﻿USE sofia;
DROP TABLE IF EXISTS sofia.deu1951_vpl;
CREATE TABLE deu1951_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES deu1951_vpl WRITE;
INSERT INTO deu1951_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Im Anfang schuf Gott den Himmel und die Erde. ");
INSERT INTO deu1951_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Und die Erde war wüst und leer, und es lag Finsternis auf der Tiefe, und der Geist Gottes schwebte über den Wassern. ");
INSERT INTO deu1951_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Und Gott sprach: Es werde Licht! Und es ward Licht. ");
INSERT INTO deu1951_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Und Gott sah, daß das Licht gut war; da schied Gott das Licht von der Finsternis; ");
INSERT INTO deu1951_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","und Gott nannte das Licht Tag, und die Finsternis Nacht. Und es ward Abend, und es ward Morgen: der erste Tag. ");
INSERT INTO deu1951_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Und Gott sprach: Es soll eine Feste entstehen inmitten der Wasser, die bilde eine Scheidewand zwischen den Gewässern! ");
INSERT INTO deu1951_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Und Gott machte die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste, daß es so ward. ");
INSERT INTO deu1951_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Und Gott nannte die Feste Himmel. Und es ward Abend, und es ward Morgen: der zweite Tag. ");
INSERT INTO deu1951_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Und Gott sprach: Es sammle sich das Wasser unter dem Himmel an einen Ort, daß man das Trockene sehe! Und es geschah also. ");
INSERT INTO deu1951_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Und Gott nannte das Trockene Land; aber die Sammlung der Wasser nannte er Meer. Und Gott sah, daß es gut war. ");
INSERT INTO deu1951_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Und Gott sprach: Es lasse die Erde grünes Gras sprossen und Gewächs, das Samen trägt, fruchtbare Bäume, deren jeder seine besondere Art Früchte bringt, in welcher ihr Same sei auf Erden! Und es geschah also. ");
INSERT INTO deu1951_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Und die Erde brachte hervor Gras und Gewächs, das Samen trägt nach seiner Art, und Bäume, welche Früchte bringen, in welchen ihr Same ist nach ihrer Art. Und Gott sah, daß es gut war. ");
INSERT INTO deu1951_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Und es ward Abend, und es ward Morgen: der dritte Tag. ");
INSERT INTO deu1951_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Und Gott sprach: Es seien Lichter an der Himmelsfeste, zur Unterscheidung von Tag und Nacht, die sollen zur Bestimmung der Zeiten und der Tage und Jahre dienen, ");
INSERT INTO deu1951_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","und zu Leuchtern an der Himmelsfeste, daß sie die Erde beleuchten! Und es geschah also. ");
INSERT INTO deu1951_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Und Gott machte die zwei großen Lichter, das große Licht zur Beherrschung des Tages und das kleinere Licht zur Beherrschung der Nacht; dazu die Sterne. ");
INSERT INTO deu1951_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Und Gott setzte sie an die Himmelsfeste, damit sie die Erde beleuchteten ");
INSERT INTO deu1951_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","und den Tag und die Nacht beherrschten und Licht und Finsternis unterschieden. Und Gott sah, daß es gut war. ");
INSERT INTO deu1951_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Und es ward Abend, und es ward Morgen: der vierte Tag. ");
INSERT INTO deu1951_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Und Gott sprach: Das Wasser soll wimmeln von einer Fülle lebendiger Wesen, und es sollen Vögel fliegen über die Erde, an der Himmelsfeste dahin! ");
INSERT INTO deu1951_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Und Gott schuf die großen Fische und alles, was da lebt und webt, wovon das Wasser wimmelt, nach ihren Gattungen, dazu allerlei Vögel nach ihren Gattungen. Und Gott sah, daß es gut war. ");
INSERT INTO deu1951_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Und Gott segnete sie und sprach: Seid fruchtbar und mehret euch und füllet das Wasser im Meere, und das Geflügel mehre sich auf Erden! ");
INSERT INTO deu1951_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Und es ward Abend, und es ward Morgen: der fünfte Tag. ");
INSERT INTO deu1951_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Und Gott sprach: Die Erde bringe hervor lebendige Wesen nach ihrer Art, Vieh, Gewürm und Tiere des Feldes nach ihrer Art! Und es geschah also. ");
INSERT INTO deu1951_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Und Gott machte die Tiere des Feldes nach ihrer Art und das Vieh nach seiner Art. Und Gott sah, daß es gut war. ");
INSERT INTO deu1951_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Und Gott sprach: Wir wollen Menschen machen nach unserm Bild uns ähnlich; die sollen herrschen über die Fische im Meer und über die Vögel des Himmels und über das Vieh auf der ganzen Erde, auch über alles, was auf Erden kriecht! ");
INSERT INTO deu1951_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Und Gott schuf den Menschen ihm zum Bilde, zum Bilde Gottes schuf er ihn; männlich und weiblich schuf er sie. ");
INSERT INTO deu1951_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Und Gott segnete sie und sprach zu ihnen: Seid fruchtbar und mehret euch und füllet die Erde und machet sie euch untertan und herrschet über die Fische im Meer und über die Vögel des Himmels und über alles Lebendige, was auf Erden kriecht! ");
INSERT INTO deu1951_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Und Gott sprach: Siehe, ich habe euch alles Gewächs auf Erden gegeben, das Samen trägt, auch alle Bäume, an welchen Früchte sind, die Samen tragen; sie sollen euch zur Nahrung dienen; ");
INSERT INTO deu1951_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","aber allen Tieren der Erde und allen Vögeln des Himmels und allem, was auf Erden kriecht, allem, was eine lebendige Seele hat, habe ich alles grüne Kraut zur Nahrung gegeben. Und es geschah also. ");
INSERT INTO deu1951_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Und Gott sah an alles, was er gemacht hatte, und siehe, es war sehr gut. Und es ward Abend, und es ward Morgen: der sechste Tag. ");
INSERT INTO deu1951_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Also waren Himmel und Erde vollendet samt ihrem ganzen Heer, ");
INSERT INTO deu1951_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","so daß Gott am siebenten Tage sein Werk vollendet hatte, das er gemacht; und er ruhte am siebenten Tage von allen seinen Werken, die er gemacht hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Und Gott segnete den siebenten Tag und heiligte ihn, denn an demselbigen ruhte er von all seinem Werk, das Gott schuf, als er es machte. ");
INSERT INTO deu1951_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Dies ist die Entstehung des Himmels und der Erde, zur Zeit, als Gott der HERR Himmel und Erde schuf. ");
INSERT INTO deu1951_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Es war aber noch kein Strauch des Feldes auf Erden, noch irgend ein grünes Kraut auf dem Felde gewachsen; denn Gott der HERR hatte noch nicht regnen lassen auf Erden, und es war kein Mensch vorhanden, um das Land zu bebauen. ");
INSERT INTO deu1951_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Aber ein Dunst stieg auf von der Erde und befeuchtete die ganze Erdoberfläche. ");
INSERT INTO deu1951_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Da bildete Gott der HERR den Menschen, Staub von der Erde, und blies den Odem des Lebens in seine Nase, und also ward der Mensch eine lebendige Seele. ");
INSERT INTO deu1951_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Und Gott der HERR pflanzte einen Garten in Eden gegen Morgen und setzte den Menschen darein, den er gemacht hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Und Gott der HERR ließ allerlei Bäume aus der Erde hervorsprossen, lieblich anzusehen und gut zur Nahrung, und den Baum des Lebens mitten im Garten und den Baum der Erkenntnis des Guten und Bösen. ");
INSERT INTO deu1951_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Und ein Strom ging aus von Eden, zu wässern den Garten; von dort aber teilte er sich und ward zu vier Hauptströmen. ");
INSERT INTO deu1951_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Der erste heißt Pison; das ist der, welcher das ganze Land Chavila umfließt, woselbst das Gold ist; ");
INSERT INTO deu1951_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","und das Gold desselbigen Landes ist gut; dort kommt auch das Bedolach vor und der Edelstein Schoham. ");
INSERT INTO deu1951_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Der zweite Strom heißt Gichon; das ist der, welcher das ganze Land Kusch umfließt. ");
INSERT INTO deu1951_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Der dritte Strom heißt Hidekel; das ist der, welcher östlich von Assur fließt. Der vierte Strom ist der Euphrat. ");
INSERT INTO deu1951_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Und Gott der HERR nahm den Menschen und setzte ihn in den Garten Eden, daß er ihn bauete und bewahrete. ");
INSERT INTO deu1951_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Und Gott der HERR gebot dem Menschen und sprach: Du sollst essen von allen Bäumen des Gartens; ");
INSERT INTO deu1951_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","aber von dem Baum der Erkenntnis des Guten und des Bösen sollst du nicht essen; denn welchen Tages du davon issest, mußt du unbedingt sterben! ");
INSERT INTO deu1951_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Und Gott der HERR sprach: Es ist nicht gut, daß der Mensch allein sei; ich will ihm eine Gehilfin machen, die ihm entspricht! ");
INSERT INTO deu1951_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Und Gott der HERR bildete aus Erde alle Tiere des Feldes und alle Vögel des Himmels und brachte sie zu dem Menschen, daß er sähe, wie er sie nennen würde, und damit jedes lebendige Wesen den Namen trage, den der Mensch ihm gäbe. ");
INSERT INTO deu1951_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Da gab der Mensch einem jeglichen Vieh und Vogel und allen Tieren des Feldes Namen; aber für den Menschen fand sich keine Gehilfin, die ihm entsprochen hätte. ");
INSERT INTO deu1951_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Da ließ Gott der HERR einen tiefen Schlaf auf den Menschen fallen; und während er schlief, nahm er eine seiner Rippen und verschloß deren Stelle mit Fleisch. ");
INSERT INTO deu1951_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Und Gott der HERR baute aus der Rippe, die er von dem Menschen genommen hatte, ein Weib und brachte sie zu ihm. ");
INSERT INTO deu1951_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Da sprach der Mensch: Das ist nun einmal Bein von meinem Bein und Fleisch von meinem Fleisch! Die soll Männin heißen; denn sie ist dem Mann entnommen! ");
INSERT INTO deu1951_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Darum wird der Mensch seinen Vater und seine Mutter verlassen und seinem Weibe anhangen, daß sie zu einem Fleische werden. ");
INSERT INTO deu1951_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Und sie waren beide nackt, der Mensch und sein Weib, und schämten sich nicht. ");
INSERT INTO deu1951_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Aber die Schlange war listiger als alle Tiere des Feldes, die Gott der HERR gemacht hatte; und sie sprach zum Weibe: Hat Gott wirklich gesagt, ihr dürft nicht essen von jedem Baum im Garten? ");
INSERT INTO deu1951_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Da sprach das Weib zur Schlange: Wir essen von der Frucht der Bäume im Garten; ");
INSERT INTO deu1951_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","aber von der Frucht des Baumes mitten im Garten hat Gott gesagt: Esset nicht davon und rührt sie auch nicht an, damit ihr nicht sterbet! ");
INSERT INTO deu1951_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Da sprach die Schlange zum Weibe: Ihr werdet sicherlich nicht sterben! ");
INSERT INTO deu1951_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Sondern Gott weiß: welchen Tages ihr davon esset, werden eure Augen aufgetan und ihr werdet sein wie Gott und wissen, was gut und böse ist. ");
INSERT INTO deu1951_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Als nun das Weib sah, daß von dem Baume gut zu essen wäre und daß er eine Lust für die Augen und ein wertvoller Baum wäre, weil er klug machte, da nahm sie von dessen Frucht und aß und gab zugleich auch ihrem Mann davon, und er aß. ");
INSERT INTO deu1951_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Da wurden ihrer beider Augen aufgetan, und sie wurden gewahr, daß sie nackt waren; und sie banden Feigenblätter um und machten sich Schürzen. ");
INSERT INTO deu1951_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Und sie hörten die Stimme Gottes, des HERRN, der im Garten wandelte beim Wehen des Abendwindes; und der Mensch und sein Weib versteckten sich vor dem Angesicht Gottes des HERRN hinter die Bäume des Gartens. ");
INSERT INTO deu1951_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Da rief Gott der HERR dem Menschen und sprach: Wo bist du? ");
INSERT INTO deu1951_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Er sprach: Ich hörte deine Stimme im Garten und fürchtete mich; denn ich bin nackt, darum verbarg ich mich! ");
INSERT INTO deu1951_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Da sprach er: Wer hat dir gesagt, daß du nackt bist? Hast du etwa von dem Baum gegessen, davon ich dir gebot, du sollest nicht davon essen? ");
INSERT INTO deu1951_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Da sprach der Mensch: Das Weib, das du mir zugesellt hast, die gab mir von dem Baum, und ich aß! ");
INSERT INTO deu1951_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Da sprach Gott der HERR zum Weibe: Warum hast du das getan? Das Weib antwortete: Die Schlange verführte mich, daß ich aß! ");
INSERT INTO deu1951_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Da sprach Gott der HERR zur Schlange: Weil du solches getan hast, so seist du verflucht vor allem Vieh und vor allen Tieren des Feldes! Auf deinem Bauch sollst du kriechen und Erde essen dein Leben lang! ");
INSERT INTO deu1951_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Und ich will Feindschaft setzen zwischen dir und dem Weibe, zwischen deinem Samen und ihrem Samen; derselbe soll dir den Kopf zertreten, und du wirst ihn in die Ferse stechen. ");
INSERT INTO deu1951_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Und zum Weibe sprach er: Ich will dir viele Schmerzen durch häufige Empfängnis bereiten; mit Schmerzen sollst du Kinder gebären; und du sollst nach deinem Manne verlangen, er aber soll herrschen über dich! ");
INSERT INTO deu1951_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Und zu Adam sprach er: Dieweil du gehorcht hast der Stimme deines Weibes und von dem Baum gegessen, davon ich dir gebot und sprach: «Du sollst nicht davon essen», verflucht sei der Erdboden um deinetwillen, mit Mühe sollst du dich davon nähren dein Leben lang; ");
INSERT INTO deu1951_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Dornen und Disteln soll er dir tragen, und du sollst das Gewächs des Feldes essen. ");
INSERT INTO deu1951_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Im Schweiße deines Angesichtes sollst du dein Brot essen, bis daß du wieder zur Erde kehrst, von der du genommen bist; denn du bist Staub und kehrst wieder zum Staub zurück! ");
INSERT INTO deu1951_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Und Adam nannte sein Weib Eva; denn sie wurde die Mutter aller Lebendigen. ");
INSERT INTO deu1951_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Und Gott der HERR machte Adam und seinem Weibe Pelzröcke und bekleidete sie. ");
INSERT INTO deu1951_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Und Gott der HERR sprach: Siehe, der Mensch ist geworden wie unsereiner, insofern er weiß, was gut und böse ist; nun soll er nicht auch noch seine Hand ausstrecken und vom Baume des Lebens nehmen und essen und ewiglich leben! ");
INSERT INTO deu1951_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Deswegen schickte ihn Gott der HERR aus dem Garten Eden, damit er den Erdboden bearbeite, von dem er genommen war. ");
INSERT INTO deu1951_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Und er vertrieb den Menschen und ließ östlich vom Garten Eden die Cherubim lagern mit dem gezückten flammenden Schwert, zu bewahren den Weg zum Baume des Lebens. ");
INSERT INTO deu1951_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Und Adam erkannte sein Weib Eva; sie aber empfing und gebar den Kain. Und sie sprach: Ich habe einen Mann bekommen mit der Hilfe des HERRN! ");
INSERT INTO deu1951_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Und weiter gebar sie seinen Bruder Abel. Und Abel ward ein Schäfer, Kain aber ein Ackersmann. ");
INSERT INTO deu1951_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Es begab sich aber nach Verfluß von Jahren, daß Kain dem HERRN ein Opfer brachte von den Früchten der Erde. ");
INSERT INTO deu1951_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Und Abel, auch er brachte dar von den Erstgebornen seiner Schafe und von ihren Fettesten. ");
INSERT INTO deu1951_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Und der HERR sah an Abel und sein Opfer; aber Kain und sein Opfer sah er gar nicht an. Da ergrimmte Kain sehr und ließ den Kopf hängen. ");
INSERT INTO deu1951_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Da sprach der HERR zu Kain: Warum bist du so zornig und lässest den Kopf hängen? Ist's nicht also: Wenn du gut bist, so darfst du dein Haupt erheben? ");
INSERT INTO deu1951_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bist du aber nicht gut, so lauert die Sünde vor der Tür, und ihre Begierde ist auf dich gerichtet; du aber herrsche über sie! ");
INSERT INTO deu1951_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Da redete Kain mit seinem Bruder Abel. Es begab sich aber, als sie auf dem Felde waren, da erhob sich Kain wider seinen Bruder Abel und schlug ihn tot. ");
INSERT INTO deu1951_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Da sprach der HERR zu Kain: Wo ist dein Bruder Abel? Er sprach: Ich weiß es nicht! Soll ich meines Bruders Hüter sein? ");
INSERT INTO deu1951_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Er aber sprach: Was hast du getan? Die Stimme des Blutes deines Bruders schreit zu mir von der Erde! ");
INSERT INTO deu1951_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Und nun sollst du verbannt sein aus dem Land, das seinen Mund aufgetan hat, das Blut deines Bruders zu empfangen von deiner Hand! ");
INSERT INTO deu1951_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wenn du das Land bebaust, soll es dir fortan sein Vermögen nicht mehr geben; unstät und flüchtig sollst du sein auf Erden! ");
INSERT INTO deu1951_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain sprach zum HERRN: Meine Schuld ist zu groß zum Tragen! ");
INSERT INTO deu1951_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Siehe, du treibst mich heute aus dem Lande, und ich muß mich vor deinem Angesicht verbergen und unstät und flüchtig sein auf Erden. Und es wird geschehen, daß mich totschlägt, wer mich findet. ");
INSERT INTO deu1951_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Da sprach der HERR: Fürwahr, wer Kain totschlägt, zieht sich siebenfache Rache zu! Und der Herr gab dem Kain ein Zeichen, daß ihn niemand erschlüge, der ihn fände. ");
INSERT INTO deu1951_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Und Kain ging aus von dem Angesicht des HERRN und wohnte im Lande Nod, östlich von Eden. ");
INSERT INTO deu1951_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Und Kain erkannte sein Weib; die empfing und gebar den Hanoch. Und da er eben eine Stadt baute, so nannte er sie nach seines Sohnes Namen Hanoch. ");
INSERT INTO deu1951_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Dem Hanoch aber ward Irad geboren, und Irad zeugte Mehujael; Mehujael zeugte Metusael, Metusael zeugte Lamech. ");
INSERT INTO deu1951_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech aber nahm sich zwei Weiber: die eine hieß Ada, die andere Zilla. ");
INSERT INTO deu1951_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Und Ada gebar Jabal; derselbe wurde der Vater der Zeltbewohner und Herdenbesitzer. ");
INSERT INTO deu1951_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Und sein Bruder hieß Jubal; derselbe wurde der Vater aller Harfen und Flötenspieler. ");
INSERT INTO deu1951_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Und Zilla, auch sie gebar den Tubal-Kain, den Meister in allerlei Erz und Eisenwerk. Und die Schwester Tubal-Kains war Naama. ");
INSERT INTO deu1951_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Und Lamech sprach zu seinen Weibern: «Ada und Zilla, hört meine Stimme, ihr Weiber Lamechs, vernehmt meinen Spruch! Einen Mann erschlug ich, weil er mich verwundet, einen Jüngling, weil er mich geschlagen hat; ");
INSERT INTO deu1951_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","denn Kain soll siebenfach gerächt werden, Lamech aber siebenundsiebzigfach!» ");
INSERT INTO deu1951_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Und Adam erkannte sein Weib abermal; die gebar einen Sohn und nannte ihn Seth; denn Gott hat mir für Abel einen andern Samen gesetzt, weil Kain ihn umgebracht hat. ");
INSERT INTO deu1951_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Und auch dem Seth ward ein Sohn geboren, den hieß er Enosch. Damals fing man an, den Namen des HERRN anzurufen. ");
INSERT INTO deu1951_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dies ist das Buch von Adams Geschlecht: Am Tage, da Gott den Menschen schuf, machte er ihn Gott ähnlich; ");
INSERT INTO deu1951_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","männlich und weiblich schuf er sie und segnete sie und nannte ihren Namen Adam, am Tage, da er sie schuf. ");
INSERT INTO deu1951_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Und Adam war 130 Jahre alt, als er einen Sohn zeugte, ihm selbst gleich, nach seinem Bilde, und nannte ihn Seth. ");
INSERT INTO deu1951_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Und nachdem er den Seth gezeugt, lebte Adam noch 800 Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1951_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","also daß Adams ganzes Alter 930 Jahre betrug, als er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth war 105 Jahre alt, als er den Enosch zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","und Seth, nachdem er den Enosch gezeugt, lebte 807 Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1951_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","also daß Seths ganzes Alter 912 Jahre betrug, als er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosch war 90 Jahre alt, als er den Kenan zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","und Enosch, nachdem er den Kenan gezeugt, lebte 815 Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1951_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","also daß Enoschs ganzes Alter 905 Jahre betrug, als er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan war 70 Jahre alt, als er den Mahalaleel zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","und Kenan, nachdem er den Mahalaleel gezeugt, lebte 840 Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1951_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","also daß Kenans ganzes Alter 910 Jahre betrug, da er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel war 65 Jahre alt, als er den Jared zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","und Mahalaleel, nachdem er den Jared gezeugt, lebte 830 Jahre und hat Söhne und Töchter gezeugt; ");
INSERT INTO deu1951_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","also daß Mahalaleels ganzes Alter 895 Jahre betrug, als er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared war 162 Jahre alt, als er den Henoch zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","und Jared, nachdem er den Henoch gezeugt, lebte 800 Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1951_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","also daß Jareds ganzes Alter 962 Jahre betrug, da er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henoch war 65 Jahre alt, als er den Methusalah zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","und Henoch, nachdem er den Methusalah gezeugt, wandelte er mit Gott 300 Jahre lang und zeugte Söhne und Töchter; ");
INSERT INTO deu1951_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","also daß Henochs ganzes Alter 365 Jahre betrug. ");
INSERT INTO deu1951_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Und Henoch wandelte mit Gott und war nicht mehr, weil Gott ihn zu sich genommen hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methusalah war 187 Jahre alt, als er den Lamech zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","und Methusalah, nachdem er den Lamech gezeugt, lebte 782 Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1951_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","also daß Methusalahs ganzes Alter 969 Jahre betrug, da er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamech war 182 Jahre alt, als er einen Sohn zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","den nannte er Noah, indem er sprach: Der wird uns trösten ob unserer Hände Arbeit und Mühe, die herrührt von dem Erdboden, den der HERR verflucht hat! ");
INSERT INTO deu1951_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Und Lamech, nachdem er den Noah gezeugt, lebte 590 Jahre lang und zeugte Söhne und Töchter; ");
INSERT INTO deu1951_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","also daß Lamechs ganzes Alter 772 Jahre betrug, da er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Und Noah war 500 Jahre alt, da er den Sem, Ham und Japhet zeugte. ");
INSERT INTO deu1951_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Als sich aber die Menschen zu mehren begannen auf Erden und ihnen Töchter geboren wurden, ");
INSERT INTO deu1951_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","sahen die Söhne Gottes, daß die Töchter der Menschen schön waren und nahmen sich von allen diejenigen zu Weibern, welche ihnen gefielen. ");
INSERT INTO deu1951_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Da sprach der HERR: Mein Geist soll den Menschen nicht ewig darum strafen, daß auch er Fleisch ist, sondern seine Tage sollen hundertundzwanzig Jahre betragen! ");
INSERT INTO deu1951_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Die Riesen waren auf Erden in jenen Tagen, und zwar daraufhin, daß die Söhne Gottes zu den Töchtern der Menschen kamen und diese ihnen gebaren. Das sind die Helden, die von alters her berühmt gewesen sind. ");
INSERT INTO deu1951_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Als aber der HERR sah, daß des Menschen Bosheit sehr groß war auf Erden und alles Gebilde der Gedanken seines Herzens nur böse allezeit, ");
INSERT INTO deu1951_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","da reute es den HERRN, daß er den Menschen gemacht hatte auf Erden, und es bekümmerte ihn in seinem Herzen. ");
INSERT INTO deu1951_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Und der HERR sprach: Ich will den Menschen, den ich erschaffen habe, vom Erdboden vertilgen, vom Menschen an bis auf das Vieh und bis auf das Gewürm und bis auf die Vögel des Himmels; denn es reut mich, daß ich sie gemacht habe! ");
INSERT INTO deu1951_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noah aber fand Gnade vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dies ist die Geschichte Noahs: Noah, ein gerechter Mann, war untadelig unter seinen Zeitgenossen; mit Gott wandelte Noah. ");
INSERT INTO deu1951_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Und Noah hatte drei Söhne gezeugt: Sem, Ham und Japhet. ");
INSERT INTO deu1951_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Aber die Erde war verderbt vor Gott und mit Frevel erfüllt. ");
INSERT INTO deu1951_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Und Gott sah die Erde, und siehe, sie war verderbt; denn alles Fleisch hatte seinen Weg auf Erden verderbt. ");
INSERT INTO deu1951_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Da sprach Gott zu Noah: Alles Fleisches Ende ist vor mich gekommen; denn die Erde ist durch sie mit Frevel erfüllt, und siehe, ich will sie samt der Erde vertilgen. ");
INSERT INTO deu1951_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Mache dir eine Arche von Tannenholz; in Räume sollst du die Arche teilen und sie innen und außen mit Pech verpichen. ");
INSERT INTO deu1951_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Und du sollst sie also machen: Dreihundert Ellen lang, fünfzig Ellen breit, dreißig Ellen hoch. ");
INSERT INTO deu1951_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ein Fenster sollst du der Arche machen; bis zu einer Elle unterhalb des Daches darf es reichen; aber die Tür der Arche sollst du an ihre Seite setzen. Du sollst ihr ein unterstes, mittleres und oberstes Stockwerk machen. ");
INSERT INTO deu1951_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Denn siehe, ich will eine Wasserflut über die Erde bringen, um alles Fleisch, das lebendigen Odem in sich hat, unter dem ganzen Himmel zu vertilgen; alles, was auf Erden ist, soll untergehen. ");
INSERT INTO deu1951_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aber mit dir will ich meinen Bund aufrichten, und du sollst in die Arche gehen, du und deine Söhne und dein Weib und deiner Söhne Weiber mit dir. ");
INSERT INTO deu1951_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Und von allem, was da lebt, von allem Fleisch, sollst du je zwei in die Arche führen, daß sie mit dir am Leben bleiben, und zwar sollen es ein Männchen und ein Weibchen sein; ");
INSERT INTO deu1951_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","aller Art Vögel und aller Art Vieh und von allem, was auf Erden kriecht, sollen je zwei von jeder Art zu dir kommen, damit sie am Leben bleiben. ");
INSERT INTO deu1951_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Du aber nimm dir von allerlei Speise, die man zu essen pflegt, und sammle sie bei dir an, daß sie dir und ihnen zur Nahrung diene! ");
INSERT INTO deu1951_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Und Noah tat es; er machte alles genau so, wie ihm Gott befahl. ");
INSERT INTO deu1951_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Und der HERR sprach zu Noah: Geh in die Arche, du und dein ganzes Haus! Denn dich habe ich gerecht ersehen unter diesem Geschlecht. ");
INSERT INTO deu1951_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Nimm von allem reinen Vieh zu dir je sieben und sieben, das Männchen und sein Weibchen; von dem unreinen Vieh aber je ein Paar, das Männchen und sein Weibchen; ");
INSERT INTO deu1951_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","auch von den Vögeln des Himmels je sieben und sieben, Männchen und Weibchen, um auf dem ganzen Erdboden Samen am Leben zu erhalten. ");
INSERT INTO deu1951_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Denn es sind nur noch sieben Tage, so will ich auf Erden regnen lassen vierzig Tage lang und alles Bestehende von dem Erdboden vertilgen. ");
INSERT INTO deu1951_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Und Noah machte alles, wie ihm der HERR gebot. ");
INSERT INTO deu1951_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Und Noah war sechshundert Jahre alt, da die Wasser der Sündflut auf die Erde kamen. ");
INSERT INTO deu1951_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Er ging aber samt seinen Söhnen, seinem Weib und seiner Söhne Weibern in die Arche vor dem Gewässer der Sündflut. ");
INSERT INTO deu1951_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Von dem reinen Vieh und von dem Vieh, das nicht rein war, und von den Vögeln und von allem, was auf der Erde kriecht, ");
INSERT INTO deu1951_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","gingen paarweise in die Arche, Männchen und Weibchen, wie Gott dem Noah geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Und es begab sich nach den sieben Tagen, daß die Wasser der Sündflut auf die Erde kamen. ");
INSERT INTO deu1951_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Im sechshundertsten Lebensjahre Noahs, am siebzehnten Tage des zweiten Monats, an dem Tage brachen alle Quellen der großen Tiefe auf, und die Fenster des Himmels öffneten sich. ");
INSERT INTO deu1951_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Und es regnete auf die Erde vierzig Tage und vierzig Nächte lang. ");
INSERT INTO deu1951_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","An ebendemselben Tage war Noah in die Arche gegangen mit Sem, Ham und Japhet, seinen Söhnen, und seinem Weibe und den drei Weibern seiner Söhne; ");
INSERT INTO deu1951_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","sie und alle Arten der Tiere und des Viehs und allerlei Kriechendes, was auf Erden kriecht, von jeglicher Art, auch aller Art Geflügel, Vögel und Federvieh; ");
INSERT INTO deu1951_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","die kamen zu Noah in die Arche, je zwei und zwei, von allem Fleisch, das lebendigen Odem in sich hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Und die hineingingen, Männchen und Weibchen von allem Fleisch, kamen herbei, wie Gott ihm geboten hatte; und der HERR schloß hinter ihm zu. ");
INSERT INTO deu1951_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Da sich aber die Sündflut vierzig Tage auf die Erde ergoß, wuchsen die Wasser und hoben die Arche, daß sie über der Erde schwebte. ");
INSERT INTO deu1951_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Und die Wasser wurden so groß und nahmen so sehr zu, daß die Arche auf dem Wasserspiegel dahinfuhr. ");
INSERT INTO deu1951_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ja, das Gewässer nahm so sehr überhand, daß alle hohen Berge unter dem ganzen Himmel bedeckt wurden; ");
INSERT INTO deu1951_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","fünfzehn Ellen höher stieg das Wasser, nachdem die Berge schon zugedeckt waren. ");
INSERT INTO deu1951_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Da ging alles Fleisch zugrunde, das auf Erden sich bewegte, Vögel, Vieh und wilde Tiere und alles, was sich auf Erden regte, samt allen Menschen; ");
INSERT INTO deu1951_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","und es starb alles, was auf dem trockenen Lande einen lebendigen Odem in der Nase hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Er vertilgte alles Bestehende auf dem Erdboden, vom Menschen an bis auf das Vieh, bis auf das Kriechende und bis auf die Vögel des Himmels; es ward alles von der Erde vertilgt; nur Noah blieb übrig und was mit ihm in der Arche war. ");
INSERT INTO deu1951_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Und das Wasser blieb hoch über der Erde, hundertundfünfzig Tage lang. ");
INSERT INTO deu1951_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Da gedachte Gott an Noah und an alle Tiere und an alles Vieh, das bei ihm in der Arche war; und Gott ließ einen Wind über die Erde wehen, daß die Wasser fielen. ");
INSERT INTO deu1951_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Und die Brunnen der Tiefe wurden verstopft samt den Fenstern des Himmels, und dem Regen vom Himmel ward gewehrt. ");
INSERT INTO deu1951_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Und die Wasser über der Erde nahmen mehr und mehr ab, so daß sie nach hundertundfünfzig Tagen sich vermindert hatten. ");
INSERT INTO deu1951_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Und die Arche ließ sich am siebzehnten Tage des siebenten Monats auf dem Gebirge Ararat nieder. ");
INSERT INTO deu1951_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Und das Gewässer nahm immerfort ab bis zum zehnten Monat; am ersten Tage des zehnten Monats konnte man die Spitzen der Berge sehen. ");
INSERT INTO deu1951_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Und es geschah nach Verfluß von vierzig Tagen, daß Noah das Fenster öffnete an der Arche, das er gemacht hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Und er sandte den Raben aus; der flog hin und her, bis das Wasser auf Erden vertrocknet war. ");
INSERT INTO deu1951_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Darnach sandte er die Taube aus, daß er sähe, ob des Wassers auf Erden weniger geworden wäre. ");
INSERT INTO deu1951_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Aber die Taube fand keinen Ort, da ihr Fuß ruhen konnte. Da kehrte sie zu ihm zur Arche zurück; denn es war noch Wasser auf der ganzen Erdoberfläche. Da streckte er seine Hand aus und ergriff sie und nahm sie wieder zu sich in die Arche. ");
INSERT INTO deu1951_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Und er wartete noch weitere sieben Tage; dann sandte er die Taube wieder von der Arche aus. ");
INSERT INTO deu1951_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Und die Taube kam zur Abendzeit wieder zu ihm und siehe, sie hatte ein frisches Ölblatt in ihrem Schnabel! Da merkte Noah, daß des Wassers auf Erden weniger geworden war. ");
INSERT INTO deu1951_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Und nachdem er noch weitere sieben Tage gewartet hatte, sandte er die Taube wieder aus; da kam sie nicht mehr zu ihm zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Im sechshundertundersten Jahre, am ersten Tage des ersten Monats, waren die Wasser auf Erden vertrocknet. Und Noah entfernte das Dach von der Arche und schaute, und siehe, der Erdboden war trocken! ");
INSERT INTO deu1951_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Und im zweiten Monat, am siebenundzwanzigsten Tage des Monats, war die Erde ausgetrocknet. ");
INSERT INTO deu1951_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Da redete Gott zu Noah und sprach: ");
INSERT INTO deu1951_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Geh aus der Arche, du und dein Weib und deine Söhne und deiner Söhne Weiber mit dir! ");
INSERT INTO deu1951_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Alle Tiere, die bei dir sind, von allem Fleisch: Vögel, Vieh und alles Kriechende, was auf Erden kriecht, sollen mit dir hinausgehen und sich regen auf Erden und sollen fruchtbar sein und sich mehren auf Erden! ");
INSERT INTO deu1951_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Also ging Noah hinaus samt seinen Söhnen und seinem Weib und seiner Söhne Weibern. ");
INSERT INTO deu1951_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Alle Tiere, alles, was kriecht und fliegt, alles, was sich auf Erden regt, nach seinen Gattungen, das verließ die Arche. ");
INSERT INTO deu1951_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah aber baute dem HERRN einen Altar und nahm von allerlei reinem Vieh und von allerlei reinem Geflügel und opferte Brandopfer auf dem Altar. ");
INSERT INTO deu1951_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Und der HERR roch den befriedigenden Geruch, und der HERR sprach zu seinem Herzen: Ich will fortan die Erde nicht mehr verfluchen um des Menschen willen, wiewohl das Dichten des menschlichen Herzens böse ist von seiner Jugend an; auch will ich fortan nicht mehr alles Lebendige schlagen, wie ich getan habe. ");
INSERT INTO deu1951_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Solange die Erde steht, soll nicht aufhören Saat und Ernte, Frost und Hitze, Sommer und Winter, Tag und Nacht! ");
INSERT INTO deu1951_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Und Gott segnete Noah und seine Söhne und sprach zu ihnen: Seid fruchtbar und mehret euch und erfüllet die Erde! ");
INSERT INTO deu1951_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Furcht und Schrecken vor euch soll kommen über alle Tiere der Erde und über alle Vögel des Himmels, über alles, was auf Erden kriecht, und über alle Fische im Meer; in eure Hände seien sie gegeben! ");
INSERT INTO deu1951_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Alles, was sich regt und lebt, soll euch zur Nahrung dienen; wie das grüne Kraut habe ich es euch alles gegeben. ");
INSERT INTO deu1951_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nur esset das Fleisch nicht, während seine Seele, sein Blut, noch in ihm ist! ");
INSERT INTO deu1951_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Für euer Blut aber, für eure Seelen, will ich Rechenschaft fordern, von der Hand aller Tiere will ich sie fordern und von des Menschen Hand, von seines Bruders Hand will ich des Menschen Seele fordern. ");
INSERT INTO deu1951_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wer Menschenblut vergießt, des Blut soll auch durch Menschen vergossen werden; denn Gott hat den Menschen nach seinem Bild gemacht. ");
INSERT INTO deu1951_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ihr aber seid fruchtbar und mehret euch und reget euch auf Erden, daß euer viele werden darauf! ");
INSERT INTO deu1951_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Und Gott sprach zu Noah und zu seinen Söhnen mit ihm: ");
INSERT INTO deu1951_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Siehe, ich richte meinen Bund auf mit euch und mit euren Nachkommen, ");
INSERT INTO deu1951_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","auch mit allen lebendigen Wesen bei euch, mit Vögeln, Vieh und allen Tieren der Erde bei euch, mit allen, die aus der Arche gegangen sind, was für Tiere es seien auf Erden; ");
INSERT INTO deu1951_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","und zwar will ich meinen Bund mit euch dafür aufrichten, daß forthin nie mehr alles Fleisch von dem Wasser der Sündflut ausgerottet werden, und daß auch keine Sündflut mehr kommen soll, um die Erde zu verderben. ");
INSERT INTO deu1951_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Und Gott sprach: Dies ist das Zeichen des Bundes, welchen ich stifte zwischen mir und euch und allen lebendigen Wesen, die bei euch sind, auf ewige Zeiten: ");
INSERT INTO deu1951_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Meinen Bogen setze ich in die Wolken, der soll ein Zeichen des Bundes sein zwischen mir und der Erde. ");
INSERT INTO deu1951_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Wenn es nun geschieht, daß ich Wolken über der Erde sammle, und der Bogen in den Wolken erscheint, ");
INSERT INTO deu1951_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","dann will ich an meinen Bund gedenken, welcher zwischen mir und euch und allen lebendigen Wesen von allem Fleisch besteht, daß forthin die Wasser nicht mehr zur Sündflut werden sollen, die alles Fleisch verderbe. ");
INSERT INTO deu1951_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Darum soll der Bogen in den Wolken sein, daß ich ihn ansehe und gedenke an den ewigen Bund zwischen Gott und allen lebendigen Wesen von allem Fleisch, das auf Erden ist. ");
INSERT INTO deu1951_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Und Gott sprach zu Noah: Das ist das Zeichen des Bundes, welchen ich aufgerichtet habe zwischen mir und allem Fleisch, das auf Erden ist! ");
INSERT INTO deu1951_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Die drei Söhne Noahs aber, welche die Arche verließen, waren Sem, Ham und Japhet. Ham ist der Vater Kanaans. ");
INSERT INTO deu1951_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Von diesen drei Söhnen Noahs ward die ganze Erde bevölkert. ");
INSERT INTO deu1951_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah aber begann und legte als Landmann einen Weinberg an. ");
INSERT INTO deu1951_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Da er aber von dem Weine trank, ward er betrunken und entblößte sich in seiner Hütte. ");
INSERT INTO deu1951_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Da nun Ham, Kanaans Vater, die Blöße seines Vaters sah, verriet er es seinen beiden Brüdern draußen. ");
INSERT INTO deu1951_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Da nahmen Sem und Japhet das Kleid und legten es auf ihre Schultern und gingen rücklings und deckten ihres Vaters Blöße zu und wandten ihre Angesichter ab, daß sie ihres Vaters Blöße nicht sahen. ");
INSERT INTO deu1951_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Als nun Noah von dem Wein erwachte und erfuhr, was ihm sein jüngster Sohn getan, ");
INSERT INTO deu1951_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","da sprach er: Verflucht sei Kanaan! Er sei ein Knecht der Knechte seiner Brüder! ");
INSERT INTO deu1951_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Und weiter sprach er: Gepriesen sei der HERR, der Gott Sems, und Kanaan sei sein Knecht! ");
INSERT INTO deu1951_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Gott breite Japhet aus und lasse ihn wohnen in Sems Hütten, und Kanaan sei sein Knecht! ");
INSERT INTO deu1951_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noah aber lebte nach der Sündflut noch 350 Jahre lang, ");
INSERT INTO deu1951_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","also daß Noahs ganzes Alter 950 Jahre betrug, als er starb. ");
INSERT INTO deu1951_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dies ist das Geschlechtsregister der Söhne Noahs: Sem, Ham und Japhet; und nach der Sündflut wurden ihnen Kinder geboren. ");
INSERT INTO deu1951_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Die Söhne Japhets waren: Gomer, Magog, Madai, Javan, Tubal, Mesech und Tiras. ");
INSERT INTO deu1951_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Die Söhne Gomers aber: Aschkenas, Riphat und Togarma. ");
INSERT INTO deu1951_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Und die Söhne Javans: Elischa, Tarsis, Kittim und Rodanim. ");
INSERT INTO deu1951_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Sie haben sich auf die Inseln der Heiden verteilt, in ihre Länder, ein jedes nach seiner Sprache; in ihre Völkerschaften, ein jedes nach seiner Abstammung. ");
INSERT INTO deu1951_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Und dies sind die Söhne Hams: Kusch, Mizraim, Put und Kanaan. ");
INSERT INTO deu1951_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Und die Söhne Kuschs: Seba, Chavila, Sabta, Raema, Sabteka und Dedan. ");
INSERT INTO deu1951_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Auch zeugte Kusch den Nimrod; der fing an ein Gewaltiger zu sein auf Erden. ");
INSERT INTO deu1951_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Er war ein gewaltiger Jäger vor dem HERRN; daher sagt man: Ein gewaltiger Jäger vor dem HERRN wie Nimrod. ");
INSERT INTO deu1951_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Und der Anfang seines Königreiches war Babel, Erek, Akkad und Kalne im Lande Sinear. ");
INSERT INTO deu1951_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Von diesem Land zog er nach Assur aus und baute Ninive, Rechobot-Ir und Kelach, ");
INSERT INTO deu1951_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","dazu Resen, zwischen Ninive und Kelach; das ist die große Stadt. ");
INSERT INTO deu1951_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim aber zeugte die Luditer, Anamiter, Lehabiter und Naphtuchiter; ");
INSERT INTO deu1951_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","auch die Patrusiter und die Kasluchiter, von welchen die Philister und die Kaphtoriter ausgegangen sind. ");
INSERT INTO deu1951_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan aber zeugte Zidon, seinen Erstgebornen und Het; ");
INSERT INTO deu1951_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","auch die Jebusiter, Amoriter und Girgasiter; ");
INSERT INTO deu1951_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","die Heviter, Arkiter und Siniter; ");
INSERT INTO deu1951_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","die Arvaditer, Zemariter und die Chamatiter; und darnach breiteten sich die Geschlechter der Kanaaniter aus. ");
INSERT INTO deu1951_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Und der Kanaaniter Gebiet erstreckte sich von Zidon an bis dahin, wo man von Gerar nach Gaza kommt; desgleichen bis dahin, wo man von Sodom und Gomorra, Adama und Zeboim nach Lascha kommt. ");
INSERT INTO deu1951_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Das sind die Söhne Hams nach ihren Geschlechtern und Sprachen, in ihren Ländern und Völkerschaften. ");
INSERT INTO deu1951_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Auch Sem wurden Kinder geboren, ihm, dem Vater aller Söhne Ebers, Japhets älterem Bruder. ");
INSERT INTO deu1951_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sems Söhne waren Elam, Assur, Arpakschad, Lud und Aram. ");
INSERT INTO deu1951_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Und Arams Söhne: Uz, Chul, Geter und Masch. ");
INSERT INTO deu1951_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakschad aber zeugte den Schelach, und Schelach zeugte den Eber. ");
INSERT INTO deu1951_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Und dem Eber wurden zwei Söhne geboren; der eine hieß Peleg, weil in seinen Tagen das Land verteilt ward; sein Bruder aber hieß Joktan. ");
INSERT INTO deu1951_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Und Joktan zeugte Almodad, Schaleph, Chazarmavet, Jarach, ");
INSERT INTO deu1951_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO deu1951_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Scheba, ");
INSERT INTO deu1951_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Chavila und Jobad; diese alle sind Söhne Joktans. ");
INSERT INTO deu1951_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Und ihre Wohnsitze erstreckten sich von Mesa an, bis man gen Sephar kommt, zum östlichen Gebirge. ");
INSERT INTO deu1951_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Das sind die Söhne Sems nach ihren Geschlechtern und Sprachen, in ihren Ländern und Völkerschaften. ");
INSERT INTO deu1951_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Das sind die Geschlechter der Söhne Noahs nach ihrer Abstammung in ihren Völkern; und von ihnen haben sich nach der Sündflut die Völker auf der Erde verteilt. ");
INSERT INTO deu1951_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Es hatte aber die ganze Welt einerlei Sprache und einerlei Rede. ");
INSERT INTO deu1951_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Da sie nun gen Osten zogen, fanden sie eine Ebene im Lande Sinear, und sie ließen sich daselbst nieder. ");
INSERT INTO deu1951_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Und sie sprachen zueinander: Wohlan, laßt uns Ziegel streichen und sie feuerfest brennen! Und sie brauchten Ziegel für Steine und Asphalt für Kalk. ");
INSERT INTO deu1951_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Und sie sprachen: Wohlan, laßt uns eine Stadt und einen Turm bauen, dessen Spitze bis an den Himmel reicht, daß wir uns einen Namen machen, damit wir ja nicht über die ganze Erde zerstreuet werden! ");
INSERT INTO deu1951_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Da fuhr der HERR herab, daß er die Stadt und den Turm sähe, den die Menschenkinder bauten. ");
INSERT INTO deu1951_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Und der HERR sprach: Siehe, es ist nur ein einziges Volk, und sie sprechen alle nur eine Sprache, und dies ist der Anfang ihres Unternehmens! Nun wird es ihnen nicht unmöglich sein, alles auszuführen, was sie sich vorgenommen haben. ");
INSERT INTO deu1951_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wohlan, laßt uns hinabfahren und daselbst ihre Sprache verwirren, daß keiner des andern Sprache verstehe! ");
INSERT INTO deu1951_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Also zerstreute sie der HERR von dannen über die ganze Erde, daß sie aufhörten die Stadt zu bauen. ");
INSERT INTO deu1951_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Daher gab man ihr den Namen Babel, weil der HERR daselbst die Sprache der ganzen Welt verwirrte und sie von dannen über die ganze Erde zerstreute. ");
INSERT INTO deu1951_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dies ist das Geschlechtsregister Sems: Als Sem hundert Jahre alt war, zeugte er den Arpakschad, zwei Jahre nach der Flut; ");
INSERT INTO deu1951_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","und nachdem Sem den Arpakschad gezeugt, lebte er noch fünfhundert Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1951_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpakschad war fünfunddreißig Jahre alt, als er den Schelach zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","und nachdem Arpakschad den Schelach gezeugt hatte, lebte er noch 403 Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1951_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Schelach war dreißig Jahre alt, da er den Eber zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","und nachdem Schelach den Eber gezeugt hatte, lebte er noch 403 Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1951_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber war vierunddreißig Jahre alt, da er den Peleg zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","und nachdem Eber den Peleg gezeugt, lebte er noch 430 Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1951_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg war dreißig Jahre alt, da er den Regu zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","und nachdem Peleg den Regu gezeugt, lebte er noch 207 Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1951_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Regu war zweiunddreißig Jahre alt, da er den Serug zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","und nachdem Regu den Serug gezeugt, lebte er noch 207 Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1951_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug war dreißig Jahre alt, da er den Nahor zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","und nachdem Serug den Nahor gezeugt, lebte er noch 200 Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1951_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor war neunundzwanzig Jahre alt, da er den Terach zeugte; ");
INSERT INTO deu1951_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","und nachdem Nahor den Terach gezeugt, lebte er noch 119 Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1951_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terach war siebzig Jahre alt, da er den Abram, Nahor und Haran zeugte. ");
INSERT INTO deu1951_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Und dies ist Terachs Geschlechtsregister: Terach zeugte den Abram, Nahor und Haran; Haran aber zeugte den Lot. ");
INSERT INTO deu1951_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Und Haran starb vor seinem Vater Terach im Lande seiner Geburt zu Ur in Chaldäa. ");
INSERT INTO deu1951_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram aber und Nahor nahmen Weiber; Abrams Weib hieß Sarai, Nahors Weib hieß Milka, eine Tochter Harans, des Vaters der Milka und der Jisla. ");
INSERT INTO deu1951_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai aber war unfruchtbar; sie hatte kein Kind. ");
INSERT INTO deu1951_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Und Terach nahm seinen Sohn Abram, dazu den Lot, Harans Sohn, seinen Enkel, auch Sarai, seine Schwiegertochter, das Weib seines Sohnes Abram, und sie zogen miteinander aus von Ur in Chaldäa, um ins Land Kanaan zu gehen. Als sie aber nach Haran kamen, blieben sie daselbst. ");
INSERT INTO deu1951_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Und Terach ward 205 Jahre alt und starb in Haran. ");
INSERT INTO deu1951_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Und der HERR sprach zu Abram: Geh aus von deinem Land und von deiner Verwandtschaft und von deines Vaters Hause in das Land, das ich dir zeigen will! ");
INSERT INTO deu1951_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","So will ich dich zu einem großen Volke machen und dich segnen und dir einen großen Namen machen, und du sollst ein Segen sein. ");
INSERT INTO deu1951_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ich will segnen, die dich segnen, und verfluchen, die dir fluchen; und durch dich sollen alle Geschlechter auf Erden gesegnet werden! ");
INSERT INTO deu1951_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Da ging Abram, wie der HERR zu ihm gesagt hatte, und Lot ging mit ihm; Abram aber war fünfundsiebzig Jahre alt, da er von Haran auszog. ");
INSERT INTO deu1951_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Und Abram nahm sein Weib Sarai und Lot, seines Bruders Sohn, samt aller ihrer Habe, die sie erworben, und den Seelen, die sie in Haran gewonnen hatten; und sie zogen aus, um ins Land Kanaan zu gehen. ");
INSERT INTO deu1951_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Und als sie ins Land Kanaan kamen, durchzog Abram das Land bis zur Ortschaft Sichem, bis zur Eiche Mores; und damals waren die Kanaaniter im Lande. ");
INSERT INTO deu1951_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Da erschien der HERR dem Abram und sprach: Deinem Samen will ich dies Land geben! Und er baute daselbst einen Altar dem HERRN, der ihm erschienen war. ");
INSERT INTO deu1951_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Von da rückte er weiter vor aufs Gebirge, östlich von Bethel, und schlug sein Zelt also auf, daß er Bethel im Westen und Ai im Osten hatte; und er baute daselbst dem HERRN einen Altar und rief den Namen des HERRN an. ");
INSERT INTO deu1951_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Darnach brach Abram auf und zog immer weiter nach Süden. ");
INSERT INTO deu1951_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Da aber Hungersnot im Lande herrschte, reiste Abram nach Ägypten hinab, um sich daselbst aufzuhalten; denn die Hungersnot lastete auf dem Land. ");
INSERT INTO deu1951_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Und als er sich Ägypten näherte, sprach er zu seinem Weib Sarai: Siehe doch, ich weiß, daß du ein Weib bist von schöner Gestalt. ");
INSERT INTO deu1951_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wenn dich nun die Ägypter sehen, so werden sie sagen: Das ist sein Weib! Und sie werden mich töten und dich leben lassen. ");
INSERT INTO deu1951_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","So sage doch, du seiest meine Schwester, daß es mir um deinetwillen wohl gehe, und meine Seele um deinetwillen am Leben bleibe! ");
INSERT INTO deu1951_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Als nun Abram nach Ägypten kam, sahen die Ägypter das Weib, daß sie sehr schön war. ");
INSERT INTO deu1951_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Und als die Fürsten des Pharao sie sahen, priesen sie dieselbe dem Pharao an. Da ward das Weib in Pharaos Haus gebracht. ");
INSERT INTO deu1951_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Und es ging Abram gut um ihretwillen; und er bekam Schafe, Rinder und Esel, Knechte und Mägde, Eselinnen und Kamele. ");
INSERT INTO deu1951_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Aber der HERR schlug den Pharao und sein Haus mit großen Plagen um Sarais, des Weibes Abrams, willen. ");
INSERT INTO deu1951_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Da rief der Pharao den Abram und sprach: Was hast du mir da angerichtet! Warum hast du mir nicht angezeigt, daß sie dein Weib ist? ");
INSERT INTO deu1951_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Warum hast du gesagt, sie sei deine Schwester, so daß ich sie mir zum Weibe nehmen wollte? Und nun siehe, da ist dein Weib; nimm sie und geh! ");
INSERT INTO deu1951_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Und der Pharao bot seinethalben Mannschaft auf, damit sie ihm und seinem Weib und allem, was er hatte, das Geleite gäben. ");
INSERT INTO deu1951_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Und Abram zog mit seinem Weib und mit allem, was er hatte, auch mit Lot, von Ägypten hinauf in das südliche Kanaan. ");
INSERT INTO deu1951_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Und Abram war sehr reich an Vieh, Silber und Gold. ");
INSERT INTO deu1951_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Und er kam auf seinen Nomadenzügen von Süden her bis nach Bethel, bis zu dem Ort, da sein Zelt zuerst gestanden hatte, zwischen Bethel und Ai, ");
INSERT INTO deu1951_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","an die Stätte des Altars, welchen er in der ersten Zeit gemacht hatte; und Abram rief daselbst den Namen des HERRN an. ");
INSERT INTO deu1951_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Aber auch Lot, der mit Abram ging, hatte Schafe, Rinder und Zelte. ");
INSERT INTO deu1951_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Und das Land mochte es nicht ertragen, daß sie beieinander wohnten; denn ihre Habe war groß, und sie konnten nicht beieinander bleiben. ");
INSERT INTO deu1951_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Und es entstand Streit zwischen den Hirten über Abrams Vieh und den Hirten über Lots Vieh; auch wohnten zu der Zeit die Kanaaniter und Pheresiter im Lande. ");
INSERT INTO deu1951_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Da sprach Abram zu Lot: Es soll doch nicht Zank sein zwischen mir und dir, zwischen meinen Hirten und deinen Hirten! Denn wir sind Brüder. ");
INSERT INTO deu1951_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Steht dir nicht das ganze Land offen? Trenne dich von mir! Willst du zur Linken, so gehe ich zur Rechten; und willst du zur Rechten, so gehe ich zur Linken. ");
INSERT INTO deu1951_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Da hob Lot seine Augen auf und besah die ganze Jordanaue; denn sie war allenthalben bewässert, wie ein Garten des HERRN, wie Ägyptenland, bis nach Zoar hinab, ehe der HERR Sodom und Gomorra verderbte. ");
INSERT INTO deu1951_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Darum erwählte sich Lot die ganze Jordanaue und zog gegen Osten. Also trennte sich ein Bruder von dem andern. ");
INSERT INTO deu1951_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram wohnte im Lande Kanaan und Lot in den Städten der Aue und zeltete bis nach Sodom hin. ");
INSERT INTO deu1951_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Aber die Leute zu Sodom waren schlecht und sündigten sehr wider den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Der HERR aber sprach zu Abram, nachdem sich Lot von ihm getrennt hatte: Hebe doch deine Augen auf und schaue von dem Orte, da du wohnst, nach Norden, Süden, Osten und Westen! ");
INSERT INTO deu1951_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Denn das ganze Land, das du siehst, will ich dir und deinem Samen geben auf ewig. ");
INSERT INTO deu1951_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Und ich will deinen Samen machen wie den Staub auf Erden; wenn ein Mensch den Staub auf Erden zählen kann, so soll man auch deinen Samen zählen. ");
INSERT INTO deu1951_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Mache dich auf, durchziehe das Land seiner Länge und Breite nach! Denn dir will ich es geben. ");
INSERT INTO deu1951_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Da brach Abram auf, kam und wohnte bei den Eichen Mamres zu Hebron und baute daselbst dem HERRN einen Altar. ");
INSERT INTO deu1951_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Und es begab sich zur Zeit des Königs Amraphel von Sinear, Ariochs, des Königs von Ellasar, Kedor-Laomers, des Königs von Elam, und Tideals, des Königs der Gojim, ");
INSERT INTO deu1951_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","daß sie kriegeten mit Bera, dem König von Sodom, und mit Birsa, dem König von Gomorra, und mit Sinab, dem König von Adama, und mit Semeber, dem König von Zeboim, und mit dem König von Bela, das ist Zoar. ");
INSERT INTO deu1951_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Diese vereinigten sich im Tal Siddim, wo jetzt das Salzmeer ist. ");
INSERT INTO deu1951_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Sie waren zwölf Jahre lang Kedor-Laomer untertan gewesen, aber im dreizehnten Jahre fielen sie von ihm ab. ");
INSERT INTO deu1951_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Darum kamen Kedor-Laomer und die Könige, die es mit ihm hielten, im vierzehnten Jahre und schlugen die Rephaiter zu Astarot-Karnaim, und die Susiter zu Ham und die Emiter in der Ebene Kirjataim; ");
INSERT INTO deu1951_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","auch die Horiter auf ihrem Gebirge Seir, bis nach El-Paran, welches an der Wüste liegt. ");
INSERT INTO deu1951_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Darnach kehrten sie um und kamen zum Brunnen Mischpat, das ist Kadesch, und schlugen das ganze Land der Amalekiter, dazu die Amoriter, die zu Hazezon-Tamar wohnten. ");
INSERT INTO deu1951_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Da zogen aus der König von Sodom, der König von Gomorra, der König von Adama, der König von Zeboim und der König von Bela, die Zoar heißt, und rüsteten sich ");
INSERT INTO deu1951_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","zu streiten im Tal Siddim mit Kedor-Laomer, dem Könige von Elam, und mit Tideal, dem Könige der Gojim, und mit Amraphel, dem König von Sinear, und mit Arioch, dem Könige von Ellasar; vier Könige gegen fünf. ");
INSERT INTO deu1951_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Und das Tal Siddim hatte viele Asphaltgruben. Aber die Könige von Sodom und Gomorra flohen und fielen daselbst, und was übrigblieb, floh ins Gebirge. ");
INSERT INTO deu1951_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Und jene nahmen alle Habe zu Sodom und Gomorra und alle ihre Nahrung, und machten sich davon. ");
INSERT INTO deu1951_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Sie nahmen auch mit sich Lot, Abrams Bruder, und seine Habe (denn er wohnte zu Sodom) und gingen. ");
INSERT INTO deu1951_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Es kam aber ein Entronnener und sagte es Abram, dem Ebräer, der bei den Eichen Mamres, des Amoriters, wohnte, welcher ein Bruder war von Eschkol und Aner; diese waren Abrams Bundesgenossen. ");
INSERT INTO deu1951_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Als nun Abram hörte, daß sein Bruderssohn gefangen sei, bewaffnete er seine erprobten Knechte, dreihundertundachtzehn, die in seinem Hause geboren waren, und jagte jenen nach bis gen Dan, ");
INSERT INTO deu1951_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","verteilte sich und überfiel sie heimlich bei Nacht mit seinen Knechten und schlug sie und verfolgte sie bis gen Hoba, das zur Linken von Damaskus liegt. ");
INSERT INTO deu1951_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Und er brachte alle Habe wieder; auch seinen Bruderssohn Lot und dessen Habe, die Weiber und das Volk brachte er wieder. ");
INSERT INTO deu1951_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Als aber Abram von der Schlacht gegen Kedor-Laomer und die Könige, die mit ihm waren, zurückkehrte, ging ihm der König von Sodom entgegen in das Tal Schaveh, welches Königstal genannt wird. ");
INSERT INTO deu1951_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Aber Melchisedek, der König von Salem, brachte Brot und Wein herbei. Und er war ein Priester Gottes, des Allerhöchsten. ");
INSERT INTO deu1951_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Und er segnete ihn und sprach: Gesegnet sei Abram vom allerhöchsten Gott, dem Besitzer des Himmels und der Erde. ");
INSERT INTO deu1951_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Und gelobt sei Gott, der Allerhöchste, der deine Feinde in deine Hand geliefert hat! Und Abram gab ihm den Zehnten von allem. ");
INSERT INTO deu1951_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Da sprach der König von Sodom zu Abram: Gib mir die Seelen, die Habe behalte für dich! ");
INSERT INTO deu1951_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram sprach zum König von Sodom: Ich hebe meine Hand auf zu dem HERRN, dem allerhöchsten Gott, dem Besitzer des Himmels und der Erde, ");
INSERT INTO deu1951_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","daß ich von allem, was dein ist, nicht einen Faden noch Schuhriemen nehmen will, daß du nicht sagest: «Ich habe Abram reich gemacht»; ");
INSERT INTO deu1951_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ausgenommen, was die Jünglinge gegessen haben, und den Teil der Männer Aner, Eschkol und Mamre, die mit mir gezogen sind; sie sollen ihren Anteil erhalten. ");
INSERT INTO deu1951_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nach diesen Geschichten begab es sich, daß des HERRN Wort an Abram in einem Gesicht also erging: Fürchte dich nicht, Abram, ich bin dein Schild; dein Lohn ist sehr groß! ");
INSERT INTO deu1951_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram aber sprach: O Herr, HERR, was willst du mir geben, da ich doch kinderlos dahingehe, Erbe meines Hauses aber dieser Elieser von Damaskus ist? ");
INSERT INTO deu1951_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Und Abram sprach weiter: Siehe, du hast mir keinen Samen gegeben, und siehe, ein Knecht, der in meinem Hause geboren ist, soll mein Erbe sein! ");
INSERT INTO deu1951_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Aber des HERRN Wort geschah zu ihm: Dieser soll nicht dein Erbe sein, sondern der von dir selbst kommen wird, der soll dein Erbe sein! ");
INSERT INTO deu1951_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Und er führte ihn hinaus und sprach: Siehe doch gen Himmel und zähle die Sterne, wenn du sie zählen kannst! Und er sprach zu ihm: Also soll dein Same werden! ");
INSERT INTO deu1951_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Und Abram glaubte dem HERRN, und das rechnete er ihm zur Gerechtigkeit. ");
INSERT INTO deu1951_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Und er sprach zu ihm: Ich bin der HERR, der ich dich von Ur in Chaldäa ausgeführt habe, daß ich dir dieses Land erblich zu besitzen gebe. ");
INSERT INTO deu1951_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram aber sprach: Herr, HERR, wobei soll ich merken, daß ich es erblich besitzen werde? ");
INSERT INTO deu1951_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Und er sprach zu ihm: Bringe mir eine dreijährige Kuh und eine dreijährige Ziege und einen dreijährigen Widder und eine Turteltaube und eine junge Taube. ");
INSERT INTO deu1951_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Und er brachte solches alles und zerteilte es mitten voneinander, und legte einen Teil dem andern gegenüber. Aber die Vögel zerteilte er nicht. ");
INSERT INTO deu1951_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Und es fielen Raubvögel über die Opfer her; aber Abram verscheuchte sie. ");
INSERT INTO deu1951_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Da nun die Sonne anfing sich zu neigen, fiel ein tiefer Schlaf auf Abram, und siehe, Schrecken und große Finsternis überfielen ihn. ");
INSERT INTO deu1951_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Da ward zu Abram gesagt: Du sollst für gewiß wissen, daß dein Same fremd sein wird in einem Lande, das nicht ihm gehört; und daselbst wird man sie zu dienen zwingen und demütigen vierhundert Jahre lang. ");
INSERT INTO deu1951_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Aber auch das Volk, dem sie dienen müssen, will ich richten; darnach sollen sie mit großer Habe ausziehen. ");
INSERT INTO deu1951_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Und du sollst in Frieden zu deinen Vätern hinfahren und in gutem Alter begraben werden. ");
INSERT INTO deu1951_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Sie aber sollen im vierten Geschlechte wieder hierherkommen; denn das Maß der Sünden der Amoriter ist noch nicht voll. ");
INSERT INTO deu1951_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Als nun die Sonne untergegangen und es finster geworden war, siehe, da rauchte ein Ofen, und eine Feuerfackel fuhr zwischen den Stücken hin. ");
INSERT INTO deu1951_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","An dem Tage machte der HERR einen Bund mit Abram und sprach: Deinem Samen habe ich dieses Land gegeben, vom Fluß Ägyptens bis an den großen Strom, den Euphrat: ");
INSERT INTO deu1951_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","die Keniter, die Kenisiter, die Kadmoniter, ");
INSERT INTO deu1951_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","die Hetiter, die Pheresiter, die Rephaiter, ");
INSERT INTO deu1951_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","die Amoriter, die Kanaaniter, die Girgasiter und die Jebusiter. ");
INSERT INTO deu1951_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai aber, Abrams Weib, gebar ihm nicht; aber sie hatte eine ägyptische Magd, die hieß Hagar. ");
INSERT INTO deu1951_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Und Sarai sprach zu Abram: Siehe doch, der HERR hat mich verschlossen, daß ich nicht gebären kann. Gehe doch zu meiner Magd, ob ich mich vielleicht aus ihr erbauen kann! Abram gehorchte Sarais Stimme. ");
INSERT INTO deu1951_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Da nahm Sarai, Abrams Weib, ihre ägyptische Magd Hagar, nachdem Abram zehn Jahre lang im Lande Kanaan gewohnt hatte, und gab sie Abram, ihrem Manne, zum Weibe. ");
INSERT INTO deu1951_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Und als er zu Hagar kam, empfing sie. Da sie nun sah, daß sie empfangen hatte, ward ihre Herrin verächtlich in ihren Augen. ");
INSERT INTO deu1951_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Da sprach Sarai zu Abram: Das Unrecht, das mir zugefügt wird, treffe dich! Ich habe dir meine Magd an den Busen gelegt. Nun sie aber sieht, daß sie guter Hoffnung ist, muß ich in ihren Augen verachtet sein. Der HERR sei Richter zwischen mir und dir! ");
INSERT INTO deu1951_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram aber sprach zu Sarai: Siehe, deine Magd ist in deiner Gewalt, tue mit ihr, wie dir gefällt! Da nun Sarai sie demütigte, floh sie von ihr. ");
INSERT INTO deu1951_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Aber der Engel des HERRN fand sie bei einem Wasserbrunnen in der Wüste, beim Brunnen am Wege Schur. ");
INSERT INTO deu1951_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Er sprach zu ihr: Hagar, Sarais Magd, wo kommst du her, und wo willst du hin? Sie sprach: Ich bin von meiner Herrin Sarai geflohen! ");
INSERT INTO deu1951_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Und der Engel des HERRN sprach zu ihr: Kehre wieder zu deiner Herrin zurück, und demütige dich unter ihre Hand. ");
INSERT INTO deu1951_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Und der Engel des HERRN sprach zu ihr: Siehe, ich will deinen Samen also mehren, daß er vor großer Menge unzählbar sein soll. ");
INSERT INTO deu1951_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Weiter sprach der Engel des HERRN zu ihr: Siehe, du hast empfangen und wirst einen Sohn gebären, den sollst du Ismael nennen, weil der HERR dein Jammern erhört hat. ");
INSERT INTO deu1951_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Er wird ein wilder Mensch sein, seine Hand wider jedermann und jedermanns Hand wider ihn; und er wird gegenüber von allen seinen Brüdern wohnen. ");
INSERT INTO deu1951_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Und sie nannte den Namen des HERRN, der mit ihr redete: Du bist «der Gott, der mich sieht»! Denn sie sprach: Habe ich hier nicht den gesehen, der mich gesehen hat? ");
INSERT INTO deu1951_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Darum nannte sie den Brunnen einen «Brunnen des Lebendigen, der mich sieht». Siehe, er ist zwischen Kadesch und Bared. ");
INSERT INTO deu1951_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Und Hagar gebar Abram einen Sohn; und Abram nannte seinen Sohn, den ihm Hagar gebar, Ismael. ");
INSERT INTO deu1951_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Und Abram war sechsundachtzig Jahre alt, als Hagar ihm den Ismael gebar. ");
INSERT INTO deu1951_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Als nun Abram neunundneunzig Jahre alt war, erschien ihm der HERR und sprach zu ihm: Ich bin der allmächtige Gott. Wandle vor mir und sei tadellos! ");
INSERT INTO deu1951_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Und ich will meinen Bund stiften zwischen mir und dir und will dich über alle Maßen mehren! ");
INSERT INTO deu1951_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Da fiel Abram auf sein Angesicht. Und Gott redete weiter mit ihm und sprach: ");
INSERT INTO deu1951_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Siehe, ich bin der, welcher im Bunde mit dir steht; und du sollst ein Vater vieler Völker werden. ");
INSERT INTO deu1951_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Darum sollst du nicht mehr Abram heißen, sondern Abraham soll dein Name sein; denn ich habe dich zu einem Vater vieler Völker gemacht. ");
INSERT INTO deu1951_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Und ich will dich sehr, sehr fruchtbar machen und will dich zu Völkern machen, auch Könige sollen von dir herkommen. ");
INSERT INTO deu1951_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Und ich will meinen Bund aufrichten zwischen mir und dir und deinem Samen nach dir von Geschlecht zu Geschlecht, daß es ein ewiger Bund sei; also, daß ich dein Gott sei und deines Samens nach dir. ");
INSERT INTO deu1951_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Und ich will dir und deinem Samen nach dir das Land geben, darin du ein Fremdling bist, nämlich das ganze Land Kanaan, zur ewigen Besitzung, und ich will ihr Gott sein. ");
INSERT INTO deu1951_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Und Gott sprach weiter zu Abraham: So bewahre nun meinen Bund, du und dein Same nach dir, von Geschlecht zu Geschlecht! ");
INSERT INTO deu1951_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Das ist aber mein Bund, den ihr bewahren sollt, zwischen mir und euch und deinem Samen nach dir: Alles, was männlich ist unter euch, soll beschnitten werden. ");
INSERT INTO deu1951_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ihr sollt aber die Vorhaut eures Fleisches beschneiden. Das soll ein Zeichen des Bundes sein zwischen mir und euch. ");
INSERT INTO deu1951_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Jedes Knäblein von euren Geschlechtern, wenn es acht Tage alt ist, sollt ihr beschneiden, sei es im Haus geboren oder um Geld erkauft von irgend einem Ausländer, der nicht deines Samens ist. ");
INSERT INTO deu1951_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Was in deinem Hause geboren oder um Geld erkauft wird, soll beschnitten werden. Also soll mein Bund an eurem Fleische sein, ein ewiger Bund. ");
INSERT INTO deu1951_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Und wenn ein Knäblein an der Vorhaut seines Fleisches nicht beschnitten wird, dessen Seele soll aus seinem Volke ausgerottet werden, weil es meinen Bund gebrochen hat. ");
INSERT INTO deu1951_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Und Gott sprach abermal zu Abraham: Du sollst dein Weib Sarai nicht mehr Sarai nennen, sondern Sarah soll ihr Name sein. ");
INSERT INTO deu1951_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Denn ich will sie segnen und will dir auch von ihr einen Sohn geben. Ich will sie segnen, und sie soll zu Nationen werden, und Könige von Völkern sollen von ihr kommen. ");
INSERT INTO deu1951_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Da fiel Abraham auf sein Angesicht und lachte und sprach in seinem Herzen: Soll mir Hundertjährigem ein Kind geboren werden, und Sarah, neunzig Jahre alt, gebären! ");
INSERT INTO deu1951_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Und Abraham sprach zu Gott: Ach, daß Ismael vor dir leben sollte! ");
INSERT INTO deu1951_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Da sprach Gott: Nein, sondern Sarah, dein Weib, soll dir einen Sohn gebären, den sollst du Isaak nennen; denn ich will mit ihm einen Bund aufrichten als einen ewigen Bund für seinen Samen nach ihm. ");
INSERT INTO deu1951_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Wegen Ismael habe ich dich auch erhört. Siehe, ich habe ihn reichlich gesegnet und will ihn fruchtbar machen und sehr mehren. Er wird zwölf Fürsten zeugen, und ich will ihn zum großen Volke machen. ");
INSERT INTO deu1951_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Meinen Bund aber will ich mit Isaak aufrichten, den dir Sarah um diese bestimmte Zeit im andern Jahre gebären soll. ");
INSERT INTO deu1951_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Und da er mit ihm ausgeredet hatte, fuhr Gott auf von Abraham. ");
INSERT INTO deu1951_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Da nahm Abraham seinen Sohn Ismael und alle, die in seinem Hause geboren, und alle, die um sein Geld erkauft waren, alles, was männlich war unter seinen Hausgenossen, und beschnitt die Vorhaut ihres Fleisches an ebendemselben Tage, wie Gott ihm gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Und Abraham war neunundneunzig Jahre alt, als das Fleisch seiner Vorhaut beschnitten ward. ");
INSERT INTO deu1951_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismael aber, sein Sohn, war dreizehn Jahre alt, als das Fleisch seiner Vorhaut beschnitten ward. ");
INSERT INTO deu1951_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","An ebendemselben Tag ließen sich Abraham und sein Sohn Ismael beschneiden; ");
INSERT INTO deu1951_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","und alles, was männlich war in seinem Hause, daheim geboren und von Fremdlingen um Geld erkauft, ward mit ihm beschnitten. ");
INSERT INTO deu1951_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Und der HERR erschien ihm bei den Eichen Mamres, da er an der Tür seiner Hütte saß, als der Tag am heißesten war. ");
INSERT INTO deu1951_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Als er nämlich seine Augen aufhob und sich umsah, siehe, da standen drei Männer ihm gegenüber. Und als er sie sah, eilte er ihnen entgegen von der Türe seiner Hütte, bückte sich zur Erde nieder ");
INSERT INTO deu1951_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","und sprach: Mein Herr, habe ich Gnade vor deinen Augen gefunden, so gehe doch nicht an deinem Knechte vorüber! ");
INSERT INTO deu1951_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Man soll ein wenig Wasser bringen, daß ihr eure Füße waschet; und lagert euch unter dem Baum, ");
INSERT INTO deu1951_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","so will ich einen Bissen Brot bringen, daß ihr euer Herz stärket; darnach mögt ihr weiterziehen, denn darum seid ihr bei eurem Knechte vorbeigekommen. Sie sprachen: Tue also, wie du gesagt hast! ");
INSERT INTO deu1951_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Und Abraham eilte in die Hütte zu Sarah und sprach: Nimm eilends drei Maß Semmelmehl, knete sie und backe Kuchen! ");
INSERT INTO deu1951_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Er aber eilte zu den Rindern und holte ein zartes und gutes Kalb und gab es dem Knaben, der eilte und rüstete es zu. ");
INSERT INTO deu1951_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Und er trug Butter und Milch auf und von dem Kalbe, das er gerüstet hatte, und setzte es ihnen vor. Und er stand bei ihnen unter dem Baum; und sie aßen. ");
INSERT INTO deu1951_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Da sprachen sie zu ihm: Wo ist dein Weib Sarah? Er antwortete: Drinnen in der Hütte. ");
INSERT INTO deu1951_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Da sprach er: Gewiß will ich um diese Zeit im künftigen Jahre wieder zu dir kommen, und siehe, dein Weib Sarah soll einen Sohn haben! Sarah aber horchte unter der Tür der Hütte, welche hinter ihm war. ");
INSERT INTO deu1951_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Und Abraham und Sarah waren alt und wohlbetagt, also daß es Sarah nicht mehr nach der Weiber Weise ging. ");
INSERT INTO deu1951_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Darum lachte sie in ihrem Herzen und sprach: Nachdem ich verblüht bin, soll mir noch Wonne zuteil werden! Dazu ist mein Herr ein alter Mann! ");
INSERT INTO deu1951_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Da sprach der HERR zu Abraham: Warum lacht Sarah und spricht: «Sollte ich wirklich noch gebären, so alt ich bin?» ");
INSERT INTO deu1951_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Sollte denn dem HERRN etwas zu wunderbar sein? Zur bestimmten Zeit will ich wieder zu dir kommen im künftigen Jahre, und Sarah soll einen Sohn haben! ");
INSERT INTO deu1951_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Da leugnete Sarah und sprach: Ich habe nicht gelacht! denn sie fürchtete sich. Er aber sprach: Doch, du hast gelacht! ");
INSERT INTO deu1951_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Da brachen die Männer auf und wandten sich gen Sodom. Und Abraham ging mit ihnen, um sie zu begleiten. ");
INSERT INTO deu1951_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Da sprach der HERR: Sollte ich Abraham verbergen, was ich tun will, ");
INSERT INTO deu1951_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","da Abraham gewiß ein großes und starkes Volk werden soll, und alle Völker auf Erden in ihm sollen gesegnet werden? ");
INSERT INTO deu1951_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Denn ich habe ihn dafür erkoren, daß er seinen Kindern und seinem Hause nach ihm befehle, des HERRN Weg zu halten und zu tun, was recht und billig ist, damit der HERR auf Abraham bringe, was er ihm verheißen hat. ");
INSERT INTO deu1951_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Und der HERR sprach: Das Geschrei über Sodom und Gomorra ist groß, und ihre Sünde ist sehr schwer. ");
INSERT INTO deu1951_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Darum will ich hinabfahren und sehen, ob sie wirklich ganz nach dem Geschrei, das vor mich gekommen ist, getan haben; wo aber nicht, daß ich es wisse. ");
INSERT INTO deu1951_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Und die Männer wandten ihr Angesicht und gingen gen Sodom; aber Abraham blieb noch stehen vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Und Abraham trat näher und sprach: Willst du auch den Gerechten mit dem Gottlosen wegraffen? ");
INSERT INTO deu1951_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Vielleicht möchten fünfzig Gerechte in der Stadt sein, willst du die wegraffen und den Ort nicht verschonen um fünfzig Gerechter willen, die darinnen wären? ");
INSERT INTO deu1951_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Das sei ferne von dir, daß du eine solche Sache tuest und tötest den Gerechten mit dem Gottlosen, daß der Gerechte sei wie der Gottlose. Das sei ferne von dir! Der aller Welt Richter ist, sollte der nicht recht richten? ");
INSERT INTO deu1951_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Der HERR sprach: Finde ich fünfzig Gerechte zu Sodom in der Stadt, so will ich um ihretwillen den ganzen Ort verschonen! ");
INSERT INTO deu1951_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Und Abraham antwortete und sprach: Ach siehe, ich habe mich unterwunden, mit meinem Herrn zu reden, obwohl ich nur Staub und Asche bin! ");
INSERT INTO deu1951_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Vielleicht möchten fünf weniger als fünfzig Gerechte darinnen sein, willst du denn die ganze Stadt verderben um der fünfe willen? Er sprach: Finde ich fünfundvierzig darinnen, so will ich sie nicht verderben! ");
INSERT INTO deu1951_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Und er fuhr weiter fort mit ihm zu reden und sprach: Man möchte vielleicht vierzig darin finden. Er aber sprach: Ich will ihnen nichts tun, um der vierzig willen. ");
INSERT INTO deu1951_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Und Abraham sprach: Möge es meinen Herrn nicht erzürnen, wenn ich noch weiter rede! Man möchte vielleicht dreißig darin finden. Er aber sprach: Finde ich dreißig darinnen, so will ich ihnen nichts tun. ");
INSERT INTO deu1951_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Und er sprach: Ach siehe, ich habe mich unterwunden, mit meinem Herrn zu reden: Man möchte vielleicht zwanzig darin finden. Er antwortete: Ich will sie nicht verderben, um der zwanzig willen! ");
INSERT INTO deu1951_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Und er sprach: Ach, zürne nicht, mein Herr, daß ich nur noch diesmal rede: Man möchte vielleicht zehn darin finden. Er aber sprach: Ich will sie nicht verderben, um der zehn willen! ");
INSERT INTO deu1951_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Und der HERR ging hin, da er mit Abraham ausgeredet hatte; Abraham aber kehrte wieder an seinen Ort zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Und die zwei Engel kamen am Abend nach Sodom. Lot aber saß zu Sodom unter dem Tor; und als er sie sah, stand er auf, ging ihnen entgegen und verneigte sich, das Angesicht zur Erde gewandt, ");
INSERT INTO deu1951_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","und sprach: Siehe da, meine Herren! Kehrt ein in das Haus eures Knechtes und bleibet über Nacht und lasset euch die Füße waschen; so steht ihr am Morgen frühe auf und zieht euren Weg! Sie aber sprachen: Nein, sondern wir wollen auf der Gasse übernachten! ");
INSERT INTO deu1951_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Er aber nötigte sie ernstlich. Da kehrten sie bei ihm ein und kamen in sein Haus. Und er bereitete ihnen ein Mahl und machte ungesäuerte Kuchen; und sie aßen. ");
INSERT INTO deu1951_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Aber ehe sie sich legten, umringten die Männer der Stadt das Haus, die Männer von Sodom, jung und alt, das ganze Volk aus allen Enden, ");
INSERT INTO deu1951_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","und riefen Lot und sprachen zu ihm: Wo sind die Männer, die diese Nacht zu dir gekommen sind? Bringe sie heraus zu uns, daß wir sie erkennen! ");
INSERT INTO deu1951_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Da ging Lot zu ihnen hinaus und schloß die Tür hinter sich zu. ");
INSERT INTO deu1951_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Und sprach: Ach, meine Brüder, tut doch nicht so übel! ");
INSERT INTO deu1951_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Siehe, ich habe zwei Töchter, die haben noch keinen Mann erkannt, die will ich zu euch hinausführen, daß ihr mit ihnen tut, was euch gut dünkt; nur diesen Männern tut nichts, weil sie doch unter den Schatten meines Daches gekommen sind! ");
INSERT INTO deu1951_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sie aber sprachen: Mach, daß du fortkommst! Darnach sprachen sie: Der ist der einzige Fremdling hier und will den Richter spielen! Nun wollen wir dir's noch ärger machen als ihnen! Und sie drangen hart auf den Mann, auf Lot ein und machten sich daran, die Türe aufzubrechen. ");
INSERT INTO deu1951_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Da streckten die Männer ihre Hände hinaus und zogen Lot zu sich hinein und schlossen die Türe zu ");
INSERT INTO deu1951_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","und schlugen die Männer vor der Haustüre mit Blindheit, beide klein und groß, daß sie müde wurden, die Tür zu suchen. ");
INSERT INTO deu1951_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Und die Männer sprachen zu Lot: Hast du noch jemand hier, einen Tochtermann oder Söhne oder Töchter? Wer dir in der Stadt zugehört, den führe hinaus von diesem Ort! ");
INSERT INTO deu1951_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Denn wir werden diesen Ort verderben, weil das Geschrei über sie groß ist vor dem HERRN; und der HERR hat uns gesandt, sie zu verderben. ");
INSERT INTO deu1951_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Da ging Lot hinaus und redete mit seinen Tochtermännern, die seine Töchter nehmen sollten, und sprach: Machet euch auf, gehet aus von diesem Ort; denn der HERR wird diese Stadt verderben! Aber es kam seinen Tochtermännern vor, als scherze er. ");
INSERT INTO deu1951_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Da nun die Morgenröte aufging, hießen die Engel Lot eilen und sprachen: Mache dich auf, nimm dein Weib und deine beiden Töchter, die vorhanden sind, damit du nicht in der Missetat dieser Stadt umkommest! ");
INSERT INTO deu1951_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Als er aber verzog, ergriffen die Männer ihn und sein Weib und seine beiden Töchter bei der Hand, weil der HERR ihn verschonen wollte, und führten ihn hinaus und ließen ihn draußen vor der Stadt. ");
INSERT INTO deu1951_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Und als sie dieselben hinausgeführt hatten, sprach er: Errette deine Seele und siehe nicht hinter dich; stehe auch nicht still in dieser ganzen Umgegend! Auf den Berg rette dich, daß du nicht weggerafft werdest! ");
INSERT INTO deu1951_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Aber Lot sprach zu ihnen: Ach nein, mein Herr! ");
INSERT INTO deu1951_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Siehe doch, dein Knecht hat vor deinen Augen Gnade gefunden, und du hast mir große Barmherzigkeit erwiesen, daß du meine Seele am Leben erhieltest. Aber auf den Berg kann ich mich nicht retten; das Unglück könnte mich ereilen, daß ich stürbe! ");
INSERT INTO deu1951_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Siehe, jene Stadt ist so nahe, daß ich dahin fliehen könnte; und sie ist klein. Ach, laß mich dahin fliehen! Ist sie nicht eine kleine Stadt? Nur daß meine Seele lebendig bleibe! ");
INSERT INTO deu1951_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Da sprach er zu ihm: Siehe, ich habe dich auch in diesem Stück erhört, daß ich die Stadt nicht umkehre, von welcher du geredet hast. ");
INSERT INTO deu1951_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Eile, rette dich daselbst hin; denn ich kann nichts tun, bis du hineingekommen bist! Daher wird die Stadt Zoar genannt. ");
INSERT INTO deu1951_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Und die Sonne war auf Erden aufgegangen, als Lot nach Zoar kam. ");
INSERT INTO deu1951_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Da ließ der HERR Schwefel und Feuer regnen auf Sodom und Gomorra, vom HERRN, vom Himmel herab, ");
INSERT INTO deu1951_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","und kehrte die Städte um und die ganze Umgebung und alle Einwohner der Städte und was auf dem Lande gewachsen war. ");
INSERT INTO deu1951_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Und sein Weib sah hinter sich und ward zur Salzsäule. ");
INSERT INTO deu1951_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham aber machte sich am Morgen früh auf an den Ort, da er vor dem HERRN gestanden hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Und er wandte sein Angesicht gen Sodom und Gomorra und gegen das ganze Land jener Gegend und sah sich um, und siehe, ein Rauch ging auf von dem Lande, wie ein Rauch vom Kalkofen. ");
INSERT INTO deu1951_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Und als Gott die Städte in jener Ebene verderbte, da gedachte Gott an Abraham, und er führte Lot mitten aus dem Verderben, als er die Städte umkehrte, darinnen Lot gewohnt hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Und Lot ging von Zoar hinauf und blieb mit seinen beiden Töchtern auf dem Berge; denn er fürchtete sich in Zoar zu bleiben; und er wohnte mit seinen Töchtern in einer Höhle. ");
INSERT INTO deu1951_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Da sprach die ältere zu der jüngeren: Unser Vater ist alt, und es ist kein Mann mehr auf Erden, der zu uns kommen möge nach aller Welt Weise. ");
INSERT INTO deu1951_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","So komm, wir wollen unsern Vater mit Wein tränken und bei ihm liegen. ");
INSERT INTO deu1951_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Also tränkten sie ihren Vater mit Wein in derselben Nacht. Und die ältere ging und legte sich zu ihrem Vater, und er gewahrte es nicht, weder als sie sich legte, noch als sie aufstand. ");
INSERT INTO deu1951_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Am Morgen sprach die ältere zu der jüngern: Siehe, ich bin gestern bei meinem Vater gelegen; wir wollen ihn auch diese Nacht mit Wein tränken, daß du hingehest und dich zu ihm legest, daß wir Samen von unserm Vater erhalten. ");
INSERT INTO deu1951_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Also tränkten sie ihren Vater dieselbe Nacht mit Wein. Und die jüngere machte sich auf und legte sich zu ihm, und er merkte es nicht, weder als sie sich legte, noch als sie aufstand. ");
INSERT INTO deu1951_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Also wurden die beiden Töchter Lots schwanger von ihrem Vater. ");
INSERT INTO deu1951_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Und die ältere gebar einen Sohn, den hieß sie Moab; der ward der Vater der Moabiter von heutzutage. ");
INSERT INTO deu1951_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Und die jüngere gebar auch einen Sohn, den hieß sie Ben-Ammi; der ward der Vater der Kinder Ammon von heutzutage. ");
INSERT INTO deu1951_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham aber zog von dannen in den südlichen Landesteil und wohnte zwischen Kadesch und Schur und war ein Fremdling zu Gerar. ");
INSERT INTO deu1951_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Und Abraham sprach von seinem Weibe Sarah: Sie ist meine Schwester. Da ließ Abimelech, der König zu Gerar, Sarah holen. ");
INSERT INTO deu1951_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Aber Gott kam des Nachts im Traum zu Abimelech und sprach zu ihm: Siehe da, du bist des Todes um des Weibes willen, das du genommen hast; denn sie ist eines Mannes Eheweib! ");
INSERT INTO deu1951_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech aber hatte sie noch nicht berührt und sprach: Herr, willst du denn auch ein gerechtes Volk umbringen? ");
INSERT INTO deu1951_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hat er nicht zu mir gesagt: «Sie ist meine Schwester?» Und sie hat auch gesagt: «Er ist mein Bruder!» Habe ich doch das mit einfältigem Herzen und unschuldigen Händen getan! ");
INSERT INTO deu1951_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Und Gott sprach zu ihm im Traum: Ich weiß, daß du solches mit einfältigem Herzen getan hast; darum habe ich dich auch behütet, daß du nicht wider mich sündigtest, und darum habe ich es dir nicht gestattet, daß du sie berührtest. ");
INSERT INTO deu1951_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","So gib nun dem Manne sein Weib wieder, denn er ist ein Prophet; und er soll für dich bitten, so wirst du am Leben bleiben; wenn du sie aber nicht zurückgibst, so wisse, daß du gewiß sterben mußt samt allem, was dein ist! ");
INSERT INTO deu1951_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Da stand Abimelech am Morgen frühe auf und rief allen seinen Knechten und sagte ihnen dieses alles vor ihren Ohren; und die Leute fürchteten sich sehr. ");
INSERT INTO deu1951_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Und Abimelech rief Abraham und sprach zu ihm: Warum hast du uns das getan, und was habe ich an dir gesündigt, daß du eine so große Sünde auf mich und mein Reich bringen wolltest? Du hast nicht mit mir gehandelt, wie man handeln soll. ");
INSERT INTO deu1951_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Und Abimelech fragte Abraham: In welcher Absicht hast du solches getan? ");
INSERT INTO deu1951_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham sprach: Weil ich dachte: Es ist gar keine Gottesfurcht an diesem Ort, darum werden sie mich um meines Weibes willen erwürgen. ");
INSERT INTO deu1951_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Auch ist sie wahrhaftig meine Schwester; denn sie ist meines Vaters Tochter, aber nicht meiner Mutter Tochter, und sie ist mein Weib geworden. ");
INSERT INTO deu1951_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Da mich aber Gott aus meines Vaters Haus führte, sprach ich zu ihr: Das mußt du mir zuliebe tun, daß du überall, wo wir hinkommen, von mir sagest: Er ist mein Bruder! ");
INSERT INTO deu1951_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Da nahm Abimelech Schafe und Rinder, Knechte und Mägde und schenkte sie Abraham und gab ihm sein Weib Sarah zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Und Abimelech sprach: Siehe da, mein Land steht dir offen; wo es dir gefällt, da laß dich nieder! ");
INSERT INTO deu1951_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Aber zu Sarah sprach er: Siehe da, ich gebe deinem Bruder tausend Silberlinge; siehe da, das soll dir eine Decke der Augen sein für alles, was mit dir vorgegangen ist, und damit du in jeder Weise gerechtfertigst seist! ");
INSERT INTO deu1951_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham aber legte Fürbitte ein bei Gott. Da heilte Gott Abimelech und sein Weib und seine Mägde, daß sie gebaren. ");
INSERT INTO deu1951_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Denn der HERR hatte zuvor jeden Mutterleib im Hause Abimelechs fest verschlossen, um Sarahs, des Weibes Abrahams willen. ");
INSERT INTO deu1951_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Und der HERR suchte Sarah heim, wie er verheißen hatte, und der HERR tat an Sarah, wie er geredet hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Und Sarah empfing und gebar dem Abraham einen Sohn in seinem Alter, zur bestimmten Zeit, wie ihm Gott versprochen hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Und Abraham nannte seinen Sohn, der ihm geboren ward, den ihm Sarah gebar, Isaak. ");
INSERT INTO deu1951_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Und Abraham beschnitt Isaak, seinen Sohn, da er acht Tage alt war, wie ihm Gott geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Hundert Jahre war Abraham alt, da ihm sein Sohn Isaak geboren ward. ");
INSERT INTO deu1951_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Und Sarah sprach: Gott hat mir ein Lachen bereitet; wer es hören wird, der wird meiner lachen! ");
INSERT INTO deu1951_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Und sie sprach: Wer verkündigt das dem Abraham, daß Sarah Kinder säugt, daß ich ihm in seinem Alter einen Sohn geboren habe? ");
INSERT INTO deu1951_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Und das Kind wuchs und ward entwöhnt. Und Abraham machte ein großes Mahl des Tages, da Isaak entwöhnt ward. ");
INSERT INTO deu1951_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Und Sarah sah, daß der Sohn der Hagar, der ägyptischen Magd, den sie dem Abraham geboren hatte, Mutwillen trieb. ");
INSERT INTO deu1951_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Da sprach sie zu Abraham: Treibe diese Magd mit ihrem Sohne aus; denn der Sohn dieser Magd soll nicht erben mit meinem Sohn Isaak! ");
INSERT INTO deu1951_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Dieses Wort mißfiel Abraham sehr um seines Sohnes willen. ");
INSERT INTO deu1951_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Aber Gott sprach zu Abraham: Es soll dir das nicht mißfallen! Höre auf alles, was Sarah dir sagt wegen des Knaben und deiner Magd; denn in Isaak soll dir ein Same berufen werden. ");
INSERT INTO deu1951_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Doch ich will auch den Sohn der Magd zum Volke machen, weil er deines Samens ist. ");
INSERT INTO deu1951_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Da stand Abraham am Morgen frühe auf und nahm Brot und einen Schlauch voll Wasser, gab es Hagar und legte es auf ihre Schulter; er gab ihr auch den Knaben und schickte sie fort. Sie ging und irrte in der Wüste Beer-Seba umher. ");
INSERT INTO deu1951_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Da nun das Wasser im Schlauch ausgegangen war, warf sie den Knaben unter einen Strauch, ");
INSERT INTO deu1951_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ging hin und setzte sich gegenüber, einen Bogenschuß weit entfernt; denn sie sprach: Ich kann nicht sehen des Knaben Sterben! Und sie saß ihm gegenüber, erhob ihre Stimme und weinte. ");
INSERT INTO deu1951_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Da erhörte Gott die Stimme des Knaben, und der Engel Gottes rief der Hagar vom Himmel her und sprach zu ihr: Was ist dir, Hagar? Fürchte dich nicht, denn Gott hat erhört die Stimme des Knaben, da, wo er liegt. ");
INSERT INTO deu1951_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Steh auf, nimm den Knaben und fasse ihn mit deiner Hand, denn ich will ihn zu einem großen Volke machen! ");
INSERT INTO deu1951_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Und Gott öffnete ihr die Augen, daß sie einen Wasserbrunnen sah. Da ging sie hin und füllte den Schlauch mit Wasser und tränkte den Knaben. ");
INSERT INTO deu1951_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Und Gott war mit dem Knaben; der wuchs und wohnte in der Wüste und ward ein Bogenschütze. ");
INSERT INTO deu1951_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Und er wohnte in der Wüste Paran, und seine Mutter nahm ihm ein Weib aus Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Zu derselben Zeit redete Abimelech und sein Feldhauptmann Pichol mit Abraham und sprach: Gott ist mit dir in allem, was du tust. ");
INSERT INTO deu1951_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","So schwöre mir nun hier bei Gott, daß du weder an mir, noch an meinen Kindern, noch an meinen Kindeskindern treulos handeln, sondern die Freundschaft, die ich dir bewiesen habe, auch an mir beweisen willst und an dem Lande, darinnen du ein Fremdling bist. ");
INSERT INTO deu1951_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Da sprach Abraham: Ich will schwören! ");
INSERT INTO deu1951_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Und Abraham rechtete mit Abimelech um des Wasserbrunnens willen, den Abimelechs Knechte mit Gewalt genommen hatten. ");
INSERT INTO deu1951_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Da antwortete Abimelech: Ich weiß nichts davon; wer hat das getan? Du hast mir gar nichts angezeigt, und ich habe auch nichts davon gehört bis auf diesen Tag! ");
INSERT INTO deu1951_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Da nahm Abraham Schafe und Rinder und gab sie Abimelech, und sie machten beide einen Bund miteinander. ");
INSERT INTO deu1951_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Und Abraham stellte sieben Lämmer besonders. ");
INSERT INTO deu1951_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Da sprach Abimelech zu Abraham: Was sollen die sieben Lämmer hier, die du besonders gestellt hast? ");
INSERT INTO deu1951_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Er antwortete: Du sollst sieben Lämmer von meiner Hand nehmen, damit sie mir zum Zeugnis seien, daß ich diesen Brunnen gegraben habe! ");
INSERT INTO deu1951_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Daher wird der Ort Beer-Seba genannt, weil sie beide daselbst einander geschworen haben. ");
INSERT INTO deu1951_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Als sie aber den Bund zu Beer-Seba geschlossen, machten sich Abimelech und Pichol, sein Feldhauptmann, auf und zogen wieder in der Philister Land. ");
INSERT INTO deu1951_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham aber pflanzte eine Tamariske zu Beer-Seba und rief daselbst den Namen des HERRN, des ewigen Gottes, an. ");
INSERT INTO deu1951_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Und Abraham hielt sich lange Zeit als Fremdling im Lande der Philister auf. ");
INSERT INTO deu1951_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nach diesen Geschichten versuchte Gott den Abraham und sprach zu ihm: Abraham! Und er antwortete: Siehe, hier bin ich. ");
INSERT INTO deu1951_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Und er sprach: Nimm doch deinen Sohn, deinen einzigen, den du lieb hast, Isaak, und gehe hin in das Land Morija und opfere ihn daselbst zum Brandopfer auf einem Berge, den ich dir nennen werde! ");
INSERT INTO deu1951_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Da stand Abraham am Morgen früh auf und sattelte seinen Esel, und nahm zwei Knechte und seinen Sohn Isaak mit sich und spaltete Holz zum Brandopfer, machte sich auf und ging hin an den Ort, davon ihm Gott gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Am dritten Tage erhob Abraham seine Augen und sah den Ort von ferne. ");
INSERT INTO deu1951_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Da sprach Abraham zu seinen Knechten: Bleibet ihr hier mit dem Esel, ich aber und der Knabe wollen dorthin gehen, und wenn wir angebetet haben, wollen wir wieder zu euch kommen. ");
INSERT INTO deu1951_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Und Abraham nahm das Holz zum Brandopfer und legte es auf seinen Sohn Isaak. Er aber nahm das Feuer und das Messer in seine Hand, und sie gingen beide miteinander. ");
INSERT INTO deu1951_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Da sprach Isaak zu seinem Vater Abraham: Mein Vater! Abraham antwortete: Siehe, hier bin ich, mein Sohn! Und er sprach: Siehe, hier ist Feuer und Holz; wo ist aber das Lämmlein zum Brandopfer? ");
INSERT INTO deu1951_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Und Abraham antwortete: Mein Sohn, Gott wird sich ein Lämmlein zum Brandopfer ersehen! Und sie gingen beide miteinander. ");
INSERT INTO deu1951_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Und als sie an den Ort kamen, den Gott ihm genannt hatte, baute Abraham daselbst einen Altar und legte das Holz ordentlich darauf, band seinen Sohn Isaak und legte ihn auf den Altar, oben auf das Holz. ");
INSERT INTO deu1951_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Und Abraham streckte seine Hand aus und faßte das Messer, seinen Sohn zu schlachten. ");
INSERT INTO deu1951_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Da rief ihm der Engel des HERRN vom Himmel und sprach: Abraham! Abraham! Und er antwortete: Siehe, hier bin ich! ");
INSERT INTO deu1951_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Er sprach: Lege deine Hand nicht an den Knaben und tue ihm nichts; denn nun weiß ich, daß du Gott fürchtest und hast deinen einzigen Sohn nicht verschont um meinetwillen! ");
INSERT INTO deu1951_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Da erhob Abraham seine Augen und sah hinter sich einen Widder mit den Hörnern in den Hecken verwickelt. Und Abraham ging hin und nahm den Widder und opferte ihn zum Brandopfer an Stelle seines Sohnes. ");
INSERT INTO deu1951_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Und Abraham nannte den Ort: Der HERR wird dafür sorgen! So daß man noch heute sagt: Auf dem Berge wird der HERR dafür sorgen! ");
INSERT INTO deu1951_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Und der Engel des HERRN rief Abraham zum zweitenmal vom Himmel ");
INSERT INTO deu1951_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","und sprach: Ich habe bei mir selbst geschworen, spricht der HERR, weil du solches getan und deines einzigen Sohnes nicht verschont hast, ");
INSERT INTO deu1951_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","will ich dich gewiß segnen und deinen Samen mächtig mehren, wie die Sterne am Himmel und wie den Sand am Rande des Meeres, und dein Same soll die Tore seiner Feinde besitzen, ");
INSERT INTO deu1951_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","und in deinem Samen sollen alle Völker auf Erden gesegnet werden, weil du meiner Stimme gehorcht hast! ");
INSERT INTO deu1951_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Und Abraham kehrte wieder zu seinen Knechten zurück; und sie machten sich auf und zogen miteinander gen Beer-Seba, denn Abraham wohnte zu Beer-Seba. ");
INSERT INTO deu1951_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nach diesen Geschichten ward Abraham die Kunde gebracht: Siehe, Milka hat deinem Bruder Nahor auch Kinder geboren: ");
INSERT INTO deu1951_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, den Erstgeborenen, und Bus, seinen Bruder, und Kemuel, den Vater des Aram, ");
INSERT INTO deu1951_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","und Kesed und Chaso und Pildasch und Jidlaph und Bethuel. ");
INSERT INTO deu1951_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel aber hatte die Rebekka gezeugt. Milka gebar diese acht dem Nahor, Abrahams Bruder. ");
INSERT INTO deu1951_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Und sein Kebsweib mit Namen Rehuma, gebar auch, nämlich Tebach, Gaham, Tachasch und Maacha. ");
INSERT INTO deu1951_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah ward hundertsiebenundzwanzig Jahre alt; so lange lebte sie. ");
INSERT INTO deu1951_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Und Sarah starb in Kirjat-Arba, das ist Hebron, im Lande Kanaan. Da ging Abraham hin, daß er um Sarah klagte und sie beweinte. ");
INSERT INTO deu1951_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Darnach stand Abraham auf von seiner Leiche und redete mit den Söhnen Hets und sprach: ");
INSERT INTO deu1951_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ich bin ein Fremdling und Beisaße bei euch, gebt mir ein Erbbegräbnis bei euch, daß ich meine Tote von meinem Angesicht entfernt begraben kann! ");
INSERT INTO deu1951_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Da antworteten die Hetiter dem Abraham und sprachen zu ihm: ");
INSERT INTO deu1951_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Höre uns, mein Herr, du bist ein Fürst Gottes mitten unter uns, begrabe deine Tote in dem besten unsrer Gräber. Niemand von uns wird dir sein Grab verweigern, daß du deine Tote darin begrabest! ");
INSERT INTO deu1951_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Da stand Abraham auf und bückte sich vor dem Volke des Landes, vor den Hetitern. ");
INSERT INTO deu1951_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Und er redete mit ihnen und sprach: Ist es euer Wille, daß ich meine Tote von meinem Angesicht entfernt begrabe, so höret mich und bittet für mich Ephron, den Sohn Zohars, ");
INSERT INTO deu1951_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","daß er mir die Höhle Machpelah gebe, die er am Ende seines Ackers hat; um den vollen Betrag soll er sie mir in eurer Mitte zum Begräbnis geben! ");
INSERT INTO deu1951_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Und Ephron saß mitten unter den Hetitern. Da antwortete Ephron, der Hetiter, dem Abraham vor den Söhnen Hets, vor allen, die durch das Tor seiner Stadt aus und eingingen, und sprach: ");
INSERT INTO deu1951_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nein, mein Herr, sondern höre mir zu: Ich schenke dir den Acker, und die Höhle darin schenke ich dir dazu, und schenke dir sie vor meinem Volke; begrabe deine Tote! ");
INSERT INTO deu1951_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Da bückte sich Abraham vor dem Volke des Landes ");
INSERT INTO deu1951_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","und redete mit Ephron, daß das Volk des Landes zuhörte, und sprach: Wohlan, wenn du geneigt bist, so höre mich: Nimm von mir das Geld, das ich dir für den Acker gebe, so will ich meine Tote daselbst begraben. ");
INSERT INTO deu1951_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron antwortete Abraham und sprach zu ihm: ");
INSERT INTO deu1951_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mein Herr, höre mich: Das Feld ist vierhundert Schekel Silber wert; was ist aber das zwischen mir und dir? Begrabe nur deine Tote! ");
INSERT INTO deu1951_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Als nun Abraham solches hörte, wog er Ephron das Geld dar, das er gesagt hatte, vor den Ohren der Hetiter, nämlich vierhundert Schekel Silber, das im Kauf gangbar und gültig war. ");
INSERT INTO deu1951_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Also ward Ephrons Acker bei Machpelah, der Mamre gegenüber liegt, der Acker und die Höhle, die darin ist, auch alle Bäume auf dem Acker und innert aller seiner Grenzen, ");
INSERT INTO deu1951_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abraham zum Eigentum bestätigt vor den Augen der Hetiter und aller, die zum Tor seiner Stadt eingingen. ");
INSERT INTO deu1951_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Darnach begrub Abraham die Sarah, sein Weib, in der Höhle des Ackers Machpelah, Mamre gegenüber, zu Hebron, im Lande Kanaan. ");
INSERT INTO deu1951_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Also ward der Acker und die Höhle darin dem Abraham von den Hetitern zum Erbbegräbnis bestätigt. ");
INSERT INTO deu1951_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Und Abraham war alt und wohlbetagt, und der HERR hatte Abraham in allem gesegnet. ");
INSERT INTO deu1951_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Und Abraham sprach zu dem ältesten Knechte seines Hauses, der aller seiner Güter Verwalter war: Lege doch deine Hand unter meine Hüfte, ");
INSERT INTO deu1951_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","daß ich dich schwören lasse bei dem HERRN, dem Gott des Himmels und der Erde, daß du meinem Sohne kein Weib nehmest von den Töchtern der Kanaaniter, unter welchen ich wohne, ");
INSERT INTO deu1951_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","sondern daß du in mein Vaterland und zu meiner Verwandtschaft ziehest und meinem Sohn Isaak ein Weib nehmest. ");
INSERT INTO deu1951_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Da sprach der Knecht zu ihm: Wie? wenn das Weib mir nicht in dieses Land folgen wollte, soll ich alsdann deinen Sohn wieder in das Land zurückbringen, daraus du gezogen bist? ");
INSERT INTO deu1951_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham sprach zu ihm: Da hüte dich wohl, meinen Sohn wieder dahin zu bringen! ");
INSERT INTO deu1951_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Der HERR, der Gott des Himmels, der mich von meines Vaters Hause und aus dem Lande meiner Geburt genommen und mit mir geredet und mir auch geschworen und gesagt hat: «Dieses Land will ich deinem Samen geben», der wird seinen Engel vor dir her senden, daß du meinem Sohn von dort ein Weib nehmest. ");
INSERT INTO deu1951_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Wenn das Weib dir aber nicht folgen will, so bist du entbunden von dem Eid, den du mir geschworen hast; nur bring meinen Sohn nicht wieder dorthin! ");
INSERT INTO deu1951_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Da legte der Knecht seine Hand unter Abrahams, seines Herrn, Hüfte und schwur solches. ");
INSERT INTO deu1951_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Und der Knecht nahm zehn Kamele von den Kamelen seines Herrn und allerlei Güter seines Herrn, und machte sich auf und zog nach Mesopotamien, zu der Stadt Nahors. ");
INSERT INTO deu1951_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Da ließ er die Kamele draußen vor der Stadt sich lagern bei einem Wasserbrunnen am Abend, zur Zeit, da die Jungfrauen herauszugehen pflegten, um Wasser zu schöpfen. ");
INSERT INTO deu1951_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Und er sprach: O HERR, du Gott meines Herrn Abraham, laß es mir doch heute gelingen und tue Barmherzigkeit an meinem Herrn Abraham! ");
INSERT INTO deu1951_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Siehe, ich stehe hier bei dem Wasserbrunnen, und die Töchter der Leute dieser Stadt werden herauskommen, Wasser zu schöpfen. ");
INSERT INTO deu1951_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Wenn nun eine Tochter kommt, zu der ich spreche: Neige doch deinen Krug, daß ich trinke, und sie spricht: Trinke, ich will deine Kamele auch tränken. So möge sie diejenige sein, die du deinem Diener Isaak bestimmt hast, und ich will daran erkennen, daß du an meinem Herrn Barmherzigkeit getan habest. ");
INSERT INTO deu1951_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Und ehe er ausgeredet hatte, siehe, da kam heraus Rebekka, die Tochter Bethuels, der ein Sohn der Milka, des Weibes Nahors, des Bruders Abrahams war; die trug einen Krug auf ihrer Achsel. ");
INSERT INTO deu1951_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Und sie war von Angesicht eine sehr schöne Tochter, eine Jungfrau, und kein Mann hatte sie erkannt; die stieg zum Brunnen hinab und füllte ihren Krug und stieg herauf. ");
INSERT INTO deu1951_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Da lief der Knecht ihr entgegen und sprach: Laß mich doch ein wenig Wasser aus deinem Kruge trinken! ");
INSERT INTO deu1951_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Und sie sprach: Trinke, mein Herr! Und sie ließ den Krug eilend auf ihre Hand hernieder und tränkte ihn. ");
INSERT INTO deu1951_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Und da sie ihn getränkt hatte, sprach sie: Ich will deinen Kamelen auch schöpfen, bis sie genug getrunken haben. ");
INSERT INTO deu1951_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Und sie eilte und leerte den Krug aus in die Tränke und lief abermal zum Brunnen, um zu schöpfen, und schöpfte allen seinen Kamelen. ");
INSERT INTO deu1951_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Und der Mann verwunderte sich über sie, schwieg aber stille, bis er erkannt hatte, ob der HERR seine Reise habe gelingen lassen oder nicht. ");
INSERT INTO deu1951_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Als nun die Kamele alle getrunken hatten, nahm er einen goldenen Ring, einen halben Schekel schwer, und zwei Armbänder an ihre Hände, zehn Schekel Goldes schwer, ");
INSERT INTO deu1951_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","und sprach: Sage mir doch, wessen Tochter bist du? Haben wir in deines Vaters Hause auch Platz zu herbergen? ");
INSERT INTO deu1951_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Sie sprach zu ihm: Ich bin Bethuels Tochter, des Sohnes der Milka, den sie dem Nahor geboren hat. ");
INSERT INTO deu1951_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Und sie sagte weiter zu ihm: Es ist auch viel Stroh und Futter bei uns und Platz genug zum Herbergen. ");
INSERT INTO deu1951_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Da neigte sich der Mann und betete an vor dem HERRN ");
INSERT INTO deu1951_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","und sprach: Gelobet sei der HERR, der Gott meines Herrn Abraham, der seine Gnade und Treue meinem Herrn nicht entzogen hat, denn der HERR hat mich den Weg zum Hause des Bruders meines Herrn geführt! ");
INSERT INTO deu1951_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Und die Tochter lief und sagte solches alles im Hause ihrer Mutter. ");
INSERT INTO deu1951_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Und Rebekka hatte einen Bruder, der hieß Laban. Und Laban lief geschwind zu dem Manne draußen bei dem Brunnen. ");
INSERT INTO deu1951_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Und es geschah, als er den Ring und die Armbänder an den Händen seiner Schwester sah und die Worte seiner Schwester Rebekka hörte, die sprach: Also hat der Mann zu mir geredet! da kam er zu dem Manne, und siehe, der stand bei den Kamelen am Brunnen. ");
INSERT INTO deu1951_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Und er sprach: Komm herein, du Gesegneter des HERRN, warum stehst du draußen? Ich habe das Haus geräumt und für die Kamele Platz gemacht. ");
INSERT INTO deu1951_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Also führte er den Mann ins Haus und zäumte die Kamele ab und gab ihnen Stroh und Futter und Wasser, um seine Füße und die Füße der Männer, die mit ihm waren, zu waschen, ");
INSERT INTO deu1951_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","und setzte ihm zu essen vor. Er aber sprach: Ich will nicht essen, bevor ich meine Sache vorgetragen habe. Er antwortete: Sage an! ");
INSERT INTO deu1951_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Er sprach: Ich bin ein Knecht Abrahams. ");
INSERT INTO deu1951_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Und der HERR hat meinen Herrn reichlich gesegnet, daß er groß geworden ist, denn er hat ihm Schafe und Ochsen, Silber und Gold, Knechte und Mägde, Kamele und Esel gegeben. ");
INSERT INTO deu1951_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Dazu hat Sarah, meines Herrn Weib, in ihrem Alter meinem Herrn einen Sohn geboren, demselben hat er alles, was sein ist, gegeben. ");
INSERT INTO deu1951_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Und mein Herr hat einen Eid von mir genommen und gesagt: Du sollst meinem Sohne kein Weib nehmen von den Töchtern der Kanaaniter, in deren Lande ich wohne; ");
INSERT INTO deu1951_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","sondern ziehe hin zu meines Vaters Haus und zu meinem Geschlecht; daselbst nimm meinem Sohn ein Weib. ");
INSERT INTO deu1951_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ich sprach aber zu meinem Herrn: Wie? wenn mir das Weib nicht folgen will? ");
INSERT INTO deu1951_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Da sprach er zu mir: Der HERR, vor dem ich wandle, wird seinen Engel mit dir senden und deinen Weg gelingen lassen, daß du meinem Sohne von meiner Verwandtschaft und von meines Vaters Hause ein Weib nehmest. ");
INSERT INTO deu1951_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Alsdann sollst du des Eides entbunden sein, wenn du zu meiner Verwandtschaft kommst und sie dir dieselbe nicht geben; so sollst du des Eides entbunden sein. ");
INSERT INTO deu1951_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Also kam ich heute zum Wasserbrunnen und sprach: O HERR, Gott, meines Herrn Abraham, wenn du doch zu meiner Reise Glück gäbest, welche ich gemacht! ");
INSERT INTO deu1951_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Siehe, ich stehe hier bei dem Wasserbrunnen. Wenn nun eine Jungfrau herauskommt zu schöpfen und ich spreche: «Gib mir aus deinem Krug ein wenig Wasser zu trinken», ");
INSERT INTO deu1951_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","und sie zu mir sagen wird: «Trinke, ich will deinen Kamelen auch schöpfen», so möge doch diese das Weib sein, welches der HERR dem Sohn meines Herrn bestimmt hat! ");
INSERT INTO deu1951_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ehe ich nun solche Worte in meinem Herzen ausgeredet hatte, siehe, da kommt Rebekka mit einem Krug auf ihrer Achsel und geht zum Brunnen hinab und schöpft. Da sprach ich zu ihr: «Gib mir zu trinken!» ");
INSERT INTO deu1951_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Und sie nahm den Krug eilend von ihrer Achsel und sprach: «Trink, ich will deine Kamele auch tränken!» Also trank ich, und sie tränkte die Kamele auch. ");
INSERT INTO deu1951_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Und ich fragte sie und sprach: «Wessen Tochter bist du?» Sie antwortete: «Ich bin Bethuels Tochter, des Sohnes Nahors, den ihm Milka geboren hat.» Da legte ich einen Ring an ihre Nase und Armbänder an ihre Hände ");
INSERT INTO deu1951_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","und neigte mich und betete an vor dem HERRN und lobte den HERRN, den Gott meines Herrn Abraham, der mich den rechten Weg geführt hat, daß ich seinem Sohne die Tochter des Bruders meines Herrn nehme. ");
INSERT INTO deu1951_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Wollt ihr nun meinem Herrn Liebe und Treue erweisen, so sagt mir's, wo nicht, so sagt es mir ebenfalls, daß ich mich zur Rechten oder zur Linken wende! ");
INSERT INTO deu1951_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Da antworteten Laban und Bethuel und sprachen: Das ist vom HERRN gekommen, darum können wir nichts wider dich reden, weder Böses noch Gutes! ");
INSERT INTO deu1951_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Da ist Rebekka vor dir, nimm sie und ziehe hin, daß sie das Weib des Sohnes deines Herrn sei, wie der HERR geredet hat! ");
INSERT INTO deu1951_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Als nun Abrahams Knecht ihre Worte hörte, bückte er sich vor dem HERRN zur Erde. ");
INSERT INTO deu1951_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Und er zog hervor silberne und goldene Kleinode und Kleider und gab sie Rebekka; auch ihrem Bruder und ihrer Mutter gab er Kostbarkeiten. ");
INSERT INTO deu1951_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Da aßen und tranken sie, er samt den Männern, die mit ihm waren, und blieben daselbst über Nacht. Aber am Morgen standen sie auf, und er sprach: Lasset mich zu meinem Herrn ziehen! ");
INSERT INTO deu1951_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Aber ihr Bruder und ihre Mutter sprachen: Laß doch die Tochter etliche Tage lang, zum wenigsten zehn, bei uns bleiben, darnach magst du ziehen! ");
INSERT INTO deu1951_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Da sprach er zu ihnen: Haltet mich nicht auf, denn der HERR hat meinen Weg gelingen lassen; lasset mich zu meinem Herrn ziehen! ");
INSERT INTO deu1951_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Da sprachen sie: Lasset uns die Tochter rufen und fragen, was sie dazu sage! ");
INSERT INTO deu1951_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Und sie riefen Rebekka und sprachen zu ihr: Willst du mit diesem Manne ziehen? Sie antwortete: Ja, ich will mit ihm ziehen! ");
INSERT INTO deu1951_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Also ließen sie Rebekka, ihre Schwester, mit ihrer Amme, samt dem Knecht Abrahams und seinen Leuten ziehen. ");
INSERT INTO deu1951_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Und sie segneten Rebekka und sprachen zu ihr: Du bist unsre Schwester, werde zu vieltausendmal Tausenden, und dein Same besitze die Tore seiner Feinde! ");
INSERT INTO deu1951_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Also machten sich Rebekka und ihre Mägde auf und setzten sich auf die Kamele und zogen dem Manne nach. Und der Knecht nahm Rebekka und zog hin. ");
INSERT INTO deu1951_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaak aber kam vom «Brunnen des Lebendigen, der mich sieht»; denn er wohnte im Süden des Landes; ");
INSERT INTO deu1951_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","und er war zur Abendzeit auf das Feld gegangen, um zu beten, und hob seine Augen auf und sah Kamele daherkommen. ");
INSERT INTO deu1951_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Und Rebekka hob ihre Augen auf und sah den Isaak. Da sprang sie vom Kamel ");
INSERT INTO deu1951_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","und sprach zu dem Knecht: Wer ist jener Mann, der uns auf dem Felde entgegenkommt? Der Knecht sprach: Das ist mein Herr! Da nahm sie den Schleier und verhüllte sich. ");
INSERT INTO deu1951_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Und der Knecht erzählte dem Isaak alles, was er ausgerichtet hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Da führte sie Isaak in die Hütte seiner Mutter Sarah und nahm die Rebekka, und sie ward sein Weib, und er gewann sie lieb. Also ward Isaak getröstet nach seiner Mutter Tod. ");
INSERT INTO deu1951_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Und Abraham nahm wieder ein Weib, die hieß Ketura. ");
INSERT INTO deu1951_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Die gebar ihm den Simran und den Jokschan, den Medan und den Midian, den Jischbak und den Schuach. ");
INSERT INTO deu1951_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokschan aber zeugte den Scheba und den Dedan. Die Kinder aber von Dedan waren die Assuriter, Letusiter und Leumiter ");
INSERT INTO deu1951_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","und die Kinder Midians waren Epha, Epher, Hanoch, Abida und Eldaa. Diese alle sind Kinder der Ketura. ");
INSERT INTO deu1951_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Und Abraham gab sein ganzes Gut dem Isaak. ");
INSERT INTO deu1951_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Aber den Kindern, die er von den Kebsweibern hatte, gab er Geschenke und schickte sie von seinem Sohne Isaak hinweg gegen Aufgang in das Morgenland, während er noch lebte. ");
INSERT INTO deu1951_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Dies ist aber die Zahl der Lebensjahre Abrahams: hundertfünfundsiebzig Jahre. ");
INSERT INTO deu1951_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Und Abraham nahm ab und starb in gutem Alter, da er alt und lebenssatt war, und ward zu seinem Volk gesammelt. ");
INSERT INTO deu1951_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Und seine Söhne Isaak und Ismael begruben ihn in der Höhle Machpelah auf dem Acker des Ephron, des Sohnes Zoars, des Hetiters, Mamre gegenüber, ");
INSERT INTO deu1951_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","im Acker, welchen Abraham von den Hetitern gekauft hat. Daselbst sind Abraham und sein Weib Sarah begraben. ");
INSERT INTO deu1951_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Und nach dem Tode Abrahams segnete Gott seinen Sohn Isaak. Und Isaak wohnte bei dem «Brunnen des Lebendigen, der mich sieht». ");
INSERT INTO deu1951_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dies ist das Geschlecht Ismaels, des Sohnes Abrahams, den ihm Hagar, der Sarah ägyptische Magd, gebar. ");
INSERT INTO deu1951_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Und dieses sind die Namen der Kinder Ismaels, davon ihre Geschlechter genannt sind: Der erstgeborne Sohn Ismaels, Nebajoth, dann Kedar, Abdeel, Mibsam, ");
INSERT INTO deu1951_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO deu1951_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jethur, Naphis und Kedma. ");
INSERT INTO deu1951_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Das sind die Kinder Ismaels mit ihren Namen, in ihren Höfen und Zeltlagern, zwölf Fürsten in ihren Geschlechtern. ");
INSERT INTO deu1951_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Und Ismael ward hundertsiebenunddreißig Jahre alt, und er nahm ab und starb und ward zu seinem Volk gesammelt. ");
INSERT INTO deu1951_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Sie wohnten aber von Chavila an bis gen Schur, das vor Ägypten liegt; und bis man nach Assyrien kommt; gegenüber von allen seinen Brüdern ließ er sich nieder. ");
INSERT INTO deu1951_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dies ist die Geschichte Isaaks, des Sohnes Abrahams. Abraham zeugte Isaak. ");
INSERT INTO deu1951_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaak aber war vierzig Jahre alt, da er die Tochter Bethuels, des Syrers von Mesopotamien, die Schwester des Syrers Laban, zum Weibe nahm. ");
INSERT INTO deu1951_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaak aber bat den HERRN für sein Weib, denn sie war unfruchtbar; und der HERR ließ sich von ihm erbitten, und sein Weib Rebekka ward guter Hoffnung. ");
INSERT INTO deu1951_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Und die Kinder stießen sich in ihrem Schoß. Da sprach sie: Wenn es so gehen soll, warum bin ich denn in diesen Zustand gekommen? Und sie ging hin, den HERRN zu fragen. ");
INSERT INTO deu1951_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Und der HERR sprach zu ihr: Zwei Völker sind in deinem Schoß, und zwei Stämme werden sich aus deinen Eingeweiden scheiden, und ein Volk wird dem andern überlegen sein, und der Ältere wird dem Jüngeren dienen. ");
INSERT INTO deu1951_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Da nun die Zeit kam, daß sie gebären sollte, siehe, da waren Zwillinge in ihrem Leibe. ");
INSERT INTO deu1951_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Der erste, der herauskam, war rothaarig, ganz wie ein härenes Kleid, und sie nannte ihn Esau. ");
INSERT INTO deu1951_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Darnach kam sein Bruder heraus, und seine Hand hielt die Ferse Esaus; da nannte sie ihn Jakob. Und Isaak war sechzig Jahre alt, da sie geboren wurden. ");
INSERT INTO deu1951_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Und als die Knaben groß wurden, ward Esau ein Waidmann, der sich auf die Jagd verstand; Jakob aber war ein sittsamer Mann, der bei den Zelten blieb. ");
INSERT INTO deu1951_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Und Isaak hatte Esau lieb, weil ihm das Wildbret mundete; Rebekka aber hatte Jakob lieb. ");
INSERT INTO deu1951_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Und Jakob kochte ein Gericht. Da kam Esau vom Feld und war müde. ");
INSERT INTO deu1951_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Und Esau sprach zu Jakob: Laß mich das rote Gericht versuchen, denn ich bin müde! Daher heißt er Edom. ");
INSERT INTO deu1951_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Aber Jakob sprach: Verkaufe mir heute deine Erstgeburt! ");
INSERT INTO deu1951_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Und Esau sprach zu Jakob: Siehe, ich muß doch sterben; was soll mir die Erstgeburt? ");
INSERT INTO deu1951_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob sprach: So schwöre mir heute! Und er schwur ihm und verkaufte also dem Jakob seine Erstgeburt. ");
INSERT INTO deu1951_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Da gab Jakob dem Esau Brot und das Linsengericht. Und er aß und trank und stand auf und ging davon. Also verachtete Esau die Erstgeburt. ");
INSERT INTO deu1951_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Es kam aber eine Teuerung in das Land; außer der vorigen Teuerung, die zu Abrahams Zeiten gewesen. Und Isaak zog gen Gerar zu Abimelech, dem König der Philister. ");
INSERT INTO deu1951_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Da erschien ihm der HERR und sprach: Reise nicht nach Ägypten hinab, sondern bleib in dem Lande, das ich dir sage! ");
INSERT INTO deu1951_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Sei ein Fremdling in diesem Lande, und ich will mit dir sein und dich segnen; denn dir und deinem Samen will ich dieses ganze Land geben und will den Eid bestätigen, den ich deinem Vater Abraham geschworen habe, ");
INSERT INTO deu1951_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","und will deinen Samen mehren wie die Sterne des Himmels und will deinem Samen das ganze Land geben, und durch deinen Samen sollen alle Völker auf Erden gesegnet werden; ");
INSERT INTO deu1951_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","weil Abraham meiner Stimme gehorsam gewesen und meine Rechte, meine Gebote, meine Sitten und meine Gesetze gehalten hat. ");
INSERT INTO deu1951_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Also wohnte Isaak zu Gerar. ");
INSERT INTO deu1951_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Und da die Leute desselben Ortes nach seinem Weibe fragten, so sprach er: Sie ist meine Schwester. Denn er fürchtete sich zu sagen: Sie ist mein Weib, weil er dachte: Die Leute an diesem Ort möchten mich um Rebekkas willen töten; denn sie war schön von Angesicht. ");
INSERT INTO deu1951_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Da er sich aber längere Zeit daselbst aufhielt, sah Abimelech, der Philister König, durchs Fenster und bemerkte, daß Isaak scherzte mit seinem Weibe Rebekka. ");
INSERT INTO deu1951_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Da rief Abimelech den Isaak und sprach: Siehe, sie ist dein Weib! Wie durftest du sagen: «Sie ist meine Schwester?» Isaak antwortete ihm: Ich dachte, ich möchte vielleicht sterben müssen um ihretwillen. ");
INSERT INTO deu1951_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelech sprach: Warum hast du uns das getan? Wie leicht hätte jemand vom Volk sich zu deinem Weibe legen können, so hättest du eine Schuld auf uns gebracht! ");
INSERT INTO deu1951_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Da gebot Abimelech dem ganzen Volke und sprach: Wer diesen Mann oder sein Weib antastet, der soll des Todes sterben! ");
INSERT INTO deu1951_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Und Isaak säte in dem Lande und erntete in demselben Jahr hundertfältig; denn der HERR segnete ihn. ");
INSERT INTO deu1951_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Und der Mann ward reich und immer reicher, bis er sehr reich war; ");
INSERT INTO deu1951_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","und er hatte Schaf und Rinderherden und eine große Dienerschaft. Darum beneideten ihn die Philister. ");
INSERT INTO deu1951_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Und die Philister verstopften alle Brunnen, die seines Vaters Knechte gegraben hatten zu Abrahams, seines Vaters, Zeiten, und füllten sie mit Erde. ");
INSERT INTO deu1951_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Und Abimelech sprach zu Isaak: Geh fort von uns; denn du bist uns viel zu mächtig geworden! ");
INSERT INTO deu1951_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Da zog Isaak von dannen und lagerte sich im Tale Gerar und wohnte daselbst. ");
INSERT INTO deu1951_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Und Isaak ließ die Wasserbrunnen aufgraben, die sie zu Abrahams, seines Vaters, Zeiten gegraben, und nannte sie mit denselben Namen, mit welchen sein Vater sie benannt hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Auch gruben Isaaks Knechte im Tal und fanden daselbst einen Brunnen lebendigen Wassers. ");
INSERT INTO deu1951_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Aber die Hirten von Gerar zankten mit den Hirten Isaaks und sprachen: Das Wasser gehört uns! Da hieß er den Brunnen Esek, weil sie daselbst sich mit ihm gezankt hatten. ");
INSERT INTO deu1951_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Da gruben sie einen andern Brunnen, um den stritten sie auch; darum hieß er ihn Sithna. ");
INSERT INTO deu1951_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Da brach er von dort auf und grub einen andern Brunnen, um den zankten sie nicht, darum hieß er ihn Rechobot und sprach: Nun hat uns der HERR einen weiten Raum gemacht, daß wir im Lande wachsen können. ");
INSERT INTO deu1951_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Von dort zog er hinauf nach Beerseba. ");
INSERT INTO deu1951_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Und der HERR erschien ihm in derselben Nacht und sprach: Ich bin der Gott deines Vaters Abraham. Fürchte dich nicht! Denn ich bin mit dir, und ich will dich segnen und deinen Samen mehren um Abrahams, meines Knechtes, willen. ");
INSERT INTO deu1951_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Da baute er einen Altar daselbst und rief den Namen des HERRN an und richtete daselbst seine Hütte auf; und Isaaks Knechte gruben daselbst einen Brunnen. ");
INSERT INTO deu1951_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Und Abimelech kam zu ihm von Gerar, mit Achussat, seinem Freund, und Pichol, seinem Feldhauptmann. ");
INSERT INTO deu1951_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aber Isaak sprach zu ihnen: Warum kommt ihr zu mir, da ihr mich doch hasset und mich von euch getrieben habt? ");
INSERT INTO deu1951_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Sie sprachen: Wir haben deutlich gesehen, daß der HERR mit dir ist, darum sprachen wir: Es soll ein Eid zwischen uns sein, zwischen uns und dir, und wir wollen einen Bund mit dir machen, ");
INSERT INTO deu1951_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","daß du uns keinen Schaden zufügest, wie wir dich auch nicht angetastet und dir nur Gutes getan und dich im Frieden haben ziehen lassen. Du bist nun einmal der Gesegnete des HERRN! ");
INSERT INTO deu1951_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Da machte er ihnen ein Mahl, und sie aßen und tranken. ");
INSERT INTO deu1951_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Und am Morgen früh standen sie auf und schwuren einer dem andern. Da ließ Isaak sie gehen, und sie zogen in Frieden von ihm. ");
INSERT INTO deu1951_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","An demselben Tage kamen Isaaks Knechte und sagten ihm von dem Brunnen, den sie gegraben hatten, und sprachen zu ihm: Wir haben Wasser gefunden! ");
INSERT INTO deu1951_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Und er nannte ihn Scheba. Daher heißt der Ort Beer-Scheba bis auf den heutigen Tag. ");
INSERT INTO deu1951_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Als Esau vierzig Jahre alt war, nahm er Weiber, Judith, die Tochter Beris, des Hetiters, und Basmath, die Tochter Elons, des Hetiters; ");
INSERT INTO deu1951_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","die machten Isaak und Rebekka viel Verdruß. ");
INSERT INTO deu1951_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Und es begab sich, als Isaak alt war und seine Augen dunkel wurden, daß er nicht mehr sehen konnte, da rief er Esau, seinen älteren Sohn, und sprach zu ihm: Mein Sohn! Er aber antwortete ihm: Hier bin ich! ");
INSERT INTO deu1951_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Und er sprach: Siehe, ich bin alt und weiß nicht, wann ich sterbe. ");
INSERT INTO deu1951_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","So nimm nun dein Jagdgerät, deinen Köcher und deinen Bogen und geh aufs Feld und jage mir ein Wildbret ");
INSERT INTO deu1951_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","und bereite mir ein schmackhaftes Essen, wie ich es gern habe, und bring mir's herein, daß ich esse, auf daß dich meine Seele segne, ehe denn ich sterbe. ");
INSERT INTO deu1951_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekka aber hörte zu, da Isaak solche Worte zu seinem Sohn Esau sagte. ");
INSERT INTO deu1951_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Während nun Esau aufs Feld ging, ein Wildbret zu jagen, daß er es heimbrächte, ");
INSERT INTO deu1951_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","sprach Rebekka zu ihrem Sohne Jakob: Siehe, ich habe gehört, wie dein Vater mit deinem Bruder Esau redete und sagte: «Bring mir ein Wildbret und bereite mir ein schmackhaftes Gericht, daß ich esse und dich segne vor dem HERRN, vor meinem Tod!» ");
INSERT INTO deu1951_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","So gehorche nun, mein Sohn, meiner Stimme und tue, was ich dich heiße: ");
INSERT INTO deu1951_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Geh hin zur Herde und hole mir von dort zwei gute Ziegenböcklein, daß ich deinem Vater ein schmackhaftes Gericht bereite, wie er es gern hat. ");
INSERT INTO deu1951_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Das sollst du deinem Vater hineintragen, daß er es esse und dich vor seinem Tode segne. ");
INSERT INTO deu1951_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakob aber sprach zu seiner Mutter Rebekka: Siehe, mein Bruder Esau ist rauh, und ich bin glatt. ");
INSERT INTO deu1951_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Vielleicht könnte mein Vater mich betasten, da würde ich in seinen Augen als ein Betrüger erscheinen und brächte so einen Fluch über mich und nicht einen Segen. ");
INSERT INTO deu1951_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Da sprach seine Mutter zu ihm: Dein Fluch sei auf mir, mein Sohn! gehorche du nur meiner Stimme, geh hin und hole es mir! ");
INSERT INTO deu1951_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Da ging er hin und holte es und brachte es seiner Mutter. Und seine Mutter machte ein schmackhaftes Essen, wie es sein Vater gern hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekka nahm auch Esaus, ihres älteren Sohnes, köstliche Kleider, die sie bei sich im Hause hatte, und legte sie Jakob, ihrem jüngeren Sohne, an. ");
INSERT INTO deu1951_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Aber die Felle von den Ziegenböcklein tat sie ihm um die Hände, und wo er am Halse glatt war, ");
INSERT INTO deu1951_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","und gab also das schmackhafte Essen, wie sie es gemacht hatte, und das Brot in ihres Sohnes Jakobs Hand. ");
INSERT INTO deu1951_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Und er kam hinein zu seinem Vater und sprach: Mein Vater! Er antwortete: Hier bin ich! Wer bist du, mein Sohn? ");
INSERT INTO deu1951_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakob sprach zu seinem Vater: Ich bin Esau, dein Erstgeborener; ich habe getan, wie du mir gesagt hast. Stehe auf, setze dich und iß von meinem Wildbret, daß mich deine Seele segne! ");
INSERT INTO deu1951_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaak aber sprach zu seinem Sohn: Mein Sohn, wie hast du es so bald gefunden? Er antwortete: Der HERR, dein Gott, bescherte es mir. ");
INSERT INTO deu1951_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Da sprach Isaak zu Jakob: Tritt herzu, mein Sohn, daß ich dich anrühre, ob du mein Sohn Esau seiest oder nicht! ");
INSERT INTO deu1951_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakob trat zu seinem Vater Isaak. Und als er ihn betastet hatte, sprach er: Die Stimme ist Jakobs Stimme, aber die Hände sind Esaus Hände! ");
INSERT INTO deu1951_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aber er erkannte ihn nicht, denn seine Hände waren rauh, wie die Hände seines Bruders Esau. Und er segnete ihn. ");
INSERT INTO deu1951_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Und er fragte ihn: Bist du mein Sohn Esau? Er antwortete: Ja, ich bin's! ");
INSERT INTO deu1951_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Da sprach er: So bringe mir her, mein Sohn, von deinem Wildbret zu essen, daß dich meine Seele segne! Da brachte er es ihm, und er aß; er reichte ihm auch Wein, und er trank. ");
INSERT INTO deu1951_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Und Isaak, sein Vater, sprach zu ihm: Komm her, mein Sohn, und küsse mich! ");
INSERT INTO deu1951_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Und er trat hinzu und küßte ihn. Und als er den Geruch seiner Kleider roch, segnete er ihn und sprach: Siehe, der Geruch meines Sohnes ist wie ein Geruch des Feldes, das der HERR gesegnet hat. ");
INSERT INTO deu1951_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Gott gebe dir vom Tau des Himmels und vom fettesten Boden und Korn und Most die Fülle; ");
INSERT INTO deu1951_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Völker müssen dir dienen und Geschlechter sich vor dir bücken; sei ein Herr über deine Brüder, und deiner Mutter Kinder müssen sich vor dir bücken. Verflucht sei, wer dir flucht, und gesegnet sei, wer dich segnet! ");
INSERT INTO deu1951_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Als nun Isaak den Segen über Jakob vollendet hatte, und Jakob kaum von seinem Vater Isaak hinausgegangen war, da kam sein Bruder Esau von der Jagd. ");
INSERT INTO deu1951_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Der machte auch ein schmackhaftes Essen und trug es zu seinem Vater hinein und sprach zu ihm: Steh auf, mein Vater, und iß von dem Wildbret deines Sohnes, daß mich deine Seele segne! ");
INSERT INTO deu1951_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Da antwortete ihm sein Vater Isaak: Wer bist du? Er sprach: Ich bin Esau, dein Erstgeborener. ");
INSERT INTO deu1951_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Da entsetzte sich Isaak über die Maßen sehr und sprach: Wer ist denn der Jäger, der ein Wildbret gejagt und mir aufgetragen hat? Ich habe von allem gegessen, ehe du kamst, und habe ihn gesegnet; er wird auch gesegnet bleiben! ");
INSERT INTO deu1951_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Als Esau diese Rede seines Vaters hörte, schrie er laut und ward über die Maßen betrübt und sprach zu seinem Vater: Segne mich auch, mein Vater! ");
INSERT INTO deu1951_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Er aber sprach: Dein Bruder ist mit List gekommen und hat deinen Segen vorweggenommen! ");
INSERT INTO deu1951_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Da sprach er: Er heißt mit Recht Jakob; denn er hat mich nun zweimal überlistet: Meine Erstgeburt hat er weggenommen, und siehe, nun nimmt er auch meinen Segen! Und er sprach: Hast du mir nicht auch einen Segen vorbehalten? ");
INSERT INTO deu1951_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaak antwortete und sprach zu Esau: Siehe, ich habe ihn zum Herrn über dich gesetzt, und alle seine Brüder habe ich ihm zu Knechten gegeben; mit Korn und Most habe ich ihn versehen. Was soll ich nun dir tun, mein Sohn? ");
INSERT INTO deu1951_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau sprach zu seinem Vater: Hast du denn nur einen Segen, mein Vater? Segne mich auch, mein Vater! Und Esau erhob seine Stimme und weinte. ");
INSERT INTO deu1951_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Da antwortete Isaak, sein Vater, und sprach zu ihm: Siehe, ohne fetten Boden wird dein Wohnsitz sein und ohne Tau des Himmels von oben. ");
INSERT INTO deu1951_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Von deinem Schwert wirst du leben und deinem Bruder dienen. Es wird aber geschehen, wenn du dich befreien kannst, daß du sein Joch von deinem Halse reißen wirst. ");
INSERT INTO deu1951_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Und Esau ward dem Jakob feind um des Segens willen, womit sein Vater ihn gesegnet hatte; und Esau sprach in seinem Herzen: Die Zeit, da man um meinen Vater trauern wird, ist nicht mehr weit; dann will ich meinen Bruder Jakob umbringen. ");
INSERT INTO deu1951_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Es wurden aber der Rebekka die Worte Esaus, ihres älteren Sohnes, hinterbracht. Da schickte sie hin und ließ Jakob, ihren jüngeren Sohn, rufen und sprach zu ihm: Siehe, dein Bruder Esau will an dir Rache nehmen und dich töten. ");
INSERT INTO deu1951_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Und nun gehorche meiner Stimme, mein Sohn: Mache dich auf und flieh zu meinem Bruder Laban, nach Haran, ");
INSERT INTO deu1951_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","und bleib eine Zeitlang bei ihm, bis sich deines Bruders Grimm gelegt hat ");
INSERT INTO deu1951_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","und bis sich sein Zorn von dir wendet und er vergißt, was du ihm angetan hast; so will ich dann nach dir schicken und dich von dannen holen lassen. Warum sollte ich euer beider beraubt werden auf einen Tag? ");
INSERT INTO deu1951_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Und Rebekka sprach zu Isaak: Es verdrießt mich zu leben mit den Töchtern Hets; wenn Jakob ein Weib nimmt von den Töchtern Hets, wie diese da, von den Töchtern des Landes, was soll mir das Leben! ");
INSERT INTO deu1951_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Da rief Isaak den Jakob, segnete ihn und gebot ihm und sprach zu ihm: Nimm kein Weib von den Töchtern Kanaans. ");
INSERT INTO deu1951_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mache dich auf und ziehe nach Mesopotamien, in das Haus Bethuels, des Vaters deiner Mutter, und nimm dir von dort ein Weib von den Töchtern Labans, des Bruders deiner Mutter. ");
INSERT INTO deu1951_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Und der allmächtige Gott segne dich und mache dich fruchtbar und mehre dich, daß du zu einer Völkergemeinde werdest, ");
INSERT INTO deu1951_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","und gebe dir den Segen Abrahams, dir und deinem Samen mit dir, daß du besitzest das Land, darin du ein Fremdling bist, das Gott dem Abraham gegeben hat! ");
INSERT INTO deu1951_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Also fertigte Isaak den Jakob ab, daß er nach Mesopotamien zog zu Laban, Bethuels Sohn, dem Syrer, dem Bruder der Rebekka, der Mutter Jakobs und Esaus. ");
INSERT INTO deu1951_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Als nun Esau sah, daß Isaak den Jakob gesegnet und ihn nach Mesopotamien abgefertigt hatte, daß er sich von dort ein Weib hole, und daß er, indem er ihn segnete, ihm gebot und sprach: «Du sollst kein Weib von den Töchtern Kanaans nehmen»; ");
INSERT INTO deu1951_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","und daß Jakob seinem Vater und seiner Mutter gehorsam war und nach Mesopotamien zog; ");
INSERT INTO deu1951_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","als Esau auch sah, daß Isaak, sein Vater, die Töchter Kanaans nicht gerne sah, ");
INSERT INTO deu1951_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","da ging Esau hin zu Ismael und nahm zu seinen Weibern noch Maalath hinzu, die Tochter Ismaels, des Sohnes Abrahams, die Schwester Nebajoths, zum Weibe. ");
INSERT INTO deu1951_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakob aber zog von Beerseba aus und wanderte gen Haran. ");
INSERT INTO deu1951_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Und er kam an einen Ort, wo er über Nacht blieb; denn die Sonne war untergegangen. Und er nahm von den Steinen jenes Orts und legte sie unter sein Haupt und legte sich an dem Ort schlafen. ");
INSERT INTO deu1951_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Und ihm träumte; und siehe, eine Leiter war auf die Erde gestellt, die rührte mit der Spitze an den Himmel. Und siehe, die Engel Gottes stiegen daran auf und nieder. ");
INSERT INTO deu1951_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Und siehe, der HERR stand oben darauf und sprach: Ich bin der HERR, der Gott deines Vaters Abraham und der Gott Isaaks; das Land, darauf du liegst, will ich dir und deinem Samen geben. ");
INSERT INTO deu1951_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Und dein Same soll werden wie der Staub auf Erden, und gegen Abend und Morgen und Mitternacht und Mittag sollst du dich ausbreiten, und durch dich und deinen Samen sollen alle Geschlechter auf Erden gesegnet werden! ");
INSERT INTO deu1951_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Und siehe: Ich bin mit dir, und ich will dich behüten allenthalben, wo du hinziehst, und dich wieder in dieses Land bringen. Denn ich will dich nicht verlassen, bis ich getan, was ich dir gesagt habe. ");
INSERT INTO deu1951_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Da nun Jakob von seinem Schlaf erwachte, sprach er: Gewiß ist der HERR an diesem Ort, und ich wußte es nicht! ");
INSERT INTO deu1951_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Und er fürchtete sich und sprach: Wie heilig ist diese Stätte! Hier ist nichts anderes als Gottes Haus, und dies ist die Pforte des Himmels. ");
INSERT INTO deu1951_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Und Jakob stand am Morgen früh auf und nahm den Stein, den er unter sein Haupt gelegt hatte, und richtete ihn auf zu einer Denksäule und goß Öl oben darauf, ");
INSERT INTO deu1951_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","und nannte diesen Ort Beth-El; zuvor aber hieß die Stadt Lus. ");
INSERT INTO deu1951_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Und Jakob tat ein Gelübde und sprach: Wenn Gott mit mir sein und mich behüten will auf dem Wege, den ich reise, und mir will Brot zu essen geben und Kleider anzuziehen, ");
INSERT INTO deu1951_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","und mich wieder mit Frieden heim zu meinem Vater bringt, so soll der HERR mein Gott sein; ");
INSERT INTO deu1951_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","und dieser Stein, den ich zur Säule aufgerichtet habe, soll ein Haus Gottes werden, und von allem, was du mir gibst, will ich dir den Zehnten geben! ");
INSERT INTO deu1951_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Da machte sich Jakob wieder auf den Weg und ging ins Morgenland. ");
INSERT INTO deu1951_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Und er sah sich um und siehe, da war ein Brunnen auf dem Felde, und siehe, drei Herden Schafe lagen dabei; denn von dem Brunnen mußten die Herden trinken. Und ein großer Stein lag über dem Loch des Brunnens. ");
INSERT INTO deu1951_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Und sie pflegten alle Herden daselbst zu versammeln und den Stein von dem Loch des Brunnens zu wälzen und die Schafe zu tränken, und taten alsdann den Stein wieder an seinen Ort, über das Loch. ");
INSERT INTO deu1951_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Und Jakob sprach zu ihnen: Meine Brüder, woher seid ihr? Sie antworteten: Wir sind von Haran. ");
INSERT INTO deu1951_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Er sprach zu ihnen: Kennt ihr auch Laban, den Sohn Nahors? Sie antworteten: Wir kennen ihn wohl. ");
INSERT INTO deu1951_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Er sprach zu ihnen: Geht es ihm gut? Sie antworteten: Es geht ihm gut; und siehe, da kommt seine Tochter Rahel mit den Schafen! ");
INSERT INTO deu1951_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Er sprach: Siehe, es ist noch hoch am Tag und noch nicht Zeit, das Vieh einzutreiben; tränket die Schafe und gehet hin, weidet sie! ");
INSERT INTO deu1951_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Sie antworteten: Wir können es nicht, ehe alle Herden zusammengebracht sind und sie den Stein von dem Loch des Brunnens wälzen; dann können wir die Schafe tränken. ");
INSERT INTO deu1951_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Als er noch mit ihnen redete, kam Rahel mit ihres Vaters Schafen; denn sie hütete die Schafe. ");
INSERT INTO deu1951_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Als aber Jakob Rahel sah, die Tochter Labans, des Bruders seiner Mutter, trat er hinzu und wälzte den Stein von dem Loch des Brunnens und tränkte die Schafe Labans, des Bruders seiner Mutter. ");
INSERT INTO deu1951_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Und Jakob küßte Rahel und erhob seine Stimme und weinte. ");
INSERT INTO deu1951_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Da sagte Jakob der Rahel, daß er ihres Vaters Bruder und der Rebekka Sohn wäre. Da lief sie und sagte es ihrem Vater. ");
INSERT INTO deu1951_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Als nun Laban die Nachricht von Jakob, seiner Schwester Sohn, hörte, lief er ihm entgegen, umarmte und küßte ihn und führte ihn in sein Haus. Da erzählte er Laban diese ganze Geschichte. ");
INSERT INTO deu1951_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Da sprach Laban zu ihm: Wohlan, du bist mein Gebein und mein Fleisch! Und er blieb bei ihm einen Monat lang. ");
INSERT INTO deu1951_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Darnach sprach Laban zu Jakob: Solltest du mir darum umsonst dienen, weil du mein Neffe bist? Sage an, was soll dein Lohn sein? ");
INSERT INTO deu1951_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban aber hatte zwei Töchter; die ältere hieß Lea und die jüngere Rahel. ");
INSERT INTO deu1951_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Und Lea hatte matte Augen, Rahel aber war schön von Gestalt und schön von Angesicht. ");
INSERT INTO deu1951_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Und Jakob gewann Rahel lieb und sprach: Ich will dir sieben Jahre lang um Rahel, deine jüngere Tochter, dienen. ");
INSERT INTO deu1951_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban antwortete: Es ist besser, ich gebe sie dir, als einem andern Mann; bleibe bei mir! ");
INSERT INTO deu1951_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Also diente Jakob um Rahel sieben Jahre lang, und sie kamen ihm vor wie einzelne Tage, so lieb hatte er sie. ");
INSERT INTO deu1951_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Und Jakob sprach zu Laban: Gib mir mein Weib, daß ich zu ihr komme, denn meine Zeit ist abgelaufen! ");
INSERT INTO deu1951_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Da lud Laban alle Leute des Ortes und machte ein Mahl. ");
INSERT INTO deu1951_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Aber am Abend nahm er seine Tochter Lea und brachte sie zu ihm hinein; und er kam zu ihr. ");
INSERT INTO deu1951_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Und Laban gab seine Magd Silpa seiner Tochter Lea zur Magd. ");
INSERT INTO deu1951_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Am Morgen aber, siehe, da war es Lea! Und er sprach zu Laban: Warum hast du mir das getan? Habe ich dir nicht um Rahel gedient? Warum hast du mich denn betrogen? ");
INSERT INTO deu1951_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban antwortete: Man tut nicht also in unserm Lande, daß man die Jüngere vor der Älteren weggibt. ");
INSERT INTO deu1951_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Halte die Woche aus mit dieser, so wird dir jene auch gegeben, um den Dienst, den du mir noch andere sieben Jahre lang leisten sollst. ");
INSERT INTO deu1951_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakob tat also und hielt die Woche aus. Da gab er ihm Rahel, seine Tochter, zum Weibe. ");
INSERT INTO deu1951_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Und Laban gab seine Magd Bilha seiner Tochter Rahel zur Magd. ");
INSERT INTO deu1951_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Also kam er auch zu Rahel und hatte Rahel lieber denn Lea, und diente ihm noch andere sieben Jahre lang. ");
INSERT INTO deu1951_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Als aber der HERR sah, daß Lea verhaßt war, machte er sie fruchtbar und Rahel unfruchtbar. ");
INSERT INTO deu1951_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Und Lea empfing und gebar einen Sohn, den hieß sie Ruben. Denn sie sprach: Weil der HERR mein Elend angesehen hat, so wird mich nun mein Mann lieben! ");
INSERT INTO deu1951_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Und sie empfing abermal und gebar einen Sohn und sprach: Weil der HERR gehört hat, daß ich verhaßt bin, so hat er mir auch diesen gegeben, und sie hieß ihn Simeon. ");
INSERT INTO deu1951_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Sie empfing abermal und gebar einen Sohn und sprach: Nunmehr wird mein Mann mir anhänglich sein, denn ich habe ihm drei Söhne geboren; darum nannte sie ihn Levi. ");
INSERT INTO deu1951_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Sie empfing wieder und gebar einen Sohn und sprach: Nun will ich den HERRN preisen! Darum hieß sie ihn Juda; und sie hielt inne mit Gebären. ");
INSERT INTO deu1951_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Als aber Rahel sah, daß sie dem Jakob keine Kinder gebar, ward sie eifersüchtig auf ihre Schwester und sprach zu Jakob: Schaffe mir auch Kinder, wo nicht, so sterbe ich. ");
INSERT INTO deu1951_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakob aber ward sehr zornig auf Rahel und sprach: Bin ich denn an Gottes Statt, der dir Leibesfrucht versagt? ");
INSERT INTO deu1951_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Sie aber sprach: Siehe, da ist meine Magd Bilha, komm zu ihr, daß sie in meinen Schoß gebäre, und ich doch durch sie Nachkommen erhalte! ");
INSERT INTO deu1951_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Und sie gab ihm ihre Magd Bilha zum Weibe, und Jakob kam zu ihr. ");
INSERT INTO deu1951_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha aber empfing und gebar dem Jakob einen Sohn. ");
INSERT INTO deu1951_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Da sprach Rahel: Gott hat mir Recht verschafft und meine Stimme erhört und mir einen Sohn gegeben; darum hieß sie ihn Dan. ");
INSERT INTO deu1951_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Und Bilha, die Magd Rahels, empfing abermal und gebar dem Jakob einen zweiten Sohn. ");
INSERT INTO deu1951_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Da sprach Rahel: Ich habe mit meiner Schwester gerungen, als ränge ich mit Gott, und habe auch gewonnen! Darum hieß sie ihn Naphtali. ");
INSERT INTO deu1951_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Als nun Lea sah, daß sie innehielt mit Gebären, nahm sie ihre Magd Silpa und gab sie Jakob zum Weibe. ");
INSERT INTO deu1951_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Und Silpa, Leas Magd, gebar dem Jakob einen Sohn. ");
INSERT INTO deu1951_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Da sprach Lea: Ich habe Glück! und hieß ihn Gad. ");
INSERT INTO deu1951_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Darnach gebar Silpa, Leas Magd, dem Jakob einen zweiten Sohn. ");
INSERT INTO deu1951_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Da sprach Lea: Die Töchter werden mich glücklich preisen! Und sie hieß ihn Asser. ");
INSERT INTO deu1951_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruben aber ging aus zur Zeit der Weizenernte und fand Liebesäpfel auf dem Felde und brachte sie heim zu seiner Mutter Lea. Da sprach Rahel zu Lea: Gib mir einen Teil der Liebesäpfel deines Sohnes! ");
INSERT INTO deu1951_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sie antwortete ihr: Ist das ein Geringes, daß du mir meinen Mann genommen hast? Und willst du auch die Liebesäpfel meines Sohnes nehmen? Rahel sprach: Er soll dafür diese Nacht bei dir schlafen zum Entgelt für die Liebesäpfel deines Sohnes! ");
INSERT INTO deu1951_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Da nun Jakob am Abend vom Felde kam, ging ihm Lea entgegen und sprach: Du sollst zu mir kommen, denn ich habe dich erkauft um die Liebesäpfel meines Sohnes. Und er schlief in jener Nacht bei ihr. ");
INSERT INTO deu1951_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Und Gott erhörte Lea, und sie empfing und gebar dem Jakob den fünften Sohn. ");
INSERT INTO deu1951_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Da sprach Lea: Gott hat mir gelohnt, daß ich meinem Mann meine Magd gegeben habe, und hieß ihn Issaschar. ");
INSERT INTO deu1951_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea empfing abermal und gebar dem Jakob den sechsten Sohn. ");
INSERT INTO deu1951_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Und Lea sprach: Gott hat mich mit einer guten Gabe beschenkt! Nun wird mein Mann wieder bei mir wohnen, denn ich habe ihm sechs Söhne geboren, und sie hieß ihn Sebulon. ");
INSERT INTO deu1951_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Darnach gebar sie eine Tochter, welche sie Dina hieß. ");
INSERT INTO deu1951_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Aber Gott gedachte an Rahel, und Gott erhörte ihr Gebet und machte sie fruchtbar. ");
INSERT INTO deu1951_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Und sie empfing und gebar einen Sohn und sprach: Gott hat meine Schmach von mir genommen! ");
INSERT INTO deu1951_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Und sie hieß ihn Joseph und sprach: Gott wolle mir noch einen Sohn dazu geben! ");
INSERT INTO deu1951_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Da nun Rahel den Joseph geboren hatte, sprach Jakob zu Laban: Entlasse mich, daß ich an meinen Ort und in mein Land ziehe! ");
INSERT INTO deu1951_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Gib mir meine Weiber und Kinder, um welche ich dir gedient habe, daß ich gehen kann! Denn du weißt, welche Dienste ich dir geleistet habe. ");
INSERT INTO deu1951_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban antwortete: Ach, daß ich doch in deinen Augen Gnade fände! Ich habe es geahnt; und doch hat mich der HERR um deinetwillen gesegnet. ");
INSERT INTO deu1951_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Und er sprach: Bestimme mir deinen Lohn, so will ich ihn dir geben! ");
INSERT INTO deu1951_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakob sprach: Du weißt, wie ich dir gedient habe, und was aus deinem Vieh unter meiner Pflege geworden ist. ");
INSERT INTO deu1951_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Denn es war wenig, was du vor meiner Ankunft hattest, nun aber ist viel daraus geworden, und der HERR hat dich gesegnet, wo ich hingekommen bin; und nun, wann soll ich auch für mein Haus sorgen? ");
INSERT INTO deu1951_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Er sprach: Was soll ich dir denn geben? Jakob sprach: Du brauchst mir gar nichts zu geben! Wenn du mir nur tun willst, was ich jetzt sage, so will ich deine Herden wieder weiden. ");
INSERT INTO deu1951_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ich will heute durch alle deine Herden gehen, und du sollst daraus absondern alle gesprenkelten und gefleckten Schafe, auch alle schwarzen Schafe unter den Lämmern und alle gefleckten und gesprenkelten Ziegen; und das soll mein Lohn sein. ");
INSERT INTO deu1951_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","So wird alsdann meine Gerechtigkeit für mich sprechen am künftigen Tag vor deinen Augen, wenn du zu meinem Lohn kommst; alles, was weder gesprenkelt noch gefleckt ist unter den Ziegen und was nicht schwarz ist unter den Lämmern bei mir, das soll als gestohlen gelten. ");
INSERT INTO deu1951_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Da sprach Laban: Gut, es sei so, wie du gesagt hast! ");
INSERT INTO deu1951_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Und er sonderte noch am gleichen Tag die gestreiften und gefleckten Böcke aus und alle gesprenkelten Ziegen, alles, woran etwas Weißes war, und alles, was schwarz war unter den Lämmern, und tat es unter die Hand seiner Söhne. ");
INSERT INTO deu1951_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Und er machte einen Abstand von drei Tagereisen zwischen sich und Jakob; dieser aber weidete die übrigen Schafe Labans. ");
INSERT INTO deu1951_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Da nahm Jakob frische Ruten von Pappeln, Mandel und Platanenbäumen und schälte weiße Streifen dran, indem er das Weiße an den Ruten bloßlegte; ");
INSERT INTO deu1951_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","und legte die Ruten, die er abgeschält hatte, in die Tränkrinnen, wohin die Schafe zum Trinken kamen, gerade vor die Schafe hin. ");
INSERT INTO deu1951_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Wenn sie dann beim Kommen zur Tränke brünstig wurden, so empfingen sie angesichts der Ruten und warfen Gestreifte, Gesprenkelte und Gefleckte. ");
INSERT INTO deu1951_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Die Lämmer aber sonderte Jakob ab und richtete das Angesicht der Schafe gegen die gefleckten und schwarzen in der Herde Labans; und er machte sich besondere Herden und tat sie nicht zu Labans Schafen. ");
INSERT INTO deu1951_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Und jedesmal, wenn die Zeit kam, wo die kräftigen Schafe brünstig wurden, legte Jakob die Ruten in die Tränkrinnen vor die Augen der Schafe, damit sie über den Ruten empfingen; ");
INSERT INTO deu1951_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","wenn aber die Schwachen brünstig wurden, legte er sie nicht hinein. So erhielt Laban die schwachen und Jakob die starken. ");
INSERT INTO deu1951_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Und der Mann wurde außerordentlich reich und bekam viele Schafe, Knechte und Mägde, Kamele und Esel. ");
INSERT INTO deu1951_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Er vernahm aber die Reden der Söhne Labans, die sagten: Jakob hat alles genommen, was unserm Vater gehört; und mit dem, was unserm Vater gehört, hat er all diesen Reichtum zuwege gebracht! ");
INSERT INTO deu1951_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Und Jakob sah, daß Labans Angesicht gegen ihn nicht mehr war wie gestern und vorgestern. ");
INSERT INTO deu1951_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Da sprach der HERR zu Jakob: Kehre in das Land deiner Väter und zu deiner Verwandtschaft zurück; ich will mit dir sein! ");
INSERT INTO deu1951_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Und Jakob ließ Rahel und Lea zu seiner Herde aufs Feld hinaus rufen ");
INSERT INTO deu1951_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","und sprach zu ihnen: Ich sehe, daß eures Vaters Angesicht gegen mich nicht mehr ist wie gestern und vorgestern; aber der Gott meines Vaters ist mit mir. ");
INSERT INTO deu1951_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Und ihr wisset, wie ich eurem Vater gedient habe mit meiner ganzen Kraft. ");
INSERT INTO deu1951_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Euer Vater aber hat mich betrogen und mir meinen Lohn zehnmal verändert; doch hat ihm Gott nicht zugelassen, daß er mir schaden durfte. ");
INSERT INTO deu1951_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sagte er: Die Gesprenkelten sollen dein Lohn sein, so warf die ganze Herde Gesprenkelte; sagte er aber: Die Gestreiften sollen dein Lohn sein, so warf die ganze Herde Gestreifte. ");
INSERT INTO deu1951_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","So hat Gott eurem Vater die Herde entwendet und sie mir gegeben. ");
INSERT INTO deu1951_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Es begab sich nämlich zu der Zeit, wo die Schafe brünstig werden, daß ich meine Augen aufhob und im Traume sah und siehe, die Böcke sprangen auf die gestreiften, gesprenkelten und scheckigen Schafe. ");
INSERT INTO deu1951_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Und der Engel Gottes sprach zu mir im Traum: Jakob! Und ich antwortete: Hier bin ich! ");
INSERT INTO deu1951_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Er aber sprach: Hebe doch deine Augen auf und siehe: Alle Böcke, welche die Schafe bespringen, sind gestreift, gesprenkelt und scheckig! Denn ich habe alles gesehen, was dir Laban antut. ");
INSERT INTO deu1951_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ich bin der Gott von Bethel, wo du die Säule gesalbt und mir ein Gelübde getan hast; nun mache dich auf, geh aus von diesem Land und kehre zurück in das Land deiner Geburt! ");
INSERT INTO deu1951_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Da antworteten Rahel und Lea und sprachen zu ihm: Haben wir auch noch ein Teil oder Erbe im Hause unsres Vaters? ");
INSERT INTO deu1951_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Werden wir nicht von ihm angesehen, als wären wir fremd? Er hat uns ja verkauft und sogar unser Geld verzehrt! ");
INSERT INTO deu1951_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Darum gehört auch all der Reichtum, den Gott unserm Vater entwendet hat, uns und unsern Kindern. So tue du nun alles, was Gott dir gesagt hat! ");
INSERT INTO deu1951_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Da machte sich Jakob auf und lud seine Kinder und seine Weiber auf Kamele ");
INSERT INTO deu1951_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","und führte all sein Vieh weg und seine ganze Habe, die er erworben hatte, seine eigene Herde, die er in Mesopotamien erworben hatte, um zu seinem Vater Isaak ins Land Kanaan zu ziehen. ");
INSERT INTO deu1951_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban aber war ausgegangen, seine Schafe zu scheren; und Rahel stahl die Hausgötzen, die ihrem Vater gehörten. ");
INSERT INTO deu1951_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakob aber täuschte Labans, des Syrers Herz, indem er ihm nicht anzeigte, daß er sich davonmachte. ");
INSERT INTO deu1951_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Und er entfloh mit allem, was er hatte, machte sich auf und setzte über den Euphrat und wandte sein Angesicht dem Gebirge Gilead zu. ");
INSERT INTO deu1951_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Am dritten Tag ward Laban angezeigt, daß Jakob geflohen sei. ");
INSERT INTO deu1951_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Da nahm er seine Brüder mit sich und jagte ihm nach, sieben Tagereisen weit und holte ihn ein auf dem Gebirge Gilead. ");
INSERT INTO deu1951_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Aber Gott kam zu Laban, dem Syrer, des Nachts im Traum und sprach zu ihm: Hüte dich davor, mit Jakob anders als freundlich zu reden! ");
INSERT INTO deu1951_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Als nun Laban den Jakob einholte, hatte Jakob sein Zelt auf dem Berge aufgeschlagen; da schlug auch Laban mit seinen Brüdern sein Zelt auf dem Gebirge Gilead auf. ");
INSERT INTO deu1951_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Und Laban sprach zu Jakob: Warum hast du dich weggestohlen und meine Töchter entführt, als wären sie Kriegsgefangene? ");
INSERT INTO deu1951_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Warum bist du heimlich geflohen und hast mich getäuscht und es mir nicht angezeigt? Ich hätte dich mit Freuden begleitet, mit Gesang, mit Pauken und Harfen! ");
INSERT INTO deu1951_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Du hast mich nicht einmal meine Söhne und Töchter küssen lassen; da hast du töricht gehandelt! ");
INSERT INTO deu1951_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Es stünde in meiner Macht, euch Übles zu tun; aber der Gott eures Vaters hat gestern zu mir gesagt: Hüte dich, daß du mit Jakob anders als freundlich redest! ");
INSERT INTO deu1951_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Und nun bist du ja gegangen, weil du dich so sehr sehntest nach deines Vaters Haus; warum hast du aber meine Götter gestohlen? ");
INSERT INTO deu1951_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Da antwortete Jakob und sprach zu Laban: Ich fürchtete, du würdest mir deine Töchter entreißen! ");
INSERT INTO deu1951_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Was aber deine Götter betrifft, bei welchem du sie findest, der soll nicht am Leben bleiben! In Gegenwart unsrer Brüder sieh dir alles an, was bei mir ist, und nimm, was dir gehört! Jakob wußte nämlich nicht, daß Rahel sie gestohlen hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Da ging Laban in Jakobs Zelt und in Leas Zelt und in das Zelt der beiden Mägde, fand aber nichts. Und von Leas Zelt ging er in Rahels Zelt. ");
INSERT INTO deu1951_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel aber hatte die Hausgötzen genommen und sie in den Kamelssattel gelegt und sich daraufgesetzt. Und Laban durchstöberte das ganze Zelt, fand sie aber nicht. ");
INSERT INTO deu1951_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Da sprach sie zu ihrem Vater: Mein Herr möge nicht so grimmig dreinsehen, weil ich vor dir nicht aufstehen kann; es geht mir eben nach der Frauen Weise! Er aber suchte eifrig und fand die Hausgötzen nicht. ");
INSERT INTO deu1951_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Da ward Jakob zornig und haderte mit Laban; und Jakob antwortete und sprach zu ihm: Was habe ich verbrochen, was habe ich gesündigt, daß du mir so hitzig nachgejagt bist? ");
INSERT INTO deu1951_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Da du nun allen meinen Hausrat durchstöbert hast, was hast du von all deinem Hausrat gefunden? Lege es hier vor meine und deine Brüder, damit sie schlichten zwischen uns! ");
INSERT INTO deu1951_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Diese zwanzig Jahre bin ich bei dir gewesen; deine Mutterschafe und Ziegen wurden nie ihrer Jungen beraubt, und die Widder deiner Herde habe ich nicht gegessen! ");
INSERT INTO deu1951_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Was zerrissen ward, habe ich dir nicht gebracht; ich mußte es ersetzen, du fordertest es von meiner Hand, ob es bei Tag oder bei Nacht gestohlen war. ");
INSERT INTO deu1951_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Des Tages verschmachtete ich vor Hitze und des Nachts vor Frost, und der Schlaf floh meine Augen. ");
INSERT INTO deu1951_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Diese zwanzig Jahre lang habe ich dir in deinem Hause gedient, vierzehn Jahre um deine beiden Töchter und sechs Jahre um deine Schafe, und du hast mir meinen Lohn zehnmal verändert! ");
INSERT INTO deu1951_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Wenn nicht der Gott meines Vaters, der Gott Abrahams und der Gefürchtete Isaaks für mich gewesen wäre, du hättest mich jetzt leer ziehen lassen; aber Gott hat mein Elend und die Arbeit meiner Hände angesehen und dich diese Nacht gestraft! ");
INSERT INTO deu1951_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban antwortete und sprach: Die Töchter sind meine Töchter und die Kinder sind meine Kinder und die Herden sind meine Herden, und alles, was du siehst, ist mein! Was kann ich nun heute diesen meinen Töchtern oder ihren Kindern tun, die sie geboren haben? ");
INSERT INTO deu1951_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Komm, wir wollen nun einen Bund machen, ich und du; der soll ein Zeuge sein zwischen mir und dir! ");
INSERT INTO deu1951_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Da nahm Jakob einen Stein und stellte ihn als Denkmal auf. ");
INSERT INTO deu1951_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Und Jakob sprach zu seinen Brüdern: Sammelt Steine! Da nahmen sie Steine und machten einen Wall und aßen daselbst auf dem Wall. ");
INSERT INTO deu1951_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Und Laban nannte ihn Jegar-Sahaduta; Jakob aber hieß ihn Galed. ");
INSERT INTO deu1951_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Und Laban sprach: dieser Wall sei heute Zeuge zwischen mir und dir; darum wird er Galed genannt ");
INSERT INTO deu1951_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","und Mizpa, indem er sprach: Der HERR wache zwischen mir und dir, wenn wir einander nicht mehr sehen! ");
INSERT INTO deu1951_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Wenn du meine Töchter mißhandelst und wenn du zu meinen Töchtern hinzu andere Frauen nimmst und kein Mensch dazwischen tritt, siehe, so ist doch Gott Zeuge zwischen mir und dir! ");
INSERT INTO deu1951_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Weiter sprach Laban zu Jakob: Siehe, dieser Wall und dieses Denkmal, das ich errichtet habe zwischen mir und dir ");
INSERT INTO deu1951_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","dieser Wall sei Zeuge und dieses Denkmal ein Zeugnis dafür, daß ich niemals über diesen Wall hinaus zu dir kommen will und daß auch du niemals in böser Absicht über diesen Wall oder über dieses Denkmal hinaus zu mir kommen sollst. ");
INSERT INTO deu1951_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Der Gott Abrahams und der Gott Nahors sei Richter zwischen uns, der Gott ihrer Väter! Jakob aber schwur bei der Furcht seines Vaters Isaak. ");
INSERT INTO deu1951_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Und Jakob brachte ein Opfer auf dem Berge und lud seine Brüder ein zu essen; und sie aßen und übernachteten auf dem Berg. ");
INSERT INTO deu1951_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Und Laban stand am Morgen früh auf, küßte seine Söhne und Töchter, segnete sie, ging und kehrte wieder an seinen Ort zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakob aber ging seines Weges; da begegneten ihm Engel Gottes. ");
INSERT INTO deu1951_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Und als er sie sah, sprach Jakob: Das ist das Heerlager Gottes! Und er nannte jenen Ort Mahanaim. ");
INSERT INTO deu1951_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Und Jakob sandte Boten vor sich her zu seinem Bruder Esau ins Land Seir, das Gefilde Edom. ");
INSERT INTO deu1951_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Diesen gebot er und sprach: Also sollt ihr zu meinem Herrn Esau sagen: Solches läßt dir dein Knecht Jakob melden: Ich bin bei Laban in der Fremde gewesen und habe mich bisher bei ihm aufgehalten; ");
INSERT INTO deu1951_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","und ich habe Rinder, Esel und Schafe, Knechte und Mägde bekommen und lasse dir solches anzeigen, damit ich Gnade vor deinen Augen finde. ");
INSERT INTO deu1951_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Die Boten kehrten wieder zu Jakob zurück und berichteten ihm: Wir sind zu deinem Bruder Esau gekommen; der zieht dir auch entgegen und vierhundert Mann mit ihm! ");
INSERT INTO deu1951_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Da fürchtete sich Jakob sehr und es ward ihm bange; und er teilte das Volk, das bei ihm war, und die Schafe, Rinder und Kamele in zwei Lager; ");
INSERT INTO deu1951_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","denn er sprach: Wenn Esau gegen das eine Lager kommt und es schlägt, so kann doch das andere entrinnen. ");
INSERT INTO deu1951_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Und Jakob sprach: Gott meines Vaters Abraham und Gott meines Vaters Isaak, HERR, der du zu mir gesagt hast: Kehre wieder in dein Land und zu deiner Verwandtschaft zurück; ich will dir wohltun! ");
INSERT INTO deu1951_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ich bin zu gering aller Barmherzigkeit und Treue, die du an deinem Knechte bewiesen hast! Denn ich hatte nur einen Stab, als ich über diesen Jordan ging, und nun bin ich zu zwei Heeren geworden. ");
INSERT INTO deu1951_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Errette mich doch aus der Hand meines Bruders, aus der Hand Esaus; denn ich fürchte ihn; er könnte kommen und mich schlagen, die Mutter samt den Kindern! ");
INSERT INTO deu1951_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Du aber hast gesagt: Ich will dir wohltun und deinen Samen machen wie den Sand am Meere, der vor Menge nicht zu zählen ist! ");
INSERT INTO deu1951_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Und er brachte die Nacht daselbst zu und nahm von dem, was ihm in die Hände kam, als Geschenk für seinen Bruder Esau: ");
INSERT INTO deu1951_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","zweihundert Ziegen, zwanzig Böcke, zweihundert Schafe, zwanzig Widder, ");
INSERT INTO deu1951_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","dreißig säugende Kamele mit ihren Füllen, vierzig Kühe und zehn Stiere, zwanzig Eselinnen und zehn Eselsfüllen. ");
INSERT INTO deu1951_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Und er gab sie in die Hand seiner Knechte, eine jegliche Herde besonders, und sprach zu seinen Knechten: Geht vor mir hinüber und lasset Raum zwischen den einzelnen Herden! ");
INSERT INTO deu1951_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Und er befahl dem ersten und sprach: Wenn mein Bruder Esau dir begegnet und dich fragt: Wem gehörst du und wo willst du hin und wem gehört das, was du vor dir her treibst? ");
INSERT INTO deu1951_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","So sollst du antworten: Deinem Knecht Jakob! Es ist ein Geschenk, das er seinem Herrn Esau sendet, und siehe, er kommt selbst hinter uns her. ");
INSERT INTO deu1951_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Desgleichen befahl er auch dem zweiten und dem dritten und allen, die hinter den Herden hergingen, und sprach: So sollt ihr mit Esau reden, wenn ihr ihn antrefft; ");
INSERT INTO deu1951_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","und ihr sollt sagen: Siehe, dein Knecht Jakob kommt auch hinter uns her! Denn er gedachte: Ich will sein Angesicht versöhnen mit dem Geschenk, das vor mir hergeht; darnach will ich sein Angesicht sehen; vielleicht wird er mich gnädig ansehen. ");
INSERT INTO deu1951_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Und das Geschenk zog vor ihm hinüber; er aber blieb in jener Nacht im Lager. ");
INSERT INTO deu1951_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Er stand aber noch in derselben Nacht auf und nahm seine beiden Weiber und seine beiden Mägde samt seinen elf Kindern und überschritt mit ihnen die Furt Jabbok; ");
INSERT INTO deu1951_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","er nahm sie und führte sie über den Fluß und ließ alles, was er hatte, hinübergehen. ");
INSERT INTO deu1951_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jakob aber blieb allein zurück. Da rang ein Mann mit ihm, bis die Morgenröte anbrach. ");
INSERT INTO deu1951_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Und da dieser sah, daß er ihn nicht übermochte, schlug er ihn auf das Hüftgelenk, so daß Jakobs Hüftgelenk verrenkt ward über dem Ringen mit ihm. ");
INSERT INTO deu1951_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Und der Mann sprach: Laß mich gehen; denn die Morgenröte bricht an! Jakob aber sprach: Ich lasse dich nicht, du segnest mich denn! ");
INSERT INTO deu1951_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Da fragte er ihn: Wie heißest du? Er antwortete: Jakob! ");
INSERT INTO deu1951_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Da sprach er: Du sollst nicht mehr Jakob heißen, sondern Israel; denn du hast mit Gott und Menschen gekämpft und hast gewonnen! ");
INSERT INTO deu1951_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakob aber bat und sprach: Tue mir doch deinen Namen kund! Er aber antwortete: Warum fragst du nach meinem Namen? Und er segnete ihn daselbst. ");
INSERT INTO deu1951_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakob aber nannte den Ort Pniel; denn er sprach: Ich habe Gott von Angesicht zu Angesicht gesehen, und meine Seele ist gerettet worden! ");
INSERT INTO deu1951_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Und die Sonne ging ihm auf, als er an Pniel vorüberzog; und er hinkte wegen seiner Hüfte. ");
INSERT INTO deu1951_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Darum essen die Kinder Israel bis auf den heutigen Tag die Sehne nicht, welche über das Hüftgelenk läuft, weil er Jakobs Hüftgelenk, die Hüftensehne, geschlagen hat. ");
INSERT INTO deu1951_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Und Jakob erhob seine Augen und schaute, und siehe, Esau kam und vierhundert Mann mit ihm. Da verteilte er die Kinder zu Lea und zu Rahel und zu den beiden Mägden. ");
INSERT INTO deu1951_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Und er stellte die Mägde mit ihren Kindern voran, und Lea mit ihren Kindern hernach, und Rahel mit Joseph zuletzt. ");
INSERT INTO deu1951_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Er selbst aber ging ihnen voraus und verneigte sich siebenmal zur Erde, bis er nahe zu seinem Bruder kam. ");
INSERT INTO deu1951_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Da lief ihm Esau entgegen, umarmte ihn, fiel ihm um den Hals und küßte ihn; und sie weinten. ");
INSERT INTO deu1951_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Als aber Esau seine Augen erhob, sah er die Weiber und die Kinder und sprach: Gehören diese dir? Er antwortete: Es sind die Kinder, mit welchen Gott deinen Knecht begnadigt hat. ");
INSERT INTO deu1951_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Da traten die Mägde herzu samt ihren Kindern und verneigten sich. ");
INSERT INTO deu1951_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Auch Lea kam herbei mit ihren Kindern, und sie verneigten sich; darnach kam Joseph mit Rahel herbei, und auch sie verneigten sich. ");
INSERT INTO deu1951_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Und er fragte: Was willst du denn mit jenem ganzen Heer, dem ich begegnet bin? Jakob antwortete: Ich wollte Gnade finden in den Augen meines Herrn! ");
INSERT INTO deu1951_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau antwortete: Ich habe genug, mein Bruder; behalte, was du hast! ");
INSERT INTO deu1951_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakob antwortete: O nein! Habe ich Gnade vor deinen Augen gefunden, so nimm doch das Geschenk an von meiner Hand; denn deshalb habe ich dein Angesicht gesehen, als sähe ich Gottes Antlitz, und du warst so freundlich gegen mich! ");
INSERT INTO deu1951_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nimm doch den Segen von mir an, der dir überbracht worden ist; denn Gott hat mich begnadigt und ich bin mit allem versehen. Also drang er in ihn, daß er es annahm. ");
INSERT INTO deu1951_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Und Esau sprach: Laß uns aufbrechen und gehen; ich will neben dir herziehen. ");
INSERT INTO deu1951_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Er aber antwortete: Mein Herr weiß, daß die Kinder noch zart sind; dazu habe ich säugende Schafe und Kühe bei mir; wenn sie einen einzigen Tag übertrieben würden, so würde mir die ganze Herde sterben. ");
INSERT INTO deu1951_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mein Herr gehe doch seinem Knechte voraus, ich aber will gemächlich hintennach ziehen, wie eben das Vieh vor mir her und die Kinder gehen mögen, bis ich zu meinem Herrn nach Seir komme. ");
INSERT INTO deu1951_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Da sprach Esau: So will ich doch etliche von meinen Leuten bei dir lassen. Er sprach: Warum sollte ich solche Gunst finden vor den Augen meines Herrn! ");
INSERT INTO deu1951_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Also kehrte Esau am gleichen Tag wieder nach Seir zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jakob aber brach auf nach Sukkot und baute sich daselbst ein Haus und errichtete für seine Herden Schutzhütten; daher wurde der Ort Sukkot genannt. ");
INSERT INTO deu1951_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Und Jakob kam wohlbehalten bis zur Stadt Sichem, die im Lande Kanaan liegt, nachdem er aus Mesopotamien gekommen war; und er lagerte sich der Stadt gegenüber. ");
INSERT INTO deu1951_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Und er kaufte das Grundstück, auf welchem er sein Zelt aufschlug, von der Hand der Kinder Hemors, des Vaters Sichems, um hundert Kesitha ");
INSERT INTO deu1951_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","und errichtete daselbst einen Altar; den nannte er «Der starke Gott Israels». ");
INSERT INTO deu1951_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina aber, Leas Tochter, welche sie dem Jakob geboren hatte, ging aus, um die Töchter des Landes zu sehen. ");
INSERT INTO deu1951_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Als nun Sichem, der Sohn Hemors, des hevitischen Landesfürsten, sie sah, nahm er sie und tat ihr Gewalt an. ");
INSERT INTO deu1951_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Und er wurde anhänglich an Dina, die Tochter Jakobs, und gewann das Mädchen lieb und redete ihr zu. ");
INSERT INTO deu1951_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Und Sichem sprach zu seinem Vater Hemor: Nimm mir dieses Mägdlein zum Weibe! ");
INSERT INTO deu1951_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakob aber hatte vernommen, daß man seine Tochter Dina entehrt hatte; weil aber seine Söhne beim Vieh auf dem Felde waren, so schwieg er, bis sie kamen. ");
INSERT INTO deu1951_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Inzwischen kam Hemor, Sichems Vater, zu Jakob, um mit ihm zu reden. ");
INSERT INTO deu1951_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Als aber die Söhne Jakobs solches hörten, kamen sie vom Felde; und die Männer waren schwer beleidigt und sehr entrüstet, daß man eine solche Schandtat an Israel begangen und Jakobs Tochter beschlafen hatte; denn so pflegte man nicht zu tun. ");
INSERT INTO deu1951_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hemor aber redete mit ihnen und sprach: Mein Sohn Sichem hängt an eurer Tochter; gebt sie ihm doch zum Weibe! ");
INSERT INTO deu1951_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Verschwägert euch mit uns; gebt uns eure Töchter und nehmt ihr unsere Töchter! ");
INSERT INTO deu1951_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Bleibt bei uns; das Land soll euch offenstehen; siedelt euch an, bewegt euch frei darin und erwerbt Grundbesitz! ");
INSERT INTO deu1951_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Und Sichem sprach zu ihrem Vater und zu ihren Brüdern: Laßt mich Gnade finden vor euren Augen; was ihr von mir fordert, das will ich geben! ");
INSERT INTO deu1951_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mögt ihr von mir noch so viel Morgengabe und Geschenke verlangen, ich will es geben, sobald ihr es fordert; gebt mir nur das Mädchen zum Weibe! ");
INSERT INTO deu1951_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Da antworteten die Söhne Jakobs dem Sichem und seinem Vater Hemor in trügerischer Weise, weil er ihre Schwester Dina entehrt hatte, ");
INSERT INTO deu1951_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","und sprachen zu ihnen: Wir können das nicht tun, daß wir unsre Schwester einem unbeschnittenen Manne geben; denn das wäre eine Schande für uns; ");
INSERT INTO deu1951_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","nur unter einer Bedingung können wir euch willfahren, daß ihr nämlich werdet wie wir, indem ihr alles, was männlich ist, beschneiden lasset. ");
INSERT INTO deu1951_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Dann wollen wir euch unsre Töchter geben und uns eure Töchter nehmen und mit euch zusammenwohnen und zu einem Volke werden. ");
INSERT INTO deu1951_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Wollt ihr uns aber nicht gehorchen, daß ihr euch beschneiden lasset, so nehmen wir unsere Tochter und gehen! ");
INSERT INTO deu1951_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ihre Rede gefiel Hemor und seinem Sohne Sichem wohl; ");
INSERT INTO deu1951_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","und der Jüngling zögerte nicht, solches zu tun; denn er hatte Lust zu der Tochter Jakobs und war der Angesehenste von seines Vaters Hause. ");
INSERT INTO deu1951_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Als nun Hemor und sein Sohn Sichem zum Tor ihrer Stadt kamen, redeten sie mit den Bürgern ihrer Stadt und sprachen: ");
INSERT INTO deu1951_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Diese Leute meinen es gut mit uns; sie sollen im Lande wohnen und verkehren! Hat doch das Land Raum genug für sie. Wir wollen uns ihre Töchter zu Weibern nehmen und ihnen unsre Töchter geben. ");
INSERT INTO deu1951_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nur das verlangen sie von uns, wenn sie unter uns wohnen und sich mit uns zu einem Volke verschmelzen sollen, daß wir alles, was männlich ist unter uns, beschneiden, gleichwie auch sie beschnitten sind. ");
INSERT INTO deu1951_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ihre Herden und ihre Habe und all ihr Vieh werden dann unser sein; lasset uns ihnen nur willfahren, damit sie bei uns bleiben! ");
INSERT INTO deu1951_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Da gehorchten dem Hemor und seinem Sohne Sichem alle, die im Tore seiner Stadt aus und eingingen. ");
INSERT INTO deu1951_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Es begab sich aber am dritten Tag, da sie wundkrank waren, daß die beiden Söhne Jakobs, Simeon und Levi, Dinas Brüder, ein jeder sein Schwert nahmen und unversehens in die Stadt eindrangen und alles Männliche umbrachten. ");
INSERT INTO deu1951_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Auch Hemor und dessen Sohn Sichem töteten sie mit des Schwertes Schärfe und holten Dina aus dem Hause Sichems und verließen die Stadt. ");
INSERT INTO deu1951_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Die Söhne Jakobs aber fielen über die Erschlagenen her und plünderten die Stadt, weil man ihre Schwester entehrt hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ihre Schafe, Rinder und Esel nahmen sie, samt allem, was in der Stadt und auf dem Felde war; ");
INSERT INTO deu1951_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","dazu führten sie ihre ganze Habe, alle ihre Kinder und Weiber gefangen und raubten alles, was in den Häusern war. ");
INSERT INTO deu1951_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jakob aber sprach zu ihnen: Ihr bringt mich ins Unglück dadurch, daß ihr mich verhaßt macht bei den Einwohnern des Landes, bei den Kanaanitern und Pheresitern, da ich doch nur wenig Leute habe; sie aber werden sich wider mich sammeln und mich schlagen und mich vertilgen samt meinem Haus. ");
INSERT INTO deu1951_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Sie aber antworteten: Soll man denn unsere Schwester wie eine Dirne behandeln? ");
INSERT INTO deu1951_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Und Gott sprach zu Jakob: Mache dich auf, ziehe hinauf nach Bethel und wohne daselbst und baue dort einen Altar dem Gott, der dir erschienen ist, da du vor deinem Bruder Esau flohest! ");
INSERT INTO deu1951_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Da sprach Jakob zu seinem Haus und zu allen, die bei ihm waren: Tut von euch weg die fremden Götter, die unter euch sind, und reinigt euch und wechselt eure Kleider! ");
INSERT INTO deu1951_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","So wollen wir uns aufmachen und nach Bethel hinaufziehen, daß ich daselbst einen Altar errichte dem Gott, der mir geantwortet hat zur Zeit meiner Not, und der mit mir gewesen ist auf dem Wege, den ich gezogen bin! ");
INSERT INTO deu1951_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Da lieferten sie Jakob alle fremden Götter aus, die in ihren Händen waren, samt den Ringen, die sie an ihren Ohren trugen, und Jakob verbarg sie unter der Eiche, die bei Sichem steht. ");
INSERT INTO deu1951_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Darnach brachen sie auf; und der Schrecken Gottes fiel auf die umliegenden Städte, daß sie die Söhne Jakobs nicht verfolgten. ");
INSERT INTO deu1951_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Als nun Jakob nach Lus kam, das im Lande Kanaan liegt (das ist Bethel), er und alles Volk, das bei ihm war, ");
INSERT INTO deu1951_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","baute er daselbst einen Altar und nannte den Ort «El-Bethel», weil sich Gott ihm daselbst geoffenbart hatte, als er vor seinem Bruder floh. ");
INSERT INTO deu1951_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Da starb Debora, die Amme der Rebekka, und ward begraben unterhalb von Bethel, unter der Eiche, die man Klageeiche nennt. ");
INSERT INTO deu1951_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Und Gott erschien Jakob zum zweitenmal, seitdem er aus Mesopotamien gekommen war, und segnete ihn. ");
INSERT INTO deu1951_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Und Gott sprach zu ihm: Dein Name ist Jakob, aber du sollst nicht mehr Jakob heißen, sondern Israel soll dein Name sein! Und so nannte er sich Israel. ");
INSERT INTO deu1951_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Und Gott sprach zu ihm: Ich bin der allmächtige Gott, sei fruchtbar und mehre dich! Ein Volk und eine Völkergemeinde soll von dir kommen, und Könige sollen aus deinen Lenden hervorgehen; ");
INSERT INTO deu1951_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","das Land aber, das ich Abraham und Isaak gegeben habe, das will ich dir und deinem Samen nach dir geben! ");
INSERT INTO deu1951_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Und Gott fuhr auf von ihm an dem Ort, da er mit ihm geredet hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Da richtete Jakob eine Säule auf an dem Ort, wo er mit ihm geredet hatte, einen Denkstein, und goß ein Trankopfer darauf aus und schüttete Öl darüber; ");
INSERT INTO deu1951_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","und Jakob nannte den Ort, wo Gott mit ihm geredet hatte, Bethel. ");
INSERT INTO deu1951_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Darnach brachen sie von Bethel auf; und als sie nur noch ein Stück Weges bis Ephrata zu gehen hatten, gebar Rahel; und sie hatte eine schwere Geburt. ");
INSERT INTO deu1951_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Als ihr aber die Geburt so schwer fiel, sprach die Geburtshelferin: Fürchte dich nicht; du hast auch diesmal einen Sohn! ");
INSERT INTO deu1951_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Als ihr aber die Seele entschwand, weil sie am Sterben war, nannte sie seinen Namen Benoni; sein Vater aber nannte ihn Benjamin. ");
INSERT INTO deu1951_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Und Rahel starb und ward begraben am Wege nach Ephrata, das ist Bethlehem. ");
INSERT INTO deu1951_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Und Jakob stellte eine Denksäule auf über ihrem Grab; das ist Rahels Grabmal geblieben bis auf diesen Tag. ");
INSERT INTO deu1951_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Und Israel zog weiter und schlug sein Zelt jenseits des Herdenturmes auf. ");
INSERT INTO deu1951_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Es begab sich aber, während Israel in dem Lande wohnte, daß Ruben sich mit seines Vaters Kebsweib Bilha verging; und Israel vernahm es. ");
INSERT INTO deu1951_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jakob aber hatte zwölf Söhne. Die Söhne Leas waren diese: Ruben, der erstgeborne Sohn Jakobs, Simeon, Levi, Juda, Issaschar und Sebulon; ");
INSERT INTO deu1951_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","die Söhne Rahels waren Joseph und Benjamin; ");
INSERT INTO deu1951_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","die Söhne Bilhas, Rahels Magd: Dan und Naphtali; ");
INSERT INTO deu1951_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","die Söhne Silpas, Leas Magd: Gad und Asser. Das sind die Söhne Jakobs, die ihm in Mesopotamien geboren wurden. ");
INSERT INTO deu1951_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Und Jakob kam zu seinem Vater Isaak gen Mamre, bei Kirjath-Arba, das ist Hebron, woselbst Abraham und Isaak Fremdlinge gewesen sind. ");
INSERT INTO deu1951_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Und Isaak ward hundertundachtzig Jahre alt. ");
INSERT INTO deu1951_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Und Isaak nahm ab, starb und ward zu seinem Volk versammelt, alt und lebenssatt; und seine Söhne Esau und Jakob begruben ihn. ");
INSERT INTO deu1951_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dies ist das Geschlecht Esaus, welcher Edom heißt. ");
INSERT INTO deu1951_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau nahm seine Weiber von den Töchtern Kanaans: Ada, die Tochter Elons, des Hetiters, und Oholibama, die Tochter der Ana, der Tochter Zibeons, des Heviters; ");
INSERT INTO deu1951_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","dazu Basmath, die Tochter Ismaels, Nebajots Schwester. ");
INSERT INTO deu1951_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Und Ada gebar dem Esau den Eliphas. Aber Basmath gebar den Reguel. ");
INSERT INTO deu1951_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama gebar Jehusch und Jaelam und Korah. Das sind die Söhne Esaus, welche ihm im Lande Kanaan geboren wurden. ");
INSERT INTO deu1951_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Und Esau nahm seine Weiber und seine Söhne und seine Töchter und alle Seelen seines Hauses, auch seine Habe und all sein Vieh und alle Güter, die er im Lande Kanaan erworben hatte, und zog von seinem Bruder Jakob weg in ein anderes Land. ");
INSERT INTO deu1951_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Denn ihre Habe war zu groß, daß sie nicht beieinander wohnen konnten; und das Land, darin sie Fremdlinge waren, mochte sie nicht ertragen wegen ihrer Herden. ");
INSERT INTO deu1951_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Also wohnte Esau auf dem Gebirge Seir; Esau ist der Edom. ");
INSERT INTO deu1951_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dies ist das Geschlecht Esaus, der ein Vater ist der Edomiter auf dem Gebirge Seir. ");
INSERT INTO deu1951_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Und also hießen die Söhne Esaus: Eliphas, der Sohn Anas, des Weibes Esaus; Reguel, der Sohn Basmaths, des Weibes Esaus; ");
INSERT INTO deu1951_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Eliphas Söhne aber waren diese: Teman, Omar, Zepho, Gaetam und Kenas. ");
INSERT INTO deu1951_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Und Timna war ein Kebsweib Eliphas, des Sohnes Esaus, die gebar dem Eliphas den Amalek. Das sind die Kinder von Ada, dem Weibe Esaus. ");
INSERT INTO deu1951_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Aber die Kinder Reguels sind diese: Nahath, Serah, Schamma und Missa. Das sind die Kinder von Basmath, dem Weibe Esaus. ");
INSERT INTO deu1951_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Die Kinder aber von Oholibama, dem Weibe Esaus, der Tochter der Ana, der Tochter Zibeons, die sie Esau gebar, sind diese: Jehusch, Jaelam und Korah. ");
INSERT INTO deu1951_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Das sind die Fürsten unter den Söhnen Esaus. Die Söhne Eliphas, des ersten Sohnes Esaus, waren diese: Der Fürst Teman, der Fürst Omar, der Fürst Zepho, der Fürst Kenas, ");
INSERT INTO deu1951_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","der Fürst Korah, der Fürst Gaetam, der Fürst Amalek. Das sind die Fürsten von Eliphas im Lande Edom und sind Söhne der Ada. ");
INSERT INTO deu1951_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Und das sind die Kinder Reguels, des Sohnes Esaus: Der Fürst Nahat, der Fürst Serah, der Fürst Schamma, der Fürst Missa. Das sind die Fürsten von Reguel im Lande Edom und die Söhne der Basmath, des Weibes Esaus. ");
INSERT INTO deu1951_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Dies sind die Söhne Oholibamas, des Weibes Esaus: Der Fürst Jehusch, der Fürst Jaelam, der Fürst Korah. Das sind die Fürsten von Oholibama, der Tochter der Ana, des Weibes Esaus. ");
INSERT INTO deu1951_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Das sind die Kinder Esaus und ihre Fürsten. Er ist der Edom. ");
INSERT INTO deu1951_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Die Söhne Seirs aber, des Horiters, die im Lande wohnten, sind diese: Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO deu1951_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Ezer und Disan. Das sind die Fürsten der Horiter, Kinder des Seir im Lande Edom. ");
INSERT INTO deu1951_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Aber Lotans Kinder waren diese: Hori und Hemam; und Lotans Schwester hieß Timna. ");
INSERT INTO deu1951_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Die Söhne Sobals waren diese: Alwan, Manabath, Ebal, Sepho und Onam. ");
INSERT INTO deu1951_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Die Söhne Zibeons waren: Aja und Ana. Das ist Ana, der in der Wüste die heißen Quellen fand, als er die Esel seines Vaters Zibeon hütete. ");
INSERT INTO deu1951_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Die Kinder Anas waren: Dison und Oholibama, diese ist die Tochter Anas. ");
INSERT INTO deu1951_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Die Söhne Disons waren: Hemdan, Esban, Jithran und Cheran. ");
INSERT INTO deu1951_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Die Söhne Ezers waren: Bilhan, Saewan und Akan. ");
INSERT INTO deu1951_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Die Söhne Disans waren: Uz und Aran. ");
INSERT INTO deu1951_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Das sind die Fürsten der Horiter: Der Fürst Lotan, der Fürst Sobal, der Fürst Zibeon, der Fürst Ana, ");
INSERT INTO deu1951_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","der Fürst Dison, der Fürst Ezer, der Fürst Disan. Das sind die Fürsten der Horiter nach ihren Fürstentümern im Lande Seir. ");
INSERT INTO deu1951_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Die Könige aber, welche im Lande Edom regiert haben, ehe ein König über die Kinder Israel regierte, sind diese: ");
INSERT INTO deu1951_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, ein Sohn Beors, war König in Edom, und seine Stadt hieß Dinhaba. ");
INSERT INTO deu1951_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Und als Bela starb, ward an seiner Statt König: Jobab, ein Sohn Serahs aus Bozra. ");
INSERT INTO deu1951_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Als Jobab starb, ward Husam aus der Temaniter Land König an seiner Statt. ");
INSERT INTO deu1951_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Als Husam starb, ward an seiner Statt König: Hadad, ein Sohn Bedads, welcher die Midianiter auf der Moabiter Gefilde schlug; und seine Stadt hieß Awith. ");
INSERT INTO deu1951_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Als Hadad starb, ward Samla von Masreka König an seiner Statt. ");
INSERT INTO deu1951_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Als Samla starb, ward Saul von Rechobot am Flusse König an seiner Statt. ");
INSERT INTO deu1951_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Als Saul starb, ward Baal-Hanan, ein Sohn Achbors, König an seiner Statt. ");
INSERT INTO deu1951_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Als Baal-Hanan, Achbors Sohn, starb, ward Hadar König an seiner Statt; und seine Stadt hieß Pahu, sein Weib hieß Mehethabeel; eine Tochter der Mathred, der Tochter Mezahabs. ");
INSERT INTO deu1951_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Also hießen die Fürsten von Esau nach ihren Geschlechtern, Orten und Namen: Der Fürst Timna, der Fürst Alwa, der Fürst Jetet, ");
INSERT INTO deu1951_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","der Fürst Oholibama, der Fürst Ela, der Fürst Pinon, ");
INSERT INTO deu1951_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","der Fürst Kenas, der Fürst Teman, der Fürst Mibzar, ");
INSERT INTO deu1951_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","der Fürst Magdiel, der Fürst Iram. Das sind die Fürsten in Edom, wie sie im Lande ihrer Besitzung gewohnt haben. Und Esau ist der Vater der Edomiter. ");
INSERT INTO deu1951_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob aber wohnte im Lande, darin sein Vater ein Fremdling war, im Lande Kanaan. ");
INSERT INTO deu1951_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dies ist die Familiengeschichte Jakobs: Joseph war siebzehn Jahre alt, als er mit seinen Brüdern das Vieh hütete, und er war als Knabe bei den Söhnen Bilhas und Silpas, der Weiber seines Vaters; und Joseph brachte die Klagen über sie vor ihren Vater. ");
INSERT INTO deu1951_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel aber hatte Joseph lieber als alle seine Söhne, weil er ihn in seinem Alter bekommen hatte; und er machte ihm einen langen Rock. ");
INSERT INTO deu1951_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Als nun seine Brüder sahen, daß ihr Vater ihn lieber hatte als alle seine Brüder, haßten sie ihn und mochten ihn nicht mehr grüßen. ");
INSERT INTO deu1951_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph aber hatte einen Traum und verkündigte ihn seinen Brüdern; da haßten sie ihn noch mehr. ");
INSERT INTO deu1951_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Er sprach nämlich zu ihnen: Hört doch, was für einen Traum ich gehabt: ");
INSERT INTO deu1951_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Siehe, wir banden Garben auf dem Feld, und siehe, da richtete sich meine Garbe auf und blieb stehen; eure Garben aber umringten sie und warfen sich vor meiner Garbe nieder! ");
INSERT INTO deu1951_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Da sprachen seine Brüder zu ihm: Willst du etwa gar unser König werden? Willst du über uns herrschen? Darum haßten sie ihn noch mehr wegen seiner Träume und wegen seiner Reden. ");
INSERT INTO deu1951_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Er hatte aber noch einen andern Traum, den erzählte er seinen Brüdern auch und sprach: Seht, ich habe wieder geträumt, und siehe, die Sonne und der Mond und elf Sterne verneigten sich vor mir! ");
INSERT INTO deu1951_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Als er aber das seinem Vater und seinen Brüdern erzählte, schalt ihn sein Vater und sprach zu ihm: Was ist das für ein Traum, den du geträumt hast? Sollen etwa ich und deine Mutter und deine Brüder kommen und uns vor dir bis zur Erde verneigen? ");
INSERT INTO deu1951_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Und seine Brüder beneideten ihn; sein Vater aber behielt das Wort im Gedächtnis. ");
INSERT INTO deu1951_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Als aber seine Brüder nach Sichem gegangen waren, um ihres Vaters Schafe zu weiden, ");
INSERT INTO deu1951_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","sprach Israel zu Joseph: Weiden nicht deine Brüder zu Sichem? Komm, ich will dich zu ihnen senden! Er aber sprach: Siehe, hier bin ich! ");
INSERT INTO deu1951_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Da sprach er zu ihm: Geh doch und sieh, ob es wohl stehe um deine Brüder und um die Schafe, und bringe mir Bescheid! Also sandte er ihn aus dem Tale Hebron, und er wanderte nach Sichem. ");
INSERT INTO deu1951_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Da fand ihn ein Mann, als er irreging auf dem Gefilde; der fragte ihn und sprach: Was suchst du? ");
INSERT INTO deu1951_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Er antwortete: Ich suche meine Brüder; sage mir doch, wo sie weiden! ");
INSERT INTO deu1951_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Der Mann antwortete: Sie sind von hier fortgezogen; denn ich hörte sie sagen: Kommt, laßt uns gen Dotan ziehen! Da ging Joseph seinen Brüdern nach und fand sie zu Dotan. ");
INSERT INTO deu1951_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Als sie ihn nun von ferne sahen, ehe er in ihre Nähe kam, beschlossen sie, ihn meuchlings umzubringen. ");
INSERT INTO deu1951_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Und sie sprachen zueinander: Seht, da kommt der Träumer her! ");
INSERT INTO deu1951_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Jetzt wollen wir ihn doch töten und in eine Zisterne werfen und sagen, ein böses Tier habe ihn gefressen; so wollen wir sehen, was aus seinen Träumen wird. ");
INSERT INTO deu1951_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Als Ruben solches hörte, rettete er ihn aus ihren Händen, indem er sprach: Wir wollen ihn nicht ums Leben bringen! ");
INSERT INTO deu1951_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Und weiter sprach Ruben zu ihnen: Vergießet kein Blut! Werft ihn in die Zisterne dort in der Wüste, aber legt nicht Hand an ihn! Er wollte ihn aber aus ihrer Hand erretten und ihn wieder zu seinem Vater bringen. ");
INSERT INTO deu1951_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Da nun Joseph zu seinen Brüdern kam, zogen sie ihm den Rock aus, den langen Rock, welchen er trug. ");
INSERT INTO deu1951_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Darnach nahmen sie ihn und warfen ihn in die Zisterne; die Zisterne aber war leer, und es war kein Wasser drin. ");
INSERT INTO deu1951_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Darauf setzten sie sich nieder, um zu essen. Als sie aber ihre Augen aufhoben und sich umsahen, siehe, da kam eine Karawane von Ismaelitern vom Gebirge Gilead daher, deren Kamele trugen Tragakanth, Balsam und Ladanum, und zogen hinab nach Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Da sprach Juda zu seinen Brüdern: Was gewinnen wir damit, daß wir unsern Bruder töten und sein Blut verbergen? ");
INSERT INTO deu1951_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kommt, wir wollen ihn den Ismaelitern verkaufen und nicht selbst Hand an ihn legen; denn er ist unser Bruder, unser Fleisch! Und seine Brüder stimmten zu. ");
INSERT INTO deu1951_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Als nun die midianitischen Kaufleute vorbeikamen, zogen sie Joseph aus der Zisterne herauf und verkauften ihn den Ismaelitern um zwanzig Silberlinge; die brachten Joseph nach Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Als nun Ruben zur Zisterne zurückkam, siehe, da war kein Joseph mehr in der Zisterne! Da zerriß er sein Kleid, ");
INSERT INTO deu1951_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","kehrte zu seinen Brüdern zurück und sprach: Der Knabe ist verschwunden! Wo soll ich hin? ");
INSERT INTO deu1951_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Sie aber nahmen Josephs Rock und schlachteten einen Ziegenbock, tauchten den Rock in das Blut, ");
INSERT INTO deu1951_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","schickten den langen Rock ihrem Vater und ließen ihm sagen: Das haben wir gefunden; sieh doch, ob es deines Sohnes Rock ist oder nicht! ");
INSERT INTO deu1951_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Und er erkannte ihn und sprach: Es ist meines Sohnes Rock! Ein böses Tier hat ihn gefressen! Joseph ist gewiß zerrissen worden! ");
INSERT INTO deu1951_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Und Jakob zerriß seine Kleider und legte einen Sack um seine Lenden und trug Leid um seinen Sohn lange Zeit. ");
INSERT INTO deu1951_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Da machten sich alle seine Söhne und Töchter auf, um ihn zu trösten; er aber wollte sich nicht trösten lassen, sondern sprach: Ich höre nicht auf zu trauern, bis ich zu meinem Sohn hinabfahre ins Totenreich! Also beweinte ihn sein Vater. ");
INSERT INTO deu1951_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Aber die Midianiter verkauften ihn nach Ägypten, an Potiphar, einen Kämmerer des Pharao, den Obersten der Leibwache. ");
INSERT INTO deu1951_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Es begab sich um jene Zeit, daß Juda von seinen Brüdern hinabzog und sich zu einem Adullamiter wandte, der Hira hieß. ");
INSERT INTO deu1951_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Und Juda sah daselbst die Tochter eines Kanaaniters, der Schua hieß, und er nahm sie und kam zu ihr. ");
INSERT INTO deu1951_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Und sie empfing und gebar einen Sohn, den hieß sie Er. ");
INSERT INTO deu1951_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Und sie empfing abermal und gebar einen Sohn, den hieß sie Onan. ");
INSERT INTO deu1951_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Sie fuhr fort und gebar einen Sohn, den hieß sie Sela. Er war aber zu Kesib, als sie denselben gebar. ");
INSERT INTO deu1951_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Und Juda gab seinem erstgebornen Sohn Er ein Weib, die hieß Tamar. ");
INSERT INTO deu1951_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Aber Er, der Erstgeborne Judas, war böse vor dem HERRN, darum tötete ihn der HERR. ");
INSERT INTO deu1951_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Da sprach Juda zu Onan: Komm zu deines Bruders Weib und vollziehe mit ihr die Pflichtehe, daß du deinem Bruder Samen erweckest! ");
INSERT INTO deu1951_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Da aber Onan wußte, daß der Same nicht sein eigen sein sollte, ließ er es, wenn er zu seines Bruders Weib ging, auf die Erde fallen und verderbte es, um seinem Bruder keinen Samen zu geben. ");
INSERT INTO deu1951_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Es gefiel aber dem HERRN übel, was er tat; da tötete er ihn auch. ");
INSERT INTO deu1951_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Da sprach Juda zu Tamar, seines Sohnes Weib: Bleib als Witwe in deines Vaters Hause, bis mein Sohn Sela erwachsen ist! Denn er dachte, vielleicht könnte er auch sterben, wie seine Brüder. Also ging Tamar hin und blieb in ihres Vaters Hause. ");
INSERT INTO deu1951_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Als nun viele Tage verflossen waren, starb Schuas Tochter, Judas Weib. Und nachdem Juda ausgetrauert hatte, ging er hinauf zu seinen Schafherden gen Timna, er und Hira, sein Freund von Adullam. ");
INSERT INTO deu1951_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Da ward der Tamar angesagt: Siehe, dein Schwiegervater geht hinauf nach Timna, seine Schafe zu scheren! ");
INSERT INTO deu1951_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Da legte sie die Witwenkleider von sich, die sie trug, bedeckte sich mit einem Schleier und verhüllte sich und setzte sich ans Tor von Enaim, am Wege nach Timna. Denn sie sah, daß Sela erwachsen war und sie ihm nicht zum Weibe gegeben wurde. ");
INSERT INTO deu1951_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Als nun Juda sie sah, glaubte er, sie sei eine Dirne; denn sie hatte ihr Angesicht bedeckt. ");
INSERT INTO deu1951_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Und er machte sich zu ihr am Wege und sprach: Laß mich doch zu dir kommen! Denn er wußte nicht, daß sie seines Sohnes Weib war. Sie antwortete: Was willst du mir geben, daß du zu mir kommest? ");
INSERT INTO deu1951_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Er sprach: Ich will dir einen Ziegenbock von der Herde schicken! Sie antwortete: So gib mir ein Pfand, bis du mir ihn schickst! ");
INSERT INTO deu1951_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Er sprach: Was willst du, daß ich dir zum Pfand gebe? Sie antwortete: Deinen Ring und deine Schnur und deinen Stab, den du in deinen Händen hast! Da gab er es ihr und ging zu ihr, und sie ward von ihm schwanger. ");
INSERT INTO deu1951_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Und sie machte sich auf und ging hin und tat ihren Schleier ab und legte wieder ihre Witwenkleider an. ");
INSERT INTO deu1951_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda aber sandte den Ziegenbock durch seinen Freund, den Adullamiter, um das Pfand von dem Weibe zurückzuerhalten; aber er fand sie nicht. ");
INSERT INTO deu1951_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Da fragte er die Leute an jenem Ort und sprach: Wo ist die Dirne, die bei Enaim am Wege saß? Sie antworteten: Es ist keine Dirne hier gewesen! ");
INSERT INTO deu1951_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Und er kam wieder zu Juda und sprach: Ich habe sie nicht gefunden; dazu sagen die Leute an jenem Ort, es sei keine Dirne dort gewesen. ");
INSERT INTO deu1951_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda sprach: So soll sie das Pfand für sich behalten, damit wir nicht zuschanden werden! Siehe, ich habe den Bock geschickt, aber du hast sie nicht gefunden. ");
INSERT INTO deu1951_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Aber nach drei Monaten ward Juda angezeigt: Deine Sohnsfrau Tamar hat gehurt, dazu siehe, ist sie von Hurerei schwanger geworden! Juda sprach: Führt sie hinaus, daß sie verbrannt werde! ");
INSERT INTO deu1951_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Und als man sie hinausführte, schickte sie zu ihrem Schwiegervater und sprach: Von dem Manne bin ich schwanger geworden, dem das gehört. Und sie sprach: Untersuche doch, wem gehört dieser Ring und die Schnur und der Stab? ");
INSERT INTO deu1951_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda sah genauer zu und sprach: Sie ist gerechter als ich; denn ich habe sie nicht meinem Sohn Sela gegeben! Doch erkannte er sie nicht mehr. ");
INSERT INTO deu1951_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Und als sie gebären sollte, siehe, da waren Zwillinge in ihrem Leibe. ");
INSERT INTO deu1951_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Und als sie gebar, kam eine Hand heraus; da nahm die Hebamme einen roten Faden und band ihn darum und sprach: Der ist zuerst herausgekommen! ");
INSERT INTO deu1951_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Als dieser aber seine Hand wieder hineinzog, siehe, da kam sein Bruder heraus. Und sie sprach: Warum hast du dir einen solchen Riß gemacht? Und man hieß ihn Perez. ");
INSERT INTO deu1951_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Darnach kam sein Bruder heraus, der den roten Faden um die Hand hatte; man hieß ihn Serach. ");
INSERT INTO deu1951_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph aber war nach Ägypten hinabgeführt worden, und Potiphar, ein ägyptischer Kämmerer des Pharao, der Oberste der Leibwache, hatte ihn von der Hand der Ismaeliter erworben, die ihn dorthin gebracht hatten. ");
INSERT INTO deu1951_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Und der HERR war mit Joseph, und er hatte Glück und durfte bleiben im Hause seines ägyptischen Herrn. ");
INSERT INTO deu1951_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Und als sein Gebieter sah, daß der HERR mit ihm war, und daß der HERR in seiner Hand alles gelingen ließ, was er unternahm, ");
INSERT INTO deu1951_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","da fand Joseph Gnade in seinen Augen und durfte ihn bedienen; und er setzte ihn zum Aufseher über sein Haus und vertraute ihm alles an, was er hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Und von der Zeit an, da er ihn über sein Haus und über alle seine Güter gesetzt hatte, segnete der HERR des Ägypters Haus um Josephs willen, also daß der Segen des HERRN in allem war, was er hatte, im Hause und auf dem Felde. ");
INSERT INTO deu1951_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Da überließ er alles, was er hatte, Josephs Hand und kümmerte sich um gar nichts mehr als um das Brot, das er aß. Joseph aber war von schöner Gestalt und hübschem Aussehen. ");
INSERT INTO deu1951_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Es begab sich aber nach diesen Geschichten, daß seines Herrn Weib ihre Augen auf Joseph warf und zu ihm sprach: Schlaf bei mir! ");
INSERT INTO deu1951_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Er aber weigerte sich und sprach zu dem Weibe seines Herrn: Siehe, mein Herr verläßt sich auf mich und kümmert sich um nichts, was im Hause vorgeht, und hat mir alles anvertraut, was ihm gehört; ");
INSERT INTO deu1951_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","es ist niemand größer in diesem Hause, als ich, und es gibt nichts, das er mir vorenthalten hätte, ausgenommen dich, weil du sein Weib bist! Wie sollte ich nun ein solch großes Übel tun und wider Gott sündigen? ");
INSERT INTO deu1951_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Und wiewohl sie ihm Tag für Tag zuredete, hörte er doch nicht auf sie, daß er sich zu ihr gelegt oder sich mit ihr vergangen hätte. ");
INSERT INTO deu1951_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Es begab sich aber an einem solchen Tage, als er ins Haus kam, um sein Geschäft zu besorgen, und niemand von den Hausgenossen zugegen war, ");
INSERT INTO deu1951_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","daß sie ihn bei seinem Kleide ergriff und zu ihm sprach: Schlaf bei mir! Er aber ließ das Kleid in ihrer Hand und floh und lief zum Hause hinaus. ");
INSERT INTO deu1951_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Als sie nun sah, daß er das Kleid in ihrer Hand gelassen hatte und entflohen war, ");
INSERT INTO deu1951_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","rief sie die Hausgenossen herbei und sprach zu ihnen: Seht, er hat uns den Hebräer ins Haus gebracht, daß er Mutwillen mit uns triebe! Er kam zu mir herein, um bei mir zu schlafen; ich aber habe aus Leibeskräften geschrieen! ");
INSERT INTO deu1951_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Als er nun hörte, daß ich meine Stimme erhob und schrie, ließ er sein Kleid neben mir liegen und floh zur Tür hinaus. ");
INSERT INTO deu1951_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Und sie ließ sein Kleid neben sich liegen, bis sein Herr nach Hause kam. ");
INSERT INTO deu1951_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Dem erzählte sie die gleiche Geschichte und sprach: Der hebräische Knecht, den du uns gebracht hast, ist zu mir hereingekommen, um Mutwillen mit mir zu treiben; ");
INSERT INTO deu1951_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","als ich aber meine Stimme erhob und schrie, ließ er sein Kleid neben mir liegen und entfloh! ");
INSERT INTO deu1951_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Als nun sein Herr die Rede seines Weibes hörte, daß sie sprach: So und so hat mir dein Knecht getan! da entbrannte sein Zorn. ");
INSERT INTO deu1951_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Und Josephs Herr nahm ihn und warf ihn ins Gefängnis, dorthin, wo die Gefangenen des Königs lagen; so war er daselbst im Gefängnis. ");
INSERT INTO deu1951_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Aber der HERR war mit Joseph und verschaffte ihm Gunst und schenkte ihm Gnade vor den Augen des Kerkermeisters. ");
INSERT INTO deu1951_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Und der Kerkermeister gab alle Gefangenen, die im Kerker waren, in Josephs Hand, und alles, was es dort zu tun gab, das besorgte dieser. ");
INSERT INTO deu1951_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Der Kerkermeister kümmerte sich nicht im geringsten um irgend etwas, das er in die Hand nahm; denn der HERR war mit ihm, und der HERR ließ alles gelingen, was er unternahm. ");
INSERT INTO deu1951_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Nach diesen Geschichten begab es sich, daß der Mundschenk des Königs von Ägypten und der oberste Bäcker sich gegen ihren Herrn, den König von Ägypten, versündigten. ");
INSERT INTO deu1951_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Da ward der Pharao zornig über seine beiden Höflinge, den obersten Mundschenk und den obersten Bäcker, ");
INSERT INTO deu1951_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","und ließ sie in Gewahrsam legen im Hause des Obersten der Leibwache, in den Kerker, in welchem Joseph gefangen lag. ");
INSERT INTO deu1951_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Und der Oberste der Leibwache übertrug Joseph die Sorge für sie, und er diente ihnen, und sie waren längere Zeit im Gefängnis. ");
INSERT INTO deu1951_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Und es träumte ihnen beiden in einer Nacht, einem jeden ein Traum von besonderer Bedeutung, dem Mundschenken und dem Bäcker des Königs von Ägypten, die in dem Kerker gefangen lagen. ");
INSERT INTO deu1951_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Als nun Joseph am Morgen zu ihnen kam, sah er sie an und siehe, sie waren verdrießlich. ");
INSERT INTO deu1951_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Da fragte er diese Höflinge des Pharao, die mit ihm im Gefängnis seines Herrn waren, und sprach: Warum macht ihr heute ein so finsteres Gesicht? ");
INSERT INTO deu1951_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Sie antworteten ihm: Uns hat geträumt; und nun ist kein Ausleger da! Joseph sprach zu ihnen: Kommen nicht die Auslegungen von Gott? Erzählt mir's doch! ");
INSERT INTO deu1951_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Da erzählte der oberste Mundschenk dem Joseph seinen Traum und sprach: In meinem Traum, siehe, da war ein Weinstock vor mir, ");
INSERT INTO deu1951_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","und an dem Weinstock waren drei Schosse; und er grünte und blühte und seine Trauben wurden reif. ");
INSERT INTO deu1951_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ich aber hatte den Becher des Pharao in der Hand. ");
INSERT INTO deu1951_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph sprach zu ihm: Dies ist die Bedeutung: Die drei Schosse sind drei Tage; ");
INSERT INTO deu1951_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","in drei Tagen wird der Pharao dein Haupt erheben und dich wieder in dein Amt einsetzen, daß du dem Pharao den Becher reichest, wie du früher zu tun pflegtest, da du noch sein Mundschenk warst. ");
INSERT INTO deu1951_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Solltest du dann etwa an mich denken, wenn es dir gut geht, so tue Barmherzigkeit an mir und empfiehl mich dem Pharao, daß er mich aus diesem Hause entlasse; ");
INSERT INTO deu1951_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","denn ich bin aus dem Lande der Hebräer gestohlen worden und habe auch hier gar nichts getan, wofür man mich einzusperren brauchte. ");
INSERT INTO deu1951_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Da nun der oberste Bäcker sah, daß Joseph eine gute Auslegung gegeben hatte, sprach er zu ihm: Siehe, in meinem Traum trug ich drei Körbe auf meinem Kopf, ");
INSERT INTO deu1951_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","und im obersten Korb war allerlei Backwerk für den Pharao; und die Vögel fraßen es mir aus dem Korb, der auf meinem Haupte war. ");
INSERT INTO deu1951_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Da antwortete Joseph und sprach: Dies ist die Bedeutung: Die drei Körbe sind drei Tage; ");
INSERT INTO deu1951_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","in drei Tagen wird der Pharao dich hinrichten und ans Holz hängen lassen, daß die Vögel dein Fleisch fressen werden. ");
INSERT INTO deu1951_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Und es begab sich am dritten Tag, dem Geburtstag des Pharao, als er für alle seine Knechte ein Mahl veranstaltete, daß er das Haupt des obersten Mundschenken und des obersten Bäckers unter allen seinen Knechten erhob; ");
INSERT INTO deu1951_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","und den obersten Mundschenken setzte er wieder ein in sein Schenkamt, daß er dem Pharao den Becher in die Hand geben durfte; ");
INSERT INTO deu1951_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","aber den obersten Bäcker ließ er hängen; wie Joseph ihnen gedeutet hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Aber der oberste Mundschenk dachte nicht an Joseph, sondern vergaß ihn. ");
INSERT INTO deu1951_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Es begab sich aber nach zwei Jahren, da hatte der Pharao einen Traum, und siehe, er stand am Nil. ");
INSERT INTO deu1951_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Und siehe, aus dem Nil stiegen sieben schöne und wohlgenährte Kühe herauf, die im Nilgras weideten. ");
INSERT INTO deu1951_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nach diesen aber stiegen sieben andere Kühe aus dem Nil herauf, von häßlicher Gestalt und magerem Leib; die traten neben die Kühe am Ufer des Nils. ");
INSERT INTO deu1951_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Und die sieben häßlichen, mageren Kühe fraßen die sieben schönen, wohlgenährten Kühe. Da erwachte der Pharao. ");
INSERT INTO deu1951_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Er schlief aber wieder ein und träumte zum zweitenmal, und siehe, da wuchsen sieben Ähren auf einem einzigen Halm, die waren voll und gut; ");
INSERT INTO deu1951_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","nach denselben aber siehe, da sproßten sieben dünne und vom Ostwind versengte Ähren. ");
INSERT INTO deu1951_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Und die sieben dünnen Ähren verschlangen die sieben schweren und vollen Ähren. Da erwachte der Pharao und siehe, es war ein Traum! ");
INSERT INTO deu1951_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Da sich aber sein Geist beunruhigte, ließ er am Morgen alle ägyptischen Wahrsager und Weisen rufen und erzählte ihnen seinen Traum; aber da war keiner, der ihn dem Pharao auslegen konnte. ");
INSERT INTO deu1951_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Da sprach der oberste Mundschenk zum Pharao: Ich gedenke heute meiner Sünde! ");
INSERT INTO deu1951_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Als der Pharao über seine Knechte zornig war und mich im Hause des Obersten der Leibwache in Gewahrsam legte, mitsamt dem obersten Bäcker, ");
INSERT INTO deu1951_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","da träumte uns in der gleichen Nacht, mir und ihm, einem jeden ein Traum von besonderer Bedeutung. ");
INSERT INTO deu1951_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Und daselbst war ein hebräischer Jüngling bei uns, ein Knecht des Obersten der Leibwache; dem erzählten wir es, und er legte uns unsre Träume aus, einem jeden ganz genau. ");
INSERT INTO deu1951_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Und so wie er es uns auslegte, so ist es gekommen; mich hat man wieder in mein Amt eingesetzt, und ihn hat man gehängt. ");
INSERT INTO deu1951_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Da sandte der Pharao hin und ließ Joseph rufen. Und sie entließen ihn eilends aus dem Loch. Er aber ließ sich scheren und wechselte seine Kleider und ging zum Pharao hinein. ");
INSERT INTO deu1951_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Und der Pharao sprach zu Joseph: Ich habe einen Traum gehabt, aber es kann ihn niemand auslegen; nun vernahm ich von dir, wenn du einen Traum hörest, so legest du ihn auch aus. ");
INSERT INTO deu1951_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph antwortete dem Pharao und sprach: Nicht mir steht dies zu. Möge Gott antworten, was dem Pharao Heil bringt! ");
INSERT INTO deu1951_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Da sprach der Pharao zu Joseph: Siehe, in meinem Traum stand ich am Ufer des Nils; ");
INSERT INTO deu1951_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","und siehe, da stiegen aus dem Nil sieben wohlgenährte Kühe von schöner Gestalt herauf, die im Nilgras weideten. ");
INSERT INTO deu1951_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Und siehe, nach ihnen stiegen sieben andere Kühe herauf, geringe Ware, und von sehr häßlicher Gestalt und magerem Leib, wie ich in ganz Ägyptenland keine so häßlichen gesehen habe. ");
INSERT INTO deu1951_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Und diese mageren, häßlichen Kühe fraßen die sieben ersten wohlgenährten Kühe. ");
INSERT INTO deu1951_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Als sie aber die verschlungen hatten, merkte man nichts davon; denn sie waren so häßlich wie zuvor. Da erwachte ich. ");
INSERT INTO deu1951_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Und ich sah weiter in meinem Traum, und siehe, sieben volle und gute Ähren wuchsen an einem einzigen Halme auf. ");
INSERT INTO deu1951_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Und siehe, nach denselben sproßten sieben dürre, magere und vom Ostwind versengte Ähren hervor; ");
INSERT INTO deu1951_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","und die sieben mageren Ähren verschlangen die sieben guten. Solches habe ich den Schriftkundigen erzählt, aber keiner kann es mir erklären. ");
INSERT INTO deu1951_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Da sprach Joseph zum Pharao: Was dem Pharao geträumt hat, ist eins: Gott hat dem Pharao angezeigt, was er tun will. ");
INSERT INTO deu1951_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Die sieben guten Kühe sind sieben Jahre, und die sieben guten Ähren sind auch sieben Jahre; es ist einerlei Traum. ");
INSERT INTO deu1951_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Die sieben mageren und häßlichen Kühe, die nach jenen heraufkamen, sind sieben Jahre; desgleichen die sieben leeren, vom Ostwind versengten Ähren; es werden sieben Hungerjahre sein. ");
INSERT INTO deu1951_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Darum sagte ich zu dem Pharao, Gott habe dem Pharao gezeigt, was er tun will. ");
INSERT INTO deu1951_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Siehe, es kommen sieben Jahre, da wird großer Überfluß in ganz Ägyptenland herrschen; ");
INSERT INTO deu1951_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","aber nach denselben werden sieben Hungerjahre eintreten, da man all diesen Überfluß im Lande Ägypten vergessen wird; ");
INSERT INTO deu1951_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","und die Hungersnot wird das Land aufzehren, daß man nichts mehr merken wird von dem Überfluß, infolge der Hungersnot, die hernach kommt; denn sie wird sehr drückend sein. ");
INSERT INTO deu1951_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Daß es aber dem Pharao zum zweitenmal geträumt hat, das bedeutet, daß das Wort gewiß von Gott kommt, und daß Gott es eilends ausführen wird. ");
INSERT INTO deu1951_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Und nun sehe der Pharao nach einem verständigen und weisen Mann und setze ihn über Ägyptenland; ");
INSERT INTO deu1951_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","der Pharao verschaffe und setze Aufseher über das Land und lasse in den sieben Jahren des Überflusses den fünften Teil der Ernte vom Lande Ägypten erheben. ");
INSERT INTO deu1951_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Also soll man alle Nahrung dieser sieben künftigen guten Jahre sammeln und Getreide aufspeichern zur Verfügung des Pharaos, und solche Nahrung in den Städten verwahren. ");
INSERT INTO deu1951_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Und diese Nahrung soll dem Land als Vorrat dienen für die sieben Hungerjahre, welche in Ägyptenland eintreten werden, daß das Land durch die Hungersnot nicht entvölkert werde. ");
INSERT INTO deu1951_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Diese Rede gefiel dem Pharao und allen seinen Knechten wohl. ");
INSERT INTO deu1951_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Und der Pharao sprach zu seinen Knechten: Können wir einen Mann finden wie diesen, in welchem der Geist Gottes ist? ");
INSERT INTO deu1951_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Der Pharao sprach zu Joseph: Nachdem Gott dir solches alles kundgetan hat, ist keiner so verständig und weise wie du! ");
INSERT INTO deu1951_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Du sollst über mein Haus sein, und deinem Befehl soll mein ganzes Volk gehorchen; nur um den Thron will ich höher sein als du. ");
INSERT INTO deu1951_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Weiter sprach der Pharao zu Joseph: Siehe, ich habe dich über ganz Ägyptenland gesetzt! ");
INSERT INTO deu1951_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Und der Pharao nahm den Siegelring von seiner Hand und steckte ihn an Josephs Hand und bekleidete ihn mit weißer Leinwand und legte eine goldene Kette um seinen Hals ");
INSERT INTO deu1951_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","und ließ ihn auf seinem zweiten Wagen fahren; und man rief vor ihm aus: «Beugt eure Knie!» Und also wurde er über ganz Ägyptenland gesetzt. ");
INSERT INTO deu1951_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Und der Pharao sprach zu Joseph: Ich bin der Pharao, und ohne dich soll niemand in ganz Ägyptenland die Hand oder den Fuß erheben! ");
INSERT INTO deu1951_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Und der Pharao nannte den Joseph Zaphenat-Paneach und gab ihm Asnath, die Tochter Potipheras, des Priesters zu On, zum Weibe. ");
INSERT INTO deu1951_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Und Joseph zog aus durch ganz Ägyptenland. Er war aber dreißig Jahre alt, da er vor dem Pharao stand. Und er ging vom Pharao aus und bereiste ganz Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Und das Land trug in den sieben Jahren des Überflusses haufenweise. ");
INSERT INTO deu1951_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Und er sammelte allen Ertrag der sieben Jahre, in denen in Ägyptenland Überfluß herrschte, und tat die Nahrungsmittel in die Städte; nämlich den Ertrag der Felder rings um die Städte brachte er in diese. ");
INSERT INTO deu1951_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Und Joseph speicherte Getreide auf wie Sand am Meer, bis er es nicht mehr messen konnte; denn es war unermeßlich viel. ");
INSERT INTO deu1951_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ehe aber die teure Zeit kam, wurden Joseph zwei Söhne geboren; die gebar ihm Asnath, die Tochter Potipheras, des Priesters zu On. ");
INSERT INTO deu1951_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Und Joseph nannte den Erstgebornen Manasse; denn er sprach: Gott hat mich vergessen lassen alle meine Mühsal und das ganze Haus meines Vaters. ");
INSERT INTO deu1951_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Den zweiten aber nannte er Ephraim; denn er sprach: Gott hat mich fruchtbar gemacht im Lande meines Elends. ");
INSERT INTO deu1951_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Als nun die sieben Jahre des Überflusses im Lande Ägypten verflossen waren, ");
INSERT INTO deu1951_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","da brachen die sieben Hungerjahre an, wie Joseph vorausgesagt hatte. Und es entstand eine Hungersnot in allen Ländern; aber in ganz Ägyptenland war Brot. ");
INSERT INTO deu1951_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Und als Ägypten Hunger litt und das Volk zum Pharao um Brot schrie, da sprach der Pharao zu allen Ägyptern: Geht hin zu Joseph; was er euch sagen wird, das tut! ");
INSERT INTO deu1951_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Und da die Hungersnot im ganzen Lande herrschte, tat Joseph alle Kornspeicher auf und verkaufte den Ägyptern Getreide; denn die Hungersnot nahm überhand in Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Und alle Welt kam nach Ägypten, um bei Joseph Korn zu kaufen; denn es herrschte allenthalben große Hungersnot. ");
INSERT INTO deu1951_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Als aber Jakob sah, daß Korn in Ägypten war, sprach er zu seinen Söhnen: Was sehet ihr einander an? ");
INSERT INTO deu1951_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Siehe, ich höre, es gebe in Ägypten Korn; reiset dort hinab und kauft uns daselbst Getreide, daß wir leben und nicht sterben! ");
INSERT INTO deu1951_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Also machten sich zehn Brüder Josephs auf den Weg, um in Ägypten Getreide zu kaufen. ");
INSERT INTO deu1951_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Benjamin aber, Josephs Bruder, sandte Jakob nicht mit den Brüdern; denn er sprach: Es könnte ihm ein Unfall begegnen! ");
INSERT INTO deu1951_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","So kamen nun die Söhne Israels, Getreide zu kaufen, mit andern, die auch gingen, weil im Lande Kanaan Hungersnot war. ");
INSERT INTO deu1951_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph aber war Regent über das Land; er verkaufte allem Volk des Landes Korn. Darum kamen Josephs Brüder und fielen vor ihm nieder, das Angesicht zur Erde gewandt. ");
INSERT INTO deu1951_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Da nun Joseph seine Brüder sah, erkannte er sie, verstellte sich aber und redete hart mit ihnen und fragte sie: Wo kommt ihr her? Sie antworteten: Aus dem Lande Kanaan, um Speise zu kaufen! ");
INSERT INTO deu1951_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Aber wiewohl Joseph seine Brüder kannte, kannten sie ihn doch nicht. ");
INSERT INTO deu1951_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Und Joseph gedachte der Träume, die er von ihnen geträumt hatte, und sprach zu ihnen: Kundschafter seid ihr; zu sehen, wo das Land offen ist, darum seid ihr gekommen! ");
INSERT INTO deu1951_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Sie antworteten ihm: Nein, mein Herr; deine Knechte sind gekommen, um Speise zu kaufen! ");
INSERT INTO deu1951_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wir sind alle eines Mannes Söhne; wir sind redlich; deine Knechte sind niemals Kundschafter gewesen. ");
INSERT INTO deu1951_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Er aber sprach zu ihnen: Doch, ihr seid gekommen zu sehen, wo das Land offen ist! ");
INSERT INTO deu1951_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Sie antworteten: Wir, deine Knechte, sind zwölf Brüder, eines einzigen Mannes Söhne im Lande Kanaan, und siehe, der jüngste ist gegenwärtig bei unserm Vater, und einer ist nicht mehr vorhanden. ");
INSERT INTO deu1951_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Aber Joseph sprach zu ihnen: Es ist so, wie ich euch gesagt habe: Ihr seid Kundschafter! ");
INSERT INTO deu1951_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Daran will ich euch prüfen; so wahr der Pharao lebt, sollt ihr von hier nicht fortgehen, es komme denn euer jüngster Bruder her! ");
INSERT INTO deu1951_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Schickt einen von euch hin, daß er euren Bruder hole, ihr aber sollt in Haft behalten werden; so wird es sich herausstellen, ob ihr mit der Wahrheit umgeht; wo aber nicht, dann seid ihr Kundschafter, so wahr der Pharao lebt! ");
INSERT INTO deu1951_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Und er tat sie alle zusammen in Verwahrung, drei Tage lang. ");
INSERT INTO deu1951_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Am dritten Tag aber sprach Joseph zu ihnen: Um euer Leben zu fristen, macht es so; denn ich fürchte Gott: ");
INSERT INTO deu1951_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Wenn ihr aufrichtig seid, so lasset einen von euch Brüdern hier gebunden im Gefängnis zurück; ihr andern aber geht hin und bringet heim, was eure Familien zur Stillung des Hungers bedürfen. ");
INSERT INTO deu1951_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Euren jüngsten Bruder aber bringet zu mir, so wird man euren Worten glauben und ihr sollt nicht sterben. Und sie taten also. ");
INSERT INTO deu1951_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Sie sagten aber zueinander: Wahrlich, das haben wir an unserm Bruder verschuldet, dessen Seelenangst wir sahen, als er uns um Erbarmen anflehte; wir aber hörten nicht auf ihn. Darum ist diese Not über uns gekommen! ");
INSERT INTO deu1951_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben antwortete und sprach zu ihnen: Habe ich es euch nicht gesagt, ihr solltet euch an dem Knaben nicht versündigen? Aber ihr wolltet ja nicht hören! Darum seht, nun wird sein Blut gefordert! ");
INSERT INTO deu1951_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sie wußten aber nicht, daß Joseph sie verstand; denn er verkehrte mit ihnen durch einen Dolmetscher. ");
INSERT INTO deu1951_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Und er wandte sich von ihnen und weinte, kehrte aber wieder zu ihnen zurück und redete mit ihnen. Darauf nahm er Simeon von ihnen weg und band ihn vor ihren Augen. ");
INSERT INTO deu1951_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Und Joseph gab Befehl, daß man ihre Säcke mit Getreide fülle und einem jeden sein Geld wieder in seinen Sack lege und ihnen auch Zehrung mit auf die Reise gebe. ");
INSERT INTO deu1951_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Und man tat ihnen also. Da luden sie ihr Getreide auf ihre Esel und gingen davon. ");
INSERT INTO deu1951_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Als aber einer seinen Sack öffnete, um in der Herberge seinem Esel Futter zu geben, da sah er sein Geld, und siehe, es lag oben im Sack! ");
INSERT INTO deu1951_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Und er sprach zu seinen Brüdern: Mein Geld ist mir zurückgegeben worden; seht, es ist in meinem Sack! Da verging ihnen aller Mut; und sie sprachen zitternd einer zum andern: Ach, warum hat uns Gott das getan? ");
INSERT INTO deu1951_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Als sie aber zu ihrem Vater Jakob ins Land Kanaan kamen, erzählten sie ihm alles, was ihnen begegnet war und sprachen: ");
INSERT INTO deu1951_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Der Mann, der des Landes Herr ist, redete hart mit uns und behandelte uns als Kundschafter des Landes. ");
INSERT INTO deu1951_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Wir aber sagten: Wir sind aufrichtig und sind keine Kundschafter; ");
INSERT INTO deu1951_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","wir sind unser zwölf Brüder, Söhne unsres Vaters; einer ist nicht mehr da, der jüngste aber ist gegenwärtig bei unserm Vater im Lande Kanaan. ");
INSERT INTO deu1951_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Da sprach der Mann, des Landes Herr, zu uns: Daran will ich erkennen, ob ihr aufrichtig seid: Laßt einen eurer Brüder bei mir zurück und geht und nehmt die Notdurft für eure Haushaltungen mit; ");
INSERT INTO deu1951_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","und bringet euren jüngeren Bruder zu mir, damit ich erkenne, daß ihr keine Kundschafter, sondern aufrichtig seid. Dann will ich euch euren Bruder herausgeben und ihr könnt ungehindert im Lande verkehren. ");
INSERT INTO deu1951_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Als sie aber ihre Säcke ausleerten, siehe, da hatte jeder sein Bündlein Geld in seinem Sack! Als sie und ihr Vater ihre Bündlein Geld sahen, erschraken sie. ");
INSERT INTO deu1951_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Und ihr Vater Jakob sprach zu ihnen: Ihr habt mich meiner Kinder beraubt! Joseph ist nicht mehr, Simeon ist nicht mehr, und Benjamin wollt ihr nehmen; es geht alles über mich! ");
INSERT INTO deu1951_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Da sprach Ruben zu seinem Vater: Du kannst meine beiden Söhne töten, wenn ich ihn dir nicht wiederbringe; übergib ihn nur meiner Hand, ich will ihn dir wiederbringen! ");
INSERT INTO deu1951_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Er aber sprach: Mein Sohn soll nicht mit euch hinabziehen; denn sein Bruder ist tot, und er ist allein übriggeblieben. Sollte ihm ein Unfall begegnen auf dem Wege, den ihr geht, so würdet ihr meine grauen Haare vor Kummer ins Totenreich hinunterbringen! ");
INSERT INTO deu1951_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Aber die Hungersnot drückte das Land. ");
INSERT INTO deu1951_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Und als sie alles Korn aufgezehrt hatten, das sie aus Ägypten hergebracht, sprach ihr Vater zu ihnen: Geht und kauft uns wieder ein wenig Getreide zur Speise! ");
INSERT INTO deu1951_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Aber Juda antwortete und sprach zu ihm: Der Mann hat uns ernstlich bezeugt und gesagt: Ihr sollt mein Angesicht nicht sehen, es sei denn euer Bruder mit euch! ");
INSERT INTO deu1951_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Sendest du nun unsern Bruder mit uns, so wollen wir hinabziehen und dir Getreide zur Speise kaufen. ");
INSERT INTO deu1951_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Lässest du ihn aber nicht gehen, so reisen wir nicht hinab; denn der Mann hat zu uns gesagt: Ihr sollt mein Angesicht nicht sehen, es sei denn euer Bruder mit euch! ");
INSERT INTO deu1951_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Da sprach Israel: Warum habt ihr mir das zuleid getan, daß ihr dem Mann verrietet, daß ihr noch einen Bruder habt? ");
INSERT INTO deu1951_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Sie sprachen: Der Mann forschte so genau nach uns und unsrer Verwandtschaft und sprach: Lebt euer Vater noch? Habt ihr noch einen Bruder? Da gaben wir ihm Auskunft, wie es sich verhielte. Konnten wir denn wissen, daß er sagen würde: Bringt euren Bruder herab? ");
INSERT INTO deu1951_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Und Juda sprach zu seinem Vater Israel: Gib mir den Knaben mit, so wollen wir uns auf den Weg machen, daß wir leben und nicht sterben, wir und du und unsre Kinder! ");
INSERT INTO deu1951_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ich will für ihn bürgen, von meiner Hand sollst du ihn fordern; wenn ich ihn dir nicht wiederbringe und ihn vor dein Angesicht stelle, so habe ich mein ganzes Leben verwirkt vor dir. ");
INSERT INTO deu1951_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Wenn wir nicht gezögert hätten, so wären wir jetzt schon zum zweitenmal zurück! ");
INSERT INTO deu1951_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Da sprach ihr Vater Israel zu ihnen: Muß es denn doch sein, so macht es so: Nehmt in eure Säcke von den berühmtesten Erzeugnissen des Landes und bringt sie dem Mann zum Geschenk: ein wenig Balsam, ein wenig Honig, Tragakanth und Ladanum, Pistazien und Mandeln. ");
INSERT INTO deu1951_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nehmt auch den doppelten Betrag Geld in eure Hände und erstattet das zurückerhaltene Geld, das oben in euren Säcken war, eigenhändig wieder; vielleicht ist da ein Irrtum geschehen. ");
INSERT INTO deu1951_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Und nehmt euren Bruder mit, macht euch auf und kehrt zu dem Manne zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Und der allmächtige Gott gebe euch Barmherzigkeit vor dem Manne, daß er euch euren andern Bruder wieder mitgebe und Benjamin! Ich aber, wenn ich doch der Kinder beraubt sein soll, so sei ich ihrer beraubt! ");
INSERT INTO deu1951_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Da nahmen die Männer das Geschenk und doppelt soviel Geld in ihre Hand, und auch Benjamin, machten sich auf und reisten nach Ägypten und traten vor Joseph. ");
INSERT INTO deu1951_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Als nun Joseph den Benjamin bei ihnen sah, sprach er zu seinem Hofmeister: Führe die Männer ins Haus hinein, schlachte und richte zu; denn sie sollen mit mir zu Mittag essen. ");
INSERT INTO deu1951_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Der Mann tat, wie ihm Joseph gesagt hatte, und führte die Männer in Josephs Haus. ");
INSERT INTO deu1951_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Da fürchteten sich die Männer, weil sie in Josephs Haus geführt wurden und sprachen: Man führt uns hinein um des Geldes willen, welches das erstemal wieder in unsre Säcke gekommen ist, daß man über uns herfalle und uns überwältige und uns zu Sklaven mache samt unsern Eseln! ");
INSERT INTO deu1951_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Darum wandten sie sich an den Mann, der über Josephs Haus war und redeten vor der Haustür mit ihm ");
INSERT INTO deu1951_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","und sprachen: Bitte, mein Herr, wir sind schon einmal hier gewesen, um Korn zu kaufen; ");
INSERT INTO deu1951_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","da ist es uns begegnet, als wir in die Herberge kamen und unsre Säcke öffneten, daß eines jeglichen Geld oben in seinem Sacke lag, unser Geld nach seinem vollen Gewicht. ");
INSERT INTO deu1951_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nun haben wir es wieder mit uns gebracht und anderes Geld dazu, um Getreide zu kaufen; wir wissen nicht, wer unser Geld in unsre Säcke gelegt hat. ");
INSERT INTO deu1951_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Er sprach zu ihnen: Friede sei mit euch! Fürchtet euch nicht! Euer Gott und eures Vaters Gott hat euch einen Schatz in eure Säcke gegeben! Euer Geld ist mir zugekommen. Und er führte Simeon zu ihnen hinaus. ");
INSERT INTO deu1951_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Und der Mann führte die Männer in Josephs Haus und gab ihnen Wasser, daß sie ihre Füße wuschen, und gab ihren Eseln Futter. ");
INSERT INTO deu1951_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Sie aber richteten das Geschenk zu, bis Joseph kam zur Mittagszeit; denn sie hatten gehört, daß sie dort essen sollten. ");
INSERT INTO deu1951_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Als nun Joseph nach Hause kam, brachten sie ihm das Geschenk, das in ihren Händen war, ins Haus und fielen vor ihm zur Erde nieder. ");
INSERT INTO deu1951_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Und er fragte sie, wie es ihnen gehe und sprach: Geht es auch eurem alten Vater wohl, von dem ihr mir sagtet? Lebt er noch? ");
INSERT INTO deu1951_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Sie antworteten: Es geht deinem Knechte, unsrem Vater, wohl; er lebt noch! Und sie verbeugten sich und fielen vor ihm nieder. ");
INSERT INTO deu1951_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Als er aber seine Augen erhob und seinen Bruder Benjamin sah, seiner Mutter Sohn, fragte er: Ist das euer jüngerer Bruder, von dem ihr mir gesprochen habt? Und er sprach: Gott sei dir gnädig, mein Sohn! ");
INSERT INTO deu1951_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Darnach aber zog sich Joseph zurück; denn sein Herz entbrannte gegen seinen Bruder; und er suchte einen Ort auf, wo er weinen konnte, und ging in sein Gemach und weinte daselbst. ");
INSERT INTO deu1951_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Dann aber wusch er sein Angesicht, ging hinaus, nahm sich zusammen und sprach: Tragt das Essen auf! ");
INSERT INTO deu1951_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Und man trug ihm und ihnen besonders auf, desgleichen den Ägyptern, die mit ihm aßen, auch besonders; denn die Ägypter dürfen nicht mit den Hebräern zusammen essen, es ist ihnen ein Greuel. ");
INSERT INTO deu1951_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Sie mußten aber vor ihm sitzen, der Erstgeborene zu oberst und der jüngste zu unterst, so daß die Männer einander verwundert anschauten. ");
INSERT INTO deu1951_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Und man trug ihnen von dem auf, was vor seinem Angesichte gestanden hatte; dem Benjamin aber ward fünfmal mehr aufgetragen als ihnen allen. Und sie tranken und wurden fröhlich mit ihm. ");
INSERT INTO deu1951_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Und Joseph befahl seinem Hofmeister und sprach: Fülle den Männern die Säcke mit Speise, soviel sie tragen mögen, und lege eines jeden Geld oben in seinen Sack; ");
INSERT INTO deu1951_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","meinen Becher aber, den silbernen Becher, lege oben in den Sack des Jüngsten samt dem Geld für das Korn! Er tat, wie Joseph ihm gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Und als der Morgen anbrach, ließ man die Männer samt ihren Eseln ziehen. ");
INSERT INTO deu1951_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Als sie aber zur Stadt hinaus und noch nicht weit gekommen waren, sprach Joseph zu seinem Hofmeister: Mache dich auf, jage den Männern nach, und wenn du sie eingeholt hast, sprich zu ihnen: Warum habt ihr Gutes mit Bösem vergolten? ");
INSERT INTO deu1951_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ist's nicht das, woraus mein Herr trinkt und wodurch er zu weissagen pflegt? Da habt ihr übel getan! ");
INSERT INTO deu1951_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Als er sie nun eingeholt hatte, redete er mit ihnen also. ");
INSERT INTO deu1951_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Sie aber sprachen: Warum redet mein Herr also mit uns? Das sei ferne von deinen Knechten, so etwas zu tun! ");
INSERT INTO deu1951_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Siehe, wir haben dir das Geld, das wir oben in unsren Säcken fanden, aus dem Lande Kanaan wieder zurückgebracht; wie sollten wir denn aus dem Hause deines Herrn Silber oder Gold gestohlen haben? ");
INSERT INTO deu1951_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bei welchem von deinen Knechten aber etwas gefunden wird, der soll sterben, und wir andern wollen deines Herrn Knechte sein! ");
INSERT INTO deu1951_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Er aber sprach: Sollte es jetzt gar noch nach euren Worten gehen? Nein, sondern bei wem er gefunden wird, der sei mein Knecht; ihr andern aber sollt ungestraft bleiben! ");
INSERT INTO deu1951_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Da ließen sie eilends ein jeder seinen Sack zur Erde gleiten und öffneten ein jeder seinen Sack. ");
INSERT INTO deu1951_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Er aber fing an zu suchen beim Ältesten und kam bis zum Jüngsten. Da fand sich der Becher in Benjamins Sack! ");
INSERT INTO deu1951_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Da zerrissen sie ihre Kleider und legten ein jeder seine Last auf seinen Esel und kehrten wieder in die Stadt zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Und Juda ging mit seinen Brüdern in Josephs Haus (denn er war noch daselbst) und sie fielen vor ihm auf die Erde nieder. ");
INSERT INTO deu1951_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph aber sprach zu ihnen: Was ist das für eine Tat, die ihr begangen habt? Wußtet ihr nicht, daß ein solcher Mann, wie ich bin, erraten kann? ");
INSERT INTO deu1951_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda antwortete: Was sollen wir meinem Herrn sagen? Was sollen wir reden, und wie sollen wir uns rechtfertigen? Gott hat die Missetat deiner Knechte gefunden! Siehe, wir sind unsres Herrn Knechte, wir und der, in dessen Hand der Becher gefunden worden ist! ");
INSERT INTO deu1951_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Er aber sprach: Das sei ferne von mir, solches zu tun! Der Mann, in dessen Hand der Becher gefunden worden ist, soll mein Knecht sein; ihr aber zieht in Frieden zu eurem Vater hinauf! ");
INSERT INTO deu1951_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Da trat Juda näher zu ihm hinzu und sprach: Bitte, mein Herr, laß deinen Knecht ein Wort reden vor den Ohren meines Herrn, und dein Zorn entbrenne nicht über deine Knechte; denn du bist wie der Pharao! ");
INSERT INTO deu1951_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mein Herr fragte seine Knechte und sprach: Habt ihr noch einen Vater oder Bruder? ");
INSERT INTO deu1951_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Da antworteten wir meinem Herrn: Wir haben einen alten Vater und einen jungen Knaben, der ihm in seinem Alter geboren ist, und dessen Bruder ist tot, und er ist allein übriggeblieben von seiner Mutter, und sein Vater hat ihn lieb. ");
INSERT INTO deu1951_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Da sprachst du zu deinen Knechten: Bringt ihn zu mir herab, damit ich ihn sehen kann! ");
INSERT INTO deu1951_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Da sprachen wir zu meinem Herrn: Der Knabe kann seinen Vater nicht verlassen; wenn er seinen Vater verließe, so würde dieser sterben. ");
INSERT INTO deu1951_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Du aber sprachst zu deinen Knechten: Wenn euer jüngster Bruder nicht mit euch herabkommt, so sollt ihr mein Angesicht nicht mehr sehen! ");
INSERT INTO deu1951_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Als wir nun zu deinem Knechte, unsrem Vater, kamen, verkündigten wir ihm die Worte unsres Herrn; ");
INSERT INTO deu1951_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","und als unser Vater sprach: Geht hin und kaufet uns wieder etwas zu essen, ");
INSERT INTO deu1951_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","da antworteten wir: Wir können nicht hinabziehen! Wenn unser jüngster Bruder bei uns ist, dann können wir gehen; denn wir dürfen das Angesicht des Mannes nicht sehen, wenn unser jüngster Bruder nicht bei uns ist! ");
INSERT INTO deu1951_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Da sprach dein Knecht, unser Vater zu uns: Ihr wisset, daß mir mein Weib zwei Söhne geboren hat; ");
INSERT INTO deu1951_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","einer ist von mir weggegangen, und ich habe ihn bis heute nicht mehr gesehen, so daß ich denken muß, ein wildes Tier habe ihn zerrissen. ");
INSERT INTO deu1951_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nehmt ihr nun diesen auch von mir und es begegnet ihm ein Unfall, so werdet ihr meine grauen Haare durch ein solches Unglück ins Totenreich hinunterbringen! ");
INSERT INTO deu1951_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Käme ich nun zu deinem Knechte, meinem Vater, und der Knabe wäre nicht bei mir, an dessen Seele doch seine Seele gebunden ist, ");
INSERT INTO deu1951_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","so würde es geschehen, wenn er sähe, daß der Knabe nicht da ist, daß er stürbe; und so würden wir, deine Knechte, die grauen Haare deines Knechtes, unsres Vaters, durch den Kummer ins Totenreich hinunterbringen. ");
INSERT INTO deu1951_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Denn dein Knecht hat sich bei meinem Vater für den Knaben verbürgt und versprochen: Wenn ich ihn dir nicht wiederbringe, so habe ich meinem Vater gegenüber mein ganzes Leben verwirkt. ");
INSERT INTO deu1951_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Darum will nun dein Knecht als Sklave meines Herrn hier bleiben anstatt des Knaben; der Knabe aber soll mit seinen Brüdern hinaufziehen. ");
INSERT INTO deu1951_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Denn wie könnte ich zu meinem Vater hinaufziehen, ohne daß der Knabe bei mir wäre? Ich möchte das Leid nicht sehen, das meinen Vater träfe! ");
INSERT INTO deu1951_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Da konnte sich Joseph vor allen, die um ihn herstanden, nicht länger enthalten, sondern rief: Tut jedermann von mir hinaus! Und es stand kein Mensch bei ihm, als Joseph sich seinen Brüdern zu erkennen gab. ");
INSERT INTO deu1951_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Und er weinte laut, so daß die Ägypter und das Haus des Pharao es hörten. ");
INSERT INTO deu1951_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Und Joseph sprach zu seinen Brüdern: Ich bin Joseph! Lebt mein Vater noch? Aber seine Brüder konnten ihm nicht antworten, so bestürzt waren sie vor ihm. ");
INSERT INTO deu1951_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Da sprach Joseph zu seinen Brüdern: Tretet doch her zu mir! Als sie nun näher kamen, sprach er zu ihnen: Ich bin Joseph, euer Bruder, den ihr nach Ägypten verkauft habt! ");
INSERT INTO deu1951_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Und nun bekümmert euch nicht und ärgert euch nicht darüber, daß ihr mich hierher verkauft habt; denn zur Lebensrettung hat mich Gott vor euch her gesandt! ");
INSERT INTO deu1951_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Denn dies ist das zweite Jahr, daß die Hungersnot im Lande herrscht, und es werden noch fünf Jahre ohne Pflügen und Ernten sein. ");
INSERT INTO deu1951_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Aber Gott hat mich vor euch hergesandt, damit ihr auf Erden überbleibt, und um euch am Leben zu erhalten zu einer großen Errettung. ");
INSERT INTO deu1951_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Und nun, nicht ihr habt mich hierher gesandt, sondern Gott: er hat mich dem Pharao zum Vater gesetzt und zum Herrn über sein ganzes Haus und zum Herrscher über ganz Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Zieht eilends zu meinem Vater hinauf und sagt ihm: So spricht dein Sohn Joseph: Gott hat mich zum Herrn über ganz Ägypten gesetzt; komm zu mir herab, säume nicht! ");
INSERT INTO deu1951_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Du sollst im Lande Gosen wohnen und nahe bei mir sein, du und deine Kinder und deine Kindeskinder, dein kleines und großes Vieh und alles, was dein ist. ");
INSERT INTO deu1951_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ich will dich daselbst mit Nahrung versorgen (denn es sind noch fünf Jahre Hungersnot), damit du nicht verarmest, du und dein Haus und alles, was dein ist. ");
INSERT INTO deu1951_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Und siehe, eure Augen sehen es und die Augen meines Bruders Benjamin, daß ich mündlich mit euch rede. ");
INSERT INTO deu1951_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Darum verkündiget meinem Vater alle meine Herrlichkeit in Ägypten und alles, was ihr gesehen habt, und bringet meinen Vater eilends herab hierher! ");
INSERT INTO deu1951_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Und er fiel seinem Bruder Benjamin um den Hals und weinte, und Benjamin weinte auch an seinem Halse. ");
INSERT INTO deu1951_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Und er küßte alle seine Brüder und weinte über ihnen, und darnach redeten seine Brüder mit ihm. ");
INSERT INTO deu1951_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Und als man im Hause des Pharao die Nachricht vernahm: Josephs Brüder sind gekommen! gefiel solches dem Pharao und seinen Knechten wohl. ");
INSERT INTO deu1951_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Und der Pharao sprach zu Joseph: Sage deinen Brüdern: Tut das: Beladet eure Tiere und macht euch auf den Weg; ");
INSERT INTO deu1951_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","und wenn ihr ins Land Kanaan kommt, so nehmt euren Vater und eure Familien und kommt zu mir, so will ich euch das Beste des Landes Ägypten geben, und ihr sollt das Fett des Landes essen! ");
INSERT INTO deu1951_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Und du, ordne solches an: Tut also: Nehmt euch Wagen mit aus Ägyptenland für eure Kinder und Weiber und führet euren Vater und kommt; ");
INSERT INTO deu1951_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","und euer Hausrat darf euch nicht reuen; denn das Beste des ganzen Landes Ägypten soll euer sein! ");
INSERT INTO deu1951_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Die Söhne Israels taten also; und Joseph gab ihnen Wagen nach dem Befehl des Pharao, auch gab er ihnen Zehrung auf den Weg, ");
INSERT INTO deu1951_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","und schenkte ihnen allen, einem jeden, ein Feierkleid; Benjamin aber schenkte er dreihundert Silberlinge. ");
INSERT INTO deu1951_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Und seinem Vater sandte er folgendes: zehn Esel, beladen mit ägyptischen Gütern, und zehn Eselinnen, welche Korn, Brot und Speise trugen für seinen Vater auf den Weg. ");
INSERT INTO deu1951_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Damit entließ er seine Brüder, und sie gingen, und er sprach zu ihnen: Zankt euch nicht auf dem Wege! ");
INSERT INTO deu1951_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Also reisten sie von Ägypten hinauf und kamen ins Land Kanaan zu ihrem Vater Jakob; ");
INSERT INTO deu1951_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","und sie verkündigten ihm und sprachen: Joseph lebt noch und ist Herrscher über ganz Ägyptenland! Aber sein Herz blieb kalt; denn er glaubte ihnen nicht. ");
INSERT INTO deu1951_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Da sagten sie ihm alle Worte Josephs, die er zu ihnen geredet hatte; und als er die Wagen sah, die Joseph gesandt hatte, ihn zu führen, ward der Geist ihres Vaters Jakob lebendig; ");
INSERT INTO deu1951_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","und Israel sprach: Ich habe genug, daß mein Sohn Joseph noch lebt! Ich will hingehen und ihn sehen, ehe denn ich sterbe! ");
INSERT INTO deu1951_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Und Israel brach auf mit allem, was er hatte; und als er nach Beerseba kam, opferte er daselbst dem Gott seines Vaters Isaak. ");
INSERT INTO deu1951_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Und Gott sprach zu Israel im Nachtgesicht: Jakob, Jakob! Er sprach: Hier bin ich! ");
INSERT INTO deu1951_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Da sprach er: Ich bin der starke Gott, der Gott deines Vaters; fürchte dich nicht, nach Ägypten hinabzuziehen; denn daselbst will ich dich zu einem großen Volke machen! ");
INSERT INTO deu1951_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ich will mit dir hinab nach Ägypten ziehen, und ich führe dich gewiß auch wieder hinauf; und Joseph soll dir die Augen zudrücken! ");
INSERT INTO deu1951_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Da machte sich Jakob von Beerseba auf, und die Kinder Israels führten ihren Vater Jakob samt ihren Kindern und Weibern auf den Wagen, welche der Pharao gesandt hatte, um ihn hinzuführen. ");
INSERT INTO deu1951_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Sie nahmen auch ihr Vieh und ihre Habe, die sie im Lande Kanaan erworben hatten, und kamen nach Ägypten, Jakob und all sein Same mit ihm: ");
INSERT INTO deu1951_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","seine Söhne und Enkel, seine Töchter und Enkelinnen, kurz allen seinen Samen brachte er mit sich nach Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dieses aber sind die Namen der Kinder Israels, die nach Ägypten kamen: Jakob und seine Söhne. Der erstgeborne Sohn Jakobs: Ruben. ");
INSERT INTO deu1951_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Die Kinder Rubens: Hanoch, Pallu, Hezron und Karmi. ");
INSERT INTO deu1951_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Die Kinder Simeons: Jemuel, Jamin, Ohad, Jachin, Zohar und Saul, der Sohn von dem kanaanäischen Weibe. ");
INSERT INTO deu1951_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Die Kinder Levis: Gerson, Kahath und Merari. ");
INSERT INTO deu1951_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Die Kinder Judas: Er, Onan, Perez und Serah. Aber Er und Onan starben im Lande Kanaan. Die Kinder des Perez aber waren Hezron und Hamul. ");
INSERT INTO deu1951_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Die Kinder Issaschars: Thola, Puva, Job und Simron. ");
INSERT INTO deu1951_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Die Kinder Sebulons: Sered, Elon und Jahleel. ");
INSERT INTO deu1951_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Das sind die Kinder von Lea, die sie dem Jakob in Mesopotamien gebar, samt seiner Tochter Dina. Diese machen zusammen, mit Söhnen und Töchtern, dreiunddreißig Seelen aus. ");
INSERT INTO deu1951_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Die Kinder Gads: Ziphion, Haggi, Suni, Ezbon, Eri, Arodi und Areli. ");
INSERT INTO deu1951_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Die Kinder Assers: Jimna, Jiswa, Jiswi, Beria und Serah, ihre Schwester. Und die Kinder Berias: Heber und Malkiel. ");
INSERT INTO deu1951_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Das sind die Kinder von Silpa, welche Laban seiner Tochter Lea gab; sie gebar dem Jakob diese sechzehn Seelen. ");
INSERT INTO deu1951_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Die Kinder Rahels, des Weibes Jakobs: Joseph und Benjamin. ");
INSERT INTO deu1951_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Und dem Joseph wurden in Ägypten Manasse und Ephraim geboren, die ihm Asnath, die Tochter Potipheras, des Priesters zu On, gebar. ");
INSERT INTO deu1951_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Die Kinder Benjamins: Bela, Becher, Asbel, Gera, Naaman, Ehi, Rosch, Mupim, Hupim und Ard. ");
INSERT INTO deu1951_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Das sind die Kinder von Rahel, die dem Jakob geboren wurden, alle zusammen vierzehn Seelen. ");
INSERT INTO deu1951_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Die Kinder Dans: Husim. ");
INSERT INTO deu1951_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Die Kinder Naphtalis: Jahzeel, Guni, Jezer und Sillem. ");
INSERT INTO deu1951_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Das sind die Kinder von Bilha, die Laban seiner Tochter Rahel gab; sie gebar dem Jakob in allem sieben Seelen. ");
INSERT INTO deu1951_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Alle Seelen, die mit Jakob nach Ägypten kamen, welche von seinen Lenden ausgegangen waren, ausgenommen die Weiber der Söhne Jakobs, sind zusammen sechsundsechzig Seelen. ");
INSERT INTO deu1951_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Und die Kinder Josephs, die ihm in Ägypten geboren sind, waren zwei Seelen, also daß alle Seelen des Hauses Jakobs, die nach Ägypten kamen, siebzig waren. ");
INSERT INTO deu1951_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Er hatte aber den Juda vor sich her zu Joseph gesandt, daß er ihn zur Begegnung nach Gosen weise. ");
INSERT INTO deu1951_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Als sie nun ins Land Gosen kamen, spannte Joseph seinen Wagen an und fuhr seinem Vater nach Gosen entgegen. Und als er ihn sah, fiel er ihm um den Hals und weinte lange an seinem Halse. ");
INSERT INTO deu1951_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Und Israel sprach zu Joseph: Nun will ich gerne sterben, nachdem ich dein Angesicht geschaut habe und sehe, daß du noch lebst! ");
INSERT INTO deu1951_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph aber sprach zu seinen Brüdern und zu seines Vaters Hause: Ich will hinaufgehen und es dem Pharao anzeigen und ihm sagen: Meine Brüder und meines Vaters Haus, die in Kanaan waren, sind zu mir gekommen; ");
INSERT INTO deu1951_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","und die Männer sind Schafhirten, sie sind Viehzüchter und haben ihre Schafe und Rinder und alles, was ihnen gehört, mitgebracht. ");
INSERT INTO deu1951_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Wenn euch dann der Pharao rufen läßt und euch fragt: Was treibt ihr? ");
INSERT INTO deu1951_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","So sollt ihr sagen: Deine Knechte sind Viehzüchter gewesen von ihrer Jugend auf bisher, wir und unsre Väter! Dann werdet ihr im Lande Gosen wohnen dürfen, weil alle Hirten den Ägyptern ein Greuel sind. ");
INSERT INTO deu1951_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Und Joseph kam und zeigte es dem Pharao an und sprach: Mein Vater und meine Brüder sind aus dem Lande Kanaan gekommen samt ihren Schafen und Rindern, und siehe, sie sind im Lande Gosen! ");
INSERT INTO deu1951_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Er hatte aber aus der Zahl seiner Brüder fünf mitgenommen und stellte sie dem Pharao vor. ");
INSERT INTO deu1951_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Und der Pharao fragte seine Brüder: Was treibt ihr? Sie antworteten ihm: Deine Knechte sind Schafhirten, wir und unsre Väter. ");
INSERT INTO deu1951_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Und sie sprachen zum Pharao: Wir sind gekommen, um uns im Lande aufzuhalten; denn deine Knechte haben keine Weide für ihr Vieh, so hart beschwert die Hungersnot das Land Kanaan; und nun möchten deine Knechte gerne im Lande Gosen wohnen. ");
INSERT INTO deu1951_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Da sprach der Pharao zu Joseph: Dein Vater und deine Brüder sind zu dir gekommen; ");
INSERT INTO deu1951_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","das Land Ägypten steht dir offen; laß deinen Vater und deine Brüder am besten Ort des Landes wohnen, im Lande Gosen sollen sie wohnen; und wenn du weißt, daß unter ihnen tüchtige Leute sind, so setze sie zu Aufsehern über mein Vieh! ");
INSERT INTO deu1951_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joseph brachte auch seinen Vater Jakob hinein und stellte ihn dem Pharao vor; und Jakob segnete den Pharao. ");
INSERT INTO deu1951_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Und der Pharao fragte Jakob: Wie alt bist du? ");
INSERT INTO deu1951_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob sprach zum Pharao: Die ganze Zeit meiner Pilgrimschaft beträgt hundertunddreißig Jahre; wenig und böse sind meine Lebensjahre gewesen und erreichen nicht die Zahl der Lebensjahre meiner Väter in den Tagen ihrer Pilgrimschaft. ");
INSERT INTO deu1951_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Und Jakob segnete den Pharao und ging hinaus von Pharaos Angesicht. ");
INSERT INTO deu1951_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Und Joseph wies seinem Vater und seinen Brüdern Wohnsitz an und gab ihnen ein Besitztum im Lande Ägypten, am besten Orte des Landes, in der Landschaft Ramses, wie der Pharao befohlen hatte. ");
INSERT INTO deu1951_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Und Joseph versorgte seinen Vater und seine Brüder und das ganze Haus seines Vaters mit Brot nach der Zahl der Kinder. ");
INSERT INTO deu1951_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Es war aber im ganzen Lande kein Brot; denn die Hungersnot war sehr schwer und Ägyptenland war erschöpft, ebenso das Land Kanaan, wegen der Hungersnot. ");
INSERT INTO deu1951_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Und Joseph brachte alles Geld zusammen, das in Ägypten und im Lande Kanaan gefunden ward, um Korn zu kaufen; und Joseph brachte das Geld in das Haus des Pharao. ");
INSERT INTO deu1951_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Da nun das Geld ausgegangen war in Ägyptenland und in Kanaan, kamen alle Ägypter zu Joseph und sprachen: Gib uns Brot! Warum sollen wir vor dir sterben, weil wir kein Brot haben? ");
INSERT INTO deu1951_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph sprach: Bringet euer Vieh her, so will ich euch geben als Entgelt für euer Vieh, wenn ihr ohne Geld seid! ");
INSERT INTO deu1951_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Da brachten sie ihr Vieh zu Joseph; und er gab ihnen Brot um Pferde, Schafe, Rinder und Esel, und versorgte sie also in jenem Jahre mit Brot um den Preis ihres Viehs. ");
INSERT INTO deu1951_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Als nun jenes Jahr verflossen war, kamen sie zu ihm im andern Jahr und sprachen: Wir wollen unserm Herrn nicht verhehlen, daß, weil das Geld ausgegangen ist und das Vieh unserm Herrn gehört, nunmehr nichts mehr übrigbleibt vor unserm Herrn als unser Leib und unser Feld! ");
INSERT INTO deu1951_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Warum sollen wir umkommen vor deinen Augen, wir und unser Feld? Kaufe uns samt unserm Feld um Brot, daß wir und unser Feld dem Pharao dienstbar seien! Gib uns Samen, daß wir leben und nicht sterben, und daß das Land nicht zur Wüste werde! ");
INSERT INTO deu1951_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Also kaufte Joseph alles Ackerland der Ägypter für den Pharao auf, denn die Ägypter verkauften ein jeder sein Feld; denn die Hungersnot zwang sie dazu; und so ward das Land des Pharao Eigentum. ");
INSERT INTO deu1951_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Das Volk aber machte er zu leibeigenen Knechten, von einem Ende Ägyptens bis zum andern. ");
INSERT INTO deu1951_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nur die Äcker der Priester kaufte er nicht; denn die Priester bekamen ihr Bestimmtes vom Pharao und nährten sich von ihrem festen Einkommen, das ihnen der Pharao gab; darum brauchten sie ihre Äcker nicht zu verkaufen. ");
INSERT INTO deu1951_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Und Joseph sprach zum Volk: Ich habe euch heute samt eurem Land für den Pharao gekauft; hier ist Samen für euch, besäet das Land. ");
INSERT INTO deu1951_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Aber vom Ertrag habt ihr dem Pharao den Fünften zu geben, und vier Teile sollen euer sein zum Besäen der Felder und zum Unterhalt für euch selbst und euer Gesinde und zur Nahrung für eure Kinder. ");
INSERT INTO deu1951_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Da sprachen sie: Du hast uns das Leben erhalten! Finden wir Gnade in deinen Augen, so wollen wir des Pharao Knechte sein! ");
INSERT INTO deu1951_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Da machte Joseph solches zum Gesetz bis auf den heutigen Tag, daß vom Ertrag des Ackerlandes der Ägypter dem Pharao der Fünfte zu geben sei; nur die Äcker der Priester wurden nicht des Pharao Eigentum. ");
INSERT INTO deu1951_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Und Israel wohnte in Ägypten, im Lande Gosen, und sie nahmen es in Besitz, waren fruchtbar und mehrten sich sehr. ");
INSERT INTO deu1951_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Und Jakob lebte noch siebzehn Jahre in Ägyptenland, also daß seine ganze Lebenszeit hundertundsiebenundvierzig Jahre betrug. ");
INSERT INTO deu1951_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Als nun die Zeit kam, daß Israel sterben sollte, rief er seinen Sohn Joseph und sprach zu ihm: Habe ich Gnade vor deinen Augen gefunden, so lege doch deine Hand unter meine Hüfte und erweise mir Liebe und Treue: Begrabe mich doch ja nicht in Ägypten! ");
INSERT INTO deu1951_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Sondern ich will bei meinen Vätern liegen; darum sollst du mich aus Ägypten führen und mich in ihrem Grabe begraben. Er sprach: Ich will tun, wie du gesagt hast! ");
INSERT INTO deu1951_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Er aber sprach: So schwöre mir! Da schwur er ihm. Und Israel verbeugte sich vor dem Haupt des Stammes. ");
INSERT INTO deu1951_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Darnach ward dem Joseph gesagt: Siehe, dein Vater ist krank! Und er nahm mit sich seine zwei Söhne, Manasse und Ephraim. ");
INSERT INTO deu1951_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Da ward dem Jakob angezeigt und gesagt: Siehe, dein Sohn Joseph kommt zu dir! Und Israel machte sich stark und setzte sich auf im Bett. ");
INSERT INTO deu1951_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Und Jakob sprach zu Joseph: Der allmächtige Gott erschien mir zu Lus im Lande Kanaan und segnete mich ");
INSERT INTO deu1951_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","und sprach zu mir: Siehe, ich will dich fruchtbar machen und dich mehren und dich zu einer Völkergemeinde machen, und ich will deinem Samen nach dir dieses Land zur Besitzung geben ewiglich. ");
INSERT INTO deu1951_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","So sollen nun deine beiden Söhne, Ephraim und Manasse, die dir in Ägypten geboren sind, ehe ich zu dir nach Ägypten gekommen bin, mein sein; wie Ruben und Simeon sollen sie mein sein. ");
INSERT INTO deu1951_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Die Kinder aber, welche du nach ihnen zeugest, sollen dein sein und sollen in ihrem Erbteil nach ihrer Brüder Namen genannt werden. ");
INSERT INTO deu1951_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Und als ich aus Mesopotamien kam, starb Rahel bei mir im Lande Kanaan, auf dem Wege, als wir nur ein Stück Weges von Ephrata entfernt waren, und ich begrub sie daselbst an dem Wege gen Ephrata, die jetzt Bethlehem heißt. ");
INSERT INTO deu1951_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Als aber Israel Josephs Söhne sah, fragte er: Wer sind diese? ");
INSERT INTO deu1951_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph antwortete: Es sind meine Söhne, die mir Gott hier geschenkt hat! Er sprach: Bring sie doch her zu mir, daß ich sie segne! ");
INSERT INTO deu1951_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Denn Israels Augen waren vom Alter kurzsichtig geworden, daß er nicht mehr sehen konnte. Als er sie nun zu ihm brachte, küßte und umarmte er sie. ");
INSERT INTO deu1951_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Und Israel sprach zu Joseph: Daß ich dein Angesicht noch sehen dürfte, darum hätte ich nicht zu bitten gewagt; und nun, siehe, hat mich Gott sogar deine Kinder sehen lassen! ");
INSERT INTO deu1951_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Und Joseph nahm sie von seinen Knien und warf sich auf sein Angesicht zur Erde nieder. ");
INSERT INTO deu1951_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Darnach nahm er sie beide, Ephraim in seine Rechte, zur Linken Israels, und Manasse in seine Linke, zur Rechten Israels, und brachte sie zu ihm. ");
INSERT INTO deu1951_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Da streckte Israel seine Rechte aus und legte sie auf Ephraims Haupt, obschon er der jüngere war, seine Linke aber auf Manasses Haupt, indem er also seine Hände verschränkte, wiewohl Manasse der Erstgeborene war. ");
INSERT INTO deu1951_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Und er segnete Joseph und sprach: Der Gott, vor dessen Angesicht meine Väter Abraham und Isaak gewandelt haben; der Gott, der mich behütet hat, seitdem ich bin, bis auf diesen Tag; ");
INSERT INTO deu1951_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","der Engel, der mich erlöset hat von allem Übel, der segne die Knaben, und durch sie werde mein Name genannt und der Name meiner Väter Abraham und Isaak, und sie sollen zu einer großen Menge werden auf Erden! ");
INSERT INTO deu1951_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Als aber Joseph sah, daß sein Vater die rechte Hand auf Ephraims Haupt legte, gefiel es ihm übel; darum ergriff er seines Vaters Hand, um sie von Ephraims Haupt auf Manasses Haupt zu wenden. ");
INSERT INTO deu1951_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Dabei sprach Joseph zu seinem Vater: Nicht also, mein Vater; denn dieser ist der Erstgeborene; lege deine Rechte auf sein Haupt! ");
INSERT INTO deu1951_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aber sein Vater weigerte sich und sprach: Ich weiß es, mein Sohn, ich weiß es wohl! Auch er soll zu einem Volk, und auch er soll groß werden; aber doch soll sein jüngerer Bruder größer werden! ");
INSERT INTO deu1951_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Also segnete er sie an jenem Tag und sprach: Mit dir wird Israel segnen und sagen: Gott mache dich wie Ephraim und Manasse! Also setzte er Ephraim dem Manasse voran. ");
INSERT INTO deu1951_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Und Israel sprach zu Joseph: Siehe, ich sterbe; aber Gott wird mit euch sein und wird euch in das Land eurer Väter zurückbringen. ");
INSERT INTO deu1951_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Und ich schenke dir einen Bergesrücken, den du vor deinen Brüdern voraushaben sollst; ich habe ihn den Amoritern mit meinem Schwert und meinem Bogen aus der Hand genommen. ");
INSERT INTO deu1951_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Und Jakob berief seine Söhne und sprach: Kommt zusammen, daß ich euch kundtue, was euch in künftigen Tagen begegnen wird! ");
INSERT INTO deu1951_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Versammelt euch und merket auf, ihr Söhne Jakobs, höret auf euren Vater Israel! ");
INSERT INTO deu1951_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, du bist mein erstgeborner Sohn, meine Kraft und der Anfang meiner Stärke, von hervorragender Würde und vorzüglicher Kraft. ");
INSERT INTO deu1951_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Du warst wie kochendes Wasser, du sollst nicht den Vorzug haben; denn du bist auf deines Vaters Bett gestiegen, hast dazumal mein Lager entweiht; er stieg hinauf! ");
INSERT INTO deu1951_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Die Brüder Simeon und Levi Mordwerkzeuge sind ihre Messer! ");
INSERT INTO deu1951_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Meine Seele komme nicht in ihren Kreis und meine Ehre vereine sich nicht mit ihrer Versammlung! Denn in ihrem Zorn haben sie Männer gemordet und in ihrer Willkür Ochsen verstümmelt. ");
INSERT INTO deu1951_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Verflucht sei ihr Zorn, weil er so heftig, und ihr Grimm, weil er so hartnäckig ist! Ich will sie verteilen unter Jakob und zerstreuen unter Israel. ");
INSERT INTO deu1951_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Dich, Juda, werden deine Brüder loben! Deine Hand wird auf dem Nacken deiner Feinde sein; vor dir werden deines Vaters Kinder sich neigen. ");
INSERT INTO deu1951_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda ist ein junger Löwe; mit Beute beladen stiegst du, mein Sohn, empor! Er ist niedergekniet und hat sich gelagert wie ein Löwe und wie eine Löwin; wer darf ihn aufwecken? ");
INSERT INTO deu1951_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Es wird das Zepter nicht von Juda weichen, noch der Herrscherstab von seinen Füßen, bis daß der Schilo kommt und ihm die Völkerschaften unterworfen sind. ");
INSERT INTO deu1951_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Er wird sein Füllen an den Weinstock binden; und der Eselin Junges an die Edelrebe; er wird sein Kleid im Weine waschen und seinen Mantel in Traubenblut; ");
INSERT INTO deu1951_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","seine Augen sind dunkel vom Wein und seine Zähne weiß von Milch. ");
INSERT INTO deu1951_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon wird an der Anfurt des Meeres wohnen und den Schiffen zur Anfurt dienen, und er lehnt sich an Sidon an. ");
INSERT INTO deu1951_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issaschar ist ein knochiger Esel, der zwischen den Hürden liegt; ");
INSERT INTO deu1951_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","und weil er sah, daß die Ruhe gut und das Land lieblich war, so neigte er seine Schultern zum Tragen und wurde ein fronpflichtiger Knecht. ");
INSERT INTO deu1951_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan wird sein Volk richten als einer der Stämme Israels ");
INSERT INTO deu1951_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan wird eine Schlange am Wege sein, eine Otter auf dem Pfad, die das Roß in die Fersen beißt, daß der Reiter rücklings stürzt. ");
INSERT INTO deu1951_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O HERR, ich warte auf dein Heil! ");
INSERT INTO deu1951_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Den Gad drängt eine Schar; aber er drängt sie zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Für Asser ist sein Brot zu fett; aber er gibt königliche Leckerbissen. ");
INSERT INTO deu1951_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali ist eine ausgelassene Hirschkuh und kann schöne Worte machen. ");
INSERT INTO deu1951_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph ist ein junger Fruchtbaum, ein junger Fruchtbaum an der Quelle; seine Zweige klettern über die Mauer hinaus. ");
INSERT INTO deu1951_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Es haben ihn zwar die Schützen heftig beschossen und bekämpft; ");
INSERT INTO deu1951_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","aber sein Bogen blieb unerschütterlich und seine Arme und seine Hände wurden gelenkt von den Händen des Mächtigen Jakobs, vom Namen des Hirten, des Felsens Israels. ");
INSERT INTO deu1951_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Von deines Vaters Gott werde dir geholfen, und Gott der Allmächtige segne dich mit Segnungen vom Himmel herab, mit Segnungen der Tiefe, die unten liegt, mit Segnungen von Brüsten und Mutterschoß! ");
INSERT INTO deu1951_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Die Segnungen deines Vaters überragen die Segnungen meiner Eltern, sie reichen bis an die ewigen Hügel; mögen sie kommen auf Josephs Haupt, auf den Scheitel des Fürsten unter seinen Brüdern! ");
INSERT INTO deu1951_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin ist ein reißender Wolf; am Morgen verzehrt er Raub und am Abend teilt er sich in die Beute. ");
INSERT INTO deu1951_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Diese alle sind Stämme Israels, ihrer zwölf; und das ist's, was ihr Vater zu ihnen geredet und womit er sie gesegnet hat; und zwar segnete er einen jeden mit einem besonderen Segen. ");
INSERT INTO deu1951_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Und er gebot ihnen und sprach: Ich werde zu meinem Volk versammelt werden; begrabet mich bei meinen Vätern in der Höhle auf dem Acker Ephrons, des Hetiters, ");
INSERT INTO deu1951_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in der Höhle Machpelah, Mamre gegenüber im Lande Kanaan, wo Abraham den Acker gekauft hat von Ephron, dem Hetiter, zum Erbbegräbnis. ");
INSERT INTO deu1951_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Daselbst hat man Abraham und sein Weib Sarah begraben, desgleichen Isaak und sein Weib Rebekka, und dort habe ich auch Lea begraben; ");
INSERT INTO deu1951_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","der Acker und seine Höhle wurde den Hetitern abgekauft. ");
INSERT INTO deu1951_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Als aber Jakob seine Befehle an seine Söhne vollendet hatte, zog er seine Füße aufs Bett zurück, verschied und ward zu seinem Volke versammelt. ");
INSERT INTO deu1951_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Da fiel Joseph auf seines Vaters Angesicht und weinte über ihm und küßte ihn. ");
INSERT INTO deu1951_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Darnach befahl Joseph den Ärzten, die ihm dienten, daß sie seinen Vater einbalsamierten; und die Ärzte balsamierten Israel ein. ");
INSERT INTO deu1951_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Und sie verwendeten darauf volle vierzig Tage; denn so lange dauert die Einbalsamierung; aber beweint haben ihn die Ägypter siebzig Tage lang. ");
INSERT INTO deu1951_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Als aber die Tage der Trauer um ihn vorüber waren, redete Joseph mit dem Hause des Pharao und sprach: Habe ich Gnade gefunden in euren Augen, so redet doch vor Pharaos Ohren und sprechet: ");
INSERT INTO deu1951_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mein Vater hat einen Eid von mir genommen und zu mir gesagt: Siehe, ich sterbe; begrabe mich in meinem Grab, das ich mir im Lande Kanaan angelegt habe! So laß mich nun hinaufziehen, daß ich meinen Vater begrabe und darnach wiederkomme. ");
INSERT INTO deu1951_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Der Pharao sprach: Zieh hinauf und begrabe deinen Vater, wie er dich hat schwören lassen! ");
INSERT INTO deu1951_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Da zog Joseph hinauf, seinen Vater zu begraben; und es zogen mit ihm hinauf alle Knechte des Pharao, alle Ältesten seines Hauses und alle Ältesten des Landes Ägypten; ");
INSERT INTO deu1951_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","dazu das ganze Haus Josephs und seine Brüder und seines Vaters Haus; nur ihre Kinder, Schafe und Rinder ließen sie im Lande Gosen zurück. ");
INSERT INTO deu1951_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Es begleiteten ihn auch Wagen und Reiter, so daß es ein großes Heer gab. ");
INSERT INTO deu1951_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Als sie nun zur Tenne Atad kamen, welche jenseits des Jordan liegt, hielten sie daselbst eine große und feierliche Totenklage; denn er veranstaltete für seinen Vater eine siebentägige Trauer. ");
INSERT INTO deu1951_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Als aber die Bewohner des Landes, die Kanaaniter, die Trauer bei der Tenne Atad sahen, sprachen sie: Die Ägypter halten da eine große Klage! Daher wurde der Ort, welcher jenseits des Jordan liegt, «der Ägypter Klage» genannt. ");
INSERT INTO deu1951_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Seine Söhne aber machten es so, wie er ihnen befohlen hatte: ");
INSERT INTO deu1951_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","sie führten ihn ins Land Kanaan und begruben ihn in der Höhle des Ackers Machpelah, weil Abraham den Acker zum Erbbegräbnis gekauft hatte von Ephron, dem Hetiter, gegenüber von Mamre. ");
INSERT INTO deu1951_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Joseph aber kehrte nach dem Begräbnis seines Vaters wieder nach Ägypten zurück, er und seine Brüder und alle, die mit ihm hinaufgezogen waren, seinen Vater zu begraben. ");
INSERT INTO deu1951_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Als nun Josephs Brüder sahen, daß ihr Vater gestorben war, sprachen sie: Joseph könnte uns angreifen und uns all die Bosheit vergelten, die wir an ihm verübt haben! ");
INSERT INTO deu1951_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Darum ließen sie Joseph sagen: Dein Vater befahl vor seinem Tode und sprach: ");
INSERT INTO deu1951_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Also sollt ihr zu Joseph sagen: Bitte, vergib doch deinen Brüdern die Missetat und ihre Sünde, daß sie so übel an dir getan! So vergib nun den Dienern des Gottes deines Vaters ihre Missetat! Aber Joseph weinte, als sie ihm das sagen ließen. ");
INSERT INTO deu1951_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Da gingen seine Brüder selbst hin und fielen vor ihm nieder und sprachen: Siehe, wir sind deine Knechte! ");
INSERT INTO deu1951_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Aber Joseph sprach zu ihnen: Fürchtet euch nicht! Bin ich denn an Gottes Statt? ");
INSERT INTO deu1951_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ihr gedachtet zwar Böses wider mich; aber Gott gedachte es gut zu machen, daß er täte, wie es jetzt am Tage ist, um viel Volk am Leben zu erhalten. ");
INSERT INTO deu1951_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So fürchtet euch nun nicht; ich will euch und eure Kinder versorgen! Und er tröstete sie und redete freundlich mit ihnen. ");
INSERT INTO deu1951_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Und Joseph blieb in Ägypten, er und seines Vaters Haus; und Joseph lebte hundertundzehn Jahre. ");
INSERT INTO deu1951_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Und Joseph sah Ephraims Kinder bis in das dritte Glied; auch die Kinder Machirs, des Sohnes Manasses, saßen noch auf seinen Knien. ");
INSERT INTO deu1951_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Und Joseph sprach zu seinen Brüdern: Ich sterbe; aber Gott wird euch gewiß heimsuchen und aus diesem Lande hinaufführen in das Land, das er Abraham, Isaak und Jakob geschworen hat. ");
INSERT INTO deu1951_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Und er nahm einen Eid von den Kindern Israels und sprach: Wenn Gott euch heimsuchen wird, so sollt ihr meine Gebeine von hier hinaufbringen! ");
INSERT INTO deu1951_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Und Joseph starb, hundertundzehn Jahre alt; und man balsamierte ihn ein und legte ihn in einen Sarg in Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Dies sind die Namen der Söhne Israels, die mit Jakob nach Ägypten gekommen sind, ein jeglicher mit seinem Haus: ");
INSERT INTO deu1951_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi und Juda; ");
INSERT INTO deu1951_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issaschar, Sebulon und Benjamin; ");
INSERT INTO deu1951_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan und Naphtali, Gad und Asser. ");
INSERT INTO deu1951_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Die ganze Nachkommenschaft Jakobs aber betrug damals siebzig Seelen, Joseph inbegriffen, der schon in Ägypten war. ");
INSERT INTO deu1951_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Als aber Joseph gestorben war und alle seine Brüder und jenes ganze Geschlecht, ");
INSERT INTO deu1951_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","wuchsen die Kinder Israel, regten und mehrten sich und wurden so zahlreich, daß das Land von ihnen voll ward. ");
INSERT INTO deu1951_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Da kam ein neuer König auf über Ägypten, der nichts von Joseph wußte. ");
INSERT INTO deu1951_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Der sprach zu seinem Volk: Siehe, das Volk der Kinder Israel ist zahlreicher und stärker als wir. ");
INSERT INTO deu1951_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Wohlan, laßt uns kluge Maßnahmen gegen sie ergreifen, daß ihrer nicht zuviele werden; sie könnten sonst, falls sich ein Krieg wider uns erhöbe, zu unsern Feinden übergehen und wider uns kämpfen und aus dem Lande ziehen. ");
INSERT INTO deu1951_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Darum setzte man Fronvögte über sie, um sie durch Lasten zu drücken; man baute nämlich dem Pharao die Vorratsstädte Pitom und Raemses. ");
INSERT INTO deu1951_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Je mehr sie aber das Volk drückten, desto zahlreicher wurde es und desto mehr breitete es sich aus, also daß ihnen graute vor den Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Darum zwangen die Ägypter die Kinder Israel durch Mißhandlungen zum Dienst ");
INSERT INTO deu1951_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","und verbitterten ihnen das Leben mit harter Zwangsarbeit an Lehm und Ziegeln und mit allerlei Feldarbeit, lauter Arbeiten, zu welchen man sie unter Mißhandlungen zwang. ");
INSERT INTO deu1951_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Und der König von Ägypten redete mit den hebräischen Hebammen, deren eine Schiphra, die andere Pua hieß. ");
INSERT INTO deu1951_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Er sprach: Wenn ihr die Hebräerinnen entbindet, so sehet auf der Stelle nach; ist es ein Sohn, so tötet ihn, ist es aber eine Tochter, so lasset sie leben! ");
INSERT INTO deu1951_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Aber die Hebammen fürchteten Gott und taten nicht, wie ihnen der ägyptische König befohlen hatte, sondern ließen die Kinder leben. ");
INSERT INTO deu1951_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Da ließ der König die Hebammen rufen und fragte sie: Warum tut ihr das, daß ihr die Kinder leben lasset? ");
INSERT INTO deu1951_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Die Hebammen antworteten dem Pharao: Weil die hebräischen Frauen nicht sind wie die ägyptischen; sie sind lebhafter; ehe die Hebamme zu ihnen kommt, haben sie geboren! ");
INSERT INTO deu1951_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Dafür segnete Gott die Hebammen; das Volk aber vermehrte sich und nahm gewaltig zu. ");
INSERT INTO deu1951_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Und weil die Hebammen Gott fürchteten, so baute er ihnen Häuser. ");
INSERT INTO deu1951_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Da gebot der Pharao all seinem Volk und sprach: Werfet alle Söhne, die geboren werden, in den Nil; aber alle Töchter lasset leben! ");
INSERT INTO deu1951_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Und es ging hin ein Mann von dem Hause Levis und nahm eine Tochter Levis. ");
INSERT INTO deu1951_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Und das Weib empfing und gebar einen Sohn. Und als sie sah, daß er schön war, verbarg sie ihn drei Monate lang. ");
INSERT INTO deu1951_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Als sie ihn aber nicht länger verbergen konnte, nahm sie ein Kästlein von Rohr, und verklebte es mit Lehm und Pech, tat das Kind darein, und legte es in das Schilf am Gestade des Flusses. ");
INSERT INTO deu1951_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Aber seine Schwester stellte sich in einiger Entfernung hin, damit sie erführe, wie es ihm ergehen würde. ");
INSERT INTO deu1951_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Da kam die Tochter des Pharao herab, um im Flusse zu baden, und ihre Jungfrauen gingen an das Gestade des Flusses; und als sie das Kästlein mitten im Schilf sah, sandte sie ihre Magd hin und ließ es holen. ");
INSERT INTO deu1951_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Und als sie es öffnete, sah sie das Kind. Und siehe, es war ein weinendes Knäblein! Da erbarmte sie sich über dasselbe und sprach: Es ist eines der hebräischen Kinder! ");
INSERT INTO deu1951_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Da sprach seine Schwester zu der Tochter des Pharao: Soll ich hingehen und eine hebräische Säugamme rufen, daß sie dir das Kindlein säuge? ");
INSERT INTO deu1951_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Die Tochter des Pharao sprach zu ihr: Geh hin! Die Jungfrau ging hin und rief des Kindes Mutter. ");
INSERT INTO deu1951_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Da sprach des Pharao Tochter zu ihr: Nimm das Kindlein hin und säuge es mir, ich will dir deinen Lohn geben! Das Weib nahm das Kind und säugte es. ");
INSERT INTO deu1951_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Und als das Kind groß geworden, brachte sie es der Tochter des Pharao, und es ward ihr Sohn, und sie hieß ihn Mose. Denn sie sprach: Ich habe ihn aus dem Wasser gezogen. ");
INSERT INTO deu1951_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Zu der Zeit aber, als Mose groß geworden, ging er aus zu seinen Brüdern und sah ihre Lasten und sah, daß ein Ägypter einen Hebräer, einen seiner Brüder, schlug. ");
INSERT INTO deu1951_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Und er wandte sich hin und her, und als er sah, daß kein Mensch zugegen war, erschlug er den Ägypter und verscharrte ihn im Sand. ");
INSERT INTO deu1951_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Am zweiten Tag ging er auch aus, und siehe, zwei hebräische Männer zankten miteinander, und er sprach zu dem Schuldigen: Warum schlägst du deinen Nächsten? ");
INSERT INTO deu1951_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Er aber sprach: Wer hat dich zum Obersten und Richter über uns gesetzt? Gedenkst du mich auch zu erwürgen, wie du den Ägypter erwürgt hast? Da fürchtete sich Mose und sprach: Wahrlich, das ist ruchbar geworden! ");
INSERT INTO deu1951_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Und es kam vor den Pharao; der suchte Mose umzubringen. Aber Mose floh vor dem Pharao und hielt sich im Lande Midian auf und setzte sich an einen Brunnen. ");
INSERT INTO deu1951_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Aber der Priester in Midian hatte sieben Töchter; die kamen, um Wasser zu schöpfen, und füllten die Tränkrinnen, um ihres Vaters Schafe zu tränken. ");
INSERT INTO deu1951_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Da kamen die Hirten und jagten sie fort. Aber Mose machte sich auf und half ihnen und tränkte ihre Schafe. ");
INSERT INTO deu1951_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Und als sie zu ihrem Vater Reguel kamen, sprach er: Warum seid ihr heute so bald wiedergekommen? ");
INSERT INTO deu1951_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Sie sprachen: Ein ägyptischer Mann errettete uns von der Hand der Hirten und schöpfte uns Wasser genug und tränkte die Schafe. ");
INSERT INTO deu1951_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Er sprach zu seinen Töchtern: Wo ist er? Warum habt ihr den Mann stehen lassen? Ruft ihn her, daß er mit uns esse! ");
INSERT INTO deu1951_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Und Mose willigte ein, bei dem Mann zu bleiben; der gab ihm seine Tochter Zippora. ");
INSERT INTO deu1951_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Die gebar einen Sohn, den hieß er Gersom; denn er sprach: Ich bin ein Fremdling geworden in einem fremden Land. ");
INSERT INTO deu1951_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Aber viele Tage darnach starb der König in Ägypten. Und die Kinder Israel seufzten über ihre Knechtschaft und schrieen. Und ihr Geschrei über ihre Knechtschaft kam vor Gott. ");
INSERT INTO deu1951_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Und Gott erhörte ihr Wehklagen, und Gott gedachte an seinen Bund mit Abraham, Isaak und Jakob. ");
INSERT INTO deu1951_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Und Gott sah die Kinder Israel an, und Gott nahm Kenntnis davon. ");
INSERT INTO deu1951_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose aber hütete die Schafe Jethros, seines Schwiegervaters, des Priesters in Midian, und trieb die Schafe hinten in die Wüste und kam an den Berg Gottes Horeb. ");
INSERT INTO deu1951_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Und der Engel des HERRN erschien ihm in einer Feuerflamme mitten aus dem Dornbusch. Und als er sich umsah, siehe, da brannte der Dornbusch im Feuer, und der Dornbusch ward doch nicht verzehrt. ");
INSERT INTO deu1951_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Da sprach Mose: Ich will doch hinzutreten und diese große Erscheinung besehen, warum der Dornbusch nicht verbrennt! ");
INSERT INTO deu1951_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Als aber der HERR sah, daß er hinzutrat, um zu sehen, rief ihm Gott mitten aus dem Dornbusch und sprach: Mose, Mose! Er antwortete: Hier bin ich! ");
INSERT INTO deu1951_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Da sprach er: Komm nicht näher herzu! Ziehe deine Schuhe aus von deinen Füßen; denn der Ort, darauf du stehest, ist heiliges Land! ");
INSERT INTO deu1951_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Und er sprach: Ich bin der Gott deines Vaters, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs! Da verdeckte Mose sein Angesicht; denn er fürchtete sich, Gott anzuschauen. ");
INSERT INTO deu1951_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Und der HERR sprach: Ich habe das Elend meines Volkes in Ägypten angesehen und habe ihr Geschrei gehört über die, welche sie treiben; ja ich kenne ihre Schmerzen; ");
INSERT INTO deu1951_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","und ich bin herabgefahren, daß ich sie errette von der Ägypter Hand und sie ausführe aus diesem Land in ein gutes und weites Land, in ein Land, das von Milch und Honig fließt, an den Ort der Kanaaniter, Hetiter, Amoriter, Pheresiter, Heviter und Jebusiter. ");
INSERT INTO deu1951_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Und nun siehe, das Geschrei der Kinder Israel ist vor mich gekommen, und ich habe auch ihre Bedrückung gesehen, wie die Ägypter sie bedrücken! ");
INSERT INTO deu1951_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","So geh nun hin, ich will dich zu dem Pharao senden, daß du mein Volk, die Kinder Israel, aus Ägypten führest! ");
INSERT INTO deu1951_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mose sprach zu Gott: Wer bin ich, daß ich zum Pharao gehe, und daß ich die Kinder Israel aus Ägypten führe? ");
INSERT INTO deu1951_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Er sprach: Ich will mit dir sein; und dies soll dir das Zeichen sein, daß ich dich gesandt habe: Wenn du das Volk aus Ägypten geführt hast, werdet ihr auf diesem Berge Gott dienen. ");
INSERT INTO deu1951_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mose sprach zu Gott: Siehe, wenn ich zu den Kindern Israel komme und zu ihnen sage: Der Gott eurer Väter hat mich zu euch gesandt, und sie mich fragen werden: Wie heißt sein Name? Was soll ich ihnen sagen? ");
INSERT INTO deu1951_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Gott sprach zu Mose: «Ich bin, der ich bin!» Und er sprach: Also sollst du zu den Kindern Israel sagen: «Ich bin», der hat mich zu euch gesandt. ");
INSERT INTO deu1951_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Und nochmals sprach Gott zu Mose: Also sollst du zu den Kindern Israel sagen: Der HERR, der Gott eurer Väter, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs, hat mich zu euch gesandt; das ist mein Name ewiglich und meine Benennung für und für. ");
INSERT INTO deu1951_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Geh hin und versammle die Ältesten von Israel und sprich zu ihnen: Der HERR, der Gott eurer Väter, der Gott Abrahams, Isaaks und Jakobs, ist mir erschienen und hat gesagt: Ich habe achtgegeben auf euch und auf das, was euch in Ägypten widerfahren ist, ");
INSERT INTO deu1951_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","und ich sage euch: Ich will euch aus dem Elend Ägyptens herausführen in das Land der Kanaaniter, Hetiter, Amoriter, Pheresiter, Heviter und Jebusiter, in das Land, das von Milch und Honig fließt. ");
INSERT INTO deu1951_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Und wenn sie auf dich hören, so sollst du und die Ältesten von Israel zum König von Ägypten hineingehen und zu ihm sagen: Der HERR, der Hebräer Gott, ist uns begegnet. So laß uns nun drei Tagereisen weit in die Wüste gehen, daß wir dem HERRN, unserm Gott, opfern! ");
INSERT INTO deu1951_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Aber ich weiß, daß euch der König von Ägypten nicht wird ziehen lassen, wenn er nicht gezwungen wird durch eine starke Hand. ");
INSERT INTO deu1951_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Aber ich werde meine Hand ausstrecken und Ägypten mit allen meinen Wundern schlagen, die ich darin tun will; darnach wird er euch ziehen lassen. ");
INSERT INTO deu1951_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Und ich will diesem Volk Gunst verschaffen bei den Ägyptern, daß, wenn ihr auszieht, ihr nicht leer ausziehen müßt; ");
INSERT INTO deu1951_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","sondern ein jedes Weib soll von ihrer Nachbarin und Hausgenossin silberne und goldene Geschirre und Kleider fordern; die sollt ihr auf eure Söhne und Töchter legen und Ägypten berauben. ");
INSERT INTO deu1951_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Da antwortete Mose und sprach: Und wenn sie mir nicht glauben und nicht auf mich hören, sondern sagen: Der HERR ist dir nicht erschienen? ");
INSERT INTO deu1951_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Der HERR sprach zu ihm: Was hast du in deiner Hand? Er sprach: Einen Stab! ");
INSERT INTO deu1951_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Da sprach er: Wirf ihn von dir auf die Erde! Und er warf ihn auf die Erde; da ward er zur Schlange. Und Mose floh vor ihr. ");
INSERT INTO deu1951_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Aber der HERR sprach zu Mose: Strecke deine Hand aus und ergreife sie beim Schwanz! Da streckte er seine Hand aus und hielt sie. Und sie ward zum Stab in seiner Hand. ");
INSERT INTO deu1951_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Darum werden sie glauben, daß der HERR, der Gott ihrer Väter, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs, dir erschienen ist. ");
INSERT INTO deu1951_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Und der HERR sprach weiter zu ihm: Stecke doch deine Hand in deinen Busen! Da steckte er seine Hand in seinen Busen; und als er sie herauszog, siehe, da war seine Hand aussätzig wie Schnee. ");
INSERT INTO deu1951_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Und er sprach: Tue deine Hand wieder in deinen Busen! Und er tat seine Hand wieder in seinen Busen; und als er sie aus seinem Busen herauszog, siehe, da war sie wieder geworden wie sein übriges Fleisch. ");
INSERT INTO deu1951_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Wenn sie nun dir nicht glauben und nicht auf das erste Zeichen hören, so werden sie doch der Stimme des andern Zeichens glauben. ");
INSERT INTO deu1951_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Wenn sie aber auch diesem Zeichen nicht glauben, so nimm Wasser aus dem Fluß und gieß es auf das trockene Land, so wird das Wasser, das du aus dem Flusse genommen hast, auf dem trockenen Lande zu Blut werden. ");
INSERT INTO deu1951_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mose aber sprach zum HERRN: Ach mein Herr, ich bin kein Mann, der reden kann; ich bin es weder gestern noch vorgestern gewesen und auch nicht, seitdem du mit deinem Knechte geredet hast; denn ich habe einen schwerfälligen Mund und eine schwere Zunge! ");
INSERT INTO deu1951_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Da sprach der HERR zu ihm: Wer hat dem Menschen den Mund erschaffen, oder wer hat den Stummen, oder Tauben, oder Sehenden, oder Blinden gemacht? Habe nicht ich es getan, der HERR? ");
INSERT INTO deu1951_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","So geh nun hin: Ich will mit deinem Munde sein und dich lehren, was du sagen sollst! ");
INSERT INTO deu1951_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Da sprach Mose: Bitte, Herr, sende doch, wen du senden willst! ");
INSERT INTO deu1951_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Da ward der HERR sehr zornig über Mose und sprach: Weiß ich denn nicht, daß dein Bruder Aaron, der Levit, wohl reden kann? Und siehe, er kommt sogar heraus, dir entgegen, und wenn er dich sieht, so wird er sich von Herzen freuen. ");
INSERT INTO deu1951_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Du sollst mit ihm reden und die Worte in seinen Mund legen; so will ich mit deinem Munde und mit seinem Munde sein und euch lehren, was ihr tun sollt. ");
INSERT INTO deu1951_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Und er soll für dich zum Volke reden und soll dein Mund sein, und du sollst für ihn an Gottes Statt sein. ");
INSERT INTO deu1951_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Und nimm diesen Stab in deine Hand, damit du die Zeichen tun sollst! ");
INSERT INTO deu1951_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Da ging Mose hin und kehrte zu Jethro, seinem Schwiegervater, zurück und sprach zu ihm: Ich möchte zu meinen Brüdern zurückkehren, die in Ägypten sind, und sehen, ob sie noch leben. Jethro sprach zu ihm: Geh hin im Frieden! ");
INSERT INTO deu1951_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Und der HERR sprach zu Mose in Midian: Geh nach Ägypten zurück; denn die Leute sind alle tot, die nach deinem Leben trachteten! ");
INSERT INTO deu1951_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Also nahm Mose sein Weib und seine Söhne und ließ sie auf einem Esel reiten und zog wieder nach Ägypten. Mose nahm auch den Stab Gottes in die Hand. ");
INSERT INTO deu1951_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Und der HERR sprach zu Mose: Siehe zu, wenn du wieder nach Ägypten kommst, daß du vor dem Pharao alle die Wunder tuest, welche ich in deine Hand gegeben habe. Ich aber will sein Herz verstocken, daß er das Volk nicht wird ziehen lassen. ");
INSERT INTO deu1951_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Und du sollst zum Pharao sagen: So spricht der HERR: «Israel ist mein erstgeborener Sohn; ");
INSERT INTO deu1951_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","darum sage ich dir: Laß meinen Sohn gehen, daß er mir diene; wirst du dich aber weigern, ihn ziehen zu lassen, siehe, so will ich deinen eigenen erstgebornen Sohn erwürgen!» ");
INSERT INTO deu1951_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Als er aber unterwegs in der Herberge war, griff ihn der HERR an und wollte ihn töten. ");
INSERT INTO deu1951_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Da nahm Zippora einen scharfen Stein und beschnitt ihrem Sohn die Vorhaut und warf sie ihm vor die Füße und sprach: Du bist mir ein Blutbräutigam! ");
INSERT INTO deu1951_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Da ließ er von ihm ab. Sie sagte aber «Blutbräutigam» um der Beschneidung willen. ");
INSERT INTO deu1951_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Und der HERR sprach zu Aaron: Gehe hin, Mose entgegen in die Wüste! Da ging er hin und traf ihn am Berge Gottes und küßte ihn. ");
INSERT INTO deu1951_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Und Mose tat Aaron alle Worte des HERRN kund, womit er ihn beauftragt hatte, auch alle Zeichen, die er ihm befohlen hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Da gingen Mose und Aaron hin und versammelten alle Ältesten der Kinder Israel. ");
INSERT INTO deu1951_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Und Aaron redete alle Worte, die der HERR mit Mose geredet hatte; und er tat die Zeichen vor dem Volk. ");
INSERT INTO deu1951_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Und das Volk glaubte. Und als sie hörten, daß der HERR sich der Kinder Israel angenommen und daß er ihr Elend angesehen habe, neigten sie sich und beteten an. ");
INSERT INTO deu1951_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Darnach gingen Mose und Aaron hinein und redeten mit dem Pharao: So spricht der HERR, der Gott Israels: Laß mein Volk ziehen, daß es mir in der Wüste ein Fest halte! ");
INSERT INTO deu1951_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Der Pharao antwortete: Wer ist der HERR, dessen Stimme ich hören soll, um Israel ziehen zu lassen? Ich weiß nichts von dem HERRN, ich will auch Israel nicht ziehen lassen! ");
INSERT INTO deu1951_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Sie sprachen: Der Hebräer Gott ist uns begegnet; wir wollen hingehen drei Tagereisen weit in die Wüste und dem HERRN, unserm Gott, opfern, daß er uns nicht mit Pestilenz oder mit dem Schwerte schlage. ");
INSERT INTO deu1951_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Da sprach der König von Ägypten zu ihnen: Du, Mose und Aaron, warum zieht ihr das Volk von ihren Pflichten ab? Geht hin an eure Arbeit! ");
INSERT INTO deu1951_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Weiter sprach der Pharao: Siehe, des Volks ist schon zuviel im Lande; und ihr wollt sie noch von ihrer Arbeit feiern heißen? ");
INSERT INTO deu1951_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Und der Pharao befahl an demselben Tage den Treibern des Volks und seinen Amtleuten und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ihr sollt dem Volk kein Stroh mehr geben zum Ziegelstreichen, wie gestern und vorgestern. Laßt sie selbst hingehen und sich Stroh zusammensuchen. ");
INSERT INTO deu1951_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ihr sollt ihnen aber gleichwohl die bestimmte Zahl Ziegel, die sie gestern und vorgestern gemacht haben, auferlegen und davon nichts nachlassen; denn sie gehen müßig. Darum schreien sie und sprechen: Wir wollen hingehen und unserm Gott opfern! ");
INSERT INTO deu1951_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Man erschwere den Leuten die Arbeit, daß sie damit zu schaffen haben und sich nicht an falsche Worte kehren! ");
INSERT INTO deu1951_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Da gingen die Treiber des Volks und seine Amtleute aus, redeten mit dem Volk und sprachen: So spricht der Pharao: «Man gibt euch kein Stroh mehr; ");
INSERT INTO deu1951_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","geht ihr selbst hin, nehmt euch Stroh, wo ihr es findet, aber von eurem Tagewerk wird euch nichts erlassen!» ");
INSERT INTO deu1951_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Da zerstreute sich das Volk in das ganze Land Ägypten, daß es Stoppeln statt Stroh sammelte. ");
INSERT INTO deu1951_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Und die Treiber trieben sie und sprachen: Erfüllt euer bestimmtes Tagewerk, wie als ihr noch Stroh hattet! ");
INSERT INTO deu1951_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Und die Amtleute der Kinder Israel, welche die Treiber des Pharao über sie gesetzt hatten, wurden geschlagen, und es ward zu ihnen gesagt: Warum habt ihr weder heute noch gestern euer bestimmtes Tagewerk getan wie zuvor? ");
INSERT INTO deu1951_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Da gingen die Amtleute der Kinder Israel hinein und schrieen zu dem Pharao und sprachen: Warum willst du mit deinen Knechten also verfahren? ");
INSERT INTO deu1951_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Man gibt deinen Knechten kein Stroh und spricht zu uns: Machet die Ziegel! Und siehe, deine Knechte werden geschlagen; womit hat sich dein Volk versündigt? ");
INSERT INTO deu1951_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Er sprach: Ihr seid müßig, müßig seid ihr; darum sprechet ihr: Wir wollen hingehen und dem HERRN opfern! ");
INSERT INTO deu1951_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","So geht nun hin, arbeitet; Stroh soll man euch nicht geben, aber die bestimmte Anzahl Ziegel sollt ihr liefern! ");
INSERT INTO deu1951_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Da sahen die Amtleute der Kinder Israel, daß es mit ihnen übel stand, weil man sagte: Ihr sollt nichts nachlassen von der Zahl der Ziegel, die ihr täglich zu liefern habt. ");
INSERT INTO deu1951_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Und als sie von dem Pharao ausgingen, trafen sie Mose und Aaron an, die dort standen und auf sie warteten. ");
INSERT INTO deu1951_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Da sprachen sie zu ihnen: Der HERR sehe auf euch und richte es, daß ihr uns vor dem Pharao und seinen Knechten verhaßt gemacht und ihnen das Schwert in die Hand gegeben habt, uns zu töten. ");
INSERT INTO deu1951_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Da wandte sich Mose an den HERRN und sprach: Herr, warum lässest du dein Volk so schlecht behandeln? Warum hast du mich hergesandt? ");
INSERT INTO deu1951_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Denn seitdem ich hineingegangen bin, um mit dem Pharao in deinem Namen zu reden, hat er dieses Volk schlecht behandelt, und du hast dein Volk gar nicht errettet! ");
INSERT INTO deu1951_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Der HERR sprach zu Mose: Nun sollst du sehen, was ich dem Pharao tun will! Denn durch eine starke Hand gezwungen wird er sie ziehen lassen, und durch eine starke Hand gezwungen wird er sie aus seinem Lande treiben. ");
INSERT INTO deu1951_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Und Gott redete mit Mose und sprach zu ihm: Ich bin der HERR; ");
INSERT INTO deu1951_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ich bin Abraham, Isaak und Jakob erschienen als der allmächtige Gott; aber nach meinem Namen «HERR» habe ich mich ihnen nicht geoffenbart. ");
INSERT INTO deu1951_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Auch habe ich meinen Bund mit ihnen aufgerichtet, daß ich ihnen das Land Kanaan geben will, das Land ihrer Pilgrimschaft, darin sie Fremdlinge gewesen sind. ");
INSERT INTO deu1951_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Und ich habe auch das Seufzen der Kinder Israel gehört, weil die Ägypter sie zu Knechten machen, und habe an meinen Bund gedacht. ");
INSERT INTO deu1951_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Darum sage den Kindern Israel: Ich bin der HERR und will euch aus den Lasten Ägyptens herausführen und will euch von ihrer Knechtschaft erretten und will euch durch einen ausgestreckten Arm und große Gerichte erlösen. ");
INSERT INTO deu1951_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Und ich will euch mir zum Volk annehmen und will euer Gott sein; daß ihr erfahren sollt, daß ich, der HERR, euer Gott bin, der euch aus den Lasten Ägyptens herausführt. ");
INSERT INTO deu1951_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Und ich will euch in das Land bringen, darüber ich meine Hand aufgehoben habe, daß ich es Abraham, Isaak und Jakob gebe. Das will ich euch zu besitzen geben, ich, der HERR. ");
INSERT INTO deu1951_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose sagte solches den Kindern Israel. Sie aber hörten nicht auf ihn vor Mißmut und harter Arbeit. ");
INSERT INTO deu1951_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Da redete der HERR mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Geh hinein, sage dem Pharao, dem König von Ägypten, daß er die Kinder Israel aus seinem Lande ziehen lasse! ");
INSERT INTO deu1951_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mose aber redete vor dem HERRN und sprach: Siehe, die Kinder Israel hören mich nicht, wie sollte mich denn der Pharao hören? Dazu bin ich von unbeschnittenen Lippen! ");
INSERT INTO deu1951_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Also redete der HERR mit Mose und Aaron und gab ihnen Befehl an die Kinder Israel und an den Pharao, den König von Ägypten, daß sie die Kinder Israel aus Ägypten führeten. ");
INSERT INTO deu1951_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Dies sind die Häupter ihrer Vaterhäuser. Die Kinder Rubens, des erstgeborenen Sohnes Israels, sind diese: Hanoch, Pallu, Hezron, Karmi. Das sind die Geschlechter von Ruben. ");
INSERT INTO deu1951_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Die Kinder Simeons sind diese: Jemuel, Jamin, Ohad, Jachim, Zohar und Saul, der Sohn des kanaanäischen Weibes. Das sind die Geschlechter Simeons. ");
INSERT INTO deu1951_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Dies sind die Namen der Kinder Levis in ihren Geschlechtern: Gerson, Kahath und Merari; und Levi ward hundertsiebenunddreißig Jahre alt. ");
INSERT INTO deu1951_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Die Kinder Gersons sind diese: Libni und Simei in ihren Geschlechtern. ");
INSERT INTO deu1951_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Die Kinder Kahaths sind diese: Amram, Jizhar, Hebron, Ussiel. Kahath aber ward hundertdreiunddreißig Jahre alt. ");
INSERT INTO deu1951_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Die Kinder Meraris sind diese: Machli und Musi. Das sind die Geschlechter Levis nach ihrer Abstammung. ");
INSERT INTO deu1951_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Und Amram nahm seine Base Jochebed zum Weibe, die gebar ihm den Aaron und den Mose. Und Amram ward hundertsiebenunddreißig Jahre alt. ");
INSERT INTO deu1951_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Die Kinder Jizhars sind diese: Korah, Nepheg und Sichri. ");
INSERT INTO deu1951_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Die Kinder Ussiels sind diese: Misael, Elzaphan und Sitri. ");
INSERT INTO deu1951_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron aber nahm zum Weibe Eliseba, die Tochter Amminadabs, Nahassons Schwester, die gebar ihm den Nadab und den Abihu, den Eleasar und den Itamar. ");
INSERT INTO deu1951_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Die Kinder Korahs sind diese: Assir, Elkana und Abiasaph. Das sind die Geschlechter der Korahiter. ");
INSERT INTO deu1951_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasar aber, Aarons Sohn, nahm sich ein Weib von den Töchtern Putiels, die gebar ihm den Pinehas. Das sind die Häupter unter den Vätern der Leviten nach ihren Geschlechtern. ");
INSERT INTO deu1951_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Das ist der Aaron und der Mose, zu denen der HERR sprach: Führet die Kinder Israel nach ihren Heerscharen aus Ägypten! ");
INSERT INTO deu1951_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Sie sind es, die mit dem Pharao, dem König von Ägypten, redeten, daß sie die Kinder Israel aus Ägypten führeten, nämlich Mose und Aaron. ");
INSERT INTO deu1951_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Und an demselben Tag redete der HERR mit Mose in Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Da nun der HERR mit Mose redete und sprach: Ich bin der HERR, rede mit dem Pharao, dem König von Ägypten, alles, was ich mit dir rede; ");
INSERT INTO deu1951_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","da antwortete Mose vor dem HERRN: Siehe, ich bin von unbeschnittenen Lippen, wie wird mich denn der Pharao hören? ");
INSERT INTO deu1951_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Der HERR sprach zu Mose: Siehe zu, ich habe dich dem Pharao zum Gott gesetzt, und dein Bruder Aaron soll dein Prophet sein. ");
INSERT INTO deu1951_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Du sollst alles reden, was ich dir gebieten werde, daß er die Kinder Israel aus seinem Lande ziehen lasse. ");
INSERT INTO deu1951_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Aber ich will das Herz des Pharao verhärten, daß ich viele meiner Zeichen und Wunder tue im Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Aber der Pharao wird euch nicht hören, so daß ich meine Hand an Ägypten legen und mein Heer, mein Volk, die Kinder Israel, durch große Gerichte aus dem Lande Ägypten führen werde. ");
INSERT INTO deu1951_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Und die Ägypter sollen erfahren, daß ich der HERR bin, wenn ich meine Hand über Ägypten ausstrecken und die Kinder Israel von ihnen ausführen werde. ");
INSERT INTO deu1951_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mose und Aaron taten solches; wie ihnen der HERR geboten hatte, also taten sie. ");
INSERT INTO deu1951_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Und Mose war achtzig Jahre alt und Aaron dreiundachtzig Jahre alt, als sie mit dem Pharao redeten. ");
INSERT INTO deu1951_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Und der HERR sprach zu Mose und Aaron: ");
INSERT INTO deu1951_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Wenn der Pharao zu euch sagen wird: Tut ein Zeichen! so sollst du zu Aaron sagen: Nimm deinen Stab und wirf ihn vor den Pharao hin, so wird er zur Schlange werden. ");
INSERT INTO deu1951_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Da gingen Mose und Aaron zum Pharao und taten also, wie der HERR ihnen geboten hatte. Und Aaron warf seinen Stab vor den Pharao und vor seine Knechte hin, und er ward zur Schlange. ");
INSERT INTO deu1951_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Da berief der Pharao die Weisen und Zauberer. Und auch sie, die ägyptischen Zauberer, taten also mit ihrem Beschwören. ");
INSERT INTO deu1951_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Und ein jeder warf seinen Stab vor sich hin, und es wurden Schlangen daraus; aber Aarons Stab verschlang ihre Stäbe. ");
INSERT INTO deu1951_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Also ward das Herz des Pharao verstockt, und er hörte nicht auf sie, wie denn der HERR gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Und der HERR sprach zu Mose: Das Herz des Pharao ist hart; er weigert sich, das Volk ziehen zu lassen. ");
INSERT INTO deu1951_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Geh am Morgen hin zum Pharao; siehe, er wird hinaus ans Wasser gehen; tritt ihm entgegen am Gestade des Flusses und nimm den Stab, der zur Schlange geworden, in deine Hand ");
INSERT INTO deu1951_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","und sprich zu ihm: Der HERR, der Hebräer Gott, hat mich zu dir gesandt, um dir zu sagen: Laß mein Volk gehen, daß es mir in der Wüste diene! Aber siehe, du hast bisher nicht hören wollen. ");
INSERT INTO deu1951_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Darum spricht der HERR also: Daran sollst du erfahren, daß ich der HERR bin: Siehe, ich will mit dem Stabe, den ich in meiner Hand habe, das Wasser schlagen, das in dem Flusse ist, und es soll in Blut verwandelt werden, ");
INSERT INTO deu1951_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","so daß die Fische im Flusse sterben müssen und der Fluß stinken, und es die Ägypter ekeln wird, das Wasser aus dem Flusse zu trinken. ");
INSERT INTO deu1951_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Und der HERR sprach zu Mose: Sage zu Aaron: Nimm deinen Stab und strecke deine Hand aus über die Wasser in Ägypten, über ihre Flüsse, über ihre Bäche und über ihre Seen und über alle Wasserbehälter, daß sie zu Blut werden und daß in ganz Ägyptenland Blut sei in hölzernen und steinernen Geschirren. ");
INSERT INTO deu1951_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose und Aaron taten, wie ihnen der HERR geboten hatte. Und er hob den Stab auf und schlug vor dem Pharao und seinen Knechten das Wasser, das im Flusse war; da ward alles Wasser im Nil in Blut verwandelt. ");
INSERT INTO deu1951_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Und die Fische im Nil starben, und der Nil ward stinkend, so daß die Ägypter das Nilwasser nicht trinken konnten; denn dasselbe ward zu Blut in ganz Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Aber die ägyptischen Zauberer taten auch also mit ihrem Beschwören. Und so ward das Herz des Pharao verstockt, und er hörte nicht auf sie, wie denn der HERR geredet hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Und der Pharao wandte sich und ging heim und kehrte sein Herz auch daran nicht. ");
INSERT INTO deu1951_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Aber alle Ägypter gruben um den Fluß her nach Trinkwasser; denn das Nilwasser konnten sie nicht trinken. ");
INSERT INTO deu1951_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Und das währte sieben Tage lang, nachdem der HERR den Fluß geschlagen hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Der HERR sprach zu Mose: Geh hinein zum Pharao und sprich zu ihm: So spricht der HERR: Laß mein Volk gehen, daß es mir diene! ");
INSERT INTO deu1951_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Weigerst du dich aber, dasselbe ziehen zu lassen, siehe, so will ich alle deine Landmarken mit Fröschen plagen, ");
INSERT INTO deu1951_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","daß der Fluß von Fröschen wimmle; die sollen heraufkommen in dein Haus und in deine Schlafkammer und auf dein Bett; auch in die Häuser deiner Knechte, unter dein Volk, in deine Backöfen und in deine Backtröge; ");
INSERT INTO deu1951_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","und die Frösche sollen auf dich und auf dein Volk und auf alle deine Knechte kriechen. ");
INSERT INTO deu1951_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Und der HERR sprach zu Mose: Sage Aaron: Strecke deine Hand und deinen Stab aus über die Flüsse, über die Bäche und Seen, und laß Frösche über Ägyptenland kommen. ");
INSERT INTO deu1951_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Und Aaron streckte seine Hand über die Wasser in Ägypten; und die Frösche kamen herauf und bedeckten das Land Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Da taten die Zauberer mit ihrem Beschwören auch also und ließen Frösche über das Land Ägypten kommen. ");
INSERT INTO deu1951_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Da berief der Pharao den Mose und Aaron und sprach: Bittet den HERRN, daß er die Frösche von mir nehme und von meinem Volk, so will ich das Volk ziehen lassen, daß es dem HERRN opfere! ");
INSERT INTO deu1951_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose sprach zum Pharao: Du sollst die Ehre haben zu bestimmen, auf wann ich für dich, für deine Knechte und für dein Volk erbitten soll, daß die Frösche von dir und deinen Häusern vertrieben werden und nur im Flusse bleiben. ");
INSERT INTO deu1951_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Er sprach: Auf morgen! Da sprach Mose: Wie du gesagt hast; auf daß du erfahrest, daß niemand ist wie der HERR, unser Gott! ");
INSERT INTO deu1951_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","So sollen die Frösche von dir und von deinen Häusern, von deinen Knechten und von deinem Volke genommen werden; nur im Flusse sollen sie bleiben. ");
INSERT INTO deu1951_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Also gingen Mose und Aaron vom Pharao; und Mose schrie zum HERRN der Frösche wegen, die er dem Pharao auferlegt hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Und der HERR tat, wie Mose gesagt hatte. Die Frösche starben in den Häusern, in den Höfen und auf dem Felde. ");
INSERT INTO deu1951_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Und sie häuften dieselben zusammen, hier einen Haufen und dort einen Haufen; und das Land stank davon. ");
INSERT INTO deu1951_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Da aber der Pharao sah, daß er Luft gekriegt hatte, verhärtete er sein Herz und hörte nicht auf sie, wie denn der HERR gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Da sprach der HERR zu Mose: Sage zu Aaron: Strecke deinen Stab aus und schlage den Staub auf der Erde, daß er in ganz Ägyptenland zu Mücken werde. ");
INSERT INTO deu1951_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Sie taten also. Und Aaron streckte seine Hand aus mit seinem Stabe und schlug in den Staub auf der Erde, und er wurde zu Mücken in ganz Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Die Zauberer versuchten mit ihrem Beschwören auch Mücken hervorzubringen; aber sie konnten es nicht. Und die Mücken kamen über die Menschen und das Vieh. ");
INSERT INTO deu1951_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Da sprachen die Zauberer zu Pharao: Das ist Gottes Finger! Aber das Herz des Pharao war verstockt, daß er nicht auf sie hörte, wie der HERR gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Da sprach der HERR zu Mose: Mache dich morgen frühe auf und tritt zum Pharao (siehe, er wird ans Wasser gehen!) und sprich zu ihm: So spricht der HERR: Laß mein Volk gehen, daß es mir diene! ");
INSERT INTO deu1951_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Denn wenn du mein Volk nicht ziehen lässest, siehe, so will ich über dich und über deine Knechte und über dein Volk und über deine Häuser Hundsfliegen kommen lassen, daß der Ägypter Häuser und das Feld, darauf sie sind, voller Hundsfliegen werden sollen. ");
INSERT INTO deu1951_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Und ich will an demselben Tage mit dem Lande Gosen, da mein Volk wohnt, etwas Besonderes tun, daß keine Hundsfliegen daselbst seien, damit du erfahrest, daß ich, der HERR, inmitten des Landes bin. ");
INSERT INTO deu1951_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","So will ich eine Scheidung setzen zwischen meinem und deinem Volk. Morgen soll das Zeichen geschehen. ");
INSERT INTO deu1951_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Und der HERR tat also. Und eine Menge Hundsfliegen kamen in das Haus des Pharao und in die Häuser seiner Knechte, ja über ganz Ägyptenland; und das Land ward von den Hundsfliegen verseucht. ");
INSERT INTO deu1951_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Da berief der Pharao Mose und Aaron und sprach: Gehet hin, opfert eurem Gott in diesem Lande! ");
INSERT INTO deu1951_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mose sprach: Das schickt sich nicht, daß wir also tun; denn wir würden dem HERRN, unserm Gott, der Ägypter Greuel opfern! Siehe, wenn wir dann der Ägypter Greuel vor ihren Augen opferten, würden sie uns nicht steinigen? ");
INSERT INTO deu1951_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Drei Tagereisen weit wollen wir in die Wüste ziehen und dem HERRN, unserm Gott, opfern, wie er uns befehlen wird. ");
INSERT INTO deu1951_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Da sprach der Pharao: Ich will euch ziehen lassen, daß ihr dem HERRN, eurem Gott, in der Wüste opfert; aber ziehet ja nicht weiter! Bittet für mich! ");
INSERT INTO deu1951_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose sprach: Siehe, ich gehe hinaus von dir und will den HERRN bitten, daß die Hundsfliegen morgen vom Pharao, von seinen Knechten und von seinem Volke genommen werden; nur daß der Pharao uns nicht mehr täusche, indem er das Volk doch nicht ziehen läßt, dem HERRN zu opfern! ");
INSERT INTO deu1951_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Und Mose ging hinaus vom Pharao und bat den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Und der HERR tat, wie Mose gesagt hatte, also daß die Hundsfliegen vom Pharao, von seinen Knechten und von seinem Volke wichen, so daß nicht eine übrigblieb. ");
INSERT INTO deu1951_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Aber der Pharao verhärtete sein Herz auch diesmal und ließ das Volk nicht ziehen. ");
INSERT INTO deu1951_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Da sprach der HERR zu Mose: Gehe hinein zum Pharao und sprich zu ihm: So spricht der HERR, der Gott der Hebräer: Laß mein Volk gehen, daß es mir diene! ");
INSERT INTO deu1951_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Denn wenn du dich weigerst, sie ziehen zu lassen und sie weiter aufhältst, ");
INSERT INTO deu1951_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","siehe, so wird die Hand des HERRN kommen über dein Vieh auf dem Felde, über Pferde, Esel, Kamele, Rinder und Schafe, mit einer sehr schweren Viehseuche. ");
INSERT INTO deu1951_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Und der HERR wird einen Unterschied machen zwischen dem Vieh der Israeliten und dem Vieh der Ägypter, daß aus allem, was den Kindern Israel gehört, kein einziges sterbe. ");
INSERT INTO deu1951_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Und der HERR bestimmte eine Zeit und sprach: Morgen wird der HERR solches im Lande tun! ");
INSERT INTO deu1951_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Und der HERR tat solches am Morgen, und alles Vieh der Ägypter starb, aber von dem Vieh der Kinder Israel starb kein einziges. ");
INSERT INTO deu1951_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Und der Pharao sandte Boten hin, und siehe, von dem Vieh Israels war nicht eines gestorben. Gleichwohl blieb das Herz des Pharao verhärtet, daß er das Volk nicht gehen ließ. ");
INSERT INTO deu1951_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Da sprach der HERR zu Mose und Aaron: Nehmet eure Hände voll Ofenruß, und Mose sprenge ihn vor dem Pharao gen Himmel, ");
INSERT INTO deu1951_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","daß er über ganz Ägyptenland stäube und zu Geschwüren werde, die als Blattern aufbrechen an Menschen und Vieh in ganz Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Da nahmen sie Ofenruß und standen vor dem Pharao, und Mose sprengte ihn gen Himmel. Da wurden Geschwüre daraus, die als Blattern aufbrachen an Menschen und Vieh, ");
INSERT INTO deu1951_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","also daß die Zauberer wegen der Geschwüre nicht vor Mose stehen konnten. Denn an den Zauberern und an allen Ägyptern waren Geschwüre. ");
INSERT INTO deu1951_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Aber der HERR verstockte das Herz des Pharao, daß er nicht auf sie hörte, wie denn der HERR zu Mose gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Da sprach der HERR zu Mose: Mache dich am Morgen früh auf und tritt vor den Pharao und sprich zu ihm: So spricht der HERR, der Gott der Hebräer: Laß mein Volk gehen, daß es mir diene! ");
INSERT INTO deu1951_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Sonst will ich diesmal alle meine Plagen gegen dein Herz richten und gegen deine Knechte und gegen dein Volk, damit du erfahrest, daß auf der ganzen Erde nicht meinesgleichen ist. ");
INSERT INTO deu1951_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Denn ich hätte meine Hand schon ausstrecken und dich und dein Volk mit Pestilenz schlagen können, daß du von der Erde vertilgt worden wärest; ");
INSERT INTO deu1951_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","aber ich habe dich deswegen bestehen lassen, daß ich dir meine Macht zeige, und daß mein Name auf der ganzen Erde verkündigt werde. ");
INSERT INTO deu1951_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Stellst du dich aber meinem Volk noch weiter entgegen und willst es nicht ziehen lassen, ");
INSERT INTO deu1951_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","siehe, so will ich morgen um diese Zeit einen sehr schweren Hagel regnen lassen, desgleichen in Ägypten bisher nicht gewesen, seit der Zeit, da es gegründet wurde. ");
INSERT INTO deu1951_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Und nun laß dein Vieh und alles, was du auf dem Felde hast, in Sicherheit bringen; denn auf alle Menschen und alles Vieh, die sich auf dem Felde befinden und nicht in den Häusern versammelt sind, auf die wird der Hagel fallen, und sie werden umkommen. ");
INSERT INTO deu1951_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wer nun von den Knechten des Pharao des HERRN Wort fürchtete, der ließ seine Knechte und sein Vieh in die Häuser fliehen; ");
INSERT INTO deu1951_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","welcher Herz sich aber nicht an des HERRN Wort kehrte, die ließen ihre Knechte und ihr Vieh auf dem Felde. ");
INSERT INTO deu1951_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Da sprach der HERR zu Mose: Strecke deine Hand aus gen Himmel, damit es über ganz Ägyptenland hagle, über die Menschen und über das Vieh und über alles Gewächs auf dem Felde in Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Also streckte Mose seinen Stab gen Himmel. Und der HERR ließ donnern und hageln, daß das Feuer auf die Erde schoß. Und der HERR ließ Hagel regnen auf Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Es war aber zugleich Hagel und ein unaufhörliches Blitzen mitten in den Hagel hinein, so stark, daß desgleichen in ganz Ägypten niemals gewesen, seitdem es bevölkert ist. ");
INSERT INTO deu1951_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Und der Hagel erschlug in ganz Ägyptenland alles, was auf dem Felde war, Menschen und Vieh. Auch zerschlug der Hagel alles Gewächs auf dem Felde und zerbrach alle Bäume auf dem Lande. ");
INSERT INTO deu1951_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Nur im Lande Gosen, wo die Kinder Israel waren, hagelte es nicht. ");
INSERT INTO deu1951_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Da schickte der Pharao hin und ließ Mose und Aaron rufen und sprach zu ihnen: Diesmal habe ich mich versündigt! Der HERR ist gerecht; ich aber und mein Volk sind schuldig! ");
INSERT INTO deu1951_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bittet aber den HERRN, daß des Donners Gottes und des Hagels genug sei, so will ich euch ziehen lassen, damit ihr nicht länger hier bleibet! ");
INSERT INTO deu1951_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose sprach zu ihm: Wenn ich zur Stadt hinaus komme, so will ich meine Hände gegen den HERRN ausstrecken; so wird der Donner ablassen und kein Hagel mehr sein, damit du erfahrest, daß die Erde des HERRN ist! ");
INSERT INTO deu1951_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ich weiß aber, daß du und deine Knechte euch vor Gott, dem HERRN, noch nicht fürchtet. ");
INSERT INTO deu1951_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Es waren aber der Flachs und die Gerste zerschlagen; denn die Gerste hatte Ähren und der Flachs Knospen getrieben. ");
INSERT INTO deu1951_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Aber der Weizen und der Spelt waren nicht zerschlagen; denn die kommen später. ");
INSERT INTO deu1951_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Nun ging Mose vom Pharao weg zur Stadt hinaus und streckte seine Hand aus gegen den HERRN, und der Donner und der Hagel ließen nach, und der Regen fiel nicht mehr auf die Erde. ");
INSERT INTO deu1951_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Da aber der Pharao sah, daß der Regen, der Hagel und der Donner nachließen, versündigte er sich weiter und verhärtete sein Herz, er und seine Knechte. ");
INSERT INTO deu1951_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Also ward das Herz des Pharao verstockt, daß er die Kinder Israel nicht ziehen ließ, wie der HERR durch Mose geredet hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Da sprach der HERR zu Mose: Gehe zum Pharao, denn ich habe sein und seiner Knechte Herz verstockt, daß ich diese meine Zeichen unter ihnen tue, ");
INSERT INTO deu1951_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","und daß du vor den Ohren deiner Kinder und Kindeskinder verkündigest, was ich in Ägypten ausgerichtet und wie ich meine Zeichen unter ihnen bewiesen habe, auf daß ihr erkennet, daß ich der HERR bin. ");
INSERT INTO deu1951_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Also gingen Mose und Aaron zum Pharao und sprachen zu ihm: So spricht der HERR, der Gott der Hebräer: Wie lange willst du dich vor mir nicht demütigen? Laß mein Volk gehen, daß es mir diene! ");
INSERT INTO deu1951_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Wenn du dich aber weigerst, mein Volk ziehen zu lassen, siehe, so lasse ich morgen Heuschrecken in dein Land kommen, ");
INSERT INTO deu1951_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","und sie sollen das Land so bedecken, daß man die Erde nicht sehen kann, und sie sollen den Rest auffressen, der gerettet worden und von dem Hagel übriggeblieben ist, und sollen alle eure grünenden Bäume auf dem Felde kahl fressen ");
INSERT INTO deu1951_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","und sollen dein Haus und aller deiner Knechte Häuser und aller Ägypter Häuser anfüllen, wie es deine Väter und Vorväter nie gesehen haben, seitdem sie im Lande sind, bis auf diesen Tag. Und er wandte sich und ging vom Pharao hinaus. ");
INSERT INTO deu1951_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Da sprachen die Knechte des Pharao zu ihm: Wie lange soll uns dieser zum Fallstrick sein? Laß die Leute gehen, daß sie dem HERRN, ihrem Gott, dienen; merkst du noch nicht, daß Ägypten zugrunde geht? ");
INSERT INTO deu1951_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Da holte man Mose und Aaron wieder zum Pharao; der sprach zu ihnen: Geht hin, dienet dem HERRN, eurem Gott! Welche sind es aber, die hingehen werden? ");
INSERT INTO deu1951_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose sprach: Wir wollen mit unsern Jungen und Alten, mit unsern Söhnen und Töchtern, mit unsern Schafen und Rindern gehen; denn wir haben ein Fest des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Er sprach zu ihnen: Der HERR sei ebenso mit euch, wie ich euch samt euren Kindern ziehen lasse! Sehet da, ihr habt Böses im Sinn! ");
INSERT INTO deu1951_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nicht also, sondern ihr Erwachsenen geht hin und dienet dem HERRN; denn das habt ihr auch begehrt! Und man jagte sie weg vom Pharao. ");
INSERT INTO deu1951_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Da sprach der HERR zu Mose: Strecke deine Hand über Ägypten, damit die Heuschrecken über Ägypten kommen und alles Gewächs im Lande auffressen samt allem, was vom Hagel übriggeblieben ist! ");
INSERT INTO deu1951_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Da streckte Mose seinen Stab über Ägyptenland aus, und der HERR ließ einen Ostwind über das Land wehen den ganzen Tag und die ganze Nacht; und am Morgen führte der Ostwind die Heuschrecken her. ");
INSERT INTO deu1951_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Und die Heuschrecken kamen über ganz Ägyptenland und ließen sich nieder im ganzen Gebiet von Ägypten, so sehr viele, daß zuvor desgleichen niemals gewesen ist, noch künftig sein wird. ");
INSERT INTO deu1951_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Denn sie bedeckten das ganze Land und verfinsterten es. Und sie fraßen alle Bodengewächse und alle Baumfrüchte, die vom Hagel übriggeblieben waren, und ließen nichts Grünes übrig an den Bäumen und an den Feldgewächsen in ganz Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Da ließ der Pharao Mose und Aaron eilends rufen und sprach: Ich habe mich versündigt an dem HERRN, eurem Gott, und an euch. ");
INSERT INTO deu1951_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Und nun vergib mir meine Sünde nur noch diesmal und bittet den HERRN, euren Gott, daß er diesen Tod von mir abwende! ");
INSERT INTO deu1951_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Und er ging hinaus vom Pharao und bat den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Da wandte der HERR den Wind, daß er sehr stark aus dem Westen wehte und die Heuschrecken aufhob und sie ins Schilfmeer warf, so daß an allen Orten Ägyptens nicht eine übrig blieb. ");
INSERT INTO deu1951_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Aber der HERR verstockte das Herz des Pharao, daß er die Kinder Israel nicht ziehen ließ. ");
INSERT INTO deu1951_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Und der HERR sprach zu Mose: Strecke deine Hand gen Himmel, daß es im Ägyptenland so finster werde, daß man die Finsternis greifen kann! ");
INSERT INTO deu1951_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Da streckte Mose seine Hand gen Himmel. Und es ward eine dicke Finsternis in ganz Ägyptenland, drei Tage lang, ");
INSERT INTO deu1951_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","daß während drei Tagen niemand den andern sah, noch jemand von seinem Platz aufstand. Aber bei allen Kindern Israel war es hell in ihren Wohnungen. ");
INSERT INTO deu1951_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Da ließ der Pharao Mose rufen und sprach: Geht hin, dienet dem HERRN; nur eure Schafe und Rinder sollen hier bleiben; lasset auch eure Kinder mit euch ziehen! ");
INSERT INTO deu1951_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mose sprach: Du mußt auch Schlachtopfer und Brandopfer in unsere Hände geben, daß wir sie dem HERRN, unserm Gott, darbringen können; ");
INSERT INTO deu1951_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","aber auch unser eigenes Vieh soll mit uns gehen, und nicht eine Klaue darf dahinten bleiben; denn von demselben werden wir nehmen zum Dienste des HERRN, unseres Gottes. Auch wissen wir nicht, womit wir dem HERRN dienen sollen, bis wir dorthin kommen. ");
INSERT INTO deu1951_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Aber der HERR verstockte das Herz des Pharao, daß er sie nicht ziehen lassen wollte. ");
INSERT INTO deu1951_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Und Pharao sprach zu ihm: Gehe weg von mir und hüte dich, daß du nicht mehr vor mein Angesicht kommest; an welchem Tage du vor mein Angesicht kommst, sollst du sterben! ");
INSERT INTO deu1951_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose antwortete: Wie du gesagt hast; ich will nicht mehr vor dein Angesicht kommen! ");
INSERT INTO deu1951_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Und der HERR sprach zu Mose: Ich will noch eine Plage über den Pharao und über Ägypten bringen; darnach wird er euch fortziehen lassen; und wenn er euch ziehen läßt, so wird er euch sogar völlig wegtreiben. ");
INSERT INTO deu1951_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","So sage nun zum Volk, daß ein jeder von seinem Nächsten und eine jede von ihrer Nachbarin silberne und goldene Geschirre fordere. ");
INSERT INTO deu1951_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Und der HERR gab dem Volke Gunst in den Augen der Ägypter. So war auch Mose ein sehr großer Mann in Ägypten vor den Knechten des Pharao und vor dem Volk. ");
INSERT INTO deu1951_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Und Mose sprach: So spricht der HERR: Ich will zu Mitternacht ausgehen mitten durch Ägypten, ");
INSERT INTO deu1951_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","und alle Erstgeburt in Ägypten soll sterben; von dem Erstgeborenen des Pharao, der auf seinem Throne sitzt, bis an den Erstgeborenen der Magd, die hinter der Mühle ist; auch alle Erstgeburt unter dem Vieh. ");
INSERT INTO deu1951_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Und es wird ein großes Geschrei in ganz Ägypten sein, desgleichen niemals gewesen ist, noch sein wird. ");
INSERT INTO deu1951_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Aber bei allen Kindern Israel soll kein Hund die Zunge regen, weder gegen Menschen noch gegen das Vieh, auf daß ihr erfahret, was der HERR für einen Unterschied macht zwischen Ägypten und Israel. ");
INSERT INTO deu1951_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Dann werden alle diese deine Knechte zu mir herabkommen und mir zu Füßen fallen und sagen: Ziehe aus, du und alles Volk hinter dir her! Darnach werde ich ausziehen! Und er ging vom Pharao mit grimmigem Zorn. ");
INSERT INTO deu1951_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Der HERR aber hatte zu Mose gesagt: Der Pharao wird euch nicht hören, damit meiner Wunder in Ägypten viel geschehen. ");
INSERT INTO deu1951_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Also hatten Mose und Aaron alle diese Wunder vor dem Pharao getan; aber der HERR verstockte das Herz des Pharao, daß er die Kinder Israel nicht aus seinem Lande entließ. ");
INSERT INTO deu1951_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Und der HERR redete mit Mose und Aaron im Ägyptenland und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Dieser Monat soll euch der erste Monat sein, und von ihm sollt ihr die Monate des Jahres anheben. ");
INSERT INTO deu1951_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Saget der ganzen Gemeinde Israel und sprechet: Am zehnten Tage dieses Monats verschaffe sich jeder Hausvater ein Lamm, ein Lamm für jede Haushaltung; ");
INSERT INTO deu1951_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","wenn aber die Haushaltung zu klein ist für ein Lamm, so nehme er es gemeinsam mit seinem Nachbar, welcher zunächst bei seinem Hause wohnt; dabei sollen sie für das Lamm die Zahl der Seelen berechnen, je nachdem ein jeder zu essen vermag. ");
INSERT INTO deu1951_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Dieses Lamm aber soll vollkommen sein, ein Männlein und einjährig. Von den Lämmern und Ziegen sollt ihr es nehmen, ");
INSERT INTO deu1951_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","und sollt es behalten bis auf den vierzehnten Tag dieses Monats. Und die ganze Versammlung der Gemeinde Israel soll es zwischen den Abendstunden schächten. ");
INSERT INTO deu1951_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Und sie sollen von dem Blut nehmen und beide Türpfosten und die Oberschwellen der Häuser, darin sie essen, damit bestreichen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Und sollen also in derselben Nacht das Fleisch essen, am Feuer gebraten, mit ungesäuertem Brot; mit bitteren Kräutern sollen sie es essen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ihr sollt nichts davon roh essen, auch nicht im Wasser gesotten, sondern nur am Feuer gebraten, sein Haupt samt seinen Schenkeln und den innern Teilen; ");
INSERT INTO deu1951_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","und sollt nichts davon übriglassen bis zum andern Morgen. Wenn aber etwas übrigbleibt bis zum Morgen, sollt ihr es mit Feuer verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Also sollt ihr es aber essen: Um eure Lenden gegürtet, eure Schuhe an euren Füßen und eure Stäbe in euren Händen, und in Eile sollt ihr es essen; es ist des HERRN Passah. ");
INSERT INTO deu1951_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Denn ich will in derselben Nacht durch Ägypten gehen und alle Erstgeburt in Ägypten schlagen, vom Menschen an bis auf das Vieh, und will an allen Göttern der Ägypter Gerichte üben, ich, der HERR. ");
INSERT INTO deu1951_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Und das Blut soll euch zum Zeichen dienen an euren Häusern, darin ihr seid, daß, wenn ich das Blut sehe, ich an euch vorübergehe und euch die Plage nicht widerfahre, die euch verderbe, wenn ich die Ägypter schlagen werde. ");
INSERT INTO deu1951_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Und dieser Tag soll euch zum Gedächtnis sein, und ihr sollt ihn feiern als ein Fest des HERRN in allen euren Geschlechtern; als ewige Ordnung sollt ihr ihn feiern. ");
INSERT INTO deu1951_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sieben Tage lang sollt ihr ungesäuertes Brot essen, darum sollt ihr am ersten Tag den Sauerteig aus euren Häusern entfernen. Denn wer gesäuertes Brot ißt vom ersten Tage an bis auf den siebenten Tag, dessen Seele soll ausgerottet werden aus Israel! ");
INSERT INTO deu1951_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ihr sollt aber am ersten Tage eine heilige Versammlung halten, desgleichen am siebenten Tage eine heilige Versammlung. Keine Arbeit sollt ihr tun; außer was zur Speise nötig ist für alle Seelen, das allein darf von euch besorgt werden. ");
INSERT INTO deu1951_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Und beobachtet die Tage der ungesäuerten Brote! Denn eben an demselben Tage habe ich euer Heer aus Ägypten geführt; darum sollt ihr diesen Tag als ewige Ordnung beobachten in allen euren Geschlechtern. ");
INSERT INTO deu1951_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Am vierzehnten Tage des ersten Monats, am Abend, sollt ihr ungesäuertes Brot essen bis an den einundzwanzigsten Tag des Monats, am Abend, ");
INSERT INTO deu1951_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","daß man sieben Tage lang keinen Sauerteig in euren Häusern finde. Denn wer gesäuertes Brot ißt, dessen Seele soll ausgerottet werden aus der Gemeinde Israel, er sei ein Fremdling oder Einheimischer im Lande. ");
INSERT INTO deu1951_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","So esset kein gesäuertes, sondern ungesäuertes Brot in allen euren Wohnungen! ");
INSERT INTO deu1951_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Und Mose berief alle Ältesten in Israel und sprach zu ihnen: Machet euch auf und nehmet euch Lämmer für eure Familien und schächtet das Passah! ");
INSERT INTO deu1951_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Und nehmet einen Büschel Ysop und tauchet ihn in das Blut im Becken und bestreicht mit diesem Blut im Becken die Oberschwelle und die zwei Türpfosten; und kein Mensch von euch gehe zu seiner Haustüre hinaus bis an den Morgen! ");
INSERT INTO deu1951_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Denn der HERR wird umhergehen und die Ägypter schlagen. Und wenn er das Blut an der Oberschwelle und an den beiden Pfosten sehen wird, so wird er, der HERR, an der Tür vorübergehen und den Verderber nicht in eure Häuser kommen lassen, zu schlagen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Und ihr sollt diese Verordnung beobachten als eine Satzung, welche dir und deinen Kindern auf ewig gilt! ");
INSERT INTO deu1951_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Und wenn ihr in das Land kommt, das euch der HERR geben wird, wie er geredet hat, so haltet diesen Dienst. ");
INSERT INTO deu1951_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Und wenn eure Kinder zu euch sagen werden: Was habt ihr da für einen Dienst? ");
INSERT INTO deu1951_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","So sollt ihr sagen: Es ist das Passah-Opfer des HERRN, der an den Häusern der Kinder Israel vorüberschritt in Ägypten, als er die Ägypter schlug und unsere Häuser errettete. ");
INSERT INTO deu1951_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Da neigte sich das Volk und betete an. Und die Kinder Israel gingen hin und taten solches; wie der HERR Mose und Aaron geboten hatte, also taten sie. ");
INSERT INTO deu1951_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Und es begab sich zu Mitternacht, da schlug der HERR alle Erstgeburt in Ägypten, von dem ersten Sohne des Pharao, der auf dem Throne saß, bis auf den ersten Sohn der Gefangenen, die in dem Gefängnisse waren, auch alle Erstgeburt des Viehes. ");
INSERT INTO deu1951_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Da stand der Pharao auf in derselben Nacht, er und alle seine Knechte und alle Ägypter; und es war ein großes Geschrei in Ägypten, denn es gab kein Haus, darin nicht ein Toter war. ");
INSERT INTO deu1951_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Und er berief Mose und Aaron in der Nacht und sprach: Machet euch auf und ziehet aus von meinem Volke, ihr und die Kinder Israel, und gehet hin, dienet dem HERRN, wie ihr gesagt habt! ");
INSERT INTO deu1951_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Nehmet auch eure Schafe und eure Rinder mit euch, wie ihr gesagt habt, und gehet hin und segnet mich auch! ");
INSERT INTO deu1951_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Und die Ägypter drangen sehr in das Volk, daß sie dasselbe eilends aus dem Lande trieben; denn sie sprachen: Wir sind alle des Todes! ");
INSERT INTO deu1951_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Und das Volk trug seinen Teig, ehe er gesäuert war, nämlich ihre Backtröge in ihre Kleider gebunden, auf ihren Achseln. ");
INSERT INTO deu1951_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Und die Kinder Israel taten, wie Mose sagte, und forderten von den Ägyptern silberne und goldene Geschirre und Kleider. ");
INSERT INTO deu1951_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Dazu gab der HERR dem Volke bei den Ägyptern Gunst, daß sie ihrem Begehren willfahrten; und sie beraubten Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Also zogen die Kinder Israel aus von Raemses gen Sukkot, bei sechshunderttausend Mann Fußvolk, die Kinder nicht inbegriffen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Auch zogen mit ihnen viele Mischlinge und Schafe und Rinder und sehr viel Vieh. ");
INSERT INTO deu1951_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Und sie machten aus dem Teige, den sie aus Ägypten brachten, ungesäuerte Kuchen; denn er war nicht gesäuert, weil sie aus Ägypten vertrieben wurden und nicht verziehen konnten; und sie hatten sich sonst keine Zehrung zubereitet. ");
INSERT INTO deu1951_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Die Zeit aber, welche die Kinder Israel in Ägypten gewohnt haben, beträgt vierhundertunddreißig Jahre. ");
INSERT INTO deu1951_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Als nun die vierhundertunddreißig Jahre verflossen waren, an eben diesem Tag ging das ganze Heer des HERRN aus Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Darum wird diese Nacht dem HERRN gefeiert, weil er sie aus Ägypten geführt hat. Diese Nacht sollen alle Kinder Israel dem HERRN feiern, auch ihre künftigen Geschlechter. ");
INSERT INTO deu1951_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Und der HERR sprach zu Mose und Aaron: Dies ist die Ordnung des Passah: Kein Fremder soll davon essen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Wer aber ein um Geld erkaufter Knecht ist, den beschneide man; alsdann esse er davon. ");
INSERT INTO deu1951_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ein Beisasse und Taglöhner soll nicht davon essen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In einem Hause soll man es essen. Ihr sollt vom Fleisch nichts vor das Haus hinaustragen, und kein Knochen werde ihm zerbrochen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Die ganze Gemeinde Israel soll es feiern. ");
INSERT INTO deu1951_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Wo sich aber ein Fremdling bei dir aufhält und dem HERRN das Passah halten will, der beschneide alles, was männlich ist; und dann erst mache er sich herzu, daß er es feiere und sei wie ein Einheimischer des Landes; denn kein Unbeschnittener soll davon essen. ");
INSERT INTO deu1951_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Einerlei Gesetz soll dem Einheimischen und dem Fremdling gelten, der unter euch wohnt. ");
INSERT INTO deu1951_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Und alle Kinder Israel taten solches; wie der HERR dem Mose und Aaron geboten hatte, also taten sie; ");
INSERT INTO deu1951_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","aber der HERR führte an eben diesem Tag die Kinder Israel nach ihren Heerscharen aus Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Heilige mir alle Erstgeburt bei den Kindern Israel, von Menschen und Vieh; denn sie sind mein! ");
INSERT INTO deu1951_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Da sprach Mose zum Volk: Gedenket an diesen Tag, an dem ihr aus Ägypten, aus dem Diensthause, gegangen seid, daß der HERR euch mit mächtiger Hand von dannen ausgeführt hat: darum sollt ihr nichts Gesäuertes essen! ");
INSERT INTO deu1951_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Heute seid ihr ausgezogen, im Monat Abib. ");
INSERT INTO deu1951_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Wenn dich nun der HERR in das Land der Kanaaniter, Hetiter, Amoriter, Heviter und Jebusiter bringen wird, wie er deinen Vätern geschworen hat, dir ein Land zu geben, das von Milch und Honig fließt, so sollst du diesen Dienst in diesem Monat halten. ");
INSERT INTO deu1951_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sieben Tage lang sollst du ungesäuertes Brot essen, und am siebenten Tag ist das Fest des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Man soll diese sieben Tage lang ungesäuertes Brot essen, daß bei dir kein Sauerteig gesehen werde; in allen deinen Grenzen soll kein gesäuertes Brot gesehen werden. ");
INSERT INTO deu1951_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Und du sollst deinem Sohne an jenem Tage erklären und sagen: Es ist um deswillen, was der HERR an mir getan, als ich aus Ägypten zog. ");
INSERT INTO deu1951_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Und es soll dir zum Zeichen sein in deiner Hand und zum Denkmal vor deinen Augen, daß des HERRN Gesetz in deinem Munde sei, weil der HERR dich mit mächtiger Hand aus Ägypten geführt hat. ");
INSERT INTO deu1951_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Darum sollst du die Ordnung beobachten, zur bestimmten Zeit, Jahr für Jahr. ");
INSERT INTO deu1951_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Wenn dich nun der HERR in das Land der Kanaaniter gebracht, wie er dir und deinen Vätern geschworen, und es dir gegeben hat, ");
INSERT INTO deu1951_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","so sollst du dem HERRN alle Erstgeburt aussondern, auch jeden ersten Wurf vom Vieh, den du bekommst; alles, was männlich ist, soll dem HERRN gehören. ");
INSERT INTO deu1951_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Aber jede Erstgeburt vom Esel sollst du mit einem Schaf lösen; wenn du es aber nicht lösest, so brich ihm das Genick. Desgleichen alle Erstgeburt von Menschen unter deinen Kindern sollst du lösen. ");
INSERT INTO deu1951_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Und wenn dich künftig dein Sohn fragen wird: Was ist das? So sollst du ihm sagen: Der HERR hat uns mit mächtiger Hand aus Ägypten, aus dem Diensthause, geführt. ");
INSERT INTO deu1951_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Denn es begab sich, als der Pharao sich hart widersetzte, uns freizulassen, da erschlug der HERR alle Erstgeburt in Ägypten, von der Menschen Erstgeburt bis an die Erstgeburt des Viehes: darum opfere ich dem HERRN alle männliche Erstgeburt; alle Erstgeburt aber meiner Söhne löse ich. ");
INSERT INTO deu1951_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Und das soll dir zum Zeichen in deiner Hand und zum Denkmal vor deinen Augen sein, daß uns der HERR mit mächtiger Hand aus Ägypten geführt hat. ");
INSERT INTO deu1951_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Als nun der Pharao das Volk gehen ließ, führte sie Gott nicht auf die Straße durch der Philister Land, wiewohl sie die nächste war; denn Gott gedachte, es möchte das Volk gereuen, wenn es Krieg sähe, und möchte wieder nach Ägypten umkehren. ");
INSERT INTO deu1951_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Darum führte Gott das Volk den Umweg durch die Wüste am Schilfmeer. Und die Kinder Israel zogen gerüstet aus Ägypten. ");
INSERT INTO deu1951_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Und Mose nahm die Gebeine Josephs mit sich; denn er hatte einen Eid von den Kindern Israel genommen und gesagt: Gott wird euch gewiß heimsuchen; dann führet meine Gebeine mit euch von hinnen! ");
INSERT INTO deu1951_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Also zogen sie aus von Sukkot und lagerten sich in Etam, am Wüstenrand. ");
INSERT INTO deu1951_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Und der HERR zog vor ihnen her, am Tage in einer Wolkensäule, daß er sie den rechten Weg führete, und des Nachts in einer Feuersäule, daß er ihnen leuchtete, damit sie bei Tag und bei Nacht wandeln konnten. ");
INSERT INTO deu1951_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Die Wolkensäule wich nimmer vom Volk des Tages, noch die Feuersäule des Nachts. ");
INSERT INTO deu1951_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Sage den Kindern Israel, daß sie sich herumwenden und sich vor Pi-Hahiroth, zwischen Migdol und dem Meer, lagern; gerade gegenüber von Baal-Zephon lagert euch am Meer! ");
INSERT INTO deu1951_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Denn der Pharao wird von den Kindern Israel sagen: Sie sind im Lande verirrt, die Wüste hat sie eingeschlossen! ");
INSERT INTO deu1951_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Und ich will sein Herz verstocken, daß er ihnen nachjage, und will mich am Pharao und an seiner ganzen Macht verherrlichen; und die Ägypter sollen erfahren, daß ich der HERR bin! ");
INSERT INTO deu1951_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Als nun dem König von Ägypten angezeigt ward, daß das Volk fliehe, wandte sich sein und seiner Knechte Herz gegen das Volk; und sie sprachen: Warum haben wir das getan, daß wir Israel haben ziehen lassen, daß sie uns nicht mehr dienen? ");
INSERT INTO deu1951_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Und er spannte seinen Wagen an und nahm sein Volk mit sich. ");
INSERT INTO deu1951_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Er nahm auch sechshundert auserlesene Wagen und alle Wagen in Ägypten und Wagenkämpfer auf jedem. ");
INSERT INTO deu1951_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Denn der HERR verstockte das Herz des Pharao, des Königs von Ägypten, daß er denn Kindern Israel nachjagte, obwohl sie durch eine hohe Hand auszogen. ");
INSERT INTO deu1951_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Also jagten ihnen die Ägypter nach mit allen Rossen, Wagen und Reitern des Pharao und mit seiner Macht und ereilten sie, als sie sich am Meere, bei Pi-Hahiroth, Baal-Zephon gegenüber, gelagert hatten. ");
INSERT INTO deu1951_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Und als der Pharao nahe zu ihnen kam, erhoben die Kinder Israel ihre Augen und siehe, die Ägypter zogen hinter ihnen her; und sie fürchteten sich sehr. Da schrieen die Kinder Israel zum HERRN ");
INSERT INTO deu1951_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","und sprachen zu Mose: Sind etwa keine Gräber in Ägypten, daß du uns genommen hast, damit wir in der Wüste sterben? Warum hast du uns das angetan, daß du uns aus Ägypten geführt hast? ");
INSERT INTO deu1951_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Haben wir dir nicht in Ägypten schon gesagt: Laß ab von uns, daß wir den Ägyptern dienen? Denn es wäre uns ja besser, den Ägyptern zu dienen, als in der Wüste zu sterben! ");
INSERT INTO deu1951_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mose sprach zum Volk: Fürchtet euch nicht, tretet hin und sehet, was für ein Heil der HERR heute an euch tun wird; denn diese Ägypter, die ihr heute sehet, sollt ihr nimmermehr sehen ewiglich! ");
INSERT INTO deu1951_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Der HERR wird für euch streiten, und ihr sollt stille sein! ");
INSERT INTO deu1951_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Der HERR sprach zu Mose: Was schreist du zu mir? Sage den Kindern Israel, daß sie ziehen! ");
INSERT INTO deu1951_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Du aber hebe deinen Stab auf und strecke deine Hand über das Meer und zerteile es, daß die Kinder Israel mitten durch das Meer auf dem Trockenen gehen. ");
INSERT INTO deu1951_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ich aber, siehe, ich will das Herz der Ägypter verstocken, daß sie ihnen nachlaufen; dann will ich mich verherrlichen am Pharao und an seiner ganzen Macht, an seinen Wagen und an seinen Reitern. ");
INSERT INTO deu1951_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Und die Ägypter sollen erfahren, daß ich der HERR bin, wenn ich mich am Pharao, an seinen Wagen und an seinen Reitern verherrliche. ");
INSERT INTO deu1951_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Da erhob sich der Engel Gottes, der vor dem Heer Israels herzog, und trat hinter sie; und die Wolkensäule machte sich auch auf von ihrem Angesicht weg und trat hinter sie ");
INSERT INTO deu1951_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","und kam zwischen das Heer der Ägypter und das Heer Israels; und sie war für die einen Wolke und Finsternis, und für die andern erleuchtete sie die Nacht, so daß diese und jene die ganze Nacht nicht zusammenkamen. ");
INSERT INTO deu1951_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Als nun Mose seine Hand über das Meer streckte, ließ der HERR dasselbe die ganze Nacht durch einen starken Ostwind ablaufen und machte das Meer trocken, und die Wasser teilten sich voneinander. ");
INSERT INTO deu1951_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Und die Kinder Israel gingen hinein mitten in das Meer auf dem Trockenen, und das Wasser war ihnen wie Mauern zu ihrer Rechten und zu ihrer Linken. ");
INSERT INTO deu1951_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Und die Ägypter jagten nach und gingen hinein ihnen nach, alle Rosse des Pharao, seine Wagen und seine Reiter, mitten ins Meer. ");
INSERT INTO deu1951_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Als nun die Morgenwache kam, schaute der HERR aus der Feuersäule und Wolke auf der Ägypter Heer und verwirrte das Heer der Ägypter ");
INSERT INTO deu1951_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","und stieß die Räder von ihren Wagen und brachte sie ins Gedränge. Da sprachen die Ägypter: Lasset uns vor Israel fliehen, denn der HERR streitet für sie wider die Ägypter! ");
INSERT INTO deu1951_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Da sprach der HERR zu Mose: Strecke deine Hand aus über das Meer, damit das Wasser wieder zurückkehre über die Ägypter, über ihre Wagen und über ihre Reiter! ");
INSERT INTO deu1951_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Da streckte Mose seine Hand aus über das Meer, und das Meer kam beim Anbruch des Morgens wieder in seine Strömung, und die Ägypter flohen ihm entgegen. Also stürzte der HERR die Ägypter ins Meer. ");
INSERT INTO deu1951_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Denn das Wasser kam wieder und bedeckte die Wagen und Reiter der ganzen Macht des Pharao, die ihnen ins Meer nachgefolgt waren, daß nicht einer aus ihnen übrigblieb. ");
INSERT INTO deu1951_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Aber die Kinder Israel gingen trocken mitten durchs Meer, und das Wasser diente ihnen als Mauern zu ihrer Rechten und zu ihrer Linken. ");
INSERT INTO deu1951_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Also half der HERR Israel an jenem Tage von der Ägypter Hand. Und Israel sah die Ägypter tot am Gestade des Meeres. ");
INSERT INTO deu1951_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Als nun Israel die große Hand sah, die der HERR an den Ägyptern bewiesen hatte, fürchtete das Volk den HERRN, und sie glaubten dem HERRN und seinem Knecht Mose. ");
INSERT INTO deu1951_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Damals sangen Mose und die Kinder Israel dem HERRN diesen Lobgesang und sprachen: Ich will dem HERRN singen, denn er hat sich herrlich erwiesen: Roß und Reiter hat er ins Meer gestürzt! ");
INSERT INTO deu1951_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Der HERR ist meine Kraft und mein Psalm, und er ward mir zum Heil! Das ist mein starker Gott, ich will ihn preisen; er ist meines Vaters Gott, ich will ihn erheben. ");
INSERT INTO deu1951_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Der HERR ist ein Kriegsmann, HERR ist sein Name. ");
INSERT INTO deu1951_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Die Wagen des Pharao und seine Macht warf er ins Meer. Seine auserlesenen Wagenkämpfer sind im Schilfmeer versunken. ");
INSERT INTO deu1951_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Die Tiefe hat sie bedeckt, sie fielen zu Grunde wie Steine. ");
INSERT INTO deu1951_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","HERR, deine Rechte Hand ist mit Kraft geschmückt; HERR, deine Rechte Hand hat den Feind erschlagen. ");
INSERT INTO deu1951_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Und mit deiner großen Macht hast du deine Widersacher vertilgt; du ließest deinen Grimm ausgehen, der verzehrte sie wie Stoppeln. ");
INSERT INTO deu1951_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Durch den Hauch deines Zornes türmte das Wasser sich auf; es standen die Wogen wie ein Damm. Die Fluten erstarrten mitten im Meer. ");
INSERT INTO deu1951_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Der Feind sprach: Ich will sie jagen, ich will sie ergreifen, ich will den Raub verteilen, will meinen Mut an ihnen kühlen, ich will mein Schwert ausziehen, meine Hand soll sie vertilgen! ");
INSERT INTO deu1951_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Als du aber mit deinem Winde wehtest, da bedeckte sie das Meer, sie versanken wie Blei im mächtigen Wasser. ");
INSERT INTO deu1951_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","HERR, wer ist dir gleich unter den Göttern, wer ist in der Heiligkeit so herrlich, mit Lobgesängen so hoch zu verehren und so wundertätig wie du? ");
INSERT INTO deu1951_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Als du deine rechte Hand ausstrecktest, verschlang sie die Erde. ");
INSERT INTO deu1951_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Du leitest in deiner Gnade das Volk, das du erlöst hast, und bringst sie durch deine Kraft zur Wohnung deines Heiligtums. ");
INSERT INTO deu1951_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Wenn das die Völker hören, so erzittern sie, Angst kommt die Philister an; ");
INSERT INTO deu1951_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","es erschrecken die Fürsten Edoms, Zittern befällt die Gewaltigen Moabs; alle Einwohner Kanaans werden verzagt. ");
INSERT INTO deu1951_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Laß durch deinen großen Arm Schrecken und Furcht über sie fallen, daß sie erstarren wie Steine, bis dein Volk, HERR, hindurchziehe, bis dein Volk hindurchziehe, das du erworben hast! ");
INSERT INTO deu1951_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Bring sie hinein und pflanze sie auf den Berg deines Erbteils, an den Ort, den du, HERR, zu deiner Wohnung gemacht hast, zu dem Heiligtum, o HERR, welches deine Hände bereitet haben! ");
INSERT INTO deu1951_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Der HERR wird herrschen immer und ewig! ");
INSERT INTO deu1951_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Denn der Pharao ging ins Meer hinein mit Rossen, mit seinen Wagen und Reitern, und der HERR ließ das Meer wieder über sie kommen; aber die Kinder Israel gingen trocken mitten durchs Meer. ");
INSERT INTO deu1951_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Und Mirjam, die Prophetin, Aarons Schwester, nahm die Handpauke in ihre Hand, und alle Weiber folgten ihr nach mit Handpauken und im Reigen. ");
INSERT INTO deu1951_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Und Mirjam antwortete ihnen: Lasset uns dem HERRN singen, denn er hat sich herrlich erwiesen: Roß und Reiter hat er ins Meer gestürzt! ");
INSERT INTO deu1951_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Darnach ließ Mose die Israeliten vom Schilfmeer aufbrechen, daß sie zur Wüste Sur zogen; und sie wanderten drei Tage lang in der Wüste und fanden kein Wasser. ");
INSERT INTO deu1951_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Da kamen sie nach Mara; aber sie konnten das Wasser von Mara nicht trinken, denn es war sehr bitter. Daher hieß man es Mara. ");
INSERT INTO deu1951_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Da murrte das Volk wider Mose und sprach: Was sollen wir trinken? ");
INSERT INTO deu1951_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Er aber schrie zum HERRN, und der HERR zeigte ihm ein Holz, das warf er ins Wasser, da ward das Wasser süß. Daselbst legte er ihnen Pflicht und Recht vor, und daselbst versuchte er sie und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Wirst du der Stimme des HERRN, deines Gottes, gehorchen und tun, was vor ihm recht ist, und seine Gebote zu Ohren fassen und alle seine Satzungen halten, so will ich der Krankheiten keine auf dich legen, die ich auf Ägypten gelegt habe; denn ich, der HERR, bin dein Arzt! ");
INSERT INTO deu1951_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Und sie kamen nach Elim, da waren zwölf Wasserbrunnen und siebzig Palmbäume, und sie lagerten sich daselbst am Wasser. ");
INSERT INTO deu1951_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Darnach zog die ganze Gemeinde der Kinder Israel von Elim weg in die Wüste Sin, die zwischen Elim und Sinai liegt, am fünfzehnten Tag des zweiten Monats, nachdem sie aus Ägypten gezogen waren. ");
INSERT INTO deu1951_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Und die ganze Gemeinde der Kinder Israel murrte wider Mose und Aaron in der Wüste. ");
INSERT INTO deu1951_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Und die Kinder Israel sprachen zu ihnen: Wären wir doch durch des HERRN Hand in Ägypten gestorben, als wir bei den Fleischtöpfen saßen und Brot die Fülle zu essen hatten. Denn ihr habt uns darum in diese Wüste ausgeführt, daß ihr diese ganze Gemeinde Hungers sterben lasset! ");
INSERT INTO deu1951_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Da sprach der HERR zu Mose: Siehe, ich will euch Brot vom Himmel regnen lassen; dann soll das Volk hinausgehen und täglich sammeln, was es bedarf, damit ich erfahre, ob es in meinem Gesetze wandeln wird oder nicht. ");
INSERT INTO deu1951_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Am sechsten Tage aber sollen sie zubereiten, was sie eingebracht haben, und zwar doppelt so viel als sie täglich sammeln. ");
INSERT INTO deu1951_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Da sprachen Mose und Aaron zu allen Kindern Israel: Am Abend sollt ihr erfahren, daß euch der HERR aus Ägypten geführt hat, ");
INSERT INTO deu1951_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","und am Morgen werdet ihr des HERRN Herrlichkeit sehen, denn er hat euer Murren wider den HERRN gehört. Aber was sind wir, daß ihr wider uns murret? ");
INSERT INTO deu1951_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Weiter sprach Mose: Der HERR wird euch am Abend Fleisch zu essen geben und am Morgen Brot die Fülle; denn er, der HERR, hat euer Murren gehört, womit ihr wider ihn gemurrt habt. Denn was sind wir? Euer Murren ist nicht wider uns, sondern wider den HERRN! ");
INSERT INTO deu1951_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Und Mose sprach zu Aaron: Sage der ganzen Gemeinde der Kinder Israel: Kommt herzu vor den HERRN, denn er hat euer Murren gehört! ");
INSERT INTO deu1951_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Und als Aaron zu der ganzen Gemeinde der Kinder Israel redete, wandten sie sich gegen die Wüste und siehe, die Herrlichkeit des HERRN erschien in einer Wolke. ");
INSERT INTO deu1951_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Und der HERR sprach zu Mose: ");
INSERT INTO deu1951_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ich habe das Murren der Kinder Israel gehört. Sage ihnen: Um den Abend sollt ihr Fleisch zu essen haben und am Morgen mit Brot gesättigt werden; also sollt ihr erfahren, daß ich der HERR, euer Gott bin! ");
INSERT INTO deu1951_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Als es nun Abend war, kamen Wachteln herauf und bedeckten das Lager, und am Morgen lag der Tau um das Lager her. ");
INSERT INTO deu1951_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Und als der Tau, der da lag, verschwunden war, siehe, da lag etwas in der Wüste, rund und klein, so fein wie der Reif auf der Erde. ");
INSERT INTO deu1951_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Und als es die Kinder Israel sahen, sprachen sie untereinander: Was ist das? denn sie wußten nicht, was es war. Mose aber sprach zu ihnen: Es ist das Brot, das euch der HERR zu essen gegeben hat! ");
INSERT INTO deu1951_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Das ist aber der Befehl, welchen der HERR gegeben hat: Ein jeder sammle davon, soviel er essen mag, einen Gomer für den Kopf, nach der Zahl eurer Seelen; ein jeder nehme für die, die in seiner Hütte sind. ");
INSERT INTO deu1951_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Und die Kinder Israel taten also und sammelten, einer viel, der andere wenig. ");
INSERT INTO deu1951_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Aber als man es mit dem Gomer maß, hatte der, welcher viel gesammelt hatte, keinen Überfluß, und dem, der wenig gesammelt hatte, mangelte nichts, sondern ein jeder hatte für sich gesammelt, soviel er essen mochte. ");
INSERT INTO deu1951_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Und Mose sprach zu ihnen: Niemand lasse etwas davon übrigbleiben bis zum andern Morgen! ");
INSERT INTO deu1951_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Aber sie gehorchten Mose nicht; denn etliche ließen davon übrigbleiben bis zum Morgen. Da wuchsen Würmer darin, und es ward stinkend. Und Mose ward zornig über sie. ");
INSERT INTO deu1951_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Sie sammelten aber von demselben alle Morgen für sich, soviel ein jeder essen mochte; wenn aber die Sonne heiß schien, zerschmolz es. ");
INSERT INTO deu1951_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Und am sechsten Tage sammelten sie doppelt so viel Brot, zwei Gomer für jede Person. Da kamen alle Obersten der Gemeinde und verkündigten es Mose. ");
INSERT INTO deu1951_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Und er sprach zu ihnen: Das ist's, was der HERR gesagt hat: Morgen ist der Sabbat der heiligen Ruhe des HERRN; was ihr backen wollt, das backet, und was ihr kochen wollt, das kochet; was aber übrig ist, das hebet auf, damit es bis morgen erhalten bleibe! ");
INSERT INTO deu1951_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Und sie ließen es bis an den Morgen bleiben, wie Mose geboten hatte; da ward es nicht stinkend und war auch kein Wurm darin. ");
INSERT INTO deu1951_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Da sprach Mose: Esset das heute, denn heute ist der Sabbat des HERRN; ihr werdet es heute nicht auf dem Felde finden. ");
INSERT INTO deu1951_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sechs Tage sollt ihr es sammeln, aber am siebenten Tag ist der Sabbat, da wird keines zu finden sein. ");
INSERT INTO deu1951_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Es begab sich aber am siebenten Tage, daß etliche vom Volke hinausgingen zu sammeln und nichts fanden. ");
INSERT INTO deu1951_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Da sprach der HERR zu Mose: Wie lange weigert ihr euch, meine Gebote und meine Satzungen zu halten? ");
INSERT INTO deu1951_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Sehet, der HERR hat euch den Sabbat gegeben; darum gibt er euch am sechsten Tage für zwei Tage Brot; so bleibe nun jeder an seinem Platz und niemand gehe am siebenten Tage heraus von seinem Ort! ");
INSERT INTO deu1951_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Also feierte das Volk am siebenten Tag. ");
INSERT INTO deu1951_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Und das Haus Israel nannte es Manna. Es war aber wie Koriandersamen, weiß, und hatte einen Geschmack wie Honigkuchen. ");
INSERT INTO deu1951_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Und Mose sprach: Das ist's, was der HERR geboten hat: Fülle einen Gomer davon und behalte ihn auf für eure Nachkommen, daß man das Brot sehe, womit ich euch in der Wüste gespeist habe, als ich euch aus Ägypten führte! ");
INSERT INTO deu1951_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Und Mose sprach zu Aaron: Nimm ein Gefäß und tue einen Gomer voll Manna hinein und stelle es vor den HERRN, zur Aufbewahrung für eure Nachkommen! ");
INSERT INTO deu1951_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Wie der HERR dem Mose geboten hatte, also stellte es Aaron daselbst vor das Zeugnis, zur Aufbewahrung. ");
INSERT INTO deu1951_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Und die Kinder Israel aßen das Manna vierzig Jahre lang, bis sie zu dem Lande kamen, darin sie wohnen sollten; bis sie an die Grenze Kanaans kamen, aßen sie das Manna. ");
INSERT INTO deu1951_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ein Gomer ist der zehnte Teil eines Epha. ");
INSERT INTO deu1951_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Und die ganze Gemeinde der Kinder Israel zog aus der Wüste Sin ihre Tagereisen, nach dem Befehl des HERRN, und lagerte sich in Raphidim; da hatte das Volk kein Wasser zu trinken. ");
INSERT INTO deu1951_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Darum zankten sie mit Mose und sprachen: Gebt uns Wasser, daß wir trinken! Mose sprach zu ihnen: Was zankt ihr mit mir? Warum versucht ihr den HERRN? ");
INSERT INTO deu1951_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Als nun das Volk daselbst nach Wasser dürstete, murrten sie wider Mose und sprachen: Warum hast du uns aus Ägypten heraufgeführt, daß du uns und unsere Kinder und unser Vieh vor Durst sterben lässest? ");
INSERT INTO deu1951_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mose schrie zum HERRN und sprach: Was soll ich mit diesem Volke tun? Es fehlt wenig, sie werden mich noch steinigen! ");
INSERT INTO deu1951_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Der HERR sprach zu Mose: Gehe hin vor das Volk und nimm etliche Älteste von Israel mit dir und nimm den Stab, mit dem du den Fluß schlugest, in deine Hand und gehe hin. ");
INSERT INTO deu1951_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Siehe, ich will daselbst vor dir auf einem Felsen in Horeb stehen; da sollst du den Felsen schlagen, so wird Wasser herauslaufen, daß das Volk trinke. Mose tat also vor den Ältesten Israels. ");
INSERT INTO deu1951_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Da hieß man den Ort Massa und Meriba, wegen des Zanks der Kinder Israel, und daß sie den HERRN versucht und gesagt hatten: Ist der HERR mitten unter uns oder nicht? ");
INSERT INTO deu1951_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Da kam Amalek und stritt wider Israel in Raphidim. ");
INSERT INTO deu1951_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Und Mose sprach zu Josua: Erwähle uns Männer und ziehe aus, streite wider Amalek! Morgen will ich auf des Hügels Spitze stehen und den Stab Gottes in meiner Hand haben. ");
INSERT INTO deu1951_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Und Josua tat, wie Mose ihm sagte, daß er wider Amalek stritt. Mose aber und Aaron und Hur stiegen auf die Spitze des Hügels. ");
INSERT INTO deu1951_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Und solange Mose seine Hände aufhob, siegte Israel; wenn er aber seine Hände sinken ließ, siegte Amalek. ");
INSERT INTO deu1951_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Aber die Hände Moses wurden schwer, darum nahmen sie einen Stein und legten denselben unter ihn, daß er sich darauf setzte. Aaron aber und Hur unterstützten seine Hände, auf jeder Seite einer. Also blieben seine Hände fest, bis die Sonne unterging. ");
INSERT INTO deu1951_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Und Josua besiegte den Amalek und sein Volk durch die Schärfe des Schwertes. ");
INSERT INTO deu1951_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Da sprach der HERR zu Mose: Schreibe das zum Gedächtnis in ein Buch und lege es Josua in die Ohren, nämlich: ich will das Gedächtnis Amaleks unter dem Himmel ganz austilgen. ");
INSERT INTO deu1951_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Und Mose baute dem HERRN einen Altar und hieß ihn: Der HERR ist mein Panier. ");
INSERT INTO deu1951_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Und er sprach: Weil eine Hand auf dem Throne des HERRN erhoben ist, soll der Krieg des HERRN wider Amalek währen, von Geschlecht zu Geschlecht. ");
INSERT INTO deu1951_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Und als Jethro, der Priester in Midian, Moses Schwiegervater, alles hörte, was Gott Mose und seinem Volk Israel getan, wie der HERR Israel aus Ägypten geführt hatte, ");
INSERT INTO deu1951_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","nahm Jethro, Moses Schwiegervater, die Zippora, das Weib Moses, die er zurückgesandt hatte, ");
INSERT INTO deu1951_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","und ihre zwei Söhne (der eine hieß Gersom; denn er sprach: Ich bin ein Fremdling in einem fremden Lande geworden; ");
INSERT INTO deu1951_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","und der andere Elieser; denn der Gott meines Vaters ist meine Hilfe gewesen und hat mich von dem Schwert des Pharao errettet) ");
INSERT INTO deu1951_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","und Jethro, Moses Schwiegervater, und seine Söhne und sein Weib kamen zu Mose in die Wüste, als er sich an dem Berge Gottes gelagert hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Und er ließ Mose sagen: Ich, Jethro, dein Schwiegervater, bin zu dir gekommen und dein Weib und ihre beiden Söhne mit ihr. ");
INSERT INTO deu1951_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Da ging Mose hinaus, seinem Schwiegervater entgegen, und bückte sich vor ihm und küßte ihn. Und als sie einander gegrüßt hatten, gingen sie in die Hütte. ");
INSERT INTO deu1951_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Da erzählte Mose seinem Schwiegervater alles, was der HERR dem Pharao und den Ägyptern um Israels willen getan hatte, und alle Mühsal, die ihnen auf dem Wege begegnet war, und wie der HERR sie errettet hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro aber freute sich über alles Gute, das der HERR an Israel getan, und daß er sie von der Ägypter Hand errettet hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Und Jethro sprach: Gelobt sei der HERR, der euch von der Hand der Ägypter und von der Hand des Pharao errettet hat, ja, der sein Volk von der Hand der Ägypter errettet hat! ");
INSERT INTO deu1951_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nun weiß ich, daß der HERR größer ist als alle Götter; denn eben mit dem, womit sie Hochmut getrieben, ist er über sie gekommen! ");
INSERT INTO deu1951_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Und Jethro, Moses Schwiegervater, nahm Brandopfer und Schlachtopfer, Gott zu opfern. Da kamen Aaron und alle Ältesten von Israel, um mit Moses Schwiegervater vor Gott das Brot zu essen. ");
INSERT INTO deu1951_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Am andern Morgen setzte sich Mose, das Volk zu richten; und das Volk stand um Mose her bis an den Abend. ");
INSERT INTO deu1951_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Als aber Moses Schwiegervater alles sah, was er mit dem Volke tat, sprach er: Was machst du dir da für Umstände mit dem Volk? Warum sitzest du allein, und alles Volk steht um dich her vom Morgen bis zum Abend? ");
INSERT INTO deu1951_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose antwortete seinem Schwiegervater: Das Volk kommt zu mir, Gott um Rat zu fragen. ");
INSERT INTO deu1951_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Denn wenn sie eine Sache haben, kommen sie zu mir, daß ich entscheide, wer von beiden recht hat, und damit ich ihnen Gottes Ordnung und seine Gesetze kundtue. ");
INSERT INTO deu1951_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Aber Moses Schwiegervater sprach zu ihm: Es ist nicht gut, was du tust! ");
INSERT INTO deu1951_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Du wirst müde und kraftlos, zugleich du und das Volk, das bei dir ist; denn das Geschäft ist dir zu schwer, du kannst es allein nicht ausrichten. ");
INSERT INTO deu1951_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","So höre auf meine Stimme; ich will dir raten, und Gott wird mit dir sein. Tritt du für das Volk vor Gott ");
INSERT INTO deu1951_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","und erkläre ihnen die Ordnungen und Gesetze, daß du ihnen den Weg kundtuest, darauf sie zu wandeln haben, und die Werke, die sie tun sollen. ");
INSERT INTO deu1951_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Sieh dich aber unter allem Volk nach wackern Männern um, die gottesfürchtig, wahrhaftig und dem Geize feind sind; die setze über sie zu Obern über tausend, über hundert, über fünfzig und über zehn, ");
INSERT INTO deu1951_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","daß sie das Volk allezeit richten; alle wichtigen Sachen aber sollen sie vor dich bringen, und alle geringen Sachen sollen sie selbst richten; so wird es dir leichter werden, wenn sie die Bürde mit dir tragen. ");
INSERT INTO deu1951_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Wirst du das tun, und gebietet es dir Gott, so magst du bestehen; und dann kann auch all dieses Volk in Frieden an seinen Ort kommen. ");
INSERT INTO deu1951_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose folgte der Stimme seines Schwiegervaters und tat alles, was er sagte. ");
INSERT INTO deu1951_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Denn er erwählte wackere Männer aus ganz Israel und machte sie zu Häuptern über das Volk, zu Obern über tausend, über hundert, über fünfzig und über zehn, ");
INSERT INTO deu1951_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","damit sie das Volk allezeit richteten; schwere Sachen sollten sie vor Mose bringen, die kleinen Sachen aber selber richten. ");
INSERT INTO deu1951_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Darauf ließ Mose seinen Schwiegervater ziehen, und er kehrte in sein Land zurück. ");
INSERT INTO deu1951_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Im dritten Monat nach dem Auszug der Kinder Israel aus Ägypten kamen sie an demselben Tag in die Wüste Sinai. ");
INSERT INTO deu1951_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Denn sie waren von Raphidim ausgezogen und in die Wüste Sinai gekommen und lagerten sich in der Wüste; Israel lagerte sich daselbst dem Berg gegenüber. ");
INSERT INTO deu1951_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Und Mose stieg hinauf zu Gott; denn der HERR rief ihm vom Berge und sprach: Also sollst du zum Hause Jakobs sagen und den Kindern Israel verkündigen: ");
INSERT INTO deu1951_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ihr habt gesehen, was ich den Ägyptern getan, und wie ich euch auf Adlersflügeln getragen und euch zu mir gebracht habe. ");
INSERT INTO deu1951_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Werdet ihr nun meiner Stimme Gehör schenken und gehorchen und meinen Bund bewahren, so sollt ihr vor allen Völkern mein besonderes Eigentum sein; denn die ganze Erde ist mein; ");
INSERT INTO deu1951_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ihr aber sollt mir ein Königreich von Priestern und ein heiliges Volk sein! Das sind die Worte, die du den Kindern Israel sagen sollst. ");
INSERT INTO deu1951_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mose kam und berief die Ältesten des Volkes und legte ihnen alle diese Worte vor, die der HERR geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Da antwortete das ganze Volk miteinander und sprach: Alles, was der HERR gesagt hat, das wollen wir tun! Und Mose überbrachte dem HERRN die Antwort des Volkes. ");
INSERT INTO deu1951_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Da sprach der HERR zu Mose: Siehe, ich will in einer dicken Wolke zu dir kommen, daß das Volk meine Worte höre, die ich mit dir rede, und auch dir ewiglich glaube. Und Mose verkündigte dem HERRN die Rede des Volkes. ");
INSERT INTO deu1951_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Da sprach der HERR zu Mose: Geh zum Volk und heilige sie heute und morgen; und sie sollen ihre Kleider waschen ");
INSERT INTO deu1951_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","und bereit sein auf den dritten Tag; denn am dritten Tage wird der HERR vor dem ganzen Volk auf den Berg Sinai herabsteigen. ");
INSERT INTO deu1951_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Und mache dem Volke ein Gehege ringsum und sprich zu ihnen: Hütet euch davor, auf den Berg zu steigen und seinen Fuß anzurühren! Denn wer den Berg anrührt, der soll des Todes sterben! ");
INSERT INTO deu1951_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Niemandes Hand soll ihn anrühren, sonst soll er gesteinigt oder mit einem Geschoß erschossen werden; es sei ein Tier oder ein Mensch, so soll er nicht leben. Wenn aber das Horn ertönt, so sollen sie zum Berge kommen. ");
INSERT INTO deu1951_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mose stieg vom Berg herab zum Volk und heiligte sie. Und sie wuschen ihre Kleider. ");
INSERT INTO deu1951_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Und er sprach zum Volk: Seid bereit auf den dritten Tag, keiner nahe sich zum Weibe! ");
INSERT INTO deu1951_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Als nun der dritte Tag kam und es noch frühe war, erhob sich ein Donnern und Blitzen und eine dicke Wolke auf dem Berg und der Ton einer sehr starken Posaune. Da erschrak das ganze Volk, das im Lager war. ");
INSERT INTO deu1951_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Und Mose führte das Volk aus dem Lager, Gott entgegen, und sie stellten sich unten am Berge auf. ");
INSERT INTO deu1951_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Aber der ganze Berg Sinai rauchte davon, daß der HERR im Feuer auf ihn herabstieg. Und sein Rauch ging auf, wie der Rauch eines Schmelzofens, und der ganze Berg erbebte sehr. ");
INSERT INTO deu1951_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Und der Ton der Posaune ward je länger je stärker. Mose redete, und Gott antwortete ihm mit lauter Stimme. ");
INSERT INTO deu1951_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Als nun der HERR auf den Berg Sinai, oben auf die Spitze des Berges herabgekommen war, rief er Mose hinauf auf die Spitze des Berges. Und Mose stieg hinauf. ");
INSERT INTO deu1951_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Da sprach der HERR zu Mose: Steig hinab und bezeuge dem Volk, daß sie nicht zum HERRN durchbrechen, um zu sehen, und viele von ihnen fallen! ");
INSERT INTO deu1951_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Auch die Priester, die dem HERRN nahen, sollen sich heiligen, daß der HERR nicht einen Riß unter ihnen mache. ");
INSERT INTO deu1951_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose aber sprach zum HERRN: Das Volk kann nicht auf den Berg Sinai steigen, denn du hast uns bezeugt und gesagt: Mache ein Gehege um den Berg und heilige ihn! ");
INSERT INTO deu1951_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Der HERR sprach zu ihm: Gehe hin, steige hinab! Darnach sollst du und Aaron mit dir hinaufsteigen; aber die Priester und das Volk sollen nicht durchbrechen, um zum Herrn heraufzusteigen, damit er nicht einen Riß unter ihnen mache! ");
INSERT INTO deu1951_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Und Mose stieg zum Volke hinunter und sagte es ihnen. ");
INSERT INTO deu1951_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Da redete Gott alle diese Worte und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ich bin der HERR, dein Gott, der ich dich aus Ägyptenland, aus dem Diensthause, geführt habe. ");
INSERT INTO deu1951_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Du sollst keine andern Götter neben mir haben! ");
INSERT INTO deu1951_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Du sollst dir kein Bildnis noch irgend ein Gleichnis machen, weder dessen, das oben im Himmel, noch dessen, das unten auf Erden, noch dessen, das in den Wassern, unterhalb der Erde ist. ");
INSERT INTO deu1951_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Bete sie nicht an und diene ihnen nicht; denn ich, der HERR, dein Gott, bin ein eifriger Gott, der da heimsucht der Väter Missetat an den Kindern bis in das dritte und vierte Glied derer, die mich hassen, ");
INSERT INTO deu1951_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","und tue Barmherzigkeit an vielen Tausenden, die mich lieben und meine Gebote halten. ");
INSERT INTO deu1951_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Du sollst den Namen des HERRN, deines Gottes, nicht mißbrauchen; denn der HERR wird den nicht ungestraft lassen, der seinen Namen mißbraucht! ");
INSERT INTO deu1951_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Gedenke des Sabbattages, daß du ihn heiligest! ");
INSERT INTO deu1951_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sechs Tage sollst du arbeiten und alle deine Werke verrichten; ");
INSERT INTO deu1951_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","aber am siebenten Tag ist der Sabbat des HERRN, deines Gottes; da sollst du kein Werk tun; weder du, noch dein Sohn, noch deine Tochter, noch dein Knecht, noch deine Magd, noch dein Vieh, noch dein Fremdling, der in deinen Toren ist. ");
INSERT INTO deu1951_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Denn in sechs Tagen hat der HERR Himmel und Erde gemacht, und das Meer und alles, was darinnen ist, und ruhte am siebenten Tag; darum segnete der HERR den Sabbattag und heiligte ihn. ");
INSERT INTO deu1951_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Du sollst deinen Vater und deine Mutter ehren, auf daß du lange lebest im Lande, das dir der HERR, dein Gott, geben wird! ");
INSERT INTO deu1951_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Du sollst nicht töten! ");
INSERT INTO deu1951_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Du sollst nicht ehebrechen! ");
INSERT INTO deu1951_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Du sollst nicht stehlen! ");
INSERT INTO deu1951_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Du sollst kein falsches Zeugnis reden wider deinen Nächsten! ");
INSERT INTO deu1951_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Laß dich nicht gelüsten deines Nächsten Hauses! Laß dich nicht gelüsten deines Nächsten Weibes, noch seines Knechtes, noch seiner Magd, noch seines Ochsen, noch seines Esels, noch alles dessen, was dein Nächster hat! ");
INSERT INTO deu1951_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Und alles Volk sah den Donner und Blitz und den Ton der Posaunen und den rauchenden Berg. Als nun das Volk solches sah, zitterte es und stand von ferne ");
INSERT INTO deu1951_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","und sprach zu Mose: Rede du mit uns, wir wollen zuhören; aber Gott soll nicht mit uns reden, wir müssen sonst sterben! ");
INSERT INTO deu1951_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose aber sprach zum Volk: Fürchtet euch nicht, denn Gott ist gekommen, euch zu prüfen, und damit seine Furcht euch vor Augen sei, damit ihr nicht sündiget! ");
INSERT INTO deu1951_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Und das Volk stand von ferne; Mose aber machte sich hinzu in das Dunkel, darinnen Gott war. ");
INSERT INTO deu1951_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Und der HERR sprach zu Mose: Also sollst du den Kindern Israel sagen: Ihr habt gesehen, daß ich mit euch vom Himmel her geredet habe. ");
INSERT INTO deu1951_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Darum sollt ihr keine andern Götter neben mir machen; silberne oder goldene Götter sollt ihr euch nicht machen. ");
INSERT INTO deu1951_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Einen Altar von Erde sollst du mir machen, darauf du deine Brandopfer und deine Dankopfer, deine Schafe und deine Rinder opferst; an jedem Ort, wo ich meines Namens Gedächtnis stifte, daselbst will ich zu dir kommen und dich segnen. ");
INSERT INTO deu1951_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Und so du mir einen steinernen Altar machen willst, sollst du ihn nicht von gehauenen Steinen bauen; denn wenn du mit deinem Eisen darüber führest, so würdest du ihn entweihen. ");
INSERT INTO deu1951_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Du sollst auch nicht auf Stufen zu meinem Altar steigen, damit deine Blöße vor ihm nicht aufgedeckt werde. ");
INSERT INTO deu1951_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Das sind die Rechte, die du ihnen vorlegen sollst: ");
INSERT INTO deu1951_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","So du einen hebräischen Knecht kaufst, soll er sechs Jahre lang dienen, und im siebenten soll er unentgeltlich freigelassen werden. ");
INSERT INTO deu1951_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ist er allein gekommen, so soll er auch allein entlassen werden; ist er aber verehelicht gekommen, so soll sein Weib mit ihm ausgehen. ");
INSERT INTO deu1951_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Hat ihm aber sein Herr ein Weib gegeben, und diese hat ihm Söhne oder Töchter geboren, so soll das Weib samt ihren Kindern seinem Herrn gehören; er aber soll allein entlassen werden. ");
INSERT INTO deu1951_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Spricht aber der Knecht: Ich habe meinen Herrn, mein Weib und meine Kinder lieb, ");
INSERT INTO deu1951_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ich will nicht freigelassen werden, so bringe ihn sein Herr vor Gott und stelle ihn an die Tür oder den Pfosten und durchbohre ihm seine Ohren mit einem Pfriem, daß er ihm diene ewiglich. ");
INSERT INTO deu1951_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Verkauft jemand seine Tochter als Magd, so soll sie nicht wie die Knechte freigelassen werden. ");
INSERT INTO deu1951_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Mißfällt sie ihrem Herrn, also daß er sie nicht heiratet, so lasse er sie loskaufen; aber unter ein fremdes Volk sie zu verkaufen hat er keine Macht, wenn er ihr untreu wird. ");
INSERT INTO deu1951_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Vermählt er sie aber seinem Sohne, so soll er nach der Töchter Recht mit ihr handeln. ");
INSERT INTO deu1951_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Nimmt er sich aber eine andere, so soll er jener an Nahrung, Kleidung und der ehelichen Pflicht nichts abbrechen. ");
INSERT INTO deu1951_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Tut er diese drei Stücke nicht an ihr, so soll sie umsonst, unentgeltlich frei werden. ");
INSERT INTO deu1951_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wer einen Menschen schlägt, daß er stirbt, der soll des Todes sterben. ");
INSERT INTO deu1951_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Hat er ihm aber nicht nachgestellt, sondern hat Gott es seiner Hand widerfahren lassen, so will ich dir einen Ort bestimmen, dahin er fliehen mag. ");
INSERT INTO deu1951_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Wenn aber jemand gegen seinen Nächsten so aufgebracht war, daß er ihn vorsätzlich umgebracht hat, so sollst du ihn von meinem Altar wegnehmen, damit er sterbe. ");
INSERT INTO deu1951_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wer seinen Vater oder seine Mutter schlägt, der soll des Todes sterben. ");
INSERT INTO deu1951_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wer einen Menschen stiehlt und ihn verkauft, oder so, daß man ihn noch in seiner Hand findet, der soll des Todes sterben. ");
INSERT INTO deu1951_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Auch wer seinem Vater oder seiner Mutter flucht, soll des Todes sterben. ");
INSERT INTO deu1951_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Wenn Männer miteinander hadern, und einer schlägt den andern mit einem Stein oder mit der Faust, daß er nicht stirbt, aber zu Bette liegen muß; ");
INSERT INTO deu1951_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","und wenn er soweit wieder hergestellt wird, daß er auf einen Stock gestützt ausgehen kann, so soll der, welcher ihn geschlagen hat, unschuldig sein; nur soll er ihn für die Versäumnis entschädigen und ihn vollständig heilen lassen. ");
INSERT INTO deu1951_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Und wer seinen Knecht oder seine Magd mit einem Stocke schlägt, so daß sie ihm unter der Hand sterben, der soll bestraft werden; ");
INSERT INTO deu1951_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","stehen sie aber nach einem oder zwei Tagen wieder auf, so soll er nicht bestraft werden, weil es sein eigener Schade ist. ");
INSERT INTO deu1951_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Wenn Männer sich zanken und stoßen ein schwangeres Weib, daß eine Fehlgeburt entsteht, aber sonst kein Schade, so muß eine Geldstrafe erlegt werden, wie sie der Ehemann des Weibes festsetzt; und man soll sie auf richterliche Entscheidung hin geben. ");
INSERT INTO deu1951_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Wenn aber ein Schaden entsteht, so sollst du ihn ersetzen; Seele um Seele, ");
INSERT INTO deu1951_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Auge um Auge, Zahn um Zahn, Hand um Hand, Fuß um Fuß, ");
INSERT INTO deu1951_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Brandmal um Brandmal, Wunde um Wunde, Beule um Beule. ");
INSERT INTO deu1951_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Wenn jemand seinem Knecht oder seiner Magd ein Auge ausschlägt, so soll er sie freilassen zur Entschädigung für das Auge. ");
INSERT INTO deu1951_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Desgleichen, wenn er dem Knecht oder der Magd einen Zahn ausschlägt, soll er sie auch freilassen für den Zahn. ");
INSERT INTO deu1951_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Wenn ein Ochs einen Mann oder eine Frau zu Tode stößt, so soll man ihn steinigen und sein Fleisch nicht essen; der Eigentümer des Ochsen aber bleibe unbestraft. ");
INSERT INTO deu1951_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ist aber der Ochs seit mehreren Tagen stößig gewesen und wurde sein Herr deshalb verwarnt, hat ihn aber doch nicht in Verwahrung getan, so soll der Ochs, der einen Mann oder eine Frau getötet hat, gesteinigt werden, und auch sein Herr soll sterben. ");
INSERT INTO deu1951_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Wird ihm aber ein Lösegeld auferlegt, so soll er zur Erlösung seiner Seele soviel geben, als man ihm auferlegt. ");
INSERT INTO deu1951_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Stößt er einen Sohn oder eine Tochter, so soll man ihn auch nach diesem Rechte behandeln. ");
INSERT INTO deu1951_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Wenn aber der Ochs einen Knecht stößt oder eine Magd, so soll man ihrem Herrn dreißig silberne Schekel bezahlen; der Ochs aber muß gesteinigt werden. ");
INSERT INTO deu1951_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Wenn jemand eine Zisterne abdeckt oder eine solche gräbt und deckt sie nicht zu, und es fällt ein Ochs oder Esel hinein, ");
INSERT INTO deu1951_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","so hat der Zisternenbesitzer den Eigentümer des Viehes mit Geld zu entschädigen, das Aas aber mag er behalten. ");
INSERT INTO deu1951_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Wenn jemandes Ochs den Ochsen eines anderen zu Tode stößt, so sollen sie den lebendigen Ochsen verkaufen und das Geld teilen und das Aas auch teilen. ");
INSERT INTO deu1951_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Wußte man aber, daß der Ochs schon seit etlichen Tagen stößig war und hat sein Herr ihn doch nicht in Verwahrung getan, so soll er den Ochsen ersetzen und das Aas behalten. ");
INSERT INTO deu1951_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Wenn jemand einen Ochsen stiehlt oder ein Schaf und schlachtet oder verkauft das Tier, so soll er fünf Ochsen für einen erstatten und vier Schafe für eins. ");
INSERT INTO deu1951_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Wird ein Dieb beim Einbruch ertappt und geschlagen, daß er stirbt, so ist man des Blutes nicht schuldig; ");
INSERT INTO deu1951_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","wäre aber die Sonne über ihm aufgegangen, so würde man des Blutes schuldig sein. Der Dieb soll Ersatz leisten; hat er aber nichts, so verkaufe man ihn um den Wert des Gestohlenen. ");
INSERT INTO deu1951_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Wird das Gestohlene noch lebend bei ihm vorgefunden, es sei ein Ochs, ein Esel oder ein Schaf, so soll er es doppelt wiedererstatten. ");
INSERT INTO deu1951_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Wenn jemand das Feld oder den Weinberg abweiden läßt, und er läßt dem Vieh freien Lauf, daß es auch das Feld eines andern abweidet, so soll er das Beste seines eigenen Feldes und das Beste seines Weinbergs dafür geben. ");
INSERT INTO deu1951_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Bricht Feuer aus und ergreift eine Dornhecke und frißt einen Garbenhaufen oder das stehende Gewächs oder das ganze Feld, so soll der, welcher den Brand verursacht hat, den Schaden vergüten. ");
INSERT INTO deu1951_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Gibt einer seinem Nächsten Geld oder Hausrat zu verwahren, und es wird aus dem Hause des Betreffenden gestohlen, so soll der Dieb, wenn er erwischt wird, es doppelt ersetzen. ");
INSERT INTO deu1951_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ist aber der Dieb nicht zu finden, so soll man den Hausherrn vor Gott bringen und ihn darüber verhören, ob er sich nicht vergriffen habe an seines Nächsten Gut. ");
INSERT INTO deu1951_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Wird irgend etwas gestohlen, sei es ein Ochs, ein Esel, ein Schaf, ein Kleid, oder was sonst abhanden gekommen sein mag, wovon einer behauptet: Der hat's! So soll beider Aussage vor Gott gelangen; wen Gott schuldig spricht, der soll es seinem Nächsten doppelt ersetzen. ");
INSERT INTO deu1951_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Wenn jemand seinem Nächsten einen Esel oder einen Ochsen oder ein Schaf oder irgend ein Vieh zu hüten gibt, und es kommt um oder nimmt Schaden oder wird geraubt, ohne daß es jemand sieht, ");
INSERT INTO deu1951_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","so soll ein Eid bei dem HERRN zwischen beiden entscheiden, daß jener sich nicht vergriffen habe an seines Nächsten Gut; und der Eigentümer soll ihn annehmen und keine Entschädigung erhalten. ");
INSERT INTO deu1951_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ist es ihm aber gestohlen worden, so soll er es dem Eigentümer ersetzen; ");
INSERT INTO deu1951_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","wenn es aber von einem wilden Tier zerrissen worden ist, so soll er das Zerrissene zum Beweis beibringen; bezahlen muß er es nicht. ");
INSERT INTO deu1951_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Entlehnt jemand etwas von seinem Nächsten, und es wird beschädigt oder kommt um, ohne daß der Eigentümer dabei ist, ");
INSERT INTO deu1951_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","so muß er es ersetzen; ist der Eigentümer dabei, so braucht jener es nicht zu ersetzen; ist er ein Tagelöhner, so ist es inbegriffen in seinem Lohn. ");
INSERT INTO deu1951_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Wenn ein Mann eine Jungfrau überredet, die noch unverlobt ist, und bei ihr liegt, so soll er sie sich durch Bezahlung des Kaufpreises zum Eheweib nehmen. ");
INSERT INTO deu1951_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Will aber ihr Vater sie ihm durchaus nicht geben, so soll er ihm soviel bezahlen, als der Kaufpreis für eine Jungfrau beträgt. ");
INSERT INTO deu1951_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Eine Zauberin sollst du nicht leben lassen! ");
INSERT INTO deu1951_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Wer bei einem Vieh liegt, soll des Todes sterben. ");
INSERT INTO deu1951_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Wer den Göttern opfert und nicht dem Herrn allein, der soll in den Bann getan werden. ");
INSERT INTO deu1951_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Den Fremdling sollst du nicht bedrängen noch bedrücken; denn ihr seid auch Fremdlinge gewesen in Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ihr sollt keine Witwen noch Waisen bedrücken. ");
INSERT INTO deu1951_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Wirst du sie dennoch bedrücken und sie schreien zu mir, so werde ich ihr Schreien gewiß erhören, ");
INSERT INTO deu1951_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","und es wird alsdann mein Zorn ergrimmen, daß ich euch mit dem Schwert umbringe, damit eure Weiber zu Witwen und eure Kinder zu Waisen werden! ");
INSERT INTO deu1951_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Wenn du meinem Volk Geld leihst, einem Armen, der bei dir wohnt, so sollst du ihn nicht wie ein Wucherer behandeln, du sollst ihm keinen Zins auferlegen. ");
INSERT INTO deu1951_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Wenn du von deinem Nächsten das Kleid als Pfand nimmst, so sollst du es ihm bis zum Sonnenuntergang wiedergeben; ");
INSERT INTO deu1951_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","denn es ist seine einzige Decke, das Kleid, das er auf der bloßen Haut trägt! Worin soll er schlafen? Schreit er aber zu mir, so erhöre ich ihn; denn ich bin gnädig. ");
INSERT INTO deu1951_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Gott sollst du nicht lästern, und dem Obersten deines Volkes sollst du nicht fluchen! ");
INSERT INTO deu1951_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Deinen Überfluß und dein Bestes sollst du nicht zurückbehalten; deinen erstgeborenen Sohn sollst du mir geben! ");
INSERT INTO deu1951_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Desgleichen sollst du tun mit deinem Ochsen und deinem Schaf; sieben Tage mag es bei seiner Mutter bleiben, am achten Tag sollst du es mir geben! ");
INSERT INTO deu1951_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Und ihr sollt mir heilige Leute sein; darum sollt ihr kein Fleisch essen, das auf dem Feld von wilden Tieren zerrissen worden ist, sondern sollt es den Hunden vorwerfen. ");
INSERT INTO deu1951_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Du sollst kein falsches Gerücht verbreiten! Leihe keinem Gottlosen deine Hand, daß du durch dein Zeugnis einen Frevel unterstützest! ");
INSERT INTO deu1951_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Du sollst nicht der Mehrheit folgen zum Bösen und sollst vor Gericht deine Aussagen nicht nach der Mehrheit richten, um zu verdrehen. ");
INSERT INTO deu1951_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Du sollst den Armen nicht beschönigen in seinem Prozeß. ");
INSERT INTO deu1951_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Wenn du den Ochsen oder Esel deines Feindes antriffst, der sich verlaufen hat, so sollst du ihm denselben wiederbringen. ");
INSERT INTO deu1951_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Siehst du den Esel deines Feindes unter seiner Last erliegen, könntest du es unterlassen, ihm zu helfen? Du sollst ihm samt jenem aufhelfen! ");
INSERT INTO deu1951_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Du sollst das Recht deines Armen nicht beugen in seinem Prozeß. ");
INSERT INTO deu1951_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Von falscher Anklage halte dich fern und bringe keinen Unschuldigen und Gerechten um; denn ich spreche keinen Gottlosen gerecht. ");
INSERT INTO deu1951_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Und nimm kein Geschenk! Denn das Geschenk macht die Sehenden blind und verkehrt die Sache der Gerechten. ");
INSERT INTO deu1951_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Und bedrücke den Fremdling nicht; denn ihr wißt, wie es den Fremdlingen zumute ist; denn ihr seid Fremdlinge gewesen in Ägyptenland. ");
INSERT INTO deu1951_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Sechs Jahre sollst du dein Land besäen und seinen Ertrag einsammeln; ");
INSERT INTO deu1951_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","aber im siebenten sollst du es brach liegen und sich ausruhen lassen, daß sich die Armen deines Volkes davon nähren, und was sie übriglassen, mögen die Tiere des Feldes fressen; desgleichen sollst du mit deinem Weinberg und Olivengarten tun. ");
INSERT INTO deu1951_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sechs Tage sollst du deine Werke verrichten, aber am siebenten Tag sollst du feiern, damit dein Ochs und dein Esel ausruhen und deiner Magd Sohn und der Fremdling sich erholen. ");
INSERT INTO deu1951_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Befolget alles, was ich euch befohlen habe, und erwähnet die Namen der fremden Götter nicht; die sollen gar nicht über eure Lippen kommen! ");
INSERT INTO deu1951_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Dreimal im Jahr sollst du mir ein Fest feiern. ");
INSERT INTO deu1951_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Das Fest der ungesäuerten Brote sollst du halten: sieben Tage sollst du ungesäuertes Brot essen zur bestimmten Zeit im Monat Abib, wie ich dir befohlen habe; denn in demselben bist du aus Ägypten ausgezogen. Man erscheine aber nicht leer vor mir! ");
INSERT INTO deu1951_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Und das Erntefest, da du deine ersten Erzeugnisse darbringst von dem, was du auf dem Felde gesät hast; und das Fest der Einsammlung am Ausgang des Jahres, wenn du deine Erzeugnisse vom Felde eingesammelt hast. ");
INSERT INTO deu1951_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Dreimal im Jahr soll alle deine Mannschaft vor dem Herrscher, dem HERRN, erscheinen! ");
INSERT INTO deu1951_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Du sollst das Blut meiner Opfer nicht zusammen mit Sauerteig darbringen, und das Fett meiner Festopfer soll nicht bleiben bis zum andern Morgen. ");
INSERT INTO deu1951_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Die frühesten Erstlinge deines Ackers sollst du in das Haus des HERRN, deines Gottes, bringen. Du sollst das Böcklein nicht in der Milch seiner Mutter kochen! ");
INSERT INTO deu1951_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Siehe, ich sende einen Engel vor dir her, dich zu behüten auf dem Weg und dich an den Ort zu bringen, den ich bereitet habe. ");
INSERT INTO deu1951_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Hüte dich vor ihm und gehorche seiner Stimme und sei nicht widerspenstig gegen ihn; denn er wird eure Übertretungen nicht ertragen; denn mein Name ist in ihm. ");
INSERT INTO deu1951_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Wirst du aber seiner Stimme gehorchen und alles tun, was ich sage, so will ich deine Feinde befehden und deinen Widersachern widerwärtig sein. ");
INSERT INTO deu1951_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Wenn nun mein Engel vor dir hergeht und dich zu den Amoritern, Hetitern, Pheresitern, Kanaanitern, Hevitern und Jebusitern bringt und ich sie vertilge, ");
INSERT INTO deu1951_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","so sollst du ihre Götter nicht anbeten, noch ihnen dienen, und sollst es nicht machen wie sie; sondern du sollst ihre Säulen niederreißen und sie gänzlich zerstören. ");
INSERT INTO deu1951_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Und ihr sollt dem HERRN, eurem Gott, dienen, so wird er dein Brot und dein Wasser segnen; und ich will die Krankheit aus deiner Mitte tun. ");
INSERT INTO deu1951_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Es soll keine Kinderlose und keine Unfruchtbare in deinem Lande sein; ich will die Zahl deiner Tage voll machen. ");
INSERT INTO deu1951_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ich will meinen Schrecken vor dir hersenden und will alle Völker in Verwirrung bringen, zu welchen du kommst, und will machen, daß alle deine Feinde dir den Rücken kehren sollen. ");
INSERT INTO deu1951_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ich will Hornissen vor dir hersenden, damit sie die Heviter, die Kanaaniter und Hetiter vor dir her vertreiben. ");
INSERT INTO deu1951_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ich will sie aber nicht in einem Jahre vor dir her vertreiben, damit das Land nicht zur Wüste werde und die wilden Tiere sich nicht zu deinem Schaden vermehren. ");
INSERT INTO deu1951_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nach und nach will ich sie vor dir vertreiben, in dem Maß, wie du zunimmst und das Land ererben kannst. ");
INSERT INTO deu1951_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Und ich setze deine Grenze vom Schilfmeer bis zum Philistermeer und von der Wüste bis zum Strom Euphrat; denn ich will die Bewohner des Landes in eure Hand geben, daß du sie vor dir her vertreibest. ");
INSERT INTO deu1951_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Du sollst mit ihnen und mit ihren Göttern keinen Bund schließen; ");
INSERT INTO deu1951_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","sie sollen nicht in deinem Lande wohnen, damit sie dich nicht zur Sünde gegen mich verleiten; denn du würdest ihren Göttern dienen, und sie würden dir zum Fallstrick werden. ");
INSERT INTO deu1951_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Er hatte aber zu Mose gesagt: Steige herauf zum HERRN, du und Aaron, Nadab und Abihu und siebzig von den Ältesten Israels, und betet an von ferne! ");
INSERT INTO deu1951_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Aber Mose allein nahe sich zum HERRN; jene sollen sich nicht nahen, und das Volk soll nicht mit ihnen heraufkommen! ");
INSERT INTO deu1951_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mose kam und erzählte dem Volk alle Worte des HERRN und alle die Verordnungen. Da antwortete das Volk einstimmig und sprach: Alles, was der HERR gesagt hat, wollen wir tun! ");
INSERT INTO deu1951_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Da schrieb Mose alle Worte des HERRN nieder und stand des Morgens frühe auf und baute einen Altar unten am Berg und zwölf Malsteine nach den zwölf Stämmen Israels. ");
INSERT INTO deu1951_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Und Mose sandte israelitische Jünglinge, daß sie Brandopfer darbrächten und Farren opferten zum Dankopfer dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Und Mose nahm die Hälfte des Blutes und tat es in Becken; aber die andere Hälfte des Blutes sprengte er auf den Altar. ");
INSERT INTO deu1951_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Darauf nahm er das Buch des Bundes und las es vor den Ohren des Volkes. Und sie sprachen: Alles, was der HERR gesagt hat, das wollen wir tun und befolgen! ");
INSERT INTO deu1951_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Da nahm Mose das Blut und sprengte es auf das Volk und sprach: Sehet, das ist das Blut des Bundes, den der HERR mit euch gemacht hat über allen diesen Worten! ");
INSERT INTO deu1951_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Da stiegen Mose und Aaron, Nadab und Abihu und siebzig von den Ältesten Israels hinauf; ");
INSERT INTO deu1951_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","und sie sahen den Gott Israels; und unter seinen Füßen war ein Boden wie von Saphirsteinen und so klar wie der Himmel selbst. ");
INSERT INTO deu1951_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Und er legte seine Hand nicht an die Auserwählten der Kinder Israel. Und als sie Gott gesehen hatten, aßen und tranken sie. ");
INSERT INTO deu1951_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Und der HERR sprach zu Mose: Steige zu mir herauf auf den Berg und bleibe daselbst, so will ich dir die steinernen Tafeln geben und das Gesetz und das Gebot, das ich geschrieben habe, um sie zu unterweisen! ");
INSERT INTO deu1951_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Da machte sich Mose auf samt seinem Diener Josua und stieg auf den Berg hinauf zu Gott. ");
INSERT INTO deu1951_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Zu den Ältesten aber hatte er gesagt: Erwartet uns hier, bis wir wieder zu euch kommen; sehet, Aaron und Hur sind bei euch; wer eine Angelegenheit hat, der wende sich an sie! ");
INSERT INTO deu1951_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Als nun Mose auf den Berg stieg, bedeckte eine Wolke den Berg. ");
INSERT INTO deu1951_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Und die Herrlichkeit des HERRN wohnte auf dem Berg Sinai, und die Wolke bedeckte ihn sechs Tage lang; am siebenten Tage aber rief er Mose von der Wolke aus zu. ");
INSERT INTO deu1951_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Und die Herrlichkeit des HERRN erschien den Kindern Israel wie ein verzehrendes Feuer oben auf dem Gipfel des Berges. ");
INSERT INTO deu1951_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mose aber ging mitten in die Wolke hinein, da er den Berg bestieg; und Mose blieb vierzig Tage und vierzig Nächte auf dem Berge. ");
INSERT INTO deu1951_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Sage den Kindern Israel, daß sie mir freiwillige Gaben bringen, und nehmet dieselben von jedermann, den sein Herz dazu treibt! ");
INSERT INTO deu1951_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Das sind aber die Gaben, die ihr von ihnen nehmen sollt: ");
INSERT INTO deu1951_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Gold, Silber, Erz, Stoffe von blauem und rotem Purpur und Karmesinfarbe, von feiner weißer Baumwolle und Ziegenhaaren, ");
INSERT INTO deu1951_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","rötliche Widderfelle, Seehundsfelle und Akazienholz, ");
INSERT INTO deu1951_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Öl zum Leuchter, Spezerei zum Salböl und zu gutem Räucherwerk, ");
INSERT INTO deu1951_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Schohamsteine und eingefaßte Steine zum Brustkleid und zum Brustschildlein. ");
INSERT INTO deu1951_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Und sie sollen mir ein Heiligtum machen, daß ich mitten unter ihnen wohne! ");
INSERT INTO deu1951_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Durchaus, wie ich dir ein Vorbild der Wohnung und aller ihrer Geräte zeigen werde, also sollt ihr es machen. ");
INSERT INTO deu1951_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Macht eine Lade von Akazienholz, dreieinhalb Ellen soll ihre Länge sein, anderthalb Ellen ihre Breite und anderthalb Ellen ihre Höhe. ");
INSERT INTO deu1951_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Die sollst du mit reinem Gold überziehen, inwendig und auswendig; und mache ringsum einen goldenen Kranz. ");
INSERT INTO deu1951_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Du sollst auch vier goldene Ringe dazu gießen und sie an ihre vier Ecken setzen; also, daß zwei Ringe auf einer Seite und zwei Ringe auf der andern Seite seien; ");
INSERT INTO deu1951_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","und mache Stangen von Akazienholz und überziehe sie mit Gold ");
INSERT INTO deu1951_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","und stecke sie in die Ringe an der Seite der Lade, daß man sie damit trage. ");
INSERT INTO deu1951_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Aber die Stangen sollen in den Ringen der Lade bleiben und nicht daraus entfernt werden. ");
INSERT INTO deu1951_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Und du sollst das Zeugnis, das ich dir geben werde, in die Lade legen. ");
INSERT INTO deu1951_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Du sollst auch einen Sühndeckel machen von reinem Gold; dreieinhalb Ellen soll seine Länge und anderthalb Ellen seine Breite sein. ");
INSERT INTO deu1951_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Und du sollst zwei Cherubim machen von Gold; von getriebener Arbeit sollst du sie machen, an beiden Enden des Sühndeckels. ");
INSERT INTO deu1951_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Also, daß du den einen Cherub an dem einen Ende machest und den andern Cherub an dem andern Ende; die Cherubim sollt ihr machen an den beiden Enden des Sühndeckels. ");
INSERT INTO deu1951_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Und die Cherubim sollen ihre Flügel darüber ausbreiten, daß sie mit ihren Flügeln den Sühndeckel schirmen und des einen Angesicht gegen das des andern gerichtet sei, und ihre Angesichter sollen auf den Sühndeckel sehen. ");
INSERT INTO deu1951_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Und du sollst den Sühndeckel oben über die Lade legen und das Zeugnis, das ich dir geben werde, in die Lade tun. ");
INSERT INTO deu1951_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Daselbst will ich mit dir zusammenkommen und mit dir reden von dem Sühndeckel herab, zwischen den beiden Cherubim auf der Lade des Zeugnisses, über alles, was ich dir für die Kinder Israel befehlen will. ");
INSERT INTO deu1951_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Du sollst auch einen Tisch machen von Akazienholz; zwei Ellen soll seine Länge und eine Elle seine Breite und anderthalb Ellen seine Höhe sein. ");
INSERT INTO deu1951_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Und sollst ihn überziehen mit reinem Gold und ihn ringsum mit einem goldenen Kranz versehen. ");
INSERT INTO deu1951_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Auch eine Leiste sollst du machen um ihn her und sie an den vier Ecken seiner Füße anbringen. ");
INSERT INTO deu1951_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Und sollst vier goldene Ringe daran machen, welche du an den vier Ecken seiner vier Füße anbringen sollst. ");
INSERT INTO deu1951_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Dicht unter der Leiste sollen die Ringe sein, daß man die Stangen darein tue und den Tisch trage. ");
INSERT INTO deu1951_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Du sollst aber die Stangen von Akazienholz machen und sie mit Gold überziehen, daß der Tisch damit getragen werde. ");
INSERT INTO deu1951_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Du sollst auch seine Schüsseln machen, seine Schalen, seine Kannen und seine Becher, daß man mit ihnen die Trankopfer ausgieße; aus reinem Golde sollst du sie machen. ");
INSERT INTO deu1951_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Und du sollst allezeit Schaubrote auf den Tisch legen vor mein Angesicht. ");
INSERT INTO deu1951_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Du sollst auch einen Leuchter von reinem Golde machen; in getriebener Arbeit soll dieser Leuchter gemacht werden; sein Fuß, sein Schaft, seine Kelche, Knoten und Blumen sollen aus einem Stück mit ihm sein. ");
INSERT INTO deu1951_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Sechs Arme sollen aus den Seiten des Leuchters herauskommen, drei Arme aus einer Seite des Leuchters und drei Arme aus der andern Seite des Leuchters. ");
INSERT INTO deu1951_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ein jeder Arm soll drei Kelche wie Mandelblüten, Knoten und Blumen haben. Auf diese Weise sollen die sechs Arme aus dem Leuchter gehen. ");
INSERT INTO deu1951_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Aber der Leuchter soll vier Kelche wie Mandelblüten, dazu seine Knoten und Blumen haben; ");
INSERT INTO deu1951_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","nämlich einen Knoten unter zwei Armen, und wieder einen Knoten unter zwei Armen; so bei den sechs Armen, die aus dem Leuchter gehen. ");
INSERT INTO deu1951_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Denn ihre Knoten und Arme sollen aus ihm herauskommen, und von getriebener Arbeit und aus reinem Gold sein. ");
INSERT INTO deu1951_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Und du sollst ihm sieben Lampen machen, und man zünde die Lampen an, daß sie Licht geben nach vorn. ");
INSERT INTO deu1951_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Und ihre Lichtscheren und Löschnäpflein sollen aus reinem Golde sein. ");
INSERT INTO deu1951_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Aus einem Zentner reinen Goldes soll man ihn machen mit allen diesen Geräten. ");
INSERT INTO deu1951_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Und siehe zu, daß du es machest nach dem Vorbilde, das dir auf dem Berge gezeigt worden ist! ");
INSERT INTO deu1951_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Die Wohnung sollst du machen von zehn Teppichen, von gezwirnter weißer Baumwolle, aus Stoffen von blauem und rotem Purpur und Karmesinfarbe. Cherubim sollst du künstlich darein wirken. ");
INSERT INTO deu1951_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Die Länge eines Teppichs soll achtundzwanzig Ellen sein und die Breite desselben vier Ellen; diese Teppiche alle sollen einerlei Maß haben. ");
INSERT INTO deu1951_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Fünf Teppiche sollen zusammengefügt sein, einer an den andern, und wieder fünf Teppiche. ");
INSERT INTO deu1951_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Und du sollst Schleifen machen von blauem Purpur an den Enden eines jeden Teppichs, da sie sollen zusammengefügt sein, daß je zwei und zwei an ihren Enden zusammengeheftet werden. ");
INSERT INTO deu1951_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Du sollst fünfzig Schleifen an dem Ende des einen Teppichs machen und fünfzig Schleifen an dem äußersten Ende des andern Teppichs, wo sie zusammengefügt werden; von diesen Schleifen soll je eine der andern gegenüberstehen. ");
INSERT INTO deu1951_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Und sollst fünfzig goldene Haften machen und damit die Teppiche zusammenheften einen an den andern, daß die Wohnung ein Ganzes werde. ");
INSERT INTO deu1951_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Du sollst auch Teppiche machen aus Ziegenhaaren zum Zelte über die Wohnung; elf solche Teppiche sollst du machen. ");
INSERT INTO deu1951_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Die Länge eines Teppichs soll dreißig Ellen sein, die Breite aber vier Ellen. Und alle elf sollen gleich sein. ");
INSERT INTO deu1951_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Fünf solcher Teppiche sollst du aneinander fügen und sechs auch aneinander, und sollst den sechsten Teppich zweifältig legen, vorne an der Hütte. ");
INSERT INTO deu1951_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Und sollst fünfzig Schleifen machen am Ende des ersten Teppichs und fünfzig Schleifen am Ende des andern Teppichs, wo sie zusammengefügt sind. ");
INSERT INTO deu1951_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Und sollst fünfzig eherne Haften machen und die Haften in die Schleifen tun, und die Hütte zusammenfügen, also daß sie ein Ganzes werde. ");
INSERT INTO deu1951_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Aber von dem Überschuß der Teppiche der Hütte sollst du die Hälfte überhängen lassen hinten an der Wohnung, ");
INSERT INTO deu1951_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","eine Elle auf dieser und eine Elle auf der anderen Seite von dem Überschuß an der Länge der Teppiche der Hütte; es soll etwas vorschießen auf beiden Seiten der Wohnung, um dieselbe auf beiden Seiten zu bedecken. ");
INSERT INTO deu1951_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Über diese Decke sollst du für die Hütte eine Decke von rötlichen Widderfellen machen. Dazu eine Decke von Seehundsfellen oben darüber. ");
INSERT INTO deu1951_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Und du sollst die Bretter der Wohnung von Akazienholz machen, aufrechtstehend. ");
INSERT INTO deu1951_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Zehn Ellen soll die Länge eines jeden Brettes sein und anderthalb Ellen eines jeden Breite. ");
INSERT INTO deu1951_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Zwei Zapfen soll ein Brett haben, einer dem andern gegenüberstehend. Also sollst du alle Bretter zur Wohnung machen. ");
INSERT INTO deu1951_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Und du sollst für die Wohnung zwanzig Bretter machen auf der Seite gegen Mittag, südwärts. ");
INSERT INTO deu1951_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Und du sollst unter die zwanzig Bretter vierzig silberne Füße machen, je zwei Füße unter ein Brett für seine beiden Zapfen; und wieder zwei Füße unter ein Brett für seine zwei Zapfen. ");
INSERT INTO deu1951_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ebenso auf der andern Seite der Wohnung gegen Mitternacht sollen auch zwanzig Bretter stehen. ");
INSERT INTO deu1951_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Und ihre vierzig silbernen Füße, je zwei Füße unter ein Brett. ");
INSERT INTO deu1951_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Aber du sollst sechs Bretter machen an der Seite der Wohnung gegen Abend. ");
INSERT INTO deu1951_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Dazu sollst du zwei Bretter machen hinten an die beiden Ecken der Wohnung. ");
INSERT INTO deu1951_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Die sollen doppelt sein von unten auf und sich oben zusammenfügen mit einem Ring; also sollen beide sein; an beiden Ecken sollen sie stehen. ");
INSERT INTO deu1951_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Daß da im ganzen acht Bretter seien mit ihren silbernen Füßen, sechzehn Füße, je zwei unter einem Brett. ");
INSERT INTO deu1951_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Und du sollst Riegel machen von Akazienholz, fünf zu den Brettern auf einer Seite der Wohnung, ");
INSERT INTO deu1951_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","und fünf zu den Brettern auf der andern Seite der Wohnung, und fünf zu den Brettern auf der hintern Seite der Wohnung gegen Abend. ");
INSERT INTO deu1951_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Und der mittlere Riegel soll inwendig durch die Bretter hindurchgehen von einem Ende zum andern. ");
INSERT INTO deu1951_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Und sollst die Bretter mit Gold überziehen und ihre Ringe von Gold machen, daß man die Riegel darein stecke; du sollst auch die Riegel mit Gold überziehen. ");
INSERT INTO deu1951_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Also sollst du die Wohnung aufrichten nach der Weise, wie du auf dem Berge gesehen hast. ");
INSERT INTO deu1951_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Du sollst auch einen Vorhang machen aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und von gezwirnter weißer Baumwolle, und sollst Cherubim künstlich darein wirken. ");
INSERT INTO deu1951_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Und sollst ihn hängen an vier Säulen von Akazienholz, die mit Gold überzogen sind und goldene Haken und vier silberne Füße haben. ");
INSERT INTO deu1951_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Und sollst den Vorhang unter die Haften hängen und die Lade des Zeugnisses innerhalb des Vorhangs setzen, daß der Vorhang euch eine Scheidewand bilde zwischen dem Heiligen und dem Allerheiligsten. ");
INSERT INTO deu1951_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Und sollst den Sühndeckel auf die Lade des Zeugnisses in dem Allerheiligsten legen. ");
INSERT INTO deu1951_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Den Tisch aber stelle außerhalb des Vorhanges auf und den Leuchter dem Tisch gegenüber auf der Südseite der Wohnung, daß der Tisch gegen Mitternacht stehe. ");
INSERT INTO deu1951_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Und du sollst einen Vorhang machen in die Türe der Hütte aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und von gezwirnter weißer Baumwolle in Buntwirkerarbeit. ");
INSERT INTO deu1951_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Und sollst für den Vorhang fünf Säulen machen von Akazienholz, mit Gold überzogen, mit goldenen Haken. Und sollst ihnen fünf eherne Füße gießen. ");
INSERT INTO deu1951_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Und du sollst einen Altar machen von Akazienholz, fünf Ellen lang und fünf Ellen breit, daß er viereckig sei, und drei Ellen hoch. ");
INSERT INTO deu1951_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Du sollst Hörner an seine vier Ecken machen; seine Hörner sollen aus ihm hervorgehen, und du sollst ihn mit Erz überziehen. ");
INSERT INTO deu1951_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Mache Aschentöpfe, Schaufeln, Sprengbecken, Gabeln und Kohlenpfannen. Alle seine Geschirre sollst du von Erz machen. ");
INSERT INTO deu1951_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Du sollst ihm auch ein ehernes Gitter machen wie ein Netz, und sollst an das Gitter vier eherne Ringe an seinen vier Ecken machen. ");
INSERT INTO deu1951_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Und sollst dasselbe unter die Einfassung des Altars setzen, unterhalb. Und das Gitter soll reichen bis zur halben Höhe des Altars. ");
INSERT INTO deu1951_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Und sollst Stangen machen für den Altar, von Akazienholz, mit Erz überzogen. ");
INSERT INTO deu1951_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Und sollst die Stangen in die Ringe stecken, daß die Stangen an beiden Seiten des Altars seien, damit man ihn tragen kann. ");
INSERT INTO deu1951_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Von Tafeln sollst du ihn machen, inwendig hohl; wie dir auf dem Berge gezeigt worden ist, so soll man ihn machen. ");
INSERT INTO deu1951_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Du sollst der Wohnung auch einen Vorhof machen: Auf der rechten Seite gegen Mittag Vorhänge von gezwirnter weißer Baumwolle, hundert Ellen lang auf der einen Seite. ");
INSERT INTO deu1951_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Und zwanzig Säulen auf zwanzig ehernen Füßen und ihre Haken mit ihren Querstangen von Silber. ");
INSERT INTO deu1951_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Also auch gegen Mitternacht sollen Vorhänge sein, hundert Ellen lang, und zwanzig Säulen auf zwanzig ehernen Füßen und ihre Haken mit ihren Querstangen von Silber. ");
INSERT INTO deu1951_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Aber gegen Abend soll die Breite der Vorhänge des Vorhofs fünfzig Ellen betragen; und es sollen zehn Säulen auf zehn Füßen sein. ");
INSERT INTO deu1951_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Gegen Morgen aber, gegen Aufgang, soll die Breite des Vorhofs fünfzig Ellen betragen; ");
INSERT INTO deu1951_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","und zwar sollen fünfzehn Ellen Vorhänge auf die eine Seite kommen, dazu drei Säulen auf drei Füßen; ");
INSERT INTO deu1951_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","desgleichen fünfzehn Ellen auf die andere Seite, dazu drei Säulen auf drei Füßen. ");
INSERT INTO deu1951_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Aber in dem Tor des Vorhofs soll ein Vorhang sein, zwanzig Ellen breit, aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und gezwirnter weißer Baumwolle in Buntwirkerarbeit, dazu vier Säulen auf ihren Füßen. ");
INSERT INTO deu1951_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Alle Säulen um den Vorhof her sollen silberne Querstangen und silberne Haken und eherne Füße haben. ");
INSERT INTO deu1951_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Und die Länge des Vorhofs soll hundert Ellen sein, die Breite fünfzig Ellen, die Höhe fünf Ellen; die Umhänge von gezwirnter weißer Baumwolle; und seine Füße sollen ehern sein. ");
INSERT INTO deu1951_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Auch alle Geräte der Wohnung zu allerlei Dienst und alle ihre Nägel und alle Nägel des Vorhofs sollen ehern sein. ");
INSERT INTO deu1951_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Gebiete auch den Kindern Israel, daß sie zu dir bringen lauteres, gestoßenes Olivenöl für den Leuchter, um beständig Licht zu unterhalten. ");
INSERT INTO deu1951_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In der Stiftshütte außerhalb des Vorhangs, der vor dem Zeugnis hängt, sollen Aaron und seine Söhne es zurichten, vom Abend bis zum Morgen, vor dem HERRN. Das ist ein ewiger Gebrauch, der von den Kindern Israel jederzeit zu beobachten ist. ");
INSERT INTO deu1951_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Und du sollst deinen Bruder Aaron und seine Söhne mit ihm zu dir nahen lassen aus den Kindern Israel, daß er mein Priester sei, nämlich Aaron und seine Söhne, Nadab, Abihu, Eleasar und Itamar. ");
INSERT INTO deu1951_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Und du sollst deinem Bruder Aaron heilige Kleider machen zur Ehre und zur Zierde. ");
INSERT INTO deu1951_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Und sollst reden mit allen, die eines weisen Herzens sind, die ich mit dem Geist der Weisheit erfüllt habe, daß sie dem Aaron Kleider machen, ihn zu heiligen und mir zum Priester zu weihen. ");
INSERT INTO deu1951_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Das sind aber die Kleider, welche sie machen sollen: Ein Brustschildlein, ein Ephod, einen Rock und einen Leibrock von gewürfeltem Stoff, Kopfbund und Gürtel. Also sollen sie deinem Bruder Aaron und seinen Söhnen heilige Kleider machen, daß er mein Priester sei. ");
INSERT INTO deu1951_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Dazu sollen sie Gold nehmen und Stoffe von blauem und rotem Purpur und Karmesinfarbe und von weißer Baumwolle. ");
INSERT INTO deu1951_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Das Ephod sollen sie machen von Gold und aus Stoff von blauem und rotem Purpur und Karmesinfarbe und gezwirnter weißer Baumwolle, künstlich gezwirnt. ");
INSERT INTO deu1951_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Zwei verbundene Schulterstücke soll es haben, an seinen beiden Enden verbunden. ");
INSERT INTO deu1951_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Die künstliche Arbeit aber seines Gürtels, welcher darauf liegt, soll von der gleichen Arbeit sein, von Gold, aus Stoff von blauem und rotem Purpur und Karmesinfarbe und von gezwirnter weißer Baumwolle. ");
INSERT INTO deu1951_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Und du sollst zwei Schohamsteine nehmen und die Namen der Kinder Israel darauf graben, ");
INSERT INTO deu1951_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","sechs Namen derselben auf den einen Stein und die sechs übrigen Namen auf den andern Stein, nach ihren Geschlechtern. ");
INSERT INTO deu1951_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Steinschneiderarbeit soll es sein, von Siegelstechern; die Namen der Kinder Israel sollst du auf die beiden Steine stechen und sie mit Gold einfassen lassen. ");
INSERT INTO deu1951_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Und sollst sie auf die Schulterstücke des Ephod heften, daß sie Steine des Gedächtnisses seien für die Kinder Israel; daß Aaron ihre Namen auf seinen beiden Schultern trage vor dem HERRN, zum Gedächtnis. ");
INSERT INTO deu1951_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Und du sollst goldene Einfassungen machen, ");
INSERT INTO deu1951_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","und zwei gewundene Ketten von reinem Gold, und sollst die zwei gewundenen Ketten an der Einfassung befestigen. ");
INSERT INTO deu1951_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Das Brustschildlein für die Rechtspflege soll ein Kunstwerk sein wie das Ephod, von Gold, aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und gezwirnter weißer Baumwolle. ");
INSERT INTO deu1951_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Viereckig soll es sein und zweifach, eine Spanne lang und eine Spanne breit. ");
INSERT INTO deu1951_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Und du sollst es mit vier Reihen von Steinen besetzen. Die erste Reihe sei ein Rubin, ein Topas und ein Smaragd; ");
INSERT INTO deu1951_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","die zweite Reihe ein Granat, ein Saphir und ein Diamant; ");
INSERT INTO deu1951_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","die dritte Reihe ein Opal, ein Achat, ein Amethyst; ");
INSERT INTO deu1951_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","die vierte Reihe ein Chrysolith, ein Schoham und ein Jaspis. In Gold sollen sie gefaßt sein bei ihrer Einsetzung. ");
INSERT INTO deu1951_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Und diese Steine sollen nach den zwölf Namen der Kinder Israel lauten und von Steinschneidern gestochen sein, ein Stein für jeden Namen der zwölf Stämme. ");
INSERT INTO deu1951_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Und du sollst für das Brustschildlein gewundene Ketten machen von lauterem Golde, ");
INSERT INTO deu1951_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","und zwei goldene Ringe, also daß du dieselben beiden Ringe an zwei Ecken des Brustschildes heftest ");
INSERT INTO deu1951_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","und die beiden goldenen, gewundenen Ketten in die zwei Ringe tuest, die an den beiden Enden des Brustschildleins sind. ");
INSERT INTO deu1951_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Aber die beiden andern Enden der zwei gewundenen Ketten sollst du in die beiden Einfassungen tun und sie einander gegenüber auf die Schulterstücke des Ephod heften. ");
INSERT INTO deu1951_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Und du sollst zwei andere goldene Ringe machen und sie an die andern beiden Ecken des Brustschildleins heften, nämlich an seinen Saum, welcher inwendig dem Ephod zugekehrt ist. ");
INSERT INTO deu1951_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Und sollst noch zwei goldene Ringe machen und sie auf die beiden Schulterstücke des Ephod heften, unterhalb, einander gegenüber, dort wo das Ephod zusammengeht, oben an dem Gürtel des Ephod. ");
INSERT INTO deu1951_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Und man soll das Brustschildlein mit seinen Ringen mit einer Schnur von blauem Purpur an die Ringe des Ephod knüpfen, daß es an dem Gürtel des Ephod hart anliege und das Brustschildlein sich nicht von dem Ephod losmache. ");
INSERT INTO deu1951_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Also soll Aaron die Namen der Kinder Israel in dem Brustschildlein für die Rechtspflege auf seinem Herzen tragen, wenn er in das Heilige geht, zum Gedächtnis vor dem HERRN, allezeit. ");
INSERT INTO deu1951_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Und du sollst in das Brustschildlein für die Rechtspflege das Licht und Recht legen, daß sie auf dem Herzen Aarons seien, wenn er hineingeht vor dem HERRN; und also soll Aaron die Rechtspflege der Kinder Israel allezeit auf seinem Herzen tragen vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Du sollst auch den Rock zum Ephod ganz von blauem Purpur machen. ");
INSERT INTO deu1951_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Und oben in der Mitte soll eine Öffnung sein, und ein Saum um die Öffnung her gewoben, wie der Saum eines Panzers, damit er nicht zerreiße. ");
INSERT INTO deu1951_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Und unten, an seinem Saum, sollst du Granatäpfel machen aus Stoffen von blauem und rotem Purpur und Karmesinfarbe, ringsum, und goldene Schellen zwischen dieselben, auch ringsum, ");
INSERT INTO deu1951_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","daß eine goldene Schelle sei, darnach ein Granatapfel, und wieder eine goldene Schelle, darnach ein Granatapfel, ringsum an dem Saum des Rocks. ");
INSERT INTO deu1951_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Und Aaron soll ihn tragen, wenn er dient, daß man seinen Klang höre, wenn er hineingeht in das Heiligtum vor dem HERRN und wenn er hinausgeht, auf daß er nicht sterbe. ");
INSERT INTO deu1951_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Du sollst auch ein Stirnblatt von reinem Golde machen und darein graben in Siegelschrift: Heilig dem HERRN! ");
INSERT INTO deu1951_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","und sollst dasselbe anheften mit einer Schnur von blauem Purpur, daß es an dem Kopfbunde sei; vorn am Kopfbund soll es sein; ");
INSERT INTO deu1951_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","und es soll auf Aarons Stirne sein, damit Aaron die Verschuldung trage in betreff der heiligen Gaben, welche die Kinder Israel weihen, welcherlei heilige Opfergaben sie auch darbringen mögen. Und es soll allezeit auf seiner Stirne sein, um sie wohlgefällig zu machen vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Den Leibrock sollst du weben von weißer Baumwolle und einen gestickten Gürtel machen. ");
INSERT INTO deu1951_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Gleicherweise sollst du den Söhnen Aarons Leibröcke, Gürtel und Kopfbünde machen zur Ehre und zur Zierde. ");
INSERT INTO deu1951_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Und sollst sie deinem Bruder Aaron samt seinen Söhnen anlegen, und sie salben und ihre Hände füllen und sie weihen, daß sie meine Priester seien. ");
INSERT INTO deu1951_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Und sollst ihnen leinene Beinkleider machen, die Blöße zu bedecken, von den Lenden bis an die Hüften. ");
INSERT INTO deu1951_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Und Aaron und seine Söhne sollen sie tragen, wenn sie in die Stiftshütte gehen oder zum Altare treten, zum Dienst am Heiligtum, damit sie keine Schuld auf sich laden und nicht sterben müssen. Das sei eine ewige Ordnung für ihn und seinen Samen nach ihm! ");
INSERT INTO deu1951_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Das ist aber die Verordnung, welche du befolgen sollst, daß sie mir zu Priestern geweiht werden. Nimm einen jungen Farren und zwei fehllose Widder ");
INSERT INTO deu1951_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","und ungesäuertes Brot und ungesäuerte Kuchen, mit Öl gemengt, und ungesäuerte Fladen, mit Öl gesalbt; von Weizenmehl sollst du es alles machen; ");
INSERT INTO deu1951_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","und lege es in einen Korb und bringe es in dem Korbe herzu samt dem Farren und den beiden Widdern. ");
INSERT INTO deu1951_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Alsdann sollst du Aaron und seine Söhne vor die Türe der Stiftshütte führen und sie mit Wasser waschen, ");
INSERT INTO deu1951_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","und die Kleider nehmen und dem Aaron den Leibrock anziehen, und den Rock zu dem Ephod, auch das Ephod und das Brustschildlein; und du sollst ihn gürten mit dem Gürtel des Ephod; ");
INSERT INTO deu1951_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","und den Kopfbund auf sein Haupt setzen, und das heilige Diadem an den Kopfbund heften. ");
INSERT INTO deu1951_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Und du sollst das Salböl nehmen und auf sein Haupt gießen und ihn salben. ");
INSERT INTO deu1951_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Und seine Söhne sollst du auch herzubringen und ihnen die Leibröcke anlegen. ");
INSERT INTO deu1951_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Und beide, Aaron und seine Söhne, mit Gürteln gürten und ihnen die Kopfbünde aufbinden, daß ihnen das Priesteramt zur ewigen Ordnung werde. Auch sollst du Aaron und seinen Söhnen die Hände füllen. ");
INSERT INTO deu1951_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Darnach sollst du den Farren herzubringen vor die Stiftshütte. Und Aaron und seine Söhne sollen ihre Hände auf des Farren Kopf legen. ");
INSERT INTO deu1951_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Und du sollst den Farren schächten vor dem HERRN, vor der Tür der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Und du sollst von des Farren Blut nehmen und mit deinem Finger auf die Hörner des Altars tun, alles übrige Blut aber an den Fuß des Altars schütten. ");
INSERT INTO deu1951_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Und du sollst alles Fett nehmen, welches die Eingeweide bedeckt, und das Fett über der Leber und die beiden Nieren mit dem Fett, das daran ist, und sollst es auf dem Altar anzünden. ");
INSERT INTO deu1951_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Aber des Farren Fleisch, Haut und Mist sollst du draußen vor dem Lager mit Feuer verbrennen; denn es ist ein Sündopfer. ");
INSERT INTO deu1951_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Darnach sollst du den einen Widder nehmen und Aaron und seine Söhne sollen ihre Hände auf seinen Kopf legen. ");
INSERT INTO deu1951_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Und du sollst ihn schächten und von seinem Blut nehmen und auf den Altar sprengen ringsumher. ");
INSERT INTO deu1951_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Aber den Widder sollst du in Stücke zerlegen und seine Eingeweide und seine Schenkel waschen und sollst sie zu den Stücken und zu seinem Kopf legen, ");
INSERT INTO deu1951_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","und auf dem Altar den ganzen Widder anzünden; denn es ist ein Brandopfer dem HERRN; eine süßer Geruch, ein Feueropfer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Desgleichen sollst du den andern Widder nehmen, und wenn Aaron und seine Söhne ihre Hände auf seinen Kopf gelegt haben, ");
INSERT INTO deu1951_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","sollst du ihn schächten und von seinem Blute nehmen und davon dem Aaron und seinen Söhnen auf das rechte Ohrläpplein tun und auf den Daumen ihrer rechten Hand und auf die große Zehe ihres rechten Fußes; das Blut aber sollst du ringsumher auf den Altar sprengen. ");
INSERT INTO deu1951_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Und sollst von dem Blut auf dem Altar und vom Salböl nehmen und den Aaron und seine Kleider, seine Söhne und ihre Kleider besprengen, so wird er und seine Kleider, seine Söhne und ihre Kleider dadurch geheiligt sein. ");
INSERT INTO deu1951_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Darnach sollst du das Fett von dem Widder nehmen und den Fettschwanz und das Fett, das die Eingeweide bedeckt, das Fett über der Leber und die beiden Nieren mit dem Fett, das daran ist, und die rechte Schulter; denn es ist ein Widder der Einweihung. ");
INSERT INTO deu1951_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Und nimm einen Laib Brot und einen Ölkuchen und einen Fladen aus dem Korb mit dem ungesäuerten Brot, der vor dem HERRN steht, ");
INSERT INTO deu1951_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","und lege alles auf die Hände Aarons und auf die Hände seiner Söhne und webe es zum Webopfer vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Darnach nimm es von ihren Händen und zünde es an auf dem Altar zum Brandopfer, zum süßen Geruch vor dem HERRN; es ist ein Feueropfer des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Du sollst ferner die Brust nehmen vom Widder der Einweihung Aarons und sollst sie vor dem HERRN weben zum Webopfer; das soll dein Teil sein. ");
INSERT INTO deu1951_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Und sollst also heiligen die Webebrust und die Hebeschulter, die von dem Widder der Einweihung Aarons und seiner Söhne gewebet und gehoben sind. ");
INSERT INTO deu1951_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Und das soll Aarons und seiner Söhne ewige Gebühr sein von den Kindern Israel; denn es ist ein Hebopfer, und soll erhoben werden von den Kindern Israel, von ihren Dankopfern, als ihr Hebopfer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aber die heiligen Kleider Aarons sollen seine Söhne nach ihm bekommen, daß sie darin gesalbt und ihre Hände darin gefüllt werden. ");
INSERT INTO deu1951_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Welcher unter seinen Söhnen an seiner Statt Priester wird, daß er in die Stiftshütte gehe, zu dienen im Heiligtum, der soll sie sieben Tage lang tragen. ");
INSERT INTO deu1951_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Du sollst aber den Widder der Einweihung nehmen und sein Fleisch an einem heiligen Orte kochen. ");
INSERT INTO deu1951_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Und Aaron mit seinen Söhnen soll das Fleisch desselben Widders essen samt dem Brot im Korbe, vor der Tür der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Sie sollen das essen, womit die Sühne für sie bewirkt wurde, als man ihre Hände füllte, sie zu weihen. Kein Fremder soll es essen, denn es ist heilig! ");
INSERT INTO deu1951_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Wenn aber etwas von dem Fleisch der Einweihung und von dem Brot bis zum Morgen übrigbleibt, sollst du das Übrige mit Feuer verbrennen und nicht essen lassen; denn es ist heilig. ");
INSERT INTO deu1951_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Und sollst also mit Aaron und seinen Söhnen alles tun, was ich dir geboten habe. Sieben Tage sollst du ihre Hände füllen ");
INSERT INTO deu1951_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","und sollst täglich einen Farren zum Sündopfer schlachten um der Sühnung willen; und sollst den Altar entsündigen, indem du ihn versühnst, und sollst ihn salben, daß er geweiht werde. ");
INSERT INTO deu1951_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sieben Tage sollst du den Altar versühnen und ihn weihen, so wird der Altar hochheilig sein. Was mit dem Altar in Berührung kommt, das wird heilig. ");
INSERT INTO deu1951_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Das ist es aber, was du auf dem Altar herrichten sollst: Zwei einjährige Lämmer sollst du beständig, Tag für Tag, darauf opfern; ");
INSERT INTO deu1951_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ein Lamm am Morgen, das andere in den Abendstunden; ");
INSERT INTO deu1951_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","und zum ersten Lamm einen Zehntel Semmelmehl, gemengt mit einem Viertel Hin gestoßenen Öls und einem Viertel Hin Wein zum Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Das andere Lamm sollst du in den Abendstunden zurichten; und mit dem Speis und Trankopfer sollst du es halten wie am Morgen; zum lieblichen Geruch, zum Feueropfer des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Das soll das beständige Brandopfer eurer Geschlechter sein vor dem HERRN, vor der Tür der Stiftshütte, wo ich mit euch zusammenkommen will, um mit dir zu reden; ");
INSERT INTO deu1951_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ja, ich will mich daselbst bei den Kindern Israel einstellen, und sie soll geheiligt werden durch meine Herrlichkeit. ");
INSERT INTO deu1951_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Und ich will die Stiftshütte heiligen samt dem Altar und mir Aaron samt seinen Söhnen heiligen zum Priesterdienst. ");
INSERT INTO deu1951_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Und ich will mitten unter den Kindern Israel wohnen und ihr Gott sein. ");
INSERT INTO deu1951_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Und sie sollen erfahren, daß ich, der HERR, ihr Gott bin, der sie aus Ägypten geführt hat, damit ich unter ihnen wohne, ich, der HERR, ihr Gott. ");
INSERT INTO deu1951_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Du sollst auch einen Räucheraltar machen zum Räucherwerk; von Akazienholz sollst du ihn machen. ");
INSERT INTO deu1951_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Eine Elle lang und eine Elle breit soll er sein, viereckig und zwei Ellen hoch, und seine Hörner sollen aus ihm heraus-gehen. ");
INSERT INTO deu1951_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Und du sollst ihn mit reinem Gold überziehen, seine Platte und seine Wände ringsum und seine Hörner, und sollst ringsum einen Kranz von reinem Gold machen, ");
INSERT INTO deu1951_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","und je zwei goldene Ringe unter dem Kranz; neben seinen beiden Ecken sollst du sie machen zu seinen beiden Seiten, daß man Stangen darein stecken und ihn damit tragen kann. ");
INSERT INTO deu1951_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Die Stangen sollst du auch von Akazienholz machen und sie mit Gold überziehen. ");
INSERT INTO deu1951_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Und du sollst ihn setzen vor den Vorhang, der vor der Lade des Zeugnisses hängt, und vor den Sühndeckel, der auf dem Zeugnis ist, da ich mit dir zusammenkommen will. ");
INSERT INTO deu1951_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Und Aaron soll alle Morgen wohlriechendes Räucherwerk darauf anzünden; wenn er die Lampen zurichtet, soll er räuchern. ");
INSERT INTO deu1951_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Desgleichen, wenn er in den Abendstunden die Lampen anzündet, soll er auch solches Räucherwerk anzünden. Es soll ein beständiges Räucherwerk sein vor dem HERRN in euren künftigen Geschlechtern. ");
INSERT INTO deu1951_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ihr sollt kein fremdes Räucherwerk darbringen darauf und auch kein Brandopfer, kein Speisopfer und kein Trankopfer darauf opfern. ");
INSERT INTO deu1951_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aber einmal im Jahr soll Aaron auf seinen Hörnern die Sühne vollziehen; mit dem Blut des Versöhnungsopfers soll er einmal jährlich darauf Sühne leisten für eure Geschlechter; er ist dem HERRN hochheilig. ");
INSERT INTO deu1951_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Wenn du die Zahl der Kinder Israel ermittelst, so soll ein jeder dem HERRN ein Lösegeld für seine Seele geben, wenn man sie zählt; damit ihnen nicht eine Plage widerfahre, wenn sie gezählt werden; ");
INSERT INTO deu1951_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","und zwar soll jeder, der durch die Musterung geht, einen halben Schekel geben, nach dem Schekel des Heiligtums; ein Schekel gilt zwanzig Gera. Der halbe Schekel ist eine Abgabe an den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Wer durch die Musterung geht im Alter von zwanzig Jahren und darüber, der soll dem HERRN die Abgabe entrichten. ");
INSERT INTO deu1951_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Der Reiche soll nicht mehr und der Arme nicht weniger als einen halben Schekel geben bei der Entrichtung der Abgabe an den HERRN zur Sühnung eurer Seelen. ");
INSERT INTO deu1951_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Und du sollst das Sühnegeld von den Kindern Israel nehmen und es für den Dienst der Stiftshütte geben, daß es den Kindern Israel zum Gedächtnis diene vor dem HERRN, zur Sühnung für eure Seelen. ");
INSERT INTO deu1951_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Weiter redete der HERR mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Du sollst auch ein ehernes Becken machen mit einem ehernen Fuß, zum Waschen, und sollst es aufstellen zwischen der Stiftshütte und dem Altar, und Wasser darein tun, ");
INSERT INTO deu1951_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","daß Aaron und seine Söhne ihre Hände und Füße waschen. ");
INSERT INTO deu1951_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wenn sie in die Stiftshütte gehen wollen, so sollen sie sich mit Wasser waschen, damit sie nicht sterben; desgleichen wenn sie zum Altar nahen, um zu dienen und anzuzünden die Feueropfer des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Und zwar sollen sie ihre Hände und ihre Füße waschen, damit sie nicht sterben. Das soll ihnen eine ewig gültige Ordnung sein, ihm und seinem Samen, für ihr Geschlecht. ");
INSERT INTO deu1951_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Der HERR redete weiter mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Nimm dir wohlriechende, auserlesene Spezereien: fünfhundert Schekel selbstausgeflossene Myrrhen und halb so viel Zimmet, also zweihundertundfünfzig, und wohlriechenden Kalmus, auch zweihundertundfünfzig, ");
INSERT INTO deu1951_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","dazu fünfhundert Schekel Kassia, nach dem Schekel des Heiligtums, und ein Hin Olivenöl; daraus mache ein heiliges Salböl, ");
INSERT INTO deu1951_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","nach der Kunst des Salbenbereiters gemengt; ein heiliges Salböl soll es sein. ");
INSERT INTO deu1951_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Und du sollst damit die Stiftshütte und die Lade des Zeugnisses salben ");
INSERT INTO deu1951_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","und den Tisch mit allem seinem Gerät, den Leuchter mit seinem Gerät, den Räucheraltar, ");
INSERT INTO deu1951_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","den Brandopferaltar mit allem seinem Gerät und das Becken mit seinem Fuß. ");
INSERT INTO deu1951_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Und sollst sie also weihen, daß sie hochheilig seien; alles, was damit in Berührung kommt, wird heilig. ");
INSERT INTO deu1951_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Auch Aaron und seine Söhne sollst du salben und sie mir zu Priestern weihen. ");
INSERT INTO deu1951_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Und du sollst zu den Kindern Israel sagen: Das soll mir ein heiliges Salböl sein für alle Zeiten! ");
INSERT INTO deu1951_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Auf Menschenleiber soll es nicht gegossen werden; du sollst auch in der gleichen Zusammensetzung keines für euch machen; denn es ist heilig, darum soll es euch heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Wer es nachmacht oder einem Fremden davon gibt, der soll von seinem Volk ausgerottet werden. ");
INSERT INTO deu1951_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Und der HERR sprach zu Mose: Nimm dir Spezereien: wohlriechendes Harz, Räucherklaue, Galbanum und reinen Weihrauch, zu gleichen Teilen, ");
INSERT INTO deu1951_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","und mache Räucherwerk daraus, nach der Kunst des Salbenbereiters gemengt, gesalzen, rein und heilig. ");
INSERT INTO deu1951_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Und zerreibe etwas davon ganz fein und lege etwas davon vor das Zeugnis in der Stiftshütte, wo ich mit dir zusammenkommen will. Das soll euch hochheilig sein. ");
INSERT INTO deu1951_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Und von dem Räucherwerk, das nach diesen Vorschriften gemacht wird, sollt ihr euch keines machen, sondern es soll dem HERRN heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Wer es nachmacht, um daran zu riechen, der soll von seinem Volk ausgerottet werden! ");
INSERT INTO deu1951_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Siehe, ich habe mit Namen berufen Bezaleel, den Sohn Uris, des Sohnes Hurs, vom Stamme Juda, ");
INSERT INTO deu1951_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","und habe ihn mit dem Geiste Gottes erfüllt, mit Weisheit und Verstand und Erkenntnis und mit allerlei Fertigkeit, ");
INSERT INTO deu1951_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Erfindungen zu machen und sie auszuführen in Gold, Silber und Erz, ");
INSERT INTO deu1951_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","und künstlich Steine zu schneiden und einzusetzen und künstlich zu zimmern am Holz, zu machen allerlei Werke. ");
INSERT INTO deu1951_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Und siehe, ich habe ihm beigegeben Oholiab, den Sohn Ahisamachs, vom Stamme Dan, und habe allen Weisen die Weisheit ins Herz gegeben, daß sie alles, was ich dir geboten habe, machen sollen: ");
INSERT INTO deu1951_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Die Stiftshütte, die Lade des Zeugnisses, den Sühndeckel darauf und alle Geräte der Hütte, ");
INSERT INTO deu1951_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","den Tisch und seine Geräte, den reinen Leuchter und alle seine Geräte, den Räucheraltar, ");
INSERT INTO deu1951_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","den Brandopferaltar mit allen seinen Geräten, das Becken mit seinem Fuß, ");
INSERT INTO deu1951_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","die Amtskleider und die heiligen Kleider des Priesters Aaron und die Kleider seiner Söhne, priesterlich zu dienen, ");
INSERT INTO deu1951_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","und das Salböl und das Räucherwerk von Spezerei zum Heiligtum; ganz so, wie ich dir geboten habe, sollen sie es machen. ");
INSERT INTO deu1951_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Sage den Kindern Israel und sprich: Beobachtet nur ja meine Sabbate! Denn sie sind das Zeichen zwischen mir und euch für alle eure Geschlechter, damit man wisse, daß ich der HERR bin, der euch heiligt. ");
INSERT INTO deu1951_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Und zwar sollt ihr den Sabbat beobachten, weil er euch heilig sein soll. Wer ihn entheiligt, der soll des Todes sterben; wer an demselben eine Arbeit verrichtet, dessen Seele soll ausgerottet werden aus seinem Volk! ");
INSERT INTO deu1951_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sechs Tage soll man arbeiten; aber am siebenten Tage ist der Sabbat, die heilige Ruhe des HERRN. Wer am Sabbattag eine Arbeit verrichtet, der soll des Todes sterben! ");
INSERT INTO deu1951_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Und zwar sollen die Kinder Israel den Sabbat halten, damit sie ihn für alle ihre Geschlechter zum ewigen Bunde machen. ");
INSERT INTO deu1951_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Er ist ein ewiges Zeichen zwischen mir und den Kindern Israel; denn in sechs Tagen machte der HERR Himmel und Erde; aber am siebenten Tage ruhte er und erquickte sich. ");
INSERT INTO deu1951_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Als er mit Mose auf dem Berge Sinai zu Ende geredet hatte, gab er ihm die beiden Tafeln des Zeugnisses; die waren steinern und mit dem Finger Gottes beschrieben. ");
INSERT INTO deu1951_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Als aber das Volk sah, daß Mose vom Berg zu kommen verzog, sammelte es sich um Aaron und sprach zu ihm: Auf, mache uns Götter, die uns vorangehen! Denn wir wissen nicht, was diesem Manne Mose widerfahren ist, der uns aus Ägypten geführt hat. ");
INSERT INTO deu1951_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron sprach zu ihnen: Reißet die goldenen Ohrringe ab, die an den Ohren eurer Weiber, eurer Söhne und eurer Töchter sind, und bringet sie zu mir! ");
INSERT INTO deu1951_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Da riß alles Volk seine goldenen Ohrringe ab, welche an ihren Ohren waren, und brachten sie zu Aaron. ");
INSERT INTO deu1951_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Und er nahm sie von ihren Händen und bildete es mit dem Meißel und machte ein gegossenes Kalb. Da sprachen sie: Das sind deine Götter, Israel, die dich aus Ägypten geführt haben! ");
INSERT INTO deu1951_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Als Aaron solches sah, baute er einen Altar vor demselben und ließ ausrufen und sprach: Morgen ist ein Fest für den HERRN! ");
INSERT INTO deu1951_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Da standen sie am Morgen früh auf und opferten Brandopfer und brachten dazu Dankopfer; darnach setzte sich das Volk nieder, um zu essen und zu trinken, und sie standen auf, um zu spielen. ");
INSERT INTO deu1951_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Da sprach der HERR zu Mose: Geh, steig hinab; denn dein Volk, das du aus Ägypten geführt hast, hat Verderben angerichtet! ");
INSERT INTO deu1951_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Sie sind eilends von dem Wege abgewichen, den ich ihnen geboten habe; sie haben sich ein gegossenes Kalb gemacht und haben es angebetet und ihm geopfert und gesagt: Das sind deine Götter, Israel, die dich aus Ägypten geführt haben! ");
INSERT INTO deu1951_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Und der HERR sprach zu Mose: Ich habe dieses Volk beobachtet, und siehe, es ist ein halsstarriges Volk. ");
INSERT INTO deu1951_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","So laß mich nun, daß mein Zorn über sie ergrimme und ich sie verzehre, so will ich dich zu einem großen Volk machen! ");
INSERT INTO deu1951_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mose aber besänftigte das Angesicht des HERRN, seines Gottes, und sprach: Ach HERR, warum will dein Zorn über dein Volk ergrimmen, das du mit so großer Kraft und starker Hand aus Ägypten geführt hast? ");
INSERT INTO deu1951_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Warum sollen die Ägypter sagen: Zum Unglück hat er sie ausgeführt, daß er sie im Gebirge erwürgte und von der Erde vertilgte? Kehre dich von dem Grimm deines Zorns und laß dich des Übels reuen, das du deinem Volk zugedacht hast! ");
INSERT INTO deu1951_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Gedenke deiner Diener, Abraham, Isaak und Israel, denen du bei dir selbst geschworen und zu denen du gesagt hast: Ich will euren Samen mehren wie die Sterne am Himmel, und dieses ganze Land, das ich versprochen habe, will ich eurem Samen geben, und sie sollen es ewiglich besitzen! ");
INSERT INTO deu1951_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Da reute den HERRN des Übels, das er seinem Volke anzutun gedroht hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose aber wandte sich und stieg vom Berg hinab und hatte die zwei Tafeln des Zeugnisses in seiner Hand; die waren auf beiden Seiten beschrieben. ");
INSERT INTO deu1951_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Und die Tafeln waren Gottes Werk, und die Schrift war Gottes Schrift, darein gegraben. ");
INSERT INTO deu1951_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Als nun Josua das Geschrei des Volkes hörte, das jauchzte, sprach er zu Mose: Es ist ein Kriegsgeschrei im Lager! ");
INSERT INTO deu1951_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Er aber antwortete: Man singt da weder von Sieg noch Niederlage, sondern ich höre einen Wechselgesang! ");
INSERT INTO deu1951_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Als er aber nahe zum Lager kam und das Kalb und den Reigen sah, entbrannte Moses Zorn, so daß er die Tafeln wegwarf und sie unten am Berg zerschmetterte. ");
INSERT INTO deu1951_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Und er nahm das Kalb, das sie gemacht hatten, und verbrannte es mit Feuer und zermalmte es zu Pulver und stäubte es auf das Wasser und gab es den Kindern Israel zu trinken. ");
INSERT INTO deu1951_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Zu Aaron aber sprach Mose: Was hat dir dieses Volk angetan, daß du eine so große Sünde über sie gebracht hast? ");
INSERT INTO deu1951_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Mein Herr lasse seinen Zorn nicht ergrimmen; du weißt, daß dieses Volk bösartig ist. ");
INSERT INTO deu1951_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Sie sprachen zu mir: Mache uns Götter, die uns vorangehen, denn wir wissen nicht, was aus diesem Mann Mose geworden ist, der uns aus Ägypten geführt hat. ");
INSERT INTO deu1951_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Da sprach ich zu ihnen: Wer Gold hat, der reiße es ab! Da gaben sie mir's, und ich warf es ins Feuer; daraus ist das Kalb geworden! ");
INSERT INTO deu1951_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Als nun Mose sah, daß das Volk zügellos geworden war (denn Aaron hatte ihm die Zügel schießen lassen, seinen Widersachern zum Spott), ");
INSERT INTO deu1951_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","stellte er sich unter das Tor des Lagers und sprach: Her zu mir, wer dem HERRN angehört! Da sammelten sich zu ihm alle Kinder Levis. ");
INSERT INTO deu1951_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Und er sprach zu ihnen: So spricht der HERR, der Gott Israels: Gürte jeder sein Schwert an seine Lenden und gehet hin und her, von einem Tor zum andern im Lager, und erwürge ein jeder seinen Bruder, seinen Freund und seinen Nächsten! ");
INSERT INTO deu1951_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Die Kinder Levis taten, wie ihnen Mose gesagt hatte, so daß an demselben Tage vom Volke bei dreitausend Männer fielen. ");
INSERT INTO deu1951_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Und Mose sprach: Füllet heute eure Hände dem HERRN, ein jeder für seinen Sohn und für seinen Bruder, daß heute der Segen über euch gegeben werde! ");
INSERT INTO deu1951_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Am Morgen sprach Mose zum Volk: Ihr habt eine große Sünde getan! Und nun will ich zu dem HERRN hinaufsteigen, vielleicht kann ich Vergebung erlangen für eure Sünde. ");
INSERT INTO deu1951_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Als nun Mose wieder zum HERRN kam, sprach er: Ach, das Volk hat eine große Sünde getan, daß sie sich goldene Götter gemacht haben! ");
INSERT INTO deu1951_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Und nun vergib ihnen doch ihre Sünde; wo nicht, so tilge mich aus deinem Buch, das du geschrieben hast! ");
INSERT INTO deu1951_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Der HERR sprach zu Mose: Ich will den aus meinem Buche tilgen, der an mir sündigt! ");
INSERT INTO deu1951_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","So gehe nun hin und führe das Volk dahin, wovon ich dir gesagt habe. Siehe, mein Engel soll vor dir hergehen. Aber am Tage meiner Heimsuchung will ich ihre Sünde an ihnen heimsuchen! ");
INSERT INTO deu1951_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Also plagte der HERR das Volk wegen dessen, was sie mit dem Kalb getan, welches Aaron gemacht hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Der HERR sprach zu Mose: Gehe hin, ziehe von dannen, du und das Volk, das du aus Ägypten geführt hast, in das Land, das ich Abraham, Isaak und Jakob geschworen und von dem ich gesagt habe: Deinem Samen will ich es geben! ");
INSERT INTO deu1951_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ich aber will einen Engel vor dir hersenden und die Kanaaniter, Amoriter, Hetiter, Pheresiter, Heviter und Jebusiter ausstoßen ");
INSERT INTO deu1951_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","in das Land, das von Milch und Honig fließt; denn ich will nicht mit dir hinaufziehen, weil du ein halsstarriges Volk bist; ich würde dich sonst unterwegs verzehren. ");
INSERT INTO deu1951_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Als das Volk diese harte Rede hörte, trug es Leid, und niemand legte seinen Schmuck an. ");
INSERT INTO deu1951_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Und der HERR sprach zu Mose: Sage den Kindern Israel: Ihr seid ein halsstarriges Volk! Wenn ich nur einen Augenblick in deiner Mitte hinaufzöge, müßte ich dich vertilgen. Und nun lege deinen Schmuck von dir, so will ich sehen, was ich dir tun will! ");
INSERT INTO deu1951_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Da rissen die Kinder Israel ihren Schmuck von sich ab beim Berge Horeb. ");
INSERT INTO deu1951_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose aber nahm die Hütte und schlug sie draußen auf, ferne von dem Lager, und hieß sie eine Hütte der Zusammenkunft. Und wer den HERRN fragen wollte, mußte vor das Lager hinaus zur Hütte der Zusammenkunft gehen. ");
INSERT INTO deu1951_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Und wenn Mose zu der Hütte hinausging, so stand alles Volk auf, und jedermann blieb stehen unter der Tür seines Zeltes und sah Mose nach, bis er in die Hütte hineinging. ");
INSERT INTO deu1951_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Und wenn Mose in die Hütte hineinging, so kam die Wolkensäule herab und stand in der Tür der Hütte, und der HERR redete mit Mose. ");
INSERT INTO deu1951_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Und wenn alles Volk die Wolkensäule in der Tür stehen sah, so standen sie alle auf und verneigten sich, ein jeder in der Tür seines Zeltes. ");
INSERT INTO deu1951_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Der HERR aber redete mit Mose von Angesicht zu Angesicht, wie ein Mann mit seinem Freunde redet; und wenn er wieder ins Lager zurückkehrte, so wich sein Diener Josua, der Sohn Nuns, der Jüngling, nicht aus der Hütte. ");
INSERT INTO deu1951_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Und Mose sprach zum HERRN: Siehe, du sprichst zu mir: Führe das Volk hinauf; und du lässest mich nicht wissen, wen du mit mir senden willst, und doch hast du gesagt: Ich kenne dich mit Namen, und du hast Gnade vor meinen Augen gefunden. ");
INSERT INTO deu1951_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Habe ich nun vor deinen Augen Gnade gefunden, so laß mich doch deinen Weg wissen und dich erkennen, damit ich vor deinen Augen Gnade finde; und siehe doch das an, daß dieses Volk dein Volk ist! ");
INSERT INTO deu1951_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Er sprach: Soll ich selbst gehen und dich zur Ruhe führen? ");
INSERT INTO deu1951_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Er sprach zu ihm: Wenn du nicht selbst mitgehst, so führe uns nicht von hier hinauf! ");
INSERT INTO deu1951_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Denn woran soll doch erkannt werden, daß ich und dein Volk vor deinen Augen Gnade gefunden haben, als daran, daß du mit uns gehst, so daß ich und dein Volk ausgezeichnet werden vor allem Volk, das auf dem Erdboden ist? ");
INSERT INTO deu1951_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Der HERR sprach zu Mose: Was du jetzt gesagt hast, das will ich auch tun; denn du hast vor meinen Augen Gnade gefunden, und ich kenne dich mit Namen! ");
INSERT INTO deu1951_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Er aber sprach: So laß mich deine Herrlichkeit sehen! ");
INSERT INTO deu1951_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Und er sprach: Ich will vor deinem Angesicht alle meine Güte vorüberziehen lassen und will den Namen des HERRN vor dir ausrufen; und wem ich gnädig bin, dem bin ich gnädig, und wessen ich mich erbarme, dessen erbarme ich mich; ");
INSERT INTO deu1951_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","aber mein Angesicht (sprach er) kannst du nicht sehen, denn kein Mensch wird leben, der mich sieht! ");
INSERT INTO deu1951_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Doch sprach der HERR: Siehe, es ist ein Ort bei mir, da sollst du auf dem Felsen stehen. ");
INSERT INTO deu1951_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Wenn dann meine Herrlichkeit vorübergeht, so stelle ich dich in die Felsenkluft und will dich mit meiner Hand solange decken, bis ich vorübergegangen bin. ");
INSERT INTO deu1951_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Wenn ich dann meine Hand zurückziehe, so magst du mir hinten nachsehen; aber mein Angesicht soll man nicht sehen! ");
INSERT INTO deu1951_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Und der HERR sprach zu Mose: Haue dir zwei steinerne Tafeln, wie die ersten waren, daß ich die Worte darauf schreibe, die auf den ersten Tafeln waren, welche du zerbrochen hast, ");
INSERT INTO deu1951_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","und sei morgen bereit, daß du früh auf den Berg Sinai steigest und daselbst zu mir auf die Spitze des Berges tretest. ");
INSERT INTO deu1951_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Und laß niemand mit dir hinaufsteigen, daß niemand um den ganzen Berg her gesehen werde; laß auch keine Schafe noch Rinder gegen diesen Berg weiden! ");
INSERT INTO deu1951_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Und Mose machte zwei steinerne Tafeln, wie die ersten waren, und stand am Morgen früh auf und stieg auf den Berg Sinai, wie ihm der HERR geboten hatte, und nahm die zwei steinernen Tafeln in seine Hand. ");
INSERT INTO deu1951_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Da kam der HERR herab in einer Wolke und trat daselbst zu ihm und rief den Namen des HERRN aus. ");
INSERT INTO deu1951_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Und als der HERR vor seinem Angesicht vorüberging, rief er: Der HERR, der HERR, der starke Gott, der barmherzig und gnädig ist, langsam zum Zorn und von großer Gnade und Treue; ");
INSERT INTO deu1951_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","welcher Tausenden Gnade bewahrt und Missetat, Übertretung und Sünde vergibt, aber keineswegs ungestraft läßt, sondern heimsucht der Väter Missetat an den Kindern und Kindeskindern bis in das dritte und vierte Glied! ");
INSERT INTO deu1951_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Da neigte sich Mose eilends zur Erde, betete an und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","O Herr, habe ich vor deinen Augen Gnade gefunden, so ziehe mein Herr mitten unter uns, wiewohl es ein halsstarriges Volk ist; du aber wollest unserer Missetat und Sünde gnädig sein und uns zum Erbteil annehmen! ");
INSERT INTO deu1951_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Da sprach er: Siehe, ich mache einen Bund: vor deinem ganzen Volk will ich Wunder tun, dergleichen nicht geschehen sind in allen Ländern und unter allen Völkern; und das ganze Volk, darunter du bist, soll das Werk des HERRN sehen; denn wunderbar soll es sein, was ich mit dir tun will. ");
INSERT INTO deu1951_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hüte dich vor dem, was ich dir heute verbiete! Siehe, ich will vor dir her ausstoßen die Amoriter, Kanaaniter, Hetiter, Pheresiter, Heviter und Jebusiter. ");
INSERT INTO deu1951_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Hüte dich, mit den Einwohnern des Landes, in das du kommst, einen Bund zu machen, daß sie dir zum Fallstrick werden in deiner Mitte; ");
INSERT INTO deu1951_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","sondern ihr sollt ihre Altäre umstürzen und ihre Säulen zerbrechen und ihre Astartenbilder ausrotten. ");
INSERT INTO deu1951_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Denn du sollst keinen andern Gott anbeten. Denn der HERR heißt ein Eiferer und ist ein eifersüchtiger Gott. ");
INSERT INTO deu1951_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Daß du nicht etwa mit den Einwohnern des Landes einen Bund machest, und wenn sie ihren Göttern nachbuhlen und ihren Göttern opfern, sie dich einladen und du von ihrem Opfer essest, ");
INSERT INTO deu1951_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","und nehmest deinen Söhnen ihre Töchter zu Weibern und dieselben alsdann ihren Göttern nachbuhlen und machen, daß deine Söhne auch ihren Göttern nachbuhlen. ");
INSERT INTO deu1951_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Du sollst dir keine gegossenen Göttern machen. ");
INSERT INTO deu1951_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Das Fest der ungesäuerten Brote sollst du halten. Sieben Tage lang sollst du ungesäuertes Brot essen, wie ich dir geboten habe, um die bestimmte Zeit des Monats Abib; denn im Monat Abib bist du aus Ägypten gezogen. ");
INSERT INTO deu1951_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Alle Erstgeburt ist mein, auch alle männliche Erstgeburt unter deinem Vieh, es sei ein Ochs oder ein Schaf. ");
INSERT INTO deu1951_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Aber den Erstling des Esels sollst du mit einem Schafe lösen; wenn du ihn aber nicht lösest, so brich ihm das Genick. Alle Erstgeburt deiner Söhne sollst du lösen. Man soll nicht leer erscheinen vor meinem Angesicht. ");
INSERT INTO deu1951_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sechs Tage sollst du arbeiten, aber am siebenten Tage sollst du ruhen; mit Pflügen und Ernten sollst du ruhen. ");
INSERT INTO deu1951_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Das Fest der Wochen sollst du halten, mit den Erstlingen der Weizenernte und das Fest der Einsammlung, wenn das Jahr vergangen ist. ");
INSERT INTO deu1951_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Alles, was männlich ist, soll dreimal im Jahr vor dem Herrscher, dem HERRN, dem Gott Israels, erscheinen. ");
INSERT INTO deu1951_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Wenn ich die Heiden vor dir ausstoßen und deine Landmarken erweitern werde, soll niemand deines Landes begehren, während du hinaufgehst, um dreimal im Jahr zu erscheinen vor dem HERRN, deinem Gott. ");
INSERT INTO deu1951_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Du sollst das Blut meines Opfers nicht neben dem Sauerteig opfern. Und das Opfer des Passahfestes soll nicht über Nacht bis zum Morgen bleiben. ");
INSERT INTO deu1951_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Die Erstlinge von den ersten Früchten deines Ackers sollst du in das Haus des HERRN, deines Gottes, bringen. Du sollst das Böcklein nicht in der Milch seiner Mutter kochen. ");
INSERT INTO deu1951_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Und der HERR sprach zu Mose: Schreibe diese Worte; denn nach diesen Worten habe ich mit dir und mit Israel einen Bund gemacht. ");
INSERT INTO deu1951_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Und er war daselbst bei dem HERRN vierzig Tage und vierzig Nächte lang und aß kein Brot und trank kein Wasser. Und er schrieb auf die Tafeln die Worte des Bundes, die zehn Worte. ");
INSERT INTO deu1951_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Als nun Mose vom Berge Sinai hinabstieg und die beiden Tafeln des Zeugnisses in der Hand hielt, als er vom Berge herabstieg, da wußte er nicht, daß die Haut seines Angesichts strahlte davon, daß er mit Ihm geredet hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Und Aaron und alle Kinder Israel sahen Mose, und siehe, die Haut seines Angesichtes strahlte; da fürchteten sie sich, ihm zu nahen. ");
INSERT INTO deu1951_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Aber Mose rief sie; da wandten sie sich zu ihm, Aaron und alle Obersten der Gemeinde; und Mose redete mit ihnen. ");
INSERT INTO deu1951_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Darnach traten alle Kinder Israel näher zu ihm. Und er befahl ihnen alles, was der HERR mit ihm auf dem Berge Sinai geredet hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Als nun Mose aufhörte mit ihnen zu reden, legte er eine Decke auf sein Angesicht. ");
INSERT INTO deu1951_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Und wenn Mose hineinging vor den HERRN, mit ihm zu reden, tat er die Decke ab, bis er wieder herausging. Und er ging heraus und redete mit den Kindern Israel, was ihm befohlen war. ");
INSERT INTO deu1951_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Und die Kinder Israel sahen das Angesicht Moses, daß die Haut desselben strahlte, und Mose tat die Decke wieder auf sein Angesicht, bis er wieder hineinging, mit Ihm zu reden. ");
INSERT INTO deu1951_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Und Mose versammelte die ganze Gemeinde der Kinder Israel und sprach zu ihnen: Das sind die Worte, die der HERR geboten hat, daß ihr sie tun sollt: ");
INSERT INTO deu1951_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sechs Tage soll gearbeitet werden, aber der siebente Tag soll euch heilig sein, zu feiern die Sabbatruhe des HERRN. Wer da Arbeit verrichtet, der soll sterben. ");
INSERT INTO deu1951_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Am Sabbattag sollt ihr in allen euren Wohnungen kein Feuer anzünden! ");
INSERT INTO deu1951_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose redete weiter mit der ganzen Gemeinde der Kinder Israel und sprach: Das ist's, was der HERR geboten hat: ");
INSERT INTO deu1951_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Bringt aus eurer Mitte Gaben für den HERRN; jeder, den sein Herz dazu treibt, der soll sie bringen, die Gabe des HERRN, nämlich Gold, Silber und Erz, ");
INSERT INTO deu1951_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Stoffe von blauem und rotem Purpur und Karmesinfarbe, feine weiße Baumwolle und Ziegenhaare, ");
INSERT INTO deu1951_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","rötliche Widderfelle, Seehundsfelle und Akazienholz, ");
INSERT INTO deu1951_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","und Öl zum Leuchter und Spezerei zum Salböl und zu gutem Räucherwerk, ");
INSERT INTO deu1951_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Schohamsteine und Steine zum Besatz für das Ephod und das Brustschildlein. ");
INSERT INTO deu1951_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Und wer unter euch weisen Herzens ist, der komme und mache, was der HERR geboten hat: ");
INSERT INTO deu1951_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Die Wohnung mit ihrer Hütte, ihre Decke, ihre Bretter, ihre Riegel, ihre Säulen und ihre Füße; ");
INSERT INTO deu1951_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","die Lade mit ihren Stangen, den Sühndeckel und den Vorhang; ");
INSERT INTO deu1951_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","den Tisch mit seinen Stangen und allem seinem Gerät und die Schaubrote; ");
INSERT INTO deu1951_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","den Leuchter zur Beleuchtung samt seinen Geräten und Lampen und das Öl des Leuchters; ");
INSERT INTO deu1951_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","den Räucheraltar mit seinen Stangen, das Salböl und die Spezerei zum Räucherwerk, den Vorhang der Tür beim Eingang der Wohnung; ");
INSERT INTO deu1951_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","den Brandopferaltar mit seinem ehernen Gitter, mit seinen Stangen und allem seinem Gerät, das Becken mit seinem Fuß; ");
INSERT INTO deu1951_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","die Vorhänge des Vorhofs mit seinen Säulen und Füßen, und den Vorhang des Tors am Vorhof; ");
INSERT INTO deu1951_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","die Nägel der Wohnung und des Vorhofs mit ihren Seilen; ");
INSERT INTO deu1951_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","die Amtskleider zum Dienst im Heiligtum, die heiligen Kleider Aarons, des Priesters, und die Kleider seiner Söhne zum Priestertum. ");
INSERT INTO deu1951_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Da ging die ganze Gemeinde der Kinder Israel von Mose hinweg. ");
INSERT INTO deu1951_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Und ein jeder, dessen Geist willig war, kam und brachte dem HERRN Gaben für das Werk der Stiftshütte und all ihren Dienst und für die heiligen Kleider. ");
INSERT INTO deu1951_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Es kamen aber die Männer samt den Frauen, alle die willigen Herzens waren, und brachten Nasenringe, Ohrringe, Fingerringe, Armbänder und allerlei goldene Geräte; alle, die dem HERRN Gold zum Webopfer brachten. ");
INSERT INTO deu1951_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Und wer bei sich Stoffe fand von blauem und rotem Purpur und Karmesinfarbe, feine weiße Baumwolle, Ziegenhaare, rötliche Widderfelle und Seehundsfelle, der brachte es. ");
INSERT INTO deu1951_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Und wer Silber und Erz hatte, der brachte es dem HERRN zum Hebopfer. Und wer Akazienholz bei sich fand, der brachte es zu allerlei Werk des Dienstes. ");
INSERT INTO deu1951_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Und alle Frauen, die weisen Herzens waren, spannen mit ihren Händen und brachten das Gesponnene, Stoffe von blauem und rotem Purpur und Karmesinfarbe und von feiner weißer Baumwolle. ");
INSERT INTO deu1951_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Und die Frauen, die ihr Herz dazu trieb und welche verständigen Sinnes waren, die spannen Ziegenhaare. ");
INSERT INTO deu1951_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Die Fürsten aber brachten Schohamsteine und eingefaßte Steine zum Brustschildlein, ");
INSERT INTO deu1951_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","und Spezerei und Öl für den Leuchter und für das Salböl und zu gutem Räucherwerk. ");
INSERT INTO deu1951_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Also brachten die Kinder Israel (alle Männer und Frauen, die willigen Herzens waren zu allerlei Werk beizutragen, das der HERR durch Mose zu machen befohlen hatte) dem HERRN freiwillige Gaben. ");
INSERT INTO deu1951_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Da sprach Mose zu den Kindern Israel: Seht, der HERR hat mit Namen berufen Bezaleel, den Sohn Uris, des Sohnes Hurs, vom Stamme Juda. ");
INSERT INTO deu1951_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Und der Geist Gottes hat ihn erfüllt mit Weisheit, Verstand und Geschicklichkeit für allerhand Arbeit; ");
INSERT INTO deu1951_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","auch daß er kunstreiche Arbeit erfinden kann zur Ausführung in Gold, Silber und Erz; ");
INSERT INTO deu1951_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","im Schneiden und Einsetzen der Edelsteine, im Zimmern des Holzes, um allerlei kunstvolle Arbeit zu machen. ");
INSERT INTO deu1951_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Auch hat er ihm ins Herz gegeben, daß er unterweisen kann; er und Oholiab, der Sohn Ahisamachs, vom Stamme Dan. ");
INSERT INTO deu1951_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Er hat sie mit weisen Herzen erfüllt, zu machen allerlei Werk eines Künstlers und Erfinders und Buntwirkers in Stoffen von blauem und rotem Purpur und Karmesinfarbe und von feiner weißer Baumwolle, und eines Webers, daß sie allerlei Werke machen und sinnreiche Arbeit erfinden. ");
INSERT INTO deu1951_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Da arbeiteten Bezaleel und Oholiab und alle Männer, die weisen Herzens waren, denen der HERR Weisheit und Verstand gegeben hatte, zu wissen, wie sie allerlei Werke machen sollten zum Dienste des Heiligtums, nach allem dem, was der HERR geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Und Mose rief Bezaleel und Oholiab und alle Männer, die weisen Herzens waren, denen der HERR Weisheit ins Herz gegeben hatte, auch alle, die ihr Herz dazu trieb, daß sie hinzutraten, um an dem Werke zu arbeiten. ");
INSERT INTO deu1951_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Und sie empfingen von Mose alle Gaben, welche die Kinder Israel brachten zu dem Werke des Dienstes am Heiligtum, daß es gemacht werde; und sie brachten immer noch alle Morgen ihre freiwilligen Gaben. ");
INSERT INTO deu1951_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Da kamen alle Weisen, die am Werke des Heiligtums arbeiteten, ein jeder von seiner Arbeit, die sie machten, ");
INSERT INTO deu1951_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","und redeten mit Mose und sprachen: Das Volk bringt zu viel, mehr als zum Werke dieses Dienstes notwendig ist, das der HERR zu machen geboten hat! ");
INSERT INTO deu1951_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Da gebot Mose, daß man durch das Lager ausrufen und sagen ließe: Niemand, es sei Mann oder Weib, soll mehr etwas anfertigen zur Abgabe an das Heiligtum! Also ward dem Volke gewehrt zu bringen; ");
INSERT INTO deu1951_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","denn des Stoffes war genug und noch übrig zu allerlei Werk, das zu machen war. ");
INSERT INTO deu1951_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","So machten nun alle Männer, die weisen Herzens waren unter den Arbeitern am Werke, die Wohnung, zehn Teppiche von gezwirnter weißer Baumwolle, aus Stoffen von blauem und rotem Purpur und Karmesinfarbe, mit Cherubim künstlich durchwirkt! ");
INSERT INTO deu1951_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Die Länge eines Teppichs war achtundzwanzig Ellen und seine Breite vier Ellen, und sie hatten alle einerlei Maß. ");
INSERT INTO deu1951_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Und er heftete je fünf Teppiche zusammen, einen an den andern. ");
INSERT INTO deu1951_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Und er machte Schleifen von blauem Purpur am Ende der beiden Teppiche, am Ende, da sie zusammengefügt wurden. ");
INSERT INTO deu1951_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Fünfzig Schleifen machte er an jedem Teppich, damit eine die andere faßte. ");
INSERT INTO deu1951_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Und er machte fünfzig goldene Haften und fügte die Teppiche mit den Haften zusammen, einen an den andern, so daß die Wohnung ein Ganzes wurde. ");
INSERT INTO deu1951_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Und er machte elf Teppiche von Ziegenhaaren zum Zelte über die Wohnung. ");
INSERT INTO deu1951_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dreißig Ellen lang und vier Ellen breit war jeder Teppich, alle elf nach einem Maß; ");
INSERT INTO deu1951_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","und er fügte fünf besonders zusammen und sechs besonders, ");
INSERT INTO deu1951_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","und machte je fünfzig Schleifen am Ende eines jeden Teppichs, damit sie zusammengeheftet würden. ");
INSERT INTO deu1951_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Dazu machte er fünfzig eherne Haften, damit die Decke zu einem Ganzen zusammengefügt würde. ");
INSERT INTO deu1951_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Und machte über die Hütte eine Decke von rötlichen Widderfellen und darüber noch eine Decke von Seehundsfellen. ");
INSERT INTO deu1951_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Er machte auch Bretter zu der Wohnung von Akazienholz, aufrechtstehend. ");
INSERT INTO deu1951_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Zehn Ellen lang und anderthalb Ellen breit war ein jedes; ");
INSERT INTO deu1951_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","und an jedem zwei Zapfen, einer dem andern gegenüberstehend; also tat er mit allen Brettern zu der Wohnung. ");
INSERT INTO deu1951_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Er machte aber die Bretter zur Wohnung also, daß zwanzig derselben auf der Seite gegen Mittag standen; ");
INSERT INTO deu1951_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","und machte vierzig silberne Füße unter die zwanzig Bretter, unter ein jedes Brett zwei Füße für die beiden Zapfen. ");
INSERT INTO deu1951_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Desgleichen zur andern Seite der Wohnung, gegen Mitternacht, machte er auch zwanzig Bretter ");
INSERT INTO deu1951_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","und vierzig silberne Füße, unter ein jedes Brett zwei Füße. ");
INSERT INTO deu1951_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Aber hinten an der Wohnung, gegen Abend, machte er sechs Bretter, ");
INSERT INTO deu1951_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","und zwei andere hinten an den beiden Ecken der Wohnung. ");
INSERT INTO deu1951_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Diese waren also doppelt von unten auf, und oben zusammengefügt mit einem Ringe: Also machte er sie beide, an beiden Ecken, ");
INSERT INTO deu1951_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","so daß acht Bretter wurden und sechzehn silberne Füße, unter jedem Brett zwei Füße. ");
INSERT INTO deu1951_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Und er machte Riegel von Akazienholz, fünf zu den Brettern auf einer Seite der Wohnung, ");
INSERT INTO deu1951_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","und fünf auf der andern Seite derselben, und fünf hinten, gegen Abend. ");
INSERT INTO deu1951_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Und machte den Mittelriegel, daß er inwendig durch die Bretter hindurchging von einem Ende zum andern, ");
INSERT INTO deu1951_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","und er überzog die Bretter mit Gold; auch die Ringe für die Riegel machte er von Gold, und er überzog die Riegel mit Gold. ");
INSERT INTO deu1951_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Und machte den Vorhang aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und gezwirnter weißer Baumwolle, und machte Cherubim daran, künstlich gewirkt. ");
INSERT INTO deu1951_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Und machte zu denselben vier Säulen von Akazienholz und überzog sie mit Gold, und machte ihre Haken von Gold, und goß dazu vier silberne Füße. ");
INSERT INTO deu1951_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Und machte einen Vorhang für die Tür der Hütte aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und von gezwirnter weißer Baumwolle, in Buntwirkerarbeit, ");
INSERT INTO deu1951_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","und fünf Säulen dazu mit ihren Haken, und überzog ihre Köpfe und ihre Querstangen mit Gold, und machte fünf eherne Füße dazu. ");
INSERT INTO deu1951_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Und Bezaleel machte die Lade von Akazienholz, dreieinhalb Ellen lang und anderthalb Ellen breit und anderthalb Ellen hoch, ");
INSERT INTO deu1951_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","und überzog sie mit reinem Gold inwendig und auswendig, und machte ihr einen goldenen Kranz ringsum. ");
INSERT INTO deu1951_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Und goß vier goldene Ringe an ihre vier Ecken, auf jeder Seite zwei. ");
INSERT INTO deu1951_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Und machte Stangen von Akazienholz und überzog sie mit Gold ");
INSERT INTO deu1951_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","und tat sie in die Ringe an den Seiten der Lade, daß man sie tragen konnte. ");
INSERT INTO deu1951_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Und machte den Sühndeckel von reinem Golde, dreieinhalb Ellen lang und anderthalb Ellen breit. ");
INSERT INTO deu1951_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Und machte zwei Cherubim von getriebenem Gold an die beiden Enden des Sühndeckels, ");
INSERT INTO deu1951_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","einen Cherub an diesem Ende und den andern an jenem Ende; zwei Cherubim machte er an beiden Enden des Sühndeckels. ");
INSERT INTO deu1951_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Und die Cherubim breiteten ihre Flügel aus von oben her und deckten damit den Sühndeckel, und ihre Angesichter waren einander zugekehrt und sahen auf den Sühndeckel. ");
INSERT INTO deu1951_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Und er machte den Tisch von Akazienholz zwei Ellen lang, eine Elle breit und anderthalb Ellen hoch, ");
INSERT INTO deu1951_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","und überzog ihn mit reinem Gold und machte ihm einen goldenen Kranz ringsum, ");
INSERT INTO deu1951_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","und machte ihm eine Leiste ringsum, eine Handbreit hoch, und machte einen goldenen Kranz um die Leiste her, ");
INSERT INTO deu1951_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","und goß dazu vier goldene Ringe und tat sie an die vier Ecken, an seine vier Füße, ");
INSERT INTO deu1951_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","dicht unter die Leiste, daß man die Stangen darein tun und so den Tisch tragen konnte. ");
INSERT INTO deu1951_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Und machte die Stangen von Akazienholz und überzog sie mit Gold, um den Tisch damit zu tragen. ");
INSERT INTO deu1951_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Und machte auch von reinem Golde die Geräte auf dem Tisch, seine Schüsseln, seine Schalen, seine Becher und seine Kannen, um mit ihnen Trankopfer zu spenden. ");
INSERT INTO deu1951_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Und er machte den Leuchter von reinem getriebenem Gold, daran war der Schaft mit Armen, Kelchen, Knoten und Blumen. ");
INSERT INTO deu1951_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Sechs Arme gingen von seinen Seiten aus, von jeder Seite drei Arme. ");
INSERT INTO deu1951_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","An jedem Arm waren drei Kelche wie Mandelblüten, dazu ihre Knoten und Blumen; auf diese Weise gingen die sechs Arme aus dem Leuchter hervor. ");
INSERT INTO deu1951_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","An dem Schaft aber waren vier Kelche wie Mandelblüten mit Knoten und Blumen, ");
INSERT INTO deu1951_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","unter je zwei Armen ein Knoten, bei allen sechs Armen, die aus dem Leuchter gingen. ");
INSERT INTO deu1951_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ihre Knoten und Arme gingen aus ihm hervor, und es war alles getriebenes reines Gold. ");
INSERT INTO deu1951_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Er machte auch sieben Lampen mit ihren Lichtscheren und Pfannen von reinem Gold. ");
INSERT INTO deu1951_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Aus einem Zentner reinen Goldes machte er ihn und alle seine Geräte. ");
INSERT INTO deu1951_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Er machte auch den Räucheraltar von Akazienholz, eine Elle lang und eine Elle breit, viereckig, und zwei Ellen hoch mit seinen Hörnern, die aus ihm hervorgingen, ");
INSERT INTO deu1951_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","und überzog ihn mit reinem Golde, seine Platte und seine Wände ringsum und seine Hörner und machte ihm einen Kranz ringsum von reinem Gold; ");
INSERT INTO deu1951_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","und zwei goldene Ringe unter dem Kranz zu beiden Seiten, daß man Stangen darein tue, um ihn zu tragen. ");
INSERT INTO deu1951_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Aber die Stangen machte er von Akazienholz und überzog sie mit Gold. ");
INSERT INTO deu1951_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","und er machte das heilige Salböl und Räucherwerk von reiner Spezerei, nach der Kunst des Salbenbereiters. ");
INSERT INTO deu1951_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Darnach machte er auch den Brandopferaltar von Akazienholz, fünf Ellen lang und fünf Ellen breit, viereckig, und drei Ellen hoch. ");
INSERT INTO deu1951_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Und machte vier Hörner, die aus ihm hervorgingen an seinen vier Ecken, und überzog ihn mit Erz. ");
INSERT INTO deu1951_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Und machte alle Geräte zu dem Altar, Aschentöpfe, Schaufeln, Becken, Gabeln und Kohlenpfannen: alles machte er von Erz. ");
INSERT INTO deu1951_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Und machte am Altar ein Gitter, wie ein Netz, von Erz, unter seiner Einfassung, von unten auf bis zur halben Höhe des Altars, ");
INSERT INTO deu1951_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","und goß vier Ringe an die vier Enden des ehernen Gitters zur Aufnahme der Stangen. ");
INSERT INTO deu1951_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Dieselben machte er von Akazienholz und überzog sie mit Erz ");
INSERT INTO deu1951_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","und tat sie in die Ringe an den Seiten des Altars, daß man ihn damit trage. Und er machte ihn hohl, von Brettern. ");
INSERT INTO deu1951_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Und er machte das Becken von Erz und seinen Fuß auch von Erz, aus den Spiegeln der dienenden Weiber, die vor der Tür der Stiftshütte Frondienst taten. ");
INSERT INTO deu1951_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Und er machte einen Vorhof: Auf der rechten Seite, gegen Mittag, einen Vorhang dazu, hundert Ellen lang, von gezwirnter weißer Baumwolle, ");
INSERT INTO deu1951_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","mit seinen zwanzig Säulen und zwanzig Füßen von Erz; aber ihre Haken und Querstangen von Silber; ");
INSERT INTO deu1951_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","desgleichen gegen Mitternacht hundert Ellen mit zwanzig Säulen und zwanzig Füßen von Erz; aber ihre Haken und Querstangen von Silber; ");
INSERT INTO deu1951_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","gegen Abend aber fünfzig Ellen mit zehn Säulen und zehn Füßen; und ihre Haken und Querstangen von Silber; ");
INSERT INTO deu1951_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","gegen Morgen aber fünfzig Ellen, ");
INSERT INTO deu1951_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","fünfzehn Ellen auf der einen Seite mit ihren drei Säulen und drei Füßen, ");
INSERT INTO deu1951_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","und fünfzehn Ellen auf der andern Seite, also daß auf beiden Seiten des Tores am Vorhof gleichviele waren, drei Säulen und drei Füße. ");
INSERT INTO deu1951_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Es waren aber alle Vorhänge des Vorhofs ringsum von gezwirnter weißer Baumwolle, ");
INSERT INTO deu1951_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","und die Füße der Säulen von Erz und ihre Haken und Querstangen von Silber und ihre Köpfe mit Silber überzogen; die Querstangen waren silbern an allen Säulen des Vorhofs. ");
INSERT INTO deu1951_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Und den Vorhang im Tore des Vorhofs machte er in Buntwirkerarbeit aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und von gezwirnter weißer Baumwolle, zwanzig Ellen lang und fünf Ellen hoch in der Breite, nach dem Maße der Vorhänge des Vorhofs; ");
INSERT INTO deu1951_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","dazu vier Säulen und vier Füße von Erz, und ihre Haken von Silber und ihre Köpfe überzogen und ihre Querstangen silbern; ");
INSERT INTO deu1951_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","und alle Nägel der Wohnung und des Vorhofs ringsum waren von Erz. ");
INSERT INTO deu1951_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Dies ist die Berechnung der Kosten der Wohnung, der Wohnung des Zeugnisses, welche auf Befehl Moses gemacht wurde, mit Hilfe der Leviten durch die Hand Itamars, des Sohnes Aarons, des Priesters, ");
INSERT INTO deu1951_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","nachdem Bezaleel, der Sohn Uris, des Sohns Hurs, vom Stamme Juda, alles gemacht, wie der HERR Mose geboten hatte; ");
INSERT INTO deu1951_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","und mit ihm Oholiab, der Sohn Ahisamachs, vom Stamme Dan, ein Meister im Steinschneiden, in künstlicher Arbeit und im Buntwirken von Stoffen von blauem und rotem Purpur und Karmesinfarbe und in feiner weißer Baumwolle. ");
INSERT INTO deu1951_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Alles Gold, das verarbeitet wurde in diesem ganzen Werke des Heiligtums, das zum Webopfer gegeben ward, betrug neunundzwanzig Zentner und siebenhundertdreißig Schekel, nach dem Schekel des Heiligtums. ");
INSERT INTO deu1951_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Das Silber aber von den Gezählten der Gemeinde war hundert Zentner und 1775 Schekel, nach dem Schekel des Heiligtums. ");
INSERT INTO deu1951_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","So manches Haupt, so mancher halbe Schekel, nach dem Schekel des Heiligtums, von allen, die gezählt wurden, von zwanzig Jahren an und darüber, 603550 Mann. ");
INSERT INTO deu1951_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Aus den hundert Zentnern Silber goß man die Füße des Heiligtums und die Füße des Vorhangs, hundert Füße aus hundert Zentnern, je einen Zentner zu einem Fuß. ");
INSERT INTO deu1951_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Aber aus den 1775 Schekeln wurden die Haken der Säulen gemacht und ihre Köpfe überzogen und mit ihren Querstangen verbunden. ");
INSERT INTO deu1951_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Das Webopfer aber des Erzes war siebzig Zentner und zweitausendvierhundert Schekel. ");
INSERT INTO deu1951_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Daraus wurden die Füße der Tür der Hütte des Zeugnisses gemacht, und der eherne Altar und das eherne Gitter daran und alle Geräte des Altars; ");
INSERT INTO deu1951_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","dazu die Füße des Vorhofs ringsumher, und die Füße des Tors am Vorhof, alle Nägel der Wohnung und alle Nägel des Vorhofs ringsumher. ");
INSERT INTO deu1951_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Und aus den Stoffen von blauem und rotem Purpur und Karmesinfarbe machten sie die Amtstracht zum Dienst im Heiligtum und verfertigten die heiligen Kleider für Aaron, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Und er machte das Ephod von Gold und aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und von gezwirnter weißer Baumwolle. ");
INSERT INTO deu1951_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Das Gold aber schlugen sie dünn zu Blechen und schnitten es zu Fäden, daß man es künstlich wirken konnte in die Stoffe von blauem und rotem Purpur und Karmesinfarbe und von gezwirnter weißer Baumwolle. ");
INSERT INTO deu1951_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Sie machten auch Schulterstücke daran, um das Brustkleid an beiden Enden zu verbinden. ");
INSERT INTO deu1951_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Das künstliche Werk seines Gurts aber, womit man es gürtete, hing mit ihm zusammen und war von derselben Arbeit, von Gold, aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und gezwirnter weißer Baumwolle, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Und sie machten Schohamsteine, in Gold gefaßt, wie Siegel gestochen auf die Namen der Kinder Israel; ");
INSERT INTO deu1951_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","die hefteten sie auf die Schulterstücke des Brustkleides, daß sie Steine des Gedächtnisses wären für die Kinder Israel, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Sie machten auch das Brustschildlein, ein Kunstwerk, wie das Brustkleid von Gold, aus Stoffen von blauem und rotem Purpur und Karmesinfarbe und von gezwirnter weißer Baumwolle. ");
INSERT INTO deu1951_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Und machten dasselbe viereckig und doppelt gelegt, eine Spanne lang und eine Spanne breit. ");
INSERT INTO deu1951_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Und füllten es mit vier Reihen von Steinen: Die erste Reihe war ein Rubin, ein Topas und ein Smaragd; ");
INSERT INTO deu1951_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","die zweite Reihe ein Granat, ein Saphir und ein Diamant; ");
INSERT INTO deu1951_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","die dritte Reihe ein Opal, ein Achat und ein Amethyst; ");
INSERT INTO deu1951_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","die vierte Reihe ein Chrysolit, ein Schoham und ein Jaspis, bei ihrer Einsetzung in Gold gefaßt. ");
INSERT INTO deu1951_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Und die Steine lauteten nach den Namen der Kinder Israel; auf ihre zwölf Namen waren sie wie Siegel gestochen, ein jeder auf einen Namen der zwölf Stämme. ");
INSERT INTO deu1951_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Und sie machten an das Brustschildlein gewundene Ketten von geflochtener Arbeit von reinem Gold, ");
INSERT INTO deu1951_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","auch zwei goldene Einfassungen und zwei goldene Ringe, und setzten die beiden Ringe an die beiden Ecken des Brustschildleins. ");
INSERT INTO deu1951_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Und die beiden gewundenen goldenen Ketten taten sie in die beiden Ringe an den Ecken des Brustschildleins. ");
INSERT INTO deu1951_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Die beiden andern Enden aber der gewundenen Ketten taten sie an die beiden Einfassungen und setzten sie auf die beiden Schulterstücke des Ephod, einander gegenüber. ");
INSERT INTO deu1951_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Und sie machten zwei andere goldene Ringe und setzten sie an die beiden andern Ecken des Brustschildleins, nämlich an seinem Rande, welcher inwendig dem Ephod zugekehrt war. ");
INSERT INTO deu1951_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Noch zwei andere goldene Ringe machten sie, die taten sie auf die beiden Schulterstücke des Ephod, unterhalb, einander gegenüber, wo das Ephod zusammengeheftet wird, oberhalb des Gürtels des Ephod. ");
INSERT INTO deu1951_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Und sie banden das Brustschildlein mit seinen Ringen an die Ringe des Ephod mit einer Schnur von blauem Purpur, daß es auf dem Ephod hart anlag und sich nicht von dem Ephod losmachte; wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Desgleichen machte er den Rock des Ephod, ganz von blauem Purpur gewoben; ");
INSERT INTO deu1951_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","und seine Öffnung oben mitten darin, und einen Saum um die Öffnung, wie den Saum eines Panzers, daß sie nicht zerreiße. ");
INSERT INTO deu1951_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Und sie machten an seinem untern Saum Granatäpfel, aus Stoffen von blauem und rotem Purpur und Karmesinfarbe gezwirnt. ");
INSERT INTO deu1951_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Und machten Schellen von reinem Gold; die taten sie zwischen die Granatäpfel ringsum an den Saum des Rockes, ");
INSERT INTO deu1951_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","je einen Granatapfel und eine Schelle, ringsum, um darin zu dienen, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Und sie machten auch die Leibröcke, von weißer Baumwolle gezwirnt, für Aaron und seine Söhne, ");
INSERT INTO deu1951_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","und den Kopfbund von weißer Baumwolle und die hohen Mützen von weißer Baumwolle und die Unterkleider von gezwirnter weißer Baumwolle; ");
INSERT INTO deu1951_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","und den Gürtel von gezwirnter weißer Baumwolle und aus Stoffen von blauem und rotem Purpur und Karmesinfarbe, Arbeit des Buntwirkers, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Sie machten auch das Stirnblatt, das heilige Diadem, von reinem Gold und schrieben darauf in gestochener Siegelschrift: Heilig dem HERRN! ");
INSERT INTO deu1951_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Und banden eine Schnur von blauem Purpur daran, um es oben am Hut zu befestigen, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Also ward das ganze Werk der Wohnung, der Stiftshütte, vollendet. Und die Kinder Israel machten alles, wie der HERR Mose geboten hatte; so machten sie es. ");
INSERT INTO deu1951_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Und sie brachten die Wohnung zu Mose, die Hütte und alle ihre Geräte, ihre Haften, Bretter, Riegel, Säulen, Füße; ");
INSERT INTO deu1951_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","die Decke von rötlichen Widderfellen, die Decke von Seehundsfellen und den Vorhang der Decke; ");
INSERT INTO deu1951_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","die Lade des Zeugnisses mit ihren Stangen, den Sühndeckel; ");
INSERT INTO deu1951_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","den Tisch und alle seine Geräte und die Schaubrote; ");
INSERT INTO deu1951_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","den Leuchter von reinem Golde, seine Lampen, die geordneten Lampen und alle seine Geräte und das Öl des Leuchters; ");
INSERT INTO deu1951_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","den goldenen Altar, das Salböl, das gute Räucherwerk und den Vorhang zu der Tür der Hütte; ");
INSERT INTO deu1951_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","den ehernen Altar und sein ehernes Gitter mit seinen Stangen und allen seinen Geräten, das Becken samt seinem Fuß; ");
INSERT INTO deu1951_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","die Vorhänge des Vorhofs mit seinen Säulen und Füßen, den Vorhang im Tor des Vorhofs mit seinen Seilen und Nägeln und allen Geräten zum Dienst der Wohnung, der Stiftshütte; ");
INSERT INTO deu1951_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","die Amtstracht zum Dienst im Heiligtum, die heiligen Kleider des Priesters Aaron und die Kleider seiner Söhne, um das Priesteramt zu verwalten; ");
INSERT INTO deu1951_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ganz, wie der HERR Mose geboten hatte, so hatten die Kinder Israel das Werk vollbracht. ");
INSERT INTO deu1951_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Und Mose sah die ganze Arbeit an, und siehe, sie hatten dieselbe gemacht, wie der HERR geboten hatte; so hatten sie es gemacht. Und Mose segnete sie. ");
INSERT INTO deu1951_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Du sollst die Wohnung, die Stiftshütte, aufrichten am ersten Tage des ersten Monats. ");
INSERT INTO deu1951_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Und du sollst die Lade des Zeugnisses darein setzen und den Vorhang vor die Lade hängen. ");
INSERT INTO deu1951_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Und du sollst den Tisch hineinbringen und darauf legen, was darauf gehört, und den Leuchter hineinbringen und die Lampen darauf setzen. ");
INSERT INTO deu1951_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Und du sollst den goldenen Räucheraltar vor die Lade des Zeugnisses setzen und den Vorhang in der Tür der Wohnung aufhängen. ");
INSERT INTO deu1951_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Den Brandopferaltar aber sollst du vor die Tür der Wohnung, der Stiftshütte, setzen, ");
INSERT INTO deu1951_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","und das Becken zwischen die Stiftshütte und den Altar, und sollst Wasser hineintun. ");
INSERT INTO deu1951_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Und du sollst den Vorhof ringsum aufrichten und den Vorhang in das Tor des Vorhofs hängen. ");
INSERT INTO deu1951_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Und du sollst das Salböl nehmen und die Wohnung salben, samt allem, was darin ist, und du sollst sie weihen und alle ihre Geräte, daß sie heilig sei. ");
INSERT INTO deu1951_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Und du sollst den Brandopferaltar mit allen seinen Geräten salben und ihn weihen, daß er hochheilig sei. ");
INSERT INTO deu1951_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Du sollst auch das Becken salben samt seinem Fuß und es weihen. ");
INSERT INTO deu1951_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Und du sollst Aaron und seine Söhne vor die Tür der Stiftshütte führen und sie mit Wasser waschen, ");
INSERT INTO deu1951_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","und Aaron die heiligen Kleider anziehen und ihn salben und weihen, daß er mein Priester sei. ");
INSERT INTO deu1951_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Auch seine Söhne sollst du herzuführen und ihnen die Leibröcke anziehen ");
INSERT INTO deu1951_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","und sie salben, wie du ihren Vater gesalbt hast, daß sie meine Priester seien. Und diese Salbung soll ihnen ein ewiges Priestertum verschaffen auf alle ihre Geschlechter. ");
INSERT INTO deu1951_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Und Mose tat alles, wie ihm der HERR geboten hatte; so machte er's. ");
INSERT INTO deu1951_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Also ward die Wohnung aufgerichtet im zweiten Jahr, am ersten Tage des ersten Monats. ");
INSERT INTO deu1951_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Und als Mose dieselbe aufgerichtet hatte, setzte er die Füße und die Bretter und Riegel, und richtete die Säulen auf. ");
INSERT INTO deu1951_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Und breitete das Zelt aus über die Wohnung und legte die Decke des Zeltes oben darauf, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Und er nahm das Zeugnis und legte es in die Lade, und tat die Stangen an die Lade; ");
INSERT INTO deu1951_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","und brachte die Lade in die Wohnung und hing den Vorhang vor die Lade des Zeugnisses, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Und er setzte den Tisch in die Stiftshütte, an die Seite der Wohnung gegen Mitternacht, außerhalb des Vorhangs, ");
INSERT INTO deu1951_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","und ordnete die Brote darauf vor dem HERRN, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Er stellte auch den Leuchter in die Stiftshütte, dem Tisch gegenüber, an die Seite der Wohnung gegen Mittag, ");
INSERT INTO deu1951_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","und setzte Lampen darauf vor dem HERRN, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Und er stellte den goldenen Altar in die Stiftshütte, vor den Vorhang, ");
INSERT INTO deu1951_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","und räucherte darauf mit gutem Räucherwerk, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Und er hängte den Vorhang in die Tür der Wohnung. ");
INSERT INTO deu1951_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Aber den Brandopferaltar setzte er vor die Tür der Wohnung, der Stiftshütte, und opferte darauf Brandopfer und Speisopfer, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Das Becken aber setzte er zwischen die Stiftshütte und den Altar und tat Wasser darein zum Waschen; ");
INSERT INTO deu1951_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Und Mose, Aaron und seine Söhne wuschen ihre Hände und Füße damit. ");
INSERT INTO deu1951_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Sie mußten sich waschen, wenn sie in die Stiftshütte gingen und zum Altar traten, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Und er richtete den Vorhof auf um die Wohnung und um den Altar her und hängte den Vorhang in das Tor des Vorhofs. Also vollendete Mose das ganze Werk. ");
INSERT INTO deu1951_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Da bedeckte die Wolke die Stiftshütte, und die Herrlichkeit des HERRN erfüllte die Wohnung. ");
INSERT INTO deu1951_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Und Mose konnte nicht in die Stiftshütte gehen, solange die Wolke darauf blieb und die Herrlichkeit des HERRN die Wohnung erfüllte. ");
INSERT INTO deu1951_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Wenn sich aber die Wolke von der Wohnung erhob, so brachen die Kinder Israel auf, während aller ihrer Reisen. ");
INSERT INTO deu1951_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Wenn sich aber die Wolke nicht erhob, so brachen sie nicht auf bis zu dem Tag, da sie sich erhob. ");
INSERT INTO deu1951_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Denn die Wolke des HERRN war bei Tag auf der Wohnung, und des Nachts war Feuer darauf vor den Augen des ganzen Hauses Israel, während aller ihrer Reisen. ");
INSERT INTO deu1951_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Und er rief Mose, und der HERR redete zu ihm von der Stiftshütte aus und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Rede zu den Kindern Israel und sprich zu ihnen: Will jemand von euch dem HERRN ein Opfer bringen, so soll euer Opfer, das ihr darbringet, vom Vieh, von Rindern oder Schafen genommen sein. ");
INSERT INTO deu1951_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ist seine Gabe ein Brandopfer von Rindern, so soll er ein tadelloses männliches Tier darbringen; zur Tür der Stiftshütte soll er es bringen, daß es ihn angenehm mache vor dem HERRN; ");
INSERT INTO deu1951_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","und er soll seine Hand auf den Kopf des Brandopfers stützen, so wird es ihm wohlgefällig aufgenommen und für ihn Sühne erwirken. ");
INSERT INTO deu1951_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Dann soll er den jungen Ochsen schächten vor dem HERRN; die Söhne Aarons aber, die Priester, sollen das Blut darbringen und es ringsum an den Altar sprengen, der vor der Tür der Stiftshütte steht. ");
INSERT INTO deu1951_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Er aber soll dem Brandopfer die Haut abziehen und es in Stücke zerlegen; ");
INSERT INTO deu1951_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","und die Söhne Aarons, des Priesters, sollen Feuer auf den Altar tun und Holz aufschichten über dem Feuer; ");
INSERT INTO deu1951_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","auf das Holz aber über dem Feuer sollen die Priester, die Söhne Aarons, die Fleischstücke legen, dazu den Kopf und das Fett; ");
INSERT INTO deu1951_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","sein Eingeweide aber und seine Schenkel soll man mit Wasser waschen; und der Priester soll das Ganze auf dem Altar verbrennen als ein Brandopfer, ein wohlriechendes Feuer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Entnimmt er aber seine Opfergabe dem Kleinvieh, so bringe er zum Brandopfer ein tadelloses männliches Tier von den Lämmern oder Ziegen dar ");
INSERT INTO deu1951_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","und schächte es an der nördlichen Seite des Altars vor dem HERRN, und die Söhne Aarons, die Priester, sollen das Blut ringsum an den Altar sprengen; ");
INSERT INTO deu1951_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","er aber zerlege es in Stücke, und der Priester lege sie samt dem Kopf und dem Fett ordentlich auf das Holz über dem Feuer auf dem Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Aber das Eingeweide und die Schenkel soll man mit Wasser waschen; und der Priester soll das Ganze darbringen und verbrennen auf dem Altar; es ist ein Brandopfer, ein wohlriechendes Feuer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Soll aber seine Brandopfergabe für den HERRN aus Geflügel bestehen, so bringe er von Turteltauben oder von jungen Tauben sein Opfer dar. ");
INSERT INTO deu1951_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Dieses soll der Priester zum Altar bringen und ihm den Kopf abkneifen und ihn auf dem Altar verbrennen; sein Blut aber soll an der Wand des Altars ausgepreßt werden. ");
INSERT INTO deu1951_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Den Kropf aber samt dem Unrat soll er entfernen und ihn auf den Aschenhaufen werfen, östlich vom Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Sodann soll er den Vogel an den Flügeln einreißen, sie aber nicht abtrennen, und der Priester soll ihn auf dem Altar verbrennen, auf dem Holz über dem Feuer; es ist ein Brandopfer, ein wohlriechendes Feuer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Will aber eine Seele dem HERRN ein Speisopfer bringen, so soll ihre Opfergabe aus Semmelmehl sein, und man soll Öl darüber gießen und Weihrauch darauf tun. ");
INSERT INTO deu1951_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Also soll man sie zu den Söhnen Aarons, zu den Priestern bringen, und er soll davon eine Handvoll nehmen, von dem Semmelmehl und dem Öl, samt allem Weihrauch, und der Priester soll dieses Gedächtnisopfer auf dem Altar verbrennen als ein wohlriechendes Feuer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Das Übrige aber vom Speisopfer gehört Aaron und seinen Söhnen, als ein hochheiliger Anteil an den Feueropfern des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Willst du aber ein Speisopfer darbringen von dem, was im Ofen gebacken wird, so nimm ungesäuerte Semmelkuchen, mit Öl gemengt, und ungesäuerte Fladen, mit Öl gesalbt. ");
INSERT INTO deu1951_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ist aber dein Speisopfer in der Pfanne bereitet, so soll es von ungesäuertem Semmelmehl sein, mit Öl gemengt; ");
INSERT INTO deu1951_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","du sollst es in Brocken zerbrechen und Öl darauf gießen, so ist es ein Speisopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Willst du aber ein gekochtes Speisopfer darbringen, so bereite man es von Semmelmehl mit Öl; ");
INSERT INTO deu1951_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","und du sollst das Speisopfer, das von solchem bereitet ist, zum HERRN bringen und sollst es dem Priester übergeben, der trage es zum Altar; ");
INSERT INTO deu1951_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","und der Priester soll von dem Speisopfer abheben, was davon zum Gedächtnis bestimmt ist, und soll es auf dem Altar verbrennen zu einem wohlriechenden Feuer vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Das Übrige aber vom Speisopfer gehört Aaron und seinen Söhnen, als hochheiliger Anteil an den Feueropfern des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Kein Speisopfer, das ihr dem HERRN darbringet, soll gesäuert werden; denn ihr sollt dem HERRN weder Sauerteig noch Honig verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Als eine Erstlingsgabe mögt ihr solches dem HERRN darbringen; aber auf den Altar soll es nicht kommen zum lieblichen Geruch. ");
INSERT INTO deu1951_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Dagegen sollst du alle deine Speisopfergaben mit Salz würzen und sollst das Bundessalz deines Gottes nicht fehlen lassen in deinem Speisopfer; sondern zu allen deinen Opfergaben sollst du Salz darbringen. ");
INSERT INTO deu1951_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Willst du aber dem HERRN, deinem Gott, ein Erstlingsopfer darbringen, so sollst du am Feuer geröstete Ähren, geschrotete Körner als Erstlingsspeisopfer bringen; ");
INSERT INTO deu1951_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","und sollst Öl darauf tun und Weihrauch darauf legen, so ist es ein Speisopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Und der Priester soll, was davon zum Gedächtnis bestimmt ist, verbrennen, von der Grütze und vom Öl, dazu allen Weihrauch, daß es ein Feuer sei für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ist aber seine Gabe ein Dankopfer, und bringt er es von den Rindern dar, es sei ein Ochs oder eine Kuh, so soll er ein tadelloses Tier herbringen vor den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Und er soll seine Hand stützen auf seines Opfers Haupt und es schächten vor der Tür der Stiftshütte, und Aarons Söhne, die Priester, sollen sein Blut ringsum an den Altar sprengen. ");
INSERT INTO deu1951_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Dann soll er von dem Dankopfer zur Verbrennung für den HERRN das Fett herzubringen, welches das Eingeweide bedeckt, auch alles Fett, das am Eingeweide hängt; ");
INSERT INTO deu1951_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","dazu die beiden Nieren samt dem Fett daran, das an den Lenden ist, und was über die Leber hervorragt; oberhalb der Nieren soll er es wegnehmen. ");
INSERT INTO deu1951_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Und Aarons Söhne sollen es verbrennen auf dem Altar, über dem Brandopfer, auf dem Holz, das über dem Feuer liegt, als ein wohlriechendes Feuer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Besteht aber seine Gabe, die er dem HERRN zum Dankopfer darbringt, in Kleinvieh, es sei ein Männchen oder Weibchen, so soll es tadellos sein. ");
INSERT INTO deu1951_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Bringt er ein Lamm zum Opfer dar, so bringe er es vor den HERRN ");
INSERT INTO deu1951_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","und stütze seine Hand auf des Opfers Haupt und schächte es vor der Stiftshütte; die Söhne Aarons aber sollen das Blut ringsum an den Altar sprengen. ");
INSERT INTO deu1951_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Darnach bringe er von dem Dankopfer das Fett dem HERRN zur Verbrennung dar, dazu das Fett, welches das Eingeweide bedeckt, samt allem Fett an den Eingeweiden; ");
INSERT INTO deu1951_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","auch die beiden Nieren mit dem Fett daran, das an den Lenden ist, samt dem, was über die Leber hervorragt; oberhalb der Nieren soll er es wegnehmen; ");
INSERT INTO deu1951_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","und der Priester soll es auf dem Altar verbrennen als Nahrung für das Feuer des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Besteht aber sein Opfer in einer Ziege, so bringe er sie vor den HERRN ");
INSERT INTO deu1951_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","und stütze seine Hand auf ihr Haupt und schächte sie vor der Stiftshütte; die Söhne Aarons aber sollen das Blut ringsum an den Altar sprengen. ");
INSERT INTO deu1951_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Darnach bringe er sein Opfer dar zur Verbrennung für den HERRN, nämlich das Fett, welches das Eingeweide bedeckt, samt allem Fett, das am Eingeweide hängt; ");
INSERT INTO deu1951_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","dazu die beiden Nieren mit dem Fett daran, das an den Lenden ist, samt dem, was über die Leber hervorragt; oberhalb der Nieren soll er es wegnehmen. ");
INSERT INTO deu1951_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Das soll der Priester auf dem Altar verbrennen als Nahrung für das Feuer, zum lieblichen Geruch. Alles Fett gehört dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Das ist eine ewige Satzung für eure Geschlechter an allen euren Wohnorten, daß ihr weder Fett noch Blut essen sollt. ");
INSERT INTO deu1951_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Sage zu den Kindern Israel und sprich: Wenn sich eine Seele aus Versehen versündigt gegen irgend eines der Gebote des HERRN, also daß sie etwas von dem tut, was man nicht tun soll, so gelte folgende Vorschrift: ");
INSERT INTO deu1951_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Wenn der gesalbte Priester sündigt, sodaß er sich am Volk verschuldet, so soll er für seine Sünde, die er begangen hat, einen jungen, tadellosen Farren dem HERRN zum Sündopfer darbringen; ");
INSERT INTO deu1951_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","und zwar soll er den Farren zur Tür der Stiftshütte bringen, vor den HERRN, und seine Hand stützen auf des Farren Haupt und ihn schächten vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Und der gesalbte Priester soll von dem Blut des Farren nehmen und es in die Stiftshütte bringen; ");
INSERT INTO deu1951_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","und der Priester soll seinen Finger in das Blut tauchen und von dem Blut siebenmal an die Vorderseite des Vorhangs im Heiligtum sprengen, vor dem Angesicht des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Auch soll der Priester von dem Blut auf die Hörner des wohlriechenden Räucheraltars tun, der in der Stitshütte ist vor dem HERRN; alles übrige Blut des Farren aber soll er an den Fuß des Brandopferaltars gießen, der vor der Tür der Stiftshütte ist. ");
INSERT INTO deu1951_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Und alles Fett des Sündopferfarren soll er von ihm ablösen, das Fett, welches das Eingeweide bedeckt, und alles Fett, das am Eingeweide hängt; ");
INSERT INTO deu1951_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","dazu die beiden Nieren, samt dem Fett daran, das an den Lenden ist, auch das, was über die Leber hervorragt; oberhalb der Nieren soll er es wegnehmen, gleich wie man es von dem Stier des Dankopfers abhebt; ");
INSERT INTO deu1951_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","und der Priester soll es auf dem Brandopferaltar verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Aber das Fell des Farren und all sein Fleisch samt seinem Kopf, seinen Schenkeln, seinen Eingeweiden und seinem Mist, ");
INSERT INTO deu1951_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","kurz den ganzen Farren soll man hinaus vor das Lager führen, an einen reinen Ort, wohin man die Asche zu schütten pflegt, und ihn bei einem Holzfeuer verbrennen; am Aschenplatz soll er verbrannt werden. ");
INSERT INTO deu1951_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Wenn sich aber die ganze Gemeinde Israel vergeht, und es ist vor den Augen der Versammlung verborgen, daß sie etwas getan, davon der HERR geboten hat, daß man es nicht tun soll, sodaß sie sich verschuldet hat; ");
INSERT INTO deu1951_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","sie kommt aber zur Erkenntnis der Sünde, die sie begangen hat wider dasselbe Gebot, so soll die Versammlung einen jungen Farren darbringen und ihn vor die Stiftshütte führen. ");
INSERT INTO deu1951_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Dann sollen die Ältesten der Gemeinde ihre Hände auf des Farren Haupt stützen vor dem HERRN, und man soll den Farren schächten vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Der gesalbte Priester aber soll von dem Blut des Farren in die Stiftshütte bringen, ");
INSERT INTO deu1951_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","und der Priester soll seinen Finger in das Blut tauchen und davon siebenmal an die Vorderseite des Vorhangs sprengen vor dem HERRN; ");
INSERT INTO deu1951_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","und er soll von dem Blut auf die Hörner des Altars tun, der vor dem HERRN in der Stiftshütte steht; alles übrige Blut aber soll er an den Fuß des Brandopferaltars gießen, der vor der Tür der Stiftshütte steht. ");
INSERT INTO deu1951_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Aber all sein Fett soll er von ihm ablösen und es auf dem Altar verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Er soll diesen Farren behandeln, wie er den Farren des Sündopfers behandelt hat; ganz gleich soll auch dieser behandelt werden, und der Priester soll sie versühnen, und es soll ihr vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Und man soll den Farren hinaus vor das Lager schaffen und ihn verbrennen, wie man den ersten Farren verbrannt hat. Er ist ein Sündopfer der Gemeinde. ");
INSERT INTO deu1951_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Kommt es aber vor, daß ein Fürst sündigt und aus Versehen irgend etwas tut, wovon der HERR, sein Gott, geboten, daß man es nicht tun soll, und sich also verschuldet, ");
INSERT INTO deu1951_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","man hält ihm aber seine Sünde vor, die er daran begangen hat, so soll er einen tadellosen Ziegenbock zum Opfer bringen ");
INSERT INTO deu1951_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","und soll seine Hand auf des Bockes Haupt stützen und ihn schächten an dem Ort, da man das Brandopfer zu schächten pflegt vor dem HERRN; es ist ein Sündopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Und der Priester soll mit seinem Finger von dem Blut des Sündopfers nehmen und es auf die Hörner des Brandopferaltars tun; das übrige Blut aber soll er an den Fuß des Brandopferaltars gießen; ");
INSERT INTO deu1951_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","und all sein Fett soll er auf dem Altar verbrennen, gleich dem Fett des Dankopfers. Also soll der Priester ihm Sühne erwirken für seine Sünde, und es wird ihm vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Wenn aber jemand vom Landvolk aus Versehen sündigt, indem er etwas tut, davon der HERR geboten hat, daß man es nicht tun soll, und sich verschuldet, ");
INSERT INTO deu1951_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","man hält ihm aber seine Sünde vor, die er begangen hat, so soll er eine tadellose Ziege zum Opfer bringen für seine Sünde, die er begangen hat, ");
INSERT INTO deu1951_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","und er soll seine Hand auf des Sündopfers Haupt stützen und das Sündopfer schächten an der Stätte des Brandopfers. ");
INSERT INTO deu1951_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Der Priester aber soll mit seinem Finger von dem Blut der Ziege nehmen und es auf die Hörner des Brandopferaltars tun und alles übrige Blut an den Fuß des Brandopferaltars gießen. ");
INSERT INTO deu1951_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Alles Fett aber soll er von ihr nehmen, wie das Fett von dem Dankopfer genommen wird, und der Priester soll es auf dem Altar verbrennen zum lieblichen Geruch dem HERRN. Also soll der Priester für ihn Sühne erwirken, und es wird ihm vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Will er aber ein Lamm darbringen zum Sündopfer, so soll es ein tadelloses Weibchen sein; ");
INSERT INTO deu1951_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","und er soll seine Hand stützen auf des Sündopfers Haupt und es schächten als Sündopfer an dem Ort, wo man das Brandopfer zu schächten pflegt. ");
INSERT INTO deu1951_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Und der Priester soll mit seinem Finger von dem Blut des Sündopfers nehmen und es auf die Hörner des Brandopferaltars tun, alles übrige Blut aber an den Fuß des Altars gießen. ");
INSERT INTO deu1951_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Und er soll alles Fett davon nehmen, wie das Fett von dem Lamm des Dankopfers genommen wird, und der Priester soll es auf dem Altar verbrennen, über den Feuerflammen des HERRN, und also soll er ihm Sühne erwirken wegen seiner Sünde, die er begangen hat, so wird ihm vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Wenn eine Seele dadurch sündigt, daß sie etwas nicht anzeigt, wiewohl sie die Beschwörung vernommen hat und Zeuge ist, daß sie es entweder gesehen oder erfahren hat, so daß sie nun ihre Missetat trägt; ");
INSERT INTO deu1951_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","oder wenn eine Seele irgend etwas Unreines anrührt, sei es das Aas eines unreinen Wildes oder das Aas eines unreinen Viehs oder das Aas eines unreinen Reptils, und es ist ihr verborgen gewesen, sie fühlt sich nun aber unrein und schuldig; ");
INSERT INTO deu1951_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","oder wenn jemand menschliche Unreinheit anrührt, irgend etwas von alledem, womit man sich verunreinigen kann, und es ist ihm verborgen gewesen, er hat es aber nun erkannt und fühlt sich schuldig; ");
INSERT INTO deu1951_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","oder wenn eine Seele leichtfertig mit ihren Lippen schwört, Gutes oder Böses tun zu wollen, irgend etwas von dem, was so ein Mensch leichtfertig schwören mag, und es war ihm verborgen, er erkennt es aber nun und fühlt sich einer dieser Sachen schuldig ");
INSERT INTO deu1951_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ist er nun wirklich in einem dieser Punkte schuldig, so bekenne er, woran er sich versündigt hat, ");
INSERT INTO deu1951_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","und bringe dem HERRN als Schuldopfer für seine Sünde, die er begangen hat, ein Weibchen vom Kleinvieh, ein Lamm oder eine Ziege zum Sündopfer, und der Priester soll ihm damit Sühne erwirken wegen seiner Sünde. ");
INSERT INTO deu1951_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kann er aber nicht soviel zusammenbringen, daß es zu einem Schäflein langt, so bringe er dem HERRN zu seinem Schuldopfer, das er schuldig ist, zwei Turteltauben oder zwei junge Tauben, eine zum Schuldopfer, die andere zum Brandopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Er soll sie zum Priester bringen; dieser aber soll zuerst die zum Sündopfer bestimmte darbringen und ihr unterhalb des Genicks den Kopf abkneifen, ihn aber nicht abtrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Und vom Blut des Sündopfers sprenge er an die Wand des Altars, das übrige Blut aber soll an den Fuß des Altars ausgepreßt werden, weil es ein Sündopfer ist. ");
INSERT INTO deu1951_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Aus der andern aber soll er ein Brandopfer machen, wie es verordnet ist. Also soll der Priester für ihn Sühne erwirken wegen seiner Sünde, die er begangen hat, so wird ihm vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Vermag er aber auch die zwei Turteltauben oder die zwei jungen Tauben nicht, so bringe er zu seinem Opfer, das er schuldig ist, ein Zehntel Epha Semmelmehl als Sündopfer. Er soll aber weder Öl daran tun, noch Weihrauch darauf legen, weil es ein Sündopfer ist. ");
INSERT INTO deu1951_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Er soll es zum Priester bringen, und der Priester nehme eine Handvoll davon, soviel als zum Gedächtnis bestimmt ist, und verbrenne es auf dem Altar über dem Feuer des HERRN. Es ist ein Sündopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Also soll ihm der Priester Sühne erwirken wegen seiner Sünde, die er begangen hat in einem jener Fälle, so wird ihm vergeben werden. Das Opfer aber soll dem Priester gehören wie das Speisopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Wenn sich eine Seele aus Versehen vergreift und versündigt an heiligen Dingen des HERRN, so soll sie dem HERRN ihr Schuldopfer bringen, nämlich einen tadellosen Widder von der Herde, nach deiner Schätzung im Wert von zwei Schekeln, nach dem Schekel des Heiligtums, zum Schuldopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Den Schaden aber, den er dem Heiligtum zugefügt hat, soll er vergüten und einen Fünftel dazufügen und es dem Priester geben; der soll für ihn Sühne erwirken mit dem Widder des Schuldopfers, so wird ihm vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Und wenn eine Seele sündigt und irgend etwas von alledem tut, was der HERR verboten hat und man nicht tun soll, hat es aber nicht gewußt und fühlt sich nun schuldig und trägt ihre Missetat; ");
INSERT INTO deu1951_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","so soll der Betreffende dem Priester einen tadellosen Widder von seiner Herde nach deiner eigenen Schätzung zum Schuldopfer bringen, und der Priester soll ihm Sühne erwirken wegen seines Versehens, das er unwissentlich begangen hat; so wird ihm vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Es ist ein Schuldopfer, das er dem HERRN schuldig ist. ");
INSERT INTO deu1951_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","(05-20) Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","(05-21) Wenn sich jemand dadurch versündigt und vergreift am HERRN, daß er seinem Volksgenossen etwas Anvertrautes oder Hinterlegtes ableugnet oder gewalttätigerweise raubt; ");
INSERT INTO deu1951_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","(05-22) oder wenn er etwas Verlorenes gefunden hat und es ableugnet und schwört einen falschen Eid wegen irgend etwas von alledem, womit sich ein Mensch versündigen mag; ");
INSERT INTO deu1951_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","(05-23) wenn er nun, nachdem er also gesündigt hat, sich schuldig fühlt, so soll er den Raub, den er genommen hat, oder das erpreßte Gut, das er sich gewalttätigerweise angeeignet hat, oder das anvertraute Gut, das ihm anvertraut worden, oder das Verlorene, das er gefunden hat, wiedergeben; ");
INSERT INTO deu1951_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","(05-24) auch alles, worüber er einen falschen Eid geschworen hat, soll er nach seinem vollen Wert zurückerstatten und noch einen Fünftel dazulegen; und zwar soll er es dem geben, dem es gehört, an dem Tage, da er sein Schuldopfer entrichtet. ");
INSERT INTO deu1951_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","(05-25) Sein Schuldopfer aber soll er dem HERRN bringen, einen tadellosen Widder von der Herde nach deiner Schätzung als Schuldopfer, zum Priester. ");
INSERT INTO deu1951_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","(05-26) Und der Priester soll ihm Sühne erwirken vor dem HERRN, so wird ihm vergeben werden, was irgend er getan hat von alledem, womit man sich verschulden kann. ");
INSERT INTO deu1951_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","(06-1) Und der HERR redete zu Mose und sprach: Gebiete Aaron und seinen Söhnen und sprich: ");
INSERT INTO deu1951_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","(06-2) Dies ist das Gesetz vom Brandopfer: Das Brandopfer soll auf seiner Glut auf dem Altar die ganze Nacht bis zum Morgen verbleiben, daß das Feuer des Altars dadurch genährt werde. ");
INSERT INTO deu1951_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","(06-3) Und der Priester soll ein leinenes Kleid anziehen und sein Fleisch in die leinenen Beinkleider hüllen und soll die Asche abheben, nachdem das Feuer auf dem Altar das Brandopfer verzehrt hat, und sie neben den Altar tun. ");
INSERT INTO deu1951_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","(06-4) Dann lege er seine Kleider ab und ziehe andere Kleider an und schaffe die Asche hinaus vor das Lager an einen reinen Ort. ");
INSERT INTO deu1951_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","(06-5) Aber das Feuer auf dem Altar soll auf demselben brennend erhalten werden; es soll nicht erlöschen; darum soll der Priester alle Morgen Holz darauf anzünden und das Brandopfer darauf zurichten und das Fett der Dankopfer darauf verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","(06-6) Ein beständiges Feuer soll auf dem Altar brennen; es soll nie erlöschen! ");
INSERT INTO deu1951_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","(06-7) Und dies ist das Gesetz vom Speisopfer: Die Söhne Aarons sollen es vor dem HERRN darbringen, vor dem Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","(06-8) Und dann hebe einer davon eine Handvoll ab, von dem Semmelmehl des Speisopfers und von seinem Öl, auch allen Weihrauch, der auf dem Speisopfer ist, und verbrenne also, was davon zum Gedächtnis bestimmt ist, auf dem Altar zum lieblichen Geruch dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","(06-9) Das Übrige aber sollen Aaron und seine Söhne essen; ungesäuert soll es gegessen werden an einem heiligen Ort; im Vorhof der Stiftshütte sollen sie es essen. ");
INSERT INTO deu1951_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","(06-10) Es soll ungesäuert gebacken werden. Ich habe es ihnen gegeben als ihren Anteil an meinen Feueropfern; es ist hochheilig wie das Sündopfer und wie das Schuldopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","(06-11) Alles, was männlich ist unter Aarons Nachkommen, darf davon essen; es ist ein auf ewig festgesetzter Anteil an den Feueropfern des HERRN für alle eure Geschlechter. Jeder, der es anrührt, soll heilig sein! ");
INSERT INTO deu1951_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","(06-12) Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","(06-13) Dies ist die Opfergabe Aarons und seiner Söhne, welche sie dem HERRN darbringen sollen am Tage seiner Salbung. Ein Zehntel Epha Semmelmehl als beständiges Speisopfer, die eine Hälfte am Morgen, die andere am Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","(06-14) Es soll in der Pfanne mit Öl angemacht werden, durcheinandergerührt soll man es darbringen, in Kuchenform, in Bissen zerlegt soll man das Speisopfer darbringen zum lieblichen Geruch dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","(06-15) Und zwar soll es der Priester, der an Aarons Statt aus seinen Söhnen gesalbt wird, bereiten, dem HERRN zum ewigen Recht; es soll gänzlich verbrannt werden. ");
INSERT INTO deu1951_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","(06-16) Jedes Speisopfer eines Priesters soll ganz verbrannt werden; es darf nicht gegessen werden. ");
INSERT INTO deu1951_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","(06-17) Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","(06-18) Sage zu Aaron und zu seinen Söhnen und sprich: Dies ist das Gesetz vom Sündopfer: Am gleichen Ort, da man das Brandopfer schächtet, soll auch das Sündopfer geschächtet werden vor dem HERRN, weil es hochheilig ist. ");
INSERT INTO deu1951_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","(06-19) Der Priester, der das Sündopfer darbringt, darf es essen; es soll aber an heiliger Stätte gegessen werden, im Vorhof der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","(06-20) Jeder, der sein Fleisch anrührt, soll heilig sein! Wenn aber etwas von seinem Blut auf ein Kleid spritzt, so sollst du das, was bespritzt worden ist, an heiliger Stätte waschen. ");
INSERT INTO deu1951_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","(06-21) Ist es in einem irdenen Geschirr gekocht worden, so soll man dasselbe zerbrechen, wenn aber in einem ehernen, so muß es gescheuert und mit Wasser gespült werden. ");
INSERT INTO deu1951_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","(06-22) Alles, was männlich ist unter den Priestern, darf davon essen; es ist hochheilig. ");
INSERT INTO deu1951_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","(06-23) Dagegen soll man kein Sündopfer essen, von dessen Blut in die Stiftshütte hineingebracht wird, um Sühne zu erwirken im Heiligtum; es soll mit Feuer verbrannt werden. ");
INSERT INTO deu1951_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Und dies ist das Gesetz vom Schuldopfer, welches hochheilig ist: ");
INSERT INTO deu1951_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Am gleichen Ort, wo man das Brandopfer schächtet, soll man auch das Schuldopfer schächten und sein Blut ringsum an den Altar sprengen. ");
INSERT INTO deu1951_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Auch soll man von ihm all sein Fett darbringen, den Fettschwanz samt dem Fett, welches die Eingeweide bedeckt; ");
INSERT INTO deu1951_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","dazu die beiden Nieren mit dem Fett daran, das an den Lenden ist, samt dem, was über die Leber hervorragt; über den Nieren soll man es wegnehmen. ");
INSERT INTO deu1951_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Und der Priester soll es auf dem Altar verbrennen, daß solches Schuldopfer zu einem Feuer werde für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Alles, was männlich ist unter den Priestern, darf es essen; es soll aber an heiliger Stätte gegessen werden, weil es hochheilig ist. ");
INSERT INTO deu1951_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Wie das Sündopfer, so das Schuldopfer; für beide gilt ein und dasselbe Gesetz: Es gehört dem Priester, der die Sühne damit vollzieht. ");
INSERT INTO deu1951_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Dem Priester, der jemandes Brandopfer darbringt, gehört auch das Fell des Brandopfers, welches er dargebracht hat. ");
INSERT INTO deu1951_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Desgleichen alle Speisopfer, die im Ofen gebacken, im Topf gekocht oder auf der Pfanne bereitet werden, fallen dem Priester zu, der sie darbringt. ");
INSERT INTO deu1951_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Alle Speisopfer, seien sie nun mit Öl vermengt oder trocken, gehören allen Söhnen Aarons, einem wie dem andern. ");
INSERT INTO deu1951_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Und dies ist das Gesetz des Dankopfers, das man dem HERRN darbringen soll: ");
INSERT INTO deu1951_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Will er es zum Lobe opfern, so bringe er zu seinem Lob-Schlachtopfer hinzu ungesäuerte Kuchen dar, mit Öl gemengt, und ungesäuerte Fladen, mit Öl bestrichen, und eingerührtes Semmelmehl, mit Öl gemengte Kuchen. ");
INSERT INTO deu1951_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Auf einem gesäuerten Brotkuchen soll er seine Opfergabe darbringen, zum Schlachtopfer seines Lob und Dankopfers hinzu. ");
INSERT INTO deu1951_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Von allen Opfergaben aber soll er dem HERRN je ein Stück als Hebe darbringen; das soll dem Priester gehören, der das Blut der Dankopfer sprengt. ");
INSERT INTO deu1951_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Es soll aber das Fleisch des Lob und Dankopfers am Tage seiner Darbringung gegessen werden; man darf nichts davon übriglassen bis zum Morgen. ");
INSERT INTO deu1951_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Beruht aber das Opfer, das er darbringt, auf einem Gelübde, oder ist es freiwillig, so soll es am Tage seiner Darbringung gegessen werden und am folgenden Tag, so daß, was davon übrigbleibt, gegessen werden darf. ");
INSERT INTO deu1951_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Was aber vom Opferfleisch bis zum dritten Tag übrigbleibt, das soll man mit Feuer verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Sollte aber trotzdem am dritten Tage von dem Fleisch seines Dankopfers gegessen werden, so würde der, welcher es dargebracht hat, nicht angenehm sein; es würde ihm nicht zugerechnet, sondern für verdorben gelten, und die Seele, die davon äße, müßte ihre Schuld tragen. ");
INSERT INTO deu1951_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Auch wenn das Fleisch mit irgend etwas Unreinem in Berührung kommt, so darf man es nicht essen, sondern muß es mit Feuer verbrennen; sonst aber darf jedermann von diesem Fleisch essen, wenn er rein ist. ");
INSERT INTO deu1951_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Eine Seele aber, die ihre Unreinigkeit an sich hat und doch von dem Fleisch des Dankopfers ißt, das dem HERRN gehört, die soll ausgerottet werden aus ihrem Volk. ");
INSERT INTO deu1951_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Auch wenn eine Seele irgend etwas Unreines anrührt, es sei die Unreinigkeit eines Menschen oder ein unreines Vieh oder irgend ein unreines Reptil, und ißt doch von dem Fleisch des Dankopfers, das dem HERRN gehört, so soll eine solche Seele ausgerottet werden von ihrem Volk. ");
INSERT INTO deu1951_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Sage den Kindern Israel und sprich: Ihr sollt kein Fett essen von Ochsen, Lämmern und Ziegen! ");
INSERT INTO deu1951_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Das Fett von Aas oder Zerrissenem darf zu allerlei Zwecken verwendet werden, aber essen sollt ihr es nicht. ");
INSERT INTO deu1951_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Denn wer Fett ißt von dem Vieh, von welchem man dem HERRN Feueropfer darzubringen pflegt, der soll ausgerottet werden aus seinem Volk! ");
INSERT INTO deu1951_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ihr sollt auch kein Blut essen in allen euren Wohnungen, weder von Geflügel noch vom Vieh; ");
INSERT INTO deu1951_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","jede Seele, die irgendwelches Blut ißt, soll ausgerottet werden aus ihrem Volk! ");
INSERT INTO deu1951_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Sage zu den Kindern Israel und sprich: Wer dem HERRN ein Dankopfer darbringen will, der lasse dem HERRN seine Gabe zukommen von seinem Dankopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Eigenhändig soll er herzubringen, was dem HERRN verbrannt werden soll: Das Fett samt dem Kern stück der Brust soll er bringen, den Brustkern, um ihn als Webopfer vor dem HERRN zu weben. ");
INSERT INTO deu1951_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Der Priester aber soll das Fett auf dem Altar verbrennen; und der Brustkern fällt Aaron und seinen Söhnen zu. ");
INSERT INTO deu1951_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Dazu sollt ihr die rechte Keule von euren Dankopfern dem Priester als Hebe geben; ");
INSERT INTO deu1951_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","und zwar soll derjenige von Aarons Söhnen, der das Blut der Dankopfer und das Fett darbringt, die rechte Keule zum Anteil erhalten. ");
INSERT INTO deu1951_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Denn ich habe die Webebrust und die Hebekeule von den Kindern Israel, von ihren Dankopfern genommen und habe sie dem Priester Aaron und seinen Söhnen gegeben zum ewigen Anrecht, das sie zu beanspruchen haben von den Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Das ist das Salbungsgeschenk, welches Aaron und seinen Söhnen gemacht wurde von den Feueropfern des HERRN an dem Tage, da er sie herzunahen ließ, dem HERRN Priesterdienst zu tun, ");
INSERT INTO deu1951_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","davon der HERR am Tage ihrer Salbung befahl, daß es ihnen gegeben werde von den Kindern Israel als ewiges Recht in ihren Geschlechtern. ");
INSERT INTO deu1951_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Dies ist das Gesetz vom Brandopfer, vom Speisopfer, vom Sündopfer, vom Schuldopfer, vom Einweihungsopfer und vom Dankopfer, ");
INSERT INTO deu1951_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","welches der HERR Mose auf dem Berge Sinai gegeben hat, des Tages, da er den Kindern Israel befahl, dem HERRN ihre Opfer darzubringen, in der Wüste Sinai. ");
INSERT INTO deu1951_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Nimm Aaron und seine Söhne mit ihm, dazu die Kleider und das Salböl und einen Farren zum Sündopfer, zwei Widder und einen Korb mit ungesäuertem Brot, ");
INSERT INTO deu1951_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","und versammle die ganze Gemeinde vor der Tür der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mose tat, wie ihm der HERR befahl, und versammelte die Gemeinde vor der Tür der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Und Mose sprach zu der Gemeinde: Das ist's, was der HERR zu tun geboten hat. ");
INSERT INTO deu1951_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Und Mose brachte Aaron und seine Söhne herzu und wusch sie mit Wasser. ");
INSERT INTO deu1951_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Und er legte ihm den Leibrock an und gürtete ihn mit dem Gürtel des Ephod und befestigte es damit. ");
INSERT INTO deu1951_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Darnach legte er ihm das Brustschildlein an und tat in das Brustschildlein das Licht und das Recht; ");
INSERT INTO deu1951_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","und er setzte ihm den Hut auf das Haupt und heftete an den Hut, vorn an seine Stirne, das goldene Stirnblatt, das heilige Diadem, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Und Mose nahm das Salböl und salbte die Wohnung und alles, was darin war, und weihte es. ");
INSERT INTO deu1951_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Auch sprengte er davon siebenmal auf den Altar und salbte den Altar samt allen seinen Geräten, auch das Becken samt seinem Fuß, um es zu weihen. ");
INSERT INTO deu1951_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Und er goß von dem Salböl auf das Haupt Aarons und salbte ihn, um ihn zu weihen. ");
INSERT INTO deu1951_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Er brachte auch die Söhne Aarons herzu und zog ihnen Leibröcke an und gürtete sie mit dem Gürtel und band ihnen hohe Mützen auf, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Und ließ einen Farren herzuführen zum Sündopfer; und Aaron und seine Söhne stützten ihre Hände auf den Kopf des Farren, des Sündopfers. ");
INSERT INTO deu1951_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Und Mose schächtete ihn und nahm das Blut und tat es mit seinem Finger auf die Hörner des Altars ringsum; also entsündigte er den Altar und goß das übrige Blut an den Grund des Altars und weihte ihn, indem er ihm Sühne erwirkte. ");
INSERT INTO deu1951_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Sodann nahm er alles Fett am Eingeweide und was über die Leber hervorragt und die beiden Nieren mit dem Fett daran, und Mose verbrannte es auf dem Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Aber den Farren samt seinem Fell und seinem Fleisch und Mist verbrannte er mit Feuer außerhalb des Lagers, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Er brachte auch den Widder herzu zum Brandopfer. Und Aaron und seine Söhne stützten ihre Hände auf des Widders Kopf. ");
INSERT INTO deu1951_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Und Mose schächtete ihn und sprengte das Blut ringsrum an den Altar ");
INSERT INTO deu1951_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","und zerlegte den Widder in seine Stücke, und Mose verbrannte den Kopf, die Stücke und das Fett, ");
INSERT INTO deu1951_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","und wusch die Eingeweide und die Schenkel mit Wasser; also verbrannte Mose den ganzen Widder auf dem Altar. Das war ein Brandopfer zum lieblichen Geruch, ein Feueropfer dem HERRN, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Er brachte auch den andern Widder herzu, den Widder des Einweihungsopfers. Und Aaron und seine Söhne stützten ihre Hände auf des Widders Kopf. ");
INSERT INTO deu1951_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mose aber schächtete ihn und nahm von seinem Blut, und tat es Aaron auf sein rechtes Ohrläpplein und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes, ");
INSERT INTO deu1951_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","und er brachte auch Aarons Söhne herzu und tat von dem Blut auf ihr rechtes Ohrläpplein und auf den Daumen ihrer rechten Hand und auf die große Zehe ihres rechten Fußes und sprengte das Blut ringsum an den Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Und er nahm das Fett und den Fettschwanz und alles Fett am Eingeweide und was über die Leber hervorragt und die beiden Nieren mit dem Fett daran und die rechte Keule; ");
INSERT INTO deu1951_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","dazu nahm er aus dem Korbe mit dem ungesäuerten Brot vor dem HERRN einen ungesäuerten Kuchen und einen Brotkuchen mit Öl und einen Fladen und legte es auf die Fettstücke und auf die rechte Keule, ");
INSERT INTO deu1951_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","und legte das alles auf die Hände Aarons und auf die Hände seiner Söhne und webte es zum Webopfer vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Darnach nahm Mose das alles wieder von ihren Händen und verbrannte es auf dem Altar über dem Brandopfer. Das war das Einweihungsopfer zum lieblichen Geruch, ein Feueropfer dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Und Mose nahm die Brust und webte sie zum Webopfer vor dem HERRN; das war Moses Anteil von dem Widder des Einweihungsopfers, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Und Mose nahm von dem Salböl und von dem Blut auf dem Altar und sprengte es auf Aaron und seine Kleider, auf seine Söhne und ihre Kleider und weihte also Aaron und seine Kleider und mit ihm seine Söhne und seiner Söhne Kleider. ");
INSERT INTO deu1951_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Und Mose sprach zu Aaron und zu seinen Söhnen: Kocht das Fleisch vor der Tür der Stiftshütte und esset es daselbst, wie ich geboten und gesagt habe: Aaron und seine Söhne sollen es essen. ");
INSERT INTO deu1951_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Was aber vom Fleisch und Brot übrigbleibt, das sollt ihr mit Feuer verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Und ihr sollt sieben Tage lang nicht hinausgehen vor die Tür der Stiftshütte, bis an den Tag, an welchem die Tage eures Weihopfers erfüllt sind; denn sieben Tage lang soll man euch die Hände füllen. ");
INSERT INTO deu1951_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Was man heute getan hat, das hat der HERR zu tun befohlen, um für euch Sühne zu erwirken. ");
INSERT INTO deu1951_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Sieben Tage lang sollt ihr Tag und Nacht an der Tür der Stiftshütte bleiben und die Anordnungen des HERRN befolgen, daß ihr nicht sterbet; denn also ist es mir geboten worden. ");
INSERT INTO deu1951_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Und Aaron und seine Söhne taten alles, was der HERR durch Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Und am achten Tage rief Mose den Aaron und seine Söhne und die Ältesten von Israel und sprach zu Aaron: ");
INSERT INTO deu1951_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Nimm dir ein Stierkalb zum Sündopfer und einen Widder zum Brandopfer, beide tadellos, und bringe sie vor den HERRN ");
INSERT INTO deu1951_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","und sage zu den Kindern Israel und sprich: Nehmt einen Ziegenbock zum Sündopfer und ein Kalb und ein Schaf, beide ein Jahr alt und tadellos, zum Brandopfer, ");
INSERT INTO deu1951_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ferner einen Ochsen und einen Widder zum Dankopfer, vor dem HERRN zu opfern, und ein mit Öl gemengtes Speisopfer; denn heute wird euch der HERR erscheinen. ");
INSERT INTO deu1951_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Und sie brachten, was Mose geboten hatte, vor die Tür der Stiftshütte, und die ganze Gemeinde trat herzu und stand vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Da sprach Mose: Was der HERR geboten hat, das sollt ihr tun, so wird euch die Herrlichkeit des HERRN erscheinen! ");
INSERT INTO deu1951_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Und Mose sprach zu Aaron: Tritt zum Altar und verrichte dein Sündopfer und dein Brandopfer und erwirke Sühne für dich und das Volk. Darnach bringe das Opfer des Volkes dar und erwirke Sühnung für sie, wie der HERR geboten hat! ");
INSERT INTO deu1951_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Da trat Aaron zum Altar und schächtete das Kalb zum Sündopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Und die Söhne Aarons brachten das Blut zu ihm, und er tauchte seinen Finger in das Blut und tat es auf die Hörner des Altars und goß das übrige Blut an den Grund des Altars. ");
INSERT INTO deu1951_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Aber das Fett und die Nieren und was von der Leber des Sündopfers hervorragt, verbrannte er auf dem Altar, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Und das Fleisch und das Fell verbrannte er mit Feuer außerhalb des Lagers. ");
INSERT INTO deu1951_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Darnach schächtete er das Brandopfer, und die Söhne Aarons brachten das Blut zu ihm, und er sprengte es ringsum an den Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Und sie brachten das Brandopfer, in seine Stücke zerlegt, samt dem Kopf, zu ihm, und er verbrannte es auf dem Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Und er wusch die Eingeweide und die Schenkel und verbrannte es über dem Brandopfer auf dem Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Darnach brachte er das Opfer des Volkes herzu und nahm den Bock, das Sündopfer des Volkes, und schächtete ihn und machte ein Sündopfer daraus, wie das vorige. ");
INSERT INTO deu1951_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Darnach brachte er das Brandopfer herzu und verrichtete es nach Vorschrift. ");
INSERT INTO deu1951_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Er brachte auch das Speisopfer herzu und nahm eine Handvoll davon und verbrannte es auf dem Altar, außer dem Brandopfer des Morgens. ");
INSERT INTO deu1951_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Darnach schächtete er den Ochsen und den Widder zum Dankopfer des Volks. Und die Söhne Aarons brachten ihm das Blut; das sprengte er ringsum an den Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Aber die Fettstücke vom Ochsen und vom Widder, den Fettschwanz und das Fett, welches die Eingeweide bedeckt, und die Nieren und was über die Leber hervorragt, ");
INSERT INTO deu1951_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","alle diese Fettstücke legten sie auf die Brust; und er verbrannte die Fettstücke auf dem Altar. ");
INSERT INTO deu1951_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aber die Brust und die rechte Schulter webte Aaron zum Webopfer vor dem HERRN, wie Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Darnach streckte Aaron seine Hand aus gegen das Volk und segnete es und stieg herab, nachdem er das Sündopfer, das Brandopfer und das Dankopfer dargebracht hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Und Mose und Aaron gingen in die Stiftshütte hinein. Und als sie wieder herauskamen, segneten sie das Volk. Da erschien die Herrlichkeit des HERRN allem Volk; ");
INSERT INTO deu1951_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","und es ging Feuer aus von dem HERRN und verzehrte das Brandopfer und die Fettstücke auf dem Altar. Als alles Volk solches sah, jubelten sie und fielen auf ihre Angesichter. ");
INSERT INTO deu1951_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aber die Söhne Aarons, Nadab und Abihu, nahmen ein jeder seine Räucherpfanne und taten Feuer hinein und legten Räucherwerk darauf und brachten fremdes Feuer vor den HERRN, das er ihnen nicht geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Da ging Feuer aus von dem HERRN und verzehrte sie, daß sie starben vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Da sprach Mose zu Aaron: Das hat der HERR gemeint, als er sprach: Ich will geheiligt werden durch die, welche zu mir nahen, und geehrt werden vor allem Volk! Und Aaron schwieg still. ");
INSERT INTO deu1951_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mose aber rief Misael und Elzaphan, die Söhne Ussiels, des Oheims Aarons, und sprach zu ihnen: Tretet herzu und traget eure Brüder vom Heiligtum hinweg, vor das Lager hinaus! ");
INSERT INTO deu1951_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Und sie traten herzu und trugen sie in ihren Leibröcken vor das Lager hinaus, wie Mose befohlen hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Da sprach Mose zu Aaron und seinen Söhnen Eleasar und Itamar: Ihr sollt eure Häupter nicht entblößen, noch eure Kleider zerreißen, damit ihr nicht sterbet und der Zorn über die ganze Gemeinde komme. Lasset eure Brüder, das ganze Haus Israel, weinen über diesen Brand, den der HERR angezündet hat. ");
INSERT INTO deu1951_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ihr aber sollt nicht vor die Tür der Stiftshütte hinausgehen, auf daß ihr nicht sterbet; denn das Salböl des HERRN ist auf euch! Und sie taten, wie Mose sagte. ");
INSERT INTO deu1951_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","DER HERR aber redete mit Aaron und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Du und deine Söhne mit dir sollen keinen Wein noch starkes Getränk trinken, wenn ihr in die Stiftshütte geht, damit ihr nicht sterbet. Das sei eine ewige Ordnung für eure Geschlechter, ");
INSERT INTO deu1951_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","damit ihr unterscheiden könnet zwischen heilig und gemein, zwischen unrein und rein, ");
INSERT INTO deu1951_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","und damit ihr die Kinder Israel alle Rechte lehret, die der HERR zu ihnen durch Mose geredet hat. ");
INSERT INTO deu1951_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Und Mose redete mit Aaron und mit seinen übrigen Söhnen, Eleasar und Itamar: Nehmt das Speisopfer, das von den Feueropfern des HERRN übrigbleibt, und esset es ungesäuert beim Altar, denn es ist hochheilig. ");
INSERT INTO deu1951_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ihr sollt es essen an heiliger Stätte; denn es ist das, was dir und deinen Söhnen bestimmt ist von den Feueropfern des HERRN; denn also ist es mir geboten worden. ");
INSERT INTO deu1951_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Desgleichen die Webebrust und die Hebeschulter sollst du und deine Söhne und deine Töchter mit dir an reiner Stätte essen. Denn solches ist dir und deinen Kindern bestimmt von den Dankopfern der Kinder Israel. ");
INSERT INTO deu1951_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Die Hebekeule und die Webebrust soll man mit den Feueropfern der Fettstücke herzubringen, daß man sie webe zum Webopfer vor dem HERRN. Solches soll dir und deinen Söhnen mit dir als ein ewiges Recht zufallen, wie der HERR geboten hat. ");
INSERT INTO deu1951_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Und Mose suchte den Bock des Sündopfers; und siehe, er war verbrannt. Da ward er zornig über Eleasar und Itamar, die Söhne Aarons, die noch übrig waren, und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Warum habt ihr das Sündopfer nicht gegessen an heiliger Stätte? Denn es ist hochheilig, und er hat es euch gegeben, daß ihr die Missetat der Gemeinde traget, um für sie Sühne zu erwirken vor dem HERRN! ");
INSERT INTO deu1951_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Siehe, sein Blut ist nicht in das Innere des Heiligtums hineingekommen; ihr hättet ihn im Heiligtum essen sollen, wie ich geboten habe. ");
INSERT INTO deu1951_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron aber sprach zu Mose: Siehe, heute haben sie ihr Sündopfer vor dem HERRN geopfert, und es ist mir solches widerfahren; sollte ich heute vom Sündopfer essen? Wäre es auch wohl getan in den Augen des HERRN? ");
INSERT INTO deu1951_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Als Mose solches hörte, war es wohlgefällig in seinen Augen. ");
INSERT INTO deu1951_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Und der HERR redete zu Mose und Aaron und sprach zu ihnen: ");
INSERT INTO deu1951_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Redet mit den Kindern Israel und sprechet: Das sind die Tiere, die ihr von allem Vieh auf Erden essen dürft: ");
INSERT INTO deu1951_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Alle Vielhufer, die ganz gespaltene Klauen haben und wiederkäuen, dürft ihr essen. ");
INSERT INTO deu1951_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Aber von den Wiederkäuern und Vielhufern sollt ihr die folgenden nicht essen: das Kamel; denn obschon es wiederkäut, hat es doch keine gespaltenen Klauen; darum soll es euch unrein sein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Desgleichen der Klippdachs; denn obschon er wiederkäut, hat er doch keine gespaltenen Klauen; darum ist er euch unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Auch der Hase, der zwar wiederkäut, aber er hat keine gespaltenen Klauen; darum ist er euch unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ferner das Schwein; es ist zwar ein Vielhufer mit durchgespaltenen Klauen, aber kein Wiederkäuer; darum ist es euch unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Von ihrem Fleisch sollt ihr nicht essen, auch ihr Aas nicht anrühren, denn sie sind euch unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Folgende Tiere dürft ihr essen von allem, was in den Wassern ist: Alles, was Flossen und Schuppen hat im Wasser, im Meer und in Bächen, dürft ihr essen. ");
INSERT INTO deu1951_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Aber alles, was keine Flossen und Schuppen hat, im Meer und in Bächen, unter allem Getier, das sich in den Wassern regt, und von allem, was im Wasser lebt, das soll euch ein Greuel sein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ein Greuel sollen sie euch sein; von ihrem Fleisch sollt ihr nicht essen und vor ihrem Aas euch scheuen. ");
INSERT INTO deu1951_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Alle Wassertiere, die keine Flossen und Schuppen haben, sollen euch ein Greuel sein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Von den Vögeln aber sollt ihr folgende verabscheuen; man soll sie nicht essen, weil sie ein Greuel sind: Den Adler, den Lämmergeier und den Seeadler, ");
INSERT INTO deu1951_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","die Weihe und das Falkengeschlecht, ");
INSERT INTO deu1951_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","die ganze Rabenfamilie, ");
INSERT INTO deu1951_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","den Strauß, die Eule, die Möwe und die Habichtarten; ");
INSERT INTO deu1951_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","das Käuzchen, den Reiher, den Ibis, ");
INSERT INTO deu1951_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","das Purpurhuhn, den Pelikan, den Schwan, ");
INSERT INTO deu1951_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","den Storch, die verschiedenen Strandläufer, den Wiedehopf und die Fledermaus. ");
INSERT INTO deu1951_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Jedes geflügelte Insekt, das auf vier Füßen geht, soll euch ein Greuel sein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Doch dürft ihr von den geflügelten Insekten, welche auf vier Füßen gehen, diejenigen essen, welche oberhalb ihrer Füße zwei Schenkel haben, vermittelst deren sie über den Erdboden hüpfen können. ");
INSERT INTO deu1951_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Von diesen dürft ihr essen die verschiedenen Arten der Wanderheuschrecke, der Feldheuschrecke, der Laubheuschrecke und der Fangheuschrecke. ");
INSERT INTO deu1951_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Aber alle übrigen geflügelten Insekten mit vier Füßen sollen euch ein Greuel sein, ");
INSERT INTO deu1951_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","und ihr würdet euch an ihnen verunreinigen; wer ihr Aas anrührt, der soll unrein sein bis zum Abend; ");
INSERT INTO deu1951_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","wer aber eines ihrer Aase aufhebt, der soll seine Kleider waschen und bleibt unrein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Jeder Vielhufer, der nicht zugleich durchgespaltene Klauen hat und wiederkäut, soll euch unrein sein; wer ihn anrührt, wird unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Auch alles, was auf seinen Tatzen geht unter den Vierfüßlern, soll euch unrein sein; wer ihr Aas anrührt, wird unrein sein bis zum Abend; ");
INSERT INTO deu1951_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","und wer ihr Aas aufhebt, der soll seine Keider waschen und bleibt unrein bis zum Abend; unrein sollen sie euch sein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Auch diese sollen euch unrein sein von den Tieren, die auf der Erde kriechen: Das Wiesel, die Maus, die verschiedenen Eidechsenarten; ");
INSERT INTO deu1951_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","der Mauergeko, der Dornschwanz, der Schleuderschwanz, der Salamander und das Chamäleon. ");
INSERT INTO deu1951_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Diese sollen euch unrein sein unter allem, was da kriecht; wer sie anrührt, wenn sie tot sind, bleibt unrein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Auch wird alles unrein, worauf eins von diesen Tieren fällt, wenn es tot ist, sei es ein hölzernes Gefäß oder ein Kleid, ein Fell oder ein Sack; ein Gerät aber, damit man Arbeit verrichtet, soll man ins Wasser legen, und es soll unrein bleiben bis zum Abend; dann wird es rein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Fällt aber eines jener Tiere in ein irdenes Geschirr, so wird sein ganzer Inhalt unrein, und ihr müßt es zerbrechen. ");
INSERT INTO deu1951_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Kommt von dem Wasser an irgendeine Speise, die man essen will, so wird sie unrein, desgleichen jedes Getränk, das man aus einem solchen Gefäß trinken würde. ");
INSERT INTO deu1951_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Alles wird unrein, worauf ein solches Aas fällt; wäre es ein Backofen oder Kochherd, so müßte er eingerissen werden; denn er wäre unrein und müßte euch für unrein gelten. ");
INSERT INTO deu1951_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nur ein Wassersammler, der von einer Quelle oder von einem Brunnen gespeist wird, bleibt rein; wer aber ein Aas anrührt, das hineinfällt, wird gleichwohl unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Auch wenn von solchem Aas auf irgendwelche Sämereien fällt, die man aussäen will, so bleiben sie rein; ");
INSERT INTO deu1951_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","wäre aber Wasser auf den Samen gegossen worden, und es fiele von solchem Aas darauf, so müßte er euch für unrein gelten. ");
INSERT INTO deu1951_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Stirbt ein Stück Vieh, das man sonst zu essen pflegt, so wird, wer sein Aas anrührt, unrein sein bis zum Abend; ");
INSERT INTO deu1951_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","wer aber von seinem Aase ißt, der soll seine Kleider waschen und bleibt unrein bis zum Abend; auch wer sein Aas aufhebt, muß seine Kleider waschen und bleibt unrein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Alles, was auf der Erde kriecht, soll euch ein Greuel sein und darf nicht gegessen werden. ");
INSERT INTO deu1951_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Alles, was auf dem Bauche kriecht, samt allem, was auf vier und mehr Füßen geht von dem, was auf der Erde kriecht, das sollt ihr nicht essen, sondern es soll euch ein Greuel sein. ");
INSERT INTO deu1951_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Macht eure Seelen nicht verabscheuungswürdig durch irgendein kriechendes Tier und verunreinigt euch nicht an ihnen, daß ihr durch sie verunreinigt werdet! ");
INSERT INTO deu1951_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Denn ich, der HERR, bin euer Gott; darum sollt ihr euch heiligen und sollt heilig sein; denn ich bin heilig; und ihr sollt eure Seelen nicht verunreinigen mit allerlei Gewürm, das auf der Erde kriecht! ");
INSERT INTO deu1951_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Denn ich, der HERR, bin es, der euch aus Ägyptenland heraufgeführt hat, um euer Gott zu sein; darum sollt ihr heilig sein; denn ich bin heilig! ");
INSERT INTO deu1951_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Dies ist das Gesetz von Vieh und Vögeln und allen lebendigen Wesen, die sich im Wasser regen und von allem Lebendigen, was auf Erden kriecht, ");
INSERT INTO deu1951_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","damit man unterscheide zwischen unrein und rein, zwischen dem, was man essen, und dem, was man nicht essen soll. ");
INSERT INTO deu1951_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Und der HERR redete zu Mose und sprach: Sage zu den Kindern Israel und sprich: ");
INSERT INTO deu1951_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Wenn ein Weib fruchtbar wird und ein Knäblein gebiert, so soll sie sieben Tage lang unrein sein, ebenso lange wie sie unrein ist, wenn sie unwohl wird, soll sie unrein sein. ");
INSERT INTO deu1951_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Und am achten Tage soll man das Fleisch seiner Vorhaut beschneiden. ");
INSERT INTO deu1951_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Und sie soll daheim bleiben dreiunddreißig Tage lang im Blut ihrer Reinigung; sie soll nichts Heiliges anrühren und nicht kommen zum Heiligtum, bis die Tage ihrer Reinigung erfüllt sind. ");
INSERT INTO deu1951_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Gebiert sie aber ein Mägdlein, so soll sie zwei Wochen lang unrein sein, wie bei ihrem Unwohlsein, und soll sechsundsechzig Tage lang daheim bleiben in dem Blut ihrer Reinigung. ");
INSERT INTO deu1951_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Und wenn die Tage ihrer Reinigung erfüllt sind für den Sohn oder für die Tochter, so soll sie dem Priester vor die Tür der Stiftshütte ein einjähriges Lamm zum Brandopfer und eine junge Taube oder eine Turteltaube zum Sündopfer bringen; ");
INSERT INTO deu1951_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","der soll es vor dem HERRN opfern und für sie Sühne erwirken, so wird sie rein von ihrem Blutfluß. Das ist das Gesetz für die, welche ein Knäblein oder Mägdlein gebiert. ");
INSERT INTO deu1951_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Vermag aber ihre Hand den Preis eines Schafes nicht, so nehme sie zwei Turteltauben oder zwei junge Tauben, eine zum Brandopfer und die andere zum Sündopfer, so soll der Priester für sie Sühne erwirken, daß sie rein werde. ");
INSERT INTO deu1951_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Und der HERR redete zu Mose und Aaron und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Wenn sich bei einem Menschen an der Haut seines Fleisches eine Geschwulst oder ein Schorf oder ein weißer Fleck zeigt, als wollte sich ein Aussatz bilden an der Haut des Fleisches, so soll man ihn zum Priester Aaron oder zu einem seiner Söhne unter den Priestern führen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Und wenn der Priester das Mal an der Haut seines Fleisches besieht und findet, daß die Haare im Mal weiß geworden sind, und daß das Mal tieferliegend erscheint als die Haut seines Fleisches, so ist es der Aussatz; sobald der Priester das sieht, soll er ihn für unrein erklären! ");
INSERT INTO deu1951_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Wenn aber der Fleck auf der Haut seines Fleisches weiß ist und nicht tieferliegend erscheint als die übrige Haut des Fleisches und seine Haare nicht weiß geworden sind, so soll der Priester das Mal sieben Tage lang einschließen, ");
INSERT INTO deu1951_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","und am siebenten Tag soll er es besichtigen. Ist das Mal gleich geblieben wie zuvor und hat nicht weitergefressen an der Haut, so soll es der Priester abermal sieben Tage lang einschließen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Und wenn ihn der Priester am siebenten Tage nochmals besieht und findet, daß das Mal blässer ist und nicht weitergefressen hat an der Haut, so soll ihn der Priester für rein erklären, denn es ist ein Ausschlag; und er soll seine Kleider waschen, so ist er rein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Wenn aber der Ausschlag weiter um sich greift an der Haut, nachdem er vom Priester besehen worden ist zu seiner Reinigung, so soll er sich dem Priester nochmals zeigen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Wenn dann der Priester sieht, daß der Ausschlag an der Haut weiter um sich gegriffen hat, so soll ihn der Priester für unrein erklären; denn es ist ein Aussatz. ");
INSERT INTO deu1951_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Zeigt sich ein Aussatzmal an einem Menschen, so soll man ihn zum Priester bringen; ");
INSERT INTO deu1951_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","sieht dieser an der Haut eine weiße Geschwulst und daß die Haare weiß geworden sind und daß rohes Fleisch in der Geschwulst ist, ");
INSERT INTO deu1951_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","so ist es ein alter Aussatz in der Haut seines Fleisches; darum soll ihn der Priester für unrein erklären und nicht einschließen; denn er ist schon unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Wenn aber der Aussatz an der Haut ausbricht und die ganze Haut des Betroffenen vom Kopf bis zu den Füßen bedeckt, soweit der Priester sehen kann, ");
INSERT INTO deu1951_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","und der Priester sieht, daß der Aussatz das ganze Fleisch bedeckt, so soll er den Betroffenen für rein erklären, weil er ganz weiß geworden ist; dann ist er rein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Sobald sich aber rohes Fleisch an ihm zeigt, so ist er unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Und wenn der Priester das rohe Fleisch sieht, soll er ihn für unrein erklären; denn das rohe Fleisch ist unrein; es ist der Aussatz. ");
INSERT INTO deu1951_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Verwandelt sich aber das rohe Fleisch wieder und wird weiß, so soll er zum Priester kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Und wenn der Priester bei der Besichtigung findet, daß das Mal weiß geworden ist, so soll er den Betroffenen für rein erklären, denn er ist rein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Wenn in jemandes Fleisch an der Haut ein Geschwür entsteht und wieder heilt, ");
INSERT INTO deu1951_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","es bildet sich aber an der Stelle des Geschwürs eine weiße Geschwulst oder ein weiß-rötlicher Fleck, so soll er sich dem Priester zeigen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Sieht aber der Priester, daß es tieferliegend erscheint als die übrige Haut und daß das Haar weiß geworden ist, so soll er ihn für unrein erklären; denn es ist ein Aussatzmal in dem Geschwür ausgebrochen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Sieht aber der Priester, daß die Haare nicht weiß sind, und daß es nicht tieferliegend ist als die übrige Haut, sondern blässer, so soll er ihn sieben Tage lang einschließen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Greift es weiter um sich an der Haut, so soll er ihn für unrein erklären; denn es ist ein Aussatzmal. ");
INSERT INTO deu1951_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Bleibt aber der weiße Fleck stehen und frißt nicht weiter, so ist es die Narbe des Geschwürs, und der Priester soll ihn für rein erklären. ");
INSERT INTO deu1951_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Wenn jemandes Fleisch an der Haut eine Brandwunde erhält, und es bildet sich in der Brandwunde ein weißrötlicher oder weißer Fleck; ");
INSERT INTO deu1951_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","und wenn der Priester es besieht und findet, daß das Haar weiß geworden ist an dem Fleck und daß er tieferliegend erscheint als die übrige Haut, so ist ein Aussatz in der Brandwunde entstanden; darum soll ihn der Priester für unrein erklären; denn es ist ein Aussatzmal. ");
INSERT INTO deu1951_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Sieht aber der Priester, daß die Haare an dem Fleck nicht weiß geworden sind und daß er nicht tieferliegend ist als die übrige Haut, so soll er ihn sieben Tage lang einschließen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Und am siebenten Tage soll er ihn besichten; hat es weitergefressen an der Haut, so soll er ihn für unrein erklären; denn es ist ein Aussatzmal. ");
INSERT INTO deu1951_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ist aber der Fleck stehengeblieben und hat nicht weitergefressen an der Haut, so ist es eine Geschwulst des Brandmals, und der Priester soll ihn für rein erklären; denn es ist die Narbe des Brandmals. ");
INSERT INTO deu1951_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Wenn ein Mann oder ein Weib auf dem Haupt oder am Bart ein Mal hat, ");
INSERT INTO deu1951_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","und der Priester das Mal besieht und findet, daß es tieferliegend erscheint als die übrige Haut, und das Haar daselbst goldgelb und dünn ist, so soll er ihn für unrein erklären; denn es ist der Grind, ein Aussatz am Haupt oder am Bart. ");
INSERT INTO deu1951_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Sieht aber der Priester, daß der Grind nicht tieferliegend erscheint als die Haut, und daß das Haar nicht goldgelb ist, so soll er den, der das Mal hat, sieben Tage lang einschließen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Und wenn er das Mal am siebenten Tage besieht und findet, daß der Grind nicht weitergefressen hat, und kein goldgelbes Haar da ist, und der Grind nicht tieferliegend erscheint als die übrige Haut, ");
INSERT INTO deu1951_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","so soll er sich scheren lassen, und der Priester soll den Grindigen abermal sieben Tage lang einschließen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Und wenn er ihn am siebenten Tage besieht und findet, daß der Grind in der Haut nicht weitergefressen hat und nicht tieferliegend erscheint als die übrige Haut, so soll ihn der Priester für rein erklären, und er soll seine Kleider waschen; denn er ist rein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Frißt aber der Grind weiter an der Haut, nach seiner Reinigung, ");
INSERT INTO deu1951_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","und der Priester besieht ihn und findet, daß der Grind an der Haut weitergefressen hat, so soll er nicht mehr darnach fragen, ob die Haare goldgelb seien; denn er ist unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ist aber das Aussehen des Grindes gleich geblieben und schwarzes Haar darin gewachsen, so ist der Grind geheilt, und er ist rein; darum soll ihn der Priester für rein erklären. ");
INSERT INTO deu1951_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Wenn sich bei einem Manne oder einem Weibe an der Haut ihres Fleisches weiße Flecken zeigen, ");
INSERT INTO deu1951_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","und der Priester sieht nach und findet in der Haut ihres Fleisches blasse weiße Flecken, so ist es ein Ausschlag, der an der Haut ausgebrochen ist, und der Betreffende ist rein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Wenn einem Mann die Haupthaare ausfallen, daß er hinten kahl wird, der ist rein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Fallen sie ihm vorn am Haupt aus, daß er vorn eine Glatze hat, so ist er rein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Entsteht aber an der hintern oder vordern Glatze ein weißrötliches Mal, so ist ihm ein Aussatz ausgebrochen an seiner hintern oder vordern Glatze. ");
INSERT INTO deu1951_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Darum soll ihn der Priester besehen, und wenn er findet, daß die Geschwulst des Males an seiner Hinter oder Vorderglatze weißrötlich ist, und wie ein Aussatz an der Haut des Fleisches anzusehen ist, ");
INSERT INTO deu1951_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","so ist er ein aussätziger Mann und unrein, und der Priester soll ihn für unrein erklären wegen des Mals auf seinem Kopf. ");
INSERT INTO deu1951_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Es soll aber der Aussätzige, der ein Mal an sich hat, in zerrissenen Kleidern einhergehen, mit entblößtem Haupt und verhüllten Lippen, und er soll ausrufen: Unrein, unrein! ");
INSERT INTO deu1951_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Solange das Mal an ihm ist, soll er unrein bleiben, denn er ist unrein; er soll abgesondert wohnen und außerhalb des Lagers seine Wohnung haben. ");
INSERT INTO deu1951_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Wenn an einem Kleide ein Aussatzmal ist, es sei wollen oder leinen; ");
INSERT INTO deu1951_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","am Zettel oder am Eintrag, es sei leinen oder wollen, oder an einem Fell, oder an irgend etwas, das aus Fellen gemacht wird; ");
INSERT INTO deu1951_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","und wenn das Mal grünlich oder rötlich ist am Kleid oder am Fell, oder am Zettel oder am Eintrag, oder an irgend etwas, das von Fellen gemacht wird, so ist es gewiß ein Aussatzmal. Darum soll es der Priester besehen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Und wenn er das Mal besehen hat, soll er es sieben Tage lang einschließen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Und wenn er am siebenten Tage sieht, daß das Mal weitergefressen hat am Kleid, am Zettel oder am Eintrag, am Fell oder an irgend etwas, das man aus Fellen macht, so ist es ein fressendes Aussatzmal und der Gegenstand ist unrein; ");
INSERT INTO deu1951_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","und er soll das Kleid verbrennen, oder den Zettel oder Eintrag, es sei wollen oder leinen, oder allerlei Fellwerk, darin ein solches Mal ist; denn es ist ein fressender Aussatz, und man soll es mit Feuer verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Sieht aber der Priester, daß das Mal nicht weitergefressen hat am Kleid oder am Zettel oder am Eintrag, oder an allerlei Fellwerk, ");
INSERT INTO deu1951_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","so soll er gebieten, daß man den Gegenstand, an welchem das Mal ist, wasche, und er soll es weitere sieben Tage lang einschließen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Und wenn der Priester sieht, nachdem das Mal gewaschen ist, daß das Mal seine Farbe nicht verändert und auch nicht weitergefressen hat, so ist es unrein; du sollst es mit Feuer verbrennen; es ist eine eingefressene Vertiefung an der hintern und vordern Seite. ");
INSERT INTO deu1951_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Wenn aber der Priester sieht, daß das Mal, nachdem es gewaschen worden, verblaßt ist, so soll er es abreißen vom Kleid, vom Fell, vom Zettel oder vom Eintrag. ");
INSERT INTO deu1951_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Wird es aber noch gesehen am Kleid, am Zettel, am Eintrag oder an allerlei Fellwerk, so ist es ein ausbrechender Aussatz; und du sollst den Gegenstand, an welchem ein solches Mal ist, mit Feuer verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Das Kleid aber oder den Zettel oder den Eintrag oder allerlei Fellwerk, das gewaschen und wovon das Mal entfernt ist, soll man nochmals waschen, so ist es rein. ");
INSERT INTO deu1951_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Das ist das Gesetz über das Aussatzmal an Kleidern, sie seien wollen oder leinen, am Zettel und am Eintrag und an allerlei Fellwerk, wonach sie für rein oder unrein zu erklären sind. ");
INSERT INTO deu1951_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Und der HERR redete zu Mose und sprach: Dieses Gesetz gilt für den Aussätzigen am Tage seiner Reinigung: ");
INSERT INTO deu1951_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Er soll zum Priester kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Und der Priester soll hinaus vor das Lager gehen, und wenn er nachsieht und findet, daß das Mal des Aussätzigen heil geworden ist, ");
INSERT INTO deu1951_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","so soll er gebieten, daß man für den, der sich reinigen läßt, zwei lebendige Vögel bringe, welche rein sind, und Zedernholz, Karmesin und Ysop; ");
INSERT INTO deu1951_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","und der Priester soll gebieten, daß man den einen Vogel schächte über einem irdenen Geschirr, darin lebendiges Wasser ist. ");
INSERT INTO deu1951_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Den lebendigen Vogel aber soll man nehmen samt dem Zedernholz, dem Karmesin und Ysop, und es samt dem lebendigen Vogel in des geschächteten Vogels Blut tauchen, das mit dem lebendigen Wasser vermischt worden ist; ");
INSERT INTO deu1951_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","und soll denjenigen siebenmal besprengen, der sich vom Aussatz reinigen läßt; also reinige er ihn und lasse den lebendigen Vogel in das freie Feld fliegen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Der zu Reinigende aber soll seine Kleider waschen und alle seine Haare abschneiden und sich mit Wasser baden; so ist er rein. Darnach gehe er in das Lager; doch soll er sieben Tage lang außerhalb seiner Hütte bleiben. ");
INSERT INTO deu1951_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Und am siebenten Tage soll er alle seine Haare abschneiden auf dem Haupte, am Bart und an den Augenbrauen, daß alle Haare abgeschoren seien, und soll seine Kleider waschen und sein Fleisch im Wasser baden, so ist er rein. ");
INSERT INTO deu1951_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Und am achten Tag soll er zwei tadellose Lämmer nehmen, und ein tadelloses jähriges Schaf, und drei Zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, und ein Log Öl. ");
INSERT INTO deu1951_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Da soll dann der Priester, der die Reinigung vollzogen hat, den zu Reinigenden und diese Dinge vor den HERRN stellen, vor die Tür der Stiftshütte; ");
INSERT INTO deu1951_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","und er soll das eine Lamm nehmen und es zum Schuldopfer darbringen samt dem Log Öl, und soll solches vor dem HERRN hin und her weben. ");
INSERT INTO deu1951_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Darnach soll er das Lamm schächten an dem Ort, da man das Sündopfer und das Brandopfer schächtet, an heiliger Stätte. Denn wie das Sündopfer, also gehört auch das Schuldopfer dem Priester: es ist hochheilig. ");
INSERT INTO deu1951_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Und der Priester soll von dem Blut des Schuldopfers nehmen und dem, der gereinigt werden soll, auf das rechte Ohrläpplein tun und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes. ");
INSERT INTO deu1951_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Darnach soll er von dem Log Öl nehmen und auf des Priesters linke Hand gießen, ");
INSERT INTO deu1951_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","und der Priester soll mit seinem rechten Finger in das Öl tunken, das in seiner linken Hand ist, und mit seinem Finger von dem Öl siebenmal vor dem HERRN sprengen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Das übrige Öl aber in seiner Hand soll er dem, der gereinigt werden soll, auf das rechte Ohrläpplein tun und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes, oben auf das Blut des Schuldopfers. ");
INSERT INTO deu1951_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Das übrige Öl aber in seiner Hand soll er auf des zu Reinigenden Haupt tun und ihn vor dem HERRN versühnen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Und der Priester soll das Sündopfer zurichten und für den zu Reinigenden Sühne erwirken wegen seiner Unreinigkeit, und soll darnach das Brandopfer schächten. ");
INSERT INTO deu1951_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Und er soll es auf dem Altar opfern samt dem Speisopfer und ihm Sühne erwirken; so ist er rein. ");
INSERT INTO deu1951_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ist er aber arm und vermag nicht so viel, so nehme er ein Lamm zum Schuldopfer, zum Webopfer, um für ihn Sühne zu erwirken, und einen Zehntel Semmelmehl, mit Öl gemengt, zum Speisopfer, und ein Log Öl, ");
INSERT INTO deu1951_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","und zwei Turteltauben oder zwei junge Tauben, je nach seinem Vermögen, die eine zum Sündopfer, die andere zum Brandopfer, ");
INSERT INTO deu1951_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","und bringe sie am achten Tage seiner Reinigung zum Priester, vor die Tür der Stiftshütte, vor den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Da soll der Priester das Lamm zum Schuldopfer nehmen, und das Öl, und soll beides vor dem HERRN zu einem Webopfer weben. ");
INSERT INTO deu1951_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Und er soll das Lamm des Schuldopfers schächten und das Blut von demselben nehmen und dem, der gereinigt werden soll, auf sein rechtes Ohrläpplein tun und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes; ");
INSERT INTO deu1951_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","und von dem Öl soll der Priester in seine linke Hand gießen, ");
INSERT INTO deu1951_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","und mit seinem rechten Finger vom Öl, das in seiner linken Hand ist, siebenmal vor dem HERRN sprengen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Darnach soll der Priester vom Öl in seiner Hand dem, der gereinigt werden soll, auf sein rechtes Ohrläpplein und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes tun, oben auf das Blut des Schuldopfers. ");
INSERT INTO deu1951_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Das übrige Öl in seiner Hand aber soll er dem zu Reinigenden auf das Haupt tun, um für ihn Sühne zu erwirken vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Darnach soll er eine der Turteltauben oder der jungen Tauben (was seine Hand aufzubringen vermochte) ");
INSERT INTO deu1951_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","zum Sündopfer zubereiten und die andere zum Brandopfer, samt dem Speisopfer; so soll der Priester für den, der gereinigt werden soll, Sühne erwirken vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Das ist das Gesetz für den Aussätzigen, der mit seiner Hand nicht aufbringen kann, was zu seiner Reinigung gehört. ");
INSERT INTO deu1951_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Und der HERR redete zu Mose und Aaron: ");
INSERT INTO deu1951_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Wenn ihr in das Land Kanaan kommt, das ich euch zur Besitzung gebe, und ich irgendein Haus des Landes eurer Besitzung mit einem Aussatz belege, ");
INSERT INTO deu1951_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","so soll der, dem das Haus gehört, kommen und es dem Priester anzeigen und sprechen: Es dünkt mich, als sei ein Aussatzmal an meinem Hause. ");
INSERT INTO deu1951_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Dann soll der Priester gebieten, daß man das Haus ausräume, ehe der Priester hineingeht, das Mal zu besehen, damit nicht alles unrein werde, was im Hause ist; darnach soll der Priester hineingehen, das Haus zu besehen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Wenn er nun das Mal besieht und findet, daß an der Wand des Hauses grüne oder rötliche Grüblein sind, die tieferliegend erscheinen als die übrige Wand, ");
INSERT INTO deu1951_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","so soll er zur Tür des Hauses hinausgehen und das Haus sieben Tage lang verschließen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Und wenn er am siebenten Tage wiederkommt und nachsieht und findet, daß das Mal an der Wand des Hauses weitergefressen hat, ");
INSERT INTO deu1951_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","so soll der Priester befehlen, daß man die Steine ausbreche, wo das Mal ist, und daß man sie vor die Stadt hinaus an einen unreinen Ort werfe; ");
INSERT INTO deu1951_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","und er soll befehlen, das Haus inwendig ringsum abzuschaben, und man soll den Schutt, den man abgeschabt hat, vor die Stadt hinaus an einen unreinen Ort schütten ");
INSERT INTO deu1951_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","und andere Steine nehmen und an jene Stelle tun und andern Mörtel nehmen und das Haus bewerfen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Wenn dann das Mal wieder kommt und am Hause ausbricht, nachdem man die Steine ausgebrochen und das Haus abgekratzt und neu beworfen hat, ");
INSERT INTO deu1951_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","so soll der Priester hineingehen; und wenn er sieht, daß das Mal am Hause weitergefressen hat, so ist es ein fressender Aussatz am Hause, und es ist unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Darum soll man das Haus abbrechen, seine Steine und sein Holz und allen Mörtel am Hause, und man soll es vor die Stadt hinaus an einen unreinen Ort führen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Und wer in das Haus geht, solang es verschlossen ist, der ist unrein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Und wer darin liegt, der soll seine Kleider waschen; auch wer darin ißt, der soll seine Kleider waschen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Wenn aber der Priester beim Betreten des Hauses sieht, daß das Mal nicht weitergefressen hat am Hause, nachdem das Haus neu beworfen ist, so soll er es für rein erklären; denn das Mal ist heil geworden. ");
INSERT INTO deu1951_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Und er soll für das Haus zum Sündopfer zwei Vögel nehmen, Zedernholz, Karmesin und Ysop, ");
INSERT INTO deu1951_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","und soll den einen Vogel schächten über einem irdenen Geschirr, darin lebendiges Wasser ist, ");
INSERT INTO deu1951_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","und soll das Zedernholz nehmen, den Ysop und das Karmesin und den lebendigen Vogel, und es in des geschächteten Vogels Blut tauchen und in das lebendige Wasser, und soll das Haus siebenmal besprengen. ");
INSERT INTO deu1951_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Und soll also das Haus entsündigen mit dem Blut des Vogels, mit dem lebendigen Wasser, mit dem lebendigen Vogel, mit dem Zedernholz, dem Ysop und Karmesin, ");
INSERT INTO deu1951_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","und soll den lebendigen Vogel vor die Stadt hinaus in das freie Feld fliegen lassen und für das Haus Sühne erwirken; so ist es rein. ");
INSERT INTO deu1951_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Dies ist das Gesetz über allerlei Aussatzmale und über den Grind, ");
INSERT INTO deu1951_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","auch über den Aussatz der Kleider und der Häuser ");
INSERT INTO deu1951_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","und über die Geschwulst, den Ausschlag und die weißen Flecken, ");
INSERT INTO deu1951_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","um Belehrung zu geben für den Tag der Verunreinigung und der Reinigung. Es ist das Gesetz vom Aussatz. ");
INSERT INTO deu1951_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Und der HERR redete zu Mose und Aaron und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Redet mit den Kindern Israel und sprecht zu ihnen: Wenn ein Mann einen Ausfluß hat, der von seinem Fleische fließt, so ist er unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Und zwar ist er unrein an diesem Flusse, wenn sein Fleisch den Ausfluß frei fließen läßt; auch wenn sein Fleisch verstopft wird von dem Ausflusse, so ist er unrein. ");
INSERT INTO deu1951_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Jedes Lager, worauf der mit einem Ausfluß Behaftete liegt, und alles, worauf er sitzt, wird unrein; ");
INSERT INTO deu1951_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","und wer sein Lager anrührt, soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis zum Abend; ");
INSERT INTO deu1951_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","und wer sich auf etwas setzt, worauf der mit einem Ausfluß Behaftete gesessen hat, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Wer sein Fleisch anrührt, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Wenn aber der mit einem Ausfluß Behaftete seinen Speichel auswirft auf einen, der rein ist, so soll dieser seine Kleider waschen und sich mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Auch der Sattel und alles, worauf der mit einem Ausfluß Behaftete reitet, wird unrein; ");
INSERT INTO deu1951_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","und wer immer etwas anrührt, das unter ihm gewesen ist, der wird unrein sein bis zum Abend. Und wer etwas solches trägt, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Und wen der mit einem Ausfluß Behaftete anrührt, ohne daß er zuvor die Hände mit Wasser gewaschen hat, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Wenn er ein irdenes Geschirr anrührt, so soll man es zerbrechen; aber jedes hölzerne Geschirr soll man mit Wasser waschen. ");
INSERT INTO deu1951_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Und wenn er von seinem Ausfluß rein wird, so soll er sieben Tage zählen zu seiner Reinigung, und seine Kleider waschen und sein Fleisch mit lebendigem Wasser baden; so ist er rein. ");
INSERT INTO deu1951_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Und am achten Tage soll er zwei Turteltauben oder zwei junge Tauben nehmen und vor den HERRN kommen, vor die Tür der Stiftshütte, und soll sie dem Priester geben. ");
INSERT INTO deu1951_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Und der Priester soll die eine zum Sündopfer, die andere zum Brandopfer machen und für ihn Sühne erwirken vor dem HERRN, wegen seines Ausflusses. ");
INSERT INTO deu1951_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Wenn einem Mann der Same entgeht, so soll er sein ganzes Fleisch mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Und jedes Kleid und jedes Fell, das mit solchem Samen befleckt ist, soll man mit Wasser waschen, und es bleibt unrein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Und wenn ein Mann bei einem Weibe liegt, daß ihm der Same entgeht, so sollen sie sich mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Wenn ein Weib ihres Fleisches Blutfluß hat, so soll sie sieben Tage lang in ihrer Unreinigkeit verbleiben. Wer sie anrührt, der bleibt unrein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Und alles, worauf sie in ihrer Unreinigkeit liegt, wird unrein; auch alles, worauf sie sitzt. ");
INSERT INTO deu1951_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Und wer ihr Lager anrührt, der soll seine Kleider waschen und sich mit Wasser baden und bleibt unrein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Und wer immer etwas anrührt, worauf sie gesessen hat, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Auch wer etwas anrührt, das auf ihrem Bette war oder worauf sie gesessen hat, soll unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Und wenn ein Mann bei ihr liegt, und es kommt ihre Unreinigkeit an ihn, der wird sieben Tage lang unrein sein, und das Lager, worauf er gelegen hat, wird unrein sein. ");
INSERT INTO deu1951_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Wenn aber ein Weib ihren Blutfluß eine lange Zeit hat, nicht nur zur gewöhnlichen Zeit, sondern auch über die gewöhnliche Zeit hinaus, so wird sie unrein sein während der ganzen Dauer ihres Flusses; wie in den Tagen ihrer Unreinigkeit soll sie auch dann unrein sein. ");
INSERT INTO deu1951_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Alles, worauf sie liegt während der ganzen Zeit ihres Flusses, soll sein wie das Lager ihrer monatlichen Unreinigkeit; auch alles, worauf sie sitzt, wird unrein sein, gleich wie zur Zeit ihrer monatlichen Unreinigkeit. ");
INSERT INTO deu1951_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Wer etwas davon anrührt, der wird unrein und soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis zum Abend. ");
INSERT INTO deu1951_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Wird sie aber rein von ihrem Flusse, so soll sie sieben Tage zählen, darnach soll sie rein sein. ");
INSERT INTO deu1951_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Und am achten Tage soll sie zwei Turteltauben oder zwei junge Tauben nehmen und sie zum Priester bringen vor die Tür der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Und der Priester soll die eine zum Sündopfer, die andere zum Brandopfer machen und ihr wegen des Flusses ihrer Unreinigkeit Sühne erwirken vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Also sollt ihr die Kinder Israel absondern um ihrer Unreinigkeit willen, damit sie in ihrer Unreinigkeit nicht sterben, wenn sie meine Wohnung verunreinigen, die unter ihnen ist. ");
INSERT INTO deu1951_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Dies ist das Gesetz über den, der einen Ausfluß hat, und über den, dem der Same entgeht, daß er unrein wird, ");
INSERT INTO deu1951_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","und über die, welche an ihrer Unreinigkeit leidet, und über solche, die einen Fluß haben, es sei ein Mann oder ein Weib, und über einen Mann, der bei einer Unreinen liegt. ");
INSERT INTO deu1951_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Und der Herr redete mit Mose nach dem Tod der beiden Söhne Aarons, als sie vor den HERRN traten. ");
INSERT INTO deu1951_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Und der HERR sprach zu Mose: Sage deinem Bruder Aaron, daß er nicht zu allen Zeiten in das Heiligtum hineingehe hinter den Vorhang vor den Sühndeckel, der auf der Lade ist, damit er nicht sterbe; denn ich will auf dem Sühndeckel in einer Wolke erscheinen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Damit soll Aaron hineingehen in das Heiligtum: mit einem jungen Farren zum Sündopfer und mit einem Widder zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","und er soll den heiligen leinenen Leibrock anziehen und soll ein leinenes Unterkleid an seinem Leibe haben und sich mit einem leinenen Gürtel gürten und einen leinenen Kopfbund umbinden (denn das sind die heiligen Kleider) und soll seinen Leib mit Wasser baden und sie anziehen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Dann soll er von der Gemeinde der Kinder Israel zwei Ziegenböcke nehmen zum Sündopfer und einen Widder zum Brandopfer. ");
INSERT INTO deu1951_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Und Aaron soll den Farren zum Sündopfer für sich selbst herzubringen und sich und seinem Haus Sühne erwirken. ");
INSERT INTO deu1951_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Darnach soll er die beiden Böcke nehmen und sie vor den HERRN stellen, vor die Tür der Stiftshütte, ");
INSERT INTO deu1951_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","und soll das Los werfen über die beiden Böcke, ein Los für den HERRN und ein Los für den Asasel. ");
INSERT INTO deu1951_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Und Aaron soll den Bock, auf welchen des HERRN Los fällt, zum Sündopfer machen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Aber den Bock, auf welchen das Los Asasels fällt, soll er lebendig vor den HERRN stellen, daß er über ihm die Sühne vollziehe und ihn zum Asasel in die Wüste jage. ");
INSERT INTO deu1951_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Und Aaron soll den Farren des Sündopfers, das für ihn selbst bestimmt ist, herzubringen und sich und seinem Haus Sühne erwirken und soll den Farren schächten zum Sündopfer für sich selbst. ");
INSERT INTO deu1951_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Darnach nehme er die Pfanne voll Glut vom Altar, der vor dem HERRN steht, und eine Handvoll wohlriechenden zerstoßenen Räucherwerks und bringe es hinein hinter den Vorhang; ");
INSERT INTO deu1951_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","und er tue das Räucherwerk auf das Feuer vor dem HERRN, damit die Wolke vom Räucherwerk den Sühndeckel, der auf dem Zeugnis ist, verhülle, damit er nicht sterbe. ");
INSERT INTO deu1951_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Er soll auch von dem Blut des Farren nehmen und mit seinem Finger gegen den Sühndeckel sprengen, gegen Aufgang. Siebenmal soll er also vor dem Sühndeckel mit seinem Finger vom Blute sprengen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Darnach soll er den Bock, das Sündopfer des Volkes schächten und von dessen Blut hinein hinter den Vorhang bringen, und soll mit dessen Blute tun, wie er mit des Farren Blut getan hat, und auch damit sprengen auf den Sühndeckel und vor denselben. ");
INSERT INTO deu1951_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Also soll er Sühne erwirken für das Heiligtum wegen der Unreinigkeiten der Kinder Israel und wegen ihrer Übertretungen und aller ihrer Sünden, und soll also tun mit der Stiftshütte, welche sich mitten unter ihren Unreinigkeiten befindet. ");
INSERT INTO deu1951_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kein Mensch soll in der Stiftshütte sein, wenn er hineingeht, um im Heiligtum die Sühne zu vollziehen, bis er wieder hinausgeht und die Sühne erwirkt hat für sich und sein Haus und die ganze Gemeinde Israel. ");
INSERT INTO deu1951_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Und wenn er zum Altar herauskommt, der vor dem HERRN steht, so soll er von dem Blut des Farren und von dem Blut des Bocks nehmen und auf die Hörner des Altars tun, ringsum, ");
INSERT INTO deu1951_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","und soll mit seinem Finger vom Blut siebenmal darauf sprengen und ihn reinigen und von der Unreinigkeit der Kinder Israel heiligen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Und wenn er die Sühne für das Heiligtum und die Stiftshütte und den Altar erwirkt hat, so soll er den lebendigen Bock herzu bringen, ");
INSERT INTO deu1951_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","und Aaron soll seine beiden Hände auf dieses lebendigen Bockes Kopf stützen und auf ihn alle Missetaten der Kinder Israel und alle ihre Übertretungen samt ihren Sünden bekennen, und soll sie dem Bock auf den Kopf legen und ihn durch einen Mann, der bereitsteht, in die Wüste jagen lassen; ");
INSERT INTO deu1951_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","daß also der Bock alle ihre Missetaten auf sich in eine Wildnis trage; und er soll ihn in der Wüste loslassen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Und Aaron soll in die Stiftshütte gehen und die leinenen Kleider ausziehen, die er anzog, als er in das Heiligtum ging, und soll sie daselbst lassen, ");
INSERT INTO deu1951_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","und soll seinen Leib mit Wasser baden an heiliger Stätte und seine eigenen Kleider anziehen und hinausgehen und sein und des Volkes Brandopfer verrichten, und Sühnung tun für sich und das Volk. ");
INSERT INTO deu1951_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Und das Fett des Sündopfers soll er auf dem Altar verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Der aber, welcher den Bock zum Asasel gejagt hat, soll seine Kleider waschen und seinen Leib mit Wasser baden und darnach in das Lager kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Den Farren des Sündopfers aber und den Bock des Sündopfers, deren Blut zur Sühnung in das Heiligtum gebracht worden ist, soll man hinaus vor das Lager führen und mit Feuer verbrennen, ihre Haut und ihr Fleisch und ihren Mist. ");
INSERT INTO deu1951_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Und der sie verbrannt hat, soll seine Kleider waschen und seinen Leib mit Wasser baden und darnach in das Lager kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Und das soll euch eine ewig gültige Ordnung sein: Am zehnten Tage des siebenten Monats sollt ihr eure Seelen demütigen und kein Werk tun, weder der Einheimische noch der Fremdling, der unter euch weilt. ");
INSERT INTO deu1951_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Denn an diesem Tage wird für euch Sühne erwirkt, euch zu reinigen; von allen euren Sünden sollt ihr vor dem HERRN gereinigt werden. ");
INSERT INTO deu1951_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Darum soll es euch ein Ruhe-Sabbat sein, und ihr sollt eure Seelen demütigen. Das sei eine ewige Ordnung. ");
INSERT INTO deu1951_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Diese Sühne soll ein Priester vollziehen, den man gesalbt und dessen Hand man gefüllt hat, daß er an seines Vaters Statt Priester sei; und er soll die leinenen Kleider anziehen, die heiligen Kleider, ");
INSERT INTO deu1951_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","und soll für das Heiligtum und die Stiftshütte und den Altar Sühne erwirken; auch den Priestern und der ganzen Volksgemeinde soll er Sühne schaffen. ");
INSERT INTO deu1951_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Das soll euch zur ewigen Gewohnheit weden, daß ihr für die Kinder Israel Sühne erwirkt wegen allen ihren Sünden, einmal im Jahr. Und man tat, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Sage Aaron und seinen Söhnen und allen Kindern Israel und sprich zu ihnen: Das ist's, was der HERR geboten hat, indem er sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Jedermann aus dem Hause Israel, der einen Ochsen, oder ein Lamm, oder eine Ziege im Lager oder außerhalb des Lagers schächtet, ");
INSERT INTO deu1951_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","und es nicht vor die Tür der Stiftshütte bringt, daß es dem HERRN zum Opfer gebracht werde vor der Wohnung des HERRN, dem soll es für eine Blutschuld gerechnet werden; er hat Blut vergossen, und es soll derselbe Mensch aus seinem Volk ausgerottet werden. ");
INSERT INTO deu1951_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Darum sollen die Kinder Israel fortan ihre Opfer, die sie jetzt noch auf freiem Felde opfern, vor den HERRN bringen, vor die Tür der Stiftshütte, zum Priester, um sie daselbst dem HERRN als Dankopfer darzubringen. ");
INSERT INTO deu1951_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Und der Priester soll das Blut auf den Altar des HERRN sprengen vor der Tür der Stiftshütte und das Fett verbrennen zum lieblichen Geruch dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Und sie sollen forthin ihre Opfer nicht mehr den Dämonen opfern, denen sie nachbuhlen. Das soll ihnen eine ewig gültige Ordnung sein auf alle ihre Geschlechter. ");
INSERT INTO deu1951_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Und du sollst zu ihnen sagen: Welcher Mensch aus dem Hause Israel oder welcher Fremdling, der unter ihnen wohnt, ein Brandopfer oder sonst ein Schlachtopfer verrichten will ");
INSERT INTO deu1951_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","und es nicht vor die Türe der Stiftshütte bringt, daß er es dem HERRN zurichte, der soll ausgerottet werden aus seinem Volk. ");
INSERT INTO deu1951_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Und wenn ein Mensch vom Hause Israel oder ein Fremdling, der unter ihnen wohnt, irgend Blut ißt, wider einen solchen, der Blut ißt, will ich mein Angesicht richten und ihn ausrotten aus seinem Volk; ");
INSERT INTO deu1951_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","denn die Seele des Fleisches ist im Blut, und ich habe es euch auf den Altar gegeben, um Sühne zu erwirken für eure Seelen. Denn das Blut ist es, das Sühne erwirkt durch die in ihm wohnende Seele. ");
INSERT INTO deu1951_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Darum habe ich den Kindern Israel gesagt: Keine Seele unter euch soll Blut essen; auch kein Fremdling unter euch soll Blut essen. ");
INSERT INTO deu1951_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Und wenn ein Mensch von den Kindern Israel oder ein Fremdling, der unter ihnen wohnt, auf der Jagd ein Wildpret oder Geflügel erwischt, das man essen darf, der soll desselben Blut ausgießen und mit Erde bedecken; ");
INSERT INTO deu1951_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","denn alles Fleisches Seele ist sein Blut; es ist mit seiner Seele verbunden. Darum habe ich den Kindern Israel gesagt: Ihr sollt keines Fleisches Blut essen; denn alles Fleisches Seele ist sein Blut. Wer es aber ißt, der soll ausgerottet werden. ");
INSERT INTO deu1951_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Jeder aber, der ein Aas oder Zerrissenes genießt, er sei ein Einheimischer oder ein Fremdling, der soll seine Kleider waschen und sich mit Wasser baden und unrein bleiben bis zum Abend, dann wird er rein. ");
INSERT INTO deu1951_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Wenn er aber sein Kleid nicht waschen und sein Fleisch nicht baden wird, so soll er seine Schuld tragen. ");
INSERT INTO deu1951_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Und der HERR redete zu Mose und sprach: Rede mit den Kindern Israel und sprich zu ihnen: ");
INSERT INTO deu1951_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Ich, der HERR, bin euer Gott! ");
INSERT INTO deu1951_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ihr sollt nicht tun, wie man im Lande Ägypten tut, wo ihr gewohnt habt, und sollt auch nicht tun, wie man in Kanaan tut, dahin ich euch führen will, und ihr sollt nicht nach ihren Satzungen wandeln; ");
INSERT INTO deu1951_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","sondern meine Rechte sollt ihr halten und meine Satzungen beobachten, daß ihr darin wandelt; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Und zwar sollt ihr meine Satzungen und meine Rechte beobachten, weil der Mensch, der sie tut, dadurch leben wird. Ich bin der HERR! ");
INSERT INTO deu1951_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Niemand soll sich seiner Blutsverwandten nahen, ihre Scham zu entblößen; ich bin der HERR! ");
INSERT INTO deu1951_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Du sollst die Scham deines Vaters und deiner Mutter nicht entblößen. Es ist deine Mutter, darum sollst du ihre Scham nicht entblößen. ");
INSERT INTO deu1951_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Du sollst die Scham des Weibes deines Vaters nicht entblößen; denn es ist die Scham deines Vaters. ");
INSERT INTO deu1951_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Du sollst die Scham deiner Schwester, die deines Vaters oder deiner Mutter Tochter ist, daheim oder draußen geboren, nicht entblößen. ");
INSERT INTO deu1951_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Die Scham der Tochter deines Sohns oder deiner Tochter Tochter, ihre Scham sollst du nicht entblößen, denn es ist deine Scham. ");
INSERT INTO deu1951_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Du sollst die Scham der Tochter deines Vaters Weibes, die deinem Vater geboren und deine Schwester ist, nicht entblößen. ");
INSERT INTO deu1951_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Du sollst die Scham der Schwester deines Vaters nicht entblößen, denn sie ist deines Vaters nächste Blutsverwandte. ");
INSERT INTO deu1951_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Du sollst die Scham der Schwester deiner Mutter nicht entblößen; denn sie ist deiner Mutter nächste Blutsverwandte. ");
INSERT INTO deu1951_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Du sollst die Scham des Bruders deines Vaters nicht entblößen, du sollst nicht zu seinem Weibe gehen; denn sie ist deine Base. ");
INSERT INTO deu1951_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Du sollst die Scham deiner Sohnsfrau nicht entblößen; denn sie ist deines Sohnes Weib, darum sollst du ihre Scham nicht entblößen. ");
INSERT INTO deu1951_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Du sollst die Scham des Weibes deines Bruders nicht entblößen, denn es ist deines Bruders Scham. ");
INSERT INTO deu1951_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Du sollst nicht zugleich die Scham eines Weibes und ihrer Tochter entblößen, noch ihres Sohnes Tochter oder ihrer Tochter Tochter nehmen, ihre Scham zu entblößen; denn sie ist ihre nächste Blutsverwandte; es wäre eine Schandtat. ");
INSERT INTO deu1951_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Du sollst auch nicht ein Weib zu ihrer Schwester hinzunehmen, wodurch Eifersucht erregt würde, wenn du ihre Scham entblößtest, während jene noch lebt. ");
INSERT INTO deu1951_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Du sollst nicht zum Weibe gehen während ihrer monatlichen Unreinigkeit, ihre Scham zu entblößen. ");
INSERT INTO deu1951_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Auch sollst du deines Nächsten Weib keinen Beischlaf gewähren, sie zu besamen, daß du dich mit ihr verunreinigest. ");
INSERT INTO deu1951_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Du sollst auch von deinen Kindern keines hergeben, daß es dem Moloch geopfert werde, damit du den Namen deines Gottes nicht entweihest; ich bin der HERR! ");
INSERT INTO deu1951_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Du sollst bei keiner Mannsperson liegen wie beim Weib; denn das ist ein Greuel. ");
INSERT INTO deu1951_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Auch sollst du den Beischlaf mit keinem Vieh vollziehen, daß du dich mit ihm verunreinigest. Und kein Weib soll sich zur Begattung vor ein Vieh stellen; das wäre abscheulich! ");
INSERT INTO deu1951_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ihr sollt euch durch nichts derartiges verunreinigen. Denn durch das alles haben sich die Heiden verunreinigt, die ich vor euch her ausstoßen will. ");
INSERT INTO deu1951_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Und dadurch ist das Land verunreinigt worden. Darum will ich ihre Missetat an ihm heimsuchen, daß das Land seine Einwohner ausspeie. ");
INSERT INTO deu1951_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ihr aber sollt meine Satzungen und Rechte beobachten und keinen dieser Greuel verüben, weder der Einheimische noch der Fremdling, der unter euch wohnt; ");
INSERT INTO deu1951_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","denn alle diese Greuel haben die Leute dieses Landes getan, die vor euch waren, wodurch das Land verunreinigt worden ist. ");
INSERT INTO deu1951_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Damit euch nun das Land nicht ausspeie, wenn ihr es verunreiniget, wie es die Heiden ausgespieen hat, die vor euch gewesen sind, ");
INSERT INTO deu1951_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","so soll jeder, der einen dieser Greuel tut, jede Seele, die dergleichen verübt, mitten aus ihrem Volk ausgerottet werden. ");
INSERT INTO deu1951_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","So beobachtet denn meine Verordnungen, daß ihr keinen von den greulichen Gebräuchen übet, die man vor euch geübt hat, und euch dadurch nicht verunreiniget. Ich, der HERR, bin euer Gott! ");
INSERT INTO deu1951_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Rede mit der ganzen Gemeinde der Kinder Israel und sprich zu ihnen: Ihr sollt heilig sein, denn Ich bin heilig, der HERR, euer Gott! ");
INSERT INTO deu1951_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Jedermann fürchte seine Mutter und seinen Vater und beobachte meine Sabbate; denn Ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ihr sollt euch nicht an die Götzen wenden und sollt euch keine gegossenen Götter machen, denn ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Und wenn ihr dem HERRN ein Dankopfer schlachten wollt, sollt ihr's so opfern, daß es euch angenehm macht. ");
INSERT INTO deu1951_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Es soll aber gegessen werden an dem Tage, da ihr es opfert, und am folgenden Tag; was aber bis zum dritten Tag übrigbleibt, das soll man mit Feuer verbrennen. ");
INSERT INTO deu1951_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Wird aber am dritten Tage davon gegessen, so ist es ein Greuel und wird nicht angenehm sein; ");
INSERT INTO deu1951_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","und wer davon ißt, wird seine Missetat tragen, weil er das Heiligtum des HERRN entheiligt hat, und eine solche Seele soll ausgerottet werden aus ihrem Volk. ");
INSERT INTO deu1951_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Wenn ihr die Ernte eures Landes einbringt, sollst du den Rand deines Ackers nicht vollständig abernten und keine Nachlese nach deiner Ernte halten. ");
INSERT INTO deu1951_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Auch sollst du nicht Nachlese halten in deinem Weinberg, noch die abgefallenen Beeren deines Weinberges auflesen, sondern du sollst es den Armen und Fremdlingen lassen; denn ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ihr sollt einander nicht bestehlen, nicht belügen noch betrügen! ");
INSERT INTO deu1951_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ihr sollt nicht falsch schwören bei meinem Namen und nicht entheiligen den Namen deines Gottes! Denn Ich bin der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Du sollst deinen Nächsten weder bedrücken noch berauben. Des Taglöhners Lohn soll nicht über Nacht bei dir bleiben bis zum Morgen. ");
INSERT INTO deu1951_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Du sollst dem Tauben nicht fluchen. Du sollst dem Blinden nichts in den Weg legen, sondern sollst dich fürchten vor deinem Gott; denn Ich bin der HERR! ");
INSERT INTO deu1951_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ihr sollt keine Ungerechtigkeit begehen im Gericht; du sollst weder die Person des Geringen ansehen, noch die Person des Großen ehren; sondern du sollst deinen Nächsten recht richten. ");
INSERT INTO deu1951_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Du sollst nicht als Verleumder umhergehen unter deinem Volk! Du sollst auch nicht auftreten wider deines Nächsten Blut! ");
INSERT INTO deu1951_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ich bin der HERR. Du sollst deinen Bruder nicht hassen in deinem Herzen; strafen sollst du deinen Nächsten, daß du nicht seinethalben Schuld tragen müssest! ");
INSERT INTO deu1951_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Du sollst nicht Rache üben, noch Groll behalten gegen die Kinder deines Volkes, sondern du sollst deinen Nächsten lieben wie dich selbst! Denn ich bin der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Meine Satzungen sollt ihr beobachten. Du sollst bei deinem Vieh nicht zweierlei Arten sich begatten lassen und dein Feld nicht besäen mit vermischtem Samen, und es soll kein Kleid auf deinen Leib kommen, das von zweierlei Garn gewoben ist. ");
INSERT INTO deu1951_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Wenn ein Mann bei einem Weibe liegt und sie beschläft, die eine Dienstmagd und einem andern versprochen, doch nicht losgekauft ist und die Freiheit nicht erlangt hat, die sollen gestraft werden, aber sie sollen nicht sterben; denn sie ist nicht frei gewesen. ");
INSERT INTO deu1951_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Er soll aber für seine Schuld dem HERRN vor die Tür der Stiftshütte einen Widder zum Schuldopfer bringen. ");
INSERT INTO deu1951_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Und der Priester soll ihm Sühne erwirken mit dem Schuldopferwidder vor dem HERRN wegen der Sünde, die er begangen hat; so wird ihm seine Sünde, die er getan hat, vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Wenn ihr in das Land kommt und allerlei Bäume pflanzet, wovon man ißt, sollt ihr die ersten Früchte derselben als Vorhaut betrachten. Drei Jahre lang sollt ihr sie für unbeschnitten achten und nicht davon essen. ");
INSERT INTO deu1951_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Im vierten Jahr aber sollen alle ihre Früchte heilig sein zu einer Jubelfeier für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Und im fünften Jahre sollt ihr die Früchte essen, daß der Ertrag umso größer werde; ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ihr sollt nichts mit Blut essen, ihr sollt keine Wahrsagerei, keine Zeichendeuterei treiben. ");
INSERT INTO deu1951_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ihr sollt den Rand eures Haupthaares nicht rundum stutzen, auch sollst du den Rand deines Bartes nicht beschädigen. ");
INSERT INTO deu1951_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ihr sollt keine Einschnitte an eurem Leibe machen für eine abgeschiedene Seele und sollt euch nicht tätowieren! Ich bin der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Du sollst deine Tochter nicht preisgeben, sie zur Unzucht anzuhalten, damit das Land nicht Unzucht treibe und voller Laster werde! ");
INSERT INTO deu1951_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Beobachtet meine Sabbattage und verehret mein Heiligtum! Ich bin der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ihr sollt euch nicht an die Totenbeschwörer wenden, noch an die Zeichendeuter; ihr sollt sie nicht fragen, auf daß ihr durch sie nicht verunreinigt werdet; denn ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Vor einem grauen Haupte sollst du aufstehen und alte Leute ehren und sollst dich fürchten vor deinem Gott; ich bin der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Wenn ein Fremdling bei dir in eurem Lande wohnen wird, so sollt ihr ihn nicht beleidigen. ");
INSERT INTO deu1951_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ihr sollt euch gegen den Fremdling, der sich bei euch aufhält, benehmen, als wäre er bei euch geboren, und du sollst ihn lieben wie dich selbst; denn ihr seid auch Fremdlinge in Ägypten gewesen. Ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ihr sollt euch nicht vergreifen weder am Recht noch an der Elle, noch am Gewicht, noch am Maß. ");
INSERT INTO deu1951_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Rechte Waage, gutes Gewicht, richtige Scheffel und rechte Eimer sollt ihr haben! Ich, der HERR, bin euer Gott, der ich euch aus Ägypten geführt habe; ");
INSERT INTO deu1951_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","darum sollt ihr alle meine Satzungen und alle meine Rechte beobachten und tun; ich bin der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Und der HERR redete zu Mose und sprach: Sage den Kindern Israel: ");
INSERT INTO deu1951_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Wer von den Kindern Israel oder den Fremdlingen, die in Israel wohnen, von seinem Samen dem Moloch gibt, der soll des Todes sterben; das Volk des Landes soll ihn steinigen! ");
INSERT INTO deu1951_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Und ich will mein Angesicht wider einen solchen Menschen setzen und ihn mitten aus seinem Volk ausrotten, weil er dem Moloch von seinem Samen gegeben und mein Heiligtum verunreinigt und meinen heiligen Namen entheiligt hat. ");
INSERT INTO deu1951_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Und wenn das Volk des Landes nachsichtig wäre gegen einen solchen Menschen, der von seinem Samen dem Moloch gegeben hat, daß es ihn nicht tötete, ");
INSERT INTO deu1951_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","so würde ich mein Angesicht wider jenen Menschen und wider sein Geschlecht richten und ihn und alle, die mit ihm dem Moloch nachgebuhlt haben, aus der Mitte ihres Volkes ausrotten. ");
INSERT INTO deu1951_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Auch wenn sich eine Seele zu den Totenbeschwörern und Zeichendeutern wendet und ihnen nachbuhlt, so will ich mein Angesicht wider diese Seele richten und sie aus der Mitte ihres Volkes ausrotten. ");
INSERT INTO deu1951_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Darum heiligt euch und seid heilig; denn ich, der HERR, bin euer Gott! ");
INSERT INTO deu1951_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Darum beobachtet meine Satzungen und tut sie; denn ich, der HERR, bin es, der euch heiligt. ");
INSERT INTO deu1951_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Wer seinem Vater oder seiner Mutter flucht, der soll unbedingt sterben! Sein Blut sei auf ihm; er hat seinem Vater oder seiner Mutter geflucht. ");
INSERT INTO deu1951_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Wenn einer die Ehe bricht mit einem Eheweib, so sollen beide unbedingt sterben, der Ehebrecher und die Ehebrecherin, weil er mit seines Nächsten Weib die Ehe gebrochen hat. ");
INSERT INTO deu1951_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Wer bei seines Vaters Weibe schläft, der hat die Scham seines Vaters entblößt; sie sollen beide unbedingt sterben; ihr Blut sei auf ihnen. ");
INSERT INTO deu1951_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Wenn jemand bei seiner Sohnsfrau schläft, so sollen sie beide unbedingt sterben; sie haben einen Greuel begangen; ihr Blut sei auf ihnen! ");
INSERT INTO deu1951_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Wenn ein Mann bei einer männlichen Person schläft, als wäre es ein Weib, die haben beide einen Greuel getan, und sie sollen unbedingt sterben; ihr Blut sei auf ihnen! ");
INSERT INTO deu1951_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Wenn jemand ein Weib nimmt und ihre Mutter dazu, so ist das eine Schandtat; man soll ihn samt den beiden Weibern mit Feuer verbrennen, damit keine solche Schandtat unter euch sei. ");
INSERT INTO deu1951_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Wenn ein Mann seinen Samen an ein Vieh abgibt, so soll er unbedingt sterben, und das Vieh soll man erwürgen. ");
INSERT INTO deu1951_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kommt ein Weib einem Vieh zu nahe, um sich mit ihm zu vermischen, so sollst du sie töten und das Vieh auch; sie sollen unbedingt sterben; ihr Blut sei auf ihnen! ");
INSERT INTO deu1951_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Wenn jemand seine Schwester nimmt, seines Vaters Tochter oder seiner Mutter Tochter, und ihre Scham beschaut und sie wieder seine Scham, so ist das eine Blutschande. Sie sollen ausgerottet werden vor den Augen ihres Volkes. Er hat seiner Schwester Scham entblößt, so trage er seine Schuld. ");
INSERT INTO deu1951_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Wenn ein Mann bei einer Frau liegt zur Zeit ihrer Krankheit und ihre Scham entblößt und ihren Brunnen aufdeckt, und sie den Brunnen ihres Blutes entblößt, so sollen beide aus ihrem Volk ausgerottet werden! ");
INSERT INTO deu1951_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Die Scham deiner Mutter Schwester und die Scham deines Vaters Schwester sollst du nicht entblößen; denn wer dies tut, hat seine Blutsverwandten entblößt; sie sollen ihre Schuld tragen! ");
INSERT INTO deu1951_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Wenn jemand bei der Frau des Bruders seines Vaters schläft, der hat die Scham seines Oheims entblößt; sie sollen ihre Sünde tragen, sie sollen kinderlos sterben! ");
INSERT INTO deu1951_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Wenn jemand seines Bruders Weib nimmt, so ist das eine schändliche Tat; sie sollen kinderlos bleiben, weil er die Scham seines Bruders entblößt hat. ");
INSERT INTO deu1951_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","So beobachtet nun alle meine Satzungen und meine Rechte und tut sie, damit euch nicht das Land ausspeie, wohin ich euch führe, daß ihr darinnen wohnet! ");
INSERT INTO deu1951_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Und wandelt nicht nach den Satzungen der Heiden, die ich vor euch her ausstoßen werde. Denn solches alles haben sie getan, daß mir vor ihnen ekelte. ");
INSERT INTO deu1951_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Euch aber habe ich gesagt: Ihr sollt ihr Land erblich besitzen; denn ich will euch dasselbe zum Erbe geben, ein Land, das von Milch und Honig fließt. Ich, der HERR, bin euer Gott, der ich euch von den Völkern abgesondert habe. ");
INSERT INTO deu1951_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","So sollt nun auch ihr das reine Vieh vom unreinen absondern und die unreinen Vögel von den reinen, und sollt eure Seelen nicht verabscheuungswürdig machen durch Vieh, Vögel und alles, was auf Erden kriecht, was ich euch als unrein abgesondert habe; ");
INSERT INTO deu1951_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","sondern ihr sollt mir heilig sein, denn ich, der HERR, bin heilig, der ich euch von den Völkern abgesondert habe, daß ihr mir angehöret! ");
INSERT INTO deu1951_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Wenn in einem Mann oder einem Weib ein Totenbeschwörer oder Wahrsagergeist steckt, so sollen sie unbedingt sterben. Man soll sie steinigen, ihr Blut sei auf ihnen! ");
INSERT INTO deu1951_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Und der HERR sprach zu Mose: Sage den Priestern, Aarons Söhnen, und sprich zu ihnen: Ein Priester soll sich an keinem Toten seines Volkes verunreinigen, ");
INSERT INTO deu1951_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","außer an seinem nächsten Blutsverwandten, der ihm zugehört; an seiner Mutter, an seinem Vater, an seinem Sohn, an seiner Tochter, an seinem Bruder, ");
INSERT INTO deu1951_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","und an seiner Schwester, die noch eine Jungfrau ist, die ihm nahesteht, weil sie noch keines Mannes Weib gewesen ist, an dieser mag er sich verunreinigen. ");
INSERT INTO deu1951_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Es soll sich der Vorgesetzte an seinem Volk nicht verunreinigen, damit er sich nicht entweihe. ");
INSERT INTO deu1951_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Sie sollen sich keine Glatze scheren auf ihrem Haupt, noch die Enden ihres Bartes stutzen, noch an ihrem Leibe Einschnitte machen. ");
INSERT INTO deu1951_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Sie sollen ihrem Gott heilig sein und den Namen ihres Gottes nicht entheiligen; denn sie opfern des HERRN Feueropfer, das Brot ihres Gottes, darum sollen sie heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Sie sollen keine Hure zum Weibe nehmen, auch keine Entehrte, noch eine, die von ihrem Mann verstoßen ist; denn der Priester ist heilig seinem Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Darum sollst du ihn für heilig halten; denn er opfert das Brot deines Gottes. Er soll dir heilig sein; denn heilig bin ich, der HERR, der euch heiligt. ");
INSERT INTO deu1951_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Wenn eines Priesters Tochter sich durch Unzucht entweiht, so hat sie ihren Vater entweiht; man soll sie mit Feuer verbrennen! ");
INSERT INTO deu1951_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Wer aber Hoherpriester ist unter seinen Brüdern, auf dessen Haupt das Salböl gegossen worden, und dem man die Hand gefüllt hat bei der Einkleidung, der soll sein Haupt nicht entblößen und seine Kleider nicht zerreißen. ");
INSERT INTO deu1951_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Er soll auch zu keinem Toten kommen und soll sich weder an seinem Vater noch an seiner Mutter verunreinigen. ");
INSERT INTO deu1951_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Er soll das Heiligtum nicht verlassen, noch das Heiligtum seines Gottes entheiligen; denn die Weihe des Salböls seines Gottes ist auf ihm; ich bin der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Er soll eine Jungfrau zum Weibe nehmen. ");
INSERT INTO deu1951_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Eine Witwe, oder eine Verstoßene, oder eine Entehrte, oder eine Hure soll er nicht nehmen; sondern eine Jungfrau aus seinem Volk soll er zum Weibe nehmen, ");
INSERT INTO deu1951_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","daß er seinen Samen nicht entweihe unter seinem Volk. Denn ich, der HERR, heilige ihn. ");
INSERT INTO deu1951_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Rede mit Aaron und sprich: Sollte jemand von deinen Nachkommen in ihren künftigen Geschlechtern mit irgend einem Gebrechen behaftet sein, so darf er sich nicht herzunahen, das Brot seines Gottes darzubringen. ");
INSERT INTO deu1951_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Nein, keiner, an dem ein Gebrechen ist, soll sich herzunahen, er sei blind oder lahm oder verstümmelt, oder habe ein zu langes Glied; ");
INSERT INTO deu1951_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","auch keiner, der einen gebrochenen Fuß oder eine gebrochene Hand hat, ");
INSERT INTO deu1951_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","oder der bucklig oder schwindsüchtig ist, oder der einen Fleck auf seinem Auge hat, oder die Krätze oder Flechten oder einen Hodenbruch. ");
INSERT INTO deu1951_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Wer nun von dem Samen Aarons, des Priesters, ein solches Gebrechen an sich hat, der soll sich nicht herzunahen, die Feueropfer des HERRN darzubringen; er hat ein Gebrechen; darum soll er das Brot seines Gottes nicht herzubringen, daß er es opfere. ");
INSERT INTO deu1951_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Doch darf er das Brot seines Gottes essen, vom Heiligen und vom Allerheiligsten. ");
INSERT INTO deu1951_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Aber zum Vorhang soll er nicht kommen, noch sich dem Altar nahen, weil er ein Gebrechen hat, daß er mein Heiligtum nicht entweihe; denn ich, der HERR, heilige sie. ");
INSERT INTO deu1951_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Und Mose sagte es Aaron und seinen Söhnen und allen Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Und der HERR redete zu Mose und sprach: Sage Aaron und seinen Söhnen, ");
INSERT INTO deu1951_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","daß sie sich enthalten sollen der heiligen Gaben der Kinder Israel, und meinen heiligen Namen nicht entweihen, in den Dingen, die sie mir geheiligt haben, mir, dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","So sage ihnen nun: Wer von euren Nachkommen, der von eurem Samen ist, sich dem Heiligen naht, das die Kinder Israel dem HERRN geheiligt haben, während er eine Unreinigkeit an sich hat; eine solche Seele soll von meinem Angesicht ausgerottet werden; ich bin der HERR! ");
INSERT INTO deu1951_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ist irgend jemand vom Samen Aarons aussätzig oder mit einem Ausfluß behaftet, so soll er von dem Heiligen nicht essen, bis er rein wird. Und wer etwas durch einen Entseelten Verunreinigtes anrührt, oder wem der Same entgeht, ");
INSERT INTO deu1951_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","oder wer irgend ein Gewürm anrührt, durch das man unrein wird, oder einen Menschen, an dem man sich verunreinigen kann wegen irgend etwas, was ihn unrein macht; ");
INSERT INTO deu1951_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","welche Seele solches anrührt, die ist unrein bis zum Abend und soll nicht von dem Heiligen essen, sondern soll zuvor ihren Leib mit Wasser baden. ");
INSERT INTO deu1951_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Und wenn die Sonne untergegangen und sie rein geworden ist, dann mag sie von dem Heiligen essen; denn es ist ihre Speise. ");
INSERT INTO deu1951_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kein Aas noch Zerrissenes soll er essen, daß er nicht unrein davon werde; ich bin der HERR! ");
INSERT INTO deu1951_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Sie sollen meine Anordnungen beobachten, damit sie nicht Sünde auf sich laden und daran sterben, wenn sie dieselben entheiligen; denn ich, der HERR, heilige sie. ");
INSERT INTO deu1951_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kein Fremdling soll von dem Heiligen essen. ");
INSERT INTO deu1951_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Wenn aber der Priester eine Seele um Geld erkauft, so mag dieselbe davon essen. Und wer ihm in seinem Hause geboren wird, der mag auch von seinem Brot essen. ");
INSERT INTO deu1951_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Wenn aber des Priesters Tochter eines Fremdlings Weib wird, soll sie nicht von dem Hebopfer des Heiligen essen. ");
INSERT INTO deu1951_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Wird aber des Priesters Tochter eine Witwe oder eine Verstoßene und hat keine Kinder und kommt wieder in ihres Vaters Haus, wie in ihrer Jugend, so soll sie von ihres Vaters Brot essen. Aber kein Fremdling soll davon essen. ");
INSERT INTO deu1951_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Wer sonst aber aus Versehen von dem Geheiligten ißt, der soll den fünften Teil dazutun und es dem Priester mit dem Geheiligten geben, ");
INSERT INTO deu1951_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","damit sie nicht die heiligen Gaben der Kinder Israel entheiligen, welche diese dem HERRN heben, ");
INSERT INTO deu1951_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","daß sie sich nicht mit Missetat und Schuld beladen, wenn sie ihr Geheiligtes essen; denn ich, der HERR, heilige sie. ");
INSERT INTO deu1951_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Weiter redete der HERR zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Sage Aaron und seinen Söhnen und allen Kindern Israel und sprich zu ihnen: Wer vom Hause Israel oder von den Fremdlingen in Israel sein Opfer bringen will (sei es, daß sie es nach ihren Gelübden oder ganz freiwillig dem HERRN zum Brandopfer darbringen wollen), ");
INSERT INTO deu1951_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","der opfere, damit es euch angenehm mache, ein tadelloses Männlein, von den Rindern, Lämmern oder Ziegen. ");
INSERT INTO deu1951_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Nichts Gebrechliches sollt ihr opfern; denn es würde euch nicht angenehm machen. ");
INSERT INTO deu1951_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Und wenn jemand dem HERRN ein Dankopfer bringen will, sei es zur Erfüllung eines Gelübdes oder als freiwillige Gabe, von Rindern oder Schafen, so soll es tadellos sein, zum Wohlgefallen. Es soll keinen Mangel haben. ");
INSERT INTO deu1951_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ein Blindes oder Gebrochenes oder Verwundetes oder eines, das Geschwüre oder die Krätze oder Flechten hat, sollt ihr dem HERRN nicht opfern und davon kein Feueropfer bringen auf den Altar des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Einen Ochsen, oder ein Schaf, das zu lange oder zu kurze Glieder hat, magst du als freiwillige Gabe opfern, aber zur Erfüllung eines Gelübdes wäre es nicht angenehm. ");
INSERT INTO deu1951_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ihr sollt auch dem HERRN kein Tier darbringen, welches verschnittene oder zerdrückte oder abgerissene oder abgeschnittene Hoden hat, und sollt in eurem Lande solches gar nicht tun. ");
INSERT INTO deu1951_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Auch von der Hand eines Fremdlings sollt ihr deren keines eurem Gott zur Speise darbringen; denn sie haben eine Verstümmelung, einen Makel an sich; sie werden euch nicht gnädig aufgenommen. ");
INSERT INTO deu1951_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Wenn ein Rind oder ein Lamm, oder eine Ziege geboren wird, so soll es sieben Tage lang bei seiner Mutter bleiben; erst vom achten Tag an ist es angenehm zum Feueropfer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ihr sollt aber kein Rind noch Schaf zugleich mit seinem Jungen am gleichen Tag schächten. ");
INSERT INTO deu1951_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Wenn ihr aber dem HERRN ein Lobopfer darbringen wollt, so opfert es zu eurer Begnadigung. ");
INSERT INTO deu1951_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ihr sollt es am gleichen Tag essen und nichts übriglassen bis zum Morgen; ich bin der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Ihr aber sollt meine Gebote beobachten und sie tun; ich bin der HERR! ");
INSERT INTO deu1951_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Und ihr sollt meinen heiligen Namen nicht entheiligen; sondern ich will geheiligt werden unter den Kindern Israel, ich, der HERR, der euch heiligt; ");
INSERT INTO deu1951_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","der ich euch aus dem Lande Ägypten geführt habe, um euer Gott zu sein, ich, der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Und der HERR redete zu Mose und sprach: Sage den Kindern Israel und sprich zu ihnen: ");
INSERT INTO deu1951_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Das sind die Feste des HERRN, da ihr heilige Festversammlungen einberufen sollt; das sind meine Feste: ");
INSERT INTO deu1951_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sechs Tage lang soll man arbeiten, aber am siebenten Tag ist die Sabbatfeier, eine heilige Versammlung; da sollt ihr kein Werk tun; denn es ist der Sabbat des HERRN, in allen euren Wohnorten. ");
INSERT INTO deu1951_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Das sind aber die Feste des HERRN, die heiligen Versammlungen, die ihr zu festgesetzten Zeiten einberufen sollt: ");
INSERT INTO deu1951_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Am vierzehnten Tag des ersten Monats, gegen Abend, ist das Passah des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Und am fünfzehnten Tage desselben Monats ist das Fest der ungesäuerten Brote des HERRN. Da sollt ihr sieben Tage lang ungesäuertes Brot essen. ");
INSERT INTO deu1951_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Am ersten Tag sollt ihr eine heilige Versammlung halten; ");
INSERT INTO deu1951_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","da sollt ihr keine Werktagsarbeit verrichten und ihr sollt dem HERRN sieben Tage lang Feueropfer darbringen. Am siebenten Tag ist heilige Versammlung, da sollt ihr keine Werktagsarbeit verrichten. ");
INSERT INTO deu1951_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Sage den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommt, das ich euch geben werde, und seine Ernte einheimset, so sollt ihr die Erstlingsgarbe von eurer Ernte zum Priester bringen. ");
INSERT INTO deu1951_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Der soll die Garbe weben vor dem HERRN, zu eurer Begnadigung; am Tage nach dem Sabbat soll sie der Priester weben. ");
INSERT INTO deu1951_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ihr sollt aber an dem Tage, wenn eure Garbe gewebt wird, dem HERRN ein Brandopfer zurichten von einem tadellosen einjährigen Lamm; ");
INSERT INTO deu1951_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","dazu sein Speisopfer, zwei Zehntel Semmelmehl, mit Öl gemengt, ein Feueropfer dem HERRN zum lieblichen Geruch; samt seinem Trankopfer, einem Viertel Hin Wein. ");
INSERT INTO deu1951_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ihr sollt aber weder Brot noch geröstetes Korn noch zerriebene Körner essen bis zu dem Tag, da ihr eurem Gott diese Gabe darbringt. Das ist eine ewig gültige Ordnung für alle eure Geschlechter. ");
INSERT INTO deu1951_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Darnach sollt ihr vom Tage nach dem Sabbat, von dem Tage, da ihr die Webegarbe darbringt, sieben volle Wochen abzählen bis zum Tag, ");
INSERT INTO deu1951_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","der auf den siebenten Sabbat folgt, nämlich fünfzig Tage sollt ihr zählen, und alsdann dem HERRN ein neues Speisopfer darbringen. ");
INSERT INTO deu1951_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ihr sollt nämlich aus euren Wohnsitzen zwei Webebrote bringen, von zwei Zehntel Semmelmehl zubereitet; die sollen gesäuert und dem HERRN zu Erstlingen gebacken werden. ");
INSERT INTO deu1951_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Zu dem Brot aber sollt ihr sieben einjährige, tadellose Lämmer darbringen und einen jungen Farren und zwei Widder; das soll des HERRN Brandopfer sein; dazu ihr Speisopfer und ihr Trankopfer; ein Feueropfer, dem HERRN zum lieblichen Geruch. ");
INSERT INTO deu1951_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ihr sollt auch einen Ziegenbock zum Sündopfer und zwei einjährige Lämmer zum Dankopfer zurichten; ");
INSERT INTO deu1951_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","und der Priester soll sie samt den Erstlingsbroten weben, nebst den beiden Lämmern, als Webopfer vor dem HERRN. Die sollen dem HERRN heilig sein und dem Priester gehören. ");
INSERT INTO deu1951_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Und ihr sollt an demselben Tag ausrufen lassen: «Man soll eine heilige Versammlung abhalten und keine Werktagsarbeit verrichten!» Das ist eine ewig gültige Satzung für alle eure Wohnorte und Geschlechter. ");
INSERT INTO deu1951_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Wenn ihr aber die Ernte eures Landes einbringt, so sollst du dein Feld nicht bis an den Rand abernten und nicht selbst Nachlese halten, sondern es dem Armen und Fremdling überlassen. Ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Rede mit den Kindern Israel und sprich: Am ersten Tag des siebenten Monats sollt ihr einen Feiertag halten, einen Gedächtnistag unter Posaunenklang, eine heilige Versammlung. ");
INSERT INTO deu1951_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ihr sollt keine Werktagsarbeit verrichten, sondern dem HERRN Feueropfer darbringen. ");
INSERT INTO deu1951_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Am zehnten Tag in diesem siebenten Monat ist der Versöhnungstag, da sollt ihr eine heilige Versammlung halten und eure Seelen demütigen und dem HERRN Feueropfer darbringen; ");
INSERT INTO deu1951_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","und ihr sollt an diesem Tage keine Arbeit verrichten; denn es ist der Versöhnungstag, zu eurer Versöhnung vor dem HERRN, eurem Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Welche Seele sich aber an diesem Tage nicht demütigt, die soll ausgerottet werden aus ihrem Volk; ");
INSERT INTO deu1951_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","und welche Seele an diesem Tag irgend eine Arbeit verrichtet, die will ich vertilgen mitten aus ihrem Volk. ");
INSERT INTO deu1951_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ihr sollt keine Arbeit verrichten. Das ist eine ewig gültige Ordnung für eure Geschlechter an allen euren Wohnorten. ");
INSERT INTO deu1951_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ihr sollt Sabbatruhe halten und eure Seelen demütigen. Am neunten Tage des Monats, am Abend, sollt ihr die Feier beginnen, und sie soll währen von einem Abend bis zum andern. ");
INSERT INTO deu1951_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Rede mit den Kindern Israel und sprich: Am fünfzehnten Tage des siebenten Monats soll dem HERRN das Laubhüttenfest gefeiert werden, sieben Tage lang. ");
INSERT INTO deu1951_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Am ersten Tage ist heilige Versammlung; da sollt ihr keine Arbeit verrichten. ");
INSERT INTO deu1951_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sieben Tage lang sollt ihr dem HERRN Feueropfer darbringen und am achten Tag eine heilige Versammlung halten und dem HERRN Feueropfer darbringen; es ist Festversammlung; da sollt ihr keine Arbeit verrichten. ");
INSERT INTO deu1951_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Das sind die Feste des HERRN, da ihr heilige Versammlungen einberufen sollt, um dem HERRN Feueropfer, Brandopfer, Speisopfer, Schlachtopfer und Trankopfer darzubringen, ein jedes an seinem Tag ");
INSERT INTO deu1951_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","außer den Sabbaten des HERRN und außer euren Gaben, den gelobten und freiwilligen Gaben, die ihr dem HERRN gebet. ");
INSERT INTO deu1951_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","So sollt ihr nun am fünfzehnten Tage des siebenten Monats, wenn ihr den Ertrag des Landes eingebracht habt, das Fest des HERRN halten, sieben Tage lang; am ersten Tag ist Feiertag und am achten Tag ist auch Feiertag. ");
INSERT INTO deu1951_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ihr sollt aber am ersten Tag Früchte nehmen von schönen Bäumen, Palmenzweige und Zweige von dichtbelaubten Bäumen und Bachweiden, und sieben Tage lang fröhlich sein vor dem HERRN, eurem Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Und sollt also dem HERRN das Fest halten, sieben Tage lang im Jahr. Das soll eine ewige Ordnung sein für eure Geschlechter, daß ihr im siebenten Monat also feiert. ");
INSERT INTO deu1951_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Sieben Tage lang sollt ihr in Laubhütten wohnen; alle Landeskinder in Israel sollen in Laubhütten wohnen, ");
INSERT INTO deu1951_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","damit eure Nachkommen wissen, wie ich die Kinder Israel in Hütten wohnen ließ, als ich sie aus Ägypten führte; ich, der Herr, euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Und Mose erklärte den Kindern Israel die Feiertage des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Und der HERR redete zu Mose und sprach: Gebiete den Kindern Israel, ");
INSERT INTO deu1951_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","daß sie zu dir bringen lauteres Öl aus zerstossenen Oliven für den Leuchter, um beständig Licht zu unterhalten! ");
INSERT INTO deu1951_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Draußen vor dem Vorhang des Zeugnisses, in der Stiftshütte, soll es Aaron zurichten, daß es stets brenne vor dem HERRN, vom Abend bis zum Morgen; eine ewige Ordnung für eure Geschlechter. ");
INSERT INTO deu1951_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Auf dem reinen Leuchter soll er die Lampen zurichten, vor dem HERRN, beständig. ");
INSERT INTO deu1951_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Und du sollst Semmelmehl nehmen und davon zwölf Kuchen backen; ein Kuchen soll aus zwei Zehnteln bestehen. ");
INSERT INTO deu1951_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Du sollst sie in zwei Schichten von je sechs Stück auf den reinen Tisch legen vor den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Du sollst auf jede Schicht reinen Weihrauch legen, damit dieser die Brote in Erinnerung bringe, wenn er verbrannt wird vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Jeden Sabbat soll er sie stets vor dem HERRN aufschichten als Gabe von den Kindern Israel, laut ewigem Bund. ");
INSERT INTO deu1951_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Und sie sollen Aaron und seinen Söhnen gehören; die sollen sie essen an heiliger Stätte; denn das ist ein hochheiliger, ewig festgesetzter Anteil für ihn von den Feueropfern des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Es ging aber der Sohn eines israelitischen Weibes, der einen ägyptischen Vater hatte, unter den Kindern Israel aus und ein. Dieser Sohn des israelitischen Weibes und ein Israelite zankten im Lager miteinander. ");
INSERT INTO deu1951_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Da lästerte der Sohn des israelitischen Weibes den Namen Gottes und fluchte. Darum brachte man ihn zu Mose. Seine Mutter aber hieß Selomit und war die Tochter Dibris, vom Stamme Dan. ");
INSERT INTO deu1951_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Und sie behielten ihn in Haft, bis ihnen Bescheid würde durch den Mund des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Führe den Flucher vor das Lager hinaus und laß alle, die es gehört haben, ihre Hand auf sein Haupt stützen, und die ganze Gemeinde soll ihn steinigen. ");
INSERT INTO deu1951_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Und sage den Kindern Israel und sprich: Wer seinem Gott flucht, der soll seine Sünde tragen; ");
INSERT INTO deu1951_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","und wer den Namen des HERRN lästert, der soll unbedingt sterben! Die ganze Gemeinde soll ihn steinigen, er sei ein Fremdling oder ein Einheimischer; wenn er den Namen lästert, so soll er sterben! ");
INSERT INTO deu1951_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Auch wenn jemand einen Menschen erschlägt, so soll er unbedingt sterben. ");
INSERT INTO deu1951_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Wer aber ein Vieh erschlägt, der soll es bezahlen; Seele um Seele! ");
INSERT INTO deu1951_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Bringt aber einer seinem Nächsten eine Verletzung bei, so soll man ihm tun, wie er getan hat: ");
INSERT INTO deu1951_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Bruch um Bruch, Auge um Auge, Zahn um Zahn; die Verletzung, die er dem andern zugefügt hat, soll man ihm auch zufügen; ");
INSERT INTO deu1951_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","also daß, wer ein Vieh erschlägt, der soll es bezahlen; wer aber einen Menschen erschlägt, der soll sterben. ");
INSERT INTO deu1951_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ihr sollt ein einheitliches Recht haben für Fremdlinge und Einheimische; denn ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mose aber sagte solches den Kindern Israel; die führten den Flucher vor das Lager hinaus und steinigten ihn. Also taten die Kinder Israel, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Und der HERR redete zu Mose auf dem Berge Sinai und sprach: ");
INSERT INTO deu1951_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Rede mit den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommt, das ich euch geben werde, so soll das Land dem HERRN einen Sabbat feiern. ");
INSERT INTO deu1951_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Sechs Jahre lang sollst du dein Feld besäen und sechs Jahre lang deine Reben beschneiden und ihre Früchte einsammeln. ");
INSERT INTO deu1951_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Aber im siebenten Jahr soll das Land seinen Ruhesabbat haben, den Sabbat des HERRN, da du dein Feld nicht besäen, noch deine Reben beschneiden sollst. ");
INSERT INTO deu1951_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Auch was nach deiner Ernte von sich selber wächst, sollst du nicht ernten; und die Trauben deines unbeschnittenen Weinstocks sollst du nicht ablesen, weil es ein Sabbatjahr des Landes ist. ");
INSERT INTO deu1951_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Und dieser Landessabbat soll euch Nahrung bringen, dir und deinen Knechten und deiner Magd, deinem Taglöhner, deinen Beisaßen und deinem Fremdling bei dir; ");
INSERT INTO deu1951_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","deinem Vieh und den Tieren in deinem Lande soll sein ganzer Ertrag zur Speise dienen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Und du sollst dir sieben solche Sabbatjahre abzählen, daß siebenmal sieben Jahre gezählt werden, und die Zeit der sieben Sabbatjahre beträgt neunundvierzig Jahre. ");
INSERT INTO deu1951_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Da sollst du den Schall der Posaune ertönen lassen am zehnten Tage des siebenten Monats; am Tage der Versöhnung sollt ihr den Schall durch euer ganzes Land ergehen lassen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Und ihr sollt das fünfzigste Jahr heiligen und sollt ein Freijahr ausrufen im Lande allen, die darin wohnen, denn es ist das Jubeljahr. Da soll ein jeder bei euch wieder zu seiner Habe und zu seinem Geschlecht kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Denn das fünfzigste ist das Jubeljahr. Ihr sollt nicht säen, auch nicht ernten, was von sich selber wächst, auch den unbeschnittenen Weinstock nicht ablesen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Denn das Jubeljahr soll unter euch heilig sein; vom Feld weg dürft ihr essen, was es trägt. ");
INSERT INTO deu1951_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In diesem Jubeljahr soll jedermann wieder zu seinem Besitztum kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Wenn du nun deinem Nächsten etwas verkaufst oder demselben etwas abkaufst, so soll keiner seinen Bruder übervorteilen; ");
INSERT INTO deu1951_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","sondern nach der Zahl der Jahre, nach dem Jubeljahr sollst du es von ihm kaufen; und nach der Zahl des jährlichen Ertrages soll er es dir verkaufen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nach der Menge der Jahre sollst du den Kaufpreis steigern, und nach der geringen Anzahl der Jahre sollst du den Kaufpreis verringern; denn eine bestimmte Anzahl von Ernten verkauft er dir. ");
INSERT INTO deu1951_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","So übervorteile nun keiner seinen Nächsten; sondern fürchte dich vor deinem Gott; denn ich, der HERR, bin euer Gott! ");
INSERT INTO deu1951_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Darum haltet meine Satzungen und beobachtet meine Rechte, daß ihr sie tut; so sollst du sicher wohnen im Lande, ");
INSERT INTO deu1951_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","und das Land soll euch seine Früchte geben, daß ihr genug zu essen habt und sicher darin wohnt. ");
INSERT INTO deu1951_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Und wenn ihr sagen würdet: Was sollen wir im siebenten Jahre essen? Denn wir säen nicht und sammeln auch keine Früchte ein! ");
INSERT INTO deu1951_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","so will ich im sechsten Jahr meinem Segen gebieten, daß es euch Früchte für drei Jahre liefern soll; ");
INSERT INTO deu1951_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","daß, wenn ihr im achten Jahre säet, ihr noch von den alten Früchten esset bis in das neunte Jahr; daß ihr von dem Alten esset bis wieder neue Früchte kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ihr sollt das Land nicht als unablöslich verkaufen; denn das Land ist mein, und ihr seid Fremdlinge und Beisaßen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Und ihr sollt im ganzen Lande eurer Besitzung die Wiedereinlösung des Landes zulassen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Wenn dein Bruder verarmt und dir etwas von seiner Habe verkauft, so soll derjenige als Löser für ihn eintreten, der sein nächster Verwandter ist; derselbe soll lösen, was sein Bruder verkauft hat. ");
INSERT INTO deu1951_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Wenn aber jemand keinen Löser hat, kann aber mit seiner Hand so viel zuwege bringen, als zur Wiedereinlösung nötig ist, ");
INSERT INTO deu1951_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","so soll er die Jahre, die seit dem Verkauf verflossen sind, abrechnen und für den Rest den Käufer entschädigen, damit er selbst wieder zu seiner Habe komme. ");
INSERT INTO deu1951_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Vermag er ihn aber nicht zu entschädigen, so soll das, was er verkauft hat, in der Hand des Käufers bleiben bis zum Jubeljahr; alsdann soll es frei ausgehen, und er soll wieder zu seiner Habe kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Wer ein Wohnhaus verkauft innerhalb der Stadtmauern, der hat zur Wiedereinlösung Frist bis zur Vollendung des Verkaufsjahres. Ein Jahr lang besteht für ihn das Rückkaufsrecht. ");
INSERT INTO deu1951_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Wenn es aber nicht gelöst wird bis zum Ablauf eines vollen Jahres, so sollen der Käufer und seine Nachkommen dasselbe Haus innerhalb der Stadtmauern als unablöslich behalten; es soll im Jubeljahr nicht frei ausgehen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Dagegen sind die Häuser in den Dörfern ohne Ringmauern dem Ackerland gleich zu rechnen; sie sind ablösbar und sollen im Jubeljahr frei ausgehen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Was aber die Levitenstädte anbetrifft, die Häuser in den Städten ihres Besitztums, so haben die Leviten das ewige Einlösungsrecht. ");
INSERT INTO deu1951_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Und wenn jemand etwas von den Leviten erwirbt, so geht das verkaufte Haus in der Stadt seines Besitztums im Jubeljahr frei aus; denn die Häuser in den Städten der Leviten sind ihr Besitztum unter den Kindern Israel; ");
INSERT INTO deu1951_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","und die Weideplätze bei ihren Städten dürfen nicht verkauft werden, denn sie sind ihr ewiges Eigentum. ");
INSERT INTO deu1951_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Wenn dein Bruder verarmt neben dir und sich nicht mehr zu halten vermag, so sollst du ihm Hilfe leisten, er sei ein Fremdling oder Beisaße, daß er bei dir leben kann. ");
INSERT INTO deu1951_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Du sollst keinen Zins noch Wucher von ihm nehmen, sondern sollst dich fürchten vor deinem Gott, daß dein Bruder neben dir leben könne. ");
INSERT INTO deu1951_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Du sollst ihm dein Geld nicht auf Zins, noch deine Speise um Wucherpreise geben. ");
INSERT INTO deu1951_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ich, der HERR, bin euer Gott, der ich euch aus Ägyptenland geführt habe, daß ich euch das Land Kanaan gebe und euer Gott sei. ");
INSERT INTO deu1951_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Wenn dein Bruder neben dir verarmt und dir sich selbst verkauft, sollst du ihn im Dienst nicht als einen leibeigenen Knecht halten; ");
INSERT INTO deu1951_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","als Taglöhner und Beisaße soll er bei dir gelten und dir bis zum Jubeljahr dienen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Alsdann soll er frei von dir ausgehen, und seine Kinder mit ihm, und soll wieder zu seinem Geschlecht und zu seiner Väter Habe kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Denn auch sie sind meine Knechte, die ich aus Ägyptenland geführt habe. Darum soll man sie nicht wie Sklaven verkaufen! ");
INSERT INTO deu1951_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Du sollst nicht mit Strenge über ihn herrschen, sondern sollst dich fürchten vor deinem Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Willst du aber leibeigene Knechte und Mägde haben, so sollst du sie kaufen von den Heiden, die um euch her sind. ");
INSERT INTO deu1951_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ihr könnt sie auch kaufen von den Kindern der Beisaßen, die sich bei euch aufhalten, und von ihren Geschlechtern bei euch, die in eurem Lande geboren sind; dieselben sollt ihr zu eigen haben, ");
INSERT INTO deu1951_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","und sollst sie vererben auf eure Kinder nach euch zum leibeigenen Besitz, daß sie euch ewiglich dienen. Aber über eure Brüder, die Kinder Israel, sollt ihr nicht, einer über den andern, mit Strenge herrschen! ");
INSERT INTO deu1951_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Wenn die Hand eines Fremdlings oder Beisaßen bei dir etwas erwirbt, und dein Bruder neben ihm verarmt und sich dem Fremdling, welcher ein Beisaße bei dir ist, oder einem Abkömmling von seinem Stamm verkauft, ");
INSERT INTO deu1951_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","so soll er, nachdem er sich verkauft hat, das Loskaufsrecht behalten; einer von seinen Brüdern soll ihn lösen; ");
INSERT INTO deu1951_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","oder sein Vetter oder seines Vetters Sohn mag ihn lösen, oder sonst sein nächster Blutsverwandter aus seinem Geschlecht kann ihn lösen; oder wenn seine Hand so viel erwirbt, so soll er sich selbst lösen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Er soll aber mit seinem Käufer rechnen von dem Jahr an, da er sich ihm verkauft hat, bis zum Jubeljahr. Und der Preis seines Verkaufs soll nach der Zahl der Jahre berechnet werden, und er soll diese Zeit wie ein Taglöhner bei ihm sein. ");
INSERT INTO deu1951_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Sind noch viele Jahre übrig, so soll er dementsprechend von dem Kaufpreis als Lösegeld zurückerstatten; ");
INSERT INTO deu1951_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","sind aber wenig Jahre übrig bis zum Jubeljahr, so soll er darauf Rücksicht nehmen; nach der Zahl der Jahre soll er sein Lösegeld bezahlen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Wie ein Taglöhner soll er Jahr für Jahr bei ihm sein; er aber soll nicht mit Strenge über ihn herrschen vor deinen Augen. ");
INSERT INTO deu1951_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Löst er sich aber nicht auf einem dieser Wege, so soll er im Jubeljahr frei ausgehen und seine Kinder mit ihm; ");
INSERT INTO deu1951_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","denn die Kinder Israel sind mir dienstbar; sie sind meine Knechte, die ich aus Ägypten geführt habe, ich, der HERR, euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ihr sollt keine Götzen machen, keine gemeißelten Bilder, und sollt euch keine Säulen aufrichten, auch keine Steinbilder setzen in eurem Lande, daß ihr euch davor bücket; denn ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Beobachtet meine Sabbate und verehret mein Heiligtum; ich bin der HERR! ");
INSERT INTO deu1951_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Werdet ihr nun in meinen Satzungen wandeln und meine Gebote befolgen und sie tun, ");
INSERT INTO deu1951_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","so will ich euch Regen geben zu seiner Zeit, und das Land soll sein Gewächs geben und die Bäume auf dem Felde ihre Früchte bringen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Und die Dreschzeit wird reichen bis zur Weinlese, und die Weinlese bis zur Saatzeit, und ihr werdet euch von eurem Brot satt essen und sollt sicher wohnen in eurem Lande. ");
INSERT INTO deu1951_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Denn ich will Frieden geben im Lande, daß ihr schlafet und euch niemand erschrecke. Ich will die bösen Tiere aus eurem Lande vertreiben, und es soll kein Schwert über euer Land kommen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ihr werdet eure Feinde jagen, daß sie vor euch her durchs Schwert fallen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Euer fünf werden hundert jagen, und euer hundert werden zehntausend jagen, und eure Feinde werden vor euch her durchs Schwert fallen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Und ich will mich zu euch wenden und euch wachsen und zunehmen lassen und meinen Bund mit euch aufrechthalten. ");
INSERT INTO deu1951_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Und ihr werdet von dem Vorjährigen essen und das Vorjährige wegen der Menge des Neuen hinwegtun. ");
INSERT INTO deu1951_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ich will meine Wohnung unter euch haben, und meine Seele soll euch nicht verwerfen: ");
INSERT INTO deu1951_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","und ich will unter euch wandeln und euer Gott sein, und ihr sollt mein Volk sein. ");
INSERT INTO deu1951_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ich, der HERR, bin euer Gott, der ich euch aus Ägypten geführt habe, daß ihr nicht ihre Knechte sein solltet; und ich zerbrach die Stäbe eures Joches und ließ euch aufrecht gehen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Werdet ihr mir aber nicht folgen und nicht alle diese Gebote erfüllen, ");
INSERT INTO deu1951_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","und werdet ihr meine Satzungen verachten, und wird eure Seele gegen meine Rechte einen Widerwillen haben, daß ihr nicht alle meine Gebote tut, sondern meinen Bund brechet, ");
INSERT INTO deu1951_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","so will auch ich euch solches tun: Ich will euch heimsuchen mit Schrecken, Schwindsucht und Fieberhitze, davon die Augen matt werden und die Seele verschmachtet. Ihr werdet eure Saat vergeblich bestellen; denn eure Feinde sollen sie essen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Und ich will mein Angesicht gegen euch richten, daß ihr vor euren Feinden geschlagen werdet; und die euch hassen, sollen über euch herrschen, und ihr werdet fliehen, wenn euch niemand jagt. ");
INSERT INTO deu1951_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Werdet ihr mir aber daraufhin noch nicht gehorchen, so will ich euch noch siebenmal ärger strafen um eurer Sünden willen, ");
INSERT INTO deu1951_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","daß ich euren harten Stolz breche. Ich will euren Himmel machen wie Eisen und eure Erde wie Erz, ");
INSERT INTO deu1951_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","daß eure Mühe und Arbeit vergeblich aufgewendet sei, und euer Land sein Gewächs nicht gebe und die Bäume des Landes ihre Früchte nicht bringen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Setzet ihr mir aber noch weitern Widerstand entgegen und wollt mir nicht gehorchen, so will ich euch noch siebenmal mehr schlagen, entsprechend euren Sünden. ");
INSERT INTO deu1951_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Und ich will wilde Tiere unter euch senden, die sollen euch euer Kinder berauben und euer Vieh verderben und euer weniger machen, und eure Straßen sollen wüste werden. ");
INSERT INTO deu1951_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Werdet ihr euch aber dadurch noch nicht züchtigen lassen, sondern mir trotzig begegnen, ");
INSERT INTO deu1951_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","so will auch ich euch trotzig begegnen und euch siebenfältig schlagen um eurer Sünden willen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Und ich will ein Racheschwert über euch kommen lassen, eine Bundesrache! Da werdet ihr euch in euren Städten sammeln; ich aber will Pestilenz unter euch senden und euch in eurer Feinde Hand geben. ");
INSERT INTO deu1951_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Und ich werde euch den Stab des Brotes zerbrechen, daß zehn Weiber euer Brot in einem Ofen backen mögen, und man wird euch das Brot nach dem Gewicht zuteilen; und ihr werdet es essen, aber nicht satt werden. ");
INSERT INTO deu1951_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Werdet ihr aber auch dadurch noch nicht zum Gehorsam gegen mich gebracht, sondern mir trotzig begegnen, ");
INSERT INTO deu1951_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","so will ich auch euch mit grimmigem Trotz begegnen und euch siebenfältig strafen um eurer Sünden willen, ");
INSERT INTO deu1951_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","daß ihr eurer Söhne und Töchter Fleisch fressen müßt! ");
INSERT INTO deu1951_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Und ich will eure Höhen vertilgen und eure Sonnensäulen abhauen und eure Leichname auf die Leichname eurer Götzen werfen, und meine Seele wird euch verabscheuen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Und ich will eure Städte öde machen und eure heiligen Städte verwüsten und euren lieblichen Geruch verabscheuen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Also will ich das Land wüste machen, daß eure Feinde, die darinnen wohnen werden, sich davor entsetzen sollen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Euch aber will ich unter die Heiden zerstreuen und das Schwert hinter euch her ausziehen, daß euer Land zur Wüste und eure Städte zu Ruinen werden. ");
INSERT INTO deu1951_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Alsdann wird das Land seine Sabbate genießen, solange es wüste liegt, und ihr in eurer Feinde Land seid. Ja alsdann wird das Land feiern und seine Sabbate genießen dürfen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Solange es wüste liegt, wird es feiern, weil es nicht feiern konnte an euren Sabbaten, als ihr darin wohntet. ");
INSERT INTO deu1951_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Denen aber, die von euch übrigbleiben, will ich das Herz verzagt machen in ihrer Feinde Land, daß ein rauschendes Blatt sie jagen wird; und sie werden davonfliehen, als jage sie ein Schwert, und fallen, ohne daß sie jemand verfolgt. ");
INSERT INTO deu1951_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Und sie sollen übereinander fallen; wie vor dem Schwert, obschon sie niemand jagt; und ihr werdet euren Feinden nicht widerstehen können, ");
INSERT INTO deu1951_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","sondern werdet unter den Heiden umkommen, und eurer Feinde Land wird euch fressen. ");
INSERT INTO deu1951_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Welche von euch aber übrigbleiben, die sollen ob ihrer Missetat verschmachten, in eurer Feinde Land; und ob der Missetat ihrer Väter sollen sie verschmachten wie sie. ");
INSERT INTO deu1951_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Werden sie aber ihre und ihrer Väter Missetat bekennen samt ihrer Übertretung, womit sie sich an mir vergriffen haben und mir trotzig begegnet sind, ");
INSERT INTO deu1951_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","weswegen auch ich ihnen widerstand und sie in ihrer Feinde Land brachte; und wird sich alsdann ihr unbeschnittenes Herz demütigen, so daß sie dann ihre Schuld büßen, ");
INSERT INTO deu1951_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","so will ich gedenken an meinen Bund mit Jakob und an meinen Bund mit Isaak und an meinen Bund mit Abraham, und will des Landes gedenken. ");
INSERT INTO deu1951_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Aber das Land wird von ihnen verlassen sein und seine Sabbate genießen, indem es um ihretwillen wüste liegt, und sie werden ihre Schuld büßen, darum und deswegen, weil sie meine Rechte verachtet und ihre Seele meine Satzungen verabscheut hat. ");
INSERT INTO deu1951_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Jedoch, wenn sie gleich in der Feinde Land sein werden, so will ich sie nicht gar verwerfen und sie nicht also verabscheuen, daß ich sie gar aufreibe oder meinen Bund mit ihnen breche; denn ich, der HERR, bin ihr Gott. ");
INSERT INTO deu1951_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Und ich will für sie an meinen ersten Bund gedenken, als ich sie aus Ägypten führte vor den Augen der Heiden, daß ich ihr Gott wäre, ich, der HERR. ");
INSERT INTO deu1951_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Das sind die Satzungen, die Rechte und Gesetze, die der HERR auf dem Berge Sinai durch die Hand Moses gegeben hat, daß sie zwischen ihm und den Kindern Israel bestehen sollten. ");
INSERT INTO deu1951_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Und der HERR redete zu Mose und sprach: Rede mit den Kindern Israel und sprich zu ihnen: ");
INSERT INTO deu1951_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Wenn jemand dem HERRN ein besonderes Gelübde tut, wenn er nach deiner Schätzung Seelen gelobt, ");
INSERT INTO deu1951_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","so sollst du sie also schätzen: Einen Mann, vom zwanzigsten bis zum sechzigsten Jahr sollst du schätzen auf fünfzig Schekel Silber, nach dem Schekel des Heiligtums. ");
INSERT INTO deu1951_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ist es aber ein Weib, so sollst du sie auf dreißig Schekel schätzen. ");
INSERT INTO deu1951_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Im Alter von fünf bis zwanzig Jahren sollst du ihn schätzen auf zwanzig Schekel, wenn es ein Knabe ist, aber auf zehn Schekel, wenn es ein Mädchen ist. ");
INSERT INTO deu1951_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Im Alter von einem Monat bis zu fünf Jahren sollst du ihn schätzen auf fünf Schekel Silber, wenn es ein Knabe ist, aber auf drei Schekel Silber, wenn es ein Mädchen ist. ");
INSERT INTO deu1951_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Im Alter von sechzig aber und darüber sollst du ihn auf fünfzehn Schekel schätzen, wenn es ein Mann ist, auf zehn Schekel, wenn es ein Weib ist. ");
INSERT INTO deu1951_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Vermag er aber nicht soviel zu bezahlen, wie du ihn schätzest, so soll er sich vor den Priester stellen, und der Priester soll ihn schätzen nach dem Vermögen dessen, der das Gelübde getan hat. ");
INSERT INTO deu1951_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ist es aber ein Vieh, von dem, was man dem HERRN opfern kann, so soll jedes Stück, das man von solchem Vieh dem HERRN gibt, heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Man soll es nicht auswechseln noch vertauschen, ein gutes für ein schlechtes oder ein schlechtes für ein gutes; sollte es aber jemand auswechseln, ein Vieh für das andere, so würde es samt dem zur Auswechslung bestimmten Stück dem HERRN heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ist aber das Tier unrein, daß man es dem HERRN nicht opfern darf, so soll man es vor den Priester stellen; ");
INSERT INTO deu1951_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","und der Priester soll es schätzen, je nachdem es gut oder schlecht ist; und bei der Schätzung des Priesters soll es bleiben. ");
INSERT INTO deu1951_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Will es aber jemand lösen, so soll er den fünften Teil deiner Schätzung dazugeben. ");
INSERT INTO deu1951_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Wenn jemand sein Haus dem HERRN zum Heiligtum weiht, so soll es der Priester schätzen, je nachdem es gut oder schlecht ist; und wie es der Priester schätzt, so soll es gelten. ");
INSERT INTO deu1951_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Will es aber derjenige lösen, der es geheiligt hat, so soll er den fünften Teil dazulegen; dann gehört es ihm. ");
INSERT INTO deu1951_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Wenn jemand dem HERRN ein Stück Feld von seinem Erbgut weiht, so soll es von dir geschätzt werden nach dem Maß der Aussaat; der Raum für die Aussaat von einem Homer Gerste soll fünfzig Schekel Silber gelten. ");
INSERT INTO deu1951_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Weiht er sein Feld vor dem Jubeljahr, so soll es nach deiner Schatzung gelten. ");
INSERT INTO deu1951_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Weiht er aber das Feld nach dem Jubeljahr, so soll der Priester den Betrag berechnen nach den übrigen Jahren bis zum nächsten Jubeljahr und es je nachdem geringer schätzen. ");
INSERT INTO deu1951_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Wenn aber der, welcher das Feld geweiht hat, es lösen will, so soll er den fünften Teil über die Schatzungssumme dazulegen, dann bleibt es sein. ");
INSERT INTO deu1951_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Will er es aber nicht lösen, sondern verkauft es einem andern, so kann es nicht mehr gelöst werden; ");
INSERT INTO deu1951_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","sondern es soll dasselbige Feld, wenn es im Jubeljahr frei ausgeht, dem HERRN heilig sein, wie ein mit dem Bann belegtes Feld; es fällt dem Priester als Erbgut zu. ");
INSERT INTO deu1951_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Wenn aber jemand dem HERRN ein Stück Feld weiht, das er gekauft hat und das nicht sein Erbgut ist, ");
INSERT INTO deu1951_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","so soll ihm der Priester den Betrag nach deiner Schatzung berechnen bis zum Jubeljahr, und er soll an demselben Tage den Schatzungswert geben, daß es dem HERRN geweiht sei. ");
INSERT INTO deu1951_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Aber im Jubeljahr soll das Feld wieder an den Verkäufer zurückfallen, nämlich an den, welchem das Land als Erbteil gehört. ");
INSERT INTO deu1951_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Alle deine Schätzung aber soll nach dem Schekel des Heiligtums geschehen. Ein Schekel macht zwanzig Gera. ");
INSERT INTO deu1951_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Doch soll niemand die Erstgeburt unter dem Vieh weihen, die dem HERRN schon als Erstgeburt gehört, es sei ein Ochs oder Schaf; es ist des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ist es aber ein unreines Vieh, so soll man es lösen nach deiner Schätzung und den fünften Teil darüber geben. Will man es nicht lösen, so soll es nach deiner Schätzung verkauft werden. ");
INSERT INTO deu1951_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nur soll man kein mit dem Bann Belegtes verkaufen oder lösen, nichts, das jemand dem HERRN gebannt, von allem, was sein ist, es seien Menschen, Vieh oder Äcker seines Besitztums; denn alles Gebannte ist dem HERRN hochheilig! ");
INSERT INTO deu1951_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Man soll auch keinen mit dem Bann belegten Menschen lösen, sondern er soll unbedingt sterben! ");
INSERT INTO deu1951_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Alle Zehnten des Landes, sowohl von der Saat des Landes als auch von den Früchten der Bäume, gehören dem HERRN und sollen dem HERRN heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Will aber jemand etwas von seinem Zehnten lösen, der soll den fünften Teil darübergeben. ");
INSERT INTO deu1951_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Und alle Zehnten von Rindern und Schafen, von allem, was unter dem Hirtenstab hindurchgeht, soll jedes zehnte Stück dem HERRN heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Man soll nicht untersuchen, ob es gut oder schlecht sei, man soll es auch nicht auswechseln; sollte es aber jemand auswechseln, so würde es samt dem zur Auswechslung bestimmten Stück heilig sein und könnte nicht gelöst werden. ");
INSERT INTO deu1951_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Das sind die Gebote, die der HERR Mose befohlen hat an die Kinder Israel, auf dem Berge Sinai. ");
INSERT INTO deu1951_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Und der HERR redete mit Mose in der Wüste Sinai in der Stiftshütte am ersten Tag des zweiten Monats im zweiten Jahr, nachdem sie aus dem Lande Ägypten gezogen waren, und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Ermittelt die Zahl der ganzen Gemeinde der Kinder Israel, nach ihren Geschlechtern und ihren Vaterhäusern, nach der Zahl der Namen, alles, was männlich ist, Kopf für Kopf; ");
INSERT INTO deu1951_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","von zwanzig Jahren an und darüber, alle wehrpflichtigen Männer in Israel; und zählet sie nach ihren Heerhaufen, du und Aaron. ");
INSERT INTO deu1951_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Und es soll von jedem Stamm das Oberhaupt der Vaterhäuser seines Stammes bei euch sein. ");
INSERT INTO deu1951_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Das sind aber die Namen der Männer, die euch zur Seite stehen sollen: Von Ruben Elizur, der Sohn Sedeurs; ");
INSERT INTO deu1951_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","von Simeon Selumiel, der Sohn Zuri-Schaddais; ");
INSERT INTO deu1951_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","von Juda Nahasson, der Sohn Amminadabs; ");
INSERT INTO deu1951_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","von Issaschar Netaneel, der Sohn Zuars; ");
INSERT INTO deu1951_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","von Sebulon Eliab, der Sohn Helons; ");
INSERT INTO deu1951_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","von den Kindern Josephs, von Ephraim Elisama, der Sohn Ammihuds; von Manasse Gamliel, der Sohn Pedazurs; ");
INSERT INTO deu1951_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","von Benjamin Abidan, der Sohn Gideonis; ");
INSERT INTO deu1951_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","von Dan Ahieser, der Sohn Ammi-Schaddais; ");
INSERT INTO deu1951_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","von Asser Pagiel, der Sohn Ochrans; ");
INSERT INTO deu1951_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","von Gad Eliasaph, der Sohn Deguels; ");
INSERT INTO deu1951_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","von Naphtali Ahira, der Sohn Enans. ");
INSERT INTO deu1951_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Das sind die Berufenen der Gemeinde, die Fürsten unter den Stämmen ihrer Väter; die Häupter über die Tausende Israels sind diese. ");
INSERT INTO deu1951_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Und Mose und Aaron nahmen diese Männer, die mit Namen bezeichnet sind, ");
INSERT INTO deu1951_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","und versammelten die ganze Gemeinde am ersten Tag des zweiten Monats, und sie ließen sich eintragen in die Geburtsregister, nach ihren Geschlechtern und ihren Vaterhäusern, unter Aufzählung der Namen, von zwanzig Jahren an und darüber, nach der Kopfzahl. ");
INSERT INTO deu1951_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Wie der HERR Mose geboten hatte, so zählte er sie in der Wüste Sinai. ");
INSERT INTO deu1951_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Und es waren der Kinder Ruben, des erstgeborenen Sohnes Israels, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern an Zahl der Namen, Haupt für Haupt, alle diensttauglichen Männer, von zwanzig Jahren und darüber, ");
INSERT INTO deu1951_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","so viele ihrer gemustert wurden vom Stamm Ruben, 46500. ");
INSERT INTO deu1951_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Der Kinder Simeon, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an Zahl der Namen, Haupt für Haupt, alle diensttauglichen Männer, von zwanzig Jahren und darüber, ");
INSERT INTO deu1951_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","so viele ihrer vom Stamme Simeon gemustert wurden, 59300. ");
INSERT INTO deu1951_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Der Kinder Gad, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war, ");
INSERT INTO deu1951_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","so viele ihrer vom Stamme Gad gemustert wurden, 45650. ");
INSERT INTO deu1951_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Der Kinder Juda, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war, ");
INSERT INTO deu1951_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","so viele ihrer vom Stamme Juda gemustert wurden, 74600. ");
INSERT INTO deu1951_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Der Kinder Issaschar, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war, ");
INSERT INTO deu1951_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","so viele ihrer vom Stamme Issaschar gemustert wurden, 54400. ");
INSERT INTO deu1951_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Der Kinder Sebulon, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an der Zahl, von zwanzig Jahren und darüber, was diensttauglich war; ");
INSERT INTO deu1951_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","so viele ihrer vom Stamme Sebulon gemustert wurden, 57400. ");
INSERT INTO deu1951_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Der Kinder Joseph, nämlich von den Kindern Ephraim, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war, ");
INSERT INTO deu1951_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","so viele ihrer vom Stamme Ephraim gemustert wurden, 40500. ");
INSERT INTO deu1951_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Der Kinder Manasse, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war; ");
INSERT INTO deu1951_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","so viele ihrer vom Stamme Manasse gemustert wurden, 32200. ");
INSERT INTO deu1951_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Der Kinder Benjamin, nach ihrer Abstammung, ihren Geschlechtern und Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war, ");
INSERT INTO deu1951_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","so viele ihrer vom Stamm Benjamin gemustert wurden, 35400. ");
INSERT INTO deu1951_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Der Kinder Dan, nach ihrer Abstammung, ihren Geschlechtern und Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war, ");
INSERT INTO deu1951_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","so viele ihrer vom Stamme Dan gemustert wurden, 62700. ");
INSERT INTO deu1951_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Der Kinder Asser, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war, ");
INSERT INTO deu1951_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","so viele ihrer vom Stamme Asser gemustert wurden, 41500. ");
INSERT INTO deu1951_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Der Kinder Naphtali, nach ihrer Abstammung, ihren Geschlechtern und ihren Vaterhäusern, an Zahl der Namen, von zwanzig Jahren und darüber, was diensttauglich war, ");
INSERT INTO deu1951_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","so viele ihrer vom Stamme Naphtali gemustert wurden, 53400. ");
INSERT INTO deu1951_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Das sind die Gemusterten, welche Mose und Aaron musterten samt den zwölf Fürsten Israels, deren je einer über die Vaterhäuser seines Stammes gesetzt war. ");
INSERT INTO deu1951_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Alle Gemusterten aber der Kinder Israel, nach den Häusern ihrer Väter, von zwanzig Jahren und darüber, was unter Israel diensttauglich war, derer waren 603550. ");
INSERT INTO deu1951_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Aber die Leviten mit ihrem väterlichen Stamm ");
INSERT INTO deu1951_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","waren in dieser Musterung nicht inbegriffen. ");
INSERT INTO deu1951_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Denn der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Nur den Stamm Levi sollst du nicht mustern und seine Zahl nicht rechnen unter die Kinder Israel; ");
INSERT INTO deu1951_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","sondern du sollst die Leviten über die Wohnung des Zeugnisses setzen und über alle ihre Geräte und über alles, was dazu gehört. Sie sollen die Wohnung tragen samt allen ihren Geräten und sollen sie bedienen und sich um die Wohnung her lagern. ");
INSERT INTO deu1951_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Und wenn die Wohnung aufbricht, so sollen die Leviten sie abbrechen; wenn aber die Wohnung sich lagern soll, so sollen sie dieselbe aufschlagen; kommt ihr aber ein Fremder zu nahe, so muß er sterben. ");
INSERT INTO deu1951_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Die Kinder Israel sollen sich lagern, ein jeder in seinem Lager und bei dem Panier seines Heers. ");
INSERT INTO deu1951_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Aber die Leviten sollen sich um die Wohnung des Zeugnisses her lagern, daß nicht ein Zorngericht über die Gemeinde der Kinder Israel komme; darum sollen die Leviten der Wohnung des Zeugnisses warten. ");
INSERT INTO deu1951_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Und die Kinder Israel taten so alles; was der HERR Mose geboten hatte, das taten sie. ");
INSERT INTO deu1951_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Und der HERR redete zu Mose und Aaron und sprach: Die Kinder Israel sollen sich lagern, ");
INSERT INTO deu1951_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","ein jeder bei seinem Panier und bei den Abzeichen ihrer Vaterhäuser; ringsum, der Stiftshütte gegenüber, sollen sie sich lagern. ");
INSERT INTO deu1951_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Gegen Morgen soll sich lagern das Panier des Lagers von Juda, nach seinen Heeren und der Fürst der Kinder Juda, Nahasson, der Sohn Amminadabs; ");
INSERT INTO deu1951_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","samt seinem Heer und ihren Gemusterten, 74600. ");
INSERT INTO deu1951_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Neben ihm soll sich lagern der Stamm Issaschar; ihr Fürst Netaneel der Sohn Zuars, ");
INSERT INTO deu1951_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","samt seinem Heer und ihren Gemusterten, 54400. ");
INSERT INTO deu1951_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Dazu der Stamm Sebulon; ihr Fürst Eliab, der Sohn Helons, ");
INSERT INTO deu1951_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","samt seinem Heer und ihren Gemusterten, 57400. ");
INSERT INTO deu1951_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Alle, die zum Lager Judas gezählt werden, sind 186400, nach ihren Heerscharen geordnet; sie sollen voranziehen. ");
INSERT INTO deu1951_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Gegen Mittag soll liegen das Panier Rubens mit seinem Heer; ihr Fürst Elizur, der Sohn Sedeurs, ");
INSERT INTO deu1951_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","samt seinem Heer und seinen Gemusterten, 46500. ");
INSERT INTO deu1951_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Neben ihm soll sich lagern der Stamm Simeon; ihr Fürst Selumiel, der Sohn Zuri-Schaddais, ");
INSERT INTO deu1951_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","samt seinem Heer und seinen Gemusterten, 59300. ");
INSERT INTO deu1951_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Dazu der Stamm Gad; ihr Fürst Eliphas, der Sohn Reguels, ");
INSERT INTO deu1951_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","samt seinem Heer und seinen Gemusterten, 45650. ");
INSERT INTO deu1951_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Alle, die zum Lager Rubens gezählt werden, sind 151450, nach ihren Heerscharen geordnet. Diese sollen in zweiter Linie ziehen. ");
INSERT INTO deu1951_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Darnach soll die Stiftshütte ziehen mit den Lagern der Leviten, mitten unter den Lagern; wie sie sich lagern, also sollen sie auch ziehen, ein jeglicher auf seiner Seite, bei seinem Panier. ");
INSERT INTO deu1951_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Gegen Abend soll liegen das Panier Ephraims mit seinem Heer; ihr Fürst Elischama, der Sohn Ammihuds, ");
INSERT INTO deu1951_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","samt seinem Heer und seinen Gemusterten, 40500. ");
INSERT INTO deu1951_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Neben ihm soll sich lagern der Stamm Manasse; ihr Fürst Gamliel, der Sohn Pedazurs; ");
INSERT INTO deu1951_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","samt seinem Heer und seinen Gemusterten, 32200. ");
INSERT INTO deu1951_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Dazu der Stamm Benjamin; ihr Fürst Abidan, der Sohn Gideonis, ");
INSERT INTO deu1951_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","samt seinem Heer und seinen Gemusterten, 35400. ");
INSERT INTO deu1951_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Alle, die zum Lager Ephraims gezählt werden, sind 108100, nach ihren Heerscharen geordnet. Diese sollen in dritter Linie ziehen. ");
INSERT INTO deu1951_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Gegen Mitternacht soll liegen das Panier des Lagers von Dan mit seinem Heer; ihr Fürst Ahieser, der Sohn Ammi-Schaddais, ");
INSERT INTO deu1951_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","samt seinem Heer und seinen Gemusterten, 62700. ");
INSERT INTO deu1951_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Neben ihm soll sich lagern der Stamm Asser; ihr Fürst Pagiel, der Sohn Ochrans, ");
INSERT INTO deu1951_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","samt seinem Heer und seinen Gemusterten, 41500. ");
INSERT INTO deu1951_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Dazu der Stamm Naphtali, ihr Fürst Ahira, der Sohn Enans, ");
INSERT INTO deu1951_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","samt seinem Heer und seinen Gemusterten, 53400. ");
INSERT INTO deu1951_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Alle, die zum Lager Dans gezählt werden, sind 157000. Sie sollen die letzten im Zuge sein mit ihren Panieren. ");
INSERT INTO deu1951_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Das sind die Gemusterten der Kinder Israel, eingeteilt nach ihren Vaterhäusern und ihren Heerlagern, 603550. ");
INSERT INTO deu1951_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Aber die Leviten wurden nicht mit den Kindern Israel gemustert, wie der Herr Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Und die Kinder Israel taten alles, wie der HERR Mose geboten hatte; sie lagerten sich nach ihren Panieren, und zogen aus, ein jeder in seinem Geschlecht, bei seinem Vaterhaus. ");
INSERT INTO deu1951_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Dies ist das Geschlecht Aarons und Moses, an dem Tag, als der HERR mit Mose redete auf dem Berge Sinai. ");
INSERT INTO deu1951_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Und dies sind die Namen der Söhne Aarons: Der Erstgeborene Nadab, darnach Abihu, Eleasar und Itamar. ");
INSERT INTO deu1951_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Das sind die Namen der Söhne Aarons, der gesalbten Priester, denen man die Hände füllte zum Priesterdienst. ");
INSERT INTO deu1951_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Aber Nadab und Abihu starben vor dem HERRN, als sie fremdes Feuer vor den HERRN brachten, in der Wüste Sinai, und sie hatten keine Söhne. Eleasar aber und Itamar taten Priesterdienst vor den Augen ihres Vaters Aaron. ");
INSERT INTO deu1951_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Bring den Stamm Levi herzu, und stelle sie vor Aaron, den Priester, daß sie ihm dienen und besorgen, ");
INSERT INTO deu1951_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","was für ihn und für die ganze Gemeinde zu besorgen ist, vor der Stiftshütte, und so den Dienst an der Wohnung versehen, ");
INSERT INTO deu1951_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","daß sie alle Geräte der Stiftshütte hüten und der Hut der Kinder Israel warten, den Dienst an der Wohnung versehen. ");
INSERT INTO deu1951_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Und du sollst die Leviten Aaron und seinen Söhnen zum Geschenk machen; geschenkt sind sie ihm von seiten der Kinder Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aber Aaron und seine Söhne sollst du beauftragen, ihres Priestertums zu warten. Wenn sich ein Fremder naht, so muß er sterben. ");
INSERT INTO deu1951_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Siehe, ich habe die Leviten unter den Kindern Israel genommen an Stelle aller Erstgeborenen unter den Kindern Israel, also daß die Leviten mein sind. ");
INSERT INTO deu1951_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Denn alle Erstgeburt ist mein; an dem Tag, da ich alle Erstgeburt in Ägypten schlug, heiligte ich mir alle Erstgeburt in Israel, von den Menschen an bis auf das Vieh, daß sie mein sein sollen, mir, dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Und der HERR redete zu Mose in der Wüste Sinai und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Mustere die Kinder Levis nach ihren Vaterhäusern und Geschlechtern, alles, was männlich ist, einen Monat alt und darüber! ");
INSERT INTO deu1951_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Also musterte sie Mose nach dem Wort des HERRN, wie er geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Und dies sind die Kinder Levis mit ihren Namen: Gerson, Kahat und Merari. ");
INSERT INTO deu1951_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Die Namen aber der Kinder Gersons nach ihren Geschlechtern sind Libni und Simei. ");
INSERT INTO deu1951_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Die Kinder Kahats nach ihren Geschlechtern sind Amram, Jizhar, Hebron und Ussiel. ");
INSERT INTO deu1951_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Die Kinder Meraris nach ihren Geschlechtern sind Machli und Muschi. Das sind die Geschlechter Levis nach ihren Vaterhäusern. ");
INSERT INTO deu1951_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Von Gerson stammt das Geschlecht der Libniter und Simeiter. Das sind die Geschlechter der Gersoniter. ");
INSERT INTO deu1951_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Die Zahl ihrer Gemusterten männlichen Geschlechts, von einem Monat und darüber, betrug 7500. ");
INSERT INTO deu1951_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Das Geschlecht der Gersoniter soll sich hinter der Wohnung gegen Abend lagern. ");
INSERT INTO deu1951_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Und der Fürst des Vaterhauses der Gersoniter sei Eliasaph, der Sohn Laels. ");
INSERT INTO deu1951_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Was aber die Kinder Gerson an der Stiftshütte zu besorgen haben, das ist die Wohnung und das Zelt, seine Decke, und den Vorhang in der Tür der Stiftshütte, ");
INSERT INTO deu1951_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","und die Vorhänge am Vorhof, und den Vorhang in der Tür des Vorhofs, welcher rings um die Wohnung und um den Altar her ist, dazu die Zeltstricke und alles, was zu ihrem Dienst gehört. ");
INSERT INTO deu1951_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Von Kahat stammt das Geschlecht der Amramiter, der Jizhariter, der Hebroniter und Ussieliter. Das sind die Geschlechter der Kahaliter. ");
INSERT INTO deu1951_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Was männlich war, einen Monat alt und darüber, belief sich an der Zahl auf 8600, die das Heiligtum besorgten. ");
INSERT INTO deu1951_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Die Geschlechter der Kinder Kahats sollen sich lagern an die Seite der Wohnung gegen Mittag. ");
INSERT INTO deu1951_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Und der Fürst des Stammhauses der Kahatiter sei Elizaphan, der Sohn Ussiels. ");
INSERT INTO deu1951_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Und sie sollen warten der Lade, des Tisches, des Leuchters, der Altäre und der Geräte des Heiligtums, mit welchen sie dienen, auch des Vorhangs, und was zu diesem Dienst gehört. ");
INSERT INTO deu1951_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Aber der oberste Fürst der Leviten soll sein Eleasar, der Sohn Aarons, des Priesters, mit der Aufsicht über die, welche des Heiligtums warten. ");
INSERT INTO deu1951_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Von Merari stammt das Geschlecht der Machliter und Muschiter. Das sind die Geschlechter der Merariter. ");
INSERT INTO deu1951_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Die Zahl ihrer Gemusterten von allem, was männlich war, einen Monat alt und darüber, betrug 6200. ");
INSERT INTO deu1951_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Und der Oberste des Stammhauses der Merariter sei Zuriel, der Sohn Abichails; und sie sollen sich lagern an der Seite der Wohnung gegen Mitternacht. ");
INSERT INTO deu1951_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Und das Hüteramt der Merariter soll sein, zu warten der Bretter und Riegel und Säulen und der Füße der Wohnung, und aller ihrer Geräte und ihres ganzen Dienstes, ");
INSERT INTO deu1951_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","dazu der Säulen um den Vorhof her, mit ihren Füßen und Nägeln und Seilen. ");
INSERT INTO deu1951_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aber vor der Wohnung, vor der Stiftshütte, gegen Morgen, sollen sich lagern Mose und Aaron und seine Söhne, die Besorgung des Heiligtums zu überwachen, zur Bewahrung der Kinder Israel. Wenn ein Fremder naht, so muß er sterben. ");
INSERT INTO deu1951_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Alle gemusterten Leviten, welche Mose und Aaron musterten nach ihren Geschlechtern, nach dem Wort des Herrn, alles, was männlich war, einen Monat alt und darüber, derer waren 22000. ");
INSERT INTO deu1951_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Und der HERR sprach zu Mose: Mustere alle männliche Erstgeburt der Kinder Israel, von einem Monat an und darüber und zähle ihre Namen! ");
INSERT INTO deu1951_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Und du sollst die Leviten mir, dem HERRN, nehmen, an Stelle aller Erstgeburt unter den Kindern Israel, und der Leviten Vieh an Stelle aller Erstgeburt unter dem Vieh der Kinder Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Und Mose musterte, wie der HERR ihm geboten hatte, alle Erstgeburt unter den Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Da belief sich die Zahl der Namen aller männlichen Erstgeborenen von einem Monat an und darüber, auf 22273. ");
INSERT INTO deu1951_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Nimm die Leviten für alle Erstgeburt unter den Kindern Israel, und das Vieh der Leviten für ihr Vieh, daß die Leviten mein seien, mir, dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Aber als Lösegeld für die 273 überzähligen Erstgeborenen der Kinder Israel über der Leviten Zahl, ");
INSERT INTO deu1951_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","sollst du je fünf Schekel erheben für jeden Kopf, und zwar sollst du es erheben nach dem Schekel des Heiligtums (ein Schekel macht zwanzig Gera); ");
INSERT INTO deu1951_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","und du sollst dieses Geld als Lösegeld der Überzähligen Aaron und seinen Söhnen geben. ");
INSERT INTO deu1951_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Da nahm Mose das Lösegeld von denen, die die Zahl der durch die Leviten Gelösten überstieg; ");
INSERT INTO deu1951_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","von den Erstgeborenen der Kinder Israel erhob er 1365 Schekel, nach dem Schekel des Heiligtums. ");
INSERT INTO deu1951_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Und Mose gab das Geld Aaron und seinen Söhnen, nach dem Wort des HERRN, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Und der HERR redete zu Mose und sprach: Stelle die Gesamtzahl der Kinder Kahat unter den Leviten fest, ");
INSERT INTO deu1951_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","nach ihren Geschlechtern, nach ihren Vaterhäusern, ");
INSERT INTO deu1951_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","von dreißig Jahren an und darüber, bis in das fünfzigste Jahr, alle Diensttauglichen für das Werk an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Das soll aber der Dienst der Kinder Kahat an der Stiftshütte sein: das Allerheiligste. ");
INSERT INTO deu1951_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Wenn das Heer aufbricht, so sollen Aaron und seine Söhne hineingehen und den Vorhang abnehmen und die Lade des Zeugnisses damit bedecken, ");
INSERT INTO deu1951_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","und sollen eine Decke von Seehundsfellen darauf tun und oben darüber ein Tuch von ganz blauem Purpur breiten und die Stangen einstecken. ");
INSERT INTO deu1951_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Auch über den Schaubrottisch sollen sie ein Tuch von blauem Purpur breiten und darauf setzen die Schüsseln, die Kellen, die Opferschalen und die Trankopferkannen; auch soll das beständige Brot darauf liegen. ");
INSERT INTO deu1951_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Und sie sollen ein Tuch von Karmesinfarbe darüber breiten und dasselbe mit einer Decke von Seehundsfellen bedecken und seine Stangen einstecken. ");
INSERT INTO deu1951_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Sie sollen auch ein Tuch von blauem Purpur nehmen und damit den Licht spendenden Leuchter bedecken und seine Lampen, samt seinen Lichtscheren und Löschnäpflein und allen Ölgeschirren, mit welchen er bedient wird. ");
INSERT INTO deu1951_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Und sollen um alle diese Geräte eine Decke von Seehundsfellen tun und es auf ein Gestell legen. ");
INSERT INTO deu1951_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Also sollen sie auch über den goldenen Altar ein Tuch von blauem Purpur breiten, und ihn mit einer Decke von Seehundsfellen bedecken und seine Stangen einstecken. ");
INSERT INTO deu1951_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Alle Geräte des Dienstes, womit man im Heiligtum dient, sollen sie nehmen und ein Tuch von blauem Purpur darüber tun und sie mit einer Decke von Seehundsfellen decken und auf ein Gestell legen. ");
INSERT INTO deu1951_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Sie sollen auch den Altar von der Asche reinigen, und ein Tuch von rotem Purpur darüber breiten. ");
INSERT INTO deu1951_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Alle seine Geräte, womit sie auf demselben dienen, sollen sie darauf legen, Kohlenpfannen, Gabeln, Schaufeln und Sprengbecken, samt allen Geräten des Altars, und sollen eine Decke von Seehundsfellen darüber breiten und seine Stangen einstecken. ");
INSERT INTO deu1951_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Wen nun Aaron und seine Söhne solches ausgerichtet und das Heiligtum und alle seine Geräte bedeckt haben, und wenn das Heer aufbricht, dann sollen die Kinder Kahat hineingehen, um es zu tragen; und sie sollen das Heiligtum nicht anrühren, sonst würden sie sterben. Das ist die Arbeit der Kinder Kahat an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleasar aber, der Sohn Aarons, soll die Aufsicht haben über das Öl für den Leuchter, und über die Spezerei zum Räucherwerk, und über das beständige Speisopfer und das Salböl, dazu die Aufsicht über die ganze Wohnung und alles, was darin ist, über das Heiligtum und seine Geräte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Und der HERR redete zu Mose und Aaron und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Ihr sollt dafür sorgen, daß der Stamm des Geschlechts der Kahatiter nicht ausgerottet werde unter den Leviten! ");
INSERT INTO deu1951_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Darum sollt ihr solches mit ihnen tun, damit sie leben und nicht sterben, wenn sie sich dem Allerheiligsten nahen: Aaron und seine Söhne sollen hineingehen und einem jeden seine Arbeit und seine Last anweisen. ");
INSERT INTO deu1951_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Jene aber sollen nicht hineingehen, um auch nur einen Augenblick das Heiligtum anzusehen, sonst würden sie sterben! ");
INSERT INTO deu1951_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Stelle die Gesamtzahl der Kinder Gerson fest, nach ihren Vaterhäusern, nach ihren Familien; ");
INSERT INTO deu1951_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","von dreißig Jahren an und darüber, bis zum fünfzigsten Jahr sollst du sie zählen, alle Diensttauglichen zur Arbeit an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Das soll aber das Amt des Geschlechts der Gersoniter sein, wo sie dienen und was sie tragen sollen: ");
INSERT INTO deu1951_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Sie sollen die Teppiche der Wohnung und die Stiftshütte tragen, ihre Decken und die Decke von Seehundsfellen, die oben darüber ist und den Vorhang in der Tür der Stiftshütte; ");
INSERT INTO deu1951_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","auch die Vorhänge des Vorhofs und den Vorhang der Tür des Tors am Vorhof, rings um die Wohnung und den Altar her, auch ihre Seile und ihre Dienstgeräte, samt allem, womit gearbeitet wird; das sollen sie besorgen. ");
INSERT INTO deu1951_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Nach dem Befehl Aarons und seiner Söhne soll der ganze Dienst der Gersoniter geschehen, alles, was sie zu tragen und was sie zu verrichten haben; ihr sollt ihnen alle ihre Aufgaben pünktlich anweisen. ");
INSERT INTO deu1951_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Das ist der Dienst des Geschlechts der Gersoniter in der Stiftshütte und was sie unter der Hand Itamars, des Sohnes Aarons, des Priesters zu besorgen haben. ");
INSERT INTO deu1951_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Auch die Kinder Merari sollst du mustern, nach ihrem Vaterhaus und ihren Familien. ");
INSERT INTO deu1951_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Von dreißig Jahren an und darüber, bis ins fünfzigste Jahr sollst du sie zählen, alle Diensttauglichen zur Arbeit an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ihre Aufgabe im Dienste der Stiftshütte ist, die Bretter der Wohnung, ihre Riegel, Säulen und Füße zu tragen, ");
INSERT INTO deu1951_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","dazu die Säulen des Vorhofs und ihre Füße, die Nägel und Seile, samt allen ihren Geräten und aller Zubehörde; ihr sollt ihnen die Geräte, die sie zu tragen haben, mit Namen nennen. ");
INSERT INTO deu1951_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Das ist der Dienst des Geschlechts der Kinder Merari, alles, was sie an der Stiftshütte zu besorgen haben unter der Hand Itamars, des Sohnes Aarons, des Priesters. ");
INSERT INTO deu1951_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Und Mose und Aaron samt den Fürsten der Gemeinde musterten die Kahatiter nach ihrem Vaterhaus und ihren Geschlechtern, ");
INSERT INTO deu1951_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","von dreißig Jahren an und darüber, bis ins fünfzigste, alle Diensttauglichen zur Arbeit an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Und ihre Musterung nach ihren Geschlechtern ergab 2750. ");
INSERT INTO deu1951_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Das sind die Gemusterten des Geschlechts der Kahatiter, alle die, welche Dienst tun konnten an der Stiftshütte, welche Mose und Aaron musterten nach dem Wort des HERRN durch Mose. ");
INSERT INTO deu1951_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Die Kinder Gerson wurden auch gemustert nach ihrem Vaterhaus und ihren Familien, ");
INSERT INTO deu1951_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","von dreißig Jahren an und darüber, bis ins fünfzigste, alle Diensttauglichen für die Arbeit an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Und ihre Musterung nach ihrem Vaterhaus und Geschlecht ergab 2630. ");
INSERT INTO deu1951_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Das sind die Gemusterten des Geschlechts der Kinder Gerson, welche tauglich waren für den Dienst an der Stiftshütte, welche Mose und Aaron musterten nach dem Wort des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Die Kinder Merari wurden auch gemustert nach ihrem Vaterhaus und ihren Geschlechtern, ");
INSERT INTO deu1951_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","von dreißig Jahren an und darüber, bis in das fünfzigste, alle Diensttauglichen zur Arbeit an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Und die Musterung nach ihren Geschlechtern ergab 3200. ");
INSERT INTO deu1951_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Das sind die Gemusterten des Geschlechts der Kinder Merari, welche Mose und Aaron einstellten nach dem Wort des HERRN durch Mose. ");
INSERT INTO deu1951_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Alle Gemusterten, welche eingestellt wurden, als Mose und Aaron samt den Fürsten Israels die Leviten zählten nach ihren Geschlechtern und Vaterhäusern, ");
INSERT INTO deu1951_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","von dreißig Jahren an und darüber, bis ins fünfzigste, alle, die da kamen zur Verrichtung irgend eines Dienstes oder um eine Last zu tragen an der Stiftshütte; ");
INSERT INTO deu1951_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","alle Gemusterten zählten 8580. ");
INSERT INTO deu1951_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Nach dem Worte des HERRN bestellte man sie durch Mose, einen jeden zu seinem Dienst und zu seiner Last und an sein Amt, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Und der HERR redete zu Mose und sprach: Gebiete den Kindern Israel, ");
INSERT INTO deu1951_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","daß sie aus dem Lager alle Aussätzigen wegschicken, und alle, die Eiterflüsse haben, und die an einem Toten unrein geworden sind. ");
INSERT INTO deu1951_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Männer und Weiber sollt ihr vor das Lager hinausschicken, daß sie ihr Lager nicht verunreinigen, weil ich unter ihnen wohne. ");
INSERT INTO deu1951_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Und die Kinder Israel taten also und schickten sie vor das Lager hinaus; wie der HERR zu Mose gesagt hatte, also taten die Kinder Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Und der HERR redete zu Mose und sprach: Sage den Kindern Israel: ");
INSERT INTO deu1951_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Wenn ein Mann oder ein Weib irgend eine menschliche Sünde tut und sich damit am HERRN vergeht und die betreffende Seele eine Schuld auf sich lädt; ");
INSERT INTO deu1951_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","so sollen sie ihre Sünde bekennen, die sie getan haben, und sollen ihre Schuld in ihrem vollen Betrag wiedererstatten, und den fünften Teil dazufügen und es dem geben, dem sie es schuldig sind. ");
INSERT INTO deu1951_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ist aber kein nächster Blutsverwandter da, dem man die Schuld erstatten kann, so fällt die dem HERRN zu erstattende Schuld dem Priester zu, außer dem Widder der Versühnung, mit dem ihm Sühne erwirkt wird. ");
INSERT INTO deu1951_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Desgleichen soll alles Hebopfer von allem, was die Kinder Israel heiligen und dem Priester bringen, ihm gehören; ");
INSERT INTO deu1951_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","und was jemand heiligt, das soll ihm gehören; gibt jemand dem Priester etwas, so gehört es ihm. ");
INSERT INTO deu1951_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Sage den Kindern Israel und sprich zu ihnen: Wenn jemandes Weib sich verginge und ihm untreu würde, und jemand sie beschliefe, ");
INSERT INTO deu1951_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","und es bliebe vor den Augen ihres Mannes verborgen und versteckt, daß sie unrein geworden, und es wäre kein Zeuge vorhanden wider sie, sie wäre auch nicht ertappt worden; ");
INSERT INTO deu1951_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","und es käme über ihn ein Geist der Eifersucht, daß er um sein Weib eiferte, weil sie unrein geworden ist (oder wenn der Eifersuchtsgeist über ihn käme, daß er um sein Weib eiferte, ob sie schon nicht unrein geworden ist) ");
INSERT INTO deu1951_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","so soll der Mann sein Weib zum Priester führen und um ihretwillen ein Opfer für sie bringen, ein Zehntel Epha Gerstenmehl; er soll aber kein Öl darauf gießen, noch Weihrauch darauf tun; denn es ist ein Eiferopfer und ein Gedächtnisopfer, das die Schuld ins Gedächtnis ruft. ");
INSERT INTO deu1951_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Und der Priester soll sie herzuführen und vor den HERRN stellen. ");
INSERT INTO deu1951_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Und der Priester soll heiliges Wasser nehmen in ein irdenes Geschirr und Staub vom Boden der Wohnung in das Wasser tun, ");
INSERT INTO deu1951_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","und soll das Weib vor den HERRN stellen und ihr Haar auflösen und das Gedächtnisopfer, das ein Eiferopfer ist, auf ihre Hände legen. Und der Priester soll in seiner Hand das bittere, fluchbringende Wasser haben; ");
INSERT INTO deu1951_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","und er soll das Weib beschwören und zu ihr sagen: «Hat dich kein Mann beschlafen und hast du dich nicht vergangen und neben deinem Mann verunreinigt, so sollst du von diesem bitteren fluchbringenden Wasser unbeschädigt bleiben; ");
INSERT INTO deu1951_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","bist du aber von deinem Mann abgewichen, und hast dich verunreinigt, indem dich jemand beschlafen hat außer deinem Mann; ");
INSERT INTO deu1951_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","so soll der Priester in seinem Beschwörungsfluch zu dem Weibe sagen setze dich der HERR zum Fluch und zum Schwur unter deinem Volk, daß der HERR deine Hüfte schwinden und deinen Bauch anschwellen lasse! ");
INSERT INTO deu1951_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","So gehe nun dieses fluchbringende Wasser in deinen Leib, daß dein Bauch anschwelle und deine Hüfte schwinde!» Und das Weib soll sagen: Amen, Amen! ");
INSERT INTO deu1951_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Dann soll der Priester diese Flüche auf einen Zettel schreiben und mit dem bittern Wasser abwaschen. ");
INSERT INTO deu1951_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Und er soll dem Weibe von dem bittern, fluchbringenden Wasser zu trinken geben, daß das fluchbringende Wasser in sie eindringe und ihr bitter sei. ");
INSERT INTO deu1951_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Darnach soll der Priester das Eiferopfer von ihrer Hand nehmen und zum Speisopfer weben vor dem HERRN und es zum Altar bringen. ");
INSERT INTO deu1951_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Und er soll eine Handvoll von dem Speisopfer nehmen, zum Gedächtnis, und es auf dem Altar verbrennen und darnach dem Weibe das Wasser zu trinken geben. ");
INSERT INTO deu1951_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Und wenn sie das Wasser getrunken hat, so wird, wenn sie unrein geworden ist und sich an ihrem Mann vergangen hat, das fluchbringende Wasser in sie eindringen und sie vergiften, so daß ihr Bauch anschwellen und ihre Hüfte schwinden wird, und das Weib wird unter ihrem Volk ein Fluch sein. ");
INSERT INTO deu1951_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ist aber das Weib nicht verunreinigt, sondern rein, so wird sie unbeschädigt bleiben, daß sie Samen empfangen kann. ");
INSERT INTO deu1951_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Das ist das Eifergesetz: Wenn ein Weib neben ihrem Manne ausschweift und unrein wird, ");
INSERT INTO deu1951_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","oder wenn der Geist der Eifersucht über einen Mann kommt, daß er um sein Weib eifert, so soll er sie vor den HERRN stellen, daß der Priester gänzlich mit ihr verfahre nach diesem Gesetz. ");
INSERT INTO deu1951_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Dann ist der Mann unschuldig; das Weib aber hat ihre Schuld zu tragen. ");
INSERT INTO deu1951_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Und der HERR redete mit Mose und sprach: Sage den Kindern Israel und sprich zu ihnen: ");
INSERT INTO deu1951_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Wenn ein Mann oder ein Weib das besondere Gelübde eines Nasiräers tun will, um sich dem HERRN zu weihen, ");
INSERT INTO deu1951_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","so soll er sich des Weins und starken Getränkes enthalten; Essig von Wein und starkem Getränk soll er nicht trinken; er soll auch keinen Traubensaft trinken und darf weder grüne noch getrocknete Trauben essen. ");
INSERT INTO deu1951_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Solange seine Weihe währt, soll er nichts essen, was vom Weinstock gewonnen wird, weder Kern noch Hülse. Solange das Gelübde seiner Weihe währt, soll kein Schermesser auf sein Haupt kommen; ");
INSERT INTO deu1951_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","bis die Zeit, die er dem HERRN geweiht hat, vergangen ist, soll er heilig sein; er soll das Haar auf seinem Haupt frei wachsen lassen. ");
INSERT INTO deu1951_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Während der ganzen Zeit, für welche er sich dem HERRN geweiht hat, soll er zu keinem Toten gehen. ");
INSERT INTO deu1951_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Er soll sich auch nicht verunreinigen an der Leiche seines Vaters, seiner Mutter, seines Bruders oder seiner Schwester; denn die Weihe seines Gottes ist auf seinem Haupt. ");
INSERT INTO deu1951_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Während der ganzen Zeit seiner Weihe soll er dem HERRN heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Und wenn jemand bei ihm unversehens und plötzlich stirbt und sein geweihtes Haupt verunreinigt wird, so soll er sein Haupt scheren am Tage seiner Reinigung; am siebenten Tage soll er es scheren. ");
INSERT INTO deu1951_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Und am achten Tage soll er zwei Turteltauben oder zwei junge Tauben zum Priester, vor die Tür der Stiftshütte bringen. ");
INSERT INTO deu1951_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Und der Priester soll die eine zum Sündopfer und die andere zum Brandopfer machen und ihm Sühne erwirken, weil er sich an einem Entseelten versündigt hat, und soll also sein Haupt an demselben Tage heiligen, ");
INSERT INTO deu1951_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","daß er dem HERRN die Tage seines Gelübdes halte, und er bringe ein einjähriges Lamm zum Schuldopfer. Aber die vorigen Tage fallen dahin, weil seine Weihe verunreinigt worden ist. ");
INSERT INTO deu1951_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Und das ist das Gesetz des Nasiräers: Wenn die Zeit seines Gelübdes erfüllt ist, so soll man ihn vor die Tür der Stiftshütte führen, ");
INSERT INTO deu1951_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","da soll er dem HERRN sein Opfer bringen, ein einjähriges, männliches, tadelloses Lamm zum Sündopfer, und einen tadellosen Widder zum Dankopfer, ");
INSERT INTO deu1951_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","und einen Korb mit ungesäuerten Kuchen von Semmelmehl, mit Öl gemengt, und ungesäuerte Fladen, mit Öl bestrichen, samt ihrem Speisopfer und ihren Trankopfern. ");
INSERT INTO deu1951_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Und der Priester soll es vor den HERRN bringen und soll sein Sündopfer und sein Brandopfer zurichten. ");
INSERT INTO deu1951_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Und er soll dem HERRN den Widder zum Dankopfer bereiten samt dem Korbe mit dem ungesäuerten Brot; auch soll der Priester sein Speisopfer und sein Trankopfer zurichten. ");
INSERT INTO deu1951_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Der Nasiräer aber soll sein geweihtes Haupt scheren vor der Tür der Stiftshütte, und soll sein geweihtes Haupthaar nehmen und es in das Feuer werfen, das unter dem Dankopfer ist. ");
INSERT INTO deu1951_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Und der Priester soll von dem Widder die gekochte Vorderkeule nehmen und einen ungesäuerten Kuchen aus dem Korbe und einen ungesäuerten Fladen und soll es dem Nasiräer auf seine Hände legen, nachdem er sein geweihtes Haar abgeschoren hat. ");
INSERT INTO deu1951_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Und der Priester soll es vor dem HERRN weben. Das ist dem Priester heilig, samt der Webebrust und der Hebekeule. Darnach mag der Nasiräer Wein trinken. ");
INSERT INTO deu1951_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Das ist das Gesetz für den Nasiräer, der ein Gelübde tut, und das Opfer, das er dem HERRN für seine Weihe darbringen soll, außer dem, das seine Hand sonst zu leisten vermag. Wie er gelobt hat, so soll er tun, nach seinem Weihegesetz. ");
INSERT INTO deu1951_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Sage Aaron und seinen Söhnen und sprich: Also sollt ihr zu den Kindern Israel sagen, wenn ihr sie segnen wollt: ");
INSERT INTO deu1951_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Der HERR segne dich und behüte dich! ");
INSERT INTO deu1951_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Der HERR lasse dir sein Angesicht leuchten und sei dir gnädig! ");
INSERT INTO deu1951_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Der HERR erhebe sein Angesicht auf dich und gebe dir Frieden! ");
INSERT INTO deu1951_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Also sollen sie meinen Namen auf die Kinder Israel legen, und ich will sie segnen. ");
INSERT INTO deu1951_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Es begab sich aber des Tages, da Mose die Wohnung völlig aufgerichtet und sie samt allen ihren Geräten gesalbt und geheiligt hatte, als er auch den Altar samt allen seinen Geräten gesalbt und geheiligt hatte; ");
INSERT INTO deu1951_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","da opferten die Fürsten Israels, die Häupter ihrer Vaterhäuser, jene Stammesfürsten, welche der Musterung vorstanden. ");
INSERT INTO deu1951_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Sie brachten aber als ihre Opfergabe vor den HERRN: sechs bedeckte Wagen und zwölf Rinder, je einen Wagen von zwei Fürsten, und je ein Rind von jedem; die brachten sie vor der Wohnung dar. ");
INSERT INTO deu1951_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Nimm es von ihnen an, daß es verwendet werde zum Dienst an der Stiftshütte, und gib es den Leviten nach Bedürfnis ihres Dienstes. ");
INSERT INTO deu1951_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Da nahm Mose die Wagen und Rinder und gab sie den Leviten. ");
INSERT INTO deu1951_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Zwei Wagen und vier Rinder gab er den Kindern Gerson für ihren Dienst; ");
INSERT INTO deu1951_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","und vier Wagen und acht Rinder gab er den Kindern Merari für ihren Dienst unter der Hand Itamars, des Sohnes Aarons, des Priesters. ");
INSERT INTO deu1951_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Aber den Kindern Kahat gab er nichts, weil sie den Dienst des Heiligtums auf sich hatten und auf ihren Schultern tragen mußten. ");
INSERT INTO deu1951_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Und die Fürsten brachten das, was zur Einweihung des Altars dienen sollte am Tage, als er gesalbt ward; und sie brachten ihre Opfer herzu vor den Altar. ");
INSERT INTO deu1951_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Der HERR aber sprach zu Mose: Jeder Fürst soll an dem für ihn bestimmten Tag seine Opfergabe zur Einweihung des Altars darbringen. ");
INSERT INTO deu1951_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Da brachte am ersten Tag seine Opfergabe herzu Nahasson, der Sohn Amminadabs, vom Stamme Juda. ");
INSERT INTO deu1951_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Seine Opfergabe aber war: eine silberne Schüssel, hundertunddreißig Schekel schwer, ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke, und fünf einjährige Lämmer. Das war die Opfergabe Nahassons, des Sohnes Amminadabs. ");
INSERT INTO deu1951_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Am zweiten Tage opferte Netaneel, der Sohn Zuars, der Fürst der Kinder Issaschar. ");
INSERT INTO deu1951_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Er brachte als seine Opfergabe herzu: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","und einen jungen Farren, einen Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Netaneels, des Sohnes Zuars. ");
INSERT INTO deu1951_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Am dritten Tage opferte der Fürst der Kinder Sebulon, Eliab, der Sohn Helons. ");
INSERT INTO deu1951_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Eliabs, des Sohnes Helons. ");
INSERT INTO deu1951_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Am vierten Tage opferten der Fürst der Kinder Ruben, Elizur, der Sohn Sedeurs. ");
INSERT INTO deu1951_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Elizurs, des Sohnes Sedeurs. ");
INSERT INTO deu1951_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Am fünften Tage opferte der Fürst der Kinder Simeon, Selumiel, der Sohn Zuri-Schaddais. ");
INSERT INTO deu1951_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","eine Schale, zehn Schekel Goldes schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Selumiels, des Sohnes Zuri-Schaddais. ");
INSERT INTO deu1951_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Am sechsten Tage opferte der Fürst der Kinder Gad, Eliasaph, der Sohn Deguels. ");
INSERT INTO deu1951_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Eliasaphs, des Sohnes Deguels. ");
INSERT INTO deu1951_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Am siebenten Tage opferte der Fürst der Kinder Ephraim, Elisama, der Sohn Ammihuds. ");
INSERT INTO deu1951_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Elisamas, des Sohnes Ammihuds. ");
INSERT INTO deu1951_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Am achten Tage opferte der Fürst der Kinder Manasse, Gamliel, der Sohn Pedazurs. ");
INSERT INTO deu1951_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Gamliels, des Sohnes Pedazurs. ");
INSERT INTO deu1951_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Am neunten Tage opferte der Fürst der Kinder Benjamin, Abidan, der Sohn Gideonis. ");
INSERT INTO deu1951_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Abidans, des Sohnes Gideonis. ");
INSERT INTO deu1951_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Am zehnten Tage opferte der Fürst der Kinder Dan, Achieser, der Sohn Ammi-Schaddais. ");
INSERT INTO deu1951_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Achiesers, des Sohnes Ammi-Schaddais. ");
INSERT INTO deu1951_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Am elften Tage opferte der Fürst der Kinder Asser, Pagiel, der Sohn Ochrans. ");
INSERT INTO deu1951_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Pagiels, des Sohnes Ochrans. ");
INSERT INTO deu1951_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Am zwölften Tage opferte der Fürst der Kinder Naphtali, Ahira, der Sohn Enans. ");
INSERT INTO deu1951_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Seine Opfergabe war: eine silberne Schüssel, hundertunddreißig Schekel schwer; ein silbernes Sprengbecken, siebzig Schekel schwer nach dem Schekel des Heiligtums; beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","eine goldene Schale, zehn Schekel schwer, voll Räucherwerk; ");
INSERT INTO deu1951_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ein junger Farre, ein Widder, ein einjähriges Lamm zum Brandopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ein Ziegenbock zum Sündopfer; ");
INSERT INTO deu1951_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","und zum Dankopfer zwei Rinder, fünf Widder, fünf Böcke und fünf einjährige Lämmer. Das ist das Opfer Ahiras, des Sohnes Enans. ");
INSERT INTO deu1951_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Das ist die Gabe für die Einweihung des Altars am Tage, da er gesalbt ward, von seiten der Fürsten Israels: Zwölf silberne Schüsseln, zwölf silberne Sprengbecken, zwölf goldene Schalen; ");
INSERT INTO deu1951_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","also daß jede Schüssel hundertunddreißig Schekel Silber und jedes Sprengbecken siebzig Schekel wog und die Summe alles Silbers an Geschirren zweitausendvierhundert Schekel betrug, nach dem Schekel des Heiligtums. ");
INSERT INTO deu1951_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Und von den zwölf goldenen Schalen voll Räucherwerk wog jede zehn Schekel nach dem Schekel des Heiligtums, also daß die Summe des Goldes an den Schalen hundertundzwanzig Schekel betrug. ");
INSERT INTO deu1951_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Die Summe der Rinder zum Brandopfer war zwölf Farren, dazu zwölf Widder, zwölf einjährige Lämmer, samt ihrem Speisopfer, und zwölf Ziegenböcke zum Sündopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Und die Summe der Rinder zum Dankopfer war vierundzwanzig Farren, dazu sechzig Widder, sechzig Böcke, sechzig einjährige Lämmer. Das war die Einweihungsgabe des Altars, nachdem er gesalbt worden. ");
INSERT INTO deu1951_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Und wenn Mose in die Stiftshütte ging, um mit Ihm zu reden, so hörte er die Stimme zu ihm reden vom Sühndeckel herab, der auf der Lade des Zeugnisses ist, zwischen den beiden Cherubim; und Er redete zu ihm. ");
INSERT INTO deu1951_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Und der HERR redete zu Mose und sprach: Rede mit Aaron und sprich zu ihm: ");
INSERT INTO deu1951_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Wenn du die Lampen aufsetzest, so sollen alle sieben Lampen ihr Licht nach der gegenüberliegenden Seite werfen. ");
INSERT INTO deu1951_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Und Aaron tat also. Vorn an dem Leuchter setzte er seine Lampen auf, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Der Leuchter aber war ein Werk von getriebenem Gold, sowohl sein Schaft als auch seine Blumen; nach dem Gesichte, welches der HERR Mose gezeigt, hatte man den Leuchter gemacht. ");
INSERT INTO deu1951_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Nimm die Leviten aus den Kindern Israel und reinige sie! ");
INSERT INTO deu1951_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Also aber sollst du mit ihnen verfahren, um sie zu reinigen: Du sollst Wasser der Entsündigung auf sie sprengen, und sie sollen ein Schermesser über ihren ganzen Leib gehen lassen und ihre Kleider waschen; so sind sie rein. ");
INSERT INTO deu1951_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Alsdann sollen sie einen jungen Farren nehmen samt seinem Speisopfer von Semmelmehl, mit Öl gemengt; und einen anderen jungen Farren sollst du zum Sündopfer nehmen. ");
INSERT INTO deu1951_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Und sollst die Leviten vor die Stiftshütte bringen und die ganze Gemeinde der Kinder Israel versammeln. ");
INSERT INTO deu1951_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Darnach sollst du die Leviten vor den HERRN treten lassen. Und die Kinder Israel sollen ihre Hände auf die Leviten stützen. ");
INSERT INTO deu1951_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Und Aaron soll die Leviten vor dem HERRN weben zum Webopfer seitens der Kinder Israel, daß sie den Dienst des HERRN versehen. ");
INSERT INTO deu1951_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Und die Leviten sollen ihre Hände auf die Häupter der Farren stützen, dann soll einer zum Sündopfer, der andere dem HERRN zum Brandopfer gemacht werden, um den Leviten Sühne zu erwirken. ");
INSERT INTO deu1951_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Und du sollst die Leviten vor Aaron und seine Söhne stellen und sie vor dem HERRN zum Webopfer weben. ");
INSERT INTO deu1951_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Also sollst du die Leviten von den Kindern Israel scheiden, daß sie mein seien. ");
INSERT INTO deu1951_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Darnach sollen sie hineingehen, um in der Stiftshütte zu dienen, nachdem du sie gereinigt und zum Webopfer gemacht hast. ");
INSERT INTO deu1951_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Denn sie sind mir zum Geschenk übergeben von den Kindern Israel; ich habe sie mir genommen an Stelle aller Erstgeburt von den Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Denn alle Erstgeburt der Kinder Israel ist mein, von Menschen und Vieh; an dem Tage, als ich alle Erstgeburt in Ägypten schlug, habe ich sie mir geheiligt. ");
INSERT INTO deu1951_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Und ich habe die Leviten genommen an Stelle aller Erstgeburt unter den Kindern Israel, ");
INSERT INTO deu1951_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","und habe sie Aaron und seinen Söhnen aus den Kindern Israel zum Geschenke gegeben, daß sie den Dienst der Kinder Israel in der Stiftshütte versehen und den Kindern Israel Sühne erwirken, daß die Kinder Israel keine Plage treffe, wenn sie selbst zum Heiligtum nahen wollten. ");
INSERT INTO deu1951_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Und Mose samt Aaron und der ganzen Gemeinde der Kinder Israel taten solches mit den Leviten; ganz wie der HERR Mose geboten hatte betreffs der Leviten, also taten sie mit ihnen. ");
INSERT INTO deu1951_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Und die Leviten entsündigten sich und wuschen ihre Kleider. Und Aaron webte sie zum Webopfer vor dem HERRN und erwirkte ihnen Sühne, daß sie rein wurden. ");
INSERT INTO deu1951_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Darnach gingen sie hinein, daß sie in der Stiftshütte ihr Amt verrichteten vor Aaron und seinen Söhnen; wie der HERR Mose geboten hatte betreffs der Leviten, also taten sie mit ihnen. ");
INSERT INTO deu1951_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Dazu sind die Leviten verpflichtet: von fünfundzwanzig Jahren an und darüber soll einer Dienst tun bei der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Aber vom fünfzigsten Jahre an soll er vom Amt des Dienstes zurücktreten und nicht mehr dienen; ");
INSERT INTO deu1951_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","er mag seinen Brüdern helfen in der Stiftshütte bei der Verrichtung ihres Amtes; aber Dienst soll er nicht mehr tun. Also sollst du es mit den Leviten halten, ihr Amt betreffend. ");
INSERT INTO deu1951_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Und der HERR redete zu Mose in der Wüste Sinai im zweiten Jahr, nachdem sie aus Ägypten gezogen waren, im ersten Monat, und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Laß die Kinder Israel das Passah zur bestimmten Zeit halten! ");
INSERT INTO deu1951_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Am vierzehnten Tage dieses Monats, gegen Abend, sollt ihr es halten, zur bestimmten Zeit; nach allen seinen Satzungen und Rechten haltet es. ");
INSERT INTO deu1951_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Und Mose redete mit den Kindern Israel, daß sie das Passah hielten. ");
INSERT INTO deu1951_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Und sie hielten das Passah am vierzehnten Tage des ersten Monats, gegen Abend, in der Wüste Sinai. Ganz wie der HERR Mose geboten hatte, so taten die Kinder Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Da waren etliche Männer unrein von einem entseelten Menschen, so daß sie das Passah an demselben Tage nicht halten konnten; sie traten vor Mose und Aaron an demselben Tag und sprachen: ");
INSERT INTO deu1951_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Wir sind unrein von einem entseelten Menschen. Warum sollen wir zu kurz kommen, daß wir des HERRN Opfergabe nicht herzubringen dürfen unter den Kindern Israel zur bestimmten Zeit? ");
INSERT INTO deu1951_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose sprach zu ihnen: Wartet, bis ich vernehme, was euch der HERR gebietet! ");
INSERT INTO deu1951_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Sage den Kindern Israel und sprich: Wenn jemand von euch oder von euren Nachkommen durch einen Entseelten unrein wird oder fern auf der Reise ist, so soll er gleichwohl dem HERRN das Passah halten. ");
INSERT INTO deu1951_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Im zweiten Monat, am vierzehnten Tage, gegen Abend, sollen sie es halten und sollen es mit ungesäuertem Brot und bittern Kräutern essen, ");
INSERT INTO deu1951_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","und sollen nichts davon übriglassen bis zum Morgen, auch kein Bein daran zerbrechen; nach der ganzen Passahordnung sollen sie es halten. ");
INSERT INTO deu1951_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Wer aber rein und nicht auf der Reise ist, und läßt es anstehen, das Passah zu halten, eine solche Seele soll ausgerottet werden, weil sie des HERRN Opfergabe nicht zur bestimmten Zeit dargebracht hat; sie soll ihre Sünde tragen! ");
INSERT INTO deu1951_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Und wenn ein Fremdling bei euch wohnt und dem HERRN das Passah halten will, so soll er es nach der Satzung und dem Rechte des Passah halten. Einerlei Satzung soll für euch gelten, für den Fremdling wie für die Landeskinder. ");
INSERT INTO deu1951_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","An dem Tage aber, als die Wohnung aufgerichtet ward, bedeckte die Wolke die Wohnung der Hütte des Zeugnisses, und vom Abend bis zum Morgen war sie über der Wohnung anzusehen wie Feuer. ");
INSERT INTO deu1951_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","So war es beständig; die Wolke bedeckte sie, aber bei Nacht war sie anzusehen wie Feuer. ");
INSERT INTO deu1951_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Sooft sich die Wolke von der Hütte erhob, brachen die Kinder Israel auf; wo aber die Wolke blieb, da lagerten sich die Kinder Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nach dem Gebot des HERRN brachen die Kinder Israel auf, und nach dem Gebot des Herrn lagerten sie sich; solange die Wolke auf der Wohnung blieb, solange lagen sie still. ");
INSERT INTO deu1951_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Und wenn die Wolke viele Tage lang auf der Wohnung verharrte, so beachteten die Kinder Israel den Wink des HERRN und zogen nicht. ");
INSERT INTO deu1951_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Und wenn es vorkam, daß die Wolke nur etliche Tage auf der Wohnung blieb, so lagerten sie sich doch nach dem Gebot des HERRN und zogen nach dem Gebot des HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Und wenn es auch vorkam, daß die Wolke nur vom Abend bis zum Morgen blieb und sich alsdann erhob, so zogen sie; und wenn sie sich des Tages oder des Nachts erhob, so zogen sie auch. ");
INSERT INTO deu1951_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Wenn sie aber zwei Tage oder einen Monat oder längere Zeit auf der Wohnung verblieb, so lagerten sich die Kinder Israel und zogen nicht; erst wenn sie sich erhob, so zogen sie. ");
INSERT INTO deu1951_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Nach dem Befehl des HERRN lagerten sie sich, und nach dem Befehl des HERRN zogen sie; sie achteten auf den Wink des HERRN, gemäß dem Befehl des HERRN, durch Mose. ");
INSERT INTO deu1951_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Und der HERR redete zu Mose und sprach: Mache dir zwei Trompeten; ");
INSERT INTO deu1951_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","von getriebenem Silber sollst du sie machen, daß du sie brauchest, die Gemeinde zusammenzurufen und wenn das Heer aufbrechen soll. ");
INSERT INTO deu1951_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Wenn man in beide stößt, soll sich die ganze Gemeinde vor der Tür der Stiftshütte zu dir versammeln. ");
INSERT INTO deu1951_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Wenn man nur in eine stößt, so sollen sich die Fürsten, die Häupter der Tausende Israels, zu dir versammeln. ");
INSERT INTO deu1951_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Wenn ihr aber Lärm blaset, so sollen die Lager aufbrechen, die gegen Morgen liegen. ");
INSERT INTO deu1951_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Und wenn ihr zum zweitenmal Lärm blaset, so sollen die Lager aufbrechen, die gegen Mittag liegen; denn wenn sie aufbrechen sollen, so soll man Lärm blasen. ");
INSERT INTO deu1951_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Wenn aber die Gemeinde versammelt werden soll, sollt ihr in die Trompete stoßen und nicht Lärm blasen. ");
INSERT INTO deu1951_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Solches Blasen aber mit den Trompeten soll den Söhnen Aarons, des Priesters, obliegen; und das soll euer Gebrauch sein bei euren Nachkommen ewiglich. ");
INSERT INTO deu1951_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Wenn ihr in einen Streit ziehet in eurem Lande wider euren Feind, der euch befehdet, so sollt ihr Lärm blasen mit den Trompeten, daß euer vor dem HERRN, eurem Gott, gedacht werde und ihr von euren Feinden errettet werdet. ");
INSERT INTO deu1951_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Aber an euren Freudentagen, es sei an euren Festen oder an euren Neumonden, sollt ihr in die Trompeten stoßen über euren Brandopfern und euren Dankopfern, daß euer vor eurem Gott gedacht werde; ich, der HERR, bin euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Am zwanzigsten Tag, im zweiten Monat des zweiten Jahres, erhob sich die Wolke über der Wohnung des Zeugnisses. ");
INSERT INTO deu1951_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Und die Kinder Israel brachen auf aus der Wüste Sinai, und die Wolke ließ sich in der Wüste Paran nieder. ");
INSERT INTO deu1951_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Sie brachen aber zum erstenmal in der Reihenfolge auf, die ihnen der HERR durch Mose befohlen hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Es zog nämlich das Panier des Lagers der Kinder Juda zuerst, Schar um Schar; und über ihr Heer war Nahasson, der Sohn Amminadabs. ");
INSERT INTO deu1951_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Und über das Heer des Stammes der Kinder Issaschar war Netaneel, der Sohn Zuars. ");
INSERT INTO deu1951_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Und über das Heer des Stammes der Kinder Sebulon war Eliab, der Sohn Helons. ");
INSERT INTO deu1951_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Darauf wurde die Wohnung abgebrochen; und es zogen die Kinder Gerson und Merari, als Träger der Wohnung. ");
INSERT INTO deu1951_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Darnach zog das Panier des Lagers Ruben mit seinen Heerscharen; und über ihr Heer war Elizur, der Sohn Sedeurs. ");
INSERT INTO deu1951_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Und über das Heer des Stammes der Kinder Simeon war Selumiel, der Sohn Zuri-Schaddais. ");
INSERT INTO deu1951_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Und Eliasaph, der Sohn Deguels, war über das Heer des Stammes der Kinder Gad. ");
INSERT INTO deu1951_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Darauf zogen auch die Kahatiter und trugen das Heiligtum, damit jene die Wohnung aufrichten konnten, bis diese kamen. ");
INSERT INTO deu1951_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Darnach zog das Panier des Lagers der Kinder Ephraim samt seinen Heerscharen; und über ihr Heer war Elischama, der Sohn Ammihuds; ");
INSERT INTO deu1951_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","und Gamliel, der Sohn Pedazurs, war über das Heer des Stammes der Kinder Manasse; ");
INSERT INTO deu1951_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","und Abidan, der Sohn Gideonis, über das Heer des Stammes der Kinder Benjamin. ");
INSERT INTO deu1951_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Darnach zog das Panier des Lagers der Kinder Dan samt seinen Heerscharen, und sie zogen als Nachhut aller Lager; und Ahieser, der Sohn Ammi-Schaddais, war über ihr Heer; ");
INSERT INTO deu1951_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","und Pagiel, der Sohn Ochrans, über das Heer des Stammes der Kinder Asser; ");
INSERT INTO deu1951_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","und Ahira, der Sohn Enans, über das Heer des Stammes der Kinder Naphtali. ");
INSERT INTO deu1951_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Das ist die Reihenfolge, in welcher die Heerscharen der Kinder Israel zogen. ");
INSERT INTO deu1951_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Und Mose sprach zu Hobab, dem Sohne Reguels, des Midianiters, seinem Schwager: Wir ziehen an den Ort, davon der HERR gesagt hat: Ich will ihn euch geben! Komm mit uns, wir wollen dich gut behandeln; denn der HERR hat Israel Gutes zugesagt! ");
INSERT INTO deu1951_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Er aber antwortete: Ich will nicht mit euch gehen, sondern in mein Land und zu meiner Verwandtschaft will ich ziehen. ");
INSERT INTO deu1951_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Er sprach: Verlaß uns doch nicht; denn du weißt, wo wir uns in der Wüste lagern sollen, und du sollst unser Auge sein! ");
INSERT INTO deu1951_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Und wenn du mit uns ziehst, so wollen wir auch an dir tun, was der HERR Gutes an uns tut! ");
INSERT INTO deu1951_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Also zogen sie von dem Berge des Herrn drei Tagereisen weit, und die Lade des Bundes des HERRN zog vor ihnen her diese drei Tagereisen, um ihnen einen Ruheplatz zu erkunden. ");
INSERT INTO deu1951_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Und die Wolke des HERRN war bei Tag über ihnen, wenn sie aus dem Lager zogen. ");
INSERT INTO deu1951_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Und wenn die Lade weiterzog, so sprach Mose: HERR, stehe auf, daß deine Feinde zerstreut werden, und die dich hassen vor dir fliehen! ");
INSERT INTO deu1951_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Und wenn sie ruhte, so sprach er: Kehre wieder, o HERR, zu den Myriaden der Tausende Israels! ");
INSERT INTO deu1951_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Aber das Volk beklagte sich arg vor den Ohren des HERRN. Als der HERR das hörte, entbrannte sein Zorn, und das Feuer des HERRN brannte unter ihnen und verzehrte das Ende des Lagers. ");
INSERT INTO deu1951_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Da schrie das Volk zu Mose. Und Mose bat den HERRN. Da erlosch das Feuer. ");
INSERT INTO deu1951_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Und man hieß den Ort Tabeera, weil das Feuer des HERRN unter ihnen gebrannt hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Und das hergelaufene Gesindel in ihrer Mitte war sehr lüstern geworden, und auch die Kinder Israel fingen wieder an zu weinen und sprachen: Wer will uns Fleisch zu essen geben? ");
INSERT INTO deu1951_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wir gedenken der Fische, die wir in Ägypten umsonst aßen, und der Gurken und Melonen, des Lauchs, der Zwiebeln und des Knoblauchs; ");
INSERT INTO deu1951_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","nun aber ist unsre Seele matt, unsre Augen sehen nichts als das Manna! ");
INSERT INTO deu1951_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Aber das Manna war wie Koriandersamen und anzusehen wie Bedellion. ");
INSERT INTO deu1951_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Und das Volk lief hin und her und sammelte und zermalmte es in Mühlen, oder zerstieß es in Mörsern, und kochte es im Topfe und machte Kuchen daraus; und es hatte einen Geschmack wie Ölkuchen. ");
INSERT INTO deu1951_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Und wenn des Nachts der Tau über das Lager fiel, so fiel das Manna zugleich darauf herab. ");
INSERT INTO deu1951_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Als nun Mose das Volk weinen hörte, in jeder Familie einen jeden an der Tür seiner Hütte, da entbrannte der Zorn des HERRN sehr, und es mißfiel auch Mose. ");
INSERT INTO deu1951_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Und Mose sprach zum HERRN: Warum tust du so übel an deinem Knecht? Und warum finde ich nicht Gnade vor deinen Augen, daß du die Last dieses ganzen Volkes auf mich legst? ");
INSERT INTO deu1951_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Habe ich denn dieses ganze Volk empfangen oder geboren, daß du zu mir sagst: Trag es an deinem Busen, wie der Wärter einen Säugling trägt, in das Land, das du ihren Vätern geschworen hast? ");
INSERT INTO deu1951_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Woher soll ich Fleisch nehmen, um es diesem ganzen Volk zu geben? Denn sie weinen vor mir und sprechen: Gib uns Fleisch, daß wir essen! ");
INSERT INTO deu1951_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ich kann dieses ganze Volk nicht allein tragen; denn es ist mir zu schwer. ");
INSERT INTO deu1951_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Und so du also mit mir tun willst, so töte mich lieber, habe ich anders Gnade vor deinen Augen gefunden, daß ich mein Unglück nicht mehr ansehen muß! ");
INSERT INTO deu1951_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Da sprach der HERR zu Mose: Sammle mir siebzig Männer aus den Ältesten Israels, von denen du weißt, daß sie Älteste des Volkes und seine Vorsteher sind, und nimm sie vor die Stiftshütte, daß sie daselbst bei dir stehen; ");
INSERT INTO deu1951_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","so will ich herabkommen und daselbst mit dir reden, und von dem Geiste, der auf dir ist, nehmen und auf sie legen, daß sie samt dir die Last des Volkes tragen, daß du dieselbe nicht allein tragest. ");
INSERT INTO deu1951_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Und du sollst zum Volke sagen: Heiligt euch für morgen, und ihr werdet Fleisch essen; denn euer Weinen ist vor die Ohren des HERRN gekommen, da ihr sprechet: «Wer gibt uns Fleisch zu essen? denn es ging uns wohl in Ägypten.» Darum wird euch der HERR Fleisch zu essen geben; ");
INSERT INTO deu1951_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","und ihr sollt nicht bloß einen Tag lang essen, nicht zwei, nicht fünf, nicht zehn, nicht zwanzig Tage lang, ");
INSERT INTO deu1951_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","sondern einen ganzen Monat lang, bis es euch zur Nase herausgeht und euch zum Ekel wird, darum, daß ihr den HERRN, der mitten unter euch ist, verworfen habt; weil ihr vor ihm geweint und gesagt habt: «Warum sind wir aus Ägypten gezogen?» ");
INSERT INTO deu1951_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Und Mose sprach: Sechshunderttausend Mann Fußvolk sind es, darunter ich bin, und du sprichst: Ich will ihnen Fleisch geben, daß sie einen Monat lang zu essen haben! ");
INSERT INTO deu1951_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Soll man Schafe und Rinder schlachten, daß es für sie genug sei? Oder werden sich alle Fische des Meeres herzusammeln, daß es für sie genug sei? ");
INSERT INTO deu1951_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Der HERR aber sprach zu Mose: Ist denn die Hand des HERRN verkürzt? Jetzt sollst du sehen, ob mein Wort eintreffen wird vor dir oder nicht! ");
INSERT INTO deu1951_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Da ging Mose hin und sagte dem Volke das Wort des HERRN und versammelte siebzig Männer aus den Ältesten des Volkes und stellte sie um die Hütte her. ");
INSERT INTO deu1951_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Da kam der HERR herab in der Wolke und redete mit ihm, und nahm von dem Geiste, der auf ihm war, und legte ihn auf die siebzig Ältesten; und als der Geist auf ihnen ruhte, weissagten sie, aber nicht fortgesetzt. ");
INSERT INTO deu1951_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Und im Lager waren noch zwei Männer geblieben; der eine hieß Eldad, der andere Medad, und der Geist ruhte auch auf ihnen. Denn sie waren auch angeschrieben und doch nicht hinausgegangen zu der Hütte; sondern sie weissagten im Lager. ");
INSERT INTO deu1951_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Da lief ein Knabe hin und sagte es Mose und sprach: Eldad und Medad weissagen im Lager! ");
INSERT INTO deu1951_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Da antwortete Josua, der Sohn Nuns, der Moses Diener war von seiner Jugend an, und sprach: Mein Herr Mose, wehre ihnen! ");
INSERT INTO deu1951_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Aber Mose sprach zu ihm: Eiferst du für mich? Ach, daß doch alles Volk des HERRN weissagte, möchte der HERR seinen Geist über sie geben! ");
INSERT INTO deu1951_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hierauf begab sich Mose ins Lager, er und die Ältesten Israels. ");
INSERT INTO deu1951_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Da fuhr ein Wind aus von dem HERRN und brachte Wachteln vom Meere her und streute sie über das Lager, eine Tagereise weit hier und eine Tagereise weit dort, um das Lager her, bei zwei Ellen hoch über der Erde. ");
INSERT INTO deu1951_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Da machte sich das Volk auf denselben ganzen Tag und die ganze Nacht und den ganzen folgenden Tag; und wer am wenigsten sammelte, der sammelte zehn Homer, und sie breiteten sie weithin aus um das ganze Lager her. ");
INSERT INTO deu1951_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Als aber das Fleisch noch unter ihren Zähnen und noch nicht verzehrt war, da entbrannte der Zorn des HERRN über das Volk, und der HERR schlug sie mit einer großen Plage. ");
INSERT INTO deu1951_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Daher hießen sie denselben Ort Lustgräber, weil man daselbst das lüsterne Volk begrub. ");
INSERT INTO deu1951_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Von den Lustgräbern aber zog das Volk aus und blieb zu Hazerot. ");
INSERT INTO deu1951_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mirjam aber und Aaron redeten wider Mose wegen des äthiopischen Weibes, das er genommen hatte; denn er hatte eine Äthiopierin zum Weibe genommen. ");
INSERT INTO deu1951_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Sie sprachen nämlich: Redet denn der HERR allein durch Mose? Redet er nicht auch durch uns? ");
INSERT INTO deu1951_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Und der HERR hörte es. Aber Mose war ein sehr sanftmütiger Mann, sanftmütiger als alle Menschen auf Erden. ");
INSERT INTO deu1951_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Da sprach der HERR plötzlich zu Mose und zu Aaron und zu Mirjam: Gehet ihr drei zur Stiftshütte hinaus! Da gingen alle drei hinaus. ");
INSERT INTO deu1951_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Da kam der HERR in der Wolkensäule herab und trat unter die Tür der Hütte und rief Aaron und Mirjam. ");
INSERT INTO deu1951_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Als sie nun beide hinausgingen, sprach er: Höret doch meine Worte: Ist jemand unter euch ein Prophet, dem will ich, der HERR, mich in einem Gesicht offenbaren, oder ich will in einem Traum mit ihm reden. ");
INSERT INTO deu1951_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Aber nicht also mein Knecht Mose: er ist treu in meinem ganzen Hause. ");
INSERT INTO deu1951_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mündlich rede ich mit ihm und von Angesicht und nicht rätselhaft, und er schaut die Gestalt des HERRN. Warum habt ihr euch denn nicht gefürchtet, wider meinen Knecht Mose zu reden? ");
INSERT INTO deu1951_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Und der Zorn des HERRN entbrannte über sie, und er ging; ");
INSERT INTO deu1951_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","und die Wolke wich von der Hütte. Und siehe, da war Mirjam aussätzig wie Schnee. Und Aaron wandte sich zu Mirjam, und siehe, sie war aussätzig. ");
INSERT INTO deu1951_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Und Aaron sprach zu Mose: Ach, mein HERR, laß die Sünde nicht auf uns liegen, da wir töricht gehandelt und uns versündigt haben; ");
INSERT INTO deu1951_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","daß doch diese nicht sei wie ein totes Kind, das von seiner Mutter Leibe kommt, und dessen Fleisch schon halb verwest ist! ");
INSERT INTO deu1951_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Mose aber schrie zu dem HERRN und sprach: Ach Gott, heile sie! Der HERR sprach zu Mose: ");
INSERT INTO deu1951_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Wenn ihr Vater ihr ins Angesicht gespieen hätte, müßte sie sich nicht sieben Tage lang schämen? Laß sie sich sieben Tage lang außerhalb des Lagers einschließen, darnach mag sie wieder aufgenommen werden. ");
INSERT INTO deu1951_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Also ward Mirjam sieben Tage lang aus dem Lager ausgeschlossen; und das Volk zog nicht weiter, bis Mirjam wieder aufgenommen ward. ");
INSERT INTO deu1951_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Darnach brach das Volk auf von Hazerot und lagerte sich in der Wüste Paran. ");
INSERT INTO deu1951_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Sende Männer aus, daß sie das Land Kanaan auskundschaften, das ich den Kindern Israel geben will. Von jedem Stamm ihrer Väter sollt ihr einen Mann schicken, lauter Fürsten aus ihrer Mitte. ");
INSERT INTO deu1951_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Und Mose sandte sie aus der Wüste Paran nach dem Befehl des HERRN, lauter Männer, die Häupter waren unter den Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Und das sind ihre Namen: Sammua, der Sohn Sackurs, vom Stamme Ruben. ");
INSERT INTO deu1951_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Saphat, der Sohn Horis, vom Stamme Simeon. ");
INSERT INTO deu1951_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kaleb, der Sohn Jephunnes, vom Stamme Juda. ");
INSERT INTO deu1951_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Jigeal, der Sohn Josephs, vom Stamme Issaschar. ");
INSERT INTO deu1951_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hosea, der Sohn Nuns, vom Stamme Ephraim. ");
INSERT INTO deu1951_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti, der Sohn Raphus, vom Stamme Benjamin. ");
INSERT INTO deu1951_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gadiel, der Sohn Sodis, vom Stamme Sebulon. ");
INSERT INTO deu1951_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gaddi, der Sohn Susis, vom Stamme Josephs, von Manasse. ");
INSERT INTO deu1951_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Ammiel, der Sohn Gemallis, vom Stamme Dan. ");
INSERT INTO deu1951_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Sethur, der Sohn Michaels, vom Stamme Asser. ");
INSERT INTO deu1951_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nachbi, der Sohn Waphsis, vom Stamme Naphtali. ");
INSERT INTO deu1951_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Geuel, der Sohn Machis, vom Stamme Gad. ");
INSERT INTO deu1951_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Das sind die Namen der Männer, die Mose aussandte, das Land auszukundschaften. Aber Hosea, den Sohn Nuns, nannte Mose Josua. ");
INSERT INTO deu1951_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Als nun Mose sie sandte, das Land Kanaan auszukundschaften, sprach er zu ihnen: Ziehet hinauf in die Mittagsgegend und besteiget das Gebirge; ");
INSERT INTO deu1951_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","und besehet das Land, wie es sei; und das Volk, das darin wohnt, ob es stark oder schwach, gering oder zahlreich sei; ");
INSERT INTO deu1951_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","und was es für ein Land sei, darin sie wohnen, ob es gut oder schlecht sei, und was für Städte es seien, darin sie wohnen, ob es offene Orte oder Festungen seien, ");
INSERT INTO deu1951_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","und was es für ein Land sei, ob es fett oder mager sei, und ob Bäume darin seien oder nicht. Seid getrost und nehmet von den Früchten des Landes! Es war aber eben die Zeit, da man frühzeitige Trauben fand. ");
INSERT INTO deu1951_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Sie gingen hinauf und kundschafteten das Land aus von der Wüste Zin bis gen Rechob, da man gen Hamat geht. ");
INSERT INTO deu1951_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Sie gingen auch hinauf in die Mittagsgegend und kamen bis gen Hebron; daselbst waren Achiman, Sesai und Talmai, Kinder Enaks. Hebron aber war sieben Jahre vor Zoan in Ägypten erbaut worden. ");
INSERT INTO deu1951_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Und sie kamen bis in das Tal Eskol und schnitten daselbst eine Weinrebe ab mit einer Weintraube und ließen sie zu zweien an einer Stange tragen, dazu auch Granatäpfel und Feigen. ");
INSERT INTO deu1951_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Den Ort hieß man das Tal Eskol, um der Weintraube willen, welche die Kinder Israel daselbst abgeschnitten haben. ");
INSERT INTO deu1951_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Und nachdem sie das Land ausgekundschaftet hatten vierzig Tage lang, ");
INSERT INTO deu1951_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","kehrten sie zurück und gingen hin und kamen zu Mose und Aaron und zu der ganzen Gemeinde der Kinder Israel, in die Wüste Paran, gen Kadesch; und sie brachten ihnen und der ganzen Gemeinde Bericht und ließen sie die Früchte des Landes sehen und erzählten ihm und sprachen: ");
INSERT INTO deu1951_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wir sind in das Land gekommen, dahin du uns sandtest, das wirklich von Milch und Honig fließt, und dieses ist seine Frucht. ");
INSERT INTO deu1951_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Aber das Volk, welches im Lande wohnt, ist stark, und die Städte sind sehr fest und groß. Und wir sahen auch Enakskinder daselbst. ");
INSERT INTO deu1951_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Die Amalekiter wohnen im Süden; die Hetiter, Jebusiter und Amoriter aber wohnen auf dem Gebirge, und die Kanaaniter am Meer und um den Jordan. ");
INSERT INTO deu1951_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb aber beschwichtigte das Volk gegen Mose und sprach: Lasset uns hinaufziehen und das Land einnehmen, denn wir können es überwältigen! ");
INSERT INTO deu1951_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Aber die Männer, die mit hinaufgezogen waren, sprachen: Wir können nicht hinaufziehen gegen das Volk, denn es ist uns zu stark! ");
INSERT INTO deu1951_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Und sie brachten das Land, das sie erkundigt hatten, in Verruf bei den Kindern Israel und sprachen: Das Land, das wir durchzogen haben, um es auszukundschaften, frißt seine Einwohner, und alles Volk, das wir darin sahen, sind Leute von hohem Wuchs. ");
INSERT INTO deu1951_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Wir sahen auch Riesen daselbst, Enakskinder aus dem Riesengeschlecht, und wir waren in unsern Augen wie Heuschrecken, und also waren wir auch in ihren Augen! ");
INSERT INTO deu1951_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Da erhob die ganze Gemeinde ihre Stimme und schrie, und das Volk weinte dieselbe Nacht. ");
INSERT INTO deu1951_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Und alle Kinder Israel murrten wider Mose und Aaron; und die ganze Gemeinde sprach zu ihnen: Ach, daß wir doch in Ägypten gestorben wären, oder noch in dieser Wüste stürben! ");
INSERT INTO deu1951_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Warum führt uns der HERR in dieses Land, daß wir durch das Schwert fallen, und daß unsre Weiber und unsre Kinder zum Raube werden? Ist es nicht besser, wir ziehen wieder nach Ägypten? ");
INSERT INTO deu1951_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Und sie sprachen zueinander: Wir wollen uns selbst einen Anführer geben und wieder nach Ägypten ziehen! ");
INSERT INTO deu1951_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mose aber und Aaron fielen auf ihr Angesicht vor der ganzen Versammlung der Gemeinde der Kinder Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Und Josua, der Sohn Nuns, und Kaleb, der Sohn Jephunnes, die auch das Land erkundigt hatten, zerrissen ihre Kleider und sprachen zu der ganzen Gemeinde der Kinder Israel: ");
INSERT INTO deu1951_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Das Land, das wir durchwandelt haben, um es auszukundschaften, ist ein sehr, sehr gutes Land! ");
INSERT INTO deu1951_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Wenn der HERR Lust zu uns hat, so wird er uns in dieses Land bringen und es uns geben; ein Land, das von Milch und Honig fließt. ");
INSERT INTO deu1951_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Seid nur nicht widerspenstig gegen den HERRN und fürchtet euch nicht vor dem Volke dieses Landes; denn wir wollen sie verschlingen wie Brot. Ihr Schirm ist von ihnen gewichen, mit uns aber ist der HERR; fürchtet euch nicht vor ihnen! ");
INSERT INTO deu1951_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Da sprach die ganze Gemeinde, man sollte sie steinigen. Aber die Herrlichkeit des HERRN erschien bei der Stiftshütte allen Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Und der HERR sprach zu Mose: Wie lange lästert mich dieses Volk? Und wie lange wollen sie nicht an mich glauben, trotz aller Zeichen, die ich unter ihnen getan habe? ");
INSERT INTO deu1951_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ich will sie mit Pestilenz schlagen und ausrotten und dich zu einem größern und mächtigeren Volk machen, als dieses ist! ");
INSERT INTO deu1951_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mose aber sprach zum HERRN: So werden es die Ägypter hören; da du doch dieses Volk durch deine Kraft aus ihrer Mitte geführt hast! ");
INSERT INTO deu1951_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","So wird man es auch den Einwohnern dieses Landes sagen, welche gehört haben, daß du, der HERR, unter diesem Volke seiest, und daß du, der HERR, von Angesicht zu Angesicht gesehen werdest und deine Wolke über ihnen stehe und du vor ihnen her bei Tag in der Wolkensäule und des Nachts in der Feuersäule gehest. ");
INSERT INTO deu1951_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Würdest du nun dieses Volk töten wie einen Mann, so würden die Heiden sagen, die solches Gerücht von dir hören: ");
INSERT INTO deu1951_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Der HERR konnte dieses Volk nicht in das Land bringen, das er ihnen geschworen hatte, darum hat er sie in der Wüste umgebracht! ");
INSERT INTO deu1951_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","So laß nun die Kraft des HERRN groß werden, wie du gesagt und gesprochen hast: ");
INSERT INTO deu1951_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Der HERR ist geduldig und von großer Barmherzigkeit; er vergibt Missetat und Übertretungen, obgleich er keineswegs ungestraft läßt, sondern heimsucht der Väter Missetat an den Kindern, bis in das dritte und vierte Glied. ");
INSERT INTO deu1951_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","So sei nun gnädig der Missetat dieses Volkes nach deiner großen Barmherzigkeit, wie du auch diesem Volk aus Ägypten bis hierher vergeben hast! ");
INSERT INTO deu1951_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Da sprach der HERR: Ich habe vergeben, wie du gesagt hast. ");
INSERT INTO deu1951_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Aber so wahr ich lebe und die Herrlichkeit des HERRN die ganze Erde füllen soll: ");
INSERT INTO deu1951_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","keiner der Männer, die meine Herrlichkeit und meine Zeichen gesehen haben, die ich in Ägypten und in der Wüste getan, und die mich nun zehnmal versucht und meiner Stimme nicht gehorcht haben, ");
INSERT INTO deu1951_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","soll das Land sehen, das ich ihren Vätern geschworen habe; ja, keiner soll es sehen, der mich gelästert hat! ");
INSERT INTO deu1951_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Aber meinen Knecht Kaleb, in dem ein anderer Geist ist, und der mir völligen Gehorsam geleistet hat, den will ich in das Land bringen, in das er gegangen ist, und sein Same soll es erblich besitzen. ");
INSERT INTO deu1951_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Aber die Amalekiter und Kanaaniter liegen im Tale; darum wendet euch morgen und ziehet in die Wüste auf dem Wege zum Schilfmeer! ");
INSERT INTO deu1951_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Wie lange soll ich diese böse Gemeinde dulden, die wider mich murrt? Ich habe das Murren der Kinder Israel gehört, welches sie wider mich erheben. ");
INSERT INTO deu1951_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Darum sprich zu ihnen: So wahr ich lebe, spricht der HERR, ich will euch tun, wie ihr vor meinen Ohren gesagt habt: ");
INSERT INTO deu1951_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Eure Leichname sollen in dieser Wüste zerfallen, und alle eure Gemusterten, die ganze Zahl, von zwanzig Jahren an und darüber, die ihr wider mich gemurrt habt, ");
INSERT INTO deu1951_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","keiner von euch soll in das Land kommen, darüber ich meine Hand aufgehoben habe, daß ich euch darin wohnen ließe, ausgenommen Kaleb, der Sohn Jephunnes, und Josua, der Sohn Nuns. ");
INSERT INTO deu1951_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Eure Kinder aber, von denen ihr sagtet, daß sie zum Raube sein würden, die will ich hineinbringen, damit sie sehen, was das für ein Land ist, das ihr verachtet habt. ");
INSERT INTO deu1951_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Eure eigenen Leiber aber sollen in dieser Wüste fallen. ");
INSERT INTO deu1951_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Und eure Kinder sollen in der Wüste vierzig Jahre lang Hirten sein und eure Unzucht tragen, bis eure Leiber in der Wüste aufgerieben sind; ");
INSERT INTO deu1951_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","nach der Zahl der vierzig Tage, in denen ihr das Land erkundet habt (so daß je ein Tag ein Jahr gilt) sollt ihr vierzig Jahre lang eure Missetat tragen, damit ihr erfahret, was es sei, wenn ich die Hand abziehe! ");
INSERT INTO deu1951_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ich, der HERR, habe es gesagt: Fürwahr, ich werde solches dieser ganzen bösen Gemeinde tun, die sich wider mich versammelt hat; in dieser Wüste sollen sie aufgerieben werden und daselbst sterben! ");
INSERT INTO deu1951_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Die Männer aber, welche Mose gesandt hatte, das Land zu erkunden, und die wiedergekommen waren und machten, daß die ganze Gemeinde wider ihn murrte, indem sie das Land in Verruf brachten; ");
INSERT INTO deu1951_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","diese Männer, welche das Land in Verruf brachten, starben an einer Plage vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Aber Josua, der Sohn Nuns, und Kaleb, der Sohn Jephunnes, blieben am Leben von den Männern, die gegangen waren, das Land auszukundschaften. ");
INSERT INTO deu1951_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Als nun Mose diese Worte zu den Kindern Israel redete, da trauerte das Volk sehr. ");
INSERT INTO deu1951_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Und sie machten sich am Morgen früh auf und zogen auf die Höhe des Gebirges und sprachen: Siehe, hier sind wir, und wir wollen hinaufziehen an den Ort, davon der HERR gesagt hat; denn wir haben gesündigt! Mose aber sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Warum übertretet ihr also das Wort des HERRN? Es wird euch nicht gelingen. ");
INSERT INTO deu1951_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ziehet nicht hinauf, denn der HERR ist nicht unter euch; damit ihr nicht von euren Feinden geschlagen werdet! ");
INSERT INTO deu1951_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Denn die Amalekiter und Kanaaniter sind daselbst vor euch, und ihr werdet durch das Schwert fallen; denn weil ihr euch von der Nachfolge des HERRN abgewendet habt, so wird der HERR nicht mit euch sein. ");
INSERT INTO deu1951_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Aber sie waren vermessen und wollten auf die Höhe des Gebirges ziehen; doch weder die Lade des Bundes des HERRN noch Mose verließen das Lager. ");
INSERT INTO deu1951_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Da kamen die Amalekiter und Kanaaniter, die auf dem Gebirge lagen, und schlugen und zerstreuten sie bis gen Horma. ");
INSERT INTO deu1951_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Und der HERR redete zu Mose und sprach: Rede mit den Kindern Israel und sprich zu ihnen: ");
INSERT INTO deu1951_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Wenn ihr in das Land kommt, das ich euch zum Wohnsitz geben will, ");
INSERT INTO deu1951_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","und dem HERRN ein Feueropfer bringen wollt, es sei ein Brandopfer oder Schlachtopfer, um ein besonderes Gelübde zu erfüllen oder ein freiwilliges Opfer, oder eure Festopfer, die ihr dem HERRN zum lieblichen Geruch darbringt, von Rindern oder von Schafen, ");
INSERT INTO deu1951_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","so soll der, welcher dem HERRN sein Opfer darbringen will, zugleich als Speisopfer ein Zehntel Epha Semmelmehl, gemengt mit einem Viertel Hin Öl darbringen, ");
INSERT INTO deu1951_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ferner Wein zum Trankopfer, auch ein Viertel Hin zum Brandopfer oder zum Schlachtopfer, wenn ein Lamm geopfert wird. ");
INSERT INTO deu1951_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Wenn aber ein Widder geopfert wird, sollst du das Speisopfer machen mit zwei Zehnteln Semmelmehl, gemengt mit einem Drittel Hin Öl; ");
INSERT INTO deu1951_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","und Wein zum Trankopfer, auch ein Drittel Hin; das sollst du dem HERRN opfern zum lieblichen Geruch. ");
INSERT INTO deu1951_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Willst du aber einen Farren zum Brandopfer oder zum Schlachtopfer darbringen, um ein Gelübde zu erfüllen oder zum Dankopfer dem HERRN, ");
INSERT INTO deu1951_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","so sollst du zu dem Farren das Speisopfer tun, drei Zehntel Semmelmehl, gemengt mit einem halben Hin Öl; ");
INSERT INTO deu1951_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","und sollst Wein darbringen, als Trankopfer, auch ein halbes Hin. Das ist ein Feueropfer, dem HERRN zum lieblichen Geruch. ");
INSERT INTO deu1951_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Also soll man verfahren mit einem Ochsen, mit einem Widder, mit einem Lamm, oder mit einer Ziege. ");
INSERT INTO deu1951_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Entsprechend der Zahl dieser Opfer soll auch die Zahl der Speisopfer und Trankopfer sein. ");
INSERT INTO deu1951_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Alle Landeskinder sollen also tun, wenn sie dem HERRN ein Feueropfer zum lieblichen Geruch darbringen. ");
INSERT INTO deu1951_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Und wenn ein Fremdling bei euch wohnt, oder wer sonst unter euch sein wird bei euren Nachkommen, und dem HERRN ein Feueropfer darbringen will zum lieblichen Geruch, der soll so tun, wie ihr tut. ");
INSERT INTO deu1951_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","In der ganzen Gemeinde soll einerlei Satzung gelten, für euch und für den Fremdling; eine ewige Satzung soll das sein euren Nachkommen; wie ihr, so soll auch der Fremdling sein vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ein Gesetz und ein Recht gilt für euch und für den Fremdling, der sich bei euch aufhält. ");
INSERT INTO deu1951_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Rede mit den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommt, darein ich euch bringen werde, ");
INSERT INTO deu1951_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","und ihr vom Brot des Landes esset, sollt ihr für den HERRN eine Abgabe erheben. ");
INSERT INTO deu1951_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Vom Erstling eures Schrotmehls sollt ihr einen Kuchen als Hebopfer erheben; wie die Abgabe von der Tenne sollt ihr sie erheben. ");
INSERT INTO deu1951_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ihr sollt dem HERRN von den Erstlingen eures Schrotmehls ein Hebopfer geben von Geschlecht zu Geschlecht. ");
INSERT INTO deu1951_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Und wenn ihr aus Versehen eines dieser Gebote nicht haltet, welche der HERR zu Mose geredet hat ");
INSERT INTO deu1951_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","von allem, was der HERR euch durch Mose geboten hat, von dem Tage an, als der HERR anfing zu gebieten, und weiterhin auf alle eure Geschlechter ");
INSERT INTO deu1951_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","wenn es ohne Vorwissen der Gemeinde geschehen ist, so soll die ganze Gemeinde einen jungen Farren zum Brandopfer darbringen, zum lieblichen Geruch dem HERRN, samt seinem Speisopfer und Trankopfer, wie es verordnet ist, und einen Ziegenbock zum Sündopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Und der Priester soll also der ganzen Gemeinde der Kinder Israel Sühne erwirken, so wird ihnen vergeben werden; denn es war ein Versehen. Darum haben sie ihre Gaben dargebracht zum Feueropfer dem HERRN, dazu ihr Sündopfer vor den HERRN, für ihr Versehen. ");
INSERT INTO deu1951_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","So wird der ganzen Gemeinde der Kinder Israel vergeben werden, dazu auch dem Fremdling, der unter euch wohnt; denn das ganze Volk war im Irrtum. ");
INSERT INTO deu1951_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Wenn aber eine einzelne Seele aus Versehen sündigen wird, die soll eine einjährige Ziege zum Sündopfer bringen. ");
INSERT INTO deu1951_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Und der Priester soll dieser Seele, welche unvorsätzlich, aus Versehen gesündigt hat, vor dem HERRN Sühne erwirken, so wird ihr vergeben werden. ");
INSERT INTO deu1951_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Es soll einerlei Gesetz gelten, wenn jemand aus Versehen etwas tut, sowohl für den Einheimischen unter den Kindern Israel als auch für den Fremdling, der unter euch wohnt. ");
INSERT INTO deu1951_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Wenn aber eine Seele aus Frevel etwas tut (es sei ein Einheimischer oder ein Fremdling) so lästert sie den HERRN; solche Seele soll ausgerottet werden mitten aus ihrem Volk; ");
INSERT INTO deu1951_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","denn sie hat des HERRN Wort verachtet und sein Gebot gebrochen; eine solche Seele soll unbedingt ausgerottet werden; ihre Schuld bleibe auf ihr! ");
INSERT INTO deu1951_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Als die Kinder Israel in der Wüste waren, fanden sie einen Mann, der am Sabbat Holz sammelte. ");
INSERT INTO deu1951_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Da brachten ihn die, welche ihn beim Holzsammeln ertappt hatten, zu Mose und Aaron und vor die ganze Gemeinde. ");
INSERT INTO deu1951_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Und sie taten ihn in Gewahrsam; denn es war nicht klar ausgedrückt, was man mit ihm tun sollte. ");
INSERT INTO deu1951_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Der HERR aber sprach zu Mose: Der Mann muß unbedingt sterben; die ganze Gemeinde soll ihn außerhalb des Lagers steinigen! ");
INSERT INTO deu1951_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Da führte ihn die ganze Gemeinde vor das Lager hinaus, und sie steinigten ihn, daß er starb, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Rede mit den Kindern Israel und sage ihnen, daß sie sich Quasten machen an die Zipfel ihrer Kleider, in all ihren Geschlechtern, und eine Schnur von blauem Purpur an die Quaste des Zipfels tun. ");
INSERT INTO deu1951_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Und die Quaste soll euch dazu dienen, daß ihr bei ihrem Anblick aller Gebote des HERRN gedenket und sie befolget, daß ihr nicht den Trieben eures Herzens nachgehet und euren Augen nachbuhlet; ");
INSERT INTO deu1951_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","sondern, daß ihr an alle meine Gebote gedenket und sie tut und ihr eurem Gott heilig seid. ");
INSERT INTO deu1951_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ich, der HERR, bin euer Gott, der ich euch aus Ägypten geführt habe, daß ich euer Gott sei, ich, der HERR, euer Gott. ");
INSERT INTO deu1951_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Und Korah, der Sohn Jizhars, des Sohnes Kahats, des Sohnes Levis, nahm Datan und Abiram, die Söhne Eliabs, und On, den Sohn Pelets, die Söhne Rubens; ");
INSERT INTO deu1951_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","und sie empörten sich wider Mose, samt zweihundertundfünfzig Männern aus den Kindern Israel, Hauptleuten der Gemeinde, Berufenen der Versammlung, angesehenen Männern. ");
INSERT INTO deu1951_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Und sie versammelten sich wider Mose und Aaron und sprachen zu ihnen: Ihr beansprucht zu viel; denn die ganze Gemeinde ist überall heilig, und der HERR ist in ihrer Mitte! Warum erhebet ihr euch über die Gemeinde des HERRN? ");
INSERT INTO deu1951_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Als Mose solches hörte, warf er sich auf sein Angesicht und sprach zu Korah und zu seiner ganzen Rotte also: ");
INSERT INTO deu1951_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Morgen wird der HERR kundtun, wer ihm angehört, und wer heilig sei, daß er ihn zu sich nahen lasse. Wen er erwählt, den wird er zu sich nahen lassen. ");
INSERT INTO deu1951_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Korah und seine ganze Rotte, tut das: Nehmet für euch Räucherpfannen ");
INSERT INTO deu1951_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","und leget Feuer darein und tut Räucherwerk darauf vor dem HERRN, morgen; ");
INSERT INTO deu1951_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","wen der HERR erwählt, der sei heilig. Ihr beansprucht zu viel, ihr Kinder Levis. Und Mose sprach zu Korah: Höret doch, ihr Kinder Levis! ");
INSERT INTO deu1951_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ist es euch zu wenig, daß euch der Gott Israels von der Gemeinde Israels ausgesondert hat, daß ihr euch zu ihm nahen sollt, daß ihr den Dienst an der Wohnung des HERRN versehet und vor der Gemeinde stehet, ihr zu dienen? ");
INSERT INTO deu1951_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Er hat dich und alle deine Brüder, die Kinder Levis, samt dir zu ihm nahen lassen, und ihr begehret nun auch das Priestertum? ");
INSERT INTO deu1951_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Fürwahr, du und deine ganze Rotte, ihr verbündet euch wider den HERRN. Was ist Aaron, daß ihr wider ihn murret? ");
INSERT INTO deu1951_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Und Mose schickte hin und ließ Datan und Abiram, die Söhne Eliabs, rufen. Sie aber sprachen: Wir kommen nicht hinauf! ");
INSERT INTO deu1951_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ist es zu wenig, daß du uns aus einem Lande geführt hast, das von Milch und Honig fließt, um uns in der Wüste zu töten? Willst du auch noch über uns herrschen? ");
INSERT INTO deu1951_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Wie fein hast du uns in ein Land gebracht, das von Milch und Honig fließt, und hast uns Äcker und Weinberge zum Erbteil gegeben! Willst du diesen Leuten auch die Augen ausstechen? Wir kommen nicht hinauf! ");
INSERT INTO deu1951_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Da ergrimmte Mose sehr und sprach zu dem HERRN: Wende dich nicht zu ihrem Speisopfer! Ich habe nicht einen Esel von ihnen genommen und habe keinem jemals ein Leid getan! ");
INSERT INTO deu1951_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Und Mose sprach zu Korah: Du und deine ganze Rotte, kommmt morgen vor den HERRN, du und sie und Aaron. ");
INSERT INTO deu1951_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Und ein jeder nehme seine Räucherpfanne und lege Räucherwerk darauf und trete herzu vor den HERRN, ein jeder mit seiner Räucherpfanne; das sind 250 Räucherpfannen, auch du und Aaron, nehmet ein jeder seine Räucherpfanne mit! ");
INSERT INTO deu1951_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Da nahm jeder seine Räucherpfanne und legte Feuer darein und tat Räucherwerk darauf, und sie standen vor der Tür der Stiftshütte, auch Mose und Aaron. ");
INSERT INTO deu1951_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Und Korah versammelte wider sie die ganze Gemeinde vor die Tür der Stiftshütte. Da erschien die Herrlichkeit des HERRN vor der ganzen Gemeinde. ");
INSERT INTO deu1951_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Und der HERR redete zu Mose und Aaron und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Scheidet euch von dieser Gemeinde, daß ich sie in einem Augenblick vertilge! ");
INSERT INTO deu1951_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Sie fielen aber auf ihr Angesicht und sprachen: O Gott, du Gott der Geister alles Fleisches, ein Mann hat gesündigt, und du willst über die ganze Gemeinde zürnen? ");
INSERT INTO deu1951_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Da redete der HERR zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Sage der Gemeinde und sprich: Entfernt euch ringsum von der Wohnung Korahs, Datans und Abirams! ");
INSERT INTO deu1951_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Da stand Mose auf und ging zu Datan und Abiram, und die Ältesten Israels folgten ihm. ");
INSERT INTO deu1951_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Und er redete mit der Gemeinde und sprach: Weichet doch von den Hütten dieser gottlosen Menschen und rühret nichts an von allem, was ihnen gehört, damit ihr nicht weggerafft werdet um aller ihrer Sünden willen! ");
INSERT INTO deu1951_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Da entfernten sie sich ringsum von der Wohnung Korahs, Datans und Abirams. Datan aber und Abiram kamen heraus und traten an die Tür ihrer Hütten mit ihren Weibern und Söhnen und Kindern. ");
INSERT INTO deu1951_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Und Mose sprach: Daran sollt ihr merken, daß der HERR mich gesandt hat, alle diese Werke zu tun, und daß sie nicht aus meinem Herzen kommen: ");
INSERT INTO deu1951_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","werden diese sterben, wie alle Menschen sterben und gestraft werden mit einer Strafe, wie sie alle Menschen trifft, so hat der HERR mich nicht gesandt; ");
INSERT INTO deu1951_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","wird aber der HERR etwas Neues schaffen, daß die Erde ihren Mund auftut und sie verschlingt mit allem, was sie haben, daß sie lebendig hinunterfahren ins Totenreich, so werdet ihr erkennen, daß diese Leute den HERRN gelästert haben! ");
INSERT INTO deu1951_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Und es geschah, als er alle diese Worte ausgeredet hatte, da zerriß die Erde unter ihnen; ");
INSERT INTO deu1951_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","und die Erde tat ihren Mund auf und verschlang sie samt ihren Häusern und samt allen Menschen, die bei Korah waren, und mit aller ihrer Habe. ");
INSERT INTO deu1951_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Und sie fuhren lebendig hinunter ins Totenreich mit allem, was sie hatten. Und die Erde deckte sie zu. Also kamen sie um, mitten aus der Gemeinde. ");
INSERT INTO deu1951_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Und ganz Israel, das rings um sie her war, floh bei ihrem Geschrei; denn sie sprachen: Daß uns die Erde nicht auch verschlinge! ");
INSERT INTO deu1951_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Dazu fuhr Feuer aus von dem HERRN und verzehrte die zweihundertundfünfzig Männer, die das Räucherwerk opferten. ");
INSERT INTO deu1951_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Sage zu Eleasar, dem Sohn Aarons, des Priesters, daß er die Räucherpfannen aus dem Brande aufhebe und das Feuer fernhin streue; ");
INSERT INTO deu1951_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","denn sie sind geheiligt, nämlich die Räucherpfannen derer, die wider ihre Seele gesündigt haben. Man soll sie zu breiten Blechen schlagen und den Altar damit bedecken; denn sie haben sie vor den HERRN gebracht und dadurch geheiligt; sie sollen den Kindern Israel zum Zeichen sein. ");
INSERT INTO deu1951_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Also nahmen Eleasar, der Priester, die ehernen Räucherpfannen, welche die Verbrannten herzugebracht hatten, und man schlug sie zu Blechen, um den Altar zu bedecken; ");
INSERT INTO deu1951_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","zum Gedächtnis den Kindern Israel, daß kein Fremder, der nicht vom Samen Aarons ist, sich nahe, um vor dem HERRN Räucherwerk zu opfern, und es ihm nicht ergehe wie Korah und seiner Rotte; wie der HERR durch Mose gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Am folgenden Morgen aber murrte die ganze Gemeinde der Kinder Israel wider Mose und Aaron und sprach: Ihr habt des HERRN Volk getötet! ");
INSERT INTO deu1951_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Als sich nun die Gemeinde wider Mose und Aaron versammelt hatte, wandten sie sich nach der Stiftshütte, und siehe, da bedeckte sie die Wolke, und die Herrlichkeit des HERRN erschien. ");
INSERT INTO deu1951_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Und Mose und Aaron gingen vor die Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Entfernt euch von dieser Gemeinde, so will ich sie in einem Augenblick vertilgen! ");
INSERT INTO deu1951_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Sie aber fielen auf ihr Angesicht. Und Mose sprach zu Aaron: Nimm die Räucherpfanne und tue Feuer darein vom Altar und lege Räucherwerk darauf und gehe eilends zu der Gemeinde und erwirke ihr Sühne. Denn der grimmige Zorn ist vom HERRN ausgegangen, und die Plage hat begonnen! ");
INSERT INTO deu1951_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Da nahm Aaron die Räucherpfanne, wie Mose gesagt hatte, und lief mitten unter die Gemeinde. Und siehe, die Plage hatte unter dem Volk angefangen; und er räucherte und erwirkte Sühne für das Volk; ");
INSERT INTO deu1951_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","und er stand zwischen den Toten und den Lebendigen: da ward der Plage gewehrt. ");
INSERT INTO deu1951_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Es belief sich aber die Zahl der an der Plage Gestorbenen auf 14700, ausgenommen die, welche wegen der Sache Korahs starben. ");
INSERT INTO deu1951_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Und Aaron kam wieder zu Mose vor die Tür der Stiftshütte, nachdem der Plage gewehrt worden war. ");
INSERT INTO deu1951_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Und der HERR redete zu Mose und sprach: Rede mit den Kindern Israel und nimm von ihnen je einen Stab für ein Vaterhaus, ");
INSERT INTO deu1951_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","von allen Fürsten ihrer Stammhäuser zwölf Stäbe, und schreibe eines jeden Namen auf seinen Stab. ");
INSERT INTO deu1951_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Aber Aarons Namen sollst du auf den Stab Levis schreiben. Denn für jedes Oberhaupt ihrer Vaterhäuser soll ein Stab sein. ");
INSERT INTO deu1951_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Und lege sie in die Stiftshütte vor das Zeugnis, wo ich mit euch zusammenzukommen pflege. ");
INSERT INTO deu1951_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Und der Mann, welchen ich erwählen werde, dessen Stab wird grünen; so werde ich das Murren der Kinder Israel, womit sie wider euch gemurrt haben, vor mir zum Schweigen bringen. ");
INSERT INTO deu1951_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Und Mose sagte solches den Kindern Israel; da gaben ihm alle ihre Fürsten zwölf Stäbe, jeder Fürst einen Stab, nach ihren Vaterhäusern; auch Aarons Stab war unter ihren Stäben. ");
INSERT INTO deu1951_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Und Mose legte die Stäbe vor den HERRN, in die Hütte des Zeugnisses. ");
INSERT INTO deu1951_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Am Morgen aber, als Mose in die Hütte des Zeugnisses trat, siehe, da grünte der Stab Aarons, des Hauses Levis; er hatte ausgeschlagen und Blüten getrieben und trug reife Mandeln. ");
INSERT INTO deu1951_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Und Mose trug alle Stäbe heraus von dem HERRN zu allen Kindern Israel; und sie sahen sie, und ein jeder nahm seinen Stab. ");
INSERT INTO deu1951_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Der HERR aber sprach zu Mose: Trage den Stab Aarons wieder vor das Zeugnis, daß er verwahrt werde zum Zeichen für die widerspenstigen Kinder, daß ihr Murren vor mir aufhöre, daß sie nicht sterben! ");
INSERT INTO deu1951_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Und Mose tat solches; wie der HERR ihm geboten hatte, so tat er. ");
INSERT INTO deu1951_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Und die Kinder Israel sprachen zu Mose: Siehe, wir sterben dahin, wir kommen um, wir kommen alle um! ");
INSERT INTO deu1951_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Wer sich der Wohnung des HERRN naht, der stirbt! Oder sind wir alle zum Sterben bestimmt? ");
INSERT INTO deu1951_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Und der HERR sprach zu Aaron: Du und deine Söhne und deines Vaters Haus mit dir sollen die Versündigung am Heiligtum tragen, und du und deine Söhne mit dir sollen die Sünde eures Priestertums tragen. ");
INSERT INTO deu1951_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Laß auch deine Brüder vom Stamme Levi, von deinem väterlichen Stamm, sich mit dir nahen, daß sie sich dir anschließen und dir dienen. Du aber und deine Söhne mit dir sollen vor der Hütte des Zeugnisses dienen und sollen deine Anordnungen und die Ordnungen der ganzen Hütte besorgen; ");
INSERT INTO deu1951_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","doch zu den Geräten des Heiligtums und zum Altar sollen sie sich nicht nahen, daß sie nicht sterben, sie und ihr dazu; ");
INSERT INTO deu1951_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","sondern sie sollen dir beigeordnet sein, daß sie die Ordnung der Stiftshütte besorgen, den Dienst an der Hütte; aber kein Fremder soll sich zu euch nahen. ");
INSERT INTO deu1951_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","So beobachtet denn die Ordnungen des Heiligtums und die Ordnung des Altars, daß hinfort kein Zorngericht über die Kinder Israel komme! ");
INSERT INTO deu1951_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Und siehe, ich habe die Leviten, eure Brüder, aus den Kindern Israel herausgenommen, euch zur Gabe, als dem HERRN Geweihte, daß sie den Dienst der Stiftshütte besorgen. ");
INSERT INTO deu1951_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Du aber und deine Söhne mit dir, ihr sollt eures Priestertums warten, daß ihr dienet in allen Geschäften des Altars und inwendig hinter dem Vorhang; denn zum Geschenk gebe ich euch das Amt eures Priestertums. Wenn ein Fremder herzunaht, so muß er sterben. ");
INSERT INTO deu1951_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Und der HERR sprach zu Aaron: Siehe, ich habe dir meine Hebopfer zu verwahren gegeben; von allem, was die Kinder Israel heiligen, habe ich sie dir zum Salbungsgeschenk und deinen Söhnen zum ewigen Recht verliehen. ");
INSERT INTO deu1951_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Das sollst du haben vom Hochheiligen, vom Feuer des Altars; alle ihre Opfer samt allen ihren Speisopfern und Sündopfern und Schuldopfern, die sie mir bringen, sollen dir und deinen Söhnen hochheilig sein. ");
INSERT INTO deu1951_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","An einem hochheiligen Ort sollst du es essen; was männlich ist, mag davon essen; denn es soll dir heilig sein. ");
INSERT INTO deu1951_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Du sollst auch das Hebopfer ihrer Gaben haben, alle Webopfer der Kinder Israel; Ich habe sie dir und deinen Söhnen und deinen Töchtern neben dir zum ewigen Rechte gegeben. Wer in deinem Hause rein ist, der soll davon essen: ");
INSERT INTO deu1951_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Alles Beste vom Öl und alles Beste vom Most und Korn, ihre Erstlinge, die sie dem HERRN geben, habe ich dir gegeben. ");
INSERT INTO deu1951_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Die ersten Früchte alles dessen, was in ihrem Lande wächst, die sie dem HERRN bringen, sollen dein sein. Wer in deinem Hause rein ist, soll davon essen. ");
INSERT INTO deu1951_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Alles Gebannte in Israel soll dein sein. ");
INSERT INTO deu1951_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Alle Erstgeburt unter allem Fleisch, die sie dem HERRN bringen, es sei ein Mensch oder ein Vieh, soll dein sein; doch sollst du die Erstgeburt von Menschen lösen lassen, auch die Erstgeburt eines unreinen Viehes sollst du lösen lassen. ");
INSERT INTO deu1951_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Und was den Lösepreis betrifft, sollst du, wenn sie einen Monat alt sind, sie lösen nach deiner Schatzung um fünf Schekel Silber, nach dem Schekel des Heiligtums, welcher zwanzig Gera gilt. ");
INSERT INTO deu1951_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Aber die Erstgeburt eines Ochsen, oder die Erstgeburt eines Lammes, oder die Erstgeburt einer Ziege sollst du nicht lösen lassen; denn sie sind heilig. Ihr Blut sollst du auf den Altar sprengen, und ihr Fett sollst du verbrennen zum Feueropfer, zum lieblichen Geruch dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ihr Fleisch aber soll dein sein; wie die Webebrust und die rechte Keule soll es dir gehören. ");
INSERT INTO deu1951_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Alle Hebopfer von den heiligen Gaben, welche die Kinder Israel dem HERRN erheben, habe ich dir und deinen Söhnen und deinen Töchtern neben dir gegeben, als ewiges Recht. Das soll ein ewiger Salzbund sein vor dem HERRN, für dich und deinen Samen mit dir. ");
INSERT INTO deu1951_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Und der HERR sprach zu Aaron: Du sollst in ihrem Lande nichts erben, auch kein Teil unter ihnen haben; denn Ich bin dein Teil und dein Erbgut unter den Kindern Israel! ");
INSERT INTO deu1951_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Aber siehe, den Kindern Levis habe ich alle Zehnten in Israel zum Erbteil gegeben für ihren Dienst, den sie mir tun in der Arbeit an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Darum sollen hinfort die Kinder Israel nicht zur Stiftshütte nahen, daß sie nicht Sünde auf sich laden und sterben; ");
INSERT INTO deu1951_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","sondern die Leviten sollen den Dienst an der Stiftshütte besorgen und sie sollen ihre Missetat tragen; das sei ein ewiges Recht bei euren Nachkommen; aber sie sollen unter den Kindern Israel kein Erbgut besitzen. ");
INSERT INTO deu1951_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Denn den Zehnten der Kinder Israel, den sie dem HERRN als Hebopfer entrichten, habe ich den Leviten zum Erbteil gegeben. Darum habe ich zu ihnen gesagt, daß sie unter den Kindern Israel kein Erbgut besitzen sollen. ");
INSERT INTO deu1951_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Sage auch den Leviten und sprich zu ihnen: Wenn ihr von den Kindern Israel den Zehnten nehmet, den ich euch von ihnen zum Erbteil gegeben habe, so sollt ihr davon dem HERRN ein Hebopfer abheben, den Zehnten vom Zehnten. ");
INSERT INTO deu1951_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Dieses euer Hebopfer soll euch angerechnet werden, als gäbet ihr Korn von der Tenne und Most aus der Kelter. ");
INSERT INTO deu1951_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Also sollt auch ihr dem HERRN das Hebopfer geben von allen euren Zehnten, die ihr von den Kindern Israel nehmet, und sollt dieses Hebopfer des HERRN dem Priester Aaron geben. ");
INSERT INTO deu1951_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Von allem, was euch geschenkt wird, sollt ihr dem HERRN ein Hebopfer geben, von allem Besten den geheiligten Teil. ");
INSERT INTO deu1951_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Und sprich zu ihnen: Wenn ihr also das Allerbeste davon abhebet, so soll es den Leviten angerechnet werden wie ein Ertrag der Tenne und wie ein Ertrag der Kelter. ");
INSERT INTO deu1951_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Und ihr möget es essen an allen Orten, ihr und euer Haus; denn es ist euer Lohn für euren Dienst an der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Und ihr werdet darob keine Sünde auf euch laden, wenn ihr nur das Beste davon abhebet und das Geheiligte der Kinder Israel nicht entweihet, auf daß ihr nicht sterbet. ");
INSERT INTO deu1951_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Und der HERR redete zu Mose und Aaron und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Dies ist eine Gesetzesbestimmung, die der HERR geboten hat, indem er sprach: Sage den Kindern Israel, daß sie zu dir bringen eine tadellose Kuh, an der kein Mangel und auf die noch kein Joch gekommen ist, und gebt sie dem Priester Eleasar, ");
INSERT INTO deu1951_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","der soll sie vor das Lager hinausführen und daselbst vor seinen Augen schächten lassen. ");
INSERT INTO deu1951_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Darnach soll Eleasar, der Priester, mit seinem Finger von ihrem Blute nehmen und von ihrem Blut siebenmal gegen die Stiftshütte sprengen, ");
INSERT INTO deu1951_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","und die Kuh soll er vor seinen Augen verbrennen lassen; ihre Haut und ihr Fleisch, dazu ihr Blut samt ihrem Mist soll er verbrennen lassen. ");
INSERT INTO deu1951_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Und der Priester soll Zedernholz und Ysop und Karmesin nehmen und es auf die brennende Kuh werfen. ");
INSERT INTO deu1951_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Und der Priester soll seine Kleider waschen und seinen Leib im Wasser baden und darnach ins Lager gehen; und der Priester soll unrein sein bis an den Abend. ");
INSERT INTO deu1951_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Gleicherweise soll der, welcher sie verbrannt hat, seine Kleider mit Wasser waschen und seinen Leib mit Wasser baden und unrein sein bis an den Abend. ");
INSERT INTO deu1951_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Und ein reiner Mann soll die Asche von der Kuh sammeln und außerhalb des Lagers an einen reinen Ort schütten, damit sie daselbst für die Gemeinde der Kinder Israel aufbewahrt werde für das Reinigungswasser; denn es ist ein Sündopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Und der, welcher die Asche von der Kuh gesammelt hat, soll seine Kleider waschen und unrein sein bis an den Abend. ");
INSERT INTO deu1951_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Es soll aber dies eine ewig gültige Satzung sein für die Kinder Israel und für die Fremdlinge, die unter ihnen wohnen: Wer einen Leichnam anrührt von irgend einem Menschen, der bleibt unrein sieben Tage lang. ");
INSERT INTO deu1951_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ein solcher soll sich mit demselben Wasser am dritten und am siebenten Tag entsündigen, so wird er rein. Wenn er sich aber am dritten und am siebenten Tag nicht entsündigt, so wird er nicht rein. ");
INSERT INTO deu1951_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Wenn aber jemand den Leichnam eines Menschen anrührt und sich nicht entsündigen wollte, der verunreinigt die Wohnung des HERRN, eine solche Seele soll aus Israel ausgerottet werden, weil das Reinigungswasser nicht über sie gesprengt worden ist; und sie bleibt unrein, ihre Unreinigkeit ist noch an ihr. ");
INSERT INTO deu1951_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Das ist das Gesetz, wenn ein Mensch im Zelte stirbt: Wer in das Zelt geht, und alles, was im Zelte ist, soll sieben Tage lang unrein sein. ");
INSERT INTO deu1951_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Und alle offenen Geschirre, worüber kein Deckel gebunden ist, sind unrein. ");
INSERT INTO deu1951_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Auch wer auf dem Felde einen mit dem Schwert Erschlagenen anrührt oder sonst einen Toten oder eines Menschen Gebein oder ein Grab, der ist sieben Tage lang unrein. ");
INSERT INTO deu1951_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","So sollen sie nun für den Unreinen von der Asche dieses verbrannten Sündopfers nehmen und lebendiges Wasser darüber tun in ein Geschirr. ");
INSERT INTO deu1951_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Und ein reiner Mann soll Ysop nehmen und ins Wasser tunken und das Zelt besprengen und alle Geschirre und alle Seelen, die darin sind; also auch den, der ein Totengebein oder einen Erschlagenen oder einen Toten oder ein Grab angerührt hat. ");
INSERT INTO deu1951_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Und der Reine soll den Unreinen besprengen am dritten Tag und am siebenten Tage; so wird er ihn am siebenten Tage entsündigen; und er soll seine Kleider waschen und sich mit Wasser baden, so wird er am Abend rein sein. ");
INSERT INTO deu1951_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ist aber jemand unrein und will sich nicht entsündigen lassen, dessen Seele soll aus der Gemeinde ausgerottet werden; denn er hat das Heiligtum des HERRN verunreinigt, er ist nicht mit Reinigungswasser besprengt, darum ist er unrein. ");
INSERT INTO deu1951_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Und das soll ihnen eine ewig gültige Satzung sein. Derjenige aber, welcher mit dem Reinigungswasser besprengt hat, soll seine Kleider waschen. Und wer das Reinigungswasser anrührt, der soll unrein sein bis an den Abend. ");
INSERT INTO deu1951_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Auch alles, was der Unreine anrührt, wird unrein werden; und welche Seele ihn anrühren wird, die soll unrein sein bis an den Abend. ");
INSERT INTO deu1951_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Und die ganze Gemeinde der Kinder Israel kam in die Wüste Zin, im ersten Monat, und das Volk blieb zu Kadesch. Und Mirjam starb daselbst und ward daselbst begraben. ");
INSERT INTO deu1951_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Und die Gemeinde hatte kein Wasser; darum versammelten sie sich wider Mose und wider Aaron. ");
INSERT INTO deu1951_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Und das Volk haderte mit Mose und sprach: Ach, daß wir umgekommen wären, als unsre Brüder vor dem HERRN umkamen! ");
INSERT INTO deu1951_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Und warum habt ihr die Gemeinde des HERRN in diese Wüste gebracht, daß wir hier sterben, wir und unser Vieh? ");
INSERT INTO deu1951_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Warum habt ihr uns doch aus Ägypten an diesen bösen Ort geführt, da man nicht säen kann, da weder Feigenbäume noch Weinstöcke noch Granatäpfel sind, auch kein Wasser zu trinken? ");
INSERT INTO deu1951_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Und Mose und Aaron gingen von der Gemeinde weg zur Tür der Stiftshütte und fielen auf ihr Angesicht. Und die Herrlichkeit des HERRN erschien ihnen. ");
INSERT INTO deu1951_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Nimm den Stab und versammle die Gemeinde, du und dein Bruder Aaron, und redet mit dem Felsen vor ihren Augen, der wird sein Wasser geben. So sollst du ihnen Wasser aus dem Felsen verschaffen und die Gemeinde und ihr Vieh tränken. ");
INSERT INTO deu1951_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Da holte Mose den Stab vor dem HERRN, wie er ihm gesagt hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Und Mose und Aaron versammelten die Gemeinde vor dem Felsen; und er sprach: Höret doch, ihr Widerspenstigen: Aus diesem Felsen sollen wir euch Wasser verschaffen? ");
INSERT INTO deu1951_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Und Mose hob seine Hand auf und schlug den Felsen zweimal mit seinem Stab. Da floß viel Wasser heraus; und die Gemeinde und ihr Vieh tranken. ");
INSERT INTO deu1951_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Der HERR aber sprach zu Mose und Aaron: Weil ihr nicht auf mich vertraut habt, um mich vor den Kindern Israel zu heiligen, sollt ihr diese Gemeinde nicht in das Land bringen, das ich ihnen geben werde! ");
INSERT INTO deu1951_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Das ist das Wasser Meriba, wo die Kinder Israel mit dem HERRN haderten, und er sich an ihnen heilig erwies. ");
INSERT INTO deu1951_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Darnach sandte Mose Botschaft aus Kadesch zu dem König der Edomiter: Also läßt dir dein Bruder Israel sagen: Du weißt alle Mühe, die uns begegnet ist; ");
INSERT INTO deu1951_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","daß unsre Väter nach Ägypten hinabgezogen sind; daß wir lange Zeit in Ägypten gewohnt und die Ägypter uns und unsre Väter mißhandelt haben; ");
INSERT INTO deu1951_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","und wir schrieen zum HERRN, und er erhörte unsre Stimme und sandte einen Engel und führte uns aus Ägypten. Und siehe, wir sind zu Kadesch, einer Stadt zuäußerst an deinem Gebiet. ");
INSERT INTO deu1951_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","So laß uns nun durch dein Land ziehen. Wir wollen weder durch Äcker noch durch Weinberge gehen, auch kein Wasser aus den Brunnen trinken. Wir wollen auf der Königsstraße ziehen und weder zur rechten noch zur linken Seite weichen, bis wir durch dein Gebiet gekommen sind. ");
INSERT INTO deu1951_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Der Edomiter aber sprach zu ihnen: Du sollst nicht durch mein Land ziehen, sonst will ich dir mit dem Schwert entgegentreten! ");
INSERT INTO deu1951_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Die Kinder Israel sprachen zu ihm: Wir wollen auf der gebahnten Straße ziehen, und wenn wir von deinem Wasser trinken, wir und unser Vieh, so wollen wir es bezahlen; wir wollen nur zu Fuß hindurchziehen. ");
INSERT INTO deu1951_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Er aber sprach: Du sollst nicht hindurchziehen! Und der Edomiter zog ihnen entgegen mit mächtigem Volk und mit starker Hand. ");
INSERT INTO deu1951_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Also weigerte sich der Edomiter, Israel zu vergönnen, durch sein Gebiet zu ziehen. Und Israel wich von ihm. ");
INSERT INTO deu1951_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Da brachen die Kinder Israel auf von Kadesch, und die ganze Gemeinde kam zu dem Berge Hor. ");
INSERT INTO deu1951_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Und der HERR redete mit Mose und Aaron an dem Berge Hor, an den Landmarken der Edomiter und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Laß Aaron sich zu seinem Volk versammeln; denn er soll nicht in das Land kommen, das ich den Kindern Israel gegeben habe, weil ihr meinen Worten beim Haderwasser ungehorsam gewesen seid. ");
INSERT INTO deu1951_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Nimm aber Aaron und seinen Sohn Eleasar und führe sie auf den Berg Hor, ");
INSERT INTO deu1951_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","und zieh Aaron seine Kleider aus und lege sie seinem Sohn Eleasar an; und Aaron soll daselbst zu seinem Volk versammelt werden und sterben. ");
INSERT INTO deu1951_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Da tat Mose, wie der HERR geboten hatte; und sie stiegen auf den Berg Hor vor den Augen der ganzen Gemeinde. ");
INSERT INTO deu1951_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Und Mose zog Aaron seine Kleider aus und zog sie seinem Sohn Eleasar an. Und Aaron starb daselbst, oben auf dem Berge. Mose aber und Eleasar stiegen vom Berge hinab. ");
INSERT INTO deu1951_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Und als die ganze Gemeinde sah, daß Aaron gestorben war, beweinte ihn das ganze Haus Israel dreißig Tage lang. ");
INSERT INTO deu1951_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Und als der Kanaaniter, der König von Arad, der gegen Mittag wohnte, hörte, daß Israel auf dem Wege der Kundschafter heranziehe, stritt er wider Israel und machte Gefangene unter ihnen. ");
INSERT INTO deu1951_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Da tat Israel dem HERRN ein Gelübde und sprach: Wenn du dieses Volk in meine Hand gibst, so will ich an ihren Städten den Bann vollstrecken! ");
INSERT INTO deu1951_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Und der HERR erhörte Israels Stimme und gab die Kanaaniter in ihre Hand, und Israel vollstreckte an ihnen und an ihren Städten den Bann und hieß den Ort Horma. ");
INSERT INTO deu1951_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Da zogen sie vom Berge Hor weg auf dem Weg zum Schilfmeer, um der Edomiter Land zu umgehen. Aber das Volk ward ungeduldig auf dem Wege. ");
INSERT INTO deu1951_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Und das Volk redete wider Gott und wider Mose: Warum habt ihr uns aus Ägypten geführt, daß wir in der Wüste sterben? Denn hier ist weder Brot noch Wasser, und unsre Seele hat einen Ekel an dieser schlechten Speise! ");
INSERT INTO deu1951_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Da sandte der HERR feurige Schlangen unter das Volk, die bissen das Volk, so daß viel Volk in Israel starb. ");
INSERT INTO deu1951_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Da kamen sie zu Mose und sprachen: Wir haben gesündigt, daß wir wider den HERRN und wider dich geredet haben. Bitte den HERRN, daß er die Schlangen von uns wende! ");
INSERT INTO deu1951_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Und Mose bat für das Volk. Da sprach der HERR zu Mose: Mache dir eine feurige Schlange und befestige sie an ein Panier; und es soll geschehen, wer gebissen ist und sie ansieht, der soll am Leben bleiben! ");
INSERT INTO deu1951_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Da machte Mose eine eherne Schlange und befestigte sie an das Panier; und es geschah, wenn eine Schlange jemanden biß und er die eherne Schlange anschaute, so blieb er am Leben. ");
INSERT INTO deu1951_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Und die Kinder Israel zogen aus und lagerten sich in Obot. ");
INSERT INTO deu1951_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Und von Obot zogen sie aus und lagerten sich bei den Ruinen von Abarim in der Wüste, Moab gegenüber, gegen Aufgang der Sonne. ");
INSERT INTO deu1951_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Von dannen zogen sie weiter und lagerten sich an dem Bach Sared. ");
INSERT INTO deu1951_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Von dannen zogen sie weiter und lagerten sich jenseits des Arnon, welcher in der Wüste ist und aus dem Gebiete der Amoriter herausfließt; denn der Arnon bildet die Grenze Moabs, zwischen Moab und den Amoritern. ");
INSERT INTO deu1951_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Daher heißt es im Buche von den Kriegen des HERRN: «Waheb hat er im Sturm eingenommen und die Täler des Arnon in Supha ");
INSERT INTO deu1951_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","und den Abhang der Täler, der sich bis zum Wohnsitz von Ar erstreckt und sich an die Grenze von Moab lehnt.» ");
INSERT INTO deu1951_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Von dannen zogen sie gen Beer. Das ist der Brunnen, davon der HERR zu Mose sagte: Versammle das Volk, so will ich ihnen Wasser geben. ");
INSERT INTO deu1951_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Da sang Israel dieses Lied: «Kommt zum Brunnen! Singt von ihm! ");
INSERT INTO deu1951_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Brunnen, den die Fürsten gruben, den die Edlen des Volkes öffneten mit dem Herrscherstab, mit ihren Stäben!» Und von dieser Wüste zogen sie gen Mattana, ");
INSERT INTO deu1951_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","und von Mattana gen Nahaliel, und von Nahaliel gen Bamot, und von Bamot in das Tal, ");
INSERT INTO deu1951_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","das im Gefilde Moab liegt, dessen Gipfel der Pisga ist, der gegen die Wüste schaut. ");
INSERT INTO deu1951_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Und Israel sandte Boten zu Sihon, dem König der Amoriter, und ließ ihm sagen: ");
INSERT INTO deu1951_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Laß mich durch dein Land ziehen, wir wollen weder in die Äcker noch in die Weingärten treten, wollen auch von dem Brunnenwasser nicht trinken; wir wollen die Königsstraße ziehen, bis wir durch dein Gebiet gekommen sind! ");
INSERT INTO deu1951_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Aber Sihon gestattete Israel nicht, durch sein Gebiet zu ziehen, sondern versammelte sein ganzes Volk und zog aus, Israel entgegen in die Wüste. Und als er gen Jahza kam, stritt er wider Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israel aber schlug ihn mit der Schärfe des Schwertes und nahm sein Land ein, vom Arnon an bis an den Jabbok und bis an die Kinder Ammon; denn die Landmarken der Kinder Ammon waren fest. ");
INSERT INTO deu1951_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Also nahm Israel alle diese Städte ein und wohnte in allen Städten der Amoriter zu Hesbon und in allen ihren Dörfern. ");
INSERT INTO deu1951_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Denn Hesbon war die Stadt Sihons, des Königs der Amoriter, der zuvor mit dem König der Moabiter gestritten und ihm sein ganzes Land bis zum Arnon abgewonnen hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Daher sagen die Spruchdichter: «Kommt gen Hesbon; die Stadt Sihons werde gebaut und aufgerichtet! ");
INSERT INTO deu1951_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Denn aus Hesbon ist Feuer gefahren, eine Flamme von der Stadt Sihons, die hat Ar der Moabiter verzehrt, die Herren der Höhen am Arnon. ");
INSERT INTO deu1951_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Wehe dir, Moab, Volk des Kamos, du bist verloren! Man hat seine Söhne in die Flucht geschlagen und seine Töchter gefangen geführt zu Sihon, dem König der Amoriter; ");
INSERT INTO deu1951_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","und ihre Nachkommenschaft ist umgekommen von Hesbon bis Dibon, und ihre Weiber sind zu dem hinabgestiegen, der das Feuer angefacht hat, nach Medeba.» ");
INSERT INTO deu1951_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Also wohnte Israel im Lande der Amoriter. ");
INSERT INTO deu1951_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Und Mose sandte Kundschafter aus gen Jaeser, und sie gewannen ihre Dörfer und trieben die Amoriter aus, die darin wohnten. ");
INSERT INTO deu1951_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Und sie wandten sich um und stiegen den Berg nach Basan hinauf. Da zog Og, der König zu Basan, aus, ihnen entgegen mit seinem ganzen Volke, zum Kampf bei Edrei. ");
INSERT INTO deu1951_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Der HERR aber sprach zu Mose: Fürchte dich nicht vor ihm, denn ich habe ihn mit Land und Leuten in deine Hand gegeben, und du sollst mit ihm tun, wie du mit Sihon, dem König der Amoriter, getan hast, der zu Hesbon wohnte! ");
INSERT INTO deu1951_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Und sie schlugen ihn und seine Söhne und sein ganzes Volk, daß niemand übrigblieb, und nahmen sein Land ein. ");
INSERT INTO deu1951_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Darnach zogen die Kinder Israel weiter und lagerten sich in der Ebene Moabs, jenseits des Jordan, Jericho gegenüber. ");
INSERT INTO deu1951_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Als aber Balak, der Sohn Zippors, alles sah, was Israel den Amoritern getan hatte, ");
INSERT INTO deu1951_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","fürchtete sich Moab sehr vor dem Volk, denn es war zahlreich; und es graute den Moabitern vor den Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Da sprach Moab zu den Ältesten der Midianiter: Nun wird dieser Haufe alles rings um uns her auffressen, wie das Vieh alles Grüne auf dem Felde wegfrißt. Balak aber, der Sohn Zippors, war zu derselben Zeit König der Moabiter. ");
INSERT INTO deu1951_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Und er sandte Boten aus zu Bileam, dem Sohn Beors, gen Petor, welches an dem Flusse Euphrat im Lande der Kinder seines Volkes liegt, daß sie ihn beriefen und zu ihm sagten: Siehe, es ist ein Volk aus Ägypten gezogen; siehe, es bedeckt das ganze Land und lagert sich gegen mich! ");
INSERT INTO deu1951_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","So komm nun und verfluche mir dieses Volk, denn es ist mir zu mächtig; vielleicht kann ich es dann schlagen und aus dem Lande treiben; denn ich weiß: wen du segnest, der ist gesegnet, und wen du verfluchst, der ist verflucht. ");
INSERT INTO deu1951_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Und die Ältesten der Moabiter gingen hin mit den Ältesten der Midianiter und hatten den Lohn des Wahrsagens in ihren Händen und kamen zu Bileam und sagten ihm die Worte Balaks. ");
INSERT INTO deu1951_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Und er sprach zu ihnen: Bleibet hier über Nacht, so will ich euch antworten, wie mir der HERR sagen wird! Also blieben die Fürsten der Moabiter bei Bileam. ");
INSERT INTO deu1951_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Und Gott kam zu Bileam und sprach: Was sind das für Leute bei dir? ");
INSERT INTO deu1951_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bileam sprach zu Gott: Balak, der Sohn Zippors, der Moabiter König, hat zu mir gesandt und mir sagen lassen: ");
INSERT INTO deu1951_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Siehe, ein Volk ist aus Ägypten gezogen und bedeckt das ganze Land, so komm nun und verfluche es mir; vielleicht kann ich dann mit ihm streiten und es vertreiben! ");
INSERT INTO deu1951_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Aber Gott sprach zu Bileam: Geh nicht mit ihnen, verfluche das Volk auch nicht; denn es ist gesegnet! ");
INSERT INTO deu1951_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Da stand Bileam am Morgen auf und sprach zu den Fürsten Balaks: Geht hin in euer Land, denn der HERR will es nicht gestatten, daß ich mit euch ziehe! ");
INSERT INTO deu1951_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Und die Fürsten der Moabiter machten sich auf, kamen zu Balak und sprachen: Bileam weigert sich, mit uns zu ziehen! ");
INSERT INTO deu1951_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Da sandte Balak noch mehrere und herrlichere Fürsten, als jene waren. ");
INSERT INTO deu1951_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Als diese zu Bileam kamen, sprachen sie zu ihm: Also läßt dir Balak, der Sohn Zippors, sagen: Weigere dich doch nicht, zu mir zu ziehen; ");
INSERT INTO deu1951_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","denn ich will dich hoch ehren, und was du mir sagst, das will ich tun. So komm doch und verfluche mir dieses Volk! ");
INSERT INTO deu1951_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bileam antwortete und sprach zu Balaks Knechten: Wenn mir Balak sein Haus voll Silber und Gold gäbe, so könnte ich doch das Wort des HERRN, meines Gottes, nicht übertreten, um Kleines oder Großes zu tun! ");
INSERT INTO deu1951_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Doch bleibet noch hier diese Nacht, daß ich erfahre, was der HERR weiter mit mir reden wird. ");
INSERT INTO deu1951_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Da kam Gott des Nachts zu Bileam und sprach zu ihm: Sind die Männer gekommen, dich zu rufen, so mache dich auf und ziehe mit ihnen, doch darfst du nur das tun, was ich dir sagen werde! ");
INSERT INTO deu1951_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Da stand Bileam am Morgen auf und sattelte seine Eselin und zog mit den Fürsten der Moabiter. ");
INSERT INTO deu1951_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Aber der Zorn Gottes entbrannte darüber, daß er ging. Und ein Engel des HERRN trat ihm als Widersacher in den Weg. Er aber ritt auf seiner Eselin, und seine beiden Knaben waren bei ihm. ");
INSERT INTO deu1951_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Als nun die Eselin den Engel des HERRN im Wege stehen sah und das gezückte Schwert in seiner Hand, bog die Eselin vom Wege ab und ging aufs Feld. Bileam aber schlug die Eselin, um sie auf den Weg zu lenken. ");
INSERT INTO deu1951_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Da trat der Engel des HERRN in den Hohlweg bei den Weinbergen, da zu beiden Seiten Mauern waren. ");
INSERT INTO deu1951_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Als nun die Eselin den Engel des HERRN sah, drängte sie sich an die Wand und klemmte Bileams Fuß an die Wand. Da schlug er sie noch mehr. ");
INSERT INTO deu1951_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Da ging der Engel des HERRN weiter und trat an einen engen Ort, wo kein Platz zum Ausweichen war, weder zur Rechten noch zur Linken. ");
INSERT INTO deu1951_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Als nun die Eselin den Engel des HERRN sah, fiel sie unter Bileam auf ihre Knie. Da ergrimmte Bileams Zorn, und er schlug die Eselin mit dem Stecken. ");
INSERT INTO deu1951_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Da öffnete der HERR der Eselin den Mund; und sie sprach zu Bileam: Was habe ich dir getan, daß du mich nun dreimal geschlagen hast? ");
INSERT INTO deu1951_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileam sprach zu der Eselin: Weil du Mutwillen mit mir getrieben hast! O daß ich ein Schwert in der Hand hätte, ich wollte dich jetzt umbringen! ");
INSERT INTO deu1951_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Die Eselin sprach zu Bileam: Bin ich nicht deine Eselin, die du von jeher geritten hast bis auf diesen Tag? Habe ich auch je gepflegt, dir also zu tun? ");
INSERT INTO deu1951_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Er sprach: Nein! Da enthüllte der HERR dem Bileam die Augen, daß er den Engel des HERRN im Wege stehen sah und das gezückte Schwert in seiner Hand; da verneigte er sich und warf sich auf sein Angesicht. ");
INSERT INTO deu1951_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Und der Engel des HERRN sprach zu ihm: Warum hast du deine Eselin nun dreimal geschlagen? Siehe, ich bin ausgegangen, dir zu widerstehen; denn der Weg ist mir ganz entgegen. ");
INSERT INTO deu1951_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Und die Eselin hat mich gesehen und ist mir dreimal ausgewichen. Und wenn sie mir nicht ausgewichen wäre, so hätte ich dich jetzt umgebracht und sie leben lassen! ");
INSERT INTO deu1951_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Da sprach Bileam zum Engel des HERRN: Ich habe gesündigt, denn ich wußte nicht, daß du mir im Wege entgegenstandest! Und nun, wenn es dir nicht gefällt, so will ich wieder umkehren. ");
INSERT INTO deu1951_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Und der Engel des HERRN sprach zu Bileam: Geh mit den Männern; aber du sollst nichts reden, außer was ich dir sagen werde! Also zog Bileam mit den Fürsten Balaks. ");
INSERT INTO deu1951_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Da nun Balak hörte, daß Bileam kam, zog er ihm entgegen bis Ir-Moab, welches am Grenzfluß Arnon liegt, der die äußerste Grenze bildet. ");
INSERT INTO deu1951_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Und Balak sprach zu Bileam: Habe ich nicht zu dir gesandt und dich rufen lassen? Warum bist du denn nicht zu mir gekommen? Kann ich dich etwa nicht ehren? ");
INSERT INTO deu1951_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bileam antwortete dem Balak: Siehe, ich bin jetzt zu dir gekommen. Kann ich nun etwas reden? Das Wort, welches mir Gott in den Mund gibt, das will ich reden! ");
INSERT INTO deu1951_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Also zog Bileam mit Balak, und sie kamen nach Kirjath-Chuzot. ");
INSERT INTO deu1951_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Und Balak opferte Rinder und Schafe und schickte zu Bileam und den Fürsten, die bei ihm waren. ");
INSERT INTO deu1951_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Und am Morgen nahm Balak den Bileam und führte ihn hinauf auf die Höhen Baals, von wo aus er den äußersten Teil des Volkes sehen konnte. ");
INSERT INTO deu1951_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Und Bileam sprach zu Balak: Baue mir hier sieben Altäre, und verschaffe mir hier sieben Farren und sieben Widder! ");
INSERT INTO deu1951_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak tat, wie ihm Bileam sagte. Und beide, Balak und Bileam, opferten auf jedem Altar einen Farren und einen Widder. ");
INSERT INTO deu1951_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Und Bileam sprach zu Balak: Tritt zu deinem Brandopfer! Ich will dorthin gehen. Vielleicht begegnet mir der HERR, daß ich dir ansage, was er mir zeigen wird. ");
INSERT INTO deu1951_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Und er ging auf einen Hügel. Und Gott begegnete dem Bileam. Er aber sprach zu ihm: Sieben Altäre habe ich zugerichtet und auf jedem einen Farren und einen Widder geopfert. ");
INSERT INTO deu1951_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Der HERR aber legte Bileam das Wort in den Mund und sprach: Geh wieder zu Balak und rede also! ");
INSERT INTO deu1951_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","So kam er wieder zu ihm, und siehe, da stand er bei seinem Brandopfer, er und alle Fürsten der Moabiter. ");
INSERT INTO deu1951_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Da hob er an seinen Spruch und sprach: Balak, der Moabiter König, hat mich aus Syrien von dem östlichen Gebirge holen lassen: Komm, verfluche mir Jakob, komm und verwünsche Israel! ");
INSERT INTO deu1951_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Wie sollte ich dem fluchen, dem Gott nicht flucht? Wie sollte ich den verwünschen, den der HERR nicht verwünscht? ");
INSERT INTO deu1951_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Denn von den Felsengipfeln sehe ich ihn, und von den Hügeln schaue ich ihn. Siehe, das Volk wohnt besonders und wird nicht unter die Heiden gerechnet. ");
INSERT INTO deu1951_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wer kann den Staub Jakobs zählen und die Zahl des vierten Teils von Israel? Meine Seele möchte des Todes der Gerechten sterben, und mein Ende werde wie dieser Ende! ");
INSERT INTO deu1951_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Da sprach Balak zu Bileam: Was hast du mir angestellt? Ich habe dich holen lassen, meinen Feinden zu fluchen, und siehe, gesegnet hast du sie! ");
INSERT INTO deu1951_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Er antwortete und sprach: Muß ich nicht darauf achten zu reden, was mir der HERR in den Mund gelegt hat? ");
INSERT INTO deu1951_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak sprach zu ihm: Komm doch mit mir an einen andern Ort, von wo aus du es sehen kannst. Nur seinen äußersten Teil sollst du sehen und sollst es nicht ganz sehen; von da aus verfluche es mir! ");
INSERT INTO deu1951_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Und er nahm ihn mit sich nach dem Späherfeld, auf die Höhe des Pisga, baute sieben Altäre und opferte auf jedem Altar einen Farren und einen Widder. ");
INSERT INTO deu1951_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Und Bileam sprach zu Balak: Tritt hier zu deinem Brandopfer; ich aber will dort eine Begegnung suchen. ");
INSERT INTO deu1951_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Und der HERR begegnete dem Bileam und legte ihm das Wort in seinen Mund und sprach: Geh wieder zu Balak und rede also! ");
INSERT INTO deu1951_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Und als er wieder zu ihm kam, siehe, da stand er bei seinem Brandopfer samt den Fürsten der Moabiter. Und Balak sprach zu ihm: Was hat der HERR gesagt? ");
INSERT INTO deu1951_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Da hob er an seinen Spruch und sprach: Steh auf, Balak, und höre! Fasse meine Zeugnisse zu Ohren, du Sohn Zippors! ");
INSERT INTO deu1951_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Gott ist nicht ein Mensch, daß er lüge, noch ein Menschenkind, daß ihn etwas gereue. Sollte er etwas sagen und nicht tun? Sollte er etwas reden und es nicht halten? ");
INSERT INTO deu1951_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Siehe, zu segnen habe ich den Auftrag empfangen; denn er hat gesegnet, und ich kann es nicht abwenden! ");
INSERT INTO deu1951_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Man schaut kein Unheil in Jakob und sieht kein Unglück in Israel. Der HERR, sein Gott, ist mit ihm, und man jauchzt dem König zu in seiner Mitte. ");
INSERT INTO deu1951_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Gott hat sie aus Ägypten geführt; seine Kraft ist wie die eines Büffels. ");
INSERT INTO deu1951_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","So hilft denn keine Zauberei gegen Jakob und keine Wahrsagerei wider Israel. Zu seiner Zeit wird man von Jakob sagen: Was hat Gott getan! ");
INSERT INTO deu1951_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Siehe, das Volk wird aufstehen wie eine Löwin und wird sich erheben wie ein Löwe. Es wird sich nicht legen, bis es den Raub verzehrt und das Blut der Erschlagenen getrunken hat! ");
INSERT INTO deu1951_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Da sprach Balak zu Bileam: Du sollst ihm weder fluchen noch Segen wünschen! ");
INSERT INTO deu1951_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bileam antwortete und sprach zu Balak: Habe ich dir nicht gesagt und gesprochen: Alles, was der HERR sagen wird, das werde ich tun? ");
INSERT INTO deu1951_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak sprach zu Bileam: Komm doch, ich will dich an einen andern Ort führen; vielleicht gefällt es Gott, daß du mir sie daselbst verfluchest! ");
INSERT INTO deu1951_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Und Balak nahm Bileam mit sich auf die Höhe des Berges Peor, welcher auf die Wüste herunterschaut. ");
INSERT INTO deu1951_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Und Bileam sprach zu Balak: Baue mir hier sieben Altäre und verschaffe mir sieben Farren und sieben Widder! ");
INSERT INTO deu1951_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Und Balak tat, wie Bileam sagte, und opferte auf jedem Altar einen Farren und einen Widder. ");
INSERT INTO deu1951_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Als nun Bileam sah, daß es dem HERRN gefiel, Israel zu segnen, ging er nicht, wie zuvor, nach Wahrsagung aus, sondern richtete sein Angesicht gegen die Wüste. ");
INSERT INTO deu1951_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Und Bileam hob seine Augen auf und sah Israel, wie es nach seinen Stämmen lagerte. Und der Geist Gottes kam auf ihn. ");
INSERT INTO deu1951_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Und er hob an seinen Spruch und sprach: Es sagt Bileam, der Sohn Beors, es sagt der Mann, dem das Auge erschlossen ist, es sagt der Hörer göttlicher Reden, ");
INSERT INTO deu1951_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","der des Allmächtigen Gesichte sieht, welcher niederfällt, und dem die Augen geöffnet werden: ");
INSERT INTO deu1951_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Wie schön sind deine Hütten, o Jakob, und deine Wohnungen, o Israel! ");
INSERT INTO deu1951_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Wie die Täler, die sich ausbreiten, wie die Gärten am Strom, wie Aloe, die der HERR gepflanzt hat, wie die Zedern am Wasser. ");
INSERT INTO deu1951_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Wasser wird aus seinen Eimern fließen, und sein Same wird sein in großen Wassern. Sein König wird höher werden als Agag, und sein Reich wird sich erheben. ");
INSERT INTO deu1951_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gott hat ihn aus Ägypten geführt, seine Kraft ist wie die eines Büffels. Er wird die Heiden, seine Widersacher, fressen und ihre Gebeine zermalmen und mit seinen Pfeilen niederstrecken. ");
INSERT INTO deu1951_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Er ist niedergekniet, er hat sich niedergelegt wie ein Löwe und wie eine Löwin. Wer will ihn aufwecken? Gesegnet sei, wer dich segnet, und verflucht, wer dir flucht! ");
INSERT INTO deu1951_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Da ergrimmte Balak im Zorn wider Bileam und schlug die Hände ineinander; und Balak sprach zu Bileam: Ich habe dich gerufen, daß du meinen Feinden fluchest, und siehe, du hast sie nun dreimal gesegnet! ");
INSERT INTO deu1951_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Und nun mach dich fort an deinen Ort! Ich gedachte dich hoch zu ehren; aber siehe, der HERR hat dir die Ehre versagt! ");
INSERT INTO deu1951_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bileam antwortete dem Balak: Habe ich nicht auch zu deinen Boten, die du mir sandtest, gesagt und gesprochen: ");
INSERT INTO deu1951_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Wenn mir Balak sein Haus voll Silber und Gold gäbe, so könnte ich doch das Gebot des HERRN nicht übertreten, Böses oder Gutes zu tun nach meinem Herzen; sondern was der HERR reden werde, das werde ich auch reden? ");
INSERT INTO deu1951_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Und nun siehe, da ich zu meinem Volk ziehe, so komm, ich will dir sagen, was dieses Volk deinem Volk in spätern Tagen tun wird! ");
INSERT INTO deu1951_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Und er hob an seinen Spruch und sprach: Es sagt Bileam, der Sohn Beors, es sagt der Mann, dem das Auge erschlossen ist, ");
INSERT INTO deu1951_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","es sagt der Hörer göttlicher Reden, und der die Erkenntnis des Höchsten hat, der die Gesichte des Allmächtigen sieht und niederfällt, und dem die Augen geöffnet werden: ");
INSERT INTO deu1951_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ich sehe ihn, aber jetzt noch nicht; ich schaue ihn, aber noch nicht in der Nähe. Ein Stern tritt aus Jakob hervor, und ein Zepter kommt aus Israel. Er schlägt Moab auf beide Seiten und alle Kinder Set aufs Haupt. ");
INSERT INTO deu1951_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom wird seine Besitzung, und Seir zum Besitztum seiner Feinde; Israel aber wird tapfere Taten tun. ");
INSERT INTO deu1951_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Von Jakob wird der ausgehen, der herrschen wird, und er wird umbringen, was von den Städten übrig ist. ");
INSERT INTO deu1951_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Und als er Amalek sah, hob er an seinen Spruch und sprach: Amalek ist der Erstling der Heiden, und zuletzt wird er untergehen. ");
INSERT INTO deu1951_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Und als er die Keniter sah, hob er an seinen Spruch und sprach: Deine Wohnung ist fest, und du hast dein Nest in einen Felsen gelegt; ");
INSERT INTO deu1951_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","aber du wirst, o Kain, verwüstet werden! Wie lange geht es noch, bis dich Assur gefangen nimmt? ");
INSERT INTO deu1951_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Und er hob abermal seinen Spruch an und sprach: Wehe! wer wird leben, wenn Gott solches erfüllt? ");
INSERT INTO deu1951_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Und Schiffe aus Kittim werden Assur bezwingen und werden auch den Heber bezwingen; und auch er wird untergehen! ");
INSERT INTO deu1951_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Darnach machte sich Bileam auf und ging und kehrte an seinen Ort zurück; und Balak ging auch seines Weges. ");
INSERT INTO deu1951_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Und Israel wohnte in Sittim und das Volk fing an Unzucht zu treiben mit den Töchtern der Moabiter, ");
INSERT INTO deu1951_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","welche das Volk zu den Opfern ihrer Götter luden. Und das Volk aß und betete ihre Götter an. ");
INSERT INTO deu1951_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Und Israel hängte sich an Baal-Peor. Da ergrimmte der Zorn des HERRN über Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Und der HERR sprach zu Mose: Nimm alle Obersten des Volks und hänge sie dem HERRN auf angesichts der Sonne, daß der grimmige Zorn des HERRN von Israel abgewandt werde! ");
INSERT INTO deu1951_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Und Mose sprach zu den Richtern Israels: Jedermann töte seine Leute, die sich an Baal-Peor gehängt haben! ");
INSERT INTO deu1951_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Und siehe, ein Mann aus den Kindern Israel kam und brachte eine Midianitin zu seinen Brüdern vor den Augen Moses und der ganzen Gemeinde der Kinder Israel, während sie weinten vor der Tür der Stiftshütte. ");
INSERT INTO deu1951_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Als Pinehas, der Sohn Eleasars, des Sohnes Aarons, des Priesters, solches sah, stand er auf inmitten der Gemeinde und nahm einen Speer in seine Hand ");
INSERT INTO deu1951_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","und ging dem israelitischen Mann nach, hinein in das Gemach, und durchstach sie beide, den israelitischen Mann und das Weib, durch den Bauch. Da hörte die Plage auf von den Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Und derer, die an dieser Plage starben, waren vierundzwanzigtausend. ");
INSERT INTO deu1951_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinehas, der Sohn Eleasars, des Sohnes Aarons, des Priesters, hat dadurch, daß er mit meinem Eifer unter ihnen eiferte, meinen Grimm von den Kindern Israel abgewandt, so daß ich in meinem Eifer die Kinder Israel nicht aufgerieben habe. ");
INSERT INTO deu1951_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Darum sprich zu ihm: Siehe, ich gebe ihm meinen Bund des Friedens, ");
INSERT INTO deu1951_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","und es soll ihm und seinem Samen nach ihm, der Bund eines ewigen Priestertums zufallen dafür, daß er für seinen Gott geeifert und für die Kinder Israel Sühne erwirkt hat. ");
INSERT INTO deu1951_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Der erschlagene israelitische Mann aber, der samt der Midianitin erschlagen ward, hieß Simri; ein Sohn Salus, ein Fürst des Vaterhauses der Simeoniter. ");
INSERT INTO deu1951_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Das erschlagene midianitische Weib aber hieß Kosbi; eine Tochter Zurs, der das Stammesoberhaupt eines Vaterhauses unter den Midianitern war. ");
INSERT INTO deu1951_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Befehdet die Midianiter und schlagt sie; ");
INSERT INTO deu1951_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","denn sie sind es, die euch befehdet haben mit ihrer Arglist, die sie wider euch erdacht haben in Sachen Peors und ihrer Schwester Kosbi, der midianitischen Fürstentochter, die am Tage der Plage erschlagen wurde, welche um Peors willen entstand. ");
INSERT INTO deu1951_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Und als die Plage ein Ende hatte, sprach der HERR zu Mose und Eleasar, dem Sohn Aarons, des Priesters, also: ");
INSERT INTO deu1951_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Ermittle die Zahl der ganzen Gemeinde der Kinder Israel von zwanzig Jahren an und darüber, nach ihren Vaterhäusern, all derer in Israel, die tauglich sind, ins Heer zu ziehen. ");
INSERT INTO deu1951_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Und Mose redete mit ihnen, samt Eleasar, dem Priester, in der Ebene Moab am Jordan, Jericho gegenüber, und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Wer zwanzig Jahre alt ist und darüber, soll gezählt werden, wie der HERR Mose und den Kindern Israel, die aus Ägypten gezogen sind, geboten hat: ");
INSERT INTO deu1951_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, der Erstgeborene Israels. Die Kinder Rubens waren: Hanoch, daher das Geschlecht der Hanochiter kommt; Pallu, daher das Geschlecht der Palluiter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron, daher das Geschlecht der Hezroniter; Karmi, daher das Geschlecht der Karmiter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Das sind die Geschlechter der Rubeniter. Und die Zahl ihrer Gemusterten war 43730. ");
INSERT INTO deu1951_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Aber die Kinder Pallus waren: Eliab. ");
INSERT INTO deu1951_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Und die Kinder Eliabs waren: Nemuel und Datan und Abiram. Das sind Datan und Abiram, die Berufenen der Gemeinde, die wider Mose und wider Aaron haderten in der Rotte Korahs, als sie wider den HERRN haderten ");
INSERT INTO deu1951_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","und die Erde ihren Mund auftat und sie samt Korah verschlang, als die Rotte starb, als das Feuer zweihundertundfünfzig Männer verzehrte und sie zum Zeichen wurden. ");
INSERT INTO deu1951_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Aber die Kinder Korahs starben nicht. ");
INSERT INTO deu1951_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Die Kinder Simeons in ihren Geschlechtern waren: Nemuel, daher das Geschlecht der Nemueliter; Jamin, daher das Geschlecht der Jaminiter; Jachin, daher das Geschlecht der Jachiniter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Serah, daher das Geschlecht der Serahiter; Saul, daher das Geschlecht der Sauliter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Das sind die Geschlechter der Simeoniter, 22200. ");
INSERT INTO deu1951_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Die Kinder Gads in ihren Geschlechtern waren: Zephon, daher das Geschlecht der Zephoniter; Haggi, daher das Geschlecht der Haggiter; Suni, daher das Geschlecht der Suniter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osni, daher das Geschlecht der Osniter; Eri, daher das Geschlecht der Eriter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, daher das Geschlecht der Aroditer; Areli, daher das Geschlecht der Areliter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Das sind die Geschlechter der Kinder Gads, und die Zahl ihrer Gemusterten 40500. ");
INSERT INTO deu1951_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Die Kinder Judas waren: Er und Onan; sie waren aber im Lande Kanaan gestorben. ");
INSERT INTO deu1951_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Aber die Kinder Judas in ihren Geschlechtern waren: Sela, daher das Geschlecht der Selaniter; Perez, daher das Geschlecht der Pereziter; Serah, daher das Geschlecht der Serahiter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Aber die Kinder des Perez waren: Hezron, daher das Geschlecht der Hezroniter; Hamul, daher das Geschlecht der Hamuliter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","das sind die Geschlechter Judas, und die Zahl ihrer Gemusterten 76500. ");
INSERT INTO deu1951_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Die Kinder Issaschars in ihren Geschlechtern waren: Tola, daher das Geschlecht der Tolaiter; Puwa, daher das Geschlecht der Puniter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jasub, daher das Geschlecht der Jasubiter; Simron, daher das Geschlecht der Simroniter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Das sind die Geschlechter Issaschars, und die Zahl ihrer Gemusterten 64300. ");
INSERT INTO deu1951_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Die Kinder Sebulons in ihren Geschlechtern waren: Sered, daher das Geschlecht der Serediter; Elon, daher das Geschlecht der Eloniter; Jahleel, daher das Geschlecht der Jahleeliter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Das sind die Geschlechter der Sebuloniter, die Zahl ihrer Gemusterten 60500. ");
INSERT INTO deu1951_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Die Kinder Josephs in ihren Geschlechtern waren Manasse und Ephraim. ");
INSERT INTO deu1951_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Die Kinder Manasses waren: Machir, daher das Geschlecht der Machiriter; und Machir zeugte den Gilead, daher das Geschlecht der Gileaditer. ");
INSERT INTO deu1951_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Das sind aber die Kinder Gileads: Jeser, daher das Geschlecht der Jeseriter; Helek, daher das Geschlecht der Helekiter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, daher das Geschlecht der Asrieliter; Sichem, daher das Geschlecht der Sichemiter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida, daher das Geschlecht der Semidaiter; Hepher, daher das Geschlecht der Hepheriter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophchad aber, Hephers Sohn, hatte keine Söhne, sondern Töchter, die hießen Machla, Noah, Hogla, Milka und Tirza. ");
INSERT INTO deu1951_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Das sind die Geschlechter Manasses, die Zahl ihrer Gemusterten 52700. ");
INSERT INTO deu1951_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Die Kinder Ephraims in ihren Geschlechtern waren: Sutelah, daher das Geschlecht der Sutelahiter; Becher, daher das Geschlecht der Becheriter; Tahan, daher das Geschlecht der Tahaniter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Die Kinder aber Sutelahs waren: Eran, daher das Geschlecht der Eraniter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Das sind die Geschlechter der Kinder Ephraim, die Zahl ihrer Gemusterten 32500. (Das sind die Kinder Josephs in ihren Geschlechtern). ");
INSERT INTO deu1951_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Die Kinder Benjamins in ihren Geschlechtern waren: Bela, daher das Geschlecht der Belaiter; Asbel, daher das Geschlecht der Asbeliter; Ahiram, daher das Geschlecht der Ahiramiter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sephupham, daher das Geschlecht der Suphamiter; Hupham, daher das Geschlecht der Huphamiter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Die Kinder Belas aber waren: Ard und Naeman, daher das Geschlecht der Arditer und Naemaniter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Das sind die Kinder Benjamins in ihren Geschlechtern, die Zahl ihrer Gemusterten 45600. ");
INSERT INTO deu1951_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Die Kinder Dans in ihren Geschlechtern waren: Suham, daher das Geschlecht der Suhamiter. Das sind die Geschlechter Dans in ihren Geschlechtern. ");
INSERT INTO deu1951_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Und alle Geschlechter der Suhamiter, so viele von ihnen gemustert wurden, beliefen sich auf 64400. ");
INSERT INTO deu1951_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Die Kinder Assers in ihren Geschlechtern waren: Jimna, daher das Geschlecht der Jimnaiter; Jisvi, daher das Geschlecht der Jisviter; Beria, daher das Geschlecht der Beriiter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Aber die Kinder Berias waren: Heber, daher das Geschlecht der Heberiter; Malchiel, daher das Geschlecht der Malchieliter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Und die Tochter Assers hieß Serah. ");
INSERT INTO deu1951_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Das sind die Geschlechter der Kinder Assers, die Zahl ihrer Gemusterten 53400. ");
INSERT INTO deu1951_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Die Kinder Naphtalis in ihren Geschlechtern waren: Jahzeel, daher das Geschlecht der Jahzeeliter; Guni, daher das Geschlecht der Guniter; ");
INSERT INTO deu1951_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer, daher das Geschlecht der Jezeriter; Sillem, daher das Geschlecht der Sillemiter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Das sind die Geschlechter Naphtalis in ihren Geschlechtern, ihre Gemusterten 45400. ");
INSERT INTO deu1951_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Das sind die Gemusterten der Kinder Israel, 601730. ");
INSERT INTO deu1951_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Und der HERR redete zu Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Diesen soll das Land zum Erbe ausgeteilt werden nach der Anzahl der Namen. ");
INSERT INTO deu1951_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Vielen sollst du viel zum Erbteil geben, und wenigen wenig; jedem Stamm soll man sein Erbteil geben nach der Zahl seiner Gemusterten. ");
INSERT INTO deu1951_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Doch soll das Land durch das Los verteilt werden. Nach dem Namen der Stämme ihrer Väter sollen sie ihr Erbteil empfangen; ");
INSERT INTO deu1951_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","denn nach dem Los soll ihr Erbe ausgeteilt werden, unter die Vielen und Wenigen. ");
INSERT INTO deu1951_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Und dies sind die Gemusterten Levis in ihren Geschlechtern: Gerson, daher das Geschlecht der Gersoniter; Kahat, daher das Geschlecht der Kahatiter; Merari, daher das Geschlecht der Merariter. ");
INSERT INTO deu1951_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Das sind die Geschlechter Levis: das Geschlecht der Libniter, das Geschlecht der Hebroniter, das Geschlecht der Maheliter, das Geschlecht der Muschiter, das Geschlecht der Korahiter. Kahat aber hat den Amram gezeugt. ");
INSERT INTO deu1951_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Und das Weib Amrams hieß Jochebed, eine Tochter Levis, die ihm in Ägypten geboren war; und sie gebar dem Amram Aaron und Mose und ihre Schwester Mirjam. ");
INSERT INTO deu1951_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron aber wurden geboren Nadab, Abihu, Eleasar und Itamar. ");
INSERT INTO deu1951_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab aber und Abihu starben, als sie fremdes Feuer vor den HERRN brachten. ");
INSERT INTO deu1951_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Und die Gesamtzahl ihrer Gemusterten war 23000, alle männlichen Geschlechts, die einen Monat alt waren und darüber; denn sie wurden nicht unter die Kinder Israel gezählt; denn man gab ihnen kein Erbe unter den Kindern Israel. ");
INSERT INTO deu1951_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Das ist die Musterung der Kinder Israel, die Mose und Eleasar, der Priester, vornahmen in der Ebene Moab am Jordan, Jericho gegenüber. ");
INSERT INTO deu1951_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Unter diesen war keiner von denjenigen, welche Mose und Aaron, der Priester, musterten, als sie die Kinder Israel in der Wüste Sinai zählten. ");
INSERT INTO deu1951_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Denn der HERR hatte ihnen gesagt, sie sollten in der Wüste des Todes sterben. Und es blieb keiner übrig, außer Kaleb, der Sohn Jephunnes, und Josua, der Sohn Nuns. ");
INSERT INTO deu1951_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Und die Töchter Zelophchads, des Sohnes Hephers, des Sohnes Gileads, des Sohnes Machirs, des Sohnes Manasses, unter den Geschlechtern Manasses, des Sohnes Josephs, mit Namen Machla, Noah, Hogla, Milka und Tirza, ");
INSERT INTO deu1951_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","kamen herzu und traten vor Mose und Eleasar, den Priester, und vor die Obersten und die ganze Gemeinde an die Tür der Stiftshütte und sprachen: ");
INSERT INTO deu1951_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Unser Vater ist in der Wüste gestorben und gehörte nicht zur Gemeinde, die sich in der Rotte Korahs wider den HERRN empörte; sondern er ist an seiner Sünde gestorben und hat keine Söhne gehabt. ");
INSERT INTO deu1951_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Warum soll denn unsres Vaters Name unter seinen Geschlechtern untergehen, weil er keinen Sohn hat? Gib uns auch ein Erbteil unter den Brüdern unsres Vaters! ");
INSERT INTO deu1951_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Da brachte Mose ihre Rechtssache vor den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Die Töchter Zelophchads haben recht geredet. Du sollst ihnen unter den Brüdern ihres Vaters ein Erbteil geben und sollst ihnen das Erbe ihres Vaters zuwenden. ");
INSERT INTO deu1951_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Und sage den Kindern Israel also: Wenn jemand stirbt und keinen Sohn hat, so soll er sein Erbe seiner Tochter zuwenden. ");
INSERT INTO deu1951_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Hat er keine Tochter, so sollt ihr es seinen Brüdern geben. ");
INSERT INTO deu1951_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Hat er keine Brüder, so sollt ihr es den Brüdern seines Vaters geben. ");
INSERT INTO deu1951_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Hat sein Vater aber keine Brüder, so sollt ihr es den nächsten Blutsverwandten von seinem Geschlecht geben, daß sie es einnehmen. Das soll den Kindern Israel ein Gesetz und ein Recht sein, wie der HERR Mose geboten hat. ");
INSERT INTO deu1951_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Und der HERR sprach zu Mose: Steig auf dieses Gebirge Abarim und besiehe das Land, das ich den Kindern Israel gegeben habe. ");
INSERT INTO deu1951_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Und wenn du es gesehen hast, sollst du auch zu deinem Volke versammelt werden, wie dein Bruder Aaron versammelt worden ist, ");
INSERT INTO deu1951_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","weil ihr in der Wüste Zin meinem Gebot widerspenstig gewesen seid, beim Hadern der Gemeinde, als ihr mich vor ihnen durch das Wasser heiligen solltet. Das ist das Haderwasser zu Kades in der Wüste Zin. ");
INSERT INTO deu1951_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Und Mose redete mit dem HERRN und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Der HERR, der Gott der Geister alles Fleisches, wolle einen Mann über die Gemeinde setzen, ");
INSERT INTO deu1951_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","der vor ihnen aus und eingehe und sie aus und einführe, daß die Gemeinde des HERRN nicht sei wie Schafe, die keinen Hirten haben! ");
INSERT INTO deu1951_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Und der HERR sprach zu Mose: Nimm Josua, den Sohn Nuns, zu dir, einen Mann, in welchem der Geist ist, ");
INSERT INTO deu1951_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","und lege deine Hand auf ihn und stelle ihn vor Eleasar, den Priester, und vor die ganze Gemeinde und gib ihm Befehl vor ihren Augen. ");
INSERT INTO deu1951_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Und lege von deiner Herrlichkeit auf ihn, daß die ganze Gemeinde der Kinder Israel ihm gehorsam sei. ");
INSERT INTO deu1951_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Und er soll vor Eleasar, den Priester, treten; der soll für ihn um Rat fragen, durch den Gebrauch der Urim, vor dem HERRN. Nach seiner Weisung sollen sie aus und einziehen, er und alle Kinder Israel und die ganze Gemeinde mit ihm. ");
INSERT INTO deu1951_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Und Mose tat, wie der HERR geboten hatte, und nahm Josua und stellte ihn vor Eleasar, den Priester, ");
INSERT INTO deu1951_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","und vor die ganze Gemeinde und legte seine Hände auf ihn und befahl ihm; wie der HERR durch Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Und der HERR redete zu Mose und sprach: Gebiete den Kindern Israel und sprich zu ihnen: ");
INSERT INTO deu1951_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Ihr sollt darauf achten, daß ihr meine Opfergaben, meine Nahrung der Feueropfer lieblichen Geruchs, mir darbringet zu ihrer bestimmten Zeit. ");
INSERT INTO deu1951_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Und sprich zu ihnen: Das ist das Feueropfer, welches ihr dem HERRN darbringen sollt: einjährige, tadellose Lämmer; täglich zwei zum beständigen Brandopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Das eine Lamm sollst du am Morgen, das andere gegen Abend zurüsten; ");
INSERT INTO deu1951_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","dazu ein Zehntel Epha Semmelmehl zum Speisopfer, gemengt mit einem Viertel Hin gestoßenen Öls. ");
INSERT INTO deu1951_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Das ist das beständige Brandopfer, welches am Berg Sinai geopfert ward zum lieblichen Geruch, als Feueropfer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Dazu sein Trankopfer, zu jedem Lamm ein Viertel Hin. Im Heiligtum soll man dem HERRN das Trankopfer von starkem Getränk ausgießen. ");
INSERT INTO deu1951_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Das andere Lamm sollst du gegen Abend opfern, wie das Speisopfer am Morgen und wie sein Trankopfer, als wohlriechendes Feuer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Am Sabbattag aber zwei einjährige, tadellose Lämmer und zwei Zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, dazu sein Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Das ist das Brandopfer eines jeden Sabbats, außer dem beständigen Brandopfer und seinem Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Aber am ersten Tag eurer Monate sollt ihr dem HERRN zum Brandopfer darbringen: zwei junge Farren, einen Widder, sieben einjährige, tadellose Lämmer; ");
INSERT INTO deu1951_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","und drei Zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, zu jedem Farren; zwei Zehntel Semmelmehl, mit Öl gemengt, zu dem Widder, ");
INSERT INTO deu1951_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","und ein Zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, zu jedem Lamm. Das ist das Brandopfer des wohlriechenden Feuers für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Und ihr Trankopfer soll sein ein halbes Hin Wein zu jedem Farren, ein Drittel Hin zu dem Widder, ein Viertel Hin zu jedem Lamm. Das ist das Brandopfer eines jeden Monats im Jahre. ");
INSERT INTO deu1951_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Dazu soll man einen Ziegenbock zum Sündopfer dem HERRN darbringen, außer dem beständigen Brandopfer und seinem Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Aber am vierzehnten Tage des ersten Monats ist das Passah des HERRN; ");
INSERT INTO deu1951_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","und am fünfzehnten Tage desselben Monats ist das Fest; sieben Tage soll man ungesäuertes Brot essen. ");
INSERT INTO deu1951_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Am ersten Tage soll heilige Versammlung sein; da sollt ihr keine Werktagsarbeit verrichten, ");
INSERT INTO deu1951_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","sondern sollt dem HERRN feurige Brandopfer darbringen, zwei junge Farren, einen Widder, sieben einjährige Lämmer; tadellos sollen sie sein; ");
INSERT INTO deu1951_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","dazu ihre Speisopfer von Semmelmehl, mit Öl gemengt; drei Zehntel sollt ihr zu jedem Farren tun und zwei Zehntel zum Widder ");
INSERT INTO deu1951_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","und ein Zehntel zu jedem der sieben Lämmer; ");
INSERT INTO deu1951_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","dazu einen Sündopferbock, um Sühnung für euch zu erwirken. ");
INSERT INTO deu1951_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Und solches sollt ihr tun außer dem Brandopfer vom Morgen, welches ein beständiges Brandopfer ist. ");
INSERT INTO deu1951_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Auf diese Weise sollt ihr täglich, sieben Tage lang, dem HERRN die Nahrung des wohlriechenden Feuers darbringen, neben dem beständigen Brandopfer; dazu sein Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Und am siebenten Tage sollt ihr eine heilige Versammlung halten; da sollt ihr keine Werktagsarbeit verrichten. ");
INSERT INTO deu1951_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Auch am Tage der Erstlinge, wenn ihr dem HERRN das neue Speisopfer an eurem Wochenfeste darbringet, sollt ihr eine heilige Versammlung halten; da sollt ihr keine Werktagsarbeit verrichten, ");
INSERT INTO deu1951_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","sondern ihr sollt dem HERRN zum Brandopfer lieblichen Geruchs darbringen zwei junge Farren, einen Widder, ");
INSERT INTO deu1951_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","sieben einjährige Lämmer samt ihrem Speisopfer von Semmelmehl, mit Öl gemengt; drei Zehntel auf jeden Farren, ");
INSERT INTO deu1951_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","zwei Zehntel auf jeden Widder; und ein Zehntel auf jedes der sieben Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","und einen Ziegenbock, um Sühnung für euch zu erwirken. ");
INSERT INTO deu1951_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Diese Opfer sollt ihr verrichten, außer dem beständigen Brandopfer mit seinem Speisopfer (sie sollen tadellos sein) und ihre Trankopfer dazu. ");
INSERT INTO deu1951_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Und am ersten Tage des siebenten Monats sollt ihr eine heilige Versammlung halten, da sollt ihr keine Werktagsarbeit verrichten, denn es ist euer Posaunentag. ");
INSERT INTO deu1951_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Und ihr sollt dem HERRN Brandopfer darbringen zum lieblichen Geruche: einen jungen Farren, einen Widder, sieben einjährige tadellose Lämmer; ");
INSERT INTO deu1951_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","dazu ihr Speisopfer von Semmelmehl, mit Öl gemengt, drei Zehntel zum Farren, zwei Zehntel zum Widder ");
INSERT INTO deu1951_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","und ein Zehntel zu jedem der sieben Lämmer; ");
INSERT INTO deu1951_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","auch einen Ziegenbock zum Sündopfer, um Sühnung für euch zu erwirken, ");
INSERT INTO deu1951_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","außer dem Brandopfer des Neumonds und seinem Speisopfer, und außer dem beständigen Brandopfer mit seinem Speisopfer und mit ihren Trankopfern, wie es sich gebührt, zum wohlriechenden Feuer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Am zehnten Tag dieses siebenten Monats sollt ihr auch eine heilige Versammlung halten und sollt eure Seelen demütigen; da sollt ihr keine Werktagsarbeit verrichten, ");
INSERT INTO deu1951_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","sondern dem HERRN ein Brandopfer darbringen, zum lieblichen Geruch: einen jungen Farren, einen Widder, sieben einjährige, tadellose Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","samt ihrem Speisopfer von Semmelmehl, mit Öl gemengt, drei Zehntel zum Farren, zwei Zehntel zum Widder, ");
INSERT INTO deu1951_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","und ein Zehntel zu jedem der sieben Lämmer; ");
INSERT INTO deu1951_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","einen Ziegenbock zum Sündopfer, außer dem Sündopfer der Versühnung und dem täglichen Brandopfer mit seinem Speisopfer und ihren Trankopfern. ");
INSERT INTO deu1951_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Gleicherweise sollt ihr am fünfzehnten Tage des siebenten Monats eine heilige Versammlung halten; da sollt ihr keine Werktagsarbeit verrichten, sondern ihr sollt dem HERRN sieben Tage lang ein Fest feiern. ");
INSERT INTO deu1951_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Da sollt ihr Brandopfer darbringen, ein wohlriechendes Feuer für den HERRN: dreizehn junge Farren, zwei Widder, vierzehn einjährige, tadellose Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","samt ihrem Speisopfer von Semmelmehl, mit Öl gemengt, drei Zehntel zu jedem der dreizehn Farren, ");
INSERT INTO deu1951_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","zwei Zehntel zu jedem der beiden Widder und ein Zehntel zu jedem der vierzehn Lämmer; ");
INSERT INTO deu1951_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer mit seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Und am zweiten Tage: zwölf junge Farren, zwei Widder, vierzehn einjährige, tadellose Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","mit den zugehörigen Speisopfern und Trankopfern zu den Farren, Widdern und Lämmern, wie sich's gebührt, nach ihrer Zahl, ");
INSERT INTO deu1951_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer samt seinem Speisopfer und den Trankopfern. ");
INSERT INTO deu1951_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Und am dritten Tage: elf Farren, zwei Widder, vierzehn einjährige, tadellose Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","samt den zugehörigen Speisopfern und Trankopfern zu den Farren, Widdern und Lämmern, nach ihrer Zahl, wie sich's gebührt; ");
INSERT INTO deu1951_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer samt seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Und am vierten Tage: zehn Farren, zwei Widder, ");
INSERT INTO deu1951_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","vierzehn einjährige, tadellose Lämmer, samt den zugehörigen Speisopfern und Trankopfern zu den Farren, Widdern und Lämmern, nach ihrer Zahl, wie sich's gebührt; ");
INSERT INTO deu1951_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer samt seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Und am fünften Tage: neun Farren, zwei Widder, vierzehn einjährige, tadellose Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","samt den zugehörigen Speisopfern und Trankopfern zu den Farren, Widdern und Lämmern, nach ihrer Zahl, wie sich's gebührt; ");
INSERT INTO deu1951_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer samt seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Und am sechsten Tage: acht Farren, zwei Widder, vierzehn einjährige, tadellose Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","samt den zugehörigen Speisopfern und Trankopfern zu den Farren, Widdern und Lämmern, nach ihrer Zahl, wie sich's gebührt; ");
INSERT INTO deu1951_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","dazu einen Bock zum Sündopfer, außer dem täglichen Brandopfer samt seinem Speisopfer und seinen Trankopfern. ");
INSERT INTO deu1951_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Und am siebenten Tage: sieben Farren, zwei Widder, vierzehn einjährige, tadellose Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","samt den zugehörigen Speisopfern und Trankopfern zu den Farren, Widdern und Lämmern, nach ihrer Zahl, wie sich's gebührt; ");
INSERT INTO deu1951_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer samt seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Am achten Tag sollt ihr eine Versammlung halten; da sollt ihr keine Werktagsarbeit verrichten, ");
INSERT INTO deu1951_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","sondern dem HERRN Brandopfer darbringen, ein Feueropfer lieblichen Geruchs: einen Farren, einen Widder, sieben einjährige, tadellose Lämmer, ");
INSERT INTO deu1951_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","samt dem erforderlichen Speisopfer und den Trankopfern zu dem Farren, dem Widder und den Lämmern, nach ihrer Zahl, wie sich's gebührt; ");
INSERT INTO deu1951_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer samt seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deu1951_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Solches sollt ihr dem HERRN an euren Festen darbringen, außer dem, was ihr gelobt und freiwillig gebt an Brandopfern, Speisopfern, Trankopfern und Dankopfern. ");
INSERT INTO deu1951_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","(029-39b) Und Mose sagte den Kindern Israel alles, was ihm der HERR geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Und Mose redete mit den Obersten der Stämme der Kinder Israel und sprach: (030-2) Das ist's, was der HERR geboten hat: ");
INSERT INTO deu1951_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","(030-3) Wenn ein Mann dem HERRN ein Gelübde tut oder einen Eid schwört, womit er eine Verpflichtung auf seine Seele bindet, so soll er sein Wort nicht brechen; sondern gemäß allem, das aus seinem Munde gegangen ist, soll er tun. ");
INSERT INTO deu1951_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","(030-4) Wenn ein Weib dem HERRN ein Gelübde tut und sich verpflichtet, solange sie noch eine Jungfrau in ihres Vaters Hause ist, ");
INSERT INTO deu1951_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","(030-5) und ihr Gelübde und ihre Verpflichtung, die sie auf ihre Seele nahm, vor ihren Vater kommt, und er schweigt dazu, so gilt all ihr Gelübde und alle ihre Verpflichtung, die sie auf ihre Seele gebunden hat. ");
INSERT INTO deu1951_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","(030-6) Wenn aber ihr Vater an dem Tage, da er es hört, ihr wehrt, so gilt kein Gelübde und keine Verpflichtung, die sie auf ihre Seele gebunden hat. Und der HERR wird es ihr vergeben, weil ihr Vater ihr gewehrt hat. ");
INSERT INTO deu1951_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","(030-7) Hat sie aber einen Mann und hat ein Gelübde auf sich oder ein unbedachtes Versprechen, das sie auf ihre Seele gebunden hat, ");
INSERT INTO deu1951_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","(030-8) und ihr Mann hört es und schweigt still an dem Tage, da er davon hört, so gilt ihr Gelübde und ihre Verpflichtung, welche sie auf ihre Seele gebunden hat. ");
INSERT INTO deu1951_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","(030-9) Wenn aber ihr Mann ihr wehrt an dem Tage, da er es hört, so macht er damit ihr Gelübde kraftlos, das sie auf sich hat, und das unbedachte Versprechen, das sie auf ihre Seele gebunden hat; und der HERR wird es ihr vergeben. ");
INSERT INTO deu1951_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","(030-10) Das Gelübde einer Witwe oder einer Verstoßenen, alles, was sie sich auf die Seele gebunden hat, soll für sie gelten. ");
INSERT INTO deu1951_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","(030-11) Hat aber eine Frau im Hause ihres Mannes ein Gelübde getan oder sich mit einem Eid etwas auf die Seele gebunden, ");
INSERT INTO deu1951_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","(030-12) und ihr Mann hat es gehört und dazu geschwiegen und ihr nicht gewehrt, so gelten alle ihre Gelübde und alles, was sie auf ihre Seele gebunden hat. ");
INSERT INTO deu1951_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","(030-13) Entkräftet es aber ihr Mann an dem Tage, da er es hört, so gilt nichts von dem, was über ihre Lippen gegangen ist, das Gelübde oder die Verpflichtung ihrer Seele; denn ihr Mann hat es entkräftet, und der HERR wird es ihr vergeben. ");
INSERT INTO deu1951_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","(030-14) Alle Gelübde und jeden Verpflichtungseid zur Demütigung der Seele kann ihr Mann bestätigen oder entkräften. ");
INSERT INTO deu1951_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","(030-15) Wenn er aber von einem Tage bis zum andern schweigt, so bekräftigt er ihr ganzes Gelübde und die Verpflichtung, die sie auf sich hat, weil er an dem Tage, da er es gehört, geschwiegen hat. ");
INSERT INTO deu1951_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","(030-16) Wollte er's aber erst später entkräften, nachdem er es gehört hat, so müßte er ihre Schuld tragen. ");
INSERT INTO deu1951_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","(030-17) Das sind die Rechte, die der HERR Mose geboten hat, eines Mannes gegenüber seinem Weibe und eines Vaters gegenüber seiner Tochter, solange sie noch eine Jungfrau in ihres Vaters Hause ist. ");
INSERT INTO deu1951_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Und der HERR redete zu Mose und sprach: Nimm für die Kinder Israel Rache an den Midianitern; ");
INSERT INTO deu1951_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","darnach sollst du zu deinem Volk versammelt werden. ");
INSERT INTO deu1951_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Da redete Mose mit dem Volk und sprach: Rüstet unter euch Leute zu einem Heereszug wider die Midianiter, daß sie die Rache des HERRN an den Midianitern vollstrecken! ");
INSERT INTO deu1951_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Aus allen Stämmen Israels sollt ihr je tausend Mann in den Streit schicken. ");
INSERT INTO deu1951_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Da wurden aus den Tausenden Israels tausend von jedem Stamme ausgewählt, zwölftausend zum Streit Gerüstete. ");
INSERT INTO deu1951_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Und Mose schickte sie, tausend aus jedem Stamm, in den Streit, sie und Pinehas, den Sohn Eleasars, des Priesters, zum Heereszug, mit den heiligen Geräten und den Lärmtrompeten in seiner Hand. ");
INSERT INTO deu1951_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Und sie führten den Streit wider die Midianiter, wie der HERR Mose geboten hatte, und töteten alles, was männlich war. ");
INSERT INTO deu1951_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Sie töteten auch die Könige der Midianiter zu den andern von ihnen Erschlagenen, nämlich Evi, Rekem, Zur, Chur und Reba, fünf Könige der Midianiter; auch Bileam, den Sohn Beors, brachten sie mit dem Schwerte um. ");
INSERT INTO deu1951_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Und die Kinder Israel nahmen die Weiber der Midianiter und ihre Kinder gefangen; all ihr Vieh, alle ihre Habe und alle ihre Güter raubten sie; ");
INSERT INTO deu1951_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","und alle ihre Städte, ihre Wohnungen und alle ihre Zeltlager verbrannten sie mit Feuer. ");
INSERT INTO deu1951_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Und sie nahmen alle Beute und allen Raub an Menschen und Vieh ");
INSERT INTO deu1951_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","und brachten es zu Mose und Eleasar, dem Priester, und zu der Gemeinde der Kinder Israel, nämlich die Gefangenen und die Beute und das geraubte Gut, in das Lager auf der Moabiter Ebene, die am Jordan, Jericho gegenüber, liegt. ");
INSERT INTO deu1951_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Und Mose und Eleasar, der Priester, und alle Hauptleute der Gemeinde gingen ihnen entgegen vor das Lager hinaus. ");
INSERT INTO deu1951_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Und Mose ward zornig über die Vorgesetzten des Heeres, die Hauptleute über Tausende und über Hunderte, die vom Kriegszuge kamen. ");
INSERT INTO deu1951_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Und Mose sprach zu ihnen: Warum habt ihr alle Weiber leben lassen? ");
INSERT INTO deu1951_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Siehe, sie haben ja in der Sache des Peor durch Bileams Rat die Kinder Israel vom HERRN abgewandt, so daß der Gemeinde des HERRN die Plage widerfuhr! ");
INSERT INTO deu1951_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","So erwürgt nun alles, was männlich ist unter den Kindern; und alle Weiber, welche einen Mann durch Beischlaf kennengelernt haben, die tötet; ");
INSERT INTO deu1951_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","aber alle weiblichen Kinder, die von männlichem Beischlaf nichts wissen, die lasset für euch leben. ");
INSERT INTO deu1951_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Und lagert euch außerhalb des Lagers sieben Tage lang, ihr alle, die ihr jemand erwürgt oder Erschlagene angerührt habt, und entsündigt euch am dritten und siebenten Tage, samt denen, welche ihr gefangen genommen habt. ");
INSERT INTO deu1951_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Und alle Kleider und alles Geräte von Fellen und alles, was von Ziegenhaar gemacht ist, und alles hölzerne Gerät sollt ihr entsündigen. ");
INSERT INTO deu1951_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Und Eleasar, der Priester, sprach zu den Kriegsleuten, die in den Streit gezogen waren: Siehe, das ist die Gesetzesbestimmung, welche der HERR Mose geboten hat: ");
INSERT INTO deu1951_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Gold, Silber, Erz, Eisen, Zinn und Blei, und alles, ");
INSERT INTO deu1951_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","was das Feuer aushält, sollt ihr durchs Feuer gehen lassen und reinigen; nur muß es mit dem Reinigungswasser entsündigt werden. Aber alles, was das Feuer nicht aushält, sollt ihr durchs Wasser gehen lassen. ");
INSERT INTO deu1951_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Auch eure Kleider sollt ihr am siebenten Tage waschen, so werdet ihr rein. Darnach sollt ihr ins Lager kommen. ");
INSERT INTO deu1951_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Stelle fest die Summe des Raubes der Gefangenen an Menschen und Vieh, du und Eleasar, der Priester, und die obersten Väter der Gemeinde, und gib die eine Hälfte denen, ");
INSERT INTO deu1951_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","die den Krieg geführt haben und in den Streit gezogen sind, und die andere Hälfte der ganzen Gemeinde. ");
INSERT INTO deu1951_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Du sollst aber dem HERRN eine Steuer erheben von den Kriegsleuten, die ins Feld gezogen sind, eine Seele von je fünfhundert, von Menschen, Rindern, Eseln und Schafen. ");
INSERT INTO deu1951_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Von ihrer Hälfte sollst du es nehmen, und es Eleasar, dem Priester, geben, zum Hebopfer für den HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Aber von der Hälfte der Kinder Israel sollst du von je fünfzig ein Stück nehmen, von Menschen, Rindern, Eseln und Schafen, von allem Vieh, und sollst es den Leviten geben, die der Wohnung des HERRN warten. ");
INSERT INTO deu1951_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Und Mose und Eleasar, der Priester, taten, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Es betrug aber die Beute, welche das Kriegsvolk geraubt hatte: 675000 Schafe, 270000 Rinder, ");
INSERT INTO deu1951_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","61000 Esel. ");
INSERT INTO deu1951_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Und der weiblichen Personen, ");
INSERT INTO deu1951_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","die von keinem männlichen Beischlaf wußten, waren 32000. ");
INSERT INTO deu1951_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Und die Hälfte, welche denen gehörte, die ins Feld gezogen waren, betrug 337500 Schafe, ");
INSERT INTO deu1951_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","davon wurden dem HERRN zuteil sechshundertsiebzig Schafe; ");
INSERT INTO deu1951_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ferner 36000 Rinder; davon wurden dem HERRN zuteil zweiundsiebzig; ");
INSERT INTO deu1951_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ferner 30500 Esel, davon wurden dem HERRN zuteil einundsechzig; ");
INSERT INTO deu1951_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16000 Menschenseelen; davon wurden dem HERRN zuteil zweiunddreißig. ");
INSERT INTO deu1951_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Und Mose gab diese Steuer, als Hebopfer für den HERRN, Eleasar, dem Priester; wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Aber die andere Hälfte, welche Mose von der Kriegsbeute den Kindern Israel zugeteilt hatte, ");
INSERT INTO deu1951_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","nämlich die der Gemeinde zufallende Hälfte, betrug 337500 Schafe, ");
INSERT INTO deu1951_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36000 Rinder, ");
INSERT INTO deu1951_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30500 Esel, ");
INSERT INTO deu1951_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","und 16000 Menschenseelen. ");
INSERT INTO deu1951_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Und Mose nahm von dieser Hälfte der Kinder Israel je ein Stück von fünfzig, von Menschen und Vieh, und gab es den Leviten, welche der Wohnung des HERRN warteten; wie der HERR Mose geboten hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Und die Obersten des Heeres, die Hauptleute über tausend und über hundert, ");
INSERT INTO deu1951_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","traten zu Mose und sprachen zu ihm: Deine Knechte haben die Summe der Kriegsleute festgestellt, welche unter unsern Händen gewesen sind, und es fehlt nicht einer. ");
INSERT INTO deu1951_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Darum bringen wir dem HERRN Geschenke, was ein jeder gefunden hat von goldenem Geräte, Fußketten, Armbänder, Fingerringe, Ohrringe und Spangen, um unsre Seelen zu sühnen vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Und Mose und Eleasar, der Priester, nahmen von ihnen das Gold, allerlei künstliche Geräte. ");
INSERT INTO deu1951_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Und alles Gold des Hebopfers, das sie dem HERRN darbrachten, betrug 16750 Schekel, vonseiten der Hauptleute über tausend und der Hauptleute über hundert. ");
INSERT INTO deu1951_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Die Kriegsleute hatten ein jeder für sich geraubt. ");
INSERT INTO deu1951_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Und Mose und Eleasar, der Priester, nahmen das Gold von den Hauptleuten über tausend und über hundert und brachten es in die Stiftshütte zum Gedächtnis der Kinder Israel vor dem HERRN. ");
INSERT INTO deu1951_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Die Kinder Ruben aber und die Kinder Gad hatten sehr viel Vieh und sahen das Land Jaeser und das Land Gilead, und siehe, es war ein geeignetes Land für ihr Vieh. ");
INSERT INTO deu1951_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Da kamen die Kinder Gad und die Kinder Ruben und redeten mit Mose und Eleasar, dem Priester, und mit den Hauptleuten der Gemeinde und sprachen: ");
INSERT INTO deu1951_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atarot, Dibon, Jaeser, Nimra, Hesbon, Eleale, Sebam, ");
INSERT INTO deu1951_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Nebo und Beon, das Land, welches der HERR vor der Gemeinde Israel geschlagen hat, ist geeignet für das Vieh; nun haben wir, deine Knechte, viel Vieh. ");
INSERT INTO deu1951_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Und sie sprachen: Haben wir Gnade vor dir gefunden, so gib dieses Land deinen Knechten zu eigen und führe uns nicht über den Jordan. ");
INSERT INTO deu1951_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Und Mose sprach zu den Kindern Gad und zu den Kindern Ruben: Sollen eure Brüder in den Streit ziehen, und ihr wollt hier bleiben? ");
INSERT INTO deu1951_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Warum macht ihr doch das Herz der Kinder Israel abwendig, daß sie nicht hinüberziehen in das Land, das ihnen der HERR geben will? ");
INSERT INTO deu1951_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Also taten auch eure Väter, als ich sie von Kadesch-Barnea aussandte, das Land zu beschauen; ");
INSERT INTO deu1951_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","als sie bis zum Tal Eskol hinaufgekommen waren und das Land sahen, machten sie das Herz der Kinder Israel abwendig, daß sie nicht in das Land ziehen wollten, das ihnen der HERR gegeben hatte. ");
INSERT INTO deu1951_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Und der Zorn des HERRN entbrannte zu derselben Zeit, und er schwur und sprach: ");
INSERT INTO deu1951_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Fürwahr, die Männer, die aus Ägypten gezogen sind, von zwanzig Jahren an und darüber sollen das Land nicht sehen, das ich Abraham, Isaak und Jakob geschworen habe, weil sie mir nicht gänzlich nachgefolgt sind; ");
INSERT INTO deu1951_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ausgenommen Kaleb, der Sohn Jephunnes, der Kenisiter, und Josua, der Sohn Nuns; denn sie sind dem HERRN gänzlich nachgefolgt. ");
INSERT INTO deu1951_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Also entbrannte der Zorn des HERRN über Israel, und er ließ sie in der Wüste hin und herziehen vierzig Jahre lang, bis das ganze Geschlecht, das vor dem HERRN übel gehandelt hatte, aufgerieben war. ");
INSERT INTO deu1951_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Und siehe, ihr seid an eurer Väter Statt aufgekommen, eine Brut von Sündern, den Zorn und Grimm des HERRN wider Israel noch größer zu machen. ");
INSERT INTO deu1951_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Denn wenn ihr euch von seiner Nachfolge abwendet, so wird er auch sie noch länger in der Wüste lassen, und ihr werdet dieses ganze Volk verderben! ");
INSERT INTO deu1951_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Da traten sie zu ihm und sprachen: Wir wollen nur Schafhürden hier bauen für unser Vieh und Städte für unsere Kinder. ");
INSERT INTO deu1951_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Wir aber wollen uns rüsten und eilends voranziehen vor den Kindern Israel, bis wir sie an ihren Ort bringen; unsre Kinder sollen in den verschlossenen Städten bleiben um der Einwohner des Landes willen. ");
INSERT INTO deu1951_vpl VALUES ("NU32_18","005_32_18","NUM","