﻿USE sofia;
DROP TABLE IF EXISTS sofia.deu1912_vpl;
CREATE TABLE deu1912_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES deu1912_vpl WRITE;
INSERT INTO deu1912_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Am Anfang schuf Gott Himmel und Erde. ");
INSERT INTO deu1912_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Und die Erde war wüst und leer, und es war finster auf der Tiefe; und der Geist Gottes schwebte auf dem Wasser. ");
INSERT INTO deu1912_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Und Gott sprach: Es werde Licht! und es ward Licht. ");
INSERT INTO deu1912_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Und Gott sah, daß das Licht gut war. Da schied Gott das Licht von der Finsternis ");
INSERT INTO deu1912_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","und nannte das Licht Tag und die Finsternis Nacht. Da ward aus Abend und Morgen der erste Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Und Gott sprach: Es werde eine Feste zwischen den Wassern, und die sei ein Unterschied zwischen den Wassern. ");
INSERT INTO deu1912_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Da machte Gott die Feste und schied das Wasser unter der Feste von dem Wasser über der Feste. Und es geschah also. ");
INSERT INTO deu1912_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Und Gott nannte die Feste Himmel. Da ward aus Abend und Morgen der andere Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Und Gott sprach: Es sammle sich das Wasser unter dem Himmel an besondere Örter, daß man das Trockene sehe. Und es geschah also. ");
INSERT INTO deu1912_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Und Gott nannte das Trockene Erde, und die Sammlung der Wasser nannte er Meer. Und Gott sah, daß es gut war. ");
INSERT INTO deu1912_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Und Gott sprach: Es lasse die Erde aufgehen Gras und Kraut, das sich besame, und fruchtbare Bäume, da ein jeglicher nach seiner Art Frucht trage und habe seinen eigenen Samen bei sich selbst auf Erden. Und es geschah also. ");
INSERT INTO deu1912_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Und die Erde ließ aufgehen Gras und Kraut, das sich besamte, ein jegliches nach seiner Art, und Bäume, die da Frucht trugen und ihren eigenen Samen bei sich selbst hatten, ein jeglicher nach seiner Art. Und Gott sah, daß es gut war. ");
INSERT INTO deu1912_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Da ward aus Abend und Morgen der dritte Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Und Gott sprach: Es werden Lichter an der Feste des Himmels, die da scheiden Tag und Nacht und geben Zeichen, Zeiten, Tage und Jahre ");
INSERT INTO deu1912_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","und seien Lichter an der Feste des Himmels, daß sie scheinen auf Erden. Und es geschah also. ");
INSERT INTO deu1912_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Und Gott machte zwei große Lichter: ein großes Licht, das den Tag regiere, und ein kleines Licht, das die Nacht regiere, dazu auch Sterne. ");
INSERT INTO deu1912_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Und Gott setzte sie an die Feste des Himmels, daß sie schienen auf die Erde ");
INSERT INTO deu1912_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","und den Tag und die Nacht regierten und schieden Licht und Finsternis. Und Gott sah, daß es gut war. ");
INSERT INTO deu1912_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Da ward aus Abend und Morgen der vierte Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Und Gott sprach: Es errege sich das Wasser mit webenden und lebendigen Tieren, und Gevögel fliege auf Erden unter der Feste des Himmels. ");
INSERT INTO deu1912_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Und Gott schuf große Walfische und allerlei Getier, daß da lebt und webt, davon das Wasser sich erregte, ein jegliches nach seiner Art, und allerlei gefiedertes Gevögel, ein jegliches nach seiner Art. Und Gott sah, daß es gut war. ");
INSERT INTO deu1912_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Und Gott segnete sie und sprach: Seid fruchtbar und mehrt euch und erfüllt das Wasser im Meer; und das Gefieder mehre sich auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Da ward aus Abend und Morgen der fünfte Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Und Gott sprach: Die Erde bringe hervor lebendige Tiere, ein jegliches nach seiner Art: Vieh, Gewürm und Tiere auf Erden, ein jegliches nach seiner Art. Und es geschah also. ");
INSERT INTO deu1912_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Und Gott machte die Tiere auf Erden, ein jegliches nach seiner Art, und das Vieh nach seiner Art, und allerlei Gewürm auf Erden nach seiner Art. Und Gott sah, daß es gut war. ");
INSERT INTO deu1912_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Und Gott sprach: Laßt uns Menschen machen, ein Bild, das uns gleich sei, die da herrschen über die Fische im Meer und über die Vögel unter dem Himmel und über das Vieh und über die ganze Erde und über alles Gewürm, das auf Erden kriecht. ");
INSERT INTO deu1912_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Und Gott schuf den Menschen ihm zum Bilde, zum Bilde Gottes schuf er ihn; und schuf sie einen Mann und ein Weib. ");
INSERT INTO deu1912_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Und Gott segnete sie und sprach zu ihnen: Seid fruchtbar und mehrt euch und füllt die Erde und macht sie euch untertan und herrscht über die Fische im Meer und über die Vögel unter dem Himmel und über alles Getier, das auf Erden kriecht. ");
INSERT INTO deu1912_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Und Gott sprach: Seht da, ich habe euch gegeben allerlei Kraut, das sich besamt, auf der ganzen Erde und allerlei fruchtbare Bäume, die sich besamen, zu eurer Speise, ");
INSERT INTO deu1912_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","und allem Getier auf Erden und allen Vögeln unter dem Himmel und allem Gewürm, das da lebt auf Erden, daß sie allerlei grünes Kraut essen. Und es geschah also. ");
INSERT INTO deu1912_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Und Gott sah alles an, was er gemacht hatte; und siehe da, es war sehr gut. Da ward aus Abend und Morgen der sechste Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Also ward vollendet Himmel und Erde mit ihrem ganzen Heer. ");
INSERT INTO deu1912_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Und also vollendete Gott am siebenten Tage seine Werke, die er machte, und ruhte am siebenten Tage von allen seinen Werken, die er machte. ");
INSERT INTO deu1912_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Und Gott segnete den siebenten Tag und heiligte ihn, darum daß er an demselben geruht hatte von allen seinen Werken, die Gott schuf und machte. ");
INSERT INTO deu1912_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Also ist Himmel und Erde geworden, da sie geschaffen sind, zu der Zeit, da Gott der HERR Erde und Himmel machte. ");
INSERT INTO deu1912_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Und allerlei Bäume auf dem Felde waren noch nicht auf Erden, und allerlei Kraut auf dem Felde war noch nicht gewachsen; denn Gott der HERR hatte noch nicht regnen lassen auf Erden, und es war kein Mensch, der das Land baute. ");
INSERT INTO deu1912_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Aber ein Nebel ging auf von der Erde und feuchtete alles Land. ");
INSERT INTO deu1912_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Und Gott der HERR machte den Menschen aus einem Erdenkloß, uns blies ihm ein den lebendigen Odem in seine Nase. Und also ward der Mensch eine lebendige Seele. ");
INSERT INTO deu1912_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Und Gott der HERR pflanzte einen Garten in Eden gegen Morgen und setzte den Menschen hinein, den er gemacht hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Und Gott der HERR ließ aufwachsen aus der Erde allerlei Bäume, lustig anzusehen und gut zu essen, und den Baum des Lebens mitten im Garten und den Baum der Erkenntnis des Guten und Bösen. ");
INSERT INTO deu1912_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Und es ging aus von Eden ein Strom, zu wässern den Garten, und er teilte sich von da in vier Hauptwasser. ");
INSERT INTO deu1912_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Das erste heißt Pison, das fließt um das ganze Land Hevila; und daselbst findet man Gold. ");
INSERT INTO deu1912_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Und das Gold des Landes ist köstlich; und da findet man Bedellion und den Edelstein Onyx. ");
INSERT INTO deu1912_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Das andere Wasser heißt Gihon, das fließt um um das ganze Mohrenland. ");
INSERT INTO deu1912_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Das dritte Wasser heißt Hiddekel, das fließt vor Assyrien. Das vierte Wasser ist der Euphrat. ");
INSERT INTO deu1912_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Und Gott der HERR nahm den Menschen und setzte ihn in den Garten Eden, daß er ihn baute und bewahrte. ");
INSERT INTO deu1912_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Und Gott der HERR gebot dem Menschen und sprach: Du sollst essen von allerlei Bäumen im Garten; ");
INSERT INTO deu1912_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","aber von dem Baum der Erkenntnis des Guten und des Bösen sollst du nicht essen; denn welches Tages du davon ißt, wirst du des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Und Gott der HERR sprach: Es ist nicht gut, daß der Mensch allein sei; ich will ihm eine Gehilfin machen, die um ihn sei. ");
INSERT INTO deu1912_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Denn als Gott der HERR gemacht hatte von der Erde allerlei Tiere auf dem Felde und allerlei Vögel unter dem Himmel, brachte er sie zu dem Menschen, daß er sähe, wie er sie nennte; denn der wie Mensch allerlei lebendige Tiere nennen würde, so sollten sie heißen. ");
INSERT INTO deu1912_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Und der Mensch gab einem jeglichen Vieh und Vogel unter dem Himmel und Tier auf dem Felde seinen Namen; aber für den Menschen ward keine Gehilfin gefunden, die um ihn wäre. ");
INSERT INTO deu1912_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Da ließ Gott der HERR einen tiefen Schlaf fallen auf den Menschen, und er schlief ein. Und er nahm seiner Rippen eine und schloß die Stätte zu mit Fleisch. ");
INSERT INTO deu1912_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Und Gott der HERR baute ein Weib aus der Rippe, die er vom Menschen nahm, und brachte sie zu ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Da sprach der Mensch: Das ist doch Bein von meinem Bein und Fleisch von meinem Fleisch; man wird sie Männin heißen, darum daß sie vom Manne genommen ist. ");
INSERT INTO deu1912_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Darum wird ein Mann Vater und Mutter verlassen und an seinem Weibe hangen, und sie werden sein ein Fleisch. ");
INSERT INTO deu1912_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Und sie waren beide nackt, der Mensch und das Weib, und schämten sich nicht. ");
INSERT INTO deu1912_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Und die Schlange war listiger denn alle Tiere auf dem Felde, die Gott der HERR gemacht hatte, und sprach zu dem Weibe: Ja, sollte Gott gesagt haben: Ihr sollt nicht essen von den Früchten der Bäume im Garten? ");
INSERT INTO deu1912_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Da sprach das Weib zu der Schlange: Wir essen von den Früchten der Bäume im Garten; ");
INSERT INTO deu1912_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","aber von den Früchten des Baumes mitten im Garten hat Gott gesagt: Eßt nicht davon, rührt's auch nicht an, daß ihr nicht sterbt. ");
INSERT INTO deu1912_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Da sprach die Schlange zum Weibe: Ihr werdet mitnichten des Todes sterben; ");
INSERT INTO deu1912_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","sondern Gott weiß, daß, welches Tages ihr davon eßt, so werden eure Augen aufgetan, und werdet sein wie Gott und wissen, was gut und böse ist. ");
INSERT INTO deu1912_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Und das Weib schaute an, daß von dem Baum gut zu essen wäre und daß er lieblich anzusehen und ein lustiger Baum wäre, weil er klug machte; und sie nahm von der Frucht und aß und gab ihrem Mann auch davon, und er aß. ");
INSERT INTO deu1912_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Da wurden ihrer beiden Augen aufgetan, und sie wurden gewahr, daß sie nackt waren, und flochten Feigenblätter zusammen und machten sich Schürze. ");
INSERT INTO deu1912_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Und sie hörten die Stimme Gottes des HERRN, der im Garten ging, da der Tag kühl geworden war. Und Adam versteckte sich mit seinem Weibe vor dem Angesicht Gottes des HERRN unter die Bäume im Garten. ");
INSERT INTO deu1912_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Und Gott der HERR rief Adam und sprach zu ihm: Wo bist du? ");
INSERT INTO deu1912_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Und er sprach: Ich hörte deine Stimme im Garten und fürchtete mich; denn ich bin nackt, darum versteckte ich mich. ");
INSERT INTO deu1912_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Und er sprach: Wer hat dir's gesagt, daß du nackt bist? Hast du nicht gegessen von dem Baum, davon ich dir gebot, du solltest nicht davon essen? ");
INSERT INTO deu1912_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Da sprach Adam: Das Weib, das du mir zugesellt hast, gab mir von von dem Baum, und ich aß. ");
INSERT INTO deu1912_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Da sprach Gott der HERR zum Weibe: Warum hast du das getan? Das Weib sprach: Die Schlange betrog mich also, daß ich aß. ");
INSERT INTO deu1912_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Da sprach Gott der HERR zu der Schlange: Weil du solches getan hast, seist du verflucht vor allem Vieh und vor allen Tieren auf dem Felde. Auf deinem Bauche sollst du gehen und Erde essen dein Leben lang. ");
INSERT INTO deu1912_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Und ich will Feindschaft setzen zwischen dir und dem Weibe und zwischen deinem Samen und ihrem Samen. Derselbe soll dir den Kopf zertreten, und du wirst ihn in die Ferse stechen. ");
INSERT INTO deu1912_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Und zum Weibe sprach er: Ich will dir viel Schmerzen schaffen, wenn du schwanger wirst; du sollst mit Schmerzen Kinder gebären; und dein Verlangen soll nach deinem Manne sein, und er soll dein Herr sein. ");
INSERT INTO deu1912_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Und zu Adam sprach er: Dieweil du hast gehorcht der Stimme deines Weibes und hast gegessen von dem Baum, davon ich dir gebot und sprach: Du sollst nicht davon essen, verflucht sei der Acker um deinetwillen, mit Kummer sollst du dich darauf nähren dein Leben lang. ");
INSERT INTO deu1912_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Dornen und Disteln soll er dir tragen, und sollst das Kraut auf dem Felde essen. ");
INSERT INTO deu1912_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Im Schweiße deines Angesichts sollst du dein Brot essen, bis daß du wieder zu Erde werdest, davon du genommen bist. Denn du bist Erde und sollst zu Erde werden. ");
INSERT INTO deu1912_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Und Adam hieß sein Weib Eva, darum daß sie eine Mutter ist aller Lebendigen. ");
INSERT INTO deu1912_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Und Gott der HERR machte Adam und seinem Weibe Röcke von Fellen und kleidete sie. ");
INSERT INTO deu1912_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Und Gott der HERR sprach: Siehe, Adam ist geworden wie unsereiner und weiß, was gut und böse ist. Nun aber, daß er nicht ausstrecke seine Hand und breche auch von dem Baum des Lebens und esse und lebe ewiglich! ");
INSERT INTO deu1912_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Da wies ihn Gott der HERR aus dem Garten Eden, daß er das Feld baute, davon er genommen ist, ");
INSERT INTO deu1912_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","und trieb Adam aus und lagerte vor den Garten Eden die Cherubim mit dem bloßen, hauenden Schwert, zu bewahren den Weg zu dem Baum des Lebens. ");
INSERT INTO deu1912_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Und Adam erkannte sein Weib Eva, und sie ward schwanger und gebar den Kain und sprach: Ich habe einen Mann gewonnen mit dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Und sie fuhr fort und gebar Abel, seinen Bruder. Und Abel ward ein Schäfer; Kain aber ward ein Ackermann. ");
INSERT INTO deu1912_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Es begab sich nach etlicher Zeit, daß Kain dem HERRN Opfer brachte von den Früchten des Feldes; ");
INSERT INTO deu1912_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","und Abel brachte auch von den Erstlingen seiner Herde und von ihrem Fett. Und der HERR sah gnädig an Abel und sein Opfer; ");
INSERT INTO deu1912_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","aber Kain und sein Opfer sah er nicht gnädig an. Da ergrimmte Kain sehr, und seine Gebärde verstellte sich. ");
INSERT INTO deu1912_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Da sprach der HERR zu Kain: Warum ergrimmst du? und warum verstellt sich deine Gebärde? ");
INSERT INTO deu1912_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ist's nicht also? Wenn du fromm bist, so bist du angenehm; bist du aber nicht fromm, so ruht die Sünde vor der Tür, und nach dir hat sie Verlangen; du aber herrsche über sie. ");
INSERT INTO deu1912_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Da redete Kain mit seinem Bruder Abel. Und es begab sich, da sie auf dem Felde waren, erhob sich Kain wider seinen Bruder Abel und schlug ihn tot. ");
INSERT INTO deu1912_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Da sprach der HERR zu Kain: Wo ist dein Bruder Abel? Er sprach: Ich weiß nicht; soll ich meines Bruders Hüter sein? ");
INSERT INTO deu1912_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Er aber sprach: Was hast du getan? Die Stimme des Bluts deines Bruders schreit zu mir von der Erde. ");
INSERT INTO deu1912_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Und nun verflucht seist du auf der Erde, die ihr Maul hat aufgetan und deines Bruders Blut von deinen Händen empfangen. ");
INSERT INTO deu1912_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wenn du den Acker bauen wirst, soll er dir hinfort sein Vermögen nicht geben. Unstet und flüchtig sollst du sein auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain aber sprach zu dem HERRN: Meine Sünde ist größer, denn daß sie mir vergeben werden möge. ");
INSERT INTO deu1912_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Siehe, du treibst mich heute aus dem Lande, und ich muß mich vor deinem Angesicht verbergen und muß unstet und flüchtig sein auf Erden. So wird mir's gehen, daß mich totschlage, wer mich findet. ");
INSERT INTO deu1912_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Aber der HERR sprach zu ihm: Nein; sondern wer Kain totschlägt, das soll siebenfältig gerächt werden. Und der HERR machte ein Zeichen an Kain, daß ihn niemand erschlüge, wer ihn fände. ");
INSERT INTO deu1912_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Also ging Kain von dem Angesicht des HERRN und wohnte im Lande Nod, jenseit Eden, gegen Morgen. ");
INSERT INTO deu1912_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Und Kain erkannte sein Weib, die ward schwanger und gebar den Henoch. Und er baute eine Stadt, die nannte er nach seines Sohnes Namen Henoch. ");
INSERT INTO deu1912_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henoch aber zeugte Irad, Irad zeugte Mahujael, Mahujael zeugte Methusael, Methusael zeugte Lamech. ");
INSERT INTO deu1912_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech aber nahm zwei Weiber; eine hieß Ada, die andere Zilla. ");
INSERT INTO deu1912_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Und Ada gebar Jabal; von dem sind hergekommen, die in Hütten wohnten und Vieh zogen. ");
INSERT INTO deu1912_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Und sein Bruder hieß Jubal; von dem sind hergekommen die Geiger und Pfeifer. ");
INSERT INTO deu1912_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Die Zilla aber gebar auch, nämlich den Thubalkain, den Meister in allerlei Erz-und Eisenwerk. Und die Schwester des Thubalkain war Naema. ");
INSERT INTO deu1912_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Und Lamech sprach zu seinen Weibern Ada und Zilla: Ihr Weiber Lamechs, hört meine Rede und merkt, was ich sage: Ich habe einen Mann erschlagen für meine Wunde und einen Jüngling für meine Beule; ");
INSERT INTO deu1912_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kain soll siebenmal gerächt werden, aber Lamech siebenundsiebzigmal. ");
INSERT INTO deu1912_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam erkannte abermals sein Weib, und sie gebar einen Sohn, den hieß sie Seth; denn Gott hat mir, sprach sie, einen andern Samen gesetzt für Abel, den Kain erwürgt hat. ");
INSERT INTO deu1912_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Und Seth zeugte auch einen Sohn und hieß ihn Enos. Zu der Zeit fing man an, zu predigen von des HERRN Namen. ");
INSERT INTO deu1912_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dies ist das Buch von des Menschen Geschlecht. Da Gott den Menschen schuf, machte er ihn nach dem Bilde Gottes; ");
INSERT INTO deu1912_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","und schuf sie einen Mann und ein Weib und segnete sie und hieß ihren Namen Mensch zur Zeit, da sie geschaffen wurden. ");
INSERT INTO deu1912_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Und Adam war hundertunddreißig Jahre alt und zeugte einen Sohn, der seinem Bild ähnlich war und hieß ihn Seth ");
INSERT INTO deu1912_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","und lebte darnach achthundert Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","daß sein ganzes Alter ward neunhundertunddreißig Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth war hundertundfünf Jahre alt und zeugte Enos ");
INSERT INTO deu1912_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","und lebte darnach achthundertundsieben Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","daß sein ganzes Alter ward neunhundertundzwölf Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos war neunzig Jahre alt und zeugte Kenan ");
INSERT INTO deu1912_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","und lebte darnach achthundertundfünzig Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","daß sein ganzes Alter ward neunhundertundfünf Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan war siebzig Jahre alt und zeugte Mahalaleel ");
INSERT INTO deu1912_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","und lebte darnach achthundertundvierzig Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","daß sein ganzes Alter ward neunhundertundzehn Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel war fünfundsechzig Jahre und zeugte Jared ");
INSERT INTO deu1912_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","und lebte darnach achthundertunddreißig Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","daß sein ganzes Alter ward achthundert und fünfundneunzig Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared war hundertzweiundsechzig Jahre alt und zeugte Henoch ");
INSERT INTO deu1912_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","und er lebte darnach achthundert Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","daß sein ganzes Alter ward neunhundert und zweiundsechzig Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henoch war fünfundsechzig Jahre alt und zeugte Methusalah. ");
INSERT INTO deu1912_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Und nachdem er Methusalah gezeugt hatte, blieb er in einem göttlichen Leben dreihundert Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","daß sein ganzes Alter ward dreihundertfünfundsechzig Jahre. ");
INSERT INTO deu1912_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Und dieweil er ein göttliches Leben führte, nahm ihn Gott hinweg, und er ward nicht mehr gesehen. ");
INSERT INTO deu1912_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methusalah war hundertsiebenundachtzig Jahre alt und zeugte Lamech ");
INSERT INTO deu1912_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","und lebte darnach siebenhundert und zweiundachtzig Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","daß sein ganzes Alter ward neunhundert und neunundsechzig Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamech war hundertzweiundachtzig Jahre alt und zeugte einen Sohn ");
INSERT INTO deu1912_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","und hieß ihn Noah und sprach: Der wird uns trösten in unsrer Mühe und Arbeit auf der Erde, die der HERR verflucht hat. ");
INSERT INTO deu1912_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Darnach lebte er fünfhundert und fünfundneunzig Jahre und zeugte Söhne und Töchter; ");
INSERT INTO deu1912_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","daß sein ganzes Alter ward siebenhundert siebenundsiebzig Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah war fünfhundert Jahre alt und zeugte Sem, Ham und Japheth. ");
INSERT INTO deu1912_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Da sich aber die Menschen begannen zu mehren auf Erden und ihnen Töchter geboren wurden, ");
INSERT INTO deu1912_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","da sahen die Kinder Gottes nach den Töchtern der Menschen, wie sie schön waren, und nahmen zu Weibern, welche sie wollten. ");
INSERT INTO deu1912_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Da sprach der HERR: Die Menschen wollen sich von meinem Geist nicht mehr strafen lassen; denn sie sind Fleisch. Ich will ihnen noch Frist geben hundertundzwanzig Jahre. ");
INSERT INTO deu1912_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Es waren auch zu den Zeiten Tyrannen auf Erden; denn da die Kinder Gottes zu den Töchtern der Menschen eingingen und sie ihnen Kinder gebaren, wurden daraus Gewaltige in der Welt und berühmte Männer. ");
INSERT INTO deu1912_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Da aber der HERR sah, daß der Menschen Bosheit groß war auf Erden und alles Dichten und Trachten ihres Herzens nur böse war immerdar, ");
INSERT INTO deu1912_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","da reute es ihn, daß er die Menschen gemacht hatte auf Erden, und es bekümmerte ihn in seinem Herzen, ");
INSERT INTO deu1912_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","und er sprach: Ich will die Menschen, die ich gemacht habe, vertilgen von der Erde, vom Menschen an bis auf das Vieh und bis auf das Gewürm und bis auf die Vögel unter dem Himmel; denn es reut mich, daß ich sie gemacht habe. ");
INSERT INTO deu1912_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Aber Noah fand Gnade vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dies ist das Geschlecht Noahs. Noah war ein frommer Mann und ohne Tadel und führte ein göttliches Leben zu seinen Zeiten. ");
INSERT INTO deu1912_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","und zeugte drei Söhne Sem, Ham und Japheth. ");
INSERT INTO deu1912_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Aber die Erde war verderbt vor Gottes Augen und voll Frevels. ");
INSERT INTO deu1912_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Da sah Gott auf die Erde, und siehe, sie war verderbt; denn alles Fleisch hatte seinen Weg verderbt auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Da sprach Gott zu Noah: Alles Fleisches Ende ist vor mich gekommen; denn die Erde ist voll Frevels von ihnen; und siehe da, ich will sie verderben mit der Erde. ");
INSERT INTO deu1912_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Mache dir einen Kasten von Tannenholz und mache Kammern darin und verpiche ihn mit Pech inwendig und auswendig. ");
INSERT INTO deu1912_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Und mache ihn also: Dreihundert Ellen sei die Länge, fünfzig Ellen die Weite und dreißig Ellen die Höhe. ");
INSERT INTO deu1912_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ein Fenster sollst du daran machen obenan, eine Elle groß. Die Tür sollst du mitten in seine Seite setzen. Und er soll drei Boden haben: einen unten, den andern in der Mitte, den dritten in der Höhe. ");
INSERT INTO deu1912_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Denn siehe, ich will eine Sintflut mit Wasser kommen lassen auf Erden, zu verderben alles Fleisch, darin ein lebendiger Odem ist, unter dem Himmel. Alles, was auf Erden ist, soll untergehen. ");
INSERT INTO deu1912_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aber mit dir will ich einen Bund aufrichten; und du sollst in den Kasten gehen mit deinen Söhnen, mit deinem Weibe und mit deiner Söhne Weibern. ");
INSERT INTO deu1912_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Und du sollst in den Kasten tun allerlei Tiere von allem Fleisch, je ein Paar, Männlein und Weiblein, daß sie lebendig bleiben bei dir. ");
INSERT INTO deu1912_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Von den Vögeln nach ihrer Art, von dem Vieh nach seiner Art und von allerlei Gewürm auf Erden nach seiner Art: von den allen soll je ein Paar zu dir hineingehen, daß sie leben bleiben. ");
INSERT INTO deu1912_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Und du sollst allerlei Speise zu dir nehmen, die man ißt, und sollst sie bei dir sammeln, daß sie dir und ihnen zur Nahrung da sei. ");
INSERT INTO deu1912_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Und Noah tat alles, was ihm Gott gebot. ");
INSERT INTO deu1912_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Und der HERR sprach zu Noah: Gehe in den Kasten, du und dein ganzes Haus; denn ich habe dich gerecht ersehen vor mir zu dieser Zeit. ");
INSERT INTO deu1912_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Aus allerlei reinem Vieh nimm zu dir je sieben und sieben, das Männlein und sein Weiblein; von dem unreinen Vieh aber je ein Paar, das Männlein und sein Weiblein. ");
INSERT INTO deu1912_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Desgleichen von den Vögeln unter dem Himmel je sieben und sieben, das Männlein und sein Weiblein, auf daß Same lebendig bleibe auf dem ganzen Erdboden. ");
INSERT INTO deu1912_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Denn von nun an über sieben Tage will ich regnen lassen auf Erden vierzig Tage und vierzig Nächte und vertilgen von dem Erdboden alles, was Wesen hat, was ich gemacht habe. ");
INSERT INTO deu1912_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Und Noah tat alles, was ihm der HERR gebot. ");
INSERT INTO deu1912_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Er war aber sechshundert Jahre alt, da das Wasser der Sintflut auf Erden kam. ");
INSERT INTO deu1912_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Und er ging in den Kasten mit seinen Söhnen, seinem Weibe und seiner Söhne Weibern vor dem Gewässer der Sintflut. ");
INSERT INTO deu1912_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Von dem reinen Vieh und von dem unreinen, von den Vögeln und von allem Gewürm auf Erden ");
INSERT INTO deu1912_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","gingen zu ihm in den Kasten paarweise, je ein Männlein und Weiblein, wie ihm Gott geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Und da die sieben Tage vergangen waren, kam das Gewässer der Sintflut auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In dem sechshundertsten Jahr des Alters Noahs, am siebzehnten Tage des zweiten Monats, das ist der Tag, da aufbrachen alle Brunnen der großen Tiefe, und taten sich auf die Fenster des Himmels, ");
INSERT INTO deu1912_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","und kam ein Regen auf Erden vierzig Tage und vierzig Nächte. ");
INSERT INTO deu1912_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Eben am selben Tage ging Noah in den Kasten mit Sem, Ham und Japheth, seinen Söhnen, und mit seinem Weibe und seiner Söhne drei Weibern, ");
INSERT INTO deu1912_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","dazu allerlei Getier nach seiner Art, allerlei Vieh nach seiner Art, allerlei Gewürm, das auf Erden kriecht, nach seiner Art und allerlei Vögel nach ihrer Art, alles was fliegen konnte, alles, was Fittiche hatte; ");
INSERT INTO deu1912_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","das ging alles zu Noah in den Kasten paarweise, von allem Fleisch, darin ein lebendiger Geist war. ");
INSERT INTO deu1912_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Und das waren Männlein und Weiblein von allerlei Fleisch, und gingen hinein, wie denn Gott ihm geboten hatte. Und der HERR schloß hinter ihm zu. ");
INSERT INTO deu1912_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Da kam die Sintflut vierzig Tage auf Erden, und die Wasser wuchsen und hoben den Kasten auf und trugen ihn empor über die Erde. ");
INSERT INTO deu1912_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Also nahm das Gewässer überhand und wuchs sehr auf Erden, daß der Kasten auf dem Gewässer fuhr. ");
INSERT INTO deu1912_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Und das Gewässer nahm überhand und wuchs so sehr auf Erden, daß alle hohen Berge unter dem ganzen Himmel bedeckt wurden. ");
INSERT INTO deu1912_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Fünfzehn Ellen hoch ging das Gewässer über die Berge, die bedeckt wurden. ");
INSERT INTO deu1912_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Da ging alles Fleisch unter, das auf Erden kriecht, an Vögeln, an Vieh, an Tieren und an allem, was sich regt auf Erden, und alle Menschen. ");
INSERT INTO deu1912_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Alles, was einen lebendigen Odem hatte auf dem Trockenen, das starb. ");
INSERT INTO deu1912_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Also ward vertilgt alles, was auf dem Erdboden war, vom Menschen an bis auf das Vieh und das Gewürm und auf die Vögel unter dem Himmel; das ward alles von der Erde vertilgt. Allein Noah blieb übrig und was mit ihm in dem Kasten war. ");
INSERT INTO deu1912_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Und das Gewässer stand auf Erden hundertundfünfzig Tage. ");
INSERT INTO deu1912_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Da gedachte Gott an Noah und an alle Tiere und an alles Vieh, das mit ihm in dem Kasten war, und ließ Wind auf Erden kommen, und die Wasser fielen; ");
INSERT INTO deu1912_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","und die Brunnen der Tiefe wurden verstopft samt den Fenstern des Himmels, und dem Regen vom Himmel ward gewehrt; ");
INSERT INTO deu1912_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","und das Gewässer verlief sich von der Erde immer mehr und nahm ab nach hundertfünfzig Tagen. ");
INSERT INTO deu1912_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Am siebzehnten Tage des siebenten Monats ließ sich der Kasten nieder auf das Gebirge Ararat. ");
INSERT INTO deu1912_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Es nahm aber das Gewässer immer mehr ab bis auf den zehnten Monat. Am ersten Tage des zehnten Monats sahen der Berge Spitzen hervor. ");
INSERT INTO deu1912_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nach vierzig Tagen tat Noah das Fenster auf an dem Kasten, das er gemacht hatte, ");
INSERT INTO deu1912_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","und ließ einen Raben ausfliegen; der flog immer hin und wieder her, bis das Gewässer vertrocknete auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Darnach ließ er eine Taube von sich ausfliegen, auf daß er erführe, ob das Gewässer gefallen wäre auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Da aber die Taube nicht fand, da ihr Fuß ruhen konnte, kam sie wieder zu ihm in den Kasten; denn das Gewässer war noch auf dem ganzen Erdboden. Da tat er die Hand heraus und nahm sie zu sich in den Kasten. ");
INSERT INTO deu1912_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Da harrte er noch weitere sieben Tage und ließ abermals eine Taube fliegen aus dem Kasten. ");
INSERT INTO deu1912_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Die kam zu ihm zur Abendzeit, und siehe, ein Ölblatt hatte sie abgebrochen und trug's in ihrem Munde. Da merkte Noah, daß das Gewässer gefallen wäre auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Aber er harrte noch weiter sieben Tage und ließ eine Taube ausfliegen; die kam nicht wieder zu ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Im sechshundertundersten Jahr des Alters Noahs, am ersten Tage des ersten Monats vertrocknete das Gewässer auf Erden. Da tat Noah das Dach von dem Kasten und sah, daß der Erdboden trocken war. ");
INSERT INTO deu1912_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Also ward die Erde ganz trocken am siebenundzwanzigsten Tage des zweiten Monats. ");
INSERT INTO deu1912_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Da redete Gott mit Noah und sprach: ");
INSERT INTO deu1912_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Gehe aus dem Kasten, du und dein Weib, deine Söhne und deiner Söhne Weiber mit dir. ");
INSERT INTO deu1912_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Allerlei Getier, das bei dir ist, von allerlei Fleisch, an Vögeln, an Vieh und an allerlei Gewürm, das auf Erden kriecht, das gehe heraus mit dir, daß sie sich regen auf Erden und fruchtbar seien und sich mehren auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Also ging Noah heraus mit seinen Söhnen und seinem Weibe und seiner Söhne Weibern, ");
INSERT INTO deu1912_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","dazu allerlei Getier, allerlei Gewürm, allerlei Vögel und alles, was auf Erden kriecht; das ging aus dem Kasten, ein jegliches mit seinesgleichen. ");
INSERT INTO deu1912_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah aber baute dem HERRN einen Altar und nahm von allerlei reinem Vieh und von allerlei reinem Geflügel und opferte Brandopfer auf dem Altar. ");
INSERT INTO deu1912_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Und der HERR roch den lieblichen Geruch und sprach in seinem Herzen: Ich will hinfort nicht mehr die Erde verfluchen um der Menschen willen; denn das Dichten des menschlichen Herzens ist böse von Jugend auf. Und ich will hinfort nicht mehr schlagen alles, was da lebt, wie ich getan habe. ");
INSERT INTO deu1912_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Solange die Erde steht, soll nicht aufhören Saat und Ernte, Frost und Hitze, Sommer und Winter, Tag und Nacht. ");
INSERT INTO deu1912_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Und Gott segnete Noah und seine Söhne und sprach: Seid fruchtbar und mehrt euch und erfüllt die Erde. ");
INSERT INTO deu1912_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Furcht und Schrecken vor euch sei über alle Tiere auf Erden und über alle Vögel unter dem Himmel, über alles, was auf dem Erdboden kriecht, und über alle Fische im Meer; in eure Hände seien sie gegeben. ");
INSERT INTO deu1912_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Alles, was sich regt und lebt, das sei eure Speise; wie das grüne Kraut habe ich's euch alles gegeben. ");
INSERT INTO deu1912_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Allein eßt das Fleisch nicht, das noch lebt in seinem Blut. ");
INSERT INTO deu1912_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Auch will ich eures Leibes Blut rächen und will's an allen Tieren rächen und will des Menschen Leben rächen an einem jeglichen Menschen als dem, der sein Bruder ist. ");
INSERT INTO deu1912_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wer Menschenblut vergießt, des Blut soll auch durch Menschen vergossen werden; denn Gott hat den Menschen zu seinem Bilde gemacht. ");
INSERT INTO deu1912_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Seid fruchtbar und mehrt euch und regt euch auf Erden, daß euer viel darauf werden. ");
INSERT INTO deu1912_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Und Gott sagte zu Noah und seinen Söhnen mit ihm: ");
INSERT INTO deu1912_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Siehe, ich richte mit euch einen Bund auf und mit eurem Samen nach euch ");
INSERT INTO deu1912_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","und mit allem lebendigen Getier bei euch, an Vögeln, an Vieh und an allen Tieren auf Erden bei euch, von allem, was aus dem Kasten gegangen ist, was für Tiere es sind auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Und richte meinen Bund also mit euch auf, daß hinfort nicht mehr alles Fleisch verderbt werden soll mit dem Wasser der Sintflut, und soll hinfort keine Sintflut mehr kommen, die die Erde verderbe. ");
INSERT INTO deu1912_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Und Gott sprach: Das ist das Zeichen des Bundes, den ich gemacht habe zwischen mir und euch und allen lebendigen Seelen bei euch hinfort ewiglich: ");
INSERT INTO deu1912_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Meinen Bogen habe ich gesetzt in die Wolken; der soll das Zeichen sein des Bundes zwischen mir und der Erde. ");
INSERT INTO deu1912_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Und wenn es kommt, daß ich Wolken über die Erde führe, so soll man meinen Bogen sehen in den Wolken. ");
INSERT INTO deu1912_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Alsdann will ich gedenken an meinen Bund zwischen mir und euch und allen lebendigen Seelen in allerlei Fleisch, daß nicht mehr hinfort eine Sintflut komme, die alles Fleisch verderbe. ");
INSERT INTO deu1912_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Darum soll mein Bogen in den Wolken sein, daß ich ihn ansehe und gedenke an den ewigen Bund zwischen Gott und allen lebendigen Seelen in allem Fleisch, das auf Erden ist. ");
INSERT INTO deu1912_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Und Gott sagte zu Noah: Das sei das Zeichen des Bundes, den ich aufgerichtet habe zwischen mir und allem Fleisch auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Die Söhne Noahs, die aus dem Kasten gingen, sind diese: Sem, Ham und Japheth. Ham aber ist der Vater Kanaans. ");
INSERT INTO deu1912_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Das sind die drei Söhne Noahs, von denen ist alles Land besetzt. ");
INSERT INTO deu1912_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah aber fing an und ward ein Ackermann und pflanzte Weinberge. ");
INSERT INTO deu1912_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Und da er von dem Wein trank, ward er trunken und lag in der Hütte aufgedeckt. ");
INSERT INTO deu1912_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Da nun Ham, Kanaans Vater, sah seines Vaters Blöße, sagte er's seinen beiden Brüdern draußen. ");
INSERT INTO deu1912_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Da nahmen Sem und Japheth ein Kleid und legten es auf ihrer beider Schultern und gingen rücklings hinzu und deckten des Vaters Blöße zu; und ihr Angesicht war abgewandt, daß sie ihres Vater Blöße nicht sahen. ");
INSERT INTO deu1912_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Als nun Noah erwachte von seinem Wein und erfuhr, was ihm sein jüngster Sohn getan hatte, ");
INSERT INTO deu1912_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","sprach er: Verflucht sei Kanaan und sei ein Knecht aller Knechte unter seinen Brüdern! ");
INSERT INTO deu1912_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","und sprach weiter: Gelobt sei der HERR, der Gott Sem's; und Kanaan sei sein Knecht! ");
INSERT INTO deu1912_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Gott breite Japheth aus, und lasse ihn wohnen in den Hütten des Sem; und Kanaan sei sein Knecht! ");
INSERT INTO deu1912_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noah aber lebte nach der Sintflut dreihundertfünfzig Jahre, ");
INSERT INTO deu1912_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","daß sein ganzes Alter ward neunhundertundfünfzig Jahre, und starb. ");
INSERT INTO deu1912_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dies ist das Geschlecht der Kinder Noahs: Sem, Ham, Japheth. Und sie zeugten Kinder nach der Sintflut. ");
INSERT INTO deu1912_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Die Kinder Japheths sind diese: Gomer, Magog, Madai, Javan, Thubal, Mesech und Thiras. ");
INSERT INTO deu1912_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Aber die Kinder von Gomer sind diese: Askenas, Riphath und Thorgama. ");
INSERT INTO deu1912_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Die Kinder von Javan sind diese: Elisa, Tharsis, die Chittiter und die Dodaniter. ");
INSERT INTO deu1912_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Von diesen sind ausgebreitet die Inseln der Heiden in ihren Ländern, jegliche nach ihren Sprachen, Geschlechtern und Leuten. ");
INSERT INTO deu1912_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Die Kinder von Ham sind diese: Chus, Mizraim, Put und Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Aber die Kinder von Chus sind diese: Seba, Hevila, Sabtha, Ragma und Sabthecha. Aber die Kinder von Ragma sind diese: Saba und Dedan. ");
INSERT INTO deu1912_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Chus aber zeugte den Nimrod. Der fing an ein gewaltiger Herr zu sein auf Erden, ");
INSERT INTO deu1912_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","und war ein gewaltiger Jäger vor dem HERRN. Daher spricht man: Das ist ein gewaltiger Jäger vor dem HERRN wie Nimrod. ");
INSERT INTO deu1912_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Und der Anfang seines Reiches war Babel, Erech, Akkad und Chalne im Lande Sinear. ");
INSERT INTO deu1912_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Von dem Land ist er gekommen nach Assur und baute Ninive und Rehoboth-Ir und Kalah, ");
INSERT INTO deu1912_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","dazu Resen zwischen Ninive und Kalah. Dies ist die große Stadt. ");
INSERT INTO deu1912_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim zeugte die Luditer, die Anamiter, die Lehabiter, die Naphthuhiter, ");
INSERT INTO deu1912_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","die Pathrusiter und die Kasluhiter (von dannen sind gekommen die Philister) und die Kaphthoriter. ");
INSERT INTO deu1912_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan aber zeugte Sidon, seinen ersten Sohn, und Heth, ");
INSERT INTO deu1912_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","den Jebusiter, den Amoriter, den Girgasiter, ");
INSERT INTO deu1912_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","den Heviter, den Arkiter, den Siniter, ");
INSERT INTO deu1912_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","den Arvaditer, den Zemariter und den Hamathiter. Daher sind ausgebreitet die Geschlechter der Kanaaniter. ");
INSERT INTO deu1912_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Und ihre Grenzen waren von Sidon an durch Gerar bis gen Gaza, bis man kommt gen Sodom, Gomorra, Adama, Zeboim und bis gen Lasa. ");
INSERT INTO deu1912_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Das sind die Kinder Hams in ihren Geschlechtern, Sprachen und Leuten. ");
INSERT INTO deu1912_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem aber, Japheths, des Ältern, Bruder, zeugte auch Kinder, der ein Vater ist aller Kinder von Eber. ");
INSERT INTO deu1912_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Und dies sind seine Kinder: Elam, Assur, Arphachsad, Lud und Aram. ");
INSERT INTO deu1912_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Die Kinder von Aram sind diese: Uz, Hul, Gether und Mas. ");
INSERT INTO deu1912_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphachsad aber zeugte Salah, Salah zeugte Eber. ");
INSERT INTO deu1912_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber zeugte zwei Söhne. Einer hieß Peleg, darum daß zu seiner Zeit die Welt zerteilt ward; des Bruder hieß Joktan. ");
INSERT INTO deu1912_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Und Joktan zeugte Almodad, Saleph, Hazarmaveth, Jarah, ");
INSERT INTO deu1912_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO deu1912_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Saba, ");
INSERT INTO deu1912_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Hevila und Jobab. Das sind die Kinder von Joktan. ");
INSERT INTO deu1912_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Und ihre Wohnung war von Mesa an, bis man kommt gen Sephar, an den Berg gegen Morgen. ");
INSERT INTO deu1912_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Das sind die Kinder von Sem in ihren Geschlechtern, Sprachen, Ländern und Leuten. ");
INSERT INTO deu1912_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Das sind die Nachkommen der Kinder Noahs in ihren Geschlechtern und Leuten. Von denen sind ausgebreitet die Leute auf Erden nach der Sintflut. ");
INSERT INTO deu1912_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Es hatte aber alle Welt einerlei Zunge und Sprache. ");
INSERT INTO deu1912_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Da sie nun zogen gen Morgen, fanden sie ein ebenes Land im Lande Sinear, und wohnten daselbst. ");
INSERT INTO deu1912_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Und sie sprachen untereinander: Wohlauf, laß uns Ziegel streichen und brennen! und nahmen Ziegel zu Stein und Erdharz zu Kalk ");
INSERT INTO deu1912_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","und sprachen: Wohlauf, laßt uns eine Stadt und einen Turm bauen, des Spitze bis an den Himmel reiche, daß wir uns einen Namen machen! denn wir werden sonst zerstreut in alle Länder. ");
INSERT INTO deu1912_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Da fuhr der HERR hernieder, daß er sähe die Stadt und den Turm, die die Menschenkinder bauten. ");
INSERT INTO deu1912_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Und der HERR sprach: Siehe, es ist einerlei Volk und einerlei Sprache unter ihnen allen, und haben das angefangen zu tun; sie werden nicht ablassen von allem, was sie sich vorgenommen haben zu tun. ");
INSERT INTO deu1912_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wohlauf, laßt uns herniederfahren und ihre Sprache daselbst verwirren, daß keiner des andern Sprache verstehe! ");
INSERT INTO deu1912_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Also zerstreute sie der HERR von dort alle Länder, daß sie mußten aufhören die Stadt zu bauen. ");
INSERT INTO deu1912_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Daher heißt ihr Name Babel, daß der HERR daselbst verwirrt hatte aller Länder Sprache und sie zerstreut von dort in alle Länder. ");
INSERT INTO deu1912_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dies sind die Geschlechter Sems: Sem war hundert Jahre alt und zeugte Arphachsad, zwei Jahre nach der Sintflut, ");
INSERT INTO deu1912_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","und lebte darnach fünfhundert Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1912_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arphachsad war fünfunddreißig Jahre alt und zeugte Salah ");
INSERT INTO deu1912_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","und lebte darnach vierhundertunddrei Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1912_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Salah war dreißig Jahre alt und zeugte Eber ");
INSERT INTO deu1912_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","und lebte darnach vierhundertunddrei Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1912_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber war vierunddreißig Jahre alt und zeugte Peleg ");
INSERT INTO deu1912_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","und lebte darnach vierhundertunddreißig Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1912_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg war dreißig Jahre alt und zeugte Regu ");
INSERT INTO deu1912_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","und lebte darnach zweihundertundneun Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1912_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Regu war zweiundreißig Jahre alt und zeugte Serug ");
INSERT INTO deu1912_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","und lebte darnach zweihundertundsieben Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1912_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug war dreißig Jahre alt und zeugte Nahor ");
INSERT INTO deu1912_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","und lebte darnach zweihundert Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1912_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor war neunundzwanzig Jahre alt und zeugte Tharah ");
INSERT INTO deu1912_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","und lebte darnach hundertundneunzehn Jahre und zeugte Söhne und Töchter. ");
INSERT INTO deu1912_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tharah war siebzig Jahre alt und zeugte Abram, Nahor und Haran. ");
INSERT INTO deu1912_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Dies sind die Geschlechter Tharahs: Tharah zeugte Abram, Nahor und Haran. Aber Haran zeugte Lot. ");
INSERT INTO deu1912_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran aber starb vor seinem Vater Tharah in seinem Vaterlande zu Ur in Chaldäa. ");
INSERT INTO deu1912_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Da nahmen Abram und Nahor Weiber. Abrams Weib hieß Sarai, und Nahors Weib Milka, Harans Tochter, der ein Vater war der Milka und der Jiska. ");
INSERT INTO deu1912_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Aber Sarai war unfruchtbar und hatte kein Kind. ");
INSERT INTO deu1912_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Da nahm Tharah seinen Sohn Abram und Lot, seines Sohnes Harans Sohn, und seine Schwiegertochter Sarai, seines Sohnes Abrams Weib, und führte sie aus Ur in Chaldäa, daß er ins Land Kanaan zöge; und sie kamen gen Haran und wohnten daselbst. ");
INSERT INTO deu1912_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Und Tharah war zweihundertundfünf Jahre alt und starb in Haran. ");
INSERT INTO deu1912_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Und der HERR sprach zu Abram: Gehe aus deinem Vaterlande und von deiner Freundschaft und aus deines Vaters Hause in ein Land, das ich dir zeigen will. ");
INSERT INTO deu1912_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Und ich will dich zum großen Volk machen und will dich segnen und dir einen großen Namen machen, und sollst ein Segen sein. ");
INSERT INTO deu1912_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ich will segnen, die dich segnen, und verfluchen, die dich verfluchen; und in dir sollen gesegnet werden alle Geschlechter auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Da zog Abram aus, wie der HERR zu ihm gesagt hatte, und Lot zog mit ihm. Abram aber ward fünfundsiebzig Jahre alt, da er aus Haran zog. ");
INSERT INTO deu1912_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Also nahm Abram sein Weib Sarai und Lot, seines Bruders Sohn, mit aller ihrer Habe, die sie gewonnen hatten, und die Seelen, die sie erworben hatten in Haran; und zogen aus, zu reisen in das Land Kanaan. Und als sie gekommen waren in dasselbe Land, ");
INSERT INTO deu1912_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","zog Abram durch bis an die Stätte Sichem und an den Hain More; es wohnten aber zu der Zeit die Kanaaniter im Lande. ");
INSERT INTO deu1912_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Da erschien der HERR dem Abram und sprach: Deinem Samen will ich dies Land geben. Und er baute daselbst einen Altar dem HERRN, der ihm erschienen war. ");
INSERT INTO deu1912_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Darnach brach er auf von dort an einen Berg, der lag gegen Morgen von der Stadt Beth-El, und richtete seine Hütte auf, daß er Beth-El gegen Abend und Ai gegen Morgen hatte, und baute daselbst dem HERRN einen Altar und predigte von dem Namen des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Darnach zog Abram weiter und zog aus ins Mittagsland. ");
INSERT INTO deu1912_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Es kam aber eine Teuerung in das Land. Da zog Abram hinab nach Ägypten, daß er sich daselbst als ein Fremdling aufhielte; denn die Teuerung war groß im Lande. ");
INSERT INTO deu1912_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Und da er nahe an Ägypten kam, sprach er zu seinem Weib Sarai: Siehe, ich weiß, daß du ein schönes Weib von Angesicht bist. ");
INSERT INTO deu1912_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wenn dich nun die Ägypter sehen werden, so werden sie sagen: Das ist sein Weib, und werden mich erwürgen, und dich leben lassen. ");
INSERT INTO deu1912_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sage doch, du seist meine Schwester, auf daß mir's wohl gehe um deinetwillen und meine Seele am Leben bleibe um deinetwillen. ");
INSERT INTO deu1912_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Als nun Abram nach Ägypten kam, sahen die Ägypter das Weib, daß sie sehr schön war. ");
INSERT INTO deu1912_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Und die Fürsten des Pharao sahen sie und priesen sie vor ihm. Da ward sie in des Pharao Haus gebracht. ");
INSERT INTO deu1912_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Und er tat Abram Gutes um ihretwillen. Und er hatte Schafe, Rinder, Esel, Knechte und Mägde, Eselinnen und Kamele. ");
INSERT INTO deu1912_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Aber der HERR plagte den Pharao mit großen Plagen und sein Haus um Sarais, Abrams Weibes, willen. ");
INSERT INTO deu1912_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Da rief Pharao Abram zu sich und sprach zu ihm: Warum hast du mir das getan? Warum sagtest du mir's nicht, daß sie dein Weib wäre? ");
INSERT INTO deu1912_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Warum sprachst du denn, sie wäre deine Schwester? Derhalben ich sie mir zum Weibe nehmen wollte. Und nun siehe, da hast du dein Weib; nimm sie und ziehe hin. ");
INSERT INTO deu1912_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Und Pharao befahl seinen Leuten über ihm, daß sie ihn geleiteten und sein Weib und alles, was er hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Also zog Abram herauf aus Ägypten mit seinem Weibe und mit allem, was er hatte, und Lot auch mit ihm, ins Mittagsland. ");
INSERT INTO deu1912_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram aber war sehr reich an Vieh, Silber und Gold. ");
INSERT INTO deu1912_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Und er zog immer fort von Mittag bis gen Beth-El, an die Stätte, da am ersten seine Hütte war, zwischen Beth-El und Ai, ");
INSERT INTO deu1912_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","eben an den Ort, da er zuvor den Altar gemacht hatte. Und er predigte allda den Namen des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot aber, der mit Abram zog, der hatte auch Schafe und Rinder und Hütten. ");
INSERT INTO deu1912_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Und das Land konnte es nicht ertragen, daß sie beieinander wohnten; denn ihre Habe war groß, und konnten nicht beieinander wohnen. ");
INSERT INTO deu1912_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Und es war immer Zank zwischen den Hirten über Abrams Vieh und zwischen den Hirten über Lots Vieh. So wohnten auch zu der Zeit die Kanaaniter und Pheresiter im Lande. ");
INSERT INTO deu1912_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Da sprach Abram zu Lot: Laß doch nicht Zank sein zwischen mir und dir und zwischen meinen und deinen Hirten; denn wir sind Gebrüder. ");
INSERT INTO deu1912_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Steht dir nicht alles Land offen? Scheide dich doch von mir. Willst du zur Linken, so will ich zur Rechten; oder willst du zur Rechten, so will ich zur Linken. ");
INSERT INTO deu1912_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Da hob Lot sein Augen auf und besah die ganze Gegend am Jordan. Denn ehe der HERR Sodom und Gomorra verderbte, war sie wasserreich, bis man gen Zoar kommt, als ein Garten des HERRN, gleichwie Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Da erwählte sich Lot die ganze Gegend am Jordan und zog gegen Morgen. Also schied sich ein Bruder von dem andern, ");
INSERT INTO deu1912_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","daß Abram wohnte im Lande Kanaan und Lot in den Städten der Jordangegend und setzte seine Hütte gen Sodom. ");
INSERT INTO deu1912_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Aber die Leute zu Sodom waren böse und sündigten sehr wider den HERRN. ");
INSERT INTO deu1912_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Da nun Lot sich von Abram geschieden hatte, sprach der HERR zu Abram: Hebe dein Augen auf und siehe von der Stätte an, da du wohnst, gegen Mittag, gegen Morgen und gegen Abend. ");
INSERT INTO deu1912_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Denn alles Land, das du siehst, will ich dir geben und deinem Samen ewiglich; ");
INSERT INTO deu1912_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","und ich will deinen Samen machen wie den Staub auf Erden. Kann ein Mensch den Staub auf Erden zählen, der wird auch deinen Samen zählen. ");
INSERT INTO deu1912_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Darum so mache dich auf und ziehe durch das Land in die Länge und Breite; denn dir will ich's geben. ");
INSERT INTO deu1912_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Also erhob Abram sein Hütte, kam und wohnte im Hain Mamre, der zu Hebron ist, und baute daselbst dem HERRN einen Altar. ");
INSERT INTO deu1912_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Und es begab sich zu der Zeit des Königs Amraphel von Sinear, Ariochs, des Königs von Ellasar, Kedor-Laomors, des Königs von Elam, und Thideals, des Königs der Heiden, ");
INSERT INTO deu1912_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","daß sie kriegten mit Bera, dem König von Sodom, und mit Birsa, dem König von Gomorra, und mit Sineab, dem König von Adama, und mit Semeber, dem König von Zeboim, und mit dem König von Bela, das Zoar heißt. ");
INSERT INTO deu1912_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Diese kamen alle zusammen in das Tal Siddim, wo nun das Salzmeer ist. ");
INSERT INTO deu1912_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Denn sie waren zwölf Jahre unter dem König Kedor-Laomor gewesen, und im dreizehnten Jahr waren sie von ihm abgefallen. ");
INSERT INTO deu1912_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Darum kam Kedor-Laomor und die Könige, die mit ihm waren, im vierzehnten Jahr und schlugen die Riesen zu Astharoth-Karnaim und die Susiter zu Ham und die Emiter in dem Felde Kirjathaim ");
INSERT INTO deu1912_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","und die Horiter auf dem Gebirge Seir, bis El-Pharan, welches an die Wüste stößt. ");
INSERT INTO deu1912_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Darnach wandten sie um und kamen an den Born Mispat, das ist Kades, und schlugen das ganze Land der Amalekiter, dazu die Amoriter, die zu Hazezon-Thamar wohnten. ");
INSERT INTO deu1912_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Da zogen aus der König von Sodom, der König von Gomorra, der König von Adama, der König von Zeboim und der König von Bela, das Zoar heißt, und rüsteten sich, zu streiten im Tal Siddim ");
INSERT INTO deu1912_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mit Kedor-Laomor, dem König von Elam, und mit Thideal, dem König der Heiden, und mit Amraphel, dem König von Sinear, und mit Arioch, dem König von Ellasar: vier Könige mit fünfen. ");
INSERT INTO deu1912_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Das Tal Siddim aber hatte viel Erdharzgruben; und die Könige von Sodom und Gomorra wurden in die Flucht geschlagen und fielen da hinein, und was übrig blieb, floh auf das Gebirge. ");
INSERT INTO deu1912_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Da nahmen sie alle Habe zu Sodom und Gomorra und alle Speise und zogen davon. ");
INSERT INTO deu1912_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Sie nahmen auch mit sich Lot, Abrams Bruderssohn, und seine Habe, denn er wohnte zu Sodom, und zogen davon. ");
INSERT INTO deu1912_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Da kam einer, der entronnen war, und sagte es Abram an, dem Ausländer, der da wohnte im Hain Mamres, des Amoriters, welcher ein Bruder war Eskols und Aners. Diese waren mit Abram im Bunde. ");
INSERT INTO deu1912_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Als nun Abram hörte, daß sein Bruder gefangen war, wappnete er seine Knechte, dreihundertundachtzehn, in seinem Hause geboren, und jagte ihnen nach bis gen Dan ");
INSERT INTO deu1912_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","und teilte sich, fiel des Nachts über sie mit seinen Knechten und schlug sie und jagte sie bis gen Hoba, das zur Linken der Stadt Damaskus liegt, ");
INSERT INTO deu1912_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","und brachte alle Habe wieder, dazu auch Lot, seinen Bruder, mit seiner Habe, auch die Weiber und das Volk. ");
INSERT INTO deu1912_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Als er nun wiederkam von der Schlacht des Kedor-Laomor und der Könige mit ihm, ging ihm entgegen der König von Sodom in das Feld, das Königstal heißt. ");
INSERT INTO deu1912_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Aber Melchisedek, der König von Salem, trug Brot und Wein hervor. Und er war ein Priester Gottes des Höchsten. ");
INSERT INTO deu1912_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Und segnete ihn und sprach: Gesegnet seist du, Abram, dem höchsten Gott, der Himmel und Erde geschaffen hat; ");
INSERT INTO deu1912_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","und gelobt sei Gott der Höchste, der deine Feinde in deine Hand beschlossen hat. Und demselben gab Abram den Zehnten von allem. ");
INSERT INTO deu1912_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Da sprach der König von Sodom zu Abram: Gib mir die Leute; die Güter behalte dir. ");
INSERT INTO deu1912_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Aber Abram sprach zu dem König von Sodom: Ich hebe mein Hände auf zu dem HERRN, dem höchsten Gott, der Himmel und Erde geschaffen hat, ");
INSERT INTO deu1912_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","daß ich von allem, was dein ist, nicht einen Faden noch einen Schuhriemen nehmen will, daß du nicht sagst, du hast Abram reich gemacht; ");
INSERT INTO deu1912_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ausgenommen, was die Jünglinge verzehrt haben; und die Männer Aner, Eskol und Mamre, die mit mir gezogen sind, die laß ihr Teil nehmen. ");
INSERT INTO deu1912_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nach diesen Geschichten begab sich's, daß zu Abram geschah das Wort des HERRN im Gesicht und sprach: Fürchte dich nicht Abram! Ich bin dein Schild und dein sehr großer Lohn. ");
INSERT INTO deu1912_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram sprach aber: Herr HERR, was willst du mir geben? Ich gehe dahin ohne Kinder; und dieser Elieser von Damaskus wird mein Haus besitzen. ");
INSERT INTO deu1912_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Und Abram sprach weiter: Mir hast du keinen Samen gegeben; und siehe, einer von meinem Gesinde soll mein Erbe sein. ");
INSERT INTO deu1912_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Und siehe, der HERR sprach zu ihm: Er soll nicht dein Erbe sein; sondern der von deinem Leib kommen wird, der soll dein Erbe sein. ");
INSERT INTO deu1912_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Und er hieß ihn hinausgehen und sprach: Siehe gen Himmel und zähle die Sterne; kannst du sie zählen? und sprach zu ihm: Also soll dein Same werden. ");
INSERT INTO deu1912_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram glaubte dem HERRN, und das rechnete er ihm zur Gerechtigkeit. ");
INSERT INTO deu1912_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Und er sprach zu ihm: Ich bin der HERR, der dich von Ur in Chaldäa ausgeführt hat, daß ich dir dies Land zu besitzen gebe. ");
INSERT INTO deu1912_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram aber sprach: Herr HERR, woran soll ich merken, daß ich's besitzen werde? ");
INSERT INTO deu1912_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Und er sprach zu ihm: Bringe mir eine dreijährige Kuh und eine dreijährige Ziege und einen dreijährigen Widder und eine Turteltaube und eine junge Taube. ");
INSERT INTO deu1912_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Und er brachte ihm solches alles und zerteilte es mitten voneinander und legte einen Teil dem andern gegenüber; aber die Vögel zerteilte er nicht. ");
INSERT INTO deu1912_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Und die Raubvögel fielen auf die Aase; aber Abram scheuchte sie davon. ");
INSERT INTO deu1912_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Da nun die Sonne am Untergehen war, fiel ein tiefer Schlaf auf Abram; und siehe, Schrecken und große Finsternis überfiel ihn. ");
INSERT INTO deu1912_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Da sprach er zu Abram: Das sollst du wissen, daß dein Same wird fremd sein in einem Lande, das nicht sein ist; und da wird man sie zu dienen zwingen und plagen vierhundert Jahre. ");
INSERT INTO deu1912_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Aber ich will richten das Volk, dem sie dienen müssen. Darnach sollen sie ausziehen mit großem Gut. ");
INSERT INTO deu1912_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Und du sollst fahren zu deinen Vätern mit Frieden und in gutem Alter begraben werden. ");
INSERT INTO deu1912_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Sie aber sollen nach vier Mannesaltern wieder hierher kommen; denn die Missetat der Amoriter ist noch nicht voll. ");
INSERT INTO deu1912_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Als nun die Sonne untergegangen und es finster geworden war, siehe, da rauchte ein Ofen, und ein Feuerflamme fuhr zwischen den Stücken hin. ");
INSERT INTO deu1912_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","An dem Tage machte der HERR einen Bund mit Abram und sprach: Deinem Samen will ich dies Land geben, von dem Wasser Ägyptens an bis an das große Wasser Euphrat: ");
INSERT INTO deu1912_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","die Keniter, die Kenisiter, die Kadmoniter, ");
INSERT INTO deu1912_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","die Hethiter, die Pheresiter, die Riesen, ");
INSERT INTO deu1912_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","die Amoriter, die Kanaaniter, die Girgasiter, die Jebusiter. ");
INSERT INTO deu1912_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, Abrams Weib, gebar ihm kein Kind. Sie hatte eine ägyptische Magd, die hieß Hagar. ");
INSERT INTO deu1912_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Und sie sprach zu Abram: Siehe, der HERR hat mich verschlossen, daß ich nicht gebären kann. Gehe doch zu meiner Magd, ob ich vielleicht aus ihr mich aufbauen möge. Und Abram gehorchte der Stimme Sarais. ");
INSERT INTO deu1912_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Da nahm Sarai, Abrams Weib, ihre ägyptische Magd, Hagar, und gab sie Abram, ihrem Mann, zum Weibe, nachdem sie zehn Jahre im Lande Kanaan gewohnt hatten. ");
INSERT INTO deu1912_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Und er ging zu Hagar, die ward schwanger. Als sie nun sah, daß sie schwanger war, achtete sie ihre Frau gering gegen sich. ");
INSERT INTO deu1912_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Da sprach Sarai zu Abram: Du tust unrecht an mir. Ich habe meine Magd dir in die Arme gegeben; nun sie aber sieht, daß sie schwanger geworden ist, muß ich gering sein in ihren Augen. Der HERR sei Richter zwischen mir und dir. ");
INSERT INTO deu1912_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram aber sprach zu Sarai: Siehe, deine Magd ist unter deiner Gewalt; tue mit ihr, wie dir's gefällt. Da sie nun Sarai wollte demütigen, floh sie von ihr. ");
INSERT INTO deu1912_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Aber der Engel des HERRN fand sie bei einem Wasserbrunnen in der Wüste, nämlich bei dem Brunnen am Wege gen Sur. ");
INSERT INTO deu1912_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Der sprach zu ihr: Hagar, Sarais Magd, wo kommst du her, und wo willst du hin? Sie sprach: Ich bin von meiner Frau Sarai geflohen. ");
INSERT INTO deu1912_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Und der Engel des HERRN sprach zu ihr: Kehre wieder um zu deiner Frau, und demütige dich unter ihre Hand. ");
INSERT INTO deu1912_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Und der Engel des HERRN sprach zu ihr: Ich will deinen Samen also mehren, daß er vor großer Menge nicht soll gezählt werden. ");
INSERT INTO deu1912_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Weiter sprach der Engel des HERRN zu ihr: Siehe, du bist schwanger geworden und wirst einen Sohn gebären, des namen sollst du Ismael heißen, darum daß der HERR dein Elend erhört hat. ");
INSERT INTO deu1912_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Er wird ein wilder Mensch sein: seine Hand wider jedermann und jedermanns Hand wider ihn, und wird gegen alle seine Brüder wohnen. ");
INSERT INTO deu1912_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Und sie hieß den Namen des HERRN, der mit ihr redete: Du Gott siehst mich. Denn sie sprach: Gewiß habe ich hier gesehen den, der mich hernach angesehen hat. ");
INSERT INTO deu1912_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Darum hieß man den Brunnen einen Brunnen des Lebendigen, der mich ansieht; welcher Brunnen ist zwischen Kades und Bared. ");
INSERT INTO deu1912_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Und Hagar gebar einen Sohn; und Abram hieß den Sohn, den ihm Hagar gebar, Ismael. ");
INSERT INTO deu1912_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Und Abram war sechsundachtzig Jahre alt, da ihm Hagar den Ismael gebar. ");
INSERT INTO deu1912_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Als nun Abram neunundneunzig Jahre alt war, erschien ihm der HERR und sprach zu ihm: Ich bin der allmächtige Gott; wandle vor mir und sei fromm. ");
INSERT INTO deu1912_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Und ich will meinen Bund zwischen mir und dir machen und ich will dich gar sehr mehren. ");
INSERT INTO deu1912_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Da fiel Abram auf sein Angesicht. Und Gott redete weiter mit ihm und sprach: ");
INSERT INTO deu1912_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Siehe, ich bin's und habe meinen Bund mit dir, und du sollst ein Vater vieler Völker werden. ");
INSERT INTO deu1912_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Darum sollst du nicht mehr Abram heißen, sondern Abraham soll dein Name sein; denn ich habe dich gemacht zum Vater vieler Völker ");
INSERT INTO deu1912_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","und will dich gar sehr fruchtbar machen und will von dir Völker machen, und sollen auch Könige von dir kommen. ");
INSERT INTO deu1912_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Und ich will aufrichten meinen Bund zwischen mir und dir und deinem Samen nach dir, bei ihren Nachkommen, daß es ein ewiger Bund sei, also daß ich dein Gott sei und deines Samens nach dir, ");
INSERT INTO deu1912_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","und ich will dir und deinem Samen nach dir geben das Land, darin du ein Fremdling bist, das ganze Land Kanaan, zu ewiger Besitzung, und will ihr Gott sein. ");
INSERT INTO deu1912_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Und Gott sprach zu Abraham: So halte nun meinen Bund, du und dein Same nach dir, bei ihren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Das ist aber mein Bund, den ihr halten sollt zwischen mir und euch und deinem Samen nach dir: Alles, was männlich ist unter euch, soll beschnitten werden. ");
INSERT INTO deu1912_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ihr sollt aber die Vorhaut an eurem Fleisch beschneiden. Das soll ein Zeichen sein des Bundes zwischen mir und euch. ");
INSERT INTO deu1912_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ein jegliches Knäblein, wenn's acht Tage alt ist, sollt ihr beschneiden bei euren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Beschnitten werden soll alles Gesinde, das dir daheim geboren oder erkauft ist. Und also soll mein Bund an eurem Fleisch sein zum ewigen Bund. ");
INSERT INTO deu1912_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Und wo ein Mannsbild nicht wird beschnitten an der Vorhaut seines Fleisches, des Seele soll ausgerottet werden aus seinem Volk, darum daß es meinen Bund unterlassen hat. ");
INSERT INTO deu1912_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Und Gott sprach abermals zu Abraham: Du sollst dein Weib Sarai nicht mehr Sarai heißen, sondern Sara soll ihr Name sein. ");
INSERT INTO deu1912_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Denn ich will sie segnen, und auch von ihr will ich dir einen Sohn geben; denn ich will sie segnen, und Völker sollen aus ihr werden und Könige über viele Völker. ");
INSERT INTO deu1912_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Da fiel Abraham auf sein Angesicht und lachte, und sprach in seinem Herzen: Soll mir, hundert Jahre alt, ein Kind geboren werden, und Sara, neunzig Jahre alt, gebären? ");
INSERT INTO deu1912_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Und Abraham sprach zu Gott: Ach, daß Ismael leben sollte vor dir! ");
INSERT INTO deu1912_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Da sprach Gott: Ja, Sara, dein Weib, soll dir einen Sohn gebären, den sollst du Isaak heißen; denn mit ihm will ich meinen ewigen Bund aufrichten und mit seinem Samen nach ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Dazu um Ismael habe ich dich auch erhört. Siehe, ich habe ihn gesegnet und will ihn fruchtbar machen und mehren gar sehr. Zwölf Fürsten wird er zeugen, und ich will ihn zum großen Volk machen. ");
INSERT INTO deu1912_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Aber meinen Bund will ich aufrichten mit Isaak, den dir Sara gebären soll um diese Zeit im andern Jahr. ");
INSERT INTO deu1912_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Und er hörte auf, mit ihm zu reden. Und Gott fuhr auf von Abraham. ");
INSERT INTO deu1912_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Da nahm Abraham seinen Sohn Ismael und alle Knechte, die daheim geboren, und alle, die erkauft, und alles, was männlich war in seinem Hause, und beschnitt die Vorhaut an ihrem Fleisch ebendesselben Tages, wie ihm Gott gesagt hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Und Abraham war neunundneunzig Jahre alt, da er die Vorhaut an seinem Fleisch beschnitt. ");
INSERT INTO deu1912_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismael aber, sein Sohn, war dreizehn Jahre alt, da seines Fleisches Vorhaut beschnitten ward. ");
INSERT INTO deu1912_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Eben auf einen Tag wurden sie alle beschnitten, Abraham, sein Sohn Ismael, ");
INSERT INTO deu1912_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","und was männlich in seinem Hause war, daheim geboren und erkauft von Fremden; es ward alles mit ihm beschnitten. ");
INSERT INTO deu1912_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Und der HERR erschien ihm im Hain Mamre, da saß er an der Tür seiner Hütte, da der Tag am heißesten war. ");
INSERT INTO deu1912_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Und als er seine Augen aufhob und sah, siehe, da standen drei Männer vor ihm. Und da er sie sah, lief er ihnen entgegen von der Tür seiner Hütte und bückte sich nieder zur Erde ");
INSERT INTO deu1912_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","und sprach: Herr, habe ich Gnade gefunden vor deinen Augen, so gehe nicht an deinem Knecht vorüber. ");
INSERT INTO deu1912_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Man soll euch ein wenig Wasser bringen und eure Füße waschen, und lehnt euch unter den Baum. ");
INSERT INTO deu1912_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Und ich will einen Bissen Brot bringen, daß ihr euer Herz labt; darnach sollt ihr fortgehen. Denn darum seid ihr zu eurem Knecht gekommen. Sie sprachen: Tue wie du gesagt hast. ");
INSERT INTO deu1912_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham eilte in die Hütte zu Sara und sprach: Eile und menge drei Maß Semmelmehl, knete und backe Kuchen. ");
INSERT INTO deu1912_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Er aber lief zu den Rindern und holte ein zartes, gutes Kalb und gab's dem Knechte; der eilte und bereitete es zu. ");
INSERT INTO deu1912_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Und er trug auf Butter und Milch und von dem Kalbe, das er zubereitet hatte, und setzte es ihnen vor und blieb stehen vor ihnen unter dem Baum, und sie aßen. ");
INSERT INTO deu1912_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Da sprachen sie zu ihm: Wo ist dein Weib Sara? Er antwortete: Drinnen in der Hütte. ");
INSERT INTO deu1912_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Da sprach er: Ich will wieder zu dir kommen über ein Jahr; siehe, so soll Sara, dein Weib, einen Sohn haben. Das hörte Sara hinter ihm, hinter der Tür der Hütte. ");
INSERT INTO deu1912_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Und sie waren beide, Abraham und Sara, alt und wohl betagt, also daß es Sara nicht mehr ging nach der Weiber Weise. ");
INSERT INTO deu1912_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Darum lachte sie bei sich selbst und sprach: Nun ich alt bin, soll ich noch Wollust pflegen, und mein Herr ist auch alt? ");
INSERT INTO deu1912_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Da sprach der HERR zu Abraham: Warum lacht Sara und spricht: Meinst du, das es wahr sei, daß ich noch gebären werde, so ich doch alt bin? ");
INSERT INTO deu1912_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Sollte dem HERRN etwas unmöglich sein? Um diese Zeit will ich wieder zu dir kommen über ein Jahr, so soll Sara einen Sohn haben. ");
INSERT INTO deu1912_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Da leugnete Sara und sprach: Ich habe nicht gelacht; denn sie fürchtete sich. Aber er sprach: Es ist nicht also; du hast gelacht. ");
INSERT INTO deu1912_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Da standen die Männer auf von dannen und wandten sich gegen Sodom; und Abraham ging mit ihnen, daß er sie geleitete. ");
INSERT INTO deu1912_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Da sprach der HERR: Wie kann ich Abraham verbergen, was ich tue, ");
INSERT INTO deu1912_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","sintemal er ein großes und mächtiges Volk soll werden, und alle Völker auf Erden in ihm gesegnet werden sollen? ");
INSERT INTO deu1912_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Denn ich weiß, er wird befehlen seinen Kindern und seinem Hause nach ihm, daß sie des HERRN Wege halten und tun, was recht und gut ist, auf daß der HERR auf Abraham kommen lasse, was er ihm verheißen hat. ");
INSERT INTO deu1912_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Und der HERR sprach: Es ist ein Geschrei zu Sodom und Gomorra, das ist groß, und ihre Sünden sind sehr schwer. ");
INSERT INTO deu1912_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Darum will ich hinabfahren und sehen, ob sie alles getan haben nach dem Geschrei, das vor mich gekommen ist, oder ob's nicht also sei, daß ich's wisse. ");
INSERT INTO deu1912_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Und die Männer wandten ihr Angesicht und gingen gen Sodom; aber Abraham blieb stehen vor dem HERRN ");
INSERT INTO deu1912_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","und trat zu ihm und sprach: Willst du denn den Gerechten mit dem Gottlosen umbringen? ");
INSERT INTO deu1912_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Es mögen vielleicht fünfzig Gerechte in der Stadt sein; wolltest du die umbringen und dem Ort nicht vergeben um fünfzig Gerechter willen, die darin wären? ");
INSERT INTO deu1912_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Das sei ferne von dir, daß du das tust und tötest den Gerechten mit dem Gottlosen, daß der Gerechte sei gleich wie der Gottlose! Das sei ferne von dir, der du aller Welt Richter bist! Du wirst so nicht richten. ");
INSERT INTO deu1912_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Der HERR sprach: Finde ich fünfzig Gerechte zu Sodom in der Stadt, so will ich um ihrer willen dem ganzen Ort vergeben. ");
INSERT INTO deu1912_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham antwortete und sprach: Ach siehe, ich habe mich unterwunden zu reden mit dem Herrn, wie wohl ich Erde und Asche bin. ");
INSERT INTO deu1912_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Es möchten vielleicht fünf weniger den fünfzig Gerechte darin sein; wolltest du denn die ganze Stadt verderben um der fünf willen? Er sprach: Finde ich darin fünfundvierzig, so will ich sie nicht verderben. ");
INSERT INTO deu1912_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Und er fuhr fort mit ihm zu reden und sprach: Man möchte vielleicht vierzig darin finden. Er aber sprach: Ich will ihnen nichts tun um der vierzig willen. ");
INSERT INTO deu1912_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham sprach: Zürne nicht, Herr, daß ich noch mehr rede. Man möchte vielleicht dreißig darin finden. Er aber sprach: Finde ich dreißig darin, so will ich ihnen nichts tun. ");
INSERT INTO deu1912_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Und er sprach: Ach siehe, ich habe mich unterwunden mit dem Herrn zu reden. Man möchte vielleicht zwanzig darin finden. Er antwortete: Ich will sie nicht verderben um der zwanzig willen. ");
INSERT INTO deu1912_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Und er sprach: Ach zürne nicht, Herr, daß ich nur noch einmal rede. Man möchte vielleicht zehn darin finden. Er aber sprach: Ich will sie nicht verderben um der zehn willen. ");
INSERT INTO deu1912_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Und der HERR ging hin, da er mit Abraham ausgeredet hatte; und Abraham kehrte wieder um an seinen Ort. ");
INSERT INTO deu1912_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Die zwei Engel kamen gen Sodom des Abends; Lot aber saß zu Sodom unter dem Tor. Und da er sie sah, stand er auf, ihnen entgegen, und bückte sich mit seinem Angesicht zur Erde ");
INSERT INTO deu1912_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","und sprach: Siehe, liebe Herren, kehrt doch ein zum Hause eures Knechtes und bleibt über Nacht; laßt eure Füße waschen, so steht ihr morgens früh auf und zieht eure Straße. Aber sie sprachen: Nein, sondern wir wollen über Nacht auf der Gasse bleiben. ");
INSERT INTO deu1912_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Da nötigte er sie sehr; und sie kehrten zu ihm ein und kamen in sein Haus. Und er machte ihnen ein Mahl und buk ungesäuerte Kuchen; und sie aßen. ");
INSERT INTO deu1912_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Aber ehe sie sich legten, kamen die Leute der Stadt Sodom und umgaben das ganze Haus, jung und alt, das ganze Volk aus allen Enden, ");
INSERT INTO deu1912_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","und forderten Lot und sprachen zu ihm: Wo sind die Männer, die zu dir gekommen sind diese Nacht? Führe sie heraus zu uns, daß wir sie erkennen. ");
INSERT INTO deu1912_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot ging heraus zu ihnen vor die Tür und schloß die Tür hinter sich zu ");
INSERT INTO deu1912_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","und sprach: Ach, liebe Brüder, tut nicht so übel! ");
INSERT INTO deu1912_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Siehe, ich habe zwei Töchter, die haben noch keinen Mann erkannt, die will ich herausgeben unter euch, und tut mit ihnen, was euch gefällt; allein diesen Männern tut nichts, denn darum sind sie unter den Schatten meines Daches eingegangen. ");
INSERT INTO deu1912_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sie aber sprachen: Geh hinweg! und sprachen auch: Du bist der einzige Fremdling hier und willst regieren? Wohlan, wir wollen dich übler plagen denn jene. Und sie drangen hart auf den Mann Lot. Und da sie hinzuliefen und wollten die Tür aufbrechen, ");
INSERT INTO deu1912_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","griffen die Männer hinaus und zogen Lot hinein zu sich ins Haus und schlossen die Tür zu. ");
INSERT INTO deu1912_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Und die Männer vor der Tür wurden mit Blindheit geschlagen, klein und groß, bis sie müde wurden und die Tür nicht finden konnten. ");
INSERT INTO deu1912_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Und die Männer sprachen zu Lot: Hast du noch irgend hier einen Eidam und Söhne und Töchter, und wer dir angehört in der Stadt, den führe aus dieser Stätte. ");
INSERT INTO deu1912_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Denn wir werden diese Stätte verderben, darum daß ihr Geschrei groß ist vor dem HERRN; der hat uns gesandt, sie zu verderben. ");
INSERT INTO deu1912_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Da ging Lot hinaus und redete mit seinen Eidamen, die seine Töchter nehmen sollten: Macht euch auf und geht aus diesem Ort; denn der HERR wird diese Stadt verderben. Aber es war ihnen lächerlich. ");
INSERT INTO deu1912_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Da nun die Morgenröte aufging, hießen die Engel den Lot eilen und sprachen: Mache dich auf, nimm dein Weib und deine zwei Töchter, die vorhanden sind, daß du nicht auch umkommst in der Missetat dieser Stadt. ");
INSERT INTO deu1912_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Da er aber verzog, ergriffen die Männer ihn und sein Weib und seine zwei Töchter bei der Hand, darum daß der HERR ihn verschonte, und führten ihn hinaus und ließen ihn draußen vor der Stadt. ");
INSERT INTO deu1912_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Und als sie ihn hatten hinausgebracht, sprach er: Errette dein Seele und sieh nicht hinter dich; auch stehe nicht in dieser ganzen Gegend. Auf den Berg rette dich, daß du nicht umkommst. ");
INSERT INTO deu1912_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Aber Lot sprach zu ihnen: Ach nein, Herr! ");
INSERT INTO deu1912_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Siehe, dieweil dein Knecht Gnade gefunden hat vor deinen Augen, so wollest du deine Barmherzigkeit groß machen, die du an mir getan hast, daß du meine Seele am Leben erhieltest. Ich kann mich nicht auf den Berg retten; es möchte mich ein Unfall ankommen, daß ich stürbe. ");
INSERT INTO deu1912_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Siehe, da ist eine Stadt nahe, darein ich fliehen kann, und sie ist klein; dahin will ich mich retten (ist sie doch klein), daß meine Seele lebendig bleibe. ");
INSERT INTO deu1912_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Da sprach er zu ihm: Siehe, ich habe auch in diesem Stück dich angesehen, daß ich die Stadt nicht umkehre, von der du geredet hast. ");
INSERT INTO deu1912_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Eile und rette dich dahin; denn ich kann nichts tun, bis daß du hineinkommst. Daher ist diese Stadt genannt Zoar. ");
INSERT INTO deu1912_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Und die Sonne war aufgegangen auf Erden, da Lot nach Zoar kam. ");
INSERT INTO deu1912_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Da ließ der HERR Schwefel und Feuer regnen von Himmel herab auf Sodom und Gomorra ");
INSERT INTO deu1912_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","und kehrte die Städte um und die ganze Gegend und alle Einwohner der Städte und was auf dem Lande gewachsen war. ");
INSERT INTO deu1912_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Und sein Weib sah hinter sich und ward zur Salzsäule. ");
INSERT INTO deu1912_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham aber machte sich des Morgens früh auf an den Ort, da er gestanden vor dem HERRN, ");
INSERT INTO deu1912_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","und wandte sein Angesicht gegen Sodom und Gomorra und alles Land der Gegend und schaute; und siehe, da ging Rauch auf vom Lande wie ein Rauch vom Ofen. ");
INSERT INTO deu1912_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Und es geschah, da Gott die Städte in der Gegend verderbte, gedachte er an den Abraham und geleitete Lot aus den Städten, die er umkehrte, darin Lot wohnte. ");
INSERT INTO deu1912_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Und Lot zog aus Zoar und blieb auf dem Berge mit seinen beiden Töchtern; denn er fürchtete sich, zu Zoar zu bleiben; und blieb also in einer Höhle mit seinen beiden Töchtern. ");
INSERT INTO deu1912_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Da sprach die ältere zu der jüngeren: Unser Vater ist alt, und ist kein Mann mehr auf Erden der zu uns eingehen möge nach aller Welt Weise; ");
INSERT INTO deu1912_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","so komm, laß uns unserm Vater Wein zu trinken geben und bei ihm schlafen, daß wir Samen von unserm Vater erhalten. ");
INSERT INTO deu1912_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Also gaben sie ihrem Vater Wein zu trinken in derselben Nacht. Und die erste ging hinein und legte sich zu ihrem Vater; und der ward's nicht gewahr, da sie sich legte noch da sie aufstand. ");
INSERT INTO deu1912_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Des Morgens sprach die ältere zu der jüngeren: Siehe, ich habe gestern bei meinem Vater gelegen. Laß uns ihm diese Nacht auch Wein zu trinken geben, daß du hineingehst und legst dich zu ihm, daß wir Samen von unserm Vater erhalten. ");
INSERT INTO deu1912_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Also gaben sie ihrem Vater die Nacht auch Wein zu trinken. Und die jüngere machte sich auf und legte sich zu ihm; und er ward's nicht gewahr, da sie sich legte noch da sie aufstand. ");
INSERT INTO deu1912_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Also wurden beide Töchter Lots schwanger von ihrem Vater. ");
INSERT INTO deu1912_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Und die ältere gebar einen Sohn, den nannte sie Moab. Von dem kommen her die Moabiter bis auf den heutigen Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Und die jüngere gebar auch einen Sohn, den hieß sie das Kind Ammi. Von dem kommen die Kinder Ammon bis auf den heutigen Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham aber zog von dannen ins Land gegen Mittag und wohnte zwischen Kades und Sur und ward ein Fremdling zu Gerar. ");
INSERT INTO deu1912_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Er sprach aber von seinem Weibe Sara: Es ist meine Schwester. Da sandte Abimelech, der König zu Gerar, nach ihr und ließ sie holen. ");
INSERT INTO deu1912_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Aber Gott kam zu Abimelech des Nachts im Traum und sprach zu ihm: Siehe da, du bist des Todes um des Weibes willen, das du genommen hast; denn sie ist eines Mannes Eheweib. ");
INSERT INTO deu1912_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech aber hatte sie nicht berührt und sprach: Herr, willst du denn auch ein gerechtes Volk erwürgen? ");
INSERT INTO deu1912_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hat er nicht zu mir gesagt: Sie sei seine Schwester? Und sie hat auch gesagt: Er ist mein Bruder. Habe ich doch das getan mit einfältigem Herzen und unschuldigen Händen. ");
INSERT INTO deu1912_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Und Gott sprach zu ihm im Traum: Ich weiß auch, daß du mit einfältigem Herzen das getan hast. Darum habe ich dich auch behütet, daß du nicht wider mich sündigtest, und habe es nicht zugegeben, daß du sie berührtest. ");
INSERT INTO deu1912_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","So gib nun dem Manne sein Weib wieder, denn er ist ein Prophet; und laß ihn für dich bitten, so wirst du lebendig bleiben. Wo du sie aber nicht wiedergibst, so wisse, daß du des Todes sterben mußt und alles, was dein ist. ");
INSERT INTO deu1912_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Da stand Abimelech des Morgens früh auf und rief alle seine Knechte und sagte ihnen dieses alles vor ihren Ohren. Und die Leute fürchteten sich sehr. ");
INSERT INTO deu1912_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Und Abimelech rief Abraham auch und sprach zu ihm: Warum hast du uns das getan? Und was habe ich an dir gesündigt, daß du so eine große Sünde wolltest auf mich und mein Reich bringen? Du hast mit mir gehandelt, wie man nicht handeln soll. ");
INSERT INTO deu1912_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Und Abimelech sprach weiter zu Abraham: Was hast du gesehen, daß du solches getan hast? ");
INSERT INTO deu1912_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham sprach: Ich dachte, vielleicht ist keine Gottesfurcht an diesem Orte, und sie werden mich um meines Weibes willen erwürgen. ");
INSERT INTO deu1912_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Auch ist sie wahrhaftig meine Schwester; denn sie ist meines Vaters Tochter, aber nicht meiner Mutter Tochter, und ist mein geworden. ");
INSERT INTO deu1912_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Da mich aber Gott aus meines Vaters Hause wandern hieß, sprach ich zu ihr: Die Barmherzigkeit tu an mir, daß, wo wir hinkommen, du sagst, ich sei dein Bruder. ");
INSERT INTO deu1912_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Da nahm Abimelech Schafe und Rinder, Knechte und Mägde und gab sie Abraham und gab ihm wieder sein Weib Sara ");
INSERT INTO deu1912_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","und sprach: Siehe da, mein Land steht dir offen; wohne, wo dir's wohl gefällt. ");
INSERT INTO deu1912_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Und sprach zu Sara: Siehe da, ich habe deinem Bruder tausend Silberlinge gegeben; siehe, das soll dir eine Decke der Augen sein vor allen, die bei dir sind, und allenthalben. Und damit war ihr Recht verschafft. ");
INSERT INTO deu1912_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham aber betete zu Gott; da heilte Gott Abimelech und sein Weib und seine Mägde, daß sie Kinder gebaren. ");
INSERT INTO deu1912_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Denn der HERR hatte zuvor hart verschlossen alle Mütter des Hauses Abimelechs um Saras, Abrahams Weibes, willen. ");
INSERT INTO deu1912_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Und der HERR suchte heim Sara, wie er geredet hatte, und tat mit ihr, wie er geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Und Sara ward schwanger und gebar Abraham einen Sohn in seinem Alter um die Zeit, von der ihm Gott geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Und Abraham hieß seinen Sohn, der ihm geboren war, Isaak, den ihm Sara gebar, ");
INSERT INTO deu1912_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","und beschnitt ihn am achten Tage, wie ihm Gott geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Hundert Jahre war Abraham alt, da ihm sein Sohn Isaak geboren ward. ");
INSERT INTO deu1912_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Und Sara sprach: Gott hat mir ein Lachen zugerichtet; denn wer es hören wird, der wird über mich lachen, ");
INSERT INTO deu1912_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","und sprach: Wer durfte von Abraham sagen, daß Sara Kinder säuge? Denn ich habe ihm einen Sohn geboren in seinem Alter. ");
INSERT INTO deu1912_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Und das Kind wuchs und ward entwöhnt; und Abraham machte ein großes Mahl am Tage, da Isaak entwöhnt ward. ");
INSERT INTO deu1912_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Und Sara sah den Sohn Hagars, der Ägyptischen, den sie Abraham geboren hatte, daß er ein Spötter war, ");
INSERT INTO deu1912_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","und sprach zu Abraham: Treibe diese Magd aus mit ihrem Sohn; denn dieser Magd Sohn soll nicht erben mit meinem Sohn Isaak. ");
INSERT INTO deu1912_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Das Wort gefiel Abraham sehr übel um seines Sohnes willen. ");
INSERT INTO deu1912_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Aber Gott sprach zu ihm: Laß dir's nicht übel gefallen des Knaben und der Magd halben. Alles, was Sara dir gesagt hat, dem gehorche; denn in Isaak soll dir der Same genannt werden. ");
INSERT INTO deu1912_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Auch will ich der Magd Sohn zum Volk machen, darum daß er deines Samens ist. ");
INSERT INTO deu1912_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Da stand Abraham des Morgens früh auf und nahm Brot und einen Schlauch mit Wasser und legte es Hagar auf ihre Schulter und den Knaben mit und ließ sie von sich. Da zog sie hin und ging in der Wüste irre bei Beer-Seba. ");
INSERT INTO deu1912_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Da nun das Wasser in dem Schlauch aus war, warf sie den Knaben unter einen Strauch ");
INSERT INTO deu1912_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","und ging hin und setzte sich gegenüber von fern, einen Bogenschuß weit; denn sie sprach: Ich kann nicht ansehen des Knaben Sterben. Und sie setzte sich gegenüber und hob ihre Stimme auf und weinte. ");
INSERT INTO deu1912_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Da erhörte Gott die Stimme des Knaben. Und der Engel Gottes rief vom Himmel der Hagar und sprach zu ihr: Was ist dir Hagar? Fürchte dich nicht; denn Gott hat erhört die Stimme des Knaben, da er liegt. ");
INSERT INTO deu1912_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Steh auf, nimm den Knaben und führe ihn an deiner Hand; denn ich will ihn zum großen Volk machen. ");
INSERT INTO deu1912_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Und Gott tat ihr die Augen auf, daß sie einen Wasserbrunnen sah. Da ging sie hin und füllte den Schlauch mit Wasser und tränkte den Knaben. ");
INSERT INTO deu1912_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Und Gott war mit dem Knaben; der wuchs und wohnte in der Wüste und ward ein guter Schütze. ");
INSERT INTO deu1912_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Und er wohnte in der Wüste Pharan, und seine Mutter nahm ihm ein Weib aus Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Zu der Zeit redete Abimelech und Phichol, sein Feldhauptmann, mit Abraham und sprach: Gott ist mit dir in allem, das du tust. ");
INSERT INTO deu1912_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","So schwöre mir nun bei Gott, daß du mir und meinen Kindern und meinen Enkeln keine Untreue erzeigen wollest, sondern die Barmherzigkeit, die ich an dir getan habe, an mir auch tust und an dem Lande, darin du ein Fremdling bist. ");
INSERT INTO deu1912_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Da sprach Abraham: Ich will schwören. ");
INSERT INTO deu1912_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Und Abraham setzte Abimelech zur Rede um des Wasserbrunnens willen, den Abimelechs Knechte hatten mit Gewalt genommen. ");
INSERT INTO deu1912_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Da antwortete Abimelech: Ich habe es nicht gewußt, wer das getan hat; auch hast du mir's nicht angesagt; dazu habe ich's nicht gehört bis heute. ");
INSERT INTO deu1912_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Da nahm Abraham Schafe und Rinder und gab sie Abimelech; und sie machten beide einen Bund miteinander. ");
INSERT INTO deu1912_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Und Abraham stellt sieben Lämmer besonders. ");
INSERT INTO deu1912_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Da sprach Abimelech zu Abraham: Was sollen die sieben Lämmer, die du besonders gestellt hast? ");
INSERT INTO deu1912_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Er antwortete: Sieben Lämmer sollst du von meiner Hand nehmen, daß sie mir zum Zeugnis seien, daß ich diesen Brunnen gegraben habe. ");
INSERT INTO deu1912_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Daher heißt die Stätte Beer-Seba, weil sie beide miteinander da geschworen haben. ");
INSERT INTO deu1912_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Und also machten sie den Bund zu Beer-Seba. Da machten sich auf Abimelech und Phichol, sein Feldhauptmann, und zogen wieder in der Philister Land. ");
INSERT INTO deu1912_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham aber pflanzte Bäume zu Beer-Seba und predigte daselbst von dem Namen des HERRN, des ewigen Gottes. ");
INSERT INTO deu1912_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Und er war ein Fremdling in der Philister Lande eine lange Zeit. ");
INSERT INTO deu1912_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nach diesen Geschichten versuchte Gott Abraham und sprach zu ihm: Abraham! Und er antwortete: Hier bin ich. ");
INSERT INTO deu1912_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Und er sprach: Nimm Isaak, deinen einzigen Sohn, den du lieb hast, und gehe hin in das Land Morija und opfere ihn daselbst zum Brandopfer auf einem Berge, den ich dir sagen werde. ");
INSERT INTO deu1912_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Da stand Abraham des Morgens früh auf und gürtete seinen Esel und nahm mit sich zwei Knechte und seinen Sohn Isaak und spaltete Holz zum Brandopfer, machte sich auf und ging an den Ort, davon ihm Gott gesagt hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Am dritten Tage hob Abraham seine Augen auf und sah die Stätte von ferne ");
INSERT INTO deu1912_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","und sprach zu seinen Knechten: Bleibt ihr hier mit dem Esel! Ich und der Knabe wollen dorthin gehen; und wenn wir angebetet haben, wollen wir wieder zu euch kommen. ");
INSERT INTO deu1912_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Und Abraham nahm das Holz zum Brandopfer und legte es auf seinen Sohn Isaak; er aber nahm das Feuer und Messer in seine Hand, und gingen die beiden miteinander. ");
INSERT INTO deu1912_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Da sprach Isaak zu seinem Vater Abraham: Mein Vater! Abraham antwortete: Hier bin ich mein Sohn. Und er sprach: Siehe, hier ist Feuer und Holz; wo ist aber das Schaf zum Brandopfer? ");
INSERT INTO deu1912_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham antwortete: Mein Sohn, Gott wird sich ersehen ein Schaf zum Brandopfer. Und gingen beide miteinander. ");
INSERT INTO deu1912_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Und als sie kamen an die Stätte, die ihm Gott gesagt hatte, baute Abraham daselbst einen Altar und legte das Holz darauf und band seinen Sohn Isaak, legte ihn auf den Altar oben auf das Holz ");
INSERT INTO deu1912_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","und reckte seine Hand aus und faßte das Messer, daß er seinen Sohn schlachtete. ");
INSERT INTO deu1912_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Da rief ihm der Engel des HERRN vom Himmel und sprach: Abraham! Abraham! Er antwortete: Hier bin ich. ");
INSERT INTO deu1912_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Er sprach: Lege deine Hand nicht an den Knaben und tue ihm nichts; denn nun weiß ich, daß du Gott fürchtest und hast deines einzigen Sohnes nicht verschont um meinetwillen. ");
INSERT INTO deu1912_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Da hob Abraham sein Augen auf und sah einen Widder hinter sich in der Hecke mit seinen Hörnern hangen und ging hin und nahm den Widder und opferte ihn zum Brandopfer an seines Sohnes Statt. ");
INSERT INTO deu1912_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Und Abraham hieß die Stätte: Der HERR sieht. Daher man noch heutigestages sagt: Auf dem Berge, da der HERR sieht. ");
INSERT INTO deu1912_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Und der Engel des HERRN rief Abraham abermals vom Himmel ");
INSERT INTO deu1912_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","und sprach: Ich habe bei mir selbst geschworen, spricht der HERR, weil du solches getan hast und hast deines einzigen Sohnes nicht verschont, ");
INSERT INTO deu1912_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","daß ich deinen Samen segnen und mehren will wie die Sterne am Himmel und wie den Sand am Ufer des Meeres; und dein Same soll besitzen die Tore seiner Feinde; ");
INSERT INTO deu1912_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","und durch deinen Samen sollen alle Völker auf Erden gesegnet werden, darum daß du meiner Stimme gehorcht hast. ");
INSERT INTO deu1912_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Also kehrte Abraham wieder zu seinen Knechten; und sie machten sich auf und zogen miteinander gen Beer-Seba; und er wohnte daselbst. ");
INSERT INTO deu1912_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nach diesen Geschichten begab sich's, daß Abraham angesagt ward: Siehe, Milka hat auch Kinder geboren deinem Bruder Nahor, ");
INSERT INTO deu1912_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","nämlich Uz, den Erstgeborenen, und Buz, seinen Bruder, und Kemuel, von dem die Syrer kommen, ");
INSERT INTO deu1912_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","und Chesed und Haso und Phildas und Jedlaph und Bethuel. ");
INSERT INTO deu1912_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel aber zeugte Rebekka. Diese acht gebar Milka dem Nahor, Abrahams Bruder. ");
INSERT INTO deu1912_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Und sein Kebsweib, mit Namen Rehuma, gebar auch, nämlich den Tebah, Gaham, Thahas und Maacha. ");
INSERT INTO deu1912_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara ward hundertsiebenundzwanzig Jahre alt ");
INSERT INTO deu1912_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","und starb in Kirjat-Arba, das Hebron heißt, im Lande Kanaan. Da kam Abraham, daß er sie beklagte und beweinte. ");
INSERT INTO deu1912_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Darnach stand er auf von seiner Leiche und redete mit den Kindern Heth und sprach: ");
INSERT INTO deu1912_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ich bin ein Fremder und Einwohner bei euch; gebt mir ein Erbbegräbnis bei euch, daß ich meinen Toten begrabe, der vor mir liegt. ");
INSERT INTO deu1912_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Da antworteten Abraham die Kinder Heth und sprachen zu ihm: ");
INSERT INTO deu1912_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Höre uns, lieber Herr! Du bist ein Fürst Gottes unter uns, begrabe deinen Toten in unsern vornehmsten Gräbern; kein Mensch soll dir unter uns wehren, daß du in seinem Grabe begrabest deinen Toten. ");
INSERT INTO deu1912_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Da stand Abraham auf und bückte sich vor dem Volk des Landes, vor den Kindern Heth. ");
INSERT INTO deu1912_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Und er redete mit ihnen und sprach: Gefällt es euch, daß ich meinen Toten, der vor mir liegt, begrabe, so hört mich und bittet für mich Ephron, den Sohn Zohars, ");
INSERT INTO deu1912_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","daß er mir gebe seine zwiefache Höhle, die er hat am Ende seines Ackers; er gebe sie mir um Geld, soviel sie wert ist, unter euch zum Erbbegräbnis. ");
INSERT INTO deu1912_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron aber saß unter den Kindern Heth. Da antwortete Ephron, der Hethiter, Abraham, daß zuhörten die Kinder Heth, vor allen, die zu seiner Stadt Tor aus und ein gingen, und sprach: ");
INSERT INTO deu1912_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nein, mein Herr, sondern höre mir zu! Ich schenke dir den Acker und die Höhle darin dazu und übergebe dir's vor den Augen der Kinder meines Volkes, zu begraben deinen Toten. ");
INSERT INTO deu1912_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Da bückte sich Abraham vor dem Volk des Landes ");
INSERT INTO deu1912_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","und redete mit Ephron, daß zuhörte das Volk des Landes, und sprach: Willst du mir ihn lassen, so bitte ich, nimm von mir das Geld für den Acker, das ich dir gebe, so will ich meinen Toten daselbst begraben. ");
INSERT INTO deu1912_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron antwortete Abraham und sprach zu ihm: ");
INSERT INTO deu1912_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mein Herr, höre doch mich! Das Feld ist vierhundert Lot Silber wert; was ist das aber zwischen mir und dir? Begrabe nur deinen Toten! ");
INSERT INTO deu1912_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham gehorchte Ephron und wog ihm das Geld dar, das er gesagt hatte, daß zuhörten die Kinder Heth, vierhundert Lot Silber, das im Kauf gang und gäbe war. ");
INSERT INTO deu1912_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Also ward Ephrons Acker, darin die zwiefache Höhle ist, Mamre gegenüber, Abraham zum eigenen Gut bestätigt mit der Höhle darin und mit allen Bäumen auf dem Acker umher, ");
INSERT INTO deu1912_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","daß die Kinder Heth zusahen und alle, die zu seiner Stadt Tor aus und ein gingen. ");
INSERT INTO deu1912_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Darnach begrub Abraham Sara, sein Weib, in der Höhle des Ackers, die zwiefach ist, Mamre gegenüber, das ist Hebron, im Lande Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Also ward bestätigt der Acker und die Höhle darin Abraham zum Erbbegräbnis von den Kindern Heth. ");
INSERT INTO deu1912_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham ward alt und wohl betagt, und der HERR hatte ihn gesegnet allenthalben. ");
INSERT INTO deu1912_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Und er sprach zu dem ältesten Knecht seines Hauses, der allen seinen Gütern vorstand: Lege deine Hand unter meine Hüfte ");
INSERT INTO deu1912_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","und schwöre mir bei dem HERRN, dem Gott des Himmels und der Erde, daß du meinem Sohn kein Weib nehmest von den Töchtern der Kanaaniter, unter welchen ich wohne, ");
INSERT INTO deu1912_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","sondern daß du ziehst in mein Vaterland und zu meiner Freundschaft und nehmest meinem Sohn Isaak ein Weib. ");
INSERT INTO deu1912_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Der Knecht sprach: Wie, wenn das Weib mir nicht wollte folgen in dies Land, soll ich dann deinen Sohn wiederbringen in jenes Land, daraus du gezogen bist? ");
INSERT INTO deu1912_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham sprach zu ihm: Davor hüte dich, daß du meinen Sohn nicht wieder dahin bringst. ");
INSERT INTO deu1912_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Der HERR, der Gott des Himmels, der mich von meines Vaters Hause genommen hat und von meiner Heimat, der mir geredet hat und mir auch geschworen hat und gesagt: Dies Land will ich deinem Samen geben, der wird seine Engel vor dir her senden, daß du meinem Sohn daselbst ein Weib nehmest. ");
INSERT INTO deu1912_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","So aber das Weib dir nicht folgen will, so bist du dieses Eides quitt. Allein bringe meinen Sohn nicht wieder dorthin. ");
INSERT INTO deu1912_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Da legte der Knecht seine Hand unter die Hüfte Abrahams, seines Herrn, und schwur ihm solches. ");
INSERT INTO deu1912_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Also nahm der Knecht zehn Kamele von den Kamelen seines Herrn und zog hin und hatte mit sich allerlei Güter seines Herrn und machte sich auf und zog nach Mesopotamien zu der Stadt Nahors. ");
INSERT INTO deu1912_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Da ließ er die Kamele sich lagern draußen vor der Stadt bei einem Wasserbrunnen, des Abends um die Zeit, wo die Weiber pflegten herauszugehen und Wasser zu schöpfen, ");
INSERT INTO deu1912_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","und sprach: HERR, du Gott meines Herrn Abraham, begegne mir heute und tue Barmherzigkeit an meinem Herrn Abraham! ");
INSERT INTO deu1912_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Siehe, ich stehe hier bei dem Wasserbrunnen, und der Leute Töchter in dieser Stadt werden herauskommen, Wasser zu schöpfen. ");
INSERT INTO deu1912_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Wenn nun eine Dirne kommt, zu der ich spreche: Neige deinen Krug, und laß mich trinken, und sie sprechen wird: Trinke, ich will deine Kamele auch tränken: das sei die, die du deinem Diener Isaak beschert hast, und daran werde ich erkennen, daß du Barmherzigkeit an meinem Herrn getan habest. ");
INSERT INTO deu1912_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Und ehe er ausgeredet hatte, siehe, da kam heraus Rebekka, Bethuels Tochter, der ein Sohn der Milka war, welche Nahors, Abrahams Bruders, Weib war, und trug einen Krug auf ihrer Achsel. ");
INSERT INTO deu1912_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Und sie war eine sehr schöne Dirne von Angesicht, noch eine Jungfrau, und kein Mann hatte sie erkannt. Die stieg hinab zum Brunnen und füllte den Krug und stieg herauf. ");
INSERT INTO deu1912_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Da lief ihr der Knecht entgegen und sprach: Laß mich ein wenig Wasser aus deinem Kruge trinken. ");
INSERT INTO deu1912_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Und sie sprach: Trinke, mein Herr! und eilend ließ sie den Krug hernieder auf ihre Hand und gab ihm zu trinken. ");
INSERT INTO deu1912_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Und da sie ihm zu trinken gegeben hatte, sprach sie: Ich will deinen Kamelen auch schöpfen, bis sie alle getrunken haben. ");
INSERT INTO deu1912_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Und eilte und goß den Krug aus in die Tränke und lief abermals zum Brunnen, zu schöpfen, und schöpfte allen seinen Kamelen. ");
INSERT INTO deu1912_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Der Mann aber wunderte sich ihrer und schwieg still, bis er erkennete, ob der HERR zu seiner Reise Gnade gegeben hätte oder nicht. ");
INSERT INTO deu1912_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Da nun die Kamele alle getrunken hatten, nahm er einen goldenen Reif, ein halbes Lot schwer, und zwei Armringe an ihre Hände, zehn Lot Goldes schwer, ");
INSERT INTO deu1912_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","und sprach: Wes Tochter bist du? das sage mir doch. Haben wir Raum in deines Vaters Hause, zu beherbergen? ");
INSERT INTO deu1912_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Sie sprach zu ihm: Ich bin Bethuels Tochter, des Sohnes Milkas, den sie dem Nahor geboren hat, ");
INSERT INTO deu1912_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","und sagte weiter zu ihm: Es ist auch viel Stroh und Futter bei uns und Raum genug, zu beherbergen. ");
INSERT INTO deu1912_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Da neigte sich der Mann und betete den HERRN an ");
INSERT INTO deu1912_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","und sprach: Gelobt sei der HERR, der Gott meines Herrn Abraham, der seine Barmherzigkeit und seine Wahrheit nicht verlassen hat an meinem Herrn; denn der HERR hat mich den Weg geführt zum Hause des Bruders meines Herrn. ");
INSERT INTO deu1912_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Und die Dirne lief und sagte solches alles an in ihrer Mutter Hause. ");
INSERT INTO deu1912_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Und Rebekka hatte einen Bruder, der hieß Laban; und Laban lief zu dem Mann draußen bei dem Brunnen. ");
INSERT INTO deu1912_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Und als er sah den Reif und die Armringe an seiner Schwester Händen und hörte die Worte Rebekkas, seiner Schwester, daß sie sprach: Also hat mir der Mann gesagt, kam er zu dem Mann, und siehe, er stand bei den Kamelen am Brunnen. ");
INSERT INTO deu1912_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Und er sprach: Komm herein, du Gesegneter des HERRN! Warum stehst du draußen? Ich habe das Haus geräumt und für die Kamele auch Raum gemacht. ");
INSERT INTO deu1912_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Also führte er den Mann ins Haus und zäumte die Kamele ab und gab ihnen Stroh und Futter und Wasser, zu waschen seine Füße und die Füße der Männer, die mit ihm waren, ");
INSERT INTO deu1912_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","und setzte ihnen Essen vor. Er sprach aber: Ich will nicht essen, bis daß ich zuvor meine Sache vorgebracht habe. Sie antworteten: Sage an! ");
INSERT INTO deu1912_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Er sprach: Ich bin Abrahams Knecht. ");
INSERT INTO deu1912_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Und der HERR hat meinen Herrn reichlich gesegnet, daß er groß geworden ist, und hat ihm Schafe und Ochsen, Silber und Gold, Knechte und Mägde, Kamele und Esel gegeben. ");
INSERT INTO deu1912_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Dazu hat Sara, meines Herrn Weib, einen Sohn geboren meinem Herrn in seinem Alter; dem hat er alles gegeben, was er hat. ");
INSERT INTO deu1912_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Und mein Herr hat einen Eid von mir genommen und gesagt: Du sollst meinem Sohn kein Weib nehmen von den Töchtern der Kanaaniter, in deren Land ich wohne, ");
INSERT INTO deu1912_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","sondern ziehe hin zu meines Vaters Hause und zu meinem Geschlecht; daselbst nimm meinem Sohn ein Weib. ");
INSERT INTO deu1912_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ich aber sprach zu meinem Herrn: Wie, wenn mir das Weib nicht folgen will? ");
INSERT INTO deu1912_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Da sprach er zu mir: Der HERR, vor dem ich wandle, wird seinen Engel mit dir senden und Gnade zu deiner Reise geben, daß du meinem Sohn ein Weib nehmest von meiner Freundschaft und meines Vaters Hause. ");
INSERT INTO deu1912_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Alsdann sollst du meines Eides quitt sein, wenn du zu meiner Freundschaft kommst; geben sie dir sie nicht, so bist du meines Eides quitt. ");
INSERT INTO deu1912_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Also kam ich heute zum Brunnen und sprach: HERR, Gott meines Herrn Abraham, hast du Gnade zu meiner Reise gegeben, auf der ich bin, ");
INSERT INTO deu1912_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","siehe, so stehe ich hier bei dem Wasserbrunnen. Wenn nun eine Jungfrau herauskommt, zu schöpfen, und ich zu ihr spreche: Gib mir ein wenig Wasser zu trinken aus deinem Krug, ");
INSERT INTO deu1912_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","und sie wird sagen: Trinke du, ich will deinen Kamelen auch schöpfen: die sei das Weib, das der HERR meines Herrn Sohne beschert hat. ");
INSERT INTO deu1912_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ehe ich nun solche Worte ausgeredet hatte in meinem Herzen, siehe, da kommt Rebekka heraus mit einem Krug auf ihrer Achsel und geht hinab zum Brunnen und schöpft. Da sprach ich zu ihr: Gib mir zu trinken. ");
INSERT INTO deu1912_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Und sie nahm eilend den Krug von ihrer Achsel und sprach: Trinke, und deine Kamele will ich auch tränken. Also trank ich, und sie tränkte die Kamele auch. ");
INSERT INTO deu1912_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Und ich fragte sie und sprach: Wes Tochter bist du? Sie antwortete: Ich bin Bethuels Tochter, des Sohnes Nahors, den ihm Milka geboren hat. Da legte ich einen Reif an ihre Stirn und Armringe an ihre Hände ");
INSERT INTO deu1912_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","und neigte mich und betete den HERRN an und lobte den HERRN, den Gott meines Herrn Abraham, der mich den rechten Weg geführt hat, daß ich seinem Sohn die Tochter nehme des Bruders meines Herrn. ");
INSERT INTO deu1912_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Seid ihr nun die, so an meinem Herrn Freundschaft und Treue beweisen wollen, so sagt mir's; wo nicht, so sagt mir's auch, daß ich mich wende zur Rechten oder zur Linken. ");
INSERT INTO deu1912_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Da antworteten Laban und Bethuel und sprachen: Das kommt vom HERRN; darum können wir nicht wider dich reden, weder Böses noch Gutes; ");
INSERT INTO deu1912_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","da ist Rebekka vor dir, nimm sie und zieh hin, daß sie das Weib sei des Sohnes deines Herrn, wie der HERR geredet hat. ");
INSERT INTO deu1912_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Da diese Worte hörte Abrahams Knecht, bückte er sich vor dem Herrn zur Erde ");
INSERT INTO deu1912_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","und zog hervor silberne und goldene Kleinode und Kleider und gab sie Rebekka; aber ihrem Bruder und der Mutter gab er Würze. ");
INSERT INTO deu1912_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Da aß und trank er samt den Männern, die mit ihm waren, und blieb über Nacht allda. Des Morgens aber stand er auf und sprach: Laß mich ziehen zu meinem Herrn. ");
INSERT INTO deu1912_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Aber ihr Bruder und ihre Mutter sprachen: Laß doch die Dirne einen Tag oder zehn bei uns bleiben; darnach sollst du ziehen. ");
INSERT INTO deu1912_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Da sprach er zu ihnen: Haltet mich nicht auf; denn der HERR hat Gnade zu meiner Reise gegeben. Laßt mich, daß ich zu meinem Herrn ziehe. ");
INSERT INTO deu1912_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Da sprachen sie: Laßt uns die Dirne rufen und fragen, was sie dazu sagt. ");
INSERT INTO deu1912_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Und sie riefen Rebekka und sprachen zu ihr: Willst du mit diesem Mann ziehen? Sie antwortete: Ja, ich will mit ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Also ließen sie Rebekka, ihre Schwester, ziehen mit ihrer Amme samt Abrahams Knecht und seinen Leuten. ");
INSERT INTO deu1912_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Und sie segneten Rebekka und sprachen zu ihr: Du bist unsre Schwester; wachse in vieltausendmal tausend, und dein Same besitze die Tore seiner Feinde. ");
INSERT INTO deu1912_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Also machte sich Rebekka auf mit ihren Dirnen, und setzten sich auf die Kamele und zogen dem Manne nach. Und der Knecht nahm Rebekka und zog hin. ");
INSERT INTO deu1912_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaak aber kam vom Brunnen des Lebendigen und Sehenden (denn er wohnte im Lande gegen Mittag) ");
INSERT INTO deu1912_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","und war ausgegangen, zu beten auf dem Felde um den Abend, und hob seine Augen auf und sah, daß Kamele daherkamen. ");
INSERT INTO deu1912_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Und Rebekka hob ihre Augen auf und sah Isaak; da stieg sie eilend vom Kamel ");
INSERT INTO deu1912_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","und sprach zu dem Knecht: Wer ist der Mann auf dem Felde? Der Knecht sprach: Das ist mein Herr. Da nahm sie den Mantel und verhüllte sich. ");
INSERT INTO deu1912_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Und der Knecht erzählte Isaak alle Sachen, die er ausgerichtet hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Da führte sie Isaak in die Hütte seiner Mutter Sara und nahm die Rebekka und sie war sein Weib, und er gewann sie lieb. Also ward Isaak getröstet über seine Mutter. ");
INSERT INTO deu1912_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham nahm wieder ein Weib, die hieß Ketura. ");
INSERT INTO deu1912_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Die gebar ihm Simran und Joksan, Medan und Midian, Jesbak und Suah. ");
INSERT INTO deu1912_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan aber zeugte Saba und Dedan. Die Kinder aber von Dedan waren: die Assuriter, die Letusiter und die Leumiter. ");
INSERT INTO deu1912_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Die Kinder Midians waren: Epha, Epher, Henoch, Abida und Eldaa. Diese alle sind Kinder der Ketura. ");
INSERT INTO deu1912_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Und Abraham gab all sein Gut Isaak. ");
INSERT INTO deu1912_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Aber den Kindern, die er von den Kebsweibern hatte, gab er Geschenke und ließ sie von seinen Sohn Isaak ziehen, dieweil er noch lebte, gegen Aufgang in das Morgenland. ");
INSERT INTO deu1912_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Das aber ist Abrahams Alter, das er gelebt hat: hundertfünfundsiebzig Jahre. ");
INSERT INTO deu1912_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Und er nahm ab und starb in einem ruhigen Alter, da er alt und lebenssatt war, und ward zu seinem Volk gesammelt. ");
INSERT INTO deu1912_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Und es begruben ihn die Söhne Isaak und Ismael in der zwiefachen Höhle auf dem Acker Ephrons, des Sohnes Zohars, des Hethiters, die da liegt Mamre gegenüber, ");
INSERT INTO deu1912_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","in dem Felde, das Abraham von den Kindern Heth gekauft hatte. Da ist Abraham begraben mit Sara, seinem Weibe. ");
INSERT INTO deu1912_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Und nach dem Tode Abrahams segnete Gott Isaak, seinen Sohn. Und er wohnte bei dem Brunnen des Lebendigen und Sehenden. ");
INSERT INTO deu1912_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dies ist das Geschlecht Ismaels, des Sohnes Abrahams, den ihm Hagar gebar, die Magd Saras aus Ägypten; ");
INSERT INTO deu1912_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","und das sind die Namen der Kinder Ismaels, davon ihre Geschlechter genannt sind: der erstgeborene Sohn Ismaels, Nebajoth, -Kedar, Abdeel, Mibsam, ");
INSERT INTO deu1912_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO deu1912_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Thema, Jetur, Naphis und Kedma. ");
INSERT INTO deu1912_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dies sind die Kinder Ismaels mit ihren Namen in ihren Höfen und Zeltdörfern, zwölf Fürsten über ihre Leute. ");
INSERT INTO deu1912_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Und das ist das Alter Ismaels: hundert und siebenunddreißig Jahre. Und er nahm ab und starb und ward gesammelt zu seinem Volk. ");
INSERT INTO deu1912_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Und sie wohnten von Hevila an bis gen Sur vor Ägypten und bis wo man nach Assyrien geht. Er ließ sich aber nieder gegen alle seine Brüder. ");
INSERT INTO deu1912_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dies ist das Geschlecht Isaaks, des Sohnes Abrahams: Abraham zeugte Isaak. ");
INSERT INTO deu1912_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaak aber war vierzig Jahre alt, da er Rebekka zum Weibe nahm, die Tochter Bethuels, des Syrers, von Mesopotamien, Labans, des Syrers Schwester. ");
INSERT INTO deu1912_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaak aber bat den HERRN für sein Weib, denn sie war unfruchtbar. Und der HERR ließ sich erbitten, und Rebekka, sein Weib, ward schwanger. ");
INSERT INTO deu1912_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Und die Kinder stießen sich miteinander in ihrem Leibe. Da sprach sie: Da mir's also sollte gehen, warum bin ich schwanger geworden? und sie ging hin, den HERRN zu fragen. ");
INSERT INTO deu1912_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Und der HERR sprach zu ihr: Zwei Völker sind in deinem Leibe, und zweierlei Leute werden sich scheiden aus deinem Leibe; und ein Volk wird dem andern Überlegen sein, und der Ältere wird dem Jüngeren dienen. ");
INSERT INTO deu1912_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Da nun die Zeit kam, daß sie gebären sollte, siehe, da waren Zwillinge in ihrem Leibe. ");
INSERT INTO deu1912_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Der erste, der herauskam, war rötlich, ganz rauh wie ein Fell; und sie nannten ihn Esau. ");
INSERT INTO deu1912_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Darnach kam heraus sein Bruder, der hielt mit seiner Hand die Ferse des Esau; und sie hießen ihn Jakob. Sechzig Jahre alt war Isaak, da sie geboren wurden. ");
INSERT INTO deu1912_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Und da nun die Knaben groß wurden, ward Esau ein Jäger und streifte auf dem Felde, Jakob aber ein sanfter Mann und blieb in seinen Hütten. ");
INSERT INTO deu1912_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Und Isaak hatte Esau lieb und aß gern von seinem Weidwerk; Rebekka aber hatte Jakob lieb. ");
INSERT INTO deu1912_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Und Jakob kochte ein Gericht. Da kam Esau vom Felde und war müde ");
INSERT INTO deu1912_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","und sprach zu Jakob: Laß mich kosten das rote Gericht; denn ich bin müde. Daher heißt er Edom. ");
INSERT INTO deu1912_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Aber Jakob sprach: Verkaufe mir heute deine Erstgeburt. ");
INSERT INTO deu1912_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau antwortete: Siehe, ich muß doch sterben; was soll mir denn die Erstgeburt? ");
INSERT INTO deu1912_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob sprach: So schwöre mir heute. Und er schwur ihm und verkaufte also Jakob seine Erstgeburt. ");
INSERT INTO deu1912_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Da gab ihm Jakob Brot und das Linsengericht, und er aß und trank und stand auf und ging davon. Also verachtete Esau seine Erstgeburt. ");
INSERT INTO deu1912_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Es kam aber eine Teuerung ins Land nach der vorigen, so zu Abrahams Zeiten war. Und Isaak zog zu Abimelech, der Philister König, zu Gerar. ");
INSERT INTO deu1912_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Da erschien ihm der HERR und sprach: Ziehe nicht hinab nach Ägypten, sondern bleibe in dem Lande, das ich dir sage. ");
INSERT INTO deu1912_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Sei ein Fremdling in diesem Lande, und ich will mit dir sein und dich segnen; denn dir und deinem Samen will ich alle diese Länder geben und will meinen Eid bestätigen, den ich deinem Vater Abraham geschworen habe, ");
INSERT INTO deu1912_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","und will deinem Samen mehren wie die Sterne am Himmel und will deinem Samen alle diese Länder geben. Und durch deinen Samen sollen alle Völker auf Erden gesegnet werden, ");
INSERT INTO deu1912_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","darum daß Abraham meiner Stimme gehorsam gewesen ist und hat gehalten meine Rechte, meine Gebote, meine Weise und mein Gesetz. ");
INSERT INTO deu1912_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Also wohnte Isaak zu Gerar. ");
INSERT INTO deu1912_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Und wenn die Leute an demselben Ort fragten nach seinem Weibe, so sprach er: Sie ist meine Schwester. Denn er fürchtete sich zu sagen: Sie ist mein Weib; sie möchten mich erwürgen um Rebekkas willen, denn sie war schön von Angesicht. ");
INSERT INTO deu1912_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Als er nun eine Zeitlang da war, sah Abimelech, der Philister König, durchs Fenster und ward gewahr, daß Isaak scherzte mit seinem Weibe Rebekka. ");
INSERT INTO deu1912_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Da rief Abimelech den Isaak und sprach: Siehe, es ist dein Weib. Wie hast du denn gesagt: Sie ist meine Schwester? Isaak antwortete ihm: Ich gedachte, ich möchte vielleicht sterben müssen um ihretwillen. ");
INSERT INTO deu1912_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelech sprach: Warum hast du das getan? Es wäre leicht geschehen, daß jemand vom Volk sich zu deinem Weibe gelegt hätte, und hättest also eine Schuld auf uns gebracht. ");
INSERT INTO deu1912_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Da gebot Abimelech allem Volk und sprach: Wer diesen Mann oder sein Weib antastet, der soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Und Isaak säte in dem Lande und erntete desselben Jahres hundertfältig; denn der HERR segnete ihn. ");
INSERT INTO deu1912_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Und er ward ein großer Mann und nahm immer mehr zu, bis er sehr groß ward, ");
INSERT INTO deu1912_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","daß er viel Gut hatte an kleinem und großem Vieh und ein großes Gesinde. Darum beneideten ihn die Philister ");
INSERT INTO deu1912_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","und verstopften alle Brunnen, die seines Vaters Knechte gegraben hatten zur Zeit Abrahams, seines Vaters, und füllten sie mit Erde; ");
INSERT INTO deu1912_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","daß auch Abimelech zu ihm sprach: Ziehe von uns, denn du bist uns zu mächtig geworden. ");
INSERT INTO deu1912_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Da zog Isaak von dannen und schlug sein Gezelt auf im Grunde Gerar und wohnte allda ");
INSERT INTO deu1912_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","und ließ die Wasserbrunnen wieder aufgraben, die sie zu Abrahams, seines Vaters, Zeiten gegraben hatten, welche die Philister verstopft hatten nach Abrahams Tod, und nannte sie mit demselben Namen mit denen sie sein Vater genannt hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Auch gruben Isaaks Knechte im Grunde und fanden daselbst einen Brunnen lebendigen Wassers. ");
INSERT INTO deu1912_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Aber die Hirten von Gerar zankten mit den Hirten Isaaks und sprachen: Das Wasser ist unser. Da hieß er den Brunnen Esek, darum daß sie ihm unrecht getan hatten. ");
INSERT INTO deu1912_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Da gruben sie einen andern Brunnen. Darüber zankten sie auch, darum hieß er ihn Sitna. ");
INSERT INTO deu1912_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Da machte er sich von dannen und grub einen andern Brunnen. Darüber zankten sie sich nicht; darum hieß er ihn Rehoboth und sprach: Nun hat uns der HERR Raum gemacht und uns wachsen lassen im Lande. ");
INSERT INTO deu1912_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Darnach zog er von dannen gen Beer-Seba. ");
INSERT INTO deu1912_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Und der HERR erschien ihm in derselben Nacht und sprach: Ich bin deines Vaters Abrahams Gott. Fürchte dich nicht; denn ich bin mit dir und will dich segnen und deinen Samen mehren um meines Knechtes Abraham willen. ");
INSERT INTO deu1912_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Da baute er einen Altar daselbst und predigte von dem Namen des HERRN und richtete daselbst seine Hütte auf, und seine Knechte gruben daselbst einen Brunnen. ");
INSERT INTO deu1912_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Und Abimelech ging zu ihm von Gerar, und Ahussat, sein Freund, und Phichol, sein Feldhauptmann. ");
INSERT INTO deu1912_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aber Isaak sprach zu ihnen: Warum kommt ihr zu mir? Haßt ihr mich doch und habt mich von euch getrieben. ");
INSERT INTO deu1912_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Sie sprachen: Wir sehen mit sehenden Augen, daß der HERR mit dir ist. Darum sprachen wir: Es soll ein Eid zwischen uns und dir sein, und wir wollen einen Bund mit dir machen, ");
INSERT INTO deu1912_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","daß du uns keinen Schaden tust, gleichwie wir dir nichts denn alles Gute getan haben und dich mit Frieden haben ziehen lassen. Du aber bist nun der Gesegnete des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Da machte er ihnen ein Mahl, und sie aßen und tranken. ");
INSERT INTO deu1912_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Und des Morgens früh standen sie auf und schwur einer dem andern; und Isaak ließ sie gehen, und sie zogen von ihm mit Frieden. ");
INSERT INTO deu1912_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Desselben Tages aber kamen Isaaks Knechte und sagten ihm an von dem Brunnen, den sie gegraben hatten, und sprachen zu ihm: Wir haben Wasser gefunden. ");
INSERT INTO deu1912_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Und er nannte ihn Seba; daher heißt die Stadt Beer-Seba bis auf den heutigen Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Da Esau vierzig Jahre alt war, nahm er zum Weibe Judith, die Tochter Beeris, des Hethiters, und Basmath, die Tochter Elons, des Hethiters. ");
INSERT INTO deu1912_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Die machten beide Isaak und Rebekka eitel Herzeleid. ");
INSERT INTO deu1912_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Und es begab sich, da Isaak alt war geworden und seine Augen dunkel wurden zu sehen, rief er Esau, seinen älteren Sohn, und sprach zu ihm: Mein Sohn! Er aber antwortete ihm: Hier bin ich. ");
INSERT INTO deu1912_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Und er sprach: Siehe, ich bin alt geworden und weiß nicht, wann ich sterben soll. ");
INSERT INTO deu1912_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","So nimm nun dein Geräte, Köcher und Bogen, und geh aufs Feld und fange mir ein Wildbret ");
INSERT INTO deu1912_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","und mache mir ein Essen, wie ich's gern habe, und bringe mir's herein, daß ich esse, daß dich meine Seele segne, ehe ich sterbe. ");
INSERT INTO deu1912_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekka aber hörte solche Worte, die Isaak zu seinem Sohn Esau sagte. Und Esau ging hin aufs Feld, daß er ein Wildbret jagte und heimbrächte. ");
INSERT INTO deu1912_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Da sprach Rebekka zu Jakob, ihrem Sohn: Siehe, ich habe gehört deinen Vater reden mit Esau, deinem Bruder, und sagen: ");
INSERT INTO deu1912_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Bringe mir ein Wildbret und mache mir ein Essen, daß ich esse und dich segne vor dem HERRN, ehe ich sterbe. ");
INSERT INTO deu1912_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","So höre nun, mein Sohn, meine Stimme, was ich dich heiße. ");
INSERT INTO deu1912_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gehe hin zur Herde und hole mir zwei gute Böcklein, daß ich deinem Vater ein Essen davon mache, wie er's gerne hat. ");
INSERT INTO deu1912_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Das sollst du deinem Vater hineintragen, daß er esse, auf daß er dich segne vor seinem Tode. ");
INSERT INTO deu1912_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakob aber sprach zu seiner Mutter Rebekka: Siehe, mein Bruder Esau ist rauh, und ich glatt; ");
INSERT INTO deu1912_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","so möchte vielleicht mein Vater mich betasten, und ich würde vor ihm geachtet, als ob ich ihn betrügen wollte, und brächte über mich einen Fluch und nicht einen Segen. ");
INSERT INTO deu1912_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Da sprach seine Mutter zu ihm: Der Fluch sei auf mir, mein Sohn; gehorche nur meiner Stimme, gehe und hole mir. ");
INSERT INTO deu1912_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Da ging er hin und holte und brachte es seiner Mutter. Da machte seine Mutter ein Essen, wie es sein Vater gern hatte, ");
INSERT INTO deu1912_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","und nahm Esaus, ihres älteren Sohnes, köstliche Kleider, die sie bei sich im Hause hatte, und zog sie Jakob an, ihrem jüngeren Sohn; ");
INSERT INTO deu1912_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","aber die Felle von den Böcklein tat sie um seine Hände, und wo er glatt war am Halse, ");
INSERT INTO deu1912_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","und gab also das Essen mit Brot, wie sie es gemacht hatte, in Jakobs Hand, ihres Sohnes. ");
INSERT INTO deu1912_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Und er ging hinein zu seinem Vater und sprach: Mein Vater! Er antwortete: Hier bin ich. Wer bist du, mein Sohn? ");
INSERT INTO deu1912_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakob sprach zu seinem Vater: Ich bin Esau, dein erstgeborener Sohn; ich habe getan, wie du mir gesagt hast. Steh auf, setze dich und iß von meinem Wildbret, auf daß mich deine Seele segne. ");
INSERT INTO deu1912_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaak aber sprach zu seinem Sohn: Mein Sohn, wie hast du so bald gefunden? Er antwortete: Der HERR, dein Gott, bescherte mir's. ");
INSERT INTO deu1912_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Da sprach Isaak zu Jakob: Tritt herzu, mein Sohn, daß ich dich betaste, ob du mein Sohn Esau seiest oder nicht. ");
INSERT INTO deu1912_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Also trat Jakob zu seinem Vater Isaak; und da er ihn betastet hatte, sprach er: Die Stimme ist Jakobs Stimme, aber die Hände sind Esaus Hände. ");
INSERT INTO deu1912_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Und er kannte ihn nicht; denn seine Hände waren rauh wie Esaus, seines Bruders, Hände. Und er segnete ihn ");
INSERT INTO deu1912_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","und sprach zu ihm: Bist du mein Sohn Esau? Er antwortete: Ja, ich bin's. ");
INSERT INTO deu1912_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Da sprach er: So bringe mir her, mein Sohn, zu essen von deinem Wildbret, daß dich meine Seele segne. Da brachte er's ihm, und er aß, und trug ihm auch Wein hinein, und er trank. ");
INSERT INTO deu1912_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Und Isaak, sein Vater, sprach zu ihm: Komm her und küsse mich, mein Sohn. ");
INSERT INTO deu1912_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Er trat hinzu und küßte ihn. Da roch er den Geruch seiner Kleider und segnete ihn und sprach: Siehe, der Geruch meines Sohnes ist wie ein Geruch des Feldes, das der HERR gesegnet hat. ");
INSERT INTO deu1912_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Gott gebe dir vom Tau des Himmels und von der Fettigkeit der Erde und Korn und Wein die Fülle. ");
INSERT INTO deu1912_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Völker müssen dir dienen, und Leute müssen dir zu Fuße fallen. Sei ein Herr über deine Brüder, und deiner Mutter Kinder müssen dir zu Fuße fallen. Verflucht sei, wer dir flucht; gesegnet sei, wer dich segnet. ");
INSERT INTO deu1912_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Als nun Isaak vollendet hatte den Segen über Jakob, und Jakob kaum hinausgegangen war von seinem Vater Isaak, da kam Esau, sein Bruder, von seiner Jagd ");
INSERT INTO deu1912_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","und machte auch ein Essen und trug's hinein zu seinem Vater und sprach zu ihm: Steh auf, mein Vater, und iß von dem Wildbret deines Sohnes, daß mich deine Seele segne. ");
INSERT INTO deu1912_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Da antwortete ihm Isaak, sein Vater: Wer bist du? Er sprach: Ich bin Esau, dein erstgeborener Sohn. ");
INSERT INTO deu1912_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Da entsetzte sich Isaak über die Maßen sehr und sprach: Wer ist denn der Jäger, der mir gebracht hat, und ich habe von allem gegessen, ehe du kamst, und habe ihn gesegnet? Er wird auch gesegnet bleiben. ");
INSERT INTO deu1912_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Als Esau diese Rede seines Vaters hörte, schrie er laut und ward über die Maßen sehr betrübt und sprach zu seinem Vater: Segne mich auch, mein Vater! ");
INSERT INTO deu1912_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Er aber sprach: Dein Bruder ist gekommen mit List und hat deinen Segen hinweg. ");
INSERT INTO deu1912_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Da sprach er: Er heißt wohl Jakob; denn er hat mich nun zweimal überlistet. Meine Erstgeburt hat er dahin; und siehe, nun nimmt er auch meinen Segen. Und sprach: Hast du mir denn keinen Segen vorbehalten? ");
INSERT INTO deu1912_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaak antwortete und sprach zu ihm: Ich habe ihn zu Herrn über dich gesetzt, und alle seine Brüder habe ich ihm zu Knechten gemacht, mit Korn und Wein habe ich ihn versehen; was soll ich doch dir nun tun, mein Sohn? ");
INSERT INTO deu1912_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau sprach zu seinem Vater: Hast du denn nur einen Segen, mein Vater? Segne mich auch, mein Vater! und hob auf seine Stimme und weinte. ");
INSERT INTO deu1912_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Da antwortete Isaak, sein Vater, und sprach zu ihm: Siehe da, du wirst eine Wohnung haben ohne Fettigkeit der Erde und ohne Tau des Himmels von obenher. ");
INSERT INTO deu1912_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Von deinem Schwerte wirst du dich nähren und deinem Bruder dienen. Und es wird geschehen, daß du auch ein Herr sein und sein Joch von deinem Halse reißen wirst. ");
INSERT INTO deu1912_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Und Esau war Jakob gram um des Segens willen, mit dem ihn sein Vater gesegnet hatte, und sprach in seinem Herzen: Es wird die Zeit bald kommen, da man um meinen Vater Leid tragen muß; dann will ich meinen Bruder Jakob erwürgen. ");
INSERT INTO deu1912_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Da wurden Rebekka angesagt diese Worte ihres älteren Sohnes Esau; und sie schickte hin und ließ Jakob, ihren jüngeren Sohn, rufen und sprach zu ihm: Siehe, dein Bruder Esau droht dir, daß er dich erwürgen will. ");
INSERT INTO deu1912_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Und nun höre meine Stimme, mein Sohn: Mache dich auf und fliehe zu meinem Bruder Laban gen Haran ");
INSERT INTO deu1912_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","und bleib eine Weile bei ihm, bis sich der Grimm deines Bruders legt ");
INSERT INTO deu1912_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","und bis sich sein Zorn wider dich von dir wendet und er vergißt, was du an ihm getan hast; so will ich darnach schicken und dich von dannen holen lassen. Warum sollte ich euer beider beraubt werden auf einen Tag? ");
INSERT INTO deu1912_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Und Rebekka sprach zu Isaak: Mich verdrießt, zu leben vor den Töchter Heth. Wo Jakob ein Weib nimmt von den Töchter Heth wie diese, von den Töchtern des Landes, was soll mir das Leben? ");
INSERT INTO deu1912_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Da rief Isaak seinen Sohn Jakob und segnete ihn und gebot ihm und sprach zu ihm: Nimm nicht ein Weib von den Töchtern Kanaans; ");
INSERT INTO deu1912_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","sondern mache dich auf und ziehe nach Mesopotamien zum Hause Bethuels, des Vaters deiner Mutter, und nimm dir ein Weib daselbst von den Töchtern Labans, des Bruders deiner Mutter. ");
INSERT INTO deu1912_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Aber der allmächtige Gott segne dich und mache dich fruchtbar und mehre dich, daß du werdest ein Haufe Völker, ");
INSERT INTO deu1912_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","und gebe dir den Segen Abrahams, dir und deinem Samen mit dir, daß du besitzest das Land, darin du ein Fremdling bist, das Gott Abraham gegeben hat. ");
INSERT INTO deu1912_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Also fertigte Isaak den Jakob ab, daß er nach Mesopotamien zog zu Laban, Bethuels Sohn, in Syrien, dem Bruder Rebekkas, seiner und Esaus Mutter. ");
INSERT INTO deu1912_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Als nun Esau sah, daß Isaak Jakob gesegnet hatte und abgefertigt nach Mesopotamien, daß er daselbst ein Weib nähme, und daß er, indem er ihn segnete, ihm gebot und sprach: Du sollst nicht ein Weib nehmen von den Töchtern Kanaans, ");
INSERT INTO deu1912_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","und daß Jakob seinem Vater und seiner Mutter gehorchte und nach Mesopotamien zog, ");
INSERT INTO deu1912_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","sah auch, daß Isaak, sein Vater, nicht gerne sah die Töchter Kanaans: ");
INSERT INTO deu1912_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ging er hin zu Ismael und nahm zu den Weibern, die er zuvor hatte, Mahalath, die Tochter Ismaels, des Sohnes Abrahams, die Schwester Nebajoths, zum Weibe. ");
INSERT INTO deu1912_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Aber Jakob zog aus von Beer-Seba und reiste gen Haran ");
INSERT INTO deu1912_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","und kam an einen Ort, da blieb er über Nacht; denn die Sonne war untergegangen. Und er nahm einen Stein des Orts und legte ihn zu seinen Häupten und legte sich an dem Ort schlafen. ");
INSERT INTO deu1912_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Und ihm träumte; und siehe, eine Leiter stand auf der Erde, die rührte mit der Spitze an den Himmel, und siehe, die Engel Gottes stiegen daran auf und nieder; ");
INSERT INTO deu1912_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","und der HERR stand obendarauf und sprach: Ich bin der HERR, Abrahams, deines Vaters, Gott und Isaaks Gott; das Land darauf du liegst, will ich dir und deinem Samen geben. ");
INSERT INTO deu1912_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Und dein Same soll werden wie der Staub auf Erden, und du sollst ausgebreitet werden gegen Abend, Morgen, Mitternacht und Mittag; und durch dich und deinen Samen sollen alle Geschlechter auf Erden gesegnet werden. ");
INSERT INTO deu1912_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Und siehe, ich bin mit dir und will dich behüten, wo du hin ziehst, und will dich wieder herbringen in dies Land. Denn ich will dich nicht lassen, bis daß ich tue alles, was ich dir geredet habe. ");
INSERT INTO deu1912_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Da nun Jakob von seinem Schlaf aufwachte, sprach er: Gewiß ist der HERR an diesem Ort, und ich wußte es nicht; ");
INSERT INTO deu1912_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","und fürchtete sich und sprach: Wie heilig ist diese Stätte! Hier ist nichts anderes als Gottes Haus, und hier ist die Pforte des Himmels. ");
INSERT INTO deu1912_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Und Jakob stand des Morgens früh auf und nahm den Stein, den er zu seinen Häupten gelegt hatte, und richtete ihn auf zu einem Mal und goß Öl obendarauf ");
INSERT INTO deu1912_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","und hieß die Stätte Beth-El; zuvor aber hieß die Stadt Lus. ");
INSERT INTO deu1912_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Und Jakob tat ein Gelübde und sprach: So Gott wird mit mir sein und mich behüten auf dem Wege, den ich reise, und mir Brot zu essen geben und Kleider anzuziehen ");
INSERT INTO deu1912_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","und mich in Frieden wieder heim zu meinem Vater bringen, so soll der HERR mein Gott sein; ");
INSERT INTO deu1912_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","und dieser Stein, den ich aufgerichtet habe zu einem Mal, soll ein Gotteshaus werden; und von allem, was du mir gibst, will ich dir den Zehnten geben. ");
INSERT INTO deu1912_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Da hob Jakob seine Füße auf und ging in das Land, das gegen Morgen liegt, ");
INSERT INTO deu1912_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","und sah sich um, und siehe, da war ein Brunnen auf dem Felde, und siehe, drei Herden Schafe lagen dabei; denn von dem Brunnen pflegten sie die Herden zu tränken, und ein großer Stein lag vor dem Loch des Brunnens. ");
INSERT INTO deu1912_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Und sie pflegten die Herden alle daselbst zu versammeln und den Stein von dem Brunnenloch zu wälzen und die Schafe zu tränken und taten alsdann den Stein wieder vor das Loch an seine Stätte. ");
INSERT INTO deu1912_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Und Jakob sprach zu ihnen: Liebe Brüder, wo seid ihr her? Sie antworteten: Wir sind von Haran. ");
INSERT INTO deu1912_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Er sprach zu ihnen: Kennt ihr auch Laban, den Sohn Nahors? Sie antworteten: Wir kennen ihn wohl. ");
INSERT INTO deu1912_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Er sprach: Geht es ihm auch wohl? Sie antworteten: Es geht ihm wohl; und siehe, da kommt seine Tochter Rahel mit den Schafen. ");
INSERT INTO deu1912_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Er sprach: Es ist noch hoher Tag und ist noch nicht Zeit das Vieh einzutreiben; tränkt doch die Schafe und geht hin und weidet sie. ");
INSERT INTO deu1912_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Sie antworteten: Wir können nicht, bis daß alle Herden zusammengebracht werden und wir den Stein von des Brunnens Loch wälzen und also die Schafe tränken. ");
INSERT INTO deu1912_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Als er noch mit ihnen redete, kam Rahel mit den Schafen ihres Vaters; denn sie hütete die Schafe. ");
INSERT INTO deu1912_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Da aber Jakob sah Rahel, die Tochter Labans, des Bruders seiner Mutter, und die Schafe Labans, des Bruders seiner Mutter, trat er hinzu und wälzte den Stein von dem Loch des Brunnens und tränkte die Schafe Labans, des Bruders seiner Mutter. ");
INSERT INTO deu1912_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Und er küßte Rahel und weinte laut ");
INSERT INTO deu1912_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","und sagte ihr an, daß er ihres Vaters Bruder wäre und Rebekkas Sohn. Da lief sie und sagte es ihrem Vater an. ");
INSERT INTO deu1912_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Da aber Laban hörte von Jakob, seiner Schwester Sohn, lief er ihm entgegen und herzte und küßte ihn und führte ihn in sein Haus. Da erzählte er dem Laban alle diese Sachen. ");
INSERT INTO deu1912_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Da sprach Laban zu ihm: Wohlan, du bist mein Bein und mein Fleisch. Und da er einen Monat lang bei ihm gewesen war, ");
INSERT INTO deu1912_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","sprach Laban zu Jakob: Wiewohl du mein Bruder bist, solltest du mir darum umsonst dienen? Sage an, was soll dein Lohn sein? ");
INSERT INTO deu1912_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban aber hatte zwei Töchter; die ältere hieß Lea und die jüngere Rahel. ");
INSERT INTO deu1912_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Aber Lea hatte ein blödes Gesicht, Rahel war hübsch und schön. ");
INSERT INTO deu1912_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Und Jakob gewann die Rahel lieb und sprach: Ich will dir sieben Jahre um Rahel, deine jüngere Tochter, dienen. ");
INSERT INTO deu1912_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban antwortete: Es ist besser, ich gebe sie dir als einem andern; bleibe bei mir. ");
INSERT INTO deu1912_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Also diente Jakob um Rahel sieben Jahre, und sie deuchten ihn, als wären's einzelne Tage, so lieb hatte er sie. ");
INSERT INTO deu1912_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Und Jakob sprach zu Laban: Gib mir nun mein Weib, denn die Zeit ist hier, daß ich zu ihr gehe. ");
INSERT INTO deu1912_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Da lud Laban alle Leute des Orts und machte ein Hochzeitsmahl. ");
INSERT INTO deu1912_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Des Abends aber nahm er seine Tochter Lea und brachte sie zu ihm; und er ging zu ihr. ");
INSERT INTO deu1912_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Und Laban gab seiner Tochter Lea seine Magd Silpa zur Magd. ");
INSERT INTO deu1912_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Des Morgens aber, siehe, da war es Lea. Und er sprach zu Laban: Warum hast du mir das getan? Habe ich dir nicht um Rahel gedient? Warum hast du mich denn betrogen? ");
INSERT INTO deu1912_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban antwortete: Es ist nicht Sitte in unserm lande, daß man die jüngere ausgebe vor der älteren. ");
INSERT INTO deu1912_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Halte mit dieser die Woche aus, so will ich dir diese auch geben um den Dienst, den du bei mir noch andere sieben Jahre dienen sollst. ");
INSERT INTO deu1912_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakob tat also und hielt die Woche aus. Da gab ihm Laban Rahel, seine Tochter, zum Weibe ");
INSERT INTO deu1912_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","und gab seiner Tochter Rahel seine Magd Bilha zur Magd. ");
INSERT INTO deu1912_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Also ging er auch zu Rahel ein, und hatte Rahel lieber als Lea; und diente bei ihm fürder die andern sieben Jahre. ");
INSERT INTO deu1912_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Da aber der HERR sah, daß Lea unwert war, machte er sie fruchtbar; Rahel aber war unfruchtbar. ");
INSERT INTO deu1912_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Und Lea ward schwanger und gebar einen Sohn; den hieß sie Ruben, und sprach: Der HERR hat angesehen mein Elend; nun wird mich mein Mann liebhaben. ");
INSERT INTO deu1912_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Und ward abermals schwanger und gebar einen Sohn und sprach: Der HERR hat gehört, daß ich unwert bin, und hat mir diesen auch gegeben. Und sie hieß ihn Simeon. ");
INSERT INTO deu1912_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Abermals ward sie schwanger und gebar einen Sohn und sprach: Nun wird mein Mann mir doch zugetan sein, denn ich habe ihm drei Söhne geboren. Darum hieß sie ihn Levi. ");
INSERT INTO deu1912_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Zum vierten ward sie schwanger und gebar einen Sohn und sprach: Nun will ich dem HERRN danken. Darum hieß sie ihn Juda. Und hörte auf, Kinder zu gebären. ");
INSERT INTO deu1912_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Da Rahel sah, daß sie dem Jakob kein Kind gebar, beneidete sie ihre Schwester und sprach zu Jakob: Schaffe mir Kinder, wo nicht, so sterbe ich. ");
INSERT INTO deu1912_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakob aber ward sehr zornig auf Rahel und sprach: Bin ich doch nicht Gott, der dir deines Leibes Frucht nicht geben will. ");
INSERT INTO deu1912_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Sie aber sprach: Siehe, da ist meine Magd Bilha; gehe zu ihr, daß sie auf meinen Schoß gebäre und ich doch durch sie aufgebaut werde. ");
INSERT INTO deu1912_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Und sie gab ihm also Bilha, ihre Magd, zum Weibe, und Jakob ging zu ihr. ");
INSERT INTO deu1912_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Also ward Bilha schwanger und gebar Jakob einen Sohn. ");
INSERT INTO deu1912_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Da sprach Rahel: Gott hat meine Sache gerichtet und meine Stimme erhört und mir einen Sohn gegeben. Darum hieß sie ihn Dan. ");
INSERT INTO deu1912_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Abermals ward Bilha, Rahels Magd, schwanger und gebar Jakob den andern Sohn. ");
INSERT INTO deu1912_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Da sprach Rahel: Gott hat es gewandt mit mir und meiner Schwester, und ich werde es ihr zuvortun. Und hieß ihn Naphthali. ");
INSERT INTO deu1912_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Da nun Lea sah, daß sie aufgehört hatte zu gebären, nahm sie ihre Magd Silpa und gab sie Jakob zum Weibe. ");
INSERT INTO deu1912_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Also gebar Silpa, Leas Magd, Jakob einen Sohn. ");
INSERT INTO deu1912_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Da sprach Lea: Rüstig! Und hieß ihn Gad. ");
INSERT INTO deu1912_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Darnach gebar Silpa, Leas Magd, Jakob den andern Sohn. ");
INSERT INTO deu1912_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Da sprach Lea: Wohl mir! denn mich werden selig preisen die Töchter. Und hieß ihn Asser. ");
INSERT INTO deu1912_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruben ging aus zur Zeit der Weizenernte und fand Liebesäpfel auf dem Felde und brachte sie heim seiner Mutter Lea. Da sprach Rahel zu Lea: Gib mir von den Liebesäpfeln deines Sohnes einen Teil. ");
INSERT INTO deu1912_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sie antwortete: Hast du nicht genug, daß du mir meinen Mann genommen hast, und willst auch die Liebesäpfel meines Sohnes nehmen? Rahel sprach: Wohlan, laß ihn diese Nacht bei dir schlafen um die Liebesäpfel deines Sohnes. ");
INSERT INTO deu1912_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Da nun Jakob des Abends vom Felde kam, ging ihm Lea hinaus entgegen und sprach: Zu mir sollst du kommen; denn ich habe dich erkauft um die Liebesäpfel meines Sohnes. Und er schlief die Nacht bei ihr. ");
INSERT INTO deu1912_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Und Gott erhörte Lea, und sie ward schwanger und gebar Jakob den fünften Sohn ");
INSERT INTO deu1912_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","und sprach Gott hat mir gelohnt, daß ich meine Magd meinem Manne gegeben habe. Und hieß ihn Isaschar. ");
INSERT INTO deu1912_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Abermals ward Lea schwanger und gebar Jakob den sechsten Sohn, ");
INSERT INTO deu1912_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","und sprach: Gott hat mich wohl beraten; nun wird mein Mann doch bei mir wohnen, denn ich habe ihm sechs Söhne geboren. Und hieß ihn Sebulon. ");
INSERT INTO deu1912_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Darnach gebar sie eine Tochter, die hieß sie Dina. ");
INSERT INTO deu1912_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Gott gedachte aber an Rahel und erhörte sie und machte sie fruchtbar. ");
INSERT INTO deu1912_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Da ward sie schwanger und gebar einen Sohn und sprach: Gott hat meine Schmach von mir genommen. ");
INSERT INTO deu1912_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Und hieß ihn Joseph und sprach: Der HERR wolle mir noch einen Sohn dazugeben! ");
INSERT INTO deu1912_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Da nun Rahel den Joseph geboren hatte, sprach Jakob zu Laban: Laß mich ziehen und reisen an meinen Ort in mein Land. ");
INSERT INTO deu1912_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Gib mir meine Weiber und meine Kinder um die ich dir gedient habe, daß ich ziehe; denn du weißt, wie ich dir gedient habe. ");
INSERT INTO deu1912_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban sprach zu ihm: Laß mich Gnade vor deinen Augen finden. Ich spüre, daß mich der HERR segnet um deinetwillen; ");
INSERT INTO deu1912_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","bestimme den Lohn, den ich dir geben soll. ");
INSERT INTO deu1912_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Er aber sprach zu ihm: Du weißt, wie ich dir gedient habe und was du für Vieh hast unter mir. ");
INSERT INTO deu1912_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Du hattest wenig, ehe ich her kam, nun aber ist's ausgebreitet in die Menge, und der HERR hat dich gesegnet durch meinen Fuß. Und nun, wann soll ich auch mein Haus versorgen? ");
INSERT INTO deu1912_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Er aber sprach: Was soll ich dir denn geben? Jakob sprach: Du sollst mir nichts geben; sondern so du mir tun willst, was ich sage, so will ich wiederum weiden und hüten deine Schafe. ");
INSERT INTO deu1912_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ich will heute durch alle deine Herden gehen und aussondern alle gefleckten und bunten Schafe und alle schwarzen Schafe und die bunten und gefleckten Ziegen. Was nun bunt und gefleckt fallen wird, das soll mein Lohn sein. ");
INSERT INTO deu1912_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","So wird meine Gerechtigkeit zeugen heute oder morgen, wenn es kommt, daß ich meinen Lohn von dir nehmen soll; also daß, was nicht gefleckt oder bunt unter den Ziegen und nicht schwarz sein wird unter den Lämmern, das sei ein Diebstahl bei mir. ");
INSERT INTO deu1912_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Da sprach Laban: Siehe da, es sei, wie du gesagt hast. ");
INSERT INTO deu1912_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Und sonderte des Tages die sprenkligen und bunten Böcke und alle gefleckten und bunten Ziegen, wo nur was Weißes daran war, und alles, was schwarz war unter den Lämmern, und tat's unter die Hand seiner Kinder ");
INSERT INTO deu1912_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","und machte Raum drei Tagereisen weit zwischen sich und Jakob. Also weidete Jakob die übrigen Herden Labans. ");
INSERT INTO deu1912_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jakob aber nahm Stäbe von grünen Pappelbäumen, Haseln und Kastanien und schälte weiße Streifen daran, daß an den Stäben das Weiß bloß ward, ");
INSERT INTO deu1912_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","und legte die Stäbe, die er geschält hatte, in die Tränkrinnen vor die Herden, die kommen mußten, zu trinken, daß sie da empfangen sollten, wenn sie zu trinken kämen. ");
INSERT INTO deu1912_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Also empfingen die Herden über den Stäben und brachten Sprenklinge, Gefleckte und Bunte. ");
INSERT INTO deu1912_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Da schied Jakob die Lämmer und richtete die Herde mit dem Angesicht gegen die Gefleckten und Schwarzen in der Herde Labans und machte sich eine eigene Herde, die tat er nicht zu der Herde Labans. ");
INSERT INTO deu1912_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wenn aber der Lauf der Frühling-Herde war, legte er die Stäbe in die Rinnen vor die Augen der Herde, daß sie über den Stäben empfingen; ");
INSERT INTO deu1912_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","aber in der Spätlinge Lauf legte er sie nicht hinein. Also wurden die Spätlinge des Laban, aber die Frühlinge des Jakob. ");
INSERT INTO deu1912_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Daher ward der Mann über die Maßen reich, daß er viele Schafe, Mägde und Knechte, Kamele und Esel hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Und es kamen vor ihn die Reden der Kinder Labans, daß sie sprachen: Jakob hat alles Gut unsers Vaters an sich gebracht, und von unsers Vaters Gut hat er solchen Reichtum zuwege gebracht. ");
INSERT INTO deu1912_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Und Jakob sah an das Angesicht Labans; und siehe, es war nicht gegen ihn wie gestern und ehegestern. ");
INSERT INTO deu1912_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Und der HERR sprach zu Jakob: Ziehe wieder in deiner Väter Land und zu deiner Freundschaft; ich will mit dir sein. ");
INSERT INTO deu1912_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Da sandte Jakob hin und ließ rufen Rahel und Lea aufs Feld zu seiner Herde ");
INSERT INTO deu1912_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","und sprach zu ihnen: Ich sehe eures Vaters Angesicht, daß es nicht gegen mich ist wie gestern und ehegestern; aber der Gott meines Vaters ist mit mir gewesen. ");
INSERT INTO deu1912_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Und ihr wißt, daß ich aus allen meinen Kräften eurem Vater gedient habe. ");
INSERT INTO deu1912_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Und er hat mich getäuscht und nun zehnmal meinen Lohn verändert; aber Gott hat ihm nicht gestattet, daß er mir Schaden täte. ");
INSERT INTO deu1912_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wenn er sprach: Die Bunten sollen dein Lohn sein, so trug die ganze Herde Bunte. Wenn er aber sprach: Die Sprenkligen sollen dein Lohn sein, so trug die ganze Herde Sprenklinge. ");
INSERT INTO deu1912_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Also hat Gott die Güter eures Vaters ihm entwandt und mir gegeben. ");
INSERT INTO deu1912_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Denn wenn die Zeit des Laufs kam, hob ich meine Augen auf und sah im Traum, und siehe, die Böcke, die auf die Herde sprangen, waren sprenklig, gefleckt und bunt. ");
INSERT INTO deu1912_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Und der Engel Gottes sprach zu mir im Traum: Jakob! Und ich antwortete: Hier bin ich. ");
INSERT INTO deu1912_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Er aber sprach: Hebe deine Augen, und siehe, alle Böcke, die auf die Herde springen, sind sprenklig, gefleckt und bunt; denn ich habe alles gesehen, was dir Laban tut. ");
INSERT INTO deu1912_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ich bin der Gott zu Beth-El, da du den Stein gesalbt hast und mir daselbst ein Gelübde getan. Nun mache dich auf und zieh aus diesem Land und zieh wieder in das Land deiner Freundschaft. ");
INSERT INTO deu1912_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Da antworteten Rahel und Lea und sprachen zu ihm: Wir haben doch kein Teil noch Erbe mehr in unsers Vaters Hause. ");
INSERT INTO deu1912_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Hat er uns doch gehalten wie die Fremden; denn er hat uns verkauft und unsern Lohn verzehrt; ");
INSERT INTO deu1912_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","darum hat Gott unserm Vater entwandt seinen Reichtum zu uns und unsern Kindern. Alles nun, was Gott dir gesagt hat, das tue. ");
INSERT INTO deu1912_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Also machte sich Jakob auf und lud seine Kinder und Weiber auf Kamele ");
INSERT INTO deu1912_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","und führte weg all sein Vieh und alle seine Habe, die er zu Mesopotamien erworben hatte, daß er käme zu Isaak, seinem Vater, ins Land Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","(Laban aber war gegangen sein Herde zu scheren.) Und Rahel stahl ihres Vaters Götzen. ");
INSERT INTO deu1912_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Also täuschte Jakob den Laban zu Syrien damit, daß er ihm nicht ansagte, daß er floh. ");
INSERT INTO deu1912_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Also floh er und alles, was sein war, machte sich auf und fuhr über den Strom und richtete sich nach dem Berge Gilead. ");
INSERT INTO deu1912_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Am dritten Tage ward Laban angesagt, daß Jakob geflohen wäre. ");
INSERT INTO deu1912_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Und er nahm seine Brüder zu sich und jagte ihm nach sieben Tagereisen und ereilte ihn auf dem Berge Gilead. ");
INSERT INTO deu1912_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Aber Gott kam zu Laban, dem Syrer, im Traum des Nachts und sprach zu ihm: Hüte dich, daß du mit Jakob nicht anders redest als freundlich. ");
INSERT INTO deu1912_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Und Laban nahte zu Jakob. Jakob aber hatte seine Hütte aufgeschlagen auf dem Berge; und Laban mit seinen Brüdern schlug seine Hütte auch auf auf dem Berge Gilead. ");
INSERT INTO deu1912_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Da sprach Laban zu Jakob: Was hast du getan, daß du mich getäuscht hast und hast meine Töchter entführt, als wenn sie durchs Schwert gefangen wären? ");
INSERT INTO deu1912_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Warum bist du heimlich geflohen und hast dich weggestohlen und hast mir's nicht angesagt, daß ich dich hätte geleitet mit Freuden, mit Singen mit Pauken und Harfen? ");
INSERT INTO deu1912_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Und hast mich nicht lassen meine Kinder und Töchter küssen? Nun, du hast töricht getan. ");
INSERT INTO deu1912_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Und ich hätte wohl so viel Macht, daß ich euch könnte Übles tun; aber eures Vaters Gott hat gestern zu mir gesagt: Hüte dich, daß du mit Jakob nicht anders als freundlich redest. ");
INSERT INTO deu1912_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Und weil du denn ja wolltest ziehen und sehntest dich so sehr nach deines Vaters Hause, warum hast du mir meine Götter gestohlen? ");
INSERT INTO deu1912_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakob antwortete und sprach zu Laban: Ich fürchtete mich und dachte, du würdest deine Töchter von mir reißen. ");
INSERT INTO deu1912_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Bei welchem du aber deine Götter findest, der sterbe hier vor unsern Brüdern. Suche das Deine bei mir und nimm's hin. Jakob wußte aber nicht, daß sie Rahel gestohlen hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Da ging Laban in die Hütten Jakobs und Leas und der beiden Mägde, und fand nichts; und ging aus der Hütte Leas in die Hütte Rahels. ");
INSERT INTO deu1912_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Da nahm Rahel die Götzen und legte sie unter den Kamelsattel und setzte sich darauf. Laban aber betastete die ganze Hütte und fand nichts. ");
INSERT INTO deu1912_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Da sprach sie zu ihrem Vater: Mein Herr, zürne mir nicht, denn ich kann nicht aufstehen vor dir, denn es geht mir nach der Frauen Weise. Also fand er die Götzen nicht, wie sehr er suchte. ");
INSERT INTO deu1912_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Und Jakob ward zornig und schalt Laban und sprach zu ihm: Was habe ich mißgehandelt oder gesündigt, daß du so auf mich erhitzt bist? ");
INSERT INTO deu1912_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Du hast allen meinen Hausrat betastet. Was hast du von meinem Hausrat gefunden? Lege das dar vor meinen und deinen Brüdern, daß sie zwischen uns beiden richten. ");
INSERT INTO deu1912_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Diese zwanzig Jahre bin ich bei dir gewesen, deine Schafe und Ziegen sind nicht unfruchtbar gewesen; die Widder deiner Herde habe ich nie gegessen; ");
INSERT INTO deu1912_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","was die Tiere zerrissen, brachte ich dir nicht, ich mußte es bezahlen; du fordertest es von meiner Hand, es mochte mir des Tages oder des Nachts gestohlen sein. ");
INSERT INTO deu1912_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Des Tages verschmachtete ich vor Hitze und des Nachts vor Frost, und kam kein Schlaf in meine Augen. ");
INSERT INTO deu1912_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Also habe ich diese zwanzig Jahre in deinem Hause gedient, vierzehn um deine Töchter und sechs um deine Herde, und du hast mir meinen Lohn zehnmal verändert. ");
INSERT INTO deu1912_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Wo nicht der Gott meines Vaters, der Gott Abrahams und die Furcht Isaaks, auf meiner Seite gewesen wäre, du hättest mich leer lassen ziehen. Aber Gott hat mein Elend und meine Mühe angesehen und hat dich gestern gestraft. ");
INSERT INTO deu1912_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban antwortete und sprach zu Jakob: Die Töchter sind meine Töchter, und die Kinder sind meine Kinder, und die Herden sind meine Herden, und alles, was du siehst, ist mein. Was kann ich meinen Töchtern heute oder ihren Kindern tun, die sie geboren haben? ");
INSERT INTO deu1912_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","So komm nun und laß uns einen Bund machen, ich und du, der ein Zeugnis sei zwischen mir und dir. ");
INSERT INTO deu1912_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Da nahm Jakob einen Stein und richtete ihn auf zu einem Mal. ");
INSERT INTO deu1912_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","und sprach zu seinen Brüdern: Leset Steine auf! Und sie nahmen Steine und machten einen Haufen und aßen auf dem Haufen. ");
INSERT INTO deu1912_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Und Laban hieß ihn Jegar-Sahadutha; Jakob aber hieß ihn Gilead. ");
INSERT INTO deu1912_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Da sprach Laban: Der Haufe sei heute Zeuge zwischen mir und dir (daher heißt man ihn Gilead) ");
INSERT INTO deu1912_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","und sei eine Warte; denn er sprach: Der HERR sehe darein zwischen mir und dir, wenn wir voneinander kommen, ");
INSERT INTO deu1912_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","wo du meine Töchter bedrückst oder andere Weiber dazunimmst über meine Töchter. Es ist kein Mensch hier mit uns; siehe aber, Gott ist der Zeuge zwischen mir und dir. ");
INSERT INTO deu1912_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Und Laban sprach weiter zu Jakob: Siehe, das ist der Haufe, und das ist das Mal, das ich aufgerichtet habe zwischen mir und dir. ");
INSERT INTO deu1912_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Derselbe Haufe sei Zeuge, und das Mal sei auch Zeuge, wenn ich herüberfahre zu dir oder du herüberfährst zu mir über diesen Haufen und dies Mal, zu beschädigen. ");
INSERT INTO deu1912_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Der Gott Abrahams und der Gott Nahors, der Gott ihres Vaters sei Richter zwischen uns. ");
INSERT INTO deu1912_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Und Jakob schwur ihm bei der Furcht seines Vaters Isaak. Und Jakob opferte auf dem Berge und lud seine Brüder zum Essen. Und da sie gegessen hatten, blieben sie auf dem Berge über Nacht. ");
INSERT INTO deu1912_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","32:1 Des Morgens aber stand Laban früh auf, küßte seine Kinder und Töchter und segnete sie und zog hin und kam wieder an seinen Ort. ");
INSERT INTO deu1912_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","32:2 Jakob aber zog seinen Weg; und es begegneten ihm die Engel Gottes. ");
INSERT INTO deu1912_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","32:3 Und da er sie sah, sprach er: Es sind Gottes Heere; und hieß die Stätte Mahanaim. ");
INSERT INTO deu1912_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","32:4 Jakob aber schickte Boten vor sich her zu seinem Bruder Esau ins Land Seir, in die Gegend Edoms, ");
INSERT INTO deu1912_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","32:5 und befahl ihnen und sprach: Also sagt meinem Herrn Esau: Dein Knecht Jakob läßt dir sagen: Ich bin bis daher bei Laban lange außen gewesen ");
INSERT INTO deu1912_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","32:6 und habe Rinder und Esel, Schafe, Knechte und Mägde; und habe ausgesandt, dir, meinem Herrn, anzusagen, daß ich Gnade vor deinen Augen fände. ");
INSERT INTO deu1912_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","32:7 Die Boten kamen wieder zu Jakob und sprachen: Wir kamen zu deinem Bruder Esau; und er zieht dir auch entgegen mit vierhundert Mann. ");
INSERT INTO deu1912_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","32:8 Da fürchtete sich Jakob sehr, und ihm ward bange; und teilte das Volk, das bei ihm war, und die Schafe und die Rinder und die Kamele in zwei Heere ");
INSERT INTO deu1912_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","32:9 und sprach: So Esau kommt auf das eine Heer und schlägt es, so wird das übrige entrinnen. ");
INSERT INTO deu1912_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","32:10 Weiter sprach Jakob: Gott meines Vaters Abraham und Gott meines Vaters Isaak, HERR, der du zu mir gesagt hast: Zieh wieder in dein Land und zu deiner Freundschaft, ich will dir wohltun! ");
INSERT INTO deu1912_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","32:11 ich bin zu gering aller Barmherzigkeit und aller Treue, die du an deinem Knechte getan hast; denn ich hatte nicht mehr als diesen Stab, da ich über den Jordan ging, und nun bin ich zwei Heere geworden. ");
INSERT INTO deu1912_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","32:12 Errette mich von der Hand meines Bruders, von der Hand Esaus; denn ich fürchte mich vor ihm, daß er nicht komme und schlage mich, die Mütter samt den Kindern. ");
INSERT INTO deu1912_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","32:13 Du hast gesagt ich will dir wohltun und deinen Samen machen wie den Sand am Meer, den man nicht zählen kann vor der Menge. ");
INSERT INTO deu1912_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","32:14 Und er blieb die Nacht da und nahm von dem, das er vor Handen hatte, ein Geschenk für seinen Bruder Esau: ");
INSERT INTO deu1912_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","32:15 zweihundert Ziegen, zwanzig Böcke, zweihundert Schafe, zwanzig Widder ");
INSERT INTO deu1912_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","32:16 und dreißig säugende Kamele mit ihren Füllen, vierzig Kühe und zehn Farren, zwanzig Eselinnen mit zehn Füllen, ");
INSERT INTO deu1912_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","32:17 und tat sie unter die Hand seiner Knechte, je eine Herde besonders, und sprach zu ihnen: Gehet vor mir hin und lasset Raum zwischen einer Herde nach der andern; ");
INSERT INTO deu1912_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","32:18 und gebot dem ersten und sprach: Wenn dir mein Bruder Esau begegnet und dich fragt: Wem gehörst du an, und wo willst du hin, und wes ist's, was du vor dir treibst? ");
INSERT INTO deu1912_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","32:19 sollst du sagen: Es gehört deinem Knechte Jakob zu, der sendet Geschenk seinem Herrn Esau und zieht hinter uns her. ");
INSERT INTO deu1912_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","32:20 Also gebot er auch dem andern und dem dritten und allen, die den Herden nachgingen, und sprach: Wie ich euch gesagt habe, so sagt zu Esau, wenn ihr ihm begegnet; ");
INSERT INTO deu1912_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","32:21 und sagt ja auch: Siehe, dein Knecht Jakob ist hinter uns. Denn er gedachte: Ich will ihn versöhnen mit dem Geschenk, das vor mir her geht; darnach will ich ihn sehen, vielleicht wird er mich annehmen. ");
INSERT INTO deu1912_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","32:22 Also ging das Geschenk vor ihm her, aber er blieb dieselbe Nacht beim Heer ");
INSERT INTO deu1912_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","32:23 und stand auf in der Nacht und nahm seine zwei Weiber und die zwei Mägde und seine elf Kinder und zog an die Furt des Jabbok, ");
INSERT INTO deu1912_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","32:24 nahm sie und führte sie über das Wasser, daß hinüberkam, was er hatte, ");
INSERT INTO deu1912_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","32:25 und blieb allein. Da rang ein Mann mit ihm, bis die Morgenröte anbrach. ");
INSERT INTO deu1912_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","32:26 Und da er sah, daß er ihn nicht übermochte, rührte er das Gelenk seiner Hüfte an; und das Gelenk der Hüfte Jakobs ward über dem Ringen mit ihm verrenkt. ");
INSERT INTO deu1912_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","32:27 Und er sprach: Laß mich gehen, denn die Morgenröte bricht an. Aber er antwortete: Ich lasse dich nicht, du segnest mich denn. ");
INSERT INTO deu1912_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","32:28 Er sprach: Wie heißt du? Er antwortete: Jakob. ");
INSERT INTO deu1912_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","32:29 Er sprach: Du sollst nicht mehr Jakob heißen, sondern Israel; denn du hast mit Gott und mit Menschen gekämpft und bist obgelegen. ");
INSERT INTO deu1912_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","32:30 Und Jakob fragte ihn und sprach: Sage doch, wie heißt du? Er aber sprach: Warum fragst du, wie ich heiße? Und er segnete ihn daselbst. ");
INSERT INTO deu1912_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","32:31 Und Jakob hieß die Stätte Pniel; denn ich habe Gott von Angesicht gesehen, und meine Seele ist genesen. ");
INSERT INTO deu1912_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","32:32 Und als er an Pniel vorüberkam, ging ihm die Sonne auf; und er hinkte an seiner Hüfte. ");
INSERT INTO deu1912_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","31:33 Daher essen die Kinder Israel keine Spannader auf dem Gelenk der Hüfte bis auf den heutigen Tag, darum daß die Spannader an dem Gelenk der Hüfte Jakobs angerührt ward. ");
INSERT INTO deu1912_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakob hob seine Augen auf und sah seinen Bruder Esau kommen mit vierhundert Mann. Und er teilte seine Kinder zu Lea und Rahel und zu den beiden Mägden ");
INSERT INTO deu1912_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","und stellte die Mägde mit ihren Kindern vornean und Lea mit ihren Kindern hernach und Rahel mit Joseph zuletzt. ");
INSERT INTO deu1912_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Und er ging vor ihnen her und neigte sich siebenmal auf die Erde, bis er zu seinem Bruder kam. ");
INSERT INTO deu1912_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau aber lief ihm entgegen und herzte ihn und fiel ihm um den Hals und küßte ihn; und sie weinten. ");
INSERT INTO deu1912_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Und er hob seine Augen auf und sah die Weiber mit den Kindern und sprach: Wer sind diese bei dir? Er antwortete: Es sind Kinder, die Gott deinem Knecht beschert hat. ");
INSERT INTO deu1912_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Und die Mägde traten herzu mit ihren Kindern und neigten sich vor ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea trat auch herzu mit ihren Kindern und neigten sich vor ihm. Darnach trat Joseph und Rahel herzu und neigten sich auch vor ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Und er sprach: Was willst du mit all dem Heere, dem ich begegnet bin? Er antwortete: Daß ich Gnade fände vor meinem Herrn. ");
INSERT INTO deu1912_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau sprach: Ich habe genug, mein Bruder; behalte was du hast. ");
INSERT INTO deu1912_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakob antwortete: Ach, nicht! Habe ich Gnade gefunden vor dir, so nimm mein Geschenk von meiner Hand; denn ich sah dein Angesicht, als sähe ich Gottes Angesicht; und laß dir's wohl gefallen von mir. ");
INSERT INTO deu1912_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nimm doch den Segen von mir an, den ich dir zugebracht habe; denn Gott hat mir's beschert, und ich habe alles genug. Also nötigte er ihn, daß er's nahm. ");
INSERT INTO deu1912_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Und er sprach: Laß uns fortziehen und reisen, ich will mit dir ziehen. ");
INSERT INTO deu1912_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Er aber sprach zu ihm: Mein Herr, du erkennest, daß ich zarte Kinder bei mir habe, dazu säugende Schafe und Kühe; wenn sie einen Tag übertrieben würden, würde mir die ganze Herde sterben. ");
INSERT INTO deu1912_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mein Herr ziehe vor seinem Knechte hin. Ich will gemächlich hintennach treiben, nach dem das Vieh und die Kinder gehen können, bis daß ich komme zu meinem Herrn nach Seir. ");
INSERT INTO deu1912_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau sprach: So will ich doch etliche bei dir lassen vom Volk, das mit mir ist. Er antwortete: Was ist's vonnöten? Laß mich nur Gnade vor meinem Herrn finden. ");
INSERT INTO deu1912_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Also zog des Tages Esau wiederum seines Weges gen Seir. ");
INSERT INTO deu1912_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Und Jakob zog gen Sukkoth und baute sich ein Haus und machte seinem Vieh Hütten; daher heißt die Stätte Sukkoth. ");
INSERT INTO deu1912_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Darnach zog Jakob mit Frieden zu der Stadt Sichems, die im Lande Kanaan liegt (nachdem er aus Mesopotamien gekommen war), und machte sein Lager vor der Stadt ");
INSERT INTO deu1912_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","und kaufte ein Stück Acker von den Kindern Hemors, des Vaters Sichems, um hundert Groschen; daselbst richtete er seine Hütte auf. ");
INSERT INTO deu1912_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Und er richtete daselbst einen Altar zu und rief an den Namen des starken Gottes Israels. ");
INSERT INTO deu1912_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina aber, Leas Tochter, die sie Jakob geboren hatte, ging heraus, die Töchter des Landes zu sehen. ");
INSERT INTO deu1912_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Da die sah Sichem, Hemors Sohn, des Heviters, der des Landes Herr war, nahm er sie und lag bei ihr und schwächte sie. ");
INSERT INTO deu1912_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Und sein Herz hing an ihr, und er hatte die Dirne lieb und redete freundlich mit ihr. ");
INSERT INTO deu1912_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Und Sichem sprach zu seinem Vater Hemor: Nimm mir das Mägdlein zum Weibe. ");
INSERT INTO deu1912_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Und Jakob erfuhr, daß seine Tochter Dina geschändet war; und seine Söhne waren mit dem Vieh auf dem Felde, und Jakob schwieg bis daß sie kamen. ");
INSERT INTO deu1912_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Da ging Hemor, Sichems Vater, heraus zu Jakob, mit ihm zu reden. ");
INSERT INTO deu1912_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Indes kamen die Söhne Jakobs vom Felde. Und da sie es hörten, verdroß es die Männer, und sie wurden sehr zornig, daß er eine Torheit an Israel begangen und bei Jakobs Tochter gelegen hatte, denn so sollte es nicht sein. ");
INSERT INTO deu1912_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Da redete Hemor mit ihnen und sprach: Meines Sohnes Sichem Herz sehnt sich nach eurer Tochter; gebt sie ihm doch zum Weibe. ");
INSERT INTO deu1912_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Befreundet euch mit uns; gebt uns eure Töchter und nehmt ihr unsere Töchter ");
INSERT INTO deu1912_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","und wohnt bei uns. Das Land soll euch offen sein; wohnt und werbet und gewinnet darin. ");
INSERT INTO deu1912_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Und Sichem sprach zu ihrem Vater und ihren Brüdern: Laßt uns Gnade bei euch finden; was ihr mir sagt, das will ich euch geben. ");
INSERT INTO deu1912_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Fordert nur getrost von mir Morgengabe und Geschenk, ich will's geben, wie ihr heischt; gebt mir nur die Dirne zum Weibe. ");
INSERT INTO deu1912_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Da antworteten Jakobs Söhne dem Sichem und seinem Vater Hemor betrüglich, darum daß ihre Schwester Dina geschändet war, ");
INSERT INTO deu1912_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","und sprachen zu ihnen: Wir können das nicht tun, daß wir unsere Schwester einem unbeschnittenem Mann geben; denn das wäre uns eine Schande. ");
INSERT INTO deu1912_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Doch dann wollen wir euch zu Willen sein, so ihr uns gleich werdet und alles, was männlich unter euch ist, beschnitten werde; ");
INSERT INTO deu1912_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","dann wollen wir unsere Töchter euch geben und eure Töchter uns nehmen und bei euch wohnen und ein Volk sein. ");
INSERT INTO deu1912_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Wo ihr aber nicht darein willigen wollt, euch zu beschneiden, so wollen wir unsere Tochter nehmen und davonziehen. ");
INSERT INTO deu1912_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Die Rede gefiel Hemor und seinem Sohn wohl. ");
INSERT INTO deu1912_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Und der Jüngling verzog nicht, solches zu tun; denn er hatte Lust zu der Tochter Jakobs. Und er war herrlich gehalten über alle in seines Vaters Hause. ");
INSERT INTO deu1912_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Da kamen sie nun, Hemor und sein Sohn Sichem, unter der Stadt Tor und redeten mit den Bürgern der Stadt und sprachen: ");
INSERT INTO deu1912_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Diese Leute sind friedsam bei uns und wollen im Lande wohnen und werben; so ist nun das Land weit genug für sie. Wir wollen uns ihre Töchter zu Weibern nehmen und ihnen unser Töchter geben. ");
INSERT INTO deu1912_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Aber dann wollen sie uns zu Willen sein, daß sie bei uns wohnen und ein Volk mit uns werden, wo wir alles, was männlich unter uns ist, beschneiden, gleich wie sie beschnitten sind. ");
INSERT INTO deu1912_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ihr Vieh und ihre Güter und alles, was sie haben, wird unser sein, so wir nur ihnen zu Willen werden, daß sie bei uns wohnen. ");
INSERT INTO deu1912_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Und sie gehorchten dem Hemor und Sichem, seinem Sohn, alle, die zu seiner Stadt Tor aus und ein gingen, und beschnitten alles, was männlich war, das zu dieser Stadt aus und ein ging. ");
INSERT INTO deu1912_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Und am dritten Tage, da sie Schmerzen hatten, nahmen die zwei Söhne Jakobs, Simeon und Levi, der Dina Brüder, ein jeglicher sein Schwert und gingen kühn in die Stadt und erwürgten alles, was männlich war. ");
INSERT INTO deu1912_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","und erwürgten auch Hemor und seinen Sohn Sichem mit der Schärfe des Schwerts und nahmen ihre Schwester Dina aus dem Hause Sichems und gingen davon. ");
INSERT INTO deu1912_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Da kamen die Söhne Jakobs über die erschlagenen und plünderten die Stadt, darum daß sie hatten ihre Schwester geschändet. ");
INSERT INTO deu1912_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Und nahmen ihre Schafe, Rinder, Esel und was in der Stadt und auf dem Felde war ");
INSERT INTO deu1912_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","und alle ihre Habe; alle Kinder und Weiber nahmen sie gefangen, und plünderten alles, was in den Häusern war. ");
INSERT INTO deu1912_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Und Jakob sprach zu Simeon und Levi: Ihr habt mir Unglück zugerichtet und mich stinkend gemacht vor den Einwohnern dieses Landes, den Kanaanitern und Pheresitern; und ich bin ein geringer Haufe. Wenn sie sich nun versammeln über mich, so werden sie mich schlagen. Also werde ich vertilgt samt meinem Hause. ");
INSERT INTO deu1912_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Sie antworteten aber: Sollten sie denn mit unsrer Schwester wie mit einer Hure handeln? ");
INSERT INTO deu1912_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Und Gott sprach zu Jakob: Mache dich auf und ziehe gen Beth-El und wohne daselbst und mache daselbst einen Altar dem Gott, der dir erschien, da du flohest vor deinem Bruder Esau. ");
INSERT INTO deu1912_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Da sprach Jakob zu seinem Hause und zu allen, die mit ihm waren: Tut von euch fremde Götter, so unter euch sind, und reinigt euch und ändert eure Kleider ");
INSERT INTO deu1912_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","und laßt uns auf sein und gen Beth-El ziehen, daß ich daselbst einen Altar mache dem Gott, der mich erhört hat zur Zeit meiner Trübsal und ist mit mir gewesen auf dem Wege, den ich gezogen bin. ");
INSERT INTO deu1912_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Da gaben sie ihm alle fremden Götter, die unter ihren Händen waren, und ihre Ohrenspangen; und er vergrub sie unter einer Eiche, die neben Sichem stand. ");
INSERT INTO deu1912_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Und sie zogen aus. Und es kam die Furcht Gottes über die Städte, die um sie her lagen, daß sie den Söhnen Jakobs nicht nachjagten. ");
INSERT INTO deu1912_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Also kam Jakob gen Lus im Lande Kanaan, das da Beth-El heißt, samt all dem Volk, das mit ihm war, ");
INSERT INTO deu1912_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","und baute daselbst einen Altar und hieß die Stätte El-Beth-El, darum daß ihm daselbst Gott offenbart war, da er floh vor seinem Bruder. ");
INSERT INTO deu1912_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Da starb Debora, der Rebekka Amme, und ward begraben unterhalb Beth-El unter der Eiche; die ward genannt die Klageeiche. ");
INSERT INTO deu1912_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Und Gott erschien Jakob abermals, nachdem er aus Mesopotamien gekommen war, und segnete ihn ");
INSERT INTO deu1912_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","und sprach zu ihm: Du heißt Jakob; aber du sollst nicht mehr Jakob heißen, sondern Israel sollst du heißen. Und also heißt man ihn Israel. ");
INSERT INTO deu1912_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Und Gott sprach zu ihm: Ich bin der allmächtige Gott; sei fruchtbar und mehre dich; Völker und Völkerhaufen sollen von dir kommen, und Könige sollen aus deinen Lenden kommen; ");
INSERT INTO deu1912_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","und das Land, das ich Abraham und Isaak gegeben habe, will ich dir geben und will's deinem Samen nach dir geben. ");
INSERT INTO deu1912_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Also fuhr Gott auf von ihm von dem Ort, da er mit ihm geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakob aber richtete ein steinernes Mal auf an dem Ort, da er mit ihm geredet hatte, und goß ein Trankopfer darauf und begoß es mit Öl. ");
INSERT INTO deu1912_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Und Jakob hieß den Ort, da Gott mit ihm geredet hatte, Beth-El. ");
INSERT INTO deu1912_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Und sie zogen von Beth-El. Und da noch ein Feld Weges war von Ephrath, da gebar Rahel. ");
INSERT INTO deu1912_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Und es kam sie hart an über der Geburt. Da aber die Geburt so schwer ward, sprach die Wehmutter zu ihr: Fürchte dich nicht, denn diesen Sohn wirst du auch haben. ");
INSERT INTO deu1912_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Da ihr aber die Seele ausging, daß sie sterben mußte, hieß sie ihn Ben-Oni; aber sein Vater hieß ihn Ben-Jamin. ");
INSERT INTO deu1912_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Also starb Rahel und ward begraben an dem Wege gen Ephrath, das nun heißt Bethlehem. ");
INSERT INTO deu1912_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Und Jakob richtete ein Mal auf über ihrem Grabe; dasselbe ist das Grabmal Rahels bis auf diesen Tag. ");
INSERT INTO deu1912_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Und Israel zog aus und richtete seine Hütte auf jenseit des Turms Eder. ");
INSERT INTO deu1912_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Und es begab sich, da Israel im Lande wohnte, ging Ruben hin und schlief bei Bilha, seines Vaters Kebsweib; und das kam vor Israel. Es hatte aber Jakob zwölf Söhne. ");
INSERT INTO deu1912_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Die Söhne Leas waren diese: Ruben, der erstgeborene Sohn Jakobs, Simeon, Levi, Juda, Isaschar und Sebulon; ");
INSERT INTO deu1912_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","die Söhne Rahel waren: Joseph und Benjamin; ");
INSERT INTO deu1912_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","die Söhne Bilhas, Rahels Magd: Dan und Naphthali; ");
INSERT INTO deu1912_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","die Söhne Silpas, Leas Magd: Gad und Asser. Das sind die Söhne Jakobs, die ihm geboren sind in Mesopotamien. ");
INSERT INTO deu1912_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Und Jakob kam zu seinem Vater Isaak gen Mamre zu Kirjat-Arba, das da heißt Hebron, darin Abraham und Isaak Fremdlinge gewesen sind. ");
INSERT INTO deu1912_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Und Isaak ward hundertundachtzig Jahre alt ");
INSERT INTO deu1912_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","und nahm ab und starb und ward versammelt zu seinem Volk, alt und des Lebens satt. Und seine Söhne Esau und Jakob begruben ihn. ");
INSERT INTO deu1912_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Das ist das Geschlecht Esaus, der da heißt Edom. ");
INSERT INTO deu1912_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau nahm Weiber von den Töchtern Kanaans: Ada, die Tochter Elons, des Hethiters, und Oholibama, die Tochter des Ana, die Enkelin des Zibeons, des Heviters, ");
INSERT INTO deu1912_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","und Basmath, Ismaels Tochter, Nebajoths Schwester. ");
INSERT INTO deu1912_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Und Ada gebar dem Esau Eliphas, aber Basmath gebar Reguel. ");
INSERT INTO deu1912_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama gebar Jehus, Jaelam und Korah. Das sind Esaus Kinder, die ihm geboren sind im Lande Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Und Esau nahm seine Weiber, Söhne und Töchter und alle Seelen seines Hauses, seine Habe und alles Vieh mit allen Gütern, so er im Lande Kanaan erworben hatte, und zog in ein ander Land, hinweg von seinem Bruder Jakob. ");
INSERT INTO deu1912_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Denn ihre Habe war zu groß, daß sie nicht konnten beieinander wohnen; und das Land darin sie Fremdlinge waren, vermochte sie nicht zu ertragen vor der Menge ihres Viehs. ");
INSERT INTO deu1912_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Also wohnte Esau auf dem Gebirge Seir. Und Esau ist der Edom. ");
INSERT INTO deu1912_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dies ist das Geschlecht Esaus, von dem die Edomiter herkommen, auf dem Gebirge Seir. ");
INSERT INTO deu1912_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Und so heißen die Kinder Esaus: Eliphas, der Sohn Adas, Esaus Weibes; Reguel, der Sohn Basmaths, Esaus Weibes. ");
INSERT INTO deu1912_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Des Eliphas Söhne aber waren diese: Theman, Omar, Zepho, Gaetham und Kenas. ");
INSERT INTO deu1912_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Und Thimna war ein Kebsweib des Eliphas, Esaus Sohnes; die gebar ihm Amalek. Das sind die Kinder von Ada, Esaus Weib. ");
INSERT INTO deu1912_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Die Kinder aber Reguels sind diese: Nahath, Serah, Samma, Missa. Das sind die Kinder von Basmath, Esaus Weib. ");
INSERT INTO deu1912_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Die Kinder aber von Oholibama, Esaus Weib, der Tochter des Ana, der Enkelin Zibeons, sind diese, die sie dem Esau gebar: Jehus, Jaelam und Korah. ");
INSERT INTO deu1912_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Das sind die Fürsten unter den Kindern Esaus. Die Kinder des Eliphas, des ersten Sohnes Esaus: der Fürst Theman, der Fürst Omar, der Fürst Zepho, der Fürst Kenas, ");
INSERT INTO deu1912_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","der Fürst Korah, der Fürst Gaetham, der Fürst Amalek. Das sind die Fürsten von Eliphas im Lande Edom und sind Kinder der Ada. ");
INSERT INTO deu1912_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Und das sind die Kinder Reguels, Esaus Sohnes: der Fürst Nahath, der Fürst Serah, der Fürst Samma, der Fürst Missa. Das sind die Fürsten von Reguel im Lande der Edomiter und sind Kinder von der Basmath, Esaus Weib. ");
INSERT INTO deu1912_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Das sind die Kinder Oholibamas, Esaus Weibes: der Fürst Jehus, der Fürst Jaelam, der Fürst Korah. Das sind die Fürsten von Oholibama, der Tochter des Ana, Esaus Weib. ");
INSERT INTO deu1912_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Das sind die Kinder und ihre Fürsten. Er ist der Edom. ");
INSERT INTO deu1912_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Die Kinder aber von Seir, dem Horiter, die im Lande wohnten, sind diese: Lotan, Sobal, Zibeon, Ana, Dison, Ezer und Disan. ");
INSERT INTO deu1912_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Das sind die Fürsten der Horiter, Kinder des Seir, im Lande Edom. ");
INSERT INTO deu1912_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Aber des Lotan Kinder waren diese: Hori, Heman; und Lotans Schwester hieß Thimna. ");
INSERT INTO deu1912_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Die Kinder von Sobal waren diese: Alwan, Manahath, Ebal, Sepho und Onam. ");
INSERT INTO deu1912_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Die Kinder von Zibeon waren diese: Aja und Ana. Das ist der Ana, der in der Wüste die warmen Quellen fand, da er seines Vaters Zibeon Esel hütete. ");
INSERT INTO deu1912_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Die Kinder aber Anas waren: Dison und Oholibama, das ist die Tochter Anas. ");
INSERT INTO deu1912_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Die Kinder Disons waren: Hemdan, Esban, Jethran und Cheran. ");
INSERT INTO deu1912_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Die Kinder Ezers waren: Bilhan, Sawan und Akan. ");
INSERT INTO deu1912_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Die Kinder Disans waren: Uz und Aran. ");
INSERT INTO deu1912_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dies sind die Fürsten der Horiter: der Fürst Lotan, der Fürst Sobal, der Fürst Zibeon, der Fürst Ana, ");
INSERT INTO deu1912_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","der Fürst Dison, der Fürst Ezer, der Fürst Disan. Das sind die Fürsten der Horiter, die regiert haben im Lande Seir. ");
INSERT INTO deu1912_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Die Könige aber, die im Lande Edom regiert haben, ehe denn die Kinder Israel Könige hatten, sind diese: ");
INSERT INTO deu1912_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela war König in Edom, ein Sohn Beors, und seine Stadt hieß Dinhaba. ");
INSERT INTO deu1912_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Und da Bela starb, ward König an seiner Statt Jobab, ein Sohn Serahs von Bozra. ");
INSERT INTO deu1912_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Da Jobab starb, ward an seiner Statt König Husam aus der Themaniter Lande. ");
INSERT INTO deu1912_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Da Husam starb, ward König an seiner Statt Hadad, ein Sohn Bedads, der die Midianiter schlug auf der Moabiter Felde; und seine Stadt hieß Awith. ");
INSERT INTO deu1912_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Da Hadad starb, regierte Samla von Masrek. ");
INSERT INTO deu1912_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Da Samla starb, ward Saul König, von Rehoboth am Strom. ");
INSERT INTO deu1912_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Da Saul starb, ward an seiner Statt König Baal-Hanan, der Sohn Achbors. ");
INSERT INTO deu1912_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Da Baal-Hanan, Achbors Sohn, starb, ward an seiner Statt König Hadar; und seine Stadt hieß Pagu, und sein Weib Mehetabeel, eine Tochter Matreds, die Mesahabs Tochter war. ");
INSERT INTO deu1912_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Also heißen die Fürsten von Esau in ihren Geschlechtern, Örtern und Namen: der Fürst Thimna, der Fürst Alwa, der Fürst Jetheth, ");
INSERT INTO deu1912_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","der Fürst Oholibama, der Fürst Ela, der Fürst Pinon, ");
INSERT INTO deu1912_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","der Fürst Kenas, der Fürst Theman, der Fürst Mibzar, ");
INSERT INTO deu1912_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","der Fürst Magdiel, der Fürst Iram. Das sind die Fürsten in Edom, wie sie gewohnt haben in ihrem Erblande. Das ist Esau, der Vater der Edomiter. ");
INSERT INTO deu1912_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob aber wohnte im Lande, darin sein Vater ein Fremdling gewesen war, im Lande Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Und dies sind die Geschlechter Jakobs: Joseph war siebzehn Jahre alt, da er ein Hirte des Viehs ward mit seinen Brüdern; und der Knabe war bei den Kinder Bilhas und Silpas, der Weiber seines Vaters, und brachte vor ihren Vater, wo ein böses Geschrei wider sie war. ");
INSERT INTO deu1912_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel aber hatte Joseph lieber als alle seine Kinder, darum daß er ihn im Alter gezeugt hatte; und machte ihm einen bunten Rock. ");
INSERT INTO deu1912_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Da nun seine Brüder sahen, daß ihn ihr Vater lieber hatte als alle seine Brüder, waren sie ihm feind und konnten ihm kein freundlich Wort zusprechen. ");
INSERT INTO deu1912_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Dazu hatte Joseph einmal einen Traum und sagte zu seinen Brüdern davon; da wurden sie ihm noch feinder. ");
INSERT INTO deu1912_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Denn er sprach zu ihnen: Höret doch, was mir geträumt hat: ");
INSERT INTO deu1912_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mich deuchte, wir banden Garben auf dem Felde, und meine Garbe richtete sich auf und stand, und eure Garben umher neigten sich vor meiner Garbe. ");
INSERT INTO deu1912_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Da sprachen seine Brüder zu ihm: Solltest du unser König werden und über uns herrschen? und sie wurden ihm noch feinder um seines Traumes und seiner Rede willen. ");
INSERT INTO deu1912_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Und er hatte noch einen andern Traum, den erzählte er seinen Brüdern und sprach: Siehe, ich habe einen Traum gehabt: Mich deuchte, die Sonne und der Mond und elf Sterne neigten sich vor mir. ");
INSERT INTO deu1912_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Und da das seinem Vater und seinen Brüdern gesagt ward, strafte ihn sein Vater und sprach zu ihm: Was ist das für ein Traum, der dir geträumt hat? Soll ich und deine Mutter und deine Brüder kommen und vor dir niederfallen? ");
INSERT INTO deu1912_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Und seine Brüder beneideten ihn. Aber sein Vater behielt diese Worte. ");
INSERT INTO deu1912_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Da nun seine Brüder hingingen, zu weiden das Vieh ihres Vaters in Sichem, ");
INSERT INTO deu1912_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","sprach Israel zu Joseph: Hüten nicht deine Brüder das Vieh in Sichem? Komm, ich will dich zu ihnen senden. Er aber sprach: Hier bin ich. ");
INSERT INTO deu1912_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Und er sprach: Gehe hin und sieh, ob's wohl stehe um deine Brüder und um das Vieh, und sage mir wieder Antwort. Und er sandte ihn aus dem Tal Hebron, daß er gen Sichem ginge. ");
INSERT INTO deu1912_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Da fand ihn ein Mann, daß er irreging auf dem Felde; der fragte ihn und sprach: Wen suchst du? ");
INSERT INTO deu1912_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Er antwortete: Ich suche meine Brüder; sage mir doch an, wo sie hüten. ");
INSERT INTO deu1912_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Der Mann sprach: Sie sind von dannen gezogen; denn ich hörte, daß sie sagten: Laßt uns gen Dothan gehen. Da folgte Joseph seinen Brüdern nach und fand sie zu Dothan. ");
INSERT INTO deu1912_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Als sie ihn nun sahen von ferne, ehe er denn nahe zu ihnen kam machten sie einen Anschlag, daß sie ihn töteten, ");
INSERT INTO deu1912_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","und sprachen untereinander: Seht, der Träumer kommt daher. ");
INSERT INTO deu1912_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","So kommt nun und laßt uns ihn erwürgen und in eine Grube werfen und sagen, ein böses Tier habe ihn gefressen, so wird man sehen, was seine Träume sind. ");
INSERT INTO deu1912_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Da das Ruben hörte, wollte er ihn aus ihren Händen erretten, und sprach: Laßt uns ihn nicht töten. ");
INSERT INTO deu1912_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Und weiter sprach Ruben zu ihnen: Vergießt nicht Blut, sondern werft ihn in die Grube, die in der Wüste ist, und legt die Hand nicht an ihn. Er wollte ihn aber aus ihrer Hand erretten, daß er ihn seinem Vater wiederbrächte. ");
INSERT INTO deu1912_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Als nun Joseph zu seinen Brüdern kam, zogen sie ihm seinen Rock, den bunten Rock, aus, den er anhatte, ");
INSERT INTO deu1912_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","und nahmen ihn und warfen ihn in die Grube; aber die Grube war leer und kein Wasser darin. ");
INSERT INTO deu1912_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Und setzten sich nieder, zu essen. Indes hoben sie ihre Augen auf und sahen einen Haufen Ismaeliter kommen von Gilead mit ihren Kamelen; die trugen Würze, Balsam und Myrrhe und zogen hinab nach Ägypten. ");
INSERT INTO deu1912_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Da sprach Juda zu seinen Brüdern: Was hilft's uns, daß wir unseren Bruder erwürgen und sein Blut verbergen? ");
INSERT INTO deu1912_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kommt, laßt uns ihn den Ismaeliten verkaufen, daß sich unsre Hände nicht an ihm vergreifen; denn er ist unser Bruder, unser Fleisch und Blut. Und sie gehorchten ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Und da die Midianiter, die Kaufleute, vorüberreisten, zogen sie ihn heraus aus der Grube und verkauften ihn den Ismaeliten um zwanzig Silberlinge; die brachte ihn nach Ägypten. ");
INSERT INTO deu1912_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Als nun Ruben wieder zur Grube kam und fand er Joseph nicht darin, zerriß er sein Kleid ");
INSERT INTO deu1912_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","und kam wieder zu seinen Brüdern und sprach: Der Knabe ist nicht da! Wo soll ich hin? ");
INSERT INTO deu1912_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Da nahmen sie Josephs Rock und schlachteten einen Ziegenbock und tauchten den Rock ins Blut ");
INSERT INTO deu1912_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","und schickten den bunten Rock hin und ließen ihn ihrem Vater bringen und sagen: Diesen haben wir gefunden; sieh, ob's deines Sohnes Rock sei oder nicht. ");
INSERT INTO deu1912_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Er erkannte ihn aber und sprach: Es ist meines Sohnes Rock; ein böses Tier hat ihn gefressen, ein reißendes Tier hat Joseph zerrissen. ");
INSERT INTO deu1912_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Und Jakob zerriß sein Kleider und legte einen Sack um seine Lenden und trug Leid um seinen Sohn lange Zeit. ");
INSERT INTO deu1912_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Und alle seine Söhne und Töchter traten auf, daß sie ihn trösteten; aber er wollte sich nicht trösten lassen und sprach: Ich werde mit Leid hinunterfahren in die Grube zu meinem Sohn. Und sein Vater beweinte ihn. ");
INSERT INTO deu1912_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Aber die Midianiter verkauften ihn in Ägypten dem Potiphar, des Pharao Kämmerer und Hauptmann der Leibwache. ");
INSERT INTO deu1912_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Es begab sich um dieselbe Zeit, daß Juda hinabzog von seinen Brüdern und tat sich zu einem Mann von Adullam, der hieß Hira. ");
INSERT INTO deu1912_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Und Juda sah daselbst eines Kanaaniter-Mannes Tochter, der hieß Sua, und nahm sie. Und da er zu ihr einging, ");
INSERT INTO deu1912_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ward sie schwanger und gebar einen Sohn, den hieß er Ger. ");
INSERT INTO deu1912_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Und sie ward abermals schwanger und gebar einen Sohn, den hieß sie Onan. ");
INSERT INTO deu1912_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Sie gebar abermals einen Sohn, den hieß sie Sela; und er war zu Chesib, da sie ihn gebar. ");
INSERT INTO deu1912_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Und Juda gab seinem ersten Sohn, Ger, ein Weib, die hieß Thamar. ");
INSERT INTO deu1912_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Aber Ger war böse vor dem HERRN; darum tötete ihn der HERR. ");
INSERT INTO deu1912_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Da sprach Juda zu Onan: Gehe zu deines Bruders Weib und nimm sie zur Ehe, daß du deinem Bruder Samen erweckest. ");
INSERT INTO deu1912_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Aber da Onan wußte, daß der Same nicht sein eigen sein sollte, wenn er einging zu seines Bruders Weib, ließ er's auf die Erde fallen und verderbte es, auf daß er seinem Bruder nicht Samen gäbe. ");
INSERT INTO deu1912_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Da gefiel dem HERRN übel, was er tat, und er tötete ihn auch. ");
INSERT INTO deu1912_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Da sprach Juda zu seiner Schwiegertochter Thamar: Bleibe eine Witwe in deines Vaters Hause, bis mein Sohn Sela groß wird. Denn er gedachte, vielleicht möchte er auch sterben wie seine Brüder. Also ging Thamar hin und blieb in ihres Vaters Hause. ");
INSERT INTO deu1912_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Da nun viele Tage verlaufen waren, starb des Sua Tochter, Juda's Weib. Und nachdem Juda ausgetrauert hatte, ging er hinauf seine Schafe zu scheren, gen Thimnath mit seinem Freunde Hira von Adullam. ");
INSERT INTO deu1912_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Da ward der Thamar angesagt: Siehe, dein Schwiegervater geht hinauf gen Thimnath, seine Schafe zu scheren. ");
INSERT INTO deu1912_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Da legte sie die Witwenkleider von sich, die sie trug, deckte sich mit einem Mantel und verhüllte sich und setzte sich vor das Tor von Enaim an dem Wege gen Thimnath; denn sie sah, daß Sela war groß geworden, und sie ward ihm nicht zum Weibe gegeben. ");
INSERT INTO deu1912_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Da sie nun Juda sah, meinte er, sie wäre eine Hure; denn sie hatte ihr Angesicht verdeckt. ");
INSERT INTO deu1912_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Und er machte sich zu ihr am Wege und sprach: Laß mich doch zu dir kommen; denn er wußte nicht, daß es seine Schwiegertochter wäre. Sie antwortete: Was willst du mir geben, daß du zu mir kommst? ");
INSERT INTO deu1912_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Er sprach: Ich will dir einen Ziegenbock von der Herde senden. Sie antwortete: So gib mir ein Pfand, bis daß du mir's sendest. ");
INSERT INTO deu1912_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Er sprach: Was willst du für ein Pfand, das ich dir gebe? Sie antwortete: Deinen Ring und deine Schnur und deinen Stab, den du in den Händen hast. Da gab er's ihr und kam zu ihr; und sie ward von ihm schwanger. ");
INSERT INTO deu1912_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Und sie machte sich auf und ging hin und zog ihre Witwenkleider wieder an. ");
INSERT INTO deu1912_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda aber sandte den Ziegenbock durch seinen Freund Adullam, daß er das Pfand wieder holte von dem Weibe; und er fand sie nicht. ");
INSERT INTO deu1912_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Da fragte er die Leute: Wo ist die Hure, die zu Enaim am Wege saß? Sie antworteten: Es ist keine Hure da gewesen. ");
INSERT INTO deu1912_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Und er kam wieder zu Juda und sprach: Ich habe sie nicht gefunden; dazu sagen die Leute des Orts, es sei keine Hure da gewesen. ");
INSERT INTO deu1912_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda sprach: Sie mag's behalten; sie kann uns doch nicht Schande nachsagen, denn ich habe den Bock gesandt, so hast du sie nicht gefunden. ");
INSERT INTO deu1912_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Über drei Monate ward Juda angesagt: Deine Schwiegertochter Thamar hat gehurt; dazu siehe, ist sie von der Hurerei schwanger geworden. Juda spricht: Bringt sie hervor, daß sie verbrannt werde. ");
INSERT INTO deu1912_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Und da man sie hervorbrachte, schickte sie zu ihrem Schwiegervater und sprach: Von dem Mann bin ich schwanger, des dies ist. Und sprach: Kennst du auch, wes dieser Ring und diese Schnur und dieser Stab ist? ");
INSERT INTO deu1912_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda erkannte es und sprach: Sie ist gerechter als ich; denn ich habe sie nicht gegeben meinen Sohn Sela. Doch erkannte er sie fürder nicht mehr. ");
INSERT INTO deu1912_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Und da sie gebären sollte, wurden Zwillinge in ihrem Leib gefunden. ");
INSERT INTO deu1912_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Und als sie jetzt gebar, tat sich eine Hand heraus. Da nahm die Wehmutter einen roten Faden und band ihn darum und sprach: Der wird zuerst herauskommen. ");
INSERT INTO deu1912_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Da aber der seine Hand wieder hineinzog, kam sein Bruder heraus; und sie sprach: Warum hast du um deinetwillen solchen Riß gerissen? Und man hieß ihn Perez. ");
INSERT INTO deu1912_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Darnach kam sein Bruder heraus, der den roten Faden um seine Hand hatte. Und man hieß ihn Serah. ");
INSERT INTO deu1912_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph ward hinab nach Ägypten geführt; und Potiphar, ein ägyptischer Mann, des Pharao Kämmerer und Hauptmann, kaufte ihn von den Ismaeliten, die ihn hinabbrachten. ");
INSERT INTO deu1912_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Und der HERR war mit Joseph, daß er ein glücklicher Mann ward; und er war in seines Herrn, des Ägypters, Hause. ");
INSERT INTO deu1912_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Und sein Herr sah, daß der HERR mit ihm war; denn alles, was er tat, dazu gab der HERR Glück durch ihn, ");
INSERT INTO deu1912_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Also daß er Gnade fand vor seinem Herrn und sein Diener ward. Der setzte ihn über sein Haus, und alles, was er hatte, tat er unter seine Hände. ");
INSERT INTO deu1912_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Und von der Zeit an, da er ihn über sein Haus und alle seine Güter gesetzt hatte, segnete der HERR des Ägypters Haus um Josephs willen; und war eitel Segen des HERRN in allem, was er hatte, zu Hause und auf dem Felde. ");
INSERT INTO deu1912_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Darum ließ er alles unter Josephs Händen, was er hatte, und nahm sich keines Dinges an, solange er ihn hatte, nur daß er aß und trank. Und Joseph war schön und hübsch von Angesicht. ");
INSERT INTO deu1912_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Und es begab sich nach dieser Geschichte, daß seines Herrn Weib ihre Augen auf Joseph warf und sprach: Schlafe bei mir! ");
INSERT INTO deu1912_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Er weigerte sich aber und sprach zu ihr: Siehe, mein Herr nimmt sich keines Dinges an vor mir, was im Hause ist, und alles, was er hat, das hat er unter meine Hände getan, ");
INSERT INTO deu1912_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","und hat nichts so Großes in dem Hause, das er mir verhohlen habe, außer dir, indem du sein Weib bist. Wie sollte ich denn nun ein solch groß Übel tun und wider Gott sündigen? ");
INSERT INTO deu1912_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Und sie trieb solche Worte gegen Joseph täglich. Aber er gehorchte ihr nicht, daß er nahe bei ihr schliefe noch um sie wäre. ");
INSERT INTO deu1912_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Es begab sich eines Tages, daß Joseph in das Haus ging, sein Geschäft zu tun, und war kein Mensch vom Gesinde des Hauses dabei. ");
INSERT INTO deu1912_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Und sie erwischte ihn bei seinem Kleid und sprach: Schlafe bei mir! Aber er ließ das Kleid in ihrer Hand und floh und lief zum Hause hinaus. ");
INSERT INTO deu1912_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Da sie nun sah, daß er sein Kleid in ihrer Hand ließ und hinaus entfloh, ");
INSERT INTO deu1912_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","rief sie das Gesinde im Hause und sprach zu ihnen: Sehet, er hat uns den hebräischen Mann hereingebracht, daß er seinen Mutwillen mit uns treibe. Er kam zu mir herein und wollte bei mir schlafen; ich rief aber mit lauter Stimme. ");
INSERT INTO deu1912_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Und da er hörte, daß ich ein Geschrei machte und rief, da ließ er sein Kleid bei mir und lief hinaus. ");
INSERT INTO deu1912_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Und sie legte sein Kleid neben sich, bis der Herr heimkam, ");
INSERT INTO deu1912_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","und sagte zu ihm ebendieselben Worte und sprach: Der hebräische Knecht, den du uns hereingebracht hast, kam zu mir herein und wollte seinen Mutwillen mit mir treiben. ");
INSERT INTO deu1912_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Da ich aber ein Geschrei machte und rief, da ließ er sein Kleid bei mir und floh hinaus. ");
INSERT INTO deu1912_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Als sein Herr hörte die Rede seines Weibes, die sie ihm sagte und sprach: Also hat mir dein Knecht getan, ward er sehr zornig. ");
INSERT INTO deu1912_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Da nahm ihn sein Herr und legte ihn ins Gefängnis, darin des Königs Gefangene lagen; und er lag allda im Gefängnis. ");
INSERT INTO deu1912_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Aber der HERR war mit ihm und neigte seine Huld zu ihm und ließ ihn Gnade finden vor dem Amtmann über das Gefängnis, ");
INSERT INTO deu1912_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","daß er ihm unter seine Hand befahl alle Gefangenen im Gefängnis, auf daß alles, was da geschah, durch ihn geschehen mußte. ");
INSERT INTO deu1912_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Denn der Amtmann des Gefängnisses nahm sich keines Dinges an; denn der HERR war mit Joseph, und was er tat, dazu gab der HERR Glück. ");
INSERT INTO deu1912_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Und es begab sich darnach, daß sich der Schenke des Königs in Ägypten und der Bäcker versündigten an ihrem Herrn, dem König von Ägypten. ");
INSERT INTO deu1912_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Und Pharao ward zornig über seine beiden Kämmerer, über den Amtmann über die Schenken und über den Amtmann über die Bäcker, ");
INSERT INTO deu1912_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","und ließ sie setzen in des Hauptmanns Haus ins Gefängnis, da Joseph lag. ");
INSERT INTO deu1912_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Und der Hauptmann setzte Joseph über sie, daß er ihnen diente; und sie saßen etliche Tage im Gefängnis. ");
INSERT INTO deu1912_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Und es träumte ihnen beiden, dem Schenken und dem Bäcker des Königs von Ägypten, in einer Nacht einem jeglichen ein eigener Traum; und eines jeglichen Traum hatte seine Bedeutung. ");
INSERT INTO deu1912_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Da nun des Morgens Joseph zu ihnen hereinkam und sah, daß sie traurig waren, ");
INSERT INTO deu1912_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","fragte er sie und sprach: Warum seid ihr heute so traurig? ");
INSERT INTO deu1912_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Sie antworteten: Es hat uns geträumt, und wir haben niemand, der es uns auslege. Joseph sprach: Auslegen gehört Gott zu; doch erzählt mir's. ");
INSERT INTO deu1912_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Da erzählte der oberste Schenke seinen Traum Joseph und sprach zu ihm: Mir hat geträumt, daß ein Weinstock vor mir wäre, ");
INSERT INTO deu1912_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","der hatte drei Reben, und er grünte, wuchs und blühte, und seine Trauben wurden reif; ");
INSERT INTO deu1912_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","und ich hatte den Becher Pharaos in meiner Hand und nahm die Beeren und zerdrückte sie in den Becher und gab den Becher Pharao in die Hand. ");
INSERT INTO deu1912_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph sprach zu ihm: Das ist seine Deutung. Drei Reben sind drei Tage. ");
INSERT INTO deu1912_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Über drei Tage wird Pharao dein Haupt erheben und dich wieder an dein Amt stellen, daß du ihm den Becher in die Hand gebest nach der vorigen Weise, da du sein Schenke warst. ");
INSERT INTO deu1912_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aber gedenke meiner, wenn dir's wohl geht, und tue Barmherzigkeit an mir, daß du Pharao erinnerst, daß er mich aus diesem Hause führe. ");
INSERT INTO deu1912_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Denn ich bin aus dem Lande der Hebräer heimlich gestohlen; dazu habe ich auch allhier nichts getan, daß sie mich eingesetzt haben. ");
INSERT INTO deu1912_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Da der oberste Bäcker sah, daß die Deutung gut war, sprach er zu Joseph: Mir hat auch geträumt, ich trüge drei weiße Körbe auf meinem Haupt ");
INSERT INTO deu1912_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","und im obersten Korbe allerlei gebackene Speise für den Pharao; und die Vögel aßen aus dem Korbe auf meinem Haupt. ");
INSERT INTO deu1912_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph antwortete und sprach: Das ist seine Deutung. Drei Körbe sind drei Tage; ");
INSERT INTO deu1912_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","und nach drei Tagen wird dir Pharao dein Haupt erheben und dich an den Galgen hängen, und die Vögel werden dein Fleisch von dir essen. ");
INSERT INTO deu1912_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Und es geschah des dritten Tages, da beging Pharao seinen Jahrestag; und er machte eine Mahlzeit allen seinen Knechten und erhob das Haupt des obersten Schenken und das Haupt des obersten Bäckers unter den Knechten, ");
INSERT INTO deu1912_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","und setzte den obersten Schenken wieder in sein Schenkamt, daß er den Becher reicht in Pharaos Hand; ");
INSERT INTO deu1912_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","aber den obersten Bäcker ließ er henken, wie ihnen Joseph gedeutet hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Aber der oberste Schenke gedachte nicht an Joseph, sondern vergaß ihn. ");
INSERT INTO deu1912_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Und nach zwei Jahren hatte Pharao einen Traum, wie er stünde am Nil ");
INSERT INTO deu1912_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","und sähe aus dem Wasser steigen sieben schöne, fette Kühe; die gingen auf der Weide im Grase. ");
INSERT INTO deu1912_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nach diesen sah er andere sieben Kühe aus dem Wasser aufsteigen; die waren häßlich und mager und traten neben die Kühe an das Ufer am Wasser. ");
INSERT INTO deu1912_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Und die häßlichen und mageren fraßen die sieben schönen, fetten Kühe. Da erwachte Pharao. ");
INSERT INTO deu1912_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Und er schlief wieder ein, und ihn träumte abermals, und er sah, daß sieben Ähren wuchsen an einem Halm, voll und dick. ");
INSERT INTO deu1912_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Darnach sah er sieben dünnen Ähren aufgehen, die waren vom Ostwind versengt. ");
INSERT INTO deu1912_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Und die sieben mageren Ähren verschlangen die sieben dicken und vollen Ähren. Da erwachte Pharao und merkte, daß es ein Traum war. ");
INSERT INTO deu1912_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Und da es Morgen ward, war sein Geist bekümmert; und er schickte aus und ließ rufen alle Wahrsager in Ägypten und alle Weisen und erzählte ihnen seine Träume. Aber da war keiner, der sie dem Pharao deuten konnte. ");
INSERT INTO deu1912_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Da redete der oberste Schenke zu Pharao und sprach: Ich gedenke heute an meine Sünden. ");
INSERT INTO deu1912_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Da Pharao zornig ward über seine Knechte, und mich mit dem obersten Bäcker ins Gefängnis legte in des Hauptmanns Hause, ");
INSERT INTO deu1912_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","da träumte uns beiden in einer Nacht, einem jeglichen sein Traum, des Deutung ihn betraf. ");
INSERT INTO deu1912_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Da war bei uns ein hebräischer Jüngling, des Hauptmanns Knecht, dem erzählten wir's. Und er deutete uns unsere Träume, einem jeglichen seinen Traum. ");
INSERT INTO deu1912_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Und wie er uns deutete, so ist's ergangen; denn ich bin wieder in mein Amt gesetzt, und jener ist gehenkt. ");
INSERT INTO deu1912_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Da sandte Pharao hin und ließ Joseph rufen; und sie ließen ihn eilend aus dem Gefängnis. Und er ließ sich scheren und zog andere Kleider an und kam hinein zu Pharao. ");
INSERT INTO deu1912_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Da sprach Pharao zu ihm: Mir hat ein Traum geträumt, und ist niemand, der ihn deuten kann; ich habe aber gehört von dir sagen, wenn du einen Traum hörst, so kannst du ihn deuten. ");
INSERT INTO deu1912_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph antwortete Pharao und sprach: Das steht bei mir nicht; Gott wird doch Pharao Gutes weissagen. ");
INSERT INTO deu1912_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pharao sprach zu Joseph: Mir träumte ich stand am Ufer bei dem Wasser ");
INSERT INTO deu1912_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","und sah aus dem Wasser steigen sieben schöne, fette Kühe; die gingen auf der Weide im Grase. ");
INSERT INTO deu1912_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Und nach ihnen sah ich andere sieben, dürre, sehr häßliche und magere Kühe heraussteigen. Ich habe in ganz Ägyptenland nicht so häßliche gesehen. ");
INSERT INTO deu1912_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Und die sieben mageren und häßlichen Kühe fraßen auf die sieben ersten, fetten Kühe. ");
INSERT INTO deu1912_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Und da sie sie hineingefressen hatten, merkte man's nicht an ihnen, daß sie die gefressen hatten, und waren häßlich gleich wie vorhin. Da wachte ich auf. ");
INSERT INTO deu1912_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Und ich sah abermals in einen Traum sieben Ähren auf einem Halm wachsen, voll und dick. ");
INSERT INTO deu1912_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Darnach gingen auf sieben dürre Ähren, dünn und versengt. ");
INSERT INTO deu1912_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Und die sieben dünnen Ähren verschlangen die sieben dicken Ähren. Und ich habe es den Wahrsagern gesagt; aber die können's mir nicht deuten. ");
INSERT INTO deu1912_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph antwortete Pharao: Beide Träume Pharaos sind einerlei. Gott verkündigt Pharao, was er vorhat. ");
INSERT INTO deu1912_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Die sieben schönen Kühe sind sieben Jahre, und die sieben guten Ähren sind auch die sieben Jahre. Es ist einerlei Traum. ");
INSERT INTO deu1912_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Die sieben mageren und häßlichen Kühe, die nach jenen aufgestiegen sind, das sind sieben Jahre; und die sieben mageren und versengten Ähren sind sieben Jahre teure Zeit. ");
INSERT INTO deu1912_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Das ist nun, wie ich gesagt habe zu Pharao, daß Gott Pharao zeigt, was er vorhat. ");
INSERT INTO deu1912_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Siehe, sieben reiche Jahre werden kommen in ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Und nach denselben werden sieben Jahre teure Zeit kommen, daß man vergessen wird aller solcher Fülle in Ägyptenland; und die teure Zeit wird das Land verzehren, ");
INSERT INTO deu1912_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","daß man nichts wissen wird von der Fülle im Lande vor der teuren Zeit, die hernach kommt; denn sie wird sehr schwer sein. ");
INSERT INTO deu1912_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Daß aber dem Pharao zum andernmal geträumt hat, bedeutet, daß solches Gott gewiß und eilend tun wird. ");
INSERT INTO deu1912_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Nun sehe Pharao nach einem verständigen und weisen Mann, den er über Ägyptenland setze, ");
INSERT INTO deu1912_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","und schaffe, daß er Amtleute verordne im Lande und nehme den Fünften in Ägyptenland in den sieben reichen Jahren ");
INSERT INTO deu1912_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","und sammle alle Speise der guten Jahre, die kommen werden, daß sie Getreide aufschütten in Pharaos Kornhäuser zum Vorrat in den Städten und es verwahren, ");
INSERT INTO deu1912_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","auf daß man Speise verordnet finde dem Lande in den sieben teuren Jahren, die über Ägyptenland kommen werden, daß nicht das Land vor Hunger verderbe. ");
INSERT INTO deu1912_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Die Rede gefiel Pharao und allen seinen Knechten wohl. ");
INSERT INTO deu1912_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Und Pharao sprach zu seinen Knechten: Wie könnten wir einen solchen Mann finden, in dem der Geist Gottes sei? ");
INSERT INTO deu1912_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Und sprach zu Joseph: Weil dir Gott solches alles hat kundgetan, ist keiner so verständig und weise wie du. ");
INSERT INTO deu1912_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Du sollst über mein Haus sein, und deinem Wort soll all mein Volk gehorsam sein; allein um den königlichen Stuhl will ich höher sein als du. ");
INSERT INTO deu1912_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Und weiter sprach Pharao zu Joseph: Siehe, ich habe dich über ganz Ägyptenland gesetzt. ");
INSERT INTO deu1912_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Und er tat seinen Ring von seiner Hand und gab ihn Joseph an seine Hand und kleidete ihn mit köstlicher Leinwand und hing eine goldene Kette an seinen Hals ");
INSERT INTO deu1912_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","und ließ ihn auf seinem zweiten Wagen fahren und ließ vor ihm ausrufen: Der ist des Landes Vater! und setzte ihn über ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Und Pharao sprach zu Joseph: Ich bin Pharao; ohne deinen Willen soll niemand seine Hand und Fuß regen in ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Und nannte ihn den heimlichen Rat und gab ihm ein Weib, Asnath, die Tochter Potipheras, des Priesters zu On. Also zog Joseph aus, das Land Ägypten zu besehen. ");
INSERT INTO deu1912_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Und er war dreißig Jahre alt, da er vor Pharao stand, dem König in Ägypten; und fuhr aus von Pharao und zog durch ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Und das Land trug in den sieben reichen Jahren die Fülle; ");
INSERT INTO deu1912_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","und sie sammelten alle Speise der sieben Jahre, so im Lande Ägypten waren, und taten sie in die Städte. Was für Speise auf dem Felde einer jeglichen Stadt umher wuchs, das taten sie hinein. ");
INSERT INTO deu1912_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Also schüttete Joseph das Getreide auf, über die Maßen viel wie Sand am Meer, also daß er aufhörte es zu zählen; denn man konnte es nicht zählen. ");
INSERT INTO deu1912_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Und Joseph wurden zwei Söhne geboren, ehe denn die teure Zeit kam, welche ihm gebar Asnath, Potipheras, des Priesters zu On, Tochter. ");
INSERT INTO deu1912_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Und er hieß den ersten Manasse; denn Gott, sprach er, hat mich lassen vergessen alles meines Unglücks und all meines Vaters Hauses. ");
INSERT INTO deu1912_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Den andern hieß er Ephraim; denn Gott, sprach er, hat mich lassen wachsen in dem Lande meines Elends. ");
INSERT INTO deu1912_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Da nun die sieben reichen Jahre um waren in Ägypten, ");
INSERT INTO deu1912_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","da fingen an die sieben teuren Jahre zu kommen, davon Joseph gesagt hatte. Und es ward eine Teuerung in allen Landen; aber in ganz Ägyptenland war Brot. ");
INSERT INTO deu1912_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Da nun das ganze Ägyptenland auch Hunger litt, schrie das Volk zu Pharao um Brot. Aber Pharao sprach zu allen Ägyptern: Gehet hin zu Joseph; was euch der sagt, das tut. ");
INSERT INTO deu1912_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Als nun im ganzen Lande Teuerung war, tat Joseph allenthalben Kornhäuser auf und verkaufte den Ägyptern. Denn die Teuerung ward je länger, je größer im Lande. ");
INSERT INTO deu1912_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Und alle Lande kamen nach Ägypten, zu kaufen bei Joseph; denn die Teuerung war groß in allen Landen. ");
INSERT INTO deu1912_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Da aber Jakob sah, daß Getreide in Ägypten feil war, sprach er zu seinen Söhnen: Was sehet ihr euch lange um? ");
INSERT INTO deu1912_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Siehe, ich höre, es sei in Ägypten Getreide feil; zieht hinab und kauft uns Getreide, daß wir leben und nicht sterben. ");
INSERT INTO deu1912_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Also zogen hinab zehn Brüder Josephs, daß sie in Ägypten Getreide kauften. ");
INSERT INTO deu1912_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Aber den Benjamin, Josephs Bruder, ließ Jakob nicht mit seinen Brüdern ziehen; denn er sprach: Es möchte ihm ein Unfall begegnen. ");
INSERT INTO deu1912_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Also kamen die Kinder Israels, Getreide zu kaufen, samt anderen, die mit ihnen zogen; denn es war im Lande Kanaan auch teuer. ");
INSERT INTO deu1912_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Aber Joseph war der Regent im Lande und verkaufte Getreide allem Volk im Lande. Da nun seine Brüder kamen, fielen sie vor ihm nieder zur Erde auf ihr Antlitz. ");
INSERT INTO deu1912_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Und er sah sie an und kannte sie und stellte sich fremd gegen sie und redete hart mit ihnen und sprach zu ihnen: Woher kommt ihr? Sie sprachen: Aus dem Lande Kanaan, Speise zu kaufen. ");
INSERT INTO deu1912_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Aber wiewohl er sie kannte, kannten sie ihn doch nicht. ");
INSERT INTO deu1912_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Und Joseph gedachte an die Träume, die ihm von ihnen geträumt hatten, und sprach zu ihnen: Ihr seid Kundschafter und seid gekommen zu sehen, wo das Land offen ist. ");
INSERT INTO deu1912_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Sie antworteten ihm: Nein, mein Herr; deine Knechte sind gekommen Speise zu kaufen. ");
INSERT INTO deu1912_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Wir sind alle eines Mannes Söhne; wir sind redlich, und deine Knechte sind nie Kundschafter gewesen. ");
INSERT INTO deu1912_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Er sprach zu ihnen: Nein, sondern ihr seid gekommen, zu ersehen, wo das Land offen ist. ");
INSERT INTO deu1912_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Sie antworteten ihm: Wir, deine Knechte, sind zwölf Brüder, eines Mannes Söhne im Lande Kanaan, und der jüngste ist noch bei unserm Vater; aber der eine ist nicht mehr vorhanden. ");
INSERT INTO deu1912_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph sprach zu ihnen: Das ist's, was ich euch gesagt habe: Kundschafter seid ihr. ");
INSERT INTO deu1912_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Daran will ich euch prüfen; bei dem Leben Pharaos! ihr sollt nicht von dannen kommen, es komme denn her euer jüngster Bruder. ");
INSERT INTO deu1912_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sendet einen unter euch hin, der euren Bruder hole; ihr aber sollt gefangen sein. Also will ich prüfen eure Rede, ob ihr mit Wahrheit umgeht oder nicht. Denn wo nicht, so seid ihr, bei dem Leben Pharaos! Kundschafter. ");
INSERT INTO deu1912_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Und er ließ sie beisammen verwahren drei Tage lang. ");
INSERT INTO deu1912_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Am dritten Tage aber sprach er zu ihnen: Wollt ihr leben, so tut also; denn ich fürchte Gott. ");
INSERT INTO deu1912_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Seid ihr redlich, so laßt eurer Brüder einen gebunden liegen in eurem Gefängnis; ihr aber zieht hin und bringet heim, was ihr gekauft habt für den Hunger. ");
INSERT INTO deu1912_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Und bringt euren jüngsten Bruder zu mir, so will ich euren Worten glauben, daß ihr nicht sterben müßt. Und sie taten also. ");
INSERT INTO deu1912_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Sie aber sprachen untereinander: Das haben wir uns an unserm Bruder verschuldet, daß wir sahen die Angst seiner Seele, da er uns anflehte, und wir wollten ihn nicht erhören; darum kommt nun diese Trübsal über uns. ");
INSERT INTO deu1912_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben antwortete ihnen und sprach: Sagte ich's euch nicht, da ich sprach: Versündigt euch nicht an dem Knaben, und ihr wolltet nicht hören? Nun wird sein Blut gefordert. ");
INSERT INTO deu1912_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sie wußten aber nicht, daß es Joseph verstand; denn er redete mit ihnen durch einen Dolmetscher. ");
INSERT INTO deu1912_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Und er wandte sich von ihnen und weinte. Da er nun sich wieder zu ihnen wandte und mit ihnen redete, nahm er aus ihnen Simeon und band ihn vor ihren Augen. ");
INSERT INTO deu1912_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Und Joseph tat Befehl, daß man ihre Säcke mit Getreide füllte und ihr Geld wiedergäbe, einem jeglichen in seinen Sack, dazu auch Zehrung auf den Weg; und man tat ihnen also. ");
INSERT INTO deu1912_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Und sie luden ihre Ware auf ihre Esel und zogen von dannen. ");
INSERT INTO deu1912_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Da aber einer seinen Sack auftat, daß er seinem Esel Futter gäbe in der Herberge, ward er gewahr seines Geldes, das oben im Sack lag, ");
INSERT INTO deu1912_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","und sprach zu seinen Brüdern: Mein Geld ist mir wieder geworden; siehe, in meinem Sack ist es. Da entfiel ihnen ihr Herz, und sie erschraken untereinander und sprachen: Warum hat uns Gott das getan? ");
INSERT INTO deu1912_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Da sie nun heimkamen zu ihrem Vater Jakob ins Land Kanaan, sagten sie ihm alles, was ihnen begegnet war, und sprachen: ");
INSERT INTO deu1912_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Der Mann, der im Lande Herr ist, redete hart mit uns und hielt uns für Kundschafter des Landes. ");
INSERT INTO deu1912_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Und da wir ihm antworteten: Wir sind redlich und nie Kundschafter gewesen, ");
INSERT INTO deu1912_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","sondern zwölf Brüder, unsers Vaters Söhne, einer ist nicht mehr vorhanden, und der jüngste ist noch bei unserm Vater im Lande Kanaan, ");
INSERT INTO deu1912_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","sprach der Herr des Landes zu uns: Daran will ich merken, ob ihr redlich seid: Einen eurer Brüder laßt bei mir, und nehmt die Notdurft für euer Haus und zieht hin, ");
INSERT INTO deu1912_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","und bringt euren jüngsten Bruder zu mir, so merke ich, daß ihr nicht Kundschafter, sondern redlich seid; so will ich euch euren Bruder geben, und ihr mögt im Lande werben. ");
INSERT INTO deu1912_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Und da sie die Säcke ausschütteten, fand ein jeglicher sein Bündlein Geld in seinem Sack. Und da sie sahen, daß es Bündlein ihres Geldes waren, erschraken sie samt ihrem Vater. ");
INSERT INTO deu1912_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Da sprach Jakob, ihr Vater, zu ihnen: Ihr beraubt mich meiner Kinder; Joseph ist nicht mehr vorhanden, Simeon ist nicht mehr vorhanden, Benjamin wollt ihr hinnehmen; es geht alles über mich. ");
INSERT INTO deu1912_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben antwortete seinem Vater und sprach: Wenn ich dir ihn nicht wiederbringe, so erwürge meine zwei Söhne; gib ihn nur in meine Hand, ich will ihn dir wiederbringen. ");
INSERT INTO deu1912_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Er sprach: Mein Sohn soll nicht mit euch hinabziehen, denn sein Bruder ist tot, und er ist allein übriggeblieben; wenn ihm ein Unfall auf dem Wege begegnete, den ihr reiset, würdet ihr meine grauen Haare mit Herzeleid in die Grube bringen. ");
INSERT INTO deu1912_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Die Teuerung aber drückte das Land. ");
INSERT INTO deu1912_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Und da es verzehrt war, was sie an Getreide aus Ägypten gebracht hatten, sprach ihr Vater zu ihnen: Zieht wieder hin und kauft uns ein wenig Speise. ");
INSERT INTO deu1912_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Da antwortete ihm Juda und sprach: Der Mann band uns das hart ein und sprach: Ihr sollt mein Angesicht nicht sehen, es sei denn euer Bruder mit euch. ");
INSERT INTO deu1912_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ist's nun, daß du unsern Bruder mit uns sendest, so wollen wir hinabziehen und dir zu essen kaufen. ");
INSERT INTO deu1912_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ist's aber, daß du ihn nicht sendest, so ziehen wir nicht hinab. Denn der Mann hat gesagt zu uns: Ihr sollt mein Angesicht nicht sehen, euer Bruder sei denn mit euch. ");
INSERT INTO deu1912_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel sprach: Warum habt ihr so übel an mir getan, daß ihr dem Mann ansagtet, daß ihr noch einen Bruder habt? ");
INSERT INTO deu1912_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Sie antworteten: Der Mann forschte so genau nach uns und unsrer Freundschaft und sprach: Lebt euer Vater noch? Habt ihr auch noch einen Bruder? Da sagten wir ihm, wie er uns fragte. Wie konnten wir wissen, daß er sagen würde: Bringt euren Bruder mit hernieder? ");
INSERT INTO deu1912_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Da sprach Juda zu Israel, seinem Vater: Laß den Knaben mit mir ziehen, daß wir uns aufmachen und reisen, und leben und nicht sterben, wir und du und unsre Kindlein. ");
INSERT INTO deu1912_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ich will Bürge für ihn sein, von meinen Händen sollst du ihn fordern. Wenn ich dir ihn nicht wiederbringe und vor deine Augen stelle, so will ich mein Leben lang die Schuld tragen. ");
INSERT INTO deu1912_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Denn wo wir nicht hätten verzogen, wären wir schon wohl zweimal wiedergekommen. ");
INSERT INTO deu1912_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Da sprach Israel, ihr Vater, zu ihnen: Muß es denn ja also sein, so tut's und nehmt von des Landes besten Früchten in eure Säcke und bringt dem Manne Geschenke hinab: ein wenig Balsam und Honig, Würze und Myrrhe, Datteln und Mandeln. ");
INSERT INTO deu1912_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nehmt auch anderes Geld mit euch; und das Geld, das euch oben in euren Säcken wieder geworden ist, bringt auch wieder mit euch. Vielleicht ist ein Irrtum da geschehen. ");
INSERT INTO deu1912_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dazu nehmt euren Bruder, macht euch auf und kommt wieder zu dem Manne. ");
INSERT INTO deu1912_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Aber der allmächtige Gott gebe euch Barmherzigkeit vor dem Manne, daß er euch lasse euren andern Bruder und Benjamin. Ich aber muß sein wie einer, der seiner Kinder gar beraubt ist. ");
INSERT INTO deu1912_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Da nahmen sie diese Geschenke und das Geld zwiefältig mit sich und Benjamin, machten sich auf, zogen nach Ägypten und traten vor Joseph. ");
INSERT INTO deu1912_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Da sah sie Joseph mit Benjamin und sprach zu seinem Haushalter: Führe diese Männer ins Haus und schlachte und richte zu; denn sie sollen zu Mittag mit mir essen. ");
INSERT INTO deu1912_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Und der Mann tat, wie ihm Joseph gesagt hatte, und führte die Männer in Josephs Haus. ");
INSERT INTO deu1912_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Sie fürchteten sich aber, daß sie in Josephs Haus geführt wurden und sprachen: Wir sind hereingeführt um des Geldes willen, das wir in unsern Säcken das erstemal wiedergefunden haben, daß er's auf uns bringe und fälle ein Urteil über uns, damit er uns nehme zu eigenen Knechten samt unsern Eseln. ");
INSERT INTO deu1912_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Darum traten sie zu Josephs Haushalter und redeten mit ihm vor der Haustür ");
INSERT INTO deu1912_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","und sprachen: Mein Herr, wir sind das erstemal herabgezogen Speise zu kaufen, ");
INSERT INTO deu1912_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","und da wir in die Herberge kamen und unsere Säcke auftaten, siehe, da war eines jeglichen Geld oben in seinem Sack mit völligem Gewicht; darum haben wir's wieder mit uns gebracht, ");
INSERT INTO deu1912_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","haben auch anderes Geld mit uns hergebracht, Speise zu kaufen; wir wissen aber nicht, wer uns unser Geld in unsre Säcke gesteckt hat. ");
INSERT INTO deu1912_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Er aber sprach: Gehabt euch wohl, fürchtet euch nicht. Euer Gott hat euch einen Schatz gegeben in eure Säcke. Euer Geld ist mir geworden. Und er führte Simeon zu ihnen heraus ");
INSERT INTO deu1912_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","und führte sie in Josephs Haus, gab ihnen Wasser, daß sie ihre Füße wuschen, und gab ihren Eseln Futter. ");
INSERT INTO deu1912_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Sie aber bereiteten das Geschenk zu, bis das Joseph kam auf den Mittag; denn sie hatten gehört, daß sie daselbst das Brot essen sollten. ");
INSERT INTO deu1912_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Da nun Joseph zum Hause einging, brachten sie ihm ins Haus das Geschenk in ihren Händen und fielen vor ihm nieder zur Erde. ");
INSERT INTO deu1912_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Er aber grüßte sie freundlich und sprach: Geht es eurem Vater, dem Alten, wohl, von dem ihr mir sagtet? Lebt er noch? ");
INSERT INTO deu1912_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Sie antworteten: Es geht deinem Knechte, unserm Vater, wohl, und er lebt noch. Und sie neigten sich und fielen vor ihm nieder. ");
INSERT INTO deu1912_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Und er hob seine Augen auf und sah seinen Bruder Benjamin, seiner Mutter Sohn, und sprach: Ist das euer jüngster Bruder, von dem ihr mir sagtet? und sprach weiter: Gott sei dir gnädig, mein Sohn! ");
INSERT INTO deu1912_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Und Joseph eilte, denn sein Herz entbrannte ihm gegen seinen Bruder, und suchte, wo er weinte, und ging in seine Kammer und weinte daselbst. ");
INSERT INTO deu1912_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Und da er sein Angesicht gewaschen hatte, ging er heraus und hielt sich fest und sprach: Legt Brot auf! ");
INSERT INTO deu1912_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Und man trug ihm besonders auf und jenen auch besonders und den Ägyptern, die mit ihm aßen auch besonders. Denn die Ägypter dürfen nicht Brot essen mit den Hebräern, denn es ist ein Greuel vor ihnen. ");
INSERT INTO deu1912_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Und man setzte sie ihm gegenüber, den Erstgeborenen nach seiner Erstgeburt und den Jüngsten nach seiner Jugend. Des verwunderten sie sich untereinander. ");
INSERT INTO deu1912_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Und man trug ihnen Essen vor von seinem Tisch; aber dem Benjamin ward fünfmal mehr denn den andern. Und sie tranken und wurden fröhlich mit ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Und Joseph befahl seinem Haushalter und sprach: Fülle den Männern ihre Säcke mit Speise, soviel sie führen können, lege jeglichem sein Geld oben in seinen Sack; ");
INSERT INTO deu1912_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","und meinen silbernen Becher lege oben in des Jüngsten Sack mit dem Gelde für das Getreide. Der tat, wie ihm Joseph gesagt hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Des Morgens, da es licht ward, ließen sie die Männer ziehen mit ihren Eseln. ");
INSERT INTO deu1912_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Da sie aber zur Stadt hinaus waren und nicht ferne gekommen, sprach Joseph zu seinem Haushalter: Auf jage den Männern nach! und wenn du sie ereilst, so sprich zu ihnen: Warum habt ihr Gutes mit Bösem vergolten? ");
INSERT INTO deu1912_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ist's nicht das, daraus mein Herr trinkt und damit er weissagt? Ihr habt übel getan. ");
INSERT INTO deu1912_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Und als er sie ereilte, redete er mit ihnen solche Worte. ");
INSERT INTO deu1912_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Sie antworteten ihm: Warum redet mein Herr solche Worte? Es sei ferne von deinen Knechten, ein solches zu tun. ");
INSERT INTO deu1912_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Siehe, das Geld, das wir fanden oben in unsern Säcken, haben wir wiedergebracht zu dir aus dem Lande Kanaan. Und wie sollten wir denn aus deines Herrn Hause gestohlen haben Silber und Gold? ");
INSERT INTO deu1912_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bei welchem er gefunden wird unter deinen Knechten, der sei des Todes; dazu wollen auch wir meines Herrn Knechte sein. ");
INSERT INTO deu1912_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Er sprach: Ja, es sei, wie ihr geredet habt. Bei welchem er gefunden wird, der sei mein Knecht; ihr aber sollt ledig sein. ");
INSERT INTO deu1912_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Und sie eilten, und ein jeglicher legte seinen Sack ab auf die Erde, und ein jeglicher tat seinen Sack auf. ");
INSERT INTO deu1912_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Und er suchte und hob am Ältesten an bis auf den Jüngsten; da fand sich der Becher in Benjamins Sack. ");
INSERT INTO deu1912_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Da zerrissen sie ihre Kleider und belud ein jeglicher seinen Esel und zogen wieder in die Stadt. ");
INSERT INTO deu1912_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Und Juda ging mit seinen Brüdern in Josephs Haus, denn er war noch daselbst; und sie fielen vor ihm nieder auf die Erde. ");
INSERT INTO deu1912_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph aber sprach zu ihnen: Wie habt ihr das tun dürfen? Wißt ihr nicht, daß ein solcher Mann, wie ich, erraten könne? ");
INSERT INTO deu1912_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda sprach: Was sollen wir sagen meinem Herrn, oder wie sollen wir reden, und womit können wir uns rechtfertigen? Gott hat die Missetat deiner Knechte gefunden. Siehe da, wir und der, bei dem der Becher gefunden ist, sind meines Herrn Knechte. ");
INSERT INTO deu1912_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Er aber sprach: Das sei ferne von mir, solches zu tun! Der Mann, bei dem der Becher gefunden ist, soll mein Knecht sein; ihr aber zieht hinauf mit Frieden zu eurem Vater. ");
INSERT INTO deu1912_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Da trat Juda zu ihm und sprach: Mein Herr, laß deinen Knecht ein Wort reden vor den Ohren meines Herrn, und dein Zorn ergrimme nicht über deinen Knecht; denn du bist wie Pharao. ");
INSERT INTO deu1912_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mein Herr fragte seine Knechte und sprach: Habt ihr auch einen Vater oder Bruder? ");
INSERT INTO deu1912_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Da antworteten wir: Wir haben einen Vater, der ist alt, und einen jungen Knaben, in seinem Alter geboren; und sein Bruder ist tot, und er ist allein übriggeblieben von seiner Mutter, und sein Vater hat ihn lieb. ");
INSERT INTO deu1912_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Da sprachst du zu deinen Knechten: Bringet ihn herab zu mir; ich will ihm Gnade erzeigen. ");
INSERT INTO deu1912_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Wir aber antworteten meinem Herrn: Der Knabe kann nicht von seinem Vater kommen; wo er von ihm käme, würde er sterben. ");
INSERT INTO deu1912_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Da sprachst du zu deinen Knechten: Wo euer jüngster Bruder nicht mit euch herkommt, sollt ihr mein Angesicht nicht mehr sehen. ");
INSERT INTO deu1912_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Da zogen wir hinauf zu deinem Knecht, unserm Vater, und sagten ihm meines Herrn Rede. ");
INSERT INTO deu1912_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Da sprach unser Vater: Zieht wieder hin und kauft uns ein wenig Speise. ");
INSERT INTO deu1912_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Wir aber sprachen: wir können nicht hinabziehen, es sei denn unser jüngster Bruder mit uns, so wollen wir hinabziehen; denn wir können des Mannes Angesicht nicht sehen, wenn unser jüngster Bruder nicht mit uns ist. ");
INSERT INTO deu1912_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Da sprach dein Knecht, mein Vater, zu uns: Ihr wisset, daß mir mein Weib zwei Söhne geboren hat; ");
INSERT INTO deu1912_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","einer ging hinaus von mir, und man sagte: Er ist zerrissen; und ich habe ihn nicht gesehen bisher. ");
INSERT INTO deu1912_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Werdet ihr diesen auch von mir nehmen und widerfährt ihm ein Unfall, so werdet ihr meine grauen Haare mit Jammer hinunter in die Grube bringen. ");
INSERT INTO deu1912_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Nun, so ich heimkäme zu deinem Knecht, meinem Vater, und der Knabe wäre nicht mit uns, an des Seele seine Seele hanget, ");
INSERT INTO deu1912_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","so wird's geschehen, wenn er sieht, daß der Knabe nicht da ist, daß er stirbt; so würden wir, deine Knechte, die grauen Haare deines Knechtes, unsers Vaters, mit Herzeleid in die Grube bringen. ");
INSERT INTO deu1912_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Denn ich, dein Knecht, bin Bürge geworden für den Knaben gegen meinen Vater und sprach: Bringe ich ihn dir nicht wieder, so will ich mein Leben lang die Schuld tragen. ");
INSERT INTO deu1912_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Darum laß deinen Knecht hier bleiben an des Knaben Statt zum Knecht meines Herrn und den Knaben mit seinen Brüdern hinaufziehen. ");
INSERT INTO deu1912_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Denn wie soll ich hinaufziehen zu meinem Vater, wenn der Knabe nicht mit mir ist? Ich würde den Jammer sehen müssen, der meinem Vater begegnen würde. ");
INSERT INTO deu1912_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Da konnte sich Joseph nicht länger enthalten vor allen, die um ihn her standen, und er rief: Laßt jedermann von mir hinausgehen! Und kein Mensch stand bei ihm, da sich Joseph seinen Brüdern zu erkennen gab. ");
INSERT INTO deu1912_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Und er weinte laut, daß es die Ägypter und das Gesinde des Pharao hörten, ");
INSERT INTO deu1912_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","und sprach zu seinen Brüdern: Ich bin Joseph. Lebt mein Vater noch? und seine Brüder konnten ihm nicht antworten, so erschraken sie vor seinem Angesicht. ");
INSERT INTO deu1912_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Er aber sprach zu seinen Brüdern: Tretet doch her zu mir! Und sie traten herzu. Und er sprach: Ich bin Joseph euer Bruder, den ihr nach Ägypten verkauft habt. ");
INSERT INTO deu1912_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Und nun bekümmert euch nicht und denkt nicht, daß ich darum zürne, daß ihr mich hierher verkauft habt; denn um eures Lebens willen hat mich Gott vor euch her gesandt. ");
INSERT INTO deu1912_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Denn dies sind zwei Jahre, daß es teuer im Lande ist; und sind noch fünf Jahre, daß kein Pflügen und Ernten sein wird. ");
INSERT INTO deu1912_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Aber Gott hat mich vor euch her gesandt, daß er euch übrig behalte auf Erden und euer Leben errette durch eine große Errettung. ");
INSERT INTO deu1912_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Und nun, ihr habt mich nicht hergesandt, sondern Gott, der hat mich Pharao zum Vater gesetzt und zum Herrn über all sein Haus und zum Fürsten in ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Eilet nun und zieht hinauf zu meinem Vater und sagt ihm: Das läßt dir Joseph, dein Sohn, sagen: Gott hat mich zum Herrn in ganz Ägypten gesetzt; komm herab zu mir, säume nicht; ");
INSERT INTO deu1912_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","du sollst im Lande Gosen wohnen und nahe bei mir sein, du und deine Kinder und deine Kindeskinder, dein kleines und dein großes Vieh und alles, was du hast. ");
INSERT INTO deu1912_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ich will dich daselbst versorgen; denn es sind noch fünf Jahre der Teuerung, auf daß du nicht verderbest mit deinem Hause und allem, was du hast. ");
INSERT INTO deu1912_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Siehe, eure Augen sehen und die Augen meines Bruders Benjamin, daß ich mündlich mit euch rede. ");
INSERT INTO deu1912_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Verkündigt meinem Vater alle meine Herrlichkeit in Ägypten und alles, was ihr gesehen habt; eilt und kommt hernieder mit meinem Vater hierher. ");
INSERT INTO deu1912_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Und er fiel seinem Bruder Benjamin um den Hals und weinte; und Benjamin weinte auch an seinem Halse. ");
INSERT INTO deu1912_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Und er küßte alle seine Brüder und weinte über ihnen. Darnach redeten seine Brüder mit ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Und da das Gerücht kam in Pharaos Haus, daß Josephs Brüder gekommen wären, gefiel es Pharao wohl und allen seinen Knechten. ");
INSERT INTO deu1912_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Und Pharao sprach zu Joseph: Sage deinen Brüdern: Tut also, beladet eure Tiere, zieht hin; ");
INSERT INTO deu1912_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","und wenn ihr kommt ins Land Kanaan, so nehmt euren Vater und alle die Euren und kommt zu mir; ich will euch Güter geben in Ägyptenland, daß ihr essen sollt das Mark im Lande; ");
INSERT INTO deu1912_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","und gebiete ihnen: Tut also, nehmet Wagen für eure Kinder und Weiber und führet euren Vater und kommt; ");
INSERT INTO deu1912_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","und sehet euren Hausrat nicht an; denn die Güter des ganzen Landes Ägypten sollen euer sein. ");
INSERT INTO deu1912_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Die Kinder Israels taten also. Und Joseph gab ihnen Wagen nach dem Befehl Pharaos und Zehrung auf den Weg ");
INSERT INTO deu1912_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","und gab ihnen allen, einem jeglichem, ein Feierkleid; aber Benjamin gab er dreihundert Silberlinge und fünf Feierkleider. ");
INSERT INTO deu1912_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Und seinem Vater sandte er dabei zehn Esel, mit Gut aus Ägypten beladen, und zehn Eselinnen mit Getreide und Brot und Speise seinem Vater auf den Weg. ");
INSERT INTO deu1912_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Also ließ er seine Brüder von sich, und sie zogen hin; und er sprach zu ihnen: Zanket nicht auf dem Wege! ");
INSERT INTO deu1912_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Also zogen sie hinauf von Ägypten und kamen ins Land Kanaan zu ihrem Vater Jakob ");
INSERT INTO deu1912_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","und verkündigten ihm und sprachen: Joseph lebt noch und ist Herr im ganzen Ägyptenland. Aber sein Herz dachte gar viel anders, denn er glaubte ihnen nicht. ");
INSERT INTO deu1912_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Da sagten sie ihm alle Worte Josephs, die er zu ihnen gesagt hatte. Und da er sah die Wagen, die ihm Joseph gesandt hatte, ihn zu führen, ward der Geist Jakobs, ihres Vaters, lebendig, ");
INSERT INTO deu1912_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","und Israel sprach: Ich habe genug, daß mein Sohn noch lebt; ich will hin und ihn sehen, ehe ich sterbe. ");
INSERT INTO deu1912_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel zog hin mit allem, was er hatte. Und da er gen Beer-Seba kam, opferte er dem Gott seines Vaters Isaak. ");
INSERT INTO deu1912_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Und Gott sprach zu ihm des Nachts im Gesicht: Jakob, Jakob! Er sprach: Hier bin ich. ");
INSERT INTO deu1912_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Und er sprach: Ich bin Gott, der Gott deines Vaters; fürchte dich nicht, nach Ägypten hinabzuziehen, denn daselbst will ich dich zum großen Volk machen. ");
INSERT INTO deu1912_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ich will mit dir hinab nach Ägypten ziehen und will dich auch wieder heraufführen; und Joseph soll seine Hände auf deine Augen legen. ");
INSERT INTO deu1912_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Da machte sich Jakob auf von Beer-Seba; und die Kinder Israels führten Jakob, ihren Vater, mit ihren Kindlein und Weibern auf den Wagen, die Pharao gesandt hatte, ihn zu führen, ");
INSERT INTO deu1912_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","und nahmen ihr Vieh und ihre Habe, die sie im Lande Kanaan erworben hatten, und kamen also nach Ägypten, Jakob und all sein Same mit ihm, ");
INSERT INTO deu1912_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","seine Söhne und seine Kindessöhne mit ihm, seine Töchter und seine Kindestöchter und all sein Same; die brachte er mit sich nach Ägypten. ");
INSERT INTO deu1912_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dies sind die Namen der Kinder Israel, die nach Ägypten kamen: Jakob, und seine Söhne. Der erstgeborene Sohn Jakobs, Ruben. ");
INSERT INTO deu1912_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Die Kinder Rubens: Henoch, Pallu, Hezron und Charmi. ");
INSERT INTO deu1912_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Die Kinder Simeons: Jemuel, Jamin, Ohad, Jachin, Zohar und Saul, der Sohn von dem kanaanitischen Weibe. ");
INSERT INTO deu1912_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Die Kinder Levis: Gerson, Kahath und Merari. ");
INSERT INTO deu1912_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Die Kinder Juda's: Ger, Onan, Sela, Perez und Serah. Aber Ger und Onan waren gestorben im Lande Kanaan. Die Kinder aber des Perez: Hezron und Hamul. ");
INSERT INTO deu1912_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Die Kinder Isaschars: Thola, Phuva, Job und Simron. ");
INSERT INTO deu1912_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Die Kinder Sebulons: Sered, Elon und Jahleel. ");
INSERT INTO deu1912_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Das sind die Kinder von Lea, die sie Jakob gebar in Mesopotamien mit seiner Tochter Dina. Die machen allesamt mit Söhnen und Töchtern dreiunddreißig Seelen. ");
INSERT INTO deu1912_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Die Kinder Gads: Ziphjon, Haggi, Suni, Ezbon, Eri, Arodi und Areli. ");
INSERT INTO deu1912_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Die Kinder Assers: Jimna, Jiswa, Jiswi, Beria und Serah, ihre Schwester. Aber die Kinder Berias: Heber und Malchiel. ");
INSERT INTO deu1912_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Das sind die Kinder von Silpa, die Laban gab Lea, seiner Tochter, und sie gebar Jakob diese sechzehn Seelen. ");
INSERT INTO deu1912_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Die Kinder Rahels, des Weibes Jakobs: Joseph und Benjamin. ");
INSERT INTO deu1912_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Und Joseph wurden geboren in Ägyptenland Manasse und Ephraim, die ihm gebar Asnath, die Tochter Potipheras, des Priesters zu On. ");
INSERT INTO deu1912_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Die Kinder Benjamins: Bela, Becher, Asbel, Gera, Naaman, Ehi, Ros, Muppim, Huppim und Ard. ");
INSERT INTO deu1912_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Das sind die Kinder von Rahel, die Jakob geboren sind, allesamt vierzehn Seelen. ");
INSERT INTO deu1912_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Die Kinder Dans: Husim. ");
INSERT INTO deu1912_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Die Kinder Naphthalis: Jahzeel, Guni, Jezer und Sillem. ");
INSERT INTO deu1912_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Das sind die Kinder Bilhas, die Laban seiner Tochter Rahel gab, und sie gebar Jakob die sieben Seelen. ");
INSERT INTO deu1912_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Alle Seelen, die mit Jakob nach Ägypten kamen, die aus seinen Lenden gekommen waren (ausgenommen die Weiber seiner Kinder), sind alle zusammen sechundsechzig Seelen, ");
INSERT INTO deu1912_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Und die Kinder Josephs, die in Ägypten geboren sind, waren zwei Seelen, also daß alle Seelen des Hauses Jakobs, die nach Ägypten kamen, waren siebzig. ");
INSERT INTO deu1912_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Und er sandte Juda vor sich hin zu Joseph, das dieser ihn anwiese zu Gosen; und sie kamen in das Land Gosen. ");
INSERT INTO deu1912_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Da spannte Joseph seinen Wagen an und zog hinauf, seinem Vater Israel entgegen, nach Gosen. Und da er ihn sah, fiel er ihm um den Hals und weinte lange an seinem Halse. ");
INSERT INTO deu1912_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Da sprach Israel zu Joseph: Ich will nun gerne sterben, nachdem ich dein Angesicht gesehen habe, daß du noch lebst. ");
INSERT INTO deu1912_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph sprach zu seinen Brüdern und seines Vaters Hause: Ich will hinaufziehen und Pharao ansagen und zu ihm sprechen: Meine Brüder und meines Vaters Haus sind zu mir gekommen aus dem Lande Kanaan, ");
INSERT INTO deu1912_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","und sind Viehhirten, denn es sind Leute, die mit Vieh umgehen; Ihr kleines und großes Vieh und alles, was sie haben, haben sie mitgebracht. ");
INSERT INTO deu1912_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Wenn euch nun Pharao wird rufen und sagen: Was ist eure Nahrung? ");
INSERT INTO deu1912_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","so sollt ihr sagen: Deine Knechte sind Leute, die mit Vieh umgehen, von unsrer Jugend auf bis her, beide, wir und unsre Väter, auf daß ihr wohnen möget im Lande Gosen. Denn was Viehhirten sind, das ist den Ägyptern ein Greuel. ");
INSERT INTO deu1912_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Da kam Joseph und sagte es Pharao an und sprach: Mein Vater und meine Brüder, ihr kleines und großes Vieh und alles, was sie haben, sind gekommen aus dem Lande Kanaan; und siehe sie sind im Lande Gosen. ");
INSERT INTO deu1912_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Und er nahm aus allen seinen Brüdern fünf und stellte sie vor Pharao. ");
INSERT INTO deu1912_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Da sprach Pharao zu seinen Brüdern: Was ist eure Nahrung? Sie antworteten: Deine Knechte sind Viehhirten, wir und unsere Väter; ");
INSERT INTO deu1912_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","und sagten weiter zu Pharao: Wir sind gekommen, bei euch zu wohnen im Lande; denn deine Knechte haben nicht Weide für ihr Vieh, so hart drückt die Teuerung das Land Kanaan; so laß doch nun deine Knechte im Lande Gosen wohnen. ");
INSERT INTO deu1912_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharao sprach zu Joseph: Es ist dein Vater und sind deine Brüder, die sind zu dir gekommen; ");
INSERT INTO deu1912_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","das Land Ägypten steht dir offen, laß sie am besten Ort des Landes wohnen, laß sie im Lande Gosen wohnen; und so du weißt, daß Leute unter ihnen sind, die tüchtig sind, so setze sie über mein Vieh. ");
INSERT INTO deu1912_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joseph brachte auch seinen Vater Jakob hinein und stellte ihn vor Pharao. Und Jakob segnete den Pharao. ");
INSERT INTO deu1912_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharao aber fragte Jakob: Wie alt bist du? ");
INSERT INTO deu1912_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob sprach: Die Zeit meiner Wallfahrt ist hundertdreißig Jahre; wenig und böse ist die Zeit meines Lebens und langt nicht an die Zeit meiner Väter in ihrer Wallfahrt. ");
INSERT INTO deu1912_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Und Jakob segnete den Pharao und ging heraus von ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Aber Joseph schaffte seinem Vater und seinen Brüdern Wohnung und gab ihnen Besitz in Ägyptenland, am besten Ort des Landes, im Lande Raemses, wie Pharao geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Und er versorgte seinen Vater und seine Brüder und das ganze Haus seines Vaters mit Brot, einen jeglichen, nachdem er Kinder hatte. ");
INSERT INTO deu1912_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Es war aber kein Brot in allen Landen; denn die Teuerung war sehr schwer, daß das Land Ägypten und Kanaan verschmachteten vor der Teuerung. ");
INSERT INTO deu1912_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Und Joseph brachte alles Geld zusammen, das in Ägypten und Kanaan gefunden ward, um das Getreide, das sie kauften; und Joseph tat alles Geld in das Haus Pharaos. ");
INSERT INTO deu1912_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Da nun Geld gebrach im Lande Ägypten und Kanaan, kamen alle Ägypter zu Joseph und sprachen: Schaffe uns Brot! Warum läßt du uns vor dir sterben, darum daß wir ohne Geld sind? ");
INSERT INTO deu1912_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph sprach: Schafft euer Vieh her, so will ich euch um das Vieh geben, weil ihr ohne Geld seid. ");
INSERT INTO deu1912_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Da brachten sie Joseph ihr Vieh; und er gab ihnen Brot um ihre Pferde, Schafe, Rinder und Esel. Also ernährte er sie mit Brot das Jahr um all ihr Vieh. ");
INSERT INTO deu1912_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Da das Jahr um war, kamen sie zu ihm im zweiten Jahr und sprachen zu ihm: Wir wollen unserm Herrn nicht verbergen, daß nicht allein das Geld sondern auch alles Vieh dahin ist zu unserm Herrn; und ist nichts mehr übrig vor unserm Herrn denn unsre Leiber und unser Feld. ");
INSERT INTO deu1912_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Warum läßt du uns vor dir sterben und unser Feld? Kaufe uns und unser Land ums Brot, daß wir und unser Land leibeigen seien dem Pharao; gib uns Samen, daß wir leben und nicht sterben und das Feld nicht wüst werde. ");
INSERT INTO deu1912_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Also kaufte Joseph dem Pharao das ganze Ägypten. Denn die Ägypter verkauften ein jeglicher seinen Acker, denn die Teuerung war zu stark über sie. Und ward also das Land Pharao eigen. ");
INSERT INTO deu1912_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Und er teilte das Volk aus in die Städte, von einem Ende Ägyptens bis ans andere. ");
INSERT INTO deu1912_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ausgenommen der Priester Feld. Das kaufte er nicht; denn es war von Pharao für die Priester verordnet, daß sie sich nähren sollten von dem Verordneten, das er ihnen gegeben hatte; darum brauchten sie ihr Feld nicht zu verkaufen. ");
INSERT INTO deu1912_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Da sprach Joseph zu dem Volk: Siehe, ich habe heute gekauft euch und euer Feld dem Pharao; siehe, da habt ihr Samen und besäet das Feld. ");
INSERT INTO deu1912_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Und von dem Getreide sollt ihr den Fünften geben; vier Teile sollen euer sein, zu besäen das Feld und zu eurer Speise und für euer Haus und eure Kinder. ");
INSERT INTO deu1912_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Sie sprachen: Du hast uns am Leben erhalten; laß uns nur Gnade finden vor dir, unserm Herrn, so wollen wir gerne Pharao leibeigen sein. ");
INSERT INTO deu1912_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Also machte Joseph ihnen ein Gesetz bis auf diesen Tag über der Ägypter Feld, den Fünften Pharao zu geben; ausgenommen der Priester Feld, das ward dem Pharao nicht eigen. ");
INSERT INTO deu1912_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Also wohnte Israel in Ägypten im Lande Gosen, und hatten's inne und wuchsen und mehrten sich sehr. ");
INSERT INTO deu1912_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Und Jakob lebte siebzehn Jahre in Ägyptenland, daß sein ganzes Alter ward hundertsiebenundvierzig Jahre. ");
INSERT INTO deu1912_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Da nun die Zeit herbeikam, daß Israel sterben sollte, rief er seinen Sohn Joseph und sprach zu ihm: Habe ich Gnade vor dir gefunden, so lege deine Hand unter meine Hüfte, daß du mir die Liebe und Treue an mir tust und begrabest mich nicht in Ägypten; ");
INSERT INTO deu1912_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","sondern ich will liegen bei meinen Vätern, und du sollst mich aus Ägypten führen und in ihrem Begräbnis begraben. Er sprach: Ich will tun, wie du gesagt hast. ");
INSERT INTO deu1912_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Er aber sprach: So schwöre mir. Und er schwur ihm. Da neigte sich Israel zu Häupten des Bettes. ");
INSERT INTO deu1912_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Darnach ward Joseph gesagt: Siehe, dein Vater ist krank. Und er nahm mit sich seine beiden Söhne, Manasse und Ephraim. ");
INSERT INTO deu1912_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Da ward's Jakob angesagt: Siehe, dein Sohn Joseph kommt zu dir. Und Israel machte sich stark und setzte sich im Bette ");
INSERT INTO deu1912_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","und sprach zu Joseph: Der allmächtige Gott erschien mir zu Lus im Lande Kanaan und segnete mich ");
INSERT INTO deu1912_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","und sprach zu mir: Siehe, ich will dich wachsen lassen und mehren und will dich zum Haufen Volks machen und will dies Land zu eigen geben deinem Samen nach dir ewiglich. ");
INSERT INTO deu1912_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","So sollen nun deine zwei Söhne, Ephraim und Manasse, die dir geboren sind in Ägyptenland, ehe ich hereingekommen bin zu dir, mein sein gleich wie Ruben und Simeon. ");
INSERT INTO deu1912_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Welche du aber nach ihnen zeugest, sollen dein sein und genannt werden nach dem Namen ihrer Brüder in deren Erbteil. ");
INSERT INTO deu1912_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Und da ich aus Mesopotamien kam starb mir Rahel im Lande Kanaan auf dem Weg, da noch ein Feld Weges war gen Ephrath; und ich begrub sie daselbst an dem Wege Ephraths, das nun Bethlehem heißt. ");
INSERT INTO deu1912_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Und Israel sah die Söhne Josephs und sprach: Wer sind die? ");
INSERT INTO deu1912_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph antwortete seinem Vater: Es sind meine Söhne, die mir Gott hier gegeben hat. Er sprach: Bringe sie her zu mir, daß ich sie segne. ");
INSERT INTO deu1912_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Denn die Augen Israels waren dunkel geworden vor Alter, und er konnte nicht wohl sehen. Und er brachte sie zu ihm. Er aber küßte sie und herzte sie ");
INSERT INTO deu1912_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","und sprach zu Joseph: Siehe, ich habe dein Angesicht gesehen, was ich nicht gedacht hätte; und siehe, Gott hat mich auch deinen Samen sehen lassen. ");
INSERT INTO deu1912_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Und Joseph nahm sie von seinem Schoß und neigte sich zur Erde gegen sein Angesicht. ");
INSERT INTO deu1912_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Da nahm sie Joseph beide, Ephraim in seine rechte Hand gegen Israels linke Hand und Manasse in seine Linke Hand gegen Israels rechte Hand, und brachte sie zu ihm. ");
INSERT INTO deu1912_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Aber Israel streckte seine rechte Hand aus und legte sie auf Ephraims, des Jüngeren, Haupt und seine linke auf Manasses Haupt und tat wissend also mit seinen Händen, denn Manasse war der Erstgeborene. ");
INSERT INTO deu1912_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Und er segnete Joseph und sprach: Der Gott, vor dem meine Väter, Abraham und Isaak, gewandelt haben, der Gott, der mein Hirte gewesen ist mein Leben lang bis auf diesen Tag, ");
INSERT INTO deu1912_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","der Engel, der mich erlöst hat von allem Übel, der segne diese Knaben, daß sie nach meiner Väter Abrahams und Isaaks, Namen genannt werden, daß sie wachsen und viel werden auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Da aber Joseph sah, daß sein Vater die rechte Hand auf Ephraims Haupt legte, gefiel es ihm übel, und er faßte seines Vaters Hand, daß er sie von Ephraim Haupt auf Manasses Haupt wendete, ");
INSERT INTO deu1912_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","und sprach zu ihm: Nicht so, mein Vater; dieser ist der Erstgeborene, lege deine rechte Hand auf sein Haupt. ");
INSERT INTO deu1912_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aber sein Vater weigerte sich und sprach: Ich weiß wohl, mein Sohn, ich weiß wohl. Dieser soll auch ein Volk werden und wird groß sein; aber sein jüngerer Bruder wird größer denn er werden, und sein Same wird ein großes Volk werden. ");
INSERT INTO deu1912_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Also segnete er sie des Tages und sprach: Wer in Israel will jemand segnen, der sage: Gott setze dich wie Ephraim und Manasse! und setzte also Ephraim Manasse vor. ");
INSERT INTO deu1912_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Und Israel sprach zu Joseph: Siehe, ich sterbe; und Gott wird mit euch sein und wird euch wiederbringen in das Land eurer Väter. ");
INSERT INTO deu1912_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ich habe dir ein Stück Land zu geben vor deinen Brüdern, das ich mit Schwert und Bogen aus der Amoriter Hand genommen habe. ");
INSERT INTO deu1912_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Und Jakob berief seine Söhne und sprach: Versammelt euch, daß ich euch verkündige, was euch begegnen wird in künftigen Zeiten. ");
INSERT INTO deu1912_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kommt zuhauf und höret zu, ihr Kinder Jakobs, und höret euren Vater Israel. ");
INSERT INTO deu1912_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, mein erster Sohn bist du, meine Kraft, und der Erstling meiner Stärke, der Oberste in der Würde und der Oberste in der Macht. ");
INSERT INTO deu1912_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Er fuhr leichtfertig dahin wie Wasser. Du sollst nicht der Oberste sein; denn du bist auf deines Vaters Lager gestiegen, daselbst hast du mein Bett entweiht mit dem Aufsteigen. ");
INSERT INTO deu1912_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Die Brüder Simeon und Levi, ihre Schwerter sind mörderische Waffen. ");
INSERT INTO deu1912_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Meine Seele komme nicht in ihren Rat, und meine Ehre sei nicht in ihrer Versammlung; denn in ihrem Zorn haben sie den Mann erwürgt, und in ihrem Mutwillen haben sie den Ochsen verlähmt. ");
INSERT INTO deu1912_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Verflucht sei ihr Zorn, daß er so heftig ist und ihr Grimm, daß er so störrig ist. Ich will sie zerteilen in Jakob und zerstreuen in Israel. ");
INSERT INTO deu1912_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, du bist's; dich werden deine Brüder loben. Deine Hand wird deinen Feinden auf dem Halse sein; vor dir werden deines Vaters Kinder sich neigen. ");
INSERT INTO deu1912_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda ist ein junger Löwe. Du bist hoch gekommen, mein Sohn, durch große Siege. Er ist niedergekniet und hat sich gelagert wie ein Löwe und wie eine Löwin; wer will sich wider ihn auflehnen? ");
INSERT INTO deu1912_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Es wird das Zepter von Juda nicht entwendet werden noch der Stab des Herrschers von seinen Füßen, bis daß der Held komme; und demselben werden die Völker anhangen. ");
INSERT INTO deu1912_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Er wird sein Füllen an den Weinstock binden und seiner Eselin Sohn an die edle Rebe. Er wird sein Kleid in Wein waschen und seinen Mantel im Weinbeerblut. ");
INSERT INTO deu1912_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Seine Augen sind trübe vom Wein und seine Zähne weiß von Milch. ");
INSERT INTO deu1912_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon wird an der Anfurt des Meeres wohnen und an der Anfurt der Schiffe und reichen an Sidon. ");
INSERT INTO deu1912_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaschar wird ein knochiger Esel sein und sich lagern zwischen den Hürden. ");
INSERT INTO deu1912_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Und er sah die Ruhe, daß sie gut ist, und das Land, daß es lustig ist; da hat er seine Schultern geneigt, zu tragen, und ist ein zinsbarer Knecht geworden. ");
INSERT INTO deu1912_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan wird Richter sein in seinem Volk wie ein ander Geschlecht in Israel. ");
INSERT INTO deu1912_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan wird eine Schlange werden auf dem Wege und eine Otter auf dem Steige und das Pferd in die Ferse beißen, daß sein Reiter zurückfalle. ");
INSERT INTO deu1912_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","HERR, ich warte auf dein Heil! ");
INSERT INTO deu1912_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad wird gedrängt werden von Kriegshaufen, er aber drängt sie auf der Ferse. ");
INSERT INTO deu1912_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Von Asser kommt sein fettes Brot, und er wird den Königen leckere Speise geben. ");
INSERT INTO deu1912_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphthali ist ein schneller Hirsch und gibt schöne Rede. ");
INSERT INTO deu1912_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph wird wachsen, er wird wachsen wie ein Baum an der Quelle, daß die Zweige emporsteigen über die Mauer. ");
INSERT INTO deu1912_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Und wiewohl ihn die Schützen erzürnen und wider ihn kriegen und ihn verfolgen, ");
INSERT INTO deu1912_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","so bleibt doch sein Bogen fest und die Arme seiner Hände stark durch die Hände des Mächtigen in Jakob, durch ihn, den Hirten und Stein Israels. ");
INSERT INTO deu1912_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Von deines Vaters Gott ist dir geholfen, und von dem Allmächtigen bist du gesegnet mit Segen oben vom Himmel herab, mit Segen von der Tiefe, die unten liegt, mit Segen der Brüste und des Mutterleibes. ");
INSERT INTO deu1912_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Die Segen deines Vaters gehen stärker denn die Segen meiner Voreltern, nach Wunsch der Hohen in der Welt, und sollen kommen auf das Haupt Josephs und auf den Scheitel des Geweihten unter seinen Brüdern. ");
INSERT INTO deu1912_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin ist ein reißender Wolf; des Morgens wird er Raub fressen, und des Abends wird er Beute austeilen. ");
INSERT INTO deu1912_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Das sind die zwölf Stämme Israels alle, und das ist's was ihr Vater mit ihnen geredet hat, da er sie segnete, einen jeglichen mit einem besonderen Segen. ");
INSERT INTO deu1912_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Und er gebot ihnen und sprach zu ihnen: Ich werde versammelt zu meinem Volk; begrabt mich zu meinen Vätern in der Höhle auf dem Acker Ephrons, des Hethiters, ");
INSERT INTO deu1912_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in der zwiefachen Höhle, die gegenüber Mamre liegt, im Lande Kanaan, die Abraham kaufte samt dem Acker von Ephron, dem Hethiter, zum Erbbegräbnis. ");
INSERT INTO deu1912_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Daselbst haben sie Abraham begraben und Sara, sein Weib. Daselbst haben sie auch Isaak begraben und Rebekka, sein Weib. Daselbst habe ich auch Lea begraben, ");
INSERT INTO deu1912_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","in dem Acker und der Höhle, die von den Kindern Heth gekauft ist. ");
INSERT INTO deu1912_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Und da Jakob vollendet hatte die Gebote an seine Kinder, tat er seine Füße zusammen aufs Bett und verschied und ward versammelt zu seinem Volk. ");
INSERT INTO deu1912_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Da fiel Joseph auf seines Vaters Angesicht und weinte über ihn und küßte ihn. ");
INSERT INTO deu1912_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Und Joseph befahl seinen Knechten, den Ärzten, das sie seinen Vater salbten. Und die Ärzte salbten Israel, ");
INSERT INTO deu1912_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","bis daß vierzig Tage um waren; denn so lange währen die Salbetage. Und die Ägypter beweinten ihn siebzig Tage. ");
INSERT INTO deu1912_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Da nun die Leidtage aus waren, redete Joseph mit Pharaos Gesinde und sprach: Habe ich Gnade vor euch gefunden, so redet mit Pharao und sprecht: ");
INSERT INTO deu1912_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mein Vater hat einen Eid von mir genommen und gesagt: Siehe, ich sterbe; begrabe mich in meinem Grabe, das ich mir im Lande Kanaan gegraben habe. So will ich nun hinaufziehen und meinen Vater begraben und wiederkommen. ");
INSERT INTO deu1912_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharao sprach: Zieh hinauf und begrabe deinen Vater, wie du ihm geschworen hast. ");
INSERT INTO deu1912_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Also zog Joseph hinauf, seinen Vater zu begraben. Und es zogen mit ihm alle Knechte Pharaos, die Ältesten seines Hauses und alle Ältesten des Landes Ägypten, ");
INSERT INTO deu1912_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","dazu das ganze Gesinde Josephs und seine Brüder und das Gesinde seines Vaters. Allein ihre Kinder, Schafe und Ochsen ließen sie im Lande Gosen. ");
INSERT INTO deu1912_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Und es zogen mit ihm hinauf Wagen und Reisige, und war ein sehr großes Heer. ");
INSERT INTO deu1912_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Da sie nun an die Tenne Atad kamen, die jenseit des Jordans liegt, da hielten sie eine gar große und bittere Klage; und er trug über seinen Vater Leid sieben Tage. ");
INSERT INTO deu1912_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Und da die Leute im Lande, die Kanaaniter, die Klage bei der Tenne Atad sahen, sprachen sie: Die Ägypter halten da große Klage. Daher heißt man den Ort: Der Ägypter Klage, welcher liegt jenseit des Jordans. ");
INSERT INTO deu1912_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Und seine Kinder taten, wie er ihnen befohlen hatte, ");
INSERT INTO deu1912_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","und führten ihn ins Land Kanaan und begruben ihn in der zwiefachen Höhle des Ackers, die Abraham erkauft hatte mit dem Acker zum Erbbegräbnis von Ephron, dem Hethiter, gegenüber Mamre. ");
INSERT INTO deu1912_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Als sie ihn nun begraben hatten, zog Joseph wieder nach Ägypten mit seinen Brüdern und mit allen, die mit ihm hinaufgezogen waren, seinen Vater zu begraben. ");
INSERT INTO deu1912_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Die Brüder aber Josephs fürchteten sich, da ihr Vater gestorben war, und sprachen: Joseph möchte uns Gram sein und vergelten alle Bosheit, die wir an ihm getan haben. ");
INSERT INTO deu1912_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Darum ließen sie ihm sagen: Dein Vater befahl vor seinem Tod und sprach: ");
INSERT INTO deu1912_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Also sollt ihr Joseph sagen: Vergib doch deinen Brüdern die Missetat und ihre Sünde, daß sie so übel an dir getan haben. So vergib doch nun diese Missetat uns, den Dienern des Gottes deines Vaters. Aber Joseph weinte, da sie solches mit ihm redeten. ");
INSERT INTO deu1912_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Und seine Brüder gingen hin und fielen vor ihm nieder und sprachen: Siehe, wir sind deine Knechte. ");
INSERT INTO deu1912_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph sprach zu ihnen: Fürchtet euch nicht, denn ich bin unter Gott. ");
INSERT INTO deu1912_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ihr gedachtet's böse mit mir zu machen; aber Gott gedachte es gut zu machen, daß er täte, wie es jetzt am Tage ist, zu erhalten viel Volks. ");
INSERT INTO deu1912_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So fürchtet euch nun nicht; ich will euch versorgen und eure Kinder. Und er tröstete sie und redete freundlich mit ihnen. ");
INSERT INTO deu1912_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Also wohnte Joseph in Ägypten mit seines Vaters Hause und lebte hundertundzehn Jahre ");
INSERT INTO deu1912_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","und sah Ephraims Kinder bis ins dritte Glied. Auch wurden dem Machir, Manasses Sohn, Kinder geboren auf den Schoß Josephs. ");
INSERT INTO deu1912_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Und Joseph sprach zu seinen Brüdern: Ich sterbe, und Gott wird euch heimsuchen und aus diesem Lande führen in das Land, das er Abraham, Isaak und Jakob geschworen hat. ");
INSERT INTO deu1912_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Darum nahm er einen Eid von den Kindern Israel und sprach: Wenn euch Gott heimsuchen wird, so führet meine Gebeine von dannen. ");
INSERT INTO deu1912_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Also starb Joseph, da er war hundertundzehn Jahre alt. Und sie salbten ihn und legten ihn in eine Lade in Ägypten. ");
INSERT INTO deu1912_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Dies sind die Namen der Kinder Israel, die mit Jakob nach Ägypten kamen; ein jeglicher kam mit seinem Hause hinein: ");
INSERT INTO deu1912_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi, Juda, ");
INSERT INTO deu1912_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaschar, Sebulon, Benjamin, ");
INSERT INTO deu1912_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphthali, Gad, Asser. ");
INSERT INTO deu1912_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Und aller Seelen, die aus den Lenden Jakobs gekommen waren, deren waren siebzig. Joseph aber war zuvor in Ägypten. ");
INSERT INTO deu1912_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Da nun Joseph gestorben war und alle seine Brüder und alle, die zu der Zeit gelebt hatten, ");
INSERT INTO deu1912_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","wuchsen die Kinder Israel und zeugten Kinder und mehrten sich und wurden sehr viel, daß ihrer das Land voll ward. ");
INSERT INTO deu1912_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Da kam ein neuer König auf in Ägypten, der wußte nichts von Joseph ");
INSERT INTO deu1912_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","und sprach zu seinem Volk: Siehe, des Volks der Kinder Israel ist viel und mehr als wir. ");
INSERT INTO deu1912_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Wohlan, wir wollen sie mit List dämpfen, daß ihrer nicht so viel werden. Denn wo sich ein Krieg erhöbe, möchten sie sich auch zu unsern Feinden schlagen und wider uns streiten und zum Lande ausziehen. ");
INSERT INTO deu1912_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Und man setzte Fronvögte über sie, die sie mit schweren Diensten drücken sollten; denn man baute dem Pharao die Städte Pithon und Raemses zu Vorratshäusern. ");
INSERT INTO deu1912_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Aber je mehr sie das Volk drückten, je mehr es sich mehrte und ausbreitete. Und sie hielten die Kinder Israel wie einen Greuel. ");
INSERT INTO deu1912_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Und die Ägypter zwangen die Kinder Israel zum Dienst mit Unbarmherzigkeit ");
INSERT INTO deu1912_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","und machten ihnen ihr Leben sauer mit schwerer Arbeit in Ton und Ziegeln und mit allerlei Frönen auf dem Felde und mit allerlei Arbeit, die sie ihnen auflegten mit Unbarmherzigkeit. ");
INSERT INTO deu1912_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Und der König in Ägypten sprach zu den hebräischen Wehmüttern, deren eine hieß Siphra und die andere Pua: ");
INSERT INTO deu1912_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Wenn ihr den hebräischen Weibern helft, und auf dem Stuhl seht, daß es ein Sohn ist, so tötet ihn; ist's aber eine Tochter, so laßt sie leben. ");
INSERT INTO deu1912_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Aber die Wehmütter fürchteten Gott und taten nicht, wie der König von Ägypten ihnen gesagt hatte, sondern ließen die Kinder leben. ");
INSERT INTO deu1912_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Da rief der König in Ägypten die Wehmütter und sprach zu ihnen: Warum tut ihr das, daß ihr die Kinder leben lasset? ");
INSERT INTO deu1912_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Die Wehmütter antworteten Pharao: Die hebräischen Weiber sind nicht wie die ägyptischen, denn sie sind harte Weiber; ehe die Wehmutter zu ihnen kommt, haben sie geboren. ");
INSERT INTO deu1912_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Darum tat Gott den Wehmüttern Gutes. Und das Volk mehrte sich und ward sehr viel. ");
INSERT INTO deu1912_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Und weil die Wehmütter Gott fürchteten, baute er ihnen Häuser. ");
INSERT INTO deu1912_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Da gebot Pharao allem seinem Volk und sprach: Alle Söhne, die geboren werden, werft ins Wasser, und alle Töchter laßt leben. ");
INSERT INTO deu1912_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Und es ging ein Mann vom Hause Levi und nahm eine Tochter Levi. ");
INSERT INTO deu1912_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Und das Weib ward schwanger und gebar einen Sohn. Und da sie sah, daß es ein feines Kind war, verbarg sie ihn drei Monate. ");
INSERT INTO deu1912_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Und da sie ihn nicht länger verbergen konnte, machte sie ein Kästlein von Rohr und verklebte es mit Erdharz und Pech und legte das Kind darein und legte ihn in das Schilf am Ufer des Wassers. ");
INSERT INTO deu1912_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Aber seine Schwester stand von ferne, daß sie erfahren wollte, wie es ihm gehen würde. ");
INSERT INTO deu1912_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Und die Tochter Pharaos ging hernieder und wollte baden im Wasser; und ihre Jungfrauen gingen an dem Rande des Wassers. Und da sie das Kästlein im Schilf sah, sandte sie ihre Magd hin und ließ es holen. ");
INSERT INTO deu1912_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Und da sie es auftat, sah sie das Kind; und siehe, das Knäblein weinte. Da jammerte es sie, und sprach: Es ist der hebräischen Kindlein eins. ");
INSERT INTO deu1912_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Da sprach seine Schwester zu der Tochter Pharaos: Soll ich hingehen und der hebräischen Weiber eine rufen, die da säugt, daß sie dir das Kindlein säuge? ");
INSERT INTO deu1912_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Die Tochter Pharaos sprach zu ihr: Gehe hin. Die Jungfrau ging hin und rief des Kindes Mutter. ");
INSERT INTO deu1912_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Da sprach Pharaos Tochter zu ihr: Nimm hin das Kindlein und säuge mir's; ich will dir lohnen. Das Weib nahm das Kind und säugte es. ");
INSERT INTO deu1912_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Und da das Kind groß war, brachte sie es der Tochter Pharaos, und es ward ihr Sohn, und sie hieß ihn Mose; denn sie sprach: Ich habe ihn aus dem Wasser gezogen. ");
INSERT INTO deu1912_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Zu den Zeiten, da Mose war groß geworden, ging er aus zu seinen Brüdern und sah ihre Last und ward gewahr, daß ein Ägypter schlug seiner Brüder, der Hebräischen, einen. ");
INSERT INTO deu1912_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Und er wandte sich hin und her, und da er sah, daß kein Mensch da war, erschlug er den Ägypter und scharrte ihn in den Sand. ");
INSERT INTO deu1912_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Auf einen andern Tag ging er auch aus und sah zwei hebräische Männer sich miteinander zanken und sprach zu dem Ungerechten: Warum schlägst du deinen Nächsten? ");
INSERT INTO deu1912_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Er aber sprach: Wer hat dich zum Obersten oder Richter über uns gesetzt? Willst du mich auch erwürgen, wie du den Ägypter erwürgt hast? Da fürchtete sich Mose und sprach: Wie ist das laut geworden? ");
INSERT INTO deu1912_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Und es kam vor Pharao; der trachtete nach Mose, daß er ihn erwürgte. Aber Mose floh vor Pharao und blieb im Lande Midian und wohnte bei einem Brunnen. ");
INSERT INTO deu1912_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Der Priester aber von Midian hatte sieben Töchter; die kamen, Wasser zu schöpfen, und füllten die Rinnen, daß sie ihres Vaters Schafe tränkten. ");
INSERT INTO deu1912_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Da kamen die Hirten und stießen sie davon. Aber Mose machte sich auf und half ihnen und tränkte ihre Schafe. ");
INSERT INTO deu1912_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Und da sie zu ihrem Vater Reguel kamen, sprach er: Wie seid ihr heute so bald gekommen? ");
INSERT INTO deu1912_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Sie sprachen: Ein ägyptischer Mann errettete uns von den Hirten und schöpfte uns und tränkte die Schafe. ");
INSERT INTO deu1912_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Er sprach zu seinen Töchtern: Wo ist er? Warum habt ihr den Mann gelassen, daß ihr ihn nicht ludet, mit uns zu essen? ");
INSERT INTO deu1912_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Und Mose willigte darein, bei dem Manne zu bleiben. Und er gab Mose seine Tochter Zippora. ");
INSERT INTO deu1912_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Die gebar einen Sohn; und er hieß ihn Gersom; denn er sprach: Ich bin ein Fremdling geworden im fremden Lande. ");
INSERT INTO deu1912_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Lange Zeit aber darnach starb der König in Ägypten. Und die Kinder Israel seufzten über ihre Arbeit und schrieen, und ihr Schreien über ihre Arbeit kam vor Gott. ");
INSERT INTO deu1912_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Und Gott erhörte ihr Wehklagen und gedachte an seinen Bund mit Abraham, Isaak und Jakob; ");
INSERT INTO deu1912_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","und er sah darein und nahm sich ihrer an. ");
INSERT INTO deu1912_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose aber hütete die Schafe Jethros, seines Schwiegervaters, des Priesters in Midian, und trieb die Schafe hinter die Wüste und kam an den Berg Gottes, Horeb. ");
INSERT INTO deu1912_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Und der Engel des HERRN erschien ihm in einer feurigen Flamme aus dem Busch. Und er sah, daß der Busch mit Feuer brannte und ward doch nicht verzehrt; ");
INSERT INTO deu1912_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","und sprach: ich will dahin und beschauen dies große Gesicht, warum der Busch nicht verbrennt. ");
INSERT INTO deu1912_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Da aber der HERR sah, daß er hinging, zu sehen, rief ihm Gott aus dem Busch und sprach: Mose, Mose! Er antwortete: Hier bin ich. ");
INSERT INTO deu1912_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Er sprach: Tritt nicht herzu, zieh deine Schuhe aus von deinen Füßen; denn der Ort, darauf du stehst, ist ein heilig Land! ");
INSERT INTO deu1912_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Und sprach weiter: Ich bin der Gott deines Vaters, der Gott Abrahams, der Gott Isaaks und der Gott Jakobs. Und Mose verhüllte sein Angesicht; denn er fürchtete sich Gott anzuschauen. ");
INSERT INTO deu1912_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Und der HERR sprach: Ich habe gesehen das Elend meines Volkes in Ägypten und habe ihr Geschrei gehört über die, so sie drängen; ich habe ihr Leid erkannt ");
INSERT INTO deu1912_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","und bin herniedergefahren, daß ich sie errette von der Ägypter Hand und sie ausführe aus diesem Lande in ein gutes und weites Land, in ein Land, darin Milch und Honig fließt, an den Ort der Kanaaniter, Hethiter, Amoriter, Pheresiter, Heviter und Jebusiter. ");
INSERT INTO deu1912_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Weil nun das Geschrei der Kinder Israel vor mich gekommen ist, und ich auch dazu ihre Angst gesehen habe, wie die Ägypter sie ängsten, ");
INSERT INTO deu1912_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","so gehe nun hin, ich will dich zu Pharao senden, daß du mein Volk, die Kinder Israel, aus Ägypten führest. ");
INSERT INTO deu1912_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mose sprach zu Gott: Wer bin ich, daß ich zu Pharao gehe und führe die Kinder Israel aus Ägypten? ");
INSERT INTO deu1912_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Er sprach: Ich will mit dir sein. Und das soll dir ein Zeichen sein, daß ich dich gesandt habe: Wenn du mein Volk aus Ägypten geführt hast, werdet ihr Gott opfern auf diesem Berge. ");
INSERT INTO deu1912_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mose sprach zu Gott: Siehe, wenn ich zu den Kindern Israel komme und spreche zu ihnen: Der Gott eurer Väter hat mich zu euch gesandt, und sie mir sagen werden: Wie heißt sein Name? was soll ich ihnen sagen? ");
INSERT INTO deu1912_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Gott sprach zu Mose: ICH WERDE SEIN, DER ICH SEIN WERDE. Und sprach: Also sollst du den Kindern Israel sagen: ICH WERDE SEIN hat mich zu euch gesandt. ");
INSERT INTO deu1912_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Und Gott sprach weiter zu Mose: Also sollst du den Kindern Israel sagen: Der HERR, eurer Väter Gott, der Gott Abrahams, der Gott Isaaks, der Gott Jakobs, hat mich zu euch gesandt. Das ist mein Name ewiglich, dabei soll man mein Gedenken für und für. ");
INSERT INTO deu1912_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Darum so gehe hin und versammle die Ältesten in Israel und sprich zu ihnen: Der HERR, euer Väter Gott, ist mir erschienen, der Gott Abrahams, der Gott Isaaks, der Gott Jakobs, und hat gesagt: Ich habe euch heimgesucht, und gesehen, was euch in Ägypten widerfahren ist, ");
INSERT INTO deu1912_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","und habe gesagt: ich will euch aus dem Elend Ägyptens führen in das Land der Kanaaniter, Hethiter, Amoriter, Pheresiter, Heviter und Jebusiter, in das Land, darin Milch und Honig fließt. ");
INSERT INTO deu1912_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Und wenn sie deine Stimme hören, so sollst du und die Ältesten in Israel hineingehen zum König in Ägypten und zu ihm sagen: Der HERR, der Hebräer Gott, hat uns gerufen. So laß uns nun gehen drei Tagereisen in die Wüste, daß wir opfern unserm Gott. ");
INSERT INTO deu1912_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Aber ich weiß, daß euch der König in Ägypten nicht wird ziehen lassen, außer durch eine starke Hand. ");
INSERT INTO deu1912_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Denn ich werde meine Hand ausstrecken und Ägypten schlagen mit allerlei Wundern, die ich darin tun werde. Darnach wird er euch ziehen lassen. ");
INSERT INTO deu1912_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Und ich will diesem Volk Gnade geben vor den Ägyptern, daß, wenn ihr auszieht, ihr nicht leer auszieht; ");
INSERT INTO deu1912_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","sondern ein jeglich Weib soll von ihrer Nachbarin und Hausgenossin fordern silberne und goldene Gefäße und Kleider; die sollt ihr auf eure Söhne und Töchter legen und von den Ägyptern zur Beute nehmen. ");
INSERT INTO deu1912_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mose antwortete und sprach: Siehe, sie werden mir nicht glauben noch meine Stimme hören, sondern werden sagen: Der HERR ist dir nicht erschienen. ");
INSERT INTO deu1912_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Der HERR sprach zu ihm: Was ist's, was du in deiner Hand hast? Er sprach: Ein Stab. ");
INSERT INTO deu1912_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Er sprach: Wirf ihn vor dir auf die Erde. Und er warf ihn von sich; da ward er zur Schlange, und Mose floh vor ihr. ");
INSERT INTO deu1912_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Aber der HERR sprach zu ihm: Strecke deine Hand aus und erhasche sie bei dem Schwanz. Da streckte er seine Hand aus und hielt sie, und sie ward zum Stab in seiner Hand. ");
INSERT INTO deu1912_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Darum werden sie glauben, daß dir erschienen sei der HERR, der Gott ihrer Väter, der Gott Abrahams, der Gott Isaaks, der Gott Jakobs. ");
INSERT INTO deu1912_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Und der HERR sprach weiter zu ihm: Stecke deine Hand in deinen Busen. Und er steckte seine Hand in seinen Busen und zog sie wieder heraus; siehe, da war aussätzig wie Schnee. ");
INSERT INTO deu1912_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Und er sprach: Tue sie wieder in deinen Busen. Und er tat sie wieder in seinen Busen und zog sie heraus; siehe, da ward sie wieder wie sein anderes Fleisch. ");
INSERT INTO deu1912_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Wenn sie dir nun nicht werden glauben noch deine Stimme hören bei dem einen Zeichen, so werden sie doch glauben deine Stimme bei dem andern Zeichen. ");
INSERT INTO deu1912_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Wenn sie aber diesen zwei Zeichen nicht glauben werden noch deine Stimme hören, so nimm Wasser aus dem Strom und gieß es auf das trockene Land, so wird das Wasser, das du aus dem Strom genommen hast, Blut werden auf dem trockenen Lande. ");
INSERT INTO deu1912_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mose aber sprach zu dem HERRN: Ach mein Herr, ich bin je und je nicht wohl beredt gewesen, auch nicht seit der Zeit, da du mit deinem Knecht geredet hast; denn ich habe eine schwere Sprache und eine schwere Zunge. ");
INSERT INTO deu1912_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Der HERR sprach zu ihm: Wer hat dem Menschen den Mund geschaffen? Oder wer hat den Stummen oder Tauben oder Sehenden oder Blinden gemacht? Habe ich's nicht getan, der HERR? ");
INSERT INTO deu1912_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","So geh nun hin: Ich will mit deinem Munde sein und dich lehren, was du sagen sollst. ");
INSERT INTO deu1912_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mose sprach aber: Mein Herr, sende, welchen du senden willst. ");
INSERT INTO deu1912_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Da ward der HERR sehr zornig über Mose und sprach: Weiß ich denn nicht, daß dein Bruder Aaron aus dem Stamm Levi beredt ist? und siehe, er wird herausgehen dir entgegen; und wenn er dich sieht, wir er sich von Herzen freuen. ");
INSERT INTO deu1912_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Du sollst zu ihm reden und die Worte in seinen Mund legen. Und ich will mit deinem und seinem Munde sein und euch lehren, was ihr tun sollt. ");
INSERT INTO deu1912_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Und er soll für dich zum Volk reden; er soll dein Mund sein, und du sollst sein Gott sein. ");
INSERT INTO deu1912_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Und diesen Stab nimm in deine Hand, mit dem du die Zeichen tun sollst. ");
INSERT INTO deu1912_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose ging hin und kam wieder zu Jethro, seinem Schwiegervater, und sprach zu ihm: Laß mich doch gehen, daß ich wieder zu meinen Brüdern komme, die in Ägypten sind, und sehe, ob sie noch leben. Jethro sprach zu ihm: Gehe hin mit Frieden. ");
INSERT INTO deu1912_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Auch sprach der HERR zu ihm in Midian: Gehe hin und ziehe wieder nach Ägypten; denn die Leute sind tot, die nach deinem Leben standen. ");
INSERT INTO deu1912_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Also nahm Mose sein Weib und seine Söhne und führte sie auf einem Esel und zog wieder nach Ägyptenland und nahm den Stab Gottes in seine Hand. ");
INSERT INTO deu1912_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Und der HERR sprach zu Mose: Siehe zu, wenn du wieder nach Ägypten kommst, daß du alle Wunder tust vor Pharao, die ich dir in deine Hand gegeben habe; aber ich will sein Herz verstocken, daß er das Volk nicht lassen wird. ");
INSERT INTO deu1912_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Und du sollst zu ihm sagen: So sagt der HERR: Israel ist mein erstgeborener Sohn; ");
INSERT INTO deu1912_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","und ich gebiete dir, daß du meinen Sohn ziehen lassest, daß er mir diene. Wirst du dich des weigern, so will ich deinen erstgeborenen Sohn erwürgen. ");
INSERT INTO deu1912_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Und als er unterwegs in der Herberge war, kam ihm der HERR entgegen und wollte ihn töten. ");
INSERT INTO deu1912_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Da nahm Zippora einen Stein und beschnitt ihrem Sohn die Vorhaut und rührte ihm seine Füße an und sprach: Du bist mir ein Blutbräutigam. ");
INSERT INTO deu1912_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Da ließ er von ihm ab. Sie sprach aber Blutbräutigam um der Beschneidung willen. ");
INSERT INTO deu1912_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Und der HERR sprach zu Aaron: Gehe hin Mose entgegen in die Wüste. Und er ging hin und begegnete ihm am Berge Gottes und küßte ihn. ");
INSERT INTO deu1912_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Und Mose sagte Aaron alle Worte des HERRN, der ihn gesandt hatte, und alle Zeichen, die er ihm befohlen hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Und sie gingen hin und versammelten alle Ältesten von den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Und Aaron redete alle Worte, die der HERR mit Mose geredet hatte, und er tat die Zeichen vor dem Volk. ");
INSERT INTO deu1912_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Und das Volk glaubte. Und da sie hörten, daß der HERR die Kinder Israel heimgesucht und ihr Elend angesehen hätte, neigten sie sich und beteten an. ");
INSERT INTO deu1912_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Darnach ging Mose und Aaron hinein und sprachen zu Pharao: So sagt der HERR, der Gott Israels: Laß mein Volk ziehen, daß mir's ein Fest halte in der Wüste. ");
INSERT INTO deu1912_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharao antwortete: Wer ist der HERR, des Stimme ich hören müsse und Israel ziehen lassen? Ich weiß nichts von dem HERRN, will auch Israel nicht lassen ziehen. ");
INSERT INTO deu1912_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Sie sprachen: Der Hebräer Gott hat uns gerufen; so laß uns nun hinziehen drei Tagereisen in die Wüste und dem HERRN, unserm Gott, opfern, daß uns nicht widerfahre Pestilenz oder Schwert. ");
INSERT INTO deu1912_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Da sprach der König in Ägypten zu ihnen: Du Mose und Aaron, warum wollt ihr das Volk von seiner Arbeit frei machen? Gehet hin an eure Dienste! ");
INSERT INTO deu1912_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Weiter sprach Pharao: Siehe, des Volks ist schon zuviel im Lande, und ihr wollt sie noch feiern heißen von ihrem Dienst! ");
INSERT INTO deu1912_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Darum befahl Pharao desselben Tages den Vögten des Volks und ihren Amtleuten und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ihr sollt dem Volk nicht mehr Stroh sammeln und geben, daß sie Ziegel machen wie bisher; laßt sie selbst hingehen, und Stroh zusammenlesen, ");
INSERT INTO deu1912_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","und die Zahl der Ziegel, die sie bisher gemacht haben, sollt ihr ihnen gleichwohl auflegen und nichts mindern; denn sie gehen müßig, darum schreien sie und sprechen: Wir wollen hinziehen und unserm Gott opfern. ");
INSERT INTO deu1912_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Man drücke die Leute mit Arbeit, daß sie zu schaffen haben und sich nicht kehren an falsche Rede. ");
INSERT INTO deu1912_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Da gingen die Vögte des Volkes und ihre Amtleute aus und sprachen zum Volk: So spricht Pharao: Man wird euch kein Stroh geben; ");
INSERT INTO deu1912_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","geht ihr selbst hin und sammelt euch Stroh, wo ihr's findet; aber von eurer Arbeit soll nichts gemindert werden. ");
INSERT INTO deu1912_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Da zerstreute sich das Volk ins ganze Land Ägypten, daß es Stoppeln sammelte, damit sie Stroh hätten. ");
INSERT INTO deu1912_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Und die Vögte trieben sie und sprachen: Erfüllet euer Tagewerk, gleich als da ihr Stroh hattet. ");
INSERT INTO deu1912_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Und die Amtleute der Kinder Israel, welche die Vögte Pharaos über sie gesetzt hatten, wurden geschlagen, und ward zu ihnen gesagt: Warum habt ihr weder heute noch gestern euer gesetztes Tagewerk getan wie bisher? ");
INSERT INTO deu1912_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Da gingen hinein die Amtleute der Kinder Israel und schrien zu Pharao: Warum willst du mit deinen Knechten also fahren? ");
INSERT INTO deu1912_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Man gibt den Knechten kein Stroh, und sie sollen die Ziegel machen, die uns bestimmt sind; siehe deine Knechte werden geschlagen, und dein Volk muß schuldig sein. ");
INSERT INTO deu1912_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pharao sprach: Ihr seid müßig, müßig seid ihr; darum sprecht ihr: Wir wollen hinziehen und dem HERRN opfern. ");
INSERT INTO deu1912_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","So gehet nun hin und frönt; Stroh soll man euch nicht geben, aber die Anzahl der Ziegel sollt ihr schaffen. ");
INSERT INTO deu1912_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Da sahen die Amtleute der Kinder Israel, daß es ärger ward, weil man sagte: Ihr sollt nichts mindern von dem Tagewerk an den Ziegeln. ");
INSERT INTO deu1912_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Und da sie von Pharao gingen, begegneten sie Mose und Aaron und traten ihnen entgegen ");
INSERT INTO deu1912_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","und sprachen zu ihnen: Der HERR sehe auf euch und richte es, daß ihr unsern Geruch habt stinkend gemacht vor Pharao und seinen Knechten und habt ihnen das Schwert in die Hände gegeben, uns zu töten. ");
INSERT INTO deu1912_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mose aber kam wieder zu dem HERRN und sprach: Herr, warum tust du so übel an diesem Volk? Warum hast du mich hergesandt? ");
INSERT INTO deu1912_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Denn seit dem, daß ich hineingegangen bin zu Pharao, mit ihm zu reden in deinem Namen, hat er das Volk noch härter geplagt, und du hast dein Volk nicht errettet. ");
INSERT INTO deu1912_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Der HERR sprach zu Mose: Nun sollst du sehen, was ich Pharao tun werde; denn durch eine starke Hand muß er sie lassen ziehen, er muß sie noch durch eine starke Hand aus seinem Lande von sich treiben. ");
INSERT INTO deu1912_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Und Gott redete mit Mose und sprach zu ihm: Ich bin der HERR ");
INSERT INTO deu1912_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","und bin erschienen Abraham, Isaak und Jakob als der allmächtige Gott; aber mein Name HERR ist ihnen nicht offenbart worden. ");
INSERT INTO deu1912_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Auch habe ich einen Bund mit ihnen aufgerichtet, daß ich ihnen geben will das Land Kanaan, das Land ihrer Wallfahrt, darin sie Fremdlinge gewesen sind. ");
INSERT INTO deu1912_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Auch habe ich gehört die Wehklage der Kinder Israel, welche die Ägypter mit Frönen beschweren, und habe an meinen Bund gedacht. ");
INSERT INTO deu1912_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Darum sage den Kindern Israel: Ich bin der HERR und will euch ausführen von euren Lasten in Ägypten und will euch erretten von eurem Frönen und will euch erlösen durch ausgereckten Arm und große Gerichte ");
INSERT INTO deu1912_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","und will euch annehmen zum Volk und will euer Gott sein, daß ihr's erfahren sollt, daß ich der HERR bin, euer Gott, der euch ausführt von der Last Ägyptens ");
INSERT INTO deu1912_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","und euch bringt in das Land, darüber ich habe meine Hand gehoben, daß ich's gäbe Abraham, Isaak und Jakob; das will ich euch geben zu eigen, ich, der HERR. ");
INSERT INTO deu1912_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose sagte solches den Kindern Israel; aber sie hörten ihn nicht vor Seufzen und Angst vor harter Arbeit. ");
INSERT INTO deu1912_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Da redete der HERR mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Gehe hinein und rede mit Pharao, dem König in Ägypten, daß er die Kinder Israel aus seinem Lande lasse. ");
INSERT INTO deu1912_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mose aber redete vor dem HERRN und sprach: Siehe, die Kinder Israel hören mich nicht; wie sollte mich denn Pharao hören? Dazu bin ich von unbeschnittenen Lippen. ");
INSERT INTO deu1912_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Also redete der HERR mit Mose und Aaron und tat ihnen Befehl an die Kinder Israel und an Pharao, den König in Ägypten, daß sie die Kinder Israel aus Ägypten führten. ");
INSERT INTO deu1912_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Dies sind die Häupter in ihren Vaterhäusern. Die Kinder Rubens, des ersten Sohnes Israels, sind diese: Henoch, Pallu, Hezron, Charmi. Das sind die Geschlechter von Ruben. ");
INSERT INTO deu1912_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Die Kinder Simeons sind diese: Jemuel, Jamin, Ohad, Jachin, Zohar und Saul, der Sohn des kanaanäischen Weibes. Das sind Simeons Geschlechter. ");
INSERT INTO deu1912_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Dies sind die Namen der Kinder Levis nach ihren Geschlechtern: Gerson, Kahath, Merari. Aber Levi ward hundertsiebenunddreißig Jahre alt. ");
INSERT INTO deu1912_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Die Kinder Gersons sind diese: Libni und Simei nach ihren Geschlechtern. ");
INSERT INTO deu1912_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Die Kinder Kahaths sind diese: Amram, Jizhar, Hebron, Usiel. Kahath aber ward hundertdreiunddreißig Jahre alt. ");
INSERT INTO deu1912_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Die Kinder Merari sind diese: Maheli und Musi. Das sind die Geschlechter Levis nach ihrer Abstammung. ");
INSERT INTO deu1912_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Und Amram nahm seine Muhme Jochebed zum Weibe; die gebar ihm Aaron und Mose. Aber Amram ward hundertsiebenunddreißig Jahre alt. ");
INSERT INTO deu1912_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Die Kinder Jizhars sind diese: Korah, Nepheg, Sichri. ");
INSERT INTO deu1912_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Die Kinder Usiels sind diese: Misael, Elzaphan, Sithri. ");
INSERT INTO deu1912_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron nahm zum Weibe Eliseba, die Tochter Amminadabs, Nahessons Schwester; die gebar ihm Nadab, Abihu, Eleasar, Ithamar. ");
INSERT INTO deu1912_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Die Kinder Korah sind diese: Assir, Elkana, Abiasaph. Das sind die Geschlechter der Korahiter. ");
INSERT INTO deu1912_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasar aber, Aarons Sohn, der nahm von den Töchtern Putiels ein Weib; die gebar ihm Pinehas. Das sind die Häupter unter den Vätern der Leviten-Geschlechter. ");
INSERT INTO deu1912_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Das ist Aaron und Mose, zu denen der HERR sprach: Führet die Kinder Israel aus Ägyptenland mit ihrem Heer. ");
INSERT INTO deu1912_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Sie sind's die mit Pharao, dem König in Ägypten, redeten, daß sie die Kinder Israel aus Ägypten führten, nämlich Mose und Aaron. ");
INSERT INTO deu1912_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Und des Tages redete der HERR mit Mose in Ägyptenland ");
INSERT INTO deu1912_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","und sprach zu Ihm: Ich bin der HERR; rede mit Pharao, dem König in Ägypten, alles, was ich mit dir rede. ");
INSERT INTO deu1912_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Und er antwortete vor dem HERRN: Siehe, ich bin von unbeschnittenen Lippen; wie wird mich denn Pharao hören? ");
INSERT INTO deu1912_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Der HERR sprach zu Mose: Siehe, ich habe dich zu einem Gott gesetzt über Pharao, und Aaron, dein Bruder, soll dein Prophet sein. ");
INSERT INTO deu1912_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Du sollst reden alles, was ich dir gebieten werde; aber Aaron, dein Bruder, soll's vor Pharao reden, daß er die Kinder Israel aus seinem Lande lasse. ");
INSERT INTO deu1912_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Aber ich will Pharaos Herz verhärten, daß ich meiner Zeichen und Wunder viel tue in Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Und Pharao wird euch nicht hören, auf daß ich meine Hand in Ägypten beweise und führe mein Heer, mein Volk, die Kinder Israel, aus Ägyptenland durch große Gerichte. ");
INSERT INTO deu1912_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Und die Ägypter sollen's innewerden, daß ich der HERR bin, wenn ich nun meine Hand über Ägypten ausstrecken und die Kinder Israel von ihnen wegführen werde. ");
INSERT INTO deu1912_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mose und Aaron taten, wie ihnen Gott geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Und Mose war achtzig Jahre alt und Aaron dreiundachtzig Jahre alt, da sie mit Pharao redeten ");
INSERT INTO deu1912_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Und der HERR sprach zu Mose und Aaron: ");
INSERT INTO deu1912_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Wenn Pharao zu euch sagen wird: Beweist eure Wunder, so sollst du zu Aaron sagen: Nimm deinen Stab und wirf ihn vor Pharao, daß er zur Schlange werde. ");
INSERT INTO deu1912_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Da gingen Mose und Aaron hinein zu Pharao und taten, wie ihnen der HERR geboten hatte. Und Aaron warf seinen Stab vor Pharao und vor seinen Knechten, und er ward zur Schlange. ");
INSERT INTO deu1912_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Da forderte Pharao die Weisen und Zauberer; und die ägyptischen Zauberer taten auch also mit ihrem Beschwören: ");
INSERT INTO deu1912_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ein jeglicher warf seinen Stab von sich, da wurden Schlangen daraus; aber Aarons Stab verschlang ihre Stäbe. ");
INSERT INTO deu1912_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Also ward das Herz Pharaos verstockt, und er hörte sie nicht, wie denn der HERR geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Und der HERR sprach zu Mose: Das Herz Pharaos ist hart; er weigert sich das Volk zu lassen. ");
INSERT INTO deu1912_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Gehe hin zu Pharao morgen. Siehe, er wird ins Wasser gehen; so tritt ihm entgegen an das Ufer des Wassers und nimm den Stab in deine Hand, der zur Schlange ward, ");
INSERT INTO deu1912_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","und sprich zu ihm: Der HERR, der Hebräer Gott, hat mich zu dir gesandt und lassen sagen: Laß mein Volk, daß mir's diene in der Wüste. Aber du hast bisher nicht wollen hören. ");
INSERT INTO deu1912_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Darum spricht der HERR also: Daran sollst du erfahren, daß ich der HERR bin. Siehe, ich will mit dem Stabe, den ich in meiner Hand habe, das Wasser schlagen, das in dem Strom ist, und es soll in Blut verwandelt werden, ");
INSERT INTO deu1912_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","daß die Fische im Strom sterben sollen und der Strom stinken; und den Ägyptern wird ekeln, zu trinken das Wasser aus dem Strom. ");
INSERT INTO deu1912_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Und der HERR sprach zu Mose: Sage Aaron: Nimm deinen Stab und recke deine Hand aus über die Wasser in Ägypten, über ihre Bäche und Ströme und Seen und über alle Wassersümpfe, daß sie Blut werden; und es sei Blut in ganz Ägyptenland, in hölzernen und in steinernen Gefäßen. ");
INSERT INTO deu1912_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose und Aaron taten, wie ihnen der HERR geboten hatte, und er hob den Stab auf und schlug ins Wasser, das im Strom war, vor Pharao und seinen Knechten. Und alles Wasser ward in Blut verwandelt. ");
INSERT INTO deu1912_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Und die Fische im Strom starben, und der Strom ward stinkend, daß die Ägypter nicht trinken konnten das Wasser aus dem Strom; und es war Blut in ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Und die ägyptischen Zauberer taten auch also mit ihrem Beschwören. Also ward das Herz Pharaos verstockt, und er hörte sie nicht, wie denn der HERR geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Und Pharao wandte sich und ging heim und nahm's nicht zu Herzen. ");
INSERT INTO deu1912_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Aber alle Ägypter gruben nach Wasser um den Strom her, zu trinken; denn das Wasser aus dem Strom konnten sie nicht trinken. ");
INSERT INTO deu1912_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Und das währte sieben Tage lang, daß der HERR den Strom schlug. ");
INSERT INTO deu1912_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","7:26 Der HERR sprach zu Mose: Gehe hinein zu Pharao und sprich zu ihm: So sagt der HERR: Laß mein Volk, daß mir's diene. ");
INSERT INTO deu1912_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","7:27 Wo du dich weigerst, siehe, so will ich all dein Gebiet mit Fröschen plagen, ");
INSERT INTO deu1912_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","7:28 daß der Strom soll von Fröschen wimmeln; die sollen heraufkriechen und kommen in dein Haus, in deine Schlafkammer, auch in die Häuser deiner Knechte, unter dein Volk, in deine Backöfen und in deine Teige; ");
INSERT INTO deu1912_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","7:29 und die Frösche sollen auf dich und auf dein Volk und auf alle deine Knechte kriechen. ");
INSERT INTO deu1912_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","8:1 Und der HERR sprach zu Mose: Sage Aaron: Recke deine Hand aus mit deinem Stabe über die Bäche und Ströme und Seen und laß Frösche über Ägyptenland kommen. ");
INSERT INTO deu1912_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","8:2 Und Aaron reckte seine Hand über die Wasser in Ägypten, und es kamen Frösche herauf, daß Ägyptenland bedeckt ward. ");
INSERT INTO deu1912_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","8:3 Da taten die Zauberer auch also mit ihrem Beschwören und ließen Frösche über Ägyptenland kommen. ");
INSERT INTO deu1912_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","8:4 Da forderte Pharao Mose und Aaron und sprach: Bittet den HERRN für mich, daß er die Frösche von mir und von meinem Volk nehme, so will ich das Volk lassen, daß es dem HERRN opfere. ");
INSERT INTO deu1912_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","8:5 Mose sprach: Habe du die Ehre vor mir und bestimme mir, wann ich für dich, für deine Knechte und für dein Volk bitten soll, daß die Frösche von dir und von deinem Haus vertrieben werden und allein im Strom bleiben. ");
INSERT INTO deu1912_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","8:6 Er sprach: Morgen. Er sprach: Wie du gesagt hast. Auf daß du erfahrest, daß niemand ist wie der HERR, unser Gott, ");
INSERT INTO deu1912_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","8:7 so sollen die Frösche von dir, von deinem Hause, von deinen Knechten und von deinem Volk genommen werden und allein in Strom bleiben. ");
INSERT INTO deu1912_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","8:8 Also gingen Mose und Aaron von Pharao; und Mose schrie zu dem HERRN der Frösche halben, wie er Pharao hatte zugesagt. ");
INSERT INTO deu1912_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","8:9 Und der HERR tat, wie Mose gesagt hatte; und die Frösche starben in den Häusern, in den Höfen und auf dem Felde. ");
INSERT INTO deu1912_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","8:10 Und sie häuften sie zusammen, hier einen Haufen und da einen Haufen, und das Land stank davon. ");
INSERT INTO deu1912_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","8:11 Da aber Pharao sah, daß er Luft gekriegt hatte, verhärtete er sein Herz und hörte sie nicht, wie denn der HERR geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","8:12 Und der HERR sprach zu Mose: Sage Aaron: Recke deinen Stab aus und schlage in den Staub auf der Erde, daß Stechmücken werden in ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","8:13 Sie taten also, und Aaron reckte seine Hand aus mit dem Stabe und schlug in den Staub auf der Erde. Und es wurden Mücken an den Menschen und an dem Vieh; aller Staub des Landes ward zu Mücken in ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","8:14 Die Zauberer taten auch also mit ihrem Beschwören, daß sie Mücken herausbrächten, aber sie konnten nicht. Und die Mücken waren sowohl an den Menschen als an Vieh. ");
INSERT INTO deu1912_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","8:15 Da sprachen die Zauberer zu Pharao: Das ist Gottes Finger. Aber das Herz Pharaos ward verstockt, und er hörte sie nicht, wie denn der HERR gesagt hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","8:16 Und der HERR sprach zu Mose: Mache dich morgen früh auf und tritt vor Pharao (siehe, er wird ans Wasser gehen) und sprich zu ihm: So sagt der HERR: Laß mein Volk, daß es mir diene; ");
INSERT INTO deu1912_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","8:17 wo nicht, siehe, so will ich allerlei Ungeziefer lassen kommen über dich, deine Knechte, dein Volk und dein Haus, daß aller Ägypter Häuser und das Feld und was darauf ist, voll Ungeziefer werden sollen. ");
INSERT INTO deu1912_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","8:18 Und ich will des Tages ein Besonderes tun mit dem Lande Gosen, da sich mein Volk aufhält, daß kein Ungeziefer da sei; auf daß du innewerdest, daß ich der HERR bin auf Erden allenthalben; ");
INSERT INTO deu1912_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","8:19 und will eine Erlösung setzen zwischen meinem und deinem Volk; morgen soll das Zeichen geschehen. ");
INSERT INTO deu1912_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","8:20 Und der HERR tat also, und es kam viel Ungeziefer in Pharaos Haus, in seiner Knechte Häuser und über ganz Ägyptenland; und das Land ward verderbt von dem Ungeziefer. ");
INSERT INTO deu1912_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","8:21 Da forderte Pharao Mose und Aaron und sprach: Gehet hin, opfert eurem Gott hier im Lande. ");
INSERT INTO deu1912_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","8:22 Mose sprach: Das taugt nicht, daß wir also tun; denn wir würden der Ägypter Greuel opfern unserm Gott, dem HERRN; siehe, wenn wir der Ägypter Greuel vor ihren Augen opferten, würden sie uns nicht steinigen? ");
INSERT INTO deu1912_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","8:23 Drei Tagereisen wollen wir gehen in die Wüste und dem HERRN, unserm Gott, opfern, wie er uns gesagt hat. ");
INSERT INTO deu1912_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","8:24 Pharao sprach: Ich will euch lassen, daß ihr dem HERRN, eurem Gott, opfert in der Wüste; allein, daß ihr nicht ferner zieht; und bittet für mich. ");
INSERT INTO deu1912_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","8:25 Mose sprach: Siehe, wenn ich hinaus von dir komme, so will ich den HERRN bitten, daß dies Ungeziefer von Pharao und seinen Knechten und seinem Volk genommen werde morgen des Tages; allein täusche mich nicht mehr, daß du das Volk nicht lassest, dem HERRN zu opfern. ");
INSERT INTO deu1912_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","8:26 Und Mose ging hinaus von Pharao und bat den HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","8:27 Und der HERR tat, wie Mose gesagt hatte, und schaffte das Ungeziefer weg von Pharao, von seinen Knechten und von seinem Volk, daß nicht eines übrigblieb. ");
INSERT INTO deu1912_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","8:27 Aber Pharao verhärtete sein Herz auch dieses Mal und ließ das Volk nicht. ");
INSERT INTO deu1912_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Der HERR sprach zu Mose: Gehe hinein zu Pharao und sprich zu ihm: Also sagt der HERR, der Gott der Hebräer: Laß mein Volk, daß sie mir dienen. ");
INSERT INTO deu1912_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Wo du dich des weigerst und sie weiter aufhältst, ");
INSERT INTO deu1912_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","siehe, so wird die Hand des HERRN sein über dein Vieh auf dem Felde, über Pferde, über Esel, über Kamele, über Ochsen, über Schafe, mit einer sehr schweren Pestilenz. ");
INSERT INTO deu1912_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Und der HERR wird ein Besonderes tun zwischen dem Vieh der Israeliten und der Ägypter, daß nichts sterbe aus allem, was die Kinder Israel haben. ");
INSERT INTO deu1912_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Und der HERR bestimmte eine Zeit und sprach: Morgen wird der HERR solches auf Erden tun. ");
INSERT INTO deu1912_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Und der HERR tat solches des Morgens, und es starb allerlei Vieh der Ägypter; aber des Viehs der Kinder Israel starb nicht eins. ");
INSERT INTO deu1912_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Und Pharao sandte darnach, und siehe, es war des Viehs Israels nicht eins gestorben. Aber das Herz Pharaos ward verstockt, und er ließ das Volk nicht. ");
INSERT INTO deu1912_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Da sprach der HERR zu Mose und Aaron: Nehmet eure Fäuste voll Ruß aus dem Ofen, und Mose sprenge ihn gen Himmel vor Pharao, ");
INSERT INTO deu1912_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","daß es über ganz Ägyptenland stäube und böse schwarze Blattern auffahren an den Menschen und am Vieh in ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Und sie nahmen Ruß aus dem Ofen und traten vor Pharao, und Mose sprengte ihn gen Himmel. Da fuhren auf böse schwarze Blattern an den Menschen und am Vieh, ");
INSERT INTO deu1912_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","also daß die Zauberer nicht konnten vor Mose stehen vor den bösen Blattern; denn es waren an den Zauberern ebensowohl böse Blattern als an allen Ägyptern. ");
INSERT INTO deu1912_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Aber der HERR verstockte das Herz Pharaos, daß er sie nicht hörte, wie denn der HERR gesagt hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Da sprach der HERR zu Mose: Mache dich morgen früh auf und tritt vor Pharao und sprich zu ihm: So sagt der HERR, der Hebräer Gott: Laß mein Volk, daß mir's diene; ");
INSERT INTO deu1912_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ich will sonst diesmal alle meine Plagen über dich selbst senden, über deine Knechte und über dein Volk, daß du innewerden sollst, daß meinesgleichen nicht ist in allen Landen. ");
INSERT INTO deu1912_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Denn ich hätte schon jetzt meine Hand ausgereckt und dich und dein Volk mit Pestilenz geschlagen, daß du von der Erde vertilgt würdest. ");
INSERT INTO deu1912_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Aber darum habe ich dich erhalten, daß meine Kraft an dir erscheine und mein Name verkündigt werde in allen Landen. ");
INSERT INTO deu1912_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Du trittst mein Volk noch unter dich und willst's nicht lassen. ");
INSERT INTO deu1912_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Siehe, ich will morgen um diese Zeit einen sehr großen Hagel regnen lassen, desgleichen in Ägypten nicht gewesen ist, seitdem es gegründet ist, bis her. ");
INSERT INTO deu1912_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Und nun sende hin und verwahre dein Vieh, und alles, was du auf dem Felde hast. Denn alle Menschen und das Vieh, das auf dem Felde gefunden wird und nicht in die Häuser versammelt ist, so der Hagel auf sie fällt, werden sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wer nun unter den Knechten Pharaos des HERRN Wort fürchtete, der ließ seine Knechte und sein Vieh in die Häuser fliehen. ");
INSERT INTO deu1912_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Welcher Herz aber sich nicht kehrte an des HERRN Wort, die ließen ihre Knechte und ihr Vieh auf dem Felde. ");
INSERT INTO deu1912_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Da sprach der Herr zu Mose: Recke deine Hand aus gen Himmel, daß es hagle über ganz Ägyptenland, über Menschen, über Vieh und über alles Kraut auf dem Felde in Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Also reckte Mose seinen Stab gen Himmel, und der HERR ließ donnern und hageln, daß das Feuer auf die Erde schoß. Also ließ der HERR Hagel regnen über Ägyptenland, ");
INSERT INTO deu1912_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","daß Hagel und Feuer untereinander fuhren, so grausam, daß desgleichen in ganz Ägyptenland nie gewesen war, seitdem Leute darin gewesen sind. ");
INSERT INTO deu1912_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Und der Hagel schlug in ganz Ägyptenland alles, was auf dem Felde war, Menschen und Vieh, und schlug alles Kraut auf dem Felde und zerbrach alle Bäume auf dem Felde. ");
INSERT INTO deu1912_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Allein im Lande Gosen, da die Kinder Israel wohnten, da hagelte es nicht. ");
INSERT INTO deu1912_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Da schickte Pharao hin und ließ Mose und Aaron rufen und sprach zu ihnen: Ich habe dasmal mich versündigt; der HERR ist gerecht, ich aber und mein Volk sind Gottlose. ");
INSERT INTO deu1912_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bittet aber den Herrn, daß er aufhöre solch Donnern und Hageln Gottes, so will ich euch lassen, daß ihr nicht länger hier bleibet. ");
INSERT INTO deu1912_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose sprach: Wenn ich zur Stadt hinauskomme, so will ich meine Hände ausbreiten gegen den HERRN; so wird der Donner aufhören und kein Hagel mehr sein, daß du innewerdest, daß die Erde des HERRN sei. ");
INSERT INTO deu1912_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ich weiß aber, daß du und deine Knechte euch noch nicht fürchtet vor Gott dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Also ward geschlagen der Flachs und die Gerste; denn die Gerste hatte geschoßt und der Flachs Knoten gewonnen. ");
INSERT INTO deu1912_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Aber der Weizen und Spelt ward nicht geschlagen, denn es war Spätgetreide. ");
INSERT INTO deu1912_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","So ging nun Mose von Pharao zur Stadt hinaus und breitete seine Hände gegen den HERRN, und der Donner und Hagel hörten auf, und der Regen troff nicht mehr auf die Erde. ");
INSERT INTO deu1912_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Da aber Pharao sah, daß der Regen und Donner und Hagel aufhörte, versündigte er sich weiter und verhärtete sein Herz, er und seine Knechte. ");
INSERT INTO deu1912_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Also ward des Pharao Herz verstockt, daß er die Kinder Israel nicht ließ, wie denn der HERR geredet hatte durch Mose. ");
INSERT INTO deu1912_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Und der HERR sprach zu Mose: Gehe hinein zu Pharao; denn ich habe sein und seiner Knechte Herz verhärtet, auf daß ich diese meine Zeichen unter ihnen tue, ");
INSERT INTO deu1912_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","und daß du verkündigest vor den Ohren deiner Kinder und deiner Kindeskinder, was ich in Ägypten ausgerichtet habe und wie ich meine Zeichen unter ihnen getan habe, daß ihr wisset: Ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Also gingen Mose und Aaron hinein zu Pharao und sprachen zu ihm: So spricht der HERR, der Hebräer Gott: Wie lange weigerst du dich, dich vor mir zu demütigen, daß du mein Volk lassest, mir zu dienen? ");
INSERT INTO deu1912_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Weigerst du dich, mein Volk zu lassen, siehe, so will ich morgen Heuschrecken kommen lassen an allen Orten, ");
INSERT INTO deu1912_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","daß sie das Land bedecken, also daß man das Land nicht sehen könne; und sie sollen fressen, was euch übrig und errettet ist vor dem Hagel, und sollen alle grünenden Bäume fressen auf dem Felde ");
INSERT INTO deu1912_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","und sollen erfüllen dein Haus, aller deiner Knechte Häuser und aller Ägypter Häuser, desgleichen nicht gesehen haben deine Väter und deiner Väter Väter, seitdem sie auf Erden gewesen bis auf diesen Tag. Und er wandte sich und ging von Pharao hinaus. ");
INSERT INTO deu1912_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Da sprachen die Knechte Pharaos zu ihm: Wie lange sollen wir mit diesem Manne geplagt sein? Laß die Leute ziehen, daß sie dem HERRN, ihrem Gott, dienen. Willst du zuvor erfahren daß Ägypten untergegangen sei? ");
INSERT INTO deu1912_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mose und Aaron wurden wieder zu Pharao gebracht; der sprach zu ihnen: Gehet hin und dienet dem HERRN, eurem Gott. Welche sind es aber, die hinziehen sollen? ");
INSERT INTO deu1912_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose sprach: Wir wollen hinziehen mit jung und alt, mit Söhnen und Töchtern, mit Schafen und Rindern; denn wir haben ein Fest des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Er sprach zu ihnen: O ja, der HERR sei mit euch! Sollte ich euch und eure Kinder dazu ziehen lassen? Sehet da, ob ihr nicht Böses vorhabt! ");
INSERT INTO deu1912_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nicht also, sondern ihr Männer ziehet hin und dienet dem HERRN; denn das habt ihr auch gesucht. Und man stieß sie heraus von Pharao. ");
INSERT INTO deu1912_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Da sprach der HERR zu Mose: Recke deine Hand über Ägyptenland, daß Heuschrecken auf Ägyptenland kommen und fressen alles Kraut im Lande auf samt allem dem, was der Hagel übriggelassen hat. ");
INSERT INTO deu1912_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mose reckte seinen Stab über Ägyptenland; und der HERR trieb einen Ostwind ins Land den ganzen Tag und die ganze Nacht; und des Morgens führte der Ostwind die Heuschrecken her. ");
INSERT INTO deu1912_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Und sie kamen über das ganze Ägyptenland und ließen sich nieder an allen Orten in Ägypten, so sehr viel, daß zuvor desgleichen nie gewesen ist noch hinfort sein wird. ");
INSERT INTO deu1912_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Denn sie bedeckten das Land und verfinsterten es. Und sie fraßen alles Kraut im Lande auf und alle Früchte auf den Bäumen, die der Hagel übriggelassen hatte, und ließen nichts Grünes übrig an den Bäumen und am Kraut auf dem Felde in ganz Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Da forderte Pharao eilend Mose und Aaron und sprach: Ich habe mich versündigt an dem HERRN, eurem Gott, und an euch; ");
INSERT INTO deu1912_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","vergebt mir meine Sünde nur noch diesmal und bittet den HERRN, euren Gott, daß er doch nur diesen Tod von mir wegnehme. ");
INSERT INTO deu1912_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Und er ging aus von Pharao und bat den HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Da wendete der HERR den Wind, also daß er sehr stark aus Westen ging und hob die Heuschrecken auf und warf sie ins Schilfmeer, daß nicht eine übrigblieb an allen Orten Ägyptens. ");
INSERT INTO deu1912_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Aber der HERR verstockte Pharaos Herz, daß er die Kinder Israel nicht ließ. ");
INSERT INTO deu1912_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Der HERR sprach zu Mose: Recke deine Hand gen Himmel, daß es so finster werde in Ägyptenland, daß man's greifen mag. ");
INSERT INTO deu1912_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Und Mose reckte seine Hand gen Himmel; da ward eine dicke Finsternis in ganz Ägyptenland drei Tage, ");
INSERT INTO deu1912_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","daß niemand den andern sah noch aufstand von dem Ort, da er war, in drei Tagen. Aber bei allen Kindern Israel war es licht in ihren Wohnungen. ");
INSERT INTO deu1912_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Da forderte Pharao Mose und sprach: Ziehet hin und dienet dem Herrn; allein eure Schafe und Rinder laßt hier; laßt auch eure Kindlein mit euch ziehen. ");
INSERT INTO deu1912_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mose sprach: Du mußt uns auch Opfer und Brandopfer geben, die wir unserm Gott, dem HERRN, tun mögen. ");
INSERT INTO deu1912_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Unser Vieh soll mit uns gehen und nicht eine Klaue dahintenbleiben; denn wir wissen nicht, womit wir dem HERRN dienen sollen, bis wir dahin kommen. ");
INSERT INTO deu1912_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Aber der HERR verstockte das Herz Pharao daß er sie nicht lassen wollte. ");
INSERT INTO deu1912_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Und Pharao sprach zu ihm: Gehe von mir und hüte dich, daß du nicht mehr vor meine Augen kommst; denn welches Tages du vor meine Augen kommst, sollst du sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose antwortete: Wie du gesagt hast; ich will nicht mehr vor deine Augen kommen. ");
INSERT INTO deu1912_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Und der HERR sprach zu Mose: Ich will noch eine Plage über Pharao und Ägypten kommen lassen; darnach wird er euch von hinnen lassen und wird nicht allein alles lassen, sondern euch von hinnen treiben. ");
INSERT INTO deu1912_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","So sage nun vor dem Volk, daß ein jeglicher von seinem Nächsten und eine jegliche von ihrer Nächsten silberne und goldene Gefäße fordere. ");
INSERT INTO deu1912_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Und der HERR gab dem Volk Gnade vor den Ägyptern. Und Mose war ein sehr großer Mann in Ägyptenland vor den Knechten Pharaos und vor dem Volk. ");
INSERT INTO deu1912_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Und Mose sprach: So sagt der HERR: Ich will zu Mitternacht ausgehen in Ägyptenland; ");
INSERT INTO deu1912_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","und alle Erstgeburt in Ägyptenland soll sterben, von dem ersten Sohn Pharaos an, der auf seinem Stuhl sitzt, bis an den ersten Sohn der Magd, die hinter der Mühle ist, und alle Erstgeburt unter dem Vieh; ");
INSERT INTO deu1912_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","und wird ein großes Geschrei sein in ganz Ägyptenland, desgleichen nie gewesen ist noch werden wird; ");
INSERT INTO deu1912_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","aber bei allen Kindern Israel soll nicht ein Hund mucken, unter Menschen sowohl als unter Vieh, auf daß ihr erfahret, wie der HERR Ägypten und Israel scheide. ");
INSERT INTO deu1912_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Dann werden zu mir herabkommen alle diese deine Knechte und mir zu Füßen fallen und sagen: Zieh aus, du und alles Volk, das unter dir ist. Darnach will ich ausziehen. Und er ging von Pharao mit grimmigem Zorn. ");
INSERT INTO deu1912_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Der HERR aber sprach zu Mose: Pharao hört euch nicht, auf daß viele Wunder geschehen in Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Und Mose und Aaron haben diese Wunder alle getan vor Pharao; aber der HERR verstockte sein Herz, daß er die Kinder Israel nicht lassen wollte aus seinem Lande. ");
INSERT INTO deu1912_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Der HERR aber sprach zu Mose und Aaron in Ägyptenland: ");
INSERT INTO deu1912_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Dieser Monat soll bei euch der erste Monat sein, und von ihm sollt ihr die Monates des Jahres anheben. ");
INSERT INTO deu1912_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Sagt der ganzen Gemeinde Israel und sprecht: Am zehnten Tage dieses Monats nehme ein jeglicher ein Lamm, wo ein Hausvater ist, je ein Lamm zu einem Haus. ");
INSERT INTO deu1912_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Wo ihrer aber in einem Hause zu einem Lamm zu wenig sind, so nehme er's und sein nächster Nachbar an seinem Hause, bis ihrer so viel wird, daß sie das Lamm aufessen können. ");
INSERT INTO deu1912_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ihr sollt aber ein solches Lamm nehmen, daran kein Fehl ist, ein Männlein und ein Jahr alt; von den Schafen und Ziegen sollt ihr's nehmen ");
INSERT INTO deu1912_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","und sollt's behalten bis auf den vierzehnten Tag des Monats. Und ein jegliches Häuflein im ganzen Israel soll's schlachten gegen Abend. ");
INSERT INTO deu1912_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Und sollt von seinem Blut nehmen und beide Pfosten der Tür und die obere Schwelle damit bestreichen an den Häusern, darin sie es essen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Und sollt also das Fleisch essen in derselben Nacht, am Feuer gebraten, und ungesäuertes Brot, und sollt es mit bitteren Kräutern essen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ihr sollt's nicht roh essen noch mit Wasser gesotten, sondern am Feuer gebraten, sein Haupt mit seinen Schenkeln und Eingeweiden. ");
INSERT INTO deu1912_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Und sollt nichts davon übriglassen bis morgen; wo aber etwas übrigbleibt bis morgen, sollt ihr's mit Feuer verbrennen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Also sollt ihr's aber essen: Um eure Lenden sollt ihr gegürtet sein und eure Schuhe an den Füßen haben und Stäbe in euren Händen, und sollt's essen, als die hinwegeilen; denn es ist des HERRN Passah. ");
INSERT INTO deu1912_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Denn ich will in derselben Nacht durch Ägyptenland gehen und alle Erstgeburt schlagen in Ägyptenland, unter den Menschen und unter dem Vieh, und will meine Strafe beweisen an allen Göttern der Ägypter, ich, der HERR. ");
INSERT INTO deu1912_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Und das Blut soll euer Zeichen sein an den Häusern, darin ihr seid, daß, wenn ich das Blut sehe, an euch vorübergehe und euch nicht die Plage widerfahre, die euch verderbe, wenn ich Ägyptenland schlage. ");
INSERT INTO deu1912_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ihr sollt diesen Tag haben zum Gedächtnis und sollt ihn feiern dem HERRN zum Fest, ihr und alle eure Nachkommen, zur ewigen Weise. ");
INSERT INTO deu1912_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sieben Tage sollt ihr ungesäuertes Brot essen; nämlich am ersten Tage sollt ihr den Sauerteig aus euren Häusern tun. Wer gesäuertes Brot ißt vom ersten Tage an bis auf den siebenten, des Seele soll ausgerottet werden von Israel. ");
INSERT INTO deu1912_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Der Tag soll heilig sein, daß ihr zusammenkommt; und der siebente soll auch heilig sein, daß ihr zusammenkommt. Keine Arbeit sollt ihr an dem tun; außer, was zur Speise gehört für allerlei Seelen, das allein mögt ihr für euch tun. ");
INSERT INTO deu1912_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Und haltet das ungesäuerte Brot; denn eben an demselben Tage habe ich euer Heer aus Ägyptenland geführt; darum sollt ihr diesen Tag halten, ihr und alle eure Nachkommen, zur ewigen Weise. ");
INSERT INTO deu1912_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Am vierzehnten Tage des ersten Monats, des Abends, sollt ihr ungesäuertes Brot essen bis an den einundzwanzigsten Tag des Monats an dem Abend, ");
INSERT INTO deu1912_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","daß man sieben Tage keinen Sauerteig finde in euren Häusern. Denn wer gesäuertes Brot ißt, des Seele soll ausgerottet werden aus der Gemeinde Israel, es sei ein Fremdling oder Einheimischer im Lande. ");
INSERT INTO deu1912_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Darum so esset kein gesäuertes Brot, sondern eitel ungesäuertes Brot in allen euren Wohnungen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Und Mose forderte alle Ältesten in Israel und sprach zu ihnen: Leset aus und nehmet Schafe für euch nach euren Geschlechtern und schlachtet das Passah. ");
INSERT INTO deu1912_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Und nehmet ein Büschel Isop und taucht in das Blut in dem Becken und berühret damit die Oberschwelle und die zwei Pfosten. Und gehe kein Mensch zu seiner Haustür heraus bis an den Morgen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Denn der HERR wird umhergehen und die Ägypter plagen. Und wenn er das Blut sehen wird an der Oberschwelle und den zwei Pfosten, wird er an der Tür vorübergehen und den Verderber nicht in eure Häuser kommen lassen, zu plagen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Darum so halte diese Weise für dich und deine Kinder ewiglich. ");
INSERT INTO deu1912_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Und wenn ihr in das Land kommt, das euch der HERR geben wird, wie er geredet hat, so haltet diesen Dienst. ");
INSERT INTO deu1912_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Und wenn eure Kinder werden zu euch sagen: Was habt ihr da für einen Dienst? ");
INSERT INTO deu1912_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","sollt ihr sagen: Es ist das Passahopfer des HERRN, der an den Kindern Israel vorüberging in Ägypten, da er die Ägypter plagte und unsere Häuser errettete. Da neigte sich das Volk und betete an. ");
INSERT INTO deu1912_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Und die Kinder Israel gingen hin und taten, wie der HERR Mose und Aaron geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Und zur Mitternacht schlug der HERR alle Erstgeburt in Ägyptenland von dem ersten Sohn Pharaos an, der auf seinem Stuhl saß, bis auf den ersten Sohn des Gefangenen im Gefängnis und alle Erstgeburt des Viehs. ");
INSERT INTO deu1912_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Da stand Pharao auf und alle seine Knechte in derselben Nacht und alle Ägypter, und ward ein großes Geschrei in Ägypten; denn es war kein Haus, darin nicht ein Toter war. ");
INSERT INTO deu1912_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Und er forderte Moses und Aaron in der Nacht und sprach: Macht euch auf und ziehet aus von meinem Volk, ihr und die Kinder Israel; gehet hin und dienet dem HERRN, wie ihr gesagt habt. ");
INSERT INTO deu1912_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Nehmet auch mit euch eure Schafe und Rinder, wie ihr gesagt habt; gehet hin und segnet mich auch. ");
INSERT INTO deu1912_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Und die Ägypter drängten das Volk, daß sie es eilend aus dem Lande trieben; denn sie sprachen: Wir sind alle des Todes. ");
INSERT INTO deu1912_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Und das Volk trug den rohen Teig, ehe denn er versäuert war, zu ihrer Speise, gebunden in ihren Kleidern, auf ihren Achseln. ");
INSERT INTO deu1912_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Und die Kinder Israel hatten getan, wie Mose gesagt hatte, und von den Ägyptern gefordert silberne und goldene Geräte und Kleider. ");
INSERT INTO deu1912_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Dazu hatte der HERR dem Volk Gnade gegeben vor den Ägyptern, daß sie ihnen willfährig waren; und so nahmen sie es von den Ägyptern zur Beute. ");
INSERT INTO deu1912_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Also zogen aus die Kinder Israel von Raemses gen Sukkoth, sechshunderttausend Mann zu Fuß ohne die Kinder. ");
INSERT INTO deu1912_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Und es zog auch mit ihnen viel Pöbelvolk und Schafe und Rinder, sehr viel Vieh. ");
INSERT INTO deu1912_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Und sie buken aus dem rohen Teig, den sie aus Ägypten brachten, ungesäuerte Kuchen; denn es war nicht gesäuert, weil sie aus Ägypten gestoßen wurden und nicht verziehen konnten und sich sonst keine Zehrung zubereitet hatten. ");
INSERT INTO deu1912_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Die Zeit aber, die die Kinder Israel in Ägypten gewohnt haben, ist vierhundertunddreißig Jahre. ");
INSERT INTO deu1912_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Da dieselben um waren, ging das ganze Heer des HERRN auf einen Tag aus Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Darum wird diese Nacht dem HERRN gehalten, daß er sie aus Ägyptenland geführt hat; und die Kinder Israel sollen sie dem HERRN halten, sie und ihre Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Und der HERR sprach zu Mose und Aaron: Dies ist die Weise Passah zu halten. Kein Fremder soll davon essen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Aber wer ein erkaufter Knecht ist, den beschneide man, und dann esse er davon. ");
INSERT INTO deu1912_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ein Beisaß und Mietling sollen nicht davon essen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In einem Hause soll man's essen; ihr sollt nichts von seinem Fleisch hinaus vor das Haus tragen und sollt kein Bein an ihm zerbrechen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Die ganze Gemeinde Israel soll solches tun. ");
INSERT INTO deu1912_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","So aber ein Fremdling bei dir wohnt und dem HERRN das Passah halten will, der beschneide alles, was männlich ist; alsdann mache er sich herzu, daß er solches tue, und sei wie ein Einheimischer des Landes; denn kein Unbeschnittener soll davon essen. ");
INSERT INTO deu1912_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Einerlei Gesetz sei dem Einheimischen und dem Fremdling, der unter euch wohnt. ");
INSERT INTO deu1912_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Und alle Kinder Israel taten, wie der HERR Mose und Aaron hatte geboten. ");
INSERT INTO deu1912_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Also führte der HERR auf einen Tag die Kinder Israel aus Ägyptenland mit ihrem Heer. ");
INSERT INTO deu1912_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Heilige mir alle Erstgeburt, die allerlei Mutter bricht bei den Kindern Israel, unter den Menschen und unter dem Vieh; denn sie sind mein. ");
INSERT INTO deu1912_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Da sprach Mose zum Volk: Gedenket an diesen Tag, an dem ihr aus Ägypten, aus dem Diensthause, gegangen seid, daß der HERR euch mit mächtiger Hand von hinnen hat ausgeführt; darum sollst du nicht Sauerteig essen. ");
INSERT INTO deu1912_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Heute seid ihr ausgegangen, in dem Monat Abib. ");
INSERT INTO deu1912_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Wenn dich nun der HERR bringen wird in das Land der Kanaaniter, Hethiter, Amoriter, Heviter und Jebusiter, daß er deinen Vätern geschworen hat dir zu geben, ein Land, darin Milch und Honig fließt, so sollst du diesen Dienst halten in diesem Monat. ");
INSERT INTO deu1912_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sieben Tage sollst du ungesäuertes Brot essen, und am siebenten Tage ist des HERRN Fest. ");
INSERT INTO deu1912_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Darum sollst du sieben Tage ungesäuertes Brot essen, daß bei dir kein Sauerteig noch gesäuertes Brot gesehen werde an allen deinen Orten. ");
INSERT INTO deu1912_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ihr sollt euren Söhnen sagen an demselben Tage: Solches halten wir um deswillen, was uns der HERR getan hat, da wir aus Ägypten zogen. ");
INSERT INTO deu1912_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Darum soll dir's sein ein Zeichen in deiner Hand und ein Denkmal vor deinen Augen, auf daß des HERRN Gesetz sei in deinem Munde; denn der HERR hat dich mit mächtiger Hand aus Ägypten geführt. ");
INSERT INTO deu1912_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Darum halte diese Weise zu seiner Zeit jährlich. ");
INSERT INTO deu1912_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Wenn dich nun der HERR ins Land der Kanaaniter gebracht hat, wie er dir und deinen Vätern geschworen hat und dir's gegeben, ");
INSERT INTO deu1912_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","so sollst du aussondern dem HERRN alles, was die Mutter bricht, und alle Erstgeburt unter dem Vieh, was ein Männlein ist. ");
INSERT INTO deu1912_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Die Erstgeburt vom Esel sollst du lösen mit einem Schaf; wo du es aber nicht lösest, so brich ihm das Genick. Aber alle erste Menschengeburt unter deinen Söhnen sollst du lösen. ");
INSERT INTO deu1912_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Und wenn dich heute oder morgen dein Kind wird fragen: Was ist das? sollst du ihm sagen: Der HERR hat uns mit mächtiger Hand aus Ägypten, von dem Diensthause, geführt. ");
INSERT INTO deu1912_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Denn da Pharao hart war, uns loszulassen, erschlug der HERR alle Erstgeburt in Ägyptenland, von der Menschen Erstgeburt an bis an die Erstgeburt des Viehs. Darum opfre ich dem HERRN alles, was die Mutter bricht, was ein Männlein ist, und die Erstgeburt meiner Söhne löse ich. ");
INSERT INTO deu1912_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Das soll dir ein Zeichen in deiner Hand sein und ein Denkmal vor deinen Augen; denn der HERR hat uns mit mächtiger Hand aus Ägypten geführt. ");
INSERT INTO deu1912_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Da nun Pharao das Volk gelassen hatte, führte sie Gott nicht auf der Straße durch der Philister Land, die am nächsten war; denn Gott gedachte es möchte das Volk gereuen, wenn sie den Streit sähen, und sie möchten wieder nach Ägypten umkehren. ");
INSERT INTO deu1912_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Darum führte er das Volk um auf die Straße durch die Wüste am Schilfmeer. Und die Kinder Israel zogen gerüstet aus Ägyptenland. ");
INSERT INTO deu1912_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Und Mose nahm mit sich die Gebeine Josephs. Denn er hatte einen Eid von den Kindern Israel genommen und gesprochen: Gott wird euch heimsuchen; so führt meine Gebeine mit euch von hinnen. ");
INSERT INTO deu1912_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Also zogen sie aus von Sukkoth und lagerten sich in Etham, vorn an der Wüste. ");
INSERT INTO deu1912_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Und der HERR zog vor ihnen her, des Tages in einer Wolkensäule, daß er den rechten Weg führte, und des Nachts in einer Feuersäule, daß er ihnen leuchtete, zu reisen Tag und Nacht. ");
INSERT INTO deu1912_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Die Wolkensäule wich nimmer von dem Volk des Tages noch die Feuersäule des Nachts. ");
INSERT INTO deu1912_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Rede mit den Kindern Israel und sprich, daß sie sich herumlenken und sich lagern bei Pihachiroth, zwischen Migdol und dem Meer, gegen Baal-Zephon, und daselbst gegenüber sich lagern ans Meer. ");
INSERT INTO deu1912_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Denn Pharao wird sagen von den Kindern Israel: Sie sind verirrt im Lande; die Wüste hat sie eingeschlossen. ");
INSERT INTO deu1912_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Und ich will sein Herz verstocken, daß er ihnen nachjage, und will an Pharao und an aller seiner Macht Ehre einlegen, und die Ägypter sollen innewerden, daß ich der HERR bin. Und sie taten also. ");
INSERT INTO deu1912_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Und da es dem König in Ägypten angesagt ward, daß das Volk geflohen war, ward sein Herz verwandelt und das Herz seiner Knechte gegen das Volk, und sie sprachen: Warum haben wir das getan, daß wir Israel haben gelassen, daß sie uns nicht dienten? ");
INSERT INTO deu1912_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Und er spannte seinen Wagen an und nahm sein Volk mit sich ");
INSERT INTO deu1912_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","und nahm sechshundert auserlesene Wagen und was sonst von Wagen in Ägypten war und die Hauptleute über all sein Heer. ");
INSERT INTO deu1912_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Denn der HERR verstockte das Herz Pharaos, des Königs in Ägypten, daß er den Kindern Israel nachjagte. Aber die Kinder Israel waren durch eine hohe Hand ausgezogen. ");
INSERT INTO deu1912_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Und die Ägypter jagten ihnen nach und ereilten sie (da sie sich gelagert hatten am Meer) mit Rossen und Wagen und Reitern und allem Heer des Pharao bei Pihachiroth, gegen Baal-Zephon. ");
INSERT INTO deu1912_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Und da Pharao zu ihnen nahe kam, hoben die Kinder Israel ihre Augen auf, und siehe, die Ägypter zogen hinter ihnen her; und sie fürchteten sich sehr und schrieen zu dem HERRN ");
INSERT INTO deu1912_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","und sprachen zu Mose: Waren nicht genug Gräber in Ägypten, daß du uns mußtest wegführen, daß wir in der Wüste sterben? Warum hast du uns das getan, daß du uns aus Ägypten geführt hast? ");
INSERT INTO deu1912_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ist's nicht das, das wir dir sagten in Ägypten: Höre auf und laß uns den Ägyptern dienen? Denn es wäre uns ja besser den Ägyptern dienen als in der Wüste sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mose sprach zum Volk: Fürchtet euch nicht, stehet fest und sehet zu, was für ein Heil der HERR heute an euch tun wird. Denn diese Ägypter, die ihr heute sehet, werdet ihr nimmermehr sehen ewiglich. ");
INSERT INTO deu1912_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Der HERR wird für euch streiten, und ihr werdet still sein. ");
INSERT INTO deu1912_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Der HERR sprach zu Mose: Was schreist du zu mir? sage den Kindern Israel, daß sie ziehen. ");
INSERT INTO deu1912_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Du aber hebe deinen Stab auf und recke deine Hand aus über das Meer und teile es voneinander, daß die Kinder Israel hineingehen, mitten hindurch auf dem Trockenen. ");
INSERT INTO deu1912_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Siehe, ich will das Herz der Ägypter verstocken, daß sie euch nachfolgen. So will ich Ehre einlegen an dem Pharao und an aller seiner Macht, an seinen Wagen und Reitern. ");
INSERT INTO deu1912_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Und die Ägypter sollen innewerden, daß ich der HERR bin, wenn ich Ehre eingelegt habe an Pharao und an seinen Wagen und Reitern. ");
INSERT INTO deu1912_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Da erhob sich der Engel Gottes, der vor dem Heer Israels her zog, und machte sich hinter sie; und die Wolkensäule machte sich auch von ihrem Angesicht und trat hinter sie ");
INSERT INTO deu1912_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","und kam zwischen das Heer der Ägypter und das Heer Israels. Es war aber eine finstere Wolke und erleuchtete die Nacht, daß sie die ganze Nacht, diese und jene, nicht zusammenkommen konnten. ");
INSERT INTO deu1912_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Da nun Mose seine Hand reckte über das Meer, ließ es der HERR hinwegfahren durch einen starken Ostwind die ganze Nacht und machte das Meer trocken; und die Wasser teilten sich voneinander. ");
INSERT INTO deu1912_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Und die Kinder Israel gingen hinein, mitten ins Meer auf dem Trockenen; und das Wasser war ihnen für Mauern zur Rechten und zur Linken. ");
INSERT INTO deu1912_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Und die Ägypter folgten und gingen hinein ihnen nach, alle Rosse Pharaos und Wagen und Reiter, mitten ins Meer. ");
INSERT INTO deu1912_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Als nun die Morgenwache kam, schaute der HERR auf der Ägypter Heer aus der Feuersäule und Wolke und machte einen Schrecken in ihrem Heer ");
INSERT INTO deu1912_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","und stieß die Räder von ihren Wagen, stürzte sie mit Ungestüm. Da sprachen die Ägypter: Laßt uns fliehen von Israel; der HERR streitet für sie wider die Ägypter. ");
INSERT INTO deu1912_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Aber der HERR sprach zu Mose: Recke deine Hand aus über das Meer, daß das Wasser wieder herfalle über die Ägypter, über ihre Wagen und Reiter. ");
INSERT INTO deu1912_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Da reckte Mose seine Hand aus über das Meer, und das Meer kam wieder vor morgens in seinen Strom, und die Ägypter flohen ihm entgegen. Also stürzte sie der HERR mitten ins Meer, ");
INSERT INTO deu1912_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","daß das Wasser wiederkam und bedeckte Wagen und Reiter und alle Macht des Pharao, die ihnen nachgefolgt waren ins Meer, daß nicht einer aus ihnen übrigblieb. ");
INSERT INTO deu1912_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Aber die Kinder Israel gingen trocken mitten durchs Meer; und das Wasser war ihnen für Mauern zur Rechten und zur Linken. ");
INSERT INTO deu1912_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Also half der HERR Israel an dem Tage von der Ägypter Hand. Und sie sahen die Ägypter tot am Ufer des Meeres ");
INSERT INTO deu1912_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","und die große Hand, die der HERR an den Ägyptern erzeigt hatte. Und das Volk fürchtete den HERRN, und sie glaubten ihm und seinem Knecht Mose. ");
INSERT INTO deu1912_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Da sang Mose und die Kinder Israel dies Lied dem HERRN und sprachen: Ich will dem HERRN singen, denn er hat eine herrliche Tat getan; Roß und Mann hat er ins Meer gestürzt. ");
INSERT INTO deu1912_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Der HERR ist meine Stärke und mein Lobgesang und ist mein Heil. Das ist mein Gott, ich will ihn preisen; er ist meines Vaters Gott, ich will ihn erheben. ");
INSERT INTO deu1912_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Der HERR ist der rechte Kriegsmann; HERR ist sein Name. ");
INSERT INTO deu1912_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Die Wagen Pharaos und seine Macht warf er ins Meer; seine auserwählten Hauptleute versanken im Schilfmeer. ");
INSERT INTO deu1912_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Die Tiefe hat sie bedeckt; sie fielen zu Grund wie die Steine. ");
INSERT INTO deu1912_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","HERR, deine rechte Hand tut große Wunder; HERR, deine rechte Hand hat die Feinde zerschlagen. ");
INSERT INTO deu1912_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Und mit deiner großen Herrlichkeit hast du deine Widersacher gestürzt; denn da du deinen Grimm ausließest, verzehrte er sie wie Stoppeln. ");
INSERT INTO deu1912_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Durch dein Blasen taten sich die Wasser empor, und die Fluten standen in Haufen; die Tiefe wallte voneinander mitten im Meer. ");
INSERT INTO deu1912_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Der Feind gedachte: Ich will nachjagen und erhaschen und den Raub austeilen und meinen Mut an ihnen kühlen; ich will mein Schwert ausziehen, und meine Hand soll sie verderben. ");
INSERT INTO deu1912_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Da ließest du deinen Wind blasen und das Meer bedeckte sie, und sie sanken unter wie Blei im mächtigen Wasser. ");
INSERT INTO deu1912_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","HERR, wer ist dir gleich unter den Göttern? Wer ist dir gleich, der so mächtig, heilig, schrecklich, löblich und wundertätig sei? ");
INSERT INTO deu1912_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Da du deine rechte Hand ausrecktest, verschlang sie die Erde. ");
INSERT INTO deu1912_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Du hast geleitet durch deine Barmherzigkeit dein Volk, das du erlöst hast, und du hast sie geführt durch deine Stärke zu deiner heiligen Wohnung. ");
INSERT INTO deu1912_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Da das die Völker hörten, erbebten sie; Angst kam die Philister an; ");
INSERT INTO deu1912_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","da erschraken die Fürsten Edoms; Zittern kam die Gewaltigen Moabs an; alle Einwohner Kanaans wurden feig. ");
INSERT INTO deu1912_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Es fällt auf sie Erschrecken und Furcht durch deinen großen Arm, daß sie erstarren wie die Steine, bis dein Volk, HERR, hindurchkomme, das du erworben hast. ");
INSERT INTO deu1912_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Du bringst sie hinein und pflanzest sie auf dem Berge deines Erbteils, den du, HERR, dir zur Wohnung gemacht hast, zu deinem Heiligtum, Herr, das deine Hand bereitet hat. ");
INSERT INTO deu1912_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Der HERR wird König sein immer und ewig. ");
INSERT INTO deu1912_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Denn Pharao zog hinein ins Meer mit Rossen und Wagen und Reitern; und der HERR ließ das Meer wieder über sie fallen. Aber die Kinder Israel gingen trocken mitten durchs Meer. ");
INSERT INTO deu1912_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Und Mirjam, die Prophetin, Aarons Schwester, nahm eine Pauke in ihre Hand, und alle Weiber folgten ihr nach hinaus mit Pauken im Reigen. ");
INSERT INTO deu1912_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Und Mirjam sang ihnen vor: Laßt uns dem HERRN singen, denn er hat eine herrliche Tat getan; Roß und Mann hat er ins Meer gestürzt. ");
INSERT INTO deu1912_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mose ließ die Kinder Israel ziehen vom Schilfmeer hinaus zur Wüste Sur. Und sie wanderten drei Tage in der Wüste, daß sie kein Wasser fanden. ");
INSERT INTO deu1912_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Da kamen sie gen Mara; aber sie konnten das Wasser nicht trinken, denn es war sehr bitter. Daher hieß man den Ort Mara. ");
INSERT INTO deu1912_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Da murrte das Volk wider Mose und sprach: Was sollen wir trinken? ");
INSERT INTO deu1912_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Er schrie zu dem HERRN, und der HERR wies ihm einen Baum; den tat er ins Wasser, da ward es süß. Daselbst stellte er ihnen ein Gesetz und ein Recht und versuchte sie ");
INSERT INTO deu1912_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","und sprach: Wirst du der Stimme des HERRN, deines Gottes, gehorchen und tun, was recht ist vor ihm, und zu Ohren fassen seine Gebote und halten alle seine Gesetze, so will ich der Krankheiten keine auf dich legen, die ich auf Ägypten gelegt habe; denn ich bin der HERR, dein Arzt. ");
INSERT INTO deu1912_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Und sie kamen gen Elim, da waren zwölf Wasserbrunnen und siebzig Palmbäume, und sie lagerten sich daselbst ans Wasser. ");
INSERT INTO deu1912_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Von Elim zogen sie aus; und die ganze Gemeinde der Kinder Israel kam in die Wüste Sin, die da liegt zwischen Elim und Sinai, am fünfzehnten Tage des zweiten Monats, nachdem sie aus Ägypten gezogen waren. ");
INSERT INTO deu1912_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Und es murrte die ganze Gemeinde der Kinder Israel wider Mose und Aaron in der Wüste ");
INSERT INTO deu1912_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","und sprachen: Wollte Gott, wir wären in Ägypten gestorben durch des HERRN Hand, da wir bei den Fleischtöpfen saßen und hatten die Fülle Brot zu essen; denn ihr habt uns ausgeführt in diese Wüste, daß ihr diese ganze Gemeinde Hungers sterben lasset. ");
INSERT INTO deu1912_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Da sprach der HERR zu Mose: Siehe, ich will euch Brot vom Himmel regnen lassen, und das Volk soll hinausgehen und sammeln täglich, was es des Tages bedarf, daß ich's versuche, ob's in meinen Gesetzen wandle oder nicht. ");
INSERT INTO deu1912_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Des sechsten Tages aber sollen sie zurichten, was sie einbringen, und es wird zwiefältig soviel sein, als sie sonst täglich sammeln. ");
INSERT INTO deu1912_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mose und Aaron sprachen zu allen Kindern Israel: Am Abend sollt ihr innewerden, daß euch der HERR aus Ägyptenland geführt hat, ");
INSERT INTO deu1912_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","und des Morgens werdet ihr des HERRN Herrlichkeit sehen; denn er hat euer Murren wider den HERRN gehört. Was sind wir, daß ihr wider uns murrt? ");
INSERT INTO deu1912_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Weiter sprach Mose: Der HERR wird euch am Abend Fleisch zu essen geben und am Morgen Brots die Fülle, darum daß der HERR euer Murren gehört hat, daß ihr wider ihn gemurrt habt. Denn was sind wir? Euer Murren ist nicht wider uns, sondern wider den HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Und Mose sprach zu Aaron: Sage der ganzen Gemeinde der Kinder Israel: Kommt herbei vor den HERRN, denn er hat euer Murren gehört. ");
INSERT INTO deu1912_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Und da Aaron also redete zu der ganzen Gemeinde der Kinder Israel, wandten sie sich gegen die Wüste; und siehe, die Herrlichkeit des HERRN erschien in einer Wolke. ");
INSERT INTO deu1912_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Und der HERR sprach zu Mose: ");
INSERT INTO deu1912_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ich habe der Kinder Israel Murren gehört. Sage ihnen: Gegen Abend sollt ihr Fleisch zu essen haben und am Morgen von Brot satt werden, und innewerden, daß ich der HERR, euer Gott, bin. ");
INSERT INTO deu1912_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Und am Abend kamen Wachteln herauf und bedeckten das Heer. Und am Morgen lag der Tau um das Heer her. ");
INSERT INTO deu1912_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Und als der Tau weg war, siehe, da lag's in der Wüste rund und klein wie der Reif auf dem Lande. ");
INSERT INTO deu1912_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Und da es die Kinder Israel sahen, sprachen sie untereinander: Man hu? (Das heißt: Was ist das?); denn sie wußten nicht was es war. Mose aber sprach zu ihnen: es ist das Brot, das euch der HERR zu essen gegeben hat. ");
INSERT INTO deu1912_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Das ist's aber, was der HERR geboten hat: Ein jeglicher sammle, soviel er für sich essen mag, und nehme einen Gomer auf ein jeglich Haupt nach der Zahl der Seelen in seiner Hütte. ");
INSERT INTO deu1912_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Und die Kinder Israel taten also und sammelten, einer viel, der andere wenig. ");
INSERT INTO deu1912_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Aber da man's mit dem Gomer maß, fand der nicht darüber, der viel gesammelt hatte, und der nicht darunter, der wenig gesammelt hatte; sondern ein jeglicher hatte gesammelt, soviel er für sich essen mochte. ");
INSERT INTO deu1912_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Und Mose sprach zu ihnen: Niemand lasse etwas übrig bis morgen. ");
INSERT INTO deu1912_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Aber sie gehorchten Mose nicht. Und da etliche ließen davon übrig bis morgen; da wuchsen Würmer darin und es ward stinkend. Und Mose ward zornig auf sie. ");
INSERT INTO deu1912_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Sie sammelten aber alle Morgen, soviel ein jeglicher für sich essen mochte. Wenn aber die Sonne heiß schien, zerschmolz es. ");
INSERT INTO deu1912_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Und des sechsten Tages sammelten sie des Brots zwiefältig, je zwei Gomer für einen. Und alle Obersten der Gemeinde kamen hinein und verkündigten's Mose. ");
INSERT INTO deu1912_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Und er sprach zu ihnen: Das ist's, was der HERR gesagt hat: Morgen ist der Sabbat der heiligen Ruhe des HERRN; was ihr backen wollt, das backt, und was ihr kochen wollt, das kocht; was aber übrig ist, das lasset bleiben, daß es behalten werde bis morgen. ");
INSERT INTO deu1912_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Und sie ließen's bleiben bis morgen, wie Mose geboten hatte; da ward's nicht stinkend und war auch kein Wurm darin. ");
INSERT INTO deu1912_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Da sprach Mose: Esset das heute, denn es ist heute der Sabbat des HERRN; ihr werdet's heute nicht finden auf dem Felde. ");
INSERT INTO deu1912_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sechs Tage sollt ihr sammeln; aber der siebente Tag ist der Sabbat, an dem wird nichts da sein. ");
INSERT INTO deu1912_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Aber am siebenten Tage gingen etliche vom Volk hinaus, zu sammeln, und fanden nichts. ");
INSERT INTO deu1912_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Da sprach der HERR zu Mose: Wie lange weigert ihr euch, zu halten meine Gebote und Gesetze? ");
INSERT INTO deu1912_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Sehet, der HERR hat euch den Sabbat gegeben; darum gibt er euch am sechsten Tage zweier Tage Brot. So bleibe nun ein jeglicher in dem Seinen, und niemand gehe heraus von seinem Ort des siebenten Tages. ");
INSERT INTO deu1912_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Also feierte das Volk am siebenten Tage. ");
INSERT INTO deu1912_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Und das Haus Israel hieß es Man. Und es war wie Koriandersamen und weiß und hatte den Geschmack wie Semmel mit Honig. ");
INSERT INTO deu1912_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Und Mose sprach: Das ist's, was der HERR geboten hat: Fülle ein Gomer davon, es zu behalten auf eure Nachkommen, auf daß man sehe das Brot, damit ich euch gespeist habe in der Wüste, da ich euch aus Ägyptenland führte. ");
INSERT INTO deu1912_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Und Mose sprach zu Aaron: Nimm ein Krüglein und tu ein Gomer voll Man darein und laß es vor dem HERRN, daß es behalten werde auf eure Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Wie der HERR dem Mose geboten hatte, also ließ es Aaron daselbst vor dem Zeugnis, daß es behalten werde. ");
INSERT INTO deu1912_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Und die Kinder Israel aßen Man vierzig Jahre, bis daß sie zu dem Lande kamen, da sie wohnen sollten; bis an die Grenze des Landes Kanaan aßen sie Man. ");
INSERT INTO deu1912_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ein Gomer aber ist der zehnte Teil eines Epha. ");
INSERT INTO deu1912_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Und die ganze Gemeinde der Kinder Israel zog aus der Wüste Sin ihre Tagereisen, wie ihnen der HERR befahl, und sie lagerten sich in Raphidim. Da hatte das Volk kein Wasser zu trinken. ");
INSERT INTO deu1912_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Und sie zankten mit Mose und sprachen: Gebt uns Wasser, daß wir trinken. Mose sprach zu ihnen: Was zankt ihr mit mir? Warum versucht ihr den HERRN? ");
INSERT INTO deu1912_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Da aber das Volk daselbst dürstete nach Wasser, murrten sie wider Mose und sprachen: Warum hast du uns lassen aus Ägypten ziehen, daß du uns, unsre Kinder und unser Vieh Durstes sterben ließest? ");
INSERT INTO deu1912_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mose schrie zum HERRN und sprach: Wie soll ich mit dem Volk tun? Es fehlt nicht viel, sie werden mich noch steinigen. ");
INSERT INTO deu1912_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Der HERR sprach zu ihm: Gehe hin vor dem Volk und nimm etliche Älteste von Israel mit dir und nimm deinen Stab in deine Hand, mit dem du den Strom schlugst, und gehe hin. ");
INSERT INTO deu1912_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Siehe, ich will daselbst stehen vor dir auf einem Fels am Horeb; da sollst du den Fels schlagen, so wird Wasser herauslaufen, daß das Volk trinke. Mose tat also vor den Ältesten von Israel. ");
INSERT INTO deu1912_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Da hieß man den Ort Massa und Meriba um des Zanks willen der Kinder Israel, und daß sie den HERRN versucht und gesagt hatten: Ist der HERR unter uns oder nicht? ");
INSERT INTO deu1912_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Da kam Amalek und stritt wider Israel in Raphidim. ");
INSERT INTO deu1912_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Und Mose sprach zu Josua: Erwähle uns Männer, zieh aus und streite wider Amalek; morgen will ich auf des Hügels Spitze stehen und den Stab Gottes in meiner Hand haben. ");
INSERT INTO deu1912_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Und Josua tat, wie Mose ihm sagte, daß er wider Amalek stritte. Mose aber und Aaron und Hur gingen auf die Spitze des Hügels. ");
INSERT INTO deu1912_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Und wenn Mose seine Hand emporhielt, siegte Israel; wenn er aber seine Hand niederließ, siegte Amalek. ");
INSERT INTO deu1912_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Aber die Hände Mose's wurden schwer; darum nahmen sie einen Stein und legten ihn unter ihn, daß er sich daraufsetzte. Aaron aber und Hur stützten ihm seine Hände, auf jeglicher Seite einer. Also blieben seine Hände fest, bis die Sonne unterging. ");
INSERT INTO deu1912_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Und Josua dämpfte den Amalek und sein Volk durch des Schwertes Schärfe. ");
INSERT INTO deu1912_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Und der HERR sprach zu Mose: Schreibe das zum Gedächtnis in ein Buch und befiehls's in die Ohren Josuas; denn ich will den Amalek unter dem Himmel austilgen, daß man sein nicht mehr gedenke. ");
INSERT INTO deu1912_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Und Mose baute einen Altar und hieß ihn: Der HERR ist mein Panier. ");
INSERT INTO deu1912_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Denn er sprach: Es ist ein Malzeichen bei dem Stuhl des HERRN, daß der HERR streiten wird wider Amalek von Kind zu Kindeskind. ");
INSERT INTO deu1912_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Und da Jethro, der Priester in Midian, Mose's Schwiegervater, hörte alles, was Gott getan hatte mit Mose und seinem Volk Israel, daß der HERR Israel hätte aus Ägypten geführt, ");
INSERT INTO deu1912_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","nahm er Zippora, Mose's Weib, die er hatte zurückgesandt, ");
INSERT INTO deu1912_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","samt ihren zwei Söhnen, deren einer hieß Gerson (denn er sprach: Ich bin ein Gast geworden in fremdem Lande) ");
INSERT INTO deu1912_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","und der andere Elieser (denn er sprach: Der Gott meines Vaters ist meine Hilfe gewesen und hat mich errettet von dem Schwert Pharaos). ");
INSERT INTO deu1912_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Da nun Jethro, Mose's Schwiegervater, und seine Söhne und sein Weib zu ihm kamen in die Wüste, an den Berg Gottes, da er sich gelagert hatte, ");
INSERT INTO deu1912_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ließ er Mose sagen: Ich, Jethro, dein Schwiegervater, bin zu dir gekommen und dein Weib und ihre beiden Söhne mit ihr. ");
INSERT INTO deu1912_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Da ging Mose hinaus ihm entgegen und neigte sich vor ihm und küßte ihn. Und da sie sich untereinander gegrüßt hatten, gingen sie in die Hütte. ");
INSERT INTO deu1912_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Da erzählte Mose seinem Schwiegervater alles, was der HERR dem Pharao und den Ägyptern getan hatte Israels halben, und alle die Mühsal, die ihnen auf den Wege begegnet war, und daß sie der HERR errettet hätte. ");
INSERT INTO deu1912_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro aber freute sich all des Guten, das der HERR Israel getan hatte, daß er sie errettet hatte von der Ägypter Hand. ");
INSERT INTO deu1912_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Und Jethro sprach: Gelobt sei der HERR, der euch errettet hat von der Ägypter und Pharaos Hand, der weiß sein Volk von der Ägypter Hand zu erretten. ");
INSERT INTO deu1912_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nun weiß ich, daß der HERR größer ist denn alle Götter, darum daß sie Hochmut an ihnen geübt haben. ");
INSERT INTO deu1912_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Und Jethro, Mose's Schwiegervater, brachte Gott ein Brandopfer mit Dankopfern. Da kamen Aaron und alle Ältesten in Israel, mit Mose's Schwiegervater das Brot zu essen vor Gott. ");
INSERT INTO deu1912_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Des andern Morgens setzte sich Mose, das Volk zu richten; und das Volk stand um Mose her von Morgen an bis zu Abend. ");
INSERT INTO deu1912_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Da aber sein Schwiegervater sah alles, was er dem Volke tat, sprach er: Was ist's, das du tust mit dem Volk? Warum sitzt du allein, und alles Volk steht um dich her von Morgen an bis zu Abend? ");
INSERT INTO deu1912_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose antwortete ihm: Das Volk kommt zu mir, Gott um Rat zu fragen. ");
INSERT INTO deu1912_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Denn wo sie was zu schaffen haben, kommen sie zu mir, daß ich richte zwischen einem jeglichen und seinem Nächsten und zeige ihnen Gottes Rechte und seine Gesetze. ");
INSERT INTO deu1912_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Sein Schwiegervater sprach zu ihm: Es ist nicht gut, was du tust. ");
INSERT INTO deu1912_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Du machst dich zu müde, dazu das Volk auch, das mit dir ist. Das Geschäft ist dir zu schwer; du kannst's allein nicht ausrichten. ");
INSERT INTO deu1912_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Aber gehorche meiner Stimme; ich will dir raten, und Gott wird mit dir sein. Pflege du des Volks vor Gott und bringe die Geschäfte vor Gott ");
INSERT INTO deu1912_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","und stelle ihnen Rechte und Gesetze, daß du sie lehrst den Weg, darin sie wandeln, und die Werke, die sie tun sollen. ");
INSERT INTO deu1912_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Siehe dich aber um unter allem Volk nach redlichen Leuten, die Gott fürchten, wahrhaftig und dem Geiz feind sind; die setze über sie, etliche über tausend, über hundert, über fünfzig und über zehn, ");
INSERT INTO deu1912_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","daß sie das Volk allezeit richten; wo aber eine große Sache ist, daß sie dieselbe an dich bringen, und sie alle geringen Sachen richten. So wird dir's leichter werden, und sie werden mit dir tragen. ");
INSERT INTO deu1912_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Wirst du das tun, so kannst du ausrichten, was Gott dir gebietet, und all dies Volk kann mit Frieden an seinen Ort kommen. ");
INSERT INTO deu1912_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose gehorchte seines Schwiegervaters Wort und tat alles, was er sagte, ");
INSERT INTO deu1912_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","und erwählte redliche Leute aus ganz Israel und machte sie zu Häuptern über das Volk, etliche über tausend, über hundert, über fünfzig und über zehn, ");
INSERT INTO deu1912_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","daß sie das Volk allezeit richteten; was aber schwere Sachen wären, zu Mose brächten, und die kleinen Sachen selber richteten. ");
INSERT INTO deu1912_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Also ließ Mose seinen Schwiegervater in sein Land ziehen. ");
INSERT INTO deu1912_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Im dritten Monat nach dem Ausgang der Kinder Israel aus Ägyptenland kamen sie dieses Tages in die Wüste Sinai. ");
INSERT INTO deu1912_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Denn sie waren ausgezogen von Raphidim und wollten in die Wüste Sinai und lagerten sich in der Wüste daselbst gegenüber dem Berge. ");
INSERT INTO deu1912_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Und Mose stieg hinauf zu Gott. Und der HERR rief ihm vom Berge und sprach: So sollst du sagen dem Hause Jakob und verkündigen den Kindern Israel: ");
INSERT INTO deu1912_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ihr habt gesehen, was ich den Ägyptern getan habe, und wie ich euch getragen habe auf Adlerflügeln und habe euch zu mir gebracht. ");
INSERT INTO deu1912_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Werdet ihr nun meiner Stimme gehorchen und meinen Bund halten, so sollt ihr mein Eigentum sein vor allen Völkern; denn die ganze Erde ist mein. ");
INSERT INTO deu1912_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Und ihr sollt mir ein priesterlich Königreich und ein heiliges Volk sein. Das sind die Worte, die du den Kindern Israel sagen sollst. ");
INSERT INTO deu1912_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mose kam und forderte die Ältesten im Volk und legte ihnen alle diese Worte vor, die der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Und alles Volk antwortete zugleich und sprach: Alles, was der HERR geredet hat, wollen wir tun. Und Mose sagte die Rede des Volkes dem HERRN wieder. ");
INSERT INTO deu1912_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Und der HERR sprach zu Mose: Siehe, ich will zu dir kommen in einer dicken Wolke, auf daß dies Volk es höre, wenn ich mit dir rede, und glaube dir ewiglich. Und Mose verkündigte dem HERRN die Rede des Volks. ");
INSERT INTO deu1912_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Und der HERR sprach zu Mose: Gehe hin zum Volk und heilige sie heute und morgen, daß sie ihre Kleider waschen ");
INSERT INTO deu1912_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","und bereit seien auf den dritten Tag; denn am dritten Tage wird der HERR herabfahren auf den Berg Sinai. ");
INSERT INTO deu1912_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Und mache dem Volk ein Gehege umher und sprich zu ihnen: Hütet euch, daß ihr nicht auf den Berg steiget noch sein Ende anrührt; denn wer den Berg anrührt, soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Keine Hand soll ihn anrühren, sondern er soll gesteinigt oder mit Geschoß erschossen werden; es sei ein Tier oder ein Mensch, so soll er nicht leben. Wenn es aber lange tönen wird, dann sollen sie an den Berg gehen. ");
INSERT INTO deu1912_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mose stieg vom Berge zum Volk und heiligte sie, und sie wuschen ihre Kleider. ");
INSERT INTO deu1912_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Und er sprach zu ihnen: Seid bereit auf den dritten Tag, und keiner nahe sich zum Weibe. ");
INSERT INTO deu1912_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Als nun der dritte Tag kam und es Morgen war, da erhob sich ein Donnern und Blitzen und eine dicke Wolke auf dem Berge und ein Ton einer sehr starken Posaune; das ganze Volk aber, das im Lager war, erschrak. ");
INSERT INTO deu1912_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Und Mose führte das Volk aus dem Lager Gott entgegen, und es trat unten an den Berg. ");
INSERT INTO deu1912_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Der ganze Berg Sinai aber rauchte, darum daß der HERR herab auf den Berg fuhr mit Feuer; und sein Rauch ging auf wie ein Rauch vom Ofen, daß der ganze Berg sehr bebte. ");
INSERT INTO deu1912_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Und der Posaune Ton ward immer stärker. Mose redete, und Gott antwortete ihm laut. ");
INSERT INTO deu1912_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Als nun der HERR herniedergekommen war auf den Berg Sinai, oben auf seine Spitze, forderte er Mose oben auf die Spitze des Berges, und Mose stieg hinauf. ");
INSERT INTO deu1912_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Da sprach der HERR zu ihm: Steig hinab und bezeuge dem Volk, daß sie nicht durchbrechen zum HERRN, ihn zu sehen, und viele aus ihnen fallen. ");
INSERT INTO deu1912_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Dazu die Priester, die zum HERRN nahen, sollen sich heiligen, daß sie der HERR nicht zerschmettere. ");
INSERT INTO deu1912_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose aber sprach zum HERRN: Das Volk kann nicht auf den Berg Sinai steigen; denn du hast uns bezeugt und gesagt: Mache ein Gehege um den Berg und heilige ihn. ");
INSERT INTO deu1912_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Und der HERR sprach zu ihm: Gehe hin, steige hinab! Du und Aaron mit dir sollt heraufsteigen; aber die Priester und das Volk sollen nicht durchbrechen, daß sie hinaufsteigen zu dem HERRN, daß er sie nicht zerschmettere. ");
INSERT INTO deu1912_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Und Mose stieg herunter zum Volk und sagte es ihm. ");
INSERT INTO deu1912_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Und Gott redete alle diese Worte: ");
INSERT INTO deu1912_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ich bin der HERR, dein Gott, der ich dich aus Ägyptenland, aus dem Diensthause, geführt habe. ");
INSERT INTO deu1912_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Du sollst keine anderen Götter neben mir haben. ");
INSERT INTO deu1912_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Du sollst dir kein Bildnis noch irgend ein Gleichnis machen, weder des, das oben im Himmel, noch des, das unten auf Erden, oder des, das im Wasser unter der Erde ist. ");
INSERT INTO deu1912_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Bete sie nicht an und diene ihnen nicht. Denn ich, der HERR, dein Gott, bin ein eifriger Gott, der da heimsucht der Väter Missetat an den Kindern bis in das dritte und vierte Glied, die mich hassen; ");
INSERT INTO deu1912_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","und tue Barmherzigkeit an vielen Tausenden, die mich liebhaben und meine Gebote halten. ");
INSERT INTO deu1912_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Du sollst den Namen des HERRN, deines Gottes, nicht mißbrauchen; denn der HERR wird den nicht ungestraft lassen, der seinen Namen mißbraucht. ");
INSERT INTO deu1912_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Gedenke des Sabbattags, daß Du ihn heiligest. ");
INSERT INTO deu1912_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sechs Tage sollst du arbeiten und alle dein Dinge beschicken; ");
INSERT INTO deu1912_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","aber am siebenten Tage ist der Sabbat des HERRN, deines Gottes; da sollst du kein Werk tun noch dein Sohn noch deine Tochter noch dein Knecht noch deine Magd noch dein Vieh noch dein Fremdling, der in deinen Toren ist. ");
INSERT INTO deu1912_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Denn in sechs Tagen hat der HERR Himmel und Erde gemacht und das Meer und alles, was darinnen ist, und ruhte am siebenten Tage. Darum segnete der HERR den Sabbattag und heiligte ihn. ");
INSERT INTO deu1912_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Du sollst deinen Vater und deine Mutter ehren, auf daß du lange lebest in dem Lande, daß dir der HERR, dein Gott, gibt. ");
INSERT INTO deu1912_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Du sollst nicht töten. ");
INSERT INTO deu1912_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Du sollst nicht ehebrechen. ");
INSERT INTO deu1912_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Du sollst nicht stehlen. ");
INSERT INTO deu1912_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Du sollst kein falsch Zeugnis reden wider deinen Nächsten. ");
INSERT INTO deu1912_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Laß dich nicht gelüsten deines Nächsten Hauses. Laß dich nicht gelüsten deines Nächsten Weibes, noch seines Knechtes noch seiner Magd, noch seines Ochsen noch seines Esels, noch alles, was dein Nächster hat. ");
INSERT INTO deu1912_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Und alles Volk sah den Donner und Blitz und den Ton der Posaune und den Berg rauchen. Da sie aber solches sahen, flohen sie und traten von ferne ");
INSERT INTO deu1912_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","und sprachen zu Mose: Rede du mit uns, wir wollen gehorchen; und laß Gott nicht mit uns reden, wir möchten sonst sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose aber sprach zum Volk: Fürchtet euch nicht; denn Gott ist gekommen, daß er euch versuchte und daß seine Furcht euch vor Augen wäre, daß ihr nicht sündigt. ");
INSERT INTO deu1912_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Also trat das Volk von ferne; aber Mose machte sich hinzu in das Dunkel, darin Gott war. ");
INSERT INTO deu1912_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Und der HERR sprach zu ihm: Also sollst du den Kindern Israel sagen: Ihr habt gesehen, daß ich mit euch vom Himmel geredet habe. ");
INSERT INTO deu1912_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Darum sollt ihr nichts neben mir machen; silberne und goldene Götter sollt ihr nicht machen. ");
INSERT INTO deu1912_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Einen Altar von Erde mache mir, darauf du dein Brandopfer und Dankopfer, deine Schafe und Rinder opferst. Denn an welchem Ort ich meines Namens Gedächtnis stiften werde, da will ich zu dir kommen und dich segnen. ");
INSERT INTO deu1912_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Und so du mir einen steinernen Altar machen willst, sollst du ihn nicht von gehauenen Steinen bauen; denn wo du mit deinem Messer darüber fährst, so wirst du ihn entweihen. ");
INSERT INTO deu1912_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Du sollst auch nicht auf Stufen zu meinem Altar steigen, daß nicht deine Blöße aufgedeckt werde vor ihm. ");
INSERT INTO deu1912_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Dies sind die Rechte, die du ihnen sollst vorlegen: ");
INSERT INTO deu1912_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","So du einen hebräischen Knecht kaufst, der soll dir sechs Jahre dienen; im siebenten Jahr soll er frei ausgehen umsonst. ");
INSERT INTO deu1912_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ist er ohne Weib gekommen, so soll er auch ohne Weib ausgehen; ist er aber mit Weib gekommen, so soll sein Weib mit ihm ausgehen. ");
INSERT INTO deu1912_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Hat ihm aber sein Herr ein Weib gegeben, und er hat Söhne oder Töchter gezeugt, so soll das Weib und die Kinder seines Herrn sein, er aber soll ohne Weib ausgehen. ");
INSERT INTO deu1912_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Spricht aber der Knecht: Ich habe meinen Herren lieb und mein Weib und Kind, ich will nicht frei werden, ");
INSERT INTO deu1912_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","so bringe ihn sein Herr vor die “Götter” und halte ihn an die Tür oder den Pfosten und bohre ihm mit einem Pfriem durch sein Ohr, und er sei sein Knecht ewig. ");
INSERT INTO deu1912_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Verkauft jemand sein Tochter zur Magd, so soll sie nicht ausgehen wie die Knechte. ");
INSERT INTO deu1912_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Gefällt sie aber ihrem Herrn nicht und will er sie nicht zur Ehe nehmen, so soll er sie zu lösen geben. Aber unter ein fremdes Volk sie zu verkaufen hat er nicht Macht, weil er sie verschmäht hat. ");
INSERT INTO deu1912_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Vertraut er sie aber seinem Sohn, so soll er Tochterrecht an ihr tun. ");
INSERT INTO deu1912_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Gibt er ihm aber noch eine andere, so soll er an ihrer Nahrung, Kleidung und Eheschuld nichts abbrechen. ");
INSERT INTO deu1912_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Tut er diese drei nicht, so soll sie frei ausgehen ohne Lösegeld. ");
INSERT INTO deu1912_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wer einen Menschen schlägt, daß er stirbt, der soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Hat er ihm aber nicht nachgestellt, sondern Gott hat ihn lassen ungefähr in seine Hände fallen, so will ich dir einen Ort bestimmen, dahin er fliehen soll. ");
INSERT INTO deu1912_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Wo aber jemand seinem Nächsten frevelt und ihn mit List erwürgt, so sollst du denselben von meinem Altar nehmen, daß man ihn töte. ");
INSERT INTO deu1912_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wer Vater und Mutter schlägt, der soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wer einen Menschen stiehlt, es sei, daß er ihn verkauft oder daß man ihn bei ihm findet, der soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wer Vater und Mutter flucht, der soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Wenn Männer mit einander hadern und einer schlägt den andern mit einem Stein oder mit einer Faust, daß er nicht stirbt, sondern zu Bette liegt: ");
INSERT INTO deu1912_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kommt er auf, daß er ausgeht an seinem Stabe, so soll, der ihn schlug, unschuldig sein, nur daß er ihm bezahle, was er versäumt hat, und das Arztgeld gebe. ");
INSERT INTO deu1912_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Wer seinen Knecht oder seine Magd schlägt mit einem Stabe, daß sie sterben unter seinen Händen, der soll darum gestraft werden. ");
INSERT INTO deu1912_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Bleibt er aber einen oder zwei Tage am Leben, so soll er darum nicht gestraft werden; denn es ist sein Geld. ");
INSERT INTO deu1912_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Wenn Männer hadern und verletzen ein schwangeres Weib, daß ihr die Frucht abgeht, und ihr kein Schade widerfährt, so soll man ihn um Geld strafen, wieviel des Weibes Mann ihm auflegt, und er soll's geben nach der Schiedsrichter Erkennen. ");
INSERT INTO deu1912_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kommt ihr aber ein Schade daraus, so soll er lassen Seele um Seele, ");
INSERT INTO deu1912_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Auge um Auge, Zahn um Zahn, Hand um Hand, Fuß um Fuß, ");
INSERT INTO deu1912_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Brand um Brand, Wunde um Wunde, Beule um Beule. ");
INSERT INTO deu1912_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Wenn jemand seinen Knecht oder seine Magd in ein Auge schlägt und verderbt es, der soll sie frei loslassen um das Auge. ");
INSERT INTO deu1912_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Desgleichen, wenn er seinem Knecht oder seiner Magd einen Zahn ausschlägt, soll er sie frei loslassen um den Zahn. ");
INSERT INTO deu1912_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Wenn ein Ochse einen Mann oder ein Weib stößt, daß sie sterben, so soll man den Ochsen steinigen und sein Fleisch nicht essen; so ist der Herr des Ochsen unschuldig. ");
INSERT INTO deu1912_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ist aber der Ochse zuvor stößig gewesen, und seinem Herrn ist's angesagt, und hat ihn nicht verwahrt, und er tötet darüber einen Mann oder ein Weib, so soll man den Ochsen steinigen, und sein Herr soll sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Wird man aber ein Lösegeld auf ihn legen, so soll er geben, sein Leben zu lösen, was man ihm auflegt. ");
INSERT INTO deu1912_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Desgleichen soll man mit ihm handeln, wenn er Sohn oder Tochter stößt. ");
INSERT INTO deu1912_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Stößt er aber einen Knecht oder eine Magd, so soll er ihrem Herrn dreißig Silberlinge geben, und den Ochsen soll man steinigen. ");
INSERT INTO deu1912_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","So jemand eine Grube auftut oder gräbt eine Grube und deckt sie nicht zu, und es fällt ein Ochse oder Esel hinein, ");
INSERT INTO deu1912_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","so soll's der Herr der Grube mit Geld dem andern wiederbezahlen; das Aas aber soll sein sein. ");
INSERT INTO deu1912_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Wenn jemandes Ochse eines andern Ochsen stößt, daß er stirbt, so sollen sie den lebendigen Ochsen verkaufen und das Geld teilen und das Aas auch teilen. ");
INSERT INTO deu1912_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ist's aber kund gewesen, daß der Ochse zuvor stößig war, und sein Herr hat ihn nicht verwahrt, so soll er einen Ochsen für den andern vergelten und das Aas haben. ");
INSERT INTO deu1912_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","21:37 Wenn jemand einen Ochsen oder ein Schaf stiehlt und schlachtet's oder verkauft's, der soll fünf Ochsen für einen Ochsen wiedergeben und vier Schafe für ein Schaf. ");
INSERT INTO deu1912_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","22:1 Wenn ein Dieb ergriffen wird, daß er einbricht, und wird dabei geschlagen, daß er stirbt, so soll man kein Blutgericht über jenen lassen gehen. ");
INSERT INTO deu1912_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","22:2 Ist aber die Sonne über ihn aufgegangen, so soll man das Blutgericht gehen lassen. Es soll aber ein Dieb wiedererstatten; hat er nichts, so verkaufe man ihn um seinen Diebstahl. ");
INSERT INTO deu1912_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","22:3 Findet man aber bei ihm den Diebstahl lebendig, es sei ein Ochse, Esel oder Schaf, so soll er's zwiefältig wiedergeben. ");
INSERT INTO deu1912_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","22:4 Wenn jemand einen Acker oder Weinberg beschädigt, daß er sein Vieh läßt Schaden tun in eines andern Acker, der soll von dem Besten auf seinem Acker und Weinberg wiedererstatten. ");
INSERT INTO deu1912_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","22:5 Wenn ein Feuer auskommt und ergreift die Dornen und verbrennt die Garben oder Getreide, das noch steht, oder den Acker, so soll der wiedererstatten, der das Feuer angezündet hat. ");
INSERT INTO deu1912_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","22:6 Wenn jemand seinem Nächsten Geld oder Geräte zu bewahren gibt, und es wird demselben aus seinem Hause gestohlen: findet man den Dieb, so soll er's zwiefältig wiedergeben; ");
INSERT INTO deu1912_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","22:7 findet man aber den Dieb nicht, so soll man den Hauswirt vor die “Götter” bringen, ob er nicht seine Hand habe an seines Nächsten Habe gelegt. ");
INSERT INTO deu1912_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","22:8 Wo einer den andern beschuldigt um irgend ein Unrecht, es sei um Ochsen oder Esel oder Schaf oder Kleider oder allerlei, das verloren ist, so soll beider Sache vor die “Götter” kommen. Welchen die “Götter” verdammen, der soll's zwiefältig seinem Nächsten wiedergeben. ");
INSERT INTO deu1912_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","22:9 Wenn jemand seinem Nächsten einen Esel oder Ochsen oder ein Schaf oder irgend ein Vieh zu bewahren gibt, und es stirbt ihm oder wird beschädigt oder wird ihm weggetrieben, daß es niemand sieht, ");
INSERT INTO deu1912_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","22:10 so soll man's unter ihnen auf einen Eid bei dem HERRN kommen lassen, ob er nicht habe seine Hand an seines Nächsten Habe gelegt; und des Gutes Herr soll's annehmen, also daß jener nicht bezahlen müsse. ");
INSERT INTO deu1912_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","22:11 Stiehlt's ihm aber ein Dieb, so soll er's seinem Herrn bezahlen. ");
INSERT INTO deu1912_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","22:12 Wird es aber zerrissen, soll er Zeugnis davon bringen und nicht bezahlen. ");
INSERT INTO deu1912_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","22:13 Wenn's jemand von seinem Nächsten entlehnt, und es wird beschädigt oder stirbt, daß sein Herr nicht dabei ist, so soll er's bezahlen. ");
INSERT INTO deu1912_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","22:14 Ist sein Herr aber dabei, soll er's nicht bezahlen, so er's um sein Geld gedingt hat. ");
INSERT INTO deu1912_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","22:15 Wenn jemand eine Jungfrau beredet, die noch nicht verlobt ist, und bei ihr schläft, der soll ihr geben ihre Morgengabe und sie zum Weibe haben. ");
INSERT INTO deu1912_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","22:16 Weigert sich aber ihr Vater, sie ihm zu geben, soll er Geld darwägen, wieviel einer Jungfrau zur Morgengabe gebührt. ");
INSERT INTO deu1912_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","22:17 Die Zauberinnen sollst du nicht leben lassen. ");
INSERT INTO deu1912_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","22:18 Wer bei einem Vieh liegt, der soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","22:19 Wer den Göttern opfert und nicht dem HERRN allein, der sei verbannt. ");
INSERT INTO deu1912_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","22:20 Die Fremdlinge sollst du nicht schinden noch unterdrücken; denn ihr seid auch Fremdlinge in Ägyptenland gewesen. ");
INSERT INTO deu1912_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","22:21 Ihr sollt keine Witwen und Waisen bedrängen. ");
INSERT INTO deu1912_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","22:22 Wirst du sie bedrängen, so werden sie zu mir schreien, und ich werde ihr Schreien erhören; ");
INSERT INTO deu1912_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","22:23 so wird mein Zorn ergrimmen, daß ich euch mit dem Schwert töte und eure Weiber Witwen und eure Kinder Waisen werden. ");
INSERT INTO deu1912_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","22:24 Wenn du Geld leihst einem aus meinem Volk, der arm ist bei dir, sollst du ihn nicht zu Schaden bringen und keinen Wucher an ihm treiben. ");
INSERT INTO deu1912_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","22:25 Wenn du von deinem Nächsten ein Kleid zum Pfande nimmst, sollst du es ihm wiedergeben, ehe die Sonne untergeht; ");
INSERT INTO deu1912_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","22:26 denn sein Kleid ist seine einzige Decke seiner Haut, darin er schläft. Wird er aber zu mir schreien, so werde ich ihn erhören; denn ich bin gnädig. ");
INSERT INTO deu1912_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","22:27 Den “Göttern” sollst du nicht fluchen, und den Obersten in deinem Volk nicht lästern. ");
INSERT INTO deu1912_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","22:28 Deiner Frucht Fülle und Saft sollst du nicht zurückhalten. Deinen ersten Sohn sollst du mir geben. ");
INSERT INTO deu1912_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","22:29 So sollst du auch tun mit deinem Ochsen und Schafe. Sieben Tage laß es bei seiner Mutter sein, am achten Tag sollst du mir's geben. ");
INSERT INTO deu1912_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","22:30 Ihr sollt heilige Leute vor mir sein; darum sollt ihr kein Fleisch essen, das auf dem Felde von Tieren zerrissen ist, sondern es vor die Hunde werfen. ");
INSERT INTO deu1912_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Du sollst falscher Anklage nicht glauben, daß du einem Gottlosen Beistand tust und ein falscher Zeuge seist. ");
INSERT INTO deu1912_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Du sollst nicht folgen der Menge zum Bösen und nicht also verantworten vor Gericht, daß du der Menge nach vom Rechten weichest. ");
INSERT INTO deu1912_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Du sollst den Geringen nicht beschönigen in seiner Sache. ");
INSERT INTO deu1912_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Wenn du deines Feindes Ochsen oder Esel begegnest, daß er irrt, so sollst du ihm denselben wieder zuführen. ");
INSERT INTO deu1912_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Wenn du den Esel des, der dich haßt, siehst unter seiner Last liegen, hüte dich, und laß ihn nicht, sondern versäume gerne das Deine um seinetwillen. ");
INSERT INTO deu1912_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Du sollst das Recht deines Armen nicht beugen in seiner Sache. ");
INSERT INTO deu1912_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Sei ferne von falschen Sachen. Den Unschuldigen und Gerechten sollst du nicht erwürgen; denn ich lasse den Gottlosen nicht Recht haben. ");
INSERT INTO deu1912_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Du sollst nicht Geschenke nehmen; denn Geschenke machen die Sehenden blind und verkehren die Sachen der Gerechten. ");
INSERT INTO deu1912_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Die Fremdlinge sollt ihr nicht unterdrücken; denn ihr wisset um der Fremdlinge Herz, dieweil ihr auch seid Fremdlinge in Ägyptenland gewesen. ");
INSERT INTO deu1912_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Sechs Jahre sollst du dein Land besäen und seine Früchte einsammeln. ");
INSERT INTO deu1912_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Im siebenten Jahr sollst du es ruhen und liegen lassen, daß die Armen unter deinem Volk davon essen; und was übrigbleibt, laß das Wild auf dem Felde essen. Also sollst du auch tun mit deinem Weinberg und Ölberg. ");
INSERT INTO deu1912_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sechs Tage sollst du deine Arbeit tun; aber des siebenten Tages sollst du feiern, auf daß dein Ochs und Esel ruhen und deiner Magd Sohn und der Fremdling sich erquicken. ");
INSERT INTO deu1912_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Alles, was ich euch gesagt habe, das haltet. Und anderer Götter Namen sollt ihr nicht gedenken, und aus eurem Munde sollen sie nicht gehört werden. ");
INSERT INTO deu1912_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Dreimal sollt ihr mir Feste halten im Jahr: ");
INSERT INTO deu1912_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","das Fest der ungesäuerten Brote sollst du halten, daß du sieben Tage ungesäuertes Brot essest, wie ich dir geboten habe, um die Zeit des Monats Abib; denn in demselben bist du aus Ägypten gezogen. Erscheint aber nicht leer vor mir. ");
INSERT INTO deu1912_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Und das Fest der Ernte, der Erstlinge deiner Früchte, die du auf dem Felde gesät hast. Und das Fest der Einsammlung im Ausgang des Jahres, wenn du deine Arbeit eingesammelt hast vom Felde. ");
INSERT INTO deu1912_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Dreimal im Jahre soll erscheinen vor dem HERRN, dem Herrscher, alles, was männlich ist unter dir. ");
INSERT INTO deu1912_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Du sollst das Blut meines Opfers nicht neben dem Sauerteig opfern, und das Fett von meinem Fest soll nicht bleiben bis auf morgen. ");
INSERT INTO deu1912_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Die Erstlinge von der ersten Frucht auf deinem Felde sollst du bringen in das Haus des HERRN, deines Gottes. Und sollst das Böcklein nicht kochen in seiner Mutter Milch. ");
INSERT INTO deu1912_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Siehe, ich sende einen Engel vor dir her, der dich behüte auf dem Wege und bringe dich an den Ort, den ich bereitet habe. ");
INSERT INTO deu1912_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Darum hüte dich vor seinem Angesicht und gehorche seiner Stimme und erbittere ihn nicht; denn er wird euer Übertreten nicht vergeben, und mein Name ist in ihm. ");
INSERT INTO deu1912_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Wirst du aber seiner Stimme hören und tun alles, was ich dir sagen werde, so will ich deiner Feinde Feind und deiner Widersacher Widersacher sein. ");
INSERT INTO deu1912_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Wenn nun mein Engel vor dir her geht und dich bringt an die Amoriter, Hethiter, Pheresiter, Kanaaniter, Heviter und Jebusiter und ich sie vertilge, ");
INSERT INTO deu1912_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","so sollst du ihre Götter nicht anbeten noch ihnen dienen und nicht tun, wie sie tun, sondern du sollst ihre Götzen umreißen und zerbrechen. ");
INSERT INTO deu1912_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Aber dem HERRN, eurem Gott, sollt ihr dienen, so wird er dein Brot und dein Wasser segnen, und ich will alle Krankheit von dir wenden. ");
INSERT INTO deu1912_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Es soll nichts Unträchtiges noch Unfruchtbares sein in deinem Lande, und ich will dich lassen alt werden. ");
INSERT INTO deu1912_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ich will meinen Schrecken vor dir her senden und alles Volk verzagt machen, dahin du kommst, und will dir alle deine Feinde in die Flucht geben. ");
INSERT INTO deu1912_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ich will Hornissen vor dir her senden, die vor dir her ausjagen die Heviter, Kanaaniter und Hethiter. ");
INSERT INTO deu1912_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ich will sie nicht auf ein Jahr ausstoßen vor dir, auf daß nicht das Land wüst werde und sich wilde Tiere wider dich mehren; ");
INSERT INTO deu1912_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","einzeln nacheinander will ich sie vor dir her ausstoßen, bis du wächsest und das Land besitzest. ");
INSERT INTO deu1912_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Und will deine Grenze setzen von dem Schilfmeer bis an das Philistermeer und von der Wüste bis an den Strom. Denn ich will dir in deine Hand geben die Einwohner des Landes, daß du sie sollst ausstoßen vor dir her. ");
INSERT INTO deu1912_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Du sollst mit ihnen oder mit ihren Göttern keinen Bund machen; ");
INSERT INTO deu1912_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","sondern laß sie nicht wohnen in deinem Lande, daß sie dich nicht verführen wider mich. Denn wo du ihren Göttern dienst, wird dir's zum Fall geraten. ");
INSERT INTO deu1912_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Und zu Mose sprach er: Steig herauf zum HERRN, du und Aaron, Nadab und Abihu und siebzig von den Ältesten Israels, und betet an von ferne. ");
INSERT INTO deu1912_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Aber Mose allein nahe sich zum HERRN und lasse jene nicht herzu nahen, und das Volk komme auch nicht zu ihm herauf. ");
INSERT INTO deu1912_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mose kam und erzählte dem Volk alle Worte des HERRN und alle Rechte. Da antwortete alles Volk mit einer Stimme und sprachen: Alle Worte, die der HERR gesagt hat, wollen wir tun. ");
INSERT INTO deu1912_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Da schrieb Mose alle Worte des HERRN und machte sich des Morgens früh auf und baute einen Altar unten am Berge mit zwölf Säulen nach den zwölf Stämmen Israels, ");
INSERT INTO deu1912_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","und sandte hin Jünglinge aus den Kindern Israel, daß sie Brandopfer darauf opferten und Dankopfer dem HERRN von Farren. ");
INSERT INTO deu1912_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Und Mose nahm die Hälfte des Blutes und tat's in ein Becken, die andere Hälfte sprengte er auf den Altar. ");
INSERT INTO deu1912_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Und nahm das Buch des Bundes und las es vor den Ohren des Volkes. Und da sie sprachen: Alles, was der HERR gesagt hat, das wollen wir tun und gehorchen, ");
INSERT INTO deu1912_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","da nahm Mose das Blut und besprengte das Volk damit und sprach: Sehet, das ist das Blut des Bundes, den der HERR mit euch macht über allen diesen Worten. ");
INSERT INTO deu1912_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Da stiegen Mose und Aaron, Nadab und Abihu und siebzig von den Ältesten Israels hinauf ");
INSERT INTO deu1912_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","und sahen den Gott Israels. Unter seinen Füßen war es wie ein schöner Saphir und wie die Gestalt des Himmels, wenn's klar ist. ");
INSERT INTO deu1912_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Und er reckte seine Hand nicht aus wider die Obersten in Israel. Und da sie Gott geschaut hatten, aßen und tranken sie. ");
INSERT INTO deu1912_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Und der HERR sprach zu Mose: Komm herauf zu mir auf den Berg und bleib daselbst, daß ich dir gebe steinerne Tafeln und Gesetze und Gebote, die ich geschrieben habe, die du sie lehren sollst. ");
INSERT INTO deu1912_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Da machte sich Mose auf mit seinem Diener Josua und stieg auf den Berg Gottes ");
INSERT INTO deu1912_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","und sprach zu den Ältesten: Bleibet hier, bis wir wieder zu euch kommen. Siehe, Aaron und Hur sind bei euch; hat jemand eine Sache, der komme vor dieselben. ");
INSERT INTO deu1912_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Da nun Mose auf den Berg kam, bedeckte eine Wolke den Berg, ");
INSERT INTO deu1912_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","und die Herrlichkeit des HERRN wohnte auf dem Berge Sinai und deckte ihn mit der Wolke sechs Tage, und er rief Mose am siebenten Tage aus der Wolke. ");
INSERT INTO deu1912_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Und das Ansehen der Herrlichkeit des HERRN war wie ein verzehrendes Feuer auf der Spitze des Berges vor den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Und Mose ging mitten in die Wolke und stieg auf den Berg und blieb auf dem Berg vierzig Tage und vierzig Nächte. ");
INSERT INTO deu1912_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Sage den Kindern Israel, daß sie mir ein Hebopfer geben; und nehmt dasselbe von jedermann, der es willig gibt. ");
INSERT INTO deu1912_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Das ist aber das Hebopfer, das ihr von ihnen nehmen sollt: Gold, Silber, Erz, ");
INSERT INTO deu1912_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blauer und roter Purpur, Scharlach, köstliche weiße Leinwand, Ziegenhaar, ");
INSERT INTO deu1912_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","rötliche Widderfelle, Dachsfelle, Akazienholz, ");
INSERT INTO deu1912_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Öl zur Lampe, Spezerei zur Salbe und zu gutem Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Onyxsteine und eingefaßte Steine zum Leibrock und zum Amtschild. ");
INSERT INTO deu1912_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Und sie sollen mir ein Heiligtum machen, daß ich unter ihnen wohne. ");
INSERT INTO deu1912_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Wie ich dir ein Vorbild der Wohnung und alles ihres Geräts zeigen werde, so sollt ihr's machen. ");
INSERT INTO deu1912_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Macht eine Lade aus Akazienholz; dritthalb Ellen soll die Länge sein, anderthalb Ellen die Breite und anderthalb Ellen die Höhe. ");
INSERT INTO deu1912_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Du sollst sie mit Gold überziehen inwendig und auswendig, und mache einen goldenen Kranz oben umher. ");
INSERT INTO deu1912_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Und gieße vier goldene Ringe und mache sie an ihr vier Ecken, also daß zwei Ringe seien auf einer Seite und zwei auf der andern Seite. ");
INSERT INTO deu1912_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Und mache Stangen von Akazienholz und überziehe sie mit Gold ");
INSERT INTO deu1912_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","und stecke sie in die Ringe an der Lade Seiten, daß man sie damit trage; ");
INSERT INTO deu1912_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","sie sollen in den Ringen bleiben und nicht herausgetan werden. ");
INSERT INTO deu1912_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Und sollst in die Lade das Zeugnis legen, das ich dir geben werde. ");
INSERT INTO deu1912_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Du sollst auch einen Gnadenstuhl machen von feinem Golde; dritthalb Ellen soll seine Länge sein und anderthalb Ellen seine Breite. ");
INSERT INTO deu1912_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Und du sollst zwei Cherubim machen von getriebenem Golde zu beiden Enden des Gnadenstuhls, ");
INSERT INTO deu1912_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","daß ein Cherub sei an diesem Ende, der andere an dem andern Ende, und also zwei Cherubim seien an des Gnadenstuhls Enden. ");
INSERT INTO deu1912_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Und die Cherubim sollen ihr Flügel ausbreiten von oben her, daß sie mit ihren Flügeln den Gnadenstuhl bedecken und eines jeglichen Antlitz gegen das des andern stehe; und ihre Antlitze sollen auf den Gnadenstuhl sehen. ");
INSERT INTO deu1912_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Und sollst den Gnadenstuhl oben auf die Lade tun und in die Lade das Zeugnis legen, das ich dir geben werde. ");
INSERT INTO deu1912_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Von dem Ort will ich mich dir bezeugen und mit dir reden, nämlich von dem Gnadenstuhl zwischen den zwei Cherubim, der auf der Lade des Zeugnisses ist, alles, was ich dir gebieten will an die Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Du sollst auch einen Tisch machen von Akazienholz; zwei Ellen soll seine Länge sein und eine Elle sein Breite und anderthalb Ellen seine Höhe. ");
INSERT INTO deu1912_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Und sollst ihn überziehen mit feinem Gold und einen goldenen Kranz umher machen ");
INSERT INTO deu1912_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","und eine Leiste umher, eine Handbreit hoch, und einen goldenen Kranz um die Leiste her. ");
INSERT INTO deu1912_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Und sollst vier goldene Ringe daran machen an die vier Ecken an seinen vier Füßen. ");
INSERT INTO deu1912_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Hart unter der Leiste sollen die Ringe sein, daß man Stangen darein tue und den Tisch trage. ");
INSERT INTO deu1912_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Und sollst die Stangen von Akazienholz machen und sie mit Gold überziehen, daß der Tisch damit getragen werde. ");
INSERT INTO deu1912_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Du sollst auch aus feinem Golde seine Schüsseln und Löffel machen, seine Kannen und Schalen, darin man das Trankopfer darbringe. ");
INSERT INTO deu1912_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Und sollst auf den Tisch allezeit Schaubrote legen vor mir. ");
INSERT INTO deu1912_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Du sollst auch einen Leuchter von feinem, getriebenem Golde machen; daran soll der Schaft mit Röhren, Schalen, Knäufen und Blumen sein. ");
INSERT INTO deu1912_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Sechs Röhren sollen aus dem Leuchter zu den Seiten ausgehen, aus jeglicher Seite drei Röhren. ");
INSERT INTO deu1912_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Eine jegliche Röhre soll drei offene Schalen mit Knäufen und Blumen haben; so soll es sein bei den sechs Röhren aus dem Leuchter. ");
INSERT INTO deu1912_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Aber der Schaft am Leuchter soll vier offene Schalen mit Knäufen und Blumen haben ");
INSERT INTO deu1912_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","und je einen Knauf unter zwei von den Sechs Röhren, welche aus dem Leuchter gehen. ");
INSERT INTO deu1912_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Beide, die Knäufe und Röhren, sollen aus ihm gehen, alles getriebenes, lauteres Gold. ");
INSERT INTO deu1912_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Und sollst sieben Lampen machen obenauf, daß sie nach vornehin leuchten, ");
INSERT INTO deu1912_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","und Lichtschneuzen und Löschnäpfe von feinem Golde. ");
INSERT INTO deu1912_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Aus einem Zentner feinen Goldes sollst du das machen mit allem diesem Gerät. ");
INSERT INTO deu1912_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Und siehe zu, daß du es machst nach dem Bilde, das du auf dem Berge gesehen hast. ");
INSERT INTO deu1912_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Die Wohnung sollst du machen von zehn Teppichen, von gezwirnter, weißer Leinwand, von blauem und rotem Purpur und von Scharlach. Cherubim sollst du daran machen von kunstreicher Arbeit. ");
INSERT INTO deu1912_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Die Länge eines Teppichs soll achtundzwanzig Ellen sein, die Breite vier Ellen, und sollen alle zehn gleich sein. ");
INSERT INTO deu1912_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Und sollen je fünf zu einem Stück zusammengefügt sein, einer an den andern. ");
INSERT INTO deu1912_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Und sollst Schleifen machen von blauem Purpur an jegliches Stück am Rand, wo die zwei Stücke sollen zusammengeheftet werden; ");
INSERT INTO deu1912_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","fünfzig Schleifen an jegliches Stück, daß eine Schleife der andern gegenüberstehe. ");
INSERT INTO deu1912_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Und sollst fünfzig goldene Haken machen, womit man die Teppiche zusammenheftet, einen an den andern, auf daß es eine Wohnung werde. ");
INSERT INTO deu1912_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Du sollst auch eine Decke aus Ziegenhaar machen zur Hütte über die Wohnung von elf Teppichen. ");
INSERT INTO deu1912_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Die Länge eines Teppichs soll dreißig Ellen sein, die Breite aber vier Ellen, und sollen alle elf gleich groß sein. ");
INSERT INTO deu1912_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Fünf sollst du aneinander fügen und sechs auch aneinander, daß du den sechsten Teppich zwiefältig machst vorn an der Hütte. ");
INSERT INTO deu1912_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Und sollst an jegliches Stück fünfzig Schleifen machen am Rand, wo die Stücke sollen zusammengeheftet werden. ");
INSERT INTO deu1912_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Und sollst fünfzig eherne Haken machen und die Haken in die Schleifen tun, daß die Hütte zusammengefügt und eine Hütte werde. ");
INSERT INTO deu1912_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Aber vom Überlangen an den Teppichen der Hütte sollst du einen halben Teppich lassen überhangen hinten an der Hütte ");
INSERT INTO deu1912_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","und auf beiden Seiten je eine Elle, daß das Überlange sei an der Hütte Seiten und auf beiden Seiten sie bedecke. ");
INSERT INTO deu1912_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Über diese Decke sollst du eine Decke machen von rötlichen Widderfellen, dazu über sie eine Decke von Dachsfellen. ");
INSERT INTO deu1912_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Du sollst auch Bretter machen zu der Wohnung von Akazienholz, die stehen sollen. ");
INSERT INTO deu1912_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Zehn Ellen lang soll ein Brett sein und anderthalb Ellen breit. ");
INSERT INTO deu1912_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Zwei Zapfen soll ein Brett haben, daß eins an das andere könne gesetzt werden. Also sollst du alle Bretter der Wohnung machen. ");
INSERT INTO deu1912_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ihrer zwanzig sollen stehen gegen Mittag. ");
INSERT INTO deu1912_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Die sollen vierzig silberne Füße unten haben, je zwei Füße unter einem jeglichen Brett an seinen zwei Zapfen. ");
INSERT INTO deu1912_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Also auf der andern Seite gegen Mitternacht sollen auch zwanzig Bretter stehen ");
INSERT INTO deu1912_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","und vierzig silberne Füße, je zwei Füße unter jeglichem Brett. ");
INSERT INTO deu1912_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Aber hinten an der Wohnung gegen Abend sollst du sechs Bretter machen; ");
INSERT INTO deu1912_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","dazu zwei Bretter hinten an die zwei Ecken der Wohnung, ");
INSERT INTO deu1912_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","daß ein jegliches der beiden sich mit seinem Eckbrett von untenauf geselle und oben am Haupt gleich zusammenkomme mit einer Klammer; ");
INSERT INTO deu1912_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","daß es acht Bretter seien mit ihren silbernen Füßen, deren sollen sechzehn sein, je zwei unter einem Brett. ");
INSERT INTO deu1912_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Und sollst Riegel machen von Akazienholz, fünf zu den Brettern auf einer Seite der Wohnung ");
INSERT INTO deu1912_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","und fünf zu den Brettern auf der andern Seite der Wohnung und fünf zu den Brettern hinten an der Wohnung gegen Abend. ");
INSERT INTO deu1912_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Und sollst den mittleren Riegel mitten an den Brettern hindurchstoßen und alles zusammenfassen von einem Ende zu dem andern. ");
INSERT INTO deu1912_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Und sollst die Bretter mit Gold überziehen und ihre Ringe von Gold machen, daß man die Riegel darein tue. ");
INSERT INTO deu1912_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Und die Riegel sollst du mit Gold überziehen. Und also sollst du denn die Wohnung aufrichten nach der Weise, wie du gesehen hast auf dem Berge. ");
INSERT INTO deu1912_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Du sollst einen Vorhang machen von blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand; und sollst Cherubim daran machen von kunstreicher Arbeit. ");
INSERT INTO deu1912_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Und sollst ihn hängen an vier Säulen von Akazienholz, die mit Gold überzogen sind und goldene Haken und vier silberne Füße haben. ");
INSERT INTO deu1912_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Und sollst den Vorhang hängen unter die Haken, und die Lade des Zeugnisses innen hinter den Vorhang setzen, daß er euch eine Scheidewand sei zwischen dem Heiligen und dem Allerheiligsten. ");
INSERT INTO deu1912_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Und sollst den Gnadenstuhl tun auf die Lade des Zeugnisses in dem Allerheiligsten. ");
INSERT INTO deu1912_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Den Tisch aber setze außen vor den Vorhang und den Leuchter dem Tisch gegenüber, mittagswärts in der Wohnung, daß der Tisch stehe gegen Mitternacht. ");
INSERT INTO deu1912_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Und sollst ein Tuch machen in die Tür der Hütte, gewirkt von blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Und sollst dem Tuch fünf Säulen machen von Akazienholz, mit Gold überzogen, mit goldene Haken, und sollst ihnen fünf eherne Füße gießen. ");
INSERT INTO deu1912_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Du sollst einen Altar machen von Akazienholz, fünf Ellen lang und breit, daß er gleich viereckig sei, und drei Ellen hoch. ");
INSERT INTO deu1912_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Hörner sollst du auf seinen vier Ecken machen und sollst ihn mit Erz überziehen. ");
INSERT INTO deu1912_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Mache auch Aschentöpfe, Schaufeln, Becken, Gabeln, Kohlenpfannen; alle seine Geräte sollst du aus Erz machen. ");
INSERT INTO deu1912_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Du sollst auch ein ehernes Gitter machen wie ein Netz und vier eherne Ringe an seine vier Enden. ");
INSERT INTO deu1912_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Du sollst's aber von untenauf um den Altar machen, daß das Gitter reiche bis mitten an den Altar. ");
INSERT INTO deu1912_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Und sollst auch Stangen machen zu dem Altar von Akazienholz, mit Erz überzogen. ");
INSERT INTO deu1912_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Und man soll die Stangen in die Ringe tun, daß die Stangen seien an beiden Seiten des Altars, wenn man ihn trägt. ");
INSERT INTO deu1912_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Und sollst ihn also von Brettern machen, daß er inwendig hohl sei, wie dir auf dem Berge gezeigt ist. ");
INSERT INTO deu1912_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Du sollst auch der Wohnung einen Hof machen, einen Umhang von gezwirnter weißer Leinwand, auf einer Seite hundert Ellen lang, gegen Mittag, ");
INSERT INTO deu1912_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","und zwanzig Säulen auf zwanzig ehernen Füßen, und ihre Haken mit ihren Querstäben von Silber. ");
INSERT INTO deu1912_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Also auch gegen Mitternacht soll sein ein Umhang, hundert Ellen lang, zwanzig Säulen auf zwanzig ehernen Füßen, und ihre Haken mit ihren Querstäben von Silber. ");
INSERT INTO deu1912_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Aber gegen Abend soll die Breite des Hofes haben einen Umhang, fünfzig Ellen lang, zehn Säulen auf zehn Füßen. ");
INSERT INTO deu1912_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Gegen Morgen aber soll die Breite des Hofes haben fünfzig Ellen, ");
INSERT INTO deu1912_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","also daß der Umhang habe auf einer Seite fünfzehn Ellen, dazu drei Säulen auf drei Füßen, ");
INSERT INTO deu1912_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","und wieder fünfzehn Ellen auf der andern Seite, dazu drei Säulen auf drei Füßen; ");
INSERT INTO deu1912_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","aber im Tor des Hofes soll ein Tuch sein, zwanzig Ellen breit, gewirkt von blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand, dazu vier Säulen auf ihren vier Füßen. ");
INSERT INTO deu1912_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Alle Säulen um den Hof her sollen silberne Querstäbe und silberne Haken und eherne Füße haben. ");
INSERT INTO deu1912_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Und die Länge des Hofes soll hundert Ellen sein, die Breite fünfzig Ellen, die Höhe fünf Ellen, von gezwirnter weißer Leinwand, und seine Füße sollen ehern sein. ");
INSERT INTO deu1912_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Auch alle Geräte der Wohnung zu allerlei Amt und alle ihre Nägel und alle Nägel des Hofes sollen ehern sein. ");
INSERT INTO deu1912_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Gebiete den Kindern Israel, daß sie zu dir bringen das allerreinste, lautere Öl von Ölbäumen, gestoßen, zur Leuchte, daß man täglich Lampen aufsetze ");
INSERT INTO deu1912_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","in der Hütte des Stifts, außen vor dem Vorhang, der vor dem Zeugnis hängt. Und Aaron und seine Söhne sollen sie zurichten des Morgens und des Abends vor dem HERRN. Das soll euch eine ewige Weise sein auf eure Nachkommen unter den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Du sollst Aaron, deinen Bruder, und seine Söhne zu dir nehmen aus den Kindern Israel, daß er mein Priester sei, nämlich Aaron und seine Söhne Nadab, Abihu, Eleasar und Ithamar. ");
INSERT INTO deu1912_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Und sollst Aaron, deinen Bruder, heilige Kleider machen, die herrlich und schön seien. ");
INSERT INTO deu1912_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Und du sollst reden mit allen, die eines weisen Herzens sind, die ich mit dem Geist der Weisheit erfüllt habe, daß sie Aaron Kleider machen zu seiner Weihe, daß er mein Priester sei. ");
INSERT INTO deu1912_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Das sind aber die Kleider, die sie machen sollen: das Amtschild, den Leibrock, Purpurrock, engen Rock, Hut und Gürtel. Also sollen sie heilige Kleider machen deinem Bruder Aaron und seinen Söhnen, daß er mein Priester sei. ");
INSERT INTO deu1912_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Dazu sollen sie nehmen Gold, blauen und roten Purpur, Scharlach und weiße Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Den Leibrock sollen sie machen von Gold, blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand, kunstreich; ");
INSERT INTO deu1912_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","zwei Schulterstücke soll er haben, die zusammengehen an beiden Enden, und soll zusammengebunden werden. ");
INSERT INTO deu1912_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Und sein Gurt darauf soll derselben Kunst und Arbeit sein, von Gold, blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Und sollst zwei Onyxsteine nehmen und darauf graben die Namen der Kinder Israel, ");
INSERT INTO deu1912_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Auf jeglichen sechs Namen, nach der Ordnung ihres Alters. ");
INSERT INTO deu1912_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Das sollst du tun durch die Steinschneider, die da Siegel graben, also daß sie mit Gold umher gefaßt werden. ");
INSERT INTO deu1912_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Und sollst sie auf die Schulterstücke des Leibrocks heften, daß es Steine seien zum Gedächtnis für die Kinder Israel, daß Aaron ihre Namen auf seinen beiden Schultern trage vor dem HERRN zum Gedächtnis. ");
INSERT INTO deu1912_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Und sollst goldene Fassungen machen ");
INSERT INTO deu1912_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","und zwei Ketten von feinem Golde, mit zwei Enden, aber die Glieder ineinander hangend; und sollst sie an die Fassungen tun. ");
INSERT INTO deu1912_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Das Amtschild sollst du machen nach der Kunst, wie den Leibrock, von Gold, blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Viereckig soll es sein und zwiefach; eine Spanne breit soll seine Länge sein und eine Spanne breit seine Breite. ");
INSERT INTO deu1912_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Und sollst's füllen die vier Reihen voll Steine. Die erste Reihe sei ein Sarder, Topas, Smaragd; ");
INSERT INTO deu1912_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","die andere ein Rubin, Saphir, Demant; ");
INSERT INTO deu1912_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","die dritte ein Lynkurer, Achat, Amethyst; ");
INSERT INTO deu1912_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","die vierte ein Türkis, Onyx, Jaspis. In Gold sollen sie gefaßt sein in allen Reihen ");
INSERT INTO deu1912_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","und sollen nach den zwölf Namen der Kinder Israel stehen, gegraben vom Steinschneider, daß auf einem jeglichen ein Namen stehe nach den zwölf Stämmen. ");
INSERT INTO deu1912_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Und sollst Ketten zu dem Schild machen mit zwei Enden, aber die Glieder ineinander hangend, von feinem Golde, ");
INSERT INTO deu1912_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","und zwei goldene Ringe an das Schild, also daß du die zwei Ringe heftest an zwei Ecken des Schildes, ");
INSERT INTO deu1912_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","und die zwei goldenen Ketten in die zwei Ringe an den beiden Ecken des Schildes tust. ");
INSERT INTO deu1912_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Aber die zwei Enden der zwei Ketten sollst du an die zwei Fassungen tun und sie heften auf die Schulterstücke am Leibrock vornehin. ");
INSERT INTO deu1912_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Und sollst zwei andere goldene Ringe machen und an die zwei Ecken des Schildes heften an seinem Rand, inwendig gegen den Leibrock. ");
INSERT INTO deu1912_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Und sollst abermals zwei goldene Ringe machen und sie unten an die zwei Schulterstücke vorn am Leibrock heften, wo der Leibrock zusammengeht, oben über dem Gurt des Leibrocks. ");
INSERT INTO deu1912_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Und man soll das Schild mit seinen Ringen mit einer blauen Schnur an die Ringe des Leibrocks knüpfen, daß es über dem Gurt des Leibrocks hart anliege und das Schild sich nicht vom Leibrock losmache. ");
INSERT INTO deu1912_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Also soll Aaron die Namen der Kinder Israel tragen in dem Amtschild auf seinem Herzen, wenn er in das Heilige geht, zum Gedächtnis vor dem HERRN allezeit. ");
INSERT INTO deu1912_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Und sollst in das Amtschild tun Licht und Recht, daß sie auf dem Herzen Aarons seien, wenn er eingeht vor den HERRN, daß er trage das Amt der Kinder Israel auf seinem Herzen vor dem HERRN allewege. ");
INSERT INTO deu1912_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Du sollst auch einen Purpurrock unter dem Leibrock machen ganz von blauem Purpur. ");
INSERT INTO deu1912_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Und oben mitteninne soll ein Loch sein und eine Borte um das Loch her zusammengefaltet, daß er nicht zerreiße. ");
INSERT INTO deu1912_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Und unten an seinen Saum sollst du Granatäpfel machen von blauem und rotem Purpur und Scharlach um und um und zwischen dieselben goldene Schellen auch um und um, ");
INSERT INTO deu1912_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","daß eine goldene Schelle sei, darnach ein Granatapfel und wieder eine goldene Schelle und wieder ein Granatapfel, um und um an dem Saum des Purpurrocks. ");
INSERT INTO deu1912_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Und Aaron soll ihn anhaben, wenn er dient, daß man seinen Klang höre, wenn er aus und eingeht in das Heilige vor dem HERRN, auf daß er nicht sterbe. ");
INSERT INTO deu1912_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Du sollst auch ein Stirnblatt machen von feinem Golde und darauf ausgraben, wie man die Siegel ausgräbt: Heilig dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Und sollst's heften an eine blaue Schnur vorn an den Hut, ");
INSERT INTO deu1912_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","auf der Stirn Aarons, daß also Aaron trage die Missetat des Heiligen, das die Kinder Israel heiligen in allen Gaben ihrer Heiligung; und es soll allewege an seiner Stirn sein, daß er sie versöhne vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Du sollst auch einen engen Rock machen von weißer Leinwand und einen Hut von weißer Leinwand machen und einen gestickten Gürtel. ");
INSERT INTO deu1912_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Und den Söhnen Aarons sollst du Röcke, Gürtel und Hauben machen, die herrlich und schön seien. ");
INSERT INTO deu1912_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Und sollst sie deinem Bruder Aaron samt seinen Söhnen anziehen; und sollst sie salben und ihre Hände füllen und sie weihen, daß sie meine Priester seien. ");
INSERT INTO deu1912_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Und sollst ihnen leinene Beinkleider machen, zu bedecken die Blöße des Fleisches von den Lenden bis an die Hüften. ");
INSERT INTO deu1912_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Und Aaron und seine Söhne sollen sie anhaben, wenn sie in die Hütte des Stifts gehen oder hinzutreten zum Altar, daß sie dienen in dem Heiligtum, daß sie nicht ihre Missetat tragen und sterben müssen. Das soll ihm und seinem Stamm nach ihm eine ewige Weise sein. ");
INSERT INTO deu1912_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Das ist's auch, was du ihnen tun sollst, daß sie mir zu Priestern geweiht werden. Nimm einen jungen Farren und zwei Widder ohne Fehl, ");
INSERT INTO deu1912_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ungesäuertes Brot und ungesäuerte Kuchen, mit Öl gemengt, und ungesäuerte Fladen, mit Öl gesalbt; von Weizenmehl sollst du solches alles machen. ");
INSERT INTO deu1912_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Und sollst es in einen Korb legen und in dem Korbe herzubringen samt dem Farren und den zwei Widdern. ");
INSERT INTO deu1912_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Und sollst Aaron und seine Söhne vor die Tür der Hütte des Stifts führen und mit Wasser waschen ");
INSERT INTO deu1912_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","und die Kleider nehmen und Aaron anziehen den engen Rock und den Purpurrock und den Leibrock und das Schild zu dem Leibrock, und sollst ihn gürten mit dem Gurt des Leibrocks ");
INSERT INTO deu1912_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","und den Hut auf sein Haupt setzen und die heilige Krone an den Hut. ");
INSERT INTO deu1912_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Und sollst nehmen das Salböl und auf sein Haupt schütten und ihn salben. ");
INSERT INTO deu1912_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Und seine Söhne sollst du auch herzuführen und den engen Rock ihnen anziehen ");
INSERT INTO deu1912_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","und beide, Aaron und auch sie, mit Gürteln gürten und ihnen die Hauben aufbinden, daß sie das Priestertum haben zu ewiger Weise. Und sollst Aaron und seinen Söhnen die Hände füllen, ");
INSERT INTO deu1912_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","und den Farren herzuführen vor die Hütte des Stifts; und Aaron und seine Söhne sollen ihre Hände auf des Farren Haupt legen. ");
INSERT INTO deu1912_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Und du sollst den Farren schlachten vor dem HERRN, vor der Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Und sollst von seinem Blut nehmen und auf des Altars Hörner tun mit deinem Finger und alles andere Blut an des Altars Boden schütten. ");
INSERT INTO deu1912_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Und sollst alles Fett nehmen am Eingeweide und das Netz über der Leber und die zwei Nieren mit dem Fett, das darüber liegt, und sollst es auf dem Altar anzünden. ");
INSERT INTO deu1912_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Aber des Farren Fleisch, Fell und Mist sollst du draußen vor dem Lager verbrennen; denn es ist ein Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Aber den einen Widder sollst du nehmen, und Aaron und seine Söhne sollen ihre Hände auf sein Haupt legen. ");
INSERT INTO deu1912_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Dann sollst du ihn schlachten und sein Blut nehmen und auf den Altar sprengen ringsherum. ");
INSERT INTO deu1912_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Aber den Widder sollst du zerlegen in Stücke, und seine Eingeweide und Schenkel waschen, und sollst es auf seine Stücke und sein Haupt legen ");
INSERT INTO deu1912_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","und den ganzen Widder anzünden auf dem Altar; denn es ist dem HERRN ein Brandopfer, ein süßer Geruch, ein Feuer des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Den andern Widder aber sollst du nehmen, und Aaron und seine Söhne sollen ihre Hände auf sein Haupt legen; ");
INSERT INTO deu1912_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","und sollst ihn schlachten und von seinem Blut nehmen und Aaron und seinen Söhnen auf den rechten Ohrknorpel tun und auf ihre Daumen ihrer rechten Hand und auf die große Zehe ihres rechten Fußes; und sollst das Blut auf den Altar sprengen ringsherum. ");
INSERT INTO deu1912_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Und sollst von dem Blut auf dem Altar nehmen und vom Salböl, und Aaron und seine Kleider, seine Söhne und ihre Kleider besprengen; so wird er und seine Kleider, seine Söhne und ihre Kleider geweiht. ");
INSERT INTO deu1912_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Darnach sollst du nehmen das Fett von dem Widder, den Schwanz und das Fett am Eingeweide, das Netz über der Leber und die zwei Nieren mit dem Fett darüber und die rechte Schulter (denn es ist ein Widder der Füllung), ");
INSERT INTO deu1912_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","und ein Brot und einen Ölkuchen und einen Fladen aus dem Korbe des ungesäuerten Brots, der vor dem HERRN steht; ");
INSERT INTO deu1912_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","und lege alles auf die Hände Aarons und seiner Söhne und webe es dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Darnach nimm's von ihren Händen und zünde es an auf dem Altar zu dem Brandopfer, zum süßen Geruch vor dem HERRN; denn das ist ein Feuer des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Und sollst die Brust nehmen vom Widder der Füllung Aarons und sollst sie dem HERRN weben. Das soll dein Teil sein. ");
INSERT INTO deu1912_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Und sollst also heiligen die Webebrust und die Hebeschulter, die gewebt und gehebt sind von dem Widder der Füllung Aarons und seiner Söhne. ");
INSERT INTO deu1912_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Und das soll Aarons und seiner Söhne sein ewigerweise von den Kindern Israel; denn es ist ein Hebopfer. Und eine Hebe soll es sein, von den Kindern Israel von ihrem Dankopfern, ihre Hebe für den HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aber die heiligen Kleider Aarons sollen seine Söhne haben nach ihm, daß sie darin gesalbt und ihre Hände gefüllt werden. ");
INSERT INTO deu1912_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Welcher unter seinen Söhnen an seiner Statt Priester wird, der soll sie sieben Tage anziehen, daß er gehe in die Hütte des Stifts, zu dienen im Heiligen. ");
INSERT INTO deu1912_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Du sollst aber nehmen den Widder der Füllung, und sein Fleisch an einem heiligen Ort kochen. ");
INSERT INTO deu1912_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Und Aaron mit seinen Söhnen soll des Widders Fleisch essen samt dem Brot im Korbe vor der Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Denn es ist zur Versöhnung damit geschehen, zu füllen ihre Hände, daß sie geweiht werden. Kein andrer soll es essen; denn es ist heilig. ");
INSERT INTO deu1912_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Wo aber etwas übrigbleibt von dem Fleisch der Füllung und von dem Brot bis an den Morgen, das sollst du mit Feuer verbrennen und nicht essen lassen; denn es ist heilig. ");
INSERT INTO deu1912_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Und sollst also mit Aaron und seinen Söhnen tun alles, was ich dir geboten habe. Sieben Tage sollst du ihre Hände füllen ");
INSERT INTO deu1912_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","und täglich einen Farren zum Sündopfer schlachten zur Versöhnung. Und sollst den Altar entsündigen, wenn du ihn versöhnst, und sollst ihn salben, daß er geweiht werde. ");
INSERT INTO deu1912_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sieben Tage sollst du den Altar versöhnen und ihn weihen, daß er sei ein Hochheiliges. Wer den Altar anrühren will, der ist dem Heiligtum verfallen. ");
INSERT INTO deu1912_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Und das sollst du mit dem Altar tun: zwei jährige Lämmer sollst du allewege des Tages darauf opfern, ");
INSERT INTO deu1912_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ein Lamm des Morgens, das andere gegen Abend; ");
INSERT INTO deu1912_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Und zu einem Lamm ein zehntel Semmelmehl, gemengt mit einem Viertel von einem Hin gestoßenen Öls, und ein Viertel vom Hin Wein zum Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Mit dem andern Lamm gegen Abend sollst du tun wie mit dem Speisopfer und Trankopfer des Morgens, zu süßem Geruch, ein Feuer dem Herrn. ");
INSERT INTO deu1912_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Das ist das tägliche Brandopfer bei euren Nachkommen vor der Tür der Hütte des Stifts, vor dem HERRN, da ich mich euch bezeugen und mit dir reden will. ");
INSERT INTO deu1912_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Daselbst will ich mich den Kindern Israel bezeugen und geheiligt werden in meiner Herrlichkeit. ");
INSERT INTO deu1912_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","So will ich die Hütte des Stifts mit dem Altar heiligen und Aaron und seine Söhne mir zu Priestern weihen. ");
INSERT INTO deu1912_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Und will unter den Kindern Israel wohnen und ihr Gott sein, ");
INSERT INTO deu1912_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","daß sie wissen sollen, ich sei der HERR, ihr Gott, der sie aus Ägyptenland führte, daß ich unter ihnen wohne, ich, der HERR, Ihr Gott. ");
INSERT INTO deu1912_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Du sollst auch einen Räuchaltar machen, zu räuchern, von Akazienholz, ");
INSERT INTO deu1912_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","eine Elle lang und breit, gleich viereckig und zwei Ellen hoch, mit seinen Hörnern. ");
INSERT INTO deu1912_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Und sollst ihn mit feinem Golde überziehen, sein Dach und seine Wände ringsumher und seine Hörner. Und sollst einen Kranz von Gold machen ");
INSERT INTO deu1912_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","und zwei goldene Ringe unter dem Kranz zu beiden Seiten, daß man Stangen darein tue und ihn damit trage. ");
INSERT INTO deu1912_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Die Stangen sollst du auch von Akazienholz machen und mit Gold überziehen. ");
INSERT INTO deu1912_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Und sollst ihn setzen vor den Vorhang, der vor der Lade des Zeugnisses hängt, und vor dem Gnadenstuhl, der auf dem Zeugnis ist, wo ich mich dir bezeugen werde. ");
INSERT INTO deu1912_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Und Aaron soll darauf räuchern gutes Räuchwerk alle Morgen, wenn er die Lampen zurichtet. ");
INSERT INTO deu1912_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Desgleichen, wenn er die Lampen anzündet gegen Abend, soll er solch Räuchwerk auch räuchern. Das soll das tägliche Räuchopfer sein vor dem HERRN bei euren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ihr sollt kein fremdes Räuchwerk darauf tun, auch kein Brandopfer noch Speisopfer und kein Trankopfer darauf opfern. ");
INSERT INTO deu1912_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Und Aaron soll auf seinen Hörnern versöhnen einmal im Jahr mit dem Blut des Sündopfers zur Versöhnung. Solche Versöhnung soll jährlich einmal geschehen bei euren Nachkommen; denn das ist dem HERRN ein Hochheiliges. ");
INSERT INTO deu1912_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Wenn du die Häupter der Kinder Israel zählst, so soll ein jeglicher dem HERRN geben die Versöhnung seiner Seele, auf daß ihnen nicht eine Plage widerfahre, wenn sie gezählt werden. ");
INSERT INTO deu1912_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Es soll aber ein jeglicher, der in der Zahl ist, einen halben Silberling geben nach dem Lot des Heiligtums (ein Lot hat zwanzig Gera). Solcher halber Silberling soll das Hebopfer des HERRN sein. ");
INSERT INTO deu1912_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Wer in der Zahl ist von zwanzig Jahren und darüber, der soll solch Hebopfer dem HERRN geben. ");
INSERT INTO deu1912_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Der Reiche soll nicht mehr geben und der Arme nicht weniger als den halben Silberling, den man dem HERRN zur Hebe gibt für die Versöhnung ihre Seelen. ");
INSERT INTO deu1912_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Und du sollst solch Geld der Versöhnung nehmen von den Kindern Israel und zum Gottesdienst der Hütte des Stifts geben, daß es sei den Kindern Israel ein Gedächtnis vor dem HERRN, daß er sich Über ihre Seelen versöhnen lasse. ");
INSERT INTO deu1912_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Du sollst auch ein ehernes Handfaß machen mit einem ehernen Fuß, zum Waschen, und sollst es setzen zwischen die Hütte des Stifts und den Altar, und Wasser darein tun, ");
INSERT INTO deu1912_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","daß Aaron und seine Söhne ihre Hände und Füße darin waschen, ");
INSERT INTO deu1912_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","wenn sie in die Hütte des Stifts gehen oder zum Altar, daß sie dienen, ein Feuer anzuzünden dem HERRN, ");
INSERT INTO deu1912_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","auf daß sie nicht sterben. Das soll eine ewige Weise sein ihm und seinem Samen bei ihren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Nimm zu dir die beste Spezerei: die edelste Myrrhe, fünfhundert Lot, und Zimt, die Hälfte soviel, zweihundertfünfzig, und Kalmus, auch zweihundertfünfzig, ");
INSERT INTO deu1912_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","und Kassia, fünfhundert, nach dem Lot des Heiligtums, und Öl vom Ölbaum ein Hin. ");
INSERT INTO deu1912_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Und mache ein heiliges Salböl nach der Kunst des Salbenbereiters. ");
INSERT INTO deu1912_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Und sollst damit salben die Hütte des Stifts und die Lade des Zeugnisses, ");
INSERT INTO deu1912_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","den Tisch mit allem seinem Geräte, den Leuchter mit seinem Geräte, den Räucheraltar, ");
INSERT INTO deu1912_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","den Brandopferaltar mit allem seinem Geräte und das Handfaß mit seinem Fuß. ");
INSERT INTO deu1912_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Und sollst sie also weihen, daß sie hochheilig seien; denn wer sie anrühren will, der ist dem Heiligtum verfallen. ");
INSERT INTO deu1912_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aaron und seine Söhne sollst du auch salben und sie mir zu Priestern weihen. ");
INSERT INTO deu1912_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Und sollst mit den Kindern Israel reden und sprechen: Dies Öl soll mir eine heilige Salbe sein bei euren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Auf Menschenleib soll's nicht gegossen werden, sollst auch seinesgleichen nicht machen; denn es ist heilig, darum soll's euch heilig sein. ");
INSERT INTO deu1912_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Wer ein solches macht oder einem andern davon gibt, der soll von seinem Volk ausgerottet werden. ");
INSERT INTO deu1912_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Und der HERR sprach zu Mose: Nimm dir Spezerei; Balsam, Stakte, Galban und reinen Weihrauch, von einem so viel wie vom andern, ");
INSERT INTO deu1912_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","und mache Räuchwerk daraus, nach der Kunst des Salbenbereiters gemengt, daß es rein und heilig sei. ");
INSERT INTO deu1912_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Und du sollst es zu Pulver stoßen und sollst davon tun vor das Zeugnis in der Hütte des Stifts, wo ich mich dir bezeugen werde. Das soll euch ein Hochheiliges sein. ");
INSERT INTO deu1912_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Und desgleichen Räuchwerk sollt ihr euch nicht machen, sondern es soll dir heilig sein dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Wer ein solches machen wird, der wird ausgerottet werden von seinem Volk. ");
INSERT INTO deu1912_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Siehe, ich habe mit Namen berufen Bezaleel, den Sohn Uris, des Sohnes Hur, vom Stamme Juda, ");
INSERT INTO deu1912_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","und habe ihn erfüllt mit dem Geist Gottes, mit Weisheit und Verstand und Erkenntnis und mit allerlei Geschicklichkeit, ");
INSERT INTO deu1912_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","kunstreich zu arbeiten an Gold, Silber, Erz, ");
INSERT INTO deu1912_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kunstreich Steine zu schneiden und einzusetzen, und kunstreich zu zimmern am Holz, zu machen allerlei Werk. ");
INSERT INTO deu1912_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Und siehe, ich habe ihm zugegeben Oholiab, den Sohn Ahisamachs, vom Stamme Dan; und habe allerlei Weisen die Weisheit ins Herz gegeben, daß sie machen sollen alles, was ich dir geboten habe: ");
INSERT INTO deu1912_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","die Hütte des Stifts, die Lade des Zeugnisses, den Gnadenstuhl darauf und alle Geräte der Hütte, ");
INSERT INTO deu1912_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","den Tisch und sein Gerät, den feinen Leuchter und all sein Gerät, den Räucheraltar, ");
INSERT INTO deu1912_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","den Brandopferaltar mit allem seinem Geräte, das Handfaß mit seinem Fuß, ");
INSERT INTO deu1912_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","die Amtskleider und die heiligen Kleider des Priesters Aaron und die Kleider seiner Söhne, priesterlich zu dienen, ");
INSERT INTO deu1912_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","das Salböl und das Räuchwerk von Spezerei zum Heiligtum. Alles, was ich dir geboten habe, werden sie machen. ");
INSERT INTO deu1912_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Sage den Kindern Israel und sprich: Haltet meinen Sabbat; denn derselbe ist ein Zeichen zwischen mir und euch auf eure Nachkommen, daß ihr wisset, daß ich der HERR bin, der euch heiligt. ");
INSERT INTO deu1912_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Darum so haltet meinen Sabbat; denn er soll euch heilig sein. Wer ihn entheiligt, der soll des Todes sterben. Denn wer eine Arbeit da tut, des Seele soll ausgerottet werden von seinem Volk. ");
INSERT INTO deu1912_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sechs Tage soll man arbeiten; aber am siebenten Tag ist Sabbat, die heilige Ruhe des HERRN. Wer eine Arbeit tut am Sabbattag, der soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Darum sollen die Kinder Israel den Sabbat halten, daß sie ihn auch bei ihren Nachkommen halten zum ewigen Bund. ");
INSERT INTO deu1912_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Er ist ein ewiges Zeichen zwischen mir und den Kindern Israel. Denn in sechs Tagen machte der HERR Himmel und Erde; aber am siebenten Tage ruhte er und erquickte sich. ");
INSERT INTO deu1912_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Und da der HERR ausgeredet hatte mit Mose auf dem Berge Sinai, gab er ihm zwei Tafeln des Zeugnisses; die waren beschrieben mit dem Finger Gottes. ");
INSERT INTO deu1912_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Da aber das Volk sah, daß Mose verzog, von dem Berge zu kommen, sammelte sich's wider Aaron und sprach zu ihm: Auf, mache uns Götter, die vor uns her gehen! Denn wir wissen nicht, was diesem Mann Mose widerfahren ist, der uns aus Ägyptenland geführt hat. ");
INSERT INTO deu1912_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron sprach zu ihnen: Reißt ab die goldenen Ohrenringe an den Ohren eurer Weiber, eurer Söhne und eurer Töchter und bringet sie zu mir. ");
INSERT INTO deu1912_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Da riß alles Volk seine goldenen Ohrenringe von ihren Ohren, und brachten sie zu Aaron. ");
INSERT INTO deu1912_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Und er nahm sie von ihren Händen und entwarf's mit einem Griffel und machte ein gegossenes Kalb. Und sie sprachen: Das sind deine Götter, Israel, die dich aus Ägyptenland geführt haben! ");
INSERT INTO deu1912_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Da das Aaron sah, baute er einen Altar vor ihm und ließ ausrufen und sprach: Morgen ist des HERRN Fest. ");
INSERT INTO deu1912_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Und sie standen des Morgens früh auf und opferten Brandopfer und brachten dazu Dankopfer. Darnach setzte sich das Volk, zu essen und zu trinken, und standen auf zu spielen. ");
INSERT INTO deu1912_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Der HERR aber sprach zu Mose: Gehe, steig hinab; denn dein Volk, das du aus Ägyptenland geführt hast, hat's verderbt. ");
INSERT INTO deu1912_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Sie sind schnell von dem Wege getreten, den ich ihnen geboten habe. Sie haben sich ein gegossenes Kalb gemacht und haben's angebetet und ihm geopfert und gesagt: Das sind deine Götter, Israel, die dich aus Ägyptenland geführt haben. ");
INSERT INTO deu1912_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Und der HERR sprach zu Mose: Ich sehe, daß es ein halsstarriges Volk ist. ");
INSERT INTO deu1912_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Und nun laß mich, daß mein Zorn über sie ergrimme und sie vertilge; so will ich dich zum großen Volk machen. ");
INSERT INTO deu1912_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mose aber flehte vor dem HERRN, seinem Gott, und sprach: Ach HERR, warum will dein Zorn ergrimmen über dein Volk, das du mit großer Kraft und starker Hand hast aus Ägyptenland geführt? ");
INSERT INTO deu1912_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Warum sollen die Ägypter sagen und sprechen: Er hat sie zu ihrem Unglück ausgeführt, daß er sie erwürgte im Gebirge und vertilgte vom Erdboden? Kehre dich von dem Grimm deines Zornes und laß dich gereuen des Übels über dein Volk. ");
INSERT INTO deu1912_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Gedenke an deine Diener Abraham, Isaak und Israel, denen du bei dir selbst geschworen und verheißen hast: Ich will euren Samen mehren wie die Sterne am Himmel, und alles Land, das ich euch verheißen habe, will ich eurem Samen geben, und sie sollen's besitzen ewiglich. ");
INSERT INTO deu1912_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Also gereute den HERRN das Übel, das er drohte seinem Volk zu tun. ");
INSERT INTO deu1912_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose wandte sich und stieg vom Berge und hatte zwei Tafeln des Zeugnisses in seiner Hand, die waren beschrieben auf beiden Seiten. ");
INSERT INTO deu1912_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Und Gott hatte sie selbst gemacht und selber die Schrift eingegraben. ");
INSERT INTO deu1912_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Da nun Josua hörte des Volks Geschrei, daß sie jauchzten, sprach er zu Mose: Es ist ein Geschrei im Lager wie im Streit. ");
INSERT INTO deu1912_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Er antwortete: Es ist nicht ein Geschrei gegeneinander derer, die obliegen und unterliegen, sondern ich höre ein Geschrei eines Singetanzes. ");
INSERT INTO deu1912_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Als er aber nahe zum Lager kam und das Kalb und den Reigen sah, ergrimmte er mit Zorn und warf die Tafeln aus seiner Hand und zerbrach sie unten am Berge ");
INSERT INTO deu1912_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","und nahm das Kalb, das sie gemacht hatten, und zerschmelzte es mit Feuer und zermalmte es zu Pulver und stäubte es aufs Wasser und gab's den Kindern Israel zu trinken ");
INSERT INTO deu1912_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","und sprach zu Aaron: Was hat dir das Volk getan, daß du eine so große Sünde über sie gebracht hast? ");
INSERT INTO deu1912_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron sprach: Mein Herr lasse seinen Zorn nicht ergrimmen. Du weißt, daß dies Volk böse ist. ");
INSERT INTO deu1912_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Sie sprachen zu mir: Mache uns Götter, die vor uns her gehen; denn wir wissen nicht, wie es diesem Manne Mose geht, der uns aus Ägyptenland geführt hat. ");
INSERT INTO deu1912_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ich sprach zu ihnen: Wer Gold hat, der reiß es ab und gebe es mir. Und ich warf's ins Feuer; daraus ist das Kalb geworden. ");
INSERT INTO deu1912_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Da nun Mose sah, daß das Volk zuchtlos geworden war (denn Aaron hatte sie zuchtlos gemacht, zum Geschwätz bei ihren Widersachern), ");
INSERT INTO deu1912_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","trat er an das Tor des Lagers und sprach: Her zu mir, wer dem HERRN angehört! Da sammelten sich zu ihm alle Kinder Levi. ");
INSERT INTO deu1912_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Und er sprach zu ihnen: So spricht der HERR, der Gott Israels: Gürte ein jeglicher sein Schwert um seine Lenden und durchgehet hin und zurück von einem Tor zum andern das Lager, und erwürge ein jeglicher seinen Bruder, Freund und Nächsten. ");
INSERT INTO deu1912_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Die Kinder Levi taten, wie ihnen Mose gesagt hatte; und fielen des Tages vom Volk dreitausend Mann. ");
INSERT INTO deu1912_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Da sprach Mose: Füllet heute eure Hände dem HERRN, ein jeglicher an seinem Sohn und Bruder, daß heute über euch der Segen gegeben werde. ");
INSERT INTO deu1912_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Des Morgens sprach Mose zum Volk: Ihr habt eine große Sünde getan; nun will ich hinaufsteigen zu dem HERRN, ob ich vielleicht eure Sünde versöhnen möge. ");
INSERT INTO deu1912_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Als nun Mose wieder zum HERRN kam, sprach er: Ach, das Volk hat eine große Sünde getan, und sie haben sich goldene Götter gemacht. ");
INSERT INTO deu1912_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nun vergib ihnen ihre Sünde; wo nicht, so tilge mich auch aus deinem Buch, das du geschrieben hast. ");
INSERT INTO deu1912_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Der HERR sprach zu Mose: Was? Ich will den aus meinem Buch tilgen, der an mir sündigt. ");
INSERT INTO deu1912_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","So gehe nun hin und führe das Volk, dahin ich dir gesagt habe. Siehe, mein Engel soll vor dir her gehen. Ich werde ihre Sünde wohl heimsuchen, wenn meine Zeit kommt heimzusuchen. ");
INSERT INTO deu1912_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Also strafte der HERR das Volk, daß sie das Kalb hatten gemacht, welches Aaron gemacht hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Der HERR sprach zu Mose: Gehe, ziehe von dannen, du und das Volk, das du aus Ägyptenland geführt hast, in das Land, das ich Abraham, Isaak und Jakob geschworen habe und gesagt: Deinem Samen will ich's geben; ");
INSERT INTO deu1912_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","und ich will vor dir her senden einen Engel und ausstoßen die Kanaaniter, Amoriter, Hethiter, Pheresiter, Heviter und Jebusiter, ");
INSERT INTO deu1912_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","dich zu bringen in das Land, darin Milch und Honig fließt. Ich will nicht mit dir hinaufziehen, denn du bist ein halsstarriges Volk; ich möchte dich unterwegs vertilgen. ");
INSERT INTO deu1912_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Da das Volk diese böse Rede hörte, trugen sie Leid, und niemand trug seinen Schmuck an sich. ");
INSERT INTO deu1912_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Und der HERR sprach zu Mose: Sage zu den Kindern Israel: Ihr seid ein halsstarriges Volk. Wo ich nur einen Augenblick mit dir hinaufzöge, würde ich dich vertilgen. Und nun lege deinen Schmuck von dir, daß ich wisse, was ich dir tun soll. ");
INSERT INTO deu1912_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Also taten die Kinder Israel ihren Schmuck von sich vor dem Berge Horeb. ");
INSERT INTO deu1912_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose aber nahm die Hütte und schlug sie auf draußen, ferne vom Lager, und hieß sie eine Hütte des Stifts. Und wer den HERRN fragen wollte, mußte herausgehen zur Hütte des Stifts vor das Lager. ");
INSERT INTO deu1912_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Und wenn Mose ausging zur Hütte so stand alles Volk auf und trat ein jeglicher in seiner Hütte Tür und sahen ihm nach, bis er in die Hütte kam. ");
INSERT INTO deu1912_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Und wenn Mose in die Hütte kam, so kam die Wolkensäule hernieder und stand in der Hütte Tür und redete mit Mose. ");
INSERT INTO deu1912_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Und alles Volk sah die Wolkensäule in der Hütte Tür stehen, und standen auf und neigten sich, ein jeglicher in seiner Hütte Tür. ");
INSERT INTO deu1912_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Der HERR aber redete mit Mose von Angesicht zu Angesicht, wie ein Mann mit seinem Freunde redet. Und wenn er wiederkehrte zum Lager, so wich sein Diener Josua, der Sohn Nuns, der Jüngling, nicht aus der Hütte. ");
INSERT INTO deu1912_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Und Mose sprach zu dem HERRN: Siehe, du sprichst zu mir: Führe das Volk hinauf! und läßt mich nicht wissen, wen du mit mir senden willst, so du doch gesagt hast: Ich kenne dich mit Namen, und du hast Gnade vor meinen Augen gefunden. ");
INSERT INTO deu1912_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Habe ich denn Gnade vor deinen Augen gefunden, so laß mich deinen Weg wissen, damit ich dich kenne und Gnade vor deinen Augen finde. Und siehe doch, daß dies Volk dein Volk ist. ");
INSERT INTO deu1912_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Er sprach: Mein Angesicht soll vorangehen; damit will ich dich leiten. ");
INSERT INTO deu1912_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Er aber sprach zu ihm: Wo nicht dein Angesicht vorangeht, so führe uns nicht von dannen hinauf. ");
INSERT INTO deu1912_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Denn wobei soll doch erkannt werden, daß ich und dein Volk vor deinen Augen Gnade gefunden haben, außer wenn du mit uns gehst, auf daß ich und dein Volk gerühmt werden vor allem Volk, das auf dem Erdboden ist? ");
INSERT INTO deu1912_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Der HERR sprach zu Mose: Was du jetzt geredet hast, will ich auch tun; denn du hast Gnade vor meinen Augen gefunden, und ich kenne dich mit Namen. ");
INSERT INTO deu1912_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Er aber sprach: So laß mich deine Herrlichkeit sehen. ");
INSERT INTO deu1912_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Und er sprach: Ich will vor deinem Angesicht alle meine Güte vorübergehen lassen und will ausrufen des HERRN Namen vor dir. Wem ich aber gnädig bin, dem bin ich gnädig; und wes ich mich erbarme, des erbarme ich mich. ");
INSERT INTO deu1912_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Und sprach weiter: Mein Angesicht kannst du nicht sehen; denn kein Mensch wird leben, der mich sieht. ");
INSERT INTO deu1912_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Und der HERR sprach weiter: Siehe, es ist ein Raum bei mir; da sollst du auf dem Fels stehen. ");
INSERT INTO deu1912_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Wenn denn nun meine Herrlichkeit vorübergeht, will ich dich in der Felskluft lassen stehen und meine Hand ob dir halten, bis ich vorübergehe. ");
INSERT INTO deu1912_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Und wenn ich meine Hand von dir tue, wirst du mir hintennach sehen; aber mein Angesicht kann man nicht sehen. ");
INSERT INTO deu1912_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Und der HERR sprach zu Mose: Haue dir zwei steinerne Tafeln, wie die ersten waren, daß ich die Worte darauf schreibe, die auf den ersten Tafeln waren, welche du zerbrochen hast. ");
INSERT INTO deu1912_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Und sei morgen bereit, daß du früh auf den Berg Sinai steigest und daselbst zu mir tretest auf des Berges Spitze. ");
INSERT INTO deu1912_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Und laß niemand mit dir hinaufsteigen, daß niemand gesehen werde um den ganzen Berg her; auch kein Schaf noch Rind laß weiden gegen diesen Berg hin. ");
INSERT INTO deu1912_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Und Mose hieb zwei steinerne Tafeln, wie die ersten waren, und stand des Morgens früh auf und stieg auf den Berg Sinai, wie ihm der HERR geboten hatte, und nahm die zwei steinernen Tafeln in seine Hand. ");
INSERT INTO deu1912_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Da kam der HERR hernieder in einer Wolke und trat daselbst zu ihm und rief aus des HERRN Namen. ");
INSERT INTO deu1912_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Und der HERR ging vor seinem Angesicht vorüber und rief: HERR, HERR, GOTT, barmherzig und gnädig und geduldig und von großer Gnade und Treue! ");
INSERT INTO deu1912_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","der da bewahrt Gnade in tausend Glieder und vergibt Missetat, Übertretung und Sünde, und vor welchem niemand unschuldig ist; der die Missetat der Väter heimsucht auf Kinder und Kindeskinder bis ins dritte und vierte Glied. ");
INSERT INTO deu1912_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Und Mose neigte sich eilend zu der Erde und betete an ");
INSERT INTO deu1912_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","und sprach: Habe ich, Herr, Gnade vor deinen Augen gefunden, so gehe der Herr mit uns; denn es ist ein halstarriges Volk, daß du unsrer Missetat und Sünde gnädig seist und lassest uns dein Erbe sein. ");
INSERT INTO deu1912_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Und er sprach: Siehe, ich will einen Bund machen vor allem deinem Volk und will Wunder tun, dergleichen nicht geschaffen sind in allen Landen und unter allen Völkern, und alles Volk, darunter du bist, soll sehen des HERRN Werk; denn wunderbar soll sein, was ich bei dir tun werde. ");
INSERT INTO deu1912_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Halte, was ich dir heute gebiete. Siehe, ich will vor dir her ausstoßen die Amoriter, Kanaaniter, Hethiter, Pheresiter, Heviter und Jebusiter. ");
INSERT INTO deu1912_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Hüte dich, daß du nicht einen Bund machest mit den Einwohnern des Landes, da du hineinkommst, daß sie dir nicht ein Fallstrick unter dir werden; ");
INSERT INTO deu1912_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","sondern ihre Altäre sollst du umstürzen und ihre Götzen zerbrechen und ihre Haine ausrotten; ");
INSERT INTO deu1912_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","denn du sollst keinen andern Gott anbeten. Denn der HERR heißt ein Eiferer; ein eifriger Gott ist er. ");
INSERT INTO deu1912_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Daß du nicht einen Bund mit des Landes Einwohnern machest, und wenn sie ihren Göttern nachlaufen und opfern ihren Göttern, sie dich nicht laden und du von ihrem Opfer essest, ");
INSERT INTO deu1912_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","und daß du nehmest deinen Söhnen ihre Töchter zu Weibern und dieselben dann ihren Göttern nachlaufen und machen deine Söhne auch ihren Göttern nachlaufen. ");
INSERT INTO deu1912_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Du sollst dir keine gegossenen Götter machen. ");
INSERT INTO deu1912_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Das Fest der ungesäuerten Brote sollst du halten. Sieben Tage sollst du ungesäuertes Brot essen, wie ich dir geboten habe, um die Zeit des Monats Abib; denn im Monat Abib bist du aus Ägypten gezogen. ");
INSERT INTO deu1912_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Alles, was die Mutter bricht, ist mein; was männlich sein wird in deinem Vieh, das seine Mutter bricht, es sei Ochse oder Schaf. ");
INSERT INTO deu1912_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Aber den Erstling des Esels sollst du mit einem Schaf lösen. Wo du es aber nicht lösest, so brich ihm das Genick. Alle Erstgeburt unter deinen Söhnen sollst du lösen. Und daß niemand vor mir leer erscheine! ");
INSERT INTO deu1912_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sechs Tage sollst du arbeiten; am siebenten Tage sollst du feiern, mit Pflügen und mit Ernten. ");
INSERT INTO deu1912_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Das Fest der Wochen sollst du halten mit den Erstlingen der Weizenernte, und das Fest der Einsammlung, wenn das Jahr um ist. ");
INSERT INTO deu1912_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Dreimal im Jahr soll alles, was männlich ist, erscheinen vor dem Herrscher, dem HERRN und Gott Israels. ");
INSERT INTO deu1912_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Wenn ich die Heiden vor dir ausstoßen und deine Grenze erweitern werde, soll niemand deines Landes begehren, die weil du hinaufgehst dreimal im Jahr, zu erscheinen vor dem HERRN, deinem Gott. ");
INSERT INTO deu1912_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Du sollst das Blut meines Opfers nicht opfern neben gesäuertem Brot, und das Opfer des Osterfestes soll nicht über Nacht bleiben bis an den Morgen. ");
INSERT INTO deu1912_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Die Erstlinge von den Früchten deines Ackers sollst du in das Haus des HERRN, deines Gottes, bringen. Du sollst das Böcklein nicht kochen in seiner Mutter Milch. ");
INSERT INTO deu1912_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Und der HERR sprach zu Mose: Schreib diese Worte: denn nach diesen Worten habe ich mit dir und mit Israel einen Bund gemacht. ");
INSERT INTO deu1912_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Und er war allda bei dem HERRN vierzig Tage und vierzig Nächte und aß kein Brot und trank kein Wasser. Und er schrieb auf die Tafeln die Worte des Bundes, die Zehn Worte. ");
INSERT INTO deu1912_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Da nun Mose vom Berge Sinai ging, hatte er die zwei Tafeln des Zeugnisses in seiner Hand und wußte nicht, daß die Haut seines Angesichts glänzte davon, daß er mit ihm geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Und da Aaron und alle Kinder Israel sahen, daß die Haut seines Angesichts glänzte, fürchteten sie sich, zu ihm zu nahen. ");
INSERT INTO deu1912_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Da rief sie Mose; und sie wandten sich zu ihm, Aaron und alle Obersten der Gemeinde; und er redete mit ihnen. ");
INSERT INTO deu1912_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Darnach nahten alle Kinder Israel zu ihm. Und er gebot ihnen alles, was der HERR mit ihm geredet hatte auf dem Berge Sinai. ");
INSERT INTO deu1912_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Und da er solches alles mit ihnen geredet hatte, legte er eine Decke auf sein Angesicht. ");
INSERT INTO deu1912_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Und wenn er hineinging vor den HERRN, mit ihm zu reden, tat er die Decke ab, bis er wieder herausging. Und wenn er herauskam und redete mit den Kindern Israel, was ihm geboten war, ");
INSERT INTO deu1912_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","so sahen dann die Kinder Israel sein Angesicht an, daß die Haut seines Angesichts glänzte; so tat er wieder die Decke auf sein Angesicht, bis er wieder hineinging, mit ihm zu reden. ");
INSERT INTO deu1912_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Und Mose versammelte die ganze Gemeinde der Kinder Israel und sprach zu ihnen: Das ist's, was der HERR geboten hat, das ihr tun sollt: ");
INSERT INTO deu1912_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sechs Tage sollt ihr arbeiten; den siebenten Tag aber sollt ihr heilig halten als einen Sabbat der Ruhe des HERRN. Wer an dem arbeitet, soll sterben. ");
INSERT INTO deu1912_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ihr sollt kein Feuer anzünden am Sabbattag in allen euren Wohnungen. ");
INSERT INTO deu1912_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Und Mose sprach zu der ganzen Gemeinde der Kinder Israel: Das ist's, was der HERR geboten hat: ");
INSERT INTO deu1912_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Gebt unter euch ein Hebopfer dem HERRN, also daß das Hebopfer des HERRN ein jeglicher willig bringe, Gold, Silber, Erz, ");
INSERT INTO deu1912_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blauen und roten Purpur, Scharlach, weiße Leinwand und Ziegenhaar, ");
INSERT INTO deu1912_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","rötliche Widderfelle, Dachsfelle und Akazienholz, ");
INSERT INTO deu1912_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Öl zur Lampe und Spezerei zur Salbe und zu gutem Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Onyxsteine und eingefaßte Steine zum Leibrock und zum Amtschild. ");
INSERT INTO deu1912_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Und wer unter euch verständig ist, der komme und mache, was der HERR geboten hat: ");
INSERT INTO deu1912_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","nämlich die Wohnung mit ihrer Hütte und Decke, Haken, Brettern, Riegeln, Säulen und Füßen; ");
INSERT INTO deu1912_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","die Lade mit ihren Stangen, den Gnadenstuhl und Vorhang; ");
INSERT INTO deu1912_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","den Tisch mit seinen Stangen und allem seinem Geräte und die Schaubrote; ");
INSERT INTO deu1912_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","den Leuchter, zu leuchten, und sein Gerät und seine Lampen und das Öl zum Licht; ");
INSERT INTO deu1912_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","den Räucheraltar mit seinen Stangen, die Salbe und Spezerei zum Räuchwerk; das Tuch vor der Wohnung Tür; ");
INSERT INTO deu1912_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","den Brandopferaltar mit seinem ehernen Gitter, Stangen und allem seinem Geräte; das Handfaß mit seinem Fuße; ");
INSERT INTO deu1912_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","den Umhang des Vorhofs mit seinen Säulen und Füßen und das Tuch des Tors am Vorhof; ");
INSERT INTO deu1912_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","die Nägel der Wohnung und des Vorhofs mit ihren Seilen; ");
INSERT INTO deu1912_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","die Kleider des Amts zum Dienst im Heiligen, die heiligen Kleider Aarons, des Priesters, mit den Kleidern seiner Söhne zum Priestertum. ");
INSERT INTO deu1912_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Da ging die ganze Gemeinde der Kinder Israel aus von Mose. ");
INSERT INTO deu1912_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Und alle, die es gern und willig gaben, kamen und brachten das Hebopfer dem HERRN zum Werk der Hütte des Stifts und zu allem ihren Dienst und zu den heiligen Kleidern. ");
INSERT INTO deu1912_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Es brachten aber beide, Mann und Weib, wer's willig tat, Spangen, Ohrringe, Ringe und Geschmeide und allerlei goldenes Gerät. Dazu brachte jedermann Gold zum Webeopfer dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Und wer bei sich fand blauen und roten Purpur, Scharlach, weiße Leinwand, Ziegenhaar, rötliche Widderfelle und Dachsfelle, der brachte es. ");
INSERT INTO deu1912_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Und wer Silber und Erz hob, der brachte es zur Hebe dem HERRN. Und wer Akazienholz bei sich fand, der brachte es zu allerlei Werk des Gottesdienstes. ");
INSERT INTO deu1912_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Und welche verständige Weiber waren, die spannen mit ihren Händen und brachten ihr Gespinnst, blauen und roten Purpur, Scharlach und weiße Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Und welche Weiber solche Arbeit konnten und willig dazu waren, die spannen Ziegenhaare. ");
INSERT INTO deu1912_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Die Fürsten aber brachten Onyxsteine und eingefaßte Steine zum Leibrock und zum Schild ");
INSERT INTO deu1912_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","und Spezerei und Öl zu den Lichtern und zur Salbe und zum guten Räuchwerk. ");
INSERT INTO deu1912_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Also brachte die Kinder Israel willig, beide, Mann und Weib, zu allerlei Werk, das der HERR geboten hatte durch Mose, daß man's machen sollte. ");
INSERT INTO deu1912_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Und Mose sprach zu den Kindern Israel: Sehet, der HERR hat mit Namen berufen den Bezaleel, den Sohn Uris, des Sohnes Hur, vom Stamme Juda, ");
INSERT INTO deu1912_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","und hat ihn erfüllt mit dem Geist Gottes, daß er weise, verständig, geschickt sei zu allerlei Werk, ");
INSERT INTO deu1912_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","kunstreich zu arbeiten an Gold, Silber und Erz, ");
INSERT INTO deu1912_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Edelsteine zu schneiden und einzusetzen, Holz zu zimmern, zu machen allerlei kunstreiche Arbeit. ");
INSERT INTO deu1912_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Und hat ihm ins Herz gegeben, zu unterweisen, ihm und Oholiab, dem Sohn Ahisamachs, vom Stamme Dan. ");
INSERT INTO deu1912_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Er hat ihr Herz mit Weisheit erfüllt, zu machen allerlei Werk, zu schneiden, zu wirken und zu sticken mit blauem und rotem Purpur, Scharlach und weißer Leinwand, und mit Weben, daß sie machen allerlei Werk und kunstreiche Arbeit erfinden. ");
INSERT INTO deu1912_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Da arbeiteten Bezaleel und Oholiab und alle weisen Männer, denen der HERR Weisheit und Verstand gegeben hatte, zu wissen, wie sie allerlei Werk machen sollten zum Dienst des Heiligtums, nach allem, was der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Und Mose berief den Bezaleel und Oholiab und alle weisen Männer, denen der HERR Weisheit gegeben hatte in ihr Herz, alle, die sich freiwillig erboten und hinzutraten, zu arbeiten an dem Werke. ");
INSERT INTO deu1912_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Und sie nahmen zu sich von Mose alle Hebe, die die Kinder Israel brachten zu dem Werke des Dienstes des Heiligtums, daß es gemacht würde. Denn sie brachten alle Morgen ihre willige Gabe zu ihm. ");
INSERT INTO deu1912_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Da kamen alle Weisen, die am Werk des Heiligtums arbeiteten, ein jeglicher von seinem Werk, das sie machten, ");
INSERT INTO deu1912_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","und sprachen zu Mose: Das Volk bringt zu viel, mehr denn zum Werk dieses Dienstes not ist, das der HERR zu machen geboten hat. ");
INSERT INTO deu1912_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Da gebot Mose, daß man rufen ließ durchs Lager: Niemand tue mehr zur Hebe des Heiligtums. Da hörte das Volk auf zu bringen. ");
INSERT INTO deu1912_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Denn des Dinges war genug zu allerlei Werk, das zu machen war, und noch übrig. ");
INSERT INTO deu1912_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Also machten alle weisen Männer unter den Arbeitern am Werk die Wohnung, zehn Teppiche von gezwirnter weißer Leinwand, blauem und rotem Purpur und Scharlach, und Cherubim daran von kunstreicher Arbeit. ");
INSERT INTO deu1912_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Die Länge eines Teppichs war achtundzwanzig Ellen und die Breite vier Ellen, und waren alle in einem Maß. ");
INSERT INTO deu1912_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Und er fügte je fünf Teppiche zu einem Stück zusammen, einen an den andern. ");
INSERT INTO deu1912_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Und machte blaue Schleifen an jegliches Stück am Rande, wo die zwei Stücke sollten zusammengeheftet werden, ");
INSERT INTO deu1912_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","fünfzig Schleifen an jegliches Stück, daß eine Schleife der anderen gegenüberstünde. ");
INSERT INTO deu1912_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Und machte fünfzig goldene Haken und heftete die Teppiche mit den Haken einen an den andern zusammen, daß es eine Wohnung würde. ");
INSERT INTO deu1912_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Und er machte elf Teppiche von Ziegenhaaren, zur Hütte über die Wohnung, ");
INSERT INTO deu1912_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","dreißig Ellen lang und vier Ellen breit, alle in einem Maß. ");
INSERT INTO deu1912_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Und fügte ihrer fünf zusammen auf einen Teil und sechs zusammen auf den andern Teil. ");
INSERT INTO deu1912_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Und machte fünfzig Schleifen an jegliches Stück am Rande, wo die Stücke sollten zusammengeheftet werden. ");
INSERT INTO deu1912_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Und machte je fünfzig eherne Haken, daß die Hütte damit zusammen in eins gefügt würde. ");
INSERT INTO deu1912_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Und machte eine Decke über die Hütte von rötlichen Widderfellen und über die noch eine Decke von Dachsfellen. ");
INSERT INTO deu1912_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Und machte Bretter zur Wohnung von Akazienholz, die stehen sollten, ");
INSERT INTO deu1912_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ein jegliches zehn Ellen lang und anderthalb Ellen breit ");
INSERT INTO deu1912_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","und an jeglichem zwei Zapfen, damit eins an das andere gesetzt würde. Also machte er alle Bretter zur Wohnung, ");
INSERT INTO deu1912_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","daß der Bretter zwanzig gegen Mittag standen. ");
INSERT INTO deu1912_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Und machte vierzig silberne Füße darunter, unter jeglich Brett zwei Füße an seine zwei Zapfen. ");
INSERT INTO deu1912_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Also zur andern Seite der Wohnung, gegen Mitternacht, machte er auch zwanzig Bretter ");
INSERT INTO deu1912_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","mit vierzig silbernen Füßen, unter jeglichem Brett zwei Füße. ");
INSERT INTO deu1912_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Aber hinten an der Wohnung, gegen Abend, machte er sechs Bretter ");
INSERT INTO deu1912_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","und zwei andere hinten an den zwei Ecken der Wohnung, ");
INSERT INTO deu1912_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","daß ein jegliches der beiden sich mit seinem Eckbrett von untenauf gesellte und oben am Haupt zusammenkäme mit einer Klammer, ");
INSERT INTO deu1912_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","daß der Bretter acht würden und sechzehn silberne Füße, unter jeglichem zwei Füße. ");
INSERT INTO deu1912_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Und er machte Riegel von Akazienholz, fünf zu den Brettern auf der einen Seite der Wohnung ");
INSERT INTO deu1912_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","und fünf auf der andern Seite und fünf hintenan, gegen Abend. ");
INSERT INTO deu1912_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Und machte den mittleren Riegel, daß er mitten an den Brettern hindurchgestoßen würde von einem Ende zum andern. ");
INSERT INTO deu1912_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Und überzog die Bretter mit Gold; aber ihre Ringe machte er von Gold, daß man die Riegel darein täte, und überzog die Riegel mit Gold. ");
INSERT INTO deu1912_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Und machte den Vorhang mit dem Cherubim daran künstlich von blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Und machte zu demselben vier Säulen von Akazienholz und überzog sie mit Gold, und ihre Haken von Gold; und goß dazu vier silberne Füße. ");
INSERT INTO deu1912_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Und machte ein Tuch in der Tür der Hütte von blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand, gestickt, ");
INSERT INTO deu1912_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","und fünf Säulen dazu mit ihren Haken, und überzog ihre Köpfe und Querstäbe mit Gold und fünf eherne Füße daran. ");
INSERT INTO deu1912_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Und Bezaleel machte die Lade von Akazienholz, dritthalb Ellen lang, anderthalb Ellen breit und hoch, ");
INSERT INTO deu1912_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","und überzog sie mit feinem Golde inwendig und auswendig und machte ihr einen goldenen Kranz umher. ");
INSERT INTO deu1912_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Und goß vier goldene Ringe an ihre vier Ecken, auf jeglicher Seite zwei. ");
INSERT INTO deu1912_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Und machte Stangen von Akazienholz und überzog sie mit Gold ");
INSERT INTO deu1912_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","und tat sie in die Ringe an der Lade Seiten, daß man sie tragen konnte. ");
INSERT INTO deu1912_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Und machte den Gnadenstuhl von feinem Golde, dritthalb Ellen lang und anderthalb Ellen breit. ");
INSERT INTO deu1912_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Und machte zwei Cherubim von getriebenem Golde an die zwei Enden des Gnadenstuhls, ");
INSERT INTO deu1912_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","einen Cherub an diesem Ende, den andern an jenem Ende. ");
INSERT INTO deu1912_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Und die Cherubim breiteten ihre Flügel aus von obenher und deckten damit den Gnadenstuhl; und ihre Antlitze standen gegeneinander und sahen auf den Gnadenstuhl. ");
INSERT INTO deu1912_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Und er machte den Tisch von Akazienholz, zwei Ellen lang, eine Elle breit und anderthalb Ellen hoch, ");
INSERT INTO deu1912_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","und überzog ihn mit feinem Golde und machte ihm einen goldenen Kranz umher. ");
INSERT INTO deu1912_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Und machte ihm eine Leiste umher, eine Handbreit hoch, und machte einen goldenen Kranz um die Leiste her. ");
INSERT INTO deu1912_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Und goß dazu vier goldene Ringe und tat sie an die vier Ecken an seinen vier Füßen, ");
INSERT INTO deu1912_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","hart an der Leiste, daß die Stangen darin wären, daran man den Tisch trüge. ");
INSERT INTO deu1912_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Und machte die Stangen von Akazienholz und überzog sie mit Gold, daß man den Tisch damit trüge. ");
INSERT INTO deu1912_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Und machte auch von feinem Golde das Gerät auf den Tisch: Schüsseln und Löffel, Kannen und Schalen, darin man das Trankopfer darbrächte. ");
INSERT INTO deu1912_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Und er machte den Leuchter von feinem, getriebenem Golde. Daran war der Schaft mit Röhren, Schalen, Knäufen und Blumen. ");
INSERT INTO deu1912_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Sechs Röhren gingen zu seinen Seiten aus, zu jeglicher Seite drei Röhren. ");
INSERT INTO deu1912_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Drei Schalen waren an jeglichem Rohr mit Knäufen und Blumen. ");
INSERT INTO deu1912_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","An dem Leuchter aber waren vier Schalen mit Knäufen und Blumen, ");
INSERT INTO deu1912_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","je ein Knauf unter zwei von den sechs Röhren, die aus ihm gingen, ");
INSERT INTO deu1912_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","und die Knäufe und Röhren gingen aus ihm, und war alles aus getriebenem, feinem Gold. ");
INSERT INTO deu1912_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Und machte die sieben Lampen mit ihren Lichtschnäuzen und Löschnäpfen von feinem Gold. ");
INSERT INTO deu1912_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Aus einem Zentner feinen Goldes machte er ihn und all sein Gerät. ");
INSERT INTO deu1912_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Er machte auch den Räucheraltar von Akazienholz, eine Elle lang und breit, gleich viereckig, und zwei Ellen hoch, mit seinen Hörnern, ");
INSERT INTO deu1912_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","und überzog ihn mit feinem Golde, sein Dach und seine Wände ringsumher und seine Hörner, und machte ihm einen Kranz umher von Gold ");
INSERT INTO deu1912_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","und zwei goldene Ringe unter dem Kranz zu beiden Seiten, daß man Stangen darein täte und ihn damit trüge. ");
INSERT INTO deu1912_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Aber die Stangen machte er von Akazienholz und überzog sie mit Gold. ");
INSERT INTO deu1912_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Und er machte die heilige Salbe und Räuchwerk von reiner Spezerei nach der Kunst des Salbenbereiters. ");
INSERT INTO deu1912_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Und er machte den Brandopferaltar von Akazienholz, fünf Ellen lang und breit, gleich viereckig, und drei Ellen hoch. ");
INSERT INTO deu1912_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Und machte vier Hörner, die aus ihm gingen auf seinen vier Ecken, und überzog sie mit Erz. ");
INSERT INTO deu1912_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Und machte allerlei Geräte zu dem Altar: Aschentöpfe, Schaufeln, Becken, Gabeln, Kohlenpfannen, alles aus Erz. ");
INSERT INTO deu1912_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Und machte am Altar ein Gitter wie ein Netz von Erz umher, von untenauf bis an die Hälfte des Altars. ");
INSERT INTO deu1912_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Und goß vier Ringe an die vier Enden des ehernen Gitters für die Stangen. ");
INSERT INTO deu1912_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Dieselben machte er aus Akazienholz und überzog sie mit Erz ");
INSERT INTO deu1912_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","und tat sie in die Ringe an den Seiten des Altars, daß man ihn damit trüge; und machte ihn inwendig hohl. ");
INSERT INTO deu1912_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Und machte ein Handfaß von Erz und seinen Fuß auch von Erz aus Spiegeln der Weiber, die vor der Tür der Hütte des Stifts dienten. ");
INSERT INTO deu1912_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Und er machte den Vorhof: Gegen Mittag mit einem Umhang, hundert Ellen lang, von gezwirnter weißer Leinwand, ");
INSERT INTO deu1912_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","mit seinen zwanzig Säulen und zwanzig Füßen von Erz, aber ihre Haken und Querstäbe von Silber; ");
INSERT INTO deu1912_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","desgleichen gegen Mitternacht hundert Ellen mit zwanzig Säulen und zwanzig Füßen von Erz, aber ihre Haken und Querstäbe von Silber; ");
INSERT INTO deu1912_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","gegen Abend aber fünfzig Ellen mit zehn Säulen und zehn Füßen, aber ihre Haken und Querstäbe von Silber; ");
INSERT INTO deu1912_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","gegen Morgen auch fünfzig Ellen; ");
INSERT INTO deu1912_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","fünfzehn Ellen auf einer Seite mit drei Säulen und drei Füßen, ");
INSERT INTO deu1912_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","und auf der andern Seite auch fünfzehn Ellen mit drei Säulen und drei Füßen, daß ihrer so viele waren an der einen Seite des Tors am Vorhofe als an der andern. ");
INSERT INTO deu1912_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Alle Umhänge des Vorhofs waren von gezwirnter weißer Leinwand ");
INSERT INTO deu1912_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","und die Füße der Säulen von Erz und ihre Haken und Querstäbe von Silber, also daß ihre Köpfe überzogen waren mit Silber. Und ihre Querstäbe waren silbern an allen Säulen des Vorhofs. ");
INSERT INTO deu1912_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Und das Tuch in dem Tor des Vorhofs machte er gestickt von blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand, zwanzig Ellen lang und fünf Ellen hoch, nach dem Maß der Umhänge des Vorhofs. ");
INSERT INTO deu1912_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Dazu vier Säulen und vier Füße von Erz, und ihre Haken von Silber und ihre Köpfe und ihre Querstäbe überzogen mit Silber. ");
INSERT INTO deu1912_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Und alle Nägel der Wohnung und des Vorhofs ringsherum waren von Erz. ");
INSERT INTO deu1912_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Das ist nun die Summe zu der Wohnung des Zeugnisses, die gezählt ward, wie Mose geboten hatte, durch den Dienst der Leviten unter der Hand Ithamars, des Sohnes Aarons, des Priesters. ");
INSERT INTO deu1912_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleel, der Sohn Uris, des Sohnes Hur, vom Stamme Juda, machte alles, wie der HERR dem Mose geboten hatte, ");
INSERT INTO deu1912_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","und mit ihm Oholiab, der Sohn Ahisamachs, vom Stamme Dan, ein Meister zu schneiden, zu wirken und zu sticken mit blauem und rotem Purpur, Scharlach und weißer Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Alles Gold, das verarbeitet ist in diesem ganzen Werk des Heiligtums, das zum Webeopfer gegeben ward, ist neunundzwanzig Zentner siebenhundertunddreißig Lot nach dem Lot des Heiligtums. ");
INSERT INTO deu1912_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Des Silbers aber, das von der Gemeinde kam, war hundert Zentner tausendsiebenhundertfünfzig Lot nach dem Lot des Heiligtums: ");
INSERT INTO deu1912_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","so manch Haupt, so manch halbes Lot nach dem Lot des Heiligtums, von allen, die gezählt wurden von zwanzig Jahren an und darüber, sechshundertmaltausend dreitausend fünfhundertundfünfzig. ");
INSERT INTO deu1912_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Aus den hundert Zentnern Silber goß man die Füße des Heiligtums und die Füße des Vorhangs, hundert Füße aus hundert Zentnern, je einen Zentner zum Fuß. ");
INSERT INTO deu1912_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Aber aus tausend siebenhundert und fünfundsiebzig Loten wurden gemacht der Säulen Haken, und ihre Köpfe überzogen und ihre Querstäbe. ");
INSERT INTO deu1912_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Das Webeopfer aber des Erzes war siebzig Zentner zweitausendvierhundert Lot. ");
INSERT INTO deu1912_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Daraus wurden gemacht die Füße in der Tür der Hütte des Stifts und der eherne Altar und das eherne Gitter daran und alle Geräte des Altars, ");
INSERT INTO deu1912_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","dazu die Füße des Vorhofs ringsherum und die Füße des Tores am Vorhofe, alle Nägel der Wohnung und alle Nägel des Vorhofs ringsherum. ");
INSERT INTO deu1912_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Aber von dem blauen und roten Purpur und dem Scharlach machten sie Aaron Amtskleider, zu dienen im Heiligtum, wie der HERR Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Und er machte den Leibrock von Gold, blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Und sie schlugen das Gold und schnitten's zu Faden, daß man's künstlich wirken konnte unter den blauen und roten Purpur, Scharlach und weiße Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Schulterstücke machten sie an ihm, die zusammengingen, und an beiden Enden ward er zusammengebunden. ");
INSERT INTO deu1912_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Und sein Gurt war nach derselben Kunst und Arbeit von Gold, blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Und sie machten zwei Onyxsteine, umher gefaßt mit Gold, gegraben durch die Steinschneider mit den Namen der Kinder Israel; ");
INSERT INTO deu1912_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","und er heftete sie auf die Schulterstücke des Leibrocks, daß es Steine seien zum Gedächtnis der Kinder Israel, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Und sie machten das Schild nach der Kunst und dem Werk des Leibrocks von Gold, blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand, ");
INSERT INTO deu1912_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","daß es viereckig und zwiefach war, eine Spanne lang und breit. ");
INSERT INTO deu1912_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Und füllten es mit vier Reihen Steinen: die erste Reihe war ein Sarder, Topas und Smaragd; ");
INSERT INTO deu1912_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","die andere ein Rubin, Saphir und Demant; ");
INSERT INTO deu1912_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","die dritte ein Lynkurer, Achat und Amethyst; ");
INSERT INTO deu1912_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","die vierte ein Türkis, Onyx und Jaspis, umher gefaßt mit Gold in allen Reihen. ");
INSERT INTO deu1912_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Und die Steine standen nach den zwölf Namen der Kinder Israel, gegraben durch die Steinschneider, daß auf einem jeglichen ein Name stand nach den zwölf Stämmen. ");
INSERT INTO deu1912_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Und sie machten am Schild Ketten mit zwei Enden von feinem Golde ");
INSERT INTO deu1912_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","und zwei goldene Fassungen und zwei goldene Ringe und hefteten die zwei Ringe auf die zwei Ecken des Schildes. ");
INSERT INTO deu1912_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Und die zwei goldenen Ketten taten sie in die zwei Ringe auf den Ecken des Schildes. ");
INSERT INTO deu1912_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Aber die zwei Enden der Ketten taten sie an die zwei Fassungen und hefteten sie auf die Schulterstücke des Leibrocks vornehin. ");
INSERT INTO deu1912_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Und machten zwei andere goldene Ringe und hefteten sie an die zwei andern Ecken des Schildes an seinen Rand, inwendig gegen den Leibrock. ");
INSERT INTO deu1912_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Und sie machten zwei andere goldene Ringe, die taten sie unten an die zwei Schulterstücke vorn am Leibrock, wo er zusammengeht, oben über dem Gurt des Leibrocks, ");
INSERT INTO deu1912_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","daß das Schild mit seinen Ringen an die Ringe des Leibrocks geknüpft würde mit einer blauen Schnur, daß es über dem Gurt des Leibrocks hart anläge und nicht vom Leibrock los würde, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Und machte einen Purpurrock zum Leibrock, gewirkt, ganz von blauem Purpur, ");
INSERT INTO deu1912_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","und sein Loch oben mitteninne und eine Borte ums Loch her gefaltet, daß er nicht zerrisse. ");
INSERT INTO deu1912_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Und sie machten an seinen Saum Granatäpfel von blauem und rotem Purpur, Scharlach und gezwirnter weißer Leinwand. ");
INSERT INTO deu1912_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Und machten Schellen von feinem Golde; die taten sie zwischen die Granatäpfel ringsumher am Saum des Purpurrocks, ");
INSERT INTO deu1912_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","je ein Granatapfel und eine Schelle um und um am Saum, darin zu dienen, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Und sie machten auch die engen Röcke, von weißer Leinwand gewirkt, Aaron und seinen Söhnen, ");
INSERT INTO deu1912_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","und den Hut von weißer Leinwand und die schönen Hauben von weißer Leinwand und Beinkleider von gezwirnter weißer Leinwand ");
INSERT INTO deu1912_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","und den gestickten Gürtel von gezwirnter weißer Leinwand, blauem und rotem Purpur und Scharlach, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Sie machten auch das Stirnblatt, die heilige Krone, von feinem Gold, und gruben Schrift darein: Heilig dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Und banden eine blaue Schnur daran, daß sie an den Hut von obenher geheftet würde, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Also ward vollendet das ganze Werk der Wohnung der Hütte des Stifts. Und die Kinder Israel taten alles, was der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Und sie brachten die Wohnung zu Mose: die Hütte und alle ihre Geräte, Haken, Bretter, Riegel, Säulen, Füße, ");
INSERT INTO deu1912_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","die Decke von rötlichen Widderfellen, die Decke von Dachsfellen und den Vorhang; ");
INSERT INTO deu1912_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","die Lade des Zeugnisses mit ihren Stangen, den Gnadenstuhl; ");
INSERT INTO deu1912_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","den Tisch und alle seine Geräte und die Schaubrote; ");
INSERT INTO deu1912_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","den schönen Leuchter mit den Lampen zubereitet und allem seinen Geräte und Öl zum Licht; ");
INSERT INTO deu1912_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","den Goldenen Altar und die Salbe und gutes Räuchwerk; das Tuch in der Hütte Tür; ");
INSERT INTO deu1912_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","den ehernen Altar und sein ehernes Gitter mit seinen Stangen und allem seinem Geräte; das Handfaß mit seinem Fuß; ");
INSERT INTO deu1912_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","die Umhänge des Vorhofs mit seinen Säulen und Füßen; das Tuch im Tor des Vorhofs mit seinen Seilen und Nägeln und allem Gerät zum Dienst der Wohnung der Hütte des Stifts; ");
INSERT INTO deu1912_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","die Amtskleider des Priesters Aaron, zu dienen im Heiligtum, und die Kleider seiner Söhne, daß sie Priesteramt täten. ");
INSERT INTO deu1912_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Alles, wie der HERR dem Mose geboten hatte, taten die Kinder Israel an allem diesem Dienst. ");
INSERT INTO deu1912_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Und Mose sah an all dies Werk; und siehe, sie hatten es gemacht, wie der HERR geboten hatte. Und er segnete sie. ");
INSERT INTO deu1912_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Du sollst die Wohnung der Hütte des Stifts aufrichten am ersten Tage des ersten Monats. ");
INSERT INTO deu1912_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","und sollst darein setzen die Lade des Zeugnisses und vor die Lade den Vorhang hängen. ");
INSERT INTO deu1912_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Und sollst den Tisch darbringen und ihn zubereiten und den Leuchter darstellen und die Lampen darauf setzen. ");
INSERT INTO deu1912_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Und sollst den goldenen Räucheraltar setzen vor die Lade des Zeugnisses und das Tuch in der Tür der Wohnung aufhängen. ");
INSERT INTO deu1912_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Den Brandopferaltar aber sollst du setzen heraus vor die Tür der Wohnung der Hütte des Stifts, ");
INSERT INTO deu1912_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","und das Handfaß zwischen die Hütte des Stifts und den Altar, und Wasser darein tun, ");
INSERT INTO deu1912_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","und den Vorhof stellen umher, und das Tuch in der Tür des Vorhofs aufhängen. ");
INSERT INTO deu1912_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Und sollst die Salbe nehmen, und die Wohnung und alles, was darin ist, salben; und sollst sie weihen mit allem ihrem Geräte, daß sie heilig sei. ");
INSERT INTO deu1912_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Und sollst den Brandopferaltar salben mit allem seinem Geräte, und weihen, daß er hochheilig sei. ");
INSERT INTO deu1912_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Sollst auch das Handfaß und seinen Fuß salben und weihen. ");
INSERT INTO deu1912_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Und sollst Aaron und seine Söhne vor die Tür der Hütte des Stifts führen und mit Wasser waschen, ");
INSERT INTO deu1912_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","und Aaron die heiligen Kleider anziehen und ihn salben und weihen, daß er mein Priester sei; ");
INSERT INTO deu1912_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","und seine Söhne auch herzuführen und ihnen die engen Röcke anziehen, ");
INSERT INTO deu1912_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","und sie salben, wie du ihren Vater gesalbt hast, daß sie meine Priester seien. Und diese Salbung sollen sie haben zum ewigen Priestertum bei ihren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Und Mose tat alles, wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Also ward die Wohnung aufgerichtet im zweiten Jahr, am ersten Tage des ersten Monats. ");
INSERT INTO deu1912_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Und da Mose sie aufrichtete, setzte er die Füße und die Bretter und Riegel und richtete die Säulen auf ");
INSERT INTO deu1912_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","und breitete die Hütte aus über der Wohnung und legte die Decke der Hütte obendarauf, wie der HERR ihm geboten hatte, ");
INSERT INTO deu1912_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","und nahm das Zeugnis und legte es in die Lade und tat die Stangen an die Lade und tat den Gnadenstuhl oben auf die Lade ");
INSERT INTO deu1912_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","und brachte die Lade in die Wohnung und hing den Vorhang vor die Lade des Zeugnisses, wie ihm der HERR geboten hatte, ");
INSERT INTO deu1912_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","und setzte den Tisch in die Hütte des Stifts, an die Seite der Wohnung gegen Mitternacht, außen vor den Vorhang, ");
INSERT INTO deu1912_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","und richtete Brot darauf zu vor dem HERRN, wie ihm der HERR geboten hatte, ");
INSERT INTO deu1912_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","und setzte den Leuchter auch hinein, gegenüber dem Tisch, an die Seite der Wohnung gegen Mittag, ");
INSERT INTO deu1912_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","und tat Lampen darauf vor dem HERRN, wie ihm der HERR geboten hatte, ");
INSERT INTO deu1912_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","und setzte den goldenen Altar hinein vor den Vorhang ");
INSERT INTO deu1912_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","und räucherte darauf mit gutem Räuchwerk, wie ihm der HERR geboten hatte, ");
INSERT INTO deu1912_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","und hing das Tuch in die Tür der Wohnung. ");
INSERT INTO deu1912_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Aber den Brandopferaltar setzte er vor die Tür der Wohnung der Hütte des Stifts und opferte darauf Brandopfer und Speisopfer, wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Und das Handfaß setzte er zwischen die Hütte des Stifts und den Altar und tat Wasser darein zum Waschen. ");
INSERT INTO deu1912_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Und Mose, Aaron und seine Söhne wuschen ihre Hände und Füße darin. ");
INSERT INTO deu1912_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Denn sie müssen sich waschen, wenn sie in die Hütte des Stifts gehen oder hinzutreten zum Altar, wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Und er richtete den Vorhof auf um die Wohnung und um den Altar her und hing den Vorhang in das Tor des Vorhofs. Also vollendete Mose das ganze Werk. ");
INSERT INTO deu1912_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Da bedeckte die Wolke die Hütte des Stifts, und die Herrlichkeit des HERRN füllte die Wohnung. ");
INSERT INTO deu1912_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Und Mose konnte nicht in die Hütte des Stifts gehen, weil die Wolke darauf blieb und die Herrlichkeit des HERRN die Wohnung füllte. ");
INSERT INTO deu1912_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Und wenn die Wolke sich aufhob von der Wohnung, so zogen die Kinder Israel, solange sie reisten. ");
INSERT INTO deu1912_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Wenn sich aber die Wolke nicht aufhob, so zogen sie nicht bis an den Tag, da sie sich aufhob. ");
INSERT INTO deu1912_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Denn die Wolke des HERRN war des Tages auf der Wohnung, und des Nachts war sie feurig vor den Augen des ganzen Hauses Israel, solange sie reisten. ");
INSERT INTO deu1912_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Und der HERR rief Mose und redete mit ihm aus der Hütte des Stifts und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Rede mit den Kindern Israel und sprich zu ihnen: Welcher unter euch dem HERRN ein Opfer tun will, der tue es von dem Vieh, von Rindern und Schafen. ");
INSERT INTO deu1912_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Will er ein Brandopfer tun von Rindern, so opfere er ein Männlein, das ohne Fehl sei, vor der Tür der Hütte des Stifts, daß es dem HERRN angenehm sei von ihm, ");
INSERT INTO deu1912_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","und lege seine Hand auf des Brandopfers Haupt, so wird es angenehm sein und ihn versöhnen. ");
INSERT INTO deu1912_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Und er soll das junge Rind schlachten vor dem HERRN; und die Priester, Aarons Söhne, sollen das Blut herzubringen und auf den Altar umhersprengen, der vor der Tür der Hütte des Stifts ist. ");
INSERT INTO deu1912_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Und man soll dem Brandopfer die Haut abziehen, und es soll in Stücke zerhauen werden; ");
INSERT INTO deu1912_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","und die Söhne Aarons, des Priesters, sollen ein Feuer auf dem Altar machen und Holz obendarauf legen ");
INSERT INTO deu1912_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","und sollen die Stücke, den Kopf und das Fett auf das Holz legen, das auf dem Feuer auf dem Altar liegt. ");
INSERT INTO deu1912_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Das Eingeweide aber und die Schenkel soll man mit Wasser waschen, und der Priester soll das alles anzünden auf dem Altar zum Brandopfer. Das ist ein Feuer zum süßen Geruch dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Will er aber von Schafen oder Ziegen ein Brandopfer tun, so opfere er ein Männlein, das ohne Fehl sei. ");
INSERT INTO deu1912_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Und soll es schlachten zur Seite des Altars gegen Mitternacht vor dem HERRN. Und die Priester, Aarons Söhne, sollen sein Blut auf den Altar umhersprengen. ");
INSERT INTO deu1912_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Und man soll es in Stücke zerhauen, und der Priester soll sie samt dem Kopf und dem Fett auf das Holz und Feuer, das auf dem Altar ist, legen. ");
INSERT INTO deu1912_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Aber das Eingeweide und die Schenkel soll man mit Wasser waschen, und der Priester soll es alles opfern und anzünden auf dem Altar zum Brandopfer. Das ist ein Feuer zum süßen Geruch dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Will er aber von Vögeln dem HERRN ein Brandopfer tun, so tue er's von Turteltauben oder von jungen Tauben. ");
INSERT INTO deu1912_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Und der Priester soll's zum Altar bringen und ihm den Kopf abkneipen, daß es auf dem Altar angezündet werde, und sein Blut ausbluten lassen an der Wand des Altars. ");
INSERT INTO deu1912_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Und seinen Kropf mit seinen Federn soll man neben den Altar gegen Morgen auf den Aschenhaufen werfen; ");
INSERT INTO deu1912_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","und soll seine Flügel spalten, aber nicht abbrechen. Und also soll's der Priester auf dem Altar anzünden, auf dem Holz, auf dem Feuer zum Brandopfer. Das ist ein Feuer zum süßen Geruch dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Wenn eine Seele dem HERRN ein Speisopfer tun will, so soll es von Semmelmehl sein, und sie sollen Öl darauf gießen und Weihrauch darauf legen ");
INSERT INTO deu1912_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","und es also bringen zu den Priestern, Aarons Söhnen. Da soll der Priester seine Hand voll nehmen von dem Semmelmehl und Öl, samt dem ganzen Weihrauch und es anzünden zum Gedächtnis auf dem Altar. Das ist ein Feuer zum süßen Geruch dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Das übrige aber vom Speisopfer soll Aarons und seiner Söhne sein. Das soll ein Hochheiliges sein von den Feuern des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Will er aber sein Speisopfer tun vom Gebackenen im Ofen, so nehme er Kuchen von Semmelmehl, ungesäuert, mit Öl gemengt, oder ungesäuerte Fladen, mit Öl bestrichen. ");
INSERT INTO deu1912_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ist aber dein Speisopfer etwas vom Gebackenen in der Pfanne, so soll's von ungesäuertem Semmelmehl mit Öl gemengt sein; ");
INSERT INTO deu1912_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","und sollst's in Stücke zerteilen und Öl darauf gießen, so ist's ein Speisopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ist aber dein Speisopfer etwas auf dem Rost Geröstetes, so sollst du es von Semmelmehl mit Öl machen ");
INSERT INTO deu1912_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","und sollst das Speisopfer, das du von solcherlei machen willst dem HERRN, zu dem Priester bringen; der soll es zu dem Altar bringen ");
INSERT INTO deu1912_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","und des Speisopfers einen Teil abzuheben zum Gedächtnis und anzünden auf dem Altar. Das ist ein Feuer zum süßen Geruch dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Das übrige aber soll Aarons und seiner Söhne sein. Das soll ein Hochheiliges sein von den Feuern des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Alle Speisopfer, die ihr dem HERRN opfern wollt, sollt ihr ohne Sauerteig machen; denn kein Sauerteig noch Honig soll dem HERRN zum Feuer angezündet werden. ");
INSERT INTO deu1912_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Unter den Erstlingen sollt ihr sie dem HERRN bringen; aber auf den Altar sollen sie nicht kommen zum süßen Geruch. ");
INSERT INTO deu1912_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Alle deine Speisopfer sollst du salzen, und dein Speisopfer soll nimmer ohne Salz des Bundes deines Gottes sein; denn in allem deinem Opfer sollst du Salz opfern. ");
INSERT INTO deu1912_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Willst du aber ein Speisopfer dem HERRN tun von den ersten Früchten, so sollst du Ähren, am Feuer gedörrt, klein zerstoßen und also das Speisopfer deiner ersten Früchte opfern; ");
INSERT INTO deu1912_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","und sollst Öl darauf tun und Weihrauch darauf legen, so ist's ein Speisopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Und der Priester soll einen Teil von dem Zerstoßenen und vom Öl mit dem ganzen Weihrauch anzünden zum Gedächtnis. Das ist ein Feuer dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ist aber sein Opfer ein Dankopfer von Rindern, es sei ein Ochse oder eine Kuh, soll er eins opfern vor dem HERRN, das ohne Fehl sei. ");
INSERT INTO deu1912_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Und soll seine Hand auf desselben Haupt legen und es schlachten vor der Tür der Hütte des Stifts. Und die Priester, Aarons Söhne, sollen das Blut auf den Altar umhersprengen. ");
INSERT INTO deu1912_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Und er soll von dem Dankopfer dem HERRN opfern, nämlich das Fett, welches die Eingeweide bedeckt, und alles Fett am Eingeweide ");
INSERT INTO deu1912_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","und die zwei Nieren mit dem Fett, das daran ist, an den Lenden, und das Netz um die Leber, an den Nieren abgerissen. ");
INSERT INTO deu1912_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Und Aarons Söhne sollen's anzünden auf dem Altar zum Brandopfer, auf dem Holz, das auf dem Feuer liegt. Das ist ein Feuer zum süßen Geruch dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Will er aber dem HERRN ein Dankopfer von kleinem Vieh tun, es sei ein Widder oder Schaf, so soll's ohne Fehl sein. ");
INSERT INTO deu1912_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ist's ein Lämmlein, soll er's vor den HERRN bringen ");
INSERT INTO deu1912_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","und soll seine Hand auf desselben Haupt legen und es schlachten vor der Hütte des Stifts. Und die Söhne Aarons sollen sein Blut auf dem Altar umhersprengen. ");
INSERT INTO deu1912_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Und er soll also von dem Dankopfer dem HERRN opfern zum Feuer, nämlich sein Fett, den ganzen Schwanz, von dem Rücken abgerissen, dazu das Fett, welches das Eingeweide bedeckt, und alles Fett am Eingeweide, ");
INSERT INTO deu1912_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","die zwei Nieren mit dem Fett, das daran ist, an den Lenden, und das Netz um die Leber, an den Nieren abgerissen. ");
INSERT INTO deu1912_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Und der Priester soll es anzünden auf dem Altar zur Speise des Feuers dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ist aber sein Opfer eine Ziege und er bringt es vor den HERRN, ");
INSERT INTO deu1912_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","soll er seine Hand auf ihr Haupt legen und sie schlachten vor der Hütte des Stifts. Und die Söhne Aarons sollen das Blut auf dem Altar umhersprengen, ");
INSERT INTO deu1912_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","und er soll davon opfern ein Opfer dem HERRN, nämlich das Fett, welches die Eingeweide bedeckt, und alles Fett am Eingeweide, ");
INSERT INTO deu1912_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","die zwei Nieren mit dem Fett, das daran ist, an den Lenden, und das Netz über der Leber, an den Nieren abgerissen. ");
INSERT INTO deu1912_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Und der Priester soll's anzünden auf dem Altar zur Speise des Feuers zum süßen Geruch. Alles Fett ist des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Das sei eine ewige Sitte bei euren Nachkommen in allen Wohnungen, daß ihr kein Fett noch Blut esset. ");
INSERT INTO deu1912_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Rede mit den Kindern Israel und sprich: Wenn eine Seele sündigen würde aus Versehen an irgend einem Gebot des HERRN und täte, was sie nicht tun sollte: ");
INSERT INTO deu1912_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","nämlich so der Priester, der gesalbt ist, sündigen würde, daß er eine Schuld auf das Volk brächte, der soll für seine Sünde, die er getan hat, einen jungen Farren bringen, der ohne Fehl sei, dem HERRN zum Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Und soll den Farren vor die Tür der Hütte des Stifts bringen vor den HERRN und seine Hand auf desselben Haupt legen und ihn schlachten vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Und der Priester, der gesalbt ist, soll von des Farren Blut nehmen und es in die Hütte des Stifts bringen ");
INSERT INTO deu1912_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","und soll seinen Finger in das Blut tauchen und damit siebenmal sprengen vor dem HERRN, vor dem Vorhang im Heiligen. ");
INSERT INTO deu1912_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Und soll von dem Blut tun auf die Hörner des Räucheraltars, der vor dem HERRN in der Hütte des Stifts steht, und alles übrige Blut gießen an den Boden des Brandopferaltars, der vor der Tür der Hütte des Stifts steht. ");
INSERT INTO deu1912_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Und alles Fett des Sündopfers soll er abheben, nämlich das Fett, welches das Eingeweide bedeckt, und alles Fett am Eingeweide, ");
INSERT INTO deu1912_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","die zwei Nieren mit dem Fett, das daran ist, an den Lenden, und das Netz über der Leber, an den Nieren abgerissen, ");
INSERT INTO deu1912_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","gleichwie er's abhebt vom Ochsen im Dankopfer; und soll es anzünden auf dem Brandopferaltar. ");
INSERT INTO deu1912_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Aber das Fell des Farren mit allem Fleisch samt Kopf und Schenkeln und das Eingeweide und den Mist, ");
INSERT INTO deu1912_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","das soll er alles hinausführen aus dem Lager an eine reine Stätte, da man die Asche hin schüttet, und soll's verbrennen auf dem Holz mit Feuer. ");
INSERT INTO deu1912_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Wenn die ganze Gemeinde Israel etwas versehen würde und die Tat vor ihren Augen verborgen wäre, daß sie wider irgend ein Gebot des HERRN getan hätten, was sie nicht tun sollten, und also sich verschuldeten, ");
INSERT INTO deu1912_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","und darnach ihrer Sünde innewürden, die sie getan hätten, sollen sie einen jungen Farren darbringen zum Sündopfer und vor die Tür der Hütte des Stifts stellen. ");
INSERT INTO deu1912_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Und die Ältesten von der Gemeinde sollen ihre Hände auf sein Haupt legen vor dem HERRN und den Farren schlachten vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Und der Priester, der gesalbt ist, soll Blut vom Farren in die Hütte des Stifts bringen ");
INSERT INTO deu1912_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","und mit seinem Finger siebenmal sprengen vor dem HERRN vor dem Vorhang. ");
INSERT INTO deu1912_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Und soll von dem Blut auf die Hörner des Altars tun, der vor dem HERRN steht in der Hütte des Stifts, und alles andere Blut an den Boden des Brandopferaltars gießen, der vor der Tür der Hütte des Stifts steht. ");
INSERT INTO deu1912_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Alles sein Fett aber soll er abheben und auf dem Altar anzünden. ");
INSERT INTO deu1912_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Und soll mit dem Farren tun, wie er mit dem Farren des Sündopfers getan hat. Und soll also der Priester sie versöhnen, so wird's ihnen vergeben. ");
INSERT INTO deu1912_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Und soll den Farren hinaus vor das Lager tragen und verbrennen, wie er den vorigen Farren verbrannt hat. Das soll das Sündopfer der Gemeinde sein. ");
INSERT INTO deu1912_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Wenn aber ein Fürst sündigt und irgend etwas wider des HERRN, seines Gottes, Gebote tut, was er nicht tun sollte, und versieht etwas, daß er verschuldet, ");
INSERT INTO deu1912_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","und er wird seiner Sünde inne, die er getan hat, der soll zum Opfer bringen einen Ziegenbock ohne Fehl, ");
INSERT INTO deu1912_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","und seine Hand auf des Bockes Haupt legen und ihn schlachten an der Stätte, da man die Brandopfer schlachtet vor dem HERRN. Das sei sein Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Da soll denn der Priester von dem Blut des Sündopfers nehmen mit seinem Finger und es auf die Hörner des Brandopferaltars tun und das andere Blut an den Boden des Brandopferaltars gießen. ");
INSERT INTO deu1912_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Aber alles sein Fett soll er auf dem Altar anzünden gleich wie das Fett des Dankopfers. Und soll also der Priester seine Sünde versöhnen, so wird's ihm vergeben. ");
INSERT INTO deu1912_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Wenn aber eine Seele vom gemeinen Volk etwas versieht und sündigt, daß sie wider irgend eines der Gebote des HERRN tut, was sie nicht tun sollte, und sich also verschuldet, ");
INSERT INTO deu1912_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","und ihrer Sünde innewird, die sie getan hat, die soll zum Opfer eine Ziege bringen ohne Fehl für die Sünde, die sie getan hat, ");
INSERT INTO deu1912_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","und soll ihre Hand auf des Sündopfers Haupt legen und es schlachten an der Stätte des Brandopfers. ");
INSERT INTO deu1912_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Und der Priester soll von dem Blut mit seinem Finger nehmen und auf die Hörner des Altars des Brandopfers tun und alles andere Blut an des Altars Boden gießen. ");
INSERT INTO deu1912_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","All sein Fett aber soll er abreißen, wie er das Fett des Dankopfers abgerissen hat, und soll's anzünden auf dem Altar zum süßen Geruch dem HERRN. Und soll also der Priester sie versöhnen, so wird's ihr vergeben. ");
INSERT INTO deu1912_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Wird er aber ein Schaf zum Sündopfer bringen, so bringe er ein weibliches, das ohne Fehl ist, ");
INSERT INTO deu1912_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","und lege seine Hand auf des Sündopfers Haupt und schlachte es zum Sündopfer an der Stätte, da man die Brandopfer schlachtet. ");
INSERT INTO deu1912_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Und der Priester soll von dem Blut mit seinem Finger nehmen und auf die Hörner des Brandopferaltars tun und alles andere Blut an den Boden des Altars gießen. ");
INSERT INTO deu1912_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Aber all sein Fett soll er abreißen, wie er das Fett vom Schaf des Dankopfers abgerissen hat, und soll's auf dem Altar anzünden zum Feuer dem HERRN. Und soll also der Priester versöhnen seine Sünde, die er getan hat, so wird's ihm vergeben. ");
INSERT INTO deu1912_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Wenn jemand also sündigen würde, daß er den Fluch aussprechen hört und Zeuge ist, weil er's gesehen oder erfahren hat, es aber nicht ansagt, der ist einer Missetat schuldig. ");
INSERT INTO deu1912_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Oder wenn jemand etwas Unreines anrührt, es sei ein Aas eines unreinen Tieres oder Viehs oder Gewürms, und wüßte es nicht, der ist unrein und hat sich verschuldet. ");
INSERT INTO deu1912_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Oder wenn er einen unreinen Menschen anrührt, in was für Unreinigkeit der Mensch unrein werden kann, und wüßte es nicht und wird's inne, der hat sich verschuldet. ");
INSERT INTO deu1912_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Oder wenn jemand schwört, daß ihm aus dem Mund entfährt, Schaden oder Gutes zu tun (wie denn einem Menschen ein Schwur entfahren mag, ehe er's bedächte), und wird's inne, der hat sich an der einem verschuldet. ");
INSERT INTO deu1912_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Wenn's nun geschieht, daß er sich an einem verschuldet und bekennt, daß er daran gesündigt hat, ");
INSERT INTO deu1912_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","so soll er für seine Schuld dieser seiner Sünde, die er getan hat, dem HERRN bringen von der Herde eine Schaf-oder Ziegenmutter zum Sündopfer, so soll ihm der Priester seine Sünden versöhnen. ");
INSERT INTO deu1912_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Vermag er aber nicht ein Schaf, so bringe er dem HERRN für seine Schuld, die er getan hat, zwei Turteltauben oder zwei junge Tauben, die erste zum Sündopfer, die andere zum Brandopfer, ");
INSERT INTO deu1912_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","und bringe sie dem Priester. Der soll die erste zum Sündopfer machen, und ihr den Kopf abkneipen hinter dem Genick, und nicht abbrechen; ");
INSERT INTO deu1912_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","und sprenge mit dem Blut des Sündopfers an die Seite des Altars, und lasse das übrige Blut ausbluten an des Altars Boden. Das ist das Sündopfer, ");
INSERT INTO deu1912_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Die andere aber soll er zum Brandopfer machen, so wie es recht ist. Und soll also der Priester ihm seine Sünde versöhnen, die er getan hat, so wird's ihm vergeben. ");
INSERT INTO deu1912_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Vermag er aber nicht zwei Turteltauben oder zwei junge Tauben, so bringe er für seine Sünde als ein Opfer ein zehntel Epha Semmelmehl zum Sündopfer. Er soll aber kein Öl darauf legen noch Weihrauch darauf tun; denn es ist ein Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Und soll's zum Priester bringen. Der Priester aber soll eine Handvoll davon nehmen zum Gedächtnis und anzünden auf dem Altar zum Feuer dem HERRN. Das ist ein Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Und der Priester soll also seine Sünde, die er getan hat, ihm versöhnen, so wird's ihm vergeben. Und es soll dem Priester gehören wie ein Speisopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Wenn sich jemand vergreift, daß er es versieht und sich versündigt an dem, das dem HERRN geweiht ist, soll er ein Schuldopfer dem HERRN bringen, einen Widder ohne Fehl von der Herde, der zwei Silberlinge wert sei nach dem Lot des Heiligtums, zum Schuldopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Dazu was er gesündigt hat an dem Geweihten, soll er wiedergeben und den fünften Teil darüber geben, und soll's dem Priester geben; der soll ihn versöhnen mit dem Widder des Schuldopfers, so wird's ihm vergeben. ");
INSERT INTO deu1912_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Wenn jemand sündigt und tut wider irgend ein Gebot des HERRN, was er nicht tun sollte, und hat's nicht gewußt, der hat sich verschuldet und ist einer Missetat schuldig ");
INSERT INTO deu1912_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","und soll bringen einen Widder von der Herde ohne Fehl, der eines Schuldopfers wert ist, zum Priester; der soll ihm versöhnen, was er versehen hat und wußte es nicht, so wird's ihm vergeben. ");
INSERT INTO deu1912_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Das ist das Schuldopfer; verschuldet hat er sich an dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","5:20 Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","5:21 Wenn jemand sündigen würde und sich damit an dem Herrn vergreifen, daß er seinem Nebenmenschen ableugnet, was ihm dieser befohlen hat, oder was ihm zu treuer Hand getan ist, oder was er sich mit Gewalt genommen oder mit Unrecht an sich gebracht, ");
INSERT INTO deu1912_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","5:22 oder wenn er, was verloren ist, gefunden hat, und leugnet solches und tut einen falschen Eid über irgend etwas, darin ein Mensch wider seinen Nächsten Sünde tut; ");
INSERT INTO deu1912_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","5:23 wenn's nun geschieht, daß er also sündigt und sich verschuldet, so soll er wiedergeben, was er mit Gewalt genommen oder mit Unrecht an sich gebracht, oder was ihm befohlen ist, oder was er gefunden hat, ");
INSERT INTO deu1912_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","5:24 oder worüber er den falschen Eid getan hat; das soll er alles ganz wiedergeben, dazu den fünften Teil darüber geben dem, des es gewesen ist, des Tages, wenn er sein Schuldopfer gibt. ");
INSERT INTO deu1912_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","5:25 Aber für seine Schuld soll er dem HERRN zu dem Priester einen Widder von der Herde ohne Fehl bringen, der eines Schuldopfers wert ist. ");
INSERT INTO deu1912_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","5:26 So soll ihn der Priester versöhnen vor dem HERRN, so wird ihm vergeben alles, was er getan hat, darum er sich verschuldet hat. ");
INSERT INTO deu1912_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","6:1 Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","6:2 Gebiete Aaron und seinen Söhnen und sprich: Dies ist das Gesetz des Brandopfers. Das Brandopfer soll brennen auf dem Herd des Altars die ganze Nacht bis an den Morgen, und es soll des Altars Feuer brennend darauf erhalten werden. ");
INSERT INTO deu1912_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","6:3 Und der Priester soll seinen leinenen Rock anziehen und die leinenen Beinkleider an seinen Leib und soll die Asche aufheben, die das Feuer auf dem Altar gemacht hat, und soll sie neben den Altar schütten. ");
INSERT INTO deu1912_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","6:4 und soll seine Kleider darnach ausziehen und andere Kleider anziehen und die Asche hinaustragen aus dem Lager an eine reine Stätte. ");
INSERT INTO deu1912_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","6:5 Das Feuer auf dem Altar soll brennen und nimmer verlöschen; der Priester soll alle Morgen Holz darauf anzünden und obendarauf das Brandopfer zurichten und das Fett der Dankopfer darauf anzünden. ");
INSERT INTO deu1912_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","6:6 Ewig soll das Feuer auf dem Altar brennen und nimmer verlöschen. ");
INSERT INTO deu1912_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","6:7 Und das ist das Gesetz des Speisopfers, das Aarons Söhne opfern sollen vor dem HERRN auf dem Altar. ");
INSERT INTO deu1912_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","6:8 Es soll einer abheben eine Handvoll Semmelmehl vom Speisopfer und vom Öl und den ganzen Weihrauch, der auf dem Speisopfer liegt, und soll's anzünden auf dem Altar zum süßen Geruch, ein Gedächtnis dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","6:9 Das übrige aber sollen Aaron und seine Söhne verzehren und sollen's ungesäuert essen an heiliger Stätte, im Vorhof der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","6:10 Sie sollen's nicht mit Sauerteig backen; denn es ist ihr Teil, den ich ihnen gegeben habe von meinem Opfer. Es soll ihnen ein Hochheiliges sein gleichwie das Sündopfer und Schuldopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","6:11 Was männlich ist unter den Kindern Aarons, die sollen's essen. Das sei ein ewiges Recht euren Nachkommen an den Opfern des HERRN: es soll sie niemand anrühren, er sei den geweiht. ");
INSERT INTO deu1912_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","6:12 Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","6:13 Das soll das Opfer sein Aarons und seiner Söhne, das sie dem HERRN opfern sollen am Tage der Salbung: ein zehntel Epha Semmelmehl als tägliches Speisopfer, eine Hälfte des Morgens, die andere Hälfte des Abends. ");
INSERT INTO deu1912_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","6:14 In der Pfanne mit Öl sollst du es machen und geröstet darbringen; und in Stücken gebacken sollst du solches opfern zum süßen Geruch dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","6:15 Und der Priester, der unter seinen Söhnen an seiner Statt gesalbt wird, soll solches tun; das ist ein ewiges Recht. Es soll dem HERRN ganz verbrannt werden; ");
INSERT INTO deu1912_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","6:16 denn alles Speisopfer eines Priesters soll ganz verbrannt und nicht gegessen werden. ");
INSERT INTO deu1912_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","6:17 Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","6:18 Sage Aaron und seinen Söhnen und sprich: Dies ist das Gesetz des Sündopfers. An der Stätte, da du das Brandopfer schlachtest, sollst du auch das Sündopfer schlachten vor dem HERRN; das ist ein Hochheiliges. ");
INSERT INTO deu1912_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","6:19 Der Priester, der das Sündopfer tut, soll's essen an heiliger Stätte, im Vorhof der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","6:20 Niemand soll sein Fleisch anrühren, er sei denn geweiht. Und wer von seinem Blut ein Kleid besprengt, der soll das besprengte Stück waschen an heiliger Stätte. ");
INSERT INTO deu1912_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","6:21 Und den Topf, darin es gekocht ist, soll man zerbrechen. Ist's aber ein eherner Topf, so soll man ihn scheuern und mit Wasser spülen. ");
INSERT INTO deu1912_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","6:22 Was männlich ist unter den Priestern, die sollen davon essen; denn es ist ein Hochheiliges. ");
INSERT INTO deu1912_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","6:23 Aber all das Sündopfer, des Blut in die Hütte des Stifts gebracht wird, zu versöhnen im Heiligen, soll man nicht essen, sondern mit Feuer verbrennen. ");
INSERT INTO deu1912_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Und dies ist das Gesetz des Schuldopfers. Ein Hochheiliges ist es. ");
INSERT INTO deu1912_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","An der Stätte, da man das Brandopfer schlachtet, soll man auch das Schuldopfer schlachten und sein Blut auf dem Altar umhersprengen. ");
INSERT INTO deu1912_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Und all sein Fett soll man opfern, den Schwanz und das Fett, welches das Eingeweide bedeckt, ");
INSERT INTO deu1912_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","die zwei Nieren mit dem Fett, das daran ist, an den Lenden, und das Netz über der Leber, an den Nieren abgerissen. ");
INSERT INTO deu1912_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Und der Priester soll's auf dem Altar anzünden zum Feuer dem HERRN. Das ist ein Schuldopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Was männlich ist unter den Priestern, die sollen das essen an heiliger Stätte; denn es ist ein Hochheiliges. ");
INSERT INTO deu1912_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Wie das Sündopfer, also soll auch das Schuldopfer sein; aller beider soll einerlei Gesetz sein; und sollen dem Priester gehören, der dadurch versöhnt. ");
INSERT INTO deu1912_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Welcher Priester jemandes Brandopfer opfert, des soll des Brandopfers Fell sein, das er geopfert hat. ");
INSERT INTO deu1912_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Und alles Speisopfer, das im Ofen oder auf dem Rost oder in der Pfanne gebacken ist, soll dem Priester gehören, der es opfert. ");
INSERT INTO deu1912_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Und alles Speisopfer, das mit Öl gemengt oder trocken ist, soll aller Kinder Aarons sein, eines wie des andern. ");
INSERT INTO deu1912_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Und dies ist das Gesetz des Dankopfers, das man dem HERRN opfert. ");
INSERT INTO deu1912_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Wollen sie ein Lobopfer tun, so sollen sie ungesäuerte Kuchen opfern, mit Öl gemengt, oder ungesäuerte Fladen, mit Öl bestrichen, oder geröstete Semmelkuchen, mit Öl gemengt. ");
INSERT INTO deu1912_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Sie sollen aber solches Opfer tun auf Kuchen von gesäuerten Brot mit ihrem Lob- und Dankopfer, ");
INSERT INTO deu1912_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","und sollen einen von den allen dem HERRN zur Hebe opfern, und es soll dem Priester gehören, der das Blut des Dankopfers sprengt. ");
INSERT INTO deu1912_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Und das Fleisch ihres Lob- und Dankopfers soll desselben Tages gegessen werden, da es geopfert ist, und nichts übriggelassen werden bis an den Morgen. ");
INSERT INTO deu1912_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ist es aber ein Gelübde oder freiwilliges Opfer, so soll es desselben Tages, da es geopfert ist, gegessen werden; so aber etwas übrigbleibt auf den andern Tag, so soll man's doch essen. ");
INSERT INTO deu1912_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Aber was vom geopferten Fleisch übrigbleibt am dritten Tage, soll mit Feuer verbrannt werden. ");
INSERT INTO deu1912_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Und wo jemand am dritten Tage wird essen von dem geopferten Fleisch seines Dankopfers, so wird er nicht angenehm sein, der es geopfert hat; es wird ihm auch nicht zugerechnet werden, sondern es wird ein Greuel sein; und welche Seele davon essen wird, die ist einer Missetat schuldig. ");
INSERT INTO deu1912_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Und das Fleisch, das von etwas Unreinem berührt wird, soll nicht gegessen, sondern mit Feuer verbrannt werden. Wer reines Leibes ist, soll von dem Fleisch essen. ");
INSERT INTO deu1912_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Und welche Seele essen wird von dem Fleisch des Dankopfers, das dem HERRN zugehört, und hat eine Unreinigkeit an sich, die wird ausgerottet werden von ihrem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Und wenn eine Seele etwas Unreines anrührt, es sei ein unreiner Mensch, ein unreines Vieh oder sonst was greulich ist, und vom Fleisch des Dankopfers ißt, das dem HERRN zugehört, die wird ausgerottet werden von ihrem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Rede mit den Kindern Israel und sprich: Ihr sollt kein Fett essen von Ochsen, Lämmern und Ziegen. ");
INSERT INTO deu1912_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Aber das Fett vom Aas, und was vom Wild zerrissen ist, macht euch zu allerlei Nutz; aber essen sollt ihr's nicht. ");
INSERT INTO deu1912_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Denn wer das Fett ißt von dem Vieh, davon man dem HERRN Opfer bringt, dieselbe Seele soll ausgerottet werde von ihrem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ihr sollt auch kein Blut essen, weder vom Vieh noch von Vögeln, überall, wo ihr wohnt. ");
INSERT INTO deu1912_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Welche Seele würde irgend ein Blut essen, die soll ausgerottet werden von ihrem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Rede mit den Kindern Israel und sprich: Wer dem HERRN sein Dankopfer tun will, der soll darbringen, was vom Dankopfer dem HERRN gehört. ");
INSERT INTO deu1912_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Er soll's aber mit seiner Hand herzubringen zum Opfer des HERRN; nämlich das Fett soll er bringen samt der Brust, daß sie ein Webeopfer werden vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Und der Priester soll das Fett anzünden auf dem Altar, aber die Brust soll Aarons und seiner Söhne sein. ");
INSERT INTO deu1912_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Und die rechte Schulter sollen sie dem Priester geben zur Hebe von ihren Dankopfern. ");
INSERT INTO deu1912_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Und welcher unter Aarons Söhnen das Blut der Dankopfer opfert und das Fett, des soll die rechte Schulter sein zu seinem Teil. ");
INSERT INTO deu1912_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Denn die Webebrust und die Hebeschulter habe ich genommen von den Kindern Israel von ihren Dankopfern und habe sie dem Priester Aaron und seinen Söhnen gegeben zum ewigen Recht. ");
INSERT INTO deu1912_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Dies ist die Gebühr Aarons und seiner Söhne von den Opfern des HERRN, des Tages, da sie überantwortet wurden Priester zu sein dem HERRN, ");
INSERT INTO deu1912_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","die der HERR gebot am Tage, da er sie salbte, daß sie ihnen gegeben werden sollte von den Kindern Israel, zum ewigen Recht allen ihren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Dies ist das Gesetz des Brandopfers, des Speisopfers, des Sündopfers, des Schuldopfers, der Füllopfer und der Dankopfer, ");
INSERT INTO deu1912_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","das der HERR dem Mose gebot auf dem Berge Sinai des Tages, da er ihm gebot an die Kinder Israel, zu opfern ihre Opfer dem HERRN in der Wüste Sinai. ");
INSERT INTO deu1912_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Nimm Aaron und seine Söhne mit ihm samt ihren Kleidern und das Salböl und einen Farren zum Sündopfer, zwei Widder und einen Korb mit ungesäuertem Brot, ");
INSERT INTO deu1912_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","und versammle die ganze Gemeinde vor die Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mose tat, wie ihm der HERR gebot, und versammelte die Gemeinde vor die Tür der Hütte des Stifts ");
INSERT INTO deu1912_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","und sprach zu ihnen: Das ist's, was der HERR geboten hat zu tun. ");
INSERT INTO deu1912_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Und nahm Aaron und seine Söhne und wusch sie mit Wasser ");
INSERT INTO deu1912_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","und legte ihnen den leinenen Rock an und gürtete sie mit dem Gürtel und zog ihnen den Purpurrock an und tat ihm den Leibrock an und Gürtete ihn über den Leibrock her ");
INSERT INTO deu1912_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","und tat ihm das Amtschild an und das Schild Licht und Recht ");
INSERT INTO deu1912_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","und setzte ihm den Hut auf sein Haupt und setzte an den Hut oben an seiner Stirn das goldene Blatt der heiligen Krone, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Und Mose nahm das Salböl und salbte die Wohnung und alles, was darin war, und weihte es ");
INSERT INTO deu1912_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","und sprengte damit siebenmal auf den Altar und salbte den Altar mit allem seinem Geräte, das Handfaß mit seinem Fuß, daß es geweiht würde, ");
INSERT INTO deu1912_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","und goß von dem Salböl auf Aarons Haupt und salbte ihn, daß er geweiht würde, ");
INSERT INTO deu1912_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","und brachte herzu Aarons Söhne und zog ihnen leinene Röcke an und gürtete sie mit dem Gürtel und band ihnen Hauben auf, wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Und ließ herzuführen einen Farren zum Sündopfer. Und Aaron und seine Söhne legten ihre Hände auf sein Haupt. ");
INSERT INTO deu1912_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Da schlachtete er ihn. Und Mose nahm das Blut und tat's auf die Hörner des Altars umher mit seinem Finger und entsündigte den Altar und goß das Blut an des Altars Boden und weihte ihn, daß er ihn versöhnte. ");
INSERT INTO deu1912_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Und nahm alles Fett am Eingeweide, das Netz über der Leber und die zwei Nieren mit dem Fett daran, und zündete es an auf dem Altar. ");
INSERT INTO deu1912_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Aber den Farren mit seinem Fell, Fleisch und Mist verbrannte er mit Feuer draußen vor dem Lager, wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Und brachte herzu einen Widder zum Brandopfer. Und Aaron und seine Söhne legten ihre Hände auf sein Haupt. ");
INSERT INTO deu1912_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Da schlachtete er ihn. Und Mose sprengte das Blut auf den Altar umher, ");
INSERT INTO deu1912_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","zerhieb den Widder in Stücke und zündete an das Haupt, die Stücke und das Fett ");
INSERT INTO deu1912_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","und wusch die Eingeweide und Schenkel mit Wasser und zündete also den ganzen Widder an auf dem Altar. Das war ein Brandopfer zum süßen Geruch, ein Feuer dem HERRN, wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Er brachte auch herzu den andern Widder des Füllopfers. Und Aaron und seine Söhne legten ihre Hände auf sein Haupt. ");
INSERT INTO deu1912_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Da schlachtete er ihn. Und Mose nahm von seinem Blut und tat's Aaron auf den Knorpel seines rechten Ohrs und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes. ");
INSERT INTO deu1912_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Und brachte herzu Aarons Söhne und tat von dem Blut auf den Knorpel des rechten Ohrs und auf den Daumen ihrer rechten Hand und auf die große Zehe ihres rechten Fußes und sprengte das Blut auf den Altar umher. ");
INSERT INTO deu1912_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Und nahm das Fett und den Schwanz und alles Fett am Eingeweide und das Netz über der Leber, die zwei Nieren mit dem Fett daran und die rechte Schulter; ");
INSERT INTO deu1912_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","dazu nahm er von dem Korb des ungesäuerten Brots vor dem HERRN einen ungesäuerten Kuchen und einen Kuchen geölten Brots und einen Fladen und legte es auf das Fett und auf die rechte Schulter. ");
INSERT INTO deu1912_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Und gab das allesamt auf die Hände Aarons und seiner Söhne und webte es zum Webeopfer vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Und nahm alles wieder von ihren Händen und zündete es an auf dem Altar oben auf dem Brandopfer. Ein Füllopfer war es zum süßen Geruch, ein Feuer dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Und Mose nahm die Brust und webte ein Webeopfer vor dem HERRN von dem Widder des Füllopfers; der ward Mose zu seinem Teil, wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Und Mose nahm von dem Salböl und dem Blut auf dem Altar und sprengte es auf Aaron und seine Kleider, auf seine Söhne und ihre Kleider, und weihte also Aaron und seine Kleider, seine Söhne und ihre Kleider mit ihm. ");
INSERT INTO deu1912_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Und sprach zu Aaron und seinen Söhnen: Kochet das Fleisch vor der Tür der Hütte des Stifts, und esset es daselbst, dazu auch das Brot im Korbe des Füllopfers, wie mir geboten ist und gesagt, daß Aaron und seine Söhne es essen sollen. ");
INSERT INTO deu1912_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Was aber übrigbleibt vom Fleisch und Brot, das sollt ihr mit Feuer verbrennen. ");
INSERT INTO deu1912_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Und sollt in sieben Tagen nicht ausgehen von der Tür der Hütte des Stifts bis an den Tag, da die Tage eures Füllopfers aus sind; denn sieben Tage sind eure Hände gefüllt, ");
INSERT INTO deu1912_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","wie es an diesem Tage geschehen ist; der HERR hat's geboten zu tun, auf daß ihr versöhnt seid. ");
INSERT INTO deu1912_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Und sollt vor der Tür der Hütte des Stifts Tag und Nacht bleiben sieben Tage lang und sollt nach dem Gebot des HERRN tun, daß ihr nicht sterbet; denn also ist mir's geboten. ");
INSERT INTO deu1912_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Und Aaron und seine Söhne taten alles, was ihnen der HERR geboten hatte durch Mose. ");
INSERT INTO deu1912_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Und am achten Tage rief Mose Aaron und seine Söhne und die Ältesten in Israel ");
INSERT INTO deu1912_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","und sprach zu Aaron: Nimm zu dir ein junges Kalb zum Sündopfer und einen Widder zum Brandopfer, beide ohne Fehl, und bringe sie vor den Herrn. ");
INSERT INTO deu1912_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Und rede mit den Kindern Israel und sprich: Nehmt einen Ziegenbock zum Sündopfer und ein Kalb und ein Schaf, beide ein Jahr alt und ohne Fehl, zum Brandopfer ");
INSERT INTO deu1912_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","und einen Ochsen und einen Widder zum Dankopfer, daß wir dem HERRN opfern, und ein Speisopfer, mit Öl gemengt. Denn heute wird euch der HERR erscheinen. ");
INSERT INTO deu1912_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Und sie nahmen, was Mose geboten hatte, vor der Tür der Hütte des Stifts; und es trat herzu die ganze Gemeinde und stand vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Da sprach Mose: Das ist's, was der HERR geboten hat, daß ihr es tun sollt, so wird euch des HERRN Herrlichkeit erscheinen. ");
INSERT INTO deu1912_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Und Mose sprach zu Aaron: Tritt zum Altar und mache dein Sündopfer und dein Brandopfer und versöhne dich und das Volk; darnach mache des Volkes Opfer und versöhne sie auch, wie der HERR geboten hat. ");
INSERT INTO deu1912_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Und Aaron trat zum Altar und schlachtete das Kalb zu seinem Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Und seine Söhne brachten das Blut zu ihm, und er tauchte mit seinem Finger ins Blut und tat's auf die Hörner des Altars und goß das Blut an des Altars Boden. ");
INSERT INTO deu1912_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Aber das Fett und die Nieren und das Netz von der Leber am Sündopfer zündete er an auf dem Altar, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Und das Fleisch und das Fell verbrannte er mit Feuer draußen vor dem Lager. ");
INSERT INTO deu1912_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Darnach schlachtete er das Brandopfer; und Aarons Söhne brachten das Blut zu ihm, und er sprengte es auf den Altar umher. ");
INSERT INTO deu1912_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Und sie brachten das Brandopfer zu ihm zerstückt und den Kopf; und er zündete es an auf dem Altar. ");
INSERT INTO deu1912_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Und er wusch das Eingeweide und die Schenkel und zündete es an oben auf dem Brandopfer auf dem Altar. ");
INSERT INTO deu1912_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Darnach brachte er herzu des Volks Opfer und nahm den Bock, das Sündopfer des Volks, und schlachtete ihn und machte ein Sündopfer daraus wie das vorige. ");
INSERT INTO deu1912_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Und brachte das Brandopfer herzu und tat damit, wie es recht war. ");
INSERT INTO deu1912_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Und brachte herzu das Speisopfer und nahm seine Hand voll und zündete es an auf dem Altar, außer dem Morgenbrandopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Darnach schlachtete er den Ochsen und den Widder zum Dankopfer des Volks; und seine Söhne brachten ihm das Blut, das sprengte er auf dem Altar umher. ");
INSERT INTO deu1912_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Aber das Fett vom Ochsen und vom Widder, den Schwanz und das Fett am Eingeweide und die Nieren und das Netz über der Leber: ");
INSERT INTO deu1912_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","alles solches Fett legten sie auf die Brust; und er zündete das Fett an auf dem Altar. ");
INSERT INTO deu1912_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aber die Brust und die rechte Schulter webte Aaron zum Webopfer vor dem HERRN, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Und Aaron hob seine Hand auf zum Volk und segnete sie; und er stieg herab, da er das Sündopfer, Brandopfer und Dankopfer gemacht hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Und Mose und Aaron gingen in die Hütte des Stifts; und da sie wieder herausgingen, segneten sie das Volk. Da erschien die Herrlichkeit des HERRN allem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Und ein Feuer ging aus von dem HERRN und verzehrte auf dem Altar das Brandopfer und das Fett. Da das alles Volk sah, frohlockten sie und fielen auf ihr Antlitz. ");
INSERT INTO deu1912_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Und die Söhne Aarons Nadab und Abihu nahmen ein jeglicher seinen Napf und taten Feuer darein und legten Räuchwerk darauf und brachten das fremde Feuer vor den HERRN, das er ihnen nicht geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Da fuhr ein Feuer aus von dem HERRN und verzehrte sie, daß sie starben vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Da sprach Mose zu Aaron: Das ist's, was der HERR gesagt hat: Ich erzeige mich heilig an denen, die mir nahe sind, und vor allem Volk erweise ich mich herrlich. Und Aaron schwieg still. ");
INSERT INTO deu1912_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mose aber rief Misael und Elzaphan, die Söhne Usiels, Aarons Vettern, und sprach zu ihnen: Tretet hinzu und traget eure Brüder von dem Heiligtum hinaus vor das Lager. ");
INSERT INTO deu1912_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Und sie traten hinzu und trugen sie hinaus mit ihren leinenen Röcken vor das Lager, wie Mose gesagt hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Da sprach Mose zu Aaron und seinen Söhnen Eleasar und Ithamar: Ihr sollt eure Häupter nicht entblößen noch eure Kleider zerreißen, daß ihr nicht sterbet und der Zorn über die ganze Gemeinde komme. Laßt eure Brüder, das ganze Haus Israel, weinen über diesen Brand, den der HERR getan hat. ");
INSERT INTO deu1912_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ihr aber sollt nicht ausgehen von der Tür der Hütte des Stifts, ihr möchtet sterben; denn das Salböl des HERRN ist auf euch. Und sie taten, wie Mose sagte. ");
INSERT INTO deu1912_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Der HERR aber redete mit Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Du und deine Söhne mit dir sollt keinen Wein noch starkes Getränk trinken, wenn ihr in die Hütte des Stifts geht, auf daß ihr nicht sterbet. Das sei ein ewiges Recht allen euren Nachkommen, ");
INSERT INTO deu1912_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","auf daß ihr könnt unterscheiden, was heilig und unheilig, was rein und unrein ist, ");
INSERT INTO deu1912_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","und daß ihr die Kinder Israel lehret alle Rechte, die der HERR zu ihnen geredet hat durch Mose. ");
INSERT INTO deu1912_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Und Mose redete mit Aaron und mit seinen noch übrigen Söhnen, Eleasar und Ithamar: Nehmet, was übriggeblieben ist vom Speisopfer an den Opfern des HERRN, und esset's ungesäuert bei dem Altar; denn es ist ein Hochheiliges. ");
INSERT INTO deu1912_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ihr sollt's aber an heiliger Stätte essen; denn das ist dein Recht und deiner Söhne Recht an den Opfern des HERRN; denn so ist's mir geboten. ");
INSERT INTO deu1912_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Aber die Webebrust und die Hebeschulter sollst du und deine Söhne und deine Töchter mit dir essen an reiner Stätte; denn solch Recht ist dir und deinen Kindern gegeben an den Dankopfern der Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Denn die Hebeschulter und die Webebrust soll man zu den Opfern des Fetts bringen, daß sie zum Webeopfer gewebt werden vor dem HERRN; darum ist's dein und deiner Kinder zum ewigen Recht, wie der HERR geboten hat. ");
INSERT INTO deu1912_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Und Mose suchte den Bock des Sündopfers, und fand ihn verbrannt, Und er ward zornig über Eleasar und Ithamar, Aarons Söhne, die noch übrig waren, und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Warum habt ihr das Sündopfer nicht gegessen an heiliger Stätte? denn es ist ein Hochheiliges, und er hat's euch gegeben, daß ihr die Missetat der Gemeinde tragen sollt, daß ihr sie versöhnet vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Siehe, sein Blut ist nicht gekommen in das Heilige hinein. Ihr solltet es im Heiligen gegessen haben, wie mir geboten ist. ");
INSERT INTO deu1912_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron aber sprach zu Mose: Siehe, heute haben sie ihr Sündopfer und ihr Brandopfer vor dem HERRN geopfert, und es ist mir also gegangen, wie du siehst; und ich sollte essen heute vom Sündopfer? Sollte das dem HERRN gefallen? ");
INSERT INTO deu1912_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Da das Mose hörte, ließ er's sich gefallen. ");
INSERT INTO deu1912_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Und der HERR redete mit Mose und Aaron und sprach zu ihnen: ");
INSERT INTO deu1912_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Redet mit den Kindern Israel und sprecht: Das sind die Tiere, die ihr essen sollt unter allen Tieren auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Alles, was die Klauen spaltet und wiederkäut unter den Tieren, das sollt ihr essen. ");
INSERT INTO deu1912_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Was aber wiederkäut und hat Klauen und spaltet sie doch nicht, wie das Kamel, das ist euch unrein, und ihr sollt's nicht essen. ");
INSERT INTO deu1912_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Die Kaninchen wiederkäuen wohl, aber sie spalten die Klauen nicht; darum sind sie unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Der Hase wiederkäut auch, aber er spaltet die Klauen nicht; darum ist er euch unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Und ein Schwein spaltet wohl die Klauen, aber es wiederkäut nicht; darum soll's euch unrein sein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Von dieser Fleisch sollt ihr nicht essen noch ihr Aas anrühren; denn sie sind euch unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Dies sollt ihr essen unter dem, was in Wassern ist: alles, was Floßfedern und Schuppen hat in Wassern, im Meer und in Bächen, sollt ihr essen. ");
INSERT INTO deu1912_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Alles aber, was nicht Floßfedern und Schuppen hat im Meer und in Bächen, unter allem, was sich regt in Wassern, und allem, was lebt im Wasser, soll euch eine Scheu sein, ");
INSERT INTO deu1912_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","daß ihr von ihrem Fleisch nicht eßt und vor ihrem Aas euch scheut. ");
INSERT INTO deu1912_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Denn alles, was nicht Floßfedern und Schuppen hat in Wassern, sollt ihr scheuen. ");
INSERT INTO deu1912_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Und dies sollt ihr scheuen unter den Vögeln, daß ihr's nicht eßt: den Adler, den Habicht, den Fischaar, ");
INSERT INTO deu1912_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","den Geier, den Weih, und was seine Art ist, ");
INSERT INTO deu1912_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","und alle Raben mit ihrer Art, ");
INSERT INTO deu1912_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","den Strauß, die Nachteule, den Kuckuck, den Sperber mit seiner Art, ");
INSERT INTO deu1912_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","das Käuzlein, den Schwan, den Uhu, ");
INSERT INTO deu1912_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","die Fledermaus, die Rohrdommel, ");
INSERT INTO deu1912_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","den Storch, den Reiher, den Häher mit seiner Art, den Wiedehopf und die Schwalbe. ");
INSERT INTO deu1912_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alles auch, was sich regt und Flügel hat und geht auf vier Füßen, das soll euch eine Scheu sein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Doch das sollt ihr essen von allem, was sich regt und Flügel hat und geht auf vier Füßen: was noch zwei Beine hat, womit es auf Erden hüpft; ");
INSERT INTO deu1912_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","von demselben mögt ihr essen die Heuschrecken, als da ist: Arbe mit seiner Art und Solam mit seiner Art und Hargol mit seiner Art und Hagab mit seiner Art. ");
INSERT INTO deu1912_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Aber alles, was sonst Flügel und vier Füße hat, soll euch eine Scheu sein, ");
INSERT INTO deu1912_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","und sollt sie unrein achten. Wer solcher Aas anrührt, der wird unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Und wer dieser Aase eines tragen wird, soll seine Kleider waschen und wird unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Darum alles Getier, das Klauen hat und spaltet sie nicht und wiederkäuet nicht, das soll euch unrein sein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Und alles, was auf Tatzen geht unter den Tieren, die auf vier Füßen gehen, soll euch unrein sein; wer ihr Aas anrührt, wird unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Und wer ihr Aas trägt, soll seine Kleider waschen und unrein sein bis auf den Abend; denn solche sind euch unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Diese sollen euch auch unrein sein unter den Tieren, die auf Erden kriechen: das Wiesel, die Maus, die Kröte, ein jegliches mit seiner Art, ");
INSERT INTO deu1912_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","der Igel, der Molch, die Eidechse, die Blindschleiche und der Maulwurf; ");
INSERT INTO deu1912_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","die sind euch unrein unter allem, was da kriecht; wer ihr Aas anrührt, der wird unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Und alles, worauf ein solch totes Aas fällt, das wird unrein, es sei allerlei hölzernes Gefäß oder Kleider oder Fell oder Sack; und alles Gerät, womit man etwas schafft, soll man ins Wasser tun, und es ist unrein bis auf den Abend; alsdann wird's rein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Allerlei irdenes Gefäß, wo solcher Aas hineinfällt, wird alles unrein, was darin ist; und sollt's zerbrechen. ");
INSERT INTO deu1912_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Alle Speise, die man ißt, so solch Wasser hineinkommt, ist unrein; und aller Trank, den man trinkt in allerlei solchem Gefäß, ist unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Und alles, worauf solches Aas fällt, wird unrein, es sei ein Ofen oder Kessel, so soll man's zerbrechen; denn es ist unrein und soll euch unrein sein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Doch die Brunnen und Gruben und Teiche bleiben rein. Wer aber ihr Aas anrührt, ist unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Und ob solch ein Aas fiele auf Samen, den man sät, so ist er doch rein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Wenn man aber Wasser über den Samen gösse, und fiele darnach ein solch Aas darauf, so würde er euch unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Wenn ein Tier stirbt, das ihr essen mögt: wer das Aas anrührt, der ist unrein bis an den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Wer von solchem Aas ißt, der soll sein Kleid waschen und wird unrein sein bis an den Abend. Also wer auch trägt ein solch Aas, soll sein Kleid waschen, und ist unrein bis an den Abend ");
INSERT INTO deu1912_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Was auf Erden schleicht, das soll euch eine Scheu sein, und man soll's nicht essen. ");
INSERT INTO deu1912_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Alles, was auf dem Bauch kriecht, und alles, was auf vier oder mehr Füßen geht, unter allem, was auf Erden schleicht, sollt ihr nicht essen; denn es soll euch eine Scheu sein. ");
INSERT INTO deu1912_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Macht eure Seelen nicht zum Scheusal und verunreinigt euch nicht an ihnen, daß ihr euch besudelt. ");
INSERT INTO deu1912_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Denn ich bin der HERR, euer Gott. Darum sollt ihr euch heiligen, daß ihr heilig seid, denn ich bin heilig, und sollt eure Seelen nicht verunreinigen an irgend einem kriechenden Tier, das auf Erden schleicht. ");
INSERT INTO deu1912_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Denn ich bin der HERR, der euch aus Ägyptenland geführt hat, daß ich euer Gott sei. Darum sollt ihr heilig sein, denn ich bin heilig. ");
INSERT INTO deu1912_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Dies ist das Gesetz von den Tieren und Vögeln und allerlei Tieren, die sich regen im Wasser, und allerlei Tieren, die auf Erden schleichen, ");
INSERT INTO deu1912_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","daß ihr unterscheiden könnt, was unrein und rein ist, und welches Tier man essen und welches man nicht essen soll. ");
INSERT INTO deu1912_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Rede mit den Kindern Israel und sprich: Wenn ein Weib empfängt und gebiert ein Knäblein, so soll sie sieben Tage unrein sein, wie wenn sie ihre Krankheit leidet. ");
INSERT INTO deu1912_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Und am achten Tage soll man das Fleisch seiner Vorhaut beschneiden. ");
INSERT INTO deu1912_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Und sie soll daheimbleiben dreiunddreißig Tage im Blut ihrer Reinigung. Kein Heiliges soll sie anrühren, und zum Heiligtum soll sie nicht kommen, bis daß die Tage ihrer Reinigung aus sind. ");
INSERT INTO deu1912_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Gebiert sie aber ein Mägdlein, so soll sie zwei Wochen unrein sein, wie wenn sie ihre Krankheit leidet, und soll sechsundsechzig Tage daheimbleiben in dem Blut ihrer Reinigung. ");
INSERT INTO deu1912_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Und wenn die Tage ihrer Reinigung aus sind für den Sohn oder für die Tochter, soll sie ein jähriges Lamm bringen zum Brandopfer und eine junge Taube oder Turteltaube zum Sündopfer dem Priester vor die Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Der soll es opfern vor dem HERRN und sie versöhnen, so wird sie rein von ihrem Blutgang. Das ist das Gesetz für die, so ein Knäblein oder Mägdlein gebiert. ");
INSERT INTO deu1912_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Vermag aber ihre Hand nicht ein Schaf, so nehme sie zwei Turteltauben oder zwei junge Tauben, eine zum Brandopfer, die andere zum Sündopfer; so soll sie der Priester versöhnen, daß sie rein werde. ");
INSERT INTO deu1912_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Wenn einem Menschen an der Haut seines Fleisches etwas auffährt oder ausschlägt oder eiterweiß wird, als wollte ein Aussatz werden an der Haut seines Fleisches, soll man ihn zum Priester Aaron führen oder zu einem unter seinen Söhnen, den Priestern. ");
INSERT INTO deu1912_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Und wenn der Priester das Mal an der Haut des Fleisches sieht, daß die Haare in Weiß verwandelt sind und das Ansehen an dem Ort tiefer ist denn die andere Haut seines Fleisches, so ist's gewiß der Aussatz. Darum soll ihn der Priester besehen und für unrein urteilen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Wenn aber etwas eiterweiß ist an der Haut des Fleisches, und doch das Ansehen der Haut nicht tiefer denn die andere Haut des Fleisches und die Haare nicht in Weiß verwandelt sind, so soll der Priester ihn verschließen sieben Tage ");
INSERT INTO deu1912_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","und am siebenten Tage besehen. Ist's, daß das Mal bleibt, wie er's zuvor gesehen hat, und hat nicht weitergefressen an der Haut, ");
INSERT INTO deu1912_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","so soll ihn der Priester abermals sieben Tage verschließen. Und wenn er ihn zum andermal am siebenten Tage besieht und findet, daß das Mal verschwunden ist und nicht weitergefressen hat an der Haut, so soll er ihn rein urteilen; denn es ist ein Grind. Und er soll seine Kleider waschen, so ist er rein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Wenn aber der Grind weiterfrißt in der Haut, nachdem er vom Priester besehen worden ist, ob er rein sei, und wird nun zum andernmal vom Priester besehen, ");
INSERT INTO deu1912_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","wenn dann da der Priester sieht, daß der Grind weitergefressen hat in der Haut, so soll er ihn unrein urteilen; denn es ist gewiß Aussatz. ");
INSERT INTO deu1912_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Wenn ein Mal des Aussatzes an einem Menschen sein wird, den soll man zum Priester bringen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Wenn derselbe sieht und findet, daß Weißes aufgefahren ist an der Haut und die Haare in Weiß verwandelt und rohes Fleisch im Geschwür ist, ");
INSERT INTO deu1912_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","so ist's gewiß ein alter Aussatz in der Haut des Fleisches. Darum soll ihn der Priester unrein urteilen und nicht verschließen; denn er ist schon unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Wenn aber der Aussatz blüht in der Haut und bedeckt die ganze Haut, von dem Haupt bis auf die Füße, alles, was dem Priester vor Augen sein mag, ");
INSERT INTO deu1912_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","wenn dann der Priester besieht und findet, daß der Aussatz das ganze Fleisch bedeckt hat, so soll er denselben rein urteilen, dieweil es alles an ihm in Weiß verwandelt ist; denn er ist rein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ist aber rohes Fleisch da des Tages, wenn er besehen wird, so ist er unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Und wenn der Priester das rohe Fleisch sieht, soll er ihn unrein urteilen; denn das rohe Fleisch ist unrein, und es ist gewiß Aussatz. ");
INSERT INTO deu1912_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Verkehrt sich aber das rohe Fleisch wieder und verwandelt sich in Weiß, so soll er zum Priester kommen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Und wenn der Priester besieht und findet, daß das Mal ist in Weiß verwandelt, soll er ihn rein urteilen; denn er ist rein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Wenn jemandes Fleisch an der Haut eine Drüse wird und wieder heilt, ");
INSERT INTO deu1912_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","darnach an demselben Ort etwas Weißes auffährt oder rötliches Eiterweiß wird, soll er vom Priester besehen werden. ");
INSERT INTO deu1912_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Wenn dann der Priester sieht, daß das Ansehen tiefer ist denn die andere Haut und das Haar in Weiß verwandelt, so soll er ihn unrein urteilen; denn es ist gewiß ein Aussatzmal aus der Drüse geworden. ");
INSERT INTO deu1912_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Sieht aber der Priester und findet, daß die Haare nicht weiß sind und es ist nicht tiefer denn die andere Haut und ist verschwunden, so soll er ihn sieben Tage verschließen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Frißt es weiter in der Haut, so soll er unrein urteilen; denn es ist gewiß ein Aussatzmal. ");
INSERT INTO deu1912_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Bleibt aber das Eiterweiß also stehen und frißt nicht weiter, so ist's die Narbe von der Drüse, und der Priester soll ihn rein urteilen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Wenn sich jemand an der Haut am Feuer brennt und das Brandmal weißrötlich oder weiß ist ");
INSERT INTO deu1912_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","und der Priester ihn besieht und findet das Haar in Weiß verwandelt an dem Brandmal und das Ansehen tiefer denn die andere Haut, so ist's gewiß Aussatz, aus dem Brandmal geworden. Darum soll ihn der Priester unrein urteilen; denn es ist ein Aussatzmal. ");
INSERT INTO deu1912_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Sieht aber der Priester und findet, daß die Haare am Brandmal nicht in Weiß verwandelt und es nicht tiefer ist denn die andere Haut und ist dazu verschwunden, soll er ihn sieben Tage verschließen; ");
INSERT INTO deu1912_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","und am siebenten Tage soll er ihn besehen. Hat's weitergefressen an der Haut, so soll er unrein urteilen; denn es ist Aussatz. ");
INSERT INTO deu1912_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ist's aber gestanden an dem Brandmal und hat nicht weitergefressen an der Haut und ist dazu verschwunden, so ist's ein Geschwür des Brandmals. Und der Priester soll ihn rein urteilen; denn es ist die Narbe des Brandmals. ");
INSERT INTO deu1912_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Wenn ein Mann oder Weib auf dem Haupt oder am Bart ein Mal hat ");
INSERT INTO deu1912_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","und der Priester das Mal besieht und findet, daß das Ansehen der Haut tiefer ist denn die andere Haut und das Haar daselbst golden und dünn, so soll er ihn unrein urteilen; denn es ist ein aussätziger Grind des Hauptes oder des Bartes. ");
INSERT INTO deu1912_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Sieht aber der Priester, daß der Grind nicht tiefer anzusehen ist denn die andere Haut und das Haar nicht dunkel ist, soll er denselben sieben Tage verschließen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Und wenn er am siebenten Tage besieht und findet, daß der Grind nicht weitergefressen hat und kein goldenes Haar da ist und das Ansehen des Grindes nicht tiefer ist denn die andere Haut, ");
INSERT INTO deu1912_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","soll er sich scheren, doch daß er den Grind nicht beschere; und soll ihn der Priester abermals sieben Tage verschließen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Und wenn er ihn am siebenten Tage besieht und findet, daß der Grind nicht weitergefressen hat in der Haut und das Ansehen ist nicht tiefer als die andere Haut, so soll er ihn rein sprechen, und er soll seine Kleider waschen; denn er ist rein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Frißt aber der Grind weiter an der Haut, nachdem er rein gesprochen ist, ");
INSERT INTO deu1912_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","und der Priester besieht und findet, daß der Grind also weitergefressen hat an der Haut, so soll er nicht mehr darnach fragen, ob die Haare golden sind; denn er ist unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ist aber vor Augen der Grind stillgestanden und dunkles Haar daselbst aufgegangen, so ist der Grind heil und er rein. Darum soll ihn der Priester rein sprechen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Wenn einem Mann oder Weib an der Haut ihres Fleisches etwas eiterweiß ist ");
INSERT INTO deu1912_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","und der Priester sieht daselbst, daß das Eiterweiß schwindet, das ist ein weißer Grind, in der Haut aufgegangen, und er ist rein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Wenn einem Manne die Haupthaare ausfallen, daß er kahl wird, der ist rein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Fallen sie ihm vorn am Haupt aus und wird eine Glatze, so ist er rein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Wird aber an der Glatze, oder wo er kahl ist, ein weißes oder rötliches Mal, so ist ihm Aussatz an der Glatze oder am Kahlkopf aufgegangen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Darum soll ihn der Priester besehen. Und wenn er findet, daß ein weißes oder rötliches Mal aufgelaufen an seiner Glatze oder am Kahlkopf, daß es sieht, wie sonst der Aussatz an der Haut, ");
INSERT INTO deu1912_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","so ist er aussätzig und unrein; und der Priester soll ihn unrein sprechen solches Mals halben auf seinem Haupt. ");
INSERT INTO deu1912_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Wer nun aussätzig ist, des Kleider sollen zerrissen sein und das Haupt bloß und die Lippen verhüllt und er soll rufen: Unrein, unrein! ");
INSERT INTO deu1912_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Und solange das Mal an ihm ist, soll er unrein sein, allein wohnen und seine Wohnung soll außerhalb des Lagers sein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Wenn an einem Kleid ein Aussatzmal sein wird, es sei wollen oder leinen, ");
INSERT INTO deu1912_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","am Aufzug oder am Eintrag, es sei wollen oder leinen, oder an einem Fell oder an allem, was aus Fellen gemacht wird, ");
INSERT INTO deu1912_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","und wenn das Mal grünlich oder rötlich ist am Kleid oder am Fell oder am Aufzug oder am Eintrag oder an irgend einem Ding, das von Fellen gemacht ist, das ist gewiß ein Mal des Aussatzes; darum soll's der Priester besehen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Und wenn er das Mal sieht, soll er's einschließen sieben Tage. ");
INSERT INTO deu1912_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Und wenn er am siebenten Tage sieht, daß das Mal hat weitergefressen am Kleid, am Aufzug oder am Eintrag, am Fell oder an allem, was man aus Fellen macht, so ist das Mal ein fressender Aussatz, und es ist unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Und man soll das Kleid verbrennen oder den Aufzug oder den Eintrag, es sei wollen oder leinen oder allerlei Fellwerk, darin solch ein Mal ist; denn es ist fressender Aussatz, und man soll es mit Feuer verbrennen. ");
INSERT INTO deu1912_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Wird aber der Priester sehen, daß das Mal nicht weitergefressen hat am Kleid oder am Aufzug oder am Eintrag oder an allerlei Fellwerk, ");
INSERT INTO deu1912_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","so soll er gebieten, daß man solches wasche, worin solches Mal ist, und soll's einschließen andere sieben Tage. ");
INSERT INTO deu1912_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Und wenn der Priester sehen wird, nachdem das Mal gewaschen ist, daß das Mal nicht verwandelt ist vor seinen Augen und auch nicht weitergefressen hat, so ist's unrein, und sollst es mit Feuer verbrennen; denn es ist tief eingefressen und hat's vorn oder hinten schäbig gemacht. ");
INSERT INTO deu1912_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Wenn aber der Priester sieht, daß das Mal verschwunden ist nach seinem Waschen, so soll er's abreißen vom Kleid, vom Fell, von Aufzug oder vom Eintrag. ");
INSERT INTO deu1912_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Wird's aber noch gesehen am Kleid, am Aufzug, am Eintrag oder allerlei Fellwerk, so ist's ein Aussatzmal, und sollst das mit Feuer verbrennen, worin solch Mal ist. ");
INSERT INTO deu1912_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Das Kleid aber oder der Aufzug oder Eintrag oder allerlei Fellwerk, das gewaschen und von dem das Mal entfernt ist, soll man zum andernmal waschen, so ist's rein. ");
INSERT INTO deu1912_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Das ist das Gesetz über die Male des Aussatzes an Kleidern, sie seien wollen oder leinen, am Aufzug und am Eintrag und allerlei Fellwerk, rein oder unrein zu sprechen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Das ist das Gesetz über den Aussätzigen, wenn er soll gereinigt werden. Er soll zum Priester kommen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Und der Priester soll aus dem Lager gehen und besehen, wie das Mal des Aussatzes am Aussätzigen heil geworden ist, ");
INSERT INTO deu1912_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","und soll gebieten dem, der zu reinigen ist, daß er zwei lebendige Vögel nehme, die da rein sind, und Zedernholz und scharlachfarbene Wolle und Isop. ");
INSERT INTO deu1912_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Und soll gebieten, den einen Vogel zu schlachten in ein irdenes Gefäß über frischem Wasser. ");
INSERT INTO deu1912_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Und soll den lebendigen Vogel nehmen mit dem Zedernholz, scharlachfarbener Wolle und Isop und in des Vogels Blut tauchen, der über dem frischen Wasser geschlachtet ist, ");
INSERT INTO deu1912_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","und besprengen den, der vom Aussatz zu reinigen ist, siebenmal; und reinige ihn also und lasse den lebendigen Vogel ins freie Feld fliegen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Der Gereinigte aber soll seine Kleider waschen und alle seine Haare abscheren und sich mit Wasser baden, so ist er rein. Darnach gehe er ins Lager; doch soll er außerhalb seiner Hütte sieben Tage bleiben. ");
INSERT INTO deu1912_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Und am siebenten Tage soll er alle seine Haare abscheren auf dem Haupt, am Bart, an den Augenbrauen, daß alle Haare abgeschoren seien, und soll seine Kleider waschen und sein Fleisch im Wasser baden, so ist er rein. ");
INSERT INTO deu1912_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Und am achten Tage soll er zwei Lämmer nehmen ohne Fehl und ein jähriges Schaf ohne Fehl und drei zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, und ein Log Öl. ");
INSERT INTO deu1912_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Da soll der Priester den Gereinigten und diese Dinge stellen vor den HERRN, vor der Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Und soll das eine Lamm nehmen und zum Schuldopfer opfern mit dem Log Öl; und soll solches vor dem HERRN weben ");
INSERT INTO deu1912_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","und darnach das Lamm schlachten, wo man das Sündopfer und Brandopfer schlachtet, nämlich an heiliger Stätte; denn wie das Sündopfer, also ist auch das Schuldopfer des Priesters; denn es ist ein Hochheiliges. ");
INSERT INTO deu1912_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Und der Priester soll von dem Blut nehmen vom Schuldopfer und dem Gereinigten auf den Knorpel des rechten Ohrs tun und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes. ");
INSERT INTO deu1912_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Darnach soll er von dem Log Öl nehmen und es in seine, des Priesters, linke Hand gießen ");
INSERT INTO deu1912_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","und mit seinem rechten Finger in das Öl tauchen, das in seiner linken Hand ist, und sprengen vom Öl mit seinem Finger siebenmal vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Vom übrigen Öl aber in seiner Hand soll er dem Gereinigten auf den Knorpel des rechten Ohrs tun und auf den rechten Daumen und auf die große Zehe seines rechten Fußes, oben auf das Blut des Schuldopfers. ");
INSERT INTO deu1912_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Das übrige Öl aber in seiner Hand soll er auf des Gereinigten Haupt tun und ihn versöhnen vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Und soll das Sündopfer machen und den Gereinigten versöhnen seiner Unreinigkeit halben; und soll darnach das Brandopfer schlachten ");
INSERT INTO deu1912_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","und soll es auf dem Altar opfern samt dem Speisopfer und ihn versöhnen, so ist er rein. ");
INSERT INTO deu1912_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ist er aber arm und erwirbt mit seiner Hand nicht so viel, so nehme er ein Lamm zum Schuldopfer, zu weben, zu seiner Versöhnung und ein zehntel Semmelmehl, mit Öl gemengt, zum Speisopfer, und ein Log Öl ");
INSERT INTO deu1912_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","und zwei Turteltauben oder zwei junge Tauben, die er mit seiner Hand erwerben kann, daß eine sei ein Sündopfer, die andere ein Brandopfer, ");
INSERT INTO deu1912_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","und bringe sie am achten Tage seiner Reinigung zum Priester vor die Tür der Hütte des Stifts, vor den HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Da soll der Priester das Lamm zum Schuldopfer nehmen und das Log Öl und soll's alles weben vor dem HERRN ");
INSERT INTO deu1912_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","und das Lamm des Schuldopfers schlachten und Blut nehmen von demselben Schuldopfer und es dem Gereinigten tun auf den Knorpel seines rechten Ohrs und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes, ");
INSERT INTO deu1912_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","und von dem Öl in seine, des Priesters, linke Hand gießen ");
INSERT INTO deu1912_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","und mit seinem rechten Finger vom Öl, das in seiner linken Hand ist, siebenmal sprengen vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Von dem übrigen aber in seiner Hand soll er dem Gereinigten auf den Knorpel seines rechten Ohrs und auf den Daumen seiner rechten Hand und auf die große Zehe seines rechten Fußes tun, oben auf das Blut des Schuldopfers. ");
INSERT INTO deu1912_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Das übrige Öl aber in seiner Hand soll er dem Gereinigten auf das Haupt tun, ihn zu versöhnen vor dem HERRN; ");
INSERT INTO deu1912_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","und darnach aus der einen Turteltaube oder jungen Taube, wie seine Hand hat mögen erwerben, ");
INSERT INTO deu1912_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ein Sündopfer, aus der andern ein Brandopfer machen samt dem Speisopfer. Und soll der Priester den Gereinigten also versöhnen vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Das sei das Gesetz für den Aussätzigen, der mit seiner Hand nicht erwerben kann, was zur Reinigung gehört. ");
INSERT INTO deu1912_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Wenn ihr in das Land Kanaan kommt, das ich euch zur Besitzung gebe, und ich werde irgend in einem Hause eurer Besitzung ein Aussatzmal geben, ");
INSERT INTO deu1912_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","so soll der kommen, des das Haus ist, es dem Priester ansagen und sprechen: Es sieht mich an, als sei ein Aussatzmal an meinem Hause. ");
INSERT INTO deu1912_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Da soll der Priester heißen, daß sie das Haus ausräumen, ehe denn der Priester hineingeht, das Mal zu besehen, auf daß nicht unrein werde alles, was im Hause ist; darnach soll der Priester hineingehen, das Haus zu besehen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Wenn er nun das Mal besieht und findet, daß an der Wand des Hauses grünliche oder rötliche Grüblein sind und ihr Ansehen tiefer denn sonst die Wand ist, ");
INSERT INTO deu1912_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","so soll er aus dem Hause zur Tür herausgehen und das Haus sieben Tage verschließen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Und wenn er am siebenten Tage wiederkommt und sieht, daß das Mal weitergefressen hat an des Hauses Wand, ");
INSERT INTO deu1912_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","so soll er die Steine heißen ausbrechen, darin das Mal ist, und hinaus vor die Stadt an einen unreinen Ort werfen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Und das Haus soll man inwendig ringsherum schaben und die abgeschabte Tünche hinaus vor die Stadt an einen unreinen Ort schütten ");
INSERT INTO deu1912_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","und andere Steine nehmen und an jener Statt tun und andern Lehm nehmen und das Haus bewerfen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Wenn das Mal wiederkommt und ausbricht am Hause, nachdem man die Steine ausgerissen und das Haus anders beworfen hat, ");
INSERT INTO deu1912_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","so soll der Priester hineingehen. Und wenn er sieht, daß das Mal weitergefressen hat am Hause, so ist's gewiß ein fressender Aussatz am Hause, und es ist unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Darum soll man das Haus abbrechen, Steine und Holz und alle Tünche am Hause, und soll's hinausführen vor die Stadt an einen unreinen Ort. ");
INSERT INTO deu1912_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Und wer in das Haus geht, solange es verschlossen ist, der ist unrein bis an den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Und wer darin liegt oder darin ißt, der soll seine Kleider waschen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Wo aber der Priester, wenn er hineingeht, sieht, daß dies Mal nicht weiter am Haus gefressen hat, nachdem das Haus beworfen ist, so soll er's rein sprechen; denn das Mal ist heil geworden. ");
INSERT INTO deu1912_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Und soll zum Sündopfer für das Haus nehmen zwei Vögel, Zedernholz und scharlachfarbene Wolle und Isop, ");
INSERT INTO deu1912_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","und den einen Vogel schlachten in ein irdenes Gefäß über frischem Wasser. ");
INSERT INTO deu1912_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Und soll nehmen das Zedernholz, die scharlachfarbene Wolle, den Isop und den lebendigen Vogel, und in des geschlachteten Vogels Blut und in das frische Wasser tauchen, und das Haus siebenmal besprengen. ");
INSERT INTO deu1912_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Und soll also das Haus entsündigen mit dem Blut des Vogels und mit dem frischen Wasser, mit dem lebendigen Vogel, mit dem Zedernholz, mit Isop und mit scharlachfarbener Wolle. ");
INSERT INTO deu1912_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Und soll den lebendigen Vogel lassen hinaus vor die Stadt ins freie Feld fliegen, und das Haus versöhnen, so ist's rein. ");
INSERT INTO deu1912_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Das ist das Gesetz über allerlei Mal des Aussatzes und Grindes, ");
INSERT INTO deu1912_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","über den Aussatz der Kleider und der Häuser, ");
INSERT INTO deu1912_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","über Beulen, Ausschlag und Eiterweiß, ");
INSERT INTO deu1912_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","auf daß man wisse, wann etwas unrein oder rein ist. Das ist das Gesetz vom Aussatz. ");
INSERT INTO deu1912_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Redet mit den Kindern Israel und sprecht zu ihnen: Wenn ein Mann an seinem Fleisch einen Fluß hat, derselbe ist unrein. ");
INSERT INTO deu1912_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Dann aber ist er unrein an diesem Fluß, wenn sein Fleisch eitert oder verstopft ist. ");
INSERT INTO deu1912_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Alles Lager, darauf er liegt, und alles, darauf er sitzt, wird unrein werden. ");
INSERT INTO deu1912_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Und wer sein Lager anrührt, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Und wer sich setzt, wo er gesessen hat, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Wer sein Fleisch anrührt, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Wenn er seinen Speichel wirft auf den, der rein ist, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Und der Sattel, darauf er reitet, wird unrein werden. ");
INSERT INTO deu1912_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Und wer anrührt irgend etwas, das er unter sich gehabt hat, der wird unrein sein bis auf den Abend. Und wer solches trägt, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Und welchen er anrührt, ehe er die Hände wäscht, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Wenn er ein irdenes Gefäß anrührt, das soll man zerbrechen; aber das hölzerne Gefäß soll man mit Wasser spülen. ");
INSERT INTO deu1912_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Und wenn er rein wird von seinem Fluß, so soll er sieben Tage zählen, nachdem er rein geworden ist, und seine Kleider waschen und sein Fleisch mit fließendem Wasser baden, so ist er rein. ");
INSERT INTO deu1912_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Und am achten Tage soll er zwei Turteltauben oder zwei junge Tauben nehmen und vor den HERRN bringen vor die Tür der Hütte des Stifts und dem Priester geben. ");
INSERT INTO deu1912_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Und der Priester soll aus einer ein Sündopfer, aus der andern ein Brandopfer machen und ihn versöhnen vor dem HERRN seines Flusses halben. ");
INSERT INTO deu1912_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Wenn einem Mann im Schlaf der Same entgeht, der soll sein ganzes Fleisch mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Und alles Kleid und alles Fell, das mit solchem Samen befleckt ist, soll er waschen mit Wasser und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ein Weib, bei welchem ein solcher liegt, die soll sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Wenn ein Weib ihres Leibes Blutfluß hat, die soll sieben Tage unrein geachtet werden; wer sie anrührt, der wird unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Und alles, worauf sie liegt, solange sie ihre Zeit hat, und worauf sie sitzt, wird unrein sein. ");
INSERT INTO deu1912_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Und wer ihr Lager anrührt, der soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Und wer anrührt irgend etwas, darauf sie gesessen hat, soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Und wer anrührt irgend etwas, das auf ihrem Lager gewesen ist oder da, wo sie gesessen hat soll unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Und wenn ein Mann bei ihr liegt und es kommt sie ihre Zeit an bei ihm, der wird sieben Tage unrein sein, und das Lager, auf dem er gelegen hat wird unrein sein. ");
INSERT INTO deu1912_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Wenn aber ein Weib den Blutfluß eine lange Zeit hat, zu ungewöhnlicher Zeit oder über die gewöhnliche Zeit, so wird sie unrein sein, solange sie ihn hat; wie zu ihrer gewöhnlichen Zeit, so soll sie auch da unrein sein. ");
INSERT INTO deu1912_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Alles Lager, darauf sie liegt die ganze Zeit ihres Flußes, soll sein wie ihr Lager zu ihrer gewöhnlichen Zeit. Und alles, worauf sie sitzt, wird unrein sein gleich der Unreinigkeit ihrer gewöhnlichen Zeit. ");
INSERT INTO deu1912_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Wer deren etwas anrührt, der wird unrein sein und soll seine Kleider waschen und sich mit Wasser baden und unrein sein bis auf den Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Wird sie aber rein von ihrem Fluß, so soll sie sieben Tage zählen; darnach soll sie rein sein. ");
INSERT INTO deu1912_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Und am achten Tage soll sie zwei Turteltauben oder zwei junge Tauben nehmen und zum Priester bringen vor die Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Und der Priester soll aus einer machen ein Sündopfer, aus der andern ein Brandopfer, und sie versöhnen vor dem HERRN über den Fluß ihrer Unreinigkeit. ");
INSERT INTO deu1912_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","So sollt ihr die Kinder Israel warnen vor ihrer Unreinigkeit, daß sie nicht sterben in ihrer Unreinigkeit, wenn sie meine Wohnung verunreinigen, die unter ihnen ist. ");
INSERT INTO deu1912_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Das ist das Gesetz über den, der einen Fluß hat und dem der Same im Schlaf entgeht, daß er unrein davon wird, ");
INSERT INTO deu1912_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","und über die, die ihren Blutfluß hat, und wer einen Fluß hat, es sei Mann oder Weib, und wenn ein Mann bei einer Unreinen liegt. ");
INSERT INTO deu1912_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Und der HERR redete mit Mose, nachdem die zwei Söhne Aarons gestorben waren, da sie vor dem HERRN opferten, ");
INSERT INTO deu1912_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","und sprach: Sage deinem Bruder Aaron, daß er nicht zu aller Zeit in das inwendige Heiligtum gehe hinter den Vorhang vor den Gnadenstuhl, der auf der Lade ist, daß er nicht sterbe; denn ich will in einer Wolke erscheinen auf dem Gnadenstuhl; ");
INSERT INTO deu1912_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","sondern damit soll er hineingehen: mit einem jungen Farren zum Sündopfer und mit einem Widder zum Brandopfer, ");
INSERT INTO deu1912_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","und soll den heiligen leinenen Rock anlegen und leinene Beinkleider an seinem Fleisch haben und sich mit einem leinenen Gürtel gürten und den leinenen Hut aufhaben, denn das sind die heiligen Kleider, und soll sein Fleisch mit Wasser baden und sie anlegen. ");
INSERT INTO deu1912_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Und soll von der Gemeinde der Kinder Israel zwei Ziegenböcke nehmen zum Sündopfer und einen Widder zum Brandopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Und Aaron soll den Farren, sein Sündopfer, herzubringen, daß er sich und sein Haus versöhne, ");
INSERT INTO deu1912_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","und darnach die zwei Böcke nehmen und vor den HERRN stellen vor der Tür der Hütte des Stifts, ");
INSERT INTO deu1912_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","und soll das Los werfen über die zwei Böcke: ein Los dem HERRN, das andere dem Asasel. ");
INSERT INTO deu1912_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Und soll den Bock, auf welchen das Los des HERRN fällt, opfern zum Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Aber den Bock, auf welchen das Los für Asasel fällt, soll er lebendig vor den HERRN stellen, daß er über ihm versöhne, und lasse den Bock für Asasel in die Wüste. ");
INSERT INTO deu1912_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Und also soll er denn den Farren seines Sündopfers herzubringen und sich und sein Haus versöhnen und soll ihn schlachten ");
INSERT INTO deu1912_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","und soll einen Napf voll Glut vom Altar nehmen, der vor dem HERRN steht, und die Hand voll zerstoßenen Räuchwerks und es hinein hinter den Vorhang bringen ");
INSERT INTO deu1912_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","und das Räuchwerk aufs Feuer tun vor dem HERRN, daß der Nebel vom Räuchwerk den Gnadenstuhl bedecke, der auf dem Zeugnis ist, daß er nicht sterbe. ");
INSERT INTO deu1912_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Und soll von dem Blut des Farren nehmen und es mit seinem Finger auf den Gnadenstuhl sprengen vornean; vor den Gnadenstuhl aber soll er siebenmal mit seinem Finger vom Blut sprengen. ");
INSERT INTO deu1912_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Darnach soll er den Bock, des Volkes Sündopfer, schlachten und sein Blut hineinbringen hinter den Vorhang und soll mit seinem Blut tun, wie er mit des Farren Blut getan hat, und damit auch sprengen auf den Gnadenstuhl und vor den Gnadenstuhl; ");
INSERT INTO deu1912_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","und soll also versöhnen das Heiligtum von der Unreinigkeit der Kinder Israel und von ihrer Übertretung in allen ihren Sünden. Also soll er auch tun der Hütte des Stifts; denn sie sind unrein, die umher lagern. ");
INSERT INTO deu1912_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kein Mensch soll in der Hütte des Stifts sein, wenn er hineingeht, zu versöhnen im Heiligtum, bis er herausgehe; und soll also versöhnen sich und sein Haus und die ganze Gemeinde Israel. ");
INSERT INTO deu1912_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Und wenn er herausgeht zum Altar, der vor dem HERRN steht, soll er ihn versöhnen und soll vom Blut des Farren und vom Blut des Bocks nehmen und es auf des Altars Hörner umher tun; ");
INSERT INTO deu1912_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","und soll mit seinem Finger vom Blut darauf sprengen siebenmal und ihn reinigen und heiligen von der Unreinigkeit der Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Und wenn er vollbracht hat das Versöhnen des Heiligtums und der Hütte des Stifts und des Altars, so soll er den lebendigen Bock herzubringen. ");
INSERT INTO deu1912_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Da soll Aaron seine beiden Hände auf sein Haupt legen und bekennen auf ihn alle Missetat der Kinder Israel und alle ihre Übertretung in allen ihren Sünden, und soll sie dem Bock auf das Haupt legen und ihn durch einen Mann, der bereit ist, in die Wüste laufen lassen, ");
INSERT INTO deu1912_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","daß also der Bock alle ihre Missetat auf sich in eine Wildnis trage; und er lasse ihn in die Wüste. ");
INSERT INTO deu1912_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Und Aaron soll in die Hütte des Stifts gehen und ausziehen die leinenen Kleider, die er anzog, da er in das Heiligtum ging, und soll sie daselbst lassen. ");
INSERT INTO deu1912_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Und soll sein Fleisch mit Wasser baden an heiliger Stätte und seine eigenen Kleider antun und herausgehen und sein Brandopfer und des Volkes Brandopfer machen und beide, sich und das Volk, versöhnen, ");
INSERT INTO deu1912_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","und das Fett vom Sündopfer auf dem Altar anzünden. ");
INSERT INTO deu1912_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Der aber den Bock für Asasel hat ausgeführt, soll seine Kleider waschen und sein Fleisch mit Wasser baden und darnach ins Lager kommen. ");
INSERT INTO deu1912_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Den Farren des Sündopfers und den Bock des Sündopfers, deren Blut in das Heiligtum zu versöhnen gebracht ward, soll man hinausschaffen vor das Lager und mit Feuer verbrennen, Haut, Fleisch und Mist. ");
INSERT INTO deu1912_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Und der sie verbrennt, soll seine Kleider waschen und sein Fleisch mit Wasser baden und darnach ins Lager kommen. ");
INSERT INTO deu1912_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Auch soll euch das ein ewiges Recht sein: am zehnten Tage des siebenten Monats sollt ihr euren Leib kasteien und kein Werk tun, weder ein Einheimischer noch ein Fremder unter euch. ");
INSERT INTO deu1912_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Denn an diesem Tage geschieht eure Versöhnung, daß ihr gereinigt werdet; von allen euren Sünden werdet ihr gereinigt vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Darum soll's euch ein großer Sabbat sein, und ihr sollt euren Leib kasteien. Ein ewiges Recht sei das. ");
INSERT INTO deu1912_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Es soll aber solche Versöhnung tun ein Priester, den man geweiht und des Hand man gefüllt hat zum Priester an seines Vaters Statt; und er soll die leinenen Kleider antun, die heiligen Kleider, ");
INSERT INTO deu1912_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","und soll also versöhnen das heiligste Heiligtum und die Hütte des Stifts und den Altar und die Priester und alles Volk der Gemeinde. ");
INSERT INTO deu1912_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Das soll euch ein ewiges Recht sein, daß ihr die Kinder Israel versöhnt von allen ihren Sünden, im Jahr einmal. Und Aaron tat, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Sage Aaron und seinen Söhnen und allen Kindern Israel und sprich zu ihnen: Das ist's, was der HERR geboten hat. ");
INSERT INTO deu1912_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Welcher aus dem Haus Israel einen Ochsen oder Lamm oder Ziege schlachtet, in dem Lager oder draußen vor dem Lager, ");
INSERT INTO deu1912_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","und es nicht vor die Tür der Hütte des Stifts bringt, daß es dem HERRN zum Opfer gebracht werde vor der Wohnung des HERRN, der soll des Blutes schuldig sein als der Blut vergossen hat, und solcher Mensch soll ausgerottet werden aus seinem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Darum sollen die Kinder Israel ihre Schlachttiere, die sie auf dem freien Feld schlachten wollen, vor den HERRN bringen vor die Tür der Hütte des Stifts zum Priester und allda ihre Dankopfer dem HERRN opfern. ");
INSERT INTO deu1912_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Und der Priester soll das Blut auf den Altar des HERRN sprengen vor der Tür der Hütte des Stifts und das Fett anzünden zum süßen Geruch dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Und mitnichten sollen sie ihre Opfer hinfort den Feldteufeln opfern, mit denen sie Abgötterei treiben. Das soll ihnen ein ewiges Recht sein bei ihren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Darum sollst du zu ihnen sagen: Welcher Mensch aus dem Hause Israel oder auch ein Fremdling, der unter euch ist, ein Opfer oder Brandopfer tut ");
INSERT INTO deu1912_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","und bringt's nicht vor die Tür der Hütte des Stifts, daß er's dem HERRN tue, der soll ausgerottet werden von seinem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Und welcher Mensch, er sei vom Haus Israel oder ein Fremdling unter euch, irgend Blut ißt, wider den will ich mein Antlitz setzen und will ihn mitten aus seinem Volk ausrotten. ");
INSERT INTO deu1912_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Denn des Leibes Leben ist im Blut, und ich habe es euch auf den Altar gegeben, daß eure Seelen damit versöhnt werden. Denn das Blut ist die Versöhnung, weil das Leben in ihm ist. ");
INSERT INTO deu1912_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Darum habe ich gesagt den Kindern Israel: Keine Seele unter euch soll Blut essen, auch kein Fremdling, der unter euch wohnt. ");
INSERT INTO deu1912_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Und welcher Mensch, er sei vom Haus Israel oder ein Fremdling unter euch, ein Tier oder einen Vogel fängt auf der Jagd, das man ißt, der soll desselben Blut hingießen und mit Erde zuscharren. ");
INSERT INTO deu1912_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Denn des Leibes Leben ist in seinem Blut, solange es lebt; und ich habe den Kindern Israel gesagt: Ihr sollt keines Leibes Blut essen; denn des Leibes Leben ist in seinem Blut; wer es ißt, der soll ausgerottet werden. ");
INSERT INTO deu1912_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Und welche Seele ein Aas oder was vom Wild zerrissen ist, ißt, er sei ein Einheimischer oder Fremdling, der soll sein Kleid waschen und sich mit Wasser baden und unrein sein bis auf den Abend, so wird er rein. ");
INSERT INTO deu1912_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Wo er seine Kleider nicht waschen noch sich baden wird, so soll er seiner Missetat schuldig sein. ");
INSERT INTO deu1912_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Rede mit den Kindern Israel und sprich zu ihnen: Ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ihr sollt nicht tun nach den Werken des Landes Ägypten, darin ihr gewohnt habt, auch nicht nach den Werken des Landes Kanaan, darein ich euch führen will; ihr sollt auch nach ihrer Weise nicht halten; ");
INSERT INTO deu1912_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","sondern nach meinen Rechten sollt ihr tun, und meine Satzungen sollt ihr halten, daß ihr darin wandelt; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Darum sollt ihr meine Satzungen halten und meine Rechte. Denn welcher Mensch dieselben tut, der wird dadurch leben; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Niemand soll sich zu seiner nächsten Blutsfreundin tun, ihre Blöße aufzudecken; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Du sollst deines Vaters und deiner Mutter Blöße nicht aufdecken; es ist deine Mutter, darum sollst du ihre Blöße nicht aufdecken. ");
INSERT INTO deu1912_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Du sollst deines Vaters Weibes Blöße nicht aufdecken; denn sie ist deines Vaters Blöße. ");
INSERT INTO deu1912_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Du sollst deiner Schwester Blöße, die deines Vaters oder deiner Mutter Tochter ist, daheim oder draußen geboren, nicht aufdecken. ");
INSERT INTO deu1912_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Du sollst die Blöße der Tochter deines Sohnes oder deiner Tochter nicht aufdecken; denn es ist deine Blöße. ");
INSERT INTO deu1912_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Du sollst die Blöße der Tochter deines Vaters Weibes, die deinem Vater geboren ist und deine Schwester ist, nicht aufdecken. ");
INSERT INTO deu1912_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Do sollst die Blöße der Schwester deines Vaters nicht aufdecken; denn es ist deines Vaters nächste Blutsfreundin. ");
INSERT INTO deu1912_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Du sollst deiner Mutter Schwester Blöße nicht aufdecken; denn es ist deiner Mutter nächste Blutsfreundin. ");
INSERT INTO deu1912_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Du sollst deines Vaters Bruders Blöße nicht aufdecken, daß du sein Weib nehmest; denn sie ist deine Base. ");
INSERT INTO deu1912_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Du sollst deiner Schwiegertochter Blöße nicht aufdecken; denn es ist deines Sohnes Weib, darum sollst du ihre Blöße nicht aufdecken. ");
INSERT INTO deu1912_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Du sollst deines Bruders Weibes Blöße nicht aufdecken; denn sie ist deines Bruders Blöße. ");
INSERT INTO deu1912_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Du sollst eines Weibes samt ihrer Tochter Blöße nicht aufdecken noch ihres Sohnes Tochter oder ihrer Tochter Tochter nehmen, ihre Blöße aufzudecken; denn sie sind ihre nächsten Blutsfreundinnen, und es ist ein Frevel. ");
INSERT INTO deu1912_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Du sollst auch deines Weibes Schwester nicht nehmen neben ihr, ihre Blöße aufzudecken, ihr zuwider, solange sie noch lebt. ");
INSERT INTO deu1912_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Du sollst nicht zum Weibe gehen, solange sie ihre Krankheit hat, in ihrer Unreinigkeit ihre Blöße aufzudecken. ");
INSERT INTO deu1912_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Du sollst auch nicht bei deines Nächsten Weibe liegen, dadurch du dich an ihr verunreinigst. ");
INSERT INTO deu1912_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Du sollst auch nicht eines deiner Kinder dahingeben, daß es dem Moloch verbrannt werde, daß du nicht entheiligst den Namen deines Gottes; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Du sollst nicht beim Knaben liegen wie beim Weibe; denn es ist ein Greuel. ");
INSERT INTO deu1912_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Du sollst auch bei keinem Tier liegen, daß du mit ihm verunreinigt werdest. Und kein Weib soll mit einem Tier zu schaffen haben; denn es ist ein Greuel. ");
INSERT INTO deu1912_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ihr sollt euch in dieser keinem verunreinigen; denn in diesem allem haben sich verunreinigt die Heiden, die ich vor euch her will ausstoßen, ");
INSERT INTO deu1912_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","und das Land ist dadurch verunreinigt. Und ich will ihre Missetat an ihnen heimsuchen, daß das Land seine Einwohner ausspeie. ");
INSERT INTO deu1912_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Darum haltet meine Satzungen und Rechte, und tut dieser Greuel keine, weder der Einheimische noch der Fremdling unter euch; ");
INSERT INTO deu1912_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","denn alle solche Greuel haben die Leute dieses Landes getan, die vor euch waren, und haben das Land verunreinigt; ");
INSERT INTO deu1912_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","auf daß euch nicht auch das Land ausspeie, wenn ihr es verunreinigt, gleich wie es die Heiden hat ausgespieen, die vor euch waren. ");
INSERT INTO deu1912_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Denn welche diese Greuel tun, deren Seelen sollen ausgerottet werden von ihrem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Darum haltet meine Satzungen, daß ihr nicht tut nach den greulichen Sitten, die vor euch waren, daß ihr nicht damit verunreinigt werdet; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Rede mit der ganzen Gemeinde der Kinder Israel und sprich zu ihnen: Ihr sollt heilig sein; denn ich bin heilig, der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ein jeglicher fürchte seine Mutter und seinen Vater. Haltet meine Feiertage; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ihr sollt euch nicht zu den Götzen wenden und sollt euch keine gegossenen Götter machen; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Und wenn ihr dem HERRN wollt ein Dankopfer tun, so sollt ihr es opfern, daß es ihm gefallen könnte. ");
INSERT INTO deu1912_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ihr sollt es desselben Tages essen, da ihr's opfert, und des andern Tages; was aber auf den dritten Tag übrigbleibt, soll man mit Feuer verbrennen. ");
INSERT INTO deu1912_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Wird aber jemand am dritten Tage davon essen, so ist er ein Greuel und wird nicht angenehm sein. ");
INSERT INTO deu1912_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Und der Esser wird seine Missetat tragen, darum daß er das Heiligtum des HERRN entheiligte, und solche Seele wird ausgerottet werden von ihrem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Wenn du dein Land einerntest, sollst du nicht alles bis an die Enden umher abschneiden, auch nicht alles genau aufsammeln. ");
INSERT INTO deu1912_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Also auch sollst du deinen Weinberg nicht genau lesen noch die abgefallenen Beeren auflesen, sondern dem Armen und Fremdling sollst du es lassen; denn ich bin der HERR euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ihr sollt nicht stehlen noch lügen noch fälschlich handeln einer mit dem andern. ");
INSERT INTO deu1912_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ihr sollt nicht falsch schwören bei meinem Namen und entheiligen den Namen deines Gottes; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Du sollst deinem Nächsten nicht unrecht tun noch ihn berauben. Es soll des Tagelöhners Lohn nicht bei dir bleiben bis an den Morgen. ");
INSERT INTO deu1912_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Du sollst dem Tauben nicht fluchen und sollst dem Blinden keinen Anstoß setzen; denn du sollst dich vor deinem Gott fürchten, denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ihr sollt nicht unrecht handeln im Gericht, und sollst nicht vorziehen den Geringen noch den Großen ehren; sondern du sollst deinen Nächsten recht richten. ");
INSERT INTO deu1912_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Du sollst kein Verleumder sein unter deinem Volk. Du sollst auch nicht stehen wider deines Nächsten Blut; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Du sollst deinen Bruder nicht hassen in deinem Herzen, sondern du sollst deinen Nächsten zurechtweisen, auf daß du nicht seineshalben Schuld tragen müssest. ");
INSERT INTO deu1912_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Du sollst nicht rachgierig sein noch Zorn halten gegen die Kinder deines Volks. Du sollst deinen Nächsten lieben wie dich selbst; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Meine Satzungen sollt ihr halten, daß du dein Vieh nicht lassest mit anderlei Tier zu schaffen haben und dein Feld nicht besäest mit mancherlei Samen und kein Kleid an dich komme, daß mit Wolle und Leinen gemengt ist. ");
INSERT INTO deu1912_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Wenn ein Mann bei einem Weibe liegt, die eine leibeigene Magd und von dem Mann verschmäht ist, doch nicht erlöst noch Freiheit erlangt hat, das soll gestraft werden; aber sie sollen nicht sterben, denn sie ist nicht frei gewesen. ");
INSERT INTO deu1912_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Er soll aber für seine Schuld dem HERRN vor die Tür der Hütte des Stifts einen Widder zum Schuldopfer bringen; ");
INSERT INTO deu1912_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","und der Priester soll ihn versöhnen mit dem Schuldopfer vor dem HERRN über die Sünde, die er getan hat, so wird ihm Gott gnädig sein über seine Sünde, die er getan hat. ");
INSERT INTO deu1912_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Wenn ihr in das Land kommt und allerlei Bäume pflanzt, davon man ißt, sollt ihr mit seinen Früchten tun wie mit einer Vorhaut. Drei Jahre sollt ihr sie unbeschnitten achten, daß ihr sie nicht esset; ");
INSERT INTO deu1912_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","im vierten Jahr aber sollen alle ihre Früchte heilig sein, ein Preisopfer dem HERRN; ");
INSERT INTO deu1912_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","im fünften Jahr aber sollt ihr die Früchte essen und sie einsammeln; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ihr sollt nichts vom Blut essen. Ihr sollt nicht auf Vogelgeschrei achten noch Tage wählen. ");
INSERT INTO deu1912_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ihr sollt euer Haar am Haupt nicht rundumher abschneiden noch euren Bart gar abscheren. ");
INSERT INTO deu1912_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ihr sollt kein Mal um eines Toten willen an eurem Leibe reißen noch Buchstaben an euch ätzen; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Du sollst deine Tochter nicht zur Hurerei halten, daß nicht das Land Hurerei treibe und werde voll Lasters. ");
INSERT INTO deu1912_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Meine Feiertage haltet, und fürchtet euch vor meinem Heiligtum; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ihr sollt euch nicht wenden zu den Wahrsagern, und forscht nicht von den Zeichendeutern, daß ihr nicht an ihnen verunreinigt werdet; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Vor einem grauen Haupt sollst du aufstehen und die Alten ehren; denn du sollst dich fürchten vor deinem Gott, denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Wenn ein Fremdling bei dir in eurem Lande wohnen wird, den sollt ihr nicht schinden. ");
INSERT INTO deu1912_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Er soll bei euch wohnen wie ein Einheimischer unter euch, und sollst ihn lieben wie dich selbst; denn ihr seid auch Fremdlinge gewesen in Ägyptenland. Ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ihr sollt nicht unrecht handeln im Gericht mit der Elle, mit Gewicht, mit Maß. ");
INSERT INTO deu1912_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Rechte Waage, rechte Pfunde, rechte Scheffel, rechte Kannen sollen bei euch sein; denn ich bin der HERR, euer Gott, der euch aus Ägyptenland geführt hat, ");
INSERT INTO deu1912_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","daß ihr alle meine Satzungen und alle meine Rechte haltet und tut; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Sage den Kindern Israel: Welcher unter den Kindern Israel oder ein Fremdling, der in Israel wohnt, eines seiner Kinder dem Moloch gibt, der soll des Todes sterben; das Volk im Lande soll ihn steinigen. ");
INSERT INTO deu1912_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Und ich will mein Antlitz setzen wider solchen Menschen und will ihn aus seinem Volk ausrotten, daß er dem Moloch eines seiner Kinder gegeben und mein Heiligtum verunreinigt und meinen heiligen Namen entheiligt hat. ");
INSERT INTO deu1912_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Und wo das Volk im Lande durch die Finger sehen würde dem Menschen, der eines seiner Kinder dem Moloch gegeben hat, daß es ihn nicht tötet, ");
INSERT INTO deu1912_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","so will doch ich mein Antlitz wider denselben Menschen setzen und wider sein Geschlecht und will ihn und alle, die mit ihm mit dem Moloch Abgötterei getrieben haben, aus ihrem Volke ausrotten. ");
INSERT INTO deu1912_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Wenn eine Seele sich zu den Wahrsagern und Zeichendeutern wenden wird, daß sie ihnen nachfolgt, so will ich mein Antlitz wider dieselbe Seele setzen und will sie aus ihrem Volk ausrotten. ");
INSERT INTO deu1912_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Darum heiligt euch und seid heilig; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Und haltet meine Satzungen und tut sie; denn ich bin der HERR, der euch heiligt. ");
INSERT INTO deu1912_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Wer seinem Vater oder seiner Mutter flucht, der soll des Todes sterben. Sein Blut sei auf ihm, daß er seinem Vater oder seiner Mutter geflucht hat. ");
INSERT INTO deu1912_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Wer die Ehe bricht mit jemandes Weibe, der soll des Todes sterben, beide, Ehebrecher und Ehebrecherin, darum daß er mit seines Nächsten Weibe die Ehe gebrochen hat. ");
INSERT INTO deu1912_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Wenn jemand bei seines Vaters Weibe schläft, daß er seines Vater Blöße aufgedeckt hat, die sollen beide des Todes sterben; ihr Blut sei auf ihnen. ");
INSERT INTO deu1912_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Wenn jemand bei seiner Schwiegertochter schläft, so sollen sie beide des Todes sterben; ihr Blut sei auf ihnen. ");
INSERT INTO deu1912_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Wenn jemand beim Knaben schläft wie beim Weibe, die haben einen Greuel getan und sollen beide des Todes sterben; ihr Blut sei auf ihnen. ");
INSERT INTO deu1912_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Wenn jemand ein Weib nimmt und ihre Mutter dazu, der hat einen Frevel verwirkt; man soll ihn mit Feuer verbrennen und sie beide auch, daß kein Frevel sei unter euch. ");
INSERT INTO deu1912_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Wenn jemand beim Vieh liegt, der soll des Todes sterben, und das Vieh soll man erwürgen. ");
INSERT INTO deu1912_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Wenn ein Weib sich irgend zu einem Vieh tut, daß sie mit ihm zu schaffen hat, die sollst du töten und das Vieh auch; des Todes sollen sie sterben; ihr Blut sei auf ihnen. ");
INSERT INTO deu1912_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Wenn jemand seine Schwester nimmt, seines Vaters Tochter oder seiner Mutter Tochter, und ihre Blöße schaut und sie wieder seine Blöße, das ist Blutschande. Die sollen ausgerottet werden vor den Leuten ihres Volks; denn er hat seiner Schwester Blöße aufgedeckt; er soll seine Missetat tragen. ");
INSERT INTO deu1912_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Wenn ein Mann beim Weibe schläft zur Zeit ihrer Krankheit und entblößt ihre Scham und deckt ihren Brunnen auf, und entblößt den Brunnen ihres Bluts, die sollen beide aus ihrem Volk ausgerottet werden. ");
INSERT INTO deu1912_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Deiner Mutter Schwester Blöße und deines Vater Schwester Blöße sollst du nicht aufdecken; denn ein solcher hat seine nächste Blutsfreundin aufgedeckt, und sie sollen ihre Missetat tragen. ");
INSERT INTO deu1912_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Wenn jemand bei seines Vaters Bruders Weibe schläft, der hat seines Oheims Blöße aufgedeckt. Sie sollen ihre Sünde tragen; ohne Kinder sollen sie sterben. ");
INSERT INTO deu1912_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Wenn jemand seines Bruders Weib nimmt, das ist eine schändliche Tat; sie sollen ohne Kinder sein, darum daß er seines Bruders Blöße aufgedeckt hat. ");
INSERT INTO deu1912_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","So haltet nun alle meine Satzungen und meine Rechte und tut darnach, auf daß euch das Land nicht ausspeie, darein ich euch führe, daß ihr darin wohnt. ");
INSERT INTO deu1912_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Und wandelt nicht in den Satzungen der Heiden, die ich vor euch her werde ausstoßen. Denn solches alles haben sie getan, und ich habe einen Greuel an ihnen gehabt. ");
INSERT INTO deu1912_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Euch aber sage ich: Ihr sollt jener Land besitzen; denn ich will euch ein Land zum Erbe geben, darin Milch und Honig fließt. Ich bin der HERR, euer Gott, der euch von allen Völkern abgesondert hat, ");
INSERT INTO deu1912_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","daß ihr auch absondern sollt das reine Vieh vom unreinen und unreine Vögel von den reinen, und eure Seelen nicht verunreinigt am Vieh, an Vögeln und an allem, was auf Erden kriecht, das ich euch abgesondert habe, daß es euch unrein sei. ");
INSERT INTO deu1912_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Darum sollt ihr mir heilig sein; denn ich, der HERR, bin heilig, der euch abgesondert hat von den Völkern, daß ihr mein wäret. ");
INSERT INTO deu1912_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Wenn ein Mann oder Weib ein Wahrsager oder Zeichendeuter sein wird, die sollen des Todes sterben. Man soll sie steinigen; ihr Blut sei auf ihnen. ");
INSERT INTO deu1912_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Und der HERR sprach zu Mose: Sage den Priestern, Aarons Söhnen, und sprich zu ihnen: Ein Priester soll sich an keinem Toten seines Volkes verunreinigen, ");
INSERT INTO deu1912_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","außer an seinem Blutsfreunde, der ihm am nächsten angehört, als: an seiner Mutter, an seinem Vater, an seinem Sohne, an seiner Tochter, an seinem Bruder ");
INSERT INTO deu1912_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","und an seiner Schwester, die noch eine Jungfrau und noch bei ihm ist und keines Mannes Weib gewesen ist; an der mag er sich verunreinigen. ");
INSERT INTO deu1912_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Sonst soll er sich nicht verunreinigen an irgend einem, der ihm zugehört unter seinem Volk, daß er sich entheilige. ");
INSERT INTO deu1912_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Sie sollen auch keine Platte machen auf ihrem Haupt noch ihren Bart abscheren und an ihrem Leib kein Mal stechen. ");
INSERT INTO deu1912_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Sie sollen ihrem Gott heilig sein und nicht entheiligen den Namen ihres Gottes. Denn sie opfern des HERRN Opfer, das Brot ihres Gottes; darum sollen sie heilig sein. ");
INSERT INTO deu1912_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Sie sollen keine Hure nehmen noch eine Geschwächte oder die von ihrem Mann verstoßen ist; denn er ist heilig seinem Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Darum sollst du ihn heilig halten, denn er opfert das Brot deines Gottes; er soll dir heilig sein, denn ich bin heilig, der HERR, der euch heiligt. ");
INSERT INTO deu1912_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Wenn eines Priesters Tochter anfängt zu huren, die soll man mit Feuer verbrennen; denn sie hat ihren Vater geschändet. ");
INSERT INTO deu1912_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Wer Hoherpriester ist unter seinen Brüdern, auf dessen Haupt das Salböl gegossen und dessen Hand gefüllt ist, daß er angezogen würde mit den Kleidern, der soll sein Haupt nicht entblößen und seine Kleider nicht zerreißen ");
INSERT INTO deu1912_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","und soll zu keinem Toten kommen und soll sich weder über Vater noch über Mutter verunreinigen. ");
INSERT INTO deu1912_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Aus dem Heiligtum soll er nicht gehen, daß er nicht entheilige das Heiligtum seines Gottes; denn die Weihe des Salböls seines Gottes ist auf ihm. Ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Eine Jungfrau soll er zum Weibe nehmen; ");
INSERT INTO deu1912_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","aber keine Witwe noch Verstoßene noch Geschwächte noch Hure, sondern eine Jungfrau seines Volks soll er zum Weibe nehmen, ");
INSERT INTO deu1912_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","auf daß er nicht seinen Samen entheilige unter seinem Volk; denn ich bin der HERR, der ihn heiligt. ");
INSERT INTO deu1912_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Rede mit Aaron und sprich: Wenn an jemand deiner Nachkommen in euren Geschlechtern ein Fehl ist, der soll nicht herzutreten, daß er das Brot seines Gottes opfere. ");
INSERT INTO deu1912_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Denn keiner, an dem ein Fehl ist, soll herzutreten; er sei blind, lahm, mit einer seltsamen Nase, mit ungewöhnlichem Glied, ");
INSERT INTO deu1912_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","oder der an einem Fuß oder einer Hand gebrechlich ist ");
INSERT INTO deu1912_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","oder höckerig ist oder ein Fell auf dem Auge hat oder schielt oder den Grind oder Flechten hat oder der gebrochen ist. ");
INSERT INTO deu1912_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Welcher nun von Aarons, des Priesters, Nachkommen einen Fehl an sich hat, der soll nicht herzutreten, zu opfern die Opfer des HERRN; denn er hat einen Fehl, darum soll er zu dem Brot seines Gottes nicht nahen, daß er es opfere. ");
INSERT INTO deu1912_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Doch soll er das Brot seines Gottes essen, von dem Heiligen und vom Hochheiligen. ");
INSERT INTO deu1912_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Aber zum Vorhang soll er nicht kommen noch zum Altar nahen, weil der Fehl an ihm ist, daß er nicht entheilige mein Heiligtum; denn ich bin der HERR, der sie heiligt. ");
INSERT INTO deu1912_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Und Mose redete solches zu Aaron und zu seinen Söhnen und zu allen Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Sage Aaron und seinen Söhnen, daß sie sich enthalten von dem Heiligen der Kinder Israel, welches sie mir heiligen und meinen heiligen Namen nicht entheiligen, denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","So sage nun ihnen auf ihre Nachkommen: Welcher eurer Nachkommen herzutritt zum Heiligen, das die Kinder Israel dem HERRN heiligen, und hat eine Unreinheit an sich, des Seele soll ausgerottet werden von meinem Antlitz; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Welcher der Nachkommen Aarons aussätzig ist oder einen Fluß hat, der soll nicht essen vom Heiligen, bis er rein werde. Wer etwa einen anrührt, der an einem Toten unrein geworden ist, oder welchem der Same entgeht im Schlaf, ");
INSERT INTO deu1912_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","und welcher irgend ein Gewürm anrührt, dadurch er unrein wird, oder einen Menschen, durch den er unrein wird, und alles, was ihn verunreinigt: ");
INSERT INTO deu1912_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","welcher der eins anrührt, der ist unrein bis auf den Abend und soll von dem Heiligen nicht essen, sondern soll zuvor seinen Leib mit Wasser baden. ");
INSERT INTO deu1912_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Und wenn die Sonne untergegangen und er rein geworden ist, dann mag er davon essen; denn es ist seine Nahrung. ");
INSERT INTO deu1912_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ein Aas und was von wilden Tieren zerreißen ist, soll er nicht essen, auf daß er nicht unrein daran werde; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Darum sollen sie meine Sätze halten, daß sie nicht Sünde auf sich laden und daran sterben, wenn sie sich entheiligen; denn ich bin der HERR, der sie heiligt. ");
INSERT INTO deu1912_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kein anderer soll von dem Heiligen essen noch des Priesters Beisaß oder Tagelöhner. ");
INSERT INTO deu1912_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Wenn aber der Priester eine Seele um sein Geld kauft, die mag davon essen; und was ihm in seinem Hause geboren wird, das mag auch von seinem Brot essen. ");
INSERT INTO deu1912_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Wenn aber des Priesters Tochter eines Fremden Weib wird, die soll nicht von der heiligen Hebe essen. ");
INSERT INTO deu1912_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Wird sie aber eine Witwe oder ausgestoßen und hat keine Kinder und kommt wieder zu ihres Vaters Hause, so soll sie essen von ihres Vaters Brot, wie da sie noch Jungfrau war. Aber kein Fremdling soll davon essen. ");
INSERT INTO deu1912_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Wer sonst aus Versehen von dem Heiligen ißt der soll den fünften Teil dazutun und dem Priester geben samt dem Heiligen, ");
INSERT INTO deu1912_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","auf daß sie nicht entheiligen das Heilige der Kinder Israel, das sie dem HERRN heben, ");
INSERT INTO deu1912_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","auf daß sie nicht mit Missetat und Schuld beladen, wenn sie ihr Geheiligtes essen; denn ich bin der HERR, der sie heiligt. ");
INSERT INTO deu1912_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Sage Aaron und seinen Söhnen und allen Kindern Israel: Welcher Israeliter oder Fremdling in Israel sein Opfer tun will, es sei ein Gelübde oder von freiem Willen, daß sie dem HERRN ein Brandopfer tun wollen, das ihm von euch angenehm sei, ");
INSERT INTO deu1912_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","das soll ein Männlein und ohne Fehl sein, von Rindern oder Lämmern oder Ziegen. ");
INSERT INTO deu1912_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Alles, was ein Fehl hat, sollt ihr nicht opfern; denn es wird von euch nicht angenehm sein. ");
INSERT INTO deu1912_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Und wer ein Dankopfer dem HERRN tun will, ein besonderes Gelübde oder von freiem Willen, von Rindern oder Schafen, das soll ohne Gebrechen sein, daß es angenehm sei; es soll keinen Fehl haben. ");
INSERT INTO deu1912_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ist's blind oder gebrechlich oder geschlagen oder dürr oder räudig oder hat es Flechten, so sollt ihr solches dem HERRN nicht opfern und davon kein Opfer geben auf den Altar des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Einen Ochsen oder Schaf, die zu lange oder zu kurze Glieder haben, magst du von freiem Willen opfern; aber angenehm mag's nicht sein zum Gelübde. ");
INSERT INTO deu1912_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Du sollst auch dem HERRN kein zerstoßenes oder zerriebenes oder zerrissenes oder das ausgeschnitten ist, opfern, und sollt im Lande solches nicht tun. ");
INSERT INTO deu1912_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Du sollst auch solcher keins von eines Fremdlings Hand als Brot eures Gottes opfern; denn es taugt nicht und hat einen Fehl; darum wird's nicht angenehm sein von euch. ");
INSERT INTO deu1912_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Wenn ein Ochs oder Lamm oder Ziege geboren ist, so soll es sieben Tage bei seiner Mutter sein, und am achten Tage und darnach mag man's dem HERRN opfern, so ist's angenehm. ");
INSERT INTO deu1912_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Es sei ein Ochs oder Schaf, so soll man's nicht mit seinem Jungen auf einen Tag schlachten. ");
INSERT INTO deu1912_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Wenn ihr aber wollt dem HERRN ein Lobopfer tun, das von euch angenehm sei, ");
INSERT INTO deu1912_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","so sollt ihr's desselben Tages essen und sollt nichts übrig bis auf den Morgen behalten; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Darum haltet meine Gebote und tut darnach; denn ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Daß ihr meinen heiligen Namen nicht entheiligt, und ich geheiligt werde unter den Kindern Israel; denn ich bin der HERR, der euch heiligt, ");
INSERT INTO deu1912_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","der euch aus Ägyptenland geführt hat, daß ich euer Gott wäre, ich, der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Sage den Kindern Israel und sprich zu ihnen: Das sind die Feste des HERRN, die ihr heilig und meine Feste heißen sollt, da ihr zusammenkommt. ");
INSERT INTO deu1912_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sechs Tage sollst du arbeiten; der siebente Tag aber ist der große, heilige Sabbat, da ihr zusammenkommt. Keine Arbeit sollt ihr an dem tun; denn es ist der Sabbat des HERRN in allen euren Wohnungen. ");
INSERT INTO deu1912_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Dies sind aber die Feste des HERRN, die ihr die heiligen Feste heißen sollt, da ihr zusammenkommt. ");
INSERT INTO deu1912_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Am vierzehnten Tage des ersten Monats gegen Abend ist des HERRN Passah. ");
INSERT INTO deu1912_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Und am fünfzehnten desselben Monats ist das Fest der ungesäuerten Brote des HERRN; da sollt ihr sieben Tage ungesäuertes Brot essen. ");
INSERT INTO deu1912_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Der erste Tag soll heilig unter euch heißen, da ihr zusammenkommt; da sollt ihr keine Dienstarbeit tun. ");
INSERT INTO deu1912_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Und sieben Tage sollt ihr dem HERRN opfern. Der siebente Tag soll auch heilig heißen, da ihr zusammenkommt; da sollt ihr auch keine Dienstarbeit tun. ");
INSERT INTO deu1912_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Sage den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommt, das ich euch geben werde, und werdet's ernten, so sollt ihr eine Garbe der Erstlinge eurer Ernte zu dem Priester bringen. ");
INSERT INTO deu1912_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Da soll die Garbe gewebt werden vor dem HERRN, daß es von euch angenehm sei; solches soll aber der Priester tun des Tages nach dem Sabbat. ");
INSERT INTO deu1912_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Und ihr sollt des Tages, da eure Garbe gewebt wird, ein Brandopfer dem HERRN tun von einem Lamm, das ohne Fehl und jährig sei, ");
INSERT INTO deu1912_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","samt dem Speisopfer: zwei Zehntel Semmelmehl, mit Öl gemengt, als ein Opfer dem HERRN zum süßen Geruch; dazu das Trankopfer: ein viertel Hin Wein. ");
INSERT INTO deu1912_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Und sollt kein neues Brot noch geröstete oder frische Körner zuvor essen bis auf den Tag, da ihr eurem Gott Opfer bringt. Das soll ein Recht sein euren Nachkommen in allen euren Wohnungen. ");
INSERT INTO deu1912_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Darnach sollt ihr Zählen vom Tage nach dem Sabbat, da ihr die Webegarbe brachtet, sieben ganze Wochen; ");
INSERT INTO deu1912_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","bis an den Tag nach dem siebenten Sabbat, nämlich fünfzig Tage, sollt ihr zählen und neues Speisopfer dem HERRN opfern, ");
INSERT INTO deu1912_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","und sollt's aus euren Wohnungen opfern, nämlich zwei Webebrote von zwei Zehntel Semmelmehl, gesäuert und gebacken, zu Erstlingen dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Und sollt herzubringen neben eurem Brot sieben jährige Lämmer ohne Fehl und einen jungen Farren und zwei Widder, die sollen des HERRN Brandopfer sein, mit ihrem Speisopfern und Trankopfern, ein Opfer eines süßen Geruchs dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Dazu sollt ihr machen einen Ziegenbock zum Sündopfer und zwei jährige Lämmer zum Dankopfer. ");
INSERT INTO deu1912_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Und der Priester soll's weben samt den Erstlingsbroten vor dem HERRN; die sollen samt den zwei Lämmern dem HERRN heilig sein und dem Priester gehören. ");
INSERT INTO deu1912_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Und sollt diesen Tag ausrufen; denn er soll unter euch heilig heißen, da ihr zusammenkommt; keine Dienstarbeit sollt ihr tun. Ein ewiges Recht soll das sein bei euren Nachkommen in allen euren Wohnungen. ");
INSERT INTO deu1912_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Wenn ihr aber euer Land erntet sollt ihr nicht alles bis an die Enden des Feldes abschneiden, auch nicht alles genau auflesen, sondern sollt's den Armen und Fremdlingen lassen. Ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Rede mit den Kindern Israel und sprich: Am ersten Tage des siebenten Monats sollt ihr den heiligen Sabbat des Blasens zum Gedächtnis halten, da ihr zusammenkommt; ");
INSERT INTO deu1912_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","da sollt ihr keine Dienstarbeit tun und sollt dem HERRN opfern. ");
INSERT INTO deu1912_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Des zehnten Tages in diesem siebenten Monat ist der Versöhnungstag. Der soll bei euch heilig heißen, daß ihr zusammenkommt; da sollt ihr euren Leib kasteien und dem HERRN opfern ");
INSERT INTO deu1912_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","und sollt keine Arbeit tun an diesem Tage; denn es ist der Versöhnungstag, daß ihr versöhnt werdet vor dem HERRN, eurem Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Denn wer seinen Leib nicht kasteit an diesem Tage, der soll aus seinem Volk ausgerottet werden. ");
INSERT INTO deu1912_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Und wer dieses Tages irgend eine Arbeit tut, den will ich vertilgen aus seinem Volk. ");
INSERT INTO deu1912_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Darum sollt ihr keine Arbeit tun. Das soll ein ewiges Recht sein euren Nachkommen in allen ihren Wohnungen. ");
INSERT INTO deu1912_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Es ist euer großer Sabbat, daß ihr eure Leiber kasteit. Am neunten Tage des Monats zu Abend sollt ihr diesen Sabbat halten, von Abend bis wieder zu Abend. ");
INSERT INTO deu1912_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Rede mit den Kindern Israel und sprich: Am fünfzehnten Tage dieses siebenten Monats ist das Fest der Laubhütten sieben Tage dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Der erste Tag soll heilig heißen, daß ihr zusammenkommt; keine Dienstarbeit sollt ihr tun. ");
INSERT INTO deu1912_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sieben Tage sollt ihr dem HERRN opfern. Der achte Tag soll auch heilig heißen, daß ihr zusammenkommt, und sollt eure Opfer dem HERRN tun; denn es ist der Tag der Versammlung; keine Dienstarbeit sollt ihr tun. ");
INSERT INTO deu1912_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Das sind die Feste des HERRN, die ihr sollt für heilig halten, daß ihr zusammenkommt und dem HERRN Opfer tut: Brandopfer, Speisopfer, Trankopfer und andere Opfer, ein jegliches nach seinem Tage, ");
INSERT INTO deu1912_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","außer was die Sabbate des HERRN und eure Gaben und Gelübde und freiwillige Gaben sind, die ihr dem HERRN gebt. ");
INSERT INTO deu1912_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","So sollt ihr nun am fünfzehnten Tage des siebenten Monats, wenn ihr die Früchte des Landes eingebracht habt, das Fest des HERRN halten sieben Tage lang. Am ersten Tage ist es Sabbat, und am achten Tage ist es auch Sabbat. ");
INSERT INTO deu1912_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Und sollt am ersten Tage Früchte nehmen von schönen Bäumen, Palmenzweige und Maien von dichten Bäumen und Bachweiden und sieben Tage fröhlich sein vor dem HERRN, eurem Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Und sollt also dem HERRN das Fest halten sieben Tage des Jahres. Das soll ein ewiges Recht sein bei euren Nachkommen, daß sie im siebenten Monat also feiern. ");
INSERT INTO deu1912_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Sieben Tage sollt ihr in Laubhütten wohnen; wer einheimisch ist in Israel, der soll in Laubhütten wohnen, ");
INSERT INTO deu1912_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","daß eure Nachkommen wissen, wie ich die Kinder Israel habe lassen in Hütten wohnen, da ich sie aus Ägyptenland führte. Ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Und Mose sagte den Kindern Israel solche Feste des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Gebiete den Kindern Israel, daß sie zu dir bringen gestoßenes lauteres Baumöl zur Leuchte, daß man täglich Lampen aufsetze ");
INSERT INTO deu1912_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","außen vor dem Vorhang des Zeugnisses in der Hütte des Stifts. Und Aaron soll's zurichten des Abends und des Morgens vor dem HERRN täglich. Das sei ein ewiges Recht euren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Er soll die Lampen auf dem feinen Leuchter zurichten vor dem HERRN täglich. ");
INSERT INTO deu1912_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Und sollst Semmelmehl nehmen und davon zwölf Kuchen backen; zwei Zehntel soll ein Kuchen haben. ");
INSERT INTO deu1912_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Und sollst sie legen je sechs auf eine Schicht auf den feinen Tisch vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Und sollst auf dieselben legen reinen Weihrauch, daß er sei bei den Broten zum Gedächtnis, ein Feuer dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Alle Sabbate für und für soll er sie zurichten vor dem HERRN, von den Kindern Israel zum ewigen Bund. ");
INSERT INTO deu1912_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Und sie sollen Aarons und seiner Söhne sein; die sollen sie essen an heiliger Stätte; denn das ist ein Hochheiliges von den Opfern des HERRN zum ewigen Recht. ");
INSERT INTO deu1912_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Es ging aber aus eines israelitischen Weibes Sohn, der eines ägyptischen Mannes Kind war, unter den Kindern Israel und zankte sich im Lager mit einem israelitischen Mann ");
INSERT INTO deu1912_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","und lästerte den Namen des HERRN und fluchte. Da brachten sie ihn zu Mose (seine Mutter aber hieß Selomith, eine Tochter Dibris vom Stamme Dan) ");
INSERT INTO deu1912_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","und legten ihn gefangen, bis ihnen klare Antwort würde durch den Mund des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Führe den Flucher hinaus vor das Lager und laß alle, die es gehört haben, ihre Hände auf sein Haupt legen und laß ihn die ganze Gemeinde steinigen. ");
INSERT INTO deu1912_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Und sage den Kindern Israel: Welcher seinem Gott flucht, der soll seine Sünde tragen. ");
INSERT INTO deu1912_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Welcher des HERRN Namen lästert, der soll des Todes sterben; die ganze Gemeinde soll ihn steinigen. Wie der Fremdling, so soll auch der Einheimische sein; wenn er den Namen lästert, so soll er sterben. ");
INSERT INTO deu1912_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Wer irgend einen Menschen erschlägt, der soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Wer aber ein Vieh erschlägt, der soll's bezahlen, Leib um Leib. ");
INSERT INTO deu1912_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Und wer seinen Nächsten verletzt, dem soll man tun, wie er getan hat, ");
INSERT INTO deu1912_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Schade um Schade, Auge um Auge, Zahn um Zahn; wie er hat einen Menschen verletzt, so soll man ihm wieder tun. ");
INSERT INTO deu1912_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Also daß, wer ein Vieh erschlägt, der soll's bezahlen; wer aber einen Menschen erschlägt, der soll sterben. ");
INSERT INTO deu1912_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Es soll einerlei Recht unter euch sein, dem Fremdling wie dem Einheimischen; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mose aber sagte es den Kindern Israel; und sie führten den Flucher hinaus vor das Lager und steinigten ihn. Also taten die Kinder Israel, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Und der HERR redete mit Mose auf dem Berge Sinai und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Rede mit den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommt, das ich euch geben werde, so soll das Land seinen Sabbat dem HERRN feiern, ");
INSERT INTO deu1912_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","daß du sechs Jahre dein Feld besäest und sechs Jahre deinen Weinberg beschneidest und sammelst die Früchte ein; ");
INSERT INTO deu1912_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","aber im siebenten Jahr soll das Land seinen großen Sabbat dem HERRN feiern, darin du dein Feld nicht besäen noch deinen Weinberg beschneiden sollst. ");
INSERT INTO deu1912_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Was aber von selber nach deiner Ernte wächst, sollst du nicht ernten, und die Trauben, so ohne deine Arbeit wachsen, sollst du nicht lesen, dieweil es ein Sabbatjahr des Landes ist. ");
INSERT INTO deu1912_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Aber was das Land während seines Sabbats trägt, davon sollt ihr essen, du und dein Knecht, deine Magd, dein Tagelöhner, dein Beisaß, dein Fremdling bei dir, ");
INSERT INTO deu1912_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","dein Vieh und die Tiere in deinem Lande; alle Früchte sollen Speise sein. ");
INSERT INTO deu1912_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Und du sollst zählen solcher Sabbatjahre sieben, daß sieben Jahre siebenmal gezählt werden, und die Zeit der sieben Sabbatjahre mache neunundvierzig Jahre. ");
INSERT INTO deu1912_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Da sollst du die Posaune lassen blasen durch all euer Land am zehnten Tage des siebenten Monats, eben am Tage der Versöhnung. ");
INSERT INTO deu1912_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Und ihr sollt das fünfzigste Jahr heiligen und sollt ein Freijahr ausrufen im Lande allen, die darin wohnen; denn es ist euer Halljahr. Da soll ein jeglicher bei euch wieder zu seiner Habe und zu seinem Geschlecht kommen; ");
INSERT INTO deu1912_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","denn das fünfzigste Jahr ist euer Halljahr. Ihr sollt nicht säen, auch was von selber wächst, nicht ernten, auch was ohne Arbeit wächst im Weinberge, nicht lesen; ");
INSERT INTO deu1912_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","denn das Halljahr soll unter euch heilig sein. Ihr sollt aber essen, was das Feld trägt. ");
INSERT INTO deu1912_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Das ist das Halljahr, da jedermann wieder zu dem Seinen kommen soll. ");
INSERT INTO deu1912_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Wenn du nun etwas deinem Nächsten verkaufst oder ihm etwas abkaufst, soll keiner seinen Bruder übervorteilen, ");
INSERT INTO deu1912_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","sondern nach der Zahl der Jahre vom Halljahr an sollst du es von ihm kaufen; und was die Jahre hernach tragen mögen, so hoch soll er dir's verkaufen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nach der Menge der Jahre sollst du den Kauf steigern, und nach der wenigen der Jahre sollst du den Kauf verringern; denn er soll dir's, nach dem es tragen mag, verkaufen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","So übervorteile nun keiner seinen Nächsten, sondern fürchte dich vor deinem Gott; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Darum tut nach meinen Satzungen und haltet meine Rechte, daß ihr darnach tut, auf daß ihr im Lande sicher wohnen möget. ");
INSERT INTO deu1912_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Denn das Land soll euch seine Früchte geben, daß ihr zu essen genug habet und sicher darin wohnt. ");
INSERT INTO deu1912_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Und ob du würdest sagen: Was sollen wir essen im siebenten Jahr? denn wir säen nicht, so sammeln wir auch kein Getreide ein: ");
INSERT INTO deu1912_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","da will ich meinem Segen über euch im sechsten Jahr gebieten, das er soll dreier Jahr Getreide machen, ");
INSERT INTO deu1912_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","daß ihr säet im achten Jahr und von dem alten Getreide esset bis in das neunte Jahr, daß ihr vom alten esset, bis wieder neues Getreide kommt. ");
INSERT INTO deu1912_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Darum sollt ihr das Land nicht verkaufen für immer; denn das Land ist mein, und ihr seid Fremdlinge und Gäste vor mir. ");
INSERT INTO deu1912_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Und sollt in all eurem Lande das Land zu lösen geben. ");
INSERT INTO deu1912_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Wenn dein Bruder verarmt, und verkauft dir seine Habe, und sein nächster Verwandter kommt zu ihm, daß er's löse, so soll er's lösen, was sein Bruder verkauft hat. ");
INSERT INTO deu1912_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Wenn aber jemand keinen Löser hat und kann mit seiner Hand so viel zuwege bringen, daß er's löse, ");
INSERT INTO deu1912_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","so soll er rechnen von dem Jahr, da er's verkauft hat, und was noch übrig ist, dem Käufer wiedergeben und also wieder zu seiner Habe kommen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Kann aber seine Hand nicht so viel finden, daß er's ihm wiedergebe, so soll, was er verkauft hat, in der Hand des Käufers bleiben bis zum Halljahr; in demselben soll es frei werden und er wieder zu seiner Habe kommen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Wer ein Wohnhaus verkauft in einer Stadt mit Mauern, der hat ein ganzes Jahr Frist, dasselbe wieder zu lösen; das soll die Zeit sein, darin er es lösen kann. ");
INSERT INTO deu1912_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Wo er's aber nicht löst, ehe denn das ganze Jahr um ist, so soll's der Käufer für immer behalten und seine Nachkommen, und es soll nicht frei werden im Halljahr. ");
INSERT INTO deu1912_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ist's aber ein Haus auf dem Dorfe, um das keine Mauer ist, das soll man dem Feld des Landes gleich rechnen, und es soll können los werden und im Halljahr frei werden. ");
INSERT INTO deu1912_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Die Städte der Leviten aber, nämlich die Häuser in den Städten, darin ihre Habe ist, können immerdar gelöst werden. ");
INSERT INTO deu1912_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Wer etwas von den Leviten löst, der soll's verlassen im Halljahr, es sei Haus oder Stadt, das er besessen hat; denn die Häuser in den Städten der Leviten sind ihre Habe unter den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Aber das Feld vor ihren Städten soll man nicht verkaufen; denn das ist ihr Eigentum ewiglich. ");
INSERT INTO deu1912_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Wenn dein Bruder verarmt und neben dir abnimmt, so sollst du ihn aufnehmen als einen Fremdling oder Gast, daß er lebe neben dir, ");
INSERT INTO deu1912_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","und sollst nicht Zinsen von ihm nehmen noch Wucher, sondern sollst dich vor deinem Gott fürchten, auf daß dein Bruder neben dir leben könne. ");
INSERT INTO deu1912_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Denn du sollst ihm dein Geld nicht auf Zinsen leihen noch deine Speise auf Wucher austun. ");
INSERT INTO deu1912_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Denn ich bin der HERR, euer Gott, der euch aus Ägyptenland geführt hat, daß ich euch das Land Kanaan gäbe und euer Gott wäre. ");
INSERT INTO deu1912_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Wenn dein Bruder verarmt neben dir und verkauft sich dir, so sollst du ihn nicht lassen dienen als einen Leibeigenen; ");
INSERT INTO deu1912_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","sondern wie ein Tagelöhner und Gast soll er bei dir sein und bis an das Halljahr bei dir dienen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Dann soll er von dir frei ausgehen und seine Kinder mit ihm und soll wiederkommen zu seinem Geschlecht und zu seiner Väter Habe. ");
INSERT INTO deu1912_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Denn sie sind meine Knechte, die ich aus Ägyptenland geführt habe; darum soll man sie nicht auf leibeigene Weise verkaufen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Und sollst nicht mit Strenge über sie herrschen, sondern dich fürchten vor deinem Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Willst du aber leibeigene Knechte und Mägde haben, so sollst du sie kaufen von den Heiden, die um euch her sind, ");
INSERT INTO deu1912_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","und auch von den Kindern der Gäste, die Fremdlinge unter euch sind, und von ihren Nachkommen, die sie bei euch in eurem Land zeugen; dieselben mögt ihr zu eigen haben ");
INSERT INTO deu1912_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","und sollt sie besitzen und eure Kinder nach euch zum Eigentum für und für; die sollt ihr leibeigene Knechte sein lassen. Aber von euren Brüdern, den Kindern Israel, soll keiner über den andern herrschen mit Strenge. ");
INSERT INTO deu1912_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Wenn irgend ein Fremdling oder Gast bei dir zunimmt und dein Bruder neben ihm verarmt und sich dem Fremdling oder Gast bei dir oder jemand von seinem Stamm verkauft, ");
INSERT INTO deu1912_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","so soll er nach seinem Verkaufen Recht haben, wieder frei zu werden, und es mag ihn jemand unter seinen Brüdern lösen, ");
INSERT INTO deu1912_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","oder sein Vetter oder Vetters Sohn oder sonst ein Blutsfreund seines Geschlechts; oder so seine Hand so viel erwirbt, so soll er selbst sich lösen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Und soll mit seinem Käufer rechnen von dem Jahr an, da er sich verkauft hatte, bis aufs Halljahr; und das Geld, darum er sich verkauft hat, soll nach der Zahl der Jahre gerechnet werden, als wäre er die ganze Zeit Tagelöhner bei ihm gewesen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Sind noch viele Jahre bis an das Halljahr, so soll er nach denselben desto mehr zu seiner Lösung wiedergeben von dem Gelde darum er gekauft ist. ");
INSERT INTO deu1912_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Sind aber wenig Jahre übrig bis ans Halljahr, so soll er auch darnach wiedergeben zu seiner Lösung. ");
INSERT INTO deu1912_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Als Tagelöhner soll er von Jahr zu Jahr bei ihm sein, und sollst nicht lassen mit Strenge über ihn herrschen vor deinen Augen. ");
INSERT INTO deu1912_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Wird er aber auf diese Weise sich nicht lösen, so soll er im Halljahr frei ausgehen und seine Kinder mit ihm. ");
INSERT INTO deu1912_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Denn die Kinder Israel sind meine Knechte, die ich aus Ägyptenland geführt habe. Ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ihr sollt keine Götzen machen noch Bild und sollt euch keine Säule aufrichten, auch keinen Malstein setzen in eurem Lande, daß ihr davor anbetet; denn ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Haltet meine Sabbate und fürchtet euch vor meinem Heiligtum. Ich bin der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Werdet ihr in meinen Satzungen wandeln und meine Gebote halten und tun, ");
INSERT INTO deu1912_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","so will ich euch Regen geben zu seiner Zeit, und das Land soll sein Gewächs geben und die Bäume auf dem Felde ihre Früchte bringen, ");
INSERT INTO deu1912_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","und die Dreschzeit soll reichen bis zur Weinernte, und die Weinernte bis zur Zeit der Saat; und sollt Brots die Fülle haben und sollt sicher in eurem Lande wohnen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ich will Frieden geben in eurem Lande, daß ihr schlafet und euch niemand schrecke. Ich will die bösen Tiere aus eurem Land tun, und soll kein Schwert durch euer Land gehen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ihr sollt eure Feinde jagen, und sie sollen vor euch her ins Schwert fallen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Euer fünf sollen hundert jagen, und euer hundert sollen zehntausend jagen; denn eure Feinde sollen vor euch her fallen ins Schwert. ");
INSERT INTO deu1912_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Und ich will mich zu euch wenden und will euch wachsen und euch mehren lassen und will meinen Bund euch halten. ");
INSERT INTO deu1912_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Und sollt von dem Vorjährigen essen, und wenn das Neue kommt, das Vorjährige wegtun. ");
INSERT INTO deu1912_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ich will meine Wohnung unter euch haben, und meine Seele soll euch nicht verwerfen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Und will unter euch wandeln und will euer Gott sein; so sollt ihr mein Volk sein. ");
INSERT INTO deu1912_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Denn ich bin der HERR, euer Gott, der euch aus Ägyptenland geführt hat, daß ihr meine Knechte wäret, und habe euer Joch zerbrochen und habe euch aufgerichtet wandeln lassen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Werdet ihr mir aber nicht gehorchen und nicht tun diese Gebote alle ");
INSERT INTO deu1912_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","und werdet meine Satzungen verachten und eure Seele wird meine Rechte verwerfen, daß ihr nicht tut alle meine Gebote, und werdet meinen Bund brechen, ");
INSERT INTO deu1912_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","so will ich euch auch solches tun: ich will euch heimsuchen mit Schrecken, Darre und Fieber, daß euch die Angesichter verfallen und der Leib verschmachte; ihr sollt umsonst euren Samen säen, und eure Feinde sollen ihn essen; ");
INSERT INTO deu1912_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","und ich will mein Antlitz wider euch stellen, und sollt geschlagen werden vor euren Feinden; und die euch hassen, sollen über euch herrschen, und sollt fliehen, da euch niemand jagt. ");
INSERT INTO deu1912_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","So ihr aber über das noch nicht mir gehorcht, so will ich's noch siebenmal mehr machen, euch zu strafen um eure Sünden, ");
INSERT INTO deu1912_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","daß ich euren Stolz und eure Halsstarrigkeit breche; und will euren Himmel wie Eisen und eure Erde wie Erz machen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Und eure Mühe und Arbeit soll verloren sein, daß euer Land sein Gewächs nicht gebe und die Bäume des Landes ihre Früchte nicht bringen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Und wo ihr mir entgegen wandelt und mich nicht hören wollt, so will ich's noch siebenmal mehr machen, auf euch zu schlagen um eurer Sünden willen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Und will wilde Tiere unter euch senden, die sollen eure Kinder fressen und euer Vieh zerreißen und euer weniger machen, und eure Straßen sollen wüst werden. ");
INSERT INTO deu1912_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Werdet ihr euch aber damit noch nicht von mir züchtigen lassen und mir entgegen wandeln, ");
INSERT INTO deu1912_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","so will ich euch auch entgegen wandeln und will euch noch siebenmal mehr schlagen um eurer Sünden willen ");
INSERT INTO deu1912_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","und will ein Racheschwert über euch bringen, das meinen Bund rächen soll. Und ob ihr euch in eure Städte versammelt, will ich doch die Pestilenz unter euch senden und will euch in eurer Feinde Hände geben. ");
INSERT INTO deu1912_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Dann will ich euch den Vorrat des Brots verderben, daß zehn Weiber sollen in einem Ofen backen, und euer Brot soll man mit Gewicht auswägen, und wenn ihr esset, sollt ihr nicht satt werden. ");
INSERT INTO deu1912_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Werdet ihr aber dadurch mir noch nicht gehorchen und mir entgegen wandeln, ");
INSERT INTO deu1912_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","so will ich euch im Grimm entgegen wandeln und will euch siebenmal mehr strafen um eure Sünden, ");
INSERT INTO deu1912_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","daß ihr sollt eurer Söhne und Töchter Fleisch essen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Und will eure Höhen vertilgen und eure Sonnensäulen ausrotten und will eure Leichname auf eure Götzen werfen, und meine Seele wird an euch Ekel haben. ");
INSERT INTO deu1912_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Und will eure Städte einreißen und will euren süßen Geruch nicht riechen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Also will ich das Land wüst machen, daß eure Feinde, so darin wohnen, sich davor entsetzen werden. ");
INSERT INTO deu1912_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Euch aber will ich unter die Heiden streuen, und das Schwert ausziehen hinter euch her, daß euer Land soll wüst sein und eure Städte verstört. ");
INSERT INTO deu1912_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Alsdann wird das Land sich seine Sabbate gefallen lassen, solange es wüst liegt und ihr in der Feinde Land seid; ja, dann wird das Land feiern und sich seine Sabbate gefallen lassen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Solange es wüst liegt, wird es feiern, darum daß es nicht feiern konnte, da ihr's solltet feiern lassen, da ihr darin wohntet. ");
INSERT INTO deu1912_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Und denen, die von euch übrigbleiben will ich ein feiges Herz machen in ihrer Feinde Land, daß sie soll ein rauschend Blatt jagen, und soll fliehen davor, als jage sie ein Schwert, und fallen, da sie niemand jagt. ");
INSERT INTO deu1912_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Und soll einer über den andern hinfallen, gleich als vor dem Schwert, da sie doch niemand jagt; und ihr sollt euch nicht auflehnen dürfen wider eure Feinde. ");
INSERT INTO deu1912_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Und ihr sollt umkommen unter den Heiden, und eurer Feinde Land soll euch fressen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Welche aber von euch übrigbleiben, die sollen in ihrer Missetat verschmachten in der Feinde Land; auch in ihrer Väter Missetat sollen sie mit ihnen verschmachten. ");
INSERT INTO deu1912_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Da werden sie denn bekennen ihre Missetat und ihrer Väter Missetat, womit sie sich an mir versündigt und mir entgegen gewandelt haben. ");
INSERT INTO deu1912_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Darum will ich auch ihnen entgegen wandeln und will sie in ihrer Feinde Land wegtreiben; da wird sich ja ihr unbeschnittenes Herz demütigen, und dann werden sie sich die Strafe ihrer Missetat gefallen lassen. ");
INSERT INTO deu1912_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Und ich werde gedenken an meinen Bund mit Jakob und an meinen Bund mit Isaak und an meinen Bund mit Abraham und werde an das Land gedenken, ");
INSERT INTO deu1912_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","das von ihnen verlassen ist und sich seine Sabbate gefallen läßt, dieweil es wüst von ihnen liegt, und sie sich die Strafe ihrer Missetat gefallen lassen, darum daß sie meine Rechte verachtet haben und ihre Seele an meinen Satzungen Ekel gehabt hat. ");
INSERT INTO deu1912_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Auch wenn sie schon in der Feinde Land sind, habe ich sie gleichwohl nicht verworfen und ekelt mich ihrer nicht also, daß es mit ihnen aus sein sollte und mein Bund mit ihnen sollte nicht mehr gelten; denn ich bin der HERR, ihr Gott. ");
INSERT INTO deu1912_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Und ich will über sie an meinen ersten Bund gedenken, da ich sie aus Ägyptenland führte vor den Augen der Heiden, daß ich ihr Gott wäre, ich, der HERR. ");
INSERT INTO deu1912_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Dies sind die Satzungen und Rechte und Gesetze, die der HERR zwischen ihm selbst und den Kindern Israel gestellt hat auf dem Berge Sinai durch die Hand Mose's. ");
INSERT INTO deu1912_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Rede mit den Kindern Israel und sprich zu ihnen: Wenn jemand ein besonderes Gelübde tut, also daß du seinen Leib schätzen mußt, ");
INSERT INTO deu1912_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","so soll dies eine Schätzung sein: ein Mannsbild, zwanzig Jahre alt bis ins sechzigste Jahr, sollst du schätzen auf fünfzig Silberlinge nach dem Lot des Heiligtums, ");
INSERT INTO deu1912_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ein Weibsbild auf dreißig Silberlinge. ");
INSERT INTO deu1912_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Von fünf Jahren an bis auf zwanzig Jahre sollst du ihn schätzen auf zwanzig Silberlinge, wenn's ein Mannsbild ist, ein Weibsbild aber auf zehn Silberlinge. ");
INSERT INTO deu1912_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Von einem Monat an bis auf fünf Jahre sollst du ihn schätzen auf fünf Silberlinge, wenn's ein Mannsbild ist, ein Weibsbild aber auf drei Silberlinge. ");
INSERT INTO deu1912_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ist er aber sechzig Jahre alt und darüber, so sollst du ihn schätzen auf fünfzehn Silberlinge, wenn's ein Mannsbild ist, ein Weibsbild aber auf zehn Silberlinge. ");
INSERT INTO deu1912_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ist er aber zu arm zu solcher Schätzung, so soll er sich vor den Priester stellen, und der Priester soll ihn schätzen; er soll ihn aber schätzen, nach dem die Hand des, der gelobt hat, erwerben kann. ");
INSERT INTO deu1912_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ist's aber ein Vieh, das man dem HERRN opfern kann: alles, was man davon dem HERRN gibt ist heilig. ");
INSERT INTO deu1912_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Man soll's nicht wechseln noch wandeln, ein gutes um ein böses, oder ein böses um ein gutes. Wird's aber jemand wechseln, ein Vieh um das andere, so sollen sie beide dem HERRN heilig sein. ");
INSERT INTO deu1912_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ist aber das Tier unrein, daß man's dem HERRN nicht opfern darf, so soll man's vor den Priester stellen, ");
INSERT INTO deu1912_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","und der Priester soll's schätzen, ob es gut oder böse sei; und es soll bei des Priesters Schätzung bleiben. ");
INSERT INTO deu1912_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Will's aber jemand lösen, der soll den Fünften über die Schätzung geben. ");
INSERT INTO deu1912_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Wenn jemand sein Haus heiligt, daß es dem HERRN heilig sei, das soll der Priester schätzen, ob's gut oder böse sei; und darnach es der Priester schätzt, so soll's bleiben. ");
INSERT INTO deu1912_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","So es aber der, so es geheiligt hat, will lösen, so soll er den fünften Teil des Geldes, zu dem es geschätzt ist, draufgeben, so soll's sein werden. ");
INSERT INTO deu1912_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Wenn jemand ein Stück Acker von seinem Erbgut dem HERRN heiligt, so soll es geschätzt werden nach der Aussaat. Ist die Aussaat ein Homer Gerste, so soll es fünfzig Silberlinge gelten. ");
INSERT INTO deu1912_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Heiligt er seinen Acker vom Halljahr an, so soll er nach seinem Wert gelten. ");
INSERT INTO deu1912_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Hat er ihn aber nach dem Halljahr geheiligt, so soll der Priester das Geld berechnen nach den übrigen Jahren zum Halljahr und ihn darnach geringer schätzen. ");
INSERT INTO deu1912_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Will aber der, so ihn geheiligt hat, den Acker lösen, so soll er den fünften Teil des Geldes, zu dem er geschätzt ist, draufgeben, so soll er sein werden. ");
INSERT INTO deu1912_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Will er ihn aber nicht lösen, sondern verkauft ihn einem andern, so soll er ihn nicht mehr lösen können; ");
INSERT INTO deu1912_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","sondern derselbe Acker, wenn er im Halljahr frei wird, soll dem HERRN heilig sein wie ein verbannter Acker und soll des Priesters Erbgut sein. ");
INSERT INTO deu1912_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Wenn aber jemand dem HERRN einen Acker heiligt, den er gekauft hat und der nicht sein Erbgut ist, ");
INSERT INTO deu1912_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","so soll der Priester berechnen, was er gilt bis an das Halljahr; und soll desselben Tages solche Schätzung geben, daß sie dem HERRN heilig sei. ");
INSERT INTO deu1912_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Aber im Halljahr soll er wieder gelangen an den, von dem er ihn gekauft hat, daß sein Erbgut im Lande sei. ");
INSERT INTO deu1912_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Alle Schätzung soll geschehen nach dem Lot des Heiligtums; ein Lot aber hat zwanzig Gera. ");
INSERT INTO deu1912_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Die Erstgeburt unter dem Vieh, die dem HERRN sonst gebührt, soll niemand dem HERRN heiligen, es sei ein Ochs oder Schaf; denn es ist des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ist es aber unreines Vieh, so soll man's lösen nach seinem Werte, und darübergeben den Fünften. Will er's aber nicht lösen, so verkaufe man's nach seinem Werte. ");
INSERT INTO deu1912_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Man soll kein Verbanntes verkaufen noch lösen, das jemand dem HERRN verbannt von allem, was sein ist, es seien Menschen, Vieh oder Erbacker; denn alles verbannte ist ein Hochheiliges dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Man soll auch keinen verbannten Menschen lösen, sondern er soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Alle Zehnten im Lande von Samen des Landes und von Früchten der Bäume sind des HERRN und sollen dem HERRN heilig sein. ");
INSERT INTO deu1912_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Will aber jemand seinen Zehnten lösen, der soll den Fünften darübergeben. ");
INSERT INTO deu1912_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Und alle Zehnten von Rindern und Schafen, von allem, was unter dem Hirtenstabe geht, das ist ein heiliger Zehnt dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Man soll nicht fragen, ob's gut oder böse sei; man soll's auch nicht wechseln. Wird's aber jemand wechseln, so soll's beides heilig sein und nicht gelöst werden. ");
INSERT INTO deu1912_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Dies sind die Gebote, die der HERR dem Mose gebot an die Kinder Israel auf dem Berge Sinai. ");
INSERT INTO deu1912_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Und der HERR redete mit Mose in der Wüste Sinai in der Hütte des Stifts am ersten Tage des zweiten Monats im zweiten Jahr, da sie aus Ägyptenland gegangen waren, und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Nehmet die Summe der ganzen Gemeinde der Kinder Israel nach ihren Geschlechtern und Vaterhäusern und Namen, alles, was männlich ist, von Haupt zu Haupt, ");
INSERT INTO deu1912_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","von zwanzig Jahren an und darüber, was ins Heer zu ziehen taugt in Israel; ihr sollt sie zählen nach ihren Heeren, du und Aaron. ");
INSERT INTO deu1912_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Und sollt zu euch nehmen je vom Stamm einen Hauptmann über sein Vaterhaus. ");
INSERT INTO deu1912_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Dies sind die Namen der Hauptleute, die neben euch stehen sollen: von Ruben sei Elizur, der Sohn Sedeurs; ");
INSERT INTO deu1912_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","von Simeon sei Selumiel, der Sohn Zuri-Saddais; ");
INSERT INTO deu1912_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","von Juda sei Nahesson, der Sohn Amminadabs; ");
INSERT INTO deu1912_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","von Isaschar sei Nathanael, der Sohn Zuars; ");
INSERT INTO deu1912_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","von Sebulon sei Eliab, der Sohn Helons; ");
INSERT INTO deu1912_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","von den Kindern Josephs: von Ephraim sei Elisama, der Sohn Ammihuds; von Manasse sei Gamliel, der Sohn Pedazurs; ");
INSERT INTO deu1912_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","von Benjamin sei Abidan, der Sohn des Gideoni; ");
INSERT INTO deu1912_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","von Dan sei Ahieser, der Sohn Ammi-Saddais; ");
INSERT INTO deu1912_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","von Asser sei Pagiel, der Sohn Ochrans; ");
INSERT INTO deu1912_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","von Gad sei Eljasaph, der Sohn Deguels; ");
INSERT INTO deu1912_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","von Naphthali sei Ahira, der Sohn Enans. ");
INSERT INTO deu1912_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Das sind die Vornehmsten der Gemeinde, die Fürsten unter den Stämmen ihrer Väter, die da Häupter über die Tausende in Israel waren. ");
INSERT INTO deu1912_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Und Mose und Aaron nahmen sie zu sich, wie sie da mit Namen genannt sind, ");
INSERT INTO deu1912_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","und sammelten auch die ganze Gemeinde am ersten Tage des zweiten Monats und rechneten nach ihrer Geburt, nach ihren Geschlechtern und Vaterhäusern und Namen, von zwanzig Jahren an und darüber, von Haupt zu Haupt, ");
INSERT INTO deu1912_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","wie der HERR dem Mose geboten hatte, und zählten sie in der Wüste Sinai. ");
INSERT INTO deu1912_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Der Kinder Ruben, des ersten Sohnes Israels, nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von Haupt zu Haupt, alles, was männlich war, von zwanzig Jahren und darüber, und ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","wurden gezählt vom Stamme Ruben sechsundvierzigtausend und fünfhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Der Kinder Simeon nach ihrer Geburt und Geschlecht, ihren Vaterhäusern, Zahl und Namen, von Haupt zu Haupt, alles, was männlich war, von zwanzig Jahren und darüber, und ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","wurden gezählt zum Stamm Simeon neunundfünfzigtausend und dreihundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Der Kinder Gad nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, und ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","wurden gezählt zum Stamm Gad fünfundvierzigtausend sechshundertundfünfzig. ");
INSERT INTO deu1912_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Der Kinder Juda nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","wurden gezählt zum Stamm Juda vierundsiebzigtausend und sechshundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Der Kinder Isaschar nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","wurden gezählt zum Stamm Isaschar vierundfünfzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Der Kinder Sebulon nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","wurden gezählt zum Stamm Sebulon siebenundfünfzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Der Kinder Joseph von Ephraim nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","wurden gezählt zum Stamm Ephraim vierzigtausend und fünfhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Der Kinder Manasse nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","wurden zum Stamm Manasse gezählt zweiunddreißigtausend und zweihundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Der Kinder Benjamin nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","wurden zum Stamm Benjamin gezählt fünfunddreißigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Der Kinder Dan nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","wurden gezählt zum Stamme Dan zweiundsechzigtausend und siebenhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Der Kinder Asser nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","wurden gezählt zum Stamm Asser einundvierzigtausend und fünfhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Der Kinder Naphthali nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte, ");
INSERT INTO deu1912_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","wurden zum Stamm Naphthali gezählt dreiundfünfzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Dies sind, die Mose und Aaron zählten samt den zwölf Fürsten Israels, deren je einer über ein Vaterhaus war. ");
INSERT INTO deu1912_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Und die Summe der Kinder Israel nach ihrer Geburt und Geschlecht, ihren Vaterhäusern und Namen, von zwanzig Jahren und darüber, was ins Heer zu ziehen taugte in Israel, ");
INSERT INTO deu1912_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","war sechsmal hunderttausend und dreitausend fünfhundertundfünfzig. ");
INSERT INTO deu1912_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Aber die Leviten nach ihrer Väter Stamm wurden nicht mit darunter gezählt. ");
INSERT INTO deu1912_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Den Stamm Levi sollst du nicht zählen noch ihre Summe nehmen unter den Kindern Israel, ");
INSERT INTO deu1912_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","sondern du sollst sie ordnen zur Wohnung des Zeugnisses und zu allem Geräte und allem, was dazu gehört. Und sie sollen die Wohnung tragen und alles Gerät und sollen sein pflegen und um die Wohnung her sich lagern. ");
INSERT INTO deu1912_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Und wenn man reisen soll, so sollen die Leviten die Wohnung abnehmen. Wenn aber das Heer zu lagern ist, sollen sie die Wohnung aufschlagen. Und wo ein Fremder sich dazumacht, der soll sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Die Kinder Israel sollen sich lagern, ein jeglicher in sein Lager und zu dem Panier seiner Schar. ");
INSERT INTO deu1912_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Aber die Leviten sollen sich um die Wohnung des Zeugnisses her lagern, auf daß nicht ein Zorn über die Gemeinde der Kinder Israel komme; darum sollen die Leviten des Dienstes warten an der Wohnung des Zeugnisses. ");
INSERT INTO deu1912_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Und die Kinder Israel taten alles, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Die Kinder Israel sollen vor der Hütte des Stifts umher sich lagern, ein jeglicher unter seinem Panier und Zeichen nach ihren Vaterhäusern. ");
INSERT INTO deu1912_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Gegen Morgen sollen lagern Juda mit seinem Panier und Heer; ihr Hauptmann Nahesson, der Sohn Amminadabs, ");
INSERT INTO deu1912_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","und sein Heer, zusammen vierundsiebzigtausend und sechshundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Neben ihm soll sich lagern der Stamm Isaschar; ihr Hauptmann Nathanael, der Sohn Zuars, ");
INSERT INTO deu1912_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","und sein Heer, zusammen vierundfünfzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Dazu der Stamm Sebulon; ihr Hauptmann Eliab, der Sohn Helons, ");
INSERT INTO deu1912_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","sein Heer, zusammen siebenundfünfzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Daß alle, die ins Lager Juda's gehören, seien zusammen hundert sechsundachtzigtausend und vierhundert die zu ihrem Heer gehören; und sie sollen vornean ziehen. ");
INSERT INTO deu1912_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Gegen Mittag soll liegen das Gezelt und Panier Rubens mit ihrem Heer; ihr Hauptmann Elizur, der Sohn Sedeurs, ");
INSERT INTO deu1912_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","und sein Heer, zusammen sechsundvierzigtausend fünfhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Neben ihm soll sich lagern der Stamm Simeon; ihr Hauptmann Selumiel, der Sohn Zuri-Saddais, ");
INSERT INTO deu1912_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","und sein Heer, zusammen neunundfünfzigtausend dreihundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Dazu der Stamm Gad; ihr Hauptmann Eljasaph, der Sohn Reguels, ");
INSERT INTO deu1912_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","und sein Heer, zusammen fünfundvierzigtausend sechshundertfünfzig. ");
INSERT INTO deu1912_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Daß alle, die ins Lager Rubens gehören, seien zusammen hunderteinundfünfzigtausend vierhundertfünfzig, die zu ihrem Heer gehören; sie sollen die zweiten im Ausziehen sein. ");
INSERT INTO deu1912_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Darnach soll die Hütte des Stifts ziehen mit dem Lager der Leviten, mitten unter den Lagern; und wie sie sich lagern, so sollen sie auch ziehen, ein jeglicher an seinem Ort unter seinem Panier. ");
INSERT INTO deu1912_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Gegen Abend soll liegen das Gezelt und Panier Ephraims mit ihrem Heer; ihr Hauptmann soll sein Elisama, der Sohn Ammihuds, ");
INSERT INTO deu1912_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","und sein Heer, zusammen vierzigtausend und fünfhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Neben ihm soll sich lagern der Stamm Manasse; ihr Hauptmann Gamliel, der Sohn Pedazurs, ");
INSERT INTO deu1912_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","und sein Heer, zusammen zweiunddreißigtausend und zweihundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Dazu der Stamm Benjamin; ihr Hauptmann Abidan, der Sohn des Gideoni, ");
INSERT INTO deu1912_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","und sein Heer, zusammen fünfunddreißigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Daß alle, die ins Lager Ephraims gehören, seien zusammen hundertundachttausend und einhundert, die zu seinem Heer gehören; und sie sollen die dritten im Ausziehen sein. ");
INSERT INTO deu1912_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Gegen Mitternacht soll liegen das Gezelt und Panier Dans mit ihrem Heer; ihr Hauptmann Ahieser, der Sohn Ammi-Saddais, ");
INSERT INTO deu1912_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","und sein Heer, zusammen zweiundsechzigtausend und siebenhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Neben ihm soll sich lagern der Stamm Asser; ihr Hauptmann Pagiel, der Sohn Ochrans, ");
INSERT INTO deu1912_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","und sein Heer, zusammen einundvierzigtausend und fünfhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Dazu der Stamm Naphthali; ihr Hauptmann Ahira, der Sohn Enans, ");
INSERT INTO deu1912_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","und sein Heer, zusammen dreiundfünfzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Daß alle, die ins Lager Dans gehören, seien zusammen hundertsiebenundfünfzigtausend und sechshundert; und sie sollen die letzten sein im Ausziehen mit ihrem Panier. ");
INSERT INTO deu1912_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Dies ist die Summe der Kinder Israel nach ihren Vaterhäusern und Lagern mit ihren Heeren: sechshunderttausend und dreitausend fünfhundertfünfzig. ");
INSERT INTO deu1912_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Aber die Leviten wurden nicht in die Summe unter die Kinder Israel gezählt, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Und die Kinder Israel taten alles, wie der HERR dem Mose geboten hatte, und lagerten sich unter ihre Paniere und zogen aus, ein jeglicher in seinem Geschlecht nach seinem Vaterhaus. ");
INSERT INTO deu1912_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Dies ist das Geschlecht Aarons und Mose's zu der Zeit, da der HERR mit Mose redete auf dem Berge Sinai. ");
INSERT INTO deu1912_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Und dies sind die Namen der Söhne Aarons: der Erstgeborene Nadab, darnach Abihu, Eleasar und Ithamar. ");
INSERT INTO deu1912_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Das sind die Namen der Söhne Aarons, die zu Priestern gesalbt waren und deren Hände gefüllt wurden zum Priestertum. ");
INSERT INTO deu1912_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Aber Nadab und Abihu starben vor dem HERRN, da sie fremdes Feuer opferten vor dem HERRN in der Wüste Sinai, und hatten keine Söhne. Eleasar aber und Ithamar pflegten des Priesteramtes unter ihrem Vater Aaron. ");
INSERT INTO deu1912_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Bringe den Stamm Levi herzu und stelle sie vor den Priester Aaron, daß sie ihm dienen ");
INSERT INTO deu1912_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","und seiner und der ganzen Gemeinde Hut warten vor der Hütte des Stifts und dienen am Dienst der Wohnung ");
INSERT INTO deu1912_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","und warten alles Gerätes der Hütte des Stifts und der Hut der Kinder Israel, zu dienen am Dienst der Wohnung. ");
INSERT INTO deu1912_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Und sollst die Leviten Aaron und seinen Söhnen zuordnen zum Geschenk von den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaron aber und seine Söhne sollst du setzen, daß sie ihres Priestertums warten. Wo ein Fremder sich herzutut, der soll sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Siehe, ich habe die Leviten genommen unter den Kindern Israel für alle Erstgeburt, welche die Mutter bricht, unter den Kindern Israel, also daß die Leviten sollen mein sein. ");
INSERT INTO deu1912_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Denn die Erstgeburten sind mein seit der Zeit, da ich alle Erstgeburt schlug in Ägyptenland; da heiligte ich mir alle Erstgeburt in Israel, vom Menschen an bis auf das Vieh, daß sie mein sein sollen, ich, der HERR. ");
INSERT INTO deu1912_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Und der HERR redete mit Mose in der Wüste Sinai und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Zähle die Kinder Levi nach ihren Vaterhäusern und Geschlechtern, alles, was männlich ist, einen Monat alt und darüber. ");
INSERT INTO deu1912_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Also zählte sie Mose nach dem Wort des HERRN, wie er geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Und dies waren die Kinder Levis mit Namen: Gerson, Kahath, Merari. ");
INSERT INTO deu1912_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Die Namen aber der Kinder Gersons nach ihren Geschlechtern waren: Libni und Simei. ");
INSERT INTO deu1912_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Die Kinder Kahaths nach ihren Geschlechtern waren: Amram, Jizhar, Hebron und Usiel. ");
INSERT INTO deu1912_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Die Kinder Meraris nach ihren Geschlechtern waren; Maheli und Musi. Dies sind die Geschlechter Levis nach ihren Vaterhäusern. ");
INSERT INTO deu1912_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Dies sind die Geschlechter von Gerson: die Libniter und Simeiter. ");
INSERT INTO deu1912_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Deren Summe war an der Zahl gefunden siebentausendundfünfhundert, alles, was männlich war, einen Monat alt und darüber. ");
INSERT INTO deu1912_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Und dieselben Geschlechter der Gersoniter sollen sich lagern hinter der Wohnung gegen Abend. ");
INSERT INTO deu1912_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ihr Oberster sei Eljasaph, der Sohn Laels. ");
INSERT INTO deu1912_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Und sie sollen an der Hütte des Stifts warten der Wohnung und der Hütte und ihrer Decken und des Tuches in der Tür der Hütte des Stifts, ");
INSERT INTO deu1912_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","des Umhangs am Vorhof und des Tuches in der Tür des Vorhofs, welcher um die Wohnung und um den Altar her geht, und ihre Seile und alles dessen, was zu ihrem Dienst gehört. ");
INSERT INTO deu1912_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Dies sind die Geschlechter von Kahath: die Amramiten, die Jizhariten, die Hebroniten und die Usieliten, ");
INSERT INTO deu1912_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","was männlich war, einen Monat alt und darüber, an der Zahl achttausendsechshundert, die der Sorge für das Heiligtum warten. ");
INSERT INTO deu1912_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","und sie sollen sich lagern an die Seite der Wohnung gegen Mittag. ");
INSERT INTO deu1912_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ihr Oberster sei Elizaphan, der Sohn Usiels. ");
INSERT INTO deu1912_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Und sie sollen warten der Lade, des Tisches, des Leuchters, der Altäre und alles Gerätes des Heiligtums, daran sie dienen und des Tuches und was sonst zu ihrem Dienst gehört. ");
INSERT INTO deu1912_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Aber der Oberste über alle Obersten der Leviten soll Eleasar sein, Aarons Sohn, des Priesters, über die, so verordnet sind, zu warten der Sorge für das Heiligtum. ");
INSERT INTO deu1912_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Dies sind die Geschlechter Meraris: die Maheliter und Musiter, ");
INSERT INTO deu1912_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","die an der Zahl waren sechstausendundzweihundert, alles was männlich war, einen Monat alt und darüber. ");
INSERT INTO deu1912_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ihr Oberster sei Zuriel, der Sohn Abihails. Und sollen sich lagern an die Seite der Wohnung gegen Mitternacht. ");
INSERT INTO deu1912_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Und ihr Amt soll sein, zu warten der Bretter und Riegel und Säulen und Füße der Wohnung und alles ihres Gerätes und ihres Dienstes, ");
INSERT INTO deu1912_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","dazu der Säulen um den Vorhof her mit den Füßen und Nägeln und Seilen. ");
INSERT INTO deu1912_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aber vor der Wohnung und vor der Hütte des Stifts gegen Morgen sollen sich lagern Mose und Aaron und seine Söhne, daß sie des Heiligtums warten für die Kinder Israel. Wenn sich ein Fremder herzutut, der soll sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Alle Leviten zusammen, die Mose und Aaron zählten nach ihren Geschlechtern nach dem Wort des HERRN eitel Mannsbilder einen Monat alt und darüber, waren zweiundzwanzigtausend. ");
INSERT INTO deu1912_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Und der HERR sprach zu Mose: Zähle alle Erstgeburt, was männlich ist unter den Kindern Israel, einen Monat und darüber, und nimm die Zahl ihrer Namen. ");
INSERT INTO deu1912_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Und sollst die Leviten mir, dem HERRN, aussondern für alle Erstgeburt der Kinder Israel und der Leviten Vieh für alle Erstgeburt unter dem Vieh der Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Und Mose zählte, wie ihm der HERR geboten hatte, alle Erstgeburt unter den Kindern Israel; ");
INSERT INTO deu1912_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","und fand sich die Zahl der Namen aller Erstgeburt, was männlich war, einen Monat alt und darüber, in ihrer Summe zweiundzwanzigtausend zweihundertdreiundsiebzig. ");
INSERT INTO deu1912_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Nimm die Leviten für alle Erstgeburt unter den Kindern Israel und das Vieh der Leviten für ihr Vieh, daß die Leviten mein, des HERRN, seien. ");
INSERT INTO deu1912_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Aber als Lösegeld von den zweihundertdreiundsiebzig Erstgeburten der Kinder Israel, die über der Leviten Zahl sind, ");
INSERT INTO deu1912_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","sollst du je fünf Silberlinge nehmen von Haupt zu Haupt nach dem Lot des Heiligtums (zwanzig Gera hat ein Lot) ");
INSERT INTO deu1912_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","und sollst das Geld für die, so überzählig sind unter ihnen, geben Aaron und seinen Söhnen. ");
INSERT INTO deu1912_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Da nahm Mose das Lösegeld von denen, die über der Leviten Zahl waren, ");
INSERT INTO deu1912_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","von den Erstgeburten der Kinder Israel, tausenddreihundert und fünfundsechzig Silberlinge nach dem Lot des Heiligtums, ");
INSERT INTO deu1912_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","und gab's Aaron und seinen Söhnen nach dem Worte des HERRN, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Nimm die Summe der Kinder Kahath aus den Kindern Levi nach ihren Geschlechtern und Vaterhäusern, ");
INSERT INTO deu1912_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","von dreißig Jahren an bis ins fünfzigste Jahr, alle, die zum Dienst taugen, daß sie tun die Werke in der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Das soll aber das Amt der Kinder Kahath in der Hütte des Stifts sein; was das Hochheilige ist. ");
INSERT INTO deu1912_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Wenn das Heer aufbricht, so sollen Aaron und seine Söhne hineingehen und den Vorhang abnehmen und die Lade des Zeugnisses darein winden ");
INSERT INTO deu1912_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","und darauf tun die Decke von Dachsfellen und obendrauf eine ganz blaue Decke breiten und ihre Stangen daran legen ");
INSERT INTO deu1912_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","und über den Schaubrottisch auch eine blaue Decke breiten und darauf legen die Schüsseln, Löffel, die Schalen und Kannen zum Trankopfer, und das beständige Brot soll darauf liegen. ");
INSERT INTO deu1912_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Und sollen darüber breiten eine scharlachrote Decke und dieselbe bedecken mit einer Decke von Dachsfellen und seine Stangen daran legen. ");
INSERT INTO deu1912_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Und sollen eine blaue Decke nehmen und darein winden den Leuchter des Lichts und seine Lampen mit seinen Schneuzen und Näpfen und alle Ölgefäße, die zum Amt gehören. ");
INSERT INTO deu1912_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Und sollen um das alles tun eine Decke von Dachsfellen und sollen es auf die Stangen legen. ");
INSERT INTO deu1912_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Also sollen sie auch über den goldenen Altar eine blaue Decke breiten und sie bedecken mit der Decke von Dachsfellen und seine Stangen daran tun. ");
INSERT INTO deu1912_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Alle Gerät, womit sie schaffen im Heiligtum, sollen sie nehmen und blaue Decken darüber tun und mit einer Decke von Dachsfellen bedecken und auf Stangen legen. ");
INSERT INTO deu1912_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Sie sollen auch die Asche vom Altar fegen und eine Decke von rotem Purpur über ihn breiten ");
INSERT INTO deu1912_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","und alle seine Geräte darauf schaffen, Kohlenpfannen, Gabeln, Schaufeln, Becken mit allem Gerät des Altars; und sollen darüber breiten eine Decke von Dachsfellen und seine Stangen daran tun. ");
INSERT INTO deu1912_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Wenn nun Aaron und seine Söhne solches ausgerichtet und das Heiligtum und all sein Gerät bedeckt haben, wenn das Heer aufbricht, darnach sollen die Kinder Kahath hineingehen, daß sie es tragen; und sollen das Heiligtum nicht anrühren, daß sie nicht sterben. Dies sind die Lasten der Kinder Kahath an der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Und Eleasar, Aarons, des Priesters, Sohn, soll das Amt haben, daß er ordne das Öl zum Licht und die Spezerei zum Räuchwerk und das tägliche Speisopfer und das Salböl, daß er beschicke die ganze Wohnung und alles, was darin ist, im Heiligtum und seinem Geräte. ");
INSERT INTO deu1912_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Ihr sollt den Stamm der Geschlechter der Kahathiter nicht lassen sich verderben unter den Leviten; ");
INSERT INTO deu1912_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","sondern das sollt ihr mit ihnen tun, daß sie leben und nicht sterben, wo sie werden anrühren das Hochheilige: Aaron und seine Söhne sollen hineingehen und einen jeglichen stellen zu seinem Amt und seiner Last. ");
INSERT INTO deu1912_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Sie sollen aber nicht hineingehen, zu schauen das Heiligtum auch nur einen Augenblick, daß sie nicht sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Nimm die Summe der Kinder Gerson auch nach ihren Vaterhäusern und Geschlechtern, ");
INSERT INTO deu1912_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","von dreißig Jahren an und darüber bis ins fünfzigste Jahr, und ordne sie alle, die da zum Dienst tüchtig sind, daß sie ein Amt haben in der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Das soll aber der Geschlechter der Gersoniter Amt sein, das sie schaffen und tragen: ");
INSERT INTO deu1912_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","sie sollen die Teppiche der Wohnung und der Hütte des Stifts tragen und ihre Decke und die Decke von Dachsfellen, die obendrüber ist, und das Tuch in der Hütte des Stifts ");
INSERT INTO deu1912_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","und die Umhänge des Vorhofs und das Tuch in der Tür des Tores am Vorhof, welcher um die Wohnung und den Altar her geht, und ihre Seile und alle Geräte ihres Amtes und alles, was zu ihrem Amt gehört. ");
INSERT INTO deu1912_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Nach dem Wort Aarons und seiner Söhne soll alles Amt der Kinder Gerson geschehen, alles, was sie tragen und schaffen sollen, und ihr sollt zusehen, daß sie aller ihrer Last warten. ");
INSERT INTO deu1912_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Das soll das Amt der Geschlechter der Kinder der Gersoniter sein in der Hütte des Stifts; und ihr Dienst soll unter der Hand Ithamars sein, des Sohnes Aarons, des Priesters. ");
INSERT INTO deu1912_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Die Kinder Merari nach ihren Geschlechtern und Vaterhäusern sollst du auch ordnen, ");
INSERT INTO deu1912_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","von dreißig Jahren an und darüber bis ins fünfzigste Jahr, alle, die zum Dienst taugen, daß sie ein Amt haben in der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Dieser Last aber sollen sie warten nach allem ihrem Amt in der Hütte des Stifts, das sie tragen die Bretter der Wohnung und Riegel und Säulen und Füße, ");
INSERT INTO deu1912_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","dazu die Säulen des Vorhofs umher und Füße und Nägel und Seile mit allem ihrem Geräte, nach allem ihrem Amt; einem jeglichen sollt ihr seinen Teil der Last am Geräte zu warten verordnen. ");
INSERT INTO deu1912_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Das sei das Amt der Geschlechter der Kinder Merari, alles, was sie schaffen sollen in der Hütte des Stifts unter der Hand Ithamars, des Priesters, des Sohnes Aarons. ");
INSERT INTO deu1912_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Und Mose und Aaron samt den Hauptleuten der Gemeinde zählten die Kinder der Kahathiter nach ihren Geschlechtern und Vaterhäusern, ");
INSERT INTO deu1912_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","von dreißig Jahren an und darüber bis ins fünfzigste Jahr, alle, die zum Dienst taugten, daß sie Amt in der Hütte des Stifts hätten. ");
INSERT INTO deu1912_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Und die Summe war zweitausend siebenhundertfünfzig. ");
INSERT INTO deu1912_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Das ist die Summe der Geschlechter der Kahathiter, die alle zu schaffen hatten in der Hütte des Stifts, die Mose und Aaron zählten nach dem Wort des HERRN durch Mose. ");
INSERT INTO deu1912_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Die Kinder Gerson wurden auch gezählt in ihren Geschlechtern und Vaterhäusern, ");
INSERT INTO deu1912_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","von dreißig Jahren an und darüber bis ins fünfzigste, alle, die zum Dienst taugten, daß sie Amt in der Hütte des Stifts hätten. ");
INSERT INTO deu1912_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Und die Summe war zweitausend sechshundertdreißig. ");
INSERT INTO deu1912_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Das ist die Summe der Geschlechter der Kinder Gerson, die alle zu schaffen hatten in der Hütte des Stifts, welche Mose und Aaron zählten nach dem Wort des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Die Kinder Merari wurden auch gezählt nach ihren Geschlechtern und Vaterhäusern, ");
INSERT INTO deu1912_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","von dreißig Jahren an und darüber bis ins fünfzigste, alle, die zum Dienst taugten, daß sie Amt in der Hütte des Stifts hätten. ");
INSERT INTO deu1912_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Und die Summe war dreitausendzweihundert. ");
INSERT INTO deu1912_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Das ist die Summe der Geschlechter der Kinder Merari, die Mose und Aaron zählten nach dem Wort des HERRN durch Mose. ");
INSERT INTO deu1912_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Die Summe aller Leviten, die Mose und Aaron samt den Hauptleuten Israels zählten nach ihren Geschlechtern und Vaterhäusern, ");
INSERT INTO deu1912_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","von dreißig Jahren und darüber bis ins fünfzigste, aller, die eingingen, zu schaffen ein jeglicher sein Amt und zu tragen die Last der Hütte des Stifts, ");
INSERT INTO deu1912_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","war achttausend fünfhundertachtzig, ");
INSERT INTO deu1912_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","die gezählt wurden nach dem Wort des HERRN durch Mose, ein jeglicher zu seinem Amt und seiner Last, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Gebiete den Kindern Israel, daß sie aus dem Lager tun alle Aussätzigen und alle, die Eiterflüsse haben, und die an Toten unrein geworden sind. ");
INSERT INTO deu1912_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Beide, Mann und Weib, sollt ihr hinaustun vor das Lager, daß sie nicht ihr Lager verunreinigen, darin ich unter ihnen wohne. ");
INSERT INTO deu1912_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Und die Kinder Israel taten also und taten sie hinaus vor das Lager, wie der HERR zu Mose geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Sage den Kindern Israel und sprich zu ihnen: Wenn ein Mann oder Weib irgend eine Sünde wider einen Menschen tut und sich an dem HERRN damit versündigt, so hat die Seele eine Schuld auf sich; ");
INSERT INTO deu1912_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","und sie sollen ihre Sünde bekennen, die sie getan haben, und sollen ihre Schuld versöhnen mit der Hauptsumme und darüber den fünften Teil dazutun und dem geben, an dem sie sich versündigt haben. ");
INSERT INTO deu1912_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ist aber niemand da, dem man's bezahlen sollte, so soll man es dem HERRN geben für den Priester außer dem Widder der Versöhnung, dadurch er versöhnt wird. ");
INSERT INTO deu1912_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Desgleichen soll alle Hebe von allem, was die Kinder Israel heiligen und dem Priester opfern, sein sein. ");
INSERT INTO deu1912_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Und wer etwas heiligt, das soll auch sein sein; und wer etwas dem Priester gibt, das soll auch sein sein. ");
INSERT INTO deu1912_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Sage den Kindern Israel und sprich zu ihnen: Wenn irgend eines Mannes Weib untreu würde und sich an ihm versündigte ");
INSERT INTO deu1912_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","und jemand bei ihr liegt, und es würde doch dem Manne verborgen vor seinen Augen und würde entdeckt, daß sie unrein geworden ist, und er kann sie nicht überführen, denn sie ist nicht dabei ergriffen, ");
INSERT INTO deu1912_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","und der Eifergeist entzündet ihn, daß er um sein Weib eifert, sie sei unrein oder nicht unrein, ");
INSERT INTO deu1912_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","so soll er sie zum Priester bringen und ein Opfer über sie bringen, ein zehntel Epha Gerstenmehl, und soll kein Öl darauf gießen noch Weihrauch darauf tun. Denn es ist ein Eiferopfer und Rügeopfer, das Missetat rügt. ");
INSERT INTO deu1912_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Da soll der Priester sie herzuführen und vor den HERRN stellen ");
INSERT INTO deu1912_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","und heiliges Wasser nehmen in ein irdenes Gefäß und Staub vom Boden der Wohnung ins Wasser tun. ");
INSERT INTO deu1912_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Und soll das Weib vor den HERRN stellen und ihr Haupt entblößen und das Rügeopfer, das ein Eiferopfer ist, auf ihre Hand legen; und der Priester soll in seiner Hand bitteres verfluchtes Wasser haben ");
INSERT INTO deu1912_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","und soll das Weib beschwören und zu ihr sagen: Hat kein Mann bei dir gelegen, und bist du deinem Mann nicht untreu geworden, daß du dich verunreinigt hast, so sollen dir diese bittern verfluchten Wasser nicht schaden. ");
INSERT INTO deu1912_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Wo du aber deinem Mann untreu geworden bist, daß du unrein wurdest, und hat jemand bei dir gelegen außer deinem Mann, ");
INSERT INTO deu1912_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","so soll der Priester das Weib beschwören mit solchem Fluch und soll zu ihr sagen: Der HERR setze dich zum Fluch und zum Schwur unter deinem Volk, daß der HERR deine Hüfte schwinden und deinen Bauch schwellen lasse! ");
INSERT INTO deu1912_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","So gehe nun das verfluchte Wasser in deinen Leib, daß dein Bauch schwelle und deine Hüfte schwinde! Und das Weib soll sagen: Amen, amen. ");
INSERT INTO deu1912_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Also soll der Priester diese Flüche auf einen Zettel schreiben und mit dem bittern Wasser abwaschen ");
INSERT INTO deu1912_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","und soll dem Weibe von dem bittern Wasser zu trinken geben, daß das verfluchte bittere Wasser in sie gehe. ");
INSERT INTO deu1912_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Es soll aber der Priester von ihrer Hand das Eiferopfer nehmen und zum Speisopfer vor dem HERRN weben und auf dem Altar opfern, nämlich: ");
INSERT INTO deu1912_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","er soll eine Handvoll des Speisopfers nehmen und auf dem Altar anzünden zum Gedächtnis und darnach dem Weibe das Wasser zu trinken geben. ");
INSERT INTO deu1912_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Und wenn sie das Wasser getrunken hat: ist sie unrein und hat sich an ihrem Mann versündigt, so wird das verfluchte Wasser in sie gehen und ihr bitter sein, daß ihr der Bauch schwellen und die Hüfte schwinden wird, und wird das Weib ein Fluch sein unter ihrem Volk; ");
INSERT INTO deu1912_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ist aber ein solch Weib nicht verunreinigt, sondern rein, so wird's ihr nicht schaden, daß sie kann schwanger werden. ");
INSERT INTO deu1912_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Dies ist das Eifergesetz, wenn ein Weib ihrem Mann untreu ist und unrein wird, ");
INSERT INTO deu1912_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","oder wenn einen Mann der Eifergeist entzündet, daß er um sein Weib eifert, daß er's stelle vor den HERRN und der Priester mit ihr tue alles nach diesem Gesetz. ");
INSERT INTO deu1912_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Und der Mann soll unschuldig sein an der Missetat; aber das Weib soll ihre Missetat tragen. ");
INSERT INTO deu1912_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Sage den Kindern Israel und sprich zu ihnen: Wenn ein Mann oder Weib ein besonderes Gelübde tut, dem HERRN sich zu enthalten, ");
INSERT INTO deu1912_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","der soll sich Weins und starken Getränks enthalten; Weinessig oder Essig von starkem Getränk soll er auch nicht trinken, auch nichts, das aus Weinbeeren gemacht wird; er soll weder frische noch dürre Weinbeeren essen. ");
INSERT INTO deu1912_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Solange solch ein Gelübde währt, soll er nichts essen, das man vom Weinstock macht, vom Weinkern bis zu den Hülsen. ");
INSERT INTO deu1912_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Solange die Zeit solches seines Gelübdes währt, soll kein Schermesser über sein Haupt fahren, bis das die Zeit aus sei, die er dem HERRN gelobt hat; denn er ist heilig und soll das Haar auf seinem Haupt lassen frei wachsen. ");
INSERT INTO deu1912_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Die ganze Zeit über, die er dem HERRN gelobt hat, soll er zu keinem Toten gehen. ");
INSERT INTO deu1912_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Er soll sich auch nicht verunreinigen an dem Tod seines Vaters, seiner Mutter, seines Bruders oder seiner Schwester; denn das Gelübde seines Gottes ist auf seinem Haupt. ");
INSERT INTO deu1912_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Die ganze Zeit seines Gelübdes soll er dem HERRN heilig sein. ");
INSERT INTO deu1912_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Und wo jemand vor ihm unversehens plötzlich stirbt, da wird das Haupt seines Gelübdes verunreinigt; darum soll er sein Haupt scheren am Tage seiner Reinigung, das ist am siebenten Tage. ");
INSERT INTO deu1912_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Und am achten Tage soll er zwei Turteltauben bringen oder zwei junge Tauben zum Priester vor die Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Und der Priester soll eine zum Sündopfer und die andere zum Brandopfer machen und ihn versöhnen, darum daß er sich an einem Toten versündigt hat, und also sein Haupt desselben Tages heiligen, ");
INSERT INTO deu1912_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","daß er dem HERRN die Zeit seines Gelübdes aushalte. Und soll ein jähriges Lamm bringen zum Schuldopfer. Aber die vorigen Tage sollen umsonst sein, darum daß sein Gelübde verunreinigt ist. ");
INSERT INTO deu1912_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Dies ist das Gesetz des Gottgeweihten: wenn die Zeit seines Gelübdes aus ist, so soll man ihn bringen vor die Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Und er soll bringen sein Opfer dem HERRN, ein jähriges Lamm ohne Fehl zum Brandopfer und ein jähriges Schaf ohne Fehl zum Sündopfer und einen Widder ohne Fehl zum Dankopfer ");
INSERT INTO deu1912_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","und einen Korb mit ungesäuerten Kuchen von Semmelmehl, mit Öl gemengt, und ungesäuerte Fladen, mit Öl bestrichen, und ihre Speisopfer und Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Und der Priester soll's vor den HERRN bringen und soll sein Sündopfer und sein Brandopfer machen. ");
INSERT INTO deu1912_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Und den Widder soll er zum Dankopfer machen dem HERRN samt dem Korbe mit den ungesäuerten Brot; und soll auch sein Speisopfer und sein Trankopfer machen. ");
INSERT INTO deu1912_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Und der Geweihte soll das Haupt seines Gelübdes scheren vor der Tür der Hütte des Stifts und soll das Haupthaar seines Gelübdes nehmen und aufs Feuer werfen, das unter dem Dankopfer ist. ");
INSERT INTO deu1912_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Und der Priester soll den gekochten Bug nehmen von dem Widder und einen ungesäuerten Kuchen aus dem Korbe und einen ungesäuerten Fladen und soll's dem Geweihten auf sein Hände legen, nachdem er sein Gelübde abgeschoren hat, ");
INSERT INTO deu1912_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","und der Priester soll's vor dem HERRN weben. Das ist heilig dem Priester samt der Webebrust und der Hebeschulter. Darnach mag der Geweihte Wein trinken. ");
INSERT INTO deu1912_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Das ist das Gesetz des Gottgeweihten, der sein Opfer dem HERRN gelobt wegen seines Gelübdes, außer dem, was er sonst vermag; wie er gelobt hat, soll er tun nach dem Gesetz seines Gelübdes. ");
INSERT INTO deu1912_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Sage Aaron und seinen Söhnen und sprich: Also sollt ihr sagen zu den Kindern Israel, wenn ihr sie segnet: ");
INSERT INTO deu1912_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Der HERR segne dich und behüte dich; ");
INSERT INTO deu1912_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","der HERR lasse sein Angesicht leuchten über dir und sei dir gnädig; ");
INSERT INTO deu1912_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","der HERR hebe sein Angesicht über dich und gebe dir Frieden. ");
INSERT INTO deu1912_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Denn ihr sollt meinen Namen auf die Kinder Israel legen, daß ich sie segne. ");
INSERT INTO deu1912_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Und da Mose die Wohnung aufgerichtet hatte und sie gesalbt und geheiligt allem ihrem Geräte, dazu auch den Altar mit allem seinem Geräte gesalbt und geheiligt, ");
INSERT INTO deu1912_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","da opferten die Fürsten Israels, die Häupter waren in ihren Vaterhäusern; denn sie waren die Obersten unter den Stämmen und standen obenan unter denen, die gezählt waren. ");
INSERT INTO deu1912_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Und sie brachten Opfer vor den HERRN, sechs bedeckte Wagen und zwölf Rinder, je einen Wagen für zwei Fürsten und einen Ochsen für einen, und brachten sie vor die Wohnung. ");
INSERT INTO deu1912_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Und der HERR sprach zu Mose: ");
INSERT INTO deu1912_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Nimm's von ihnen, daß es diene zum Dienst der Hütte des Stifts, und gib's den Leviten, einem jeglichen nach seinem Amt. ");
INSERT INTO deu1912_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Da nahm Mose die Wagen und die Rinder und gab sie den Leviten. ");
INSERT INTO deu1912_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Zwei Wagen und vier Rinder gab er den Kindern Gerson nach ihrem Amt; ");
INSERT INTO deu1912_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","und vier Wagen und acht Ochsen gab er den Kindern Merari nach ihrem Amt unter der Hand Ithamars, des Sohnes Aarons, des Priesters; ");
INSERT INTO deu1912_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","den Kinder Kahath aber gab er nichts, darum daß sie ein heiliges Amt auf sich hatten und auf ihren Achseln tragen mußten. ");
INSERT INTO deu1912_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Und die Fürsten opferten zur Einweihung das Altars an dem Tage, da er gesalbt ward, und opferten ihre Gabe vor dem Altar. ");
INSERT INTO deu1912_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Und der HERR sprach zu Mose: Laß einen jeglichen Fürsten an seinem Tage sein Opfer bringen zur Einweihung des Altars. ");
INSERT INTO deu1912_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Am ersten Tage opferte seine Gabe Nahesson, der Sohn Amminadabs, des Stammes Juda. ");
INSERT INTO deu1912_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Und seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silbern Schale siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Nahessons, des Sohnes Amminadabs. ");
INSERT INTO deu1912_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Am zweiten Tage opferte Nathanael, der Sohn Zuars, der Fürst Isaschars. ");
INSERT INTO deu1912_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Nathanaels, des Sohnes Zuars. ");
INSERT INTO deu1912_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Am dritten Tage der Fürst der Kinder Sebulon, Eliab, der Sohn Helons. ");
INSERT INTO deu1912_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Eliabs, des Sohnes Helons. ");
INSERT INTO deu1912_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Am vierten Tage der Fürst der Kinder Ruben, Elizur, der Sohn Sedeurs. ");
INSERT INTO deu1912_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Elizurs, des Sohnes Sedeurs. ");
INSERT INTO deu1912_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Am fünften Tage der Fürst der Kinder Simeon, Selumiel, der Sohn Zuri-Saddais. ");
INSERT INTO deu1912_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Selumiels, des Sohnes Zuri-Saddais. ");
INSERT INTO deu1912_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Am sechsten Tage der Fürst der Kinder Gad, Eljasaph, der Sohn Deguels. ");
INSERT INTO deu1912_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Eljasaphs, des Sohnes Deguels. ");
INSERT INTO deu1912_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Am siebenten Tage der Fürst der Kinder Ephraim, Elisama, der Sohn Ammihuds. ");
INSERT INTO deu1912_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Elisamas, des Sohnes Ammihuds. ");
INSERT INTO deu1912_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Am achten Tage der Fürst der Kinder Manasses, Gamliel, der Sohn Pedazurs. ");
INSERT INTO deu1912_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Gamliels, des Sohnes Pedazurs. ");
INSERT INTO deu1912_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Am neunten Tage der Fürst der Kinder Benjamin, Abidan, der Sohn des Gideoni. ");
INSERT INTO deu1912_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Abidans, des Sohn's Gideonis. ");
INSERT INTO deu1912_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Am zehnten Tage der Fürst der Kinder Dan, Ahi-Eser, der Sohn Ammi-Saddais. ");
INSERT INTO deu1912_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Ahi-Esers, des Sohnes Ammi-Saddais. ");
INSERT INTO deu1912_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Am elften Tage der Fürst der Kinder Asser, Pagiel, der Sohn Ochrans. ");
INSERT INTO deu1912_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Pagiels, des Sohnes Ochrans. ");
INSERT INTO deu1912_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Am zwölften Tage der Fürst der Kinder Naphthali, Ahira, der Sohn Enans. ");
INSERT INTO deu1912_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Seine Gabe war eine silberne Schüssel, hundertdreißig Lot schwer, eine silberne Schale, siebzig Lot schwer nach dem Lot des Heiligtums, beide voll Semmelmehl, mit Öl gemengt, zum Speisopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","dazu einen goldenen Löffel, zehn Lot schwer, voll Räuchwerk, ");
INSERT INTO deu1912_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","einen jungen Farren, einen Widder, ein jähriges Lamm zum Brandopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","einen Ziegenbock zum Sündopfer; ");
INSERT INTO deu1912_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","und zum Dankopfer zwei Rinder, fünf Widder und fünf jährige Lämmer. Das ist die Gabe Ahiras, des Sohnes Enans. ");
INSERT INTO deu1912_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Das ist die Einweihung des Altars zur Zeit, da er gesalbt ward, dazu die Fürsten Israels opferten diese zwölf silbernen Schüsseln, zwölf silberne Schalen, zwölf goldene Löffel, ");
INSERT INTO deu1912_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","also daß je eine Schüssel hundertdreißig Lot Silber und je eine Schale siebzig Lot hatte, daß die Summe alles Silbers am Gefäß betrug zweitausendvierhundert Lot nach dem Lot des Heiligtums. ");
INSERT INTO deu1912_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Und der zwölf goldenen Löffel voll Räuchwerk hatte je einer zehn Lot nach dem Lot des Heiligtums, daß die Summe Goldes an den Löffeln betrug hundertzwanzig Lot. ");
INSERT INTO deu1912_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Die Summe der Rinder zum Brandopfer waren zwölf Farren, zwölf Widder, zwölf jahrige Lämmer samt ihrem Speisopfer und zwölf Ziegenböcke zum Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Und die Summe der Rinder zum Dankopfer war vierundzwanzig Farren, sechzig Widder, sechzig Böcke, sechzig jährige Lämmer. Das ist die Einweihung des Altars, da er gesalbt ward. ");
INSERT INTO deu1912_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Und wenn Mose in die Hütte des Stifts ging, daß mit ihm geredet würde, so hörte er die Stimme mit ihm reden von dem Gnadenstuhl, der auf der Lade des Zeugnisses war, dort ward mit ihm geredet. ");
INSERT INTO deu1912_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Rede mit Aaron und sprich zu ihm: Wenn du Lampen aufsetzt, sollst du sie also setzen, daß alle sieben vorwärts von dem Leuchter scheinen. ");
INSERT INTO deu1912_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Und Aaron tat also und setzte die Lampen auf, vorwärts von dem Leuchter zu scheinen, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Der Leuchter aber war getriebenes Gold, beide, sein Schaft und seine Blumen; nach dem Gesicht, das der HERR dem Mose gezeigt hatte, also machte er den Leuchter. ");
INSERT INTO deu1912_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Nimm die Leviten aus den Kindern Israel und reinige sie. ");
INSERT INTO deu1912_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Also sollst du aber mit ihnen tun, daß du sie reinigst: du sollst Sündwasser auf sie sprengen, und sie sollen alle ihre Haare rein abscheren und ihre Kleider waschen, so sind sie rein. ");
INSERT INTO deu1912_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Dann sollen sie nehmen einen jungen Farren und sein Speisopfer, Semmelmehl, mit Öl gemengt; und einen andern jungen Farren sollst du zum Sündopfer nehmen. ");
INSERT INTO deu1912_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Und sollst die Leviten vor die Hütte des Stifts bringen und die ganze Gemeinde der Kinder Israel versammeln ");
INSERT INTO deu1912_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","und die Leviten vor den HERRN bringen; und die Kinder Israel sollen ihre Hände auf die Leviten legen, ");
INSERT INTO deu1912_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","und Aaron soll die Leviten vor dem HERRN weben als Webeopfer von den Kindern Israel, auf daß sie dienen mögen in dem Amt des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Und die Leviten sollen ihre Hände aufs Haupt der Farren legen, und einer soll zum Sündopfer, der andere zum Brandopfer dem HERRN gemacht werden, die Leviten zu versöhnen. ");
INSERT INTO deu1912_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Und sollst die Leviten vor Aaron und seine Söhne stellen und vor dem HERRN weben, ");
INSERT INTO deu1912_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","und sollst sie also aussondern von den Kindern Israel, daß sie mein seien. ");
INSERT INTO deu1912_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Darnach sollen sie hineingehen, daß sie dienen in der Hütte des Stifts. Also sollst du sie reinigen und weben; ");
INSERT INTO deu1912_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","denn sie sind mein Geschenk von den Kindern Israel, und ich habe sie mir genommen für alles, was die Mutter bricht, nämlich für die Erstgeburt aller Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Denn alle Erstgeburt unter den Kindern Israel ist mein, der Menschen und des Viehes, seit der Zeit ich alle Erstgeburt in Ägyptenland schlug und heiligte sie mir ");
INSERT INTO deu1912_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","und nahm die Leviten an für alle Erstgeburt unter den Kindern Israel ");
INSERT INTO deu1912_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","und gab sie zum Geschenk Aaron und seinen Söhnen aus den Kindern Israel, daß sie dienen im Amt der Kinder Israel in der Hütte des Stifts, die Kinder Israel zu versöhnen, auf daß nicht unter den Kindern Israel sei eine Plage, so sie sich nahen wollten zum Heiligtum. ");
INSERT INTO deu1912_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Und Mose mit Aaron samt der ganzen Gemeinde der Kinder Israel taten mit den Leviten alles, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Und die Leviten entsündigten sich und wuschen ihre Kleider, und Aaron webte sie vor dem HERRN und versöhnte sie, daß sie rein wurden. ");
INSERT INTO deu1912_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Darnach gingen sie hinein, daß sie ihr Amt täten in der Hütte des Stifts vor Aaron und seinen Söhnen. Wie der HERR dem Mose geboten hatte über die Leviten, also taten sie mit ihnen. ");
INSERT INTO deu1912_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Das ist's, was den Leviten gebührt: von fünfundzwanzig Jahren und darüber taugen sie zum Amt und Dienst in der Hütte des Stifts; ");
INSERT INTO deu1912_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","aber von dem fünfzigsten Jahr an sollen sie ledig sein vom Amt des Dienstes und sollen nicht mehr dienen, ");
INSERT INTO deu1912_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","sondern ihren Brüdern helfen des Dienstes warten an der Hütte des Stifts; des Amts aber sollen sie nicht pflegen. Also sollst du mit den Leviten tun, daß ein jeglicher seines Dienstes warte. ");
INSERT INTO deu1912_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Und der HERR redete mit Mose in der Wüste Sinai im zweiten Jahr, nachdem sie aus Ägyptenland gezogen waren, im ersten Monat, und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Laß die Kinder Israel Passah halten zu seiner Zeit, ");
INSERT INTO deu1912_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","am vierzehnten Tage dieses Monats gegen Abend; zu seiner Zeit sollen sie es halten nach aller seiner Satzung und seinem Recht. ");
INSERT INTO deu1912_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Und Mose redete mit den Kindern Israel, daß sie das Passah hielten. ");
INSERT INTO deu1912_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Und sie hielten Passah am vierzehnten Tage des ersten Monats gegen Abend in der Wüste Sinai; alles, wie der HERR dem Mose geboten hatte, so taten die Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Da waren etliche Männer unrein geworden an einem toten Menschen, daß sie nicht konnten Passah halten des Tages. Die traten vor Mose und Aaron desselben Tages ");
INSERT INTO deu1912_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","und sprachen zu ihm: Wir sind unrein geworden an einem toten Menschen; warum sollen wir geringer sein, daß wir unsere Gabe dem HERRN nicht bringen dürfen zu seiner Zeit unter den Kindern Israel? ");
INSERT INTO deu1912_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose sprach zu ihnen: Harret, ich will hören, was euch der HERR gebietet. ");
INSERT INTO deu1912_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Sage den Kinder Israel und sprich: Wenn jemand unrein an einem Toten oder ferne über Feld ist, unter euch oder unter euren Nachkommen, der soll dennoch dem HERRN Passah halten, ");
INSERT INTO deu1912_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","aber im zweiten Monat, am vierzehnten Tage gegen Abend, und soll's neben ungesäuertem Brot und bitteren Kräutern essen, ");
INSERT INTO deu1912_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","und sie sollen nichts davon übriglassen, bis morgen, auch kein Bein daran zerbrechen und sollen's nach aller Weise des Passah halten. ");
INSERT INTO deu1912_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Wer aber rein und nicht über Feld ist und läßt es anstehen, das Passah zu halten, des Seele soll ausgerottet werden von seinem Volk, darum daß er seine Gabe dem HERRN nicht gebracht hat zu seiner Zeit; er soll seine Sünde tragen. ");
INSERT INTO deu1912_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Und wenn ein Fremdling bei euch wohnt und auch dem HERRN Passah hält, der soll's halten nach der Satzung und dem Recht des Passah. Diese Satzung soll euch gleich sein, dem Fremden wie des Landes Einheimischen. ");
INSERT INTO deu1912_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Und des Tages, da die Wohnung aufgerichtet ward, bedeckte sie eine Wolke auf der Hütte des Zeugnisses; und des Abends bis an den Morgen war über der Wohnung eine Gestalt des Feuers. ");
INSERT INTO deu1912_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Also geschah's immerdar, daß die Wolke sie bedeckte, und des Nachts die Gestalt des Feuers. ");
INSERT INTO deu1912_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Und so oft sich die Wolke aufhob von der Hütte, so zogen die Kinder Israel; und an welchem Ort die Wolke blieb, da lagerten sich die Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nach dem Wort des HERRN zogen die Kinder Israel, und nach seinem Wort lagerten sie sich. Solange die Wolke auf der Wohnung blieb, so lange lagen sie still. ");
INSERT INTO deu1912_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Und wenn die Wolke viele Tage verzog auf der Wohnung, so taten die Kinder Israel nach dem Gebot des HERRN und zogen nicht. ");
INSERT INTO deu1912_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Und wenn's war, daß die Wolke auf der Wohnung nur etliche Tage blieb, so lagerten sie sich nach dem Wort des HERRN und zogen nach dem Wort des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Wenn die Wolke da war von Abend bis an den Morgen und sich dann erhob, so zogen sie; oder wenn sie sich des Tages oder des Nachts erhob, so zogen sie auch. ");
INSERT INTO deu1912_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Wenn sie aber zwei Tage oder einen Monat oder länger auf der Wohnung blieb, so lagen die Kinder Israel und zogen nicht; und wenn sie sich dann erhob, so zogen sie. ");
INSERT INTO deu1912_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Denn nach des HERRN Mund lagen sie, und nach des HERRN Mund zogen sie, daß sie täten, wie der HERR gebot, nach des HERRN Wort durch Mose. ");
INSERT INTO deu1912_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Mache dir zwei Drommeten von getriebenem Silber, daß du sie brauchst, die Gemeinde zu berufen und wenn das Heer aufbrechen soll. ");
INSERT INTO deu1912_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Wenn man mit beiden schlicht bläst, soll sich zu dir versammeln die ganze Gemeinde vor die Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Wenn man nur mit einer schlicht bläst, so sollen sich zu dir versammeln die Fürsten, die Obersten über die Tausende in Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Wenn ihr aber drommetet, so sollen die Lager aufbrechen, die gegen Morgen liegen. ");
INSERT INTO deu1912_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Und wenn ihr zum andernmal drommetet, so sollen die Lager aufbrechen, die gegen Mittag liegen. Denn wenn sie reisen sollen, so sollt ihr drommeten. ");
INSERT INTO deu1912_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Wenn aber die Gemeinde zu versammeln ist, sollt ihr schlicht blasen und nicht drommeten. ");
INSERT INTO deu1912_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Es sollen aber solch Blasen mit den Drommeten die Söhne Aarons, die Priester, tun; und das soll euer Recht sein ewiglich bei euren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Wenn ihr in einen Streit ziehet in eurem Lande wider eure Feinde, die euch bedrängen, so sollt ihr drommeten mit den Drommeten, daß euer gedacht werde vor dem HERRN, eurem Gott, und ihr erlöst werdet von euren Feinden. ");
INSERT INTO deu1912_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Desgleichen, wenn ihr fröhlich seid, und an euren Festen und an euren Neumonden sollt ihr mit den Drommeten blasen über eure Brandopfer und Dankopfer, daß es euch sei zum Gedächtnis vor eurem Gott. Ich bin der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Am zwanzigsten Tage im zweiten Monat des zweiten Jahres erhob sich die Wolke von der Wohnung des Zeugnisses. ");
INSERT INTO deu1912_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Und die Kinder Israel brachen auf und zogen aus der Wüste Sinai, und die Wolke blieb in der Wüste Pharan. ");
INSERT INTO deu1912_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Es brachen aber auf die ersten nach dem Wort des HERRN durch Mose; ");
INSERT INTO deu1912_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","nämlich das Panier des Lagers der Kinder Juda zog am ersten mit ihrem Heer, und über ihr Heer war Nahesson, der Sohn Amminadabs; ");
INSERT INTO deu1912_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","und über das Heer des Stammes der Kinder Isaschar war Nathanael, der Sohn Zuars; ");
INSERT INTO deu1912_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","und über das Heer des Stammes der Kinder Sebulon war Eliab, der Sohn Helons. ");
INSERT INTO deu1912_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Da zerlegte man die Wohnung, und zogen die Kinder Gerson und Merari und trugen die Wohnung. ");
INSERT INTO deu1912_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Darnach zog das Panier des Lagers Rubens mit ihrem Heer, und über ihr Heer war Elizur, der Sohn Sedeurs; ");
INSERT INTO deu1912_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","und über das Heer des Stammes der Kinder Simeon war Selumiel, der Sohn Zuri-Saddais; ");
INSERT INTO deu1912_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","und Eljasaph, der Sohn Deguels, über das Heer des Stammes der Kinder Gad. ");
INSERT INTO deu1912_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Da zogen auch die Kahathiten und trugen das Heiligtum; und jene richteten die Wohnung auf, bis diese nachkamen. ");
INSERT INTO deu1912_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Darnach zog das Panier des Lagers der Kinder Ephraim mit ihrem Heer, und über ihr Heer war Elisama, der Sohn Ammihuds; ");
INSERT INTO deu1912_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","und Gamliel, der Sohn Pedazurs, über das Heer des Stammes der Kinder Manasse; ");
INSERT INTO deu1912_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","und Abidan, der Sohn des Gideoni, über das Heer des Stammes der Kinder Benjamin. ");
INSERT INTO deu1912_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Darnach zog das Panier des Lagers der Kinder Dan mit ihrem Heer; und so waren die Lager alle auf. Und Ahi-Eser, der Sohn Ammi-Saddais, war über ihr Heer; ");
INSERT INTO deu1912_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","und Pagiel, der Sohn Ochrans, über das Heer des Stammes der Kinder Asser; ");
INSERT INTO deu1912_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","und Ahira, der Sohn Enans, über das Heer des Stammes der Kinder Naphthali. ");
INSERT INTO deu1912_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","So zogen die Kinder Israel mit ihrem Heer. ");
INSERT INTO deu1912_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Und Mose sprach zu seinem Schwager Hobab, dem Sohn Reguels, aus Midian: Wir ziehen dahin an die Stätte, davon der HERR gesagt hat: Ich will sie euch geben; so komm nun mit uns, so wollen wir das Beste an dir tun; denn der HERR hat Israel Gutes zugesagt. ");
INSERT INTO deu1912_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Er aber antwortete: Ich will nicht mit euch, sondern in mein Land zu meiner Freundschaft ziehen. ");
INSERT INTO deu1912_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Er sprach: Verlaß uns doch nicht; denn du weißt, wo wir in der Wüste uns lagern sollen, und sollst unser Auge sein. ");
INSERT INTO deu1912_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Und wenn du mit uns ziehst: was der HERR Gutes an uns tut, das wollen wir an dir tun. ");
INSERT INTO deu1912_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Also zogen sie von dem Berge des HERRN drei Tagereisen, und die Lade des Bundes des HERRN zog vor ihnen her die drei Tagereisen, ihnen zu weisen, wo sie ruhen sollten. ");
INSERT INTO deu1912_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Und die Wolke des Herrn war des Tages über ihnen, wenn sie aus dem Lager zogen. ");
INSERT INTO deu1912_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Und wenn die Lade zog, so sprach Mose: HERR, stehe auf! laß deine Feinde zerstreut und die dich hassen, flüchtig werden vor dir! ");
INSERT INTO deu1912_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Und wenn sie ruhte, so sprach er: Komm wieder, HERR, zu der Menge der Tausende Israels! ");
INSERT INTO deu1912_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Und da sich das Volk ungeduldig machte, gefiel es übel vor den Ohren des HERRN. Und als es der HERR hörte, ergrimmte sein Zorn, und zündete das Feuer des HERRN unter ihnen an; das verzehrte die äußersten Lager. ");
INSERT INTO deu1912_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Da schrie das Volk zu Mose, und Mose bat den HERRN; da verschwand das Feuer. ");
INSERT INTO deu1912_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Und man hieß die Stätte Thabeera, darum daß sich unter ihnen des HERRN Feuer angezündet hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Das Pöbelvolk aber unter ihnen war lüstern geworden, und sie saßen und weinten samt den Kindern Israel und sprachen: Wer will uns Fleisch zu essen geben? ");
INSERT INTO deu1912_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Wir gedenken der Fische, die wir in Ägypten umsonst aßen, und der Kürbisse, der Melonen, des Lauchs, der Zwiebeln und des Knoblauchs. ");
INSERT INTO deu1912_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Nun aber ist unsere Seele matt; denn unsere Augen sehen nichts als das Man. ");
INSERT INTO deu1912_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Es war aber das Man wie Koriandersamen und anzusehen wie Bedellion. ");
INSERT INTO deu1912_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Und das Volk lief hin und her und sammelte und zerrieb es mit Mühlen und stieß es in Mörsern und kochte es in Töpfen und machte sich Aschenkuchen daraus; und es hatte einen Geschmack wie ein Ölkuchen. ");
INSERT INTO deu1912_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Und wenn des Nachts der Tau über die Lager fiel, so fiel das Man mit darauf. ");
INSERT INTO deu1912_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Da nun Mose das Volk hörte weinen unter ihren Geschlechtern, einen jeglichen in seiner Hütte Tür, da ergrimmte der Zorn des HERRN sehr, und Mose ward auch bange. ");
INSERT INTO deu1912_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Und Mose sprach zu dem HERRN: Warum bekümmerst du deinen Knecht? und warum finde ich nicht Gnade vor deinen Augen, daß du die Last dieses ganzen Volks auf mich legst? ");
INSERT INTO deu1912_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Habe ich nun all das Volk empfangen oder geboren, daß du zu mir sagen magst: Trag es in deinen Armen, wie eine Amme ein Kind trägt, in das Land, das du ihren Vätern geschworen hast? ");
INSERT INTO deu1912_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Woher soll ich Fleisch nehmen, daß ich allem diesem Volk gebe? Sie weinen vor mir und sprechen: Gib uns Fleisch, daß wir essen. ");
INSERT INTO deu1912_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ich vermag alles das Volk nicht allein zu ertragen; denn es ist mir zu schwer. ");
INSERT INTO deu1912_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Und willst du also mit mir tun, so erwürge ich mich lieber, habe ich anders Gnade vor deinen Augen gefunden, daß ich nicht mein Unglück so sehen müsse. ");
INSERT INTO deu1912_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Und der HERR sprach zu Mose: Sammle mir siebzig Männer unter den Ältesten Israels, von denen du weißt, daß sie Älteste im Volk und seine Amtleute sind, und nimm sie vor die Hütte des Stifts und stelle sie daselbst vor dich, ");
INSERT INTO deu1912_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","so will ich herniederkommen und mit dir daselbst reden und von deinem Geist, der auf dir ist, nehmen und auf sie legen, daß sie mit dir die Last des Volkes tragen, daß du nicht allein tragest. ");
INSERT INTO deu1912_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Und zum Volk sollst du sagen: Heiliget euch auf morgen, daß ihr Fleisch esset; denn euer Weinen ist vor die Ohren des HERRN gekommen, die ihr sprecht: Wer gibt uns Fleisch zu essen? denn es ging uns wohl in Ägypten. Darum wird euch der HERR Fleisch geben, daß ihr esset, ");
INSERT INTO deu1912_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","nicht einen Tag, nicht zwei, nicht fünf, nicht zehn, nicht zwanzig Tage lang, ");
INSERT INTO deu1912_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","sondern einen Monat lang, bis daß es euch zur Nase ausgehe und euch ein Ekel sei; darum daß ihr den HERRN verworfen habt, der unter euch ist, und vor ihm geweint und gesagt: Warum sind wir aus Ägypten gegangen? ");
INSERT INTO deu1912_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Und Mose sprach: Sechshunderttausend Mann Fußvolk ist es, darunter ich bin, und du sprichst Ich will euch Fleisch geben, daß ihr esset einen Monat lang! ");
INSERT INTO deu1912_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Soll man Schafe und Rinder schlachten, daß es ihnen genug sei? Oder werden sich alle Fische des Meeres herzu versammeln, daß es ihnen genug sei? ");
INSERT INTO deu1912_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Der HERR aber sprach zu Mose: Ist denn die Hand des HERRN verkürzt? Aber du sollst jetzt sehen, ob meine Worte können dir etwas gelten oder nicht. ");
INSERT INTO deu1912_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Und Mose ging heraus und sagte dem Volk des HERRN Worte und versammelte siebzig Männer unter den Ältesten des Volks und stellte sie um die Hütte her. ");
INSERT INTO deu1912_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Da kam der HERR hernieder in der Wolke und redete mit ihm und nahm von dem Geist, der auf ihm war, und legte ihn auf die siebzig ältesten Männer. Und da der Geist auf ihnen ruhte, weissagten sie und hörten nicht auf. ");
INSERT INTO deu1912_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Es waren aber noch zwei Männer im Lager geblieben; der eine hieß Eldad, der andere Medad, und der Geist ruhte auf ihnen; denn sie waren auch angeschrieben und doch nicht hinausgegangen zu der Hütte, und sie weissagten im Lager. ");
INSERT INTO deu1912_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Da lief ein Knabe hin und sagte es Mose an und sprach: Eldad und Medad weissagen im Lager. ");
INSERT INTO deu1912_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Da antwortete Josua, der Sohn Nuns, Mose's Diener, den er erwählt hatte, und sprach: Mein Herr Mose, wehre ihnen. ");
INSERT INTO deu1912_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Aber Mose sprach zu ihm: Bist du der Eiferer für mich? Wollte Gott, daß all das Volk des HERRN weissagte und der HERR seinen Geist über sie gäbe! ");
INSERT INTO deu1912_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Also sammelte sich Mose zum Lager mit den Ältesten Israels. ");
INSERT INTO deu1912_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Da fuhr aus der Wind von dem HERRN und ließ Wachteln kommen vom Meer und streute sie über das Lager, hier eine Tagereise lang, da eine Tagereise lang um das Lager her, zwei Ellen hoch über der Erde. ");
INSERT INTO deu1912_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Da machte sich das Volk auf denselben ganzen Tag und die ganze Nacht und den ganzen andern Tag und sammelten Wachteln; und welcher am wenigsten sammelte, der sammelte zehn Homer. Uns sie hängten sie auf um das Lager her. ");
INSERT INTO deu1912_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Da aber das Fleisch noch unter ihren Zähnen war und ehe es aufgezehrt war, da ergrimmte der Zorn des HERRN unter dem Volk, und schlug sie mit einer sehr großen Plage. ");
INSERT INTO deu1912_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Daher heißt diese Stätte Lustgräber, darum daß man daselbst begrub das lüsterne Volk. ");
INSERT INTO deu1912_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Von den Lustgräbern aber zog das Volk aus gen Hazeroth, und sie blieben zu Hazeroth. ");
INSERT INTO deu1912_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Und Mirjam und Aaron redeten wider Mose um seines Weibes willen, der Mohrin, die er genommen hatte, darum daß er eine Mohrin zum Weibe genommen hatte, ");
INSERT INTO deu1912_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","und sprachen: Redet denn der HERR allein durch Mose? Redet er nicht auch durch uns? Und der HERR hörte es. ");
INSERT INTO deu1912_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Aber Mose war ein sehr geplagter Mensch über alle Menschen auf Erden. ");
INSERT INTO deu1912_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Und plötzlich sprach der HERR zu Mose und zu Aaron und zu Mirjam: Geht heraus, ihr drei, zu der Hütte des Stifts. Und sie gingen alle drei heraus. ");
INSERT INTO deu1912_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Da kam der HERR hernieder in der Wolkensäule und trat in der Hütte Tür und rief Aaron und Mirjam; und die beiden gingen hinaus. ");
INSERT INTO deu1912_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Und er sprach: Höret meine Worte: Ist jemand unter euch ein Prophet des HERRN, dem will ich mich kundmachen in einem Gesicht oder will mit ihm reden in einem Traum. ");
INSERT INTO deu1912_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Aber nicht also mein Knecht Mose, der in meinem ganzen Hause treu ist. ");
INSERT INTO deu1912_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mündlich rede ich mit ihm, und er sieht den HERRN in seiner Gestalt, nicht durch dunkle Worte oder Gleichnisse. Warum habt ihr euch denn nicht gefürchtet, wider meinen Knecht Mose zu reden? ");
INSERT INTO deu1912_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Und der Zorn des HERRN ergrimmte über sie, und er wandte sich weg; ");
INSERT INTO deu1912_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","dazu die Wolke wich auch von der Hütte. Und siehe da war Mirjam aussätzig wie der Schnee. Und Aaron wandte sich zu Mirjam und wird gewahr, daß sie aussätzig ist, ");
INSERT INTO deu1912_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Und sprach zu Mose: Ach, mein Herr, laß die Sünde nicht auf uns bleiben, mit der wir töricht getan und uns versündigt haben, ");
INSERT INTO deu1912_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","daß diese nicht sei wie ein Totes, das von seiner Mutter Leibe kommt und ist schon die Hälfte seines Fleisches gefressen. ");
INSERT INTO deu1912_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Mose aber schrie zu dem HERRN und sprach: Ach Gott, heile sie! ");
INSERT INTO deu1912_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Der HERR sprach zu Mose: Wenn ihr Vater ihr ins Angesicht gespieen hätte, sollte sie sich nicht sieben Tage schämen? Laß sie verschließen sieben Tage außerhalb des Lagers; darnach laß sie wieder aufnehmen. ");
INSERT INTO deu1912_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Also ward Mirjam sieben Tage verschlossen außerhalb des Lagers. Und das Volk zog nicht weiter, bis Mirjam aufgenommen ward. ");
INSERT INTO deu1912_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Darnach zog das Volk von Hazeroth und lagerte sich in die Wüste Pharan. ");
INSERT INTO deu1912_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Und der HERR redet mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Sende Männer aus, die das Land Kanaan erkunden, das ich den Kindern Israel geben will, aus jeglichem Stamm ihrer Väter einen vornehmen Mann. ");
INSERT INTO deu1912_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mose, der sandte sie aus der Wüste Pharan nach dem Wort des HERRN, die alle vornehme Männer waren unter den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Und hießen also: Sammua, der Sohn Sakkurs, des Stammes Ruben; ");
INSERT INTO deu1912_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Saphat, der Sohn Horis, des Stammes Simeon; ");
INSERT INTO deu1912_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kaleb, der Sohn Jephunnes, des Stammes Juda; ");
INSERT INTO deu1912_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Jigeal, der Sohn Josephs, des Stammes Isaschar; ");
INSERT INTO deu1912_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hosea, der Sohn Nuns, des Stammes Ephraim; ");
INSERT INTO deu1912_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti, der Sohn Raphus, des Stammes Benjamin; ");
INSERT INTO deu1912_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gaddiel, der Sohn Sodis, des Stammes Sebulon; ");
INSERT INTO deu1912_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gaddi, der Sohn Susis, des Stammes Joseph von Manasse; ");
INSERT INTO deu1912_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Ammiel, der Sohn Gemallis, des Stammes Dan; ");
INSERT INTO deu1912_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Sethur, der Sohn Michaels, des Stammes Asser; ");
INSERT INTO deu1912_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nahebi, der Sohn Vaphsis, des Stammes Naphthali; ");
INSERT INTO deu1912_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Guel, der Sohn Machis, des Stammes Gad. ");
INSERT INTO deu1912_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Das sind die Namen der Männer, die Mose aussandte, zu erkunden das Land. Aber Hosea, den Sohn Nuns, nannte Mose Josua. ");
INSERT INTO deu1912_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Da sie nun Mose sandte, das Land Kanaan zu erkunden, sprach er zu ihnen: Ziehet hinauf ins Mittagsland und geht auf das Gebirge ");
INSERT INTO deu1912_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","und besehet das Land, wie es ist, und das Volk, das darin wohnt, ob's stark oder schwach, wenig oder viel ist; ");
INSERT INTO deu1912_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","und was es für ein Land ist, darin sie wohnen, ob's gut oder böse sei; und was für Städte sind, darin sie wohnen, ob sie in Gezelten oder Festungen wohnen; ");
INSERT INTO deu1912_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","und was es für Land sei, ob's fett oder mager sei und ob Bäume darin sind oder nicht. Seid getrost und nehmet die Früchte des Landes. Es war aber eben um die Zeit der ersten Weintrauben. ");
INSERT INTO deu1912_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Sie gingen hinauf und erkundeten das Land von der Wüste Zin bis gen Rehob, da man gen Hamath geht. ");
INSERT INTO deu1912_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Sie gingen auch hinauf ins Mittagsland und kamen bis gen Hebron; da waren Ahiman, Sesai und Thalmai, die Kinder Enaks. Hebron aber war sieben Jahre gebaut vor Zoan in Ägypten. ");
INSERT INTO deu1912_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Und sie kamen bis an den Bach Eskol und schnitten daselbst eine Rebe ab mit einer Weintraube und ließen sie zwei auf einem Stecken tragen, dazu auch Granatäpfel und Feigen. ");
INSERT INTO deu1912_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Der Ort heißt Bach Eskol um der Traube willen, die die Kinder Israel daselbst abschnitten. ");
INSERT INTO deu1912_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Und sie kehrten um, als sie das Land erkundet hatten, nach vierzig Tagen, ");
INSERT INTO deu1912_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","gingen hin und kamen zu Mose und Aaron und zu der ganzen Gemeinde der Kinder Israel in die Wüste Pharan gen Kades und sagten ihnen wieder und der ganzen Gemeinde, wie es stände, und ließen sie die Früchte des Landes sehen. ");
INSERT INTO deu1912_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Und erzählten ihnen und sprachen: Wir sind in das Land gekommen, dahin ihr uns sandtet, darin Milch und Honig fließt, und dies ist seine Frucht; ");
INSERT INTO deu1912_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","nur, daß starkes Volk darin wohnt und sehr große und feste Städte sind; und wir sahen auch Enaks Kinder daselbst. ");
INSERT INTO deu1912_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","So wohnen die Amalekiter im Lande gegen Mittag, die Hethiter und Jebusiter und Amoriter wohnen auf dem Gebirge, die Kanaaniter aber wohnen am Meer und um den Jordan. ");
INSERT INTO deu1912_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb aber stillte das Volk gegen Mose und sprach: Laßt uns hinaufziehen und das Land einnehmen; denn wir können es überwältigen. ");
INSERT INTO deu1912_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Aber die Männer, die mit ihm waren hinaufgezogen, sprachen: Wir vermögen nicht hinaufzuziehen gegen das Volk; denn sie sind uns zu stark, ");
INSERT INTO deu1912_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","und machten dem Lande, das sie erkundet hatten, ein böses Geschrei unter den Kindern Israel und sprachen: Das Land, dadurch wir gegangen sind, es zu erkunden, frißt seine Einwohner, und alles Volk, das wir darin sahen, sind Leute von großer Länge. ");
INSERT INTO deu1912_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Wir sahen auch Riesen daselbst, Enaks Kinder von den Riesen; und wir waren vor unsern Augen wie Heuschrecken, und also waren wir auch vor ihren Augen. ");
INSERT INTO deu1912_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Da fuhr die ganze Gemeinde auf und schrie, und das Volk weinte die Nacht. ");
INSERT INTO deu1912_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Und alle Kinder Israel murrten wider Mose und Aaron, und die ganze Gemeinde sprach zu ihnen: Ach, daß wir in Ägyptenland gestorben wären oder noch stürben in dieser Wüste! ");
INSERT INTO deu1912_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Warum führt uns der HERR in dies Land, daß wir durchs Schwert fallen und unsere Weiber und unsere Kinder ein Raub werden? Ist's nicht besser, wir ziehen wieder nach Ägypten? ");
INSERT INTO deu1912_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Und einer sprach zu dem andern: Laßt uns einen Hauptmann aufwerfen und wieder nach Ägypten ziehen! ");
INSERT INTO deu1912_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mose aber und Aaron fielen auf ihr Angesicht vor der ganzen Versammlung der Gemeinde der Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Und Josua, der Sohn Nuns, und Kaleb, der Sohn Jephunnes, die auch das Land erkundet hatten, zerrissen ihre Kleider ");
INSERT INTO deu1912_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","und sprachen zu der ganzen Gemeinde der Kinder Israel: Das Land, das wir durchwandelt haben, es zu erkunden, ist sehr gut. ");
INSERT INTO deu1912_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Wenn der HERR uns gnädig ist, so wird er uns in das Land bringen und es uns geben, ein Land, darin Milch und Honig fließt. ");
INSERT INTO deu1912_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Fallt nur nicht ab vom HERRN und fürchtet euch vor dem Volk dieses Landes nicht; denn wir wollen sie wie Brot fressen. Es ist ihr Schutz von ihnen gewichen; der HERR aber ist mit uns. Fürchtet euch nicht vor ihnen. ");
INSERT INTO deu1912_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Da sprach das ganze Volk, man sollte sie steinigen. Da erschien die Herrlichkeit des HERRN in der Hütte des Stifts allen Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Und der HERR sprach zu Mose: Wie lange lästert mich dies Volk? und wie lange wollen sie nicht an mich glauben durch allerlei Zeichen, die ich unter ihnen getan habe? ");
INSERT INTO deu1912_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","So will ich sie mit Pestilenz schlagen und vertilgen und dich zu einem größeren und mächtigeren Volk machen, denn dies ist. ");
INSERT INTO deu1912_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mose aber sprach zu dem HERRN: So werden's die Ägypter hören; denn du hast dies Volk mit deiner Kraft mitten aus ihnen geführt. ");
INSERT INTO deu1912_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Und man wird es sagen zu den Einwohnern dieses Landes, die da gehört haben, daß du, HERR, unter diesem Volk seist, daß du von Angesicht gesehen werdest und deine Wolke stehe über ihnen und du, HERR, gehest vor ihnen her in der Wolkensäule des Tages und Feuersäule des Nachts. ");
INSERT INTO deu1912_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Würdest du nun dies Volk töten, wie einen Mann, so würden die Heiden sagen, die solch Gerücht von dir hören, und sprechen: ");
INSERT INTO deu1912_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Der HERR konnte mitnichten dies Volk in das Land bringen, das er ihnen geschworen hatte; darum hat er sie geschlachtet in der Wüste. ");
INSERT INTO deu1912_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","So laß nun die Kraft des Herrn groß werden, wie du gesagt hast und gesprochen: ");
INSERT INTO deu1912_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Der HERR ist geduldig und von großer Barmherzigkeit und vergibt Missetat und Übertretung und läßt niemand ungestraft sondern sucht heim die Missetat der Väter über die Kinder ins dritte und vierte Glied. ");
INSERT INTO deu1912_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","So sei nun gnädig der Missetat dieses Volks nach deiner großen Barmherzigkeit, wie du auch vergeben hast diesem Volk aus Ägypten bis hierher. ");
INSERT INTO deu1912_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Und der HERR sprach: Ich habe es vergeben, wie du gesagt hast. ");
INSERT INTO deu1912_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Aber so wahr als ich lebe, so soll alle Herrlichkeit des HERRN voll werden. ");
INSERT INTO deu1912_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Denn alle die Männer, die meine Herrlichkeit und meine Zeichen gesehen haben, die ich getan habe in Ägypten und in der Wüste, und mich nun zehnmal versucht und meiner Stimme nicht gehorcht haben, ");
INSERT INTO deu1912_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","deren soll keiner das Land sehen, das ich ihren Vätern geschworen habe; auch keiner soll es sehen, der mich verlästert hat. ");
INSERT INTO deu1912_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Aber meinen Knecht Kaleb, darum daß ein anderer Geist mit ihm ist und er mir treulich nachgefolgt ist, den will ich in das Land bringen, darein er gekommen ist, und sein Same soll es einnehmen, ");
INSERT INTO deu1912_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","dazu die Amalekiter und Kanaaniter, die im Tale wohnen. Morgen wendet euch und ziehet in die Wüste auf dem Wege zum Schilfmeer. ");
INSERT INTO deu1912_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Wie lange murrt diese böse Gemeinde wider mich? Denn ich habe das Murren der Kinder Israel, das sie wider mich gemurrt haben, gehört. ");
INSERT INTO deu1912_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Darum sprich zu ihnen: So wahr ich lebe, spricht der HERR, ich will euch tun, wie ihr vor meinen Ohren gesagt habt. ");
INSERT INTO deu1912_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Eure Leiber sollen in dieser Wüste verfallen; und alle, die ihr gezählt seid von zwanzig Jahren und darüber, die ihr wider mich gemurrt habt, ");
INSERT INTO deu1912_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","sollt nicht in das Land kommen, darüber ich meine Hand gehoben habe, daß ich euch darin wohnen ließe, außer Kaleb, dem Sohn Jephunnes, und Josua, dem Sohn Nuns. ");
INSERT INTO deu1912_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Eure Kinder, von denen ihr sagtet: Sie werden ein Raub sein, die will ich hineinbringen, daß sie erkennen sollen das Land, das ihr verwerft. ");
INSERT INTO deu1912_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Aber ihr samt euren Leibern sollt in dieser Wüste verfallen. ");
INSERT INTO deu1912_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Und eure Kinder sollen Hirten sein in dieser Wüste vierzig Jahre und eure Untreue tragen, bis daß eure Leiber aufgerieben werden in der Wüste, ");
INSERT INTO deu1912_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Nach der Zahl der vierzig Tage, darin ihr das Land erkundet habt; je ein Tag soll ein Jahr gelten, daß ihr vierzig Jahre eure Missetaten tragt; auf daß ihr innewerdet, was es sei, wenn ich die Hand abziehe. ");
INSERT INTO deu1912_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ich, der HERR, habe es gesagt; das will ich auch tun aller dieser bösen Gemeinde, die sich wider mich empört hat. In dieser Wüste sollen sie aufgerieben werden und daselbst sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Also starben durch die Plage vor dem HERRN alle die Männer, die Mose gesandt hatte, das Land zu erkunden, und wiedergekommen waren und wider ihn murren machten die ganze Gemeinde, ");
INSERT INTO deu1912_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","damit daß sie dem Lande ein Geschrei machten, daß es böse wäre. ");
INSERT INTO deu1912_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Aber Josua, der Sohn Nuns, und Kaleb, der Sohn Jephunnes, blieben lebendig aus den Männern, die gegangen waren, das Land zu erkunden. ");
INSERT INTO deu1912_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Und Mose redete diese Worte zu allen Kindern Israel. Da trauerte das Volk sehr, ");
INSERT INTO deu1912_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","und sie machten sich des Morgens früh auf und zogen auf die Höhe des Gebirges und sprachen: Hier sind wir und wollen hinaufziehen an die Stätte, davon der HERR gesagt hat; denn wir haben gesündigt. ");
INSERT INTO deu1912_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mose aber sprach: Warum übertretet ihr also das Wort des HERRN? Es wird euch nicht gelingen. ");
INSERT INTO deu1912_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ziehet nicht hinauf, denn der HERR ist nicht unter Euch, daß ihr nicht geschlagen werdet vor euren Feinden. ");
INSERT INTO deu1912_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Denn die Amalekiter und Kanaaniter sind vor euch daselbst, und ihr werdet durchs Schwert fallen, darum daß ihr euch vom HERRN gekehrt habt, und der HERR wird nicht mit euch sein. ");
INSERT INTO deu1912_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Aber sie waren störrig, hinaufzuziehen auf die Höhe des Gebirges; aber die Lade des Bundes des HERRN und Mose kamen nicht aus dem Lager. ");
INSERT INTO deu1912_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Da kamen die Amalekiter und Kanaaniter, die auf dem Gebirge wohnten, herab und schlugen und zersprengten sie bis gen Horma. ");
INSERT INTO deu1912_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Rede mit den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land eurer Wohnung kommt, das ich euch geben werde, ");
INSERT INTO deu1912_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","und wollt dem HERRN Opfer tun, es sei ein Brandopfer oder ein Opfer zum besonderen Gelübde oder ein freiwilliges Opfer oder euer Festopfer, auf daß ihr dem HERRN einen süßen Geruch machet von Rindern oder von Schafen: ");
INSERT INTO deu1912_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","wer nun seine Gabe dem HERRN opfern will, der soll das Speisopfer tun, ein Zehntel Semmelmehl, mit einem viertel Hin Öl; ");
INSERT INTO deu1912_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","und Wein zum Trankopfer, auch ein viertel Hin, zu dem Brandopfer oder sonst zu dem Opfer, da ein Lamm geopfert wird. ");
INSERT INTO deu1912_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Wenn aber ein Widder geopfert wird, sollst du das Speisopfer machen aus zwei Zehntel Semmelmehl, mit einem drittel Hin Öl gemengt, ");
INSERT INTO deu1912_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","und Wein zum Trankopfer, auch ein drittel Hin; das sollst du dem HERRN zum süßen Geruch opfern. ");
INSERT INTO deu1912_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Willst du aber ein Rind zum Brandopfer oder zum besonderen Gelübdeopfer oder zum Dankopfer dem HERRN machen, ");
INSERT INTO deu1912_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","so sollst du zu dem Rind ein Speisopfer tun, drei Zehntel Semmelmehl, mit einem halben Hin Öl gemengt, ");
INSERT INTO deu1912_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","und Wein zum Trankopfer, auch ein halbes Hin; das ist ein Opfer dem HERRN zum süßen Geruch. ");
INSERT INTO deu1912_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Also sollst du tun mit einem Ochsen, mit einem Widder, mit einem Schaf oder mit einer Ziege. ");
INSERT INTO deu1912_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Darnach die Zahl dieser Opfer ist, darnach soll auch die Zahl der Speisopfer und Trankopfer sein. ");
INSERT INTO deu1912_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Wer ein Einheimischer ist, der soll solches tun, daß er dem HERRN opfere ein Opfer zum süßen Geruch. ");
INSERT INTO deu1912_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Und wenn ein Fremdling bei euch wohnt oder unter euch bei euren Nachkommen ist, und will dem HERRN ein Opfer zum süßen Geruch tun, der soll tun, wie ihr tut. ");
INSERT INTO deu1912_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Der ganzen Gemeinde sei eine Satzung, euch sowohl als den Fremdlingen; eine ewige Satzung soll das sein euren Nachkommen, daß vor dem HERRN der Fremdling sei wie ihr. ");
INSERT INTO deu1912_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ein Gesetz, ein Recht soll euch und dem Fremdling sein, der bei euch wohnt. ");
INSERT INTO deu1912_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Rede mit den Kindern Israel und sprich zu ihnen: Wenn ihr in das Land kommt, darein ich euch bringen werde, ");
INSERT INTO deu1912_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","daß ihr esset von dem Brot im Lande, sollt ihr dem HERRN eine Hebe geben: ");
INSERT INTO deu1912_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","als eures Teiges Erstling sollt ihr einen Kuchen zur Hebe geben; wie die Hebe von der Scheune, ");
INSERT INTO deu1912_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","also sollt ihr auch dem HERRN eures Teiges Erstling zur Hebe geben bei euren Nachkommen. ");
INSERT INTO deu1912_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Und wenn ihr aus Versehen dieser Gebote irgend eins nicht tut, die der HERR zu Mose geredet hat, ");
INSERT INTO deu1912_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","alles, was der HERR euch durch Mose geboten hat, von dem Tage an, da er anfing zu gebieten auf eure Nachkommen; ");
INSERT INTO deu1912_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","wenn nun ohne Wissen der Gemeinde etwas versehen würde, so soll die ganze Gemeinde einen jungen Farren aus den Rindern zum Brandopfer machen, zum süßen Geruch dem HERRN, samt seinem Speisopfer, wie es recht ist, und einen Ziegenbock zum Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Und der Priester soll also die ganze Gemeinde der Kinder Israel versöhnen, so wird's ihnen vergeben sein; denn es ist ein Versehen. Und sie sollen bringen solch ihre Gabe zum Opfer dem HERRN und ihr Sündopfer vor dem HERRN über ihr Versehen, ");
INSERT INTO deu1912_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","so wird's vergeben der ganzen Gemeinde der Kinder Israel, dazu auch dem Fremdling, der unter euch wohnt, weil das ganze Volk an solchem versehen teilhat. ");
INSERT INTO deu1912_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Wenn aber eine Seele aus Versehen sündigen wird, die soll eine jährige Ziege zum Sündopfer bringen. ");
INSERT INTO deu1912_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Und der Priester soll versöhnen solche Seele, die aus Versehen gesündigt hat, vor dem HERRN, daß er sie versöhne und ihr vergeben werde. ");
INSERT INTO deu1912_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Und es soll ein Gesetz sein für die, so ein Versehen begehen, für den Einheimischen unter den Kindern Israel und für den Fremdling, der unter ihnen wohnt. ");
INSERT INTO deu1912_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Wenn aber eine Seele aus Frevel etwas tut, es sei ein Einheimischer oder Fremdling, der hat den HERRN geschmäht. Solche Seele soll ausgerottet werden aus ihrem Volk; ");
INSERT INTO deu1912_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","denn sie hat des HERRN Wort verachtet und sein Gebot lassen fahren. Ja, sie soll ausgerottet werden; die Schuld sei ihr. ");
INSERT INTO deu1912_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Als nun die Kinder Israel in der Wüste waren, fanden sie einen Mann Holz lesen am Sabbattage. ");
INSERT INTO deu1912_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Und die ihn darob gefunden hatten, da er das Holz las, brachten sie ihn zu Mose und Aaron und vor die ganze Gemeinde. ");
INSERT INTO deu1912_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Und sie legten ihn gefangen; denn es war nicht klar ausgedrückt, was man mit ihm tun sollte. ");
INSERT INTO deu1912_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Der HERR aber sprach zu Mose: Der Mann soll des Todes sterben; die ganze Gemeinde soll ihn steinigen draußen vor dem Lager. ");
INSERT INTO deu1912_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Da führte die ganze Gemeinde ihn hinaus vor das Lager und steinigten ihn, daß er starb, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Und der HERR sprach zu Mose: ");
INSERT INTO deu1912_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Rede mit den Kindern Israel und sprich zu ihnen, daß sie sich Quasten machen an den Zipfeln ihrer Kleider samt allen ihren Nachkommen, und blaue Schnüre auf die Quasten an die Zipfel tun; ");
INSERT INTO deu1912_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","und sollen euch die Quasten dazu dienen, daß ihr sie ansehet und gedenket aller Gebote des HERRN und tut sie, daß ihr nicht von eures Herzens Dünken noch von euren Augen euch umtreiben lasset und abgöttisch werdet. ");
INSERT INTO deu1912_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Darum sollt ihr gedenken und tun alle meine Gebote und heilig sein eurem Gott. ");
INSERT INTO deu1912_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ich bin der HERR, euer Gott, der euch aus Ägyptenland geführt hat, daß ich euer Gott wäre, ich, der HERR, euer Gott. ");
INSERT INTO deu1912_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Und Korah, der Sohn Jizhars, des Sohnes Kahaths, des Sohnes Levis, samt Dathan und Abiram, den Söhnen Eliabs, und On, dem Sohn Peleths, den Söhnen Rubens, ");
INSERT INTO deu1912_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","die empörten sich wider Mose samt etlichen Männern unter den Kindern Israel, zweihundertundfünfzig, Vornehmste in der Gemeinde, Ratsherren und namhafte Leute. ");
INSERT INTO deu1912_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Und sie versammelten sich wider Mose und Aaron und sprachen zu ihnen: Ihr macht's zu viel. Denn die ganze Gemeinde ist überall heilig, und der HERR ist unter ihnen; warum erhebt ihr euch über die Gemeinde des HERRN? ");
INSERT INTO deu1912_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Da das Mose hörte, fiel er auf sein Angesicht ");
INSERT INTO deu1912_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","und sprach zu Korah und zu seiner ganzen Rotte: Morgen wird der HERR kundtun, wer sein sei, wer heilig sei und zu ihm nahen soll; welchen er erwählt, der soll zu ihm nahen. ");
INSERT INTO deu1912_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Das tut: nehmet euch Pfannen, Korah und seine ganze Rotte, ");
INSERT INTO deu1912_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","und legt Feuer darein und tut Räuchwerk darauf vor dem HERRN morgen. Welchen der HERR erwählt, der sei heilig. Ihr macht es zu viel, ihr Kinder Levi. ");
INSERT INTO deu1912_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Und Mose sprach zu Korah: Höret doch, ihr Kinder Levi! ");
INSERT INTO deu1912_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ist's euch zu wenig, daß euch der Gott Israels ausgesondert hat von der Gemeinde Israel, daß ihr zu ihm nahen sollt, daß ihr dienet im Amt der Wohnung des HERRN und vor die Gemeinde tretet, ihr zu dienen? ");
INSERT INTO deu1912_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Er hat dich und alle deine Brüder, die Kinder Levi, samt dir zu sich genommen; und ihr sucht nun auch das Priestertum? ");
INSERT INTO deu1912_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Du und deine ganze Rotte macht einen Aufruhr wider den HERRN. Was ist Aaron, daß ihr wider ihn murrt? ");
INSERT INTO deu1912_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Und Mose schickte hin und ließ Dathan und Abiram rufen, die Söhne Eliabs. Sie aber sprachen: Wir kommen nicht hinauf. ");
INSERT INTO deu1912_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ist's zu wenig, daß du uns aus dem Lande geführt hast, darin Milch und Honig fließt, daß du uns tötest in der Wüste? Du mußt auch noch über uns herrschen? ");
INSERT INTO deu1912_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Wie fein hast du uns gebracht in ein Land, darin Milch und Honig fließt, und hast uns Äcker und Weinberge zum Erbteil gegeben! Willst du den Leuten auch die Augen ausreißen? Wir kommen nicht hinauf. ");
INSERT INTO deu1912_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Da ergrimmte Mose sehr und sprach zu dem HERRN: Wende dich nicht zu ihrem Speisopfer! Ich habe nicht einen Esel von ihnen genommen und habe ihrer keinem nie ein Leid getan. ");
INSERT INTO deu1912_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Und er sprach zu Korah: Du und deine Rotte sollt morgen vor dem HERRN sein; du, sie auch und Aaron. ");
INSERT INTO deu1912_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Und ein jeglicher nehme seine Pfanne und lege Räuchwerk darauf, und tretet herzu vor den HERRN, ein jeglicher mit seiner Pfanne, das sind zweihundertundfünfzig Pfannen; auch Du Aaron, ein jeglicher mit seiner Pfanne. ");
INSERT INTO deu1912_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Und ein jeglicher nahm seine Pfanne und legte Feuer und Räuchwerk darauf; und sie traten vor die Tür der Hütte des Stifts, und Mose und Aaron auch. ");
INSERT INTO deu1912_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Und Korah versammelte wider sie die ganze Gemeinde vor der Tür der Hütte des Stifts. Aber die Herrlichkeit des HERRN erschien vor der ganzen Gemeinde. ");
INSERT INTO deu1912_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Scheidet euch von dieser Gemeinde, daß ich sie plötzlich vertilge. ");
INSERT INTO deu1912_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Sie fielen aber auf ihr Angesicht und sprachen: Ach Gott, der du bist ein Gott der Geister alles Fleisches, wenn ein Mann gesündigt hat, willst du darum über die ganze Gemeinde wüten? ");
INSERT INTO deu1912_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Sage der Gemeinde und sprich: Weicht ringsherum von der Wohnung Korahs und Dathans und Abirams. ");
INSERT INTO deu1912_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Und Mose stand auf und ging zu Dathan und Abiram, und die Ältesten Israels folgten ihm nach, ");
INSERT INTO deu1912_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","und er redete mit der Gemeinde und sprach: Weichet von den Hütten dieser gottlosen Menschen und rührt nichts an, was ihr ist, daß ihr nicht vielleicht umkommt in irgend einer ihrer Sünden. ");
INSERT INTO deu1912_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Und sie gingen hinweg von der Hütte Korahs, Dathans und Abirams. Dathan aber und Abiram gingen heraus und traten an die Tür ihrer Hütten mit ihren Weibern und Söhnen und Kindern. ");
INSERT INTO deu1912_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Und Mose sprach: Dabei sollt ihr merken, daß mich der HERR gesandt hat, daß ich alle diese Werke täte, und nicht aus meinem Herzen: ");
INSERT INTO deu1912_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","werden sie sterben, wie alle Menschen sterben, oder heimgesucht, wie alle Menschen heimgesucht werden, so hat mich der HERR nicht gesandt; ");
INSERT INTO deu1912_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","wird aber der HERR etwas Neues schaffen, daß die Erde ihren Mund auftut und verschlingt sie mit allem, was sie haben, daß sie lebendig hinunter in die Hölle fahren, so werdet ihr erkennen, daß diese Leute den HERRN gelästert haben. ");
INSERT INTO deu1912_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Und als er diese Worte hatte alle ausgeredet, zerriß die Erde unter ihnen ");
INSERT INTO deu1912_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","und tat ihren Mund auf und verschlang sie mit ihren Häusern, mit allen Menschen, die bei Korah waren, und mit aller ihrer Habe; ");
INSERT INTO deu1912_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","und sie fuhren hinunter lebendig in die Hölle mit allem, was sie hatten, und die Erde deckte sie zu, und kamen um aus der Gemeinde. ");
INSERT INTO deu1912_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Und ganz Israel, das um sie her war, floh vor ihrem Geschrei; denn sie sprachen: daß uns die Erde nicht auch verschlinge! ");
INSERT INTO deu1912_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Dazu fuhr das Feuer aus von dem HERRN und fraß die zweihundertundfünfzig Männer, die das Räuchwerk opferten. ");
INSERT INTO deu1912_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","17:1 Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","17:2 Sage Eleasar, dem Sohn Aarons, des Priesters, daß er die Pfannen aufhebe aus dem Brand und streue das Feuer hin und her; ");
INSERT INTO deu1912_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","17:3 denn die Pfannen solcher Sünder sind dem Heiligtum verfallen durch ihre Seelen. Man schlage sie zu breiten Blechen, daß man den Altar damit überziehe; denn sie sind geopfert vor dem HERRN und geheiligt und sollen den Kindern Israel zum Zeichen sein. ");
INSERT INTO deu1912_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","17:4 Und Eleasar, der Priester, nahm die ehernen Pfannen, die die Verbrannten geopfert hatten und schlug sie zu Blechen, den Altar zu überziehen, ");
INSERT INTO deu1912_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","17:5 zum Gedächtnis der Kinder Israel, daß nicht jemand Fremdes sich herzumache, der nicht ist des Samens Aarons, zu opfern Räuchwerk vor dem HERRN, auf daß es ihm nicht gehe wie Korah und seiner Rotte, wie der HERR ihm geredet hatte durch Mose. ");
INSERT INTO deu1912_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","17:6 Des andern Morgens aber murrte die ganze Gemeinde der Kinder Israel wider Mose und Aaron, und sprachen: Ihr habt des HERRN Volk getötet. ");
INSERT INTO deu1912_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","17:7 Und da sich die Gemeinde versammelte wider Mose und Aaron, wandten sie sich zu der Hütte des Stifts. Und siehe, da bedeckte es die Wolke, und die Herrlichkeit des HERRN erschien. ");
INSERT INTO deu1912_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","17:8 Und Mose und Aaron gingen herzu vor die Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","17:9 Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","17:10 Hebt euch aus dieser Gemeinde; ich will sie plötzlich vertilgen! Und sie fielen auf ihr Angesicht. ");
INSERT INTO deu1912_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","17:11 Und Mose sprach zu Aaron: Nimm die Pfanne und tue Feuer darein vom Altar und lege Räuchwerk darauf und gehe eilend zu der Gemeinde und versöhne sie; denn das Wüten ist von dem HERRN ausgegangen, und die Plage ist angegangen. ");
INSERT INTO deu1912_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","17:12 Und Aaron nahm wie ihm Mose gesagt hatte, und lief mitten unter die Gemeinde (und siehe, die Plage war angegangen unter dem Volk) und räucherte und versöhnte das Volk ");
INSERT INTO deu1912_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","17:13 und stand zwischen den Toten und den Lebendigen. Da ward der Plage gewehrt. ");
INSERT INTO deu1912_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","17:14 Derer aber, die an der Plage gestorben waren, waren vierzehntausend und siebenhundert, ohne die, so mit Korah starben. ");
INSERT INTO deu1912_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","17:15 Und Aaron kam wieder zu Mose vor die Tür der Hütte des Stifts, und der Plage ward gewehrt. ");
INSERT INTO deu1912_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","17:16 Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","17:17 Sage den Kindern Israel und nimm von ihnen zwölf Stecken, von Jeglichem Fürsten seines Vaterhauses einen, und schreib eines jeglichen Namen auf seinen Stecken. ");
INSERT INTO deu1912_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","17:18 Aber den Namen Aarons sollst du schreiben auf den Stecken Levis. Denn je für ein Haupt ihrer Vaterhäuser soll ein Stecken sein. ");
INSERT INTO deu1912_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","17:19 Und lege sie in die Hütte des Stifts vor dem Zeugnis, da ich mich euch bezeuge. ");
INSERT INTO deu1912_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","17:20 Und welchen ich erwählen werde, des Stecken wird grünen, daß ich das Murren der Kinder Israel, das sie wider euch murren, stille. ");
INSERT INTO deu1912_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","17:21 Mose redete mit den Kindern Israel, und alle ihre Fürsten gaben ihm zwölf Stecken, ein jeglicher Fürst einen Stecken, nach ihren Vaterhäusern; und der Stecken Aarons war auch unter ihren Stecken. ");
INSERT INTO deu1912_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","17:22 Und Mose legte die Stecken vor den HERRN in der Hütte des Zeugnisses. ");
INSERT INTO deu1912_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","17:23 Des Morgens aber, da Mose in die Hütte des Zeugnisses ging, fand er den Stecken Aarons des Hauses Levi grünen und die Blüte aufgegangen und Mandeln tragen. ");
INSERT INTO deu1912_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","17:24 Und Mose trug die Stecken alle heraus von dem HERRN vor alle Kinder Israel, daß sie es sahen; und ein jeglicher nahm seinen Stecken. ");
INSERT INTO deu1912_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","17:25 Der HERR sprach aber zu Mose: Trage den Stecken Aarons wieder vor das Zeugnis, daß er verwahrt werde zum Zeichen den ungehorsamen Kindern, daß ihr Murren von mir aufhöre, daß sie nicht sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","17:26 Mose tat wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","17:27 Und die Kinder Israel sprachen zu Mose: Siehe, wir verderben und kommen um; wir werden alle vertilgt und kommen um. ");
INSERT INTO deu1912_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","17:28 Wer sich naht zur Wohnung des HERRN, der stirbt. Sollen wir denn ganz und gar untergehen? ");
INSERT INTO deu1912_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Und der HERR sprach zu Aaron: Du und deine Söhne und deines Vaters Haus mit dir sollt die Missetat des Heiligtums tragen; und du und deine Söhne mit dir sollt die Missetat eures Priestertums tragen. ");
INSERT INTO deu1912_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Aber deine Brüder des Stammes Levis, deines Vaters, sollst du zu dir nehmen, daß sie bei dir seien und dir dienen; du aber und deine Söhne mit dir vor der Hütte des Zeugnisses. ");
INSERT INTO deu1912_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Und sie sollen deines Dienstes und des Dienstes der ganzen Hütte warten. Doch zu dem Gerät des Heiligtums und zu dem Altar sollen sie nicht nahen, daß nicht beide, sie und ihr, sterbet; ");
INSERT INTO deu1912_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","sondern sie sollen bei dir sein, daß sie des Dienstes warten an der Hütte des Stifts in allem Amt der Hütte; und kein Fremder soll sich zu euch tun. ");
INSERT INTO deu1912_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","So wartet nun des Dienstes des Heiligtums und des Dienstes des Altars, daß hinfort nicht mehr ein Wüten komme über die Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Denn siehe, ich habe die Leviten, eure Brüder, genommen aus den Kindern Israel, dem HERRN zum Geschenk, und euch gegeben, daß sie des Amts pflegen an der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Du aber und deine Söhne mit dir sollt eures Priestertums warten, daß ihr dienet in allerlei Geschäft des Altars und inwendig hinter dem Vorhang; denn euer Priestertum gebe ich euch zum Amt, zum Geschenk. Wenn ein Fremder sich herzutut, der soll sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Und der HERR sagte zu Aaron: Siehe, ich habe dir gegeben meine Hebopfer von allem, was die Kinder Israel heiligen, als Gebühr dir und deinen Söhnen zum ewigen Recht. ");
INSERT INTO deu1912_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Das sollst du haben von dem Hochheiligen: Was nicht angezündet wird von allen ihren Gaben an allen ihren Speisopfern und an allen ihren Sündopfern und an allen ihren Schuldopfern, die sie mir geben, das soll dir und deinen Söhnen ein Hochheiliges sein. ");
INSERT INTO deu1912_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","An einem heiligen Ort sollst du es essen. Was männlich ist, soll davon essen; denn es soll dir heilig sein. ");
INSERT INTO deu1912_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ich habe auch das Hebopfer ihrer Gabe an allen Webeopfern der Kinder Israel dir gegeben und deinen Söhnen und Töchtern samt dir zum ewigen Recht; wer rein ist in deinem Hause, soll davon essen. ");
INSERT INTO deu1912_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Alles beste Öl und alles Beste vom Most und Korn, nämlich ihre Erstlinge, die sie dem HERRN geben, habe ich dir gegeben. ");
INSERT INTO deu1912_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Die erste Frucht, die sie dem HERRN bringen von allem, was in ihrem Lande ist, soll dein sein; wer rein ist in deinem Hause, soll davon essen. ");
INSERT INTO deu1912_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Alles Verbannte in Israel soll dein sein. ");
INSERT INTO deu1912_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Alles, was die Mutter bricht unter allem Fleisch, das sie dem HERRN bringen, es sei ein Mensch oder Vieh, soll dein sein; doch daß du die erste Menschenfrucht lösen lassest und die erste Frucht eines unreinen Viehs auch lösen lassest. ");
INSERT INTO deu1912_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Sie sollen's aber lösen, wenn's einen Monat alt ist; und sollst es zu lösen geben um Geld, um fünf Silberlinge nach dem Lot des Heiligtums, das hat zwanzig Gera. ");
INSERT INTO deu1912_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Aber die erste Frucht eines Rindes oder Schafes oder einer Ziege sollst du nicht zu lösen geben, denn sie sind heilig; ihr Blut sollst du sprengen auf den Altar, und ihr Fett sollst du anzünden zum Opfer des süßen Geruchs dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ihr Fleisch soll dein sein, wie auch die Webebrust und die rechte Schulter dein ist. ");
INSERT INTO deu1912_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Alle Hebeopfer, die die Kinder Israel heiligen dem HERRN, habe ich dir gegeben und deinen Söhnen und deinen Töchtern samt dir zum ewigen Recht. Das soll ein unverweslicher Bund sein ewig vor dem HERRN, dir und deinem Samen samt dir. ");
INSERT INTO deu1912_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Und der HERR sprach zu Aaron: Du sollst in ihrem Lande nichts besitzen, auch kein Teil unter ihnen haben; denn ich bin dein Teil und dein Erbgut unter den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Den Kindern Levi aber habe ich alle Zehnten gegeben in Israel zum Erbgut für ihr Amt, das sie mir tun an der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Daß hinfort die Kinder Israel nicht zur Hütte des Stifts sich tun, Sünde auf sich zu laden, und sterben; ");
INSERT INTO deu1912_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","sondern die Leviten sollen des Amts pflegen an der Hütte des Stifts, und sie sollen jener Missetat tragen zu ewigem Recht bei euren Nachkommen. Und sie sollen unter den Kindern Israel kein Erbgut besitzen; ");
INSERT INTO deu1912_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Denn den Zehnten der Kinder Israel, den sie dem HERRN heben, habe ich den Leviten zum Erbgut gegeben. Darum habe ich zu ihnen gesagt, daß sie unter den Kindern Israel kein Erbgut besitzen sollen. ");
INSERT INTO deu1912_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Sage den Leviten und sprich zu ihnen: Wenn ihr den Zehnten nehmt von den Kindern Israel, den ich euch von ihnen gegeben habe zu eurem Erbgut, so sollt ihr davon ein Hebeopfer dem HERRN tun, je den Zehnten von dem Zehnten; ");
INSERT INTO deu1912_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","und sollt solch euer Hebeopfer achten, als gäbet ihr Korn aus der Scheune und Fülle aus der Kelter. ");
INSERT INTO deu1912_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Also sollt auch ihr das Hebeopfer dem HERRN geben von allen euren Zehnten, die ihr nehmt von den Kindern Israel, daß ihr solches Hebopfer des HERRN dem Priester Aaron gebet. ");
INSERT INTO deu1912_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Von allem, was euch gegeben wird, sollt ihr dem HERRN allerlei Hebopfer geben, von allem Besten das, was davon geheiligt wird. ");
INSERT INTO deu1912_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Und sprich zu ihnen: Wenn ihr also das Beste davon hebt, so soll's den Leviten gerechnet werden wie ein Einkommen der Scheune und wie ein Einkommen der Kelter. ");
INSERT INTO deu1912_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ihr möget's essen an allen Stätten, ihr und eure Kinder; denn es ist euer Lohn für euer Amt in der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","So werdet ihr nicht Sünde auf euch laden an demselben, wenn ihr das Beste davon hebt, und nicht entweihen das Geheiligte der Kinder Israel und nicht sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Und der HERR redete mit Mose und Aaron und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Diese Weise soll ein Gesetz sein, das der HERR geboten hat und gesagt: Sage den Kindern Israel, daß sie zu dir führen ein rötliche Kuh ohne Gebrechen, an der kein Fehl sei und auf die noch nie ein Joch gekommen ist. ");
INSERT INTO deu1912_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Und gebt sie dem Priester Eleasar; der soll sie hinaus vor das Lager führen und daselbst vor ihm schlachten lassen. ");
INSERT INTO deu1912_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Und Eleasar, der Priester, soll von ihrem Blut mit seinem Finger nehmen und stracks gegen die Hütte des Stifts siebenmal sprengen ");
INSERT INTO deu1912_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","und die Kuh vor ihm verbrennen lassen, beides, ihr Fell und ihr Fleisch, dazu ihr Blut samt ihrem Mist. ");
INSERT INTO deu1912_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Und der Priester soll Zedernholz und Isop und scharlachrote Wolle nehmen und auf die brennende Kuh werfen ");
INSERT INTO deu1912_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","und soll seine Kleider waschen und seinen Leib mit Wasser baden und darnach ins Lager gehen und unrein sein bis an den Abend. ");
INSERT INTO deu1912_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Und der sie verbrannt hat, soll auch seine Kleider mit Wasser waschen und seinen Leib in Wasser baden und unrein sein bis an den Abend. ");
INSERT INTO deu1912_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Und ein reiner Mann soll die Asche von der Kuh aufraffen und sie schütten draußen vor dem Lager an eine reine Stätte, daß sie daselbst verwahrt werde für die Gemeinde der Kinder Israel zum Sprengwasser; denn es ist ein Sündopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Und derselbe, der die Asche der Kuh aufgerafft hat, soll seine Kleider waschen und unrein sein bis an den Abend. Dies soll ein ewiges Recht sein den Kindern Israel und den Fremdlingen, die unter euch wohnen. ");
INSERT INTO deu1912_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Wer nun irgend einen toten Menschen anrührt, der wird sieben Tage unrein sein. ");
INSERT INTO deu1912_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Der soll sich hiermit entsündigen am dritten Tage und am siebenten Tage, so wird er rein; und wo er sich nicht am dritten Tage und am siebenten Tage entsündigt, so wird er nicht rein werden. ");
INSERT INTO deu1912_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Wenn aber jemand irgend einen toten Menschen anrührt und sich nicht entsündigen wollte, der verunreinigt die Wohnung des HERRN, und solche Seele soll ausgerottet werden aus Israel. Darum daß das Sprengwasser nicht über ihn gesprengt ist, so ist er unrein; seine Unreinigkeit bleibt an ihm. ");
INSERT INTO deu1912_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Das ist das Gesetz: Wenn ein Mensch in der Hütte stirbt, soll jeder, der in die Hütte geht und wer in der Hütte ist, unrein sein sieben Tage. ");
INSERT INTO deu1912_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Und alles offene Gerät, das keinen Deckel noch Band hat, ist unrein. ");
INSERT INTO deu1912_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Auch wer anrührt auf dem Felde einen, der erschlagen ist mit dem Schwert, oder einen Toten oder eines Menschen Gebein oder ein Grab, der ist unrein sieben Tage. ");
INSERT INTO deu1912_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","So sollen sie nun für den Unreinen nehmen Asche von diesem verbrannten Sündopfer und fließendes Wasser darauf tun in ein Gefäß. ");
INSERT INTO deu1912_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Und ein reiner Mann soll Isop nehmen und ins Wasser tauchen und die Hütte besprengen und alle Geräte und alle Seelen, die darin sind; also auch den, der eines Toten Gebein oder einen Erschlagenen oder Toten oder ein Grab angerührt hat. ");
INSERT INTO deu1912_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Es soll aber der Reine den Unreinen am dritten Tage und am siebenten Tage entsündigen; und er soll seine Kleider waschen und sich mit Wasser baden, so wird er am Abend rein. ");
INSERT INTO deu1912_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Welcher aber unrein sein wird und sich nicht entsündigen will, des Seele soll ausgerottet werden aus der Gemeinde; denn er hat das Heiligtum des HERRN verunreinigt und ist mit Sprengwasser nicht besprengt; darum ist er unrein. ");
INSERT INTO deu1912_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Und dies soll ihnen ein ewiges Recht sein. Und der auch, der mit dem Sprengwasser gesprengt hat, soll seine Kleider waschen; und wer das Sprengwasser anrührt, der soll unrein sein bis an den Abend. ");
INSERT INTO deu1912_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Und alles, was der Unreine anrührt, wird unrein werden; und welche Seele ihn anrühren wird, soll unrein sein bis an den Abend. ");
INSERT INTO deu1912_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Und die Kinder Israel kamen mit der ganzen Gemeinde in die Wüste Zin im ersten Monat, und das Volk lag zu Kades. Und Mirjam starb daselbst und ward daselbst begraben. ");
INSERT INTO deu1912_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Und die Gemeinde hatte kein Wasser, und sie versammelten sich wider Mose und Aaron. ");
INSERT INTO deu1912_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Und das Volk haderte mit Mose und sprach: Ach, daß wir umgekommen wären, da unsere Brüder umkamen vor dem HERRN! ");
INSERT INTO deu1912_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Warum habt ihr die Gemeinde des HERRN in diese Wüste gebracht, daß wir hier sterben mit unserm Vieh? ");
INSERT INTO deu1912_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Und warum habt ihr uns aus Ägypten geführt an diesen bösen Ort, da man nicht säen kann, da weder Feigen noch Weinstöcke noch Granatäpfel sind und dazu kein Wasser zu trinken? ");
INSERT INTO deu1912_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mose und Aaron gingen vor der Gemeinde zur Tür der Hütte des Stifts und fielen auf ihr Angesicht, und die Herrlichkeit des HERRN erschien ihnen. ");
INSERT INTO deu1912_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Nimm den Stab und versammle die Gemeinde, du und dein Bruder Aaron, und redet mit dem Fels vor ihren Augen; der wird sein Wasser geben. Also sollst du ihnen Wasser aus dem Fels bringen und die Gemeinde tränken und ihr Vieh. ");
INSERT INTO deu1912_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Da nahm Mose den Stab vor dem HERRN, wie er ihm geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Und Mose und Aaron versammelten die Gemeinde vor den Fels, und er sprach zu ihnen: Höret, ihr Ungehorsamen, werden wir euch Wasser bringen aus jenem Fels? ");
INSERT INTO deu1912_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Und Mose hob seine Hand auf und schlug den Fels mit dem Stab zweimal. Da ging viel Wasser heraus, daß die Gemeinde trank und ihr Vieh. ");
INSERT INTO deu1912_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Der HERR aber sprach zu Mose und Aaron: Darum daß ihr nicht an mich geglaubt habt, mich zu heiligen vor den Kindern Israel, sollt ihr diese Gemeinde nicht in das Land bringen, das ich ihnen geben werde. ");
INSERT INTO deu1912_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Das ist das Haderwasser, darüber die Kinder Israel mit dem HERRN haderten und er geheiligt ward an ihnen. ");
INSERT INTO deu1912_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Und Mose sandte Botschaft aus Kades zu dem König der Edomiter: Also läßt dir dein Bruder Israel sagen: Du weißt alle die Mühsal, die uns betroffen hat, ");
INSERT INTO deu1912_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","daß unsre Väter nach Ägypten hinabgezogen sind und wir lange Zeit in Ägypten gewohnt haben, und die Ägypter behandelten uns und unsre Väter übel. ");
INSERT INTO deu1912_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Und wir schrieen zu dem HERRN; der hat unsre Stimme erhört und einen Engel gesandt und uns aus Ägypten geführt. Und siehe, wir sind zu Kades, in der Stadt an deinen Grenzen. ");
INSERT INTO deu1912_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Laß uns durch dein Land ziehen. Wir wollen nicht durch Äcker noch Weinberge gehen, auch nicht Wasser aus den Brunnen trinken; die Landstraße wollen wir ziehen, weder zur Rechten noch zur Linken weichen, bis wir durch deine Grenze kommen. ");
INSERT INTO deu1912_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom aber sprach zu ihnen: Du sollst nicht durch mich ziehen, oder ich will dir mit dem Schwert entgegenziehen. ");
INSERT INTO deu1912_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Die Kinder Israel sprachen zu ihm: Wir wollen auf der gebahnten Straße ziehen, und so wir von deinem Wasser trinken, wir und unser Vieh, so wollen wir's bezahlen; wir wollen nichts denn nur zu Fuße hindurchziehen. ");
INSERT INTO deu1912_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Er aber sprach: Du sollst nicht herdurchziehen. Und die Edomiter zogen aus, ihnen entgegen, mit mächtigem Volk und starker Hand. ");
INSERT INTO deu1912_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Also weigerten sich die Edomiter, Israel zu vergönnen, durch ihr Gebiet zu ziehen. Und Israel wich von ihnen. ");
INSERT INTO deu1912_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Und die Kinder Israel brachen auf von Kades und kamen mit der ganzen Gemeinde an den Berg Hor. ");
INSERT INTO deu1912_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Und der HERR redete mit Mose und Aaron am Berge Hor, an den Grenzen des Landes der Edomiter, und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Laß sich Aaron sammeln zu seinem Volk; denn er soll nicht in das Land kommen, das ich den Kindern Israel gegeben habe, darum daß ihr meinem Munde ungehorsam gewesen seid bei dem Haderwasser. ");
INSERT INTO deu1912_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Nimm aber Aaron und seinen Sohn Eleasar und führe sie auf den Berg Hor ");
INSERT INTO deu1912_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","und zieh Aaron seine Kleider aus und ziehe sie Eleasar an, seinem Sohne. Und Aaron soll sich daselbst sammeln und sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Da tat Mose, wie ihm der HERR geboten hatte, und sie stiegen auf den Berg Hor vor der ganzen Gemeinde. ");
INSERT INTO deu1912_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Und Mose zog Aaron seine Kleider aus und zog sie Eleasar an, seinem Sohne. ");
INSERT INTO deu1912_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Und Aaron starb daselbst oben auf dem Berge. Mose aber und Eleasar stiegen herab vom Berge. ");
INSERT INTO deu1912_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Und da die Kanaaniter, der König von Arad, der gegen Mittag wohnte, hörte, daß Israel hereinkommt durch den Weg der Kundschafter, stritt er wider Israel und führte etliche gefangen. ");
INSERT INTO deu1912_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Da gelobte Israel dem HERRN ein Gelübde und sprach: Wenn du dies Volk unter Meine Hand gibst, so will ich ihre Städte verbannen. ");
INSERT INTO deu1912_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Und der HERR erhörte die Stimme Israels und gab die Kanaaniter, und sie verbannten sie samt ihren Städten und hießen die Stätte Horma. ");
INSERT INTO deu1912_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Da zogen sie von dem Berge Hor auf dem Wege gegen das Schilfmeer, daß sie um der Edomiter Land hinzögen. Und das Volk ward verdrossen auf dem Wege ");
INSERT INTO deu1912_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","und redete wider Gott und wider Mose: Warum hast du uns aus Ägypten geführt, daß wir sterben in der Wüste? Denn es ist kein Brot noch Wasser hier, und unsre Seele ekelt vor dieser mageren Speise. ");
INSERT INTO deu1912_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Da sandte der HERR feurige Schlangen unter das Volk; die bissen das Volk, daß viel Volks in Israel starb. ");
INSERT INTO deu1912_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Da kamen sie zu Mose und sprachen: Wir haben gesündigt, daß wir wider dich geredet haben; bitte den HERRN, daß er die Schlangen von uns nehme. Mose bat für das Volk. ");
INSERT INTO deu1912_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Da sprach der HERR zu Mose: Mache dir eine eherne Schlange und richte sie zum Zeichen auf; wer gebissen ist und sieht sie an, der soll leben. ");
INSERT INTO deu1912_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Da machte Mose eine eherne Schlange und richtete sie auf zum Zeichen; und wenn jemanden eine Schlange biß, so sah er die eherne Schlange an und blieb leben. ");
INSERT INTO deu1912_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Und die Kinder Israel zogen aus und lagerten sich in Oboth. ");
INSERT INTO deu1912_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Und von Oboth zogen sie aus und lagerten sich in Ije-Abarim, in der Wüste Moab, gegenüber gegen der Sonne Aufgang. ");
INSERT INTO deu1912_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Und von da zogen sie und lagerten sich am Bach Sered. ");
INSERT INTO deu1912_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Von da zogen sie und lagerten sich diesseits am Arnon, der in der Wüste ist und herauskommt von der Grenze der Amoriter; denn der Arnon ist die Grenze Moabs zwischen Moab und den Amoritern. ");
INSERT INTO deu1912_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Daher heißt es in dem Buch von den Kriegen des HERRN: “Das Vaheb in Supha und die Bäche Arnon ");
INSERT INTO deu1912_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","und die Quelle der Bäche, welche reicht hinan bis zur Stadt Ar und lenkt sich und ist die Grenze Moabs.” ");
INSERT INTO deu1912_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Und von da zogen sie zum Brunnen. Das ist der Brunnen, davon der HERR zu Mose sagte: Sammle das Volk, ich will ihnen Wasser geben. ");
INSERT INTO deu1912_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Da sang Israel das Lied: “Brunnen, steige auf! Singet von ihm! ");
INSERT INTO deu1912_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Das ist der Brunnen, den die Fürsten gegraben haben; die Edlen im Volk haben ihn gegraben mit dem Zepter, mit ihren Stäben.” Und von dieser Wüste zogen sie gen Matthana; ");
INSERT INTO deu1912_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","und von Matthana gen Nahaliel; und von Nahaliel gen Bamoth; ");
INSERT INTO deu1912_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","und von Bamoth in das Tal, das im Felde Moabs liegt, zu dem hohen Berge Pisgas, der gegen die Wüste sieht. ");
INSERT INTO deu1912_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Und Israel sandte Boten zu Sihon, dem König der Amoriter, und ließ ihm sagen: ");
INSERT INTO deu1912_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Laß mich durch dein Land ziehen. Wir wollen nicht weichen in die Äcker noch in die Weingärten, wollen auch Brunnenwasser nicht trinken; die Landstraße wollen wir ziehen, bis wir durch deine Grenze kommen. ");
INSERT INTO deu1912_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Aber Sihon gestattete den Kindern Israel nicht den Zug durch sein Gebiet, sondern sammelte all sein Volk und zog aus, Israel entgegen in die Wüste; und als er gen Jahza kam, stritt er wider Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israel aber schlug ihn mit der Schärfe des Schwerts und nahm sein Land ein vom Arnon an bis an den Jabbok und bis an die Kinder Ammon; denn die Grenzen der Kinder Ammon waren fest. ");
INSERT INTO deu1912_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Also nahm Israel alle diese Städte und wohnte in allen Städten der Amoriter, zu Hesbon und in allen seinen Ortschaften. ");
INSERT INTO deu1912_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Denn Hesbon war die Stadt Sihons, des Königs der Amoriter, und er hatte zuvor mit dem König der Moabiter gestritten und ihm all sein Land abgewonnen bis zum Arnon. ");
INSERT INTO deu1912_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Daher sagt man im Lied: “Kommt gen Hesbon, daß man die Stadt Sihons baue und aufrichte; ");
INSERT INTO deu1912_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","denn Feuer ist aus Hesbon gefahren, eine Flamme von der Stadt Sihons, die hat gefressen Ar der Moabiter und die Bürger der Höhen am Arnon. ");
INSERT INTO deu1912_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Weh dir, Moab! Du Volk des Kamos bist verloren; man hat seine Söhne in die Flucht geschlagen und seine Töchter gefangen geführt Sihon, dem König der Amoriter. ");
INSERT INTO deu1912_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ihre Herrlichkeit ist zunichte worden von Hesbon bis gen Dibon; sie ist verstört bis gen Nophah, die da langt bis gen Medeba.” ");
INSERT INTO deu1912_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Also wohnte Israel im Lande der Amoriter. ");
INSERT INTO deu1912_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Und Mose sandte aus Kundschafter gen Jaser, und sie gewannen seine Ortschaften und nahmen die Amoriter ein, die darin waren, ");
INSERT INTO deu1912_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","und wandten sich und zogen hinauf den Weg nach Basan. Da zog aus, ihnen entgegen, Og, der König von Basan, mit allem seinem Volk, zu streiten in Edrei. ");
INSERT INTO deu1912_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Und der HERR sprach zu Mose: Fürchte dich nicht vor ihm; denn ich habe ihn in deine Hand gegeben mit Land und Leuten, und du sollst mit ihm tun, wie du mit Sihon, dem König der Amoriter, getan hast, der zu Hesbon wohnte. ");
INSERT INTO deu1912_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Und sie schlugen ihn und seine Söhne und all sein Volk, bis daß keiner übrigblieb, und nahmen das Land ein. ");
INSERT INTO deu1912_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Darnach zogen die Kinder Israel und lagerten sich in das Gefilde Moab jenseit des Jordans, gegenüber Jericho. ");
INSERT INTO deu1912_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Und Balak, der Sohn Zippors, sah alles, was Israel getan hatte den Amoritern; ");
INSERT INTO deu1912_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","und die Moabiter fürchteten sich sehr vor dem Volk, das so groß war, und den Moabitern graute vor den Kindern Israel; ");
INSERT INTO deu1912_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","und sie sprachen zu den Ältesten der Midianiter: Nun wird dieser Haufe auffressen, was um uns ist, wie ein Ochse Kraut auf dem Felde auffrißt. Balak aber, der Sohn Zippors, war zu der Zeit König der Moabiter. ");
INSERT INTO deu1912_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Und er sandte Boten aus zu Bileam, dem Sohn Beors, gen Pethor, der wohnte an dem Strom im Lande der Kinder seines Volks, daß sie ihn forderten, und ließ ihm sagen: Siehe, es ist ein Volk aus Ägypten gezogen, das bedeckt das Angesicht der Erde und liegt mir gegenüber. ");
INSERT INTO deu1912_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","So komm nun und verfluche mir das Volk (denn es ist mir zu mächtig), ob ich's schlagen möchte und aus dem Lande vertreiben; denn ich weiß, daß, welchen du segnest, der ist gesegnet, und welchen du verfluchst, der ist verflucht. ");
INSERT INTO deu1912_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Und die Ältesten der Moabiter gingen hin mit den Ältesten der Midianiter und hatten den Lohn des Wahrsagers in ihren Händen und kamen zu Bileam und sagten ihm die Worte Balaks. ");
INSERT INTO deu1912_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Und er sprach zu ihnen: Bleibt hier über Nacht, so will ich euch wieder sagen, wie mir der HERR sagen wird. Also blieben die Fürsten der Moabiter bei Bileam. ");
INSERT INTO deu1912_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Und Gott kam zu Bileam und sprach: Wer sind die Leute, die bei dir sind? ");
INSERT INTO deu1912_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bileam sprach zu Gott: Balak, der Sohn Zippors, der Moabiter König, hat zu mir gesandt: ");
INSERT INTO deu1912_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Siehe, ein Volk ist aus Ägypten gezogen und bedeckt das Angesicht der Erde; so komm nun und fluche ihm, ob ich mit ihm streiten möge und sie vertreiben. ");
INSERT INTO deu1912_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Gott aber sprach zu Bileam: Gehe nicht mit ihnen, verfluche das Volk auch nicht; denn es ist gesegnet. ");
INSERT INTO deu1912_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Da stand Bileam des Morgens auf und sprach zu den Fürsten Balaks: Gehet hin in euer Land; denn der HERR will's nicht gestatten, daß ich mit euch ziehe. ");
INSERT INTO deu1912_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Und die Fürsten der Moabiter machten sich auf, kamen zu Balak und sprachen: Bileam weigert sich, mit uns zu ziehen. ");
INSERT INTO deu1912_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Da sandte Balak noch größere und herrlichere Fürsten, denn jene waren. ");
INSERT INTO deu1912_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Da die zu Bileam kamen, sprachen sie zu ihm: Also läßt dir sagen Balak, der Sohn Zippors: Wehre dich doch nicht, zu mir zu ziehen; ");
INSERT INTO deu1912_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","denn ich will dich hoch ehren, und was du mir sagst, das will ich tun; komm doch und fluche mir diesem Volk. ");
INSERT INTO deu1912_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bileam antwortete und sprach zu den Dienern Balaks: Wenn mir Balak sein Haus voll Silber und Gold gäbe, so könnte ich doch nicht übertreten das Wort des HERRN, meines Gottes, Kleines oder Großes zu tun. ");
INSERT INTO deu1912_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","So bleibt doch nur hier auch ihr diese Nacht, daß ich erfahre, was der HERR weiter mit mir reden werde. ");
INSERT INTO deu1912_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Da kam Gott des Nachts zu Bileam und sprach zu ihm: Sind die Männer gekommen, dich zu rufen, so mache dich auf und zieh mit ihnen; doch was ich dir sagen werde, das sollst du tun. ");
INSERT INTO deu1912_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Da stand Bileam des Morgens auf und sattelte seine Eselin und zog mit den Fürsten der Moabiter. ");
INSERT INTO deu1912_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Aber der Zorn Gottes ergrimmte, daß er hinzog. Und der Engel des HERRN trat ihm in den Weg, daß er ihm widerstünde. Er aber ritt auf seiner Eselin, und zwei Knechte waren mit ihm. ");
INSERT INTO deu1912_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Und die Eselin sah den Engel des HERRN im Wege stehen und ein bloßes Schwert in seiner Hand. Und die Eselin wich aus dem Wege und ging auf dem Felde; Bileam aber schlug sie, daß sie in den Weg sollte gehen. ");
INSERT INTO deu1912_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Da trat der Engel des HERRN in den Pfad bei den Weinbergen, da auf beiden Seiten Wände waren. ");
INSERT INTO deu1912_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Und da die Eselin den Engel des HERRN sah, drängte sie sich an die Wand und klemmte Bileam den Fuß an der Wand; und er schlug sie noch mehr. ");
INSERT INTO deu1912_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Da ging der Engel des HERRN weiter und trat an einen engen Ort, da kein Weg war zu weichen, weder zur Rechten noch zur Linken. ");
INSERT INTO deu1912_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Und da die Eselin den Engel des HERRN sah, fiel sie auf ihre Knie unter Bileam. Da ergrimmte der Zorn Bileams, und er schlug die Eselin mit dem Stabe. ");
INSERT INTO deu1912_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Da tat der HERR der Eselin den Mund auf, und sie sprach zu Bileam: Was habe ich dir getan, daß du mich geschlagen hast nun dreimal? ");
INSERT INTO deu1912_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileam sprach zur Eselin: Daß du mich höhnest! ach, daß ich jetzt ein Schwert in der Hand hätte, ich wollte dich erwürgen! ");
INSERT INTO deu1912_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Die Eselin sprach zu Bileam: Bin ich nicht deine Eselin, darauf du geritten bist zu deiner Zeit bis auf diesen Tag? Habe ich auch je gepflegt, dir also zu tun? Er sprach: Nein. ");
INSERT INTO deu1912_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Da öffnete der HERR dem Bileam die Augen, daß er den Engel des HERRN sah im Wege stehen und ein bloßes Schwert in seiner Hand, und er neigte und bückte sich mit seinem Angesicht. ");
INSERT INTO deu1912_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Und der Engel des HERRN sprach zu ihm: Warum hast du deine Eselin geschlagen nun dreimal? Siehe, ich bin ausgegangen, daß ich dir widerstehe; denn dein Weg ist vor mir verkehrt. ");
INSERT INTO deu1912_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Und die Eselin hat mich gesehen und ist dreimal ausgewichen; sonst, wo sie nicht vor mir gewichen wäre, so wollte ich dich auch jetzt erwürgt und die Eselin lebendig erhalten haben. ");
INSERT INTO deu1912_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Da sprach Bileam zu dem Engel des HERRN: Ich habe gesündigt; denn ich habe es nicht gewußt, daß du mir entgegenstandest im Wege. Und nun, so dir's nicht gefällt, will ich wieder umkehren. ");
INSERT INTO deu1912_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Der Engel des HERRN sprach zu ihm: Zieh hin mit den Männern; aber nichts anderes, denn was ich dir sagen werde, sollst du reden. Also zog Bileam mit den Fürsten Balaks. ");
INSERT INTO deu1912_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Da Balak hörte, daß Bileam kam, zog er aus ihm entgegen in die Stadt der Moabiter, die da liegt an der Grenze des Arnon, welcher ist an der äußersten Grenze, ");
INSERT INTO deu1912_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","und sprach zu ihm: Habe ich nicht zu dir gesandt und dich fordern lassen? Warum bist du denn nicht zu mir gekommen? Meinst du ich könnte dich nicht ehren? ");
INSERT INTO deu1912_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bileam antwortete ihm: Siehe, ich bin gekommen zu dir; aber wie kann ich etwas anderes reden, als was mir Gott in den Mund gibt? Das muß ich reden. ");
INSERT INTO deu1912_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Also zog Bileam mit Balak, und sie kamen in die Gassenstadt. ");
INSERT INTO deu1912_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Und Balak opferte Rinder und Schafe und sandte davon an Bileam und an die Fürsten, die bei ihm waren. ");
INSERT INTO deu1912_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Und des Morgens nahm Balak den Bileam und führte ihn hin auf die Höhe Baals, daß er von da sehen konnte das Ende des Volks. ");
INSERT INTO deu1912_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Und Bileam sprach zu Balak: Baue mir hier sieben Altäre und schaffe mir her sieben Farren und sieben Widder. ");
INSERT INTO deu1912_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak tat, wie ihm Bileam sagte; und beide, Balak und Bileam, opferten je auf einem Altar einen Farren und einen Widder. ");
INSERT INTO deu1912_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Und Bileam sprach zu Balak: Tritt zu deinem Brandopfer; ich will hingehen, ob vielleicht mir der HERR begegne, daß ich dir ansage, was er mir zeigt. Und ging hin eilend. ");
INSERT INTO deu1912_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Und Gott begegnete Bileam; er aber sprach zu ihm: Sieben Altäre habe ich zugerichtet und je auf einem Altar einen Farren und einen Widder geopfert. ");
INSERT INTO deu1912_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Der HERR aber gab das Wort dem Bileam in den Mund und sprach: Gehe wieder zu Balak und rede also. ");
INSERT INTO deu1912_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Und da er wieder zu ihm kam, siehe, da stand er bei dem Brandopfer samt allen Fürsten der Moabiter. ");
INSERT INTO deu1912_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Da hob er an seinen Spruch und sprach: Aus Syrien hat mich Balak, der Moabiter König, holen lassen von dem Gebirge gegen Aufgang: Komm, verfluche mir Jakob! komm schilt Israel! ");
INSERT INTO deu1912_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Wie soll ich fluchen, dem Gott nicht flucht? Wie soll ich schelten, den der HERR nicht schilt? ");
INSERT INTO deu1912_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Denn von der Höhe der Felsen sehe ich ihn wohl, und von den Hügeln schaue ich ihn. Siehe, das Volk wird besonders wohnen und nicht unter die Heiden gerechnet werden. ");
INSERT INTO deu1912_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wer kann zählen den Staub Jakobs und die Zahl des vierten Teils Israels? Meine Seele müsse sterben des Todes der Gerechten, und mein Ende werde wie dieser Ende! ");
INSERT INTO deu1912_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Da sprach Balak zu Bileam: Was tust du an mir? Ich habe dich holen lassen, zu fluchen meinen Feinden; und siehe, du segnest. ");
INSERT INTO deu1912_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Er antwortete und sprach: Muß ich das nicht halten und reden, was mir der HERR in den Mund gibt? ");
INSERT INTO deu1912_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak sprach zu ihm: Komm doch mit mir an einen andern Ort, von wo du nur sein Ende sehest und es nicht ganz sehest, und fluche mir ihm daselbst. ");
INSERT INTO deu1912_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Und er führte ihn auf einen freien Platz auf der Höhe Pisga und baute sieben Altäre und opferte je auf einem Altar einen Farren und einen Widder. ");
INSERT INTO deu1912_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Und (Bileam) sprach zu Balak: Tritt her zu deinem Brandopfer; ich will dort warten. ");
INSERT INTO deu1912_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Und der HERR begegnete Bileam und gab ihm das Wort in seinen Mund und sprach: Gehe wieder zu Balak und rede also. ");
INSERT INTO deu1912_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Und da er wieder zu ihm kam, siehe, da stand er bei seinem Brandopfer samt den Fürsten der Moabiter. Und Balak sprach zu ihm: Was hat der HERR gesagt? ");
INSERT INTO deu1912_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Und er hob an seinen Spruch und sprach: Stehe auf, Balak, und höre! nimm zu Ohren was ich sage, du Sohn Zippors! ");
INSERT INTO deu1912_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Gott ist nicht ein Mensch, daß er lüge, noch ein Menschenkind, daß ihn etwas gereue. Sollte er etwas sagen und nicht tun? Sollte er etwas reden und nicht halten? ");
INSERT INTO deu1912_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Siehe, zu segnen bin ich hergebracht; er segnet, und ich kann's nicht wenden. ");
INSERT INTO deu1912_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Man sieht keine Mühe in Jakob und keine Arbeit in Israel. Der HERR, sein Gott, ist bei ihm und das Drommeten des Königs unter ihm. ");
INSERT INTO deu1912_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Gott hat sie aus Ägypten geführt; seine Freudigkeit ist wie eines Einhorns. ");
INSERT INTO deu1912_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Denn es ist kein Zauberer in Jakob und kein Wahrsager in Israel. Zu seiner Zeit wird Jakob gesagt und Israel, was Gott tut. ");
INSERT INTO deu1912_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Siehe, das Volk wird aufstehen, wie ein junger Löwe und wird sich erheben wie ein Löwe; es wird sich nicht legen, bis es den Raub fresse und das Blut der Erschlagenen saufe. ");
INSERT INTO deu1912_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Da sprach Balak zu Bileam: Du sollst ihm weder fluchen noch es segnen. ");
INSERT INTO deu1912_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bileam antwortete und sprach zu Balak: Habe ich dir nicht gesagt, alles, was der HERR reden würde, das würde ich tun? ");
INSERT INTO deu1912_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak sprach zu ihm: Komm doch, ich will dich an einen Ort führen, ob's vielleicht Gott gefalle, daß du daselbst mir sie verfluchst. ");
INSERT INTO deu1912_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Und er führte ihn auf die Höhe des Berges Peor, welcher gegen die Wüste sieht. ");
INSERT INTO deu1912_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Und Bileam sprach zu Balak: Baue mir hier sieben Altäre und schaffe mir sieben Farren und sieben Widder. ");
INSERT INTO deu1912_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak tat, wie ihm Bileam sagte, und opferte je auf einem Altar einen Farren und einen Widder. ");
INSERT INTO deu1912_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Da nun Bileam sah, daß es dem HERRN gefiel, daß er Israel segnete, ging er nicht aus, wie vormals, nach Zauberei, sondern richtete sein Angesicht stracks zu der Wüste, ");
INSERT INTO deu1912_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","hob seine Augen auf und sah Israel, wie sie lagen nach ihren Stämmen. Und der Geist Gottes kam auf ihn, ");
INSERT INTO deu1912_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","und er hob an seinen Spruch und sprach: Es sagt Bileam, der Sohn Beors, es sagt der Mann, dem die Augen geöffnet sind, ");
INSERT INTO deu1912_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","es sagt der Hörer göttlicher Rede, der des Allmächtigen Offenbarung sieht, dem die Augen geöffnet werden, wenn er niederkniet: ");
INSERT INTO deu1912_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Wie fein sind deine Hütten, Jakob, und deine Wohnungen, Israel! ");
INSERT INTO deu1912_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Wie die Täler, die sich ausbreiten, wie die Gärten an den Wassern, wie die Aloebäume, die der HERR pflanzt, wie die Zedern an den Wassern. ");
INSERT INTO deu1912_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Es wird Wasser aus seinem Eimer fließen, und sein Same wird ein großes Wasser werden; sein König wird höher werden denn Agag, und sein Reich wird sich erheben. ");
INSERT INTO deu1912_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gott hat ihn aus Ägypten geführt; seine Freudigkeit ist wie eines Einhorns. Er wird die Heiden, seine Verfolger, fressen und ihre Gebeine zermalmen und mit seinen Pfeilen zerschmettern. ");
INSERT INTO deu1912_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Er hat sich niedergelegt wie ein Löwe und wie ein junger Löwe; wer will sich gegen ihn auflehnen? Gesegnet sei, der dich segnet, und verflucht, der dir flucht! ");
INSERT INTO deu1912_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Da ergrimmte Balak im Zorn wider Bileam und schlug die Hände zusammen und sprach zu ihm: Ich habe dich gefordert, daß du meinen Feinden fluchen solltest; und siehe, du hast sie nun dreimal gesegnet. ");
INSERT INTO deu1912_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Und nun hebe dich an deinen Ort! Ich gedachte, ich wollte dich ehren; aber der HERR hat dir die Ehre verwehrt. ");
INSERT INTO deu1912_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bileam antwortete ihm: Habe ich nicht auch zu deinen Boten gesagt, die du zu mir sandtest, und gesprochen: ");
INSERT INTO deu1912_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Wenn mir Balak sein Haus voll Silber und Gold gäbe, so könnte ich doch an des HERRN Wort nicht vorüber, Böses oder Gutes zu tun nach meinem Herzen; sondern was der HERR reden würde, das würde ich auch reden? ");
INSERT INTO deu1912_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Und nun siehe, ich ziehe zu meinem Volk. So komm, ich will dir verkündigen, was dies Volk deinem Volk tun wird zur letzten Zeit. ");
INSERT INTO deu1912_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Und er hob an seinen Spruch und sprach: es sagt Bileam, der Sohn Beors, es sagt der Mann, dem die Augen geöffnet sind, ");
INSERT INTO deu1912_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","es sagt der Hörer göttlicher Rede und der die Erkenntnis hat des Höchsten, der die Offenbarung des Allmächtigen sieht und dem die Augen geöffnet werden, wenn er niederkniet. ");
INSERT INTO deu1912_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ich sehe ihn, aber nicht jetzt; ich schaue ihn aber nicht von nahe. Es wird ein Stern aus Jakob aufgehen und ein Zepter aus Israel aufkommen und wird zerschmettern die Fürsten der Moabiter und verstören alle Kinder des Getümmels. ");
INSERT INTO deu1912_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom wird er einnehmen, und Seir wird seinen Feinden unterworfen sein; Israel aber wird den Sieg haben. ");
INSERT INTO deu1912_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Aus Jakob wird der Herrscher kommen und umbringen, was übrig ist von den Städten. ");
INSERT INTO deu1912_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Und da er sah die Amalekiter, hob er an seinen Spruch und sprach: Amalek, die Ersten unter den Heiden; aber zuletzt wirst du gar umkommen. ");
INSERT INTO deu1912_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Und da er die Keniter sah, hob er an seinen Spruch und sprach: Fest ist deine Wohnung, und hast dein Nest in einen Felsen gelegt. ");
INSERT INTO deu1912_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Aber, o Kain, du wirst verbrannt werden, wenn Assur dich gefangen wegführen wird. ");
INSERT INTO deu1912_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Und er hob abermals an seinen Spruch und sprach: Ach, wer wird leben, wenn Gott solches tun wird? ");
INSERT INTO deu1912_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Und Schiffe aus Chittim werden verderben den Assur und Eber; er aber wird auch umkommen. ");
INSERT INTO deu1912_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Und Bileam machte sich auf und zog hin und kam wieder an seinen Ort, und Balak zog seinen Weg. ");
INSERT INTO deu1912_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Und Israel wohnte in Sittim. Und das Volk hob an zu huren mit der Moabiter Töchtern, ");
INSERT INTO deu1912_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","welche luden das Volk zum Opfer ihrer Götter. Und das Volk aß und betete ihre Götter an. ");
INSERT INTO deu1912_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Und Israel hängte sich an den Baal-Peor. Da ergrimmte des HERRN Zorn über Israel, ");
INSERT INTO deu1912_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","und er sprach zu Mose: nimm alle Obersten des Volks und hänge sie dem HERRN auf an der Sonne, auf daß der grimmige Zorn des HERRN von Israel gewandt werde. ");
INSERT INTO deu1912_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Und Mose sprach zu den Richtern Israels: Erwürge ein jeglicher seine Leute, die sich an den Baal-Peor gehängt haben. ");
INSERT INTO deu1912_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Und siehe, ein Mann aus den Kindern Israel kam und brachte unter seine Brüder eine Midianitin vor den Augen Mose's und der ganzen Gemeinde der Kinder Israel, die da weinten vor der Tür der Hütte des Stifts. ");
INSERT INTO deu1912_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Da das sah Pinehas, der Sohn Eleasars, des Sohnes Aarons, des Priesters, stand er auf aus der Gemeinde und nahm einen Spieß in seine Hand ");
INSERT INTO deu1912_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","und ging dem israelitischen Mann nach hinein in die Kammer und durchstach sie beide, den israelitischen Mann und das Weib, durch ihren Bauch. Da hörte die Plage auf von den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Und es wurden getötet in der Plage vierundzwanzigtausend. ");
INSERT INTO deu1912_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinehas, der Sohn Eleasars, des Sohnes Aarons, des Priesters, hat meinen Grimm von den Kindern Israel gewendet durch seinen Eifer um mich, daß ich nicht in meinem Eifer die Kinder Israel vertilgte. ");
INSERT INTO deu1912_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Darum sage: Siehe, ich gebe ihm meinen Bund des Friedens; ");
INSERT INTO deu1912_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","und er soll haben und sein Same nach ihm den Bund eines ewigen Priestertums, darum daß er für seinen Gott geeifert und die Kinder Israel versöhnt hat. ");
INSERT INTO deu1912_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Der israelitische Mann aber, der erschlagen ward mit der Midianitin, hieß Simri, der Sohn Salus, der Fürst eines Vaterhauses der Simeoniter. ");
INSERT INTO deu1912_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Das midianitische Weib, das auch erschlagen ward, hieß Kosbi, eine Tochter Zurs, der ein Fürst war seines Geschlechts unter den Midianitern. ");
INSERT INTO deu1912_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Tut den Midianitern Schaden und schlagt sie; ");
INSERT INTO deu1912_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","denn sie haben euch Schaden getan mit ihrer List, die sie wider euch geübt haben durch den Peor und durch ihre Schwester Kosbi, die Tochter des Fürsten der Midianiter, die erschlagen ist am Tag der Plage um des Peor willen. ");
INSERT INTO deu1912_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Und es geschah, nach der Plage sprach der HERR zu Mose und Eleasar, dem Sohn des Priesters Aaron: ");
INSERT INTO deu1912_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Nehmt die Summe der ganzen Gemeinde der Kinder Israel, von zwanzig Jahren und darüber, nach ihren Vaterhäusern, alle, die ins Heer zu ziehen taugen in Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Und Mose redete mit ihnen samt Eleasar, dem Priester, in dem Gefilde der Moabiter, an dem Jordan gegenüber Jericho, ");
INSERT INTO deu1912_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","die zwanzig Jahre alt waren und darüber, wie der HERR dem Mose geboten hatte und den Kindern Israel, die aus Ägypten gezogen waren. ");
INSERT INTO deu1912_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, der Erstgeborene Israels. Die Kinder Rubens aber waren: Henoch, von dem das Geschlecht der Henochiter kommt; Pallu, von dem das Geschlecht der Palluiter kommt; ");
INSERT INTO deu1912_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron, von dem das Geschlecht der Hezroniter kommt; Charmi, von dem das Geschlecht der Charmiter kommt. ");
INSERT INTO deu1912_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Das sind die Geschlechter von Ruben, und ihre Zahl war dreiundvierzigtausend siebenhundertdreißig. ");
INSERT INTO deu1912_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Aber die Kinder Pallus waren: Eliab. ");
INSERT INTO deu1912_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Und die Kinder Eliabs waren: Nemuel und Dathan und Abiram, die Vornehmen in der Gemeinde, die sich wider Mose und Aaron auflehnten in der Rotte Korahs, die sich wider den HERRN auflehnten ");
INSERT INTO deu1912_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","und die Erde ihren Mund auftat und sie verschlang mit Korah, da die Rotte starb, da das Feuer zweihundertfünfzig Männer fraß und sie ein Zeichen wurden. ");
INSERT INTO deu1912_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Aber die Kinder Korahs starben nicht. ");
INSERT INTO deu1912_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Die Kinder Simeons in ihren Geschlechtern waren: Nemuel, daher kommt das Geschlecht der Nemueliter; Jamin, daher kommt das Geschlecht der Jaminiter; Jachin, daher das Geschlecht der Jachiniter kommt; ");
INSERT INTO deu1912_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Serah, daher das Geschlecht der Serahiter kommt; Saul, daher das Geschlecht der Sauliter kommt. ");
INSERT INTO deu1912_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Das sind die Geschlechter Simeon, zweiundzwanzigtausend und zweihundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Die Kinder Gads in ihren Geschlechtern waren: Ziphon, daher das Geschlecht der Ziphoniter kommt; Haggi, daher das Geschlecht der Haggiter kommt; Suni, daher das Geschlecht der Suniter kommt; ");
INSERT INTO deu1912_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osni, daher das Geschlecht der Osniter kommt; Eri, daher das Geschlecht der Eriter kommt; ");
INSERT INTO deu1912_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, daher das Geschlecht der Aroditer kommt; Ariel, daher das Geschlecht der Arieliter kommt. ");
INSERT INTO deu1912_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Das sind die Geschlechter der Kinder Gads, an ihrer Zahl vierzigtausend und fünfhundert ");
INSERT INTO deu1912_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Die Kinder Juda's: Ger und Onan, welche beide starben im Lande Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Es waren aber die Kinder Juda's in ihren Geschlechtern: Sela, daher das Geschlecht der Selaniter kommt; Perez, daher das Geschlecht der Pereziter kommt; Serah, daher das Geschlecht der Serahiter kommt. ");
INSERT INTO deu1912_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Aber die Kinder des Perez waren: Hezron, daher das Geschlecht der Hezroniter kommt; Hamul, daher das Geschlecht der Hamuliter kommt. ");
INSERT INTO deu1912_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Das sind die Geschlechter Juda's, an ihrer Zahl sechsundsiebzigtausend und fünfhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Die Kinder Isaschars in ihren Geschlechtern waren: Thola, daher das Geschlecht der Tholaiter kommt; Phuva, daher das Geschlecht der Phuvaniter kommt; ");
INSERT INTO deu1912_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jasub, daher das Geschlecht der Jasubiter kommt; Simron, daher das Geschlecht der Simroniter kommt. ");
INSERT INTO deu1912_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Das sind die Geschlechter Isaschars, an der Zahl vierundsechzigtausend und dreihundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Die Kinder Sebulons in ihren Geschlechtern waren: Sered, daher das Geschlecht der Serediter kommt; Elon, daher das Geschlecht der Eloniter kommt; Jahleel, daher das Geschlecht der Jahleeliter kommt. ");
INSERT INTO deu1912_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Das sind die Geschlechter Sebulons, an ihrer Zahl sechzigtausend und fünfhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Die Kinder Josephs in ihren Geschlechtern waren: Manasse und Ephraim. ");
INSERT INTO deu1912_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Die Kinder aber Manasses waren: Machir, daher kommt das Geschlecht der Machiriter; Machir aber zeugte Gilead, daher kommt das Geschlecht der Gileaditer. ");
INSERT INTO deu1912_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Dies sind aber die Kinder Gileads: Hieser, daher kommt das Geschlecht der Hieseriter; Helek, daher kommt das Geschlecht der Helekiter; ");
INSERT INTO deu1912_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, daher kommt das Geschlecht der Asrieliter; Sichem, daher kommt das Geschlecht der Sichemiter; ");
INSERT INTO deu1912_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida, daher kommt das Geschlecht der Semiditer; Hepher, daher kommt das Geschlecht der Hepheriter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophehad aber war Hephers Sohn und hatte keine Söhne sondern Töchter; die hießen Mahela, Noa, Hogla, Milka und Thirza. ");
INSERT INTO deu1912_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Das sind die Geschlechter Manasses, an ihrer Zahl zweiundfünfzigtausend und siebenhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Die Kinder Ephraims in ihren Geschlechtern waren: Suthelah, daher kommt das Geschlecht der Suthelahiter; Becher, daher kommt das Geschlecht der Becheriter; Thahan, daher kommt das Geschlecht der Thahaniter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Die Kinder Suthelahs waren: Eran, daher kommt das Geschlecht der Eraniter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Das sind die Geschlechter der Kinder Ephraims, an ihrer Zahl zweiunddreißigtausend und fünfhundert. Das sind die Kinder Josephs in ihren Geschlechtern. ");
INSERT INTO deu1912_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Die Kinder Benjamins in ihren Geschlechtern waren: Bela, daher kommt das Geschlecht der Belaiter; Asbel, daher kommt das Geschlecht der Asbeliter; Ahiram, daher kommt das Geschlecht der Ahiramiter; ");
INSERT INTO deu1912_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Supham, daher kommt das Geschlecht der Suphamiter; Hupham, daher kommt das Geschlecht der Huphamiter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Die Kinder aber Belas waren: Ard und Naeman, daher kommt das Geschlecht der Arditer und Naemaniter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Das sind die Kinder Benjamins in ihren Geschlechtern, an der Zahl fünfundvierzigtausend und sechshundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Die Kinder Dans in ihren Geschlechtern waren: Suham, daher kommt das Geschlecht der Suhamiter ");
INSERT INTO deu1912_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Das sind die Geschlechter Dans in ihren Geschlechtern, allesamt an der Zahl vierundsechzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Die Kinder Asser in ihren Geschlechtern waren: Jimna, daher kommt das Geschlecht der Jimniter; Jiswi, daher kommt das Geschlecht der Jiswiter; Beria, daher kommt das Geschlecht der Beriiter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Aber die Kinder Berias waren: Heber, daher kommt das Geschlecht der Hebriter; Melchiel, daher kommt das Geschlecht der Melchieliter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Und die Tochter Assers hieß Sarah. ");
INSERT INTO deu1912_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Das sind die Geschlechter der Kinder Assers, an ihrer Zahl dreiundfünfzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Die Kinder Naphthalis in ihren Geschlechtern waren: Jahzeel, daher kommt das Geschlecht der Jahzeeliter; Guni, daher kommt das Geschlecht der Guniter; ");
INSERT INTO deu1912_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer, daher kommt das Geschlecht der Jezeriter; Sillem, daher kommt das Geschlecht der Sillemiter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Das sind die Geschlechter von Naphthali, an ihrer Zahl fünfundvierzigtausend und vierhundert. ");
INSERT INTO deu1912_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Das ist die Summe der Kinder Israel sechsmal hunderttausend eintausend siebenhundertdreißig. ");
INSERT INTO deu1912_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Diesen sollst du das Land austeilen zum Erbe nach der Zahl der Namen. ");
INSERT INTO deu1912_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Vielen sollst du viel zum Erbe geben, und wenigen wenig; jeglichen soll man geben nach ihrer Zahl. ");
INSERT INTO deu1912_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Doch man soll das Land durchs Los teilen; nach dem Namen der Stämme ihrer Väter sollen sie Erbe nehmen. ");
INSERT INTO deu1912_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Denn nach dem Los sollst du ihr Erbe austeilen zwischen den vielen und den wenigen. ");
INSERT INTO deu1912_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Und das ist die Summe der Leviten in ihren Geschlechtern: Gerson, daher kommt das Geschlecht der Gersoniter; Kahath, daher kommt das Geschlecht der Kahathiter; Merari, daher das Geschlecht der Merariter. ");
INSERT INTO deu1912_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Dies sind die Geschlechter Levis: das Geschlecht der Libniter, das Geschlecht der Hebroniter, das Geschlecht der Maheliter, das Geschlecht der Musiter, das Geschlecht der Korahiter. Kahath zeugte Amram. ");
INSERT INTO deu1912_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Und Amrams Weib hieß Jochebed, eine Tochter Levis, die ihm geboren ward in Ägypten; und sie gebar dem Amram Aaron und Mose und ihre Schwester Mirjam. ");
INSERT INTO deu1912_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Dem Aaron aber ward geboren: Nadab, Abihu, Eleasar und Ithamar. ");
INSERT INTO deu1912_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab aber und Abihu starben, da sie fremdes Feuer opferten vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Und ihre Summe war dreiundzwanzigtausend, alles Mannsbilder, von einem Monat und darüber. Denn sie wurden nicht gezählt unter die Kinder Israel; denn man gab ihnen kein Erbe unter den Kindern Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Das ist die Summe der Kinder Israel, die Mose und Eleasar, der Priester, zählten im Gefilde der Moabiter, an dem Jordan gegenüber Jericho; ");
INSERT INTO deu1912_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","unter welchen war keiner aus der Summe, da Mose und Aaron, der Priester, die Kinder Israel zählten in der Wüste Sinai. ");
INSERT INTO deu1912_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Denn der HERR hatte ihnen gesagt, sie sollten des Todes sterben in der Wüste. Und blieb keiner übrig als Kaleb, der Sohn Jephunnes, und Josua, der Sohn Nuns. ");
INSERT INTO deu1912_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Und die Töchter Zelophehads, des Sohnes Hephers, des Sohnes Gileads, des Sohnes Machirs, des Sohnes Manasses, unter den Geschlechtern Manasses, des Sohnes Josephs, mit Namen Mahela, Noa, Hogla, Milka und Thirza, kamen herzu ");
INSERT INTO deu1912_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","und traten vor Mose und vor Eleasar, den Priester, und vor die Fürsten und die ganze Gemeinde vor der Tür der Hütte des Stifts und sprachen: ");
INSERT INTO deu1912_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Unser Vater ist gestorben in der Wüste und war nicht mit unter der Gemeinde, die sich wider den HERRN empörte in der Rotte Korahs, sondern ist an seiner Sünde gestorben, und hatte keine Söhne. ");
INSERT INTO deu1912_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Warum soll denn unsers Vaters Name unter seinem Geschlecht untergehen, weil er keinen Sohn hat? Gebt uns auch ein Gut unter unsers Vaters Brüdern! ");
INSERT INTO deu1912_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mose brachte ihre Sache vor den HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Und der HERR sprach zu ihm: ");
INSERT INTO deu1912_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Die Töchter Zelophehads haben recht geredet; du sollst ihnen ein Erbgut unter ihres Vaters Brüdern geben und sollst ihres Vaters Erbe ihnen zuwenden. ");
INSERT INTO deu1912_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Und sage den Kindern Israel: Wenn jemand stirbt und hat nicht Söhne, so sollt ihr sein Erbe seiner Tochter zuwenden. ");
INSERT INTO deu1912_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Hat er keine Tochter, sollt ihr's seinen Brüdern geben. ");
INSERT INTO deu1912_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Hat er keine Brüder, sollt ihr's seines Vaters Brüdern geben. ");
INSERT INTO deu1912_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Hat er nicht Vatersbrüder, sollt ihr's seinen nächsten Blutsfreunden geben, die ihm angehören in seinem Geschlecht, daß sie es einnehmen. Das soll den Kindern Israel ein Gesetz und Recht sein, wie der HERR dem Mose geboten hat. ");
INSERT INTO deu1912_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Und der HERR sprach zu Mose: Steig auf dies Gebirge Abarim und besiehe das Land, das ich den Kindern Israel gebe werde. ");
INSERT INTO deu1912_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Und wenn du es gesehen hast, sollst du dich sammeln zu deinem Volk, wie dein Bruder Aaron versammelt ist, ");
INSERT INTO deu1912_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","dieweil ihr meinem Wort ungehorsam gewesen seid in der Wüste Zin bei dem Hader der Gemeinde, da ihr mich heiligen solltet durch das Wasser vor ihnen. Das ist das Haderwasser zu Kades in der Wüste Zin. ");
INSERT INTO deu1912_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Und Mose redete mit dem HERRN und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Der HERR, der Gott der Geister alles Fleisches, wolle einen Mann setzen über die Gemeinde, ");
INSERT INTO deu1912_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","der vor ihnen her aus und ein gehe und sie aus und ein führe, daß die Gemeinde des HERRN nicht sei wie die Schafe ohne Hirten. ");
INSERT INTO deu1912_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Und der HERR sprach zu Mose: Nimm Josua zu dir, den Sohn Nuns, einen Mann, in dem der Geist ist, und lege deine Hände auf ihn ");
INSERT INTO deu1912_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","und stelle ihn vor den Priester Eleasar und vor die ganze Gemeinde und gebiete ihm vor ihren Augen, ");
INSERT INTO deu1912_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","und lege von deiner Herrlichkeit auf ihn, daß ihm gehorche die ganze Gemeinde der Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Und er soll treten vor den Priester Eleasar, der soll für ihn ratfragen durch die Weise des Lichts vor dem HERRN. Nach desselben Mund sollen aus und einziehen er und alle Kinder Israel mit ihm und die ganze Gemeinde. ");
INSERT INTO deu1912_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mose tat, wie ihm der HERR geboten hatte, und nahm Josua und stellte ihn vor den Priester Eleasar und vor die ganze Gemeinde ");
INSERT INTO deu1912_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","und legte seine Hand auf ihn und gebot ihm, wie der HERR mit Mose geredet hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Gebiete den Kindern Israel und sprich zu ihnen: Die Opfer meines Brots, welches mein Opfer des süßen Geruchs ist, sollt ihr halten zu seiner Zeit, daß ihr mir's opfert. ");
INSERT INTO deu1912_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Und sprich zu ihnen: Das sind die Opfer, die ihr dem HERRN opfern sollt: jährige Lämmer, die ohne Fehl sind, täglich zwei zum täglichen Brandopfer, ");
INSERT INTO deu1912_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ein Lamm des Morgens, das andere gegen Abend; ");
INSERT INTO deu1912_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","dazu ein zehntel Epha Semmelmehl zum Speisopfer, mit Öl gemengt, das gestoßen ist, ein viertel Hin. ");
INSERT INTO deu1912_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Das ist das tägliche Brandopfer, das ihr am Berge Sinai opfertet, zum süßen Geruch ein Feuer dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Dazu ein Trankopfer je zu einem Lamm ein viertel Hin. Im Heiligtum soll man den Wein des Trankopfers opfern dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Das andere Lamm sollst du gegen Abend zurichten; mit dem Speisopfer wie am Morgen und mit einem Trankopfer sollst du es machen zum Opfer des süßen Geruchs dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Am Sabbattag aber zwei jährige Lämmer ohne Fehl und zwei Zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, und sein Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Das ist das Brandopfer eines jeglichen Sabbats außer dem täglichen Brandopfer samt seinem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Aber des ersten Tages eurer Monate sollt ihr dem HERRN ein Brandopfer opfern: Zwei junge Farren, einen Widder, sieben jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","und je drei Zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, zu einem Farren; zwei Zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, zu einem Widder; ");
INSERT INTO deu1912_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","und je ein Zehntel Semmelmehl zum Speisopfer, mit Öl gemengt, zu einem Lamm. Das ist das Brandopfer des süßen Geruchs, ein Opfer dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Und ihr Trankopfer soll sein ein halbes Hin Wein zum Farren, ein drittel Hin zum Widder, ein viertel Hin zum Lamm. Das ist das Brandopfer eines jeglichen Monats im Jahr. ");
INSERT INTO deu1912_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Dazu soll man einen Ziegenbock zum Sündopfer dem HERRN machen außer dem täglichen Brandopfer und seinem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Aber am vierzehnten Tage des ersten Monats ist das Passah des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Und am fünfzehnten Tage desselben Monats ist Fest. Sieben Tage soll man ungesäuertes Brot essen. ");
INSERT INTO deu1912_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Der erste Tag soll heilig heißen, daß ihr zusammenkommt; keine Dienstarbeit sollt ihr an ihm tun ");
INSERT INTO deu1912_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","und sollt dem HERRN Brandopfer tun: Zwei junge Farren, einen Widder, sieben jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","samt ihren Speisopfern: Drei Zehntel Semmelmehl, mit Öl gemengt, zu einem Farren, und zwei Zehntel zu dem Widder, ");
INSERT INTO deu1912_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","und je ein Zehntel auf ein Lamm unter den sieben Lämmern; ");
INSERT INTO deu1912_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","dazu einen Bock zum Sündopfer, daß ihr versöhnt werdet. ");
INSERT INTO deu1912_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Und sollt solches tun außer dem Brandopfer am Morgen, welche das tägliche Brandopfer ist. ");
INSERT INTO deu1912_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Nach dieser Weise sollt ihr alle Tage, die sieben Tage lang, das Brot opfern zum Opfer des süßen Geruchs dem HERRN außer dem täglichen Brandopfer, dazu sein Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Und der siebente Tag soll bei euch heilig heißen, daß ihr zusammenkommt; keine Dienstarbeit sollt ihr da tun. ");
INSERT INTO deu1912_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Und der Tag der Erstlinge, wenn ihr opfert das neue Speisopfer dem HERRN, wenn eure Wochen um sind, soll heilig heißen, daß ihr zusammenkommt; keine Dienstarbeit sollt ihr da tun ");
INSERT INTO deu1912_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","und sollt dem HERRN Brandopfer tun zum süßen Geruch: zwei junge Farren, einen Widder, sieben jährige Lämmer; ");
INSERT INTO deu1912_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","samt ihrem Speisopfer: drei Zehntel Semmelmehl, mit Öl gemengt, zu einem Farren, zwei Zehntel zu dem Widder, ");
INSERT INTO deu1912_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","und je ein Zehntel zu einem Lamm der sieben Lämmer; ");
INSERT INTO deu1912_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","und einen Ziegenbock, euch zu versöhnen. ");
INSERT INTO deu1912_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Dies sollt ihr tun außer dem täglichen Brandopfer mit seinem Speisopfer. Ohne Fehl soll's sein, dazu ihre Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Und der erste Tag des siebenten Monats soll bei euch heilig heißen, daß ihr zusammenkommt; keine Dienstarbeit sollt ihr da tun-es ist euer Drommetentag- ");
INSERT INTO deu1912_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","und sollt Brandopfer tun zum süßen Geruch dem HERRN: einen jungen Farren, einen Widder, sieben jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","dazu ihr Speisopfer: drei Zehntel Semmelmehl, mit Öl gemengt, zu dem Farren, zwei Zehntel zu dem Widder, ");
INSERT INTO deu1912_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","und ein Zehntel auf ein jegliches Lamm der sieben Lämmer; ");
INSERT INTO deu1912_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","auch einen Ziegenbock zum Sündopfer, euch zu versöhnen- ");
INSERT INTO deu1912_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","außer dem Brandopfer des Monats und seinem Speisopfer und außer dem täglichen Brandopfer mit seinem Speisopfer und mit seinem Trankopfer, wie es recht ist -, zum süßen Geruch. Das ist ein Opfer dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Der zehnte Tag des siebenten Monats soll bei euch auch heilig heißen, daß ihr zusammenkommt; und sollt eure Leiber kasteien und keine Arbeit da tun, ");
INSERT INTO deu1912_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","sondern Brandopfer dem HERRN zum süßen Geruch opfern: einen jungen Farren, einen Widder, sieben jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","mit ihren Speisopfern: drei Zehntel Semmelmehl, mit Öl gemengt, zu dem Farren, zwei Zehntel zu dem Widder, ");
INSERT INTO deu1912_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","und ein Zehntel je zu einem Lamm der sieben Lämmer; ");
INSERT INTO deu1912_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","dazu einen Ziegenbock zum Sündopfer, außer dem Sündopfer der Versöhnung und dem täglichen Brandopfer mit seinem Speisopfer und mit ihrem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Der fünfzehnte Tag des siebenten Monats soll bei euch heilig heißen, daß ihr zusammenkommt; keine Dienstarbeit sollt ihr an dem tun und sollt dem HERRN sieben Tage feiern ");
INSERT INTO deu1912_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","und sollt dem HERRN Brandopfer tun zum Opfer des süßen Geruchs dem HERRN: dreizehn junge Farren, zwei Widder; vierzehn jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","samt ihrem Speisopfer: drei Zehntel Semmelmehl, mit Öl gemengt, je zu einem der dreizehn Farren, zwei Zehntel je zu einem Widder, ");
INSERT INTO deu1912_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","und ein Zehntel je zu einem der vierzehn Lämmer; ");
INSERT INTO deu1912_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","dazu einen Ziegenbock zum Sündopfer, -außer dem täglichen Brandopfer mit seinem Speisopfer und seinem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Am zweiten Tage: zwölf junge Farren, zwei Widder, vierzehn jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","mit ihrem Speisopfer und Trankopfer zu den Farren, zu den Widdern und zu den Lämmern in ihrer Zahl, wie es recht ist; ");
INSERT INTO deu1912_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer mit seinem Speisopfer und mit ihrem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Am dritten Tage: elf Farren, zwei Widder, vierzehn jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","mit ihrem Speisopfer und Trankopfer zu den Farren, zu den Widdern und zu den Lämmern in ihrer Zahl, wie es recht ist; ");
INSERT INTO deu1912_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer mit seinem Speisopfer und mit ihrem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Am vierten Tage: Zehn Farren, zwei Widder, vierzehn jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","samt ihren Speisopfern und Trankopfern zu den Farren, zu den Widdern und zu den Lämmern in ihrer Zahl, wie es recht ist; ");
INSERT INTO deu1912_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer mit seinem Speisopfer und mit ihrem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Am fünften Tage: neun Farren, zwei Widder, vierzehn jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","samt ihren Speisopfern und Trankopfern zu den Farren, zu den Widdern und zu den Lämmern in ihrer Zahl, wie es recht ist; ");
INSERT INTO deu1912_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer mit seinem Speisopfer und mit ihrem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Am sechsten Tage: acht Farren, zwei Widder, vierzehn jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","samt ihren Speisopfern und Trankopfern zu den Farren, zu den Widdern und zu den Lämmern in ihrer Zahl, wie es recht ist; ");
INSERT INTO deu1912_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer mit seinem Speisopfer und mit ihrem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Am siebenten Tage: sieben Farren, zwei Widder, vierzehn jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","samt ihren Speisopfern und Trankopfern zu den Farren, zu den Widdern und zu den Lämmern in ihrer Zahl, wie es recht ist; ");
INSERT INTO deu1912_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","dazu einen Ziegenbock zum Sündopfer, außer dem täglichen Brandopfer mit seinem Speisopfer und mit ihrem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Am achten soll der Tag der Versammlung sein; keine Dienstarbeit sollt ihr da tun ");
INSERT INTO deu1912_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","und sollt Brandopfer opfern zum Opfer des süßen Geruchs dem HERRN: einen Farren, einen Widder, sieben jährige Lämmer ohne Fehl; ");
INSERT INTO deu1912_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","samt ihren Speisopfern und Trankopfern zu den Farren, zu den Widdern und zu den Lämmern in ihrer Zahl, wie es recht ist; ");
INSERT INTO deu1912_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","dazu einen Bock zum Sündopfer, außer dem täglichen Brandopfer mit seinem Speisopfer und mit ihrem Trankopfer. ");
INSERT INTO deu1912_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Solches sollt ihr dem HERRN tun auf eure Feste, außerdem, was ihr gelobt und freiwillig gebt zu Brandopfern, Speisopfern, Trankopfern und Dankopfern. ");
INSERT INTO deu1912_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","30:1 Und Mose sagte den Kindern Israel alles, was ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","30:2 Und Mose redete mit den Fürsten der Stämme der Kinder Israel und sprach: das ist's, was der HERR geboten hat: ");
INSERT INTO deu1912_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","30:3 Wenn jemand dem HERRN ein Gelübde tut oder einen Eid schwört, daß er seine Seele verbindet, der soll sein Wort nicht aufheben, sondern alles tun, wie es zu seinem Munde ist ausgegangen. ");
INSERT INTO deu1912_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","30:4 Wenn ein Weib dem HERRN ein Gelübde tut und sich verbindet, solange sie in ihres Vaters Hause und ledig ist, ");
INSERT INTO deu1912_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","30:5 und ihr Gelübde und Verbündnis, das sie nimmt auf ihre Seele, kommt vor ihren Vater, und er schweigt dazu, so gilt all ihr Gelübde und all ihr Verbündnis, das sie ihrer Seele aufgelegt hat. ");
INSERT INTO deu1912_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","30:6 Wo aber ihr Vater ihr wehrt des Tages, wenn er's hört, so gilt kein Gelübde noch Verbündnis, das sie auf ihre Seele gelegt hat; und der HERR wird ihr gnädig sein, weil ihr Vater ihr gewehrt hat. ");
INSERT INTO deu1912_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","30:7 Wird sie aber eines Mannes und hat ein Gelübde auf sich oder ist ihr aus ihren Lippen ein Verbündnis entfahren über ihre Seele, ");
INSERT INTO deu1912_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","30:8 und der Mann hört es, und schweigt desselben Tages, wenn er's hört, so gilt ihr Gelübde und Verbündnis, das sie auf ihre Seele genommen hat. ");
INSERT INTO deu1912_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","30:9 Wo aber ihr Mann ihr wehrt des Tages, wenn er's hört, so ist ihr Gelübde los, das sie auf sich hat, und das Verbündnis, das ihr aus den Lippen entfahren ist über ihre Seele; und der HERR wird ihr gnädig sein. ");
INSERT INTO deu1912_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","30:10 Das Gelübde einer Witwe und Verstoßenen, alles Verbündnis, das sie nimmt auf ihre Seele, das gilt auf ihr. ");
INSERT INTO deu1912_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","30:11 Wenn eine in ihres Mannes Hause gelobt oder sich mit einem Eide verbindet über ihre Seele, ");
INSERT INTO deu1912_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","30:12 und ihr Mann hört es, und schweigt dazu und wehrt es nicht, so gilt all dasselbe Gelübde und alles Verbündnis, das sie auflegt ihrer Seele. ");
INSERT INTO deu1912_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","30:13 Macht's aber ihr Mann des Tages los, wenn er's hört, so gilt das nichts, was aus ihren Lippen gegangen ist, was sie gelobt oder wozu sie sich verbunden hat über ihre Seele; denn ihr Mann hat's losgemacht, und der HERR wird ihr gnädig sein. ");
INSERT INTO deu1912_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","30:14 Alle Gelübde und Eide, die verbinden den Leib zu kasteien, mag ihr Mann bekräftigen oder aufheben also: ");
INSERT INTO deu1912_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","30:15 wenn er dazu schweigt von einem Tag zum andern, so bekräftigt er alle ihre Gelübde und Verbündnisse, die sie auf sich hat, darum daß er geschwiegen hat des Tages, da er's hörte; ");
INSERT INTO deu1912_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","30:16 wird er's aber aufheben, nachdem er's gehört hat, so soll er ihre Missetat tragen. ");
INSERT INTO deu1912_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","30:17 Das sind die Satzungen, die der HERR dem Mose geboten hat zwischen Mann und Weib, zwischen Vater und Tochter, solange sie noch ledig ist in ihres Vaters Hause. ");
INSERT INTO deu1912_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Räche die Kinder Israel an den Midianitern, daß du darnach dich sammelst zu deinem Volk. ");
INSERT INTO deu1912_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Da redete Mose mit dem Volk und sprach: Rüstet unter euch Leute zum Heer wider die Midianiter, daß sie den HERRN rächen an den Midianitern, ");
INSERT INTO deu1912_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","aus jeglichem Stamm tausend, daß ihr aus allen Stämmen Israels in das Heer schickt. ");
INSERT INTO deu1912_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Und sie nahmen aus den Tausenden Israels je tausend eines Stammes, zwölftausend gerüstet zum Heer. ");
INSERT INTO deu1912_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Und Mose schickte sie mit Pinehas, dem Sohn Eleasars, des Priesters, ins Heer und die heiligen Geräte und die Halldrommeten in seiner Hand. ");
INSERT INTO deu1912_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Und sie führten das Heer wider die Midianiter, wie der HERR dem Mose geboten hatte, und erwürgten alles, was männlich war. ");
INSERT INTO deu1912_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Dazu die Könige der Midianiter erwürgten sie samt ihren Erschlagenen, nämlich Evi, Rekem, Zur, Hur und Reba, die fünf Könige der Midianiter. Bileam, den Sohn Beors, erwürgten sie auch mit dem Schwert. ");
INSERT INTO deu1912_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Und die Kinder Israel nahmen gefangen die Weiber der Midianiter und ihre Kinder; all ihr Vieh, alle ihre Habe und alle ihre Güter raubten sie, ");
INSERT INTO deu1912_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","und verbrannten mit Feuer alle ihre Städte ihrer Wohnungen und alle Zeltdörfer. ");
INSERT INTO deu1912_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Und nahmen allen Raub und alles, was zu nehmen war, Menschen und Vieh, ");
INSERT INTO deu1912_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","und brachten's zu Mose und zu Eleasar, dem Priester, und zu der Gemeinde der Kinder Israel, nämlich die Gefangenen und das genommene Vieh und das geraubte Gut ins Lager auf der Moabiter Gefilde, das am Jordan liegt gegenüber Jericho. ");
INSERT INTO deu1912_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Und Mose und Eleasar, der Priester, und alle Fürsten der Gemeinde gingen ihnen entgegen, hinaus vor das Lager. ");
INSERT INTO deu1912_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Und Mose ward zornig über die Hauptleute des Heeres, die Hauptleute über tausend und über hundert waren, die aus dem Heer und Streit kamen, ");
INSERT INTO deu1912_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","und sprach zu ihnen: Warum habt ihr alle Weiber leben lassen? ");
INSERT INTO deu1912_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Siehe, haben nicht dieselben die Kinder Israel durch Bileams Rat abwendig gemacht, daß sie sich versündigten am HERRN über dem Peor und eine Plage der Gemeinde des HERRN widerfuhr? ");
INSERT INTO deu1912_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","So erwürget nun alles, was männlich ist unter den Kindern, und alle Weiber, die Männer erkannt und beigelegen haben; ");
INSERT INTO deu1912_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","aber alle Kinder, die weiblich sind und nicht Männer erkannt haben, die laßt für euch leben. ");
INSERT INTO deu1912_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Und lagert euch draußen vor dem Lager sieben Tage, alle, die jemand erwürgt oder Erschlagene angerührt haben, daß ihr euch entsündigt am dritten und am siebenten Tage, samt denen, die ihr gefangen genommen habt. ");
INSERT INTO deu1912_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Und alle Kleider und alles Gerät von Fellen und alles Pelzwerk und alles hölzerne Gefäß sollt ihr entsündigen. ");
INSERT INTO deu1912_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Und Eleasar, der Priester, sprach zu dem Kriegsvolk, das in den Streit gezogen war: Das ist das Gesetz, welches der HERR dem Mose geboten hat: ");
INSERT INTO deu1912_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Gold, Silber, Erz, Eisen, Zinn und Blei ");
INSERT INTO deu1912_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","und alles was das Feuer leidet, sollt ihr durchs Feuer lassen gehen und reinigen; nur daß es mit dem Sprengwasser entsündigt werde. Aber alles, was das Feuer nicht leidet, sollt ihr durchs Wasser gehen lassen. ");
INSERT INTO deu1912_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Und sollt eure Kleider waschen am siebenten Tage, so werdet ihr rein; darnach sollt ihr ins Lager kommen. ");
INSERT INTO deu1912_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Nimm die Summe des Raubes der Gefangenen, an Menschen und an Vieh, du und Eleasar, der Priester, und die obersten Väter der Gemeinde; ");
INSERT INTO deu1912_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","und gib die Hälfte denen, die ins Heer gezogen sind und die Schlacht getan haben, und die andere Hälfte der Gemeinde. ");
INSERT INTO deu1912_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Du sollst aber dem HERRN heben von den Kriegsleuten, die ins Heer gezogen sind, je fünf Hunderten eine Seele, an Menschen, Rindern, Eseln und Schafen. ");
INSERT INTO deu1912_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Von ihrer Hälfte sollst du es nehmen und dem Priester Eleasar geben zur Hebe dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Aber von der Hälfte der Kinder Israel sollst du je ein Stück von fünfzigen nehmen, an Menschen, Rindern, Eseln und Schafen und von allem Vieh, und sollst es den Leviten geben, die des Dienstes warten an der Wohnung des HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Und Mose und Eleasar, der Priester, taten, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Und es war die übrige Ausbeute, die das Kriegsvolk geraubt hatte, sechsmal hundert und fünfundsiebzigtausend Schafe, ");
INSERT INTO deu1912_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","zweiundsiebzigtausend Rinder, ");
INSERT INTO deu1912_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","einundsechzigtausend Esel ");
INSERT INTO deu1912_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","und der Mädchen, die nicht Männer erkannt hatten, zweiunddreißigtausend Seelen. ");
INSERT INTO deu1912_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Und die Hälfte, die denen, so ins Heer gezogen waren, gehörte, war an der Zahl dreihundertmal und siebenunddreißigtausend und fünfhundert Schafe; ");
INSERT INTO deu1912_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","davon wurden dem HERRN sechshundertfünfundsiebzig Schafe. ");
INSERT INTO deu1912_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Desgleichen sechsunddreißigtausend Rinder; davon wurden dem HERRN zweiundsiebzig. ");
INSERT INTO deu1912_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Desgleichen dreißigtausend und fünfhundert Esel; davon wurden dem HERRN einundsechzig. ");
INSERT INTO deu1912_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Desgleichen Menschenseelen, sechzehntausend Seelen; davon wurden dem HERRN zweiunddreißig Seelen. ");
INSERT INTO deu1912_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Und Mose gab solche Hebe des HERRN dem Priester Eleasar, wie ihm der HERR geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Aber die andere Hälfte, die Mose den Kindern Israel zuteilte von den Kriegsleuten, ");
INSERT INTO deu1912_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","nämlich die Hälfte, der Gemeinde zuständig, war auch dreihundertmal und siebenunddreißigtausend fünfhundert Schafe, ");
INSERT INTO deu1912_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","sechsunddreißigtausend Rinder, ");
INSERT INTO deu1912_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","dreißigtausend und fünfhundert Esel ");
INSERT INTO deu1912_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","und sechzehntausend Menschenseelen. ");
INSERT INTO deu1912_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Und Mose nahm von dieser Hälfte der Kinder Israel je ein Stück von fünfzigen, sowohl des Viehs als der Menschen, und gab's den Leviten, die des Dienstes warteten an der Wohnung des HERRN, wie der HERR dem Mose geboten hatte. ");
INSERT INTO deu1912_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Und es traten herzu die Hauptleute über die Tausende des Kriegsvolks, nämlich die über tausend und über hundert waren, zu Mose ");
INSERT INTO deu1912_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","und sprachen zu ihm: Deine Knechte haben die Summe genommen der Kriegsleute, die unter unsern Händen gewesen sind, und fehlt nicht einer. ");
INSERT INTO deu1912_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Darum bringen wir dem HERRN Geschenke, was ein jeglicher gefunden hat von goldenem Geräte, Ketten, Armgeschmeide, Ringe, Ohrenringe und Spangen, daß unsere Seelen versöhnt werden vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Und Mose samt dem Priester Eleasar nahm von ihnen das Gold von allerlei Geräte. ");
INSERT INTO deu1912_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Und alles Goldes Hebe, das sie dem HERRN hoben, war sechzehntausend und siebenhundertfünfzig Lot von den Hauptleuten über tausend und hundert. ");
INSERT INTO deu1912_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Denn die Kriegsleute hatten geraubt ein jeglicher für sich. ");
INSERT INTO deu1912_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Und Mose mit Eleasar, dem Priester, nahm das Gold von den Hauptleuten über tausend und hundert, und brachten es in die Hütte des Stifts zum Gedächtnis der Kinder Israel vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Die Kinder Ruben und die Kinder Gad hatten sehr viel Vieh und sahen das Land Jaser und Gilead an als gute Stätte für ihr Vieh ");
INSERT INTO deu1912_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","und kamen und sprachen zu Mose und zu dem Priester Eleasar und zu den Fürsten der Gemeinde: ");
INSERT INTO deu1912_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Das Land Ataroth, Dibon, Jaser, Nimra, Hesbon, Eleale, Sebam, Nebo und Beon, ");
INSERT INTO deu1912_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","das der HERR geschlagen hat vor der Gemeinde Israel, ist gut zur Weide; und wir, deine Knechte, haben Vieh. ");
INSERT INTO deu1912_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Und sprachen weiter: Haben wir Gnade vor dir gefunden, so gib dies Land deinen Knechten zu eigen, so wollen wir nicht über den Jordan ziehen. ");
INSERT INTO deu1912_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mose sprach zu ihnen: Eure Brüder sollen in den Streit ziehen, und ihr wollt hier bleiben? ");
INSERT INTO deu1912_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Warum macht ihr der Kinder Israel Herzen abwendig, daß sie nicht hinüberziehen in das Land, das ihnen der HERR geben wird? ");
INSERT INTO deu1912_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Also taten auch eure Väter, da ich sie aussandte von Kades-Barnea, das Land zu schauen; ");
INSERT INTO deu1912_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","und da sie hinaufgekommen waren bis an den Bach Eskol und sahen das Land, machten sie das Herz der Kinder Israel abwendig, daß sie nicht in das Land wollten, das ihnen der HERR geben wollte. ");
INSERT INTO deu1912_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Und des HERRN Zorn ergrimmte zur selben Zeit, und er schwur und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Diese Leute, die aus Ägypten gezogen sind, von zwanzig Jahren und darüber sollen wahrlich das Land nicht sehen, das ich Abraham, Isaak und Jakob geschworen habe, darum daß sie mir nicht treulich nachgefolgt sind; ");
INSERT INTO deu1912_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ausgenommen Kaleb, den Sohn Jephunnes, des Kenisiters, und Josua, den Sohn Nuns; denn sie sind dem HERRN treulich nachgefolgt. ");
INSERT INTO deu1912_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Also ergrimmte des HERRN Zorn über Israel, und er ließ sie hin und her in der Wüste ziehen vierzig Jahre, bis daß ein Ende ward all des Geschlechts, das übel getan hatte vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Und siehe, ihr seid aufgetreten an eurer Väter Statt, daß der Sünder desto mehr seien und ihr auch den Zorn und Grimm des HERRN noch mehr macht wider Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Denn wo ihr euch von ihm wendet, so wird er auch noch länger sie lassen in der Wüste, und ihr werdet dies Volk alles verderben. ");
INSERT INTO deu1912_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Da traten sie herzu und sprachen: Wir wollen nur Schafhürden hier bauen für unser Vieh und Städte für unsere Kinder; ");
INSERT INTO deu1912_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","wir aber wollen uns rüsten vornan vor den Kindern Israel her, bis daß wir sie bringen an ihren Ort. Unsre Kinder sollen in den verschlossenen Städten bleiben um der Einwohner willen des Landes. ");
INSERT INTO deu1912_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Wir wollen nicht heimkehren, bis die Kinder Israel einnehmen ein jeglicher sein Erbe. ");
INSERT INTO deu1912_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Denn wir wollen nicht mit ihnen erben jenseit des Jordans, sondern unser Erbe soll uns diesseit des Jordan gegen Morgen gefallen sein. ");
INSERT INTO deu1912_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mose sprach zu Ihnen: Wenn ihr das tun wollt, daß ihr euch rüstet zum Streit vor dem HERRN, ");
INSERT INTO deu1912_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","so zieht über den Jordan vor dem HERRN, wer unter euch gerüstet ist, bis daß er seine Feinde austreibe von seinem Angesicht ");
INSERT INTO deu1912_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","und das Land untertan werde dem HERRN; darnach sollt ihr umwenden und unschuldig sein vor dem HERRN und vor Israel und sollt dies Land also haben zu eigen vor dem HERRN. ");
INSERT INTO deu1912_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Wo ihr aber nicht also tun wollt, siehe, so werdet ihr euch an dem HERRN versündigen und werdet eurer Sünde innewerden, wenn sie euch finden wird. ");
INSERT INTO deu1912_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","So bauet nun Städte für eure Kinder und Hürden für euer Vieh und tut, was ihr geredet habt. ");
INSERT INTO deu1912_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Die Kinder Gad und die Kinder Ruben sprachen zu Mose: Deine Knechte sollen tun, wie mein Herr geboten hat. ");
INSERT INTO deu1912_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Unsre Kinder, Weiber, Habe und all unser Vieh sollen in den Städten Gileads sein; ");
INSERT INTO deu1912_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","wir aber, deine Knechte, wollen alle gerüstet zum Heer in den Streit ziehen vor dem HERRN, wie mein Herr geredet hat. ");
INSERT INTO deu1912_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Da gebot Mose ihrethalben dem Priester Eleasar und Josua, dem Sohn Nuns, und den obersten Vätern der Stämme der Kinder Israel ");
INSERT INTO deu1912_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","und sprach zu ihnen: Wenn die Kinder Gad und die Kinder Ruben mit euch über den Jordan ziehen, alle gerüstet zum Streit vor dem HERRN, und das Land euch untertan ist, so gebet ihnen das Land Gilead zu eigen; ");
INSERT INTO deu1912_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ziehen sie aber nicht mit euch gerüstet, so sollen sie unter euch erben im Lande Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Die Kinder Gad und die Kinder Ruben antworteten und sprachen: Wie der Herr redete zu seinen Knechten, so wollen wir tun. ");
INSERT INTO deu1912_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Wir wollen gerüstet ziehen vor dem HERRN ins Land Kanaan und unser Erbgut besitzen diesseit des Jordans. ");
INSERT INTO deu1912_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Also gab Mose den Kindern Gad und den Kindern Ruben und dem halben Stamm Manasses, des Sohnes Josephs, das Königreich Sihons, des Königs der Amoriter, und das Königreich Ogs, des Königs von Basan, das Land samt den Städten in dem ganzen Gebiete umher. ");
INSERT INTO deu1912_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Da bauten die Kinder Gad Dibon, Ataroth, Aroer, ");
INSERT INTO deu1912_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth-Sophan, Jaser, Jogbeha, ");
INSERT INTO deu1912_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth-Nimra und Beth-Haran, verschlossene Städte und Schafhürden. ");
INSERT INTO deu1912_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Die Kinder Ruben bauten Hesbon, Eleale, Kirjathaim, ");
INSERT INTO deu1912_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal-Meon, und änderten die Namen, und Sibma, und gaben den Städten Namen, die sie bauten. ");
INSERT INTO deu1912_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Und die Kinder Machirs, des Sohnes Manasses, gingen nach Gilead und gewannen's und vertrieben die Amoriter, die darin waren. ");
INSERT INTO deu1912_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Da gab Mose dem Machir, dem Sohn Manasses, Gilead; und er wohnte darin. ");
INSERT INTO deu1912_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair aber, der Sohn Manasses, ging hin und gewann ihre Dörfer und hieß sie Dörfer Jairs. ");
INSERT INTO deu1912_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah ging hin und gewann Knath mit seinen Ortschaften und hieß sie Nobah nach seinem Namen. ");
INSERT INTO deu1912_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Das sind die Reisen der Kinder Israel, da sie aus Ägyptenland gezogen sind mit ihrem Heer durch Mose und Aaron. ");
INSERT INTO deu1912_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Und Mose beschrieb ihren Auszug, wie sie zogen nach dem Befehl des HERRN, und dies sind die Reisen ihres Zuges. ");
INSERT INTO deu1912_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Sie zogen aus von Raemses am fünfzehnten Tag des ersten Monats, dem zweiten Tage der Ostern, durch eine hohe Hand, daß es alle Ägypter sahen, ");
INSERT INTO deu1912_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","als sie eben die Erstgeburt begruben, die der HERR unter ihnen geschlagen hatte; denn der HERR hatte auch an ihren Göttern Gericht geübt. ");
INSERT INTO deu1912_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Als sie nun von Raemses auszogen, lagerten sie sich in Sukkoth. ");
INSERT INTO deu1912_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Und zogen aus von Sukkoth und lagerten sich in Etham, welches liegt an dem Ende der Wüste. ");
INSERT INTO deu1912_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Von Etham zogen sie aus und blieben in Pihachiroth, welches liegt gegen Baal-Zephon, und lagerten sich gegen Migdol. ");
INSERT INTO deu1912_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Von Hachiroth zogen sie aus und gingen mitten durchs Meer in die Wüste und reisten drei Tagereisen in der Wüste Etham und lagerten sich in Mara. ");
INSERT INTO deu1912_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Von Mara zogen sie aus und kamen gen Elim; da waren zwölf Wasserbrunnen und siebzig Palmen; und lagerten sich daselbst. ");
INSERT INTO deu1912_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Von Elim zogen sie aus und lagerten sich an das Schilfmeer. ");
INSERT INTO deu1912_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Von dem Schilfmeer zogen sie aus und lagerten sich in der Wüste Sin. ");
INSERT INTO deu1912_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Von der Wüste Sin zogen sie aus und lagerten sich in Dophka. ");
INSERT INTO deu1912_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Von Dophka zogen sie aus und lagerten sich in Alus. ");
INSERT INTO deu1912_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Von Alus zogen sie aus und lagerten sich in Raphidim, daselbst hatte das Volk kein Wasser zu trinken. ");
INSERT INTO deu1912_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Von Raphidim zogen sie aus und lagerten sich in der Wüste Sinai. ");
INSERT INTO deu1912_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Von Sinai zogen sie aus und lagerten sich bei den Lustgräbern. ");
INSERT INTO deu1912_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Von den Lustgräbern zogen sie aus und lagerten sich in Hazeroth. ");
INSERT INTO deu1912_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Von Hazeroth zogen sie aus und lagerten sich in Rithma. ");
INSERT INTO deu1912_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Von Rithma zogen sie aus und lagerten sich in Rimmon-Perez. ");
INSERT INTO deu1912_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Von Rimmon-Perez zogen sie aus und lagerten sich in Libna. ");
INSERT INTO deu1912_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Von Libna zogen sie aus und lagerten sich in Rissa. ");
INSERT INTO deu1912_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Von Rissa zogen sie aus und lagerten sich in Kehelatha. ");
INSERT INTO deu1912_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Von Kehelatha zogen sie aus und lagerten sich im Gebirge Sepher. ");
INSERT INTO deu1912_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Vom Gebirge Sepher zogen sie aus und lagerten sich in Harada. ");
INSERT INTO deu1912_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Von Harada zogen sie aus und lagerten sich in Makheloth. ");
INSERT INTO deu1912_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Von Makheloth zogen sie aus und lagerten sich in Thahath. ");
INSERT INTO deu1912_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Von Thahath zogen sie aus und lagerten sich in Tharah. ");
INSERT INTO deu1912_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Von Tharah zogen sie aus und lagerten sich in Mithka. ");
INSERT INTO deu1912_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Von Mithka zogen sie aus und lagerten sich in Hasmona. ");
INSERT INTO deu1912_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Von Hasmona zogen sie aus und lagerten sich in Moseroth. ");
INSERT INTO deu1912_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Von Moseroth zogen sie aus und lagerten sich in Bne-Jaakan. ");
INSERT INTO deu1912_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Von Bne-Jaakan zogen sie aus und lagerten sich in Horgidgad. ");
INSERT INTO deu1912_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Von Horgidgad zogen sie aus und lagerten sich in Jotbatha. ");
INSERT INTO deu1912_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Von Jotbatha zogen sie aus und lagerten sich in Abrona. ");
INSERT INTO deu1912_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Von Abrona zogen sie aus und lagerten sich in Ezeon-Geber. ");
INSERT INTO deu1912_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Von Ezeon-Geber zogen sie aus und lagerten sich in der Wüste Zin, das ist Kades. ");
INSERT INTO deu1912_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Von Kades zogen sie aus und lagerten sich an dem Berge Hor, an der Grenze des Landes Edom. ");
INSERT INTO deu1912_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Da ging der Priester Aaron auf den Berg Hor nach dem Befehl des HERRN und starb daselbst im vierzigsten Jahr des Auszugs der Kinder Israel aus Ägyptenland am ersten Tage des fünften Monats, ");
INSERT INTO deu1912_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","da er hundertunddreiundzwanzig Jahre alt war. ");
INSERT INTO deu1912_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Und der König der Kanaaniter zu Arad, der da wohnte gegen Mittag des Landes Kanaan, hörte, daß die Kinder Israel kamen. ");
INSERT INTO deu1912_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Und von dem Berge Hor zogen sie aus und lagerten sich in Zalmona. ");
INSERT INTO deu1912_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Von Zalmona zogen sie aus und lagerten sich in Phunon. ");
INSERT INTO deu1912_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Von Phunon zogen sie aus und lagerten sich in Oboth. ");
INSERT INTO deu1912_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Von Oboth zogen sie aus und lagerten sich in Ije-Abarim, in der Moabiter Gebiet. ");
INSERT INTO deu1912_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Von Ijim zogen sie aus und lagerten sich in Dibon-Gad. ");
INSERT INTO deu1912_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Von Dibon-Gad zogen sie aus und lagerten sich in Almon-Diblathaim. ");
INSERT INTO deu1912_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Von Almon-Diblathaim zogen sie aus und lagerten sich in dem Gebirge Abarim vor dem Nebo. ");
INSERT INTO deu1912_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Von dem Gebirge Abarim zogen sie aus und lagerten sich in das Gefilde der Moabiter an dem Jordan gegenüber Jericho. ");
INSERT INTO deu1912_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Sie lagerten sich aber am Jordan von Beth-Jesimoth an bis an Abel-Sittim, im Gefilde der Moabiter. ");
INSERT INTO deu1912_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Und der HERR redete mit Mose in dem Gefilde der Moabiter an dem Jordan gegenüber Jericho und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Rede mit den Kindern Israel und sprich zu ihnen: Wenn ihr über den Jordan gegangen seid in das Land Kanaan, ");
INSERT INTO deu1912_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","so sollt ihr alle Einwohner vertreiben vor eurem Angesicht und alle ihre Säulen und alle ihre gegossenen Bilder zerstören und alle ihre Höhen vertilgen, ");
INSERT INTO deu1912_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","daß ihr also das Land einnehmet und darin wohnet; denn euch habe ich das Land gegeben, daß ihr's einnehmet. ");
INSERT INTO deu1912_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Und sollt das Land austeilen durchs Los unter eure Geschlechter. Denen, deren viele sind, sollt ihr desto mehr zuteilen, und denen, deren wenige sind, sollt ihr desto weniger zuteilen. Wie das Los einem jeglichen daselbst fällt, so soll er's haben; nach den Stämmen eurer Väter sollt ihr's austeilen. ");
INSERT INTO deu1912_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Werdet ihr aber die Einwohner des Landes nicht vertreiben vor eurem Angesicht, so werden euch die, so ihr überbleiben laßt, zu Dornen werden in euren Augen und zu Stacheln in euren Seiten und werden euch drängen in dem Lande darin ihr wohnet. ");
INSERT INTO deu1912_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","So wird's dann gehen, daß ich euch gleich tun werde, wie ich gedachte ihnen zu tun. ");
INSERT INTO deu1912_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Gebiete den Kindern Israel und sprich zu ihnen: Wenn ihr ins Land Kanaan kommt, so soll dies das Land sein, das euch zum Erbteil fällt, das Land Kanaan nach seinen Grenzen. ");
INSERT INTO deu1912_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Die Ecke gegen Mittag soll anfangen an der Wüste Zin bei Edom, daß eure Grenze gegen Mittag sei vom Ende des Salzmeeres, das gegen Morgen liegt, ");
INSERT INTO deu1912_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","und das die Grenze sich lenke mittagwärts von der Steige Akrabbim und gehe durch Zin, und ihr Ausgang sei mittagwärts von Kades-Barnea und gelange zum Dorf Adar und gehe durch Azmon ");
INSERT INTO deu1912_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","und lenke sich von Azmon an den Bach Ägyptens, und ihr Ende sei an dem Meer. ");
INSERT INTO deu1912_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Aber die Grenze gegen Abend soll diese sein, nämlich das große Meer. Das sei eure Grenze gegen Abend. ");
INSERT INTO deu1912_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Die Grenze gegen Mitternacht soll diese sein: ihr sollt messen von dem großen Meer bis an den Berg Hor, ");
INSERT INTO deu1912_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","und von dem Berg Hor messen, bis man kommt gen Hamath, das der Ausgang der Grenze sei gen Zedad ");
INSERT INTO deu1912_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","und die Grenze ausgehe gen Siphron und ihr Ende sei am Dorf Enan. Das sei eure Grenze gegen Mitternacht. ");
INSERT INTO deu1912_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Und sollt messen die Grenze gegen Morgen vom Dorf Enan gen Sepham, ");
INSERT INTO deu1912_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","und die Grenze gehe herab von Sepham gen Ribla morgenwärts von Ain; darnach gehe sie herab und lenke sich an die Seite des Meers Kinneret gegen Morgen ");
INSERT INTO deu1912_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","und komme herab an den Jordan, daß ihr Ende sei das Salzmeer. Das sei euer Land mit seiner Grenze umher. ");
INSERT INTO deu1912_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Und Mose gebot den Kindern Israel und sprach: Das ist das Land, das ihr durchs Los unter euch teilen sollt, das der HERR geboten hat den neun Stämmen und dem halben Stamm zu geben. ");
INSERT INTO deu1912_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Denn der Stamm der Kinder Ruben nach ihren Vaterhäusern und der halbe Stamm Manasse haben ihr Teil genommen. ");
INSERT INTO deu1912_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Also haben zwei Stämme und der halbe Stamm ihr Erbteil dahin, diesseit des Jordans gegenüber Jericho gegen Morgen. ");
INSERT INTO deu1912_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Das sind die Namen der Männer, die das Land unter euch teilen sollen: der Priester Eleasar und Josua, der Sohn Nuns. ");
INSERT INTO deu1912_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Dazu sollt ihr nehmen von einem jeglichen Stamm einen Fürsten, das Land auszuteilen. ");
INSERT INTO deu1912_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Und das sind der Männer Namen: Kaleb, der Sohn Jephunnes, des Stammes Juda; ");
INSERT INTO deu1912_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Samuel, der Sohn Ammihuds, des Stammes Simeon; ");
INSERT INTO deu1912_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidad, der Sohn Chislons, des Stammes Benjamin; ");
INSERT INTO deu1912_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Bukki, der Sohn Joglis, Fürst des Stammes der Kinder Dan; ");
INSERT INTO deu1912_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Hanniel, der Sohn Ephods, Fürst des Stammes der Kinder Manasse, von den Kindern Joseph; ");
INSERT INTO deu1912_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemuel, der Sohn Siphtans, Fürst des Stammes der Kinder Ephraim; ");
INSERT INTO deu1912_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elizaphan, der Sohn Parnachs, Fürst des Stammes der Kinder Sebulon; ");
INSERT INTO deu1912_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Paltiel, der Sohn Assans, der Fürst des Stammes der Kinder Isaschar; ");
INSERT INTO deu1912_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahihud, der Sohn Selomis, Fürst des Stammes der Kinder Asser; ");
INSERT INTO deu1912_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pedahel, der Sohn Ammihuds, Fürst des Stammes der Kinder Naphthali. ");
INSERT INTO deu1912_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Dies sind die, denen der HERR gebot, daß sie den Kindern Israel Erbe austeilten im Lande Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Und der HERR redete mit Mose auf den Gefilde der Moabiter am Jordan gegenüber Jericho und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Gebiete den Kindern Israel, daß sie den Leviten Städte geben von ihren Erbgütern zur Wohnung; ");
INSERT INTO deu1912_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","dazu Vorstädte um die Städte her sollt ihr den Leviten auch geben, daß sie in den Städten wohnen und in den Vorstädten ihr Vieh und Gut und allerlei Tiere haben. ");
INSERT INTO deu1912_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Die Weite aber der Vorstädte, die ihr den Leviten gebt, soll tausend Ellen draußen vor der Stadtmauer umher haben. ");
INSERT INTO deu1912_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","So sollt ihr nun messen außen an der Stadt von der Ecke gegen Morgen zweitausend Ellen und von der Ecke gegen Mittag zweitausend Ellen und von der Ecke gegen Abend zweitausend Ellen und von der Ecke gegen Mitternacht zweitausend Ellen, daß die Stadt in der Mitte sei. Das sollen ihre Vorstädte sein. ");
INSERT INTO deu1912_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Und unter den Städten, die ihr den Leviten geben werdet, sollt ihr sechs Freistädte geben, daß dahinein fliehe, wer einen Totschlag getan hat. Über dieselben sollt ihr noch zweiundvierzig Städte geben, ");
INSERT INTO deu1912_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","daß alle Städte, die ihr den Leviten gebt, seien achtundvierzig mit ihren Vorstädten. ");
INSERT INTO deu1912_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Und sollt derselben desto mehr geben von denen, die viel besitzen unter den Kindern Israel, und desto weniger von denen, die wenig besitzen; ein jeglicher nach seinem Erbteil, das ihm zugeteilt wird, soll Städte den Leviten geben. ");
INSERT INTO deu1912_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Und der HERR redete mit Mose und sprach: ");
INSERT INTO deu1912_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Rede mit den Kindern Israel und sprich zu ihnen: Wenn ihr über den Jordan ins Land Kanaan kommt, ");
INSERT INTO deu1912_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","sollt ihr Städte auswählen, daß sie Freistädte seien, wohin fliehe, wer einen Totschlag unversehens tut. ");
INSERT INTO deu1912_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Und sollen unter euch solche Freistädte sein vor dem Bluträcher, daß der nicht sterben müsse, der einen Totschlag getan hat, bis daß er vor der Gemeinde vor Gericht gestanden sei. ");
INSERT INTO deu1912_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Und der Städte, die ihr geben werdet zu Freistädten, sollen sechs sein. ");
INSERT INTO deu1912_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Drei sollt ihr geben diesseit des Jordans und drei im Lande Kanaan. ");
INSERT INTO deu1912_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Das sind die sechs Freistädte, den Kindern Israel und den Fremdlingen und den Beisassen unter euch, daß dahin fliehe, wer einen Totschlag getan hat unversehens. ");
INSERT INTO deu1912_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Wer jemand mit einem Eisen schlägt, daß er stirbt, der ist ein Totschläger und soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Wirft er ihn mit einem Stein, mit dem jemand mag getötet werden, daß er davon stirbt, so ist er ein Totschläger und soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Schlägt er ihn aber mit einem Holz, mit dem jemand mag totgeschlagen werden, daß er stirbt, so ist er ein Totschläger und soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Der Rächer des Bluts soll den Totschläger zum Tode bringen; wo er ihm begegnet, soll er ihn töten. ");
INSERT INTO deu1912_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Stößt er ihn aus Haß oder wirft etwas auf ihn aus List, daß er stirbt, ");
INSERT INTO deu1912_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","oder schlägt ihn aus Feindschaft mit seiner Hand, daß er stirbt, so soll er des Todes sterben, der ihn geschlagen hat; denn er ist ein Totschläger. Der Rächer des Bluts soll ihn zum Tode bringen, wo er ihm begegnet. ");
INSERT INTO deu1912_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Wenn er ihn aber ungefähr stößt, ohne Feindschaft, oder wirft irgend etwas auf ihn unversehens ");
INSERT INTO deu1912_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","oder wirft irgend einen Stein auf ihn, davon man sterben mag, und er hat's nicht gesehen, also daß er stirbt, und er ist nicht sein Feind, hat ihm auch kein Übles gewollt, ");
INSERT INTO deu1912_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","so soll die Gemeinde richten zwischen dem, der geschlagen hat, und dem Rächer des Bluts nach diesen Rechten. ");
INSERT INTO deu1912_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Und die Gemeinde soll den Totschläger erretten von der Hand des Bluträchers und soll ihn wiederkommen lassen zu der Freistadt, dahin er geflohen war; und er soll daselbst bleiben, bis daß der Hohepriester sterbe, den man mit dem heiligen Öl gesalbt hat. ");
INSERT INTO deu1912_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Wird aber der Totschläger aus seiner Freistadt Grenze gehen, dahin er geflohen ist, ");
INSERT INTO deu1912_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","und der Bluträcher findet ihn außerhalb der Grenze seiner Freistadt und schlägt ihn tot, so soll er des Bluts nicht schuldig sein. ");
INSERT INTO deu1912_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Denn er sollte in seiner Freistadt bleiben bis an den Tod des Hohenpriesters, und nach des Hohenpriesters Tod wieder zum Lande seines Erbguts kommen. ");
INSERT INTO deu1912_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Das soll euch ein Recht sein bei euren Nachkommen, überall, wo ihr wohnt. ");
INSERT INTO deu1912_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Den Totschläger soll man töten nach dem Mund zweier Zeugen. Ein Zeuge soll nicht aussagen über eine Seele zum Tode. ");
INSERT INTO deu1912_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Und ihr sollt keine Versühnung nehmen für die Seele eines Totschlägers; denn er ist des Todes schuldig, und er soll des Todes sterben. ");
INSERT INTO deu1912_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Und sollt keine Versühnung nehmen für den, der zur Freistadt geflohen ist, daß er wiederkomme, zu wohnen im Lande, bis der Priester sterbe. ");
INSERT INTO deu1912_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Und schändet das Land nicht, darin ihr wohnet; denn wer blutschuldig ist, der schändet das Land, und das Land kann vom Blut nicht versöhnt werden, das darin vergossen wird, außer durch das Blut des, der es vergossen hat. ");
INSERT INTO deu1912_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Verunreinigt das Land nicht, darin ihr wohnet, darin ich auch wohne; denn ich bin der HERR, der unter den Kindern Israel wohnt. ");
INSERT INTO deu1912_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Und die obersten Väter des Geschlechts der Kinder Gileads, des Sohnes Machirs, der Manasses Sohn war, von den Geschlechtern der Kinder Joseph, traten herzu und redeten vor Mose und vor den Fürsten, den obersten Vätern der Kinder Israel, ");
INSERT INTO deu1912_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","und sprachen: Meinem Herrn hat der HERR geboten, daß man das Land zum Erbteil geben sollte durchs Los den Kindern Israel; auch ward meinem Herrn geboten von dem HERRN, daß man das Erbteil Zelophehads, unsers Bruders, seinen Töchtern geben soll. ");
INSERT INTO deu1912_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Wenn sie jemand aus den Stämmen der Kinder Israel zu Weibern nimmt, so wird unserer Väter Erbteil weniger werden, und so viel sie haben, wird zu dem Erbteil kommen des Stammes, dahin sie kommen; also wird das Los unseres Erbteils verringert. ");
INSERT INTO deu1912_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Wenn nun das Halljahr der Kinder Israel kommt, so wird ihr Erbteil zu dem Erbteil des Stammes kommen, da sie sind; also wird das Erbteil des Stammes unserer Väter verringert, so viel sie haben. ");
INSERT INTO deu1912_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Mose gebot den Kindern Israel nach dem Befehl des Herrn und sprach: Der Stamm der Kinder Joseph hat recht geredet. ");
INSERT INTO deu1912_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Das ist's, was der HERR gebietet den Töchtern Zelophehads und spricht: Laß sie freien, wie es ihnen gefällt; allein daß sie freien unter dem Geschlecht des Stammes ihres Vaters, ");
INSERT INTO deu1912_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","auf daß nicht die Erbteile der Kinder Israel fallen von einen Stamm zum andern; denn ein jeglicher unter den Kindern Israel soll anhangen an dem Erbe des Stammes seiner Väter. ");
INSERT INTO deu1912_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Und alle Töchter, die Erbteil besitzen unter den Stämmen der Kinder Israel, sollen freien einen von dem Geschlecht des Stammes ihres Vaters, auf daß ein jeglicher unter den Kindern Israel seiner Väter Erbe behalte ");
INSERT INTO deu1912_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","und nicht ein Erbteil von einem Stamm falle auf den andern, sondern ein jeglicher hange an seinem Erbe unter den Stämmen der Kinder Israel. ");
INSERT INTO deu1912_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Wie der HERR dem Mose geboten hatte, so taten die Töchter Zelophehads, ");
INSERT INTO deu1912_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mahela, Thirza, Hogla, Milka und Noa, und freiten die Kinder ihrer Vettern, ");
INSERT INTO deu1912_vpl VALUES ("NU36