﻿USE sofia;
DROP TABLE IF EXISTS sofia.des_vpl;
CREATE TABLE des_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES des_vpl WRITE;
INSERT INTO des_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo ñecʉ sʉmarã iribojegue majarã árĩñuma. Eropigʉ ĩgʉ ñecʉ mʉrʉ iribojegue majagʉ Davi waĩcʉgʉ árĩmʉriñumi. Ĩgʉ árĩboro core erã ñecʉ Abrahã waĩcʉgʉ árĩmʉriñumi. ");
INSERT INTO des_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahã Isaa pagʉ árĩñumi. Isaa Jacobo pagʉ árĩñumi. Jacobo Judá sã pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá porã Fares Zara sã árĩñuma. Erã pago Tamar waĩcʉgo árĩñumo. Fares Esrom pagʉ árĩñumi. Esrom Aram pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab pagʉ árĩñumi. Aminadab Naasón pagʉ árĩñumi. Naasón Salmón pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz pagʉ árĩñumi. Ĩgʉ pago Rahab árĩñumo. Booz Obed pagʉ árĩñumi. Ĩgʉ pago Rut árĩñumo. Obed Isaí pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí Davi pagʉ árĩñumi. Davipʉ Israe majarã tauro opʉ árĩñumi. Ĩgʉ Uria waĩcʉgʉ mʉrʉ marapore ĩgʉ marapocʉra pʉhrʉ Salomo waĩcʉgʉre porãcʉñumo igo. ");
INSERT INTO des_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo Roboam pagʉ árĩñumi. Roboam Abías pagʉ árĩñumi. Abías Asa pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafat pagʉ árĩñumi. Josafat Joram pagʉ árĩñumi. Joram Uzías pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotam pagʉ árĩñumi. Jotam Acaz pagʉ árĩñumi. Acaz Ezequia pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequia Manase pagʉ árĩñumi. Manase Amón pagʉ árĩñumi. Amón Josia pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia Jeconia sã pagʉ árĩñumi. Erã árĩrisubure Israe yeba majarãre Babilonia majarãpʉ ñeagãñuma erã ya yebague peresu iimorã. ");
INSERT INTO des_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Eropi Babilonia yeba erã ejara pʉhrʉ, Jeconia marapo Salatiere porãcʉñumo. Salatie Zorobabe pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabe Abiud pagʉ árĩñumi. Abiud Eliaquim pagʉ árĩñumi. Eliaquim Azor pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Zadoc pagʉ árĩñumi. Zadoc Aquim pagʉ árĩñumi. Aquim Eliud pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar pagʉ árĩñumi. Eleazar Matán pagʉ árĩñumi. Matán Jacobo pagʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobo José pagʉ árĩñumi. José María marapʉ árĩmʉriñumi. Maríapʉ Jesu pago árĩmo. Jesupʉ masare taubu árĩgʉ Cristo erã arĩ piyudigʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eropirã Abrahãre mari queonʉgacʉ̃, ne Daviguere mari queotucʉ̃, oã árĩpehrerã árĩrã catorce cururi gohra árĩñuma. Eropirã mari dipaturi Davire queocʉ̃, ne Babiloniague Israe majarãre erã aĩgãboro core queotucʉ̃ catorce cururi gohra dipaturi árĩñuma. Eropiituhaja Babiloniague erã ejara pʉhrʉ mari queonʉgacʉ̃ ne Cristo ĩgʉ masa dehyoacʉ̃gue mari queotucʉ̃ catorce cururi gohra árĩñuma daja. ");
INSERT INTO des_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Eropigʉ Jesucristo õpa masa dehyoapʉ. Ĩgʉ pago Maríapʉ José mera mojoto diribo árĩpo. Eropigo igo ĩgʉ mera marapʉcʉboro core Espíritu Santo ĩgʉ turari mera majigʉ bocapo. Eropigo igo basi majigʉ opawahgũriñere masipo igo. ");
INSERT INTO des_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Eropigʉ José igore mojoto diribodigʉ irire masigʉ, diaye árĩrire ĩgʉ iigʉ árĩgʉ igore cóãbu iiripʉ. Igore gʉhyasĩuro iidiabigʉ, masa erã masibiricʉ̃ ta igore cóãbu iiripʉ. ");
INSERT INTO des_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Irire ĩgʉ pepirisubu Goãmʉ anyupʉ quẽrogue Josére dehyoagʉ, õpa arĩpʉ. —José, Davi mʉrʉ pãrami, María mera gʉhyasĩriro mariro mojoto dirique. Igo Espíritu Santo ĩgʉ turari mera ne nijipo árĩ wahgãrigo ãhrimo. Eropigʉ gʉhyasĩriro mariro igore mojoto dirique. ");
INSERT INTO des_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Igo porãcʉgocumo. Ĩgʉ igo magʉ ta ĩgʉ ya maca majarãre erã ñeri iira dipuwajare taubu árĩgʉcumi. Ĩgʉ eropa taubu árĩcʉ̃ Jesu waĩyegʉca mʉhʉ ĩgʉgãre, arĩpʉ anyu Josére. ");
INSERT INTO des_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","I árĩpehreri eropa wayoro iribojegue majagʉ Goãmʉ ya weremʉhtadigʉ ĩgʉ arĩ gojadiro dopa ta. Irire ĩgʉre Goãmʉ gojadoreñumi. Õpa arĩ gojamʉriñumi Goãmʉ yare: ");
INSERT INTO des_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nómeo ʉmʉ mera árĩbigo, majigʉgãre bocago porãcʉgocumo igo magʉgãre. Eropigʉ Emanuel waĩcʉgʉcumi ĩgʉgã, arĩ gojañumi Goãmʉ yare gojayudigʉgue. Emanuel arĩdiaro “Goãmʉ mari mera ta ãhrimi,” arĩdiaro iiaa. ");
INSERT INTO des_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Goãmʉ yagʉ anyu Josére eropa arĩ werera pʉhrʉ Josépʉ wahgã anyu ĩgʉ dorediro dopa ta María mera mojoto diripʉ. ");
INSERT INTO des_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Igo magʉgãre igo porãcʉboro core Josépʉ igo mera árĩnibiripʉ. Igopʉ porãcʉpo pare. Eropigʉ ĩgʉpʉ igo magʉgãre Jesu waĩyepʉ. ");
INSERT INTO des_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea yeba árĩri maca Belén waĩcʉri maca Jesu masa dehyoapʉ. Irisubu Herode Judea yeba majarã erã tauro opʉ árĩpʉ. Ĩgʉ eropa masa dehyoara pʉhrʉ necãre buherã necãre õaro masirã abe mʉririropʉ majarã ahri, Jerusaléngue erañorã. ");
INSERT INTO des_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Eropa erarã, masare ero majarãre serẽpiñorã: —¿Judio masa erã tauro opʉ árĩbu dohpaguere nohogue masa dehyoayuri ĩgʉ? Abe ĩgʉ mʉririro majarãgue árĩrã, ne necãmʉ dehyoacʉ̃ ĩabʉ. Eropa ĩgʉ dehyoacʉ̃ ĩha “Opʉ masa dehyoagʉ iicumi,” arĩ masiabʉ gʉa. Eropa ĩgʉ ne dehyoacʉ̃ ĩarã gʉa yujuro mera ĩgʉre umupeorã arirã iiabʉ õgue, arĩ wereñorã necãre buheri masa masare. ");
INSERT INTO des_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Erã eroparĩcʉ̃ pee erã opʉre Herodere irire wererã wañorã. Eropigʉ gajigʉ opʉ masa dehyoarare erã werecʉ̃ peegʉ Herodepʉ guñaricʉpʉ. Eropirã árĩpehrerã Jerusalén majarã sã ĩgʉ iro dopa ta guñaricʉñorã erã sã. ");
INSERT INTO des_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eropigʉ Herodepʉ árĩpehrerã pahia oparãre, judio masare buherã sãre sihupehocãpʉ. Ĩgʉ sihubeora pʉhrʉ erã gamenere­pehrecʉ̃ ĩha, erãre serẽpipʉ ĩgʉ: —¿Nohogue masa dehyoagʉcuri Goãmʉ beyedigʉ Cristopʉ mʉa pepicʉ̃? arĩ serẽpipʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Õpa arĩ wereñorã erã ĩgʉre: —Belén, Judea yebague árĩri macague Cristo masa dehyoagʉcumi. Õpa arĩ gojamʉriñumi Goãmʉ yare weremʉhtadigʉ: ");
INSERT INTO des_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén waĩcʉri macague yujugʉ opʉ dehyoagʉcumi. Ĩgʉ Goãmʉ yarãre Israe majarãre dorebu árĩgʉcumi. Eropiro Belén Judea yeba árĩri macari watope bu árĩri maca árĩquerero gaji macari tauro árĩroca, arĩ gojamʉriñumi Goãmʉ yare gojayudigʉgue, arĩ wereñorã erã Herodere. ");
INSERT INTO des_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erã eropa arĩra pʉhrʉ Herode masa erã peebirogue abe mʉririropʉ arinirãre sihubeopʉ. Ĩgʉ pohrogue erã ejara pʉhrʉ, erãre ĩgʉ serẽpira pʉhrʉ, erã necãmʉre erã ĩaranʉre wereñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Erã eropa werera pʉhrʉ Herodepʉ erãre Beléngue obeogʉ õpa arĩpʉ erãre: —Ĩgʉgãre õaro amaque. Ĩgʉgãre mʉa bocajara pʉhrʉ yʉ sãre wererã arique mʉa. Ĩgʉgãre umupeogʉ wabu iiaa yʉ sã, arĩ were obeoripʉ erãre Herodepʉ. ");
INSERT INTO des_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ĩgʉ eropa arĩra pʉhrʉ, erã waha wañorã. Erã eropa wacʉ̃ abe mʉririropʉ erã ĩadiru necãmʉpʉ erã core wamʉhtaniguicãyoro. Eropiro majigʉgã ĩgʉ árĩro weca dujanʉgaja wayoro iriru necãmʉ. ");
INSERT INTO des_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Eropirã necãmʉ dujanʉgajacʉ̃ ĩarã, bʉrigã mucubiriñorã erã. ");
INSERT INTO des_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Majigʉgã ĩgʉ árĩri wihigue eja, ñaja wañorã erã. Eropa ñajajarã majigʉgãre ĩgʉ pago mera árĩgʉre ĩañorã erã. Eropirã erã mereja, ĩgʉre umupeoñorã. Umupeotuhaja, erã ya comorire aĩbeo, pãgũñorã erã ĩgʉgãre aĩgãrirare omorã. Eropirã orore, buirire, poresuri sãre aĩwiu, ĩgʉgãre waja mariro oñorã. ");
INSERT INTO des_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Irire otuhara pʉhrʉ carĩa wañorã erã. Erã eropa carĩcʉ̃ quẽrogue Goãmʉ werepʉ erãre: “Herode pohro dujabiricãque,” arĩ werepʉ Goãmʉ erãre quẽroguere. Ĩgʉ eropa arĩ werera pʉhrʉ, erãpʉ wahgãñorã. Erã eropa wahgãra pʉhrʉ gaji mague erã ya yebague dujarã dujaa wañorã. ");
INSERT INTO des_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Erã eropa wara pʉhrʉ Goãmʉ yagʉ anyu quẽrogue Josére dehyoagʉ, õpa arĩ werepʉ: —Wahgãque. Herodepʉ majigʉgãre wejẽbu amagʉcumi dohpaguere. Eropigʉ majigʉ sãre ĩgʉ pago sãre Egiptogue duru aĩ duhrigãque. Eroguere yʉ dipaturi mʉre werecʉ̃gue dujarique, arĩ werepʉ anyu Josére. ");
INSERT INTO des_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ĩgʉ eroparĩcʉ̃ peegʉ, Josépʉ ñami ta wahgã, majigʉ sãre ĩgʉ pago sãre Egiptogue aĩ duhrigã wapʉ. ");
INSERT INTO des_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egiptogue eja, Herode ĩgʉ ojocariropẽ ta eroguere árĩñorã erã. Eropa wayoro iribojegue majagʉ Goãmʉ ya weremʉhtadigʉ ĩgʉ arĩ gojadiro dopa ta. Irire ĩgʉre Goãmʉ gojadoreñumi. Õpa arĩ gojamʉriñumi Goãmʉ yare gojayudigʉgue: “Egiptogue árĩgʉre yʉ magʉre sihubeoabʉ,” arĩ gojamʉriñumi Goãmʉ yare weremʉhtadigʉgue. ");
INSERT INTO des_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eropigʉ necã buherã erã duhri dujaacʉ̃ peegʉ Herodepʉ guatariacãpʉ. Eropigʉ Belén majarãre, iri maca pohro majarã sãre erã porãre ʉma porãgãre wejẽpehocãdorepʉ ĩgʉ. Ne dehyoarãre wejẽnʉgadore pe bojori oparãre wejẽtudorepʉ ĩgʉ. Nere necãre buheri masa necãmʉre erã ĩaranʉre wereñorã Herodere. Erã eroparĩcʉ̃ peegʉ ĩgʉ Jesu masa dehyoarinʉre masigʉ, “I nʉcʉ bojori ta ĩgʉ opacumi,” arĩgʉ majirãre pe bojori oparãre wejẽtudorepʉ. ");
INSERT INTO des_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ĩgʉ eropiicʉ̃ iribojegue majagʉ Jeremia Goãmʉ yare weremʉhtadigʉ ĩgʉ arĩ gojadiro dopa ta eropa wayoro. Õpa wereyu gojañumi ĩgʉ: ");
INSERT INTO des_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá waĩcʉrogue bʉsʉro carabʉ. Bʉrigã bʉjawereri mera orerã carama. Raquel acawererã Israe masa marasã nome erã porãre bʉrigã orerãcoma. Erã porã sĩricʉ̃ ĩarã ne bʉjawere duhusome,” arĩ gojañumi iribojeguere Herode majirãre wejẽdoreboro core. ");
INSERT INTO des_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Eropi Herode ĩgʉ sĩrira pʉhrʉ Egiptogue árĩdigʉre Josére Goãmʉ yagʉ anyu quẽrogue dehyoapʉ daja. Eropa dehyoagʉ õpa arĩpʉ Josére: ");
INSERT INTO des_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Majigʉgãre wejẽdianirã mʉra sĩria waháma. Eropigʉ ĩgʉ majigʉre, ĩgʉ pago sãre Israe yebague aĩ dujaaque mʉhʉ, arĩ werepʉ anyu Josére. ");
INSERT INTO des_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ĩgʉ eropa arĩra pʉhrʉ wahgã, majigʉgãre ĩgʉ pago mera ta Israe yebague aĩ dujaa wapʉ. ");
INSERT INTO des_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Arquelao Herode magʉ ĩgʉ pagʉre gohrotodigʉ ĩgʉ árĩcʉ̃ pee, Josépʉ Judea yeba árĩgʉ güipʉ. Eropigʉ dipaturi ta Goãmʉ quẽrogue ĩgʉre werenemopʉ. Ĩgʉre Judeague dipaturi dujadorebiripʉ. Ĩgʉ eropa werera pʉhrʉ erã Galilea yebague waha wañorã. ");
INSERT INTO des_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Iri yebaguere Nazare waĩcʉri macague eja árĩñorã erã. Eropa iiñorã erã Goãmʉ yare weremʉhtanirã erã gojadiro dopa ta. Õpa arĩ wereyumʉriñuma: “‘Cristo Goãmʉ beyedigʉ Nazare majagʉ ta ãhrimi,’ arĩrãcoma masa,” arĩ gojamʉriñuma iribojegue majarã. ");
INSERT INTO des_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Eropi irisubure Ñu Goãmʉ yarãre waĩyeri masʉ árĩpʉ. Judea yeba masa marirogue ĩgʉ Goãmʉ yare werenʉgapʉ. ");
INSERT INTO des_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Õpa arĩ werepʉ masare ĩgʉ pohro ejarãre. —Mʉa ñero iirare bʉjawere duhucãque. Ʉmaro majagʉ Goãmʉ mʉa opʉ ĩgʉ árĩboro merogã dʉhyaa, arĩ werepʉ ĩgʉ Ñu. ");
INSERT INTO des_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iribojegue majagʉ Isaia Goãmʉ yare weremʉhtadigʉ Ñu eropa waburire õpa arĩ gojayuñumi: Masa marirogue werenigui gaguiniguigʉ õpa arĩ buhegʉcumi ĩgʉ: “Mari Opʉ ĩgʉ ariburi mare amuro dopa ta ĩgʉ ariboro core õarã árĩyuque mʉa ĩgʉre peemorã,” arĩ wereniguigʉcumi, arĩ gojañumi Isaia. ");
INSERT INTO des_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ihĩ Ñu camello ya gasirire suhri sañagʉ, waibʉgʉ ya gasirodare tʉãdiudigʉ árĩpʉ. Eropigʉ poreroare bamʉripʉ. Eropárĩcʉ̃ nʉgʉ majarã momere bapʉ. ");
INSERT INTO des_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén maca majarã, árĩpehrero Judea yeba árĩrã, dia Jordán waĩcʉriya pohro árĩrã sã ĩgʉre peerã wañorã. ");
INSERT INTO des_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Erã eropa pee, erã ñero iirare bʉjawere, Goãmʉre irire weretarimʉriñorã erã. Erã eropa werecʉ̃ peegʉ dia Jordán waĩcʉriyague Ñu erãre waĩyepʉ. ");
INSERT INTO des_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Eropigʉ bajarã fariseo masa, saduceo masa sã ĩgʉre waĩyedorerã ejacʉ̃ ĩagʉ Ñu werepʉ erãre: —Mʉa ñero iiricʉrã ãhraa mʉa. “Goãmʉre gʉa ñeri dipuwaja moabiricãporo,” arĩrã, ¿mʉa yʉre waĩyedorerã ahriri? ");
INSERT INTO des_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ĩgʉ mʉa ñero iira dipuwajare moabiricʉ̃ õpa iique mʉa. Diaye ta mʉa ñeri iirare bʉjawererã árĩrã, õarire gohrotorã árĩrã, õarire iique mʉa. ");
INSERT INTO des_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Õpa arĩ pepibiricãque: “Abrahã mari ñecʉ mʉrʉ árĩmʉripʉ. Eropirã Goãmʉ mera õhaa,” arĩ pepibiricãque mʉa. Mʉare arĩgʉ tiiaa. Abrahã pãramerã mʉa árĩri duhpiburi árĩbeaa. Goãmʉ gamegʉ i ʉtãyeri mera gajirãre iimasimi Abrahã acawererãre. Eropirã Abrahã pãramerã mʉa árĩri bu gohra ta ãhraa. ");
INSERT INTO des_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Õpa ãhraa: Mari masa yucʉ iro dopa ãhraa. Goãmʉpʉ come opagʉ iro dopa ãhrimi. Eropigʉ ñeri dʉcacʉri yucʉre pa cohã, iri nuguri sãre tabetagʉcumi. Tabetatuhaja, peamegue cóãgʉcumi ĩgʉ iri yucʉre, iri nuguri sãre. Eropa ta iigʉcumi mʉa sãre ĩgʉre gamebirãre. ");
INSERT INTO des_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yʉ pʉhrʉ yʉ tauro turagʉ arigʉcumi. Õatariagʉ ãhrimi. Ĩgʉ iro dopa õagʉ árĩbeaa yʉpʉ. Eropigʉ ĩgʉre pepigʉ “Yʉ tamera bu gohra árĩgʉ ãhraa,” arĩ pepia yʉhʉ. Mʉa ñero iirare bʉjawerera pʉhrʉ, yʉpʉ deco mera waĩyea. Yʉ pʉhrʉ arigʉpʉ yʉhʉ tauro iigʉcumi. Espíritu Santore ogʉcumi masa mera árĩniguibure. Eropigʉ peamegue ĩgʉ ñerire soewearo dopa ta ĩgʉpʉ mʉa ñero iirire coegʉcumi. ");
INSERT INTO des_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yʉ pʉhrʉ arigʉ trigo gasirire cóãgʉ iro dopa ãhrimi. Gasirire cóãgʉ ĩgʉ sihburu mera árĩpehreri trigo yeri gasirire sʉha weami. Ĩgʉ eropa sʉha weara pʉhrʉ trigo gohra yeripʉre ĩgʉ diburi wihigue dibugʉcumi. Ĩgʉ sʉha weara gasiripʉre ĩgʉ soegʉcumi. Õpa ii beyegʉcumi yʉ pʉhrʉ arigʉpʉ. Õarire gohrotonirãpʉre ĩgʉ mera árĩniguicʉ̃ iigʉcumi. Erã ñerire bʉjawerebirãpʉre peamegue yaribiri peamegue cóãgʉcumi, arĩ werepʉ Ñu. ");
INSERT INTO des_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pʉhrʉ Jesu Galileague árĩdigʉ wapʉ. Jordán waĩcʉriyague ejapʉ Ñure “Yʉre waĩyeque,” arĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Negohraguere Ñu ĩgʉre waĩyediabiriripʉ. —Cue, mʉpʉ yʉ tauro turagʉpʉre yʉre mʉ waĩyecʉ̃ õaboaya. Mʉre waĩyebu árĩbeaa yʉhʉ, arĩ yʉhripʉ Ñu Jesure. ");
INSERT INTO des_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesupʉ yʉhripʉ ĩgʉre: —Yʉre waĩyeque. Mari õpa iirã Goãmʉ ĩgʉ dorediro dopa ta iirã iiaa, arĩpʉ Jesu. Ĩgʉ eroparĩcʉ̃ peegʉ, —Áʉ, arĩ yʉhripʉ Ñu. ");
INSERT INTO des_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Eropa arĩtuhaja Jesure waĩyepʉ. Waĩyetuhajacʉ̃ Jesu diague niguidigʉ majanʉgajapʉ. Ĩgʉ majanʉgajacʉ̃ ta, ʉmʉsi ĩgʉre pãrima wayoro. Eropigʉ Goãmʉ yagʉ Espíritu Santo buja iro dopa bejagʉ ĩgʉ weca ĩgʉ dijaricʉ̃ ĩapʉ ĩgʉ basi. ");
INSERT INTO des_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eropiro ʉmarogue wereniguiro cariyoro: —Ihĩ yʉ magʉ yʉ mahigʉ ãhrimi. Ĩgʉ mera bʉrigã mucubiria, arĩro cariyoro ʉmaroguere. ");
INSERT INTO des_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Eropi Espíritu Santopʉ Jesure masa marirogue wadorepʉ erogue watĩ ĩgʉre ñerire iidoreboro dopa. ");
INSERT INTO des_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Erogue ejagʉ, cuarenta nʉri gohra baro mariro árĩpʉ Jesu. Eropiro pʉhrʉguere ĩgʉre oa pũriyoro pare. ");
INSERT INTO des_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ĩgʉ oaboacʉ̃ ĩagʉ watĩpʉ ĩgʉ pohrogue ejagʉ õpa arĩpʉ: —Mʉhʉ Goãmʉ magʉ árĩgʉ õpa ĩhmuque. Iyerire ʉtãyerire bari poyacʉ̃ iique, arĩripʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu gamebiripʉ. Eropigʉ Jesu õpa arĩ yʉhripʉ: —Goãmʉ yare erã gojarapũ õpa ãhraa: “Masare bari mera dihta ojocaribiro gahmea. Árĩpehreri Goãmʉ ĩgʉ ya wereniguiri mera árĩro gahmea,” arĩmi Goãmʉ, arĩ yʉhripʉ Jesu watĩre. ");
INSERT INTO des_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ĩgʉ eropa arĩ yʉhrira pʉhrʉ watĩpʉ Jerusalén waĩcʉri macague Jesure aĩgãpʉ. Erogue eja, Goãmʉ ya wihi wecague Jesure aĩ mʉrijapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aĩ mʉrijatuha, ĩgʉre õpa arĩripʉ: —¿Diaye ta Goãmʉ magʉ gohra ta ãhriri mʉhʉ? Goãmʉ yare erã gojarapũ õpa ãhraa: “Goãmʉ ĩgʉ yarã anyuare mʉre ĩhadibudoregʉcumi. Eropirã erãpʉ mʉre ĩhadiburãcoma mʉgue ʉtãye weca mehbejajari arĩrã,” arãa ĩgʉ gojarapũ. Erã mʉre eropa ĩhadibumorã árĩcʉ̃ mʉhʉ Goãmʉ magʉ ta árĩgʉ õgue buhrima dija ĩhmuque yʉre. Mʉre erã itamucʉ̃ ĩhmuñata yʉre, arĩripʉ watĩpʉ. ");
INSERT INTO des_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ĩgʉ eroparĩcʉ̃ peegʉ gamebiripʉ Jesu. Õpa arĩ yʉhripʉ ĩgʉre: —Goãmʉ yare erã gojarapũ õpa arãa: “Goãmʉ mʉa Opʉ ĩgʉ arĩrare ‘¿Diaye ta ãhriri?’ arĩ masidiarã Goãmʉre ii ĩhmudoremaabiricãque,” arãa Goãmʉ yare erã gojarapũ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ĩgʉ eropa arĩ yʉhrira pʉhrʉ ʉmadigʉgue ʉtãgʉgue Jesure aĩ mʉriapʉ daja. Irigʉ wecague mʉri bejaja, árĩpehreri macarire i ʉmʉ majare ĩhmupʉ Jesure. Erã opari sãre ĩhmupʉ. ");
INSERT INTO des_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Eropa ĩhmugʉ Jesure õpa arĩpʉ: —Yʉre mereja, “Mʉhʉ yʉ opʉ ãhraa,” arĩ umupeoque mʉhʉ yʉre. Mʉhʉ yʉre eropa iicʉ̃ mʉre árĩpehreri i macarire mʉre ogʉra, arĩ wereripʉ watĩ. ");
INSERT INTO des_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ĩgʉ eroparĩcʉ̃ Jesu õpa arĩ yʉhripʉ daja: —Satana, waque mʉhʉ. Õpa arãa Goãmʉ yare erã gojarapũ: “Mʉ Opʉ Goãmʉ dihtare umupeoque. Ĩgʉ ya doreri dihtare iique,” arãa Goãmʉ yare erã gojarapũ, arĩpʉ Jesu watĩre. ");
INSERT INTO des_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ĩgʉ eroparĩcʉ̃ peegʉ watĩ waha wapʉ. Ĩgʉ wara pʉhrʉ anyuapʉ eja, Jesure itamuñorã. Ĩgʉre barire oñorã. ");
INSERT INTO des_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Eropi Ñure peresu erã iicʉ̃ peegʉ, waha wapʉ Jesu. Galilea yebague ejapʉ. ");
INSERT INTO des_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ero árĩri macague Nazaregue waha, tarigã, Capernaum waĩcʉri macague ejapʉ. Galilea waĩcʉri ditaru pohro árĩbʉ Capernaum. Iri maca Zabulón yeba pohro, Neftalí yeba pohro árĩbʉ Capernaum. Erogue eja árĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Eropa ta iipʉ Jesu iribojegue majagʉ Goãmʉ yare weremʉhtadigʉ Isaia ĩgʉ arĩ gojadiro dopa ta. Õpa arĩ gojayuñumi: ");
INSERT INTO des_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón yeba pohro, Neftalí yeba pohro, ditaru waro, Jordán waĩcʉriya gajipʉ masegue Galilea yeba ãhraa. Iri yeba judio masa árĩbirã ya yeba ãhraa. ");
INSERT INTO des_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ero majarã Goãmʉ yare õaro masibeama. Eropa masibiriquererã ta õagʉre ĩarãgue masirãcoma. Erãpʉ Goãmʉre ne masibeama. Eropirã peamegue wamorã ta árĩrima. Eropigʉ yujugʉ erãre Goãmʉ yare masicʉ̃ iigʉcumi, arĩ gojañumi Isaia Jesu eraboro coregue. ");
INSERT INTO des_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Erogue árĩgʉ Goãmʉ yare werenʉgapʉ Jesu: —Mʉa ñeri iirare bʉjawereque. Eropa iirã õaripʉre gohrotoque. Ʉmaro majagʉ Goãmʉ árĩpehrerã tauro ĩgʉ opʉ árĩboro merogã dʉhyaa, arĩ werenʉgapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Eropi Galilea waĩcʉri ditaru tʉrogue ejagʉ, Simore, ĩgʉ pagʉ magʉ Andre mera bocajapʉ Jesu. Simo ta Pedro erã arĩ piyugʉ árĩpʉ. Erã wai wejẽri masa árĩñorã. Erã ya wejẽri yucʉre mehyurã iiñorã iri ditaru wʉari ditarugue. ");
INSERT INTO des_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Erãre boca õpa arĩpʉ Jesu: —Yʉ mera majarã árĩmorã arique mʉa. Yʉ mera mʉa aricʉ̃ waire ñeha gameneorã mʉa árĩro dopa ta, Goãmʉ yarã árĩmorãre masare sihu gameneomorã árĩcʉ̃ iigʉra mʉare. Yʉ mera mʉa aricʉ̃ eropa iimorãre amugʉra mʉare. Eropirã yʉ mera arique, arĩpʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eropa ĩgʉ arĩcʉ̃ peerã ta erã ya wejẽdi yucʉre apicãa, Jesu mera waha wañorã. ");
INSERT INTO des_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eropirã erã Jesu mera tarigã, Santiagore ĩgʉ pagʉ magʉ Ñu sãre bocajañorã daja. Erã Zebedeo porã árĩñorã. Erã yaru dohodirugue erã pagʉ mera erã sã erã ya wejẽdi yucʉre amurã iiñorã. Erã perãre ĩgʉ sihubeopʉ. ");
INSERT INTO des_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ĩgʉ eropa sihubeocʉ̃ pee, erãpʉ erã pagʉre, dohodiru sãre api Jesu mera waha wañorã. ");
INSERT INTO des_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Eropi árĩpehrerogue Galilea yebare Jesu buhe curipʉ. Judio masa gʉa buheri wirigue õari buherire, ʉmaro majagʉ ĩgʉ opʉ árĩricʉrire buhepʉ. Eropigʉ dorecʉrãre õarã iigʉ árĩpehreri dorecʉrire cóãpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ĩgʉ eropa iicʉ̃ peerã Siria yeba majarã árĩpehrerogue iri yeba árĩrã ĩgʉre masinʉgañorã. Eropa masirã, gajiropa árĩri dore oparãre, watẽa ñajasũnirãre, pũriri dorecʉrãre, sĩriri mʉra dorecʉrãre, dʉpʉ turabirã sãre aĩ ejañorã Jesu pohrogue. Eropigʉ árĩpehrerãre erãre õarã wacʉ̃ iipʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ĩgʉ eropa iicʉ̃ ĩarã, Galilea yeba majarã Decapoli yeba majarã, Jerusalén majarã, Judea yeba majarã, Jordán waĩcʉriya gajipʉ masepʉ majarã, bajarã masa ĩgʉ mera wañorã. ");
INSERT INTO des_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Masa bajarã ĩgʉ pohro erã ejacʉ̃ ĩagʉ Jesu ʉtãgʉgue mʉriapʉ. Mʉrija, ero doajapʉ. Ero ĩgʉ doacʉ̃ ĩgʉ buherã ĩgʉ pohrogue ejañorã. ");
INSERT INTO des_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Erã ejacʉ̃ ĩagʉ õpa arĩ buhenʉgapʉ: ");
INSERT INTO des_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Erã ñerire bʉjawererã, Goãmʉre gamerã mucubirirã ãhrima. Ʉmaro majagʉ erã opʉ árĩroguere warãcoma erã. Ʉmaro maja erã ya ãhraa. Eropirã bʉrigã mucubirirãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Orerã sã mucubirirã ãhrima. Erãre mucubiricʉ̃ iimi mari Pagʉ. Eropirã mucubirirã árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Gajirãre tarinʉgadiabirã eropa árĩca arĩbirã mucubirirã ãhrima. Goãmʉ “Ogʉra,” ĩgʉ arĩrare oparãcoma. Eropirã erã sã mucubirirã árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Goãmʉ ĩgʉ dorero dopa iidiarã, õarire iidiarã mucubirirã ãhrima. Goãmʉ ĩgʉ itamucʉ̃ erã õarire ii ojogorocʉrãcoma. Eropirã mucubirirã árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Gajirãre mojomoro ĩarã mucubirirã ãhrima. Erã eropa mojomoro ĩacʉ̃ Goãmʉ erã sãre mojomoro ĩagʉcumi. Eropirã mucubirirãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Erã ñerire cóãnirã, mucubirirã ãhrima erã. Goãmʉre ĩarãcoma erã. Eropirã mucubirirãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Gajirãre gamequeãcʉ̃ bosarã mucubirirã ãhrima. Erãre “Yʉ porã ãhrima,” arĩgʉcumi Goãmʉ. Eropirã mucubirirãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Goãmʉ dorerire erã iira waja gajirã mera ñero tarinirãpʉ ʉmaro majagʉ erã opʉ árĩroguere ĩgʉ yare oparãcoma erã. Eropirã mucubirirãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Yahare mʉa iira waja gajirã mʉare erã turiquerecʉ̃ ta mucubirirã ãhraa mʉa. Mʉare erã ñero iicʉ̃ mucubirirã ãhraa mʉa. Yaharã mʉa árĩri waja mʉare árĩpehreri ñeri quere goroweoquerecʉ̃ ta mucubirirã ãhraa mʉa. ");
INSERT INTO des_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Goãmʉ yare weremʉhtanirãre mʉa core árĩnirãre erãguere ta ñero iimʉhtañuma. Mʉa sãre erãre iidiro dopa iicʉ̃ mucubirique. Õaro sĩporãcʉque. Eropigʉ ʉmarogue mʉa ejacʉ̃ wʉaro õaro iigʉcumi mʉare Goãmʉ. Eropirã mucubirique mʉa, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Eropi Jesu buhenemopʉ: —Moa waibʉgʉ dihire iri ñero wabiricʉ̃ iiro dopa ta mʉapʉ yaharãpʉ árĩpehrerã gajirãre ñerire erã iidiabiricʉ̃ iiaa. Moa ñeri wacʉ̃ dipaturi õari iimasiya mara. Iri moa ne õabeaa. Iri eropa wacʉ̃ iri moare cóãcãro gahmea. Irire cóãra pʉhrʉ weca ejama. Ne duhpiburi árĩbeaa iri erã cóãra. Iri duhpiburi árĩbiro dopa ta árĩbiricãque mʉa. Goãmʉ yapʉre iiniguicãque, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Eropi ĩgʉ buhenemopʉ: —Boyoro marire ĩhamasicʉ̃ iiro dopa ta mʉapʉre yaharãpʉre i yeba majarãre Goãmʉ yare wererã erãre masicʉ̃ iiro gahmea. Ʉtãgʉ weca árĩri macare duhmasiya mara. ");
INSERT INTO des_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Eropi sihãgodirure masa sihãgorã gajino docague dibubeama. Irure sihãgogʉ ʉmarogue duhpeomi iri wihi majarã árĩpehrerã erã ĩaboro dopa. ");
INSERT INTO des_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eropirã mʉa sã mʉa Goãmʉre mʉa umupeorire dibubiricãque. Õaro wereque. Eropirã õarire iique. Mʉa eropa iicʉ̃ ĩarã masa erã mari Pagʉ ʉmaro majagʉre umupeorãcoma. “Ĩgʉ turagʉ, õagʉ ãhrimi,” arĩrãcoma, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Eropa arĩtuhaja, erãre werenemopʉ: —Ire mʉa masicʉ̃ gahmea yʉhʉ. Goãmʉ ĩgʉ dorerire Moisere ĩgʉ apirare, ĩgʉ yare weremʉhtanirã erã gojara sãre cóãgʉ arigʉ iibiribʉ. Iri dorerire mʉare õaro were amugʉ arigʉ iibʉ. Goãmʉ yare erã werediro dopa ta iigʉ aribʉ. ");
INSERT INTO des_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Diaye ta mʉare arĩgʉ iiaa. I yeba ʉmaro árĩropẽ ta ĩgʉ doreri sã árĩroca. Goãmʉ ĩgʉ dorerare iipehogʉcumi. ");
INSERT INTO des_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eropirã iri dorerire yujurãyeri tarinʉgarã, gajirãre eropa ta iidorerã bu árĩrã árĩrãcoma. Ʉmaro majagʉ opʉ ĩgʉ árĩrogue bu árĩrã iro dopa árĩrãcoma. Yujuñe doreriñe árĩquerecʉ̃ ta erã tarinʉgarã bu árĩrã iro dopa árĩrãcoma erã. Gajirãpʉ ĩgʉ dorerire õaro iirã, gajirãre erã iiro dopa iidorerã ʉmaro majagʉ ĩgʉ opʉ árĩrogue oparã iro dopa árĩrãcoma erã. ");
INSERT INTO des_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mʉare arĩgʉ tiiaa yʉhʉ. Masare buherã, fariseo masa sã Goãmʉ gamerire queoro iibeama. Erã tauro Goãmʉ gamerire iique mʉa. Mʉa eropa iibirã, ĩgʉ opʉ árĩroguere ne ejasome mʉa, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Eropa arĩtuhaja erãre werenemopʉ: —Iribojegue majarã õpa arĩ wererare ta peenirã árĩribʉ mʉa: “Masare wejẽbiricãque. Masare wejẽdigʉ erã dipuwaja moabu ãhrimi,” erã arĩrare peenirã árĩribʉ mʉa. ");
INSERT INTO des_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","I erã werera tauñariro mʉapʉre werenemogʉra. Ĩgʉ acaweregʉ mera papũridigʉpʉ masʉre wejẽdigʉ iro dopa ta ãhrimi. Eropigʉ erã dipuwaja moabu ãhrimi ĩgʉ sã. Ĩgʉ acaweregʉre gameturigʉ dipuwaja moadorerã pohro erã aĩgãbu ta ãhrimi ĩgʉ sã. “Ñegʉ pee masibigʉ ãhraa mʉhʉ,” ĩgʉ acaweregʉre arĩgʉre peamegue wama gʉhyataria ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Mʉa acaweregʉ mʉare ĩgʉ ĩhaturicʉ̃ ĩgʉ mera amumʉhtaque Goãmʉre serẽboro core. Eropirã Goãmʉ wihigue mʉa Goãmʉre umupeorã waboro core, waibʉgʉre mʉa oboro core õpa iique. ");
INSERT INTO des_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Goãmʉre mʉa oburire duhucãnique dohpa. Mʉa acaweregʉ pohrogue waha, “Dipaturi ĩhaturibiricãrã. Irire iripẽta duhurã,” irire arĩque ĩgʉre. Mʉa eropa amura pʉhrʉ Goãmʉre umupeorã waque daja ĩgʉ ya wihigue. ");
INSERT INTO des_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Gajigʉ mʉare weresãdiagʉ, dipuwaja moadoreri wihigue mʉare ĩgʉ aĩgãdiacʉ̃, ĩgʉ mera guaro mariro árĩque. Dipuwaja moadoregʉ pohrogue ĩgʉ aĩ ejaboro core ĩgʉ mera õaro ahmu wereniguique. Mʉa eropa iicʉ̃ ĩagʉ mʉare weresãbiribocumi. Mʉa eropa iibiricʉ̃ eroguere mʉare aĩ ejacʉ̃ ĩgʉpʉ dipuwaja moadoregʉre weresãgʉcumi. Ĩgʉ eropa weresãcʉ̃, beyegʉpʉ peresu iirãguere mʉare ogʉcumi. Eropirã erã mʉare peresu iirãcoma. ");
INSERT INTO des_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Erogue árĩniguirãca mʉa. Ne erã wajayedorerare mʉa wajayepehocʉ̃gue wirirãca mʉa, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Õpa arĩ werenemopʉ Jesu: —Iribojegue majarã õpa erã arĩ wererare peenirã árĩribʉ mʉa. “Gajigʉ marapo mera ñero iibiricãque,” erã arĩrare peenirã árĩribʉ mʉa. ");
INSERT INTO des_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","I erã werera tauñariro mʉare ipʉre werenemogʉra: Nomeore ñeabiriqueregʉ ta yujugʉ igo mera árĩdiagʉ igore ñero ʉaribejagʉ ñero guña pepigʉ ñero iituhami igo mera. ");
INSERT INTO des_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Eropirã mʉa cuiru diayepʉ árĩdiru mera ñero iirã irirure mʉa gorawea cóãbodiro dopa ta iri ñerire duhucãque. Irire duhubirã peamegue warãca. Mʉa cuirure cóãcʉ̃ iri cuiru dihta dederea. Mʉa ñerire duhubirãpʉ peamegue waha ñetariaro tarirãca. Eropirã iri ñerire duhucãque. ");
INSERT INTO des_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Eropirã mʉa mojoto diayepʉ maja mojoto mera ñero iirã iri mojotore tabeta cóãbodiro dopa ta iri ñerire duhucãque. Irire duhubirã peamegue warãca. Mʉa mojotore mʉa cóãcʉ̃ iri mojoto dihta dederea. Mʉa ñerire duhubirãpʉ peamegue waha ñetariaro tarirãca. Eropirã iri ñerire duhucãque, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Õpa arĩ werenemopʉ Jesu: —Iribojegue i sãre arĩñuma: “Ĩgʉ marapore cóãdiagʉ ĩgʉ cóãburire wereripũ mera igore cóãmasimi,” arĩñuma iribojeguere. ");
INSERT INTO des_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","I erã werera tauñariro mʉapʉre ire weregʉra: Yujugʉ ĩgʉ marapo ʉmʉ mera ñero iibiriquerecʉ̃ ta igore cóãbocumi. Ĩgʉ eropa cóãdigo gajigʉ mera marapʉcʉgo ñero iigo iicumo gajigʉ mera árĩgo. Eropigʉ igo marapʉ igore cóãdigʉ igore gajigʉ mera ñero iicʉ̃ iimi. Eropigʉ ĩgʉ cóãdigo mera marapocʉgʉ igo mera ñero iigʉ iimi ĩgʉ sã, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Õpa arĩ werenemopʉ Jesu: —Iribojegue majarãre erã õpa arĩ wererare peenirã árĩribʉ mʉa: “Mʉa arĩdiro dopa ta eropa iique. ‘Goãmʉ mera diaye ta eropa iigʉra,’ mʉa arĩdiro dopa ta iique,” erã arĩ wererare peenirã árĩbʉ mʉa. ");
INSERT INTO des_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","I erã werera tauñariro mʉare weregʉra. “Ʉmaro mera diaye ta arĩgʉ iiaa,” arĩ ʉmaro mera arĩ waĩpeo arĩbiricãque. Ʉmaropʉ mari Opʉ ĩgʉ árĩro ãhraa. Bu árĩro árĩbeaa. Ero eropa árĩro árĩcʉ̃ ĩarã eropa arĩmaabiricãque. ");
INSERT INTO des_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","I yeba mera ne waĩpeo arĩbiricãque. I yeba sã Goãmʉ ya yeba ta ãhraa. Ero eropa árĩro árĩcʉ̃ ĩarã eropa arĩmaabiricãque. Jerusalén mera ne waĩpeobiricãque. Turagʉ mari Opʉ ya maca ãhraa Jerusalén. Bu árĩro árĩbeaa. Eropirã eropa arĩmaabiricãque. ");
INSERT INTO des_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Yʉ dipuru mera diaye arĩgʉ iiaa,” arĩ waĩpeobiricãque. Mʉa poari borecʉ̃ iimasibeaa mʉa. Iri ñiri wacʉ̃ sãre iimasibeaa mʉa. Eropa iimasibirã árĩrã “Yʉ dipuru mera diaye arĩgʉ iiaa,” arĩ waĩpeobiricãque. ");
INSERT INTO des_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Iirãra,” arĩrã waĩpeoro mariro diaye ta irire arĩniguicãque. “Iisome,” arĩrã sã waĩpeoro mariro arĩniguicãque. Mʉa waĩpeo arĩrã watĩ ñegʉ ĩgʉ dorero dopa ta iirã iica, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Õpa arĩ werenemopʉ daja Jesu: —Iribojegue õpa erã arĩ wererare peenirã árĩribʉ mʉa. “Mʉre gajigʉ mʉ cuirure ĩgʉ patĩadiro dopa ta mʉ sã ĩgʉre patĩa gameque. Mʉ gʉcʉrirure ĩgʉ panuadiro dopa ta mʉ sã ĩgʉre ĩgʉ gʉcʉrirure panua gameque,” erã arĩ wererare peenirã árĩribʉ mʉa. ");
INSERT INTO des_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Erã werera tauñariro weregʉra daja mʉare. Mʉare ñero iidigʉre eropa ĩacãque. Yujupʉ mʉ wayuporãre pacʉ̃, “Gajipʉ sãre padiagʉ paque,” arĩque ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gajigʉ mʉre dipuwaja moagʉre ĩgʉ weresãcʉ̃, ĩgʉ dipuwaja moagʉpʉ mʉhʉ camisa mera mʉre weresãdigʉre wajayedorebocumi. Ĩgʉ eropa wajayedorecʉ̃ ĩgʉre oque. Iriñere otuhaja mʉ weca majañe suhriro sãre onemoque ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yujugʉ surara gajinore yuju kilómetro mʉre aĩgãbasadorecʉ̃, gaji kilómetro aĩgãnemobasaque daja ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mʉre serẽdigʉre ĩgʉ serẽropẽ ta oque ĩgʉre. Eropigʉ gajigʉ mʉre wayudorecʉ̃ wayuque ĩgʉre ĩgʉ wayudorerare, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Õpa arĩ werenemopʉ daja Jesu: —Masa õpa arĩmʉrima: “Mʉa mera majarãre mahique. Eropirã mʉare ĩhaturirãpʉre ĩhaturi gameque daja,” erã arĩrare peenirã árĩribʉ mʉa. ");
INSERT INTO des_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Erã werera tauñariro weregʉra mʉare daja: Mʉare ĩhaturirãre mahi umupeoque. Mʉare ñero iirãre õaro árĩdoreque. Mʉare ĩhaturirãre õaro iique. Eropirã mʉare ñero wereniguirãre mʉare ñero iirã sãre “Erã sã õaro árĩporo,” arĩrã Goãmʉre serẽbasaque. ");
INSERT INTO des_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mʉa eropa iirã mari Pagʉ ʉmaro majagʉ Goãmʉ porã ãhraa mʉa. Goãmʉpʉ yujuropa ta iimi masare. Ñerãre, õarã sãre abere asicʉ̃ iimi ĩgʉ. Eropigʉ Goãmʉ ĩgʉ dorerire iirã sãre, iibirã sãre deco merecʉ̃ iimi ĩgʉ. Masare yujuropa ĩgʉ iiro dopa ta mʉa sã masare iique. ");
INSERT INTO des_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉare umupeorã dihtare mʉa umupeocʉ̃ ne duhpiburi árĩbeaa iri. Ñerã masa wajasea corerã sã eropa ta iima. Eropirã árĩpehrerãre umupeoque. ");
INSERT INTO des_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉa acawererã dihtare mʉa õaro bocatĩricʉ̃ ne duhpiburi árĩbeaa iri. Goãmʉre masibirã sã eropa ta iima. Eropirã árĩpehrerãre õaro bocatĩrique. ");
INSERT INTO des_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ñeri marirã árĩque mʉa. Mari Pagʉ ʉmaro majagʉ ĩgʉ ñeri marigʉ ĩgʉ árĩdiro dopa ta mʉa sã ñeri marirã árĩque, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Dipaturi ĩgʉ werenemopʉ: —Goãmʉ ya árĩburire õarire iirã árĩrã, “Goãmʉ yare iipehorã ãhraa gʉa,” arĩ werebiricãque gajirãre. Mʉa eropa arĩ wererã mʉa õaro iira ne duhpiburi árĩbeaa. Eropigʉ Goãmʉ ʉmaro majagʉ õarire mʉa iira wajare mʉare osome. ");
INSERT INTO des_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Eropirã mojomorocʉrãre itamurã, irire masare ii ĩhmubiricãque. Masa erã ĩabiro itamuque erãre. Gajirã iro dopa iibiricãque. Erã masa bajarã watope mojomorocʉrãre itamuma. Mague niguirã watope mari buheri wirigue árĩrã watope sãre ii ĩhmuma. Erã eropa iiquererã erã mari pʉrʉpʉpʉre ñero iicorerã ãhrima. Eropa masa watope õarire ii ĩhmurã erã, “Õarã ãhrima erã,” masare arĩdorerã iima. Erã eropa iirã masa umupeori mera wajatatuhama. Eropigʉ Goãmʉpʉ ne wajayesome erãre. ");
INSERT INTO des_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Eropirã mojomorocʉrãre itamurã, irire yayarogã iique. Mʉa wapi mera árĩquererã ta ĩgʉ ĩabiro irire iique. ");
INSERT INTO des_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Masa erã ĩabirogue mojomorocʉrãre itamuque. Masa ĩabirogue mʉa itamuquerecʉ̃ Goãmʉpʉ ĩhami. Eropigʉ mari Pagʉpʉ mʉare wajayegʉcumi, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Dipaturi ĩgʉ werenemopʉ: —Goãmʉre serẽrã, mari pʉrʉpʉ ñero iicorerã iiro dopa iibiricãque mʉa. Erã mari buheri wirigue nigui, mague sãre nigui, Goãmʉre serẽ ĩhmuma erã masare. Eropa serẽ ĩhmurã diaye masa erãre umupeori mera erã mucubirituhama. Eropigʉ Goãmʉ erãpʉre umupeosome. ");
INSERT INTO des_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉapʉ Goãmʉre serẽmorã mʉa ya taribugue biha ñajaque. Biha ñaja mari Pagʉ ĩasũya marigʉre serẽque. Mʉa eropa iicʉ̃ masa erã ĩabiro árĩquerecʉ̃ ta mari Pagʉpʉ mʉare ĩagʉcumi. Eropa peegʉ mʉare õaro iigʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Eropirã Goãmʉre serẽrã, pepiro mariro mʉa serẽrare ta dipaturi serẽ maji dujabiricãque. Eropa ta iima Goãmʉre masibirã. “Bajasuburi yuju disiro ta gʉa serẽcʉ̃ gʉare peegʉcumi,” arĩ pepima erã. ");
INSERT INTO des_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Erã iiro dopa iibiricãque. Mʉa serẽboro core mari Pagʉ mʉa gamerire masituhami. ");
INSERT INTO des_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Eropirã õpa arĩ serẽro gahmea Goãmʉre. Gʉa Pagʉ ʉmaro majagʉ mʉ õagʉ árĩrire árĩpehrerã umupeoporo. ");
INSERT INTO des_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dohpaguere árĩpehrerã weca opʉ árĩque. Ʉmaroguere mʉ dorero dopa ta erã iiro dopa ta i yeba majarã sã eropa iiporo. ");
INSERT INTO des_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Eropigʉ ʉmʉri nʉcʉ gʉa baburire oniguicãque gʉare. ");
INSERT INTO des_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gajirã gʉare erã ñero iirare gʉa cãdijiro dopa ta mʉ sã gʉa ñero iirare cãdijique. ");
INSERT INTO des_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Eropigʉ gʉa ñero iiborare cãhmotaque. Eropigʉ gʉare ñerire iibiricãcʉ̃ iique. Mʉhʉ gʉa Opʉ turagʉ eropa árĩniguigʉca. Árĩpehrerã mʉre eropa umupeoniguicãrãcoma, arĩ serẽque Goãmʉre, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Gajirãre mʉare erã ñero iirare mʉa cãdijicʉ̃ ĩagʉ, mari Pagʉ ʉmaro majagʉ mʉa ñero iira sãre cãdijigʉcumi. ");
INSERT INTO des_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gajirã mʉare erã ñero iirare mʉa cãdijibiricʉ̃ mari Pagʉ mʉa ñero iira sãre cãdijisome, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Eropigʉ ĩgʉ erãre werenemopʉ: —Goãmʉre umupeomorã ba duhurã bʉjawererã iro dopa ii ĩhmubiricãque. Eropa iima mari pʉrʉpʉ ñero iicorerã. Erã erã diaporire bʉjawererã iro dopa ãhrima. Erã eropárĩcʉ̃ erã ba duhucʉ̃ ĩha masima masa. Diaye ta mʉare arĩgʉ iiaa. Masa erãre umupeocʉ̃ gahmema erã. Eropirã erãre umupeocʉ̃ ĩarã mucubirituhama. Eropigʉ Goãmʉpʉ erãre õaro iisome. Eropirã erã iiro dopa ii ĩhmubiricãque mʉa. ");
INSERT INTO des_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mʉa sã ba duhurã mʉa árĩniguiro dopa ta árĩque. Mʉa ya dipure ʉyʉ mera sũcã õaro wʉapocãque. Mʉa diapori sãre coecãque. ");
INSERT INTO des_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mʉa eropa iicʉ̃ mʉa ba duhucʉ̃ ĩha masisome masapʉ. Goãmʉ dihta ĩha masigʉcumi. Mʉa seyaro mʉa árĩcʉ̃ ĩgʉpʉ mʉa mera ãhrimi. Eropa ĩagʉ ĩgʉ mʉare õaro iigʉcumi, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesu werenemopʉ daja: —I yeba majare aĩ gameneobiricãque. Õ maja boa waboca. Iri boabiricʉ̃ yajari masʉ aĩbocumi irire. Ĩgʉ yajabiricʉ̃ mega tʉabocoma. Eropiro i yeba maja dederema gʉhya ãhraa. Eropirã i yeba majare bʉrigã gamebiricãque. ");
INSERT INTO des_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ʉmaro majapʉre turaro gameque mʉa. Ʉmaro majare mega tʉamasibeama. Erogue mʉa opaburi ne boabeaa. Eroguere yajari masʉ ne aĩmasibeami. ");
INSERT INTO des_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Erogue mʉa opaburi iri árĩcʉ̃, ʉmaro majare Goãmʉ yare bʉrigã guñarãca mʉa, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Eropi buhegʉ õpa arĩ werenemopʉ erãre: —Mʉa cuiri mʉa dʉpʉre sihãgodiru iro dopa ta ãhraa, arĩ werediacʉ̃ õpa ãhraa. Mʉa pepiro dopa ta iiaa. Mʉa õaro mera pepirã árĩrã õarire iiaa. ");
INSERT INTO des_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mʉa ñerire pepirã árĩrã ñeri dihtare i mʉa. Ʉmaro majare mega tʉamiaa. Eropirã mʉa ñeri dihtare mʉa pepiniguicãcʉ̃ iri ñeripʉ ñetariari ãhraa, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Eropigʉ ĩgʉ erãre werenemopʉ: —Yujugʉ Goãmʉpʉre guñagʉ niyerupʉre guñabeami. Niyerupʉre bʉrigã guñagʉ Goãmʉpʉre guñabeami. Eropigʉ niyeru dihtare gamegʉ árĩgʉ Goãmʉre mucubiricʉ̃ iibeami. Goãmʉ sãre niyeru sãre peñere gametarimaja masiya mara mʉare, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Eropigʉ erãre werenemopʉ: —Eropigʉ mʉare ire arĩgʉ iiaa. Mʉa árĩricʉrire mʉa barire, ihririre, suhri sãre wʉaro guñaricʉbiricãque. Mʉare deyoro moagʉ bari dihtare bamorãre, suhri sañamorã dihtare Goãmʉ iibiripʉ mʉare. Mʉa iri dihtare guñacʉ̃ gamebeami. ");
INSERT INTO des_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mirimagʉ porãre Goãmʉ ĩgʉ ĩhadiburire masique mʉa. Erã poeri moorã ãhrima. Eropiro erã bari dihburi wiri erãre mara. Mari Pagʉpʉ erãre erã baburire ohomi. Mirimagʉ porã tauro mʉapʉre mahimi Goãmʉ. Eropigʉ mʉa sãre ĩhadibugʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wʉaro mʉa pepiri mera iri mʉare pagarã wacʉ̃ iibeaa. Eropiro mʉa wʉaro pepiri duhpiburi árĩbeaa. ");
INSERT INTO des_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Eropirã duhpirã mʉa suhri sañaburire wʉaro guña bʉjawere pepicãri? Nʉgʉ maja gori iri gorire pepique. Iri gori ne iiro mariro õari goricʉa. Iri gori õari suhri iro dopa õari gori dehyoaa. ");
INSERT INTO des_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Salomo opʉ mʉrʉ õari suhri opagʉ ĩgʉ árĩquerecʉ̃ ta iri goripʉ ĩgʉ ya suhri tauro õari gori ãhraa. ");
INSERT INTO des_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iri gorire õari gori iimi Goãmʉpʉ. Iri gori bajamenʉrigã árĩra pʉhrʉ ñaidija pehrea wahaa. Mero ãhri, gajinʉ peamegue soe cóãcãma. Iri eropa mata pehrequerecʉ̃ ta iri gori iri õari gori árĩcʉ̃ iimi Goãmʉ. Eropigʉ Goãmʉ iri gorire ĩgʉ õari gori ĩgʉ iidiro tauro mʉa sãre õaro iigʉcumi. Suhrire ogʉcumi. Goãmʉre daberogã umupeoa mʉa. ");
INSERT INTO des_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eropirã mʉa baburire, mʉa ihriburire, mʉa suhri sañaburire wʉaro guñabiricãque. ");
INSERT INTO des_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Goãmʉre masibirãpʉ irire eropa amaniguicãma. Mari Pagʉ ʉmaro majagʉ árĩpehreri mʉa gamerire masimi. Ĩgʉ eropa masicʉ̃ mʉa ya árĩburire wʉaro guñabiricãque. ");
INSERT INTO des_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Goãmʉ mʉa Opʉ ĩgʉ árĩborore gamemʉhtaque mʉa. Mʉa eropa iira pʉhrʉ Goãmʉpʉ mʉa gameri dʉhyacʉ̃ ogʉcumi. ");
INSERT INTO des_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Eropirã ñamigãre mʉa dohpa warocuri arĩ wʉaro bʉjawere ne pepibiricãque. Dohpagãre mʉa ñero tariboro árĩtuhaa. Eropirã dohpagã maja dihtare pepique. Gajinʉ majare wʉaro bʉjawere pepinemobiricãque. Goãmʉpʉ mʉare itamugʉcumi, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Eropigʉ ĩgʉ erãre werenemopʉ: —Gajirãre “Ñerã ãhrima,” arĩ erã iirare werewʉabiricãque mʉa. Mʉa eropa arĩ werewʉabiricʉ̃ Goãmʉ mʉa sãre “Ñerã ãhrima,” arĩsome. ");
INSERT INTO des_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gajirãre “Õaro iibeama,” mʉa arĩ pepidiro dopa ta Goãmʉpʉ mʉa sãre eropa ta arĩ ĩagʉcumi. Mʉa gajirãre beyero dopa Goãmʉpʉ mʉa sãre eropa ta beyegʉcumi. ");
INSERT INTO des_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mari werenigui queori mera buhecʉ̃ õpa iirã ãhraa mʉa. Mʉa acaweregʉ ĩgʉ cuirugue miri pogañegã mehñajacʉ̃ iri pogañegãre õaro ĩhaa mʉa. Mʉa ya cuiripʉre wʉarimiji árĩquerecʉ̃ ta irimijire ne pepibeaa mʉa. Eropirã gajigʉre miri pogañegãre mʉa ĩaro dopa ta mʉa acaweregʉ ĩgʉ ñero iiripʉre õaro ĩhaa mʉa. Mʉa basi turaro ñerire iiquererã ta irire eropa pepicãa mʉa. ¿Dohpa árĩronore eropa ãhriri mʉa? ");
INSERT INTO des_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Õpa arĩ wereniguia mʉa acawererãre: “Acaweregʉ, ñerire iigʉ iica mʉhʉ. Eropigʉ irire duhucãque,” arĩ wereniguia mʉa. Eropa ĩgʉre ñerire iidorebiriquererã mʉa sã ñerire duhubeaa. ¿Duhpirã irire ñerire iinirã árĩquererã ta irire pee masibeari mʉa? ");
INSERT INTO des_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eropa iirã masa erã pʉrʉpʉre ñero iicorerã ãhraa mʉa. Mʉa ñero iiripʉre duhumʉhtaque. Mʉa eropa iira pʉhrʉ mʉa acawererãre “Mʉa ñero iirire duhucãque,” arĩ weremasia mʉa. ");
INSERT INTO des_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Diayea iro dopa árĩrãre ñetariarãre Goãmʉ ya õatariarire erã umupeobiririre werebiricãque erãre. “Erãgue ñero wereya ñero arĩri,” arĩrã werebiricãque erãre, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Eropigʉ ĩgʉ erãre werenemopʉ: —Goãmʉre mari Pagʉre serẽque mʉa. Mʉa eropa serẽrã mʉa aĩrãca. Mʉa serẽrire bocarãca. Goãmʉre eropa serẽniguicãque mʉa. Mʉa eropa iicʉ̃ ĩgʉ mʉare ogʉcumi. ");
INSERT INTO des_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Árĩpehrerã Goãmʉre serẽrã aĩrãcoma. Eropirã erã serẽrare bocarãcoma. Eropigʉ árĩpehrerã Goãmʉre eropa serẽ­niguicãrãre ĩgʉ erãre ogʉcumi. ");
INSERT INTO des_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Mʉa porã barire mʉare serẽcʉ̃ ʉtãyepʉre obocuri mʉa erãre? Obiriboya. ");
INSERT INTO des_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Mʉa porã waire mʉare serẽcʉ̃ añapʉre obocuri mʉa erãre? Obiriboya mʉa. ");
INSERT INTO des_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʉa ñerã árĩquererã ta mʉa porãre õarire omasia mʉa. Eropigʉ mari Pagʉ mʉa tauro õarire ohomi mʉare ĩgʉ porãre ĩgʉre mʉa serẽrire. ");
INSERT INTO des_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gajirã mʉare õaro iicʉ̃ gahmea mʉa. Erãre mʉa õaro iicʉ̃ gamero dopa ta õaro iique erã sãre. Erã õaro iibiriquerecʉ̃ ta mʉapʉ erãre õaro iique. Eropa ta iidorea Moise dorerigue, Goãmʉ yare weremʉhtanirã erã gojarague sã, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Eropigʉ ĩgʉ queorire werenemopʉ erãre õpa arĩgʉ: —Goãmʉ pohrogue wadiarã ĩgʉ yare iiro gahmea mʉare. Eropirã ĩgʉ yare eropa iimaabiricãro gahmea. Miri disiporogãgue mʉa wadiacʉ̃ diasa ãhraa. Eropiro diasa ãhraa Goãmʉ pohrogue mʉa wadiacʉ̃. Peamegue masa erã wacʉ̃ diasabeaa. Wʉari disiporogue mari ñajacʉ̃ diasabeaa. Iri disiporogue ta masa erã ñajaboro dopa ta peamegue masa erã wacʉ̃ diasabeaa. Eropirã masa bajarã erogue warã iima. ");
INSERT INTO des_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Goãmʉ pohrogue wadiacʉ̃ diasa ãhraa. Bajamerãgã masa erogue warãcoma. Erogue warã ʉmʉri nʉcʉ Goãmʉ mera árĩniguirãcoma, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Eropigʉ ĩgʉ werenemopʉ erãre: —Õaro pee masique. “Goãmʉ yare weremʉhtarã ãhraa,” arĩ gʉyarãre peebiricãque mʉa. Erã õarire iirã iro dopa aririma mʉa pohrogue. Erã pepirigue ñerã ãhrima erã. ");
INSERT INTO des_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Erã ñero iicʉ̃ ĩarã ñerã erã árĩcʉ̃ masirãca mʉa. Erã õaro iicʉ̃ ĩarã, õarã erã árĩcʉ̃ masirãca mʉa. Aña poragʉ dipatõrire dʉcacʉbeaa. Poracʉdigʉ sã higuera dipure dʉcacʉbeaa. ");
INSERT INTO des_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Õadigʉ yucʉgʉ õarire dʉcacʉa. Ñedigʉpʉ ñerire dʉcacʉa. ");
INSERT INTO des_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yucʉgʉ õadigʉ ñerire ne dʉcacʉmasibirica. Eropiro ñedigʉ sã õarire dʉcacʉmasibirica. ");
INSERT INTO des_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Õarire dʉcacʉbiriri yucʉre pa cóãcã, peamegue soecãma. Eropa ta iigʉcumi Goãmʉ ĩgʉ gamerire iibirãre. ");
INSERT INTO des_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eropirã “Goãmʉ yare weremʉhtarã ãhraa,” arĩrã erã gʉyacʉ̃ õpa masirãca. Erã iiricʉrire ĩaque. Erã õarire iirã árĩcʉ̃ ĩha “Goãmʉ ya wereniguirã ta ãhrima,” arĩ ĩha masirãca. Erã ñerire iirã árĩcʉ̃ ĩha “Goãmʉ ya wereniguirã árĩbeama. Eropirã gʉyarã ãhrima,” arĩ ĩha masirãca, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Eropigʉ ĩgʉ erãre werenemopʉ: —Bajarã yʉre “Yʉ tĩgʉ,” arĩrã árĩquererã ta ʉmaro majagʉ Goãmʉ ĩgʉ árĩroguere wasome erã. Yʉ Pagʉ ʉmaro majagʉ ĩgʉ gamerire iirã dihta ĩgʉ opʉ árĩrogue warãcoma. ");
INSERT INTO des_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pehrerinʉ árĩcʉ̃ bajarã masa õpa arĩrãcoma yʉre: “Gʉa tĩgʉ, mʉ yare gʉa buheabʉ. Mʉ waĩ mera pũririre, watẽare cóãbʉ. Eropirã mʉ turari mera baja deyoro moarire iiabʉ gʉa,” yʉre arĩrãcoma. ");
INSERT INTO des_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Erã eropa arĩquerecʉ̃ õpa arĩ yʉhrigʉca erãre: “Mʉare ne masibeaa. Ñerire iirã ãhraa mʉa. Yʉ pohro aribiricãque,” arĩgʉca yʉhʉ erãre. Eropirã Goãmʉ gamerire iique yʉ pohro aridiarã, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Eropigʉ queori mera werepʉ Jesu erãre buhegʉ: —Eropi árĩpehrerã i yʉ wereniguirire peenirã yʉ dorerire iirã, õaro pee masigʉ wihi iidigʉ iro dopa ãhrima erã. Ĩgʉ ʉ̃hcãri goberire seha, wihire nugunʉgapʉ. ");
INSERT INTO des_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ĩgʉ wihire ĩgʉ tuhajara pʉhrʉ deco bʉrigã ahri, dia miritaria wayoro. Miruñe bʉrigã weãyoro. Eropa waquerecʉ̃ ta iri wihi ʉ̃hcãro ĩgʉ nugura wihi árĩro ne mihrua dijabiriyoro. ");
INSERT INTO des_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Eropirã árĩpehrerã yʉ wereniguirire peenirã árĩquererã ta yʉ dorerire iibirãpʉ pee masibigʉ ĩgʉ wihi iigʉ iro dopa ãhrima. Ĩgʉpʉ ĩgʉ wihire dia tʉro maja imiporo weca nugu, õaro iibiripʉ. ");
INSERT INTO des_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ĩgʉ wihire tuhajara pʉhrʉ, deco bʉrigã ahri, dia miritaria waha, miruñe bʉrigã weãyoro. Eropa weãro iri wihire weã mehpicãyoro, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Ĩgʉ eropa arĩ buhecʉ̃ peerã, peemaria wañorã masa. “Ĩgʉ marire opʉ ĩgʉ buhero dopa ta buhemi ĩgʉ. Marire buherã iro dopa buhebeami,” arĩ pepiñorã erã. ");
INSERT INTO des_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu ʉtãgʉgue buhe doadigʉ dijaa wapʉ. Ĩgʉ dijacʉ̃ ĩarã masa bajarã ĩgʉre nʉrʉsiañorã. ");
INSERT INTO des_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ero ĩgʉ wadiro yujugʉ cami boagʉ mague ĩgʉre nʉrʉsiaja eja, mereja, ĩgʉre serẽpʉ. —Gʉa tĩgʉ, mʉhʉ yʉre õagʉ iidiagʉ iique, arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ĩgʉ eroparĩcʉ̃ peegʉ ĩgʉ mojoto mera Jesu ĩgʉre mohmepipʉ. —Áʉ, mʉre õagʉ wacʉ̃ iiaa, arĩpʉ Jesu ĩgʉre. Ĩgʉ eroparĩcʉ̃ ta iri cami boara yarima wayoro. ");
INSERT INTO des_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Eropa iituhaja Jesu ĩgʉre arĩpʉ daja: —Yʉhʉ mʉre õpa iirare ne gajirãre werebiricãque. Mʉ ya dʉpʉre õarare pahire ĩhmugʉ waque, “Õaro ãhrimi,” arĩdoregʉ. Tuhajanugu Moise dorerire Goãmʉ ĩgʉ apidiro dopa ta iique. Eropigʉ Goãmʉ ya wihigue mirimagʉre asũ wahgã apique mʉ dore tarirare masa árĩpehrerã erã masimaja õaro, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ero pʉhrʉ Jesu Capernaum waĩcʉri macague ĩgʉ ejacʉ̃ surara opʉ ĩgʉ pohro eja, ĩgʉre turaro õpa arĩ serẽpʉ: ");
INSERT INTO des_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Gʉa tĩgʉ, yʉ pohro majagʉ ne bʉhari mera dorecʉgʉ wamasibirinijagʉ, ĩgʉre bʉrigã pũricʉ̃ pepigʉ yaha wihigue oyacumi ĩgʉ, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ĩgʉ eroparĩcʉ̃ pee: —Áʉ, arĩ, ĩgʉre ĩgʉ dorecʉrire taugʉ wagʉra, arĩpʉ Jesu. Ĩgʉ eroparĩcʉ̃ õpa arĩpʉ surara opʉ: ");
INSERT INTO des_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","—Opʉ, õaroca. Aribita. Ñegʉ ãhraa yʉhʉ. Yaha wihire mʉre ñajaridorebuno árĩbeaa yʉhʉ. Yuju diaye ta mʉ turari mera dorebeoque. Mʉ eropa iicʉ̃ yʉ pohro majagʉ õagʉ wagʉcumi. Yʉre yʉ weca árĩrã gajirã oparã dorema. Yʉ sã surarapʉre dorea. Yujugʉre “Waque,” yʉ arĩcʉ̃ ĩgʉ wahami. Gajigʉre “Arique,” yʉ arĩcʉ̃ ahrimi. Yʉ pohro majagʉre “Ire iique,” yʉ arĩcʉ̃ irire iimi. Eropigʉ mʉ ĩgʉre mʉ dorero dopa ta ĩgʉ dorecʉgʉ tarigʉcumi, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesu ĩgʉ eroparĩcʉ̃ pee ʉca wa bajarã masa ĩgʉ mera nʉrʉsiarãre õpa arĩpʉ: —Diaye ta mʉare arĩgʉ iiaa. Ihĩ surara opʉ Israe masʉ árĩbiriqueregʉ Goãmʉre bʉrigã umupeomi. Ĩgʉ pohro majagʉre yʉ õagʉ wacʉ̃ iiburire masituhami. Ne Israe masare ihĩ iro dopa umupeorãre ĩanibeaa. ");
INSERT INTO des_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mʉare arĩgʉ iiaa. Bajarã ihĩ iro dopa árĩrã árĩpehrero majarã ʉmaro majagʉ ĩgʉ opʉ árĩrogue eja, erogue árĩrã mera barãcoma. Mʉa ñecʉ sʉmarã mʉra Abrahã, Isaa, Jacobo mera barãcoma erã. ");
INSERT INTO des_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Masa gajirãpʉ “Opʉ ĩgʉ árĩrogue wamorã ãhraa gʉa,” erã arĩquerecʉ̃ ta ñerogue naitĩarogue cóãgãgʉcumi erãre. Erogue ĩgʉ cóãnirã bʉrigã ore, bʉjawereri mera erã gʉcʉrire cũridihurãcoma, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Irire eropa arĩtuhaja surara opʉre arĩpʉ: —Dujaaque mʉ ya wihigue. Mʉ pohro majagʉ tarigʉcumi. “Diaye ta tarigʉcumi,” arĩ mʉ pepidiro dopa ta tarigʉcumi, arĩpʉ Jesu. Ĩgʉ eroparĩcʉ̃ ta ĩgʉ pohro majagʉ pʉ õha wapʉ. ");
INSERT INTO des_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pʉhrʉ Jesu Pedro ya wihigue eja, Pedro mʉñeco dorecʉcʉ̃ ĩapʉ ĩgʉ. Nimacʉri árĩcʉ̃ oyapo igo. ");
INSERT INTO des_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Igo eropa dorecʉcʉ̃ ĩanijagʉ igo mojotore mohmepipʉ. Ĩgʉ eropa mohmepicʉ̃ ta nimacʉri taria wayoro. Taricʉ̃ pepigo igopʉ wahgã, erãre barire ejopo. ");
INSERT INTO des_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Eropi ñamicague bajarã watẽa ñajasũnirãre masa aĩ ejañorã Jesu pohrogue. Erã eropa aĩ ejacʉ̃ ĩagʉ mata ĩgʉ watẽare cóãcʉ̃ masa õha wañorã. Eropigʉ árĩpehrerãre dorecʉrãre erã aĩ ejanirãre taupehocãpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Eropa ta iipʉ ĩgʉ iribojegue majagʉ Goãmʉ yare weremʉhtadigʉ Isaia ĩgʉ arĩdiro dopa ta. Õpa arĩ gojañumi: “Mari dorecʉrire taucãmi ĩgʉ. Marire pũririre cohãmi ĩgʉ,” arĩ gojañumi Isaia Jesu ariboro coregue. ");
INSERT INTO des_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesu masa bajarã ĩgʉ pohro árĩcʉ̃ ĩagʉ, —Wʉariya gajipʉ masegue ina taribujarã, arĩpʉ ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Erã taribujaboro core judio masare buhegʉ Jesu pohrogue eja, õpa arĩpʉ: —Buhegʉ, mʉ mera wadiaa noho mʉ waro, arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu õpa arĩ yʉhripʉ: —Yʉ mera árĩcʉ̃ diasa ãhraa. Nʉgʉ majarã diayea erã carĩburi toreri opama. Mirimagʉ porã sã erã ya suhri opama. Yʉpʉre Goãmʉ ĩgʉ obeodigʉpʉre ne yaha wihi mara. Eropirã yʉ mera árĩrã ñero tarirãca mʉa, arĩ yʉhripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Eropi gajigʉ Jesu buhegʉ õpa arĩpʉ: —Gʉa opʉ, yʉ pagʉ ĩgʉ sĩricʉ̃ yaatuhajagʉ mʉ mera wagʉra, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesu yʉhripʉ: —Yʉre gamebirã sĩrinirã iro dopa ta ãhrima. Erãpʉ sĩrinirãre yaaporo. Eropigʉ mʉpʉ yʉ mera majagʉ árĩbu arique dohparagã, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Eropa arĩtuhaja dohodirugue ñajapʉ. Eropirã ĩgʉ buherã sã ĩgʉ mera waha ñajañorã. ");
INSERT INTO des_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ero erã taribujarisubu iriyague miruñe bʉrigã ariyoro. Eropiro pãgúri dohodirure miucãriyoro. Eropa miruñe weãquerecʉ̃ ta Jesupʉ carĩgʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eropa wacʉ̃ ĩarã erã ĩgʉre wahgũñorã. Wahgũ õpa arĩñorã: —Opʉ, mirimorã iica mari. Miruñere tauque, arĩñorã. ");
INSERT INTO des_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —¿Duhpirã güimaacãri mʉa? Yʉre merogã umupeorã ãhraa mʉa, arĩpʉ Jesu erãre. Eropa arĩgʉ ta wahgãnʉgaja miruñere pãgúri sãre “Yʉsʉque,” arĩpʉ. Ĩgʉ eroparĩcʉ̃ miruñe, pãgúri sã yʉsʉdijapehrea wayoro. ");
INSERT INTO des_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ĩgʉ eropa iicʉ̃ ĩha ʉca, õpa arĩ wereniguiñorã erã basi. —¿Ñehmʉno masʉ ãhriri ihĩ? I miruñe, pãgúri sã yʉhrisũgʉ ãhrimi, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Erãre eropa wara pʉhrʉ taribujaja, Gerasa majarã ya yebague ejapʉ. Erogue erã ejacʉ̃ perã ʉma Jesure bocatĩriñorã. Masa goberi watopegue árĩnirã árĩñorã. Erã watẽa ñajasũnirã árĩrã gorowererã gʉhyarã árĩñorã. Eropirã erogue masa ne wabiriñorã. ");
INSERT INTO des_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ĩgʉre bocatĩri õpa arĩ gaguiniguiñorã: —¿Mʉhʉ Goãmʉ magʉ duhpibu ahriri mʉhʉ gʉa pohroguere? ¿Gʉare Goãmʉ dorero ejabiriquerecʉ̃ ta dipuwaja moagʉ ahriri mʉhʉ? arĩ gaguiniguiñorã erã watẽa mera. ");
INSERT INTO des_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ero pohro bajarã yesea ahma barã iiñorã. ");
INSERT INTO des_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Erãre ĩanijarã, watẽapʉ õpa arĩ bʉrigã serẽñorã Jesure: —Gʉare oã ʉmare cóãgʉ soã yesea pohrogue wadoreque gʉare. Erã mera gʉare árĩdoreque, arĩ serẽñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Áʉ, waque, arĩpʉ Jesu. Ĩgʉ eroparĩcʉ̃ watẽa perã masa mera árĩnirã waha, yesea pohrogue ejañorã. Erãre ñajacʉ̃ ta yesea gorowere, dipatʉrʉgue oma buha, wʉariyague yuriñaja yuhria, miri sĩripehrea wañorã. ");
INSERT INTO des_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Erã eropa wacʉ̃ ĩarã yeseare ĩhadiburãpʉ güi, omagã wañorã. Macague eja yesea erã mirirare weresiripehocãñorã erã. Watẽa erã ñajasũnirãre Jesu ĩgʉ cóãra sãre werepehocãñorã erã. ");
INSERT INTO des_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Erã eropa weresirira pʉhrʉ iri maca majarã árĩpehrerã Jesure ĩarã ejañorã. Eropirã ĩgʉre ĩara pʉhrʉ turaro mera wiriadoreñorã ĩgʉre erã ya yebare. ");
INSERT INTO des_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Erã eropa wadorera pʉhrʉ Jesu dohodirugue ñaja, wʉariyague taribujaa, ĩgʉ ya macague ejapʉ. ");
INSERT INTO des_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Erogue gajirã dʉpʉ bʉhadigʉre pũgʉ mera coã aĩ wahgã erañorã Jesu pohro. “Jesu ĩre ĩgʉ dorecʉrire taricʉ̃ iigʉcumi,” arĩ pepiñorã erã. Erã eropa arĩ pepicʉ̃ masigʉ Jesu dorecʉgʉre õpa arĩpʉ: —Mucubirique mʉhʉ. Mʉ ñero iirare cóãtuhabʉ yʉhʉ, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ĩgʉ eroparĩcʉ̃ peerã yujurãyeri masare buherã õpa arĩ pepiriñorã erã basi: “Ihĩ eropa arĩ ĩgʉ wereniguiri mera Goãmʉre ñero arĩgʉ iimi,” arĩ pepiñorã erã buherã. ");
INSERT INTO des_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Erã eropa arĩ pepicʉ̃ masigʉ, õpa arĩpʉ Jesupʉ: —¿Duhpirã eropa arĩ ñero pepiri mʉa? ");
INSERT INTO des_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Mʉ ñero iirare cóãbʉ,” yʉ arĩcʉ̃ “Gʉyagʉ ãhrimi,” arãa mʉa masibiriquererã ta. Ĩgʉre “Wahgãnʉgajaque. Curique,” yʉ arĩcʉ̃ yʉ arĩra diaye árĩri árĩcʉ̃ mata mʉa ĩha masirãca. ");
INSERT INTO des_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ i yeba majarã erã ñero iirire cóãmasia yʉhʉ. Mʉa ire masiborore õpa ta ĩgʉ wahgãnʉgacʉ̃ iigʉra, arĩpʉ Jesu. Eropa arĩtuhaja dʉpʉ bʉhadigʉre õpa arĩpʉ: —Wahgãnʉgajaque. Mʉ pũgʉre aĩ, mʉ ya wihigue dujaaque, arĩpʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ĩgʉ eroparĩcʉ̃ ta peegʉ dʉpʉ bʉhadigʉ wahgãnʉgaja, ĩgʉ ya wihigue dujaa wapʉ. ");
INSERT INTO des_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Masa ĩgʉ eropa wacʉ̃ ĩarã güiñorã. Eropirã Jesure Goãmʉ ĩgʉ turarire opacʉ̃ ĩarã Goãmʉre umupeo, õaro wereniguiñorã. ");
INSERT INTO des_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Erã eropa iira pʉhrʉ Jesu erogue árĩdigʉ wiria, yʉre Mateore bocatĩrimi. Oparã ya árĩburire masare wajasea coregʉ árĩribʉ. Eropigʉ irisubure yʉ mohmeri taribugue doabʉ. Ero yʉ doacʉ̃ ĩagʉ, õpa arĩmi yʉre: —Yʉ mera majagʉ árĩbu arique, arĩmi yʉre Jesu. Ĩgʉ eroparĩcʉ̃ pee, wahgãnʉgaja ĩgʉ mera wabʉ. ");
INSERT INTO des_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pʉhrʉ yaha wihigue Jesu sã barã erama. Bajarã wajasea corerã “ñero iirã” erã arĩrã gʉa mera ta bama. ");
INSERT INTO des_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Erã mera gʉa bacʉ̃ ĩarã, fariseo masa Jesu buherãre õpa arĩma: —¿Duhpigʉ mʉare buhegʉ wajasea corerã ñero iirã mera bahari? arĩma erã gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Erã eroparĩcʉ̃ peegʉ Jesupʉ õpa queori mera yʉhrimi: —Dorecʉbirã duhturure amabeama. Dorecʉrã dihta duhturure ahmama. Dorecʉrã duhturu amaro dopa ta “Ñerã ãhraa,” arĩrã yʉre amarãcoma. Eropigʉ “Ñerã ãhraa,” arĩrã dihtare erã ñero iirare bʉjaweredore õaripʉre gohrotocʉ̃ iigʉ aribʉ yʉhʉ. Erã basi “Õarã ãhraa gʉa,” arĩ pepirãre itamugʉ aribiribʉ. Goãmʉ ĩgʉ arĩrare erã arĩ gojarare masique mʉa. “Waimʉrãre wejẽ soemujurã yʉre eropa umupeocʉ̃ ne gamebeaa. Gajirãre mʉa mojomoro ĩacʉ̃pʉre gahmea,” arĩmi Goãmʉ, arĩ gojañumi. I eropa arĩrire masique mʉa. Irire õaro buhenemorã waque, arĩmi Jesu fariseo masare. ");
INSERT INTO des_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pʉhrʉ Ñu waĩyegʉ ĩgʉ buherã gʉa pohro eja Jesure serẽpima: —Gʉa Ñu buherãpʉ bajasuburi Goãmʉ ya árĩburire iirã ba duhua. Fariseo masa sã eropa ta ba duhuma. ¿Duhpirã mʉ buherãpʉ ba duhubeari? arĩma erã Jesure. ");
INSERT INTO des_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu erãre õpa arĩ yʉhrimi: —Õpa ãhraa iri: Mojoto diridigʉ ĩgʉ bosenʉ iicʉ̃ ĩgʉ mera majarã bʉjawererã ba duhurã árĩbeama. Ĩgʉ mera árĩrã mucubiri barã iima. Eropa ta yʉ buherã sã yʉ mera árĩrã ba duhumasibeama. Yujunʉ yʉre Goãmʉ aĩcãgʉcumi. Eropa ĩgʉ yʉre aĩra pʉhrʉ yʉ buherã mera árĩsome yʉhʉ. Irisubugue ta yʉ buherã ba duhurãcoma, arĩ yʉhrimi Jesu. ");
INSERT INTO des_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Erã iribojegue maja buheri mama buheri mera erã peñe buhemorediacʉ̃ ĩagʉ õpa arĩ werenemomi Jesu erãre: —Ne mama gasiro suhri gasiro mera mʉrañe suhrirore seretu masiya mara. Eropa seretura pʉhrʉ mama gasiro mari coecʉ̃ mʉra suhriro árĩro yehguea wa daja, tara gameneo, wʉatariaro yehgueacʉ̃ iiaa. Eropa ta mʉra buheri mama buheri mera wapi moa buhebiricãro gahmea. ");
INSERT INTO des_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Eropirã ne igui deco imisĩri decore waibʉgʉ gasiro ajuro mʉra ajuro mera diyebiricãro gahmea. Eropiicʉ̃ igui deco imisĩri pahmura pʉhrʉ mʉra ajurore yeguedija wahaa. Iri ajuro yehguecʉ̃ igui deco sã, ajuro sã cohmoa wahaa. Eropirã igui deco waibʉgʉ gasiro mama ajuro mera diyero gahmea. Eropiicʉ̃ igui deco pahmuro õaro iri ajuro sẽraa. Eropa ta mama buheri mʉra buheri mera buhebiricãro gahmea, arĩ weremi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ĩgʉ eropa arĩ wererisubu gʉa judio masa buheri wihi opʉ Jesu pohrogue erami. Eraa, mereja, õpa arĩmi: —Yʉ mago negãgue sĩria wahámo. Igore mʉ mojotore duhpeogʉ arique. Mʉ eropa iicʉ̃ masagocumo, arĩmi ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu wahgãnʉgaja, ĩgʉ mera wami. Gʉa ĩgʉ buherã sã ĩgʉ mera wabʉ. ");
INSERT INTO des_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Gʉa erogue waniguicʉ̃ ero nomeo Jesu pʉrʉpʉ eja, ĩgʉ suhriro ojogorore mohmepiñamo. Doce bojori gohra ʉmʉri nʉcʉ behreniguigo árĩpo. ");
INSERT INTO des_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Õpa arĩ pepipo igo eropa iigo: “Ĩgʉ suhriro dihtare mohmepiñago õago dujagoca yʉhʉ,” arĩ pepipo igo. Eropigo igo mohmepicʉ̃ mata igo di wirira purumujuyoro. ");
INSERT INTO des_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Igo eropa iicʉ̃ masigʉ Jesu majinʉgaja, igore arĩmi: —Mucubirique mʉhʉ. Mʉhʉ yʉre umupeori mera õago dujaa, arĩmi ĩgʉ. Ĩgʉ eroparĩcʉ̃ ta õha wamo igo. ");
INSERT INTO des_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Eropa iituhaja Jesu gʉa mera opʉ ya wihigue ejami sĩridigo pohro. Ñajajagʉ bajarã masa i wihigue árĩrã turaro bʉsʉcʉ̃ ĩami. Gajirã ñehamere orerãre gaguiniguirãre ĩami. Gajirã igogãre yaaboro core tarisu iro dopa árĩrire purirãre ĩami. ");
INSERT INTO des_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Erã eropa iicʉ̃ ĩagʉ masare õpa arĩmi: —Wiriaque mʉa. Sĩribeamo igo. Carĩgo iimo, arĩmi erãre. Ĩgʉ eroparĩcʉ̃ peerã, “Eroparĩcãgʉ iimi ihĩ,” arĩrã masa ĩayema ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ĩgʉpʉ erãre disiporogue wiupehocãmi. Tuhajanugu sĩridigo pohrogue eja, igo mojotore ñeapʉ. Ĩgʉ eropa ñeañacʉ̃ ta masa bejaja, wahgãnʉgajapo igo. ");
INSERT INTO des_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ĩgʉ eropa iirare peerã, ero majarã masa árĩpehrerã masa werewʉañorã. ");
INSERT INTO des_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ero árĩnirã gʉa Jesu mera wacʉ̃, perã cuiri ĩhajabirã ĩgʉre piyu nʉrʉsiama: —Opʉ Davi pãrami masare taugʉ, gʉare mojomoro ĩaque mʉhʉ, arĩ gaguiniguima erã. ");
INSERT INTO des_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Erã eroparĩcʉ̃ Jesu gaji wihigue ñajami. Ĩgʉ eropa ñajacʉ̃ masirã cuiri ĩhajabirã ĩgʉ pohrogue ñaja wama. Erã eropa ñajacʉ̃ ĩagʉ ĩgʉpʉ erãre serẽpimi: —¿Marire ĩacʉ̃ iigʉcumi ĩgʉ, arĩ pepiri mʉa yʉre? arĩmi ĩgʉ. —Opʉ, eropa ta arĩ pepia gʉa, arĩ yʉhrima erã. ");
INSERT INTO des_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Erã eropa yʉhricʉ̃ ta erã cuirire ñapeomi. Ñapeogʉ, õpa arĩmi: —Yʉre “Eropa iigʉcumi,” mʉa arĩ pepidiro dopa ta eropa ta iigʉra, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ĩgʉ eroparĩcʉ̃ ta erã cuiri õha wabʉ. Eropi Jesu õpa arĩmi erãre: —I yʉ õpa iirare gajirãre ne werebiricãque, arĩrimi Jesu. ");
INSERT INTO des_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ĩgʉ eropa arĩquerecʉ̃ ta waha, i yeba majarãre weresirinirã árĩma ĩgʉ eropa iirare erã. ");
INSERT INTO des_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Iri wihire erã cuiri õha wanirã wiriarisubu gohra yujugʉ wereniguimasibigʉre aĩgãrima Jesu pohro masa. Watĩ ĩgʉre ñajasũdigʉ ĩgʉre wereniguimasibiricʉ̃ iidi árĩmi. ");
INSERT INTO des_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Erã aĩ ejacʉ̃ ĩagʉ watĩre Jesu cóãmi. Ĩgʉ eropa watĩre cóãcʉ̃ wereniguimasibiridigʉpʉ wereniguia wami. Ĩgʉ eropa iicʉ̃ ĩarã árĩpehrerã ĩhamaria wama. —Ne i yeba Israe yebaguere õpa iirãre ĩabirimʉrabʉ mari, arĩ wereniguima masa erã basi. ");
INSERT INTO des_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo masa gajiropa arĩ wereniguima: —Watẽa opʉ ĩgʉ turari mera watẽare cohãmi ihĩ, arĩ wereniguima erã. ");
INSERT INTO des_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Eropi árĩpehreri macari ero árĩri macarire, paga macari sãre buhe curigʉ wami Jesu gʉa mera. Õari buherire erã buheri wirigue buhegʉ wami ĩgʉ. Eropigʉ Goãmʉ ĩgʉ opʉ árĩborore weremi. Árĩpehreri dorecʉri sãre ero majarãre taumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Erã masa bajarã ñero tarirã, itamuri moorã, oveja dibuya marirã iro dopa erã árĩcʉ̃ ĩapʉ Jesu erãre. Eropa ĩagʉ Jesu erãre mojomoro ĩami. ");
INSERT INTO des_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eropigʉ õpa arĩmi ĩgʉ gʉare ĩgʉ buherãre: —Ojodʉca baja iri bʉgatuhajacʉ̃ baja árĩcʉ̃ mohmeri wʉaro ãhraa. Mohmeri masapʉ bajamerãgã ãhrima. Eropa ta õari buherire peemorã bajarã árĩcʉ̃ wʉaro ãhraa mari mohmeri. Iri eropa árĩquerecʉ̃ ta mari masare buhemorã bajamerãgã ãhraa. ");
INSERT INTO des_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eropirã õari buherire buhemorãre gajirãre ĩgʉ obeomorãre serẽque Goãmʉre mʉa, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pʉhrʉ doce gʉare ĩgʉ buherãre Jesu sihubeo, turarire omi gʉare. Watẽare gʉa cóãmasiburire, árĩpehreri dorere gʉa taumasiburire omi gʉare. ");
INSERT INTO des_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Õpa waĩcʉrã árĩbʉ gʉa Jesu ĩgʉ apinirã: Simo árĩmi. Ĩgʉre ta Pedro arĩ piyumi Jesu. Simo pagʉ magʉ Andre árĩmi. Santiago ĩgʉ pagʉ magʉ Ñu mera árĩmi. Erã pagʉ Zebedeo waĩcʉmi. ");
INSERT INTO des_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Toma, yʉhʉ Mateo árĩbʉ gʉa. Yʉpʉ oparã ya árĩburire masare wajaseabasa coredigʉ árĩribʉ. Gʉa mera gajigʉ Santiago árĩmi. Ĩgʉ Alfeo magʉ árĩmi. Eropigʉ Lebéo sã árĩmi. Ĩgʉpʉ Tadeo erã arĩ piyudigʉ árĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo celote ya curu majagʉ, Juda Iscariote sã árĩma. Judapʉ Jesure ĩhaturirãre ĩhmubu árĩmi. ");
INSERT INTO des_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Eropi gʉare ĩgʉ buherãre docere obeogʉ, “Õpa iique,” arĩ wereseremi gʉare: —Judio masa árĩbirã pohroguere wabiricãque. Ne Samaria yeba maja macarigue sãre wabiricãque. ");
INSERT INTO des_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israe yeba majarã pohroguepʉre waque. Goãmʉre masibirã ãhrima erã. ");
INSERT INTO des_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Ʉmaro majagʉ opʉ árĩboro merogã dʉhyaa,” arĩ buheque erãre. ");
INSERT INTO des_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Eropirã cami boarãre, gaji baja gajiropa árĩri dore oparã sãre õarã wacʉ̃ iique. Sĩrinirãre masuque. Watẽa ñajasũnirãre cohã wiuque erã watẽare. Mʉare iri turarire ogʉ iiaa. Eropirã mʉa sã yʉ eropa odiro dopa ta masare wajasearo mariro õarã wacʉ̃ eropa iicãque. ");
INSERT INTO des_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Mʉa warã ne niyerure aĩbiricãque. ");
INSERT INTO des_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ne mʉa ajure, ne peñe camisare, ne peba zapaturi sãre aĩgãbiricãque. Mʉa buheroguere ero majarãpʉ mʉare barire oporo. ");
INSERT INTO des_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Iri macariguere ejarã, mʉa carĩborore masa õaro umupeogʉ pohrogue amaque. Eropirã ĩgʉ ya wihi ta dujanique. Ne warãgue wiriaque iri wihire. ");
INSERT INTO des_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Eropirã wihigue ñajarã “Ãhriri,” arĩque iri wihi majarãre. ");
INSERT INTO des_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mʉare erã gamecʉ̃, “Goãmʉ mera õaro árĩque mʉa,” arĩque erãre. Mʉare erã gamebiricʉ̃, “Goãmʉ mera õaro árĩque,” mʉa arĩbiricãque erãre. ");
INSERT INTO des_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eropirã mʉare erã gamebiricʉ̃, erã mʉa buherire peediabiricʉ̃ ĩarã iri wihire wiria waque. Eropa wiriarã, guburi maja nicure moje siripique erã ĩaro, erã ya dipuwajare ĩhmumorã. Iri maca majarã mʉare gamebiricʉ̃ eropa ta iique erã sãre. ");
INSERT INTO des_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Diaye ta mʉare arĩgʉ tiiaa. I ʉmʉ pehrecʉ̃guere Sodoma majarã Gomorra majarã mʉra bʉrigã dipuwajacʉrãcoma. Erã eropa dipuwajacʉro tauro mʉare gamebirãpʉ dipuwajacʉrãcoma. arĩ weremi Jesu gʉare. Eropa arĩtuha õpa arĩnemomi gʉare ĩgʉ buherãre: ");
INSERT INTO des_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Yʉre peeque mʉa. Oveja iro dopa árĩrãre mʉare yeea guarã iro dopa ta ñerã árĩrã watopegue obeogʉ iiaa. Eropirã mʉapʉ õaro pee masirã árĩque. Eropirã gariboro mariro õaro árĩque erã mera. ");
INSERT INTO des_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Õaro iique mʉa. Masa mʉare erã oparãre orãcoma mʉare dipuwaja moadorerã. Erã buheri wirigue sãre parãcoma mʉare. ");
INSERT INTO des_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eropirã mʉa yaharã mʉa árĩri dipuwaja macari majarã oparã pohrogue erã tauro oparã pohrogue sãre aĩgãrãcoma mʉare dipuwaja moadoremorã. Eropirã mʉare erogue erã aĩgãcʉ̃ judio masa árĩbirã oparã sãre õari buherire wererãca mʉa. ");
INSERT INTO des_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Mʉare oparã pohrogue erã aĩgãcʉ̃ erãre mʉa wereniguiburire wʉaro pepibiricãque. Mʉare erã serẽpicʉ̃ ta mʉa erãre yʉhriburire masirãca Goãmʉ mera. Eropa masirã mʉa irire mʉa gamero wereniguisome. Goãmʉpʉ mari Pagʉ ĩgʉ Espíritu Santo mera mʉare wereniguicʉ̃ iigʉcumi. ");
INSERT INTO des_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Irisubure erã tĩrã erã pagʉ porã Jesu yarã árĩcʉ̃ ĩha wejẽdore wiarãcoma oparãre. Erã pagʉ sʉmarã erã porã Jesu yarã erã árĩcʉ̃ ĩha wejẽdore wiarãcoma oparãre. Erã porãpʉ erã pagʉ sʉmarã erã Jesu yarã erã árĩcʉ̃ ĩha wejẽdore wiarãcoma oparãre. ");
INSERT INTO des_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Eropirã masa árĩpehrerã yʉre mʉa umupeora dipuwaja ĩhaturirãcoma mʉare. Erã mʉare erã ñero iiquerecʉ̃ ta mʉare erã ñero iirare yujuro bojerã yʉre duhubiricʉ̃ Goãmʉ mʉare taugʉcumi. Eropigʉ ĩgʉ pohrogue mʉare opagʉcumi. ");
INSERT INTO des_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yuju maca mʉare erã ñero iicʉ̃ gaji macague duhri wahgãque. Diaye ta mʉare arĩgʉ tiiaa. Israe yeba árĩri macarire mʉa buhepehoboro core, yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ i yebague dujarigʉra. ");
INSERT INTO des_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Buherã erãre buhegʉre masi taribeama. Eropigʉ pohro majagʉ sã ĩgʉ opʉ weca árĩbeami. ");
INSERT INTO des_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yujugʉ buhegʉre ĩgʉre weredigʉ iro dopa dujaro gahmemi ĩgʉ. Pohro majagʉ sãre ĩgʉ opʉ iro dopa ta dujami. Mʉapʉ yʉ buherã ãhraa. Eropirã yʉre iidiro dopa ta mʉa sãre iirãcoma. Eropirã yʉre “Watĩ Beelzebú ãhrimi,” arĩ weresãrã, mʉa sãre yaharãre ñero arĩ wereniguirãcoma erã, arĩ weremi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Eropa arĩra pʉhrʉ Jesu õpa arĩnemomi gʉare: —Eropirã mʉare erã ñero iidiarãre güibiricãque. Masa erã yayasãrare pʉhrʉ gajirã masirãcoma. Erã dibura sãre gajirã masirãcoma. ");
INSERT INTO des_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eropirã mʉare yayarogã yʉ wererare bajarã masa watope wereturiaque mʉapʉ. ");
INSERT INTO des_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉare wejẽrã mʉa dʉpʉ dihtare wejẽmasima. Mʉa sĩporãpʉ sĩribeaa. Eropirã mʉare wejẽdiarãre güibiricãque. Goãmʉpʉre güique. Ĩgʉ mʉa dʉpʉ mʉa sĩporãri sãre peamegue dedeomasimi mʉare. Eropirã ĩgʉpʉre güique. ");
INSERT INTO des_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Perã mirua wajamarima. Erã eropa wajamariquerecʉ̃ ta Goãmʉ õaro mahi ĩhadibumi erãgãre. Goãmʉ dorebiricʉ̃ ne sĩribeami yujugʉgã. ");
INSERT INTO des_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Eropigʉ mʉa poarire ne yuju poadagã dʉhyaro mariro masipehomi Goãmʉ. Eropa ta mʉa árĩricʉri sãre masipehomi Goãmʉ. Eropa masigʉ mʉare ĩhadibuniguicãmi. ");
INSERT INTO des_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Miruare ĩgʉ ĩhadiburo tauro mʉapʉre ĩhadibumi Goãmʉ. Eropirã wʉaro bʉjawere guñaricʉbiricãque mʉa, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Eropigʉ gʉa sãre werenemomi: —Yujugʉ “Jesucristo yagʉ ãhraa,” masare ĩgʉ arĩ werecʉ̃ yʉ sã ĩgʉre “Yahagʉ ãhrimi,” arĩ weregʉra yʉ Pagʉ ʉmaro majagʉguere. ");
INSERT INTO des_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yujugʉ masare güigʉ “Jesucristo yagʉ árĩbeaa,” masare ĩgʉ arĩ werecʉ̃ yʉ sã “Yahagʉ árĩbeami ĩgʉ,” arĩ weregʉra yʉ Pagʉguere ʉmaro majagʉguere, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Eropa arĩtuhaja õpa werenemomi masare: —¿Dohpa arĩ pepiri mʉa yʉre? ¿Yʉhʉ masare yʉ buhegʉ aricʉ̃ yʉ buheri mera masa ĩhaturisome, arĩ pepiri mʉa? Eropa árĩbeaa. Masa yʉ buherire peerã pe curu erã basi dʉca warirãcoma. Yujurãyeri yʉ buherire peerãcoma. Gajirãpʉ irire gamebirã erãre ĩhaturirãcoma. Eropirã yujuro mera árĩsome masa. ");
INSERT INTO des_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mʉrã yʉ buherire erã peera dipuwaja erã porã erãre ĩhaturirãcoma. Mʉrã nome erã yʉ buherire peera dipuwaja erã porã nome erãre ĩhaturirãcoma. Erã mʉñecosã nome yʉ buherire erã peera dipuwaja erã beposã nome erãre ĩhaturirãcoma. ");
INSERT INTO des_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Eropirã masa erã acawererãre yʉ buherire peecʉ̃ ĩarã erãre ĩhaturirã árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yʉre erã mahibodiro tauro erã pagʉ sʉmarãpʉre mahitarinʉgarã yaharã árĩsome erã. Yʉre erã mahiborono tauro erã porãpʉre mahitarinʉgarã yaharã árĩsome erã. ");
INSERT INTO des_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Eropirã crusague yʉ sĩridiro dopa ta yaharã erã árĩra waja ñero tarirãcoma erã sã. Eropa ñero taridiabirã yaharã árĩsome. ");
INSERT INTO des_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Masa yʉre guñaro mariro erã gamero iirã peamegue warãcoma erã. Yaha árĩburipʉre erã guñarã árĩpehrerinʉri Goãmʉ mera õaro árĩniguicãrãcoma, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Eropa arĩtuhaja õpa werenemomi gʉa sãre: —Mʉare yaharãre yujugʉ õaro mera bocatĩrigʉ, yʉ sãre bocatĩrigʉ iimi ĩgʉ. Eropigʉ yʉre õaro bocatĩrigʉ yʉre obeodigʉ sãre bocatĩrigʉ iimi. ");
INSERT INTO des_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Eropigʉ Goãmʉ yare weredigʉ wajatagʉcumi. Ĩgʉre õaro iigʉcumi Goãmʉ. Eropigʉ ĩgʉ yahare ĩgʉ weregʉ árĩcʉ̃ ĩagʉ yujugʉ ĩgʉre õaro bocatĩrigʉ weredigʉ iro dopa ta wajatagʉcumi ĩgʉ sã. Eropi gajigʉ õaro iidigʉ wajatagʉcumi. Eropigʉ ĩgʉ õaro iigʉ ĩgʉ árĩcʉ̃ ĩagʉ yujugʉ ĩgʉre õaro bocatĩrigʉ õaro iidigʉ dopa wajatagʉcumi ĩgʉ sã. ");
INSERT INTO des_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Jesu yagʉgã ta ãhrimi,” mʉa arĩ ĩarã ĩgʉgãre itamudiarã deco yʉsari mera dihta tĩaquerecʉ̃, diaye ta mʉa sãre õaro iigʉcumi Goãmʉ, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Gʉare ĩgʉ buherãre ĩgʉ eropa arĩ werera pʉhrʉ ero pohro árĩri macarigue buhegʉ waha wami ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Eropigʉ Ñu peresugue árĩgʉ Jesu ĩgʉ iiricʉrire peebeopʉ. Eropa peegʉ Ñu ĩgʉ buherãre Jesure serẽpidoregʉ obeopʉ. ");
INSERT INTO des_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Eropirã gʉa pohrogue eja, Jesure serẽpima erã Ñu buherã. —Ñu õpa arĩ serẽpidoreami mʉre: “‘¿Yʉ pʉhrʉ gajigʉ ĩgʉ arigʉcumi,’ yʉ eropa arĩdigʉ ta ãhriri mʉhʉ? ¿O gajigʉre corerãcuri gʉa?” arĩ serẽpi doreami Ñu, arĩma erã Jesure. ");
INSERT INTO des_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Erã eroparĩcʉ̃ peegʉ Jesu yʉhrimi: —Dohpaguere mʉa peerare, mʉa ĩarare Ñure wererã waque. ");
INSERT INTO des_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Õpa arĩque: “Jesu mera cuiri ĩhajabirã ĩhama. Curimasibirã cuhrima. Cami boanirã õarã wahama. Peejabirinirã peea wahama. Sĩrinirã masa wahama,” arĩ wereque. Eropirã mojomorocʉrãre õari buherire yʉ wererare wereque ĩgʉre. Eropa arĩ weretuhaja õpa arĩ wereque Ñure. ");
INSERT INTO des_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“Yʉre peegʉ ‘Diaye ta ãhraa,’ arĩgʉ ĩgʉ mucubirigʉ ãhrimi,” arãmi Jesu, arĩ, Ñure wererã waque, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ñu buherã erã wara pʉhrʉ, Jesu Ñu árĩricʉrire werenʉgami masa bajarãre. —Masa marirogue Ñu pohrogue warã ero majare taare miru weãcʉ̃ ĩarã ejabiribʉ mʉa. ");
INSERT INTO des_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Õari suhricʉgʉ sãre ĩabiribʉ mʉa. Õari suhricʉrã oparã ya wirigue ãhrima. ");
INSERT INTO des_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Masa marirogue ejarã Goãmʉ yare weremʉhtadigʉpʉre ĩarã ejabʉ mʉa. Diaye ta Ñu Goãmʉ yare weremʉhtagʉ ãhrimi. Gajirã Goãmʉ yare weremʉhtanirã tauro árĩgʉ ãhrimi Ñupʉ. ");
INSERT INTO des_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iribojegue Goãmʉ yare erã gojarapũ õpa arĩ wereyuyoro Ñure. Mari Pagʉ ĩgʉ magʉre õpa arĩpʉ. “Mʉ core mʉre wereyubure obeogʉ iiaa,” arĩmi Goãmʉ, arĩ gojañuma Ñure. ");
INSERT INTO des_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mʉare diaye ta arĩgʉ iiaa. Masa árĩpehrerã tauro ãhrimi Ñu waĩyegʉ. Irisubure ĩgʉ eropa árĩquerecʉ̃ ta ʉmaroguere Goãmʉ ĩgʉ opʉ árĩroguere árĩpehrerã docanʉgagʉpʉ Ñu tauro árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Ñu waĩyegʉ ĩgʉ eraboro core Moisere ĩgʉ apira doreri mera Goãmʉ marire doremi. Goãmʉ ya weremʉhtanirã mʉra erã gojara sã eropa ta árĩribʉ marire dorera. Dohpaguepʉre Ñu õari buherire, Goãmʉ opʉ ĩgʉ árĩrire buhemi. Ĩgʉ eropa buhecʉ̃ pee masa erã ejatuharo erã turari mera Goãmʉ erã opʉ árĩcʉ̃ bʉrigã gahmema. ");
INSERT INTO des_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Elia arigʉcumi,” iribojegue erã arĩdigʉ ta Ñupʉ ãhrimi. “Iribojegue majarã erã arĩrare diaye ta ãhraa,” arĩdiarã Ñu ĩgʉ erã eropa arĩdigʉ árĩcʉ̃ masirãca mʉa. ");
INSERT INTO des_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Õaro peeque mʉa ire, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Eropigʉ õpa arĩnemomi masare: —¿Mʉa dohpague majarã masa ñehmarano iro dopa ãhriri mʉa pepicʉ̃? Mʉa majirã iiro dopa õpa ãhraa. Doberi duarogue bira doarã, õpa arĩ dʉyasoma erãgã erã basi: ");
INSERT INTO des_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mʉa bayaburire tarisu purirabʉ gʉa. ¿Duhpirã mʉa mucubiri bayarã aribirari? Eropirã gʉa bʉrigã ñehamere orerabʉ. ¿Mʉapʉ duhpirã gʉa mera orebirari?” arĩma dʉyasorã. Erã majirã arĩ dʉyasorã iro dopa ta iirã õpa iiaa mʉa dohpague majarã. ");
INSERT INTO des_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ñu waĩyegʉ Goãmʉ ya árĩburire ba duhugʉ vinore ihribirimi. Ĩgʉ eropa ihribiricʉ̃ ĩarã “Pee masibigʉ ãhrimi,” arĩribʉ mʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yʉpʉ masʉ Goãmʉ ĩgʉ obeodigʉ árĩgʉ yʉhʉ baha, ihria. Yʉ eropa iicʉ̃ ĩarã õpa arãa mʉa yʉpʉre. “Ĩaque. Ihĩ wʉaro bagʉ, merericʉgʉ sã ãhrimi. Wajasea corerã ñero iirã erã wapicʉgʉ ãhrimi ĩgʉ,” arãa mʉa yʉre. Mʉa gamero dopa gʉa iibiricʉ̃ ero wabeaa mʉare. Mʉa masibiriquererã ta gʉa iirare ĩarã, Goãmʉ masirire gʉa opacʉ̃ masirãca mʉa, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pʉhrʉ ero maja macari majarãre turipʉ Jesu. Iri macarire gaji macari sãre Goãmʉ turari mera tauro deyoro moarire ii ĩhmudi árĩrimi ĩgʉ. Ĩgʉ eropa ii ĩhmuquerecʉ̃ ta erã ñero iirire duhubirinirã árĩma erã. Eropigʉ erãre õpa arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Corazín maca majarã mʉa ñero tarirãca. Betsaida majarã mʉa sã ñero tarirãca. Mʉa ya macaguere yʉhʉ Goãmʉ turari mera deyoro moarire iirabʉ. Mʉa peebirabʉ. Iribojegue Tiro waĩcʉri macare, Sidón waĩcʉri maca sãre yʉ deyoro moarire yʉ iicʉ̃ ĩarã ero majarãpʉ erã ñerire bʉjawereboañuma. Eropa iirã õaripʉre gohrotoboañuma. Bʉjawererã bʉjawereri suhrire saña, erã basi peame witũ mera mohsiripeoboañuma erã ñero iirare bʉjawere ĩhmumorã. Mʉapʉ eropa iibeaa. ");
INSERT INTO des_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eropigʉ mʉare arĩgʉ tiiaa. Dipuwaja moarinʉ árĩcʉ̃, Goãmʉ Tiro majarã mʉra, Sidón majarã mʉra tauro ñerã mʉa árĩri waja mʉare ñero gohra dipuwaja moagʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mʉa Capernaum majarã, mʉa ejatuharo Goãmʉ pohrogue wadiarabʉ. Mʉa Goãmʉ yare iidiabiricʉ̃ mʉare Goãmʉ peamegue cóãgʉcumi. Mʉa ya macague Goãmʉ turari mera deyoro moarire ii ĩhmurabʉ. Mʉa yʉre peebirabʉ. Iribojegue Sodoma waĩcʉri macare deyoro moarire yʉ eropa iicʉ̃ iri macapʉ dohpaguere árĩboca. ");
INSERT INTO des_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eropigʉ mʉare arĩgʉ tiiaa. Dipuwaja moarinʉ árĩcʉ̃ Goãmʉ Sodoma maca majarã mʉra tauro, mʉapʉre mʉa ñeri dipuwaja dipuwaja moagʉcumi, arĩpʉ Jesu iri macari majarãre. ");
INSERT INTO des_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Irisubu ĩgʉ Pagʉ mera wereniguigʉ õpa arĩmi Jesu. —Ahʉ, mʉhʉ ʉmaro majarã tauro opʉ, i yeba majarã tauro opʉ ãhraa. I mʉ buherire “Masituhaja gʉa,” arĩrãre masicʉ̃ iibeaa. Mʉ yare masipehobirãpʉre masicʉ̃ iiabʉ mʉhʉ. Mʉhʉ eropa iicʉ̃ “Õhaa,” arãa yʉhʉ mʉre. ");
INSERT INTO des_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eropa ta ãhraa, Ahʉ. Erã masibirãpʉre erã masicʉ̃ gahmeabʉ mʉhʉ, arĩmi Jesu ĩgʉ Pagʉre. ");
INSERT INTO des_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eropigʉ masare gʉa sãre õpa arĩ werenemomi: —Yʉ Pagʉ árĩpehreri yʉ iiborore apimi yʉre. Ĩgʉ dihta yʉre õaro masimi. Yʉ sã ĩgʉre masia. Yʉ beyenirã sã ĩgʉre masima yʉ ĩgʉre masidorerã árĩrã. Erã nʉcʉ ta yʉ Pagʉre masia gʉa. ");
INSERT INTO des_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Goãmʉ mera õaro árĩdiarã baja dorerire iiraa mʉa. Iri doreri nʉcʉrire omaro iro dopa ta ãhraa. Eropirã gariborea wahaa mʉa iri dorerire iirã. Eropa gariborerã yʉre serẽque. Mʉare soocʉ̃ iigʉra. ");
INSERT INTO des_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yʉhʉ pũriro mera doregʉ árĩbeaa. Nijiyajaro doregʉ ãhraa. Eropirã yʉ doreripʉre iique. Eropa iirã dipuwaja marirã õaro árĩrãca mʉa. ");
INSERT INTO des_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Eropiro yʉ itamuri mera yahare iicʉ̃ diasabeaa. Eropirã yʉ dorerire iirã nʉcʉrire pepiro mariro õaro árĩrãca, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Merogã ĩgʉ eropa arĩ buhera pʉhrʉ Sabado árĩcʉ̃ gʉa Jesu mera trigo otera pohegue ĩha tariabʉ. Erogue tariarã gʉa ĩgʉ buherã oaboarã, trigo pororire tʉrĩ aĩ babʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gʉa eropa iicʉ̃ ĩarã, fariseo masa Jesure õpa arĩma: —Peenique gʉare. ¿Duhpirã erã mari soorinʉ árĩquerecʉ̃ ta mohmeri? Mari dorerire tarinʉgarã iima erã, arĩma erã. ");
INSERT INTO des_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Erã eroparĩcʉ̃ peegʉ Jesu “Yʉ buherã tarinʉgarã iibeama,” arĩgʉ õpa arĩmi erãre: —Iribojegue Davi ĩgʉ mera majarã mera oaboagʉ Goãmʉ ya wihigue ñaja, iri wihi árĩri panre bañumi ĩgʉ mera majarã mera. Iri pan pahia dihtare badorera árĩyoro. Goãmʉ doreri gajirãre iri panre badorebiriyoro. ¿Davi irire ĩgʉ iirare Goãmʉ yare erã gojarapũgue buhebirari mʉa? Davi iri panre bagʉ Goãmʉre tarinʉgagʉ iibiriñumi. Dohpagãre yʉ buherã sã trigo yerire tʉrĩ barã Goãmʉre tarinʉgarã iibeama. ");
INSERT INTO des_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Eropi Goãmʉ ya wihi mohmerã pahia ne soobeama mari soorinʉrire. Eropa soobiriquererã Goãmʉ dorerire tarinʉgarã árĩbeama. ¿Irire buhebirari mʉa Goãmʉ Moisere ĩgʉ apirapũre? ");
INSERT INTO des_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mʉare arĩgʉ tiiaa: Goãmʉ wihire umupeorã iri wihi mohmerã erã soobiricʉ̃ ĩarã “Õhaa,” arãa mʉa. Erã tauro yʉpʉre umupeoro gahmea. ");
INSERT INTO des_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Goãmʉ yare erã gojarapũ õpa ãhraa: “Waimʉrãre wejẽ soerã yʉre mʉa eropa umupeocʉ̃ gamebeaa. Gajirãpʉre mʉa mojomoro ĩacʉ̃ gahmea yʉhʉ,” arĩmi Goãmʉ, arãa ĩgʉ yare gojarapũre. Ĩgʉ eropa arĩrare mʉa õaro masirã, yʉ buherãre erã dipuwaja mariquerecʉ̃ ta erãre weresãmasibiriboya mʉa. ");
INSERT INTO des_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ inonʉ soorinʉ sãre masa erã iiburire doremasia, arĩmi Jesu fariseo masare. ");
INSERT INTO des_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ĩgʉ eropa arĩra pʉhrʉ waha gʉa judio masa buheri wihigue ejabʉ gʉa Jesu mera. ");
INSERT INTO des_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ero mojoto bʉhagʉ árĩmi. Eropirã fariseo masapʉ Jesure weresãmorã, ĩgʉre serẽpima: —Sabadonʉ mari soorinʉre masare õarã wacʉ̃ iidorebeami Goãmʉ. ¿Eropa ta ãhriri mʉ pepicʉ̃? arĩ serẽpima erã. ");
INSERT INTO des_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu yʉhrimi erãre: —Mʉa yagʉ oveja mari soorinʉ árĩquerecʉ̃ gobegue ĩgʉ yuhriñajadigʉre ĩgʉre aĩ wiurãca mʉa. ");
INSERT INTO des_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oveja tauro ãhrimi masʉpʉ Goãmʉ ĩacʉ̃. Eropiro mari soorinʉ árĩcʉ̃ masʉre taucʉ̃ õapũrica, arĩ yʉhrimi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ĩgʉ eropa arĩra pʉhrʉ mojoto bʉhagʉre õpa arĩmi: —Mʉ mojotore sĩsirãbeoque, arĩmi ĩgʉ. Ĩgʉ eroparĩcʉ̃ mojoto bʉhagʉpʉ sĩsirãbeomi. Ĩgʉ eropa sĩsirãbeora pʉhrʉ ta õari mojoto dujabʉ. ");
INSERT INTO des_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Erã soorinʉ ĩgʉ eropiicʉ̃ ĩarã fariseo masa waha, erã basi õpa arĩñorã: —¿Dohpa ii mari Jesure wejẽrãcuri? arĩñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesu erã eropa arĩrire masigʉ waha wami. Ĩgʉ eropa wacʉ̃ bajarã masa ĩgʉre nʉrʉsiama. Eropigʉ ĩgʉpʉ árĩpehrerã erã mera majarã dorecʉrãre õarã wacʉ̃ iimi. ");
INSERT INTO des_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Eropigʉ dorecʉnirãre erãre ĩgʉ taurare gajirãre weredorebirimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eropa dorecʉrãre õarã wacʉ̃ iigʉ Goãmʉ yare weremʉhtadigʉ Isaia iribojegue ĩgʉ arĩ gojadiro dopa ta iigʉ iimi Jesu. Õpa arĩ gojañumi Isaia mʉrʉ: ");
INSERT INTO des_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Õpa arĩmi Goãmʉ: “Ihĩ yʉ pohro majagʉ ãhrimi. Ĩgʉ yʉ beyedigʉ ãhrimi. Ĩgʉre mahia. Eropigʉ ĩgʉ mera mucubiria. Yʉ Espíriture ĩgʉre ogʉra. Eropigʉ yʉ turari mera árĩpehrerã masare diaye iirire weregʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eropigʉ ĩgʉ ne game dʉyasosome. Eropigʉ gaguiniguisome. Eropigʉ masa bajarã watope ĩgʉ bʉrigã gaguinigui weresome. ");
INSERT INTO des_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Guaro mariro masare mojomorocʉrãre itamugʉcumi ĩgʉ. Daberogã ʉ̃jʉri peamere yaubiro dopa ta masare turabirãre õaro iigʉcumi ĩgʉ. Sĩporã marirãre õaro sĩporãcʉcʉ̃ iigʉcumi. Eropa ta iiniguigʉcumi ĩgʉ watĩre ĩgʉ tarinʉgaboro core. ");
INSERT INTO des_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Eropirã masa bajarã ĩgʉre umupeorãcoma,” arĩmi Goãmʉ ĩgʉ magʉ iiburire, arĩ gojañumi Isaia. ");
INSERT INTO des_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yujunʉ watĩ ñajasũdigʉre masa aĩgãrima gʉa pohrogue Jesure taudorerã. Ĩgʉpʉ watĩ ñajasũdigʉ wereniguimasibirimi. Eropigʉ cuiri ĩhajabirimi. Erã ĩgʉre eropa aĩ eracʉ̃ ĩha õagʉ wacʉ̃ iimi Jesu ĩgʉre. Ĩgʉ eropa iicʉ̃ õaro ĩha, wereniguimi pare. ");
INSERT INTO des_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ĩgʉ eropa wacʉ̃ ĩarã, masa ĩhamaria wama. —¿Ihĩ Davi mʉrʉ pãrami masare taubu ãhriri? arĩma erã erã basi. ");
INSERT INTO des_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Erã eroparĩquerecʉ̃ Jesu watẽare ĩgʉ cóãrare peerã fariseo masapʉ õpa arĩ pepiñorã: —Beelzebú, watẽa opʉ, ĩgʉ turari mera watẽare cohãmi Jesu, arĩ pepiñorã erã. ");
INSERT INTO des_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Erã eropa arĩ pepicʉ̃ masigʉ, Jesu õpa arĩ weremi erãre werenigui queori mera: —Yuju yeba majarã erã basi gamequeãrã iri yeba majarã pehrea wabocoma. Yuju maca majarã erã basi gamequeãrã iri maca majarã pehrea wabocoma. Yuju wihi majarã sã gamequeãrã eropa ta wabocoma. ");
INSERT INTO des_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eropigʉ Beelzebú watẽa opʉpʉ yʉre watẽare cóãdoregʉ ĩgʉ basi ĩgʉ yarãre cóãboñumi ĩgʉ. Eropirã erã sã wapehrea waboñuma. ");
INSERT INTO des_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Õpa arĩ weresãa mʉa yʉre: “Ĩgʉ Beelzebú itamuri mera watẽare cohãmi,” arĩ weresãa mʉa yʉre. Mʉa mera majarã sã watẽare cohãma. Eropirã erã “Watĩ ĩgʉ turari mera erãre cohãa gʉa,” arĩbeama. “Goãmʉ ĩgʉ turari mera watẽare cohãa,” arĩma. Eropirã mʉa yʉre “Watĩ turari mera watẽare cohãmi,” mʉa arĩra diaye árĩbiricʉ̃ mʉa mera majarã wererãcoma. ");
INSERT INTO des_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Eropigʉ yʉpʉ watẽare cóãgʉ Goãmʉ ĩgʉ Espíritu Santo turari mera cohãa. Yʉ eropa cóãcʉ̃ ĩarã õpa arĩ masirãca mʉa: “Goãmʉ ĩgʉ opʉ árĩri i yebaguere árĩtuhajaa dohpaguere,” arĩrãca mʉa. ");
INSERT INTO des_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Õpa ta ãhraa watĩ turagʉ tarinʉgari werediacʉ̃: Wihi opʉ turagʉre diribigʉ yajagʉ ĩgʉ ya wihigue ñajaja yajamasibeami. Ĩgʉre ĩgʉ dirira pʉhrʉ tamerare yajamasimi ĩgʉre, arĩ weremi Jesu. Eropa arĩ weremi watĩre ĩgʉ tarinʉgarare weregʉ. Watĩ turagʉ árĩquerecʉ̃ ta Jesu ĩgʉre tarinʉgami watẽare cóãgʉ. Eropa arĩtuhaja õpa arĩ werenemomi Jesu masare gʉa sãre: ");
INSERT INTO des_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Yujugʉ yʉre gamebigʉ, yʉre ĩhaturigʉ ãhrimi. Yujugʉ yʉre itamubigʉ, yʉre teboricʉcʉ̃ ĩgʉ iimi. ");
INSERT INTO des_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Eropigʉ mʉare diaye arĩgʉ tiiaa yʉhʉ. Árĩpehreri ñerire masa erã iicʉ̃ erã wereniguicʉ̃ sãre Goãmʉ cãdijimasimi. Eropa cãdijiqueregʉ Espíritu Santore erã ñero arĩ wereniguicʉ̃ Goãmʉ iri tamerare ne cãdijisome. ");
INSERT INTO des_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yʉ masʉre Goãmʉ ĩgʉ obeodigʉre erã ñero arĩ wereniguicʉ̃ iri ñerire cãdijimasimi Goãmʉ. Espíritu Santopʉre erã ñero arĩ wereniguicʉ̃ irire ne cãdijisome Goãmʉ. Dohpaguere pehrerinʉ pʉhrʉ sãre erã eropa arĩrare ne cãdijisome ĩgʉ, arĩ buhemi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Eropigʉ õpa arĩ werenemomi erãre werenigui queori mera: —Õadigʉ yucʉgʉ õarire dʉcacʉa. Ñedigʉ yucʉgʉ ñerire dʉcacʉa. Yucʉgʉ dʉcare masirã “Irigʉ dʉca ta ãhraa,” arĩ masia mari. Mari eropa masiro dopa ta masa erã wereniguirire peerã erã árĩricʉrire masia mari. ");
INSERT INTO des_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Añaa iro dopa ñerã ãhraa mʉa. Mʉa ñerã árĩrã, õarire wereniguimasibeaa mʉa. Mari guñarigue mari pepidiro dopa ta mari wereniguia. ");
INSERT INTO des_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Õagʉ õarire pepimi. Eropigʉ õarire wereniguimi. Ñegʉ ñerire pepimi. Eropigʉ ñerire wereniguimi. ");
INSERT INTO des_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mʉare arĩgʉ iiaa. Õaro pepi wereniguirã árĩque mʉa. Õaro wereniguibirinirã dipuwaja moarinʉ árĩcʉ̃, mʉa eropa arĩmaacãrare Goãmʉre wererãca. ");
INSERT INTO des_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mʉa queoro wereniguirare masigʉ, “Õarã ãhrima,” arĩ beyegʉcumi Goãmʉ. Eropigʉ mʉa ñero wereniguirare masigʉ, “Ñerã ãhrima,” arĩ beyegʉcumi ĩgʉ daja, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ĩgʉ eropa arĩra pʉhrʉ masare buherã, fariseo masa sã ĩgʉre õpa arĩma: —Buhegʉ, Goãmʉ ĩgʉ obeodigʉ árĩgʉ Goãmʉ turari mera ii ĩhmuque gʉare, arĩrima erã. ");
INSERT INTO des_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesu yʉhrimi: —Mʉa dohpague majarã ñerã, Goãmʉre gamebirã ãhraa. Yʉhʉ diaye arĩgʉ árĩcʉ̃ mʉa masidiarã Goãmʉ turari mera deyoro moarire iidoreraa yʉre. Mʉa eropa dorequerecʉ̃ Goãmʉ yare weremʉhtadigʉ Jona iribojegue majagʉ Goãmʉ turari mera ĩgʉ iira dihtare ĩhmumi Goãmʉ mʉare. ");
INSERT INTO des_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona ʉhrenʉ gohra waimʉ wʉagʉ paru pohecaguere árĩñumi. Ĩgʉ iidiro dopa ta yʉ sã masʉ Goãmʉ ĩgʉ obeodigʉ ʉhrenʉ árĩgʉca yeba pohecaguere. ");
INSERT INTO des_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Iribojegue majarãpʉ Nínive maca majarã Jona Goãmʉ yare ĩgʉ wererare peerã, erã ñero iirare bʉjawereñuma. Õarire gohrotoñuma. Dohpaguere mʉa watopegue Jona tauro árĩgʉ ãhraa yʉhʉ. Yʉhʉ Goãmʉ yare mʉare werequerecʉ̃ ta mʉa ñero iirare bʉjawerebeaa. Eropirã Nínive majarã mʉrapʉ erã ñero iirare bʉjawerenirãpʉ dipuwaja moarinʉ árĩcʉ̃ mʉa ñerire bʉjawerebirinirãre “Ñerã ãhrima,” arĩ weresãrãcoma mʉare. ");
INSERT INTO des_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Iribojegue majago, sur majago, opo bʉro igo sã mʉa dohpague majarãre weresãgocumo dipuwaja moarinʉ árĩcʉ̃. Igo Salomo opʉ ĩgʉ masirire peediago yoarogue aridigo Salomo opʉre peego ejañumo. Eropigo õaro iigo iiñumo dohpague majarã tauro. Mʉare arĩgʉ tiiaa. Dohpaguere mʉa watopegue Salomo tauro masigʉ ãhraa yʉhʉ. Yʉhʉ mʉa mera árĩquerecʉ̃ mʉa yʉ masirire peediabeaa. Mʉa eropa peediabirira waja igo opo bʉro mʉare “Ñerã ãhrima,” arĩ weresãgocumo, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Eropigʉ dipaturi Jesu queori moa weremi masare. —Yujugʉ watĩ masʉ mera árĩdigʉ waha, ĩgʉ deco mariri yebague cuhri, ĩgʉ sooborore amariñumi. ");
INSERT INTO des_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Eropa bocabigʉ õpa arĩ pepiñumi ĩgʉ. “Masʉre yʉ cóãdigʉ mera ta dipaturi árĩgʉ wagʉra,” arĩ pepiñumi ĩgʉ. Eropa arĩ pepigʉ ĩgʉ dujaa waha ĩgʉ cóãdigʉre ta bocañumi daja. Ĩgʉ bocaboro core masʉpʉ õagʉ árĩriñumi. ");
INSERT INTO des_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eropigʉ watĩ gajirã siete watẽare ĩgʉ tauro ñerãre sihugʉ wañumi. Ĩgʉ eropa sihucʉ̃ erã árĩpehrerã ĩgʉ mera árĩñuma. Masʉpʉ ero core yujugʉ watĩre opagʉ ñegʉ árĩñumi. Pʉhrʉ bajarã watẽare opagʉ ñetariagʉ árĩñumi. Eropa dohpague majarã Goãmʉre gamebirã, yʉ buherire peediabirã ñetariarã ta warãcoma, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Masare ĩgʉ eropa arĩ wereniguirisubu ĩgʉ pago ĩgʉ pagʉ porã mera disiporo nigui, ĩgʉre weretamudiañorã. ");
INSERT INTO des_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eropigʉ yujugʉ Jesure weremi: —Mʉ pago mʉ pagʉ porã mera disiporo niguima mʉre weretamudiarã, arĩmi. ");
INSERT INTO des_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ĩgʉ eroparĩcʉ̃ peegʉ ero árĩrãre õpa arĩmi Jesu erãre buhebu: —¿Noa ãhriri yʉ pago gohra? ¿Noa ta yʉ pagʉ porã gohra ãhriri mʉa ĩacʉ̃? arĩmi. ");
INSERT INTO des_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eropa arĩgʉ, gʉare ĩgʉ buherãre sĩpu, õpa arĩmi: —Oã ãhrima yʉ pago yʉ pagʉ porã iro dopa árĩrã. ");
INSERT INTO des_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Erã yʉ Pagʉ ʉmaro majagʉ ĩgʉ gamerire iima. Eropa iirã yʉ pagʉ magʉ, yʉ pagʉ mago, yʉ pago iro dopa ta ãhrima, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Irinʉ ta Jesu wihigue árĩgʉ wiriami gʉa mera. Wiri, wʉariyague waha, iriya tʉro pohro doami. ");
INSERT INTO des_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ĩgʉ eropa doacʉ̃ ĩarã bajarã masa ĩgʉ pohrogue gamenerema. Eropa cʉ̃hñacʉ̃ ĩagʉ dohodirugue ñajaa, irirugue doami ĩgʉ. Masapʉ imiporogue niguima. ");
INSERT INTO des_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Eropigʉ baja queori mera weremi ĩgʉ erãre. Õpa arĩmi: —Oteri masʉ otegʉ wañumi. ");
INSERT INTO des_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ĩgʉ eropa otecʉ̃ gajiyeri ma tʉro yuri merejayoro. Ero mehmerejarayerire mirimagʉ porã ahri bacãñuma. ");
INSERT INTO des_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eropi gajiyeri ʉtã watope yuri merejayoro. Ero ʉtã watope nicu mariñariro árĩro mata puhririyoro. ");
INSERT INTO des_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Eropa puhrira árĩquerero, abe ĩgʉ bʉrigã asicʉ̃, nuguri marinijaro ñaiñaja sĩria wayoro. ");
INSERT INTO des_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gajiyeri pora watope yuri merejayoro. Porapʉ puhri iri tiataria wa, oterayeripʉre wejẽcãyoro. ");
INSERT INTO des_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gajiyeri õari yebapʉ yurimerejayoro. Õaro puhri dʉcacʉyoro. Gajisari cien yeri, gajisari sesenta yeri, gajisari treinta yeri dʉcacʉyoro. ");
INSERT INTO des_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Irire õaro peeque mʉa, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ĩgʉ eropa arĩra pʉhrʉ gʉa ĩgʉ buherã ĩgʉ pohro eja, serẽpibʉ ĩgʉre: —¿Ne, duhpigʉ masare queori mera were buheri mʉhʉ? arĩ serẽpibʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu yʉhrimi: —Ʉmaro majagʉ masa tauro opʉ ĩgʉ árĩrire iribojegue majarã erã masibirirare mʉare masicʉ̃ iimi Goãmʉ. Gajirãpʉre eropiibeami ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Eropigʉ masirãre masinemocʉ̃ iigʉcumi ĩgʉ. Eropirã erãpʉ õaro masirãcoma. Masibirãpʉre merogã erã masiquerecʉ̃ erãpʉre masibiricʉ̃ iigʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Eropigʉ queori mera buhea. Yʉ eropiicʉ̃ õpa wahaa. Dohpague majarã ĩaquererã pee masisome. Eropirã peequererã masibeama. Irire peebirinirã iro dopa ãhrima erã. ");
INSERT INTO des_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Eropa árĩrã Isaia iribojegue majagʉ ĩgʉ arĩ gojadiro dopa ta iima erã. Õpa arĩ gojañumi: Õpa arĩmi Goãmʉ: “Goãmʉ yare peerãca mʉa. Eropa peequererã ne masisome mʉa. ");
INSERT INTO des_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mʉa dipuru bʉri ãhraa. Eropirã mʉa gamiro goberire bihaa peeri arĩrã. Mʉa cuirire cuumitĩa ĩhari arĩrã. Eropa iibirã õaro ĩarã masiboaya mʉa. Eropirã peerã masiboaya mʉa. Mʉa guñarigue õaro masiboaya. Eropirã yʉre Goãmʉre gameboaya mʉa. Mʉa eropa yʉre gamecʉ̃ mʉa ñerire cãdiji, mʉare tauboaya,” arĩmi Goãmʉ, arĩ gojañumi Isaia, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mʉapʉ peerã masia. Eropirã mucubirirã ãhraa mʉa. ");
INSERT INTO des_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mʉare ta arĩgʉ iiaa. Dohpague mʉa ĩarire mʉa peerire iribojegue majarã Goãmʉ yarã bʉrigã ĩadiariñorã. Goãmʉ yare weremʉhtanirã sã irire bʉrigã ĩadiariñorã. Ne ĩabiriñorã. Dohpague mʉa peeri sãre bʉrigã peediariñorã erã. Ne peebiriñorã. Erã eropa masidiaquerecʉ̃ ta Goãmʉ erãre masidorebiripʉ irisubuguere, arĩ weremi Jesu gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Pʉhrʉ Jesu gʉare werenemomi: —Peeque mʉa. Oteri masʉ queorare mʉare were amugʉra. Yʉre peerã õaro masique. ");
INSERT INTO des_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oteriyeri õari buheri iro dopa ãhraa. Eropiro ma tʉro mehmerejarayeri õari buheri iro dopa ta ãhraa. Eropirã masa õari buherire peequererã ta ne masibeama. Eropigʉ masa õari buherire erã peecʉ̃ ĩagʉ ñegʉpʉ watĩ ahri, iri buherire õari buherire masidorebeami masare. Mirimagʉ porã iriyerire erã dote aĩ badiro dopa ta iimi. ");
INSERT INTO des_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Eropi ʉtã watope yuri merejarayeri õari buheri iro dopa ta ãhraa. Eropirã masa õari buherire pee, mucubiriri mera mata irire pee aĩma. ");
INSERT INTO des_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Eropa pee aĩquererã ʉtã watope árĩri yucʉ nuguri mariri yucʉ iro dopa ta oã masa sã turabeama. Eropa turabirã yaha õari buherire erã peera dipuwaja gajirã erãre ñero iicʉ̃ yahare duhucãma. Gajirã erãre erã ñero iicʉ̃ irire yujuro bojebiri, yahare duhucãma. ");
INSERT INTO des_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eropi pora watope yuri merejarayeri õari buheri iro dopa ta ãhraa. Eropirã masa õari buherire peequererã i yeba majare wʉaro pepiri mera niyerure gametarima. Erã eropa iicʉ̃ iripʉ õari buherire cãhmotaa. Iri cãhmotacʉ̃ masa Goãmʉ gamerire iibeama. ");
INSERT INTO des_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Eropi õari yeba yuri merejarayeri õari buheri iro dopa ãhraa. Eropirã masa õari buherire peerã irire õaro masima. Eropa masirã árĩrã, Goãmʉ gamerire iima erã. Yujurãyeri wʉaro õarire iima cien yeri dʉcacʉro dopa ta. Gajirã erã docañariro õarire Goãmʉ yare iima sesenta yeri dʉcacʉro dopa ta. Gajirã merogã õarire iima treinta yeri dʉcacʉro dopa ta, arĩ weremi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Eropi dipaturi gaji queorire gʉa sãre weremi Jesu. —Ʉmaro majagʉ ĩgʉ opʉ árĩrire werediacʉ̃ õpa ãhraa: Pohe opʉ ĩgʉ ya pohegue õariyerire ĩgʉ otediro dopa ta ãhraa ʉmaro majagʉ ĩgʉ opʉ árĩri. ");
INSERT INTO des_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pohe opʉ trigo otera pʉhrʉ árĩpehrerã ĩgʉ mera majarã sã erã carĩrisubu ĩgʉre ĩhaturigʉ ariñumi. Eropa arigʉ trigo yeri erã oterayeri watope ñeri taare oteñumi. Otetuhaja waha wañumi. ");
INSERT INTO des_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pʉhrʉ trigo sari puhri iiriyoro. Eropiro iri dʉcacʉboro core árĩcʉ̃ iri ñeri taa sã puhri iri pohere tiha wacʉ̃ iiyoro. ");
INSERT INTO des_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Eropirã pohe opʉre mohme corerã ĩgʉ pohrogue eja serẽpiñuma: “Opʉ, ¿õariyeri dihtare mʉ ya pohere otequerecʉ̃ duhpiro ñeri taa sã tiari iri pohere?” arĩñuma erã. ");
INSERT INTO des_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Yʉre ĩhaturigʉ ãhrañumi iri taare otegʉ,” arĩñumi pohe opʉ. “¿Taare gʉa curacʉ̃ gahmeri mʉhʉ?” arĩriñuma ĩgʉre mohme corerã. ");
INSERT INTO des_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Taare curabiricãque, taare curanijarã trigopʉre curari,” arĩñumi. ");
INSERT INTO des_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Trigo iri ñeri taa mera puhricãniporo. Iri ñairisubu dʉca aĩrãre õpa arĩrã: ‘Iri ñeri taare cura gameneopimʉhtaque irire soemorã. Pʉhrʉ trigore tʉrĩque. Tʉrĩpeho, irire yʉ diburi wihigue apique,’ arĩrã erãre,” arĩñumi pohe opʉ, arĩmi Jesu queori mera weregʉ. ");
INSERT INTO des_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Eropi gaji queori gʉare õpa arĩ buhemi daja. —Ʉmaro majagʉ ĩgʉ opʉ árĩri werediacʉ̃ mostazayegã iro dopa ãhraa. Iriyegã miriyegã gohra ãhraa. Iriyegã yujugʉ oteri masʉ ĩgʉ pohegue oteami. ");
INSERT INTO des_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iriyegãre ĩgʉ pohegue otera pʉhrʉ õaro puhria. Eropiro yucʉgʉ wʉatariadigʉ wahaa. Eropa wacʉ̃ mirimagʉ porã bajarã irigʉ dʉpʉrigue suhri suama. Eropa ta ʉmaro majagʉre mari Opʉre masirã bajamerãgã erã árĩmʉhtaquerecʉ̃ ta pʉhrʉguere erã bajarã warãcoma, arĩ weremi Jesu ");
INSERT INTO des_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Eropi gaji queori mera gʉare õpa arĩ buhemi daja: —Ʉmaro majagʉ ĩgʉ opʉ árĩri pan bʉgacʉ̃ iiburi iro dopa ãhraa. Yujugo nomeo panre iigo pan bʉgacʉ̃ iiburi pohgare merogã moremo trigo pohga mera. Igo eropa iicʉ̃ pan bʉgacʉ̃ iiburi pohga merogã árĩquerero ta trigo pohgare õaro seyapehrea wahaa. Eropa ta ʉmaro majagʉre mari Opʉre bajarã masa árĩpehrero majarã masirãcoma, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","I árĩpehreri buherire queori mera weremi Jesu. Queori mariro werebirimi ĩgʉ masare. ");
INSERT INTO des_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eropa ta iimi ĩgʉ Goãmʉ yare weremʉhtadigʉ ĩgʉ arĩ gojadiro dopa ta. Õpa arĩ gojañumi iribojegue: Queori mera weregʉra. Goãmʉre i yebare ĩgʉ ĩhacũnugura pʉhrʉ, ne masare ĩgʉ werebirirare weregʉra, arĩ gojayuñumi Jesu iiborore. ");
INSERT INTO des_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Eropi masare goeriseregʉ, wihigue ñajaa wami Jesu. Eropirã gʉa ĩgʉ buherã ĩgʉ pohrogue eja, serẽpibʉ gʉa: —Trigo watopegue ñeri taa tiara queorire werepehoque gʉare, arĩbʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu yʉhrimi gʉare: —Pohe opʉ õariyerire otediro iro dopa ta ãhraa yʉhʉ. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. ");
INSERT INTO des_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pohepʉ i yeba iro dopa ta ãhraa. Õariyeri puhriro ʉmaro majagʉ ĩgʉ opʉ árĩrogue árĩmorã iro dopa ta ãhrima. Ñeri taapʉ watĩ yarã iro dopa ta ãhrima. ");
INSERT INTO des_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Pohe opʉre ĩhaturigʉ ñeri taare otedigʉ watĩ iro dopa ta ãhrimi. Iri ñairisubu pehrerinʉ iro dopa ãhraa. Eropirã trigore aĩrã anyua iro dopa ta ãhrima. ");
INSERT INTO des_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Iri ñeri taare erã curarare soe peamegue cóãdiro dopa ta pehrerinʉ árĩcʉ̃ watĩ yarãre peamegue cóãrãcoma. ");
INSERT INTO des_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yaharã anyuare obeogʉra. Yʉ obeocʉ̃ anyuapʉ ñeri iidorenirãre, ñerire iinirãre yʉ dorerogue gameneorãcoma. ");
INSERT INTO des_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Gameneotuhaja peamegue cóãrãcoma erãre. Erogue erã bʉrigã ore, bʉjawereri mera gʉcʉri cũridihurãcoma. ");
INSERT INTO des_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Eropirã Goãmʉ yarã erã Pagʉ erã Opʉ ĩgʉ árĩrogue árĩrãcoma. Ero árĩrã, õaro mucubiriri mera árĩrãcoma erã. Ire õaro peeque mʉa, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Eropi gaji queori mera weremi daja: —Ʉmaro majagʉ ĩgʉ opʉ árĩri niyeru wʉaro diburare bocadiro iro dopa ãhraa. Eropigʉ yujugʉ masʉ curigʉ wagʉ iri niyerure guñaña mariro bocañumi yuju yebague. Eropa bocagʉ bʉrigã mucubiriñumi ĩgʉ. Bocatuhaja waha iri yebague dipaturi dujara irire õaro dibunemoñumi. Eropigʉ ĩgʉ bocarare aĩbu iri yebare asũdiañumi. Eropigʉ ĩgʉ yare duapeho, iri yebare asũñumi. Ʉmaro majagʉ opʉ ĩgʉ árĩri ĩgʉ bocadiro dopa ta ãhraa. Ĩgʉ bocarare ĩgʉ bʉrigã gamediro dopa ta ʉmaro majagʉ masa weca opʉre õaro erã masira pʉhrʉ masa bʉrigã gahmema ĩgʉre, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Eropi gaji queori mera weremi daja: —Ʉmaro majagʉ ĩgʉ opʉ árĩri waja pagariye perla waĩcʉriyere asũdigʉ iro dopa ãhraa. ");
INSERT INTO des_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iriyere amagʉ õataririyere bocañumi. Bocagʉ iriyere gametarigʉ árĩpehreri ĩgʉ yare duapehogʉ wañumi. Eropa duatuhaja iriyere waja pagariyere asũñumi. Iriyerire bʉrigã ĩgʉ gamediro dopa ta ʉmaro majagʉ masa weca opʉre õaro erã masira pʉhrʉ masa bʉrigã gahmema ĩgʉre, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Eropi gaji queori mera Jesu weremi daja gʉa sãre: —Ʉmaro majagʉ ĩgʉ opʉ árĩri wejẽdigʉ erã mehyudigʉ iro dopa ta ãhraa. Irigʉ wejẽdigʉ mera bajarã waire gajiropa árĩrãre ñeama. ");
INSERT INTO des_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Irigʉ ʉjʉtʉria wacʉ̃ wai wejẽrãpʉ irigʉre wejẽdigʉre imiporogue tara majaa õarã waire beyema. Õarãre erã puirigue beye sãma. Ñerã waire cóãcãma. ");
INSERT INTO des_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pehrerinʉ árĩcʉ̃ õpa ta árĩroca. Anyuapʉ masare beyerãcoma. Ñerãre beye aĩ wiurãcoma õarã watope árĩrãre. ");
INSERT INTO des_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aĩ wiu, erãre peamegue cóãrãcoma. Erogue erã ore, bʉrigã bʉjawereri mera gʉcʉri cũridihurãcoma ñerãpʉ, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ĩgʉ eropa arĩ werera pʉhrʉ gʉare serẽpimi ĩgʉ: —¿I árĩpehrerire peeri mʉa? arĩ serẽpimi ĩgʉ. —Peea gʉa, arĩ yʉhribʉ. ");
INSERT INTO des_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gʉa eroparĩcʉ̃ ĩgʉ weremi gʉare: —Judio masare buherã watope yujugʉ ʉmaro majagʉ ĩgʉ opʉ árĩrire buhenʉgagʉ iri mama buherire buhegʉ iribojegue maja sãre masigʉ weremi. Ĩgʉ wihi opʉ iro dopa ãhrimi. Ĩgʉ ĩgʉ ya wihi diburare õarire aĩ wiugʉ, mamare, mʉra sãre aĩ wiumi ĩgʉ, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iri queori bajare ĩgʉ buhera pʉhrʉ ĩgʉ mera gʉa waha wabʉ. ");
INSERT INTO des_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Waha, ĩgʉ masara macague ejabʉ. Erogue eja, gʉa buheri wihigue buhemi ĩgʉ. Ĩgʉ eropa buhecʉ̃ peerã, pee ʉca wama erã. —¿Nohogue masiyuri ihĩ i buherire? ¿Dohpa ii ĩgʉ i deyoro moarire iimasiri? arĩ wereniguima erã erã basi. ");
INSERT INTO des_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ihĩ taboa mohmeri masʉ magʉ ta ãhrimi ĩgʉ. Eropi ĩgʉ pago María ãhrimo. Eropi Santiago, José, Simo, Juda ĩgʉ pagʉ porã ãhrima. ");
INSERT INTO des_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dohpaguere ĩgʉ pagʉ porã nome i maca ãhrima. Eropigʉ ĩgʉ mari iro dopa ta árĩgʉ ãhrimi. ¿Eropa árĩqueregʉ ta nohogue peeyuri i buherire? arĩ wereniguima erã erã basi. ");
INSERT INTO des_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eropirã erã ĩgʉre umupeobirima. Erã eropa umupeobiricʉ̃ ĩagʉ õpa arĩmi Jesu erãre: —Árĩpehrerogue Goãmʉ yare weremʉhtagʉre gajirã umupeoma. Ĩgʉ ya maca majarã ĩgʉ ya wihi árĩrã dihta ĩgʉre umupeobeama. Eropirã yʉre umupeobeaa mʉa ohõ yʉhʉ masadigʉ árĩcʉ̃, arĩmi ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eropigʉ erã ĩgʉre umupeobiricʉ̃, iri macare baja deyoro moarire iibirimi Jesu. ");
INSERT INTO des_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Irisubure Herode Galilea majagʉ opʉ Jesu ĩgʉ iirare peebeopʉ. ");
INSERT INTO des_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Eropa peegʉ õpa arĩripʉ: —Ñu waĩyeri masʉ sĩridigʉ dipaturi masa dehyoagʉ iicumi. Eropa masadigʉ árĩgʉ ĩgʉ turarire opami ĩgʉ deyoro moarire iigʉ, arĩripʉ Herode ĩgʉ pohro majarãre. Jesure “Ñu mʉrʉ ta ãhrimi,” arĩ pepiripʉ ĩgʉ Ñure ĩgʉ wejẽdorera pʉhrʉ. ");
INSERT INTO des_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Eropigʉ Ñure ĩgʉ wejẽdoreboro core Herode ĩgʉ pagʉ magʉ Felipe marapore ehma igo mera marapocʉpʉ. Ĩgʉ eropa iicʉ̃ ĩagʉ Ñu waĩyegʉ Herodepʉre õpa arĩ wereniguipʉ: —Mʉ pagʉ magʉ marapore marapocʉgʉ Goãmʉ dorerire tarinʉgagʉ iiaa mʉhʉ, arĩripʉ Ñu ĩgʉre. Ĩgʉ eropa arĩra waja Herode ĩgʉre wejẽdiaripʉ. “‘Ñu Goãmʉ yare weremʉhtagʉ ãhrimi,’ arĩ pepima judio masa,” arĩgʉ erãpʉre güipʉ Herode. “Ñure yʉ wejẽcʉ̃ erã guabocoma,” arĩgʉ erãre güipʉ. Eropa güigʉ Ñure wejẽdiabiriripʉ. Eropa wejẽbiriqueregʉ ta ĩgʉre ñeha diridore, peresu iipʉ. Ĩgʉre eropa iicʉ̃ gamepo ĩgʉ marapo Herodia. ");
INSERT INTO des_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Eropi Herode ĩgʉ masa dehyoaranʉ árĩcʉ̃ bosenʉ iipʉ ĩgʉ. Ĩgʉ eropa bosenʉ iicʉ̃ ĩgʉ marapo mago bosenʉ eranirã erã ĩhuro baya ĩhmupo igo. Igo eropa baya ĩhmucʉ̃ Herode mucubiripʉ. Eropa mucubirigʉ igore arĩpʉ: ");
INSERT INTO des_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","—Goãmʉ mera diaye ta arĩgʉ iiaa. Yʉre mʉ serẽropẽ ta ogʉra yʉhʉ mʉre, arĩpʉ pare Herodepʉ ĩgʉ marapo magore. ");
INSERT INTO des_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ĩgʉ eroparĩcʉ̃ ĩgʉ marapo igo magore igo serẽburire werepo igore. Igo eropa werecʉ̃ igo magopʉ õpa arĩ serẽpo Herodere. —Ñu waĩyegʉ dipurure tabetadoreque. Eropigʉ soropa mera ĩgʉ dipurure yʉre oque, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Igo eroparĩcʉ̃ peegʉ Herode bʉrigã bʉjawerepʉ. Masa erã peero “Mʉ serẽro mʉre ogʉra,” arĩtuhapʉ ĩgʉ. Eropigʉ ĩgʉ ĩgʉ eropa arĩrare gʉhyasĩrigʉ “Mʉre osome,” arĩmasibiripʉ igore. Eropigʉ igo ĩgʉre dorero dopa ta Herodepʉ ĩgʉ pohro majarãre Ñure wejẽdorepʉ. ");
INSERT INTO des_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eropigʉ Ñu dipurure tabetadorecãpʉ pare peresugue árĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tabetatuhaja, soropa mera ĩgʉ dipurure aĩgãriñorã erã. Ĩgʉ marapo magore ĩgʉ dipurure erã ocʉ̃, igopʉ igo pagoguere aĩ taupo. ");
INSERT INTO des_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Erã eropa iira pʉhrʉ Ñu ĩgʉ buhenirã ĩgʉ dʉpʉ mʉrarore aĩgã wañorã. Eropa yaatuhajarã, erã irire Jesure wererã arima. ");
INSERT INTO des_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ñu sĩrirare peegʉ Jesu gʉa mera dohodirugue ñaja, masa marirogue sihu wami. Jesu erogue wacʉ̃ peerã, masa erã ya macarire wiri, marigue waha ĩgʉ core ejatuhañorã. ");
INSERT INTO des_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Eropiro Jesu ĩgʉ wadiru dohodiru tuhajara pʉhrʉ ĩgʉ bajarã masa árĩcʉ̃ ĩha, mojomoro ĩami erãre. Eropa mojomoro ĩagʉ erã mera bajarã dorecʉrãre õarã wacʉ̃ iimi. ");
INSERT INTO des_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ñamicague gʉa ĩgʉ buherã õpa arĩbʉ: —Ñamicague ãhraa. Ohõ masa marirogue ãhraa. Õgã árĩri macarigue masare wadoreque. Erã baburire asũrã waporo, arĩribʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu yʉhrimi gʉare: —Wabiricãporo erã. Mʉa basi ta barire oque erãre, arĩmi gʉare. ");
INSERT INTO des_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Cinco pan dipurure, perã ta wai sãre iripẽta opaa gʉa, arĩ yʉhribʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Irire yʉre aĩgãrique mʉa, arĩmi gʉare. ");
INSERT INTO des_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Gʉa irire ora pʉhrʉ, taa weca masare ĩgʉ doadoremi pare. Erã eropa doarisubu cinco pan dipurure aĩ, perã wai sãre aĩ, ʉmarogue ĩhamuju, ĩgʉ Pagʉre “Õhaa,” arĩmi. Õpa arĩtuhaja iri pan dipurure nuha, gʉare ĩgʉ buherãre omi. Ĩgʉ eropa ocʉ̃ gʉapʉ iri barire masare guerebʉ. ");
INSERT INTO des_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Eropirã árĩpehrerã õaro baha yapia wama. Erã ba dʉharare doce puiri gohra aĩ gameneo, ʉjʉtu dobobʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ero irire banirã ʉma dihtare queocʉ̃ cinco mil ʉma árĩma. Nome, majirã sã árĩma. ");
INSERT INTO des_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pʉhrʉ gʉare ĩgʉ buherãre Jesu dohodirugue ñajadore wʉariyague taribuja yuudoremi masare ĩgʉ goerisererisubu. ");
INSERT INTO des_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Goeriseretuhaja, ĩgʉ basi ʉtãgʉgue mʉria, ĩgʉ Pagʉ Goãmʉ mera serẽgʉ wapʉ ĩgʉ seyaro. ");
INSERT INTO des_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Irisubure wʉariya deco gohra gʉa taribujacʉ̃ miruñe bʉrigã ahri, pãgúri pagari wahgã, dohodirure deco paa ñajabʉ. ");
INSERT INTO des_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Eropa wacʉ̃ boyomʉririboro core cãreña wahgãrisubu Jesu deco weca cʉhrapi wahgãrimi gʉa pohrogue arigʉ. ");
INSERT INTO des_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gʉa pohrogue ĩgʉ aricʉ̃ ĩarã güibʉ gʉa. Eropa güirã gaguiniguiribʉ. —Sĩridi mʉrʉ watĩ ãhrimi, arĩ gaguiniguibʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gʉa eropa güicʉ̃ Jesu õpa arĩmi: —Ne yʉre ĩha ʉcabiricãque. Yʉhʉ ta ãhraa. Güibita, arĩmi gʉare. ");
INSERT INTO des_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ĩgʉ eroparĩcʉ̃ peegʉ Pedro arĩmi ĩgʉre: —Yʉ tĩgʉ, diaye ta mʉhʉ ta árĩgʉ, deco weca curi wahgãdoreque yʉre mʉ pohrogue, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Arique, arĩ yʉhrimi ĩgʉpʉ. Ĩgʉ eroparĩcʉ̃ Pedropʉ dohodirugue árĩdigʉ wiria, deco weca Jesu pohrogue niguigãrimi. ");
INSERT INTO des_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Miruñe iri bʉrigã aricʉ̃ ĩagʉ güimi. Eropa güigʉ diha dija warimi. —Yʉre tauque, arĩ gaguiniguimi ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ĩgʉ eroparĩcʉ̃ ta Jesu ĩgʉ mojotore ñeha, —Merogã umupeoa mʉhʉ yʉre. ¿Duhpigʉ yʉre guñaturabeari mʉhʉ? arĩmi ĩgʉ Pedrore. ");
INSERT INTO des_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Eropa arĩra pʉhrʉ dohodirugue ñajama erã. Erã eropa ñajara pʉhrʉ, miruñe taria wabʉ. ");
INSERT INTO des_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eropirã gʉa ĩgʉ buherã dohodirugue árĩrã Jesure umupeobʉ. —Diaye ta mʉhʉ Goãmʉ magʉ ta ãhraa, arĩbʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eropi taribujaja, Genesare waĩcʉri yebague ejabʉ. ");
INSERT INTO des_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ero majarã Jesure ĩha masima. Eropa masirã erã pohro árĩrãre dorecʉrãre aĩgãridorema. Eropirã erã dorecʉrãre ĩgʉ pohrogue aĩ erama. ");
INSERT INTO des_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Mʉ suhriro tʉro dihtare gʉare mohmepiñadoreque, arĩ serẽma erã Jesure. Eropirã árĩpehrerã dorecʉrã ĩgʉ suhrirore mohmepiñanirã dihta õarã wama. ");
INSERT INTO des_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Eropi Jerusalén majarã, fariseo masa, masare buherã mera Jesu pohrogue erarã, serẽpima ĩgʉre: ");
INSERT INTO des_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Duhpirã mari ñecʉ sʉmarã mʉra erã dorediro dopa iibeari mʉ buherãpʉ? Erã mari dorero dopa ta erã baboro core mojo coe ĩhmubeama, arĩma erã Jesure. ");
INSERT INTO des_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu yʉhrigʉ serẽpimi erãpʉre: —¿Mʉapʉ duhpirã Goãmʉ doreripʉre iibeari? ¿Duhpirã mʉa ya doreri dihtare iiri mʉapʉ? ");
INSERT INTO des_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Õpa arĩmi Goãmʉ: “Mʉa pagʉ sʉmarãre umupeoque,” arĩmi. Eropigʉ “Ĩgʉ pagʉ sʉmarãre ñero werenigui coredigʉre erã dipuwaja moarã wejẽbu árĩgʉcumi,” arĩmi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ĩgʉ eropa arĩquerecʉ̃ ta mʉapʉ õpa arĩdorea masare erã pagʉ sʉmarãre. “‘Mʉare itamumasibeaa. Mʉare yʉ oborare Goãmʉ ya árĩburire opehocãbʉ,’ arĩque mʉa pagʉ sʉmarãre,” arĩ buheraa mʉa. ");
INSERT INTO des_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mʉa eropa buherã erã pagʉ sʉmarãre erã umupeobiricʉ̃ iiaa mʉa. Mʉa eropa iirã Goãmʉ buherire tarinʉgarã iiaa mʉa mʉa ya doreri dihtare iirã. ");
INSERT INTO des_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Masa erã ĩabiropʉre ñero iicorerã ãhraa mʉa. Goãmʉ ya weremʉhtadigʉgue Isaia mʉare diaye ta were gojamʉriñumi iribojeguere: ");
INSERT INTO des_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Oã masa yʉre õaro wereniguiquererã yʉre õaro umupeobeama. Erã ya sĩporãripʉ gajipʉgue ãhraa. ");
INSERT INTO des_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Goãmʉ ya dorerire arĩbodirore erã ya wereniguiri dihtare buhema erã. Eropirã yʉre umupeo erã sĩbuipeori duhpiburi árĩbeaa, arĩ gojañumi Isaia, arĩmi Jesu fariseo masare, masare buherã sãre yujuropa ta. ");
INSERT INTO des_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Eropa arĩtuhaja ĩgʉ pohrogue masare sihubeo, õpa arĩmi: ");
INSERT INTO des_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","—Peeque mʉa. Mʉa disirorire ñajaripʉ mʉa baripʉ masare ñerã masa wacʉ̃ iibeaa. Mʉa wereniguiripʉ mʉa ya disiro wiriripʉ mʉare ñerã árĩcʉ̃ iiaa, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ĩgʉ eropa arĩ buhera pʉhrʉ gʉa ĩgʉ buherãpʉ ĩgʉre werebʉ: —Mʉ eroparĩcʉ̃ peerã fariseo masa guama, arĩ werebʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Irire pee õpa arĩ yʉhrimi gʉare: —Erã otera iro dopa ãhrima. Yʉ Pagʉ ʉmaro majagʉ árĩpehreri oterare ĩgʉ otebirirare nuguri mera ta cura cóãgʉcumi. ");
INSERT INTO des_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Erãre eropa ĩacãque. Erã Goãmʉ yare masibirã masa cuiri ĩhajabirã iro dopa ãhrima. Cuiri ĩhajabirã seyaro erã basi game tʉagã erã perãgue ta mehtua yuhridijarãcoma gobegue. Eropa erã Goãmʉ yare masibiriquererã ta gajirãre masibirãre buhediarima. Eropirã erã erã buherã sã peamegue warãcoma, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ĩgʉ eroparĩcʉ̃ peegʉ Pedro arĩmi: —Iñe queoriñere erã disiro wiriri queorire werenemoque gʉare daja, arĩmi ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu yʉhrimi: —¿Ne, peenibeari mʉa? ");
INSERT INTO des_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Masa erã barire bacʉ̃ erã ya disiro ñajaa. Eropiro erã parugue ñajaja, pʉhrʉ erã dʉpʉpʉ ñerire cohãa. Ibu gohra ãhraa. Mari bari marire ñerã wacʉ̃ iibeaa. ¿Ire masibeari mʉa? ");
INSERT INTO des_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Masa ya disiro wiriri, erã wereniguiripʉ erã pepiri ãhraa. Erã ya pepiripʉ ñeri árĩro masare ñerã árĩcʉ̃ iiaa. ");
INSERT INTO des_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Erã pepirigue õpa ñeri nʉgaa: Ñeri pepiri, masare wejẽri, gajigʉ marapo mera ñero iiri, ñero iirã nome mera ñero iiri, yajari, gʉyari, masare ñero quere iiri, masa erã pepirigue nʉgaa. ");
INSERT INTO des_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iri ñeripʉ masare ñerã árĩcʉ̃ iiaa. Masa erã dorerire mʉrague erã iimʉridiro dopa ta mojoto coebiriquererã ta erã bacʉ̃ iri masare ñerã masa árĩcʉ̃ iibeaa, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Eropa arĩ buhetuhaja gʉare sihu waha wami daja. Tiro waĩcʉri maca pohrogue Sidón waĩcʉri maca pohrogue ejabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Gʉa erogue ejacʉ̃ Canaa yeba majago ero árĩgo Jesu pohrogue eja, turaro mera wereniguimo: —Opʉ Davi pãrami, masare taugʉ yʉre mojomoro ĩaque mʉhʉ. Yʉ mago watĩ ñajasũdigo ñetariaro tarimo igo, arĩmo. ");
INSERT INTO des_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Igo eropa arĩquerecʉ̃ ta Jesu igore yʉhribirimi. Ĩgʉ eropa iicʉ̃ ĩarã gʉa ĩgʉ buherãpʉ ĩgʉre õpa arĩribʉ: —Wadoreque igore. Ñe gariboro bʉsʉcumo, arĩribʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Gʉa eroparĩcʉ̃ peegʉ ĩgʉ yʉhrimi igore: —Israe majarã oveja dederenirã iro dopa árĩrã dihtare itamudoregʉ obeomi yʉ Pagʉ yʉre, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ĩgʉ eroparĩcʉ̃ ta Jesu guburi pohro merejamo igo. —Mʉhʉ eropa arĩqueregʉ itamuque yʉre, arĩmo igo. ");
INSERT INTO des_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu yʉhrimi igore: —Wihi opʉ porã ya barire diayeare ocʉ̃ õabeaa. Eropa arĩgʉ, Israe masa yare gaji yeba majarãre yʉ ocʉ̃ õabeaa, arĩ weremi Jesu igore. ");
INSERT INTO des_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Eropa ta ãhraa, Opʉ. Eropa árĩquerecʉ̃ barisubu dijarire diayea sã bacohrema. Gaji yeba majago yʉ árĩquerecʉ̃ ta yʉ sãre itamuque mʉhʉ, arĩ yʉhrimo igo. ");
INSERT INTO des_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Igo eroparĩcʉ̃ ĩgʉ yʉhrimi: —Mʉhʉ nomeo, yʉre bʉrigã umupeoa. Mʉ gamero dopa ta eropa waroca, arĩmi Jesu igore. Ĩgʉ eroparĩcʉ̃ ta igo mago mata õago wapo. ");
INSERT INTO des_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Eropa arĩtuhaja gʉare sihu waha, Galilea waĩcʉriya tʉro pohrogue sihu ejami daja. Pʉhrʉ ʉtãgʉgue mʉria, erogue doajami. ");
INSERT INTO des_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ero ĩgʉ doacʉ̃ masa bajarã erama. Eropirã bajarã dorecʉrãre aĩ erama. Curimasibirãre, cuiri ĩhajabirãre, yujupʉ ñero guburucʉrãre, apayuriri árĩrãre, wereniguimasibirãre, bajarã gajirã dorecʉrãre ĩgʉ pohrogue aĩ erama masa. Eropa aĩ erarã Jesu guburi pohrogã apima erã. Erã eropa duhupira pʉhrʉ õarã wacʉ̃ iimi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ĩgʉ eropa iicʉ̃ ĩarã masa ĩhamaria wama. Wereniguimasibirinirã erã wereniguicʉ̃ ĩarã, apayuriri árĩnirã erã õarã wacʉ̃ ĩarã, curimasibirinirã erã curicʉ̃ ĩarã, cuiri ĩhajabirinirã erã ĩacʉ̃ ĩarã, ĩhamaria wama erã. Eropirã õpa arĩma: —Mari Israe majarã mari Opʉ Goãmʉ turagʉ õagʉ ãhrimi, arĩ umupeoma erã Goãmʉre. ");
INSERT INTO des_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ĩgʉ eropa iira pʉhrʉ Jesu gʉare ĩgʉ buherãre sihubeo arĩmi: —Oã masa yʉ mera ʉhrenʉ gohra árĩtuhajama. Erãre bari pehrea waca. Eropigʉ erãre mojomoro ĩhaa. Erã babiriquererã erã ya wirigue dujaacʉ̃ gamebirica. Mague warã erã oaboarã turabiribocoma. Eropigʉ erãre bari ejotudiaca, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ĩgʉ eroparĩcʉ̃ gʉa ĩgʉ buherã ĩgʉre serẽpibʉ: —¿Duhpii mari õguere masa mariroguere barire bocabocuri erã bajarã masare ejoburire? arĩbʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Dinʉcʉ dipuru pan dipurure opari mʉa? arĩmi gʉare. —Siete pan dipuru, bajamerãgã waire opaa, arĩ yʉhribʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Gʉa eroparĩcʉ̃ peegʉ ĩgʉ masare taa weca doadoremi. ");
INSERT INTO des_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tuhajanugu siete pan dipurure, waigã sãre aĩ, ĩgʉ Pagʉre “Õhaa,” arĩ serẽtuhaja, pan dipurure nuha, gʉare ĩgʉ buherãre omi. Eropirã gʉa ĩgʉ buherã iri barire masare guerebʉ. ");
INSERT INTO des_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Eropirã masa irire baha, yapia wama. Erã ba dʉharare siete puiri gohra aĩ gameneo ʉjʉtu dobobʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ero banirãre ʉma dihtare queocʉ̃ cuatro mil gohra árĩma. Nome, majirãgã sã árĩma. ");
INSERT INTO des_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Erã eropa batuhajacʉ̃ Jesu masare goerisere, dohodirugue ñaja, Magdala waĩcʉri yebague gʉare sihu ejami. ");
INSERT INTO des_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Eropi fariseo masa, saduceo masa mera Jesu pohrogue erama. “Ĩgʉ Goãmʉ ĩgʉ obeodigʉ árĩbeami,” arĩ ĩadiariñuma. Eropirã ĩgʉre Goãmʉ turari mera deyoro moarire ĩgʉ ii ĩhmucʉ̃ gamerima. Ĩgʉ ii ĩhmumasibiricʉ̃ “Goãmʉ obeodigʉ árĩbeami,” arĩdiarima. ");
INSERT INTO des_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Erã ĩgʉre deyoro moarire eropa iidorecʉ̃ Jesu yʉhrimi erãre: —Ñami wacʉ̃ necã õaro boyocʉ̃ ĩarã “Õari ñami árĩroca,” arãa mʉa. ");
INSERT INTO des_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Eropirã boyoropʉre ñipicʉ̃ ĩarã, “Deco ariroca,” arãa mʉa. Ʉmarore ĩhamemujurã, “Õpa waroca,” arĩ masia mʉa. Eropa õaro masiquererã ta dohpague Goãmʉ turari mera mʉare yʉ ii ĩhmuquerecʉ̃ ta ne irire õaro masibeaa mʉa. ");
INSERT INTO des_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dohpague majarã ñetariarã Goãmʉre gamebirã Goãmʉ turari mera ii ĩhmurire ĩadiarima. Deyoro moarire ii ĩhmusome yʉhʉ. Goãmʉ yare weremʉhtadigʉ Jona mʉrʉ ĩgʉre wadirore masituhaa mʉa. Iri dihtare ĩhmugʉra mʉare, arĩ yʉhrimi Jesu. Eropa arĩ weretuhaja gʉare sihu waha wami daja. ");
INSERT INTO des_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wʉari ditarugue gʉa taribujarã panre cãdijicãnirã árĩribʉ. ");
INSERT INTO des_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Eropigʉ Jesu gʉare weremi: —Fariseo masa saduceo masa erã pan bʉgacʉ̃ iiburire õaro masique mʉa. Gʉhya ãhraa, arĩ weremi gʉare: ");
INSERT INTO des_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ĩgʉ eroparĩcʉ̃ pee wisirã gʉa basi irire wereniguibʉ. —Mari panre mari aĩgãribiricʉ̃ ĩagʉ eropa arĩcumi ĩgʉ, arĩ pepiribʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gʉa eropa arĩrare masigʉ, gʉare serẽpimi: —¿Duhpirã panre mʉa cãdijirare guñari mʉa? Merogã gohra yʉre umupeoa mʉa. ");
INSERT INTO des_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Masinibeari mʉa? ¿Cinco mil ʉmare cinco pan dipurure yʉ nuha orare guñabeari mʉa? ¿Erã baha yapira pʉhrʉ doce puiri gohra mʉa ʉjʉtu doborare guñabeari mʉa? ");
INSERT INTO des_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Eropirã daja siete pan dipurure nuha, cuatro mil ʉmare yʉ ora sãre guñabeari mʉa? ¿Erã baha yapira pʉhrʉ dinʉcʉ puiri gohra mʉa ʉjʉtu doborare guñabeari mʉa? ");
INSERT INTO des_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Eropirã pan bʉgacʉ̃ iiburire yʉ werecʉ̃ duhpirã õaro peebeari mʉa? Eropa arĩgʉ pan gohrare arĩgʉ iibeaa. Fariseo masa, saduceo masa erã pan bʉgacʉ̃ iiburire õaro iique, arĩgʉ pan gohrare arĩgʉ iibeaa, arĩ weremi ĩgʉ gʉare. ");
INSERT INTO des_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ĩgʉ eropa arĩ werecʉ̃ gʉa masibʉ. “Pan bʉgacʉ̃ iiburire,” arĩgʉ pan gohrare arĩgʉ iibirimi. Eropa arĩgʉ fariseo masa, saduceo masa erã buherire arĩgʉ iidi árĩrimi gʉare. “Erã ya buherire peebiricãque,” arĩgʉ iimi. ");
INSERT INTO des_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Eropi Jesu mera warã Cesarea Filipo waĩcʉri maca pohro árĩri macague ejabʉ gʉa. Eropigʉ iri macague gʉa ejara pʉhrʉ Jesu gʉare ĩgʉ buherãre serẽpiñami: —¿Nihino árĩcuri yʉhʉ masa erã pepicʉ̃? arĩ serẽpimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—“Ñu waĩyegʉ ãhrimi,” arĩma mʉre gajirã. Gajirã “Elia ãhrimi,” arĩma. Gajirãpʉ “Jeremia árĩbocumi o gajigʉ Goãmʉ yare weremʉhtanirã mera majagʉ árĩbocumi,” arĩma, arĩ yʉhribʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Mʉapʉ pepicʉ̃ nihino árĩcuri yʉhʉ? arĩ serẽpimi ĩgʉ gʉare daja. ");
INSERT INTO des_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Pedropʉ yʉhrimi: —Mʉhʉ Cristo Goãmʉ obeodigʉ ãhraa. Goãmʉ ojocarigʉ magʉ ãhraa mʉhʉ, arĩ yʉhrimi Simo Pedro. ");
INSERT INTO des_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Simo, Jona magʉ, mʉhʉ mucubirigʉ ãhraa. Õpa arĩ mʉ yʉre yʉhrira masa erã werera árĩbeaa. Yʉ Pagʉ ʉmaro majagʉpʉ irire mʉre masicʉ̃ iiami. ");
INSERT INTO des_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mʉre arĩgʉ tiiaa. Mʉhʉ Pedro waĩcʉgʉ ãhraa. (Pedro arĩgʉ ʉtãye arĩgʉ iipʉ.) Iye ʉtãye weca wʉari wihire yʉ iibodiro dopa ta yaharãpʉre yuju curu wʉari curu árĩcʉ̃ iigʉca yʉhʉ. Eropigʉ watĩ ĩgʉ yarã mera yaharãre tarinʉgasome. Eropirã yaharã ne peamegue wasome. ");
INSERT INTO des_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ʉmaro majagʉ mari Opʉ ĩgʉ árĩro maja sawire mʉre ogʉra. Eropigʉ i yebaguere mʉ iidorebiricʉ̃ yʉ sã ʉmarogue árĩgʉ iidoresome. I yebaguere mʉ iidorecʉ̃ ʉmarogue yʉ sã iidoregʉra, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ĩgʉ eropa arĩra pʉhrʉ gʉare ĩgʉ buherãre weremi: —Yʉre “Cristo ãhrimi ĩgʉ,” ne arĩ weresiribiricãque gajirãre, arĩmi gʉare. ");
INSERT INTO des_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Irisubure ta Jesu gʉare ĩgʉ buherãre õaro werepehonʉgami: —Jerusaléngue yʉre waro gahmea dohpaguere. Erogue majarã, mʉrã, pahia oparã, mari masare buherã sã yʉre ñero iirãcoma. Eropirã yʉre wejẽrãcoma. Eropa ta ñero tariro gahmea yʉre. Eropigʉ ʉhrenʉ pʉhrʉ ta masa mʉriagʉca, arĩ weremi gʉare ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ĩgʉ eroparĩcʉ̃ peegʉ Pedropʉ gajipʉ ñarigã Jesure aĩgã, ĩgʉre õpa arĩmi: —Opʉ, eropa arĩbiricãque. Mʉ arĩro dopa wabiricãporo. Mʉre erã wejẽbiricãporo, arĩrimi ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu majinʉgaja, ĩgʉre õpa arĩmi: —Satana iro dopa wereniguigʉ iiaa mʉhʉ. Eropa arĩbiricãque. Mʉ pepiri masa ya pepiri ãhraa. Goãmʉ ya pepiri árĩbeaa. Eropigʉ yʉ iiborore cãhmotadiaa mʉhʉ, arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ĩgʉ eropa arĩra pʉhrʉ gʉare weremi: —Yujugʉ yʉ mera majagʉ árĩdiagʉ, ĩgʉ gamero iidiarire duhucãgʉcumi. Eropigʉ ĩgʉ yʉ mera majagʉ árĩri dipuwaja ñero tarigʉcumi. Eropa ñero tariqueregʉ ta yahare iiniguicãgʉ árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yujugʉ masʉ ĩgʉ ya árĩburi dihtare pepigʉ ĩgʉ dederea wagʉcumi. Eropigʉ yujugʉ masʉ yaha árĩburi dihtare iigʉ árĩpehrerinʉri yʉ mera ʉmarogue õaro árĩgʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yujugʉ masʉ i yeba majare árĩpehrerire opaqueregʉ peamegue wagʉ õarire wajatasome. Eropigʉ i yebague opaburi dihtare guñagʉ, ĩgʉ sĩrigʉ waburire guñabigʉ ĩgʉ sĩporã mera peamegue dederegʉcumi. ");
INSERT INTO des_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉhʉ masʉ Goãmʉ obeodigʉ yaharã anyua mera i yebague dujarigʉca. Yʉ Pagʉ ĩgʉ gosesiriri mera dujarigʉ árĩpehrerã masare erã ñeri iira dipuwaja dipuwaja moagʉra. Erã õaripʉre erã iicʉ̃ õaro iigʉra erãre. ");
INSERT INTO des_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Diaye arĩgʉ tiiaa. Yujurãyeri mʉa õguere árĩrã mʉa sĩriboro core yʉre yʉ opʉ arigʉ árĩcʉ̃gue ĩarãca, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Eropi seis nʉri pʉhrʉ Jesu Pedrore, Santiagore, ĩgʉ pagʉ magʉ Ñu sãre ʉmadigʉ ʉtãgʉgue erã dihtare sihumʉriapʉ. ");
INSERT INTO des_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ʉmarogue erã mʉrijara pʉhrʉ erã ĩhabeoro ĩgʉ dʉpʉre gohrotopʉ. Ĩgʉ diapo abe ʉmʉ majagʉ iro dopa gohra gosesiriyoro. Eropiro ĩgʉ suhri gosesiriri suhri õaro boreriñe wayoro. ");
INSERT INTO des_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mata iribojegue majarã Moise mʉrʉ Elia mʉrʉ sã dehyoañorã. Eropirã Jesu, Moise, Elia mera ĩgʉ weretamucʉ̃ ĩañorã erã ʉrerã ĩgʉ buherã. ");
INSERT INTO des_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Eropigʉ Pedro Jesure arĩpʉ: —Opʉ, mari ohõ árĩcʉ̃ õadiaa. Mʉ gamecʉ̃ ʉhre wihigã iirã. Mʉ ya wihigã, Moise ya wihigã, Elia ya wihigã iirã mari, arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ĩgʉ eropa arĩ wereniguirisubu, imica curu õaro gosesiriri curu erãre cãhmotacãyoro. Eropa wacʉ̃ imica curu pohecague Goãmʉ ĩgʉ wereniguiri bʉsʉyoro: —Ihĩ yʉ magʉ yʉ mahigʉ ãhrimi. Ĩgʉ mera mucubiria. Ĩgʉre peeque, arĩri bʉsʉyoro. ");
INSERT INTO des_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Eropa arĩro caricʉ̃ peerã ĩgʉ buherã ʉca mehmereja wañorã. ");
INSERT INTO des_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Erã eropa wara pʉhrʉ Jesu erã pohrogue eja, erãre bʉacare ñahpʉ: —Wahgãnʉgajaque mʉa. Güibiricãque, arĩpʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ĩgʉ eroparĩcʉ̃ erã ĩhabeo, Jesu dihtare ĩañorã. Gajirãre ĩabiriñorã. ");
INSERT INTO des_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eropirã ʉtãgʉgue erã dijaricʉ̃ Jesu erãre turaro mera arĩpʉ: —Dohparagã yʉre eropa warare gajirãre ne werebiricãque. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉhʉ sĩri masa mʉriara pʉhrʉ irire gajirãre wereque mʉa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ĩgʉ buherãpʉ ĩgʉre serẽpiñorã: —“Cristo Goãmʉ beyedigʉ ĩgʉ ariboro core Eliare arimʉhtaro gahmea,” arĩma masare buherã. ¿Dohpa arĩronore eropa arĩri erã? arĩ serẽpiñorã erã ĩgʉre: ");
INSERT INTO des_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu yʉhripʉ: —Diaye ta ãhraa. Eliare arimʉhtadoremi Goãmʉ árĩpehrerire amumʉhtabure. ");
INSERT INTO des_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Õpa arĩgʉ mʉare arĩgʉ iiaa. Elia eratuhajami. Ĩgʉ eropa eraquerecʉ̃ ta erã ĩgʉre ne ĩha masibirima. Eropirã erã gamero dopa ñero iinirã árĩma ĩgʉre. Eropa ta iirãcoma yʉ masʉre Goãmʉ ĩgʉ obeodigʉre. Erã eropa iicʉ̃ ñero tarigʉca yʉhʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ĩgʉ eropa arĩ werecʉ̃ erã peeñorã. “Elia,” arĩgʉ, Ñu waĩyegʉre weregʉ iipʉ. Irire masiñorã pare erã. ");
INSERT INTO des_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eropirã ʉtãgʉgue mʉrijanirã erã ʉrerã Jesu mera dijararã gʉa pohrogue erama bajarã masa árĩrogue. Erã eracʉ̃ ĩagʉ yujugʉ ʉmʉ Jesu pohrogue eja, merejami. ");
INSERT INTO des_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Opʉ, yʉ magʉre mojomoro ĩaque. Ĩgʉ ñama sĩriri mʉrare dorecʉgʉ ãhrimi. Eropigʉ ĩgʉ ñetariaro tarimi. Bajasuburi peamegue mehmerejamʉrimi ĩgʉ. Yujuyerisuburi diaguere yuri ñajamʉrimi. ");
INSERT INTO des_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eropigʉ mʉ buherã pohrogue aĩ erarabʉ. Erã ĩgʉre õagʉ wacʉ̃ iimasibirama, arĩmi ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu arĩmi ero árĩrãre: —Dohpague majarã mʉa ñerã ãhraa. ¿Yʉre ne umupeobirigohracãri? Yoari boje mʉare buherabʉ yʉhʉ. ¿Dipẽ yoari boje yʉre mʉa garibori? Ĩgʉre aĩgãrique yʉre, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ĩgʉ majigʉre erã aĩ eratuhajacʉ̃ ĩha Jesu watĩre tuhri cóãmi. Eropigʉ mata õagʉ wami ĩgʉ magʉ. ");
INSERT INTO des_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pʉhrʉ gʉa ĩgʉ buherã gʉa seyaro árĩrã Jesure serẽpibʉ: —¿Duhpirã gʉapʉ ĩgʉ magʉre watĩre cóãmasibirayuri? arĩ serẽpibʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu yʉhrimi: —Yʉre daberogã umupeoa mʉa. Diaye ta mʉare weregʉ iiaa. Goãmʉre “Diaye ta iigʉ ãhrimi,” mʉa arĩ umupeorã miriyegã mostazaye pegã mʉa umupeoquererã irigʉ ʉtãgʉre “Sohõgue waque,” mʉa arĩcʉ̃, waha waroca. Goãmʉre eropa umupeorã árĩpehrerire iimasia mʉa. ");
INSERT INTO des_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ino watĩre mʉa cóãdiarã Goãmʉre bʉrigã serẽro gahmea mʉare. Eropirã ba duhuro gahmea Goãmʉre serẽmorã, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Eropi Galilea yebague gʉa curicʉ̃, Jesu gʉare weremi: —Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. Masa yʉre ñeha, gajirãguere yʉre wiarãcoma. ");
INSERT INTO des_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Eropa yʉre erã wiara pʉhrʉ wejẽrãcoma erã. Eropa erã wejẽdigʉ ʉhrenʉ pʉhrʉ masagʉca, arĩmi ĩgʉ gʉare. Ĩgʉ eropa arĩ werecʉ̃ pee bʉrigã bʉjawerebʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Eropirã Capernaum macague gʉa ejacʉ̃, Goãmʉ wihi maja wajayeburire wajasea corerã Pedro pohrogue eja, ĩgʉre serẽpiñama: —¿Mʉare buhegʉ Goãmʉ wihi maja árĩburire wajayeri ĩgʉ? arĩ serẽpima erã. ");
INSERT INTO des_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Wajayemi ĩgʉ, arĩ yʉhrimi Pedro. Ĩgʉ eropa arĩra pʉhrʉ wihigue ĩgʉ ñajacʉ̃ ta Jesu Pedrore serẽpimʉhtami: —Simo, ¿dohpa arĩ pepiri mʉhʉ? ¿I yeba majarã oparã ñehmarãpʉre waja aĩri mʉ pepicʉ̃? ¿Erã mera majarãre wajaseari? ¿O gaji yeba majarãpʉre wajaseari? arĩ serẽpimi ĩgʉ Pedrore. ");
INSERT INTO des_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Gaji yeba majarãpʉre wajaseama, arĩ yʉhrimi Pedro. Ĩgʉ eroparĩcʉ̃ Jesu weremi: —Eropigʉ opʉ ĩgʉ ya yeba majarãre wajaseabirimʉririmi. ");
INSERT INTO des_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Eropa árĩquerecʉ̃ ta wajasea corerãre guacʉ̃ iidiabeaa mari. Eropirã wajayerãca. Ditarugue waque. Erogue eja wejericãrore mehyuque. Eropigʉ waimʉ bamʉhtadigʉre tara suaque. Eropigʉ ĩgʉ waimʉ disirogue niyerusere bocajagʉca mʉhʉ. Irise queoro wajacʉroca. Yʉre, mʉa sãre Goãmʉ wihi maja árĩburire erã wajaseacʉ̃ õaro queoro sihajaroca irise. Irisere bocajagʉ mari wajamoriñere wajayepehogʉ waque, arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Irisubure gʉa Jesu buherã ĩgʉ pohrogue eja serẽpibʉ ĩgʉre: —¿Ʉmaro majagʉ ĩgʉ opʉ árĩroguere gʉa mera majagʉ nihino wabocuri árĩpehrerã weca opʉ? arĩ serẽpibʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Gʉa eroparĩcʉ̃ Jesu majigʉgãre sihubeo, ĩgʉgãre gʉa watope duhudobomi. Duhudobotuhaja gʉare arĩmi. ");
INSERT INTO des_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Diaye mʉare were purumujugʉra. Oã majirãgã Goãmʉre erã opʉ gohra pepima. Eropirã mʉa sã erã iro dopa ta pepirã, õarire gohrotorã ʉmaro majagʉ opʉ árĩroguere warãca. Erã iro dopa pepibirã opʉ ĩgʉ árĩroguere wasome mʉa. ");
INSERT INTO des_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Eropigʉ ʉmaro majagʉ ĩgʉ opʉ árĩroguere eropa pepicãgʉ, ihĩ majigʉgã dopa pepigʉ ta gajirã tauro opʉ wahami. ");
INSERT INTO des_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Eropirã yahare iimorã õpa árĩgʉgãre gamerã, yʉ sãre gahmea mʉa, arĩ weremi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Eropigʉ õpa werenemomi: —Ĩgã dopa árĩgʉ yʉre ne umupeogʉre weregʉra mʉare. Yujugʉ ĩgã iro dopa árĩgʉre ñerire iidoredigʉ ĩgʉ ñetariaro tarigʉcumi. Gajigʉre masa ĩgʉ wʉnʉgʉre wʉariye ʉtãye mera dirisiu, wʉariyague ĩgʉre cóãcʉ̃ ñero wabocumi ĩgʉ. Eropigʉ ĩgã dopa árĩgʉre ñerire iidoredigʉpʉ wʉariyague erã cóãdigʉ tauro ñero tarigʉcumi. Ĩgʉ turaro dipuwaja moasũgʉcumi. ");
INSERT INTO des_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Masare ñerire iicʉ̃ iiri ãhraa. Irire iirã i yeba majarã ñero tarima. Gajirã ñerire iidorema gajirã masare. Erã ñerire iidorenirãpʉ erã tauro ñetariaro tarirãcoma. ");
INSERT INTO des_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Mʉ mojoto mera ñero iigʉ iri mojotore mʉ tabe cóãbodiro dopa ta iri ñerire duhuque. Irire duhubigʉ peamegue wagʉca. Eroguere ne peame yaribeaa. Mʉ mojotore mʉ cóãcʉ̃ iri dʉca dihta cohmoboya. Eropigʉ mʉpʉ epasi árĩqueregʉ ta pʉhrʉ Goãmʉ mera árĩgʉca. Mʉ pe mojoto mera árĩgʉre peamegue ĩgʉ cóãcʉ̃ ñetariaro tarigʉca. Eropigʉ iri ñeri iiripʉre duhuque. Mʉ guburu mera ñero iigʉ iri guburu sãre mʉ tabe cóãbodiro dopa ta iri ñerire duhuque. Irire duhubigʉ peamegue wagʉca. Eroguere ne peame yaribeaa. Mʉ guburure mʉ cóãcʉ̃ irisi dihta cohmoboya. Eropigʉ epasi árĩqueregʉ ta pʉhrʉ Goãmʉ mera árĩgʉca. Mʉhʉ pe guburu mera árĩgʉre mʉre peamegue cóãcʉ̃ mʉ ñetariaro tarigʉca. Eropigʉ iri ñeri iiripʉre duhuque. ");
INSERT INTO des_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mʉ cuiru mera ñero iigʉ irirure mʉ gorawea cóãbodiro dopa ta iri ñerire duhuque. Irire duhubigʉ peamegue wagʉca. Eroguere ne peame yaribeaa. Mʉ cuirure cóãcʉ̃ iriru dihta cohmoboya. Yujupʉ cuiru mariquerecʉ̃ ta pʉhrʉ Goãmʉ mera árĩgʉca. Mʉre pe cuiru mera árĩgʉre peamegue mʉre cóãcʉ̃, mʉ ñetariaro tarigʉca. Eropigʉ iri ñeri iiripʉre duhucãque, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Eropigʉ gʉa sãre werenemomi: —Ne, oã majirãgãre doobiricãque. Mʉare arĩgʉ tiiaa. Erãgãre ĩhadiburã anyua ʉmarogue yʉ Pagʉ pohrogue eropa árĩniguima. ");
INSERT INTO des_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ i yebague dederebonirãre taugʉ arigʉ iibʉ yʉhʉ, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Eropa arĩtuha õpa arĩ queorire ahmu wereniguimi. —Ovejare ĩhadibugʉ cien ovejare opagʉ yujugʉ oveja dederea wacʉ̃ ĩagʉ õpa iigʉcumi erãre ĩhadibugʉpʉ. Gajirã ovejare noventa y nueve ovejare erã bari campogue duhudobo, dederedigʉre amagʉ wagʉcumi. ");
INSERT INTO des_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Diaye ta arĩgʉ iiaa mʉare. Ĩgʉre bocagʉ bʉrigã mucubirigʉcumi ĩgʉ. Gajirã noventa y nueve dʉhyarã mera mucubiridigʉ árĩqueregʉ erã tauro ĩgʉ bocadigʉpʉre mucubirigʉcumi. ");
INSERT INTO des_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eropa ta mari Pagʉ ʉmaro majagʉ oãgã iro dopa árĩrã sãre erã dederecʉ̃ gamebeami, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Eropa arĩtuhaja õpa werenemomi Jesu: —Mʉ acaweregʉ mʉre ñero iicʉ̃ ĩgʉ mera weretamugʉ waque. Mʉa seyaro irire weretamuque. Mʉ eropa iicʉ̃ ĩgʉ mʉre peebocumi. Ĩgʉ peecʉ̃ “Mʉre dipaturi ne õpa iisome yʉhʉ,” ĩgʉ arĩcʉ̃ mʉ acaweregʉre dipaturi wapicʉ iigʉca mʉhʉ. ");
INSERT INTO des_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mʉre ĩgʉ peediabiricʉ̃ tamerare yujugʉ mera wadiagʉ, o perã mera wadiagʉ, erãre wapicʉgã dipaturi ĩgʉre wereniguigʉ waque daja “Erã sã peeporo,” arĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Eropigʉ mʉ mera majarã sãre ĩgʉ peediabiricʉ̃ árĩpehrerã Jesu yarã mera gamenere ĩgʉre weresãque. Eropirã Jesu yarã gamenererã sãre ĩgʉ peediabiricʉ̃ ĩarã Goãmʉre masibigʉ ñegʉ árĩro dopa iique ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Diaye ta mʉare arĩgʉ iiaa. I yeba mʉa yaharã yaha dorerire oparãca. Eropirã mʉa i yebare iidorebirirare yʉ sã ʉmarogue árĩgʉ iidoresome. I yeba mʉa iidorerare yʉ sã ʉmarogue iidoregʉca. ");
INSERT INTO des_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Dipaturi mʉare ire weregʉra daja: Mʉa perã Goãmʉre serẽrã, yujuro mera pepirã árĩcʉ̃, yʉ Pagʉ ʉmaro majagʉ irire mʉare ogʉcumi. ");
INSERT INTO des_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Perã o ʉrerã yaharã yahare iimorã erã gamenerecʉ̃ yʉ sã erã mera ãhraa, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pʉhrʉ Pedro Jesu pohrogue eja serẽpimi: —Opʉ, ¿yʉ acaweregʉ mʉ yagʉ ĩgʉ dinʉcʉsuburi yʉre ñero iicʉ̃ ĩagʉ irire cãdijitugʉcuri yʉhʉ? ¿O siete suburi ĩgʉ iicʉ̃ cãdijitugʉcuri yʉhʉ? arĩ serẽpimi Pedro. ");
INSERT INTO des_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu yʉhrimi: —Sietesuburi dihta mʉre ĩgʉ ñero iirare mʉ cãdijicʉ̃ ero wabeaa. Bajasuburi ĩgʉ mʉre ñero iicʉ̃ sãre cãdijique, arĩmi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Eropigʉ Jesu õpa werenemomi gʉare: —Ʉmaro majagʉ opʉ árĩri werediacʉ̃ õpa ãhraa. Yujugʉ opʉ ĩgʉ pohro majarãre erã ĩgʉre wajamorare wajayepeho dorediariñumi. ");
INSERT INTO des_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Erã wajamorare ĩgʉ queonʉgacʉ̃, ĩgʉre mohme corerãpʉ wʉaro wajamogʉre ĩgʉ pohrogue aĩgãriñuma. Wajamogʉpʉ wʉaro wajamoñumi opʉre. ");
INSERT INTO des_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Eropigʉ ĩgʉ wajayemasibiricʉ̃ ĩagʉ ĩgʉ opʉ ĩgʉre, ĩgʉ marapore, ĩgʉ porã sãre pohro majarã acu, erãre gajirãre duadiariñumi ĩgʉ wajamorire wajaseagʉ. ");
INSERT INTO des_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ĩgʉ eropa duadiacʉ̃ wʉaro wajamogʉpʉ mereja, ĩgʉ opʉre turaro serẽñumi: “Opʉ, gʉare gajirãre duabiricãque. Mojomoro ĩagʉ corenique. Mʉre wajayepehogʉca,” arĩñumi ĩgʉ ĩgʉ opʉre. ");
INSERT INTO des_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ĩgʉ eroparĩcʉ̃ peegʉ ĩgʉre mojomoro ĩagʉ, ĩgʉ wajamorare eropa ta cãdijipehocãñumi. ");
INSERT INTO des_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ĩgʉ eropa iira pʉhrʉ wajamodigʉpʉ waha, gajigʉ pohro majagʉre bocajañumi. Ĩgʉpʉ merogã wajamoñumi ĩgʉre wajamodigʉpʉre. Eropa bocajagʉ yojaro mera ñeañumi ĩgʉre. “Yʉre mʉ wajamorare wajaye purumujuque duru,” arĩñumi ĩgʉ ĩgʉ mera majagʉre. ");
INSERT INTO des_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ĩgʉ eroparĩcʉ̃ gajigʉ pohro majagʉpʉ mereja ĩgʉre bʉrigã serẽriñumi: “Yʉre mojomoro ĩaque. Merogã corenique. Mʉre wajayepehogʉra,” arĩriñumi gajigʉ pohro majagʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ĩgʉ eropa arĩ serẽquerecʉ̃ ta ĩgʉ yʉhribiriñumi. Eropigʉ ĩgʉ gajigʉ pohro majagʉpʉre peresu iidoreñumi ne ĩgʉ wajayepehocʉ̃gue. ");
INSERT INTO des_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wʉaro wajamodigʉ ĩgʉre merogã wajamogʉpʉre ĩgʉ eropa iicʉ̃ ĩha papũri, gajirã pohro majarãpʉ erã opʉre weresãrã wañuma. ");
INSERT INTO des_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Erã eropa arĩ weresãcʉ̃ peegʉ erã opʉ erãre weresãdigʉre sihubeo õpa arĩñumi: “Mʉhʉ ñetariagʉ ãhraa. Mʉhʉ yʉre bʉrigã serẽcʉ̃ mʉ wajamorare cãdijipehocãrabʉgʉ yʉhʉ mʉre. ");
INSERT INTO des_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mʉre yʉ eropa iiquerecʉ̃ ta mʉpʉ merogã wajamogʉpʉre cãdijibirayoro mʉhʉ. Mʉ wajamorare yʉ cãdijidiro dopa ta ĩgʉ sãre mʉ cãdijicʉ̃ õatariaboya. ¿Duhpigʉ ĩgʉre mojomoro ĩabirari ĩgʉre eropa iigʉ mʉhʉ?” arĩñumi ĩgʉ opʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Eropa arĩgʉ bʉrigã guagʉ, peresu iiñumi ĩgʉ pohro majagʉre ne ĩgʉ wajayepehocʉ̃gue, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Eropigʉ õpa arĩ i queorire weretumi: —Eropa ta iigʉcumi yʉ Pagʉ ʉmaro majagʉ mʉare. Mʉa árĩpehrerã mʉa acawererã mʉare ñero iirare õaro mʉa cãdijipehobiricʉ̃ ĩgʉ mʉare dipuwaja moagʉcumi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Irire ĩgʉ eropa arĩ werera pʉhrʉ ĩgʉ Galilea árĩdigʉ Judea yebague gʉare sihu wami. Dia Jordán waĩcʉriya gajipʉ masegue ejabʉ. ");
INSERT INTO des_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Erogue gʉa wacʉ̃ bajarã masa gʉare nʉrʉsiagãma. Erã mera majarãre dorecʉrãre õarã wacʉ̃ iimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eropi yujurãyeri fariseo masa gʉa pohro erama. Jesure weresãdiarã, ñero ĩgʉ wereniguicʉ̃ peediarã, ĩgʉre õpa serẽpima: —¿Mari marapore mari gamero cóãcʉ̃ õhari? ¿Mari doreripʉ eropa ta iidoreri mʉ pepicʉ̃? arĩ serẽpima erã. ");
INSERT INTO des_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu yʉhrimi. —¿Goãmʉ yare erã gojarapũgue ne ire buhebiriniari mʉa? Õpa arĩ gojara ãhraa: “Negohraguere i yebare ĩhacũnugudigʉ ʉmʉ, nomeo sãre iipʉ,” arĩ gojañumi Moise. ");
INSERT INTO des_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Õpa ãhraa ĩgʉ arĩ gojanemora: “Eropigʉ ʉmʉ ĩgʉ pagʉ sʉmarãre cohã wiria, ĩgʉ marapo mera árĩgʉcumi. Eropirã erã perã árĩquererã ta yuju dʉpʉ iro dopa ta árĩrãcoma,” arĩ gojañumi. ");
INSERT INTO des_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eropirã erã perã iro dopa árĩbeama. Yuju dʉpʉ iro dopa ta árĩrã iima. Goãmʉ doreri mera mojoto dirima. Eropirã duhubiricãro gahmea erãre, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ĩgʉ eroparĩcʉ̃ fariseo masa serẽpima daja: —Mʉhʉ eropa werequerecʉ̃ ta õpa arĩ gojañumi Moisepʉ: “Mʉ marapore cóãdiagʉ paperapũgue irire gojaque. Eropa gojagʉ iripũre mʉ marapore mʉ ora pʉhrʉ igore cóãmasia mʉhʉ,” arĩ gojañumi Moise. ¿Mʉ arĩro dopa arĩquerecʉ̃ ta duhpigʉ Moisepʉ eropa arĩ gojayuri? arĩ yʉhrima erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu yʉhri gamemi erãre: —Goãmʉ dorerire mʉa ñecʉ sʉmarã erã iidiabiricʉ̃ ĩagʉ “Eropa ta wacuraporo,” arĩgʉ, “Mʉa marapore cóãmasia,” arĩ gojañumi Moise. Ĩgʉ eropa arĩ gojara árĩquerecʉ̃ ta negohraguere mʉa marasã nomere cóãcʉ̃ gamebiripʉ. ");
INSERT INTO des_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mʉare arĩgʉ tiiaa: Masʉ ĩgʉ marapo igo gajigʉ mera ñero iibiriquerecʉ̃ ta igore cóãgʉ, gajigo mera marapocʉgʉ, ĩgʉ gajigo mera ñero iigʉ iimi. Eropigʉ ihĩ cóãdigo mera marapocʉgʉ sã igo mera ñero iigʉ iimi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ĩgʉ eroparĩcʉ̃ peerã, gʉa ĩgʉ buherãpʉ õpa arĩbʉ: —Eropa ʉmʉ ĩgʉ marapo mera erã game cóãbiricʉ̃, maripʉre ne marapo marirã árĩcʉ̃ õaboca gʉare, arĩbʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu yʉhrimi gʉare: —Mʉa arĩro dopa ta árĩpehrerã árĩmasibeama. Goãmʉ marapocʉdorebirinirã dihta eropa árĩmasima. ");
INSERT INTO des_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ʉma marapocʉmasibirã yujurãyeri ãhrima. Yujurãyeri ʉma ero ta poyari masa mata nomere gamebirã masa dehyoama. Gajirã masa erã ãpiritõ diuri erã weanirãpʉ marapocʉmasibeama. Gajirã ʉma ʉmaro majagʉ erã Opʉ yare itamudiarã marapocʉbeama. Eropirã oã marapocʉdiabirã eropa ta pepicãrã, eropa ta erã árĩ ojogorocʉcʉ̃ õhaa, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Eropi masa majirãgãre Jesure mohmepiñadoremorã Jesu pohrogue aĩ erama. Eropa aĩ erarã, erã Jesure ĩgʉ mojotore erãgãre mohmepidorediama. Eropirã erãgãre erã õaro árĩburire Goãmʉre serẽbasadorediama Jesure. Erã eropa iicʉ̃ ĩarã gʉa ĩgʉ buherã erãre turiribʉ. ");
INSERT INTO des_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gʉa eropa turicʉ̃ ĩagʉ, gʉare Jesu õpa arĩmi: —Majirãgã yʉ pohrogue ariporo. “Waque,” arĩbiricãque erãgãre. Erãgã Goãmʉre erã opʉ pepima. Eropirã ĩgʉ ʉmaro majagʉ ĩgʉ opʉ árĩroguere oãgã iro dopa pepirã ãhrima eroguere, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Eropa arĩtuhaja erã majirãgãre mohmepituhaja waha wami. ");
INSERT INTO des_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ĩgʉ eropa iira pʉhrʉ yujugʉ masʉ mamʉ Jesu pohrogue eraa, serẽpimi ĩgʉre: —Ne mʉhʉ õagʉ buhegʉ ãhraa. ¿Yʉ árĩpehrerinʉri Goãmʉ mera árĩdiagʉ, õarire iidiagʉ dinopʉre iibocuri yʉhʉ? arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Dohpa arĩronore yʉre õagʉ arĩ piyuri mʉhʉ? Goãmʉ dihta õagʉ ãhrimi. Árĩpehrerinʉri Goãmʉ mera árĩdiagʉ ĩgʉ dorerire iique, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Di doreripʉre arĩgʉ iiri? arĩ serẽpinemomi ĩgʉ. Jesu yʉhrimi: —Masare wejẽbiricãque. Gajigʉ marapo mera árĩbita. Yajabita. Gʉyabita. ");
INSERT INTO des_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉ pagʉ sʉmarãre umupeoque. Mʉ basi mahiro dopa ta mʉ pohro árĩgʉ sãre mahique. I dorerire iiro gahmea, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—I dorerire ne tarinʉgabirimʉrabʉ yʉhʉ. ¿Ñeheno dʉhyari yʉ iinemoburi yʉ árĩpehrerinʉri Goãmʉ mera árĩdiagʉ? arĩmi ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu werenemomi: —Mʉhʉ Goãmʉ mera õaro árĩdiagʉ mʉ yare árĩpehrerire duagʉ waque. Eropa duagʉ árĩpehreri niyerure mʉ wajatarare mojomorocʉrãre oque. Mʉ eropa iicʉ̃ wʉaro mʉ ya ʉmaroguere Goãmʉ pohroguere árĩyuroca. Mʉ eropa iira pʉhrʉ yʉ mera majagʉ árĩbu arique, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ĩgʉ wʉaro opagʉ árĩpʉ. Eropigʉ Jesu ĩgʉre eroparĩcʉ̃ peegʉ ĩgʉ oparire mojomorocʉrãre odiabigʉ, turaro bʉjawere sʉabiri waha wami. ");
INSERT INTO des_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ĩgʉ eropa wacʉ̃ Jesu gʉare ĩgʉ buherãre werenemomi: —Diaye ta mʉare arĩgʉ iiaa. Doberi oparã Goãmʉre ĩgʉ opʉ árĩroguere erã wadiacʉ̃ diasa ãhraa. ");
INSERT INTO des_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mʉare werenemogʉra: Camellopʉ awiru gobegãgue ĩgʉ ñajatariwereadiacʉ̃ masiya mara ĩgʉre. Eropa ta doberi opagʉ Goãmʉ opʉ ĩgʉ árĩroguere wacʉ̃ diasataria, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ĩgʉ eroparĩcʉ̃ gʉa ĩhamaria wa gʉa basi õpa arĩbʉ: —Yaho. Ĩgʉ arĩro dopa ta diaye árĩcʉ̃, ne yujugʉ masʉre Goãmʉ taubiribocumi ĩgʉ pohro waborore, arĩbʉ gʉa gʉa basi. ");
INSERT INTO des_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Gʉa eroparĩcʉ̃ Jesu gʉare ĩhabeo, õpa weremi: —Masa erã bocatĩuro erã õaro iira mera Goãmʉ pohroguere wamasibeama. Goãmʉpʉ masare peamegue wabonirãre taumasimi. Ĩgʉ árĩpehrerire õaro iimasipehocãmi, arĩmi ĩgʉ gʉare. ");
INSERT INTO des_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ĩgʉ eroparĩcʉ̃ Pedro ĩgʉre arĩmi: —Peenique. Gʉapʉ gʉa ya árĩpehrerire apipehocãbʉ mʉ mera warã. ¿Gʉa õpa iirã dohpa árĩrire wajatarãcuri gʉa? arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Mʉare diaye arĩgʉ tiiaa: Pehrerinʉ pʉhrʉ árĩpehreri mama gohrotoroca. Irisubuguere yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉ opʉ doaro gosesiriro doagʉca yʉhʉ. Yʉhʉ ero doacʉ̃ mʉa sã doce gohra árĩnirã oparã árĩri mera doarãca. Eropirã Israe masare doce cururi majarãre beyerãca õarã sãre ñerã sãre. ");
INSERT INTO des_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eropirã mʉa árĩpehrerã õari buherire yaha árĩburire iimorã, mʉa wirire, mʉa pagʉ porãre, mʉa pagʉ sʉmarãre, mʉa porãre, mʉa poerire apicãnirã wʉaro wajatarãca. Eropirã árĩpehrerinʉri Goãmʉ mera õaro árĩrãca. ");
INSERT INTO des_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Dohpaguere bajarã oparã árĩnirã mʉra irisubuguere bu árĩrã dujarãcoma. Eropirã dohpaguere bajarã bu árĩnirã mʉra irisubure oparã gohrotorãcoma daja, arĩ weremi Jesu gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Eropi dipaturi Jesu queorire weremi daja õpa arĩgʉ: —Ʉmaro majagʉ opʉ ĩgʉ árĩri werediacʉ̃ pohe opʉ iro dopa ãhraa. Ĩgʉ pohe opʉ boyo pãri merejacʉ̃ ĩgʉ pohere mohmemorãre sihugʉ wañumi. ");
INSERT INTO des_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Yujuse niyerusere yujunʉ mohmeri wajare wajayegʉra yujunʉre,” arĩñumi. “Áʉ,” arĩñuma mohmemorã. Erã eroparĩcʉ̃ pohegue mohmedoregʉ obeoñumi ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Eropigʉ ʉmʉgue nueve árĩcʉ̃ doberi duarogue wañumi daja. Erogue ejagʉ, gajirã mohmebirãre ĩañumi. ");
INSERT INTO des_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eropa ĩagʉ erãre arĩñumi: “Mʉa sã yaha pohere mohmerã waque. Õaro wajayegʉra,” arĩñumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eropirã erã pohegue mohmerã wañuma. Eropi pohe opʉ goeri boje árĩcʉ̃, ñamicague tres árĩcʉ̃ sãre gajirãre mohmedoreñumi daja. ");
INSERT INTO des_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Eropi ñamicague cinco árĩcʉ̃gue doberi duarogue ĩgʉ wañumi daja. Erogue eja gajirã mohmeri moorãre ĩañumi. Erãre arĩñumi: “¿Ne gajino iibiriquererã yujunʉre ĩaniguineacãri mʉa?” arĩ serẽpiñumi erãre. ");
INSERT INTO des_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ne gʉare mohmeri mara,” arĩ yʉhriñuma erã. “Mʉa sã yaha pohere mohmerã waque,” arĩñumi erãre. Eropirã ĩgʉ arĩdiro dopa ta ĩgʉ ya pohere mohmerã wañuma. ");
INSERT INTO des_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Eropi ñamicague mohme duhurisubugue árĩcʉ̃ pohe opʉ ĩgʉ mohmerãre coregʉre õpa arĩñumi: “Mohmerãre sihuque. Erã eracʉ̃ erãre wajayeque. Erã pʉhrʉgue mohmedorenirãre wajayemʉhtaque. Erãre wajayetuha, gajirã sãre wajayetuha, yʉ mohmedoremʉhtanirãre wajaye ojogorocʉque,” arĩñumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Eropigʉ cinco árĩcʉ̃ mohmenʉganirãre yujuse niyeruse wajayeñumi. ");
INSERT INTO des_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ĩgʉ eropa wajayecʉ̃ ĩarã, “Gʉare tauñariro wajayegʉcumi,” arĩ pepiriñuma ĩgʉ doremʉhtanirãpʉ. Erã sãre yujuropa ta wajayecãñumi. ");
INSERT INTO des_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eropirã erãre niyerure ĩgʉ wajayetuhajacʉ̃ erã opʉ mera papũri ĩgʉre arĩñuma: ");
INSERT INTO des_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Oã gʉa pʉhrʉgue mʉ mohmedorenirãpʉ yuju hora ta mohmeama. Gʉapʉ yujunʉ õaro mohmeneacarabʉ. Ñero abe asiami gʉare. Gʉa eropa yoari boje mohmequerecʉ̃ ta gʉa pʉhrʉgue mohmenʉganirã sãre yujuropa wajayecãbʉ mʉhʉ,” arĩ guañuma erã ĩgʉ mera. ");
INSERT INTO des_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Erã eroparĩcʉ̃ peegʉ yujugʉ erã mera majagʉre pohe opʉ yʉhriñumi: “Ne acaweregʉ, yujuse niyerusere wajayegʉra, arĩrabʉ mʉare. Yʉ eroparĩcʉ̃ yʉhriabʉ mʉa. Eropigʉ yʉ arĩdiro dopa ta mʉare wajayeabʉ yʉhʉ. Queoro wajayeabʉ mʉare. Ne yajabirabʉ mʉare. ");
INSERT INTO des_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eropigʉ yʉ wajayerare aĩ wihigue dujaaque. Ĩre pʉhrʉ yʉ mohmedoredigʉ sãre mʉare yʉ wajayediropẽ ta wajayegʉra. ");
INSERT INTO des_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yaha niyeru ãhraa i. Eropigʉ yʉ gamero dopa ta i mera wajayegʉra. ¿Gajirãre tauñariro yʉ wajayecʉ̃ ĩhaturiri mʉhʉ?” arĩñumi ĩgʉ pohe opʉ, arĩ weremi iri queorire Jesu. ");
INSERT INTO des_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Eropa arĩgʉ werenemomi ĩgʉ: —I queori arĩro dopa ta yaharã árĩmʉhtanirãre erã pʉhrʉ yaharã árĩnirã sãre yujuro mera ogʉcumi Goãmʉ ĩgʉ ya õarire. Eropirã árĩmʉhtanirãpʉ “Gʉare onemogʉcumi,” arĩmasibeama, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Eropi Jerusaléngue warã yujuro mera ta waniguirã, gʉare ĩgʉ buherãre sihubeotuha, gajipʉgue gʉare gʉa seyarore aĩgãmi Jesu. Gʉa seyaro gʉa árĩcʉ̃ weremi. ");
INSERT INTO des_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Peeque yʉre. Dohpaguere Jerusaléngue warã iiaa mari. Erogue yʉ masʉre Goãmʉ ĩgʉ obeodigʉre ñeha, gajirãre orãcoma. Pahia oparãre, masare buherã sãre yʉre orãcoma. Eropirã yʉre wejẽdorerãcoma erã. ");
INSERT INTO des_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Eropa wejẽdorerã judio masa árĩbirãre yʉre orãcoma. Erã eropa ora pʉhrʉ erãpʉ yʉre wereya, tãrarãcoma. Tuhaja, crusague pabiarãcoma yʉre. Eropigʉ yʉ sĩrira pʉhrʉre ʉhrenʉ waboro gohra masa mʉriagʉca, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eropigo Zebedeo marapo Santiago, Ñu igo porã mera Jesu pohrogue eja, merejapo ĩgʉre serẽbo arigo. ");
INSERT INTO des_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Dohpa yʉ iicʉ̃ gahmeri mʉhʉ? arĩpʉ Jesu igore. —Mʉhʉ opʉ ñajagʉ yʉ porã sãre dorerã acuque. Eropa acugʉ mʉ pepʉri erãre doboque, arĩ serẽpo igo igo porã mera. ");
INSERT INTO des_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu õpa arĩpʉ: —Mʉa ñero tariborore masibiriquererã ta eropa serẽa mʉa. ¿Dohpaguere yʉ ñero tariboro dopa ta mʉa sã ñero tarirã yujuro bojebocuri mʉa? arĩpʉ Jesu igo porãre. —Yujuro bojerãca, arĩ yʉhriñorã Santiago Ñu mera. ");
INSERT INTO des_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Diaye ta ãhraa. Yʉ ñero taridiro dopa ta ñero tarirãca mʉa sã. Eropa mʉa tarimorã árĩquerecʉ̃ ta yʉ mera doremorãre mʉare yʉhʉ beyemasibeaa. Yʉ Pagʉpʉ amutuhami irire. Eropirã ĩgʉ beyenirã dihta yʉ diayepʉre, yʉ copʉpʉre doarãcoma, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Eropirã gʉa gajirã diez ĩgʉ buherãpʉ erã oparã árĩburire Jesure serẽcʉ̃ Santiago, Ñu sã mera guabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gʉa eropa guacʉ̃ ĩagʉ Jesu árĩpehrerã ĩgʉ buherãre sihu gameneo, õpa arĩ weremi gʉare: —Goãmʉre masibirã oparãpʉ masare dorerã, pũriro mera dorema. ");
INSERT INTO des_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉapʉ eropa iisome mʉa basi. Mʉa mera majagʉ opʉ árĩdiagʉ, árĩpehrerã ĩgʉ mera majarãre itamugʉ árĩporo. ");
INSERT INTO des_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Eropigʉ árĩpehrerãre doregʉ árĩdiagʉ pohro majagʉ iiro dopa ta árĩporo. ");
INSERT INTO des_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Eropa árĩgʉ ta ãhraa yʉ sã. Masare dorebiragʉ arigʉ iibiribʉ. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ árĩqueregʉ ta i yebaguere masare itamugʉ arigʉ iibʉ. Eropigʉ bajarã masa erã ñero iira dipuwajare sĩribasagʉ arigʉ iibʉ. Eropigʉ masa peamegue wabonirãre taugʉ arigʉ iibʉ, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Eropi Jericógue árĩnirã gʉa wacʉ̃ bajarã masa Jesure nʉrʉsiama. ");
INSERT INTO des_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eropi Jesu ĩgʉ tarigãcʉ̃ perã cuiri ĩhajabirã ma tʉro doanirã peema. Eropa peerã õpa arĩ gaguiniguinemoma: —Opʉ Davi mʉrʉ pãrami, masare taubu, gʉare mojomoro ĩaque, arĩ gaguinima. ");
INSERT INTO des_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Erã eropa gaguiniguicʉ̃ masapʉ erãre turima. —Ejarimaricãque, arĩma masa erãre. Erã eropa arĩquerecʉ̃ ta erã gaguiniguidiro tauro gaguiniguinemoma daja. —Opʉ Davi mʉrʉ pãrami, gʉare mojomoro ĩaque, arĩ gaguiniguima daja. ");
INSERT INTO des_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Erã eroparĩcʉ̃ peegʉ Jesu nʉgaja erãre sihubeo serẽpimi, —¿Dohpa yʉ mʉare iicʉ̃ gahmeri? arĩ serẽpimi. ");
INSERT INTO des_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Opʉ, gʉare ĩacʉ̃ iique, arĩ yʉhrima erã. ");
INSERT INTO des_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Erã eroparĩcʉ̃ Jesu erãre mojomoro ĩami. Eropa mojomoro ĩagʉ erã cuirire mohmepimi. Ĩgʉ eropa mohmepicʉ̃ ta erã õaro ĩha wama. Eropa ĩanirã ĩgʉre nʉrʉsia wahgãma. ");
INSERT INTO des_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Eropi Jerusaléngue gʉa ejaboro core Betfagé waĩcʉri macague ejamʉhtanibʉ gʉa Jesu mera. Betfagé ʉtãgʉ Olivo waĩcʉdigʉ gubuye árĩbʉ. Erogue ejagʉ, gʉare perãre ĩgʉ buherã mera majarãre Jesu ĩgʉ core obeomʉhtami. ");
INSERT INTO des_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Õpa doremi erãre: —Si macague waque. Erogue ejarã, mata burrore ĩgʉ magʉgã mera erã dirinugudigʉre bocajarãca. Erãre boca, ĩgʉre diriradarire pãa aĩgãribasaque yʉre. ");
INSERT INTO des_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mʉa eropa iicʉ̃ ĩagʉ, burro opʉ “¿Duhpimorã burrore pãri mʉa?” ĩgʉ arĩcʉ̃ peerã õpa arĩ yʉhrique: “Mari tĩgʉ burrore gamebeoniami dohpa. Eropigʉ dohparagã wiagʉcumi ĩgʉ,” arĩ yʉhrique ĩgʉre, arĩdore obeomi Jesu perã ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eropa iimi Goãmʉ yare weremʉhtadigʉ ĩgʉ arĩ gojadiro dopa ta. Õpa arĩ gojañumi iribojegue: ");
INSERT INTO des_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén majarãre õpa arĩ wereque: “Ĩaque mʉa. Mʉa Opʉ mʉa pohrogue ahrimi. Ĩgʉ ta masare õaro iigʉ ãhrimi. Burro magʉgã weca arigʉcumi,” arĩ wereque Jerusalén majarãre, arĩ gojañumi iribojeguere. ");
INSERT INTO des_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesu ĩgʉ obeonirã perã iri macague eja, ĩgʉ iidorediro dopa ta iiñorã erã. ");
INSERT INTO des_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burragore igo magʉgã sãre aĩgãrima. Aĩgãrituhaja gʉa weca maja suhrire tuwea aĩ, erã weca peobʉ gʉa. Gʉa eropa iira pʉhrʉ Jesu ĩgʉgã weca mʉribejami wabu. ");
INSERT INTO des_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mʉribejatuha, ĩgʉgã weca Jerusaléngue wami. Ĩgʉ eropa aricʉ̃ ĩarã masa bajarã ĩgʉ wari maha deco erã ya weca maja suhrire tuwea aĩ, sẽopi mʉhtama Jesure umupeorã. Gajirãpʉ pũricʉri dʉpʉrire mare apimʉhtama “Ĩgʉ wari maha õari maha árĩporo,” arĩrã. ");
INSERT INTO des_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eropirã ĩgʉ core warã, ĩgʉ pʉhrʉ nʉrʉsiarã mera õpa arĩ gaguiniguima: —Davi mʉrʉ pãramire marire itamubure umupeorã. Ihĩ Goãmʉ ĩgʉ obeodigʉ õaro ariporo. Ʉmaro majagʉre “Turagʉ ãhrimi,” arĩ umupeorã, arĩ gaguiniguima masa. ");
INSERT INTO des_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Eropirã Jerusaléngue erã eropa ejacʉ̃ ero majarãpʉ ĩhamaria wama. —Cue, ¿nihino ãhriri ihĩ? arĩ game serẽpima erã basi. ");
INSERT INTO des_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Gajirã masa yʉhrima: —Ihĩ Goãmʉ yare weremʉhtagʉ Nazare majagʉ Jesu waĩcʉgʉ ãhrimi, arĩ werema erã masare. ");
INSERT INTO des_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pʉhrʉ Goãmʉ wihigue ejami Jesu gʉa mera. Iri wihigue eja ñaja wami. Ñajaja masa duadoarãre asũrã sãre bocajagʉ erãre cohã wiucãmi iri wihigue. Eropigʉ niyerure game gohroto doarã ya mesarire yomemuju, aĩ majipi beomʉrimi. Bujare duarã erã doari pẽrori sãre eropa ta iimi. ");
INSERT INTO des_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Eropa iigʉ õpa arĩmi: —Goãmʉ yare erã gojarapũ õpa ãhraa: Goãmʉ arĩmi: “Yaha wihi Goãmʉ mera wereniguiri wihi waĩcʉroca,” arĩmi Goãmʉ, ãhraa ĩgʉ gojarapũ. Mʉapʉ i wihire Goãmʉ wihire duadoarã game yajarã iiaa, arĩmi ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ĩgʉ eropa iira pʉhrʉ cuiri ĩhajabirã, curimasibirã sã Goãmʉ wihiguere ĩgʉ pohrogue erama. Erã eropa eracʉ̃ erãre õarã dujacʉ̃ iimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Eropa õarire ĩgʉ iicʉ̃ ĩarã, pahia oparã, masare buherã sã guama ĩgʉ mera. Eropirã majirãgã sã Jesure, “Davi mʉrʉ pãrami, masare itamubu, turagʉ ãhraa mʉhʉ,” erã arĩ umupeocʉ̃ peerã guanemoma dipaturi erã. ");
INSERT INTO des_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Eropa guarã õpa arĩma Jesure: —¿Erã eroparĩcʉ̃ peebeari mʉhʉ? Eropa arĩbiricãporo, arĩ dorema erã Jesure. —Erã eroparĩcʉ̃ peea. ¿Goãmʉ yare erã gojarapũre ire ne buhebiriri mʉa? Majirãgãre Goãmʉre õaro umupeocʉ̃ iibʉ mʉhʉ, ãhraa Goãmʉ yare erã gojarapũ, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eropa arĩtuha erãre cóãgã, Betania waĩcʉri macague eja, iri ñamire ero árĩmi. ");
INSERT INTO des_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gajinʉ boyorogue Jerusaléngue gʉa dujaacʉ̃, oaboami Jesu. ");
INSERT INTO des_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Eropa oaboagʉ, ma tʉro niguidigʉ higueragʉre ĩhanijagʉ, irigʉ dʉcare omagʉ warimi. Dʉca maribʉ irigʉpʉ. Pũri dihta árĩbʉ. Dʉca maricʉ̃ ĩagʉ Jesu õpa arĩmi: —Irigʉ yucʉgʉ ne dipaturi dʉcacʉsome, arĩmi ĩgʉ. Ĩgʉ eroparĩcʉ̃ irigʉpʉ mata ñaidija wabʉ. ");
INSERT INTO des_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Irigʉ eropa wacʉ̃ ĩarã, gʉa ĩgʉ buherã ĩhamaria wabʉ. —¿Duhpiro mata irigʉ ñaidija wahári? arĩ serẽpibʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu yʉhrimi: —Ire guñaque mʉa. Goãmʉre õaro guñatura umupeoque. “Diaye ta eropa ta iigʉcumi ĩgʉ,” arĩrã, “Goãmʉ iisome,” arĩbirã, yʉhʉ irigʉre iidiro dopa ta iimasirãca mʉa sã. Eropirã irigʉre yʉ sĩridorediro dopa ta tauro diasarire doremasirãca mʉa Goãmʉre guñatura umupeorã. Irigʉ ʉtãgʉ sãre “Dua aĩ, wʉariyague cóãdigʉ árĩporo,” Goãmʉre mʉa arĩcʉ̃ irigʉ ʉtãgʉ dija waroca. ");
INSERT INTO des_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Goãmʉ irigʉ diague dijacʉ̃ iigʉcumi. Goãmʉre mʉa umupeocʉ̃,” Yʉ serẽro dopa ta eropa waroca,” mʉa arĩ guñacʉ̃, mʉa serẽdiro dopa ta Goãmʉ iigʉcumi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Eropi Goãmʉ wihigue dujaja buhemi ĩgʉ. Ĩgʉ eropa buhecʉ̃ pahia oparã, masare buherã, mʉrã mera ĩgʉ pohrogue eraa serẽpima: —¿Noa doreri mera ire eropa iigʉ iiri mʉhʉ? ¿Noa mʉre Goãmʉ wihigue árĩnirãre cóãdoreari? arĩ serẽpima erã. ");
INSERT INTO des_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Erã eroparĩcʉ̃ Jesu yʉhrimi: —Mʉare yʉhʉ sã serẽpigʉra. Õaro mʉa yʉre yʉhricʉ̃ yʉ sã mʉare yʉhri gamegʉra. ");
INSERT INTO des_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ñu masare ĩgʉ waĩyecʉ̃ noano ĩgʉre waĩyedoremʉriyuri mʉa pepicʉ̃? ¿Goãmʉ doreyuri? ¿O masapʉ doremʉriyuri mʉa pepicʉ̃? arĩ serẽpimi Jesu erãre. Ĩgʉ eroparĩcʉ̃ erãpʉ erã basi game wereniguima: —¿Dohpa arĩ yʉhrirãcuri mari? “Goãmʉ Ñure doreñumi,” mari arĩcʉ̃, “¿Goãmʉ Ñure ĩgʉ dorequerecʉ̃ ta duhpirã ĩgʉ wererare peebirari mʉa?” arĩbocumi Jesu marire. ");
INSERT INTO des_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Oã masapʉ “Diaye ta Ñu Goãmʉ yare weremʉhtadigʉ árĩmi,” arĩ pepima erã. Erã eropa pepirã “Ñu ĩgʉ waĩyecʉ̃ Goãmʉ ĩgʉre dorebiriñumi,” mari arĩcʉ̃ peerã masapʉ guarãcoma mari mera, arĩma erã erã basi. ");
INSERT INTO des_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Erã eropa arĩ werenigui amura pʉhrʉ Jesure yʉhrima erã. —Ñure waĩyedoredigʉre gʉa masibeaa, arĩma erã. Erã eroparĩcʉ̃ peegʉ õpa arĩmi Jesu: —Irisubu tamerare yʉ sã mʉa serẽpirare werebeaa mʉare. Yʉ iirire doregʉre werebeaa mʉare, arĩmi ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ĩgʉ eropa arĩra pʉhrʉ Jesu queori moa werenemomi erãre: —¿Dohpa arĩ pepirãcuri yʉ õpa arĩ werecʉ̃? arĩmi Jesu erãre. Perã pagʉ árĩñumi. Tĩgʉpʉre õpa arĩñumi erã pagʉ: “Mahgʉ, pohegue mohmegʉ waque,” arĩñumi. ");
INSERT INTO des_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Wabeaa,” arĩ yʉhririñumi ĩgʉ magʉ negohrare. Eropa arĩqueregʉ ta pʉhrʉguere pohegue wadiariñe árĩyoro daja ĩgʉre. Eropigʉ wañumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Eropigʉ erã pagʉ ĩgʉ magʉ dʉhyagʉ pohrogue eja, ĩgʉ tĩgʉre ĩgʉ arĩdiro dopa ta pohegue wadoreriñumi. “Áʉ,” arĩriñumi dʉhyagʉpʉ. Eropa arĩqueregʉ ta wabiriñumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Nihinopʉ ĩgʉ pagʉ ĩgʉ dorediro dopa ta iiyuri? arĩ serẽpimi Jesu. —Ĩgʉ tĩgʉpʉ iiñumi, arĩ yʉhrima erã. Erã eroparĩcʉ̃ Jesu weremi: —Mʉare diaye arĩgʉ tiiaa. “Ñetariarã ãhrima,” mʉa arĩnirãpʉ Goãmʉ opʉ ĩgʉ árĩroguere mʉa wabodiro árĩquerecʉ̃ ta erãpʉ warãcoma. ");
INSERT INTO des_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ñu waĩyeri masʉ buhegʉ arigʉ mʉare “Õaro iirã árĩque,” arĩ wererimi. Eropa ĩgʉ werequerecʉ̃ ta ĩgʉre peebiribʉ mʉa. Eropirã ĩgʉ dorerire yʉhribiribʉ. Erã ñerã árĩnirãpʉ wajasea corerãpʉ, nome ñero iiricʉnirãpʉ ĩgʉre peenirã árĩma. Erã eropa pee gohrotorare ĩabʉ mʉa. Mʉa eropa ĩaquererã ta mʉapʉ ne gohrotodiabirabʉ. Eropirã peebirabʉ mʉa, arĩmi Jesu pahia oparãre, mʉrã sãre. ");
INSERT INTO des_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Eropi Jesu dipaturi ĩgʉ pepiri mera õpa arĩ queorire moa erãre buhenemomi: —Gajisubu mʉare werenigui queoriñere yʉ werecʉ̃ peeque daja, arĩmi. Yeba opʉ árĩñumi. Ĩgʉ ya pohere iguidarire oteñumi. Otetuha, sãrirore nugu, iguire erã cʉhra bujuburi gobere seañumi. Pohe decogue ʉmari wihigã sãre iiñumi ĩhadibumaja õaro. Eropigʉ gajirãre ĩgʉ ya pohe deco mera apiñumi erã mohme corera waja. Eropigʉ iri pohere erãre mohme coredoretuhaja gaji yebague waha wañumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Igui ñirisubu árĩcʉ̃ opʉ ĩgʉ pohro majarãre ĩgʉ ya pohe mohme corerã pohrogue obeoñumi. Pohe maja ĩgʉ oteri dʉcare ĩgʉ ya sero maja dʉcare aĩdoregʉ obeoriñumi. ");
INSERT INTO des_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Eropirã pohere mohme corerãpʉ ĩgʉ pohro majarãre ñero iiñuma. Yujugʉre turaro paa, gajigʉre wejẽ, gajigʉre ʉtã mera deañuma. ");
INSERT INTO des_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pʉhrʉ pohe opʉ dipaturi ĩgʉ pohro majarãre ĩgʉ obeomʉhtanirã tauñariro árĩri curu majarãre obeoriñumi daja. Eropirã pohere mohme corerã mʉraro ta iiñuma erã sãre daja. ");
INSERT INTO des_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Eropigʉ ĩgʉ obeotudigʉ ĩgʉ magʉ árĩñumi. “Yʉ magʉpʉre umupeorãcoma,” arĩgʉ ĩgʉre obeoriñumi. ");
INSERT INTO des_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ĩgʉ eropa arĩ pepiquerecʉ̃ ta pohere mohme corerã ĩgʉ magʉ ĩgʉ aricʉ̃ ĩarã, õpa arĩñuma: “Pohe opʉ magʉ ahrimi ĩgʉ. Ĩgʉre wejẽ cóãcãrã mari. Eropiro i pohe mari ya pohe dujaroca,” arĩriñuma erã basi. ");
INSERT INTO des_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eropa arĩrã ĩgʉre ñeha pohe tʉrogue aĩgã, wejẽcãñuma erã ĩgʉre, arĩmi Jesu erãre. Eropa arĩtuhaja Jesu erãre serẽpimi: ");
INSERT INTO des_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","—¿Pohe opʉ arigʉ dohpa iigʉcuri ĩgʉ ya pohere mohme corerãre? arĩ serẽpimi Jesu pahia oparãre, mʉrã sãre. ");
INSERT INTO des_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Ĩgʉ gajirãre pohere mohme coremorãre gohroto­gʉcumi. Árĩmʉhtanirãre ñetarianirãre wejẽgʉcumi. Ĩgʉre dʉcare queoro wiamorãpʉre mohmedoregʉcumi, arĩ yʉhrima erã. ");
INSERT INTO des_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Erã eroparĩcʉ̃ Jesu werenemomi erãre: —¿Goãmʉ yare erã gojarapũ ire yʉre ĩgʉ arĩ gojarare buhebiriri mʉa? Ihĩ Cristo ʉtãye iro dopa ta ãhrimi. Masa Cristore gamebirãcoma. Erã gamebiriquerecʉ̃ Goãmʉ ĩgʉre beye opʉ acumi. Goãmʉpʉ irire iimi. Ĩgʉ eropa iicʉ̃ ĩarã “Õataria,” arĩ pepia mari, arĩ gojañuma iribojeguere. ¿Irire ne buhebiriri mʉa? ");
INSERT INTO des_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Eropigʉ mʉare arĩgʉ tiiaa yʉhʉ. Goãmʉ ĩgʉ dorerire iirã ĩgʉ õari orire opaboya mʉa. Mʉa iibiricʉ̃ ĩha gajirãpʉre ogʉcumi Goãmʉ. Gajirã masapʉ ĩgʉ dorero dopa ta iirãcoma. ");
INSERT INTO des_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yʉre gamebirãpʉ yʉ dipuwaja moamorã ñero tarirãcoma, arĩmi Jesu pahia oparãre, mʉrã sãre. ");
INSERT INTO des_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Iri pohe opʉ queorire ĩgʉ arĩcʉ̃ peerã, “Ĩgʉ iri queori mera ‘Ñerã mohme corerã iro dopa ãhrima,’ marire arĩgʉ weresãgʉ iicumi ĩgʉ,” arĩ pepiñorã erã. ");
INSERT INTO des_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eropa arĩ pepirã, ĩgʉre ñeadiariñorã oparãpʉ. Masapʉ Jesure umupeo “Goãmʉ yare weremʉhtadigʉ ãhrimi ĩgʉ,” arĩmʉriñorã erã. Erã eropa arĩrã árĩcʉ̃ pahia oparã sã masare güirã, Jesure ñeabiriñorã. ");
INSERT INTO des_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Eropi dipaturi gaji queori mera erãre buhenʉgami Jesu: ");
INSERT INTO des_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ʉmaro majagʉ ĩgʉ opʉ árĩri werediacʉ̃ i queori iro dopa ãhraa. Yuju yeba majagʉ tauro opʉ árĩñumi. Eropigʉ ĩgʉ magʉ ya árĩburi bosenʉ iiñumi. Ĩgʉ mojoto diriri bosenʉ árĩyoro. ");
INSERT INTO des_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Eropigʉ opʉ ĩgʉ pohro majarãre bosenʉ ĩarã arimorãre sihudore obeoriñumi. Erãpʉ aridiabiriñuma. ");
INSERT INTO des_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Eropigʉ gajirãre sihudoregʉ obeoriñumi daja ĩgʉ pohro majarãre. “Yʉ sihubeorãre õpa arĩ wereque. ‘Mari baburire iituhama. Wecʉare, wecʉagã õaro diicʉrãre wejẽ amutuhajama. Eropiro árĩpehreri bosenʉ majare iituhajama. Eropirã bosenʉ majare barã arique,’ arĩ wereque erãre,” arĩ obeoriñumi ĩgʉ opʉ ĩgʉ pohro majarãre. ");
INSERT INTO des_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Erã eropa werera pʉhrʉ ĩgʉ sihubeonirã eropa pepicãñuma. Bosenʉre ĩarã wabiriñuma. Yujugʉ ĩgʉ pohegue waha, wañumi. Gajigʉ ĩgʉ mohmerire ĩagʉ wañumi. ");
INSERT INTO des_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Gajirãpʉ ĩgʉ pohro majarãre erãre wererã eranirãre ñeha, erãre ñero iiñuma. Eropii wejẽcãñuma. ");
INSERT INTO des_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Erã eropa iicʉ̃ peegʉ, opʉpʉ guañumi. Gua, erã eropa wejẽra dipuwaja dipuwaja moadoregʉ ĩgʉ surarare obeoñumi. Eropirã surara erãre wejẽpehocã, erã ya macare soecãñuma. ");
INSERT INTO des_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Erã eropa iira pʉhrʉ, opʉ ĩgʉ pohro majarãre õpa arĩñumi: “Bosenʉ majare amutuharama. Yʉ sihumʉhtanirã yʉ bosenʉre ĩabonirã aribeama. Ñerã ãhrima erã. ");
INSERT INTO des_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eropirã macare wari marigue mʉa bocajarãre bosenʉre ĩamorãre sihuque,” arĩñumi ĩgʉ ĩgʉ pohro majarãre. ");
INSERT INTO des_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ĩgʉ eroparĩcʉ̃ ĩgʉ pohro majarã marigue waha, árĩpehrerã erã bocajarãre, ñerãre, õarãre wereñuma. Erã eropa sihura pʉhrʉ ejañuma erã bajarã. Õaro bosenʉ erã iiri taribure masa ʉjʉtʉritaria wañuma. ");
INSERT INTO des_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ero erã doacʉ̃ opʉpʉ yujugʉre mojoto diririnʉ majañe suhriro sañabigʉre ĩañumi. ");
INSERT INTO des_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“Ne, acaweregʉ, ¿duhpigʉ mojoto diririnʉ majañe suhrirore sañabiriqueregʉ ñajarari mʉhʉ?” arĩ serẽpiñumi opʉ. Ĩgʉ eropa serẽpicʉ̃ masʉpʉ werebiriñumi. ");
INSERT INTO des_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ĩgʉ eropa werebiricʉ̃ ĩagʉ ĩgʉ pohro majarãre õpa arĩñumi opʉpʉ: “Ĩre ñeha ĩgʉ mojotorire dirique. Ĩgʉ guburi sãre dirique. Dirituha aĩ wiria, disiporogue naitĩarogue ĩgʉre cóãque. Erogue ĩgʉ turaro ore, bʉjawereri mera gʉcʉri cũridihugʉcumi,” arĩñumi opʉ, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ĩgʉ eropa arĩra pʉhrʉ õpa arĩtumi ĩgʉ: —I queori wadiro dopa ta Goãmʉ bajarã masa ĩgʉ sihubeonirã árĩquererã ta bajamerãgã ĩgʉ mera dujarãcoma, arĩ weretumi Jesu. ");
INSERT INTO des_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ĩgʉ eropa arĩra pʉhrʉ fariseo masa waha, ĩgʉre weresãburire erã basi weretamuñorã erã. Erã ĩgʉre baja serẽpiri mera erãre ĩgʉ gajiropa yʉhricʉ̃ weresãmorã iiriñorã. ");
INSERT INTO des_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Eropirã erã mera majarãre, Herode ya curu majarã sãre, Jesure serẽpidorerã obeoñorã. Erãpʉ gʉa pohrogue eraa, Jesure serẽpima: —Buhegʉ, diaye wereniguigʉ gʉyari marigʉ mʉ árĩcʉ̃ masia gʉa. Eropigʉ opʉ árĩcʉ̃ sãre bu árĩgʉ ĩgʉ árĩcʉ̃ sãre mʉhʉ yujuropa ĩhaa. Eropigʉ Goãmʉ yare diaye mʉ werecʉ̃ sãre gʉa masia. Masa sʉacʉ̃ sãre erã sʉabiricʉ̃ sãre queoro werea. ");
INSERT INTO des_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eropigʉ gʉare wereque. ¿Roma majarã árĩpehrerã tauro opʉ árĩgʉre gobierno majare marire wajayero gahmeri mʉ pepicʉ̃? ¿Mari doreripʉ irire wajayedoreri? arĩ serẽpima Jesure. ");
INSERT INTO des_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesupʉ erã ĩgʉre ñero weresãdiarire masigʉ õpa arĩ yʉhrimi: —Gʉyaricʉrã ãhraa mʉa. ¿Duhpirã yʉ ñero wereniguicʉ̃ peediari mʉa? ");
INSERT INTO des_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dohparagã niyerusere oparã yare wajayeburisere aĩrique. Irisere ĩarã, arĩmi ĩgʉ. Ĩgʉ eroparĩcʉ̃ peerã niyerusere aĩgãrima erã. ");
INSERT INTO des_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Erã irisere aĩ eracʉ̃ ĩagʉ ĩgʉ serẽpimi erãre: —¿Nihino gohra masʉ waĩcʉgʉ tuhyari irisere? ¿Noa waĩ tuhyari? arĩ serẽpimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—César waĩcʉgʉ masa tauro opʉ masʉ ĩgʉ waĩ sã tuhyami iriseguere, arĩ yʉhrima erã. Erã eroparĩcʉ̃ peegʉ Jesu weremi: —Irisubu tamera masa tauro opʉ yare ĩgʉre oque. Goãmʉ yare Goãmʉpʉre oque, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ĩgʉ eroparĩcʉ̃ peerã, pee ʉca wa, waha wama. ");
INSERT INTO des_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Eropi irinʉ ta yujurãyeri saduceo masa Jesure ĩarã erarã gʉa pohrogue erama. Saduceo masa “Goãmʉ sĩrinirãre masusome,” arĩ pepirã árĩma. Eropirã õpa arĩma erã ĩgʉre: ");
INSERT INTO des_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Buhegʉ, õpa arĩ gojañumi Moise: “Yujugʉ ĩgʉ tĩgʉ marapocʉgʉ porã mariqueregʉ ta ĩgʉ sĩricʉ̃ ĩgʉ pagʉ magʉre ĩgʉ tĩgʉ marapo árĩdigore marapocʉro gahmea. Eropigʉ ĩgʉ tĩgʉ mʉrʉ ĩgʉ porãcʉbodiro dopa ta porãcʉro gahmea ĩgʉ pagʉ magʉre. Eropirã igo porã ĩgʉ tĩgʉ mʉrʉ porã iro dopa ta árĩrãcoma,” arĩ gojañumi Moise, arĩma erã saduceo masa. ");
INSERT INTO des_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Irire eropa arĩ weretuha i queorire werenemoma erã Jesure: —Yujugʉ porã siete gohra árĩñorã. Erã tĩgʉpʉ marapocʉ, porã marigʉ ta sĩria wapʉ. Eropigʉ gajigʉ ĩgʉ pagʉ magʉ sã ĩgʉ tĩgʉ marapo árĩdigore marapocʉpʉ. ");
INSERT INTO des_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ĩgʉ eropa marapocʉra pʉhrʉ ĩgʉ sã ĩgʉ tĩgʉ mʉrʉ iro dopa ta porã mariqueregʉ ta sĩria wapʉ. Eropigʉ ĩgʉ pagʉ magʉ ĩgʉ tĩgʉ mʉrʉ iro dopa ta porã mariqueregʉ ta sĩria wapʉ. Eropa dihta wañorã yujugʉ porã gohra. Ne porã mariquererã ta sĩripehrea wañorã erã. ");
INSERT INTO des_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Erã marapo sã erã pʉhrʉ sĩria wapo pare, arĩ õpa serẽpima Jesure: ");
INSERT INTO des_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Ne, Goãmʉ árĩpehrerãre ĩgʉ sĩrinirãre masucʉ̃ nihino marapo árĩgocuri igo? Erã siete árĩpehrerã igore marapocʉnirã árĩñorã. ¿Eropigo nihino marapo gohra árĩgocuri igo? arĩ serẽpima erã. ");
INSERT INTO des_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu yʉhrimi erãre: —Goãmʉ yare erã gojarapũ wereniguirire ne masibeaa mʉa. Eropirã Goãmʉ ĩgʉ turari sãre ne masibeaa mʉa. Eropiro mʉa pepiripʉ ne diaye árĩbeaa. ");
INSERT INTO des_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sĩrinirã erã masa mʉriara pʉhrʉ erã anyua iro dopa ãhrima. Erã ʉma nome mera marapocʉbeama eroguere. ");
INSERT INTO des_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sĩrinirã mʉra erã masa mʉriaboropʉre weregʉra. ¿Goãmʉ iribojegue ĩgʉ arĩrare ne buhebiriri mʉa? Õpa arĩñumi ĩgʉ: ");
INSERT INTO des_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yʉhʉ Abrahã, Isaa, Jacobo erã opʉ ãhraa,” arĩ wereñumi Goãmʉ iribojegue. Erã sĩrira pʉhrʉgue “Erã opʉ ta ãhraa,” arĩ wereñumi Goãmʉ. Eropirã erã sĩrinirã mʉra ĩgʉ masunirã árĩrã erã ojocarirã ãhrima, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ĩgʉ eropa arĩ buhecʉ̃ peerã bajarã masa pee ʉca wama. ");
INSERT INTO des_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Eropi saduceo masa Jesure erã yʉhrimasibiricʉ̃ peerã, fariseo masapʉ gʉa pohrogue gamenerema daja. ");
INSERT INTO des_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Eropigʉ erã mera majagʉ, masare buhegʉpʉ Jesu ĩgʉ ñero arĩcʉ̃ peediagʉ gʉya serẽpirimi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Buhegʉ, ¿Goãmʉ ya doreri õatariaro doreripʉ diñe doreripʉ ãhriri? arĩ serẽpimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu ĩgʉre yʉhrimi: —“Bʉrigã mʉa sĩporã mera, mʉa turari mera, mʉa õaro guñari mera Goãmʉre mʉa Opʉre mahique,” arĩmi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iñe doreriñe õatariariñe ãhraa. ");
INSERT INTO des_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iñe doreriñe pʉhrʉ gajiñe doreriñe sã õataria: “Mʉ basi mahiro dopa ta mʉ pohro árĩrã sãre mahique,” arĩmi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iñe peñe doreriñere iirã árĩpehreri gaji dorerire iipehorã iiaa mari. Goãmʉ yare weremʉhtanirã iribojegue erã gojara sãre iirã iiaa mari eropa iirã, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Eropi fariseo masa ero gamenererã erã árĩcʉ̃ Jesu erãre serẽpimi: ");
INSERT INTO des_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—“Cristo mari Pagʉ ĩgʉ obeodigʉ ãhrimi,” arãa mʉa. ¿Nihino ãhriri ĩgʉ ñecʉ iribojegue majagʉ, mʉa pepicʉ̃? arĩmi ĩgʉ. —Cristo Davi mʉrʉ pãrami árĩgʉcumi, arĩ yʉhrima erã. ");
INSERT INTO des_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu weremi: —¿Davipʉ Cristo ñecʉ árĩqueregʉ ta duhpigʉ opʉcʉturiayuri Cristore? ¿Duhpigʉ eropa opʉcʉdoreyuri Espíritu Santo ĩgʉre? Õpa arĩñumi Davi mʉrʉ: ");
INSERT INTO des_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Goãmʉ yʉ opʉre õpa arĩmi: “Ohõ yʉ diayepʉ dorebu doaque. Eropigʉ mʉre ĩhaturirãre mʉre tarinʉgabasagʉra yʉhʉ mʉ pohro majarã dopa árĩmorãre,” arĩmi Goãmʉ yʉ opʉre, arĩ gojañumi Davi mʉrʉ. ");
INSERT INTO des_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Eropa arĩ gojagʉ ta Davi mʉrʉ opʉcʉñumi Cristore. Cristo Davi mʉrʉ opʉ ãhrimi. ¿Eropigʉ Davi mʉrʉ Cristo ñecʉ árĩqueregʉ duhpigʉ opʉcʉyuri Cristore? arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ĩgʉ eropa arĩ werecʉ̃ erã ĩgʉre ne yʉhrimasibirima. Eropirã iripẽta serẽpi duhucãma erã ĩgʉre. Eropirã ĩgʉre güirã dipaturi serẽpi ĩabirima ĩgʉre pare. ");
INSERT INTO des_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Eropi masa bajarãre gʉa sãre Jesu weremi daja. ");
INSERT INTO des_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Masare buherã, fariseo masa sã Goãmʉ doreri Moisere ĩgʉ apirare wererã ãhrima erã. ");
INSERT INTO des_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Erã eropa wererã árĩcʉ̃ mʉare erã dorerare iipehoque mʉa. Eropa iiquererã ta erãre ĩhacũbiricãque mʉa. Erã buhero dopa ta iibeama erã. ");
INSERT INTO des_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Masare baja dorema erã bocatĩubiririre. Eropa dorequererã ta erã dorero dopa ta masa erã iimasibiriquerecʉ̃ ĩarã erãre itamubeama. ");
INSERT INTO des_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Masa erã ĩacʉ̃ dihta õaro ii ĩhmuma erã. Goãmʉ yare erã gojarapũri erã duhsãri comogãre pagañari comogãre erã diaporire dirituma masare erãre ĩadorerã. Erã dʉca sãre dirituma iri comogãre. Eropirã erã suhri sãre gajirã ya tauro yoari árĩriñe ahmu sañama, “Gʉa Goãmʉre umupeotaria,” arĩ ĩadorerã. ");
INSERT INTO des_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Eropirã bosenʉri árĩcʉ̃ oparã erã doarigue doadiama. Eropirã mari buheri wirigue sãre õari doari dihtare doadiama erã. ");
INSERT INTO des_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eropirã doberi duarogue gajirã õaro umupeori mera erãre bocatĩri serẽcʉ̃ gahmema erã. Erãre “Buhegʉ,” arĩ piyucʉ̃ gahmema. ");
INSERT INTO des_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Mʉapʉre “Buhegʉ,” arĩ gajirã piyucʉ̃ iibiricãque. Mʉa árĩpehrerã yuju curu majarã ãhraa. Eropigʉ mʉare buhegʉ yʉhʉ yujugʉ ta ãhraa. ");
INSERT INTO des_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Eropirã i yeba majarãre “Mari pagʉ,” arĩrã erãre umupeorã iica. Ne eropa arĩ iibiricãque. Ʉmaro majagʉ dihta mari Pagʉ ãhrimi. Ĩgʉ dihtare umupeoro gahmea marire. ");
INSERT INTO des_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Eropirã masʉre “Opʉ,” arĩbiricãque. Mʉa opʉ yʉhʉ Cristo yujugʉ ta ãhraa. ");
INSERT INTO des_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pohro majagʉ iro dopa mʉare itamugʉ ĩgʉ ta árĩgʉcumi opʉ árĩbu. ");
INSERT INTO des_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yujugʉ opʉ árĩdiagʉ docanʉgaja árĩcorecãro gahmea. Eropigʉ docanʉgagʉ “Bu árĩgʉ ãhraa yʉhʉ,” arĩ pepigʉ ĩgʉ ta árĩgʉcumi opʉ árĩbu, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ĩgʉ eropa arĩra pʉhrʉ erãre werenemomi: —Mʉa masare buherã, fariseo masa sã ñero tarirãca. Gʉyaricʉrã ãhraa mʉa. Gajiropa mʉa arĩ buhecʉ̃ peerãpʉ Goãmʉ ĩgʉ opʉ árĩroguere wasome. Mʉa sã eroguere wasome. Eropa arĩ buherã eroguere wadiarãre cãhmotaa mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Mʉa masare buherã, fariseo masa sã ñero tarirãca. Gʉyaricʉrã ãhraa mʉa. Wapeweyarã nome erã wajamocʉ̃ ĩha erã ya wirire emacãa mʉa erã nomere. Eropa erãre mojomoro ĩabiriquererã masa erã ĩhuro yoari boje Goãmʉre serẽ ĩhmuraa mʉa masare. Mʉa eropa iira dipuwaja gajirã tauro dipuwaja moagʉcumi mʉare. ");
INSERT INTO des_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mʉa masare buherã, fariseo masa sã ñero tarirãca. Gʉyaricʉrã ãhraa mʉa. Wʉariyague taribuja, yoaro maja macarigue wahaa mʉa mʉa dorerire iibure omarã. Mʉa dorerire iibure boca, ĩgʉre buhea. Mʉa eropa iicʉ̃ ĩgʉpʉ mʉa tauro ñero iinʉgagʉcumi. Eropirã ĩgʉre peamegue wabu árĩcʉ̃ iiaa mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mʉa ñero tarirãca. Cuiri ĩhajabirã erã ĩhajabiro dopa ta masibirã ãhraa mʉa. Eropa árĩquererã ta gajirãre buheraa mʉa. Õpa arĩ buheraa mʉa: “‘Goãmʉ wihi mera iigʉra,’ arĩ waĩpeogʉ ĩgʉ arĩdiro dopa ta iibiricʉ̃ õaroca,” arĩ buheraa mʉa. “‘Goãmʉ ya wihi maja oro mera iigʉra,’ arĩ waĩpeodigʉpʉre ĩgʉ arĩdiro dopa ta ii ojogorocʉro gahmea,” arĩ iri sãre buheraa mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Cuiri ĩhajabirã erã ĩhamasibiro dopa ta masibirã ãhraa mʉa. Pee masibirã ãhraa. ¿Dinopʉre umupeoro gahmeri? Orore umupeobiricãro gahmea. Goãmʉpʉ iri orore ĩgʉ ya wihi árĩcʉ̃ õari iimi irire. Eropirã ĩgʉ ya wihipʉre umupeoro gahmea mʉare. Eropiro mʉa buheripʉ queoro wabeaa. ");
INSERT INTO des_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","I sãre buheraa mʉa: “‘Goãmʉ wihi maja mesa mera iigʉra,’ arĩ waĩpeodigʉ ĩgʉ arĩdiro dopa ta ĩgʉ iibiricʉ̃ õacãroca,” arĩ buheraa mʉa. “‘Iri mesa weca mari aĩgã apira ta mera iigʉra,’ arĩ waĩpeodigʉpʉre ĩgʉ arĩdiro dopa ta ii ojogorocʉro gahmea,” arĩ buheraa mʉa queoro buhebirã. ");
INSERT INTO des_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Cuiri ĩhajabirã erã ĩhamasibiro dopa ta masibirã ãhraa mʉa. ¿Dipʉ iri gohra ãhriri mʉa pepicʉ̃? Goãmʉre masʉ ĩgʉ ora mʉra iri gohra árĩbiriñaria. Iri mesa weca Goãmʉre ĩgʉ ocʉ̃, õari wahaa iri mesa weca árĩri. Eropiro iri mesa bu árĩri mesa árĩbeaa. Goãmʉre erã ora weca tauro õari mesa ãhraa. ");
INSERT INTO des_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eropigʉ “Goãmʉ wihi maja mesa mera iigʉra,” yujugʉ arĩ waĩpeogʉ, iri mesa weca apira mera ĩgʉ eropa arĩgʉ iicumi. Eropiro mʉa buheripʉ queoro wabeaa. ");
INSERT INTO des_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Goãmʉ ĩgʉ ya wihi majagʉ ãhrimi. Eropigʉ “Goãmʉ wihi mera eropa iigʉra,” arĩ waĩpeogʉ diaye ta Goãmʉ waĩ mera eropa arĩgʉ iicumi. ");
INSERT INTO des_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Goãmʉ ʉmaro majagʉ ãhrimi. Eropigʉ “Ʉmaro mera iigʉra,” yujugʉ arĩ waĩpeogʉ, Goãmʉ mera ta eropa arĩgʉ iicumi. Eropiro mʉa buheripʉ queoro wabeaa. ");
INSERT INTO des_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mʉa masare buherã, fariseo masa sã ñero tarirãca. Gʉyaricʉrã ãhraa mʉa. Bari sʉricʉ̃ iirisarire menta, anis, comina waĩcʉrisarire aĩ deara pʉhrʉ diez quẽri iiaa. Eropa iira pʉhrʉ yujuquẽ ta aĩgã apia Goãmʉ wihigue Goãmʉ dorerire iimorã. Mʉa eropa iri dorerire iiquererã ta tauro õaro iirire guñabeaa mʉa. Diaye iirire, mojomoro ĩarire, Goãmʉre umupeorire ne guñabeaa mʉa. Dʉcare mʉa aĩrare merogã Goãmʉ wihire apicʉ̃ õhaa. Eropa iirã õpa iinemoque: Diaye iirire, mojomoro ĩarire, Goãmʉre umupeorire iique. ");
INSERT INTO des_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cuiri ĩhajabirã erã ĩabiro dopa ta diaye majare masibirã ãhraa mʉa. Õpa iiaa mʉa. Mʉa dorerire iidorerã árĩpehrerire õaro iidiaa yujuñegã dʉhyaro mariro. Mʉa eropa iiquererã ñeripʉre duhubeaa. ");
INSERT INTO des_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mʉa masare buherã, fariseo masa sã ñero tarirãca. Gʉyaricʉrã ãhraa mʉa. Mʉa dorero dopa ta mʉa soroparire, mʉa ihriri parire mʉa coeweaa mʉa õarire ii ĩhmurã. Eropa coequererã ta mʉa sĩporãripʉre coebeaa. Eropirã mʉa árĩricʉrire mʉa pepiripʉre ne õarire gohrotobeaa. Gajirã yare yajadiarã, mʉa basi dihta pagarire aĩdiarã árĩrã, eropa dihta pepia mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Cuiri ĩhajabirã erã ĩhajabiro dopa ta masibirã ãhraa mʉa fariseo masa. Mʉa pepirire gohrotomʉhtaque mʉa. Eropirã õaripʉre iique. Mʉa eropa iirã masa erã ĩhuro sãre õarã gohra árĩrãca pare mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mʉa masare buherã, fariseo masa sã ñero tarirãca. Gʉyaricʉrã ãhraa mʉa. Masa comorore boreri mera erã sũhuma. Eropirã masa iri comorore erã ĩacʉ̃ õari comoro dehyoa. Iri comoro eropa õaro deyoquerecʉ̃ ta, poheca majague ĩgʉ boara gõariguere ĩaya mara. ");
INSERT INTO des_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Eropa ta mʉa sã masa erã ĩhabeoro õarã dehyoa mʉa. Eropa õarã deyorã mʉa árĩquerecʉ̃ ta mʉa pepiriguere ñeri gʉyaricʉrã árĩtariacãa boanirã iro dopa, arĩ weremi Jesu. Eropa arĩtuhaja õpa arĩnemomi daja: ");
INSERT INTO des_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Mʉa masare buherã, fariseo masa sã ñero tarirãca. Gʉyaricʉrã ãhraa mʉa. Goãmʉ yare weremʉhtanirã iribojegue majarã erã masa goberire õaro amuraa mʉa. Eropirã iribojegue majarãre õaro iinirã mʉrare erã wéanugunirã mʉrare õaro amuraa mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Eropa iirã õpa arĩ wereniguiraa mʉa: “Iribojegue mari ñecʉ sʉmarã mʉrague erã iidiro dopa gʉapʉ iibiriboya. Irisubugue árĩnirãre Goãmʉ yare weremʉhtanirãre gʉapʉ wejẽbiriboya,” arĩ wereniguiraa mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eropa arĩrã árĩrã, mʉa ñecʉ sʉmarã mʉra Goãmʉ yare weremʉhtanirã mʉrare erã wejẽnirã erã árĩcʉ̃ wererã iica. Erã wejẽnirã pãramerã mʉa árĩri sãre mʉa basi weresãrã iica mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mʉa ñecʉ sʉmarã mʉra iidiro dopa ta ii ojogorocʉque. ");
INSERT INTO des_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Añaa iro dopa ñerã ãhraa mʉa. Añaa porã iro dopa ãhraa mʉa. Goãmʉ mʉa ñeri dipuwajare ĩgʉ peamegue ĩgʉ cóãboro core duhrimasibeaa mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eropigʉ Goãmʉ yare weremʉhtarãre, gajirã masirãre, gajirã mʉare buhemorãre mʉa pohro obeogʉra. Yʉ eropa obeocʉ̃ mʉapʉ yujurãyeri erãre wejẽrãca. Gajirãre crusague pabiarãca. Gajirãre mʉa buheri wirigue tãrarãca. Erãre macari nʉcʉ nʉrʉsiarãca. ");
INSERT INTO des_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mʉa eropa iirã árĩpehrerã ñeri marirãre mʉa wejẽra dipuwaja dipuwajacʉrãca. Abel mʉrʉre Caín ĩgʉ wejẽra dipuwajare dipuwajacʉrãca mʉapʉ. Árĩpehrerã ĩgʉ pʉhrʉ árĩnirãre õarãre erã wejẽra dipuwaja sãre dipuwajacʉrãca mʉa sã. Eropirã Goãmʉ wihi pohro waimʉrãre mʉa soeburi mesa pohro Zacaríare mʉa acawererã mʉra wejẽñorã. Ĩgʉpʉ Berequias magʉ árĩpʉ. Eropirã ĩgʉ sãre erã wejẽra dipuwaja dipuwajacʉrãca mʉa. ");
INSERT INTO des_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Diaye mʉare weregʉ ta iiaa. Erã árĩpehrerãre erã wejẽra dipuwaja dohpague majarã dipuwajacʉrãcoma, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Eropa arĩtuhaja õpa werenemomi Jerusalén majarãre bʉjawere ĩagʉ: —Mʉa Jerusalén majarã, mʉa acawererã mʉra Goãmʉ yare weremʉhtanirãre wejẽmʉrinirã árĩma. Eropirã Goãmʉ obeonirãre, ʉtã mera deamʉrinirã árĩma. Cãreña bʉro igo igo porãre igo quẽdʉpʉri mera igo coã oyaro dopa ta bajasuburi opadiarabʉ mʉare. Mʉapʉ irire ne yʉre gamebirabʉ. ");
INSERT INTO des_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dohpaguere mʉa árĩri maca cóãra maca árĩroca. ");
INSERT INTO des_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Diaye mʉare arĩgʉ tiiaa. Pʉhrʉgue dujarigʉca daja yʉhʉ. Eropa yʉ dujaricʉ̃ ĩarã mʉa yʉre “Goãmʉ turari mera arigʉ õaro ariporo,” arĩrãca. Yʉre mʉa irire arĩboro core, dipaturi yʉre ĩasome mʉa, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Eropi Goãmʉ wihire Jesu ĩgʉ wiriara pʉhrʉ gʉa ĩgʉ buherã iri wihi maja wirire ĩarã, —Õatariari wiri ãhraa. Ĩaque mʉ sã, arĩbʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesu yʉhrimi: —I wihi majare dohpaguere ĩaraa mʉa. Mʉare weregʉ tiiaa. I wihi árĩpehreri mʉa ĩara i ʉtã sã cohmopehrea waroca. Ne yujuye ʉtãye dujasome, arĩmi ĩgʉ gʉare. ");
INSERT INTO des_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pʉhrʉ Olivo waĩcʉdigʉ ʉtãgʉgue eja, erogue doami Jesu. Ero ĩgʉ doacʉ̃ gʉa ĩgʉ buherã gʉa seyaro ĩgʉ pohrogue eja serẽpibʉ. —Wereque gʉare. ¿Dohpárĩcʉ̃ eropa warocuri mʉ arĩdiro dopa waro? ¿Pehrerinʉ coregã mʉ dujariboro coregã dohpa wanʉgacʉ̃ ĩarãcuri gʉa? arĩ serẽpibʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu yʉhrimi: —Õaro iiyuque mʉa. Eropirã gajirã mʉare erã gʉyarire peebiricãque. ");
INSERT INTO des_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bajarã masa “Cristo ãhraa yʉhʉ,” arĩ gʉyarã árĩrãcoma. Erã eropa gʉyacʉ̃ peerã bajarã masa Goãmʉ yare duhurãcoma. ");
INSERT INTO des_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mʉa pohrogã gajirã masa erã gamewejẽcʉ̃ peerãca mʉa. Eropirã yoarogue majarã erã sã erã gamewejẽcʉ̃ peebeorãca. Eropa peequererã ta ne wʉaro irire pepibiricãque. Eropa ta wamʉhtaroca. Eropa wacʉ̃ pehreburinʉ dʉhyaniroca dohpa. ");
INSERT INTO des_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Irisubure yuju yeba majarã gaji yeba majarã mera gamewejẽrãcoma. Eropirã yujugʉ opʉ yarã gajigʉ opʉ yarã mera gamewejẽrãcoma. Eropirã masa bajarã oa mera sĩrirãcoma. Gajirã dorecʉ ñero tarirãcoma. Eropiro bajasuburi i yeba ñohmeroca. ");
INSERT INTO des_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Eropa ñero tariquererã i yeba majarãre tauro erã ñero tariboro dʉhyaa dohpa. Ñero tarinirãcoma dohpa. ");
INSERT INTO des_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Irisubure gajirã mʉare ñeha ñero iidorerã orãcoma mʉare gajirã oparãre. Erã eropa ocʉ̃ mʉare wejẽrãcoma. Yaharã mʉa árĩri dipuwaja árĩpehrerã mʉare ĩhaturirãcoma. ");
INSERT INTO des_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Irisubure bajarã yaharã árĩnirã yʉre cóãrãcoma. Eropirã erã mera majarãre Jesu yarãre erã ĩhaturirãcoma. Eropirã erã mera majarã erã árĩquerecʉ̃ ta ĩhaturirãcoma. Eropirã erã mera majarã erã árĩquerecʉ̃ ta erãre ñero iimorãre erãre orãcoma. ");
INSERT INTO des_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Irisubure bajarã “Goãmʉ yare weremʉhtarã ãhraa,” arĩ gʉyarã árĩrãcoma. Eropirã bajarã masa erã gʉyarire peerã árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Irisubure ñetariaro iirãcoma masa. Eropirã erã mera majarãre mahinemosome. ");
INSERT INTO des_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Eropirã mʉare erã ñero iiquerecʉ̃ ta mʉare erã ñero iirare yujuro bojerã yʉre duhubiricʉ̃ Goãmʉ mʉare taugʉcumi. Eropigʉ ĩgʉ pohrogue mʉare opagʉcumi. ");
INSERT INTO des_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Eropiro i õari buheri árĩpehreroguere i yebaguere erã wereburi buheri árĩroca. Goãmʉ ĩgʉ opʉ árĩrire árĩpehrerãre wererãcoma árĩpehrerã iri buherire erã masiboro dopa. Eropa werera pʉhrʉ pehrerinʉ nʉgaroca. ");
INSERT INTO des_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ñetariagʉ Goãmʉ yare goroweogʉ aribure were­mʉriñumi iribojegue Daniel mʉrʉ Goãmʉ yare weremʉhtadigʉ. Irisubure ĩgʉ ñetariagʉ Goãmʉ wihigue ĩgʉ niguicʉ̃ ĩarãca mʉa. (Irire buhegʉ peeporo.) ");
INSERT INTO des_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ero ĩgʉ niguicʉ̃ ĩarã, Judea yeba árĩrãpʉ ʉtã yucʉgue oma duhriporo. ");
INSERT INTO des_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Irisubure masa ñero tarirãcoma. Eropirã yojaro mera duhrirã waporo. Irisubure erã wiri weca maja pʉʉrigue árĩrã wihi pohecague erã yare aĩrã ñajabiricãporo. ");
INSERT INTO des_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Eropirã irisubure gajirã erã poerigue árĩrã erã ya suhrire wihigue árĩri suhrire aĩrã pihabiricãporo. ");
INSERT INTO des_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Irisubure nijiposã nome, erã porãre mihrirãre oparã nome sã mojomorocʉrã nome dujarãcoma. ");
INSERT INTO des_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Eropirã Goãmʉre õpa arĩ serẽque: “Puhiró árĩcʉ̃ gʉa judio masa soorinʉ árĩcʉ̃ sãre gʉa oma duhriburinʉ árĩbiricãporo,” arĩ serẽque mʉa Goãmʉre. ");
INSERT INTO des_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Irinʉrire masa ñero tarirãcoma. I yebare ĩgʉ ĩhacũnugura pʉhrʉ masa ñero tarimʉriñuma. Iri eropa árĩquerecʉ̃ ta árĩpehreri pũriri erã ñero taridiro tauro ñetariaro tarirãcoma masa pehreburinʉ coregãre. Eropa ñero erã tarira pʉhrʉ, dipaturi eropa ñero tarisome i yeba pare. ");
INSERT INTO des_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Eropigʉ Goãmʉ irinʉrire bajamenʉrigã árĩcʉ̃ iigʉcumi. Ĩgʉ eropa iibiricʉ̃ ne yujugʉ masʉ taribiribocumi. Eropigʉ ĩgʉ beyenirã erã tariborore bajamenʉrigã ñero tariburinʉrire apigʉcumi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Irisubure gajirãre pee masi ĩaque: “Ĩaque. Ohõ ãhrimi Cristo,” erã arĩcʉ̃ erãre peebiricãque. “Ero ãhrimi Cristo,” erã arĩcʉ̃ sãre peebiricãque. ");
INSERT INTO des_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“Cristo ãhraa,” arĩ gʉyarã, “Goãmʉ yare weremʉhtarã ãhraa,” arĩ gʉyarã árĩrãcoma irisubure. Eropirã Goãmʉ ĩgʉ beyenirãre gʉyarã, erã deyoro moarire ii ĩhmurãcoma. Goãmʉ yare erãre cóãcʉ̃ iidiarã iirãcoma erã gʉyari masa. ");
INSERT INTO des_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","I árĩpehrerire wereyumʉhtaa mʉare iri eropa waboro core. Eropirã õaro pee masiyuque mʉa. ");
INSERT INTO des_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Gajirã masa mʉare õpa arĩcʉ̃, “Masa marirogue ãhrimi Cristo,” erã arĩcʉ̃ eroguere ĩarã wabiricãque. Eropirã erã “Ohõ iri wihigue ãhrimi ĩgʉ,” erã arĩcʉ̃ sãre erãre peebiricãque. ");
INSERT INTO des_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ guñaña mariro dujarigʉra. Bupu ĩgʉ miacʉ̃ ʉmarore, abe mʉririrogue, abe ñajarogue yojaro mera ĩgʉ miabeoro dopa ta eropa ta dujarigʉra yʉhʉ. ");
INSERT INTO des_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Masa erã ñeri erã iiniguirogue erogue Goãmʉ erãre erã ñeri dipuwaja dipuwaja moagʉcumi erãre, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Eropigʉ gʉare werenemomi: —Masa ñero erã tariranʉri pʉhrʉ abe ʉmʉ majagʉ, ñami majagʉ sã boyo duhurãcoma. Erã eropa wacʉ̃ necã dipu yuri dijariroca. Eropiro ʉmaro maja sã yeba sã bʉrigã ñohmeroca. ");
INSERT INTO des_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Irisubu ta yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉ dehyoacʉ̃ masa ĩarãcoma. Eropirã árĩpehreri cururi majarã orerãcoma. Eropirã yʉ turari mera, yʉ gosesiriri mera, ʉmaro maja imica curu weca i yebaguere yʉ dujaricʉ̃ ĩarãcoma masa. ");
INSERT INTO des_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Corneta bʉsʉroca. Eropigʉ yaharã anyuare árĩpehrero i yebaguere obeogʉra. Eropirã árĩpehreroguere yaharãre yʉ beyenirãre erã aĩ gameneorãcoma. ");
INSERT INTO des_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Higueragʉ irigʉ waricʉrire masia mʉa. Irigʉ yucʉgʉ pũcʉcʉ̃ ĩarã, “Bojori merogã dʉhyaa,” arĩ masia mʉa. ");
INSERT INTO des_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eropa ta irigʉ waro dopa ta masique mʉa. I árĩpehreri yʉ arĩra eropa wacʉ̃ ĩarã, “Cristo dujariboro merogã dʉhyaa,” arĩ masique mʉa. ");
INSERT INTO des_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Diaye arĩgʉ tiiaa mʉare. Irisubu majarã erã sĩriboro core árĩpehreri yʉ arĩdiro dopa ta eropa waroca. Ʉmaro i yeba sã pehrea waroca. ");
INSERT INTO des_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yʉ wereniguiripʉ ne pehresome. Árĩpehreri yʉ arĩdiro dopa ta eropa waha ojogorocʉroca. ");
INSERT INTO des_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Irinʉre yʉ dujariburinʉre, iri hora sãre masibeaa yʉhʉ. Anyua sã irire masibeama. Masa sã ne masibeama. Yʉ Pagʉ dihta irire masimi. ");
INSERT INTO des_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Noé ĩgʉ árĩrasubu majarã erã árĩdiro dopa ta i yeba majarã yʉ dujariboro coregã eropa ta árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yeba miriboro core masa baha, ihri, iiñuma. Eropirã mojoto diriñuma. Noé sã erã wʉadiru dohodirugue erã ñajaboro core mʉraro ta iimʉririñuma masa. ");
INSERT INTO des_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mata turaro deco ahri, guñaña mariro yeba miria wayoro. Masa sã miripehrea wañuma. Guñaña mariro ero miridiro dopa ta, yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ i yebaguere guñaña mariro dujarigʉca. ");
INSERT INTO des_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Irisubure yʉre umupeorãre beye gameneodoregʉca. Eropigʉ poheguere perã mohmerã árĩcʉ̃ yujugʉre aĩrãcoma yʉ mera árĩbure. Eropigʉ gajigʉ ero dujagʉcumi. ");
INSERT INTO des_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Irisubure nome perã nome erã yujuro erã ojodʉcare erã biurã árĩcʉ̃ yujugore aĩrãcoma. Eropigo gajigo ero ta dujagocumo. ");
INSERT INTO des_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Õaro guñamasi coreque. Yʉhʉ mʉa opʉ yʉ dujariburinʉre ne masibeaa mʉa. ");
INSERT INTO des_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ire guñaque. Yajari masʉ ĩgʉ wihigue ĩgʉ ñajaa ĩgʉ yajaborore wihi opʉ masigʉ, iri ñamire ĩgʉ carĩbiriboñumi yajari masʉre coregʉ. Eropigʉ yajari masʉre ĩgʉ ya wihire ñajaridorebiriboñumi. ");
INSERT INTO des_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wihi opʉ ĩgʉ ya wihire corero dopa ta mʉa sã yʉ ariburire core árĩque. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ i yebare dujarigʉ guñaña mariro arigʉca. Eropirã yahare eropa iiniguirã yʉre coreque, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Eropi Jesu õpa arĩ queorire moami buhenemobu: —Mohme coregʉ ĩgʉ opʉre umupeogʉ pee masigʉ õpa ta ãhrimi. Opʉ curigʉ wagʉ, mohme coregʉre ĩgʉ wihire apimi. Ĩgʉ apigʉpʉ doregʉ árĩgʉcumi. Eropigʉ barisubu árĩcʉ̃ mohme coregʉ gajirã mohmeri masare barire gueremi. ");
INSERT INTO des_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Eropigʉ opʉ ĩgʉ ya wihi dujarami. Ĩgʉ dujaracʉ̃ ĩagʉ mohme coregʉ ĩgʉ opʉ ĩgʉ dorediro dopa ta iipehogʉ árĩgʉ, mucubirigʉ árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Diaye mʉare arĩgʉ tiiaa. Ĩgʉ eropa iicʉ̃ ĩagʉ ĩgʉ opʉ árĩpehreri ĩgʉ yare ĩhadibugʉ apigʉcumi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ñegʉ mohme coregʉpʉ õpa ta ãhrimi. “Yʉ opʉ yoja deyobeami,” arĩgʉ, gajirã mohme corerãre paa, wʉaro baha, ihri, mererã mera meregʉcumi. ");
INSERT INTO des_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ĩgʉ eropa iirisubu ĩgʉ opʉ guñaña mariro dujaragʉcumi. Ĩgʉ dujararinʉre ne masibeami mohme coregʉ. ");
INSERT INTO des_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eropa dujaragʉ ñegʉ ĩgʉ iirare pee ĩgʉre turaro dipuwaja moagʉcumi. Eropigʉ gʉyaricʉrã erã warogue ĩgʉre cóãgʉcumi. Eroguere ĩgʉ turaro ore, bʉjawereri mera ĩgʉ gʉcʉri cũridihugʉcumi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Eropi Jesu dipaturi õpa arĩ queorire weremi buhenemogʉ daja: —Ʉmaro majagʉ ĩgʉ opʉ árĩri diez nome erã wadiro dopa ãhraa: Diez nome árĩñuma. Yuju ñami erã, erã sihãgori dipuru mera mojoto diridigʉre bocatĩrirã wañuma. ");
INSERT INTO des_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Erã mera majarã nome cinco nome pee masibirã nome árĩñuma. Gajirã nomepʉ cinco nome pee masirã nome árĩñuma. ");
INSERT INTO des_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pee masibirã nomepʉ erã sihãgori dipurure ʉyʉ dicʉri dipurure aĩquererã erã gohrotoburire aĩabiriñuma. ");
INSERT INTO des_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pee masirã nomepʉ erã sihãgori dipurure dicʉri dipurure aĩ gaji ʉyʉ dipuru sãre erã gohrotoburire aĩañuma. ");
INSERT INTO des_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Eropirã mojoto diridigʉ ĩgʉ yoja deyobiricʉ̃ erã nome wʉja pũricʉ̃ carĩa wañuma. ");
INSERT INTO des_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Eropiro ñami deco gaguinigʉ cariñumi: “Peeque, mojoto diridigʉ arigʉ carimi. Ĩgʉre bocatĩrirã arique,” arĩ gaguiniguigʉ cariñumi. ");
INSERT INTO des_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ĩgʉ eroparĩcʉ̃ peerã erã nome wahgã, erã sihãgori dipurure amuñuma. ");
INSERT INTO des_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eropirã pee masibirã nomepʉ, gajirã nomere pee masirã nomere õpa arĩñuma: “Gʉa sihãgori dipuru yariro iiaa. Eropirã merogã mʉa ya ʉyʉre oque gʉare,” arĩ serẽriñuma erã nome. ");
INSERT INTO des_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Erã eropa arĩ serẽquerecʉ̃ ta pee masirã nomepʉ õpa yʉhriñuma: “Gʉa ya ʉyʉ mʉare ocʉ̃ árĩpehrerãre sihajabiriboca. Eropirã ʉyʉ duarã pohro mʉa basi asũrã waque,” arĩ yʉhriñuma pee masirã nomepʉ. ");
INSERT INTO des_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Eropirã pee masibirã nome asũrã wañuma. Erã eropa wara pʉhrʉ mojoto diridigʉ erañumi. Ĩgʉ eracʉ̃ ĩha, erã amutuhanirã nome pee masirã nome ĩgʉre bocatĩriñuma. Ĩgʉ mojoto diriri bosenʉgue ĩgʉ mera ĩarã wañuma. Eropirã erã bosenʉ erã iri wihigue ñajara pʉhrʉ, disiporore biacãñumi. ");
INSERT INTO des_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pʉhrʉgue pee masibirã nomepʉ erariñuma. “Opʉ, gʉare pãgũque,” arĩriñuma erã nome. ");
INSERT INTO des_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Diaye mʉare arĩgʉ tiiaa. Mʉare masibeaa yʉhʉ,” arĩñumi ĩgʉ erã nomere. ");
INSERT INTO des_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yʉ dujariburinʉre iri hora sãre ne masibeaa mʉa. Eropirã pee masirã nome erã yare õaro amutuha erã corediro dopa ta õarã, ñeri marirã ãhri coreque mʉa sã, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Eropa arĩ weretuha õpa arĩ queorire moa buhenemomi daja gʉa sãre: —Irisubu yʉ dujariburinʉ ĩgʉ wihi opʉ iidiro dopa árĩroca. Wihi opʉ árĩñumi. Ĩgʉ gajipʉgue curigʉ wagʉ, ĩgʉre mohme corerãre sihubeoñumi. Eropigʉ erãre ĩgʉ yare coredoreñumi. ");
INSERT INTO des_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Eropa coredoregʉ erã dibu masiropẽ erãre niyeruserire wajapagariserire oñumi. Yujugʉre cinco mil seri oroserire oñumi. Gajigʉre pe mil seri oñumi. Gajigʉre yuju mil seri oñumi. Erãre otuha waha wañumi. ");
INSERT INTO des_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Eropigʉ cinco mil seri ĩgʉ odigʉ mata iriseri mera gajinore asũñumi. Ĩgʉ asũra mera duagʉ gaji cinco mil seri wajatanemoñumi ĩgʉ. Eropigʉ diez mil seri mera dujañumi. ");
INSERT INTO des_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Eropigʉ pe mil seri ĩgʉ odigʉ mata ĩgʉ ora pʉhrʉ ta iriseri mera gajinore asũñumi. Ĩgʉ asũra mera duagʉ gaji pe mil seri wajatanemoñumi. Eropigʉ wapicʉri mil seri opañumi. ");
INSERT INTO des_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yuju mil seri ĩgʉ odigʉpʉ gobe seha, iri gobegue dibuñumi iriserire dibugʉ. ");
INSERT INTO des_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pʉhrʉ yoara pʉhrʉ erã opʉ goerañumi. Eropa eragʉ ĩgʉ niyeruseri mera erã wajatanemorare queobu ĩgʉre mohme corerãre sihubeoñumi. ");
INSERT INTO des_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Eropigʉ cinco mil seri ĩgʉ odigʉ ĩgʉ opʉ pohrogue eja, diez mil seri wiañumi ĩgʉre. “Cinco mil seri yʉre ohabʉ mʉhʉ. Ĩañatagʉ. Iriseri mera gaji cinco mil serire wajatanemoabʉ,” arĩñumi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Õaro iiaya mʉhʉ. Mʉhʉ õagʉ yʉ dorediro dopa ta iidigʉ ãhraa. Eropigʉ dohpaguere wʉaro mʉ mohmeborore apigʉra. Eropigʉ yʉ mera mucubirique,” arĩñumi ĩgʉ opʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Eropigʉ pe mil serire aĩdigʉ sã ĩgʉ opʉ pohrogue eja, wereñumi ĩgʉre: “Pe mil seri yʉre ohabʉ mʉhʉ. Ĩañatagʉ. Iriseri mera gajiseri pe mil seri wajatanemoabʉ,” arĩñumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Õaro iiaya mʉhʉ. Mʉhʉ õagʉ yʉ dorediro dopa ta iigʉ ãhraa. Merogãre õaro iiaya mʉhʉ. Eropigʉ dohpaguere wʉaro mʉ mohmeborore apigʉra. Eropigʉ yʉ mera mucubirique mʉhʉ,” arĩñumi ĩgʉ opʉ. ");
INSERT INTO des_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Eropigʉ yuju mil serire aĩdigʉpʉ, ĩgʉ opʉ pohrogue eja, wereñumi ĩgʉre: “Opʉ, mʉhʉ turaro mohmedoregʉ ãhraa. Eropigʉ gajirãre mohmedorequeregʉ oteri moogʉ árĩqueregʉ ta mʉ dihta iri dʉcare aĩa. ");
INSERT INTO des_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mʉhʉ eropa árĩgʉ árĩcʉ̃ mʉre güiabʉ. Eropa güigʉ gobe seha, iri gobegue mʉ niyeruserire dibucãbʉ. Ĩañatagʉ. Ohõ ãhraa mʉ ya niyeruseri,” arĩñumi ĩgʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mʉhʉ ñegʉ butagʉ ãhraa. Yʉre, ‘Mʉhʉ gajirãre mohmedorequeregʉ mʉ dihta iri dʉcare aĩa,’ arãa mʉhʉ yʉre. ");
INSERT INTO des_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Mʉhʉ yʉre eropa arĩqueregʉ ta, duhpigʉ yʉ óraserire niyeru diburi wihigue dihbubirari mʉhʉ? Mʉ erogue dibugʉ iriseri mera wʉaro wajata­nemoboaya. Irire mʉhʉ iicʉ̃ dujaragʉ wajata­nemoboaya yʉhʉ,” arĩñumi opʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Eropa arĩgʉ gajirã ĩgʉre mohme corerãre doreñumi ĩgʉ: “Niyeruserire emaque ĩgʉre. Diez mil seri opagʉpʉre oque. ");
INSERT INTO des_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Árĩpehrerã baja oparãre onemogʉra. Moorãpʉre merogã erã opaquerecʉ̃ ta erãre emapehocãgʉra. ");
INSERT INTO des_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ihĩ mohme coregʉ duhpibu árĩbeami. Naitĩarogue ñerogue cóãcãque ĩgʉre. Erogue ĩgʉ turaro ore, bʉjawereri mera ĩgʉ gʉcʉri cũridihugʉcumi,” arĩñumi opʉ, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Eropi Jesu werenemomi: —Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ árĩpehrerã anyua mera doregʉ dujarigʉca. Eropa dujarigʉ opʉ doarogue yʉ gosesiriri mera doagʉca. ");
INSERT INTO des_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Eropa yʉ doacʉ̃, yaharã anyua i yeba majarãre árĩpehrerãre yʉ pohro gameneorãcoma. Erãre gameneora pʉhrʉ pe curu dʉca wagʉra erãre. Oveja ĩhadibugʉ ĩgʉ iiro dopa ĩgʉ cabrare ĩgʉ dʉca waro dopa ta masare dʉca wa dobogʉra. ");
INSERT INTO des_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eropa dʉca wagʉ oveja dopa árĩrãre õarãre yʉ diayepʉ dobogʉra. Eropigʉ cabra dopa árĩrãre, ñerãre yʉ copʉpʉ dobogʉra. ");
INSERT INTO des_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yʉ eropa iira pʉhrʉ yʉhʉ árĩpehrerã tauro opʉ yʉ diayepʉ doarãre õpa arĩ weregʉra: “Yʉ Pagʉ mʉare õaro iigʉcumi. I yebare ĩhacũnugudigʉgue ta mʉa ya árĩburire ĩgʉ opʉ árĩrore amuyutuhami Goãmʉ. Eropirã dohpaguere ĩgʉ amuyudiroguere árĩrã arique. ");
INSERT INTO des_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉ oaboacʉ̃ ĩarã mʉa yʉre barire obʉ. Yʉ ñemesibucʉ̃ mʉa yʉre tĩabʉ. Mʉa pohro yʉ curicʉ̃ yʉre ĩha masibiriquererã yʉre õaro bocatĩribʉ mʉa. ");
INSERT INTO des_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Suhri marigʉ yʉ árĩcʉ̃ ĩarã mʉapʉ yʉre suhrire sãbʉ. Dorecʉcʉ̃ mʉa yʉre ĩarã aribʉ. Peresu yʉ árĩcʉ̃ sãre yʉre ĩarã aribʉ,” arĩgʉra õarãre. ");
INSERT INTO des_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yʉ eroparĩcʉ̃ peerã õarãpʉ yʉre serẽpirãcoma: “Opʉ, ¿dohpárĩcʉ̃ mʉ oaboacʉ̃ mʉre barire ori gʉa? ¿Dohpárĩcʉ̃ mʉ ñemesibucʉ̃ mʉre tĩari gʉa? ");
INSERT INTO des_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Dohpárĩcʉ̃ mʉre ĩha masibiriquererã õaro bocatĩriri gʉa? ¿Dohpárĩcʉ̃ mʉ suhri marigʉ mʉ árĩcʉ̃ mʉre suhri sãri gʉa? ");
INSERT INTO des_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Dohpárĩcʉ̃ mʉ dorecʉcʉ̃ o peresugue mʉ árĩcʉ̃ sãre mʉre ĩarã ejari gʉa?” arĩrãcoma yʉre. ");
INSERT INTO des_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Erã eropa arĩ serẽpicʉ̃ peegʉ yʉhʉ õpa erãre yʉhrigʉca: “Diaye mʉare arĩgʉ tiiaa. Oã yaharã mera majagʉ bu árĩgʉ árĩquerecʉ̃ ta, mʉa ĩgʉre eropa ta õaro iibʉ. Eropa árĩgʉre eropa iirã, yʉre iiro dopa iirã tiiaa mʉa,” arĩ weregʉra erãre. ");
INSERT INTO des_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Õarãre yʉ eropa arĩ werera pʉhrʉ, copʉpʉ árĩrãre ñerãre yʉ árĩpehrerã tauro opʉ õpa arĩgʉra: “Goãmʉ ĩgʉ dipuwaja moamorã ãhraa mʉa. Yʉ mera dujabiricãque. Peamegue waque mʉa. Iri peame ne yaribeaa. Watĩ, ĩgʉ yarã anyua sã erã árĩborore iri peamere iimi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉ oaboacʉ̃ mʉa yʉre barire obiribʉ. Yʉ ñemesibucʉ̃ mʉa yʉre tĩabiribʉ. ");
INSERT INTO des_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mʉa pohro yʉ curicʉ̃ yʉre masibirã bocatĩribiribʉ. Eropa ĩacãbʉ. Suhri marigʉ yʉ árĩquerecʉ̃ ta, yʉre suhri sãbiribʉ mʉa. Dorecʉgʉ yʉ árĩcʉ̃, peresu yʉ árĩcʉ̃ sãre eropa ĩacãbʉ mʉa yʉre,” arĩ weregʉra erãre ñerãre. ");
INSERT INTO des_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yʉ eroparĩcʉ̃ peerã erã yʉre serẽpirãcoma: “Opʉ, ¿mʉ oaboacʉ̃, mʉ ñemesibucʉ̃, gʉa masibigʉ mʉ árĩcʉ̃, suhri marigʉ mʉ árĩcʉ̃, dorecʉgʉ mʉ árĩcʉ̃, peresugue mʉ árĩcʉ̃, dohpárĩcʉ̃ gʉapʉ mʉre itamubiriri?” arĩ serẽpirãcoma yʉre. ");
INSERT INTO des_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Erã eropa arĩ serẽpicʉ̃ yʉhʉ erãre õpa arĩ weregʉra: “Diaye mʉare arĩgʉ tiiaa. Oã yaharã mera majagʉre bu árĩgʉre mʉa ne itamubiribʉ. Eropa árĩgʉre mʉa itamubirã, yʉre ta itamubeaa mʉa,” arĩ weregʉra erãre. ");
INSERT INTO des_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Eropigʉ erãre eropa dipuwaja moaniguicãgʉcumi Goãmʉ. Erã eropa dipuwajacʉri ne pehresome. Eropirã õarãpʉ ʉmʉri nʉcʉ õaro árĩrãcoma, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iri árĩpehrerire ĩgʉ buhera pʉhrʉ Jesu gʉare ĩgʉ buherãre weremi: ");
INSERT INTO des_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Penʉ pʉhrʉ Pascua árĩroca. Irire mʉa masia. Irisubure yʉhʉ masʉre Goãmʉ ĩgʉ obeodigʉre ñearãcoma. Ñeha yʉre crusague wejẽrãcoma, arĩmi ĩgʉ gʉare. ");
INSERT INTO des_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Irisubu ta pahia oparã, mʉrã sã gamenereñorã. Caifa pahia opʉ ya wihi gamenereñorã erã. ");
INSERT INTO des_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ero gamenere, erã gʉyari mera Jesure ñeha erã wejẽburire game weretamurã iiñorã. ");
INSERT INTO des_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Bosenʉ árĩcʉ̃ ĩgʉre ñeabiricãrã. Masa gʉa ĩgʉre ñeacʉ̃ ĩarã gua gamenerenijarã gamequeãbocoma, arĩrã iiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Irisubure Simo cami boadigʉ ya wihi árĩmi Jesu. Gʉa sã árĩbʉ. Ĩgʉ árĩri maca Betania waĩcʉri maca árĩbʉ. ");
INSERT INTO des_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iri wihi ĩgʉ baro watope yujugo nomeo poresuri aĩgãri, Jesu dipuru weca pipeomo. Iri poresuri alabastro waĩcʉdiru dicʉri deco, igo pipeori deco wajapagari deco árĩbʉ. ");
INSERT INTO des_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Igo eropa pipeocʉ̃ ĩarã gʉa Jesu buherã guarã õpa arĩnʉgabʉ: —¿Duhpigo igo irire eropa iisirimaacãri? ");
INSERT INTO des_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iri poresurire duaboañumo. Eropa duago wʉaro niyerure wajataboañumo. Eropa wajatago, mojomorocʉrãre iri niyerure oboañumo, arĩbʉ gʉa ĩgʉ buherã. ");
INSERT INTO des_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Gʉa eroparĩcʉ̃ ĩagʉ, Jesu gʉare weremi: —¿Duhpirã eropa arĩri mʉa igore? Yʉre õaro iigo iimo. ");
INSERT INTO des_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mojomorocʉrãpʉ mʉa mera eropa árĩniguirãcoma. Eropirã mʉa erãpʉre omasia. Yʉpʉ i yebare mʉa mera eropa árĩniguisome. ");
INSERT INTO des_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yʉre erã yaaboro core yʉ dʉpʉre amuyugo, poresuri mera sũhumo yʉre. ");
INSERT INTO des_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eropigʉ diaye ta mʉare arĩgʉ iiaa. Árĩpehrero i yebaguere õari buherire erã wererogue igo õpa iirare wererãcoma. Erã eropa werecʉ̃ peerã masa bajarã igore guñarãcoma, arĩ weremi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Irisubure yujugʉ gʉa mera majagʉ Juda Iscariote pahia oparã pohrogue ejapʉ. ");
INSERT INTO des_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Eja, erãre serẽpipʉ. —¿Jesure mʉare yʉ ĩhmucʉ̃ dipẽ wajayerãcuri yʉre mʉa? arĩ serẽpipʉ erãre. Ĩgʉ eroparĩcʉ̃, erã ĩgʉre treinta seri plataserire oñorã. ");
INSERT INTO des_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Erã eropa ocʉ̃ Judapʉ Jesure ĩgʉ ĩhmuburinʉre corenipʉ. ");
INSERT INTO des_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Eropi bʉgabiriri panre erã baburinʉ bosenʉ árĩnʉgarinʉ árĩbʉ. Eropirã gʉa Jesu buherã ĩgʉ pohrogue waha serẽpibʉ ĩgʉre: —¿Nohonogue bosenʉ mari baburire amudoregʉ obeori mʉhʉ gʉare? arĩbʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Gʉa eroparĩcʉ̃ ĩgʉ gʉare weremi: —Jerusaléngue waque. Ero mʉa bocagʉre õpa arĩ wereque: “Marire buhegʉ mʉre õpa arĩ weredoreami: ‘Yʉ ñero tariboro merogã dʉhyanijaa. Pascua árĩcʉ̃ yʉhʉ, yʉ buherã mera mʉ ya wihi gʉa barãca,’ arĩ weredore obeomi gʉare,” õpa arĩ wereque iri wihi opʉre, arĩ obeomi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Eropirã gʉare ĩgʉ dorediro dopa ta iirã, Pascua árĩcʉ̃ gʉa baburire amubʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Eropi iri ñamire gʉa mera doce ĩgʉ buherã mera bagʉ árĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Gʉa barisubu ĩgʉ gʉare weremi: —Diaye ta mʉare arĩgʉ iiaa. Yujugʉ mari mera majagʉ ta yʉre ĩhaturirãre ĩhmugʉcumi yʉre, arĩ weremi ĩgʉ gʉare. ");
INSERT INTO des_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ĩgʉ eroparĩcʉ̃ peerã gʉapʉ bʉrigã bʉjawererã, ĩgʉre serẽpinʉgabʉ gʉa yujurãyeri. —Opʉ, ¿yʉ ãhriri mʉre ĩhmubu? arĩ serẽpibʉ. ");
INSERT INTO des_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Gʉa eropa arĩ serẽpicʉ̃ ĩgʉ yʉhrimi: —Yʉ baripare yʉ mera yoso bagʉ ta ãhrimi yʉre ĩhaturirãre ĩhmubu. ");
INSERT INTO des_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iribojegue erã yʉre arĩ gojadiro dopa ta yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ sĩrigʉca. Yʉre ĩhaturirãre ĩhmudigʉpʉ ñetariaro tarigʉcumi. Eropiro ĩgʉpʉre ĩgʉ masa dehyoabiricʉ̃ õaboya. Ñero taribiriboñumi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ĩgʉ eroparĩcʉ̃ ĩgʉre ĩhaturirãre ĩhmubu Juda ĩgʉre serẽpimi: —Buhegʉ, ¿mʉre ĩhmubu ãhriri yʉhʉ? arĩ serẽpimi ĩgʉ. —Ʉ̃ ʉ. Mʉhʉ ta ãhraa, arĩmi. ");
INSERT INTO des_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eropa arĩ weretuhaja gʉa barisubu Jesu panre aĩ, Goãmʉre “Õhaa,” arĩmi. Eropa arĩtuha irire nuha gʉare ĩgʉ buherãre gueremi. —Ire aĩ, baque. I yʉ dʉpʉ ãhraa, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Eropa arĩtuha ĩgʉ ihriripare aĩ, Goãmʉre “Õhaa,” arĩ, gʉare omi. —Mʉa árĩpehrerã ire ihrique. ");
INSERT INTO des_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","I yʉ di ãhraa. Bajarã ñero erã iirare cóãbu sĩrigʉca. Eropigʉ yʉ di cóãgʉca. Eropa sĩrigʉ Goãmʉ yʉ Pagʉ “Masare õaro iigʉra,” ĩgʉ arĩdiro ii ojogorocʉgʉca. ");
INSERT INTO des_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mʉare arĩgʉ tiiaa. Yʉ Pagʉ ĩgʉ opʉ árĩrogue mʉa mera igui deco mama decore ihrigʉca. Mari erogue ihriboro core i igui decore dipaturi ihrinemosome yʉhʉ, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eropirã yujuñe Goãmʉre bayariñere bayatuhajarã wiriabʉ. Ʉtãgʉ Olivo waĩcʉdigʉgue wabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Erogue gʉa ejacʉ̃ Jesupʉ gʉare weremi: —Dohpagã ñami mʉa árĩpehrerã yʉre cóãgãrãca. Mʉa yʉre cóãborore õpa ta arĩ gojañuma Goãmʉ yare erã gojarapũ: “Ovejare ĩhadibugʉre erã wejẽcʉ̃ iigʉca. Yʉ eropa iicʉ̃ oveja ĩgʉ yarã ĩgʉre cohãgã wasiria warãcoma,” arĩ gojañuma. ");
INSERT INTO des_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Eropigʉ Goãmʉ yʉre ĩgʉ masura pʉhrʉ mʉa core Galileague wamʉhtagʉca, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ĩgʉ eroparĩcʉ̃ peegʉ Pedro õpa arĩrimi: —Yʉ mera majarã árĩpehrerã erã mʉre cóãgãquerecʉ̃ ta yʉpʉ mʉre ne cóãsome, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu yʉhrimi: —Diaye arĩgʉ tiiaa mʉre. Dohpagã ñami cãreña ĩgʉ wereboro core ʉhresubu “Yʉhʉ Jesure masibeaa,” arĩgʉca mʉhʉ, arĩmi ĩgʉ Pedrore. ");
INSERT INTO des_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ĩgʉ eropa arĩquerecʉ̃ ta Pedro õpa arĩ yʉhrimi: —Mʉ mera yʉre erã wejẽquerecʉ̃ ta, “Jesure masibeaa,” ne arĩsome yʉhʉ, arĩ yʉhririmi Pedro. Eropirã gʉa sã gajirã ĩgʉ buherã Pedro ĩgʉ arĩro dopa ta arĩribʉ gʉa Jesure. ");
INSERT INTO des_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Eropi Getsemaní waĩcʉri gorogue Jesu gʉa ĩgʉ buherã mera waha, erogue eja, gʉare arĩmi: —Ohõ doayuque. Mʉa ohõ doaropẽ sohõgue Goãmʉ mera wereniguigʉ wagʉ iiaa, arĩmi ĩgʉ gʉare. ");
INSERT INTO des_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Eropa arĩtuha Pedrore, perã Zebedeo porãre, erã ʉrerãre sihugãmi. Eropigʉ ĩgʉ turaro bʉjawere, ñero sĩporãcʉpʉ. ");
INSERT INTO des_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Eropa bʉjaweregʉ ĩgʉ mera majarãre ĩgʉ sihugãnirãre arĩpʉ: —Bʉrigã ñero sĩporãcʉa yʉhʉ. Yʉre turaro pũriro dopa ta pepigʉ iiaa. Sohõñari wanigʉ iiaa. Ohõ dujanique mʉa. Eropirã yʉ mera ta tʉyʉque mʉa sã, arĩpʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eropa arĩtuha ero core merogã wanemo, yeba mereja, Goãmʉre arĩpʉ: —Ahʉ, yʉ ñero tariburire iidiabigʉ iibiricãque. Yʉ eropa arĩquerecʉ̃ ta yʉ gamero dopa iibita. Mʉpʉ masia. Mʉ gamero dopa iique, arĩpʉ ĩgʉ Goãmʉre. ");
INSERT INTO des_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Eropa arĩtuha, ʉrerã ĩgʉ buherã pohrogue eranijagʉ erã carĩ oyarãre ĩapʉ. Erãre ĩagʉ Pedrore õpa arĩpʉ: —¿Yuju hora gohra yʉ mera ta tʉyʉtamubirari? ");
INSERT INTO des_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Õaro iique mʉa. Mʉa pepiri mera õarire iidiaraa mʉa. Mʉa seyaro irire iidiaquererã ta irire bocatĩubeaa. Eropirã Goãmʉre serẽniguique ñero mʉa iibiriboro dopa, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eropa arĩtuha dipaturi waha, Goãmʉre serẽpʉ daja: —Ahʉ, yʉ ñero tariburire iidiagʉ iique yʉre. Mʉ gamero dopa ta iique, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ĩgʉ buherã pohrogue ʉrerã pohrogue dipaturi erapʉ daja. Eropa eragʉ carĩ oyarãre ĩapʉ daja. Wʉja pũritaricãyoro erãre. ");
INSERT INTO des_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Eropigʉ dipaturi erãre apicã dipaturi waha, Goãmʉ mera wereniguipʉ daja. Ĩgʉ ero core ĩgʉ arĩdiro dopa ta arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Eropa arĩtuha ĩgʉ buherã pohrogue eraa, erãre arĩpʉ: —¿Mʉa carĩrã soorã iiri dohpa? arĩpʉ ĩgʉ. Eropa arĩtuha masa erã aricʉ̃ ĩagʉ õpa arĩpʉ: —Iripẽta ãhraa. Dohparagã yʉ masʉre Goãmʉ ĩgʉ obeodigʉre ñerãre orãcoma yʉre. ");
INSERT INTO des_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wahgãque. Ina warã. Ĩaque. Yʉre ĩhaturirãre obu ohõ ahrimi, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ĩgʉ eropa arĩ wereniguirisubu gʉa mera majagʉ mʉrʉpʉ Judapʉ erami. Eropirã masa bajarã ñoserimijiri yucʉ dʉcari opanirã ĩgʉ mera yujuro mera erama. Erã pahia oparã, erã mʉrã sã erã obeonirã árĩma. ");
INSERT INTO des_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Negohrare Jesure ĩhaturirãre wiabu õpa arĩ wereseretuhapʉ Juda: “Yʉhʉ wayuporãre mimigʉ ĩgʉ ta árĩgʉcumi mʉa ñeabu. Ĩgʉre yʉ mimira pʉhrʉ ñeaque,” arĩpʉ Juda erãre. ");
INSERT INTO des_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eropigʉ eragʉ Jesu pohrogue mata wapurumujumi. —Buhegʉ, ¿ãhriri mʉhʉ? arĩ ĩgʉre wayuporã mimimi. ");
INSERT INTO des_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ĩgʉ eropa mimicʉ̃ Jesu õpa arĩmi: —Yʉ mera majagʉ, ¿duhpigʉ õguere ahriri mʉhʉ? arĩmi ĩgʉre. Eropirã erã Jesure ñeama. ");
INSERT INTO des_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Erã eropa iicʉ̃ ĩagʉ Jesu mera majagʉ ĩgʉ matamijire tʉãwea aĩ, pahi opʉ pohro majagʉre ĩgʉ gamirore tabe corodijucãmi. ");
INSERT INTO des_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ĩgʉ eropa iicʉ̃ ĩagʉ Jesu ĩgʉre weremi. —Mʉ matamijire dibuque. Gajirãre ñosenirã árĩrã, erã ñose gamecʉ̃ sĩrirãcoma. ");
INSERT INTO des_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yʉ Pagʉre yʉ itamudorecʉ̃ ĩgʉpʉ bajarã anyuare doce cururire yʉ pohro obeobocumi. ¿Irire masibeari mʉa? ");
INSERT INTO des_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Eropa itamubodiro árĩqueregʉ ta ĩgʉre yʉre itamudoresome yʉhʉ. Yʉ eropa dorebiricʉ̃ Goãmʉ yare erã gojarapũ arĩdiro dopa ta eropa waroca, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eropa arĩtuha masare weremi ĩgʉ: —¿Mʉa ñoserimijiri mera, yucʉ dʉcari mera arirã yajari masʉre iro dopa mʉa yʉre ñearã arirã iiari? Ʉmʉri nʉcʉ Goãmʉ wihigue yʉhʉ mʉare buhe doacʉ̃, mʉa yʉre ne ñeabiribʉ. ");
INSERT INTO des_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dohpaguere mʉa yʉre eropa iirã i árĩpehreri Goãmʉ yare weremʉhtanirã erã arĩ gojadiro dopa ta iiaa mʉa, arĩmi Jesu erãre. Ĩgʉre eropa ñeacʉ̃ ĩarã gʉa ĩgʉ buherã árĩpehrerã ĩgʉre cohã omagã wabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Eropi ĩgʉre ñeanirã pahi tauro opʉ Caifa waĩcʉgʉ ya wihigue aĩ ejañorã ĩgʉre. Iri wihi ta masare buherã, mʉrã sã gamenereñorã. ");
INSERT INTO des_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedropʉ yoarogue erãre ĩhanʉrʉsiapʉ. Eropa ĩhanʉrʉsiagʉ Caifa ya wihire cãhmotara sãrirore eja, iri sãriro pohecague ñajaa wapʉ. Ñajaja, iri wihire corerã surara mera doapʉ. “Jesure duhpiicʉ̃ ĩagʉra,” arĩgʉ doapʉ Pedro. ");
INSERT INTO des_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eropirã pahia oparã, gajirã oparã mera gamenererã Jesure wejẽdorediarã, gʉyari mera erã ĩgʉre ñero dipuwaja moaborore guñamaariñorã. ");
INSERT INTO des_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Erã eropa weresãburire guñabocabiriñorã. Eropa guñabocabiriquererã ta masa bajarã ĩgʉre eropa weresãmorã amañorã. Eropirã perã ĩgʉre weresãmorã erañorã. Õpa arĩñorã: ");
INSERT INTO des_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Ihĩ õpa arĩmi: “Goãmʉ wihire cóãmasia. Eropa cóãgʉ ʉhrenʉ pʉhrʉ iri wihire dipaturi iigʉra,” ĩgʉ arĩcʉ̃ peebʉ gʉa, arĩ weresãmaacãñorã Jesure. ");
INSERT INTO des_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Erã eropa arĩra pʉhrʉ pahia tauro opʉ wahgãnʉgaja, Jesure serẽpipʉ: —¿Oã mʉre weresãquerecʉ̃ ta erãre yʉhri gamebeari mʉhʉ? ¿Mʉre erã weresãrire dohpa arĩ yʉhri gahmeri mʉhʉ? arĩpʉ opʉ. ");
INSERT INTO des_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ĩgʉ eroparĩcʉ̃ peequeregʉ ta Jesu eropa pepicãpʉ. Ĩgʉ eropa yʉhribiricʉ̃ ĩagʉ pahia tauro opʉ ĩgʉre dipaturi serẽpipʉ daja: —Goãmʉ ojocariniguicãgʉ mera diaye arĩque mʉhʉ. Mʉhʉ eropa arĩbiricʉ̃ mʉre ĩgʉ dipuwaja moagʉcumi. Wereque gʉare. ¿Cristo Goãmʉ magʉ ta ãhriri mʉhʉ? arĩ serẽpipʉ daja. ");
INSERT INTO des_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ĩgʉ eroparĩcʉ̃gue ta Jesu yʉhripʉ: —Ĩgʉ ta ãhraa. Mʉare diaye weregʉ tiiaa. Pʉhrʉ yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ Goãmʉ yʉ Pagʉ turagʉ pohro ĩgʉ diayepʉ doacʉ̃ ĩarãca mʉa. Eropirã ʉmaro maja imica weca yʉ dujaricʉ̃ sãre ĩarãca, arĩ yʉhripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ĩgʉ eroparĩcʉ̃ peegʉ pahia opʉ, ĩgʉ basi ĩgʉ sañarañe suhrirore yeguecãpʉ gajirãre “Guatariacãmi,” arĩdoregʉ. —Ĩre weresãrãre gajirãre gamebeaa pare. Ĩgʉ basi Goãmʉre ĩgʉ ñero wereniguicʉ̃ peea mari. Eropirã ĩgʉ ñero iira dipuwajare masituhaa mari. ");
INSERT INTO des_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Eropirã dohpa iirãcuri mari dohpaguere ĩre? arĩ serẽpipʉ ĩgʉ gajirã oparãre. —Ĩgʉ ñeri dipuwaja wejẽcãro gahmea, arĩ yʉhriñorã erã. ");
INSERT INTO des_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Erã eropa arĩra pʉhrʉ ĩgʉ diapore disico ehosũ, ĩgʉre pañorã erã. ");
INSERT INTO des_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Gajirã ĩgʉ cuirire diricãhmota õpa arĩ wereyañorã ĩgʉre: —¿Noa mʉre pari? Cristo Goãmʉ beyedigʉ árĩgʉ ĩabiriqueregʉ ta wereque gʉare, arĩ pañorã erã. ");
INSERT INTO des_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Eropi iri wihi pohro árĩri pʉʉ õari pʉʉ Pedropʉ doapʉ. Ĩgʉ eropa doacʉ̃ ĩago pahia opʉ pohro majago ĩgʉ pohrogue erago õpa arĩpo: —Mʉ sã Jesu Galilea majagʉ mera ãhrabʉ, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Igo eroparĩcʉ̃ peegʉ Pedro õpa arĩpʉ: —¿Dohpa arĩmaacãgo iiri mʉhʉ? Mʉ arĩgʉre ne masibeaa yʉhʉ, arĩpʉ Pedro árĩpehrerã erã peero. ");
INSERT INTO des_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Igo eropa arĩra pʉhrʉ iri pʉʉ maja sãriro disiporo pohrogue wapʉ Pedro. Ero ĩgʉ árĩcʉ̃ gajigo pohro majago ĩgʉre ĩago, ero árĩrãre õpa arĩpo igo sã: —Jesu Nazare majagʉ mera ãhrami ihĩ, arĩpo igo Pedrore daja. ");
INSERT INTO des_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Igo eroparĩcʉ̃ peegʉ Pedro yʉhripʉ: —Goãmʉ mera diaye arĩgʉ iiaa. Ĩgʉ mʉ arĩgʉre ne masibeaa yʉhʉ, arĩ yʉhripʉ Pedro. ");
INSERT INTO des_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Eropi merogã pʉhrʉ ta ero niguinirã Pedro pohrogue waha, ĩgʉre õpa arĩñorã. —Diaye ta ãhraa. Jesu mera majarã mera majagʉ ta ãhraa mʉ sã. Erã iro dopa ta wereniguia mʉhʉ, arĩñorã erã Pedrore. ");
INSERT INTO des_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Erã eroparĩcʉ̃ Pedro yʉhripʉ: —Diaye ta Goãmʉ mera arĩgʉ iiaa mʉare. Yʉ diaye arĩbiricʉ̃ Goãmʉ yʉre dipuwaja moaporo. Ĩgʉ mʉa arĩgʉre ne masibeaa yʉhʉ, arĩ yʉhripʉ ĩgʉ erãre. Ĩgʉ eroparĩcʉ̃ ta cãreña werepʉ. ");
INSERT INTO des_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ĩgʉ werecʉ̃ peegʉ Jesu ĩgʉre arĩrare guñapʉ. “Cãreña ĩgʉ wereboro core ‘Jesure masibeaa,’ arĩgʉca mʉhʉ. Ʉhresubu eropa arĩgʉca mʉhʉ,” Jesu ĩgʉre arĩrare guñapʉ Pedro. Eropa guñagʉ iri sãrirore wiria turaro orepʉ. ");
INSERT INTO des_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Eropirã boyodi merero ta pahia oparã, mʉrã sã Jesure erã wejẽdoreborore game weretamuñorã. ");
INSERT INTO des_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Erã eropa weretamura pʉhrʉ ĩgʉre dihri, Pilato waĩcʉgʉ opʉ pohrogue aĩgã, ĩgʉre oñorã Pilatore. Pilatopʉ iri yeba majarã opʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Eropigʉ Jesure erã wejẽdorecʉ̃ ĩagʉ Judapʉ Jesure ĩgʉ ĩhmurare guña turaro bʉjawerepʉ. Eropa bʉjaweregʉ treinta seri niyeruserire ĩgʉ ñearaserire wiagʉ wagʉ, pahia pohrogue, mʉrã pohrogue eja, õpa arĩpʉ: ");
INSERT INTO des_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Jesu mʉare yʉ ĩhmudigʉ ñeri marigʉ ĩgʉ árĩquerecʉ̃ ta erã wejẽdoreama ĩgʉre. Eropigʉ mʉare ĩgʉre ĩhmugʉ ñero iigʉ iiaya yʉhʉ. Eropigʉ i niyeruserire mʉare wiagʉ iiaa, arĩpʉ Juda erãre. Ĩgʉ eropa arĩ werera pʉhrʉ erã yʉhriñorã: —Eropa ta iicuraporo. Mʉ eropa arĩri gʉare duhpiburi árĩbeaa. Mʉ dihta eropa arĩ pepia irire, arĩ yʉhriñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Erã eropa arĩ yʉhrira pʉhrʉ erã árĩri wihi Goãmʉ wihigue Juda ĩgʉ niyeruserire mehsiripicãpʉ. Mehsirituha waha wapʉ. Waha, yuradare dirisiu, ĩgʉ basi ĩgʉ wʉnʉgʉ tuhbiu, buhrimadija, sĩria wapʉ pare. ");
INSERT INTO des_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Eropirã pahia oparã niyeruserire aĩrã õpa arĩñorã: —I niyerure Goãmʉ wihi maja comorogue niyeru diburi comorogue mari apimasibeaa. I niyeru mera ta masʉre wejẽdorema. Eropiro mari doreri marire eropa árĩri niyerure dibudorebeaa Goãmʉ wihigue, arĩñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Erã eropa arĩra pʉhrʉ, “Õpa iirã,” erã arĩ weretamura pʉhrʉ mátasorori mohmegʉ ya yebare asũrã wañorã. Iriseri mera asũñorã. Gajipʉ majarã iri macague eranirã sĩricʉ̃ erãre yaaburi yebare asũñorã. ");
INSERT INTO des_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eropirã iri yebare “Di cóãri yeba,” arĩ waĩyema masa. Dohpague sãre eropa ta waĩcʉa. ");
INSERT INTO des_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","I árĩpehreri eropa wayoro iribojegue majagʉ Jeremia ĩgʉ “Eropa waroca,” ĩgʉ arĩdiro dopa ta. Ĩgʉ Goãmʉ ya weremʉhtadigʉ árĩñumi. Õpa arĩ gojañumi ĩgʉ: “‘Treinta niyeruserire plataserire iripẽta wajayerãra gʉa ĩgʉre ñeaborore,’ arĩrãcoma Israe masa. ");
INSERT INTO des_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Eropirã iriseri mera mátasorori mohmegʉ ya yebare asũrãcoma erã. Õpa ta yʉre iidoremi Goãmʉ,” arĩ gojañumi Jeremia iribojegue. ");
INSERT INTO des_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Eropi Pilatore erã Jesure ora pʉhrʉ ĩgʉpʉ ĩgʉre serẽpipʉ: —¿Diaye ta judio masa erã opʉ ta ãhriri mʉhʉ? arĩ serẽpipʉ Jesure. —Mʉ arĩro dopa ta ĩgʉ ta ãhraa, arĩ yʉhripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eropa arĩ yʉhriqueregʉ ta, pahia oparã, mʉrã sã erã weresãcʉ̃ yʉhribiripʉ. ");
INSERT INTO des_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ĩgʉ eropa yʉhribiricʉ̃ ĩagʉ Pilato serẽpipʉ: —¿I árĩpehreri erã weresãrire peebeari mʉhʉ? arĩ serẽpipʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ĩgʉ eropa arĩ serẽpiquerecʉ̃ ta Jesu ne yuju disiro yʉhribiripʉ. Ĩgʉ eropa yʉhribiricʉ̃ ĩagʉ Pilato ʉca wapʉ. ");
INSERT INTO des_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bojori nʉcʉ Pascua árĩcʉ̃ peresu árĩdigʉre yujugʉre masa “Ĩgʉre wiuque,” erã arĩgʉre Pilato eropa wiubasamʉripʉ. ");
INSERT INTO des_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Irisubure Barrabá waĩcʉgʉ peresugue árĩpʉ. Ĩgʉre masiñorã masa. ");
INSERT INTO des_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Eropigʉ erã gamenerecʉ̃ Pilato serẽpipʉ erãre: —¿Nihipʉre mʉare wiubasacuri yʉhʉ? ¿O Barrabáre o Jesure “Cristo” erã arĩgʉre wiubasacuri yʉhʉ? arĩ serẽpipʉ Pilato Jesure wiudianijagʉ. ");
INSERT INTO des_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jesure masa erã mahicʉ̃ ĩarã judio masa oparã ĩgʉre ĩhaturirã iiñorã. Eropa ĩhaturirã ĩgʉre oñorã Pilatore. Irire erã ĩhaturirare masigʉ Pilato Jesure wiudiaripʉ. ");
INSERT INTO des_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Eropi Pilato masare ĩgʉ beyeri pẽro ĩgʉ doacʉ̃ ĩgʉ marapo ĩgʉre quere obeopo: “Dohpagã ñamire Jesure quẽgo bʉrigã ñero pepiabʉ ĩgʉre ñero iiburire. Eropigʉ ĩgʉre ñeri marigʉre ne gajiropa iibiricãque mʉhʉ,” arĩ werebeopo ĩgʉ marapo Pilatore. ");
INSERT INTO des_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pilato Jesure eropa wiudiaquerecʉ̃ ta pahia oparã, mʉrã sã masare õpa arĩdoreñorã: “Barrabápʉre wiudoreque. Jesupʉre wejẽdoreque,” arĩdoreñorã masare. ");
INSERT INTO des_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Eropigʉ Pilato masare serẽpipʉ daja: —¿Oã perãre nihipʉre mʉare wiubasacuri yʉhʉ? arĩ serẽpipʉ. —Barrabápʉre wiubasaque gʉare, arĩ yʉhriñorã. ");
INSERT INTO des_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Ihĩ Jesu, “Cristo” erã arĩgʉpʉre dohpa iigʉcuri yʉhʉ? arĩ serẽpipʉ ĩgʉ. —Crusague pabia wejẽque ĩgʉre, arĩ yʉhriñorã masa árĩpehrerã. ");
INSERT INTO des_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Ñehenore ñerire iiari ihĩ mʉa eroparĩcʉ̃? arĩpʉ ĩgʉ. Ĩgʉ eroparĩcʉ̃ peerã erã turaro mera gaguiniguinemoñorã: —Crusague pabia wejẽque ĩgʉre, arĩ gaguiniguiñorã daja masa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Erã eropa arĩ gaguiniguicʉ̃ peegʉ, ĩgʉre erã peediabiricʉ̃ ĩagʉ, “Masa gua gamequeãbocoma,” arĩgʉ, yʉhrigʉ ta õpa iipʉ Pilato. Decore aĩgãridoretuhaja masa erã ĩhuro ĩgʉ mojo coepʉ. Eropa mojo coegʉ õpa arĩpʉ: —Ĩre wejẽra dipuwaja, yaha dipuwaja árĩsome. Mʉa ya dipuwaja árĩroca, arĩgʉ mojo coepʉ. ");
INSERT INTO des_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ĩgʉ eroparĩcʉ̃ peerã árĩpehrerã masa õpa arĩñorã: —Ĩre gʉa wejẽdorera dipuwaja gʉa porã sã gʉa ya dipuwaja ta árĩporo, arĩñorã masa. ");
INSERT INTO des_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Erã eroparĩcʉ̃ peegʉ Pilato Barrabáre peresugue árĩdigʉre wiudorepʉ masa erã gamegʉre. Eropa iituha Jesupʉre yuradari mera tãradore, ĩgʉre crusague pabia wejẽdoregʉ wiapʉ surarare. ");
INSERT INTO des_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ĩgʉ eropa wiacʉ̃ Pilato ya wihigue ĩgʉ surara aĩ ejañorã Jesure. Eropirã erã surara árĩpehrerãre Jesu pohrogue gameneoñorã. ");
INSERT INTO des_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Eropirã ĩgʉ suhrire tuwea aĩ, opʉ ya suhriro dopa bejariñere Jesure sãñorã. ");
INSERT INTO des_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eropa sãtuha, pora berore iituha, ĩgʉ dipuru weca duhpeoñorã. Eropa duhpeotuha, yucʉgʉre diayepʉ mohsuañorã. Mohsuatuha, õpa arĩ wereyañorã erã ĩgʉre ĩgʉ pohro merejarã: —Umupeorã arique. Judio masa opʉ õaro árĩporo, arĩ wereyañorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eropirã ĩgʉre disico ehosũñorã. Erã mohsuadigʉre ĩgʉre tʉãwea aĩ, ĩgʉ dipurure pañorã irigʉ mera. ");
INSERT INTO des_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ĩgʉre eropa wereyara pʉhrʉ erã sãra suhrirore tuwea aĩ ĩgʉ ya suhriropʉre sãñorã daja. Eropirã crusague pabia wejẽmorã ĩgʉre aĩ wiria wañorã. ");
INSERT INTO des_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ĩgʉre aĩgã, Simo waĩcʉgʉre Cirene majagʉre bocatĩri, ĩgʉre Jesu ĩgʉ coãra crusare coãtamudorema. ");
INSERT INTO des_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Coãgã Gólgota waĩcʉrogue ejama. Gólgota arĩro, mari ya mera “Dipu pero” arĩro iiaa. ");
INSERT INTO des_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Eropirã vinore sʉĩri deco mera erã morera decore Jesure orima erã. Iri decore ihriña, ihribirimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Eropirã ĩgʉ suhrire tuwea aĩra pʉhrʉ ĩgʉre crusague pabiama erã. Eropa pabiatuha ĩgʉ suhri mʉrare, “¿Noa yañe árĩrocuri iñe?” arĩ masimorã erã basi game deamehtu birama. Eropa iirã Goãmʉ yare weremʉhtadigʉ ĩgʉ arĩdiro dopa ta iirã iima erã. Õpa arĩ gojañumi ĩgʉ: “Yaha suhrire erã basi aĩmorã, ‘¿Noa yañe árĩrocuri iñe?’ arĩ masimorã erã basi game deamehtu birama erã,” arĩ gojañumi iribojeguere. ");
INSERT INTO des_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Deabiratuha ĩgʉre ĩhadoacurima erã. ");
INSERT INTO des_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ĩgʉ dipuru weca crusague õpa arĩ gojarapũre pabia tuma erã ĩgʉre weresãra wererapũre. “Ihĩ judio masa tauro opʉ ãhrimi,” erã arĩ gojarapũre pabia tuma. ");
INSERT INTO des_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Eropirã perã yajari mʉrare Jesu pohro gaji crusarigue pabia tuma erã sãre. Yujugʉ ĩgʉ diayepʉ, gajigʉre ĩgʉ copʉ pabia tuma erã. ");
INSERT INTO des_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Crusari pohro tarigãrã Jesure ĩha, erã dipure yurerã, ñero arĩ wereniguima ĩgʉre: ");
INSERT INTO des_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—“Goãmʉ wihire cohã, ʉhrenʉ pʉhrʉ iri wihire amugʉra daja,” arĩ wereniguidigʉ árĩribʉ mʉhʉ. Goãmʉ magʉ árĩgʉ mʉ basi dijaque. Eropigʉ mʉ basi itamuque. Eropigʉ tari weregʉca mʉhʉ, arĩma masa. ");
INSERT INTO des_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eropa ta pahia oparã, masare buherã sã eropa arĩ wereyama. ");
INSERT INTO des_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ĩgʉ gajirãre taudigʉ árĩqueregʉ ta ĩgʉ basi taumasibeami. “Israe masa opʉ ãhraa,” arĩrimi ĩgʉ. Eropirã ĩgʉ basi ĩgʉ dijaricʉ̃ ĩarã ĩgʉre umupeorãca. ");
INSERT INTO des_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ĩgʉpʉ Goãmʉre umupeorimi. Eropigʉ “Goãmʉ magʉ ãhraa,” arĩrimi ĩgʉ. Ĩgʉ eropa arĩgʉ árĩcʉ̃ Goãmʉpʉ ĩgʉre itamuporo, arĩ wereyama erã. ");
INSERT INTO des_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yajari mʉra ĩgʉ pohro erã pabianirã eropa ta ĩgʉre wereya ñero wereniguima erã sã. ");
INSERT INTO des_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Eropi goeri boje árĩcʉ̃ ʉhre hora gohra árĩpehrerogue naitĩa wabʉ. ");
INSERT INTO des_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Eropigʉ irisubu naitĩa wari subure Jesu turaro gaguinimi: —Elí, Elí, ¿lema sabactani? arĩmi ĩgʉ. Eropa arĩgʉ õpa arĩgʉ iimi mari ya mera: “Yʉ Goãmʉ, yʉ Goãmʉ, ¿duhpigʉ yʉre cohãri mʉhʉ?” arĩgʉ iimi. ");
INSERT INTO des_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ĩgʉ eroparĩcʉ̃ peenirã yujurãyeri ero niguinirã õpa arĩrima: —Goãmʉ ya weremʉhtadigʉre Eliare sihugʉ iicumi, arĩrima erã. ");
INSERT INTO des_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eropigʉ yujugʉ erã mera majagʉ mimi aĩri yʉsʉ mera vino sʉĩrire yosotuha, aĩ omagã, yucʉgʉ ojogorore diritu, Jesure simujumi. ");
INSERT INTO des_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ĩgʉ eropa iicʉ̃ ĩarã gajirã simujugʉre õpa arĩma: —Corenique. Elia ĩgʉre ĩgʉ itamucʉ̃ ĩanirã dohpa mari, arĩma erã. ");
INSERT INTO des_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Erã eropa arĩra pʉhrʉ dipaturi Jesu turaro gaguinigui sĩria wami. ");
INSERT INTO des_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ĩgʉ sĩricʉ̃ ta Goãmʉ wihi majañe suhriro ero erã cãhmotara suhriro deco mera yehguea wayoro. Eropiro yeba sã ñohmebʉ. Eropa ñohmecʉ̃ ʉtã sã pagayeri sã wahria wabʉ. ");
INSERT INTO des_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Eropirã masa goberi pãricʉ̃, bajarã Goãmʉ yarã árĩnirã iribojegue sĩrinirã mʉra masa wiriañorã. ");
INSERT INTO des_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Masa wiriarã iri goberire cóãcã õari macague Jerusaléngue wañorã erã. Erogue erã wacʉ̃ masa bajarã erãre ĩañorã. ");
INSERT INTO des_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Eropirã yeba ñohmecʉ̃ ĩarã, sĩrinirã mʉra erã masa wiriacʉ̃ ĩarã, surara opʉ ĩgʉ surara mera ʉca wama. Erã Jesure crusague árĩgʉre corerã árĩma. Ʉca wa, õpa arĩma: —Diaye ta ãhraa. Ihĩ Goãmʉ magʉ ta ãhrañumi, arĩma erã. ");
INSERT INTO des_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Eropirã Galileague Jesu mera arinirã ĩgʉre itamunirã nome árĩma. Yoarogue crusague tuyagʉre ĩhabeo niguibʉ gʉa erã mera. ");
INSERT INTO des_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Erã nome mera María Magdalena árĩmo. Gajigo María waĩcʉgo sã árĩmo. Igopʉ Santiago, José sã pago árĩmo. Gajigo Zebedeo marapo árĩmo. ");
INSERT INTO des_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Eropi ñamicague José Arimatea majagʉ doberi opagʉ ero árĩmi. Ĩgʉ Jesu buhegʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Eropigʉ Pilato pohrogue eja, Jesu dʉpʉre serẽpʉ. Ĩgʉ eropa serẽcʉ̃ peegʉ Jesu mʉrʉ dʉpʉre odorepʉ Pilato. ");
INSERT INTO des_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ĩgʉ eropa dorera pʉhrʉ Josépʉ Jesu mʉrʉ dʉpʉre aĩ, diju, õari suhriro gʉhrari mariri suhriro mera ĩgʉ dʉpʉre omapʉ. ");
INSERT INTO des_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Omatuha, José ĩgʉ ya masa gobegue apipʉ ĩgʉ dʉpʉre. Iri gobe erã ʉtãyegue erã seara gobe mama gobe árĩyoro. Iri gobegue apituha, wʉariye ʉtãyere taragãpʉ iriye mera bihabu. Bihatuha, waha wapʉ. ");
INSERT INTO des_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Eropirã María Magdalena, gajigo María mera iri gobeguere ĩhadoa coreñorã. ");
INSERT INTO des_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Eropi gajinʉ, Pascua árĩburire erã amuranʉ pʉhrʉ Sabado árĩcʉ̃ pahia oparã, fariseo masa sã Pilato pohro gamenereñorã. ");
INSERT INTO des_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Gameneretuha õpa arĩñorã erã Pilatore: —Opʉ, irire guñaa gʉa. Ĩgʉ gʉyaricʉgʉ Jesu ojocarinigʉ õpa arĩpʉ ĩgʉ: “Ʉhrenʉ pʉhrʉ masa mʉriagʉca yʉhʉ,” arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ĩgʉ eropa arĩdigʉ árĩcʉ̃ ĩgʉ buherãpʉ ĩgʉ dʉpʉre yajabocoma. Eropa yajarã masare õpa arĩbocoma: “Jesu masa mʉriami,” arĩbocoma erã. Ĩgʉ Jesupʉ masare gʉyagʉ iimi. Ĩgʉ buherã sã “Ĩgʉ masa mʉriami,” arĩrã gʉyarã iirãcoma. Eropirã Jesu ĩgʉ gʉyadiro tauro erã gʉyaripʉ ñetariaroca. Eropa yajari arĩgʉ ʉhrenʉ gohra mʉ surarare coredoreque erã ĩgʉ mʉrʉre apidirogue, arĩñorã erã Pilatore. ");
INSERT INTO des_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato yʉhripʉ: —Áʉ. Yaharã surara coreporo. Eropirã mʉa bocatĩuropẽ iri gobere õaro coreque, arĩpʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ĩgʉ eroparĩcʉ̃ erã waha, iri gobere bihariye merague ta pihatuñorã masa erã ñajacʉ̃ ĩha masimorã. Eropirã surarare iri gobere coredoreñorã. ");
INSERT INTO des_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Eropi judio masa soorinʉpʉ Sabadonʉpʉ irinʉ taricʉ̃, Domingo árĩcʉ̃ ñamiñarigã árĩcʉ̃ María Magdalena gajigo María mera Jesu masa gobere ĩarã wañorã. ");
INSERT INTO des_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Eropiro mata yeba turaro ñohme purumujuyoro. Eropa ñohmecʉ̃ mari Opʉ ĩgʉ anyu ʉmarogue aridigʉ dijari, masa gobere bihariyere ʉtãyere tarabeo iriye weca doapʉ. ");
INSERT INTO des_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ĩgʉ anyu bupu miaro dopa õaro gosesirigʉ, ĩgʉ suhri yaji poari iro dopa õaro boreri suhricʉgʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ĩgʉ eropa dehyoacʉ̃, surara iri gobere corerã, ʉcataria wa, naragã, weca gohrare sĩrinirã iro dopa wañorã. ");
INSERT INTO des_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eropigʉ anyupʉ erã nomere õpa arĩpʉ: —Yʉre güibiricãque. Crusague erã pabiadigʉre Jesure mʉa amacʉ̃ masia yʉhʉ. ");
INSERT INTO des_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ĩgʉ dohpaguere õre marimi. Ĩgʉ arĩdiro dopa ta ĩgʉ masa mʉria wami. Erã ĩgʉ dʉpʉre erã apidirore ĩarã arique. ");
INSERT INTO des_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tuhaja ĩgʉ buherã pohrogue ʉmʉdiaro waha, õpa arĩ wererã waque: “Ihĩ Jesu sĩridigʉ masa mʉriami. Eropigʉ mʉa core Galileague ĩgʉ wamʉhtagʉcumi. Erogue ĩgʉre ĩarãca mʉa,” arĩ wererã waque mʉa. I yʉ arĩrare guñaque mʉa, arĩpʉ anyu erã nomere. ");
INSERT INTO des_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ĩgʉ eropa arĩra pʉhrʉ erã nome masa gobegue árĩnirã nome yojaro mera wiria, erã ĩarare güiquererã ta, mucubiriri mera Jesu buherãre wererã warã, omañorã. ");
INSERT INTO des_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Eropa warã nomere Jesu bocatĩripʉ: —¿Noho wahari mʉa? arĩ serẽpipʉ ĩgʉ. Ĩgʉre ĩha erãpʉ ĩgʉ pohrogue eja, ĩgʉ guburire ñeha ĩgʉre umupeoñorã. ");
INSERT INTO des_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—Güibiricãque mʉa. Yʉ pagʉ porãre “Galileague waque,” arĩ wererisa. Erogue yʉre ĩarãcoma, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Erã nome wererã warisubu surara watope yujurãyeri masa gobere corenirã surara Jerusaléngue pahia oparãre wererã wañorã. Jesu ĩgʉ masa gobegue ĩgʉ mʉriarare werepehocãñorã. ");
INSERT INTO des_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Erã eropa arĩ werecʉ̃ pahia oparã, mʉrã mera gamenereñorã. Gamenere weretamuñorã. Eropirã surarare gʉyadorerã niyerure wajayeñorã. ");
INSERT INTO des_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Õpa arĩque mʉa masare: “Ñami gʉa carĩra pʉhrʉ, ĩgʉ buherãpʉ masa gobegue eraa, ĩgʉ dʉpʉre aĩcãnirã ãhrama,” arĩ wereque masare. ");
INSERT INTO des_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mʉa eropa arĩ werecʉ̃ Pilatopʉ mʉa carĩtariarare peecãbocumi. Ĩgʉ eropa peecʉ̃, ĩgʉre wererãra gʉa. “Erãre dipuwaja moabiricãque,” arĩ wererãra gʉa ĩgʉre, arĩñorã erã surarare. ");
INSERT INTO des_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Erã eropa arĩra pʉhrʉ surarapʉ niyerure ñeha, erãre erã gʉyadorediro dopa ta masare wererã wañorã erã. “Jesu buherã aĩcãnirã ãhrama ĩgʉ mʉrʉ dʉpʉre,” arĩñorã erã. Eropirã eropa Jesu ĩgʉ dʉpʉ aĩrare wereniguima judio masa. Dohpague sãre eropa ta arĩ werema erã. ");
INSERT INTO des_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Eropi gʉa Jesu buherã once buherã Galileague waha ʉtãgʉgue Jesu ĩgʉ wadoredigʉgue wabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Erogue eja Jesure ĩarã umupeobʉ gʉa ĩgʉre. Eropa umupeoquererã ta gʉa yujurãyeri “Ihĩ Goãmʉ magʉ árĩbiribocumi,” arĩ pepiribʉ dohpa. ");
INSERT INTO des_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ĩgʉpʉ õpa arĩmi gʉare: —I yebaguere, ʉmaro sãre Goãmʉ árĩpehrerã tauro turarire omi yʉre. ");
INSERT INTO des_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ĩgʉ eropa ocʉ̃ mʉare õpa iidorea: Árĩpehrero majarãre yahare buherã waque erã yaharã erã waboro dopa. Eropirã mari Pagʉ waĩ mera, yʉ waĩ mera, Espíritu Santo waĩ mera erãre waĩyeque. ");
INSERT INTO des_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Eropirã mʉare yʉ dorerare erã iipehoburire buheque erãre mʉa. Eropirã ire yʉ arĩrare guñaque: Árĩpehrerinʉri nʉcʉ mʉa mera árĩgʉca ne i ʉmʉ pehrecʉ̃gue, arĩ weremi gʉare Jesu.");
INSERT INTO des_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Goãmʉ magʉ Jesucristo ĩgʉ iirare, õari buherire wereri õpa árĩnʉgayoro. ");
INSERT INTO des_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Goãmʉ yare weremʉhtadigʉ Isaia ĩgʉ iribojegue gojadiro dopa ta i wereri ãhraa. Õpa arĩ gojañumi ĩgʉ: Goãmʉ ĩgʉ magʉre õpa arĩpʉ: “Mʉ core mʉre wereyubure obeogʉ iiaa. ");
INSERT INTO des_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Eropigʉ ĩgʉ masa marirogue árĩgʉcumi. Ĩgʉre peerãre weregʉ bʉsʉro mera arĩ wereniguigʉcumi: ‘Mari Opʉ ĩgʉ ariburi mare amuro dopa ĩgʉ ariboro core õarã árĩyuque ĩgʉre peemorã,’ arĩ wereniguigʉcumi,” arĩpʉ Goãmʉ, arĩ gojañumi Isaia, Ñu waĩyegʉ ĩgʉ masa dehyoaboro coregue. ");
INSERT INTO des_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Eropigʉ Ñu waĩyegʉ masa marirogue masare buhemʉripʉ. Õpa arĩpʉ: —Mʉa ñero iirire bʉjawereque. Dohpaguere õaripʉre gohrotoque. Eropirã waĩyenirã árĩque. Mʉa eropa gohrotocʉ̃ ĩagʉ mʉa ñero iirare Goãmʉ cãdijigʉcumi, arĩ buhemʉripʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eropirã árĩpehrero Judea yeba majarã, Jerusalén majarã mera ĩgʉ pohrogue peerã ejañorã. Eropigʉ Ñu erãre waĩyepʉ Jordán waĩcʉriyague. Erã ñero iirare weretarituhacʉ̃ ĩha ĩgʉ erãre waĩyemʉripʉ. ");
INSERT INTO des_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Eropigʉ Ñu camello ya gasiro suhrirore suhricʉpʉ. Waibʉgʉ ya gasirore ta tʉãdiuridacʉgʉ árĩpʉ. Poreroa, mome sã ĩgʉ bari árĩyoro. ");
INSERT INTO des_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Eropigʉ õpa arĩ buhemʉripʉ: —Yʉ pʉhrʉre yʉ tauro turagʉ arigʉcumi. Õatariagʉ ãhrimi ĩgʉ. Ĩgʉ iro dopa õagʉ árĩbeaa yʉpʉ. Eropigʉ ĩgʉre pepigʉ, “Yʉ tamera bu árĩgʉ ãhraa yʉhʉ,” arĩ pepia yʉhʉ. ");
INSERT INTO des_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Masare waĩyegʉ deco mera waĩyea yʉpʉ. Ĩgʉpʉ yʉ tauro iigʉcumi. Mʉare Goãmʉ yarã iigʉcumi ĩgʉ. Espíritu Santore masa mera árĩniguicʉ̃ iigʉcumi, arĩ buhepʉ Ñu. ");
INSERT INTO des_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eropi irisubure Jesu Nazaregue, Galilea yeba árĩri maca árĩdigʉ, dia Jordán waĩcʉriyague ejapʉ. Ĩgʉ eropa ejacʉ̃ Ñu waĩyepʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ĩgʉ waĩyetuhajacʉ̃ Jesu diague niguidigʉ, majanʉgaja ʉmarogue ĩhamujupʉ. Ʉmʉsi pãrimaa wayoro. Ero pãrimaacʉ̃ ta Espíritu Santo buja iro dopa bejagʉ ĩgʉ weca dijibejajapʉ. ");
INSERT INTO des_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eropiro ʉmarogue wereniguiri bʉsʉyoro. —Mʉhʉ yʉ magʉ yʉ mahigʉ ãhraa. Mʉ mera bʉrigã mucubiria, arĩro cariyoro ʉmarogue. ");
INSERT INTO des_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Irisubure Espíritu Santo Jesure masa marirogue wadorepʉ. ");
INSERT INTO des_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Erogue ejagʉ cuarenta nʉri gohra árĩpʉ. Erogue ĩgʉ árĩcʉ̃, Satanapʉ Jesu ĩgʉ ñero iirire ĩadiagʉ ñerire iidoreripʉ ĩgʉre. Eropigʉ Jesu waimʉrã nʉgʉ majarã watope árĩpʉ. Eropirã anyuapʉ ĩgʉre itamu ĩgʉre bari oñorã. ");
INSERT INTO des_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Eropi Ñure erã peresugue erã biha dobora pʉhrʉ, Jesupʉ Galileague õari buherire Goãmʉ ĩgʉ opʉ árĩrire weregʉ wapʉ. ");
INSERT INTO des_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Õpa arĩ werepʉ: —Dohpaguere õpa ãhraa: Goãmʉ ĩgʉ opʉ árĩboro merogã dʉhyaa. Mʉa ñeri iirire bʉjawereque. Eropirã õarire gohrotoque. Õari buherire peeque mʉa, arĩ buhemʉripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Eropigʉ Galilea waĩcʉriya tʉrogue ejagʉ, Simore ĩgʉ pagʉ magʉ mera bocajapʉ. Erã wai wejẽdi masa árĩñorã. Erã wejẽdi yucʉre mehyurã iiñorã erã iri ditaru wʉari ditarugue. ");
INSERT INTO des_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Erãre arĩpʉ Jesu: —Yʉ mera majarã árĩmorã arique mʉa. Yʉ mera mʉa aricʉ̃ mʉa waire mʉa ñeha gameneorã mʉa iiro dopa ta, Goãmʉ yarã árĩmorãre sihu gameneomorãre iirã árĩcʉ̃ iigʉra mʉare. Yʉ mera mʉa aricʉ̃ eropa iimorãre apigʉra mʉare. Eropirã yʉ mera arique, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ĩgʉ eroparĩcʉ̃ peerã, erã wejẽdi yucʉre apicã ĩgʉ mera waha wañorã. ");
INSERT INTO des_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Eropirã erã merogã tarigã Santiagore ĩgʉ pagʉ magʉ Ñu sãre bocajañorã daja. Erãpʉ Zebedeo porã árĩñorã. Erã ya dohodirugue erã wejẽdi yucʉre amurã iiñorã. ");
INSERT INTO des_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Erã perãre ĩgʉ sihubeopʉ. Ĩgʉ sihubeocʉ̃ pee erãpʉ erã pagʉre ĩgʉre itamurã mera dohodirugue apicã Jesu mera waha wañorã. ");
INSERT INTO des_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Eropi erã Capernaum waĩcʉri macague ejañorã. Eropigʉ Sabado árĩcʉ̃ judio masa erã buheri wihigue buhegʉ ñajapʉ. ");
INSERT INTO des_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Eropigʉ õaro masipehogʉ buhegʉ, judio masare erã buherã iro dopa árĩbiripʉ ĩgʉ. Ĩgʉ eropa buhecʉ̃ iri maca majarã pee ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Irisubure iri wihire yujugʉ watĩ ñajasũdigʉ árĩpʉ. Eropigʉ õpa arĩ gaguiniguipʉ Jesure: ");
INSERT INTO des_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Mʉhʉ Jesu Nazare majagʉ garibobiricãque gʉare watẽare. ¿Duhpibu õpa iiri gʉare? ¿Mʉhʉ gʉare dederecʉ̃ iibu iiri? Goãmʉ magʉ mʉ õagʉ árĩcʉ̃ gʉa masia, arĩ gaguiniguipʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu turipʉ watĩre: —Ejarimaricãque. Ĩgʉre cohã wiria waque, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eropigʉ watĩ masʉre yeba mehmereja tũrucʉ̃ iipʉ. Ĩgʉ gaguiniguicʉ̃ ta wiriapʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Eropirã árĩpehrerã iri wihi doanirã ĩgʉ eropa wacʉ̃ ĩha ʉcataria waha õpa arĩñorã: —Yaho. ¿Ñehe buheri ãhriri ii? ¿Mama buheri ta ãhriri? Ĩgʉ opʉ iro dopa ta doremi watẽare. Ĩgʉ dorecʉ̃ watẽapʉ tarinʉgabeama ĩgʉre, arĩ wereniguiñorã iri wihi doarã erã basi. ");
INSERT INTO des_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eropirã bajamenʉrigã pʉhrʉgã ta, árĩpehrerã Galilea yeba majarã irire ĩgʉ eropa iirare masipehrea wañorã. ");
INSERT INTO des_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Eropi Jesu sã judio masa erã buheri wihigue árĩnirã wiria wañorã. Erã eropa wiriara pʉhrʉ Jesu, Santiago, Ñu mera, Simo ĩgʉ pagʉ magʉ Andre sã ya wihigue ñajapʉ. ");
INSERT INTO des_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Irisubure Simo mʉñeco nimacʉri dorecʉgo camague igo oyacʉ̃ wereñorã Jesure. ");
INSERT INTO des_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Erã eropa werecʉ̃ peegʉ, ĩgʉ igo pohrogue eja, igo mojotore ñeha, igore tara wahgũ dobopʉ. Ĩgʉ tara wahgũ dobocʉ̃ ta igore nimacʉri taria wayoro. Taricʉ̃ pepigo igopʉ wahgã erãre bari ejopo. ");
INSERT INTO des_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ñamicague abe ñajara pʉhrʉgue masa árĩpehrerã dorecʉrãre, gajirã watẽa ñajasũnirãre, pũriri dorecʉrãre Jesu pohrogue aĩ ejañorã. ");
INSERT INTO des_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eropirã árĩpehrerã iri maca majarã gamenereñorã Jesu árĩri wihi disiporore. ");
INSERT INTO des_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Eropigʉ Jesu bajarã dorecʉrãre, baja dore oparãre õarã wacʉ̃ iipʉ. Masa bajarãre watẽare wiupʉ. Eropigʉ watẽa Jesu Goãmʉ magʉ ĩgʉ árĩrire erã masicʉ̃ ĩagʉ Jesupʉ erãre irire weredorebiripʉ. ");
INSERT INTO des_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Eropigʉ ñamiñarigã árĩcʉ̃ boyoboro core, ĩgʉ wahgãra pʉhrʉ masa marirogue ĩgʉ Pagʉ Goãmʉre serẽgʉ wapʉ. ");
INSERT INTO des_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ĩgʉ eropa wacʉ̃ ĩarã Simo sã ĩgʉre amarã ejañorã. ");
INSERT INTO des_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eropirã ĩgʉre bocatĩri õpa arĩñorã: —Masa árĩpehrerã mʉre ahmama, arĩñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Erã eroparĩcʉ̃ peegʉ õpa arĩpʉ Jesupʉ. —I macare buhegʉ ahrabʉ yʉhʉ. Eropirã gaji macari sãre õgã maja macari sãre buherã warã mari. Yʉhʉ iri macari sãre buhegʉra, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eropigʉ árĩpehrero Galilea yebare buhecuripʉ. Eropigʉ macari nʉcʉ erã ya buheri wirigue ñajaja buhepʉ. Pũriri dorecʉrã sãre pũririre cóãpʉ. Watẽare masare ñajanirãre cohã wiupʉ. ");
INSERT INTO des_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Eropi gajigʉ cami boagʉ Jesu pohrogue eja, mereja serẽpʉ: —Mʉhʉ yʉre õagʉ wacʉ̃ iidiagʉ, yʉre õagʉ wacʉ̃ iimasia, arĩpʉ cami boagʉpʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu ĩgʉre mojomoro ĩapʉ. Eropigʉ Jesu ĩgʉ mojoto mera mohmepipʉ. Mohmepigʉ ta õpa arĩpʉ: —Irire iidiaca. Õagʉ árĩque mʉhʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ĩgʉ eroparĩcʉ̃ ta ĩgʉ cami boara yaria wayoro. Õagʉ wapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ĩgʉ eropa wacʉ̃ ĩagʉ Jesu ĩgʉre turaro mera werepʉ: ");
INSERT INTO des_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Yʉhʉ mʉre õpa iirare gajirãre ne werebiricãque. Eropa werebiriqueregʉ ta mʉ dʉpʉre õaro warare pahire ĩhmugʉ waque, “Õagʉ ãhrimi,” arĩdoregʉ. Goãmʉ doreri Moisere ĩgʉ apidiro dopa ta iique. Eropigʉ mirimagʉgãre oque pahire mʉ õagʉ warare masare mʉ ĩhmuburire, arĩpʉ Jesu ĩgʉre. Õpa arĩtuhaja waque, arĩpʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ĩgʉ eropa masare weredorebiriquerecʉ̃ ta ĩgʉpʉ waha árĩpehreri macari majarãre Jesu ĩgʉre õagʉ wacʉ̃ iirare werepʉ. Ĩgʉ eropa werera pʉhrʉ Jesu masa bajarã erã árĩroguere wamasibiripʉ. Eropigʉ ĩgʉ masa bajamerãgã árĩrogue árĩpʉ. Erogue ĩgʉ árĩcʉ̃ baja macari majarã ĩgʉ pohrogue ejañorã. ");
INSERT INTO des_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bajamenʉri pʉhrʉ Jesu Capernaumgue dujaa wapʉ. Wihigue ĩgʉ árĩcʉ̃ masa masiñorã. ");
INSERT INTO des_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Eropirã masa ero bajarã gamenere iri wihire ʉjʉtʉria waha disiporogue wirinʉgajañorã. Eropigʉ Jesu erãre õari buherire werepʉ. ");
INSERT INTO des_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Eropirã gajirã sã Jesu pohro ejariñorã. Erã wapicʉrã ʉma dʉpʉ bʉhadigʉre aĩ ejañorã. ");
INSERT INTO des_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eropa ejarã masa bajarã árĩcʉ̃ ĩarã Jesu pohrogue aĩ ñajamasibiriñorã. Eropirã erã dʉpʉ bʉhadigʉre aĩ muju wihi weca aĩ weasiri ñajaa Jesu ĩgʉ niguiro weca pihri dijuñorã. “Jesu ihĩ ĩgʉ dorecʉrire taricʉ̃ iigʉcumi,” arĩ pepiñorã erã. ");
INSERT INTO des_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Erã eroparĩ pepicʉ̃ masigʉ Jesupʉ dorecʉgʉre õpa arĩ werepʉ: —Mahgʉ, mʉ ñero iirare cóãtuhabʉ, arĩpʉ Jesu dʉpʉ bʉhadigʉre. ");
INSERT INTO des_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ĩgʉ eroparĩcʉ̃ peerã erogue doarã judio masare buherãpʉ erã basi õpa arĩ pepiñorã: ");
INSERT INTO des_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ihĩ eropa arĩ were­nigui­biricãporo. Goãmʉre ñero wereniguigʉ iimi ihĩ. Ĩgʉ masʉ mari iro dopa árĩgʉ ãhrimi ĩgʉ sã. Eropigʉ ĩgʉ mari ñero iirare cóãmasibeami. Goãmʉ dihta masa erã ñero iirire cóãmasimi,” arĩ pepiñorã erã. ");
INSERT INTO des_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Erã eropa arĩ pepicʉ̃ ĩagʉ, Jesu erã pepirire masigʉ õpa arĩpʉ erãre: —¿Duhpirã mʉa eropa arĩ pepiri? ");
INSERT INTO des_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Mʉ ñero iirare cóãtuhabʉ,” yʉ arĩcʉ̃ pee “Gʉyaricʉgʉ ãhrimi,” arãa mʉa yʉre masibiriquererã ta. Ihĩ dʉpʉ bʉhadigʉre “Wahgã­nʉgajaque,” yʉ arĩcʉ̃ ĩgʉ wahgãnʉgajacʉ̃ ĩarã yʉ arĩra diaye árĩcʉ̃ masirãca mʉa. ");
INSERT INTO des_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ árĩgʉ i yebaguere masa erã ñero iirire cóãmasia yʉhʉ. Mʉa irire masiboro dopa ĩgʉre wahgãnʉgajacʉ̃ iigʉra, arĩpʉ Jesu judio masare buherãre. Eropa arĩtuhaja dʉpʉ bʉhadigʉre õpa arĩpʉ: ");
INSERT INTO des_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Mʉre arĩgʉ iiaa: Wahgãnʉgajaque. Curique. Mʉ pũgʉre aĩ waque mʉ ya wihigue, arĩpʉ ĩgʉre Jesu. ");
INSERT INTO des_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ĩgʉ eroparĩcʉ̃ peegʉ dʉpʉ bʉhadigʉpʉ wahgãnʉgaja, ĩgʉ pũgʉre aĩ árĩpehrerã masa erã ĩhuro wiria waha wapʉ. Ĩgʉ eropiicʉ̃ ĩarã erã árĩpehrerã ĩhamaria wañorã. —Goãmʉ õagʉ turagʉ ãhrimi. Ne õpa iirire ĩabirimʉrabʉ mari, arĩñorã erã basi. ");
INSERT INTO des_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Eropi dipaturi Jesu ditaru tʉrogue wapʉ. Eropigʉ masa bajarã ĩgʉ pohrogue eja gamenerecʉ̃ ĩagʉ ĩgʉ erãre buhepʉ. ");
INSERT INTO des_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Eropa iituha, erogue árĩdigʉ wagʉ, Levíre Alfeo magʉre ĩgʉ mohmeri taribugue bocajapʉ. Gajirã mera oparã ya árĩburire wajasea corerã mera árĩpʉ Leví. Ĩgʉre bocajagʉ õpa arĩpʉ: —Yʉ mera majagʉ árĩbu arique mʉhʉ, arĩpʉ Jesu Levíre. Ĩgʉ eroparĩcʉ̃ peegʉ Levípʉ wahgãnʉgaja Jesu mera waha wapʉ. ");
INSERT INTO des_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pʉhrʉ ĩgʉ ĩgʉ buherã mera Leví ya wihire mesague ba doacʉ̃ bajarã wajasea corerã “Ñero iirã ãhrima,” masa erã arĩrã erã mera ba doañorã. ");
INSERT INTO des_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Erogue erã doara pʉhrʉ, gajirã judio masare buherã, fariseo masa sã Jesu ñero iirã mera ĩgʉ bacʉ̃ ĩañorã. Eropa ĩarã õpa arĩñorã: —¿Duhpigʉ ñero iirã wajasea corerã mera bahari Jesu? arĩ serẽpiñorã judio masare buherã Jesu buherãre. ");
INSERT INTO des_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Erã eroparĩcʉ̃ peegʉ õpa arĩ yʉhripʉ Jesupʉ: —Dorecʉrã dihta duhturure ahmama. Dorecʉrã duhturure amaro dopa ta “Ñegʉ ãhraa yʉhʉ,” arĩrã yʉre amarãcoma. Eropigʉ “Ñegʉ ãhraa,” arĩrã dihtare erã ñero iirare bʉjaweredore õaripʉre gohrotocʉ̃ iigʉ aribʉ yʉhʉ. Erã basi “Õarã ãhraa gʉa,” arĩ pepirãpʉre itamugʉ aribiribʉ, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Irisubure Ñu buherã, fariseo masa sã Goãmʉre umupeomorã ba duhumʉriñorã. Eropirã masa Jesu pohro eraa ĩgʉre serẽpiñorã. —Erã Ñu buherã, fariseo masa buherã sã Goãmʉ ya árĩburire iirã, ba duhumʉrama. ¿Duhpirã mʉ buherãpʉ ba duhubeari? arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Erã eroparĩcʉ̃ pee Jesu erãre õpa arĩ yʉhripʉ: —Õpa ãhraa iri: Mojoto diridigʉ ĩgʉ bosenʉre iicʉ̃ ĩgʉ mera majarã bʉjawererã ba duhurã iibeama. Ĩgʉ mera árĩrã mucubiri barã iima. Eropa ta yʉ buherã sã yʉ mera árĩrã ba duhumasibeama. ");
INSERT INTO des_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yujunʉ Goãmʉ yʉre aĩcãgʉcumi. Eropa ĩgʉ aĩgãra pʉhrʉ yʉ buherã mera árĩsome yʉhʉ. Eropirã irisubugue tamerare yʉ buherã ba duhurãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Erã iribojegue maja buheri mera mama buheri mera erã buhe morediacʉ̃ ĩagʉ õpa arĩ werenemopʉ Jesu werenigui queori mera: —Ne mama gasiro suhri gasiro mera mʉrañe suhrirore seretu masiya mara. Eropiicʉ̃ mama gasiro mari coera pʉhrʉ mʉrañere suhrirore taragameneo, wʉatariaro yehguecʉ̃ iiaa. Eropa ta mama buherire mʉra buheri mera wapi moa buhebiricãro gahmea. ");
INSERT INTO des_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Eropirã ne igui decore imisĩri decore waibʉgʉ gasiro ajurore mʉra ajurore pisãbiricãro gahmea. Eropiro igui deco pahmutarirogue mʉra ajurore yehgue dija wahaa. Iri ajuro yehguecʉ̃ igui deco sã cohmo, ajuro sã cohmoa wahaa. Eropirã igui decore mama ajuro mera pisãro gahmea. Eropiicʉ̃ igui deco sã cohmobeaa. Ajuro sã cohmobeaa. Eropa ta mama buheri, mʉra buheri mera more buhebiricãro gahmea, arĩ buhepʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gajinʉ Sabado árĩcʉ̃ Jesu sã trigo pohegue ĩha taria wañorã. Erogue tariarã ĩgʉ buherãpʉ trigo pororire tʉrĩ tari wahgãñorã. ");
INSERT INTO des_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Erã eropiicʉ̃ ĩarã õpa arĩñorã fariseo masa Jesure: —Peenique gʉare. ¿Duhpirã mʉ buherã Sabadonʉ mari soorinʉ árĩquerecʉ̃ Goãmʉ ĩgʉ mohmedorebiririnʉre mohmeri erã? Mari dorerire tarinʉgarã iima, arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Erã eroparĩcʉ̃ peegʉ yʉ buherã tarinʉgarã iibeama arĩgʉ õpa arĩpʉ erãre: —Iribojegue Davi ĩgʉ mera majarã mera oaboagʉ Goãmʉ wihigue ñaja iri wihi árĩri panre Goãmʉ ya panre bañumi. Eropigʉ ĩgʉ mera majarã sãre badoregʉ iri panre oñumi. Iri panre pahia dihtare badorera árĩyoro. Goãmʉ doreri gajirãre iri panre badorebiriyoro. Irisubure Abiata waĩcʉgʉ pahia opʉ árĩñumi. ¿Davi sã irire erã iirare Goãmʉ yare erã gojarare buhebirari mʉa? Davi iri panre bagʉ Goãmʉre tarinʉgagʉ iibiriñumi. Dohpagãre yʉ buherã sã i trigo yerire tʉrĩ barã Goãmʉre tarinʉgarã iibeama, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Eropa arĩtuhaja õpa arĩnemopʉ: —Goãmʉ masare iituhajagʉ soorinʉre doreñumi “Masa sooporo,” arĩgʉ. Eropa iigʉ masa inʉre iiburire weregʉ ãhrimi. Masapʉ inʉre erã iiburire wererã árĩbeama. ");
INSERT INTO des_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Eropigʉ yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ inonʉ soorinʉ sãre masa erã iiburire doremasia, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gaji Sabado árĩcʉ̃ Jesu judio masa erã buheri wihigue eja ñajapʉ daja. Eropigʉ mojoto bʉhadigʉ sã ero árĩpʉ. Eropirã iri wihi árĩrã Jesure ĩhanʉrʉñorã ĩgʉre weresãmorã. ");
INSERT INTO des_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sabado árĩcʉ̃ Jesu mojoto bʉhadigʉre ĩgʉ õagʉ iicʉ̃ ĩarã, “Mari soorinʉre Jesu mohmegʉ iimi,” arĩ weresãdiañorã Jesure. ");
INSERT INTO des_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Eropigʉ õpa arĩpʉ Jesu mojoto bʉhadigʉre: —Wahgãnʉgajaque. Arique õgue, arĩpʉ. Õpa arĩtuha iri wihi árĩrãre werepʉ: ");
INSERT INTO des_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","—¿Sabado árĩcʉ̃ õarire iicʉ̃ õabeari? ¿Ñerire iicʉ̃pʉre õhari mʉa pepicʉ̃? Sabado árĩcʉ̃ masʉre masucʉ̃ õapũrica. Masʉre wejẽcʉ̃pʉre õabeaa, arĩ werepʉ Jesu erãre. Ĩgʉ eropa arĩquerecʉ̃ ta yʉhribiriñorã. ");
INSERT INTO des_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Erã eropa yʉhribiricʉ̃ ĩagʉ Jesu erãre ĩhamehtu erã mera guapʉ. Erã ĩgʉre peediabiricʉ̃ ĩagʉ Jesu erã mera bʉjawerepʉ. Eropigʉ mojoto bʉhadigʉre arĩpʉ: —Mʉ mojotore sĩsirãbeoque, arĩpʉ ĩgʉre. Ĩgʉ eroparĩcʉ̃ peegʉ ĩgʉ mojotore sĩsirãbeopʉ ĩgʉ. Ĩgʉ eropiicʉ̃ ta õari mojoto wayoro. ");
INSERT INTO des_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ĩgʉ ya mojoto õari mojoto wacʉ̃ ĩarã fariseo masa wiria wañorã. Wiria Herode curu majarã mera gamenere, “¿Dohpa ii ihĩ Jesure wejẽrãcuri?” arĩ weretamuñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Eropi Jesu ĩgʉ buherã mera ditaru tʉrogue wapʉ. Erã erogue wacʉ̃ ĩarã Galilea majarã masa bajarã erã pʉhrʉ nʉrʉsiañorã. Eropirã Judea yeba majarã, Jerusalén majarã, Idumea yeba majarã, Jordán waĩcʉriya gajipʉ masegue majarã, Tiro majarã, Sidón majarã ĩgʉre ĩarã wañorã ĩgʉ iirare peenijarã. ");
INSERT INTO des_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Eropirã bajarã árĩñorã Jesu pohrore. Tuucãhmota nʉgajacãñorã. Eropigʉ Jesu ĩgʉ buherãre gasirure amuyudorepʉ ĩgʉ doaborore. ");
INSERT INTO des_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bajarã dorecʉrãre ĩgʉ õarã wacʉ̃ iicʉ̃ ĩarã gajirã dorecʉrã sã ĩgʉre pẽhrediañorã. ");
INSERT INTO des_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Eropirã watẽa ñajasũnirã Jesure ĩarã ĩgʉ pohro mereja arĩñorã: —Mʉhʉ Goãmʉ magʉ ãhraa, arĩ gaguiniguiñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eropigʉ erãre Goãmʉ magʉ ĩgʉ árĩrire turaro mera gajirãre weredorebiripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Eropigʉ Jesu ʉtãgʉgue mʉria ĩgʉ gamerãre sihupʉ. Ĩgʉ eropa sihubeocʉ̃ peerã ĩgʉ pohrogue ejañorã. ");
INSERT INTO des_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Eropigʉ doce ʉmare ĩgʉ mera majarãre, ĩgʉ obeomorãre beyepʉ. Gaji macarigue ĩgʉ yare buherã wamorãre beyedobopʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Eropigʉ watẽare erã cóãburire apipʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Oã árĩñorã doce gohra ʉma ĩgʉ beyenirã. Simo, Santiago Zebedeo magʉ, ĩgʉ pagʉ magʉ Ñu, Andre, Felipe, Bartolomé, Mateo, Toma, Santiago Alfeo magʉ, Tadeo, Simo celote ya curu majagʉ, Juda Iscariote, oã nʉcʉre Jesu beyedobopʉ. Jesu Simore Pedro waĩyepʉ. Santiagore, Ñu mera Boanerges waĩyepʉ. Boanerges mari ya mera “bupu masa” waĩcʉma. Juda Iscariote Jesure ĩhaturirãre ĩhmubu árĩpʉ. Erãre beyedobotuha Jesu dijaha wihigue ñaja wapʉ. ");
INSERT INTO des_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Eropi ero dipaturi masa bajarã gamenereñorã daja erã pohro. Eropirã ĩgʉ ĩgʉ buherã sã ne bamasibiriñorã. ");
INSERT INTO des_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eropirã Jesu acawererã ĩgʉ iirare peebeoñorã. “Jesu goroweregʉ wagʉ iimi,” masa arĩcʉ̃ peeñorã. Eropirã ĩgʉ pohrogue eja ĩgʉre aĩgãridiariñorã. ");
INSERT INTO des_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Gajirãpʉ õpa arĩñorã: —Beelzebú ĩgʉre eropa iicʉ̃ iicumi. Ĩgʉ watẽare cóãgʉ Beelzebú watẽa opʉ turari mera erãre cohãmi, arĩñorã Jerusaléngue arinirã judio masare buherãpʉ. ");
INSERT INTO des_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Erã eroparĩcʉ̃ peegʉ Jesupʉ erãre sihubeo werenigui queoriñe mera werepʉ erãre. —Watĩ ya turari mera watẽare cóãgʉ iibeaa. Watẽa erã basi cóãmasibeama. ");
INSERT INTO des_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Eropirã yuju yeba majarã erã basi gamequeãrã iri yeba majarã pehrea wacoma. ");
INSERT INTO des_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Eropirã yuju wihi majarã erã basi erã gamequeãrã iri wihi majarã pehrea wacoma. ");
INSERT INTO des_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Eropigʉ ĩgʉ Satana watẽa opʉpʉ watẽare yʉre cóãdoregʉ, ĩgʉ basi ta gamequeãgʉ iibocumi. Eropigʉ ĩgʉ pehrea wabocumi. ");
INSERT INTO des_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Õpa ta ãhraa watĩ turagʉre tarinʉgari werediacʉ̃: Wihi opʉre turagʉre diribigʉ, yajari masʉ ĩgʉ ya wihire ñajaja yajamasibeami. Ĩgʉre ĩgʉ dirira pʉhrʉ tamerare ñajaja yajamasimi ĩgʉre, arĩ werepʉ Jesu. Eropa arĩ werepʉ watĩre ĩgʉ tarinʉgarare weregʉ. Watĩ turagʉ árĩquerecʉ̃ ta Jesu ĩgʉre tarinʉgami watẽare cohã wiugʉ. ");
INSERT INTO des_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Eropigʉ arĩnemopʉ Jesu: —Diaye arĩgʉ iiaa mʉare. Árĩpehreri masa erã ñeri iicʉ̃ sãre, erã wereniguicʉ̃ sãre Goãmʉ cãdijimasimi. ");
INSERT INTO des_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Eropa cãdijiqueregʉ ta Espíritu Santore erã ñero wereniguicʉ̃ iri tamerare ne cãdijisome. Erã eropa arĩra waja eropa dipuwajacʉniguicãrã árĩrãcoma, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu Espíritu Santo turari mera mohmequerecʉ̃ erãpʉ “Watĩ turari mera mohmemi,” arĩñorã. Erã eropa arĩra waja Jesu eropa arĩ werepʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eropirã Jesu pagʉ porã ĩgʉ pago mera erañorã. Eropa erarã disiporogue niguirã gajirãre sihudoreñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eropirã masa ĩgʉ pohrogue doarã wereñorã ĩgʉre. —Mʉ pago mʉ pagʉ porã mera disiporogue sihuma mʉre erã, arĩñorã. ");
INSERT INTO des_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Erã eroparĩcʉ̃ peegʉ õpa arĩpʉ Jesu erãre buhebu: —¿Noa ãhriri yʉ pago yʉ pagʉ porã sã mʉa ĩacʉ̃? arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eropa arĩgʉ ĩgʉ pohro doarãre ĩagʉ õpa arĩpʉ: —Oã ãhrima yʉ pago, yʉ pagʉ porã dopa árĩrã. ");
INSERT INTO des_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Goãmʉ gamerire iima oã. Eropa ta iirã yʉ pagʉ magʉ, yʉ pagʉ mago, yʉ pago iro dopa ãhrima, arĩ buhepʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Eropi dipaturi ta daja Jesu ditaru tʉrogue buhenʉgapʉ. Eropa eroguere buhenʉgagʉ masa bajarã ĩgʉ pohrogue gamenerecʉ̃ ĩagʉ Jesu dohodirugue ñaja buhe payapʉ. Eropirã masapʉ yebague ditaru tʉrogue niguiñorã ĩgʉre peemorã. ");
INSERT INTO des_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eropigʉ Jesu baja werenigui queorire erãre buhepʉ. ");
INSERT INTO des_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—I queoriñere peeque mʉa, arĩpʉ erãre. —Oteri masʉ otegʉ wañumi. ");
INSERT INTO des_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ĩgʉ eropa otecʉ̃ gajiyeri ma tʉro yurimerejayoro. Ero mehmerejarayerire mirimagʉ porã ahri bacãñuma. ");
INSERT INTO des_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Eropi gajiyeri ʉtãyeri watope yuri­merejayoro. Ero ʉtãyeri watope nicu mariñariro árĩquerecʉ̃ ta, mata puhririyoro. ");
INSERT INTO des_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Eropa puhrira árĩquerero, abe ĩgʉ bʉrigã asicʉ̃, nuguri marinijaro ñaiñaja sĩria wayoro. ");
INSERT INTO des_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gajiyeri poracʉrogue yurimerejayoro. Porapʉ puhri tiataria waha oterayeripʉre wejẽcãyoro. Eropiro iri dʉca mariyoro. ");
INSERT INTO des_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gajiyeri õari yebapʉ yurimerejayoro. Õaro puhri dʉcacʉyoro, gajisari treinta yeri, gajisari sesenta yeri, gajisari cien yeri dʉcacʉyoro, arĩ buhepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","—Irire õaro peeque mʉa, arĩnemopʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Eropirã pʉhrʉ erã seyaro árĩrã, doce buherã gajirã Jesu mera árĩrã iri queorañere masidiarã Jesure serẽpiñorã. ");
INSERT INTO des_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Erã eropa serẽpira pʉhrʉ Jesu õpa arĩ werepʉ: —Goãmʉ masa tauro opʉ ĩgʉ árĩrire, iribojegue majarã erã masibirirare mʉare yʉ buherãre masicʉ̃ iimi Goãmʉ. Gajirãpʉre eropiibeami ĩgʉ. Eropigʉ erãre werenigui queori mera buhea. ");
INSERT INTO des_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eropirã erã ĩaquererã, pee masibeama. Eropirã peequererã ta masisome. Erã masirã õaripʉre gohrotoboñuma. Erã eropa gohrotocʉ̃ ĩagʉ erã ñero iirare cóãboñumi Goãmʉ. Eropa árĩquerecʉ̃ ta erãpʉ ne peediabeama, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ĩgʉ eroparĩra pʉhrʉ, õpa arĩnemopʉ erãre: —¿Iñe queoriñere peenibeari mʉa? ¿Mʉa iñe queoriñere peebirã dohpa gaji queorire peerãcuri mʉa? arĩpʉ Jesu erãre. Eropa arĩtuhaja õpa arĩ werepʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Oteri masʉ ĩgʉ oteriyeri õari buheri iro dopa ãhraa. ");
INSERT INTO des_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Eropiro ma tʉro mehmerejarayeri, õari buheri iro dopa ta ãhraa. Eropigʉ masa erã õari buherire erã peecʉ̃ ĩagʉ Satanapʉ iri õari buherire masidorebeami erãre. Mirimagʉ porã iriyerire erã dote aĩdiro dopa ta iimi. ");
INSERT INTO des_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Eropi ʉtã watope mehmerejarayeri õari buheri iro dopa ta ãhraa. Eropirã masa õari buherire pee, mucubiriri mera mata irire pee aĩma. ");
INSERT INTO des_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Eropa pee aĩquererã ta, ʉtã watope árĩrisari, nuguri maririsari iro dopa ta oã masa turabeama. Eropa turabirã yaha õari buherire erã peera waja gajirã erãre ñero iicʉ̃ ĩarã yahapʉre duhucãma. Gajirã erãre ñero iicʉ̃ irire bocatĩubirã yahare duhucãma. ");
INSERT INTO des_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Eropi pora watope yurimerejarayeri õari buheri iro dopa ta ãhraa. ");
INSERT INTO des_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Eropirã masa õari buherire peequererã, i yeba majare wʉaro guñaricʉrã niyerure mahima. Gajino sãre baja gamenemoma. Erã eropiicʉ̃ iripʉ õari buheripʉre cãhmotaa. Iri eropa cãhmotacʉ̃ masa Goãmʉ gamerire iibeama. ");
INSERT INTO des_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Eropi õari yeba mehmerejarayeri õari buheri iro dopa ta ãhraa. Eropirã masa õari buherire peerã irire masima. Eropa masirã árĩrã Goãmʉ ĩgʉ gamero dopa ta iima erã. Yujurãyeri merogã õarire iima treinta yeri dʉcacʉro dopa ta. Gajirã wecañari õarire iima sesenta yeri iri dʉcacʉro dopa ta. Gajirã wʉaro õarire iima cien yeri dʉcacʉro dopa ta, arĩ werepʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Eropa arĩtuha õpa arĩnemopʉ: —Ne, sihãgodirure masa sihãgorã mátasorobu docague buhapibeama. Irirure sehro doca apibeama. Irirure sihãgorã ʉmarogue duhpeoma õaro boyoweadorerã. ");
INSERT INTO des_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Árĩpehrerã masa erã masibirirare pʉhrʉ masirãcoma. Sihãgodiru boyocʉ̃ mari ĩhamasiro dopa ta, iribojegue erã masibirirare masirãcoma masa. ");
INSERT INTO des_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Irire õaro peeque mʉa, arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Eropigʉ erãre arĩnemopʉ daja: —Merogã masidiarã merogã masirãca. Wʉaro masidiarã wʉaro masirãca. Eropirã peerã õaro peenʉrʉque. ");
INSERT INTO des_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Õaro peenʉrʉgʉ õaro masigʉcumi. Peenʉrʉbigʉ “Merogã peea,” ĩgʉ arĩquerecʉ̃ ta, iripʉ dederea waroca ĩgʉre, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu erãre werenigui queori mera buhepʉ daja: —Goãmʉ ĩgʉ opʉ árĩri werediacʉ̃ ojodʉcare otera iro dopa ãhraa. Yujugʉ coyere ojodʉcayeri otemi. ");
INSERT INTO des_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Otetuhaja mʉraro ta carĩ wahgã ĩagʉ wamʉririmi. Irisubu ĩgʉ oterayeri puhri wiriaca. “¿Dohpa puhriri?” arĩ ĩha masibeami irire otedigʉ ĩgʉ basi. ");
INSERT INTO des_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Iri otera iri yeba mera iri gamero dʉcacʉa. Epapũgã deyomʉhta, pʉhrʉ dipa poro puhri wiria wahaa. ");
INSERT INTO des_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dʉca bʉgatuhajacʉ̃ ĩagʉ iri pororire pehami. “Pearisubuno ta ãhraa,” arĩmi. Ĩgʉ otera iri bʉgarare ĩgʉ masibiridiro dopa ta masa Goãmʉ yarã erã dohpa wacʉ̃ sãre masibeama masa, arĩ buhepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Eropa arĩtuha buhenemopʉ: —¿Goãmʉ ĩgʉ opʉ árĩri werediacʉ̃ ñeheno iro dopa ãhriri mʉa pepicʉ̃? Iri werenigui queoriñe mera irire weregʉra. ");
INSERT INTO des_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostazayegã iro dopa ãhraa Goãmʉ ĩgʉ opʉ árĩri. Iriyegã ĩgʉ otecʉ̃ miriyegã gohra ãhraa. ");
INSERT INTO des_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Eropa árĩquerero iriyegã õaro puhri wiria. Eropiro yucʉgʉ wʉadigʉ wahaa. Eropirã irigʉ dʉpʉri paga dʉpʉri bʉgacʉ̃ ĩarã mirimagʉ porã iri dʉpʉrigue suhri suama. Mostazayegã wʉatariadigʉ bʉgaro dopa ta ʉmaro majagʉ mari Opʉre masinʉgarã bajamerãgã erã árĩquerecʉ̃ ta, pʉhrʉguere erã bajarã warãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Eropigʉ iri werenigui queori iro dopa baja queorire erã masiropẽ õari buherire buhepʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Queoriñe mariro werebiripʉ erãre. Pʉhrʉ erã seyaro árĩrãre õaro were amupehocãpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Eropi irinʉ ñamica Jesu ĩgʉ buherãre õpa arĩpʉ: —Ina sipʉ masegue, arĩpʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ĩgʉ eroparĩcʉ̃ peerã, yebague niguirãre goeriseretuhajarã dohodirugue ñajaa, Jesure aĩ taribuja wañorã. Eropirã gajirã gaji gasi mera erã pʉhrʉ taribujañorã. ");
INSERT INTO des_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Erã taribujacʉ̃ iriyague miruñe bʉrigã weãyoro. Eropiro miruñe ariro pãgúri dohodirure miucãriyoro. Deco turaro ñajayoro. Merogã dʉhyayoro erã miriboro. ");
INSERT INTO des_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Eropa warisubu Jesu dohodiru auturogue suhri pore wecague carĩgʉ iipʉ. Eropirã erã ĩgʉre wahgũñorã. —Buhegʉ, ¿mʉhʉ ĩabeari? Mirirari iiaa mari, arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Erã eroparĩcʉ̃ peegʉ Jesu wahgã miruñere, pãgúri sãre, —Yʉsʉque, arĩpʉ. Ĩgʉ eroparĩcʉ̃ ta miruñe pãgúri sã yʉsʉdija pehrea wayoro. Õaro dujayoro. ");
INSERT INTO des_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eropigʉ Jesu arĩpʉ ĩgʉ buherãre: —¿Duhpirã güimaacãri mʉa? ¿Mʉa yʉre umupeobeari? arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eropa wacʉ̃ ĩarã erã ĩhamaria wañorã. —¿Ñehmʉno masʉ ãhriri ihĩ miruñe, pãgúri sã yʉhrisũgʉ? arĩñorã erã basi. ");
INSERT INTO des_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Eropi erã sipʉ masegue Gerasa majarã ya yebague taribujajañorã. Eropigʉ Jesupʉ dohodirugue sañadigʉ majanʉgajapʉ. Ĩgʉ majanʉgajara pʉhrʉ, watẽa ñajasũdigʉ masa goberi ʉtã goberi watopegue árĩdigʉ wiriri ĩgʉ pohrogue aripʉ. ");
INSERT INTO des_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ĩgʉ watẽa mera goroweregʉ masa goberi watope árĩgʉ árĩmʉripʉ. Gajirãpʉ ĩgʉre ñeha comeda wʉarida mera dirimasibirimʉriñorã. ");
INSERT INTO des_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ĩgʉ bʉrigã gorowerecʉ̃ ĩha bajasuburi masa ĩgʉre guburi diriri berori mera comedari mera dirimʉririñorã. Eropigʉ ĩgʉpʉ comedarire nuha tʉãtasiricãmʉripʉ. Eropirã ĩgʉ turagʉ árĩro mera masapʉ ĩgʉre ñeha dirirã bocatĩubiriñorã. ");
INSERT INTO des_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Eropigʉ ñami árĩcʉ̃, ʉmʉ sãre masa goberi watopegue, ʉtã yucʉgue sãre, eropa gaguinigui curicãmʉripʉ ĩgʉ. Eropigʉ ʉtã mera ĩgʉ basi dotemʉripʉ. ");
INSERT INTO des_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eropigʉ yoarogue Jesure ĩhabeo ĩgʉ pohrogue omagãripʉ. Eraa merejapʉ Jesu core umupeobu. ");
INSERT INTO des_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","—Watẽa, duhuque ĩgʉre, arĩpʉ Jesu. Ĩgʉ õpa arĩcʉ̃ peegʉ, watẽa ñajasũdigʉ õpa arĩ gaguiniguipʉ: —¿Jesu Goãmʉ turagʉ magʉ, ñehenore iibu iiri mʉhʉ yʉre? Goãmʉ ĩgʉ ĩaro serẽa yʉhʉ mʉre. Yʉre ñero iibiricãque, arĩ gaguiniguipʉ watẽa ñajasũdigʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Dohpa waĩcʉri mʉhʉ? arĩpʉ Jesu ĩgʉre. —Gʉa bajarã ãhraa. Eropirã “Bajarã watẽa” waĩcʉa, arĩpʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eropigʉ Jesure turaro serẽpʉ: —I yeba árĩrãre gʉa watẽare gajipʉgue wadorebiricãque, arĩñorã watẽa masʉ mera árĩnirã. ");
INSERT INTO des_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Irisubure bajarã yesea árĩñorã erã pohrore. Ʉtãgʉ gubuye ahma barã iiñorã. ");
INSERT INTO des_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ero erã baniguicʉ̃ ĩarã õpa arĩ serẽñorã watẽa: —Soã yesea pohrogue wadoreque gʉare. Erã mera árĩdoreque gʉare, arĩ serẽñorã watẽa masʉre ñajanirã. ");
INSERT INTO des_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Erã eroparĩcʉ̃ peegʉ yesea pohrogue wadorepʉ Jesu erãre. Ĩgʉ eropa dorecʉ̃ watẽa masʉre duhu yesea dos mil gohra árĩrãpʉre ñajañorã. Erã pohrogue erã ejara pʉhrʉ yeseapʉ gorowere árĩpehrerã dipatʉrʉgue oma buha, ditarugue yuriñajaa sĩripehrea wañorã. ");
INSERT INTO des_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yesea erã eropa wacʉ̃ ĩarã, erãre ĩhadibunirãpʉ güi omagã wañorã. Macague eja, iri maca majarãre campo majarã sãre erã ĩarare weresiripehocãñorã. Erã eropa werecʉ̃ peerã masapʉ bajarã Jesu ĩgʉ iirare ĩarã ariñorã. ");
INSERT INTO des_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Eropirã Jesu pohrogue erarã, watẽa ñajasũdigʉre, suhri saña, pee masigʉ ĩgʉ ero õaro doacʉ̃ ĩarã ĩha ʉca wañorã erã. ");
INSERT INTO des_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eropirã watẽa ñajasũdigʉre, yesea sãre erã eropa warare ĩanirã gajirãre werepehocãñorã. ");
INSERT INTO des_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Erã eropa werepehocʉ̃ peerã ero majarã Jesure turaro mera wadoreñorã. ");
INSERT INTO des_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Eropigʉ Jesu ĩgʉ dohodirugue ĩgʉ ñajacʉ̃ ĩagʉ “Mʉ mera wadiaca,” arĩ bʉrigã serẽripʉ watẽa ñajasũdigʉpʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ĩgʉ eropa arĩquerecʉ̃ Jesu ĩgʉre werepʉ: —Yʉ mera aribita. Mʉ ya wihigue waha, mʉ pohro árĩrãre yʉhʉ mʉ opʉ mʉre õaro iirare weregʉ waque. Mʉre yʉ mojomoro ĩarare wereque erãre, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ĩgʉ eroparĩcʉ̃ pee watẽa ñajasũdigʉpʉ Decapoli waĩcʉri macague Jesu ĩgʉre õaro iirare werenʉgapʉ. Ĩgʉ eropa arĩ werecʉ̃ peerã, masa árĩpehrerã pee ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Eropi dipaturi ta Jesu gajipʉ masegue ĩgʉ taribujajacʉ̃ masa bajarã ĩgʉ pohrogue wʉariya tʉrogue gamenereñorã. ");
INSERT INTO des_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eropigʉ judio masa erã buheri wihire ĩhadibugʉ Jairo waĩcʉgʉ erapʉ. Jesure ĩha, ĩgʉ guburi pohro mereja õpa arĩ serẽpʉ: ");
INSERT INTO des_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Yʉ mago sĩrigo iiamo. Eropigʉ igore mʉ mojoto mera duhpeogʉ, igore dore taugʉ arique. Mʉhʉ eropiicʉ̃ igo masagocumo, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ĩgʉ eroparĩcʉ̃ pee Jesu ĩgʉ mera wapʉ. Ĩgʉ wacʉ̃ masa bajarã nʉrʉsiagãñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Eropigo nomeo doce bojori gohra eropa ʉmʉri nʉcʉ behreniguigo ero árĩpo. Ero core bajarã duhturua igore ñero taricʉ̃ iiñorã igore ocoyerã. ");
INSERT INTO des_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Eropigo duhturuare igo niyeru árĩpehrerire wajayepituhapo igo ocoyedorego. Erã eropa ocoyequerecʉ̃ igo mʉraro ta árĩniguicãpo. Eropigo igo ero core igo árĩdiro tauro ñero wapo. ");
INSERT INTO des_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Igo eropa ñero taririsubu Jesu ĩgʉ masare õarã iirire peerã gajirã wereñorã igore. Eropigo igo Jesu pʉhrʉ ta masa bajarã watope aripo. Ahri Jesu suhrirore mohmepiñapo. ");
INSERT INTO des_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Yʉhʉ ĩgʉ suhriro dihtare mohmepiñago õago dujagoca,” arĩ pepipo igo. ");
INSERT INTO des_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eropi igo mohmepicʉ̃ mata igo di wirira purumujudija wayoro. Igo dʉpʉre õari dʉpʉ wacʉ̃ pepipo. ");
INSERT INTO des_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Eropigʉ Jesu ĩgʉ turari mera dorere ĩgʉ taurare masigʉ, masa watope maji ĩapʉ. —¿Noa yaha suhrirore mohmepiari? arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ĩgʉ eroparĩcʉ̃ peerã ĩgʉ buherãpʉ õpa arĩñorã. —Cʉ̃hña ãhraa. Eropirã masa bajarã mʉre pẽhregãma. “¿Noa yʉre mohmepiñari?” arĩgʉ, ¿dohpa arĩgʉ iiri mʉhʉ? arĩ serẽpiñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Eropigʉ Jesu ĩgʉre mohmepidigore amapʉ. ");
INSERT INTO des_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ĩgʉ amaro watope igopʉ igo dʉpʉ õaro wacʉ̃ pepigo güi, naragã merejapo ĩgʉ pohro. ");
INSERT INTO des_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Eropigo igo diaye ta werepehopo ĩgʉre. Igo eropa arĩ werera pʉhrʉ Jesu werepʉ igore: —Mahgo, mʉhʉ yʉre umupeori mera õago dujaa dohpaguere. Mucubiriri mera waque. Dore mariro árĩque, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Erã õpa arĩ wereniguiro watope ta Jairo ya wihi majarã erañorã, —Mʉ mago sĩria wahámo. Eropigʉ buhegʉre sihubita pare, arĩñorã. ");
INSERT INTO des_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Erã eropa arĩquerecʉ̃ ta Jesu Jairore õpa arĩ werepʉ: —Bʉjawere pepibita. Yʉre guñaque. Umupeoque iri dihtare, arĩpʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eropa arĩtuha, Santiago, ĩgʉ pagʉ magʉ Ñu, Pedro, erã dihtare “Yʉ mera arique,” arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Eropigʉ Jairo ya wihigue ejapʉ. Iri wihiguere masa bajarã bʉrigã ñehamere orerã iiñorã. Erã eropa orecʉ̃ ĩha erãre arĩpʉ Jesu: ");
INSERT INTO des_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","—¿Ñero arĩ ñehamere orebiricãque mʉa. Igo majigo sĩribeamo. Carĩgo iimo, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ĩgʉ eroparĩcʉ̃ peerã erã “Eroparĩcãgʉ iimi ihĩ,” arĩrã ĩgʉre ĩayeñorã. Ĩgʉpʉ erãre disiporogue wiupehocãpʉ. Majigo pagʉ sʉmarã mera, Jesu ĩgʉ mera majarã igo pohrogue sihuñajajapʉ. ");
INSERT INTO des_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eropigʉ Jesu igo mojotore ñeha arĩpʉ igore: —Talita cumi, arĩpʉ ĩgʉ. Talita cumi mari ya mera “Majigo wahgãque,” arĩdiaro iiaa. ");
INSERT INTO des_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ĩgʉ eroparĩcʉ̃ ta igo majigo sĩridigo mʉro wahgãnʉgaja curipo. Doce bojori opago árĩpo igo. Igore ĩgʉ eropa iicʉ̃ ĩarã ʉcataria wañorã. ");
INSERT INTO des_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Eropigʉ Jesu irire ĩgʉ iirare weresiridorebiripʉ. Eropiituha igore bari ejodorepʉ. ");
INSERT INTO des_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Eropigʉ ero árĩdigʉ waha wa, ĩgʉ buherã mera ĩgʉ ya yebague ejapʉ. ");
INSERT INTO des_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Eropigʉ Jesu Sabado árĩcʉ̃ judio masa erã buheri wihigue buhenʉgapʉ. Ĩgʉ eropa buhecʉ̃ masa bajarã ĩgʉre ĩha masirã ĩgʉre pee ʉca wañorã. Õpa arĩñorã: —¿Dohpa ii masiyuri ihĩ i buherire? ¿Dohpa ii ĩgʉ deyoro moarire ii masiri? ");
INSERT INTO des_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ihĩ taboa mohmeri masʉ María magʉ ãhrimi. Santiago, José, Juda, Simo, erã tĩgʉ ãhrimi. Eropirã ĩgʉ pagʉ porã nome i maca ãhrima. Eropigʉ ĩgʉ mari iro dopa árĩgʉ ãhrimi, arĩñorã erã Jesure peenijarã. Eropirã Jesure umupeobiriñorã. ");
INSERT INTO des_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Erã umupeobiricʉ̃ ĩagʉ õpa arĩpʉ Jesu: —Árĩpehrerogue Goãmʉ yare weremʉhtadigʉre gajirã umupeoma. Erã eropa umupeoquerecʉ̃ ta ĩgʉ ya maca majarã, ĩgʉ acawererã, ĩgʉ ya wihi árĩrã dihta umupeobeama ĩgʉre. Eropirã yʉre umupeobeaa mʉa ohõ yʉhʉ masadigʉ árĩcʉ̃ ĩarã, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eropigʉ iri maca árĩgʉ Jesu Goãmʉ turari mera baja deyoro moarire iimasibiripʉ. Dorecʉrã bajamerãgã dihtare ĩgʉ mohmepi taupʉ erã dorere. ");
INSERT INTO des_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Eropigʉ ero majarã Jesure erã umupeobiricʉ̃ ĩagʉ, “¿Dohpa árĩrono mera yʉre gamebeari erã?” arĩgʉ ʉca wapʉ ĩgʉ. Eropigʉ Jesu ero pohro árĩri macarigue buhegʉ waha wapʉ. ");
INSERT INTO des_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Eropi Jesu doce ĩgʉ buherãre sihubeo perãyeri dihta obeopʉ erãre macariguere buhedoregʉ. Eropigʉ ĩgʉ dorerire ópʉ erãre watẽare masa ñajanirãre erã cóãburire. ");
INSERT INTO des_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Erãre obeogʉ gajinore aĩadorebiripʉ. Doberire, barire, niyerure aĩgãdorebiripʉ erãre. Erã tuari yucʉ dihtare aĩgãdorepʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Eropigʉ gaji zapaturire aĩdorebiripʉ erãre. Yujuñe ta suhrirore sañadorepʉ. Peñe sañadorebiripʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eropigʉ õpa arĩ werepʉ erãre: —Árĩpehreri macarigue erã mʉare carĩro ocʉ̃, iri wihi ta carĩque. Ne warãgue wiriaque iri wihire. ");
INSERT INTO des_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eropirã gaji macari majarã mʉare erã gamebiricʉ̃, erã mʉa buherire peediabiricʉ̃ ĩha iri macare tari wahgã waque. Eropa warã, mʉa guburi maja nicure moje siripique mʉa erã ya dipuwajare masicʉ̃ iimorã erãre, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eropirã erã doce buherã waha masare buherã, erã ñero iirare bʉjaweredoreñorã. Õaripʉre iidoreñorã erãre. ");
INSERT INTO des_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eropirã bajarã watẽare masare ñajanirãre cóãñorã. Dorecʉrãre ʉyʉ mera sũrã õarã wacʉ̃ iiñorã. ");
INSERT INTO des_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Eropirã Jesu ĩgʉ õaro iirare masa bajarã masiñorã. Eropigʉ opʉ Herode sã irire peebeopʉ. Eropa peebeogʉ õpa arĩ guñapʉ ĩgʉ Jesure: —Ñu waĩyemʉridigʉ sĩridigʉ mʉrʉ dipaturi masa dehyoagʉ iicumi daja ihĩ Jesu. Eropa masadigʉ árĩgʉ ĩgʉ turarire opami ĩgʉ deyoro moarire iigʉ, arĩ pepiripʉ Herode. Jesure “Ñu mʉrʉ ta ãhrimi,” arĩ pepiripʉ ĩgʉ Ñure wejẽdorera pʉhrʉ. ");
INSERT INTO des_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gajirã õpa arĩ pepiriñorã: —Elia ãhrimi, arĩ pepiriñorã. Gajirãpʉ: —Goãmʉ yare weremʉhtadigʉ iribojegue majarã dopa ãhrimi ĩgʉ, arĩ pepiñorã Jesure. ");
INSERT INTO des_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erã eropa arĩ pepiquerecʉ̃, Herodepʉ Jesu ĩgʉ iirare peegʉ õpa arĩ pepipʉ: —Jesu Ñu mʉrʉ ta árĩcumi. Ñu dipurure yʉ tabedigʉ masa dehyoagʉ iicumi daja, arĩ pepipʉ. ");
INSERT INTO des_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ero core Herode ĩgʉ pagʉ magʉ marapo Herodia waĩcʉgore ehma igo mera marapocʉpʉ. Ĩgʉ eropa iicʉ̃ Ñu Herodepʉre õpa arĩ wereniguipʉ: —Mʉ pagʉ magʉ marapore marapocʉgʉ Goãmʉ dorerire tarinʉgagʉ iiaa mʉhʉ, arĩpʉ Ñu Herodere. Ĩgʉ eropa arĩra dipuwaja Herode Ñure ñeadore peresugue acumʉripʉ. Ĩgʉre eropa iicʉ̃ gamepo ĩgʉ marapo Herodia. ");
INSERT INTO des_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Eropigo Herodiapʉ Ñure ĩhaturinijago ĩgʉre wejẽ­dore­diaripo. Eropiidiaquerego ta wejẽdoremasibiripo Herode opʉpʉ gamebiricʉ̃. ");
INSERT INTO des_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodepʉ “Ñu õarire iigʉ õagʉ ãhrimi,” arĩ pepi Ñure güipʉ. Eropigʉ Herode Ñu wereniguirire ĩgʉ peegʉ guñaturabiripʉ. Eropa guñaturabiriqueregʉ ta mucubiriri mera ĩgʉre peegʉ wejẽdorebiripʉ ĩgʉ Ñure. ");
INSERT INTO des_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Irisubu ta Herodia igo ĩgʉre wejẽdorera ejayoro. Irisubure Herode ĩgʉ masa dehyoaranʉ árĩcʉ̃ ĩgʉ gobierno majarãre, ĩgʉ surara oparãre, Galilea majarã oparã sãre sihu bosenʉ iipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Eropigo ĩgʉ marapo mago bosenʉ ĩago erago erã ĩhuro baya ĩhmupo. Igo baya ĩhmucʉ̃ ĩarã Herode ĩgʉ sihunirã mucubiriñorã. Erã eropa mucubiricʉ̃ ĩagʉ õpa arĩpʉ Herode igore: —Mʉ gamerire serẽque yʉre. Eropigʉ mʉ serẽrire mʉre ogʉra. ");
INSERT INTO des_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Goãmʉ mera diaye arãa mʉre. Mʉ serẽropẽ yahare deco mera ogʉra mʉre, arĩpʉ ĩgʉ igore. ");
INSERT INTO des_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ĩgʉ eropa arĩcʉ̃ peego igo pago pohrogue waha serẽpipo: —¿Ñehenore serẽgocuri yʉhʉ? arĩ serẽpipo igo pagore. —Ñu waĩyegʉ dipurure serẽque, arĩpo pagopʉ. ");
INSERT INTO des_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Igo eroparĩcʉ̃ peego ʉmʉdiaro mera opʉ Herode pohrogue eja arĩpo: —Dohparagã Ñu waĩyegʉ dipurure tabetadoreque. Eropigʉ soropa mera ĩgʉ dipurure oque yʉre, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Igo eroparĩcʉ̃ opʉ Herode bʉrigã bʉjawerepʉ. Ĩgʉ masa erã peero, “Mʉ serẽrire mʉre ogʉra,” arĩtuhapʉ ĩgʉ. Eropigʉ ĩgʉ ĩgʉ eropa arĩrare gʉhyasĩrigʉ “Mʉre osome,” arĩmasibiripʉ igore. Ĩgʉ sihunirã ĩhuro “Iibeaa,” arĩmasibiripʉ. ");
INSERT INTO des_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Eropigʉ mata surarare peresu árĩrãre coregʉre Ñu dipurure tabeta aĩgãridorepʉ. ");
INSERT INTO des_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ĩgʉ eropa dorecʉ̃ peegʉ surarapʉ waha, ĩgʉ dipurure tabeta, soropa mera aĩgãripʉ. Aĩgã nómeore ĩgʉ marapo magore ópʉ. Eropigo igo iripare ñeha igo pagore o taupo daja. ");
INSERT INTO des_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Eropirã Ñu buherã irire peenijarã erogue waha, ĩgʉ dʉpʉre aĩ masa gobegue aĩgã apiñorã. ");
INSERT INTO des_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Eropi Jesu ĩgʉ buhedore obeonirã ĩgʉ pohrogue dujajañorã daja. Erã iirare erã buherare wereñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Irisubure masa bajarã eropa majiniguirã erãre ne baro iibiriñorã. Eropigʉ õpa arĩpʉ Jesu ĩgʉ buherãre: —Masa marirogue mari seyaro soonirã warã, arĩpʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eropirã erã seyaro gasiru mera masa marirogue wariñorã. ");
INSERT INTO des_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Erã eropa wacʉ̃ ĩarã masa bajarã erãre masiñorã. Eropa masirã baja macari majarã mague waha, Jesu ĩgʉ ejaborogue omajatuhañorã. ");
INSERT INTO des_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Erã eropa ejacʉ̃ Jesu tuhajapa, gasirugue sañadigʉ majanʉgajagʉ ĩgʉ bajarã masare ĩapʉ. Oveja ĩhadibugʉ moorã iro dopa árĩñorã erã Jesu ĩgʉ ĩacʉ̃. Eropigʉ erãre mojomoro ĩagʉ baja buhepʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ñamicague doce ĩgʉ buherã Jesu pohrogue eja õpa arĩñorã ĩgʉre: —Ohõ maca marirogue ãhraa. Ñamicague ãhraa. ");
INSERT INTO des_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Õgã árĩri macarigue masare wadoreque. Erã baburire asũrã waporo, arĩriñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Mʉa basi ta barire oque erãre, arĩpʉ Jesu erãre. Ĩgʉ eroparĩcʉ̃ peerã õpa arĩ yʉhriñorã: —¿Wʉaro niyerupũri mera gʉa dohpa ii asũbocuri panre masa bajarã erã baburire? arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Di nʉcʉ pan ãhriri õguere? Ĩarã waque, arĩpʉ ĩgʉ erãre. Ĩgʉ eroparĩcʉ̃ erãpʉ barire boca õpa arĩñorã: —Cinco dipuru ãhraa pan. Wai perã ãhrima, arĩñorã. ");
INSERT INTO des_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Erã eroparĩcʉ̃ peegʉ Jesu masare dipa cururi ero taa árĩro weca doadorepʉ masare. ");
INSERT INTO des_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ĩgʉ eroparĩcʉ̃ peerã erã dipa cururi doañorã. Yuju curure cien gohra árĩñorã. Gaji curure cincuenta gohra árĩñorã. ");
INSERT INTO des_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Erã doapehrecʉ̃ ĩha Jesu cinco dipuru pan dipurure aĩ, erã perã waire aĩ, ʉmarogue ĩhamemuju Goãmʉre “Õhaa,” arĩpʉ. Eropa arĩ serẽtuha iri pan dipurure nuha ĩgʉ buherãre ópʉ masare gueredoregʉ. Eropigʉ wai perãre gueredorepʉ árĩpehrerãre. ");
INSERT INTO des_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Eropirã árĩpehrerã baha yapia wañorã. ");
INSERT INTO des_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Erã ba dʉarare doce puiri gohra sea gameneo ʉjʉtu doboñorã erã wai sãre eropa ta. ");
INSERT INTO des_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eropirã panre banirã ʉma dihtare queocʉ̃ cinco mil gohra árĩñorã. ");
INSERT INTO des_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Irisubu ta Jesu ĩgʉ buherãre dohodirugue ñajajadore, gajipʉ masegue Betsaida yebague ĩgʉ core taribuja yudorepʉ. Eropigʉ erã taribuja wara pʉhrʉ Jesupʉ masare goeriserepʉ. ");
INSERT INTO des_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Goeriseretuhaja ʉtãgʉgue mʉria ĩgʉ seyaro Goãmʉre serẽgʉ waha wapʉ. ");
INSERT INTO des_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pʉhrʉ ñamicague árĩcʉ̃ dohodirupʉ ĩgʉ buherã wadiru ditaru deco árĩyoro. Erã ero payacʉ̃ Jesu yujugʉ ta erã taribujaridirogue árĩpʉ. ");
INSERT INTO des_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Miruñe dʉrʉro weã dujuyoro erãre. Eropigʉ erã ñero tari wejacʉ̃ ĩhabeopʉ Jesu erãre. Eropigʉ boyo mʉririboro core cãreña wahgãrisubu erã pohro wagʉ deco weca cʉhrapi wahgã wapʉ. Erãre ĩgʉ tarigãripʉ. ");
INSERT INTO des_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ĩgʉ tarigãquerecʉ̃ ta, ĩgʉ deco weca aricʉ̃ ĩarã ĩha ʉca wañorã. “Sĩridigʉ mʉrʉ watĩ ãhrimi,” arĩ pepi gaguiniguiñorã. ");
INSERT INTO des_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Erã árĩpehrerã ĩgʉre ĩarã ĩha bʉrigã ʉca wañorã. Erã eropa ĩha ʉcacʉ̃ ĩagʉ Jesu werepʉ erãre: —Ne yʉre ĩha ʉcabiricãque. Yʉhʉ ta ãhraa. Güibita, arĩpʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Eropa arĩtuha ĩgʉ erã mera dohodirugue ñaja wapʉ. Ĩgʉ ñajara pʉhrʉgã ta miruñe taria wayoro. Eropa wacʉ̃ erãpʉ ʉcataria wañorã. ");
INSERT INTO des_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ĩgʉ pan dipurure baja iirare guñabiriñorã erã. Ĩgʉre õaro masibiriniñorã. ");
INSERT INTO des_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Eropi erã taribujaja, Genesare yebague eja, tʉrogãgue payañorã. ");
INSERT INTO des_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Eropirã erã dohodirugue árĩnirã erã majacʉ̃ ta masapʉ Jesure ĩha masiñorã. ");
INSERT INTO des_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Eropa ĩha masirã árĩpehrerogue erã ya yebague omaja, dorecʉrãre erã pũyucʉ mera aĩgãriñorã. “Jesu erogue ãhrimi,” masa erã arĩcʉ̃ pee eroguere aĩ ejañorã. ");
INSERT INTO des_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Eropirã árĩpehrero ĩgʉ waroguere paga macariguere, mʉta macarigãguere, campogue, erã wari mariguere erã masa dorecʉrãre aĩ apiñorã Jesure coremorã. Eropirã Jesu erã pohro ĩgʉ ejacʉ̃ mohmepiñadiarã turaro serẽñorã ĩgʉre. —Mʉ suhriro ojogoro dihtare mohmepiñadoreque gʉare, arĩ serẽñorã erã. Eropirã ĩgʉ suhrirore mohmepinirã nʉcʉ õarã wañorã. ");
INSERT INTO des_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Eropi Jerusaléngue arinirã judio masare buherã, fariseo masa mera Jesu pohrogue gamenereñorã. ");
INSERT INTO des_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Fariseo masa árĩpehrerã, gajirã gʉa acawererã judio masa mera erã ñecʉ sʉmarã dorediro dopa ta erã mojotorire coero mariro babirimʉriñorã. Eropirã doberi duarã pohrogue wanirã dujajarã erã dorerire iimorã, erã mojotorire coero mariro babirimʉriñorã erã. Eropirã baja gaji erã dorerire erã ñecʉ sʉmarã iidorerire iimʉriñorã erã. Tasa parire yujuropa coe, mátasororire coe, comesororire coe, erã iiguaro dopa ta iimʉriñorã erã judio masa “Goãmʉ eropa gahmemi,” arĩrã. Eropirã Jesu pohrogue gamenererã Jesu buherã erã ñecʉ sʉmarã dorediro dopa ta erã mojo coebiricʉ̃ ĩañorã fariseo masa. ");
INSERT INTO des_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eropa ĩatuhajarã Jesure serẽpiñorã: —Mʉ buherã mari ñecʉ sʉmarã mʉra erã dorediro dopa ta erã baboro core erã mojo coebeama. ¿Duhpirã mari dorerire iibeari erã? arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Erã eroparĩcʉ̃ peegʉ werepʉ Jesu erãre: —Masa erã ĩabiropʉre ñero iicorerã ãhraa mʉa. Goãmʉ yare weremʉhtadigʉ Isaia mʉare iribojegue diaye ta weremʉriñumi. Õpa arĩ gojañumi Goãmʉ ya wereniguirire: Oã masa yʉre õaro wereniguiquererã ne yʉre umupeobeama. Erã ya sĩporãripʉ gajipʉgue ãhraa. Yʉre ne mahibeama. ");
INSERT INTO des_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Goãmʉ ya doreri wereniguibodirore erã ya wereniguiri dihtare buhema erã. Eropirã yʉre umupeo erã sĩbuipeori duhpiburi árĩbeaa yʉre, arĩmi Goãmʉ, arĩ gojañumi Isaia iribojegue. ");
INSERT INTO des_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Iri diaye ta ãhraa. Goãmʉ dorerire iibeaa mʉa. Mʉa ñecʉ sʉmarã mʉra árĩricʉri dihtare iiaa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Eropigʉ erãre wereniguinemopʉ daja: —Mʉa ñecʉ sʉmarã mʉra árĩricʉrire iiduhubirã ta Goãmʉ yapʉre cohãa mʉa. ");
INSERT INTO des_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Iribojegue õpa arĩñumi Moise Goãmʉ dorerire: “Mʉa pagʉ sʉmarãre umupeoque. Yujugʉ ĩgʉ pagʉ sʉmarãre ñero werenigui coredigʉ ĩgʉ wejẽbu árĩgʉcumi,” arĩñumi Moise. ");
INSERT INTO des_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Moise eropa arĩquerecʉ̃ ta, mʉapʉ masare õpa arĩ weredorea erã pagʉ sʉmarãre. “‘Mʉare itamumasibeaa. Mʉare yʉ oborare Goãmʉ ya árĩburire opehocãbʉ,’ arĩque mʉa pagʉ sʉmarãre,” arĩ weredorea mʉa. ");
INSERT INTO des_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Eropa arĩ weredorerã erã pagʉ sʉmarãre erã umupeobiricʉ̃ iiaa mʉa erãre. ");
INSERT INTO des_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Eropirã Goãmʉ ĩgʉ dorerire tarinʉgarã iiaa mʉa mʉa ñecʉ sʉmarã ya doreri dihtare iirã. Gajirãre mʉa buheri dihtare peedorea mʉa. Baja eropa árĩrire iiaa mʉa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Eropa arĩtuha masare sihubeo õpa arĩpʉ daja: —Mʉa árĩpehrerã peeque yʉre. Yʉ arĩrire õaro masique mʉa. ");
INSERT INTO des_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mʉa disiro ñajaripʉ mʉa baripʉ ñerã wacʉ̃ iibeaa. Mʉa disiro wiriripʉ, mʉa wereniguiripʉ mʉare ñerã árĩcʉ̃ iiaa. ");
INSERT INTO des_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yʉre õaro peeque, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eropa arĩtuha Jesu masa pohro árĩdigʉ waha wihigue ñajaa wapʉ. Ĩgʉ eropa ñajacʉ̃ ĩarã ĩgʉ buherãpʉ ĩgʉ wererare serẽpiñorã. Erã eropa serẽpicʉ̃ peegʉ õpa arĩpʉ Jesu: ");
INSERT INTO des_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—¿Ne peenibeari mʉa sã? Mʉa bari disiro ñajaripʉ mʉare ñerã masa wacʉ̃ iibeaa. ¿Irire masibeari? ");
INSERT INTO des_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Iri mʉa pepirigue ñajabeaa. Mʉa parugue ñajaja taria wahaa, arĩpʉ Jesu. Eropa arĩgʉ “Árĩpehreri bari õari bari ãhraa,” arĩgʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Õpa arĩnemopʉ: —Mʉa wereniguiripʉ, mʉa disiro wiriripʉ mʉa pepiri ãhraa. Mʉa pepiripʉ mʉare ñerã masa árĩcʉ̃ iiaa. ");
INSERT INTO des_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mʉa pepirigue õpa ñeri iinʉgaa: Ñero pepiri, nomere gameri, yajari, masare wejẽri, ");
INSERT INTO des_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gajigʉ marapo mera ñero iiri, gajirã yare turaro ʉaribejari, ñetariari iiri, gʉyari, ñeri ʉaribejari, gajirã gajinore opacʉ̃ ĩhaturiri, ñero quere wereri, gajirãre tarinʉgadiari, pee masibiriri iinʉgaa. ");
INSERT INTO des_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Árĩpehreri i ñeri mʉa pepirigue árĩnʉgari mʉare ñerire iicʉ̃ ñerã árĩcʉ̃ iiaa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Eropigʉ Tiro waĩcʉri maca pohrogue, Sidón waĩcʉri maca pohrogue wapʉ. Erogue ejagʉ ero árĩri wihigue ñajaa wapʉ. Eropigʉ gajirãre ĩgʉ árĩri wihire ne weredorebiripʉ. Ĩgʉ eropa duhridiaqueregʉ ta duhrimasibiripʉ. ");
INSERT INTO des_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ĩgʉ ejacʉ̃ pee mata yujugo nomeo ĩgʉ pohro ejapo. Igo mago watĩ ñajasũdigo árĩpo. Gajirã Jesu iira querere peedigo árĩpo. Igo Jesu pohro eja ĩgʉ guburi pohro merejapo. ");
INSERT INTO des_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Igo judio maso árĩbigo Grecia majago árĩpo. Siro Fenicia árĩyoro igo masa dehyoara maca. Jesu pohro mereja ĩgʉre turaro serẽpo: —Watĩre wiubasaque yʉ magore, arĩ serẽpo igo Jesure. ");
INSERT INTO des_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Igo eroparĩcʉ̃ peegʉ õpa arĩpʉ Jesu igore: —Negohrare wihi opʉ porã bamʉhtaporo. Erã porã ya barire diayeare ocʉ̃ ero wabeaa. Israe masa yare gaji yeba majarãre yʉ omʉhtacʉ̃ ero wabeaa, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Eropa ta ãhraa opʉ. Eropa árĩquerecʉ̃ ta barisubu árĩcʉ̃ erã diayea sã yuhridijarire bacohrema. Gaji yeba majago yʉ árĩquerecʉ̃, yʉ sãre itamuque mʉhʉ, arĩpo igo ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Mʉhʉ eropa õaro arĩ yʉhricʉ̃ mʉ magore watĩre wiubasatuhabʉ. Ĩago waque, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ĩgʉ eroparĩcʉ̃ peego waha, igo ya wihigue eja, igo magore camague oyagore watĩ moogoguere eja ĩapo. ");
INSERT INTO des_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Irisubure Jesu sã Tiro waĩcʉri maca pohrogue árĩdigʉ waha, Sidón waĩcʉri macare eja tarigã, Decapoli waĩcʉri macare eja tarigã, Galilea waĩcʉri ditarugue ejañorã pare. ");
INSERT INTO des_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eropirã peejabigʉre, wereniguibigʉre aĩgãriñorã gajirã Jesu pohrore. —Mʉ mojoto mera mohmepiñaque ĩgʉre, arĩ serẽñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Erã eroparĩcʉ̃ peegʉ Jesupʉ peejabigʉre aĩgã, masa marirogue aĩ ejapʉ. Erã seyaro árĩñorã. Eropigʉ Jesu ĩgʉ mujusĩri mera ĩgʉ gamirire pupʉ. Eropigʉ ĩgʉ disico mera ĩgʉ nerore mohmepiñapʉ. ");
INSERT INTO des_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Eropiituhaja ʉmaro ĩhamuju sĩ aĩ õpa arĩpʉ: —Efata, arĩpʉ Jesu. Efata mari ya mera “Pãgũque,” arĩro iiaa. Eropa arĩgʉ ĩgʉre peedoregʉ iipʉ. Eropigʉ wereniguidoregʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ĩgʉ eroparĩcʉ̃ ta ĩgʉ peejabigʉ peepʉ. Ĩgʉ nero niricʉ̃ pepigʉ õaro wereniguinʉgapʉ. ");
INSERT INTO des_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Eropigʉ Jesu irire ĩanirãre gajirãre weredorebiripʉ. Eropa weredorebiriquerecʉ̃, erãpʉ gajirãre bʉrigã werepehocãñorã. ");
INSERT INTO des_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eropirã masa pee ʉca waha õpa arĩñorã: —Árĩpehreri õaro iimi. Peejabirã sãre õaro peecʉ̃ iimi. Wereniguibirã sãre õaro wereniguicʉ̃ iimi Jesu, arĩñorã masa. ");
INSERT INTO des_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Irisubure daja dipaturi masa bajarã erã gamenerera pʉhrʉ, bari moorã erã árĩcʉ̃ ĩagʉ Jesu ĩgʉ buherãre sihubeopʉ: ");
INSERT INTO des_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Oã masa ʉhrenʉ gohra yʉ mera árĩtuhajama. Erãre bari pehrea waca. Eropigʉ erãre mojomoro ĩhaa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Gajirã erã mera majarã yoarogue arinirã ãhrima. Erã babiriquererã erã ya wirigue dujaacʉ̃ gamebirica. Mague warã erã oaboarã turabiribocoma. Eropigʉ erãre barire odiaca, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ĩgʉ eroparĩcʉ̃ ĩgʉ buherã ĩgʉre arĩñorã: —¿Duhpii mari õguere masa mariroguere barire bocabocuri erãre ejomorã? arĩñorã Jesu ĩgʉ buherãpʉ. ");
INSERT INTO des_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Di nʉcʉ dipuru pan dipuru opari mʉa? arĩ serẽpipʉ Jesu erãre: —Siete pan dipuru ãhraa, arĩñorã. ");
INSERT INTO des_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eropigʉ ĩgʉ masare taa árĩro weca doadorepʉ. Tuhajanugu siete pan dipurure aĩ, Goãmʉre “Õhaa,” arĩ serẽpʉ. Eropa arĩ serẽtuhaja pan dipurure nuha ĩgʉ buherãre ópʉ gueredoregʉ. ");
INSERT INTO des_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eropirã waigã sãre bajamerãgã opañorã erã. Eropigʉ waigãre aĩ Goãmʉre “Õhaa,” arĩ serẽ, ĩgʉ buherãre masare gueredorepʉ. ");
INSERT INTO des_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Masa irire barã yapia wañorã. Erã ba dʉharare siete puiri gohra aĩ gameneo ʉjʉtu doboñorã. Erã masa cuatro mil gohra árĩñorã. ");
INSERT INTO des_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Eropiituha Jesu masare goeriserepʉ wagʉ. Erãre goeriseretuhaja Dalmanuta waĩcʉri maca pohrogue waha wapʉ. ");
INSERT INTO des_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ero pʉhrʉ fariseo masa Jesu mera dʉyasorã erañorã. Erã Jesure Goãmʉ turari mera deyoro moariñere iidoreriñorã. Ĩgʉ ii ĩhmumasibiricʉ̃ ĩadiariñorã. Ĩgʉ iimasibiricʉ̃ “Goãmʉ ĩgʉ obeodigʉ árĩbeami,” arĩdiariñorã. ");
INSERT INTO des_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Erã õpa dorecʉ̃ peegʉ Jesu turaro bʉjawere sĩñaja õpa arĩpʉ: —¿Mʉa dohpague majarã duhpirã Goãmʉ ĩgʉ turari mera deyoro moarire ĩadiari? Diaye arãa mʉare. Dohpague majarã mʉare ne deyoro moarire ii ĩhmusome yʉhʉ, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Õpa arĩtuha waha dohodirugue ñaja gajipʉ masegue waha wapʉ ĩgʉ buherã mera. ");
INSERT INTO des_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Eropa warã panre cãdijiñorã. Dohodiruguere yujuru ta panrure opañorã erã. ");
INSERT INTO des_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Eropigʉ Jesu gʉhyaro mera werepʉ ĩgʉ buherãre: —Õaro iique. Fariseo masa, Herode ya curu majarã sã erã pan bʉgacʉ̃ iiburire õaro iique. Gʉhya ãhraa iri, arĩ werepʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ĩgʉ fariseo masa sã erã buherire eroparĩcʉ̃ pee, ĩgʉ buherãpʉ peewisirã irire erã basi wereniguiñorã. —Mari panre mari aĩgãribiricʉ̃ ĩagʉ eropa arĩcumi ĩgʉ, arĩñorã erã basi. ");
INSERT INTO des_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Erã eropa arĩrare masigʉ õpa arĩpʉ Jesu erãre: —¿Duhpirã mʉa pan cãdijirare guñari mʉa? ¿Mʉa masibeari? ¿Peenibeari mʉa dohpa? ¿Peediabeari mʉa? ");
INSERT INTO des_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Cuiricʉrã árĩquererã ĩabeari mʉa? ¿Gamiricʉquererã ta peebeari mʉa? ¿Mʉa yʉ iirare guñabeari? ");
INSERT INTO des_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Yʉ cinco mil ʉmare cinco dipuru panre yʉ nuha orare guñabeari mʉa? ¿Erã yapi weorare di nʉcʉ puiri pan dipure mʉa ʉjʉtura puirire aĩari mʉa? arĩ serẽpipʉ Jesu erãre. —Doce puiri, arĩñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—¿Eropi yʉhʉ siete pan dipurure cuatro mil masare yʉ ora pʉhrʉ di nʉcʉ puiri ʉjʉtura puiri aĩari mʉa? arĩpʉ Jesu erãre daja. —Siete puiri, arĩ yʉhriñorã erã. ");
INSERT INTO des_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Eropa irire ĩaquererã ta masibeari mʉa dohpa? arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Eropi erã Betsaida waĩcʉri macague erã ejacʉ̃ ĩarã, masapʉ cuiri deyobigʉre aĩgãriñorã. —Ĩgʉre mohmepique, arĩ turaro serẽñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eropigʉ Jesu cuiri deyobigʉre mojoto ñeha iri maha tʉrogue ĩgʉre taragãpʉ. Aĩ eja ĩgʉ cuirire purimetupʉ disico mera. Eropigʉ ĩgʉ mojoto mera ĩgʉre mohmepipʉ. —¿Mʉhʉ ĩacʉ̃ dehyori? arĩ serẽpipʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ĩgʉ eroparĩcʉ̃ ĩgʉpʉ ĩagʉ õpa arĩpʉ: —Masare ĩhaa. Erãre ĩaquerecʉ̃ erã curicʉ̃ yucʉ iro dopa dehyoma, arĩpʉ ĩgʉ cuiri deyobigʉpʉ. ");
INSERT INTO des_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ĩgʉ eroparĩcʉ̃ peegʉ Jesupʉ ĩgʉ mojotori mera ĩgʉ cuirire mohmepipʉ daja. Ĩgʉ eropa mohmepira pʉhrʉ cuiri deyobigʉ ĩgʉ turaro ĩacʉ̃ õaro deyoyoro pare. Eropigʉ árĩpehrerire õaro ĩapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Eropigʉ Jesu ĩgʉre ĩgʉ ya wihigue omedijugʉ õpa arĩpʉ: —Macague tamerare wabiricãque. Eropigʉ maca majarãre i yʉ iirare gajirãre weresiribiricãque, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Eropi Jesu ĩgʉ buherã mera Cesarea Filipo waĩcʉri maca pohro árĩri macarigue wanemoñorã. Erogue wagʉ Jesu serẽpiñapʉ ĩgʉ buherãre: —¿Nihino árĩcuri yʉhʉ masa erã yʉre pepicʉ̃? arĩ serẽpiñapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ĩgʉ eropa arĩ serẽpiñacʉ̃ peerã ĩgʉ buherã yʉhriñorã: —“Ñu waĩyegʉ ãhrimi,” arĩma mʉre. Gajirã “Elia ãhrimi,” arĩma. Gajirãpʉ “Goãmʉ yare weremʉhtanirã mera majagʉ ãhrimi,” arĩma, arĩ yʉhriñorã ĩgʉ buherã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Erã eropa arĩra pʉhrʉ Jesu serẽpinemopʉ erãre: —¿Mʉapʉ mʉa pepicʉ̃ nihino árĩcuri yʉhʉ? arĩ serẽpipʉ. Pedropʉ yʉhripʉ ĩgʉre: —Mʉhʉ Cristo Goãmʉ ĩgʉ obeodigʉ ãhraa, arĩ yʉhripʉ Pedro. ");
INSERT INTO des_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu õpa arĩpʉ: —Yʉre “Cristo ãhrimi ĩgʉ,” ne arĩ weresiribiricãque gajirãre, arĩpʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Eropigʉ ĩgʉ erãre buhenʉgapʉ õpa arĩ weregʉ: —Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. Eropigʉ bʉrigã ñero tarigʉca. Yʉre eropa ta waro gahmea. Mʉrã, pahia oparã, marire buherã sã yʉre gamebirã yʉre wejẽrãcoma. Erã yʉre eropa wejẽquerecʉ̃, ʉhrenʉ pʉhrʉ masa mʉriagʉca, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Eropa arĩgʉ erã õaro peeboro dopa õaro weregʉ iipʉ erãre. Ĩgʉ eroparĩcʉ̃ peegʉ Pedropʉ gajipʉ ñarigã Jesure aĩgã ĩgʉre arĩpʉ. “Eropa arĩbiricãque,” turaro mera arĩ werepʉ. ");
INSERT INTO des_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ĩgʉ eropa arĩdorebiricʉ̃ peegʉ Jesupʉ ĩgʉ buherãre majinʉgaja, turipʉ Pedrore. —Satana iro dopa wereniguigʉ iiaa mʉhʉ. Eropa arĩbiricãque. Mʉ pepiri masa ya ãhraa. Goãmʉ ya árĩbeaa, arĩpʉ ĩgʉ Pedrore. ");
INSERT INTO des_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eropa arĩtuha masare ĩgʉ buherã mera sihubeo õpa arĩpʉ: —Yujugʉ yʉ mera majagʉ árĩdiagʉ ĩgʉ gamero iidiarire duhucãgʉcumi. Eropigʉ ĩgʉ yʉ mera majagʉ ĩgʉ árĩri dipuwaja ñero tarigʉcumi. Ñero tariqueregʉ yahare iiniguicãgʉcumi. ");
INSERT INTO des_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yujugʉ masʉ ĩgʉ ya árĩburi dihtare pepigʉ ĩgʉ dederea wagʉcumi. Eropigʉ gajigʉ yaha árĩburi dihtare iigʉ, õari buheri sãre iigʉ, árĩpehrerinʉri yʉ mera ʉmarogue õaro árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yujugʉ masʉ i yeba majare árĩpehrerire opaqueregʉ, peamegue wagʉ õarire wajatasome. ");
INSERT INTO des_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Eropigʉ i yebague opaburi dihtare guñagʉ, ĩgʉ sĩrigʉ waburire guñabigʉ ĩgʉ sĩporã mera peamegue dederegʉcumi. ");
INSERT INTO des_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Dohpaguere ñerã Goãmʉre gamebirã erã ejatuharo iiri árĩro iiaa. Eropirã yujurãyeri yʉre, yʉ buheri sãre masiquererã “Masibeaa,” arĩbocoma gʉhyasĩrirã. Erã eroparĩcʉ̃ ĩagʉ yʉ sã erãre gʉhyasĩrigʉ “Erãre masibeaa,” arĩgʉca. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ õarã anyua mera yʉ Pagʉ gosesiriri mera dujarigʉca. Yʉ dujarigʉ yʉ waĩre arĩdia gʉhyasĩrisãnirãre gʉhyasĩrisãgʉca yʉ sã, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Eropa arĩtuhaja õpa arĩnemopʉ Jesu: —Diaye arĩgʉ tiiaa mʉare. Yujurãyeri mʉa õguere árĩrã, mʉa sĩriboro core Goãmʉ ĩgʉ opʉ árĩroguere yʉ ñajacʉ̃ ĩarãca, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Eropi seis nʉri pʉhrʉ Jesu Pedrore, Santiagore, ĩgʉ pagʉ magʉre Ñure ʉtãgʉgue ʉmadigʉgue erã dihtare sihu mʉriapʉ. Ʉmarogue erã mʉrijara pʉhrʉ erã ĩhabeoro ĩgʉ dʉpʉre gohrotopʉ. ");
INSERT INTO des_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Eropiro ĩgʉ suhri gosesiriri suhri õaro boreriñe wayoro. I yeba majarã nome suhri coerã nome ne eropa borerire iimasibeama. ");
INSERT INTO des_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mata iribojegue majarã Moise mʉrʉ Elia mʉrʉ sã dehyoañorã. Eropirã Jesu, Elia, Moise mera weretamucʉ̃ ĩañorã erã ʉrerã ĩgʉ buherã. ");
INSERT INTO des_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Eropirã erã bʉrigã güiñorã. Eropa güigʉ dohpa arĩmasibirinijagʉ õpa arĩpʉ Pedro: —Opʉ, mari ohõ árĩcʉ̃ õadiaa. Ʉhre wihigã iirã. Mʉ ya wihigã, Moise ya wihigã, Elia ya wihigã iirã, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eropiro erã weca erãre imica curu cãhmotayoro. Iri eropa cãhmotacʉ̃ ta imica curu pohecague Goãmʉ ĩgʉ wereniguiri bʉsʉyoro: —Ihĩ yʉ magʉ yʉ mahigʉ ãhrimi. Peeque ĩgʉre, arĩri bʉsʉro cariyoro. ");
INSERT INTO des_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eroparĩcʉ̃ peerã Pedro sã maji ĩarã Moisere, Eliare ĩabiriñorã pare. Jesu dihtare ĩañorã. ");
INSERT INTO des_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eropi ʉtãgʉgue erã dijaricʉ̃ Jesu erãre werepʉ: —Dohparagã yʉre eropa warare gajirãre ne werebiricãque. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉ sĩri masa mʉriara pʉhrʉ irire gajirãre wereque mʉa, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eropirã erã ĩgʉ dorediro dopa werebiriñorã gajirãre. Eropirã erã, erã basi õpa arĩ serẽpi wereniguiñorã: —“Yʉhʉ sĩridi masa mʉriara pʉhrʉ,” ĩgʉ arĩgʉ ¿duhpigʉ eropa arĩri ĩgʉ? arĩ wereniguiñorã erã. ");
INSERT INTO des_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eropirã Jesure õpa arĩ serẽpiñorã: —Cristo Goãmʉ beyedigʉ ĩgʉ ariboro core “Eliare arimʉhtaro gahmea,” arĩma masare buherã. ¿Dohpa arĩronore eropa arĩri erã? arĩ serẽpiñorã Jesure ĩgʉ buherã. ");
INSERT INTO des_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesu yʉhripʉ: —Diaye ta ãhraa. Eliare arimʉhtadoremi Goãmʉ árĩpehrerire amumʉhtabure. Ĩgʉ eropa iiborore arĩ gojayura ãhraa Goãmʉ yare gojarapũgue. Yʉ sãre arĩ gojayuñuma. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ bajasuburi ñero tarigʉca. Gajirã yʉre gamebirã yʉre ñero iirãcoma. ¿Iri sãre masiri mʉa? Eropigʉ õpa arĩgʉra mʉare: Elia eratuhami. Ĩgʉ eracʉ̃ erã ĩgʉre erã gamero dopa ñero iima. Iribojegue erã arĩ gojayudiro dopa iima ĩgʉre, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eropi dijari ĩgʉ buherã dujanirã pohrogue eja, bajarã masare ĩapʉ. Ĩgʉ buherãpʉ judio masare buherã mera game dʉyasorã iiñorã. ");
INSERT INTO des_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Masa Jesure ĩarã árĩpehrerã ĩhamaria wañorã. Eropirã ĩgʉ pohrogue omagã ĩgʉ pohrogue eja, “¿Ahrari?” arĩñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","“Ahrabʉ,” arĩtuhaja erãre serẽpipʉ: —¿Ñehenore game wereniguirã iiari mʉa eropa dʉyasorã? arĩ serẽpipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ĩgʉ serẽpicʉ̃ peegʉ masa watope niguidigʉ werepʉ ĩgʉre: —Buhegʉ, yʉ magʉre watĩ ñajasũdigʉre mʉre aĩgãrirabʉ. Watĩpʉ ĩgʉre wereniguidorebeami. ");
INSERT INTO des_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yʉ magʉre ĩgʉ ñajacʉ̃ yebague mehmereja wahami. Ĩgʉ disirore sumutua, ĩgʉ gʉcʉrire cũridihu bʉha wamʉrami ĩgʉ. Eropigʉ mʉ buherãre watĩre yʉ magʉre ñajadigʉre cóãdorerabʉ. Erã cóã­masibirama, arĩ werepʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ĩgʉ eroparĩcʉ̃ peegʉ õpa arĩpʉ Jesu masare: —¿Ne yʉre umupeobirigohracãri mʉa? Yoari boje mʉare buherabʉ yʉhʉ. ¿Dipa boje yʉhʉ mʉare yujuro bojebocuri? Ĩgʉre aĩgãrique, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ĩgʉ eroparĩcʉ̃ peerã watĩ ñajasũdigʉre Jesu pohro aĩgãriñorã. Erã Jesu pohro aĩ ejacʉ̃ ta watĩpʉ ĩgʉ majigʉre mehmerejacʉ̃ iipʉ. Ĩgʉ eropiicʉ̃ ĩgʉ yebague mehmereja wapʉ. Tũru, naragã, bʉhacʉ̃ iipʉ. Eropii ĩgʉ disiro sumutua wapʉ. Jesu ĩgʉ pagʉre serẽpipʉ: ");
INSERT INTO des_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—¿Dipa boje eropa ãhrari ĩgʉ? arĩ serẽpipʉ Jesu majigʉ pagʉre. —Majigʉgãgue ta ĩgʉ eropa árĩnʉgami, arĩ yʉhripʉ ĩgʉ pagʉpʉ. ");
INSERT INTO des_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Eropigʉ watĩpʉ ĩgʉre peamegue, diague sãre cóãmʉririmi ĩgʉre wejẽdiagʉ. Eropigʉ mʉhʉ itamumasigʉ mojomoro ĩha itamuque gʉare, arĩpʉ majigʉ pagʉpʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ĩgʉ eroparĩcʉ̃ peegʉ õpa arĩpʉ Jesu ĩgʉre: —Mʉhʉ yʉre umupeocʉ̃ ĩagʉ Goãmʉ árĩpehrerire iipehocãmasimi mʉ ya árĩburire iigʉ, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ĩgʉ eroparĩcʉ̃ majigʉ pagʉ õpa arĩ gaguiniguipʉ: —Mʉre umupeoa yʉhʉ. Yʉ umupeobiricʉ̃ ĩagʉ itamuque yʉre yʉhʉ mʉre umupeoboro dopa, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eropiicʉ̃ masa bajarã erã pohro omagãriñorã. Erã gamenerecʉ̃ ĩagʉ Jesu watĩre õpa arĩ turipʉ: —Mʉhʉ wereniguimasibiricʉ̃ iidigʉ, gamiri bihadigʉ ĩre duhuque. Eropigʉ dipaturi ĩgʉre garibobiricãque, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ĩgʉ eroparĩcʉ̃ peegʉ majigʉre ñajadigʉ watĩ gaguinigui, majigʉre yebague mehmereja, tũru naragãcʉ̃ ii duhupʉ ĩgʉre. Ĩgʉ eropiicʉ̃ majigʉpʉ sĩrigʉ dopa wapʉ. ");
INSERT INTO des_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","—Ĩgʉ sĩria wami, arĩñorã masa bajarã. Erã eropa arĩquerecʉ̃ ta Jesupʉ ĩgʉ mojotore ñeha ĩgʉre tara wahgũ nugupʉ. Ĩgʉ tara wahgũ nugucʉ̃ wahgãnʉgajapʉ ĩgʉpʉ. ");
INSERT INTO des_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pʉhrʉ Jesu wihigue ñajajacʉ̃ ĩarã ĩgʉ buherã erã seyaro serẽpiñorã Jesure: —¿Duhpirã gʉapʉ majigʉre watĩ opagʉre cóãmasibirayuri mʉ pepicʉ̃? arĩ serẽpiñorã erã. ");
INSERT INTO des_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Ĩno watĩre cóãdiarã bʉrigã Goãmʉre serẽro gahmea. Eropirã Goãmʉre serẽmorã ba duhuro gahmea mʉare, arĩ yʉhripʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Eropi erogue árĩnirã waha Galilea yebague eja, tarigãñorã. Irisubu Jesu ĩgʉ buherãre buhegʉ iipʉ. Eropigʉ erã warore gajirã masicʉ̃ gamebiripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Erogue ejagʉ ĩgʉ buherãre buhepʉ. Õpa arĩ buhepʉ: —Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. Masa yʉre ñeha gajirãguere yʉre wiarãcoma. Erã wiara pʉhrʉ yʉre wejẽrãcoma erã. Eropa erã wejẽra pʉhrʉ ʉhrenʉ pʉhrʉ masa mʉriagʉca, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ĩgʉ õpa arĩcʉ̃ õaro peebiriñorã. Eropirã güirã ĩgʉre irire serẽpibiriñorã. ");
INSERT INTO des_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Eropi erã Capernaumgue ejara pʉhrʉ wihigue erã árĩcʉ̃ Jesupʉ serẽpipʉ erãre: —¿Maguere arirã dohpa arĩ dʉyaso wereniguirã iiari mʉa? arĩ serẽpipʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ĩgʉ eroparĩcʉ̃ erã yʉhribiriñorã. Mague arirã õpa arĩ dʉyaso wereniguiñorã erã basi: —¿Nihi ãhriri mari árĩpehrerã wecague? arĩ dʉyaso wereniguiñorã erã. Eropirã erã eropa arĩrare Jesure werediabiriñorã. ");
INSERT INTO des_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Erã eropa yʉhribiricʉ̃ ĩagʉ Jesu doaja ĩgʉ buherãre sihubeo õpa arĩpʉ: —Árĩpehrerã wecague opʉ árĩdiagʉ árĩpehrerã ojogoro majagʉ árĩro dopa ta erã pohro majagʉ árĩro gahmea mʉare, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eropa arĩgʉ majigʉgãre erã watope duhudobopʉ. Duhudobotuha ĩgʉgãre aĩ coã õpa arĩ werepʉ: ");
INSERT INTO des_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Yahare iidiarã, ĩgʉgãre bu árĩgʉre gamerã yʉ sãre gahmea mʉa. Mʉa eropiirã yʉre gamerã, yʉre obeodigʉ Goãmʉ sãre gahmea mʉa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ero pʉhrʉ ĩgʉ buhegʉ Ñu õpa arĩpʉ Jesure: —Buhegʉ, yujugʉ mʉ waĩ mera watẽare cohã wiucʉ̃ gʉa ĩhabʉ. Ĩgʉ mari mera majagʉ ĩgʉ árĩbiricʉ̃ ĩarã, ĩgʉre irire iidorebirimʉrabʉ gʉa, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu erãre werepʉ: —Eropa arĩbita mʉa ĩgʉre. Yujugʉ yʉ waĩ mera deyoro moarire iigʉ, pʉhrʉguere yʉre ñero wereniguimasibeami. ");
INSERT INTO des_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Marire ĩhaturibigʉ árĩgʉ, ĩgʉ mari mera majagʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mʉare diaye ta arãa. Yaharã mʉa árĩcʉ̃ ĩarã gajirã mʉare itamucʉ̃ ĩagʉ Goãmʉ erãre õaro itamugʉcumi. Yuju coaru mera decore mʉare erã tĩacʉ̃ merogã árĩquerecʉ̃, erãre õaro iigʉcumi Goãmʉ erã õaro iira waja, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Eropigʉ Jesu majigʉgãre ĩgʉ basi coã aĩ erãre werenemopʉ: —Ĩgã yʉre umupeogʉgãre weregʉra mʉare: Yujugʉ ĩgã iro dopa árĩgʉre ñerire iidoredigʉ, ĩgʉ ñetariaro tarigʉcumi. Gajigʉre masa ĩgʉre wʉnʉgʉre wʉariye ʉtãye mera dirisiu, wʉariyague ĩgʉre cóãcʉ̃ ñero wabocumi ĩgʉ. Eropigʉ ĩgã dopa árĩgʉre ñerire iidoredigʉpʉ wʉariyague erã cóãdigʉ tauro ñero tarigʉcumi. Ĩgʉ bʉrigã dipuwaja moasũgʉcumi. ");
INSERT INTO des_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mʉ mojoto mera ñero iigʉ, iri mojotore mʉ tabe cóãbodiro dopa iri ñerire duhuque. Irire duhubigʉ peamegue wagʉca. Eroguere ne peame yaribeaa. Eropirã beca sã ʉ̃jʉquererã ne sĩribeama. Mʉ mojotore mʉ cóãcʉ̃ iri dʉca dihta cohmoboya. Eropigʉ mʉpʉ epasi árĩqueregʉ ta pʉhrʉ Goãmʉ mera árĩgʉca. Mʉ pe mojoto mera árĩgʉre peamegue ĩgʉ cóãcʉ̃ ñetariaro tarigʉca. Eropigʉ iri ñeri iiripʉre duhuque. ");
INSERT INTO des_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mʉ guburu mera ñero iigʉ mʉhʉ iri guburu sãre mʉ tabe cóãbodiro dopa ta iri ñerire duhuque. Irire duhubigʉ peamegue wagʉca. Eroguere ne peame yaribeaa. Eropirã beca ne sĩribeama. Mʉ guburure mʉ cóãcʉ̃ irisi dihta cohmoboya. Eropigʉ epasi árĩqueregʉ ta pʉhrʉ Goãmʉ mera árĩgʉca. Mʉ pe guburu mera árĩgʉre mʉre peamegue cóãcʉ̃ mʉ ñetariaro tarigʉca. Eropigʉ iri ñeri iiripʉre duhuque. ");
INSERT INTO des_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Mʉ cuiru mera ñero iigʉ irirure mʉ gorawea cóãbodiro dopa ta iri ñerire duhuque. Irire duhubigʉ peamegue wagʉca. Eroguere ne peame yaribeaa. Eropirã beca sã ne sĩribeama. Mʉ cuirure cóãcʉ̃ iriru dihta cohmoboya. Yujupʉ cuiru mariqueregʉ ta pʉhrʉ Goãmʉ mera árĩgʉca. Mʉre pe cuiri mera árĩgʉre peamegue mʉre cóãcʉ̃ mʉ ñetariaro tarigʉca. Eropigʉ iri ñeri iiripʉre duhuque. ");
INSERT INTO des_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“I yeba árĩrã ñero tarirãca mʉa. Peamegue mari ʉ̃jʉcʉ̃ marire pũriro dopa ta ñero tarirãca mʉa. ");
INSERT INTO des_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moa õaro acaa. Moa acabiricʉ̃ ʉsʉriri iimasiya mara. Moa acabiro iri moa ne õabeaa. Iri moa acabiricʉ̃ dohpagohra iimasiya mara. Eropirã moa õaro acaro dopa mʉa sʉarã árĩque. Eropirã gajirã mera õaro mera árĩque. ");
INSERT INTO des_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Eropigʉ ĩgʉ erogue árĩdigʉ waha, Judea yeba pohrogue eja, dia Jordán waĩcʉriya gajipʉ masegue ejapʉ. Erogue ĩgʉ ejacʉ̃ ĩarã masa bajarã ĩgʉ pohrogue gamenereñorã daja. Erã gamenerecʉ̃ ĩagʉ ero core ĩgʉ buhediro dopa ta dipaturi buhepʉ daja. ");
INSERT INTO des_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ĩgʉ eropa buherisubu fariseo masa erañorã. Jesure ĩgʉ ñero wereniguicʉ̃ peediañorã. Eropa peediarã erã Jesure õpa arĩ serẽpiñorã: —¿Mari marapore cóãcʉ̃ õhari? ¿Moise doreripʉ eropa ta iidone õabeaa. Iri moa acabiricʉ̃ reri mʉ pepicʉ̃? arĩ serẽpiñorã. ");
INSERT INTO des_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Dohpa doreyuri Moise mʉare? arĩ yʉhripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—“Mʉ marapore cóãdiagʉ paperapũgue irire gojaque. Eropa gojagʉ iripũre mʉ marapore otuhajanijagʉgue igore cóãmasia,” arĩ gojañumi Moise, arĩ yʉhriñorã fariseo masa. ");
INSERT INTO des_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Erã eroparĩcʉ̃ peegʉ õpa arĩ werepʉ Jesu: —Mʉa ñecʉ sʉmarã Goãmʉ dorerire iidiabiricʉ̃ ĩagʉ, “Eropa ta wacuraporo,” arĩgʉ, “Mʉa marapore cóãmasia,” arĩ gojañumi Moise. ");
INSERT INTO des_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ĩgʉ eropa arĩ gojara árĩquerecʉ̃ ta, negohraguere Goãmʉ mʉa marasã nomere cóãcʉ̃ gamebiriñumi. I yebare ĩhacũnugugʉ ʉmʉ, nomeo sãre iiñumi. ");
INSERT INTO des_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Eropigʉ ʉmʉ ĩgʉ pagʉ sʉmarãre cohã wiria ĩgʉ marapo mera árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Eropirã erã perã árĩquererã ta, yuju dʉpʉ iro dopa árĩrãcoma. Eropirã erã perã iro dopa árĩbeama. Yuju dʉpʉ iro dopa ãhrima erã. ");
INSERT INTO des_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eropirã Goãmʉ ĩgʉ doreri mera mojotodirima. Eropirã game cóãbiricãro gahmea erãre, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Eropa arĩtuha ĩgʉ buherã mera wihigue ñajaa wapʉ. Wihigue ñajajarã erã marasã nomere cóãrire serẽpinemoñorã daja ĩgʉ buherã. ");
INSERT INTO des_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Erã eropa serẽpiñacʉ̃ ĩgʉ yʉhripʉ: —Ĩgʉ marapore cóãdigʉ gajigo mera marapocʉgʉ, ĩgʉ igo gajigo mera ñero iigʉ iimi. ");
INSERT INTO des_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Eropigo nomeo sã igo marapʉre cóãgo, gajigʉ mera marapʉcʉgo, ĩgʉ gajigʉ mera ñero iigo ãhrimo, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Eropi majirãgãre Jesure mohmepidoremorã erãgãre Jesu pohrogue aĩ erañorã. Erã eropiicʉ̃ ĩgʉ buherãpʉ erãgãre aĩgãrirãre bocatĩri turiñorã. ");
INSERT INTO des_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Erã eropa turicʉ̃ ĩagʉ Jesu papũrigʉ õpa arĩpʉ erãre: —Eropa ĩacãque. Majirã yʉ pohrogue ariporo. Waque, arĩbiricãque erãgãre. Erã Goãmʉre erã opʉre masima. Eropirã Goãmʉ ĩgʉ opʉ árĩroguere oãgã iro dopa pepirã ãhrima eroguere. ");
INSERT INTO des_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Diaye arĩgʉ iiaa mʉare. Oãgã Goãmʉre gamediro dopa ta mʉa Goãmʉre gamebirã ĩgʉ pohrogue wasome mʉa. Mʉa wabiricʉ̃ mʉa opʉ árĩsome ĩgʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eropa arĩtuha Jesu majirãgãre aĩ coãgʉ erãre mohmepi erã õaro árĩburire Goãmʉre serẽbasagʉ õpa arĩpʉ: —Oãgã õarã waporo, arĩ serẽbasapʉ Goãmʉre. ");
INSERT INTO des_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Eropi Jesu ĩgʉ mague wacʉ̃, yujugʉ masʉ omagã wa ĩgʉ guburi pohro mereja Jesure serẽpipʉ. —Mʉhʉ buhegʉ õagʉ ãhraa. ¿Yʉhʉ árĩpehrerinʉri Goãmʉ mera árĩdiagʉ duhpigʉcuri? arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ĩgʉ eroparĩcʉ̃ Jesu ĩgʉre yʉhripʉ: —¿Dohpa arĩronore yʉre “Õagʉ” arĩ piyuri mʉhʉ? Goãmʉ yujugʉ ta õagʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ĩgʉ Goãmʉ dorerire masia mʉhʉ. “Masare wejẽbiricãque. Gajigʉ marapo mera árĩbiricãque. Yajabita, gʉyabita, gajirã yare gʉya aĩbita, mʉ pagʉ sʉmarãre umupeoque,” ire doremi Goãmʉ. I dorerire iro gahmea mʉre, arĩ werepʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Buhegʉ, irire árĩpehrerire majigʉgãgue ta tari­nʉgabiri­mʉribʉ yʉa, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu ĩgʉre ĩhamehtu mahipʉ. Eropigʉ õpa arĩpʉ: —Merogã dʉhyaa mʉre mʉ iipehoboro. Árĩpehrerire mʉ yare duaque. Eropigʉ árĩpehreri mʉ wajatarare mojomorocʉrãre oque. Mʉhʉ eropiicʉ̃ baja õari ʉmarogue Goãmʉ pohroguere árĩyuroca. Tuhajanugu yʉ mera majagʉ árĩbu arique, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wʉaro opagʉ árĩpʉ ĩgʉ. Eropigʉ Jesu ĩgʉre eroparĩcʉ̃ peegʉ ĩgʉ oparire mojomorocʉrãre odiabigʉ, turaro bʉjawere, sʉabiri waha wapʉ. ");
INSERT INTO des_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ĩgʉ bʉjawere wacʉ̃ ĩagʉ Jesu majinʉgaja ĩgʉ buherãre ĩha õpa arĩpʉ: —Doberi oparã Goãmʉ ĩgʉ opʉ árĩroguere erã wadiacʉ̃ diasa ãhraa, arĩpʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ĩgʉ eroparĩcʉ̃ peerã erãpʉ pee ʉca waha pee masibiriñorã. Eropa arĩtuha Jesu dipaturi werepʉ erãre: —Yʉ acawererã, árĩpehrerã “Yʉ gamero yʉ opari mera ta õaro tarigʉca,” arĩ pepirã Goãmʉ ĩgʉ opʉ árĩroguere erã wacʉ̃ diasataria. ");
INSERT INTO des_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camellopʉ awiru gobegãgue ĩgʉ ñajatariwereadiacʉ̃ masiya mara ĩgʉre. Eropa ta doberi opagʉ ĩgʉ Goãmʉ mera õaro árĩgʉ ĩgʉ opʉ árĩroguere ĩgʉ wacʉ̃ diasa ãhraa, arĩ werepʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ĩgʉ eroparĩcʉ̃ peenijarã ĩhamaria wanijarã, erã basi õpa arĩñorã: —Yaho. Ĩgʉ arĩro dopa ta diaye árĩcʉ̃ ne yujugʉ masʉre taubiribocumi Goãmʉ ĩgʉ pohro wamorãre, arĩñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Erã eroparĩcʉ̃ peegʉ Jesu erãre ĩhabeo õpa arĩpʉ: —Masa erã bocatĩuro erã õaro iiri mera tarimasibeama. Goãmʉ pohrogue wamasibeama. Goãmʉ dihta masare peamegue wabonirãre taumasimi ĩgʉ pohro wamorãre. Ĩgʉ árĩpehrerire õaro iimasipehocãmi, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ĩgʉ eroparĩcʉ̃ peegʉ Pedro ĩgʉre õpa arĩpʉ: —Peenique. Gʉapʉ árĩpehreri gʉa yare apicãbʉ mʉ mera wamorã, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ĩgʉ eroparĩcʉ̃ Jesu õpa arĩpʉ: —Diaye arĩgʉ iiaa mʉare. Árĩpehrerã õari buherire yaha árĩburire iimorã mʉa wirire, mʉa pagʉ porãre, mʉa pagʉ sʉmarãre, mʉa porãre, mʉa poerire apirã wʉaro wajatarãca mʉa dohpaguere. ");
INSERT INTO des_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Eropirã mʉa wirire, mʉa pagʉ porãre, mʉa pagosã nomere, mʉa porãre, mʉa poerire ero core mʉa opadiro tauro dohpaguere baja oparãca mʉa ñero tarirã árĩquererã. Eropirã gajirã mʉare ñero iirãcoma. Eropirã pʉhrʉguere árĩpehrerinʉri Goãmʉ mera árĩrãca. ");
INSERT INTO des_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dohpaguere bajarã oparã árĩnirã irisubure bu árĩrã dujacãrãcoma. Eropirã dohpaguere bajarã bu árĩnirãpʉ oparã dujarãcoma daja, arĩ werepʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Eropi erã mague majaa, Jerusaléngue majarã iiñorã. Jesu erã coregã mʉhtapʉ. Ĩgʉ eropa mʉhtacʉ̃ ĩarã ĩgʉ buherã ĩha ʉca wañorã. Eropirã erã pʉhrʉ nʉrʉsiarãpʉ güiro mera ĩgʉre nʉrʉsiañorã. Eropigʉ Jesu doce ĩgʉ buherã seyarore sihubeo, masa ĩgʉre iiburire werenʉgapʉ daja erãre. ");
INSERT INTO des_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Peeque yʉre. Dohpaguere Jerusaléngue warã iiaa mari. Erogue masa yʉ masʉre Goãmʉ ĩgʉ obeodigʉre yʉre ñeha, pahia oparãre, judio masare buherã sãre yʉre orãcoma. Eropirã yʉre wejẽdorerãcoma erã. Eropa wejẽdorerã judio masa árĩbirãre orãcoma yʉre. ");
INSERT INTO des_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Erã eropa ora pʉhrʉ erã yʉre wereya, disico ehosũ tãrarãcoma. Tuhaja yʉre wejẽrãcoma. Eropigʉ yʉ sĩrira pʉhrʉ ʉhrenʉ pʉhrʉ masa mʉriagʉca, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Eropi Santiago, Ñu mera Jesu pohrogã ejarã erã gamerire serẽñorã ĩgʉre. Erã Zebedeo porã árĩñorã. Eropirã õpa arĩñorã: —Buhegʉ, gʉa serẽro dopa ta gʉare iique mʉhʉ, arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Yʉhʉ duhpiicʉ̃ gahmeri mʉa? arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Mʉhʉ árĩpehrerã wecague opʉ árĩgʉ gʉare mʉ waĩ mera dorerã acuque. Yujugʉre mʉ diayepʉ, gajigʉre copʉ doboque gʉare. Mʉ mera oparã gʉa árĩboro dopa iique, arĩ serẽñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Erã eroparĩcʉ̃ peegʉ õpa arĩ werepʉ Jesu: —Mʉa ñero tariborore masibiriquererã õpa arĩ serẽa mʉa yʉre. ¿Dohpaguere yʉ ñero tariboro dopa ta mʉa sã ñero tarirã yujuro bojebocuri mʉa? ¿Yʉre erã ñero iiboro dopa mʉa sãre ñero iicʉ̃ yujuro bojemasibocuri mʉa? arĩ serẽpipʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Yujuro bojerãca, arĩ yʉhriñorã. Erã eroparĩcʉ̃ Jesu õpa arĩ werepʉ: —Yʉ ñero tariboro dopa ta mʉa sã ñero tarirãca. ");
INSERT INTO des_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Eropa mʉa tarimorã árĩquerecʉ̃ ta, yʉ mera doremorãre beyemasibeaa yʉhʉ. Irire yʉhʉ Pagʉ amutuhami. Eropirã ĩgʉ beyenirã dihta yʉ diayepʉ yʉ copʉ doarãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Santiago, Ñu sã erã oparã árĩburire Jesure serẽcʉ̃ gajirã diez buherã peerã, erã mera guañorã. ");
INSERT INTO des_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Erã eropa guacʉ̃ ĩagʉ, Jesu ĩgʉ buherãre sihu gameneo õpa arĩpʉ: —Goãmʉre masibirã oparãpʉ erã masare dorerã, pũriro mera dorema. ");
INSERT INTO des_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉapʉ ne eropa iisome mʉa basi. Mʉa mera majagʉ opʉ árĩdiagʉ, árĩpehrerã ĩgʉ mera majarãre itamugʉ árĩporo. ");
INSERT INTO des_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Eropigʉ árĩpehrerãre doregʉ árĩdiagʉ, erã pohro majagʉ árĩro dopa ta árĩporo. ");
INSERT INTO des_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Eropa árĩgʉ tiiaa yʉ sã. Masare dorebiragʉ arigʉ iibiribʉ. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ árĩqueregʉ ta, i yebaguere masare itamugʉ arigʉ iibʉ. Eropigʉ masa bajarã erã ñero iira dipuwajare sĩribasagʉ arigʉ iibʉ. Eropigʉ erã peamegue wabonirãre taugʉ arigʉ iibʉ, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Eropi erã Jericógue ejañorã. Eropirã iri macague árĩnirã Jesu ĩgʉ buherã masa bajarã mera wañorã. Jesu wari maha tʉrogue yujugʉ masʉ cuiri ĩhajabigʉ doapʉ. Ĩgʉ Bartimeo waĩcʉgʉ Timeo magʉ árĩpʉ. Ĩgʉ ma tʉrogue doagʉ ʉmʉri nʉcʉ masare niyerure serẽmʉripʉ. ");
INSERT INTO des_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eropigʉ ero doanijagʉ masa “Jesu Nazare majagʉ ahrimi,” erã arĩcʉ̃ peepʉ. Eropa peenijagʉ õpa arĩ gaguiniguipʉ: —Jesu, opʉ Davi mʉrʉ pãrami masare taubu mojomoro ĩaque yʉre, arĩ gaguiniguipʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ĩgʉ eropa arĩ gaguiniguicʉ̃ peerã masa bajarã Bartimeore “Ejarimaricãque,” arĩ turiñorã. Erã eropa arĩ turiquerecʉ̃, ĩgʉpʉ ĩgʉ ero core ĩgʉ gaguiniguidiro tauro gaguiniguipʉ daja. —Jesu, opʉ Davi mʉrʉ pãrami masare taubu mojomoro ĩaque yʉre, arĩ gaguiniguipʉ daja. ");
INSERT INTO des_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ĩgʉ eroparĩcʉ̃ peegʉ Jesupʉ dujanʉgaja: —Sihubeoque ĩgʉre, arĩpʉ. Ĩgʉ eroparĩcʉ̃ peerã erãpʉ ĩgʉ cuiri ĩhajabigʉre sihugãñorã. —Mucubirique. Wahgãnʉgajaque. Ĩgʉ mʉre sihumi, arĩñorã erã ĩgʉre Bartimeore. ");
INSERT INTO des_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Erã eroparĩcʉ̃ peegʉ ĩgʉ omasiariñere tuweapi, buhri tarimagã Jesu pohrogue ejanʉgajapʉ. ");
INSERT INTO des_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Eropigʉ Jesu serẽpipʉ ĩgʉre: —¿Dohpa yʉhʉ mʉre iicʉ̃ gahmeri mʉhʉ? arĩ serẽpipʉ Jesu ĩgʉre. —Yʉ opʉ, yʉre cuiri ĩacʉ̃ iique, arĩpʉ ĩgʉ cuiri ĩhajabigʉpʉ. ");
INSERT INTO des_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Mʉ yʉre umupeonijagʉ õagʉ wahaa. Eropigʉ wanisa, arĩpʉ Jesu ĩgʉre. Ĩgʉ eroparĩcʉ̃ ta cuiri ĩhajabigʉ õaro ĩha wapʉ. Õagʉ wanijagʉ Jesu mera mague nʉrʉsia wahgã wapʉ. ");
INSERT INTO des_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Eropii erã Jerusaléngue ejaboro coregã, Betfagé maca pohrogã, Betania maca pohrogã ejamʉhtañorã. Iri macari ʉtãgʉ Olivo waĩcʉdigʉ gubuye árĩyoro. Erogue ejagʉ perãre ĩgʉ buherãre Jesu obeogʉ õpa arĩpʉ: ");
INSERT INTO des_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Si macague waque. Erogue ejarã mata burrogãre erã dirinugudigʉgãre bocajarãca. Gajirã erã peyaya marigʉ árĩcumi. Ĩgʉre bocaja ĩgʉre diriradarire pãa yʉre aĩgãribasaque. ");
INSERT INTO des_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mʉa eropiicʉ̃ ĩagʉ burrogã opʉ “¿Duhpimorã burrogãre pãri?” ĩgʉ arĩcʉ̃ peerã õpa arĩ yʉhrique ĩgʉre: “Mari tĩgʉ burrogãre gamebeoniami dohpa. Eropigʉ dohparagã wiagʉcumi ĩgʉre,” arĩ wereque ĩgʉre, arĩ weredore obeopʉ ĩgʉ buherã perãre. ");
INSERT INTO des_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ĩgʉ dorebeonirã waha, wihi pohro árĩri mare burrogãre disiporo erã dirinugudigʉgãre bocajañorã. Bocaja ĩgʉre erã diriradarire pãñorã. ");
INSERT INTO des_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eropirã ĩgʉre erã pãcʉ̃ ĩarã ero niguinirã serẽpiñorã: —¿Duhpimorã mʉa diriradarire pãri burrogãre? arĩ serẽpiñorã. ");
INSERT INTO des_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Erã eroparĩcʉ̃ peerã erãpʉ Jesu ĩgʉ arĩdiro dopa ta wereñorã erãre serẽpirãre. Erã eropa arĩ werecʉ̃ peerã erã ero niguinirãpʉ “Aĩgãque,” arĩñorã erãre. ");
INSERT INTO des_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eropirã erã burrogãre Jesu pohrogue aĩgã wañorã. Erã aĩ ejara pʉhrʉ suhri ĩgʉgã weca erã peotuhacʉ̃ ĩagʉ Jesupʉ ĩgʉgã wecague mʉribejapʉ wabu. ");
INSERT INTO des_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Eropirã masa bajarã erã peyari suhrire tuwea aĩ ĩgʉ wari maha deco sẽopi mʉhtañorã Jesure umupeorã. Gajirãpʉ pũricʉri dʉpʉrire poerigue erã aĩgãrira dʉpʉrire apimʉhtañorã “Õari maha árĩporo,” arĩrã. ");
INSERT INTO des_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eropirã ĩgʉ core warã, ĩgʉ pʉhrʉ arirã sã õpa arĩ gaguiniñorã: —Ĩre umupeorã. Ihĩ Goãmʉ ĩgʉ obeodigʉ õaro ariporo. ");
INSERT INTO des_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mari ñecʉ Davi mʉrʉ opʉ ĩgʉ árĩdiro dopa ta õaro ariporo. “Ʉmaro majagʉ turagʉ ãhrimi,” arĩ umupeorã, arĩ gaguiniguiñorã erã. ");
INSERT INTO des_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Eropigʉ Jesu Jerusaléngue ejapʉ. Ejagʉ Goãmʉ ya wihigue ñajajagʉ, iri wihi majare árĩpehrerire ĩapehocãpʉ. Ĩatuhaja “Ñamicague ãhraa. Ʉmʉñarigã ta ãhraa. Ina warã,” arĩpʉ Jesu. Ĩgʉ buherã mera Betaniague waha wañorã. ");
INSERT INTO des_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Eropi gajinʉ erã Betaniague árĩnirã Jerusaléngue dujariñorã daja. Eropa dujaricʉ̃ Jesupʉ oaboa wapʉ. Eropa oaboagʉ yoarogue niguidigʉre higueragʉre õaro pũricʉdigʉre ĩanijagʉ irigʉ dʉcare amagʉ waripʉ. ");
INSERT INTO des_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dʉca mariyoro. Dʉcacʉrisubu árĩbiriya. Pũri dihta opayoro. ");
INSERT INTO des_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eropigʉ dʉca maricʉ̃ ĩagʉ õpa arĩpʉ: —Irigʉ dʉcare masa ne dipaturi babiricãporo. Ne dʉcacʉbiricãporo, arĩpʉ Jesu. Ĩgʉ eroparĩcʉ̃ ĩgʉ buherãpʉ peeñorã. ");
INSERT INTO des_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ĩgʉ eropiira pʉhrʉ erã Jerusaléngue erañorã. Eragʉ Jesu Goãmʉ ya wihigue ñajapʉ daja. Ñajajagʉ doberi duarãre, asũrãre bocajagʉ cohã wiucãpʉ. Eropigʉ niyerure game gohroto doarã ya mesarire yomemuju aĩ mehpi behomʉripʉ. Bujare duarã erã doari pẽrori sãre eropa ta iipʉ. ");
INSERT INTO des_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Eropigʉ Jesu Goãmʉ wihiguere gajinore aĩ ñajadorebiripʉ masare. ");
INSERT INTO des_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Eropigʉ Jesu õpa arĩ buhepʉ erãre: —Õpa ãhraa Goãmʉ yare erã gojarapũgue: “Yaha wihi Goãmʉ mera wereniguiri wihi waĩcʉroca. Eropiro árĩpehrero majarãgue yʉ mera erã wereniguiri wihi árĩroca,” arĩ gojañuma Goãmʉ wereniguirire. Goãmʉ eropa arĩquerecʉ̃ ta, mʉapʉ i wihire Goãmʉ wihire duadoarã bu game yajarã iiaa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ĩgʉ eropa arĩ buhecʉ̃ árĩpehrerã masapʉ pee ʉcapehrea wañorã. Eropirã pahia oparã, judio masare buherã mera ĩgʉre güi árĩñorã. Eropirã erã ĩgʉre wejẽburire guñamaañorã. ");
INSERT INTO des_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Erã eropiicʉ̃ ñamicague Jesu ĩgʉ buherã mera iri maca árĩnirã waha wañorã. ");
INSERT INTO des_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eropirã boyo dijaricʉ̃ mague majarirã higueragʉre ĩañorã daja. Irigʉ nugurigue sĩrinʉga sĩriadigʉ árĩcʉ̃ ĩañorã. ");
INSERT INTO des_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Irigʉre ĩagʉ Pedropʉ õpa arĩpʉ: —Buhegʉ, ĩaque. Irigʉ higueragʉpʉ mʉ sĩridoredigʉpʉ sĩria waya, arĩpʉ Pedro. ");
INSERT INTO des_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ĩgʉ eroparĩcʉ̃ Jesu werepʉ erãre: —Goãmʉre umupeoturaque mʉa. ");
INSERT INTO des_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Diaye arĩgʉ tiiaa mʉare. Mʉa Goãmʉre õaro umupeori mera irigʉ ʉtãgʉre “Dua aĩ wʉariyague cóãdigʉ árĩporo,” mʉa Goãmʉre arĩcʉ̃, mʉa arĩdiro dopa ta waroca. “Yʉ serẽro dopa diaye ta eropa iigʉcumi,” mʉa arĩ guñacʉ̃, “Goãmʉ iisome,” arĩbiricʉ̃, mʉa serẽdiro dopa ta Goãmʉ iigʉcumi. ");
INSERT INTO des_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eropigʉ irire weregʉra mʉare. Goãmʉ mera wereniguirã, ĩgʉre serẽrã, “Yʉ serẽro dopa ta eropa waroca yʉre,” arĩ guñaque. Mʉa eropiicʉ̃ ĩagʉ Goãmʉ mʉa serẽrire ogʉcumi. ");
INSERT INTO des_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Eropirã Goãmʉre mʉa serẽboro core gajirãre erã mʉare erã ñero iirare cãdijique. Gajirã erã ñero iicʉ̃ mʉa guarare duhuque. Mʉa eropiicʉ̃ ĩagʉ mari Pagʉ ʉmaro majagʉ mʉa ñero iirare ĩgʉ sã cãdijigʉcumi. ");
INSERT INTO des_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mʉare ñero iirare mʉa cãdijibiricʉ̃ ĩgʉ sã mʉa ñero iirare cãdijisome, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ĩgʉ eropa arĩra pʉhrʉ erã Jerusaléngue wañorã daja. Eropirã Jesu Goãmʉ wihigue ĩgʉ curicʉ̃ ĩarã, pahia oparã, judio masare buherã, mʉrã mera ĩgʉ pohrogue erarã ĩgʉre serẽpiñorã: ");
INSERT INTO des_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Noa doreri mera irinore iigʉ iiri mʉhʉ? ¿Noa mʉre Goãmʉ wihi duanirãre cóãdoreari? arĩ serẽpiñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Mʉapʉre serẽpimʉhtagʉra. Õaro mʉa yʉhricʉ̃ yʉ sã mʉare yʉhrigʉra. ");
INSERT INTO des_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ñu masare ĩgʉ waĩyecʉ̃ noano ĩgʉre waĩyedoremʉriyuri mʉa pepicʉ̃? ¿O Goãmʉ doreyuri? ¿O masapʉ doremʉriyuri mʉa pepicʉ̃? Yʉre wereque, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ĩgʉ eroparĩcʉ̃ peerã erãpʉ erã basi game õpa arĩ wereniguiñorã: —¿Dohpa arĩ yʉhrirãcuri mari? “Goãmʉ Ñure doredigʉ árĩñumi,” mari arĩcʉ̃, “¿Goãmʉ Ñure ĩgʉ dorequerecʉ̃ ta duhpirã ĩgʉ wererare peebirari mʉapʉ?” arĩbocumi Jesu marire. ");
INSERT INTO des_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Oã masapʉ “Diaye ta Ñu Goãmʉ yare weremʉhtadigʉ árĩmi,” arĩ pepima erã. Erã eropa pepirã, “Ñu ĩgʉ waĩyecʉ̃ Goãmʉpʉ ĩgʉre doredigʉ árĩbiriñumi,” mari arĩcʉ̃, masapʉ mari mera guarãcoma, arĩñorã erã basi. ");
INSERT INTO des_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eropirã erã Jesure õpa arĩ yʉhriñorã: —Ñure waĩyedoredigʉre gʉa masibeaa, arĩñorã erã Jesure. Erã eroparĩcʉ̃ õpa arĩpʉ Jesu. —Irisubu tamerare yʉ sã mʉa serẽpirare werebeaa mʉare. Yʉ iirire iidoredigʉre werebeaa mʉare, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Eropi Jesu queori mera buhenʉgapʉ daja erãre. —Yeba opʉ árĩñumi. Iri yebare ĩgʉ ya iguidarire oteñumi. Otetuha sãrirore nugu, iguire erã cʉhra bujuburi gobere seañumi. Pohe decogue ʉmari wihigã sãre iiñumi ĩhadibuma õaro. Eropigʉ gajirãre ĩgʉ ya pohe deco mera apiñumi erã mohme corera waja. Eropigʉ iri pohere erãre mohme coredoretuhaja gaji yebague waha wañumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pʉhrʉ igui ñirisubu árĩcʉ̃ pohe opʉ ĩgʉ pohro majagʉre ĩgʉ ya pohe mohme corerã pohrogue obeoriñumi. Pohe maja ĩgʉ ya oteri dʉcare ĩgʉ ya sero maja dʉcare aĩdoregʉ obeoriñumi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Eropirã pohere mohme corerãpʉ ĩgʉ pohro majagʉre ñeha pañuma. Eropiituha ĩgʉ ya igui tõrire obiriquererã dujadoreñuma ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eropigʉ pohe opʉ gajigʉ ĩgʉ pohro majagʉre obeoriñumi daja. Eropirã pohere mohme corerãpʉ ĩgʉre ĩgʉ dipurure cami moa ñero iiñuma ĩgʉ sãre. ");
INSERT INTO des_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Gajigʉ ĩgʉ pohro majagʉre obeocʉ̃ ĩgʉpʉre wejẽcãñuma. Gajirã sãre bajarãre eropa dihta iiñuma. Gajirãre pa gajirãre wejẽñuma erã. ");
INSERT INTO des_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Eropigʉ pohe opʉ magʉ dihta dʉhyañumi. Ĩgʉ ta ĩgʉ magʉ ĩgʉ mahigʉ árĩñumi. Eropigʉ ĩgʉ magʉre obeoñumi pare erã pohrogue, “Yʉ magʉpʉre umupeorãcoma,” arĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ĩgʉ õpa arĩ pepiquerecʉ̃, erã pohere corerãpʉ ĩgʉ magʉ aricʉ̃ ĩha, õpa arĩ wereniguiñuma: “Pohe opʉ magʉ ãhrimi. Ĩgʉre wejẽcãrã mari. Eropiro i pohe mari ya pohe dujaroca,” arĩ wereniguiñuma erã erã basi. ");
INSERT INTO des_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eropa arĩrã ĩgʉre ñeha wejẽ, pohe tʉrogue aĩgã cóãcãñuma erã ĩgʉre, arĩpʉ Jesu erãre. Eropa arĩtuhaja Jesu erãre serẽpipʉ: ");
INSERT INTO des_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—Ne, ¿pohe opʉ dujarigʉ dohpa iigʉcuri ĩgʉ ya pohere mohme corerãre? arĩpʉ Jesu. Õpa iigʉcumi erãre, arĩpʉ. Ĩgʉ erãre wejẽ gajirãpʉre pohere mohmedoregʉcumi, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","¿Goãmʉ yare erã gojarapũgue õpa arĩrire irire buhebiriri mʉa? Õpa arĩ gojañuma: Ihĩ Cristo ʉtãye iro dopa ãhrimi. Masa Cristore gamebirãcoma. Erã gamebiriquerecʉ̃ Goãmʉ ĩgʉre beye opʉ acumi. Goãmʉpʉ ire iimi. Ĩgʉ eropa iicʉ̃ ĩarã “Õataria,” arĩ pepia mari, arĩ gojañuma iribojeguere. ¿Irire ne buhebiriri mʉa? arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ĩgʉ eroparĩcʉ̃ peerã pahia oparã, judio masare buherã, mʉrã mera õpa arĩ pepiñorã: “Jesu i queorire weregʉ ‘Erã ñerã mohme corerã iro dopa ãhrima,’ marire arĩ weresãgʉ iicumi,” arĩ pepiñorã. Eropa arĩ pepirã Jesure ñeadiariñorã. Eropa ñeadiaquererã, masapʉ Jesure gamerã mari mera guari, arĩrã masare güi árĩñorã. Eropa güirã ĩgʉre cohãgã wañorã. ");
INSERT INTO des_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Waha, erã mera majarãre yujurãyerire fariseo masare, Herode ya curu majarã sãre Jesure serẽpiñadore obeoñorã daja. Erã Jesure baja serẽpiri mera ĩgʉ gajiropa yʉhricʉ̃ weresãmorã iiriñorã. ");
INSERT INTO des_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eropirã Jesu pohro eja ĩgʉre serẽpiñorã: —Buhegʉ, diaye mʉ wereniguigʉ gʉyari marigʉ mʉ árĩcʉ̃ masia gʉa. Eropigʉ opʉ árĩcʉ̃ sãre bu árĩgʉ ĩgʉ árĩcʉ̃ sãre mʉhʉ yujuropa ĩhaa. Eropigʉ Goãmʉ yare diaye mʉhʉ werea. Masa sʉacʉ̃ sãre erã sʉabiricʉ̃ sãre queoro werea. Eropigʉ gʉare wereque: ¿Roma majagʉ árĩpehrerã tauro opʉ árĩgʉre, gobierno majare marire wajayero gahmeri mʉ pepicʉ̃? ¿Mari doreripʉ wajayedoreri mʉ pepicʉ̃? arĩ serẽpiñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Erã eropa arĩ serẽpicʉ̃ peegʉ erã gʉyarire erã ñero iidiarire masigʉ õpa arĩ yʉhripʉ erãre: —¿Duhpirã yʉ ñero wereniguicʉ̃ peediari mʉa? Dohparagã niyerusere aĩgãrique irisere ĩamorã, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ĩgʉ eroparĩcʉ̃ peerã yujuse niyerusere aĩgãriñorã. Erã irisere aĩ eracʉ̃ ĩagʉ Jesu serẽpipʉ erãre: —¿Nihino gohra masʉ tuhyari isere? ¿Noa waĩ tuhyari isere? arĩ serẽpipʉ ĩgʉ. —César waĩcʉgʉ masa tauro opʉ masʉ ĩgʉ waĩ sã tuhyaa irisegue, arĩ yʉhriñorã erã. ");
INSERT INTO des_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Erã eroparĩcʉ̃ Jesu werepʉ erãre: —Irisubu tamerare masa tauro opʉ árĩgʉ yare ĩgʉre oque. Goãmʉ yare Goãmʉpʉre oque, arĩpʉ Jesu. Ĩgʉ eroparĩcʉ̃ pee ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Eropi yujurãyeri Saduceo masa Jesu pohroguere erañorã. Saduceo masapʉ “Goãmʉ sĩrinirãre masusome,” arĩ pepirã árĩñorã. ");
INSERT INTO des_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Eropirã erã õpa arĩñorã Jesure: —Buhegʉ, marire õpa arĩ gojadigʉ árĩmi Moise: “Yujugʉ ĩgʉ tĩgʉ marapocʉgʉ porã mariqueregʉ ĩgʉ sĩricʉ̃ ĩagʉ, ĩgʉ pagʉ magʉre ĩgʉ tĩgʉ marapo árĩdigore marapocʉro gahmea. Eropigʉ ĩgʉ tĩgʉ mʉrʉ ĩgʉ tĩgʉ ĩgʉ porãcʉbodiro dopa ta porãcʉro gahmea ĩgʉ pagʉ magʉre. Eropirã ĩgʉ tĩgʉ mʉrʉ porã iro dopa árĩrãcoma,” arĩdi árĩmi Moise, arĩñorã. ");
INSERT INTO des_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ire erã arĩtuhaja i queorire werenemoñorã Jesure. —Yujugʉ porã siete árĩñorã. Eropii erã tĩgʉpʉ marapocʉ, porã marigʉ ta sĩria wapʉ. ");
INSERT INTO des_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Eropigʉ gajigʉ ĩgʉ pagʉ magʉ sã ĩgʉ tĩgʉ mʉrʉ marapo árĩdigore marapocʉpʉ. Ĩgʉ eropa marapocʉra pʉhrʉ ĩgʉ sã ĩgʉ tĩgʉ mʉrʉ iro dopa ta porã mariqueregʉ ta sĩria wapʉ. Eropigʉ ĩgʉ pagʉ magʉ ĩgʉ ĩgʉ mʉrʉ iro dopa porã mariqueregʉ ta sĩria wapʉ. ");
INSERT INTO des_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Eropa dihta wañorã yujugʉ porã. Ne porã mariquererã sĩripehrea wañorã. Erã marapo sã erã pʉhrʉ sĩria wapo pare, erã arĩtuhaja Jesure serẽpiñañorã. ");
INSERT INTO des_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Ne, Goãmʉ árĩpehrerã sĩrinirãre ĩgʉ masucʉ̃ nihino marapo gohra árĩgocuri igo? Erã árĩpehrerã igore marapocʉnirã árĩñorã. ¿Eropigo nihino marapopʉ árĩgocuri igo? arĩ serẽpiñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu yʉhripʉ erãre: —Goãmʉ yare erã gojarapũ wereniguirire ne masibeaa mʉa. Eropirã Goãmʉ ĩgʉ turari sãre ne masibeaa mʉa, arĩpʉ Jesu. Eropiro mʉa pepiripʉ diaye árĩbeaa. ");
INSERT INTO des_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sĩrinirã mʉra erã masa mʉriara pʉhrʉ erã anyua iro dopa ãhrima. Erã ʉma nome mera marapocʉbeama eroguere. ");
INSERT INTO des_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Sĩrinirã erã masa mʉriaboropʉre mʉare weregʉra, arĩpʉ Jesu. Irire Moise õaro werepehocãñumi. Iri yucʉgʉgãgue ʉ̃jʉrisubu árĩgʉ Goãmʉ õpa wereñumi Moisere: “Yʉhʉ Abrahã, Isaa, Jacobo, erã opʉ ãhraa,” arĩ wereñumi Goãmʉ iribojegue. ");
INSERT INTO des_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Erã sĩrira pʉhrʉgue “Erã opʉ ta ãhraa,” arĩ wereñumi Goãmʉ. Eropirã erã sĩrinirã mʉra ĩgʉ masunirã árĩrã erã ojocarirã ãhrima. Eropirã “Sĩrinirã masasome,” arĩ pepirã diaye pepibeaa mʉa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Eropigʉ yujugʉ judio masa erã buherã mera majagʉ erã pohrogue eraa, erã game wereniguicʉ̃ peepʉ. Jesu ĩgʉ õaro yʉhririre peegʉ serẽpipʉ ĩgʉre. —¿Goãmʉ ya doreri õatariaro doreripʉ diñe doreripʉ ãhriri mʉ pepicʉ̃re? arĩ serẽpipʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu ĩgʉre yʉhripʉ: —Iñe doreriñe õatariariñe õpa ãhraa. “Israe masa peeque. Goãmʉ mari Opʉ yujugʉ ta ãhrimi. ");
INSERT INTO des_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bʉrigã mʉa sĩporã mera, mʉa turari mera, mʉa õaro guñari mera Goãmʉre mʉa Opʉre mahique,” arĩmi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iñe doreriñe pʉhrʉ gaji doreriñe sã õataria. “Mʉ basi mahiro dopa ta mʉ pohro árĩrã sãre mahique,” arĩmi Goãmʉ. Iri pe doreri ta árĩpehreri gaji doreri tauro ãhraa, arĩ werepʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ĩgʉ eroparĩcʉ̃ judio masare buhegʉ õpa arĩ yʉhripʉ: —Eropa ta ãhraa, buhegʉ. Diaye ta arãa mʉhʉ. Goãmʉ yujugʉ ta ãhrimi. Gajigʉ ĩgʉ iro dopa árĩgʉ marimi. Mʉ arĩri diaye ta ãhraa. Goãmʉre turaro mari sĩporã mera, mari turari mera, mari pepiri mera, mari õaro guñari mera ĩgʉre mahiro gahmea. Mari pohro árĩrãre mari basi mari mahiro dopa ta, erã sãre mahiro gahmea marire. ");
INSERT INTO des_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mari Goãmʉre umupeomorã waimʉrã wejẽ soemujucʉ̃ õapũrica. I tauro Goãmʉre masa sãre mari mahicʉ̃ õataria, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ĩgʉ pee masiri mera yʉhricʉ̃ ĩha Jesu ĩgʉre arĩpʉ: —Merogã dʉhyaa mʉre Goãmʉ mʉ opʉre mʉ masiboro, arĩpʉ Jesu ĩgʉre. Ĩgʉre eroparĩcʉ̃ gajirã peerã ĩgʉre güirã serẽpi­nemo­diabiriñorã pare. ");
INSERT INTO des_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Eropigʉ Goãmʉ wihigue buhegʉ õpa arĩpʉ Jesu: —“Cristo Davi mʉrʉ pãrami arigʉcumi,” arĩ buhema marire buherã. ¿Duhpirã eropa arĩ buheri erã? Erã õaro masiboro dʉhyania erãre dohpa. ");
INSERT INTO des_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davi ĩgʉ basi Espíritu Santo ĩgʉre dorero dopa ta õpa arĩ wereñumi: Goãmʉ yʉ opʉre õpa arãmi. “Ohõ yʉ diayepʉ yʉ mera dorebu doaque. Eropigʉ mʉre ĩhaturirãre mʉre tarinʉgabasagʉca yʉhʉ,” arĩmi Goãmʉ yʉ opʉre, arĩ gojañumi Davi mʉrʉ. ");
INSERT INTO des_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Eropa arĩ gojagʉ Davi mʉrʉ opʉcʉpʉ Cristore “Yʉ opʉ,” arĩgʉ. Cristo Davi mʉrʉ opʉ ãhrimi. Eropigʉ Davi mʉrʉ Cristo ñecʉ árĩqueregʉ opʉcʉñumi Cristore, arĩ werepʉ Jesu. Ĩgʉ eropa arĩ buhecʉ̃ bajarã masa mucubiriri mera peeñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Eropigʉ ĩgʉ buhenemogʉ õpa arĩpʉ: —Masare buherã erã ñero iirire õaro ĩaque. Eropirã erã iiro dopa iibiricãque. Erã yoari suhri saña erã masa erã ĩhabeoro cuhrima. Doberi duarogue gajirã umupeori mera erãre bocatĩri serẽcʉ̃ gahmema erã. ");
INSERT INTO des_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Eropirã mari buheri wiriguere õari doari dihtare doadiama. Eropirã bosenʉri árĩcʉ̃ sãre oparã erã doari dihtare gahmema erã. ");
INSERT INTO des_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eropirã erã wapeweyarã nome erã wajamocʉ̃ ĩha erã ya wirire emacãma erã nomere. Eropa erãre mojomoro ĩabiriquererã erã masa ĩhurore yoari boje Goãmʉre serẽma, “Gʉa Goãmʉre õaro umupeoa,” arĩ gʉyarã. Erã eropa iira dipuwaja gajirã tauro dipuwaja moagʉcumi erãre, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Eropigʉ Jesu Goãmʉ wihi maja erã amuburi niyeru gameneori comoro pohro doapʉ. Ero masa erã niyeru sãcʉ̃ ĩapʉ. Doberi oparã iri comoroguere niyeru pagari sãa tari wahgãmʉriñorã. ");
INSERT INTO des_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eropigo wapeweyo bʉro iri comorogue ahri pesegã sãpo. Pese yuju centavo maja ãhraa. ");
INSERT INTO des_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iriserire igo apicʉ̃ ĩagʉ Jesu ĩgʉ buherãre sihubeo arĩpʉ: —Diaye arĩgʉ iiaa mʉare. Igo wapeweyo mojomorocʉgo niyeru sãri comorogue igo yare sãgo gajirã árĩpehrerã erã sãdiro tauro sãmo igo. ");
INSERT INTO des_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gajirã doberi oparã erã wʉaro oquerecʉ̃ ta erã ya wʉaro dʉhyaa. Igopʉ mojomorocʉgo árĩquerego ta, árĩpehreri igo bari asũborare Goãmʉ ya árĩburire opehocãmo, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Eropigʉ Goãmʉ wihiguere erã wiriacʉ̃ ĩagʉ yujugʉ erã buherã mera majagʉ õpa arĩpʉ: —Buhegʉ, ĩaque. I wihi Goãmʉ wihi maja wiri ʉtã mera erã iira wiri õari wiri ãhraa, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ĩgʉ eroparĩcʉ̃ Jesu werepʉ erãre: —I wihi maja wiri dohpaguere ĩaraa mʉa. I wihi árĩpehreri mari ĩara i ʉtã sã cohmopehrea waroca. Ne yujuye ʉtãye dujasome iri wiri maja, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Eropi Jesu Olivo waĩcʉdigʉ ʉtãgʉgue Goãmʉ wihi diaye maja árĩdigʉgue ejapʉ. Ero doapʉ. Ero Pedro, Santiago, Ñu, Andre mera erã seyaro árĩrã, erã ĩgʉre serẽpiñorã: ");
INSERT INTO des_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Wereque gʉare. ¿Dohpárĩcʉ̃ eropa warocuri mʉ arĩdiro dopa waro? ¿Pehreburinʉ coregãre dohpa wanʉgacʉ̃ ĩarãcuri gʉa? arĩ serẽpiñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu yʉhripʉ: —Õaro ii yuque mʉa. Eropirã gajirã erã gʉyarire peebiricãque mʉa. ");
INSERT INTO des_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bajarã masa “Cristo ãhraa yʉhʉ,” arĩ gʉyarã árĩrãcoma. Erã eropa gʉyacʉ̃ peerã masa bajarã Goãmʉ yare duhurãcoma. ");
INSERT INTO des_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mʉa pohrogã gajirã masa erã gamewejẽcʉ̃ peerãca. Eropirã yoarogue majarã erã sã erã gamewejẽcʉ̃ peebeorãca mʉa. Eropa peequererã ta ne irire wʉaro bʉjawere pepibiricãque. Eropa wamʉhtaroca. Eropa wacʉ̃ pehreburinʉ dʉhyaniroca dohpa. ");
INSERT INTO des_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Irisubure yuju yeba majarã gaji yeba majarã mera gamewejẽrãcoma. Eropirã yujugʉ opʉ yarã gajigʉ opʉ yarã mera gamewejẽrãcoma. Eropiro bajasuburi i yeba ñohmeroca. Eropirã bajarã masa oa mera sĩrirãcoma. Eropa ñero tariquerecʉ̃ i yeba majarãre tauro erã ñero tariboro dʉhyaa dohpa. Ñero tarinirãcoma dohpa. ");
INSERT INTO des_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Õpa wacʉ̃ ĩarã mʉa basi õaro iique. Gajirã mʉare ñeha ñero iidorerã orãcoma gajirã oparãre. Eropirã mʉa acawererã judio masa erã buheri wirigue sãre mʉare parãcoma. Eropirã macari majarã oparã pohrogue, erã tauro oparã pohrogue sãre aĩgãrãcoma mʉare mʉare dipuwaja moamorã. Eropirã erã mʉare erã pohrogue aĩgãcʉ̃ yaha buherire wererãca mʉa erã sãre. ");
INSERT INTO des_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Eropiro pehrerinʉ árĩboro core árĩpehrerãre õari buherire weresũroca. ");
INSERT INTO des_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eropirã mʉare dipuwaja moadorerã erã oparã pohrogue erã aĩgãcʉ̃, erã oparãre mʉa wereniguiburire wʉaro pepibiricãque. Mʉare erã serẽpicʉ̃ mʉa yʉhriburire Goãmʉ mera masirãca. Eropa masirã mʉa gamero wereniguisome mʉa. Espíritu Santopʉ mʉare wereniguicʉ̃ iigʉcumi. ");
INSERT INTO des_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Irisubure erã tĩrã erã pagʉ porãre Jesu yarã erã árĩcʉ̃ ĩha erãre wejẽdorerã oparãre wiarãcoma. Gajigʉpʉ ĩgʉ tĩgʉre wejẽdoregʉ oparãre wiagʉcumi. Eropi erã pagʉ sʉmarã erã porã Jesu yarã erã árĩcʉ̃ ĩha erãre wejẽdoregʉ oparãre wiarãcoma. Eropirã erã porãpʉ erã pagʉ sʉmarãre erã Jesu yarã árĩcʉ̃ ĩha wejẽdorerã wiarãcoma erã oparãre. ");
INSERT INTO des_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yʉre mʉa umupeora dipuwaja mʉare masa árĩpehrerã ĩhaturirãcoma. Eropa mʉare erã ñero iiquerecʉ̃ ta, mʉare erã ñero iirare yujuro bojerã, yʉre duhubiricʉ̃ Goãmʉ mʉare taugʉcumi. Eropigʉ ĩgʉ pohrogue mʉare opagʉcumi. ");
INSERT INTO des_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Eropirã ñetariagʉre Goãmʉ yare goroweogʉre ĩarãca mʉa. Goãmʉ wihigue ĩgʉ niguicʉ̃ ĩarãca. Ero ĩgʉre árĩbiricãro gahmea. Iribojegue Goãmʉ yare weremʉhtayugʉ Daniel ĩgʉre were gojañumi. (Irire buhegʉ peeporo). Ero ĩgʉ niguicʉ̃ ĩarã Judea yebague árĩrãpʉ ʉtã yucʉgue oma duhrigã waporo. ");
INSERT INTO des_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Irisubure masa ñero tarirãcoma. Eropirã yojaro mera waporo. Irisubure erã wiri weca maja pʉʉrigue árĩrã wihi pohecaguere erã yare aĩrã wabiricãporo. ");
INSERT INTO des_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Eropirã irisubure gajirã erã poerigue árĩrã erã ya suhrire wihigue árĩri suhrire aĩrã dujabiricãporo. ");
INSERT INTO des_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Irisubure nijiposã nome, erã porã mihrirãre oparã nome sã mojomorocʉrã nome dujarãcoma. ");
INSERT INTO des_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eropirã õpa serẽque Goãmʉre: “Puhiró árĩcʉ̃ eropa wabiricãporo,” arĩ serẽque ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Irinʉrire masa ñero tarirãcoma. I yebare ĩgʉ ĩhacũnugura pʉhrʉ masa erã ñero tariri árĩmʉriyoro. Iri eropa árĩquerecʉ̃ ta árĩpehreri pũriri erã ñero taridiro tauro masa ñetariaro tarirãcoma pehrerinʉ coregãre. Eropa ñero erã tarira pʉhrʉ dipaturi eropa ñero tarisome i yeba pare. ");
INSERT INTO des_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Eropigʉ Goãmʉ i ñero taririnʉrire bajamenʉrigã árĩcʉ̃ iigʉcumi. Ĩgʉ eropiibiricʉ̃ ne yujugʉ masʉ taribiribocumi. Eropigʉ ĩgʉ beyenirã erã tariborore bajamenʉrigã ñero taririre apigʉcumi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Irisubure gajirãre pee masi ĩaque. “Õho ãhrimi Cristo,” erã arĩcʉ̃ erãre peebiricãque. “Ero ãhrimi Cristo,” erã arĩcʉ̃ sãre peebiricãque. ");
INSERT INTO des_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Cristo ãhraa,” arĩ gʉyarã, “Goãmʉ yare weremʉhtarã ãhraa,” arĩ gʉyarã árĩcãrãcoma irisubure. Eropirã Goãmʉ ĩgʉ beyenirãre gʉyarã erã deyoro moarire ii ĩhmurãcoma. Goãmʉ yare erã cóãcʉ̃ iidiarã iirãcoma erã gʉyari masa. ");
INSERT INTO des_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ire árĩpehrerire wereyumʉhtaa mʉare iri eropa waboro core. Eropirã õaro pee masi yuque mʉa, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Eropa arĩtuhagʉ õpa arĩ werepʉ Jesu erãre: —Irinʉri erã ñero tarira pʉhrʉ, abe ʉmʉ majagʉ, ñami majagʉ sã boyo duhurãcoma. ");
INSERT INTO des_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Erã eropa wacʉ̃, necã dipuru yuhridijariroca. Eropiro ʉmaro maja sã yeba sã bʉrigã ñohmeroca. ");
INSERT INTO des_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Irisubu ta yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ arigʉca. Eropiro ʉmarogue yʉ turari mera yʉ gosesiriri mera ʉmaro maja imica weca i yebaguere yʉhʉ dujaricʉ̃ ĩarãcoma masa. ");
INSERT INTO des_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Eropigʉ yaharã anyuare árĩpehrero i yebaguere obeogʉra. Eropirã árĩpehreroguere waha yaharãre yʉ beyenirãre gameneorãcoma yʉ pohrogue. ");
INSERT INTO des_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Higueragʉ irigʉ waricʉrire ĩarã masia mʉa. Irigʉ yucʉgʉ pũricʉcʉ̃ ĩarã, “Bojori merogã dʉhyaa,” arĩ masia mʉa. ");
INSERT INTO des_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eropa ta irigʉ waro dopa ta masique mʉa. I árĩpehreri yʉ arĩra iri eropa wacʉ̃ ĩarã, “Cristo dujariboro merogã dʉhyaa,” arĩ masique mʉa. ");
INSERT INTO des_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Diaye ta arĩgʉ iiaa mʉare. Irisubu majarã erã sĩriboro core árĩpehreri yʉ arĩdiro dopa waroca. ");
INSERT INTO des_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ʉmaro i yeba sã pehrea waroca. Yʉ wereniguiripʉ ne pehresome. Árĩpehreri yʉ arĩdiro dopa ta eropa waha ojogorocʉroca. ");
INSERT INTO des_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Irinʉre yʉ dujariburinʉre, iri hora sãre ne masibeaa yʉhʉ. Anyua sã irire ne masibeama. Masa sã ne masibeama. Yʉ Pagʉ dihta yʉ dujariburinʉre masimi. ");
INSERT INTO des_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Mʉa sã irinʉre masibeaa. Eropirã õaro guñatura coreque. Goãmʉre serẽque. ");
INSERT INTO des_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Õpa coreque mʉa. I queoriñe mera irire mʉare buhegʉra. Wihi opʉpʉ yoarogue ĩgʉ curiro dopa ta ãhraa i. Ĩgʉ ĩgʉ waboro coregã ĩgʉ pohro majarãre ĩgʉ wihire coredoremi. Yujurãyerire ĩgʉ mohmerire apimi. Yujugʉre wihi disiporo ĩhadibudoregʉre õaro coredoremi ĩgʉ dujariborore. ");
INSERT INTO des_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eropigʉ wahámi. Ĩgʉ pohro majarãpʉ ĩgʉ dujariburinʉre ne masibeama. Ĩgʉ ñamica o ñami deco, cãreña ĩgʉ wererisubu o boyoro ĩgʉ aribocumi. Erã õaro ĩhacorebiricʉ̃ ĩgʉ guñaña mariro arigʉ erãre carĩrãre bocabocumi. Wihi opʉre erã ĩgʉ dujariburinʉre erã masibiro dopa ta mʉa sã yʉ dujariburinʉre masibeaa. Eropirã yʉre õaro guña coreque. ");
INSERT INTO des_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Guñaña mariro yʉ eraborore masirã, õaro guña coreque. Yʉ dorerire yahare eropa iiniguirã árĩque. Eropirã yʉre õaro coreque. ");
INSERT INTO des_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Eropigʉ mʉare yʉ arĩro dopa ta árĩpehrerãre eropa arãa. Õaro guña coreque, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Eropi irisubure Pascua bosenʉ core, bʉgabiriri pan erã baburinʉ core penʉ dʉhyayoro. Irisubure pahia oparã judio masare buherã mera, Jesure gʉyari mera erã ñeha erã wejẽburire game wereniguiñorã. ");
INSERT INTO des_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Bosenʉ árĩcʉ̃ ĩgʉre ñehabiricãrã. Masa gʉa ĩgʉre ñeacʉ̃ ĩarã gua gamenerenijarã gamequeãbocoma, arĩrã iiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Eropi Jesu sã Betaniague Simo cami boadi ya wihigue árĩñorã. Iri wihi erã baro watope, yujugo nomeopʉ alabastro mera iidirure poresuri nardo waĩcʉri dicʉdirure aĩrapo. Igo aĩrara wajacʉri árĩyoro. Eropigo igo irirure pãgũ Jesu dipuru weca pipeopo. ");
INSERT INTO des_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Igo eropiicʉ̃ ĩarã gajirã ũrugã gua wañorã. —¿Duhpigo igo eropa iisirimaacãri? ");
INSERT INTO des_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iri poresurire duaboañumo. Irire duago yuju bojori mohmeri waja wajataboañumo. Eropigo iri niyerure mojomorocʉrãre oboañumo igo, arĩñorã erã erã basi. Eropirã igore turiñorã. ");
INSERT INTO des_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Erã eroparĩcʉ̃ peegʉ Jesu erãre werepʉ: —¿Duhpirã eropa arĩri igore? Garibobiricãque igore. Igo yʉre õaro iimo. ");
INSERT INTO des_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mojomorocʉrã mʉa mera eropa árĩniguicãrãcoma. Eropirã mʉa gamero erãre omasia. Yʉpʉ i yebare mʉa mera eropa árĩniguicãsome. ");
INSERT INTO des_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Igo masiropẽ yʉre iiamo. Yʉre erã yaaboro core yʉ dʉpʉre amuyugo poresuri mera sũhumo yʉre. ");
INSERT INTO des_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Eropigʉ diaye mʉare arĩgʉ iiaa. Árĩpehrero i yebaguere, õari buherire erã wereroguere igo õpa iirare wererãcoma. Erã eropa arĩ werecʉ̃ peerã masa bajarã igo iirare guñarãcoma. ");
INSERT INTO des_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Irisubure Juda Iscariote doce buherã mera majagʉ pahia oparã pohro waha õpa arĩpʉ: —Yʉhʉ mʉare weregʉra Jesu ĩgʉ árĩrore mʉa ĩgʉre ñeacʉ̃, arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Eropirã pahia oparã irire peerã mucubiriñorã. —Mʉre niyerure orãra, arĩñorã erã Judare. Eropigʉ Juda Jesure ĩhaturirãre ĩgʉ erãre ĩhmuburire corenipʉ. ");
INSERT INTO des_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bʉgabiriri panre erã baburinʉ bosenʉ árĩnʉgarinʉ árĩyoro. Eropiro ovejare Pascua majagʉ árĩbure erã wejẽrinʉ árĩyoro. Irisubure ĩgʉ buherãpʉ serẽpiñorã Jesure: —¿Nohonogue Pascua bosenʉ mari baburire amudoregʉ obeori mʉhʉ gʉare? arĩñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Erã eroparĩcʉ̃ Jesupʉ perã ĩgʉ buherã mera majarãre obeopʉ. —Jerusaléngue waque. Erogue mʉa ejacʉ̃ deco sorobu tuhpeogʉ mʉare bocatĩrigʉcumi. Ĩgʉ bocatĩricʉ̃ ĩgʉ mera waque. ");
INSERT INTO des_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Eropa warã ĩgʉ sihu ñajari wihigue ejarã, wihi opʉre õpa arĩque: “‘¿Nohogue yʉhʉ, yʉ buherã mera Pascua maja barire bagʉcuri?’ arãmi gʉa opʉ,” arĩque wihi opʉre. ");
INSERT INTO des_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mʉa eroparĩcʉ̃ peegʉ ʉmaro maja taribure mari gameri árĩpehreri mera erã amura taribure ĩhmugʉcumi wihi opʉ. Erogue mari baburire iique, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ĩgʉ eroparĩcʉ̃ erã perã ĩgʉ buherã iri macague wañorã. Erã erogue erã ejacʉ̃ ĩgʉ arĩdiro dopa ta wayoro. Eropirã erã Pascua árĩcʉ̃ baburire amuñorã. ");
INSERT INTO des_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Eropi naidijaririsubu Jesu doce ĩgʉ buherã mera erã bari taribugue eroguere ejapʉ. ");
INSERT INTO des_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eropirã erã mesague erã ba doarisubu Jesu erãre werepʉ: —Diaye arĩgʉ iiaa mʉare. Yujugʉ mʉa mera majagʉ ta yʉ mera bagʉ ta yʉre ĩhaturirãre ĩhmugʉcumi, arĩ werepʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ĩgʉ eropa arĩ werecʉ̃ peerã erãpʉ bʉrigã bʉjawererã ĩgʉre serẽpinʉgañorã erã yujurãyeri. —¿Yʉhʉ ta árĩbocuri mʉre ĩhmubu? arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Mʉa yʉ doce buherã mera majagʉ ta ãhrimi ĩgʉ. Yʉ baripare yʉ mera yoso bagʉ ãhrimi yʉre ĩhaturirãre ĩhmubu. ");
INSERT INTO des_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Iribojegue erã yʉre arĩ gojadiro dopa ta yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ sĩrigʉca. Eropigʉ yʉre ĩhaturirãre ĩhmudigʉpʉ ñero tarigʉcumi. Ĩgʉpʉre ĩgʉ masa dehyoabiricʉ̃ õapũricãboya. Ñero taribiriboñumi, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eropigʉ Jesu erã mera barisubu panre aĩ Goãmʉre “Õhaa,” arĩ serẽpʉ. Eropa arĩgʉ ta irire nuha guerepʉ erãre õpa arĩgʉ: —Ire aĩ baque. I yʉ dʉpʉ ãhraa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Eropa arĩtuha ĩgʉ ihriripare aĩ, Goãmʉre “Õhaa,” arĩ serẽpʉ. Erãre ĩgʉ ocʉ̃ árĩpehrerã erã irire ihriñorã. ");
INSERT INTO des_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—I yʉ di ãhraa. Bajarã masa erã ñero iirare cóãbu sĩrigʉca. Eropigʉ yʉ dire cóãgʉca. Eropa sĩrigʉ Goãmʉ yʉ Pagʉ “Masare õaro iigʉra,” ĩgʉ arĩdiro ii ojogorocʉgʉca. ");
INSERT INTO des_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Diaye arĩgʉ iiaa mʉare. Goãmʉ ĩgʉ opʉ árĩrogue mama igui decore yʉ ihriboro core, õre igui decore dipaturi ihrinemosome yʉhʉ, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eropirã yujuñe erã Goãmʉ bayariñere bayatuha, ʉtãgʉ Olivo waĩcʉdigʉgue wañorã. ");
INSERT INTO des_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Erogue sihu ejagʉ Jesu erãre werepʉ: —Dohpagã ñami mʉa árĩpehrerã yʉre cóãrãca. Mʉa yʉre cóãborore õpa ta arĩ gojamʉhtañuma Goãmʉ yare erã gojarapũgue: “Ovejare ĩhadibugʉre erã wejẽcʉ̃ waro dopa ta iigʉca. Yʉ eropa iicʉ̃ oveja ĩgʉ yarã ĩgʉre cohãgã warãcoma,” arĩmi Goãmʉ, arĩ gojañuma. ");
INSERT INTO des_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Eropigʉ Goãmʉ ĩgʉ yʉre sĩridigʉre masura pʉhrʉ, mʉa core Galileague wamʉhtagʉca yʉhʉ, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ĩgʉ eroparĩcʉ̃ peegʉ Pedro õpa arĩripʉ: —Yʉ mera majarã árĩpehrerã erã mʉre cóãquerecʉ̃ yʉpʉ mʉre ne cóãsome, arĩpʉ Pedro ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu yʉhripʉ: —Diaye arĩgʉ iiaa mʉre. Dohpagã ñamire cãreña pesubu ĩgʉ wereboro core, mʉ ʉhresubu “Yʉhʉ Jesure masibeaa,” arĩgʉca mʉhʉ, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ĩgʉ eropa arĩquerecʉ̃ Pedro õpa arĩ turaro bʉsʉro yʉhripʉ: —Mʉ mera yʉre erã wejẽquerecʉ̃ ta ne mʉre cóãsome yʉhʉ, arĩ yʉhripʉ ĩgʉ Jesure. Pedro ĩgʉ eroparĩcʉ̃ peerã ĩgʉ mera majarã ĩgʉ arĩro dopa ta arĩriñorã erã sã. ");
INSERT INTO des_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Eropii erã Getsemaní waĩcʉri gorogue wañorã. Erogue ejagʉ õpa arĩpʉ Jesu: —Ohõ doayuque. Mʉa ohõ doaropẽ sohõgue Goãmʉre serẽniguigʉ wagʉ iiaa, arĩpʉ ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Eropa arĩtuha Pedrore, Santiagore, Ñure sihugãpʉ. Eropigʉ ñero güinʉgapʉ Jesu. Eropigʉ ñero sĩporãcʉpʉ. ");
INSERT INTO des_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Eropa ñero pepigʉ ĩgʉ mera majarãre ĩgʉ sihugãnirãre arĩpʉ: —Bʉrigã ñero yʉ sĩporãcʉca. Yʉre turaro pũriro dopa pepica yʉa. Sohõñari wanigʉ iiaa. Ohõ dujanique. Eropirã yʉ mera ta tʉyʉque mʉa sã, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Eropa arĩtuha ĩgʉ ero core mero wanemo, yebague mereja, Goãmʉre arĩpʉ: —Ahʉ, mʉhʉ árĩpehrerire iimasia. Eropigʉ yʉ ñero tariburire iidiabigʉ iibiricãque. Yʉ eropa arĩquerecʉ̃ ta yʉ gamero dopa iibita. Mʉ basi masia. Mʉ gamero dopa iique, arĩ serẽpʉ ĩgʉ Goãmʉre. ");
INSERT INTO des_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Eropa arĩtuha ʉrerã ĩgʉ buherã pohrogue eranijagʉ erã carĩ oyarãre ĩapʉ. Ĩha Pedrore arĩpʉ: —Simo, ¿carĩgʉ iiri mʉhʉ? ¿Yuju hora gohra yʉ mera tʉyʉtamubirari? ");
INSERT INTO des_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Õaro iique mʉa. Mʉa pepiri mera õarire iidiaraa mʉa. Mʉa seyaro irire iidiaquererã ta irire bocatĩubeaa. Eropirã Goãmʉre serẽniguicãque ñero mʉa iibiriboro dopa, arĩpʉ Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Eropa arĩ weretuha dipaturi waha, Goãmʉre serẽpʉ daja. Ĩgʉ ero core ĩgʉ arĩdiro dopa ta arĩ serẽpʉ daja. ");
INSERT INTO des_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Serẽtuha dipaturi erã pohrogue dujaripʉ daja. Eropa dujarigʉ carĩ oyarãre ĩapʉ daja. Wʉja pũritaricãyoro erãre. Eropirã erã Jesu “¿Duhpirã carĩri mʉa?” erãre arĩcʉ̃ yʉhrimasibiriñorã. ");
INSERT INTO des_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Eropigʉ dipaturi ĩgʉ Goãmʉre serẽra pʉhrʉ, erã pohro eraa erãre arĩpʉ: —¿Mʉa carĩrã soorã iiri dohpa? Iripẽta ãhraa. Sihajagãriro iiaa. Dohparagã yʉre masʉre Goãmʉ ĩgʉ obeodigʉre ñerãre erã oburisubu sihajaa. ");
INSERT INTO des_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wahgãque. Ina warã. Ĩaque. Yʉre ĩhaturirãre ĩhmubu ohõ ahrimi, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ĩgʉ eropa arĩ wereniguirisubu Juda doce buherã mera majagʉ erapʉ. Eropirã masa bajarã ñoserimijirire, yucʉre opanirã ĩgʉ mera yujuro mera erañorã. Erã pahia oparã, judio masare buherã, mʉrã sã erã obeonirã árĩñorã. ");
INSERT INTO des_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Negohrare Jesure ĩhaturirãre obu, õpa arĩtuhapʉ: —Yʉ ĩgʉ wayuporãre mimigʉ ĩgʉ ta árĩgʉcumi mʉa ñeabu. Ĩgʉre yʉ mimira pʉhrʉ ñeaque. Eropirã ĩgʉre õaro ñeaque ĩgʉ duhribiriboro dopa, arĩ wereserepʉ Judapʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Eropigʉ Jesu pohrogue eragʉ mata wa purumujupʉ: —Buhegʉ, ¿ãhriri mʉhʉ? arĩ ĩgʉre wayuporãre mimipʉ. ");
INSERT INTO des_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ĩgʉ eropiicʉ̃ ĩarã erã Jesure ñeañorã. ");
INSERT INTO des_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Erã eropiicʉ̃ ĩagʉ ĩgʉ pohrogue niguinirã mera majagʉ ĩgʉ matamijire tʉãwea aĩ, pahia opʉ pohro majagʉre ĩgʉ gamirore tabe corocãpʉ. ");
INSERT INTO des_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Eropigʉ Jesu õpa arĩpʉ: —¿Mʉa ñoserimijiri mera, yucʉ dʉcari mera arirã, yajari masʉre iro dopa mʉa yʉre ñearã arirã iiari? ");
INSERT INTO des_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ʉmʉri nʉcʉ Goãmʉ wihigue yʉhʉ mʉare buhedoacʉ̃, mʉa yʉre ne ñeabiribʉ. Dohpaguere mʉa yʉre eropa iirã i árĩpehreri Goãmʉ yare weremʉhtanirã erã arĩ gojadiro dopa ta mʉa yʉre iiaa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eropirã Jesu buherã árĩpehrerã ĩgʉre cohã omagã wañorã. ");
INSERT INTO des_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Eropigʉ yujugʉ mamʉ Jesu pʉhrʉ nʉrʉsiaripʉ. Omasiariñe dihta omadigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ĩgʉ sãre erã ñeadiacʉ̃ ĩgʉ ya omasiariñere cóãcã suhri marigʉ oma duhrigã wapʉ. ");
INSERT INTO des_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Eropii pahia opʉ pohrogue Jesure aĩ ejañorã. Iri wihiguere árĩpehrerã pahia oparã, mʉrã, judio masare buherã sã gamenereñorã. ");
INSERT INTO des_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Eropigʉ Pedropʉ Jesu pʉhrʉ yoarogue ĩha nʉrʉsiapʉ. Eropa nʉrʉsiagʉ ĩgʉ pahia opʉ Caifa waĩcʉgʉ ya wihire cãhmotara sãriro eja, iri sãriro pohecague ñajaa wapʉ. Eropigʉ ĩgʉ iri wihire corerã surara mera peame tʉro sõhma doapʉ. ");
INSERT INTO des_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eropirã pahia oparã, gajirã oparã mera gamenererã Jesure wejẽdoremorã, gʉyari mera erã ĩgʉre dipuwaja moaborore guñamaariñorã. Erã eropa weresãburire guña bocabiriñorã. ");
INSERT INTO des_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Masa bajarã ĩgʉre erã gamero weresãmaacãquererã erã weresãri diaye árĩbiriyoro. Gajigʉ gajiropa arĩ, gajigʉ sã gajiropa dihta arĩñorã. ");
INSERT INTO des_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Eropirã gajirã erogue eja, Jesure weresãñorã: ");
INSERT INTO des_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ihĩ õpa arĩmi: “Yʉhʉ i wihire masa iira wihire, Goãmʉ wihire cóãgʉra. Eropa cóãgʉ ʉhrenʉ pʉhrʉ iri wihire dipaturi iigʉra. Iri wihi masa erã iira wihi árĩsome,” ĩgʉ arĩcʉ̃ gʉa peebʉ, arĩ weresãñorã. ");
INSERT INTO des_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Erã eropa arĩ weresãquerecʉ̃ ta iri diaye árĩbiriyoro. Gajigʉ gajiropa arĩ gajigʉ sã gajiropa arĩpʉ. ");
INSERT INTO des_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Erã eropa arĩra pʉhrʉ pahia opʉ erã watope wahgãnʉgaja Jesure serẽpipʉ: —¿Oã mʉre weresãquerecʉ̃ ta erãre yʉhri gamebeari mʉhʉ? ¿Mʉre erã weresãrire duhpigʉ erãre yʉhri gamebeari mʉhʉ? arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ĩgʉ eroparĩcʉ̃ peequeregʉ ta Jesu eropa pepicãpʉ. Ĩgʉ eropa yʉhribiricʉ̃ ĩagʉ pahia opʉ ĩgʉre dipaturi serẽpipʉ daja: —¿Cristo ta ãhriri mʉhʉ? ¿Õagʉ Goãmʉ magʉ ta ãhriri mʉhʉ? arĩ serẽpipʉ daja ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ĩgʉ eropa arĩcʉ̃gue ta Jesu yʉhripʉ: —Ĩgʉ ta ãhraa. Eropirã yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉ Pagʉ turagʉ pohro, ĩgʉ diayepʉ yʉ doacʉ̃ ĩarãca mʉa. Eropirã ʉmaro maja imica watope yʉ aricʉ̃ sãre ĩarãca mʉa, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ĩgʉ eroparĩcʉ̃ ta pahia opʉpʉ ĩgʉ sañarañe suhrirore ĩgʉ basi yeguecãpʉ gajirãre “Guataricãmi,” arĩdoregʉ. —Ĩre weresãrãre gajirãre mari gamebeaa pare. ");
INSERT INTO des_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ĩgʉ basi Goãmʉre ĩgʉ ñero wereniguicʉ̃ peea mari. Eropirã ĩgʉ ñero iira dipuwajare masituhaa mari. ¿Eropirã dohpa iirãcuri mari ĩre dohpaguere? arĩpʉ pahia opʉ gajirã oparãre. —Ĩgʉ ñeri dipuwaja wejẽcãro gahmea, arĩ yʉhriñorã erã árĩpehrerã oparã. ");
INSERT INTO des_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eropirã erã mera majarã Jesure disico ehosũ ĩgʉ cuirire diricãhmotacã, ĩgʉre pañorã. Patuha õpa arĩñorã ĩgʉre: —¿Noa mʉre pari? Ĩabiriqueregʉ gʉare wereque, arĩ wereyañorã erã. Eropirã opʉ yarã surara Jesure pañorã. ");
INSERT INTO des_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Eropigʉ Pedro iri wihi maja sãriro pohecague ĩgʉ árĩcʉ̃ pahia opʉ pohro majago erapo. ");
INSERT INTO des_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Igo Pedro ĩgʉ sõhmacʉ̃ ĩago ĩgʉ dihtare ĩhaniguipo. —Nazare majagʉ mera Jesu mera mʉ sã ãhrabʉ, arĩpo igo Pedrore. ");
INSERT INTO des_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Igo eroparĩcʉ̃ peegʉ Pedropʉ õpa arĩpʉ: —¿Dohpa arĩmaacãgo iiri mʉhʉ? Mʉ arĩgʉre ne masibeaa yʉhʉ, arĩpʉ Pedro igore. Igo eropa arĩra pʉhrʉ Pedro iri pʉʉ maja sãriro disiporo pohrogue wapʉ. Eropigʉ ĩgʉ ero niguicʉ̃ cãreña werepʉ. ");
INSERT INTO des_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ero ĩgʉ árĩcʉ̃ ĩago dipaturi werepo daja ero árĩrãre. —Ihĩ Jesu buherã mera majagʉ ãhrimi, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Igo eroparĩcʉ̃ peegʉ Pedro dipaturi arĩpʉ daja. —Ĩgʉre masibeaa yʉhʉ, arĩpʉ daja. Eropii merogã pʉhrʉ ta ero niguirã Pedrore õpa arĩñorã daja: —Diaye ta ãhraa. Mʉhʉ Galilea majagʉ ãhraa. Eropigʉ ĩgʉ mera majagʉ ta ãhraa mʉhʉ, arĩñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Erã eroparĩcʉ̃ peegʉ ĩgʉ erãre yʉhripʉ: —Diaye ta Goãmʉ mera arĩgʉ iiaa mʉare. Yʉhʉ diaye arĩbiricʉ̃ Goãmʉ yʉre dipuwaja moaporo. Ĩgʉre mʉa arĩgʉre ne masibeaa yʉhʉ, arĩ yʉhripʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ĩgʉ eroparĩcʉ̃ ta cãreña werepʉ daja. Ĩgʉ werecʉ̃ peegʉ Jesu ĩgʉ arĩrare guñapʉ. “Cãreña pesubu ĩgʉ wereboro core mʉhʉ yʉre ʉhresubu ‘Jesure masibeaa,’ arĩgʉca mʉhʉ,” Jesu ĩgʉ eropa arĩrare guñapʉ Pedro. Eropa guñagʉ turaro orepʉ. ");
INSERT INTO des_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Eropirã boyorogue mʉrã, pahia oparã, judio masare buherã, árĩpehrerã gajirã oparã mera gamenere weretamuñorã erã Jesure iiburire masimorã. Erã basi wereniguituha, Jesure dihri aĩgã Pilato waĩcʉgʉre opʉre oñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Erã aĩ ejacʉ̃ ĩagʉ Pilato ĩgʉre serẽpipʉ: —¿Diaye ta judio masa opʉ ãhriri mʉhʉ? arĩ serẽpipʉ ĩgʉ Jesure. —Mʉ arĩro dopa ta ĩgʉ ta ãhraa, arĩ yʉhripʉ ĩgʉre Jesu. ");
INSERT INTO des_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eropirã pahia oparã baja weresãñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Erã eropa arĩ weresãcʉ̃ peegʉ dipaturi serẽpipʉ daja ĩgʉre. —Oã mʉre baja weresãrã iima. ¿Erã eropa arĩ weresãquerecʉ̃ yʉhribeari mʉhʉ? arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ĩgʉ eroparĩcʉ̃ Jesu yʉhribiripʉ. Eropigʉ Pilato ĩhamaria wapʉ. ");
INSERT INTO des_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bojori nʉcʉ Pascua bosenʉ árĩcʉ̃ peresu árĩdigʉre yujugʉre masa “Ĩgʉre wiuque,” erã arĩgʉre Pilato eropa wiubasamʉripʉ. ");
INSERT INTO des_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Irisubure Barrabá waĩcʉgʉ peresugue árĩpʉ. Ĩgʉ oparãre cóãdiarã mera majagʉ masare wejẽrã mera majagʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eropirã masa bajarã Pilato pohrogue eja, ĩgʉre serẽñorã: —Bojori nʉcʉ mʉ iidiro dopa ta iique daja gʉare. Yujugʉ peresugue árĩgʉre gʉare wiubasaque daja, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Erã eroparĩcʉ̃ Pilato erãre serẽpiñapʉ: —¿Mʉa yagʉ opʉre judio masa opʉre wiucuri? arĩ serẽpipʉ Pilato erãre Jesure wiudianijagʉ. ");
INSERT INTO des_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jesure masa erã mahicʉ̃ ĩarã pahia oparã Jesure ĩhaturirã árĩñorã. Eropa ĩhaturirã ĩgʉre wejẽdorerã oñorã Pilatore. Erã ĩhaturirire masigʉ Pilato Jesure wiudiaripʉ. ");
INSERT INTO des_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ĩgʉ eropa wiudiaquerecʉ̃ ta pahia oparã Jesu mera masare guacʉ̃ iiñorã. Õpa arĩdoreñorã erãre: “Barrabáre wiuque. Jesure wejẽdoreque,” Pilatore arĩdoreñorã masare. ");
INSERT INTO des_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Eropigʉ Pilatore Barrabáre erã wiudorera pʉhrʉ Pilato erãre serẽpipʉ daja: —¿Ihĩ “judio masa opʉ” mʉa arĩgʉpʉre duhpigʉcuri yʉhʉ? arĩ serẽpipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Crusague pabia wejẽque ĩgʉre, arĩ gaguiniguiñorã masa. ");
INSERT INTO des_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Ñehenore ñerire iiari ihĩ mʉa eropa arĩ gaguiniguicʉ̃? arĩpʉ ĩgʉ. Ĩgʉ eroparĩcʉ̃ peerã erã gaguiniguinemoñorã daja. —Crusague pabia wejẽque ĩgʉre, arĩñorã daja. ");
INSERT INTO des_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Erã eropa arĩ gaguiniguicʉ̃ peegʉ Pilato Barrabáre wiudorepʉ masare mucubiricʉ̃ iidiagʉ. Eropigʉ Jesure yuradari mera tãradore, crusague pabia wejẽdoregʉ wiapʉ surarare. ");
INSERT INTO des_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Eropi surara ĩgʉ opʉ Pilato wihigue pretorio waĩcʉri wihigue Jesure aĩ ejañorã. Ĩgʉre aĩ ejatuha erã gajirã surara erã mera majarãre gameneremorã sihubeoñorã. ");
INSERT INTO des_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Eropirã erã opʉ ya suhriro dopa bejariñere Jesure sãñorã. Eropa sãtuha pora berore ii ĩgʉ dipuru duhpeoñorã. ");
INSERT INTO des_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eropiituha õpa arĩ wereyañorã erã ĩgʉre: —Umupeorã arique. Judio masa opʉ õaro árĩporo, arĩ wereyañorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eropirã ĩgʉ dipurure yucʉgʉ mera padiu, ĩgʉre disico ehosũ, gʉhyadiaro ĩaro dopa ta mereja ĩgʉre ii birañorã. ");
INSERT INTO des_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eropi ĩgʉre wereya biratuha, erã sãra suhrirore tuwea aĩ, ĩgʉ ya suhriropʉre ĩgʉre sãñorã daja. Eropirã ĩgʉre crusague pabia wejẽmorã aĩ wiria wañorã. ");
INSERT INTO des_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ĩgʉre aĩgã, Simo Cirene majagʉ pohegue árĩdigʉ erã pohro ĩgʉ eracʉ̃ ĩarã surarapʉ ĩgʉre Jesu ĩgʉ coãra crusare coãgãbasadoreñorã. Alejandro, Rufo sã pagʉ árĩpʉ Simopʉ. ");
INSERT INTO des_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Waha Gólgota waĩcʉrogue ejañorã. Gólgota arĩro mari ya mera “dipu pero” arĩro iiaa. ");
INSERT INTO des_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eropirã vinore sʉĩri deco mera erã morera decore Jesure oriñorã. Iri decore ihribiripʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eropirã ĩgʉ suhrire tuwea aĩra pʉhrʉ crusague Jesure pabiañorã. Erã pabiatuhaja ĩgʉ suhri mʉrare “¿Noa yañe árĩrocuri iñe?” arĩ game deabirañorã. ");
INSERT INTO des_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesure erã pabiara pʉhrʉ ʉhre hora dʉhyayoro goeri boje ejaboro. ");
INSERT INTO des_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Eropirã crusague õpa arĩ gojarapũre pabia duhtuñorã. “Ihĩ judio masa opʉ ãhrimi,” erã arĩ gojaturapũ árĩyoro. Iri erã gojaturapũ Jesure erã weresãra árĩyoro. ");
INSERT INTO des_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Eropirã perã yajari mʉrare Jesu pohro gajimijirigue crusarigue erã pabiatuñorã erã sãre. Yujugʉ ĩgʉ diayepʉ, gajigʉre ĩgʉ copʉ pabiatuñorã. ");
INSERT INTO des_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Erã eropiicʉ̃ iribojegue Goãmʉ yare weremʉhtanirã gojadiro dopa ta eropa wayoro. Õpa arĩ gojayuñuma: “‘Dorerire tarinʉgarã mera majagʉ ãhrimi,’ arĩ pepima masa ĩgʉre,” arĩ gojañuma iribojeguere. ");
INSERT INTO des_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Eropirã crusari pohro tarigãrã Jesure ĩha, erã dipurure yurerã, ĩgʉre ñero arĩ wereniguiñorã. —Mʉhʉ ta “Goãmʉ wihire cohã, ʉhrenʉ pʉhrʉ iri wihire amugʉra daja,” arĩdigʉ árĩribʉ mʉhʉ. ");
INSERT INTO des_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mʉ basi dijaque. Eropigʉ mʉ basi tarique. Eropigʉ tari weregʉca mʉhʉ, arĩ wereyañorã erã. ");
INSERT INTO des_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Erã iro dopa ta pahia oparã sã judio masare buherã sã ĩgʉre eropa wereyañorã. Eropa arĩ wereyarã õpa arĩñorã erã basi: —Ĩgʉ gajirãre taudigʉ árĩqueregʉ ta ĩgʉ basi tarimasibeami. ");
INSERT INTO des_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Israe masa opʉ ãhraa,” arĩrimi ĩgʉ. Eropirã ĩgʉ basi dijaricʉ̃ ĩarã ĩgʉre umupeorãca, arĩ wereyañorã. Yajari mʉra sã ĩgʉ pohro erã pabianirã eropa ta ĩgʉre ñero arĩ wereyañorã. ");
INSERT INTO des_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Eropi goeri boje árĩcʉ̃ ʉhre hora gohra árĩpehrerogue naitĩa wayoro. ");
INSERT INTO des_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Eropigʉ irisubure ero naitĩarisubu Jesu turaro gaguiniguipʉ: —Eloi, Eloi, ¿lama sabactani? arĩpʉ ĩgʉ. Ire arĩgʉ mari ya mera õpa arĩgʉ iipʉ: “Yʉ Goãmʉ, yʉ Goãmʉ, ¿duhpigʉ yʉre cohãri mʉhʉ?” arĩgʉ iipʉ ĩgʉ Pagʉre. ");
INSERT INTO des_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ĩgʉ eroparĩcʉ̃ peenirã yujurãyeri ero niguinirã õpa arĩriñorã: —Goãmʉ yare weremʉhtadigʉre Eliare sihugʉ iicumi, arĩriñorã erã. ");
INSERT INTO des_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eropigʉ yujugʉ erã mera majagʉ mimi aĩri yʉsʉ mera vino sʉĩrire yosotuha aĩ omagã, yucʉgʉ ojogoro diritu, Jesure simujuripʉ. Eropa iigʉ õpa arĩpʉ: —Corenique. Elia ĩgʉre itamucʉ̃ ĩanirã dohpa mari, arĩpʉ ĩgʉ gajirãre. ");
INSERT INTO des_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ĩgʉ eropa arĩra pʉhrʉ dipaturi Jesu turaro gaguinigui sĩria wapʉ. ");
INSERT INTO des_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ĩgʉ sĩricʉ̃ ta Goãmʉ wihi majañe suhriro ero erã cãhmotara suhriro gasiro deco mera yehguea wayoro. ");
INSERT INTO des_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ĩgʉ eropa sĩricʉ̃ ĩagʉ surara opʉ Jesu pohro niguidigʉ õpa arĩpʉ: —Diaye ta ãhraa. Ihĩ Goãmʉ magʉ ta ãhrañumi, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Eropirã yoarogue ĩhaniguinirã nome sã árĩñorã Jesure ĩhaniguirã. Erã nome mera María Magdalena árĩpo. Gajigo María waĩcʉgo sã árĩpo. Igopʉ José ĩgʉ pagʉ magʉ Santiago erã pago árĩpo. Gajigo Salomé waĩcʉgo árĩpo. ");
INSERT INTO des_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Erã nome Jesu yare õaro peerã nome árĩñorã. Erã Galilea yeba ĩgʉ árĩcʉ̃ ĩgʉre itamumʉriñorã. Erã nome mera bajarã gajirã nome sã árĩñorã. Jerusaléngue Jesu mera arinirã nome árĩñorã. ");
INSERT INTO des_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Eropii irinʉ ĩgʉ sĩriranʉ Sabado core judio masa soorinʉ core majanʉ árĩyoro. Eropiro Pascua maja árĩburire erã amurinʉ árĩyoro. Irinʉ ñamica árĩcʉ̃ José Arimatea majagʉ güiro mariro Pilato pohrogue ejapʉ. Jesu dʉpʉre serẽgʉ ejapʉ. José oparã mera majagʉ oparã erã umupeodigʉ árĩpʉ. Eropigʉ Goãmʉ ĩgʉ opʉ árĩburire coregʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Eropigʉ José Jesu dʉpʉ mʉrarore ĩgʉ Pilatore serẽcʉ̃ Pilatopʉ peegʉ, pee ʉca wapʉ. “¿Jesu sĩrituhayuri?” arĩ pepipʉ. Eropigʉ surara opʉre sihu õpa arĩpʉ ĩgʉre: —¿Jesu sĩria wayuri? arĩ serẽpipʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ĩgʉ eroparĩcʉ̃ surara opʉ yʉhripʉ: —Sĩria wami, arĩpʉ. Ĩgʉ eroparĩcʉ̃ Pilato Josére odorepʉ Jesu dʉpʉ mʉrʉre. ");
INSERT INTO des_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ĩgʉ odorera pʉhrʉ José õariñe suhrirore asũpʉ. Asũtuha, Jesu dʉpʉre aĩ diju, iri suhriro mera omapʉ. Omatuhaja erã ʉtãyegue seara gobegue ĩgʉ dʉpʉre apipʉ. Apituha iri gobe pohro árĩriye ʉtãye wʉariyere taragã tubiha nugucãpʉ. ");
INSERT INTO des_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Eropirã María Magdalena, María José pago Jesure ĩgʉ apidirore ĩañorã. ");
INSERT INTO des_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Eropirã erã soorinʉ Sabadonʉ taricʉ̃ María Magdalena, María Santiago pago, Salomé mera poresurire asũñorã Jesu dʉpʉre sũmorã. ");
INSERT INTO des_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Eropirã Domingo boyorogã Jesure erã yaara gobegue wañorã erã. ");
INSERT INTO des_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Warã õpa arĩñorã: —¿Iri gobere erã biharayere noa marire pãgũbasarãcuri mari ñajaborore? arĩñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iri gobegue ejarã iri gobere biharayere ʉtãyere erã pãgũ nugurayere ĩañorã. Wʉariye ʉtãye árĩyoro. ");
INSERT INTO des_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eropa ĩarã iri gobeguere ñajañorã. Eropa ñajajarã mamʉre diayepʉ doagʉre boreri suhricʉgʉre ĩañorã. Ĩarã ĩha ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Erã ʉcacʉ̃ õpa arĩpʉ ĩgʉ: —Ʉcabiricãque. Crusague erã pabiadigʉre Jesu Nazare majagʉre amaraa mʉa. Masa mʉriatuhami. Õre marimi. Erã ĩgʉ dʉpʉre apidirore ĩaque. Ĩatuhaja ĩgʉ buherãre Pedro sãre õpa arĩ wererã waque. ");
INSERT INTO des_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Ĩgʉ mʉa core Galileague wamʉhtagʉcumi. Erogue ĩgʉre ĩarãca mʉa. Ero ĩgʉ arĩdiro dopa ta mʉa ĩgʉre ĩarãca,” arĩ wererã waque, arĩ werepʉ mamʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ĩgʉ eroparĩcʉ̃ erã güi, naragã, masa gobe pohro árĩnirã omagã wiria wañorã. Eropa güirã gajirãre werebiriñorã. ");
INSERT INTO des_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Eropii Domingo árĩcʉ̃ Jesu ĩgʉ masa mʉriara pʉhrʉ María Magdalenare dehyoamʉhtapʉ. Igo siete watẽa ñajasũdigo árĩpo. Jesu ĩgʉ sĩriboro core igore watẽare cóãpʉ. Eropigʉ igopʉre dehyoamʉhtapʉ ĩgʉ ĩgʉ masa mʉriara pʉhrʉre. ");
INSERT INTO des_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesu igore dehyoara pʉhrʉ igo ĩgʉ mera majarãre werego wapo. Erã ĩgʉ sĩrirare bʉjawererã orerã árĩñorã. ");
INSERT INTO des_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Cristo ojocariami. Ĩgʉre ĩabʉ,” igo arĩquerecʉ̃ peediabiriñorã. ");
INSERT INTO des_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pʉhrʉ perã Jesu buherã mera majarã campogue wiri marirogue wañorã. Erã eropa waniguicʉ̃ Jesu gajiropa bejagʉ gʉhyaro dehyoapʉ erãre. ");
INSERT INTO des_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ĩgʉ eropa dehyoara pʉhrʉ, waha gajirã Jesu yarãre wereñorã. “Gʉa Jesure ĩabʉ,” erã arĩ werecʉ̃ erã peediabiriñorã daja. ");
INSERT INTO des_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pʉhrʉ once ĩgʉ buherã mesa pohrogue erã doacʉ̃ erãre dehyoapʉ ĩgʉ. Eropigʉ ĩgʉre ĩanirã “Jesu masa mʉriapʉ,” arĩ erã werecʉ̃ peediabirirare erãre turipʉ Jesu. Ĩgʉre õaro umupeobiriri dipuwaja erãre turipʉ. ");
INSERT INTO des_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Erãre turituha õpa arĩpʉ: —I yeba árĩpehreroguere masare árĩpehrerãre õari buherire buherã waque. ");
INSERT INTO des_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yʉre umupeorãre erã waĩyenirãre erã peamegue wabonirãre taugʉcumi Goãmʉ. Eropirã yʉre umupeobirã Goãmʉ ĩgʉ dipuwaja moamorã, peamegue wamorã árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Eropirã yʉre umupeorã yʉ turari mera õpa iirãcoma: Yʉ turari mera watẽa masare ñajasũnirãre cóãrãcoma. Eropirã mama disirore wereniguirãcoma. ");
INSERT INTO des_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Eropirã añare ñeacʉ̃, árĩpehreri nimare erã ihricʉ̃ pũrisome erãre. Eropirã dorecʉrã weca erã mojotorire erã mohmepi ñeacʉ̃ õarã warãcoma, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Eropa arĩ weretuha mari Opʉ Jesu ʉmarogue mʉria wapʉ. Erogue ejagʉ Goãmʉ diayepʉ doapʉ ĩgʉ mera opʉ árĩgʉ. ");
INSERT INTO des_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eropirã ĩgʉ buherãpʉ árĩpehreroguere õari buherire Goãmʉ masare ĩgʉ tauburire buherã wañorã. Erã eropa buhecʉ̃ mari Opʉ erãre itamupʉ. Deyoro moarire ĩgʉ turari mera iimasicʉ̃ iipʉ erãre masare ĩgʉ ya buherire peedoregʉ. “Eropa ta árĩporo,” arãa yʉhʉ. Iripẽta ãhraa.");
INSERT INTO des_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Opʉ Teófilo, mʉre ipũre gojabeogʉ iiaa yʉhʉ. Jesu gʉa mera árĩnigʉ ĩgʉ iirare gajirã gojanʉgamʉhtatuhanirã árĩma. Negohraguere Jesure ĩanirã, ĩgʉ yare buhenirã erã arĩ werediro dopa ta gajirã irire gojanʉgamʉhtatuhanirã árĩma. ");
INSERT INTO des_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eropigʉ i árĩpehrerire õaro masipehodiagʉ yʉ sã erã arĩ wererare buhebʉ. Eropigʉ yʉ sã irire õaro gojadiaa mʉa buheburi árĩburire. ");
INSERT INTO des_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jesu yare buherã mʉre weretuhanirã árĩma. “Iri queoro ãhraa,” õaro mʉ arĩ masiborore ipũre mʉre gojabeogʉ iiaa. ");
INSERT INTO des_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herode Judea yeba majarã opʉ ĩgʉ árĩcʉ̃, Zacaría waĩcʉgʉpʉ pahi árĩpʉ. Zacaría ya curupʉ pahia curu Abías ya curu árĩyoro. Zacaría marapo sã pahi Aarón mʉrʉ pãrameo árĩturiagogue árĩpo. Igopʉ Elisabet waĩcʉgo árĩpo. ");
INSERT INTO des_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Erã perã Goãmʉ dorerire iipehorã erã árĩcʉ̃ ĩagʉ, “Ʉmʉri nʉcʉ õarire iirã ãhrima,” arĩ pepidi árĩmi Goãmʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet ne porã marigo árĩpo. Eropigo igo Zacaría mera porã mari muñucãpo. ");
INSERT INTO des_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pahia Goãmʉ wihigue Goãmʉ ya umupeoburire mohmerã ʉmʉri nʉcʉ erã gohrotomʉriñorã. “Zacaría ya curu majarã dohpaguere iiporo,” erã arĩra pʉhrʉ ĩgʉ pahia erã iidiro dopa ta Goãmʉ ya umupeoburire mohmegʉ arigʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pahia erã iiguaro dopa ta inciensore soebure beyerã irisubure Zacaríare beyeñorã. Eropigʉ ĩgʉ Goãmʉ wihigue ñajaa wapʉ soegʉ wagʉ. ");
INSERT INTO des_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Goãmʉ wihi pohecague ĩgʉ árĩrisubu, inciensore ĩgʉ soerisubu árĩpehrerã masapʉ disiporogue Goãmʉ mera serẽniguiñorã. ");
INSERT INTO des_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Irisubure Goãmʉ yagʉ anyu incienso soero diayepʉ dehyoanʉgajapʉ Zacaríare. ");
INSERT INTO des_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ĩgʉ anyu eropa dehyoacʉ̃ ĩagʉ Zacaría ĩgʉre ĩha, ʉca wa, güia wapʉ. ");
INSERT INTO des_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Eropa ĩgʉ güicʉ̃ ĩagʉ anyu ĩgʉre werepʉ: —Zacaría, güibita. Goãmʉ mʉ serẽrare peeami. Eropigo mʉ marapo Elisabet porãcʉgocumo. Mʉ magʉ masa dehyoagʉcumi. Ĩgʉ eropa dehyoacʉ̃ Ñu waĩyeque ĩgʉgãre. ");
INSERT INTO des_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","17","“Ĩgʉ õagʉ ãhrimi. Turagʉ ãhrimi,” arĩ pepigʉcumi Goãmʉ mʉ magʉre. Ĩgʉ masa dehyoara pʉhrʉ vinore, siburire ihrisome. Eropigʉ ĩgʉ, ĩgʉ masa dehyoara pʉhrʉ ta Espíritu Santo árĩri mera õaro turagʉ árĩgʉcumi ĩgʉ. Eropigʉ bajarã Israe masare Goãmʉ mari Opʉre õaro gamecʉ̃ iigʉcumi ĩgʉ. Goãmʉ yare buhegʉ Elia Goãmʉ yare weremʉhtadigʉ mari Opʉ ariborore ĩgʉ buhediro dopa ta Goãmʉ ĩgʉ turari mera mʉ magʉ sã buhegʉcumi. Eropa buhegʉ erã pagʉ sʉmarã erã porã mera erã õaro game mahi árĩcʉ̃ iigʉcumi. Eropigʉ dorerire tarinʉgarãre õaro erã umupeori mera yʉhricʉ̃ iigʉcumi. Eropa buhegʉ mari Opʉ ariboro core ĩgʉ yarã árĩmorãre amuyugʉcumi ĩgʉ. Eropigʉ ĩgʉ masa dehyoara pʉhrʉ mʉhʉ mucubirigʉca. Gajirã sã bajarã mucubirirãcoma, arĩpʉ anyu Zacaríare. ");
INSERT INTO des_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ĩgʉ eroparĩcʉ̃ peegʉ Zacaríapʉ serẽpipʉ anyure. —Yʉhʉ, yʉ marapo mera gʉa mʉrã ãhraa. ¿Eropigʉ mʉ arĩra diaye árĩcʉ̃ dohpa masigʉcuri yʉhʉ? arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ĩgʉ eroparĩcʉ̃ anyupʉ ĩgʉre werepʉ: —Yʉhʉ Gabrie waĩcʉgʉ ãhraa. Goãmʉ pohro árĩgʉ ãhraa yʉhʉ. Goãmʉ i õari querere weredoregʉ, mʉ pohro yʉre obeoami. Yʉ werediro dopa ta diaye waroca. ");
INSERT INTO des_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yʉ eropa arĩquerecʉ̃ ta yʉre peediabeaa mʉhʉ. Eropigʉ mʉhʉ dohpaguere wereniguibigʉ dujagʉca. Mʉ magʉ ĩgʉ masa dehyoara pʉhrʉ wereniguigʉca daja, arĩpʉ anyu Zacaríare. ");
INSERT INTO des_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Disiporogue masa Zacaríare corerã iiñorã. “¿Duhpigʉ ĩgʉ Goãmʉ wihigue árĩgʉ mata wiriribeari?” arĩ, corerã iiñorã masa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eropigʉ ĩgʉ i wihigue árĩdigʉ wiria, erã mera wereniguimasibiripʉ. “Goãmʉ ĩgʉre dehyoacumi,” arĩ pepi, masiñorã erã. Eropigʉ ĩgʉ wereniguimasibigʉ árĩgʉ ĩgʉ mojotori mera masare wereniguipʉ. ");
INSERT INTO des_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Goãmʉ wihi ĩgʉ mohmeri pehrecʉ̃, ĩgʉ dujaa wapʉ ĩgʉ ya wihigue. ");
INSERT INTO des_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pʉhrʉ ĩgʉ marapo Elisabet majigʉre ne bocagãrigo iipo. Eropigo igo cinco aberi gohra masa pohro wabiripo. ");
INSERT INTO des_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Õpa arĩpo igo: “Dohpaguere yʉre Goãmʉ itamumi pare. Yʉ porã marigo árĩgo gʉhyasĩuro taribʉ yʉhʉ. Goãmʉ yʉ porã maririre cohãmi yʉre,” arĩ pepipo igo. ");
INSERT INTO des_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabet seis aberi igo nijipo árĩra pʉhrʉ, Goãmʉpʉ anyure Gabrie waĩcʉgʉre nómeo õago pohrogue obeopʉ. Igo Nazare waĩcʉri maca Galilea árĩri yeba árĩpo. Eropigo igo María waĩcʉgo José mera mojoto diribo árĩpo. Josépʉ iribojegue majagʉ mʉrʉ Davi mʉrʉ pãrami árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","María pohrogue ejagʉ anyu werepʉ: —María, ¿ãhriri mʉhʉ? Goãmʉ mʉ mera árĩgʉ ãhrimi. Eropigʉ mʉre õaro iigʉ iimi. Árĩpehrerã nome gajirã nome tauro õaro iimi mʉre, arĩpʉ anyu igore. ");
INSERT INTO des_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ĩgʉ eroparĩcʉ̃ peego, igo turaro guña pepipo. Anyu ĩgʉ wererare pepigo “¿Dohpa arĩgʉ yʉre eropa arĩcuri?” arĩ guñapo igo. ");
INSERT INTO des_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Igo eropa arĩ guñacʉ̃ ĩagʉ anyu werepʉ igore: —María, mʉre Goãmʉ turaro mahimi. Eropigo güibita. ");
INSERT INTO des_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Peeque. Majigʉre bocagoca mʉhʉ. Eropigʉ mʉ magʉ masa dehyoagʉcumi. Ĩgʉre Jesu waĩyegoca. ");
INSERT INTO des_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Ĩgʉ turatariagʉ árĩgʉcumi. Eropirã ĩgʉre “Goãmʉ ʉmaro majagʉ magʉ ãhrimi,” arĩrãcoma masa. Eropigʉ mʉ magʉ ñecʉ mʉrʉgue Davi mʉrʉ Israe masa erã opʉ ĩgʉ árĩdiro dopa ta mʉ magʉ sãre apigʉcumi Goãmʉ. Eropigʉ árĩpehrerinʉri ĩgʉ Israe masare doregʉcumi. Eropiro ĩgʉ opʉ árĩripʉ ne pehresome, arĩpʉ anyu. ");
INSERT INTO des_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ĩgʉ eroparĩcʉ̃ Maríapʉ serẽpipo: —¿Duhpi ʉmʉ mera árĩbiriquerego ta porãcʉbocuri yʉhʉ? arĩpo igo. ");
INSERT INTO des_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Igo eroparĩcʉ̃ anyupʉ werepʉ: —Espíritu Santo mʉre porãcʉcʉ̃ iigʉcumi. Eropiro Goãmʉ ĩgʉ turari imica curu iro dopa ta cãhmotaroca mʉre. Eropirã “Goãmʉ magʉ, ñerire iibigʉ ãhrimi,” arĩrãcoma masa mʉ magʉre. ");
INSERT INTO des_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Goãmʉ árĩpehrerire iimasimi. Eropigo mʉ acawerego Elisabet bʉro árĩquerego ta majigʉre bocámo igo sã. Igo porãcʉgocumo ʉmʉgãre. Masa igore “Porã marigo ãhrimo,” erã arĩdigo bʉro dohpaguere seis aberi wahaa igo majigʉre bocara pʉhrʉ, arĩpʉ anyu Maríare. ");
INSERT INTO des_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ĩgʉ eroparĩcʉ̃ María yʉhripo: —Yʉre peeque. Mari Opʉ ĩgʉ pohro majago ãhraa yʉhʉ. Mʉ arĩdiro dopa ta yʉre eropa waporo, arĩpo igo. Igo eropa arĩra pʉhrʉ anyu waha wapʉ. ");
INSERT INTO des_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Irinʉrire María ʉtã yucʉ árĩri yebague Judea yeba árĩri macague ʉmʉdiaro waha wapo. ");
INSERT INTO des_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Erogue ejago Zacaría ya wihi ñaja, “¿Ahriri?” arĩpo igo Elisabere. ");
INSERT INTO des_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Igo eroparĩcʉ̃ Elisabet igo peecʉ̃ ta, igo magʉpʉ niji suhrirogue árĩdigʉ ñohmepʉ. Elisabet Espíritu Santo árĩri mera õaro pepigo wapo. ");
INSERT INTO des_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Eropigo turaro mucubiriri mera wereniguipo. —Árĩpehrerã nome tauro õaro iimi Goãmʉ mʉre. Mʉ magʉ sãre õaro iimi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cue, yʉ Opʉ pago yʉ pohro aricʉ̃ õaro iimi yʉre Goãmʉ. ");
INSERT INTO des_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mʉhʉ yʉre “¿Ãhriri?” arĩcʉ̃, yʉ magʉpʉ niji suhrirogue árĩgʉ mucubiriri mera ñohmeacumi yʉre. ");
INSERT INTO des_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","“Goãmʉ ĩgʉ arĩdiro dopa ta iipehogʉcumi,” arĩgo mucubirigo ãhraa mʉhʉ, arĩpo Elisabet Maríare. ");
INSERT INTO des_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Igo eroparĩcʉ̃ María yʉhripo: Goãmʉ õagʉ, turagʉ ãhrimi, arãa. Yʉhʉ õaro sĩporãcʉa. ");
INSERT INTO des_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Goãmʉ yʉre peamegue wabodigore itamugʉ ãhrimi. Eropigʉ dohpaguere yʉre õaro mucubiriri mera árĩcʉ̃ iimi. ");
INSERT INTO des_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Yʉre bu árĩgore ĩgʉ ĩgʉ pohro majagore guñadi ãhrami. Goãmʉ turatariagʉ õari dihtare yʉre itamumi. Eropirã “Igore Goãmʉ õaro iimi,” árĩpehrerã masa dohpaguere eropa arĩ wereniguirãcoma yʉre. Goãmʉ ñeri marigʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Árĩpehrerinʉri árĩpehrerã ĩgʉre umupeorãre ĩgʉ mojomoro ĩagʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Goãmʉ ĩgʉ turari mera iigʉ ãhrimi. “Gajirãre tarinʉgaa yʉhʉ,” arĩrãre tarinʉgadi árĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Oparãre erã dorero árĩrare cóãdi árĩmi ĩgʉ. Eropigʉ bu árĩrãpʉre ĩgʉ oparã iro dopa ta apidi árĩmi. ");
INSERT INTO des_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Oaboanirãre ĩgʉ õari barire ódi árĩmi. Eropigʉ baja opanirãpʉre gajino moorã wacʉ̃ iidi árĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Mari ñecʉ sʉmarã mʉrare “Masare õaro iigʉra,” ĩgʉ arĩ werediro dopa ta iipehodi árĩmi Goãmʉ. Eropigʉ ĩgʉ pohro majarã Israe masare ĩgʉ itamudi árĩmi. Mari ñecʉ sʉmarã mʉrare, Abrahã mʉrʉre árĩpehrerã ĩgʉ acawererã ĩgʉ pʉhrʉ árĩrã sãre Goãmʉ árĩpehrerinʉri eropa mojomoro ĩaniguigʉ árĩmʉridi árĩmi. “Masare õaro iigʉca,” erãre ĩgʉ werepirare cãdijibiridi árĩmi Goãmʉ, arĩpo María. ");
INSERT INTO des_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ʉrerã abe gohra Elisabet mera ãhri, igo ya macague goe dujaa wapo María. ");
INSERT INTO des_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet igo niji wahgũra pʉhrʉ igo magʉ masa dehyoapʉ. ");
INSERT INTO des_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Eropirã Goãmʉ igore ĩgʉ eropa õaro iicʉ̃ igo ya maca majarã igo acawererã sã igo mera mucubiriñorã. ");
INSERT INTO des_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho nʉri ĩgʉ masa dehyoara pʉhrʉ, ĩgʉ pagʉ sʉmarã ĩgʉgãre gasiro merogã wiri aĩdorerã wañorã. Eropa erã iirisubu erã mera majarã Zacaría waĩyediariñorã ĩgʉgãre ĩgʉ pagʉ waĩre. ");
INSERT INTO des_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Erã eropa waĩyediaquerecʉ̃ ta ĩgʉ pagopʉ õpa arĩpo: —Ĩgʉ pagʉ waĩre waĩyebeaa. Ñu waĩyerãca ĩgʉgãre, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Mʉ acawererã ne yujugʉ Ñu waĩcʉgʉ marimi, arĩñorã erã igore. ");
INSERT INTO des_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Eropirã erã mojotori mera werenigui Zacaríare serẽpiñorã erã. —¿Mʉca dohpa waĩyediari mʉ magʉre? arĩ serẽpiñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Erã eroparĩcʉ̃ ĩgʉ pagʉ gojaburimijire serẽbeo, ñeha, gojapʉ: “Yʉ magʉ Ñu waĩcʉmi,” arĩ gojapʉ Zacaría. Ĩgʉ eropa arĩ gojacʉ̃ erãpʉ ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ĩgʉ eropa arĩ gojara pʉhrʉ ĩgʉre wereniguicʉ̃ iipʉ Goãmʉ. Eropigʉ ĩgʉ wereniguimasipʉ daja. —Goãmʉ turagʉ, õagʉ ãhrimi, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ĩgʉ eropa arĩ wereniguicʉ̃ peerã ero majarã ʉca wañorã. Eropirã i árĩpehrerire Judea yeba majarãre ʉtã yucʉ watope árĩrãre masa weresiriñorã. ");
INSERT INTO des_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Árĩpehrerã irire peerã guñañorã. “Goãmʉ turarire ĩgʉgã opami. ¿Eropigʉ ñehmʉno árĩgʉcuri ĩgʉgã?” arĩ pepiñorã masa. ");
INSERT INTO des_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eropigʉ ĩgʉ pagʉ Zacaría Espíritu Santo árĩri mera õaro pepigʉ árĩgʉ Goãmʉ yare werepʉ: ");
INSERT INTO des_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Mari Israe masa Goãmʉre umupeorã. Ĩgʉ yarã ãhraa mari. Eropigʉ mari pohrogue arigʉ, marire itamugʉ õaro taumi. ");
INSERT INTO des_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Eropigʉ Goãmʉ turagʉre marire peamegue wabonirãre õaro taubure obeomi. Marire õaro taubu ĩgʉ acaweregʉ Davi mʉrʉ ãhrimi. Davipʉ Goãmʉ pohro majagʉ árĩmʉriñumi. ");
INSERT INTO des_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Iribojegue ĩgʉ ya weremʉhtanirã mera Goãmʉ ĩgʉ marire taubure obeoburire wereyumʉripʉ. ");
INSERT INTO des_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Marire ĩhaturirã marire ñero erã iidiacʉ̃ ĩagʉ “Mʉare itamugʉra,” arĩ apiñumi Goãmʉ marire. ");
INSERT INTO des_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mari ñecʉ sʉmarã mʉrare, “Mʉare mojomoro ĩagʉ itamugʉra. Mʉare yʉ wererare guñagʉra,” arĩ apiñumi Goãmʉ mari ñecʉ sʉmarãre. Iribojegue ĩgʉ eropa arĩdiro dopa ta marire dohpaguere iimi. ");
INSERT INTO des_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Eropigʉ Abrahãre õpa arĩmʉriñumi: “Mʉ acawererã pʉhrʉ árĩrã erãre ĩhaturirã árĩcʉ̃ cóãgʉra. Eropigʉ mʉ acawererãre itamugʉra. Eropirã erã güibirã ta yʉ dorerire iimasima. Eropigʉ erã ñerire yʉ cóãcʉ̃, erã yʉ ĩhuro ʉmʉri nʉcʉ õarã árĩniguirãcoma,” arĩ werepimʉriñumi iribojegue Goãmʉ mari acaweregʉ Abrahãre, arĩpʉ Zacaría. Eropa arĩtuha ĩgʉ magʉgãre õpa arĩpʉ: ");
INSERT INTO des_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","—Mahgʉ, mʉre õpa arĩrãcoma masa: “Goãmʉ turatariagʉ yare wereniguigʉ ãhrimi,” arĩrãcoma mʉre. Eropigʉ mʉhʉ mari Opʉ core wayugʉca. Eropa wagʉ õpa arĩ weregʉca. “Goãmʉ mʉa ñerire cóãgʉ, peamegue wabonirãre taugʉcumi mʉare,” arĩ weregʉca. Eropa arĩ weregʉ mari Opʉ ĩgʉ ariborore weremʉhtayugʉ iigʉca mʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Goãmʉpʉ marire turaro mojomoro ĩagʉ marire õaro iigʉ árĩgʉ, ĩgʉ marire peamegue wabonirãre taudiami. Marire taugʉ arigʉ Cristo mari pohro arigʉcumi. ");
INSERT INTO des_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Árĩpehrerã mari peamegue wabonirãre taudiami ĩgʉ. Eropigʉ Goãmʉre mari masibirã árĩcʉ̃ ĩagʉ marire masicʉ̃ iidiami ĩgʉ. Eropigʉ mari õaro yujuro mera mari árĩborore weregʉcumi marire, arĩpʉ Zacaría. ");
INSERT INTO des_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Eropi Ñu Zacaría magʉ õaro bʉgapʉ. Eropigʉ Goãmʉre turaro mahipʉ. Eropigʉ yoari boje masa marirogue árĩmʉripʉ. Te Israe masare buhenʉgagʉ sã erogue ta árĩmʉripʉ. ");
INSERT INTO des_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Irisubure árĩpehreri yebari majarã tauro opʉ Augusto árĩpehrerãre queodorepʉ. ");
INSERT INTO des_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Oã masare erã ne queonʉgarisubu árĩcʉ̃ Cirenio waĩcʉgʉ Siria yeba majarã opʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eropirã árĩpehrerã erã ñecʉ sʉmarã iribojegue majarã ya macarigue erã waĩre gojapeorã wañorã. ");
INSERT INTO des_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José sã Nazaregue Galilea árĩri yeba árĩri macague árĩnirã waha, Judea yebague Belén waĩcʉri macague ejañorã. Opʉ Davi iribojegue majagʉ ĩgʉ masa dehyoadiro árĩyoro Belén. José Davi mʉrʉ pãrami árĩgʉ Beléngue wapʉ ĩgʉ waĩre gojapeogʉ wagʉ. ");
INSERT INTO des_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Eropigʉ ĩgʉ María ĩgʉ mojoto diribo árĩcʉ̃ erogue igo mera ĩgʉ waĩre gojapeodoregʉ wapʉ. Igopʉ majigʉre bocatuhadigogue árĩpo. ");
INSERT INTO des_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Eropigo Beléngue ejago igo niji wahgũpo. ");
INSERT INTO des_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Erogue masa erã carĩri wihi ne sihajabiriyoro erãre. Eropirã erã wecʉa ya wihigue carĩrã wañorã. Eropigo igo ĩgʉ ne dehyoagʉgãre porãcʉtuha ĩgʉgãre suhriro mera oma, wecʉa erã bari coro weca ĩgʉre pihripeopo. ");
INSERT INTO des_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iri ñamire iri maca tʉrogue campogue ovejare ĩhadiburã erã yarã ovejare ĩhadiburã iiñorã. ");
INSERT INTO des_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Eropigʉ Goãmʉ ĩgʉ obeodigʉ anyu erãre dehyoapʉ. Ĩgʉ eropa dehyoacʉ̃ Goãmʉ ĩgʉ gosesiriri erãre boyoweayoro. Eropa wacʉ̃ ĩarã, ovejare ĩhadiburã güia wañorã. ");
INSERT INTO des_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Erã eropa wacʉ̃ anyu erãre werepʉ: —Õari querere mʉare weregʉ ahraa. Árĩpehrerã masare mucubiricʉ̃ iiroca i quere. Eropirã güibiricãque mʉa. ");
INSERT INTO des_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dohpagã ñamire opʉ mʉrʉ Davi ya macague mʉare peamegue wabonirãre taubu, Cristo Goãmʉ ĩgʉ obeodigʉ mari Opʉ masa dehyoatuhami. ");
INSERT INTO des_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eropigʉ suhriro mera omadigʉ wecʉa bari coro weca erã pihripeodigʉ mʉa bocagʉ ĩgʉ ta árĩgʉcumi, arĩ werepʉ anyu erãre. ");
INSERT INTO des_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ĩgʉ eroparĩcʉ̃ ta bajarã ʉmaro majarã árĩmʉhtadigʉ anyu mera bayapeoñorã. Õpa arĩ bayapeoñorã erã: ");
INSERT INTO des_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Goãmʉre ʉmaro majagʉre umupeorã. Eropirã Goãmʉ ĩgʉ mahirã güiro mariro gamequeãro mariro õaro árĩporo, arĩ bayapeoñorã anyua. ");
INSERT INTO des_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Eropa bayatuhaja ʉmarogue erã mʉriara pʉhrʉ ovejare ĩhadiburãpʉ erã basi game wereniguiñorã: —Ire Goãmʉ ĩgʉ marire wererare Beléngue ina ĩarã warã, arĩñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eropa arĩrã yojaro mera wañorã erã. Maríare, Josére bocaja, majigʉgãre wecʉa erã bari coro weca pihripeodigʉre ĩañorã erã. ");
INSERT INTO des_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ovejare ĩhadiburã ĩgʉre ĩatuha anyu majigʉgãre ĩgʉ wererare wereñorã gajirãre. ");
INSERT INTO des_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Erã eropa arĩ werecʉ̃ ta árĩpehrerã erãre pee ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","I árĩpehrerire Maríapʉ guña pepipo. ");
INSERT INTO des_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eropirã ovejare ĩhadiburãpʉ anyu ĩgʉ werediro dopa árĩcʉ̃ ĩañorã. “Goãmʉ turagʉ ãhrimi,” arĩ mucubiriñorã. Eropa arĩ mucubiri dujaa wañorã. ");
INSERT INTO des_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yuju semana pʉhrʉ majigʉre gasiro merogã wiri aĩrire erã iidoreranʉ árĩcʉ̃ erã ĩgʉgãre Jesu waĩyeñorã. Jesure ne igo bocaboro core anyupʉ “Jesu waĩyeque ĩgʉre,” arĩ werepipʉ. Eropirã ĩgʉgãre Jesu waĩyeñorã. ");
INSERT INTO des_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Goãmʉ doreri Moise ĩgʉ werediro dopa ta iimorã, José, María mera Jerusaléngue wañorã. Erogue María porãcʉra pʉhrʉ õago igo dʉpʉ árĩrore ĩhmurã wañorã. Eropa warã erã Jesure aĩgã wañorã. Ĩgʉgãre Goãmʉre “Ĩgã mʉ yagʉ árĩbu ãhrimi,” arĩ ĩhmurã warã iiñorã. ");
INSERT INTO des_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Õpa iiñorã Goãmʉ yare erã gojarapũ dorero dopa ta. “Árĩpehrerã mʉa porãre ne dehyoarãre Goãmʉre ĩhmuque. ‘Ĩgã mʉ yagʉ árĩbu ãhrimi,’ arĩ ĩhmuque,” arĩ doremʉriñumi Goãmʉ ĩgʉ yare gojarapũgue. ");
INSERT INTO des_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eropa ĩhmutuha Goãmʉ ĩgʉ dorediro dopa ta mirimagʉgãre erã asũtuhaja Goãmʉ wihigue apirã wañorã. Õpa doreñumi Goãmʉ ĩgʉ yare gojarapũgue: “Buja borerãre perã oque Goãmʉre. O erã maricʉ̃ buja borewijigãrãre oque yʉre umupeomorã,” arĩ doreñumi Goãmʉ. Eropirã ĩgʉ dorediro dopa iiñorã José María mera. ");
INSERT INTO des_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusaléngue Simeón waĩcʉgʉ árĩpʉ. Ĩgʉ õagʉ, Goãmʉre umupeogʉ árĩpʉ. Goãmʉ Israe masare itamuburire coregʉ iipʉ. Eropigʉ Simeón Espíritu Santo ĩgʉ mera árĩcʉ̃ õaro pepigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Eropigʉ “Mʉ sĩriboro core Goãmʉ ĩgʉ obeobure Cristore ĩagʉca mʉhʉ,” arĩ weremʉhtapʉ Espíritu Santo ĩgʉre Simeore. ");
INSERT INTO des_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eropigʉ Espíritu Santo ĩgʉre dorecʉ̃ Goãmʉ wihigue ñajaa wapʉ. Ĩgʉ ñajara pʉhrʉ Jesu pagʉ sʉmarã ĩgʉgãre aĩ ñajañorã Goãmʉ ĩgʉ gojarapũ dorera dopa ta iirã. ");
INSERT INTO des_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeónpʉ ĩgʉgãre coã aĩ, Goãmʉre umupeo, “Õhaa,” arĩ ĩgʉ mera wereniguipʉ. Õpa arĩpʉ ĩgʉ Goãmʉre: ");
INSERT INTO des_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","Opʉ, dohpague tamerare masare peamegue wabonirãre taubure obeoa mʉhʉ. Ĩgʉ judio masa árĩbirãre buhegʉ mʉre õaro masicʉ̃ iigʉcumi erãre. Masare taubure Israe masʉre mʉhʉ apiyoro. Mʉ eropa iirare árĩpehrerã masirã, “Israe masare õaro iimi Goãmʉ,” arĩrãcoma masa. Ĩgã marire taubu ãhrimi. Eropigʉ mʉ yʉre arĩdiro dopa ĩgãre ĩatuhabʉ. Eropigʉ dohpaguere õaro mucubirigʉ sĩrigʉca, arĩpʉ Simeón. ");
INSERT INTO des_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón ĩgʉgãre arĩrare peerã ĩgʉ pagʉ sʉmarãpʉ pee ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Eropigʉ Simeón erãre “Õaro árĩque mʉa,” arĩgʉ ĩgʉ Jesu pago Maríare werepʉ: —Goãmʉ ĩgãre beyedi árĩmi. Ĩgʉ eropa beyedigʉ árĩcʉ̃ judio masa bajarã ĩgʉre tarinʉgarãcoma. Eropa iirã erã peamegue warãcoma. Eropigʉ judio masare bajarãre taubure beyedi árĩmi Goãmʉ ĩgãre. Ĩgʉ Goãmʉ turarire ii ĩhmugʉ ĩgʉ árĩquerecʉ̃ masa bajarã ĩgʉre ñero arĩ wereniguirãcoma. ");
INSERT INTO des_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Erã eropa iicʉ̃ gajirã erã ñero guñarire masirãcoma. Eropigo mʉhʉ turaro bʉjaweregoca, arĩdocaritamupʉ Simeón Maríare. ");
INSERT INTO des_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ero Goãmʉ yare wereniguigo Ana waĩcʉgo árĩpo. Igo Fanuel mago árĩpo. Aser mʉrʉ ya curu majago árĩpo. Bʉro gohra árĩpo. Igo ero coregue siete bojori dihta igo marapʉ mera árĩniripo. ");
INSERT INTO des_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Eropigo ochenta y cuatro bojori gohra wapeweyo árĩmʉripo igo. Eropigo ʉmʉre, ñami sãre Goãmʉ ya árĩburire iibo, ba duhu, Goãmʉ mera werenigui, Goãmʉ wihire ne wiriabiripo. ");
INSERT INTO des_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón ĩgʉ wereniguiro watope igo erã pohro erago, mucubirigo Goãmʉre, “Õhaa,” arĩpo. Eropigo Jerusalén majarãre taubure corerãre igo Jesu dehyoarare werepo erã árĩpehrerãre. ");
INSERT INTO des_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Goãmʉ ĩgʉ dorero dopa ta iituhaja, erã ya macague Nazaregue dujaañorã. Galilea yeba árĩyoro iri maca. ");
INSERT INTO des_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eropigʉ Jesu õaro bʉga turagʉ wapʉ. Eropigʉ ĩgʉ õaro pee masigʉ árĩpʉ. Eropigʉ ĩgʉre Goãmʉ õaro iipʉ. ");
INSERT INTO des_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bojori nʉcʉ Jesu pagʉ sʉmarã Jerusaléngue Pascua bosenʉre ĩarã wamʉriñorã. ");
INSERT INTO des_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesu doce bojori ĩgʉ opacʉ̃ erã iidiro dopa ta erã árĩpehrerã Jerusaléngue wañorã. ");
INSERT INTO des_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Eropirã bosenʉ pehrecʉ̃ erã erã ya macague dujaa wañorã daja. Erã eropa dujaaquerecʉ̃ ta Jesupʉ Jerusaléngue dujacãpʉ. Ĩgʉ pagʉ sʉmarã ĩgʉ erogue dujarare masibiriñorã. ");
INSERT INTO des_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Ĩgʉ mari mera majarã mera árĩcumi,” arĩ pepiriñorã erã. Eropirã erã yujunʉ gohra Jesu mariro wañorã mague. Eropirã erã Jesure erã acawererã watope amariñorã. ");
INSERT INTO des_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ne bocabiriñorã. Eropirã Jerusaléngue ĩgʉre amarã dujañorã daja. ");
INSERT INTO des_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ʉhrenʉ pʉhrʉ ĩgʉre Goãmʉ wihigue bocajañorã. Eropirã Jesure judio masare buherã watope bocañorã. Ĩgʉ erãre pee serẽpi doapʉ. ");
INSERT INTO des_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Erã árĩpehrerã Jesure peerã õaro masigʉgã ĩgʉ árĩcʉ̃ ĩarã, erã ĩhamaria wañorã. ");
INSERT INTO des_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ĩgʉ pagʉ sʉmarã sã eroguere Jesure ĩarã ĩhamaria wañorã. Eropigo ĩgʉ pago ĩgʉre õpa arĩpo: —Mahgʉ, ¿duhpigʉ eropa iiari mʉhʉ gʉare? Mʉ pagʉ, yʉhʉ, “Ĩgʉ dederea wañumi,” arĩrã ahmaa gʉa mʉre, arĩpo igo igo magʉre. ");
INSERT INTO des_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Igo eroparĩcʉ̃ ĩgʉ ĩgʉ pagʉ sʉmarãre werepʉ: —¿Duhpirã yʉre ahmari mʉa? Yʉ Pagʉ yʉre ĩgʉ dorediro dopa ta iigʉ iiaa. ¿Irire masibeari mʉa? arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ĩgʉ eropa arĩquerecʉ̃ erã peemasibiriñorã. ");
INSERT INTO des_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","I árĩpehreri ĩgʉ iirare Maríapʉ õaro guñapo. Eropigʉ Jesu Nazaregue dujaa wapʉ. Ĩgʉ pagʉ sʉmarãre õaro yʉhrigʉ árĩmʉripʉ. ");
INSERT INTO des_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Eropigʉ Jesu bʉga, õaro pee masigʉ wapʉ. Eropirã Goãmʉ masa sã “Õagʉ ãhrimi,” arĩ ĩañorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Irisubure erã tauro opʉ árĩgʉ Tiberio waĩcʉgʉ ĩgʉ opʉ árĩra pʉhrʉ quince bojori wayoro. Eropigʉ Poncio Pilato waĩcʉgʉ Judea yeba majarã opʉ árĩpʉ. Eropigʉ Herode waĩcʉgʉ Galilea yeba majarã opʉ árĩpʉ. Ĩgʉ pagʉ magʉ Felipe Iturea yeba majarã, Traconite majarã sã erã opʉ árĩpʉ. Eropigʉ Lisania waĩcʉgʉ Abilinia yeba majarã opʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Eropirã Ana, Caifa mera pahia oparã árĩñorã. Oã árĩpehrerã erã árĩrisubure Ñu Zacaría magʉ masa marirogue árĩgʉre Goãmʉpʉ ĩgʉ ĩgʉ yare weredorepʉ. ");
INSERT INTO des_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eropigʉ Jordán waĩcʉriya tʉro árĩri yeba árĩpehrerogue Ñu õpa arĩ weregʉ wapʉ: —Mʉa ñeri iirire bʉjawereque. Dohpaguere õarire gohrotoque. Eropirã waĩyenirã árĩque. Mʉa eropa iicʉ̃ ĩagʉ Goãmʉ mʉa ñerire cóãgʉcumi, arĩ weremʉripʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ñu eropa wereniguigʉ Isaia iribojegue majagʉ Goãmʉ ya weremʉhtadigʉ ĩgʉ gojadiro dopa ta iigʉ iipʉ. Õpa arĩ gojayuñumi Isaia Ñu iiburire: Masa marirogue werenigui gaguiniguigʉ õpa arĩgʉcumi: “Mari Opʉ ĩgʉ ariburi mare amuro dopa õarã árĩyuque mʉa ĩgʉre peemorã. ");
INSERT INTO des_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dipa gobericʉrore mari diaye maja maha iidiro dopa ta, mʉa ñero iirire duhuque. ");
INSERT INTO des_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mʉa eropa iicʉ̃ Goãmʉ mʉare peamegue wabonirãre ĩgʉ taucʉ̃ ĩarãca árĩpehreri yeba majarã,” arĩgʉcumi ĩgʉ gaguinigui weregʉpʉ, arĩ gojamʉriñumi Isaia iribojeguere Ñu ĩgʉ árĩboro coregue. ");
INSERT INTO des_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Masa bajarã Ñu pohro erarã ĩgʉ erãre waĩyecʉ̃ gameñorã erã. Eropigʉ ĩgʉ erãre werepʉ: —Mʉa ñero iiricʉrã ãhraa mʉa. Goãmʉre “Gʉa ñeri dipuwaja moabiricãporo,” arĩrã ¿mʉa yʉre waĩyedorerã ahriri? ");
INSERT INTO des_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ĩgʉ mʉa ñero iira dipuwaja moabiricʉ̃ õpa iique mʉa. Diaye mʉa ñero iirire bʉjawererã árĩrã, õarire gohrotorã árĩrã, õarire iique mʉa. “Abrahã mari ñecʉ mʉrʉ árĩmʉripʉ. Eropirã mari Goãmʉ mera õatuhajaa,” arĩ pepibiricãque. Mʉare arĩgʉ tiiaa. Abrahã pãramerã mʉa árĩri duhpiburi árĩbeaa. Goãmʉpʉ gamegʉ i ʉtãyeri mera gajirãre iimasimi Abrahã acawererãre. Eropiro Abrahã acawererã mʉa árĩri bu gohra ta ãhraa. ");
INSERT INTO des_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Õpa ãhraa: Mari masa yucʉ iro dopa ta ãhraa. Goãmʉpʉ come opagʉ iro dopa ta ãhrimi. Eropigʉ ñeri dʉcacʉri yucʉre tabe cóã, iri nuguri sãre tabetagʉcumi. Tabetatuhaja, peamegue cóãgʉcumi ĩgʉ iri yucʉre iri nuguri sãre. Eropa ta iigʉcumi mʉa sãre ĩgʉre gamebirãre, arĩpʉ Ñu masare. ");
INSERT INTO des_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ĩgʉ eroparĩcʉ̃ peerã masapʉ ĩgʉre serẽpiñorã: —¿Dohpa iirãcuri gʉa? arĩñorã erã Ñure. ");
INSERT INTO des_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Peñe suhriro opagʉ suhriro moogʉre yujuñe oque. Eropirã mʉa bari oparã gajirã sãre oque, arĩpʉ Ñu. ");
INSERT INTO des_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bajamerãgã oparã yare wajasea corerã sã waĩyedorerã erañorã. Eropirã Ñu pohro erarã ĩgʉre serẽpiñorã: —Buhegʉ, ¿gʉapʉ dohpa iirãcuri? arĩñorã. ");
INSERT INTO des_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Mʉa oparã erã doreropẽ ta masare niyerure wajaseaque. Gʉyari mera aĩnemobita, arĩ yʉhripʉ Ñu erãre. ");
INSERT INTO des_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Gajirã surara ĩgʉre serẽpiñorã daja. —¿Gʉapʉ dohpa iirãcuri? arĩñorã erã ĩgʉre daja. —Masare erã niyerure emabiricãque. Eropirã iri niyerure gʉya emabiricãque. Mʉa wajatarire ĩarã mucubirique, arĩ yʉhripʉ Ñu erãre. ");
INSERT INTO des_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Masa Cristore Goãmʉ ĩgʉ obeobure corerã iiñorã. Eropirã õpa arĩ pepinʉgañorã erã Ñure. “Ihĩ Ñupʉ Cristo árĩbocumi,” arĩ pepiriñorã erã. ");
INSERT INTO des_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Erã eropa arĩ pepicʉ̃ peegʉ Ñu árĩpehrerãre werepʉ: —Yʉ tauro turagʉ arigʉcumi. Õatariagʉ ãhrimi ĩgʉ. Ĩgʉ iro dopa árĩbeaa yʉpʉ. Eropigʉ ĩgʉre pepigʉ, “Yʉ tamera bu árĩgʉ ãhraa,” arĩ pepia yʉhʉ. Mʉa ñero iirare bʉjawerera pʉhrʉ yʉpʉ mʉare deco mera waĩyeabʉ. Ĩgʉpʉ yʉ tauro iigʉcumi. Espíritu Santore ogʉcumi masa mera árĩniguibure. Eropigʉ ĩgʉ ñerire soewearo dopa ta ĩgʉ arigʉpʉ mʉa ñerire coeweagʉcumi. ");
INSERT INTO des_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yʉ pʉhrʉ arigʉ trigo gasirire cóãgʉ iro dopa ãhrimi. Gasiri cóãgʉ ĩgʉ ya sihburu mera árĩpehreri trigo yeri gasirire sʉha weami. Eropa sʉha weara pʉhrʉ trigo yeri gohrapʉre ĩgʉ diburi wihigue apigʉcumi. Ĩgʉ sʉha weara gasiripʉre ĩgʉ soegʉcumi. Eropa ii beyegʉcumi yʉ pʉhrʉ arigʉ. Õarire gohrotonirãpʉre ĩgʉ mera árĩniguicʉ̃ iigʉcumi. Erã ñero iirare bʉjawerebirãpʉre peamegue yaribiriri peamegue cóãgʉcumi, arĩ werepʉ Ñu. ");
INSERT INTO des_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bajarãre ĩgʉ eropa arĩ wereri mera masare õari buherire werepʉ Ñu. ");
INSERT INTO des_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Eropigʉ opʉ Herodepʉ ĩgʉ pagʉ magʉ Felipe marapore ĩgʉ emara waja, wʉaro ñerire ĩgʉ iira waja Ñu ĩgʉ sãre wereripʉ. ");
INSERT INTO des_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ĩgʉ eropa arĩ werecʉ̃ Herodepʉ Ñure peresu iipʉ dipaturi ñerire iigʉ daja. Eropa iigʉ ĩgʉ ñerire iira dipuwajacʉgʉ árĩnemopʉ. ");
INSERT INTO des_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ñure erã peresu iiboro core gajirã masare Ñupʉ waĩyegʉ iipʉ. Erãre waĩyegʉ Jesu sãre waĩyepʉ. Eropigʉ Jesu diague niguigʉ Goãmʉre ĩgʉ serẽrisubu ʉmʉsi pãrimaa waya. ");
INSERT INTO des_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Eropa pãrimaara pʉhrʉ Espíritu Santo buja iro dopa bejagʉ Jesu weca dijaripʉ. Ĩgʉ dijaricʉ̃ ʉmarogue wereniguiro cariyoro: —Mʉhʉ yʉ magʉ yʉ mahigʉ ãhraa. Mʉ mera õaro mucubiria, arĩro cariyoro ʉmarogue. ");
INSERT INTO des_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu ĩgʉ buhenʉgarasubure treinta bojori opapʉ ĩgʉ. “Ĩgʉ José magʉ ãhrimi,” arĩ pepiriñorã masa. Josépʉ Elí magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat magʉ árĩñumi. Matat Leví magʉ árĩñumi. Leví Melqui magʉ árĩñumi. Melqui Jana magʉ árĩñumi. Jana José magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías magʉ árĩñumi. Matatías Amós magʉ árĩñumi. Amós Nahúm magʉ árĩñumi. Nahúm Esli magʉ árĩñumi. Esli Nagai magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat magʉ árĩñumi. Maat Matatías magʉ árĩñumi. Matatías Semei magʉ árĩñumi. Semei Josec magʉ árĩñumi. Josec Judá magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joanán magʉ árĩñumi. Joanán Resa magʉ árĩñumi. Resa Zorobabe magʉ árĩñumi. Zorobabe Salatie magʉ árĩñumi. Salatie Neri magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui magʉ árĩñumi. Melqui Adi magʉ árĩñumi. Adi Cosam magʉ árĩñumi. Cosam Elmadam magʉ árĩñumi. Elmadam Er magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josué magʉ árĩñumi. Josué Eliezer magʉ árĩñumi. Eliezer Jorim magʉ árĩñumi. Jorim Matat magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví magʉ árĩñumi. Leví Simeón magʉ árĩñumi. Simeón Judá magʉ árĩñumi. Judá José magʉ árĩñumi. José Jonam magʉ árĩñumi. Jonam Eliaquim magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea magʉ árĩñumi. Melea Mena magʉ árĩñumi. Mena Matata magʉ árĩñumi. Matata Natán magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán Davi magʉ árĩñumi. Davi Isaí magʉ árĩñumi. Isaí Obed magʉ árĩñumi. Obed Booz magʉ árĩñumi. Booz Salmón magʉ árĩñumi. Salmón Naasón magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadab magʉ árĩñumi. Aminadab Admin magʉ árĩñumi. Admin Arni magʉ árĩñumi. Arni Esrom magʉ árĩñumi. Esrom Fares magʉ árĩñumi. Fares Judá magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacobo magʉ árĩñumi. Jacobo Isaa magʉ árĩñumi. Isaa Abrahã magʉ árĩñumi. Abrahã Taré magʉ árĩñumi. Taré Nacor magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serug magʉ árĩñumi. Serug Ragau magʉ árĩñumi. Ragau Peleg magʉ árĩñumi. Peleg Heber magʉ árĩñumi. Heber Sala magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Caina magʉ árĩñumi. Caina Arfaxad magʉ árĩñumi. Arfaxad Sem magʉ árĩñumi. Sem Noé magʉ árĩñumi. Noé Lame magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lame Matusalem magʉ árĩñumi. Matusalem Enoco magʉ árĩñumi. Enoco Jared magʉ árĩñumi. Jared Mahalaleel magʉ árĩñumi. Mahalaleel Caina magʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Caina Eno magʉ árĩñumi. Eno Sete magʉ árĩñumi. Sete Adán magʉ árĩñumi. Adán Goãmʉ iidigʉ árĩñumi. ");
INSERT INTO des_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu Espíritu Santo ĩgʉ dorero dopa ta iipehogʉ árĩgʉ, ĩgʉ Jordán waĩcʉriyague buharapʉ. Ĩgʉ eropa buharacʉ̃ Espíritu Santopʉ ĩgʉre masa marirogue wadorepʉ. ");
INSERT INTO des_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Erogue ejagʉ cuarenta nʉri gohra árĩpʉ. Eropigʉ watĩpʉ Jesure ñerire iicʉ̃ gameripʉ. Eropigʉ ñerire iidoreripʉ ĩgʉre. Irinʉrire ne Jesu babiripʉ. Eropigʉ irinʉri pehrero gohra ĩgʉ oaboapʉ. ");
INSERT INTO des_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ĩgʉ eropa oaboacʉ̃ ĩagʉ watĩ õpa arĩpʉ Jesure: —Mʉhʉ Goãmʉ magʉ árĩgʉ õpa ĩhmuque. Iyere ʉtãyere bari poyacʉ̃ iique, arĩripʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu gamebiripʉ. Õpa arĩ yʉhripʉ: —Goãmʉ yare erã gojarapũ õpa ãhraa: “Masare bari mera dihta ojocaribiro gahmea. Árĩpehreri Goãmʉ ya ĩgʉ ya wereniguiri mera sãre árĩro gahmea,” arĩmi Goãmʉ, arĩpʉ Jesu watĩre. ");
INSERT INTO des_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ĩgʉ eropa arĩra pʉhrʉ watĩpʉ ĩgʉre ʉtãgʉ wecague aĩ mʉriagʉ merogã pʉhrʉ ĩgʉ árĩpehreri macari majare Jesure ĩhmu purumujupʉ. ");
INSERT INTO des_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Eropa ĩhmugʉ õpa Jesure arĩpʉ: —Árĩpehreri i macari ĩgʉ yʉre ora ãhraa. Eropigʉ yʉ gamegʉre omasia. Eropigʉ i macarire, i macari majarã doreri sãre, erã opari mera mʉre ogʉra. ");
INSERT INTO des_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yʉre “Mʉhʉ yʉ opʉ ãhraa,” arĩ umupeoque. Mʉ eroparĩcʉ̃ i macarire árĩpehreri macarire mʉre ogʉra, arĩ wereripʉ watĩ Jesure. ");
INSERT INTO des_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu õpa arĩ yʉhripʉ ĩgʉre: —Mʉre umupeobeaa. Õpa ãhraa Goãmʉ yare erã gojarapũ: “Mʉ Opʉ Goãmʉ dihtare umupeoque. Ĩgʉ ya doreri dihtare iique,” arĩ gojañuma Goãmʉ yare, arĩpʉ Jesu watĩre. ");
INSERT INTO des_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Ĩgʉ eropa arĩra pʉhrʉ Jerusaléngue watĩpʉ ĩgʉre aĩgãpʉ. Erogue eja Goãmʉ wihi wecague aĩ mʉrijapʉ ĩgʉre. Aĩ ejatuhaja ĩgʉre õpa arĩripʉ: —¿Diaye ta Goãmʉ magʉ gohra ta ãhriri mʉhʉ? Goãmʉ yare erã gojarapũ õpa ãhraa: Goãmʉ ĩgʉ yarã anyuare mʉre ĩhadibudoregʉcumi. Eropirã erãpʉ mʉre ĩhadiburãcoma mʉgue ʉtãye weca mehbejajari arĩrã, arĩ gojañuma Goãmʉ yare erã gojarapũ. Erã mʉre eropa ĩhadibumorã árĩcʉ̃ mʉhʉ Goãmʉ magʉ ta árĩgʉ õgue buhrimaa dija ĩhmuque yʉre. Mʉre erã itamucʉ̃ ĩhmuñata yʉre, arĩripʉ watĩ Jesure. ");
INSERT INTO des_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ĩgʉ eroparĩcʉ̃ peegʉ gamebiripʉ Jesu. Õpa arĩ yʉhripʉ ĩgʉre: —Goãmʉ yare erã gojarapũ õpa ãhraa: “Mʉ opʉ Goãmʉ ĩgʉ arĩrare, ‘¿Diaye ta ãhriri?’ arĩ masidiarã, Goãmʉre ii ĩhmudoremaabiricãque,” ãhraa Goãmʉ yare erã gojarapũ, arĩpʉ Jesu watĩre. ");
INSERT INTO des_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Eropigʉ watĩ árĩpehreri ñerire Jesure iidoreripʉ. Jesu ĩgʉ gamebiricʉ̃ ĩagʉ ĩgʉre merogã duhupʉ. ");
INSERT INTO des_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pʉhrʉ Jesu Galileague dujaa wapʉ. Eropigʉ ĩgʉ Espíritu Santo turari mera iipʉ. Ĩgʉ eropiicʉ̃ ĩarã ero árĩpehrero majarã masa ĩgʉ iira quere peeñorã. ");
INSERT INTO des_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judio masa buheri wiri Jesu sã buhemʉripʉ. Eropirã árĩpehrerã masa ĩgʉre õaro wereniguiñorã. ");
INSERT INTO des_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Pʉhrʉ Nazaregue Jesu ĩgʉ bʉgadirogue ta ejapʉ. Erogue eja, Sabado árĩcʉ̃ ĩgʉ eropa iiniguiro dopa ta ĩgʉ judio masa erã buheri wihigue ñajajapʉ. Ero ĩgʉ Goãmʉ yare erã gojarapũre buhediagʉ niguipʉ. Ĩgʉ eropa niguicʉ̃ ĩarã ero majarãpʉ Goãmʉ yare weremʉhtadigʉ Isaia ĩgʉ gojarapũre ĩgʉre oñorã. Iripũre Jesu i wererire bocagʉ buhepʉ: ");
INSERT INTO des_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Goãmʉ Espíritu Santo yʉ mera árĩgʉ yʉre doremi. Ĩgʉ mojomorocʉrãre õari buherire weredoregʉ obeomi yʉre. Eropigʉ ñero sĩporãcʉrãre õaro mucubiricʉ̃ iidoregʉ yʉre obeomi. Eropigʉ peresugue árĩrã sãre erãre ĩgʉ tauborore weredoregʉ obeomi yʉre. Cuiri ĩhajabirã erã õaro ĩhajaburire, gajirã erã ñero iibirarãre wiubure yʉre obeomi. ");
INSERT INTO des_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","“Mari Opʉ ĩgʉ yarãre peamegue wabonirãre ĩgʉ tauburinʉri ãhraa,” yʉre weredoregʉ obeomi, arĩ buhepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Eropa buhetuha Jesu iripũre bihacã, wihi majarãre wiatuha, doapʉ. Ĩgʉ doacʉ̃ ĩarã ero árĩpehrerã ĩgʉre ĩhanʉrʉñorã. ");
INSERT INTO des_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Erã eropa iicʉ̃ ĩgʉ erãre werenʉgapʉ: —I dohparagã ta yʉ buhediro dopa Goãmʉ ĩgʉ arĩdiro dopa sihajaro iiaa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ĩgʉ eropa wereniguicʉ̃ peerã “Ihĩ õagʉ ãhrimi,” arĩ pepiñorã. Eropirã erã ĩgʉ õaro wereniguirire peerã ʉca wañorã. Eropirã õpa arĩñorã erã erã basi: —Cuena, ¿José magʉ árĩbeari ihĩ? arĩñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Erã eroparĩcʉ̃ masigʉ Jesu werepʉ erãre: —Iribojegue majarã erã eropa wereniguidiro dopa ta mʉa sã yʉre õpa arĩdiarã ãhraa: “Mʉhʉ duhturu árĩgʉ mʉ basi ocoyeque mʉhʉ duhturu árĩrire ii ĩhmuboro dopa ta. Mʉhʉ Goãmʉ ĩgʉ obeodigʉ árĩgʉ mʉ basi ĩgʉ turari mera ii ĩhmuque gʉare. Capernaumguere Goãmʉ turari mera ii ĩhmuayoro mʉhʉ. Ohõ mʉ ya macague sãre gʉare ii ĩhmuque. Diaye ta mʉ Goãmʉ ĩgʉ obeodigʉ árĩrire gʉa masiboro dopa ii ĩhmuque,” arĩdiaa mʉa yʉre. ");
INSERT INTO des_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ire weregʉra mʉare. Goãmʉ ya weremʉhtagʉre ĩgʉ ya yeba majarã umupeobeama. Eropirã yʉre umupeobeaa mʉa ohõ yʉ bʉgadigʉ árĩquerecʉ̃. ");
INSERT INTO des_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Eropigʉ diaye arĩgʉ iiaa mʉare. Iribojegue majarã sãre Goãmʉ ya weremʉhtanirãre erã ya yeba majarã erãre umupeobiriñuma. Eropiro Elia Goãmʉ yare weremʉhtadigʉ ĩgʉ árĩrasubure ʉhre bojori gaji bojori deco gohra ne deco aribiriyoro. Eropiro árĩpehrerogue sãre ne bari mariyoro. Irisubure ĩgʉ ya yeba majarã Israe majarã bajarã wapeweyarã árĩquerecʉ̃ ta Goãmʉ erãre Eliare itamudoregʉ obeobiriñumi. ");
INSERT INTO des_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ĩgʉ ya yeba majarãre itamudorebiriqueregʉ gaji yeba Sidón yeba árĩri maca Sarepta waĩcʉri maca majagore itamudoregʉ Eliare obeoñumi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pʉhrʉ Goãmʉ ya weremʉhtadigʉ Eliseo ĩgʉ ĩgʉ árĩrisubure Israe yebague bajarã cami boarã erã árĩquerecʉ̃ ta ne yujugʉ Israe majagʉre ĩgʉ ya yeba majagʉre õagʉ iibiriñumi Eliseo. Ĩgʉ ya yeba majagʉre õaro iibigʉ ta gaji yeba majagʉ Naamán Siria majagʉ dihtare õagʉ iiñumi ĩgʉ. Eropigʉ judio masa erã umupeobirira waja, judio masa árĩbirã dihtare itamuñumi Goãmʉ, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ĩgʉ eroparĩcʉ̃ peerã árĩpehrerã iri wihi árĩrã guataria wañorã. ");
INSERT INTO des_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Eropirã erã wahgãnʉgaja Jesure tara wiria, iri maca tʉro árĩri tʉhrʉgue ĩgʉre tumedijudiariñorã. ");
INSERT INTO des_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Erã eropa iidiaquerecʉ̃ ta Jesu erã watope waha wapʉ. ");
INSERT INTO des_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pʉhrʉ Jesu Galilea yeba árĩri macague Capernaum waĩcʉri macague eja, Sabado árĩcʉ̃ masare buhepʉ. ");
INSERT INTO des_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ĩgʉ opʉ iro dopa ta ĩgʉ buhecʉ̃ peerã masa ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Iri wihi watĩ ñajasũdigʉ árĩgʉ turaro gaguiniguipʉ: ");
INSERT INTO des_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Mʉhʉ Jesu Nazare majagʉ gʉare garibobita mʉhʉ. ¿Dohpa iibu iiri gʉare? ¿Mʉhʉ gʉare dederecʉ̃ iibu iiri? Yʉhʉ masia Goãmʉ magʉ mʉ õagʉ árĩrire, arĩ gaguiniguipʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu turipʉ watĩre: —Ejarimaricãque. Duhuque ĩgʉre, arĩpʉ Jesu. Ĩgʉ eropa arĩra pʉhrʉ watĩpʉ masʉre yebague mehmereja tũrucʉ̃ iipʉ. Ĩgʉ eropa iira pʉhrʉ wiria wapʉ. Ĩgʉ masʉpʉ õagʉ dujapʉ. ");
INSERT INTO des_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ero árĩrã árĩpehrerã ĩgʉ eropa wacʉ̃ ĩha ʉca wañorã. Eropirã erã basi õpa arĩ wereniguiñorã: —¿Ñeheno buheri ãhriri i õpa wacʉ̃ iiri? Turaro mera opʉ iro dopa ta ihĩ watĩ ñajasũdigʉre taumi. Eropirã erã watẽa ĩgʉ dorero dopa ta masare duhuma, arĩ wereniguiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ĩgʉ eropa iicʉ̃ ĩarã iri yeba árĩpehreroguere masa Jesu ĩgʉ eropa iirare weresiriñorã. ");
INSERT INTO des_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Judio masa buheri wihire wiria, Simo ya wihigue ñajajapʉ Jesu. Ero Simo mʉñeco dorecʉgo iipo. Turaro nimacʉri árĩyoro. Eropirã erã igo dorecʉcʉ̃ wereñorã Jesure. ");
INSERT INTO des_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Erã werera pʉhrʉ ĩgʉ igo pohro eja, nimacʉrire taridorepʉ. Ĩgʉ eropa taridorera pʉhrʉ igore nimacʉri tahria wayoro. Mata õago wapo. Igo eropa wago wahgã doaja, igo ta erãre barire ejopo. ");
INSERT INTO des_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Abe ñajara pʉhrʉ árĩpehrerã masa ĩgʉ pohro arirã dorecʉrãre Jesu pohrogue aĩ ejañorã. Dorecʉrã baja gajiropa árĩri dorere opañorã. Eropigʉ Jesu ĩgʉ mojotori mera erã weca ñapeo, árĩpehrerãre erã dorere õaro taricʉ̃ iipʉ. ");
INSERT INTO des_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Watẽa ñajasũnirã sãre Jesu watẽare wiriadorepʉ. Erã wiricʉ̃ õpa arĩ gaguiniguiñorã: —Mʉhʉ diaye ta Goãmʉ magʉ ãhraa, arĩñorã erã Jesure. Jesu Goãmʉ ĩgʉ obeodigʉ ĩgʉ Cristo árĩcʉ̃ watẽa ĩgʉre masiñorã. Eropigʉ Jesu irire gajirãre werenidorebiripʉ. ");
INSERT INTO des_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Boyomʉriricʉ̃ Jesu iri maca árĩdigʉ waha, masa marirogue ejapʉ. Ĩgʉ eropiicʉ̃ ĩarã masa ĩgʉre ahma, bocajarã, õpa arĩñorã: —Gʉa ya maca dujaque. Wabita, arĩriñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Erã eropa arĩquerecʉ̃ ta ĩgʉpʉ erãre õpa yʉhripʉ: —Goãmʉ ĩgʉ opʉ árĩrire õari buherire gaji macari sãre buhediaa yʉhʉ. Goãmʉ yʉre obeomi irire werebure, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eropigʉ Galilea yeba maja wiri, judio masa buheri wirigue ĩgʉ buhe curipʉ. ");
INSERT INTO des_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gajinʉ Jesu Genesare waĩcʉri ditaru tʉrogue ejapʉ. Ero ĩgʉ árĩcʉ̃ ĩarã bajarã masa Goãmʉ yare peediarã ĩgʉre nʉrʉsia ejañorã. Õaro ʉjʉtʉri nʉgajañorã masa bajarã. ");
INSERT INTO des_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Peeru gasiru imiporo payari gasire Jesu ĩapʉ. Iri gasi majarã wai wejẽnirã majanʉgaja, erã wejẽdi yucʉre coerã iiñorã. ");
INSERT INTO des_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Eropigʉ Jesu Simo yarugue ñajapʉ. Ñajatuha iriru dohodirure dia tʉro taramujupidorepʉ. Eropigʉ dohodirugue doa, masare buhebeo doapʉ. ");
INSERT INTO des_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Buhetuha, Jesu Simore õpa arĩpʉ: —Deco ñari sĩwiuque. Eropirã mʉhʉ, mʉ wapi mera mʉa wejẽdi yucʉre mehyuque wai ñeamorã, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ĩgʉ eroparĩcʉ̃ peegʉ Simo Jesure yʉhripʉ: —Opʉ, wai wejẽbutahmuarabʉ gʉa dohpagã ñamire. Eropiiquererã ta waire wejẽbiraca gʉa. Eropa wejẽbiriquererã ta mʉ dorero dopa ta mehyu ĩarãra, arĩ yʉhripʉ Simo. ");
INSERT INTO des_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Eropa arĩtuha erã mehyuñorã. Erã eropa mehyucʉ̃ irigʉ wejẽdigʉre bajarã wai ñajañorã. Bajarã erã ñajacʉ̃ wejẽdigʉ yehguea wariyoro. ");
INSERT INTO des_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eropa wacʉ̃ ĩarã erã gajiru majarã erã mera majarãre sihubeoñorã. —Mʉa sã itamuque gʉare, arĩ sihubeoñorã Simo sã. Erã eropa itamura pʉhrʉ peeru gasiru õaro miriparo bocañorã waire. ");
INSERT INTO des_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simo Pedro eropa wai bajarã ñajacʉ̃ ĩagʉ, Jesu pohro mereja, ĩgʉre werepʉ: —Yʉ opʉ, mʉ mera árĩbogʉ árĩbeaa yʉhʉ. Ñegʉ ãhraa. Eropigʉ yʉre duhuque, arĩpʉ Simo Jesure. ");
INSERT INTO des_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ĩgʉ árĩpehrerã ĩgʉ mera majarã sã wai bajarã ñajacʉ̃ ĩarã, ʉca wañorã erã sã. ");
INSERT INTO des_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Perã Simo mera majarã Zebedeo porã Santiago ĩgʉ pagʉ magʉ Ñu mera, erã sã ĩha ʉca wañorã. Eropa ʉcacʉ̃ ĩagʉ Jesu Simo Pedrore werepʉ: —Güibita. Dohpaguere waire ñeha gameneogʉ mʉ árĩro dopa ta Goãmʉ yarã árĩmorãre sihu gameneogʉ árĩgʉca mʉhʉ, arĩpʉ Jesu Simore. ");
INSERT INTO des_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ĩgʉ eropa arĩra pʉhrʉ erã erã gasire imiporo taramujupicã, erã ya árĩpehrerire ero ta apicã, Jesu mera waha wañorã. ");
INSERT INTO des_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesu gaji maca ĩgʉ árĩcʉ̃ cami boagʉ ĩgʉ pohrogue erapʉ. Eropigʉ ĩgʉ Jesure ĩagʉ mereja turaro serẽpʉ: —Opʉ, mʉhʉ yʉre õagʉ iidiagʉ yʉre õagʉ iimasia mʉhʉ, arĩ serẽpʉ. ");
INSERT INTO des_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ĩgʉ eropa arĩra pʉhrʉ Jesu ĩgʉre mohmepiñagʉ õpa arĩpʉ: —Irire iidiaa. Dohpaguere õagʉ árĩque mʉhʉ, arĩpʉ. Ĩgʉ eroparĩcʉ̃ ta ĩgʉ cami boara mʉra yaria wayoro. ");
INSERT INTO des_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Eropigʉ Jesu ĩgʉre dorepʉ: —I yʉ mʉre õpa iirare gajirãre ne werebiricãque. Mʉ ya dʉpʉre õarare pahire ĩhmugʉ waque, “Õaro ãhrimi,” arĩdoregʉ. Tuhajanugu Moisere Goãmʉ ĩgʉ apidiro dopa ta iique. Eropigʉ Goãmʉ wihigue mirimagʉre asũwahgã apique mʉ dore tarirare masa árĩpehrerã masimaja õaro, arĩpʉ Jesu cami boadigʉre. ");
INSERT INTO des_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","“Werebita,” ĩgʉ arĩquerecʉ̃ ta árĩpehrerogue masa ĩgʉ iirare weresiripehoñorã. Erã eropa quere peerã masa bajarã Jesu pohrogue ejañorã. Dorecʉrã õarã wadiarã erã sã ĩgʉ pohrogue ejañorã. ");
INSERT INTO des_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Erã eropa ejaquerecʉ̃ ta Jesu masa marirogue Goãmʉ ĩgʉ Pagʉre serẽgʉ waha wapʉ. ");
INSERT INTO des_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gajinʉ Jesu ĩgʉ buhecʉ̃ fariseo masa, judio masare buherã sã ero doañorã. Erã árĩpehrerã Galilea macari majarã, Judea macari majarã, Jerusalén majarã árĩñorã. Eropigʉ Jesu Goãmʉ turari mera dorecʉrãre õarã iipʉ. ");
INSERT INTO des_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Irisubu bajamerãgã ʉma dʉpʉ bʉhadigʉre oyariñe mera coã erañorã. Eropirã ĩgʉre Jesu pohro apidiarã, wihigue aĩ ñajariñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Eropa ñajadiaquererã masa bajarã árĩcʉ̃ erã ĩgʉre aĩ ñaja masibiriñorã. Eropirã ĩgʉre wihi wecague aĩ mʉrija, miri gobe aĩ wea iri gobegue dʉpʉ bʉhadigʉre oyariñe mera pihri dijuñorã Jesu pohro árĩrã watope. ");
INSERT INTO des_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","“Jesu ihĩ ĩgʉ dorecʉrire taricʉ̃ iigʉcumi,” arĩ pepiñorã erã. Erã eroparĩ pepicʉ̃ masigʉ Jesupʉ dorecʉgʉre õpa arĩ werepʉ: —Mahgʉ, mʉ ñero iirare yʉhʉ cóãtuhabʉ, arĩpʉ dʉpʉ bʉhadire Jesu. ");
INSERT INTO des_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ĩgʉ eroparĩcʉ̃ peerã fariseo masa, judio masare buherã sã erã basi õpa arĩ pepiriñorã: “Ihĩ eropa arĩ wereniguiri mera Goãmʉre ñero arĩgʉ iimi. Ĩgʉ masʉ mari iro dopa árĩgʉ ĩgʉ masa erã ñerire cóãmasibeami. Goãmʉ dihta masa erã ñeri iirire cóãmasimi,” arĩ pepiriñorã erã. ");
INSERT INTO des_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesu erã pepirire masigʉ õpa arĩpʉ: —¿Duhpirã eropa arĩ pepiri mʉa? ");
INSERT INTO des_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Mʉ ñeri iirire yʉ cóãtuha,” yʉ arĩcʉ̃, “Gʉyagʉ ãhrimi,” yʉre arãa mʉa masibiriquererã ta. “Wahgãnʉgajaque. Curique,” yʉ arĩcʉ̃ yʉ arĩra diaye árĩri árĩcʉ̃ mata masirãca mʉa. ");
INSERT INTO des_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ i yeba majarã erã ñeri iirire cóãmasia yʉhʉ. Mʉa ire masiboro dopa õpa ta ĩgʉ wahgãnʉgacʉ̃ iigʉra, arĩpʉ Jesu. Eropa arĩtuha dʉpʉ bʉhadigʉre õpa arĩpʉ: —Mʉre arĩgʉ iiaa. Wahgãnʉgajaque. Mʉ oyarañere aĩgãque. Mʉ ya wihigue waque, arĩpʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ĩgʉ eroparĩcʉ̃ ta mata árĩpehrerã erã ĩhuro wahgãnʉgaja, ĩgʉ oyarañere aĩ ĩgʉ ya wihigue waha wapʉ. Eropa wagʉ ĩgʉ Goãmʉre umupeogʉ mucubiriri mera õaro wereniguipʉ. ");
INSERT INTO des_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ĩgʉ eropiicʉ̃ ĩarã masapʉ árĩpehrerã ĩha ʉca wañorã. Goãmʉre umupeorã mucubiriri mera õaro wereniguiñorã: —Dohpagãre gajiropa árĩrire ĩabʉ gʉa, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Eropiituha waha, Leví waĩcʉgʉre ĩgʉ mohmeri taribugue ĩgʉ árĩgʉre bocajapʉ Jesu. Levípʉ oparã ya árĩburire masare wajasea coregʉ árĩpʉ. Eropa bocajagʉ ĩgʉre õpa arĩpʉ: —Yʉ mera majagʉ árĩbu arique, arĩpʉ ĩgʉ Levíre. ");
INSERT INTO des_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ĩgʉ eroparĩcʉ̃ Levípʉ árĩpehreri ĩgʉ mohmerare duhucã, Jesu mera waha wapʉ. ");
INSERT INTO des_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pʉhrʉ Leví ya wihi Jesu ya árĩburire bosenʉ iirã iiñorã. Ero bajarã wajasea corerã, gajirã Leví sã mera ba doañorã. ");
INSERT INTO des_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Erã mera Jesu ĩgʉ doacʉ̃ ĩarã bajamerãgã fariseo masa, judio masare buherã mera gua ũrugã Jesu buherãre arĩ dʉyasoñorã: —¿Duhpirã ñero iirã wajasea corerã mera bahari mʉa? arĩ turiñorã erã. ");
INSERT INTO des_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Erã eroparĩcʉ̃ peegʉ Jesu yʉhripʉ erãre. —Dorecʉbirã duhturure amabeama. Dorecʉrã dihta duhturure ahmama. Dorecʉrã duhturu amaro dopa ta “Ñerã ãhraa,” arĩrã yʉre amarãcoma. ");
INSERT INTO des_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eropigʉ “Ñerã ãhraa,” arĩrã dihtare erã ñero iirare bʉjaweredore, õaripʉre gohrotocʉ̃ iigʉ aribʉ yʉhʉ. Erã basi “Õarã ãhraa gʉa,” arĩ pepirãre itamugʉ aribiribʉ yʉhʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eropirã bajamerã masa Jesure õpa arĩ serẽpiñorã: —Ñu buherã bajasuburi Goãmʉ ya árĩburire iimorã ba duhuma. Eropi erã bajasuburi Goãmʉ mera wereniguima. Fariseo buherã sã erã iro dopa ta iima. ¿Duhpirã mʉ buherãpʉ Goãmʉ ya árĩburire ba duhubeari erã? arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Erã eroparĩcʉ̃ Jesu erãre õpa arĩ yʉhripʉ. —Õpa ãhraa iri: Mojoto diridigʉ ĩgʉ bosenʉ iicʉ̃ ĩgʉ mera majarã bʉjawererã ba duhunirã árĩbeama. Ĩgʉ mera árĩrã mucubiriri mera barã iima. Eropa ta yʉ buherã sã yʉ mera árĩrã ba duhumasibeama. ");
INSERT INTO des_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yujunʉ yʉre Goãmʉ aĩcãgʉcumi. Eropa ĩgʉ aĩra pʉhrʉ yʉ buherã mera árĩsome yʉhʉ. Irisubugue ta yʉ buherã ba duhurãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iribojegue maja buheri mama buheri mera erã buhemoresũdiacʉ̃ ĩagʉ õpa arĩ werenemopʉ Jesu erãre. —Ne mama suhrirore miri gasirogã yehgue aĩ, mʉrañe suhrirore seretuma masiya mara. Mari eropa seretura pʉhrʉ mama gasirore mari coecʉ̃, mʉra gasiro árĩro tara gameneo yehgueacʉ̃ iiaa. Eropirã mʉra buheri mama buheri mera wapimoa buhebiricãro gahmea. ");
INSERT INTO des_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Eropirã ne igui decore imisĩri decore waibʉgʉ gasiro ajurore, mʉra ajurore diyebiricãro gahmea. Eropa iicʉ̃ igui deco pahmuro mʉra ajurore yehgue dija wahaa. Iri ajuro yehguecʉ̃ igui deco iri ajuro sã cohmoa wahaa. ");
INSERT INTO des_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Eropirã igui deco mama decore mama ajuro mera diyero gahmea. Eropa ta mama buheri mʉra buheri mera buhebiricãro gahmea. ");
INSERT INTO des_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Vino deco mʉra decore masa erã ihrira pʉhrʉ mama decore gamebeama erã. Õpa arĩma masa. “Vino mʉra deco mama decore õatarinʉgaa,” arĩma masa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gajinʉ Sabado árĩcʉ̃ Jesu ĩgʉ buherã sã trigo pohegue ĩha tariañorã. Erogue tariarã, ĩgʉ buherãpʉ trigo pororire tʉrĩ, gasiri cohro bañorã iriyerire. ");
INSERT INTO des_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Erã eropa iicʉ̃ ĩarã bajamerãgã fariseo masa erãre serẽpiñorã: —¿Duhpirã mʉa Sabado mari soorinʉ árĩquerecʉ̃ ta mohmeri? Mari dorerire tarinʉgarã iiaa, arĩñorã fariseo masa. Erã eroparĩcʉ̃ peegʉ Jesupʉ “Yʉ buherã iri dorerire tarinʉgarã iibeama,” arĩgʉ õpa arĩpʉ erãre: ");
INSERT INTO des_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","—Iribojegue Davi ĩgʉ mera majarã mera oaboagʉ Goãmʉ wihigue ñaja, iri wihi árĩri panre bapʉ. Eropa bagʉ ĩgʉ mera majarã sãre badoregʉ iri panre ópʉ. Iri pan pahia dihtare badorera árĩriyoro. Goãmʉ doreri iri panre gajirãre badorebiriyoro. ¿Davi irire ĩgʉ eropa iirare Goãmʉ yare erã gojarapũgue buhebirari mʉa? Davi i panre bagʉ Goãmʉre tarinʉgagʉ iibiriñumi. Dohpagãre yʉ buherã sã i trigo yerire tʉrĩ barã Goãmʉre tarinʉgarã iibeama. ");
INSERT INTO des_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ inonʉ soorinʉ sãre masa erã iiburire doremasia, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gajinʉ Sabado árĩcʉ̃ Jesu judio masa buheri wihigue ñaja buhepʉ masare. Ero mojoto diayepʉ bʉhadigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ero árĩrã sã bajamerãgã masare buherã, fariseo masa sã Jesure ĩhanʉrʉñorã ĩgʉre weresãdiarã. Õpa arĩ pepiñorã: “Sabadonʉ árĩcʉ̃ ihĩ masʉre õagʉ iibocumi Jesu. Ĩgʉ eropiicʉ̃ ‘Mari soorinʉ Jesu mohmegʉ iimi,’ arĩ weresãrãra,” ari pepiñorã. ");
INSERT INTO des_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesu erã pepirire masigʉ, mojoto bʉhadigʉre õpa arĩpʉ: —Wahgãnʉgajaque. Ohõ arique, arĩpʉ ĩgʉre. Ĩgʉ eropa arĩra pʉhrʉ mojoto bʉhadigʉpʉ wahgãnʉgaja, ero niguipʉ. ");
INSERT INTO des_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Eropigʉ Jesu erãre serẽpipʉ. —Mʉare serẽpigʉra: ¿Mari soorinʉ árĩcʉ̃ õarire iicʉ̃ õabeari? ¿Ñerire iicʉ̃pʉre õhari? ¿Soorinʉ árĩcʉ̃ masʉre masucʉ̃ õhari? ¿O soorinʉ árĩcʉ̃re masʉre wejẽcʉ̃pʉre õhari? arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eropa arĩgʉ Jesu erãre ĩhametupeho, mojoto bʉhadigʉre õpa arĩpʉ daja: —Mʉ mojotore sĩsirãbeoque, arĩpʉ ĩgʉ. Ĩgʉ eroparĩcʉ̃ ta mojoto bʉhadigʉpʉ sĩsirãbeo, õari mojoto wayoro. ");
INSERT INTO des_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ĩgʉ eropa iicʉ̃ ĩarã erã ĩgʉ mera turaro guañorã. —¿Dohpa iirãcuri mari ĩre? arĩñorã erã basi. ");
INSERT INTO des_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Irinʉrire Jesu ʉtãgʉgue Goãmʉre serẽgʉ mʉria wapʉ. Erogue árĩgʉ, ñamire Goãmʉ mera werenigui butahmua wapʉ. ");
INSERT INTO des_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Boyorogue ĩgʉ buherãre ĩgʉ pohro sihubeopʉ. Sihubeotuha erã mera majarãre doce gohra ĩgʉ apimorãre beyepʉ. ");
INSERT INTO des_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Oã árĩñorã Jesu ĩgʉ beyenirã: Simore Jesu Pedro piyudigʉ, Simo pagʉ magʉ Andre, Santiago, Ñu, Felipe, Bartolomé, ");
INSERT INTO des_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Toma, Santiago árĩñorã. Santiagopʉ Alfeo magʉ árĩpʉ. Eropirã Simo celote ya curu majagʉ árĩgʉ, ");
INSERT INTO des_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda Santiago pagʉ magʉ sã, Juda Iscariote sã árĩñorã ĩgʉ beyenirã. Juda Iscariotepʉ Jesure ĩhaturirãre ĩhmubu árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Eropii Jesu ĩgʉ buherã mera ʉtãgʉ weca árĩnirã dijaricʉ̃, bajarã gajirã ĩgʉ buherã mera õari pʉʉgue niguiñorã erã. Gajirã masa sã bajarã árĩñorã. Erã árĩpehrero Judea yeba macari majarã, Jerusalén majarã, Tiro waĩcʉri maca majarã, Sidón waĩcʉri maca majarã, wʉariya tʉro árĩri macari majarã ĩgʉ pohrogue eranirã árĩñorã. ");
INSERT INTO des_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Erã Jesu buherire peerã erarã, erã dorecʉrire taudorerã erarã árĩñorã. Watẽa ñajasũnirã sã ĩgʉ pohrogue eraa, õarã wañorã. ");
INSERT INTO des_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesu ĩgʉ turari mera õarã wacʉ̃ iipʉ erãre. Eropirã erã árĩpehrerã ĩgʉre mohmepiñarã erañorã. ");
INSERT INTO des_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pʉhrʉ Jesu ĩgʉ buherãre ĩha, werepʉ: —Mʉa mojomorocʉrãpʉ Goãmʉ ĩgʉ opʉ árĩroguere warãca mʉa. Eropirã mʉa mucubirirãca. ");
INSERT INTO des_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Dohpaguere mʉa oaboarãpʉ yapirã árĩrãca. Eropirã mucubirirãca. “Mʉa dohpaguere bʉjawere orerãpʉ mucubirimorã ãhraa. Eropirã pʉhrʉguere ĩayerãca. Eropirã mucubirirãca. ");
INSERT INTO des_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. Eropirã yaha árĩburire mʉa iiri dipuwaja gajirã mʉare ĩhaturicʉ̃ mʉapʉ mucubirirãca. Mʉare erã cóãcʉ̃ sãre mucubirirãca. Mʉare erã ñero wereniguiquerecʉ̃ ta, “Ñerã ãhrima,” mʉare arĩquerecʉ̃ ta mʉapʉ mucubirirãca. ");
INSERT INTO des_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mʉare erã eropa iinirãre ʉmarogue mʉa ejacʉ̃gue Goãmʉ mʉare wʉaro õaro iigʉcumi. Eropirã turaro mucubirirã árĩque. Õaro sĩporãcʉrã árĩque. Mʉare ĩhaturirã ta erã acawererã mʉra iribojegue majarã eropa ta ñero iimʉriñuma Goãmʉ yare weremʉhtanirãre. ");
INSERT INTO des_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Eropirã mʉa dohpaguere baja oparãpʉ i yebaguere mʉa õaro árĩtuhabʉ. Eropirã ñero tarirã árĩrãca mʉa. ");
INSERT INTO des_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Dohpaguere yapirãpʉ mʉa oaboarãca. Mʉa eropa árĩrã ñero tarirãca. “Dohpaguere mʉa mucubirirã árĩrãpʉ pʉhrʉguere bʉjawere orerãca. Eropirã ñero tarirãca. ");
INSERT INTO des_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Goãmʉ yare weremʉhtarã ãhraa,” arĩ gʉyarãre “Õarã ãhrima,” arĩriñuma bajarã iribojegue majarã. Mʉa mera majarãre eropa ta “Õarã ãhrima,” arĩbocoma masa. Eropa arĩnirã árĩrãpʉ ñero tarirãca mʉa sã, arĩ buhepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Eropigʉ õpa arĩ buhenemopʉ Jesu: —Yʉre peediarãre, mʉare arĩgʉ tiiaa. Mʉare ĩhaturirã erã árĩquerecʉ̃ erã sãre mahique. Mʉare ĩhaturirãre õaro iique. ");
INSERT INTO des_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mʉare ñero árĩdorerã erã árĩquerecʉ̃ ta õadoreque erãre. Mʉare ñero iirã erã árĩquerecʉ̃ ta, “Erã sã õaro árĩporo,” arĩ serẽbasaque Goãmʉre. ");
INSERT INTO des_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yujugʉ mʉa wayuporã pacʉ̃, “Gajipʉ sãre padiagʉ paque,” arĩque ĩgʉre. Mʉa weca majañe suhrirore ĩgʉ emacʉ̃ mʉa camisa sãre ocãque ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mʉare serẽgʉre ĩgʉ serẽropẽ ta oque ĩgʉre. Mʉa yare ĩgʉ aĩcʉ̃ ĩgʉre dipaturi serẽpibita irire. ");
INSERT INTO des_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gajirã mʉare õaro iicʉ̃ gahmea mʉa. Erãre mʉa õaro iicʉ̃ gamero dopa ta õaro iique erã sãre. Erã õaro iibiriquerecʉ̃ ta mʉapʉ erãre õaro iique. ");
INSERT INTO des_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mʉare umupeorã dihtare mʉa umupeocʉ̃ iri ne duhpiburi árĩbeaa. Ñerã sã eropa ta iima. ");
INSERT INTO des_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Eropirã mʉare õaro iinirã dihtare mʉa õaro iicʉ̃ iri sã ne duhpiburi árĩbeaa. Irire ñerã sã iima. ");
INSERT INTO des_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Eropiro gajirãre wayurã “Yʉre wiaque,” arĩcʉ̃ mʉa wayuri sã ne iri duhpiburi árĩbeaa. Ñerã sã gajirãre wayurã ero pʉhrʉ wiapehodorerã ohoma. ");
INSERT INTO des_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Eropirã mʉapʉ mʉare ĩhaturirãre mahi umupeoque. Eropirã erãre õaro iique. Eropirã mʉa yare mahibirã ta wayuque erãre. Mʉa eropa iicʉ̃ Goãmʉ mʉare õaro iigʉcumi. Goãmʉpʉ ĩgʉre umupeobirã sãre, ñerã sãre õaro iimi. Eropa ta iique mʉa sã. Mʉa eropa iirã wʉaro wajatarãca. Eropirã Goãmʉ turatarigʉ ʉmaro majagʉ porã árĩrãca. ");
INSERT INTO des_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mari Pagʉ ʉmaro majagʉ ĩgʉ mojomoro ĩadiro dopa ta mʉa sã masare mojomoro ĩaque. ");
INSERT INTO des_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Eropigʉ erãre werenemopʉ: —Gajirãre “Ñerã ãhrima,” arĩrã erã iirare were­wʉa­biricãque. Mʉa eropa arĩ werewʉabiricʉ̃ Goãmʉ mʉa sãre “Ñerã ãhrima,” arĩsome. Gajirã mʉare erã ñero iirare, erã ñero arĩra sãre cãdijique. Mʉa eropa cãdijicʉ̃ ĩagʉ Goãmʉ mʉa sãre mʉa ñero iirare cãdijigʉcumi. ");
INSERT INTO des_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gajinore oparã gajirãre oque. Mʉa eropa ocʉ̃ Goãmʉ mʉare ogʉcumi. Eropa ogʉ mʉare õaro queoro wʉaro ogʉcumi. Õaro wajayegʉcumi. Gajirãre mʉa orañepẽ ta mʉa sãre Goãmʉ ogʉcumi, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Eropa arĩtuha Jesu buhenemogʉ õpa arĩpʉ werenigui queori mera: —Cuiri ĩhajabirã erã seyaro erã basi game tʉagãrã erã perãgue ta mehtuha yuriñaja warãcoma gobegue. Eropa ta erã cuiri ĩhajabirã iro dopa ta Goãmʉ yare masibirã sã gajirãre buhediarima. Eropirã erã erã buherã sã peamegue warãcoma. ");
INSERT INTO des_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Buherã erãre buhegʉre masitarinʉgabeama. Eropirã árĩpehrerã buherã erãre õaro buhepehora pʉhrʉ erãre buhegʉ iro dopa ta masirãcoma. Eropirã erãre buherã masibirã árĩbiricãporo, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Eropa arĩtuha gaji buheri mera buhepʉ daja: —Mari werenigui queori mera buhecʉ̃ õpa iirã ãhraa mʉa: Mʉa acaweregʉ ĩgʉ cuirugue miri pogañegã mehñajacʉ̃ iri pogañegãre õaro ĩhaa mʉa. Mʉ yaru cuirupʉre wʉarimijiro árĩquerecʉ̃ irimijipʉre ne pepibeaa mʉa. Eropirã miri pogañegãre mʉa ĩaro dopa ta mʉa acaweregʉ ĩgʉ ñero iiripʉre õaro ĩhaa mʉa. Mʉapʉ mʉa ñero iirire turaro iiquererã ta irire eropa pepicãa. ¿Dohpa árĩrono eropa ãhriri mʉa? ");
INSERT INTO des_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Õpa arĩ wereniguia mʉa acawererãre: “Acaweregʉ, mʉ ñerire iigʉ iica. Eropigʉ iri ñerire duhucãque,” arĩ wereniguia mʉa. Eropa ĩgʉ ñerire duhudorequererã mʉapʉ iri ñerire iirã duhubeaa. ¿Duhpirã mʉa ñerire iiquererã ta irire eropa pepicãri mʉa? Masa erã pʉrʉpʉpʉre ñero ii corerã ãhraa mʉa eropa iirã. Mʉa ñero iiripʉre duhumʉhtaque. Mʉa eropa iira pʉhrʉ mʉa acaweregʉre “Mʉ ñero iirire duhucãque,” arĩ weremasia, arĩ buhepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Eropigʉ buhenemogʉ õpa arĩ werenemopʉ erãre werenigui queori mera: —Yucʉgʉ õadigʉ ñerire dʉcacʉbeaa. Eropiro ñedigʉ sã õarire dʉcacʉbeaa. ");
INSERT INTO des_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yucʉgʉ dʉcare masirã “Irigʉ dʉca ta ãhraa,” arĩ masia mari. Poracʉdigʉ higuera dipure dʉcacʉbeaa. Eropiro aña poragʉ igui tõrire dʉcacʉbeaa. ");
INSERT INTO des_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Eropa ãhrima masa sã. Õagʉ ĩgʉ pepiri õari ãhraa. Eropigʉ ĩgʉ õarire wereniguimi yucʉgʉ õadigʉ irigʉ õarire dʉcacʉro dopa ta. Ñegʉre ĩgʉ pepirigue ñeri ãhraa. Eropigʉ ĩgʉ ñerire wereniguimi yucʉgʉ ñedigʉ irigʉ ñerire dʉcacʉro dopa ta. Mari pepirigue iri árĩro dopa ta wereniguia mari, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Eropigʉ erãre werenemopʉ: —Mʉa yʉre “Opʉ,” arãa. Eropa arĩquererã ta yʉ dorerire iibeaa mʉa. ¿Duhpirã eropa iibeari mʉa? ");
INSERT INTO des_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Árĩpehrerã yʉre gamerã yʉ wereniguirire peema. Eropirã yʉ dorerire tarinʉgabeama. Õpa ãhrima yʉre tarinʉgabirã: ");
INSERT INTO des_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wihi õaro nugudi iro dopa ta ãhrima erã. Ĩgʉ ʉ̃hcãri goberire seha, wihire nugunʉgami. Iri wihi õaro ĩgʉ ʉ̃hcãro nugura wihi árĩro dia miricʉ̃ turaro deco turaquerecʉ̃ iri wihi õaro turaniguia. ");
INSERT INTO des_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Eropirã yʉ wereniguirire peenirã árĩquererã ta yʉ dorerire iibirãpʉ wihire õaro nugubigʉ iro dopa ãhrima. Iri wihire wecagã nugu, õaro iinʉgabeami. Ĩgʉ eropa iira wihi árĩro dia miricʉ̃ deco turacʉ̃ iri wihi mata cohro yuhria wahaa. Eropiro iri wihi cohmopehrea wahaa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iri queori masare weretuha Jesu sã Capernaumgue ejañorã. ");
INSERT INTO des_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ero árĩgʉ cien surara opʉ árĩgʉ ĩgʉ pohro majagʉre turaro mahipʉ. Ĩgʉ pohro majagʉ dorecʉgʉ árĩgʉ sĩriro pohrogue árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Eropigʉ Jesu ĩgʉ iirare peegʉ, judio masa mʉrãre sihu Jesu pohrogue obeopʉ opʉpʉ. —Yʉ pohro majagʉre dorecʉgʉre õacʉ̃ iigʉ arique, arĩ weredoregʉ obeopʉ opʉ mʉrãre. ");
INSERT INTO des_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Erã Jesu pohrogue ejarã, õpa arĩ bʉrigã serẽñorã ĩgʉre: —Surara opʉ gʉare mʉ pohro obeoami. “Yʉ pohro majagʉre dore taubasagʉ ariporo,” arĩ weredoregʉ obeoami. Ĩgʉ opʉ õagʉ ãhrimi. Ĩgʉ eropa árĩcʉ̃ itamuque ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mari ya maca majarãre ĩgʉ mahimi. Eropigʉ ĩgʉ gʉa buheri wihire gʉa iira waja wajayemi, arĩñorã mʉrã Jesure wererã. ");
INSERT INTO des_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Erã eropa arĩ werecʉ̃ peegʉ Jesupʉ erã mera wapʉ. Surara opʉ ya wihi pohro ĩgʉ ejabu iicʉ̃ gohra opʉpʉ ĩgʉ mera majarãre Jesure õpa arĩ weredoregʉ obeopʉ: —Opʉ, õaroca. Aribita. Õagʉ árĩbeaa yʉhʉ. Yaha wihi mʉre ñajaridorebuno árĩbeaa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Eropigʉ mʉ pohro wabirabʉ. Yuju diaye ta mʉ turari mera dorebeoque. Mʉ eropiicʉ̃ yʉ pohro majagʉ õagʉ wagʉcumi. ");
INSERT INTO des_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yʉre yʉ weca árĩrã gajirã oparã dorema. Eropigʉ yʉ sã surarare dorea. Yujugʉre “Waque,” yʉ arĩcʉ̃ ĩgʉ wahami. Gajigʉre “Arique,” yʉ arĩcʉ̃ ĩgʉ ahrimi. Yʉ pohro majagʉre “Ire iique,” yʉ arĩcʉ̃ irire ĩgʉ iimi. Eropigʉ mʉ sã mʉ dorero dopa ta ĩgʉ dorecʉgʉ tarigʉcumi, arĩ weredorepʉ surara opʉ. ");
INSERT INTO des_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesu irire peegʉ, ʉca wa, bajarã masare ĩgʉ mera nʉrʉsiarãre majinʉga werepʉ: —Diaye ta mʉare arĩgʉ iiaa. Ihĩ surara opʉ Israe masʉ árĩbiriqueregʉ Goãmʉre bʉrigã umupeomi. Ĩgʉ pohro majagʉre yʉ õagʉ wacʉ̃ iiburire masituhami. Israe masare ne sihĩ iro dopa umupeorãre ĩanibeaa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ĩgʉ eropa arĩra pʉhrʉ surara opʉ Jesu pohro ĩgʉ obeonirã erã opʉ ya wihigue dujaa wañorã. Dujaja dorecʉdigʉre õagʉ ĩgʉ árĩcʉ̃ ĩañorã erã. ");
INSERT INTO des_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pʉhrʉ ñari Naín waĩcʉri macague Jesu wapʉ. Ĩgʉ buherã bajarã masa sã ĩgʉ mera wañorã. ");
INSERT INTO des_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iri macare ñajaro pohro ĩgʉ ejacʉ̃ sĩridigʉre masa aĩ wiririñorã yaarã warã. Sĩridigʉ pago wapeweyo árĩpo. Yujugʉ ta árĩgʉ igo magʉ sĩria wapʉ. Eropirã ero majarã masa bajarã igo mera wañorã. ");
INSERT INTO des_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Igo eropa wacʉ̃ ĩagʉ Jesu igore mojomoro ĩapʉ. —Orebita, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Eropa arĩgʉ sĩridigʉ ĩgʉ masa porere eja mohmepipʉ. Ĩgʉ eropa mohmepicʉ̃ ĩarã iri porere coãrãpʉ nʉgajañorã. —Mahgʉ, yʉhʉ mʉre õpa arãa. Wahgã doajaque, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ĩgʉ eroparĩcʉ̃ ta sĩridigʉ mʉrʉ wahgã doaja, wereniguipʉ. Eropigʉ Jesu ĩgʉre ĩgʉ pagore wiapʉ. ");
INSERT INTO des_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Eropirã erã árĩpehrerã güirã warã Goãmʉre umupeo õpa arĩñorã: —Goãmʉ yare weremʉhtagʉ masitarigʉ dohpague tamerare mari watope ãhrimi, arĩñorã erã. —Goãmʉ marire ĩgʉ yarãre itamugʉ eratuhami, arĩñorã gajirã. ");
INSERT INTO des_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eropirã árĩpehrerã Judea yeba majarãre ero tʉro árĩri macari majarãre Jesu ĩgʉ iirare masa weresiripehoñorã. ");
INSERT INTO des_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Eropi Jesu ĩgʉ iirare ĩarã Ñure peresu árĩgʉre wereñorã ĩgʉ buherã. Eropa erã werecʉ̃ peegʉ perãre ĩgʉ pohro sihubeo, ");
INSERT INTO des_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesure serẽpidoregʉ obeopʉ Ñu. Õpa arĩ serẽpidorepʉ: —“Yʉ pʉhrʉ gajigʉ arigʉcumi,” ¿Ñu ĩgʉ arĩdigʉ ta ãhriri mʉhʉ? ¿O gajigʉre corerãcuri gʉa? arĩ serẽpidorepʉ Ñu perã ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Eropi erã Jesu pohro eja, serẽpiñorã ĩgʉre: —Ñu waĩyeri masʉ mʉre õpa serẽpidoregʉ obeoami gʉare. “Yʉ pʉhrʉ gajigʉ arigʉcumi,” ¿Ñu arĩdigʉ ta ãhriri mʉhʉ? ¿O gajigʉre corerãcuri gʉa? arĩ serẽpiñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Irisubu ta bajarã dorecʉrãre, watẽa ñajasũnirãre, cuiri ĩhajabirãre õarã iipʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eropigʉ Ñu ĩgʉ obeonirãre Jesu yʉhripʉ: —Dohpaguere mʉa ĩarare mʉa peerare Ñure wererã waque: Õpa arĩque: “Jesu mera cuiri ĩhajabirã ĩhama. Curimasibirã cuhrima. Cami boanirã õarã wahama. Peejabirinirã peea wahama. Sĩrinirã masa wahama,” arĩ wereque. Eropirã mojomorocʉrãre õari buherire yʉ wererare wereque ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Eropa arĩ weretuhaja õpa arĩ wereque Ñure: “Yʉre peegʉ ‘Diaye ta ãhraa,’ arĩgʉ ĩgʉ mucubirigʉ ãhrimi, arĩmi Jesu,” Ñure arĩ wererã waque, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ñu buherã erã wara pʉhrʉ Jesupʉ Ñu árĩricʉrire werenʉgapʉ bajarã masare: —Mʉa masa marirogue Ñu pohrogue warã, ero majare taare miru weãcʉ̃ ĩarã ejabiribʉ mʉa. ");
INSERT INTO des_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Õari suhricʉgʉ sãre ĩabiribʉ mʉa. Õari suhricʉrã waja pagarire suhri sañarã oparã ya wirigue ãhrima. ");
INSERT INTO des_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Masa marirogue ejarã Goãmʉ yare weremʉhtadipʉre ĩarã ejabʉ. Diaye ta Ñu Goãmʉ yare weremʉhtagʉ ãhrimi. Gajirã Goãmʉ yare weremʉhtanirã tauro árĩgʉ ãhrimi Ñupʉ. ");
INSERT INTO des_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iribojegue Goãmʉ yare erã gojarapũ Ñure õpa arĩ wereyuyoro: Mari pagʉ ĩgʉ magʉre õpa arĩpʉ: “Mʉ core mʉre wereyubure obeogʉ iiaa,” arĩmi Goãmʉ, arĩ gojañuma iribojeguere Ñure. ");
INSERT INTO des_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Diaye arĩgʉ iiaa. Masa árĩpehrerã tauro ãhrimi Ñu. Isubure ĩgʉ eropa árĩquerecʉ̃ ta ʉmaroguere Goãmʉ ĩgʉ opʉ árĩroguere árĩpehrerã docanʉgagʉpʉ Ñu tauro árĩgʉcumi, arĩpʉ Jesu masare. ");
INSERT INTO des_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ĩgʉ eroparĩcʉ̃ peerã masa, wajasea corerã mera Ñu ĩgʉ waĩyenirã árĩrã õpa arĩ pepiñorã Goãmʉre: “Goãmʉ diaye iigʉ ãhrimi,” arĩ pepiñorã erã. ");
INSERT INTO des_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo masapʉ, judio masare buherã sã Ñu ĩgʉ waĩyenirã árĩdiabirinirã árĩñorã. Eropirã Goãmʉ erãre ĩgʉ itamudiarire erã gamebiriñorã. ");
INSERT INTO des_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Eropigʉ Jesu dipaturi werepʉ: —¿Dohpague majarã masa ñehmarano iro dopa ãhriri mʉa pepicʉ̃? ");
INSERT INTO des_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Erã majirã iro dopa ãhrima. Erã majirã doberi duarogue bira doarã, õpa arĩ dʉyasoma erãgã erã basi: “Mʉa bayaburire tarisu gʉa purirabʉ. ¿Duhpirã mʉa mucubiri bayarã aribirari? Eropirã gʉa bʉrigã ñehamere orerabʉ. ¿Mʉapʉ duhpirã gʉa mera orebirari?” arĩma dʉyasorã. Erã majirã arĩ dʉyasorã iro dopa ta iirã õpa arãa mʉa dohpague majarã. ");
INSERT INTO des_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ñu waĩyeri masʉ Goãmʉ ya árĩburire ba duhugʉ, vinore ihribirimi. Ĩgʉ eropa ihribiricʉ̃ ĩarã “Pee masibigʉ ãhrimi,” arĩrabʉ mʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yʉpʉ masʉ Goãmʉ ĩgʉ obeodigʉ árĩgʉ yʉhʉ baha ihria. Yʉ eropa iicʉ̃ ĩarã õpa arãa mʉa yʉpʉre: “Ĩaque. Ihĩ wʉaro bagʉ merericʉgʉ sã ãhrimi. Wajasea corerã ñero iirã erã wapicʉgʉ ãhrimi ĩgʉ,” arãa mʉa yʉre. ");
INSERT INTO des_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Eropa masibiriquererã ta gʉa iirare ĩarã, Goãmʉ masirire gʉa opacʉ̃ masirãca mʉa, arĩ werepʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo masʉ Simo waĩcʉgʉ ĩgʉ ya wihigue badoregʉ sihupʉ Jesure. Ĩgʉ eropa sihucʉ̃ Jesu ĩgʉ ya wihigue eja, erã bari mesague doajapʉ. ");
INSERT INTO des_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Iri macaguere ñeri iigo árĩpo. Jesu fariseo masʉ ya wihigue ĩgʉ árĩcʉ̃ igo peepo. Eropa peego alabastro mera iidirure poresuri dicʉdirure aĩ, Jesu pʉrʉpʉ eranʉgara pʉhrʉ orepo. Eropa orego, Jesu guburire igo codeco mera webo, igo poari mera niucóãpo. Ĩgʉ guburi bojocʉ̃ ĩha igo ĩgʉ guburire mihmi, iri poresuri mera pipeopo. ");
INSERT INTO des_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Igo eropa iicʉ̃ ĩagʉ fariseo masʉ Jesure sihudigʉ ĩgʉ basi õpa arĩ pepiripʉ: “Igo ĩgʉre mohmepiñago ñerire iigo ãhrimo. Ihĩ Jesu Goãmʉ ya weremʉhtagʉ árĩgʉ irire masiboñumi,” arĩ pepiripʉ. ");
INSERT INTO des_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ĩgʉ eropa arĩ pepirire masigʉ Jesu werepʉ ĩgʉre: —Simo, dohpague tamerare mʉre werediaa, arĩpʉ Jesu. —Buhegʉ, ¿yʉre dohpa arĩ werediari mʉhʉ? arĩ yʉhripʉ Simo. ");
INSERT INTO des_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ĩgʉ eroparĩcʉ̃ Jesupʉ õpa arĩ buhebu yʉhripʉ: —Opʉre perã wajamorã árĩñuma. Yujugʉ wʉaro wajamogʉ quinientos niyeruseri wajamoñumi. Gajigʉpʉ merogã cincuenta niyeruserire wajamoñumi. ");
INSERT INTO des_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Eropirã erã wajamorire erã wajayegohrabiricʉ̃ ĩagʉ ĩgʉ erã wajamorire cãdijicãñumi. ¿Ĩgʉ eropiicʉ̃ dohpague tamerare nihipʉ erã opʉre mahitarinʉgayuri mʉ pepicʉ̃? arĩ serẽpipʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo yʉhripʉ: —Õbaa, wʉaro wajamodigʉ merogã wajamodigʉ tauro ĩgʉ opʉre mahibocumi, arĩpʉ Simo. —Diaye yʉhria mʉhʉ yʉre, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eropa arĩtuha ĩgʉre pipeodigore maji ĩha, Jesu Simore werenemopʉ: —Igore ĩaque mʉhʉ. Mʉ ya wihire yʉhʉ ñajarara pʉhrʉ yʉ guburi coeburi decore obirabʉ mʉhʉ. Igopʉ igo ya codeco mera yaha guburire coemo. Pʉhrʉ igo ya poari mera tucoeamo. ");
INSERT INTO des_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mʉpʉ yʉre bocatĩri mimibirabʉ. Igopʉ ohõ yʉ doaropẽ yʉ guburire mihmimo. ");
INSERT INTO des_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mʉpʉ yʉ dipurure ʉyʉ mera pipeobirabʉ. Igopʉ yʉ guburire poresuri mera pipeoamo. ");
INSERT INTO des_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Eropa arĩgʉ mʉre weregʉ ta iiaa. Igo igo ñero iira baja gohra ãhraa. Eropigʉ igo ñero iirare cãdijiabʉ. Yʉ eropa iicʉ̃ igo turaro mahiamo yʉre. Erã ñero iirare merogã bʉjawere guñarãpʉ merogã yʉre cãdijidorema. Eropirã erã ñero iirare merogã cãdijisũnirã merogã mahima yʉre, arĩpʉ Jesu Simore. ");
INSERT INTO des_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Eropa arĩtuha ĩgʉ igore werepʉ: —Dohpague tamerare mʉ ñero iirare cohãbʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ĩgʉ eroparĩcʉ̃ peerã Jesu mera doarã erã basi õpa arĩ wereniguiñorã: —Ihĩ diaye ta “Ñerire cóãgʉ iiaa,” arĩmi. ¿Dohpa árĩgʉno ãhriri ĩgʉ ñero iirire cóãgʉ? arĩñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eropigʉ Jesu nomeore õpa arĩ werepʉ: —Yʉre mʉ umupeocʉ̃ mʉre peamegue wabodigore taua. Güiro mariro waque, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pʉhrʉ paga macarigue mʉta macarigãgue sãre eja, Goãmʉ ĩgʉ opʉ árĩrire, õari buherire werepʉ Jesu. Doce ĩgʉ buherãpʉ ĩgʉ mera árĩñorã. ");
INSERT INTO des_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Eropirã nome sã watẽa ñajasũnirã nome, dorecʉnirã nome, Jesu õarã ĩgʉ iinirã ĩgʉ mera árĩñorã. María waĩcʉgo Magdalena erã arĩ piyudigo Jesu mera curipo. Igo siete watẽare Jesu ĩgʉ cóãdigo árĩpo. ");
INSERT INTO des_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana sã Cuza waĩcʉgʉ Herodere itamudigʉ marapo sã Jesu mera curipo. Susana waĩcʉgo sã gajirã nome mera baja erã gajino opari mera ĩgʉre itamuñorã. ");
INSERT INTO des_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Eropi baja macari majarã Jesu pohrogue gamenereñorã. Erã gamenerera pʉhrʉ Jesu ĩgʉ werenigui queori mera erãre werepʉ buhebu: ");
INSERT INTO des_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Oteri masʉ otegʉ wañumi. Ĩgʉ eropa otecʉ̃ gajiyeri ma tʉro yuri merejayoro. Eropirã iriyerire masa cʉradiuñuma. Eropirã mirimagʉ porã bajarã ahri iriyerire bañuma. ");
INSERT INTO des_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eropi gajiyeri ʉtã watope yuri merejayoro. Erore yeba deco mariyoro. Eropiro iriyeri puhri wiriri niguiri ñañia wayoro. ");
INSERT INTO des_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gajiyeri pora yucʉ watope yuri merejayoro. Pora yucʉpʉ puhri tiataria wa, oterayeripʉre wejẽcãyoro. ");
INSERT INTO des_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gajiyeri õari yeba yuri merejayoro. Õaro puhri dʉcacʉyoro. Eropiro baja dʉcacʉyoro, arĩpʉ Jesu. Eropa arĩtuha õpa arĩnemopʉ: —Ire õaro peeque mʉa, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pʉhrʉ ĩgʉ buherã iri werenigui queorire masidiarã, Jesure serẽpiñorã: —¿I queori mera dohpa arĩ buhegʉ iiri mʉhʉ? arĩ serẽpiñorã erã. ");
INSERT INTO des_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Goãmʉ ĩgʉ opʉ árĩrire iribojegue majarã erã masibirirare mʉare masicʉ̃ iimi Goãmʉ. Gajirãpʉre eropa iibeami ĩgʉ. Eropigʉ erãre werenigui queori mera buhea. Yʉ eropa iicʉ̃ erã yʉ buherire peequererã masisome, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Eropa arĩtuha erãre werenemopʉ: —Õpa arĩ werea i werenigui queorire: Oteriyeri õari buheri iro dopa ãhraa. ");
INSERT INTO des_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Eropiro ma tʉro yuri merejariyeripʉ õari buheri iro dopa ãhraa. Eropiro masa erã õari buherire peecʉ̃ ĩagʉ watĩpʉ ahri, iri buherire masidorebeami masare. Ĩgʉ eropa iibiricʉ̃ erã Goãmʉre umupeoboñuma. Erã eropa umupeocʉ̃ ĩagʉ Goãmʉpʉ erãre peamegue wabonirãre tauboñumi. ");
INSERT INTO des_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ʉtã weca yuri merejarayeri õari buheri iro dopa ãhraa. Eropirã masa õari buherire pee, mucubiriri mera irire pee aĩma. Eropa pee aĩquererã ta ʉtã weca árĩri yucʉ nuguri mariri yucʉ iro dopa ta oã masa sã turabeama. Eropa turabirã yaha õari buherire erã peera dipuwaja gajirã erãre ñero iicʉ̃ ĩarã yahapʉre duhucãma. ");
INSERT INTO des_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Eropi pora yucʉ weca yurimerejarayeri õari buheri iro dopa ãhraa. Eropirã masa õari buherire peequererã ta, i yeba majare wʉaro pepirã, niyerure gamerã, i yeba majare gahmema erã. Eropirã iripʉ õari buherire cãhmotaa. Iri cãhmotacʉ̃ masa Goãmʉ gameripʉre iibeama. ");
INSERT INTO des_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Eropi õari yeba yurimerejarayeri õari buheri iro dopa ãhraa. Eropirã masa õari buherire õaro mera pee peenʉrʉcãma. Eropirã duhuro mariro Goãmʉ ĩgʉ gamero dopa ta õarire iima, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Eropa arĩtuha gaji queori mera buhepʉ Jesu. —Ne sihãgodirure masa sihãgora pʉhrʉ mátasoro doca dibubeama. Eropirã irirure cama doca dibubeama. Ʉmarogue irirure duhpeomi wihigue ñajarã erã õaro ĩha ñajama õaro. ");
INSERT INTO des_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mari iiraguere Goãmʉre duhmasiya mara. Pʉhrʉguere árĩpehreri masisũroca. Sihãgodiru ñamire boyoro dopa ta iribojegue erã masibirirare masirãcoma masa. ");
INSERT INTO des_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eropirã mʉa peerã õaro peenʉrʉque. Õaro peenʉrʉgʉ, õaro masigʉcumi. Peenʉrʉbigʉ “Merogã peea,” ĩgʉ arĩquerecʉ̃ iripʉ dederea waroca ĩgʉre, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pʉhrʉ Jesu pagʉ porã erã pago mera ĩgʉ pohrogue warã iiriñorã. Masa bajarã árĩcʉ̃ ĩgʉ pohro ejabiriñorã. ");
INSERT INTO des_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Eropigʉ yujugʉ Jesure werepʉ: —Mʉ pago mʉ pagʉ porã mera disiporogue niguima. Mʉre ĩarã ahrañorã, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ĩgʉ eroparĩcʉ̃ õpa arĩ werepʉ Jesu árĩpehrerãre buhebu: —Goãmʉ buherire peerã, irire tarinʉgabirã erã ta ãhrima yʉ pago yʉ pagʉ porã iro dopa árĩrã, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gajinʉ Jesu ĩgʉ buherã mera dohodirugue ñaja —Ina, taribujarã, arĩ, erã árĩpehrerã iriru mera ditarugue taribuja wañorã. ");
INSERT INTO des_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Eropa taribujagʉ carĩa wapʉ ĩgʉ. Erã eropa taribujarisubu turaro miruñe ariyoro. Miruñe aricʉ̃ pãgúri wahgã, erãre miucãriyoro. Eropa waro mirimaja gʉhya árĩyoro erãre. ");
INSERT INTO des_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eropa wacʉ̃ ĩha ʉca wa, Jesu pohro waha, ĩgʉre wahgũñorã. —Buhegʉ, mari mirimorã iiaa, arĩñorã erã. Erã eroparĩcʉ̃ Jesupʉ wahgã, miruñere “Iripẽta weã duhuque,” arĩpʉ. Eropa arĩgʉ pãgúrire “Yʉsʉaque,” arĩpʉ. Ĩgʉ eroparĩcʉ̃ ta miruñe taria wayoro. Eropiro pãgúri sã yʉsʉ dija wayoro. ");
INSERT INTO des_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Eropa wara pʉhrʉ Jesu erãre õpa arĩpʉ: —¿Mʉa yʉre umupeobeari? Erãpʉ güi, ĩha ʉca, õpa arĩ wereniguiñorã erã basi: —Cue, ¿ñehmʉno masʉ ãhriri ihĩ? Miruñe, pãgúri sã ĩgʉ dorecʉ̃ tarinʉgabeaa ĩgʉre, arĩñorã erã basi. ");
INSERT INTO des_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Eropirã erã gajipʉ masegue Gerasa majarã ya yebague taribujajañorã. Iri yeba Galilea yeba diaye árĩyoro. ");
INSERT INTO des_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ero Jesu ĩgʉ majajanʉgarisubu ero majagʉ watẽa ñajasũdigʉ ĩgʉ pohrogue aripʉ. Ĩgʉ yoari boje goroweregʉ suhri marigʉ árĩgʉ, ĩgʉ wihiguere ne árĩbirimʉripʉ. Eropigʉ masa goberi ʉtã goberi watope árĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Eropirã bajasuburi watẽa ĩgʉre ñearo mera ĩgʉ bʉrigã gorowerecʉ̃ ĩha masa ĩgʉre bihadoboriñorã. Eropigʉ ĩgʉ peresugue árĩgʉ ĩgʉ mojotorire guburire comedari mera erã diridigʉ árĩqueregʉ, ĩgʉ iridarire nuapʉ. Eropirã watẽapʉ ĩgʉre masa marirogue aĩgãñorã. Eropigʉ ĩgʉ Jesure ĩhametu turaro gaguinigui, Jesu pohro merejapʉ. Ĩgʉ eropa iicʉ̃ ĩagʉ Jesupʉ watẽare dorepʉ: —Ihĩ mera árĩbiricãque. Waque watẽa, arĩpʉ. Ĩgʉ eroparĩcʉ̃ peegʉ watẽa ñajasũdigʉpʉ turaro gaguinigui, serẽpipʉ Jesure: —Jesu, ʉmaro majagʉ Goãmʉ magʉ, ¿ñehenore iibu iiri mʉhʉ yʉre? Yʉre ñero iibiricãque, arĩpʉ watẽa ñajasũdigʉpʉ. ");
INSERT INTO des_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ĩgʉ eroparĩcʉ̃ Jesupʉ serẽpipʉ ĩgʉre: —¿Ñehmʉno waĩcʉri mʉhʉ? arĩpʉ. Bajarã watẽa ĩgʉ mera árĩñorã. Eropigʉ õpa arĩpʉ erãre opagʉ. —Watẽa bajarã waĩcʉa gʉa, arĩpʉ watẽa ñajasũdigʉpʉ. ");
INSERT INTO des_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—Ʉ̃hcãri gobegue gʉare wadorebita, arĩ, turaro serẽñorã watẽapʉ. ");
INSERT INTO des_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Irisubure ero ʉtãgʉ gubuye bajarã yesea barã iiñorã. Erã ero bacʉ̃ ĩarã watẽa õpa arĩ serẽñorã Jesure: —Soã yesea pohrogue wadoreque gʉare. Erã mera árĩdoreque gʉare, arĩ serẽñorã watẽa masʉre ñajanirã. Erã eropa arĩ serẽcʉ̃ peegʉ Jesu erãre yesea pohrogue wadorepʉ. ");
INSERT INTO des_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ĩgʉ eropa wadorera pʉhrʉ watẽapʉ masʉ mera árĩnirã waha, yesea pohrogue ejañorã. Erã pohrogue erã ejara pʉhrʉ yeseapʉ gorowere dipatʉrʉgue omabuha, ditarugue yuriñaja miri sĩripehrea wañorã. ");
INSERT INTO des_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yeseare ĩhadibunirãpʉ yesea eropa miricʉ̃ ĩarã, güi omagã wañorã. Eropa omagãrã macague eja, iri maca majarãre campo majarã sãre erã ĩarare weresiripehocãñorã. ");
INSERT INTO des_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Erã eropa werera pʉhrʉ masa ĩarã wañorã. Eropirã Jesu pohro eja, watẽa ñajasũdigʉ mʉrʉ ĩgʉ suhri sañadigʉ pee masigʉ ĩgʉ ero õaro doacʉ̃ ĩañorã erã. Iri árĩpehrerire ĩarã erã güi árĩñorã. ");
INSERT INTO des_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Watẽa ñajasũdigʉ mʉrʉ ĩgʉ õaro árĩcʉ̃ ĩanirã gajirãre erã ĩarare wereñorã. ");
INSERT INTO des_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Eropa pee ero majarã Gerasa yeba majarã árĩpehrerã bʉrigã Jesure güiñorã. Eropirã ĩgʉre wadoreñorã. Erã eropa wadorecʉ̃ Jesu dohodirugue ñajapʉ wabu. ");
INSERT INTO des_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Watẽa ñajasũdigʉ mʉrʉpʉ Jesu ĩgʉ waborore ĩha turaro ĩgʉre serẽripʉ: —Mʉ mera wadiaca, arĩ serẽripʉ. ");
INSERT INTO des_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ĩgʉ eroparĩcʉ̃ Jesu ĩgʉre yʉhripʉ: —Mʉ ya macague waque. Eropa wagʉ Goãmʉ mʉre õaro iirare wereque gajirãre, arĩpʉ Jesu. Ĩgʉ eropa arĩra pʉhrʉ ĩgʉ ya macague ejagʉ Jesu ĩgʉre õaro iirare árĩpehrerãre ĩgʉ ya maca majarãre werepʉ. ");
INSERT INTO des_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sipʉ masegue Jesu dipaturi ĩgʉ taribujajacʉ̃ ĩarã masa bajarã ĩgʉre corenirã bocatĩri serẽñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ero buheri wihi opʉ Jairo waĩcʉgʉ Jesu pohro eja, ĩgʉ guburi pohro merejapʉ. Ĩgʉ mago sĩrigo iipo. Igo yujugo ta árĩgo doce bojori opago árĩpo. Eropigʉ ĩgʉ ĩgʉ ya wihigue Jesure sihugãpʉ. “Áʉ,” arĩ, ĩgʉ mera wapʉ Jesu sã. Ĩgʉ eropa wacʉ̃ masa bajarã ĩgʉre nʉrʉsiarã cʉ̃riro iiñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Eropigo yujugo nomeo doce bojori gohra duhuro mariro eropa behrego ero árĩpo. Ero corere duhturuare igo ya niyeru mera árĩpehrerire wajayeripo igo ocoyedorego. Erã eropa ocoyequerecʉ̃ ta mʉraro ta di waniguicãyoro igore. ");
INSERT INTO des_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Eropigo igo Jesu pʉhrʉ ahri, ĩgʉ suhriro ojogorore igo ñeacʉ̃ igore di wiriniguicãra pehrea wayoro. ");
INSERT INTO des_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Igo eropa ñeañacʉ̃ Jesu pepigʉ serẽpipʉ. —¿Noa yʉ suhrirore mohmepiari? arĩpʉ ĩgʉ. Árĩpehrerã “Mohmepibeaa,” arĩñorã. Eropirã Pedro sã õpa arĩ yʉhriñorã: —Buhegʉ, cʉ̃hña ãhraa. Eropirã masa bajarã mʉre pẽhrecãma. ¿Duhpigʉ eropa arĩ serẽpiri mʉhʉ? arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Dohparagã yʉ turari mera yujugore dore yʉhʉ cóãrare masia. Eropigʉ yʉre igo ñeañarare masia, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ĩgʉ eroparĩcʉ̃ peego igo duhrimasibigo, naragãgo Jesu pohro merejapo. Eropigo árĩpehrerã masa erã peero igo arĩpo Jesure: —Yʉhʉ ñeañabʉ mʉre. “Ĩgʉre ñeañacʉ̃ yʉ dore taria waroca,” arĩgo mʉre ñeañabʉ. Yʉ mʉre eropa ñeañago mata õago wahabʉ, arĩpo. ");
INSERT INTO des_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Igo eropa arĩtuhajacʉ̃ Jesu igore werepʉ: —Mahgo, yʉre mʉ umupeori mera õago dujaa dohpaguere. Mucubiriri mera waque, arĩpʉ igore. ");
INSERT INTO des_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ĩgʉ eropa arĩrisubu Jairo ya wihi árĩgʉ weregʉ erapʉ. —Mʉ mago sĩria wahámo. Eropigʉ ihĩ buhegʉre sihubita pare, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ĩgʉ eroparĩcʉ̃ peegʉ Jairore õpa arĩ werepʉ Jesu: —Bʉjawerebita. Yʉre umupeoque. Iri dihtare iique. Mʉ eropa iicʉ̃ õago wagocumo, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eropa arĩtuha Jairo ya wihigue eja, Pedrore, Ñure, Santiagore, dorecʉgo pagʉ sʉmarãre aĩ ñajapʉ. Gajirãpʉre Jesu ñajadorebiripʉ. ");
INSERT INTO des_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ero árĩpehrerã masa erã ñehamere orerã iiñorã. Jesu erãre arĩpʉ: —Orebiricãque. Igogã sĩribeamo. Carĩgo iimo, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ĩgʉ eroparĩcʉ̃ erãpʉ igo sĩridigo árĩcʉ̃ masirã “Eroparĩcãgʉ iimi ihĩ,” arĩrã Jesure ĩayeñorã. ");
INSERT INTO des_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eropigʉ Jesu igo mojotore ñeha, arĩpʉ igore: —Majigo, wahgãque, arĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ĩgʉ eropa arĩcʉ̃ igo sĩridigo árĩquerego igo sĩporã goecʉ̃ masa wapo. Irisubu ta wahgãnʉgajapo igo. Igo eropa wahgãra pʉhrʉ Jesu igore barire odorepʉ. ");
INSERT INTO des_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Igore eropa ĩgʉ masacʉ̃ ĩarã igo pagʉ sʉmarã ĩhamaria wañorã. Eropigʉ Jesu irire gajirãre weredorebiripʉ. ");
INSERT INTO des_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Eropi Jesu doce ĩgʉ buherãre sihubeo, ĩgʉ turarire ópʉ ĩgʉ erãre. Watẽare erã cóãburire, dorecʉrãre erã õarã iiburire ópʉ ĩgʉ turarire erãre. ");
INSERT INTO des_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Eropa iituha erãre Goãmʉ ĩgʉ opʉ árĩrire buhedoregʉ, dorecʉrãre õarã iidoregʉ obeopʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Õpa arĩ dorepʉ Jesu erãre: —Mʉa warã gajinore aĩbiricãque. Tuadire, ajure, barire, niyerure aĩbiricãque. Yujuñe suhriro ta sañaque. Peñe sañabita. ");
INSERT INTO des_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Árĩpehrerogue mʉare erã carĩro ocʉ̃ iri wihi ta dujanique. Ne warãgue wiriaque iri wihire. ");
INSERT INTO des_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gaji macari majarã mʉare erã gamebiricʉ̃ ĩarã iri macare tarigã waque. Eropa warã mʉa guburi maja nicure moje siripique mʉa erãre erã ya dipuwajare ĩhmumorã, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ĩgʉ eropa arĩra pʉhrʉ ĩgʉ buherãpʉ waha, árĩpehreri macarigue masare õari buherire were curiñorã. Eropirã dorecʉrãre õarã wacʉ̃ iiñorã. ");
INSERT INTO des_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Eropi Herode Galilea yeba majarã opʉ Jesu ĩgʉ iirare peebeopʉ. “¿Noa ãhriri ĩgʉ Jesu?” arĩqueregʉ ne masibiripʉ. Yujurãyeri õpa arĩñorã Jesure. “Ñu waĩyedi mʉrʉ dipaturi masa deyogʉ iicumi. Eropigʉ Jesu erã arĩgʉ ĩgʉ ta ãhrimi,” arĩriñorã gajirã. Erã eroparĩcʉ̃ peegʉ Herode Jesure dohpa arĩ masibiripʉ. ");
INSERT INTO des_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Eropirã gajirã “Ĩgʉ Elia mʉrʉ dohpague dehyoagʉ iimi,” arĩriñorã. Gajirãpʉ “Goãmʉ ya weremʉhtanirã mera majagʉ árĩcumi daja masa mʉrigʉ,” arĩriñorã Jesure. ");
INSERT INTO des_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erã eropa arĩ wereniguiquerecʉ̃ ta õpa arĩ pepipʉ Herode: “Ñu dipurure tabetadoregʉ wejẽtuhabʉ ĩgʉpʉre yʉhʉ. ¿Eropigʉ masa erã werewʉagʉ nihino árĩbocuri ĩgʉ?” arĩ pepi ĩgʉ Jesure ĩadiaripʉ. ");
INSERT INTO des_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Eropi Jesu ĩgʉ obeonirã ĩgʉ pohrogue dujaja, erã iirare wereñorã Jesure. Erã weretuhacʉ̃ Jesu erã dihtare Betsaidague sihu waripʉ. ");
INSERT INTO des_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ĩgʉ erã dihtare sihuquerecʉ̃ erã warare masirã, masa bajarã nʉrʉsiagãñorã. Jesu ĩgʉre erã nʉrʉsiajacʉ̃ ĩagʉ ĩgʉ bocatĩri serẽpʉ erãre. Eropigʉ ĩgʉ Goãmʉ ĩgʉ opʉ árĩrire erãre were, dorecʉrãre õarã iipʉ. ");
INSERT INTO des_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ñamicague doce ĩgʉ buherã ĩgʉ pohrogue eja, Jesure wereñorã: —Ohõ masa marirogue ãhraa. Õ majaro maja wirigue oã masare obeoque. Carĩmorã erã batuburire amadoreque erãre, arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Erã eroparĩcʉ̃ Jesu yʉhripʉ erãre: —Mʉa basi barire oque erãre, arĩpʉ. Ĩgʉ eroparĩcʉ̃ peerã erã yʉhriñorã: —Cinco pan dipurure, perã ta wai sãre iripẽta opaa mari. Oã masa bajarã erã baburire asũmasiya mara marire, arĩñorã ĩgʉ buherã. Bajarã masa erã árĩcʉ̃ eropa arĩñorã ĩgʉ buherã. Eroguere cinco mil ʉma árĩñorã. Eropigʉ Jesu werepʉ ĩgʉ buherãre: —Yujurãyeri cururi cincuenta gohra doadoreque. Gaji curu sãre erã nʉcʉ ta doadoreque, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ĩgʉ eroparĩcʉ̃ ĩgʉ buherã ĩgʉ dorero dopa ta iiñorã. Árĩpehrerã masare doadoreñorã. ");
INSERT INTO des_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Doadoretuha Jesu cinco pan dipurure, perã wai mera aĩ, ʉmarogue ĩhamemuju, Goãmʉre “Õhaa,” arĩpʉ. Ĩgʉ eropa arĩra pʉhrʉ pan dipurure nuha, ĩgʉ buherãre masare gueredoregʉ ópʉ. ");
INSERT INTO des_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eropirã erã árĩpehrerã masa baha yapia wañorã. Erã ba dʉharare doce puiri gohra aĩ gameneo ʉjʉtudoboñorã ĩgʉ buherã. ");
INSERT INTO des_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yujunʉ Jesu yujugʉ ta Goãmʉre serẽgʉ iipʉ. Ĩgʉ wereniguirisubu ĩgʉ buherã ĩgʉ pohrogue árĩñorã. Eropigʉ Jesu serẽpipʉ erãre: —¿Nihino árĩcuri yʉhʉ, masa erã pepicʉ̃? arĩ serẽpipʉ. Ĩgʉ eroparĩcʉ̃ peerã ĩgʉ buherã yʉhriñorã: ");
INSERT INTO des_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—“Ñu waĩyedigʉ mʉrʉ árĩbocumi,” arĩma mʉre. Gajirã “Elia mʉrʉ árĩbocumi,” arĩma. Gajirã, “Goãmʉ ya weremʉhtanirã mera majagʉ iribojegue majagʉ masa mʉriadi árĩbocumi,” arĩma, arĩ yʉhriñorã ĩgʉ buherãpʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Erã eropa arĩra pʉhrʉ Jesu erãre serẽpipʉ daja: —¿Mʉapʉ pepicʉ̃ nihino árĩcuri yʉhʉ? arĩ serẽpipʉ daja. —Mʉhʉ Cristo Goãmʉ ĩgʉ obeodigʉ ta ãhraa, arĩ yʉhripʉ Pedro. ");
INSERT INTO des_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Eropi Pedro “Cristo ãhraa mʉhʉ,” ĩgʉ arĩrare ne gajirãre Jesu weredorebiripʉ. ");
INSERT INTO des_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Eropa weredorebirituhagʉ õpa arĩpʉ: —Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ bʉrigã ñero tarigʉca. Eropa ta tariro gahmea yʉre. Eropirã pahia oparã, mʉrã, judio masare buherã mera yʉre gamebirã wejẽrãcoma. Erã wejẽra pʉhrʉ ʉhrenʉ pʉhrʉ masa mʉriagʉca, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pʉhrʉ árĩpehrerãre õpa arĩ werepʉ Jesu: —Yujugʉ yʉ mera majagʉ árĩdiagʉ, ĩgʉ gamero iidiarire duhucãgʉcumi. Eropigʉ yahagʉ ĩgʉ árĩri dipuwaja ñero tarigʉcumi. Ñero tariqueregʉ ta yahare iiniguigʉ árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yujugʉ masʉ ĩgʉ ya árĩburi dihtare pepigʉ dederea wagʉcumi. Eropigʉ yaha árĩburi yʉ gameri dihtare iigʉ árĩpehrerinʉri yʉ mera ʉmaroguere õaro árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yujugʉ masʉ i yeba majare árĩpehrerire opaqueregʉ peamegue wagʉ õarire bocasome. ");
INSERT INTO des_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yujurãyeri yʉ buherire werediarã, “Jesu yagʉ ãhraa,” arĩdiarã gʉhyasĩrirãcoma. Erã eropa iicʉ̃ ĩagʉ yʉ sã erãre eropa iirãre gʉhyasĩrisãgʉca. Yʉhʉ Goãmʉ ĩgʉ obeodigʉ õarã anyua erã gosesiriri mera, yʉ Pagʉ ĩgʉ gosesiriri mera dujarigʉ yʉre gʉhyasĩrinirãre gʉhyasĩrisãgʉca yʉ sã. ");
INSERT INTO des_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Diaye arĩgʉ tiiaa mʉare. Dohpague yujurãyeri mʉa õgue árĩrã mʉa sĩriboro core Goãmʉ ĩgʉ opʉ árĩcʉ̃gue ĩarãca, arĩpʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Eropi ocho nʉri irire ĩgʉ werera pʉhrʉ Jesu Pedrore, Ñure, Santiagore erã dihtare sihupʉ. Eropi waha, Goãmʉ mera wereniguirã wañorã. Ʉtãgʉre mʉria wañorã erã. ");
INSERT INTO des_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Goãmʉre ĩgʉ serẽrisubu Jesu ĩgʉ diapo gohrotoa wayoro. Eropiro ĩgʉ suhri cuimijuri suhri õaro boreri suhri wayoro. ");
INSERT INTO des_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eropa warisubu perã ʉma ĩgʉ pohro dehyoañorã. Ĩgʉ mera wereniguirã iiñorã. Erã iribojegue majarã Elia mʉrʉ, Moise mʉrʉ sã árĩñorã. ");
INSERT INTO des_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Erã ʉmaro maja gosesiriri mera dehyoañorã. Jesu merogã Jerusaléngue ĩgʉ sĩriborore erã Jesu mera wereniguirã iiñorã. ");
INSERT INTO des_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro ĩgʉ mera majarã sã wʉja meretaria carĩrã iiñorã. Eropa carĩquererã ta ʉca wahgã, Jesu gosesiriri ĩha, perã ĩgʉ mera wereniguirã sãre ĩañorã. ");
INSERT INTO des_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moise Elia mera erã warisubu Pedro Jesure õpa arĩpʉ: —Opʉ, mari õre árĩcʉ̃ õadiaa. Ʉhre wihigã gohra iirã. Mʉ ya wihigã, Moise ya wihigã, Elia ya wihigã iirãca, arĩpʉ Pedro. Eropa arĩqueregʉ ta ĩgʉ arĩrare ne masibiripʉ. ");
INSERT INTO des_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ĩgʉ eropa arĩ wereniguirisubu erãre imica curu cãhmotayoro. Eropa cãhmotacʉ̃ ĩarã erã güia wañorã. ");
INSERT INTO des_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eropiro imica curu pohecague Goãmʉ ĩgʉ wereniguiri bʉsʉyoro: —Ihĩ yʉ magʉ yʉ beyedigʉ ãhrimi. Õaro peeque ĩgʉre, arĩri bʉsʉyoro imica pohecague. ");
INSERT INTO des_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Eropa arĩra pʉhrʉ Jesu dihtare ĩañorã erã. Pʉhrʉ erã ĩarare gajirãre werebiriñorã. Ne yujugʉre werebiriñorã dohpa irisubure. ");
INSERT INTO des_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gajinʉ erã ʉtãgʉgue erã dijaricʉ̃ bajarã masa Jesure bocatĩriñorã. ");
INSERT INTO des_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eropigʉ erã mera majagʉ Jesure piyupʉ: —Buhegʉ, mʉre turaro ire serẽdiaa yʉhʉ. Yʉ magʉ yujugʉ ta ãhrimi. Eropigʉ ĩgʉre ĩabasaque mʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Watĩ ñajasũ gorowereniguicãmi. Iri watĩ ĩgʉre ñeha, gaguiniguicʉ̃ ii, tũru naragãcʉ̃ ii, sumutua wacʉ̃ iimʉraa. Eropigʉ ihĩ watĩ yʉ magʉre ñero taricʉ̃ ii, ne duhudiabeami ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉ buherãre iri watĩre cóãdoregʉ turaro serẽrabʉ. Yʉ eropa serẽquerecʉ̃ ta erã irire ne cóãmasibirama, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ĩgʉ eroparĩcʉ̃ Jesupʉ õpa arĩpʉ ero árĩrãre: —Dohpague majarã mʉa ñerã ãhraa. ¿Yʉre ne umupeobirigohracãri? Yoari boje mʉare buherabʉ. ¿Dipẽ yoari boje yʉre garibori mʉa? arĩ turipʉ Jesu. Eropa arĩtuha watĩ ñajasũdigʉ pagʉre õpa arĩpʉ: —Mʉ magʉre aĩgãrique, arĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ĩgʉ eropa arĩra pʉhrʉ ĩgʉ magʉ Jesu pohrogue ĩgʉ aririsubu watĩ ĩgʉre yebague mehmereja, tũru naragãcʉ̃ iipʉ. Ĩgʉ eropa iicʉ̃ Jesu watĩre cóãpʉ. Ĩgʉ eropa cóãcʉ̃ watĩ ñajasũdigʉ õagʉ wapʉ. Eropigʉ Jesupʉ ĩgʉgãre wiapʉ ĩgʉ pagʉre. ");
INSERT INTO des_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Árĩpehrerã masa Goãmʉ turari mera ĩgʉ õagʉ wacʉ̃ iirire ĩarã, ʉca wañorã. Masa Jesu ĩgʉ iirare ĩha ʉca wacʉ̃ Jesupʉ ĩgʉ buherãre õpa arĩ werepʉ: ");
INSERT INTO des_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Dohparagã yʉ wereburire cãdijibiricãque mʉa. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. Masa yʉre ñeha, gajirãguere yʉre wiarãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ĩgʉ eropa arĩquerecʉ̃ ta erãpʉ ĩgʉ wererire õaro peebiriñorã. Ĩgʉ wererare erãre masiya mariyoro. Irisubu ta Goãmʉ erãre irire masidorebirinipʉ. Eropirã erã güirã irire ĩgʉre serẽpibiriñorã. ");
INSERT INTO des_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pʉhrʉ Jesu buherã werenigui dʉyasorã iiñorã: —¿Mari mera majagʉ nihinopʉ opʉ ñajagʉcuri? arĩ dʉyasorã iiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Erã eroparĩcʉ̃ Jesupʉ erã pepirire masigʉ, majigʉre ĩgʉ pohro aĩunugu, ĩgʉ buherãre werepʉ: ");
INSERT INTO des_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Yaha árĩburire iimorã õpa árĩgʉgãre bu árĩgʉre gamerã yʉ sãre gahmea mʉa. Eropirã yʉre gamerã, yʉre obeodigʉ sãre gahmea mʉa. Mʉa mera majagʉ mʉa pohro majagʉ árĩgʉ ĩgʉ sã opʉ ta árĩgʉcumi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pʉhrʉ Ñu Jesure õpa arĩ werepʉ: —Buhegʉ, mʉ waĩ mera watĩ ñajasũnirãre taricʉ̃ iiami yujugʉ. Ĩgʉre gʉa ĩabʉ. Ĩgʉ mari mera majagʉ ĩgʉ árĩbiricʉ̃ ĩarã ĩgʉre irire iidorebirimʉrabʉ gʉa, arĩpʉ Ñu Jesure. ");
INSERT INTO des_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ĩgʉ eroparĩcʉ̃ Jesu Ñure gajirã ĩgʉ buherã sãre õpa arĩ werepʉ: —Eropa arĩbiricãque mʉa ĩgʉre. Marire ĩhaturibigʉ árĩgʉ, ĩgʉ mari mera majagʉ ãhrimi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Irisubure Jesu ĩgʉ ʉmʉsigue ĩgʉ waboro coregã “Jerusaléngue wagʉra,” arĩpʉ ĩgʉ. Eropa arĩgʉ wagʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Eropirã Jesu core ĩgʉ obeonirã waha, Samaria yeba maja macague eja, ero Jesu ĩgʉ ejaborore amuyudiariñorã. ");
INSERT INTO des_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jesu Jerusaléngue wabu iipʉ. Erogue ĩgʉ wabu árĩcʉ̃ peerã, iri maca majarã ĩgʉre gamebiriñorã. ");
INSERT INTO des_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Irire peerã Ñu, Santiago mera wereñorã Jesure: —Opʉ, mʉ gamecʉ̃ ʉmaro maja peame mera mʉre gamebirinirãre wejẽdorerãra Elia mʉrʉ ĩgʉ iidiro dopa ta, arĩñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Erã eroparĩcʉ̃ maji ĩha turipʉ erã perãre: —Eropa arĩbiricãque. Espíritu Santo yarã ãhraa mʉa. Dohpague mʉa pepiro dopa ta ĩgʉpʉ pepibeami. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ i yebaguere arigʉ peamegue wabonirãre taugʉ aribʉ. Masare erã dederecʉ̃ iigʉ aribiribʉ, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Eropa arĩ weretuha gaji macague Jesu sã carĩrã waha wañorã. ");
INSERT INTO des_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Maha erã wacʉ̃, yujugʉ masʉ Jesure werepʉ: —Mʉ mera yʉhʉ wadiaa noho mʉ wadiaro, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ĩgʉ eropa arĩra pʉhrʉ Jesu yʉhripʉ: —Yʉ mera aricʉ̃ diasa ãhraa. Nʉgʉ majarã diayea erã carĩburi toreri opama. Mirimagʉ porã sã erã ya suhri opama. Yʉ masʉre Goãmʉ ĩgʉ obeodigʉpʉre sooro mara. Ne yaha wihi mara. Eropirã yʉ mera árĩrã ñero tarirãca mʉa, arĩ yʉhripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pʉhrʉ gajigʉre Jesu sihupʉ: —Yʉ mera majagʉ árĩbu arique, arĩpʉ. Ĩgʉ eroparĩcʉ̃ ĩgʉ yʉhripʉ Jesure: —Opʉ, yʉhʉ yʉ pagʉ sĩricʉ̃ yaanigʉ wagʉra. Pʉhrʉ mʉ mera wagʉra, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ĩgʉ eroparĩcʉ̃ Jesu werepʉ: —Yʉre gamebirã sĩrinirã iro dopa ta ãhrima. Erãpʉ sĩrinirãre yaaporo. Eropigʉ mʉpʉ Goãmʉ ĩgʉ opʉ árĩrire õari buherire buhegʉ arique, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Eropigʉ gajigʉ Jesure õpa arĩpʉ: —Opʉ, mʉ mera wagʉra. Yʉ acawererãre goeriserenigʉ wanigʉra dohpa, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ĩgʉ eroparĩcʉ̃ werepʉ Jesu ĩgʉre: —Mohmebu mohmediabigʉ ĩgʉ duhpibu árĩbeami. Ĩgʉ iro dopa árĩgʉ õpa ãhrimi: “Goãmʉ yare iidiaa,” arĩqueregʉ irire ne iibeami. Ĩgʉ Goãmʉ yagʉ árĩbodigʉ árĩbeami, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pʉhrʉ Jesu gajirã ĩgʉ buherãre setenta buherãre beye, macarigue ĩgʉ waboro core obeoyupʉ. Yujuyeri macarire perã dihta obeopʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Eropa obeogʉ õpa arĩ werepʉ erãre werenigui queorire buhegʉ: —Ojodʉca baja iri bʉgatuhajacʉ̃ baja árĩcʉ̃ baja mohmeri ãhraa. Mohmeri masapʉ bajamerãgã ãhrima. Eropa ta õari buherire peemorã bajarã árĩcʉ̃ wʉaro ãhraa mari mohmeri. Iri eropárĩquerecʉ̃ ta mari masare buhemorã bajamerãgã ãhraa. Eropirã õari buherire buhemorãre gajirãre ĩgʉ obeomorãre Goãmʉre serẽque mʉa. ");
INSERT INTO des_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Waque mʉa. Mʉare yʉ obeogʉ oveja iro dopa árĩrãre mʉare yeea guarã iro dopa ta ñerã árĩrã watopegue obeogʉ iiaa. ");
INSERT INTO des_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Niyeru ajure, paga aju sãre, zapature aĩbiricãque. Mʉa mague curirã gajirãre bocajarã wereniguibiricãque. Diaye ta taria waque. ");
INSERT INTO des_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Árĩpehreri wirire mʉa ñajari wirire i wihi majarãre, “¿Ãhriri mʉa?” arĩmʉhtaque. ");
INSERT INTO des_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Iri wihi majarã õaro mera árĩrã gamequeãro mariro erã árĩcʉ̃ õadoreque erãre. Õaro mera erã árĩbiricʉ̃ iri wihi majarãre irire õadorebita. ");
INSERT INTO des_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yuju wihi ñajanʉgarã erã õaro árĩcʉ̃ iri wihi ta dujaque. Iri wihi majarã mʉare erã ejorire baha ihrituque. Mohmegʉre ĩgʉ wajatarire aĩro gahmea. Eropirã mʉa erãre buhera waja erã bari orire aĩque mʉa sã. Eropirã yuju wihi ta mʉa ejara wihi ta ñajarã, iri macare gajirã ya wirigue árĩcuribiricãque. ");
INSERT INTO des_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Macaguere mʉa ejarã ero majarãpʉ mʉare gamerã árĩcʉ̃ erã bari ejori árĩcʉ̃ baque. ");
INSERT INTO des_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ero majarã dorecʉrãre õarã iique. Eropirã õpa arĩque ero majarãre: “Goãmʉ mari Opʉ dohpaguere ĩgʉ árĩborore wererã iiaa mʉare,” arĩque erãre. ");
INSERT INTO des_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gaji macague mʉa ejacʉ̃ erãpʉ mʉare gamebiribocoma. Erã gamebiricʉ̃ ĩarã iri maca decogue waha, õpa arĩque erãre. ");
INSERT INTO des_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Gʉa nicu imicare guburi maja imicare wejẽsiri cóãrã iiaa mʉa gʉare gamebiriri dipuwaja ĩhmurã,” arĩque. “Eropirã ire guña árĩque,” arĩque. “Goãmʉ mari Opʉ dohpaguere ĩgʉ árĩborore mʉare wererã arirabʉ,” arĩque erãre. ");
INSERT INTO des_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mʉare diaye yʉhʉ arĩgʉ iiaa. I ʉmʉ pehrecʉ̃guere Sodoma majarã mʉra bʉrigã dipuwajacʉrãcoma. Erã eropa árĩquerecʉ̃ ta tauro mʉare gamebirãpʉ dipuwajacʉrã árĩrãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Pʉhrʉ Jesu õpa arĩpʉ macari majarãre: —Corazín majarã, mʉa ñero tarirãca. Betsaida maca majarã mʉa sã ñero tarirãca. Mʉa ya macaguere Goãmʉ ĩgʉ turari mera deyoro moarire iirabʉ yʉhʉ. Mʉa peebirabʉ. Iribojegue Tiro waĩcʉri macare, Sidón waĩcʉri maca sãre ĩgʉ turari mera iri deyoro moarire yʉ ii ĩhmucʉ̃ ĩarã ero majarãpʉ erã ñero iirire bʉjawereboañuma. Eropa iirã õaripʉre gohrotoboañuma. Mata erã bʉjawererã erã bʉjawereri suhrire saña, erã basi pea witũ mera mohsiripeoboañuma erã ñerire bʉjawererire ĩhmumorã. Mʉapʉ eropa iibeaa. ");
INSERT INTO des_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Eropigʉ mʉare arĩgʉ tiiaa. Goãmʉ ĩgʉ dipuwaja moarinʉ árĩcʉ̃ Tiro majarã mʉra, Sidón majarã mʉra tauro mʉapʉre mʉa ñeri dipuwaja dipuwaja moagʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum majarã, mʉa ejatuharo mera Goãmʉ pohrogue wadiaribʉ. Eropirã mʉa Goãmʉ yapʉre iidiabiricʉ̃ mʉare Goãmʉ peamegue cóãgʉcumi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Eropa arĩtuha ĩgʉ buherãre werepʉ: —Mʉare peerã yʉ sãre peema. Mʉare gamebirã yʉ sãre gamebeama. Eropirã yʉre gamebirã, erã yʉre obeodigʉ sãre gamebeama, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pʉhrʉ setenta buherã mucubiriri mera dujarañorã: —Opʉ, mʉ waĩ mera mʉ turari mera watẽare masaguere gʉa wiridorecʉ̃ erãpʉ gʉare yʉhriama, arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Erã eroparĩcʉ̃ Jesu yʉhripʉ erãre: —Ʉmarogue miariñe dijariro dopa ta watĩ ĩgʉ dijaricʉ̃ ĩabʉ. ");
INSERT INTO des_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Peeque. Mʉare yʉ turarire ohabʉ yʉhʉ. Eropirã añare, corebare, watĩ marire ĩhaturigʉre árĩpehreri ĩgʉ turari sãre mʉa tarinʉgaburire mʉare ohabʉ yʉhʉ. Eropirã erã mʉare ñero iimasibeama. ");
INSERT INTO des_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yʉ eropa oquerecʉ̃ ta watẽa mʉare erã tarinʉgabiricʉ̃ ĩarã iri dihtare mucubiribita. Ipʉre mucubirique. Ʉmarogue Goãmʉ yarã erã waĩre ĩgʉ gojaturipũgue mʉa waĩre ĩgʉ gojatura árĩcʉ̃ masirã, iripʉre mucubirique mʉa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Irisubure Espíritu Santo Jesure bʉrigã mucubiricʉ̃ iipʉ. Eropigʉ Jesu õpa arĩpʉ ĩgʉ Pagʉre: —Ahʉ, mʉhʉ ʉmaro majarã tauro opʉ, i yeba majarã tauro opʉ ãhraa. I mʉ buherire “Masituhaja gʉa,” arĩrãre masicʉ̃ iibeaa. Mʉ yare masipehobirãpʉre masicʉ̃ iiabʉ mʉhʉ. Mʉ eropa iicʉ̃ ĩagʉ “Õataria,” arãa yʉhʉ mʉre. Eropa ta ãhraa, ahʉ. Erã masibirãpʉre erã masicʉ̃ gahmeabʉ mʉhʉ, arĩpʉ Jesu. Eropa arĩtuha gajirãre õpa arĩpʉ: ");
INSERT INTO des_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","—Yʉ Pagʉ árĩpehrerire yʉ iiburire apimi yʉre. Yʉ Pagʉ dihta yʉre masimi. Yʉ dihta ĩgʉre masia. Yʉ beyenirã sã ĩgʉre masima yʉ masidorenirã árĩrã. Erã nʉcʉ ta yʉ Pagʉre masia gʉa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ĩgʉ eropa arĩra pʉhrʉ erã seyaro erã árĩcʉ̃ Jesu ĩgʉ buherãre õpa arĩpʉ: —I árĩpehrerire ĩarã mucubirirã ãhraa mʉa. ");
INSERT INTO des_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Diaye ta ãhraa. Bajarã Goãmʉ ya weremʉhtanirã, yebari majarã oparã sã dohpague mʉa ĩarire ĩadiariñorã erã sã. Eropirã mʉa peeri sãre peediariñorã. Erã eropa masidiaquerecʉ̃ ta Goãmʉ erãre masidorebiripʉ irisubuguere, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Irisubu ta judio masare buhegʉ Jesu pohro eraa, Jesure ĩgʉ ñero wereniguicʉ̃ iidiaripʉ: —Buhegʉ, ¿yʉ árĩpehrerinʉri Goãmʉ mera árĩdiagʉ dohpa iigʉcuri yʉhʉ? arĩ serẽpipʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ĩgʉ eroparĩcʉ̃ Jesu yʉhripʉ ĩgʉre: —¿Dohpa arĩ irire wereri Goãmʉ yare erã gojarapũgue? ¿Goãmʉ ĩgʉ arĩ gojarapũguere ĩgʉ mera õaro árĩdiarire dohpa arĩri mʉ pepicʉ̃? arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ĩgʉ eroparĩcʉ̃ ĩgʉ yʉhripʉ: —Õpa arĩñumi Goãmʉ: “Turaro mʉ sĩporã mera, mʉ turari mera, mʉ õaro guñari mera Goãmʉre mahique. Eropigʉ mʉ basi mahiro dopa ta mʉ pohro árĩrã sãre mahique,” arĩ apiñumi Goãmʉ marire, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ĩgʉ eroparĩcʉ̃ Jesu yʉhripʉ: —Diaye ta arãbʉ mʉhʉ. Irire iique. Eropigʉ árĩpehrerinʉri Goãmʉ mera árĩgʉca mʉhʉ, arĩpʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ĩgʉ masare buhegʉpʉ “Ihĩ Goãmʉ ya dorerire iipehogʉ ãhrimi,” masa ĩgʉre erã arĩ pepicʉ̃ gamepʉ. Eropa gamegʉ ĩgʉ Jesure õpa arĩ serẽpinemopʉ: —¿Noa ãhriri Goãmʉ yʉre mahidoregʉ? arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ĩgʉ eroparĩcʉ̃ Jesupʉ õpa arĩ yʉhripʉ Samaria majagʉ ĩgʉ iirare weregʉ: —Yujunʉ Jerusaléngue árĩdigʉ Jericógue wagʉ maha ĩgʉ curicʉ̃ yajari masa ĩgʉre ñeañorã. Eropa ñearã ĩgʉ suhrirore tuwea aĩ, ĩgʉre turaro pañorã. Eropa parã sĩrimerejacʉ̃ gohra duhuñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Irisubu ta pahi iri mague aripʉ. Eropa arigʉ erã padigʉre ĩaqueregʉ ta maha gajipʉ masepʉ ĩgʉre ĩhatarigã wapʉ. ");
INSERT INTO des_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Eropi Goãmʉ wihi mohmegʉ sã mojomorocʉgʉ pohro eja ĩgʉre ĩha gajipʉ masepʉ tarigã wapʉ. ");
INSERT INTO des_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Erã eropiiquerecʉ̃ Samaria majagʉpʉ ero waha yoañarirogue ĩha ĩgʉre mojomoro ĩapʉ. ");
INSERT INTO des_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eropigʉ ĩgʉ mojomorocʉgʉ pohro eja, igui deco vino ʉyʉ mera morera deco mera ĩgʉ camire pisũpʉ. Pisũtuhaja suhri gasiro mera diricãhmotapʉ ĩgʉ camire. Tuhaja, ĩgʉre ĩgʉ yagʉ burro weca duhpeo, carĩri wihigue aĩ ejapʉ ĩgʉre. Ero árĩgʉ ĩgʉ Samaria majagʉ õaro ĩhadibupʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gajinʉ ĩgʉ carĩri wihi opʉre pese niyerusere oho, õpa arĩpʉ: “Ĩre ĩhadibuque. Iseri sihajabiricʉ̃ dipaturi dujarigʉ wajayepehogʉra,” arĩpʉ Samaria majagʉ wihi opʉre, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Eropa arĩtuha judio masare buhegʉre serẽpipʉ Jesu: —¿Oã ʉrerã ʉma mojomorocʉgʉ pohro tarianirã nihinopʉ árĩyuri mojomorocʉgʉre mahigʉ? arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ĩgʉ eroparĩcʉ̃ buhegʉpʉ Jesure yʉhripʉ: —Mojomorocʉgʉre itamudigʉ árĩñumi ĩgʉre mahigʉ, arĩpʉ ĩgʉ Jesure. —Mʉ sã masare eropa ta iigʉ waque, arĩpʉ Jesu buhegʉre. ");
INSERT INTO des_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Eropi Jesu ĩgʉ buherã mera wacʉ̃, gaji macague erã curicʉ̃, Marta waĩcʉgo erãre igo ya wihi ñajaridorepo. ");
INSERT INTO des_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ĩgʉ ñajara pʉhrʉ igo pagʉ mago María waĩcʉgo ĩgʉ guburi pohro doa ĩgʉ buherire peepo. ");
INSERT INTO des_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Igo eropa iicʉ̃ ĩago Marta igo mohmeri baja árĩcʉ̃ ĩago guapo. Eropigo igo Jesure werepo: —Opʉ, ¿yʉhʉ yujugo ta mohmecʉ̃ yʉre yʉ pagʉ mago igo itamubiricʉ̃ õhari mʉ ĩacʉ̃? Igore yʉre itamudoreque, arĩpo Marta Jesure. ");
INSERT INTO des_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Igo eroparĩcʉ̃ Jesu yʉhripʉ: —Marta, baja mʉre mohmeri árĩcʉ̃ wʉaro pepia mʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Goãmʉ ĩgʉ yare peedoremi. María õarire iibo irire beyemo. Eropigʉ yʉre igo peecʉ̃, “Mohmetamugo waque,” arĩbeaa igore, arĩpʉ Jesu Martare. ");
INSERT INTO des_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yujunʉ Jesu ĩgʉ Pagʉre Goãmʉre serẽgʉ iipʉ. Ĩgʉ serẽtuhacʉ̃ yujugʉ ĩgʉ buherã mera majagʉ õpa arĩpʉ: —Opʉ, Ñu ĩgʉ buherãre ĩgʉ buhediro dopa ta Goãmʉre serẽrire gʉa sãre buheque mʉhʉ, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu erãre werepʉ: —Õpa arĩ Goãmʉre serẽque: “Gʉa Pagʉ, ʉmaro majagʉ mʉhʉ õagʉ ãhraa. Dohpaguere árĩpehrerã weca opʉ ãhraa. Ʉmaroguere mʉ dorero erã iiro dopa ta i yeba majarã sã iiporo. ");
INSERT INTO des_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Eropigʉ ʉmʉri nʉcʉ gʉa baburire oniguicãque gʉare. ");
INSERT INTO des_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gajirã erã gʉare ñero iirare gʉa cãdijiro dopa ta mʉ sã gʉa ñero iirare cãdijique. Eropigʉ gʉa ñeri iiborare cãhmotaque. Gʉa ñeri iiborare tauque,” arĩ serẽque Goãmʉre, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pʉhrʉguere ĩgʉ buherãre õpa arĩ buhepʉ werenigui queori mera: —Yujugʉ ñami deco ĩgʉ acaweregʉ wihigue waha, ĩgʉre serẽpʉ: “Acaweregʉ, ʉreru pan dipure oque yʉre. ");
INSERT INTO des_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gajigʉ yʉ acaweregʉ curigʉ aridigʉ dohparagã yaha wihi erami. Eropiro ĩgʉre yʉ oburi mara,” arĩpʉ ĩgʉ ĩgʉ acaweregʉre. ");
INSERT INTO des_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ĩgʉ eroparĩcʉ̃ ĩgʉ acaweregʉ wihi pohecague árĩgʉ yʉhripʉ: “Yʉre garibobita. Disiporo bihadiro ãhraa. Yʉhʉ, yʉ porã mera carĩgʉ iiaa. Wahgãro bejabirica yʉre mʉre barire obudi,” arĩpʉ ĩgʉ acaweregʉ. ");
INSERT INTO des_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","¿Dohpa warocuri serẽgʉpʉre? Diaye arãa mʉare. Ĩgʉ acaweregʉ árĩqueregʉ ta barire obudigʉ wahgãbiripʉ. Ĩgʉ eropa wahgãdiabiriquerecʉ̃ ta bari serẽgʉpʉ gʉhyasĩribigʉ ĩgʉ yoari boje serẽniguicʉ̃ árĩpehreri ĩgʉ serẽro dopa ta pʉhrʉ wahgã ogʉcumi. ");
INSERT INTO des_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Eropigʉ ire mʉare weregʉ iiaa: Goãmʉre mari Pagʉre serẽque. Eropa serẽrã mʉa serẽrire bocarãca. Goãmʉre eropa serẽ­niguicãque. Mʉa eropa iicʉ̃ ĩgʉ ogʉcumi. ");
INSERT INTO des_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Árĩpehrerã Goãmʉre serẽrã aĩrãcoma. Eropirã erã serẽrare bocarãcoma. Eropigʉ árĩpehrerã Goãmʉre eropa serẽniguirãre ĩgʉ erãre ogʉcumi. ");
INSERT INTO des_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Mʉa porã mʉare erã pan serẽcʉ̃ ʉtãyepʉre obocuri mʉa? Obiriboya. ¿Erã mʉare erã waire serẽcʉ̃ añapʉre obocuri erãre? Obiriboya. ");
INSERT INTO des_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Eropirã mʉa porã cãreña diuri serẽcʉ̃ corebapʉre obocuri mʉa? Obiriboya. ");
INSERT INTO des_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mʉa ñerã árĩquererã ta mʉa porãre õarire omasia mʉa. Eropigʉ Goãmʉpʉ mʉa tauro õarire ohomi mʉare. Ĩgʉ mari Pagʉ ʉmaro majagʉ ĩgʉ Espíritu Santore ogʉcumi ĩgʉre serẽrãre, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Irisubure Jesu watĩre cóãgʉ iipʉ. Watĩpʉ were­nigui­masibigʉ árĩcʉ̃ iipʉ masʉre. Eropigʉ watĩ masʉre Jesu cóãcʉ̃ masʉpʉ wereniguinʉgapʉ. Ĩgʉ wereniguicʉ̃ peerã masa bajarã ĩhamaria wañorã. ");
INSERT INTO des_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Erã eropa ʉcaquerecʉ̃ ta gajirãpʉ õpa arĩñorã: —Ihĩ Jesu watẽare cóãgʉ Beelzebú waĩcʉgʉ watẽa opʉ ĩgʉ turari mera cohãmi, arĩñorã gajirã. ");
INSERT INTO des_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gajirã “Mʉhʉ Goãmʉ ĩgʉ obeodigʉ árĩgʉ Goãmʉ turari mera deyoro moarire ii ĩhmuque gʉare,” arĩriñorã. ");
INSERT INTO des_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Erã eropa dorecʉ̃ peegʉ erã pepirire masigʉ, erãre õpa arĩ werenigui queori werepʉ Jesu: —Watĩ ya turari mera watẽare cóãbeaa yʉhʉ. Yuju maca majarã erã basi gamequeãrã, iri maca majarã pehrea wabocoma. Eropirã yuju wihi majarã erã basi gamequeãrã, iri wihi majarã pehrea wabocoma. ");
INSERT INTO des_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Eropigʉ Beelzebú watẽa opʉpʉ ĩgʉ turari mera ĩgʉ watẽare yʉre cóãdoregʉ ĩgʉ basi ĩgʉ yarãre cóãbocumi. Eropirã erã sã wapehrea waboñuma. Mʉa yʉre õpa arãa. “Ĩgʉ Beelzebú turari mera watẽare cohãmi,” mʉa yʉre arĩ weresãa. ");
INSERT INTO des_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mʉa mera majarã sã watẽare cohãma. Eropirã erã “Beelzebú ĩgʉ turari mera erãre cohãa,” arĩbeama. “Goãmʉ ĩgʉ turari mera watẽare cohãa,” arĩma. Eropirã mʉa yʉre “Watĩ turari mera watẽare cohãmi,” mʉa arĩra diaye árĩbiricʉ̃ mʉa mera majarã wererãcoma. ");
INSERT INTO des_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Eropigʉ yʉpʉ watẽare cóãgʉ Goãmʉ ĩgʉ Espíritu Santo turari mera iiaa. Yʉ eropa cóãcʉ̃ ĩarã õpa arĩ masirãca mʉa: “Goãmʉ ĩgʉ opʉ árĩri i yebaguere árĩtuhaja dohpaguere,” arĩrãca, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Watĩ turagʉ tarinʉgari werediacʉ̃ õpa ãhraa, arĩpʉ Jesu. —Wihi opʉ turagʉ ĩgʉ mojo mera ĩgʉ wihire ĩhadibucʉ̃ ĩgʉ yare gajirã aĩmasibeama. ");
INSERT INTO des_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ĩgʉ eropa ĩhadibuquerecʉ̃ ta gajigʉ turatarigʉ ĩgʉre gamequeã, ĩgʉre tarinʉga, ĩgʉ mojore emacã, ĩgʉ yare aĩcã gajirãre gueremi. “Watĩ turagʉ árĩquerecʉ̃ yʉhʉ turatariagʉ ãhraa,” arĩgʉ iipʉ Jesu i queori mera. ");
INSERT INTO des_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yujugʉ yʉre gamebigʉ yʉre ĩhaturigʉ ãhrimi. Yujugʉ yʉre itamubigʉ yʉre teboricʉcʉ̃ iigʉ iimi, arĩ buhepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Eropigʉ ĩgʉ dipaturi werenigui queori mera õpa arĩ buhepʉ: —Yujugʉ watĩ masʉ mera árĩdi waha deco mariri yeba cuhri, ĩgʉ sooborore amaripʉ. Eropa bocabigʉ õpa arĩ pepipʉ: “Masʉ yʉ cóãdi mera dipaturi árĩgʉ wagʉra,” arĩ pepipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eropa arĩgʉ ĩgʉ dujaa waha, ĩgʉ cóãdigʉre ta masʉre bocapʉ daja. Ĩgʉre bocaboro core masʉpʉ õagʉ ñeri marigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Eropigʉ watĩ gajirã siete watẽare ĩgʉ tauro ñerãre sihugʉ wapʉ. Ĩgʉ eropa sihucʉ̃ erã árĩpehrerã watẽa masʉ mera árĩñorã. Eropigʉ masʉpʉ ero core yujugʉ watĩre opagʉ ñetariagʉ árĩripʉ. Dohpaguepʉre bajarã watẽare opagʉ árĩgʉ, ero core ĩgʉ árĩdiro tauro ñegʉ dujapʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Irire ĩgʉ eroparĩcʉ̃ masa watope árĩgo Jesure arĩpo bʉsʉro mera: —Mʉre porãcʉdigo, mʉre mihudigo mucubirigo ãhrimo, arĩpo Jesure. ");
INSERT INTO des_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Igo eropa arĩtuhacʉ̃ peegʉ Jesu igore yʉhripʉ: —Goãmʉ wereniguirire peerã ĩgʉ dorerire iirãpʉ erã árĩrãcoma mucubirirã, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eropi bajarã masa Jesu pohro erã eracʉ̃, ĩgʉ erãre werenemopʉ: —Dohpague majarã ñerã ãhrima. Yʉ diaye arĩgʉ árĩcʉ̃ mʉa masidiarã Goãmʉ turari mera deyoro moarire iidoreraa yʉre. Mʉa eropa dorequerecʉ̃ ta Jona iribojegue majagʉ ĩgʉ iira dihtare ii ĩhmugʉcumi Goãmʉ masare. ");
INSERT INTO des_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona Goãmʉ yare weremʉhtadigʉ árĩgʉ ĩgʉ Ninive majarãre ĩgʉ masicʉ̃ iidiro dopa ta yʉhʉ Goãmʉ ĩgʉ obeodigʉ masicʉ̃ iiaa dohpague majarãre. ");
INSERT INTO des_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dipuwaja moarinʉ árĩcʉ̃ iribojegue majago opo bʉro sur majago bʉro igo bʉro wahgãnʉga mʉare dohpague majarãre weresãgocumo. Igo Salomo opʉ ĩgʉ masirire peediago yoarogue aridigo Salomore peego aripo. Dohpaguere mʉa watopere Salomo tauro masigʉ ãhraa. Yʉhʉ mʉa mera árĩquerecʉ̃ mʉa yʉ masirire peediabeaa. Mʉa eropa peediabirira waja igo opo bʉro mʉare “Ñerã ãhrima,” arĩ weresãgocumo. ");
INSERT INTO des_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Eropa ta dipuwaja moarinʉ árĩcʉ̃ Ninive maca majarã mʉra sã mʉare dohpague majarãre “Ñerã ãhrima,” arĩ weresãrãcoma erã. Jona erãre Goãmʉ yare ĩgʉ werecʉ̃ peerã, erã ñerire bʉjawere, õarire gohrotonirã árĩñorã erãpʉ. Dohpaguere mʉa watopere Jona tauro árĩgʉ ãhraa yʉhʉ. Yʉhʉ Goãmʉ yare werequerecʉ̃ mʉa ñero iirare bʉjawerebeaa. Eropirã Ninive majarã mʉra mʉare ñerire bʉjawerebirãre weresãrãcoma, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Eropigʉ buhenemogʉ õpa arĩpʉ erãre: —Masa sihãgodirure sihãgorã dibubeama. Irirure sihãgorã mátasoro docague dibubeama. Irirure ʉmarogue duhpeomi wihigue ñajarirã erã ĩha ñajama õaro. ");
INSERT INTO des_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Mari cuiri mari dʉpʉre sihãgodiru iro dopa ta ãhraa,” arĩ werediacʉ̃ õpa ãhraa. Mʉa pepiro dopa ta iiaa. Mʉa õaro mera pepirã árĩrã õarire iiaa. Mʉa ñero pepirã árĩrãpʉ ñeri dihtare iiaa. ");
INSERT INTO des_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eropirã õaro iique. Mʉa pepirigue ñero árĩbiricãporo. ");
INSERT INTO des_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tuhaja mʉa pepirigue õari árĩcʉ̃, ñeri ne maricʉ̃ õari dihtare pepirãca. Mʉa pepirigue õari árĩcʉ̃ mʉa õarire iirãca, arĩ buhepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesu ĩgʉ buhetuhajacʉ̃ ĩagʉ fariseo masʉ ĩgʉre ĩgʉ ya wihigue badoregʉ sihupʉ. Eropigʉ Jesu ĩgʉ ya wihigue ñaja, erã baro erã mera doajapʉ. ");
INSERT INTO des_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ĩgʉ eropa doajacʉ̃ fariseo masʉpʉ Jesure ĩhanʉrʉgʉ judio masa mojo coeniguiro dopa ta ĩgʉ mojo coebiricʉ̃ ĩagʉ õpa arĩ pepipʉ: “Cuena. ¿Ihĩ duhpigʉ gʉa iro dopa mojo coebeari?” arĩ pepipʉ. ");
INSERT INTO des_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ĩgʉ eropa arĩ pepicʉ̃ masigʉ Jesu ĩgʉre werepʉ: —Mʉa fariseo masa mʉa dorero dopa ta mʉa ihririparire, soropari sãre mʉa coeweaa mʉa õarire iirire ii ĩhmudiarã. Eropa coequererã ta mʉa sĩporãripʉre coebeaa. Eropirã mʉa árĩricʉri mʉa pepiripʉre ne õarire gohrotobeaa. Mʉa pepiriguere gajirã yare yajadiarire ñeri dihta ãhraa. ");
INSERT INTO des_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pee masibirã ãhraa mʉa. Goãmʉ mʉa dʉpʉre iigʉ mʉare pepiri sãre iipʉ. ¿Irire masibeari mʉa? ");
INSERT INTO des_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eropirã mʉa Goãmʉ ya árĩburire iidiarã mʉa pepirire õarire gohrotomʉhtaque. Mʉa eropa iira pʉhrʉ õarire iirã árĩrãca. ");
INSERT INTO des_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mʉa fariseo masa ñero tarirãca. Bari õaro sʉriburi sarire aĩ deara pʉhrʉ diez quẽri iiaa. Tuhaja yujuquẽ ta Goãmʉ wihigue aĩgã apia Goãmʉ dorero dopa ta. Eropa iri dorerire iiquererã ta diaye iirire, Goãmʉre gamerire mʉa ne guñabeaa. Dʉcare mʉa aĩrare merogã Goãmʉ wihire apicʉ̃ õhaa. Eropa iirã õpa iinemoque: Diaye iirire, Goãmʉre gameri sãre iique mʉa. ");
INSERT INTO des_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mʉa fariseo masa ñero tarirãca. Buheri wihigue árĩrã õari doari dihtare gahmea mʉa. Doberi duarogue masa mʉare õaro umupeori mera bocatĩri serẽcʉ̃ gahmea mʉa. ");
INSERT INTO des_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Mʉa judio masare buherã, fariseo masa sã mʉa gʉyaricʉrã ãhraa. Ñero tarirãca mʉa. Masa gobe dibura gobe iro dopa ta ãhraa mʉa. Iri gobe pohro masa tarigãrã pohecague boanirã árĩcʉ̃ masibeama. Eropa ta masa mʉa pohro árĩrã mʉa pepirigue ñeri árĩcʉ̃ masibeama erã, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ĩgʉ eroparĩcʉ̃ peegʉ judio masare buherã mera majagʉ Jesure werepʉ: —Buhegʉ, irire arĩgʉ, gʉa sãre ñero arĩgʉ iica mʉhʉ, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ĩgʉ eroparĩcʉ̃ Jesu yʉhripʉ: —Diaye ta ãhraa. Mʉa masare buherã sã ñero tarirãca. Mʉa gajirãre erã bocatĩubiririre iidorea erãre. Eropa dorequererã mʉapʉ erãre ne merogã itamubeaa iri dorerire erã iiboro dopa. ");
INSERT INTO des_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Eropirã mʉa ñero tarirãca. Goãmʉ yare were­mʉhtanirã mʉra ya masa goberire õaro amuraa mʉa erãre umupeoro dopa ta iirã. Mʉa eropa iiquerecʉ̃ ta iribojegue majarã mʉa acawererãpʉ erãre wejẽñuma. ");
INSERT INTO des_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Erãpʉ Goãmʉ ya weremʉhtanirãre erã wejẽdiro dopa ta mʉa sã iiboya. Eropirã dohpaguere erã masa goberire amuraa mʉa. Eropa amurã mʉa acawererã erãre wejẽrare guñaa mʉa. Erã eropa wejẽrare guñarã “Õaro iiñuma,” arĩraa mʉa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Eropigʉ Goãmʉ ĩgʉ masiri mera õpa arĩ wereyuñumi: “Yahare weremʉhtamorãre yʉ buherire buhemʉhtamorã sãre obeogʉra erãre. Eropirã erã yʉ obeorãre gajirãre wejẽ, gajirãre ñero iirãcoma,” arĩyuñumi Goãmʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","I yebare Goãmʉ ĩhacũnugura pʉhrʉ Caínpʉ Abelre wejẽñumi. Ero pʉhrʉ Goãmʉ yare weremʉhtanirãre wejẽñuma. Pʉhrʉ Zacaríare mʉa acawererã mʉra ta ĩgʉre wejẽñuma. Ĩgʉ Goãmʉ wihi pohro Goãmʉ ya árĩburire waimʉrã soeburi mesa pohro árĩcʉ̃ mʉa acawererã ĩgʉre wejẽñuma. Árĩpehrerã erãre erã wejẽra dipuwaja dohpague majarã dipuwajacʉrãcoma. Eropa ta ãhraa. Mʉare ta arĩgʉ iiaa. Árĩpehrerã erãre erã wejẽra dipuwajare dohpague majarãre Goãmʉ dipuwaja moagʉcumi. ");
INSERT INTO des_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mʉa masare buherã, mʉa ñero tarirãca. Goãmʉ masirire ĩgʉ gojarare opaquererã ta gajirãre werebeaa mʉa. Mʉa basi Goãmʉ yare peebeaa. Eropirã gajirã ĩgʉ yare erã peediaquerecʉ̃ ta irire mʉa erãre peedorebeaa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Ĩgʉ eroparĩcʉ̃ peerã judio masare buherã, fariseo masa sã ĩgʉ mera guarã ĩgʉre ñero wereniguiñorã. Eropirã Jesu ĩgʉ ñero arĩ yʉhricʉ̃ peediarã, erã serẽpinʉrʉñorã ĩgʉre weresãdiarã. ");
INSERT INTO des_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Eropi Jesu pohro masa bajarã gohra gamenereñorã. Cʉ̃hña taricãyoro. Ero Jesu ĩgʉ buherãre õpa arĩ werepʉ: —Õaro guña masique mʉa. Fariseo masa erã pan bʉgacʉ̃ iiburire ĩarã õaro masique. Erã gʉyarire weregʉ iiaa. ");
INSERT INTO des_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Masa erã yayasãrare pʉhrʉ masirãcoma. Erã dibura sãre gajirã masirãcoma. ");
INSERT INTO des_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eropiro gajirã peebirogue mʉa wereniguirare õaro masicʉ̃ Goãmʉ weregʉcumi. Bihara taribugue gajigʉre erã yayarogã erã arĩrare masa bajarã watope masicʉ̃ iigʉcumi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Eropigʉ Jesu werenemopʉ erãre: —Diaye arĩgʉ iiaa mʉare. Masʉre wejẽrã wejẽtuha dipaturi erã wejẽdigʉre ñero iimasibeama. Eropirã mʉare wejẽdiarãpʉre güibiricãque. ");
INSERT INTO des_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dohpaguere mʉa güibure mʉa umupeobure weregʉra. Goãmʉpʉre güi umupeoque. Ĩgʉ mʉa sĩrira pʉhrʉ peamegue cóãmasimi mʉare. Eropa ta ãhraa. Diaye arĩgʉ tiiaa. Goãmʉpʉre güi umupeoque. ");
INSERT INTO des_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Cinco mirua waja marima. Eropa waja mariquerecʉ̃ ta erãgãre Goãmʉ ĩhadibumi. Ne cãdijibeami erãre. Mirua tauro Goãmʉ ĩhadibumi mʉapʉre. ");
INSERT INTO des_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Eropigʉ mʉa poari sãre ne yuju poadagã dʉhyaro mariro masipehomi Goãmʉ. Eropa ta mʉa árĩricʉri sãre masipehomi. Eropa masigʉ mʉare ĩhadibuniguicãmi. Miruare ĩgʉ mahiro tauro mʉapʉre mahimi Goãmʉ. Eropirã ĩgʉre umupeorã güibiricãque mʉa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Eropi Jesu werenemopʉ: —Mʉare arĩgʉ iiaa. Yujugʉ “Jesu yagʉ ãhraa,” masare ĩgʉ arĩ werecʉ̃ ĩagʉ yʉhʉ Goãmʉ ĩgʉ obeodigʉ sã “Ĩgʉ yahagʉ ãhrimi,” arĩgʉca Goãmʉ yarã anyuare. ");
INSERT INTO des_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yujugʉ masare güigʉ yʉre “Jesucristore masibeaa,” masare arĩ weregʉre yʉ sã “Ĩgʉre masibeaa,” arĩ weregʉca anyuare. ");
INSERT INTO des_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yʉ masʉre Goãmʉ ĩgʉ obeodigʉre ñero arĩ erã wereniguicʉ̃ iri ñerire Goãmʉ cãdijimasimi. Eropa cãdijiqueregʉ ta Espíritu Santopʉre erã ñero arĩ wereniguicʉ̃ irire ne Goãmʉ cãdijisome. ");
INSERT INTO des_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mari buheri wirigue oparã pohro gajirã mʉare aĩ ñaja weresãrãcoma. Erã eropa weresãcʉ̃ mʉa arĩ cãhmotaburire ne wʉaro pepibiricãque. ");
INSERT INTO des_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Irisubu ta Espíritu Santo mʉa wereburire mʉare weregʉcumi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Eropi masa watope árĩgʉ Jesure õpa arĩ werepʉ: —Buhegʉ, gʉa pagʉ ĩgʉ sĩrira pʉhrʉ ĩgʉ ya árĩra gʉare dujaa. Eropigʉ yʉ tĩgʉre irire yʉ sãre queoro dʉca wadoreque, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ĩgʉ eroparĩcʉ̃ Jesu yʉhripʉ: —Ne irinore dʉca wabuno árĩbeaa yʉhʉ, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eropa arĩtuha Jesu árĩpehrerãre werepʉ: —Õaro iique mʉa. Doberire, gajino sãre game­tari­biricãque. Baja opaquererã ta iri mera ta mucubirituhajabeaa mari, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eropa arĩtuha Jesu erãre i queori mera werepʉ: —Doberi opʉ õari yebare opapʉ. Eropiro iri yebare ĩgʉ oteri õaro dʉcacʉyoro. ");
INSERT INTO des_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Eropigʉ ĩgʉ, ĩgʉ basi õpa arĩ pepiripʉ: “Iri dʉca yʉhʉ diburi wihire ne sihajasome. ");
INSERT INTO des_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dohpaguere õpa iigʉra. I wihi dohpague yʉ dibumʉhtara wihire cóãcã, dohpaguere mʉra wihi tauro mama wihipʉre wʉari wihi iigʉra. Iri wihire yaha oteri dʉcare, árĩpehrerire dibugʉra. ");
INSERT INTO des_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yʉ eropa iira pʉhrʉ õpa arĩ pepigʉra yʉ basi: ‘Yʉ árĩpehreri opagʉ ãhraa. Õaro soogʉra. Eropigʉ baha, ihri, mucubirigʉra,’ arĩ pepigʉra yʉ basi,” arĩ pepiripʉ ĩgʉ basi. ");
INSERT INTO des_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ĩgʉ eropa arĩ pepiquerecʉ̃ Goãmʉ ĩgʉre werepʉ: “Mʉhʉ ne pee masibigʉ ãhraa. Dohpagã ñami ta mʉhʉ sĩrigʉca. Mʉ eropa wacʉ̃ mʉ ya mʉ mahira dederea waroca mʉre,” arĩpʉ Goãmʉ ĩgʉre, arĩpʉ Jesu masare. ");
INSERT INTO des_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Irire arĩgʉ masare õpa arĩ werepʉ Jesu: —Eropa ta warãcoma doberi oparã erã Goãmʉre guñabirã. Baja doberire, niyerure erã ya árĩburi dihtare diburã, Goãmʉre guñabirã erã mojomorocʉrã iro dopa árĩrãcoma erã Goãmʉ ĩgʉ ĩacʉ̃. Eropigʉ Goãmʉ erãre ĩhasʉabeami, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Eropi Jesu ĩgʉ buherãre õpa arĩ werepʉ: —Ire mʉare arĩgʉ iiaa: Mʉa barire, suhri sãre wʉaro guñaricʉbiricãque. ");
INSERT INTO des_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Goãmʉ mʉare deyoro moagʉ bari dihtare bamorãre suhri sañamorã dihtare iibiriñumi mʉare. Mʉa iri dihtare guñacʉ̃ gamebeami. ");
INSERT INTO des_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mirimagʉ porãre Goãmʉ ĩgʉ ĩhadiburire masique. Erã poeri moorã ãhrima. Eropiro erã bari dihburi wiri erãre mara. Goãmʉpʉ erãre erã baburire ohomi. Mirimagʉ porã tauro mʉapʉre mahimi Goãmʉ. Eropigʉ mʉa sãre ĩhadibugʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wʉaro mʉa pepiri mera iri mʉare pagarã wacʉ̃ iibeaa. Eropiro mari wʉaro pepiri duhpiburi árĩbeaa. ");
INSERT INTO des_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","¿Eropirã wʉaro mʉa pepiri duhpiburi árĩbiriquerecʉ̃ ta, duhpirã mʉa baburire, mʉa ihriburire, mʉa sañaburire wʉaro guña bʉjawere pepiri mʉa? ");
INSERT INTO des_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nʉgʉ maja gorire pepique. Iri gori ne iiro mariro õari goricʉa. Iri gori õari suhri iro dopa õari gori dehyoa. Salomo opʉ mʉrʉ õari suhri opagʉ ĩgʉ árĩquerecʉ̃ ta iri goripʉ ĩgʉ ya suhri tauro õari dehyoa. ");
INSERT INTO des_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iri gorire õari gori gocʉ̃ iimi Goãmʉpʉ. Ĩgʉ eropa iiquerecʉ̃ ta iri goripʉ bajamenʉrigã árĩra pʉhrʉ ñaidija pehrea wahaa. Merogã ãhri gajinʉ peamegue soe cóãcãma. Iri eropa mata pehrequerecʉ̃ ta iri gorire iri õari gori árĩcʉ̃ iimi Goãmʉ. Eropigʉ Goãmʉ iri gorire ĩgʉ õari gori árĩcʉ̃ ĩgʉ iidiro dopa ta tauro mʉa sãre õaro iigʉcumi. Suhrire ogʉcumi. Daberogã Goãmʉre umupeoa mʉa. ");
INSERT INTO des_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eropirã mʉa baburire, mʉa ihriburire wʉaro guñabiricãque. ");
INSERT INTO des_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Goãmʉre masibirãpʉ i yeba majarãpʉ irire eropa amaniguicãma. Mari Pagʉ ʉmaro majagʉ árĩpehreri mʉa gamerire masimi. Ĩgʉ eropa masicʉ̃ mʉa ya árĩburire wʉaro guñabiricãque. ");
INSERT INTO des_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Goãmʉ mʉa opʉ ĩgʉ árĩborore gamemʉhtaque mʉa. Mʉa eropa iira pʉhrʉ Goãmʉpʉ mʉa gameri dʉhyacʉ̃ ogʉcumi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Eropigʉ erãre werenemopʉ: —Yʉ mahirã, bajamerãgã árĩquererã güibiricãque mʉa. Goãmʉ ĩgʉ opʉ árĩrore ĩgʉ mera mʉa árĩcʉ̃ gahmemi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Eropirã mʉa yare duapehoque. Irire duacã, iri niyerure mojomorocʉrãre oque. Eropirã ʉmaro maja Goãmʉ ya árĩburire mohmeque. Eropa iirã ʉmaro maja mʉa wajatari ne pehresome. Ʉmarogue mʉa ya árĩri ne pehrebeaa. Eroguere mʉa yare aĩmasibeami yajari masʉ. Eropirã mega sã irire tʉamasibeama. ");
INSERT INTO des_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ʉmarogue mʉa ya árĩcʉ̃ Goãmʉ ya dihtare pepirãca mʉa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Eroparĩtuhaja erãre werenemopʉ daja: —Mʉa yare amuyunirã iro dopa árĩrã yahare eropa iiniguirã árĩrã coreque yʉ dujariborore. Mohme corerã erã opʉ mojoto diriri bosenʉgue ĩgʉ wacʉ̃ ĩgʉ dujariborore erã cohrema. Erã eropa corero dopa ta yʉ dujariborore coreque mʉa sã. Opʉ ĩgʉ ya wihigue eraa, disiporore ĩgʉ dotecʉ̃ peerã erã mata pãgũ acuma ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mohme corerã erã opʉ eracʉ̃ ĩgʉ gamero dopa ta iiyurã árĩrã mucubirirã árĩrãcoma. Erã eropa iicʉ̃ ĩagʉ erã opʉpʉ mohme coregʉ iro dopa gohrotogʉcumi. Eropigʉ mohme corerãre doadore, ĩgʉ erãre barire duhpeogʉcumi. ");
INSERT INTO des_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ĩgʉ erarisubu ñami deco árĩcʉ̃, o boyorogue árĩquerecʉ̃ mohme corerãpʉ ĩgʉ erarisubure ĩgʉre õaro corerã árĩrã, mucubirirã árĩrãcoma erã. ");
INSERT INTO des_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ire guñaque mʉa. Wihi opʉ yajari masʉ ĩgʉ eraborore masigʉ, ĩgʉ yajari masʉre coregʉ ñajadorebiriboñumi. ");
INSERT INTO des_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eropirã mʉa sã coreque. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ guñaña mariro arigʉca. Eropirã yahare eropa iiniguirã árĩrã yʉre coreque mʉa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ĩgʉ eroparĩcʉ̃ Pedropʉ serẽpipʉ Jesure: —Opʉ, ¿i queorire weregʉ gʉare arĩgʉ iiri? ¿O árĩpehrerãre eropa arĩri? arĩpʉ Pedro. ");
INSERT INTO des_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ĩgʉ eroparĩcʉ̃ Jesu werenigui queoriñe mera õpa arĩ buhepʉ erãre: —Mohme coregʉ ĩgʉ opʉre umupeogʉ pee masigʉ õpa ta ãhrimi. Opʉ curigʉ wagʉ, mohme coregʉre ĩgʉ wihire apimi. Ĩgʉ apigʉpʉ doregʉ árĩgʉcumi. Eropigʉ barisubu árĩcʉ̃ gajirã mohmeri masare barire gueremi. ");
INSERT INTO des_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Eropigʉ opʉ ĩgʉ ya wihigue dujarami. Ĩgʉ opʉ eracʉ̃ mohme coregʉpʉ ĩgʉ opʉ ĩgʉ dorediro dopa ta iipehodigʉ árĩgʉ, ĩgʉ mucubirigʉ árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Diaye arĩgʉ iiaa mʉare. Ĩgʉ eropa iicʉ̃ ĩagʉ ĩgʉ opʉ árĩpehreri ĩgʉ yare ĩhadibugʉ apigʉcumi ĩgʉre daja. ");
INSERT INTO des_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ñegʉ mohme coregʉpʉ õpa ta ãhrimi. “Yʉ opʉ yoja deyobeami,” arĩmi. Eropa arĩgʉ gajirã mohme corerãre ʉmare, nome sãre pami. Eropigʉ wʉaro baha, ihri, meremi. ");
INSERT INTO des_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ĩgʉ eropa iirisubu guñaña mariro ĩgʉ opʉ dujaragʉcumi. Ĩgʉ dujararinʉre ne masibeami mohme coregʉ. Eropa dujaragʉ ñegʉ ĩgʉ iirare pee ĩgʉre ñero dipuwaja moagʉcumi. Eropigʉ Goãmʉre tarinʉganirãre ĩgʉ cóãdirogue ĩgʉre cóãgʉcumi. ");
INSERT INTO des_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Eropigʉ mohme coregʉ ĩgʉ opʉ gamerire masigʉ árĩqueregʉ ta irire ĩgʉ iibiricʉ̃, ĩgʉ õaro ĩgʉ mohmebiricʉ̃, ĩgʉ opʉpʉ ĩgʉre bʉrigã dipuwaja moa pagʉcumi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gajigʉ mohme coregʉpʉ ĩgʉ opʉ gamerire masibigʉ árĩcʉ̃ ĩgʉ opʉpʉ ĩgʉre daberogã ñari ĩgʉ eropa árĩri dipuwajare pagʉcumi. Goãmʉ ĩgʉ gamerire masicʉ̃ iimi masare. Eropiro masigʉre yʉhriro gahmea. Eropiro õaro masigʉre õaro yʉhriro gahmea, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Eropa arĩtuha Jesu erãre werepʉ daja: —Peame soewearo dopa ta yʉhʉ i yebare masa erã ñero iirire cóãgʉ arigʉ iibʉ. Dohpague ta masa árĩpehreri ñeri marirã árĩcʉ̃ bʉrigã gahmea yʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yʉhʉ ñero tarigʉca. Yʉ eropa ñero tariburire coregʉ, ñero sĩporãcʉa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Dohpa arĩ pepiri mʉa yʉre? Yʉhʉ i yebaguere buhegʉ aricʉ̃ yʉ buheri mera “Masa ĩhaturisome pare,” ¿arĩ pepiri mʉa? Eropa árĩbeaa. Mʉare arĩgʉ iiaa. Masa yʉ buherire peerã, pe curu erã basi game dʉca warirãcoma. Yujurãyeri yʉ buherire peerãcoma. Gajirãpʉ irire gamebirã erãre ĩhaturirãcoma. Eropirã yujuro mera árĩsome masa. ");
INSERT INTO des_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Eropirã yuju wihi majarã sã cinco masa yʉ buherire peerã, pe curu erã basi game dʉca warirãcoma. Yuju curu ʉrerã, gaji curu perã árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ĩgʉ pagʉ ĩgʉ magʉre ĩhaturigʉcumi ĩgʉ yaha buherire peecʉ̃. Gajigʉ magʉ sã ĩgʉ pagʉre ĩhaturigʉcumi. Eropigo igo pago igo magore ĩhaturigocumo. Gajigo mago sã igo pagore ĩhaturigocumo. Eropigo igo mʉñeco igo bepore ĩhaturigocumo. Gajigo bepo sã igo mʉñecore ĩhaturigocumo. Eropa warãcoma yaha buherire erã peecʉ̃, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Eropi Jesu masare bajarãre õpa arĩ werepʉ daja: —Abe ñajarogue imica cururi ĩarã, “Mata deco ariroca,” arãa mʉa. Mʉa eropa arĩra pʉhrʉ deco ahraa. ");
INSERT INTO des_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Eropirã surgue miruñe aricʉ̃ “Asirinʉ árĩroca,” arãa mʉa. Mʉa eropa arĩra pʉhrʉ irinʉ asia. ");
INSERT INTO des_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mʉa gʉyaricʉrã ãhraa. Yebare ĩarã, ʉmarore ĩarã “Õpa waroca,” arĩ masia mʉa. Õarinʉ árĩborore, ñerinʉ árĩboro sãre masia mʉa. ¿Eropa õaro masiquererã ta, duhpirã dohpague yʉ Goãmʉ turari mera yʉ mʉare ĩhmuquerecʉ̃ ta ne irire õaro masibeari mʉa? arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Eropa arĩtuhaja õpa arĩ werenemopʉ: —¿Mʉa diaye iiburire masibeari mʉa dohpa? ");
INSERT INTO des_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gajigʉ mʉre weresãgʉ wagʉ dipuwaja moadoreri wihigue wadorebocumi. Erogue ejaboro core “Dipaturi mʉre eropa iisome,” arĩ game amuque. Mʉhʉ ĩgʉre amubiricʉ̃ mʉre ĩgʉ dipuwaja moadoreri wihigue aĩgãbocumi mʉre. Eropigʉ dipuwaja moadoregʉpʉ mʉre surarare ĩgʉ wiacʉ̃, mʉre surara peresu iirãcoma. ");
INSERT INTO des_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mʉre arĩgʉ iiaa. Ne erã wajayedorerare mʉ wajayepehocʉ̃gue wirigʉca mʉhʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Irisubure bajamerãgã masa Jesure õpa arĩ wereñorã: —Galilea majarã Goãmʉre waibʉgʉre wejẽ, erã soe muju umupeorisubu Pilatopʉ erãre wejẽpʉ. Ĩgʉ eropa wejẽcʉ̃ waibʉgʉ di mera masa di morera wayoro, arĩ wereñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Erã eropa weretuhajacʉ̃ Jesu yʉhripʉ: —¿Galilea majarã Pilato ĩgʉ wejẽnirã mʉrare dohpa arĩ pepiri mʉa? ¿Erã eropa sĩrirã gajirã Galilea majarã tauro ñerã árĩra dipuwaja sĩriyuri? ");
INSERT INTO des_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Árĩbeaa. Mʉare arĩgʉ tiiaa. Mʉapʉ ñerire bʉjawerebirã, õaripʉre gohrotobirã, mʉa sã sĩrirã peamegue warãca. ");
INSERT INTO des_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Eropirã sohõ árĩnirã diez y ocho masa Siloé waĩcʉri wihi ʉmari wihi erã weca yuribeja wejẽpehoyoro. ¿Eropa wa sĩrirã gajirã Jerusalén majarã tauro ñerã árĩra dipuwaja sĩriyuri mʉa pepicʉ̃? ");
INSERT INTO des_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Árĩbeaa. Mʉare arĩgʉ tiiaa. Mʉa ñerire bʉjawerebirã õaripʉre gohrotobirã, mʉa sã sĩrirãca. Eropirã peamegue warãca, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Eropa arĩtuhaja, Jesu i queori mera werepʉ erãre: —Pohe opʉ ĩgʉ pohegue ĩgʉ higueragʉre opapʉ. Eropigʉ ĩgʉ irigʉ dʉcare amagʉ waripʉ. Bocabiripʉ. ");
INSERT INTO des_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bocabirinijagʉ ĩgʉ iri pohe mohmegʉre werepʉ. “Peeque yʉre. Ʉhre bojori gohra higueragʉ dʉcare amaraa. Dʉca mara. Irigʉ dʉca maricʉ̃ irigʉre pa cóãcãque. Irigʉ yaha pohe árĩcʉ̃ gajigʉre otemasibeaa,” arĩpʉ pohe opʉ mohmegʉre. ");
INSERT INTO des_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ĩgʉ eroparĩcʉ̃ peegʉ mohme coregʉ õpa arĩpʉ: “Opʉ, irigʉ yuju bojori gohra niguiniporo. Yʉhʉ irigʉ gubuyere seatu nujatu iigʉra. Tuhaja waibʉgʉ gʉra mera iri gobere yaagʉra. ");
INSERT INTO des_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yʉ eropa iira pʉhrʉ irigʉre gaji bojori dʉcacʉcʉ̃ õaroca. Dʉca maricʉ̃ mʉhʉ padoregʉca,” arĩpʉ mohme coregʉ pohe opʉre, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Irisubure Sabadonʉ Jesu judio masa buheri wihigue buhegʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ero pũriri dorecʉgo diez y ocho bojori gohra pũriri dorecʉgo árĩpo. Eropigo opatũ niguigo árĩgo, diaye niguimasibiripo. ");
INSERT INTO des_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Igo eropa árĩcʉ̃ ĩagʉ Jesu igore ĩha, piyupʉ: —Noméo, mʉ dorecʉri pehrea wahabʉ, arĩ piyupʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ĩgʉ piyura pʉhrʉ igore ĩgʉ mohmepicʉ̃ mata igo diaye niguigo wapo. Eropa wago “Goãmʉ turagʉ, õagʉ ãhrimi,” arĩ Goãmʉre umupeopo igo. ");
INSERT INTO des_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesu igore Sabadonʉ árĩcʉ̃ ĩgʉ õago igore iicʉ̃ ĩagʉ iri buheri wihi opʉpʉ ĩgʉ mera guapʉ. Eropa guagʉ ĩgʉ masare õpa arĩpʉ: —Seis nʉri ãhraa mari mohmerinʉri. Eropirã mʉa dore õarã árĩdiarã irinʉrire taudorerã arique. Sabadonʉre mari soorinʉre irire iibiricãro gahmea, arĩpʉ wihi opʉ. ");
INSERT INTO des_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ĩgʉ eroparĩcʉ̃ Jesu õpa arĩ yʉhripʉ: —Mʉa gʉyaricʉrã ãhraa. Mʉa wecʉare, burro sãre oparã Sabadonʉ árĩquerecʉ̃ erã diriradare pã, erãre aĩ buha ihridorea. ");
INSERT INTO des_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dohpague igore Abrahã mʉrʉ acaweregore watĩ diez y ocho bojori gohra igore dorecʉcʉ̃ iimi. ¿Sabadonʉ árĩcʉ̃ igore õago iidorebeari mʉa? arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ĩgʉ eroparĩcʉ̃ erãpʉ gʉhyasĩuro wañorã. Eropirã gajirãpʉ árĩpehreri Jesu iirare ĩha mucubiriñorã. ");
INSERT INTO des_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Eropigʉ Jesu werepʉ daja: —¿Goãmʉ masa tauro opʉ ĩgʉ árĩri werediacʉ̃ ñeheno iro dopa ãhriri mʉa pepicʉ̃? I werenigui queoriñe mera weregʉra yʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostazayegã iro dopa ãhraa. Iriyegãre oteri masʉ yujugʉ ĩgʉ ya pohegue otemi. Ĩgʉ otera pʉhrʉ õaro puhria. Eropiro yucʉgʉ wʉadigʉ wahaa. Eropa wacʉ̃ mirimagʉ porã bajarã irigʉ dʉpʉrigue suhri suama. Eropa ta ʉmaro majagʉ mari Opʉre masirã bajamerãgã erã árĩmʉhtaquererã pʉhrʉguere erã bajarã warãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Eropigʉ dipaturi Jesu werenigui queoriñe mera buhepʉ: —¿Goãmʉ masa tauro opʉ ĩgʉ árĩri werediacʉ̃ ñeheno iro dopa ãhriri mʉa pepicʉ̃? ");
INSERT INTO des_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pan bʉgacʉ̃ iiburi iro dopa ãhraa. Yujugo nomeo panre iigo pan bʉgacʉ̃ iiburi pohgare merogã moremo trigo pohga mera. Igo eropa iicʉ̃ pan bʉgacʉ̃ iiburi pohga merogã árĩquerero trigo pohgare õaro seyapehrea wahaa. Eropa ta ʉmaro majagʉre mari Opʉre bajarã masa masirãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Eropi Jesu paga macarigue, mʉta macarigãgue buhegã, Jerusaléngue ejabu iipʉ. ");
INSERT INTO des_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ĩgʉ eropa warisubu masʉ Jesure õpa arĩ serẽpipʉ: —Opʉ, ¿bajamerãgã dihtare peamegue wabonirãre Goãmʉ taugʉcuri erã ĩgʉ pohro waboro dopa? arĩpʉ ĩgʉ Jesure. Ĩgʉ eroparĩcʉ̃ Jesu werenigui queoriñere buhegʉ õpa arĩ werepʉ: ");
INSERT INTO des_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Yʉ mʉare õpa arãa: Bajarã Goãmʉ pohrogue wadiaquererã wamasisome. Ĩgʉ pohro waburi miri disiporogã ñajaro dopa ãhraa. Eropirã mʉa i disiporogãre turaro ñajadiarã iro dopa ta ĩgʉ yare iique. ");
INSERT INTO des_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Õpa iigʉcumi Goãmʉ bajarã masare. Ĩgʉ wihi opʉ iro dopa ãhrimi. Wihi opʉ wahgã, disiporore bihagʉcumi. Ĩgʉ eropa iicʉ̃ disiporogue mʉa niguirã disiporo biharisere doterãca. Doterã õpa arĩrãca. “Opʉ, disiporore pãgũque gʉare.” Mʉa eroparĩcʉ̃ wihi opʉpʉ yʉhrigʉcumi. “Mʉa aridirore masibeaa yʉhʉ. Eropigʉ mʉare masibeaa,” arĩ yʉhrigʉcumi, ");
INSERT INTO des_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ĩgʉ eroparĩcʉ̃ mʉa yʉhrirãca. “Mʉ mera gʉa baha, ihribʉ. Gʉa ya maca buhebʉ mʉhʉ,” arĩrãca mʉa. ");
INSERT INTO des_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mʉa eroparĩcʉ̃ ĩgʉpʉ yʉhrigʉcumi. “Mʉa aridirore masibeaa. Árĩpehrerã mʉa ñeri iinirã yʉ pohro aribiricãque,” arĩgʉcumi wihi opʉ. ");
INSERT INTO des_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eropi Abrahãre, Isaare, Jacobore, árĩpehrerã Goãmʉ ya weremʉhtanirãre Goãmʉ ĩgʉ opʉ árĩrore erã árĩcʉ̃ ĩarã, mʉa disiporogue cóãnirã árĩrã bʉrigã orerãca. Eropirã mʉa turaro bʉjawererã, mʉa gʉcʉrire cũridihurãca. ");
INSERT INTO des_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Irisubure norte majarã, sur majarã, abe mʉririro majarã, abe ñajaro majarã Goãmʉ ĩgʉ opʉ árĩroguere eja, mesa pohro doarãcoma. ");
INSERT INTO des_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dohpague árĩrã pohro majarã árĩrã irisubure oparã árĩrãcoma. Eropirã dohpaguere “Oparã ãhraa,” arĩrã irisubure pohro majarã árĩrãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Irisubure bajamerãgã fariseo masa Jesu pohrogue ejarã, ĩgʉre wereñorã: —Herode mʉre wejẽdiami. Eropigʉ gajipʉ waque mʉhʉ, arĩñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Erã eroparĩcʉ̃ Jesupʉ yʉhripʉ: —Herode gʉyaricʉgʉ ãhrimi ĩgʉ. Õpa arĩ wereque ĩgʉre: “Jesu watẽare cóãgʉ iimi. Eropigʉ dorecʉrãre õarã iigʉ iimi. Irire dohpagãre, ñamigã sãre iigʉcumi. Eropigʉ ñamigã core mohmetugʉcumi,” arĩ wereque Herodere. ");
INSERT INTO des_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Eropigʉ dohpagãre, ñamigãre, ñamigã core sãre Jerusaléngue curigʉ wagʉra. Ero yʉre Goãmʉ yare weremʉhtagʉre wejẽrãcoma masa. Goãmʉ yare weremʉhtagʉre erã wejẽbupʉre Jerusaléngue árĩro gahmea. Eropigʉ yʉre i maca ta dujaro gahmea. ");
INSERT INTO des_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mʉa Jerusalén majarã, mʉa acawererã mʉra Goãmʉ ya weremʉhtanirãre wejẽmʉrinirã árĩma. Eropirã Goãmʉ obeonirãre ʉtã mera deamʉrinirã árĩma. Cãreña bʉro igo porãre igo quẽdʉpʉri mera igo coã oyaro dopa ta bajasuburi opadiaribʉ mʉare. Mʉapʉ irire yʉre ne gamebiribʉ. ");
INSERT INTO des_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dohpaguere mʉa árĩri maca cóãra maca árĩroca. Diaye arĩgʉ tiiaa mʉare. Pʉhrʉ dujarigʉca daja yʉhʉ. Eropa yʉ dujaricʉ̃ ĩarã mʉa yʉre Goãmʉ turari mera arigʉ “Õaro ariporo,” arĩrãca. Yʉre mʉa irire arĩboro core dipaturi yʉre ĩasome mʉa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Gajinʉ erã soorinʉ Sabadonʉ árĩcʉ̃ fariseo masa oparã mera majagʉ ya wihigue Jesu bagʉ wapʉ. Iri wihi árĩrã ĩgʉre ĩhanʉrʉsiañorã. ");
INSERT INTO des_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Eropigʉ ñigagʉ bijigʉ ĩgʉ pohrogue ejapʉ. ");
INSERT INTO des_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eropigʉ Jesu judio masare buherãre, fariseo masa sãre serẽpipʉ: —¿Mari soorinʉre dorecʉgʉre õagʉ iidoreri Goãmʉ yare erã gojarapũ? arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ĩgʉ eropa arĩ serẽpiquerecʉ̃ ta erã yʉhribiriñorã. Erã yʉhribiricʉ̃ ĩagʉ Jesu ñigagʉ bijigʉre õagʉ iipʉ. Tuhajanugu, “Waque,” arĩpʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eropa iituhagʉ erãre serẽpipʉ daja: —¿Mʉa yagʉ burrore o mʉa yagʉ wecʉre gobegue yuhridijadigʉre mata aĩ wiubeari mʉa mari soorinʉ árĩquerecʉ̃? arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ĩgʉ eropa arĩquerecʉ̃ ta erã ĩgʉ serẽpirire yʉhrimasibiriñorã daja. ");
INSERT INTO des_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fariseo masʉ ya wihi árĩgʉ iri wihi majagʉ ĩgʉ sihubeonirã oparã doarire erã beyemʉhtacʉ̃ ĩapʉ Jesu. Eropa ĩatuha ire werepʉ árĩpehrerãre: ");
INSERT INTO des_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Mojoto diriri bosenʉ árĩcʉ̃ ĩgʉ mʉare sihubeocʉ̃, ĩgʉ ya wihigue eja oparã doarire beye doabiricãque. Mʉa tauro gʉhyadiarãre sihuboñumi iri wihi opʉ. ");
INSERT INTO des_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ĩgʉ eropa iicʉ̃ mʉa oparã doarire doacʉ̃ “Oã gʉhyadiarãre mʉa doarire oque,” mʉare arĩbocumi wihi opʉ. Ĩgʉ eroparĩcʉ̃ mʉa gʉhyasĩuro dujarãca. Eropirã bu árĩrã doarire doarã warãca. ");
INSERT INTO des_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Eropirã wihi opʉ mʉare sihubeocʉ̃, bu árĩrã doarire doamʉhtaque. Mʉa eropa iicʉ̃ wihi opʉ mʉare oparã doaripʉre “Doarã arique,” arĩgʉcumi ĩgʉ mʉare. Mʉa eropa wacʉ̃ gajirã ĩgʉ sihubeonirãpʉ mʉare umupeori mera ĩarãcoma. ");
INSERT INTO des_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yujugʉ ĩgʉ basi “Opʉ ãhraa,” arĩ pepigʉ bu árĩgʉ árĩgʉcumi. Eropigʉ gajigʉ “Bu árĩgʉ ãhraa,” arĩ pepigʉ, gajirãre tarinʉgadiabigʉ opʉ árĩgʉcumi, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Eropa arĩtuha Jesu wihi opʉre werepʉ: —Mʉhʉ bosenʉ iigʉ mʉ pohro árĩrãre, mʉ pagʉ porãre, mʉ acawererãre, doberi oparãre sihubiricãque. Mʉhʉ erãre sihucʉ̃ mʉre erã sã sihu gamerãcoma daja. Eropa sihu gamerã mʉre erã wajamorire wajayerãcoma. ");
INSERT INTO des_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mʉhʉ bosenʉ moagʉ mojomorocʉrãre, curimasibirãre, yujupʉ guburu poyanirãre, cuiri ĩhajabirãre sihubeoque. ");
INSERT INTO des_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mʉ eropa iicʉ̃ ĩagʉ Goãmʉ mʉre õaro iigʉcumi. Erãpʉ mʉre erã sihura wajamorire wajayemasibeama. Eropigʉ õarã sĩrinirã erã masa mʉriarisubu árĩcʉ̃ Goãmʉpʉ mʉre wajayegʉcumi, arĩpʉ Jesu wihi opʉre. ");
INSERT INTO des_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ĩgʉ eroparĩcʉ̃ peegʉ gajigʉ bari mesa pohro doadigʉ Jesure werepʉ: —Goãmʉ ĩgʉ opʉ árĩro ĩgʉ bari mesa pohro doarã turaro mucubirirã árĩrãcoma, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ĩgʉ eroparĩcʉ̃ Jesu i queorire werepʉ ĩgʉre: —Wʉari bosenʉ iigʉ bajarã masare sihubeopʉ. ");
INSERT INTO des_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ĩgʉ sihubeora pʉhrʉ bosenʉ árĩrinʉ gohra mohme coregʉre ĩgʉ sihubeonirãre weredoregʉ obeopʉ. “Ma, árĩpehrerire bosenʉ maja árĩburire amutuhama. Eropigʉ mʉare sihubeomi,” arĩ weredorepʉ mohme coregʉre. ");
INSERT INTO des_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mohme coregʉ ĩgʉ eropa arĩ werequerecʉ̃ ta, ĩgʉ sihunirãpʉ “Wamasibirica,” arĩñorã erã. Ĩgʉ sihumʉhtadigʉ õpa arĩ werepʉ mohme coregʉre. “Dohparagã yebare asũabʉ. Eropigʉ iri yebare ĩagʉ wabu iiaa. Eropigʉ wamasibirica. Umupeoque yʉre. Yʉre masiya mara, arĩque,” arĩpʉ ĩgʉ sihumʉhtadigʉpʉ mohme coregʉre. ");
INSERT INTO des_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gajigʉpʉ õpa arĩpʉ: “Wecʉare pe mojotocʉ majarã dohparagã ta asũabʉ. Eropigʉ wecʉare queo ĩagʉ wabu iiaa. Eropigʉ wasome. Yʉre wamasiya mara,” arĩpʉ ĩgʉ sã. ");
INSERT INTO des_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Gajigʉpʉ õpa arĩpʉ: “Yʉhʉ dohpagã mojoto dihriabʉ. Eropigʉ iri bosenʉre wamasibirica,” arĩpʉ ĩgʉ mohme coregʉre. ");
INSERT INTO des_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ĩgʉ eroparĩcʉ̃ mohme coregʉpʉ dujaa wa, ĩgʉ opʉre erã arĩrare werepehopʉ. Ĩgʉ eropa arĩ werecʉ̃ ĩgʉ opʉ turaro gua, õpa arĩpʉ mohme coregʉre. “Yojaro mera maca árĩri marigue, mojomorocʉrã erã árĩri marigue waque. Eropigʉ mojomorocʉrãre, curimasibirãre, cuiri ĩhajabirãre, poyari masare yojaro mera aĩgãrique erãre,” arĩpʉ opʉ. ");
INSERT INTO des_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pʉhrʉ mohme coregʉ werepʉ ĩgʉ opʉre: “Opʉ, mʉ dorediro dopa ta masare sihuabʉ. Yʉ eropa sihuquerecʉ̃ ta gajirã sã iri taribure sihajarãcoma,” arĩpʉ mohme coregʉ. ");
INSERT INTO des_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ĩgʉ eroparĩcʉ̃ opʉ ĩgʉre dorepʉ: “Campogue waque. Ero paga marigue, mʉta marigãgue árĩrãre yaha wihigue aridoreque yaha wihi õaro ʉjʉtʉrimaja õaro. ");
INSERT INTO des_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Diaye arĩgʉ iiaa mʉre. Oã yʉ sihumʉhtanirã yʉ barire ne merogã basome,” arĩpʉ opʉ, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Irisubure bajarã masa Jesu mera wañorã. Eropigʉ Jesu erãre maji ĩha werepʉ: ");
INSERT INTO des_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Yujugʉ yʉ buhegʉ árĩdiagʉ gajirã tauro yʉpʉre mahiro gahmea. Ĩgʉ pagʉre, ĩgʉ pagore, ĩgʉ marapore, ĩgʉ porãre, ĩgʉ pagʉ porãre ĩgʉ basire ĩgʉ mahiro tauro yʉpʉre mahiro gahmea. ");
INSERT INTO des_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yujugʉ yʉ buhegʉ árĩdiagʉ yahare eropa iiniguigʉ árĩgʉcumi. Eropigʉ ĩgʉ yahagʉ ĩgʉ árĩri dipuwaja ñero tariqueregʉ ta yʉre pihrisome. Eropa ñero taridiabigʉ yʉ buhegʉ árĩmasisome. ");
INSERT INTO des_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ire masiyuro gahmea mʉare. Õpa ãhraa iri: Wihi iigʉ ĩgʉ ʉmari wihi ĩgʉ iiboro core wihi wajacʉburire queomʉhtanimi. Eropa iigʉ ĩgʉ wihire pehoborore masimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wajacʉburire queobigʉ iri wihire iipehobiribocumi. Eropirã ĩgʉre ĩarã wereyabocoma. ");
INSERT INTO des_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ihĩ ĩgʉ wihire iigʉ bocatĩubirañumi,” arĩ wereyabocoma. ");
INSERT INTO des_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Opʉ sã gajigʉ opʉ yarã mera erã gamewejẽboro core, ĩgʉ yarã surarare ĩgʉ gamewejẽdoreboro core, ĩgʉ yarã surarare queogʉcumi. “¿Yʉhʉ diez mil surara mera gajigʉ veinte mil surara opagʉ mera gamewejẽgʉ wagʉ bocatĩubocuri?” arĩ pepigʉ queogʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eropa queogʉ “Bocatĩusome,” arĩgʉ, gajigʉ opʉ ĩgʉ surara mera gamewejẽgʉ arigʉ yoarogue ĩgʉ aricʉ̃ ta, “Bocatĩusome,” arĩgʉpʉ “Gamewejẽbiricãrã,” arĩdoregʉ obeobocumi ĩgʉ pohro majagʉre. ");
INSERT INTO des_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Eropirã yʉ buherã árĩdiarã mʉa iiburire mʉare masiyuro gahmea. Eropirã mʉa gamerire duhudiabirã yʉ buherã árĩmasibeaa mʉa, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Eropigʉ erãre werenemopʉ: —Moa õaro acari ãhraa. Iri moa ñeri wacʉ̃ dipaturi õari iimasiya mara. ");
INSERT INTO des_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Iri moa mera duhpimaja masiya mara. Iri eropa árĩcʉ̃ iri moare cóãro gahmea. Eropirã mʉa Goãmʉ yare iiniguibirã ne duhpimorã árĩbeaa. Ire õaro peeque mʉa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Eropa gajinʉ bajarã wajasea corerã gajirã “Ñerã ãhrima,” erã arĩrã mera Jesure peerã ariñorã. ");
INSERT INTO des_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Erã eropa iicʉ̃ ĩarã fariseo masa judio masare buherã sã Jesure ĩhaturirã õpa arĩñorã erã basi: —Ihĩ ñerã mera wapicʉmi. Eropigʉ erã mera bahami, arĩ wereniguiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Erã eropa arĩ wereniguicʉ̃ Jesu i queori mera õpa arĩ buhepʉ erãre: ");
INSERT INTO des_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Cien oveja opʉ yujugʉ oveja dederea wacʉ̃ ĩagʉ dohpa iigʉcuri ĩgʉ? Õpa iigʉcumi. Ĩgʉ noventa y nueve ovejare erã bari campogue api, dederedigʉre amagʉ wagʉcumi. Ovejare bocagʉgue dujarigʉcumi. ");
INSERT INTO des_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ĩgʉre bocagʉ mucubirigʉcumi. Eropigʉ ĩgʉre ĩgʉ weca coãpeo ");
INSERT INTO des_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ĩgʉ ya wihigue aĩ dujaa wagʉcumi. Aĩ dujaja, ĩgʉ pohro árĩrãre, ĩgʉ acawererãre sihu gameneogʉcumi. “Yʉ oveja dederedigʉre bocabʉ. Eropirã yʉ mera mucubirique,” arĩgʉcumi ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Oveja dederedigʉre ĩgʉ bocadiro dopa ta õpa arĩgʉ iiaa mʉare. Yujugʉ ñerire iigʉ ĩgʉ ñerire bʉjawerecʉ̃ õaripʉre gohrotocʉ̃ ĩarã Goãmʉ pohro árĩrã bʉrigã mucubirima. Gajirãpʉ bajarã masa õpa arĩ pepima: “Ñero iibeaa yʉpʉ. Eropiro yʉ ñeri bʉjawereburi mara,” arĩ pepirima. Erã eropa arĩ pepicʉ̃ ĩarã ʉmaro majarã Goãmʉ pohro árĩrã mucubiribeama, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Eropa arĩtuha gaji queori mera werenemopʉ: —¿Diez niyeruseri waja pagariseri opago yujuse dederecʉ̃ duhpibocuri igo mʉa pepicʉ̃? Õpa iigocumo igo. Sihãgodirure sihãgo, wihire oha, õaro amapehogocumo. Irisere bocagogue duhugocumo. ");
INSERT INTO des_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Irisere bocatuha, igo pohro árĩrãre, igo acawererãre sihupehogocumo. “Niyeruse yahase dederera­sere bocabʉ. Eropirã yʉ mera mucubirique,” arĩgocumo igo. ");
INSERT INTO des_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Diaye arĩgʉ iiaa mʉare. Eropa ta yujugʉ ñerire iigʉ ĩgʉ ñerire bʉjawerecʉ̃ õarire gohrotocʉ̃ Goãmʉ yarã anyuapʉ bʉrigã mucubirirãcoma. Ĩgʉ dederebodigʉ dederebeami pare. Eropirã turaro mucubirirãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Eropa arĩtuha Jesu gaji queori mera werepʉ daja: —Bʉgʉ porã perã árĩñorã. ");
INSERT INTO des_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dʉhyagʉpʉ õpa arĩpʉ ĩgʉ pagʉre: “Ahʉ, mʉ sĩrira pʉhrʉ yʉre mʉ oburire yʉre opurumujuque,” arĩpʉ ĩgʉ ĩgʉ pagʉre. Ĩgʉ eroparĩcʉ̃ erã pagʉ perãgue ta ĩgʉ porãre guerepʉ ĩgʉ oparare. ");
INSERT INTO des_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bajamenʉrigã pʉhrʉ dʉhyagʉpʉ ĩgʉ ya árĩpehrerire aĩ, yoarogue gaji yebague waha wapʉ. Ero eja ĩgʉ ya niyerure iisiripehocãpʉ. ");
INSERT INTO des_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ĩgʉ iisiripehora pʉhrʉ iri yebare ne bari marinʉgayoro. Eropigʉ oaboapʉ. ");
INSERT INTO des_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Eropigʉ iri yeba maja mohmerire amapʉ. Ĩgʉ mohmerire bocacʉ̃ ĩgʉ opʉ yesea coregʉ acupʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Eropigʉ ĩgʉ yeseare ejo, erã barire badiaripʉ ĩgʉ sã. Ĩgʉ eropa badiaquerecʉ̃ ta ero majarã ĩgʉre barire obiriñorã. ");
INSERT INTO des_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Eropi ĩgʉre ero guñari ariyoro pare. “Yʉ pagʉre mohme corerãpʉ pagari barire opacoma. Erã ba dʉhari sã pagari árĩca. Erã õaro árĩrisubu yʉpʉ ohõ árĩgʉ oaboagʉ iiaa. ");
INSERT INTO des_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dohparagã yʉ pagʉ pohro dujagʉra. Yʉ pagʉ pohrogue ejagʉ õpa arĩgʉra ĩgʉre: ‘Ahʉ, Goãmʉre ñero iiabʉ. Mʉ sãre ñero iiaca. ");
INSERT INTO des_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ñegʉ ãhraa. Eropigʉ mʉ magʉ diaye dopa ĩabita yʉre pare. Mʉre mohme corerã dopa ta ĩaque yʉre,’ arĩgʉra yʉ pagʉre,” arĩ pepipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eropa arĩ pepigʉ wahgãnʉgaja, ĩgʉ pagʉ pohrogue dujaa wapʉ. Erogue ĩgʉ ejadigʉ ĩgʉ dujaricʉ̃ ĩgʉ pagʉpʉ ĩgʉre yoarogue ĩgʉ árĩcʉ̃ ta ĩgʉ magʉre ĩha masipʉ. “Ĩgʉ eropa eracʉ̃ ĩagʉ ĩgʉ magʉre mojomoro ĩapʉ. Mojomoro ĩagʉ ĩgʉre oma bocatĩri pabua, ĩgʉ wayuporãre mimipʉ ĩgʉ pagʉ ĩgʉ magʉre. ");
INSERT INTO des_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ahʉ, Goãmʉre ñero iiabʉ. Mʉ sãre ñero iiaca. Ñegʉ ãhraa yʉhʉ. Eropigʉ mʉ magʉ diaye dopa ĩabita yʉre pare,” arĩpʉ ĩgʉ ĩgʉ pagʉre. ");
INSERT INTO des_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ĩgʉ eroparĩcʉ̃ peequeregʉ ta ĩgʉ pagʉpʉ mohme corerãre sihupʉ. “Yojaro, õariñe suhrirore aĩgãrique. Eropirã yʉ magʉre sãque. Sãtuha ĩgʉ mojotore sãri berore sã, ĩgʉ guburire zapature sãque. ");
INSERT INTO des_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sãtuha diicʉgʉ wecʉre wejẽque. Bosenʉ iirã. ");
INSERT INTO des_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ihĩ yʉ magʉ sĩrigʉ dopa ta waha wami. Eropa waqueregʉ ta dohpaguere ojocarimi ĩgʉ. Dederedigʉ dopa árĩdigʉre dohpaguere bocabʉ. Eropirã bosenʉ iirã,” arĩpʉ ĩgʉ pagʉ. Ĩgʉ eropa arĩra pʉhrʉ bosenʉ iinʉgañorã erã. ");
INSERT INTO des_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Irisubure ĩgʉ tĩgʉpʉ pohegue árĩpʉ. Pohegue árĩdigʉ dujarigʉ wihi pohro eragʉ, erã bayarire peepʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Peegʉ yujugʉ mohme coregʉre sihubeo ĩgʉre serẽpipʉ ĩgʉ: “¿Dohpa iirã bayarã iiari?” arĩpʉ ĩgʉ mohme coregʉre. ");
INSERT INTO des_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Mʉ pagʉ magʉ dujarami. Ĩgʉ õagʉ dujaracʉ̃ mʉ pagʉ diicʉgʉre wecʉre wejẽdoreami,” arĩ yʉhripʉ mohme coregʉ. ");
INSERT INTO des_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ĩgʉ eropa arĩ werecʉ̃ ĩgʉ tĩgʉpʉ bʉrigã guagʉ wihigue ñajabiripʉ. Ĩgʉ eropa ñajabiricʉ̃ ĩagʉ ĩgʉ pagʉ wiriri, “Ñajarique,” arĩ turaro sihuripʉ ĩgʉ magʉre. ");
INSERT INTO des_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Peeque, ahʉ. Yʉhʉ yoari boje mʉre mohme coregʉ dopa ta itamurabʉ. Eropigʉ mʉ dorerire ne yujusubu tarinʉgabirimʉrabʉ. Yʉhʉ mʉre mohme corequerecʉ̃ ta yʉpʉre ne obirabʉ mʉhʉ. Ne yujugʉ waibʉgʉre obeaa mʉhʉ yʉre yʉ mera majarã mera yʉ bosenʉ iicʉ̃. ");
INSERT INTO des_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Eropigʉ ihĩ mʉ magʉpʉ ñerã nome mera mʉ yare iisiripehodigʉ árĩmi. Irire iisiripehotuha, ĩgʉ wihigue ĩgʉ dujaracʉ̃ diicʉgʉ wecʉre wejẽabʉ mʉhʉ ĩgʉ babure,” arĩpʉ ĩgʉ tĩgʉ ĩgʉ pagʉre. ");
INSERT INTO des_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mahgʉ, mʉhʉ yʉ mera árĩpehrerinʉri ãhraa. Eropiro árĩpehreri yaha mʉ ya dihta ãhraa. ");
INSERT INTO des_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mʉ pagʉ magʉpʉ sĩridigʉ dopa ta wahámi marire. Eropi ĩgʉ dohpaguere ojocarigʉ ãhrimi. Ĩgʉ dederedigʉ dopa ta wahámi. Ĩgʉ eropa wara pʉhrʉ dohpaguere ĩgʉre bocabʉ. Eropiro ĩgʉ dujaracʉ̃ mari bosenʉ ii mucubiricʉ̃ õhaa,” arĩpʉ ĩgʉ ĩgʉ magʉre, arĩpʉ Jesu erãre iri queorire weregʉ. ");
INSERT INTO des_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Eropi i queorire ĩgʉ buherãre werepʉ Jesu: —Doberi opʉ ya niyerure dibu coregʉ niyerure ĩgʉ õaro dibubiricʉ̃ ĩagʉ gajigʉpʉ weresãpʉ doberi opʉre. “Ĩgʉ mʉ ya niyerure iisirigʉ iimi,” arĩ weresãpʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ĩgʉ eropa weresãcʉ̃ pee niyeru dibu coregʉre sihubeopʉ. Eropigʉ ĩgʉ eracʉ̃ ĩagʉ ĩgʉre opʉ werepʉ. “Gajigʉ mʉ yaha niyerure iisiririre wereami yʉre. Eropigʉ yahare dibugʉ dohpaguere árĩsome mʉhʉ. Eropigʉ yahare mʉ iirare werepeho gojaque. Mʉre cóãgʉ iiaa,” arĩpʉ ĩgʉ opʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ĩgʉ eropa arĩra pʉhrʉ õpa arĩ pepipʉ dibu coregʉ ĩgʉ basi: “Yʉ opʉ yʉre cóãbu iicumi. Yʉhʉ turabeaa. Eropigʉ turaro mohmerire bocatĩubeaa. Eropigʉ gajirãre niyeru serẽgʉ gʉhyasĩutariaro tarigʉca yʉhʉ. ¿Eropigʉ dohpa iigʉcuri yʉhʉ? ");
INSERT INTO des_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Dohpague tamerare yʉ iiburire masia yʉhʉ. Õpa yʉ iicʉ̃ yʉ mohmeri maricʉ̃ erã yʉ itamurã árĩrãcoma. Eropirã erã ya wirigue ñajadorerãcoma yʉre,” arĩ pepipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Eropa arĩ pepigʉ ĩgʉ árĩpehrerã ĩgʉ opʉre wajamonirãre sihubeopʉ. Sihubeotuha eramʉhtagʉre õpa arĩ serẽpipʉ ĩgʉ. “¿Yʉ opʉre dipẽ wajamori mʉhʉ?” arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ĩgʉ eroparĩcʉ̃ wajamogʉpʉ yʉhripʉ. “Cien tambore ʉyʉre olivo waĩcʉdigʉ maja ʉyʉre wajamoa ĩgʉre,” arĩ yʉhripʉ ĩgʉ. Ĩgʉ eropa arĩ werecʉ̃ dibugʉpʉ õpa arĩ werepʉ. “Ohõ ãhraa mʉ wajamorire gojaturapũ. Doaque. Eropigʉ mʉ wajamorire deco mera aĩ, deco mera gojatuque,” arĩpʉ niyeru dibugʉ wajamogʉre. ");
INSERT INTO des_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Eropa arĩtuhaja gajigʉ wajamogʉre serẽpipʉ ĩgʉ. “¿Mʉca dipẽ wajamori?” arĩpʉ daja. “Cien aju trigo ajure wajamoca yʉhʉ,” arĩpʉ wajamogʉ dibugʉre. “Ohõ ãhraa mʉ wajamorire gojaturapũ. Mʉ wajamorire ochenta goja amuque,” arĩpʉ dibugʉ. ");
INSERT INTO des_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ĩgʉ eropa õaro gʉyamehrecʉ̃ ĩagʉ “Ihĩ gʉyamehregʉ árĩcumi,” arĩ pepipʉ ĩgʉ opʉ niyeru dibugʉre. Inʉ majarã Goãmʉ gamebirã erã yare gʉya amurare erã niyerure erã diburare Goãmʉ yarã tauro masicoma erã, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Eropa arĩtuha Jesu werenemopʉ: —Eropigʉ mʉare arĩgʉ tiiaa. Mʉa oparire, i yeba majare mojomorocʉrãre mʉa ocʉ̃, erãpʉ mʉare mahirãcoma. Mʉa eropa iicʉ̃ mʉa opara pehrera pʉhrʉ ʉmʉsigue mʉa ejacʉ̃ erogue mʉare õaro mahirãcoma. ");
INSERT INTO des_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Bu árĩrã ya mohmerire queoro iirã oparã ya mohmeri sãre queoro iirãca. Bu árĩrã ya mohmerire queoro iibirã oparã ya sãre queoro iibirãca. ");
INSERT INTO des_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eropirã i yebague mʉa opari mera mʉa õaro iibirã Goãmʉ mʉare iidoreri sãre õaro iisome mʉa. ");
INSERT INTO des_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eropirã gajigʉ yare mʉa õaro iibasabiricʉ̃ ĩagʉ mʉa ya árĩburire osome mʉare. ");
INSERT INTO des_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Yujugʉ Goãmʉpʉre guñagʉ bʉrigã gohra niyerupʉre guñabeami. Niyerupʉre bʉrigã guñagʉ Goãmʉpʉre guñabeami. Eropigʉ niyeru dihtare gamegʉ árĩgʉ Goãmʉpʉre mucubiricʉ̃ iibeami. Goãmʉ sãre niyeru sãre yujuro mera gametarima masiya mara mʉare. Niyerure gametarigʉ Goãmʉpʉre umupeomasibeami, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ĩgʉ eroparĩcʉ̃ peerã fariseo masapʉ ĩgʉre wereyañorã. Erãpʉ niyerure gametariñorã. Eropirã wereyañorã. ");
INSERT INTO des_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Erã wereyacʉ̃ peegʉ Jesu erãre werepʉ: —Masa erã ĩhurore mʉa õaro iiraa. Mʉa eropa iicʉ̃, “Õarã diaye ta iirã ãhrima,” arĩrima masa mʉare. Goãmʉpʉ mʉa pepirire masimi. Masa “Õatariama,” erã arĩrãre Goãmʉpʉ gajiropa arĩ pepimi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Eropa arĩtuhaja õpa werenemopʉ Jesu: —Ñu waĩyegʉ ĩgʉ eraboro core Moisere ĩgʉ apira doreri mera Goãmʉ marire doreami. Goãmʉ ya weremʉhtanirã mʉra erã gojara sã eropa ta árĩribʉ marire dorera. Dohpaguepʉre Ñu õari buherire, Goãmʉ opʉ ĩgʉ árĩrire buhemi. Ĩgʉ eropa buhecʉ̃ pee masa erã ejatuharo, erã turari mera Goãmʉ erã opʉ árĩcʉ̃ gahmema. ");
INSERT INTO des_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Goãmʉ Moisere ĩgʉ apira dorerire erã ĩgʉ yare gojara sãre “Iri duhpiburi árĩbeaa,” ne arĩsome. Ʉmʉsi, yeba sã pehrequerecʉ̃ Goãmʉ ĩgʉ werediro dopa ta iipehogʉcumi, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Eropa arĩtuhaja õpa arĩnemopʉ Jesu: —Masʉ ĩgʉ marapore cóãgʉ, gajigo mera marapocʉgʉ ĩgʉ igo mera ñero iigʉ iimi. Tuhaja masʉ gajigʉ ĩgʉ cóãdigo mera marapocʉgʉ ĩgʉ sã igo mera ñero iigʉ iimi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Eropa i queori werepʉ Jesu: —Yujugʉ doberi opʉ árĩñumi. Suhri wajacʉrire sañagʉ árĩñumi. Eropigʉ ʉmʉri nʉcʉ õari dihtare bagʉ, baja opañumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eropigʉ irisubure gajigʉ árĩñumi. Ĩgʉ mojomorocʉgʉ Lázaro waĩcʉgʉ árĩñumi. Ĩgʉ ĩgʉ dʉpʉre baja camicʉgʉ árĩñumi. Eropirã gajirãpʉ ĩgʉre doberi opʉ ya wihi disiporo aĩgã apimʉriñuma. ");
INSERT INTO des_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Eropigʉ mojomorocʉgʉpʉ doberi opʉ ĩgʉ ba dʉharire gamemʉriñumi. “Ba dʉhari mera yapigʉca yʉhʉ,” arĩ pepimʉriñumi ĩgʉ. Ero oyarisubu diayea ĩgʉ pohro eja ĩgʉ camire neremʉriñuma. ");
INSERT INTO des_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Eropigʉ mojomorocʉgʉ sĩria wañumi. Ĩgʉ sĩria wacʉ̃, Abrahã pohrogue paraíso waĩcʉrogue anyua ĩgʉre aĩ mʉriañuma. Eropigʉ doberi opʉ sã ĩgʉ pʉhrʉ sĩria wañumi. Ĩgʉ sĩricʉ̃ ĩgʉre yaañuma. ");
INSERT INTO des_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Eropiro doberi opʉre peamegue ejagʉ bʉrigã teboricʉñumi. Eropigʉ peamegue árĩgʉ ʉmʉsigue árĩgʉre Abrahãre ĩhamujuñumi. Lázaro mʉrʉ sãre ĩañumi. ");
INSERT INTO des_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ĩatuha ĩgʉ Abrahãre sihubeoñumi. “Ahʉ, Abrahã, mojomoro ĩaque yʉre. Peamegue yʉhʉ ñero tarigʉ iica. Yʉ eropa wacʉ̃ Lázarore yʉre obeoque. Eropigʉ ĩgʉ decore ĩgʉ mujusĩru mera yoso, yʉ nerore deco mera nehoporo. Irire yʉsuporo ĩgʉ,” arĩriñumi doberi opʉ mʉrʉ. ");
INSERT INTO des_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ĩgʉ eroparĩquerecʉ̃ Abrahãpʉ ĩgʉre wereñumi: “Mahgʉ, ojocarigʉ árĩgʉ árĩpehrerire õarire opabʉ mʉhʉ. Lázaropʉ ʉmʉri nʉcʉ ñero tarimi. Dohpaguere mʉ ñero taricʉ̃ ĩgʉpʉ õguere mucubiriri mera árĩcãgʉ iimi. ");
INSERT INTO des_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eropiro mari watope ʉ̃hcãri waya ãhraa. Eropirã õre árĩrã eroguere wamasibeama. Tuhaja erogue árĩrã õre aridiaquererã ta õguere arimasibeama,” arĩñumi Abrahã doberi opʉ mʉrʉre. ");
INSERT INTO des_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ĩgʉ eroparĩcʉ̃ doberi opʉ õpa arĩnemoñumi: “Acaweregʉ, turaro serẽa mʉre. Lázarore yʉ pagʉ ya wihigue obeoque. ");
INSERT INTO des_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yʉhʉ yuju mojoto majarã pehrerã pagʉ porãcʉa. Lázaro erãre wereporo. Õre erã ñero tariroguere aribiricãporo,” arĩñumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ĩgʉ eroparĩcʉ̃ Abrahãpʉ yʉhriñumi: “Goãmʉ dorerire Moise ĩgʉ apirare, Goãmʉ weremʉhtanirã erã gojarare opama mʉ pagʉ porã. Eropirã mʉ pagʉ porã irire ta peeporo,” arĩñumi Abrahã. ");
INSERT INTO des_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ĩgʉ eroparĩcʉ̃ doberi opʉpʉ yʉhriñumi: “Ahʉ, Abrahã, irire opaquererã ta õaro peesome. Lázaro sĩridigʉ masadigʉ erã pohro ĩgʉ ejacʉ̃ ĩarã erãpʉ erã ñero iirire bʉjawere, õaripʉre gohrotorãcoma. Eropirã õarire iirãcoma yʉ pagʉ porãpʉ,” arĩñumi doberi opʉ mʉrʉ. ");
INSERT INTO des_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ĩgʉ eroparĩcʉ̃ Abrahãpʉ wereñumi: “Mʉ pagʉ porã Moise ĩgʉ apirapũ ĩgʉ wererare, Goãmʉ yare weremʉhtanirã erã wererare peebirã ãhrima. Eropirã Lázaro mʉrʉ sĩridigʉgue masadigʉ ĩgʉ árĩquerecʉ̃ ta erã Goãmʉ yare peesome,” arĩñumi Abrahã, arĩ werepʉ Jesu masare. ");
INSERT INTO des_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Eropi Jesu werepʉ ĩgʉ buherãre: —Mʉare ñeri iidoreri baja ãhraa. Eropirã masa ñerire iima. Iri eropa árĩquerecʉ̃ ta masʉre ñerire iidoregʉpʉ ñetariaro tarigʉcumi. ");
INSERT INTO des_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gajigʉre masa ĩgʉ wʉnʉgʉre wʉariye ʉtãyere dirisiu, wʉariyague ĩgʉre cóãcʉ̃ ñero wabocumi ĩgʉ. Eropigʉ oãgã mera majarãre ñerire iidoredigʉpʉ wʉariyague erã cóãdigʉ tauro ñero tarigʉcumi. Ĩgʉre bʉrigã dipuwaja moasũgʉcumi. ");
INSERT INTO des_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Õaro iique mʉa. Mʉa acaweregʉ ñero ĩgʉ iicʉ̃ ĩarã, “Iibita,” arĩque ĩgʉre. Eropirã ĩgʉ ñero iirire ĩgʉ bʉjawerecʉ̃, õarire gohrotocʉ̃ mʉapʉ ĩgʉ ñeri iirire cãdijique. ");
INSERT INTO des_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eropigʉ mʉa acaweregʉ yujunʉ ta siete suburi mʉare ĩgʉ ñero iibocumi. Ĩgʉ eropa iicʉ̃ yujuyerisubure mʉare, “Yʉ ñero iirire bʉjawerea. Õarire gohrotogʉ iiaa,” ĩgʉ arĩcʉ̃ iri nʉcʉ suburi ĩgʉ ñero iirire cãdijique, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eropi Jesu buherã ĩgʉre õpa arĩñorã: —Goãmʉre gʉare õaro umupeonemocʉ̃ iique, arĩñorã Jesure. ");
INSERT INTO des_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —“Goãmʉre diaye ta iigʉ ãhrimi,” mʉa arĩ umupeorã miriyegã mostazaye pẽgã mʉa umupeoquererã irigʉ sicómoro waĩcʉdigʉre õpa iimasia: “Irigʉ yucʉgʉ irigʉ basi tara duhagãporo. Wʉariyague yuriñajaporo,” arĩmasia mʉa. Mʉa eroparĩcʉ̃ irigʉ yucʉgʉpʉ mʉa dorero dopa ta waroca, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Pʉhrʉ i werenigui queoriñere werepʉ Jesu: —Mʉare mohme coregʉ poheguere tãra, mohmemi. Ĩgʉ ovejare ĩhadibumi. ¿Ĩgʉ eropa mohme ĩgʉ dujaracʉ̃ ĩarã dohpa arĩbocuri mʉa ĩgʉre? “Yojaro arique. Mʉ bari ohõ ãhraa,” ¿arĩbocuri mʉa? ");
INSERT INTO des_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Eropa arĩbeaa mʉa. Ĩgʉre õpa arãa mʉa: “Yʉ baburire iique. Eropigʉ yʉ baha ihricʉ̃ yʉre coreque. Yʉ pʉhrʉ mʉ sã baha ihrique,” arãa mʉa mohme coregʉre. ");
INSERT INTO des_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mohme coregʉ ĩgʉ mʉa mohmedorerire ĩgʉ iicʉ̃ ĩgʉre “Õhaa,” arĩbeaa mʉa. Ĩgʉre mʉa dorero dihtare iigʉ iicumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mʉa sã ĩgʉ iro dopa ta ãhraa. Goãmʉ ĩgʉ dorediro dopa ta iipehorã õpa arĩ pepique mʉa. “Gʉa mohme corerã dihta ãhraa. Gʉare ĩgʉ dorero dihtare iiabʉ gʉa,” arĩ pepique mʉa, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Gajinʉ Jerusaléngue Jesu wagʉ iipʉ. Eropa wagʉ Samaria yeba, Galilea yeba deco tarigãpʉ. ");
INSERT INTO des_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Gaji macague wari mague ĩgʉ curicʉ̃ diez cami boarãpʉ ĩgʉre bocatĩriñorã. Eropirã yoañarirogue niguirã ta piyuñorã: —Jesu, opʉ, gʉare mojomoro ĩaque, arĩñorã. ");
INSERT INTO des_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Erã eroparĩcʉ̃ erãre ĩha, werepʉ Jesu: —Pahire mʉa dʉpʉrire õaro warare ĩhmurã waque, arĩpʉ erãre. Ĩgʉ eropa arĩra pʉhrʉ erã warisubu erã dʉpʉ õarã wañorã. ");
INSERT INTO des_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Eropigʉ yujugʉ erã mera majagʉ ĩgʉ dʉpʉ õari dʉpʉ wacʉ̃ ĩagʉ, Jesu pohrogue maji dujariripʉ. Eropa dujarigʉ turaro mera Goãmʉre umupeopʉ. “Goãmʉ turagʉ, õagʉ ãhrimi,” arĩ umupeopʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eropa arĩgʉ ĩgʉ Jesu guburi pohro mereja “Õhaa,” arĩpʉ. Ĩgʉpʉ Samaria majagʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ĩgʉ eropa iira pʉhrʉ Jesu õpa arĩ werepʉ: —Diez ãhrama masa õarã wanirã. ¿Gajirã nueve dʉhyarãpʉ nohogue árĩcuri erã? ");
INSERT INTO des_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ihĩ gaji yeba majagʉ dihta Goãmʉre “Õhaa,” arĩgʉ dujarami. ¿Duhpirã gajirãpʉ aribirari? arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eropa arĩtuha Jesu merejadigʉre arĩpʉ. —Wahgãnʉgajaque. Waque. Mʉ Goãmʉre umupeogʉ õagʉ wahabʉ mʉhʉ, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Irisubure bajamerãgã fariseo masa Jesure serẽpiñorã: —¿Dohpárĩcʉ̃ Goãmʉ opʉ árĩnʉgagʉcuri? arĩ serẽpiñorã erã. Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Goãmʉ ĩgʉ opʉ árĩnʉgacʉ̃ mʉa ĩhamasibeaa. ");
INSERT INTO des_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Goãmʉ ĩgʉ opʉ árĩri ohõ ãhraa,” arĩmasibeaa. “Sohõgue ãhraa,” arĩmasibeaa. Goãmʉ ĩgʉ opʉ árĩri masa erã pepirigue ãhraa, arĩpʉ Jesu fariseo masare. ");
INSERT INTO des_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Eropa arĩtuha Jesu ĩgʉ buherãre õpa arĩ werepʉ: —Pʉhrʉ yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉ i yebague dujariburire bʉrigã gamerãca mʉa. “Ĩgʉre yujunʉ gohra mari ĩacʉ̃ õaboaya,” arĩ quererã ta yʉre ĩanisome mʉa. Eropa mʉa gamequerecʉ̃ ta irisubure arisome yʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Gajirã mʉare õpa arĩrãcoma. “Ĩgʉre ĩaque. Ĩgʉ Cristo ãhrimi. Sihĩre ĩaque. Cristo ãhrimi,” arĩrãcoma mʉare. Erã eropa arĩquerecʉ̃ ta erãre peebiricãque. ");
INSERT INTO des_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bupu ʉmarore guñaña mariro miaro dopa ta guñaña mariro arigʉca yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ dujarigʉ. ");
INSERT INTO des_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ire yʉ iiboro core yʉhʉ turaro ñero tarigʉca. Eropirã yʉre dohpague majarã gamesome. ");
INSERT INTO des_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé ĩgʉ árĩrasubu majarã erã árĩmʉridiro dopa ta yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉ dujariboro coregã eropa ta árĩrãcoma masa. ");
INSERT INTO des_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé ĩgʉ árĩrasubure árĩpehrerã masa eropa baha, ihri iiñuma. Eropirã mojoto dirimʉriñuma. Noé wʉadiru dohodirugue ĩgʉ ñajaboro core Goãmʉ erãre ĩgʉ miupehoboro core iri árĩpehrerire masa mʉraro ta iiniguicãmʉriñorã. Eropa árĩroca yʉ dujaricʉ̃ sãre. ");
INSERT INTO des_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lote ĩgʉ árĩrasubu majarã sã erã árĩdiro dopa ta yʉ dujaricʉ̃ árĩrãcoma masa. Lote ĩgʉ árĩrasubure masa baha, ihri, asũ, dua, ote, wirire iiñuma. ");
INSERT INTO des_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Erã eropa iirisubu ĩgʉ ya macare Sodoma waĩcʉri maca Lote ĩgʉ waranʉ ʉmaro maja peame ʉ̃jʉ dijari erãre wejẽpehocãyoro. ");
INSERT INTO des_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉhʉ guñaña mariro yʉ dujaricʉ̃ eropa ta waroca irisubure. ");
INSERT INTO des_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Irisubure yujugʉ ĩgʉ ya wihi weca maja pʉʉgue árĩgʉ wihi pohecague ĩgʉ yare aĩgʉ ñajabiricãporo pobero mera duhriboro dopa. Eropigʉ pohegue árĩgʉ sã irisubure ĩgʉ ya wihigue piharibiricãporo. ");
INSERT INTO des_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lote marapo igo warare guñaque. ");
INSERT INTO des_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ĩgʉ ya árĩburi dihtare yujugʉ guñagʉ peamegue wagʉcumi ĩgʉ. Yaha árĩburipʉre yujugʉ guñagʉ árĩpehrerinʉri Goãmʉ mera õaro árĩgʉcumi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Yʉhʉ mʉare werea. Irisubure yʉre umupeorãre beye gameneodoregʉca. Eropigʉ eropa wari ñamire yuju camare perã carĩcʉ̃ yujugʉre yʉre umupeogʉre aĩrãcoma yʉ mera árĩbure. Gajigʉ yʉre umupeobigʉ ero dujagʉcumi. ");
INSERT INTO des_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Eropa ta nome perã erã ya ojodʉcare erã biucʉ̃ yujugore aĩrãcoma. Yujugo ero dujagocumo. ");
INSERT INTO des_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Eropigʉ perã poheguere mohmerã árĩcʉ̃ yujugʉre aĩrãcoma. Yujugʉ ero dujagʉcumi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ĩgʉ eroparĩcʉ̃ ĩgʉ buherãpʉ serẽpiñorã. —¿Nohogue eropa warocuri? arĩ serẽpiñorã erã. Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Masa erã ñeri erã iiniguirogue, erogue Goãmʉ erãre erã ñeri dipuwaja moagʉcumi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Eropi Jesu erãre Goãmʉre serẽburire weregʉ õpa arĩpʉ: —Mʉa Goãmʉre serẽrã coreque ĩgʉ yʉhriborore. Yoari boje corequererã ta bʉjawerebiricãque. Ĩgʉre serẽrã duhubita, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ĩgʉ eropa arĩrare buhebu i queori mera werepʉ erãre: —Gaji macague masare dipuwaja moadoregʉ árĩpʉ. Ĩgʉ Goãmʉre umupeobiripʉ. Eropigʉ masa sãre umupeobiripʉ. ");
INSERT INTO des_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Eropigo wapeweyo sã erogue árĩpo. Igo ĩgʉ pohrogue dʉrʉro curigo õpa arĩpo: “Yʉre ĩhaturigʉre dipuwaja moadoreque mʉhʉ. Yʉre arĩ cãhmotaque,” arĩ serẽniguicãpo igo ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Igo eroparĩcʉ̃ ĩgʉ bajasuburi “Iisome yʉhʉ,” arĩripʉ igore. Ĩgʉ eropa arĩquerecʉ̃ ta igo bajasuburi ĩgʉre eropa serẽniguicãgo garibotariaro iipo. Igo garibocʉ̃ ĩagʉ õpa arĩpʉ ĩgʉ basi. “Yʉhʉ Goãmʉre masa sãre umupeobeaa. ");
INSERT INTO des_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yʉ eropa umupeobigʉ árĩquerecʉ̃ ta igopʉ yʉre garibotaricãmo. Yʉre eropa garibogo yʉre gariboreacʉ̃ iicumo yʉre. Igo eropa arĩ weresãniguicʉ̃ igore ĩhaturigʉre dipuwaja moadoregʉra,” arĩpʉ dipuwaja moadoregʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Eropa arĩgʉ Jesu erãre werenemopʉ: —Eropa arĩpʉ ĩgʉ ñegʉ dipuwaja moadoregʉ. Ĩgʉ eropa arĩrare guñaque mʉa. ");
INSERT INTO des_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ĩgʉ tauro Goãmʉpʉ ĩgʉ yarãre ʉmʉri nʉcʉ ĩgʉre serẽrãre itamugʉcumi. ");
INSERT INTO des_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mʉare arĩgʉ tiiaa. Goãmʉ erãre mata iigʉcumi erã serẽrare. ¿Ĩgʉ eropa yʉhrigʉ ĩgʉ árĩcʉ̃ ta yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ i yebague dujarigʉ, Goãmʉre umupeorãre ĩgʉre serẽrãre bocagʉcuri yʉhʉ? arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Eropi gaji queori mera werepʉ Jesu. “Gʉapʉ õarã ãhraa. Gajirãpʉ ñero iirã ãhrima,” arĩ pepirãre i queori mera õpa arĩ werepʉ: ");
INSERT INTO des_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Goãmʉ ya wihigue perã ʉma Goãmʉ mera wereniguirã wañorã. Yujugʉ fariseo masʉ árĩpʉ. Gajigʉ wajasea coregʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Eropigʉ fariseo masʉpʉ nʉgaja, õpa arĩ serẽ niguipʉ Goãmʉre: “Yʉhʉ gʉya yajaricʉgʉ, diaye iibigʉ, nome mera ñero iigʉ árĩbeaa. Gajirã iro dopa árĩbeaa. Ihĩ wajasea coregʉ iro dopa ñegʉ árĩbeaa. Eropigʉ mʉre Goãmʉre õhaa, arãa. ");
INSERT INTO des_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yʉhʉ semanari nʉcʉ mʉ ya árĩburire iigʉ pesubu ba duhua. Eropigʉ diez niyeruserire wajatagʉ yujuse mʉre ohoa,” arĩpʉ fariseo masʉ Goãmʉre. ");
INSERT INTO des_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Eropigʉ wajasea coregʉpʉ yoarogue niguigʉ muhri siunʉgaja, ĩgʉ ñerire bʉjawere, ʉmarogue ĩabiripʉ. Ĩgʉ ñerire bʉjaweredigʉ árĩgʉ ĩgʉ coretibi pa, wereniguipʉ Goãmʉre: “Goãmʉ, yʉhʉ ñegʉ ãhraa. Eropigʉ mʉhʉ yʉre mojomoro ĩaque,” arĩpʉ ĩgʉ Goãmʉre. ");
INSERT INTO des_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eropigʉ mʉare arĩgʉ iiaa. Ihĩ wajasea coregʉpʉ ĩgʉ wihigue ĩgʉ dujagʉ ĩgʉ ñerire Goãmʉ mera cóãdigʉ dujapʉ. Gajigʉ fariseo masʉ ĩgʉ ñerire cóãdigʉ árĩbiripʉ. “Yʉhʉ õagʉ ãhraa,” arĩgʉ Goãmʉ ĩgʉ ĩacʉ̃ ñegʉ árĩmi. “Yʉhʉ ñegʉ ãhraa. Eropigʉ yʉ ñerire bʉjawerea,” arĩgʉpʉre Goãmʉ õagʉ iigʉcumi ĩgʉre, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Eropi masa erã porã majirãgãre Jesure mohme­pi­ñadoremorã ĩgʉ pohrogue aĩ erariñorã. Erã eropiicʉ̃ ĩarã Jesu buherã erãgãre aĩrarãre turiñorã. ");
INSERT INTO des_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Erã eropa turicʉ̃ ĩagʉ Jesu majirãgãre sihubeopʉ ĩgʉ pohrogue. Sihubeo õpa arĩpʉ ĩgʉ ĩgʉ buherãre: —Majirãgã yʉ pohrogue ariporo. “Waque,” arĩbita erãgãre. Erãgã Goãmʉre erã opʉ iro dopa pepima. Eropirã Goãmʉ ĩgʉ opʉ árĩroguere oãgã iro dopa pepirã ãhrima eroguere. ");
INSERT INTO des_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Diaye arĩgʉ iiaa mʉare. Oãgã Goãmʉre erã gamediro dopa ta mʉa Goãmʉre gamebirã ĩgʉ pohrogue wasome mʉa. Mʉa wabiricʉ̃ mʉa opʉ árĩsome ĩgʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ĩgʉ eropa arĩra pʉhrʉ judio masa oparã mera majagʉ Jesure serẽpi erapʉ. —Ne õagʉ, buhegʉ ãhraa mʉhʉ. ¿Yʉ árĩpehrerinʉri Goãmʉ mera árĩdiagʉ dohpa iigʉcuri yʉhʉ? arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ĩgʉ eroparĩcʉ̃ Jesu yʉhripʉ: —¿Dohpa arĩronore yʉre “Õagʉ,” arĩ piyuri mʉhʉ? Goãmʉ dihta õagʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","I Goãmʉ dorerire masia mʉhʉ. “Gajigʉ marapo mera árĩbiricãque. Masare wejẽbiricãque. Yajabiricãque. Gʉyabiricãque. Mʉ pagʉ sʉmarãre umupeoque,” arĩ doremi Goãmʉ. Eropigʉ irire iique mʉhʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ĩgʉ eroparĩcʉ̃ ĩgʉ Jesure yʉhripʉ: —Iri árĩpehrerire majigʉgãgue ta iibʉ yʉhʉ, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu ĩgʉre õpa arĩ werepʉ: —Yujuñe dihta dʉhyaa mʉre mʉ iiboro. Árĩpehreri mʉ yare duagʉ waque. Eropa iigʉ árĩpehreri niyeru mʉ wajatarire mojomorocʉrãre oque. Mʉ eropa iicʉ̃ wʉaro mʉ ya õari mʉhʉ opaburire ʉmaroguere Goãmʉ pohroguere árĩroca. Eropa iituha yʉ mera majagʉ árĩbu arique, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ĩgʉ eroparĩcʉ̃ peegʉ ĩgʉpʉ baja doberi opagʉ árĩgʉ irire mojomorocʉrãre odiabigʉ, turaro bʉjawere waha wapʉ. ");
INSERT INTO des_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ĩgʉ eropa bʉjawerecʉ̃ ĩagʉ Jesu õpa arĩ werepʉ gajirãre: —Doberi oparãre Goãmʉ ĩgʉ opʉ árĩroguere erã wacʉ̃ diasataria. ");
INSERT INTO des_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camello waĩcʉgʉ waibʉgʉpʉ ĩgʉpʉ awiru gobegãgue ĩgʉ ñajacʉ̃ masiya mara ĩgʉre. Eropa ta doberi opagʉ Goãmʉ mera õaro árĩgʉ ĩgʉ opʉ árĩroguere wacʉ̃ diasataria, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ĩgʉ eroparĩcʉ̃ ĩgʉre peerã õpa arĩñorã: —Cue. Mʉ arĩro dopa ta diaye árĩcʉ̃, ne yujugʉ masʉre Goãmʉ taubiribocumi ĩgʉ pohro waborore, arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Masa erã bocatĩuro erã õaro iira mera Goãmʉ pohrogue wamasibeama. Goãmʉpʉ masare peamegue wabonirãre taumasimi. Ĩgʉ árĩpehrerire õaro iimasipehocãmi, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ĩgʉ eroparĩcʉ̃ Pedro ĩgʉre õpa arĩpʉ: —Peenique. Gʉa árĩpehreri gʉa yare apicãbʉ mʉ mera warã, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ĩgʉ eroparĩcʉ̃ Jesu õpa arĩpʉ: —Diaye mʉare arĩgʉ iiaa. Árĩpehrerã mʉa Goãmʉ yare iimorã mʉa wirire, mʉa marasã nomere, mʉa pagʉ porãre, mʉa pagʉ sʉmarãre, mʉa porãre mʉa apinirã mʉa wʉaro wajatarãca dohpaguere. ");
INSERT INTO des_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Mʉa apidiro tauro wajatarãca. Eropirã mʉa sĩrira pʉhrʉ árĩpehrerinʉri Goãmʉ mera árĩrãca mʉa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Eropi doce ĩgʉ buherã dihtare aĩgã erãre werepʉ: —Peeque yʉre. Dohpaguere mari Jerusaléngue warã iiaa. Erogue yʉre Goãmʉ ĩgʉ obeodigʉre Goãmʉ ya weremʉhtanirã iribojegue erã werediro dopa ta eropa waroca yʉre. ");
INSERT INTO des_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ero masa yʉre ñeha, judio masa árĩbirãre orãcoma yʉre. Yʉre erã ora pʉhrʉ erã yʉre wereya, ñero arĩ, disico ehosũrãcoma. ");
INSERT INTO des_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eropirã yʉre tãratuhaja wejẽrãcoma yʉre. Eropigʉ yʉ sĩrira pʉhrʉ ʉhrenʉ waboro masa mʉriagʉca yʉhʉ, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ĩgʉ eroparĩcʉ̃ ĩgʉ buherã ĩgʉ wererire õaro pee masibiriñorã. Goãmʉ irire erãre masicʉ̃ iibirinipʉ dohpa. ");
INSERT INTO des_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Eropi Jesu sã Jericó waĩcʉri maca pohrogue ejañorã. Ĩgʉ wari maha tʉrogue yujugʉ masʉ cuiri ĩhajabigʉ doapʉ. Niyeru serẽgʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eropigʉ masa bajarã ĩgʉ pohro aricʉ̃ peegʉ serẽpipʉ ero árĩrãre. —¿Duhpirã masa bajarã tarigãri? arĩ serẽpipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Jesu Nazare majagʉ arigʉ iimi, arĩñorã gajirã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Erã eropa arĩ werecʉ̃ peegʉ ĩgʉ gaguiniguinʉgapʉ: —Jesu, opʉ Davi mʉrʉ pãrami masare taubu, yʉre mojomoro ĩaque, arĩ gaguiniguipʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ĩgʉ eroparĩcʉ̃ ĩgʉ pohro árĩrãpʉ “Ejarimaricãque,” arĩ turiñorã ĩgʉre. Erã eropa arĩ turiquerecʉ̃ ta ĩgʉ ero core ĩgʉ gaguiniguidiro tauro gaguiniguinemopʉ daja. —Opʉ Davi mʉrʉ pãrami, yʉre mojomoro ĩaque, arĩ gaguiniguipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ĩgʉ eropa gaguiniguicʉ̃ peegʉ Jesupʉ nʉgaja, “Sihubeoque ĩgʉre,” arĩpʉ. Ĩgʉ eroparĩcʉ̃ erãpʉ cuiri ĩhajabigʉre sihugãñorã. Erã eropa sihugãcʉ̃ ĩgʉ Jesu pohrogue ĩgʉ ejacʉ̃ Jesupʉ ĩgʉre serẽpipʉ: ");
INSERT INTO des_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Dohpa yʉ iicʉ̃ gahmeri mʉhʉ? arĩpʉ Jesu. —Yʉ Opʉ, yʉre ĩacʉ̃ iique, arĩpʉ cuiri ĩhajabigʉ. ");
INSERT INTO des_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Ĩaque pare. Yʉre umupeonijagʉ, õagʉ wahaa mʉhʉ, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ĩgʉ eroparĩcʉ̃ ta cuiri ĩhajabigʉ õaro ĩha wapʉ. Eropa õagʉ wanijagʉ ĩgʉ Jesu mera wapʉ. “Goãmʉ turagʉ ãhrimi,” arĩ umupeopʉ ĩgʉ. Eropirã masa bajarã cuiri ĩhajabiridigʉ ĩgʉ õagʉ wacʉ̃ ĩarã, “Goãmʉ õagʉ, turagʉ ãhrimi,” arĩ umupeoñorã erã sã. ");
INSERT INTO des_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Eropii Jesu Jericógue eja, iri macague tarigãbu iipʉ. ");
INSERT INTO des_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Doberi opʉ Zaqueo waĩcʉgʉ wajasea corerã opʉ ero árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Eropigʉ ĩgʉ Jesure “¿Nihino árĩcuri?” arĩ ĩha masibu Jesure ĩadiaripʉ. Eropa ĩgʉ ĩadiaquerecʉ̃ ta ĩgʉ yebagʉgã árĩcʉ̃ masa bajarã ĩgʉgãre cãhmotacãñorã. ");
INSERT INTO des_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eropigʉ ĩgʉ masare omatarigã wa, sicómoro waĩcʉdigʉ yucʉgʉgue mʉribejapʉ Jesure ĩabu. Pʉhrʉ ñarigã Jesu irigʉ pohro tarigãbu iipʉ. Eropigʉ Zaqueo irigʉgue coregʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ĩgʉ eropa corero watope Jesupʉ irigʉ gubuye ejanʉgaja, Zaqueore ĩhamuju ĩgʉre werepʉ: —Zaqueo, dohpaguere mʉ ya wihi dujagʉra. Eropigʉ duru dijarique, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ĩgʉ eroparĩcʉ̃ Zaqueopʉ ʉmʉdiaro mera dijari, mucubiriri mera ĩgʉ ya wihigue aridorepʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ĩgʉ eropa bocatĩricʉ̃ ĩha, masa árĩpehrerã erã basi õpa arĩ wereniguiñorã: —Ihĩ Jesu ñegʉ ya wihigue curigʉ wadiami, arĩ wereniguiñorã árĩpehrerã masa erã basi. ");
INSERT INTO des_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueopʉ bocatĩrituha ero nigui, Jesure werepʉ: —Opʉ, peeque yʉre. Árĩpehreri yahare deco mera mojomorocʉrãre ogʉra. Eropigʉ yʉhʉ gajigʉre cien niyeruserire gʉya aĩdigʉ árĩgʉ, cuatro cientos niyeruserire wajayenemogʉra ĩgʉre, arĩpʉ Zaqueo Jesure. ");
INSERT INTO des_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ĩgʉ eroparĩcʉ̃ Jesupʉ werepʉ ĩgʉre: —Dohpagãre mʉre mʉ ya wihi árĩrã sãre peamegue wabonirãre Goãmʉ tautuhami. Mʉ sã Abrahã mʉrʉ acaweregʉ ta ãhraa. ");
INSERT INTO des_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ peamegue wabonirãre amagʉ arigʉ iibʉ. Erogue wabonirãre õaro taugʉ arigʉ iibʉ, arĩpʉ Jesu Zaqueore. ");
INSERT INTO des_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Eropi ĩgʉre peerãre Jesu queori mera werepʉ daja. Merogã dʉhyayoro Jerusaléngue ĩgʉ ejaboro. Eropirã ĩgʉre peerã õpa arĩ pepiñorã: “Goãmʉ dohpaguere opʉ árĩnʉgabu iimi,” arĩ pepiriñorã erã. ");
INSERT INTO des_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Erã eropa arĩ pepicʉ̃ Jesu i queorire õpa werepʉ erãre: —Yujugʉ gaji yebague yoarogue wabu iiñumi. Eroguere ero majagʉ erã tauro opʉ árĩgʉ ĩgʉre ĩgʉ ya maca majarã opʉre acucʉ̃ wabu iiñumi. Pʉhrʉ ĩgʉ ya wihigue dujarabu iiñumi. ");
INSERT INTO des_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nere ĩgʉ waboro corere diez mohme corerãre sihubeoñumi. Eropa sihubeogʉ, ĩgʉ erãre yujurãyerire yujuse niyeruse orosere oñumi. Otuha wereñumi erãre: “Yʉ maricʉ̃ i niyeru mera mʉa wajatanemoburire amaque,” arĩñumi ĩgʉ mohme corerãre. ");
INSERT INTO des_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ĩgʉ ya yeba majarãpʉ ĩgʉre gamebiriñuma. Eropa gamebirã ĩgʉ opʉ árĩbu wara pʉhrʉ gajirãre ĩgʉre weredorerã obeoñuma. “Mʉhʉ gʉa opʉ árĩcʉ̃ gamebeaa gʉa,” arĩñuma erã weredorenirãpʉ. ");
INSERT INTO des_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Eropa erã gamebiriquerecʉ̃ ta pʉhrʉ erã opʉ ñajañumi ĩgʉ. Eropa opʉ ñajatuha, ĩgʉ ĩgʉ ya wihigue dujariñumi. Eropa dujaragʉ ĩgʉ mohme corerãre ĩgʉ niyeru mera erã wajatanemorare masibu, erãre sihubeoñumi. ");
INSERT INTO des_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ĩgʉ eropa sihubeora pʉhrʉ, eramʉhtagʉ ĩgʉre wereñumi: “Opʉ, mʉ niyeruse, mʉ yʉre orase mera diez seri wajatanemoabʉ yʉhʉ,” arĩñumi mohme coregʉ ĩgʉ opʉre. ");
INSERT INTO des_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Õaro iiabʉ mʉhʉ. Õagʉ mohme coregʉ ãhraa. Mʉ merogã mera yʉ dorero dopa iipehogʉ árĩgʉ dohpague diez macari majarã erã opʉ árĩbu wagʉca mʉhʉ,” arĩñumi opʉ mohme coregʉre. ");
INSERT INTO des_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ĩgʉ pʉhrʉ eragʉ ĩgʉ mera majagʉ õpa arĩñumi: “Opʉ, mʉ niyeruse, yʉre mʉ orase mera cinco seri wajatanemoabʉ yʉ sã,” arĩ wereñumi ĩgʉ opʉre. ");
INSERT INTO des_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Cinco macari majarã opʉ wagʉca mʉhʉ,” arĩñumi ĩgʉ opʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ĩgʉ eropa arĩra pʉhrʉ gajigʉ mohme coregʉ eraa werepʉ: “Opʉ, mʉ niyeruse ohõ ãhraa. Suhri gasiro mera oma, irisere dihbuabʉ. ");
INSERT INTO des_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉhʉ turaro mohmedoregʉ ãhraa. Eropigʉ gajirãre mohmedorequeregʉ oteri moogʉ árĩqueregʉ ta mʉ dihta iri dʉcare aĩa. Eropigʉ mʉre güiabʉ,” arĩñumi ĩgʉ opʉre. ");
INSERT INTO des_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mʉ yʉre eropa arĩgʉ ñegʉ ãhraa. Yʉre mʉ eropa arĩri dipuwajare dipuwaja moagʉra yʉhʉ. Yʉhʉ mʉre turaro mohmedoregʉ árĩcʉ̃ mʉhʉ yʉre masia. Gajirã yare yʉhʉ aĩcʉ̃ yʉhʉ otebirira árĩquerecʉ̃ iri dʉcare yʉ aĩgʉ árĩcʉ̃ masituhabʉ mʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Yʉ eropa árĩcʉ̃ ĩaqueregʉ duhpigʉ yʉ orasere niyeru diburi wihigue dibubirari mʉhʉ? Irire erã wayura waja wajatanemoboaya mʉhʉ. Irire mʉ iicʉ̃ dujaragʉ wajatanemoboaya yʉ sã,” arĩñumi erã opʉ. ");
INSERT INTO des_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Eropa arĩtuha ĩgʉ pohro niguirãre doreñumi: “Niyerusere emaque ĩgʉre. Diez seri opagʉre oque,” arĩñumi ĩgʉ opʉ. ");
INSERT INTO des_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ĩgʉ eroparĩcʉ̃ erãpʉ wereñuma ĩgʉre: “Opʉ, diez seri opagʉ baja opatuhami,” arĩñuma erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Erã eroparĩcʉ̃ opʉ yʉhriñumi: “Mʉare arĩgʉ iiaa. Árĩpehrerã wʉaro oparãre onemogʉra. Moorãpʉre merogã erã opaquerecʉ̃ ta erãre emagʉra. ");
INSERT INTO des_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dohpague tamerare yʉre ĩhaturirãre yʉre erã opʉ árĩdorebirinirãre yʉ pohro aĩgãrique. Eropirã yʉ ĩaro wejẽcãque erãre,” arĩñumi opʉ ĩgʉ mohme corerãre, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Eropa arĩtuha Jesu gajirã core Jerusaléngue wagʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jerusaléngue ejaboro coregã Olivo waĩcʉdigʉ ʉtãgʉ gubuyegue ejañorã pe maca árĩrogue. Yuju maca Betfagé gaji maca Betania waĩcʉyoro. Erogue ejagʉ ĩgʉ buherã mera majarãre perãre obeogʉ Jesu õpa arĩpʉ: ");
INSERT INTO des_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Si macague waque. Ero ejarã, burrogãre erã dirinugudigʉre bocajarãca. Gajirã ĩgʉre ne peyanibeama dohpa. Ĩgʉre bocarã, ĩgʉre diriradare pã, aĩgãribasaque yʉre. ");
INSERT INTO des_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mʉa eropa iicʉ̃ ĩagʉpʉ “¿Duhpirã burrore pãri?” ĩgʉ arĩcʉ̃ peerã õpa arĩ yʉhrique ĩgʉre: “Mari tĩgʉ burrore gamebeoniami dohpa,” arĩ wereque ĩgʉre, arĩ weredore obeopʉ ĩgʉ buherãre perãre. ");
INSERT INTO des_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ĩgʉ eroparĩcʉ̃ erã perãpʉ ĩgʉ obeodirogue ejañorã. Erã eropa ejacʉ̃ Jesu árĩpehreri ĩgʉ erãre arĩdiro dopa ta eropa wayoro. ");
INSERT INTO des_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eropirã burrogãre erã pãcʉ̃ ĩgʉgã oparã serẽpiñorã erãre: —¿Duhpimorã diriradare pãri burrogãre? arĩ serẽpiñorã erã. ");
INSERT INTO des_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Mari tĩgʉ burrogãre gamebeoniami, arĩ yʉhriñorã erã. ");
INSERT INTO des_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eropirã ĩgʉgãre burrogãre Jesu pohrogue aĩ ejañorã. Ĩgʉgãre aĩ ejatuhaja erã weca maja suhrire ĩgʉ weca duhpeoñorã. Eropirã ĩgʉ weca Jesu ĩgʉ mʉribejacʉ̃ itamuñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesu ĩgʉ weca ĩgʉ peyagʉ wacʉ̃ erã masa erã weca suhri sañari suhrire tuwea aĩ mague seõpi mʉhtañorã ĩgʉ core. ");
INSERT INTO des_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eropirã Jerusalén pohrogue eja, Olivo waĩcʉdigʉ dijariri mague ejañorã. Erogue ejarã Jesu buherã bajarã árĩpehrerire ĩgʉ deyoro moarare, ĩgʉ õari ĩgʉ iirare erã ĩarare guña mucubiri Goãmʉre õaro wereniguinʉgañorã. Goãmʉre “Õagʉ, turagʉ ãhrimi,” arĩ gaguiniguiñorã. Eropirã bʉrigã gaguinigui Goãmʉre umupeo õpa arĩñorã: ");
INSERT INTO des_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Ĩre umupeorã. Ihĩ Goãmʉ ĩgʉ obeodigʉ, mari Opʉ õaro ariporo. Ʉmaro majarã õaro árĩporo. Goãmʉ ĩgʉ turagʉ árĩcʉ̃ árĩpehrerã masiporo, arĩ umupeoñorã erã. ");
INSERT INTO des_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Erã eroparĩcʉ̃ peerã fariseo masa bajamerãgã erã watope árĩrã Jesure wereñorã: —Buhegʉ, mʉ buherãre ejarimaricãdoreque, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Erãre yʉhripʉ Jesu: —Mʉare arĩgʉ tiiaa. Oã yʉre umupeorã erã wereniguibiricʉ̃ ʉtãyeripʉ yʉre umupeoro dopa ta gaguiniboca, arĩpʉ Jesu erãre fariseo masare. ");
INSERT INTO des_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Eropa arĩtuha Jesu Jerusalén pohrogue eja, iri macare ĩhabeogʉ orepʉ. ");
INSERT INTO des_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Õpa arĩpʉ ĩgʉ: —Jerusalén majarã, dohpague tamerare mʉare õaro árĩburire mʉa masicʉ̃ õatariaboya. Eropa árĩquerecʉ̃ mʉa dohpaguere irire ne peediabirabʉ. Eropigʉ Goãmʉ mʉare irire masidorebirimi. ");
INSERT INTO des_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mʉare ĩhaturirã mʉa árĩri macare cãhmotarãcoma. Eropa iirã erã mʉare wiriaro iisome. ");
INSERT INTO des_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Irisubu erã mʉa ya macare cóãpehorãcoma. Mʉare mʉa porã sãre wejẽrãcoma. Mʉare ĩhaturirã õaro weasirirãcoma mʉa ya macare. Goãmʉ peamegue wabonirãre mʉare ĩgʉ taubure yʉre mʉa masidiabirabʉ. Mʉa masidiabirira dipuwaja mʉare ĩhaturirãre Goãmʉ cóãdoregʉcumi mʉa ya macare, arĩpʉ Jesu Jerusalén majarãre. ");
INSERT INTO des_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Eropi Jerusaléngue ejagʉ, Jesu Goãmʉ wihigue ñaja wapʉ. Eropigʉ doberi duarãre iri wihigue bocajagʉ, erãre cohã wiucãpʉ. Õpa arĩpʉ ĩgʉ erãre: ");
INSERT INTO des_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Goãmʉ yare erã gojarapũ õpa ãhraa: “Goãmʉ arĩmi: Yaha wihi Goãmʉ mera wereniguiri wihi waĩcʉroca,” arĩñuma ĩgʉ yare erã gojarapũ. Ĩgʉ eropa arĩquerecʉ̃ ta mʉapʉ i wihire Goãmʉ wihire duadoarã bu game yajarã iiaa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ʉmʉri nʉcʉ Goãmʉ wihigue Jesu buhepʉ. Eropirã pahia oparã, judio masare buherã mera, masa oparã sã, ĩgʉre erã wejẽburire guñamaañorã. ");
INSERT INTO des_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Masa árĩpehrerã ĩgʉre eropa peenigui, ĩgʉ buherire õaro peenʉrʉrã árĩñorã. Erã eropa õaro peenʉrʉcʉ̃ Jesure wejẽdiarãpʉ ĩgʉre erã wejẽburire bocabiriñorã. ");
INSERT INTO des_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gajinʉ Goãmʉ wihigue Jesu masare õari buherire buhegʉ iipʉ. Ĩgʉ eropa buhecʉ̃ pahia oparã, judio masare buherã, mʉrã mera ĩgʉ pohrogue erarã, ĩgʉre serẽpiñorã: ");
INSERT INTO des_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Wereque gʉare. ¿Noa doreri mera eropa iiri mʉhʉ? ¿Nihino mʉre Goãmʉ wihigue árĩnirãre cóãdoreari? arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Erã eroparĩcʉ̃ Jesu yʉhripʉ erãre: —Yʉhʉ mʉapʉre serẽpimʉhtagʉra. Wereque yʉ sãre. ");
INSERT INTO des_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ñu masare ĩgʉ waĩyecʉ̃ nihinopʉ ĩgʉre waĩyedoremʉriyuri mʉa pepicʉ̃? ¿Goãmʉ doreyuri? ¿O masapʉ doremʉriyuri? arĩ serẽpipʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ĩgʉ eroparĩcʉ̃ erãpʉ erã basi game wereniguiñorã: —¿Dohpa arĩ yʉhrirãcuri mari? “Goãmʉ Ñure doredigʉ árĩmi,” mari arĩcʉ̃, “¿Goãmʉ Ñure ĩgʉ dorequerecʉ̃ ta duhpirã ĩgʉ wererare peebirari mʉa?” arĩbocumi Jesu marire. ");
INSERT INTO des_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Oã masapʉ “Diaye ta Ñu Goãmʉ yare weremʉhtadigʉ árĩmi,” arĩ pepima erã. Erã eropa arĩ pepirã maripʉ “Ñu ĩgʉ waĩyecʉ̃ Goãmʉpʉ ĩgʉre dorebiridigʉ árĩmi,” mari arĩcʉ̃ masapʉ marire ʉtã mera dearãcoma, arĩ wereniguiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Eropa arĩ wereniguituha erã Jesure yʉhriñorã: —Ñure waĩyedoredigʉre gʉa masibeaa, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Irisubu tamerare yʉ sã yʉre doredigʉre werebeaa mʉare, arĩpʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Eropi Jesu queori moa õpa arĩ buhenʉgapʉ masare: —Yeba opʉ árĩñumi. Ĩgʉ ya pohere iguire oteñumi. Otetuha, iri pohere gajirãre deco mera apiñumi erã mohme corera waja. Eropa apigʉ erãre iri pohere ĩhadibudoretuhaja gaji yebague waha wañumi. Yoari boje deyobiriñumi. ");
INSERT INTO des_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Eropigʉ igui ñirisubu árĩcʉ̃ pohe opʉ ĩgʉ pohro majagʉre pohere mohme corerã pohrogue obeoñumi. Pohe maja ĩgʉ oteri dʉcare ĩgʉ ya sero majare aĩdoregʉ obeoriñumi. Eropirã pohere mohme corerãpʉ ĩgʉ pohro majagʉre bocatĩri pañuma ĩgʉre. Eropirã erã ĩgʉre iguitõrire obiriquererã dujadoreñuma ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Eropigʉ pohe opʉ gajigʉ ĩgʉ pohro majagʉre iri pohe maja dʉcare aĩdoregʉ obeoriñumi daja. Eropirã pohere mohme corerã ĩgʉ sãre pa ñero iiñuma ĩgʉre. Eropa iituha ĩgʉ iri dʉcare obiriquererã dujadoreñuma daja. ");
INSERT INTO des_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ĩgʉre erã eropa iira pʉhrʉ gajigʉ pohro majagʉre obeoriñumi daja. Eropirã mohme corerã daja ĩgʉre cami moa, iri pohe tʉro cóãcãñuma ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Erã eropa iira pʉhrʉ pohe opʉ õpa arĩ pepiriñumi: “¿Dohpa iigʉcuri yʉhʉ? Õpa iigʉra. Yʉhʉ yʉ magʉre yʉ mahigʉre obeogʉra. Erã ĩgʉre umupeobocoma,” arĩ pepiriñumi pohe opʉ. ");
INSERT INTO des_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Eropirã ĩgʉ magʉre ĩgʉ obeodigʉ ejacʉ̃ ĩarã mohme corerãpʉ erã basi õpa arĩ wereniguiñuma: “Ihĩ pohe opʉ magʉ ãhrimi. Ĩgʉre wejẽrã. Eropiro i pohe mari ya pohe dujaroca,” arĩriñuma erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eropa arĩtuha pohe opʉ magʉre ñeha pohe tʉro aĩgã, wejẽcãñuma ĩgʉre. ¿Ne pohe opʉ dujaragʉ dohpa iigʉcuri ĩgʉ ya pohere mohme corerãre? arĩpʉ Jesu. —Õpa iigʉcumi erãre. ");
INSERT INTO des_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ĩgʉ pohere mohme corerãre wejẽgʉ, gajirãpʉre pohere mohme coredoregʉcumi, arĩ yʉhripʉ Jesu ĩgʉ basi. Ĩgʉ eroparĩcʉ̃ peerã masapʉ õpa arĩñorã: —Marire eropa wabiricãporo, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Erã eroparĩcʉ̃ Jesupʉ erãre ĩha serẽpipʉ: —¿Goãmʉ yare erã gojarapũre õpa arĩra dohpa arĩro iiri mʉa pepicʉ̃? Ihĩ Cristo ʉtãye iro dopa ta ãhrimi. Masa Cristore gamebirãcoma. Erã ĩgʉre gamebiriquerecʉ̃ Goãmʉ ĩgʉre beye erã opʉ erãre taubu acumi, arĩ gojañuma. ");
INSERT INTO des_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yʉre gamebirãpʉ yʉ dipuwaja moamorã árĩrã ñero tarirãcoma, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ĩgʉ eroparĩcʉ̃ peerã judio masa buherã, pahia oparã sã “Jesu iri pohe opʉ queori mera ‘Erã ñerã mohme corerã iro dopa ãhrima,’ arĩgʉ marire weresãgʉ iicumi ĩgʉ,” arĩ pepiñorã erã. Eropa arĩ pepirã erã Jesure ñeadiariñorã. Eropa ñeadiaquererã ta masa Jesure gamerã mari mera guari arĩrã erã masare güi árĩñorã. ");
INSERT INTO des_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eropa güirã Jesure erã ñeaburisubure corerã ĩgʉre ĩhanʉrʉñorã. Ĩgʉ ñero arĩ yʉhricʉ̃ ĩadiarã iiriñorã ĩgʉre weresãmorã. Eropirã Jesure gajino serẽpidorerã obeoñorã gʉyarãre. Erãre diaye iirã dopa wereniguidoreñorã. Jesu ñero ĩgʉ werenicʉ̃ peerã iri yeba majagʉ opʉre peresu iidoremorã iiriñorã. ");
INSERT INTO des_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Eropirã erã Jesure serẽpiñorã: —Buhegʉ, diaye wereniguigʉ, gʉyari marigʉ mʉ árĩcʉ̃ gʉa masia. Eropigʉ opʉ árĩcʉ̃ sãre ĩgʉ bu árĩgʉ ĩgʉ árĩcʉ̃ sãre yujuropa ĩhaa mʉhʉ. Mʉhʉ Goãmʉ yare diaye mʉ buhecʉ̃ sãre gʉa masia. ");
INSERT INTO des_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wereque gʉare: ¿Roma majagʉ árĩpehrerã tauro opʉ árĩgʉre gobierno majare marire wajayero gahmeri mʉ pepicʉ̃? ¿Mari doreripʉ irire wajayedoreri? arĩñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Erã eroparĩcʉ̃ Jesu erã ñero iidiarire masigʉ erãre werepʉ: —¿Duhpirã yʉ ñero wereniguicʉ̃ peediari mʉa? ");
INSERT INTO des_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Dohparagã niyerusere aĩrique. Irisere ĩarã, arĩpʉ. Irisere erã aĩ eracʉ̃ ĩagʉ õpa serẽpipʉ Jesu: —¿Nihino gohra waĩcʉgʉ masʉ tuhyari irisere? ¿Noa waĩ tuhyari? arĩ serẽpipʉ Jesu erãre. —César, masa tauro opʉ waĩ ĩgʉ masʉ sã tuhyami iriseguere, arĩ yʉhriñorã erã. ");
INSERT INTO des_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Erã eroparĩcʉ̃ Jesu werepʉ: —Irisubu tamerare masa tauro opʉre ĩgʉ yare oque. Goãmʉ yapʉre Goãmʉre oque, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eropirã masa erã peero Jesure ñero arĩ wereniguicʉ̃ iimasibiriñorã erã. Eropirã erã Jesu yʉhririre peerã erã peemaria wañorã. Eropa peemariarã, ejarimaria wañorã. ");
INSERT INTO des_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Eropi bajamerãgã Saduceo masa Jesu pohrogue erañorã. “Goãmʉ sĩrinirãre masusome,” arĩ pepirã árĩñorã Saduceo masa. Eropirã erã õpa arĩñorã ĩgʉre: ");
INSERT INTO des_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Buhegʉ, marire õpa arĩ gojañumi Moise: “Yujugʉ ĩgʉ tĩgʉ marapocʉgʉ porã mariqueregʉ ta ĩgʉ sĩricʉ̃ ĩagʉ ĩgʉ pagʉ magʉre ĩgʉ tĩgʉ marapo árĩdigore marapocʉro gahmea. Eropa iigʉ ĩgʉ tĩgʉ mʉrʉ ĩgʉ porãcʉbodiro dopa ta porãcʉro gahmea ĩgʉ pagʉ magʉre. Eropirã ĩgʉ tĩgʉ mʉrʉ porã iro dopa árĩrãcoma,” arĩpʉ Moise, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Irire arĩtuha i queorire werenemoñorã erã Jesure: —Yujugʉ porã siete árĩñorã. Erã tĩgʉpʉ marapocʉ porã marigʉ ta sĩria wapʉ. ");
INSERT INTO des_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Eropigʉ gajigʉ ĩgʉ pagʉ magʉ sã ĩgʉ tĩgʉ marapo árĩdigore ta marapocʉpʉ. Ĩgʉ eropa marapocʉra pʉhrʉ ĩgʉ tĩgʉ mʉrʉ iro dopa ta ĩgʉ sã porã mariqueregʉ ta sĩria wapʉ. ");
INSERT INTO des_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Eropigʉ ihĩ pagʉ magʉ sã ĩgʉ tĩgʉ mʉrʉ iro dopa ta porã mariqueregʉ sĩria wapʉ. Eropa dihta wañorã yujugʉ porã gohra. Ne porã mariquererã ta sĩripehrea wañorã. ");
INSERT INTO des_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Erã marapo sã erã pʉhrʉ sĩria wapo pare, arĩ, Jesure serẽpiñorã: ");
INSERT INTO des_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Ne, Goãmʉ árĩpehrerãre sĩrinirãre ĩgʉ masucʉ̃ nihino marapo gohra árĩgocuri igo? Erã siete árĩpehrerã igore marapocʉnirã árĩñorã. ¿Eropigo nihino marapo gohra árĩgocuri igo? arĩ serẽpiñorã erã. ");
INSERT INTO des_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —I yeba majarã ʉma nome mera marapocʉma. ");
INSERT INTO des_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Erã eropa iiquerecʉ̃ ta ʉmʉsi majarãpʉ eropa árĩbeama. Dohpaguere masare ʉmare, nome sãre diaye iirãre Goãmʉ õarã iigʉcumi. Erã erã sĩrira pʉhrʉ masa mʉriarãcoma Goãmʉ pohrogue. Eropirã erã eroguere marapocʉbeama. ");
INSERT INTO des_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eropirã erã anyua iro dopa ta ne sĩrisome daja. Erã Goãmʉ ĩgʉ masunirã árĩrã, Goãmʉ porã ãhrima. ");
INSERT INTO des_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dohpaguere sĩrinirã erã masa mʉriaboropʉre mʉare weregʉra. Irire masia mʉa ĩgʉ Moise ĩgʉ arĩ gojarare. “Iri yucʉgʉgãgue ʉ̃jʉdigʉgue árĩgʉ Goãmʉ õpa arĩ weremi yʉre,” arĩ gojañumi Moise. “‘Yʉhʉ Abrahã, Isaa, Jacobo erã opʉ ta ãhraa,’ arĩ weremi Goãmʉ yʉre,” arĩ gojañumi Moise. ");
INSERT INTO des_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Erã sĩrira pʉhrʉgue “Erã opʉ ta ãhraa,” arĩñumi Goãmʉ. Eropirã erã sĩrinirã mʉra ĩgʉ masunirã árĩrã erã ojocarirã ãhrima. Árĩpehrerã masa sĩriquererã ojocarirã ãhrima Goãmʉ ĩgʉ ĩacʉ̃, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Ĩgʉ eroparĩcʉ̃ erãpʉ dipaturi Jesure serẽpidiabiriñorã. Eropirã bajamerãgã judio masare buherã õpa arĩñorã: —Buhegʉ, mʉhʉ õaro yʉhriabʉ, arĩñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pʉhrʉ Jesu õpa arĩ werepʉ masare: —“Cristo Davi mʉrʉ pãrami árĩgʉcumi,” arĩ buherima mʉare buherã. ¿Duhpirã erã eropa arĩ buheri? ");
INSERT INTO des_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davi mʉrʉ ĩgʉ basi Salmo ĩgʉ gojarapũgue õpa arĩ gojañumi: Goãmʉ yʉ opʉre õpa arãmi: “Ohõ yʉ diayepʉ dorebu doaque. ");
INSERT INTO des_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Eropigʉ mʉre ĩhaturirãre mʉre tarinʉgabasagʉra yʉhʉ,” arĩmi Goãmʉ yʉ opʉre, arĩ gojañumi Davi mʉrʉ. ");
INSERT INTO des_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Eropa arĩ gojagʉ Davi mʉrʉ opʉcʉñumi Cristore. ¿Eropigʉ Davi mʉrʉ Cristo ñecʉ mʉrʉ árĩqueregʉ ta duhpigʉ Davipʉ Cristore opʉcʉyuri? Cristo Davi mʉrʉ opʉ ãhrimi, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Masa bajarã watope Jesupʉ ĩgʉ buherãre õpa arĩ werepʉ: ");
INSERT INTO des_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Masare buherã erã ñeri iirire ĩarã õaro pee masique. Eropirã erã iro dopa iibiriricãque. Erã yoari suhri sañama masa erãre ĩaboro dopa. Doberi duarogue gajirã umupeori mera bocatĩri serẽcʉ̃ gahmema erã. Eropirã erã mari buheri wiriguere oparã õari doari dihtare doadiama erã. Eropirã bosenʉri árĩcʉ̃ sãre oparã erã doarigue dihtare doadiama. ");
INSERT INTO des_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Erã wapeweyarã nome erã wajamocʉ̃ ĩha erã ya wirire ehmama erã nomere. Eropa erãre mojomoro ĩabiriquererã erã masa erã ĩhurore yoari boje Goãmʉre serẽma, “Gʉa Goãmʉre õaro umupeoa,” arĩ gʉyarã. Erã eropa iira dipuwaja Goãmʉ erãre gajirã tauro dipuwaja moagʉcumi, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Eropa arĩ weretuha Jesu Goãmʉ wihi maja erã amuburi niyeru gameneori comoro pohrogue ĩha doapʉ. Iri comorogue doberi oparã erã niyeru sãcʉ̃ ĩapʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Eropa ĩagʉ wapeweyo mojomorocʉgo igo pesegã igo oparaserigãre igo sãcʉ̃ sãre ĩapʉ. ");
INSERT INTO des_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Irire ĩatuha õpa arĩ werepʉ: —Diaye arĩgʉ iiaa mʉare. Igo wapeweyo mojomorocʉgopʉ ii comorogue igo yare sãgo gajirã árĩpehrerã erã sãdiro tauro sãmo igoa. ");
INSERT INTO des_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gajirã doberi oparã erã wʉaro oquerecʉ̃ ta erãpʉre erã ya wʉaro dʉhyaa. Igopʉ mojomorocʉgo árĩquerego ta árĩpehreri igo bari waja árĩborare opehocãmo igoa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eropi gajirã Goãmʉ wihire ĩarã õpa arĩñorã: —Õari ʉtã mera iira wihi, õari wihi ãhraa. Masa Goãmʉ wihire erã ora sã õari ãhraa, arĩ wereniguirã iiñorã. Erã eroparĩcʉ̃ Jesu werepʉ erãre: ");
INSERT INTO des_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—I wihi majare dohpaguere ĩaraa mʉa. Gajinʉ árĩcʉ̃ i wihi maja árĩpehreri mari ĩara, i ʉtã sã cohmopehrea waroca. Ne yujuye ʉtãye dujasome, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ĩgʉ eroparĩcʉ̃ peerã erãpʉ serẽpiñorã ĩgʉre: —Buhegʉ, ¿dohpárĩcʉ̃ eropa warocuri mʉ arĩdiro dopa waro? ¿Pehreburinʉ coregãre dohpa wanʉgacʉ̃ ĩarãcuri gʉa? arĩ serẽpiñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu yʉhripʉ erãre: —Õaro iiyuque mʉa. Eropirã gajirã mʉare erã gʉyarire peebiricãque. Bajarã masa “Cristo ãhraa yʉhʉ,” arĩ gʉyarã árĩrãcoma. Eropa arĩ gʉyarã “Dohpaguere pehreburinʉ merogã dʉhyaa,” arĩrãcoma. Erã eroparĩcʉ̃ erãre peebiricãque. ");
INSERT INTO des_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Eropirã mʉa pohrogã gajirã masa game­wejẽcʉ̃, masa erã oparãre cóãcʉ̃ peerãca. Eropirã yoarogue majarã sã eropa iicʉ̃ peebeorãca. Mʉa irire peerã güibiricãque. Pehreburinʉ core õpa wamʉhtaroca. Eropa wamʉhtacʉ̃ pehreburinʉ dʉhyaniroca dohpa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Eropa arĩtuha õpa arĩ werenemopʉ: —Irisubure yuju yeba majarã gaji yeba majarã mera gamewejẽrãcoma. Eropirã yujugʉ opʉ yarã gajigʉ opʉ yarã mera gamewejẽrãcoma. ");
INSERT INTO des_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Eropiro bajasuburi i yeba ñohmeroca. Eropirã masa bajarã oa mera sĩri, árĩpehrero majarã masa dorecʉrãcoma. Eropirã ʉmaro majare deyoro moarire gʉhyadiarire masa ĩarã, ĩha ʉca warãcoma. Eropa wacʉ̃ mʉapʉ güibiricãque. ");
INSERT INTO des_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“I árĩpehreri eropa waboro core, yaharã mʉa árĩri dipuwaja gajirã mʉare ñeha ñero iirãcoma. Eropirã mari judio masa buheri wirigue mʉare weresã, peresu iirãcoma mʉare. Erã eropa iicʉ̃ macari majarã oparã pohrogue erã tauro oparã pohrogue sãre mʉare aĩgãrãcoma erã mʉare dipuwaja moadorerã. ");
INSERT INTO des_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Erã eropa mʉare aĩgãcʉ̃ mʉapʉ erãre õari buherire wererãca. ");
INSERT INTO des_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Erã oparã pohrogue mʉare erã aĩgãcʉ̃ erã oparãre mʉa yʉhriborore wʉaro guñabiricãque mʉa. ");
INSERT INTO des_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yʉhʉ mʉare wereniguicʉ̃ iigʉra. Mʉare eropa itamugʉ pee masirire, õari wereniguiri sãre mʉa iicʉ̃ iigʉra. Mʉa eropa iicʉ̃ mʉare ĩhaturirãpʉ mʉa wereniguirire pee bocatĩumasisome. “Iri diaye árĩbeaa,” arĩ yʉhrimasisome. ");
INSERT INTO des_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Irisuburi mʉa yaharã árĩcʉ̃ ĩha mʉa pagʉ sʉmarã, mʉa pagʉ porã, mʉa acawererã, mʉa mera majarã sã mʉare oparãre wejẽdorerã orãcoma mʉare. Erã eropa iicʉ̃ mʉare ĩhaturirã mʉa mera majarãre gajirãre wejẽrãcoma. ");
INSERT INTO des_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Eropirã yaharã mʉa árĩcʉ̃ ĩarã, árĩpehrerã mʉare ĩhaturirãcoma. ");
INSERT INTO des_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mʉare eropa iicʉ̃ mʉapʉ ne dederesome. ");
INSERT INTO des_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Eropirã erã mʉare ñero iiquerecʉ̃ ta mʉare erã ñero iirare yujuro bojerã yʉre duhubiricʉ̃ Goãmʉ mʉare taugʉcumi. Eropigʉ ĩgʉ pohrogue mʉare opagʉcumi. ");
INSERT INTO des_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Eropirã bajarã surara Jerusalénguere erã cãhmotacʉ̃ ĩarã, Jerusalénre erã cóãborore merogã dʉhyacʉ̃ masirãca mʉa. ");
INSERT INTO des_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Eropa wacʉ̃ ĩarã Judea yeba árĩrãpʉ ʉtã yucʉgue oma duhriporo. Eropirã Jerusalén árĩrã sã waporo. Eropirã campo árĩrã Jerusalénguere wabiricãporo daja. ");
INSERT INTO des_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Irinʉri dipuwaja moarinʉri árĩpehreri Goãmʉ yare erã gojarapũ erã arĩdiro dopa ta eropa waroca. ");
INSERT INTO des_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Goãmʉ oã masare turaro dipuwaja moacʉ̃ árĩpehrerogue i yebaguere ñero tarirãcoma. Eropa wacʉ̃ nijiposã nome, erã porãre mihrirãre oparã nome sã mojomorocʉrã nome dujarãcoma irisubure. ");
INSERT INTO des_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Gajirã i maca majarãre gamewejẽrãcoma. Eropirã gajirã i maca majarãre árĩpehreri yebarigue aĩgã peresu iirãcoma. Eropirã judio masa árĩbirã Jerusalénre ñero iirãcoma. Eropirã erã tarinʉgarãcoma. Judio masa árĩbirãre “Iripẽta árĩque,” Goãmʉ ĩgʉ arĩcʉ̃gue Jerusalénre ãhri duhurãcoma, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Eropigʉ erãre werenemopʉ: —Irisubure abe ʉmʉ majagʉ, ñami majagʉ, necã sã gʉhyaro gohrotoa warãcoma. Árĩpehrerã i yeba majarã, “Cue, sĩrirãca,” arĩ pepirãcoma. Wʉariya turaro bʉsʉrire pãgúri sãre turaro güirãcoma. ");
INSERT INTO des_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Irisubure ʉmaro maja sã yeba sã bʉrigã ñohmeroca. Eropa wacʉ̃ ĩarã masapʉ i yeba pehreborore corerã bʉrigã güirãcoma dedereri arĩrã. ");
INSERT INTO des_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Irisubu ta yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ Goãmʉ ĩgʉ turari mera, ĩgʉ gosesiriri mera ʉmaro maja imica weca i yebaguere yʉ dujaricʉ̃ ĩarãcoma masa. ");
INSERT INTO des_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yʉ eropa arĩra wanʉgacʉ̃ ĩarã güibiricãque. Eropirã guñatura ʉmarogue ĩhamujuque. Irisubure Goãmʉ mʉare ĩgʉ tauboro merogã dʉhyaroca, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Eropa arĩtuha i queori mera erãre werepʉ Jesu: —Higueragʉ baja gaji yucʉ sã iri yucʉ waricʉrire pepique mʉa. ");
INSERT INTO des_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Iri yucʉ pũricʉcʉ̃ ĩarã, “Bojori merogã dʉhyaa,” arĩ masia mari. ");
INSERT INTO des_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eropa ta i árĩpehreri yʉ arĩra iri eropa wacʉ̃ ĩarã, “Goãmʉ ĩgʉ opʉ árĩburisubu merogã dʉhyaa,” arĩ pepirãca mʉa. ");
INSERT INTO des_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mʉare diaye arĩgʉ iiaa. Irisubu majarã erã sĩriboro core árĩpehreri yʉ arĩra eropa waroca. ");
INSERT INTO des_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ʉmaro i yeba sã pehrea waroca. Yʉ wereniguiripʉ ne pehresome. Árĩpehreri yʉ arĩdiro dopa ta eropa waha ojogorocʉroca. ");
INSERT INTO des_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Yʉ dujariburinʉre ne masibeaa mʉa. Eropirã õaro árĩyuque. Bosenʉrire pagari iiniguibiricãque. Eropirã merebiricãque. I yeba maja iiburire wʉaro pepibiricãque. Mʉare yʉ arĩdiro dopa ta iirã, guñaña mariro i yebaguere yʉ aricʉ̃ ne ʉcasome. ");
INSERT INTO des_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yʉhʉ masare beyegʉ arigʉ guñaña mariro arigʉca. Waibʉgʉ guñaña mariro ĩgʉ weradague ĩgʉ mehsihajaro dopa ta irinʉ waroca masare árĩpehrerã i yeba majarãre. I yeba majarã “Eropa waroca,” erã arĩbiririnʉ eropa waroca. ");
INSERT INTO des_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mʉapʉ õaro guñatura coreque. Eropirã Goãmʉre ire serẽniguicãque: “Pehrerinʉ eropa wacʉ̃ yʉre itamuque. Turarire oque yʉre õaro yʉ tariboro dopa. Eropigʉ Cristore mʉ obeogʉre güiro mariro yʉhʉ ĩgʉre bocatĩricʉ̃ iique yʉre,” arĩ serẽque Goãmʉre, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Eropi irinʉrire Goãmʉ wihigue Jesu buhemʉripʉ. Ñamiri nʉcʉ buhetuhajagʉ Olivo waĩcʉdigʉgue waha irigʉgue árĩboyotahmuamʉripʉ. ");
INSERT INTO des_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Boyocʉ̃ árĩpehrerã masa ĩgʉre Goãmʉ wihigue peerã wamʉriñorã. ");
INSERT INTO des_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Eropi irisubure bʉgabiriri pan erã baburi bosenʉ merogã dʉhyayoro. Iri bosenʉ Pascua waĩcʉyoro. ");
INSERT INTO des_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Eropirã pahia oparã, judio masare buherã mera Jesure wejẽdiarã, erã wejẽborore guñamaañorã. Jesure wejẽdia­quererã ta masapʉre güiñorã guari arĩrã. ");
INSERT INTO des_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Eropi Judapʉ watĩ ĩgʉre ñero iidorecʉ̃ yʉhripʉ ĩgʉre. Juda doce Jesu buherã mera majagʉ árĩripʉ. ");
INSERT INTO des_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eropigʉ pahia oparãre, Goãmʉ wihi majarã surara oparã mera sãre weretamugʉ wapʉ. Erã pohrogue eja, erãre Jesure ĩgʉ ĩhmuborore weretamupʉ erã mera. ");
INSERT INTO des_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ĩgʉ erãre eroparĩcʉ̃ pee erã mucubiri, “Mʉre niyeru wajayerãca,” arĩñorã erã Judare. ");
INSERT INTO des_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Erã eroparĩcʉ̃, “Áʉ, mʉare ĩgʉre ĩhmugʉra,” Juda arĩpʉ. Eropigʉ masa erã ĩabiririsubu Jesure ĩhaturirãre ĩgʉ ĩhmuborore corenipʉ. ");
INSERT INTO des_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bʉgabiriri panre erã baburinʉ bosenʉ árĩnʉgarinʉ árĩyoro. Eropiro Pascua majagʉ árĩbure ovejare erã wejẽrinʉ árĩyoro. ");
INSERT INTO des_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Irisubu ta Pedro, Ñu sãre Jesu werepʉ: —Bosenʉ mari baburire amurã waque, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Nohonogue mari baburire amudoregʉ obeori mʉhʉ gʉare? arĩ serẽpiñorã erã. ");
INSERT INTO des_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Jerusaléngue waque. Erogue mʉa ejacʉ̃ deco sorobu tuhpeogʉ mʉare bocatĩrigʉcumi. Ĩgʉ bocatĩricʉ̃ ĩgʉ mera waque. ");
INSERT INTO des_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Eropa warã ĩgʉ sihu ñajari wihigue ejarã, wihi opʉre õpa arĩque: “‘¿Nohogue yʉhʉ, yʉ buherã mera Pascua maja barire barãcuri?’ arãmi buhegʉ,” arĩque wihi opʉre. ");
INSERT INTO des_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mʉa eroparĩcʉ̃ peegʉ wʉari taribure, ʉmaro maja taribure, mari gameri mera erã amura taribure ĩhmugʉcumi wihi opʉ. Erogue mari baburire iique mʉa, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ĩgʉ eroparĩcʉ̃ erã iri macague wañorã. Erogue erã ejacʉ̃ erãre ĩgʉ arĩdiro dopa ta eropa wayoro. Eropirã erã Pascua árĩcʉ̃ baburire amuñorã. ");
INSERT INTO des_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Erã barisubu árĩcʉ̃ Jesu doce ĩgʉ buherã mera ba doapʉ. ");
INSERT INTO des_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Erogue erã barogue doagʉ Jesu erãre werepʉ: —Mʉare arĩgʉ iiaa. I Pascua bosenʉre mari iiaa Goãmʉ ĩgʉ yarãre ĩgʉ taurare guñarã. Pʉhrʉ Goãmʉ ĩgʉ opʉ árĩrogue ĩgʉ yarãre tautuhagʉcumi. Ĩgʉ eropa tauboro core inʉno majare dipaturi basome yʉhʉ. Eropigʉ dohpaguere yʉ ñero tariboro core i Pascua maja barire mʉa mera turaro badiabʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Eropa arĩgʉ Jesu ihriripare aĩ, Goãmʉre “Õhaa,” arĩ serẽ, erãre werepʉ: —Mʉare arĩgʉ tiiaa. Goãmʉ ĩgʉ opʉ árĩrogue igui decore ihriboro core ne dipaturi ihrisome yʉhʉ. Eropirã iri vinore aĩ mʉa basi ihrique, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Eropa arĩtuha panre aĩ, Goãmʉre “Õhaa,” arĩpʉ. Eropa arĩtuha irirure nuha guerepʉ erãre. Irirure gueregʉ ta erãre werepʉ: —I yʉ dʉpʉ ãhraa. Yʉ dʉpʉ yʉre ĩhaturirãre erã oburi dʉpʉ árĩroca. Mʉa ñeri iira wajare cóãbu sĩrigʉca yʉhʉ. Eropirã mʉa yʉre guñaburire ire baque, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Eropa batuha eropa ta erãre ihriripa sãre ópʉ. Eropigʉ erãre werepʉ: —Mʉa ñeri iirare cóãbu sĩrigʉca. Eropigʉ yʉ dire cóãgʉca. Eropa sĩrigʉ yʉ Pagʉ Goãmʉ “Masare õaro iigʉra,” ĩgʉ arĩdiro ii ojogorocʉgʉca. ");
INSERT INTO des_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Dohpaguere peeque mʉa. Yʉre ĩhaturirãre ĩhmubu yʉ mera ohõ doami. ");
INSERT INTO des_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Goãmʉ ĩgʉ arĩdiro dopa ta yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ sĩrigʉca. Ĩgʉ eropa sĩridorequerecʉ̃ ta yʉre ĩhaturirãre ĩhmudigʉpʉ ñetariaro tarigʉcumi, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ĩgʉ eroparĩcʉ̃ erãpʉ erã basi õpa arĩ serẽpiñorã: —¿Jesure ĩhaturirãre ĩhmubu mari mera majagʉ nihino árĩcuriba? arĩ serẽpiñorã erã basi. ");
INSERT INTO des_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pʉhrʉ Jesu buherã õpa arĩ dʉyasoñorã: —¿Mari mera majagʉ nihipʉ árĩgʉcuri opʉ? arĩ wereniguiñorã erã basi. ");
INSERT INTO des_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Erã eropa arĩ wereniguicʉ̃ peegʉ Jesu erãre werepʉ: —Goãmʉre masibirã oparãpʉ erã masare dorerã pũriro mera dorema. Eropirã oparãre “Erã masare õaro itamurã ãhrima,” arĩrima gajirã erãre. ");
INSERT INTO des_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉapʉ eropa oparã árĩdiasome mʉa basi. Mʉa mera majagʉ mʉa tĩgʉpʉ mʉa pagʉ magʉ iro dopa árĩporo. Mʉa mera majagʉ opʉ árĩdiagʉ gajirã itamugʉ árĩporo. ");
INSERT INTO des_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Nihino ãhriri opʉ mʉa pepicʉ̃? ¿Ba doagʉpʉ opʉ ãhriri? ¿O barire duhpeogʉpʉ opʉ ãhriri? Ba doagʉ ta árĩcumi opʉ. Ĩgʉ eropa árĩquerecʉ̃ ta yʉpʉ pohro majagʉ iro dopa ta mʉare itamugʉ ahrabʉ. ");
INSERT INTO des_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Masa erã yʉre ñero iiquerecʉ̃ ta mʉapʉ yʉre duhubirabʉ. ");
INSERT INTO des_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Eropigʉ yʉ Pagʉ ĩgʉ yʉre opʉ acudiro dopa ta mʉa sãre oparãre acugʉra yʉhʉ. ");
INSERT INTO des_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yʉ opʉ árĩcʉ̃ mʉa sã yʉ bari mesa ta baha ihrirãca. Eropirã mʉa oparã doarire doarãca. Mʉa ero doarã Israe masare doce cururi majarãre beyerãca õarã sãre ñerã sãre, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Eropa arĩtuhaja Pedrore Jesu õpa arĩ werepʉ: —Simo Pedro yʉre peeque. Watĩ Satana mʉare árĩpehrerãre gamegʉ Goãmʉre serẽrami. Mʉa yʉre duhu ĩgʉ yare iicʉ̃ gamegʉ serẽrami. Trigo pohe opʉ ĩgʉ trigo gasirire cóãgʉ puri siriro dopa mʉare goroweodiami. ");
INSERT INTO des_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ĩgʉ mʉare eropa gamequerecʉ̃ yʉpʉ mʉre Goãmʉre serẽbasabʉ. Yʉre mʉ umupeo duhubiriburire serẽbasabʉ Goãmʉre. Eropigʉ mʉhʉ yʉ mera majagʉ dipaturi árĩgʉ mʉ acawererãre yaharãre guñaturacʉ̃ iique mʉhʉ, arĩpʉ Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ĩgʉ eroparĩcʉ̃ Pedro yʉhripʉ: —Opʉ, mʉre erã peresu iiquerecʉ̃ ta, yʉhʉ mʉ mera majagʉ árĩniguigʉca. Mʉre erã wejẽquerecʉ̃ ta mʉ mera majagʉ árĩniguigʉca, arĩpʉ Pedro. ");
INSERT INTO des_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu yʉhripʉ: —Pedro, mʉre arĩgʉ iiaa. Dohpagã ñami cãreña ĩgʉ wereboro core ʉhresubu “Jesure masibeaa,” arĩgʉca mʉhʉ gajirãre, arĩpʉ Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Eropa arĩtuha Jesu ĩgʉ buherãre werepʉ: —¿Sohõ árĩrasubure mʉa niyeru aju moorã, suhri diyeri aju moorã, zapatu moorã mʉare yʉ obeorasubure gajino dʉhyari mʉare? arĩ serẽpipʉ Jesu. —Ne gajino gʉare dʉhyabirabʉ, arĩ yʉhriñorã erã. ");
INSERT INTO des_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Irisubure mʉare dʉhyabiriquerecʉ̃ ta dohpaguepʉre suhri diyeri ajure, niyeru aju sãre oparã irire aĩque. Eropirã mʉare matamijiri maricʉ̃ ĩarã mʉa suhrire duarã irimijire asũque. ");
INSERT INTO des_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ire mʉare arĩgʉ iiaa. Goãmʉ yare erã gojarapũ erã arĩdiro dopa ta yʉre eropa waro gahmea. Õpa arĩñuma iripũgue. “‘Ĩgʉ dorerire tarinʉgarã mera majagʉ ãhrimi,’ arĩrãcoma masa,” arĩ gojañuma yʉre, arĩpʉ Jesu. Erãpʉ arĩñorã: ");
INSERT INTO des_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Ĩaque opʉ. Pemiji matamijirire opaa gʉa, arĩñorã ĩgʉ buherã. —Iripẽta árĩca, arĩ yʉhripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Eropi Jesu ĩgʉ ero core ĩgʉ iiguadiro dopa ta Olivo waĩcʉdigʉ ʉtãgʉgue waha wapʉ. Ĩgʉ eropa wacʉ̃ ĩgʉ buherã ĩgʉ mera wañorã. ");
INSERT INTO des_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Erogue ejagʉ ĩgʉ erãre werepʉ: —Goãmʉre serẽque mʉa ñerire iibiriboro dopa, arĩpʉ erãre Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Eropa arĩtuha ĩgʉ seyaro merogã yujugʉ ta wanemo, mereja Goãmʉ mera wereniguipʉ: ");
INSERT INTO des_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Ahʉ, yʉ ñero tariburire iidiabigʉ iibiricãque. Yʉ eropa serẽquerecʉ̃ ta yʉ gamero dopa iibita. Mʉpʉ masia. Mʉ gamero dopa ta iique, arĩ serẽpʉ Jesu Goãmʉre. ");
INSERT INTO des_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ĩgʉ eropa arĩ serẽcʉ̃ ʉmarogue aridigʉ anyu Jesure dehyoapʉ ĩgʉre itamugʉ. ");
INSERT INTO des_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Eropigʉ Jesu ñero sĩporãcʉ turaro mera Goãmʉ mera wereniguipʉ. Eropiro ĩgʉ ñajasiri guari di wiriro dopa ĩgʉre wiridijayoro. ");
INSERT INTO des_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Goãmʉ mera wereniguituha wahgãnʉgaja, ĩgʉ buherã pohrogue dujaa wapʉ. Ĩgʉ dujajacʉ̃ ĩgʉ buherã bʉrigã bʉjawererã árĩrã carĩrã árĩñorã. ");
INSERT INTO des_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Eropigʉ Jesu erãre õpa arĩ werepʉ: —¿Duhpirã carĩri mʉa? Wahgãque. Goãmʉre serẽque mʉa ñeri iibiriburire, arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ĩgʉ eropa arĩ wereniguirisubu masa bajarã erañorã. Juda doce buherã mera majagʉ árĩdigʉ masare mʉhtagãridigʉ árĩpʉ. Eropigʉ ĩgʉ Jesu pohro eraa, ĩgʉ wayuporãre mimipʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ĩgʉ eropa mimicʉ̃ Jesupʉ ĩgʉre serẽpipʉ: —Juda, ¿yʉ masʉre Goãmʉ ĩgʉ obeodigʉre yʉre ĩhaturirãre ĩhmugʉ yʉ wayuporãre mimiri mʉhʉ? arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ĩgʉ eropa arĩra pʉhrʉ Jesu buherã masa Jesure erã ñeaburire masirã ĩgʉre serẽpiñorã: —Opʉ, ¿gʉa matamijiri mera erãre gamequeãsi? arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Erã eropa arĩra pʉhrʉ yujugʉ Jesu buherã mera majagʉpʉ pahia opʉ pohro majagʉre ĩgʉ matamiji mera ĩgʉ gamirore diayepʉ árĩri gamirore tabe coro dijucãpʉ. ");
INSERT INTO des_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ĩgʉ eropa iicʉ̃ ĩagʉ Jesu õpa arĩpʉ: —Iibita, arĩpʉ. Eropa arĩtuha pohro majagʉ gamiro árĩrañere mohmepipʉ. Ĩgʉ eropa iicʉ̃ pohro majagʉpʉ mʉraro ta dujapʉ daja. ");
INSERT INTO des_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Eropa iituha pahia oparãre, Goãmʉ wihi surara oparãre, mʉrã sãre ĩgʉre ñeamorãre Jesu serẽpipʉ: —¿Mʉa matamijiri mera, yucʉ dʉcari mera arirã yajari masʉre iro dopa ta yʉre ñearã arirã iiari? ");
INSERT INTO des_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ʉmʉri nʉcʉ Goãmʉ wihigue mʉa mera yʉ árĩcʉ̃, mʉa yʉre ñeabiribʉ. Eropa arĩquerecʉ̃ ta dohpague mʉa ñerã yanʉ ta ãhraa. Watĩ ĩgʉ tarinʉgaburisubu árĩro iiaa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Erã Jesure ñeatuha pahia opʉ ya wihigue aĩgãñorã erã ĩgʉre. Erã aĩgãcʉ̃ Pedro yoarogue erãre ĩhanʉrʉsiapʉ. ");
INSERT INTO des_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Opʉ ya wihigue ejacʉ̃, iri wihire cãhmotara sãriro pohecague õari goro deco peame dihuñorã gajirã. Erã dihucʉ̃ ĩagʉ Pedro peame pohro doarã mera doapʉ. ");
INSERT INTO des_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ĩgʉ peame boyorogue doacʉ̃ yujugo pohro majago ĩgʉre õaro ĩhanʉrʉ gajirãre õpa arĩ werepo: —Ihĩ sã ĩgʉ mera ta ãhrami, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Igo eroparĩcʉ̃ Pedro yʉhripʉ: —Nomeo, ĩgʉre ne masibeaa yʉhʉ, arĩripʉ Pedro. ");
INSERT INTO des_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pʉhrʉ ñari gajigʉ Pedrore ĩha, õpa arĩ werepʉ: —Mʉ sã erã mera majagʉ ta ãhraa, arĩpʉ ĩgʉ. —Ne, árĩbeaa, arĩripʉ Pedro. ");
INSERT INTO des_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yuju hora pʉhrʉ gajigʉ gajirãre õpa arĩ werepʉ: —Diaye ta ãhraa. Ihĩ Galilea majagʉ ãhrimi. Diaye ta Jesu mera ãhrami ihĩ sã, arĩpʉ ĩgʉ gajirãre. ");
INSERT INTO des_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ĩgʉ eroparĩcʉ̃ Pedro yʉhripʉ: —Mʉ arĩgʉre ne masibeaa yʉhʉ, arĩ yʉhripʉ. Ĩgʉ eropa arĩ wereniguirisubu cãreña werepʉ. ");
INSERT INTO des_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ĩgʉ werecʉ̃ mari Opʉ Jesu wihi pohro árĩdigʉ Pedrore maji ĩapʉ. Ĩgʉ eropa ĩacʉ̃ Pedropʉ Jesu ĩgʉ arĩrare guñapʉ. “Dohpagã ñami cãreña ĩgʉ wereboro core, ʉhresubu mʉhʉ, ‘Yʉhʉ Jesure masibeaa,’ arĩgʉca mʉhʉ,” Jesu ĩgʉ arĩrare guñapʉ Pedro. ");
INSERT INTO des_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Eropigʉ Pedro erogue wiriri, turaro orepʉ. ");
INSERT INTO des_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Eropirã Jesure corerã surara ĩgʉre wereya, pañorã. ");
INSERT INTO des_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Eropa parã ĩgʉ cuirire diricãhmota, ĩgʉre serẽpiñorã: —¿Noa mʉre pari? Ĩabiriqueregʉ ta wereque gʉare, arĩ wereyañorã erã. ");
INSERT INTO des_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Eropirã baja gaji ñero arĩ wereyañorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Eropirã boyorogue ta mʉrã, pahia oparã, judio masare buherã sã gamenereñorã. Erã eropa gamenererore gajirã erã pohrogue Jesure aĩgãriñorã. ");
INSERT INTO des_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Wereque gʉare. ¿Goãmʉ beyedigʉ Cristo ãhriri mʉhʉ? arĩ serẽpiñorã erã Jesure. Erã eroparĩcʉ̃ Jesu yʉhripʉ: —Mʉare yʉ werecʉ̃ sãre yʉre peesome mʉa. ");
INSERT INTO des_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mʉare yʉ serẽpicʉ̃ yʉre yʉhrisome mʉa. Eropirã yʉre wiusome mʉa. ");
INSERT INTO des_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mʉa yʉre wiubiriquerecʉ̃ ta pʉhrʉ ñari ʉmʉri nʉcʉ yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ Goãmʉ yʉ Pagʉ turagʉ ĩgʉ diayepʉ doagʉ árĩgʉca, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ĩgʉ eroparĩcʉ̃ erã árĩpehrerã serẽpiñorã daja dipaturi: —¿Eropa arĩgʉ “Yʉhʉ Goãmʉ magʉ ãhraa,” arĩri mʉhʉ? arĩñorã erã. —Mʉa arĩro dopa ĩgʉ ta ãhraa, arĩ yʉhripʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ĩgʉ eroparĩcʉ̃ õpa arĩ erã basi wereniguiñorã erã: —Ĩre weresãrãre gajirãre mari gamebeaa pare. Erã nʉcʉ ta sihajama. Ĩgʉ Goãmʉre ĩgʉ ñero wereniguicʉ̃ mari basi ta mari peea. Eropirã ĩgʉ ñero iira dipuwajare masituhaa, arĩñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Eropa arĩtuha erã árĩpehrerã wahgãnʉgaja, Jesure Pilato waĩcʉgʉ opʉ pohrogue aĩgãñorã. ");
INSERT INTO des_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aĩ ejarã Jesure weresãnʉgañorã: —Ihĩ mari ya yeba majarãre ñero iidorecʉ̃ peeabʉ. Mari opʉre Césare ihĩ wajayedorebeami. Eropigʉ ĩgʉ “Yʉhʉ opʉ ãhraa. Cristo ãhraa yʉhʉ,” arĩ wereniguimi ĩgʉ basi, arĩ weresãñorã erã Jesure. ");
INSERT INTO des_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Erã eropa arĩ weresãra pʉhrʉ Pilato Jesure serẽpipʉ: —¿Diaye ta judio masa opʉ ta ãhriri mʉhʉ? arĩpʉ ĩgʉ Jesure. —Mʉ arĩro dopa ta ĩgʉ ta ãhraa, arĩ yʉhripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ĩgʉ eroparĩcʉ̃ Pilato pahia oparãre, masa sãre werepʉ: —Ĩre gajino waja dipuwaja mara, arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ĩgʉ eropa arĩquerecʉ̃ ta erã turaro weresãnemoñorã: —Ĩgʉ, ĩgʉ buheri mera masare gamequeãcʉ̃ iimi. Galilea yeba ĩgʉ irire iinʉgami. Eropa iinʉgatuha árĩpehrero Judea yebague irire ĩgʉ iimi, arĩ weresãñorã erã. ");
INSERT INTO des_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Erã eropa arĩ weresãcʉ̃ peegʉ Pilatopʉ serẽpipʉ: —¿Ihĩ Galilea majagʉ ãhriri? arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Ero majagʉ ta ãhrimi, arĩ yʉhriñorã gajirã. Erã eropa yʉhricʉ̃ peegʉ Pilatopʉ Jesu ĩgʉ árĩri yebare masigʉ opʉ Herode ĩgʉ ya yeba majagʉ ĩgʉ árĩcʉ̃ masipʉ. Irire masigʉ Jesure Herode pohro obeopʉ. Irisubure Herode Jerusalén árĩpʉ. ");
INSERT INTO des_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ero core Herode Jesure peemʉripʉ. Ĩgʉ eropa peera pʉhrʉ ĩgʉre bʉrigã ĩadiaripʉ. Jesu ĩgʉ deyoro moarire ĩgʉ ii ĩhmucʉ̃ ĩadiaripʉ ĩgʉ. Eropigʉ ĩgʉ Jesure ĩagʉ mucubiripʉ. ");
INSERT INTO des_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Eropigʉ baja serẽpipʉ Jesure. Ĩgʉ eropa serẽpiquerecʉ̃ ta Jesupʉ ne yʉhribiripʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pahia oparã, judio masare buherã sã Herode pohro nʉgaja turaro Jesure weresãñorã. ");
INSERT INTO des_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erã eropa arĩ weresãra pʉhrʉ Herode ĩgʉ surara mera wereya, Jesure ñero iiñorã. Eropa wereyarã, õariñe suhrirore opʉ yañe dopa bejariñere sãñorã erã Jesure. Eropa wereyatuha, iri suhrirore tuwea aĩ Pilato pohro obeoñorã daja. ");
INSERT INTO des_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Irinʉre Herode, Pilato mera õaro erã basi game iinʉgarã árĩnʉgañorã. Ero corere erã basi game ĩhaturirã árĩriñorã. ");
INSERT INTO des_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Eropi Pilato pahia oparãre, gajirã oparãre, masa sãre ĩgʉ sihubeocʉ̃ gamenereñorã. ");
INSERT INTO des_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Erã gamenerecʉ̃ ĩagʉ õpa arĩpʉ erãre: —Ĩre yʉre aĩgãrirã, “Ĩgʉ masare ñero iidoremi,” arĩraa mʉa yʉre. Dohpague mʉa ĩhuro ĩre serẽpipehoabʉ daja. Yʉ eropa serẽpira pʉhrʉ mʉa ĩgʉre weresãcʉ̃ ñeri dipuwaja mara yʉ ĩacʉ̃. ");
INSERT INTO des_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode sã “Ĩgʉre ne ñeri dipuwaja mara,” arãmi. Eropa arĩgʉ dipaturi ĩre ohõ dujuami daja. Eropiro ĩre wejẽdorero mara. Mʉa sã irire ĩha masia. ");
INSERT INTO des_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Eropigʉ ĩgʉre tãraradari mera tãradoregʉca yʉhʉ. Erã eropa tãrara pʉhrʉ ĩgʉre wiugʉra, arĩripʉ Pilato. ");
INSERT INTO des_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bojori nʉcʉ Pascua bosenʉri nʉcʉ peresu árĩdigʉre yujugʉre masa gamegʉre Pilato eropa wiubasamʉripʉ. Eropa iiro gameyoro ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Eropirã Pilato “Jesure wiugʉra,” ĩgʉ arĩcʉ̃ peerã árĩpehrerã masa õpa arĩ gaguiniguiñorã: —Ĩgʉ Jesure wejẽque. Gʉa yagʉ árĩbure Barrabápʉre gʉare wiubasaque, arĩ gaguiniguiñorã masa. ");
INSERT INTO des_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ero Barrabápʉ Jerusaléngue oparãre ĩgʉ cóãdorera dipuwaja, ĩgʉ gajirãre wejẽra dipuwaja peresu iiñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato Jesupʉre wiudiaripʉ. Eropigʉ ĩgʉ masare ĩgʉ wiabure serẽpi ĩapʉ daja. ");
INSERT INTO des_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ĩgʉ Jesure eropa wiudiaquerecʉ̃ ta erã ĩgʉre arĩñorã daja: —Crusague pabia wejẽque ĩgʉre. Wejẽcãque ĩgʉre, arĩ gaguiniñorã erã. ");
INSERT INTO des_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Erã eroparĩcʉ̃ Pilato ʉhresubu waro gohra õpa arĩripʉ daja erãre: —¿Ñehenore ñerire iiari ĩgʉ mʉa eropa arĩ gaguiniguicʉ̃? Ne ĩgʉre ñeri dipuwaja mara. Eropigʉ ĩgʉre wejẽ­dore­masibeaa. Ĩgʉre tãraradari mera tãradoregʉca. Iripẽta iidoregʉca. Eropigʉ ĩgʉre wiugʉca, arĩripʉ Pilato. ");
INSERT INTO des_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ĩgʉ eroparĩcʉ̃ ta erã turaro mera gaguininemo, Jesure crusague wejẽdoreñorã. Erã eropa arĩ gaguinicʉ̃ peegʉ Pilato erã gamero dopa ta iidorepʉ. ");
INSERT INTO des_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Eropigʉ erã arĩro dopa ta Pilato Jesure wejẽdorepʉ. ");
INSERT INTO des_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Eropa doregʉ masa serẽdigʉre wiupʉ. Ĩgʉ peresugue árĩgʉre, masare gamewejẽcʉ̃ iidigʉre, masare wejẽdigʉre Pilato Barrabápʉre wiupʉ. Eropigʉ masa erã gamero dopa ta Pilato Jesure crusague wejẽdorepʉ. ");
INSERT INTO des_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Eropirã erã Jesure wejẽrã warã, aĩgãñorã. Erã eropa warisubu Simo waĩcʉgʉ Cirene majagʉ pohegue ejadigʉ erapʉ. Jerusaléngue ĩgʉ eracʉ̃ ĩarã Jesure aĩgãrã ĩgʉre bocatĩri, ñeha, crusare ĩgʉre coãtamudoreñorã Jesu pʉhrʉ. ");
INSERT INTO des_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Eropirã masa bajarã Jesure ĩhanʉrʉsiañorã. Eropirã gajirã nome ĩgʉre erã eropa iicʉ̃ ĩarã turaro ore nʉrʉsiañorã. ");
INSERT INTO des_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Erã orecʉ̃ peegʉ Jesu erãre maji ĩha õpa arĩpʉ: —Jerusalén majarã nome yʉre orebiricãque. Mʉa basi, mʉa porã ya árĩburire oreque. ");
INSERT INTO des_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gajinʉri árĩcʉ̃ masa õpa arĩrãcoma. “Porã marirã nome dohpaguere mari árĩcʉ̃ õatariaboaya,” arĩrãcoma masa. ");
INSERT INTO des_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Irisubure ʉtãgʉre õpa arĩ wereniguirãcoma masa. “Igʉ ʉtãgʉ gʉa weca yuri bejaporo. Gʉare wejẽcãporo,” arĩrãcoma masa. ");
INSERT INTO des_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Masa yʉre dipuwaja marigʉre erã õpa iicʉ̃, ñeri dipuwaja oparãpʉ ñetariaro warãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Gajirã perã dorerire tarinʉgarã erã árĩcʉ̃ erã sãre Jesu mera erã wejẽmorãre aĩgãñorã erã. ");
INSERT INTO des_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Erã aĩgã dipu pero waĩcʉrogue eja crusague Jesure pabiañorã. Eropirã gajirã perã sãre yujugʉre ĩgʉ diayepʉ gajigʉre ĩgʉ copʉ crusariguere pabiañorã. ");
INSERT INTO des_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Erã eropa iicʉ̃ Jesu õpa arĩpʉ: —Ahʉ, oã dohparagã erã ñero iirire cãdijique erãre. Erã erã eropa iirire masibeama. Eropigʉ irire cãdijique, arĩpʉ Jesu ĩgʉ Pagʉre. Eropirã surara Jesu suhri mʉrare “¿Noa yañe árĩrocuri iñe?” arĩ game bira wajatañorã. ");
INSERT INTO des_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Eropirã masa ero niguirã erã ĩaro judio masa oparã Jesure wereyañorã: —Ĩgʉ gajirã masare sĩribonirãre taurapʉ. Eropigʉ ĩgʉ Cristo Goãmʉ ĩgʉ beyedigʉ árĩgʉ ĩgʉ basi tariporo, arĩ wereyañorã erã. ");
INSERT INTO des_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Surara sã ĩgʉre wereyañorã. Jesu pohro ejarã, vino sʉĩrire erã oriñorã. ");
INSERT INTO des_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Irire iirã õpa arĩñorã erã: —Mʉhʉ judio masa erã opʉ árĩgʉ ta, mʉ basi tarique, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Eropi ĩgʉ weca õpa arĩ gojarapũre pabia tuñorã: “Ihĩ judio masa tauro opʉ árĩgʉ ãhrimi,” arĩ gojaturapũ árĩyoro. Griego ya mera, Roma majarã ya mera, judio masa ya mera gojarapũ árĩyoro. ");
INSERT INTO des_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Gajigʉ ĩgʉ mera erã pabia tudigʉ ĩgʉ ñero arĩ wereniguipʉ Jesure: —¿Mʉhʉ Cristo árĩbeari? Mʉ basi, gʉa sãre tauque, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ĩgʉ eroparĩcʉ̃ peegʉ ĩgʉ mera majagʉpʉ ĩgʉre yʉhripʉ: —Eropa arĩbiricãque. ¿Duhpigʉ Goãmʉre umupeobeari mʉhʉ? Marire yujuro mera dipuwaja moama erã. ");
INSERT INTO des_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Maripʉre mari ñeri dipuwajare dipuwaja moarã diaye iirã iima erã. Ihĩpʉ ñerire iibiriñumi, arĩpʉ gajigʉ tarinʉgagʉpʉ. ");
INSERT INTO des_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eropa arĩgʉ ĩgʉ Jesure õpa arĩpʉ: —Jesu, mʉhʉ opʉ árĩrogue árĩgʉ yʉ sãre guñaque, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—Mʉre ire arãa. Dohpagãre yʉ mera paraíso waĩcʉrogue yʉ mera árĩgʉca, arĩpʉ Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Eropi goeri boje gohra árĩcʉ̃ árĩpehrerogue ʉhre hora gohra naitĩa wayoro. ");
INSERT INTO des_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Naitĩaro árĩrisubu Goãmʉ wihi majañe suhriro cãhmotara suhriro deco mera yehguea wayoro. ");
INSERT INTO des_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eropigʉ Jesu turaro gaguinipʉ: —Ahʉ, yʉ sĩporãre mʉre wiaa mʉ dibuboro dopa, arĩ gaguinipʉ Jesu. Eropa arĩtuha sĩria wapʉ. ");
INSERT INTO des_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Eropa wacʉ̃ ĩagʉ surara opʉpʉ “Goãmʉ turagʉ ãhrimi,” arĩ, “Ihĩ Jesu diaye ta õagʉ ãhrañumi,” arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Eropirã ero gamenererã iri eropa wacʉ̃ ĩarã, Jesu ĩgʉ sĩricʉ̃ ĩarã, erã ya wihigue dujaa wañorã. Dujaa wa, bʉjawereri mera waha wañorã. ");
INSERT INTO des_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Árĩpehrerã Jesu mera majarã, Galileague ĩgʉ mera arinirã nome sã yoarogue Jesure ĩhu niguiñorã. ");
INSERT INTO des_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Irisubure José waĩcʉgʉ ero árĩpʉ. Judea yeba Arimatea waĩcʉri maca majagʉ árĩpʉ. Eropigʉ ĩgʉ õagʉ, diaye iigʉ árĩgʉ, Goãmʉ ĩgʉ opʉ árĩnʉgaburire coregʉ árĩpʉ. Eropigʉ ĩgʉ judio masa oparã mera majagʉ árĩqueregʉ ta Jesure erã wejẽdorecʉ̃ gamebiriripʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Eropigʉ Pilato pohrogue eja, Jesu mʉrʉ dʉpʉre serẽpʉ. ");
INSERT INTO des_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Serẽtuha Jesu dʉpʉre aĩ diju, õari suhriro mera ĩgʉ dʉpʉre omapʉ. Eropa omatuha masa gobegue ʉtãyegue erã seara gobegue apipʉ ĩgʉ dʉpʉre. Iri gobere ne yujugʉ sĩridigʉre yaanibiriñorã dohpa. ");
INSERT INTO des_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Irinʉ Sabadonʉ maja árĩburire erã amuyurinʉ árĩyoro. Sabado judio masa soorinʉ árĩboro merogã dʉhyayoro. ");
INSERT INTO des_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Eropirã Galileague Jesu mera arinirã nome masa gobegue José wacʉ̃ ĩarã nʉrʉsiañorã. Masa gobegue eja, iri gobere ĩha, Jesu dʉpʉre ĩgʉ apirare ĩañorã. ");
INSERT INTO des_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pʉhrʉ erã ya wihigue dujaa wañorã. Poresurire ĩgʉ dʉpʉre sũburire amuñorã erã. Eropirã Sabado árĩcʉ̃ Goãmʉ ĩgʉ dorerire Moisere ĩgʉ apirare iri dorero dopa ta erã sooñorã. ");
INSERT INTO des_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo árĩcʉ̃ boyorogue erã nome erã poresuri erã amurare aĩ Jesu masa gobe pohrogue aĩgãñorã. ");
INSERT INTO des_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Iri gobegue ejarã, iri gobere biharaye ʉtãyere erã pãgũ nugurayere ĩañorã. ");
INSERT INTO des_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eropa ĩarã erã iri gobegue ñaja wañorã. Jesu dʉpʉpʉre ne bocajabiriñorã erã. ");
INSERT INTO des_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ĩgʉ dʉpʉre bocabirã, “¿Dohpa wayuri?” arĩ pepiñorã erã. Erã eropa arĩ pepi erã werenigui amaro gohra perã ʉma gosesiriri suhricʉrã erã pohro niguiñorã. ");
INSERT INTO des_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ero erã niguicʉ̃ ĩha, nome güirã merejañorã. Eropirã ʉmapʉ erãre wereñorã: —¿Duhpimorã sĩridigʉ mʉrʉ ĩgʉ árĩdirore ahmari mʉa? Dohpaguere ĩgʉ ojocarigʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ĩgʉ õre marimi. Masa mʉriatuhami. ¿Sohõ árĩrasubure Galileague mʉa mera árĩgʉ ĩgʉ arĩrare guñari mʉa? ");
INSERT INTO des_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Yʉ masʉre Goãmʉ ĩgʉ obeodigʉre wiarãcoma ñerãre. Erã yʉre crusague pabia wejẽrãcoma erã yʉre. Eropigʉ yʉ sĩrira pʉhrʉ ʉhrenʉ pʉhrʉ masa mʉriagʉca yʉhʉ,” ¿mʉare ĩgʉ arĩrare guñari mʉa? arĩñorã ʉmapʉ. ");
INSERT INTO des_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Erã eroparĩcʉ̃ peerã, nomepʉ ĩgʉ arĩrare guñañorã. ");
INSERT INTO des_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Erã eropa arĩra pʉhrʉ erã dujaa wañorã. Once buherãre gajirã sãre irire werepehoñorã. ");
INSERT INTO des_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Erã nomepʉ María Magdalena, Juana, María Santiago pago árĩñorã. Erã nome gajirã nome sã árĩñorã Jesu buherãre eropa wererã nome. ");
INSERT INTO des_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Erã eropa arĩ werequerecʉ̃ ta Jesu buherãpʉ “Erã diaye arĩbiribocoma. Eropa arĩcãrã iima oã nome,” arĩ pepiriñorã. Eropirã erã nomere peediabiriñorã. ");
INSERT INTO des_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Erã eroparĩcʉ̃ peegʉ, Pedropʉ masa gobegue omagã, ĩagʉ wapʉ. Iri gobegue eja, ĩgʉ muhmereja ĩhame acupʉ. Jesure erã omara gasiro dihtare ĩapʉ. “¿Dohpa wayuri?” arĩ pepigʉ ĩgʉ wihigue dujaa wapʉ. ");
INSERT INTO des_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Irinʉre perã Jesu buherã mera majarã Emaus waĩcʉri macague warã iiñorã. Jerusalénre once kilómetros yoaro ãhraa Emaure ejaro. ");
INSERT INTO des_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Emaugue waha, árĩpehreri Jesure eropa warare wereniguigãrã iiñorã. ");
INSERT INTO des_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Erã eropa arĩ werenirisubu Jesupʉ erã watope erã mera wapʉ. ");
INSERT INTO des_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eropirã ĩgʉre ĩaquererã ta erã ĩgʉre ĩha masibiriñorã. ");
INSERT INTO des_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","—¿Mʉa curirã warã dohpa arĩ werenigui bʉjawererã iiri mʉa? arĩpʉ Jesu. Ĩgʉ eroparĩcʉ̃ erã dujanʉgañorã bʉjawererã. ");
INSERT INTO des_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Eropigʉ Cleofa waĩcʉgʉpʉ Jesure yʉhripʉ: —¿Dohpaguere Jerusalénre erã iirare mʉ dihta masibeari? arĩ serẽpipʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Dohpa wahári Jerusalénre? arĩpʉ Jesu. Ĩgʉ eroparĩcʉ̃ Cleofa yʉhripʉ: —Jesure Nazare majagʉre erã iirare arĩrã iiaa. Ĩgʉ Goãmʉ yare weremʉhtagʉ árĩrimi. Eropirã ĩgʉ wereniguirire peerã, ĩgʉ iira sãre ĩarã, “Turagʉ ãhrimi,” arĩ pepirima masa. Goãmʉ sã eropa arĩ pepicumi. ");
INSERT INTO des_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mari pahia oparã, gajirã oparã mera ĩgʉre wejẽdorerã gajirãre ohama. Erã eropa ocʉ̃ gajirãpʉ ĩgʉre crusague pabia wejẽama. ");
INSERT INTO des_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Roma majarãre cóãbu Israe masa opʉ árĩbu ãhrimi,” arĩ pepiribʉ gʉa ĩgʉre. Dohpagã mera ʉhrenʉ wahaa ĩgʉ sĩrira pʉhrʉ. ");
INSERT INTO des_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bajamerãgã gʉa mera majarã nome gʉare ʉcacʉ̃ iiama. Boyoro Jesu ĩgʉ masa gobegue erã eja, ");
INSERT INTO des_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ĩgʉ dʉpʉre erã bocabirañorã. Dʉpʉre bocabiri erã dujara wereama. “Gʉare anyua dehyoama. Jesu ojocariapʉ,” arĩ wereama nomepʉ. ");
INSERT INTO des_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Erã eroparĩcʉ̃ gajirã gʉa mera majarãpʉ iri gobegue eja nome erã arĩdiro dopa ta ĩañorã. Erã sã Jesu mʉrʉre ĩabirañorã, arĩpʉ ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ĩgʉ eropa arĩra pʉhrʉ Jesu werepʉ erãre: —Mʉa ne peebirã ãhraa. ¿Goãmʉ yare weremʉhtanirã mʉra erã arĩrare õaro peebeari mʉa? ");
INSERT INTO des_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristo opʉ árĩboro core ĩgʉ ʉmarogue ĩgʉ mʉriaboro core ĩgʉre ñero tariro gahmeabʉ. ¿Irire masibeari mʉa? arĩpʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Eropa arĩgʉ Goãmʉ yare erã gojarapũguere erã ĩgʉre gojayurare Jesu werepehocãpʉ erãre. Moise mʉrʉ ĩgʉ gojarare Jesu werenʉgapʉ. Eropigʉ árĩpehrerã Goãmʉ yare weremʉhtanirã erã gojara sãre erãre werepehocãpʉ. ");
INSERT INTO des_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Erã erã wari macague erã ejacʉ̃ Jesupʉ erãre tarigãgʉ dopa iipʉ. ");
INSERT INTO des_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ĩgʉ eropa iiquerecʉ̃ ta erãpʉ ĩgʉre wadorebiriñorã. —Gʉa mera dujaque. Ñamicague ãhraa. Nairo iica, arĩñorã erã Jesure. Eropigʉ Jesu erã mera wihigue ñaja wapʉ. ");
INSERT INTO des_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pʉhrʉ ĩgʉ erã mera erã bari mesague doaja, panre aĩ, Goãmʉre “Õhaa” arĩpʉ. Eropa arĩgʉ iri panre nuha aĩ erãre ópʉ. ");
INSERT INTO des_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ĩgʉ eropa iicʉ̃ ĩarã erã Jesure ĩha masiñorã pare. Erã ĩha masira pʉhrʉ ĩgʉ dederea wapʉ. ");
INSERT INTO des_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ĩgʉ eropa dederecʉ̃ erã erã basi õpa arĩ wereniguiñorã: —Mague ĩgʉ marire wereniguirisubu Goãmʉ ĩgʉ gojarare ĩgʉ wereniguirisubu mari sĩporã mera õaro mucubiriri mera pepiabʉ mari, arĩñorã erã basi. ");
INSERT INTO des_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Eropa arĩtuha erã mata Jerusaléngue dujaa wañorã. Erogue eja, once buherãre, gajirã mera gamenererãre bocañorã. ");
INSERT INTO des_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Erã ejacʉ̃, once buherã õpa arĩñorã erãpʉre: —Diaye ta mari Opʉ masa mʉriadi ãhrami. Simo Pedro ĩgʉre ĩapʉ, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Erã eroparĩcʉ̃ peerã Emaus wari maha wanirã sã erã ĩarare wereñorã: —Jesu ĩgʉ panre nuha gʉare ĩgʉ ocʉ̃ ĩha masiabʉ gʉa, arĩñorã gajirãre. ");
INSERT INTO des_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Erã eropa arĩ wererisubu mata Jesupʉ erã pohro dehyoanʉgajapʉ. —¿Ãhriri mʉa? arĩpʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ĩgʉ eroparĩcʉ̃ erã “Sĩridigʉ mʉrʉre ĩarã iiaa mari,” arĩ pepi, turaro güiñorã. ");
INSERT INTO des_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Erã eropa güicʉ̃ ĩagʉ ĩgʉ erãre werepʉ: —¿Duhpirã güiri mʉa? ¿Duhpirã yʉre ĩarã “I diaye árĩbeaa, arĩri mʉa? ");
INSERT INTO des_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yʉ mojotorire yʉ guburi sãre ĩaque. Mʉa irire ĩarã, yʉre ĩha masirãca. Yʉre mohmepique. Mohmepirã masirãca mʉa. Sĩridigʉ mʉrʉ dʉpʉ moomi. Yʉpʉ dʉpʉcʉa, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eroparĩgʉ ĩgʉ mojotorire, ĩgʉ guburire ĩhmupʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ĩgʉ eropa ĩhmuquerecʉ̃ ta erã bʉrigã mucubiri ʉca warã “I diaye árĩbeaa,” arĩ pepiniñorã dohpa. Erã eropa arĩ pepicʉ̃ masigʉ Jesu erãre serẽpipʉ: —¿Õre bari ãhriri? arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ĩgʉ eroparĩcʉ̃ waimʉ mupudigʉre mome imisĩri sãre oñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Irire aĩ erã ĩhuro Jesu bapʉ. ");
INSERT INTO des_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Batuha Jesu werepʉ erãre: —Sohõ mari árĩrasubu mʉa mera árĩgʉ yʉhʉ mʉare werediro dopa ta dohpaguere yʉre eropa wahabʉ. Goãmʉ doreri Moise marire ĩgʉ apira ĩgʉ eropa arĩ gojadiro dopa ta yʉre eropa wahabʉ. Goãmʉ yare weremʉhtanirã, Salmopũre gojanirã sã iribojegue erã yʉre arĩ were gojayudiro dopa ta dohpague yʉre eropa wahabʉ. Eropa ta waro gahmeabʉ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Eropa arĩtuha Goãmʉ yare erã arĩ were gojarare ĩgʉ buherãre masicʉ̃ iipʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Goãmʉ yare erã gojara õpa arĩyoro: “Cristo ñero tarigʉcumi. Eropigʉ ʉhrenʉ pʉhrʉ ĩgʉ sĩrira pʉhrʉre ĩgʉ masa mʉriagʉcumi. ");
INSERT INTO des_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ĩgʉ masa mʉriara pʉhrʉ árĩpehreri yeba ĩgʉ yarã Goãmʉ yare buherãcoma. ‘Mʉa ñerire bʉjawererã Jesucristo mera mʉa ñerire cãdijirã árĩrãca,’ arĩ wererãcoma masare. Eropa weremorã Jerusalén were­nʉga­rãcoma,” arĩ gojañumi Goãmʉ yare erã gojarapũ, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eropa arĩtuhaja õpa arĩ werenemopʉ: —Mʉapʉ i árĩpehrerire ĩanirã ãhraa. Eropirã gajirãre wererãca. ");
INSERT INTO des_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Goãmʉ “Ĩgʉre mʉare obeogʉra,” ĩgʉ arĩdigʉre yʉpʉ mʉare obeogʉra. Eropirã Jerusaléngue ĩgʉ Espíritu Santo mʉare ĩgʉ eraburire coreque mʉa. Ĩgʉ mʉare turarire ogʉcumi, arĩpʉ Jesu ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Eropa arĩtuha Jesu erãre Jerusalén árĩrãre Betaniague aĩgãpʉ. Erogue eja, Jesu ĩgʉ mojotori mera sĩmuju, “Õaro árĩque,” arĩpʉ erãre. ");
INSERT INTO des_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eropa arĩtuha erãre api, ʉmarogue mʉria wapʉ. ");
INSERT INTO des_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ĩgʉ mʉriara pʉhrʉ erã ĩgʉre umupeo, “Õagʉ, turagʉ ãhrimi,” arĩ, Jerusaléngue bʉrigã mucubiriri mera dujaa wañorã. ");
INSERT INTO des_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ero ãhri ʉmʉri nʉcʉ erã Goãmʉ wihigue Goãmʉre serẽmʉriñorã. “Mʉhʉ õagʉ ãhraa,” arĩ umupeoniguicãmʉriñorã erã ĩgʉre. Eropa ta árĩporo. Iripẽta ãhraa.");
INSERT INTO des_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Negohraguere i yeba árĩboro coregue ta Cristo mata árĩmʉhtamʉrituhapʉ. Ĩgʉ Goãmʉ mera árĩpʉ. Eropigʉ ĩgʉ Goãmʉ ta árĩcãgʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Matague ta Cristo Goãmʉ mera árĩpʉ. ");
INSERT INTO des_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Eropigʉ i yebare, ʉmʉsire árĩpehrerire ĩhacũ­nugudorepʉ Goãmʉ ĩgʉre. Eropigʉ masa sãre ĩhacũnugudorepʉ ĩgʉre. Eropigʉ irire ĩhacũnugupehopʉ ĩgʉ Jesucristo. Eropiro irire ĩgʉ ĩhacũnugupehobiricʉ̃ i ne mariboya. ");
INSERT INTO des_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cristo ojocaririre ogʉ ãhrimi. Boyocʉ̃ mari mari basi õaro mari ĩha masiro dopa ta, ĩgʉ mari Pagʉre õaro ĩha masicʉ̃ iimi marire. Eropigʉ i yebare eragʉ mari Pagʉre masicʉ̃ iimi masare. ");
INSERT INTO des_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I yeba majarã erã guñaricʉri naitĩaro iro dopa ñeri ãhraa. Jesucristo boyogoro dopa ta masa pohro eragʉ erã Goãmʉ yare masicʉ̃ iimi. Eropiro naitĩariñe, boyoriñere ne tarinʉgabiro dopa ta Cristore ñeripʉ ne tarinʉgabiriyoro. ");
INSERT INTO des_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Goãmʉ Ñu waĩcʉgʉpʉre obeomʉhtapʉ Cristore quere aĩgã weremʉhtadoregʉ. Ĩgʉ obeodigʉ Ñupʉ eraa gʉare masare Cristo ĩgʉ ariburire weremi. ");
INSERT INTO des_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ñupʉ Cristo árĩbirimi. Eropa árĩbiriqueregʉ ta ĩgʉ Cristore masare wereyumʉhtagʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristo boyogoro dopa ta árĩgʉ árĩpehrerã masare Goãmʉre masicʉ̃ iibu i yebaguere aridigʉ árĩmi. Diaye ta ãhraa. Ĩgʉ masare masicʉ̃ iigʉ ta ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Eropigʉ Cristo i yebare árĩdigʉ árĩrimi. I yebare ĩhacũnugudigʉ árĩpʉ. Ĩgʉ eropa árĩquerecʉ̃ ta i yeba majarã ĩgʉre ne ĩha masibirinirã árĩma. ");
INSERT INTO des_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ĩgʉ ya yeba ĩgʉ masa dehyoadigʉ árĩrimi. Ĩgʉ ya yeba ĩgʉ masa dehyoadigʉ árĩquerecʉ̃ ta ĩgʉ ya yeba majarãpʉ ĩgʉre ne gamebirinirã árĩma. ");
INSERT INTO des_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Erã eropa gamebiriquerecʉ̃ ta árĩpehrerã ĩgʉre gamerãpʉre erãre Goãmʉ ĩgʉ porã árĩcʉ̃ iimi. Ĩgʉre umupeorãre árĩpehrerã Goãmʉ ĩgʉ porã árĩcʉ̃ iimi. ");
INSERT INTO des_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Erã Goãmʉ porã ta ãhrima. Eropirã masa erã gamero Goãmʉ porã wabeama. Goãmʉ gamero mera ĩgʉ porã wahama. ");
INSERT INTO des_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Eropigʉ Cristo ĩgʉ masʉ ĩgʉ árĩnʉgara pʉhrʉ mari mera árĩmi ĩgʉ. Ĩgʉ eropa árĩcʉ̃ ĩarã masare mahigʉ, diaye majare ĩgʉ wereniguigʉ árĩcʉ̃ gʉa masibʉ. Ĩgʉ dihta Goãmʉ magʉ árĩgʉ turagʉ árĩmi. Ĩgʉ eropa árĩgʉ árĩcʉ̃ gʉa masibʉ. ");
INSERT INTO des_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ñu waĩyegʉ ĩgʉ buherogue Cristo eracʉ̃ ĩha õpa arĩ gaguiniguimi gʉare weregʉ: —Sihĩ ahrimi yʉ mʉare weredigʉ. Ĩgʉ yʉ pʉhrʉ masa dehyoadigʉ ãhrimi. Eropa árĩqueregʉ ta yʉ tauro turagʉ ãhrimi. Ĩgʉ yʉ masa dehyoaboro coregue árĩtuhapʉ. Eropigʉ ĩgʉ yʉ tauro ãhrimi. Yʉhʉ mʉare eropa arĩ weredigʉ ta ãhrimi ihĩ, arĩmi Ñu gʉare. ");
INSERT INTO des_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ĩgʉ Cristopʉ õagʉ turaro masare mahigʉ árĩgʉ marire árĩpehrerãre õaro iiniguicãmi. ");
INSERT INTO des_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Goãmʉ dorerire Moisepʉ apimʉhtapʉ marire. Jesucristopʉ Goãmʉ masare ĩgʉ mahirire buhegʉ árimi. Goãmʉ ĩgʉ diaye wereniguiri sãre buhegʉ árimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Masa ne Goãmʉre ĩabeama. Ĩgʉre mari ĩabiriquerecʉ̃ ta ĩgʉ magʉ ĩgʉ turaro mahigʉ yujugʉ ta árĩgʉpʉ ĩgʉ Pagʉre marire masicʉ̃ iimi. ");
INSERT INTO des_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judio masa oparã Jerusalén árĩrã pahiare, Goãmʉ wihi mohmerã sãre Ñu pohrogue obeoñorã. “¿Nihino ãhriri mʉhʉ?” arĩ serẽpidorerã obeoñorã erãre. Erã eropa arĩ serẽpirã ejacʉ̃ õpa arĩ weremi Ñupʉ. ");
INSERT INTO des_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ne yayaro mariro weremi. Diaye ta werepehocãmi gʉyaro mariro. —Yʉhʉ Cristo Goãmʉ ĩgʉ masare taudoregʉ ĩgʉ obeodigʉ árĩbeaa, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ĩgʉ eroparĩcʉ̃ erãpʉ ĩgʉre dipaturi serẽpima daja: —¿Mʉhʉ Cristo árĩbigʉ Eliapʉ ãhriri? arĩma. —Árĩbeaa yʉhʉ, arĩmi ĩgʉ. —¿Gʉa coredigʉ Goãmʉ yare weremʉhtagʉpʉ ãhriri mʉhʉ? arĩma erã. —Árĩbeaa yʉhʉ, arĩmi Ñu. ");
INSERT INTO des_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ĩgʉ eroparĩcʉ̃ erã ĩgʉre dipaturi serẽpima daja. —Gʉare serẽpidorenirãre gʉa õaro wereboro dopa gʉare wereque daja. ¿Nihinopʉ ãhriri mʉhʉ? ¿Dohpa árĩgʉno ãhriri mʉhʉ? arĩma erã Ñure. ");
INSERT INTO des_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Erã eroparĩcʉ̃ õpa arĩ yʉhrimi: —Masa marirogue õpa arĩ gaguiniguigʉ ãhraa yʉhʉ. Goãmʉ ya weremʉhtadigʉ Isaia mʉrʉ ĩgʉ werediro dopa ta werea yʉ sã: “Mari Opʉ ĩgʉ ariboro core õarã árĩyuque ĩgʉre peemorã,” arĩ masare wereyu gaguiniguigʉ ãhraa yʉhʉ, arĩmi Ñu erãre ");
INSERT INTO des_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ñure serẽpirã fariseo masa erã obeonirã árĩma. ");
INSERT INTO des_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Eropirã erã Ñure serẽpima daja: —¿Mʉhʉ Cristo, Elia Goãmʉ ya weremʉhtagʉ gʉa coregʉ árĩbiriqueregʉ ta duhpigʉ masare Goãmʉ ya árĩburire waĩyeri mʉhʉ? arĩma erã. ");
INSERT INTO des_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Erã eroparĩcʉ̃ yʉhrimi ĩgʉ. —Yʉ deco mera masare Goãmʉ ya árĩburire waĩyea. Gajigʉpʉ mʉa masibigʉpʉ mʉa watope árĩtuhami. ");
INSERT INTO des_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ĩgʉpʉ yʉ pʉhrʉ arigʉ yʉ tauro turagʉ ãhrimi. Õatariagʉ ãhrimi. Ĩgʉ iro dopa árĩbeaa yʉpʉ. Eropigʉ ĩgʉre pepigʉ, “Bu árĩgʉ ãhraa yʉhʉ,” arĩ pepia, arĩmi Ñu erãre. ");
INSERT INTO des_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Eropa arĩ wereniguima erã Betaniague, dia Jordán waĩcʉriya gajipʉ masegue, Ñu ĩgʉ masare ĩgʉ waĩyerogue. ");
INSERT INTO des_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Gajinʉ Jesu Ñu pohro ĩgʉ aricʉ̃ ĩagʉ Ñu õpa arĩmi gʉare: —Ĩaque. Ihĩ Goãmʉ ĩgʉ obeodigʉ ĩgʉ cordero iro dopa ãhrimi. Cordero mari ñeri iira dipuwajare sĩriro dopa ihĩ sĩrigʉ i yeba majarãre erã ñero iirare cóãgʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ihĩ ta ãhrimi yʉ õpa arĩdigʉ: “Yʉ pʉhrʉ arigʉ yʉ tauro turagʉ ãhrimi. Yʉhʉ masa dehyoaboro core ĩgʉ matague ta árĩtuhapʉ. Eropigʉ ĩgʉ yʉ tauro turami,” yʉ arĩdigʉ ihĩ ta ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yʉpʉ ĩre Goãmʉ magʉ ĩgʉ árĩrire masibirinibʉ. Eropa masibiriqueregʉ ta deco mera waĩyegʉ arigʉ iibʉ yʉ acawererã Israe masa ĩre erã masiborore, arĩmi Ñu. ");
INSERT INTO des_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Eropa arĩtuha Ñu werenemomi: —Espíritu Santo ʉmarogue buja iro dopa bejagʉ Cristo weca dijarimi. Ĩgʉ weca ĩgʉ dujanʉgacʉ̃ ĩabʉ. ");
INSERT INTO des_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ĩgʉ weca dujanʉgajacʉ̃ ĩha ĩgʉre ĩha masibʉ. Ĩgʉ yʉre masare deco mera waĩyedore obeodigʉ Goãmʉpʉ õpa arĩ were­mʉhta­tuhami yʉre: “Espíritu Santo dijari ĩgʉ weca dujanʉgajagʉ ĩgʉ ta árĩgʉcumi. Ĩgʉpʉ Espíritu Santore masa mera eropa árĩniguicʉ̃ iigʉ árĩgʉcumi,” arãmi Goãmʉ yʉre. Ĩgʉ yʉre eropa werebiricʉ̃ ĩha masibiriboya ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dohpaguere ĩgʉre ĩha masituhaa yʉhʉ. Eropa ĩha masigʉ “Diaye ta Goãmʉ magʉ ta ãhrimi,” arãa yʉhʉ mʉare, arĩ weremi Ñu. ");
INSERT INTO des_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Gajinʉ Ñu mera gʉa perã ĩgʉ buherã ĩgʉ mera gʉa niguicʉ̃, Jesu gʉa pohro tari wahgãgʉ iimi. Ĩgʉ eropa tari wahgãcʉ̃ ĩagʉ Ñu dipaturi õpa arĩmi gʉare: —Ĩaque. Ihĩ Goãmʉ ĩgʉ obeodigʉ cordero iro dopa árĩgʉ ãhrimi, arĩmi Ñu. ");
INSERT INTO des_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ĩgʉ eroparĩcʉ̃ gʉa perã ĩgʉ buherãpʉ irire peerã Jesure nʉrʉsiagãbʉ. ");
INSERT INTO des_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Gʉa eropa nʉrʉsiagãcʉ̃ ĩagʉ Jesu gʉare maji ĩha, serẽpimi: —¿Nohogue wahari mʉa? arĩmi ĩgʉ gʉare. Ĩgʉ eroparĩcʉ̃ gʉa sã ĩgʉre serẽpibʉ. —Buhegʉ, ¿nohogue ãhriri mʉhʉ? arĩ serẽpibʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Yʉ mera arinijarã, ĩarã arique, arĩmi gʉare Jesu. Ĩgʉ eroparĩcʉ̃ gʉapʉ ĩgʉ árĩrogue ĩarã wabʉ. Irisubu ñamicague cuatro hora árĩbʉ. Eropirã iri ñamire ĩgʉ mera dujabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Gʉa perã Ñure peerã, Jesure nʉrʉsiagãrã yʉ mera majagʉ Andre mera árĩbʉ. Andrepʉ Simo pagʉ magʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Eropigʉ ĩgʉ mata ĩgʉ tĩgʉre ahma boca, õpa arĩ werepʉ ĩgʉre: —Mesiare Goãmʉ marire taubure Goãmʉ ĩgʉ obeodigʉre bocabʉ gʉa, arĩpʉ Andre Simore. Mesia ero majarã ya mera arĩrã, Cristo arĩrã iima. ");
INSERT INTO des_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Eropa arĩtuha ĩgʉ Simore Jesu pohro aĩgãmi. Ĩgʉ pohro erã ejacʉ̃ ĩagʉ Jesupʉ Simore õpa arĩmi: —Mʉhʉ Simo waĩcʉgʉ Jona waĩcʉgʉ magʉ ãhraa. Dohpaguere mʉre Cefa waĩyegʉra, arĩmi Jesu Simore. Cefa ero majarã ya mera arĩrã, Pedro arĩma. Eropigʉ Pedro waĩcʉmi pare. ");
INSERT INTO des_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Gajinʉ Jesu “Galilea yebague ina warã,” arĩmi gʉare. Eropigʉ erogue eja ĩgʉ Felipere bocatĩri õpa arĩmi: —Yʉ mera majagʉ árĩbu arique, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipepʉ Betsaida majagʉ árĩmi. Ĩgʉ, Andre, Pedro mera yuju maca majarã árĩma. ");
INSERT INTO des_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Eropigʉ Felipe Natanaere ahma, boca õpa arĩ weremi: —Goãmʉ dorerire Moise ĩgʉ gojarapũgue ĩgʉ weredigʉre, gajirã Goãmʉ yare weremʉhtanirã sã erã weredigʉre gʉa bocabʉ. Jesu Nazare majagʉ José magʉ ĩgʉ ta árĩcumi, arĩmi ĩgʉ Natanaere. ");
INSERT INTO des_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—Nazareguere ne yujugʉ õagʉ marimi, arĩmi Natanaepʉ. —Ĩagʉ arique mʉhʉ, arĩmi Felipe. ");
INSERT INTO des_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eropi Natanae Jesu pohro ĩgʉ ejacʉ̃ ĩagʉ Jesupʉ õpa arĩmi Natanaere: —Ihĩ dohpague arigʉ diaye ta õagʉ judio masʉ gohra ãhrimi. Ĩgʉre ne gʉyari mara, arĩmi Natanaepʉre. ");
INSERT INTO des_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ĩgʉ eroparĩcʉ̃ peegʉ Natanae ĩgʉre serẽpimi: —¿Duhpigʉ yʉre õaro masiri mʉhʉ? arĩmi. —Felipe, ĩgʉ mʉre ĩgʉ sihuboro core, higueragʉ doca mʉ árĩcʉ̃ ĩhabʉ yʉhʉ mʉre, arĩmi Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ĩgʉ eroparĩcʉ̃ Natanaepʉ õpa arĩmi ĩgʉre daja: —Buhegʉ, diaye ta mʉhʉ Goãmʉ magʉ ta ãhraa. Mʉhʉ Israe masa gʉa opʉ árĩbu ãhraa, arĩmi Natanae. ");
INSERT INTO des_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ĩgʉ eroparĩcʉ̃ peegʉ õpa arĩ yʉhripʉ Jesu: —Higueragʉ doca yʉ mʉre ĩarare masigʉ yʉre “Goãmʉ magʉ ãhraa,” arĩ umupeoa mʉhʉ yʉre. ¿Iri ta mʉre umupeocʉ̃ iiri? Mʉre yʉ eropa ĩara tauro Goãmʉ turari mera yʉ iicʉ̃ ĩagʉca mʉhʉ, arĩmi Jesu Natanaere. ");
INSERT INTO des_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Eropa arĩgʉ õpa arĩ werenemomi: —Diaye ta mʉre arĩgʉ iiaa. Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. Ʉmarogue Goãmʉ yarã anyua erã yʉ weca erã dijaricʉ̃, erã mʉriacʉ̃ sãre ĩagʉca mʉhʉ, arĩmi Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ʉhrenʉ pʉhrʉ Caná Galilea árĩri macague mojoto diriri bosenʉ árĩbʉ. Eropigo Jesu pago iri wihigue árĩmo. ");
INSERT INTO des_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu gʉa ĩgʉ buherã sã erã mojoto dirirogue sihubeonirã árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Iri bosenʉ maja vino pehrecʉ̃ Jesu pago ĩgʉre weremo: —Dohpaguere vino pehrea wahabʉ erãre, arĩmo igo Jesure. ");
INSERT INTO des_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Igo eroparĩcʉ̃ peegʉ Jesu õpa arĩmi: —Meho, ¿duhpigo irire yʉre wereri mʉhʉ? Masa erã yʉre masiboro dʉhyania dohpa, arĩmi Jesu ĩgʉ pagore. ");
INSERT INTO des_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ĩgʉ eroparĩra pʉhrʉ ĩgʉ pagopʉ mohme corerãre weremo. —Yʉ magʉ ĩgʉ dorero dopa ta iique mʉa, arĩmo igo. ");
INSERT INTO des_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Irisubuguere gʉa acawererã judio masa Goãmʉ yare iimorã masare erã dʉpʉre eropa coeniguicãdorema. Eropi iri wihi seis gohra máta sorori, deco dicʉri sorori árĩbʉ. Iri deco Goãmʉ yare iimorã erã coeri deco árĩbʉ. Iri soroburire ochenta o cien litros sihajabʉ decore. ");
INSERT INTO des_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Eropigʉ erã mohme corerãre doremi Jesu: —I soroburire deco mera pisãnemo ʉjʉtu dobopehocãque, arĩmi Jesu. Ĩgʉ eroparĩcʉ̃ erãpʉ õaro ʉjʉtu dobopehocãma iri soroburire. ");
INSERT INTO des_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Erã eropa iira pʉhrʉ Jesu erãre doremi daja: —Dohpaguere iri decore waa aĩ, sihu bosenʉ iigʉre tĩarã waque, arĩmi. Ĩgʉ eroparĩcʉ̃ peerã iri decore waa aĩgã, sihu bosenʉ iigʉre tĩama erã. ");
INSERT INTO des_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Erã tĩacʉ̃ ĩgʉpʉ iri decore vino poyara decore ihriñami. Iri vinore “¿Noho majare aĩgãrayuri erã?” arĩ pepipʉ ĩgʉ. Ĩgʉ eropa masibiriquerecʉ̃ ĩgʉre mohme corerãpʉ iri vinore tĩanirãpʉ masima. Sihu bosenʉ iigʉ eropa masibirinijagʉ, mojoto diridigʉre sihubeo ");
INSERT INTO des_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","õpa arĩ weremi: —Gajirã masa õari decore vino decore tĩamʉhtamʉrima. Masa erã õaro ihrira pʉhrʉ ñequeyari vino decopʉre tĩama erã. Mʉpʉ õari vino decore dihbu, pʉhrʉgue gʉare tĩaa, arĩmi sihu bosenʉ iigʉ mojoto diridigʉre. ");
INSERT INTO des_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Caná Galilea árĩri macague decore vino ĩgʉ poyacʉ̃ iira ne Goãmʉ turari mera ĩgʉ deyoro moanʉgara árĩbʉ. Eropa iigʉ gajirãre ĩgʉ turarire ii ĩhmúmi Jesu. Ĩgʉ eropa ii ĩhmura pʉhrʉ gʉa ĩgʉ buherã ĩgʉre umupeobʉ. ");
INSERT INTO des_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pʉhrʉ Jesu, ĩgʉ pago, ĩgʉ pagʉ porã, gʉa ĩgʉ buherã mera Capernaumgue sihugã wami. Erogue ejarã bajamenʉrigã dujabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua árĩcʉ̃ gʉa judio masa bosenʉ árĩboro merogã dʉhyanijabʉ. Eropigʉ Jesu gʉa mera Jerusaléngue wami. ");
INSERT INTO des_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Erogue ejagʉ ĩgʉ Goãmʉ wihigue ñajajagʉ, wecʉare, ovejare, bujare duarãre bocajami. Eropigʉ niyeru gohrotorã erã mesarigue erã doacʉ̃ bocajami. ");
INSERT INTO des_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Eropa bocajagʉ yuradari mera tãraridari ii, erãre árĩpehrerãre disiporogue tãranʉrʉ wiumi. Eropigʉ niyeru gohrotorã erã ya mesarire yomemuju mehpicãmi. Erã niyeru turi sãre mehsiripicãmi. ");
INSERT INTO des_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Eropa iituha bujare duarãre õpa arĩmi: —Mʉa yarã bujare aĩgãque. Yʉ Pagʉ ya wihire doberi duari wihi iibiricãque, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ĩgʉ eropa iicʉ̃ ĩarã gʉa ĩgʉ buherãpʉ Goãmʉ ya gojarapũ erã arĩrare guñabʉ. Õpa arĩ gojanirã árĩma. “Goãmʉ, mʉ wihire turaro mahia. Eropa mahigʉ mʉ wihire ñero erã iicʉ̃ ĩagʉ turaro bʉjawerea yʉhʉ,” arĩ gojarare guñabʉ gʉa Jesu ĩgʉ buherãpʉ. ");
INSERT INTO des_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesu ĩgʉ eropa iira pʉhrʉ judio masa oparã ĩgʉre serẽpima: —¿Duhpigʉ mʉhʉ oãre Goãmʉ wihigue árĩrãre cohã wiuari? Goãmʉ irire mʉre iidoregʉ árĩcʉ̃ Goãmʉ turari mera ii deyoro moaque gʉa ĩaburire, arĩma erã Jesure. ");
INSERT INTO des_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Erã eroparĩcʉ̃ Jesu yʉhrimi: —I wihire mʉa cóãcʉ̃, ʉhrenʉ pʉhrʉ tuhajagʉca yʉhʉ, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Ʉhrenʉ i wihire iisome mʉhʉ. Cuarenta y seis bojori gohra erã iira wihi ãhraa i wihi, arĩ yʉhrima erã Jesure. ");
INSERT INTO des_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesu ĩgʉ eropa arĩrare erã õaro pee masibirima. Jesu i wihire arĩgʉ ĩgʉ dʉpʉ waburire arĩgʉ iirimi. ");
INSERT INTO des_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eropi ĩgʉ sĩrira pʉhrʉ, ĩgʉ masa mʉriara pʉhrʉ gʉa ĩgʉ buherãpʉ ĩgʉ eropa arĩrare guñabʉ. Goãmʉ yare erã gojarapũre, Jesu ĩgʉ werera sãre guña, “Iri diaye ta ãhraa,” arĩbʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua bosenʉ árĩcʉ̃ Jesu Jerusaléngue árĩmi. Ero ĩgʉ árĩcʉ̃ masa bajarã Goãmʉ turari mera ĩgʉ deyoro moarire ii ĩhmucʉ̃ ĩarã ĩgʉre umupeoma. ");
INSERT INTO des_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Erã eropa umupeoquerecʉ̃ ta Jesu masa erã guñarire õaro masigʉ, “Yʉre eropa umupeoniguicãrãcoma,” arĩ pepibiridi árĩmi. ");
INSERT INTO des_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ĩgʉ masa erã guñarire õaro masími. Eropa masigʉ masa ĩgʉre erã pepirire serẽpibirimi. ");
INSERT INTO des_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iri maca majagʉ Nicodemo waĩcʉgʉ, judio masa oparã mera majagʉ árĩmi. Ĩgʉ fariseo masa ya curu majagʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Eropigʉ ĩgʉ yuju ñami ĩgʉ Jesu pohro ahri ĩgʉ mera weretamupʉ: —Buhegʉ, mʉhʉ Goãmʉ ĩgʉ buhedoredigʉ ĩgʉ obeodigʉ mʉ árĩcʉ̃ gʉa masia. Goãmʉ mʉre ĩgʉ itamubiricʉ̃ mʉpʉ ĩgʉ turari mera ne deyoro moarire ne iibiriboaya. Mʉhʉ bajasuburi Goãmʉ turari mera ii ĩhmua, arĩpʉ Nicodemo Jesure. ");
INSERT INTO des_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ĩgʉ eroparĩcʉ̃ Jesu werepʉ: —Diaye mʉre arĩgʉ iiaa. Ne masa dehyoagʉ iro dopa dipaturi masa dehyoagʉ dihta Goãmʉ yagʉ árĩmasimi. Mʉ sã eropa ta árĩmasia, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—Yaho. ¿Bʉgʉpʉ dohpa ii dipaturi masa dehyoabocuri ĩgʉ? Ĩgʉ pago niji suhriroguere ñajaa, dipaturi masa dehyoa masiya mariboca ĩgʉre, arĩpʉ Nicodemo. ");
INSERT INTO des_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ĩgʉ eroparĩcʉ̃ Jesu yʉhripʉ: —Diaye ta arĩgʉ iiaa mʉre. Ne masa dehyoagʉ iro dopa ta deco mera, Espíritu Santo ĩgʉ turari mera dipaturi masa dehyoagʉ dihta Goãmʉ yagʉ árĩmasimi. ");
INSERT INTO des_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nome nijipo sã nome árĩrã, majirãgãre masa dehyoacʉ̃ iima. Espíritu Santopʉ masare Goãmʉ porã árĩcʉ̃ iimi. ");
INSERT INTO des_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Ne masa dehyoagʉ iro dopa ta dipaturi masa dehyoagʉ dihta Goãmʉ yagʉ árĩmasimi,” yʉ arĩcʉ̃ ne pee gorowerebita. ");
INSERT INTO des_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Espíritu Santo masare Goãmʉ porã ĩgʉ iicʉ̃ iiri miruñe iro dopa ãhraa. Miruñe iri arirogue ahraa. Iri ariro caricʉ̃ mari peea. Eropa peequererã ta iri aridirore, iri waro sãre ne masibeaa. Eropa ta iimi Espíritu Santo masare Goãmʉ porã iigʉ, arĩpʉ Jesu Nicodemore. ");
INSERT INTO des_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Mʉ eropa arĩrire õaro masibeaa, arĩpʉ Nicodemo. ");
INSERT INTO des_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ĩgʉ eroparĩcʉ̃ peegʉ õpa arĩpʉ Jesu: —¿Mʉhʉ judio masare buhegʉ árĩqueregʉ ta, duhpigʉ yʉ arĩrire peebeari? ");
INSERT INTO des_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Diaye mʉre arĩgʉ iiaa. Gʉa masirare, gʉa ĩarare gʉa werea. Gʉa eropa werequerecʉ̃ ta ne mʉa gʉa acawererã judio masa ne peediabiribʉ. ");
INSERT INTO des_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","I yeba majare yʉ werenigui queoñaquerecʉ̃ ta “Diaye ta ãhraa,” arĩbeaa mʉa. Eropa arĩbirã Goãmʉ yare yʉ werecʉ̃ sãre “Diaye ta ãhraa,” arĩsome mʉa. ");
INSERT INTO des_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Ne yujugʉ ʉmarogue Goãmʉ pohrogue wagʉ ne dipaturi dujarisome. Yʉhʉ Goãmʉ ĩgʉ obeodigʉ yʉ dihta ʉmarogue árĩdigʉ i yebaguere aribʉ. Eropigʉ yʉ dihta Goãmʉ yare mʉare weremasia. ");
INSERT INTO des_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Iribojeguere masa mariroguere Moise mʉrʉ añare come mera erã wéadigʉre yucʉgʉ erã nugudigʉgue duhsiupʉ. Yucʉgʉgue ĩgʉ duhsiudiro dopa ta yʉre Goãmʉ ĩgʉ obeodigʉre eropa ta yʉ sãre duhsiurãcoma. ");
INSERT INTO des_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yʉre erã eropa iicʉ̃ árĩpehrerã yʉre umupeorã árĩpehrerinʉri Goãmʉ mera árĩniguirãcoma, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Eropa arĩtuha õpa arĩnemopʉ Jesu: —Goãmʉ árĩpehreri yeba majarãre turaro mahimi. Eropigʉ yʉre ĩgʉ magʉre yujugʉ ta árĩgʉre Goãmʉ obeomi árĩpehrerã yʉre umupeorã peamegue erã wabiriborore. Eropirã árĩpehrerinʉri Goãmʉ mera árĩrãcoma erã. ");
INSERT INTO des_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Goãmʉ yʉre ĩgʉ magʉre masare dipuwaja moadoregʉ obeobirimi i yebaguere. Eropigʉ masare peamegue wabonirãre taubure yʉre obeomi. ");
INSERT INTO des_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Yʉre Goãmʉ magʉre umupeorãre ne dipuwaja moasome Goãmʉ. Yʉre umupeobirãpʉre Goãmʉ dipuwaja moadoretuhami. Masa yʉre Goãmʉ magʉre yujugʉ ta árĩgʉre erã umupeobirira dipuwaja, dipuwaja moagʉcumi Goãmʉ erãre. ");
INSERT INTO des_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yʉhʉ Goãmʉ magʉ i yebaguere arigʉ boyoriñe õaro ĩha masicʉ̃ iro dopa ta Goãmʉ yare õaro masicʉ̃ iiaa masare. Yʉ eropa masicʉ̃ iicʉ̃ ĩarã yʉre umupeobirã yʉre gamebeama. Erã ñerire iiripʉre turaro gahmema. Erã eropa gameri dipuwaja erãre dipuwaja moagʉcumi. ");
INSERT INTO des_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Árĩpehrerã ñerire iirã erã ñero iirire duhudiabeama. Eropirã boyoro iiriñe deyoro moaro dopa ta erã ñero iirare deyoro moari arĩrã yʉre gamebeama. ");
INSERT INTO des_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Õarire iirãpʉ yʉre, yʉ buheri sãre gahmema. Goãmʉ yare erã iirire yʉ õaro deyoro moacʉ̃ gʉhyasĩribeama erã. Eropiro yʉre boyoro iro dopa árĩgʉre gahmema, arĩ werepʉ Jesu. ");
INSERT INTO des_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pʉhrʉ Jesu gʉare ĩgʉ buherãre Judea yebague sihugã wami. Erogue ejagʉ ero majarã mera bajamenʉrigã duja, Goãmʉ ya árĩburire waĩyemi erãre. ");
INSERT INTO des_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ñu sã masare waĩyegʉ iipʉ Enón waĩcʉri macague. Enón waĩcʉri maca Salim waĩcʉri maca pohro árĩbʉ. Ero wʉaro dia árĩbʉ. Ero eropa árĩcʉ̃ ero majarã masare waĩyegʉ iipʉ Ñu. ");
INSERT INTO des_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Erã ĩgʉre peresu iiboro core Enóngue masare waĩyegʉ iipʉ Ñu. ");
INSERT INTO des_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Irisubure Ñu buherã mera majarã bajamerãgã judio masa mera waĩyerire wereniguirã dʉyasoñorã. ");
INSERT INTO des_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tuhaja erã Ñu pohrogue eja irire wereñorã. —Buhegʉ, dia Jordán waĩcʉriya gajipʉ masegue mʉ mera árĩdigʉ “Ĩgʉ ta Cristo ta árĩgʉcumi,” mʉ arĩdigʉpʉ dohpague masare waĩyegʉ iimi. Ĩgʉ eropa iicʉ̃ árĩpehrerã ĩgʉ pohrogue wahama pare, arĩñorã erã Ñure. ");
INSERT INTO des_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Erã eroparĩcʉ̃ peegʉ Ñu yʉhripʉ: —Ĩgʉ dorerire ĩgʉ opacʉ̃ Goãmʉ ĩgʉre odi árĩmi. ");
INSERT INTO des_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Cristo árĩbeaa yʉhʉ,” yʉ arĩcʉ̃ mʉa peeabʉ. Eropa Cristo árĩbiriqueregʉ ta ĩgʉ core wereyubure Goãmʉ ĩgʉ obeodigʉ ãhraa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Õpa ãhraa iri: Mojoto diridigo igo marapʉ mera árĩgo wahamo. Mojoto diridigʉ mera majagʉpʉ diridigʉ ĩgʉ marapocʉcʉ̃ ĩagʉ ĩgʉ werenicʉ̃ peegʉ turaro mucubirimi. Eropigʉ mojoto diridigʉ mera majagʉ ĩgʉ mucubiridiro dopa ta yʉ sã Cristo mera masa erã wacʉ̃ ĩagʉ õaro mucubiria. ");
INSERT INTO des_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cristopʉre umupeoro gahmea masare. Yʉpʉre umupeo­biricãro gahmea masare, arĩ yʉhripʉ Ñu. ");
INSERT INTO des_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Eropa arĩtuhagʉ õpa arĩnemopʉ Ñu. —Ʉmarogue aridigʉ árĩpehrerã nemoro turagʉ ãhrimi. Mari masa i yeba majarã ãhraa. Eropirã i yeba majare wereniguia mari. Ʉmarogue aridigʉpʉ árĩpehrerã nemoro turagʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ĩgʉ ĩarare, ĩgʉ peerare ĩgʉ weremi. Ĩgʉ eropa werequerecʉ̃ ta masa ĩgʉre ne peediabeama. ");
INSERT INTO des_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ʉmarogue aridigʉ ĩgʉ wererire masa peerãpʉ, “Goãmʉ diaye árĩgʉ tiimi,” arĩrã iima erã. ");
INSERT INTO des_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ihĩ Cristore Goãmʉ ĩgʉ obeodigʉre Espíritu Santo ya turarire opehoñumi Goãmʉ. Eropigʉ ĩgʉ Goãmʉ ya wereniguirire wereniguimi. ");
INSERT INTO des_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Goãmʉ ĩgʉ magʉre turaro mahimi. Eropigʉ árĩpehrerire, árĩpehrerã sãre erã opʉ árĩdoremi Goãmʉ ĩgʉ magʉre. ");
INSERT INTO des_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Goãmʉ magʉre umupeorãpʉ ʉmʉri nʉcʉ Goãmʉ mera árĩniguicãrãcoma. Ĩgʉ magʉre tarinʉgarãpʉ Goãmʉ pohro wasome. Eropirã ʉmʉri nʉcʉ ʉmaroguere árĩsome. Eropigʉ Goãmʉ erãre turaro dipuwaja moagʉcumi, arĩpʉ Ñu masare. ");
INSERT INTO des_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesu Ñu nemoro bajarã ĩgʉ buherã ĩgʉ opacʉ̃, Ñu nemoro masare ĩgʉ waĩyecʉ̃ fariseo masa peeñorã. ");
INSERT INTO des_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Erã eropa peebeoquerecʉ̃ ta Jesupʉ ĩgʉ basi masare waĩyebirimi. Gʉa ĩgʉ buherãpʉ masare waĩyebʉ. ");
INSERT INTO des_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo masa erã eropa masicʉ̃ peegʉ Jesupʉ Judea yeba árĩdigʉ Galilea yebague sihu dujaa wami gʉare. ");
INSERT INTO des_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galileague warã gʉa “Samaria yebare tarigã warãca,” arĩbʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Eropa tarigã Samaria yebague árĩri macague Sica waĩcʉri macague ejabʉ. Iri maca pohro iribojegue Jacobo mʉrʉ ĩgʉ magʉ José mʉrʉre ĩgʉ ora yeba árĩyoro. ");
INSERT INTO des_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ero Jacobo mʉrʉ ĩgʉ deco ihrira gobe árĩbʉ. Eropigʉ Jesupʉ yoarogue aridigʉ, ĩgʉ oẽtaria wagʉ iri gobe pohro doajami. Irisubu ĩgʉ ero doajarisubu goeri boje gohra árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Gʉa ĩgʉ buherãpʉ macague gʉa barire asũrã wara pʉhrʉ yujugʉ ta ĩgʉ erore dujadoami. Eropigo Samaria majago iri gobegue igo deco waago eracʉ̃ Jesu igore deco serẽpʉ: —Deco oque yʉre, arĩpʉ. ");
INSERT INTO des_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","—Mʉhʉ judio masʉ ãhraa. Yʉpʉ Samaria majago ãhraa. ¿Duhpigʉ yʉre decore serẽri mʉhʉ? arĩpo igo Jesure. Judio masa Samaria majarãre game ĩadiabirã árĩñorã. Eropigo igo eropa arĩpo Jesure. ");
INSERT INTO des_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Igo eropa arĩra pʉhrʉ Jesu igore werepʉ: —Mʉre Goãmʉ ĩgʉ itamudiarire masigo árĩgo, mʉre decore serẽgʉre masigo árĩgo, mʉpʉ yʉpʉre serẽboaya. Mʉ eropa serẽcʉ̃ gaji decore oboaya yʉhʉ mʉre. Iri decopʉ ojocariniguicãcʉ̃ iiri ãhraa, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ĩgʉ eroparĩcʉ̃ peego igo yʉhripo ĩgʉre: —Ne mʉre sorobu mara. I gobe sã ʉ̃hcãri gobe ãhraa. ¿Eropigʉ i ojocaricʉ̃ iiri decore nohogue waabocuri mʉhʉ? ");
INSERT INTO des_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Gʉa ñecʉ mʉrʉ Jacobo iribojegue majagʉ mʉrʉ i gobere gʉare apimʉripʉ. Ĩgʉ, ĩgʉ porã, ĩgʉ ejorã sã i decore ihrimʉriñorã. “Gaji decore oboaya yʉhʉ,” mʉ arĩgʉ, ¿Jacobo tauro turagʉ ãhriri mʉhʉ eropa arĩ pepigʉ? arĩpo igo. ");
INSERT INTO des_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Igo eroparĩcʉ̃ Jesu yʉhripʉ: —Árĩpehrerã i decore ihrirã dipaturi ñemesiburãcoma. ");
INSERT INTO des_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yaha decopʉre ihrirã ne dipaturi ñemesibusome. Eropirã yaha decore ihrirã Goãmʉ mera eropa árĩniguirãcoma. Maʉ dipagãgue eropa deco wiriniguiro dopa ta yaha deco ne pehresome, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ĩgʉ eroparĩcʉ̃ nomeopʉ õpa arĩpo: —Ne dipaturi yʉ ñemesibubiriboro dopa iri decore oque yʉre. Eropigo dipaturi õguere ne deco waasome, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Igo eroparĩcʉ̃ Jesu igore werepʉ: —Irisubu tamerare mʉ marapʉre sihugo waque. Sihutuha õgue arique ĩgʉ mera, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Marapʉ marigo ãhraa yʉhʉ, arĩpo igo. —Diaye ta arãa mʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mʉhʉ cincosuburi marapʉcʉ­tuharibʉ. Eropigʉ dohpague mʉ mera árĩgʉ mʉ marapʉ gohra árĩbeami. Eropigo “Marapʉ marigo ãhraa,” arĩgo, diaye ta arãa mʉhʉ, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ĩgʉ eroparĩcʉ̃ peego õpa arĩpo igo: —Ne, Goãmʉ yare weremʉhtagʉ ãhraa mʉhʉ yʉ pepicʉ̃. ");
INSERT INTO des_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Gʉa ñecʉ sʉmarã mʉra irigʉ ʉtãgʉgue Goãmʉre umupeomʉriñorã. Eropirã mʉapʉ judio masa “Jerusaléngue masare Goãmʉre umupeoro gahmea,” arĩmʉribʉ mʉa judio masa, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Igo eroparĩcʉ̃ Jesu yʉhripʉ: —Nomeo, yʉpʉre peenique. Pʉhrʉguere irigʉ ʉtãgʉgue, Jerusaléngue sãre mari Pagʉre umupeosome mʉa. ");
INSERT INTO des_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉapʉ mʉa umupeorire masibeaa. Masare taubupʉ judio masʉ ãhrimi. Eropirã gʉa judio masapʉ gʉa umupeogʉre masia. ");
INSERT INTO des_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dohpaguere pʉhrʉgue sãre Goãmʉre diaye umupeorã erã õaro pepiri mera ĩgʉre umupeorãcoma. Eropa mari umupeocʉ̃ gahmemi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Goãmʉ dʉpʉ marigʉ ta ĩgʉ árĩcʉ̃ masa ĩgʉre ĩabeama. Eropiro ĩgʉre umupeori mera erã õaro pepiri mera ĩgʉre õaro diaye umupeoro gahmea masare, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ĩgʉ eroparĩcʉ̃ igo yʉhripo: —Mesia, “Cristo,” erã arĩgʉpʉ, masare taubu ĩgʉ ariburire masia yʉhʉ. Ĩgʉ arigʉ marire árĩpehrerire buhepehogʉcumi, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Yʉhʉ ta ãhraa Cristo, arĩpʉ Jesu igore. ");
INSERT INTO des_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ĩgʉ eropa arĩ weretamurisubu gʉapʉ ĩgʉ buherãpʉ erabʉ. Jesu nomeo mera ĩgʉ wereniguicʉ̃ ĩarã ʉca wacarabʉ. Eropa ʉcaquererã ta “¿Dohpa gahmeri mʉhʉ? ¿Dohpa arĩri mʉhʉ igore?” arĩ serẽpiñabiribʉ. ");
INSERT INTO des_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Eropigo nomeo igo sorobure ero duhudobocã, macague waha wamo. Eja masare werego õpa arĩpo: ");
INSERT INTO des_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Yʉ iirare werepehogʉre ĩarã arique mʉa. ¿Ĩgʉ diaye ta Cristo árĩbocuri? Ĩarã arique mʉa, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Igo eroparĩcʉ̃ iri maca majarã Jesure ĩarã arimorã iima. ");
INSERT INTO des_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Irisubure gʉa Jesu buherã ĩgʉre turaro badoreribʉ. —Buhegʉ, baque, arĩribʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Gajiropa árĩri barire opaa yʉhʉ. Irire mʉa masibeaa, arĩmi ĩgʉ gʉare. ");
INSERT INTO des_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ĩgʉ eroparĩcʉ̃ peerã gʉa basi õpa arĩ wereniguibʉ: —¿Gajirã ĩgʉre barire otuhayuri? arĩbʉ gʉa basi. Gʉa eroparĩcʉ̃ Jesu weremi: ");
INSERT INTO des_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—Masapʉ basʉama. Yʉre obeodigʉ ĩgʉ gamerire iigʉ sʉaa yʉpʉ. ");
INSERT INTO des_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Wapicʉrã aberi dʉhyaa mari dʉca aĩboro,” pohe opʉ ĩgʉ arĩ pepimi. Mʉapʉ “Goãmʉ yare gʉa masare wereboro dʉhyania,” arĩ pepibiricãque. Diaye arĩgʉ iiaa mʉare. Dohpague tamerare masare wererã waque. Masare ĩaque. Dohpague tamerare yʉ buherire masa erã peeburisubuno árĩro tiiaa. ");
INSERT INTO des_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Dʉcare aĩrãre erã wajayero dopa ta, yaharã árĩmorãre aĩnirãre yahare buhenirãre wajayegʉra yʉhʉ. Erã eropiira waja õaro wajayegʉra erãre. Erã eropa buhecʉ̃ peerã yʉ buherire peenirã yaharãpʉ Goãmʉ mera ʉmʉri nʉcʉ árĩrãcoma. Eropirã erãre buhemʉhtanirã, pʉhrʉ yaharã árĩcʉ̃ iirã sã yujuropa mucubirima. ");
INSERT INTO des_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Yujugʉ otemʉhtagʉ ãhrimi. Gajigʉpʉ dʉcare aĩgʉ ãhrimi,” arĩmʉriñorã iribojeguere. Iri diaye ta ãhraa. Erã eropa arĩdiro dopa ta yujurãyeri yahare weremʉhtarã ãhrima. Gajirã yahare buhe yaharã árĩcʉ̃ iirã ãhrima. ");
INSERT INTO des_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Pohe opʉ ĩgʉre mohmerã erã otebirinirã árĩquerecʉ̃ ta erãre dʉcare aĩdoregʉ obeomi. Eropa ta masare buhemʉhtabirinirã mʉa árĩquerecʉ̃ ta erã yʉre umupeocʉ̃ iidoremorãre obeoa mʉare. Gajirãpʉ erãre buhemʉtatuhama. Erã buhenirãguere dipaturi buhenemorã, yaharã árĩcʉ̃ iirãca mʉapʉ. Eropirã buhemʉhtarãpʉ erã itamuro mera gajirãre yaharã árĩcʉ̃ iirãca, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Irisubure Samaria majago, “Yʉ iira mʉrare ĩgʉ werepehoami,” igo arĩcʉ̃ peerã Samaria majarã bajarã Jesure umupeoma. ");
INSERT INTO des_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eropirã Samaria majarã Jesu pohro ejarã, “Gʉa mera dujanique,” arĩma ĩgʉre. Erã eroparĩcʉ̃ gʉa penʉ ĩgʉ mera ero dujanibʉ. ");
INSERT INTO des_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gajirã sã bajarã Jesure peerã umupeoma. ");
INSERT INTO des_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Õpa arĩma masa nomeore: —Nere mʉ arĩrare peerã Jesure umupeonʉgarabʉ. Dohpague tamerare ĩgʉ wereniguirire gʉa basi peerã ĩgʉre õaro umupeoa. Eropirã ĩgʉpʉre peerã i yeba majarãre peamegue wabonirãre taubu diaye ta ĩgʉ árĩcʉ̃, dohpague gʉa masia, arĩma masa Samaria majagore. ");
INSERT INTO des_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Penʉ pʉhrʉ Jesu gʉare Galileague sihu wami daja. ");
INSERT INTO des_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Neguere õpa arĩmʉrimi gʉare Jesu: “Goãmʉ ya weremʉhtagʉre ĩgʉ ya yeba majarã ĩgʉre umupeobeama,” arĩmʉrimi Jesu. ");
INSERT INTO des_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Eropirã gʉa Galileague ĩgʉ mera ejacʉ̃ ero majarã ĩgʉre õaro bocatĩrima. Ero core Jerusaléngue bosenʉ árĩcʉ̃ Jesu ĩgʉ iirare ĩanirã árĩma erã. ");
INSERT INTO des_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Eropi Caná Galilea árĩri macague ĩgʉ decore vino wacʉ̃ ĩgʉ iira macague waha wabʉ gʉa ĩgʉ mera daja. Caná pohro árĩri maca Capernaum waĩcʉri maca opʉ magʉ dorecʉgʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Eropigʉ Jesu Judea árĩdigʉ ĩgʉ Galileague ejari querere peepʉ. Irire peegʉ Jesu pohrogue erami. —Yʉ magʉ sĩrigʉ iiami. Eropigʉ ĩgʉre õagʉ wacʉ̃ iigʉ arique, arĩ yojaro mera sihumi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu yʉhrimi: —Goãmʉ turari mera yʉ deyoro moarire ĩabirã, ne yʉre umupeobeaa mʉa, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ĩgʉ eroparĩcʉ̃ peegʉ opʉpʉ õpa arĩmi: —Opʉ, yʉ magʉ ĩgʉ sĩriboro core arique, arĩmi ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Dujaaque. Mʉ magʉ ojocarigʉcumi, arĩmi Jesu. Ĩgʉ eroparĩcʉ̃ peegʉ, “Ĩgʉ arĩdiro dopa ta ojocarigʉcumi yʉ magʉ,” arĩgʉ opʉ dujaa wami. ");
INSERT INTO des_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Eropa dujaniguigʉre ĩgʉ pohro majarã ĩgʉre bocatĩri wereñorã. —Mʉ magʉ masa wahámi, arĩ wereñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Noho gohra abe árĩcʉ̃ õagʉ wahári ĩgʉ? arĩ serẽpipʉ ĩgʉ pohro majarãre. —Cãrʉre goeri boje pʉhrʉgã ta nimacʉri tahriabʉ ĩgʉre, arĩñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Erã eroparĩcʉ̃ õpa arĩ pepipʉ ĩgʉ: “Jesu yʉre ‘Mʉ magʉ masa wahámi,’ arĩ werera pʉhrʉ ta nimacʉri tahria waya,” arĩ pepipʉ opʉpʉ. “Diaye ta arãñumi yʉre,” arĩgʉ, ĩgʉ árĩpehrerã ĩgʉ acawererã mera Jesure umupeoñorã. ");
INSERT INTO des_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesu Judea árĩdigʉ Galileague ĩgʉ ejara pʉhrʉ opʉ magʉre ĩgʉ õagʉ wacʉ̃ ĩgʉ iira mera mari queocʉ̃ pesubu Goãmʉ ĩgʉ turari mera ii ĩhmúmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pʉhrʉ judio masa Goãmʉre gʉa umupeori bosenʉ árĩcʉ̃ gʉa Jesu mera Jerusaléngue ejabʉ daja. ");
INSERT INTO des_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ero maca ñajari disiporo oveja waĩcʉri disiporo pohro guhari gobe árĩbʉ. Gʉa judio masa ya mera Betesda waĩcʉri gobe árĩbʉ. Iri deco gobe pohro cinco gohra tiaya mariri tari dipabu árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Iri tari dipabugue bajarã dorecʉrã oyarãre ĩabʉ. Cuiri ĩhajabirã, curimasibirã, gõari marirã, erã iri gobe pohro oyama. Deco ñohmeborore corerã iiñorã. ");
INSERT INTO des_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Erogue dijarigʉ iri gobe maja decore yujuyerisuburi ñohmecʉ̃ iipʉ anyu. Iri gobe maja deco ĩgʉ ñohmera pʉhrʉ ñaja guhamʉhtagʉpʉ õagʉ wapʉ. Dohpa árĩri dorere opagʉ õagʉ wapʉ. ");
INSERT INTO des_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Eropigʉ ero yujugʉ dorecʉgʉ oyami. Ĩgʉ treinta y ocho bojori gohra dorecʉgʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ero ĩgʉ oyacʉ̃ ĩagʉ ĩgʉ eropa yoari boje ĩgʉ dorecʉcʉ̃ masimi Jesu ĩgʉre. Eropa masigʉ ĩgʉre serẽpimi: —¿Õari dʉpʉ dore marigʉ árĩdiari mʉhʉ? arĩmi Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ĩgʉ eroparĩcʉ̃ dorecʉgʉpʉ yʉhrimi: —Iri deco ñohmecʉ̃ yʉre decogue aĩ acugʉ marimi. Iri decogue yʉ ñajadiaquerecʉ̃ ta gajirãpʉ yʉ core yuu ñajamʉhtama, arĩmi ĩgʉ Jesure. ");
INSERT INTO des_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Wahgãnʉgajaque. Mʉ omasiariñere aĩ, mʉ guburi mera cʉhrapi wahgã waque, arĩmi Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ĩgʉ eroparĩcʉ̃ ta dorecʉgʉpʉ wahgãnʉgaja ĩgʉ omasiariñere aĩ waha wami. Irinʉ Sabado gʉa judio masa soorinʉ árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ĩgʉ eropa õagʉ wadigʉ ĩgʉ omasiariñere aĩgãcʉ̃ ĩarã judio masa gʉa oparãpʉ dorecʉdigʉre õpa arĩ wereñorã: —Dohpagãre Sabadonʉ mari soorinʉ árĩquerecʉ̃ mʉ yañe omasiariñere aĩ wahgãa mʉhʉ. Eropa iigʉ mari dorerire tarinʉgagʉ iiaa, arĩñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Yʉre yʉ dorecʉrire taudigʉpʉ õpa arãmi yʉre, arĩpʉ dorecʉdigʉpʉ. “Mʉ omasiariñere aĩ, mʉ guburi mera cʉhrapi wahgãque,” arãmi yʉre, arĩ yʉhripʉ dorecʉdigʉ mʉrʉpʉ erãre judio masa oparãre. ");
INSERT INTO des_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Irire mʉre eropa arĩdigʉpʉ nihino ãhriri ĩgʉ? arĩ serẽpiñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ero bajarã masa erã árĩcʉ̃ ĩagʉ Jesupʉ waha wadigʉ árĩmi. Eropigʉ dorecʉdigʉpʉ ĩgʉre õagʉ wacʉ̃ iidigʉ ĩgʉ waĩre masibiripʉ. ");
INSERT INTO des_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pʉhrʉ Goãmʉ wihigue gʉa ĩgʉre bocatĩricʉ̃ Jesu ĩgʉre weremi: —Peenique mʉhʉ yʉre. Dohpaguere õaro dʉpʉcʉa mʉhʉ. Ñerire iinemobiricãque. Dipaturi iinemogʉ mʉ dorecʉdiro tauro wagʉca, arĩmi Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ĩgʉ eropa arĩra pʉhrʉ dorecʉdigʉ judio masa oparã ĩgʉre serẽpinirã pohrogue eja, werepʉ erãre: —Jesu waĩcʉgʉ yʉre õagʉ wacʉ̃ iiami, arĩ werepʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Eropi Sabado árĩcʉ̃ Jesu dorecʉgʉre ĩgʉ dorere ĩgʉ taucʉ̃ masirã judio masapʉ ĩgʉre ñero iinʉgañorã. Eropirã erã ĩgʉre wejẽdiariñorã. ");
INSERT INTO des_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Eropa ñero erã iidiarire masigʉ Jesupʉ weremi erãre: —Yʉ Pagʉ dohpaguere mohmenimi. Yʉ sã eropigʉ mohmenigʉ iiaa, arĩ weremi ĩgʉre ñero iidiarãre. ");
INSERT INTO des_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ĩgʉ eroparĩcʉ̃ judio masa gʉa oparã ĩgʉ mera turaro guarã, ero core erã arĩdiro tauro ĩgʉre wejẽdiañorã. Sabadonʉre erã soorinʉre ĩgʉre õagʉ iicʉ̃ ĩarã erã guañorã. Eropa guarã Goãmʉre ĩgʉ “yʉ Pagʉ,” ĩgʉ arĩcʉ̃ peerã erãpʉ tauro guañorã. “‘Yʉ Pagʉ,’ arĩgʉ Jesu ĩgʉ basi ‘Goãmʉ mera yujuro mera ãhraa,’ arĩ guñacumi ĩgʉ,” arĩ pepiñorã judio masa gʉa oparã. ");
INSERT INTO des_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Eropi Jesu erãre weremi: —Diaye mʉare arĩgʉ iiaa. Yʉhʉ Goãmʉ magʉ yʉ gamero iigʉ iibeaa. Yʉ Pagʉ ĩgʉ iirare ĩagʉ irire iiaa. ");
INSERT INTO des_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉ Pagʉ yʉre ĩgʉ magʉre mahimi. Eropigʉ ĩgʉ iirare yʉre ii ĩhmupehomi. I dohpaguere ĩgʉ turari mera yʉ iira tauro ĩgʉ gajire iidoregʉcumi yʉre. Ĩgʉ eropa iidorecʉ̃ ĩgʉ turari mera ii ĩhmugʉca ĩgʉre yʉhʉ. Eropa yʉ ii ĩhmucʉ̃ ĩha ʉcarãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yʉ Pagʉ sĩrinirãre ĩgʉ masuro dopa ta yʉ sã yʉ gamerãre masugʉra. ");
INSERT INTO des_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ne yʉ Pagʉpʉ masa erã ñeri iira dipuwaja, ĩgʉ basi dipuwaja moagʉ moabeami. Yʉpʉre irire erã ñeri iira dipuwaja dipuwaja moabure apimi. Erã ĩgʉre umupeodiro dopa ta yʉ sãre umupeoborore eropa apimi. Eropirã yʉre ĩgʉ magʉre umupeobirã yʉ Pagʉ sãre umupeobeaa mʉa. Ĩgʉ ãhrimi yʉre obeodigʉ, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Eropa arĩtuha õpa arĩ werenemomi: —Diaye mʉare arĩgʉ iiaa. Yʉ wereniguirire peerã yʉre obeodigʉre umupeorã ʉmʉri nʉcʉ ʉmarogue eropa árĩniguicãrãcoma. Eropigʉ erãre dipuwaja moasome yʉhʉ. Eropirã erã peamegue wabonirã tarirãcoma. ");
INSERT INTO des_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Diaye ta mʉare arĩgʉ iiaa. Peamegue wamorã yʉre Goãmʉ magʉre erã peeburisubu dohpague ãhraa. Pʉhrʉ sãre erã yʉre peerãcoma daja. Eropa peerã peenʉrʉrãpʉ Goãmʉ mera eropa árĩniguirãcoma. ");
INSERT INTO des_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Goãmʉ yʉ Pagʉpʉ erãre eropa árĩniguicʉ̃ iigʉ ãhrimi. Eropigʉ yʉre ĩgʉ magʉre erãre eropa árĩniguicʉ̃ iibure árĩdoremi ĩgʉ yʉre. ");
INSERT INTO des_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Eropigʉ yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ árĩcʉ̃ ĩgʉ masare dipuwaja moadorerire apimi yʉre. ");
INSERT INTO des_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ire peerã, pee ʉcabiricãque mʉa. Gajinʉguere árĩpehrerã sĩrinirã masa goberigue árĩrã yʉ wereniguicʉ̃ peerãcoma. ");
INSERT INTO des_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Eropa pee wahgãrã õarire iinirã mʉra ʉmʉri nʉcʉ Goãmʉ mera árĩmorã masa mʉriarãcoma. Ñeri iinirã mʉrapʉ ñerire erã iira dipuwaja peamegue warãcoma, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Eropa arĩtuha õpa arĩ werenemomi: —Yʉ gamero ne gajinore iibeaa. Ne yʉ basi yʉ gamero iibeaa. Yʉre obeodigʉ ĩgʉ gamero dopa ta iiaa. Eropigʉ ĩgʉ arĩdiro dopa ta dipuwaja moaa. Eropigʉ masare yʉhʉ dipuwaja moagʉ diaye ta iiaa. ");
INSERT INTO des_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Yʉhʉ Goãmʉ magʉ ĩgʉ obeodigʉ ãhraa,” yʉ basi arĩ werecʉ̃, “Mʉ wereniguiri ne diaye árĩbeaa,” arĩboca mʉa. ");
INSERT INTO des_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Gajigʉ ãhrimi yʉre weregʉ. Ĩgʉ Goãmʉ ãhrimi. Ĩgʉ yʉre werera diaye ta ãhraa. Irire yʉ õaro masia. ");
INSERT INTO des_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mʉa gajirãpʉre Ñure yʉre serẽpidore obeobʉ. Eropigʉ ĩgʉ sã diaye ta weremi mʉare. ");
INSERT INTO des_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Masare yʉre “Goãmʉ ĩgʉ obeodigʉ ãhrimi,” arĩ weremorãre amabeaa yʉpʉ. Eropa amabiriqueregʉ ta Ñu masʉ ĩgʉ árĩquerecʉ̃ ta “Yʉre diaye ta weremi,” arãa. Mʉa yʉre umupeoburire, mʉa peamegue wabonirã mʉa tariburire yʉre ĩgʉ werera “Diaye ta ãhraa,” arĩ weregʉ iiaa. ");
INSERT INTO des_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ñu mʉare buhemʉhtagʉ bajamenʉrigã buhemi mʉare. Ĩgʉ eropa buhecʉ̃ peerã bajamenʉrigã mucubiriribʉ mʉa. ");
INSERT INTO des_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ñu yʉ árĩricʉrire weremi mʉare. Ĩgʉ wereri mera yʉ árĩricʉrire masiquererã yʉ iirire ĩarã tauro masirãca. Goãmʉ yʉ Pagʉ ĩgʉ turari mera ĩgʉ yʉre iidorerare dohpague iigʉ iiaa. Ire yʉ iicʉ̃ ĩarã diaye ta Goãmʉ ĩgʉ obeodigʉ yʉ árĩcʉ̃ masirãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Eropiro yʉ Pagʉ yʉre obeodigʉ ĩgʉ basi yʉhʉ ĩgʉ obeodigʉ árĩrire arĩ weremi mʉare ĩgʉ yare erã gojarapũgue. Ĩgʉ eropa arĩ werequerecʉ̃ ta ĩgʉ wereniguirire ne peebeaa mʉa. Eropi mʉa ĩgʉre ne ĩabeaa. ");
INSERT INTO des_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yʉre Goãmʉ ĩgʉ obeodigʉre mʉa ne peediabeaa. Eropirã mʉa ne Goãmʉ yare gamebeaa. ");
INSERT INTO des_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Goãmʉ yare erã gojarapũre mʉa õaro buhea. Eropa buherã “Gʉa ipũre buherã ʉmʉri nʉcʉ Goãmʉ mera eropa árĩniguirãca,” arãa mʉa. Iripũ ta yʉre werea. ");
INSERT INTO des_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Iripũ yʉre werequerecʉ̃ ta mʉapʉ yʉre gamebeaa. Ʉmʉri nʉcʉ Goãmʉ mera mʉa árĩniguiburire yʉhʉ ogʉ árĩquerecʉ̃ yʉre gamebiribʉ mʉa, arĩ weremi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Eropa arĩtuha õpa arĩnemomi: —Yʉre masa erã umupeorire amabeaa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Eropa amabiriqueregʉ ta Goãmʉre mʉa mahibiricʉ̃ masia yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Goãmʉ yʉ Pagʉ ĩgʉ dorero dopa ta yʉ ariquerecʉ̃ ta mʉa yʉre gamebeaa. Gajigʉpʉre Goãmʉ ĩgʉ obeobiridigʉ ĩgʉ árĩquerecʉ̃ ta ĩgʉpʉre gamerãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gajirã masa mʉare erã umupeocʉ̃ gahmea mʉa. Goãmʉ mʉa mera ĩgʉ mucubiririre gamebeaa mʉa. Ĩgʉ dihta Goãmʉ gohra ãhrimi. Eropa gamebirã yʉre peebeaa mʉa. Yʉre umupeobeaa mʉa. ");
INSERT INTO des_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mʉare yʉ Pagʉguere ne weresãsome yʉhʉ. Irire pee masique mʉa. Moise ĩgʉ gojarapũpʉ mʉare weresãroca. “Iripũ maja dorerire iipehorã, Goãmʉ pohro warãca mʉa,” arĩripũpʉ mʉare weresãroca. ");
INSERT INTO des_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moise ĩgʉ gojarapũ yʉpʉre weremʉhtayoro. Eropirã iripũre õaro umupeorã yʉ sãre umupeoboaya mʉa. ");
INSERT INTO des_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moise ĩgʉ gojarapũre mʉa õaro peebirã, yaha wereniguiri sãre peesome mʉa, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eropa ĩgʉ buhera pʉhrʉ Galilea waĩcʉri ditaru gajipʉ masegue gʉa Jesu mera taribuja wabʉ. Galilea ditaru ta Tiberia waĩcʉbʉ. ");
INSERT INTO des_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ero core Galilea yeba Jesu dorecʉrãre ĩgʉ õarã ĩgʉ iicʉ̃ masa ĩanirã árĩma. Erã eropa ĩanirã árĩrã Jesu ĩgʉ taribujacʉ̃ ĩarã masa bajarã ĩgʉre nʉrʉsia taribujama. ");
INSERT INTO des_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Erogue eja, gʉa ĩgʉ buherã ĩgʉ mera ʉtãgʉgue mʉria, doabʉ. ");
INSERT INTO des_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Irinʉ Pascua waĩcʉri bosenʉ árĩboro judio masa bosenʉ árĩboro merogã dʉhyabʉ. ");
INSERT INTO des_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Erogue doagʉ, Jesu masa bajarã ĩgʉ pohro erã aricʉ̃ ĩhabeomi. Eropa ĩhabeogʉ Felipere serẽpimi Jesu: —¿Oã masa erã baburire nohogue asũrãcuri mari? arĩ serẽpimi. ");
INSERT INTO des_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesu ĩgʉ basi ĩgʉ iiburire masiqueregʉ ta Felipere serẽpi ĩami, “¿Dohpa yʉhrigʉcuri?” arĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ĩgʉ eropa serẽpicʉ̃ Felipepʉ yʉhrimi: —Doscientos niyerupũri waja mera mari asũquerecʉ̃ ta, masare yujurãyerire mʉtarigã barire mari guerequerecʉ̃ ta ne sihajasome, arĩmi Felipe Jesure. ");
INSERT INTO des_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gʉa mera majagʉ Andrepʉ Simo Pedro pagʉ magʉpʉ Jesure weremi. ");
INSERT INTO des_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Cinco pan dipuru, perã wai ihĩ majigʉ ohõ opami. Iri pan dipurugã ĩgʉ opaquerecʉ̃ ta masapʉ bajarã gohra ãhrima. Eropiro i merogã bari ne sihajasome, arĩmi Andre. ");
INSERT INTO des_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Masare doadoreque mʉa, arĩmi Jesu gʉare ĩgʉ buherãre. Ero mʉtarigã taacʉro árĩbʉ. Gʉa doadorecʉ̃ masa árĩpehrerã doajapehrea wama taa weca. Ʉma dihtare queocʉ̃ cinco mil gohra árĩma. ");
INSERT INTO des_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Erã eropa doajacʉ̃ ĩagʉ Jesupʉ panre aĩ Goãmʉre “Õhaa,” arĩmi. Eropa arĩtuha gʉare ĩgʉ buherãre gueredoremi. Ĩgʉ eropa gueredorecʉ̃ gʉapʉ erã doarãre guere wahgãbʉ. Perã wai sãre aĩ guere wahgãbʉ. Árĩpehrerãre erã sihajaro barire guerebʉ. ");
INSERT INTO des_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Eropirã masa erã yapicʉ̃ ĩagʉ Jesu gʉare doremi: —Erã ba dʉharire aĩque. Eropirã iri barire ne dedeosome, arĩmi. ");
INSERT INTO des_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ĩgʉ eroparĩcʉ̃ gʉapʉ cinco pan dipuru dʉhyarare gʉa gameneocʉ̃ doce puiri gohra wiribʉ. ");
INSERT INTO des_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eropirã masa Jesu Goãmʉ turari mera iri deyoro moariñere ĩgʉ iicʉ̃ ĩarã õpa arĩma: —Diaye ta ãhraa. Ihĩ Goãmʉ ya wereniguigʉ i yebague aridigʉ mari coredigʉ ta ãhrimi, arĩma erã. ");
INSERT INTO des_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eropirã erã Jesure erã opʉ árĩbure acudiarima. Jesu irire masigʉ dipaturi yujugʉ ta ʉtãgʉgue waha wami. ");
INSERT INTO des_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ñamicague gʉa ĩgʉ buherã dihta ditarugue buhabʉ. ");
INSERT INTO des_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Eroguere buhaja dohodirugue ñaja, Capernaum waĩcʉri macague taribujabʉ. Gʉa eropa taribujacʉ̃ ñamigue árĩbʉ. Eropigʉ Jesu gʉa pohrogue arinibirimi dohpa. ");
INSERT INTO des_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Miruñe turaro aricʉ̃ gʉa taribujariyaguere pãgúri wahgãbʉ. ");
INSERT INTO des_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cinco kilómetros gohra gʉa taribujara pʉhrʉ Jesu gʉa pohrogue árimi. Deco weca nigui wahgãricʉ̃ ĩabʉ gʉa ĩgʉre. Eropa gʉa pohro ĩgʉ aricʉ̃ ĩarã gʉa güibʉ. ");
INSERT INTO des_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Gʉa güicʉ̃ ĩagʉ ĩgʉ gʉare weremi: —Ne yʉre ĩha ʉcabiricãque. Guñaturarã árĩque. Yʉhʉ ta ãhraa, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ĩgʉ eroparĩcʉ̃ peerã gʉa ĩgʉre mucubiriri mera bocatĩri ñajadorebʉ. Ĩgʉ ñajara pʉhrʉgã gʉa wara yebaguere taribujajabʉ. ");
INSERT INTO des_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Gajinʉ masa ero dujanirãpʉ gamenerenʉgañorã daja Jesure corerã. Iri ñamire gʉa yaru mera gʉa dihta taribujacʉ̃ ĩanirã árĩma erã. Jesu gʉa mera ĩgʉ wabiricʉ̃ sãre ĩanirã árĩma erã. Eropa gamenererã Jesure bocabiriñorã. Bocabiri ero pohro Tiberiague ariri gasi tuhajacʉ̃ ĩañorã. Jesu Goãmʉre “Õhaa,” arĩ, masare ĩgʉ bari guerediro pohroñarigue árĩyoro. Eropirã Jesu gʉa sã maricʉ̃ ĩarã, iri gasigue ñaja, Capernaumgue gʉare nʉrʉsia taribujajama. Jesure ahma nʉrʉsiagãrã iima erã. ");
INSERT INTO des_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ditarure taribuja, gʉa árĩrogue eja, Jesure bocajanijarã erã serẽpima ĩgʉre: —Buhegʉ, ¿dohpárĩcʉ̃ ahrari mʉhʉ õguere? arĩ serẽpima erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Erã eropa arĩ serẽpicʉ̃, Jesu erãre weremi: —Diaye arĩgʉ iiaa mʉare. Deyoro moarire yʉ iiquerecʉ̃ ta yʉpʉre umupeobeaa mʉa. Yʉre umupeobiriquererã ta yʉre ahmaa mʉa. Yʉ mera pagari baha, mʉa yapinirã árĩrã yʉre amagãrirã iiaya daja. ");
INSERT INTO des_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bari ne árĩniguibeaa. Pʉhrʉ pehrea wahaa iri. Eropirã irire eropa amaniguibiricãque. Gaji bari gajiropa árĩri baripʉre amaque mʉa. Iri barire amarã ʉmʉri nʉcʉ Goãmʉ mera árĩrãca. Eropiro iri bari tamera ne pehrebeaa. Iri barire yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ mʉare ogʉra. Goãmʉ yʉ Pagʉ yʉre irire odoregʉ ãhrimi. Ĩgʉ obeodigʉ yʉ árĩrire ĩhmutuhami mʉare, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ĩgʉ eroparĩcʉ̃ erã serẽpima ĩgʉre: —¿Goãmʉ iidorerire iimorã dohpa iirãcuri gʉa? arĩ serẽpima erã. ");
INSERT INTO des_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Ire Goãmʉ mʉare iidoremi: “Yʉre ĩgʉ obeodigʉre umupeoque,” arĩ doremi Goãmʉ, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ĩgʉ eroparĩcʉ̃ peerã erã õpa arĩma: —Goãmʉ ĩgʉ obeodigʉ mʉ árĩgʉ ĩgʉ turari mera ii ĩhmuque gʉare mʉre gʉa õaro umupeoborore. ¿Ñehenore iibocuri mʉhʉ? ");
INSERT INTO des_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mari ñecʉ sʉmarã mʉrague iribojegue majarã masa marirogue mana waĩcʉri dipurure bamʉriñorã. Goãmʉ yare erã gojaripũgue õpa arĩ wereyoro: “Ĩgʉ erãre ʉmaro maja dijuri barire omʉripʉ erã baburire,” arĩ gojañuma Goãmʉ yare erã gojarapũgue. ¿Ĩgʉ eropa iidiro dopa ta iigʉ iiri mʉ sã? arĩma erã. ");
INSERT INTO des_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Erã eroparĩcʉ̃ Jesu weremi erãre: —Diaye mʉare arĩgʉ iiaa. Moisepʉ iri ʉmaro maja barire mʉa acawererãre obiriñumi. Yʉ Pagʉpʉ ʉmaro maja barire diaye maja barire mʉare ogʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Goãmʉ ĩgʉ bari ʉmaro dijari árĩpehreri yeba majarãre ojocaririre omasia, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Opʉ, ʉmʉri nʉcʉ iri barire oque gʉare, arĩma erã. ");
INSERT INTO des_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Erã eroparĩcʉ̃ peegʉ Jesu weremi erãre: —Yʉpʉ ojocaririre ogʉ bari iro dopa árĩgʉ ãhraa. Mari ya barire barã matagã ta oaboa wahaa mari. Ihriri sãre mari ihrira pʉhrʉgã ta ñemesibua daja. Yʉre gamegʉpʉ, yʉre umupeogʉpʉ, ne oaboabigʉ ñemesibubigʉ iro dopa ĩgʉ õaro árĩri ne pehresome ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mʉapʉ yʉre ĩaquererã ta umupeonibeaa dohpa. Irire ta mʉare wererabʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Árĩpehrerã yʉ Pagʉ yarã árĩmorãre ĩgʉ aĩnirãpʉ yʉre gamerãcoma. Eropigʉ yʉre gamerãre ne cóãsome yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ʉmarogue arigʉ yʉ gamero iigʉ arigʉ iibiribʉ. Yʉre obeodigʉ ĩgʉ gamero dopa ta iigʉ aribʉ. ");
INSERT INTO des_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ita árĩbʉ yʉre obeodigʉ ĩgʉ gameri gohra: Árĩpehrerã yaharã árĩmorã yʉre ĩgʉ onirãre yʉ dedeobiricʉ̃ gahmemi. Yʉre obeodigʉ pehrerinʉ árĩcʉ̃ erãre yʉ masucʉ̃ gahmemi. ");
INSERT INTO des_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Árĩpehrerã yʉre Goãmʉ magʉre ĩarã, yʉre umupeorã ʉmʉri nʉcʉ ĩgʉ mera erã árĩcʉ̃ gahmemi yʉ Pagʉ. Eropigʉ pehrerinʉ árĩcʉ̃ erãre masugʉra, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Yʉhʉ ʉmarogue ariri bari iro dopa árĩgʉ ãhraa,” ĩgʉ arĩcʉ̃ peerã judio masa gʉa oparãpʉ ĩgʉ mera guarã, erã basi Jesure ñero arĩ wereniguima. ");
INSERT INTO des_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—¿Ihĩ Jesu José magʉ árĩbeari? Ĩgʉ pagʉ, ĩgʉ pago sãre mari masia. ¿Eropa árĩqueregʉ ta duhpigʉ “Ʉmarogue aribʉ,” arĩ wereniguiri ĩgʉ? arĩ guama erã. ");
INSERT INTO des_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Erã eroparĩcʉ̃ peegʉ Jesu weremi erãre: —Mʉa basi yʉre ñero arĩ wereniguibiricãque. ");
INSERT INTO des_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yʉ Pagʉ yʉre obeodigʉpʉ masare yʉre gamecʉ̃ iimi. Ĩgʉ eropiibiricʉ̃ masapʉ yaharã árĩmasibiriboñuma. Pehrerinʉ árĩcʉ̃ yaharãre masugʉca yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Goãmʉ ya weremʉhtanirãpʉ õpa arĩ gojañuma: “Goãmʉ erãre buhegʉcumi,” arĩ gojañuma. Árĩpehrerã yʉ Pagʉ ĩgʉ buherire peerã ĩgʉre yʉhrirã yʉre gahmema. Eropirã yaharã ãhrima. ");
INSERT INTO des_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Yʉ Pagʉre ne yujugʉ masʉ ĩabeami. Yʉhʉ Goãmʉ ĩgʉ obeodigʉ dihta yʉ Pagʉre ĩabʉ. ");
INSERT INTO des_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Diaye arĩgʉ iiaa mʉare. Yʉre umupeogʉ árĩpehrerinʉri yʉ Pagʉ mera árĩniguigʉcumi. ");
INSERT INTO des_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉpʉ ojocaririre ogʉ bari iro dopa árĩgʉ ãhraa. ");
INSERT INTO des_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉa ñecʉ sʉmarã mʉrague masa marirogue manare bamʉriñorã. Eropa irire baquererã ta sĩria wañorã. ");
INSERT INTO des_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ʉmarogue ariri baripʉre masʉ bagʉ ne sĩrisome. ");
INSERT INTO des_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉhʉ ʉmarogue ariri bari ojocaririre ori bari iro dopa árĩgʉ ãhraa. I barire bagʉ ʉmʉri nʉcʉ yʉ Pagʉ mera eropa árĩniguigʉcumi. I bari ojocaririre ori bari iro dopa árĩri yʉ dʉpʉ ta ãhraa. Árĩpehreri yeba majarã Goãmʉ mera eropa erã árĩniguiburire yʉ dʉpʉre ogʉra. Eropa ogʉ sĩrigʉca, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ĩgʉ eroparĩcʉ̃ peerã judio masapʉ õpa arĩ wereniguima erã basi: —¿Ihĩ dohpa ii ĩgʉ dʉpʉre baburi ogʉcuri? arĩma erã erã basi. ");
INSERT INTO des_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Erã eroparĩcʉ̃ peegʉ Jesu weremi: —Diaye arĩgʉ iiaa mʉare. Yʉhʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. Yʉ dʉpʉre babigʉ, yʉ dire ihribigʉ Goãmʉ mera árĩsome. ");
INSERT INTO des_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yʉ dʉpʉre bagʉre, yʉ dire ihrigʉre, pehrerinʉ árĩcʉ̃ masugʉra. ");
INSERT INTO des_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yʉ dʉpʉ diaye ta bari gohra iro dopa ãhraa. Yʉ di diaye ta ihriri gohra iro dopa ãhraa. ");
INSERT INTO des_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yʉ dʉpʉre bagʉ yʉ dire ihrigʉ yʉ mera mucubiriri mera árĩniguigʉcumi. Eropigʉ yʉhʉ ĩgʉ mera mucubiriri mera árĩniguigʉca. ");
INSERT INTO des_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉ Pagʉ yʉre obeodigʉ eropa árĩniguicãmi. Eropa árĩniguigʉ yʉ sãre eropa árĩniguicʉ̃ iimi. Eropirã yʉre eropa árĩniguigʉre masa barã, Goãmʉ mera ʉmaroguere eropa árĩniguirãcoma erã sã. ");
INSERT INTO des_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ita ãhraa ʉmarogue ariri bari. Mari ñecʉ sʉmarã mʉra erã bara mʉra iro dopa árĩbeaa i bari. Erãpʉ iri barire baquererã ta sĩria wañorã. I baripʉre bagʉ ʉmaroguere eropa árĩniguicãgʉcumi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaum judio masa gʉa buheri wihi Jesu buhegʉ, eropa weremi. ");
INSERT INTO des_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ĩgʉ eropa wereniguicʉ̃ peerã bajarã gʉa watope árĩrã Jesure gamerã, ĩgʉre nʉrʉsianirã õpa arĩ wereniguima: —I buheri diasa ãhraa. Eropirã mari peediabiriñaria, arĩ wereniguima erã erã basi. ");
INSERT INTO des_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Erã eroparĩcʉ̃ Jesupʉ erã wereniguirire masimi. Eropa masigʉ ĩgʉ erãre serẽpimi: —¿I buherire peerã guari mʉa? ");
INSERT INTO des_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ʉmarogue dujaa wacʉ̃ dohpa wabocuri mʉa? ");
INSERT INTO des_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Masʉ ĩgʉ sĩporãre opagʉ ojocarimi. Ĩgʉ dʉpʉpʉ ĩgʉre ojocaricʉ̃ iibeaa. Masʉre ĩgʉre ĩgʉ sĩporã ojocaricʉ̃ iro dopa ta yʉ buheripʉ mʉare Goãmʉ mera eropa árĩniguicʉ̃ iiaa. ");
INSERT INTO des_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Gajirã mʉa mera majarã ne yʉre umupeobeama, arĩmi Jesu. Negohraguere Jesu ĩgʉre umupeobiribonirãre masi­tuhajapʉ. Ĩgʉre ĩhaturirãre wiabu sãre mata masituhapʉ. Eropa masigʉ “Gajirã mʉa mera majarã yʉre umupeobeama,” arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eropa arĩtuhaja õpa werenemomi: —Õpa arĩ wererabʉ mʉare. “Yʉ Pagʉpʉ masare yʉre gamecʉ̃ iimi. Ĩgʉ eropa iibiricʉ̃ masapʉ yaharã árĩmasibiriboñuma,” mʉare arĩrabʉ, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ĩgʉ eropa arĩ buhecʉ̃ peerã bajarã Jesure gamenirã mʉra ĩgʉre cohã, ĩgʉ mera dipaturi wabirima. ");
INSERT INTO des_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Erã eropa iicʉ̃ ĩagʉ Jesu gʉare doce ĩgʉ buherãre serẽpimi: —¿Mʉa sã yʉre cóãcãrãcuri? arĩ serẽpimi gʉare. ");
INSERT INTO des_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ĩgʉ eroparĩcʉ̃ Simo Pedro yʉhrimi ĩgʉre: —Opʉ, gʉare gajigʉ buhegʉ marimi. Mʉ buherire peerã Goãmʉ mera eropa árĩniguirãca gʉa. Mʉ buheri dihta irire werea gʉare. ");
INSERT INTO des_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Eropirã gʉa mʉre umupeoa. Eropa mʉhʉ õagʉ, Goãmʉ magʉ ĩgʉ obeodigʉ mʉ árĩcʉ̃ gʉa masia. Eropirã mʉre cóãsome gʉa, arĩmi Simo Pedro Jesure. ");
INSERT INTO des_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ĩgʉ eroparĩcʉ̃ peegʉ Jesu weremi gʉare: —Yʉpʉ mʉare doce majarãre beyebʉ. Yujugʉ mʉa mera majagʉ watĩ yagʉ árĩbu ãhrimi, arĩmi gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Eropa arĩgʉ Judare Simo Iscariote magʉre arĩgʉ iimi. Judapʉ doce gʉa mera majagʉ Jesure ĩhaturirãre wiabu árĩmi. ");
INSERT INTO des_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pʉhrʉ gʉa mera Jesu Galilea yeba curigʉ wami. Judea yeba majarã judio masa ĩgʉre wejẽdiañorã. Erã eropa wejẽdiacʉ̃ masigʉ ĩgʉ iri yebare wabirimi. ");
INSERT INTO des_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judio masa mʉta wirigã gʉa iiburinʉ bosenʉ merogã dʉhyabʉ. ");
INSERT INTO des_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Eropirã Jesu pagʉ porã ĩgʉre werema: —Judeague bosenʉre ĩagʉ waque. Ero mʉ yarãre deyoro moarire ii ĩhmugʉ waque mʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Masare deyoro moarire ii ĩhmudiagʉ mʉre dibubiricãro gahmea. Deyoro moarire iigʉ árĩgʉ árĩpehrerã erã ĩhuro iique, arĩma erã. ");
INSERT INTO des_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ĩgʉ pagʉ porã árĩquererã ta Jesure “Goãmʉ magʉ ãhrimi,” arĩbirima. Eropirã eropa arĩma erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Erã eropa arĩra pʉhrʉ Jesu weremi erãre: —Masa yʉre erã õaro masiburisubu dʉhyania dohpa. Mʉapʉ bosenʉre ĩadiarã waque. ");
INSERT INTO des_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ero majarã mʉare ĩhaturibeama. Yʉpʉre erã ñeri iirare yʉ werecʉ̃ yʉre ĩhaturima. ");
INSERT INTO des_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mʉa seyaro bosenʉ árĩcʉ̃ waque. Yʉpʉre yʉ waburisubu dʉhyania dohpa. Eropigʉ yʉpʉ bosenʉre ĩagʉ wanibeaa dohpa, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Eropa arĩgʉ ĩgʉ Galilea dujami. ");
INSERT INTO des_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bosenʉgue Jesu ĩgʉ pagʉ porã erã wara pʉhrʉ Jesu sã gʉa mera erã pʉhrʉ wami. Eropa wagʉ masa erã ĩabiririsubu wami. ");
INSERT INTO des_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bosenʉ árĩrã judio masa gʉa oparã ĩgʉre amañorã: —¿Nohogue árĩcuri ĩgʉ? arĩ serẽpiñorã. ");
INSERT INTO des_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eropirã masa bajarã Jesure werewʉañorã. Gajirã, “Ĩgʉ õagʉ ãhrimi,” arĩñorã. Gajirãpʉ, “Ĩgʉ ñegʉ ãhrimi. Masare gʉyagʉ ãhrimi,” arĩ werewʉañorã. ");
INSERT INTO des_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Eropa arĩquererã judio masa gʉa oparãre güirã, masa erã ĩabirogue Jesure werewʉañorã. ");
INSERT INTO des_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Gʉa erogue ejara pʉhrʉ bosenʉ deco Jesu Goãmʉ wihigue ñajaja buhemi. ");
INSERT INTO des_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ĩgʉ eropa buhecʉ̃ judio masa ʉca wa õpa arĩma: —¿Ihĩ buherogue buhebigʉ árĩqueregʉ ta duhpigʉ õaro masipehori ĩgʉ? arĩma erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Erã eroparĩcʉ̃ Jesu weremi erãre: —Yʉ buheri yaha wereniguiri árĩbeaa. Yʉre obeodigʉ ya wereniguiripʉ ãhraa i buheri. ");
INSERT INTO des_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Goãmʉ gamerire iidiarã yʉ buherire “Goãmʉ wereniguiri ta ãhraa,” arĩ masirãcoma. Yʉ buheri yaha wereniguiri dihta árĩbiricʉ̃ sãre masirãcoma. ");
INSERT INTO des_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yujugʉ ĩgʉ gamero ĩgʉ masiri mera buhegʉ árĩgʉ “Yʉ dihtare umupeoque,” arĩgʉ ãhrimi ĩgʉ. Yʉre obeodigʉpʉre mʉa umupeocʉ̃ gahmea yʉpʉ. Yʉ eroparĩcʉ̃ peerã, “Diaye ta wereniguimi ĩgʉ. Ne gʉyabeami,” arĩ masirãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Goãmʉ dorerire Moise mʉrʉpʉ apimʉriñumi mʉare. Ĩgʉ eropa apiquerecʉ̃ ta mʉa árĩpehrerã iri dorerire ne yʉhribeaa. ¿Duhpirã yʉre wejẽdiari mʉa? arĩmi Jesu judio masare. ");
INSERT INTO des_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Mʉ goroweregʉ ãhraa. Mʉre wejẽdiarã marima, arĩ yʉhrima erã Jesure. Erã eroparĩcʉ̃ Jesu yʉhrimi: ");
INSERT INTO des_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—Yʉhʉ soorinʉ yujusubu Goãmʉ ĩgʉ turari mera dorecʉgʉre ĩgʉ dorere yʉ cóãcʉ̃ mʉa ĩha ʉca wabʉ. ");
INSERT INTO des_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mari ñecʉ sʉmarã iribojegue majarãpʉ erã dʉpʉre merogã gasirogãre wiri aĩrã erã árĩdiro dopa ta Moise wiridoreñumi. Ĩgʉ eropa dorecʉ̃ majirãgãre ocho nʉri erã masa dehyoara pʉhrʉ soorinʉ árĩquerecʉ̃ ta erã dʉpʉre merogã erã gasirogãre wiri aĩmʉria mʉa. ");
INSERT INTO des_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mari soorinʉ árĩcʉ̃ majirãgãre erã dʉpʉre merogã gasirogãre wihria mʉa Moise doreri iimorã. ¿Mʉa sã soorinʉ irire iiquererã ta irinʉ dorecʉgʉre yʉ taucʉ̃ duhpirã yʉ mera guari mʉa? ");
INSERT INTO des_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yʉ iirare mʉa õaro masibiriboro core, yʉre ñero pepibiricãque. Mʉa õaro masira pʉhrʉ yʉre mʉa ñero pepicʉ̃ diaye ta árĩroca, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ĩgʉ eropa arĩ werera pʉhrʉ bajamerãgã Jerusalén majarã õpa arĩ wereniñorã: —¿Ihĩ mari oparã erã wejẽdiagʉ árĩbeari? ");
INSERT INTO des_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Eropigʉ ĩgʉre erã wejẽdiaquerecʉ̃ ta árĩpehrerã masare buhegʉ iimi ĩgʉ. Eropirã ĩgʉre wejẽdianirã árĩquererã ta eropa ĩacãma. Eropa ĩacãrã ĩgʉre “Ĩgʉ diaye ta Cristo Goãmʉ ĩgʉ obeodigʉ ãhrimi,” ¿arĩ pepibocuri oparãpʉ? Maripʉ masia. Cristo árĩbiribocumi. ");
INSERT INTO des_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ihĩ Jesu ĩgʉ aridirore gʉa masia. Cristopʉ ĩgʉ árĩcʉ̃ ĩgʉ aridirore masiya mara. Eropigʉ Cristo gohra árĩbeami Jesu, arĩ werewʉañorã erã Jerusalén majarã. ");
INSERT INTO des_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Erã eropa arĩrare masigʉ, Jesu õpa turaro bʉsʉro werenigui buhemi Goãmʉ wihi: —Yʉre õpa arĩ pepia mʉa: “Ĩgʉre masia gʉa. Eropirã ĩgʉ aridiro sãre masia,” arĩ pepiraa mʉa yʉre. Mʉa eropa arĩ pepiquererã ta yʉ gamero aribirabʉ. Yʉre obeodigʉ gohrare masibeaa mʉa. Yʉre obeodigʉ diaye árĩgʉ, diaye iigʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ĩgʉ ta yʉre obeomi. Eropigʉ ĩgʉ pohrogue aribʉ. Eropigʉ yʉhʉ ĩgʉre masia, arĩmi Jesu judio masare. ");
INSERT INTO des_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ĩgʉ eroparĩcʉ̃ peerã ĩgʉre ñeadiarima. Erã eropa ñeadiaquerecʉ̃ ta Jesu ĩgʉ ñero tariburisubu árĩbiriyoro dohpa. Eropirã erã ĩgʉre ñeamasibirima. ");
INSERT INTO des_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gajirã masapʉ bajarã ĩgʉre umupeoma. Õpa arĩma: —“Cristo bajasuburi Goãmʉ turari mera deyoro moarire ii ĩhmugʉcumi,” erã arĩ werediro dopa ta ihĩ Jesupʉ bajasuburi Goãmʉ turari mera ii ĩhmumi. Árĩpehrerã gajirã tauro Goãmʉ turari mera ii ĩhmumi ĩgʉ. Eropigʉ Cristo Goãmʉ ĩgʉ obeodigʉ ta ãhrimi Jesu, arĩma Jesure ne umupeonʉgarãpʉ. ");
INSERT INTO des_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Masa Jesure eropa arĩ wereniguicʉ̃ peerã pahia oparã, fariseo masa mera Jesure ñeadorerã obeoriñorã surarare. ");
INSERT INTO des_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Eropigʉ Jesu masare õpa arĩmi: —Bajamenʉrigã mʉa mera árĩnigʉca. Eropigʉ pʉhrʉñarigã yʉre obeodigʉ pohro wagʉca. ");
INSERT INTO des_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉ árĩborore mʉa wamasibeaa. Eropirã yʉre amaquererã ta ne bocasome mʉa, arĩmi Jesu masare. ");
INSERT INTO des_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ĩgʉ eroparĩcʉ̃ peerã erã judio masa õpa arĩ wereniguiñorã: —¿Ihĩ eropa arĩgʉ nohogue wagʉcuri mʉa pepicʉ̃? ¿Griego masa pohrogue judio masa wasirinirã pohrogue erã árĩri macarigue Griego masaguere buhegʉ wabocuri ihĩ? ");
INSERT INTO des_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Yʉ árĩborore mʉa wamasibeaa. Eropirã mʉa yʉre amaquererã ta ne bocasome,” ĩgʉ arĩgʉ ¿dohpa arĩronore ĩgʉ eropa arĩri? arĩ wereniguiñorã judio masa erã basi. ");
INSERT INTO des_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bosenʉ ojogorocʉrinʉ irinʉ gʉhyadiarinʉ gohra árĩro iibʉ. Irinʉ Jesu ero nigui, turaro mera weremi masare: —Ñemesiburã decore turaro gamero dopa árĩrã ʉmʉri nʉcʉ Goãmʉ mera turaro árĩdiarã yʉre serẽque. Mʉa eropa serẽcʉ̃ ĩgʉ yarã árĩdoregʉra mʉare. ");
INSERT INTO des_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yʉre umupeorãre õpa arĩ gojañuma Goãmʉ yare erã gojarapũgue: “Erã sĩporãriguere ojocaricʉ̃ iiri deco eropa árĩniguicãroca,” arĩ gojañuma, arĩ turaro weremi Jesu masare. ");
INSERT INTO des_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","“Erã sĩporãriguere ojocaricʉ̃ iiri deco eropa árĩniguicãroca,” arĩgʉ “Yʉre umupeorã Espíritu Santore oparãcoma” arĩgʉ iimi Jesu. Ĩgʉ ʉmarogue ĩgʉ mʉrianibiricʉ̃ dohpa Espíritu Santopʉ arinibirimi dohpa erãre. ");
INSERT INTO des_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesu ĩgʉ eroparĩcʉ̃ peerã, masa bajarã õpa arĩ wereniguima: —Ihĩ diaye ta Goãmʉ yare weremʉhtagʉ mari coredigʉ ta ãhrimi, arĩ wereniguima. ");
INSERT INTO des_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Õpa arĩma gajirã sã: —Ihĩ Cristo marire taubu ãhrimi, arĩma. Gajirãpʉ õpa arĩma: —Cristo árĩgʉ Galilea majagʉ árĩsome ĩgʉ. Ihĩ Jesupʉ ero majagʉ ta ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cristo Davi mʉrʉ pãrami gajisubu majagʉ arigʉ árĩbocumi. Eropigʉ Davi ya maca mʉraro Belén waĩcʉri maca masa dehyoagʉcumi Cristopʉ. Eropa ta arĩ werea Goãmʉ yare erã gojarapũ. Ihĩ Jesupʉ Belén macague masa dehyoabiripʉ. Eropigʉ ĩgʉ Goãmʉ ĩgʉ obeodigʉ Cristo gohra árĩbeami, arĩrima erã. ");
INSERT INTO des_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eropirã Jesure peenirã gajirã umupeo gajirãpʉ umupeobirã árĩnijarã game dʉca warima pe curu. ");
INSERT INTO des_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Eropirã bajamerãgã Jesure ñeadiarima. Eropa ñeadiaquererã ta ĩgʉre ñeabirima. ");
INSERT INTO des_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Eropirã surara pahia oparã pohrogue fariseo pohrogue dujaa wañorã daja. Erã dujajacʉ̃ ĩarã erã surarare serẽpiñorã: —¿Duhpirã Jesure ñeagãribirari mʉa? arĩñorã. ");
INSERT INTO des_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Ĩgʉ õatariaro wereniguigʉ ãhrami. Gajirã ĩgʉ iro dopa wereniguirã ne marima, arĩ yʉhriñorã surara erãre. ");
INSERT INTO des_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Erã eroparĩcʉ̃ fariseo masapʉ õpa arĩ wereñorã: —¿Mʉare ĩgʉ gʉyacʉ̃, “Diaye ta arĩgʉ iimi,” arãri mʉa sã? ");
INSERT INTO des_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mari oparã Jesure ne umupeobeama. Gʉa sã eropirã ĩgʉre umupeobeaa. ");
INSERT INTO des_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Oã masa Goãmʉ dorerire Moisere ĩgʉ apirare masibeama. Eropa masibirã árĩrã Jesure umupeoma. Erã eropa umupeori dipuwaja mari Pagʉ Goãmʉ erãre dipuwaja moagʉcumi, arĩñorã fariseo masa. ");
INSERT INTO des_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo fariseo masʉ Jesure weretamugʉ ejadigʉ ero árĩpʉ erã mera. Erã eroparĩcʉ̃ peegʉ õpa arĩpʉ ĩgʉ erãre: ");
INSERT INTO des_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Jesu ĩgʉ ñero iirare masibeaa mari. Eropa masibirã ĩgʉ marire wereboro core ĩgʉre dipuwaja moamasibeaa mari. Eropa masibiriquererã ta ĩgʉre dipuwaja moarã, mari ya dorerire tarinʉgarã iiaa mari, arĩpʉ Nicodemo erãre. ");
INSERT INTO des_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ĩgʉ eroparĩcʉ̃ peerã õpa arĩ yʉhriñorã erã: —¿Mʉ sã ĩgʉ iro dopa ta Galilea majagʉ ta ãhriri? Goãmʉ ya erã gojarapũre buhepehoque. Eropa buhegʉ, “Goãmʉ yare weremʉhtagʉ ne yujugʉ Galilea majagʉ marimi,” arĩ masigʉca mʉhʉ, arĩ yʉhriñorã erã Nicodemore. ");
INSERT INTO des_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Erã eropa arĩra pʉhrʉ erã ya wirigue dujaa wañorã. ");
INSERT INTO des_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesupʉ ĩgʉ seyaro ʉtãgʉgue Olivo waĩcʉdigʉgue waha wami. ");
INSERT INTO des_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gajinʉ Goãmʉ ya wihigue gʉa wabʉ daja. Jesu ejacʉ̃ ĩarã masa bajarã ĩgʉ pohro gamenerema. Erã gamenerecʉ̃ ĩgʉpʉ doanijagʉ erãre buhenʉgapʉ. ");
INSERT INTO des_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ĩgʉ eropa buhero watope judio masa buherã, fariseo masa mera iri wihigue nomeore aĩ ñajajama. Igo marapʉcʉquerego gajigʉ mera igo ñero iicʉ̃ bocajañorã erã igore. Eropa bocajarã igore Goãmʉ wihigue aĩ ñajama erã igore dipuwaja moadorerã. Aĩ ñajatuha árĩpehrerã gʉa ĩaro igore duhu nuguma. ");
INSERT INTO des_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Duhunugu õpa arĩma Jesure. —Buhegʉ, igo marapʉcʉgo árĩquerego gajigʉ mera ñero iigo iicʉ̃ bocajabʉ. ");
INSERT INTO des_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moise dorerire õpa ãhraa: “Ʉmʉ mera ñero iidigore ʉtã mera dea wejẽcãque,” arĩyoro Goãmʉ doreri. ¿Mʉca dohpa arĩ pepiri ire? arĩ serẽpima erã Jesure. ");
INSERT INTO des_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jesu ĩgʉ ñero wereniguicʉ̃ peediarã iirima erã ĩgʉre weresãmorã. Erã eropa serẽpiquerecʉ̃ ta Jesupʉ muhmusiu dija, yebague ĩgʉ mujusĩru mera gojami. ");
INSERT INTO des_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Eropigʉ erã eropa serẽpiniguicʉ̃ peegʉ Jesupʉ wahgã doaja, erãre weremi: —Mʉa mera majagʉ ñero iibigʉ árĩgʉ igore ʉtã mera deanʉgaporo, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Eropa arĩtuha dipaturi muhrisiu dija, yebague gojami daja. ");
INSERT INTO des_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Irire peerã igore aĩ ñajarinirãpʉ erã ñeri iirare guñarã, erã tĩrãpʉ wiria wamʉhtama. Erã pʉhrʉ erã mera majarã sã wiriapehrea wama. Eropigo nomeo dihta Jesu pohro dujanʉgamo. ");
INSERT INTO des_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Eropigʉ Jesu wahgã doaja, igore serẽpimi. —¿Nohogue ãhriri erã? ¿Mʉre dipuwaja moadianirã mariri dohpaguere? arĩmi igore. ");
INSERT INTO des_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Marima, opʉ, arĩ yʉhrimo igo. —Yʉ sã dipuwaja moabeaa mʉre. Waque. Eropigo ñerire iinemobiricãque, arĩmi Jesu igore. ");
INSERT INTO des_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Dipaturi Jesu iri wihigue árĩrãre weremi: —Boyoro iro dopa yʉhʉ i yeba majarãre Goãmʉre masicʉ̃ iiaa. Yʉre umupeogʉ Goãmʉ mera eropa árĩniguicãgʉcumi. Eropigʉ ĩgʉ boyorogue árĩgʉ dopa ta õarire guñagʉcumi. Eropigʉ ĩgʉ ñerire guñadiabeami, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ĩgʉ eroparĩcʉ̃ peerã fariseo masapʉ õpa arĩma. —Mʉhʉ mʉ basi mʉ árĩricʉrire eropa arĩ were­nigui­maacãgʉ iiaa. Mʉ õpa arĩ wereniguiri ne waja mara, arĩma erã Jesure. ");
INSERT INTO des_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Erã eroparĩcʉ̃ Jesu yʉhrimi: —Yʉhʉ, yʉ aridirore masia. Yʉ waboro sãre masia. Mʉapʉ ne irire masibeaa. Eropigʉ yʉ basi yʉ árĩricʉrire werequeregʉ iri yʉ werera diaye ta ãhraa. ");
INSERT INTO des_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mʉa sihajaro mʉa sã ĩara dihtare masia mʉa. Eropirã mʉa yʉre werewʉaa. Yʉhʉ mʉa iro dopa ta werewʉabeaa. ");
INSERT INTO des_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Masa erã árĩricʉrire ĩagʉ yʉhʉ yujugʉ ta ĩhamasibeaa. Yʉ tamera yʉre obeodigʉ mera masia. Eropigʉ yʉhʉ masa erã árĩricʉrire diaye ta ĩha masia. ");
INSERT INTO des_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉare doreri erã gojarapũ õpa arĩ werea: “Masa perã erã yujuro mera erã werecʉ̃ erã wereri diaye ta ãhraa,” arĩ were gojañuma. ");
INSERT INTO des_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yʉre weregʉ mera gʉa perã ãhraa. Yʉhʉ, yʉ árĩricʉrire werea. Eropigʉ yʉ Pagʉ sã weremi yʉre. Ĩgʉ ta ãhrimi yʉre obeodigʉ, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Nohogue ãhriri mʉ Pagʉ? arĩ serẽpima erã. —Yʉre mʉa masibeaa. Yʉ Pagʉ sãre masibeaa. Yʉre masirã, yʉ Pagʉ sãre masiboaya, arĩ yʉhrimi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu erãre buhegʉ eropa arĩ wereniguimi Goãmʉ wihigue erã niyeru apiri comoro pohro. Ĩgʉ ñero tariburisubu ejabiribʉ dohpa. Eropirã erã mera ĩgʉ árĩquerecʉ̃ ta ĩgʉre ñeabirima. ");
INSERT INTO des_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Dipaturi masa mera gʉa árĩrisubu Jesu erãre weremi daja: —Yʉ aridirogue wagʉca. Yʉ wara pʉhrʉ yʉre amarãca mʉa. Yʉ waboroguere mʉapʉ wamasisome. Eropirã mʉa ñeri dipuwajacʉrã sĩrirãca, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","“Yʉ waboroguere mʉapʉ wamasisome,” ĩgʉ arĩcʉ̃ peerã, —¿Ihĩ ĩgʉ basi wejẽ sĩrigʉcuri eropa arĩgʉ? arĩma judio masa erã basi. ");
INSERT INTO des_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Erã basi erã eroparĩcʉ̃ Jesu weremi erãre: —Mʉapʉ i yeba majarã ãhraa. Yʉpʉ ʉmaro majagʉ ãhraa. I yeba dehyoanirã ãhraa mʉapʉ. Ʉmarogue aridigʉ ãhraa yʉpʉ. ");
INSERT INTO des_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mʉare yʉ árĩricʉrire yʉ werecʉ̃ “Diaye árĩbeaa,” mʉa arĩrã, mʉa ñeri dipuwajacʉrã sĩrirãca mʉa. Eropigʉ “Mʉa ñeri dipuwajacʉrã sĩrirãca,” arĩrabʉ mʉare, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Noano ãhriri mʉhʉ? arĩ serẽpima erã. —Neguere yʉ mʉare arĩdiro dopa ta ãhraa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mʉare yʉ wereburi wʉaro dʉhyania. Eropiro mʉa ñeri dipuwajare mʉare yʉ wereboro wʉaro dʉhyaa dohpa. Eropigʉ yʉre obeodigʉre yʉ peerare i yeba majarãre werea. Ĩgʉ werera diaye ta ãhraa, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","“Yʉre obeodigʉ,” ĩgʉ arĩcʉ̃ peerã “Mari Pagʉ árĩcumi,” arĩ pepibirima erã. ");
INSERT INTO des_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Erã eropa arĩ pepibiricʉ̃ ĩagʉ Jesu weremi erãre: —Yʉre masʉre Goãmʉ ĩgʉ obeodigʉre mʉa crusa mera pabia aĩ wahgũ nugurãca. Mʉa eropa iirã, “Ĩgʉ Goãmʉ ĩgʉ obeodigʉ ta ãhrimi,” arĩ masirãca yʉre. Eropirã yʉ gamero dopa ta iibigʉ yʉ árĩrire masirãca. Eropirã yʉ Pagʉ ĩgʉ yʉre ĩgʉ buhera dihtare weregʉ yʉ árĩcʉ̃ sãre masirãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Eropigʉ yʉre obeodigʉpʉ yʉ mera ãhrimi. Ĩgʉ gamerire ʉmʉri nʉcʉ iiniguia. Eropigʉ ĩgʉ yʉre ne cóãbeami, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ĩgʉ eroparĩcʉ̃ peerã masa bajarã ĩgʉre umupeoma. ");
INSERT INTO des_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Eropirã gajirã judio masa Jesure umupeoma. Eropigʉ Jesu erãre weremi: —Yʉ dorerire iipehorã árĩrã, diaye ta yʉ buherã ãhraa mʉa. ");
INSERT INTO des_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Eropirã diaye ta masirãca mʉa. Diaye árĩrire masirã, ñero iirire duhumasirãca. Eropirã pohro majarã wiunirã iro dopa árĩrãca mʉa, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ĩgʉ eroparĩcʉ̃ peerã erã õpa arĩ yʉhrima daja: —Gʉapʉ iribojegue majagʉ mʉrʉ Abrahã pãramerã árĩturiarãgue ãhraa. Eropirã ne gajirã pohro majarã árĩbeaa gʉa. Eropigʉ “Pohro majarã wiunirã iro dopa árĩrãca,” arĩgʉ ¿dohpa arĩgʉ eropa arĩri mʉhʉ? arĩ serẽpima erã Jesure. ");
INSERT INTO des_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Erã eroparĩcʉ̃ peegʉ Jesu õpa arĩmi erãre: —Diaye mʉare arĩgʉ iiaa. Árĩpehrerã ñerire iirãpʉ erã ñeri iirire duhumasibeama. Eropiro iri ñeripʉ erãre dorea. Eropa árĩrã árĩrã pohro majarã iro dopa ãhrima erã. ");
INSERT INTO des_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pohro majagʉpʉ ĩgʉ opʉ magʉ iro dopa árĩbeami. Doreri opabeami. Iri wihi majagʉ magʉpʉ ʉmʉri nʉcʉ diaye ta ĩgʉ pagʉ doreri opami. ");
INSERT INTO des_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yʉhʉ Goãmʉ magʉ ãhraa. Eropigʉ ĩgʉ doreri opaa. Eropirã mʉa ñerire yʉ duhucʉ̃ iinirã árĩrã diaye ta ñerire duhunirã árĩrãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abrahã mʉrʉ pãramerã árĩturiarã mʉa árĩcʉ̃ masia. Eropa árĩquererã ta yʉ wereripʉre peediabeaa mʉa. Eropirã yʉre wejẽdiaa mʉa. ");
INSERT INTO des_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉ Pagʉ ĩgʉ yʉre masicʉ̃ iirare werea mʉare. Yʉ eropa werequerecʉ̃ ta mʉa pagʉ ĩgʉ doreripʉre iiaa mʉa sã, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Abrahã mʉrʉ iribojegue majagʉ gʉa pagʉ mʉrʉ árĩmʉripʉ, arĩ yʉhrima erã. Erã eroparĩcʉ̃ Jesu yʉhrimi: —Abrahã mʉrʉ porã árĩrã ĩgʉ iidiro dopa ta iiboaya mʉa. ");
INSERT INTO des_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Goãmʉ yʉre diaye ĩgʉ wererire mʉare yʉ werequerecʉ̃ ta yʉre wejẽdiaa mʉa. Abrahã mʉrʉpʉ ne eropa iibiridi árĩmi. ");
INSERT INTO des_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉa pagʉ ĩgʉ iidiro dopa ta iiaa mʉa, arĩmi Jesu erãre. Ĩgʉ eroparĩcʉ̃ erã yʉhrima: —Mojoto diribiridigo porã árĩbeaa gʉa. Yujugʉ ta ãhrimi gʉa pagʉ. Ĩgʉ ta ãhrimi Goãmʉ, arĩma erã. ");
INSERT INTO des_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Erã eroparĩcʉ̃ Jesu yʉhrimi: —Goãmʉ mera majagʉ árĩdigʉ ta õguere aribʉ yʉhʉ. Eropirã Goãmʉ mʉa Pagʉ ĩgʉ árĩcʉ̃ yʉre mahiboaya mʉa. Yʉ gamero aribiribʉ yʉ tamera. Yʉ Pʉ Goãmʉ ĩgʉ obeocʉ̃ aribʉ õguere. ");
INSERT INTO des_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Duhpirã yʉ wereniguirire peebeari mʉa? Yʉ wererire yujuro bojebeaa mʉa. Eropirã peebeaa mʉa. ");
INSERT INTO des_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉa pagʉpʉ watĩ ãhrimi. Eropirã watĩ ĩgʉ gameripʉre iidiaa mʉa. I yeba negohraguere árĩnʉgacʉ̃gue, dohpague sãre ĩgʉ masare wejẽgʉ ãhrimi. Ĩgʉre diaye maja ne mara. Eropigʉ ĩgʉ ne diaye majare wereniguibeami. Ĩgʉ negohraguere gʉyanʉgadigʉ árĩmi. Eropigʉ ĩgʉ eropa gʉyaniguigʉ árĩgʉ, gʉyarire weremi. ");
INSERT INTO des_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yʉpʉ diaye majare werea mʉare. Eropa yʉ werecʉ̃ peebeaa mʉa. ");
INSERT INTO des_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Mʉhʉ ñero iigʉ ãhraa,” arĩmasibeaa mʉa yʉre. ¿Diaye mʉare yʉ werequerecʉ̃ ta duhpirã peebeari mʉa? ");
INSERT INTO des_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Goãmʉ porãpʉ ĩgʉ wereniguirire peema. Ĩgʉ porã árĩbirã ĩgʉ wereniguirire peebeama, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ĩgʉ eroparĩcʉ̃ peerã judio masa ĩgʉre õpa arĩma: —“Mʉhʉ Samaria majagʉ ãhraa. Eropigʉ watĩ mera goroweregʉ ãhraa mʉhʉ,” gʉa arĩra diaye ta ãhraa, arĩma erã Jesure. ");
INSERT INTO des_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Erã eroparĩcʉ̃ peegʉ õpa arĩ yʉhrimi Jesu: —Goroweregʉ árĩbeaa yʉhʉ. Yʉ Pagʉre umupeoa. Mʉapʉ yʉre umupeobeaa. ");
INSERT INTO des_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yʉre masa erã umupeorire amabeaa yʉhʉ. Yʉ Pagʉpʉ yʉre umupeocʉ̃ gahmemi masare. Ĩgʉ tamera yʉ árĩricʉrire õaro ĩha masigʉ eropa ta umupeodoremi. Eropigʉ yʉ Pagʉ erã yʉre gamebiriri dipuwaja, dipuwaja moagʉcumi. ");
INSERT INTO des_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Diaye mʉare arĩgʉ iiaa. Yʉ dorerire iigʉ ʉmʉri nʉcʉ Goãmʉ mera eropa árĩniguicãgʉcumi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ĩgʉ eroparĩcʉ̃ peerã õpa arĩma erã: —Dohpague tamerare mʉ watĩ mera goroweregʉ árĩcʉ̃ gʉa õaro masia. Abrahã mʉrʉ sĩria wañumi. Goãmʉ yare weremʉhtanirã sã sĩria wañuma iribojegue. Eropigʉ “Yʉ dorerire iigʉ ʉmʉri nʉcʉ Goãmʉ mera eropa árĩ­niguigʉcumi,” arĩgʉ, ¿dohpa arĩgʉ eropa arĩri mʉhʉ? ");
INSERT INTO des_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Gʉa ñecʉ mʉrʉ tauro turari mʉhʉ? Ĩgʉ, Goãmʉ ya weremʉhtanirã sã sĩria wañuma iribojegue. ¿Mʉpʉ nihino ãhriri eropa arĩ wereniguigʉ? Mʉ eropa arĩro dopa árĩbeaa mʉhʉ, arĩma erã. ");
INSERT INTO des_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Erã eroparĩcʉ̃ peegʉ Jesu werenemomi: —Yʉhʉ yʉ basire umupeodoreri duhpiburi árĩbeaa. Yʉ Pagʉpʉ yʉre umupeodoregʉ ãhrimi ĩgʉ. “Gʉa Pagʉ” mʉa arĩgʉpʉ yʉ Pagʉ ta ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉapʉ yʉ Pagʉre ne masibeaa. Yʉhʉ ĩgʉre masia. “Ĩgʉre masibeaa,” arĩgʉ mʉa iro dopa ta gʉyaricʉgʉ árĩboaya yʉhʉ. Diaye ta ĩgʉre masia. Eropigʉ ĩgʉ dorerire iiaa. ");
INSERT INTO des_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I yebaguere yʉ árĩboro coregue mari ñecʉ mʉrʉ Abrahã mʉrʉ masimʉhtatuhamʉriñumi yʉre. Eropa masigʉ ĩgʉ mucubirimʉriñumi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ĩgʉ eroparĩcʉ̃ erã yʉhrima: —Abrahã mʉrʉ iribojegue majagʉ ãhrimi. Mʉpʉ cincuenta bojori opanibeaa. ¿Eropigʉ mʉhʉ ĩgʉ mʉrʉre duhpigʉ ĩha masiboyuri? arĩma judio masa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Diaye mʉare arĩgʉ iiaa. Abrahã ĩgʉ árĩboro core yʉpʉ árĩmʉhtatuhabʉ, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ĩgʉ eroparĩcʉ̃ peerã erã ʉtãyerire aĩ ĩgʉre deadiarima. Erã eropa deadiaquerecʉ̃ ta Jesupʉ Goãmʉ wihigue árĩdigʉ duhri wiria wami. ");
INSERT INTO des_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesu gʉa ĩgʉ buherã mera mague tariarã gajigʉre cuiri ĩhajabigʉre bocajabʉ. Ĩgʉ ne masa dehyoagʉgue ta cuiri ĩhajabigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gʉa sã ĩgʉre ĩarã serẽpibʉ Jesure. —Buhegʉ, ¿ihĩ duhpigʉ cuiri ĩhajabigʉ masa dehyoayuri? ¿Ñerire iimʉriyuri eropa wagʉ? ¿O ĩgʉ pagʉ sʉmarã erã ñero iira dipuwaja eropa wayuri ĩgʉ? arĩ serẽpibʉ gʉa Jesure. ");
INSERT INTO des_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Gʉa eroparĩcʉ̃ peegʉ õpa arĩ yʉhrimi: —Ihĩ ĩgʉ pagʉ sʉmarã sã erã ñerire iira sã ĩgʉre cuiri ĩhajabiricʉ̃ iibeaa. Goãmʉpʉ ĩgʉre cuiri ĩhajabiricʉ̃ iimi. Ĩgʉre ĩacʉ̃ iibu masare ĩgʉ turarire ii ĩhmuburire apimi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yʉre obeodigʉ ĩgʉ apirare yʉre iiro gahmea dohpaguere. Ñamiguere mari mohmemasibiro dopa ta pʉhrʉgue yʉre obeodigʉ ĩgʉ apirare iimasibeaa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","I yebaguere i yeba majarãre Goãmʉre masicʉ̃ iiaa, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Eropa arĩtuha yebague disico ehomepimi. Ĩgʉ disico ehomepirare nicu mera mohmore nijagʉ, cuiri ĩhajabigʉre ĩgʉ cuirire sũmi. ");
INSERT INTO des_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Eropa sũgʉ õpa arĩmi Jesu: —Siloé waĩcʉri gobegue mʉ cuirire coegʉ waque, arĩmi Jesu. Siloé ero majarã ya mera arĩrã obeora gobe arĩrã iima. Jesu ĩgʉ cuiri coedoredigʉpʉ waha, coetuhaja, cuiri ĩagʉgue dujajapʉ ĩgʉ ya wihigue. ");
INSERT INTO des_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ĩgʉ dujajacʉ̃ ero majarã ĩgʉre ĩañorã. Ero core niyeru serẽdigʉ ĩgʉ árĩcʉ̃ ĩanirã ĩgʉre õpa arĩñorã erã basi: —¿Ihĩ sohõ árĩdigʉ niyeru serẽdoadigʉ árĩbeari? arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Ĩgʉ ta ãhrimi, arĩñorã gajirã. —Ĩgʉ árĩbeami. Eropa árĩbiriqueregʉ ta ĩgʉ iro dopa ta bejagʉ ãhrimi, arĩñorã gajirã. Erã eroparĩcʉ̃ peegʉ cuiri ĩhajabiridigʉpʉ õpa arĩpʉ: —Ĩgʉ ta ãhraa yʉhʉ, arĩpʉ erãre. ");
INSERT INTO des_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ĩgʉ eroparĩcʉ̃ masa ĩgʉre serẽpiñorã: —¿Cuiri ĩhajabiridigʉ árĩdigʉ dohpa ii ĩhari mʉhʉ? arĩ serẽpiñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jesu waĩcʉgʉ disicore nicu mera mohmore yʉ cuirire sũami. Yʉre sũtuhaja “Siloé waĩcʉri gobegue mʉ cuirire coegʉ waque,” arãmi yʉre. Ĩgʉ eroparĩcʉ̃ coegʉ ejabʉ yʉhʉ. Eropa yʉ coera pʉhrʉ yʉ cuiri õaro dehyoabʉ yʉre, arĩ werepʉ ĩgʉ masare. ");
INSERT INTO des_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Mʉre eropa iidigʉ nohogue árĩcuri ĩgʉ? arĩñorã erã. —Ũba. Noho árĩgʉ árĩcumi, arĩpʉ ĩgʉ ");
INSERT INTO des_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Eropa arĩ wereniguituha erã cuiri ĩhajabiridigʉre fariseo masa pohrogue aĩ ejañorã. ");
INSERT INTO des_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Irinʉ Jesu dihta nicure mohmore cuiri ĩhajabigʉre õagʉ iiranʉ Sabadonʉ árĩbʉ. Irinʉ gʉa soorinʉ árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eropirã fariseo masapʉ ĩgʉre serẽpiñorã daja. —¿Dohpa ii ĩhari mʉhʉ? arĩ serẽpiñorã erã. —Nicu mera yʉ cuirire sũami. Eropigʉ yʉ cuirire coera pʉhrʉ ĩhaa yʉhʉ, arĩ werepʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—Ĩgʉ mari soorinʉ mari mohmedorebiririnʉre mohmeami. Eropigʉ ĩgʉ Goãmʉ yagʉ árĩbeami, arĩñorã gajirã fariseo masa. Gajirãpʉ õpa arĩñorã: —Ñerire iigʉ árĩgʉ õpa ĩre õagʉ wacʉ̃ iimasibeami. Eropigʉ ĩgʉ õagʉ árĩbocumi, arĩñorã gajirã Jesure. Eropirã erã, erã basi pe curu dʉca wariñorã. ");
INSERT INTO des_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Eropirã dipaturi erã cuiri ĩhajabiridigʉre serẽpinemoñorã daja. —¿Mʉre mʉ cuirire õaro iidigʉre dohpa arĩ pepiri mʉhʉ Jesure? arĩñorã erã ĩgʉre. —Ĩgʉ diaye ta Goãmʉ yare weremʉhtagʉ ãhrimi, arĩpʉ cuiri ĩhajabiridigʉpʉ. ");
INSERT INTO des_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Negohraguere judio masa õpa arĩ pepiriñorã. “Ihĩ cuiri ĩhajabiridigʉ árĩbeami,” arĩ pepiriñorã. Eropa arĩ pepirã cuiri ĩhajabigʉ pagʉ sʉmarãre sihubeoñorã erã. ");
INSERT INTO des_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Sihubeo ĩgʉ pagʉ sʉmarãre serẽpiñorã fariseo masa oparã. —¿Ihĩ diaye ta mʉ magʉ ãhriri? ¿Mata ĩgʉ cuiri ĩhajabigʉ masa dehyoari? ¿Diaye ta cuiri ĩhajabiridigʉ árĩqueregʉ dohpa ii ĩhari dohpaguere? arĩ serẽpiñorã erã ĩgʉ pagʉ sʉmarãre. ");
INSERT INTO des_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ihĩ gʉa magʉ ta ãhrimi. Eropigʉ mata cuiri ĩhajabigʉ masa dehyoami ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Irire masiquererã ta ĩgʉ ĩarare, ĩgʉre ĩacʉ̃ iidigʉ sãre masibeaa gʉa. Gʉa magʉre serẽpique. Bʉgʉ ãhrimi ĩgʉ. Ĩgʉ basi weremasimi ĩgʉ, arĩñorã ĩgʉ pagʉ sʉmarã. ");
INSERT INTO des_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judio masa oparã ero coreguere õpa arĩtuhañorã: —“Jesu ta Cristo mari taubu ãhrimi,” arĩrãre mari buheri wirigue ñajadoresome gʉa, arĩmʉriñorã judio masa gʉa oparã. Erã eroparĩcʉ̃ peenirã cuiri ĩhajabigʉ pagʉ sʉmarãpʉ judio masa oparãre güi árĩñorã. ");
INSERT INTO des_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eropa güirã “Bʉgʉ ãhrimi ĩgʉ. Ĩgʉre ta serẽpique,” arĩñorã erã judio masa oparãre. ");
INSERT INTO des_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pʉhrʉ judio masa oparã dipaturi cuiri ĩhajabiridigʉre sihubeoñorã. Sihubeo õpa arĩñorã ĩgʉre: —Goãmʉ mera diaye wereque mʉhʉ. Jesure ĩgʉ ñeri iigʉ ĩgʉ árĩcʉ̃ gʉa masia. Eropigʉ diaye wereque gʉare, arĩñorã judio masa cuiri ĩhajabiridigʉre. ");
INSERT INTO des_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Erã eroparĩcʉ̃ peegʉ õpa arĩ yʉhripʉ ĩgʉ: —Jesure ĩgʉ ñeri iigʉ ĩgʉ árĩcʉ̃ masibirica yʉhʉ. Yujuñe ta masia yʉhʉ. Iribojeguere cuiri ĩhajabigʉ árĩmʉribʉ yʉhʉ. Dohpaguepʉre ĩhaa yʉhʉ. Iri dihtare masia yʉhʉ, arĩ yʉhripʉ cuiri ĩhajabiridigʉpʉ erãre. ");
INSERT INTO des_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—¿Dohpa iiari ĩgʉ mʉre? Mʉ cuirire ĩhajadoregʉ dohpa iiari ĩgʉ mʉre? arĩ serẽpiñorã erã daja. ");
INSERT INTO des_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Irire ta mʉare weretuharabʉgʉ yʉhʉ. Yʉ eropa arĩ werequerecʉ̃ ta mʉa ne peediabeaa yʉre. ¿Dohpa iidiarã yʉ dipaturi werecʉ̃ peediari mʉa? ¿Mʉa sã ĩgʉ buherã árĩdiari? arĩpʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ĩgʉ eroparĩcʉ̃ peerã erã ĩgʉre turiñorã. —Mʉhʉ Jesu buhegʉ ãhraa. Gʉapʉ Moise buherã ãhraa. ");
INSERT INTO des_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Diaye ta Goãmʉ Moisere wereniguimʉriñumi. Jesure obeodigʉre gʉa masibeaa, arĩñorã erã cuiri ĩhajabiridigʉre. ");
INSERT INTO des_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Erã eroparĩcʉ̃ yʉhripʉ ĩgʉ: —¿Ĩgʉre obeodigʉre mʉa masibiricʉ̃, yʉre ĩacʉ̃ iidigʉ árĩgʉ Goãmʉ ĩgʉ obeodigʉ árĩbiribocuri ĩgʉ? ");
INSERT INTO des_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Goãmʉ ñeri iigʉre ĩgʉ serẽrire peebeami. Iri tamerare mari masia. Ñerire iigʉre peebiriqueregʉ ta Goãmʉre umupeogʉre, ĩgʉ dorerire iigʉre ĩgʉ serẽrire peemi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Negohraguere i yeba árĩnʉgacʉ̃guere, mata masa dehyoagʉgue ta cuiri ĩhajabigʉre ne yujugʉpʉre ĩhajacʉ̃ iigʉ marimʉripʉ. ");
INSERT INTO des_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eropigʉ Jesu Goãmʉ ĩgʉ obeodigʉ árĩbigʉ yʉre ĩacʉ̃ iibiriboñumi, arĩpʉ ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Erãpʉ õpa arĩ yʉhriñorã: —Mʉhʉ mata ñegʉ árĩmʉriya. ¿Eropa árĩqueregʉ ta gʉare buheri mʉhʉ? arĩñorã judio masa oparã. Eropa arĩtuha erã ĩgʉre cohã wiuñorã. ");
INSERT INTO des_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Eropigʉ cuiri ĩhajabigʉre erã cohã wiurare Jesu peemi. Eropa peegʉ cuiri ĩhajabiridigʉre gʉa bocajacʉ̃, ĩgʉre serẽpimi. —¿Masʉre Goãmʉ ĩgʉ obeodigʉre umupeori mʉhʉ? arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Opʉ, ¿noa ãhriri ĩgʉ? Ĩgʉre masigʉ umupeogʉra, arĩmi cuiri ĩhajabiridigʉpʉ Jesure. ");
INSERT INTO des_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Ĩgʉre ĩhatuhabʉ mʉhʉ. Dohpaguere mʉ mera wereniguigʉ ĩgʉ ta ãhraa yʉhʉ, arĩmi Jesu cuiri ĩhajabiridigʉre. ");
INSERT INTO des_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Opʉ, mʉre umupeoa yʉhʉ, arĩmi cuiri ĩhajabiridigʉpʉ. Eropa arĩgʉ ĩgʉ Jesu pohro mereja ĩgʉre umupeomi. ");
INSERT INTO des_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ĩgʉ eropa umupeocʉ̃ ĩagʉ õpa arĩmi Jesu masare: —Õarã, ñerã sã erã iirare masicʉ̃ iibu aribʉ yʉhʉ. Cuiri ĩhajabirã erã ĩabiro dopa ta yʉ Pagʉre masibirã ãhrima. Eropa masibirãre yʉ Pagʉre masicʉ̃ iigʉ aribʉ yʉhʉ. “Gʉa õaro masia,” arĩ pepinirã sãre õaro erã masibirirare masicʉ̃ iigʉ aribʉ yʉhʉ, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ĩgʉ eroparĩcʉ̃ peerã bajamerãgã fariseo masa ĩgʉre õpa arĩma: —“Cuiri ĩhajabirã erã ĩhamasibiro dopa ta masibeaa mʉa sã,” ¿arĩri mʉhʉ gʉare? arĩma fariseo masa Jesure. ");
INSERT INTO des_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Erã eroparĩcʉ̃ Jesu õpa arĩmi: —“Cuiri ĩhajabirã erã ĩha masibiro dopa ta diaye õaro masibeaa gʉa,” mʉa arĩcʉ̃ dipuwaja mariboya. “Gʉa õaro masirã ãhraa,” mʉa arĩrã ãhraa. Eropirã yʉre peediabirira dipuwaja mʉare dipuwaja ãhraa dohpaguere, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Pʉhrʉ queoriñe mera werenigui queogʉ buhebu õpa arĩmi Jesu gʉare gajirã masa sãre: —Diaye arĩgʉ iiaa mʉare. Oveja diburi sãriro disiporo ñajabigʉpʉ gajipʉgue ñajagʉpʉ yajari masʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Disiporo ñajagʉpʉ ovejare ĩhadibugʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Disiporo coregʉ disiporo pãgũmi ovejare ĩhadibugʉ ĩgʉ ñajariborore. Ovejare ĩhadibugʉ eracʉ̃ ĩgʉ wereniguirire peerã ãhrima ĩgʉ oveja. Erãre sihugʉ, erã waĩ mera sihubeomi ĩgʉ. Eropigʉ erãre sãrirogue árĩrãre sihu wiuniguimi disiporogue. ");
INSERT INTO des_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ĩgʉ yarãre árĩpehrerãre sihu wiu erãre mʉhtanʉgajami. Ovejapʉ ĩgʉ wereniguirire masirã, ĩgʉre nʉrʉsiama. ");
INSERT INTO des_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Gajigʉre erã masibigʉre nʉrʉsiabeama erã. Eropirã gajirã erã wereniguirire peerã, güi omagã wahama, arĩmi Jesu masare. ");
INSERT INTO des_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iri ĩgʉ werequerecʉ̃ ta irire peerã masibirima erã. ");
INSERT INTO des_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Eropigʉ dipaturi Jesu erãre gʉa sãre weremi daja: —Diaye mʉare arĩgʉ iiaa. Ovejare diburi sãriro disiporo iro dopa ãhraa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Árĩpehrerã yʉ core arinirã gʉyarire buherã yajari masa iro dopa ãhrima. Erã eropa árĩquerecʉ̃ ta oveja iro dopa árĩrã yaharãpʉ gajirãre ne pee wahgãbeama. ");
INSERT INTO des_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉ ovejare diburi sãriro disiporo iro dopa ãhraa. Iri disiporo ñajarã iro dopa ta ãhrima yʉre umupeorã. Eropigʉ erãre peamegue wabonirãre taugʉra. Ovejare cãhmotari sãriro erã cãhmotaro dopa ta yʉ taunirãre cãhmotagʉca. Eropirã erã gamerire oparãcoma, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Eropa arĩtuha õpa arĩnemomi: —Mʉare gʉya buherã ovejare yajari masa iro dopa ãhrima. Gajirã yajadiarã wejẽdiagãrima. Oveja iro dopa árĩrã yaharã árĩpehrerinʉri Goãmʉ mera árĩcʉ̃ iigʉ aribʉ yʉpʉ. Eropigʉ yaharã ʉmʉri nʉcʉ erã õaro árĩcʉ̃ iibu aribʉ yʉpʉ. ");
INSERT INTO des_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ovejare õaro ĩhadibugʉ iro dopa árĩgʉ ãhraa yʉhʉ. Ovejare õaro ĩhadibugʉ sĩribu árĩqueregʉ ta ĩgʉ ovejare cãhmotaniguigʉcumi. Yaharã Goãmʉ mera erã eropa árĩniguiburire sĩrigʉca. ");
INSERT INTO des_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ĩgʉ mohmeri masʉpʉ õaro ovejare ĩhadibugʉ árĩbeami. Eropirã oveja ĩgʉ yarã árĩbeama. Eropigʉ nʉgʉ majagʉ diaye ovejare ñeagʉ ĩgʉ aricʉ̃ ĩagʉ ĩgʉ mohmeri masʉpʉ ovejare cóãcã güi omagã wahami. Ĩgʉ eropa cohãpigãra pʉhrʉ, nʉgʉ majagʉ diaye ĩgʉ ovejare ĩgʉ ñeacʉ̃ ĩarã ovejapʉ omasirigã wahama. ");
INSERT INTO des_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ĩgʉ mohmeri masʉpʉ ĩgʉ wajatari dihtare gahmemi. Eropigʉ ĩgʉ ovejare õaro ĩhadibudiabeami, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Eropa arĩtuha õpa arĩnemomi queoriñe mera: —Ovejare õaro ĩhadibugʉ iro dopa ãhraa yʉhʉ. Eropigʉ yaharãre masia yʉhʉ. Eropirã yaharã sã yʉre masima. ");
INSERT INTO des_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Eropa ta yʉ Pagʉ sã yʉre masimi. Eropigʉ yʉ sã yʉ Pagʉre masia. Yaharã Goãmʉ mera erã árĩniguiburire sĩrigʉca. ");
INSERT INTO des_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Gajirã oveja gaji sãriro majarã iro dopa árĩrã gajirã masa sã yaharã árĩrãcoma. Erã sãre aĩgʉca. Eropirã yʉ wereniguirire pee wahgãrãcoma erã sã. Eropirã yaharã árĩpehrerã yuju curu ta árĩrãcoma. Eropigʉ yʉ dihta yaharãre ĩhadibugʉca, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Eropa arĩtuha õpa arĩnemomi daja: —Yaharã Goãmʉ mera erã árĩniguiburire sĩrigʉca yʉhʉ. Yʉ sĩrira pʉhrʉ masa mʉriagʉca. Yʉ eropa iibu árĩcʉ̃ yʉ Pagʉ yʉre mahimi. ");
INSERT INTO des_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yʉ wejẽdorebiricʉ̃ yʉre wejẽmasibiriboñuma erã. Yʉ gamero mera yʉre wejẽrãcoma. Eropigʉ yaharã Goãmʉ mera erã ya árĩburire sĩrigʉca. Sĩrimasia yʉhʉ. Eropigʉ masa mʉriamasia. Yʉ Pagʉ yʉre irire ta iidoremi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ĩgʉ eroparĩcʉ̃ peerã judio masa pe curu dʉca warima daja. Gajirã gajiropa pepi, gajirã sã gajiropa pepinirã árĩma. ");
INSERT INTO des_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Ĩgʉ watĩre opami. Eropigʉ goroweregʉ ãhrimi. ¿Duhpirã ĩgʉre dipaturi peeri mʉa? arĩma gajirã bajarã judio masa. ");
INSERT INTO des_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gajirãpʉ õpa arĩma: —Watĩ mera goroweregʉ árĩgʉ eropa õaro arĩ wereniguibiriboñumi. Cuiri ĩhajabigʉre ĩacʉ̃ iimasibiriboñumi watĩre opagʉ. Eropa árĩgʉ árĩgʉ ĩgʉ watĩre opabeami, arĩma gajirã judio masa. ");
INSERT INTO des_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gajinʉ Jerusaléngue bosenʉ iirã iima dipaturi judio masa. Goãmʉ wihire erã Goãmʉ ya árĩburire erã apiri bosenʉ árĩbʉ. Irisubu yura wahgũro árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Irinʉ Salomo waĩcʉri taribugue Goãmʉ wihigue árĩri taribure Jesu gʉa mera ĩhacurigʉ iimi. ");
INSERT INTO des_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iri taribugue ĩgʉ árĩcʉ̃ ĩarã judio masa ĩgʉ pohrogue gamenere ĩgʉre serẽpima daja: —Yoatariari boje gʉare õaro werebeaa mʉhʉ. Diaye gʉare õaro were purumujuque. ¿Cristo Goãmʉ ĩgʉ obeodigʉ ta ãhriri mʉhʉ? arĩma erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Erã eroparĩcʉ̃ peegʉ õpa arĩ yʉhrimi Jesu: —Mʉare weretuhabʉ yʉhʉ. Yʉ eropa werequerecʉ̃ ta yʉre peebeaa mʉa. Yʉ Pagʉ ĩgʉ dorero dopa ta ĩgʉ turari mera ii ĩhmurabʉ mʉare. Eropa iigʉ yʉ Cristo árĩrire ta mʉare ĩhmugʉ iirabʉ. ");
INSERT INTO des_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yʉ eropa ii ĩhmuquerecʉ̃ ta yʉre peebeaa mʉa. Mʉapʉ yaharã árĩbeaa. Eropirã gajigʉ yarã oveja iro dopa árĩrã yʉpʉre peebeaa mʉa. ");
INSERT INTO des_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Oveja erãre ĩhadibugʉre erã peediro dopa ta yaharã yʉre peema. Eropigʉ erãre masia yʉhʉ. Eropirã erã yʉ mera wahama. ");
INSERT INTO des_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eropigʉ ʉmʉri nʉcʉ Goãmʉ mera árĩcʉ̃ iiaa erãre. Eropirã erãpʉ peamegue wasome. Eropigʉ yaharãre yʉ ĩhadibucʉ̃ gajirãpʉ ne yʉre emamasibeama erãre. ");
INSERT INTO des_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yʉ Pagʉ yaharãre yʉre odigʉ yʉ tauro turami. Eropirã yʉ Pagʉ sã yaharãre ĩgʉ ĩhadibucʉ̃ gajirã ĩgʉ sãre ne emamasibeama. ");
INSERT INTO des_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉhʉ, yʉ Pagʉ mera yujugʉ ta ãhraa, arĩmi Jesu judio masare. ");
INSERT INTO des_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ĩgʉ eroparĩcʉ̃ peerã judio masapʉ ĩgʉre deaburi ʉtãre dipaturi aĩma daja. ");
INSERT INTO des_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Erã eropa iicʉ̃ ĩagʉ Jesu erãre serẽpimi: —Yʉ Pagʉ ĩgʉ turari mera baja deyoro moarire ii ĩhmurabʉ mʉare. ¿Ñehenore iira dipuwaja ʉtã mera deadiari mʉa yʉre? arĩ serẽpimi. ");
INSERT INTO des_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ĩgʉ eroparĩcʉ̃ peerã õpa arĩma erã: —Goãmʉ turari mera mʉ ii ĩhmuri dipuwaja mʉre ʉtã mera dea wejẽdiabeaa gʉa. Goãmʉre mʉ ñero wereniguiri dipuwaja mʉre ʉtã mera dea wejẽdiaa gʉa. Masʉ árĩqueregʉ ta mʉhʉ “Goãmʉ ãhraa yʉhʉ,” mʉ arĩri dipuwaja mʉre ʉtã mera dea wejẽdiaa gʉa, arĩ yʉhrima erã. ");
INSERT INTO des_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Erã eropa arĩ yʉhricʉ̃ peegʉ Jesu erãre weremi: —Mʉa sãre “Goãmarã,” arĩ piyumi Goãmʉ. Eropa ta arĩ gojañuma ĩgʉ dorerire erã gojarapũgue. ");
INSERT INTO des_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Goãmʉ yare erã gojarapũ queoro árĩcʉ̃ mari masia. “Gʉyari ãhraa,” iripũre arĩmasibeaa mari. Eropigʉ ĩgʉ yare pepirãre diaye ta ĩgʉ “Goãmarã,” arĩ piyumi. ");
INSERT INTO des_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Goãmʉ yʉre beyenijagʉ i yebaguere obeomi. Eropigʉ “Yʉhʉ Goãmʉ magʉ ãhraa,” yʉ arĩra dipuwaja “Goãmʉre ñero wereniguigʉ iimi Jesu,” arãa mʉa yʉre. ¿Duhpirã yʉre eropa arĩri mʉa? ");
INSERT INTO des_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉ Pagʉ ĩgʉ gamero dopa ta ĩgʉ turari mera yʉ ii ĩhmubiricʉ̃ tamerare yʉ buherire “Diaye ta ãhraa,” arĩbiriboya mʉa. ");
INSERT INTO des_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yʉ Pagʉ ĩgʉ turari mera yʉ ii ĩhmuquerecʉ̃ ta yʉpʉre umupeodiabiriboca mʉa. Eropa umupeodiabiriquererã ta ĩgʉ turari mera yʉ ii ĩhmucʉ̃ ĩarã yʉ iirare “Diaye ta ãhraa,” arĩque mʉa. Mʉa eropa arĩrã, yʉ Pagʉ mera gʉa yujuro mera árĩcʉ̃ masirãca mʉa. Eropirã yʉhʉ, yʉ Pagʉ mera yujuro mera yʉ árĩcʉ̃ masirãca mʉa. Eropirã peerãca mʉa, arĩmi Jesu erãre. ");
INSERT INTO des_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ĩgʉ eroparĩcʉ̃ erã ĩgʉre dipaturi ñeadiarima. Erã eropa ñeadiacʉ̃ ĩgʉ duhri wiria wami. ");
INSERT INTO des_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Eropa wiriadigʉgue ta Ñu masare ĩgʉ waĩyemʉhtadirogue Jordán waĩcʉriya sipʉ majasegue gʉa dipaturi wabʉ daja. Erogue dujacãbʉ. ");
INSERT INTO des_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Eropirã masa bajarã ĩgʉre ĩarã erama. Õpa arĩma erã erã basi: —Ñu waĩyegʉpʉ Goãmʉ turari mera deyoro moarire ii ĩhmubirimi. Eropa ii ĩhmubiriquerecʉ̃ ta árĩpehreri Jesure ĩgʉ wererapʉ diaye ta ãhraa, arĩma masa erã basi. ");
INSERT INTO des_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eropirã masa erogue bajarã umupeoma Jesure. ");
INSERT INTO des_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Eropi Judea yebague Betania waĩcʉri maca majagʉ Lázaro waĩcʉgʉ árĩmi. Iri maca ĩgʉ pagʉ porã nome María, Marta mera árĩma. ");
INSERT INTO des_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maríapʉ Jesure poresuri mera sũbo, igo poari mera ĩgʉre tucoebodigo árĩmo. Igo tĩgʉ Lázaropʉ dorecʉgʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eropirã erã nome gajirãre Jesure weredorerã obeoñorã. —Opʉ, mʉ mahigʉ dorecʉgʉ iimi, arĩ weredorerã obeoñorã Lázaro pagʉ porã nome. ");
INSERT INTO des_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Erã gʉa pohrogue eraa, iri querere werecʉ̃ peegʉ õpa arĩmi Jesu gʉare. —Dohpaguere Lázaro ĩgʉ dorecʉri sĩriburi árĩbeaa. Goãmʉ turarire masare ĩhmuburire dohpaguere ĩgʉ dorecʉmi. Eropirã yʉ turari opagʉ árĩcʉ̃ sãre masa ĩarãcoma, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu Martare, igo pagʉ mago, Lázaro sãre turaro mahími. ");
INSERT INTO des_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Eropigʉ Lázaro ĩgʉ dorecʉrire peequeregʉ ta ero Jesupʉ penʉ dujanimi. ");
INSERT INTO des_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Penʉ pʉhrʉ Jesu õpa arĩmi gʉare ĩgʉ buherãre. —Dipaturi Judea yebague dujaa warã daja, arĩmi gʉare. ");
INSERT INTO des_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Buhegʉ, cãrʉgã ta mʉre judio masa ʉtã mera dea wejẽdiama. ¿Duhpigʉ dipaturi dujadiari mʉhʉ? arĩbʉ gʉa ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Gʉa eroparĩcʉ̃ peegʉ ĩgʉ erã wejẽmasibirirare weregʉ, werenigui queori mera gʉare õpa arĩmi: —Wʉaro guñaricʉbiricãque. Yujunʉre doce horari gohra ãhraa. Abe ʉmʉ majagʉ árĩcʉ̃ õaro ĩhaa mari. Eropirã ʉmʉre curirã ne cohresome mari. ");
INSERT INTO des_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Naitĩaro curirã cohrema. Abe ʉmʉ majagʉ maricʉ̃ õaro ĩabeama erã, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Eropa arĩgʉ gʉare werenemomi. —Mari mera majagʉ Lázaro carĩgʉ iicumi. Ĩgʉ eropa carĩquerecʉ̃ ta yʉhʉ ĩgʉre wahgũgʉ wagʉra, arĩmi gʉare. ");
INSERT INTO des_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Opʉ, Lázaro carĩgʉ árĩgʉ tarigʉcumi, arĩbʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Gʉa eropa arĩquerecʉ̃ ta Jesupʉ “Carĩgʉ iicumi,” arĩgʉ, “Sĩria wami,” arĩgʉ iidigʉ árĩmi. Ĩgʉ “Lázaro carĩgʉ iicumi,” arĩcʉ̃ peerã “Lázaro soogʉ iicumi,” arĩ pepiribʉ gʉapʉ. ");
INSERT INTO des_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Gʉa eropa arĩ pepicʉ̃ masigʉ Jesu gʉare diaye weremi. —Lázaro sĩria wañumi. ");
INSERT INTO des_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yʉ mariro ĩgʉ sĩricʉ̃ õapũricãa. Eropirã mʉa yʉre umupeonemorãca. Ina ta. Mari ĩarã warã ĩgʉ pohrogue, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma sʉhrʉadigʉ erã arĩgʉpʉ õpa arĩmi gʉare: —Mari sã Jesu mera warã. Ĩgʉre wejẽrã mari sãre wejẽporo, arĩmi Toma. ");
INSERT INTO des_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Eropi gʉa erogue ejara pʉhrʉ ero majarã õpa arĩ werema Jesure: —Wapicʉrinʉ taria Lázaro mʉrʉre masa gobegue erã apira pʉhrʉ, arĩ werema ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniapʉ Jerusalén pohrogã ʉhre kilómetros yoaro dujabʉ. ");
INSERT INTO des_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Eropirã judio masa bajarã Martare, María sãre ñehamere orerã eranirã árĩma Lázaro ĩgʉ sĩrira pʉhrʉ. ");
INSERT INTO des_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eropigʉ Jesu mera gʉa ejaboro pohro árĩcʉ̃ peego Martapʉ gʉare bocatĩrigo eramo. Igo bocatĩrigo wacʉ̃ Maríapʉ igo ya wihi dujadigo árĩmo. ");
INSERT INTO des_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Eropa bocatĩrigo Marta õpa arĩmo Jesure: —Opʉ, yʉ tĩgʉ ĩgʉ sĩriboro core mʉhʉ ohõ árĩcʉ̃ ĩgʉ sĩribiriboañumi. ");
INSERT INTO des_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dohpague sãre Goãmʉre mʉ serẽcʉ̃ ĩgʉ mʉ serẽro dopa ta iigʉcumi, arĩmo Marta Jesure. ");
INSERT INTO des_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Mʉ tĩgʉ masagʉcumi, arĩmi Jesu igore. ");
INSERT INTO des_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—I yeba pehrerinʉ ĩgʉ masa mʉriaborore masia yʉhʉ, arĩmo igo. ");
INSERT INTO des_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Igo eroparĩcʉ̃ Jesu weremi daja: —Yʉhʉ sĩrinirãre masacʉ̃ iigʉ ãhraa. Masare yʉ mera eropa árĩniguicʉ̃ iigʉ ãhraa. Yʉre umupeogʉ sĩriqueregʉ ta eropa árĩniguicãgʉcumi. ");
INSERT INTO des_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Eropirã árĩpehrerã Goãmʉ mera árĩniguirã yʉre umupeorã peamegue wasome. ¿Ire masiri mʉhʉ? arĩmi Jesu igore. ");
INSERT INTO des_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Opʉ, masia yʉhʉ. “Cristo Goãmʉ magʉ i yebague arigʉcumi,” erã arĩdigʉ mʉ árĩcʉ̃ masia yʉhʉ, arĩmo Marta Jesure. ");
INSERT INTO des_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta eropa arĩtuha igo pagʉ magore Maríare sihugo wamo. —Marire buhegʉ mari ya macare eranijagʉ iiami. Mʉre sihuami, arĩ yayarogã arĩ werepo Maríare. ");
INSERT INTO des_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Igo eroparĩcʉ̃ peego María pobero mera wahgãnʉgaja, gʉa pohrogue árimo Jesure ĩago arigo. ");
INSERT INTO des_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Erã ya macague ejanibiricarabʉ dohpa. Marta gʉare igo bocatĩridirogue árĩnibʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judio masa iri wihi Maríare ñehamere orerã iinirã árĩma. Eropirã igo pobero mera wahgã wacʉ̃ ĩarã erã igore nʉrʉsiagãnirã árĩma. “Igo tĩgʉ mʉrʉre erã apira gobegue orego wago iicumo igo,” arĩ pepinirã árĩrima erã. Eropa arĩ pepirã igore nʉrʉsiagãnirã árĩma. ");
INSERT INTO des_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Eropigo María gʉa pohrogue erago, Jesure ĩha, ĩgʉ guburi pohro merejamo. —Opʉ, yʉ tĩgʉ ĩgʉ sĩriboro core mʉhʉ ohõ árĩcʉ̃ ĩgʉ sĩribiriboañumi, arĩmo igo ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Eropigʉ igo judio masa igo mera arinirã sã erã orecʉ̃ ĩagʉ Jesupʉ turaro bʉjawere ñero sĩporãcʉmi. ");
INSERT INTO des_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Lázaro mʉrʉre nohogue opari mʉa? arĩ serẽpimi Jesu. —Opʉ, ĩagʉ arique, arĩ sihugãma erã. ");
INSERT INTO des_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Erã eroparĩcʉ̃ peegʉ Jesu oremi. ");
INSERT INTO des_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ĩgʉ orecʉ̃ ĩha judio masa õpa arĩma erã basi: —Lázaro mʉrʉre Jesu bʉrigã mahirañumi, arĩma. ");
INSERT INTO des_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gajirãpʉ õpa arĩma: —Cuiri ĩhajabigʉre ĩacʉ̃ iigʉ ãhrimi ihĩ Jesu. ¿Eropigʉ Lázaro ĩgʉ sĩriboro core masumasibiriboayuri? arĩma gajirã. ");
INSERT INTO des_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Eropigʉ Jesu dipaturi turaro bʉjaweremi. Eropirã árĩpehrerã Lázaro mʉrʉ masa gobegue ejabʉ. Ʉtãyegue árĩri gobegue ĩgʉ dʉpʉ mʉraro erã sĩ acura gobegue árĩbʉ. Eropi iri gobegue wʉariye ʉtãye mera erã bihara gobegue árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Ʉtãyere aĩ weaque, arĩmi Jesu. Ĩgʉ eroparĩcʉ̃ peego Marta sĩridigʉ mʉrʉ pagʉ mago õpa arĩmo: —Opʉ, dohpague wapicʉrinʉ wahaa ĩgʉ sĩrira pʉhrʉ. Eropiro ĩgʉ dʉpʉ mʉraro ʉrĩ árĩca, arĩmo Jesure. ");
INSERT INTO des_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—“Yʉre umupeogo Goãmʉ turarire ĩagoca,” mʉre arĩrabʉ, arĩmi Jesu Martare. ");
INSERT INTO des_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ĩgʉ eropa arĩra pʉhrʉ erã ʉtãyere aĩ weama. Erã eropa aĩ weara pʉhrʉ Jesu ʉmarogue ĩha Goãmʉre õpa arĩmi: —Ahʉ, yʉre mʉ peetuhabʉ. Irire mʉ iicʉ̃ masigʉ mucubiria mʉre. ");
INSERT INTO des_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yʉre mʉhʉ ʉmʉri nʉcʉ peeniguia. Irire masia. Eropa masiqueregʉ ta yʉhʉ mʉ obeodigʉ árĩcʉ̃ õre niguirã erã masiburire mʉre eropa arĩgʉ iiaa. ");
INSERT INTO des_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eropa arĩtuha Jesu turaro gaguiniguimi: —Lázaro, arique, arĩ gaguiniguimi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ĩgʉ eroparĩcʉ̃ sĩridigʉ mʉrʉpʉ ĩgʉ mojotorire ĩgʉ guburi sãre suhri gasiri mera erã diridigʉ, ĩgʉ dipurure suhri gasiri mera erã omadigʉ masa gobegue wiririmi. —Ĩgʉre dirirare pãque ĩgʉre, arĩmi Jesu ");
INSERT INTO des_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ĩgʉ eropa masucʉ̃ ĩarã bajarã judio masa mera majarã María mera árĩnirã Jesure umupeoma. ");
INSERT INTO des_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gajirãpʉ erã mera majarã fariseo masa pohrogue eja, Jesu ĩgʉ iirare wereñorã erãre. ");
INSERT INTO des_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Eropirã pahia oparã, fariseo masa oparã sã gamenere, erã basi õpa arĩ wereniguiñorã. —Jesu bajasuburi deyoro moarire ii ĩhmumi. Ĩgʉ eropa iicʉ̃, “Irire iibita,” mari arĩbiricʉ̃ árĩpehrerã masa ĩgʉre umupeo, ĩgʉ mera wabocoma. Eropirã Roma majarã oparã Goãmʉ wihire cóãdorerã obeorãcoma erã yarã surarare. Mari ya yeba sãre emarãcoma erã. Mari ya yeba majarã Jesure erã opʉ erã apicʉ̃ ĩarã Roma majarã oparã guarã ñero iirãcoma marire. ¿Eropa iirã dohpa iirãcuri dohpaguere? arĩ wereniguiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Erã eropa arĩquerecʉ̃ ta gajigʉ Caifa waĩcʉgʉ iri bojorire pahia opʉ árĩgʉ erãre werepʉ. —Mʉapʉ ne masibeaa. ");
INSERT INTO des_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Judio masa árĩpehrerã mari ya árĩburire yujugʉ masʉ ĩgʉ sĩricʉ̃ õhaa. Ĩgʉ sĩribiricʉ̃ mari árĩpehrerã judio masa pehrea waboca. Irire mʉa masibeaa, arĩmi Caifa erãre. ");
INSERT INTO des_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Eropa arĩgʉ ĩgʉ gamero eropa arĩbiriñumi. Pahia tauro opʉ ĩgʉ árĩcʉ̃ judio masa ya árĩburire Jesu ĩgʉ sĩriborore Goãmʉpʉ Caifare eropa arĩ weredoreñumi. ");
INSERT INTO des_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesu ĩgʉ sĩrigʉ judio masa ya dihta sĩribiriñumi. Sĩrigʉ árĩpehrerã Goãmʉ porã i yeba árĩpehrero árĩrã sãre erã ya árĩburi sãre sĩriñumi Jesu. Erã yuju curu árĩboro dopa sĩriñumi. ");
INSERT INTO des_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifa eroparĩcʉ̃ peerã erã “¿Jesure dohpa ii wejẽrãcuri mari?” arĩ wereniguirã ĩgʉre wejẽmorã iiñorã. ");
INSERT INTO des_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ĩgʉre erã wejẽdiacʉ̃ masigʉ Jesu bajarã judio masa watope dipaturi curigʉ wabirimi. Eropigʉ masa marirogã Efraín waĩcʉri macague gʉare sihu wami. Gʉare iri maca sihu dujanimi Jesu. ");
INSERT INTO des_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Irisubure Pascua bosenʉ gʉa judio masa bosenʉ árĩboro merogã dʉhyabʉ. Eropirã bosenʉ core masa bajarã gaji macari majarã masa Jerusaléngue gamenerema. Pascua majare erã baboro core Goãmʉ ya árĩburire erã basi coemorã ejanirã árĩma. ");
INSERT INTO des_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Eropirã erã Jesure amarã iiñorã. Erã eropa amacʉ̃ ĩarã Goãmʉ wihigue árĩrã õpa arĩ wereniguiñorã: —¿Bosenʉre ĩagʉ aribiribocuri Jesu mʉa pepicʉ̃? arĩ wereniguiñorã erã basi. ");
INSERT INTO des_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Eropirã pahia oparã, fariseo masa sã õpa arĩ weredoreñorã masare: —Jesu ĩgʉ árĩrore mʉa masirã wereque gʉare. Ĩgʉre ñeamorã iiaa gʉa, arĩñorã oparã masare. ");
INSERT INTO des_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua bosenʉ seis nʉri gohra dʉhyacʉ̃ Jesu gʉa ĩgʉ buherã mera Betaniague ejabʉ. Lázaro Jesu ĩgʉ masudigʉ iri maca majagʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gʉa ejara pʉhrʉ Jesu sã gʉa ya bari árĩburire iima gajirã. Eropirã Lázaro, Jesu, gʉa mera mesare doajabʉ. Gʉa eropa doajara pʉhrʉ Marta barire peomo gʉare. ");
INSERT INTO des_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Eropigo María poresuripʉre nardo waĩcʉri goripʉre yuju kilo deco aĩgãri, Jesu guburire pipeomo. Pipeotuha igo poari mera tucoemo. Igo eropa pipeora pʉhrʉ iri wihi õaro poresu sehya wabʉ. ");
INSERT INTO des_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Igo eropa iicʉ̃ ĩha gʉa mera majagʉ, Jesure ĩhaturirãre wiabu Juda Iscariotepʉ õpa arĩmi: ");
INSERT INTO des_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Duhpigo iri poresuri eropa iisiriri igoa? Irire igo duaboañumo. Irire duago yuju bojori mohmeri wajapʉre wajataboañumo. Eropigo mojomorocʉrãre oboañumo igo, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judapʉ mojomorocʉrãre itamudiabiriñumi. Ĩgʉ gʉa ya niyeru dibugʉ árĩqueregʉ ta yajaricʉgʉ árĩmi. Eropigʉ ĩgʉ gʉa ya niyeru sãre yujuyerisuburi aĩmʉrimi. Eropigʉ iri niyerure aĩdiagʉ árĩgʉ, eropa arĩñumi ĩgʉ Maríare. ");
INSERT INTO des_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ĩgʉ eroparĩcʉ̃ peegʉ õpa arĩmi Jesu: —Eropa arĩbita igore. Igo poresurire yʉre igo dʉarare yʉre pipeoamo yʉre erã yaaboro core yʉ dʉpʉre amuyugo. Mojomorocʉrãpʉ mʉa mera eropa árĩniguicãrãcoma. Eropirã mʉa gamero erãre omasia mʉa. ");
INSERT INTO des_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yʉpʉ i yebaguere eropa árĩniguicãsome, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Eropirã Jesu ĩgʉ Betaniague árĩcʉ̃ peerã judio masa bajarã ĩgʉre ĩarã arima. Ĩgʉ dihtare ĩarã aribirima. Lázaro sĩridigʉ Jesu ĩgʉ masudigʉre ĩgʉ sãre ĩarã arirã iima. ");
INSERT INTO des_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Erã ĩarã ejarare pahia oparã masirã Lázarore wejẽdiañorã. ");
INSERT INTO des_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro sĩridigʉ Jesu ĩgʉ masudigʉ árĩcʉ̃ ĩarã bajarã masa Jesure umupeoma. Ĩgʉ eropa masucʉ̃ ĩarã bajarã judio masa erã pahia erã buheripʉre cóãma. Erã eropa cóãcʉ̃ ĩarã pahia oparãpʉ guataria wa, Lázaro sãre wejẽdiañorã. ");
INSERT INTO des_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pascua bosenʉ erã iicʉ̃ bajarã masa Jerusaléngue ĩarã wanirã árĩma. Gajinʉ Jerusaléngue Jesu ĩgʉ waburire masa peenirã árĩma. ");
INSERT INTO des_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Eropirã bejepũre aĩgã, ĩgʉre bocatĩrirã wama. Eropa bocatĩrirã õpa arĩ gaguiniguima erã. —Ĩre umupeorã. Ihĩ Goãmʉ ĩgʉ obeodigʉ õaro ariporo. Ihĩ judio masa mari opʉ ta ãhrimi, arĩ gaguiniguima erã. ");
INSERT INTO des_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu burrogã ĩgʉ bocadigʉ weca peyami. Ĩgʉ eropiigʉ Goãmʉ yare erã gojarapũ werediro dopa ta iimi. Õpa arĩ gojañumi Goãmʉ yare wereyumʉhtadigʉgue. ");
INSERT INTO des_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalén waĩcʉro majarã güibiricãque mʉa. Ĩaque. Mʉa opʉ burrogã weca peyagãrimi, arĩ weremʉhtañumi Goãmʉ yare erã gojarapũgue. ");
INSERT INTO des_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Irire gʉa ĩgʉ buherã õaro masinibiribʉ. Eropa masibiriquererã ta ʉmarogue Jesu ĩgʉ mʉriara pʉhrʉ gʉa erã gojara mʉrare guña boca pee masibʉ. Õpa arĩ pepibʉ: “Goãmʉ yare erã gojarapũgue Jesure weremʉhtañuma. Eropiro Goãmʉ yare erã gojarapũ arĩdiro dopa ta sihajabʉ Jesure,” arĩ pepibʉ gʉa basi. ");
INSERT INTO des_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lázarore erã apira gobegue árĩgʉre Jesu ĩgʉ piyucʉ̃ ĩgʉre ĩgʉ masucʉ̃ ĩanirãpʉ weresiriniguinirã árĩma masare. ");
INSERT INTO des_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eropirã Lázarore Jesu ĩgʉ masurare erã peenirã árĩrã masa bajarã Jesure bocatĩrirã wama. ");
INSERT INTO des_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Erã Jesure eropa umupeocʉ̃ ĩarã fariseo masa erã basi õpa arĩñorã. —Árĩpehrerã Jesu yarã dihta warã iima dohpaguere. Eropirã mari dohpa iimasibeaa erãre, arĩñorã fariseo masa erã basi. ");
INSERT INTO des_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Eropi bosenʉ Goãmʉ wihigue Goãmʉre umupeorã eranirã mera majarã bajamerãgã griego masa árĩñorã. ");
INSERT INTO des_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eropirã erã Felipe pohrogue erañorã. Felipepʉ Betsaida waĩcʉri maca Galilea yeba árĩri maca majagʉ árĩmi. Eropirã ĩgʉ pohrogue erarã õpa arĩñorã ĩgʉre: —Jesure ĩadiaca gʉa, arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Erã eroparĩcʉ̃ peegʉ Felipe Andreguere weregʉ wapʉ. Eropirã erã perã Jesure werema. ");
INSERT INTO des_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Erã werera pʉhrʉ Jesu gʉare weremi: —Yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ ãhraa. Yʉre árĩpehrerã umupeoburisubu árĩro iiaa dohpaguere. Dohpaguere yʉ sĩriburisubu árĩro ta iiaa. ");
INSERT INTO des_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Diaye mʉare arĩgʉ iiaa. Oteriyere yebague yaabiricʉ̃, iriyere otebiricʉ̃ yujuye ta dujaroca. Eropiro iriyere mari otera pʉhrʉ bajayeri dʉcasiua. Eropa ta yʉ sĩrira pʉhrʉ yʉre erã yaara pʉhrʉ bajarã masare Goãmʉ mera eropa árĩniguimorãre iigʉca yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","I yeba mʉa árĩrire wʉaro pepiboca mʉa. Eropa pepirã Goãmʉre guñabirã peamegue warãca mʉa. I yeba mʉa árĩrire eropa pepicãrã, Goãmʉ mera eropa árĩniguirãca. ");
INSERT INTO des_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yahare iidiarã, yʉ buherire õaro peeque mʉa. Mʉa eropa iirã mʉa sã yʉ árĩboroguere árĩrãca. Yahare iigʉre yʉ Pagʉpʉ umupeogʉcumi, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Õpa arĩnemomi gʉare. —Dohpaguere yʉhʉ ñero sĩporãcʉa. ¿Yʉ Pagʉre dohpa arĩgʉcuri yʉhʉ? “¿Ahʉ, yʉ ñero tariborore tauque,” ¿arĩbocuri yʉhʉ? Irire arĩbeaa yʉhʉ. Ñero taribu ta i yebaguere aribʉ. Eropiro yʉ ñero tariburisubu dohpaguere ãhraa, arĩ weremi Jesu gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Eropigʉ õpa arĩmi ĩgʉ Pagʉre: —Ahʉ, mʉ turagʉ árĩrire dohpaguere ĩhmuque masare, arĩmi Jesu ĩgʉ Pagʉre. Ĩgʉ eroparĩcʉ̃ ʉmarogue wereniguiro caribʉ. —Turagʉ yʉ árĩrire masare ĩhmutuhabʉ. Dohpaguere eropiigʉ dipaturi ĩhmugʉca masare, arĩro caribʉ. ");
INSERT INTO des_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Eroparĩcʉ̃ peerã ero niguirã masa bajarã õpa arĩma: —Bupu árĩcumi eropa bʉsʉgʉ, arĩma masa. —Anyu Jesure weregʉ iiami, arĩma gajirã masa. ");
INSERT INTO des_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Õpa arĩmi Jesupʉ: —Ʉmarogue yʉre peedorero eropa bʉsʉbiro carabʉ. Mʉapʉre peedorero eropa carabʉ. ");
INSERT INTO des_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Dohpaguere i yeba majarã erã ñeri iira dipuwaja dipuwajacʉrãcoma. I yeba majarã erã opʉre watĩre Goãmʉ cóãgʉcumi. ");
INSERT INTO des_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Eropigʉ crusague yʉre erã aĩ wahgũ nugucʉ̃ bajarã masare yaharã árĩmorãre iigʉca yʉhʉ, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Eropa arĩgʉ crusague ĩgʉ sĩriborore weregʉ iimi Jesu masare. ");
INSERT INTO des_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ĩgʉ eroparĩcʉ̃ peerã masapʉ ĩgʉre õpa arĩma: —Goãmʉ yare erã gojarapũ õpa arãa: “Cristo árĩpehrerinʉri árĩgʉcumi,” arĩ gojañuma. ¿Ĩgʉ eropa arĩ gojacʉ̃ mʉre masʉre Goãmʉ ĩgʉ obeodigʉre dohpa arĩronore mʉre wejẽ crusague aĩ wahgũrãcuri masa? ¿Goãmʉ ĩgʉ obeodigʉ noa ãhriri ĩgʉ? ¿Cristo árĩbeari mʉhʉ? arĩ serẽpima erã Jesure. ");
INSERT INTO des_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Erã eroparĩcʉ̃ õpa arĩ yʉhrimi Jesu: —Boyoriñe iro dopa árĩgʉ masare Goãmʉ yare õaro masicʉ̃ iiaa yʉhʉ. Pʉhrʉñarigã mʉa mera árĩsome yʉhʉ. Mʉare yʉ buhecʉ̃ dohpaguere peeque ñerire mʉa iibiriburire, Goãmʉ mera mʉa eropa árĩniguiburire. Yʉ buherire peebirã naitĩaro curirã iro dopa erã waborore masibeama. ");
INSERT INTO des_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Eropigʉ boyoriñe iro dopa ta árĩgʉ yʉhʉ ta ãhraa. Eropigʉ mʉare buhegʉ Goãmʉ yare õaro masicʉ̃ iiaa mʉare. Dohpaguere yʉ waboro core yʉre umupeoque. Eropa umupeorã yaharã árĩrãca mʉa, arĩmi Jesu. Eropa arĩ weretuha waha wami erãre duhri wahgãgʉ. ");
INSERT INTO des_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bajasuburi Goãmʉ turari mera erãre Jesu ĩgʉ deyoro moarire ii ĩhmuquerecʉ̃ ta judio masa bajarã ĩgʉre ne peediabirima. ");
INSERT INTO des_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Goãmʉ yare erã gojarapũ Isaia mʉrʉ ĩgʉ gojadiro dopa ta eropa iirã iima erã. Õpa arĩ gojañumi Isaia: Goãmʉ, mʉ buherire gʉa werecʉ̃ masa peediabeama. Mʉ turarire erãre mʉhʉ ii ĩhmuquerecʉ̃ ta irire “Diaye árĩbeaa,” arĩma erã, arĩ gojañumi Isaia Goãmʉ yare gojarapũgue. ");
INSERT INTO des_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Erã eropa peediabiricʉ̃ ĩagʉ Goãmʉ erãre masibiricʉ̃ iiñumi. Iri sãre Isaia õpa arĩ gojañumi daja: ");
INSERT INTO des_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Cuiri ĩhajabirã iro dopa árĩcʉ̃ iidi árĩmi Goãmʉ erãre. Eropigʉ ĩgʉ yare masibiricʉ̃ iidi árĩmi erãre. Eropirã ĩgʉ turarire erã ĩaquererã ta erã ĩarare masibirinirã árĩma erã. Eropirã ĩgʉ buherire peequererã ta irire masibirinirã árĩma erã. Goãmʉ yare masirã erã ñerire cóãdoreboñuma. Eropigʉ erãre tauboñumi ĩgʉ, arĩ gojañumi Isaia Goãmʉ yare erã gojarapũgue. ");
INSERT INTO des_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia Cristo turarire masiyudigʉ eropa arĩ gojamʉhtañumi. ");
INSERT INTO des_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gajirã Jesure erã umupeobiriquerecʉ̃ ta judio masa sã oparã mera majarã sã bajarã Jesure umupeonirã árĩma. Eropa erã umupeoquererã ta erã fariseo masare güirã gajirã masare Jesure erã umupeorire werebirinirã árĩma. Irire erã werecʉ̃ peerã gʉa judio masa buheri wihigue erãre ñajadorebiriboñuma fariseo masapʉ. ");
INSERT INTO des_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Goãmʉre mucubiricʉ̃ iidiaquererã ta erã tauro masapʉre mucubiricʉ̃ iidianirã árĩma erã. Eropirã erã Jesure ne umupeorã “Jesu yarã ãhraa,” arĩ gajirãre werediabirinirã árĩma. ");
INSERT INTO des_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Masa bajarã gʉa pohro gamenerenirãre Jesu turaro bʉsʉro mera weremi: —Yʉre umupeogʉ yʉ dihtare umupeobeami. Yʉre obeodigʉ sãre umupeomi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Eropirã yʉre masirã yʉre obeodigʉ sãre masima. ");
INSERT INTO des_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yʉhʉ boyoriñe iro dopa ta árĩgʉ yʉhʉ Goãmʉ yare buhegʉ ahraa i yebaguere. Eropigʉ Goãmʉ yare mʉare masicʉ̃ iiaa. Yʉre umupeogʉ naitĩaro wagʉ iro dopa ñerire iiniguisome. Yʉre umupeogʉ diaye pepigʉcumi. ");
INSERT INTO des_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Gajirã yʉ wererire peequererã ta irire yʉhribeama. Erã eropa yʉhribiriquerecʉ̃ ta, erã yʉhribirira dipuwaja moasome yʉpʉ dohpa. I yebaguere dipuwaja moagʉ arigʉ aribiribʉ yʉhʉ. I yeba majarãre peamegue wabonirãre taugʉ arigʉ aribʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yʉre gamebigʉre yʉ wereri sãre gamebigʉre dipuwaja moari árĩroca. Ĩgʉ yʉre peebirira dipuwaja i ʉmʉ pehrecʉ̃ dipuwajacʉgʉcumi. ");
INSERT INTO des_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉhʉ yʉ gamero werebeaa. Yʉ Pagʉ yʉre obeodigʉpʉ yʉre weredoremi. Eropiro yʉ wereripʉ ĩgʉ ya wereniguiri ãhraa. ");
INSERT INTO des_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ĩgʉ ya wereniguirire peerã Goãmʉ mera eropa árĩniguirãca mʉa. Eropigʉ yʉ Pagʉ ĩgʉ weredorediro dopa ta werea mʉare, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","Eropi Pascua bosenʉ coregã árĩbʉ. Iri ñamire Jesu gʉa ĩgʉ buherã mera iri bosenʉre babu árĩmi. Eropigʉ i yebare ĩgʉ wiriaborore ĩgʉ Pagʉ pohro waburire merogã dʉhyacʉ̃ masidigʉ árĩmi Jesu. Gʉa barisubu Judare watĩ doretuhadigʉ árĩmi ĩgʉ pepirigue. Eropigʉ ĩgʉre Simo Iscariote magʉre Jesure ĩhaturirãre iri ñamire ĩgʉ wiaburire doretuhadigʉ árĩmi. Jesu ĩgʉ yarãre i yeba árĩrãre bʉrigã mahidigʉ árĩmi. Eropigʉ ĩgʉ mahirare ĩhmubu gʉa guburire coemi. Ĩgʉ Goãmʉ pohrogue ĩgʉ arirare, pʉhrʉ ĩgʉ ʉmarogue ĩgʉ mʉriaburi sãre masidigʉ árĩmi. Ĩgʉ Pagʉ Goãmʉ ĩgʉre árĩpehrerã weca opʉ ĩgʉ apira sãre masidigʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eropa masiqueregʉ wahgãnʉgaja, ĩgʉ suhriro weca majañere tuwea suhriro gasiro mera ĩgʉ paru yʉjʉre dirimi. ");
INSERT INTO des_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dirituha soropa mera decore pisã, gʉare ĩgʉ buherãre gʉa guburire coenʉgami. Gʉare coetuha ĩgʉ dirira gasiro mera tucoemi gʉa guburire. ");
INSERT INTO des_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Gajirã buherãre coegã, Simo Pedroguere ejami. Ĩgʉ guburire ĩgʉ coeboro core, Pedropʉ ĩgʉre õpa arĩmi: —Opʉ, ¿yʉ guburire coebu iiri mʉhʉ? arĩmi Jesure Pedro. ");
INSERT INTO des_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Dohparagã yʉhʉ mʉre iiburire masibeaa mʉhʉ. Eropa masibiriqueregʉ ta pʉhrʉ masigʉca, arĩmi Jesu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Yʉ guburire ne coesome mʉhʉ, arĩmi Pedro. —Mʉre yʉ coebiricʉ̃ yahagʉ árĩsome mʉhʉ, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Opʉ, yʉ guburi dihtare coebiricãque. Yʉ guburire, yʉ mojotorire, yʉ dipuru sãre coeque, arĩmi Pedro. ");
INSERT INTO des_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ĩgʉ eroparĩcʉ̃ Jesu õpa arĩmi: —Yujugʉ masʉ guhagʉ ĩgʉ dʉpʉre õaro tucoepehomi. Eropiro ĩgʉre dipaturi tucoema masiya mara. Ĩgʉ guburi dihtare coero gahmea. Árĩpehrerã mʉa ñeri iirare coenirã mʉa árĩquerecʉ̃ ta yujugʉ mʉa mera majagʉ ĩgʉ ñerire coeya marigʉ ãhrimi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu ĩgʉre ĩhaturirãre wiabure masituhañumi. Eropa masigʉ “Yujugʉ mʉa mera majagʉ ĩgʉ ñerire coeya marigʉ ãhrimi,” arĩñumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gʉa guburire coetuha, suhrirore sañatuha, doajami daja ĩgʉ doadiro ta. Tuhaja õpa arĩmi gʉare: —¿Dohparagã yʉhʉ mʉare iirare masiri mʉa? ");
INSERT INTO des_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mʉa yʉre “Buhegʉ,” arĩ piyurã, “Opʉ,” arĩ piyurã diaye ta arĩrã iiaa yʉre. Mʉare buhegʉ, mʉa opʉ diaye ta ãhraa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eropirã yʉhʉ mʉare buhegʉ, mʉa opʉ árĩqueregʉ ta mʉa guburire yʉ coecʉ̃ mʉa sã mʉa mera majarãre guburire coeque. ");
INSERT INTO des_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dohparagã mʉa iiburire mʉare ĩhmuabʉ. Mʉa mera majarãre mʉa itamuburire mʉare ĩhmuabʉ. Mʉare yʉ iidiro dopa ta mʉa sã iique. ");
INSERT INTO des_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Diaye mʉare arĩgʉ ta iiaa. Mʉa yʉ pohro majarã dopa árĩrã yʉ tauro árĩbeaa. Mʉare buhedore yʉ obeorã ãhraa mʉa. Eropirã yʉ tauro árĩbeaa mʉa. Eropa iigʉ ta “Yʉ iidiro dopa ta iique,” arãbʉ yʉhʉ mʉare. ");
INSERT INTO des_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ire mʉa masirã, yʉ dorerire iirã, mucubirirã árĩrãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mʉare árĩpehrerãre eropa arĩbeaa. Yʉ beyenirãre masia yʉhʉ. Goãmʉ yare erã gojarapũ arĩdiro dopa ta eropa waroca. “Yʉ mera bagʉ ta yʉre wejẽdiami,” arĩ gojañuma Goãmʉ yare erã gojarapũgue. ");
INSERT INTO des_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ĩgʉ yʉre eropa wiaboro core ire wereyugʉ iiaa mʉare. Yʉre ĩgʉ eropa iira pʉhrʉ “Jesu ta Cristo Goãmʉ ĩgʉ obeodigʉ ãhrimi,” mʉa arĩburire ire mʉare wereyugʉ iiaa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Diaye ta mʉare arĩgʉ iiaa. Yʉ obeonirãre gamegʉ yʉ sãre gahmemi ĩgʉ. Eropigʉ yʉre gamegʉ yʉre obeodigʉ sãre gahmemi ĩgʉ, arĩmi Jesu gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Eropa arĩ weretuha Jesu turaro bʉjaweremi. Eropa bʉjaweregʉ õpa arĩ weremi ĩgʉ gʉare. —Diaye mʉare arĩgʉ iiaa. Yujugʉ mʉa mera majagʉ yʉre ĩhaturirãre wiagʉcumi, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ĩgʉ eroparĩcʉ̃ peerã Jesure wiabure masibirã, gʉa game ĩhamehtubʉ. ");
INSERT INTO des_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yʉhʉ ĩgʉ buherã mera majagʉ Jesu ĩgʉ mahigʉpʉ ĩgʉ pohro doabʉ. ");
INSERT INTO des_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Eropigʉ Simo Pedro yʉre ĩgʉ mojoto mera sĩpu serẽpidoremi Jesure ĩgʉre wiabure: ");
INSERT INTO des_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eropigʉ yʉpʉ Jesu pohro doadigʉ serẽpiñabʉ ĩgʉre: —Opʉ, ¿nihire arĩgʉ iiri mʉhʉ? arĩbʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Iru panrure mohwa aĩ, yʉhʉ yoso ogʉ ĩgʉ ta ãhrimi yʉre wiabu, arĩmi Jesu. Eropa arĩtuha iriru panrure ĩgʉ mohwarañere yosotuha Judare Simo Iscariote magʉre omi. ");
INSERT INTO des_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Eropigʉ panre ĩgʉ ora pʉhrʉ watĩpʉ Judare ñero iidoredigʉ árĩmi. Eropigʉ Jesu ĩgʉre õpa arĩmi: —Mʉ iiburire yojaro mera ii purumujuque mʉhʉ, arĩmi Jesu Judare. ");
INSERT INTO des_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ĩgʉ eroparĩcʉ̃ peerã gʉa mesague doanirã Jesu Judare ĩgʉ arĩrare masibiribʉ. ");
INSERT INTO des_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yujurãyeri gʉa õpa arĩ pepiribʉ: “Juda gʉa niyerure dibugʉ ãhrimi. Eropigʉ bosenʉ gʉa baburire asũdoregʉ obeoami Jesu Judare. Mojomorocʉrãre niyerure odoregʉ iiami Jesu,” arĩ pepiribʉ gʉa yujurãyeri. ");
INSERT INTO des_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Eropigʉ Juda iri panre ñeatuha wiria wami. Ĩgʉ wiriarasubure ñami árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ĩgʉ wiriara pʉhrʉ gʉare õpa arĩmi Jesu: —Dohpague tamerare yʉhʉ masʉ Goãmʉ ĩgʉ obeodigʉ yʉ turagʉ árĩrire ĩhmugʉcumi Goãmʉ masare. Eropigʉ Goãmʉ ĩgʉ turagʉ árĩrire ĩhmugʉca yʉpʉ. ");
INSERT INTO des_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Eropigʉ Goãmʉ turarire yʉ ĩhmucʉ̃ ĩgʉ yʉ turari sãre dohparagã ĩhmu purumujugʉcumi. ");
INSERT INTO des_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉ porã, yʉre peeque. Bajamenʉrigã mʉa mera árĩnigʉca. Yʉre amarãca mʉa. Eropigʉ judio masare yʉ arĩdiro dopa ta mʉa sãre arãa. “Yʉ waborore mʉapʉ wamasibeaa,” erãre yʉ arĩdiro dopa ta mʉa sãre werea. ");
INSERT INTO des_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mama doreriñere mʉare weregʉra. Mʉa mera majarãre mahique mʉa. Mʉare yʉ mahidiro dopa ta mʉa mera majarãre mahi umupeoque. ");
INSERT INTO des_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Eropirã mʉa mera majarãre mʉa mahicʉ̃ ĩha gajirã yaharã mʉa árĩcʉ̃ ĩha masirãcoma, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ĩgʉ eroparĩcʉ̃ Simo Pedro Jesure serẽpimi: —Opʉ, ¿nohogue wagʉcuri mʉhʉ? arĩmi Pedro. Ĩgʉ eroparĩcʉ̃ Jesu yʉhrimi: —Yʉ waboroguere dohpaguere yʉ mera wamasibeaa mʉhʉ. Dohpaguere wamasibiriqueregʉ ta pʉhrʉ yʉ pohro wagʉca, arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro arĩmi: —Opʉ, ¿duhpigʉ dohpaguere mʉ mera wamasibiribocuri yʉhʉ? Yʉre erã wejẽdiaquerecʉ̃ yʉhʉ mʉre duhusome. Itamugʉca, arĩmi Pedro Jesure. ");
INSERT INTO des_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Mʉ eropa arĩgʉ diaye ta yʉre itamugʉcuri? Diaye mʉre weregʉ iiaa. “Jesure masibeaa,” arĩgʉca mʉhʉ gajirãre. Ʉhresubu eropa arĩgʉca cãreña ĩgʉ wereboro core, arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Pʉhrʉ Jesu gʉare õpa arĩ weremi: —Ne bʉjawere wʉaro guñaricʉbiricãque. Goãmʉre “Diaye ta iigʉ ãhrimi,” arĩ umupeoque. Eropirã yʉ sãre eropa umupeoque. ");
INSERT INTO des_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉ Pagʉ ĩgʉ árĩroguere baja wiri ãhraa. Mʉa árĩborore amuyugʉ wagʉra. Iri diaye ta ãhraa. Eropigʉ mʉare irire werea. ");
INSERT INTO des_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Eropigʉ mʉa árĩborore amutuha, dujarigʉra yʉhʉ. Eropigʉ yʉ pohrogue mʉa árĩmorãre aĩgʉ arigʉra yʉhʉ daja. ");
INSERT INTO des_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Eropirã yʉ waburi mare masia mʉa, arĩmi Jesu gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—Opʉ, mʉ waborore masibeaa gʉa. ¿Eropirã dohpa ii mʉ waburi mare masirãcuri gʉa? arĩ serẽpimi Toma Jesure. ");
INSERT INTO des_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ĩgʉ eropa arĩ serẽpicʉ̃ Jesupʉ yʉhrimi: —Goãmʉ pohrogue wari maha iro dopa árĩgʉ tiiaa yʉhʉ. Eropigʉ diaye árĩrire weregʉ árĩcãgʉ tiiaa yʉhʉ. Eropigʉ ʉmaroguere ojocariniguicʉ̃ iigʉ árĩgʉ tiiaa yʉhʉ. Eropirã yʉre umupeorã dihta yʉ Pagʉ pohrogue warãcoma. ");
INSERT INTO des_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nere yʉre masirã árĩrã, yʉ Pagʉ sãre masiboaya mʉa. Dohpaguere ĩgʉre ĩhaa mʉa. Eropirã ĩgʉre masituhabʉ mʉa, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ĩgʉ eroparĩcʉ̃ Felipe õpa arĩmi: —Opʉ, mari Pagʉre ĩhmuque gʉare. Iripẽta gahmea gʉa, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ĩgʉ eroparĩcʉ̃ Jesu weremi: —Felipe, ¿yoari boje yʉ mera árĩqueregʉ ta, mʉ masinibeari yʉre? Yʉre ĩagʉ yʉ Pagʉ sãre ĩatuhami. “Eropigʉ mari Pagʉre ĩhmuque gʉare,” ¿duhpigʉ eropa arĩri mʉhʉ yʉre? ");
INSERT INTO des_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yʉ Pagʉ mera yujugʉ ta ãhraa yʉhʉ. Irire “Diaye árĩbeaa,” ¿arĩgʉ meje iiri mʉhʉ? Mʉare weregʉ yʉ gamero weregʉ iibeaa. Yʉ Pagʉre werebasagʉ iiaa. Eropigʉ ĩgʉ yʉ mera árĩgʉ ĩgʉ turari mera ii ĩhmumi. ");
INSERT INTO des_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yʉhʉ, yʉ Pagʉ mera yujugʉ ta ãhraa. Yʉ eroparĩcʉ̃ irire “Diaye ta ãhraa,” arĩ pepique mʉa. Irire “Diaye ta árĩbeaa,” arĩdiarã, Goãmʉ turari mera deyoro moarire yʉ ii ĩhmurire ĩaque. Eropa ĩara pʉhrʉ yʉ Pagʉ mera yʉ yujugʉ ta árĩrire “Diaye ta ãhraa,” arĩ pepique mʉa. ");
INSERT INTO des_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Diaye mʉare arĩgʉ iiaa. Yʉre umupeogʉ yʉ iidiro dopa ta iigʉcumi. Eropigʉ ĩgʉpʉ yʉ tauro iigʉcumi. Yʉ Pagʉ pohrogue wabu iiaa dohpaguere. Eropigʉ yʉre umupeogʉ yʉ tauro Goãmʉ turari mera ii ĩhmugʉcumi. ");
INSERT INTO des_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eropigʉ yʉre umupeorãre erã yʉ waĩ mera serẽropẽ ta iigʉra. Eropa iigʉ yʉ Pagʉ ĩgʉ turarire ii ĩhmugʉca. ");
INSERT INTO des_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yʉre umupeorã mʉa árĩcʉ̃ mʉa serẽropẽ ta iigʉra, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Eropa arĩtuha gʉare õpa arĩnemomi: —Yʉre mʉa mahirã, yʉ dorerire iipehorãca. ");
INSERT INTO des_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yʉ Pagʉre serẽgʉra. Yʉ eropa serẽcʉ̃ yʉ Pagʉpʉ gajigʉre mʉare itamubure mʉare obeogʉcumi. Eropigʉ ĩgʉ mʉare itamubupʉ ʉmʉri nʉcʉ mʉa mera árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ĩgʉ diaye majare weregʉ Espíritu Santo ãhrimi. I yeba majarãpʉ Espíritu Santore masibeama. Eropirã ĩgʉre opamasibeama. Ĩgʉ ta mʉa mera árĩgʉcumi. Eropirã mʉa ĩgʉre oparãca. Eropirã ĩgʉre masia mʉa. ");
INSERT INTO des_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mʉare cóãsome yʉhʉ. Mʉa mera árĩbu dujarigʉca yʉhʉ daja. ");
INSERT INTO des_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Merogã dʉhyaa yʉ waboro. Yʉ wara pʉhrʉ i yeba majarã yʉre umupeobirinirã yʉre dipaturi ĩasome. Mʉapʉ yʉre ĩarãca. Yʉ ojocaricʉ̃ mʉa sã ʉmʉri nʉcʉ Goãmʉ mera ojocarirãca. ");
INSERT INTO des_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Irinʉ yʉ dujariburinʉre yʉhʉ, yʉ Pagʉ mera yujugʉ ta yʉ árĩcʉ̃ masirãca mʉa. Eropirã yʉ mera mʉa árĩcʉ̃ mʉa mera yʉ árĩcʉ̃ sãre masirãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉ dorerire iigʉ yʉre mahigʉ ta ãhrimi. Eropigʉ yʉre mahigʉre yʉ Pagʉpʉ mahigʉcumi. Eropigʉ yʉ sã ĩgʉre mahigʉca. Eropigʉ ĩgʉre yʉre õaro masicʉ̃ iigʉca, arĩmi Jesu gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Gʉa mera majagʉ gajigʉ Juda waĩcʉgʉ árĩmi Iscariote árĩbigʉ. Õpa arĩmi ĩgʉ Jesure. —Opʉ, ¿dohpa iigʉcuri mʉhʉ gʉare eropa arĩgʉ? ¿I yeba majarãre mʉre masicʉ̃ iibigʉ dohpa iigʉcuri mʉhʉ gʉa dihtare mʉre masicʉ̃ iigʉ? arĩ serẽpimi Juda. ");
INSERT INTO des_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ĩgʉ eroparĩcʉ̃ Jesu yʉhrimi: —Yʉre mahirã yʉ dorerire õaro iima. Erã eropa iicʉ̃ yʉ Pagʉpʉ erãre mahigʉcumi. Eropirã erã mera árĩrã árĩrãca gʉa. ");
INSERT INTO des_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yʉre mahibigʉ yʉ dorerire iibeami. Eropiro yʉ wereri mʉa peerapʉ yʉ wereniguiri árĩbeaa. Yʉre obeodigʉ ya wereniguiripʉ ãhraa. Ĩgʉ yʉ Pagʉ ta ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mʉa mera árĩnigʉ ire mʉare wereniguigʉ iiaa. ");
INSERT INTO des_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pʉhrʉ yʉ serẽcʉ̃ yʉ Pagʉ Espíritu Santore obeogʉcumi mʉare. Eropigʉ Espíritu Santopʉ mʉare itamubu árĩgʉ, mʉare buhepehogʉcumi ĩgʉ. Eropigʉ mʉare yʉ wererare guñacʉ̃ iigʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mʉare õaro árĩcʉ̃ iigʉca yʉhʉ. Yʉhʉ õaro árĩdiro dopa ta õaro árĩcʉ̃ iigʉca mʉare. I yeba majarã erã iidiro dopa iisome yʉhʉ. Yʉ tamera diaye õaro árĩcʉ̃ iigʉca mʉare. Bʉjawere wʉaro guñaricʉbiricãque mʉa. Eropirã güibiricãque mʉa. ");
INSERT INTO des_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yʉhʉ wagʉca. Eropigʉ mʉa mera árĩbu dujarigʉca daja,” mʉare yʉ eropa arĩ werecʉ̃ peetuhabʉ mʉa. Irire masirã árĩrã mucubiriboaya mʉa. Yʉre mʉa diaye mahinirã árĩrã mucubiriboaya mʉa. Yʉ Pagʉpʉ yʉ tauro turami. Eropirã ĩgʉ pohrogue yʉ waborore mʉa masira pʉhrʉ yʉre mahirã mucubiriboaya mʉa. ");
INSERT INTO des_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yʉre mʉa umupeoburire yʉ waborore wereyugʉ iiaa mʉare. ");
INSERT INTO des_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“I yeba majarã opʉ watĩ doregʉ iimi dohpaguere. Eropigʉ ĩgʉ eropa dorecʉ̃ yʉhʉ mʉa mera wereniguituboro merogã dʉhyaa. Ĩgʉpʉ yʉre tarinʉgamasibeami. ");
INSERT INTO des_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yʉre yʉ Pagʉ ĩgʉ dorero dopa ta iiaa yʉhʉ. Eropa ta iiaa yʉhʉ yʉ Pagʉre yʉ mahirire i yeba majarã erã masiburire. “Wahgãnʉgajaque. Ina warã, arĩmi Jesu gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Eropigʉ werenigui queori mera buhegʉ gʉare õpa arĩmi Jesu: —Yʉhʉ iguiru diaye majaru iro dopa árĩgʉ ãhraa. Yʉ Pagʉpʉ iguirure ĩhadibugʉ iro dopa árĩgʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iguirure iri dʉpʉri gamesʉriro dopa ta mʉa yaharã yʉ mera ãhraa. Dʉca mariri dʉpʉrire iguirure ĩhadibugʉ ĩgʉ peha cóãro dopa ta yʉ Pagʉ ĩgʉ gamerire iibirãre cohãmi. Dʉcacʉri dʉpʉrire iguirure ĩhadibugʉ ĩgʉ amuro dopa ta yʉ Pagʉ ĩgʉ gamerire iirãre itamugʉcumi ĩgʉ “Yʉ gamerire iinemoporo,” arĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yʉ wererire peerã, “Diaye ta ãhraa,” arãa mʉa. Eropigʉ yʉ Pagʉ mʉa ñeri iirare cóãtuhami. ");
INSERT INTO des_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yʉre gamesʉriro dopa ta yʉ mera majarã árĩque mʉa. Eropigʉ mʉa mera árĩgʉca. Iguiru dʉpʉri iguiru mera gamesʉribiro árĩro iri dʉpʉripʉ dʉca mara. Eropa ta yʉ mera majarã õaro árĩbirã sã yʉ Pagʉ gamerire iimasibeaa mʉa. ");
INSERT INTO des_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Iguirure iri dʉpʉri gamesʉriro dopa ta mʉa yaharã yʉ mera ãhraa. Iri dʉpʉri iguirure õaro gamesʉriro árĩro dʉcacʉa. Mʉa sã yʉre õaro gamesʉrirã yʉ Pagʉ gamerire iiaa. Yʉre gamesʉrirã árĩbirã ĩgʉ gamerire iimasibeaa mʉa. ");
INSERT INTO des_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ñeri dʉpʉrire tʉrira dʉpʉre ĩgʉ cóãboro dopa ta yʉ mera majarã árĩbirãre yʉ Pagʉ cóãgʉcumi. Iri dʉpʉri ñaicʉ̃ ĩha iguirure ĩhadibugʉ iri dʉpʉrire aĩ gameneo peamegue soecãgʉcumi. Eropa ta iigʉcumi Goãmʉ yʉ mera majarã árĩbirãre. ");
INSERT INTO des_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Yʉ mera majarã árĩrã yʉ buherire cãdijibiriboca mʉa. Eropa cãdijibirã mʉa gameropẽ ta yʉre serẽque. Eropigʉ mʉa serẽropẽ ta ogʉra. ");
INSERT INTO des_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yʉ Pagʉ gamerire mʉa iirã árĩcʉ̃ ĩarã, “Oã Jesu yarã ãhrima,” arĩ masirãcoma gajirã masa. Eropirã mʉare ĩarã yʉ Pagʉre umupeorãcoma. ");
INSERT INTO des_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉ Pagʉ ĩgʉ yʉre mahidiro dopa ta yʉ sã mʉare mahia. Eropirã yʉ mahiri mera árĩque mʉa. ");
INSERT INTO des_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉ Pagʉ ĩgʉ dorerire iiaa yʉhʉ. Eropigʉ ĩgʉ mahigʉ árĩniguia yʉhʉ. Eropa ta mʉa sã yʉ dorerire iirã yʉ mahirã árĩniguicãrãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ire mʉare wereabʉ yʉ mera mʉa õaro mucubiriborore. Eropirã turaro mucubirirãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Õpa dorea mʉare: Mʉare yʉ mahidiro dopa ta mʉa mera majarãre mʉa sã mahique. ");
INSERT INTO des_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yujugʉ masʉ ĩgʉ mera majagʉ yañe árĩborañe sĩrigʉ ĩgʉ mera majagʉre bʉrigã mahiami gajirã mahidiro tauro. ");
INSERT INTO des_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eropirã yʉ dorerire iirã yʉ mera majarã ãhraa mʉa. ");
INSERT INTO des_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Diaye ta mʉa yʉ mera majarã gohra ãhraa. Mʉa eropa árĩrã árĩcʉ̃ árĩpehrerire yʉ iirare werea mʉare. Pohro majagʉ ĩgʉ opʉ iiburire masibeami ĩgʉ. Eropigʉ “Yʉ pohro majarã bu árĩrã ãhraa mʉa,” arĩbeaa mʉare. Yʉ Pagʉ ĩgʉ yʉre wererare mʉare werepehoabʉ. Eropa weregʉ “Yʉ mera majarã ãhraa mʉa,” mʉare arãa dohpaguere. ");
INSERT INTO des_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉapʉ yʉre beyebiribʉ. Yʉpʉ mʉare beyebʉ yʉ Pagʉ gamerire mʉa iimorãre. Mʉa eropa iicʉ̃ mʉa eropa iiri ne yuju diaye gohra árĩsome. Mʉa eropa iicʉ̃ yʉre mʉa umupeocʉ̃ yʉ Pagʉ mʉa serẽropẽ ta mʉare ogʉcumi. ");
INSERT INTO des_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ire mʉare dorea yʉhʉ: Mʉa basi game mahi umupeoque, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Eropigʉ gʉare werenemomi daja: —I yeba majarã mʉare erã ĩhaturicʉ̃ ĩarã ire guñaque mʉa: “Gʉare eropa ĩhaturiboro core Jesupʉre ĩhaturinʉgatuhama erã,” arĩ guñaque. ");
INSERT INTO des_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","I yeba majarã gohra mʉa árĩcʉ̃, erã mera majarãre erã mahidiro dopa ta mʉa sãre mahiboañuma erã. I yeba majarã mera mʉa árĩnicʉ̃ mʉare beyebʉ. Eropirã dohpaguere i yeba majarã gohra árĩbeaa mʉa. Mʉa eropa árĩbiricʉ̃ ĩarã i yeba majarã mʉare ĩhaturima. ");
INSERT INTO des_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mʉa yaharã árĩrã “Yʉ tauro árĩbeaa,” mʉare yʉ arĩrare guñaque mʉa. Eropa yʉ mera majarã árĩrã yʉ ñero tariboro dopa ta ñero tarirãca mʉa sã. Yʉre ñero iinirã ta mʉa sãre ñero iirãcoma. Yʉ buherire yʉhrinirã ta mʉa buheri sãre yʉhrirãcoma. ");
INSERT INTO des_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","I yeba majarã yʉre obeodigʉre masibeama. Eropirã yʉre umupeorã mʉa árĩcʉ̃ ñero iirãcoma erã mʉare. ");
INSERT INTO des_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Erãre yʉ buhegʉ aribiricʉ̃ erã yʉre gamebirira dipuwaja mariboaya. Dohpaguere erãre yʉ buhera pʉhrʉ “Ñeri dipuwaja mara gʉare,” arĩmasibeama erã. ");
INSERT INTO des_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yʉre ĩhaturigʉ yʉ Pagʉ sãre ĩhaturimi. ");
INSERT INTO des_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Goãmʉ turari mera gajirã erã ne iibirirare ii ĩhmubʉ. Eropiro erãre irire yʉ ii ĩhmubiricʉ̃ erã peebirira dipuwaja mariboaya. Goãmʉ turari mera yʉ ii ĩhmurare erã ĩara pʉhrʉ yʉre yʉ Pagʉ sãre ĩhaturima erã. ");
INSERT INTO des_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Eropa ĩhaturirã Goãmʉ yare erã gojarapũ matague ta erã arĩ gojadiro dopa ta iirã iima erã. Õpa arĩ gojañuma: “Erãre yʉ ñero iibiriquerecʉ̃ ta yʉre ĩhaturima erã,” arĩ gojañuma matague ta Goãmʉ yare erã gojarapũgue, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Eropigʉ werenemomi daja: —Yʉ pʉhrʉgue mʉare itamubu, yʉ Pagʉ mera árĩgʉ mʉare yʉ obeobu Espíritu Santo ta ãhrimi. Ĩgʉ diaye majare weregʉ ta ãhrimi. Eropigʉ ĩgʉ arigʉ yʉ árĩricʉrire weregʉcumi mʉare. ");
INSERT INTO des_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mʉare yʉ buhenʉgacʉ̃gue mʉa sã yʉ mera ʉmʉri nʉcʉ árĩbʉ. Mʉa sã yʉ árĩricʉrire wererãca, arĩ weremi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Eropa arĩtuha gʉare õpa arĩ werenemomi: —Pʉhrʉ yʉ buherire yʉ sãre mʉa cóãbiriburire õpa weregʉra mʉare. ");
INSERT INTO des_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mari buheri wirigue mʉa ñajadiacʉ̃ ñajadoresome mʉare yaharã mʉa árĩri dipuwaja. Eropirã mʉare gajisubu wejẽ “Goãmʉ gamerire iirã iiaa,” arĩ pepirãcoma gajirã. ");
INSERT INTO des_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yʉ Pagʉre, yʉ sãre erã masibeama. Eropa masibirã mʉare ñero iirãcoma erã. ");
INSERT INTO des_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Eropirã mʉare erã ñero erã iicʉ̃ ĩarã, “Erã õpa iiboro core ta Jesu gʉare weremʉhtayutuhami,” arĩ guñarãca mʉa. Mʉa eropa arĩ guñaburire dohpaguere ire weremʉhtagʉ iiaa mʉare, arĩ weremi Jesu. Eropa arĩtuha õpa arĩ werenemomi: —Neguere mʉa mera árĩgʉ ire mʉare werebiribʉ. ");
INSERT INTO des_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dohpaguepʉre yʉre obeodigʉ pohrogue wagʉca. “¿Nohogue wagʉcuri mʉhʉ?” arĩ ne yujugʉ yʉre serẽpibeaa mʉa yʉre. ");
INSERT INTO des_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Eropa serẽpibiriquererã ta yʉ waborore mʉare werecʉ̃ mʉa ñero sĩporãcʉa. ");
INSERT INTO des_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mʉa ñero sĩporãcʉquerecʉ̃ mʉare õpa diaye ta werea: Yʉ wara pʉhrʉ mʉare õacãroca. Yʉ ʉmarogue wabiricʉ̃ mʉare itamubupʉ aribiribocumi. Eropa wagʉ eja mʉare ĩgʉre obeogʉca yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yʉ eropa obeocʉ̃ ĩgʉ arigʉcumi. Eropa eragʉ i yeba majarãre ñerire iirã erã árĩcʉ̃ masicʉ̃ iigʉcumi ĩgʉ. Eropigʉ õaro árĩricʉburire buhegʉcumi ĩgʉ. Eropigʉ Goãmʉ ĩgʉ dipuwaja moaborore weregʉcumi masare itamubupʉ. ");
INSERT INTO des_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yʉre umupeobirã ãhrima i yeba majarã. Eropigʉ itamubupʉ masa erã ñero iiricʉrire erãre masicʉ̃ iigʉcumi. ");
INSERT INTO des_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yʉ Pagʉ pohrogue wagʉca. Yʉ eropa wara pʉhrʉ masa yʉre ĩanisome. Eropigʉ itamubupʉ arigʉ õaro árĩricʉri sãre buhegʉcumi. ");
INSERT INTO des_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","I yeba majarã opʉre watĩre Goãmʉ dipuwaja moadoretuhami. Eropigʉ Goãmʉ masare ĩgʉ dipuwaja moaburi sãre weregʉcumi itamubupʉ. ");
INSERT INTO des_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Wʉaro ãhraa mʉare yʉ wereburi. Yʉ eropa werenemodiaquerecʉ̃ ta ire yʉ werecʉ̃ dohparagã masisome mʉa. ");
INSERT INTO des_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yʉ eropa werenemobiricʉ̃ Espíritu Santopʉ irire werenemogʉ arigʉcumi. Ĩgʉ ĩgʉ gamero mʉare weresome. Yʉ Pagʉ ĩgʉ weredorerare mʉare weregʉcumi. Eropigʉ mʉare diaye majare werepehogʉcumi. Eropiro pʉhrʉgue waburire mʉare masicʉ̃ iigʉcumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Eropigʉ ĩgʉ yare mʉare weregʉcumi. Eropa weregʉ yʉre umupeocʉ̃ iigʉcumi mʉare. ");
INSERT INTO des_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Árĩpehreri yʉ Pagʉ ya sã yaha ãhraa. Eropigʉ “Espíritu Santo yahare weregʉcumi,” arãbʉ mʉare, arĩ weremi Jesu. ");
INSERT INTO des_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Eropa arĩtuha õpa arĩ werenemomi gʉare daja: —Bajamenʉri yʉre ĩasome mʉa. Eropirã pʉhrʉgã ta daja mʉa yʉre ĩarãca, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ĩgʉ eroparĩcʉ̃ peerã, gʉapʉ bajamerãgã õpa arĩ wereniguibʉ gʉa basi: —“Bajamenʉri yʉre ĩasome mʉa. Eropirã pʉhrʉgã ta daja mʉa yʉre ĩarãca,” arĩgʉ ¿dohpa arĩgʉ eropa arãri marire? Eropigʉ “Yʉ Pagʉ pohrogue wagʉca,” ¿dohpa arĩronore eropa arãri ĩgʉ? ");
INSERT INTO des_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Bajamenʉri pʉhrʉ,” arĩgʉ ¿dohpa arĩgʉ eropa arãri ĩgʉ? Ĩgʉ wererare õaro pee masibeaa mari, arĩbʉ gʉa basi. ");
INSERT INTO des_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Gʉa eropa arĩ wereniguicʉ̃ Jesu ĩgʉre gʉa serẽpidiarire masigʉ gʉare õpa arĩ weremi: —“Bajamenʉri yʉre ĩasome mʉa. ¿Eropirã pʉhrʉgã ta yʉre ĩarãca daja,” yʉ arĩrare serẽpidiari mʉa? ¿Irire yʉ arĩrare masibeari mʉa? ");
INSERT INTO des_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Diaye mʉare arĩgʉ iiaa: Yʉhʉ sĩricʉ̃ ĩarã mʉa orerãca. Eropirã bʉrigã bʉjawererãca. Yʉre umupeobirinirãpʉ mucubirirãcoma. Mʉapʉ bʉjawerenirã árĩquererã pʉhrʉ mucubirirãca mʉa. ");
INSERT INTO des_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Õpa ãhraa iri: Nomeo niji wahgũgo igo ñero tariburisubu ãhraa. Eropigo igo turaro bʉjaweremo. Eropa bʉjawerequerego, igo magʉgã dehyoacʉ̃ ĩago mucubirimo. Eropigo igore pũrirare guñabeamo igo pare. ");
INSERT INTO des_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Eropa ta mʉa dohpaguere bʉjawererãca. Pʉhrʉ mʉa yʉre ĩarãca daja. Eropirã mʉa turaro mucubirirãca. Mʉa eropa mucubiririre gajirã mʉare bʉjawerecʉ̃ iimasisome. ");
INSERT INTO des_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Irinʉ yʉre mʉa ĩarinʉre yʉre serẽpisome mʉa. Yʉ Pagʉpʉ mʉa serẽrire ogʉcumi. Diaye ta mʉare arĩgʉ iiaa. Yʉre mʉa umupeocʉ̃ ĩagʉ yʉ Pagʉre yʉ waĩ mera mʉa serẽrire ĩgʉ mʉare ogʉcumi. ");
INSERT INTO des_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yʉ õpa waboro core mʉa yʉre waĩpeo Goãmʉre serẽnibiribʉ mʉa. Dohpaguere yʉre waĩpeo Goãmʉre serẽque. Mʉa eropa serẽcʉ̃ mʉare ĩgʉ ogʉcumi mʉa turaro mucubiriburire, arĩmi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Eropa arĩtuha õpa arĩnemomi: —Werenigui queori mera mʉare weremʉrabʉ. Eropa werequeregʉ ta pʉhrʉ mʉare werenigui queori mera weresome pare yʉhʉ. Yʉ Pagʉpʉre mʉa õaro peeboro dopa weregʉra mʉare. ");
INSERT INTO des_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Irinʉre mʉa ya árĩburire mʉare serẽbasasome yʉhʉ. Yʉre umupeorã yaha waĩ mera mʉa basi ĩgʉre serẽrãca. ");
INSERT INTO des_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mʉa yʉre mahirã ãhraa. Eropirã yʉ Pagʉ pohrogue yʉ aridigʉ árĩcʉ̃ “Diaye ta ãhraa,” arãa mʉa. Eropa arĩrã mʉa árĩcʉ̃ ĩagʉ, yʉre mahirã mʉa árĩcʉ̃ ĩagʉ yʉ Pagʉ sã mʉare mahimi. Ĩgʉ eropa mahicʉ̃ mʉa ĩgʉre serẽrãca. ");
INSERT INTO des_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉ Pagʉ pohro árĩdigʉ árĩgʉ i yebaguere aribʉ yʉhʉ. Eropigʉ dohpaguere i yebague árĩdigʉ árĩgʉ yʉ Pagʉ pohrogue dujagʉca daja, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ĩgʉ eroparĩcʉ̃ gʉa ĩgʉ buherã õpa arĩbʉ: —Dohpague tamerare werenigui queori mariro wereniguigʉ õaro diaye wereniguigʉ iiaa mʉhʉ gʉare. ");
INSERT INTO des_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mʉhʉ õaro masipehogʉ mʉ árĩcʉ̃ gʉa dohpague ta õaro masia. Eropirã gajirã mʉre buhemasibeama. Eropirã irire gʉa dohpaguere õaro masia. Gʉa irire õaro masirã árĩrã Goãmʉ pohrogue mʉ aridigʉ árĩcʉ̃ “Diaye ta ãhraa,” arãa, arĩbʉ gʉa Jesure. ");
INSERT INTO des_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Gʉa eroparĩcʉ̃ Jesu yʉhrimi gʉare: —Dohpaguere “Diaye ta ãhraa,” ¿arĩri mʉa pare? ");
INSERT INTO des_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pʉhrʉñari mʉa ya wirigue wasirirã yʉre cóãrãca mʉa. Mʉa eropa cóãquerecʉ̃ ta yʉ Pagʉpʉ yʉ mera ãhrimi. Eropigʉ yʉhʉ yujugʉ ta árĩbeaa. ");
INSERT INTO des_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ire mʉare wereyubʉ yʉre mʉa guñaturari mera mʉa õaro árĩboro dopa. I yeba árĩrisubu Goãmʉre gamebirã pohrogue mʉa árĩcʉ̃ mʉare ñero iirãcoma erã. Erã eropa iiquerecʉ̃ ta guñaturaque mʉa. I yeba majarã erã ñero iirare tarinʉgagʉ ãhraa yʉhʉ. Eropirã yʉre guñatura mucubirique mʉa, arĩmi gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Eropa arĩ weretuha Jesu ʉmarogue ĩhamuju õpa arĩ wereniguimi Goãmʉre ĩgʉ Pagʉre: —Ahʉ, dohpaguere mʉ werediro dopa ta yʉre erã ñero iiburisubu ejanijaro iiaa. Yʉre mʉ magʉre erã masare umupeocʉ̃ iique. Mʉ eropa iicʉ̃ masare mʉre umupeocʉ̃ iigʉra yʉ sã. ");
INSERT INTO des_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Árĩpehrerã tauro opʉ apibʉ mʉhʉ yʉre. Eropigʉ mʉ yʉre onirãre mʉ mera eropa árĩniguicʉ̃ iigʉca mʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mʉ dihta Goãmʉ gohra ãhraa. Yʉhʉ Jesucristo mʉ obeodigʉ ãhraa. Eropirã árĩpehrerã mʉre masirã, yʉ sãre masirã mari mera ʉmaroguere eropa árĩniguicãrãcoma, arĩmi. ");
INSERT INTO des_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Eropa arĩgʉ ta õpa arĩnemomi Goãmʉre: —I yebaguere mʉ iidorerare iipehoabʉ yʉhʉ. Eropa iigʉ masare mʉ turagʉ árĩrire ĩhmuabʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","I yeba árĩboro core mʉ mera yʉ árĩcʉ̃ õaro turari opabʉ. Eropigʉ dohpaguere mʉ árĩrogue irire yʉ õaro turagʉ árĩrire ĩhmuque. ");
INSERT INTO des_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“I yeba árĩrãre yʉre mʉ onirãre mʉre masicʉ̃ iiabʉ. Mʉ onirã mʉ yarã ãhrima. Eropigʉ erãre ohabʉ mʉhʉ yʉre. Eropirã mʉ dorerire iiama erã. ");
INSERT INTO des_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Yʉre mʉ wererare erãre buheabʉ. Yʉ buhecʉ̃ peerã yʉ buherire gahmeama erã. Eropirã diaye ta mʉ pohro aridigʉ yʉ árĩcʉ̃ masima erã. Eropirã mʉ obeodigʉ yʉ árĩcʉ̃ sãre “Diaye ta ãhraa,” arĩ pepima erã. ");
INSERT INTO des_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Erã ya árĩburi mʉre serẽgʉ iiaa. Gajirã ya árĩburipʉre serẽgʉ iibeaa yʉhʉ. Yʉre mʉ onirã mʉ yarã ãhrima. Eropigʉ erã ya árĩburire serẽgʉ iiaa mʉre. ");
INSERT INTO des_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Erã árĩpehrerã mʉ yarã ãhrima. Eropirã mʉ yarãpʉ yaharã ãhrima. Yʉre umupeorã yʉ turagʉ árĩrire ĩhmuma erã masare. ");
INSERT INTO des_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Dohpaguere i yebaguere dujasome yʉhʉ. Mʉ pohro wabu iiaa. Yʉ eropa waquerecʉ̃ ta dohpaguere yʉre mʉ onirã i yebaguere dujama. Ahʉ, mʉhʉ õagʉ ãhraa. Yʉre mʉ onirãre mʉ turari mera ĩhadibuque. Mʉ eropa dibucʉ̃ mari yujugʉ ta árĩdiro dopa ta yuju curu ta árĩrãcoma erã sã. ");
INSERT INTO des_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Erã mera árĩgʉ mʉ turari mera erãre õaro ĩhadibuabʉ. Yujugʉ tamera peamegue wagʉcumi mʉ yare erã gojarapũ werediro dopa ta. ");
INSERT INTO des_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Dohpaguere mʉ pohrogue wabu iiaa. Eropigʉ i yeba i árĩpehrerire mʉ yarãre werea yʉ mera erã õaro mucubiriborore. ");
INSERT INTO des_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʉ yare wereabʉ erãre. Erã yʉ iro dopa ta i yeba árĩwajamorã árĩbeama. Eropirã i yeba majarãpʉ erãre ĩhaturima. ");
INSERT INTO des_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“I yeba árĩrãre, yaharãre aĩaque,” arĩbeaa. Eropa arĩbiriqueregʉ erãre õaro ĩhadibuque watĩ ñerire iidoreri erãgue arĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","I yeba majagʉ árĩbeaa. Erã sã yʉ iro dopa ta i yeba árĩwajamorã árĩbeama. ");
INSERT INTO des_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yaharãre mʉ buheri mera õarã árĩcʉ̃ iique erãre. Mʉ wereripʉ diaye ta ãhraa. ");
INSERT INTO des_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","I yebaguere yʉre mʉ obeodiro dopa ta yʉpʉ yaharãre mʉ yare buhedoregʉ obeoa. ");
INSERT INTO des_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mʉ gamerire iibu árĩgʉ, sĩribu árĩgʉ erã ya árĩburire sĩribu ãhraa. Eropa sĩribu ãhraa yʉhʉ yaharã sã mʉ gamerire diaye erã õaro iiburire. ");
INSERT INTO des_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Yaharãre dohpague árĩrã dihtare itamuque,” arĩ serẽbeaa yʉhʉ. Yaharã gajirãre erã buhera pʉhrʉ gajirã sã yʉre umupeorãcoma. “Erã sãre itamuque,” arãa yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yaharã árĩpehrerã erã yuju curu árĩboro dopa itamuque. Yʉhʉ mʉ mera yujugʉ ta ãhraa. Mari yujugʉ árĩdiro dopa ta erã mari mera yuju curu ta árĩporo. Yujuro mera ta árĩporo mʉ obeodigʉ yʉ árĩrire árĩpehrerã masa “Diaye ta ãhraa,” erã arĩburire. ");
INSERT INTO des_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yʉre mʉ ora turarire yaharãre ohabʉ. Iri turarire oparã yujugʉ ta mari árĩdiro dopa ta erã sã yuju curu ta árĩrãcoma. ");
INSERT INTO des_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yʉhʉ erã mera ãhraa. Eropigʉ mʉhʉ yʉ mera ãhraa. Mari eropa árĩrã árĩcʉ̃ mari yarã diaye ta õaro yuju curu ta árĩrãcoma. Yuju curu erã árĩcʉ̃ ĩarã mʉ obeodigʉ yʉ árĩrire i yeba majarã masirãcoma. Eropirã yʉre mʉ mahidiro dopa ta yaharã sãre mʉ mahirire masirãcoma masa. ");
INSERT INTO des_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ahʉ, i yeba árĩboro core yʉre mahibʉ mʉhʉ. Eropa mahigʉ yʉ turagʉ árĩrire ĩhmubʉ mʉhʉ. Eropigʉ yʉre mʉ onirã yʉ mera erã árĩcʉ̃ gahmea yʉ turagʉ árĩrire erã masiboro dopa. ");
INSERT INTO des_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ahʉ, mʉhʉ õagʉ ãhraa. I yeba majarã ñerã mʉre masibeama. Yʉpʉ mʉre masia. Eropirã yʉhʉ mʉ obeodigʉ árĩcʉ̃ masima yaharãpʉ. ");
INSERT INTO des_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉre erãre masicʉ̃ iiabʉ. Pʉhrʉ sãre mʉre erãre masicʉ̃ iigʉca yʉre mʉ mahidiro dopa ta gajirãre erã mahiburire. Eropigʉ yaharã mera árĩgʉca, arĩmi Jesu mari Pagʉre. ");
INSERT INTO des_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ĩgʉ eropa arĩra pʉhrʉ Jesu gʉa sã ĩgʉ buherã Cedrón waĩcʉriyare taribuja, Olivo waĩcʉri gorogue ejabʉ. ");
INSERT INTO des_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Bajasuburi iri gorogue Jesu mera gʉa gamenere­mʉribʉ. Eropigʉ Juda Jesure ĩhaturirãre wiabu iri gorore masími. ");
INSERT INTO des_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eropa masigʉ pe curu surara mera aridi árĩmi ĩgʉ. Yuju curu surara gohra árĩma. Gaji curu surara Goãmʉ wihire corerã árĩma. Pahia oparã, fariseo masa erã obeonirã árĩma surara. Eropa arirã sihãri dipurure, eropárĩcʉ̃ yucʉ mojocʉma erã. ");
INSERT INTO des_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iri gorogue gʉa pohrogue erã erara pʉhrʉ Jesu ĩgʉ ñero tariborore masigʉ, erãre bocatĩri serẽpimi: —¿Noare amarã iiri mʉa? arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesu Nazare majagʉre ahmaa, arĩ yʉhrima erã. —Ĩgʉ ta ãhraa yʉhʉ, arĩmi Jesu. Judapʉ Jesure ñeadoregʉ erã mera árĩmi. ");
INSERT INTO des_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Eropirã Jesu “Ĩgʉ ta ãhraa yʉhʉ,” ĩgʉ arĩcʉ̃ erãpʉ ʉca wa yebague dusirimaagã mehmereja wama. ");
INSERT INTO des_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Erã eropa wacʉ̃ ĩagʉ dipaturi serẽpimi Jesu: —¿Noare amarã iiri mʉa? arĩmi. —Jesu Nazare majagʉre amarã iiaa gʉa, arĩ yʉhrima erã daja. ");
INSERT INTO des_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Ĩgʉ ta ãhraa, arĩrabʉgʉ yʉhʉ mʉare. Eropirã yʉre ñearã oãre yʉ mera majarãre peresu iibiricãque, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Eropa gʉare mahigʉ ne yujugʉre dederecʉ̃ iibirimi. Eropa iigʉ ero core Goãmʉre ĩgʉ arĩdiro dopa ta iigʉ iimi ĩgʉ. “Yʉre mʉ onirãre ne yujugʉre dedeobiribʉ,” ĩgʉ arĩdiro dopa ta iigʉ iimi Jesu. ");
INSERT INTO des_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Eropi Simo Pedro matamijire opagʉ irimijire tʉãwea aĩ, pahia opʉ pohro majʉre Malco waĩcʉgʉre ĩgʉ gamirore pacoro medijucãmi. Diayepʉ maja gamirore pacoro medijucãmi ");
INSERT INTO des_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ĩgʉ eropa pacorocʉ̃ ĩagʉ Jesu õpa arĩmi: —Mʉ matamijire dibuque. Yʉ Pagʉ ĩgʉ yʉre ñero taridorero dopa ta ñero tarigʉra, arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ĩgʉ eropa arĩtuhacʉ̃ ta surara, erã opʉ mera, Goãmʉ wihire corerã surara sã Jesure ñeha ĩgʉre dirima. ");
INSERT INTO des_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dirituha Ana waĩcʉgʉ pohrogue aĩgãmʉhtama erã. Anapʉ Caifa mʉñecʉ árĩmi. Caifapʉ iri bojorire pahia tauro opʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","“Judio masa ya árĩburire yujugʉ masʉ sĩricʉ̃ õhaa,” arĩdigʉ árĩmi ĩgʉ Caifapʉ. ");
INSERT INTO des_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Eropigʉ yʉhʉ Simo Pedro mera Jesure yoañarirogue nʉrʉsiabʉ. Yʉpʉ pahia opʉ ĩgʉ ĩha masigʉ árĩbʉ. Eropigʉ Jesu pʉhrʉ, opʉ árĩri wihi árĩri sãriro pohecague ñajaa wabʉ. ");
INSERT INTO des_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedropʉ disiporo dujanʉgajami. Eropigʉ maji wiriri disiporo coregore serẽbasabʉ Pedrore aĩ ñajabu. Yʉ eropa serẽpiñacʉ̃ igo Pedrore ñajaridoremo. Igo ñajaridorera pʉhrʉ yʉhʉ Pedrore aĩ ñajaa wabʉ. ");
INSERT INTO des_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yʉ eropa aĩ ñajajacʉ̃ ĩago disiporo coregopʉ Pedrore serẽpimo: —¿Jesu buherã mera majagʉ árĩbeari mʉhʉ? arĩmo igo Pedrore. —Árĩbeaa yʉhʉ, arĩ yʉhrimi Pedropʉ. ");
INSERT INTO des_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ero core ero majarã pohro majarã, surara mera erã sõhmaburi peamere dihunirã árĩma. Yʉsaa árĩbʉ. Eropirã erã iri peame tʉro sõhma niguima. Erã sõhmacʉ̃ ĩagʉ Pedro sã sõhmagʉ wami. ");
INSERT INTO des_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Eropi pahia tauro opʉ árĩgʉ Jesu ĩgʉ buherire, gʉa ĩgʉ buherã sãre serẽpi ĩapʉ Jesure. ");
INSERT INTO des_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ĩgʉ eropa arĩ serẽpicʉ̃ Jesupʉ yʉhripʉ ĩgʉre: —Árĩpehrerãre buhegʉ erã core niguibʉ. Eropa buhegʉ mari buheri wiri Goãmʉ wihi sãre masa gamenererogue eropa buhe niguicãbʉ. Duhrinijagʉ ne buhebirabʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Duhpigʉ yʉre serẽpiri mʉhʉ? Serẽpidiagʉ yʉre peenirãre serẽpique. Yʉ wererare erã masima, arĩ yʉhripʉ Jesu. ");
INSERT INTO des_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ĩgʉ eroparĩcʉ̃ surarapʉ ero niguidigʉ ĩgʉ mojoto mera Jesure papʉ. —Eropa arĩbiricãque pahia tauro opʉre, arĩpʉ surara Jesure. ");
INSERT INTO des_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ĩgʉ eroparĩcʉ̃ Jesu õpa arĩpʉ: —Ñero arĩ yʉ wereniguirare wereque yʉre. ¿Diaye majare yʉ mʉare werequerecʉ̃ duhpigʉ pari mʉhʉ yʉre? arĩpʉ Jesu surarare. ");
INSERT INTO des_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pʉhrʉ Ana Jesure erã diridigʉre Caifa pahia tauro opʉ pohrogue obeopʉ. ");
INSERT INTO des_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Eropi Simo Pedro peame tʉro sõhma niguigʉ iimi. Eropa ĩgʉ sõhma niguicʉ̃ ĩarã ero majarã ĩgʉre serẽpima. —¿Mʉ sã Jesu buherã mera majagʉ árĩbeari? arĩ serẽpima erã Pedrore. —Árĩbeaa yʉhʉ, arĩ yʉhrimi Pedro. ");
INSERT INTO des_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Eropigʉ pahia tauro opʉ pohro majagʉpʉ Pedro ĩgʉ gamiro pacorodigʉ acaweregʉpʉ Pedrore serẽpimi: —¿Jesure erã ñearasubu yʉ árĩcʉ̃ mʉ sã erã mera árĩsabʉ? arĩ serẽpimi ĩgʉ Pedrore. ");
INSERT INTO des_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—Yʉhʉ ĩgʉ mera árĩbirabʉ, arĩ yʉhrimi Pedro. Ĩgʉ eroparĩcʉ̃ ta cãreña weregʉ carimi. ");
INSERT INTO des_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ñamiñarigã árĩcʉ̃ Caifa ya wihigue árĩnirã Jesure aĩ wiria, iri maca majarã opʉ Pilato ya wihigue aĩgã wama erã. Eropa waquererã ĩgʉ ya wihiguere ñajabirima. Pascua árĩcʉ̃ erã bamorã árĩrã õpa arĩma: “Judio masʉ árĩbeami Pilato. Eropirã mari i wihigue judio masʉ árĩbigʉ árĩri wihire ñajarã, mari dorerire tarinʉgarãca. Eropirã mari ñajacʉ̃ ĩarã ñerã dopa ĩabocoma marire. Eropirã marire bosenʉ barire marire badorebiribocoma,” arĩma. Eropa arĩrã opʉ ya wihire ñajabirima Jesure aĩgãnirãpʉ. ");
INSERT INTO des_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Erã ñajabiricʉ̃ ĩagʉ Pilato erã pohrogue wihi disiporogue wiriranʉgaja, erãre serẽpimi: —¿Ñehenore ĩre weresãdiari mʉa? arĩ serẽpimi Pilato erãre. ");
INSERT INTO des_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Ihĩ õagʉ ĩgʉ árĩcʉ̃ mʉre ĩgʉre obiriboaya. Ñegʉ ãhrimi ĩgʉ, arĩ yʉhrima erã. ");
INSERT INTO des_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Erã eroparĩcʉ̃ Pilato õpa arĩmi: —Mʉa basi ĩgʉre aĩaque. Eropirã mʉa ya doreri arĩro dopa ta ĩgʉre dipuwaja moaque, arĩmi Pilato erãre. —Gʉa judio masapʉ masʉre wejẽdoremasibeaa, arĩma erã Pilatore. Eropa arĩrã Jesure wejẽdoremorã iima. ");
INSERT INTO des_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Erã eropa wejẽdorecʉ̃ Jesupʉ crusague ĩgʉ sĩriborore ero core ĩgʉ werediro dopa ta eropa wabʉ. ");
INSERT INTO des_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Erã eropa arĩra pʉhrʉ Pilatopʉ wihigue maji ñaja, Jesure sihubeo ĩgʉre serẽpipʉ: —¿Judio masa erã opʉ ta ãhriri mʉhʉ? arĩ serẽpipʉ. ");
INSERT INTO des_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu yʉhripʉ ĩgʉre. —¿Mʉ guñaro yʉre eropa arĩ serẽpiri mʉhʉ? ¿O gajirã mʉre erã wererare peenijagʉ yʉre serẽpigʉ iiri mʉhʉ? arĩpʉ Jesu Pilatore. ");
INSERT INTO des_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Judio masʉ árĩbeaa yʉhʉ. Mʉ ya yeba majarã, pahia oparã sã, mʉre wiama yʉre. ¿Ñehenore ñero iiri mʉhʉ erã eropa mʉre dipuwaja moadiacʉ̃? arĩpʉ Pilato. ");
INSERT INTO des_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Yʉ opʉ árĩri i yeba maja árĩbeaa. Yʉhʉ i yeba majarã opʉ árĩcʉ̃, yaharã yʉre itamuboñuma judio masare ñeadorebirã. Yʉ opʉ árĩri i yeba maja árĩbeaa, arĩpʉ Jesu Pilatore. ");
INSERT INTO des_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—¿Eropigʉ opʉ ãhraa arĩri mʉhʉ eropa arĩgʉ? arĩpʉ Pilato. —Mʉ arĩro dopa ta opʉ ta ãhraa. Masa opʉ árĩbu masa dehyoabʉ yʉhʉ. Eropigʉ i yebague arigʉ erã opʉ árĩbu aribʉ. Diaye majare weregʉ aribʉ. Árĩpehrerã diaye árĩrire peediarã yʉ wererire peema, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿Ñeheno ãhriri diaye árĩri? arĩpʉ Pilato. Eropa arĩtuha Pilato judio masa pohro maji dujaa wa erãre weremi: —Ĩre ne gajino dipuwaja mara. ");
INSERT INTO des_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bojori nʉcʉ Pascuanʉ árĩcʉ̃ yujugʉ peresu árĩgʉre mʉa wiudorea. ¿Eropigʉ ĩre Jesure ta mʉa opʉ árĩbupʉre mʉare wiubasacuri yʉhʉ? arĩmi Pilato judio masare. ");
INSERT INTO des_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ĩgʉ eroparĩcʉ̃ peerã erã judio masa õpa arĩ gaguiniguima: —Ĩgʉre wiubiricãque. Barrabápʉre gʉare wiubasaque, arĩ gaguiniguima judio masa Pilatore. Barrabápʉ yajaricʉgʉ árĩdigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Erã eropa arĩ gaguiniguira pʉhrʉ Pilato Jesure tãradorepʉ. Eropirã ĩgʉ yarã surarapʉ ĩgʉre tãrañorã. ");
INSERT INTO des_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tãratuha pora bero iituha, Jesure ĩgʉ dipuru weca duhpeoñorã. Duhpeotuha, oparã ya suhrirore ĩgʉre sãñorã. ");
INSERT INTO des_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Eropirã ĩgʉ pohro nʉgaja õpa arĩñorã erã õpa arĩ wereyarã: —Õaro árĩporo. Judio masa opʉ õaro árĩporo, arĩ wereya erã mojotori mera ĩgʉre pañorã. ");
INSERT INTO des_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eropigʉ Pilato dipaturi waha, judio masare weremi: —Peeque mʉa. Ĩre ñeri dipuwaja mara. Eropigʉ irire mʉa masiburire ĩgʉre mʉa pohro aĩgãribu iiaa, arĩmi Pilato. ");
INSERT INTO des_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ĩgʉ eropa arĩra pʉhrʉ Jesu pora berore peyadigʉ, oparã ya suhrironore sañadigʉ wihigue árĩdigʉ wiririmi. Ĩgʉ wiriricʉ̃ Pilato õpa arĩmi: —Ĩaque. Ihĩ ta ãhrimi ĩgʉ, arĩmi Pilato. ");
INSERT INTO des_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ĩgʉ eropa arĩtuhacʉ̃ peerã pahia oparã, surara Goãmʉ wihi ĩhadibu corerã sã Jesure ĩarã gaguiniguima: —Crusague wejẽque ĩgʉre. Crusague pabia wejẽque ĩgʉre, arĩ gaguiniguima erã. —Ĩgʉre ne ñeri dipuwaja mara. Eropirã mʉa basi ta ĩgʉre aĩgãque. Eropirã mʉa basi ta ĩgʉre crusague pabia wejẽque, arĩmi Pilato erãre. ");
INSERT INTO des_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—Ĩgʉ, ĩgʉ basi “Goãmʉ magʉ ãhraa,” arĩmʉrami. Ĩgʉ eropa arĩra waja gʉa doreripʉ ĩgʉre wejẽdorea, arĩma erã Pilatore. ");
INSERT INTO des_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Erã eroparĩcʉ̃ peegʉ ʉcataria Pilatopʉ. ");
INSERT INTO des_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Eropigʉ dipaturi ĩgʉ wihigue Jesure aĩ majiñajagʉ Jesure serẽpipʉ daja: —¿Nohogue majagʉ ãhriri mʉhʉ? arĩpʉ Pilato Jesure. Ĩgʉ eropa arĩ serẽpiquerecʉ̃ ta Jesu ĩgʉre ne yʉhribiripʉ: ");
INSERT INTO des_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ĩgʉ yʉhribiricʉ̃ ĩagʉ Pilato ĩgʉre serẽpinemopʉ: —¿Yʉre yʉhribeari mʉhʉ? Yʉhʉ mʉre peresu árĩgʉre wiumasia. Eropigʉ mʉre crusague pabia wejẽdoremasia yʉhʉ. ¿Irire masibeari mʉhʉ? arĩpʉ Pilato Jesure. ");
INSERT INTO des_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ĩgʉ eroparĩcʉ̃ Jesu yʉhripʉ daja: —Goãmʉ mʉre dorebiricʉ̃ ne iimasibiriboaya mʉhʉ. Eropigʉ yʉre ĩhaturirãre wiadigʉpʉ mʉ tauro ñero dipuwajacʉgʉcumi, arĩpʉ Jesu Pilatore. ");
INSERT INTO des_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ĩgʉ eroparĩcʉ̃ peegʉ Pilatopʉ ĩgʉre wiudiaripʉ. Ĩgʉ eropa wiudiaquerecʉ̃ ta dipaturi judio masapʉ gaguiniguima: —Jesu “Opʉ ãhraa,” arĩgʉ mari tauro opʉ árĩgʉre Roma majagʉre ĩhaturigʉ iimi ĩgʉ. Eropigʉ ĩgʉre wiugʉ mʉ sã mari tauro opʉ árĩgʉre ĩhaturigʉ ãhraa, arĩ gaguiniguima judio masa Pilatore. ");
INSERT INTO des_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Erã eroparĩcʉ̃ peegʉ Jesure wihigue árĩgʉre aĩ wiriri, ĩgʉ dipuwaja moadoregʉ ĩgʉ doari pẽro doajami Pilatopʉ. Ĩgʉ dipuwaja moadorero judio masa ya mera gabata waĩcʉro empedrado waĩcʉbʉ. ");
INSERT INTO des_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Irinʉ Pascuanʉ bosenʉ árĩcʉ̃ gʉa baburi gʉa amurinʉ árĩbʉ. Irisubu goeri boje core árĩbʉ. Doajatuha Pilato masare õpa arĩ weremi: —Ihĩ ta ãhrimi mʉa opʉ, arĩmi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ĩgʉ eroparĩcʉ̃ peerã judio masa gaguiniguima daja: —Sĩriporo ĩgʉ. Sĩriporo ĩgʉ. Crusague pabia wejẽque ĩgʉre, arĩ gaguiniguima erã. —¿Mʉa opʉ árĩquerecʉ̃ ta ĩgʉre crusague pabia wejẽdiari mʉa? arĩmi Pilato erãre. Ĩgʉ eroparĩcʉ̃ õpa arĩ yʉhrima pahia oparã: —Mari árĩpehrerã tauro opʉ Roma majagʉ ãhrimi. Gajigʉ opʉ marimi marire, arĩ yʉhrima pahia oparã. ");
INSERT INTO des_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Erã eropa arĩ wereniguira pʉhrʉ Pilato Jesure crusague pabia wejẽdoregʉ wiami erãre pare. Eropirã surara Jesure aĩ wiriama. ");
INSERT INTO des_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Erã aĩ wiriacʉ̃ Jesupʉ crusare ĩgʉ basi aĩ coã, dipu pero waĩcʉrogue ejami. Gʉa judio masa ya mera Gólgota waĩcʉbʉ. ");
INSERT INTO des_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Erogue eja erã Jesure crusague pabiama. Eropirã gajirã perã sãre yujugʉ ĩgʉ diayepʉ, gajigʉre ĩgʉ copʉ pabiama erã. Eropigʉ Jesu erã deco árĩmi. ");
INSERT INTO des_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato taboamijire goja, crusague Jesu weca pabia tuudorepʉ ĩgʉ gojaramijire. Õpa arĩ gojara árĩbʉ: “Ihĩ Jesu Nazare majagʉ, judio masa tauro opʉ ãhrimi,” arĩ gojara árĩbʉ irimijire. ");
INSERT INTO des_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Irimijire gojagʉ judio masa ya mera, Roma majarã ya mera, Griego ya mera gojara árĩbʉ. Eropiro Jesure crusague erã pabianugudiro maca pohrogã árĩbʉ. Eropirã bajarã judio masa Pilato ĩgʉ gojarare ĩha buhema. ");
INSERT INTO des_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Eropirã pahia oparã iri buhetuhaja õpa arĩrã wañorã Pilatore: —“Ihĩ judio masa opʉ ãhrimi,” arĩ gojabita. Gʉa opʉ árĩbeami ĩgʉ. Eropigʉ õpa arĩ goja amuque mʉhʉ. Ihĩ “Judio masa opʉ ãhraa,” arĩ yujugʉ ta ĩgʉ basi ta eropa arĩ pepigʉ ãhrimi, arĩ goja amuque, arĩñorã pahia oparã. ");
INSERT INTO des_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatopʉ yʉhripʉ erãre: —Yʉ gojarare ne yʉ goja amusome, arĩpʉ Pilato erãre. ");
INSERT INTO des_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesure erã pabiara pʉhrʉ wapicʉrã surarapʉ Jesu suhri mʉrare erã basi game gueremorã iima. Erã eropa guerediaquerecʉ̃ ta ĩgʉ suhriro yoari suhriro dohori mariri suhriro árĩbʉ. Iri suhriro suara suhriro árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Iri suhriro eropa árĩcʉ̃ ĩarã õpa arĩma erã basi: —Iñe suhrirore yeguesiribiricãrã. Yujugʉ dihta aĩporo. Eropirã iñe suhriro aĩbure masimorã deabirarã mari, arĩma erã basi. Eropa deabirarã Goãmʉ yare erã gojarapũ erã gojadiro dopa ta eropa iirã iima erã. “Yʉ suhrirore erã basi guerema. Eropirã yaha suhrirore aĩbure masidiarã deabirama erã,” arĩ gojañuma Goãmʉ yare erã gojarapũgue. Erã gojadiro dopa ta eropa iima erã. ");
INSERT INTO des_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesu pago, Jesu bʉamo María Cleofa marapo, María Magdalena mera Jesu crusa pohrogã ĩha niguima. ");
INSERT INTO des_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Eropigʉ ĩgʉ pago, yʉhʉ ĩgʉ mahigʉ sã ĩgʉ pohrogã gʉa niguicʉ̃ ĩagʉ ĩgʉ pagore yʉre weremi: —Dohpaguere ihĩ mʉ magʉ árĩbu ãhrimi, arĩmi Jesu ĩgʉ pagore. ");
INSERT INTO des_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Eropa arĩtuha yʉre õpa arĩ weremi ĩgʉ: —Dohpaguere igo mʉ pago árĩbo ãhrimo, arĩmi Jesu yʉre. Ĩgʉ eropa arĩra pʉhrʉ Jesu pagore yaha wihigue aĩ opamʉribʉ. ");
INSERT INTO des_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ĩgʉ eropa arĩ werera pʉhrʉ árĩpehreri Goãmʉ ĩgʉre mohmedoregʉ ĩgʉ apirare iipehogʉ árĩgʉ masipʉ Jesu. Eropa masigʉ Goãmʉ yare erã gojarapũ iribojegue erã arĩ wereyudiro dopa ta õpa arĩmi Jesu: —Ñemesibuca yʉre, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ero vino sʉ̃iri deco dicʉri sorobu ero doabʉ. Eropirã ero árĩrã Jesu eroparĩcʉ̃ pee mimi aĩri yʉsʉre deco mera erã yosora yʉsʉre yucʉgʉ hisopo waĩcʉdigʉ ojogoro dirituma. Eropirã aĩ muju Jesu disiro sĩtuma. ");
INSERT INTO des_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iri decore Jesu mimituha õpa arĩmi: —Iripẽta árĩca, arĩgʉ ta ĩgʉ dipurure muhmusiudija sĩria wami. ");
INSERT INTO des_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Irinʉ Pascua bosenʉ core árĩbʉ. Iri bosenʉ gʉa baburire gʉa amurinʉ árĩbʉ. Eropirã gajinʉ Sabado árĩcʉ̃ iri õari bosenʉ árĩcʉ̃ crusarigue sĩrinirãre judio masa apidiabirima. Irinʉ ta bosenʉ gʉa judio masa bosenʉ wʉari bosenʉ árĩro iibʉ. Eropirã erã sĩrinirã mʉra irinʉ crusarigue árĩcʉ̃ gamebirima. Eropirã pabianirã mʉrare erã ñigagʉ gõarire panuadorerã judio masa serẽñorã Pilatore erãre sĩri purumujudorerã. Erã eropa iira pʉhrʉ erã dʉpʉ mʉrare aĩdijumorã iima. ");
INSERT INTO des_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Erã eropa dorecʉ̃ surarapʉ crusari pohrogue eja, yajaricʉgʉre copʉ árĩgʉ ñigagʉre panuama: Gajipʉ árĩgʉ sãre eropa ta iima erã. ");
INSERT INTO des_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Eropa iiquererã Jesu ñigagʉre panuabonirã ĩgʉ pohro eja ĩgʉ sĩridigʉ árĩcʉ̃ ĩha panuabirima. ");
INSERT INTO des_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Eropa panuabirã yujugʉ surara ĩgʉ patore gohra gubuye ĩgʉre ñosemi. Ĩgʉ eropa ñosecʉ̃ mata ĩgʉ di, deco mera wiribʉ. ");
INSERT INTO des_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ĩgʉ eropa wacʉ̃ ĩabʉ yʉhʉ. Yʉhʉ ipũre gojagʉ diaye mʉare werea. Diaye yʉ wereri árĩcʉ̃ masia yʉhʉ. Mʉare irire werea mʉa sã Jesure mʉa umupeoburire. ");
INSERT INTO des_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Goãmʉ yare erã gojarapũ werediro dopa ta eropa wabʉ. “Ĩgʉ gõare ne yuju gõare panuabirima,” erã arĩ gojadiro dopa ta Jesu ñigagʉ gõare ne yuju gõa panuabirima. ");
INSERT INTO des_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Eropiro gajipũ sã Goãmʉ yare erã õpa arĩ gojayudiro dopa ta wabʉ: “Ĩgʉre erã ñosedigʉ mʉrʉre ĩarãcoma erã,” erã arĩ gojadiro dopa ta gʉa Jesure erã ñosedigʉ mʉrʉre ĩabʉ. ");
INSERT INTO des_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ĩgʉ sĩrira pʉhrʉ José Arimatea majagʉ Jesu dʉpʉ mʉrarore aĩ dijubu Pilatore serẽgʉ ejapʉ. Josépʉ gajirã judio masare güigʉ, Jesure umupeogʉ ĩgʉ árĩrire werebiridigʉ árĩmi. Eropigʉ ĩgʉ dʉpʉ mʉrarore ĩgʉ serẽra pʉhrʉ Pilatopʉ ĩgʉ dʉpʉre aĩdorepʉ. Ĩgʉ aĩdorecʉ̃ José crusa pohro eraa Jesu dʉpʉ mʉrarore aĩgã wami. ");
INSERT INTO des_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo sã ĩgʉ poresurire mohmorerare treinta kilo nʉcʉrire aĩgãrimi Jesu dʉpʉ ĩgʉ amuburire. Yucʉgʉ di pohga, mirra waĩcʉri poresuri, yucʉgʉ pohga mera árĩyoro ĩgʉ mohmorera. Ĩgʉ Jesu mera ñami weretamudigʉ árĩmi. ");
INSERT INTO des_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Eropirã erã perã Jesu dʉpʉ mʉrarore aĩma. Judio masa sĩrinirãre yaaro dopa ta ĩgʉ dʉpʉ mʉrarore poresuri sũra pʉhrʉ suhri gasiri mera omama. ");
INSERT INTO des_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Crusague Jesure erã pabia wejẽdiro pohro pohe árĩbʉ. Iri pohegue masa gobe ʉtãyegue erã seara gobe árĩbʉ. Iri gobere ne yujugʉ sĩridigʉre cóãnibirima dohpa. ");
INSERT INTO des_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pascuanʉ bosenʉ maja gʉa judio masa baburire amurinʉ árĩbʉ. Eropirã iri gobe pohrogã crusa árĩcʉ̃ ero apima erã Jesu dʉpʉ mʉrarore. ");
INSERT INTO des_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo ñamiñarigã árĩcʉ̃, boyoboro coregã María Magdalena Jesu masa gobegue ejapo. Erogue ejago iri gobere erã biharayere gajipʉ tunuguraye árĩcʉ̃ ĩapo igo. ");
INSERT INTO des_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eropa ĩadigo árĩgo gʉa pohrogue omagãrimo igo. Simo Pedro mera perã árĩbʉ gʉa. Eraa õpa arĩ weremo gʉare igo. —Mari Opʉ dʉpʉ mʉrarore aĩcãnirã ãhrama. Eropirã ĩgʉre erã apidirore mari masibeaa, arĩmo igo gʉare. ");
INSERT INTO des_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Igo eroparĩcʉ̃ peerã, yʉhʉ Pedro mera gʉa perã masa gobegue ĩarã wabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Eropa ĩarã warã gʉa perã omagãabʉ. Eropa omarã, yʉhʉ Pedrore omatarigãgʉ masa gobegue ejamʉhtabʉ. ");
INSERT INTO des_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Erogue ejagʉ muhmumereja ĩha acubʉ iri gobere. Eropa ĩha acugʉ ĩgʉre erã omara gasiro seyarore ĩabʉ. Eropigʉ iri gobere ñajabiribʉ. ");
INSERT INTO des_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yʉ eropa ĩara pʉhrʉgue Simo Pedro sã erami. Eraa masa gobegue ñajaa, ĩgʉ dʉpʉ mʉrarore erã omara suhri gasirire ĩami ĩgʉ. ");
INSERT INTO des_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Eropigʉ Jesu dipurure erã omara gasiro sãre ĩami daja. Iri gasiro boje oyaro, yeguera gasiro árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Eropigʉ yʉ sã masa gobegue ñajabʉ. Jesu ĩgʉ maricʉ̃ ĩagʉ “Diaye ta Jesu masa mʉriañumi,” arĩ pepibʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Iri gobegue gʉa waboro core Goãmʉ yare erã gojarapũ Cristo sĩriburire erã wererare õaro gʉa masinibiribʉ. Dohpaguepʉre iri gobere yʉ ĩara pʉhrʉ, “Diaye ta Jesu masa mʉriañumi,” arĩ pepibʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Eropa ĩatuhajarã gʉa wihigue dujaa wabʉ. ");
INSERT INTO des_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Eropi masa gobe disiporo María niguigo ore niguipo. Eropa orequerego ta muhmumereja igo ĩhame acupo masa gobere. ");
INSERT INTO des_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Eropa ĩhame acugo perã anyuare boreri suhricʉrãre Jesu ĩgʉ oyadiro mʉrarogue erã doacʉ̃ ĩapo igo. Yujugʉ ĩgʉ dipuru oyadiro doapʉ. Gajigʉ ĩgʉ guburi oyadiro doapʉ. ");
INSERT INTO des_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Erãre igo ĩacʉ̃ erãpʉ igore serẽpiñorã: —Nomeo, ¿dohpa árĩronore orego iiri mʉhʉ? arĩñorã erã. —Yʉ Opʉ dʉpʉ mʉrarore aĩcãnirã ãhrama. Eropigo erã apidirore masibeaa yʉhʉ, arĩpo igo. ");
INSERT INTO des_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eropa arĩtuha, majinʉgaja nijago Jesure ero niguigʉre ĩapo igo. Eropa ĩaquerego ta Jesure ĩha masibiripo igo. ");
INSERT INTO des_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—Nomeo, ¿dohpa árĩrono orego iiri mʉhʉ? ¿Noare amago iiri mʉhʉ? arĩpʉ Jesu igore. “Ihĩ i pohere ĩhadibugʉ ãhrimi,” arĩ pepiripo igo Jesure. Eropa arĩ pepigo õpa arĩpo igo: —Mʉhʉ ĩgʉ dʉpʉ mʉrarore aĩdigʉ árĩgʉ wereque mʉ apidirore yʉre. Mʉ werera pʉhrʉ aĩgora ĩgʉ dʉpʉ mʉrarore, arĩpo igo ĩgʉre. ");
INSERT INTO des_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Igo eropa arĩra pʉhrʉ Jesu õpa arĩpʉ: —María, arĩpʉ. Ĩgʉ eropa piyucʉ̃ peego, majiñabeo igo Hebreo ya mera õpa arĩpo: —Rabuni, arĩpo igo Jesure. Rabuni, erã ya mera arĩrã “Buhegʉ,” arĩma. ");
INSERT INTO des_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu arĩpʉ: —Yʉ Pagʉ pohrogue mʉrianibeaa dohpa yʉhʉ. Yʉ eropa mʉrianibiricʉ̃ yʉre mohpiñabiricãque. Eropigo gajirã yaharã pohrogue waque. Erã pohrogue ejago õpa arĩ wereque: “Jesu õpa arĩdoremi mʉare: ‘Yʉ Pagʉ pohrogue wabu iiaa. Mʉa Pagʉ sã ãhrimi ĩgʉ. Goãmʉ pohrogue wabu iiaa. Mʉa yagʉ Goãmʉ sã ãhrimi ĩgʉ,’ arãmi Jesu,” arĩ wereque erãre, arĩpʉ Jesu Maríare. ");
INSERT INTO des_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ĩgʉ eropa arĩra pʉhrʉ María Magdalena gʉare Jesu buherã pohrogue eraa weremo gʉare: —Mari Opʉre ĩabʉ yʉhʉ, arĩ Jesu igore gʉare weredorerare weremo igo. ");
INSERT INTO des_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Irinʉ soorinʉ ñamicague gʉa Jesu buherã gʉa acawererãre judio masare güirã, gʉa ya wihigue biha ñaja doabʉ gʉa. Gʉa eropa doacʉ̃ Jesu gʉa watope dehyoanʉgaja õpa arĩmi: —¿Ãhriri mʉa? arĩmi. ");
INSERT INTO des_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Eropa arĩtuha ĩgʉ mojotorire, ĩgʉ patore sãre gʉare ĩhmúmi. Eropirã gʉa ĩgʉre gʉa opʉre masa mʉriadigʉre ĩarã mucubiribʉ. ");
INSERT INTO des_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dipaturi Jesu gʉare õpa arĩmi daja: —Õaro árĩque mʉa. Yʉ Pagʉ ĩgʉ yʉre obeodiro dopa ta yʉ sã mʉare obeoa, arĩmi gʉare. ");
INSERT INTO des_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eropa arĩtuhaja gʉare ĩgʉ purisãmi. Eropa purisãgʉ Espíritu Santore gʉa ñeaburire ĩhmugʉ iimi. Ĩhmutuhaja õpa arĩmi: —Dohpaguere Espíritu Santore ñeaque mʉa mʉa mera árĩbure. ");
INSERT INTO des_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Masa erã ñeri dipuwajare bʉjawerecʉ̃ ĩarã, “Mʉa ñero iirare cohãa,” arĩmasia mʉa erãre. Erã bʉjawerebiricʉ̃ ĩarã, “Mʉa ñeri iirare cóãbiribʉ,” arĩmasia mʉa, arĩmi Jesu gʉare ĩgʉ buherãre. ");
INSERT INTO des_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesu gʉa watope ĩgʉ dehyoacʉ̃ Toma sʉhrʉadigʉ erã arĩgʉ gʉa mera marimi irisubure. ");
INSERT INTO des_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ĩgʉ eropa maricʉ̃ gʉa ĩgʉ mera majarã ĩgʉre werebʉ. —Mari Opʉre gʉa ĩabʉ, arĩ wereribʉ gʉa ĩgʉre. Gʉa eropa arĩ werequerecʉ̃ ta õpa arĩmi Toma: —Ĩgʉ mojotorire erã pabiara goberire ĩabigʉ iri goberire yʉ mujusĩru mera puñabigʉ “Diaye ta masa mʉriañumi,” ne arĩsome. Eropigʉ ĩgʉ patore gubuye árĩri gobere yʉ mojoto mera sĩ acubigʉ, “Diaye ta masa mʉriañumi,” ne arĩsome yʉhʉ ĩgʉre, arĩmi Toma. ");
INSERT INTO des_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yuju semana pʉhrʉ gʉa ĩgʉ buherã gʉa ya wihigue árĩbʉ. Irisubure Toma gʉa mera árĩmi. Iri wihi bihara wihi árĩbʉ. Bihara wihi árĩquerecʉ̃ ta Jesu ñaja, gʉa watope dehyoanʉgaja õpa arĩmi: —¿Ãhriri mʉa? arĩmi. ");
INSERT INTO des_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Eropa arĩtuha ĩgʉ Tomare weremi: —Ĩaque yʉ mojotorire. Eropi mʉ mujusĩru mera yʉ mojotorire erã pabiara goberire puñaque. Eropigʉ mʉ mojoto mera yʉ patore gubuye árĩri gobere sĩ acuñaque. “Diaye árĩbeaa,” arĩbiricãque. “Diaye ta ãhraa,” arĩque mʉhʉ, arĩmi Jesu Tomare. ");
INSERT INTO des_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ĩgʉ eropa arĩra pʉhrʉ Toma yʉhrimi: —Mʉhʉ yʉ Opʉ ãhraa. Mʉhʉ yahagʉ Goãmʉ ãhraa, arĩmi Toma Jesure pare. ");
INSERT INTO des_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—Yʉre mʉ ĩara pʉhrʉ yʉre “Diaye ta ãhraa,” arãa. Gajirãpʉ yʉre ĩabiriquererã ta “Diaye ta ãhraa,” arĩ umupeorãcoma. Eropirã erã turaro mucubirirã árĩrãcoma, arĩmi Jesu Tomare. ");
INSERT INTO des_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Eropigʉ baja gaji sãre Goãmʉ ĩgʉ turari mera ii ĩhmúmi Jesu gʉa mera árĩgʉ. Irire ĩgʉ iirare ipũre gojapehobirabʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Eropa gojapehobiriqueregʉ ta ipũ yʉ wererare gojagʉ, “Jesu ta Cristo Goãmʉ ĩgʉ obeodigʉ ãhrimi. Ĩgʉ diaye ta Goãmʉ magʉ ãhrimi,” mʉa arĩ masiburire gojabʉ. Eropirã mʉa ĩgʉre umupeorã Goãmʉ mera mʉa eropa árĩniguiburire gojabʉ ipũre. ");
INSERT INTO des_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pʉhrʉ Tiberia waĩcʉri ditaru tʉro dipaturi gʉare ĩgʉ buherãre dehyoami daja. Gʉare dehyoagʉ õpa iimi ĩgʉ daja. ");
INSERT INTO des_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo Pedro, Toma sʉhrʉadigʉ erã arĩgʉ, Natanae Galilea yeba árĩri maca Caná waĩcʉri maca majagʉ, gʉa perã Zebedeo porã, gajirã sã perã gʉa oã nʉcʉ gamenere árĩbʉ. ");
INSERT INTO des_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Gʉa eropa gamenerera pʉhrʉ Simo Pedro õpa arĩmi: —Wai wejẽgʉ wagʉ iiaa, arĩmi ĩgʉ. —Gʉa sã mʉ mera warãra, arĩbʉ gʉa ĩgʉre. Eropa arĩtuha buha wabʉ. Eropirã dohodiru mera wabʉ. Iri ñamire gʉa õaro boyotahmuquererã ne yujugʉ waimʉre wejẽbiricarabʉ. ");
INSERT INTO des_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Boyodiji merejacʉ̃ Jesu imiporo ĩgʉ niguicʉ̃ ĩaribʉ gʉa. Eropa ĩaquererã ĩgʉre ĩha masibiricarabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Eropigʉ gʉare õpa arĩ serẽpimi: —Ne, ¿wai wejẽari mʉa? arĩmi Jesu. —Ne wejẽbirabʉ, arĩ yʉhribʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Dohodiru diayepʉ wejẽdire mehyuque. Iripʉ mehyurã wai wejẽrãca, arĩbeo niguimi gʉare. Ĩgʉ eroparĩcʉ̃ peerã ĩgʉ arĩdiro dopa ta mehyubʉ. Gʉa mehyura pʉhrʉ bajarã wai ñajama. Bajarã wai ñajacʉ̃ ĩarã wejẽdigʉre dohodirugue aĩsã turabiricarabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Eropigʉ yʉhʉ Jesu ĩgʉ mahigʉ Pedrore werebʉ: —Mari Opʉ ãhrimi sihĩ imiporo niguigʉ, arĩbʉ Pedrore. Yʉ eroparĩcʉ̃ Jesu ĩgʉ árĩcʉ̃ masigʉ, Simo Pedro ĩgʉ suhrirore sañami. Wai wejẽbu ĩgʉ suhrirore tuweadigʉ árĩmi. Ĩgʉ suhrirore sañatuha diague yuriñajami. ");
INSERT INTO des_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Eropirã gajirã gʉa buherã dohodirugue árĩbʉ. Cien metro yoaro diaguere payabʉ gʉa. Eropirã wejẽdigʉre wai bajarã ñajadigʉre dohodiru mera taramajaabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tʉrogue tuhajarã pea niti dihta gose oyari peame weca waire ĩgʉ mupunugupidigʉre ĩabʉ gʉa. Panru sãre ĩabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Gʉa eropa ĩacʉ̃ Jesu gʉare õpa arĩmi: —Dohparagã mʉa wejẽnirãre bajamerãgã aĩgãrique, arĩmi gʉare. ");
INSERT INTO des_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ĩgʉ eroparĩcʉ̃ Simo Pedro Jesu mera árĩgʉ ĩgʉ sã dohodirugue ñaja, wejẽdire tara majaami imiporogue. Pagarã wai ñajanirã ciento cincuenta y tres wai árĩma. Bajarã wai ñajaquererã wejẽdire ne yehguebirima. ");
INSERT INTO des_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","—Banirã arique, arĩmi Jesu gʉare. —¿Noano ãhriri mʉhʉ? arĩ serẽpiñabiribʉ gʉa ĩgʉre. Gʉa Opʉ ĩgʉ árĩcʉ̃ masibʉ gʉa. ");
INSERT INTO des_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eropigʉ Jesu peame pohrogue eja, panre aĩ gʉare gueremi. Wai sãre gueremi. ");
INSERT INTO des_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Eropigʉ Jesu ĩgʉ masa mʉriara pʉhrʉ imiporo dehyoagʉ ʉhresubu gʉare ĩgʉ buherãre dehyoagʉ iimi. ");
INSERT INTO des_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gʉa bara pʉhrʉ Jesu Simo Pedrore serẽpimi: —Simo, Jona magʉ, ¿oãre mʉ mahiro tauro yʉre mahiri mʉhʉ? arĩmi Simo Pedrore. —Opʉ, mʉre mahia yʉhʉ. Mʉre yʉ mahirire masia mʉhʉ, arĩ yʉhrimi Simo Pedro. Jesu arĩmi: —Eropigʉ ovejagãre mari ejodiro dopa ta yaharãre buheque mʉhʉ, arĩmi Jesu. ");
INSERT INTO des_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Eropa arĩtuha dipaturi ĩgʉ Simo Pedrore serẽpimi daja: —Simo, Jona magʉ, ¿yʉre mahiri mʉhʉ? arĩmi Jesu. —Opʉ, mʉre mahia yʉhʉ. Mʉre yʉ mahicʉ̃ masia mʉhʉ, arĩ yʉhrimi Simo Pedro. Jesu arĩmi daja: —Ovejare ĩhadibugʉ ovejare ĩgʉ õaro ĩhadiburo dopa ta yaharãre õaro ĩhadibuque, arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Eropa arĩtuha dipaturi Simo Pedrore serẽpimi: —Simo, Jona magʉ, ¿diaye ta yʉre mahiri mʉhʉ? arĩmi Jesu daja. Ʉhresubu ĩgʉ eropa serẽpicʉ̃ peegʉ Simo Pedro turaro bʉjaweremi. —Opʉ, mʉhʉ masipehoa. Mʉre yʉ mahicʉ̃ masia mʉhʉ, arĩmi Simo Pedro. —Ovejare mari ejodiro dopa ta yaharãre buheque mʉhʉ. ");
INSERT INTO des_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Diaye mʉre arĩgʉ iiaa. Mʉhʉ mamʉ árĩgʉ mʉ suhrire saña, mʉ gamerogue curimʉribʉ mʉhʉ. Eropa árĩdi árĩqueregʉ ta pʉhrʉ mʉhʉ bʉgʉ árĩcʉ̃, mʉ mojotorire sĩbeocʉ̃ gajigʉ mʉre mʉ suhrire sãgʉcumi. Eropigʉ mʉ wadiabirogue mʉre aĩgãgʉcumi, arĩmi Jesu Simo Pedrore. ");
INSERT INTO des_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Eropa arĩgʉ Simo Pedro dohpa wa ĩgʉ sĩriborore wereyugʉ iimi. Eropigʉ Simo Pedro sĩrigʉ Goãmʉre, “Õagʉ, turagʉ ãhraa,” masa erã arĩcʉ̃ ĩgʉ iiborore wereyugʉ iimi. Eropigʉ Pedro mera weretamutuhagʉ õpa arĩmi Jesu ĩgʉre: —Diaye ta yʉ buhediro dopa iique mʉhʉ, arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ĩgʉ eroparĩcʉ̃ Pedropʉ yʉre Jesu ĩgʉ mahigʉre erãre yʉ nʉrʉsiacʉ̃ ĩami ĩgʉ. Yʉpʉ ĩgʉ ĩagʉpʉ ero core Jesu pohrogã badoagʉ ĩgʉre õpa arĩdigʉ árĩbʉ. “Opʉ, ¿mʉre ĩhaturirãre wiabupʉ nihino árĩcuri ĩgʉ?” arĩ Jesure serẽpidi árĩbʉ yʉpʉ. Eropa yʉre ĩagʉ Pedro serẽpimi Jesure: ");
INSERT INTO des_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","—Opʉ, ¿ihĩ Ñupʉ dohpa wagʉcuri? arĩ serẽpimi: ");
INSERT INTO des_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Ire mʉre werebeaa. I yebaguere yʉ dujariboro core ĩgʉre árĩniguicʉ̃ yʉ iicʉ̃ irire masibeaa mʉhʉ. Eropigʉ ĩgʉ waborore guñabita mʉhʉ. Diaye ta yʉ buhediro dopa iique mʉpʉ, arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Irire ĩgʉ yʉre Ñure wererare peerã árĩpehrerã Jesu yarã weresiririma. Irire weresirirã õpa arĩrima erã: “Jesu ĩgʉ mahigʉ buhegʉ sĩrisome,” arĩ weresiririma yʉre Jesu yarã erã basi. Erã eropa arĩquerecʉ̃ ta “Ĩgʉ sĩrisome,” arĩgʉ iibirimi Jesu. “I yebaguere yʉ dujaricʉ̃ ĩgʉre árĩniguicʉ̃ yʉ iicʉ̃ irire masibeaa mʉpʉ,” arĩmi Jesu Pedrore. ");
INSERT INTO des_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesu buhegʉ ire weregʉ, ipũre gojagʉ ãhraa yʉhʉ. Eropirã i wereri diaye ta árĩcʉ̃ masia mari. ");
INSERT INTO des_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Baja gaji sãre Jesu iimi. Ĩgʉ iirare mari gojapehocʉ̃ iripũri gojarapũri baja tariari pũri waboya. Eropiro iripũrire mari dibucʉ̃ sihajabiriboya i yeba. Ʉjʉtʉria waboya yʉ pepicʉ̃. Iripẽta ãhraa.");
INSERT INTO des_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teófilo, ero core yʉ gojamʉhtarapũ mera Jesu ĩgʉ iirare, ĩgʉ buherare mʉre weretuhabʉ. Te ʉmarogue ĩgʉ mʉriarare weretubʉ. Jesu ĩgʉ mʉriaboro core ĩgʉ Espíritu Santo turari mera dorepʉ ĩgʉ apinirãre. Erã ĩgʉ beyenirã árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Eropi Jesu ĩgʉ crusague ĩgʉ sĩrira pʉhrʉ yujuyerisuburi dʉpʉcʉgʉ dehyoapʉ ĩgʉ apinirãre. Cuarenta nʉri pʉhrʉ dehyoatupʉ. Eropigʉ ĩgʉ ĩgʉ basi ojocarigʉ árĩrire ĩhmupʉ erãre. Eropa dehyoagʉ Goãmʉ mari Pagʉ ĩgʉ opʉ árĩrire õari buherire werepʉ erãre. ");
INSERT INTO des_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Gajisubu Jesu ĩgʉ apinirã mera árĩgʉ õpa arĩ erãre werepʉ: —Jerusalén ta árĩnique dohpa. “Espíritu Santore mʉare obeogʉra,” yʉ Pagʉ ĩgʉ arĩdigʉre corenique. Irire ĩgʉ eropa arĩrare mʉare wereabʉ yʉhʉ. ");
INSERT INTO des_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ñu mʉare waĩyegʉ deco mera mʉare waĩyemi. Yʉpʉ ĩgʉ iira tauro iigʉra mʉare. Espíritu Santo mʉa mera ĩgʉ árĩniguicãcʉ̃ iigʉra mʉare, arĩpʉ Jesu. ");
INSERT INTO des_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Eropi gajisubu ʉtãgʉgue Olivo waĩcʉdigʉgue Jesu erãre dehyoacʉ̃ erã serẽpiñorã ĩgʉre: —Opʉ, ¿i Israe yebare mari ya yebare dohpárĩcʉ̃ gʉare dipaturi doreburire apibocuri mʉhʉ gʉare? ¿Dohpárĩcʉ̃ mari acawererã gohrare opʉ acugʉcuri mʉhʉ? arĩñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Erã eroparĩcʉ̃ peegʉ Jesu õpa arĩpʉ: —Mari Pagʉ dihta irinʉrire mʉa ya yebare mʉa õaro árĩborore apimasimi. Irinʉrire mʉare masiya mara. ");
INSERT INTO des_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Eropirã mʉare Espíritu Santo ĩgʉ eracʉ̃ Goãmʉ ya turarire oparãca mʉa. Iri turarire mʉa oparã Jerusalén majarãre, árĩpehrerã Judea majarãre, Samaria majarãre, árĩpehreri yeba majarãre õari buherire buherãca mʉa yaha árĩburire. Yʉ sĩrirare, yʉ masa mʉriarare erãre buherãca mʉa, arĩ werepʉ Jesu erãre. ");
INSERT INTO des_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eropa arĩ weretuhaja, Jesu ʉmarogue mʉria wapʉ. Erã ĩgʉre erã ĩhanʉrʉsia mujucʉ̃ imica cururi pohecague ñaja dedere mʉria wapʉ. ");
INSERT INTO des_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eropirã erã Jesu ĩgʉ mʉriagʉre erã ĩhanʉrʉsia mujurisubu perã anyua boreri suhricʉrã Jesu ĩgʉ apinirã pohro dehyoanʉgajañorã. ");
INSERT INTO des_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Eropirã erãre õpa arĩñorã: —Mʉa Galilea majarã, ¿duhpirã ĩhamuju niguirã iiri mʉa? Ihĩ Jesu ʉmarogue mʉriagʉ, ĩgʉ mʉriadiro dopa ta dipaturi arigʉcumi daja, arĩ wereñorã anyua. ");
INSERT INTO des_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Eropiira pʉhrʉ Jesu yarã ʉtãgʉgue Olivo waĩcʉdigʉgue árĩnirã dijari, Jerusaléngue dujajañorã. Irigʉ ʉtãgʉ yuju kilómetro wecañari Jerusalén ejaboro pohro árĩyoro. ");
INSERT INTO des_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Dujaja erã ʉmarogue erã árĩri taribugue mʉria wañorã. Oã árĩñorã erã: Pedro, Ñu, Santiago, Andre, Felipe, Toma, Bartolomé, Mateo, Santiago, Simo, Juda árĩñorã. Santiagopʉ Alfeo magʉ árĩpʉ. Simopʉ celote waĩcʉri curu majagʉ árĩpʉ. Judapʉ Santiago acaweregʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Eropirã bajasuburi oã árĩpehrerã, nome mera, María Jesu pago mera, Jesu pagʉ porã mera õaro gamenere, turaro mera Goãmʉre mari Pagʉre serẽmʉriñorã. ");
INSERT INTO des_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Eropi irinʉrire masa bajarã ciento veinte ejaboro gohra gamenereñorã. Eropigʉ Pedropʉ ĩgʉ mera majarã Cristo yarã watope nʉgaja, werepʉ erãre. ");
INSERT INTO des_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Yʉ acawererã, Goãmʉ iribojegue ĩgʉ arĩdiro dopa ta eropa wahaa. Irire Espíritu Santo Davire weredoreñumi Juda mʉrʉ eropa warare. Juda Jesure ñeha wejẽmorãre ĩhmudi árĩmi. ");
INSERT INTO des_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Juda mʉrʉ mari mera Jesu yare ii, gʉa mera majagʉ ta árĩrimi. ");
INSERT INTO des_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judapʉ ĩgʉ Jesure ĩhmura wajare iri niyerure ĩgʉ wiara pʉhrʉ ĩgʉ basi wejẽ sĩripʉ. Eropigʉ yuhridija wa, ĩgʉ gʉramisida yehguea sĩria wapʉ. Ĩgʉ wiara niyeru mʉra mera gajirã merogã yebare asũñorã. ");
INSERT INTO des_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Eropirã árĩpehrerã ohõ Jerusalén majarã masipehrecãma Juda mʉrʉ ĩgʉ ñero warare. Eropa masirã ĩgʉ niyeru mera erã asũra yebare Acéldama di cóãri yeba waĩcʉa, arĩma iri yebare. ");
INSERT INTO des_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Iribojegue erã arĩ gojadiro dopa ta eropa wahámi Juda mʉrʉ. Salmo waĩcʉripũgue õpa arĩ gojañuma: Ĩgʉ árĩdirore cóãdiro árĩporo. Eropirã gajirã ĩgʉ árĩdirore árĩbiricãporo, arĩ gojañuma. Ohõ sãre õpa arĩ gojañuma: Gajigʉ ĩgʉ mohmerare gohrotogʉ árĩgʉcumi, arĩ gojañuma Salmogue, arĩpʉ Pedro. ");
INSERT INTO des_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Eropirã mari yujugʉ beyerã Juda mʉrʉre gohrotobure. Ñu waĩyegʉ ĩgʉ masare buherasubu árĩdigʉre, Jesu mera mari mera árĩdigʉre beyero gahmea mari mera majagʉ árĩbure. Jesu masa mʉriacʉ̃ sãre ĩadigʉre beyero gahmea. Eropa beyera pʉhrʉ Jesu ĩgʉ masa mʉriarare mari mera buhegʉcumi, arĩ werepʉ Pedro ĩgʉ acawererãre Cristo yarãre. ");
INSERT INTO des_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ĩgʉ eroparĩcʉ̃ peerã perãre beyedoboñorã erã. Yujugʉ José Justo waĩcʉgʉre beyeñorã. Ĩgʉ Barsabá erã arĩ piyugʉ árĩpʉ. Eropirã gajigʉre Matia waĩcʉgʉre beyeñorã. ");
INSERT INTO des_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Erã perãre beyedobotuhaja, erãre Goãmʉre õpa arĩ serẽñorã: —Mʉhʉ gʉa Opʉ árĩpehrerã masa erã pepirire masia. Oã ãhrima gʉa perã beyerã. Juda mʉrʉre gohrotobure nihi mʉ gamegʉre beyeque. Juda mʉrʉ Jesure cóãdigʉ peamegue wadigʉ árĩmi. Eropigʉ ĩgʉre gohrotogʉ Jesu ĩgʉ apidigʉ árĩgʉcumi. Eropigʉ gʉa mera õari buherire buhegʉcumi, arĩñorã erã Goãmʉre. ");
INSERT INTO des_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eropa arĩrã ta ʉtã mera deamʉriñorã beyemorã. Matia yañe õaro wiricʉ̃, Matiapʉ Jesu ĩgʉ apinirã once apinirã mera majagʉ dujapʉ. ");
INSERT INTO des_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Eropii Pentecoste waĩcʉrinʉ árĩʉ̃ erã yujuro mera árĩpehrerã yuju wihi gamenereñorã. ");
INSERT INTO des_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Irisubure ta miruñe bʉrigã ariro dopa ta ʉmarogue bʉsʉro cariyoro. Ero eropa bʉsʉro caricʉ̃ peeñorã árĩpehrerã iri wihigue gamenere árĩrã. ");
INSERT INTO des_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Eropiro peame porãrigã dopa bejari erã árĩpehrerã dipu wecare dehyoayoro. Iri peame porãrigã nediru dopa bejari dehyoayoro. ");
INSERT INTO des_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Eropigʉ Espíritu Santo erapʉ erãre ĩgʉ turarire ogʉ arigʉ. Eropirã Espíritu Santo erãre ĩgʉ itamuropẽ erãpʉ gajirã yare õaro wereniguinʉgañorã. ");
INSERT INTO des_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Irinʉrire Jerusalén bajarã judio masa eranirã árĩñorã. Goãmʉre umupeorã erarã árĩñorã. Erã macari nʉcʉ majarã árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Eropirã ʉmarogue bʉsʉcʉ̃ peerã masa bajarã Jesu buherã pohrogue gamenere wahgãñorã. Masa nʉcʉ yare Jesu buherã erã wereniguicʉ̃ peeñorã. Erã eropa wereniguicʉ̃ peerã, erã pee ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","—Yaho, ¿Duhpirã oã Galilea majarã árĩquererã õaro mari yare wereniguiri? Erã mari masa dehyoadirogue árĩnirã iro dopa ta wereniguirã iima, arĩñorã erãpʉ. ");
INSERT INTO des_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Árĩpehrerã mari yare dohpaguere wereniguirã iima. Partia majarã, Media majarã, Elam majarã, Mesopotamia majarã, Judea majarã, Capadocia majarã, Ponto majarã, Asia majarã, Frigia majarã, Panfilia majarã, Egipto majarã, Africa majarã, Cirene majarã, Romague arirã ãhraa mari. Yujurãyeri judio masa ãhraa mari. Gajirã judio masa árĩbirã judio masa ya buheripʉre buherãgue ãhraa mari. ");
INSERT INTO des_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Creta majarã Arabia majarã sã mari mera ãhrima. Eropirã oã mari yare erã wereniguicʉ̃ peea mari. Erã mari ya mera Goãmʉ turari mera ĩgʉ õaro iirare wererã iima, arĩ wereniguiñorã masa erã basi. ");
INSERT INTO des_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Erã eropa arĩrã ʉca wañorã. Erã ĩarare erã peerare õaro masibiriñorã. —¿Dohpárĩrono oã gajirã ya mera Goãmʉ yare eropa õaro wereniguiri mʉa pepicʉ̃? arĩ game serẽpiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Eropirã gajirã wereyañorã. —¿Dohpa oã siburi ihrinijarã mererã iiri? arĩ wereyañorã gajirã erã basi. ");
INSERT INTO des_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Eropigʉ Pedro once Jesu ĩgʉ apinirã mera wahgãnʉgaja, masare werepʉ: —Mʉa Judea majarã, árĩpehrerã Jerusaléngue árĩrã, ire yʉ werecʉ̃ õaro peeque mʉa. ");
INSERT INTO des_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mʉa pepiri diaye árĩbeaa. Dohpaguere nueve ãhraa. Ʉmʉgue ãhraa. Eropirã oã merebeama. ");
INSERT INTO des_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Oã Goãmʉ iribojegue ĩgʉ werediro dopa ta iirã iima. Irire Joere Goãmʉ ya weremʉhtadigʉre ire weredoreñumi Goãmʉpʉ. ");
INSERT INTO des_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ojogorocʉrinʉ árĩcʉ̃ õpa árĩroca: Yʉhʉ Espíriture masare árĩpehrerãre obeogʉra. Eropirã mʉa porã Goãmʉ yare wererãcoma. Eropirã mʉa mera majarã mamarã Goãmʉ deyoro moarire ĩarãcoma. Eropirã mʉa mera majarã mʉrãpʉ quẽrire quẽrãcoma. ");
INSERT INTO des_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eropigʉ yʉ pohro majarãre yʉ Espíriture obeogʉra. Eropirã erã yahare wererãcoma. ");
INSERT INTO des_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eropigʉ yʉ turari mera iigʉca ʉmʉsigue. Yebague sãre yʉ turari mera irire ĩhmugʉca. Eropigʉ di mera, peame mera, imica mera ĩhmugʉca yʉ turarire. ");
INSERT INTO des_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yʉ eropiicʉ̃ abe ʉmʉ majagʉ naitĩa wagʉcumi. Ñami majagʉ abe diagʉ gʉhyaro wagʉcumi. Õpa waroca Cristo mʉa opʉ ĩgʉ dujariburinʉ, yʉ arĩranʉ core. Irinʉ ĩha ʉca warãca mʉa. Eropiro irinʉ gʉhyarinʉ árĩroca. ");
INSERT INTO des_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eropiro õpa árĩroca: Árĩpehrerã masa Cristore erã ñerire cóãdore serẽnirãre ĩgʉ erãre peamegue wabonirãre taugʉcumi Goãmʉ, arĩ gojañumi Joe, arĩpʉ Pedro masare. ");
INSERT INTO des_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mʉa Israe masa yʉhʉ werecʉ̃ peeque, arĩpʉ daja. Jesu Nazare majagʉpʉ Goãmʉ ĩgʉ obeodigʉ árĩmi. Jesure “Goãmʉ obeodigʉ ãhrimi,” masa erã arĩ masiboro dopa Jesu Goãmʉ turari mera deyoro moarire masare ii ĩhmucʉ̃ iidi árĩmi Goãmʉ Jesure. Mʉa irire masia. ");
INSERT INTO des_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mʉa Jesure wejẽdorecʉ̃ Goãmʉ iribojegue ĩgʉ “Eropa waroca,” ĩgʉ arĩdiro dopa ta eropa wahabʉ. Eropirã mʉa Jesure crusague wejẽdorerã wiabʉ ĩgʉre masa ñerãre. ");
INSERT INTO des_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Goãmʉpʉ Jesu sĩridigʉre masuami. Eropigʉ dipaturi ne sĩrisome ĩgʉ. Ĩgʉ sĩri wajabeami. Eropa ojocariniguicãbu ãhrimi. ");
INSERT INTO des_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Õpa arĩñumi Davi iribojegue majagʉ Cristo ĩgʉ arĩbodiro dopa ta: Yʉ Opʉ, yʉ mera ãhraa mʉhʉ. Ʉmʉri nʉcʉ Goãmʉ yʉ Opʉ yʉ pohro mʉhʉ árĩcʉ̃ ĩamʉrabʉ yʉhʉ güibiriboro dopa. ");
INSERT INTO des_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Mʉhʉ Goãmʉ yʉ sĩporãre sĩrinirã erã árĩroguere ne cóãsome. Yʉre mʉ mahigʉre ñerogue yʉ sĩporãre cóãsome mʉhʉ. Yʉhʉ mʉ pohro majagʉ mʉre umupeogʉ ãhraa. Yʉ dʉpʉre boadoresome mʉhʉ. Eropigʉ bʉrigã mucubiria. Mucubiriri mera wereniguia. Eropigʉ mʉre Goãmʉre bʉrigã umupeogʉ árĩgʉ güiro mariro õaro árĩcãa. ");
INSERT INTO des_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yʉre dipaturi ojocaricʉ̃ iigʉca mʉhʉ. Yʉ mera mʉhʉ árĩcʉ̃ bʉrigã mucubiria, arĩ gojañumi Davi Cristo ĩgʉ arĩbodiro dopa ta, arĩpʉ Pedro. ");
INSERT INTO des_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Acawererã, õpa õaro weregʉra mʉare Davire mari acaweregʉ mʉrʉre, iribojegue majagʉre, arĩnemopʉ daja Pedro. Ĩgʉ Davi sĩria wañumi. Eropigʉ ĩgʉre erã yaara gobe dohpaguere árĩnia. Eropigʉ “Yʉ dʉpʉre boadoresome mʉhʉ,” arĩ gojagʉ ĩgʉ basi waĩpeo weregʉ iibiriñumi. ");
INSERT INTO des_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Iribojegue Goãmʉ Davire õpa arĩñumi: “Diaye ta arĩgʉ iiaa. Mʉ pãramerã árĩturiarã mera majagʉ mʉ iiro dopa ta i maca majarã weca opʉ árĩgʉcumi,” arĩñumi Goãmʉ Davire. Davi Goãmʉ yare wereyugʉ árĩñumi. Eropigʉ Cristore Goãmʉ ta opʉ acuborore masigʉ, Cristo ĩgʉ masa mʉriaborore weremʉhtatuhañumi Davipʉ. Õpa arĩ wereñumi ĩgʉ: “Ĩgʉ sĩrinirã erã árĩroguere árĩwajasome. Ĩgʉ dʉpʉ ero boasome,” arĩñumi Davi. ");
INSERT INTO des_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ĩre Jesucristore Goãmʉ masuami. Ĩgʉ masudigʉre gʉa árĩpehrerã ĩabʉ. ");
INSERT INTO des_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Eropigʉ Cristo ʉmarogue mari Pagʉ diayepʉ árĩcumi doregʉ árĩgʉ. Eropigʉ ĩgʉ Pagʉ “Espíritu Santore yebague obeogʉra,” arĩpʉ ĩgʉre. Eropigʉ Cristopʉ Espíritu Santore dohpaguere obeomi gʉare. Eropirã Espíritu Santore ĩgʉ gʉare obeorare ĩarã iiaa mʉa. Eropirã mʉa peea. ");
INSERT INTO des_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davipʉ Jesu ĩgʉ mʉriadiro dopa ta ʉmaroguere mʉriabiriñumi. Eropigʉ ĩgʉ ĩgʉ basi õpa arĩñumi: Goãmʉ arĩmi yʉ Opʉre: “Ohõ yʉ diayepʉ doaque mʉhʉ. ");
INSERT INTO des_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Eropigʉ mʉre ĩhaturirãre mʉre tarinʉgabasagʉra yʉhʉ mʉ pohro majarã dopa árĩmorãre,” arĩmi Goãmʉ yʉ Opʉre, arĩ gojañumi Davi. ");
INSERT INTO des_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Eropirã árĩpehrerã Israe masa ire õaro masique mʉa. Ihĩ Jesure mʉa crusague wejẽdigʉre mʉa opʉ acuami Goãmʉpʉ. Ĩgʉre mʉare taubure Cristore apiami Goãmʉ, arĩ werepʉ Pedro masare. ");
INSERT INTO des_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ĩgʉ eroparĩcʉ̃ peerã bʉrigã bʉjawere, güirã masapʉ Pedro sãre serẽpi ĩañorã: —Gʉa acawererã, ¿dohpa iirãcuri gʉa? arĩ serẽpi ĩañorã erã. ");
INSERT INTO des_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Erã eropa arĩ serẽpi ĩacʉ̃ yʉhripʉ Pedro sã. —Mʉa ñero iirire bʉjawererã árĩque. Õarire gohrotoque. Eropirã Jesu waĩ mera waĩyenirã árĩque mʉa árĩpehrerã. Mʉa eropa iicʉ̃ mʉa ñerire cãdijigʉcumi Goãmʉ. Mʉa eropa iicʉ̃ Espíritu Santo mʉa mera árĩgʉcumi. Goãmʉ ĩgʉ Espíritu Santore eropa ocãgʉcumi mʉare. ");
INSERT INTO des_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mʉare, mʉa porãre, mʉa pãramerã árĩturiarãre yoarogue majarãre, árĩpehrerã Goãmʉ mari Opʉ ĩgʉ beyenirãre “Diaye ta itamugʉra mʉare,” arĩ apiñumi Goãmʉ, arĩpʉ Pedro masare. ");
INSERT INTO des_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Eropa arĩtuhaja baja werenemopʉ Pedro. Eropigʉ turaro mera werepʉ erãre. —I yeba majarãre erã ñero iira dipuwaja dipuwaja moagʉcumi Goãmʉ. Eropirã mʉapʉ Goãmʉ yarã árĩque. Mʉa eropa árĩcʉ̃ ĩgʉ mʉare dipuwaja moasome, arĩpʉ Pedro masare. ");
INSERT INTO des_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ĩgʉ eroparĩcʉ̃ peerã bajarã ĩgʉ wereniguirire õaro peeñorã. Eropigʉ ĩgʉ sã erãre waĩyepʉ. Eropirã Goãmʉ yarã mera majarã tres mil masa wanemoñorã. ");
INSERT INTO des_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eropirã erã masa Cristo ĩgʉ apinirã mera ʉmʉri nʉcʉ árĩmʉriñorã. Eropirã erã buherire ʉmʉri nʉcʉ peemʉriñorã. Erã barire game guere, Goãmʉre serẽ, Cristo ĩgʉ apinirã mera õaro árĩcãñorã erã. ");
INSERT INTO des_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Eropii Goãmʉ ĩgʉ turari mera deyoro moarire ii ĩhmuñorã ĩgʉ apinirã. Erã eropa iicʉ̃ ĩarã masa árĩpehrerã ĩha ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Eropirã árĩpehrerã Jesure umupeorã gamenere, õaro árĩcãñorã. Eropirã erã yare game gueremʉriñorã. ");
INSERT INTO des_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Erã yare dua, árĩpehrerãre gajinore moorãre erã nʉcʉ omʉriñorã erã. ");
INSERT INTO des_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Eropirã ʉmʉri nʉcʉ erã Goãmʉ wihigue gameneremʉriñorã. Árĩpehrerã yujurãyeri erã wirigue yujuyeri cururi mucubiriri mera gamenere bamʉriñorã. ");
INSERT INTO des_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Erã eropa gamenererisubu “Goãmʉ õagʉ ãhrimi,” arĩ umupeomʉriñorã. Eropirã gajirã masa erãre gametarimʉriñorã. Eropigʉ ʉmʉri nʉcʉ Goãmʉ gajirãre ĩgʉ yarã wacʉ̃ iimʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ñamicague tres árĩcʉ̃ Goãmʉre serẽrisubu árĩcʉ̃ Pedro, Ñu mera Goãmʉ wihigue warã iiñorã. Iri wihi disiporo yujugʉ ʉmʉ doapʉ. ");
INSERT INTO des_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ʉmʉri nʉcʉ iri wihi disiporo õari disiporo waĩcʉri disiporo gajirã ĩgʉre aĩgãri duhudoboñorã. Ĩgʉ ʉmʉpʉ ne masa dehyoagʉgue ta curimasibigʉ árĩpʉ. Eropigʉ ĩgʉ iri disiporo pohro doagʉ niyerure serẽmʉripʉ iri wihire ñajarãre. ");
INSERT INTO des_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Eropii Pedro, Ñu iri wihigue erã ejanʉgajacʉ̃ curimasibigʉpʉ erãre ĩha, niyerure serẽpʉ. ");
INSERT INTO des_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Eropirã erã Pedro, Ñu mera ĩgʉre ĩha, Pedropʉ õpa arĩpʉ: —Gʉare ĩaque mʉhʉ, arĩpʉ Pedro ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ĩgʉ eroparĩcʉ̃ peegʉ erãre ĩha “Niyerure orãcoma yʉre,” arĩ pepiripʉ. ");
INSERT INTO des_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ĩgʉ eropa arĩ pepiquerecʉ̃ ta Pedro ĩgʉre õpa arĩ werepʉ: —Niyerure opabeaa yʉhʉ. Opabiriqueregʉ ta ire iigʉra yʉhʉ mʉre. Jesucristo Nazare majagʉ ĩgʉ turari mera curique mʉhʉ, arĩpʉ Pedro curimasibigʉre. ");
INSERT INTO des_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Eropa arĩgʉ ta ĩgʉ mojotore diayepʉ maja mojotore ñeha, ĩgʉre tarawahgũ nugupʉ. Irisubu ta curimasibigʉ ĩgʉ guburire, ĩgʉ ñigarire turari ñajayoro. ");
INSERT INTO des_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Iri eropa ñajara pʉhrʉ ĩgʉ wahgãnʉgajapʉ. Eropigʉ ĩgʉ waha buhrima mʉria “Goãmʉ turagʉ õagʉ ãhrimi,” ĩgʉ arĩ mucubiridiro mera erã mera Goãmʉ wihigue ñajaapʉ pare. ");
INSERT INTO des_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ĩgʉ eropa curicʉ̃, “Goãmʉ õagʉ ãhrimi,” arĩ gaguiniguicʉ̃ masa árĩpehrerã ĩgʉre ĩañorã. ");
INSERT INTO des_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Eropirã masa ĩgʉre ĩha masiñorã. “Ihĩ iri wihi maja disiporo õari disiporo pohro ĩgʉ niyerure serẽ doagʉ ãhrimi,” arĩñorã erã. Eropirã ĩgʉ eropa curicʉ̃ ĩarã ĩhamaria wañorã. ");
INSERT INTO des_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Eropii curimasibiridigʉ Pedro sãre ĩgʉ duhubirisubu, masa árĩpehrerã ĩhamaria warã Pedro sã pohro omagã, gamenereñorã. Erã Goãmʉ wihigue árĩrã Salomo waĩcʉripʉgue árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Erã eropa gamenerera pʉhrʉ Pedropʉ werepʉ erãre. —Mʉa Israe masa, ¿duhpirã ĩre ĩha ʉcari? ¿Duhpirã gʉare mʉa ĩhanʉrʉri? Gʉapʉ gʉa ya turari mera, Goãmʉre gʉa umupeori mera, gʉa ejatuharo ĩre curicʉ̃ iibirabʉ gʉa. Jesu irire iiami. ");
INSERT INTO des_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mari ñecʉ sʉmarã mʉra Abrahã, Isaa, Jacobo mʉra Goãmʉre umupeomʉriñorã. Erã umupeodigʉpʉ Goãmʉpʉ ĩgʉ magʉre Jesure turagʉ, õagʉ ĩgʉ árĩcʉ̃ ĩhmumʉrimi. Mʉa Jesure ĩhaturirãre ohabʉ. Eropigʉ Pilato ĩgʉre ĩgʉ peresugue wiudiacʉ̃ mʉapʉ ĩgʉre ĩgʉ wiucʉ̃ gamebirabʉ. Pilatore Jesure ohabʉ mʉa. ");
INSERT INTO des_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pilato ĩgʉre wiudiarami. Mʉapʉ Jesure õagʉre, õaro iigʉre gamebirã gajigʉre masa wejẽdigʉpʉre wiudoreabʉ mʉa. ");
INSERT INTO des_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Eropirã Jesure mari ojocaricʉ̃ iigʉre wejẽabʉ mʉa. Ĩgʉ sĩricʉ̃ Goãmʉ ĩgʉre masuami. Ĩgʉre masudigʉre gʉa ĩabʉ. ");
INSERT INTO des_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Eropirã gʉa ĩgʉre umupeorã ãhraa. Gʉa eropa umupeocʉ̃ ĩagʉ ĩre mʉa dohpague ĩagʉre mʉa ĩha masigʉre Jesupʉ ĩgʉ turari mera ĩgʉ curicʉ̃ iiami. ");
INSERT INTO des_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Yʉ acawererã, mari oparã mera Jesure õaro masibiriquererã ĩgʉre wejẽabʉ mʉa. Irire masia yʉhʉ. ");
INSERT INTO des_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Iribojegue majarã Goãmʉ yare weremʉhtanirã Goãmʉ erãre ĩgʉ weredorediro dopa ta wereñuma erã sã. “Cristo ñero tarigʉcumi,” arĩ wereyuñuma erã. Erã eropa arĩ werediro dopa ta eropa wabʉ dohpaguere. ");
INSERT INTO des_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Eropirã dohpaguere mʉa ñero iirare bʉjawererã árĩque. Õaripʉre gohrotoque. Cristore umupeoque. Mʉa eropa iicʉ̃ mʉa ñerire cãdijigʉcumi Goãmʉ. Eropigʉ mʉare mucubiririnʉrire apigʉcumi ĩgʉ. Eropirã õaro sĩñajarãca. ");
INSERT INTO des_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Eropigʉ Goãmʉ Cristore ĩgʉ beyedigʉre mʉare obeogʉcumi daja. Cristo Jesu ta ãhrimi. ");
INSERT INTO des_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ĩgʉ Jesu Goãmʉ pohrogue árĩcumi dohpa. Iribojegue Goãmʉ ĩgʉ yare weremʉhtanirãre wereyudoreñumi ĩgʉ iiburire. Ĩgʉ werediro dopa ta árĩpehrero amugʉ iicumi. Ĩgʉ amutuhaja Cristore obeogʉcumi daja. ");
INSERT INTO des_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moise irire weregʉ õpa arĩñumi: “Mari mera majagʉre mari acaweregʉre Goãmʉ yare weremʉhtagʉre Goãmʉ mari Opʉ obeogʉcumi mʉare. Yʉre ĩgʉ obeodiro dopa ta obeogʉcumi ĩgʉ sãre. Eropirã mʉare ĩgʉ werecʉ̃ peepehrecãrãca mʉa. ");
INSERT INTO des_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Õpa árĩroca. Árĩpehrerã ĩgʉre peebirã, ĩgʉ dorerire iibirã ĩgʉ cóãnirã árĩrãcoma. Goãmʉ yarã mera majarã árĩsome erã,” arĩmʉriñumi Moise iribojeque. ");
INSERT INTO des_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Árĩpehrerã Goãmʉ yare weremʉhtanirã nʉcʉ, Samue ĩgʉ pʉhrʉ árĩrã sã i dohpague warire wereyuñuma. ");
INSERT INTO des_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mari ñecʉ sʉmarãre iribojegue majarãre “Masare õaro iigʉra,” arĩ weremʉriñumi. Ĩgʉ erãre werediro dopa iimi marire dohpaguere. Eropigʉ Abrahãre ĩgʉ arĩdiro dopa ta mari sãre arĩ weregʉ iiñumi. Õpa arĩ wereñumi Goãmʉ Abrahãre: “Árĩpehreri yeba majarãre õaro iigʉra. Õpa irire iigʉra: Mʉ acaweregʉ pʉhrʉ árĩgʉpʉ masare õaro iibasagʉcumi yʉre,” arĩñumi Goãmʉ Abrahãre. ");
INSERT INTO des_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Maripʉre Goãmʉ Jesure ĩgʉ magʉre ĩgʉ masudigʉre mari pohrogue obeomʉhtami mari ñero iirare cóãbure. Eropa iigʉ ĩgʉ mʉare õaro iiami, arĩpʉ Pedro erãre. ");
INSERT INTO des_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","3","Ĩgʉ eropa wereniguisubu pahia, Goãmʉ wihire corerã surara opʉ, saduceo masa sã erãre peeñorã. Õpa buhepʉ Pedro Ñu mera masare: —Jesu ĩgʉ sĩrira pʉhrʉ masa mʉria wami. Ĩgʉ eropa masa mʉriacʉ̃ ĩarã, pʉhrʉ mari sã ĩgʉ yarã mari masa mʉriaborore masia mari, arĩ werepʉ Pedro sã. Erã eroparĩcʉ̃ peerã, oparãpʉ erã mera guañorã. Eropa guarã naimerecʉ̃ ĩarã erã Pedrore, gajirã Jesu apinirã sãre ñeha, peresu iiñorã. ");
INSERT INTO des_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Oparã eropa gamebiriquerecʉ̃ ta masa bajarã Goãmʉ yare Pedro sã buherire peerã “Diaye ta ãhraa,” arĩ pepiñorã erã. Eropirã Jesu yarã bajarã wañorã. Erã ʉma dihtare queocʉ̃ Jesure umupeorã cinco mil masa árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Eropii gajinʉ iri maca majarã mʉrã, oparã, judio masa buherã mera Jerusaléngue gamenereñorã. ");
INSERT INTO des_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Eropigʉ pahia opʉ Ana waĩcʉgʉ ero árĩpʉ. Ĩgʉ acawererã sã árĩñorã. Caifa, Ñu, Alejandro, gajirã mera Ana acawererã árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Eropirã erã Pedro sãre erãre gamebeocʉ̃, surarapʉ peresugue erãre aĩwiu oparã watopegue erãre aĩ ejañorã. Erã eropa iira pʉhrʉ oparã serẽpi ĩañorã Pedro sãre. —¿Noa ya turari mera mʉa curimasibigʉre õagʉ iiari? ¿Noa ãhriri mʉare irire iidoregʉ? arĩ serẽpi ĩañorã erã. ");
INSERT INTO des_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Erã eroparĩcʉ̃ peegʉ Espíritu Santo ĩgʉ itamurire õaro opagʉ werepʉ Pedro erãre. ");
INSERT INTO des_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—Mʉa oparã, mʉa mʉrã, ¿gʉa curimasibigʉre gʉa õagʉ iirare serẽpi ĩarã iiri mʉa gʉare? ");
INSERT INTO des_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ire masique mʉa árĩpehrerã, Israe masa. Ire Jesucristo eropa iiami. Jesu Nazare majagʉ, mʉa crusague wejẽdigʉ, Goãmʉ masudigʉ, ĩgʉpʉ ihĩ curimasibigʉre õagʉ wacʉ̃ iiami. Eropirã ĩre dohpaguere mʉa ĩhuro ĩgʉ curicʉ̃ ĩhaa mʉa. Õpa ãhraa Goãmʉ yare erã gojarapũgue Cristore wereyuro: ");
INSERT INTO des_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Ihĩ Cristo ʉtãye iro dopa ta Goãmʉ beyedigʉ ãhrimi. Ĩgʉ Goãmʉ beyedigʉ árĩquerecʉ̃ masa ĩgʉre gamesome. Ĩgʉre erã gamebiriquerecʉ̃ Goãmʉ ĩgʉre opʉ acuami árĩpehrerãre dorebure,” arĩ gojañumi iribojegue. ");
INSERT INTO des_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne gajigʉ masare peamegue wabonirãre taugʉ ne marimi. I yebaguere Jesu dihta masare taugʉ ãhrimi. Ne gajirã ĩgʉ iro dopa árĩrã ne marima, arĩ werepʉ Pedro erãre. ");
INSERT INTO des_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ĩgʉ eropa arĩ werera pʉhrʉ, Pedro Ñu mera buheya marirã erã árĩcʉ̃ ĩarã, güiro mariro erã buhecʉ̃ ĩarã, mʉrã, oparã, judio masa buherã mera pee ʉca wañorã. Eropirã Jesu iro dopa erã buhecʉ̃ ĩarã, õpa pepiñorã erã. “Pedro, Ñu sã diaye ta Jesu mera majarã ta ãhrima oã,” arĩ pepiñorã erã. ");
INSERT INTO des_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eropigʉ curimasibiridigʉ Pedro sã mera árĩpʉ. Ĩgʉ, ĩgʉ õagʉ árĩcʉ̃ ĩañorã mʉrã, oparã, judio masa buherã mera. Eropirã erã Pedro sãre “Ñero iirã iiaa,” arĩ weresãmasibiriñorã. ");
INSERT INTO des_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Eropa weresãmasibirã oparã erã gamenereri taribugue árĩrãre Pedro sãre wiriadoreñorã. ");
INSERT INTO des_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Erã wiriara pʉhrʉ erã basi weretamuñorã. —¿Oãre dohpa iirãcuri mari? arĩ wereniguiñorã erã. Õpa arĩ wereniguinemoñorã: —Pedro, Ñu mera Goãmʉ turari mera curimasibigʉre curicʉ̃ iinirã ãhrama. Eropirã Jerusalén majarã árĩpehrerã erã eropa õaro iirare masiama. Eropirã maripʉ “Eropa iibirama erã,” arĩmasibeaa mari. ");
INSERT INTO des_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Eropirã Jesu ĩgʉ buherare gajirãre buhedorebiricãrã erãre gajirã erã buherire gameri arĩrã, arĩ wereniguiñorã erã erã basi. ");
INSERT INTO des_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Eropa arĩ wereniguituha Pedro sãre sihubeo õpa arĩñorã: —Jesu ĩgʉ buherare ne buhebiricãque gajirãre. Irire ne wereniguibiricãque, arĩriñorã erãre. ");
INSERT INTO des_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Erã eroparĩcʉ̃ peerã Pedro Ñu mera õpa arĩñorã erãre: —Mʉa õpa arĩcʉ̃ mʉare yʉhrirã Goãmʉpʉre tarinʉgãrã iiboca gʉa. ¿Nihi yapʉre gʉa werecʉ̃ gahmeri mʉa? ¿Mʉa yapʉre gʉa iicʉ̃ gahmeri mʉa? ¿Goãmʉ yapʉre gʉa iicʉ̃ gahmeri mʉa? ");
INSERT INTO des_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gʉapʉre gʉa ĩarare, gʉa peerare gʉare yayasãma masiya mara masare, arĩ yʉhripʉ Pedro Ñu mera. ");
INSERT INTO des_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Erã eroparĩcʉ̃ peerã oparãpʉ dipaturi doreriñorã daja erãre. —Jesu ĩgʉ buherare mʉa buherã ñero tarirãca mʉa, arĩriñorã oparã erãre. Erãre “Ñu, Pedro mera ñero iirã iima,” arĩmasibiriñorã erã. Eropirã masapʉ curimasibiridigʉ ĩgʉ õagʉ wacʉ̃ ĩarã, “Goãmʉ diaye ta õagʉ ãhrimi,” arĩñorã masa. Erã eroparĩcʉ̃ peerã oparãpʉ Pedro sãre dipuwaja moamasibiri, erãre wiuñorã. ");
INSERT INTO des_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Curimasibigʉ õagʉ erã iidigʉ cuarenta bojori opagʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Eropii, Pedro Ñu mera erã mera majarã pohrogue eja, pahia oparã, mʉrã erãre erã arĩrare wereñorã. ");
INSERT INTO des_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Erã eroparĩcʉ̃ peerã erã árĩpehrerã yujuro mera mari Pagʉre Goãmʉre serẽñorã. —Gʉa Opʉ, mʉhʉ ʉmarore, yebare, diarire iigʉ, árĩpehrerãre ojocaricʉ̃ iigʉ ãhraa mʉhʉ. ");
INSERT INTO des_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mʉ Espíritu Santo gʉa ñecʉre Davi mʉrʉre mʉ pohro majagʉre õpa weredoreyoro mʉ arĩdiro dopa ta: ¿Duhpirã judio masa árĩbirã guari? Pee masibirã ãhrima masa. ");
INSERT INTO des_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Baja macari majarã oparã gamenere, mari Opʉ Goãmʉre, ĩgʉ opʉ acudigʉ Cristo sãre ĩhaturi, ñero iidiama erã, arĩ weredoreyoro mʉhʉ Davire iribojeguere. ");
INSERT INTO des_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Eropa ta ãhraa, arĩ serẽnemoñorã Goãmʉre. I macare Herode, Poncio Pilato, judio masa árĩbirã, judio masa mera mʉ beyedigʉre Jesure õagʉ mʉ pohro majagʉre wejẽdia gamenereama. ");
INSERT INTO des_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Irisubu mʉ gamediro dopa ta “Eropa waroca,” mʉ arĩdiro dopa ta iiama erã. Mʉ masiri mera eropa wereyoro mʉhʉ. ");
INSERT INTO des_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Eropigʉ, gʉa Opʉ, erã gʉare “Mʉa buheri waja ñero tarirãca,” erã arĩrare guñaque mʉhʉ. Gʉare itamuque. Eropigʉ gʉare mʉ pohro majarãre güiro mariro mʉ buherire weredoreque gʉare. ");
INSERT INTO des_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mʉhʉ mʉ turari mera dorecʉrãre õarã iique. Eropigʉ mʉ buherire güiro mariro werecʉ̃ iique gʉare. Eropigʉ mʉ deyoro moarare Jesu mʉ pohro majagʉ ĩgʉ turari mera ii ĩhmudoreque gʉare. Eropigʉ dorecʉrãre õarã gʉa wadorecʉ̃ mʉ turari mera itamuque gʉare, arĩ serẽñorã erã mari Pagʉre. ");
INSERT INTO des_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Erã eropa arĩ serẽra pʉhrʉ, erã gamenereri wihi ñohmemaa wayoro. Ero eropa ñohmecʉ̃ ta Espíritu Santo ĩgʉ turari mera guñaturarã wacʉ̃ iipʉ erãre. Eropa warã, Espíritu Santo ĩgʉ dorediro dopa ta iiñorã. Güiro mariro Goãmʉ yare wereñorã erã. ");
INSERT INTO des_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","33","Eropirã Goãmʉ ĩgʉ turari mera erã Jesu ĩgʉ apinirã õpa arĩ wereñorã masare: Jesure Goãmʉ masudigʉre gʉa ĩabʉ, arĩ wereñorã erã masare. Eropigʉ Goãmʉ erã árĩpehrerãre õaro itamumʉripʉ. Eropirã Jesure umupeorã bajarã árĩñorã. Erã yujuropa ta pepirã árĩmʉriñorã. Eropirã erã erã yare erã doberire “Yaha dihta ãhraa,” ne arĩbiriñorã. Erã árĩpehrerã erã yare gajinore moorãre erã mera majarãre dʉca wamʉriñorã. ");
INSERT INTO des_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Eropirã erã mera majarã mojomorocʉrã marimʉriñorã. Erã mera majarã yeba oparã, wiri oparã erã yare duamʉriñorã. ");
INSERT INTO des_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Eropa duarã erã wajasearare erã aĩgãri, Jesu ĩgʉ apinirãre omʉriñorã. Eropirã erãpʉ irire erã mera majarãre dʉca wamʉriñorã. Árĩpehrerã opabirãre dʉca wañorã. ");
INSERT INTO des_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Irisubure yujugʉ erã mera majagʉ José waĩcʉgʉ árĩpʉ. Jesu ĩgʉ apinirã Josére Bernabé waĩyeñorã. Ĩgʉ waĩ Bernabé “Masare mucubiricʉ̃ iigʉ ãhrimi,” arĩma Griego ya mera. Ĩgʉ Leví ya curu majagʉ Chipre nʉgʉro majagʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Eropigʉ ĩgʉ poeri opagʉ árĩgʉ irire duapʉ. Eropigʉ ĩgʉ wajasearare Jesu ĩgʉ apinirãre ópʉ ĩgʉ gajirãre gueredoregʉ. ");
INSERT INTO des_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gajirã sã Bernabé iro dopa iimʉririñorã. Erã Ananía waĩcʉgʉ, ĩgʉ marapo Safira waĩcʉgo árĩñorã. Eropigʉ Ananía erã ya poerire duapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Eropa duaqueregʉ ta ĩgʉ wajasearare ĩgʉ basi aĩpʉ. Ĩgʉ marapo sã ĩgʉ eropa iirare masipo. Eropigʉ erã wajasea dʉharare aĩgãri, Jesu ĩgʉ apinirãre ópʉ Ananíapʉ. Eropa ogʉ, “Opehogʉ iiaa,” arĩripʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ĩgʉ eropa iicʉ̃ ĩagʉ Pedro ĩgʉre werepʉ. —Ananía, watĩ mʉre gʉyadorecʉ̃ mʉhʉ gʉyabʉ Espíritu Santore. Eropigʉ mʉa ya poerire dua, mʉ wajasearare mʉ basi aĩbu ãhrabʉ mʉhʉ. ");
INSERT INTO des_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mʉ duaboro core mʉa ya poeri árĩribʉ. Eropiro mʉ duara pʉhrʉ mʉ ya wajatari ta ãhrabʉ. ¿Eropigʉ dohpa árĩronore eropa gʉyari mʉhʉ? Mʉhʉ gʉa dihtare gʉyabeaa. Goãmʉ sãre gʉyabʉ mʉhʉ, arĩpʉ Pedro ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ĩgʉ eroparĩcʉ̃ peegʉ ta, Ananíapʉ mehmereja, sĩria wapʉ. Eropirã árĩpehrerã ĩgʉ eropa warare masirã, bʉrigã güiñorã. ");
INSERT INTO des_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ĩgʉ sĩrira pʉhrʉ mamarã ahri, ĩgʉ dʉpʉre suhri mera oma, disiporogue aĩgã, yaañorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Eropii ʉhre hora pʉhrʉ Ananía mʉrʉ marapo ĩgʉ sĩrirare masibigo Pedro pohrogue ñajapo. ");
INSERT INTO des_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Eropigʉ Pedro igore õpa arĩpʉ: —¿Mʉa ya poerire duanijarã dipẽ wajatari mʉa? arĩpʉ ĩgʉ. Eropigo igo igo marapʉ mʉrʉ ĩgʉ arĩrañepẽ ta, “Iripẽta wajatabʉ gʉa,” arĩ wereripo igo sã. ");
INSERT INTO des_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Eropigʉ Pedro igore werepʉ: —¿Duhpirã mʉa yujuro mera Goãmʉ Espíriture gʉya ĩhadiari mʉa? Peeque dohpaguere. Mʉ marapʉ mʉrʉre yaanirã ta ahrima daja. Mʉ sãre mʉ dʉpʉre aĩrã ahrima, arĩpʉ Pedro. ");
INSERT INTO des_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ĩgʉ eropa arĩ werecʉ̃ ta igo mehmereja, sĩria wapo. Eropirã mamarã iri wihire ñajarã, igo ya dʉpʉ mʉrarore aĩ wiria wañorã. Aĩgã, igo marapʉ mʉrʉ dipaba yaañorã. ");
INSERT INTO des_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eropirã Jesu yarã árĩpehrerã gajirã irire peerã sã, güitariacãñorã. ");
INSERT INTO des_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Eropirã masa watope Jesu ĩgʉ apinirã bajasuburi Goãmʉ turari mera deyoro moarire ii ĩhmumʉriñorã. Eropirã erã Salomo waĩcʉri taribugue õari taribugue gameneremʉriñorã. ");
INSERT INTO des_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Eropirã gajirã erãre güirã, erã pohrogue wabiriñorã. Eropa güiquererã erãre Jesu ĩgʉ apinirãre, “Õarã ãhrima oã,” arĩñorã masa. ");
INSERT INTO des_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eropirã ʉma, nome bajarã Jesure umupeonʉgañorã. ");
INSERT INTO des_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Eropirã erã dorecʉrãre aĩgãri, omasiariñe mera pũtãpi apigãñorã Pedro waburi mague erãre. Eropirã dorecʉrãre õarã wacʉ̃ gamerã Pedro erãre ĩgʉ ñapeocʉ̃ gameñorã erã aĩgãnirãpʉ. Erãre ĩgʉ ñapeobiricʉ̃ Pedro erã weca ĩgʉ watĩ merejariñe dihtare gameñorã erã. Iri dihtare gameñorã erã erã õarã waboro dopa. ");
INSERT INTO des_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Eropirã Jerusalén pohro árĩri macari majarã sã, dorecʉrãre, watẽa ñajasũnirã sãre aĩgãriñorã. Eropirã erã árĩpehrerã erã dʉpʉ õaro wañorã. ");
INSERT INTO des_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ĩgʉ eropa iicʉ̃ ĩarã pahia opʉ, ĩgʉ mera majarã mera Pedro sãre peyocʉpʉ. Pahia opʉ mera majarã saduceo masa árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pedro sã iirare peerã erã guatarirã Jesu ĩgʉ apinirãre ñehadore, peresu iiñorã. ");
INSERT INTO des_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Eropiira pʉhrʉ iri ñami ta Goãmʉ ĩgʉ anyu pãgũpʉ erãre peresugue árĩrãre. Tuhajanugu erãre wiriridore õpa arĩ werepʉ anyu: ");
INSERT INTO des_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Goãmʉ wihigue waque. Iri wihigue árĩrã Goãmʉ masare ĩgʉ tauburire, iri õari buherire wereque masare, arĩpʉ anyu erãre. ");
INSERT INTO des_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ĩgʉ eroparĩcʉ̃ peerã ñamigã ñari Goãmʉ ya wihigue ñaja, masare buheñorã erã. Irinʉ ta pahia opʉ, ĩgʉ mera majarã, Israe masa oparã mera gamenere, Jesu ĩgʉ apinirãre peresugue árĩrãre aĩgãridoreripʉ surara oparãre. ");
INSERT INTO des_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eropirã surara oparã peresugue doarãpʉre aĩgãrirã wariñorã. Erãre bocabiriñorã. Bocabiri dujaa wañorã daja. ");
INSERT INTO des_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Dujaja wereñorã erã oparãre. —Peresugue árĩri disiporori bihara disiporori ãhrabʉ. Eropirã erã iri disiporori pohro peresu iinirãre corerã niguiama. Eropa ĩabʉ gʉa. Eropirã gʉa disiporore pãgũcʉ̃, masa marabʉ, arĩ wereñorã erã. ");
INSERT INTO des_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Erã eroparĩcʉ̃ peerã, surara Goãmʉ wihire corenirã opʉ, pahia oparã mera irire pee ʉca wa, “¿Dohpa waha ojogorocʉrãcuri erã eropa iirã?” arĩ pepiñorã erã. ");
INSERT INTO des_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Eropigʉ erã pohrogue gajigʉ ahri, erãre werepʉ. —Mʉa peresu iinirã Goãmʉ wihigue ãhrama. Ĩarã waque bu. Iri wihigue masare buherã iiama erã, arĩ werepʉ. ");
INSERT INTO des_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ĩgʉ eroparĩcʉ̃ pee, surara opʉ, ĩgʉ surara mera waha, Jesu ĩgʉ apinirãre dipaturi ñeagãriñorã daja. Eropa ñearã erãre surara turibiriñorã. Eropirã erãre pabonirã árĩquererã, masare güirã pabiriñorã erãre. “Oãre mari pacʉ̃ gajirã masapʉ ʉtã mera dearãcoma marire,” arĩ pepiñorã erã surarapʉ. ");
INSERT INTO des_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Eropirã erãre aĩgãri, oparã core duhudoboñorã erãre. Erã eropa aĩ eraa dobocʉ̃ pahia opʉ erãre turipʉ. ");
INSERT INTO des_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Mʉare gʉa weretuhabʉ. Jesu yare buhebiricãque, arĩrabʉ gʉa mʉare. Gʉa eropa arĩquerecʉ̃ ta mʉapʉ árĩpehrerã Jerusalén majarãre buhea mʉa. Jesu ĩgʉ sĩrira waja, gʉare dipuwajacʉcʉ̃ iidiarã iica mʉa, arĩpʉ pahia opʉ. ");
INSERT INTO des_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ĩgʉ eroparĩcʉ̃ peegʉ Pedropʉ gajirã Jesu ĩgʉ apinirã mera yʉhripʉ. —Goãmʉ ĩgʉ dorerapʉre iimʉhtarãra. Eropirã pʉhrʉ Goãmʉ gamecʉ̃ masa erã dorerire iirãra. ");
INSERT INTO des_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Goãmʉ mari acawererã iribojegue majarã opʉ Jesure masudi árĩmi. Ĩgʉ ta ãhrimi mʉa crusague pabia wejẽdigʉ. ");
INSERT INTO des_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jesure masura pʉhrʉ Goãmʉ ĩgʉre “Õagʉ ãhrimi,” arĩ, ĩgʉ diayepʉ doadoremi Jesure ĩgʉ Pagʉpʉ. Eropigʉ Jesu masa opʉ, masare masugʉ árĩgʉ, Israe masare erã ñeri iirare bʉjawererã árĩdoregʉ, erã ñerire cóãdiami Jesu. ");
INSERT INTO des_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Eropirã gʉapʉ Jesu ĩgʉ iirare ĩanirã árĩrã irire werea gʉa. Espíritu Santo irire ĩhmugʉ árĩgʉ weremi ĩgʉ sã. Ĩgʉre Espíritu Santore Goãmʉ obeoami. Árĩpehrerã Goãmʉ dorerire iirãre ĩgʉ Espíritu Santore ohomi, arĩ werepʉ erãre. ");
INSERT INTO des_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ĩgʉ eroparĩcʉ̃ peerã oparãpʉ guatariacãñorã. Eropirã erã Jesu ĩgʉ apinirãre wejẽdiariñorã. ");
INSERT INTO des_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Irisubure erore Gamalie fariseo masʉ ero árĩgʉ erãre wejẽdoregʉ iibiripʉ. Ĩgʉ oparã mera majagʉ, dorerire buhegʉ ĩgʉ árĩcʉ̃, masa erã umupeogʉ árĩpʉ. Eropigʉ Ĩgʉ Jesu ĩgʉ apinirãre merogã coredoregʉ gajipʉgue erãre aĩgãdorepʉ surarare. ");
INSERT INTO des_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Erã eropa aĩgãra pʉhrʉ ĩgʉpʉ werepʉ masare. —Mʉa Israe masa, oãre mʉa iiburire õaro pepique mʉague wejẽri arĩrã. ");
INSERT INTO des_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Guñaque Teuda mʉrʉre. Ĩgʉ, ĩgʉ basi “Masare tarinʉgagʉ ãhraa yʉhʉ,” arĩmi masare. Eropirã masa bajarã cuatrocientos masa ĩgʉ mera majarã dujama. Eropirã gajirãpʉ ĩgʉre wejẽnirã árĩma. Ĩgʉ sĩricʉ̃ ĩha ĩgʉ buherire buhenirãpʉ wasiria wanirã árĩma. Eropirã erã dohpaguere marima. ");
INSERT INTO des_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pʉhrʉ masare erã queorisubu árĩcʉ̃ Galilea majagʉ Juda waĩcʉgʉ masare ĩgʉ buhecʉ̃ ĩgʉ mera masa bajarã dujama. Ĩgʉ sã sĩria wadi árĩmi. Eropii ĩgʉ yarã árĩpehrerã wasiria wanirã árĩma erã sã. ");
INSERT INTO des_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Eroparĩgʉ dohpaguere mʉare ire arĩgʉ iiaa. Eropa ĩacãque oãre Jesu yare wererãre. Eropii i buheri oã erã ya buheri Goãmʉ ya buheri árĩbiro, pehrea waroca. ");
INSERT INTO des_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Goãmʉ ya buheripʉ árĩro, ne pehresome. I buheri Goãmʉ ya árĩcʉ̃ ne ire ne dederecʉ̃ iimasibeaa mʉa. Mʉa ire dederecʉ̃ iidiarã Goãmʉ mera gamequeãrã iiboca mʉa, arĩpʉ Gamalie erãre. Ĩgʉ eropa arĩ werecʉ̃ peerã, “Diaye ta ãhraa,” arĩ, peeñorã oparã. ");
INSERT INTO des_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Eropirã erã Jesu apinirãre sihubeo, erã eracʉ̃ ĩarã erãre tãrañorã. “Jesu yare buhebiricãque mʉa,” arĩtuhaja, erãre wadoreñorã. ");
INSERT INTO des_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Eropa wadorecʉ̃ peerã erã oparã pohrogue árĩnirã waha wañorã. Jesu ya árĩburire ñero tarirã bʉrigã mucubiriñorã Jesu ĩgʉ apinirã. ");
INSERT INTO des_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Eropirã ʉmʉri nʉcʉ erã ya wirigue, Goãmʉ wihigue sãre Jesucristo yare buhe weremʉriñorã erã. ");
INSERT INTO des_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Irinʉrire Jesure umupeorã bajarã wañorã. Eropirã griego masa judio masa mera gameturiñorã erã Jesu yarã dihta árĩquererã. Griego masa wapeweyarã nomere ʉmʉri nʉcʉ erã barire õaro erã guerebiricʉ̃ ĩarã judio masare turiñorã. ");
INSERT INTO des_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Eropirã Jesu ĩgʉ apinirã, docepʉ Jesure umupeorãre árĩpehrerãre erã pohrogue sihubeo, õpa arĩ wereñorã: —Gʉa Goãmʉ yare buherã ãhraa gʉa. Barire gueremorãno árĩbeaa gʉa. ");
INSERT INTO des_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Eropirã mʉa gʉa acawererã, siete ʉmare, gajirã “Õarã,” erã arĩrãre, Espíritu Santo oparãre amaque. Erãpʉre barire gueredoreque mʉa. ");
INSERT INTO des_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Eropirã gʉapʉ ʉmʉri nʉcʉ Goãmʉre serẽ Goãmʉ yare buherãca, arĩñorã Jesu apinirã erã Jesure umupeorãre. ");
INSERT INTO des_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Erã eroparĩcʉ̃ peerã, “Áʉ, eropa ta iirã,” arĩñorã erã árĩpehrerã Jesure umupeorã. Eropirã Estebanre Cristore umupeogʉre, Espíritu Santo turarire wʉaro opagʉre beyeñorã erã. Gajirã sãre beyeñorã. Felipere, Prócorore, Nicanore, Timore, Parmenare, Nicolare bari gueremorãre beyeñorã erã. Nicolapʉ judio masʉ árĩbigʉ Antioquía majagʉ judio masa buherire gamegʉ erã mera ñajadigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Erã beyenirãre Jesu ĩgʉ apinirã pohro aĩ erañorã gajirã Jesu yarãpʉ. Erã eropa aĩ eracʉ̃ ĩarã erã Goãmʉre serẽbasañorã. Eropirã erã beyenirã weca erã mojotorire duhpeoñorã Goãmʉ turarire orã. ");
INSERT INTO des_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eropirã iri yeba majarã Goãmʉ yare masipehrenijarã iiñorã. Eropirã Jerusaléngue árĩrã Jesure umupeorã bajarã wanemoñorã daja. Eropirã pahia sã bajarã Jesu yarã wañorã. ");
INSERT INTO des_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Eropigʉ Esteban Goãmʉ turarire opagʉ árĩpʉ. Ĩgʉ Goãmʉ õaro iigʉ árĩpʉ. Eropigʉ ĩgʉ Goãmʉ turari mera deyoro moarire ii ĩhmupʉ masa erã ĩaro. ");
INSERT INTO des_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Judio masa erã buheri wihi majarã ĩgʉre ĩhaturiñorã. Eropirã ĩgʉ mera game dʉyasonʉgañorã. Erã Liberto waĩcʉrã árĩñorã. Eropirã erã Cirene majarã, Alejandría majarã, Cilicia majarã, Asia majarã mera bajarã árĩñorã erã Esteban mera dʉyasorã. ");
INSERT INTO des_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Esteban masigʉ dopa ta, Espíritu Santore wʉaro opagʉ ta ĩgʉ wereniguicʉ̃ peerã erã yujuro bojebiriñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Eropa yujuro bojebirã erã gajirãre ahma gʉyadore, wajayeñorã erãre. Erã eropa gʉyadorecʉ̃ õpa arĩ weresãñorã erã Estebanre: —Ihĩ Goãmʉre ĩgʉ ñero wereniguicʉ̃, Moisere ĩgʉ ñero wereniguicʉ̃ sãre gʉa peeabʉ, arĩ weresãriñorã erã gʉyarãpʉ gajirãre. ");
INSERT INTO des_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Erã eroparĩcʉ̃ peerã masa, judio masa buherã, mʉrã sã ĩgʉ mera guañorã. Eropirã erã Estebanre ñeha erã oparã pohro aĩgãñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Eropirã erã gajirãre gʉyanemodoreñorã. Õpa arĩñorã erãpʉ: —Ihĩ ʉmʉri nʉcʉ Goãmʉ wihire, ĩgʉ doreri sãre ñero wereniguigʉ ãhrimi. Peeabʉ gʉa ĩgʉre ĩgʉ õpa arĩcʉ̃. “Jesu Nazare majagʉ Goãmʉ wihire cóãgʉcumi. Eropigʉ ĩgʉ Moise dorerare marire ĩgʉ wererare gohrotogʉcumi Jesu,” arãmi Esteban gʉa peecʉ̃, arĩ gʉya weresãriñorã erã. ");
INSERT INTO des_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eropirã árĩpehrerã ero doarã Estebanre õaro ĩhamehtu, ĩgʉ diapore ĩañorã erã. Anyu iro dopa deyoyoro ĩgʉ diapo. ");
INSERT INTO des_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Eropii pahia opʉ serẽpipʉ Estebanre. —¿Oã erã arĩri diaye ta ãhriri? arĩ serẽpipʉ ĩgʉ Estebanre. ");
INSERT INTO des_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ĩgʉ eroparĩcʉ̃ peegʉ, Estebanpʉ erãre õpa arĩ werepʉ: —Acawererã, mʉrã, gʉa pagʉ sʉmarã, peeque. Abrahã mari ñecʉ mʉrʉ iribojegue majagʉ Mesopotamiague ĩgʉ árĩcʉ̃, Harángue ĩgʉ árĩboro core, Goãmʉ turagʉ gosesiriro dopa ĩgʉre Abrahãre dehyoañumi. ");
INSERT INTO des_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Eropa dehyoagʉ Goãmʉ wereñumi ĩgʉre. “Mʉ ya yebare mʉ acawererã mera árĩbiricãque. Eropigʉ gaji yebague waque. Mʉ eropa wacʉ̃ mʉre iri yebare ĩhmugʉra yʉhʉ,” arĩpʉ Goãmʉ Abrahãre. ");
INSERT INTO des_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ĩgʉ eroparĩcʉ̃ peegʉ Abrahã sã Caldea majarã ya yeba árĩrã wañuma. Pʉ Harángue ejañuma. Erogue eja árĩñuma. Eropigʉ ĩgʉ pagʉ ĩgʉ sĩrira pʉhrʉ i yeba dohpague mʉa árĩri yeba Goãmʉ ta árĩdoreñumi Abrahãre. ");
INSERT INTO des_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ĩgʉre eropa árĩdorequeregʉ Goãmʉ Abrahã ĩgʉ árĩri yebare õaro gohra apibirimʉriniñumi ĩgʉre. Ne merogã apibiriniñumi. Eropigʉ Abrahã ĩgʉ porã marigʉ árĩquerecʉ̃ ta Goãmʉpʉ ĩgʉre õpa arĩ wereñumi. “Mʉre mʉ pãramerã gaji turi majarãguere i yebare ogʉra,” arĩñumi Goãmʉ Abrahãre. ");
INSERT INTO des_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Eropa arĩgʉ ta õpa arĩ werenemoñumi Goãmʉ Abrahãre. “Mʉ pãramerã gaji turi majarãgue gaji yebague waha, erogue gajirã pohro árĩrã erã pohro majarã árĩrãcoma erã. Eropirã cuatrocientos bojori gohra ero majarã ñero iirãcoma mʉ pãramerã árĩturiarãguere. ");
INSERT INTO des_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Eropigʉ ero majarãre erã eropa iira waja dipuwaja moagʉra yʉhʉ. Yʉhʉ eropiira pʉhrʉ mʉ pãramerã i yeba erarãcoma daja. Eropirã i yeba yʉ dorerire iirãcoma erã,” arĩñumi Goãmʉ Abrahãre. ");
INSERT INTO des_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Eropa arĩgʉ Goãmʉ “Yʉ arĩdiro dopa ta iigʉra,” arĩgʉ Abrahã ĩgʉ guñaburire õpa apiñumi ĩgʉre. Merogã gasirogãre ĩgʉ dʉpʉre wiri aĩdoreñumi ĩgʉre, ĩgʉ eropa arĩ wereraguere guñadoregʉ. Eropiira pʉhrʉ Abrahã Isaare porãcʉñumi. Ocho nʉri pʉhrʉ merogã gasirogãre wiri aĩñumi Isaa dʉpʉ sãre. Pʉhrʉ Isaa Jacobore ĩgʉ porãcʉra pʉhrʉ wiri aĩñumi ĩgʉ dʉpʉ sãre. Eropigʉ Jacobo doce gohra porãcʉñumi. Erã docepʉ mari cururi nʉcʉ oparãgue árĩmʉriñuma. ");
INSERT INTO des_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Eropirã erã Jacobo porã mari ñecʉ sʉmarã mʉra Josére erã pagʉ magʉre peyocʉmʉriñuma. Ĩgʉre cohã, duacãñuma Egiptogue warãre. Eropigʉ Josére Goãmʉ itamumʉriñumi. ");
INSERT INTO des_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ĩgʉ ñero taricʉ̃ ĩagʉ Goãmʉ ĩgʉre itamumʉriñumi. Ĩgʉ eropa itamucʉ̃ Josépʉ õaro pee masigʉ wañumi. Eropigʉ faraõ Egipto majagʉ opʉpʉ Josére ĩgʉ gamecʉ̃ iiñumi Goãmʉpʉ. Ĩgʉ eropiicʉ̃ faraõpʉ Josére Egipto majagʉ opʉ, ĩgʉ ya wihi majagʉ opʉ apiñumi. ");
INSERT INTO des_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Eropii irisubure ta Egiptogue, Canaa waĩcʉri yeba sã ne deco aribiriyoro. Eropirã ero majarã ñero tariñuma. Eropirã Canaague árĩrã Jacobo porã mari ñecʉ sʉmarã mʉra bari bocabirimʉriñuma. ");
INSERT INTO des_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Eropigʉ Egiptogue trigo árĩcʉ̃ peegʉ, Jacobo ĩgʉ porãre erogue bari asũdoregʉ ne obeogʉ iiñumi. ");
INSERT INTO des_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pʉhrʉ Egiptogue erã ejacʉ̃ José ĩgʉ tĩrãre wereñumi. “Mʉa pagʉ magʉ ta ãhraa yʉhʉ,” arĩñumi erãre. Eropigʉ José acawererãre ne ĩagʉ iiñumi opʉ faraõ waĩcʉgʉ. ");
INSERT INTO des_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pʉhrʉ José ĩgʉ tĩrãre erã pagʉ Jacobore sihudoregʉ obeoñumi. Ĩgʉ acawererã setenta y cinco masa árĩñuma irisubu. ");
INSERT INTO des_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ĩgʉ magʉ ĩgʉ sihubeocʉ̃ peegʉ Jacobo Egiptogue wañumi ĩgʉ magʉ pohrogue. Ĩgʉ magʉ pohro ãhri, pʉhrʉ sĩria wañumi pare. Eropirã ĩgʉ porã mari ñecʉ sʉmarã mʉra erogue sĩripehrea wañuma erã sã. ");
INSERT INTO des_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Eropirã Siquẽ waĩcʉri yebague erã dʉpʉre aĩ, masa goberigue seatuha yaañuma erã dʉpʉre. Abrahã ĩgʉ asũra yebague árĩyoro iri yeba erãre yaara yeba. Ero core Abrahã iri yebare Hamor porãre asũyuñumi niyeru mera. ");
INSERT INTO des_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Eropigʉ Goãmʉ Abrahãre “I yebare ogʉra mʉre,” arĩmʉriñumi. “Iri yebare ogʉra,” ĩgʉ arĩrasubu ejacʉ̃ Abrahã pãramerã Israe masa bajarã masa wañuma. Egiptogue árĩñuma. ");
INSERT INTO des_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Egipto yeba erã árĩnicʉ̃, gajigʉ opʉ ñajañumi. Eropigʉ ĩgʉ opʉpʉ José mʉrʉre masibiriñumi. ");
INSERT INTO des_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Eropigʉ ĩgʉ mari acawererãre ñero iidia, erã porãre wejẽdia, erã porãre wejẽ cóãcãdoreñumi erãre. Eropigʉ mari ñecʉ sʉmarãre ñero iiñumi opʉ faraõpʉ. ");
INSERT INTO des_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ĩgʉ eropiirisubu Moise árĩbupʉ masa dehyoañumi. Ĩgʉ õagʉ, Goãmʉ õaro ĩhasʉagʉ árĩmʉriñumi. Eropirã ĩgʉ pagʉ sʉmarã ʉrerã abe gohra õaro ĩhadibuñuma ĩgʉgãre. ");
INSERT INTO des_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Moisere dibunemomasibiricʉ̃ ĩgʉre erã cóãra pʉhrʉ opʉ mago ĩgʉre boca aĩ majaa, igo magʉ iro dopa ta dibuñumo ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eropirã Egipto majarã õaro masirã yare buheñuma Moisere. Eropigʉ güiro mariro wereniguigʉ opʉ iro dopa iigʉ árĩñumi Moise. ");
INSERT INTO des_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Eropigʉ Moise cuarenta bojori ĩgʉ opaboro core ĩgʉ acawererãre Israe masare ĩadiagʉ erã pohrogue curigʉ wañumi. ");
INSERT INTO des_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Eropa curigʉ ejagʉ Egipto majagʉ Moise acaweregʉre ĩgʉ ñero iicʉ̃ Moise ĩañumi. Eropa ĩagʉ ĩgʉ acaweregʉre itamuñumi Moise. Ĩgʉ acaweregʉre itamugʉ Egipto majagʉpʉre pa wejẽcãñumi ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Eropirgʉ Moise õpa arĩ pepiriñumi. Yʉ acawererã erã acaweregʉre yʉ itamucʉ̃ ĩarã, ‘Goãmʉ marire õaro taricʉ̃ iidoregʉ obeoñumi ĩre,’ yʉ acawererã yʉre arĩ pepirãcoma,” arĩ pepiriñumi Moise. Erãpʉ ne eropa pepibiriñuma. ");
INSERT INTO des_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Gajinʉ Moise ĩgʉ acawererãre perã erã basi gamequeãrãre ĩapʉ. Eropigʉ ĩgʉ erãre bosariñumi. “¿Mʉa basi árĩquererã gamequeãri mʉa?” arĩñumi Moise erãre. ");
INSERT INTO des_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ĩgʉ eroparĩcʉ̃ peegʉ yujugʉ ĩgʉ acaweregʉre ñero iigʉ Moisere tuubeoñumi. “Mʉhʉ gʉa opʉ árĩbeaa. Gʉare doregʉ árĩbeaa mʉhʉ. ");
INSERT INTO des_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Carʉ̃re Egipto majagʉre mʉ wejẽdiro dopa ta yʉ sãre wejẽdiagʉ iiri mʉhʉ?” arĩñumi ĩgʉ Moisere. ");
INSERT INTO des_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ĩgʉ eroparĩcʉ̃ pee ʉca wa Moise oma duhrigã waha wapʉ. Madián waĩcʉri yebague waha wañumi. Erogue nomeore boca perã porãcʉñumi. ");
INSERT INTO des_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Eropii Moise cuarenta bojori gohra ero ĩgʉ árĩra pʉhrʉ Sinaí waĩcʉdigʉ ʉtãgʉ pohro masa marirogue ĩgʉ árĩcʉ̃ anyu ĩgʉre dehyoañumi. ");
INSERT INTO des_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Eropa irigʉgã ʉ̃jʉcʉ̃ ĩagʉ Moise ĩha ʉca wañumi. Iri peamere pohrogã õaro ĩgʉ ĩagʉ wacʉ̃ gohra Goãmʉ ĩgʉre wereñumi. ");
INSERT INTO des_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Goãmʉ ãhraa yʉhʉ. Mʉ ñecʉ sʉmarã, Abrahã, Isaa, Jacobo erã Goãmʉ ãhraa yʉhʉ,” arĩñumi Goãmʉ Moisere. Ĩgʉ eroparĩcʉ̃ peegʉ Moisepʉ naragãñumi. Ne ĩha wahgũbiriñumi. ");
INSERT INTO des_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Eropigʉ Goãmʉ wereñumi ĩgʉre. “Dohparagã yʉ pohro niguigʉ iiaa mʉhʉ. Eropigʉ gʉhyadiaro mera mʉ zapature tuweaque. ");
INSERT INTO des_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yaharã masa Egiptogue erã ñero taricʉ̃ ĩabʉ. Erã sĩwererire peeabʉ. Eropigʉ erãre itamugʉ ahrabʉ. Erã eropa wacʉ̃ ĩagʉ waque mʉ sã. Egiptogue mʉre obeogʉra erãre itamudoregʉ,” arĩñumi Goãmʉ Moisere. ");
INSERT INTO des_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Erãpʉ mari acawererã Israe masa Moisere gamebirituhajañuma. “Mʉhʉ gʉa opʉ árĩbeaa. Mʉhʉ gʉare doregʉ árĩbeaa,” Moisere eropa arĩrã gamebirã iituhajañuma. Eropa erã Moisere gamebiriquerecʉ̃ Goãmʉ ĩgʉre Egiptogue obeoñumi mari acawererãre, Israe masare itamubure, erãre dorebure. Ĩgʉ eropa obeogʉ anyupʉre ĩgʉre yucʉgʉgue dehyoadigʉre itamudoreñumi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moise ta mari acawererãre Israe masare Egiptogue árĩrãre wiudigʉ árĩñumi. Eropigʉ Egiptogue eja, ihĩ Moise Goãmʉ turari mera ii ĩhmunʉgañumi. Eropigʉ wʉariya diariyague eropa ta iiñumi daja. Pʉhrʉguere masa marirogue sãre cuarenta bojori gohra Goãmʉ turari mera deyoro moarire ii ĩhmumʉriñumi ĩgʉ erãre. ");
INSERT INTO des_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ihĩ Moisepʉ mari acawererãre Israe masare weremʉriñumi. “Yʉ iro dopa ta Goãmʉ yare weremʉhtabure Goãmʉ obeogʉcumi. Eropigʉ ĩgʉ mʉa mera majagʉ mʉa acaweregʉ árĩgʉcumi. Ĩgʉ eropa eracʉ̃ ĩgʉre õaro peeque mʉa,” arĩmʉriñumi Moise erãre. ");
INSERT INTO des_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moise masa marirogue mari acawererã Israe masa mera árĩmʉriñumi. Eropigʉ mari ñecu sʉmarã iribojegue majarã mera árĩñumi ĩgʉ. Eropa árĩgʉ Sinaí waĩcʉdigʉ ʉtãgʉgue ĩgʉre weredigʉ anyu mera árĩñumi. Erogue Goãmʉ ĩgʉ dorerire aĩdigʉ árĩñumi Moise. ");
INSERT INTO des_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","“Iri dorerire ʉtãgʉgue Moise waha aĩrisubu mari ñecʉ sʉmarã mʉra Egiptogue dujadiarã Moisere tarinʉgañuma. Erã ĩgʉre gamebiriñuma. Eropa gamebirã Aarõre Moise tĩgʉre õpa arĩñuma: “¿Ĩgʉ Moise marire Egiptogue aĩgãridi dohpa wayuri ĩgʉ? Masibirica mari. Eropigʉ goãmarã wéanirãre iique mari yarã árĩmorã. Eropirã mʉ wéanirã marire doreri mari wadiari maha marire aĩgãrãcoma,” arĩñuma erã. ");
INSERT INTO des_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Eropa arĩra pʉhrʉ erã wecʉre oro mera wéañuma. Eropa iituhaja, erã waimʉrãre wejẽ, erã wéadigʉ pohro aĩgãri umupeoñuma ĩgʉre. Eropirã erã erã iidigʉre wecʉre ĩarã, mucubiri, bosenʉ iiñuma. ");
INSERT INTO des_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Eropigʉ Goãmʉ erã wéadigʉre erã umupeocʉ̃ ĩagʉ, erãre cóãcãriñumi. “Erã yʉre cóãrã gajirã ʉmaro majarãpʉre umupeo curaporo,” arĩgʉ cohãgã wariñumi. Goãmʉ yare weremʉhtanirã õpa arĩ gojañuma Goãmʉ wereniguirire: Mʉa Israe masa, yʉre ñe ñero iiabʉ. Masa marirogue cuarenta bojori gohra árĩrã waimʉrãre mʉa wejẽnirãre mʉa soenirãre yʉre mʉa obodiro dopa ta umupeorabʉ mʉa. Eropirã yʉpʉre umupeobirabʉ mʉa. ");
INSERT INTO des_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Eropirã mʉa Molo waĩcʉgʉre umupeorã árĩrã, ĩgʉre umupeori wihire iiabʉ mʉa. Eropirã “Refa gʉa goãmʉ ãhrimi,” arĩrã ĩgʉ necãmʉ mʉa wéadigʉre mʉa umupeoabʉ daja. Erã wéanirãre mʉa iinirãre mʉa umupeoabʉ. Mʉa eropa iira waja mʉare Babilonia sipʉgue cóãbeogʉra yʉhʉ, arĩñumi Goãmʉ ĩgʉ ya weremʉhtanirã mera. ");
INSERT INTO des_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Eropirã masa marirogue Goãmʉ masa mera ĩgʉ árĩri wihire waimʉrã gasiri wihire opamʉriñuma mari ñecʉ sʉmarã iribojegue majarã. Iri wihi Goãmʉ masa mera ĩgʉ wereniguiri wihi árĩyoro. Iri wihigue Goãmʉ dorerire ĩgʉ gojara mijiri ʉtã mijiri árĩyoro. Iri wihire Goãmʉ ĩgʉ werediro dopa ta Moisere ĩgʉ ĩhmudiro dopa ta ii ĩhacũdoreñumi Goãmʉ Moisere. ");
INSERT INTO des_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pʉhrʉgue majarã mari ñecʉ sʉmarã Josué mera iri wihire aĩgãriñuma mari árĩri yebague erarã. Erã iri yebaguere Goãmʉ ĩgʉ apira yebaguere erã eraboro core iri yeba majarã mʉrare Goãmʉ cóãcãñumi. Irisubure Goãmʉre umupeori wihire waimʉrã gasiri wihire opamʉriñuma mari ñecʉ sʉmarã. Ne Davi mʉrʉ ĩgʉ árĩcʉ̃gue opatuñuma iri wihire. ");
INSERT INTO des_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Eropigʉ Davi mʉrʉ Goãmʉre mucubiricʉ̃ iiñumi. Eropigʉ Goãmʉ ya wihi árĩburire iidiagʉ Davipʉ serẽriñumi Goãmʉre. ");
INSERT INTO des_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ĩgʉ eropa serẽquerecʉ̃ ta Salomopʉ Davi magʉpʉ Goãmʉ ya wihire iiñumi. ");
INSERT INTO des_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ĩgʉ eropa iiquerecʉ̃ ta Goãmʉpʉ masa erã iira wihiguere árĩbeami. Õpa arĩñumi Goãmʉ wereniguirire weremʉhtadigʉ: ");
INSERT INTO des_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ʉmarogue yʉ doaro ãhraa. Ero doagʉ dorea yʉhʉ. Eropiro yebapʉ yʉ guburire duhpeoro iro dopa ta ãhraa. Yʉhʉ turatariagʉ ãhraa. Yaha wihi árĩborore iimasibeaa mʉa. Goãmʉ yʉ árĩcʉ̃ yʉ árĩburi wihire mʉa iimasibeaa. ");
INSERT INTO des_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yʉ basi i yebare árĩpehrero iiabʉ yʉhʉ, arĩmi Goãmʉ, arĩ gojañumi Goãmʉ yare weremʉhtadigʉ, arĩpʉ Esteban. ");
INSERT INTO des_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Eropigʉ õpa werenemopʉ Esteban erãre: —Mʉa ne yʉhridiabirã ãhraa. Goãmʉ yare peequererã, ĩgʉre yʉhridiabeaa. Espíritu Santore tarinʉgataria mʉa. Mʉa ñecʉ sʉmarã erã iidiro dopa ta iiaa mʉa. ");
INSERT INTO des_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mʉa ñecʉ sʉmarã árĩpehrerã Goãmʉ ya weremʉhtanirãre ñero iiñuma. Erã Goãmʉ yare weremʉhtanirãpʉ “Pʉhrʉ õagʉ Goãmʉ yare weremʉhtagʉ arigʉcumi,” arĩ erã wererã árĩcʉ̃ peeñuma mʉa ñecʉ sʉmarã mʉra. Eropa arĩ werenirã mʉrare wejẽmʉriñuma. Eropirã “Õagʉ,” erã arĩgʉre mʉa sã dohpaguere ĩgʉ ya curu majarã árĩquererã ta ĩgʉre wejẽabʉ. ");
INSERT INTO des_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Goãmʉ dorerire anyuapʉ wereriñuma mʉare. Eropirã mʉa iri dorerire opariyoro. Eropirã iri dorerire tarinʉgabʉ mʉa, arĩ wereniguitupʉ pare Esteban. ");
INSERT INTO des_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ĩgʉ eroparĩcʉ̃ peerã erãpʉ bʉrigã guañorã. Eropa turaro guarã, gʉhyarã wañorã. ");
INSERT INTO des_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Erã eropa guaquerecʉ̃ ta ĩgʉ Espíritu Santo ĩgʉ dorero dopa ta iipehogʉ árĩgʉ, ĩgʉ turarire õaro opagʉ árĩgʉ, ʉmarogue ĩhamemuju Goãmʉ gosesiririre ĩapʉ Esteban. Jesu Goãmʉ diayepʉ ĩgʉ niguicʉ̃ ĩapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eropa ĩagʉ õpa arĩpʉ —Ʉmarogue merogã ero tuweamaacʉ̃ Jesu Goãmʉ obeodigʉ Goãmʉ diayepʉ ĩgʉ niguicʉ̃ ĩhaa yʉhʉ, arĩpʉ Esteban. ");
INSERT INTO des_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ĩgʉ eroparĩcʉ̃ peerã ta erã bʉrigã gaguinigui, erã gamirire bihacã, yujuro mera ĩgʉ pohrogue omagã, ĩgʉre ñeañorã. ");
INSERT INTO des_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ñehatuhaja, ĩgʉre aĩgã, iri maca tʉro pohrogue cóãñorã ĩgʉre. Eropirã ʉtãyeri mera dea wejẽcãñorã erã ĩgʉre. Erã eropa wejẽboro core ĩgʉre ʉtãyeri mera deamorã erã weca maja suhrire tuwea, mamʉre Saulo waĩcʉgʉre iri suhrire opabasadoreñorã erã. ");
INSERT INTO des_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Eropigʉ Esteban erã ĩgʉre ʉtãyeri mera dea wejẽrisubu õpa arĩpʉ. —Jesu yʉ Opʉ, yʉ sĩporãre aĩque, arĩpu. ");
INSERT INTO des_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Eropigʉ ĩgʉ mereja õpa arĩpʉ: —Opʉ Jesu, oã dohpague ñero erã yʉre iirire erãre dipuwaja moabita mʉhʉ, arĩpʉ Esteban. Eropa arĩtuhajagʉ ta sĩria wapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Eropigʉ Esteban ĩgʉ sĩricʉ̃ ĩagʉ, “Õhaa,” arĩpʉ Saulo. Eropirã irinʉre ta Jesu yarãre Jerusaléngue árĩrãre ñero iinʉgañorã Jesure gamebirãpʉ. Erã eropa ñero iicʉ̃ Jesu yarã Judea yebague, Samaria yebague yoarogue duhrisirigã wañorã. Jesu ĩgʉ apinirã dihta wabiriñorã. ");
INSERT INTO des_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Eropirã gajirã Goãmʉre umupeorã Esteban dʉpʉ mʉrarore yaa, bʉrigã oreñorã erã. ");
INSERT INTO des_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulopʉ Jesu yarãre ñetariaro iimʉriripʉ. Ĩgʉ erã ya wirigue ñaja, ʉmare, nomere ñeha, peresugue bihadobomʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Eropirã yoarogue wasirinirã Jesu yarãpʉ Jesu yare buheñorã. ");
INSERT INTO des_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Eropigʉ Felipe Samaria waĩcʉri macague eja, Jesu yare buhepʉ iri maca majarãre. ");
INSERT INTO des_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ĩgʉ eropa buhecʉ̃ ero majarã õaro peeñorã. Eropirã Goãmʉ turari mera deyoro moarire ĩgʉ ii ĩhmucʉ̃ ĩañorã erã. Eropa ĩarã ĩgʉre õaro peeñorã erã. ");
INSERT INTO des_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bajarã watẽa ñajasũnirãre ĩgʉ pohro erã eracʉ̃ ĩagʉ watẽapʉre wadorepʉ ĩgʉ. Watẽapʉ bʉrigã gaguinigui, duhugã waha wañorã erãre. Eropigʉ bajarã dʉpʉ bʉhanirãre, curimasibirãre dʉpʉ õarã iimʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ĩgʉ eropa iicʉ̃ ĩarã iri maca majarã bajarã masa mucubiriñorã. ");
INSERT INTO des_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Irisubure Simo waĩcʉgʉ iri maca majagʉ yee árĩpʉ, Eropigʉ yeea erã iirare ii ĩhmumʉripʉ Samaria majarãre. Ĩgʉ eropa ii ĩhmucʉ̃ ero majarã ĩha ʉca wa ĩgʉre gʉhyadiaro mera ĩarã árĩñorã. —Yʉhʉ masipehogʉ ãhraa, arĩpʉ Simopʉ erãre. ");
INSERT INTO des_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ĩgʉ eropa iicʉ̃ ĩarã masapʉ õpa arĩmʉririñorã: —Ihĩ Goãmʉ ya turari opagʉ ãhrimi. Goãmʉ iro dopa turagʉ ãhrimi, arĩmʉririñorã masa erã oparã mera. Erã árĩpehrerã õaro peeñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ĩgʉ yeea erã iiri ĩgʉ purisiriri mera yoari boje ii ĩhmumʉripʉ erãre. Ĩgʉ eropa ii ĩhmucʉ̃ ĩarã erã ʉca wamʉriñorã. Eropirã erã ĩgʉre umupeomʉriñorã. ");
INSERT INTO des_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipepʉ erã ĩgʉre eropa umupeoquerecʉ̃ Goãmʉ ĩgʉ opʉ árĩrire, Jesucristo yare õari buherire werepʉ. Ĩgʉ eropa werecʉ̃ erã ĩgʉre õaro peeñorã. Erã eropa õaro peecʉ̃ ĩagʉ ũma, nome mera waĩyepʉ Felipe. ");
INSERT INTO des_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Eropigʉ Simo ĩgʉ yee sã Felipere õaro peepʉ. Eropigʉ ĩgʉ sãre waĩyepʉ. Ĩgʉ eropa iira pʉhrʉ Felipe mera dujapʉ ĩgʉ. Felipepʉ Goãmʉ turari mera ii ĩhmucʉ̃ ĩagʉ, dorecʉrã õarã ĩgʉ iicʉ̃ ĩagʉ Simo ĩha ʉca wamʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eropirã Samaria majarã Goãmʉ yare erã bʉrigã gamecʉ̃ peebeomʉriñorã Jerusaléngue árĩrã Jesu ĩgʉ apinirãpʉ. Erã eropa peebeorã Pedrore, Ñu sãre obeoñorã Samariague. ");
INSERT INTO des_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Erogue erã ejara pʉhrʉ Pedro sã Goãmʉre serẽbasañorã. “Oã Samaria majarã mʉre umupeorã mʉ Espíritu Santore opaporo,” arĩ, serẽbasañorã erã Goãmʉre. ");
INSERT INTO des_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Erã Samaria majarã Jesucristo waĩ mera waĩyesũnirã árĩñorã. Iri dihtare masiñorã erã. Eropirã Espíritu Santore opabiriniñorã dohpa. ");
INSERT INTO des_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Eropigʉ Pedro Ñu mera Samaria majarãre erã mojotorire erã weca duhpeora pʉhrʉ Espíritu Santore opanʉgañorã erã. ");
INSERT INTO des_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Eropigʉ Pedro sã erã ya mojotori mera erã duhpeora pʉhrʉ Espíritu Santo eracʉ̃ ĩapʉ Simo yeepʉ. Eropa ĩagʉ árĩgʉ, erã turarire gamegʉ niyeru mera wajayediaripʉ. ");
INSERT INTO des_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Õpa arĩripʉ Simo: —Yʉ sãre oque i turarire. Yʉ sã yʉ mojotori mera masa weca duhpeodiaca Espíritu Santore erã ñeaboro dopa. Eropigʉ i yʉ iiburi wajare wajayediaa, arĩripʉ Simo erãre. ");
INSERT INTO des_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ĩgʉ eroparĩcʉ̃ peegʉ Pedro õpa arĩpʉ. —Mʉ niyeru mera Goãmʉ ya turarire mʉ asũdiara waja mʉ niyeru mera ta peamegue waque mʉhʉ. ");
INSERT INTO des_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Goãmʉ mʉ pepirire masimi. Mʉhʉ ñegʉ árĩnia. Eropirgʉ ire gʉa iirire iimasibeaa mʉhʉ. I mʉ iirino árĩbeaa. ");
INSERT INTO des_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Bʉrigã peyocʉa mʉhʉ. Eropigʉ mʉ ñeri iirire ne duhumasibeaa mʉhʉ. Eropigʉ ire mʉhʉ ñero iirare bʉjawereque mʉhʉ. Goãmʉre mʉ ñero pepirire ero diaye ta serẽque mʉhʉ. Mʉhʉ eropa iicʉ̃ ĩagʉ ĩgʉ mʉ ñerire cãdijibocumi, arĩ werepʉ Pedro ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ĩgʉ eroparĩcʉ̃ peegʉ Simo yʉhripʉ ĩgʉre. —Yʉre serẽbasaque mʉa Goãmʉre mʉ arĩdiro dopa yʉ wabiriboro dopa. Iri waja peamegue wadiabeaa yʉhʉ, arĩpʉ Simo ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ero pʉhrʉ Pedro Ñu mera Goãmʉ yare wereñorã. “Jesu ĩgʉ masa mʉriacʉ̃ ĩabʉ gʉa,” arĩ, Samaria yeba árĩri macari majarãre õari buherire buheñorã. Erãre Goãmʉ yare buhetuhaja Jerusaléngue dujaa wañorã. ");
INSERT INTO des_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Eropii Goãmʉ ĩgʉ obeodigʉ anyu Felipere werepʉ: —Dohpaguere õdoca surgue waque. Jerusalén pohro árĩri mague Gazague wari mague waque, arĩ werepʉ anyu Felipere. Iri maha masa marirogue árĩyoro. ");
INSERT INTO des_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ĩgʉ eroparĩcʉ̃ peegʉ ĩgʉpʉ iri mague waha wapʉ. Pʉhrʉ iri mague yujugʉ masʉre bocatĩribu iipʉ. Ĩgʉ bocatĩribu árĩpʉ Etiopía yeba majagʉ opʉ. Eropigʉ Candace waĩcʉgo Etiopía majago opo bʉro yare niyerure árĩpehrerire ĩhadibugʉ árĩpʉ. Eropigʉ ĩgʉ Jerusaléngue mari Pagʉre umupeogʉ ejadi árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ĩgʉ ya macague tũrudiru mera dujaagʉ irirugue waqueregʉ ta buhegʉ iipʉ. Goãmʉ yare weremʉhtadigʉ Isaia ĩgʉ gojarapũre buhegʉ iipʉ. ");
INSERT INTO des_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Eropigʉ Espíritupʉ Felipere õpa arĩ werepʉ. —Sihĩ tũrudirugue wagʉ pohrogue waque, arĩpʉ Espíritu Santo ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ĩgʉ eroparĩcʉ̃ peegʉ, Felipepʉ tũrudiru pohrogue omagã, Isaia ĩgʉ gojarare Etiopía majagʉ ĩgʉ buhecʉ̃ peepʉ. Eropa peegʉ Felipe serẽpipʉ ĩgʉre. —¿Mʉ buherire masiri mʉhʉ? arĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ĩgʉ eroparĩcʉ̃ peegʉ Etiopía majagʉ õpa arĩ yʉhripʉ: —Gajigʉ yʉre weretaugʉ maricʉ̃ õaro masibeaa yʉhʉ. Ohõ yʉre weredoagʉ arique yʉhʉ dipaba, arĩ yʉhripʉ ĩgʉ Felipere. —Áʉ, arĩ, doajapʉ ĩgʉ pohro. ");
INSERT INTO des_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Eropii Goãmʉ yare Etiopía majagʉ ĩgʉ buheripũ õpa árĩyoro: Ovejare erã ñeha wejẽdiro dopa ta ĩgʉ sãre ñeha wejẽrãcoma masa. Eropigʉ ovejagãre ĩgʉ poare erã seacʉ̃ ĩgʉ gaguiniguibiro dopa ta ĩgʉ masʉ sã ejari mariro árĩgʉcumi. ");
INSERT INTO des_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ĩgʉre erã wereyarãcoma. Eropirã ĩgʉ ĩgʉ ñero iibiriquerecʉ̃ ta erãpʉ ñero iirãcoma ĩgʉre. Ĩgʉ i yebague ĩgʉ árĩcʉ̃ erã ĩgʉre wejẽrãcoma. Eropigʉ ĩgʉ porã marigʉ sĩria wagʉcumi, arĩ gojara árĩyoro. ");
INSERT INTO des_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Iripũ eroparĩcʉ̃ ĩagʉ, Etiopía majagʉ Felipere serẽpipʉ: —Wereque yʉre. ¿Õpa Isaia ĩgʉ arĩgʉ nihino árĩcuri ihĩ? ¿Isaia ĩgʉ basi weregʉ iicuri? ¿O gajigʉre weregʉ iicuri? arĩ serẽpipʉ Etiopía majagʉ. ");
INSERT INTO des_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ĩgʉ eropa serẽpi ĩacʉ̃ peegʉ Felipe iripũre ĩha, Jesu yare werepʉ Etiopía majagʉre. ");
INSERT INTO des_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eropirã erã iriru mera waha, maʉgãgue ejañorã. —Ĩaque. Ohõ maʉgã ãhraa. I maʉgãgue yʉre waĩyeque, arĩpʉ Etiopía majagʉ. ");
INSERT INTO des_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Jesure mʉhʉ õaro umupeocʉ̃ ĩagʉ mʉre waĩyegʉra, arĩpʉ Felipe ĩgʉre. —Jesure umupeoa yʉhʉ. Ĩgʉ Cristo Goãmʉ magʉ ãhrimi. Irire õaro masia yʉhʉ, arĩpʉ Etiopía majagʉ. ");
INSERT INTO des_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Eropa arĩgʉ ta ĩgʉ tũrudiru autugʉre yaudorepʉ. Iriru yʉsʉmerejara pʉhrʉ wiriañorã erã. Wiria waha, iriyagãgue eja, ñumu wiri nʉgajañorã. Ero ñumunʉgaja, Felipepʉ ĩgʉre waĩyepʉ. ");
INSERT INTO des_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Waĩyetuhaja erã majajanʉgajacʉ̃ Goãmʉ ĩgʉ Espíritu Felipere aĩgã wapʉ. Ĩgʉ eropa wara pʉhrʉ Etiopía majagʉ õaro mucubirigʉ ĩgʉ ya yebague dujaa wapʉ. Ĩgʉ eropa iira ʉjʉtʉyacʉ̃ ne dipaturi Felipere ĩabiripʉ. ");
INSERT INTO des_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipepʉ eropa iituhaja Azotogue ejapʉ. Eropigʉ baja macarire õari buherire buhepʉ masare. Pʉ Cesareague buhetumʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Irisubure Saulo Jesu yarãre ĩhaturigʉ, “Erãre wejẽgʉra,” arĩgʉ, ĩgʉ opʉ pohrogue wapʉ. ");
INSERT INTO des_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Erogue ejagʉ ĩgʉ gojarapũrire serẽpʉ pahia opʉre. Õpa arĩpʉ: —Damasco maca maja wirigue mari buheri wirigue Jesu yarãre, ʉmare, nomere yʉhʉ erãre bocaja, ñeha dihri, Jerusaléngue aĩgãrigʉra. Iri wirigue árĩrãre yʉ erãre ñeaburipũre paperapũre yʉre goja oque, arĩ serẽpʉ pahia opʉre. ");
INSERT INTO des_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iripũre aĩtuhaja, waha, ĩgʉ Damasco pohro ĩgʉ ejabu iicʉ̃ gohra ʉmaro maja gosesiri medijuyoro ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Eropa gosesiri medijucʉ̃ ta ĩgʉ yebague mehmerejagʉ, wereniguicʉ̃ peepʉ. —Saulo, Saulo, ¿duhpigʉ mʉhʉ yʉre ñero iiri? arĩro cariyoro. ");
INSERT INTO des_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—Opʉ, ¿nihino ãhriri mʉhʉ? arĩpʉ Saulo. —Yʉhʉ mʉ ñero iigʉ ta ãhraa arĩpʉ Jesu. Mʉhʉ yʉ mera guagʉ yʉre yʉhribigʉ, mʉ basi ta ñero tariaa, arĩpʉ Jesu Saulore. ");
INSERT INTO des_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ĩgʉ eroparĩcʉ̃ Saulo güiri mera naragãnijagʉ õpa serẽpipʉ: —Opʉ, ¿dohpa yʉhʉ iicʉ̃ gahmeri mʉhʉ? arĩpʉ Saulo. Ĩgʉ eroparĩcʉ̃ õpa arĩpʉ Jesu ĩgʉre: —Wahgãnʉgajaque mʉhʉ. Macague waque. Iri macague ejacʉ̃ ero majagʉ mʉ iiburire weregʉcumi mʉre, arĩpʉ Jesu Saulore. ");
INSERT INTO des_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ĩgʉ eroparĩcʉ̃ Saulo mera majarãpʉ ĩgʉ wereniguiri dihtare peeñorã. Jesupʉre ĩabiriñorã. Ĩgʉ eropa wacʉ̃ ĩarã güirã erã wereniguimasibiriñorã. ");
INSERT INTO des_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Eropigʉ Saulo yebague oyadigʉ wahgãnʉgaja, ĩgʉ ĩacʉ̃ ĩgʉ cuiri deyobiriyoro. Eropirã erã ĩgʉ mojotore ñeha, Damascogue tʉã wahgã wañorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Eropigʉ ĩgʉ ʉhrenʉ gohra ne ĩabiri, babiri, ne ihribiripʉ. ");
INSERT INTO des_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Eropii Jesu ĩgʉ buhegʉ Ananía waĩcʉgʉ Damasco árĩpʉ. Eropigʉ Jesu dehyoapʉ Ananíare. Eropa dehyoagʉ piyupʉ ĩgʉre: —Ananía, ¿ãhriri? arĩpʉ Jesu ĩgʉre. —Ãhraa yʉ, arĩ yʉhripʉ Ananía ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ĩgʉ eroparĩcʉ̃ Jesu ĩgʉre werepʉ. —Diaye waĩcʉri mague waque. Eropa wagʉ Juda ya wihigue Tarso majagʉre Saulo waĩcʉgʉre amaque. Ĩgʉ Goãmʉre serẽniguigʉ iicumi. ");
INSERT INTO des_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Eropigʉ quẽro dopa ta ĩgʉ ĩarare ĩagʉ iicumi eroguere. Õpa árĩrire ĩagʉ iicumi. Mʉhʉ mʉ mojotore ĩgʉ weca duhpeo, ĩgʉ cuiri õaro wacʉ̃ ĩagʉ iicumi ĩgʉre dehyoarare, arĩpʉ Jesu Ananíare. ");
INSERT INTO des_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ĩgʉ eroparĩcʉ̃ peegʉ Ananíapʉ õpa arĩpʉ: —Opʉ, ĩgʉ mʉ yarãre õarãre Jerusalén majarãre ñero iiapʉ. Bajarã masa yʉre eropa arĩ wereama. ");
INSERT INTO des_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Eropigʉ õre ĩgʉ árĩpehrerã mʉre umupeorãre peresu iigʉ arigʉ iiapʉ. Pahia oparã ĩgʉre eropa iidoreañorã, arĩpʉ Ananía Jesure. ");
INSERT INTO des_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ĩgʉ eropa arĩquerecʉ̃ Jesupʉ werepʉ ĩgʉre. —Ĩgʉ Saulopʉ yʉ beyedigʉ ãhrimi. Ĩgʉ yaha buherire baja macari majarãre, oparãre, Israe masa sãre buhegʉcumi. ");
INSERT INTO des_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eropigʉ bajasuburi yahare ĩgʉ buheri waja ĩgʉ ñero tarigʉcumi. Irire ĩgʉre masicʉ̃ iigʉra. Eropigʉ waque mʉhʉ, arĩpʉ Jesu Ananíare. ");
INSERT INTO des_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ĩgʉ eropa arĩra pʉhrʉ Ananíapʉ, waha eja, Saulo ĩgʉ árĩri wihigue ñaja wapʉ. Ñajaja, ĩgʉ mojotore Saulo weca duhpeo, werepʉ ĩgʉre: —Acaweregʉ Saulo, mari Opʉ Jesupʉ mague mʉre dehyoadigʉ yʉre obeoami mʉ cuiri mʉ ĩaboro dopa. Espíritu Santore mʉ opaboro dopa, ĩgʉ dorediro dopa mʉ iiboro dopa yʉre obeoami mʉ pohrogue, arĩ werepʉ Ananía Saulore. ");
INSERT INTO des_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ĩgʉ eroparĩcʉ̃ ta ĩgʉ cuirire wai nʉtʉri dopa bejarire ĩgʉ cuirire cohrodijacʉ̃ ĩapʉ pare Saulo. Ĩgʉ eropa ĩatuhara pʉhrʉ ĩgʉ wahgãnʉgajacʉ̃ gajigʉpʉ waĩyepʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Eropigʉ ĩgʉ, ĩgʉ bara pʉhrʉ turagʉ wapʉ. Eropii bajamenʉri Damascogue Jesu yarã mera árĩmʉripʉ Saulo. ");
INSERT INTO des_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Eropigʉ irisubure ta ĩgʉ judio masa buheri wiri árĩgʉ, Jesu yare buhepʉ masare. “Jesu Goãmʉ magʉ ta ãhrimi,” arĩ werepʉ Saulo. ");
INSERT INTO des_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ĩgʉ eropa werecʉ̃ ĩarã árĩpehrerã ĩgʉre peerã ʉca wañorã. —Ihĩ Goãmʉ yarãre Jesure umupeorãre ñero iidigʉ ãhrimi. Eropigʉ ĩgʉ erãre ñeha, dihri, pahia oparãre odiadigʉ árĩrimi. Eropiidiagʉ õguere aridigʉ árĩrimi, arĩñorã masa ĩgʉre peerã. ");
INSERT INTO des_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Erã eroparĩquerecʉ̃ Saulo güiro mariro turaro mera buhenʉgapʉ. Judio masare Damasco majarãre õaro werepʉ. “Ihĩ Jesu diaye ta Cristo marire taubu ãhrimi,” ĩgʉ arĩ werecʉ̃ erãpʉ ĩgʉre “Gʉyagʉ iimi ihĩ,” arĩmasibiriñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Eropirã bajanʉri pʉhrʉ judio masa ĩgʉre wejẽdiañorã. Eropirã erã basi gamenere ĩgʉre erã wejẽburire wereniguiñorã. ");
INSERT INTO des_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Eropirã ĩgʉre wejẽdiarã, iri maca maja disipororire ʉmʉre ñami sãre coremʉriñorã. Saulo wiricʉ̃ ĩha wejẽmorã coreñorã. Erã eropa wejẽdiaquerecʉ̃ Saulo erã wejẽdiarire masipʉ ĩgʉ mera majarã mera. ");
INSERT INTO des_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Eropirã ñamigue Saulo buherã ĩgʉre puibu wʉari puibu mera aĩsã, iri maca maja sãriro pʉrʉpʉgue duhudijucãñorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Eropigʉ Saulo Jerusaléngue ejagʉ, erogue Jesu yarã mera ĩgʉ árĩdiaripʉ. Ĩgʉ eropa árĩdiacʉ̃ erã ĩgʉre “Jesure umupeogʉ árĩbeami ihĩ,” arĩñorã. Ĩgʉre güi árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Erã eropa güiquerecʉ̃ ta Bernabépʉ ĩgʉre aĩgãpʉ Jesu ĩgʉ apinirã pohrogue. Eropigʉ Saulo mague Jesure ĩgʉ ĩarare, Jesu mera ĩgʉ wereniguirare, Damascogue güiro mariro Jesu yare ĩgʉ buhenʉgarare werepʉ Bernabépʉ. ");
INSERT INTO des_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ĩgʉ eropa werera pʉhrʉ Saulo erã mera ñajagʉ, Jerusaléngue erã mera árĩmʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Eropigʉ ĩgʉ güiro mariro Jesu yare buhepʉ. Eropigʉ ĩgʉ judio masare Jesu yare weretarinʉgagʉ iipʉ. Erã judio masa griego masa ya wereniguirã árĩñorã. Eropirã Saulo ĩgʉ eropa weretarinʉgari waja ĩgʉre wejẽdiañorã. ");
INSERT INTO des_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Erã eropa wejẽdiacʉ̃ ĩarã, Saulo mera majarã Jesu yarãpʉ ĩgʉre Cesareague aĩduhrigã waha wañorã. Erogue ĩgʉre sihu árĩniguiri Tarsogue obeoñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Eropi árĩpehrerogue Judea yebague, Galilea yebague, Samaria yebague Goãmʉ yarã õaro árĩmʉriñorã. Irisubure ne masa ñero iibirimʉriñorã erãre. Eropirã õaro buheñorã erã. Eropirã erã Goãmʉre gʉhyadiaro ĩañorã. Espíritu Santo erãre ĩgʉ itamucʉ̃ erãpʉ Jesure umupeorã bajarã wañorã. ");
INSERT INTO des_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Eropii Pedro árĩpehreri macarigue wagʉ, Jesu yarã Lida majarã pohrogue sãre ejapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Erogue ejagʉ Enea waĩcʉgʉre bocajapʉ. Enea dʉpʉ bʉhadigʉ árĩgʉ, ocho bojori gohra erã pũtãpidi oyamʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Eropigʉ Pedropʉ ĩgʉre õpa arĩpʉ: —Enea, Jesucristo õagʉ árĩcʉ̃ iimi mʉre. Wahgãnʉgajaque. Mʉre pũtãpira gasirore amuque, arĩpʉ Pedro ĩgʉre. Ĩgʉ eroparĩcʉ̃ ta ĩgʉ wahgãnʉgaja waha wapʉ. ");
INSERT INTO des_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Eropirã árĩpehrerã Lida majarã, Sarón majarã ĩgʉre ĩarã, erã erã ñeri iirare duhu, Jesure umupeonʉgañorã. ");
INSERT INTO des_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Eropii Jope waĩcʉri macague Jesure umupeogo Tabita waĩcʉgo árĩpo. Igo waĩ Tabita griego ya wereniguiri mera Dorca ãhraa. Igo õarire iigo baja omʉripo masare. ");
INSERT INTO des_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Eropigo irisubure igo dorecʉ wahgũ, sĩria wamʉripo. Igo sĩricʉ̃ ĩarã, erã igo dʉpʉ mʉrarore õaro coe, ʉmaro maja taribugue apiñorã igore. ");
INSERT INTO des_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida waĩcʉri maca Jope pohrogue árĩyoro. Ero eropa árĩcʉ̃ Jesure umupeorã Jope maca majarã Pedro Lidague ĩgʉ árĩcʉ̃ peebeoñorã. Eropa peebeorã perã ʉmare obeoñorã Pedro pohrogue. Ĩgʉ pohrogue ejarã wereñorã Pedrore erã. —Yojaro mera waque gʉa árĩrogue, arĩ wereñorã erã. ");
INSERT INTO des_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Erã eroparĩcʉ̃ peegʉ erã mera waha wapʉ ĩgʉ. Erogue ĩgʉre erã aĩ ejara pʉhrʉ ʉmaro maja taribugue sĩridigo pohro aĩmʉria wañorã ĩgʉre. Pedro árĩcʉ̃ ĩha árĩpehrerã wapeweyarã nome orerã ĩgʉ pohro ejanʉgamʉriñorã. Tabita erã mera árĩnigogue baja suhrire iibasamʉripo. Eropirã erã igo eabasara suhri mʉrare ĩhmuñorã Pedrore. ");
INSERT INTO des_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro erãre iri taribugue árĩrãre wiriadorepʉ. Erã wiriara pʉhrʉ ĩgʉ mereja, Goãmʉre igore serẽbasapʉ. Eropigʉ igo dʉpʉ mʉrarore maji ĩha, —Tabita, wahgãque, arĩpʉ ĩgʉ. Ĩgʉ eroparĩcʉ̃ ta igopʉ ĩha wahgũ, Pedrore ĩha, wahgã doajapo. ");
INSERT INTO des_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Igo eropa wahgã doajacʉ̃ ĩha, ĩgʉ igo mojotore ñeha tarawahgũ nugupʉ igore. Eropigʉ ĩgʉ ero majarãre Jesu yarãre, wapeweyarãre sihubeo, igore ojocarigore wiapʉ erãre. ");
INSERT INTO des_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ĩgʉ eropa iira pʉhrʉ árĩpehrerã Jope majarã irire masirã bajarã masa Jesure umupeonʉgañorã. ");
INSERT INTO des_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pʉhrʉ Jopegue Simo waimʉrã gasirire amugʉ mera bajanʉri Pedro ĩgʉ mera árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Irisubure Cesareague Cornelio waĩcʉgʉ árĩgʉ. Ĩgʉ cien surara opʉ árĩpʉ. Erã surarapʉ erã ya curu Italiano waĩcʉyo ro. ");
INSERT INTO des_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio ĩgʉ ya wihi majarã mera mari Pagʉre umupeorã, gʉhyadiaro ĩarã árĩñorã. Eropigʉ ĩgʉ judio masa mojomorocʉrãre itamugʉ baja gajinore omʉripʉ. Eropigʉ ĩgʉ ʉmʉri nʉcʉ mari Pagʉre serẽmʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Eropii ñamicague tres árĩcʉ̃gue Goãmʉ yagʉ anyu ĩgʉre dehyoapʉ. Eropa dehyoagʉ Cornelio pohrogue ñajajapʉ. —Cornelio, arĩ piyupʉ anyu ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Eropigʉ Cornelio ĩgʉre ĩha güigʉ õpa arĩpʉ: —Opʉ, ¿ñehenore gahmeri? arĩpʉ ĩgʉ. —Masare mʉ orare, mari Pagʉre mʉ serẽniguirare Goãmʉ peeami. ");
INSERT INTO des_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Eropigʉ Jopegue mʉ ʉmare obeoque. Erogue Simo Pedro waĩcʉgʉ ãhrimi. Ĩgʉre aĩgãridoreque mʉ ʉmare. ");
INSERT INTO des_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ĩgʉ gajigʉ Simo waimʉrã gasiri amugʉ pohro, wʉariya tʉro árĩri wihi ta ãhrimi, arĩpʉ anyu Corneliore. ");
INSERT INTO des_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anyu eropa arĩtuhaja, wiria waha wapʉ. Ĩgʉ wiriara pʉhrʉ Cornelio perãre ĩgʉre itamurãre yujugʉ ĩgʉ surara mera majagʉre sihupʉ. Surarapʉ Goãmʉre umupeogʉ árĩgʉ, ʉmʉri nʉcʉ Corneliore itamudigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Eropigʉ Cornelio erãre werepeho, Jopegue obeopʉ erãre. ");
INSERT INTO des_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Eropi gajinʉ Jopegue erã warisubu goeri boje gohra árĩcʉ̃ Pedropʉ wihi wecague Goãmʉre serẽgʉ wapʉ. ");
INSERT INTO des_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Eropigʉ ĩgʉre oa pũricʉ̃ badiapʉ. Eropigʉ gajirã barire erã moarisubu ĩgʉpʉ dehyoacʉ̃ ĩapʉ. ");
INSERT INTO des_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ʉmarore pãrimaacʉ̃, wʉari gasiro wapicʉrisubu pepʉri ojogorori dirira gasiro dijaricʉ̃ ĩapʉ. ");
INSERT INTO des_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Iri gasiro pohecague bajarã waimʉrã nʉgʉ majarã, yebague paha curirã, mirimagʉ porã majarã árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Irire ĩgʉ ĩara pʉhrʉ, Pedrore wereniguiro caricʉ̃ peepʉ. —Pedro, wahgãnʉgajaque. Oãre wejẽ baque, arĩro cariyoro ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ĩgʉ eroparĩcʉ̃ peequeregʉ ta Pedro õpa arĩpʉ: —Opʉ, ne erãre babeaa yʉhʉ. Ñerãre, Goãmʉ ĩgʉ badorebirinirãre ne babirimʉrabʉ yʉhʉ, arĩpʉ Pedro. ");
INSERT INTO des_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Eropigʉ Pedro dipaturi wereniguiro caricʉ̃ peepʉ. —Goãmʉ, “Õarã ãhrima,” ĩgʉ arĩnirãre “Ñerã ãhrima,” arĩbiricãque mʉhʉ erãre, arĩro cariyoro Pedrore. ");
INSERT INTO des_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eropii ʉhresubu eropa arĩ wereniguira pʉhrʉ iri gasiro ʉmarogue mʉria wayoro daja. ");
INSERT INTO des_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Eropigʉ Pedro bʉrigã guña “¿Dohpa arĩdiari iiri yʉre eropa dehyoaro?” arĩ pepipʉ ĩgʉ ĩgʉ basi. Ĩgʉ eropa pepirisubu Cornelio ʉma ĩgʉ obeonirãpʉ Pedro ya wihigue ejañorã. “¿Simo ya wihi nohogue ãhriri?” arĩ, erã serẽpira pʉhrʉ ĩgʉ ya wihigue ejañorã erã. ");
INSERT INTO des_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Eropirã erã serẽ ĩha purumujuñorã. “¿Simo Pedro waĩcʉgʉ i wihire ãhriri?” arĩ serẽpi ĩañorã erã. ");
INSERT INTO des_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Eropigʉ Pedro ĩgʉ pepirisubu Espíritu Santo ĩgʉre werepʉ: —Ĩaque. Ʉrerã ʉma mʉre amarã iima. ");
INSERT INTO des_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wahgãnʉgajaque. Dijaque. Erã mera waque. “¿Dohparĩri?” arĩ pepibigʉ ta waque õaro mera. Yʉpʉ erãre õguere obeoabʉ, arĩpʉ Espíritu Santo Pedrore. ");
INSERT INTO des_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ĩgʉ eroparĩcʉ̃ peegʉ Pedro erã pohrogue dija wa, —Ĩaque. Ohõ ãhraa yʉhʉ mʉa amagãrigʉ. ¿Duhpirã arirã iiari mʉa yʉ pohro arirã? arĩpʉ Pedro erãre. ");
INSERT INTO des_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ĩgʉ eroparĩcʉ̃ ta erãpʉ õpa arĩñorã. —Cornelio cien surara opʉ, õarire iigʉ, mari Pagʉre gʉhyadiaro mera umupeogʉ, árĩpehrerã judio masa “Õagʉ” erã arĩgʉ mʉre sihugãridoregʉ obeoami gʉare. Goãmʉ õagʉ anyu Corneliore mʉre sihudoreapʉ. Õpa arãpʉ: “Pedrore mʉa ya wihigue aĩgãridoreque mʉ ʉmare. Eropii ĩgʉ mʉre weregʉcumi,” arĩ, sihudoreapʉ anyu Corneliore, arĩ wereñorã Cornelio Pedrore ĩgʉ sihudorenirãpʉ. ");
INSERT INTO des_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Erã eroparĩcʉ̃ Pedropʉ erãre ñajaridore, bari oho, ĩgʉ ya wihigue carĩdorepʉ erãre. Eropigʉ gajinʉ Pedro wahgã, erã mera waha wapʉ. Eropirã gajirã Cristo yarã Jope majarã Pedrore wapicʉgãñorã. ");
INSERT INTO des_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Gajinʉ erã Cesareague ejañorã. Eropigʉ Corneliopʉ ĩgʉ acawererãre, ĩgʉ mera majarã sãre sihu gameneo, Pedrore corepʉ. ");
INSERT INTO des_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Eropigʉ Pedro Cornelio ya wihi pohrogue ĩgʉ aricʉ̃ ĩagʉ Corneliopʉ ĩgʉre bocatĩri wiria, ĩgʉ guburi pohro merejapʉ. ");
INSERT INTO des_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ĩgʉ eropa iicʉ̃ Pedropʉ ĩgʉre aĩ wahgũnugupʉ. —Niguique mʉhʉ. Yʉ sã mʉ iro dopa ta árĩgʉ ãhraa. Goãmʉ árĩbeaa, arĩpʉ Pedro ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ĩgʉ eropa arĩtuhajara pʉhrʉ Cornelio ĩgʉre aĩñaja wapʉ ĩgʉ ya wihigue. Erogue ñajajagʉ masa bajarã iri wihigue gamenere ĩgʉre corerãre ĩapʉ Pedro. ");
INSERT INTO des_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Eropigʉ Pedro erãre werepʉ: —Judio masʉ árĩqueregʉ ta gaji curu majarã mera árĩgʉ gʉa dorerire tarinʉgagʉ iiaa yʉhʉ. Irire õaro masia mʉa. Eropigʉ gaji curu majarãre “Ñerã ãhrima,” arĩdorebirami Goãmʉ. Õpa arĩ wereami ĩgʉ yʉre. ");
INSERT INTO des_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ĩgʉ eroparĩcʉ̃ peegʉ õguere mʉa pohroguere ahrabʉ. Mʉa yʉre sihubeocʉ̃ “Ne wasome,” arĩbirabʉ. ¿Dohpa árĩronore yʉhʉ õgue aricʉ̃ gahmeari mʉa? arĩpʉ Pedro erãre. ");
INSERT INTO des_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ĩgʉ eroparĩcʉ̃ peegʉ Corneliopʉ õpa arĩpʉ: —Tres árĩcʉ̃ i horano gohra ta mari Pagʉ yagʉ anyu yʉre dehyoami. Wapicʉrinʉ wahaa ĩgʉ yʉre dehyoara pʉhrʉ. Irinʉ ta mari Pagʉre yʉ serẽniguirisubu cuimijuri suhricʉgʉ yʉ pohro dehyonʉgajami. ");
INSERT INTO des_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Eropigʉ ĩgʉ yʉre õpa arãmi: “Cornelio, mʉhʉ mari Pagʉ mera mʉ serẽcʉ̃ ĩgʉ peeami. Eropigʉ mojomorocʉrãre erã gamerire mʉ ocʉ̃ ĩagʉ mari Pagʉ mʉ mera mucubirigʉ itamugʉcumi. ");
INSERT INTO des_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Eropigʉ Jopegue mʉ ʉmare obeoque Simo Pedro waĩcʉgʉre mʉ pohrogue erã aĩgãricʉ̃. Ĩgʉ gajigʉ Simo waimʉrã gasiri amugʉ ya wihi, wʉariya tʉro pohro árĩri wihi ãhrimi ĩgʉ. Ĩgʉ mʉ pohro eragʉ mʉre weregʉcumi,” arĩ wereami ĩgʉ yʉre. ");
INSERT INTO des_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ĩgʉ eroparĩcʉ̃ peegʉ yʉ ʉmare mʉre aĩgãridoregʉ obeoabʉ yʉhʉ. Eropigʉ õaro iigʉ ahraya mʉhʉ gʉa pohroguere. Eropirã gʉa árĩpehrerã õre mari Pagʉ ĩgʉ ĩhabeoro árĩrã iiaa gʉa. Árĩpehrerire mari Pagʉ Goãmʉ mʉre ĩgʉ weredorera peediarã, cohreabʉ gʉa, arĩpʉ Cornelio Pedrore. ");
INSERT INTO des_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ĩgʉ eroparĩcʉ̃ peegʉ, Pedro õpa arĩ werepʉ: —Dohpague masia pare. Diaye ta ãhraa. Goãmʉ yujuropa ta õaro iimi marire. ");
INSERT INTO des_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Eropigʉ árĩpehreri macari majarã Goãmʉre gʉhyadiaro erã ĩacʉ̃, õarire erã iicʉ̃, Goãmʉpʉ erãre mucubirimi. ");
INSERT INTO des_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Goãmʉ gʉa judio masa pohro Jesucristore obeomi. Masa Goãmʉ mera õaro erã árĩboro dopa Jesupʉ õari buherire weremi. Iri buherire mʉa masia. Jesucristopʉ árĩpehrerã masa opʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ñu waĩyegʉ “Mʉa ñerire bʉjawereque. Eropirã waĩyenirã árĩque,” masare ĩgʉ eropa arĩ werera pʉhrʉ Galileague õari buherire Jesupʉ werenʉgami. Pʉhrʉ Judea yebague iri buherire werepehomi. ");
INSERT INTO des_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ihĩ Jesu Nazare majagʉre Goãmʉpʉ ĩgʉ turarire, Espíritu Santo mera ĩgʉ iimasiburire odi árĩmi Jesure. Eropigʉ Jesu õaro iigʉ wami. Eropa wagʉ watẽa ñajasũnirãre, ñero tarirãre, árĩpehrerãre õarã wacʉ̃ iimi. Mari Pagʉ Jesu mera árĩdi árĩmi. ");
INSERT INTO des_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Judea yeba, Jerusalén sãre árĩpehreri ĩgʉ iirare gʉa ĩabʉ. Pʉhrʉ erã crusague pabia wejẽma ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Eropigʉ ʉhrenʉ waboro Goãmʉ ĩgʉre masudi árĩmi. Eropigʉ Jesure ĩgʉ masura pʉhrʉ gajirãre dehyoacʉ̃ iidigʉ árĩmi mari Pagʉ. ");
INSERT INTO des_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Irisubu Jesure árĩpehrerã ĩabirima. Gʉare bajamerãgãre dehyoami. Mari Pagʉ ĩgʉ gamerãre, Jesure ĩamorãre iribojegue Goãmʉ gʉare beyepʉ. Gʉapʉ Jesu ĩgʉ sĩridi masara pʉhrʉ ĩgʉ mera baha, ihribʉ. ");
INSERT INTO des_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Eropigʉ ĩgʉ gʉare doremi õpa arĩgʉ: “Masare wereque. Yʉhʉ Jesu árĩpehrerã ojocarirãre, sĩrinirãre erãre dipuwaja moabu yʉ árĩcʉ̃ iiami yʉre Goãmʉ. Eropirã irire wereque,” arĩ doremi Jesu gʉare. ");
INSERT INTO des_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Árĩpehrerã Jesure erã umupeocʉ̃ ĩagʉ Goãmʉ erã ñerire cãdijigʉcumi. Irire árĩpehrerã Goãmʉ ya weremʉhtanirã iribojegue majarã wereyuñuma, arĩ werepʉ Pedro. ");
INSERT INTO des_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Iri árĩpehrerire ĩgʉ eropa arĩ wererisubu, árĩpehrerã irire peerã mera Espíritu Santo árĩnʉgamʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Eropirã erã judio masa árĩbirã peeyamariri wereniguiri mera mucubiriri mera wereniguinʉgañorã. Erã ya wereniguiri mera “Goãmʉ turagʉ, õagʉ ãhrimi”, arĩrã iiñorã. Erã eroparĩcʉ̃ peepʉ Pedro ĩgʉ acawererã judio masa mera. Eropirã Espíritu Santo judio masa árĩbirã mera ĩgʉ árĩnʉgacʉ̃ ĩarã judio masapʉ ʉca wañorã. Eropigʉ Pedro õpa arĩ werepʉ judio masare: ");
INSERT INTO des_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Mari iro dopa ta Espíritu Santore opama oã sã. Erã eropa opacʉ̃ ĩarã oãre waĩyedoremasia mari, arĩpʉ Pedro erãre. ");
INSERT INTO des_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Eropa arĩtuhaja Jesu waĩ mera judio masa árĩbirãre waĩyedorepʉ Pedro. Erã eropiira pʉhrʉ “Gʉa mera bajamenʉrigã dujanique,” arĩñorã erã Pedro sãre. ");
INSERT INTO des_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Eropii judio masa árĩbirã sã Goãmʉ yare erã õaro gamecʉ̃ Jesu ĩgʉ apinirãpʉ erã acawererã Judeague árĩrã mera peebeoñorã. ");
INSERT INTO des_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Eropirã Pedro Jerusaléngue ĩgʉ dujajacʉ̃ ĩarã judio masa Jesu yarã bajamerãgã ĩgʉre õpa arĩñorã: ");
INSERT INTO des_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—¿Judio masa árĩbirã pohro duhpigʉ ejari mʉhʉ? ¿Dohpa árĩronore erã mera bahari mʉhʉ? arĩ turiñorã erã Pedrore. ");
INSERT INTO des_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Erã eroparĩcʉ̃ peegʉ Pedro ĩgʉ iirare werepehopʉ erãre. ");
INSERT INTO des_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Õpa arĩ werepʉ: —Yʉhʉ Jopegue árĩgʉ Goãmʉre serẽgʉ iibʉ. Eropigʉ yʉre õpa dehyoabʉ. Yʉhʉ ĩacʉ̃ wʉari gasiro wapicʉrisubu pepʉri dirira gasiro ʉmarogue yʉ pohrogue dijaricʉ̃ ĩabʉ. ");
INSERT INTO des_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Eropigʉ iri gasirore õaro ĩabʉ “¿Ñeheno iri gasiroguere ãhriri?” arĩbʉ. Eropigʉ ĩabʉ iri gasiroguere árĩrãre. Waimʉrã nʉgʉ majarãre, yebague paha curirãre, mirimagʉ porã majarãre ĩabʉ. ");
INSERT INTO des_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Eropigʉ Goãmʉ ĩgʉ yʉre wereniguirire peebʉ. “Pedro, wahgãnʉgaque. Wejẽ baque oãre,” arĩgʉ carimi yʉre. ");
INSERT INTO des_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ĩgʉ eroparĩcʉ̃ peegʉ õpa arĩbʉ yʉhʉ. “Opʉ, ne erãre babeaa yʉhʉ. Ñerãre Goãmʉ badorebirinirãre ne babirimʉrabʉ yʉhʉ,” arĩbʉ yʉpʉ. ");
INSERT INTO des_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Eropigʉ ʉmarogue yʉre dipaturi wereniguigʉ carimi daja. “Goãmʉ ĩgʉ ‘Õarã ãhrima,’ ĩgʉ arĩrãre ‘Ñerã ãhrima,’ arĩbiricãque mʉhʉ,” arĩgʉ carimi yʉre. ");
INSERT INTO des_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Eropigʉ ʉhresubu ĩgʉ eropa arĩ wereniguira pʉhrʉ iri gasiro dipaturi mʉria wabʉ daja. ");
INSERT INTO des_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Yʉ eropa ĩarisubu ta ʉrerã ʉma gʉa árĩri wihigue ejanirã árĩma. Erã Cesarea majagʉ ĩgʉ obeonirã árĩnirã árĩma. ");
INSERT INTO des_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Eropigʉ Espíritu Santopʉ yʉre erã mera wadoregʉ “‘Erã ñerã ãhrima,’ arĩbiricãque erãre,” arĩ weremi ĩgʉ yʉre. Eropirã oã seis mera yʉ acawererã mera Cesarea majagʉ ya wihigue ñajajabʉ gʉa. ");
INSERT INTO des_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Eropigʉ ĩgʉ gʉare õpa arĩ weremi. “Anyu yaha wihi dehyoacʉ̃ ĩabʉ yʉhʉ. Õpa weremi yʉre. ‘Jopegue Simo waĩcʉgʉre aĩgãridoreque. ");
INSERT INTO des_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ĩgʉ mʉre mʉ acawererã mera mʉare árĩpehrerãre peamegue wabonirãre mʉa tariborore weregʉcumi,’ arĩmi anyu yʉre,” arĩ weremi yʉre Cesarea majagʉ. ");
INSERT INTO des_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Eropii yʉhʉ erãre wereniguirisubu Espíritu Santopʉ erã mera árĩnʉgami marire ĩgʉ iimʉhtadiro dopa ta. ");
INSERT INTO des_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eropigʉ Jesu ĩgʉ wererare guñabʉ yʉhʉ. Õpa arĩ weremi ĩgʉ: “Ñu mʉare waĩyegʉ deco mera waĩyemi. Yʉpʉ iri tauro iigʉra mʉare. Pʉhrʉ Espíritu Santore mʉa mera árĩniguicʉ̃ iigʉra,” arĩ weremi. ");
INSERT INTO des_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Eropigʉ Jesucristo mari Opʉre mari umupeocʉ̃ ĩagʉ Goãmʉ ĩgʉ Espíritu Santore ohámi marire. Eropigʉ Goãmʉ marire ĩgʉ Espíritu Santore ĩgʉ odiro dopa ta judio masa árĩbirã sãre ĩgʉ ohámi. Goãmʉ ĩgʉ eropa iicʉ̃ ĩagʉ ĩgʉre tarinʉgamasibeaa yʉhʉ, arĩpʉ Pedro erãre judio masare Jesu yarãre. ");
INSERT INTO des_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ĩgʉ eroparĩcʉ̃ peerã, erã ĩgʉre ne arĩnemobiriñorã. Ĩgʉre erã turimasibiriñorã. Eropirã erã Goãmʉre mucubirirã, —Goãmʉ õagʉ, turagʉ ãhrimi, arĩñorã. Õpa arĩnemoñorã erã: —Judio masa árĩbirã sã erã ñerire bʉjawererã árĩrã Goãmʉ ĩgʉ taunirã árĩrãcoma. Eropa ĩgʉ taunirã árĩrã erã sã ʉmʉri nʉcʉ ĩgʉ mera árĩniguirãcoma, arĩnemoñorã erã. ");
INSERT INTO des_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Eropii Estebanre erã wejẽra pʉhrʉ masa Jesu yarãre ñero iiñorã. Erã eropa iicʉ̃ ĩarã Jesu yarã duhrisirigã wañorã. Eropirã erã Feniciague, Chipregue, Antioquíague waha, judio masa dihtare Goãmʉ yare wereriñorã erã. ");
INSERT INTO des_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Gajirãpʉ Jesu yarã mera majarã Chipre majarã, Cirene majarã Antioquíague eja, judio masa árĩbirãre Jesu yare buheñorã Goãmʉ erãre ĩgʉ tauboro dopa. ");
INSERT INTO des_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Eropigʉ mari Opʉ erãre itamupʉ. Eropirã masa bajarã Jesure umupeo, õaripʉre gohrotoñorã. ");
INSERT INTO des_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Eropii “Antioquía majarãgue Jesure gamecoma,” arĩ peebeoñorã Jerusalén majarã Jesu yarã. Erã eropa peebeora pʉhrʉ Jerusalén majarã Bernabé waĩcʉgʉre Antioguíague obeoñorã. ");
INSERT INTO des_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Eropigʉ ĩgʉ Antioguíague ejagʉ, Goãmʉ itamuri mera judio masa árĩbirã ĩgʉ yarã erã wacʉ̃ ĩagʉ, bʉrigã mucubiripʉ. Eropigʉ ĩgʉ ero majarãre õpa arĩ werepʉ: —Jesure eropa umupeoniguicãque. Ĩgʉ yare ne duhubiricãque, arĩ werepʉ ĩgʉ árĩpehrerãre erãre. ");
INSERT INTO des_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé õagʉ árĩgʉ, Espíritu Santore wʉaro opagʉ árĩgʉ, Jesu dorediro dopa iigʉ árĩgʉ Jesure õaro umupeodigʉ árĩpʉ. Eropirã ĩgʉ buhera pʉhrʉ bajarã masa Jesure umupeoñorã. ");
INSERT INTO des_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pʉhrʉ ĩgʉ Tarso waĩcʉri macague Saulore amagʉ wapʉ. ");
INSERT INTO des_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Erogue ĩgʉre bocajapʉ. Ĩgʉ bocajara pʉhrʉ Antioquíague aĩgãpʉ Saulore. Erogue erã ejara pʉhrʉ yuju bojori gohra erã Goãmʉ yarã mera gamenere, bajarã masare buhemʉriñorã erã. Eropirã Antioquíague Cristo yarã Cristiano waĩcʉnʉgañorã. ");
INSERT INTO des_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Irisubure Goãmʉ ya weremʉhtarã Jerusalén árĩnirã waha, Antioquíague ejañorã. ");
INSERT INTO des_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Eropigʉ erã mera majagʉ Agabo waĩcʉgʉ Jesu yarã watope niguigʉ, Espíritu Santo ĩgʉ turari mera werepʉ erãre. “Árĩpehreri yebaguere bʉrigã oanʉ waroca,” arĩ wereyupʉ ĩgʉ. Irisubure bari maririsubu árĩcʉ̃ árĩpehrerã weca opʉ Claudio árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Eropirã Jesu yarã árĩpehrerã erã oparopẽ erã acawererãre odiarã erã basi game wereniguiñorã. “Judea yeba majarãre Jesu yarãre niyerure obeorã,” arĩñorã erã basi. ");
INSERT INTO des_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Erã eropa arĩra pʉhrʉ Bernabé Saulo mera erã iri niyerure aĩgãbasañorã. Erogue ejarã Judea majarãre Jesu yarãre wiañorã iri niyerure. ");
INSERT INTO des_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Irisubu opʉ Herode yujurãyerire Jesu yarãre ñero iinʉgapʉ. ");
INSERT INTO des_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Eropigʉ ĩgʉ Ñu tĩgʉre Santiagopʉre matamiji mera ĩgʉ wejẽdorecʉ̃ gajigʉpʉ ĩgʉre wejẽpʉ. Santiagore ĩgʉ wejẽcʉ̃ judio masa mucubiriñorã. ");
INSERT INTO des_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Erã mucubiririre Herode masigʉ, “Eropa dihta iicʉ̃ gahmema erã,” arĩgʉ Pedro sãre peresu iipʉ. Irinʉrire bʉgabiriri pan erã bari bosenʉ Pascua árĩyoro. ");
INSERT INTO des_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Eropigʉ Herode Pedrore ñeha, peresu iipʉ. Eropigʉ diez y seis surarare ĩhadibudorepʉ ĩgʉre. Wapicʉrã surara ĩgʉre ĩhadibuñorã. Pʉhrʉ wapicʉrã erã gohrotonirã ĩgʉre ĩhadibumʉriñorã. Eropa ta iiñorã erã diez y seis surara. Herodepʉ Pascua pʉhrʉ Pedrore peresugue árĩgʉre masa core duhudobodiaripʉ ĩgʉre wejẽdorebu. ");
INSERT INTO des_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Eropigʉ Pedro peresugue árĩpʉ. Ĩgʉ erogue árĩcʉ̃ ta Jesu yarãpʉ Goãmʉre bʉrigã serẽbasañorã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Iri ñamire ta Pedro comedari peda mera erã diridigʉ perã surara watope carĩgʉ iipʉ. Eropirã perã surara disiporo coreniguiñorã ĩgʉre. Eropigʉ iri ñami boyoro Herode Pedrore judio masa core duhudobodiaripʉ ĩgʉre wejẽdorebu. ");
INSERT INTO des_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Eropigʉ Goãmʉ anyupʉ Pedro carĩgʉ pohro ĩgʉ niguicʉ̃ ĩgʉ peresu árĩri taribu boyopehrea wayoro. Eropigʉ anyu Pedro pohro niguigʉ ĩgʉ patorere puucarepʉ ĩgʉre. —Duru wahgãque, arĩpʉ ĩgʉ Pedrore. Ĩgʉ eroparĩcʉ̃ ta ĩgʉ mojotorire erã dirira comedari pãrisiri dija wayoro. ");
INSERT INTO des_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Eropigʉ anyu ĩgʉre werepʉ: —Mʉ ya suhrire sañaque. Mʉ zapatu sãre sañaque, arĩpʉ ĩgʉ. Ĩgʉ eroparĩcʉ̃ Pedropʉ ĩgʉ arĩro dopa ta iipʉ. —Mʉ weca majañe suhrirore saña, yʉ mera arique, arĩpʉ anyu. ");
INSERT INTO des_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ĩgʉ eroparĩcʉ̃ iri taribugue árĩdigʉ wiria anyu pʉhrʉ waha wapʉ ĩgʉ. Eropa waqueregʉ ta õpa arĩ pepiripʉ ĩgʉ. “¿I diaye árĩbiricuri? ¿O quẽgʉ iicuri yʉhʉ?” arĩ pepiripʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Eropirã erã ĩgʉ árĩri taribu pohro niguirã surarare tarigã, gajirã yoañariro niguirã sãre tarigã, wʉari disiporogue ejañorã. Iri disiporo macague wari mare cãhmotayoro. Iri biharise irise basi pãricʉ̃ erã wiriañorã. Wiria wa erã mague waha wañorã. Anyupʉ waha wapʉ. Eropigʉ Pedro yujugʉ ta dujapʉ. ");
INSERT INTO des_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eropa ĩgʉ anyu ĩgʉ wara pʉhrʉ ĩgʉ iirare Pedro masipʉ pare. Õpa arĩ pepipʉ ĩgʉ. “Anyu Goãmʉ ĩgʉ obeodigʉ peresugue árĩgʉre yʉre wiugʉ erami. Dohpague irire masia ĩgʉ eropa iirare. Judio masapʉ yʉre erã ñero iidiarare Goãmʉpʉ erãre iidorebirami. Eropigʉ yʉre Herode ĩgʉ peresu iidigʉre wiuami,” arĩ pepipʉ Pedro. ");
INSERT INTO des_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ĩgʉ eropa arĩ pepira pʉhrʉ María Ñu pago ya wihigue ejapʉ Pedro. Ñupʉ Marco waĩcʉgʉ árĩpʉ. Iri wihigue masa bajarã gamenere, Goãmʉre serẽrã iiñorã. ");
INSERT INTO des_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Eropigʉ Pedro disiporore eraa dotepʉ. Rode waĩcʉgo pohro majago ĩgʉ dotecʉ̃ peego, ĩago ejapo igo. ");
INSERT INTO des_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Eropigo Pedro igore piyucʉ̃ peego ĩgʉ wereniguirire pee masi, bʉrigã mucubiri disiporore pãgũbiripo. Eropa mucubirigo ĩgʉre pãgũbodio cãdija wapo. Pedro ero niguicʉ̃ ta igo majinʉgaja oma ñaja wapo. —Pedro disiporogue erami, arĩ werego ñajapo. ");
INSERT INTO des_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Eropirã iri wihi árĩrã igo eroparĩcʉ̃ peerã, —Eropa arĩmaacãgo iiaa mʉhʉ, arĩñorã erã igore. —Diaye ta ãhraa. Diaye ta arĩgo iiaa, arĩpo igo. Igo eroparĩcʉ̃ peerã, —Ĩgʉ árĩbiricumi. Ĩgʉ sĩporã mʉraro eraro iica, arĩñorã erãpʉ. ");
INSERT INTO des_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Erã eropa arĩrisubu Pedro disiporore eropa ta doteniguicãpʉ. Ĩgʉ eropiicʉ̃ peerã, erã disiporore pãgũ, ĩgʉre ĩha, ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Eropigʉ Pedro ĩgʉ mojoto mera “Ejarimaricãque,” arĩgʉ, Goãmʉ peresugue ĩgʉre ĩgʉ wiurare werepʉ erãre. —Ire wereque Santiagore gajirã Jesu yarã sãre, arĩpʉ Pedro. Eropa arĩ weretuhaja, ĩgʉ gajipʉgue tarigã waha wapʉ. ");
INSERT INTO des_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Eropii boyodijiricʉ̃ surara Pedrore ĩhadibunirã ĩgʉ dohpa ii wiriarare ne masibiriñorã. Eropa masibirã ʉca wañorã. ");
INSERT INTO des_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Eropigʉ Herode Pedrore amadoreripʉ. Eropigʉ ĩgʉ surarare peresu corerãre ĩgʉ serẽpira pʉhrʉ erãre wejẽdorepʉ Herodepʉ. Eropii Herode Judeague árĩdigʉ waha Cesareague árĩgʉ waha wapʉ. ");
INSERT INTO des_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ero pʉhrʉ Tiro waĩcʉri maca majarã mera Sidón waĩcʉri maca majarã mera sãre Herode guapʉ. Ĩgʉ eropa guacʉ̃ ĩarã iri macari majarãpʉ Herode mera amurã wañorã. Ĩgʉ erã mera ĩgʉ guarare wereniguirã wañorã. Ejaa Herodere ĩaboro core Herode itamugʉ Blasto waĩcʉgʉ mera weretamuñorã. Eropirã erã ĩgʉ Blasto ĩgʉ itamuri mera Herode pohro ejañorã. Ĩgʉ pohro ejarã õpa arĩñorã: —Mari õaro árĩrã. Mari basi ĩhaturibiricãrã, arĩ serẽñorã erã Herodere. Erã ya yeba majarã Herode ya yeba barire bocamʉriñorã. Eropirã Herode erãre ĩhaturicʉ̃ gamebiriñorã erã. ");
INSERT INTO des_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Eropigʉ Herode erã ĩgʉre ĩarinʉ ĩgʉ queoranʉ árĩcʉ̃, opʉ ĩgʉ sañari suhri õari suhrire sañamʉripʉ ĩgʉ. Eropigʉ ĩgʉ ĩgʉ doaro doanijagʉ, masare werenigui ĩhmumʉripʉ. ");
INSERT INTO des_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ĩgʉ eropa werenigui ĩhmucʉ̃ peerã masapʉ gaguiniguiñorã: —Ihĩ wereniguigʉ masʉ árĩbeami. Goãmʉ ãhrimi, arĩ gaguiniguimʉririñorã erã Herodere. ");
INSERT INTO des_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Erã eropa arĩra pʉhrʉ Goãmʉ ĩgʉ anyu Herodere dore ópʉ. “Goãmʉ árĩbeaa yʉhʉ,” ne arĩbiripʉ Herode. Ĩgʉ eropa arĩbirira dipuwaja anyu ĩgʉ dorecʉcʉ̃ iipʉ. Ĩgʉ eropa dorecʉcʉ̃ ĩgʉre beca ba wejẽcãñorã. ");
INSERT INTO des_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Eropii Jesu yarã masa bajarãre Jesu ya buherire buheñorã. ");
INSERT INTO des_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Eropirã Bernabé, Saulo mera Jesu yarãre itamupehotuhaja Jerusaléngue árĩnirã Antioquíague dujaa wañorã. Eropirã Ñure Marco waĩcʉgʉre erã aĩgãñorã erã mera. ");
INSERT INTO des_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Irisubure Antioquíague Jesu yarã gamenererã mera majarã, Goãmʉ yare weremʉhtarã árĩñorã. Masare buherã ta árĩñorã erã sã. Bernabé, Simo Negro waĩcʉgʉ, Lucio Cirene majagʉ, Manaén, Saulo mera erã árĩñorã. Manaénpʉ opʉ Herode mʉrʉ mera erã perã yujuro mera ta masanirã árĩñorã. ");
INSERT INTO des_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Eropirã erã Goãmʉ yare erã buherisubu, erã ba duhurisubu, Espíritu Santopʉ werepʉ erãre: —Bernabére, Saulo mera apique yʉ gamero dopa iimorãre. Irire iimorãre beye apigʉ iiaa erãre, arĩpʉ Espíritu Santo. ");
INSERT INTO des_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ĩgʉ eroparĩcʉ̃ erãpʉ ba duhu Goãmʉre serẽ, Bernabé weca Saulo weca erã mojotorire duhpeoñorã. Eropa duhpeorã erãre buhedorerã obeoñorã. ");
INSERT INTO des_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Eropirã erã Espíritu Santo ĩgʉ obeonirã árĩrã, Seleuciague eja, iri macare tarigã, Chipre waĩcʉri nʉgʉrogue ejañorã erã. ");
INSERT INTO des_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Eropirã Salamina waĩcʉri peramague ejañorã. Iri maca judio masa buheri wirigue Goãmʉ yare werenʉgañorã erã. Eropigʉ Ñu Marco sã erã mera waha, erãre itamupʉ. ");
INSERT INTO des_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Eropirã erã iri nʉgʉro ojogoro maja. Pafo waĩcʉri macague ejarã, yeere bocajañorã erã. Ĩgʉ judio masʉ Barjesu waĩcʉgʉ árĩpʉ. Barjesu griego ya mera Elima erã arĩ piyugʉ árĩpʉ. “Goãmʉ yare weremʉhtagʉ ãhraa yʉhʉ,” arĩ masare gʉyaniguicãgʉ árĩpʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Eropigʉ ĩgʉ Sergio Paulo waĩcʉgʉ mera majagʉ árĩpʉ. Sergio Paulopʉ iri nʉgʉro majarã opʉ masipehogʉ árĩpʉ. Eropigʉ Goãmʉ yare peediagʉ erãre Bernabé, Pablo mera bocatĩripʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Eropigʉ Elima yeepʉ erãre buhedorebiriripʉ. Ĩgʉ Sergio Paulo Jesu yare ĩgʉ umupeocʉ̃ gamesãbiripʉ yeepʉ. Sergio Paulore Goãmʉ yare ĩgʉ peecʉ̃ cãhmotadiaripʉ. ");
INSERT INTO des_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Ĩgʉ eropa buhedorebiriquerecʉ̃ ta Saulo, Pablo waĩcʉgʉ Espíritu Santore õaro opagʉ árĩgʉ yeere õaro ĩadihupi ĩgʉre werepʉ: —Mʉhʉ gʉyaricʉgʉ, ñegʉ, watĩ ĩgʉ dorerire iigʉ, õarire ĩhaturigʉ ãhraa mʉhʉ. ¿Duhpigʉ mari Opʉ yare “Ñeri ãhraa. Gʉyari ãhraa,” eropa arĩniguicãri mʉhʉ? ");
INSERT INTO des_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mʉhʉ eroparĩra waja Jesu mari Opʉ mʉre ĩgʉ pẽhrecʉ̃ cuiri ĩhajabigʉ árĩgʉca mʉhʉ. Eropigʉ bajamenʉrigã mʉhʉ inʉrire ĩarisome, arĩpʉ Pablo. Ĩgʉ eroparĩcʉ̃ ta ĩgʉ yeepʉ imica iro dopa árĩrire ĩamʉhtagʉ, naitĩaro dihtare ĩapʉ ĩgʉ. Eropigʉ ĩgʉre tʉã curibure amapʉ ĩgʉ. ");
INSERT INTO des_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ĩgʉ eropa wacʉ̃ ĩagʉ, Sergio Paulopʉ Jesu yare “Diaye ta ãhraa,” arĩ masipʉ. Mari Opʉ yare ĩgʉ pee, ʉca wa, Jesure umupeonʉgapʉ. ");
INSERT INTO des_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Eropi Pablo sã Pafogue árĩnirã dohodiru mera waha, Pergegue ejañorã. Perge Panfilia yebague ãhraa. Erogue eja, Ñu Marcopʉ erãre cohã wahgã, Jerusaléngue waha wapʉ. ");
INSERT INTO des_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Erãpʉ Pergegue árĩnirã waha, Antioquíague ejañorã. Antioquía Pisidia yebague ãhraa. Erogue ejarã, Sabadonʉ árĩcʉ̃ erã judio masa buheri wihigue ñajaja, erogue doañorã. ");
INSERT INTO des_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Eropirã iri wihi majarã oparã Goãmʉ dorerire, Moisegue marire ĩgʉ apirare, Goãmʉ yare weremʉhtanirã erã gojarare erã buhera pʉhrʉ erã sihubeoñorã Pablo sãre. —Acawererã, ¿masare mʉa werediarã iiri? Irire werediarã wereque dohparagã, arĩñorã iri wihi majarã oparã. ");
INSERT INTO des_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Erã eroparĩcʉ̃ peegʉ, Pablo wahgãnʉgaja, “Wereniguibiricãque,” arĩgʉ ĩgʉ mojoto mera paatupʉ. Erã ejarimaricʉ̃ ĩha, ĩgʉ õpa arĩpʉ: —Israe masa, mʉa mari Pagʉre umupeorã, peeque. ");
INSERT INTO des_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mari ñecʉ sʉmarã mʉra Goãmʉre umupeomʉriñuma. Erã mʉrare Goãmʉ beyemʉriñumi. Eropirã erã mari ñecʉ sʉmarã yoari boje Egiptogue árĩmʉriñuma gajirã árĩquererã. Erogue erã árĩcʉ̃ Goãmʉ õaro iimʉriñumi erãre. Eropirã bajarã masa pore árĩñuma erã. Õpa iiñumi erãre. Erãre Egiptogue árĩrãre ĩgʉ turari mera aĩ wiuñumi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ĩgʉ eropa wiura pʉhrʉ erã cuarenta bojori gohra masa marirogue curimʉriñuma. Erogue ĩgʉre erã tarinʉgacʉ̃ Goãmʉ eropa ta pepicãñumi. ");
INSERT INTO des_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Eropigʉ Canaa waĩcʉri yebaguere siete cururi majarãre cóãtuhaja, Goãmʉ iri yebare oñumi Israe masapʉre. ");
INSERT INTO des_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Iri yebare otuhaja cuatrocientos cincuenta bojori gohra masare doremorãre apimʉriñumi Goãmʉ Israe masare. —“Goãmʉ ĩgʉ apinirã Samue ĩgʉ árĩcʉ̃gue árĩtumʉriñuma. Samuepʉ Goãmʉ yare weremʉhtagʉ árĩmʉriñumi. ");
INSERT INTO des_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samue árĩrisubu Israe masapʉ erã opʉ árĩbure amamʉriñuma. Eropirã Goãmʉre serẽmʉriñuma. Erã eropa serẽcʉ̃ ĩagʉ Goãmʉ Saulore apimʉriñumi. Saulo Cis magʉ árĩñumi. Benjami ya curu majagʉ árĩñumi. Eropigʉ cuarenta bojori gohra erã opʉ árĩbure apiñumi Goãmʉ ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eropigʉ Goãmʉ Saulore ĩgʉ cóãra pʉhrʉ Davire apimʉriñumi ĩgʉ. Õpa arĩñumi Goãmʉ Davire. “Davi Isaí magʉre bocabʉ yʉhʉ. Ĩgʉre mucubiria yʉhʉ. Ĩgʉ yʉ gamerire iipehogʉcumi,” arĩñumi Goãmʉ. ");
INSERT INTO des_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ihĩ Davi ĩgʉ pãrami árĩturiagʉ ãhrimi Jesu. Goãmʉ Jesure apidigʉ árĩmi Israe masare itamubure. “Masare õaro iigʉca,” arĩñumi Goãmʉ. Ĩgʉ arĩdiro dopa ta iidi árĩmi ĩgʉ Jesu. ");
INSERT INTO des_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ĩgʉ eropa iiboro core Jesu ĩgʉ ariboro core Ñu waĩyegʉ õpa arĩ buhepʉ: “Mʉa ñerire bʉjawereque. Õaripʉre gohrotoque. Eropirã waĩyesũnirã árĩque,” arĩ buhepʉ Ñu árĩpehrerã Israe masare. ");
INSERT INTO des_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Eropigʉ Ñu ĩgʉ buhetuboro core, ĩgʉ sĩriboro core õpa arĩ weremʉripʉ. “¿Nihino ãhriri yʉhʉ mʉa pepicʉ̃? Iribojegue majagʉ Goãmʉ yare weremʉhtadigʉ árĩbeaa yʉhʉ. Cristo árĩbeaa yʉhʉ. Gajigʉ ãhraa. Cristo yʉhʉ árĩbiriquerecʉ̃ yʉ pʉhrʉ yʉ tauro turagʉpʉ arigʉcumi. Ĩgʉpʉ õatariagʉ ãhrimi. Ĩgʉ iro dopa árĩbeaa yʉhʉ,” arĩ werepʉ Ñu masare, arĩpʉ Pablo. ");
INSERT INTO des_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Acawererã, Abrahã pãramerã, árĩpehrerã mari Pagʉre gʉhyadiaro ĩarã, marire i ĩgʉ tauborore wereri buherire obeodi árĩmi mari Pagʉ. ");
INSERT INTO des_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalén majarã erã oparã mera Jesu erãre taugʉ ĩgʉ árĩcʉ̃ masibirinirã árĩma. Sabadonʉri árĩcʉ̃ Goãmʉ yare weremʉhtanirã erã gojarare buhequererã ta Jesure masibirinirã árĩma. Eropa masibirã Jesure wejẽdoreñorã. Eropa iirã Goãmʉ yare weremʉhtanirã erã gojadiro dopa ta iirã iiñorã. ");
INSERT INTO des_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ĩgʉre erã wejẽboro core erã Jesure weresãriñorã. Ĩgʉ ñerire iibiriquerecʉ̃ ta erã Pilatore Jesure wejẽdoremorã serẽñorã. ");
INSERT INTO des_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Eropirã iribojegue majarã erã gojadiro dopa ta Jesure iituhaja, ĩgʉre crusague árĩgʉre aĩdiju, masa gobegue ʉtãyegue erã seara gobegue apiñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Eropa erã ĩgʉre wejẽquerecʉ̃ ta Goãmʉ masudi árĩmi ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Eropirã Galileague arinirã Jerusaléngue ĩgʉ mera ejanirã bajanʉri ĩgʉre sĩri masa deyodigʉre ĩañorã. Eropirã dohpaguere ĩgʉre erã ĩarare masare werema erã. ");
INSERT INTO des_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Eropa masare wereniguigʉ õpa arĩ werenemopʉ daja Pablo: —Eropirã õari buherire werea gʉa mʉare. Goãmʉ mari ñecʉ sʉmarãre “Masare õaro iigʉca,” iribojegue ĩgʉ arĩdiro dopa ta dohpaguere marire erã acawererãre iiami. Irire ĩgʉ wererare õpa iiami ĩgʉ. Goãmʉ Jesure masudi árĩmi. Eropirã Jesure ĩgʉ masurare werea gʉa mʉare. Salmopũgue iribojegue ĩgʉ õpa arĩ gojadiro dopa eropa wayoro Jesure: “‘Mʉhʉ yʉ magʉ ãhraa. Dohpagãre mʉre dehyoacʉ̃ iiabʉ,’ arĩmi Goãmʉ ĩgʉ magʉre,” arĩ gojañumi iribojegue. ");
INSERT INTO des_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Eropigʉ Goãmʉ Jesure ĩgʉ masuburire dipaturi ĩgʉ sĩribiriborore weregʉ õpa arĩ were gojadoreñumi Salmopũgue: “Davire yʉhʉ mojomoro ĩadiro dopa ta diaye ta õaro iigʉra mʉa sãre,” arĩ gojadoreñumi. ");
INSERT INTO des_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Eropigʉ gaji Salmo sãre õpa ta arĩ wereñumi: “Goãmʉ mʉ õagʉ ĩgʉ dʉpʉre boadorebirabʉ mʉhʉ,” arĩ gojañumi. ");
INSERT INTO des_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Eropigʉ Davi Goãmʉ ĩgʉ gamediro dopa ta ĩgʉ árĩrasubu majarãre itamumʉriñumi. Pʉhrʉ ĩgʉ sĩria wañumi. Ĩgʉ sĩrira pʉhrʉ ĩgʉ pagʉ sʉmarãre erã iidiro dopa ta yaañuma ĩgʉ sãre. Eropigʉ ĩgʉ boa wañumi. ");
INSERT INTO des_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Eropigʉ ihĩ Jesu Goãmʉ ĩgʉ masudigʉpʉ ne boabiridi árĩmi. ");
INSERT INTO des_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Eropirã mʉa, yʉ acawererã, ire masique: Goãmʉ mʉa ñerire ĩgʉ cóãborore mʉare ire werea gʉa. Jesupʉ mʉa ñerire cóãbu ãhrimi. ");
INSERT INTO des_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Eropigʉ ĩgʉre umupeorãre erã ñero iirare cãdijicãgʉcumi ĩgʉ. Moisere ĩgʉ apira dorerire mʉa iira mera Goãmʉ pohrogue wasome mʉa. Eropigʉ iri dorerire iiri mera taridiarãre erã ñerire cóãsome Goãmʉ. ");
INSERT INTO des_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Eropirã õaro iique. Mʉa õaro iibiricʉ̃ Goãmʉ ya weremʉhtanirã erã gojadiro dopa ta mʉare waroca. Õpa arĩ gojañuma: ");
INSERT INTO des_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Peeque mʉa queoricʉrã. Yʉre ĩhaturirã ãhraa mʉa. Yʉ õpa iicʉ̃ güique mʉa. Eropirã peamegue waque. Mʉa árĩrinʉrire mʉare ii ĩhmugʉra. Yʉ eropa ii ĩhmucʉ̃ ĩaquererã “Diaye ta ãhraa,” arĩsome mʉa. Gajigʉ irire mʉare ĩgʉ õaro werequerecʉ̃ ta “Diaye ta ãhraa,” arĩsome mʉa, arĩ gojañumi Goãmʉ yare weremʉhtadigʉ, arĩ werepʉ Pablo erãre. ");
INSERT INTO des_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ĩgʉ eropa arĩ werera pʉhrʉ judio masa buheri wihigue erã wiriara pʉhrʉ judio masa árĩbirãpʉ erãre serẽñorã. —Gaji semanague Sabado árĩcʉ̃ ire buheba daja gʉare, arĩ serẽñorã erã Pablore. ");
INSERT INTO des_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Eropirã iri wihigue árĩnirã wiria, judio masa bajarã, judio masa árĩbirã sã Pablo, Bernabé sã mera wañorã. Judio masa árĩbirã judio masa yare buherã árĩñorã. Erã erã mera wacʉ̃ Pablo Bernabé mera õaro wereñorã erãre. “Goãmʉ mʉare mahimi. Eropirã ĩgʉre umupeorã árĩniguicãque,” arĩ buheñorã erã. ");
INSERT INTO des_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Eropirã gaji semanare Sabado árĩcʉ̃ árĩpehrerã Jesu yare peediarã gamenereñorã. ");
INSERT INTO des_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Eropirã judio masapʉ bajarã masa Jesu yare peediarã gamenerecʉ̃ ĩarã guañorã. Eropa guarã, erã gajiropa arĩ werenigui, Pablore ñero quere goroweoñorã. “Mʉare ĩgʉ buheri diaye árĩbeaa,” arĩñorã erã. ");
INSERT INTO des_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Erã eroparĩcʉ̃ peerã, Pablo, Bernabé mera erãre quere goroweonirãre güiro mariro wereñorã. —Goãmʉ ĩgʉ dorediro dopa ta mʉare judio masare buhemʉhtarabʉ gʉa. Mʉapʉ irire gamebirituhabʉ. Ʉmʉri nʉcʉ Goãmʉ mera árĩniguicʉ̃ sãre gamebirituhabʉ mʉa. Eropirã gʉapʉ judio masa árĩbirãpʉre buhenʉgarãca. ");
INSERT INTO des_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Õpa ta doreñumi mari Opʉ gʉare: Mʉa judio masa árĩbirãre buherã erãre Goãmʉ yare õaro masicʉ̃ iirãca mʉa. Eropigʉ mʉa yoarogue árĩrãre mʉa buhecʉ̃ peerãre erãpʉre peamegue wabonirãre taugʉca yʉhʉ, arĩ wereñumi Goãmʉ gʉare ĩgʉ yare gojarapũgue, arĩ werepʉ Pablo, Bernabé mera. ");
INSERT INTO des_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Erã eroparĩcʉ̃ peerã judio masa árĩbirãpʉ mucubiriñorã. “Mari Opʉ yapʉ õari ãhraa,” arĩñorã erã. Eropirã Goãmʉ ĩgʉ gamenirã, ʉmʉri nʉcʉ ĩgʉ mera erã árĩniguiborore ĩgʉ odianirã Jesure umupeonʉgañorã. ");
INSERT INTO des_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Eropirã mari Opʉ Cristo yare iri yebague werepehoñorã. ");
INSERT INTO des_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Erã eropa iicʉ̃ ĩarã judio masa sʉabiria wañorã. Erogue mari Pagʉre umupeorã nome, õarã nome árĩñorã. Eropirã judio masa Pablo sãre ñero wereniguiñorã. Erã eropa wereniguicʉ̃ peerã erã nome Pablo mera Bernabé mera guañorã. Eropirã iri maca majarã oparã sã erã mera guañorã. Eropa quarã ero majarã ñero iiñorã Pablo sãre. Erã eropiira, pʉhrʉ Pablo sãre erã ya yebague árĩrãre cohã wiucãñorã. ");
INSERT INTO des_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Erã eropa iicʉ̃ ĩarã, Pablo Bernabé mera erã guburi maja nicure pasiripiñorã iri maca majarã erã ñeri wajare ĩhmurã. Eropa iituhaja erã Iconiogue waha wañorã. ");
INSERT INTO des_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Eropirã erã Jesu yarã wʉaro mucubiri, Espíritu Santo wʉaro ĩgʉ dorediro dopa iirã iiñorã. ");
INSERT INTO des_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Eropirã Iconiogue árĩrã Pablo Bernabé mera judio masa buheri wihigue ñaja, Jesu yare wereñorã. Eropirã judio masa bajarã Jesure umupeonʉgañorã. Eropirã judio masa árĩbirã sã Jesure umupeoñorã. ");
INSERT INTO des_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Judio masa Jesu yare peediabirãpʉ judio masa árĩbirãre Jesu yarã mera erã guacʉ̃ iiñorã daja. Erã eropa iicʉ̃ judio masa árĩbirã ñero pepiñorã Jesu yarãre. ");
INSERT INTO des_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Erã eropa pepicʉ̃ ĩarã Jesu yarãpʉ Pablo sã erogue yoari boje árĩrã, güiro mariro mari Opʉ yare õari buherire buheñorã. Goãmʉ masare ĩgʉ mahirire buheñorã. Erã eropa buherisubu Goãmʉ turari mera deyoro moarire ii ĩhmuñorã, “I buheri diaye ta ãhraa,” arĩ ĩhmurã. ");
INSERT INTO des_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Eropirã iri maca majarã deco mera judio masa yare gamerã dujañorã. Deco mera ta Jesu yare gamerã sã dujañorã. Erã pe curu dʉca wariñorã. ");
INSERT INTO des_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Eropirã Jesu yare gamebirãpʉ judio masa sã árĩbirã, judio masa sã erã oparã mera gamenere Jesu ĩgʉ apinirãre ñero iidiariñorã. Ʉtã mera dea wejẽdiariñorã erãre. ");
INSERT INTO des_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Erã eropa iidiarire masirã, Pablo, Bernabé mera Licaonia yebague duhrigã waha wañorã. Iri yeba árĩri macari tari wahgã Listra waĩcʉri macare Derbe waĩcʉri maca sãre ejañorã. ");
INSERT INTO des_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Erogue ejarã, õari buherire buheñorã daja erã. ");
INSERT INTO des_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Eropii Listrague curimasibigʉ doapʉ. Ĩgʉ ne masa dehyoagʉgue ta curimasibiridigʉ árĩpʉ. ");
INSERT INTO des_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Eropigʉ ĩgʉ Pablo ĩgʉ buhecʉ̃ peepʉ. Ĩgʉ peerisubu Pablopʉ ĩgʉ dihtare ĩapʉ. Ĩgʉre ĩanʉrʉ õpa arĩ pepipʉ: “Ihĩ Jesure umupeomi. Eropigʉ ‘Jesu yʉre dʉpʉ õacʉ̃ iimasimi,’ arĩ pepigʉ iicumi,” arĩ pepipʉ Pablo curimasibigʉre. Eropa pepigʉ turaro mera õpa arĩpʉ Pablo ĩgʉre: —Wahgãnʉgajaque, arĩpʉ Pablo ĩgʉre. Ĩgʉ eroparĩcʉ̃ peegʉ ta curimasibigʉpʉ buhrimanʉgaja, wapʉ. ");
INSERT INTO des_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablo ĩgʉ eropa iicʉ̃ ĩarã masa gaguiniguiñorã. Erã Licaonia ya mera õpa arĩ gaguiniguiñorã: —Goãmarã masa dopa bejarã ʉmarogue árĩrã mari pohrogue dijarama, arĩ gaguiniñorã erã. ");
INSERT INTO des_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Eropirã erã Bernabére “Mari goãmʉ Zeus ãhrimi,” arĩ piyuñorã. Eropirã Pablo buhemʉhtadigʉ opʉ iro dopa ĩgʉ árĩcʉ̃ ĩarã “Mari goãmʉ Hermes ãhrimi,” arĩ piyuñorã erã ĩgʉre. ");
INSERT INTO des_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Eropirã Zeure umupeorã ya wihi iri maca tʉro pohro árĩyoro. Eropigʉ Zeus yarã erã pahipʉ iri wihigue árĩgʉ macague ñajariri disiporo pohrogue wecʉare, gori amurare aĩgãripʉ. Iri mera Pablore Bernabére “Mari goãmarã ãhrima,” arĩ umupeodiariñorã. Eropirã erã wecʉare soemuju Pablore, Bernabére umupeodiariñorã. ");
INSERT INTO des_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Erã eropa iidiacʉ̃ ĩarã Pablo, Bernabé mera erã basi erã ya suhrire yehguenʉgañorã erã bʉjawererire masare ĩhmurã. Erã yehguenʉgara pʉhrʉ masa watope omagã, gaguiniguiñorã erã. ");
INSERT INTO des_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Mʉa õpa iibiricãque. Gʉa sã mʉa iro dopa ta masa ãhraa. Mʉa õpa iiri ne duhpiburi árĩbeaa. Eropirã mʉare õarire buherã ahrabʉ. Õpa iirire duhudorerã arirã iiabʉ. Oã mʉa goãmarãre mʉa wéanirãre ñerãre cóãcãque. Eropirã Goãmʉre ojocarigʉpʉre umupeoque. Goãmʉpʉ ʉmarore, yebare, wʉariyare, árĩpehrerire, árĩpehrero majarãre iigʉ ãhrimi. ");
INSERT INTO des_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Eropigʉ ĩgʉ iribojegue árĩpehreri macari majarã erã gamero iirare eropa ĩacãñumi. ");
INSERT INTO des_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ĩgʉ eropa ĩacãqueregʉ ĩgʉ árĩricʉrire ĩhmumi marire. Ĩgʉ masare õarire ii, deco aricʉ̃ ii, dʉcare oo, masare barire oniguimi. Ĩgʉ eropa ocʉ̃ masa mucubirima. Eropa ta ĩgʉ árĩricʉrire ĩhmumi masare, arĩpʉ Pablo, Bernabé mera. ");
INSERT INTO des_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Eropirã erã eroparĩcʉ̃ peequererã ta masa wecʉare wejẽ soemuju erãre umupeodiariñorã. Eropa erã umupeodiacʉ̃ ĩarã erãre eropa iidorebiriñorã Pablo sã. Erã eropa iirire duhudiabiriquererã duhuñorã. ");
INSERT INTO des_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Eropii gajirã judio masa Antioquía majarã, Iconio majarã sã Listrague ejañorã. Erogue ejarã, Pablore ñero wereniguiñorã ero majarãre. Erã eropa wereniguicʉ̃ peerã masa ĩgʉ mera guanʉ