﻿USE sofia;
DROP TABLE IF EXISTS sofia.ded_vpl;
CREATE TABLE ded_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ded_vpl WRITE;
INSERT INTO ded_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Ngic goa yeni Anutu ngadehema mangana megecdeac ayemmeu ngic mong ye imoc wama yeneac dederecgeyoac mi modacande, me ngic kopocsicgoc yeneac sinnu mi kengande, nga ye desusuicngic, yeneac botucfu naric mi tarude, ngic ifia ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Ye Anutuac dedeseriyoacac songo negemma hadzing toforec imoc hennegeng amma negengising angkecde. ");
INSERT INTO ded_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Ngic yeneng doku eacdaeu ic mong homecgec nasoya hau fora amma maria mi dzanggeande, mong ye siriha imocacsoc kecma wiac sasawa angande, imoc forayagoc anu ngereeude. ");
INSERT INTO ded_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni ngic dindingac, yeni isoc kpac. Firangngo padi sebera homemea mefiranggeande, yeni ifia isoc. ");
INSERT INTO ded_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Imocac ngic mangana yeni Anutuac yoacfu namma naric mi serigecde. Yeni kopocsicmemengo dindingac yeneac kpebunnu Anutuac kicfu mi serigecde. ");
INSERT INTO ded_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Anutungo ngicngac dindingac yeneac sing hennegeng amma garengyunuude. Nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni ine kpac anggecde. ");
INSERT INTO ded_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Foracngoc, bangec monnunac ngicngac Anutu mi negemmidae, yeneng faka mangana anggecdeac yoac dedzege andae nga ngiha ngiha yeni negen negeng ua mema kpedzongemeandae. ");
INSERT INTO ded_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Bangecac ngictau yeni efaigec ngic enara uayoacnginagoc, yeni kpeturanggema KEBU memagecde. Nga yeng ngic meisinggema kerecdokungo nadzicmiec, ye ifingoc memagecdeac yoac yofi deandae, ");
INSERT INTO ded_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Yeri sengngo witicnunuoc, nenang imoc herecgema rekongngirango mendannunude, imoc merecgema ukubisina.” ");
INSERT INTO ded_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Ngic kurumenga kurumenga, imohai kecde, ye dzomorede. KEBUNGO yenemma detenic ayemmema ");
INSERT INTO ded_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","yoac ngabayagoc deu herebuyango kengec meficgeyemmema yofi deude, ");
INSERT INTO ded_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Foracngoc, ni ngictauna neac Siong tiki kpetiacfu bic faiba tacde.” ");
INSERT INTO ded_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","KEBUNGO yoac desima neac deec, imoc dekperagiba, yofi edenuec, “Ni yagucnoc megudua. Ge medacna nga ni geac Mangga. ");
INSERT INTO ded_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Ge wiac gembadeac kpesinenna ni ngicngac bangec monnunac desigemba yeneng maridzomingga anggecde. Bangec tegia fekende, yeni sasawa geac anggec geng mingingngina annade. ");
INSERT INTO ded_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ngictauyasuga aiengngo memea mekecnec, ge imoc mema ngicngo enang kpedzameandae, ifi isoc yasugango kpedzameyununade.” ");
INSERT INTO ded_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Imocac ngictau ngeni yomoc negensibisia. Bangecac enara uayoacnginagoc kecdae, ngeni goroyoac yomoc negemma garengemema kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Ngeni KEBU kengecgoc kingang kpemima dzonong fede fedegoc desogai ammibisia. ");
INSERT INTO ded_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Medac ye herebu bic angkecde. Yeng ngaba angemmeu ngeni sinnu manganema kpac ambauac haniau ngonducnema titikokoc ammibisia. Ngicngac yeac hoannu sufuma kecdae, yeni kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Dawidingo medaha Absaronggac kicfunac worama yegec yofi heiec. O KEBU, ngic ngabafocna yeni homac yombong nga ngic homacngo yacma nubeso andae. ");
INSERT INTO ded_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Ngic homac yeneng neac yofi deandae, “Anutungo ye ebicfunac naric mi mesiude.” Selac ");
INSERT INTO ded_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","O KEBU, gennoc oronnuma kasona annec. Geng kuc nga kibikpergiagoc ambadeac anengkecma orucna memiacma meserinukecnec. ");
INSERT INTO ded_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Ni KEBUARU seria kiacba yeng kpetiac tikiyau tacma yoacna turunga merennenude. Selac ");
INSERT INTO ded_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","KEBUNGO nanggenuude, imocac ni mafema monggoc yacbade. ");
INSERT INTO ded_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Ngic teng taoseng nga noc yeneng habuya habuya kpedzucnema noboc nobocnac hama nubeso oronnugec ni yeneac mi kengecnuude. ");
INSERT INTO ded_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","O KEBU, ge hama ebicfunac mesinuna. Anutuna, ge ngabafocna ngebacngina kpedzamema manganameme enacngina kpemoronggena mabeso. ");
INSERT INTO ded_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","KEBU ye ebic mesi mesi mingina. Kebu, ge ngicngacfocga kenecnununa. Selac ");
INSERT INTO ded_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Yegecgareng yearu. Gitakurere nga noc kpema yegec yomoc heibesonga. Dawidingo mitiyegec yofi heiec. O Anutu, ge dindingac kekecna, ni kpacguba ge kpakpacna negemma turunga merennenna. Ebicfu ubaebic meficgeba geng titing meficgenenna kekecna ngereeu naric kefai. Ge wosoefac anemma nunumuna negenna. ");
INSERT INTO ded_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ngicac medacfora, ngeni neac eweheihei kekec heimeremma desofoc anengandae, imoc naso dafiguc angkecgecde? Ngeni yoac sicsauc foraya kpac, imocac songo negemma ikocac sing meficgegecdeac ua meandae, ngeni imoc naso dafiguc angkecgecde? ");
INSERT INTO ded_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","KEBUNGO yengena enac tofoc tofohongic bic segereu yengena areng ande, ngeni imoc negembisia. Ni KEBU kpacba yeng ubaudumenna negenude. ");
INSERT INTO ded_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Ngeni herengina buu kopocsic mi meficgebisia nga fefenginau fema ubanginau wiac negensima waicke febisia. Selac ");
INSERT INTO ded_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Ngeni sese sirihau meficgema faima KEBU negenserima kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Ngicngac homacngo yofi deandae, “Wiac gombunga edzacnunugecdeac anemmede. O KEBU, ge kicmesugaac kperagingo nerarannununa.” ");
INSERT INTO ded_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Ngic goa yeni semeng uanginau wit nga waing gboria efea kpac fingeru sogaigecde anu geng sogac sogai herenau fainec, imocngo ine yeneac ubangerec ferahade. ");
INSERT INTO ded_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","O KEBU, geng onggonnuna ruaegoc kecbadeac ruaegoc fefenau mama gau febade. ");
INSERT INTO ded_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Yegecgareng yearu. Kungac fima heibesonga. Dawidingo yegec yofi heiec. KEBU ge kedzac faima yoacna negenna nga asoringa anende, imoc negensina. ");
INSERT INTO ded_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ngictauna nga Anutuna, ni numugenduaeac kedzac kpena nga meficnunadeac kpacguba ge kpakpacna nga enacudumenna negenna. ");
INSERT INTO ded_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","O KEBU, ni asoacngoc kpacguba enacudumenna negengannec nga asoacngoc sesena mengerema gearu faima tomai kecbade. ");
INSERT INTO ded_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Anutu, geng ngic ngadeguma mangana megecdeac ayemmeande, yeneac ubangerec mi negennec nga ngic mong ye faka mangana hoanggeande, yeng gegoc naric mi kefude. ");
INSERT INTO ded_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Ngic yoackpekpe yoac homac osoandae, yeni geac kicfu naric mi hama nanggecde. Ge yarengic ubango ukuyunudacma wayununade. ");
INSERT INTO ded_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Geng ngic ikocyoac deandae, yeni kpetotieyununa kpac anggecde. Nga ngic ogofocngina kpebucyunuma sac hembeso ayemmeande nga ogofocngina tobangyunuandae, ngic ifia KEBUNGO ubango wayunuude. ");
INSERT INTO ded_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Geng yoac dedzege amma imoc modackecnec. Imocac ni amagau erema kicna kpetiac womonggau fima eweheiheigoc fafoc heigemma numugembade. ");
INSERT INTO ded_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O KEBU, ni ngabafocna kecdaeac geangga faka dindingacfu hesicnuma singga mesorongainenna tima kembade. ");
INSERT INTO ded_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Yeni enanginau yoac fora mong mi fede nga herenginau ogofocngina memanganeyunugecdeac negen negensac fede. Yeni ubangina imoc kicsere angge anggea nga nedzarangnginango yoac deandae, imocngo ngicngac kerec ayemmema manganau faiyunugecde. ");
INSERT INTO ded_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","O Anutu, ge ngic ifia yoacfu faiyunuma kopocsicnginaac turunga yemmebesena. Yeni yenaoc yoac goa dzegegecac yoac imocngo memayunubeso. Yeni singyoac kpekecgec homac andeac kporacyununa yeni ngadeau kemema kecbisia. Yeni yoacga kpegec, imocac ge memayunubesena. ");
INSERT INTO ded_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Ngicngac hoanggau hama sufuma kecdae, yeni sogac sogai meficgeyemmema ubangerec ayemmena nasosoc ubangerecac yegec heikecma sogac sogaigoc kecbisia. Geng orongyunuma onggongyununa. Ge ifi anna ngicngac yeneng kpacgaac songo negemma geac negenggec engena anu sogaigecde. ");
INSERT INTO ded_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","KEBU, geng ngic dindingac kenehema gombunga ammina imocngo mariku isoc kasoya anude. ");
INSERT INTO ded_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Yegecgareng yearu. Gitakurere nga noc kpema sheminic uba modacma heibesonga. Dawidingo mitiyegec yofi heiec. KEBU ge ngaba amma ngabasiricfu yoac mi anenna amma herega buu numeme mi anenna. ");
INSERT INTO ded_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","O KEBU, ni kucna kpac anu homebeso anduae nga kengec amma dzononna fededeac neac ubaga manganeu sebina mengerena. ");
INSERT INTO ded_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","O KEBU, ni ongana kengectoa meficgema ebirima kecdeac ubaebicna bic meickenadeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","O KEBU, ge dzigene hama kekecna ebicfunac mesina. Ge yoac dedzege amma imoc modackecnecac ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Homecfu kemegec, yeni ge mi negensigugecde nga mong ye homec amau kemema fede, yeng ge naric mi dengereguude. ");
INSERT INTO ded_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ni asoringa anengkefu kucna kpac ande. Ni tofocnacsoc kiacba kickumana dokutoa isoc mama heifefena heiude. Amma ni homac kiacba kickumanango fefena meu boroc boroc yombong angande. ");
INSERT INTO ded_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Ni ubahodunnagoc kecduaeac kiacba kicna ngopic kpede nga kiacba ngabafocna sasawa ebic meficgenenggec kicna kuha kpac ande. ");
INSERT INTO ded_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","KEBUNGO kedzac kpema neac kiac ubamangang bic negendacac manganameme ngic ngeni sasawango wanuma meickegec. ");
INSERT INTO ded_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Ni ubamangang amma KEBU dekpesi ammiba imoc bic negendac. KEBU ye nunumuna negenu ngereede. ");
INSERT INTO ded_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Ngabafocna yeni gameyunudaru homac yombong kengecyunuu fakanginaac amma gameyunuu wanuma bic yombong woragecde. ");
INSERT INTO ded_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Yegec yomoc Shiggaiong uba modacma heibesonga. Dawidingo Benyaming ngic mong kpara Kushiac yoac negemma yegec yofi KEBU heimiec. O KEBU, Anutuna, ni geac hoannu hama sufuduae. Ngic yeni sasawango kisannuma menubauac onggonnuma ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Ngic mongngo yeneac mariunac naric mi mesinuudeac raiong yangtoa isoc sorienacnginango sebina merecgegec kapuc kpeu menuma kembauac geng onggonnuna. ");
INSERT INTO ded_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O KEBU, Anutuna, ni faka mangana dedaemoc anaiu me marinango ngicngac goa memanganeyunubai dede. ");
INSERT INTO ded_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Me ngic mongngo nigoc ruae kecmanu mangana hoanggema ammibai me ngabangicnaac finac eng wangecma mekembai dede ");
INSERT INTO ded_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ngabangicna geng negemmana kisannuma naric menubeso. Ye kpebucnuudeac ubana tindziru onganango bangecac gotennu febeso. Selac ");
INSERT INTO ded_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","O KEBU, ge ngaba amma yacna. Ngabafocna yeni herengina buu geng yacma memayunubesena. O Anutuna, kopocsicac turunga fingecyemmeudeac deserinecac amma ge gborima yacma meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Ngicngac yeni kicgau hama kpeturanggegec ge wi kurumennu ngictau tatacgau tacma garengyununa. ");
INSERT INTO ded_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","KEBUNGO ngiha ngiha sasawa faka angammengina isinggedacma foraya deude. O KEBU, ni dindingac kecma kopocsic mong mi meficgeai. Ge imocac faka angammemena yoacfu isinggema foraya dena faka dindingac meficgenenna firang ambesare. ");
INSERT INTO ded_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","O, gennoc Anutu dindingac amma ngicngac negen negengngina nga herenginaac hengising mingina. Geng ngic mangana megedeac ayemmeande, yeneac yarefakaac kpae heina kpac ambeso nga ge ngicngac dindingac tatacngina meficgema faiyununa ihai seria tacbisia. ");
INSERT INTO ded_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Anutu Kuctoa mingina, ye neac kasona. Yeng ngicngac hereninau ikoc nga hamangec mong mi fede, nenang ebicfunac mesinunuude. ");
INSERT INTO ded_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Anutungo ngicngac faka angammemengina yoacfu isinggema faka dindingac modacma foraya deude. Amma ye wenacsoc mangana hemma modzea tide. ");
INSERT INTO ded_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Ngic mong ye ubea mi merendeu Anutungo soea dzumuma tebea kpesaiudeac efaiude. ");
INSERT INTO ded_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ye kpebucyunuudeac dzikacac iwaiya mengerema tebemedaha gerec borangagoc memengere bic andac. ");
INSERT INTO ded_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Negenggec, ngic imoc ye wiac mangana kpenanggema ebicngo tobangyunuudeac heregoc kecma wiac hereau meficgeu imohacnac fingerude, imoc kpara ikoc. ");
INSERT INTO ded_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ngicngac botacfu meyunuudeac negemma yeng teng keme kemea anudeac bangec homac usuma yengenaocngoc makpema tengau kemeude. ");
INSERT INTO ded_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Ye tobangyunuudeac ebic arenggema ngicngac ogofora ayemmeu ebic imocngo dzigene hama yengena oruhau heiude. Nga ye ogofora memanganeyunuu faka imocngo yengenaaru dzigenema ye memanganema oruhau heiude. ");
INSERT INTO ded_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","KEBU ye dindingac, imocac ubangerec ammibade. Ni yegec heima KEBU Kuctoa minginaac kpac kuneng heiwayong memibade. ");
INSERT INTO ded_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Yegecgareng yearu. Gati yeneac musiwiac kpema heibesonga. Dawidingo mitiyegec yofi heiec. O KEBU, ge Kebunina, bangectoa bangec fekendeu kpacga Engenatoa yombong feude. Ge kurumenga kurumenga feracyunuma kucga kibikperagiagoc wi yombong faina fede. ");
INSERT INTO ded_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Ge nambarac kapia nga sabac namuu kecdae uayoac yemmena yeneng geac kpac kuneng heiwayong memigec faka kuhagoc fingerude. Ge ngabafocga kecdae, yeneac amma ifi annec. Nambarac yeni ifi anggec ngabafocga nga ngicngac goa yeni turung kpoukpouyoac homac osoandae, yeni yoacngina kpac anu waicke tacgecde. ");
INSERT INTO ded_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Geng kurumenga kurumenga meficyununa marikibiga andae nga ge afo nga asomeng sasawa wi faiyununa tatacnginau seria tacgec yenenganduae. Yenemma ");
INSERT INTO ded_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","yofi negensima deba, “Geng bangecfu ngicngacnec negensinunuma ngicac medacfora gombunga garengnunukecnec, imocac warecguduae. ");
INSERT INTO ded_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Geng ngic meficgema tatahau faina yeng Anutuac siric anu Anutungo kunenga kecde. Ye kuc kibikperagigoc kefudeac ge imocngo iraya isoc heiminec. ");
INSERT INTO ded_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ge marikibiga sasawa meficgena yeng imocac mingina kefudeac fainec. Ge wiac sasawa yengena haniaac bageu fainec. ");
INSERT INTO ded_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Imoc amau rama burumaka sasawa nga manennu yang sasawa ");
INSERT INTO ded_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","amma sawau neng sasawa nga kondunnu kondungyang amma kondung manau yang hania hania singngina mema kenghaandae, imoc yeac haniaac bageau faina garengyunuude.” ");
INSERT INTO ded_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O KEBU, ge Kebunina, bangeha bangeha fekendaeu kpacga imoc engenatoa yombong fekefude. ");
INSERT INTO ded_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Yegecgareng yearu. Yegec mong kpara Medac homeec, imocac uba modacma yegec yomoc heibesonga. Dawidingo mitiyegec yofi heiec. KEBU, ni heregoc yombong ubangerec megemma yofi edeyunuba, “Ye ua sasawa mekecde, imoc bibiagoc yombong.” ");
INSERT INTO ded_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Ni ubangerec negemma geac amma sogaibade. O Kuctoa mingina, ni geac kpac kuneng heiwayong memima yegec heibade. ");
INSERT INTO ded_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Ngabafocna yeni gemma dzigenema tifainggema mayunuu kpac anggec. ");
INSERT INTO ded_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Nga geng yoacfu nanggenuma yoacna faka dindingafu desina yoacfu firang anai. Ge ngictau tatacgau tacma faka dindingac modacma yoac isinggema desinec. ");
INSERT INTO ded_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Geng ngicngac bangec monnunac Anutu mi negemmidae, yeni yunumeting ayemmenec nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni kpetotieyununa kpac anggec kpacngina meickenec. Nga imoc sufuma nasoya nasoya kpac anude. ");
INSERT INTO ded_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Ngabafocnina yeni amangina sesuhasac wisic wisickea kpac anu ngaba yeneng imohai kpac anggec. Geng taongngina hembarackena kpac anggec ngic mongngo yeneac naric mi negensiude. ");
INSERT INTO ded_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","KEBU ye ngictau amma tatahau nasoya nasoya tarude. Ye ngictauac tataha faiu seria taru yoacfu faifai uaya meudeac efaide. ");
INSERT INTO ded_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ye faka dindingac modacma bangectoa bangecac ngicngac yoacngina isinggema foraya dema monde mondea kpac kecma ngiha ngiha yoacngina desiude. ");
INSERT INTO ded_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Ngicngac goa yeneng ngic ogofocngina ebic meficgeyemmegec ubaebicnginagoc kecgec, yeneac sufu sufuamangina seria, imoc KEBUNOC. Naso mangana hau yeng amangina seria anu ihai sufugecde. ");
INSERT INTO ded_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","O KEBU, ngicngac yeneng geac kpac kuneng negengandae, yeni negenserigugecde. Ngicngac yeneng ge hofocgugec geng yeni mi ngadeyunuma wayununade. ");
INSERT INTO ded_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","KEBUNGO Sionnu ngictau tatahau tacde, ngeni ye yegec heimima dengerebisia amma yeng ua mekecde, imoc ngiha ngiha botucnginau dekperagibisia. ");
INSERT INTO ded_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Ye ngic sac hetinggegec, yeni negengyunuma kopocsicnginaac turunga kpouyemmeude. Ngicngac ebicnginagoc kecma ye kpacgec yeng imoc naric mi nigeckpeude. ");
INSERT INTO ded_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","O KEBU, ngabafocna yeneng ngadenuma kpendzeng nga ebic nenggec kecduae. Ge neac ubaga manganeu meficnuna. O Kebu, ni homecac naguu febare geng miacnuna monggoc imohacnac erebade. ");
INSERT INTO ded_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Ge ifi anna ni faka gombunga angannec, imocac siduc andacma eriendzong megembade. Nga ge ebicfunac mesinunec, imoc Siong naroangaac naguu namma sogac sogaigoc dekperagiyemmebade. ");
INSERT INTO ded_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Ngicngac bangec monnunac Anutu mi negemmidae, yeni yenaoc teng usuma imohai kemegec nga ufic mesufuma faigec, imocngo haninginau meu mayunuec. ");
INSERT INTO ded_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","KEBUNGO yoacfu faifai uaya ngicngac yenearu meu neni ye negemmidimbe. Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni maringinango ua megec, imocngo yenang botacngina amma witicyunuude. Higgaiong, Selac ");
INSERT INTO ded_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Ngicngac Anutu ngadehema mangana megecdeac ayemmeande nga bangec monnunac ngicngac Anutu nigecyunuu kecandae, yeni ngic homegec, yeneac amau kemma kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Ngicngac iwaiac obohoma kecandae, Kebungo yeneac ebicngina nasosoc mi nigeckpeude, kpac. Ngicngac makpekpea yeneng Anutungo meficyunuudeac negensima tomai kecandae, yeni nasoya hau wiac imocac fora henggecde. ");
INSERT INTO ded_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","O KEBU, ge bangecngic kpae heiyemmena firang mi ambisia. Bangec monnunac ngicngac yeni geac kicfu nanggec geng yoacfu faiyunuma fakangina isinggena. ");
INSERT INTO ded_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","O KEBU, geng kengec meficgeyemmena. Ngicngac bangec monnunac yeni bangecngicsac andae, imoc edzacyununa negembisia. Selac ");
INSERT INTO ded_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","O KEBU, ge nocac neac hereau yombong nannec nga ge nocac ebicnaso anu sufuma kecnec? ");
INSERT INTO ded_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Ngic Anutu ngadehema mangana meudeac ammiande, ye yengenaac negenu engena ande. Ifi anu gereagoc kemma ngicngac kucmama kisangyunuma ebicngina arenggema mendangyunuude. ");
INSERT INTO ded_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Ngic Anutu ngadehema mangana meudeac ammiande, ye hereau negensongo mangana fede, imocac negenu engena anu yoac homac osoude. Ye iwaiac kichodung amma wiac homac mekpedzuc amma mekefudeac ammiude amma KEBU ngadehema yeac sowecyoac deude. ");
INSERT INTO ded_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Ngic Anutu ngadehema mangana meudeac ammiande, ye sebia meemma deude, “Anutu ye wiac imocac mi kpesinenude.” Amma yofi negensima kecde, “Anutu mong mi kecde, kpac.” ");
INSERT INTO ded_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Ngic mong ifi kecande, ye uaya nasosoc naric amma ngereeude. Ye ngabafora sasawa yeneac negenu wiac efeacnec andeac dzomoreyemmeude. Ye yoacga kpekefu geng wiac hengising amma foraya deannec, imoc yeac hereau fedeac imoc naric mi henude. ");
INSERT INTO ded_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Ye yengenaac yofi negenude, wiac mongngo menuu goroc goroc naric mi ambade. Ni nga esangabofocna kecma ebic mong naric mi meficgenide. ");
INSERT INTO ded_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Ye sowecyoac nga ikoc amma ogofocngina ebicfu faiyunuudeac yoac dekefude. Dekefu enara imocngo wakeu enacbibihau ngicngac tobangyunuudeac yoac nga ogofocngina memanganeyunuudeac yoac mesufuude. ");
INSERT INTO ded_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Ye amabangec wegenacfu sufuma tomai tacande. Taru ngic mongngo mangana mi meande, ye hau ngic manganango ngic memanganeyunuudeac areng andae, kiwa yenearu fima sufu sufuu kpebucyunuude. ");
INSERT INTO ded_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Raiong yangtoango icbisic botucnginau sufuma tacande, yeng ifi isoc sufuma kucmama yeni meyunuudeac tomai taru ngicngac memeficngina kpac andae, yeni ufihau mendanggegec meyunuma kenude. ");
INSERT INTO ded_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Ebicfu mayunugecdeac areng yeni ngonducnema bangecfu sufuma tacdae. Tacma memeficngina kpac kecma yeac mariu kpegec yeng kuhagoc meyunuude. ");
INSERT INTO ded_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Ngic mangana ye ubeau yofi negensiude, “Anutu ye neac nigeckpeu kiwa semema naric mi nenude.” ");
INSERT INTO ded_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","O KEBU, ge yacna. Anutu, ge mariga miacna enu. Ngic goa yeneng ngic ogofocngina ebic meficgeyemmegec ebicgoc kecandae, ge yeneac mi nigecgubeso. ");
INSERT INTO ded_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Ngic Anutu ngadehema mangana meudeac ammiande, ye nocac Anutu ngadehema yengenaac negemma yofi deude, “Ye kopocsicnaac turunga mi kpounenude.” ");
INSERT INTO ded_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Anutu, geng sifu ngicngac ebic nga kpendzenggoc kecdae, yenemma ebicngina negensima marigango meficyununadeac negennec. Memangac manganea kecde, ye kekeha gearu waande nga geng beging yeneac memeficngic. ");
INSERT INTO ded_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Geng ngic Anutu ngadehema mangana meudeac ammiande nga yarengic, yeneac maringina hetackena. Hetackema fakangina mangana hengising amma meficgekecna sasawa kpac andacbeso. ");
INSERT INTO ded_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","KEBU ye ngictau kecde nga kecengkefude. Nga bangec monnunac ngicngac Anutu mi negemmidae, yeneng yeac bangecfunac meickema kpac anggecde. ");
INSERT INTO ded_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","O KEBU, ngicngac yumia yeneng heresongongina edegugec ge imoc negemma herengina meseriyemmenade. Yeni kpacgugec ge kedzacga yenearu faina. ");
INSERT INTO ded_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Nga ngicngac goa yeni ogofocngina ebicfu faiyunugec. Faiyunugec ge ngicngac ubaebicgoc kecdae nga nambarac beging kecdae, yenenggareng ayemmema faka dindingac modacma ayemmebesena. Ge ifi anna bangecngic yeneng kengectoa monggoc mi meficgeyemmegecde. ");
INSERT INTO ded_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Yegecgareng yearu. Dawidingo yegec yofi heiec. Ni KEBUAC hoannu hama sufuma kecba ngeni dafi negemma yoac yofi edenudae, “Ge neng isoc kemma tikigau worana.” ");
INSERT INTO ded_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Negenna, ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni ngic goa herenginau ikoc nga hamangec mong mi fede, yenemma tebemedahango wedecyunugecdeac negemma kundunnu namma gurutu taima kpesaigecde. ");
INSERT INTO ded_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Ngic yeneng dedeseriyoaraac titiseri kpetotieyunuma meickegecdeu ngicngac dindingac yeneng wiac imoc mengeregecdeac obohogecde. ");
INSERT INTO ded_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","KEBUNGO womonga kpetiacfu tacde. Ye ngictau tatahau kurumennu tacma kiwango ngicac nambaracfora yenemma kiwa yenearu fima fakangina hennegeng anude. ");
INSERT INTO ded_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","KEBUNGO ngic dindingac fakangina tobanggeude. Yeng ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneac faka momoc tobanggeu ngic yarefakaac songo negengandae, yeni ubango wayunuude. ");
INSERT INTO ded_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Ngicngac Anutu ngadehema mangana megecdeac ayemmeande, yeng yeneac witiu hoc gerec dzedzeagoc nga sarafa gerec borangagoc kpakeu yenereude. Yenereu firang gerea yenereu imocngo pakenginau kpakegec yenanggac wiac anu yeni ebic imoc pakeunac isoc negecde. ");
INSERT INTO ded_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","KEBU ye dindingac amma ye faka dindingac songea negende. Nga ngicngac uba kongaha amma ikoc nga hamangecngina kpac kecdae, yeneng yeac kicmesu henggecde. ");
INSERT INTO ded_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Yegecgareng yearu. Yegec yomoc sheminic uba modacma gitakurere witingina 8ngo kpema heibesonga. Dawidingo mitiyegec yofi heiec. Ngicngac yoac modac modacfaka angandae, yeni bic kpac andacma ngicngac botucninau monggoc mi kecgecde. Nga Anutuac enac tofoc tofohongic, yeni kpac amma monggoc mi kecgecde. O KEBU, imocac meficnunubesena. ");
INSERT INTO ded_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Ngic sasawa yeni ogofocnginagoc denengeng amma ikoc andacgec enacbibicnginaunac yoackerec ikoha ereu herenginau manganango tobangyunugecdeac yoac degecde. ");
INSERT INTO ded_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Ngicngac yeni enacnginau yoackerec ikoha anggecde nga nedzarangngina yenanggac yoac engena homac osogec KEBUNGO imoc herecgema meickebeso. ");
INSERT INTO ded_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Yeni yofi deandae, “Neni nedzaranninango kuc nemmeu seria nannide nga enacbibicninango meficnunuu ngic mongngo naric mi garennunuma dzegenunuude.” ");
INSERT INTO ded_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Ifi degec KEBUNGO ine yoac yofi dede, “Yeni makpekpea memayunuma memanganeyunuandae. Nga ngicngac yeni ebic witiau kecma asoringa ayemmede, imocac yaguc yacma onggongyunubade. Yeni sufu sufuu ruaegoc tacgecdeac ayemmeu neng meyunuma hoannau faiyunubade.” ");
INSERT INTO ded_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","KEBUNGO yoac deserima deec, imoc sasawa yoac kongaha nga seuha kpac. Ngic yeni siriwa gerec gereagoc ohogec atac 7 anu bangecfu mama kongac koporarac anude. KEBUNGO yoac deserima deec, imoc ifi isoc ande. ");
INSERT INTO ded_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","O KEBU, geng onggonnunuma ngicngac yofinenggac kecdae, yenearunac nasosoc garennununa. ");
INSERT INTO ded_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Ngicac medacfora botucnginau yarefakaac negenggec engena ande. Nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni noboc noboc oronnunuma kengha andae. ");
INSERT INTO ded_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Yegecgareng yearu. Dawidingo yegec yofi heiec. O KEBU, ebicna noc nasou wisickeude? Ge naso wisic wisickea kpac kecma neac mi nigecgubeso. Ge kicmesuga nearu mesufukecnec, ge faka imoc wanadeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Ni ubaebicgoc kecduae, imoc wisickeudeac tomai kecma ubahodung wenacsoc negengkecduae, imoc kpac anudeac tomai kecduae. Ngabafocna yeni firang anggec yeneac bageu kecduae, imoc wisickeudeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","O KEBU Anutuna, ge neac negensima turunga merennenna. Ni homecfu heima febaiac kicnau kperagiga faina kecbesare. ");
INSERT INTO ded_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Nocac ngabangicnango yofi debacac, “Ni firang bic andua.” ifi deu ni goroc goroc amma manubeso anu ye imocac sogaibacac meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Geng yoac dedzege amma imoc modackecnecac negenseriguma kecduae. Geng ebicfunac mesinunecac amma ni heregoc geac desogai angkecduae. ");
INSERT INTO ded_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","KEBUNGO gombunga anengandeac yegec heimibade. ");
INSERT INTO ded_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Yegecgareng yearu. Dawidingo yegec yofi heiec. Ngic negen negengngina kpac, yeni herenginau yofi negemma deandae, “Anutu mong mi kecde, kpac yombong.” Yeni fakangina manganeu faka mangana yombong anggecde. Ngic mongngonec faka gombunga mi angkecde, imoc kpac yombong. ");
INSERT INTO ded_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","KEBUNGO kurumennu kecma ngicac nambarac yenemma kefude. Nga ngic mong ye negen negentegehagoc kecma Anutu hofocande, Kebungo kic fiu mau ngic ifia yeac kicfifi angkecde. ");
INSERT INTO ded_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Nga yeni ine sasawango ngade ngade monggoc kemedacma fakangina heimeremma manganedacgec. Ngic mongnga mong faka gombunga mi angkecde, mocdong kpac yombong. ");
INSERT INTO ded_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Yarengic yeni wiac negemma negen negentegecgnginagoc mi anggecde. Nga ngicngo yaka neandae, yeni ifi isoc ngicngacfocna neyunuma KEBU ine naric mi kpacgecde. ");
INSERT INTO ded_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Anutungo ngicareng dindingac kecandae, yenigoc kefudeac manganameme yeneng kengectoa amma homac yombong kpidohogecde. ");
INSERT INTO ded_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Yarengic ngeneng ngic makpekpea arengngina memanganebeso angandae, fora. Nga KEBU yennoc yeneac sufu sufuama. ");
INSERT INTO ded_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","O, Israe neneac mengec mengere, ye Siong tikiunac mama habeso, imocac yombong anemmede. KEBUNGO ngicngacfora monggoc mengerenunuu naric kecnide, naso imohai Yakoboac nambaracfora sogaigecde nga Israe neni ubangerec negennide. ");
INSERT INTO ded_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Dawidingo yegec yofi heiec. O KEBU, geac kporucwomongga kpetiacfu merang naric tarude? Nga merang tikiga kpetiacfu naric kefude? ");
INSERT INTO ded_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Ngic mong ye faka angammemeau kopocsic mong mi meficgeude nga mong ye faka gombunga angkecma hereaunac yoac fora ereu deude, yeng ihai naric kefude. ");
INSERT INTO ded_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Ngic mong ye nedzarangango ngadeyoac mi deude nga ogea mi memanganeude nga mong ye ogofora yeac wegenac kecandae, yeni game kpekpeuu naric mi faiyunuude, yeng ihai naric kefude. ");
INSERT INTO ded_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Ngic mong ye ngic mangana, yeneac modzea tiande nga ngicngac KEBU eweheiheigoc hoanggeandae, yeneac ewengina heiude. Nga mong ye dedeseriyoac modaru imocngo ebic homac meficgemiudeu imoc sifu modarude nga ye imoc negenu wiac engena mi anude, ngic imocngo Kebuac tiki kpetiacfu naric kefude. ");
INSERT INTO ded_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Ngic goa yeneng ngic mong yearu turung angkecdae amma kpougecde, imohai yeng profit dema dzo monggoc torokpema mi meude. Amma ngicngac goa kopocsicngina kpac kecdae, yeng yeni yoacfu memayunuudeac moneng naric mi meude, ngic ifia yeng Kebuac tiki kpetiacfu naric kefude. Ngic mong ye faka imoc angkecde, ye wiac mongngo meu goroc goroc naric mi anude. ");
INSERT INTO ded_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Yegec yomoc miktang uba modacma heibesonga. Dawidingo yegec yofi heiec. O Anutu, ni geac hoannu hama sufuma kecbadeac onggonnuna. ");
INSERT INTO ded_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ni KEBU yofi ededuae, “Ge Kebuna, forangoc, gea kpac wiac mong gombunga naric mi mekecbai.” ");
INSERT INTO ded_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Bangecfu ngicngac kpetiac yeni ngicngac eweheiheinginagoc, yeneac negemba ngereede. ");
INSERT INTO ded_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Ngicngac nemuonga meisinggema hoanggeandae, yeni ine ubahodung kekecnginau kpedzigec hama ebicngina monggoc nga monggoc anude. Ni yeneac sese dema sac naric mi hetinggebade nga kpacngina enacbibicnango naric mi kpacbade. ");
INSERT INTO ded_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","KEBU, geng wiac noboha nennec, imoc pakene isoc anu imoc mema nebade. Geng maridzominna garenggena imoc neac amma fekefude. ");
INSERT INTO ded_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Wiac mederema nemmegec, imohai neac maridzoming wiac gombungau heficgeu nenggec. Foracngoc, ni maridzominna imocac ubangerec negenduae. ");
INSERT INTO ded_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","KEBUNGO dederecge anemma sing edzacnuudeac kenehebade. Herenango tofocnac ifingoc edekpou anengande. ");
INSERT INTO ded_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Ni nasosoc kicna KEBUARU fikecduae. Yeng marifoinau kecdeac wiac mongngo menuu goroc goroc naric mi ambade. ");
INSERT INTO ded_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Imocac herenango ubangerec negemma ongana sogaiu sebina ifingoc ruaegoc anude. ");
INSERT INTO ded_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Geng ongana wana homec amau naric mi kemeude. Amma ge enac tofoc tofohongicga onggonggena kicsere naric mi henude. ");
INSERT INTO ded_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Geng kekecac sing kpounennec. Geac kicfu sogac sogai hafoangoc fede nga marifoigau ubangerec feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Dawidingo yofi numuec. O KEBU, ni dindingac amma ebicfu kecma yoac deduae, imocac yoacna negenna. Ni arohoma kpacguba ge yoacna negenna. Enacbibicna ikoha kpacngo numugemba ge kedzac kpema nunumuna negenna. ");
INSERT INTO ded_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ge yoacfu neac yoac faka dindingac modacma forana debesena nga geac kicngo faka dindingac hembeso. ");
INSERT INTO ded_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Foracngoc, ge tofonac yugucnuma tobangge herena hennegeng annadeu nearu mangana mong mi meficgenade. Enacnango yoac kopocsihagoc mong mi debadeac negenseriai. ");
INSERT INTO ded_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Ngic goa yeni faka angammemengina hania hania fede, fora. Nga ni sifu enacbibicgango yoac denec, imoc modacma garengemema yarengic yeneac sinnu mong mi kenai. ");
INSERT INTO ded_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ni serima geac sinnu tima kengha amma hanina mong mi tiposockeec. ");
INSERT INTO ded_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","O Anutu, geng nunumunaac turunga merennennadeac kpacguduae. Ge kedzacga nearu faima yoacna negenna. ");
INSERT INTO ded_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Geng yoac dedzege amma imoc modackecnec, wiac imoc bibiagoc andeac imoc edzacnuyombonggena. Ngicngac neni ngabafocnina yenearunac meickema sufunideac geac hoannu hani geng ebicfunac mesinununade. Nga ngaba yenearunac gearu hama marifoigau sufunide. ");
INSERT INTO ded_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Ge geangga kicga garenggeannec, ge ifi isoc ni garennuma kpeganggaac debannu fainuma mesufununa. ");
INSERT INTO ded_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Ngic goa yeni Anutu ngadehema mangana megecdeac ayemmeu kpetotienubeso andae. Nga ngaba yeni kpebucnugecdeac negemma oronnuma nandae, ge yenearunac mesufununa. ");
INSERT INTO ded_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Yeni herengina dzegegec yenearu ubamangang mong mi feyemmeu enacnginango yoackpekpe kpegecde. ");
INSERT INTO ded_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Yeni hanina modacma kisannuma meficnuma yaguc oronnuma nandae. Yeni kicngina kucgoc nearu fima bangecfu kpefacnubeso andae. ");
INSERT INTO ded_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Raiong yangtoango wiac kisamma sorienacngo sebia merecgeudeac ammiande nga raiong kuhagocngo sufu sufuu ngonducnema tomai feande, yeni ifi isoc andae. ");
INSERT INTO ded_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","O KEBU, ge yacma kemma ngabafocna kicnginau hama yunuma bangecfu ukuyununa. Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni menugecac dzikacbeanggango kekecna yeneac mariunac mesina. ");
INSERT INTO ded_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","O KEBU, ge geangga maringo bangecngic yenearunac mesinuna. Bangecngic yeni bangec yomohai kecma imocac wiac mekpedzuc amma mekecdae, yeni imocac areng. Ge yeneac negemma wiac faina fede, imocngo herengina mewakeude. Mewakeu medacfocngina yeneng wiac imoc monggoc nga monggoc mekecma nambaracfocngina yeneac negemma noboha faigec tarude. ");
INSERT INTO ded_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Anu ni dindingac kecma kicmesuga hemma gauunac gborima geac kicsiric hemba gunucnude. ");
INSERT INTO ded_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Yegecgareng yearu. KEBUNGO kingang ngiha Dawidi ngabafora sasawa yeneac maringinaunac mesima Sauroac kuc memama yearunac meickeu Dawidingo KEBU yegec yofi heimiec. O KEBU, ge neac kucna, ni geac songo negenduae. ");
INSERT INTO ded_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","KEBU ye neac hoc peperandzi seria, ye amana seria amma neac yungec yungecngic. Ye Anutuna nga neac hoc peperandzi seria anu ni yeac hoannu kemma sufuma kecbade. Ye kasona nga ye kuhagoc amma ebicfunac mesinuu yeac odaseriau kecbade. ");
INSERT INTO ded_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","KEBU eriendzong memini ngereeyombonggede. Ni ye kpacba yeng ngabafocna yeneac witicfunac mesinuude. ");
INSERT INTO ded_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Homecac witicngo fusenuu doku tunggbaungngo wegenac hama memanganenubeso anu kucna kpac anec. ");
INSERT INTO ded_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Nga homec amaac witicngo fusenuu homecac botacngo sinna hedzickegec. ");
INSERT INTO ded_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Ni ebicfu kecma Anutunango meficnuudeac kpacbare yeng womongau tacma ubaudumenna negemma kedzac kpema kiacna negenec. ");
INSERT INTO ded_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Yeng ngaba anecac bangecngo kockpac amma kpemindzaheu usoc meu tikiac titiseri yeni dendeng kpegec. ");
INSERT INTO ded_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Ye samaha singausing hosuc mau gerecngo enarausing erema wiac dzerecgeu kpac andarec. Hoc gerecyohoagocngo enaraunac ereu singsararang kpema kenggec. ");
INSERT INTO ded_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ye kurumenga kurumenga merarangyunuma hau kundungtoango hania bageau tarec. ");
INSERT INTO ded_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Ye kerobing witiau taru imocngo kpegangagoc kpututuckeu haec. Ye firanggac kpeganga witiau heima sawakebangau haec. ");
INSERT INTO ded_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Ye kundung mema imocngo kperacemema kiahoeng dzadzungo bedzoya amma oronggeu imocac manau tarec. ");
INSERT INTO ded_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Kibikperagingo waraimima hoeng mekperagiyunuu yeni yeac kicfu kenggec kia nomanggbomea kuneng amma mau hoc gerecyohoagocngo ifingoc hoeng manaunac maec. ");
INSERT INTO ded_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Nga nomanggbomeatoa nga hoc gerecyohoagocngo maec, imocac manaunac KEBUNGO kurumenga kurumenga, imohai tacma gbumparandang meficgeu haec. Kuctoa minginango yoac deu yeni enacudumenga negenggec. ");
INSERT INTO ded_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Ye tebe kperecgema tebemedac isoc kpesaiu ngabafora singsararang kpegec. Ye piratac kucnginagoc sing edzacyunuma faiu yeni sing imoc modacma kenggec. ");
INSERT INTO ded_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","O KEBU, geng yoac ngabasiric edeyunuma samacgausing asu fifina kucgoc erema kondungtoa meu dzikeu kperemenga fingectegeru henggec. Nga bangectoa bangecac titiseri imoc didiu faina henggec. ");
INSERT INTO ded_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Ye sawau tacma maria sinema menuma doku dzohong keme kemeaunac kpedzinuec. ");
INSERT INTO ded_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Neac ngabangic kuhagoc anu yeng yeac mariunac mesinuu ngic neac modzongina tiande, yeneac kucngo feracnuecac yeng yenearunac mesinuec. ");
INSERT INTO ded_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Naso manganango ebihagoc neac wegenac hau ngabafocna yeneng kicnau hama namma nubeso anggec KEBUNGO meserinuma mefinuec. ");
INSERT INTO ded_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Ye neac songo negenecac amma ebicfunac mesinuma sawea homac meficgenemma hesicnu kemma ihai fainuec. ");
INSERT INTO ded_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","KEBUNGO neac faka dindingac henec, imocacsoc faka gombunga anenec. Nga marinango faka kongaha angkefaiac ye imocac turunga merennemma wiac gombunga nenec. ");
INSERT INTO ded_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Ni Anutu wama faka mangana mong mi amma KEBUAC sing gombunga modacanduaengoc. ");
INSERT INTO ded_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Yeac dedesiyoac imoc sasawango kicnau feu ni nasosoc hemma yeac singyoac mong mi ngadehema wayai. ");
INSERT INTO ded_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Amma ni yeac hehennu kopocsic mong mi meficgeai, kpac. Ni kopocsic meficgebaiac fagung amma garengemekefai. ");
INSERT INTO ded_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Nga marinango faka kongaha angkefecac KEBUNGO neac faka angammeme dindingac hemma gombungaac turunga kpounenec. ");
INSERT INTO ded_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","O Kebu, ngic mongngo yoac modackefu ge yoacga modackecnec, imoc edzahanade. Nga mong ye kopocsic mong mi meficgeu geng kopocsic mong mi meficgeannec, imoc edzahana henude. ");
INSERT INTO ded_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Mong ye uba kongahagoc kefu geng ubaga kongaha, edzahenade. Nga mong ye fakaya heimeremma mangana modackefu ge ifingoc fakaga gombunga heimeremma mangana ammina henude. ");
INSERT INTO ded_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Geng ngicngac yumia ebicfunac mesiyununade. Nga ngic yenanggac negenggec wiac engena ande nga gamea kpac kecma kicngina miacandae, geng ine yeni memayununade. ");
INSERT INTO ded_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","KEBU Anutunango kundunna meickeu kperagia angkecde. Oc, gennoc kifana kpedzereckenade. ");
INSERT INTO ded_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","O, ge sing meficgenenna ngabahabu memayunubade. Anutunango kuc nenu odatoangina membarackema ferahabade. ");
INSERT INTO ded_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Anutu ye faka angammemea dindingac nga KEBUNGO yoac deserima deu fora fingerudenoc. Ngicngac yeneng yeac hoannu hama sufudacgec yeng kasongina amma mesufuyunuude. ");
INSERT INTO ded_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","KEBU ye mocgungo Anutu fora amma Anutunina mocgungo hoc peperandzi seria. ");
INSERT INTO ded_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Ngicngac wamba heigec kemeande, ifi isoc Anutungo kuc heinenu kemeu sing ebiha kpac meficgenenu gombunga kengkecbade. ");
INSERT INTO ded_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Yeng hanina mengereu kate yanggac haniherec isoc anu bic yombong nedzibade. Nga ye tikiu nambadeac kuc nenu naric mi manuude. ");
INSERT INTO ded_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Ye marina mengereu dzikacac negen negenggoc anduaeac tebe seria aiengngo memea, imoc naric taibade. ");
INSERT INTO ded_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ge ebicfunac mesinuna imocngo kasona angkecde. Ge marifoigango nanggenuna serima namba geng meficnuna ngickuneng anai. ");
INSERT INTO ded_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ni tiserima nambadeac geng tumiatoa meficgenenna haninango mong mi tiposockeec. ");
INSERT INTO ded_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Amma ni ngabafocna kisangyunuma meficyunuma memanganeyunuba kpac andacgec monggoc dzigeneai. ");
INSERT INTO ded_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Ni ngic yunuhomeai, yeni haninau makpema monggoc mi yacgec. ");
INSERT INTO ded_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Geng dzikac kpebadeac kuc heinemma ngabafocna neac bageau faiyununa mayunuu fegec. ");
INSERT INTO ded_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Nga ge ngabafocna faka ayemmena yeni ngadengina nearu meremma wanuma kenggec. Nga ngic yeneng neac modzongina tiu neng kpetotieyunuba kpac anggec. ");
INSERT INTO ded_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Yeni memeficac kiacgec nga ebicfunac mesiyunuudeac ngic mong ine mi tarec. Yeni KEBUNGO meficyunuudeac kiacgec yeng yoacngina mong mi merenec. ");
INSERT INTO ded_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Ni kpedzameyunuba yeni sendung firangngo mefiranggeande, ifi isoc anggec. Ni sinnu goteng isoc meicyunuma ngadeau ukuyunuai. ");
INSERT INTO ded_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Ngiha ngiha yeneng ngaba anenggec geng imohacnac mesinunec. Mesinuma sing meficgenenna bangec monnunac ngicngac yeneac garengtoa anai. Ni ngicngac areng goa mi negengyunuba yeneng neac bageu kecma kingang kpenenggec. ");
INSERT INTO ded_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Ngic yeni siducna negemma yoacna bic tofohogec kuricngic yeneng hama neac kicfu ngonducnema ewena heigec. ");
INSERT INTO ded_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Yeni kucngina mau dzonongngina fedeu amangina seria wama imohacnac mama hagec. ");
INSERT INTO ded_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","KEBU kecde. Neac hoc peperandzi seria, ye kenehebesonga. Anutu ebicfunac mesinuec, ye kpac kuneng mibesonga. ");
INSERT INTO ded_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Anutungo ebicna negemma turunga kpouyemmema ngiha ngiha neac bageu kecgecdeac faiyunuec. ");
INSERT INTO ded_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Oc, ye ngabafocna yeneac mariunac mesinuma kicnginau miacnuma kpac kuneng nenec. Ge yarengic kucnginagoc, yeneac mariunac mesinunec. ");
INSERT INTO ded_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Imocac bangec monnunac ngicngac botucnginau namma afegubade. O KEBU, ni yegec heima geac kpac kuneng heiwayong memibade. ");
INSERT INTO ded_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Yeng ngictauya faka ammiu dzikatoau firang angkefude. Ye ngic meisinggema kerec nadzicmiu yeng yeac ngictau anu yegoc kecma yoac dedzege anec, imoc modackefude. Yeng Dawidi meisinggema nasoya nasoya ye nga esangaboforagoc kecde nga kecengkefude. ");
INSERT INTO ded_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Yegecgareng yearu. Dawidingo yegec yofi heiec. Anutu ye kuc nga kibikperagiagoc, kurumenga kurumenga yeni siduc imoc dekperagikecdae nga sawango yeac marikibi deireckeude. ");
INSERT INTO ded_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Hadzing mongngo hadzing ogea yoac imoc edeu tofocnac mongngo tofocnac ogea imoc dedekperagi ammiude. ");
INSERT INTO ded_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Yeni yoacngina ning kpeu yoac mong mi dedae, fora. Ngic mongngo ubaudumengngina mi negenude. ");
INSERT INTO ded_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Nga ubaudumengngina imoc sifu bangectoa bangec, imohai kengkecde. Yeni yoacnginango bangec noboc noboc wisic wisickeau kendarude. Anutungo kurumenga kurumenga, imohai wenacac kporucbedzo mong faiu fede. ");
INSERT INTO ded_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Ye memeturang ngic mongngo memeturang ama manaunac ubangerecgoc maande, ifi isoc haude. Wenac ye nedzi nedzi ngic kuhagocngo firang anudeac sogac sogaigoc nedziande, ifi isoc hama ");
INSERT INTO ded_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","kurumenga kurumenga tegia monnusing erema singa modacma kemebesonga tegia nobocsing kemeude. Ye gerea yombong anu wiac mongngo yearu naric mi sufuude. ");
INSERT INTO ded_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","KEBUAC dedeseri imoc gombunga amma ngicngac ubaonganina heigboriude. Amma KEBUNGO yoac dekperagi nemmeude, imoc fora yombong amma ngic negen negentegecac obohoande, ye negen negentegec meficgemiude. ");
INSERT INTO ded_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","KEBUAC dederecgeyoac imoc dindingac amma sogac sogai hereninau meficgenemmeude. Amma KEBUAC nonoyoac imoc kongaha amma kicnina mekperagiude. ");
INSERT INTO ded_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","KEBUAC eweheiheigoc kekec imoc kongaha amma feengkefude. Nga KEBUNGO dederecgeyoac modacnideac faiec, imoc seria amma dindingac. ");
INSERT INTO ded_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Imoc gol ferahama gol tegeng momoc ferahaude. Amma imoc kukundzau songea ferahama songea yombong ande. Imoc kukundzau kpedzucneandimbe, imoc ferahayombonggeude. ");
INSERT INTO ded_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Dederecgeyoacgango kingang ngicga goroya kpeu ye imoc modackefu, imocngo ubangerec wiac engena miude. ");
INSERT INTO ded_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Ngic yengenaocngoc isingemema kopocsiha naric mi hentegerude, kpac. Kebu, ge kopocsicna sufu sufuya wana. ");
INSERT INTO ded_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Ni, kingang ngicgango kopocsicfaka goa yofi negemma mekecbai, “Faka imoc songea andeac angkecbadenoc.” Ni ifi amba geng sinna hedzickena kopocsicngo mi garennubeso. Ge ifi anna ni kopocsic mong mi meficgebade nga singyoac kpema faka mangana mi ambade. ");
INSERT INTO ded_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Nga enacbibicnaunac yoac nga negen negeng herenau fede, imoc negenna ngereebeso. O KEBU, gennoc neac hoc peperandzi seria nga ge bummenuma ebicfunac mesinunec. ");
INSERT INTO ded_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Yegecgareng yearu. Dawidingo mitiyegec yofi heiec. KEBUNGO ebicnasou yoacgaac turunga merenggembeso. Yakoboac Anutu, yeac kpac kunengngo ge onggonggubeso. ");
INSERT INTO ded_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Yeng womongaunac memefic suegenu Siong tikiunac heimefic anggema mang anggembeso. ");
INSERT INTO ded_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ge sese mema faiannec, yeng imoc sasawa negenu febeso nga sesegerecga ohoannec, imocac negenu ngereebeso. Selac ");
INSERT INTO ded_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Ge wiac monggac heresongoga anu ye wiac imoc gembeso nga geng areng sasawa faina yeng imocac fora meficgegembeso. ");
INSERT INTO ded_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Ge firang andanggac ubangerecac arohoma sogac sogai ambisina. Nenang Anutuninaac kpacfu firanggac ma kpedzini embeso. KEBUNGO kpesi kpesiga sasawa negemma foraya meficgebeso. ");
INSERT INTO ded_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","KEBUNGO ngictau meisinggema kerec nadzicmiec, ye ebicfunac mesiude, imoc yaguc negenduae. Ye kpetiac kurumengaunac yeac nunumuac turunga meremmima marifoiango faka kucgoc mema ye ebicfunac mesiu firang anude. ");
INSERT INTO ded_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Ngic goa yeni dzikacac keretac negenggec wiac engena anu yoac homac osogecde. Nga goa yeni becosiac negenggec wiac engena anu yoac homac osogecde. Nga nenang KEBU Anutuninaac kpac kuneng negenserima negenni wiac engena ande. ");
INSERT INTO ded_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Yeni kucngina kpac anu fafocnginango heima mayunuude. Nga nenang yacma hongngoc serima nannide. ");
INSERT INTO ded_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","O KEBU, ge ngictau meficgena firang ambeso. Neni kpacguni geng turunga merennemmena. ");
INSERT INTO ded_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Yegecgareng yearu. Dawidingo mitiyegec yofi heiec. O KEBU, ge kucgagoc, imocac ngictau ye geac ubangerec negenude. Nga geng ye meficgekecnecac ye firang amma homac yombong sogaima kecde. ");
INSERT INTO ded_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Hereau songo feec, ge imoc meficgemidang nga enacbibihango wiacac kpesigenu ge imoc sasawa mima mong mi wadang. Selac ");
INSERT INTO ded_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Geng ye heitaima kenecgaac finactoa mima ngictau ira gol tegengo memea oruhau fainec. ");
INSERT INTO ded_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Ye kekecac kpesigenu geng kekec mina nasoya nasoya fekengkefude. ");
INSERT INTO ded_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Nga ge mefickena ye firang amma feracyunuma kuc nga kibikperagitoagoc ande. Ge ngickunenggac kuc nga kibikperagi mina ye kunengngina fekefude. ");
INSERT INTO ded_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","O, kenecgango yegoc nasosoc feengkefude. Ge yegoc kecnecac ye ubangerec negemma sogaima kefude. ");
INSERT INTO ded_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Ngictau ye KEBU negenserima kecde. Kebu Engenatoango yoac dedzege amma imoc modacma kecandeac wiac mongngo ngictau meu goroc goroc naric mi anude. ");
INSERT INTO ded_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Ge marigango ngabafocga mendangyununade nga marifoigango ngic geac modzongina tiande, yeni meyunuude. ");
INSERT INTO ded_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Ge didiu fingectegecnade, naso imohai ngaba yeni ngic gerecfu manganeandae, ifi isoc kecgec gerecgango yonohoude. KEBUNGO herebu amma gbokoyunuu gerecngo yonohou kpac anggecde. ");
INSERT INTO ded_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ge yeneac esafocngina kpetotieyunuma bangecfunac meicyununade. Amma ge yeneac gborifocngina ngic medacfocngina botucnginaunac meicyununa kpac anggecde. ");
INSERT INTO ded_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Yeni mangana arenggema gubeso amma ge tobanggugecdeac sing mengeregecdeu uangina imoc naric mi fingerude. ");
INSERT INTO ded_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Ge tebega kicnginau kpesaina yeni dzigenema ngadeguma woragecde. ");
INSERT INTO ded_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","O KEBU kuctoagagoc, neni afeguma kuctoaga afehema yegec heinide. ");
INSERT INTO ded_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Yegecgareng yearu. Yegec yomoc yegec mong kpara Asoacac kebeseac, imocac uba modacma heibesonga. Dawidingo mitiyegec yofi heiec. Anutuna, Anutuna, ge ngadenuma wanudang, imoc naric mi ande. Ge neac hereau yombong kecma ebicfunac mi mesinunec, imoc mi ngereede. Ni asoring anenu kiacba ge nocac hereau namma yoacna mi negennec, ifi isoc ande. ");
INSERT INTO ded_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","O Anutuna, ni hadzing tofocnac kiacba turunga mi merennennec, ni waickema mong mi kecbade. ");
INSERT INTO ded_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Ge kpetiac, imoc fora. Israe neneng eriendzong megenni, imocngo ngictau tatacga anude. ");
INSERT INTO ded_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Bangecfocnina yeni warac negenseriguma kecgec. O, yeneng negenserigugec geng ebicfunac mesiyununec. ");
INSERT INTO ded_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Yeni kpacgugec geng ebicfunac mesiyununec. Yeni negenseriguma seria nanggec ubangina kuha mi maec. ");
INSERT INTO ded_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Anu ni ngic kpac, ni gususac. Ngic yeneng desofoc anenggec ngicngac yeni neac modzongina tide. ");
INSERT INTO ded_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Ngicngac sasawa yeni nemma detenic anemma nedzarang sinenemma orucngina kpatitickenemma yofi dedae, ");
INSERT INTO ded_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Ge ebicga KEBUAC mariu fainecac yeng ebicfunac mesigubeso. Ye geac songo negendeac ebicfunac mesigubeso.” ");
INSERT INTO ded_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","KEBU gennoc nonggo heremanaunac menuna fingecma sabacfu nenggacnaac namu nema febareng geng garennumana ruaegoc fekefai. ");
INSERT INTO ded_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Ni fingeraiunacngoc geac hoannu fainugec geac anai. Ni nonggo heremanau tacbareng kecma yaguc ge Anutuna kecnec. ");
INSERT INTO ded_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Ebicngo mewegenenuu mongngo mi meficnuudeac geng neac hereau mi kecbesena. ");
INSERT INTO ded_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Burumaka ngiwa homacngo oronnuma nandae. Basanggac burumaka ngiwa kucnginagocngo oronnuma nandae. ");
INSERT INTO ded_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Yeni mewegenenuma enacngina anggedae. Raiong yangtoa soringina nga enacnginango wiac mong merecgegecdeac kucgoc yombong arohoandae, yeni ifi isoc andae. ");
INSERT INTO ded_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Ngicngac yeneng doku bokonnunac kpakeandae, yeni ifi isoc ni kpakenugec kerengaiba sicna dzuhura sasawa fotockedacdac. Ni ubaherena kendokereha isoc amma herena manau sisingaima doku doku ande. ");
INSERT INTO ded_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Enang dzame dzameaac noboha kerenga fede, ni ifi isoc gbanggema kucna dzikema kpac andac. Nedzarannango kerengaima dumbennau mendanggeu ge homecac sendunnu fainuna feduae. ");
INSERT INTO ded_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Kasi yeneng oronnuma sinna tidzickecdae nga yarengic habunginagoc yeneng oronnuma nangkecdae. Yeni hanimarina nendanggedau. ");
INSERT INTO ded_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Sicna sasawa fingectegeru ni imoc osobadeacsoc anduae. Nga ngicngac yeneng kic nearu fiyombonggema ni ifi nemma negenggec ngereede. ");
INSERT INTO ded_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Yeni wambana botucnginau mederema ngakpina merang meudeac kpeing kpedae. ");
INSERT INTO ded_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","O KEBU, ge neac hereau mi kecna. O, neac memeficngic, ge bic hama meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Ge hama dzikacac beang, imohacnac mesinuna nga kekecna kasi yeneac kucfunac meickena. ");
INSERT INTO ded_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Ge raiong yangtoaac enacfunac mesinuna. O, geng kpacna negemma ubaongana ubaebicgoc kecde, imoc kate burumakaac baicfunac onggonggenecac ");
INSERT INTO ded_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","ni munafocna geac kpac kuneng dekperagiyemmema kpebung botucnginau namma ge eriendzong megembade. ");
INSERT INTO ded_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Ngicngac KEBU ewea heiandae, ngeni ye eriendzong memibisia. Nga Yakoboac gboricfora sasawa, ngeni ye afehebisia. Nga Israeac gboricfora sasawa, ngeni hemma yeac negenggec engena andeac kicngina yearu fima afehema nambisia. ");
INSERT INTO ded_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Ye ngic kpendzengagoc hemma kpendzengtoaac amma ye mi ngadeheec nga ubango mi waec. Ye kicmesuya yearunac mi mesufuec nga kiaru yeng kiara negenec. ");
INSERT INTO ded_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Geng oyang boyang ubanau faina ni habutoa yeneac botucfu namma ge eriendzong megembade. Nga ngic geac ewega heiandae, yeneac kicfu namma dedeserinaac turung kpoudacbade. ");
INSERT INTO ded_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Ngicngac makpekpea yeni nema gebecyunuude nga ngicngac KEBU hofocandae, yeneng ye dengeregecde. O, ngeni herengina nasoya nasoya fekecbeso. ");
INSERT INTO ded_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Bangec tegiaunac ngiha ngiha yeneng yeac negemma ubangina dzigeneu KEBUARU kenggecde. Nga ngiha ngiha yeni sasawango tosofocnginagoc hama yeac kicfu ngonducnema numumigecde. ");
INSERT INTO ded_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","KEBU, kuc minginango bangec monnunac ngicngac garengyunuude. ");
INSERT INTO ded_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","O, bangecac ngicngac yeni yenanggac ngenggec wiac engena ande, yeni sasawango yeac kicfu ngonducnegecde. Yeni sasawango yeac kicfu ngonducnema bangecfu sendunnu kenggecde. Ngic yeni kekecngina garenggegecdeacsoc mi amma homedacgecde, yeni yeac kicfu ngonducnegecde. ");
INSERT INTO ded_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Bangecfocngina ngade hagecde, yeneng kingang kpemigecde. Ngicareng ngade fingecgecde, yenemma Kebuac kpacsiduc dekperagiyemmegec negenggecde. ");
INSERT INTO ded_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Yeneng yeac fakaya dindingac, imoc ngicngac areng ngade fingecgecde, yeni edeyunugecde. Ye uaya ifi mesiec, imoc edeyunugecde. ");
INSERT INTO ded_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Dawidingo mitiyegec yofi heiec. KEBU ye neac gareng. Ramagarengngo ramafora garengyunuande, ye ifi isoc nenggareng anenu wiac monggac naric mi obohobade. ");
INSERT INTO ded_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Ye maneng kpindzing sabayagoc fede, ihai fainuu febade nga doku tegiau hesicnuu ruaegoc kecnegeng ambade. ");
INSERT INTO ded_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ye ubaongana mengerema kuc gboria monggoc nenude. Amma ye yengena kparaac amma sing dindingacfu hesicnuu imohai kengkecbade. ");
INSERT INTO ded_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Nga ni homecac kperemennu kemema kundung kundunnu kembadeu wiac mangana fingeru imocngo kengec naric mi meficgenenude, nocac Kebu gennoc nigoc kecnec. Geac dzikac nga yasungo meserinuecde. ");
INSERT INTO ded_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ge ngabafocna kicnginau yombong yakana mengerena neba kerecdokungo orucnau nadzicnenna sebinango ireckeude. Ge neac kpakenec mewakeyombonggena tosea ngadeau maude. ");
INSERT INTO ded_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ge faka gombunga anennade. Foracngoc, geng yoac dedzege amma imoc modackecnec nga fakaga imocngo hesicnuma kekecnaac uameme sasawau hesicnunadengoc. Nga ni KEBUAC amau erema ihai nasoya nasoya kecengkecbade. ");
INSERT INTO ded_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Dawidingo mitiyegec yofi heiec. Bangeha bangeha nga wiac sasawa bangecfu fede, imoc KEBUAC. Bangectoa bangec nga ngiha ngiha imocac witiau kecdae, yeni sasawa yeac. ");
INSERT INTO ded_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Yennoc bangec meficgema imoc kondungdoku nga dokutoa witinginau faiu seria fede. ");
INSERT INTO ded_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Ngic merang KEBUAC tikiu naric enude nga merang yeac ama kpetiacfu naric nanude? ");
INSERT INTO ded_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Mong ye maria nga herea kongaha kecande nga nemuonga mi afeheude amma ikoc mi amma yoac mong mi deserima deude, ");
INSERT INTO ded_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","ye ifi kecmanu KEBUNGO ye keneheu Anutu ebicfunac mesimesi minginango ye ngic dindingac demiude. ");
INSERT INTO ded_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Ngicareng Anutu hofocandae, yeni siricngina ifi. Yeni Yakoboac Anutu, yeac kicfu nambeso ayemmede. Selac ");
INSERT INTO ded_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Nagutoa ngeni hereema witigec. Nagu feengkecdae, ngeni kuc nga kibikperagiaac ngictaungo ereudeac hereema kunengngoc witigec. ");
INSERT INTO ded_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Nga kuc nga kibikperagiaac ngictau imoc merac? Ye KEBU kuctoa mingina amma KEBU yennoc dzikacfu firang angkecde. ");
INSERT INTO ded_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Nagutoa ngeni hereema witigec. Nagu feengkecdae, ngeni kuc nga kibikperagiaac ngictaungo ereudeac hereema kunengngoc witigec. ");
INSERT INTO ded_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Nga kuc nga kibikperagiaac ngictau imoc merac? Ye KEBU wasai habuya habuya yeneac kunengngina, yennoc kuc nga kibikperagiaac ngictau. Selac ");
INSERT INTO ded_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Dawidingo yegec yofi heiec. OKEBUNA, ubaongana miacma gearu faiba hade. ");
INSERT INTO ded_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","O Anutuna, ni negenseriguma kecduae. Ngic yeneng game kpekpeu fainubauac geng kpae heiyemmebesena. Ngabafocna yeneng ebicnaac sogaima dedzomoc anembauac kpae heiyemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Oc, ngic mong ye ge negensingguma tomai kefu yeneng desofoc ammibauac kpae heiyemmebesena. Nga ngicngac goa ikoc ayemmegecdeac areng faiandae, yeni ine game kpekpeu faiyunubesena. ");
INSERT INTO ded_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","O KEBU, ge singga edzacnuma hanisingga kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Anutu ge neac ebicfunac mesi mesingic. Ge imocac yoacga forau hesicnuma faka fora edekpou anenna. Ni asoac kemma marai geac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","O KEBU, ge wosoefacgagoc nga geng yoac dedzege amma imoc modackecnec, imocnoc hanac hanaheaunacngoc feec amma fehakecde, imoc negensina. ");
INSERT INTO ded_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","O KEBU, ge gombunga. Amma yoac dedzege amma imoc modackecnec, imocac neac negenna febeso. Ni ngicmedac kecma singyoac kpekecma kopocsic meficgeai, ge imoc ine mi negenna febeso. ");
INSERT INTO ded_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","KEBU ye gombunga, ye dindingac yombong. Ye imocac ngicngac kopocsicgoc kecdae, yeni yengena sing edekpou ayemmeude. ");
INSERT INTO ded_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Ye ngicngac yumia faka dindingac modacma hesicyunuma yengena sing edekpou ayemmeude. ");
INSERT INTO ded_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Ngicngac KEBUAC dzadzahac nga dedekperagiyoac modacandae, yeni KEBU hemma yofi negenggecde, ye yoac modac modac Kebu. Amma ye yoac dedzege amma imoc modackefude. ");
INSERT INTO ded_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","O KEBU, ni kopocsic ebira yombong meficgeaiac kpac kunenggaac amma imoc sifu wana. ");
INSERT INTO ded_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Ngic mong ye KEBUAC ewea heikecde, ngic ifia ye merac? KEBUNGO yenoc sing edekpou ammiu ngic ye sing imoc meisinggema modacbeso. ");
INSERT INTO ded_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Amma ngic imoc ye kekeha ngereeu wiac monggac mi obohoude nga yeac esamedacfora yeni maridzoming dema bangec mema mingina anggecde. ");
INSERT INTO ded_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Nga ngic KEBUAC ewea heikecdae, yeneng yeac ogofora anggecde. Ye yengena dzadzahac dekperagiyemmeu yeni imoc negentegecgecde. ");
INSERT INTO ded_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","KEBUNGO hanina uficfunac mesiudeac meficnuudeac negeung amma kicna nasosoc yearu fikecbade. ");
INSERT INTO ded_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","KEBU, ni tembucna amma ebicgoc kecduaeac neacnec wosoefac anemma dzigenema nearu monggoc hana. ");
INSERT INTO ded_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Ni ebicna herenau fede, imoc monggoc yadide. Ge ubaebicfunac mesinuma ebicna sasawa meickena. ");
INSERT INTO ded_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Ge kpendzenna nga hereebicna negensima kopocsicna wadacna. ");
INSERT INTO ded_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Neac ngabangic yeni homac amma yeni ngabatoanginangoc amma ngadenuandae, imoc negensina. ");
INSERT INTO ded_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","O, ni geac hoannu hama sufubadeac kekecna onggonggema ebicfunac mesinuna. Nga ngic yeneng desofoc anembauac ge kpae heiyemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Ni geac tomai kecduaeac dindingac kecma kopocsic mong mi meficgeanduae amma ikoc nga hamangecna kpac kecanduaeac faka imocngo onggonnubeso. ");
INSERT INTO ded_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O Anutu, ge Israe ngicngac bummenunuma ebicfunac mesinunudacna. ");
INSERT INTO ded_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Dawidingo yegec yofi heiec. O KEBU, ni dindingac kecma kopocsic mong mi meficgeaiac nanggenuna yoacfu firang ambesare. Ni seria namma KEBU negenserima kecanduae. ");
INSERT INTO ded_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","O KEBU, geng faitobannu fainuma kekecna isinggema ubaherena ifingoc isinggema henna. ");
INSERT INTO ded_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Ge yoac dedzege amma imoc modackecnec, imoc hemma geac yoac tofohoma kecbade. ");
INSERT INTO ded_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ni ikocngic yenigoc naric mi kecbade nga ngic manganangina gombunga bageau mesufuandae, yenigoc naric mi kecbade. ");
INSERT INTO ded_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Ni yarengic yenigoc naric mi kecbade nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yenigoc naric mi tacbade. ");
INSERT INTO ded_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","O KEBU, ni kopocsic mong mi meficgema marina dzuacba kongac kpeu arataga wegenacfu yerecgebade. ");
INSERT INTO ded_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Ni ubana miacma ubangerec megemma kucfakaga wiac engena negemma dekperagiba negenggecde. ");
INSERT INTO ded_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","O KEBU, ge amagerecgau kuc nga kibikperagigagoc kecnec, ama imocac songo negenduae. ");
INSERT INTO ded_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Ge kopocsicmeme meicyununade, naso imohai ni yenigoc mi meicnuna. Nga ngic goa yeneng ngicngac ogofocngina yeneac sac hetinggegecdeac ayemmeande, ge meicyunuma neac kekec yenigoc mi meickebesena. ");
INSERT INTO ded_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Ngic imoc yeni maringinau yarefaka anggecdeac wiac megecde nga marifoinginau hiedzo mema benukerere faka megec wakeude. ");
INSERT INTO ded_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Ni neannaoc dindingac kecma kopocsic mong mi meficgekefai. Ge imocac wosoefac anemma ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Haninango bangec sorongau tima nambade nga habutoa yeneac kicfu KEBU kenehebade. ");
INSERT INTO ded_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Dawidingo yegec yofi heiec. KEBU ye neac kperagi nga memengerec, ni wiac monggac kengec naric mi ambade. Ye sufu sufuamana amma ye kekecna onggonggema kecdeac monggac kengec mi ambade. ");
INSERT INTO ded_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Yarengic yeneng wegenac hama gbokocnubesonga andae amma ngabafocna ogofocnginagoc wegenac hama tifainggema mayunuude. ");
INSERT INTO ded_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Wasai ngic habutoagoc hama nugecdeac bedzongina mema oronnugecdeu ni naric mi kengecnuude. Yeni nugecdeac dzikac kpegecdeu ni negengyohocna kpac kecma seria nambade. ");
INSERT INTO ded_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ni wiac mocgu imocac KEBU numumima dekpesi ammima imoc hofockecduae, imoc yofi, ni KEBUAC amau nasosoc tacyac amba kekecnasona wisickebeso. Ni yeac siriha gombunga yombong, imoc hemma yeac womonnu ye hembadeac anende. ");
INSERT INTO ded_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Ye ebicnasou yengena oda manau onggonnuude. Ye kporucbedzoyau mesufunuma wi hoc peperandzi seriau fainuu gombunga kecbade. ");
INSERT INTO ded_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Ye orucna miaru ngabafocna oronnudae, yeni feracyunuma wi namma yenembade. Ni sogaima ubangerec negemma Anutu womongau sese faimima sogac sogaiac yegec heima KEBU yaiyo kpemibade. ");
INSERT INTO ded_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","O KEBU, ni kunengngoc kiacba ge negennemma neac ubaga manganeu turunga merennenna. ");
INSERT INTO ded_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Geng yofi denec, “Ge neac kicmesu hennadeac anggembeso.” Ge ifi dena herenango meremma dede, “O KEBU, ni geac kicmesuga hembeso anende.” ");
INSERT INTO ded_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","O Anutu, ge ebicfunac mesinunade nga ni geac kingang ngicga. Ge kicmesuga nearunac mi mesufuna nga ngaba amma mi meicnuna. Ge meficnukecnecac mi ukununa. Ge ni mi ngadenuma wanuna. ");
INSERT INTO ded_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Nonggo manna yereng ngadenuma wanuec KEBUNGO ine heitainuma nenggareng anenude. ");
INSERT INTO ded_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","O KEBU, ngabafocna memanubeso ayemmedeac singga kpounemma sing sorongau hesicnuma kenna. ");
INSERT INTO ded_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Ngic goa yeni enacnginaunac yareasu ereande, yeni yoacfu yacma neac yoac ikoha degecde. Ge yeneac songo mi modacna nga yeneac mariu mi fainuna. ");
INSERT INTO ded_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ni ngicngac gbori kecdae, yeneac bangecfu KEBUAC kekec nga angammeme gombunga hembade, imoc negensinggeduae. ");
INSERT INTO ded_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Ge KEBUAC tomai kecma seria nambesena. Heregango efaima kucgoc ambeso. Oc, ge KEBUAC tomai kecbesena. ");
INSERT INTO ded_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Dawidingo yegec yofi heiec. O KEBU, ge neac hoc peperandzi seria, ni kpacguduae. Ge kedzacga mi kpefonggena. Ge yoacga waickenadeu ni ngic homecamau kendae, yeni isoc ambade. ");
INSERT INTO ded_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Ni kpesi kpesi gearu hama kiacba ge ubaudumenna negenna. Ni kicna kpetiac womonggaugeng fima marina miacba geng meficnunadeac numubade. ");
INSERT INTO ded_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Ngic Anutu ngadehema mangana megecdeac ayemmeande nga yarengic amma ngic enacnginango ruae dema herenginango ine tobangyunugecdeac mangana arenggeandae, meicyununade, imohai ni yenigoc mi meicnuna. ");
INSERT INTO ded_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Yeni fakangina mangana anggec nga megec, imocac turunga merengyemmena. Nga yeni mangana maringinango megec, ge imocac siricfu turunga yemmena. ");
INSERT INTO ded_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","KEBUNGO ua mekecde nga mariango wiac meficgekecde, yeni imoc hemma wama mi negensiandaeac yeng kpedzameyunuma monggoc mi nanggeyunuude. ");
INSERT INTO ded_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","KEBUNGO neac kiac udumeng negendacac kenehebade. ");
INSERT INTO ded_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","KEBU ye kucna nga kasona anu herenango ye negenserima kefude. Ye meficnuu herenango sogaiu ubangerecac yegec heimibade. ");
INSERT INTO ded_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","KEBU ye ngicngacfora yeneac kucngina. Ye ngiha meisinggema kerec nadzimima yeac sufu sufuamea amma ebicfunac mesiude. ");
INSERT INTO ded_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","O, ge ngicngacfocga ebicfunac mesiyununa amma maridzoming ngicngacfocga andae, yeni kenecyunuma yenenggareng ayemmema nasoya nasoya tofohoyunubesena. ");
INSERT INTO ded_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Dawidingo yegec yofi heiec. O, anutu hania hania yeneac medacfocngina kucnginagoc kurumennu kecdae, ngeni KEBU eriendzong memibisia. Amma ngeni KEBUAC kuc kibikperagiagoc negensima eweheihei ammibisia. ");
INSERT INTO ded_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Ngeni KEBUAC kpara eweheiheigoc heiwayong memibisia. KEBU ye kpetiac, imocac ngeni ngonducnema numumibisia. ");
INSERT INTO ded_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","KEBUAC ubaudumeng imoc doku witinginau fingerude. Anutu kuc nga kibikperagia minginango kondungtoa witiau gbururung amma heiude. ");
INSERT INTO ded_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","KEBUAC ubaudumeng imoc kuhagoc yombong. KEBUAC ubaudumeng imoc ngictauac ubaudumeng ande. ");
INSERT INTO ded_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","KEBUAC ubaudumengngo yomondzoc ic kpetackeude. KEBUNGO Rebanong bangecac yomondzoc ic kpedzameyunuude. ");
INSERT INTO ded_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Yeng Rebanong bangec yoac edeu ye burumaka medaha isoc yuude nga Siriong bangec ye burumaka ngiwa isoc yuude. ");
INSERT INTO ded_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","KEBUAC ubaudumengngo gerecborang meficgema ukuyunuu singsararang kpegecde. ");
INSERT INTO ded_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","KEBUAC ubaudumengngo bangec kisiu fingeru imocngo dzonoma fedeude. KEBUNGO Kadesi bangec kisi kpemindzaheude. ");
INSERT INTO ded_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","KEBUAC ubaudumengngo kateburumaka yoac edeyunuu medacfocngina fingecgecde. Yeng ic maria kpemoronggedarude. Yeac womonnu yofi dema arohodacgecde, “KEBU eweheiheiagoc dengereni.” ");
INSERT INTO ded_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","KEBUNGO ngictau tatahau dokutunggbaung witiau tacde. Ye ngictau tatacfu tacma ngictau nasosoc kecengkefude. ");
INSERT INTO ded_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","KEBUNGO ngicngacfora kuc nemmema kenecnunuu ruaegoc kecbisina. ");
INSERT INTO ded_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Dawidingo womong desi desinasoac mitiyegec yofi heiec. KEBU ge keme kemeaunac tainuna ereduaac afegubade. Geng ngabafocna kpae heiyemmena yeneng neac amma ubangerec mi meficgebisia. ");
INSERT INTO ded_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O KEBU, Anutuna, ni gearu memeficac kiacma numuba geng mengerenunec. ");
INSERT INTO ded_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","O KEBU, ge homec amaunac menunec. Nga tennu keme kemeac arennu tacbareng geng menuma kekecna homecfu kemegecde, yeneac arennunac mesinunec. ");
INSERT INTO ded_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","O, KEBUAC ngicngac kpetiac, ngeni ye dengerema yegec heibisia. Ngeni yeac kpara kpetiac heiwayong memibisia. ");
INSERT INTO ded_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Ye ngabaya naso wegenanec mekefude nga fakaya gombunga imoc kekecninau sasawa fekefudengoc. Ge tofocnac kiacade nga asoac sogac sogai meficgenade. ");
INSERT INTO ded_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Ni naric kecma wiac monggac mi obohoai, imohai yofi deai, “Ni seria nanduaeac wiac mongngo nuu goroc goroc naric mi ambade.” ");
INSERT INTO ded_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Nga ge kicga nearu sufuna ine kengecngo memanuec. O KEBU, gennoc faka gombunga anemma tatacnau fainuna tiki seria isoc seria yombong nanai. ");
INSERT INTO ded_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","O KEBU, ni kpacguma kpesi kpesi amba negennennadeac yofi numugenai, ");
INSERT INTO ded_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“KEBU, ni homema homecamau kemebadeu wiac mong naric mi gembac. Bangecac sendungngo ge naric mi dengereguude nga ge yoac modac modac Kebu, imoc naric mi dekperagiude. ");
INSERT INTO ded_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","O KEBU, geng negennemma ubamangang anenna, o KEBU, ge meficnuna.” ");
INSERT INTO ded_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Geng ubaebicna heimerenna yegec fededuae nga songgonggac wamba heikefai, ge imoc meickema sogac sogaiac wamba heinenna kemeec. ");
INSERT INTO ded_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Ge ifi anna ni waicke monggoc mi kecbade. Herenango yegec heima eweheiheigoc afegubade, o KEBU, Anutuna, ni nasoya nasoya ge eriendzong megembade. ");
INSERT INTO ded_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Yegecgareng yearu. Dawidingo yegec yofi heiec. O KEBU, ni gearu hama sufubeso anduae. Ngicngac yeneng game kpekpeu fainubauac kpae heiyemmedacna. Ge dindingac, imocac ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ge kedzacga nearu faima nearu bic hama ebicfunac mesinuna. Ge neac hoc peperandzi seria anna imohai hama sufubade. Ge amana seria amma ebicfunac mesinubesena. ");
INSERT INTO ded_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Foranoc, ge neac hoc peperandzi nga amana seria. Ge kpac kunenggaac amma hesicnuma singga edzacnuna. ");
INSERT INTO ded_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ge neac sufu sufuama annecac ngic yeni ufic sufu sufuu faigec mendannuu, geng imohacnac yungecnuna. ");
INSERT INTO ded_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Ni asuna marigau faiduae. O KEBU, yoac modac modac Anutuna, geng bummenuma ebicfunac mesinunec. ");
INSERT INTO ded_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Ngicngac yeneng nemuonga ikocnginagoc hoangyunuma eweheihei ayemmeandae, ni ine yeni ubango wayunuma KEBU negenserima kecbade. ");
INSERT INTO ded_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Geng kpendzenna hengkecnec nga geng yoac dedzege amma imoc modackecnec, imocac ubangerec negemma sogaibade. ");
INSERT INTO ded_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ge ngabafocna yeneac mariu mi fainuma sawea homac meficgenenna haninango naric tima nambade. ");
INSERT INTO ded_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","O KEBU, ni ubaebicgoc kecduaeac amma ge neac ubaga manganeu. Ni ubahodunnagoc kecba kicna ngopic ande nga ongasebinango undzang kpema kecduae. ");
INSERT INTO ded_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Kekecna ubahodunggoc kefai nga asoringa anenu kifana kengkefec. Ni ngicngac memanganeyunukefaiac amma kucna kpac anu sicnango kucmama amma kpac ambeso ande. ");
INSERT INTO ded_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Ngabafocna sasawa yeneng desofoc anenggecde. Nga ngicngac nigoc wegenac kecandae, yeni neac modzongina tiu wanugec ogofocna yeneng sinnu meficnuma nemma woragecde. ");
INSERT INTO ded_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Ngic ogofocngina homegec ngicngac yeneng yeneac nigecyunuande, yeni ifi isoc neac nigecyunuec. Enang mong tohou ngic yeneng imoc ukuandae, ni ifi isoc anduae. ");
INSERT INTO ded_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Ngicngac homacngo neac dengunuc kpengunuc anengkecdae imoc negenduae. Ni noboc noboc kemma kengectoa amma kpidohoba yeni nugecdeac yoac dedzege amma kpebucnugecdeac yoac dzegedae. ");
INSERT INTO ded_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","O KEBU, ni negenseriguma yoac yofi deba, “Ge Anutuna.” ");
INSERT INTO ded_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Neac naso imoc geac mariu fede. Ge ngabafocna nukporac anendae, yeneac mariunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Ni geac kingang ngicga, imocac kicmesugango nerarannuna. Geng yoac dedzege amma imoc modackecnecac ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","O KEBU, ni kpacguduaeac negennnenna. Ngaba yeneng game kpekpeu fainubauac ge kpae heiyemmena. Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni ine game kpekpeu faiyunubesonga nga yeni yoacngina kpac amma homecamau kemebisia. ");
INSERT INTO ded_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Nga ngicngac enacbibicnginango ikoc angandae, ge yeneac enac medzickena. Ngic yeni yenanaggac negenggec engena anu ngic ogofocngina dindinga ngadeyunuma yeneac ubakpekpeyoac deandae, ge ngic imoc yeneac enac medzickena. ");
INSERT INTO ded_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Ngicngac ge eweheihei anggendae, yeni gombungagango garengyunuannec. Nga ngicngac neneng geac hoannu hama sufuni geng ngicngac sasawa yeneac kicfu gombungaga meficnununade, fakaga gombunga imoc homac yombong kpac. ");
INSERT INTO ded_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Ge kasonina anna ngicngac yeneng memanganenunugecdeac arenggegec geng mesufununuannec. Ge kasonina amma hoangnununa ngic mangana yeneac yoac manganango naric mi memanganenunuude. ");
INSERT INTO ded_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","KEBU kenehebesonga. Ngaba yeneng taongtoa hedzickeandae, yeni ifi isoc sinna hedzikegec imohai Kebu yoac dedzege amma imoc modackecde, yeng wiac engena mema garennuec. ");
INSERT INTO ded_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Foracngoc, ni kengec amma yofi deai, “Yeni kicgaunac meicnuma hereau fainugec.” Nga ni kpesi kpesi amma meficnunadeac kiacba gennoc kiacna negennec. ");
INSERT INTO ded_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","KEBUAC kpetiac ngicngac sasawa, ngeni ye songogoc hoanggebisia. Yeng ngicngac yeac yoac modacandae, yeni onggongyunuude. Ngic yeni yenanggac negenggec wiac engena anu angammeme hania hania angandae, imohai yeng turunga mangana efea kpac merengyemmeude. ");
INSERT INTO ded_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","KEBUAC tomai kecandae, ngeni herengina meserima serima nandacbisia. ");
INSERT INTO ded_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Yegec yomoc masiki uba modacma heibesonga. Dawidingo yegec yofi heiec. Ngic mong ye singyoac kpeu Kebungo ebiha wamima kopocsihaac ebic semeec, ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Ngic mong ye ngicngac ogofora memanganeyunuu KEBUNGO kopocsiha wau kpac andac deande nga ngic mong ye asuyau ikoc mong mi fede, ngic imoc ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Ni kopocsicna mi deficgema waba feu asoacnac kemma marai asoringa anenu mi wisickemanu kecbare sebina kpac ambeso anec. Wenac nasou wiac kerenga amma moronggeande, ni kucna ifi isoc kpac anec. ");
INSERT INTO ded_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Ge marigango hadzing toforec merandzinukecnecac wenacngo kpeu bangec gbanggeande, kucna ifi isoc gbanggema kpac ambeso anec. Selac ");
INSERT INTO ded_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Anu ni kopocsicna gearu deficgeai. Ni kopocsicna mi semema yofi deai, “Ni singyoac kpekefai, imoc KEBUARU deficgebade.” ifi deba geng kopocsicna wama ubamanganna meickena kpac anec. Selac ");
INSERT INTO ded_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Anutuac enac tofoc tofohongic yeni ebic fingecyemmeu yeneng gearu numubisia. Numugec ebic kuneng me doku tunggbaungngo naric mi kpesereyunuude. ");
INSERT INTO ded_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ge neac sufu sufuama. Ebicngo memanubeso anu geng onggonnuna ebicngo naric mi memanganenuu geng sogac sogaiac aro kunengngo oronnunade. Selac ");
INSERT INTO ded_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","KEBUNGO deec, “Ge singga tinade, imoc edekpou anggemba, imoc modacbesena. Kicnango modacguma dederecgeyoac anggembade. ");
INSERT INTO ded_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Becosic nga donggi yeni negen negengngina kpac kecdae. Ge yeni isoc mi ambesena. Yeni dumbengnginau witic kpena kemeu, imohai yoacga modacgecde nga witiha kpacngo geac wegenac naric mi hagecde.” ");
INSERT INTO ded_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Ngicngac Anutu ngadehema mangana megecdeac ayemmeande, yeni ebic homac meficgema mayunuude. Nga ngicngac yeni KEBU negenserima kecgec KEBUNGO yoac dedzege amma imoc modarude. Nga yeac faka imocngo orongyunuude. ");
INSERT INTO ded_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","O ngicngac dindingac, ngeni sasawango sogaima KEBU dengerebisia. Ngicwiac herenginau ikoc nga hamangec mong mi fede, ngeni sasawango sogaima dendzerenggema arohobisia. ");
INSERT INTO ded_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","O ngicngac dindingac, ngeni KEBUAC amma sogaibisia. Ngicngac ngeni ikoc nga hamangecngina kpac kecdae, ngeni ye eriendzong memigec ngereede. ");
INSERT INTO ded_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Ngeni kurerengo KEBU dengerema gita witiha 10 kpema yeac musi gombunga kpebisia. ");
INSERT INTO ded_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Ngeni yeac yegec gboria heimibisia. Ngeni gita mengerema kpegec musi gombunga fingeru dendzerenggema yegec heibisia. ");
INSERT INTO ded_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","KEBUAC yoacfu ikoc nga hamangec mong mi fede, kpac. Ye yoac dema imoc modacma uaya sasawa mekecma mesiude. ");
INSERT INTO ded_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","KEBUNGO dindingac kekec nga sing dindingac modac modac fakaac songo negenude. KEBUNGO yoac dedzege amma imoc modackecde, yeac faka imocngo bangec sokoma fede. ");
INSERT INTO ded_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","KEBUNGO yoac dema kurumenga kurumenga meficyunuec. Ye enacasuyango wenac nga afo amma asomeng habutoanginagoc meficyunuec. ");
INSERT INTO ded_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Ngicngac yeni doku kirunnu faiandae, yeng ifi isoc kondunggac doku kpedzucyunuu mocgu anggec amma kondung keme kemea dokunginagoc amangina mengerema tatacnginau faiyunuec. ");
INSERT INTO ded_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Bangectoa bangecngo KEBU ewea heimibeso nga bangectoa bangecac ngicngac, ngeni sasawango hemma yeac negenggec engena ambeso. ");
INSERT INTO ded_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Yeng yoac enacngo deu wiac imoc fingerec. Nga fingecgec deu imohaingoc wiac sasawa fingecdacma seria feec. ");
INSERT INTO ded_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Bangec monnunac ngicngac Anutu mi negemmidae, yeneng negen negengngina arenggegec KEBUNGO imoc meu kemma kpac anude. Nga ngiha ngiha yeneng ua mong mebesonga arenggegec yeng singngina hedzickeu imoc naric mi megecde. ");
INSERT INTO ded_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Nga KEBUNGO wiac mong mebesonga negenude, wiac imocngo nasosoc fefeseri feengkefude. Yeac hereaac negen negeng, imongo fingecsahenina fekecdesoc, imohai feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Bangecareng mong yeni Anutungina KEBU yeni kenecnginagoc. Ye yengena areng meisingyunuu yeac maridzoming areng anggec. ");
INSERT INTO ded_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","KEBUNGO kurumennunac kiwa fiu mau bangecngicngac sasawa yenendarude. ");
INSERT INTO ded_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ye ngictau tatahau tacma kiwa bangecac ngicngac yenearu fima nenendacma ");
INSERT INTO ded_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","ngicngac neneac woubocninaac siriha dema meficgedaru faka angammemenina sasawa hennegeng anude. ");
INSERT INTO ded_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ngictau ye yengena wasai ngichabu yeneac kucfu dzikacfu firang naric mi anude nga wasaingic ye yengena kucfu ngaba yeneac mariunac naric mi woraude. ");
INSERT INTO ded_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Dzikacac becosicac kucfu dzikacfu firang angandae anu negen negeng imocngo fora mi ande. Nga becosic kuctoanginagocngo ngaba yeneac mariunac naric mi mesiyunugecde. ");
INSERT INTO ded_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Foracngoc, ngicngac yeneng KEBUAC ewea heiandae, Kebungo yeni kiwango yenenude. Yeng yoac dedzege amma imoc modackefude nga ngicngac yeneng imoc negensima fora fingerudeac tomai kecandae, ye kiwango yeninoc yenenude. ");
INSERT INTO ded_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Yeng yenenggareng ayemmema homecfunac mesiyunuude. Ye bodi nasou yakaac garengyunuu kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","KEBU ye memefic nga kasonina nga wiac fingerudeac ubaonganinango yeac tomai kecde. ");
INSERT INTO ded_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Neni yeac kpara kpetiac negenserima kecnideac hereninango yearu sogaima kecde. ");
INSERT INTO ded_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","O KEBU, geng yoac dedzege amma imoc modackecnecac hoannunubesena. Neni ge negensingguma tomai kecni fora fingecbeso. ");
INSERT INTO ded_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Dawidingo Abimerecac kicfu fingecma ikoc amma uba sufu sufungic isoc anu Abimerecngo ye kporaru mama worama yegec yofi heiec. Ni nasosoc KEBU keneheba, yeac dedengerecngo neac enacbibicfu nasosoc fekefude. ");
INSERT INTO ded_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Ubaonganango KEBUAC negenu wiac engena anu ye dengereba. Ngicngac makpekpea yeneng imoc negemma sogaibisia. ");
INSERT INTO ded_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","O, ngeni nigoc KEBU kpac kuneng mima nenahafoc yeac kpac kuneng heiwayong memini. ");
INSERT INTO ded_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Ni KEBUNGO meficnuudeac ye hofocba yeng kengecna meickema ebicfunac mesinuec. ");
INSERT INTO ded_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Ngicngac neni kicnina yearu fini sogac sogaiac kperagingo kicmesunina mekperagiu kperagigoc annide nga kicmesunina gameagoc amma sacsac naric mi kpeude. ");
INSERT INTO ded_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Ni ngic makpekpeango kiacba KEBUNGO neac kpakpac negemma ebicfunac mesinudarec. ");
INSERT INTO ded_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Ngicngac neneng Anutuac eweheiheigoc kecni KEBUAC angerongo ebicfunac mesinunuudeac nenigoc kecma oronnunuude. ");
INSERT INTO ded_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","KEBU gombunga, ngeni imocnoc nehemma kicnginango hembisia. Ngic mong ye yeac hoannu kemma sufuma kecande, ye sogac sogaigoc kefude. ");
INSERT INTO ded_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","KEBU eweheihei ammiandae, yeni wiac monggac naric mi obohogecde. Imocac ngicngacfora kpetiac kecdae, ngeni ye eweheimima kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Raiong yang gboria yeni yaka hofocma herenginaac homegecde, fora. Anu ngicngac KEBU hofocandae, yeni wiac gombunga monggac naric mi obohogecde. ");
INSERT INTO ded_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","O nambarac, ngeni yei hama yoacna negembisia. Ni KEBUAC eweheiheigoc kekec kpoungemmebade. ");
INSERT INTO ded_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Ge kecnadeac anggendeu nga nasoga mehereema kekec gombunga kecnadeac anggendeu ");
INSERT INTO ded_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","ge nedzaranggango yoac mangana mi debesena amma ge enacbibicgango ikocyoac mong mi debesena. ");
INSERT INTO ded_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Ge yarefaka wama gombunga angkecbesena amma ruaekekec meficgenadeac anggenu imoc meficgenadeac uatoa mebesena. ");
INSERT INTO ded_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","KEBUNGO kiwa ngicngac dindingac yenearu fima kedzac kpema kiacngina negenude. ");
INSERT INTO ded_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Ye yarengic yenemma meicyunuu bangecfu ngicngac ninigec meficgeyemmeu yeneng monggoc mi negensiyunugecde. ");
INSERT INTO ded_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Ngicngac dindingac yeni KEBUNGO meficyunuudeac kiacgec yeng kiacngina negemma ebicfunac mesiyunudarude. ");
INSERT INTO ded_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Ngicngac ubamanganggac wosongina toho tohoya kecgec KEBUNGO yeneac wegenac kefude nga ngicngac asuu kpungge kpunggea kecdae, yeni ebicfunac mesiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Ngic dindingacngo kpendzeng kpekecde, imoc wiac homac yombong, nga KEBUNGO sifu ye ebicfunac mesidarude. ");
INSERT INTO ded_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Ye sira gombunga garenggeu sira mongngo naric mi usuude. ");
INSERT INTO ded_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Ngic Anutu ngadehema mangana meudeac ammiande, ye yarefakaac wiac manganango kpebucgeude. Nga ngicngac ngic dindingac ngaba ayemmeande, yeni yoacfu kopocsicnginagoc deyemmegec makpegecde. ");
INSERT INTO ded_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","KEBUNGO kingang ngicfora kekecngina bummema ebicfunac mesiyunuude nga mong ye yeac hoannu hama sufuude, ye yoacfu naric mi makpeude. ");
INSERT INTO ded_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Dawidingo yegec yofi heiec. O KEBU, ngic yoackpekpe anendae, yeni yoakpekpe ayemmebesena. Nga ngic nigoc eweandae, yenigoc ewema yunubesena. ");
INSERT INTO ded_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Kebu ge dzikacac kaso nga mariku mema yacma meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Ge tebe nga dzikacac naka mema ni kisannuandae, yeni yununa. Ge ongana yofi edena, “Ni ebicfunac mesigubade.” ");
INSERT INTO ded_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Ngic yeni kpebucnubeso anggec geng feracyunuma game kpekpeu faiyununa eweheiheia kpac ambisia nga kpetotienubeso anggec geng kpae heiyemmena yeni dzigenema oboc kpoboc ambisia. ");
INSERT INTO ded_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","KEBU, firangngo padihakoya fifiranggema kisangande, ifi isoc fingecbeso. Geac angerongo ifi kisangyunuu kembisia. ");
INSERT INTO ded_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Ge negemmana yeni singngina kundung kpema pososoc anu KEBUAC angerongo kisangyunubeso. ");
INSERT INTO ded_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Yeni hania kpacfu eng memanganenubeso dema ufic mong mesufuma faigec nga kekecna eng megecdeac dema teng mong usugec. ");
INSERT INTO ded_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Nga geng negemmana yeneng wiac mong mi negemmagec wiac manganango hama kpetotieyunubeso. Yeni ufic faigec, imohai imocngo yenang mendangyunubeso amma teng usugec, imohai yenaoc kemegec kpetotieyunuu kpac andacbisia. ");
INSERT INTO ded_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Ifi anu onganango KEBUAC amma sogac sogai meficgeude amma yeng ebicfunac mesinudacac ubangerec negembade. ");
INSERT INTO ded_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Sicna sasawango degecde, “O KEBU, ge isoc mong mi kecde. Ngic kucnginagoc yeni kucmama feracyunugec geng yeneac mariunac mesiyununade. Ge ngic kucmama nga makpekpea godzungic maringinaunac mesiyunuannec.” ");
INSERT INTO ded_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Ngic yeni mangana arenggema yacma yoacfu nearu hama faka goa mi negenduae, imocac dekpesi anendae. ");
INSERT INTO ded_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Ni yeneac faka gombunga amba yeneng ine turunga mangana merennendae, imocac ongana ebiride. ");
INSERT INTO ded_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Anu yeneng hafei amma kecgec, imohai ni sifu ubamanganggac wamba torungo memea heima yakasege kpendzenggoc kecma ngonducnema yeneac amma numuai. ");
INSERT INTO ded_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Faka anai, imoc neanna sactosona monggac me dacnaac angang isoc ubamangang negengkefai. Amma nonggonango homeu ambai isoc songgonggac wamba heima ngonduc ngonduc kengha kefai. ");
INSERT INTO ded_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Anu ni tifainggeai, imohai yeneng ine ubangerec negemma adzoroma namma nubeso anggec. Yeneng memanugecdeac kpedzucnegec nga godzungic goa mi negengyunuduae, yeneng memanganenugec, imoc wisic wisickea kpac. ");
INSERT INTO ded_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Ngic Anutu ngadehema mangana angkecdae, yeneng yeni isoc monggoc nga monggoc enac kisaranggedae. ");
INSERT INTO ded_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","O KEBU, ge naso dafiguc wiac imoc kicga fima hennade? Yeni memanganenudaeac yeneac mariunac meicnuna. Ge kekecna raiong yangtoa yenearunac meicnuna. ");
INSERT INTO ded_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Geng ifi anna ni kpebung habutoa yeneac kicfu geac ubangerec megembade amma ngicngac habutoagoc nanggec ni yenigoc namma eriendzong megembade. ");
INSERT INTO ded_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Anu ngabafocna yeneng hania kpacfu ngaba anemma dedzomoc anembauac kpae heiyemmebesena. Yeni hania kpacfu neac modzongina tiu ebic imocac ubangerec negemma kicparac kpounembauac kpae heiyemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Yeni ruaeac yoac mong mi deandae nga ngic bangecfu yumia kecdae, yeneac ikocyoac dema memanganeyunugecdeac negensidae. ");
INSERT INTO ded_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Yeni enacngina anggema udumengtoa meficgema neac yofi deandae, “Yahec, imoc gennoc andang, neni gending.” ");
INSERT INTO ded_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","O KEBU, ge wiac sasawa bic hennec. Ge imocac yoacga mi waickena. O KEBU, ge neac hereau mi kecbesena. ");
INSERT INTO ded_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","O Anutu, ge neac Kebu. Ge yacma kockpac amma yoacna nanggema meseribesena. ");
INSERT INTO ded_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","O KEBU Anutuna, ngabafocna yeneng dedzomoc anembauac fakaga dindingac modacma nanggenuna yoacfu firang ambesare. ");
INSERT INTO ded_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Yeni ge negemmana yofi mi deemebisia, “Naric yombong, ifi yombonnoc fingecmiudeac negening.” nga yeni monggoc mi debisia, “Yagucnoc ye kpetotieni kpac andarude.” ");
INSERT INTO ded_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Yeni neac ebicac amma ubangerec negendae, imocac ge negemmana yeni oboc kpoboc anggec game kpekpeu faiyunubesonga. Ngicngac goa yeneng memanuma feracnuma ubangerec negendae, yeni gamengo wamba isoc semeyunuu eweheiheia kpac kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Nga ngicngac yeni neac yoacac fora dindingac fingerudeac ayemmeande, yeni ge negemmana ubangerec negemma sogaima dendzerenggema arohobisia. Yeni nasosoc yofi dekecbisia, “KEBU ye engena yombong, ye kingang ngihango gombunga kefudeac songo negenude.” ");
INSERT INTO ded_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Ifi anu neac nedzarangngo fakaga dindingac dekperagima asoacnac kemma marai dedengerecga deude. ");
INSERT INTO ded_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Yegecgareng yearu. KEBUAC kingangngic Dawidingo yegec yofi heiec. Ngic mong ye Anutu ngadehema mangana meudeac ammiu singyoackpekpengo yeac herea keme kemeau yombong kehema yoac edeude. Ye kiwango wiac hendacma Aunutuac kengec mong mi negenude. ");
INSERT INTO ded_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Ye yoackerec nga ikoc angemema ubeau yofi negenude, “Ngicngac ogofocna memanganeyunudua, imoc ngic mongngo naric mi hennegeng anude nga fakana imocac modzongina mi tiude.” ");
INSERT INTO ded_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Ngic imoc ye enacngo ogofocngina tobangyunuudeac yoac nga ikocyoac arenggema deude. Ye bicngoc negentegecma wiac gombunga angkefec, imoc bic wama eng kefude. ");
INSERT INTO ded_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Nga ye fefeau fema ogofora tobangyunuudeac mangana arenggema sing manganasac modackefudeac negenude. Ye faka angammeme mangana mong mi ngadehema waude. ");
INSERT INTO ded_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","O KEBU, geng yoac dedzege amma imoc modackecnec, fakaga imocngo emma kurumenga kurumenga kpesereyunuude. Nga yoac modac modac fakagango wi emma hoeng kpesereyunuude. ");
INSERT INTO ded_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Tikitoa nangkendae, ifi isoc geac dindingac kekecga ande. Ge yoacfu sing dindingac modacma yoacngina desiyemmeannec, imocngo kondung keme kemea isoc ande. O KEBU, ge ngicngac nga yang hania hania momoc onggongyununade. ");
INSERT INTO ded_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","O Anutu, geng yoac dedzege amma imoc modackecnec, fakaga imoc wiac engena yombong. Neni, ngicngac yeneac nambaracfocnginango, geac hoannu hadacma kpegangga marabeau sufuma kecnide. ");
INSERT INTO ded_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Geac amau yaka gombunga gombunga homac feu ubangerecga doku isoc hanemmeu nekecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Kekecac haniaac dokudzohong, imoc gearu fekefude nga neni geac kperagiu kperagi hengkecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","O Kebu, geng yoac dedzege amma imoc modackecnecac fakaga imocac ngicngac negenggukecdimbe, nenearu fekecbeso. Ngicngac herenginau ikoc nga hamangec mong mi fede, geng yeni ebicfunac mesiyununa. ");
INSERT INTO ded_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Ubakpekpe ngic ye haniango ni tifacnubaac kpae heimibesena. Amma ngic Anutu ngadehema mangana megecdeac ayemmeande, ge yeneac kpae heina yeneng ni mi kporacnubisia. ");
INSERT INTO ded_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Yarengic yeni bangecfu mayunuu fedae, yeni mayunuu monggoc mi yacgecde. ");
INSERT INTO ded_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Dawidingo yegec yofi heiec. Ngic Anutu ngadehema mangana megecdeac ayemmeande, ge yeneac modzoga mi tibeso. Nga faka mangana angandae, ge yeneac keracmangang mi ambesena. ");
INSERT INTO ded_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Yeni naso wegenacnecsac kecma kpindzingngo dzanggeande, ifi isoc dzanggegecde. Wiac mong maria tengging tenggingngo homeande, yeni ifi isoc homegecde. ");
INSERT INTO ded_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Ge KEBU negenserima kecma faka gombunga angkecbesena. Ge ifi amma bangecfu naso herea kecma bangec imocac hoannu sufuma ruaegoc kecnade. ");
INSERT INTO ded_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Ge KEBUAC songo negembesena. Ge ifi anna yeng heregaac songo modacma wiac genude. ");
INSERT INTO ded_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Ge kekecgaac sing KEBUAC mariu faima ye negenserima kecna yeng uaya mekefude. ");
INSERT INTO ded_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Nga yeng nanggeguu ge firang anna imocngo wenac kperagia isoc mekperagiyunuude. Amma nanggeguu dindingac annade, fakaga imoc wenac nasou wenac kperagiande, ifi isoc kperagiude. ");
INSERT INTO ded_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Ge KEBUAC kicfu waickema tomai kecma kucga mi mabeso. Ngic mongngo yarefaka arenggema iwai sasawa meficgema naric kefude, imoc fingeru ge yeac modzoga mi tibeso. ");
INSERT INTO ded_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Ge ngaba mi ambesena nga herebufaka imoc ngadehema monggoc mi negembesena. Modzotitingo manganau wangecguudeac ngicngac ubango mi ukuyunubesena. ");
INSERT INTO ded_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Ngic Anutu ngadehema mangana megecdeac ayemmeande, ye meicyunuu kpac anggecde. Nga ngicngac KEBUAC tomai kecandae, yeni maridzominggac arennu bangec mema mingina anggecde. ");
INSERT INTO ded_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni naso mi hereemanu monggoc mi kecgecde. Ge tatahau kemma ye hofocyombonggema naric mi meficgenade. ");
INSERT INTO ded_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Anu ngicngac yumia yeni maridzoming arennu bangec mingina anggecde. Yeni finac hania hania efea kpac mekecma ubangerecgoc kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni ngic dindingac yunugecdeac areng faima enac kisaranggedae. ");
INSERT INTO ded_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Nga KEBUNGO ine yenemma dzomoreude, nocac nasongina wegena haude, imoc bic negende. ");
INSERT INTO ded_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni soe taima tebengina kpedzigecde. Yeni ngicngac makpekpea amma ngicngac iwaiac obohoma kecdae, yenemma ngicngac ikoc nga hamangecngina kpac kecandae, yeni yenemma yunugecdeac ayemmeude. Yeni ngicngac herengina dindingac kpebucyunugecdeac ayemmeande. ");
INSERT INTO ded_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Soenginango yenang herengina nendanggeu tebengina usuude. ");
INSERT INTO ded_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Nga ngic didingacngo wiac kapianec mekecde, imoc wiac gombunga. Anu ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni wiac efea kpac feyemmeude, imocngo ngic dindingac yeac finacbisic, ifi isoc mi ngereeude. ");
INSERT INTO ded_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Ngic Anutu ngadehema mangana megecdeac ayemmeandae, yeni ebicfu enggec maringina kpetackeude. Anu KEBUNGO ngicngac dindingac nanggeyunuu seria nanggecde. ");
INSERT INTO ded_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","KEBUNGO ngic kopocsic mong mi meficgeandae, yeneac nasongina negendacde. Nga yeni maridzoming negemma wiac megecde, imoc wisic wisickea kpac anu ");
INSERT INTO ded_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","naso ebihagoc hau yeni seria nanggecde. Mongngo game kpekpeu naric mi faiyunuude nga bodinaso hau wiac monggac naric mi obohogecde. ");
INSERT INTO ded_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneng ine kpac anggecde. Dzaring dzuria moronggema kpac angandae, ifi isoc KEBUAC ngabafora kpac anggecde. Yeni hosuc engande, ifi isoc emma kpac anggecde. ");
INSERT INTO ded_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Ngic Anutu ngadehema mangana meudeac ammiude, ye wiac turung amma mema turunga imoc mi kpouande. Ngic dindinga, yeng ubangerec negemma wiac naric eng yemmeude. ");
INSERT INTO ded_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Ngicngac KEBUAC kenecgoc kecdae, yeneng maridzominggac arennu bangec mema mingina anggecde. Nga ngicngac Kebuac sowec bageau kecgec Kebungo meicyunuu kpac anggecde. ");
INSERT INTO ded_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","KEBUNGO ngic monggac singgac negenu ngereeudeu ye yeac kenghaya meseriu sing titia seria anude. ");
INSERT INTO ded_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Ye todinggebac, fora. Nga Kebungo mariau medeac naric mi makpeude. ");
INSERT INTO ded_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Ni medacnaungoc kecerekecma yaguc ngickpengeng anduae, imohai hemba Anutungo ngic dindingac naric mi wau eng kecande, kpac. Nga yeac nambaracfora yeni yakaac mong mi derecgegecde. ");
INSERT INTO ded_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Yeng nasosoc iwai eng yemmekecde nga nambaracfora yeni ogomefic amma ngicngac ogofocngina kenec meficgeyemmegecde. ");
INSERT INTO ded_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Ge faka angammeme mangana ngadehema wama faka gombunga amma bangecfu wisic wisickea kpac kecnade. ");
INSERT INTO ded_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","KEBUNGO ngicngac sing dindingac modacgecdeac ammiu yeac kpetiac areng, yeni naric mi ngadeyunuma wayunuude. Ye onggongyunuude, imoc wisic wisickea kpac. Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeng yeac nambaracfora ine meicyunuu kpac anggecde. ");
INSERT INTO ded_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Ngicngac dindingac yeneng maridzominggac arennu bangec mema mingina amma naso wisic wisickea kpac imohai kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Ngic dindingac ye enarango yoac negen negentegecgoc deude nga nedzarangango sing dindingac modacnideac yoac deude. ");
INSERT INTO ded_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Ye KEBUAC dedeseriyoac ubahereau feu hania naric mi tiposockeude. ");
INSERT INTO ded_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni ngic dindingac yeneac kicfifi kecma kpebucyunubeso anggec ");
INSERT INTO ded_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","KEBUNGO ngic dindingac naric mi wayunuude nga ngaba yeneac kucnginango naric mi feracyunuma memayunuude. Ngaba yeneng yeneac yoac mekemma yoacfu faiyunugec KEBUNGO kpae heiyemmeu kopocsicac areng naric mi deyemmegecde. ");
INSERT INTO ded_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Ge KEBUAC tomai kecma yeac sing modacbesena. Ge ifi anna yeng miacguma maridzominggac arennu bangec genu mingina annade. Nga yeni geac kicfu ngic Anutu ngadehema mangana megecdeac ayemmeande, meicyunugec kpac anggecde. ");
INSERT INTO ded_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Ni ngic mong henai, ye Anutu ngadehema mangana meudeac ammiu ngicngac ogofora ebicfu faiyunukefec. Nga yeneng ubaebicgoc kecmagec yeng Rebanong bangecac yomondzoc ic herea isoc feracyunuma nangkecfec. ");
INSERT INTO ded_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Nga ni monggoc ihai kemma nanangasac hemba yengena mi nanu hemba dema hofocba imohai mi nanec. ");
INSERT INTO ded_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Ngic kopocsic mong mi meficgeande, ngeni ye hentegecbisia. Ngic mong ye ikoc nga hamangeha kpac kecande, ye hembisia. Ngic ruaegoc kecande, yeng arengfora yenigoc naso herea kefude. ");
INSERT INTO ded_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Nga singyoackpekpe ine kpetotieyunugec kpac andacgecde nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni wiacngina ngereema feec, imoc meickegec kpac anude. ");
INSERT INTO ded_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","KEBUNGO ngic dindingac ebicfunac mesiyunuma ebicnasou yeneac sufu sufuamangina anu ihai sufuma kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","KEBUNGO meficyunuma ebicfunac mesiyunuude. Yeni yeac hoannu hama sufuma kecdaeac amma yeng ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneac mariunac mesiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Dawidingo sese fai faiac nunumuyegec yofi heiec. O KEBU, ge ngaba amma yoac ngabasiric mi anenna nga herega buu kopocsicac amma numeting mi anenna. ");
INSERT INTO ded_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Ge tebegango wedecnunec nga marigango witinau faima ferandzinunec. ");
INSERT INTO ded_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Ge neac modzoga tikecdeac sebina sasawa manganeu hafei ande nga kopocsicnaac amma sicna yeni sasawango hafeinginagoc andae. ");
INSERT INTO ded_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Ni kopocsic meficgekecba imocngo feracnuma semenukecde. Nga finactoa ebirango ngicngac yiniande isoc niu imoc naric mi tofohobade. ");
INSERT INTO ded_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Ni kopocsicnagoc kecma kapafaka angkecduaeac amma kubecna sasawa hoaema homuna fiu ");
INSERT INTO ded_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","patickema ngonducnema asoacnac kemma marai ubahodungtoa negengkecduae. ");
INSERT INTO ded_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Sebina gerea nohou hafeingo sokodaru gombunga mong mi ande. ");
INSERT INTO ded_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Amma ni kucna kpac andaru manganema pereckema panggeduae. Amma herenau negengyohocgoc kpeborongtoa amma asoringa anenu kpacma arohoduae. ");
INSERT INTO ded_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Kebu, ni wiac sasawaac anende, imoc negendacnec. Nga ni asoringa anenu imocngo gearu mi sufuude. ");
INSERT INTO ded_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Ni wosona tantang anu kucna kpac andaru kicnaac kperagi bic pisickedac. ");
INSERT INTO ded_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Ni kpendzennagoc, imocac tosofocna nga amaarengfocna wanuma wegenac naric mi hagecde nga nonggo mang dacmunacfocna yeni hereau nandae. ");
INSERT INTO ded_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Ngic kpebucnubeso ayemmede, yeneng botac faima kpetotienugecdeac yoac dedae. Yeni asoacnac kemma marai ikocfu faitobang anenggecdeac arenga faikecdae. ");
INSERT INTO ded_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Ngic kedzacfongngo yoac mi negengande, ni ifi isoc anduae. Amma enacmedzicngo yoara kpac kecde, ni ifi isoc enac anggema yoac mong mi deduae. ");
INSERT INTO ded_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Oc, ni neannaoc ngic mong yoac mi negengande, ifi isoc amma kecduae. Ngic mong ye enacngo demetingyoac naric mi merengyemmeande, ni ifi isoc anduae. ");
INSERT INTO ded_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","O KEBU, ni geac tomai kecduae. O KEBU Anutuna, gennoc yoacnaac turunga merennennade. ");
INSERT INTO ded_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Ni numuma yofi deduae, “Ngaba yeneng feracnuma ubangerec negembauac nga tiposockeba yeneng negenggec wiac engena anu yoac homac osobauac kpae heiyemmebesena.” ");
INSERT INTO ded_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ni manubeso anu kpendzenggoc kecbare imocngo mong mi wanuude. ");
INSERT INTO ded_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Ni ngic memanganefaka angkefai, imoc deficgema kopocsicnaac amma ubahodung negemma kecduae. ");
INSERT INTO ded_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Ngabafocna yeni ine ngaba eng anendae amma yeni kucngina monggoc. Nga ngic endzirango hania kpacfu ubango ukunudae. ");
INSERT INTO ded_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Ni faka gombunga amba yeneng ine imocac turunga yarefakango merennengecde. Ni faka gombunga modacma angkecduaeac yeni ngabafocna andae. ");
INSERT INTO ded_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O KEBU, ge mi ngadenuma wanuna. O Anutuna ge neac hereau mi kecna. ");
INSERT INTO ded_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","O Kebu, memeficna, ge bic hama meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Yegecgareng yearu. Yehudutung siriha modacma heibesonga. Dawidingo yegec yofi heiec. Ni negen nengengua mema deai, “Nedzarannango kopocsic meficgebaiac nedzaranna nga fakana garenggebade. Ngic Anutu wama magana megecdeac ayemmeande, yeneng nigoc wegenac kecmagec enacbibicna kpae heimiba yoac mong mi debeso.” ");
INSERT INTO ded_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Ni udumenga kpac waickema kecma wiac mong mi deba imoc memefihagoc mi anec, kpac. Kpendzenna imoc monggoc yombong yadiec. ");
INSERT INTO ded_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Herena gerea anu negen negeng ua meba herena gerec dzeu nedzarannango yoac deai. ");
INSERT INTO ded_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Yoac yofi deai, “O KEBU, ni nasona wisickebeso ande, negen negeng imoc dekperaginembesena. Ge uameme nasona kpeteagoc bic nennec kecduae, imoc edzacnuna negentegecbesare. ");
INSERT INTO ded_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Negenna, ge uameme nasona faina neneng imoc maringo naric edzacyununi, imoc wegenac yombong ande. Kekecna imoc geac kicfu wiac wegenacnec ande. Ngic tembuc tembuc neneac kekec imoc wiac engena kpac, geng asu naso mocgu heiannec, ifi isoc ande.” Selac ");
INSERT INTO ded_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","“Nga wenac nasou ic ongea fingecande, ngicngo ifi isoc kengha anu wisickeude. Ye uatoa homac mekecde nga imoc eng fingeru foraya mong mi fingecde. Ngicngo wiac mekpedzuc angkecde nga wiac imoc merang ngade meude, imoc ine mi negenude.” ");
INSERT INTO ded_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","“Kebu, ifi anu ni wiac mong fingecnenudeac tomai mi kecbade. Geng meficnunadeac tomai kecba negen negenna gearu fede. ");
INSERT INTO ded_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Ni singyoac kpema mangana angkefai. Nga ngic negen negengngina kpac yeni desofoc anembauac kpae heiyemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Nga gennoc faka yomoc meficgena fingecnendacac amma ni waicke kecma enacna mong mi anggebade, kpac. ");
INSERT INTO ded_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Geng ni kpendzeng nennec, imoc nearunac meickena. Ge marigaac kucngo nuu kpac ambeso anduae. ");
INSERT INTO ded_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Geng bangecngic kopocsicninaac amma yoac ngabasiric dema turunga merengnemmema kpemeting anemmeannec. Gisicngo wamba neande, ge ifi isoc songowiacnina nedacna kpac andarude. Foracngoc, ngicngac sasawa neni wiac engena kpac, geng naso mocgu asu heiannec, ifi isoc andimbe.” Selac ");
INSERT INTO ded_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","“O KEBU, ge nunumuna negenna memeficac kiacba ge kedzac faima negenna. Ni kickumana madeac ihoc bahoc mi anna. Ni kuricngic amma hama naso wegenacnecsac kecbade. Ni esangabofocna isoc kuricngicsac anduae.” ");
INSERT INTO ded_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","“Ge wanuma kicga nearu mi fina. Geng ifi anna ni sogac sogai monggoc meficgemaguc yomoc wama kendacma kpac ambade.” ");
INSERT INTO ded_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Yegecgareng yearu. Dawidingo yegec yofi heiec. Ni modzotitia kpac kecma KEBUAC tomai kecbare yeng kiwa nearu faima kpakpacna negenec. ");
INSERT INTO ded_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Ye kpetotiekekecac tennunac kpedzinuma goteng yohoctaunac tainuma hoc peperandzi seria witiau fainuu namba hanina meseriu tiseriduae. ");
INSERT INTO ded_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ye yegec gboria enacnau faiu heianduae, imoc Anutuninaac dedengerec yegec. Ngicngac homacngo imoc hemma KEBU eweheihei ammima ye negenserima kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Ngic mong ye KEBU negenseriande, ye kenehagoc. Yeng ngic yenanggac negenggec wiac engena angkecde, yeneac hoannu mi kemma yenigoc naric mi kefude. Ye sing mi segeude, nga ye ngic nemu ikoha modacandae, yenearu naric mi kenude. ");
INSERT INTO ded_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","O KEBU Anutuna, ge isoc mong mi kecde. Ge neneac negemma kucfaka wiac engena homac meannec, imoc monggoc nga monggoc mekecnec. Ni imoc dekperagima ngicngac edeyunubade dema kpetengina homac amma imoc memeac siriha kpac. ");
INSERT INTO ded_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Ge sesegerec nga kopocsicac sese hania haniaac mi anggengande. Ge sese dema yang nga burumaka hafoa oho oho me kopocsic meic meickeac sese, imocac mi kpesiannec. Geng kedzacna mesarinec, imocac ni geac kingang ngic amma kecbade. ");
INSERT INTO ded_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Ifiac amma yoac yofi deai, “Kibi kpou kpouya manau neac siduc bic ohogec fede nga ni bic hadua. ");
INSERT INTO ded_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","O Anutuna, ni geac songo sogac sogaigoc modacbade nga geac dedeseriyoac imoc herenau fede.” ");
INSERT INTO ded_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","O KEBU, ni siduc gombung bic edeyunuai. Geng ebicfunac mesinunukecnec, ni habutoa yeneac kicfu namma siduc imoc dekperagiyemmema enacbibicna mong mi kidzickeai, ge imoc negennec. ");
INSERT INTO ded_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Amma geac faka dindingac imoc herenau mi mesufuai. Ge yoac modac modac Kebu amma ge ngicngac ebicfunac mesinunukecnec, ni habutoa yeneac kicfu namma imoc dekperagiyemmeai. Geng yoac dedzege amma imoc modackecnec amma ge yoac modac modac Kebu, imoc mi mesufuma habu sasawa edeyunudacba negendacgec. ");
INSERT INTO ded_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","O KEBU, ge ubamangangga mi dzegenenna. Geng yoac dedzege amma imoc modackecnec amma ge yoac modac modac Kebu. Geac fakaga imocngo hoannuma nasosoc onggonnubeso. ");
INSERT INTO ded_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Yarefakanaac kpetea osobadeacsoc mi amba yeni oronnukecdae. Ni ngicngac ogofocna memanganeyunukefai, faka imocngo feracnumanu wiac mong naric mi hembade. Nga imoc homac yombong amma orucna dzoea ferahau herena kuha kpac ande. ");
INSERT INTO ded_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","O KEBU, ge neac negenna ngereeu onggonnuna. O KEBU, ge bicbic hama meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Ngic yeni kekecna hamangec mebeso andae, imocac ge yenemma game kpekpeu faiyununa oboc kpoboc ambisia. Ngic yeni ni memanganenubeso ayemmeande, ge negemmana ngic imoc dzigenegecdeac ayemmena yeni worama eweheiheingina kpac ambisia. ");
INSERT INTO ded_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Ngic yeneng neac deendema yoac yofi deandae, “Yahec, yahec!” Yeni yenaoc gameyunuudeac amma manganema nambisia. ");
INSERT INTO ded_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Ngicngac ge hofocgukecdae, yenennoc sogaima geac ubangerec negembisia. Ngicngac geac memengerecac songo negendae, yeni yofi dekecbisia, “KEBU dengereni.” ");
INSERT INTO ded_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Neng ine makpekpea amma iwaiac obohoma kecma naric mi meficemeba Kebungo sifu ebicna henu wiac monggac mi obohobade. O Anutuna, ge memeficna nga ebicfunac yungec yungecngicna, ge naso mi ukuma nearu bic hana. ");
INSERT INTO ded_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Yegecgareng yearu. Dawidingo yegec yofi heiec. Ngic mong ye ngicngac makpekpea yenenggareng ayemmeande, ye kenehagoc. Ebicnasou KEBUNGO ye ebicfunac mesima ");
INSERT INTO ded_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","onggonggema kekeha garenggeu ye bangehau sogac sogaigoc kefude. Ngabafora yeneng megecdeac ayemmeu KEBUNGO yeneac mariu naric mi faiude. ");
INSERT INTO ded_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Ye hafei ammiu femanu KEBUNGO meserima hafeia meickema monggoc mengereeude. ");
INSERT INTO ded_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Neng yoac yofi deai, “O KEBU, ni gearu kopocsic meficgeai. Ge imocac neac ubaga manganeu mengerenuna.” ");
INSERT INTO ded_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Ngabafocna yeneng neac yoac mangana dema yofi deandae, “Ye homeu kpara kpac ambeso.” ");
INSERT INTO ded_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Ngic mongngo yugucnubeso hama ni tobannuudeac negen negeng ubahereau arenggeude. Ye yoac fora mong mi dema monggoc mama kemma imoc deyadiude. ");
INSERT INTO ded_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Ngic neac modzongina tiande, yeni sasawango neac yoac sangic sangic denengeng amma wiac mangana yombong fingecnenudeac negemma ");
INSERT INTO ded_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","yofi deandae, “Ye hafei mangana yombong ammiu fefeunac monggoc naric mi yarude.” ");
INSERT INTO ded_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Nga tosona nigoc wegenac kecande, ye negenserima kefai. Ye warac yaka nigoc nekefec nga yeng ifingoc gofoc gofohango tifacnuma docfu fainuec. ");
INSERT INTO ded_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","O KEBU, ge ubaga sifu neac manganeu miacnuna ngereema namma turunga merengyemmebade. ");
INSERT INTO ded_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Ngabafocna yeni firang amma mi memanugec, imocac yofi negenduae, ge neac negenna ngereede. ");
INSERT INTO ded_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ni dindingac kecma kopocsic mong mi meficgeaiac geng nanggenuma geac hoannu fainuna ni imohai nasosoc kecbade. ");
INSERT INTO ded_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","KEBU Israeac Anutu, ye nasoya nasoya kenehema keneengkecbesonga. Imoc fora nga fora yombong. ");
INSERT INTO ded_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Yegecgareng yearu. Yegec yomoc masiki uba modacma heibesonga. Kora medacfora yeneng yegec yofi heigec. Kate burumakabisicngo dokuac ammiu doku hofocande, ubaonganango ifi isoc Anutu ge hofocgude. ");
INSERT INTO ded_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Ni dokuac homeanduae, ifi isocngoc ubaonganango Anutu kekehagoc yeac ammide. Ni kemma Anutuac kicfu namma ye hembade, naso imocac homac yombong tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Ni hadzing toforec kickumanango yakana angkefu ngicngac yeni nasosoc kpesinendae, “Geac Anutu mong mi hendimbe, kpac yombong.” ");
INSERT INTO ded_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Ni onganaac negen negeng hafoangoc widicma edzacguma wiac yomoc negemba fede, ni warac ngicngac arengnginagoc kenggec waraiyemmeba Anutuac womonnu kening. Neni ngicngac habutoango hombang nasoninau sogac sogaiac arohoma ubangerecac yegec heikefing. ");
INSERT INTO ded_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","O ubaongana, ge kucmama mi kecbesena amma ge herena manau dewaidzoc mi ambesena. Ni monggoc Anutu eriendzong memibade. Ge imocac ye negensima tomai kecna fora fingecbeso. Ye memeficna nga Anutuna. ");
INSERT INTO ded_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Ni Yodang bangecfu nga Hermong amma Midza tikiu kecduae. Amma ubaherenaac kuha madeac Anutuna ni geac negemba fede. ");
INSERT INTO ded_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Ni ubana ebirima yofi isoc ande, geac dokudundung yeni kpeborongtoa kpemagec dzohong mongngo dzohong ogea kparu geac kondungsiri yeni kucgoc hama semenudau. ");
INSERT INTO ded_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","KEBUNGO yoac dedzege amma modackecde, ye imoc hadzinnu sing edzahau nigoc kefude. Nga tofocnac yeac yegec nigoc feu heikecba Anutu kekecna sasawangoc garennukecde, numumibade. ");
INSERT INTO ded_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Anutu ye neac hoc peperandzi seria anu yeac deba, “Ge neac nigecgudac, ifi isoc ande. Ngabafocna yeneng ebicfu fainugec ubaebicgoc kecduae, imoc nocac fingecnende, imoc mi negentegecduae.” ");
INSERT INTO ded_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Ngabafocna yeni deendema anemma deandae, “Ge Anutuga mong mi hendimbe, kpac yombong.” ifi degec kubec manganaac kpendzeng kpeandimbe, kpendzeng ifi isoc sebinau kpeduae. ");
INSERT INTO ded_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","O ubaongana, ge kucmama mi ambesena, herena ge dewaidzoc mi ambesena. Ni monggoc Anutu eriendzong memibade, imocac ge ye negensima tomai kecna fora fingecbeso. Ye memeficna nga Anutuna. ");
INSERT INTO ded_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Yegec 42ac tosea O Anutu, ngic Anutu wama kecandae, yeneng memanubauac geng nanggenuna firang ambesare. Ge ngic ikocnginagoc nga ngic faka dindingac mi modacandae, yeneac mariunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Anutu, ni geac hoannu hama sufuma kecba ge nocac ngadenuma wanunec. Ngabafocna yeni ebicfu fainugec ubaebicgoc kecduae, imoc fingecnendeac titiha mi negentegecduae. ");
INSERT INTO ded_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","O Kebu, ge kperagiga nga yoacga fora faina maec yereng sinnu hesicnuma kenec geng kpetiac tikigau kecnec, imohai habesare. ");
INSERT INTO ded_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Ifi anu ni Anutuac aratau kembade. O, sogac sogaitoaac Anutuna, ni gearu kemma gita kpema dengeregubade. O Anutu, ge Anutuna. ");
INSERT INTO ded_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","O ubaongana, ge kucmama mi kecbesena amma ge herena manau dewaidzoc mi ambesena. Ni monggoc Anutu eriendzong memibade. Ge imocac ye negensima tomai kecna fora fingecbeso. Ye memeficna nga Anutuna. ");
INSERT INTO ded_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Yegecgareng yearu. Yegec yomoc masiki uba modacma heibesonga. Kora medafora yeneng yegec yofi heigec. O Anutu, ge bicngoc esangabofocnina yeneac nasou kucfaka meannec, imoc edenunugec kedzacninango negening. ");
INSERT INTO ded_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Ge marigango bangec monnunac ngicngac kporacyunuma neneac bangecfocnina semeng uau isoc homecyununa ihai kecgec. Ge bangecareng tosea ebicfu faiyununec, fora. Nga ge bangecfocnina witicfunac yungecyununa witicngina kpac kecgec. ");
INSERT INTO ded_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Yeni yenang dzikacac beangngo firang amma bangec mi megec, kpac. Amma yenang maringinaac kucngo firang mi anggec, kpac. Geng yeneac songo negennec amma marifoigango kucfaka menec, yeni imocac firang amma bangec megec. Geng marigaac kuc nga kicmesugaac kperagingo meficyununec. ");
INSERT INTO ded_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","O Anutu, ge ngictauna nga Anutuna. Geng yoac dena, Yakoboac arengngo, firang annide. ");
INSERT INTO ded_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Ngabafocnina yeneng wegenac hagec neni geac kucfu igocyununi worama kenggec geac kpacfu ngabafocnina tidzicyunuma memayununide. ");
INSERT INTO ded_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Ni tebena mong mi negenserima kecanduae nga dzikacac beannango ebicfunac naric mi mesinuude. ");
INSERT INTO ded_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Geng warac ngabafocnina yenearunac mesinununec. Ngicngac yeneng ubango ukununugec geng faka ayemmena oboc kpoboc anggec. ");
INSERT INTO ded_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Neni Anutuac negenni engena angkecde. Geac kpac kuneng heiwayong memima nasoya nasoya ifi angkecnide. Selac ");
INSERT INTO ded_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Ge yaguc ine ngadenunuma neneac wasai areng yenigoc mi hama kecnecac game kpekpeu fainununec. ");
INSERT INTO ded_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Ge ngabafocnina kpae mi heiyemmena neni yenearunac worama hani yeneng finacnina medacgec. ");
INSERT INTO ded_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Rama yeni memeficngina kpac kecmagec ngic yeni meyunuma kpehou angkecdae, neni ifi isoc aning nga geng ngic imoc kpae mong mi heiyemmenec, kpac. Ge meicnununa singsararang kpema bangec monnunac ngicngac botucnginau fainununec. ");
INSERT INTO ded_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Ge ngicngacfocga fainunuma bung efeanecsac dena menunugec. Ge neneac bung kuneng mong mi denec. Imoc hemba mi ngereede. ");
INSERT INTO ded_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Ge ngicngac wegenac kecdae sing meficgeyemmenecac yeni deendema anemmeandae nga ngicngac oronnunuandae, yeni detenic anemmema desofoc anemmegecde. ");
INSERT INTO ded_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Nga ge bangec monnunac ngicngac sing meficgeyemmena yeneng neneac yoac dekecgec yeneac dzomoc tirea andimbe. Ngicngac areng hania hania yeni dedzomoc anemmema orucngina kpatitickenemmegecde. ");
INSERT INTO ded_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Ni asoacnac kemma marai eweheiheia kpac kecba gamengo kicmesuna semeu kecduae. ");
INSERT INTO ded_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Nocac yeni deendema anemma demanganenugec yoacngina negenganduae. Ngabafocna nga ngic yeni turung kpougecdeac ayemmeande. ");
INSERT INTO ded_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Imoc sasawa fingecnemmeec, fora. Nga neneng sifu geac mong mi nigecnunuec, kpac. Ge nenigoc dzadzahac menec, imoc wama ikoc mong mi anggening. ");
INSERT INTO ded_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Neni hereninango geac hereau mong mi kefing nga geac sing modackecma faka imoc mi wanide. ");
INSERT INTO ded_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Geng ine eng kate yang yeneac kekecfu fainununa kecmina kpedzamenunuma kundungtoango semenununec. ");
INSERT INTO ded_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Neni Anutuninaac kpac kuneng nigecnunuu marinina miacma nemu furia afehebinnu ");
INSERT INTO ded_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Anutungo imoc meficgema negendacbac. Ye hereninau wiac sufu sufu fede, imoc negendacde. ");
INSERT INTO ded_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Geac areng andimbeac amma yeni asoacnac kemma marai homecfu fainunukecdae. Yeneng nenemma yofi negendae, neni rama kpebucyunuandae isoc andimbe. ");
INSERT INTO ded_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","O Kebu, ge gauunac yacma negenggborina. Ge naso wisic wisickea kpac mi wanunuma kecbesena. ");
INSERT INTO ded_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Ge kicmesuga mesufuma neneac kpendzeng nigecguec, imoc naric mi ande. Ngic yeneng ebicfu fainunugec neni ubaebicgoc kecdimbe. O, Kebu, imoc mi nigecgubeso. ");
INSERT INTO ded_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Ubaonganina bangecfu sendunnu ngonducneu sebininango bangecfu mendanggema fede. ");
INSERT INTO ded_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","O Kebu, ge gborima yacma ebicfunac yungecnununa. Ge yoac dedzege amma imoc modacanecac amma meficnunuma bummenunuma ebicfunac yungecnununa. ");
INSERT INTO ded_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Yegecgareng yearu. Yegec yomoc masiki yegec kpara Lili dzaring, imocac uba modacma heibesonga. Kora medacfora memeturangyegec yofi heigec. Yoac gombunga gombungango herena wakeu ni ngictauac yegec yofi heibade. Nedzarannango kibi oho ohongic gombunga yeac pen isoc ande. ");
INSERT INTO ded_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ngictau, ge siricga gombunga yombong, ge isoc bangecngic mong ifia mi kecde. Nga geac enacbibicgaunac yoac songea ereude. Anutungo kenecguma monggoc wisic wisickeac kpac kenecgubeso. ");
INSERT INTO ded_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","O Firangngic kucgagoc, ge ngictauac kuc nga kibikperagigagoc kecnec. Ge dzikacac soega kebanggau dzegema dzikacac efaina. ");
INSERT INTO ded_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ge ngictau kucgagoc kecma dzikacac becosicfu tacma yoac fora nga yumiakekec amma dindingac kekec meseriyununadeac kucgoc kemma firang ambesena. Ge marifoigango kucfaka wiac engena yombong kpougembeso. ");
INSERT INTO ded_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Ge tebemedaha enaragocngo ngictauac ngabafora yeneac woubocfu wedecna kemebeso. Ngiha ngiha yeni geac bageu kemema kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","O Anutu, geac ngictau tatacga imoc wisic wisickea kpac amma feengkecfu ge ngicngacfocga ngictauyasugango garengyununade amma yoacga imoc monde mondea kpac. ");
INSERT INTO ded_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Ge dindingac kekecac anggenu ngicngac Anutu ngadehema mangana megecdeac ayemmeande, yeneac faka imocac modzoga tiande. Imocac Anutu, geac Anutungonoc tosofocga yeneac botucfunac meisingguma feracyunuma sogac sogaiac kerec nadzicgenu sebigango ireckeude. ");
INSERT INTO ded_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Ngicngac yeni wambagau mira nga aroe amma kassia heigec homuna gombunga gombunga fiande. Yeni erefang yanggac baihango wiac gombunga gombunga mema ngictauamagau faigec siriha gombunga anude. Yeni imohai gitakurere kpegec udumeng gombunga meficgegenggec ubangerec negengannec. ");
INSERT INTO ded_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Ngictau yeneac naroangfocngina yeni ngac yenigoc amagau kecma geac kingang kpema oronggudae. Enembingecga ye Ofiri bangecfunac gol heima foigaugeng tacde. ");
INSERT INTO ded_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","O naroang, negenna, ge kedzac kpema yoacna negemma negensina. Ge arengfocga nga manggaac ama imoc nigecgubeso. ");
INSERT INTO ded_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Ngictau ye geac siricga gombunga imoc hembokoma kecde. Ye geac kebu, imocac ge yeac kicfu ngonducnema eweheihei ammina. ");
INSERT INTO ded_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Ge yeneac negenna ngereeudeac negemma ngicngac Tiro taonnunac yeneng geac ubangerecac wiacngina mehama genggecde. Yeni dzofinactoanginagoc amma ngicngac sasawa feracyunudae. ");
INSERT INTO ded_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Nga ngictauac naroang ye ngackereng yombong yengena manau tacde. Ye ngakpia imoc gol mucngo memea nga ");
INSERT INTO ded_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","wamba kibiagoc kpebimigec, imoc yearu heigec kemeu ye hesickema ngictau yearu mehagec ngacnaroang tosofora yeneng ye hesickegec yenahafoc gearu hagecde. ");
INSERT INTO ded_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Yeni ubangerec nga sogac sogaigoc hesicyunuma kemma ngictauac ama manau endae. ");
INSERT INTO ded_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","O ngictau, ge medacfocga fingecma mangfocga yeneac tatac megec geng areng faina yeneng bangectoa bangec garenggegecde. ");
INSERT INTO ded_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Fingecsahenina fekecdesoc, yeneac kicfu geac kpac kuneng miacba yeneng afegugecde. Ngicngac areng sasawa yeneng wisic wisickea kpac eriendzong megenggecde. ");
INSERT INTO ded_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Yegecgareng yearu. Yegec yomoc aramoc uba modacma heibesonga. Kora medafora yeni yegec yofi heigec. Anutu ye sufu sufuamanina nga kucnina. Ye ebicnasou nenigoc nasosoc kecma meficnunuude. ");
INSERT INTO ded_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Imocac kengec naric mi annide. Bangec kpemindzaheudeu me tiki kondung keme kemeau turic turic anggecdeu ");
INSERT INTO ded_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","nga doku tunggbaungtoango udumeng kunengngoc meficgema kporoc tima tiki yunuu dendeng kpegecde, fora. Nga neneng sifu kengec mi annide. Selac ");
INSERT INTO ded_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Doku mong mahama Anutuac taonnu sogac sogai meficgede. Anutu Engenatoango kpetiac ama imohai kecde. ");
INSERT INTO ded_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Anutungo taong imocac botuhau yombong kecdeac wiac mongngo meu imoc goroc goroha kpac kecma naric mi makpeude. Anutungo ama werec wereckenggac ye meficgeude. ");
INSERT INTO ded_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Bangec monnunac ngicngac Anutu mi negemmidae, yeneng dzomugerec mekecdae nga bangecac eucerereng yeni goroc goroc amma mayunuude. Ye ubia miacma kparu bangectoa bangecngo sisingaima kpac andarude. ");
INSERT INTO ded_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","KEBU kurumenggac wasaiareng kunengnginango nenanggoc kecde. Yakoboac Anutu ye sufu sufuamanina. Selac ");
INSERT INTO ded_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Ngeni hama KEBUAC ua hembisia. Ye bangecfu faka bibiagoc meec, ngeni imoc hembisia. ");
INSERT INTO ded_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Yeng bangec tegia noboc noboc dzikac menomanema tebe pokong sasawa kpetackedacma dzikacac kasongina gerecfu faiu dzeude. ");
INSERT INTO ded_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Anutungo yofi dede, “Ni Anutungina, ngeni waicke tacma imoc negembisia. Bangec monnunac ngicngac yeneng yaiyo kpenenggecde nga bangectoa bangec yeni afenugecde.” ");
INSERT INTO ded_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","KEBU kurumenggac wasaiareng kunengnginango nenanggoc kecde, Yakoboac Anutu ye sufu sufuamanina. Selac ");
INSERT INTO ded_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Yegecgareng yearu. Kora medacfora yeni mitiyegec yofi heigec. Ngiha ngiha sasawa, ngeni mari kpema Anutuac yegec sogac sogaigoc dendzerenggema heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","KEBU Engenatoa ye bibiagoc, ye bangectoa bangec imoac ngictautoa. ");
INSERT INTO ded_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Ye ngiha ngiha memayunuma nenang bageu faiyunuec. Ye bangec monnunac ngicngac hanininaac bageau faiyunuec. ");
INSERT INTO ded_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Yeng Yakoboac songo negendeac amma bangec imoc meisinggeu Yakobongo imoc negenu wiac engena anec. Kebungo bangec imoc maridzominggac arennu nemmeec. Selac ");
INSERT INTO ded_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Anutungo sogac sogaiac arogoc kurumennu enec. KEBUNGO trampet udumengtoagoc kurumennu enec. ");
INSERT INTO ded_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Ngeni Anutuac oheha mema yegec heima eriendzong memima yegec heimibisia. Ngeni ngictaunina yaiyo kpemima yegec heimima dedengerec yegec heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Anutu ye bangectoa bangec imocac ngictau. Ngeni yeac yegec heimima ye dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Anutu ye ngictau amma bangec monnunac ngicngac areng kucgoc garengyunuma kecde. Ye ngictau tataha kpetiacfu tacde. ");
INSERT INTO ded_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Ngiha ngiha yeneac ngictauac medacfocngina yeni Abarahanggac Anutu yeac ngicngacfora. Nga yeni hama kpedzucnema tacgecde. Ngicngac bangectoa bangec imocac kaso amma kecandae, yeni Anutuac ngic. Imocac ye afehema afehekecbesonga. ");
INSERT INTO ded_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Kora medacfora yeni mitiyegec yofi heigec. KEBU ye engena, ye oyang boyang memibesonga. Yeac tiki kpetiacfu, Anutuninaac amatoau, ye dengerebesonga. ");
INSERT INTO ded_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Tiki imoc herea nga gombunga yombong amma bangectoa bangec sogac sogai meficgeyemmeude. Imoc Siong tiki, imoc not bigeng yombong tacde amma imoc ngictau Engenatoa, yeac taong. ");
INSERT INTO ded_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Anutungo ngictau amatoau tacma amea onggonggema gombunga henggareng ammiude, imoc hengkecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Negenggec, ngictau yeneng kpedzucnema yenahafoc dzikac kpegecdeac hama ");
INSERT INTO ded_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","taongtoa imoc hemma kpidohoma kengec homac yombong yunuu woragec. ");
INSERT INTO ded_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Yeni hemma kengecyunuu dzonongngina fedeec. Ngacngo ngadze kiu kpendzeng kpeande, yeni ifi isoc kpendzeng kpegec. ");
INSERT INTO ded_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Geng wenac ere ereaunac firang dena imocngo hama Tarsisi taonggac wage kpedzameyunuande, ge ifi isoc memanganeyununa yeni kengectoa anggec. ");
INSERT INTO ded_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Neni warac siduha negening, imocac fora hening. Nga kicninango KEBU kurumenggac wasaiareng kunengngina Anutuninaac taonnu hening. Anutungo amatoa imoc tatahau faiu nasoya nasoya seria feengkefude. Selac ");
INSERT INTO ded_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","O Anutu, geng yoac dedzege amma imoc modackecnec, imoc geac womonnu namma negensiandimbe. ");
INSERT INTO ded_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","O Anutu, geac kpac kuneng nga geac eriendzong imoc bangec tegia fekendaemoc kpesereyunuu negendacgecde. Ge marifoigango firang angkecnecac mariga imocngo wakede. ");
INSERT INTO ded_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Siong tiki ye ubangerec negembeso nga ge wiac foraya deannecac Yudaac amafora yeni sogaibisia. ");
INSERT INTO ded_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Ngeni Siong yerecgema yeac odaac ama herec herec osoma kpetengina mebisia. ");
INSERT INTO ded_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Ngeni Siong tikiac oda dafia, imoc mengere hemma ngictauac amaseria hembisia. Hemma fingecsahenina fekefude, imocac siduc yofi meyemmebisia. ");
INSERT INTO ded_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Anutu yomoc nenang Anutu, ye nasoya kpac kecengkefude. Yeng sing edzacnunukefungoc kekecnina wisickeude. ");
INSERT INTO ded_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Yegecgareng yearu. Kora medacfora yeni mitiyegec yofi heigec. Ngiha ngiha ngeni yoac yomoc negembisia nga ngicngac bangectoa bangecfu kecdae, ngeni kedzac kpema yoac yomoc negembisia. ");
INSERT INTO ded_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Ngicngac kpactoanginagoc nga kpacngina kpac, dzofinactoanginagoc nga makpekpea, ngeni yoac yomoc negembisia. ");
INSERT INTO ded_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Enacnango negen negentegecac yoac debade nga herenango negen negengua mema wiac hania hania negentegecma kecbade. ");
INSERT INTO ded_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Ngic yeni yoac heima degec ni kedzac kpema imoc negembade. Ni gita kpema udumeng gombunga negemma yoac heiheiac hania deireckebade. ");
INSERT INTO ded_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Naso manganango hau ngic yeni nukporac anenggec ngabafakanginango oronnuu kengec naric mi ambade. ");
INSERT INTO ded_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Ngicngac imoc yeni hiedzongina negenserima kecandae, yeni dzofinactoanginaac negenggec wiac engena anu imocac yoac homac osogecde. ");
INSERT INTO ded_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Foracngoc, ngic mongngo munia monggac kekec dzofinacngo bung naric mi meude, kpac. Ye buma imoc naric mi meficgeude nga yeac bung Anutu naric mi miude. ");
INSERT INTO ded_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Ngickekecac bung imoc engena yombong nga imocac hiedzo homac yombong faigecdeu imoc sifu naric mi kpoudarude. ");
INSERT INTO ded_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Imocac ngic mongngo naso herea wisic wisickea kpac mi kefude. Ngicngac sasawa yeneng kicsereu kemema imoc hendacgecde. ");
INSERT INTO ded_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Oc, ngic negen negentegecnginagoc yeni ifingoc homeandae, imoc hengandimbe. Ngic negen negengngina kpac nga oboc kpoboc yeneng ifi isocngoc homegecde. Yeni hiedzongina wagec goa yeneng imoc megecde. ");
INSERT INTO ded_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Yeni amangina fefeseri feudeac negemma bangec goa ifingoc yenaoc wase meandae, fora. Nga kicserengo sifu yeneac amabangecngina feengkefude. Yeni fingecsahengina fekefudesoc kicserenginau kemema kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Ngic mong wiac kibiagoc gombunga gombunga mekecma heiu wiac ifiango ye kefudeac naric mi meficgeude, kpac. Ye ine yang hania hania yeni homeandae, ifi isoc homema kpac anude. ");
INSERT INTO ded_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Ngicngac yeneng ubafong amma yenanggac negensima kecandae, yeneac kekec imoc ifinoc. Nga ogofocngina goa yeneac yoacnginaac songo negemma modacyunuandae, yeneng sing ifiangoc kenggecde. Selac ");
INSERT INTO ded_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Ngic yeni rama meisingyunuma homec amaac arennu faiyunuandae, yeni ifi isoc andae. Homecngo rama garengngina amma hesicyunuu yeni kemema kicsereu fegec sebingina hoaeu homec amango amangina anude. Anu ama wereckenu ngic ikoc nga hamangecngina kpac kecandae, yeneng kunengngina amma garengyunugecde. ");
INSERT INTO ded_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Anutungo sifu ni hoannuma menuudeac ubaongana homec amaac kucfunac bummema mesiude. Selac ");
INSERT INTO ded_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Ngic mong ye dzofinaha homac nga amagereha nga finatoaya monggoc anu ge imoc hemma imocac negenna wiac engena mi ambeso. ");
INSERT INTO ded_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Ye homeude, imohai wiac imohacnac mong mi tofoma kenu iwaiya sasawa imocngo ye modacma homec amau naric mi kenude. ");
INSERT INTO ded_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Foracngoc, ye gbori kecma yengenaac yofi negengande, ni kenecnagoc. Ngic ye kekeha sasawa ngereeu ngicngac yeneng imoc hemma ye dengerekecgecde ");
INSERT INTO ded_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","nga ye sifu homeude. Ye bangecfora bic kemma kperagi monggoc mi hengandae, yenearu kemeude. ");
INSERT INTO ded_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Ngic mong ye kecma wiac kibiagoc gombunga gombunga mekecma heiu wiac ifiango ye fekefudeac naric mi meficgeude, kpac. Ye ine yang hania hania homeandae, ifi isoc homema kpac anude. ");
INSERT INTO ded_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Asafango mitiyegec yofi heiec. Anutu Kuctoa mingina, KEBU yeng yoac dema bangec kparu wenac ere ereaunac kengkecma wenac keme kemeau wisickeude. ");
INSERT INTO ded_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Siong ye siriha gombunga yombong ande nga Anutungo imohacnac fingectegecma kperagiango nerarannunude. ");
INSERT INTO ded_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Anutuninango hama naric mi waickeude. Yeac kicfu gerecngo dzema waraimiude nga kiafirang kuhagocngo ye yerecgeude. ");
INSERT INTO ded_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Ye ngicngacfora yoacngina isinggema forangina deudeac kurumenga kurumenga wi fekendae amma bangec momoc kpacyunuude. ");
INSERT INTO ded_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Kpacyunuma yofi deude, “Ngicngacfocna yoac tofohoma kecandae, ngeni yeni kpedzucyunuma sueyunugec nearu hadacbisia. Yeneng neac hosuc heima sese ohoma nigoc dzadzahac megecac kpacyunuduae.” ");
INSERT INTO ded_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Anutungo yoacngina isinggema deudeac amma kurumenga kurumenga yeni yoac yofi dekperagikecdae, “Anutu ye dindinga.” Selac ");
INSERT INTO ded_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Ni neannaoc Anutu, ngeneac Anutu. Ngicngacfocna, ni yoac deba negembisia. Israe habu, yoacfu faingunuma yoacngina debade. ");
INSERT INTO ded_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ngeni ubangerecac sese meandae nga neac sese ohogec imoc hengkecduae. Ni ine wiac monggac negemma gorongina kpeduae, imoc yofi, ngeni Anutu Engenatoaac kpacfu wiac deserima dema imocac fora mi meficgegec. ");
INSERT INTO ded_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Ngeni burumaka ngiwa me noning ngiwa odangina manaunac mema nenggec, imoc sifu mi ngereeude, kpac. ");
INSERT INTO ded_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Imoc yofiac, kateu yang sasawa yeni neac nga rama burumaka sasawa bangec buma taosennu kecdae, imoc yeni ifingoc neac. ");
INSERT INTO ded_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Sawakebangau neng sasawa kecdae, yeni negengyunuduae. Nga wiac sasawa kekecnginagoc manennu kenghaandae, yeni ifingoc neac. ");
INSERT INTO ded_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Bangectoa bangec nga wiac sasawa imohai fedacde, imoc neac andeac herenaac homebadeu imoc ngeni mi edengunubai, kpac. ");
INSERT INTO ded_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Ni burumakaac busia mi neanduae nga noninggac sawa ifingoc mi neanduae, kpac. ");
INSERT INTO ded_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Ngeni Anutu ubangerec ammigec imocngo sesengina ambeso. Ngeni Anutu Engenatoaac kpacfu wiac deserima dema imocac fora meficgegec ");
INSERT INTO ded_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","ebicnaso hau ngeni ni kpacnugec neng ebicfunac mesingunuba ngeneng ni afenubisia.” ");
INSERT INTO ded_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneac ine Anutungo yofi deande, “Ngeni neac enac mema singyoacna degec, imocac kpae heingemmeba imoc naric mi debisia. Nga dzadzahac meai, imoc kpacma yoac mong mi debisia, imoc kpaeagoc. ");
INSERT INTO ded_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Ngeni neac dederecgeyoacac modzongina tiu yoacna ngadehema waandae. ");
INSERT INTO ded_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Ngeni hamangecngic hemma yegoc torokpema yeac ogofora anggecde. Nga ngeni kaisero ngic yenemma yenigoc tacyac angandae. ");
INSERT INTO ded_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Ngeni enacbibicngina mi dzegema imocngo ngicngac ogofocngina memanganeyunugecdeac yoac mangana deandae nga nedzarangnginango ikocyoac degecdeac sing arengggeandae.” ");
INSERT INTO ded_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","“Ngeni ngenang dacmunafocngina yoacnginango memanganeyunuandae nga nenggacyombongnginaac medaha enacfu faifai ammiandae. ");
INSERT INTO ded_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Ngeni faka ifi anggec ni waickema kecba ngeneng negenggec, ‘Ni kecduaengoc, ye neni isoc, ye siriha mong mi ande.’ Nga imoc kpac, ni yaguc ine ngeni demeting angemmema mesunginau kpebade. ");
INSERT INTO ded_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Ngeni Anutu nigecngunuande, ngeni wiac imoc negensibisia. Ifi mi negensigecdeu neng ine kpedzamengunuba mongngo naric mi onggongngunuude. ");
INSERT INTO ded_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Nga ngic mong ye neac ewena heima ubangerecac sese heinemma sing dindingac modackecde, ye ebicfunac mesiba yeng Anutuac faka henude.” ");
INSERT INTO ded_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Yegecgareng yearu. Dawidingo Batsebagoc serofaka anu profetengic Natangngo yearu kemma dzigeneu Dawidingo yegec yofi heiec. O Anutu, geng yoac dedzege amma imoc modackecnecac neac ubaga manganeu. Geac wosoefac imoc efea kpac, imocac neng singyoac kpema kopocsic meficgeai, imoc dzuacdacna kpac ambeso. ");
INSERT INTO ded_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Ni ngicngac ogofocna faka mangana ayemmeai. Ge dzuacnuna kongaha ambesare. Ge kopocsicna medzuacna kongac kpebesare. ");
INSERT INTO ded_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Ni singyoac kpeai, imoc negengkecduae nga kopocsicna imoc nasosoc hensiduae. ");
INSERT INTO ded_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Gearusac kopocsic meficgema kicgau faka mangana yombong anai. Ifi anu geng yoac denec imoc fora fingectegerude ge ngic hania isinggema yoacngina desinec, imoc dindingac. ");
INSERT INTO ded_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Foracngoc, nengganango kopocsicgoc kecma ni kpenannuma menuu kopocsicnagoc fingerai. ");
INSERT INTO ded_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Nga herenau yoac forasac febeso, ge imocac negenna ngereeude. Ge imocac here sufu sufunau negen negentegec kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ge babacmeac mema dzuacnuna kongac kpeba dzuacnuna hoeng kongaha feracyunuma kongac ambesare. ");
INSERT INTO ded_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ge negemmana ni sogac sogai nga ubangerec negembesare. Geng sicna kpedzamenec nga ge negemmana yeni monggoc sogaibisia. ");
INSERT INTO ded_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ge kopocsicna imohacnac kicga mesufubesena amma ni ngic ogofocna memanganeyunudarai, imoc dzuacdacna kpac ambeso. ");
INSERT INTO ded_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O Anutu, ge herena kongaha gboria meficgenemma asu gboria nga dindingac meficgema herena manau fainenna. ");
INSERT INTO ded_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Geac hoannunac mi ukununa amma kpetiac Asuga nearunac mi meickena. ");
INSERT INTO ded_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Ge ebicfunac mesinunecac sogac sogai monggoc mengere nemma enactofoc tofoho nga ogomeficac asu nemma nanggenuna. ");
INSERT INTO ded_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ge ifi anna ni singyoackpekpengic geac sing kpouyemmeba kopocsicgoc yeneng ubangina dzigeneu gearu monggoc hagecde. ");
INSERT INTO ded_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O Anutu, memengerecnaac Anutu, ni ngic kopocsiha kpacfu eng kpehomebaiac imohacnac mesinuna. Ge ifi anna ni nedzarannango imocac sogac sogai yegec kunengngoc heigemma geng ebicfunac mesinunec, imoc edeyunubade. ");
INSERT INTO ded_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Kebu, ni enacnango dengeregubadeac enacbibicna mesina. ");
INSERT INTO ded_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ni sesegerec megemba ge imocac songo mi negennade nga sese dema hosuc ohogemba ge imocac negenna ifingoc mi ngereebac. ");
INSERT INTO ded_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","O Anutu, ni ine asuna ebicngo kipac kipactanggea gemba imocngo sesena anude. O Anutu, ubamangangngo ngichereu ebic meficgema kipatanggeu ge imoc hemma naric mi wanade. ");
INSERT INTO ded_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Ge Sionggac songo negemma gombunga ammima Yerusarenggac hocodatoa monggoc heimengere anna. ");
INSERT INTO ded_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ge ifi anna sese gombunga nga dindingac megenni imocac negenna ngereeu sese ohogemma seseyang hafoangoc ohogennide. Neni sese dema burumaka ngiwa aratagau faiyunuma ohogennide. ");
INSERT INTO ded_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Yegecgareng yearu. Yegec yomoc masiki uba modacma heibesonga. Edomingic mong kpara Doege ye Sauroaru kemma yofi edeec, “Dawidi ye Ahimerecac amau kemma kecde.” imohai Dawidingo yegec yofi heiec. O ngic kuctoagagoc, ge Anutuac enac tofoc tofohongic tobanggema kpenec. Ge imocac defefec amma yoac homac osokecnec. Ge ngic kpetotieyununa kpac anggecde, ifi negemma asoacnac kemma marai negeng areng angkecnec. ");
INSERT INTO ded_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Ge nedzarangga imoc resa enaragoc, ifi isoc anu ikoc ayemmema kpetotieyunuannec. ");
INSERT INTO ded_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ge manganaac songo homac negemma gombungaac songo mong mi negemma ikocyoac debesonga anggenu yoac fora deneadeac mong mi anggengande, kpac. Selac ");
INSERT INTO ded_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Is, nedzarang ikohagoc, yoac manganango ngicngac memanganeyunuande, ge imocac songo negengannec. ");
INSERT INTO ded_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Anutungo ine kpedzameguu nasoga kpac ambeso. Ye kporucbedzogau hama imohacnac kucgoc meicguma ukuguu kekecnginagoc yeneac bangecfunac meicgudaru imohai monggoc mi kecnade. Selac ");
INSERT INTO ded_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Ngic dindingac yeni imoc hemma kpidohoma kengec amma yarengic hemma dzomoremima yofi degecde, ");
INSERT INTO ded_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Henggec, ngic imoc ye Anutuac hoannu kemma mi sufuec. Ye ine ngicngac ogofora memanganeyunuma yengena dzofinactoaya negenserima kefu wiac imocngo sufu sufuamea anec.” ");
INSERT INTO ded_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Anu oriwa icngo sabayagoc nangande, ni ifi isoc Anutuac amau namba Anutungo yoac dedzege amma imoc modackecde, ni nasoya nasoya wiac imoc negenserikecduae. ");
INSERT INTO ded_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Anutu, geng ua menec, ni nasoya nasoya imocac ubangerec megembade. Geac kpac kuneng, imoc gombunga nga ni imocac negensima fora fingerudeac negemma kecbade. Amma geac enac tofoc tofohongicngacfocga yeneac kicfu geac kpac kuneng heiwayong memibade. ");
INSERT INTO ded_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Yegecgareng yearu. Yegec yomoc maharatac sing masiki uba modacma heibesonga. Dawidingo yegec yofi heiec. Ngicngac negen ngentegecngina kpac, yeni herenginau yofi negemma deandae, “Anutu mong mi kecde, kpac yombong.” Yeni fakangina manganeu faka mangana yombong hania hania angkecma yenearunac mongngo faka gombunga mi anude. ");
INSERT INTO ded_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Anutungo kurumennunac kic fiu mau ngicngac yenengkecde. Ye ngicngac negen negentegecgoc kecma Anutu hofocandae, ngic ifia hofocyunuma kecde. ");
INSERT INTO ded_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Yeni sasawango ine faka gombunga ngadehedacma fakangina manganedaru yenearunac mongngo mong faka gombunga mi angande, mocdong kpac. ");
INSERT INTO ded_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Ngicngo yaka dzegoc neandae, yarengic yeni ifi isoc ngicngacfocna neyunuandae, yeni memeficac Anutu mi kpacgecde. Yeni negen negengtegecngina kpac. ");
INSERT INTO ded_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Ngic ge gugecdeac kpedzucnegec yeni Antungo sicngina kpedzameude. Imocac wiac mong kengehagoc mi fingeru yeni ine kengectoa amma kpidohogecde. Anutungo wayunuecac gameyunuu nanggecde. ");
INSERT INTO ded_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","O, ebicfunac mesi mesi, imocngo Siong, imohacnac habeso, imocac yombong anemmede. Anutungo ngicngacfora mengereyunuu kekecngina ngereeude, imohai Yakoboac areng yeni sogaigecde nga Israeac areng yeni ubangerec negenggecde. ");
INSERT INTO ded_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Yegecgareng yearu. Gitakurere kpema heibesonga. Sifingic yeneng Sauroaru kemma yofi edegec, “Dawidi ye nenanggoc sufuma kecde.” Ifi anggec Dawidingo masikiyegec yofi heiec. O Anutu, ge kpac kunenggaac amma ebicfunac mesinuma kucgango onggonnuna ngic yeneac yoacfu firang ambesare. ");
INSERT INTO ded_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","O Anutu, ge nunumuna negemma yoacnaac kedzac kpena. ");
INSERT INTO ded_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Kuricngic yeni yacma nubeso andae nga ubakpekpe ngicngo Anutuac negenggec engena mi angkecde, yeni ngaba anemma kpebucnubeso andae. Selac ");
INSERT INTO ded_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Foracngoc, Anutu ye memeficngicna. Kebungo kekecna garenggekecdae, yenigoc kecma nanggeyunuu seria nanggecde. ");
INSERT INTO ded_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Ngic neac ngabayoac degec yeng ngadeyoacngina merenu yeni imocac ebic meficgegecde. Kebu, ge yoac modac modac Anutu, imocac memanganeyununa kpac ambisia. ");
INSERT INTO ded_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","O Kebu, ni ubaefac amma geac sese megembade. Ge kpacga gombunga, imocac geac kpac kuneng heiwayong memibade. ");
INSERT INTO ded_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Geng ebicfunac mesinudacma ngabafocna memanganeyununa ni firang amma kicnango yenenai. ");
INSERT INTO ded_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Yegecgareng yearu. Gitakurere nga noc kpema heibesonga. Dawidingo masikiyegec yofi heiec. O Anutu, ge neac nunumunaac kedzac faina wiac monggac kpesigemba ge imoc negemma ihoc bahaoc mi ambesena. ");
INSERT INTO ded_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Ubaebicnango feracnuu negen negennango sicsauc andeac ge negennemma yoacna turunga merennenna. ");
INSERT INTO ded_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Ngabafocna yeni kpeborong kpekecdae nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni kicngina nearu fima ngaba anemma ebicfu fainugec ubaebicgoc kecduae. Yeni ngaba amma nubeso andae. ");
INSERT INTO ded_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Herenau ubaebic mema homecac kengectoa amma kpidohoma manganebeso anduae. ");
INSERT INTO ded_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Ni kpidohoma kengecnuu dzononna fedede. Ni kpidohoba kengectoango feracnuu ubaebicgoc kecduae. ");
INSERT INTO ded_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Ni yofi deduae, “Ni kebesac neng isoc kpegannagoc ambai dede kpututuckema bangec monnu kemma ruae meficgebesare, imocac yombong anende. ");
INSERT INTO ded_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Foracngoc, ni kpututuckema bangec ngiha kpacfu kemma amagerecna ihai mema kecbai. Selac ");
INSERT INTO ded_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Kia firangtoa kpeu ni sufu sufuamana mong meficgema ihai bicbic kpututucke kemma sufubai.” ");
INSERT INTO ded_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","O Kebu, ni taonnu ngic yenemba yeni ngaba angemema yarefaka angandae. Ge imocac negen negengngina kpetotiena yoacnginau tohoemebisia. ");
INSERT INTO ded_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Yeni hadzing tofocnac taonggac odatoa witiau kengha amma yerecgema nangandae nga taong manau tosongo ngicngac tosofocngina memanganeyunugec ebic homac fede. ");
INSERT INTO ded_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Yeni wiac kpetotiegecdeac negen negeng mekecgec, imocngo taong botuhau wiac kuneng ande. Ngic yeni ngicngac ogofocngina ebicfu faiyunugec ubaebicgoc kecdae nga goa yeni ikoc amma hiedzo kiregecandae. Faka imocngo emenecnginau fekecma mi kpac anude. ");
INSERT INTO ded_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Neac ngabangicngo yoac deendema anembac ni naric serima imoc negengkecbai nga ngaba mongngo ubakpekpe anenu yearunac naric sufubai. ");
INSERT INTO ded_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Faka ifia ine gennoc ogona angkecnec. Nerang arennira mocgu amma ge ngic ni isoc amma wegenac kecandipe, ge tosoyombonna, gennoc faka ifia anengkecnecac ubahodung negenduae. ");
INSERT INTO ded_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Neri nerahafoc kecma desogai angkecma habutoagoc Anutuac womonnu nerahafoc kengkefic. ");
INSERT INTO ded_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Homecngo ngabafocna meyunubeso. Yarefakango amangina nga herengina mewakeudeac yeni sebingina gbori femanu homec amau kemebisia. ");
INSERT INTO ded_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Anu ni sifu Anutu kpacba KEBUNGO ebicfunac mesinuude. ");
INSERT INTO ded_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Ebicngo memanuu asoringa anenu ni asoac nga marai amma tofocnac imocac kiacma ebicyoacna edeba yeng ubaudumenna negenude. ");
INSERT INTO ded_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Foracngoc, ngic homac yeni ngaba anemma nubeso andae nga Kebungo dzikacfu garennuma bummenuma onggonnuude. ");
INSERT INTO ded_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Anutungo ngictau tatahau bicngoc tarec amma nasosoc tarude. Ngic imoc, yeni ine ubangina naric mi dzigeneude. Yeni Anutu kengec nga eweheiheigoc naric mi hoanggegecde. Imocac ye neac kiac negemma kpendzennu faiyunuude. Selac ");
INSERT INTO ded_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Tosonango yeac dzadzahac kpema maria sinema ngic ogea kpebeso anec. ");
INSERT INTO ded_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Yeac yoac yumia hosonec kerec isoc deu herea manau ine dzikacngo feu yoac deec, imoc ine ruaegoc yombong kerecdokuya isoc amma soengo yenereande, ifi isoc yenereec. ");
INSERT INTO ded_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Ge ebic sasawa tofohonec, imoc KEBU wamina yeng ebic imoc tofohodacma meserigubeso. Ye ngic dindingac garenggema kpae heimiu wiac mongngo ye meu goroc goroc naric mi anude. ");
INSERT INTO ded_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Ngic yeni ngic ogofocnginaac sac hetinggebeso ayemmeande nga ikocngic, yeni kekecngina kebangau homegecde. O Anutu, geng kpefacyununa yeni teng keme kemeau kemeyombonggegecde. Anu ni negenserigukecbade. ");
INSERT INTO ded_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Yegecgareng yearu. Yegec mong kpara Kebesac neng aga saruc icfu tacde, imocac uba modacma miktangyegec yomoc heibesonga. Firistiareng yeneng Dawidi Gata amau meficgema mendanggegec yeng yegec yofi heiec. O Anutu, ngicngac yeneng ni mematiti anendae nga ngabafocna yeneng asoacnac kemma marai ebicfu fainugec ubaebicgoc kecduae. Ge imocac neac ubaga manganeu. ");
INSERT INTO ded_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","O Kebu Engenatoa, ngabafocna yeni asoacnac kemma marai enacfu faifai amma sebingina meemma mematiti anemma ngaba anengkecdae. ");
INSERT INTO ded_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Ni kengecnuu negenseriguanduae. ");
INSERT INTO ded_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Ni Anutuac yoac dengerema ye negenserikecma kengec mi ambade. Ngic yeneng wiac mong naric mi anenggecde. ");
INSERT INTO ded_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Yeneng asoacnac kemma marai enacfu faifai anemma memangenenukecdae. Yeni ebic hania hania fingecnenudeac negen negengua ebirangoc mekecdae. ");
INSERT INTO ded_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Yeni memanganenugecdeac denegeng amma neac tomai sufuma namma kpebucnugecdeac ayemmeu ni kengha ambadesoc garennukecdae. ");
INSERT INTO ded_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","O Anutu, ge ngicngac areng sasawa yarefakanginaac turunga kpouyemmema herebugaac ebic witicnginau ukuna mau. ");
INSERT INTO ded_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Yeni nukporac anenggec wenac dafiguc ama heidac kefai imocac kpetea osoma medacnec. Amma kickumana bic osoma kibigau ohonec fede, imocac kpetea negensibesena. ");
INSERT INTO ded_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Anutungo nigoc kecde, imoc negenduae. Yeng ni meficnuudeac kpacba imohai ngabafocna dzigenema woragecde. ");
INSERT INTO ded_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Ni Anutuac yoac dengerema Kebuac yoac dengerema ");
INSERT INTO ded_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","ye negenserikecma kengec mi anganduae. Ifi amba bangecngic yeneng wiac mong anenggecdeacsoc mi ande. ");
INSERT INTO ded_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","O Anutu, ni yoac deserima ge edeguai, imoc tofohobesare. Ni ubangerecnaac sese megembade. ");
INSERT INTO ded_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Ge ubaongana homecfunac mesima hanina meserina mong mi tifainggeai. Ge ifi anna ni Anutuac kicfu kekecac kperagiau kecbade. ");
INSERT INTO ded_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Yegecgareng yearu. Yegec kpara: Ge mi kpetotiebesena, imocac uba modacma miktangyegec yomoc heibesonga. Dawidingo Sauro yearunac worama hocsingau sufuma yegec yofi heiec. O Anutu, ge neac ubaga manganeu. Ubaonganagoc geac hoannu sufuduaeac amma ge neac ubamangang negenna. Ni geac kpeganggaac debannu sufuma kecbare kiafirang mangana kpac andacbeso. ");
INSERT INTO ded_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Ni Anutu Engenatoango meficnuudeac kpacduae. Anutu yennoc neac kekecareng uayagoc faima uaya nearu mesidarude. ");
INSERT INTO ded_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Ye memefiha kurumennunac sueu imocngo ebicfunac mesinuude amma ngic mematiti anenggec imoc yenemma game kpekpeu faiyunude. Anutungo yoac dedzege amma imoc modackecde nga ye yoac modac modac Kebu amma faka imoc faiu hanemmeude. Selac ");
INSERT INTO ded_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Raiong yangtoa yeni yang siricfu herenginaac homema bangecngic medacfocngina neyunuandae, ni botucnginau feduaenoc. Ngic yeneac enacngina imoc pokong nga tebemedaha isoc amma nedzarangngina imoc dzikacac soe isoc enara monggoc. ");
INSERT INTO ded_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","O Anutu, afegugec imocngo kurumenga kurumenga ferahema embeso. Ge kucga nga kibikperagiaga bangecfu faina mau bangectoa bangec sokoma fedacbeso. ");
INSERT INTO ded_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Yeneng neac ufic faigecac ni ebic kuneng meficgeba neac sinnu teng mong usuma yenaoc teng imohai kemegec. Selac ");
INSERT INTO ded_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","O Anutu, herenango ge seria meguma kecbade, oc, herenango seria meguma kecbade. Ni yegec heima music mema afegubade. ");
INSERT INTO ded_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Ubaongana ge negengboribesena. Gitakurere ngeni gboribisia. Ni ama negemma yegec heima amabangecac kperagi midibade. ");
INSERT INTO ded_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","O Kebu, ni ngiha ngiha botucnginau ge ubangerec megemma bangec monnunac ngicngac botucnginau namma geac yegec heima dengeregubade. ");
INSERT INTO ded_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Geng yoac dedzege amma imoc modackecnec nga imocngo wiac herea amma kurumenga kurumenga manau naric enude nga ge yoac modac modac Kebu. Geac faka imocngo wiac herea amma sawau emma hoeng kpesereyunuude. ");
INSERT INTO ded_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","O Anutu, ngicngac afegugec, imocngo kurumenga kurumenga ferahama embeso nga ge kucga nga kibikperagiga faina bangecfu mau bangectoa bangec sokoma fedacbeso. ");
INSERT INTO ded_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Yegecgareng yearu. Yegec kpara: Ge mi kpetotiebesena, imocac uba modacma miktangyegec yomoc heibesonga. Dawidingo yegec yofi heiec. Nemu hania hania, ngeni yoara kpac kecma desi desi ua dindingac mi megecde. Ngeni yoacfu ngicngac yeneac yoac isingising ikohau meandae. ");
INSERT INTO ded_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Ngeni herenginango negen negeng mangana arenggekecma maringinanango bangecfu yarefaka fingerudeac ua mederema yemmeandae. ");
INSERT INTO ded_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Ngicngac Anutu ngadehema mangana megecdeac ayemmeande, yeni nonggo heremanaunacngoc sing segema fingecma kecdae. Yeni fingecgecfunacngoc sing segema ikocyoac deandae. ");
INSERT INTO ded_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Yeni marasingngina mangana imoc boidzocac marasing mangana isoc ande nga kpate kedzafongngo kedzaha mefonggeande, yeni ifi isoc andae. ");
INSERT INTO ded_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Boidzoc ifiango dzinacngic ubaudumengngina naric mi negenude nga dzinacngicngo ye tobanggema uatoa mema udumeng gombunga meficgeu kpatengo imoc naric mi negenude. ");
INSERT INTO ded_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","O Anutu, geng enacsicngina dumbengnginaunac kpedzamena. O KEBU, geng raiong gboria baicngina kpetackema meickena. ");
INSERT INTO ded_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Geng sueyununa yeni dokungo worama kengande, ifi isoc kembisia. Nga ngicngac yeneng kpindzing tidzamegec moronggeande, yeneng ifi isoc ge negemmana ngic Anutu ngadehema mangana megecdeac ayemmede, yeni tidzameyunubisia. ");
INSERT INTO ded_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Geng negemmana yeni gowohahacngo homema hoaeande, ifi isoc hoaebisia. Nga geng negemmana yeni sabacngo yadiseri mi amma nonggo heremanaunac homemea fingecma wenackiwa naric mi henude, ye isoc ambisia. ");
INSERT INTO ded_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni sabanginagoc me dzangge dzanggea kecgec yeng meicyunuu kpac ambisia. Enang bebedaha gerecngo dzeu fitickema yacande, Anutuac herebungo dzefiticyunuu yeni ifi isoc yacbisia. ");
INSERT INTO ded_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Yeni kopocsicnginaac turunga ifi fingecyemmeu ngic dindingac yeni imoc hemma sogaigecde. Yeni ngic Anutu wama kopocsic meficgegecdeac ayemmeande, yeneac sacngina tima haningina dzuacgec ");
INSERT INTO ded_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","ngicngac yeneng degecde, “Foracngoc, ngicngac dindingac yeni angammemenginaac foraya gombunga fingecyemmeude. Foracngoc, Anutu kecde, ye bangecfu desi desi ua mekecde.” ");
INSERT INTO ded_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Yegecgareng yearu. Yegec kpara Ge mi kpetotiebesena, imocac uba modacma miktangyegec yomoc heibesonga. Saurongo ngicfora Dawidi kpebugecdeac sueyunuu Dawidiac ama garenggema nanggec yeng yegec yofi heiec. O Anutuna, ge ngabafocna yeneac mariunac mesinuna. Ngic nubesonga andae, geng yenearunac onggonnuna. ");
INSERT INTO ded_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Yarengic nga ngic sacna hetinggebeso ayemmede, ge yeneac mariunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","O Kebu, ni singyoac kpema kopocsic mong mi meficgeai nga yeni ine yagungoc kekecna meickegecdeac nembima ngonducnema tomai kecdae nga yarengic ngabatoanginagoc yeni nugecdeac negemma yoac dzegedae. ");
INSERT INTO ded_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Ni faka mangana mong mi anai nga yeneng ine efaima hama nubeso andae. Ge kic fima ebicna hemma yacma meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","O KEBU, Anutu kurumenggac wasaiareng kunengngina, ge Israe neneac Anutu. Ge gauunac yacma bangec monnunac ngicngac mi negenggudae, yeni sasawa kopocsicnginaac amma turunga kpouyemmena. Ngic ikocngina mesufuma yarefaka arengandae, yeni mi onggongyunubesena. Selac ");
INSERT INTO ded_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Yeni wenasoc ama marai anu dzigenema hama kasi isoc taua kpema taonnu hofoc hofoc kengha angandae. ");
INSERT INTO ded_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Yeni enacnginausing wiac urunggec maude, imoc hembesena. Yeni enacbibicnginaunac wiac urunggec maude, imoc dzikacac beang isoc. Imoc enara monggoc anu deandae, “Mongngo yoacnina naric mi negenude.” ");
INSERT INTO ded_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","O KEBU, geng ine dzomoreyemmema bangec monnunac ngicngac ge mi negenggudae, yeni tenicfu faiyununade. ");
INSERT INTO ded_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","O Anutu, ge neac memeserina nga amana seria, imocac ni kic gearu fibade. ");
INSERT INTO ded_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Anutuna yeng yoac dedzege amma imoc modarude. Ye warainemma kemma sinnu meficnuude. Anutunango sing meficgeu ni firang amma ngabafocna memayunuma yenembade. ");
INSERT INTO ded_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","O KEBU, ngicngacfocna yeneng wiac imoc nigecyunubaac ngabafocna mi kpebucyununa. Ge ngic ifia kucgango memayununa kucmama nga goroc goroc amma kecbisia. O Kebu, ge kasonina. ");
INSERT INTO ded_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Yeni enacnginaunac yoac mangana mau kopocsicgoc amma sowec nga ikocyoac degecde. Yeni wiac imoc negenggec engena anu imocngo botacngina amma meyunubeso. ");
INSERT INTO ded_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Ge herebugango gbokoyunubesena. Oc, ge gbokoyununa kpac andacbisia. Ifi anna bangectoa bangec tegia fekendaeu ngicngac yeneng yofi negenggecde, “Anutungo Yakoboac areng garengyunukecde.” Selac ");
INSERT INTO ded_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Yeni wenacsoc ama marai anu dzigenema hama kasi isoc taua kpema taonnu hofoc hofoc kengha angandae. ");
INSERT INTO ded_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Yeni yaka meficgegecdeac hofocma kengha amma mi gebecyunuudeu ngaba yombong amma arohogecde. ");
INSERT INTO ded_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Ni ine kucgaac amma yegec heigembade. Geng neac amana seria nga ebicnasou geac hoannu haba geng sufu sufuamana angkecnec. Ge yoac dedzege amma imoc modackecnec, imocac asoacngoc ubana miacma fakaga imocac ubangerec yegec heibade. ");
INSERT INTO ded_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","O Anutu, ge memeserina nga amana seria, imocac geac dedengerec yegec heibade. Anutu ge yoac nigoc dedzege amma imoc modacnade. ");
INSERT INTO ded_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Yegecgareng yearu. Yegec kpara: Dzadzahaac lili dzaring, imocac uba modacma miktangyegec yomoc heima ubau faibesonga. Dawidingo yegec yofi heiec. O Anutu, ge nagdenunuma kpetotienunuma neneac ngaba annec. O Kebu, ge monggoc mengerenununa. ");
INSERT INTO ded_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Ge bangec kpemindzahena usoc meu titing kuneng fingeru goroc goroc andeac geng titinga monggoc mengerena. ");
INSERT INTO ded_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Ge ngicngacfocga kpendzengtoau fainunuma waing seria gumecnununa neinggac hanititinina goroc goroc anu sicsaufu kengha aning. ");
INSERT INTO ded_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Ngicngac ge eweheiheigoc hoanggugec yeni ine tebemedahaac sinnunac hesicyununadeac firac mong miacna yeni imoc hemma ihai kpedzucnema nanggecde. Selac ");
INSERT INTO ded_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Ge ngicngacfocga neneac songo negennec, nga ebicfunac mesiyununadeac neni marifoigango dzikacfu meficnununa firang ambisina. Ge nunumuninaac turunga merennemmena. ");
INSERT INTO ded_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Anutu ye womongau tacma yoac deserima yofi deec, “Ni firang amma sogaima Sikeng ama mederema Sukoc bangec tume imoc medereba noboha noboha anu ngicngacfocna yemmebade. ");
INSERT INTO ded_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gireade nga Manasse yeri neac. Efaraing imoc wasai opocna nga Yuda ye ngictau yasuna. ");
INSERT INTO ded_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Moabi imoc dzuac dzuac sokocna nga ni Edonggaru hanitabena ukuba yunuude amma ni firang amma Firistia bangec arohomiba negenggecde.” ");
INSERT INTO ded_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Mongngo nigoc kemma taong odaya seria imohai menuma Edong bangecfu hesicnuma kembeso. ");
INSERT INTO ded_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","O Anutu, gennoc wanunuma ukununudacnec. Ge wasaingicnina yenigoc dzikacfu monggoc mi kengannec. ");
INSERT INTO ded_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Ngicngo meficnunuude, imoc memefihagoc kpac. Imocac gennoc meficnununa ngabafocnina yunubesena. ");
INSERT INTO ded_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Neni Anutugoc namma kuctoaninagoc amma firang annide. Yennoc ngabafocnina mematiti ayemmeude. ");
INSERT INTO ded_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Yegecgareng yearu. Gitakurere nga noc kpema yegec yomoc heibesonga. Dawidingo mitiyegec yofi heiec. O Anutu, ge kpakpacna negemma nunumunaac kedzac kpema negenna. ");
INSERT INTO ded_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Ni bangectoa bangec tegiau namba woubocna kucmama anu kpacguduae. Ge hesicnuna hoc peperandzi herea mong feracnude, imohai kemma nambisira. ");
INSERT INTO ded_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Ge neac sufu sufuama. Ngabafocna yeneng nubeso anggec geng amana herea nga seria annec. ");
INSERT INTO ded_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Ge kporucbedzogau fainuna ni nasoya nasoya ihai kecbade. Ni geac kpegangga bageu sufuma kecbadeac anende. Selac ");
INSERT INTO ded_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","O Anutu, ni yoac deserima deai, imohai ge imoc negemma ngicngac eweheiheigoc hoangguandae, ge maridzoming desiyemmenec, imoc ni ifingoc desinennec. ");
INSERT INTO ded_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Ge ngictauac kekeha mehereena kifa homac kecbeso amma apangabofora yenembeso. ");
INSERT INTO ded_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Anutu, ye geac kicfu nasoya nasoya ngictau tatahau takecbeso. Ge yoac modac modac Kebu amma yoac dedzege amma yoacga imoc modackecnecac amma fakaga imocngo ge negemmana ngictau henggareng ammibeso. ");
INSERT INTO ded_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Geng ifi anna ni dedeserina imoc wenacsoc modackecma geac kpac kuneng nasoya nasoya heiwayong memibade. ");
INSERT INTO ded_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Yegecgareng yearu. Yegec kpara: Yehudutung, imocac uba modacma yegec yomoc heibesonga. Dawidingo mitiyegec yofi heiec. Anutungo ebicfunac mesinuu ubaonganango yeac hoannu ruae meficgeude. ");
INSERT INTO ded_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Ye neac hoc peperandzi seria amma ebicfunac mesinuude. Ye amana seria anu mongngo menuu goroc goroc naric mi amba yeng naric mi meicnuude. ");
INSERT INTO ded_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Ngeni ngic kuha kpac ngabaac siricfu kpekecdae, imoc wisickebeso. Ngeni sasawango ye kpema bangecfu ukuyombonggebeso andae. Ye oda kuha kpac nga odabisic dzame dzamea isoc nanu ngeni ye memanganegec todinggema makpeudeac negemma kpekecdae. ");
INSERT INTO ded_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Ye ngickuneng tatahau taru yeni negen negengina arenggema yofi negengandae, “Ye tatahaunac meickebesonga.” Yeni ikocyoac negenggec ngereeu enacnginaunac kenecyoac maande nga herenginango ine sowecyunugecde. Selac ");
INSERT INTO ded_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Ni Anutu negensima tomai kecba foraya fingerudeac ubaonganango yeac hoannu ruae meficgeude. ");
INSERT INTO ded_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Yennoc neac hoc peperandzi seria amma ni ebicfunac mesinuude. Ye amana seria, imocac wiac mongngo menuu goroc goroc naric mi ambade. ");
INSERT INTO ded_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Neac memengerec nga eweheihei imoc Anutuarunac haude. Yennoc neac hoc peperandzitoa seria nga ni Anutuac hoannu kemma sufubade. ");
INSERT INTO ded_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","O ngicngac, ngeni nasoya nasoya Anutu negenserima kecbisia. Yeac hoannu kemma sufuma kecnide. Ngeni herenginau wiac sasawa fedacde, imoc ye edebisia. Selac ");
INSERT INTO ded_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Ngic mamea yeni ngicngo asu naso mocgu heiandae, imoc wiac ifi. Ngic engena kecdae, yeni firang onga ikoha fifiu kpac angande, ifi isoc andae. Sigeriu faiyunugec yeni ebicngina kpac. Yeni efea yombong nga enacasuac ebic sigeriu yeneac ebic ferahede. ");
INSERT INTO ded_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Ngeni hodzinnu wiac mema finacgoc anggecdeac mi negensibisia nga yarefaka amma finacnginagoc anggecdeac mi negensima sicsauc amma imocac tomai kecbisia. Ngeni dzofinacngina monggoc nga mongoc anu mekecgecdeu negen negengngina imohai mi faigec febeso. ");
INSERT INTO ded_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Anutungo naso mocgu yoac yofi deec, imoc atac yohockang anu negenai, “Ni Anutu kuc mingina nga ");
INSERT INTO ded_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","ni yoac dedzege amma imoc modacbade.” Kebu ge ngicngac tembuc tembuc angammemengina hennegeng amma turunga kpouyemmenade. ");
INSERT INTO ded_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Dawidingo Yuda bangec kisiu sufuma kecma mitiyegec yofi heiec. O Anutu, neac Anutuna, ni ge hofocgukecduae, imoc bangec gbangge gbanggeango dokuac ammiande, ni geac ifi isoc anende. ");
INSERT INTO ded_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ni kuc nga eweheiheiga hembadeac kicna aratagau fima genai. ");
INSERT INTO ded_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Geng yoac dedzege amma imoc modackecnec, fakaga imocngo kekec ferahadeac amma dengeregubade. ");
INSERT INTO ded_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Ifi anu ni kecbadesoc kenecgubade amma geac kpacfu numuma marina miacba enu. ");
INSERT INTO ded_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Geng ubaongana yakaac kuc nga kerehagoc megume ammina wakeu enacbibicnango sogac sogaiac yegec heiu enacnango ge dengereguude. ");
INSERT INTO ded_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Ni kecnegeng naso amma tofocnacsoc fefenau fema ge negensiguma geac negensikecma feanduae. ");
INSERT INTO ded_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Gennoc neac memeficngic, imocac geac kpegangga bageu sogaima kecma yegec heigembade. ");
INSERT INTO ded_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Ubaongana gearu kpeketaheu marifoigango nanggenunade. ");
INSERT INTO ded_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Ngicngac kekecna kpetotiebeso andae, yeni ine homec amau kemegecde. ");
INSERT INTO ded_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Yeni dzikacfu kenggec beangngo feracyunuma kpebucyunuu katekasi yeneng sebingina negecde. ");
INSERT INTO ded_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Ngictaungo Anutuac sogaiu ngicngac sasawa yeac kpacfu dedeseri deandae, yeneng yeac negenggec engena angande. Ikocngic yeneac enac ine fitec kpegecde. ");
INSERT INTO ded_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Yegecgareng yearu. Dawidingo mitiyegec yofi heiec. Anutu, ni ebicyoacna edeguba ge ubaudumenna negenna. Ngaba yeneng nubeso andaeac kengecnude. Ge imocac onggonnuna. ");
INSERT INTO ded_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Ngic yeneng Anutu ngadehema mangana megecdeac ayemmeu sufu sufuu yoac dedzege angandae. Geng yenearunac mesufununa yeni mi meficnubisia. Yarengic yeni memanganenugecdeac areng faigec ge mesufununa yeni mi meficnubisia. ");
INSERT INTO ded_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Ngic yeni soe dzumuandae, yeni ifi isoc nedzarangngina dzumugecde. Ngic yeni tebemedaha kpesaima ukuandae, ifi isoc kpesaima yoacngina hodungagoc ukugecde. ");
INSERT INTO ded_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Yeni sufuma fema ngic kopocsic mong mi meficgeec, ye wedecandae. Yeni kengecngina kpac kecma bic yombong wedecgecde. ");
INSERT INTO ded_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Yeni yarefaka megecdeac negen negeng seria mekecma ning kpema sufu sufuu subangina idegecdeac yoac denegeng angandae. Yeni yofi negemma deandae, “Mongngo naric mi nenenude, kpac.” ");
INSERT INTO ded_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Yeni mangana dedzege amma deandae, “Neni wiac imoc gombunga yombong arenggedinggac naric annide.” Foracngoc, ngic ubaherenginaac negen negeng, imoc keme kemea yombong, i. ");
INSERT INTO ded_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Ifi ammagec Anutungo tebea yenearu kpesaima wedecyunuu yeni bic yombong kubecnginagoc amma mayunuude. ");
INSERT INTO ded_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Ye nedzarangngina mangana imocngo kpetotieyunuu kpac anggec ngicngac ogofocngina yenengandae, yeni faka imoc hemma hata gigigecde. ");
INSERT INTO ded_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Ngicngac sasawa yeneng Anutungo faka meec, imoc negensima deyadigec ngicngac sasawa kengec anggecde. ");
INSERT INTO ded_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Anu ngic dindingac yeni KEBUNGO faka meecac sogaima yeac hoannu hama sufuma kecbisia. Ngicngac uba kongaha kecandae amma herenginau ikoc nga hamangec mong mi fede, yeni Kebuac negenggec wiac engena ambeso. ");
INSERT INTO ded_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Yegecgareng yearu. Dawidingo yegec nga mitiyegec yofi heiec. O Anutu, Siong taonnu ge eriendzong megembesonga nga geac kicfu namma dedzegeninaac fora modacbisina. ");
INSERT INTO ded_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","O Kebu, ge nunumuac turunga merengannec. Bangecngicngac sasawa yeni gearu hakecdae. ");
INSERT INTO ded_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Neni ngicngac ogofocnina memanganeyunuinggac ebic imocngo memanunuu geng singyoac kpeinggac kopocsicnina wanec. ");
INSERT INTO ded_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Geng ngic mong meisinggema hoanggema wangecna womonggau kefudeac haude, ngic imoc ye kenehagoc. Neni geac amaac nga womong kpetiacac gombungagoc kecni gebecnunuu kecnide. ");
INSERT INTO ded_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","O Anutu, memengerecnina, ge nunumunina negemma fakaga mi hehena amma turunga merennemmema ebicfunac mesinununade. Bangec tegia fekende, imocac ngicngacfora nga ngicngac kondung ferahema tegiau kecdae, yeni sasawango kekecnginau wiac fora fingerudeac ge negensiguma tomaiga kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ge kucga heina kemeu kucgango tiki meficyunuma tatacnginau faiyununec. ");
INSERT INTO ded_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Kondung yeni kunengngoc arohogec ge arongina menomanena ning kpegecde nga kondunggac siri udumengtoagoc kpeande, imoc menomanena ning kpema feude. Ge ngiha ngiha yeneac dzomugerec ifingoc menomanenade. ");
INSERT INTO ded_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Ge ngicngac negensinggugecdeac kucfaka meannec, imohai ngicngac bangec feracyunudacma tegiau kecdae, yeni imocac kerectegec anggecde. Geng ama werec wereckengaunac hanahema kemma bangec wenac keme kemeau wisickeude, imohai ubangerec ayemmena ubangerec negemma kunengngoc arohogecde. ");
INSERT INTO ded_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Ge bangec yugucke kia mina bangec kerehagoc yombong anudeac amminade nga Anutuac doku, imohai doku efea kpac fede. Ge bangec ifi mengerema ngicngac semengngina meficgeyemmenade. ");
INSERT INTO ded_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Ge kia dena kpema semeng sereau kia kehema semeng homac nadzicmiude. Ge bangec buriric mesorongaina kia kpema bangec meyumeu bangecac semeng sasawa kenehena fora gombunga fingerude. ");
INSERT INTO ded_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ge kifaacsoc semeng homac meficgena imocngo kifaac iraya isoc anude. Geac hanititigaac bangec imoc kerehagoc nga semengtoayagoc. ");
INSERT INTO ded_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Bangec kisiu ramaburumakaac bangec imoc kpindzingngo wakedarude. Bangec buma yeni ubangerec heigec kemeu sogac sogai anggecde. ");
INSERT INTO ded_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Ramaburumakaac bangec yeni ramaburumaka habu homac wamba isoc heigec kemeu sokodacgecde nga bangec tumia emai imoc semengngo mewakeyunude. Wiac sasawa imoc yeni kpeturanggema arohoma yaiyo kpema yegec heigecde. ");
INSERT INTO ded_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Yegecgareng yearu. Yegec nga mitiyegec. Bangecfu wiac sasawa, ngeni Anutu dendzerenggema yaiyo kpema ");
INSERT INTO ded_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","yegec heima yeac kpac kuneng heiwayong memima ye oyang boyang memima ");
INSERT INTO ded_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","yofi debisia, “Geng wiac angannec, imoc wiac engena yombong, imocac kerectegec andimbe. Ge kucga monggoc, imocac ngabafocga geac bageu kecma ngonducnegecde. ");
INSERT INTO ded_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Bangec sasawango geac kicfu ngocducnema numugemma yaiyo kpema yegec heigendae. Yeni geac kpac kuneng heiwayong memima yegec heidae.” Selac ");
INSERT INTO ded_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Ngeni hama Anutungo ua meec, imoc hembisia. Ye bangecngicngac nenanggoc kecma ua bibiagoc meude. ");
INSERT INTO ded_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Yeng kondung heimerenu bangec kerenga anu ngicngac yeni haningo doku imoc ferecgegec. Ye faka imoc meecac amma nenang sogac sogaigoc kefing. ");
INSERT INTO ded_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Ye nasoya nasoya kuhagocngo wiac sasawa garenggema kiwango bangec monnunac ngicngac sasawa yenemma kefude. Yoackpekpe yeni sebingina mi meembisia. Selac ");
INSERT INTO ded_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Ngiha ngiha ngeni Anutunina kenehema enac udumengnginango ye oyang boyang ammigec ngicngac yeni negendacbisia. ");
INSERT INTO ded_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Yeng garennunuu gbori kecdae, yenigoc kecni ye haninina garenggeu mong mi tiposockenide. ");
INSERT INTO ded_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","O Anutu, imoc yofiac, ngic yeni siriwa isingeandae, geng ifi isoc faitobannu fainunuma isinnununec. ");
INSERT INTO ded_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Ge uficfu fainununa kemeni ge ebic kuneng witininau faina imoc tofohokefing. ");
INSERT INTO ded_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Geng negemmana ngic yeneng orucninau tima kenggec. Neni gerec manau kehema dokuu kemema kening, fora. Nga geng yaguc menunuma amabangec tumiatoau fainununa wiac monggac mi obohonide. ");
INSERT INTO ded_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Ni womonggau hama sese ohogemma wiac ambadeac dedeseri deai, imoc ambade. ");
INSERT INTO ded_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Ni ebicfu kecma wiac ambadeac enacbibicnango yoac deserima deai nga yoac enacnango deai, imocac ");
INSERT INTO ded_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","ramaburumaka kerehagoc sese negemma gembade. Nga rama ngiwa sese dema ohoma hosuc heima burumaka nga noning ngiwa gemba sese ambeso. Selac ");
INSERT INTO ded_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Ngicngac Anutu eweheiheigoc hoanggeandae, ngeni hama yoacna negembisia. Yeng nearu ua meec, imoc edengunuba. ");
INSERT INTO ded_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Enacbibicnango ye kunengngoc kpacba nedzarannango ye bic afeheec. ");
INSERT INTO ded_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Ni ngicngac ogofocna memanganeyunubadeac negen negeng herenau arenggebai dede Kebungo neac kedzac mi kpebac. ");
INSERT INTO ded_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Amma forangoc, Anutungo negennemma nunumunaac yoac negensima kefec. ");
INSERT INTO ded_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Ye nunumuna mi ngadehema yoac nigoc dzegeec, imoc mi waec, imocac Anutu kenehebesonga. ");
INSERT INTO ded_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Yegecgareng yearu. Yegec nga mitiyegec, gitakurere nga noc kpema heibesonga. Anutungo wosoefac anemmema kenecnunuma kicmesuyango nerarannunubeso. Selac ");
INSERT INTO ded_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Ifi anna ngicngac bangecfu kecdae, yeni geac haniaga negembisia nga ge ebicfunac mesiyununadeac kuc fegende, bangec monnunac ngicngac botucnginau kecdae, yeni imoc negembisia. ");
INSERT INTO ded_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","O Anutu, ngiha ngiha yeneng afegubisia, yeni sasawango ge yaiyo kpegembisia. ");
INSERT INTO ded_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Ge monde mondega kpac kecma ngiha ngiha siric mocguu isingyununade nga bangec monnunac ngicngac sing edzacyununa imoc modacgecdeac yeni ubangerec negemma sogac sogai yegec heigembisia. Selac ");
INSERT INTO ded_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","O Anutu, ngiha ngiha yeneng afegubisia, yeni sasawango ohecga megembisia. ");
INSERT INTO ded_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Anutu ye nenang Anutu. Yeng kenecnunuu bangecngo semeng gombunga meficgenemmeude. ");
INSERT INTO ded_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Anutungo kenecnunubeso nga ngicngac bangec tegia fekendaesoc, yeni sasawango ye eweheimima hoanggebisia. ");
INSERT INTO ded_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Yegecgareng yearu. Dawidingo yegec nga mityegec yofi heiec. Anutungo yacma ngabafora yunuu singsararang kpema kecbisia nga yeac modzongina tiande, yeni yearunac worama kendacbisia. ");
INSERT INTO ded_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Firangngo hosuc mefiranggeu kengkecde, geng ifi isoc kporacyununa worama kendacbisia. Ngicngac Anutu ngadehema mangana megecdeac ayemmeande, yeni ge negemmana kerecngo gerec wegenau tacma sisingaiande, yeni ifi isoc Anutuac kicfu sisingaima kpac ambisia. ");
INSERT INTO ded_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Anu ngicngac dindingac, ngeni ubangerec negemma Anutuac kicfu sogaima kecbisia. Ngeni ubangerec homac yombong negemma sogaibisia. ");
INSERT INTO ded_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Ngeni Anutuac yegec heibisia, ngeni yeac kpac kuneng heiwayong memima dedengerec yegec heibisia. KEBU hoennu tacma kengande, ngeni yeac kicfu sogaima yegec heima oeha memibisia. ");
INSERT INTO ded_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Anutungo kpetiac womongau tacde. Ye beging mang ayemmema hodzec yenenggareng ayemmema onggongyunuude. ");
INSERT INTO ded_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Anutungo ngicngac dzengong amagerec meficgeyemmeu tosofocnginagoc kecgecde. Ye witicngic witicamaunac mesiyunuu yeneng mama kecma wiac monggac mi obohogecde. Yoackpekpe ngic yeni ine bangec dzangge dzanggeau kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O Anutu, geng warac ngicngacfocga waraiyemmema bangeckisiusing wangecyununa kenggec. Selac ");
INSERT INTO ded_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Imohai bangecfu usoc meu Anutu, Sinai bangec gbangge gbanggeac Anutu amma Anutu, Israeac Anutu, kurumenga kurumenga yeneng geac kicfu kia faigec maec. ");
INSERT INTO ded_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","O Anutu, geng kia faina bangecfu mau dokuac mi obohoing. Ge bangec gbangge gbanggea soc kpema nemmema kuha mina icngo monggoc kpedzienu bangec imoc kerehagoc anec. ");
INSERT INTO ded_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Ifi anu kpebunggango bangec imohai kemma tacngisigec. O Anutu, ge wiacga homac fedeac ubangerecgaac imoc mema makpekpea yemmena wiac monggac mi obohogec. ");
INSERT INTO ded_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Kebungo yoac deu ngicngac homacngo siduc imoc tofohoma dekperagima ");
INSERT INTO ded_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","degec, “Ngictau yeni wasaingicfocnginagoc bic kemma woradacgec ngicngo dzikacfu firang amma iwai megec ngac yeneng amanginau kecma imoc hedzicma megecde. ");
INSERT INTO ded_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Amma dzikacac hepuc amau tacgec yeni neng dzongina siriwa nga gol tengging tengging isoc ifiango sebingina soko sokoa feec.” ");
INSERT INTO ded_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Anutu kpudamuyagocngo ngictau yunuu singsararang kpegec imohai nomang kia isoc mama Dzarimong tiki semeec. ");
INSERT INTO ded_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","O Basang tikitoa tiki, ge bumaga homac nga herea herec, o Basang tiki. ");
INSERT INTO ded_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Tiki bumaga homac nga herea herec, geng nocac kichodung amma Anutuac tikiu kic finec? Anutu yengenaoc tiki yomoc yeac anudeac segerema ye ihai ngictau kecma nasoya nasoya tacyac anude, ge nocac imoc kihodung amma hengkecnec? ");
INSERT INTO ded_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Anutungo dzikacac keretaha tausenga tausenga mehadac. Ye Sinai bangec wama kpetiac womongau emma kecde. ");
INSERT INTO ded_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Geng wi sawau yombong emma witicareng witicyunuma wangecyununa arenggau kenggec. Ngic yeneng ubangerecac wiac genggec. O KEBU Anutu, geng ihai kecnec nga ngic yeni geac modzongina tiu yoacga kpeandae, yeni ifingoc ubangerecac wiac genggecde. ");
INSERT INTO ded_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Kebungo nasosoc sesehenunuma nanggenunukecde, ye kenehebesonga. Anutu ye memengerecnina. Selac ");
INSERT INTO ded_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Anutunina ye memengerec mingina nga KEBU Israeac Anutu, ye homecfunac mesinunuudeac mingina. ");
INSERT INTO ded_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Ye ngabafora yeneac oruc kpedzameu ngic mangana mekecma nasosoc kopocsicnginagoc kecandae, yeneac orucsicngina dzoeagoc hetackeude. ");
INSERT INTO ded_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Kebungo yofi deec, “Ni ngic imoc Basang bangecfunac merengyunubade nga kondung buya keme kemeaunac meyunuma erebade. ");
INSERT INTO ded_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Ifi amba ngeni haningina yeneac sacngo nadzicgecde nga kasifocngina tosea ifingoc yemmegec sacngina aberegecde.” ");
INSERT INTO ded_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","O Anutu, hombanggac habuga arenggoc hagec ngicngac yeneng gengecde. Neac Anutu ngictauna habuya arennu hama kpetiac womongau enu ye henggecde. ");
INSERT INTO ded_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Yegec heihei areng yeneng waraima wiac kpegec music fingecande, yeni wisic wisickeau hagec ngacnaroang yeni tambaringngina kpema botucnginau hadae. ");
INSERT INTO ded_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","“Kpebung habutoa manau Anutu kenehebesonga. O, Israeac fingecsahe, ngeni sasawango KEBU kenehebisia.” ");
INSERT INTO ded_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Benyaming areng yeni areng kapiango enara meyemmeu kendae. Yuda arennunac ngictau kekecac areng habutoango kecmagec Dzeburung arenggac ngictauac areng nga Naftari arenggac ngictauac areng yeni ifingoc modacyunudae. ");
INSERT INTO ded_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Anutu ge kucga kpedzucnema efaina. O Anutu, ge kucgaac hania warac mekperagima edzacnununec, imoc monggoc edzacnununa. ");
INSERT INTO ded_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Womongga Yerusarennu tacdeac ngictau yeneng ubangerecac wiac mehama gendae. ");
INSERT INTO ded_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Yang hania hania dokuac haseng manau kecandae, ge yeneac yoac ngabasiric dena kate burumaka ngiwa yeni habunginagoc kenggec ngic yeneac burumaka medaha kapia botucnginau kecgec ge gorongina kpebesena. Geng yeni memayununa siriwa toseatoa mehama gembisia. Ngic sasawa dzikacac songea negengandae, yeni yununa singsararang kpebisia. ");
INSERT INTO ded_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Ngic kuneng yeni Aigita bangecfunac hagec ngic Etiopia bangecfunac yeni maringina bic miacma Anutuaru hagecde. ");
INSERT INTO ded_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Bangec areng ngictaunginagoc kecdae, ngeni Anutu yegec heimima Kebu yegecfu yaiyo kpemibisia. Selac ");
INSERT INTO ded_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Negenggec, yeng kurumenga kurumenga hanahema fingecgec, yeneac witinginau tacma kende. Ye ubaudumenga miacma kunengngoc yombong kpacde. ");
INSERT INTO ded_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Anutu ye kuhagoc, imoc deyadibesonga. Yeng ngictauac kucgoc amma Israe ngicngacfora garengyunude. Yeac kuc imoc sawau fedengoc. ");
INSERT INTO ded_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","O Anutu, ge damu damugagoc amma ge kpetiac womonggau kecnec. Israeac Anutu ye ngicngacfora gareng anggecdeac kuc nga sebinginaac kuc yemmeude. Anutu kenehebesonga, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Yegecgareng yearu. Yegec kpara Lili dzaring, imocac uba modacma yegec yomoc heibesonga. Dawidingo mitiyegec yofi heiec. O Anutu, dokungo ubanau erema feracnubeso andeac ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Ni goteng dzohonnu kemebeso anduae, imohai titiseriac wiac mong mi fede. Ni doku dzohong kunennu kemeba doku tunggbaungngo semenuu ");
INSERT INTO ded_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","memeficac kiackecba kucna kpac anu ngorucbonna gbanggede. Ni Anutungo meficnuudeac kicfifi kecba kicna kundung kpebeso ande. ");
INSERT INTO ded_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Ngic yeni hania kpacfu ubango ukunudae, yeneac kpete imoc orucdzonaac kpete ferahade. Ngabafocna yeni homac nga ngic kucnginagoc ikoc amma neac ngadeyoac dema memanganenubeso anggecde. Ni wiac mong hamangec mi meai nga yeneng ine turunga yemmebadeac dekecdae. ");
INSERT INTO ded_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","O Anutu, ni kapa ua mekefai, imoc geng negennec nga manganana hania hania, imoc geac kicfu naric mi sufuude. ");
INSERT INTO ded_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","O KEBU Anutu, kurumenggac wasaiareng kunengngina, ge negensigugec fora fingerudeac tomai kecdae, yeni neac amma ngic yeneng game kpekpeu faiyunubauac kpae heiyemmebesena. O Israeac Anutu, ngicngac ge hofocgudae, yeni neac amma eweheiheia kpac kecbauac faka imoc kpetaribesena. ");
INSERT INTO ded_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Yeni geac ammanoc deendema anenggec gamenuu imocngo kicmesuna semeu kicmesuna sufukecduae. ");
INSERT INTO ded_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Ngic ogofocna yeni negennenggec ni monnunac isoc anduae nga dacmunafocna yeni negennenggec kuric isoc anduae. ");
INSERT INTO ded_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Ni amawomonggaac amma herena gerec dzema dzendandannuude nga ge dedenggbaring anggenggec imocngonoc neac witiu enude. ");
INSERT INTO ded_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Ni kiacma yaka waba yeni detenic anenggec ");
INSERT INTO ded_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","ubamanganggac wamba heiba desusuic anenggec. ");
INSERT INTO ded_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Ngicngac yeni taonggac sobennu tacma ni dedzomoc anenggec ngic doku seria neandae, yeni neac kiki kpema yegec heiandae. ");
INSERT INTO ded_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","O KEBU, ni sifu gearu numuduae. O Anutu, geng yoac dedzege amma imoc modackecnec, imocngo mi kpac anudeac amma nasoya hau geng turunga merennembesena. Yoac modac modac Anutu, ge meficnubesena. ");
INSERT INTO ded_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Ni goteng dzohonnu kemebaiac meicnuna. Geng negemmana yeni ngabafocna yeneac mariunac mesinuma doku dzohonnunac onggonnubisia. ");
INSERT INTO ded_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Doku tunggbaungngo semenubaac kpae heimina. Doku dzohongngo gbokonubaac me tengngo menuma naguya heibaac geng kpae heiyemmena imoc wabisia. ");
INSERT INTO ded_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","O KEBU, geng yoac dedzege amma imoc modackecnec, imoc gombunga yombong nga ge wosoefacga efea kpac, imocac kicmesuga nearu monggoc merenna. ");
INSERT INTO ded_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Ge kicmesuga kingang ngicga nearu mi sufubesena. Ebic witiau yombong kecduaeac ge bic yombong turunga merennenna. ");
INSERT INTO ded_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Ge neac wegenac hama bummenuma ebicfunac mesinuma ngabafocna yeneac amma witicfunac mesinubesena. ");
INSERT INTO ded_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Ngic dedenggbaring anemma game kpekpeu fainugec goiheiheia kpac kecduae, ge imoc negemma ngabafocna sasawa negengyunudacnec. ");
INSERT INTO ded_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Yeni dedenggbaring anemma herena kpedzamegecac ubaebictoa meficgema kecduae. Ni negemba goa yeneng neac ubangina manganeudeac kic fima mong mi meficyunuma memeseringic hofocyunuma mong mi meficyunuai. ");
INSERT INTO ded_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Yeni wiac marasing manganagoc nebadeac gumecnuma doku aengagoc nebadeac nenggec. ");
INSERT INTO ded_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Yeneac tatac nasoac nenedoku, imoc geng negemmana botac isoc amma mendangyunubeso nga ogofocnginagoc sesegerec yang negec, imocngo suba isoc amma meyunubeso. ");
INSERT INTO ded_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Yeni ge negemmana kicngina kundung kpeu wiac mong naric mi hemma tinicngina nasosoc dendeng kpekecbeso. ");
INSERT INTO ded_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Ge herebuga yenearu kpakena imoc gerec isoc dzema feracyunuma yeneac witiu feu ");
INSERT INTO ded_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","yeni amabangecngina kisi fingeru ngic mongngo yeneac kporucbedzonginau mi tacbeso. ");
INSERT INTO ded_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Geng ngic hanahema yununa yeneng torokpema yunukporac ayemmedae. Geng ngic dzoboya yununa yeneng kpendzengngina monggoc meyadiandae. ");
INSERT INTO ded_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Geng yoacfu torokpeu torokpe faiyunubesena, yeni geac memengerecfu mi torokpebisia. ");
INSERT INTO ded_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Geng negemmana yeni kpacngina kekecac kibiunac dzuacbesonga amma ngic dindingac kecandae, yeneac kpacarennu mi kpeturanggebesonga. ");
INSERT INTO ded_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Ni ine ubaebicgoc kecma kpendzeng kpema kecduae. O Anutu, ge memengerecgango ni onggonnubeso. ");
INSERT INTO ded_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Ni Anutuac kpac kuneng yegecfu yaiyo kpemima ubangerec memima afeheba ");
INSERT INTO ded_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","KEBUNGO imocac negenu ngereede. Imocngo burumaka ngiwaac sese ferahama burumaka baiha nga gbongagoc, imocac sese ferahade. ");
INSERT INTO ded_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Ngic yeni ogofocngina ebicfu faiyunugec yeneng ubaebicgoc andae, yeninoc imoc hemma ubangerec negembisia. Ngicngac Anutu hofocandae, ngeni herengina kekecgoc monggoc anude. ");
INSERT INTO ded_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","KEBUNGO ngicngac iwaiac obohokecandae, yeneac nunumu negengkecde, ye ngicngacfora witicamau kecdae, yeni naric mi wayunuude. ");
INSERT INTO ded_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Kurumeng nga bangec ngeri ye dengereec kondung nga kondung manau wiac sasawa kenghaandae, ngeni ye dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Imoc yofiac, Anutungo Siong ebicfunac mesima Yudaac taong fekendaemoc monggoc heigboriyunuma amangina meyemmeude. Yeac kingang ngicngacforango tacngisima bangec imoc mema mingina anggecde. ");
INSERT INTO ded_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Kingang ngicfora yeneac nambaracfocngina yeneng maridzoming dema bangec imoc megec ngicngac yeac kpac kuneng songogoc hoanggeandae, yeni ihai kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Yegecgareng yearu. Dawidingo nunumuac mitiyegec yofi heiec. O Anutu, ge hama ebicfunac mesinubesena. O KEBU, ge bic hama meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Ngic kpebucnubeso andae, yeni geng negemmana game kpekpeu faiyunugec oboc kpoboc ambisia. Nga memanganenubeso ayemmeande, geng yeni memayununa eweheiheia kpac kecma dzigenebisia. ");
INSERT INTO ded_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Ngic yofi denengandae, “Naric yombong, naric yombong.” yeni yenang gameyunuu dzigenebisia. ");
INSERT INTO ded_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Anu ngicngac ge hofocgudae, yeni geac amma sogaima ubangerec negenggec ngicngac geac memengerecga songogoc hoanggeandae, yeni monggoc nga monggoc yofi debisia, “Anutu ye engenatoa.” ");
INSERT INTO ded_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Ni ine makpekpea amma iwaiac obohoma kecduae. O Anutu, ge nearu bic hana. Ge memeficna nga ebicfunac yungec yungecngicna. O KEBU, ge naso mi ukuma nearu bic hana. ");
INSERT INTO ded_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","O KEBU, ni geac hoannu hama sufuma kecbade. Ngic yeneng desofoc anembauac nasosoc kpae heiyemmekecma ");
INSERT INTO ded_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","fakaga dindingac modacma ebicfunac yungecnuna. Ge kedzacga nearu faima ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Geng neac hoc peperandzi seria nga sufu sufuamana amma ama seria anembesena. Ge neac hoc peperandzi seria nga amana seria annecac yoac edeyununa ebicfunac mesinubisia. ");
INSERT INTO ded_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","O Anutuna, ge yarengic yeneac mariunac mesinuna. Ngic singkpekpe nga godzungic menugec geng maringinaunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Kebu, ni negen negensinna gearu faiba fora fingerudeac tomai kecduae. Ni hanahema sebigbori kefai kecma yaguc, imoc KEBU negenseriguma kecduae. ");
INSERT INTO ded_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ni nonggo heremanaunac mi fingecmangoc, imohacnac geng naggenuna kefai nga gennoc nonggo heremanaunac meficnunec. Ni nasosoc ge yaiyo kpegembade. ");
INSERT INTO ded_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Neac kekecna imoc ngic homac yeneac kicfu wiac kengehagoc yombong nga gombunga kpac, ifi isoc angande, fora. Nga ge sufu sufuamana seria. ");
INSERT INTO ded_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Enacnau geac dedengerecngo wakeu asoacnac kemma marai ge eweheihei anggembade. ");
INSERT INTO ded_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Ni ngickpengeng ambade, naso imohai ge mi ukunubesena nga kucna kpac anu ge ngadenuma mi wanubesena. ");
INSERT INTO ded_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Ngabafocna yeni neac yoac dema kpebucnubeso amma kpedzucnema denengeng amma ");
INSERT INTO ded_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","yofi deandae, “Anutungo ngic imoc ngadehema wamanu mongngo naric mi onggonggeudeac nenang ngic imoc kisamma kemma meni.” ");
INSERT INTO ded_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O Anutu, neac hereau yombong mi kecbesena. O Anutuna, ge bic hama meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Mesunau nuandae, yeni geng negemmana game kpekpeu faiyunugec kpac ambisia. Ngic memanganenubeso andae, yeni desofoc ayemmegec goiheiheia kpac kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Ni sifu nasosoc ge negensiguma fora fingerudeac tomai kecma monggoc nga monggoc dengeregubadeac anende. ");
INSERT INTO ded_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Enacnango fakaga dindingac edeyunuba geac memengerec uagaac kpetengo engena anu imoc naric mi osobade. Ni asoacnac kemma marai imoc dekperagibade. ");
INSERT INTO ded_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","O KEBU, Israeac Anutu, geng ua kuhagoc mekecnec, ni hama imoc dekperagibade. Ge faka dindingac mingina, imocac ohec megembade. ");
INSERT INTO ded_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","O Anutu, ni sebigborinaungoc kecba geng wiac edekpou anennec nga ni naso yofinenggac kucfakaga wiac engena hemma dekperagima kecduaengoc. ");
INSERT INTO ded_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","O Anutu, ni kpengeng yegbonnagoc ambade, ge imohai ifingoc mi ngadenuna amma mi wanuna. Ge nigoc kecmana fingecsahe hakecgecdesoc, yenearu ifingoc geac kucfaka engena dekperagiyemmebade. ");
INSERT INTO ded_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","O Anutu, geac fakaga dindingac imocngo wi engkecma kurumenga kurumenga kpesereyunuude. Geng wiac engena mema kecnec. O Anutu, ge isoc mong mi kecde. ");
INSERT INTO ded_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Geng negemmana ebic nga wiac mangana homac fingecnenu henai nga gennoc megborinuma kekec monggoc nennade. Ge bangec keme kemeaunac monggoc hesicnuna erebade. ");
INSERT INTO ded_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ge kpacna meyadina imoc eweheiheigoc monggoc anude nga ge monggoc meserinuna herena nomaneude. ");
INSERT INTO ded_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","O Anutuna, ge yoac modac modac Anutu. Ni gitana kpema udumeng gombunga megembade. O, ge Israeac kpetiac ngic, ni gita kpema afeguma ");
INSERT INTO ded_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","dedengerec yegec heigemma enacbibicnango sogaima arohobade. Ge ubaongana ebicfunac mesinec, imocac dengeregubade. ");
INSERT INTO ded_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Ge faka dindingac amma meficnunecac nedzarannango asoacnac kemma marai imoc dekperagibade. Nocac ngic memanganenubeso anggec, ngicngac yeneng yeninoc game kpekpeu faiyunuma wayunugec yeni goiheiheingina kpac anggec. ");
INSERT INTO ded_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Ngictau Saromongngo yofi numuec. O Anutu, ngictau ye geac desi desifakaga dindingacgoc kefudeac derecgemina. Ge ni, ngictauac medac, fakaga dindingacgoc ambadeac derecgenenna. ");
INSERT INTO ded_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Ge ifi anna yeng faka dindingacfu ngicngacfocga yoacngina desibeso nga sing dindingac modacma makpekpea yoacngina desibeso. ");
INSERT INTO ded_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Tiki yeneng ngicngac ruae meficgeyemmebisia nga fagang yeneng dindingac kekecac fora meficgeyemmebisia. ");
INSERT INTO ded_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Ngictauac ngicngacfora tosea makpekpea kecdae, yeni yoacfu nanggeyunuma yoacngina deu firang ambisia. Nga ngicngac iwaiac obohoma eng kecdae, yeni meficyunuma wiac yemmebeso. Ngic mongngo ngicngac ogofora ebicfu faiyunuu ubaebicgoc kecgec ngictaungo hemma kpedzameu kuha kpac ambeso. ");
INSERT INTO ded_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Wenacngo feengkefude, ye imoc isoc kekec herea kecbeso. Nga afo fekefude, ye ifi isoc fekecma ngicngac fingecsahengina fekefudesoc kecbeso. ");
INSERT INTO ded_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Neni semeng uanina mengereni kiango imohai heiande, ye semeng ua ifia isoc amma kiango bangecfu heiu dokuyagoc angkecde, ye bangec ifia isoc ambeso. ");
INSERT INTO ded_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Afo imoc nasosoc fekefude, ifi isocngoc ngictauac nasou faka dindingac sabayagoc amma ruae kunengtoa fefeseri fekecbeso. ");
INSERT INTO ded_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Ngictau ye kondunga kondunga tegiau nga Eufrate dokutoa hanahema bangec tegiau wisickede, bangec imocac mingina amma imoc garenggebeso. ");
INSERT INTO ded_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Ngabafora bangec kisiu kecandae, yeni yeac kicfu ngonducnema sendung nedzarangnginango aberebisia. ");
INSERT INTO ded_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Tarasis bangec nga nuha nuha bangecngina fekendae, imocac ngictau yeneng yeac ubangerec wiac mehama ye mibisia. Arabiaac Saba bangec nga Etiopiaac Seba bangecac ngictau yeneng ifingoc ubangerec wiac mehama ye mibisia. ");
INSERT INTO ded_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Ngictau sasawa yeneng yeac kicfu ngonducnegec bangec monnunac ngicngac yeni sasawango yeac kingang kpemibisia. ");
INSERT INTO ded_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Imoc yofiac, ngicngac iwaiac obohoma kecandae, yeneng ye kpacgec yeng ebicfunac mesiyunuude nga ngicngac makpekpea nga memeficngina kpac kecdae, yeneng kpacgec yeng ebicfunac mesiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Ye ngicngac kucmama nga iwaiac obohokecdae, yeneac uba mangang negemma iwaiac obohokecdae, yeneac kekec onggonggeude. ");
INSERT INTO ded_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Ye yeneac sacngina negenu engena angkecdeac amma ngic yeneng yarefaka amma ogofocngina ebicfu faiyunugec ubaebicgoc kecgec yeng ebicgoc yeneac kekecngina bummema ebicfunac mesiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Ngictau ye naso hereangoc kecbeso. Arabiaac Seba bangecfunac ngicngac yeneng gol mema ye mibisia. Yeac tatahoc numuma asoacnac kemma marai ye kenehebesonga. ");
INSERT INTO ded_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Bangecfu semeng homac fingeru ngicngac yeneng monggoc yakaac mi obohobisia. Semeng imoc tiki buma bumau mekemmeha amma Rebanong bangec isoc ambeso. Taong sasawa fekendae, ngicngac yeneng imohai kecdae, yeni kpindzingngo manennu sabayagoc yombong angande, ifi isoc ambisia. ");
INSERT INTO ded_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Ngictauac kpac kuneng imoc nasoya nasoya feengkecbeso. Wenacngo tatacseri takecde, ifi isoc yeac kpac kuneng deyadigec nasoya nasoya fekecbeso. Yeng bangec monnunac ngicngac sing meficgeyemmeu yeni kenecnginagoc amma yofi debisia, “Ye kenehagoc.” ");
INSERT INTO ded_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","KEBU kenehebesonga. Israeac Anutu yengsac kucfaka engena mekefu neneng imoc negenni wiac engena ande. ");
INSERT INTO ded_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Yeac kpac kuneng imoc kuc nga kibikperagiagoc, imocac nasoya nasoya ye kenehebesonga. Yeac kuc nga kibikperagiango bangeha bangeha sokodacbeso. Imoc fora nga fora yombong. ");
INSERT INTO ded_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Isaiac medac Dawidi, yeac nunumu yofi wisickede. ");
INSERT INTO ded_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Asafango mitiyegec yofi heiec. Foracngoc, Anutungo Israe areng faka gombunga ayemmeude. Ngicngac uba kongaha amma ikoc nga hamangecngina kpac kecandae, yeni faka gombunga ayemmeude. ");
INSERT INTO ded_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Ni ine hanina pososoc anu tifainggema manubeso anec. ");
INSERT INTO ded_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Ngic yoackpekpe angandae nga ngic Anutu ngadehema mangana mebeso ayemmeande, yenemba yeni naric kecma wiac monggac mi obohogec, imohai keracmangang anai. ");
INSERT INTO ded_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Yeni kpendzengngina kpac eng kecma sebingina kuhagoc anu kucmamea kpac kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Ngicngac goa yeni ebicgoc kecandae nga ngic imoc yeneng ine ifi isoc mi kecgecde, kpac. Ngicngac goa yeni kpendzeng kpema kecandae nga ngic imoc yeneng kpendzenga kpac kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Imocac amma yeni yenanggac negenggec wiac engena angkecde, faka imoc kubu isoc ubahema godzufaka ngakpingina isoc heigecde. ");
INSERT INTO ded_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Yeni herenginau negen negeng sicsauc hania hania dzacgoc fema ereu kichabungina ngopic amma yadiande. ");
INSERT INTO ded_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Yeni deendema ayemmema yoac mangac manganea dema ngicngac ebicfu faiyunugecdeac ngabasiricfu yoac degecde. ");
INSERT INTO ded_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Yeni enacbibicnginango kurumeng demanganema nedzarangnginaunac yoacngo bangec ferecgema kenude. ");
INSERT INTO ded_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Imocac ngicngac yeni yeneac hoannu kemma yoacngina imoc doku neandae, ifi isoc efea kpac negebec amma ");
INSERT INTO ded_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","yofi deandae, “Autungo wiac imoc naric mi negenude. Anutu Engenatoa ye wiac ifia naric mi negenude.” ");
INSERT INTO ded_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Negenggec, ngic mangana yeni ifia. Yeni nasosoc wiac monggac negengyohoha kpac kecma hiedzongina meyadigecde. ");
INSERT INTO ded_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Foracngoc, herena garenggeba kongaha feec, fakana imoc uaya kpac yombong anec. Ni kopocsicna kpac kecma marina dzuacba wononga kpac anec, fakana imoc uaya kpac yombong. ");
INSERT INTO ded_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Kebungo numengere anengkefu ni asoacnac kemma marai kpendzeng kpekecma asoacsoc kopocsicac amma numengere anenggec. ");
INSERT INTO ded_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","“Ni yoac ifia dekecbade.” Ni ine ifi debai dede nambaracfocgaac areng tobangyunuma ikoc ayemmema wayunubai. ");
INSERT INTO ded_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Nga manganango kuhagoc fekecde, ni wiac imocac hania negentegecbadeac uaya mema negemba osiec. ");
INSERT INTO ded_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Amma ni ngade Anutuac womonnu emma noc wiacngo wisic wisickeau fingecyemmeude, ni imohainoc negentegerai. ");
INSERT INTO ded_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Foracngoc, ge ngic ifia bangec gbafiringau faiyunuma kpetotieyununa kpac andacgecde. ");
INSERT INTO ded_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Yeni bic yombong manganema kpac anggecde. Yeni kengectoa amma kpidohogec wiac imocngo meicyunudarude. ");
INSERT INTO ded_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","O Kebu, ngicngac gau hemma yacma imoc nigecyunuande, yeni ifi isoc. Geng yacma yeni gauac siric andae dema wayununade. ");
INSERT INTO ded_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Ubaonganango negenghodungaiba imocngo herena biring isoc nendanggeu ");
INSERT INTO ded_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","ni ubafong amma negen negenna kpac kecma yang yeneng memanganeyunuandae, ni ifi isoc geac kicfu ubakpekpe anggenai, fora. ");
INSERT INTO ded_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Amma ni sifu gegoc kecba geng marifoinau menunade. ");
INSERT INTO ded_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Ge dederecgeyoac nemma garennukecna wisic wisickeau goiheihei anemma heitainuma hoannunade. ");
INSERT INTO ded_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Kurumennu geng neac areng angkecnec, mongngo kpac. Ni bangecfu ge meficgubadeac anende, wiac monggac mi anende. ");
INSERT INTO ded_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Sebina nga woubocna yeri kucngira kpac ambeso angandapeu dede Anutu geng neac woubocnaac kuc amma ge nasoya nasoya neac Anutu kecnec. ");
INSERT INTO ded_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Foracngoc, geac hereau kecandae, yeni kpac anggecde nga ngicngac geac kicfu faka forau mi kecandae, ge yeneac kekec herecgena kpac anude. ");
INSERT INTO ded_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Nga ni Anutuac wegenac kecba ngereede. Ni KEBU Israeac Anutuac hoannu kemba yeng neac sufu sufuamana amma onggonnuma kecde. Ni geng wiac sasawa annec, imoc desahebade. ");
INSERT INTO ded_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Yegec yomoc masiki uba modacma heibesonga. Asafango yegec yofi heiec. O Anutu, ge nocac wanunuma ukunudacnec? Rama habufocga geac bangecfu kecdimbe, ge nocac herebugango nunuma hosuc isoc kporacnununec? ");
INSERT INTO ded_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Ge kpebung habufocga warac yombong menununec, imoc negenna febeso. Neni geangga maridzoming ngicngac areng annideac geng bummenunuma ebicfunac mesinununec. Geng Siong tikiu tacannec, imoc negenna febeso. ");
INSERT INTO ded_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Ngabafocnina yeneng kpetiac womongga kpetotiedacgec amabangec sesuhasac amma ifi feengkefude, ge hama imoc hembesena. ");
INSERT INTO ded_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Ngabafocga yeni amabangecga kpetiacfu hama kunengngoc arohoma yenang onga hania hania ihai faigec tacde. ");
INSERT INTO ded_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Yeni nagu wi tacde, imocacsing hama wiac icngo memea imoc nakango heima hembarackedacma ");
INSERT INTO ded_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","onga marikibi gombunga icngo memea, imoc naka nga hamango hedzamedacgec. ");
INSERT INTO ded_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Yeni womongga faigec dzema bangecfu maec amma geac kpac kunenggac amagerec, yeni imoc heidzadzu kpema kpedzamegec bangecfu mau ");
INSERT INTO ded_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","negemma degec, “Memayunuyombonggenide.” yeni ifi negemma bangecninau Anutuac kpekpeturangama fekendae, imoc sasawa faigec dzedarec. ");
INSERT INTO ded_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Anu geac faka bibiagoc hengandimbe, imoc monggoc mi hengandimbe nga profete mongngo mi kecde. Ebic imoc noc nasoac kpac anude, imoc nenearunac mongngo mi negende. ");
INSERT INTO ded_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","O Anutu, ngabafocnina yeneng naso dafiguc detenic anggenggecde? Ngabangic yeni nasoya nasoya geac kpac kuneng ngadeheandae, imoc mi ngereede. ");
INSERT INTO ded_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Ge onggongyunuma marigango mi meyununec amma marifoiga segerekecnec, imoc mi ngereede. Ge mariga monggoc mi mesufuma mariga sinema memanganeyununa kpac ambisia. ");
INSERT INTO ded_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","O Anutu ngictauna, gennoc waracngoc kecma kecnecngoc amma ge bangecfu yagucngoc memengerec ua mekecnec. ");
INSERT INTO ded_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Anutu ge kucgango kondung kperecgena yohockang anec nga ge doku dzohonggac wasaiyang orucngina kpedzameyununec. ");
INSERT INTO ded_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Rewiatang ye wasaiyang oruha homac nga gennoc yeac oruha sasawa kpedzamedacma sebia imoc bangeckisiac yang yeni gumecyununec. ");
INSERT INTO ded_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Geng doku kiwa nga doku tunggbaung singngina kpendzicna yeni fingecma hakecdae. Ge doku fefeseri hakecgec yeni singngina hedzickena gbanggedacgec. ");
INSERT INTO ded_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Hadzing nga toforec yeri geac. Geng kperagia amma wenac tatacngirau warac faiyuruna seria nandape. ");
INSERT INTO ded_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Ge bangecac ma faima meseriyununec. Geng wenac nga kia naso meficyurunec. ");
INSERT INTO ded_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","O KEBU, ngabafocga yeni ngadeguma deendema anggenggec ngic negen negengngina kpac, yeni geac kpac kuneng demanganeandae, imoc negenna febeso. ");
INSERT INTO ded_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Ni geac kebesac neng isoc anduae, ge kebesacgaac ubaonga onggonggena wasai yang yeneng mi menubisia. Ge ngicngacfocga makpekpea kecdae, yeneac kekec nasoya nasoya mi nigecgubeso. ");
INSERT INTO ded_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Bangec noboc noboc kundung kundung imoc godzufakango mewakeu homac fede. Ge dzadzahac menec, imocac negensikecbesena. ");
INSERT INTO ded_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Ngicngac yeni ngicngac ogofocngina meenti memati ayemmema game kpekpeu faiyunubauac kpae heiyemmena ngicngac makpekpea nga iwaiac obohoma kecandae, yeneng geac kpac kuneng heiwayong memibisia. ");
INSERT INTO ded_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","O KEBU, ge yacma geangga yoac nanggebesena. Ngic mangana yeneng asoacnac kemma marai geac dedzomoc angandae, imoc negenna febeso. ");
INSERT INTO ded_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Ngabafocga yeneng kunengngoc arohogec, imoc mi nigecguu yeneng nasosoc yoackpekpe kunengngoc kpekecdae, ge imoc mi nigecgubeso. ");
INSERT INTO ded_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Yegecgareng yearu. Yegec kpara Mi kpetotiebesena, imocac uba modacma yegec yomoc heibesonga. Asafango mitiyegec yofi heiec. Anutu, geac kpac kuneng wegenac fedecac amma ge ohec megendimbe. Ngicngac yeni kucfakaga negenggec wiac engena angkecdeac imocac yoacsiduc deandae. ");
INSERT INTO ded_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ge yofi denec, “Ni monde mondena kpac nga kecma naso mong faiba hau faka angammemengina isinggema desibade. ");
INSERT INTO ded_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Bangec nga bangecfu ngicngac kecdae, yeni imohai goroc goroc amma kockpac anggecde. Ni neannaoc bangecac wotungtoa meseriyunuma nanggeyunuma kecduae.” Selac ");
INSERT INTO ded_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Ngic yeni yenanggac negenggec wiac engena anu yoac homac osoandae, yeneac yofi debade, “Ngeni ngenanggac negenggec wiac engena angkecde, yoacngina imoc wadacbisia.” Nga ngicngac Anutu ngadehema mangana megecdeac ayemmeande, yeni yoac yofi edeyunubade, “Ngeni kucngina mi miacbisia. ");
INSERT INTO ded_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Ngeni kucngina wi kurumennugeng miacma ubangina meemma yoackpekpe kpeandae, faka imoc wadacbisia.” ");
INSERT INTO ded_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Imoc yofiac, ngic mong ye wenac ere ereaunac me wenac keme kemeaunac bangec kisiunac haude, ye ngic ogea miarudeacsoc mi ande, kpac. ");
INSERT INTO ded_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Anutungo desi desi ua mekecma ngic mong memama ngic ogea miarude. ");
INSERT INTO ded_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","KEBUNGO mariau kpakenec mong menande, imocac manau Anutuac ngabaac waing faifaia, imoc wiac homunagoc yerec yerecgea kporoc tima wake wakea fede. Ye imoc bangecfu kpakedaru ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneng doku mangana imoc hafoangoc nedacgecde. ");
INSERT INTO ded_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Ni nasosoc sogac sogaigoc kecma Yakoboac Anutu yegec heimima dengerebade. ");
INSERT INTO ded_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Ngic Anutu ngadehema mangana megecdeac ayemmeande, minginango yeneac kucngina meickeu kpac anu ngic dindingac yeneac kucngina monggoc meenude. ");
INSERT INTO ded_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Yegecgareng yearu. Gitakurere nga noc kpema yegec yomoc heibesonga. Asafango mitiyegec yofi heiec. Yuda bangecfu Anutu negengkecdae nga Israe bangecfu yeac kpac kuneng heiwayong memigecde. ");
INSERT INTO ded_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Yeac bedzo tatahau faigec Sareng bangecfu tacde nga amagereha Sionnu faigec ");
INSERT INTO ded_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","ye imohai kecma tebemedaha piratac isoc hagec, imoc kpetackema dzikacac kaso nga beang nga noc, imoc sasawa kpetackedarec. Selac ");
INSERT INTO ded_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Anutu, geac kuc nga kibikperagi, imoc wiac engena. Tiki yeni wiac engena amma herea herec yeneng nasoya nasoya fekecdae, ge ngictau kucgagoc engena yombong, imocngo yeni feracyunuude. ");
INSERT INTO ded_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Ngic ubaherengina kuhagoc kecandae, yeni serima kecma iwai dzikacfu megec goa yeneng firang amma yenang wiacngina wangecyunugec. Ngic kucnginagoc yeni todinggema mama homema fegec nga wasaingic yeni maringina miacgecdeacsoc mi anggec. ");
INSERT INTO ded_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","O Yakoboac Anutu, ge yoac seria ngabasiricfu edeyununa becosi nga ngic witiau tacma kisangyunuandae, yeni mayunuu homema fegec. ");
INSERT INTO ded_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Geac kengectoa negembesonga. Ge herebu negemmana ngic mongngo geac kicfu nanudeacsoc mi ande, imoc kpac yombong. ");
INSERT INTO ded_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Anutu, ge kurumenga kurumenga fekendae, imohai tacma imohacnac desi desiyoacga dena bangecngo kengec amma waickeec. ");
INSERT INTO ded_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Ge foraya dede nasoya fainadeac yacnec, imohai ifi fingerec. Ngic yeni ngic ogofocngina ebic meficgeyemmegec yeneng ubaebicgoc kecgec geng ebicfunac mesiyunudacnadeac hanec. Selac ");
INSERT INTO ded_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Bangecngic yeneac herebu, imocngo ge dengereguude. Ge herebuac tosea kebanggau dzegena dzikacac wiacga ande. ");
INSERT INTO ded_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Ngeni KEBU Anutunginaac kicfu yoacngina deserima imoc modacbisia. Bangec monnunac ngicngac yerecgema kecdae, ngeni Anutuac kengec amma ubangerec wiac mehama mibisia. ");
INSERT INTO ded_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Nocac yeng ngictau medacfocngina yeneac onganginaac kuc meickema bangecac ngictau kengectoa meficgeyemmeude. ");
INSERT INTO ded_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Yegecgareng yearu. Yegec kpara Yehudutung modacma heibesonga. Asafango mitiyegec yofi heiec. Ni Anutuaru kunengngoc kpacduae, Anutungo negennudeac seriangoc kpacba. ");
INSERT INTO ded_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Ni ebicnasou Kebu meficgebadeac uatoa mekecma tofocnac kucmamea kpac kecma marina Kebuaru miackecba ubaonganango memeseriac memefic naric mi meude. ");
INSERT INTO ded_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Ni Anutu negensiba asoringa anenu ye hennegeng amma negensikecba ongana ebiriude. Selac ");
INSERT INTO ded_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Geng kicna tapea miacna gauya kpac kecba herenango ebic meficgedeac enacnaunac yoac mong naric mi ereude. ");
INSERT INTO ded_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Ni naso bicngoc feec, imoc negensima kecba kifa bic wisickeec, imoc negemba fede. ");
INSERT INTO ded_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Ni yegecna negemba fede, imoc tofocnac negensiba asunango negengising anu herenango imoc hennegeng amma negensiude. ");
INSERT INTO ded_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Kebu ye nasoya nasoya wanuma gombunga monggoc mi anenude.” ni negengyohoc amma ifi negemma kecduae. ");
INSERT INTO ded_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","“Yeng yoac dedzege amma imoc modackecde, fakaya imoc yaguc kpac amma nasoya nasoya kpac andarude. Nga ye yoac deserima deec, imoc yaguc kpac anu nasoya nasoya kpac andarude.” ifi isoc ande. ");
INSERT INTO ded_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","“Anutungo wosoefac anemmeande, imocac nigeckpeec nga ubamangang anemmeande, fakaya imoc ngaba amma kpae heimiec, ifi isoc ande.” Selac ");
INSERT INTO ded_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Ifi negemma yofi deai, “O Kebu Engenatoa, ge mariga warac angkefec, ifi isoc monggoc mi amma siriha merennecac ubahodunggoc kecduae.” ");
INSERT INTO ded_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","KEBUNGO faka warac meec, imoc negensibade. Oc, geng warac kucfaka bibiagoc menec, imoc negen negennau faiba fekefude. ");
INSERT INTO ded_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Geng ua sasawa medacnec, imoc hennegeng amma negensikecba geac kucfakaga engena, imoc ubangerecgoc negensima kecbade. ");
INSERT INTO ded_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","O Anutu, geac sing imoc kpetiac. Nemu mongngo Anutunina mi feraheude, kpac. ");
INSERT INTO ded_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Anutu ge mocgungo kucfaka bibiagoc mekecnec. Ge kucuaga ngicngac areng botucnginau mena yeneng imoc bic henggec. ");
INSERT INTO ded_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Ge mariga kuhagocngo ngicngacfocga Yakobo nga Yosefeac gboricfora bummeyunuma ebicfunac yungecyununec. Selac ");
INSERT INTO ded_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","O Anutu, doku nga dzohong yeneng warac gemma kengec anggec. Bangec manau keme kemeango gemma dendeng kpeec. ");
INSERT INTO ded_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Hoeng yeneng doku kpakegec sawango gbururung heiu tebemedahango piratac heima noboc noboc kpesaiec. ");
INSERT INTO ded_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Firang kunengngo amabangec heimerenu imocac manau geac gbururunggac udumengtoa fingerec. Geac piratacngo bangeha bangeha mekperagiyunuu bangecngo kengec amma dendeng kpekecfec. ");
INSERT INTO ded_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Geac sing imoc kondungtoa dzongiau kenu singbisicga imoc kondungtoa manau tima kengannec, fora. Nga haniga ongea sifu mi hening. ");
INSERT INTO ded_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Ge ngicngacfocga Mose nga Arong yereac mariu faiyununa yereng rama isoc heitaiyunuma wangecyunuoc. ");
INSERT INTO ded_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Yegec yomoc masiki uba modacma heibesonga. Asafango yegec yofi heiec. Ngicngacfocna, ngeni neac kpoukpouac kedzac faigec enacnaunac yoac mau kedzac faima negembisia. ");
INSERT INTO ded_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Ni yoac heima deba, imoc enacnaunac maudeac ande nga wiac warac kundunnu sufu sufuya feec nga wiac ngade fingecbesande, imocac yoac debade. ");
INSERT INTO ded_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Esangabofocnina yeni warac yoac degec, imoc kedzacngo negening nga imoc negen negenninau fede. ");
INSERT INTO ded_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Neni nambaracfocninango imoc negenggecdeac wiac mong naric mi mesufunide nga fingecsahenina ngade feengkefude, yeni edeyununide. KEBUNGO kuc nga kibikperagiagoc kecma uatoa meec, imoc edeyununide. Nga yeng kucfaka bibiagoc mekefec, imocac siduc ayemmenide. ");
INSERT INTO ded_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Kebungo Yakoboac areng dederecgeyoac yemmema edeyunuma kpouyemmeec nga Israe habu dedeseriyoac yemmema edeyunuma kpouyemmeec. Ye esangabocfocnina yeneng nambaracfocngina edekpou ayemmegecdeac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Fingecsahe ngade feengkefude, yeneng imoc negenggecdeac negenec. Nga nambaracfocngina mi fingecgecngo ngade fingecgecde, yeni imoc negenggecdeac edeyunugecde. ");
INSERT INTO ded_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Ifi anggec yeneng Anutu negensima fora fingerudeac tomai kecma yoacngina negemma Anutuac kucfaka bibiagoc mi nigecyunubeso. Yeni yeac nonoyoac tofohoma kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Yeni mangesafocngina yeni isoc ambauac ifi anec. Mangesafocngina yeni serima kecma yoackpekpe areng amma herenginango ye seria mi modacgec nga asunginango Anutu wama kecgec. ");
INSERT INTO ded_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Efarainggac areng tebe mema kecma dzikac nasou dzigenema woragec. ");
INSERT INTO ded_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Yeni Anutungo dzadzahac meec nga yeac dedeseriyoac mi modacma wadacgec. ");
INSERT INTO ded_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Yeng wiac bic meec nga kucfakaya bibiagoc edzacyunuu kicnginango imoc henggec, yeni wiac imoc nigecyunudarec. ");
INSERT INTO ded_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Ye Aigita bangecac Dzoang yeneac bangec nobohau esangabo yeneac kicfu kucfakaya bibiagoc meec. ");
INSERT INTO ded_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Ye kondung kperecgeu doku tegecma yohockang amma noboc noboc emma serima nanu yeng sing faiyemmeu yeni botuhau ferecgema kenggec. ");
INSERT INTO ded_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Yeni wenacfu hoengngo waraiyemmema hesicyunuec nga tofocnac gerecac kperagingo mekperagiyunudarec. ");
INSERT INTO ded_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Ye bangec kisiu hoc kpendziru keme kemeunac doku efea kpac ereu imoc gumecyunuu nekecgec. ");
INSERT INTO ded_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Ye doku hocfunac kpeu dokungo doku dzuamagoc maande, ifi isoc mama feec. ");
INSERT INTO ded_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Ngicngac yeneng imoc henggec, fora. Nga yeni ine yeac uba kpema kopocsic monggoc meficgema bangec kisiu Kebu Engenatoaac yoac kpekecgec. ");
INSERT INTO ded_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Yeni songongina yaka siriha monggac ayemmeu imocac serima dekecma Anutu igockema ");
INSERT INTO ded_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","yoara kpema degec, “Anutungo bangec gbangge gbanggea yomohai yaka meficgenemmeudeacsoc mi ande, kpac. ");
INSERT INTO ded_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Foracngoc, ye hoc kpendziru dokutoa nga doku tunggbaung endzirango mama feec. Nga yaka ine naric mi nemmeude, kpac. Ye ngicngacfora yang naric mi meficgenemmeude.” ");
INSERT INTO ded_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Imocac amma KEBUNGO yoacngina negemma herebu kuneng yombong negemma Yakoboac areng yenereudeac gerec mong fiu dzeu ngabayango Israe yenearu fingecma feec. ");
INSERT INTO ded_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Yeni Anutu mi negensinggema ye ebicfunac mesiyunuudeac kuctoa femide, imoc mi negenserigec, fora. ");
INSERT INTO ded_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Nga ye sifu hoeng wi sawau edeyunuma kurumenggac nagu witiu ");
INSERT INTO ded_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","uaya meu manna yakango kia isoc witinginau mau ngicngac yeneng negecdeac yemmeec. Ye kurumenggac yaka yemmeu nekecgec ");
INSERT INTO ded_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","yaka efea kpac faiu mau nema kecgec. Bangecngicngo angero yeneac yaka nekecgec. ");
INSERT INTO ded_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Nga yeng kurumenga kurumenga imohai wenac ere ereaunac firang mong sing meficgemima sueu haec. Ye kuhagocngo saot bigeng imocac firang mong ameaunac hesickema hau ngadeau haec. ");
INSERT INTO ded_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Hau sendung homac angande, ye ifi isoc yang homac ukuu kia isoc maec. Neng kpegangnginagoc yeni kpetengina kondunggac sangi isoc anec, yeni kia isoc magec. ");
INSERT INTO ded_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Yeng negemmanu neng yeni ngicngac bedzongina mema nandacgec, imohai mama tacgec. ");
INSERT INTO ded_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Ngicngac yeni songonginango noc wiacac anu derecgegec, imoc yemmeecac ngicngac yeneng neng imoc nema negebec anggec. ");
INSERT INTO ded_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Songongina imoc mi wisickemanu yaka enacnginau femanungoc ");
INSERT INTO ded_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Anutungo ine ngaba ayemmema ngicfocngina kucnginagoc kecgec, yeni kpebucyunuec. Israeac arengfora yeneng semeng sabayagoc isoc kecgec, yenemma memayunuma kekecngina herecgeu kpac anec. ");
INSERT INTO ded_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Ye wiac sasawa ifi anu yeneng ine kopocsic meficgemangoc kecgec. Yeng kucfakaya bibiagoc mekefec, imoc fora. Nga yeneng ine imoc wama mi negensinggegec. ");
INSERT INTO ded_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Ifi anu ye kekecac wenacnaso faiyemmeec. Imoc naso mocgu asu taigec kpac angande, naso ifi faiyemmeu kpac anec. Yeni kengectoa amma kpidohoma ubaebicgoc kecmagec kifangina kpac anec. ");
INSERT INTO ded_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Nga Anutungo yunukpebuc anec, yeni naso imohaingoc ubamereng amma herenginango hofocma ye modacgec. ");
INSERT INTO ded_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Anutu ye yeneac hoc peperandzi seria nga Anutu Engenatoango bummeyunuma ebicfunac mesiyunuec, yeni imoc negenggec feec. ");
INSERT INTO ded_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Nga yeni enacnginango ine kerecyoac ammima nedzarangnginango ikocyoac ammigec. ");
INSERT INTO ded_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Yeni herengina yearu seria mi feu yeac dzadzahac imoc faka forau mi modacgec. ");
INSERT INTO ded_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Yeni kopocsicnginagoc kecgec, forangoc, nga yeng sifu yeneac ubea manganeu manganangina wama mi kpetotieyunuec. Ye naso homac ngabaya dzegema herebuya erebacac imoc kpetarimiec. ");
INSERT INTO ded_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Yeni bangecngicngacsac, ye imoc negenu feec. Yeni ngicngo asu taiu erema kemma monggoc mi dzigeneande, yeni ifiasac. ");
INSERT INTO ded_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Yeni bangec kisiu kecma naso homac yombong yeac yoac kpema bangec gbangge gbanggeau ubaebic fingecmiudeac ammigec. ");
INSERT INTO ded_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Ifi ammima Anutu monggoc nga monggoc faitobannu faima Israeac Kpetiac Ngic heremiac miac ammikecgec. ");
INSERT INTO ded_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Ye kuc mingina, imoc mi negensigec nga yeng ngaba yeneac mariunac bummeyunuma mesiyunuec, wenac imocac mong mi negensigec. ");
INSERT INTO ded_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Ye Aigita bangecfu ngic yeneng negensinggegecdeac kucfaka mi hengena meficgema Soang manennu kucfakaya bibiagoc hania hania mekefec, yeni naso imoc mong mi negensima kecgec. ");
INSERT INTO ded_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Yeng dokutoangina merenu sac andacgec yeni doku imohai negecdeac osigec. ");
INSERT INTO ded_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Mogoc enaragoc areng kuneng yombong sueyunuu botucnginau hama neyunudacgec nga sepeng homac sueyunuu kpetotieyunugec. ");
INSERT INTO ded_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Ye semengngina kpembong gumecyunuu nedacgec uanginaac semeng imoc ipua gumecyunuu nedacgec. ");
INSERT INTO ded_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Ye nomanggbomea kia isoc faiu waing uanginau mama imoc kpetotieu kpac andaru nomang sueu nomangngo figi icnginaac gbomea dzedarec. ");
INSERT INTO ded_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Yeng negemmanu nomanggbomea kia isoc burumakanginaac witiu mama memanganeyunudaru gbumparandang kiafirangagocngo rama nga noning memanganeyunudarec. ");
INSERT INTO ded_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Yeac ngaba imoc gerec dzeande, ifi isoc dzeu ye witiha mesiu yenereec. Ye herea buu mangananginaac amma ubea hodungaiu ubaebic kuneng mema kpetotie uaac angero habunginagoc sueyunuu hagec. ");
INSERT INTO ded_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Ye herea buu imocac singa meficgema homefunac mi onggongyunuec. Ye kekecngina homeac kpae mi faima hafei manganaac enarau faiyunudarec. ");
INSERT INTO ded_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Ye Aigita yeneac warac nambaracfocngina kpebucyunudarec. Ye Hanggac esangabo kporucamanginau kecgec, yeneac kucnginaac waracmedacfocngina sasawa kpebucyunudarec. ");
INSERT INTO ded_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Imoc wisickeu Anutungo ngicngacfora meyunuma rama wangecyunuma waraiyemmeandae, ifi isoc waraiyemmema kenec. Ngic yeneng bangec kisi dokuya kpacfu ramahabu hesicyunuandae, ifi isoc wangecyunuu kenggec. ");
INSERT INTO ded_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Ye yenenggareng ayemmema onggongyunuma hesicyunuu yeni kengeha kpac kecmagec kondungngo ngabafocngina semeyunuec. ");
INSERT INTO ded_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Ye meyunuma yengena bangec kpetiacfu kenec. Ye firang amma ngabafora feracyunuma yengena marifoiaac kuhango tiki imoc warac firang amma meecac ngicngacfora imohai meyunuu kenggec. ");
INSERT INTO ded_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Yeng yeni hagecdeac amma bangec monnunac ngicngac Anutu mi negemmidae, yeni kporacyunuu kenggec bangec imoc Israe habu medereyemmeu yeni amagerecngina ihai feudeac kporucbedzocnginau faiyunuu tacgec. ");
INSERT INTO ded_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Ye ifi anec, fora. Nga yeneng ine Anutu Engenatoa tobanggekecma yeac yoac kpekecma dederecgeyoac mi modacma eng kecgec. ");
INSERT INTO ded_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Yeni mangesafocngina warac angkecgec, ifi isoc Anutu wama ye mi negensinggegec. Ngic yeni tebe gbaring gbaring kpesaigec dindingac mi kengande, yeni ifi isoc ihai nga ihai kenggec. ");
INSERT INTO ded_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Yeni nemu yeneac arata hania hania tiki bumau meyunuma Anutu woseau mema ngaba meficgemima nemunginagoc kecma yeac keracmangang meficgemigec. ");
INSERT INTO ded_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Anutungo imoc negemma herebu kuneng fingecmiu Israe habu wayunudarec. ");
INSERT INTO ded_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Ye amagereha Siro fekefec, imoc wama kporucbedzoya ngicngac yeneac botucfu tarec, imoc ifingoc wama ");
INSERT INTO ded_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","kuhaac katapa wama ngaba yeneac mariu faiu yeneac witicamau feec. Yeng kuc nga kibikperagia wama ngaba yeneac mariu faiu feec. ");
INSERT INTO ded_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Ye maridzomingfora herebu negengyemmema ngicngacfora wayunuu ngic yeneng dzikacac beangngo kpebucyunugec. ");
INSERT INTO ded_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Gerecngo sebigbori medacfocngina yonohou homegec naroangfocngina ngiha kpac kecma memeturanggac yegecngina mong mi heigec. ");
INSERT INTO ded_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Ngic yeneng womong garengfocngina dzikacac beangngo yunuma kpebucyunuu enengfocngina yeni kiac ubamangang anggecdeacsoc mi anggec. ");
INSERT INTO ded_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Anu ngicngo gauunac yacandae, Kebungo ifi isoc amma yarec. Ngic seria mongngo waing dokuac kucfu arohoande, ye ifi isoc arohoec. ");
INSERT INTO ded_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Ye ngabafora yunuma firang amma game kpekpeu faiyunuu nasoya nasoya ifi kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Ye Yosefeac kporucbedzo ngadehema Efarainggac areng mi meisinggema ");
INSERT INTO ded_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Yuda areng meisinggeec. Ye Siong tikiac songo negendeac imoc meisinggema ");
INSERT INTO ded_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","womong kpetiac meec imoc kurumenga kurumenga wi fekendae, yeni isoc anec. Ye bangec meficgema faiu feengkefude, womonga kpetia ifi isoc meec. ");
INSERT INTO ded_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Ye kingang ngiha Dawidi meisinggema rama odaunac meu haec. ");
INSERT INTO ded_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Ye Yakoboac areng garengyunuma yeng waraiyemmeudeac faima Israe habu garengyunuudeac ye faiec. Meisinggeu yeng rama nonggo medac yenenggareng ayemmekefec, ua imoc wama Anutuac maridzomingfora garengyunuec. ");
INSERT INTO ded_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Dawidiac hereu ikoc nga hamangec mong mi feu yenenggareng ayemmema negen negenggoc uaya mema mariango garengyunuma wangecyunuu kecgec. ");
INSERT INTO ded_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Asafango mitiyegec yofi heiec. O Anutu, bangec monnunac ngicngac mi negenggudae, yeneng maridzoming bangecgau eredau. Yeni eweheihei faka mi amma womongga kpetiacfu eregec imoc gotengagoc anu Yerusareng ama kpedzamedacgec amabangec sesuhasac ande. ");
INSERT INTO ded_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Yeni geac kingang ngicngacfocga kpebucyunuma farengngina koec koec nga huntoc yemmegec imocngo yeneac yaka anu neyunugec. Yeni geac ngicngac kpetiac kpebucyunuma sebingina imoc bangecfu yang kecdae, imoc yemmegec negec. ");
INSERT INTO ded_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Yeni sacngina hetinggegec imocngo Yerusareng fekendeu doku isoc nedzima feu farengngina tonggoudeac areng mong mi kefec. ");
INSERT INTO ded_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Ngicngac nenigoc wegenac kecandae nga oronnunuma kecdae, yeneng deendema anemmema dzomorenemmedae. ");
INSERT INTO ded_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","O KEBU, faka imoc wisickeudeac tomai kecdimbe. Ge herebu negennemmena imocngo wisic wisickea kpac fekefude, ifi isoc ande. Nga ge keracmangang anemmena imocngo gerec isoc dzeu mi wisickede, ifi isoc ande. ");
INSERT INTO ded_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Bangec monnunac ngicngac yeneac witinginau herebuga hetinggena mau nga bangec areng goa yeni geac kpac kuneng mi kpacandae, ge herebuga yenearu kpakena mau. ");
INSERT INTO ded_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Yeni Yakoboac areng yaka isoc gbokoyunuma amabangecnina kpetotiegec kisi fede. ");
INSERT INTO ded_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Mang esafocninango kopocsic meficgegec, geng imocac mi negenna feu nga ge imocac turunga mi kpounemmena. Yeni memanunugec wiac sasawa obohoyombonggedimbeac neneac ubaga manganeu bic yombong hama sinnu meficnununa. ");
INSERT INTO ded_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O Anutu memengerecnina, kpacga imoc kuc nga kibikperagiagoc, imocac meficnununa. Ge kpac kunenggaac amma ebicfunac mesinunuma kopocsicnina wana. ");
INSERT INTO ded_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Bangec monnunac ngicngac Anutu mi negemmidae, yeneng yofi debau, “Ngeni Anutungina mong mi hendimbe, kpac.” yeni ifi degec negemba naric mi ande. Ngic yeneng kingang ngicngacfocga sacngina kpakegec, imocac turunga bangec monnunac ngicngac yenearu kpouyemmena neni kicninango hemma nambisina. ");
INSERT INTO ded_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Witicngic asoringa ayemmede, yeneac ebicnginango gearu hasikeu imoc negembesena. Ngic yeneng ngic ogofocngina homegecdeac bic desiyunugec geng hama kuctoagango onggongyununa. ");
INSERT INTO ded_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","O Kebu, ngicngac nenigoc wegenac kecdae, yeni ge deendema anggenggecac kopocsicnginaac turunga naso seweng kekecnginau kpouyemmena. ");
INSERT INTO ded_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Ifi anna neneng ngicngacfocga nga rama habufocga anni geng garennunukecna, neni nasoya nasoya ge eriendzong megennide. Nga fingecsahenina ngade feengkefude, yeneng fingecma nenigoc torokpema ge ifingoc dedengerec anggenggecde. ");
INSERT INTO ded_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Yegecgareng yearu. Yegec kpara Dzadzahaac lili dzaring, imocac uba modacma heibesonga. Asafango mitiyegec yofi heiec. O Israeac rama gareng, ge kedzac faima yoacnina negenna. Geng Yosefeac areng rama habu isoc wangecyununade. Kerobing yeneng miacguma ngictautatacga anggec geng yeneac witiu tacannec, gennoc hama kperagigango nerarannunubesena. ");
INSERT INTO ded_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Ge Efaraing areng nga Bengyaming amma Manasse areng, yeneac kicfu kucga hafoangoc heina kemedaru hama ebicfunac mesinununa. ");
INSERT INTO ded_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","O Anutu, geng monggoc mengerenununa komoc kpenideac kicmesugango mekperaginununa. ");
INSERT INTO ded_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","O KEBU Anutu, kurumenggac wasaiareng kunengngina, ge ngicngacfocga neneac nunumuac ngaba negengkecnec, imoc wisickeudeac tomai kecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Geng kickumanina gumecnununa imocngo yaka nga dokunina ande. ");
INSERT INTO ded_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Geng sing meficgena ngicngac wegenac kecdae, yeneng desofoc anemmeandae nga ngabangic yeneng detenic anemmeandae. ");
INSERT INTO ded_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","O Anutu, kurumenggac wasaiareng kunengngina, ge monggoc mengerenunuma kicmesugango nerarannununa komoc kpebisina. ");
INSERT INTO ded_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Gennoc neni waingkomoha isoc Aigita bangecfunac menunuma hanec. Ge bangec monnunac ngicngac mi negenggudae, yeni kporacyununa woragec neni bangec imohai waing isoc homecnununa kecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Ge waing ic imocac bangec memengere amma homecna ye bangec imohai godea mema kemema fingesahe amma bangec sokodarec. ");
INSERT INTO ded_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Sokodaru fawango tiki fekendae, imoc semeyunuma nokumuc meficgeyemmema yomondzoc ic fawatoanginagoc ifingoc kperacyunuu yeni imocac bageau nanggec. ");
INSERT INTO ded_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Ye fawa sinema imocngo kemma kondungtoanina meficgeu sera sinema Eufarata dokutoa kpeseregec. ");
INSERT INTO ded_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Anu ge odaya hembarackenec, imoc negenni naric mi ande. Ge ifi anna titinga fingeru ngicngac yeneng imohai ferecgedacma ic imocac fora sicsauc mesinec anggecde. ");
INSERT INTO ded_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Nga kateberec ngiwa yeneng godea suruhegec manennu yang yeneng seraac kiwa kirecgenec angandae. ");
INSERT INTO ded_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","O Anutu, kurumenggac wasaiareng kunengngina, ge monggoc nenearu dzigenema nenenna. Ge kurumennunac kicga fina mau nenemma waing ic yomocnec henggareng ambesena. ");
INSERT INTO ded_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Gennoc ic komoha imoc marifoigango homecnec. Gennoc medacga imoc gegoc kefudeac garenggena yadiseri anec. ");
INSERT INTO ded_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Ngic yeneng waing icga imoc kperecgema gerecfu faigec dzeu geng fingecyemmema yoac ngabasiricfu edeyununa yeni manganema kpac ambisia. ");
INSERT INTO ded_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Gennoc ngicga meisinggena kuhagoc anudeac amminec, yeng marifoigau tacmanu marigango nanggebesena. ");
INSERT INTO ded_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Ge ifi anna neneng monggoc mi ngadegunide, kpac. Geng megborinununa geac kpac kuneng kpacma afegunide. ");
INSERT INTO ded_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","O Anutu, kurumenggac wasaiareng kunengngina, ge monggoc mengerenunuma kicmesugango nerarannununa komoc kpebisina. ");
INSERT INTO ded_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Yegecgareng yearu. Gatingic yeneac musiwiac kpema heibesonga. Asafango yegec yofi heiec. Anutu ye kucnina. Ngeni dendzerenggema yegec heimima Yakoboac Anutu sogac sogaigoc arohoma oheha memibisia. ");
INSERT INTO ded_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Ngeni tambaring nga gita amma kurere kpema udumeng gombunga meficgema yegec heibisia. ");
INSERT INTO ded_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Afo gboria mau nga nasotoanina afo dzongiau trampet fifigec arohobeso. ");
INSERT INTO ded_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Anutungo Israeac singyoac ngemmeec. Yakoboac Anutungo yoac ifi deseringemmeec. ");
INSERT INTO ded_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Anutu yengenaoc Aigita bangecfu kemma dzikac kpema firang anec, imohai dederecgeyoac imoc Yosefeac areng yemmeec. Ni ubaudumeng nga yoac warac mi negengkefai, imoc naso imohai negenai. ");
INSERT INTO ded_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Negemba yofi deec, “Ni fuanginaunac ebic mesima maringinaunac uaac sakac ebira meickeba ");
INSERT INTO ded_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","ngeni ebicnginagoc kecma kpacnugec ebicfunac mesingunuai. Ni hoennu gbururunggac manau sufuma yoacnginaac turunga merengngemmema Meriba doku imohai faitobannu faingunuyai.” Selac ");
INSERT INTO ded_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","“O ngicngacfocna, ngeni kedzac faigec goroyoac edengunuba. O Israe habu, ngeni neac yoac negembisia. ");
INSERT INTO ded_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Ngeni anutu furia mong mi mekecbisia nga bangecareng goa yeneac anutu fafoc mi heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Ni ngeneac KEBU nga Anutungina. Nennoc Aigita bangecfunac mengunuma hayai. Ngeni enacngina anggegec mewakengunubade.” ");
INSERT INTO ded_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“Ngicngacfocna ngeneng ine ubaudumennaac kedzac mong mi kpegec, kpac yombong. Israe areng ngeni wanuma neac yoac mi tofohogec. ");
INSERT INTO ded_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Imocac wangunuba ngeni ubaseringinagoc kecma ngenang negen negeng modacgec. ");
INSERT INTO ded_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","O ngicngacfocna, ngeni neac yoac modacma kedzac kpebau, imocac yombong anende. Nga Israe ngeneng neac sing modacbau, imocac homac anende. ");
INSERT INTO ded_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Ngeni ifi ambau neng ngabafocngina bic memayunuma marinango singngina hedzickebai.” ");
INSERT INTO ded_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","“Ifi amba ngicngac KEBU ubango ukudae, yeneng yeac kicfu hama fafoc heimibau. Yeni kopocsicnginaac turunga ebicgoc kecdae, imoc nasoya nasoya feengkecbac. ");
INSERT INTO ded_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Ifi kefu Israe areng, ni wit yaka gombunga ngemmeba nebau nga ni hoc peperandziac kukundzau meficgema ngemmeba nebau.” ");
INSERT INTO ded_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Asafango mitiyegec yofi heiec. Anutungo anutu hania hania yeneac adzoc adzorotoau enara amma tatahau anutu hania hania botucnginau tacma isingyunuma yaocngina desima ");
INSERT INTO ded_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","yofi dede, “Fakangina yomoc mi ngereede, ngeni sing dindingac wama ngic yoacngina desiandae. Ngeni monde monde angandae nga ngic Anutu ngadehema mangana megecdeac ayemmeude, ngeni yeni meficyunukecdae nga fakangina imoc mi wisickede, kpac.” Selac ");
INSERT INTO ded_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","“Ngeni ngic kucmama nga beging kecdae, yeneac yoac sing dindingac modacma desibisia. Ngicngac ogofocngina ebic witiau kecma wiac sasawa obohokecdae, ngeni yenenggareng ayemmema yeneac yoac sing dindingacfu desibisia. ");
INSERT INTO ded_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneng ngicngac kucmama nga iwaiac obohoma kecandae, yeni meyunugec ngeneng meficyunuma yeneac mariunac mesiyunubisia. ");
INSERT INTO ded_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Yeni ine wiac mong mi negemma wiac naric mi negentegecma kundung manau kengkecdae. Ifi anu bangecac titiseri sasawango goroc goroc andae.” ");
INSERT INTO ded_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Ni yofi deai, “Ngeni sasawango anutuareng nga Anutu Engenatoa neac medacfocna.” ");
INSERT INTO ded_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","“Foracngoc, ngeni bangecngic homeandae, ifi isoc homegecde. Ngictauac medacfoc, ngeni ngictau yeneac nambaracfocngina sasawa mayunuande, ngeni ifi isoc mangunuude.” ");
INSERT INTO ded_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","O Anutu, bangeha bangeha ngicngac areng sasawa yeni geac. Imocac ge yacma bangecfu desi desi uaga mebesena. ");
INSERT INTO ded_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Asafango mitiyegec yofi heiec. O Anutu, ge mi waickena amma kedzacga mi kpefonggena, o Anutu, ge eng mi tacna. ");
INSERT INTO ded_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Henna, ngabafocga yeni kpeborongtoa kpedae nga ngic ubango ukugudae, yeni orucngina miacma nandae. ");
INSERT INTO ded_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Yeni geac ngicngacfocga tobangyunugecdeac negemma areng faima yoac dedzege andae. Geng ngicngacfocga nenenggareng amma onggongnunuannec, yeni neninoc memanganenunubeso amma ");
INSERT INTO ded_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","dedae, “Hagec, nenang Israe bangec areng meicyununi kpac andacbisia nga ngicngac yeneng Israe kpacngina monggoc mi negenggec febeso.” ");
INSERT INTO ded_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Yeni uba mocgu amma yoac dedzege amma Israe memanganegecdeac dzadzahac mekecdae. ");
INSERT INTO ded_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Ngic imoc Edonggac areng kporucbedzonginau kecandae. Yeni Ismaeac areng nga Moabi areng amma Hagiri, yeac areng. ");
INSERT INTO ded_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Yeni Gebare nga Among amma Amareke ngic. Yeni Firisti bangecac ngicngac areng nga Tiro taonnunac hagec ");
INSERT INTO ded_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Asiria habu ifingoc yenigoc torokpeyunudau. Yeni kucnginagoc amma Rotiac gboricfora yeni nonggo tacyemmedae. Selac ");
INSERT INTO ded_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Geng warac Midiangbangec kpemeting amminec, ifi isoc yeni ayemmema Kisong doku tegiau ngictau Sisera nga Yabing faka ayecmenec, ge ifi isoc kpemeting ayemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Geng warac Eng Doro amau ngic kpetotieyununa farengnginango bangecfu kerac isoc hoaema kpac anggec. ");
INSERT INTO ded_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Ge ngickunengngina meyununa Orebe nga Dzebe yeri manganeec, ifi isoc ayemmema ngictau yeneac medacfocngina kucnginagoc sasawa meyununa yeni Dzeba nga Dzarimuna ayecmenec, yeni ifi isoc ayemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Nocac yeni degec, “Neni Anutuac manengbangec meni imocngo nenang ambeso.” ");
INSERT INTO ded_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","O Anutuna, geng ngic ifia meyununa sendungngo firannu yerecgeande, ifi isoc yerecgebisia. Ngic yeneng padi seuha firangngo mefiranggeande, ifi isoc mefirangyununa. ");
INSERT INTO ded_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Nga gerecngo ickate dzeande nga gerecborangngo tikiu fekengkecma bangec faiu dzeande, ge ifi isoc amma ");
INSERT INTO ded_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","kiafiranggango kisangyunuma firangngo kuneng kpeu kengectoa meficgeyemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","O KEBU, geng kicmesungina game kpekpeu faiyunudacna yeneng geac kpac kuneng hofocbisia. ");
INSERT INTO ded_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Yeni geng negemmana gameyunuu nasoya nasoya negeng manganggoc kecma imocngo nasosoc mebucyunuu ngicngac yeneng wayunugec kpac ambisia. ");
INSERT INTO ded_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Geac kpac kuneng imoc KEBU. Ge mocgungo bangectoa bangec fekendacde, imocac Engenatoa kecnec, yeni imoc negembisia. ");
INSERT INTO ded_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Yegecgareng yearu. Gatingic yeneac musiwiac kpema heibesonga. Kora medacfora yeneng mitiyegec yofi heigec. O KEBU, kurumenggac wasaiareng kunengngina, geac ama womong imoc songogoc nga sogac sogaigoc wakema fede. ");
INSERT INTO ded_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","KEBU, ni ongaasunango geac womong sobenggaac ammiu imohai kebadeac homema kecde. Ni heresebinango Anutu kekehagoc, yeac sogac sogai yegec heide. ");
INSERT INTO ded_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Dzinuc nengbisic ye ifingoc amea meficgeande nga dzibirarec ye medacfora fingecgecdeac negemma faeha geac aratagau heide. O KEBU, kurumenggac wasaiareng kunengngina, ge neac ngictau nga Anutu. ");
INSERT INTO ded_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Ngicngac geac amau kecdae, yeni kenecnginagoc amma yeni nasoya nasoya dengereguma yegec heigenggecde. Selac ");
INSERT INTO ded_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Ngicngac yeni kucngina gearu fede, yeni kenecnginagoc amma yeneac herenginau Sionggac singtoa modacma Sionnu kenggecdeac ayemmeude. ");
INSERT INTO ded_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Yeni Bakaac kickuma kperemennu ferecgema kengkecmagec dokukiwa homac imohai fingecgecde. Nga semeng homec homecnasoac kia kpema doku dzohongngo bangec imoc mewakeude. ");
INSERT INTO ded_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Yeni kuc meficgema kuc monggoc nga monggoc torokpema mema kengkecma anutu hania hania yeneac Anutu Sionnu henggecde. ");
INSERT INTO ded_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O KEBU Anutu, kurumenggac wasaiareng kunengngina, ge nunumuna negenna. Yakoboac Anutu ge kedzac faina. Selac ");
INSERT INTO ded_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","O Anutu, ge kasonina henna. Ge ngic kerecngo nadzicminec, yeac kicmesuya henna. ");
INSERT INTO ded_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Imoc yofiac, ni geac sobenggau uameme mocgu kecbade, imocngo ama goau uameme tausengngoc kecbai, imoc ferahade. Ni Anutunaac nagugareng nambeso anende nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneac kporuc amanginau naric mi kecbade. ");
INSERT INTO ded_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Nocac KEBU Anutu ye wenac nga kaso. Ye wosoefac nga eweheihei anemmema ngicngac dindingac kecandae, yeni faka gombunga ayemmema wiac gombunga mong naric mi segereyemmeude. ");
INSERT INTO ded_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O KEBU, kurumenggac wasaiareng kunengngina, ngic mongngo negenseriguma kecande, yennoc kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Yegecgareng yearu. Kora medacfora yeneng yegec yofi heigec. KEBU ge bangecga gombunga yombong ammima Yakoboac areng monggoc mengereyununa naric kecgec. ");
INSERT INTO ded_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Ngicngacfocga yeneng ngicngac ogofocngina memanganeyunugec, fora. Nga geng imoc wama kopocsicngina sasawa wayemmenec. Selac ");
INSERT INTO ded_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Ge herebuga wama ngaba gereagoc angkecnec, imoc wadacnec. ");
INSERT INTO ded_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","O Anutu memengerecnina, ge monggoc mengerenununa. Nga neni wosogau meing, imoc monggoc mi negensina. ");
INSERT INTO ded_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Ge neni nasoya nasoya ngaba anemmekecma fingecsahenina fekefudesoc, ge yeneac herebu ifingoc negengkecnade, imoc henni mi ngereede. ");
INSERT INTO ded_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Ngicngacfocga neneng desogai anggenni ngereede. Ge imocac sifu kekecnina monggoc heigborinemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O KEBU, geng yoac dedzege amma imoc modackecnec, imoc edzacnunuma ebicfunac mesinununadeac deserinemmena. ");
INSERT INTO ded_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","KEBU Anutungo yoac deude, imoc negembeso anende. Ngicngac ubaherengina meremma yearu haandae, yeni yeac kpetiac ngicngacfora nga yeng ngicngacfora imoc ruaeyoac edeyunuude. ");
INSERT INTO ded_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Foracngoc, yeac kuc kibikperagiagoc bangecninau fekefudeac amma yeng ngicngac yeac eweheiandae, yenemma ebicfunac mesiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Anutungo yoac dedzege amma imoc modackecde, faka imoc nga yoac modac modacfaka yereng meficemeec dindingac kekec amma ruae kekec yereng titikokoc angemeecde. ");
INSERT INTO ded_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Yoac modac modac faka, imocngo bangecfunac nemonggema ereu dindingac kekecngo kurumennunac fiu maude. ");
INSERT INTO ded_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Fora, KEBUNGO wiac gombunga nemmeu bangecninaac semeng uango semeng monggoc meficgeude. ");
INSERT INTO ded_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Dindingac kekecngo waraimima yeac haniaac sing mengeremiude. ");
INSERT INTO ded_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Dawidingo yofi numuec. O KEBU, ni ngic makpekpeango iwaiac obohoma kecduaeac kedzaga faima yoacnaac turunga merennenna. ");
INSERT INTO ded_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Ni geac enac tofoc tofohoga nga ge neac Anutuna. Ge imocac kekecna onggonggena. Ni geac kingang ngicngo negenseriguma kecduaeac ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","O Kebu, ni asoacnac kemma marai gearu kiackecduaeac ge neac ubaga manganeu. ");
INSERT INTO ded_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","O Kebu, ubaongana memiacma gearu faiduaeac ubaonganaac ubangerec meficgenenna. ");
INSERT INTO ded_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Ge gombunga anemmema kopocsic wanemmenade. O Kebu, geng yoac dedzege amma imoc modackecnec. Nga ngic yeneng hofocgugec geng faka imoc modacma wiac gombunga efea kpac ayemmenade. ");
INSERT INTO ded_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","O KEBU, ge kedzac faima nunumuna negenna. Ni kpesi kpesi amma kiacba ge kedzac kpema negenna. ");
INSERT INTO ded_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Geng turunga merennennadeac ebicnasonau kpacgubade. ");
INSERT INTO ded_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","O Kebu, anutu hania hania kecdae, yeneac botucfu mongngo ge isoc mi kecde. Anu geng ua mekecnec, ua ifi isoc mongngo mi mekecde, kpac. ");
INSERT INTO ded_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","O Kebu, ge bangeha bangeha ngicngac areng meficyununec, yeneng gearu hadacma kicgau fafoc heigemma hama geac kpac kuneng heiwayong memigecde. ");
INSERT INTO ded_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Ge mocgungo Engenatoa kecma faka bibiagoc mekecnec amma geng Anutu. ");
INSERT INTO ded_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","O KEBU, ni yoacga fora modackecbadeac singga kpounenna. Ge herenau ubayohoc meickena geac kpac kuneng eweheiheigoc hoanggebesare. ");
INSERT INTO ded_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","O Kebu Anutuna, ni heregoc ge ubangerec megemma geac kpac kuneng nasoya nasoya heiwayong memibade. ");
INSERT INTO ded_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Geng yoac dedzege amma imoc modackecnec, ge imoc anenna wiac engena ande. Kekecnango emu homec amau feu gennoc kekecna imohacnac mesina ereec. ");
INSERT INTO ded_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O Anutu, ubakpekpe ngic yeneng yacma nubeso anggec yarengic yeni habutoagoc hama kpebucnubeso andae. ");
INSERT INTO ded_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","O Kebu, ge Anutu ubamangang nga wosoefac mingina. Ge ngaba bic mi annade nga geng yoac dedzege amma imoc modackecnec, fakaga imoc wiac engena. Ge yoac modac modacac Kebu nga faka imocngo wake wakea fegende. ");
INSERT INTO ded_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Ge nearu dzigenema neac ubaga manganeu. Ge kingang ngicga kuc nemma kingang ngacgaac medac, imoc ni, ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","KEBU, geng meficnuma meserinunade. Ge imocac ngic ubango ukunudau, yeneng geac fakaga hemma gameyunuudeac geng neac negenna ngereeande, imocac ma mong edzacnubesena. ");
INSERT INTO ded_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Kora medacfora yeneng mitiyegec yofi heigec. KEBUNGO tiki kpetiacfu taong mong faiu fede. ");
INSERT INTO ded_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","KEBUNGO Sionggac nagutoaac songotoa negemma Yakoboac ama noboha yeneac songo ifi mi negenude. ");
INSERT INTO ded_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","O Anutuac taong, geac yoacsiduc imoc damuyagoc. Selac ");
INSERT INTO ded_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","“Bangec areng goa ni negennudae, imoc kpacyunubade, Aigita nga Babirong amma Firisti yeneac bangec nga Tiro amma Etiopia, yeneng deandae, ‘Ngic yomoc ye ihai fingerec.’” ");
INSERT INTO ded_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Engenatoango ye tatahau Sionnu faiu seria tarudeac amma Siong manaungoc degecde, “Ngic yomoc amma ngic imoc, yeni imohai fingecgec.” ");
INSERT INTO ded_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","KEBUNGO bangec areng yeneac kpacngina kpedzucnema arengyunuma yofi ohoude, “Yomocngo ihai fingerec.” Selac ");
INSERT INTO ded_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Yegec fede fedeac ngicngac sasawa yeneng yegec yofi dema heiandae, “Neac dokudzohong sasawa yeni Sionnu tacdae.” ");
INSERT INTO ded_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Kora medacfora yeni yegec yofi heigec. Yegecgareng yearu. Esrangic Hemang amaunac, yeng masiki yegec heiec, ifi isoc yegec yomoc Maharac rennoc, imocac uba modacma heibesonga. O KEBU, Anutuna, ge neac ebicfu mesi mesingic. Ni hadzing tofocnac geac arohoma kiackecba ");
INSERT INTO ded_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","geng nunumunaac kedzac kpena nga kiacnango gearu hau negenna. ");
INSERT INTO ded_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Ubaonganango ebic wakeyombonggeu kekecnango homec ama bic mewegenede. ");
INSERT INTO ded_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Yeni neac yofi negendae, “Ye ngic bic homegec, yeni isoc ande.” Ni ngic kucngina kpac, yeni isoc anduae. ");
INSERT INTO ded_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Ngic wayunuma homec yeneac botucfu faiyunuandae, yeni isoc feduae. Yeni ngic kpebucyunuma kicsereu faiyunugec fedae, ifi isoc anduae. Ge ninigec meficgema neac monggoc naric mi negenna fede, ni ifi isoc anduae. Ge ngic marigaunac meicyunuma monggoc mi garengyununa kpac angandae, ni ifi isoc anduae. ");
INSERT INTO ded_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Ge teng mana keme kemeau kicsere menuma kundung dzic manau fainunec. ");
INSERT INTO ded_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Geac herebungo neac witiu emma mepetannuma kondungsiri isoc semenuna kucna kpac anec. Selac ");
INSERT INTO ded_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Geng ifi anenna ogofocna yeni imoc hemma ngadenuma neac ebic hemma kengectoa amma kpidohoma nandae. Ni witicfu ifi kecduaeac naric mi worabade. ");
INSERT INTO ded_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Ni ubahodunggoc kecba kicna kundung kpebeso ande. O KEBU, ni wenacsoc kpacguma marina gearu sinekecduae. ");
INSERT INTO ded_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Ni homebeso anduae nga ge ngic homemea yenearu kucfaka bibiagoc mi menade, kpac. Homegec yeneng onga amma naric mi yacgecde nga yeni eriendzong naric mi megenggecde. Selac ");
INSERT INTO ded_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Geng yoac dedzege amma imoc modackecnec, ngic kicsereu yeneng yoac imoc mi dekperagiandae nga ge yoac modac modac Anutu, imoc homec amau naric mi deyadigecde. ");
INSERT INTO ded_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Kundung manau geac kucfaka bibiagoc naric mi negenggecde. Nga geng meficyunuma ebicfunac mesiyunuannec, imocngo ninigec amau naric mi fingectegerude. ");
INSERT INTO ded_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","O KEBU, ni sifu asoac anu memeficac kiacgemma arohoma gearu nunumuna faiba haude. ");
INSERT INTO ded_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","O KEBU, ge ni wanuma kicmesuga nearu mesufunec, imocac hania mi negentegecduae. ");
INSERT INTO ded_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Ni sebigborinaungoc kpendzenggoc kecma homecfu heima kefai. Ge kengec efea kpac meficgenenna kpidohoma ubaebicgoc amma memeficna kpac kecduae. ");
INSERT INTO ded_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Geac herebungo semenuu kengec efea kpac gearunac meficgema kengecnuu manganema kpac anai. ");
INSERT INTO ded_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Geac kengectoa imoc asoacnac kemma marai doku tunggbaung isoc yadima oronnuma noboc nobocnac hama semenukefu ");
INSERT INTO ded_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","geng negemmana songo ogona nga arengfocna yeni sasawango wanuma ngadenugec kundungngo tosoyombonna ande. ");
INSERT INTO ded_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Esrangic Etangngo masikiyegec yofi heiec. O KEBU, geng yoac dedzege amma imoc modackecnecac nasoya nasoya yegec heigembade. Ge yoac modac modac Kebu, imoc enacbibicnango dekperagiba fingecsahe fekefudesoc, yeneng imoc negendacgecde. ");
INSERT INTO ded_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Ni yofi deba, “Geng yoac dedzege amma imoc modackecnec, fakaga imoc nasoya nasoya faina fekefude. Ge yoac modac modac Anutu. Kurumenga kurumenga nasosoc fefeseri fekecdae, ifi isoc geac fakaga ifingoc fekefude.” ");
INSERT INTO ded_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Geng yofi denec, “Ni ngicna Dawidi meisinggema yegoc dzadzahac mema ye kingangngicna anu yofi deserima edeai, ");
INSERT INTO ded_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Ni geac gborifocga tatacnginau faiyunuba yeneng nasoya nasoya seria tacgecde. Yeni fingecsahengina fekefudesoc ngictau tatacfu tacma ua imoc torokpeu torokpe medacgecde.’” Selac ");
INSERT INTO ded_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","O KEBU, ge kurumenga kurumenga sing faiyemmena yeni geac kucfaka bibiagoc oyang boyang mebisia. Ge yoac modac modac Kebu, fakaga imoc kpetiac areng yeneac adzoc adzorou dengerebesonga. ");
INSERT INTO ded_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","KEBU, wi sawakebangau ge isoc mong mi kecde. Nga anutu hania hania yeneac medacfocngina kecdae, botucnginau ge isoc mong mi kecde. ");
INSERT INTO ded_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Kpetiac areng yeneac adzoc adzorou tacandae, yeneng yofi negengandae, Anutu ye damu damuyagoc. Ye engenatoa amma yeng kurumenggac areng ye yerecgema nandae, yeni feracyunuu yeneng yeac kengec homac angandae. ");
INSERT INTO ded_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","O Anutu, kurumenggac wasaiareng kunengngina, KEBU, mongngo ge isoc kuhagoc mi kecde. O KEBU, ge yoac modac modac Kebu nga fakaga imocngo orongguma fede. ");
INSERT INTO ded_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Kondungngo kpeborong kuhagoc kpeu geng mingina amma kuha memana siri kuneng kpeu mengisiyununade. ");
INSERT INTO ded_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Ngic yeneng ngic goa yunuma memanganeyunugec, geng Aigita bangec medzamena ifi isoc feec. Ge mariga kuhagocngo ngabafocga kisangyununa yeni singsararang kpegec. ");
INSERT INTO ded_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Ge kurumenga kurumenga yeneac mingingngina nga bangec imoc ifingoc geac. Geng bangectoa bangec nga wiac sasawa ihai fedae faiyununa seria kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Geng bangec noboc noboc not nga saut meficyununec. Taboro nga Herimong tiki yereng sogaima geac kpac kuneng oyang boyang memiecde. ");
INSERT INTO ded_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Fuakpegangga imoc kuhagoc nga mariga imoc kuhagoc, ge marifoiga sawau miacnec. ");
INSERT INTO ded_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Ge fakaga dindingac nga ge sing dindingac modacma yoac desiannec, wiac imocngo ngictau tatacgaac sering ande. Geng yoac dedzege amma imoc modackecnec amma ge yoac modac modac Kebu, fakaga imocngo waraigendape. ");
INSERT INTO ded_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","O KEBU, ngicngac geac kicmesugaac kperagiau kecandae, yeneng afegugecdeac sing negemma sogaima kpacma afeguandae, yenennoc kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Yeni geac kpac kunenggac amma asoacnac kemma marai sogaima kecma fakaga dindinga afehegecde. ");
INSERT INTO ded_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Ge ngicngac imoc yeneac kibikperagi nga kucngina. Amma ge wosoefac anemmena kucninagoc amma firang annide. ");
INSERT INTO ded_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Ngictau ye kasonina nga KEBU ye kasonina mingina. Ye Israeac kpetiac ngic amma yeng neneac ngictau, yeac mingina. ");
INSERT INTO ded_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Ge warac onga nga kpefingyoacfu singyoacga dena ngicngacfocga geac yoac modac modac kecgec, yeni yofi edeyununec, “Ni ngic mong kuhagoc meficgema ye ngictauac ira heimiai. Ni ngicngac yeneac botucfunac sebigbori medac mong meisinggema gununggeai. ");
INSERT INTO ded_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ni kingang ngicna Dawidi meisinggema kerecna kpetiacngo nadzicmiai. ");
INSERT INTO ded_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Ifi anu marinango ye nasoya nasoya nanggema marinaac kucngo meseribade. ");
INSERT INTO ded_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Ngabangic mongngo ye tobanggema naric mi feraheude nga ngic Anutu ngadehema mangana megecdeac ayemmede, yeni ye mi memagecde. ");
INSERT INTO ded_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Ni ngabafora yeac kicfu kpedzameyunubade nga ngic ye ubango ukudae, yeni kpefacyunuba mayunuude. ");
INSERT INTO ded_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Ni yoacna modacma yoac dedzege amma imoc modacbade, fakana imocngo ye garenggekefude. Ni neannaac kpacfu nanggeba yeng kuhagoc amma firang anude. ");
INSERT INTO ded_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ni kondung yeac mariu faiba yeng imoc garenggema marifoiango doku haandae, yeni garengyunuude. ");
INSERT INTO ded_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Yeng kpacnuma yofi deude, ‘Ge Manna nga Anutuna amma memengerecnaac hoc peperandzi seria.’ ");
INSERT INTO ded_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Ni ye meisinggeba yeng neac morocmedac anu bangecfu ngictau yeneac kunengngina anudeac faiba kefude. ");
INSERT INTO ded_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Ni yoac yegoc dedzege amma imoc nasoya nasoya modacma dzadzahacna yegoc mebade, imocngo yegoc fefeseri feude. ");
INSERT INTO ded_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ni Dawidiac nambarac nga esamedac fingeckecgecdesoc tatacnginau faiyunuba nasoya nasoya seria tacgecde. Yeac ngictau tatac nanggeba nasoya nasoya fekefu kurumenga kurumenga yeneac wenac dafiguc fede, kpetea ifi isoc anude.” ");
INSERT INTO ded_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","“Esangaboforango neac dedeseri wama ngadehema dederecgeyoacna kpema imoc mi modacgecdeu ");
INSERT INTO ded_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","me yeni kpema nonoyoac edeyunuai, imoc mi modacgecdeu ");
INSERT INTO ded_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","ni yeneng singyoac kpegecac amma turunga kpouyemmema gbarucngo yunubade. Yeni ngicngac ogofocngina memanganeyunugecac dzikacngo yunuba kpendzeng kpegecde. ");
INSERT INTO ded_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Ni Dawidigoc yoac dedzege amma imoc modacduae, fakana imoc naric mi wangecbade. Ni ikoc mi ambade nga yoac modac modac fakana naric mi wabade. ");
INSERT INTO ded_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Ni dzadzahac meai, imoc mi kpebade nga enacnaunac yoac maec, imoc mengerema siriha mong mi debade. ");
INSERT INTO ded_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Ni naso mocgu kpetiac kekecnau namma dedeseri seria deai, imoc nasosoc fora angkefude, ‘Ni Dawidi ikoc mi ammibade.’ ");
INSERT INTO ded_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Yeac bangecfora yeni kpac angana kpac torokpeu torokpe kecengkecgecde. Wenac kiwango nasoya nasoya neac kicfu fekecde, ngictau yeac ngictau tatacngo ifi isoc fekefude. ");
INSERT INTO ded_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Sawakebanggac hepuc, imoc afo, ye tataha mi wama takecde. Nga ni ngictau tatahau faiba ye ifi isoc nasoya nasoya seria tackefude.” Selac ");
INSERT INTO ded_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Geng kingang ngicga Dawidi kerecdokungo nadzicminec, fora. Nga geng ine yeac herebu negemma ye ngadehema wanec. ");
INSERT INTO ded_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Ge kingang ngicgagoc dzadzahac menec, imoc wana wisickeu ngictau iraya bangecfu sendunnu ukuna gotengagoc andarec. ");
INSERT INTO ded_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Ge yeac taonggac hocoda kpembarackedacma amea seria kpedzamedacna sesuhasac andae. ");
INSERT INTO ded_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Nga ngicngac yeneng imohai ferecge kengha angandae, yeni iwaiya mema woraandae. Ngicngac yeac wegenac kecandae, yeneng desofoc ammidae. ");
INSERT INTO ded_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Ge ngabafora marifoingina memiacna dzikacfu serigec ngabafora sasawa sogaigecdeac sing meficgeyemmenec. ");
INSERT INTO ded_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Fora, ge ngictau dzikacfu mi nanggenec nga yeac dzikacac beang, imocac enara merenna ngadeaubigeng kenec. ");
INSERT INTO ded_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Ge ngictau yasuya mariaunac wangecma ngictau tataha bangecfu ukuna maec. ");
INSERT INTO ded_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Ye sebigbori kecmanu ge wenahaac kpete mewegenena homac mi anec. Ye game kpekpeu faina imocngo ye semeu kecde. Selac ");
INSERT INTO ded_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","O KEBU, ge mesufuemema monggoc kicninau fingecnadeac tomai kecduae. Ge nasoya nasoya ifi sufuma kecnade, ifi isoc ande. Geac herebu gerec isoc dzekecde, imoc wisickeudeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","O Kebu, kekecna imoc wegenacnecsac ande, imoc negenna febeso. Ge ngicac medacfora fainununa eng fingecma kpac annide. ");
INSERT INTO ded_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Ngic mong ye keengkecma mi homeude, ifia mong mi kecde, kpac. Homec amau ngic kucgoc meyunugec ngic mongngo imohacnac naric mi mesiude. Selac ");
INSERT INTO ded_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","O Kebu, geng yoac dedzege amma imoc modackecnec nga yoacga modackecnec, imoc warac Dawidi deserima desiminec, imocac fora hofocduae. ");
INSERT INTO ded_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","O Kebu, yeni ni, kingang ngicga deendema anengandae, imoc negenna febeso. Ngicngac yeneng deendema anenggec ebic imoc herenau tofohokecduae. ");
INSERT INTO ded_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","O KEBU, ge ngictau meisinnuma kerec nadzicnennec nga ngabafocna yeneng ine deendema anengandae. Ni sing tikengkecba yeneng hanititina hemmodacma desusuic anemma yoac mangana denenggecde. ");
INSERT INTO ded_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","KEBU nasoya nasoya kenehebesonga. Imoc fora nga fora yombong. ");
INSERT INTO ded_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Anutuac ngic Mosengo yofi numuec. O Kebu, neni fingecsahenina bic fekefec, geng yeneac sufu sufuamangina angkecnec. ");
INSERT INTO ded_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Ge Anutu, tiki mi fingecmagec geng marigango bangec nga bangectoa bangec mi meficgemangoc imohai bic kecnec. Ge nasoya nasoya kecnec nga kecbesannec. ");
INSERT INTO ded_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Geng yoac dena ngic yeni monggoc sendung anggecde. Ge yofi deannec, “Ngicac nambarac, ngeni monggoc bangecfu dzigenema sendung ambisia.” ");
INSERT INTO ded_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Imoc yofiac, kifa tauseng imocngo geac kicfu uameme mocgu kemma bic kpac andac, ifi isoc ande. Imoc tofocnac monggac noboha isoc ande. ");
INSERT INTO ded_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Ge ngic wanggenununa seuc isoc kengandimbe nga kekecnina imoc gau negengandimbe, ifi isoc ande. Kpindzingngo asoac gborima monggoc ereande, ifi isoc. ");
INSERT INTO ded_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Imocngo asoac gboria nga sabayagoc anu marai anu sokuema ururueude. ");
INSERT INTO ded_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Geac herebungo neni memanganenunuu kpac andimbe. Geac heregerecngo ebicfu fainunuu kecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Neni ngicngac ogofocnina memanganeyununi geng wiac imoc kicgau arenggema hengkecnec. Nga kopocsic sufu sufuu meficgeing, ge imoc kicgaac kperagiu faina feu hengkecnec. ");
INSERT INTO ded_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Anu kekecninaac uameme sasawa geac herebugaac bageau kecni nasonina kpac anude. Ngicngo asoringa ammiu kpac angande, neni kifanina ifi isoc kecni kpac andarude. ");
INSERT INTO ded_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Kekecninaac kpete imoc kifa 70 me kucnina feudeu kifa 80 kecnide. Kifa imocac manau kekecnina gombunga yombong kecandimbe, imohai ine ebic nga ubahodunggoc ifingoc kecandimbe. Kifanina bic meickegec kpac andaru neni kpututukema kendacnide. ");
INSERT INTO ded_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Ngic mongngo geac ngabagaac kuc mi negensiude, kpac. Kengecgoc geac eweheihei kuneng anggembesonga nga heregerecga kuneng imoc ifingoc imocacsoc ande. ");
INSERT INTO ded_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Kekecnina uameme dafigucacsoc fede, imoc negensinideac wiac imoc kpounemmena. Ge ifi anna neni hereninango negen negentegecgoc anude. ");
INSERT INTO ded_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","O KEBU, ge monggoc dzigenena. Naso dafiguc monggoc geac tomai tacbesonga? Ge kingang ngicfocga neneac ubaga manganeu. ");
INSERT INTO ded_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Neni uameme kecnidesoc sogac sogaigoc kecma ubangerec negennideac amma geng yoac dedzege amma imoc modackecnec, imoc asoacngoc mewakenunubesena. ");
INSERT INTO ded_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Ge wenac homac ebicfu fainununec, uameme ifi isocngoc ubangerec nemmena. Neni kifa homac yarefaka hengkefing, imocacsoc ifingoc kifa ubangerecgoc meficgenemmena. ");
INSERT INTO ded_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Geng ua mekecnec, imoc kingangngicfocga nenearu didiu edzacnunuma kucga damu damuyagoc imoc esamedacfocninango hembisia. ");
INSERT INTO ded_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Kebu Anutuninaac ubangerecngo semennunubeso. Ge marininaac ua tataha meficgena seria febeso. Fora, ge marininango ua meandimbe, imoc tataha meficgena seria febeso. ");
INSERT INTO ded_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Anutu Engenatoango ngic mong garenggema mesufuu yeng Kuctoa minginaac debannu kecnegeng kecande, ");
INSERT INTO ded_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","ye KEBU edeude, “Ge sufu sufuamana nga amana seria, ge Anutuna nga ni negenseriguma kecduae.” ");
INSERT INTO ded_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Ye nengmeme ngic yeac botacfunac mesiguude nga homecac hafei manganango memanganegubaac yeng onggongguude. ");
INSERT INTO ded_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Ye kpegang dzoeango kperacguu geng yeac kpeganga bageau sufuma kecnade. Ye yoac modac modac Kebu nga fakaya imocngo geac kasoga amma odaga seria ande. ");
INSERT INTO ded_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Ge tofocnac wiac mong manganaac kengec mi annade nga wenacfu tebemedahaac kengectoa amma naric mi kpidohonade. ");
INSERT INTO ded_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Hafeitoa kundung manau haande, imocac kengec naric mi amma homecac hafei mangana wenacfu fingecma yunuande, imocac kengec mi annade. ");
INSERT INTO ded_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Ngic tauseng yeneng hoanggau namma homegec ten tauseng yeneng foigaugeng namma homegecdeu wiac mangana mongngo gearu naric mi fingerude. ");
INSERT INTO ded_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Ge kicgango yenemmana ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni angammemenginaac amma turunga megecde. ");
INSERT INTO ded_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Geng yofi denec, “Ni KEBUAC hoannu sufuma kecduae nga Kebu Engenatoa ye kecnegeng amana.” ");
INSERT INTO ded_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Yarefakaac ebicngo gearu naric mi hau ebic mangana mongngo geac kporuc amagaac wegenac naric mi haude. ");
INSERT INTO ded_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Ye angerofora uayoac yemmeu yeneng sing sasawa kengkecnec, imohai garenggugecde. ");
INSERT INTO ded_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Ge haniga hocngo heibacac yeneng maringina witiau faiguma sesehegugecde. ");
INSERT INTO ded_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Ge raiong yangtoa witiau nga kpate witingirau eng tikemma raiong sebigbori nga boidzocac witingirau tima tidzameyununade. ");
INSERT INTO ded_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Kebungo yofi dede, “Ye neac songo negemma nigoc kpeketahema kecdeac ebicfunac mesibade. Ye neac kpac kuneng negendeac neng henggareng amma ongonggebade. ");
INSERT INTO ded_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Ye kpacnuu ni turunga meremmibade. Ye ebic witiau kefu ni yegoc kecma ebicfunac mesima eweheihei ammibade. ");
INSERT INTO ded_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ni kekeha mehereeba kecma gebeckpeu memengerecna edzahabade.” ");
INSERT INTO ded_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Sondaac mitiyegec. O KEBU, ge Engenatoa. Ni ubangerec negemma geac kpac kuneng heiwayong memima yegec heigemba, faka imocngo ngereede. ");
INSERT INTO ded_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Geng yoac dedzege amma imoc modacnade, imoc asoac dekperagibade. Nga ge yoac modac modac Kebu, imoc tofocnac dekperagima ");
INSERT INTO ded_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","gita witiha tengngo kpema udumeng mema kurere hania hania kpema udumeng yumiango geac kpac kuneng heiwayong memibade, imocngo wiac ubangerehagoc ande. ");
INSERT INTO ded_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","O KEBU, geng ua mekecnec, imocngo ubangerec meficgenenu marigango ua menec, imoc hentegecma sogac sogaiac yegec heibade. ");
INSERT INTO ded_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","O KEBU, geng ua meannec, imoc bibiagoc nga geac negen negeng imoc engena nga keme kemea yombong. ");
INSERT INTO ded_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Ngic kapayango imoc naric mi negenude nga ngic negen negenga kpac, ye wiac yomoc naric mi negentegerude. ");
INSERT INTO ded_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Imoc ine yofi, ngic yeneng Anutu ngadehema mangana megecdeac ayemmeande, yeni kpindzing isoc erema sabanginagoc anggecde nga yarengic yeni faka mangana angkecma yadiseri anggecde. Nga yeneng yoacngina bic desigec fede, yeni manganaac areng deyec deyecmea. ");
INSERT INTO ded_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","O KEBU, gennoc engenatoa nga ge nasoya nasoya ifi kechereema kecbesannec. ");
INSERT INTO ded_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Foracngoc, KEBU, geac ngabafocga yeni homecac areng andae nga yarengic sasawa yeni singsararang kpegecde. ");
INSERT INTO ded_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Kateburumakango kuhagoc kecande, ge sifu kuc ifia nemma nanggenuna kucgoc amma firang ambade. Ge kerec gombunga kpakema nadzicnennec. ");
INSERT INTO ded_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Ni kic fima ngabafocna mayunuu yenenai. Nga yarengic yeneng wegenac hama nubeso anggec, yeni kopocsicnginaac turunga ebira megec, imoc kedzacnango negenai. ");
INSERT INTO ded_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Ngic dindingac yeneng pam ic gombunga sabayagoc, ifi isoc andae. Yeni Rebanong bangecac yomondzoc ic herea yadiseri angande, ifi isoc yadiseri anggecde. ");
INSERT INTO ded_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Yeni ic isoc KEBUAC amau homehomera, yeni Anutuac amasobennu sabanginagoc anggecde. ");
INSERT INTO ded_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Yeni esea anggecde, fora. Nga yeni sifu fora meficgema maringina besaima fora homac gbarigoc angkecma ");
INSERT INTO ded_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","yofi degecde, “KEBU ye faka angammemea dindingac. Yeng neac hoc peperandzi seria yombong nga yearu faka mangana mong mi fede.” ");
INSERT INTO ded_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","KEBUNGO ngictauac kuc, imoc ngakpi isoc heiu kemeu ngicngac garengyunuude. Ye ngictauac kuc heiu ngakpia ande. Ye kuha bic heima kebangau dzegeec. O, yeng bangectoa bangec tatahau faiu seria tacdeac wiac mongngo meu goroc goroc naric mi anude. ");
INSERT INTO ded_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","O KEBU, geng ngictau tatacga bicngoc tatahau faina seria feu ge nasoya nasoya kecnec nga kecbesannec. ");
INSERT INTO ded_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","O KEBU, dokutoa yeneng ubaudumeng miacgec, dokutoa yeneng ubaudumengngina miacgec, dokutoa yeneng kucgoc arohoma ubaudumengngina miacgec. ");
INSERT INTO ded_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","KEBU wi kecde, ye damu damuyagoc. Ye doku dundung yeneac udumeng ferahama kondung siri yeneac kuc ifingoc ferahade. ");
INSERT INTO ded_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","O KEBU, geac singyoac imoc sasawa seria nga fora. Geac amau nasoya nasoya kpetiac feengkecbeso. ");
INSERT INTO ded_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","O KEBU, ge turung kpoukpou Anutu. Turung kpoukpouac Anutu, ge kperagigagoc fingectegecna. ");
INSERT INTO ded_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","O bangecac desi desi ngic, ge yacna. Ngic goa yenanggac negenggec engena angkecde, geng ngic imoc angammemenginaac turunga merengyemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","O KEBU, ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni nasoherec bic kecgecac nasongina kpac anudeac tomai kecduae. Yeni naso herea bic kecma ngicngac yeneac ebicac amma sogaima kecandaeac nasona herecgena kpac ambeso. ");
INSERT INTO ded_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Yeni enacnginaunac ubakpekpe yoac makecde nga yarengic sasawa yeni sebingina meemma yoac homac osokecdae. ");
INSERT INTO ded_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","O KEBU yeni geac ngicngacfocga kpedzameyunuma maridzomingfocga kpendzennu faiyunuma ");
INSERT INTO ded_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","ngac hodzec nga kuricngic yunuma beging kpebucyunuma ");
INSERT INTO ded_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","yofi deandae, “KEBU ye naric mi nenenude nga Yakoboac Anutungo imoc naric mi negensiude.” ");
INSERT INTO ded_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Ngicngac ubafong, ngeni kedzac faima yoacna negembisia. Oboc kpobocngic, ngeni negen negenggoc anggecdeac yoac edengunubade. ");
INSERT INTO ded_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Anutungo kedzac ngicfu faiu fede amma ye wiac imoc naric negenude. Nga kic imoc Anutuac marikibi. Imocac ye wiac imoc henudengoc. ");
INSERT INTO ded_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Yennoc bangeha bangeha ngicngac areng kpemeting ayemmema yunuude. Ye negen negeng minginango ngicngac kpouyemmeu yeneng negen negeng arenggegecde. ");
INSERT INTO ded_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","KEBUNGO ngicngac negen negennina negendacde. Ye ngicngac negen negengngina hennegeng amma negenu imoc uaya kpac. Nenang asu mocgu taiandimbe, ifi isoc. ");
INSERT INTO ded_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","O KEBU, ge ngic mong kopocsicac kpemeting amma dedeseriyoacga edekpou ammiannec, ngic imoc ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Geng ruae mina ebicnaso mong mi henude. Nga ngic goa Anutu ngadehema mangana megecdeac ayemmeande, yeneng ine kecma kemegecdeac amma teng usuyemmegecde. ");
INSERT INTO ded_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","KEBUNGO ngicngacfora mi ngadeyunuma wayunuude. Ye maridzomingfora naric mi wayunuude. ");
INSERT INTO ded_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Ngic mong ye sing dindingac modarude, imohai desi desingic yeneng yeac yoac sing dindingacfu desima monggoc degecde. Ngicngac herenginau ikoc nga hamangec mong mi fede, yeneng desi desi yoac dindingac imoc modacgecde. ");
INSERT INTO ded_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Ngic goa yeni Anutu ngadehema mangana megecdeac ayemmeande. Nga merang ni meficnuude nga merang yacma kicnginau nanude? Ni imocac tomai kecduae. Ngic mongngo meficnuma yarengic yeneac kicfu nanudeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","KEBUNGO hama ni mi meficnubacfu ubaonganango bic kemema ngicac ubaudumenga kpacfu nga kicsereu febac. ");
INSERT INTO ded_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Ni yofi deai, “Hanina pososoc anu manubeso ande.” O KEBU, ni ifi debareng fakaga modacma yoac dedzege amma imoc modacma nanggenunec, imohai mi manuec. ");
INSERT INTO ded_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Herenau negengyohoc homac mekecba geng meserinuma ubaonganaac ubangerec meficgenennec. ");
INSERT INTO ded_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Ngicenara goa yeni Anutu ngadehema mangana megecdeac ayemmeande, yeneng geac ogofocga naric mi anggecde. Yeni singyoac hania hania ohoandae, imocngo ngicngac ogofocngina faitobang ayemmema memangnaneyunugecde. ");
INSERT INTO ded_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Yeni ngic dindingac kpehomegecdeac yoac dedzege angkecma ngic kopocsiha kpac homecac arennnu desigecde. ");
INSERT INTO ded_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Anu KEBU ye neac ama seria nga Anutuna. Ye neac hoc peperandzi seria amma sufu sufuamana. ");
INSERT INTO ded_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Ngicngac yeneng ogofocngina memanganeyunugec yeng imocac turunga kpouyemmeude. Yeni Anutu wama faka mangana meandaeac yeng meicyunuu kpac anggecde. KEBU Anutuninango meicyunuude. ");
INSERT INTO ded_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Hagec, KEBUAC yegec heima oeha memini. Ye hoc peperandzi serinina nga memengerecnina. Nenang sogaima yeac yegec dendzerenggema heima ");
INSERT INTO ded_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","yeac hoannu kemma ye ubangerec memibisina. Neni yeac afe afeheyegec sogaima dendzerenggema heibisina. ");
INSERT INTO ded_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","KEBU ye Anutu engena yombong, ye anutu sasawa yeneac ngictau engenatoa. ");
INSERT INTO ded_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Yeng bangectoa bangec manau keme kemea fede, imoc mariau mema garenggeude. Bangec kperec kperemenga nga tiki sasawa imoc yeac. ");
INSERT INTO ded_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Yennoc kondung meec, imocac amma kondung imoc yeacngoc. Amma yeng bangec kerenga meu imocngo yeac marikibi ande. ");
INSERT INTO ded_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Hagec ngonducnema numumini. KEBUNGO meficnunuec, nenang yeac kicfu fafoc heimini. ");
INSERT INTO ded_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Ye Anutunina nga nenang yeac ngicngacfora. Ye yengena odayau fainunuma nenenggareng angkefu ramafora anni yeng mariango menunuu kecdimbe. O, ngeni yaguc kedzac kpema yeac enacudumeng negembau, imocac yombong anende. ");
INSERT INTO ded_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Mang esafocngina yeni Meriba dokuu ubaseri amma Massa bangecfu kecgec, naso imohai bangec kisiu faka anggec, ngeni ifi isoc mi ambisia. ");
INSERT INTO ded_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Ni faka kuhagoc meba yeni imoc hengkecgec, imoc fora. Nga yeni sifu tobannuma faitobannu fainugec. ");
INSERT INTO ded_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Ifi anggec ni kifa 40 ngicngac areng yeneac modzona tiu yofi deai, “Ngicngac imoc yeni ubaherenginau sing segema neac sing ngadehema kecdae.” ");
INSERT INTO ded_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Imocac ni yeneac ngaba amma yofi deserima deai, “Yeni neac kecnegeng kekecfu naric mi enggecde.” ");
INSERT INTO ded_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","KEBUAC yegec gboria heimibesonga. Bangectoa bangec, ge KEBU yegec gboria heimibesena. ");
INSERT INTO ded_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","KEBU oeha mema yegec heimima yeac kpac kuneng kenehebesonga. Ngeni wenaha wenaha memengerec uayaac yoac edeyunukecbisia. ");
INSERT INTO ded_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Kebu ye kuc nga kibikperagiagoc, imoc bangeha bangeha ngicngac areng botucnginau dekperagima edeyunugec yeng kucfaka bibiagoc meec, imoc ngiha ngiha botucnginau edeyunubisia. ");
INSERT INTO ded_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","KEBU ye engenatoa nga ye oyang boyang memibesonga. Ye tatahau wi yombong tacma anutu hania hania feracyunudacdeac ye kengec nga eweheiheigoc hoanggebesonga. ");
INSERT INTO ded_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","KEBUNGO kurumenga kurumenga meficyunuec. Nga bangec monnunac ngicngac, yeneac anutufocngina hania hania, yeni ine nemuongasac andacdae. ");
INSERT INTO ded_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Eweheihei nga ngictauac kuctoa kibikperagiagoc imoc KEBUARU fede. Yeac kpetiac amau kuc nga kibikperagia fede. ");
INSERT INTO ded_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Ngiha ngiha arengnginagoc kecdae, ngeni KEBU dengerema yeac kuc nga kibikperagia afehebisia. ");
INSERT INTO ded_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","KEBUAC kpac kuneng imoc kuhagoc nga kibikperagiagoc. Imoc eweheiheigoc hoanggebesonga. Ngeni sese mema yeac amawomongau hama meembisia. ");
INSERT INTO ded_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Ngeni kpetiac kekec heigec kemeu siricngina gombunga anu KEBU numumibisia. Bangectoa bangecac ngicngac areng, ngeni yeac kicfu kengec amma dzonong fede fedegoc nambisia. ");
INSERT INTO ded_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Ngeni bangec monnunac ngicngac Anutu mi negemmidae, yeneac botucfu yoac yofi dekperagiyemmebisia, “KEBU ye ngictau. Ye kuc imoc mekecma garengyununuma kecde. Foracngoc, ye bangectoa bangec tatahau faiec, imoc nasoya nasoya seria feu wiac mongngo meu goroc goroc naric mi anude. Ye monde mondea kpac kecma ngiha ngiha faka angammemengina yoacfu isinggema desiude.” ");
INSERT INTO ded_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Kurumenga kurumenga ngeni ubangerec negenggec bangecngo sogaibeso. Kondung nga wiac sasawa imohai wakema fedacdae, ngeni udumeng kuneng meficgebisia. ");
INSERT INTO ded_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Maneng nga semeng ua nga wiac sasawa imohai fedacdae, ngeni sogaibisia. Nga kateu ic sasawa, ngeni sogac sogaiac yegec heibisia. ");
INSERT INTO ded_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","KEBUNGO hadeac amma yeac kicfu sogaibisia. Ye bangecfu desi desi ua meudeac hama bangec sasawa faka dindingacfu isingyunuma ngiha ngiha faka forau yoacngina desiude. ");
INSERT INTO ded_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","KEBU ye ngictauac kuc minginango bangectoa bangec garenggema kecde. Imocac bangecngo sogaibeso nga kondung tegiau bangec fekendae, yeni ubangerecgoc kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Hoeng nga kundung kunengngo ye oronggema fedape. Faka dindingac nga sing dindingac, imocngo yeac ngictautatahaac sering seria. ");
INSERT INTO ded_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Gerecngo waraimiu ngabafora noboc noboc ye oronggeandae, yeni yonohodarude. ");
INSERT INTO ded_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Yeac piratacngo bangectoa bangec mekperagiu bangec ye imoc hemma dendeng kpeude. ");
INSERT INTO ded_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Bangec sasawaac KEBU hau tiki yeni KEBUAC kicfu pereckema kendo kereha sisingaiande, ifi isoc sisingaigecde. ");
INSERT INTO ded_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Kurumenga kurumenga yeni yeac faka dindingac dekperagigec ngiha ngiha yeneng yeac kuc nga kibikperagia henggecde. ");
INSERT INTO ded_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Ngic yeni nemuongaac kicfu ngonducnema numuyemmeandae nga imocac negenggec wiac engena yombong anu yoac homac osoandae. Nga nemuongangina yeni wiac fora mi meficgeyemmegecde, kpac. Yeni game kpekpeu faiyunugec eng nanggecde. Nga anutu hania hania yeni Kebuac kicfu ngonducnemigecde. ");
INSERT INTO ded_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Ge anutu hania hania isingyunuma yoacngina desinadeac Siong ye imoc negemma ubangerec meficgeu Yudaac ngacnaroang yeni sogaigecde. ");
INSERT INTO ded_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","O KEBU, ge Anutu engenatoa yombong nga bangec sasawaac ngic kunenga. Ge anutu hania hania feracyunudacnecac afeguyombonggeni. ");
INSERT INTO ded_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","KEBUNGO kpetiac ngicngacfora kekecngina onggonggeude. Ngic yeni yarefaka henggec imocac modzongina tiande, KEBUNGO yeni songogoc hoangyunuude. Ngic goa Anutu ngadehema mangana megecdeac ayemmeande, yeng ngicfora yeneac mariunac mesiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Ngicngac dindingac kecandae, yenearu ama wereckenude. Nga ngicngac uba kongahagoc kecdae amma herenginau ikoc nga hamangec mong mi fede, yeni sogac sogai meficgegecde. ");
INSERT INTO ded_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Ngicngac dindingac ngeni KEBUAC sogac sogaigoc kecma yeac kpara kpetiac yaiyo kpemibisia. ");
INSERT INTO ded_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Mitiyegec. KEBUNGO faka kuhagoc nga bibiagoc meu yegec gboria heimibesonga. Ye marifoia nga fuaya kpetiac sinema ngabafora feracyunuma firang anec. ");
INSERT INTO ded_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","KEBUNGO firang bic anec, imoc dekperagiyemmeec. Ye faka dindingac modacma ngicngac yoacngina dema nanggeyunuec, imoc bangec monnunac ngicngac ye mi negemmidae, yeni imoc didiu edzacyunuu yeni imoc kicnginango henggec. ");
INSERT INTO ded_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Ye Israe habu yenigoc yoac dedzege amma imoc modackecde, ye imoc negenu fekecde nga ye yoara modarudeac faka mong mi nigeckpeec. Anutuninango firang anec, imoc ngicngac bangec tegiau fekendae, yeneng henggec. ");
INSERT INTO ded_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Bangecfu ngicngac sasawa, ngeni sogaima KEBU dendzerenggema yegec heimibisia. Ngeni dendzerenggema oeha memima yegec heimima kpara heiwayong memibisia. ");
INSERT INTO ded_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Ngeni gita kpema KEBUAC yegec heibisia. Ngeni gita kpegec yegec udumenga gombunga fingecbeso. ");
INSERT INTO ded_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Ngeni trampet nga tomengtoa fifigec musi udumeng gombunga fingecbeso. Ngeni KEBU ngictauninaac kicfu kecma yegec dendzerenggema sogac sogaigoc heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Kondung, ge nga geac manau wiac sasawa fedae, ngeni udumengtoa meficgebisia. Bangectoa bangec nga imocac manau kecdae, ngeni ifingoc udumeng kuneng meficgebisia. ");
INSERT INTO ded_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Doku ngeni mari kpegec tiki ngeni sogaima yegec ngenahafoc heibisia. ");
INSERT INTO ded_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","KEBUNGO desi desi ua meudeac bangecfu hade. Imocac yeac kicfu yegec heibisia. Ye faka dindingacfu bangectoa bangecac ngicngac areng isingyunuma yoacngina desima monde mondea kpac kecma ngiha ngiha faka angammemengina isinggema yoacfu desiude. ");
INSERT INTO ded_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","KEBU ye ngictau amma ye ngiha ngiha garengyunuu yeni dzonong fede fedegoc kecbisia. Ye kerobing botucnginau ngictau tatahau taru usocngo bangecfu mebeso. ");
INSERT INTO ded_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","KEBU ye Siong manau kunennina kecde. Ye engena amma ngiha ngiha sasawa feracyunuude. ");
INSERT INTO ded_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Geac kpacga imoc damu damuyagoc. Yeneng imoc dengerebisia. Kebu ye kpetiac. ");
INSERT INTO ded_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Ngictau ye kuctoayagoc. Ye faka dindingac fingerudeac ammide. Geng faka mongang mongangga kpac, imoc faina seria fede. Ge Yakoboac areng yeneac botucfu faka angammemengina isinggema yoacfu desima sing dindingac modacma yoacngina desinec. ");
INSERT INTO ded_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","KEBU Anutunina ye kpetiac. Ngeni afehema yeac haniaac tatacfu ngonducnema numumibisia. ");
INSERT INTO ded_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Mose nga Arong yereng yeac womong gareng habugoc kefoc nga Samue ye yeac kpac kuneng kpacma nunumu ua mekefec. Yeni desambic ammigec yeng negengyemmema turunga merengyemmekefec. ");
INSERT INTO ded_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","KEBUNGO hoeng mong hereatoaac manau tacma yoac edeyunuu yeni yeac dedekperagiyoac nga singyoac tofohoma kecgec. ");
INSERT INTO ded_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","O KEBU Anutunina, geng ngicngac nunumunginaac turunga merengyemmenec. Ge kopocsic wawa Anutungina amma kopocsicnginaac turunga ifingoc merengyemmenec. ");
INSERT INTO ded_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","KEBU Anutunina ye kpetiac. Ngeni imocac amma afehema tiki kpetiacfu emma fafoc heimima numumibisia. ");
INSERT INTO ded_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Ubangerecseseac mitiyegec. Bangec sasawa, ngeni KEBU dendzerenggema sogac sogai yegec heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Ngeni KEBU ubangerecgoc kingang kpemima sogac sogaiac yegecgoc yeac kicfu habisia. ");
INSERT INTO ded_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","KEBU ye Anutu, ngeni imoc negembisia. Yennoc meficnunuma menunuu nenang yeac ngicngac areng andimbe. Nga yeac ngicngac areng amma yeac rama habufora amma yeac oda manau kecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Ye ubangerec ammima yeac nagutoau embesonga amma ama sobengau dedengerecac yegec heibesonga. Yeac ubangerec dema yeac kpac kuneng kenehebesonga. ");
INSERT INTO ded_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","KEBU ye gombunga. Yeng yoac dedzege amma imoc modackecde, fakaya imoc nasoya nasoya feengkefude. Ye yoara modackecde, imocngo fingecsahengina fekefudesoc, yenearu feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Dawidingo mitiyegec yofi heiec. O KEBU, gearu yoac modac modac faka fede. Nga sing dindingac modacma yoacngina desinade, imocac yegec heigembade. ");
INSERT INTO ded_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Ni kopocsiha kpac kecma sing imohai kengkecbadeac negensima kecduae. O, ge dafinenggac nearu hanade? Ni ngic ogofocna mong mi memanganeyunuma herenau dindingac nga kopocsicna kpac kecma amanau kecbade. ");
INSERT INTO ded_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Wiac mongngo sinna gombunga memanganenuudeacsoc anu ni kic imohai naric mi fibade. Ngicngac sing segema negen negensingngina kpac kecandae, yeneac uaac modzona tiu wiac imocngo nigoc mi kpeketaheude. ");
INSERT INTO ded_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Herenau sing gombunga modacma imoc naric mi wabade nga kekec mangana imoc nigoc kpac. Yare faka hania hania, imocac negen negeng nearu mi febeso. ");
INSERT INTO ded_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Mong ye ogea wegenac kecma yeac ngadeyoac sufu sufuu deude, ni ngic ifia memanganeba kpac ambeso. Ngic mong ye yengenaac negenu wiac engena anu ngic ogofora yenemma yeneac negenu mamea angande nga hereau ubakpekpe faka meande, yeac modzona tiude. ");
INSERT INTO ded_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Bangecnau yoac modac modac ngic nigoc kecgecdeac kicna yenearu fima negemba ngereeude. Mong ye kopocsiha kpac kecande, yeng neac kingang ngic amma uana mebeso. ");
INSERT INTO ded_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Ngic mong ye faitobang amma ngicngac ikocfu faiyunuande, yeng neac amau mi kecbeso. Nga ngic mong ikocyoac deande, yeng neac hoannu naric mi kefude. ");
INSERT INTO ded_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni asoacsoc bangecfu memanganeyunudacba kpac anggecde. Ni yarengic sasawa meicyunuba kpac anggecde. Yeni KEBUAC taonnu mi kecbisia. ");
INSERT INTO ded_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Kucmamango KEBUAC kicfu hama desambic amma yoac yofi edede. O KEBU, ge nunumuna negenna memeficac kiacba imocngo gearu habeso. ");
INSERT INTO ded_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Ge neac ebicnasou kicga nearu mi sufuma kedzacga nearu faina. Ni kpacguba turunga bic merennenna. ");
INSERT INTO ded_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Uamemena imoc hosuc ereande, ifi isoc erema kpac anggec sicnango gerea yombong amma gerec isoc dzekecde. ");
INSERT INTO ded_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Kpindzing herecgegec dzanggema homeande, herenango ifi isoc dzanggede. Kucna kpac yombong anu yaka nenena nigecnude. ");
INSERT INTO ded_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Ni kpendzeng kpema kunengngoc arohoduaeac amma sebi fusinango kemma sicnau kpeketahade. ");
INSERT INTO ded_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Ni bangec gbangge gbanggeau kpendzo neng isoc anduae nga kpabekuruc mong amabangec sesuhau kecde, ifi isoc kecduae. ");
INSERT INTO ded_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Ni gaugbori kecba neng mongngo ama witiau tembuha tacande, imoc isoc anduae. ");
INSERT INTO ded_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Ngabafocna yeneng asoacnac kemma marai game kpekpeu fainuma deendema anemma kpacna soweckegecde. ");
INSERT INTO ded_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Ni ic sogong nebadeac anenu hamango yakana angkecde nga kickumanango sokocfu kemema dokuna anu nekecduae. ");
INSERT INTO ded_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Ge ubaga manganeu ngaba anennec, imocac menu emma ukununa mayai. ");
INSERT INTO ded_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Uamemena sasawa maraiac onganinango hereeande, ifi isoc ande nga ni kpindzing isoc homema dzanggeduae. ");
INSERT INTO ded_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","O KEBU, ge nasoya nasoya ngictau tatacgau tacna geac kpac kuneng imoc ngicngac fingecsahenina fekefudesoc, nenearu feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Ge monggoc yacma Sionggac ubaga manganeu. Yagucnoc ubamangang amminadeac naso memea hade. ");
INSERT INTO ded_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Kingang ngicngacfocga yeneng Sionggac hoc songea negemma yeac sendunggac ubamangang negendae. ");
INSERT INTO ded_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Bangeha bangeha ngicngac yeneng KEBUAC kpac kunenggac kengec amma eweheimigec bangecfu ngictau sasawa yeneng geac kuc nga kibikperagigaac ewea heibisia. ");
INSERT INTO ded_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","KEBUNGO Siong ama monggoc mema heigboriu kuc kibikperagiagoc fingectegeru henggecde. ");
INSERT INTO ded_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Ye ngicngac makpekpea neneac nunumuac kedzac faiu wiacac desambic ammini imoc naric mi waude. ");
INSERT INTO ded_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Ngicngac fingecsahe ngade anggecde, yeneac amma yoac yomoc kibiu ohogec ngicngac yeneng ngade fingecma KEBU eriendzong memibisia. ");
INSERT INTO ded_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","“Ye yengena kpetiac tikiau wi tacma kiwa fiu maec. KEBUNGO kurumennunac kiwa fima bangec henec. ");
INSERT INTO ded_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Ngic witicamau kecdae, yeng kiacngina negemma kiwa bangecfu fima homecac areng yungecyunuudeac kiwa fiu maec.” ");
INSERT INTO ded_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Ifi anu KEBUAC kpac kuneng Siong taonnu dekperagibesonga nga Yerusarennu eriendzong memibesonga. ");
INSERT INTO ded_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Ngiha ngiha yeni ngictau areng yenigoc kpeturanggema KEBUAC kicfu ngonducnema numumigecde. ");
INSERT INTO ded_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Ye kucna dzongiau memama uameme nasona mewegeneu ");
INSERT INTO ded_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","deai, “O Anutuna, ge kifaga nasoya nasoya ngicngac fingecsahengina fekefudesoc, imoc feracyunuma feengkefude. Ge uameme nasona dzongiau herecgema mi meicnuna.” ");
INSERT INTO ded_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Ge hanac hanaheaunacngoc kecma bangecac titiseri fainec seria fede. Kurumenga kurumenga yeni geangga marikibinoc. ");
INSERT INTO ded_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Wiac imoc sasawa yeni kpac anggec, fora. Nga ge sifu kecengkecnade. Yeni ngakpi isoc esea anggecde nga wamba hesikpe amma ukuandimbe, ge ifi isoc wayunuma gboria fainade. ");
INSERT INTO ded_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Geng nasoya nasoya siric ifiangoc kecengkecnade nga geac kifaga imoc wisic wisickea kpac. ");
INSERT INTO ded_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Geac kingang ngicfocga yeneac nambaracfocngina, yeneng geac hoannu kecgec geng esamedacfocngina hoanggau faiyununa yeneng gegoc serima kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Dawidingo mitiyegec yofi heiec. O ubaongana, ge KEBU kenehena. Wiac sasawa neac manau fede, imocngo yeac kpara kpetiac kenehebeso. ");
INSERT INTO ded_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","O ubaongana, ge KEBU kenehena. Yeng faka gombunga anggenec, imoc mi nigecgubeso. ");
INSERT INTO ded_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Geng ngicngac ogofocga memanganeyununa yennoc kopocsicga imoc waude. Ye hafeidzoicga sasawa mengerema ");
INSERT INTO ded_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","kekecga bummema homecfunac mesiude. Yeng yoac dedzege amma imoc modacma wosoefac anggenu imocngo kekecgau iraga isoc anude. ");
INSERT INTO ded_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Ge wiac monggac anggenu yeng wiac kereng kereng genu soha anu naric yombong kecnade. Huntoc neng ye dzoea heigboriu sebigbori isoc angande, imoc isoc sebiga monggoc gboriude. ");
INSERT INTO ded_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","KEBUNGO ngic garengyunuu goango ngic ogofocngina ebicfu faiyunugec ubaebicgoc kecgec yeng sing dindingac modacma yoacngina faka dindingacfu isinggema desiude. ");
INSERT INTO ded_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Ye singa Mose edzahama uaya mema Israe habu imoc edzacyunuec. ");
INSERT INTO ded_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","KEBUNGO wosoefac anemmema neneac ubamangang negemma ngaba bic mi anude. Ye yoac dedzege amma imoc modackecde, faka imocngo yearu wiac engena. ");
INSERT INTO ded_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Ye nasosoc mesuninau mi nunukefude nga ye ngaba nasoya nasoya mi mekefude. ");
INSERT INTO ded_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Nenang kopocsic meficgeing, ye imocacsoc faka mi anemmeude nga fakanina manganaac siricfu turunga mi kpounemmeude. ");
INSERT INTO ded_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Ngicngac yeneng eweheimigec yeng yoac yenigoc dedzege amma imoc modarude. Yeac faka siriha yofi, kurumenga kurumenga yeni bangec ferahama wi enggec fedae, ye ifi isoc ngicngacfora yeneac songo efea kpac negenude. ");
INSERT INTO ded_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Wenac ere erea imocngo keme kemeagoc wegenac naric mi tacde, imoc herea yombong. Nenang singyoac kpema mangana meficgeing, ifi isoc imoc meickeu nenanggac hereau kenude. ");
INSERT INTO ded_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Manggac mongngo nambaracfora yeneac ubea manganeu hoangyunuande, ye ifi isoc ngicngac KEBU eweheimiandae, yeneac ubamangang negemma hoangyunuude. ");
INSERT INTO ded_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Nga dafiu fingering, imoc yeng negende. Nenang sendungsac, ye imoc negennu fede. ");
INSERT INTO ded_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Kpindzingngo manennu kpafuya kpeande, imoc uameme nasoya wegenacsac ande. Nga bangecfu ngic ye uameme nasoya ifi isoc ande. Dzaring dzuria sabayagoc anu ");
INSERT INTO ded_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","firangngo mefiranggeu morongge mama kpac anu wiac imoc tacande, tatahango imoc monggoc mi negenude. Ngic ye kekeha bangecfu ifi isoc ande, fora. ");
INSERT INTO ded_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Nga KEBUNGO sifu yoac dedzege amma imoc modarude. Ngicngac yeneng eweheihei ammigec yeng nasoya nasoya hoangyunuma kecengkefude, fakaya dindingac imocngo nambarac nga esamedacfocngina fingecgecdesoc, yenearu fekefude. ");
INSERT INTO ded_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Nga ngicngac yeneng yeac dzadzahac seria modacgec yeng ifi ayemmeude. Nga ngicngac yeac nonoyoac negenggec fede, yeni ifingoc ifi ayemmeude. ");
INSERT INTO ded_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","KEBUNGO ngictau tataha kurumenga kurumenga fekendaeu tatahau faiu seria nande. Ye ngictau amma eucererenga wiac sasawa feracyunuma mingina ande. ");
INSERT INTO ded_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","O KEBUAC angero, ngeni ye kenehebisia. Yeac areng kucnginagocngo yeac yoac negengkecma yoara tofohoma ua mekecdae nga yeac ubaudumeng negenggecdeac kedzac kpeandae, ngeni ye kenehebisia. ");
INSERT INTO ded_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Kurumenggac wasai arengfora nga kingang ngicngacfora yeac songo modacandae, ngeni KEBU kenehebisia. ");
INSERT INTO ded_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","KEBUAC marikibifora sasawa bangecfu yeac bageau kecdae, ngeni sasawango KEBU kenehebisia. O ubaongana, ge KEBU kenehena. ");
INSERT INTO ded_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","O ubaongana, ge KEBU kenehena. O KEBU, Anutuna, ge engenatoa yombong amma eweheihei nga ngictauac kuc kibikperagiagoc heima kecannec. ");
INSERT INTO ded_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Ngicngac yeneng wamba heiandae, ge ifi isoc kperagiango kperacemema kecnec. Geng kurumenga kurumenga meficyunuma kporucbedzo isoc kpedziyununa fekendae. ");
INSERT INTO ded_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Ge ama managaac kpete doku witiau mena hoeng imoc geac keretac anu geng firanggac kpegang mema witiau tacma kisanna firangngo meguma kenude. ");
INSERT INTO ded_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Geng firang sueyununa yeneng yoacga mema kenggec gerecborang uayoac edeyununa yeneng kingang kpegenggecde. ");
INSERT INTO ded_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Geng bangec mena imocngo goroc goroc amma kengha ambacac ge imoc titiseria tatahau fainecac wiac mongngo meu goroc goroc naric mi anude. ");
INSERT INTO ded_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Geng dzohongtoa mema imocngo bangec kperahana kporuc isoc heiu kemeu dokungo tiki feracyunuma feu ");
INSERT INTO ded_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","geng doku yoac ngabasiric edeyununa yeni kengec amma woradacgec. Ge parandanggac mingina nga doku yeneng geac parandang udumeng negemma kengecyunuu woragec. ");
INSERT INTO ded_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Ge tiki kperemeng tatacngina deseriyemmena tiki yeni yacgec kperemeng yeni kemema ihai fegecde. ");
INSERT INTO ded_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Geng kpetengina faina feu bangec monggoc semebauac ferahegecdeac kpae heiyemmenec. ");
INSERT INTO ded_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Ge bangec keme kemeau doku kiwa faina doku kucgoc hakecma tiki botucnginau mama feec. ");
INSERT INTO ded_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Fema manennu yang sasawa doku gumecyunuu nekecgec kateu donggi yeneng dokuac homema doku imoc nekecgecde. ");
INSERT INTO ded_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Kateu neng yeneng faecngina doku tegiau mema ihai fema ic fawau tacma arohogecde. ");
INSERT INTO ded_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Ge wi amagau tacma tikiu doku kpema uaga mema kecna foragoc anu bangecngo fora negebec anude. ");
INSERT INTO ded_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Geng kpindzing dena fingeru ramaburumakango imoc negecde. Geng dzaring nga semeng meficgena fingeru ngicngac neneng semeng ua meni bangecfu yaka fingerudeac edena neandimbe. ");
INSERT INTO ded_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Ngichereu ubangerec fingerudeac waing meficgenec nga ngicngac kicsiricnina pirac pirac anudeac geng kerec meficgenec. Amma ngicngac herengina kucgoc anudeac yaka meficgema yemmenec. ");
INSERT INTO ded_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","KEBUNGO Rebanong bangecac yomondzoc ic homecyunuma doku efea kpac kpeyemmeu nekecgec ");
INSERT INTO ded_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","neng yeneng faecngina ihai megec kpendzo neng ye faeha yomondzoc icfu mema ihai fekecde. ");
INSERT INTO ded_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Tiki kuneng herea yeneng kate noning yeneac amabangec nga mandzang yeneng hoc peperandzi singau sufuma kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Geng afo faina imocngo kifasoc kecnideac kpete angkefu wenac yengenaocngoc keme keme nasoya negenude. ");
INSERT INTO ded_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Geng kundung faina ama toforeu kateu yang yeneng kenghaanggecde. ");
INSERT INTO ded_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Raiong yang sebigbori yeni Anutungo yakangina meficgeudeac negemma yang yunuma negecdeac kucgoc arohogecde. ");
INSERT INTO ded_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Wenac ereu yeni monggoc meickema faecnginau kemma fegecde. ");
INSERT INTO ded_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Imohai ngicngo ama uayau kemma ua mema kefu ama marai anude. ");
INSERT INTO ded_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O KEBU, ge wiac hania hania medacnec, imocac kpetea engena yombong. Ge negen negentegecgango imoc sasawa mena wiac sasawa kekecnginagoc yeneng geac marikibiga amma bangec mewakedae. ");
INSERT INTO ded_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Kondung ye kuneng kpererema edi feu kondungyang nga yang kuneng kapia hania hania homac yombong imocac manau fedae, yeneac kpete naric mi osodacnide. ");
INSERT INTO ded_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Wage yeni imohai kengha angkecdae. Nga geng kondunggac kondungyang kuneng ifingoc meficyununa yeneng kondunnu yuengyuma anggecde. ");
INSERT INTO ded_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Wiac imoc sasawa yeni kicngina gearu figec geng nasoya hau yaka yemmenadeac negeung kecgec ");
INSERT INTO ded_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","geng wiac yemmena imoc mekecgecde. Geng mariga mederena yeni wiac gombunga homac negebec angkecdae. ");
INSERT INTO ded_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ge kicga yenearu sufuna yeni kpidohoma kengecyunuude. Ge asungina wangecyununa yeni homema bangecnginau monggoc dzigenegecde. ");
INSERT INTO ded_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Geng meficyunuma Asuga monggoc fifina yeneng monggoc gborigecde. Ge bangecac siriha heigborikecna monggoc gboria fingerude. ");
INSERT INTO ded_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","KEBUAC kuc nga kibikperagi imoc nasoya nasoya feengkecbeso. KEBUNGO marikibia hemma ubangerec negembeso. ");
INSERT INTO ded_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Yeng kiwa bangecfu fiu bangecngo dendeng kpeu mariango tiki kpesereyunuu tikingo hosuc kpegecde. ");
INSERT INTO ded_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Ni kekecna kecbadesoc KEBU yegec heimibade. Ni kekecna kecma Anutu dengerekecbadengoc. ");
INSERT INTO ded_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Ni KEBUARU sogac sogai meficgekecma yeac wiac hennegeng angkecba yeng imocac negenu ngereebeso. ");
INSERT INTO ded_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Ngic kopocsicgoc bangecfunac meicyunubesonga nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni kpac ambisia. O ubaongana, ge KEBU kenehena. KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","O ngicngac, KEBU ubangerec memima yeac kpac kuneng hofocbesonga. Yeng ua sasawa meande, imoc ngiha ngiha dekperagiyemmema edeyunugec yeneng imoc negendacbisia. ");
INSERT INTO ded_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Ngeni yeac yegec heimibisia. Ngeni dedengerec yegec heimima yeng ua bibiagoc meande, imoc ngicngac edeyunubisia. ");
INSERT INTO ded_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Yeac kpara kpetiac. Ngeni imocac negenggec wiac engena ambeso. Ngicngac KEBU hofocandae, ngeni sogaibisia. ");
INSERT INTO ded_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Ngeni KEBU hofocma yeac kuhaac kic fima yeac hoannu kemma kecgecdeac nasosoc angemmebeso. ");
INSERT INTO ded_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Yeng ua bibiagoc amma kucfaka bibiagoc mekecma desi desiyoac enarango dekefec, ngeni imoc negenggec febeso. ");
INSERT INTO ded_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","O, yeng ngeni meisingngunuec. Ye kingang ngiha Abarahanggac gboricfora nga Yakoboac medacfora meisingngunuec. ");
INSERT INTO ded_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yennoc KEBU Anutunina nga yeng ngicngac yoacngina isinggema desiude, faka imoc bangecfu sokoma fede. ");
INSERT INTO ded_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Ye dzadzahac meec, imoc nasosoc negensima dedeseriyoac edengunuec, imoc ngicngac fingecsahengina fekefude, imoc andenga tauseng feenude, imocacsoc negensima kefude. ");
INSERT INTO ded_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Ye Abarahanggoc dzadzahac imoc mema Isakaac yoac deserimima edema ");
INSERT INTO ded_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Yakoboaru dedeseriyoac imocnoc meserima Israegoc dzadzahac imoc fefeseri feudeac dema ");
INSERT INTO ded_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","yofi deec, “Ni maridzoming arennu Kanaang bangec ge gembade, imocnoc geac bangec noboha anude.” ");
INSERT INTO ded_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Ngicngac imoc yeni kpetengina kuneng kpac. Yeni ngicngac efeanecsac amma bangec imohai kemma kuric kecgec. ");
INSERT INTO ded_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Bangecareng yeneac bangecngina fekende, yeni imohai yerecgema ngictau monggac bangec yerecgema ngictau monggac bangecfu kengkecma ngicngacareng mong yenigoc kecma wayunuma monggaru kengkecgec. ");
INSERT INTO ded_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Kebungo ngic kpae heiyemmeu mongngo mong ebicfu mi faiyunuec. Ye yeneac amma ngictau yoac ngabasiricfu ayemmema ");
INSERT INTO ded_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","yofi edeyunukefec, “Ni ngic meisinggema kerecdokungo nadzicyemmeai, ngeneng mi kpesereyunubisia nga profetefocna mangana mong mi ayemmebisia.” ");
INSERT INTO ded_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Yeng bangec imohai boditoa fingerudeac edeec, imohai nenesemengngina sasawa kpetotieu kpac anudeac negemma ");
INSERT INTO ded_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","ngic mong bic sueu waraiyemmeec, imoc Yosefe. Yeneng ye wanac ngic anudeac dema suema dzo megec. ");
INSERT INTO ded_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Yeni hania ic gigidangau faima ubiau becsac aiengngo memea dzegegec. ");
INSERT INTO ded_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Yeng ifi kefu yeac kpefing yoac dedea, imoc erema heiu KEBUAC yoacngo Yosefeac hania tobanggeu seriec. ");
INSERT INTO ded_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Seriu Aigita yeneac ngictaungo ngicfora sueyunuu kemma Yosefe yungecgec. Ngiha ngiha yeneac ngictaungo Yosefe witicfunac yungerec. ");
INSERT INTO ded_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Ngictaungo ye amea manaac enara faiu yeng iwaiya sasawa garenggeudeac uayoac demiec. ");
INSERT INTO ded_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Demiu Yosefengo songeaac arennu ngictauac medacfora dederecge ayemmema ngic enarafora negen negentegec edekpou ayemmekefec. ");
INSERT INTO ded_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Ifi anu Israe yeneng Aigita bangecfu hagec. Yakobongo Hanggac bangecfu kuric kefu ");
INSERT INTO ded_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","KEBUNGO ngicngacfora meficyunuu fingecsahe kuneng nga kucgoc amma ngabafocngina yeneac kuc ferahagec. ");
INSERT INTO ded_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Ferahegec yeng Aigita ngic yeneac negen negeng merenu yeneng ngicngacfora ubango ukuyunugec. Yeni yenahafoc yoac denegeng amma Kebuac kingang ngicfora faitobannu faiyunugec. ");
INSERT INTO ded_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","If anggec Kebungo kingang ngiha Mose suema Arong ifingoc meisinggeu ");
INSERT INTO ded_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","yereng yeneac botucfu faka kuhagoc meoc. Yeri Hanggac bangecfu kucfaka mi hehena mekefoc. ");
INSERT INTO ded_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Anutungo kundung sueu bangec mekundungkpeu yeneng ine yeac yoac kpema wagec. ");
INSERT INTO ded_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Ye dokungina sasawa heimerenu sac andaru kondungyang kpebucyunuu homedacgec. ");
INSERT INTO ded_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Sepeng yeneng hama bangecngina sokodacma ngickunengfocngina yeneac fefeamanginaungoc engkecgec. ");
INSERT INTO ded_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Yeng yoac deu dawec nga dokuac mogocbisic habutoanginagoc hama ama bangecngina sasawa sokodarec. ");
INSERT INTO ded_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Yeni kia kpeudeac negenggec yeng nomanggbomea yemmeu piratacngo amabangecngina sokoma heidarec. ");
INSERT INTO ded_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Yeng waing icngina kpezamema fig ic amma icngina goa bangecnginau kpetackedarec. ");
INSERT INTO ded_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Ye ipua yoac edeyunuu yeneng hagec. Ipua gboria kucnginagoc hagec, yeneac kpetengina naric mi mebesonga. ");
INSERT INTO ded_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Yeneng hama bangecfu wiac maria tengging tengging sasawa nedacma bangecnginaac semeng nedacgec kpac anec. ");
INSERT INTO ded_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Yeng bangecnginau warac medacfocngina sasawa kpebucyunudacma kucnginaac fora warac fingecgec, yeni kpebucyunuu homedacgec. ");
INSERT INTO ded_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Imoc sasawa fingeru wisickeu ye Israe habu meyunuu Aigita bangec wama kenggec. Yeni siriwa nga gol momoc mema kenggec yeac ngicngac arengfora yenearunac mongngo mi tifainggema makpeec. ");
INSERT INTO ded_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Aigita ngicngac yeneng Israe ngicngac yeneac homac kengecyunuecac amma yeneng wayunuma kenggec, imocac ubangerec negenggec. ");
INSERT INTO ded_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Anutungo hoeng tiameu imocngo kperacngina amma witinginau feu tofocnac gerec yemmeu imocngo mekperagiyunuec. ");
INSERT INTO ded_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Yeni kpesimigec yeng neng negecdeac yemmema kurumenggac yaka efea kpac yemmeu negebec anggec. ");
INSERT INTO ded_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Ye hoc kpendziru doku dundungngo mama bangec dokuya kpac, imohai dzuamagoc mekeng feec. ");
INSERT INTO ded_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Nocac ye dedeseri kpetiac deserima bic deec. Nga ye kingang ngiha Abarahang, yeac ifingoc negenu feu ");
INSERT INTO ded_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","ngicngacfora sogac sogaigoc wangecyunuec. Ye meisingfora hesicyunuu yeni yegec heima arohoma sogaima kenggec. ");
INSERT INTO ded_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Yeng bangec monnunac ngicngac yeneac bangec wangecyunuma meisingngicngacfora imoc yemmeu ngicngac yeneac semeng uaac mingina amma fora mema nekecgec. ");
INSERT INTO ded_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Yeneng yeac singyoac mekecma dedeseri yoara seria modacgecdeac ifi anec. KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","KEBU eriendzong memini, hallelu Yac. KEBUNGO yoac dedzege amma imoc modarude nga wosoefaha imoc nasoya nasoya feengkefude amma ye gombunga, imocac ubangerec memibesonga. ");
INSERT INTO ded_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","KEBUNGO faka kuhagoc mekecde, ngic mongngo kucfaka ifia naric mi deude nga ye kucfaka imoc dengereudeacsoc kpac. ");
INSERT INTO ded_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Ngicngac sing dindingac nasosoc modacbeso ayemmeande nga faka dindingac angandae, yeni kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","O KEBU, ge ngicngacfocga gombunga ayemmema neac ifingoc negenna febeso. Ge ngicngac ebicfunac mesiyunuma ni ifingoc meficnubesena. ");
INSERT INTO ded_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Geng ngicngacfocga meisingyununa yeni naric kecma wiac monggac mi obohogecde, imoc hembeso anende. Ngicngac arengfocga yeneng ubangerec negengandae, imoc hemma sogaibadeac anende. Geac maridzoming ngicngacfocga yeni sogaima ge dengeregugecde, imohai ni yenigoc sogaibadeac anende. ");
INSERT INTO ded_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Warac mangesafocnina yeni kopocsic meficgegec nenang meficyunuma Anutu ngadehema mangana menideac anemmeu ngicngac ogofocnina memanganeyunuma faka mangana ayemmeing. ");
INSERT INTO ded_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Esangabofocnina yeni Aigita bangecfu kecma geac kuc fakaga bibiagoc hengwa anggec. Geng yoac dedzege amma imoc modacnade, imoc wiac engena. Yeneng ine imoc nigecyunuu kondung sacsac tegiau kecma Anutu Engenatoaac yoac kpegec ");
INSERT INTO ded_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","ye yengena kparaac amma ebicfunac mesiyunuma kuhaac hania mekperagiyemmeec. ");
INSERT INTO ded_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Yeng kondung sacsac yoac ngabasiric ammiu gbanggeec. Nga yeng dzohong keme kemeausing bangec gbangge gbanggeau kengandae, ifi isoc wangecyunuma nobocgeng enec. ");
INSERT INTO ded_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Ye ifi amma ngic ngadeyunugec, yeneac mariunac mesiyunuma ngabafocngina yeneac kucfunac mesiyunuec. ");
INSERT INTO ded_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Doku imocngo ngabafocngina semeyunudaru kpac anggec yenearunac mongngo mi kefec. ");
INSERT INTO ded_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Ifi anu yeneng yeac yoac negensinggema dedengerec yegec heimigec. ");
INSERT INTO ded_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Nga yeni ine bic yombong ye uaya mekefec, imoc nigecyunuu yoac dederecge ayemmeudeac tomai mong mi anggec. ");
INSERT INTO ded_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Yeni bangec kisiu yakaac songo kuneng negemma imoc mi garenggema bangec gbangge gbanggeau Anutu faitobannu faigec. ");
INSERT INTO ded_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Nga ye wiac mong yemmeudeac derecgegec, imohai yeng imoc yemmema hafei kuneng mong botucnginau sueu yenearu haec. ");
INSERT INTO ded_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Anu ngic yeneng kporucbedzongina nangkenec, ihai kecma Moseac keracmangang amma Arong, KEBUAC kpetiacngic, yeac keracmangang ifingoc anggec ");
INSERT INTO ded_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","bangecngo anggema Datang gbokoma Abirang arengforagoc semeyunuec. ");
INSERT INTO ded_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Gerecngo mama ngicngac yeni modacyunukecgec, yeni sasawa yonohoec. Gerecborangngo yarengic yonohodarec. ");
INSERT INTO ded_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Anu yeni Horebe tikiu kecma burumaka medahaac ongea mong mema nemuonga aiengngo mema, imoc eweheimima numumigec. ");
INSERT INTO ded_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Yeni Anutuac kuc nga kibikperagia wama imoc merenggec burumaka kpindzing neande, onga imocngo yeac tataha meudeac negemma faigec. Faima fafoc heimima numumigec. ");
INSERT INTO ded_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Anutu memengerecnginango Aigita bangecfu faka kuneng mekefec, yeac nigecyunuec. ");
INSERT INTO ded_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Yeng Hanggac bangecfu kucfaka bibiagoc mema kondung sacsacfu faka kicfuria meu kerectegec anggec. ");
INSERT INTO ded_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Yeneng ifi anggec yeng kpetotieyunuudeac deu Mose meising ngihango Anutuac kicfu namma yeac herebu menomaneec. Ye ifi mi nambac dede Anutungo kpetotieyunuu kpac ambau. ");
INSERT INTO ded_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Anutungo yoac deserima deu yeneng imoc mi negensinggema bangec gombunga yemmeu megecdeac dedea, imoc ngadehegec. ");
INSERT INTO ded_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Yeni kporucbedzonginau Anutuac pandzeng kpouma tacma KEBUAC ubaudumeng negemma imoc mi tofohogec. ");
INSERT INTO ded_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Imocac yeng maria miacma yoac yofi deserima deec, “Ni bangec kisiu yunuba homema fedacbisia nga ");
INSERT INTO ded_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","esamedacfocngina medereyunuba bangeha bangeha ngicngac areng yeneac botucfu kecgecde. Yeni ifi kecgec ngicngac yeneng yunukpebuc ayemmegec neng bangeha bangeha fekendae, imohai sueyunuba singsarang kpema kecbisia.” ");
INSERT INTO ded_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Imocac witiau yeni Peore tiki Baari nemuac ongagoc kpeketehama kecma nemuonga homemea yeneac sesegerec oho ohoya, imoc nekecgec. ");
INSERT INTO ded_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Yeni ifi amma KEBUAC here miacgec yeng angammemenginaac amma ngaba ayemmeu hafei mangana mongngo yenearu fingerec. ");
INSERT INTO ded_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Anu Pinehasingo sifu yacma KEBUARU nunumu ua meu hafei mangana imocac kuha mau kpac anec. ");
INSERT INTO ded_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Yeng ifi anecac amma fingecsahe feerekecgecde, yeni sasawango Pinehasiac fakaya dindingac, imoc negensikecgecde. ");
INSERT INTO ded_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Anu yeni Meriba dokuu kecma KEBU ngaba ifingoc meficgemigec Mosengo yeneac ebicac amma ebicfu enec. ");
INSERT INTO ded_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Yeneng Moseac asu mehodungaigec yeng yoac mi negentegecma deec. ");
INSERT INTO ded_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","KEBUNGO dederecgeyoac ayemmeec nga yeni ine ifi isoc habu goa mi kpetotieyunuma meicyunugec, kpac. ");
INSERT INTO ded_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Yeneng ine bangeha bangeha ngicngac areng yenigoc kengha amma yeneac faka arenggema imoc modacgec. ");
INSERT INTO ded_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Yeni yeneac nemuonga hania hania modacgec. Faka imocngo botacngina amma mendangyunuu ");
INSERT INTO ded_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","yeni naroangmedacfocngina meyunuma kpebucyunugec. Faka imocngo asu manganaac hosuc heiyemmekecgec. ");
INSERT INTO ded_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Yeni nambaracfocngina yeneac sac kopocsiha kpac kpakegecac bangecngina seuhagoc anec. Yeni naroang medacfocngina sese dema kpebucyunuma Kanaang bangecac nemuonga yeneac sesegerec ohogec bangecngo sacac kopocsicac seuhagoc anec. ");
INSERT INTO ded_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Ngicngac yeni angamemengina ifia angkecgecac amma uba seucnginagoc amma Anutuac kicfu yeni kaisero siric anggec. ");
INSERT INTO ded_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Imocac KEBUNGO ngicngacfora ngaba ayemmema maridzoming ngicngacfora yenenu seucnginagoc anggec negemma modzea tiu wayunuec. ");
INSERT INTO ded_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Wayunuma bangec monnunac ngicngac ye mi negemmidae, yeneac mariu faiyunuu yeneng ubango ukuyunuma garengyunugec. ");
INSERT INTO ded_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Ngabafocnginango ebicfu faiyunugec ubaebicgoc kecgec yeneng meyunuma memayunuma kucngina bageau faiyunugec. ");
INSERT INTO ded_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Kebungo naso homac ebicfunac mesiyunukefec nga yeneng ine yoackpekpengic amma faka imocsac negensima kecgec. Yeni ngicngac ogofocngina memanganeyunukecgecac yeng memayunuu memeficac obohoma ");
INSERT INTO ded_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","kpendzeng kpekecma kiacgec, fora. Nga yeng sifu ebicngina negensima memeficac kiacngina negenec. ");
INSERT INTO ded_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Ye warac dzadzahac yenigoc meec, imoc yeneac amma negenu feec. Yeng yoac dedzege amma imoc modackecde, imocngo efea kpac femideac amma yeneac ubamangang negengkefec. ");
INSERT INTO ded_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Ngic witicfu faiyunuma meyunuma kecdacgec, yeng faka ayemmeu yeneng yeneac ubahodung negenggec. ");
INSERT INTO ded_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","O KEBU, Anutunina, ge ebicfunac mesinunuma bangec monnunac ngicngac ge mi negenggudae, yeneac botucfunac menunuma kpedzucnununa. Geng ifi anna neni geac kpacga kpetiacac ubangerec negemma homac dengeregunide. ");
INSERT INTO ded_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","KEBU Israeac Anutu, ye nasoya nasoya kenehebesonga. Imoc fehereema fekecbeso. Ngicngac sasawango yofi debisina, “Imoc Fora.” KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","KEBU ye gombunga. Ye yoac dedzege amma imoc modackecde, fakaya imocngo nasoya nasoya feengkefude. O, ngeni imocac ubangerec memibisia. ");
INSERT INTO ded_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","KEBUNGO ngicngac bummenunuma ebicfunac mesinunuec, ngeneng ifi dekecbisia. ");
INSERT INTO ded_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Ngeni bangeha bangeha kecgec yeng imohacnac mengunuec. Goa ngeni wenac ere ereau kecgec nga goa wenac keme kemeau kecgec. Goa ngeneng not bigeng kecgec nga goa saot bigeng kecgec nga yeng imohacnac mengunuma kpedzucngunuec. ");
INSERT INTO ded_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Goa ngeni taong monnu kemma kecgecdeac sing hofocma bangec kisi gbangge gbangeau kengha angkecma ");
INSERT INTO ded_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","yakaac nga dokuac homema ubaongangina herenginau homeec. ");
INSERT INTO ded_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Ngeni ebicfu ifi kecma KEBUARU kiacgec yeng kpendzeng imohacnac mesingunuma ");
INSERT INTO ded_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","sing wegenacfu wangecngunu kengkecma taong nga amabangec gombunga meficgengemmeu ihai kecgec. ");
INSERT INTO ded_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","KEBUNGO yoac dedzege amma imoc modackecde, ngeni imocac ubangerec memibisia. Yeng bangecngic medacfocngina meficngunuma faka bibiagoc mekecdeac ngeni ubangerec memibisia. ");
INSERT INTO ded_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Mongngo dokuac ammiu yeng doku miu negebec anude nga mongngo yakaac homeu yeng wiac gombunga miu neu gebeckpeude. ");
INSERT INTO ded_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","11","Goa yeni Anutu Engenatoa yeac yoac kpema dederecgeyoara ngadehekecgecac kundung manau kengkpung hakpung anggec witicngo witicyunugec tacandae, ifi isoc tacma kpendzeng kpegec. ");
INSERT INTO ded_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Yeni uatoa mekecgec herenginango kuha kpac anu bangecfu mayunuu mongngo mi meficyunuec. ");
INSERT INTO ded_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Yeni ebicfu ifi kecma KEBUARU kiacgec yeng kpendzeng imohacnac mesiyunuma ");
INSERT INTO ded_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","kundung dzic imohacnac meyunuu erema witicngina herecgeec. ");
INSERT INTO ded_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","KEBUNGO yoac dedzege amma imoc modarude nga yeneng imocac ubangerec memibisia. Yeng bangecngic medacfocngina meficyunuma faka bibiagoc mekecdeac ubangerec memibisia. ");
INSERT INTO ded_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Yeng nagu seria aiengngo memea sasawa, imoc hembarackeu aiengngo kpae heiheia imoc kpetackeude. ");
INSERT INTO ded_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Goa yeni kopocsicac fakagoc kecgecac hafei ayemmeec. Yeni ngicngac ogofocngina memanganeyunugecac amma kpendzeng kpekecma ");
INSERT INTO ded_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","yaka negecdeac mi ayemmeu yaka sasawa wama homecac naguu heima fegec. ");
INSERT INTO ded_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Yeni ebicfu ifi kecma KEBUARU kiacgec yeng kpendzeng imohacnac mesiyunuma ");
INSERT INTO ded_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","yoara sueu mama hafeingina mengereu wiac kpetotieyunuu kpac ambeso anggec, imohacnac mesiyunuec. ");
INSERT INTO ded_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","KEBUNGO yoac dedzege amma imoc modackecde, yeneng imocac ubangerec memibisia. Yeng bangecngicac medacfocngina meficyunuma faka bibiagoc mekecdeac ye ubangerec memibisia. ");
INSERT INTO ded_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Yeni ubangerecac sese ohoma yeng uaya sasawa mekecde, imocac oyang boyang memima imoc ngicngac edeyunubisia. ");
INSERT INTO ded_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Goa ngeni kondunnu wageu emma kenggec nga goa ngeni dokutoau kengkecma finac mehama ngicngac yenearu suegec. ");
INSERT INTO ded_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Ngeni ihai kecma KEBUNGO ua kuneng sasawa mekefec, imoc hengkecgec. Ngeni yeac ua bibiagoc kondunggac keme kemeau henggec. ");
INSERT INTO ded_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Yeng enacngo deu firang kucgoc kpema kondunggac siri miaru kucgoc kpeu ");
INSERT INTO ded_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","wagenginango sawau yombong emma emu keme kemeau yombong kemegec ngic ngeni ebic imoc hemma ongangina worau kengecngunuec. ");
INSERT INTO ded_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Ngeni kicngina gigiu ngic doku seria neandae, ifi isoc goroc goroc amma kengha amma negen negengngina mi ireckeec. ");
INSERT INTO ded_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Ngeni ebicfu ifi kecma KEBUARU kiacgec yeng kpendzeng imohacnac mesingunuma ");
INSERT INTO ded_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","firangnomang menomaneu kpac anec nga kondung siri menomaneu ning kpema feec. ");
INSERT INTO ded_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Kondung kuha mau ngeneng ruaegoc kecgecac ubangerec negenggec. Nga yeng wangecngunuu ngeni ihai me ihai kembesonga negenggec, ihai kengsikegec. ");
INSERT INTO ded_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","KEBUNGO yoac dedzege amma imoc modackecde, ngeneng imocac ubangerec memibisia. Yeng bangecngic medacfocngina meficngunuma faka bibiagoc mekecdeac ngeni dangge memibisia. ");
INSERT INTO ded_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Ngeni habu yeneac kpekpeturannu Kebu oyang boyang memima enarafocngina yeneac botucfu namma ye eriendzong memibisia. ");
INSERT INTO ded_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Yeng dokutoa heimerenu bangec gbangge gbanggea anggec. Nga doku kiwagocngo kerengaima bangec gbangge gbanggea anggec. ");
INSERT INTO ded_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Ngicngac areng goa yeneng bangecnginau kecma Anutu ngadehema mangana megecdeac ayemmeec. Imocac yeng bangec kerehagoc imoc merenu bangec kisi kondungagoc anec. ");
INSERT INTO ded_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Ye bangec kisi gbangge gbanggea heimerenu doku dzohong homac fingecgec nga bangec dzangge dzanggea merenu doku dzuamagoc fingecgec. ");
INSERT INTO ded_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Ye ngicngac yakaac homegec, yeni ihai faiyunuu kecma taongngina ihai megec amagerecngina seria anec. ");
INSERT INTO ded_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Yeni semeng nga waing uanginau homecgec fora homac anec. ");
INSERT INTO ded_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Yeng kenecyunuu nambaracfocngina homac fingecgec. Amma ramaburumakangina keneheu yeneac kpetengina mi maec. ");
INSERT INTO ded_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Ngic yeneng ebicfu faiyunugec ubaebicgoc kecma memeficac obohoma ebicfu nga ubahodunggoc kecgec kpetengina mau habu kapianec anggec. ");
INSERT INTO ded_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Anutungo ine ngictauac medacfora yeneac modzea tiu ebic meficgeyemmema bangec kisi singa kpac, ihai faiyunuu kengkpung hakpung ihai kengkecgec. ");
INSERT INTO ded_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Nga ngicngac yeni iwaiac obohoma kpendzennu kecgec, yeng yeni ebicfunac mesiyunuu nambaracfocngina yeneng fingecsahetoa amma rama habutoa angandae, ifi isoc anggec. ");
INSERT INTO ded_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Ngicngac ikoc nga hamangecngina kpac kecandae, yeneng imoc hemma ubangerec negenggecde. Nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneng ine yoacngina waickegecde. ");
INSERT INTO ded_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Mong ye negen negentegecgoc kecde, yeng wiac yomoc hensima negentegecbeso. KEBU ye yoac dedzege amma imoc modarude, bangecfu ngicngac yeneng imoc negenghomebisia. ");
INSERT INTO ded_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Dawidingo mitiyegec yofi heiec. O Anutu, herenango efaiu udumeng gombunga amma yegec heibade. Ubaongana, ge gaunac yacna. ");
INSERT INTO ded_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","O, ni ama werec wereckenggac yombong midibade nga gitakurere ngeri negenggboribesera. ");
INSERT INTO ded_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","O KEBU, ni ngiha ngiha botucnginau ge ohec megemma bangec monnunac ngicngac yeneac botucfu yegec heima ge dengeregubade. ");
INSERT INTO ded_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Geng yoac dedzege amma imoc modackecnec, imocngo wiac engena amma engkecma kurumenga kurumenga feracyunuma enude. Nga ge yoac modac modac angkecnec, faka imocngo sawau emma hoeng kpesereyunuude. ");
INSERT INTO ded_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","O Anutu, ge oyang boyang megengandae, imocngo kurumenga kurumenga ferahema erebeso. Ge kucga nga kibikperagiga bangecfu faina mama bangectoa bangec sokodacbeso. ");
INSERT INTO ded_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Geng ngicngacfocga neneac songo negennec, neni ebicfunac mesinununadeac marifoigango meficnunuma nunumuninaac turunga merennemmena. ");
INSERT INTO ded_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Anutungo womonga kpetiacfu tacma yoac yofi deserima deec, “Ni firang amma sogac sogaigoc Sikeng ama nga Sukocac bangec tumia medereyemmebade. ");
INSERT INTO ded_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gireac nga Manasse imoc neac, Efaraing imoc wasaiopocna nga Yuda ye ngictauyasuna. ");
INSERT INTO ded_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Moabi ye dokunadzic terana nga Edonggaru hanitabena ukuma Firistia bangecfu firang amma arohobade.” ");
INSERT INTO ded_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Dawidingo monggoc yofi deec, “Taong odaya seria fede, mongngo imohai hesicnuu kendedeac negenduae. Mongngo naric hesicnuu Edong bangecfu kendedeac negenduae.” ");
INSERT INTO ded_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","O Anutu, ge wanunuma ukununudacma neneac wasaingichabugoc monggoc mi kengannec. ");
INSERT INTO ded_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Ngicngo meficnunuande, imoc memefihagoc kpac. Imocac geng meficnununa ngabafocnina yunubisina. ");
INSERT INTO ded_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Neni Anutugoc namma kuctoaninagoc amma firang annide. Gennoc ngabafocnina tidzicyununa bangecfu fegecde. ");
INSERT INTO ded_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Yegecgareng yearu. Dawidingo mitiyegec yofi heiec. O dedengerec Anutuna, ge yoacga mi waickena. ");
INSERT INTO ded_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Ngic goa ge waguma mangana megecdeac ayemmeande nga faitobang ngic ikocnginagoc, yeneng memanganenubeso enacngina anggema nedzarangngina ikohagoc neac yoac mangana dema ");
INSERT INTO ded_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","ngadenuma oronnuma memangac manganeyoac denemma hania kpacfu hama nugecde. ");
INSERT INTO ded_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Ni songogoc hoangyunuba yeneng mesunnau nuandae, fora. Nga ni sifu yeneac numubade. ");
INSERT INTO ded_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Ni faka gombunga ayemmeba yeneng turunga mangana merennenggec. Ni songogoc hoangyunuba yeneng ubango ukunugecde. ");
INSERT INTO ded_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Yeni yofi dedae, “Ngic mong Anutu ngadehema mangana meudeac ammiande, ye uayoac mina yeng ngic manganaac yoac kpebeso. Ngic mongngo yoacfu marifoiau namma yeac mesuyau kpebeso. ");
INSERT INTO ded_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Desi desingicngo ye isinggema yoac desima ngic imocac manganaya hembeso nga yeac nunumuya imoc Anutungo negenu kopocsihagoc angkecde, ifi desibeso. ");
INSERT INTO ded_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Kekecnasoya imoc wegenanec anu ngic mongngo yeac ngicenaraac tatac mebeso. ");
INSERT INTO ded_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Nambaracfora yeneng beging anggec enemango hodzec ambeso. ");
INSERT INTO ded_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Nambaracfora yeneng amaheidac kecma yakaac derecgema kecbisia. Yeni amabangec sesuhau kecgec imohai meficyunuma imohacnac ifingoc kporacyunubesonga. ");
INSERT INTO ded_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Ngic mong ye faka sirihau mi amma hiedzo meande, yeng finaha segereu kuricngic yeneng uayaac fora mekecbisia. ");
INSERT INTO ded_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Mongngo ye ubangerec mi ammibeso nga begingfora yeneac ubamangang mi negengyemmebisia. ");
INSERT INTO ded_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Yeac esamedacfora meicyunugec kpac ambisia. Ye esamedacfora yeneac arennu yeac kpac meickebesonga. ");
INSERT INTO ded_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Mangesafora yeneng ngicngac ogofocngina memanganeyunugec, KEBUNGO kopocsicngina imoc negenu febeso. Nga nonggeaac kopocsic imoc naric mi wabesonga. ");
INSERT INTO ded_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Yeneac kopocsic imoc nasosoc KEBUAC kicfu feu hengkecbeso. Ngic imoc bangecfunac meickegec kpac anu yeac nigecyunudacbeso.” ");
INSERT INTO ded_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","“Ye wiac gombunga anudeac nigeckpeu makpekpea nga iwaiac obohoma kecgec, yeni yunukporac ayemmema ubaebicgoc kisangyunuma homecfu faiyunuec. ");
INSERT INTO ded_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Ye sowecyoac deudeac songo negengkefec, imocac yeneng soweckebisia. Ye kenecyoac mi ammiecac kenec yeac hereau febeso. ");
INSERT INTO ded_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Ye sowec ngakpi isoc heima kefecac sowecngo sebifusiau doku isoc kemema sirau kerec isoc kemebeso. ");
INSERT INTO ded_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Sowecngo ngakpitoaya anu kperacemebeso nga kebangau fadeng isoc anu wenacsoc dzegebeso.” ");
INSERT INTO ded_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Ngabafocna yeneng yoacfu nukecgec KEBUNGO turunga imoc kpouyemmebeso. Yeni ngadeyoac denenggec yeng ifi ayemmebeso. ");
INSERT INTO ded_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","O KEBU Anutuna, ge kpac kunenggac amma yoacna dema nanggenuna. Geng yoac dedzege amma imoc modackecnec, imoc fedeac ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Ni ngic makpekpea amma iwaiac obohoma kecduae. Nga yeni herena manau woubocna kpegec tohoec. ");
INSERT INTO ded_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Maraiac ongango hereema tofocnac kpac angkecde, ni ifi isoc kpac ambeso anduae. Firangngo ipua mefiranggeu kengandae, ifi isoc kenduae. ");
INSERT INTO ded_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Ni yakasege kecma fafocna kuha kpac anu sicnasac anduae. ");
INSERT INTO ded_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Ngic mesunau nudae, yeneng desofoc anemma orucngina kpatitickenendae. ");
INSERT INTO ded_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","O KEBU, Anutuna, ge meficnuna. Geng yoac dedzege amma imoc modackecnecac ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","O KEBU, ge marigango wiac imoc menec, yeni imoc negentegecbisia. O Kebu, geng ua imoc menec. ");
INSERT INTO ded_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Yeni sowecyoac dekecdae, naric, nga ge sifu kenecyoac debesena. Ngicngac neac wegenac hama memanganenubeso angandae, yeni ge negemmana game kpekpeu faiyunubesonga. Geac kingang ngicngo ubangerec negemma kecbeso. ");
INSERT INTO ded_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Ngicngac mesunau nuandae, yeni eweheiheia kpac kecbisia. Imocngo wamba isoc sangoyunubeso. Yeni gameyunuu kecdae, imocngo ngakpitoa isoc witinginau embeso. ");
INSERT INTO ded_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Enacbibicnango KEBU oyang boyang ammima ngicngac habutoanginagoc kecdae, yeneac botucfu namma ye oyang boyang memibade. ");
INSERT INTO ded_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Ngic mong ye wiac sasawaac obohoma kefu yeng marifoiau nanude. Yeneng yeac degecde, “Ye manganaac areng amma homebeso.” Ifi degec Anutungo ye yeneac mariunac mesiude. ");
INSERT INTO ded_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Dawidingo mitiyegec yofi heiec. KEBUNGO neac Kebuna yofi edeec, “Ge marifoinau tacmana ngabafocga hanigaac bageau faiyunuba yeni hanigaac tatac anggecde.” ");
INSERT INTO ded_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","KEBUNGO Siong amau tacma ngictauyasuga faiu hau ge imoc mema ngabafocga yeneac botucfu ngictau amma ngic kunengngina kecbesena. ");
INSERT INTO ded_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Ngicfocga yeni dzikac nasou gegoc kenggecdeac songo negemma hama edegugec geng hesicyununa tiki kpetiacfu enggecde. Sacgbori habunginagoc yeni ubaefac amma wamba kpetiac heima asoacac dzimbong heima feande, ifi isoc amma gearu hagecde. ");
INSERT INTO ded_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","KEBUNGO yoac yofi bic deseriec, imoc naric mi meickeude, “Geng Merikisedeac siricfu womonggareng wisic wisickea kpac kecengkecnade.” ");
INSERT INTO ded_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Kebu foigaugeng nande, ye herebunasoya hau ngictau kpedzameyunuude. ");
INSERT INTO ded_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Ye bangeha bangeha ngicngac areng botucnginau tacma isingyunuma yoacngina desiu homegec farengnginango bangecnginau feemeude. Ye bangeha bangeha fekendeu ngic enarafocngina kpetotieyunuude. ");
INSERT INTO ded_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Ye sing tegiau doku mahama feu hemma neudeac oruha miacma kuhagoc nanude. ");
INSERT INTO ded_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","KEBU eriendzong memibesonga, hallelu Yac. Ngicngac uba kongaha amma ikoc nga hamangecngina kpac kecdae, yeneac kpebung habugoc namma heregoc yombong KEBU ubangerec ammibade. ");
INSERT INTO ded_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","KEBUNGO uaya mekecde, imoc wiac engena nga imocac songo negengandae, yeneng imoc negengising angkecdae. ");
INSERT INTO ded_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Kebungo wiac sasawa meec, imocngo ngictauac kuhagoc nga damuyagoc wakema fede. Ye fakaya dindingacngo nasoya nasoya feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Ye uaya bibiagoc meec, imoc yeng negemmanu negenggec fekefude. KEBUNGO neneac ubea manganeu ubangerec anemmeude. ");
INSERT INTO ded_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Ngicngac eweheihei ammiandae, ye yeni yaka yemmeude nga dzadzahac meec, imoc nasoya nasoya negensikefude. ");
INSERT INTO ded_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Kebu ye ngicngacfora uayaac kuc edzacyunuma maridzoming dema bangec monnunac ngicngac yeneac bangec imoc ngicngacfora yemmeec. ");
INSERT INTO ded_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Yeng wiac mariango meande, imoc yoara modacma faka dindingacgoc. Nenang yeac dederecgeyoac sasawa negenserima mekecbisina. ");
INSERT INTO ded_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Ye dederecgeyoac faiu imocngo nasoya nasoya seria fema fefeseri feengkefude. Imoc ikoc nga hamangeha kpac kecma modacma kecbesonga. ");
INSERT INTO ded_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Yeng wiacfora sueyunuu yeneng ngicngacfora yungecyunugec. Ye dzadzaha feengkefudeac yoac seria edeyunuec. Yeac kpac imoc kpetiac nga bibiagoc. ");
INSERT INTO ded_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","KEBU eweheihei ammima ye hoanggebesonga. Faka imoc negen negentegecac hania ande. Ye eweheiheigoc hoanggeandae, yeni negen negengngina irec ireckea. Yeac eriendzong, imoc nasoya nasoya feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","KEBU eriendzong memibesonga, hallelu Yac. Ngic mong ye KEBU eweheihei ammiande nga yeac nonoyoac songotoagoc hoanggeande, ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Yeac esamedacfora yeni bangecfu kucnginagoc kecgecde. Ngicngac areng ikoc nga hamangecngina kpac andae, yeni kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Yeac amau hiedzo finactoa endzirangoc feude amma yeac faka dindingacngo nasoya nasoya feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Ngicngac uba kongaha amma ikoc nga hamangecngina kpac kecandae, yeni kundung manau kecmagec kperagi fingecyemmeude. Kebu ye ubangerec ayemmema ubamangang negengyemmema dindingac kefude. ");
INSERT INTO ded_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Ngic mong ye sing dindingac modacma ngic wosoefac ayemmema yengena wiac turung dema maringinau faiu ua goa meandae, ngic ifia ye naric kecde. ");
INSERT INTO ded_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Ngic dindingac ye seria nanu wiac mongngo meu goroc goroc naric mi anude. Amma ngicngac yeneng yeac negenggec fekefude. ");
INSERT INTO ded_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Ye yarefakaac yoacsiduc negemma kengec naric mi anude. Ye hereango KEBU negenserima kefude. ");
INSERT INTO ded_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Yeac herea imoc seri seria. Ye kengeha kpac serima kecma firang amma ngabafora yenenude. ");
INSERT INTO ded_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Ye songea modacma wiac mederema ngicngac makpekpea yemmeude. Yeac faka dindingac, imoc nasoya nasoya feengkefude nga ye kuhagoc anu ngic yeneng eweheihei ammima nanggegecde. ");
INSERT INTO ded_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Ngic Anutu ngadehema mangana meudeac ammiande, yeng ngic mong dindingac henu kekeha ngereeude, imohai enac kisaranggeu dzameude. Ye wiac mong meudeac negensiande, imoc fora naric mi fingerude, kpac yombong. ");
INSERT INTO ded_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","KEBU eriendzong memibesonga, hallelu Yac. O, KEBUAC kingang ngicfora, ngeni KEBU oyang boyang memima KEBUAC kpac kuneng heiwayong memibisia. ");
INSERT INTO ded_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","KEBUAC kpac kuneng, imoc yaguc kenehema nasoya nasoya kenehekecbesonga. ");
INSERT INTO ded_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Wenac ere ereaunac kengkecma wenac keme kemeau wisickede, imohai KEBUAC kpac kuneng heiwayong memibesonga. ");
INSERT INTO ded_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","KEBUNGO bangeha bangeha ngicngac areng feracyunuma kecde. Yeac kuc kibikperagigoc, imoc kurumenga kurumenga feracyunuma emma feude. ");
INSERT INTO ded_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","KEBU Anutunina kecde, ye isoc mongngo mi kecde, kpac yombong. Ye wi tatahau tacma ");
INSERT INTO ded_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","kiwa fiu mau kurumenga kurumenga nga bangec yenenude. ");
INSERT INTO ded_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Yeng ngic makpekpea sendunnunac memiacyunuude nga ngicngac iwaiac obohoma kecandae, yeni hamaseucfunac meyunuu eregecde. ");
INSERT INTO ded_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Eregec yeng ngictauac medacfocngina yenigoc tatacfu faiyunuu tacgecde. Ye ngicngacfora yeneac ngictauac medacfocngina, yenigoc faiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Ye ngac kufing amagerec miu ye sabac nonggea amma sogaima kefude. KEBU eriendzong memibesonga. ");
INSERT INTO ded_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Israengo Aigita bangec wama erema kenec. O, Yakoboac areng yeni ngicngac kuricyoac dekecgec, yeni wayunuma kenggec. ");
INSERT INTO ded_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Yuda ye Anutuac womong kpetiac anec nga Israe imoc yeac eucererenga anec. ");
INSERT INTO ded_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Kondung ye imoc hemma kpidohoma kenu Yodang doku dzigeneec. ");
INSERT INTO ded_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Tiki yeneng rama ngiwango futuckeandae, ifi isoc futuckegec nga fagang yeneng ramamedaha yuma engemmama angandae, ifi isoc sogac sogaigoc yuma engemmama anggec. ");
INSERT INTO ded_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Kondung ge kpidohoma woranec nga Yodang ge kpidohoma dzigenenec. ");
INSERT INTO ded_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","O tiki, ngeni kpidohoma rama ngiwa isoc futuckedae nga fagang ngeni kpidohoma ramamedaha isoc yuma engemmama andae. ");
INSERT INTO ded_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","O bangec, ge KEBUAC kicfu dendeng kpekecbesena. Ge Yakoboac Anutu yeac kicfu gbigbihebesena. ");
INSERT INTO ded_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Yennoc hoc peperandzi seria heimerenu doku dzohong angkecde nga harongang heimerenu doku kiwa anude. ");
INSERT INTO ded_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","O KEBU, ge neneac kpac mi miacbesena, kpac. Geng yoac dedzege amma imoc modackecnec nga ge yoac modac modac Kebu, imocac geac kpac kuneng imoc eweheiheigoc kpacbesonga. ");
INSERT INTO ded_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Bangec monnunac ngicngac Anutu mi negemmidae, yeneng deandae, “Yeni Anutungina mong mi hendimbe, kpac.” Yeni nocac ifi deandae? ");
INSERT INTO ded_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Anutuninango kurumenga kurumenga, imohai kecma songoya modacma uaya mekecde. ");
INSERT INTO ded_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Ngicngac Anutuac yoac ifi deandae, yeneac nemuongangina siriwa nga golngo memea, yeni bangecngic yeneac marikibisac. ");
INSERT INTO ded_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Yeni enacbibicnginagoc nga yoac ine naric mi degecde. Yeni kicngina noboc noboc amma wiac naric mi henggecde. ");
INSERT INTO ded_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Yeni kedzacngina noboc noboc amma wiac mong naric mi negenggecde. Yeni samacnginagoc amma wiac monggac homuna naric mi homunggegecde. ");
INSERT INTO ded_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Yeni maringinagoc nga maringinango wiac mong naric mi menegenggecde. Yeni haninginagoc nga haninginango sing naric mi kenggecde amma ubanginango udumeng mong naric mi meficgegecde. ");
INSERT INTO ded_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Ngicngac nemuonga meyunuandae, yeni nemuonga isoc angggec. Nga nemuonga negenserima kecandae, yeni sasawango nemuongangina isocngoc anggecde. ");
INSERT INTO ded_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","O Israe ngicngac, ngeni KEBU negenserima kecbisia, yennoc memeficngina nga kasongina. ");
INSERT INTO ded_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","O Aronggac ama areng, ngeni KEBU negenserima kecbisia, yennoc ngeneac memefic nga kasongina. ");
INSERT INTO ded_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Ngicngac KEBU eweheiheigoc hoanggeandae, ngeni KEBU negenserima kecbisia, yennoc ngeneac memefic nga kasongina. ");
INSERT INTO ded_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","KEBUNGO neneac negenside. Yeng kenecnunuude, ye Israeac ama areng kenecyunuma Aronggac ama areng kenecyunuma ");
INSERT INTO ded_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","ngicngac KEBU eweheiheigoc hoanggeandae amma ngicngac kuneng nga kapia kenecyunuude. ");
INSERT INTO ded_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","KEBUNGO ngeni nga nambaracfocngina mesahengunubeso. ");
INSERT INTO ded_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","KEBU kurumeng nga bangec meficyuruec, yeng kenecngunubeso. ");
INSERT INTO ded_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Kurumenga kurumenga yeni KEBU yengena ama nga bangec imoc ngicac medacfocngina kecdimbeac nemmeu ihai kecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Homemea yeni KEBU eriendzong naric mi memigecde, kpac. Ngicngac ningkpe fedae, yeneng ye naric mi dengeregecde, fora. ");
INSERT INTO ded_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Nga KEBU dengerenide. Neni ye yofinenggac kenehema kecma nasoya nasoya kenehenide. KEBU eriendzong memibesonga, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Ni KEBUARU kpesi kpesi faiba yeng ubaudumenna negenecac ye songogoc hoanggebade. ");
INSERT INTO ded_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Ye kedzaha nearu faiecac amma ni kecbadesoc kpakpacna yearu kpacba kengkefude. ");
INSERT INTO ded_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Homecac witicngo dedecnuu homec amaac kengec amma ubaebicngo mendannuu ni ubaebic nga kengecgoc kecma ");
INSERT INTO ded_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","KEBUAC kpac kuneng kpacma yofi deai, “O KEBU, ge kekecna ebicfunac mesina.” ");
INSERT INTO ded_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","KEBU ye wosoefac nga faka dindingacac KEBU. Anutuninango ubamangang anemmeude. ");
INSERT INTO ded_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Ngicngac negen negengtoangina kpac kecgec KEBUNGO yeni onggongyunuude. Ni memeficac obohobare yeng ebicfunac mesinuec. ");
INSERT INTO ded_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","O ubaongana, KEBUNGO ubangerec homac anggenu naric kecnecac amma ge ruaegoc monggoc kecbesena. ");
INSERT INTO ded_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Ge ubaongana homecfunac mesima kickumana mekerenggena tifainggema manubacac hanina onggonggenec. ");
INSERT INTO ded_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","KEBU, ni geac kicfu kekecnginagoc yeneac bangecfu kengkecbadeac ifi annec. ");
INSERT INTO ded_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Ni yofi deai, “Ni kpendzeng kuneng kpema kecduae.” Ni negen negensinggoc kefaiac ebicnasou ifingoc negensinggumangoc kefai. ");
INSERT INTO ded_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Nga ubaebicnagoc kecma deai, “Ngic sasawa yeni ikocnginagoc.” ");
INSERT INTO ded_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","KEBUNGO ni gombunga anemma wiac sasawa nenu ni naric kecma imocac turunga noc wiac ammiba ngereeudeac obohoude. ");
INSERT INTO ded_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Ni memengerecac kpakenec mema miacma KEBUAC kpac kuneng kpacbade. ");
INSERT INTO ded_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Ni yoac KEBUAC kicfu deseriai, imoc ngicngacfora sasawa yeneac kicfu namma fora meficgebade. ");
INSERT INTO ded_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","KEBUAC ngicngac kpetiac homedae, imocngo yeac kicfu wiac buma kuneng ande. ");
INSERT INTO ded_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","O KEBU, ni geac kingang ngicga amma uangacgaac medac. Gennoc witicfunac mesinunec. ");
INSERT INTO ded_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Ni ubangerecac sese faigemma KEBUAC kpac kuneng kpacbade. ");
INSERT INTO ded_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Ni yoac KEBUAC kicfu deseriai, imoc ngicngacfora sasawa yeneac kicfu namma fora meficgebade. ");
INSERT INTO ded_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Imoc Yerusareng, geac botuhau KEBUAC ama tacde, imocac amabangecfu ambade. KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Bangec monnunac ngicngac, ngeni KEBU fendzonggema dengerebisia. Ngiha ngiha sasawa ngeni KEBU afehebisia. ");
INSERT INTO ded_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Yeng yoac dedzege amma imoc modackecde, faka imocngo hoannunuude, imoc wiac engena. KEBUNGO yoara modackecde, faka imocngo nasoya nasoya feengkefude. KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","O, KEBU ye gombunga, yeng yoac dedzege amma imoc modackecde, faka imoc nasoya nasoya feengkefude, imocac ubangerec memibesonga. ");
INSERT INTO ded_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Israe habu ngeneng yofi debisia, “Yeng yoac dedzege amma imoc modackecde, faka imoc nasoya nasoya feengkefude.” ");
INSERT INTO ded_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Aronggac ama areng ngeneng yofi debisia, “Yeng yoac dedzege amma imoc modackecde, faka imoc nasoya nasoya feengkefude.” ");
INSERT INTO ded_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Ngicngac KEBU eweheiheigoc hoanggeandae, ngeneng yofi debisia, “Yeng yoac dedzege amma imoc modackecde, faka imoc nasoya nasoya feengkefude.” ");
INSERT INTO ded_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Ni ebic kuneng mema KEBU kpacba KEBUNGO kpakpacnaac turunga meremma ebicfunac yungecnuec. ");
INSERT INTO ded_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","KEBU ye nigoc kefu ni naric mi kengecnuude. Ngic yeneng wiac mong naric mi anenggecde. ");
INSERT INTO ded_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","KEBU ye memeficna amma nigoc wegenac kecdeac ni firang amma ngic ubango ukunudae yenemma nambade. ");
INSERT INTO ded_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Nenang KEBUAC hoannu kemma sufuma kecni ngereede. Ngic negensingyununi memefihagoc yombong mi ande. ");
INSERT INTO ded_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","KEBUAC hoannu kemma sufuma kecni ngereede. Ngictau medacfocngina negensingyununi memefihagoc mi ande. ");
INSERT INTO ded_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Bangec monnunac ngicngac Kebu mi negendae, yeni sasawango oronnudacgec ni KEBUAC kpacfu firang amma kporacyunuba kpac anggec. ");
INSERT INTO ded_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Yeni noboc noboc oronnuma kecgec, fora. Nga ni sifu KEBUAC kpacfu firang amma kporacyunuba kpac anggec. ");
INSERT INTO ded_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Yeni sangobide isoc noboc noboc oronnugec kate dzema borang tima bic bokoande, ifi isoc anggec. Ni KEBUAC kpacfu firang amma kporacyunuba kpac anggec. ");
INSERT INTO ded_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Yeneng kucgoc kpefacnugec manubesonga anec, fora. Nga KEBUNGO ine meficnuec. ");
INSERT INTO ded_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","KEBU ye neac kuc nga yegecna. Yennoc neac memengerecna. ");
INSERT INTO ded_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Ngicngac dindingac yeneng firang amma kporucbedzonginau sogac sogaiac yegec heigec yegecngina negembisia. “KEBUAC marifoingo faka bibiagoc amma firang andac. ");
INSERT INTO ded_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","KEBUNGO marifoia miaru sawau yacde. KEBUAC marifoiango faka bibiagoc amma firang andac.” ");
INSERT INTO ded_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Ni naric mi homebade. Ni ine gbori kecma KEBUNGO uaya mekefec, imoc dekperagibade. ");
INSERT INTO ded_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","KEBUNGO kopocsicnaac amma kpemeting ebirangoc anenec, fora. Nga homecac mariu mong mi fainuec. ");
INSERT INTO ded_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Ngeni dindingac kekec womongamaac nagutoa witinenggec ni imohai emma KEBU ubangerec memibade. ");
INSERT INTO ded_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","KEBUAC nagu yomoc nga ngicngac dindingac yeneng imohai enggecde. ");
INSERT INTO ded_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Ge yoacna turunga merennenna memengerecna amma meficnunec. Imocac geac ubangerec megembade. ");
INSERT INTO ded_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Amameme ngic yeneng hoc mong mangana dema ukugec. Nga hoc imocngo amaac hoc wotung amma seria nanude. ");
INSERT INTO ded_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","KEBUNGO faka meu imocngo nenang kicfu wiac bibiagoc ande. ");
INSERT INTO ded_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","KEBUNGO uamemenaso yomocnoc meu nenang naso yofinenggac sogaima ubangerec negenni. ");
INSERT INTO ded_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","O KEBU, neni kpacsambic amma yofi dedimbe, “Ge ebicfunac mesinununa. O KEBU, neni naric kecnideac gombunga anemmena.” ");
INSERT INTO ded_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Ngic KEBUAC kpacfu erahade, ye kenehagoc. Neni KEBUAC amau namma kenecngunukecdimbe. ");
INSERT INTO ded_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","KEBU ye Anutu. Yeng kperagi nemmeu imocngo mekperaginunuec amma mekperaginunuude. Ngeni ic maria sabayagoc maringinau mema arennu hakecma hombanggac sese mehagec, imoc witicngo arata baihau dedeckebisia. ");
INSERT INTO ded_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Ge Anutuna. Ni eriendzong megembade. Ge Anutuna, imocac afegubade. ");
INSERT INTO ded_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","KEBU ye gombunga, yeng yoac dedzege amma imoc modackecde, faka imoc nasoya nasoya feengkefude, imocac ubangerec memibesonga. ");
INSERT INTO ded_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Ngicngac yeni kopocsic mong mi meficgema kecma KEBUAC dedeseri modacandae, yeni kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","KEBUNGO yoac ngicngac dekperagiyemmeu yeneng imoc modacma heregoc ye hofocandae, yeni kenecnginagoc amma ");
INSERT INTO ded_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","kopocsic mong mi meficgema yeac hanising modacma kengkecgecde. ");
INSERT INTO ded_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","KEBU, geng dederecgeyoacga nemmena imoc serima modacnideac negennec. ");
INSERT INTO ded_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Ni geac singyoac seria tofohoma sing imoc hafoangoc yombong modacma kecbadeac yombong anende. ");
INSERT INTO ded_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Ni geac nonoyoac sasawa hengkecba ngic yeneng game kpekpeu naric mi fainugecde. ");
INSERT INTO ded_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ni geac dederecgeyoac dindingac negen negennau arenggeba herenau ikoc nga hamangec mong mi feu ge dengeregubade. ");
INSERT INTO ded_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","O, ni geac singyoac modacbade. Kebu ge ni mi ngadenuma wanudacna. ");
INSERT INTO ded_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Sebigbori medac ye singau garengemema uba kongaha kefude, sing imoc eng mi meficgeude, kpac. Ye geac yoac gombunga modacma garengemeude, imohai naric kefude, ");
INSERT INTO ded_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ni heregoc hofocguduae. Geac nonoyoac kpebaiac garennuma kpae heinenna. ");
INSERT INTO ded_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Ni yoacga kpema kopocsic meficgebaiac yoacga herena manau faiba feude. ");
INSERT INTO ded_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","O KEBU, kenecgubisina. Ge singyoacga kpounenna ni imoc negen negennau arenggema mekecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Enacgaac dederecgeyoac sasawa, imoc enacbibicnango dekperagibade. ");
INSERT INTO ded_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ngicngac yeneng dzofinacnginaac sogaiandae, ni ifi isoc geac dedekperagiyoac negemma sing imoc modacma sogaibade. ");
INSERT INTO ded_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ni geac dederecgeyoac hennegeng amma imoc negensikecma kicna fima geac sing hengkecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Ni singyoacgaac ubangerec negemma geac yoac naric mi nigecnuude, kpac. ");
INSERT INTO ded_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Ni, kingang ngicgango gbori kecma yoacga tofohobadeac gombunga anenna. ");
INSERT INTO ded_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Wiac gombunga gombunga dedeseriyoacgau fede, imoc hembadeac kicna merecgena. ");
INSERT INTO ded_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Ni bangecfu kuric kecduae. Ge nonoyoacga nearunac mi mesufuna. ");
INSERT INTO ded_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Ubaonganango nasosoc geac dederecgeyoac negembeso ammiu kuha kpac ambeso ande. ");
INSERT INTO ded_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Anutu ge ubakpekpe ngic yoac ngabasiric ayemmeannec, yeni geac nonoyoac wama ngadehema kecgec ge sowecyununec. ");
INSERT INTO ded_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Ni geac dedekperagiyoac modackecduaeac amma yeni desofoc nga desusuic anendae. Ge faka imoc meickenenna kpac ambeso. ");
INSERT INTO ded_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Ngictau yeneac medacfocngina yeneng tacma ni memanganenugecdeac yoac denegeng angandae, fora. Nga ni, geac kingang ngicngo sifu geac singyoac hennegeng amma imoc negensikecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Geac dedekperagiyoacngo ni ubangerec meficgenemma dederecge gombunga anenude. ");
INSERT INTO ded_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Ubaonganango sendunggoc kpeketahema homebeso ande. Ge yoacga dema deserinec, imoc modacma kekecna monggoc megborina. ");
INSERT INTO ded_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ni haniana edeguba geng imocac turunga merennemma singyoacga kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Geng meefainuna dederecgeyoacgaac sing negentegecma uaga bibiagoc hennegeng amma negensikecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Ubaebicngo ubaongana meebiriu sisingaima kpac ambeso ande. Ge yoacga denec, imoc modacma monggoc meserinuna. ");
INSERT INTO ded_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Ge ikocfakaunac onggonnuma ubangerec anemma dedeseriyoacga kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Ni yoac modac modac ngic ambeso negenduaeac sing imoc meisinggema kengkecduae. Ni dederecgeyoacga kicnau faiba fede. ");
INSERT INTO ded_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","O KEBU, ge dedekperagiyoacga nennec imoc seria mekecduaeac goa yeneng desofoc anembauac kpae heiyemmebesena. ");
INSERT INTO ded_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Ge negen negentegecna meyadikecna geac nonoyoacgaac sinnu nedzikecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","O KEBU, ge singyoacga fainec, imocac sing kpounenna. Ni imoc negen negennau arenggema modacma kengkecba kekecna wisickebeso. ");
INSERT INTO ded_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Ni dedeseriyoacga modacma heregoc imoc tofohobadeac negen negentegec nenna. ");
INSERT INTO ded_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Nonoyoacgaac ubangerec negenduaeac sing imohai hesicnuna. ");
INSERT INTO ded_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Ge herenaunac bangecac songo meickema geac dedekperagiyoacngo seria febeso. ");
INSERT INTO ded_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Wiac hania hania uaya kpac fede, ni kicna imohai fibaiac kicna garenggena kekecna geac sinnu kengkecbeso. ");
INSERT INTO ded_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Ngicngac goi heigengandae, yeni wiac yemmebesonga deserima denec, imoc kingang ngicga nearu meserima edzacnuna. ");
INSERT INTO ded_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Geac dederecgeyoac sasawa imoc gombunga. Game kpekpeu fainugec kengecgoc kecbaiac ebic imoc meickenenna. ");
INSERT INTO ded_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Ge fakaga dindingac imocac amma kekecna megborima kekec monggoc nenna. Negenna, ni geac dederecgeyoac negembadeac anende. ");
INSERT INTO ded_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","O KEBU, geng yoac dedzege amma imoc modackecnec, geac faka imocngo nearu habeso. Ge ebicfunac mesinunadeac deserima denec, faka imocngo ifingoc nearu habeso. ");
INSERT INTO ded_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Ifi anu ngic goa deendema anengandae, yeni turunga naric merengyemmebade. Ni geac yoac negenserima kecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Ni yoac forau kecma yoac fora dekecduae, imoc kpac ambacac ge imoc enacnaunac mi meickebesena. Ni geac dederecgeyoac negensikecba fora fingerudeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Ni geac dedeseriyoac nasoya nasoya modackecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Ni geac dederecgeyoac meficgebadeac ua mekefaiac witiha kpac kengha ambade. ");
INSERT INTO ded_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Ni ngictau yeneac kicfu ifingoc geac dedekperagiyoac ayemmeba game kpekpeu naric mi fainugecde. ");
INSERT INTO ded_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Ni geac dedeseriyoacac songo negemma yoac imoc ubangerecgoc debade. ");
INSERT INTO ded_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Ni nonoyoacgaac songo negemma marina miacma fendzonggema singyoacga hennegeng amma negensikecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Ge ni, kingang ngicga yoac edenunec, imoc negenna febeso. Ge imoc denenna negensikecba fora fingerudeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Geac dedeserigango kekec meficgenenu kpendzeng kpekecbare wiac imocngo meserinuude. ");
INSERT INTO ded_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Ngic Anutu ngadehema kecdae, yeneng deendema anengandae, fora. Nga ni sifu geac dedeseriyoac mong mi ngadehema wabade. ");
INSERT INTO ded_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","O KEBU, ge dederecgeyoacga warac yombong denec, imoc negensikecba imocngo meserinuude. ");
INSERT INTO ded_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneng geac dederecgeyoac ngadehema wagec, imocac amma herebu negemba herena gerec dzeude. ");
INSERT INTO ded_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Ni yei kuricngic amma amanginau kecbare singyoacgango ubangerecyegecna anu heibade. ");
INSERT INTO ded_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","O KEBU, ni tofocnac geac kpac kuneng negemba feu geac dedeseriyoac modackecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Ni dederecgeyoacga modackecba imoc fingecnenu neac kenec ande. ");
INSERT INTO ded_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","O KEBU, ge neac areng nga yeneng bangec isoc mederema noboha nenggec, imoc ge. Ni yoacga modacbadeac geac kicfu deserima deduae. ");
INSERT INTO ded_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Ge neac negenna ngereeude, imoc meficgebadeac herenango hafoa uatoa meai. Ge yoac deserima denennec, imoc modacma wosoefac anenna. ");
INSERT INTO ded_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Ge faka modackecnec, imoc negensima geac dedekperagiyoacga modacbadeac nananna mengereba geac yoacgau kenude. ");
INSERT INTO ded_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Ni naso mi ukuma geac nonoyoac bic yombong modacma uaya mebade. ");
INSERT INTO ded_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneac witicngo dedecnuande, fora. Nga ni geac dedeseriyoac sifu mong mi nigecnuude. ");
INSERT INTO ded_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Ni tofocnac dzongiau yacma dedeseriga dindingac negemma imocac dengeregukecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Ngicngac geac eweheihei angandae nga dederecgeyoacga modacandae, yeneac ogongina. ");
INSERT INTO ded_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","O KEBU, geng yoac dedzege amma imoc modacnade, fakaga imocngo bangec sokoma fede. Ge singyoacga kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","O KEBU, ge yoacga modacma ni, kingang ngicga, gombunga anengkecnec. ");
INSERT INTO ded_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Ni geac nonoyoac negensinggeduaeac negen negentegec nga negengising faka gombunga kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Ni kpendzenga kpac kefai, imohai sing segema kengkefai. Nga yofinenggac geac yoac modacbade. ");
INSERT INTO ded_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","KEBU, ge gombunga amma faka gombunga angannec. Ge singyoacga kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Ngic Anutu ngadehema kecdae, yeneng ikoc amma ngadeyoac dema enacfu faifai anengkecdae, fora. Nga ni sifu geac dederecgeyoac heregoc modackecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Ngic Anutu wagec, yeni ubaseri amma tosofocngina yeneac ubamangang negenggecdeacsoc mi ande, fora. Nga ni sifu geac dedeseriyoacac ubangerec negengkecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Ge ebic meficgenennec, imoc negemba ngereede. Ge ifi anna geac singyoac haniaac negen negeng mema arenggekecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Geac enacgaac dedeseriyoac, imocngo wiac engena ande. Imocngo ngereenende nga imoc hoc gol nga siriwango memea taoseng nga taoseng feracyunuude. ");
INSERT INTO ded_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Geng meficnuma marigango menuma memengere anennec. Ni nonoyoacgaac negen negeng arenggema mekecbadeac anende. Ge imocac negen negentegec nenna. ");
INSERT INTO ded_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Ni geac yoac negensiba fora fingerudeac tomai kefaiac amma ngicngac goa eweheihei anggengandae, yeneng nemma sogaigecde. ");
INSERT INTO ded_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","O KEBU, geac singyoac imoc dindingac nga gennoc yoac modac modac Kebu, imocac ebic meficgenennec, imoc negenduae. ");
INSERT INTO ded_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Ge ni, kingang ngicga, yoac deserinennec. Ge yoac imoc modacma faka anenna. Geng yoac dedzege amma imoc modackecnec, ge efaima fakaga imocngo ni, kingang ngicga, meserinuna. ");
INSERT INTO ded_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Ni dedeseriyoacgaac ubangerec negenduaeac ubamangang anenna gbori kecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Ngic Anutu ngadehema kecdae, yeneng hania kpacfu mangana anenggecac ge negemmana game kpekpeu faiyunubesonga. Ni geac dederecgeyoac hennegeng amma imoc negensikecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Ge eweheiheigoc hoangguma kecandae, yeneng naric nearu hama geac dedekperagiyoac negembisia. ");
INSERT INTO ded_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Ngicngac goa yeneng gameu fainubauac herenango geac singyoacfu seria kpeketaheu kopocsic mong mi meficgebesare. ");
INSERT INTO ded_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Ubaonganango geac memengerecac ammikefu yoacga negensiba fora fingerudeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Kicnango dedeseriga fora fingeru hembadeac fikecba kuha kpac anu yofi deanduae, “Ge hama meserinunade, naso imocac tomai kecduae.” ");
INSERT INTO ded_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Ni waing sebera hosucfu fekecma harandanggeande, ifi isoc anai, fora. Amma dedeseriyoacga sifu mi nigecnuec, kpac. ");
INSERT INTO ded_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Ni, kingang ngicgango naso dafiguc ebicfu kecma tomai kecbesare? Ngic nukporac anengandae, yeni turunga yemmenade, naso imocac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Ngic Anutu ngadehema kecdae, yeneng menugecdeac teng keme kemea usugec. Ngic imoc yeni geac dedeseriyoac kpema kecdae. ");
INSERT INTO ded_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Ge nonoyoac sasawa dekecnec, imoc yoac fora. Ngic yeneng ine ikoc amma nukporac anengkecdaeac meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Yeni bangecfu kekecna kpetotiebeso anggec, fora. Nga ni sifu dederecgeyoacga mekecma imoc ngadehema mi wayai. ");
INSERT INTO ded_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Geng yoac dedzege amma imoc modackecnec. Ni enacgaac dedekperagiyoac modacbadeac fakaga imocngo kekecna onggonggena. ");
INSERT INTO ded_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","O KEBU, geac yoac imoc kekecseri. Imoc nasoya nasoya kurumenga kurumenga, imohai fefeseri fekefude. ");
INSERT INTO ded_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Ge yoacga modackecnec, imocngo fingecsahenina fekefudesoc, yenearu feengkefude. Geng bangec tatahau faina seria tarudengoc. ");
INSERT INTO ded_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Geng yoac dema wiac sasawa faiyemmenec. Imocac amma imoc yofinenggac fedengoc. Wiac sasawa fedacde, yeni geac enac tofohogecde. ");
INSERT INTO ded_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Geac dedeseriyoacngo ubangerec mi meficgenembacfu kpendzennango mebucnuu kpac ambai. ");
INSERT INTO ded_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Ge dederecgeyoacga faima kekec nennecac amma dederecgeyoacga naric mi nigecnuude. ");
INSERT INTO ded_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Ni geac ngic nga dederecgeyoacga meficgebadeac ua mekefaiac ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneng memanganenuma meicnugecdeac tomai feandae, fora. Nga ni sifu dedekperagiyoacga negensima kecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Wiac gombunga nga sirihau, imoc sasawa hemba wisic wisickea feu maya kpesereai. Nga geac dederecgeyoac imoc maya kpac feecngoc fede. ");
INSERT INTO ded_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","O, ni geac dedeseriyoacac songo homac yombong negemma asoacnac kemma marai imoc hennegeng amma negensima kecanduae. ");
INSERT INTO ded_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Geac dedeseriyoac, imoc nasoya nasoya nearu fekecdeac imocngo ngabafocna feracyunuma negen negentegec homac meficgenenude. ");
INSERT INTO ded_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Ni dedekperagiyoacga hennegeng amma negensikecduaeac negen negentegecgoc amma kpoukpoufocna feracyunubade. ");
INSERT INTO ded_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Ni geac dederecgeyoac modackecduaeac ngicngac kifangina homac kecgec feracyunuma monggoc negentegecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Ni yoacga modacbadeac amma haninango yarengic yeneac sing mangana hania hania tibaiac hanina kpae heimima garenggekecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Geng dederecgeyoacga kpounennecac amma imoc naric mi ngadehema wabade. ");
INSERT INTO ded_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Ni yoacga negemba songea yombong ande, enacnau imoc kukundzauac songea ferahade. ");
INSERT INTO ded_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Geac dederecgeyoacngo negen negentegec nenudeac sing ikoha sasawa imocac modzona tiude. ");
INSERT INTO ded_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Geac yoac, imocngo haninaac kifa amma sinna mekperagiude. ");
INSERT INTO ded_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Ni dedeseriyoacga dindingac modacbadeac yoac deserima imoc meseriai. ");
INSERT INTO ded_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","O KEBU, ni ebicnagoc yombong kecduae. Ge yoacga modacma kekec nenna. ");
INSERT INTO ded_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","O KEBU, ni efaima enacnango dedengerec sese megenduae, imocac negenna ngereebeso. Ge dederecgeyoacga kpounendacna negen negeng imoc arenggema mekecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Ni kekecna marinau mekecduae, fora. Nga dederecgeyoacga sifu mong mi nigecnuude. ");
INSERT INTO ded_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneng botac faima menubesonga angandae, fora. Nga ni dederecgeyoacga modackecma sing mi segebade, kpac. ");
INSERT INTO ded_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Geac dedekperagiyoac, imoc nasoya nasoya maridzominna fefeseri fenenude. O, herenango imoc negemma sogaima kecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Herenango geac singyoac nasoya nasoya angammemenango modacbadeac isinggeai, ni ifi kecba naso wisickeude. ");
INSERT INTO ded_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Ngic monde monde kecdae, yeneac modzona tiu geac dedeseriyoacac songo negengkecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Ge sufu sufuamana nga kasona nga ni geac yoac negensiba fora fingerudeac tomai kecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Ni Anutunaac nonoyoac modacbadeac negenduae. Yarengic ngeni imocac wanuma kembisia. ");
INSERT INTO ded_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Ge yoac deserima denec, imoc modacma garennuna gbori kecbade. Ni negen negensina foragoc mi ambacac ngic yeni geng negemmana game kpekpeu mi fainubisia. ");
INSERT INTO ded_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Ge marinau menuma nanggenuma onggonnuna. Ni geac singyoac negensima kecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Ngicngac sing segema singyoacga kpeandae, yeni ikocnginagoc kecgec uatoanginango fora mong mi meficgeude. Ge imocac ngadeyunudacnec. ");
INSERT INTO ded_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Geng ngic Anutu ngadehema mangana megecdeac ayemmeande, yenenna seuc isoc angkecde, imocac amma ni dedekperagiyoacgaac songo negengkecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Ni geac kengec amba sebinango gbigbihekecde nga geng yoacna isinggema desinade, imoc negemma negengfagunggoc kecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ni singyoac mi kpema faka dindingac angkefai. Ngic yeneng ebicfu fainubeso ambauac onggonnuma yeneac mariu mi fainuna. ");
INSERT INTO ded_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Ni, kingang ngicgango naric kecbadeac nenggareng anenna. Nga ngic Anutu wama kecandae, yeneng ebicfu fainubauac geng onggonnuna. ");
INSERT INTO ded_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Ge faka dindingac modacma deserima ebicfunac mesinunadeac denec, imocac fora fingerudeac kicfifi kecba kicna kuha kpac ande. ");
INSERT INTO ded_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Geng yoac dedzege amma imoc modackecnec. Ge ni, kingang ngicga gombunga anemma singyoacga kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Ni geac kingang ngic amma dedekperagiyoacga arenggema negembadeac negen negentegec nenna. ");
INSERT INTO ded_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Ngicngac yeneng dedeseriyoacga kpegecac KEBU, ge efaina, uaga menadeac naso bic hade. ");
INSERT INTO ded_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Ni imocac geac nonoyoacac songo negenduae. Nga imocngo golac songo ferahaude, imoc goltegeng pirac pirac, imocac songo ferahaude. ");
INSERT INTO ded_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Ni imocac geac dederecgeyoac sasawa modacma imocac sing tikecma sing ikoha hania hania tibeso modzona tiude. ");
INSERT INTO ded_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Geac dedekperagiyoac imoc wiac engena, imocac ubaonganango imoc modackefude. ");
INSERT INTO ded_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Ge yoacgaac nagu witina imocngo ngicngac mekperagiyemmema ngicngac negen negengngina efea, yeni negen negentegec yemmeude. ");
INSERT INTO ded_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Ni nonoyoacgaac homac anenu enacna anggema asoringa anenu kecanduae. ");
INSERT INTO ded_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Ngicngac geac kpac kunenggaac songo negengandae, ge neneac anggengandeac nearugeng dzigenema neac ubaga manganeu. ");
INSERT INTO ded_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Faka manganango kekecna garenggeu ngicngac ogofocna memanganeyunubaiac singtitina meserina. Ge yoac deserima denec, imoc modacbesare. ");
INSERT INTO ded_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Ge meficnuna dederecgeyoacga modackecbade. Ngic yeneng ebicfu fainugec ubaebicgoc kecbaiac bummenuma yeneac witicfunac yungecnuna. ");
INSERT INTO ded_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Ge ni, kingang ngicga kicmesugango nerarannuma singyoacga kpounenna. ");
INSERT INTO ded_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Ngicngac yeneng geac dedeseriyoac mi modacandaeac kickumanango doku isoc made. ");
INSERT INTO ded_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","O KEBU, ge dindingac nga yoac isinggema foraya desiannec, imoc dindingac sasawa. ");
INSERT INTO ded_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Ge dedekperagiyoacgaac sing dindingac modacma yoacga imoc faima modackecma fainemmenec. ");
INSERT INTO ded_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Ngabafocna yeneng geac yoac nigecyunuandeac herena gerec dzeu kpac ambeso anduae. ");
INSERT INTO ded_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Geng yoac deserima denec, imoc ngicngac bic tobanggegec fora ande. Nga ni, kingang ngicgango imocac songo negenduae. ");
INSERT INTO ded_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Ni ngictehec nga sure surea, fora. Nga geac dederecgeyoac imoc naric mi nigecnuude. ");
INSERT INTO ded_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Geac dindingac kekec imocngo nasoya nasoya fefeseri feude nga geac dedeseriyoac, imocngo fora. ");
INSERT INTO ded_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Ebic nga kpendzeng nearu fingecande, fora. Nga geac nonoyoacngo ubangerec meficgenenude. ");
INSERT INTO ded_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Geac dedekperagiyoac sasawango nasoya nasoya dindingac feengkefude. Ge negen negentegec nenna gbori kecbesare. ");
INSERT INTO ded_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","O KEBU, ni heregoc kpacguduaeac negennenna. Ge ifi anna ni geac singyoac modacbade. ");
INSERT INTO ded_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Ni gearu yofi kpacba, “Ni dedekperagiyoacga gombunga modacbadeac, ge ebicfunac mesinuna.” ");
INSERT INTO ded_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Negen negenna geac yoacfu faima tomai kecba ama mi wereckemmanu geng meficnunadeac yacma kpacgubade. ");
INSERT INTO ded_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Ge yoac deserima denec, imoc tofocnacsoc hennegeng amma negensikecbadeac naso herea gaugbori kecanduae. ");
INSERT INTO ded_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","O KEBU, geng yoac dedzege amma imoc modacnade, imocac ubaudumenna negenna. Ge sing dindingac modacma ngic isinnunuma yoacnina desiannecac kekecna onggonggena. ");
INSERT INTO ded_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Ngic goa yeneng geac dedeseriyoacac hereau yombong kecma yarefaka megecdeac ayemmeu imoc arenggema neac wegenac hama nukporac anenggecde. ");
INSERT INTO ded_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","O KEBU, geng sifu neac wegenac kecnecngoc. Geac nonoyoac imoc sasawa fora ande. ");
INSERT INTO ded_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Ni geac dedekperagiyoac bicngoc negemma yofi negengkefai, “Geng yoac imoc fainec nga imoc nasoya nasoya feengkefude.” ");
INSERT INTO ded_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Ni geac dedeseriyoac imoc mi nigecnuude. Ge imocac kpendzenna hemma imohacnac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Ge yoacfu meficnuma nanggenuma bummenuma yungecnuna. Ge yoac deserima denec, imoc modacma kekec monggoc nenna. ");
INSERT INTO ded_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni geac singyoac meficgegecdeac ua mong mi mekecdae. Yeni imocac geac memengerecac hereau kecdae. ");
INSERT INTO ded_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","O KEBU, geac ubamangang imoc wiac engena. Ge sing dingdingac modacma isinnunuma yoacnina desiannec, imocacsoc anenna kekecgoc ambade. ");
INSERT INTO ded_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Ngic homacngo nukporac anemma ngaba anengandae, fora. Nga ni geac dedekperagiyoac sifu mong mi wabade. ");
INSERT INTO ded_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Ngicngac goa yeni negen negensingngina kpac kecandae, yeni geac dedeseriyoac mi modacandaeac ni yenemma modzona tide. ");
INSERT INTO ded_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Kebu, ni geac dederecgeyoacac songotoa negenduaeac geng imoc negensikecna. Geng yoac dedzege amma imoc modackecnec, imocac kekecna onggonggena. ");
INSERT INTO ded_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Yoacga sasawa imoc fora nga geac dederecgeyoac dindingac imoc sasawa tembuc tembuc nasoya nasoya feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Ngictauac medacfora yeneng hania kpacfu nukporac anengandae, fora. Nga herenango sifu geac yoac bibiagoc, imoc hengkefude. ");
INSERT INTO ded_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Ngic mongngo finac hania hania buma kuneng bummema sogaiande, ni ifi isoc geac yoacac sogaibade. ");
INSERT INTO ded_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Ni ikocfakaac negemba wiac mangana yombong anu imocac modzona tide. Nga geac dedeseriyoac, imocac songo negemma kecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Ni geac dederecgeyoac dindingacac amma uamemesoc naso seweng dengeregukecbade. ");
INSERT INTO ded_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Ngicngac yeneng geac dedeseriyoacac songo negengandae, yeni ruae kekec kuneng meficgekecma wiac monnu tifotockema naric mi mayunuude. ");
INSERT INTO ded_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","O KEBU, ni geac memengerecac negensikecba imoc fingerudeac tomai kecma nonoyoacgaac uaya mekecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Ubaonganango geac dedekperagiyoac modacma imocac songo kuneng negengkecduae. ");
INSERT INTO ded_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Wiac sasawa angkecduae, imoc negennecac dederecgeyoacga nga dedekperagiyoacga modacbade. ");
INSERT INTO ded_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","O KEBU, kiacnango gearu hau ge negennenna. Yoacga modacma negen negentegecgoc ambadeac anenna. ");
INSERT INTO ded_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Ni kpesi kpesi gearu haba geng negemma yoac deserima denec, imoc modacma ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Geng singyoacgaac negen negeng kpounengannecac enacbibicnango geac dedengerec yoac homac dekecbeso. ");
INSERT INTO ded_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Geac nonoyoac imoc fora nga dindingac sasawa, imocac nedzarannango geac yoacac yegec gombunga heibeso. ");
INSERT INTO ded_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Ni geac dederecgeyoac segerema meaiac marigango meficnunadeac efaima kecbesena. ");
INSERT INTO ded_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","O KEBU, geng ebicfunac mesinunadeac anende nga ni dedeseriyoacgaac songo negenduae. ");
INSERT INTO ded_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Ge onggonnuna kekecnagoc ambadeac anenna dengereguma kecbade. Geac dederecgeyoacngo meficnubeso. ");
INSERT INTO ded_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Rama sufu sufuyango sing segema kengande, ni ifi isoc sing segema kenai. Ni, kingang ngicgango geac nonoyoac mi nigecnuudeac hama meficnuna. ");
INSERT INTO ded_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Hombannu kekenggac yegec. Ni ebicgoc kecma KEBU kpacba yeng kiacna negemma turunga merennembeso. ");
INSERT INTO ded_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","O KEBU, ngic goa enacbibicngina ikohagoc nga nedzarangnginaunac ngic ogofocngina tobangyunugecdeac yoac maande, ge yenearunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Nedzarang ge ngicngac tobangyununadeac yoacgoc kecnec, ge yoacna negenna. Ge noc wiac anggembesonga? Amma geac turunga noc wiac gembesonga? ");
INSERT INTO ded_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Wasaingic yeneac tebemedaha nga icngina gerecyohohagoc, imoc genggecde. ");
INSERT INTO ded_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Ni nocac Meseke bangecfu kuric kecduae nga Kedare yeneac kporucbedzoac botucfu kecduae. ");
INSERT INTO ded_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Ngicngac ruaeac modzongina tiande, ngic ifia yenigoc naso hereangoc kefaiac modzona tide. ");
INSERT INTO ded_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Ni ruaengic nga ruaeyoac deba yeneng ine dzikacac ngic andae. ");
INSERT INTO ded_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Hombannu kekenggac yegec. Ni kicna tikiu fiba ende. Ni memeficac obohoduae, imocngo dahacnac haude, ifi kpesiduae. ");
INSERT INTO ded_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","KEBUNGO kurumeng nga bangec meficgeec nga memeficna yearunac haude. ");
INSERT INTO ded_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Kebu genggareng anggengkecde, yeng gau mi feude, kpac. Ye haniga garenggeu seria nanu wiac mongngo meu goroc goroc naric mi anude. ");
INSERT INTO ded_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Negenggec, Kebu Israe habu onggongyunuande, ye gaunec mong mi feande nga gau ebira mong mi feude. ");
INSERT INTO ded_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","KEBUNGO onggongguma marifoigau nanu ge yeac debannu kecna ");
INSERT INTO ded_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","wenacfu wenacngo mi guude nga tofocnac afongo mi memanganeguude. ");
INSERT INTO ded_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","KEBUNGO onggongguu yarefaka hania hania fede, imocngo naric mi memaguude. Kebu ye kekecga onggonggeude. ");
INSERT INTO ded_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Ge amaunac manade me amau ennade dena KEBUNGO yofinenggac nga nasoya nasoya onggonggukefude. ");
INSERT INTO ded_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Hombannu kekenggac yegec. Dawidingo yegec yofi heiec. “Nenang KEBUAC amau enni.” Yeneng ifi edenugec ubangerec negenai. ");
INSERT INTO ded_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","O Yerusareng, neni hanininango geac naguusing ekemma odaga manau tinandimbe. ");
INSERT INTO ded_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Yerusareng imoc taongtoa isoc megec nande. Imoc meserima mocgutoa megec ama nga ama wegenacfu ifi tackendae. ");
INSERT INTO ded_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Nga ngicngac neni arenninasoc modacma imohai engandimbe. Imoc Israe areng neneac dema yoac deserigec fede. KEBUAC ngicngac areng neneng ihai emma KEBUAC kpac kuneng heiwayong meminide. ");
INSERT INTO ded_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Ihainoc fora dedeac ngictau tatac faigec homac tacdae, imoc Dawidiac esangabo yeneac ngictau tatac sasawa. ");
INSERT INTO ded_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Ngeni ruae Yerusarennu feudeac numubisia. “Geac songo negengandae, yeni naric kecma wiac monggac mi obohobisia. ");
INSERT INTO ded_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Geac odaga manau ruae febeso. Nga amaherec amaga onggonggekecdae, imocac manau mangang kpangang mong mi febeso.” ");
INSERT INTO ded_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Sactosofocna nga ogofocna yeneng naric kecgecdeac amma yofi debade, “Geac ama manau ruaengo kecbeso.” ");
INSERT INTO ded_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","KEBU Anutuninaac ama, imocac gombunggac amma ngeneng naric kecgecdeac nunumu uatoa mekecbade. ");
INSERT INTO ded_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Hombannu kekenggac yegec. KEBU ge kurumenga kurumenga imohai ngictau tatacgau tacna ni kicna gearu fiba erede. ");
INSERT INTO ded_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Kingang ngic yeneng ngic kunengnginaac negeung kecandae nga kingang naroang yeni ngac kunengnginaac negeung kecma kic fiandae. Negenna, nenang ifi isocngoc kicnina KEBU Anutunina, yearu fikecmina yeng nenanggac ubea manganebeso. ");
INSERT INTO ded_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","O KEBU, ge ubamangang anemmena. Ngicngac yeneng homac deendema anemmegec imocac witiau kecdimbeac ubamangang anemmena. ");
INSERT INTO ded_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Ngicngac goa yeneng ebiha kpac kecma desofoc anemmegec naso herea monggoc bic ande. Nga ngic goa yenanggac negenggec engena yombong angkecde, yeni ngadenunuma desusuic anemmekecgec ubaonganinango ebic imoc mekecma gebeckpede. ");
INSERT INTO ded_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Hombannu kekenggac yegec. Dawidingo yegec yofi heiec. Israe ngeni yofi debisia, “KEBUNGO nenanggoc mi kecbacfu neni dafi ambesonga obohobing.” ");
INSERT INTO ded_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Ngic yeneng yacma nunubeso anggec, imohai KEBUNGO nenanggoc mi kecbacfu ");
INSERT INTO ded_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","yeneng nenanggac herebu kuneng negemma gboringoc gbokonunubau. ");
INSERT INTO ded_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Tunggbaungngo meicnunubac me doku dundungngo nebucnunubau. ");
INSERT INTO ded_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Amma dokutoa kucnginagoc yeneng semenunudacbau. ");
INSERT INTO ded_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","KEBU keneheni. Ye onggonnunuu yeneac enacfu mi ening. ");
INSERT INTO ded_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Uficngic yeneng ufic faigec nga nengngo uficfunac woraande, ifi isoc woraing. Ufic imoc barackeu uficfunac woraing. ");
INSERT INTO ded_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","KEBUNGO kurumeng nga bangec meficgeec. Nga memeficnina imoc yeac kpacfu fede. ");
INSERT INTO ded_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Hombannu kekenggac yegec. Ngicngac KEBU negenserima kecdimbe, nenang Siong tiki isoc. Wiac mongngo meu goroc goroc mi amma nasoya nasoya nangkefude. ");
INSERT INTO ded_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Tikingo Yerusareng yerecgema tackendae, ifi isocngoc KEBUNGO ngicngacfora yerecyunuma yofinenggac nga nasoya nasoya ifi kefude. ");
INSERT INTO ded_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Ngicngac dindingac yeni maringina sinema angammeme mangana ambauac. Ngic Anutu ngadehema mangana megecdeac ayemmeande, Anutungo yeni kpae heiyemmeu ngictau yasunginango ngic dindingac yeneac bangec naric mi garenggeude. ");
INSERT INTO ded_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","O KEBU, ngicngac gombunga nga herenginau ikoc nga hamangec mong mi fede, geng yeni faka gombunga ayemmena. ");
INSERT INTO ded_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Ngicngac goa ine efaima sing mangana noboc noboc modacgec KEBUNGO yarengic meicyunuma yeni ifingoc yenigoc meicyunuu kenggec kpemeting ayemmeude. Ruaengo Israe areng yenearu febeso. ");
INSERT INTO ded_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Hombannu kekenggac yegec. KEBUNGO Siong monggoc mengereu ngicngacfora naric kecgec, naso imohai nenang negenni imoc gau negendimbe isoc anec. ");
INSERT INTO ded_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Nenang enacbibicfu dzomocngo wakeu sogac sogaiac yegecngo nedzaranninau feu bangec monnunac ngicngac botucnginau degec, “KEBUNGO yeni wiac kuneng yombong ayemmeec.” ");
INSERT INTO ded_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","KEBUNGO wiac kuneng yombong anemmeecac nenang sogac sogaingo mewakenunuude. ");
INSERT INTO ded_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","O KEBU, ge Negewe bangec kisiu dokukperemeng gbangge gbanggea, yeni mengereyununa doku monggoc haande, ge ifi isoc monggoc mengerenununa naric kecni. ");
INSERT INTO ded_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Ngicngac kickumagoc wiac homecandae, ngeni sogac sogaigoc arohoma fora megecde. ");
INSERT INTO ded_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Ngicngac ngeni kiac ubamanganggoc kemma wit komoha tofohoma ngade wit gbomea bodangagoc tofohoma amanginau dzigene hama sogaima arohogecde. ");
INSERT INTO ded_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Hombannu kekenggac yegec, Soromongngo yegec yofi heiec. KEBUNGO ama mi meudeu ngic yeneng uatoa mema ama mekecdae, imocngo memefihagoc mong mi anude, kpac. KEBUNGO amabangec mi garenggeudeu ama gareng yeni gaugbori anggec uangina sifu memefihagoc mi anude. ");
INSERT INTO ded_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Ngeni neneyaka meficgegecdeac asoac bic yacma uatoa mema kecma fefe nasongina ferahakecma uamemeac negengyohocgoc kecma yakangina nekecgecde, imoc ifingoc memefihagoc mi anude. KEBUNGO ngicngac songogoc hoangyunude, yeni gau femagec yaka meficgeyemmeude. ");
INSERT INTO ded_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Negenggec, nambarac sasawa yeni KEBUARUNAC maridzoming nga ngac hereaunac fora fingecande, imoc uanginaac bung. ");
INSERT INTO ded_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Wasaingicac mariu tebemedaha homac femide, ngic sebigboringo medacfocngina meficyunuu kecdae, yeni medacfocnginagoc kecma wasaingic imoc isoc andae. ");
INSERT INTO ded_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Ngic mong ye medacfora ifia homac kpedzucyunuma meyunukecde, ye kenehagoc. Ngabafora taong naguu yoacfu nangandae, yeng imohai yenigoc nanu yeneng game kpekpeu naric mi faigecde. ");
INSERT INTO ded_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Hombannu kekenggac yegec. Ngicngac KEBUAC eweheiheigoc kecma yeac sing modacandae, yeni sasawango kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Ge ua marigango mena fora fingeru menec amma sogac sogaigoc kecma naric kecnade. ");
INSERT INTO ded_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Enenggango amaga manau kecde, ye waing ic fora homac amma nangande, ifi isoc anude. Nga nambaracfocga yeneng oriwa benama, ifi isoc tatacga yerecgema tackenggecde. ");
INSERT INTO ded_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Negenggec, ngic mong KEBU eweheimima kefude, yearu kenec ifinoc feude. ");
INSERT INTO ded_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","KEBUNGO Sionnu kecma kenecguu. Yerusareng ye naric kecma wiac monggac mi obohoude, imoc hembesena. ");
INSERT INTO ded_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Ge esafocga fingecgec yenennade. Ruaengo Israe areng yenearu febeso. ");
INSERT INTO ded_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Hombannu kekenggac yegec. Israengo yofi debeso, “Ni sebigborinaungoc kecbareng ngic yeneng ebic kunennu fainugec.” ");
INSERT INTO ded_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“Ni sebigborinaungoc kecbareng ngic yeneng ebic kunennu fainukecma firang mong mi anggec. ");
INSERT INTO ded_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Bangec mendzic mendzic yeneng bangec mendzicgec areng fingecande, yeni ifi isoc ngadenau kpendzicgec areng herea fingecgec.” ");
INSERT INTO ded_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","KEBU ye dindingac. Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeng yeneac witic herecgema yungecnunuec. ");
INSERT INTO ded_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Ngicngac Siong ubanginango ukuandae, yeni merengyunugec yeni game kpekpeu faiyunugec monggoc dzigenema kembisia. ");
INSERT INTO ded_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Yeni ama witiau kpindzingngo erema bic homeande, ifi isoc ambisia. ");
INSERT INTO ded_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Mekpedzuc ngicngo imoc meudeac maria mi sineude nga semeng dedeckeande, imoc mi abaranggema mekenude. ");
INSERT INTO ded_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Ngicngac goa yeni kengha angandae, yeneng yofi naric mi degecde, “KEBUNGO kenecngunuu. Neni KEBUAC kpacfu kenecngunudimbe.” ");
INSERT INTO ded_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Hombannu kekenggac yegec. O KEBU, ni ubaebicnagoc emu keme kemeau isoc kecma kpacguduae. ");
INSERT INTO ded_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Kebu, ge enacudumenna negemma kedzac kpena. Kpesi kpesina gearu hade. ");
INSERT INTO ded_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","O KEBU, ge kopocsicnina kicgau arenggema negenna febacfu ngic mongngo serima naric mi kecbac. ");
INSERT INTO ded_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Nga gearu sifu kopocsic wawa fedeac eweheiheigoc hoanggubesonga. ");
INSERT INTO ded_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Ni KEBUAC tomai kecduae. Ubaonganango tomai kefu ni yeac yoac negensikecma fora fingerudeac tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Tofocnacgareng yeneng asoac haudeac tomai kecandae, ni yeni feracyunuma ubaonganango KEBUAC tomai kecduae. Ni yeac tomai kecduae amma monggoc ferahama tomai kecduae. ");
INSERT INTO ded_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","KEBUNGO yoac dedzege amma imoc modarude. O Israe, ge KEBU negensima fora fingerudeac tomai kecna. Yeng bummenunudacma ebicfunac mesinunuudeac kuc engena femide. ");
INSERT INTO ded_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Israe areng yeni ngicngac ogofocngina memanganeyunuma kopocsicnginagoc anggec. Nga yennoc bummeyunuma manganameme fakanginaunac mesiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Hombannu kekenggac yegec. Dawidingo yegec yofi heiec. O KEBU, herenau sebiengeng mi anganduae nga ubakpekpe arennu kicna wi mi meemma fibade. Wiac kuneng me bibiagoc amma ni feracnuma neacsoc mi ande. Ni imocac negen negeng ua mi mebade. ");
INSERT INTO ded_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Ubaongana menomaneba waicke fede. Sabac mongngo nonggeaac namu nema waicke feande, ubaonganango ifi isoc waickema fekecde. ");
INSERT INTO ded_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","O Israe, ge yofinenggac amma nasoya nasoya Kebu negensina fora fingerudeac tomai kecbesena. ");
INSERT INTO ded_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Hombannu kekenggac yegec. O KEBU, Dawidingo ebicfu engkefec, imoc negenna feu yeac negenna ngereebeso. ");
INSERT INTO ded_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","KEBU, Yakoboac Anutu Kuctoa mingina, ge yomoc negensibesena, yeng geac yoac deserima yofi deec, ");
INSERT INTO ded_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Ni amana manau mi embade me fefenau naric mi febade, ");
INSERT INTO ded_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","ni kicna gauac kpetarimima gau naric mi febade ");
INSERT INTO ded_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","kecma KEBU geac amatatac nga Kuctoa mingina Yakobogoc kecande, geac amagerec meficgebade.” ");
INSERT INTO ded_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Negenggec, neni Efrata bangecfu Anutuac dzadzahac katapaac siduc negemma Yara manennu imoc meficgeing. ");
INSERT INTO ded_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","“Hagec KEBUAC amau kenni, nenang yeac hanitatahau fafoc heimima numumini. ");
INSERT INTO ded_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","O KEBU, ge yacma kucgaac katapagoc tacnegeng amagau hana. ");
INSERT INTO ded_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Womong garenga, ngeni dindingac kekec heigec kemebeso nga ngicngacfora kpetiac kecandae, ngeneng desogai amma arohobisia.” ");
INSERT INTO ded_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Ge kingang ngicga Dawidiac gombunggac amma ngicga kerecngo nadzicminec, ye mi ngadehebesena. ");
INSERT INTO ded_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","KEBUNGO yoac deserima Dawidi yoac edeec, imoc naric mi meickeude. Ye yofi deec, “Ni geac bangecyombongga yeneac arennunac medacga mong meisinggema ye ngictautatacgau faiba tacbeso. ");
INSERT INTO ded_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Neac dzadzahac nga dedekperagiyoacna kpouyemmeba geac medacfocga yeneng imoc modacgecdeu yeneac medacfocngina ifingoc geac ngictau tatacfu nasoya nasoya takecgecde.” ");
INSERT INTO ded_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","KEBUNGO Siong meisinggema ihai kefudeac ammide. ");
INSERT INTO ded_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Ye yofi deec, “Ni ama yomocac negensongo negengkecba imocngo nasoya nasoya neac tacnegeng ama seria anu imohai tacyac ambade. ");
INSERT INTO ded_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Nga imohai wiac sasawa fede, imoc homac yombong kenehebade. Yeac ngicngac makpekpea semeng gumecyunuba negebec anggecde. ");
INSERT INTO ded_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Ni womong garengfora ebicfunac yungecyunubade, faka imoc ngakpi isoc heiyemmeba kemeu kecgec ngicngacfora kpetiac kecandae, yeni sogac sogaiac yegec heigecde. ");
INSERT INTO ded_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Ni imohai Dawidiac arennununac ngic mong faima yeac kuc heigboriba besaiude. Ni ngicna kerecdokungo nadzicmiba kefu yeac kifa mong mengeremiai. ");
INSERT INTO ded_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Nga yeac ngabafora yeni ine game heiyemmeba kemeude. Ni ngictauac ira pirac pirac heimiba kemeu imocngo ye mekperagiude.” ");
INSERT INTO ded_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Hombannu kekenggac yegec. Dawidingo yegec yofi heiec. Negenggec, ngicngac daramuna ngeneng negen negengngina kpeturanggema ruaegoc kecandae, imocngo wiac songea yombong. ");
INSERT INTO ded_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Faka imocngo kerec homuna gombunga nga buma kuneng, imoc orucfu kpakegec mama ngebacdzo momoc nadzicmiande, ifi isoc. Imoc Aronggac ngebacdzou mama ferecgema ngakpia ubiau ifingoc nadzicmiude. ");
INSERT INTO ded_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Imoc Herimong tikiac songoroc, ifi isoc. KEBUNGO Siong tikiu keneha nga kekeha wisic wisickea kpac kpakenemmeude, imocngo imohai mama kecde. ");
INSERT INTO ded_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Hombannu kekenggac yegec. KEBUAC kingang ngic KEBUAC amau tofocnac nangandae, ngeni sasawango hadacma KEBU kenehebisia. ");
INSERT INTO ded_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Ngeni maringina miacma amabangec kpetiac, imohaigeng maringina sinema KEBU kenehebisia. ");
INSERT INTO ded_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","KEBUNGO kurumeng nga bangec meficgeec, yeng Sionnu kecma kenecgubeso. ");
INSERT INTO ded_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","KEBU yaiyo kpemini, hallelu Yac. KEBUAC kpac kuneng heiwayong memibesonga. O KEBUAC kingang ngic sasawa, ngeni ye dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","KEBUAC amau nga Anutuninaac womong sobengau nangandae, ");
INSERT INTO ded_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","ngeni KEBU ohec waec memibisia nocac KEBU ye gombunga. Ye wosoefac anemmeandeac yeac kpac kuneng heiwayong memima yegec heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","KEBUNGO Yakobo yengena areng segerema Israe yengena areng yombong anggecdeac meisingyunuec. ");
INSERT INTO ded_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","KEBU ye kuneng, imoc negenduae. Nenang Kebu yeng anutu hania hania sasawa feracyunudacde. ");
INSERT INTO ded_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","KEBUNGO wiac mong meudeac songo meficgema imoc naric kurumennu me bangecfu me kondunnu me keme kemea hania hania fekendae, imohai uaya meude. ");
INSERT INTO ded_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Yennoc bangec tegiau hoeng uayoac yemmeu yacgecde. Nga yeng kia nga piratac meficyuruu heiandape nga firang tohongameaunac memau ngadeau mama fingecande. ");
INSERT INTO ded_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Yennoc Aigita ngic yeneac warac medacfocngina nga rama burumakanginaac warac areng kpebucyunudarec. ");
INSERT INTO ded_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","O Aigita bangec, ye gearu hama geac botucfu negensinggegecdeac faka kuhagoc amma kucfaka bibiagoc sueyunuu fingecma Farao nga habufora memanganeyunuec. ");
INSERT INTO ded_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Ye firang amma bangec monnunac ngicngac homac yunuma ngictau kucnginagoc kpebucyunudarec. ");
INSERT INTO ded_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Ye Amori yeneac ngictau Sihong kpema Basang bangecac ngictau Ogie kpema Kanaanggac ngictau sasawa yunuma ");
INSERT INTO ded_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","bangec maridzoming dema ngicngacfora Israe yemmeec. Ye maridzominga imoc yemmeec. ");
INSERT INTO ded_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","O KEBU, geac kpac kuneng imoc nasoya nasoya feengkefu ngicngac esamedacfocngina fingecsahe anggecde, yeneng geac kpac kuneng negenggec feude. ");
INSERT INTO ded_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","KEBUNGO yoacfu ngicngacfora nanggeyunuu yeni yoacfu firang ambisia. Ye kingang ngicfora yeneac ubea manganeude. ");
INSERT INTO ded_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Bangec monnunac ngicngac yeni nemuongangina siriwa nga gol tegengngo memea. Yeni bangecngic yeneac marikibisac andae. ");
INSERT INTO ded_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Yeni enacbibicnginagoc nga yoac ine naric mi degecde. Yeni kicnginagoc nga kicnginango ine wiac naric mi henggecde. ");
INSERT INTO ded_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Yeni kedzacnginagoc nga kedzacnginango ine wiac mong mi negemma enacnginausing asu mong mi heigecde. ");
INSERT INTO ded_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Ngic nemuonga meandae, yeneng nemuonga isoc anggecde. Ngicngac yeni nemuonga negenseriandae, ngicngac ifia yeni sasawango nemu ongangina isoc andacgecde. ");
INSERT INTO ded_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","O Israeac areng, ngeni KEBU kenehebisia. O Aronggac areng ngeni KEBU kenehebisia. ");
INSERT INTO ded_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","O Rewiac areng, ngeni KEBU kenehebisia. Ngicngac ngeneng KEBU eweheiheigoc hoanggema kecandae, ngeni KEBU kenehebisia ");
INSERT INTO ded_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Ngicngac Sionnu kecdae, ngeni KEBU Yerusarennu kecande, ye kenehebisia. KEBU eriendzong memibesonga, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","KEBU ye gombunga, imocac ubangerec memibesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Anutu hania hania yeneac Anutu ubangerec memibesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Kebu yeneac Kebu ubangerec memibesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Kebu kucfaka bibiagoc mekecde, ye ubangerecyoac memibesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Kebu wiac sasawa negentegecma kurumenga kurumenga meficyunuec, yeac marikibi gombunga yombong ande nga ye ubangerec memibesonga. Yeng yoac dedzege amma imoc modackecde, faka imoc fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Kebu doku witiau bangec faiec, ye ubangerec memibesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Anutu kperagia kuneng faiyuruec, ye ubangerec memibesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Ye wenacngo hadzing garenggeudeac faiec. Yeng yoac dedzege amma imoc modackecde faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Ye afo nga asomeng yeneng tofocnac garenggegecdeac faiyunuec. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Kebu Aigita bangecfu waracmedacfocngina kpebucyunuec, ye ubangerec edebesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Ye Israe areng yeneac botucfunac hesicyunuu kenggec, ye ubangerec edebesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Ye mariseria nga kuctoayagoc amma maria sinema ua imoc meec. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Kebu kondung sacsac kpendziru yohockang anec, ye ubangerec edebesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Ye Israe areng sing faiyemmeu yeneng imocac dzongiau ferecgegec. Ye ubangerec edebesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Yeng firang amma Farao nga wasai arengfora heimerengyunuu kondung sacsacngo semeyunuec. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Ye ngicngacfora meyunuma bangec gbangge gbanggea feec, imohai wangecyunuma kenec, ye ubangerec edebesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Kebu firang amma ngictau kucnginagoc yunuec, ye ubangerec edebesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Ye firang amma ngictau kpac kunengnginagoc yunuec. Yeng yoac dedzege amma imoc modackecde faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Ye firang amma Amori ngic yeneac ngictau Sihong kpeec. Yeng yoac dedzege amma imoc modackecde faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Ye firang amma Basang yeneac ngictau Oge kpeec. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Ye yeneac bangecngina maridzoming dema ngicngac areng mong yemmeec. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Ye maridzoming dema bangec imoc kingang ngiha Israe miec. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Neni sure surea kecmina yennoc neneac negenu feec. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Ye ngabafocnina yeneac mariunac mesinunuec. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Yennoc wiac sasawa meficyunuma kekecnginagoc anggec semeng yemmeude. Yeng yoac dedzege amma imoc modarude, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","O, kurumenggac Anutu ubangerec memibesonga. Yeng yoac dedzege amma imoc modackecde, faka imocngo fefeseri feengkefude. ");
INSERT INTO ded_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Neni Babirong bangecac doku tegiau tacma Siong negensima kiacma ");
INSERT INTO ded_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","gitanina ic fawau gbedickeing. ");
INSERT INTO ded_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Ngic yeneng menunuma kemma ebic meficgenemmegec, yeneng ubangerec meficgegecdeac degec, “Ngeni Sionggac yegec heigec negenni.” ");
INSERT INTO ded_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Neni ine kuric bangecfu kecma KEBUAC yegec heinideac obohodimbe. ");
INSERT INTO ded_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Yerusareng, ni geac nigecnuudeu marifoinango dzanggema kuha kpac ambeso. ");
INSERT INTO ded_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Yerusareng imoc neac sogac sogaiac enaratoa, ni ifi mi negemma geac nigecnuudeu nedzarannango ngorucbonnau mendanggebeso. ");
INSERT INTO ded_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","O KEBU, ngic yeneng Yerusareng kpetotiegec, naso imohai Edonggac ngic yeneng degec, “Kpembarackegec, kpembarackegec mama seringau wisickeu.” Kebu ge imoc negenna febeso. ");
INSERT INTO ded_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","O Babironggac naroang, ge kpetotiegugecdeac areng, imoc bic degenggec. Ge mangana anennecac ngic mong ye imocac turunga merenude, ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Mong ye geac sabac mema hoc peperandziu yunuma kpebucyunuude, ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Dawidingo mitiyegec yofi heiec. O KEBU, ni heregoc ubangerec megemma anutu hania hania kecdae, yeneac kicfu geac dedengerec yegec heigembade. ");
INSERT INTO ded_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Ni womongga kpetiacfubigeng ngonducnebade. Geng yoac dedzege amma imoc modacnade amma ge yoac modac modac Kebu, imocac kpac kunenggaac ubangerec dekecbade. Ge kpac kunenggagoc nga geng yoacga deserima denec, ge wiac imoc miacna enu imocngo wiac sasawa feraheude. ");
INSERT INTO ded_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Ni kpacguai naso imohai geng turunga merennenna kengeha kpac amma serima kecbadeac anennec. ");
INSERT INTO ded_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","O KEBU, bangecac ngictau sasawa yeneng geac enacgaunac yoac negenggecac dengeregubisia. ");
INSERT INTO ded_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","KEBUAC kuc nga kibikperagitoa, imoc wiac engena. Yeni imocac KEBUAC sing fekende, imocac yegec heigecde. ");
INSERT INTO ded_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","KEBUNGO wi yombong kecde, fora, amma ye sifu ngictehec nenang nenenggareng anemmekefude. Ngicngac goa yenanggac nengenggec engena angande, yeng herenginau kecma fakangina negenude. ");
INSERT INTO ded_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Ni ebic witiau kecduae, fora. Nga geng sifu kekecna onggonggekecnec. Ngabafocna yeneng herebu anenggec geng mariga sinema marifoigango ebicfunac mesinunade. ");
INSERT INTO ded_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","KEBUNGO efaima neac kekecareng uayagoc faima imoc sasawa nearu mesidarude. O KEBU, geng yoac dedzege amma imoc modackecnade, fakaga imocngo nasoya nasoya feengkefude. Ge marikibiga mi ngadehema wana. ");
INSERT INTO ded_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Yegecgareng yearu. Dawidingo mitiyegec yofi heiec. O KEBU, ge neac herena hennegeng amma negennunec. ");
INSERT INTO ded_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ni takecduae nga yacma nangkecduae, geng imoc sasawa negendacma hereaungoc tacma negen negenna hentegecdacnec. ");
INSERT INTO ded_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ni kengha anduae nga fefenau feduae, imoc hennegeng amma sing sasawa kenganduae, imoc negendacnec. ");
INSERT INTO ded_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","O KEBU, ni yoac debesonga enac mi anggebareng geng yoac imoc bic negendacnec. ");
INSERT INTO ded_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ge kicnau nga ngadenau oronnukecma marigau fainuma menunade. ");
INSERT INTO ded_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Negen negeng ifia imoc keme kemea nga engenatoa amma kuneng andeac imocac ubangerec negenduae, fora. Nga imoc sifu naric mi negentegecbade. ");
INSERT INTO ded_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Ni ihai me ihai kembadesoc geac Asuarunac agac naric mi kecbade. Nga geac kicfu kekec, imoc wama sufubadeacsoc mi anduae. ");
INSERT INTO ded_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Ni kurumennu embadeu ge ihainoc kecnec. Nga homec amau kemema fefena faima fema naric mi sufubai nocac ge ihai ifingoc kecnec. ");
INSERT INTO ded_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Ni asoac ama negenggac kpegang kpema kpututuckebade me kondung tegiau edi noboc kemma ihai tacbaiu ");
INSERT INTO ded_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","ge marigango ihai ifingoc hesicnuma marifoigango seria menunade. ");
INSERT INTO ded_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Ni yofi gedang debai, “Kundungngo semenuu kperagia nearu fede imoc kundung kpebeso.” ");
INSERT INTO ded_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","ifi deba kundung imoc ine geac kicfu kundung mi anude, kpac. Nga tofocnac imoc wenac isoc kperagiude. Nocac kundung imoc geac kicfu kperagi angkecde. ");
INSERT INTO ded_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Geng ubaherena sasawa meficgema nonggo heremanau kecbare geanggaoc sebifusina nga ubaherena kpedzucnema meficnunec. ");
INSERT INTO ded_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Ge meficnuma menunec imoc faka bibiagoc nga damuyagoc annecac dengeregubade. Geng uaga mekecnec, imoc wiac bibiagoc yombong, imoc negengyombonggeduae. ");
INSERT INTO ded_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Geng sufu sufuu menunec, imohai ni forakebannagoc kicgango bic nennec. Sebina imoc emu bangec keme kemeau feu geng kpedzucnunec. ");
INSERT INTO ded_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Sebinango mi torokpemanungoc kicgango sebinaac hanac hanahea hennec nga uamemena mong mi hamanungoc imoc sasawa tembuc tembuc geac kibiu oho ohoya fede. ");
INSERT INTO ded_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","O Anutu, geng wiac negensiannec, imocac negemba wiac engenatoa ande. Imocac ni imoc kpeturanggeba kpetea engena yombong fingerude. ");
INSERT INTO ded_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Imoc homac yombong sangi ferahadeac imoc osobesonga osiduae. Nga gborima yacbade, imoc gegocngoc kecbade. ");
INSERT INTO ded_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","O Anutu, ngic Anutu ngadehema mangana megecdeac ayemmeande nga ngic sacnina hetinggegecdeac ayemmeande, yeni kpebucyununa wanubisia, imocac yombong anende. ");
INSERT INTO ded_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Yeni mangana negemma geac yoac deandae nga ikoc fingerudeac ngabafocga nanggeyunugecde. ");
INSERT INTO ded_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","O KEBU, ngic geac modzongina tiande, ni yeneac modzona homac tide. Ngicngac yeneng geac yoac kpeandae, yeni manganaac areng, ifi negemma wayunudacbade. ");
INSERT INTO ded_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Foracngoc, ni yeneac modzona tiu ngicngac imoc yeni ngabafocna, ifi negemma ubango ukuyunubade. ");
INSERT INTO ded_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","O KEBU, ge herena isinggema herenaac hania hennegeng amma faitobang anemma negen negenna henna. ");
INSERT INTO ded_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Ni manganaac sinnu kengkecduae me kpac, imoc hennegeng amma sing feengkefude, imohai hesicnuna. ");
INSERT INTO ded_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Yegecgareng yearu. Dawidingo mitiyegec yofi heiec. O KEBU, ge yarengic yenearunac yungecnuma ngic mangana herebunginagoc yenearunac onggonnuna. ");
INSERT INTO ded_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Yeni herenginau yarefaka hania hania arenggema nasosoc dzikac kpegecdeac sing meficgekecdae. ");
INSERT INTO ded_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Yeni nedzarangngina dzomugec boidzocac nedzarang enaragoc, ifi isoc anude. Yeni ngedzarangnginango ikoc ayemmeandae amma bibicnginau boidzocac marasing mekecdae. Selac ");
INSERT INTO ded_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","O KEBU, ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneac mariunac onggonnuna. Yarengic yeneng hanina kpesigecdeac negensima areng faigec ge onggonnuna. ");
INSERT INTO ded_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Ubakpekpe ngic yeneng botac mong mesufuma faima menubeso angkecdae. Yeni witic mema ufic faima suba sing tegiau faima menubeso angkecdae. Selac ");
INSERT INTO ded_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","KEBU yoac yofi ededuae, “Ge neac Anutu.” O KEBU, ge neac ubaga manganeudeac kpacguba ge kedzac kpema negembesena. ");
INSERT INTO ded_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","O KEBU Kuctoa mingina, ge neac yungec yungecna seria. Geng dzikac nasou orucna garenggema onggonnunec. ");
INSERT INTO ded_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","O KEBU, ngic Anutu ngadehema mangana mebeso ayemmeande, yeni yenanggac negenggec wiac engena ambaac songongina modacma wiac mong mi meficgeyemmebesena. Yeni yarefaka arenggekecdae, imoc fora mi fingecbeso. Selac ");
INSERT INTO ded_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Ngic ni oronnudae, yeni enacbibicnginango yoac dema ngicngac ebicfu faiyunuandae. Ebic imocngo geng negemmana orucngina semeu ");
INSERT INTO ded_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","gerec seriango kia isoc witinginau mabeso. Yeni emu tengtoau ukuyunugec kemema monggoc mi erebisia. ");
INSERT INTO ded_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Ngic ngadeyoac deande, ye bangecfu titiseria faibacac geng imoc kpetarimina. Faka mangana yengenaoc yarengic bic yombong kisamma firang amma ye meickebeso. ");
INSERT INTO ded_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Ngicngac ebic witiau kecgec KEBUNGO yeneac yoac henggareng amma nanggeyunuude. Ngicngac iwaiac obohoma kecandae, yeni sing dindingac modacgec yeng isingyunuma yoacngina desiude, imoc negenduae. ");
INSERT INTO ded_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Foracngoc, ngic dindingac yeneng geac kpac kuneng heiwayong memima ubangerec degecde. Nga ngicngac ikoc nga hamangecngina kpac kecdae, yeneng geac kicfu kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Dawidingo mitiyegec yofi heiec. O KEBU, ni kpacguduae. Ge nearu bic hana. Ni kpacguba ge kedzac nearu faima ubaudumenna negenna. ");
INSERT INTO ded_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Nunumunango geac kicfu hama hosuc homuna gombunga, ifi isoc ambeso nga marina gearu miacba imocngo maraiac sese gombunga, ifi isoc ambeso. ");
INSERT INTO ded_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","O KEBU, ge enacnau kpae mong mengerema bibicnaac naguya garenggekecbesena. ");
INSERT INTO ded_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Herenango mangana hoanggebacac nga ngic ngicngac ogofocngina memanganeyunuandae, yenigoc kecma haifaka mangana angkecbaiac ge imocac kpae heinembesena. Ni yenigoc tama wiac emenec mi ambesare. ");
INSERT INTO ded_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Ngic gombungango yoac yumiau edenuma demengere naric anembeso. Imocngo kerec orucnau nadzicnenggec sebinango ireckeande, ifi isoc andeac orucnango imoc naric mi waude. Ni manganameme yeneac negemma numuanduae, imocac turungaac nasoya hau fora fingecdarude. ");
INSERT INTO ded_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Imohai ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni wi nanggec enarafocngina ukuyunugec hofeu kemegecde. Nga yeni imohai yofi negenggecde, KEBUAC yoac imoc fora. ");
INSERT INTO ded_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Ngicngo bangec mendzicgec hocngo erema fingecande, yarengic yeneac sicngo ifi isoc homec amaac naguu singsararang kpema feemeude. ");
INSERT INTO ded_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","O KEBU, Israeac Anutu, ni sifu kicna gearu fima geac hoannu hama sufubeso anduaeac onggonnuma mi wanubesena. ");
INSERT INTO ded_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Ngic mangana yeneng menugecdeac botac faigec nga yarengic yeneng suba faigec ge imohacnac onggonnuna. ");
INSERT INTO ded_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Ni gombunga kembare ngic goa Anutu ngadehema mangana megecdeac ayemmeande, yeni yenang botacngo meyunubeso. ");
INSERT INTO ded_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Masiki uba modacma heibesonga. Dawidingo hoc singau tacma numuyegec yofi heiec. Ni ubana miacma KEBU kpacba yeng neac ubea manganeudeac ubana miacma numubade. ");
INSERT INTO ded_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Ni ebicyoacna hafoangoc yeac kicfu kpakema kpendzennaac yoacsiduc yeac kicfu deficgebade. ");
INSERT INTO ded_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Asuna ukuba kpeu geng haniana bic negennade. Ni sing kenganduae, imohai ngic yeneng menugecdeac botac faima sufuma takecdae. ");
INSERT INTO ded_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Ni kicna foinaugeng fima hemba mongngo ni mi nengsiude. Nga ni sufu sufuama hofocba kpac anu ngic mongngo nenggareng mi anenude. ");
INSERT INTO ded_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","O KEBU, ni kpacguma deba, “Ge sufu sufuamana nga ge gbori kekec bangecnginau neac wiac angkecnec. ");
INSERT INTO ded_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Ni memeficac obohoyombonggema kecma kiacduaeac kiacna negemma ngic nukporac anengandae, yenearunac yungecnuna. Yeni serima feracnudae. ");
INSERT INTO ded_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Ge yungecnuma ebicnaac witicamaunac wangecnubesena. Ge ifi anna ni geac kpac kuneng heiwayong memima ubangerecyoac debade. Ge gombunga anengannecac amma ngicngac dindingac yeneng hama oronnugecde.” ");
INSERT INTO ded_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Dawidingo mitiyegec yofi heiec. O KEBU, ge nunumuna negenna. Ni kpacguma desambic anggemba ge kedzac faima yoacna negenna. Ge yoac modac modac Kebu nga ge dindingac kecnecac amma turunga merennenna. ");
INSERT INTO ded_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Ngic mong kekehagoc ye geac kicfu dindingac naric mi kecde. Nga ni kingang ngicga anduaeac yoacfu mi fainubesena. ");
INSERT INTO ded_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Ngabangicnango kporacnuma kekecna bangecfu kpefahau ni kundung manau homecngic bic homegec, yeni isoc tacbadeac fainuec. ");
INSERT INTO ded_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Imocac asuna herena manau worau herenango ebic meficgema hoc isoc ande. ");
INSERT INTO ded_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Ni warac naso, imoc negemba fede nga geng ua mekecnec, imoc hennegeng amma negensikecduae. Ge marigango marikibi meficgenec, imocac ubangerec negemma hennegeng angkecduae. ");
INSERT INTO ded_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Marina gearu miacduae. Bangec dzangge dzanggeango dokuac ammiande, ubaonganango ifi isoc geac ammide. Selac ");
INSERT INTO ded_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","O KEBU, asuna woradeac turunga bic merennenna. Ni kecma ngic homema bangecfu kemeandae, ifi isoc kemebaiac ge kicmesuga nearunac mi mesufuna. ");
INSERT INTO ded_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Ni negenseriguma yofi deba, “Geng yoac dedzege amma imoc modackecnec, ge asoacngoc imocac yoac edenubesena. Ubaongana gearu miacba ereudeac sing kpounenna ni imoc modacma kengkecbade.” ");
INSERT INTO ded_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","O KEBU, ni worama geac hoannu sufubadeac hadua. Ge ngabafocna yeneac mariunac yungecnuna. ");
INSERT INTO ded_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Ge neac Anutu. Ge imocac songoga kpounenna arenggeba geac Asu gombunggango bangec sorongau hesicnubeso. ");
INSERT INTO ded_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","O KEBU, ge kpac kunengga gombunggaac amma kekecna onggonggena. Nga fakaga dindingacac amma ebicfunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Ni geac kingang ngicga kecduaeac geng yoac dedzege amma imoc modackecnec, fakaga imocngo ngabafocna nga ngic sasawa ubana kpeandae, meicyunudacna kpac ambisia. ");
INSERT INTO ded_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Dawidingo mitiyegec yofi heiec. KEBU ye neac hoc peperandzi seria, ye kenehebesonga. Yeng marina dzikacac mengerekecma dzikac kpebadeac gbonna meefaiude. ");
INSERT INTO ded_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Neac Anutungo yoac dzegema imoc modarude. Ye neac hoc peperandzi seria nga amana seria amma ye ebicfunac mesinuude. Ye kasona anenu ni yeac hoannu kemma sufubade. Ye firang amma ngiha ngiha neac bageu faiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","O KEBU, bangecngic ye gombungaya kpac kecde, fora. Nga geng ngicac medac sifu henggareng anemmema negensinade. ");
INSERT INTO ded_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Bangecfu ngic neni ine wiac engena kpac. Ngic neneng asu naso mocgu taiandimbe, ifisac. Nga kekecnina imoc wenacfu onganinango hereande, ifi isoc ande. ");
INSERT INTO ded_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","O KEBU, ge kurumenga kurumenga merarangyunuma yacma mama tiki kpesereyununa hosuc kpebisia. ");
INSERT INTO ded_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Ge piratac sueyununa ngabafocga yunugec singsararang kpema kendacbisia. Ge tebemedaha kpesaima wedecyunubesena. ");
INSERT INTO ded_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Ge wi tacma mariga sinema menuma doku tunggbaung kucnginagoc hakecdae, imohacnac mesinuna. Ge kuricngic yeneac mariunac mesinuna. ");
INSERT INTO ded_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Yeni enacbibicnginau ikocyoac wakeu deandae nga marifoinginango tobannunuma ua meandae. ");
INSERT INTO ded_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","O Anutu, ni geac yegec gboria mong heibade. Ni gita witiha teng kpema imocngo udumeng gombunga meficgegembade. ");
INSERT INTO ded_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Gennoc dzikacfu ngictau kuc yemmena firang anggecde. Dzikaac beangngo ni, kingang ngicga Dawidi kpebeso anu geng imohacnac onggonnunec. ");
INSERT INTO ded_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Ge dzikac beang mangana yombong, imohacnac onggonnuma kuricngic yeneac mariunac yungecnuna. Yeni enacbibicnginango ikocyoac deandae nga marifoinginango tobanunudeac uatoa meandae. ");
INSERT INTO ded_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Medacfocnina yeni sebigbori kecma ic barama gombunga, ifi isoc ambisia nga naroangfocnina yeneng ngictauac ama mana tuturunggac sering marikibi gombunga heiandae, ifi isoc siricnginagoc ambisia. ");
INSERT INTO ded_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Uaninaac tohonnu semeng hania haniango wakema febeso. Nga ramafocnina manennu yeneng fingecsahe kuneng ambisia, imoc taoseng nga taoseng naso teng ifi sahebisia. ");
INSERT INTO ded_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Nga burumakafocnina yeneng medac heregoc kecma ebiria yombong amma medac megecde, imohai mongngo mi manganebeso me homebeso, kpac. Taongtoaninaac sinnu ebicac nga kiacac udumeng mong mi fingecbeso. ");
INSERT INTO ded_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Ngicngac sasawa Kebuac kenecgoc ifi kecandae, yeni sogac sogainginagoc. KEBUNGO ngicngac ngeneac Anutungina ande, ngeni kenehagoc amma kecgecde. ");
INSERT INTO ded_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Dawidingo dedengerec yegec yofi heiec. Anutu nga KEBUNA, ni afeguma geac kpac kuneng nasoya nasoya kenehekecbade. ");
INSERT INTO ded_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Ni wenacsoc kenecguma geac kpac kuneng nasoya nasoya heiwayong memibade. ");
INSERT INTO ded_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","KEBU ye engenatoa amma damu damuyagoc. Ngic mongngo yeac negen negeng nga siriha naric mi arenggema negentegerude, kpac. Kebu eriendzong memibesonga. ");
INSERT INTO ded_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Ngicngac yofinenggac kecdae, yeneng angammemegaac siduc nambaracfocngina edeyunugec yeni ngade fingecgecde, yenearu deyadiyemmekecma kucfakaga damu damuyagoc dekperagiyemmegecde. ");
INSERT INTO ded_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Ge kibikperagiagoc nga ngictauac kucgagoc amma ua bibiagoc mekecnec, yeni imocac yoac degec ni imoc hennegeng amma negensikecbade. ");
INSERT INTO ded_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Ngic yeneng uaga damu damuyagoc nga kuhagoc mekecnec, imoc dekperagiyemmebisia. Nga ge engenatoa, imoc dekperagibade. ");
INSERT INTO ded_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Geng gombunga anemmekecnec, imoc wiac efea kpac. Yeneng imocac siduc degec ni fakaga dindingacac desogai amma yegec heibade. ");
INSERT INTO ded_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","KEBUNGO ubangerec anemma neneac ubea manganeude. Ye ngaba bic mi anemmeude amma yeng yoac dedzege amma imoc modackecde, faka imocngo wiac engena ande. ");
INSERT INTO ded_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","KEBUNGO ngicngac sasawa gombunga anemmema marikibifora neneac ubamangang anemmeude. ");
INSERT INTO ded_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","O KEBU, ge wiac sasawa mefiyununec, yeni geac ubangerec megembisia. Nga ngicngacfocga kpetiac yeneng kenecguma ");
INSERT INTO ded_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","eucererenggac kibikperagiaac siduc dekperagima kucgaac yoacsiduc dekperagibisia. ");
INSERT INTO ded_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Ifi anggec ngic sasawango uaga kuhagoc mekecnec, imoc negenggecde. Yeni eucererenggaac kuc kibikperagiagoc, imocac siduha negenggecde. ");
INSERT INTO ded_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Geac eucerereng imoc nasoya nasoya feengkefu geng ngictauac kucngo garengyunukecnec, imoc ngic fingecsahenina fekefude, imocacsoc feengkefude. KEBUNGO yoara sasawa deec, imoc modarude nga faka angammemea imoc ubangerecgoc. ");
INSERT INTO ded_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Ngicngac manunubeso anu KEBUNGO nenang sasawa nanggenunuude. Ye ngicngac tipetangyunuyunuya miacyunuude. ");
INSERT INTO ded_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Geng nasoya hau yaka yemmenadeac sasawango geac negeung amma kicngina gearu figecde. ");
INSERT INTO ded_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Wiac kekecnginagoc sasawa yeni wiac monggac ayemmeu geng mariga mekpacgema yemmena soha megecde. ");
INSERT INTO ded_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","KEBUNGO fakaya dindingac modacma wiac sasawa meande, imoc ubangerecgoc anemmeude. ");
INSERT INTO ded_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Ngicngac KEBU kpacgec yeng yeneac wegenac kefude. Nga ngicngac ikocngina kpac kecma ye kpacandae, ye yenigoc wegenac kefude. ");
INSERT INTO ded_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Ngicngac eweheihei ammiandae, yeni wiac monggac me monggac ayemmeu yeng imoc yemmeu naric kecgecde. Yeng kpakpacngina negemma ebicfunac mesiyunuude. ");
INSERT INTO ded_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Ngicngac yeneng KEBU songogoc hoanggekecgec Kebungo onggongyunuude. Anu ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni memanganeyunuu kpac andacgecde. ");
INSERT INTO ded_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Enacbibicnango KEBUAC dedengerec yoac deude. Ngicngac bangecsebigoc kecdae, ngeni sasawango yeac kpara kpetiac nasoya nasoya kenehebisia. ");
INSERT INTO ded_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","KEBU yoyomo heimini, hallelu Yac. O ubaongana, ge KEBU dengerebesena. ");
INSERT INTO ded_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Ni kekecnau KEBU afehema kekec kecbadesoc Anutunaac dedengerec yegec heibade. ");
INSERT INTO ded_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Ngeni ngictauac medacfocngina nga bangecngicac medac sasawa mi negenseriyunubisia, imoc negembisia. Yeneng naric mi meficngunugecde. ");
INSERT INTO ded_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Asunginango wayunuma kenu yeneng homema emu bangecfu monggoc kemegecde. Nga yeni ua hania hania megecdeac arenggekecgec, imoc uameme imohaingoc kpac andarude. ");
INSERT INTO ded_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Yakoboac Anutungo ngic monggac memeficngic anude, imohai ngic imocngo kenehagoc anude. Ngic mong ye KEBU Anutu negensima fora fingerudeac tomai kecande, ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Anutungo kurumeng nga bangec meficgema kondung nga kondung manau wiac sasawa fede, imoc meficgedarec. Ye yoac modac modac KEBU. Ye ifi kecde nga nasoya nasoya ifi kecengkefude. ");
INSERT INTO ded_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Ngic goa yeneng ngic ogofocngina ebicfu faiyunugec ubaebicgoc kecgec Kebungo sing dindingac modacma isingyunuma yoacngina desiude. Ngicngac herenginaac homegec yeng yaka gumecyunuude. KEBUNGO ngicngac witicamau tacandae, yeni witicngina yungerude. ");
INSERT INTO ded_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","KEBUNGO ngicngac kicpisic kicngina merecgeude nga ngadehokuc ngadengina mesorongaima miacyunuude. KEBUNGO ngicngac dindingac kecandae, yeni songogoc hoangyunuude. ");
INSERT INTO ded_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Ngicngac kuric kecgec KEBUNGO yenenggareng ayemmema ngac hodzec nga beging nanggeyunuude. Ngic Anutu ngadehema mangana megecdeac ayemmeande, yeneac singngina ine memanganeude. ");
INSERT INTO ded_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","KEBU Sionggac Anutu, ye nasoya nasoya geac ngictau anggengkefude. Ye fingecsahega fekefudesoc geac ngictau anggengkefude. KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","KEBU eriendzong memini, hallelu Yac. Anutunina yegec heimima dengereni, imoc wiac gombunga yombong. Ye ubangerec anemmeandeac amma ye sesehema yegec heimini, imoc ubangerehagoc nga faka imoc ngereede. ");
INSERT INTO ded_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Ngic yeneng Israe arenggac ngicngac bic ukuyunugec. Nga KEBUNGO Yerusareng taong ine monggoc mema megboriu yeni monggoc kpedzucyunuma hoangyunuude. ");
INSERT INTO ded_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Ngicngac herenginau ebic mema manganeyombonggeu yeng mengereyunuma kubecngina sangohoude. ");
INSERT INTO ded_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Yeng asomeng kpetengina meserima kpacngina tembuc tembuc kparude. ");
INSERT INTO ded_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","KEBUNINA ye damu damuyagoc nga ye kuha engena yombong. Ngic mongngo yeac negen negentegecac kpetea naric mi meude, kpac. ");
INSERT INTO ded_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Ngic yeneng ngicngac ogofocngina memayunugec KEBUNGO monggoc miacyunuma nanggeyunuude. Nga ngic Anutu ngadehema mangana megecdeac ayemmeande, yeni ine meyunuma bangecfu ukuyunuude. ");
INSERT INTO ded_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","KEBU ubangerecac yegec heimima Anutuninaac gita kpema imocngo udumeng gombunga memini. ");
INSERT INTO ded_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Yeng kurumenga kurumenga hoengngo kperacyunuma kia faiu bangecfu mama fagannu kpindzing meficgeu ereude. ");
INSERT INTO ded_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Yeng yang hania hania yakangina meficgeyemmeude. Neng yeneac medacngina yakaac derecgegec yeng yaka yemmeude. ");
INSERT INTO ded_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Yeng becosi kuhagoc henu wiac engena mi ande nga ngic kuhagoc ye haningo sing herea tiu ye imoc henu wiac engena mi ande. ");
INSERT INTO ded_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Ngicngac ye eweheiheigoc hoangeandae, yeng yenemma nengenu ngereeude. Yeng yoac dedzege amma imoc modarude. Nga ngicngac yeneng imocac negensima fora fingerudeac tomai kecandae, ye yeneac negenu ngereeu sogaiude. ");
INSERT INTO ded_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","O Yerusareng, ge KEBU yoyomo heimina. Siong, ge Anutuga yaiyo kpemibesena. ");
INSERT INTO ded_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Ye taongga oda mengerema naguyaac aieng meseriu seria monggoc nanude. Yeng amaga manau medacfocga kenecyunuude. ");
INSERT INTO ded_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Ye bangecgau ma faima ngicngacfocga onggongngunuu ruaegoc kecgecde. Ye wit semeng gombunga yombong meficgengemmeu negebec anggecde. ");
INSERT INTO ded_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Ye dederecgeyoara bangecfu sueu imocngo bic yombong nedzima haude. ");
INSERT INTO ded_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Ye nomang sueu imoc rama dzoea, ifi isoc amma bangecfu maude. Ye nomang bangecfu haudeac deu imocngo hama isoc bangec semeude. ");
INSERT INTO ded_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Ye nomanggbomea minginango nomanggbomea imoc wiac kotaha isoc ukuu mau mongngo yeac nomang imohai serima naric mi nanude. ");
INSERT INTO ded_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Ye nomanggbomea yoac edeyunuu yeni sisingaima doku monggoc anggecde. Ye firang minginango firang sueu bangec fifiranggeu doku dzuamagoc hakecgecde. ");
INSERT INTO ded_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Ye yoara Yakobo mekperagimiu sing nga dederecgeyoara imoc Israe areng mekperagiyemmeec. ");
INSERT INTO ded_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Ye bangec areng goa yeni faka ifia mong mi ayemmeec. Yeneng yeac dederecgeyoac mi negendae, kpac. KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","KEBU heiwayong memini, hallelu Yac. Kurumenga kurumenga areng kecdae, ngeni KEBU ohec memibisia nga sawau kecdae, ngeni Kebu dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Kebuac angero sasawa ngeni ye dengerebisia. Kurumennu yeac wasai areng, ngeni ye dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Wenac nga afo amma asomeng kperagiagoc, ngeni yoyomo heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Kurumenga kurumenga wi yombong nga kurumenga kurumenga witinginau doku fedae, ngeni KEBU dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Yennoc yoac deu fingecgecac ngeni sasawango KEBUAC kpac kuneng heiwayong memibisia. ");
INSERT INTO ded_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Yeng tatacnginau seria tacgecdeac faingunuma mangina faiec, imoc naric mi ferahagecde. ");
INSERT INTO ded_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Ngicngac bangecfu kecdae, ngeni KEBU eriendzong memibisia. Kondunggac yangtoatoa amma kondung kunenggac dzohongtoa keme kemea, ngeni KEBU dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Piratac nga nomanggbomea amma nomang maande nga nomang bangecfu fingecande amma kia firang, ngeni sasawango yeac enac tofohobisia. ");
INSERT INTO ded_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Tiki fagang nga ic foragoc amma yomondzoc ic sasawa, ");
INSERT INTO ded_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","kateu yang nga amaac yang sasawa, gisicgbiriring nga neng kpututuckegecde. ");
INSERT INTO ded_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Bangectoa bangecac ngictau nga ngiha ngiha nga ngictauac medacfocngina nga bangecac ngic enara kecdae, ");
INSERT INTO ded_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","sebigbori medac nga naroang momoc, ngicngac kpengeng nga nambarac, ");
INSERT INTO ded_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","ngeni sasawango KEBUAC kpac kuneng heiwayong memibisia. Ye kpactoayagoc, imocac ye afehebesonga. Yeac kuc kibikperagiagoc kurumeng nga bangec feracyunuma wi fede. ");
INSERT INTO ded_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Ye ngicngacfora yeneac amma ngictau mong nanggeu kuhagoc amma firang anude. Yeac ngicngacfora kpetiac kecandae, ngeni ye dengerebisia. Kebu ye Israe habufora yeac wegenacfu hama kecdae, ngeneac amma ngictau faiec. KEBU eriendzong memibesonga, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","KEBU eriendzong memini, hallelu Yac. KEBUAC yegec gboria heimibesonga. Ngicngacfora yeac yoac modackecdae, ngeni kpekpeturangnginau yeac yegec gboria heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Yeng Israe meficngunuu ngeni yeac ubangerec negembisia. Sionggac medacfora, ngeni ngictaunginaac sogaibisia. ");
INSERT INTO ded_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Ngeni yegec fedema yeac kpac kuneng heiwayong memibisia. Ngeni tambaring nga gita kpema udumeng gombunga meficgema oeha memibisia. ");
INSERT INTO ded_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","KEBUNGO ubangerecgoc ngicngacfora ngeneac negenu ngereeude. Yeng ngicngac yumia ebicfunac mesingunuu imocngo wiacngina sirihau anu heingemmeu kemeude. ");
INSERT INTO ded_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Yoac modac modac ngicngac ngeni sogaima fefenginau fema ubangerec negemma yegec heimibisia. ");
INSERT INTO ded_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Ngeni enacnginango dendzerenggema Anutu dengerema maringinau soe mana ngadea enaragoc mema kecma ");
INSERT INTO ded_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","imocngo bangec monnunac ngicngac yenearu turungngina kpouyemmebisia. Ngeni ngiha ngiha kopocsicnginaac turunga kpouyemmema ");
INSERT INTO ded_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","seng mema imocngo ngictaufocngina witicyunugec ngickunengfocngina aiennu mendanggyunubisia. ");
INSERT INTO ded_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Yoac yofi bic oho ohoya fede, “Yeneac yoac imoc modacma yoacngina isinggema desibesonga.” Nga imocngo Anutuac ngicngac yeac yoac modacma kecdae, yeneac kuc kibikperagiagoc anude. KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","KEBU eriendzong memini, hallelu Yac. Anutu womongau eriendzong memibesonga. Yeac kurumenga kurumenga seria fekendae, ngeni imohai yaiyo kpemibisia. ");
INSERT INTO ded_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Kebungo kucfaka damu damuyagoc mekecde amma ye engenatoa kpembibihagoc, imocac yoyomo heimibesonga. ");
INSERT INTO ded_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Ngeni trampet fifima udumeng meficgema ye dengerema yoming nga gita kpema udumeng meficgema heiwayong memibisia. ");
INSERT INTO ded_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Ngeni tambaring kpema yegec fedema ye dengerema gitakurere kpema kungac fifima dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Ngeni kpeng kpema ye dengerema kpeng udumenga kunengngoc fifima dengerebisia. ");
INSERT INTO ded_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Wiac sasawango asu heiandae, ngeni KEBU eriendzong memibisia. KEBU eriendzong memini, hallelu Yac. ");
INSERT INTO ded_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristoarunac fingecsahe amma fingeceregec, imocac yofi ohogec. Yesu ye Dawidiarunac nga Dawidi ye Abrahanggarunac. ");
INSERT INTO ded_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahang ye Isakaac mama. Isaka ye Yakoboac mama. Yakoboarunac Yuda nga dacmunafora. ");
INSERT INTO ded_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudaac medahora Perese nga Dzera fingeroc, yereac nonggongira Tama. Anu Perese ye Hesoronggac mama nga Hesorongngo Ranggac mama. ");
INSERT INTO ded_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rangngo Aminadaac mama, Aminadango Nasonggac mama nga Nasongngo Sarmonggac mama, ");
INSERT INTO ded_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Boas ye Sarmong nga enema Rahabaarunac. Boasi ye Obedac mama nga nonggea, imoc Ruti. Nga Obedngo Isaiac mama. ");
INSERT INTO ded_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaingo ngictau Dawidiac mama, Dawidingo Saromoac mama yeac nonggea ye warac Uriaac enema kefec. ");
INSERT INTO ded_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromo ye Rehoboanggac mama, Rehoboang ye Abiaac mama nga Abiaarunac Asafa. ");
INSERT INTO ded_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafa ye Yosafataac mama, Yosafatango Yoranggac mama nga Yorang ye Usiaac mama. ");
INSERT INTO ded_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiango Yotanggac mama, Yotang ye Ahasiac mama nga Ahasi yearunac Hesekia fingerec. ");
INSERT INTO ded_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiaarunac Manasse fingerec, Manassearunac Among, Amonggarunac Yosia fingerec. ");
INSERT INTO ded_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia yearunac Yekonia nga munafora fingecgec. Yeni Babirong bangecfu meyunu kenggec, naso imohai fingecgec. ");
INSERT INTO ded_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yeneac ngadeu Saratiere fingerec, ye Yekoniarunac. Nga Saratiere yearunac Dzorobabe. ");
INSERT INTO ded_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Dzorobabearunac Abiudu, Abiuduarunac Eriaking, Eriakinggarunac Asore fingerec. ");
INSERT INTO ded_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asorearunac Sadoko, Sadokoarunac Aking nga Akinggarunac Eriudu fingerec. ");
INSERT INTO ded_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriuduarunac Ereasa, Ereasaarunac Matang nga Matanggarunac Yakobo fingerec. ");
INSERT INTO ded_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakoboarunac Yosefe Mariaac ewea fingerec. Nga Maria yearunac Yesu, kpara Kristo degec, ye fingerec. ");
INSERT INTO ded_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Fingecsahengina Abrahanggarunac erekecma Dawidi fingeru andenga 14 ande. Nga Dawidiarunac fingecsahengina erekecma andenga 14 ammanu Babironnu meyunuma kenggec. Nga imohacnac namma erekecgec andenga 14nu Messia fingerec. ");
INSERT INTO ded_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yomoc Yesu Kristoac fingec fingecac siduc. Maria nga Yosefe yeri eweeneng anecdeac yoac dedzege bic anoc nga Maria yeng ine Yosefegoc feyac mi ammaec Tiri Asuarunac medac kpenanggeec. ");
INSERT INTO ded_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nga ewea Yosefengo ifi negemma ngic kpetiac kefecac ngicngac yeneac kicfu enembingeha gamekpekpe ammiudeac negenu naric mi anu negen negengua mema tembuhau aikic waudeac negenec. ");
INSERT INTO ded_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ye imocac negen negengua mema kecmanu Kebuac angero mongngo ine gauu fingecmima yofi edeec, “Yosefe, Dawidiac kisicfunac, ge enembingecga Maria menadeac mi kengecgubeso. Sabac hereau tacde, ye imoc Tiri Asuarunac. ");
INSERT INTO ded_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariango medac mong meude, yeng kecma ngicngacfora kopocsinginaunac mesiyunuu komoc kpegecde. Imocac ge kpara Yesu mibesena.” ");
INSERT INTO ded_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Anu Kebungo yoac profete yenearu faiu degec, imocnoc fingecdarudeac ifi fingerec. ");
INSERT INTO ded_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Negenggec, ngacnaroangngo medac mong kpenanggema meu yeac kpara Imanuere degecde.” Imocac titiha yofi, Anutungo nenanggoc kecde. ");
INSERT INTO ded_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Anu Yosefengo gauunac yacma Kebuac angerongo yoac edeec, imoc modacma kemma Maria hesickema ameau enec. ");
INSERT INTO ded_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Enu yeri eweeneng kekec bic mi kecmaecngoc medac fingeru kpara Yesu kparoc. ");
INSERT INTO ded_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu Betreheng amau Yudaia prowinsiu fingerec, naso imohai Herodengo ngictau kefec. Kecmanu negen negengngic goa bangec wenac ere ereaunac Yerusarennu hama ");
INSERT INTO ded_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yofi degec, “Yudangic ngeneac ngictau fingecdac, ye dahai? Neni wenac ere ereau tacma yeac asomeng ereu hemma ye eweheiminideac hadimbe.” ");
INSERT INTO ded_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ifi degec ngictau Herodengo imoc negemma ubaebic meec. Meu ngicngac Yerusareng taonnu kecgec, yeneng ifingoc anggec. ");
INSERT INTO ded_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nga ye yudaareng yeneac womong gareng enara nga mitiac negen negengngicfocngina sasawa heitaiyunuma yofi dekpesi ayemmeec, “Messiango dahai fingerudeac dedea?” ");
INSERT INTO ded_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ifi kpesiyemmeu yofi degec, “Imoc Betreheng taonnu Yudaia prowinsiu. Imocacnoc profetengo yoac yofi ohoec fede, ");
INSERT INTO ded_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yuda bangecfu Beterehennac enara mong fingecma israengicngacfocna garengyunuudeac taong imoc yudaarenggac taong goa yeneac mamea kpac.’” ");
INSERT INTO ded_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ifi edegec Herodengo wenac ere ereaunac negen negengngic tembucfu heitaiyunuma asomeng noc nasoac fingerec, imocac naso dindingac negenudeac dekpesi ayemmeu edegec. ");
INSERT INTO ded_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Edegec yeng yofi dema Betreheng amau sueyunuec, “Ngeni kemma sabac dahai fede, imoc hofocma meficgema hama edenugec neng mong ifingoc kemma eweheimibesare.” ");
INSERT INTO ded_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ngictaungo ifi deu yeni imoc negemma sinnu kenggec. Kemma asomeng wenac ere ereau henggec, imocngo monggoc fingeru hemma ubangerectoa negemma desogai homac anggec. Nga asomengngo waraiyemmeu kengkecma sabac feec, ama imocac witiau heiserima tarec. ");
INSERT INTO ded_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Taru yeni amau emma sabac nga nonggea Maria yerenggec. Yeremma fafoc heima ngonducnema ye afehegec. Amma finachienginaunac ubangerecac wiac yofi widicma migec, gol nga hosuc homungkerengagoc amma icsopea homuna gombunga kpara mira. ");
INSERT INTO ded_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nga Anutungo yeni Herodearu sing mi dzigenegecdeac gauu goro dema dederecge ayemmeu yeni sing monnu sing bangecnginau dzigenegec. ");
INSERT INTO ded_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dzigenema kenggec Kebuac angero mongngo Yosefe gauu fingecmima yofi edeec, “Ge yacma sabac nonggeagoc meyuruma worama Aigita bangecfu kemma kecgec. Kecmagec neng edengunubaguc monggoc habisia, nocac Herodengo sabac hofocma meficgema kpehomeudeac dede.” ");
INSERT INTO ded_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ifi deu Yosefengo tofocnac imohaingoc yacma sabac nonggeagoc meyuruu Aigita bangecfu kenggec. ");
INSERT INTO ded_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kemma ihai kecmagec Herode homeuguc dzigenegec. Nga Anutungo profeteac enacfu yoac faiu yofi deec, “Ni Aigita bangecfunac medacna kpacba haec.” imoc fora anudeac ifi fingerec. ");
INSERT INTO ded_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Anu negen negengngic yeneng Herodeac yoac wagec, ye ifi hemma herebutoa negenec. Negemma Betreheng nga amabangec imocac wegenacfu tarec, imohai wasaingic sueyunuu yeni ngicngac imoc yeneac medacfocngina kifangina yohockang namma made, yeni sasawa yunuhomedacgec. Imoc negen negengngic yenearunac naso negenec, imocac sirihau anec. ");
INSERT INTO ded_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ifi anu profete Yeremiaaru yoac yofi dedea, imoc fora fingerec. ");
INSERT INTO ded_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Raama taonnu kiacsonggong nga ubahodung kuneng fingecde. Imoc Rahengo nambaracfora homegec, yeneac kiackecde. Ye nambaracfora homedacgec mong mi kecdaeac demeefai ammigecdeac mi negende.” ");
INSERT INTO ded_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Anu Herode homemanuguc Anutuac angero mongngo Yosefe gauu fingecmima yofi edeec, ");
INSERT INTO ded_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ge yacma medac nonggeagoc meyuruma Israe bangecfu kenna, medac kpehomebesonga degec, ngic imoc yeni bic homegec.” ");
INSERT INTO ded_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ifi deu Yosefengo efaima yacma medac nonggeagoc meyuruma Aigita bangec wama Israe bangecfu dzigenema kenggec. ");
INSERT INTO ded_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kemma Yosefengo yoacsiduc yomoc meficgeec, “Akeraongo mama Herodeac tatac mema Yudaia prowins, imocac ngictau anec.” Yosefengo imoc meficgema ihai kecbeso kengec kpeec. Nga ye gauu goroyoac negenecac Gariraia prowinsiu kenec. ");
INSERT INTO ded_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kemma taong mong kpara Nadzarete, ihai emma kecgec. Profete yeneng yoac yofi degec, “Ye nadzaretengic, ifi degecde.” imoc fora anudeac ifi fingerec. ");
INSERT INTO ded_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naso imohai Yohane dokunadzicngo Yudaia bangec kisiu hama ngicngac mitiyoac edekpou ayemmema ");
INSERT INTO ded_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","yofi deec, “Kurumenggac eucererengngo bic mewegenengunudeac ngeni ubangina merenggec.” ");
INSERT INTO ded_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nga profete Yesaiango Yohaneac yofi ohoec, “Bangec kisiu kpakpac mong yofi fingecde, ‘Ngeni KEBUAC sing wisima singa heitumeigec.’” ");
INSERT INTO ded_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nga ye wamba kamere dzoeango memea, imoc heima fadenga mong yangseberango memea, imocngo kebangau dzegeec. Amma ye ipua nga kateac kukundzau nekefec. ");
INSERT INTO ded_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Anu Yerusareng ngicngac nga Yudaia prowinsiunac amma Yodang doku wegenacfu bangec tackenec, imohacnac yeni amanene yearu kenggec. ");
INSERT INTO ded_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kemma kopocsicngina deficgemagec Yodannu doku nadzicyemmeec. ");
INSERT INTO ded_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farisaio nga sadukaio homacngo doku nadzicgecdeac hagec Yohanengo yenemma yofi edeyunuec, “Boidzocac gboricfora, ngeni Anutuarunac turunga haudeac ande, imohacnac woragecdeac merang goroyoac edengunuec? ");
INSERT INTO ded_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Imocac ngeni doku nadzicma ubamerenggac siricfu fora meficgebisia. ");
INSERT INTO ded_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nga ge geanggaac yofi mi negengemebesena, ‘Abrahang ye bangecna.’ Anutungo hoc yomoc naric deu Abrahanggac bangecfora fingecgecdenoc, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Naka ic haniau bic faigec fede. Nga ic goa fora gombunga mi angandae, imoc sasawa heiu kpeu gerecfu ukugecde. ");
INSERT INTO ded_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ni uba dzigec dzigeneac doku nadzicngemmebade. Nga ngic ngadenau hama kecde, yeng ine Tiri Asu nga gerec nadzicngemmeude. Nga yeac kucngo neac kuc ferahade. Ni ifiango yeac hanitabe hesimiba naric mi ngereeude. ");
INSERT INTO ded_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ye meic meicke saraha mariau mehama wit seuhagoc meic meicke sobennu feu imoc fima seuha meickeude. Meickema fora mekpedzuc amma ameau faima seuha wanggema gerec pisic pisickea kpac, imohai ukuu dzeude.” ");
INSERT INTO ded_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naso imohai Yesungo Gariraia bangecfunac Yodang dokuu kemma Yohanengo mitidoku nadzicmiudeac edeec. ");
INSERT INTO ded_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Edeu Yohanengo imoc negenu naric mi anu deec, “Geng ni naric nadzicnennade, imoc ngereede, ammanu geng nearu hama nadzicgembadeac denec.” ");
INSERT INTO ded_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ifi deu Yesungo yofi deec, “Ge yoac imoc wana, faka dindingac sasawa fora fingerudeac yaguc edeguduae, ifi anna ngereeude.” Ifi deu naric dema yoara tofohoec. ");
INSERT INTO ded_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nga Yesungo doku nadzicma dokuunac eremanu kurumeng anggeec. Anggeu Anutuac Asungo kebesacac siric amma hau hemmanu yearu maec. ");
INSERT INTO ded_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mamanu kurumennunac ubaudumeng mongngo yofi deec, “Yomoc songomedacna, ye hensongo ammiduae.” ");
INSERT INTO ded_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Naso imohai Asungo Yesu wangecma mangana minginango ye tobanggeudeac bangec kisiu hesicke kenec. ");
INSERT INTO ded_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kenu Yesungo imohai hadzingtoforec 40 yakasege kecma hereaac homeec. ");
INSERT INTO ded_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ifi anu faitobang ngicngo yearu hama deec, “Ge Anutuac Medac fora kecnecfu hoc yomoc dena meremma ic sogong anu.” ");
INSERT INTO ded_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ifi deu Yesungo yoac yofi meremmiec, “Yoac yofi oho ohoya fede, ‘Ngicngo ic sogonggacsac mi kefude, kpac. Ye Anutuac enacfunac yoac ereandesoc, imoc sasawa mema kecbeso.’” ");
INSERT INTO ded_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ifi deu mangana minginango Yesu hesickema taong kpetiacfu kemma Anutuac womong witiau wi yombong, ihai faiu nanu edeec, ");
INSERT INTO ded_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Ge Anutuac Medac fora kecnecfu geanggaoc yomohacnac yuma kemena. Yoac yofi oho ohoya fede, ‘Ye geac amma angerofora uayoac yemmeu yeneng maringina witiau tofohogugec hoc mongngo haniga mi herecgeude.’” ");
INSERT INTO ded_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ifi deu Yesungo yofi edeec, “Nga monggoc yoac yofi oho ohoya fede, ‘Ge Kebu Anutuga faitobannu mi faibesena.’” ");
INSERT INTO ded_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ifi deu mangana minginango Yesu monggoc hesickema tiki buma kuneng monnu emma bangectoa bangec gawamangnginagoc nga kuc kibikperagingina hania hania, imoc edzahema ");
INSERT INTO ded_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","edeec, “Negenna, ge fafoc heima ngonducnema eweheinennadeu yomoc sasawa gembade.” ");
INSERT INTO ded_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ifi deu Yesungo yofi edeec, “Satang ge meickena. Yoac yofi oho ohoya fede, ‘Ge Kebu Anutuga, ye mocgu eweheimima kingang kpemibesena.’” ");
INSERT INTO ded_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ifi deu mangana minginango wama kenu angero yeneng hama Yesu henggareng ammigec. ");
INSERT INTO ded_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngic yeni yoac yomoc degec, “Yeni Yohane witicamau faigec tacde.” Yesungo imoc negemma Gariraia bangecfu Nadzarete taonnu dzigeneec. ");
INSERT INTO ded_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Dzigenema Nadzarete wama Seburong nga Naftari yereac bangec Gariraia dzohong tegiau, Kafanaung taonnu tacyac anec. ");
INSERT INTO ded_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Profete Yesaiango imocac kpefinnu yofi deec, ");
INSERT INTO ded_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yodang noboc sing doku dzohonnu kende, Seburong nga Naftariac bangec ihai bangec monnunac ngicngac Anutu mi negemmidae, yeneng Gariraia bangecfu kecdae. ");
INSERT INTO ded_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ngicngac kundunnu kecgec, yeni kperagi kuneng henggec nga ngicngac homecac bageu bangecfu kecgec, yeneac botucfu kperagia fingerec.” Yoac imoc fora anudeac ye Kafanaung taonnu tacyac anec. ");
INSERT INTO ded_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Naso imohai Yesungo ngicngac yoac yofi edekpou ayemmeec, “Kurumenggac eucererengngo bic mewegenengudeac ngeni ubangina merenggec.” ");
INSERT INTO ded_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesungo ifi kpouyemmema kemma Gariraia dzohong tegiau kensikema dacmunac yohockang uficngira dzohonnu ukuma nanec yerenec. Imoc Simong, kpara mong Petoro degec nga munea Anderea. Yeri kondungyang meme ngic kefoc. ");
INSERT INTO ded_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeri yeremma yofi edeyuruec, “Ngeri hama modacnuec. Ngeri kondungyang meandape, ifi isocngoc ngic meyunuecdeac kpoungemecbade.” ");
INSERT INTO ded_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ifi deu yeri imohaingoc uficngira wama ye modaroc. ");
INSERT INTO ded_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Anu imohacnac kemma monggoc dacmunac yohockang, Dzebedaioac medahora, Yohane nga munea Yakobo yerenec. Yerenu yeri mangngira Dzebedaiogoc gombau uficngina memengere amma kecmagec kpacyuruec. ");
INSERT INTO ded_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kpacyuruu yeri naso imohaingoc mangngira nga gomba wama ye modaroc. ");
INSERT INTO ded_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesungo Gariraia ihai bangecsoc yerecgema kpekpeturang amanginau kpoukpou ua mema eucererenggac siduc gombung dekperagiyemmekefec. Amma ye ngicngac hafei nga kucmamangina hania hania sasawa mengereyunudarec. ");
INSERT INTO ded_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ifi anu yeac siducngo kemma Siria prowins sasawa sokodarec. Sokodaru ngicngac yeneng ngicngac hafei hania haniango memanganeyunuec nga kpendzengtoa kpegec amma hadehade nga yafinggoc amma goa afonasongina hau ubasufu angandae nga ngicngac hanimaringina homemea, yeni Yesuaru meyunu kendacgec yeng mengereyunuec. ");
INSERT INTO ded_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nga Gariraia bangecfunac nga Dekaporisi, imohacnac amma Yerusareng taonnunac nga Yudaia prowins amma Yodang nobocgennac ngicngac habutoango yombong ye modackecgec. ");
INSERT INTO ded_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Yesungo habutoa yenemma tikiu emma tarec. Tacmanu medacfora yeneng yearu kenggec yeng yoac yofi dema kpouyemmeec. ");
INSERT INTO ded_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ngicngac Asuac songou home homegoc kecandae, yeni kenecnginagoc, nocac kurumenggac eucerereng imoc yeneacnoc. ");
INSERT INTO ded_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ngicngac ubahodunggoc kecandae, yeni kenecnginagoc, Anutungo yeninoc meefaiyunuude. ");
INSERT INTO ded_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nga ngicngac memaemema kecandae, yeni kenecnginagoc, nocac bangec yomocngo yeneac maridzoming anude. ");
INSERT INTO ded_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ngicngac yaka nga dokuac homeandae, ifi isoc dindingac kekecac homeandae, yeni kenecnginagoc, Anutungo yeni imoc gumecyunuu gebecyunuude. ");
INSERT INTO ded_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ngicngac ogofocngina yeneac ubamangang negengandae, yeni kenecnginagoc, nocac Anutungo ifingoc yeneac ubamangang negenude. ");
INSERT INTO ded_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ngicngac ubangina kongaha kecandae, yeni kenecnginagoc, yeni Anutu henggecde. ");
INSERT INTO ded_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ngicngac yare menomaneandae, yeni kenecnginagoc, nocac yeni Anutuac nambaracfora deyemmebesonga. ");
INSERT INTO ded_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ngicngac faka dindingac angkecdaeac yunumeme ayemmeandae, yeni kenecnginagoc, kurumenggac eucerereng imoc yeneac. ");
INSERT INTO ded_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nga ngeni neac arennu kecdaeac amma ngic yeneng desofoc nga ngunukporac angemmema ikoc amma ngeneac negemma yoac mangana hania hania angemmegecde. Yeni ifi angemmegecde, ngeni kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bungngina kunengngo kurumennu tomaingina fede. Ngeni imocac ubangerec negemma sogaibisia. Ngicngac yeneng warac profete yunukporac ayemmegec, yeni ifi isoc angemmegecdenoc. ");
INSERT INTO ded_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ngeni bangecngicngac yeneac kondung. Kondungngo kiacma songea kpac anudeu songea monggoc naric mi meficgeude. Kondung ifia, imoc uaya kpac. Imoc eng bangecfu ukuni ngic yeneng haningo tigecde. ");
INSERT INTO ded_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Anu ngeni bangectoa bangec yomocac kperagi. Taong mong tikiu nande, imoc naric mi sufuude. ");
INSERT INTO ded_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nga ngic mongngo kifa kpedzereckema pake bageau naric mi faiu tarude. Imoc ine kifa tatahau faiu tacma ngicngac ama manau tacdae, yeni mekperagiyunudarude. ");
INSERT INTO ded_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nga ngeneac kperagingo siriha imocngoc amma ngicngac mekperagiyunubeso. Mekperagiyunuu yeni angammemengina gombunga hemma Mangngina kurumennu kecde, ye dengeregecde. ");
INSERT INTO ded_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ngeni yofi mi negembisia, ye dedeseriyoac nga profete yeneac kpoukpouyoac kpeudeac maec. Negenggec, ni yoac kpebadeac mi mayai, kpac. Enacdedea imocngo fora fingerudeac mayai. ");
INSERT INTO ded_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Foracngoc, bangec nga kurumeng yeri kpac anecde. Nga dedeseriyoacac dzikangabisic mongngo naric mi kpac anude. Dedeseri kibiu yoac oho ohoya fede, imoc sasawango foragoc ammanu bangec nga kurumeng wisickeude. ");
INSERT INTO ded_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Imocac amma yofi ande, mong ye dedeseriyoac yomohacnac wiac kapiabisic mong meickeude amma ogofora ifingoc anggecdeac kpouyemmeude, yennoc kurumenggac areng yenearunac ngic mamea yombong demigecde. Nga ngic mong ye dedeseriyoac tofohoma ogofora modacgecdeac kpouyemmeude, ye kurumennu ngicngac yeneac engena demigecde. ");
INSERT INTO ded_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ni edengunuba negenggec, ngeni fakangina dindingacngo mitiac negen negengngic nga farisaio yeneac angammeme mi feraheyombonggeudeu ngeni kurumenggac eucererennu naric mi enggecde. ");
INSERT INTO ded_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Bangecfocnina nga esangabofocnina yeni yofinoc ede edeyunuya, ‘Ge ngicngac mi yunuhomebesena. Nga mong ye ngic kpehomeude, ye yoacac areng anude.’ ");
INSERT INTO ded_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Neng ine yofi edengunuba, ngic mong ye ogeaac herebu angande, ye yoacfu nambeso. Nga mong ye ogeaac yofi deude, ‘Ge ngic irec ireckea kpac.’ Ye yudangic yeneac tutumangtoanginau faibesonga. Nga mong ye ogeaac yofi deude, ‘Ge negen negengga kpac.’ ye hofeac gerecfu ukugec kemeude. ");
INSERT INTO ded_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ge imocac amma ubangerecgaac wiac Anutuaru faibeso dema yofi ambesena. Aratau kemma ogoga geac ngaba mekecde, imoc negensinadeu ge sesega arata kiwau wana taru kemma ogogagoc yoac mengerena. Mengerena ruae fingeruguc hama ubangerecgaac wiac faibesena. ");
INSERT INTO ded_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nga ngabagango yoacfu faigubacac ngerahafoc sinnu kemma yegoc dedefic angemema ngaba wabesera. Ge ifi mi annadeu ngabagango desi desingic yearu faiguu yeng keracnatang yeneac mariu faiguu witicamau faigugecde. ");
INSERT INTO ded_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ni fora yombong edeguduae, ge witicamau takecma ogogaac turung sasawa hafoangoc kpoumaguc manade. ");
INSERT INTO ded_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Anu yoac yofi bic edengunugec fede, ‘Ge kaisero mi ambesena.’ (Makekeng 20:14) ");
INSERT INTO ded_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Neng ine yofi edengunuba, ngic mongngo ngac mong hemma hensongo ammiude, ye hereango serofaka bic andac. ");
INSERT INTO ded_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nga kicga foingo anggenu kopocsic meficgenadeu ge imoc tatahaunac meickema ukuna kembeso. Sebiga tosea kpac anu sebiga hafoangoc hofeu mi ukugecde, imocngo ngereeude. ");
INSERT INTO ded_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nga marifoigango anggenu kopocsic meficgenadeu ge imoc herecgema ukuna kembeso. Sebiga tosea kpac anu sebiga hafoangoc hofeu mi ukugec kemeude, imocngo ngereeude. ");
INSERT INTO ded_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Warac yofi dekecgec, ‘Ngic mongngo enema wade, ye wawakibi ohoma mibeso.’ ");
INSERT INTO ded_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Neng ine yofi edengunuduae, enemango serofaka mi ammanu ngic mongngo ye waude, ye serongac anudeac ammiude. Nga ngicngo ifi anu enemango eweenenggac sing ferahema kefude. Amma ngic ye ngac wawaya meude, ye eweenenggac sing ferahema serofaka anude. ");
INSERT INTO ded_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Anu bangecfocnina nga esangabofocnina yeni ifingoc yofi bic edeyunuyunuya, ‘Ge dedzegegaac dzadzahac mi meickebesena. Nga yoacga Anutuac kicfu seria deserinec, imoc modacbesena.’ ");
INSERT INTO ded_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Neng ine yofi edengunuduae, ngeni yoacngina seriudeac wiac mong kpacma mi deseribisia. Kurumeng imoc Anutuac amatatac, imocac ngeni kurumeng kpacma yoacngina mi deseribisia. ");
INSERT INTO ded_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nga bangec, imoc Anutuac fetec, imocac ngeni yoacngina deserigecdeac bangec mi kpacbisia. Nga ngeni Yerusareng imoc ifingoc deserima mi kpacbisia nocac imoc Ngictautoa, yeac taong. ");
INSERT INTO ded_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nga ge orucdzoga mocgubisic kongac kongac me dzadzu dzadzu menadeacsoc mi annecac orucga kpacma dedeseri dede, imoc ifingoc wabesena. ");
INSERT INTO ded_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ngeni yoacngina sasawa yofisac debisia, ‘Fora imoc fora nga kpac imoc kpac. Yoacngina yomoc ferahema torokpema degecde, imoc mangana mingina yearunac hade.’ ");
INSERT INTO ded_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ngeni yoac mong yofi bic negenggec, ‘Ngic mongngo ogeaac kic memanganeudeu yeac kic ifingoc memanganebesonga. Nga mongngo ogeaac enac hetackeudeu yeac enac ifingoc hetackebesonga. Kicac turunga imoc kicngo kpoumibesonga nga enacac turunga imoc enacngo kpoumibesonga.’ ");
INSERT INTO ded_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Neng ine yofi edengunuduae, ngicngac mangana angemmegec ngeni turunga mong mi merengyemmebisia. Mongngo munggungga foiu kpeudeu geng munggungga kanau ifingoc sinemibesena. ");
INSERT INTO ded_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nga mongngo yoacfu faigubesonga ngakpiga mana meudeu ge ngakpiga witiau ifingoc wamibesena. ");
INSERT INTO ded_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nga mongngo igocguma sing kiromita mocgu yegoc kennadeac edeguudeu geng kiromita yohockang yegoc kembesena. ");
INSERT INTO ded_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nga ngic mongngo wiac mong minadeac kpesigenu ge imoc mibesena. Nga mongngo gearunac wiac monggac turung ambesonga dema kpesigenu wiacga mi segerebesena. ");
INSERT INTO ded_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yoac mong yofi fede, ngeni imoc warac bic negenggec, ‘Ngicngac gegoc wegena kecdae, yeni heresongogoc hoangyunubesena amma ge ngabafocga ngadeyunubesena.’ ");
INSERT INTO ded_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Neng ine yofi edengunuduae, ngeni ngabafocngina heresongogoc hoangyunubisia amma ngicngac ngunukporac angemmeandae, yeneac numubisia. ");
INSERT INTO ded_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ngeni ifi amma Mangngina kurumennu kecde, yeac nambaracfora kecgecde. Ye wenaha uayoac miu imocngo ngic gombunga mangana yeneac amma ereude. Nga ye ngic dindingac nga ngic faka dindingac mi angandae, yeni momocngoc kia yemmeude. ");
INSERT INTO ded_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nga ngicngac yeneng ngeni heresongogoc hoangngunugec ngeneng yeni heresongogoc hoangyunugecdeu faka imocac buma mong mi fingerude, kpac. Takesimeme ngic yeneng imoc ifingoc angandae. ");
INSERT INTO ded_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngeni dacmunafocngina yeneac edoc bedoc ayemmegecdeu imoc faka engena kpac. Bangec monnunac ngicngac Anutu mi negemmidae, yeni ifingoc imoc angandae. ");
INSERT INTO ded_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imocac amma ngeni yofi ambisia, kurumeng Mangngina ye dindingac kecde nga ngeni ifingoc ye isoc dindingac kecbisia.” ");
INSERT INTO ded_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ngeni ngicngac yeneng ngenemma dengerengunugecdeac yeneac kicfu faka gombunga mi angkecbisia, kpac. Ngeni ifi anggecdeu kurumeng Mangngina yearunac faka gombunggaac buma mong mi megecde. Ifi fingecbacac henghomema kecbisia. ");
INSERT INTO ded_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Imocac ngicngac makpekpea ubangerecac wiac yemmenec, imohai ngicngac yeneng trampet udumengtoayagoc geac amma fifigecdeac mi edeyunubesena. Ngic ikoha goa yeni kpekpeturang amau me singtoau ngicngac yeneng dengereyunugecdeac ifi angandae. Ni fora edengunuduae, ngic ifia yeni bungngina hafoangoc bic megec. ");
INSERT INTO ded_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ge ngicngac makpekpea ubangerecac wiac mong yemmenade, imohai ine marifoigango wiac anu kanagango imoc mi negembeso. ");
INSERT INTO ded_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ge ifi amma ubangerecac wiac mong yemmenade, imocngo sufu sufuu femanu Manggac wiac sufu sufuu hengande, yennoc buma genude. ");
INSERT INTO ded_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Anu ngeni numubesonga dema ngic ikoha yeneng angandae, ngeni ifi isoc mi ambisia. Yeni kpekpeturang amau nga singtuturunnu numuma nanggec ngic yeneng yenemma dengereyunugecdeac songo negengandae. Foracngoc, yeni bungngina hafoangoc bic megec, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ge numubesonga dema, imohai ine amaga mana kapiau emma naguga heima Manggac sufu sufuu kecde, ye numumibesena. Ifi anna Manggac faka sufu sufuu hennegeng angande, yeng buma genude. ");
INSERT INTO ded_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nga ngeneng numubeso dema, bangec monnunac ngicngac Anutu mi negemmidae, yeneng numuandae, ngeneng ifi isoc mi numubisia, kpac. Yeni nunumu herea negengisinga kpac eng numuandae. Amma yoacngina homac osokecdaeac amma negenggec nunumunginango foragoc anude. ");
INSERT INTO ded_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Imocac ngeni yeni isoc mi ambisia. Ngeni mi numumimagec Mangngina yeng ngeni noc wiacac kpedadanggeandae, imoc bic negenude. ");
INSERT INTO ded_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ifi anu ngeni yofi numubisia, ‘Kurumeng Mannina, geac kpac kpetiac febeso. ");
INSERT INTO ded_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nga eucererengga hanemmebeso. Kurumennu geac songo nga negen negeng modacgec fede, siriha imocngoc bangecfu nenearu fingecbeso. ");
INSERT INTO ded_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ge yaguc yaka socnina nemmena. ");
INSERT INTO ded_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nga neni ngic yeneac kopocsic waandimbe, siriha ifingoc kopocsicninaac turunga wanemmena. ");
INSERT INTO ded_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ge faitobannu mi fainununa nga manganaunac mesinunubesena.’ ");
INSERT INTO ded_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ngeni ngicngac mangana angemmegec ngeni yeneac kopocsic wagecdeu kurumeng Mangnginango ngeneac kopocsic ifingoc waude. ");
INSERT INTO ded_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amma ngeni ngic yeneac kopocsic mi wagecdeu ine Kurumeng Mangnginango ngeneac kopocsic ifingoc mi waude. ");
INSERT INTO ded_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Anu ngeni yaka segekecma ikocngic yeneng angandae, ifi isoc mi ambisia. Yeni yakasege kecdae, naso imohai ngicngo yenenggecdeac kicnangengngina huringaiande. Foracngoc, ngic ifia yeni bungngina hafoangoc bic megec, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ge yakasege kecma orucga kerec nadzicmima kicmesuga dzuacbesena. ");
INSERT INTO ded_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ifi anna ngic yeneng ge yakasege kecnec, imoc mi negentegecmagec Manggac mi hengena kecde, yengsac negenude. Amma Manggac angammemega sufu sufuu hengkecde, yengsac buma genude. ");
INSERT INTO ded_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Bangecfu dzaukpadzadzangngo dzofinacngina kirecgeande nga hufengngo wiacngina meande amma hamangecngic yeneng ama hetackema wiacngina meandae. Imocac ngeni bangecfu dzofinacngina mekpedzuc mi ambisia. ");
INSERT INTO ded_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ngeni dzofinacngina kurumennu mekpedzuc ambisia. Imohai dzaukpadzadzangngo wiacngina mi kirecgeude nga wiacngina hufengngo mi meude amma hamangecngic yeneng imohai naric mi hetackema wiac megecde. ");
INSERT INTO ded_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ge dzofinacga fede, imohai songoga ifingoc feude. ");
INSERT INTO ded_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kicga imoc sebigaac kifa nga kicgango gombunga feudeu sebiga sasawa mekperagidarude. ");
INSERT INTO ded_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nga ge kickerec me kicmangang me kicgango manganeudeu ine sebiga sasawa kundung kpeude. Nga kperagi gearu fede, imocngo kundung kpeudeu kundungtoa yombong fingecgenude. ");
INSERT INTO ded_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ngic mongngo ngic kuneng yohockang yereac kingang naric mi kpekefude, kpac. Ye monggac songo negemma mong ngadeheude me monggaru kpeketahema mong waude. Ngeni naso socfungoc Anutu nga dzofinac yereac kingang naric mi kpegecde. ");
INSERT INTO ded_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Imocac amma yofi edengunuduae, ngeni nenedokuac dema kekecnginaac defagung amma yofi mi debisia, ‘Neni noc yaka nema kecnide?’ me sebinginaac negemma, ‘Noc wamba heima kecnide?’ Negenggec, kekecngo yaka feraheude nga sebingo ine ngakpikporuc feraheude. ");
INSERT INTO ded_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ngeni sawau neng yenenggec. Yeni heikpenec me netohong mong mi angkecgec Mangngina kurumennu kecde, yeng yaka eng yemmeude. Nga ngeni isinggema negembisia, ngeneng Anutuac kicfu neng yeneac engena andae. ");
INSERT INTO ded_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nga ngenearunac mongngo dewaidzoc amma kefu imocngo kekecnasoya kapianec monggoc naric mi mehereeude, kpac. ");
INSERT INTO ded_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Anu ngeni nocac negengyohoc amma yofi deandae, ‘Neni noc wamba mema mekecni?’ Ngeni dzaring amasobennu eng tohoandae yenembisia. Yeni witic mi yumuma uatoa mi mema sifu yadiandae. ");
INSERT INTO ded_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nga ngictau Saromo ye warac wamba kibia gombunga gombunga heikefec, yeac kibikperagitoayango ine dzaring yeneac kibi kereng kereng mi feraheec, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nga dzaring amasobennu eng tohoande, imoc yagucacsac fingeru wereckengau herecgema gerecfu ukugecde. Nga Anutungo dzaringtehec ifia wamba heiyemmeudeu ye ifingoc ngicngac ngeni negen negensingngina kapia fede, ngeni ngakpi kporucngina torokpeu torokpe ngemmeude. ");
INSERT INTO ded_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Imocac amma ngeni dewaidzoc amma yofi mi debisia, ‘Neni noc nenedoku nenide me noc wamba heinide?’ ");
INSERT INTO ded_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bangec monnunac ngicngac Anutu mi negemmidae, yeneng imoc sasawa megecdeac negen negengngina imohai faigec fekecde. Nga Kurumeng Mangnginango ngeni wiac sasawa kpedadanggeandae, imoc bic negenude. ");
INSERT INTO ded_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Imocac ngeni warac warac yombong Anutuac eucerereng nga yeac faka dindingac meficgegecdeac uatoa mebisia. Ngeni ifi anggec yeng wiac sasawa imocnoc ifingoc torokpeu torokpe ngemmeude. ");
INSERT INTO ded_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ifi anu ngeni wereckenuac dema negengyohoc mong mi ambisia. Wereckenu ye yengenaoc negengyohoc angemeude. Uameme tembuc tembuc ye yengenaoc ebihaac sirihau ebiha mebeso, imoc soha ande.” ");
INSERT INTO ded_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ngic yeneng ngeneac faka isinggema desingunubauac ngeni ngic yeneac faka isinggema mi desiyunubisia. ");
INSERT INTO ded_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Imoc yofiac, ngeni ngic isingyunuma yoacngina desiandae, siriha ifiangoc yeneng isingngunuma ngeneac yoacngina desigecde. Nga ngeni wiac kpetea isinggema imocacsoc ngicngac wiac yemmeandae, yeni siriha ifiangoc kpetea isinggema turung kpoungemmegecde. ");
INSERT INTO ded_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ge ogogaac kicfu gocbisic tacde, imoc hengannec amma geangga kicfu ine ic kebanga fede, imoc mi hentegecnec, faka ifia imocngo mi ngereede. ");
INSERT INTO ded_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Geangga kicfu ic kebanga femanu ogogaac deannec, ‘Naric negemmana kicgau goc tacde, imoc meickeba.’ ");
INSERT INTO ded_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ikocngic, ge geangga kicfu ic kebanga fede, imoc meickemaguc ogogaac kicfu gocbisic tacde, imoc naric hentegecma meickenade. ");
INSERT INTO ded_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ngeni wiac mong kpetiac dedea, imoc kasi mi yemmebisia nga kubungina imoc berec yenearu mi ukubisia. Kasi yeneng dzigenema nginibauac nga berec yeni imoc haninginango tidzamebauac. ");
INSERT INTO ded_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ngeni turunga fingecngemmeudeac numuma kecbisia nga wiac meficgegecdeac hofocma kecbisia. Amma nagu witingemmeudeac naguu heima kecbisia. ");
INSERT INTO ded_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngic mong ye numukecde, yeng wiac meude nga hofockecdengo wiac meficgeude amma naguu heikecde, yeac nagu witimigecde. ");
INSERT INTO ded_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ngenearunac ngic mong medahango yakaac kpesimiu yeng hoc naric mi miude. ");
INSERT INTO ded_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Me kondungyanggac kpesimiu boidzoc mangana naric mi miude. ");
INSERT INTO ded_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ngeni ngic fakangina manganagocngo sifu nambaracfocngina ubangerecac wiac gombunga yemmegecdeac negentegecdae. Imocac ngeni yofi negembisia, Kurumeng Mangnginango ngeneac faka gombunga imoc homac ferahaude. Ngeni yearu wiac monggac kpesigec yeng wiac gombunga torokpeu torokpe ngemmeude. ");
INSERT INTO ded_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nga ngic yeneng noc faka angemmegecdeac negensiandae, ngeni faka siriha imocngoc ayemmebisia. Imocnoc dedeseriyoac nga profeteyoacac hania. ");
INSERT INTO ded_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ngeni nagu kapiau emma kengkecbisia. Imoc yofiac, manganaac sing imocac naguya kuneng nga sing imoc singtoa amma ngicngac homacngo sing imoc modacma kengkecgec kecma kpetotieyunugecde. ");
INSERT INTO ded_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nga kekecac sing imocac naguya kapia nga sing imoc fofonga anu ngicngac efeanecngosac imohai kengkecma kekec fora meficgegecde. ");
INSERT INTO ded_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Profete ikoha yeneng memanganengunubauac ngeni yeneac henghomema kecbisia. Yeni sebinginango rama sebi nga ubanginango ine katekasi anu yeni godzuac arennu iwaingina wangecngunugecdeac ngenearu hagecde. ");
INSERT INTO ded_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nga forangina fingectegeru, ngeni imoc hemma negengyemmegecde. Ngic yeni kemma witic waeyagoc, imohacnac waing fora naric mi mesigecde. Amma fareng nga gberafecfunac fig fora naric mi megecde, imoc negendae. ");
INSERT INTO ded_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nga ic gombunga sasawa, yenearunac fora gombunga fingerude nga ic manganaunac ine fora mangana fingerude. ");
INSERT INTO ded_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nga ic gombunga imohacnac fora mangana fingec fingec mi fede. Nga ic manganaunac fora gombunga naric mi fingerude. ");
INSERT INTO ded_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ic mong foraya gombunga mi fingerudeu imoc kperecgema gerecfu ukugecde. ");
INSERT INTO ded_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ifi anu ngeni profete ikoha yeneac forangina hemma naric negentegecyunugecde. ");
INSERT INTO ded_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Ngicngac Kebuna, Kebuna.’ ifi denengandae, yenearunac sasawango kurumenggac eucererennu naric mi enggecde. Manna kurumennu kecde nga ngicngac yeac songo nga negen negeng modacma kecdae, yeneng ihai enggecde. ");
INSERT INTO ded_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nga naso imohai ngicngac homacngo edenugecde, ‘Kebu, Kebu, neni geac kpacfu profeteyoac deing amma hadehade nga yafing kporacyunuing amma faka kuhagoc homac meing, ge imoc sifu negennec.’ ");
INSERT INTO ded_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ifi degec yofi yombong edeyunubade, ‘Ni ngeni mi negengngunuduae. Dedeseriyoac kpekpengic, ngeni neac kicfunac meickegec.’ ");
INSERT INTO ded_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ngic mong ye yoacna yomoc negemma tofohoande, yeng ngic irec ireckea nga ngic amea peperandzi witiau meec, ye isoc. ");
INSERT INTO ded_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ye ameaac hania peperandzi witiau nanecac serima taru kiafirangtoa kpeu tungbaungngo hama ama imoc naric mi kpembarackeude. ");
INSERT INTO ded_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nga mong ye yoacna yomoc negemma mi tofohoude, yeng ine ngic negen negenga kpac nga ngic amea sangiu meec, ye isoc. ");
INSERT INTO ded_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kia kpeu tungbaung nga firangtoa kpema ama imoc kpembarackema medidinggeu makpeude.” ");
INSERT INTO ded_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesungo yoac yomoc deu wisickeu ngicngac habutoa yeneng kpoukpouyaac amma kerectegec anggec. ");
INSERT INTO ded_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nocac yeng mitiac negen negengngic yeneac dede isoc mi deec, kpac. Ye ngic uakibi mekecde, yeac siricfu kpoukpou ua kuhagoc meec. ");
INSERT INTO ded_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesungo tikiunac mamanu habutoa kuneng yombongngo ye modacgec. ");
INSERT INTO ded_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Modacmagec ngic mong kukuseriagocngo hama fafoc heimima deec, “Kebu, ge negenna naric anu medzuacnubang.” ");
INSERT INTO ded_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ifi deu Yesungo maria sinema ngic kpeserema yofi edeec, “Ge ngereenadeac songona fede.” Deu imohaingoc sebia ngereeu hafeia kpac anec. ");
INSERT INTO ded_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nga Yesungo yofi edema deraheec, “Ge sebigau faka fingecdac, imocac ngic mong mi edebesena. Ge womong gareng yearu kemma sebiga edzahena. Edzahema Mosengo seseac deec, imoc modacma imocac sirihau faina yeneng sesega imoc hemma negentegecgecde.” ");
INSERT INTO ded_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Anu Yesungo Kafanaung taonnu emmanu wasaigareng mongngo hama meficgeudeac desambic amma deec, ");
INSERT INTO ded_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kunenna, enac tofoc tofoho medacna ye hanimaria homemea amma ye amau kpendzengtoa kpema fema kecde.” ");
INSERT INTO ded_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ifi deu Yesungo yofi edeec, “Ni naric hama mengerebade.” ");
INSERT INTO ded_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ifi deu wasai garengngo yoac yofi meremmiec, “Kunenna, ni noc gombunnaac amawarocnau erenade. Ge yoacgangosac dena enac tofoc tofoho medacna ngereeude. ");
INSERT INTO ded_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Imoc yofi, ni ngic kucnginagoc yeneac bageu kecduae. Nga neac bageu wasaifocna kecdae. Yenearunac monggac kenna deba ye kenude. Ni yenearunac monggac hana deba haude. Nga wanacngicnaac ua yomoc mena deba ye imoc meude.” ");
INSERT INTO ded_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ifi deu Yesungo imoc negemma kerectegec amma ngicngac modacgec, yeni yofi edeyunuec, “Foracngoc, Israe bangecfu ngicngac negen negensingngina seria yofia mong mi henai, imoc yeac henduae. ");
INSERT INTO ded_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Imocac yofi edengunuduae, ngic homacngo wenac ere ereaunac nga wenac keme kemeaunac hama Abrahang nga Isaka amma Yakobo yenigoc kurumenggac eucererennu yenahafoc tacma neneyaka negecde. ");
INSERT INTO ded_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nga Anutungo warac warac yengena eucererenggac areng deec, yeni ine ngadeau kundunnu ukuyunugec kemegecde. Kemema ihai kiacma enacngina kisaranggema kecgecde.” ");
INSERT INTO ded_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ifi dema wasaigareng yofi edeec, “Ge kenna, negensinggenecmoc, imoc fora fingecgenude.” Anu wenac naso imohaingoc enac tofoc tofoho medaha ngereec. ");
INSERT INTO ded_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Anu Yesungo Petoroac amau emma Petoro sefenango sebigerec ammiu feu henec. ");
INSERT INTO ded_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Hemma mariau mema kpesereu sefena hafeia kpac anu yacma yenenggareng ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Marai anu imohaingoc ngicngac yeneng ngicngac hadehade nga yafinggoc homac Yesuaru meyunuu hagec. Hagec, yeng yoac dema asu mangana kporacyunuma hafeinginagoc sasawa mengereyunuec. ");
INSERT INTO ded_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Profete Yesaiango warac yofi deec, “Yeng nenang kucmamanina meickema hafeinina atickeec.” imoc imohai fora fingerec. ");
INSERT INTO ded_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ngicngac habutoango Yesu oronggegec ye ifi yenemma medacfora edeyunuec, “Nenang dzohong noboc kenni.” ");
INSERT INTO ded_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ifi demanu mitiac negen negengngic mongngo hama edeec, “Kpoukpou, ge ihai me ihai kennadesoc ni modacguma gegoc kembadeac negenduae.” ");
INSERT INTO ded_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ifi deu Yesungo yofi deec, “Katekasi yeni bangec manau fefenginagoc nga sawau neng yeni faecnginagoc nga ngicac Medacngo ine kparicganga kpac, ifi kecde.” ");
INSERT INTO ded_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Deu medacfora yenearunac mongngo deec, “Kebu, negennemmana kemma manna tonggomaguc modacgubade.” ");
INSERT INTO ded_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ifi deu Yesungo ine yofi edeec, “Ge homemea wayununa yeni yenaocngoc tonggoemegec. Nga geng ine ni modacnuna.” ");
INSERT INTO ded_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesungo gombau enu medacfora yenahafoc gombau emma kenggec. ");
INSERT INTO ded_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kemmagec firang kucgoc kpeu siritembongngo gomba feraheu kemebesonga anec nga Yesungo ine gau feec. ");
INSERT INTO ded_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Feu medac yeneng Yesuaru kemma midima degec, “Kebu ge onggonnununa, neni kemebeso andimbe.” ");
INSERT INTO ded_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ifi degec yeng yofi edeyunuec, “Ngeni negen negensingngina kapianecsac fede, ngeni kengec mi ambisia.” Ifi dema firang nga dzohong kpetariyemeru firang kpac anu dzohong ye ning kpema eng feec. ");
INSERT INTO ded_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Feu ngic yeni kerectegec amma kpesiemegec, “Ye noc ngic? Firang nga dzohongtoa yereng yeac enara tofohodape.” ");
INSERT INTO ded_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Anu yeni dzohong noboc gadarangic, yeneac bangecfu kensikemagec ngic yohockang hadehadengiragocngo kicsereunac haoc. Yeri wasai yombong, imocac ngicngac yeni imohacsing susuferecge mi angkecgec. ");
INSERT INTO ded_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nga yeri ihai namma kpacma deoc, “Anutuac Medac, neneac wiac imoc geac mi ande. Nasonina mi hamanu ge kpendzeng monnu mi fainunubesena.” ");
INSERT INTO ded_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Anu edibigeng berechabu mong kuneng yeni surukpema kecmagec ");
INSERT INTO ded_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","hadehade yeneng yofi dema Yesu desambic ammigec, “Ge kporacnununade isoc, berechabu yenearu suenununa kemebisina.” ");
INSERT INTO ded_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ifi degec yeng yofi edeyunuec, “Ngeni meickegec.” Deu yeni meickema erema berechabu yenearu kemegec berec yeni hafoangoc fagannunac nedzima dzohonnu kemema doku nema homedacgec. ");
INSERT INTO ded_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Homegec berecgareng yeneng kengec worama taonnu kemma faka imocac siduc sasawa ayemmegec. Ayemmedacma ngic hadehadengiragoc yerearu faka fingerec, imocac ifingoc edeyunugec. ");
INSERT INTO ded_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Edeyunugec taong imocac ngicngac sasawango Yesu meficgegecdeac kemma hemma amabangecngina waudeac edegec. ");
INSERT INTO ded_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesungo gombau emma dzohong ferecgema yengena taonnu kensikeec. ");
INSERT INTO ded_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kensikeu yeni ngic mong hanimaria homemea dzakeu faima tofohoma hagec. Hagec Yesungo negen negensingngina hemma ngic puringa yofi edeec, “Medacna, ge ubaga ngereeu, kopocsicga imoc bic wawaya.” ");
INSERT INTO ded_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ifi deu mitiac negen negengngic goa yenaocngoc negensigec, “Ngic yomoc ye Anutu emmide.” ");
INSERT INTO ded_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ifi negenggec Yesungo negen negengngina hemma yofi deec, “Ngeni ubanginau negen negeng mangana mi negensigec. ");
INSERT INTO ded_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yoac damocngo efea ande, ‘Kopocsicga bic kpac ande.’ ifi debesonga me ‘Ge yacma kenna.’ ");
INSERT INTO ded_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngicac Medac ye bangecfu kopocsic wawaac uayoac nga kuc femide. Nga ngeni imoc negenggecdeac amma yoac yomoc deduae.” Ifi dema ngicpuring yofi edeec, “Ge yacma dzakega mema amagau kenna.” ");
INSERT INTO ded_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ifi deu ngic ye yacma ameau kenec. ");
INSERT INTO ded_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kenu ngicngac habutoa nanggec, yeneng imoc hemma kerectegec amma kengecyunuec. Anutungo uayoac kuhagoc ifia ngicngac yemmeec, yeni imoc hemma Anutu dengeregec. ");
INSERT INTO ded_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesungo imohacnac ferecge kemma takesimemengic mong kpara Mataio, ye takesimeme amau taru hemma yofi edeec, “Ge hama modacnuna.” Ifi deu yacma modarec. ");
INSERT INTO ded_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Anu Yesungo Mataioac amau emma yaka netacmanu takesimeme nga manganameme ngic homacngo hama Yesu nga medacfora yenigoc tacma yaka yenahafoc negec. ");
INSERT INTO ded_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nema tacgec farisaio yeneng imoc hemma Yesuac medacfora kpesiyemmegec, “Kpoukpoungina ye nocac manganameme ngic nga takesimeme yenigoc tacma yaka nede?” ");
INSERT INTO ded_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ifi degec Yesungo imoc negemma yofi edeyunuec, “Ngicngac kuchafeingina kpac kecdae, yeni dotaac mi ayemmeande. Hafeinginagoc, yeneng ine dotaac ayemmeude. ");
INSERT INTO ded_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ngeni kemma yoac yofi fede, imocac negen negeng megec, ‘Ni sesegerec meandae, imocac mi anende. Ngicngac wosoefac angemeandae, imocac anende.’ Imoc yofiac, ni ngic dindingac kpacyunubadeac mi mayai, kpac. Ni ine ngicngac kopocsicnginagoc kpacyunubadeac mayai.” ");
INSERT INTO ded_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naso imohai Yohaneac medacfora yeneng hama kpesimigec, “Neni nga farisaio naso homac yakasege angandimbe amma geac medacfocga yeni nocac yaka sege mi angandae?” ");
INSERT INTO ded_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ifi degec Yesungo yofi edeyunuec, “Memeturanggac ngicngo ogofora yenigoc kecmanu yeni ubahodung naric mi anggecde, kpac. Nga kecma naso monnu memeturanggac ngic yenearunac meickegecde, naso imohai ine yakasege anggecde. ");
INSERT INTO ded_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ngac mong ye ngakpi eseau kporucsusuc gboria mong faima mi kpebiude, kpac. Ye gboria ifi faiudeu gboriango esea taiu dzamema titingtoa fingerude. ");
INSERT INTO ded_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nga ngic mongngo waing gboria bokong yangseberango memea eseau mi kpeu kemeude, kpac. Ifi anudeu waing gboriango bokong esea imoc tindziru manganeu dokuya maude. Imocac waing gboriango bokong gboriau kpegec yerahafoc naric tarecde.” ");
INSERT INTO ded_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesungo yoac imoc edeyunuma tacmanu gareng mongngo yearu hama fafoc heima eweheiheigoc edeec, “Ni naroanna yaguc homedac. Geng hama mariga witiau faina gboriude.” ");
INSERT INTO ded_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ifi deu Yesungo yacma kenu medacfora ifingoc yenahafoc modacma kenggec. ");
INSERT INTO ded_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kemmagec ngac mongngo ngadenginau modacyunuma kenec. Ye kifa 12 sacherec kefecac amma hama negenec, “Ni Yesuac ngakpiasac kpeserebadeu ngerec ngeree meficgebade.” ifi negemma ngakpihereha susiaac witiha kpesereec. ");
INSERT INTO ded_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kpesereu Yesungo dzigene hemma yofi edeec, “Ngac, ge ubaga ngereeu. Negen negensinggango mengeregudac.” Ifi demanu ngac ye imohaingoc ngereec. ");
INSERT INTO ded_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Anu Yesungo kemma garenggac amau kensikema emma kungac fifi fifi areng amma ngicngac habutoa kpeborongngina negemma yofi ");
INSERT INTO ded_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","edeyunuec, “Ngeni yomohacnac meickegec. Naroang ye mi homedac, ye gau fede.” Ifi deu yeni deendema ammima dzomoremigec. ");
INSERT INTO ded_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dzomoremima meickema mamagec, Yesungo naroang feec, ihai emma naroanggac mariau mema miaru gborima yarec. ");
INSERT INTO ded_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yaru siduc imocngo bangec imoc sokodarec. ");
INSERT INTO ded_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesungo bangec imoc wama kemmanu ngic yohockang kicngira pisic pisickeango Yesu modacma arohoma kpacsambic ammima deoc, “Dawidiac bangeha, ge nereacnec ubaga manganeu.” ");
INSERT INTO ded_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ye amau emmanu kicpisic yohockang yereng yearu kenec yeng yofi kpesiyemerec, “Neng faka ifia mebadeacsoc anduae, ngeri imoc negensinggedape me?” Ifi deu yereng deoc, “Oc Kebu, imoc negensinggedipe.” ");
INSERT INTO ded_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ifi deec kicngira kpeserema yofi deec, “Negen negensingngiraac fora fingecngemeru.” ");
INSERT INTO ded_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ifi deu kicngira tegerec. Tegeru wiac fingecyemerec, imoc ngic mong mi edeecdeac dederac ayecmeec. ");
INSERT INTO ded_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nga yereng ine kemma siduha imoc deyadiec amasoc negendacgec. ");
INSERT INTO ded_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Anu yeri kemmaec ngicngac yeni ngic mong yoara kpac nga hadehadeagoc Yesuaru mehagec. ");
INSERT INTO ded_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mehagec yeng hadehade kporacmiu ngic ye yoac deec. Deu ngicngac habutoango imoc hemma kerectegec amma degec, “Israe bangecfu faka ifia warac mong mi fingeru hening.” ");
INSERT INTO ded_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ifi degec ine farisaio yeneng degec, “Ye hadehade yeneac ngictaunginaac kucfu hadehade kporacyunuma kecde.” ");
INSERT INTO ded_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesungo taong nga amabisic sasawau yerecgema kpekpeturang amanginau emma edekpou ayemmema eucererenggac siduc gombung dekperagima hafei hania hania nga ngicngac kucmamanginagoc sasawa mengereyunudarec. ");
INSERT INTO ded_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nga habutoa yeni demadzac nga kucmama amma rama garengngina kpac, ifi isoc kecgec. Imocac amma Yesungo yenemma ubea manganeu ");
INSERT INTO ded_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","medacfora yofi edeyunuec, “Semeng fora homacngoc kpauedac fede nga uangic ine efeanecsac kecdae. ");
INSERT INTO ded_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Imocac amma ngeni Kebu, semeng mingina numumima yofi edebisia, ‘Ge ua ngic sueyununa yeneng kemma foraga mekpedzuc ambisia.’” ");
INSERT INTO ded_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesungo medacfora 12 kpacyunuu hagec ngicngac yenearunac asu seuhagoc kporacyemmegecdeac uayoac yemmmeec nga hafei hania hania amma ngicngac kucmamanginagoc sasawa mengereyunugecdeac uayoac kuhagoc yemmeec. ");
INSERT INTO ded_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposoro 12, yeneac kpacngina yofi, Simong kpara mong Petoro nga munea Anderea amma Sebedaioac medahora Yakobo nga munea Yohane. ");
INSERT INTO ded_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Firipo nga Batoromaio nga Toma amma takesimemengic Mataio, Yakobo Arifaioac medac nga Tadaio ");
INSERT INTO ded_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Amma Simong Kananaio amma Yuda Kariotonac. Ngic yeng kecma Yesu kerereu megec. ");
INSERT INTO ded_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesungo medacfora 12 imocnoc sueyunuma yoac yofi dema edeyunuec, “Ngeni bangec monnunac ngicngac Anutu mi negemmidae, yeneac bangecfu nga samariangic yeneac taonnu mi kembisia, kpac. ");
INSERT INTO ded_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israehabuu ngicngac rama sufu sufuya, ifi isoc kecdae, ngeni yenearu kembisia. ");
INSERT INTO ded_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ngeni kemma yofi dekperagiyemmebisia, kurumenggac eucerereng imoc bic mewegenengunude. ");
INSERT INTO ded_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ifi dekperagiyemmemma ngicngac hafeigoc mengereyunuma homemea megboriyunubisia nga kukuserigoc sebingina ngereeudeac mengereyunuma hadehade nga yafing kporacyunubisia. Ni kuc imoc ubangerecac nga buma kpac ngemmedua, imocac amma ngeni ubangerecac nga buma kpac memefic imoc yemmebisia. ");
INSERT INTO ded_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ngeni dzo gol nga siriwa nga kopango memea, imoc mi meficgebisia nga wiac ifia fadeng nabehau mi faima mekecbisia. ");
INSERT INTO ded_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ngicngac yeneng ua mekecmagec ua imocngo yakangina meficgebeso, faka imoc ngereeude. Imocac ngeni singgac hie me ngakpi yohockang me hanitabe me yasu mong mi mekembisia. ");
INSERT INTO ded_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Amma taong me amabangec monnu kenggecde, ngeni imohai ngic mong yegoc tacgecdeac siric ande, ye meficgebisia. Meficgema yegoc tacyac anggec wisickeu faima kembisia. ");
INSERT INTO ded_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ngeni ama imohai emma wenacngerec ruaeyoacgoc debisia. ");
INSERT INTO ded_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ifi degec ama imoc ruae naric meudeac siriha anudeu, ruaengo ama imohai hama feude. Nga ama imoc ye ruaea naric mi meudeac siriha anudeu ruae imocngo ngenanggaru monggoc dzigenengemmeude. ");
INSERT INTO ded_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nga mongngo mi hoangngunuma yoacngina mi negenudeu ngeneng ama me taong imoc wama haninginaunac yube kpegec mau kembisia. ");
INSERT INTO ded_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Foracngoc, kecma ising ising nasotoau taong imocac ngicngac yeneac ebicngo Sodong nga Gomora taong, yereac ebic feraheude, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Negendae, rama yeneng katekasi yeneac botucfu kecdae, ni siriha imocacsoc suengunuduae. Imocac ngeni boidzoc isoc negen negentegecnginagoc kecbisia nga kebesac neng, yeni isoc manganangina kpac kecbisia. ");
INSERT INTO ded_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ngeni ngic yeneac negentegecma kecbisia. Yeni yoacfu faingunugecde nga kpekpeturang amanginau dzikacngo ebiria ngunugecde. ");
INSERT INTO ded_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nga ngicngac yeni neac amma mengunuma kemma gawana nga ngictau yeneac kicfu faingunugecde. Ifi anggec ngeneng yeni nga bangec monnunac ngicngac Anutu mi negendae, ngic imoc momoc siduc gombung dekperagiyemmebisia. ");
INSERT INTO ded_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nga ngicngac yeneac kicfu faingunugec yoacfu nanggecde, imohai ngeni noc yoac degecde me dafi degecde, imocac negengyohoc mong mi ambisia. Kebungo naso imohainoc yoac ngemmeu ngeni imoc debisia. ");
INSERT INTO ded_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ngeni naso imohai ngenaoc yoac mi degecde, kpac. Mangnginaac Asungo yoac enacnginau faiu imoc degecde. ");
INSERT INTO ded_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Imohai dara mongngo munea enara yeneac mariu faiu yeneng ye homecfu faigecde nga manggac mongngo faka imocngoc medahaac anude. Nga nambarac yeneng nonggo mangfocngina deengdema ayemmema homecfu faiyunugecde. ");
INSERT INTO ded_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nga neac kpacac amma ngicngac sasawa yeneng ubango ukungunugecde. Nga ngic mong ye seserigoc kecmanu nasotoa haude, yeng komoc kpeude. ");
INSERT INTO ded_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ngeni taong monnu kecgec ngicngac yeneng ngunukporac angemmegec ngeni taong imoc wama worama monnu kembisia. Foracngoc, ngeni Israe bangecfu taong sasawa fekende, ihai uana mi mesimagec Ngicac Medacngo haude. ");
INSERT INTO ded_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Negen negeng medac mongngo kpoukpouya yeac engena mi anude nga wanacngic mong ye mingina yeac engena mi anude, kpac. ");
INSERT INTO ded_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Negen negeng medac ye kpoukpouyaac siric isoc ambeso nga wanacngic ye minginaac siric isoc ambeso, imocngo naric anude. Nga amaac enara yeac Bedzeburu demigec isoc amafora ngenearu kpac ifia mangana monggoc kpacngunugecde. ");
INSERT INTO ded_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wiac mong sangoyagoc fede, imoc kecma nonongkac fingectegerude nga wiac sufu sufuya fede, imoc negendacgecde. Imocac ngeni yeneac mi kengecngunubeso. ");
INSERT INTO ded_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ni tofocnac nasou yoac edengunuduae, ngeni imoc kperagiau debisia. Nga sangicfu kedzacnginau dedea, ngeni ama witiau namma imoc deyadigec negendacbisia. ");
INSERT INTO ded_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ngicngac yeni sebingina kpehomema ubaongangina naric mi kpehomegecde, ngeni yeneac mi kengecngunubeso. Anutungo sebi nga ubaonga yerahafoc hofeu memanganeude, ngeni yeac ine damungunubeso. ");
INSERT INTO ded_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ngicngac yeni nengbisic yohockang faigec toea mocgu sacsacngo bummeandae. Nga neng yenearunac mongngo bangecfu makpeu Mangnginango imoc bic negenude. ");
INSERT INTO ded_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nga ngeneac orucdzonginaac kpete, imoc ifingoc osoosodara. ");
INSERT INTO ded_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ngeneng nengbisic homac feracyunudae, imocac amma ngeni mi damungunubeso. ");
INSERT INTO ded_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mong ye ngic yeneac kicfu neac deande, ‘Ni yeac areng.’ Neng yeac ifingoc Manna kurumennu kecde, yeac kicfu yofi debade, ‘Ye neac ngic.’ ");
INSERT INTO ded_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nga mong ye ngic yeneac kicfu neac kpacna busickpeu neng Manna kurumennu kecde, yeac kicfu yeac kpac ifingoc busic kpebade. ");
INSERT INTO ded_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Ye bangecfu ruae meficgeudeac maec.’ ngeni neac ifi mi negembisia, kpac. Ni ruae meficgebadeac mi mayai, ni ine yare meficgebadeac mayai. ");
INSERT INTO ded_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‘Medac ye mamagoc tohoemeecde nga naroang ye nonggeagoc tohoemeecde. Nga ngac ye erangiagoc tohoemeecde, ifi fingerudeac mayai. ");
INSERT INTO ded_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ngicngac ngic monggac ameau yombong arengfora kecdae, yenennoc ngabafora anggecde.’ ");
INSERT INTO ded_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ngic mong ye nonggo manghora heresongogoc hoangyuruma neac songo mamea negengande, ye neac areng anudeac siric mi anude. Nga mong ye medaha me naroanga heresongogoc hoanggema neac songo mamea negenude, yeng neac areng kefudeac siric mi anude. ");
INSERT INTO ded_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ngic mong ye mariponga tofohoma ni mi modacnuude, yeng neac areng kefudeac siric mi anude. ");
INSERT INTO ded_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mong ye yengena kekeha meficgema segerede, ye kekeha sufumiude. Nga mong ye neac amma kekeha wade, ye kekeha meficgeude. ");
INSERT INTO ded_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ngic mongngo ngeni heitaingunuude, yeng ni heitainuude. Amma ni heitainuude, yeng Anutu suenuec, ye heitaiude. ");
INSERT INTO ded_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nga ngic mong ye profete mong hemma ngic imoc ye profete kecde, ifi negemma ye heitaiude, yeng profeteac bung meude. Amma mongngo ngic ye dindingac kecdeac amma ngic imoc heitaiude, ye ngicngac dindingac yeneac bung meude. ");
INSERT INTO ded_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mongngo medac kapia mong hemma neac medac andeac negemma doku nomang kpakenecfu kpemiu neudeu yeng kecma bumaac mi obohoude, imoc fora yombong.” ");
INSERT INTO ded_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesungo medacfora 12 dederecge ayemmedaru wisickeu amabangec imoc waec. Wama taonnginau siduc gombung edekpou ayemmeudeac kenec. ");
INSERT INTO ded_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Anu Yohanengo witicamau tacma Kristongo ua meec, siduc imoc negemma medacfora yearu sueyunuu kemma ");
INSERT INTO ded_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kpesimigec, “Ngic hanemmeudeac dedea, imoc ge me neni monggac tomai kecbisina?” ");
INSERT INTO ded_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ifi degec yeng yofi deec, “Ngeni kemma wiac hennegeng andae, imocac siduc Yohane ammibisia. ");
INSERT INTO ded_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ngicngac kicpisic yeni kicfifi andae nga hanimangang yeni sing kengkecdae amma ngicngac kukuseringinagoc yeni sebingina ngereeu kecdae. Kedzacfong yeneng yoac negemma kecdae nga homemea yeneng gborima kecdae amma ngic makpekpea yeneng siduc gombung negengkecdae. ");
INSERT INTO ded_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nga ngic mong ye neac negemma herea mi buude, ye kenehagoc.” ");
INSERT INTO ded_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Anu Yohaneac medacfora yeni kemmagec Yesungo yeac haniaya dekperagima habutoa yofi edeyunuec, “Ngeni bangec kisiu noc wiac henggecdeac kenggec? Komba mong firangngo kpeu kockpac ande, ngeni imoc henggecdeac kenggec me? ");
INSERT INTO ded_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Imoc kpac. Imocac noc wiac hembesonga kenggec? Ngic mong wambaya kibiagoc me? Negenggec, ngic wambangina kibia gombunga heiandae, yeni ngictau yeneac amau kecandae. ");
INSERT INTO ded_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngeni profete mong hembesonga kenggec me? Yennoc profete goa sasawa feracyunude, ifi deduae. ");
INSERT INTO ded_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yeacnoc yofi oho ohoya fede, ‘Negenna, ni enacdedena sueba yeng waraigemma singga mengeregenude.’ ");
INSERT INTO ded_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Foracngoc, ngic ngacfunac fingecgec, yenearunac mongngo Yohane dokunadzic naric mi ferahaec, kpac. Nga kurumeng eucererenggac manau mamea kecde, yeng Yohaneac engena. ");
INSERT INTO ded_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nga Yohane dokunadzicngo uaya hanaheecfunac erekecma yaguc ande, ngicngac yeni kurumenggac eucerereng mebesonga ua serima meandae. ");
INSERT INTO ded_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Profete sasawa nga Moseac dedeseriyoac, imoc yeni kpefingyoac deerekecmagec Yohanearu hasikede. ");
INSERT INTO ded_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nga ngeni yoac yomoc hoanggebeso negengandae isoc yofi deduae, Eriango haudeac degec, imoc yenoc. ");
INSERT INTO ded_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kedzahagoc yeng yoac yomoc negembeso. ");
INSERT INTO ded_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nga areng yofinenggac kecdae, yeni fakangina yofi. Nambarac yeni sobennu tacma ogofocngina yeneac kpacandae, ");
INSERT INTO ded_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Neni kungac fifini ngeni ine yegec mi fededau nga ubahodung yegec heini ngeni mong mi kiacdau.’ ");
INSERT INTO ded_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohanengo hama nenedoku mi neu yeni hemma degec, ‘Ye yafingagoc.’ ");
INSERT INTO ded_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nga Ngicac Medacngo hama nenedoku neu hemma deandae, ‘Henggec, ye nenedoku efea mi nekecde nga ye takesimeme ngic nga manganameme ngic yeneac ogongina.’ Anutuac negen negentegec, imoc gombunga ande, imoc uayango dede.” ");
INSERT INTO ded_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesungo guruama goau faka kuhagoc homac meu ngicngac homacngo hemma ubamereng mi anggecac ye dehou ayemmema yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Koradzing nga Besaida ngicngac, ngeni sowecnginagoc. Ngenearu kucfaka homac bic fingerec, kucfaka ifia Tiro nga Sidong taonnu fingecbac dede ngicngac yeni kopocsicnginaac amma ubamanganggac wamba bic heima hama nadzicma ubamereng ambau. ");
INSERT INTO ded_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ni edengunuba, ising ising nasotoau Anutungo Tiro nga Sidong areng yeneac ubamangang negemma turunga efeanec yemmeude amma ngeni ine turunga ebiriangoc ngemmeude. ");
INSERT INTO ded_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nga Kafanaung taong, geng kurumennu ennadeac ifi negengannec, imoc kpac yombong. Yeni homecac amau megu keme kemeac siric annec. Faka kuhagoc gearu fingerec, imocngo Sodong taonnu fingecbac dede Sodong ye naso yofinenggac febacngoc. ");
INSERT INTO ded_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nga edengunuba negenggec, turung kpoukpou nasou Sodonggac areng yeni turunga efeanec ayemmegecde nga ge ine turunga meebirima anggenggecde.” ");
INSERT INTO ded_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naso imohai Yesungo yofi deec, “Manggac, kurumeng nga bangec mingina, ngicngacareng negen negentegecnginagoc nga fitira andae, geng yeni wiacga sasawa yomoc mesufuyemmenec. Amma nambaracbisic bisic, yeni ine wiac yomoc mekperagiyemmenec, imocac dengereguduae. ");
INSERT INTO ded_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oc Manggac, ge imoc hemma ubaga ngereede. ");
INSERT INTO ded_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mannango wiac sasawa nenu neng imoc mekecduae. Nga ngic mongngo Medac naric mi negemmide, Manggacngosac negemmide. Ifi isocngoc mongngo Manggac naric mi negemmide, Medacngosac ine ye negemmide. Amma Medacngo ngicngac meisingyunuma edzacyunuande, yeneng ifingoc Manggac negemmigecde. ");
INSERT INTO ded_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ngicngac uatoa mema kucmama kecandae nga ebic homac tofohoandae, ngeni nearu hadacgec neng kecnegeng ngemmebade. ");
INSERT INTO ded_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngeni hama tofona miacma tofohoma negen negeng nearunac megec. Ni wosonomang nga memaemema kecduae. Ifi anu ubaonganginango kecnegeng meficgeude. ");
INSERT INTO ded_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Neac tofona imoc yumea nga tofo witiau wiac dzegeanduae imoc efea.” ");
INSERT INTO ded_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naso imohai Yesungo sabata nasou wit uausing kemmanu medacfora yeni herenginaac homema wit fora goa menec anggec. ");
INSERT INTO ded_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ifi anggec farisaio yeneng imoc hemma edegec, “Henna, medacfocga yeni sabata nasou faka mi angana, imoc andae.” ");
INSERT INTO ded_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ifi degec Yesungo yofi edeyunuec, “Dawidi nga uamedacfora yeni herenginaac homema faka anggec, ngeni imoc osonegeng mi angandae gedang. ");
INSERT INTO ded_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ye Anutuac womonnu emma ic sogong Anutuac sese faifaia, imoc mema uamedacfora yenigoc negec. Faka imoc mi angana nga Dawidi yengena nga uamedacfora yeneng imoc anggec. Womong gareng yeneng imoc naric negecde nga ngictehec yeneng imoc mi nebisia. ");
INSERT INTO ded_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Womong gareng yeni ifingoc sabata nasou ua mema sabata tatac faka wama sifu kopocsic mi meficgegecde. Dedeseriyoac mitikibiu fede, ngeni imoc osoma mi negengandae. ");
INSERT INTO ded_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ni yoac yofi edengunuba, wiac yomocngo Anutuac womong ferahade. ");
INSERT INTO ded_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nga yoac yofi oho ohoya fede, ‘Ngeni wosoefac ayemmedae, imocac anende nga sesegerecac ine mi anende.’ Ngeni yoac imoc negentegecbau dede ngeni ngic kopocsiha kpac, ye mangana mi demibau. ");
INSERT INTO ded_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngicac Medac yennoc sabataac Kebu.” ");
INSERT INTO ded_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Anu ye wama imohacnac kemma kpekpeturang amanginau enec. ");
INSERT INTO ded_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Enu ngic mong maria mong homemeango ihaingoc tarec. Taru ngic yeni Yesungo dafi deu negemma yoacfu faigecdeac kpesimigec, “Sabata nasou ngic mengec mengere ua naric mebesonga me kpac?” ");
INSERT INTO ded_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ifi degec yeng yofi edeyunuec, “Ngenearunac mongngo ramaya mong sabata nasou teng monnu kemedac isoc, ye ine bic kemma ramaya taiu ereude. ");
INSERT INTO ded_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nga ngic ngeneng ine wiac engena amma rama feraheyombonggedae. Imocac sabata nasou mengec mengere uaac kpaea mong mi fede.” ");
INSERT INTO ded_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ifi dema ngicac yofi deec, “Ge mariga sinena.” Ifi deu ye maria sineu imohaingoc sorongaima ngereeu maria noboha isoc anec. ");
INSERT INTO ded_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nga farisaio yeni mama kemma adzoroma tacma Yesu kpegecdeac dekiric anggec. ");
INSERT INTO ded_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ifi anggec Yesungo negengyemmema imohacnac wama kenec. Kenu ngicngac homacngo modacgec yeng ngicngac hafeinginagoc sasawa mengereyunuec. ");
INSERT INTO ded_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mengereyunuma ngicngac yeni siduha mi deyadigecdeac goroyoac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Profete Yesaiango kpefinnu yoac bic deec, imoc fora ambeso, ");
INSERT INTO ded_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Negenggec, ni ua ngicna meisinggeai nga heregoc yeac songo negemba ubaonganango yeac sogaide. Nga Asuna yeac witiu faiba yeng neac desi desifaka dindingac bangec monnunac ngicngac, yenearu dekperagiyemmeude. ");
INSERT INTO ded_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Amma ye ngaba mi anude nga ye kucgoc mi arohoude. Ngicngac yeni amasobennu namma yeac yoac udumenga naric mi negenggecde. ");
INSERT INTO ded_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nga yeng komba mong bic manganedac, imoc mi tueude nga kifa mong witiha hosuhagoc, imoc mi mepisickeude. Ifi anu kecma ye desi desi faka dindingac garenggekefu faka imocngo faka mangana feraheude. ");
INSERT INTO ded_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nga bangec monnunac ngicngac Anutu mi negendae, yeneng negen negensingngina yeac kpacfu gbedickegecde.” ");
INSERT INTO ded_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yeni ngic mong hadehadeagoc nga kiwa pisic pisickea amma yoara kpac, ye Yesuaru mema kenggec. Kenggec yeng ngic mengereu yoac dede nga kicfifi anec. ");
INSERT INTO ded_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ifi anu kpebung nandacgec, yeneng imoc hemma kerectegec amma degec, “Ngic imoc ye Dawidiac kisicfunac gedang.” ");
INSERT INTO ded_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ifi degec Farisaio yeneng ine imoc negemma degec, “Hadehade nga yafing kporacde, imoc hadehade nga yafing yeneac ngictau Bedzeburu, yeac kucfu mede.” ");
INSERT INTO ded_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ifi degec Yesungo negen negengnginau negemma yofi deec, “Bangec monggac ngicngac yeni ngaba angemema tohogecdeu bangec imoc kisi fingerude. Nga taong me amaareng mong yenaocngoc ngaba angemegecdeu taong me amaareng imoc naric mi fekefude. ");
INSERT INTO ded_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nga Satang yengenaocngoc kporacemeudeu ye tohou habu yohockang anu yeac amabangeha seria naric mi feude. ");
INSERT INTO ded_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Neng Bedzeburu yeac kucfu hadehade nga yafing kporacyunubai dede ngeneac medacfocngina yeni ifingoc yeac kucfu hadehade nga yafing kporacyunubau. Ifi anu ngeneac medacfocnginango yoacngina isinggema desigecde. ");
INSERT INTO ded_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nga neng Anutuac Asugoc hadehade nga yafing kporacyunuduaeu imohai Anutuac eucererengngo ngenearu bic hadac kecde.” ");
INSERT INTO ded_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ngic mongngo ngic kuhagoc mong yeac amau naric mi enude nga ye iwaiya sasawa naric mi wangerude, kpac. Ye ngic kuhagoc witickemaguc amea manau emma iwaiya tacde, imoc naric wangerude.” ");
INSERT INTO ded_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ifi anu yofi edengunuba negenggec, ngic mong ye mi nanggenude ye ngadenuude. Nga mongngo nigoc mekpedzuc ua mi meude, yeng neac wiac megigi anu sinsararang kpeudeac ua meude. ");
INSERT INTO ded_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Imocac edengunuba negenggec, ngic mong ye kopocsic hania hania meande amma Anutu demanganeande, yeac kopocsic wawaac sing fede. Nga mongngo Asu demanganeude, yeac kopocsic wawaac sing ine mi fede, kpac. ");
INSERT INTO ded_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Anu ngic mong ye Ngicac Medac emmima yoac deude, yeac kopocsic wawaya fede. Nga mong ye Tiri Asu emmima yoac deude, yeac kopocsic wawaac sing mong mi fede, kpac. Imoc naso yofinenggac kecdimbe me naso ngade haude, imohai ifi fekeng kecbesande.” ");
INSERT INTO ded_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ic mong gombunga degec, imohai fora gombunga fingerude nga ic mangana degec, imohai fora mangana fingerude. Forango icac siriha edzacnunuude. ");
INSERT INTO ded_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ngeni boidzocac fingecsaheunac. Nga wiac ubaherenginau wakema fede, imocnoc enacnginango dekperagiude. Ngeni ngic manganango yoac gombunga degecdeacsoc mi ande. ");
INSERT INTO ded_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ngic gombungango ye tohonga gombunga femide, imohacnac wiac gombunga meu maande. Nga ngic manganango tohonga manganaunac wiac mangana meu maande. ");
INSERT INTO ded_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Neng yofi edengunuba, ngeni yoacngina sicsauha sasawa deandae, yoac imoc ising ising nasou isinggema foraya degecde. ");
INSERT INTO ded_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yoacgaac siricfu yoacga gombunga desigecde nga yoacgaac siricfu desima mangana degenggecde.” ");
INSERT INTO ded_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ifi deu mitiac negen negengngic nga farisaio goa yeneng degec, “Kpoukpou, ge faka kuhagoc mong edzacnununadeac anemmede.” ");
INSERT INTO ded_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ifi degec yeng ine yofi edeyunuec, “Naso yomocac ngicngac ngeni mangana nga seroareng amma kucfaka mong henggecdeac kpesiandae. Nga ngeni ine faka kuhagoc mong mi ngemmengemmea, kpac. Profete Yona, yearu kucfaka fingerec, ngeni imocsac henggecde. ");
INSERT INTO ded_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona ye hadzing nga tofocnac harebec kondungyangtoaac heremanau feec, ifi isocngoc Ngicac Medacngo bangecac heremanau hadzing nga tofocnac harebec feude, ngeni imocsac henggecde. ");
INSERT INTO ded_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Anu Niniwe taongtoaac ngic yeni Yonaac dedekperagiyoac negemma ubamereng anggec. Imocac ngicngac yomoc ngeneng ising ising nasou Niniwe ngicngac yenigoc yacma nammagec fakangina isinggema ngeneac mangana dengemmegecde. Anu negenggec, yomocngo Yonaac faka ferahade. ");
INSERT INTO ded_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nga Seba bangecac ngactaungo Saromoac negen negentegec meudeac bangec tegiau sautfunac haec. Yeng ising ising nasou ngicngac yomoc ngenigoc yacma nammagec fakangina isinggema ngeneac mangana dengemmeude. Anu negenggec, yomocngo Saromo ferahede. ");
INSERT INTO ded_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Asu seuhagoc ye ngicfunac erema bangec dokuya kpac, ihai kemma tacnegenudeac tatac hofocma yerecgema kecande. Kecma tatac mong mi meficgema ");
INSERT INTO ded_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yengenaocngoc yofi deude, ‘Amana warac tacma wayai, imohai monggoc dzigenema kembadeac negenduae.’ Ifi dema kemma ama imoc henude. Nga imoc bic wangge wanggea nga mengec mengerea amma mingina kpac eng tacde. Taru asu seuhagocngo imoc hemma ");
INSERT INTO ded_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","monggoc kemma arengfora 7 wangecyunuu hagecde. Arengfora imoc yeneng ye ferahema mangana yombong andae, yeni meyunuma kemma ama imohai enarangina anu kecgecde. Ifi anu ngic ye warac mangana kefec, ye imoc ferahema imocac mangana yombong kefude. Nga ngicngac yofinenggac mangana andae, ngenearu faka ifiangoc fingerude.” ");
INSERT INTO ded_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesungo ngicngac yoac edeyunumanu nonggo munafora yeneng hama ngadeau namma yegoc yoac denegeng anggecdeac degec enec. ");
INSERT INTO ded_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Enu ngic mongngo imoc negemma edeec, “Nonggo munafocga yeni gegoc yoac yoac anggecdeac ngadeau nandae.” ");
INSERT INTO ded_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ifi deu Yesungo ye edeec, “Damoc yeneng neac nonggo munafocna?” ");
INSERT INTO ded_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ifi dema medacfora nanggec, yenearu maria sinema yofi deec, “Ngicngac yomoc yeneng nonggo munafocna. ");
INSERT INTO ded_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Imoc yofiac, ngicngac Manna kurumennu kecde, yeac songo nga negen negeng modacma uaya meandae, yenennoc neac nonggonaing nga dacmunafocna.” ");
INSERT INTO ded_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Uameme imohaingoc Yesungo amaunac mama dzohong tegiau kemma tarec. ");
INSERT INTO ded_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tacmanu habutoa kunengngo yombong yearu kenggec ye gombau emma tacmanu ngicngac habutoango dzohong tegiau nanggec. ");
INSERT INTO ded_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nanggec yeng yoac heima yoac homac edeyunuma yofi deec, “Gbome kpegi kpegingic mongngo gbome kpegiudeac uau kenec. ");
INSERT INTO ded_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kemma gbome kpegiu gbome goango mama sinnu heiu neng yeneng hama nedacgec. ");
INSERT INTO ded_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nga goango harongannu heiu ihai bangec efeanec feecac imoc bic nemonggema ereec. ");
INSERT INTO ded_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amma gbome godea homac mi faiecac wenacngo erema kpeu ururuema homeec. ");
INSERT INTO ded_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nga goango haseng manau heima nemonggeu hasengngo yadima gbome heihomeec. ");
INSERT INTO ded_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nga gbome goango bangec gombungau heima fora fingerec. Imohanac goau 100 fingerec nga goau 60 amma goau 30 fingerec. ");
INSERT INTO ded_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kedzahagoc yeng yoac yomoc negembeso.” ");
INSERT INTO ded_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anu medac yeneng yearu kemma kpesimigec, “Ge dafiac yoac heima edeyunuannec?” ");
INSERT INTO ded_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ifi kpesimigec Yesungo yofi merengyemmeec, “Kurumeng eucererenggac negen negeng sufu sufuya, imoc ngeneng negenggecdeac ngemmengemmea. Nga imoc ine yeni mi yemmeyemmea. ");
INSERT INTO ded_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngic mong wiac goa femide, ye wiac homac monggoc migec mekefude. Nga mong ye wiac mong mi mekecde, yearunac wiacbisic mekecde, imoc ifingoc wangecgecde. ");
INSERT INTO ded_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ngicngac yeni kic fima mi hendae nga kedzac kpema sifu wiac mong mi negentegecgecde. Imocac amma yoac heima edeyunuanduae. ");
INSERT INTO ded_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nga profete Yesaiango yoac deec, imoc yenearu fora fingecde, ‘Ngicngac kedzacngo negen negeng, yeni imoc negemma naric mi negentegecgecde. Amma kicngo heheng yeni imoc hemma naric mi hentegecgecde. ");
INSERT INTO ded_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ngicngacareng yomoc yeni herengina tondzera nga kedzacnginango yoac negenggecdeac ebiridae amma kicnginango wiac henggecdeac mepisickegec. Yeni kicnginango wiac mong hembauac nga kedzacnginango negembauac amma negen negengnginango wiac mong negentegecbauac, imoc yeni ubangina dafiu dzigeneu mengereyunubade.’ ");
INSERT INTO ded_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nga ngicngac kicpisic nga kedzacfong kpac, ngeneac kickedzacngina kenehagoc. ");
INSERT INTO ded_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Foracngoc, profete nga ngic fakangina dindingac homacngo warac kecgec, yeni wiac ngeni hengandae, imoc hembeso songo negemma sifu mi henggec. Nga ngeni wiac kedzacnginango negengandae, yeni imoc kedzacngo negembeso ayemmeu ifingoc mi negenggec.” ");
INSERT INTO ded_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Imocac ngic gbome kpegiec, imocac yoac heiheiac hania deba ngeni negenggec. ");
INSERT INTO ded_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ngic mongngo eucererenggac yoac kedzahango negemma mi negentegeru mangana minginango hama gbome hereau homec homera, imoc bic meickeude. Imoc wit gbomea sinnu heiec, siriha imocacsoc ande. ");
INSERT INTO ded_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nga gbomea harongannu heiec, imoc ngic mongngo eucererenggac yoac negemma songogoc bic hoanggeude, ye isoc. ");
INSERT INTO ded_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Hoanggeu imocngo ubeau godo mi mema naso wegenanecsac feude. Nga Anutuac yoacac amma kpendzeng me yunukporacfaka yearu fingeru ye makpeude. ");
INSERT INTO ded_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nga gbomea hasennu heiec, imoc ngic mong ye eucererenggac yoac negemma kefude, ye isoc. Ye yoac negenu kekecac negengyohoc nga dzofinacac faitobangfaka imocngo yadima yoac imoc heihomeu fora mong mi fingerude. ");
INSERT INTO ded_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nga gbomea bangec kerehagocfu heiec, imoc ngic mong ye eucererenggac yoac negemma negentegerude, ye isoc. Ngic ifia yearunac goango fora 100 nga goango 60 amma goango 30, ifi fingerude.” ");
INSERT INTO ded_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesungo yoac mong heima yofi edeyunuec, “Kurumenggac eucerereng imoc ngic mongngo uayau kemma witgbomea gombunga kpegiec, siriha imocacsoc ande. ");
INSERT INTO ded_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngic ye kpegima kenu amaareng yeni tofocnac gau fedacmagec ngabango ine hama kpindzing mangana ifingoc wit botuhau kpegima kenec. ");
INSERT INTO ded_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nga wit imoc nemonggema erema fora fingecmanu kpindzing manganango ifingoc nesarima ereec. ");
INSERT INTO ded_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ifi anu wanacngic yeneng hama mingingngina edegec, ‘Kunennina, ge uau gbome gombunga kpeginec anu kpindzing mangana imoc ine damohacnac erede?’ ");
INSERT INTO ded_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ifi degec yofi edeyunuec, ‘Ngabangic mongngo imoc andac.’ Ifi deu degec, ‘Neni kemma kpindzing mangana imoc taima ukunide, ge ifi negennec, me?’ ");
INSERT INTO ded_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ifi degec yeng yofi edeyunuec, ‘Kpac, ngeni kpindzing taidimbe dema wit ifingoc taibauac amma wagec.’ ");
INSERT INTO ded_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wit nga kpindzing yerahafocngoc yadimaec kpememe naso hau kpememengic yofi edeyunubade, ‘Ngeni hanahema kpindzing taima dedeckema gerecfu ukugec dzebeso. Nga wit ine mekpedzuc amma semengamanau faigec tacbeso.’” ");
INSERT INTO ded_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesungo yoac mong heima yofi edeyunuec, “Kurumenggac eucerereng imoc mastet gbomea isoc, ngic mongngo imoc mekemma uayau homerec. ");
INSERT INTO ded_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet gbomea, imoc gbome sasawa yeneac kapiangina. Amma ye yadima semeng uaac mondzang feracyunuma ic wegena anu sawau neng yeneng hama fawau faec heiandae.” ");
INSERT INTO ded_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Anu Yesungo yoac mong heima yofi edeyunuec, “Kurumenggac eucerereng imoc yis isoc. Ngac mongngo farawa 20 kg mema uuha yisgoc yerecgema meu hafoangoc yisagoc anude.” ");
INSERT INTO ded_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesungo yoac deec, imoc yoacfu sasawa heima ngicngac habutoa edeyunukefec, ye eng mong mi edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Profete mongngo yoac yofi deec, “Ni yoac heima deba, imoc enacnaunac maudeac ande nga wiac warac kundunnu sufu sufuya feec nga wiac ngade fingecbesande, imocac yoac debade.” Yoac imoc fora fingerudeac Yesungo yoac heimasac yoac edeyunukefec. ");
INSERT INTO ded_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Anu ye habutoa faiyunuma amau enu medacfora yeneng yearu emma degec, “Ge yoac heima kpindzing mangana uau erede dedang, imocac hania dekperaginemmena negenni.” ");
INSERT INTO ded_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ifi degec yeng yofi merengyemmeec, “Ngicac Medacngo gbome gombunga kpegima kecde. ");
INSERT INTO ded_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Semeng uaya imoc bangectoa bangec amma gbomea gombunga imoc eucererenggac nambaracfora. Nga kpindzing mangana imocngo mangana minginaac nambaracfora. ");
INSERT INTO ded_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nga ngabangicngo gbome uau kpegiec, imoc mangana mingina. Nga fora kpememe naso, imoc naso wisic wisickea, imocac nasotoa. Uangic imoc angero. ");
INSERT INTO ded_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yeneng kpindzing mangana taima gerecfu ukugec dzeude, nasotoau ifi isoc fingerude. ");
INSERT INTO ded_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Imohai Ngicac Medacngo angerofora sueyunuu yeneng yeac amabangehaunac wiac kopocsic meficgeande amma ngicngac kopocsic mekecdae, imoc sasawa kpezucyunudacma ");
INSERT INTO ded_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","gerecyadau ukuyunuu kemegecde. Ihai ngicngac kiacma enacngina kisaranggema kecgecde. ");
INSERT INTO ded_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nga ngicngac kpetiac yeni Mangnginaac eucererennu wenackiwa isoc kperagima kecgecde. Kedzahagoc yeng yoac yomoc negembeso.” ");
INSERT INTO ded_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesungo monggoc yofi deec, “Kurumenggac eucerereng imoc ngic yeneng dzofinac ua monnu sufugec, ifi isoc. Ngic mongngo ihai kemma imoc meficgema monggoc mesufuec. Mesufuma ubangerec kuneng negemma kemma wiara sasawa suema dzo mema kemma ua imoc bummeec. ");
INSERT INTO ded_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Anu monggoc yofi, kurumenggac eucerereng imoc kubu gombunga buma kuneng kubu faifaingic mongngo hofocma kefec, ifi isoc. ");
INSERT INTO ded_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hofoc kecma kubu mong buma kuneng yombong meficgeec. Meficgema kemma iwaiya sasawa sueu dzo kirecgeec. Kirecgeu hama imocngo kubu imoc bummeec. ");
INSERT INTO ded_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ni monggoc deba negenggec, kurumenggac eucerereng imoc ufic mong isoc. Ngic yeni ufic dzohonnu ukugec kemema kondung yang hania hania meande. ");
INSERT INTO ded_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ukugec dzohonggac yangngo uficfu wakeu tegiau kpedzigec ereec. Ereu ngic yeni kondungyang nenea isinggema otou faigec nga mi nenea, imoc ukugec. ");
INSERT INTO ded_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Naso wisic wisickea imohai faka ifi isoc fingerude. Angero yeneng kemma ngicngac manganameme areng kecdae, yeni ngicngac dindingac yeneac botucfunac meicyunuma ");
INSERT INTO ded_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","gerectoau ukuyunugec kemegecde. Kemema yeni ihai kiacma enacngina kisaranggema kecgecde.” ");
INSERT INTO ded_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesungo ifi dema kpesiyemmeec, “Ngeni yoac imoc sasawa negentegecdae me?” Ifi deu degec, “Oc.” ");
INSERT INTO ded_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ifi degec yofi edeyunuec, “Imocac mitiac negen negengngic kurumeng eucererenggac negen negeng mema kecandae, yeninoc ama monggac mingina, ye isoc andae. Yeng tohongaunac wiac esea nga gboria memaude.” ");
INSERT INTO ded_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesungo yoac heima imoc dedacma amabangec imoc wama ");
INSERT INTO ded_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yengena amabangehau kenec. Kemma kpekpeturang amanginau emma edekpou ayemmeu ngicngac yeneng imoc negemma kpidohoma degec, “Ngic yomoc ye negen negentegec nga kucfaka imoc dahacnac mema mekecde? ");
INSERT INTO ded_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ye amamemengic yeac medacnoc. Nga nonggea kpara Maria amma ye Yakobo nga Yosec nga Simong amma Yuda yeneac dacngina. ");
INSERT INTO ded_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nga naingfora sasawa yeni nenanggoc kecdae. Yeng negen negeng imoc dahacnac meec?” ");
INSERT INTO ded_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yeni ifi dema Yesuac yoac nga uayaac dehesi amma wagec. Ifi anggec Yesungo edeyunuec, “Profete yeni yenang amanginau nga amabangecnginau, imohaisac kpacngina kpac kecdae.” ");
INSERT INTO ded_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Anu ngicngac yeni mi negensinggegecac amma yeng imohai kucfaka efeanecsac meec. ");
INSERT INTO ded_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naso imohai Yesuac siducngo gawanatoa Herode yeac kedzacfu kemeu ");
INSERT INTO ded_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yeng negemma uamedacfora edeyunuec, “Imoc Yohane dokunadzic. Ye homecfunac gborima yarecac amma faka kuhagoc meudeac kuc femide.” ");
INSERT INTO ded_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Imoc yofiac, Herodengo warac munea Firipoac enema Herodia hamangec meec. Meu Yohanengo yofi edeec, “Ge ngac imoc mema yegoc kecnade, imoc singngo mi dede.” Ifi deecac Herodengo Yohane mema hanimaria kpema witicamau faima ");
INSERT INTO ded_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","kpehomebeso negensiec. Nga ngicngac yeneng ye profete, ifi negenggecac amma kengec anec. ");
INSERT INTO ded_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anu Herodeac fingec fingecnaso hau yeni adzoroma tacmagec Herodiaac naroangngo yeneac botucfu yegec fedeu Herodengo hensongo ammima ");
INSERT INTO ded_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","naroangngo wiac monggac ammiu imoc naric miudeac nemuya monggac kpacfu deseriec. ");
INSERT INTO ded_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Deseriu naroang ye nonggeango negen negeng miu Herode edeec, “Ge Yohane dokunadzicac oruha terau faima mehama nenna.” ");
INSERT INTO ded_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ifi deu negemma ngictau ye ubaebic meec. Amma ye ine dedeseriyoac ngicngac tacgec yeneac kicfu deec, imoc negensima naroangngo deec, imoc migecdeac deserima ");
INSERT INTO ded_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","wasaingic sueu Yohane witicamau tarec, ye ubea herecgebesonga kenec. ");
INSERT INTO ded_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kemma Yohaneac ubea kperecgema hatea terau faima mehama naroang miu nonggeaaru mekenec. ");
INSERT INTO ded_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Anu Yohane medacfora yeni kemma farenga mehama tonggoma kemma Yesu siduc imoc ammigec. ");
INSERT INTO ded_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ammagec Yesungo siduc imoc negemma amabangec imoc wama gombau emma medacfora yenigoc amabangec mong ngiha kpacfu, ihai ye tembuha tarudeac kenggec. Ammanu ngicngac habutoa yeneng imoc bic negemma taongngina wama hanising ye modacma kenggec. ");
INSERT INTO ded_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kenggec Yesungo gombaunac mama ngicngac habutoa ifi yenemma ubea manganeu ngicngac hafeinginagoc mengereyunuec. ");
INSERT INTO ded_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mengereyunuma kecmanu ama marai anu medacfora yeneng yearu hama degec, “Bangec yomoc ngiha kpac anu naso bic kendacdeac ngicngac habutoa sueyununa amabangec goau kenggec. Yeni kemma yenaoc yaka bummenec anggec.” ");
INSERT INTO ded_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ifi degec yeng yofi edeyunuec, “Yeni kenggecdeacsoc mi ande, ngeni ngenaoc yaka gumecyunugec.” ");
INSERT INTO ded_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ifi deu degec, “Neni ic sogong marimong nga kondungyang yohockang yoc mekecdimbe.” ");
INSERT INTO ded_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ifi degec yeng yofi deec, “Ngeni yaka imoc nearu mehagec.” ");
INSERT INTO ded_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yesungo ifi dema ngicngac habutoa kpindzinnu matacgecdeac edeyunuec. Edeyunuma ic sogong marimong nga kondungyang yohockang, imoc mema kiwa fiu kurumennu enu yaka keneheec. Kenehema ic sogong imoc tuema medacfora yemmeu yeneng imoc mema ngicngac habutoa yemmegec negec. ");
INSERT INTO ded_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nga yeni sasawango negebec amma yaka tosea neti anggec tarec, imoc kpedzucnegec kemema sakac 12 wakeec. ");
INSERT INTO ded_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ngicngac yaka negec, ngic yeneac kpete imoc 5 tauseng isoc. Nga ngacnambarac yeneac kpetengina imoc mong mi megec. ");
INSERT INTO ded_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesungo medacfora sueyunuu yeni gombau emma dzohong nobocgeng waraigecdeac kenggec. Kemmagec ye yengenaoc kecma ngicngac habutoa faiyunuu ");
INSERT INTO ded_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","kendacgec. Kendacgec ye numuudeac tikiu enu ama toforeu tembuha tarec. ");
INSERT INTO ded_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Taru gombango dzohong dzongiau kensikemanu firangngo kenggecfusing hama siri kpema gomba mekemmeha anec. ");
INSERT INTO ded_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ifi anu ama wereckembesonga ammanu Yesungo dzohong witiau titi medacfora yenearu kenec. ");
INSERT INTO ded_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ye dzohong witiau titikenu medacfora yeneng hemma yofi degec, “Wosongango hade.” Ifi dema kengec amma arohogec. ");
INSERT INTO ded_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Arohogec Yesungo negemma imohaingoc yofi edeyunuec, “Ngeni wosongina makiu, imoc ni, ngeni mi kengecngunuu.” ");
INSERT INTO ded_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ifi deu Petorongo meremma deec, “Kebu, ge geanggaoc hanec isoc, ni doku witiau tima tima gearu habadeac edenuna.” ");
INSERT INTO ded_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ifi deu Yesungo deec, “Ge hana.” Ifi deu Petoro ye gombaunac mama doku witiau tima Yesuaru kenec. ");
INSERT INTO ded_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kemmanu firangtoa kpeu hemma kengec amma ine dokuu kemema kpacma deec, “Kebu, ge meficnuna.” ");
INSERT INTO ded_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ifi deu Yesungo maria bic sinema Petoroac mari mema miacma yofi edeec, “Ngic negen negensingga kapia, ge nocac negengyohoc andang?” ");
INSERT INTO ded_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ifi deu gombau emmaec imohaingoc firang kpac anec. ");
INSERT INTO ded_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Anu gombau tacgec, yeneng Yesu dengerema yofi degec, “Foracngoc, ge Anutuac Medac.” ");
INSERT INTO ded_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Anu yeni dzohong ferecgema Genesarete bangecfu kensikegec. ");
INSERT INTO ded_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kensikemagec bangec imocac ngic yeneng Yesu bic hensima yoac imoc faigec bangec imohai yerecgeu yeni ngicngac hafeinginagoc yearu meyunudacma hagec. ");
INSERT INTO ded_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hama hafeinginagoc yeni ngakpia susiaac witihasac kpeseregecdeac derecgegec. Amma kpeseregec, yeni sasawango ngereedacgec. ");
INSERT INTO ded_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mitiac negen negengngic nga farisaio yeneng Yerusarennac Yesuaru hama degec, ");
INSERT INTO ded_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Medacfocga yeni nocac bangecfocnina nga esangabofocnina yeneac singyoac kpema maringina mi dzuacma yaka menec angandae?” ");
INSERT INTO ded_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ifi degec yeng yofi deec, “Ngeni nocac Anutuac dedeseriyoac kpema ngenang singyoac waraima modacandae.” ");
INSERT INTO ded_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anutungo yofi dede, “Ge nonggo manghocga seseheyurubesena.” Nga “Ngic mong nonggea me mamaac sowecyoac deude, ye homebeso.” ");
INSERT INTO ded_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngeni ine yofi deandae, “Mongngo nonggea me mama edema yofi deude, ‘Neng wiac goa gemma nanggegubai dede imoc bic Anutuac sese dedua.’ ");
INSERT INTO ded_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ye ifi dema nonggo manghora mi seseheyuruude. Ifi amma ngeni singyoacngina kpabanggema Anutuac yoac semegecde. ");
INSERT INTO ded_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ikocngic, ngeneacnoc profete Yesaiango kpefing dema fora yombong yofi deec, ");
INSERT INTO ded_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ngichabu yomoc yeni enacbibicngo sesehenuandae nga herenginango ine neac hereau kecdae. ");
INSERT INTO ded_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nga yeni kpoukpou ngicngac kpouyemmeandae imoc ngicac singyoacsac edekpou ayemmeandae amma eng dengerenugec hemba fora kpac angkecde.’” ");
INSERT INTO ded_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Anu Yesungo ngicngac kpacyunuu hagec yoac yofi dema edeyunuec, “Ngeni kedzac kpema negentegecbisia. ");
INSERT INTO ded_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Enacfusing wiac kemede, imocngo ngic ubahere mi heidzadzu kpeude. Nga wiac hereninaunac nga enacfu ereande, imocngo ine ngic ubahere heidzadzu kpeude.” ");
INSERT INTO ded_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Anu medacfora yeneng yearu hama edegec, “Farisaio yeneng yoac imoc negemma negemmangang meficgegec, ge imoc negennec me?” ");
INSERT INTO ded_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ifi kpesimigec yeng yofi deec, “Kurumeng Mannango iwai mong mi homerec, imoc godeagoc kpedzigecde. ");
INSERT INTO ded_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ngeni imocac wayunugec. Yeni yenaoc kicpisic amma kicpisic yeneac enara kecdae. Amma kicpisic mongngo kicpisic ogea wangerudeu, yeri yerahafoc tennu kemeyuruude.” ");
INSERT INTO ded_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Deu Petorongo kpesimiec, “Yoac heidang, imocac hania dena negenni.” ");
INSERT INTO ded_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ifi deu yeng yofi edeyunuec, “Ngeni negen negentegecngina kpac isoc kecdaengoc. ");
INSERT INTO ded_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wiac enacfusing kemeande, imoc sasawango herenginau kemema isinggeu keractennu kemeude. Ngeni imoc mi negentegecdae me? ");
INSERT INTO ded_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nga wiac enacfusing ereande, imocngo ine ubahereunac erema ngic ubahere heidzadzu kpeude. ");
INSERT INTO ded_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ubahereunac wiac yofia ereande, negen negeng magana nga ewekpekpe amma kaisero faka nga eweeneng mewa amma hamangec faka nga ikoc yoacfu faifaiyunu amma desureyoac. ");
INSERT INTO ded_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Faka imocngo ngic ubahere heidzadzu kpeude. Nga ngeni maringina mi dzuacma yaka eng negecde, faka imocngo ine ngic ubahere naric mi heidzadzu kpeude.” ");
INSERT INTO ded_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesungo Genesarete bangec wama Tiro nga Sidong bangec, imohai kenec. ");
INSERT INTO ded_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kemmanu imohacnac Kanaang yeneac arennunac ngac mongngo hama Yesu kpacsambic ammima deec, “Kebu, Dawidiac bangeha, ge neac ubaga manganeu, hadehadengo naroanna memanganeande.” ");
INSERT INTO ded_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Deu Yesungo yoac turunga mong mi merenu medacfora yeneng hama igockema degec, “Ngac ye ngadeninau homac kpacdeac suena kenu.” ");
INSERT INTO ded_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ifi degec, yeng yoac yofi merenec, “Ni Israe amaarenggac rama sufu sufuya kecdae, yeneac amma mayai.” ");
INSERT INTO ded_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Anu ngacngo ine hama Yesuac fafoc heimima deec, “Kebu, ge meficnuna.” ");
INSERT INTO ded_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ifi deu yofi edeec, “Nambarac yeneac yaka wangecyunuma kasi yenearu ukuyemmeyemme, imoc faka gombunga mi ande.” ");
INSERT INTO ded_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ifi deu ngac ye serima deec, “Kunenna, imoc naric denec. Nga kasi yeni ine mingingfocnginango yaka kisisickegec tebo bageau mau imocsac neandae.” ");
INSERT INTO ded_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ifi deu Yesungo meremma ngac yofi edeec, “Ngac, negen negensingga imoc engena yombong. Negen negenggau negendang, ifi fingecgende.” Ifi demanu naso imohaingoc naroanga ngereec. ");
INSERT INTO ded_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Anu Yesungo amabangec, imoc wama Gariraia dzohong tegiau kemma tikiu emma ihai tarec. ");
INSERT INTO ded_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tacmanu ngicngac habutoa kuneng yombong hama ngicngac hanimangang nga puring amma kicpisic nga yoacngina kpac amma ngicngac homac ifia meyunuma hagec. Hama Yesuac hoannu faiyunugec yeng mengereyunuec. ");
INSERT INTO ded_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mengereyunuu ngicngac yoacngina kpac, yeni yoac degec nga puring yeni ngereegec amma hanimangang yeni sing tigec nga kicpisic yeni kic figec. Ifi anggec ngicngac yeneng imoc hemma kerectegec amma Israeac Anutu dengeregec. ");
INSERT INTO ded_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Anu Yesungo medacfora kpacyunuu hagec yofi edeyunuec, “Ngicngac habutoa yomoc yeni yakangina kpac uameme harebec bic nigoc kecdauac yeneac ubana manganede. Yeni sinnu kemma kicgigi ayemmebacac herenginaac homemagec naric mi sueyunubade.” ");
INSERT INTO ded_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ifi deu medacfora yeneng meremmigec, “Nenang yei bangec kisiu kecma yaka dahacnac meni ngicngac habutoa kuneng yomocac kpetenginasoc anude?” ");
INSERT INTO ded_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ifi degec Yesungo yofi kpesiyemmeec, “Ngeni ic sogong dafiguc mekecdae?” Kpesiyemmeu degec, “Ic sogong seweng nga kondungyangbisic bisic goa.” ");
INSERT INTO ded_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Degec Yesungo ngicngac habutoa bangecfu matacgecdeac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Edeyunuu tacgec, yeng ic sogong nga kondungyang mema ubangerec dema tuema medacfora yemmeu yeneng mederema ngicngac habutoa yemmegec negec. ");
INSERT INTO ded_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yeni sokoma nema negebec andacgec yaka tosea neti anggec tarec, imoc kpedzucnegec kemema sakac 7 wakeec. ");
INSERT INTO ded_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nga yaka negec, ngic imoc yeneac kpetengina 4 tauseng nga ngac nambarac yeneac kpete imoc mi memea. ");
INSERT INTO ded_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesungo ngicngac habutoa sueyunu kengha anggec ye gombau emma Magadang bangecfu kenec. ");
INSERT INTO ded_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisaio nga sadukaio yeni Yesuaru kemma yeac kuha isinggegecdeac negenggec. Ifi negemma ye faka furia mong kurumennunac meu fingeru edzacyunuudeac kpesimigec. ");
INSERT INTO ded_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kpesimigec Yesungo meremma yofi edeyunuec, “Ama marai anu ngeni deandae, ‘Amabangec sacsac andeac wereckenu naso gombunga anude.’ ");
INSERT INTO ded_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nga asoac yacma deandae, ‘Amabangec sacsac amma kundung kpedeac kiafirang kpeude.’ Ngeni sawau faka fingecande, imoc gombunganoc isinggeandae nga nasoac soi fingecande ngeni imoc ifingoc isinggegec ngereebac. ");
INSERT INTO ded_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ngicngac areng yomoc ngeni manganameme nga seroareng amma ngeni kucfaka mong henggecdeac kpesiandae. Imocac ngeni faka kuhagoc mong mi ngemmengemmea. Yonaaru kucfaka fingerec, ngeni faka imocfiasac henggecde.” Ifi dema wayunuma kenec. ");
INSERT INTO ded_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesuac medacfora yeni yegoc dzohong noboc kenggec. Kembeso ic sogong nigecyunuu engsac kenggec. ");
INSERT INTO ded_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kensikema Yesungo yofi edeyunuec, “Ngeni farisaio nga sadukaio yeneac yis henghomema kecbisia.” ");
INSERT INTO ded_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Deu medac yeni yenaocngoc denegeng amma degec, “Nenang ic sogong mi mema hading, imocacnoc ifi dede.” ");
INSERT INTO ded_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ifi degec yeng bic negengyemmema deec, “Ngeni ngic negen negensingngina kapianec, ngeni ngenaocngoc ic sogong mi mehadauac denegeng andae, yoac imoc wagec. ");
INSERT INTO ded_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ngeni negen negentegecngina kpac. Ic sogong 5ngo ngic 5 tauseng sokoyunudaru sakac dafiguc mewakegec, imoc mi nigecngunubeso. ");
INSERT INTO ded_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amma ic sogong 7ngo ngic 4 tauseng sokoyunudaru sakac imoc dafiguc mewakegec, imoc ifingoc negensibisia. ");
INSERT INTO ded_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ni ic sogonggac mi dedua. Ngeni farisaio nga sadukaio yeneac yis, imocac henghomema kecgecdeac dedua nga ngeni imoc mi negentegecdau.” ");
INSERT INTO ded_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ifi edeyunuma yeni ic sogonggac yis garengeme kecgecdeac mi deec, imoc negentegecgec. Yeni farisaio nga sadukaio yeneac kpoukpouyoac, imocac garengemema kecgecdeac ine deec. ");
INSERT INTO ded_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesungo Firipi bangecac Kaisarea taong mewegenema medacfora yofi kpesiyemmeec, “Ngicngac yeni Ngicac Medac yeac merac deandae?” ");
INSERT INTO ded_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ifi deu degec, “Ngic goango Yohane dokunadzic deandae nga goango Eria amma goa yeneng ine Yeremia me profete mong deandae.” ");
INSERT INTO ded_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ifi degec yofi deec, “Nga ngeni ngenaoc ine neac merac deandae?” ");
INSERT INTO ded_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kpesiyemmeu Simong Petorongo deec, “Ge Messia, Anutu kekehagoc yeac Medac.” ");
INSERT INTO ded_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ifi deu Yesungo yofi edeec, “Simong, Yonaac medac, yoac imoc ngic dedeunac mi dedang, imocac ge kenecgagoc. Manna kurumennu kecde, yennoc imoc mekperagima edeguu dedang. ");
INSERT INTO ded_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Neng ifingoc edeguba negenna, ge Petoro, anu hoc yomocac witiau kpebungtoana faibade. Nga imocngo serima nanu homec amaac nagungo naric mi hepatanggeude. ");
INSERT INTO ded_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ni kurumeng eucererenggac ki gemba geng bangecfu iwai sasawa dzegenade, imoc kurumennu ifingoc dzege dzegea fingerude. Nga ge wiac bangecfu yungecdacnade, imocngo kurumennu ifingoc yungec yungec fingerude.” ");
INSERT INTO ded_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ifi dema medacfora yeneng Yesu ye Messia, imoc ngic mong mi edeyunugecdeac deracyunuec. ");
INSERT INTO ded_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Naso imohai hanahema Yesungo medacfora yofi edeyunuec, “Ni Yerusarennu kemba yudangic enarafocngina nga womong gareng enara amma mitiac negen negengngic yeneng kpendzengtoau fainuma nuhomegecde. Anu uameme harebec ammanu monggoc gborima yacbesare.” Faka imoc fingerudeac deec. ");
INSERT INTO ded_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ifi edeyunuu Petorongo Yesu ngadeau wangec kemma tembucfu namma dekpetari ammima deec, “Anutungo meficgumanu faka imocngo gearu naric mi fingecgembeso.” ");
INSERT INTO ded_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ifi deu Yesungo dzigenema Petoro yofi edeec, “Satang, ngadenau hakenna, ni memanunadeac negennec. Ge wiac negennec, imoc Anutuarunac kpac, imocngo ine ngicac negen negeng ande.” ");
INSERT INTO ded_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ifi dema medacfora yofi edeyunuec, “Mong ye ni modacnubeso negendeu ye yengena ubasebiaac songo memama mariponga miacma tofohoma modacnubeso. ");
INSERT INTO ded_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ngic mong ye kekeha segereudeac negemma uaya mekecde, ye kekeha sufumiude. Nga mong ye neac amma kekeha waude, ye kekeha fingecmiude. ");
INSERT INTO ded_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Imocac amma ngic mong ye bangectoa bangec yomocac finac sasawa meficgema yengena kekeha ukuu sufuude, wiac imocngo memefihagoc naric mi anude. Amma mong ye kekeha monggoc meudeac negenside, ye imoc bummemeac osiude. ");
INSERT INTO ded_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nga Ngicac Medacngo Mamaarunac kuc nga kibikperagiagoc angerofora yenigoc hama ngicngac sasawa angammemengina angandae, imocac sirihau turunga kpouyemmeude. ");
INSERT INTO ded_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Foracngoc, ngic yomoc nandae, ngenearunac goa mi homemagec Ngicac Medacngo eucererengagoc hau kicnginango henggecde.” ");
INSERT INTO ded_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Uameme 6 wisickemanu Yesungo Petoro nga Yakobo amma munea Yohane hesicyunuu tikitoa herea monnu emma tembucngina kecgec. ");
INSERT INTO ded_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ihai kecmagec Yesuac sebia kicnginau heimerenec. Heimerenu kicmesuya imoc wenac isoc anec nga ngakpikporuha imoc kongac kpema ama meaiu kperagia fingecande, ifi isoc anec. ");
INSERT INTO ded_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ifi ammanu Mose nga Eria yereng imohaingoc fingecyemmema yegoc denegeng anoc. ");
INSERT INTO ded_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nga Petorongo Yesuac deec, “Kebu, nenang yei kecni songea andeac ge negenna naric anu bedzo bedzo harebec meba. Geac mong nga Moseac mong amma Eriaac mong.” ");
INSERT INTO ded_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Anu Petorongo ifi denammanungoc hoeng mong kperagiagocngo mama semeyunumanu hoeng manaunac yoacudumeng mong yofi kpacma deec, “Yomoc neac Songomedacna, ye hensongo ammiduae. Ngeni yeac yoac negembisia.” ");
INSERT INTO ded_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nga medac yeni imoc negemma kengec ebiria amma bangecfu makpema kicmesungina sufugec. ");
INSERT INTO ded_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ifi anggec Yesungo yenearu kemma midiyunuma yofi edeyunuec, “Ngeni yacgec, kengec mi anggec.” ");
INSERT INTO ded_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ifi deu yeni kicngina fima ngic mong mi henggec, yeni Yesu yengenasac nanu henggec. ");
INSERT INTO ded_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Anu tikiunac mama Yesungo deracyunuma yofi deec, “Ngeni onga hendau, imocac ngic mong mi edeyunubisia. Kecma Ngicac Medacngo homecfunac gborima yaruguc ine edeyunubisia.” ");
INSERT INTO ded_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ifi deu medacfora yeneng kpesimigec, “Mitiac negen negengngic yeni dafiac Eriango waraima haudeac deandae?” ");
INSERT INTO ded_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ifi degec yeng yofi edeyunuec, “Eriango warai hama wiac sasawa memengere anudenoc.” ");
INSERT INTO ded_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ni yofi edengunuba negenggec, “Eria ye bic hau yeni mi hensima yenang songo modacma faka hania hania ammigec. Nga yeni Ngicac Medac ifingoc kpendzennu faigec kpendzeng kpeude.” ");
INSERT INTO ded_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ifi deu medac yeni Yohane dokunadzicac deec, imoc bic irickegec. ");
INSERT INTO ded_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Anu yeni tikiunac mama habutoa yenearu kensikemagec ngic mongngo Yesuaru hama fafoc heimima deec, ");
INSERT INTO ded_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kebu, ge medacnaac ubaga manganeu. Ye afonasoya hau kpendzeng ebiria kpema naso homac gerecfu nga dokuu kemeande. ");
INSERT INTO ded_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nga medacna geac medacfocga yenearu mekemba yeneng ye mengeregecdeac obohoma wadau.” ");
INSERT INTO ded_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ifi deu Yesungo yofi deec, “Ngicngac areng yomoc ngeni negen negensingngina kpac yombong amma ngeni fakangina sicsauha. Ni naso herea ngenigoc monggoc tacbadeac modzona tide. Ngeni medac nearu mehagec.” ");
INSERT INTO ded_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Deu mehagec Yesungo hadehade ngabayoac seria edeu ye medac imoc wama kenec. Kenu naso imohaingoc medac imoc ngereec. ");
INSERT INTO ded_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ifi anu medacfora yeneng Yesuaru hama tembucngina tacma kpesimigec, “Neni dafiac hadehade imoc kporacbibieding?” ");
INSERT INTO ded_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kpesimigec Yesungo yofi merengyemmeec, “Foracngoc, ngeni negen negensingngina kapianecsac fedeac obohoma wadau. Ngeni negen negensingngina mastet gbomea isoc fengemmeu debac ngeni tiki yomoc naric edegecde, ‘Tiki, ge yomohacnac yacma edimoc kenna.’ Ifi edegec ye kenude. Nga ngeni wiac monggac naric mi obohogecde. ");
INSERT INTO ded_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hadehade ifia yakasege kecma nunumungosac kporacbesonga.” ");
INSERT INTO ded_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu nga medacfora yeni yenahafoc Gariraia bangecfu kpedzucnema kecmagec yeng yofi edeyunuec, “Ngic yeneng Ngicac Medac kererema ngicngac yeneac mariu faigecde, imocac naso wegenede. ");
INSERT INTO ded_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Faigec yeneng ye mema kpegec homeude. Homema uameme harebec ammanu homecfunac monggoc gborima yarude.” ifi deu yeni ubaebic kuneng megec. ");
INSERT INTO ded_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Anu Kafanaung taonnu kensikemagec Anutuac womonggac takesimemengic yeneng Petoroaru hama kpesimigec, “Ngeneac kpoukpou ye womonggac takesi faiande me kpac?” ");
INSERT INTO ded_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ifi degec Petorongo deec, “Oc, faiande.” Ifi dema amau emma yoac mi demanu Yesungo kpesimiec, “Simong, ge dafi negennec, bangeha bangeha ngictaungina, yeni takesi meracarunac meandae? Yeni yenang medacfocngina, yenearunac me ngicngac goa yenearunac meandae?” ");
INSERT INTO ded_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kpesimiu deec, “Yeni ngicngac goa yenearunac meandae.” ifi deu Yesungo yofi deec, “Ifiac amma medacfora yeni takesi mi faifai eng kecgecde. ");
INSERT INTO ded_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nga yeni neranggac negemmangang mi anggecdeac amma geng ine dzohong tegiau kemma kondungyang memeac hawic mong ukuna. Ukuma kondungyang waraima menade, imocac enara mekpacgema siriwadzo mong meficgenade. Meficgema dzo imoc mema neac nga geangga kpacfu takesimemengic yemmebesena.” ");
INSERT INTO ded_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naso imohai medac yeneng Yesuaru hama kpesimigec, “Kurumenggac eucerereng, imocac arennu merang kuneng kecde?” ");
INSERT INTO ded_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ifi kpesimigec Yesungo nambarac yenearunac mong kparec. Kparu kenu ye botucnginau faiu nanu yofi deec, ");
INSERT INTO ded_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Foracngoc, ngeni ubangina mi merenggecde amma nambarac yeni isoc mi anggecdeu kurumenggac eucererennu naric mi enggecde. ");
INSERT INTO ded_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Imocac ngic mong ye memaemema medac yofia, yeac siricfu kefude, yeng kurumenggac eucererennu kuneng kefude. ");
INSERT INTO ded_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nga mong ye nambarac yenearunac mong yofia neac kpacfu hoanggeude, yeng ni hoannuude. ");
INSERT INTO ded_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nga nambarac kapia yenearunac mong ni negensinnude, ye mongngo ngombonggeu sing segeudeu faka yomocngo yearu ngereebac. Ye yagucnoc dzamandzingtoa ubiau ubahemima kondung keme kemeau ukugec kemebac. ");
INSERT INTO ded_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bangectoa bangec yomocac ngic manganaac ngombonggema ogofocngina kopocsicfu faiyunuandae, yeni sowecnginagoc. Nga faka imoc fingerude, amma ngic mong ye faka imoc fingerudeac ngombonggeude, ye ebihagoc. ");
INSERT INTO ded_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ge haniga me mariga mongngo anggenu kopocsic meficgenadeu geng imoc herecgema ukuna kembeso. Hanimariga hafoangoc kecma gerec wisic wisickea kpac, imohai ukugugec kemebanggac, hani mangang me hanimariga tegec tegera kecma kekecseriu ennade, imoc ine ngereeude. ");
INSERT INTO ded_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Me kicga mongngo anggenu kopocsic meficgenadeu geng kicga meickema ukuna kembeso. Ge kicga yohockanggoc kecma hofeac gerecfu ukugugec kemebanggac kicga nobohagocsac kecma kekecseriu ennade, imoc naric anude. ");
INSERT INTO ded_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ngeni nambarac kapia, yenearunac mong ubango mi ukubisia. Ni edengunuba negenggec, nambarac yeneac angerofocngina kurumennu kecdae, yeni nasosoc Manna kurumennu kecde, yeac kicmesuya hengkecdae. ");
INSERT INTO ded_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nga Ngicac Medacngo ngicngac sufu sufuya, yeni ebicfunac kpedzucyunuma meyunuudeac maec. ");
INSERT INTO ded_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ngic mong ye ramafora 100 mekecde, imohacnac mong kemma sufuu yofi anude. Ye ramafora 99 tikiu wayunuu nanggec kemma sufudacmoc, imocnoc hoforude. ");
INSERT INTO ded_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Hofockecma meficgema yeac ubangerec kuneng negenude. Nga 99 mi sufugec, yeneac ubangerec negengande, imoc ferahema sufuec, yeac ubangerec kuneng negenude, imoc fora yombong. ");
INSERT INTO ded_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nga Mangngina kurumennu kecde, yeng ifi isocngoc areng kapia yomoc, yenearunac mongngo mi sufuudeac negemma kecde. ");
INSERT INTO ded_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ogoga mongngo gearu kopocsic meficgeudeu ge kenna yegoc tembucngira tacma imoc deficgemina. Nga yeng yoacga negenudeu ge firang anna ye geac ogoga monggoc anude. ");
INSERT INTO ded_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nga ye yoacga mi negenudeu geng ine ngic mocgu me yohockang meyuruna ngenahafoc ebic imoc mengeregecdeac tacbisia. Ifi amma ngic yohockang me harebec dede sasawa demeseri ambisia. ");
INSERT INTO ded_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nga ye yoacngina mi negenudeu ngeni ine kemma kpebung edeyunubisia. Edeyunugec yeng kpebung yeneac yoac ifingoc waudeu ine ngic imoc henggec ye ngic Anutu mi negemmidae nga takesimemengic, yeni isoc ambeso. ");
INSERT INTO ded_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Foracngoc, ngeni bangecfu wiac sasawa dzegegecde, imoc kurumennu ifingoc dzege dzegea feude. Nga ngeni bangecfu wiac yungecdacgecde, imoc kurumennu ifingoc yungec yungera feude. ");
INSERT INTO ded_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Imoc yofiac, yei bangecfu ngicngac yohockang me harebecngo neac kpacfu kpeturanggema tacgecdeu ni botucnginau kecbade. Imocac ngenearunac yohockangngo uba mocgu amma wiac monggac me monggac kpesiecdeu Manna kurumennu kecde, yeng negengngecmema imoc ngemerude.” ");
INSERT INTO ded_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Anu Petorongo Yesuaru hama kpesimiec, “Kebu, ogonango nearu kopocsic meficgeudeu naso dafiguc kopocsiha wabadeac negennec? Atac 7 soha ande me?” ");
INSERT INTO ded_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ifi deu Yesungo yofi meremmiec, “Atac 7 kpac, atac 70 namma ende imocac deduae. ");
INSERT INTO ded_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Imocac kurumenggac eucerereng imoc ngictau mong ngic homac mingingngina kefec, ye isoc. Nga yeng wanacngic yeni yearu turungngina kpougecdeac nasoya faiec. ");
INSERT INTO ded_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Faiu hagec turungnginaac ising ising ua hanaheu ngic mong ye turunga kifa 150 tausenggac uabung, imocacsoc feec, ngic imoc yearu mehagec. ");
INSERT INTO ded_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nga ye turunga imoc kpouudeac obohoma minginango edeu yengena nga enemmedacfora minging monggaru sueyunuma wiara sasawa suedacma, imocngo dzo kirecgeu turung imoc kpac anudeac deec. ");
INSERT INTO ded_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ifi deu wanacngic ye imoc negemma minginaac kicfu makpema deec, ‘Kunenna, ge neac ubaga manganeu tomaina kecmana turunna kpoudacbade.’ ");
INSERT INTO ded_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ifi deu minginango yeac ubea manganeu yoara nga turunga momoc waec. ");
INSERT INTO ded_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Anu wanacngic ye ngadeau kemeec. Kemema ine wanacngic ogea mong yearu turunga uameme 100ac uabung feec, ye meficgeec. Meficgema ye mendanggema ubea mendzicma deec, ‘Neac turunna gearu fede, imoc bic kpounendacna.’ ");
INSERT INTO ded_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ifi deu wanacngic ogeango imoc negemma yeac kicfu makpema desambic ammima deec, ‘Ge neacnec ubaga manganeu tomai kecmana turungga imoc ngade kpoubade.’ ");
INSERT INTO ded_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ifi deu ogeango yeac yoac wama turunga kpoudacmaguc maudeac mekemma witicamau faiu tarec. ");
INSERT INTO ded_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Taru wanacngic ogofocngira yeneng faka imoc hemma ubangina homac manganeu negenggec naric mi anec. Nga yeni kemma faka fingerec, imoc sasawa mingingngina edegec. ");
INSERT INTO ded_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Edegec mingingnginango wanacngic imoc deu hau edeec, ‘Ge wanacngic mangac manganea. Geng desambic anenna turungga sasawa wadua. ");
INSERT INTO ded_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nga neng geac ubana manganeu turungga wadua, ge ifi isoc wanacngic ogogaac ubaga ifingoc manganeu turunga wabanggacsoc.’ ");
INSERT INTO ded_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ifi dema minginango herebu negemma ngaba ammima witicamagareng yeneac mariu faiec. Faiu wanacngic ye turung imoc sasawa kpoudacmaguc maudeac deec. ");
INSERT INTO ded_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Anu ngeni sasawango ogofocngina tembuc tembuc yeneac kopocsic ubaherenginango yombong mi wagecdeu Manna kurumennu kecde, yeng siriha ifingoc ngeni angemmeude.” ");
INSERT INTO ded_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesungo yoac imoc dedaru wisickeu Gariraia bangec wama Yudaia bangecfu Yodang nobocgengau kenec. ");
INSERT INTO ded_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kenu ngicngac habutoa kuneng yombong ye modacgec yeng ngicngac hafeinginagoc mengereyunuec. ");
INSERT INTO ded_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Anu farisaio yeneng yearu hama faitobannu faigecdeac kpesimigec, “Ngic ye enema wiac hania haniaac amma waude, singngo imoc dede me?” ");
INSERT INTO ded_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ifi degec Yesungo meremma yofi edeyunuec, “Fingec fingec minginango hanahema deu ngic nga ngac anecde, ifi meficyuruec. Ngeni imocnoc osonegeng angandae. ");
INSERT INTO ded_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ye meficyuruma yofi deec, ‘Imocac amma ngic ye nonggomama wayuruma enemaaru kpeketaheu yegoc sebi mocgu anecde.’ ");
INSERT INTO ded_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ifi anecdeac yeri yohockang monggoc mi andape, kpac. Yeri sebi mocgu anecdeac yofi ande, Anutungo wiac dzegeec, imoc ngicngo naric mi herecgebeso.” ");
INSERT INTO ded_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Deu degec, “Nga dafiac Mosengo dedeseri yofi nemmeec, ngic mongngo ngac wawa kibi ohoma ngac miu ngac ye wau kembeso?” ");
INSERT INTO ded_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ifi degec Yesungo yofi deec, “Ngeni ngic ubaseri nga herengina dzege dzegea, imocac Mosengo enengfocngina wayunugecdeac kpae mi heiec. Nga hanac hanaheaunac ereec sing ifia mong mi feec. ");
INSERT INTO ded_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ni ine yofi edengunuba, ngic mongngo enema serofaka mi ammanu ye eng wama ngac mong meude, ngic imocngo serofaka anude.” ");
INSERT INTO ded_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ifi deu negemma medacfora yeneng degec, “Eweeneng yereac botucfu faka ifia fedeu eweeneng kekec kecnide, imoc gombunga yombong kpac.” ");
INSERT INTO ded_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ifi degec Yesungo yofi edeyunuec, “Yoac yomoc goa yenearu mi heiude. Yoac imoc ngic yemmeyemmea yenearusac heiude. ");
INSERT INTO ded_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ngic goa yeni nonggo heremanaunac kufing fingecgec. Nga goa yeni ngicngo faka ayemmegec kufing anggec amma ngic goa yeni kurumeng eucererenggac amma kufing isoc kecandae. Ngic mong ye yoac imoc yearu heide, yeng imoc mebeso.” ");
INSERT INTO ded_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Anu ngicngac yeneng nambaracfocngina kapiabisic Yesuaru meyunu kemma negenggec, “Yeng mariango nambarac witinginau faima numuyemmeude.” ifi anggec medacfora yeneng kpetariyemmegec. ");
INSERT INTO ded_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesungo ine yofi deec, “Nambaracbisic bisic yeni nearu naric hagec. Ngeni kpae mi heiyemmegec. Kurumenggac eucerereng imoc nambaracbisic bisic yofia yeneac.” ");
INSERT INTO ded_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ifi dema maria witinginau faima kenecyunuu wisickeu ye amabangec imoc wama monnu kenec. ");
INSERT INTO ded_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Negenggec, ngic mongngo Yesuaru hama deec, “Kpoukpou, ni noc faka gombunga angkecma kekecseri mebai?” ");
INSERT INTO ded_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ifi deu yeng yofi deec, “Ge wiac gombungaac ni mi kpesinenna. Mocgungo gombunga kecde. Nga ge kekecseriu embesonga dema dedeseriyoacnina tofohobesena.” ");
INSERT INTO ded_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ifi deu deec, “Dedeseriyoac damoc tofohobadeac denec?” ifi deu Yesungo yofi deec, “Ge ngicngac mi yunuhomebesena nga kaisero mi ambesena nga hamangec mi mebesena amma enacfu faifai mi ambesena. ");
INSERT INTO ded_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ge nonggo manghocga seseyurubesena amma geangga anggengande, siriha imocngoc ogofocga heresongogoc hoangyunubesena.” ");
INSERT INTO ded_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ifi deu sebigboringic yeng deec, “Ni imoc sasawa modacanduae. Nga noc wiacac monggoc kpedadanggebade?” ");
INSERT INTO ded_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Deu Yesungo yofi edeec, “Ge ngic dindingac hafoangoc kecbesonga negennec isoc, yofi anna. Kemma wiacga sasawa suedacma hiedzoga mema ngicngac makpekpea yemmebesena. Ifi anna kurumenggac dzofinac fingecgenu hama modacnubesena.” ");
INSERT INTO ded_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ifi deu sebigboringic ye dzofinaha homac femiecac yoac imoc negemma ubaebic mema kenec. ");
INSERT INTO ded_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kenu Yesungo medacfora yofi edeyunuec, “Foracngoc, ngic mong dzofinactoagoc, ye kurumenggac eucererennu enudeac ambibieude. ");
INSERT INTO ded_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Amma monggoc deba negenggec, kamerengo bungic singau engeng, imoc ua efea nga ngic dzofinacgoc yeng Anutuac eucererennu engeng, imocngo ine uatoayagoc.” ");
INSERT INTO ded_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ifi deu medac yeneng yoac imoc negemma kpidohoma kerectegec yombong amma degec, “Ifi anu merang naric komoc kpeude?” ");
INSERT INTO ded_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ifi degec Yesungo yenemma yofi deec, “Ngic ngeni imoc obohoma wagecde nga Anutungo wiac sasawa naric meude.” ");
INSERT INTO ded_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ifi deu Petorongo deec, “Negenna, neni wiacnina sasawa wadacma modacguma kecdimbe. Imocac neni noc wiac menide?” ");
INSERT INTO ded_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ifi deu Yesungo yofi edeec, “Foracngoc, kecma wiac sasawa gboria fingerude, naso imohai Ngicac Medacngo kurumenggac kuc nga kibikperagiaac ngictautatahau tarude. Nga ngic modacnuandae, ngeni ifingoc ngictautatac 12 imohai tacma Israeac kisic 12, yeneac fakangina isinggema desigecde. ");
INSERT INTO ded_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nga ngicngac kpacnaac amma amafocngina me dacmunafocngina me nonggo mangfocngina me nambaracfocngina me bangecngina wagec, ngeni sasawango wiac imocac naso 100 monggoc megecde nga kekecseringo maridzomingngina ambesande. ");
INSERT INTO ded_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngic warac warac kecandae, yenearunac ine homacngo ngadea anggecde nga ngadea kecdae, yenearunac homacngo warac warac anggecde.” ");
INSERT INTO ded_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kurumenggac eucerereng imoc ngic mong amabangehagoc, siriha imocacsoc. Ye asoacngoc kemma ngic waing uayau ua megecdeac ngic yagura meyunuec. ");
INSERT INTO ded_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Meyunuma ua ngic yagura yeni uameme mocguac dzo ifiasoc megecdeac denegeng amma uba mocgu amma sueyunuu uau kenggec. ");
INSERT INTO ded_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nga 9 kiroc ammanu waing ua minginango ngic goa kpedzaroc sobennu eng nanggec yenemma ");
INSERT INTO ded_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yofi edeyunuec, ‘Ngeni ifingoc waing uanau kemma ua megec, imocac sirihau dzo ngemmebade.’ ");
INSERT INTO ded_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ifi deu yeni waing uayau kenggec. Nga ye 12 kiroc nga 3 kirocfu faka imocngoc anec. ");
INSERT INTO ded_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nga 5 kiroc anu ye monggoc kemma ngic goa ifingoc eng nanggec meficyunuma yofi edeyunuec, ‘Ngeni nocac eng nanggec ama marai ande?’ ");
INSERT INTO ded_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ifi deu degec, ‘Ngic mongngo uayoac mong mi denemmedac.’ Ifi degec yofi edeyunuec, ‘Ngeni ifingoc kemma neac waing uau ua mebisia.’ ");
INSERT INTO ded_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ama marai anu ua minginango ua gareng yofi edeec, ‘Ge yagurangic kpacyununa hagec uaac bung yemmena. Amma ngic wisic wisickea hagec, yenearunac hanahema yemmekengkecna waraima hadau, yenearu wisickebeso.’ ");
INSERT INTO ded_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ifi deu ua garengngo ngic 5 kiroc hagec, yeni hanahema ua meme mocguac bung, ifi yemmeec. ");
INSERT INTO ded_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yemmeu ngic waraima hagec yeneng negenggec, ‘Ye dzo meemma nemmeude.’ Nga ua garengngo dzo kpetea imocngoc yemmeec. ");
INSERT INTO ded_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yemmeu yeni dzo kpetea imoc hemma negenggec naric mi anu waing ua mingina ");
INSERT INTO ded_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","edegec, ‘Ngic yomoc yeni ngade yombong hama aua mocgusac ua megec. Nga neni ine asoacngoc hama uaac ebic hemma wenacfu namma meerekecni ama marai ande. Nga geng yenigoc siriha mocgungoc anemmedang.’ ");
INSERT INTO ded_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ifi degec yeng yenearunac mong yofi edeec, ‘Ogona, ni kopocsic mong mi meficgegendua. Negenna, nerang waraima uameme mocguac dzo ifiasoc deserima uba mocgu andic. ");
INSERT INTO ded_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ge imocac dzoga mema kenna. Nga neng ine yagurangic ngade hadau yeni bung socfungoc yemmebadeac songona ande. ");
INSERT INTO ded_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ni neanna hiedzongo ifi me ifi ambesonga negemma imoc naric ambai. Amma fakana gombunga anu imocac negen negengga mi manganebeso.’ ");
INSERT INTO ded_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ifi isoc ngadea yeneng warac warac anggecde nga warac warac yeneng ine ngadea anggecde.” ");
INSERT INTO ded_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesungo medacforagoc Yerusarennu kembeso kemma sinnu tembucnginau yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Negendae, nenang Yerusarennu endimbe. Enni ngic yeneng Ngicac Medac womong gareng enara nga mitiac negen negengngic, yeneac mariu faigecde. Faigec yeneng ye homeudeac desigecde. ");
INSERT INTO ded_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Desima ye bangec monnunac ngic Anutu mi negemmidae, yeneac mariu faigecde. Faigec yeneng deendema ammima dzikacngo kpema sebia kpekperecge amma mariponnu kpegec homeude. Amma uameme harebec kemmanu homecfunac monggoc yarude.” ");
INSERT INTO ded_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Anu Dzebedaioac medahora nonggongirango meyuruu Yesuaru hagec. Hama Yesu fafoc heimima deec, “Ni wiac monggac naric kpesigembai me?” ");
INSERT INTO ded_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ifi deu deec, “Ge noc wiacac anggende?” Deu edeec, “Medachocna yomoc yereng eucererenggau mongngo foigau nga mongngo kanagau tarecde, imoc deserinenna.” ");
INSERT INTO ded_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ifi deu Yesungo yofi deec, “Ngeni wiac kpesidae, imocac hania mi negenghomedae. Nga neng kpendzenggac kpakenecfu nebeso anduae, ngeri imoc neecdeac dedape me?” deu deoc, “Oc, naric nedede.” ");
INSERT INTO ded_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeri ifi deec Yesungo yofi edeyuruec, “Ni kpendzenggac kpakenecfu nebade, ngeri imocngoc neecde. Nga ngic merang foinau me kananau tarude, imocac fora ine neng naric mi desibade. Mannango ngic tatac imohai tarecdeac bic mengereec, yereng ihai naric tarecde.” ");
INSERT INTO ded_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Anu medacfora 10 yeneng imoc negemma dacmunac yereac negenggec manganeec. ");
INSERT INTO ded_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Manganeu Yesungo kpacyunuu kenggec yofi edeyunuec, “Bangec monnunac ngicngac, yeneac ngictaufocngina ngicngac yeneac ngickuneng siricfu garengyunuandae. Nga ngicngac kunengfocngina yeni ngicngacfocngina yeneng yoacngina modacgecdeac kuc feyemmede, ifinoc negengandae. ");
INSERT INTO ded_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","28","Nga faka ifia ngeneac botucfu mong mi febeso, kpac. Ngicac Medacngo ngicngac yeneng yeac kingang kpegecdeac mi maec, kpac. Yeng yeneac kingang kpema ngicngac homac ebicfunac yungecyunuma kekeha wau yeneac doudeac maec. Ifi isoc ngenearunac ngic mongngo engena kecbeso ammide, yeng botucnginau kingang kpekpengina kecbeso. Nga ngeneac botucfunac warac warac ambeso ammide, yeng botucnginau wanacngicngina kecbeso.” ");
INSERT INTO ded_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu nga medacfora yeni Yeriko taong wama kemmagec ngicngac habutoa kuneng yombong modacyunugec. ");
INSERT INTO ded_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nga sing tegiau kicpisic ngic yohockang taroc. Tarec ngicngac yeneng degec, “Yesungo hama kende.” ifi degec yeri imoc negemma kpacma deoc, “Kebu, Dawidiac bangeha, ge nereacnec ubaga manganeu.” ");
INSERT INTO ded_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ifi kparec ngicngac habutoa yeneng waickema tarecdeac kpetariyecmegec. Nga yeri ine monggoc seriangoc kpacma deoc, “Kebu, Dawidiac bangeha, ge nereacnec ubaga manganeu.” ");
INSERT INTO ded_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kparec Yesungo namma kpacyuruma yofi deec, “Ngeri noc wiac angecmebadeac negendape?” ");
INSERT INTO ded_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","deu deoc, “Kebu, neri kicnira tegerudeac negendipe.” ");
INSERT INTO ded_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Deec Yesungo ubea manganeu mariango kicngira kpesereu yeri imohaingoc kicngira fima ye modaroc. ");
INSERT INTO ded_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu nga medacfora yeni Yerusareng mewegenema Betefage amabangec Oriwa tikiu tarec, imohai kensikema Yesungo medahora yohockang yofi dema sueyuruec, ");
INSERT INTO ded_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ngeri dindingac kemma guruama sing enarau tacde, imohai donggi mong bic meficgeecde. Ye medahagoc witickegec nande. Ngeri donggi imoc yungecyuruma nearu mehaec. ");
INSERT INTO ded_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nga ngeri ifi anec ngic mongngo ngeremma kpesingemerude isoc ngeri yofi edebesera, ‘Kebungo yerigoc ua meudeac dede.’ Ifi deec yeng donggi nonggomedac bic ngerigoc sueyuruude.” ");
INSERT INTO ded_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Profete yoac mong yofi deec, imoc fora anudeac ifi fingerec. ");
INSERT INTO ded_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ge Sionggac naroang yofi edebesena, ‘Henna, ngictauga hagende. Ye donggiu hade, ye donggi medahaac witiau tacde nga ye fakaya memaemeemea.’” ");
INSERT INTO ded_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nga medac yeri kemma Yesungo edeyuruec, ifi isoc anoc. ");
INSERT INTO ded_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ifi amma donggi medahagoc meyuruma hama ngakpingira herea hesima donggi nonggomedac yereac witingirau tiameoc. Tiameec Yesungo imocac witiau tarec. ");
INSERT INTO ded_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Taru ngicngac habutoa nanggec, yeni ngakpingina hesima sinnu tiamegec nga goa yeni ic fawa icfunac herecgema sinnu tiamegec. ");
INSERT INTO ded_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nga ngicngac habutoa kiwau kenggec nga ngadeau modacgec, yeneng kpacma yofi degec, “Ohec waec, Dawidiac kisicfunac, ohec. Ngic Kebuac kpacfu hade, ye kenehagoc. Wi kurumennu kpara dengeregec, ohec waec, hosanna.” ");
INSERT INTO ded_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesungo Yerusarennu enu taonggac ngicngac sasawa yeni kpidohoma kengha amma degec, “Imoc merac?” ");
INSERT INTO ded_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ifi degec ngicngac habutoa yeneng edeyunugec, “Imoc Yesu, profetenoc Gariraia bangecfunac Nadzarete taonnunac.” ");
INSERT INTO ded_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Anu Yesungo Anutuac womonggac oda manau emma ngicngac wiac emekpesi anggec, yeni imohacnac kporacyunuec. Ye ngic hiedzo emekpesi anggec, yeneac tebo heimeremma kebesac emegec, yeneac tatac ifingoc heimeremma ");
INSERT INTO ded_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","yofi edeyunuec, “Yoac yofi oho ohoya fede, ‘Neac ama imoc nunumuama, kpara ifi kpacbesonga.’ Nga ngeneng ine imoc merenggec, hamangec ngic yeneac sufu sufuama ande.” ");
INSERT INTO ded_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Anu womonggac odatoaac manau ngic kicpisic amma hanimangang yeneng yearu hagec yeng mengereyunuec. ");
INSERT INTO ded_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ye faka kuhagoc ifi meec nga nambarac yeneng womong manau kpacma yofi degec, “Dawidiac bangeha, ohec, hosanna.” Kpacgec womong gareng enara nga mitiac negen negengngic yeneng imoc hemma herebu negemma ");
INSERT INTO ded_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yesuaru kemma degec, “Yeni yoac dedaemoc, imoc negennec me?” Ifi degec yeng yofi deec, “Negenduae amma ngeni yoac yomocnoc osonegeng mi angandae gedang, ‘Ge nambarac kapia nga sabac namuu kecdae uayoac yemmena yeneng geac kpac kuneng heiwayong memigecde.’” ");
INSERT INTO ded_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ifi dema wayunuma taong wama Betania amabangecfu kemma tofocnac ihai kefec. ");
INSERT INTO ded_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Amma Yesungo asoac taonnu dzigene kemma hereaac homema ");
INSERT INTO ded_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","sing tegiau kic fima fig ic mong henec. Hemma negenu foragoc isoc anu haniau kemma mariasac hemma ic yofi edeec, “Ic, gearunac fora monggoc mi fingeckecbeso.” Ifi deu fig ic imoc imohaingoc ururueec. ");
INSERT INTO ded_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ururueu medacfora yeneng imoc hemma kpidohoma kpesimigec, “Fig ic imoc dafi bic yombong ururuede?” ");
INSERT INTO ded_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ifi dema kpesimigec Yesungo yofi edeyunuec, “Foracngoc, ngeni negen negensingnginagoc kecma negengyohoc mi anggecdeu icfu faka medua, faka imoc naric megecde, imoc edengunuduae. Nga imocsac kpac, ngeni ifingoc tiki yomocac yofi naric degecde, ‘Tiki ge miacemema kondunnu ukuemema kemena.’ Ngeni ifi edegec, ifinoc anude. ");
INSERT INTO ded_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nga ngeni wiac monggac me monggac negensinggema nunumunginau kpesigecdeu ngeni imoc sasawa megecde.” ");
INSERT INTO ded_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesungo ifi dema taonnu hama womonnu emma kpoukpou ua meu womong gareng enara nga yudangic enarafocngina, yeneng hama kpesimigec, “Ge noc kucfu ua yomoc menec amma merang uayoac imoc genec?” ");
INSERT INTO ded_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ifi kpesimigec yeng yofi merengyemmeec, “Neng ngeni wiac monggac ifingoc kpesingemmeba ngeni turunga edenugecdeu ni uakibinaac hania imoc edengunubade. ");
INSERT INTO ded_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohanengo dokunadzic ua mekefec, imoc dahacnac, kurumennunac me ngicfunac?” Deu yeni yenaocngoc denegeng amma degec, “‘Imoc kurumennunac.’ ifi denideu yeng yofi kpesinemmeude, ‘Ifi negemma ngeni nocac ye mi negensinggegec?’ ");
INSERT INTO ded_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Me ‘Imoc ngicfunac.’ ifi denideu ngicngac sasawa yeni Yohaneac ye profete negendae, imocac debesonga yeneac kengecnunude.” ");
INSERT INTO ded_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yeni ifi denegeng amma Yesu edegec, “Imoc mi negendimbe.” Ifi degec Yesungo yofi deec, “Ifi degec, ni ifingoc noc uayoacac kucfu ua mekecduae, imoc mi edengunubade.” ");
INSERT INTO ded_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Negenggec, “Ngic mong ye medahora yohockang nga ye waracmedahaaru kemma edeec, ‘Medacna, ge yaguc waing uau kemma ua mebesena.’ ");
INSERT INTO ded_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ifi edeu medahango merenec, ‘Ni imoc waduae.’ Ifi dema ine ngade ubea dzigeneu uau kenec. ");
INSERT INTO ded_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nga manggac ye kemma ngademedaha, yeac ifingoc edeu ngademedahango deec, ‘Manggac, ni naric kembade.’ Ifi dema kemma ihoc bahoc amma uau mong mi kenec.” ");
INSERT INTO ded_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ngeni dafi negendae, “Medac yerearunac merang mamaac songo modacma uaya meec?” Ifi kpesiyemmeu degec, “Waracmedaha yeng.” degec Yesungo yofi edeyunuec, “Foracngoc, takesimeme ngic nga singtoangac yeneng waraingemmema Anutuac eucererennu enggecde. ");
INSERT INTO ded_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohanengo sing dindingac modacma ngenearu hau ngeni ine mi negensinggegec. Nga takesimeme ngic nga singtoangac yeneng ye negensinggegec. Ngeni ine imoc henggec amma sifu ubangina mi merenggec nga mi negensinggegec.” ");
INSERT INTO ded_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ni yoac mong heiba negenggec, “Ngic mong amabangehagoc ye waing ua mong homecma oda dzegeec. Dzegema waing tidzoc tidzohoac teng usuma gareng yeneac kicfifiac amaherec meec. Ifi meu wisickeu waing ua garenggegecdeac ngic meficyunuma yenigoc yoac dedzege anggec. Nga yengenaoc ine bangec hereau kenec. ");
INSERT INTO ded_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kenu fora kpememe naso hau ye wanacngicfora sueyunuu uagareng yenearu waing fora megecdeac kenggec. ");
INSERT INTO ded_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kenggec ua gareng yeneng ine minginaac wanacngicfora meyunuma mong kpema mong kpehomema mong hocngo heigec. ");
INSERT INTO ded_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ifi anggec ua minginango wanacngic goa homac monggoc sueyunuu kenggec gareng yeneng faka imocngoc ayemmegec. ");
INSERT INTO ded_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nga ngade ua minginango yofi negemma yengena medaha sueec, ‘Yeni medacnaac ewea sifu heigecde.’ ");
INSERT INTO ded_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ifi dema sueu kenu ua gareng yeneng medaha hemma yofi denegeng anggec, ‘Yeng kecma ua yomoc tiu enude, imocac ye kpehomema bangeha nga maridzominga sasawa meni nenang ambeso.’ ");
INSERT INTO ded_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ifi dema miacukugec oda ngadeau kemeu mema kpehomegec. ");
INSERT INTO ded_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nga ua minginago monggoc hama uagareng dafi ayemmeude?” ");
INSERT INTO ded_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ifi deu degec, “Ua minginango hama uagareng mangana memanganeyunuma yunuhomema waing uaya imoc uagareng goa yeneac mariu faiude. Faiu yeneng imoc garenggema foranasou mingina fora migecde.” ");
INSERT INTO ded_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ifi degec Yesungo yofi deec, “Mitikibiu yoac yofi oho ohoya fede, ‘Amameme ngic yeneng hoc mong mangana dema ukugec. Nga hoc imocngo amaac hoc wotung amma seria nanude. Kebu yengenaoc faka imoc meu ngicngo hensongo ammidimbe.’ Ngeni kibi imoc osonegeng mi angandae gedang. ");
INSERT INTO ded_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Imocac amma edengunuba negenggec, Anutungo eucerereng ngenearunac meickema areng mong yemmeude. Nga yeneng eucererenggac uaya mema foraya meficgegecde. ");
INSERT INTO ded_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nga ngic mong ye hoc imocac witiau maude, ye sebia tegerude. Nga hoc imocngo yeac witiu makpema hedzameu kapuc kpeude.” ");
INSERT INTO ded_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Anu Yesungo yoac heiec, imoc womong gareng enara nga farisaio yeneac deec, imoc bic negentegecgec. ");
INSERT INTO ded_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yeni ifi negenggec nga habu yeneng yeac profete degecac yeni ine Yesu mendanggegecdeac kengecyunuu osima wagec. ");
INSERT INTO ded_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesungo yoac mong heima torokpema yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kurumenggac eucerereng imoc ngictau mong isoc, ye medahaac memeturang nasoac yakatoa ohoma memengere anec. ");
INSERT INTO ded_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Amma ngictaungo wanacngicfora sueyunuu yeni ngicngac memeturanggac amma bic heitaiyunuec, yeni wangecyunugecdeac kenggec. Kenggec ngicngac yeneng ine modzongina tiu wagec. ");
INSERT INTO ded_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wagec ngictaungo wanacngicfora goa monggoc sueyunuma yofi deec, ‘Ngeni kemma ngic bic heitaiyunuai, yeni edeyunugec, “Negendae, burumakana ngiwa nga yang kerectoayagoc imoc bic kpeoho amma yakatoa mengeredacdua. Ni wiac sasawa bic memockedua, imocac ngeni hagec.” ’ ");
INSERT INTO ded_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ifi deu kemma edeyunugec, yeneng ine yoac monggoc hau imoc negemma modzongina tiu eng wama kengha anggec. Mong ye uayau kenec nga mongngo kpounec uayau kenec. ");
INSERT INTO ded_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nga ngicngac tosea yeneng ngictauac wanacngicfora ngaba ayemmema yunuhomegec. ");
INSERT INTO ded_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ifi anggec ngictau ye imoc negemma herebu amma wasaifora sueyunuu kemma ngickpekpengic imoc yunuma taongngina faigec dzeec. ");
INSERT INTO ded_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Amma wanacngicfora yofi edeyunuec, ‘Memeturanggac yaka imoc bic mengec mengerea nga ngic heitaiyunudua, yeni areng mangana ifiango nearu hagecdeacsoc mi ande. ");
INSERT INTO ded_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Imocac ngeni sing sosocfu kemma namma ngic meficyunugecdesoc, yeni edeyunugec memeturanggac amau habisia.’ ");
INSERT INTO ded_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ifi deu wanacngic yeni sinnu kemma ngic meficyunugecsoc gombunga nga mangana momoc hesicyunudacma hama memeturanggac yakaama imoc mewakegec. ");
INSERT INTO ded_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Anu ngicngac yeni hadacma tacgec ngictaungo yenenudeac hama ngic mong memeturanggac ngakpi mi heima tarec, ");
INSERT INTO ded_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ye hemma yofi edeec, ‘Tosona, ge dafi memeturanggac ngakpi mi heima erema tacnec?’ Ifi deu ngic ye yoara kpac waickema taru ");
INSERT INTO ded_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ngictaungo kingangngicfora yeneac yofi deec, ‘Ngeni hanimaria kpema ngadeau kundunnu ukugec kemeu. Ihai kiacma enara kisaranggema kecbeso.’ ");
INSERT INTO ded_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ngicngac kpacyunuyunuya, yeni homac nga meisingyunuyunuya, yeneng ine efeanec.” ");
INSERT INTO ded_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Anu farisaio yeneng kemma yoac dafi dema Yesu tobanggeni yoac goa segeu meni dema imocac denegeng anggec. ");
INSERT INTO ded_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ifi amma medacfocngina nga Herodeac areng goa Yesuaru sueyunugec kemma degec, “Kpoukpou, ge yoac fora dekecnec, imoc negendimbe. Nga Anutuac sing dindingac ngicngac edekpou anemmekecnec amma ngic monggac me monggac songo mi negemma engena mamea socfungoc anemmeannec. ");
INSERT INTO ded_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Imocac dafi negennec, damocngo naric ande, neni takesi ngictau Sisa naric minide me kpac?” ");
INSERT INTO ded_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ifi degec Yesungo ngabasiricfu degec, imoc negemma yofi edeyunuec, “Ikocngic, ngeni nocac suba idenendae? ");
INSERT INTO ded_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ngeni takesi faiandae, imohacnac dzo mong mehagec hemba.” Ifi deu yeni denarihoc mong mekemma edzahegec ");
INSERT INTO ded_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","yeng imoc hemma yofi kpesiyemmeec, “Onga nga kibi yoc, imoc meracac?” ");
INSERT INTO ded_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Deu degec, “Imoc Sisaac.” Ifi degec yeng yofi edeyunuec, “Imocac ngeni Sisaac wiac Sisa mibisia nga Anutuac wiac Anutu mibisia.” ");
INSERT INTO ded_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ifi deu yeni imocac negenggec engena anu wama kenggec. ");
INSERT INTO ded_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadukaio areng yeni homecfunac yacyac mi fede, ifi dekecdae, yenearunac ngic goango wenac imohaingoc Yesuaru hama kpesimigec, ");
INSERT INTO ded_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kpoukpou, Mosengo yofi deec, ‘Ngic mongngo ngac meec nga ye gboriha kpac kecma homeu muneango daraac hodzec mema gboric kpeficgema daraac kpac miacma kecbeso.’ ");
INSERT INTO ded_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dacmunac seweng nenigoc kecgec, yenearunac waracdacnginango ngacfu kemma gboriha kpac kecma homeu muneango hodzeha meec. ");
INSERT INTO ded_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Meu munea nga yeac ngadeau munafora 5 kecgec, yenearu faka ifiangoc fingeru yeni sasawango homedacgec. ");
INSERT INTO ded_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Homedacgec ngac ye ifingoc kecma homeec. ");
INSERT INTO ded_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ngic seweng yeni sasawango ngac yeac ewea anggec. Nga yacyac nasou ngac imoc meracac enema anude?” ");
INSERT INTO ded_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ifi degec Yesungo meremma yofi edeyunuec, “Ngeni mitikibi nga Anutuac kuc mi negentegecdaeac yoac desufudae. ");
INSERT INTO ded_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yacyac nasou ngicngac yeni monggoc mi meemegecde amma manggac mongngo yofi mi deude, ‘Ni naroanna ngic mibade.’ Imohai ngicngac yeni ine kurumenggac angero, yeni isoc anggecde. ");
INSERT INTO ded_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nga homecfunac yacyac dema Anutungo yofi bic edengunuec, ");
INSERT INTO ded_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ni Abrahang nga Isaka amma Yakobo, yeneac Anutu.’ Ngeni imoc osonegeng mi angandae gedang. Nga ye ine ngic homemea, yeneac Anutu kpac. Ye gbori kecdimbe, neneac Anutu.” ");
INSERT INTO ded_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nga ngicngac habutoa yeni kpoukpouya imoc negenggec engena anec. ");
INSERT INTO ded_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Anu farisaio yeneng yoac yomoc negenggec, “Yesungo sadukaio yeneac yoac merenu yoacngina dugung kpeu engsac nanggec.” Yeni imoc negemma kpedzucnema ");
INSERT INTO ded_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","yeneac botucfunac dedeseriyoacac negen negengngic mongngo Yesu faitobannu faima kpesimiec, ");
INSERT INTO ded_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kpoukpou, dedeseriyoacac manau dedeseriyoac damocngo engena yombong ande?” ");
INSERT INTO ded_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ifi kpesimiu yofi edeec, “‘Ge ubaherega nga ubaongaga amma negen negengga hafoangoc Kebu Anutugaac songo negemma kecbesena.’ ");
INSERT INTO ded_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Imocngo dedeseriyoacac warac warac nga kuneng ande. ");
INSERT INTO ded_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nga imocac ngadeau ogea yofi, ‘Ge geangga anggengande, siriha imocngoc gegoc wegena kecdae, yeni heresongogoc hoangyunubesena.’ ");
INSERT INTO ded_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dedeseriyoac nga profeteyoac sasawango dedeseriyoac yohockang yomocac witiau tima nandae.” ");
INSERT INTO ded_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Anu farisaio yeni kpedzucnema tacmagec Yesungo yofi kpesiyemmeec, ");
INSERT INTO ded_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngeni Messiaac hania dafi negendae, ye meracac kisicfunac?” Kpesiu meremmigec, “Ye Dawidiac bangeha.” ");
INSERT INTO ded_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ifi degec Yesungo yofi deec, “Ifi anu Tiri Asungo dafiac Dawidiac enac meefaiu yeac ‘Neac Kebu.’ dema yofi deec,” ");
INSERT INTO ded_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“KEBUNGO neac Kebu edeec, ‘Ge foinaugeng tacmana ngabafocga hanigaac bageau faiyunuba yeni hanititiga anggecde.’” Ifi deec. ");
INSERT INTO ded_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nga Dawidi yengenaoc kpara yofi kparec, “Neac Kebu. Nga Messiango dafiu Dawidiac bangeha ande?” ");
INSERT INTO ded_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ifi deu yeni Yesuac yoac turunga merembesonga obohogec. Obohoma naso imohacnac erema yeac kengec amma mongngo dekpesi monggoc mi ammigec. ");
INSERT INTO ded_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesungo ngicngac habutoa nga medacfora yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mitiac negen negengngic nga farisaio yeni Moseac tatacfu tacdaeac ");
INSERT INTO ded_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","yeni yoac edengunudae, ngeni imoc sasawa tofohoma modacbisia. Nga yeni faka angandae, ngeni siric ifi mi ambisia. Yeni yoac edengunuandae, imoc ine yenaoc mi modacandae. ");
INSERT INTO ded_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yeni singyoacac dede ebiria yombong dedeckema ngic ngeneac fuau faigec ebiriude. Nga yenaoc ine dede imoc meefaima meficngunugecdeac gbongnginango miacgecdeac mi ayemmeude. ");
INSERT INTO ded_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yeni ngicngo fakangina henggecdeac mitigbomea kandacbisic bisicngina meyadiandae. Amma ngakpingina herea heiandae, imohai witic kibi kibi kpatainggema nangande, imoc kuneng yombong meandae. ");
INSERT INTO ded_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yeni yakatoa nasou nga kpekpeturang amau warac warac tatacfu tacbesonga ayemmeude. ");
INSERT INTO ded_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nga kpedzaroc sobennu ngicngac yeneng ‘Wenacngerec.’ nga ‘Gareng,’ ifi dema kpacyunugecdeac homac ayemmeude. ");
INSERT INTO ded_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Anu ngeni garengngina mocgungo kecde nga ngeni sasawa dacmunac andae. Imocac ngeneac negemma mongngo ‘Gareng,’ ifi mi kpacngunubeso. ");
INSERT INTO ded_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mangngina mocgungo kurumennu kecdeac amma ngeni bangecfu ngic monggac ‘Mannina,’ ifi mi debisia. ");
INSERT INTO ded_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nga kunengngina Messia mocgungo kecdeac amma ngic mongngo ‘Kunenna,’ ifi mi kpacngunubeso. ");
INSERT INTO ded_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nga kunengngina kecde, yeng ine ngeneac kingangkpekpe kecbeso. ");
INSERT INTO ded_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngic mong ye yengenaac negenu engena angkecde, ye mamea anudeac memagecde. Nga mong ye yengenaac negenu mamea angkecde, ye meenggecde. ");
INSERT INTO ded_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mitiac negen negengngic nga farisaio, ngeni kurumeng eucererenggac nagu kpebung yeneac kicnginau heiandae. Ngeneng imohai enggecdeac segeandae nga kpebung yeneng embesonga ammagec kpae ifingoc heiyemmekecdae. Ngeni ikocfakangina ifia mekecdaeac ngeni sowecnginagoc. ");
INSERT INTO ded_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mitiac negen negengngic nga farisaio ngeni sowecnginagoc. Ngeni ngachodzec amangina wangecyunugec engsac kecgecde. Amma ngicngac yeneng negengngeree ngemmegecdeac ngeni nunumu hereangoc numuandae. Ngeni ikocfaka ifia angandaeac turunga ebiriangoc megecde. ");
INSERT INTO ded_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mitiac negen negengngic nga farisaio, ngeni ngic mocgu dekerecyoac ammigecdeac bangeha bangeha nga kondung ferecgema kengandae. Nga yeng ngenearu torokpeu mefahegec, ye ngenang isoc hofeac nambarac amma feracngunuma kemeude. Ikocfakangina ifia mekecdaeac ngeni sowecnginagoc. ");
INSERT INTO ded_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Sing edzac edzac ngic, ngeninoc kicpisic andae. Ngeni yoac yofi deandae, ‘Ngic mongngo Anutuac womong kpacma yoara deseriudeu, imoc yoac kapia. Nga mongngo womong manau gol tacde, imoc kpacma yoara deseriudeu ye yoara imoc naric mi waude.’ Ifi deandaeac ngeni sowecnginagoc. ");
INSERT INTO ded_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Womongngo gol kpanggeu kpetiac anude, imoc wiac engena nga gol yengenaoc imoc wiac mamea. Ngeni kicpisic nga negen negengngina mi irec ireckea. ");
INSERT INTO ded_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Amma ngeni deandae, ‘Mong ye arata kpacma yoara deseriudeu, imoc yoac kapia. Nga mongngo sese arata witiau bic faifaia, imoc kpacma yoara deseriudeu yoara imoc naric mi waude.’ ");
INSERT INTO ded_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Aratango sese kpanggeu kpetiac anudenoc, imocngo wiac engena nga sese yengenaoc imoc wiac mamea. Ngeni kicpisic areng. ");
INSERT INTO ded_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ngic mong ye arata kpacma yoara deseriudeu ye arata nga sese arata witiau fedacde, imoc momocngoc kpacma medarude. ");
INSERT INTO ded_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nga mong ye womong kpacma yoara deseriudeu womong yengena amma Anutu imohai kecde, ye momocngoc kpacma medarude. ");
INSERT INTO ded_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nga mong ye kurumeng kpacma yoara deseriudeu, ye Anutuac tatac nga yeng ihai mingina amma tarude, ye momocngoc medarude. ");
INSERT INTO ded_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mitiac negen negengngic nga farisaio, ngeni sowecnginagoc. Ngeni singyoac kapiabisic modacma dedeseriyoac engena, imoc ine wagecde. Ngeni ikocfakangina ifia meandae. Ngeni wiac homuna gombunga nga yakaac nga ic sogonggac homuna gombunga fingerude, imocac gbomea kapiabisic 10, imohacnac mocgu hendzicma Anutu miandae. Amma faka dindingac nga ubamangang amma negen negensingngina hafoangoc mekekec, imoc ine ihoc bahoc amma wagecde. Ngeni faka gombungngina imoc naric modacbisia amma tosea deduae, imoc ifingoc mi wabisia. ");
INSERT INTO ded_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ngeni ngicngac sing edzacyunugecdeac ua, imoc kicpisic siricfu angkecdae. Nga kurungnginau picpic hemma imoc meickema kamere ine mi hemma gbokoandae. ");
INSERT INTO ded_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mitiac negen negengngic nga farisaio, ngeni ikocfakangina yofia mekecdaeac ngeni sowecnginagoc. Ngeni tera tasengina ngadeasac dzuacandae amma ngenang ubaherengina manau ine kickerec homac fede, imoc ngenaoc mi garengemeandae. ");
INSERT INTO ded_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ge tase teraac mana dzuacnaguc ngadea ifingoc kongac kpeude. Farisaio ngeni kicpisic. ");
INSERT INTO ded_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mitiac negen negengngic nga farisaio ngeni yofi negenggec, kicsere imoc homemea seucnginagoc nga sicngo wake wakea fede, imoc kibiagoc anudeac ngeni kicsereac simeng weroc nadzicandae. Nga ngeni ubaherenginau nga sebinginau siriha ifia amma kecdae. ");
INSERT INTO ded_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ngeni sebinginango ngickicfu dindingac isoc ande. Nga ubaherenginau ine ikocngo wake wakea amma ngeni ngenaoc dedeseriyoac kpema kecdae. Ngeni ikocfakangina ifia mekecdaeac ngeni sowecnginagoc. ");
INSERT INTO ded_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mitiac negen negengngic nga farisaio, ngeni sebiengeneng amma ikocfakangina mekecdaeac sowecnginagoc andae. Ngeni profete yeneac kicsereu simengngina meyemmema ngic dindingac simengngina kibiagoc anudeac monggoc heigborima mengereandae. ");
INSERT INTO ded_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mengerema yofi deandae, ‘Neni bangecfocnina yeneac nasou kecbing debac profete naric mi yunuhomebing nga sacngina maudeac faka yenigoc mi ambing.’ ");
INSERT INTO ded_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ngeni ifi mekecma yofi dekperagiemedae, ‘Nenang ngic profete yunuhomegec, yeneac medacfocngina.’ ");
INSERT INTO ded_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ngeni ifi dema bangecfocngina yeneac faka mewakema mekecgecde. ");
INSERT INTO ded_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ngeni ngenaoc boidzoc amma boidzocac medac, ngeni yoacfu turunga mema hofeu kemebauac ");
INSERT INTO ded_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","neng profete nga negen negengngic amma mitiac negen negengngic sueyunuba hangemmegecde. Nga ngeneng kecma yenearunac goa yunuhomegecde nga goa mariponnu yunugecde amma goa kpekpeturang amanginau dzikacngo yunuma ngaba ayemmema taong monnunac monnu kporacyunugecde. ");
INSERT INTO ded_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngeni ifi mekecma ngic dindingac yunudacgec sacngina bangecfu madarec, imocac turunga hafoangoc ngenearu feude. Imoc Abeac sacfunac hanahema erekecma Barakiaac medac Dzekaraia, yeac sacfu erede. Ngeni ye kpetiac ama nga arata botucngirau kpehomegec. ");
INSERT INTO ded_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Foracngoc, faka sasawa imocac turunga, imoc areng yomoc ngenearu fingecdarude, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O, Yerusareng, Yerusareng, ge profete yunuhomeannec nga ngic gearu sueyunuyunuya, yeni hocngo yenereannec. Kokorec nonggeango nambaracfora kpeganga bageau foforacyunuande, ni naso homac ifi isoc nambaracfocga kpedzucyunubadeac negembare ngeneng ine imocac songo mi negenggec. ");
INSERT INTO ded_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Negenggec, ngeneac amagerec imoc ngiha kpac anu kisi fingerude. ");
INSERT INTO ded_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ni edengunuba negenggec, yofinenggac hanahema ngeni monggoc mi nenggecde. Nga nang enggecdeu yofi degecde, ‘Kebuac kpacfu ngic hade, ye kenehagoc.’ ifi degecde, naso imohai ngeneng monggoc nenggecde.” ");
INSERT INTO ded_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesungo womonnunac mamanu medacfora yeneng yearu hama womonggac mana kuneng hania hania edzahegec ");
INSERT INTO ded_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","yeng yofi edeyunuec, “Wiac imoc yaguc hendacdae, imoc ine ngade yofi fingerude. Foracngoc, areng mong yeneng hama imoc sasawa hembarackedacgec kendarude. Kendaru hoc mongngo monggac witiu mi wagec tarude.” Ifi dema ");
INSERT INTO ded_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesungo Oriwa tikiu kemma taru medacfora tembucngina yearu kemma kpesimigec, “Ge yoac dedang imoc noc nasou fingerude? Nga naso wisic wisickea amma geangga hahanasogau noc soi fingerude, imoc edenununa.” ");
INSERT INTO ded_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ifi degec Yesungo meremma yofi deec, “Ngic mongngo ikocfu wangecngunubacac ngeni henghomema kecbisia. ");
INSERT INTO ded_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Imoc yofiac, ngic homac yeneng hama neac kpac kpacma degecde, ‘Ni Messia.’ ifi dema ngicngac homac uba mesufu ayemmegecde. ");
INSERT INTO ded_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nga ewekpekpetoaac siduc bangec wegenaunac nga bangec hereaunac hau ngeni imoc negemma mi kpidohobisia. Wiac ifia fingecbeso nga nasongo imohaingoc bic mi wisickeude. ");
INSERT INTO ded_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bangec goa yeneng bangec ogofocngina yenigoc ewekpekpe anggecde. Nga ngictau monggac arengngo ngictau monggac areng yenigoc ngaba angemegecde. Nga boditoa bangec goau fingerude nga goau usoctoa meude. ");
INSERT INTO ded_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wiac gboria hanahema fingerudeac gadze kiande, ifi isoc ande. ");
INSERT INTO ded_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ifi fingeru ngicngac yeneng ngeni ngabafocnginaac mariu faingunugecde. Faingunugec ngaba yeneng ngunuma homecfu faingunugecde. Nga bangeha bangehaac ngicngac sasawa yeni neac kpacnaac amma ubango ukungunugecde. ");
INSERT INTO ded_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nga ngicngac homac yeni negemmangang amma wanuma yenaocngoc ogofocngina ngaba yeneac mariu faiemegecde nga ubango ukuemegecde. ");
INSERT INTO ded_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nga profete ikoha homacngo fingecma ngicngac homac ikocfu wangecyunugecde. ");
INSERT INTO ded_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Singyoac wawa faka imoc yadiude imocac ngicngac homac yeneac heresongogoc negengemeeme nga hoangemefaka nomaneude. ");
INSERT INTO ded_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nga ngic mongngo serima kecmanu naso wisickeude, yeng komoc kpeude. ");
INSERT INTO ded_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nga ngicngac yeneng eucererenggac siduc gombung yomoc edeyunugec dedekperagi imoc bangec sasawa sokodaru ngicngac yeni imoc negendacmagec naso wisickeude. ");
INSERT INTO ded_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Profete Danierengo wiac mangac manganea imocac yoac warac deec, imocngo ama kpetiacfu nanu henggecde. Ngic mong ye yoac yomoc osoude, yeng imoc negentegecbeso. ");
INSERT INTO ded_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Faka imoc fingeru ngicngac Yudaia bangecfu kecdae, ngeni worama tikiu embisia. ");
INSERT INTO ded_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nga mong ye ama witiau nande, ye wiac mong meudeac ama manau mi embeso. ");
INSERT INTO ded_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nga mong ye semeng uau nande, ye ngakpi hereha meudeac mi dzigenebeso. ");
INSERT INTO ded_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ngac heregoc kecdae nga nenggac sabac namuu meyunukecdae, yeni naso imohai ebicnginagoc anggecde. ");
INSERT INTO ded_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nga ngeni woragecdeac naso haude, imoc nomannasou me sabatanasou mi fingerudeac numubisia. ");
INSERT INTO ded_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Naso imohai kpendzeng kuneng yombong fingerude. Kpendzeng ifia bangec hanac hanaheaunacngoc erekecma yofinenggac mong mi fingerec amma ngade ifingoc mi fingecbesande. ");
INSERT INTO ded_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nga uameme imoc mi mewegenegecde isoc ngic mongngo komoc naric mi kpeude. Amma ngicngac isingyunuyunuya, ngeneac amma naso mewegenegecde. ");
INSERT INTO ded_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Naso imohai yoac mong yofi fingerude, ‘Henggec, Messia yei fingecde.’ me ‘Messia ye edi fingecde.’ Ifi degecde isoc ngeni mi negensingyunubisia. ");
INSERT INTO ded_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Imoc yofiac, Messia ikoha nga profete ikoha yeneng fingecma ngicngac uba mesufu ayemmegecdeac tobangyunuma faka morora nga faka kuhagoc engena megecde. Amma yeni sing meficgegecdeu ngicngac isingyunuyunuya ifingoc ikocfu wangecyunugecde. ");
INSERT INTO ded_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Negenggec, ni faka imoc fingerudeac bic edengunuba negendae. ");
INSERT INTO ded_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ngicngac goa yeneng yofi degecde, ‘Henggec, ye bangec kisiu kecde.’ Ifi degecdeu ngeni ihai mi kembisia. Me yofi degecde, ‘Ye yei ama manabisicfu tacde.’ Ifi degecdeu ngeni imoc mi negensinggebisia. ");
INSERT INTO ded_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Piratacngo wenac ere ereaunac heima wenac keme kemeau kpesiande. Nga Ngicac Medac haude, naso imohai siriha imocacsoc fingerude. ");
INSERT INTO ded_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Koec koec neng yeni fareng fede, imohai eacandae. ");
INSERT INTO ded_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Anu kpendzengtoa nasoya wisickeuguc wenackiwa kundung kpeu afokperagia mi fingerude. Asomeng yeni kurumennunac fotockema magec kurumenga kurumenga yeneac kuc sasawa kpemindzahegecde. ");
INSERT INTO ded_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Imohai Ngicac Medacac soi sawakebangau fingeru bangeha bangeha ngicngac sasawa yeni imoc hemma kiacsonggong anggecde. Ifi ammagec Ngicac Medacngo kurumenggac hoennu kuc nga kibikperagitoagoc hau henggecde. ");
INSERT INTO ded_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nga trampet udumengtoa kuneng fingecmanu ye angerofora sueyunuu yeneng kurumenga kurumenga noboc noboc amma bangec tegia noboc noboc 4 imohai kemma Kebu yengenaoc ngicngac meisingyunuec, yeni kpedzucyunugecde. ");
INSERT INTO ded_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Fig icngo hania edekpou angemmeu ngeni imoc negembisia. Fawa firitickema besaiu ngicngac yofi negengandae, wenac naso ande. ");
INSERT INTO ded_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nga wiac sasawa dedua, imoc fingeru ngeni imoc hemma ifingoc negembisia, Ngicac Medacac naso imoc bic wegenema hade amma ye nagu ngadeau nande. ");
INSERT INTO ded_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Foracngoc, areng yomoc ngeni mi homemagec wiac yomoc fingecdarude. ");
INSERT INTO ded_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Fingeru bangec nga kurumeng kpac anecde nga neac yoac, imoc ine mi kpac anude. ");
INSERT INTO ded_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Faka imoc noc uamemeu amma aua nofu fingerude, imoc mongngo mi negenude. Kurumenggac angero yeni imoc mi negendae nga Medacngo ifingoc mi negende. Manggacngosac naso imoc negende. ");
INSERT INTO ded_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noaac nasou faka fingerec, Ngicac Medacngo hau faka siriha imocngoc fingerude. ");
INSERT INTO ded_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kiatunggbaung mi hamanu ngicngac yeneng nenedoku nema ngic yeni ngacfu kenggec nga manggac yeneng yofi degec, ‘Ni naroanna ngic mibade.’ ifi angkecmagec Noango wageu enec. ");
INSERT INTO ded_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Enu yeni mi negemma kecmagec kiatunggbaungtoango hama merucyunudarec. Ngicac Medacac hahanasou faka ifiangoc fingerude. ");
INSERT INTO ded_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Naso imohai ngic yohockang semeng uau kecmaec yerearunac mong mema mong ine wagec uau kefude. ");
INSERT INTO ded_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ngac yohockang yeri flawa amau namma flawa medzamema kecmaec yerearunac mong mema mong ine wagec nanude. ");
INSERT INTO ded_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kebunginango noc uamemeac haude, ngeni imoc mi negendaeac amma ubagbori kecbisia. ");
INSERT INTO ded_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hamangecngic ye ama hetackema engande. Nga ama mingina mong ye hamangecngic noc nasou haude negendeu ye gaugbori kecma amea garenggekecma hamangecngic imoc kpae heimiude. ");
INSERT INTO ded_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Imocac ngeni ifingoc efaima kecbisia. Ngicac Medacac aua ngeni mi negemmagec haude. ");
INSERT INTO ded_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wanacngic mongngo negen negentegehagoc kefec. Nga minginango ye wanacngic ogofora yeneac gareng amma yakangina nasoyau modacma yemmeudeac demiec. ");
INSERT INTO ded_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ye ua demi demia imoc medaru minginango hama henu naric anude, ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Foracngoc, yeac minginango wiara sasawa garenggeudeac demiude. Ngeni siriha imocacsoc kecbisia. ");
INSERT INTO ded_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nga wanacngic mangana, ye ine yengenaoc negensiude, ‘Ni minginna naso herea kecmaguc haude.’ ");
INSERT INTO ded_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ifi dema wanacngic ye ogofora yunuma minggong ngic, yenigoc doku seria neude. ");
INSERT INTO ded_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ifi amma tomai mi kecma wanacngic yeng minginaac uamemenaso nga auaya mi negemmanu minginango haude. ");
INSERT INTO ded_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hama wanacngic imoc kpema herec kperecge heima ngic ikoha yenigoc faiude. Nga yeni ihai kiacma enacngina kisaranggema kecgecde.” ");
INSERT INTO ded_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kurumenggac eucerereng imoc yofi isoc anude. Naroang 10 yeni kifangina mema memeturang ngic yegoc meficemegecdeac sinnu kenggec. ");
INSERT INTO ded_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yenearunac naroang 5 yeni mi irec ireckea nga 5 yeni negen negengnginagoc. ");
INSERT INTO ded_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Naroang mi ireckegec, yeni kifangina mema kirung dokuyagoc mong mi megec. ");
INSERT INTO ded_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nga negen negengnginagoc, yeneng kifangina mema dokungina kirunnu kisima megec. ");
INSERT INTO ded_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nga memeturang ngicngo bic mi hau naroang sasawango kicngina gau anu gau fegec. ");
INSERT INTO ded_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Femagec tofocnac dzongiau kpakpac mong yofi fingerec, ‘Negenggec, memeturang ngic hade, ngeni kemma yegoc eacgec.’ ");
INSERT INTO ded_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ifi fingeru naroang 10 yeni gauunac gborima yacma kifangina memengere amma ");
INSERT INTO ded_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","naroang negen negengngina mi irec ireckea, yeneng negen negenggoc yeneac degec, ‘Kifanina bokobeso andeac ngeni doku mong kisinemmegec.’ ");
INSERT INTO ded_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ifi degec naroang negen negenggoc, yeneng merengyemmema yofi edeyunugec, ‘Doku yomocngo nenanggacsoc kpac. Imocac ngeni ine kifadokuya faiandae, yenearu kemma bummegec.’ ");
INSERT INTO ded_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ifi degec, yeni kifadoku bummebesonga kemmagec memeturang ngicngo haec. Hau naroang efaigecmoc, yeni yegoc memeturanggac amau enggec. Emma nagu ukugec kpeu imohai nenesemeng nesogai amma tacgec. ");
INSERT INTO ded_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tacmagec ngade ngac tosea yeneng hasikema degec, ‘Kebu, Kebu, nagu witinemmena ereni.’ ");
INSERT INTO ded_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ifi degec, yeng edeyunuec, ‘Foracngoc, ni kicrurungngunuduae.’ ");
INSERT INTO ded_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ngeni wenac nga aua mi negendae, imocac amma ngeni ubagbori kecbisia. ");
INSERT INTO ded_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Imohai faka siriha yofi fingerude. Ngic mongngo bangec monnu kenudeac wanacngicfora kpacyunuma dzofinaha yeneac mariu faima kenudeac negenec. ");
INSERT INTO ded_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ye dzo garenggegecdeac kucnginaac sirihau yofi hendzicma yemmeec. Ye ngic mong tarantong dzo 5 nga mong tarantong dzo yohockang amma mong tarantong dzo mocgu, dzo ifi yemmema kenec. ");
INSERT INTO ded_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kenu ngic tarantong dzo 5 meec, ye imohaingoc kemma emekpesi uaya mema tarantong dzo 5 torokpema meficgeec. ");
INSERT INTO ded_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nga ngic tarantong dzo yohockang meec, ye ifingoc kemma emekpesi uaya mema yohockang torokpema meficgeec. ");
INSERT INTO ded_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nga ngic tarantong dzo mocgu meec, yeng ine kemma mingina dzo miec, imoc mema bangec usuma tonggoma mesufuec. ");
INSERT INTO ded_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Anu mingingnginango naso herea kecma monggoc dzigene hama dzo yemmeec, imocac turunga kpoumigecdeac kpacyunuec. ");
INSERT INTO ded_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kpacyunuu ngic tarantong dzo 5 meec, yeng tarantong dzo 5 mong momoc mekemma deec, ‘Kunenna, ge tarantong dzo 5 nenna ni emekpesi uaya mema 5 monggoc torokpema meficgedua.’ Ifi deu ");
INSERT INTO ded_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","minginango yofi edeec, ‘Wanacngic gombunga yombong. Ge fakaga dindingac amma yoac modac modacfakaga soronga. Nga geng yoac modacma wiac kapia kpacgoc garenggedanggac wiac ebiriangoc garenggenadeac faigubade. Hana kunenggaac sogac sogaiu nerahafoc kecdede.’ ");
INSERT INTO ded_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nga ngic tarantong dzo yohockang meec, yeng ifingoc hama deec, ‘Kunenna, ge tarantong dzo yohockang nenna ni emekpesi uaya mema tarantong dzo yohockang monggoc torokpema meficgedua.’ Ifi deu ");
INSERT INTO ded_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","minginango yofi edeec, ‘Wanacngic gombunga yombong. Ge fakaga dindingac amma yoac modac modacfakaga soronga. Nga geng yoac modacma wiac kapia kpacgoc garenggedanggac wiac ebiriangoc garenggenadeac faigubade. Hana kunenggaac sogac sogaiu nerahafoc kecdede.’ ");
INSERT INTO ded_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nga ngic tarantong dzo mocgu meec, yeng ifingoc hama deec, ‘Kunenna, ge ngic gerea, imoc negenduae. Amma uau wiac heihomec mi amma foraya kpedziannec amma gbomea mong mi kpegima sifu foraya mesiannec. ");
INSERT INTO ded_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Imocac kengecnuu kemma tarantong dzoga bangecfu tonggoba feec wiacga imoc monggoc merenggenduae.’ ");
INSERT INTO ded_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ifi deu minginango yoara turunga yofi meremmiec, ‘Ge wanacngic mangana amma oyonga. Ni uau heihomec mi amma foraya kpedzianduae amma gbomea mi kpegima sifu foraya mesianduae, geng imoc bic negennec. ");
INSERT INTO ded_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ge imoc negemma dzona dzo tohonnu faina heikpegumekecgec saheu neng dzigenema dzona imoc nobohagoc mebai. ");
INSERT INTO ded_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Imocac ngeni tarantong dzo yearunac wangecma ngic tarantong dzo teng mekecde, ye migec. ");
INSERT INTO ded_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngic mong ye wiac mekecde, ye monggoc migec homac ebiriangoc anude. Nga mong ye wiac mi mekecde, yearunac wiac mekecdemoc, imoc ifingoc wangecgecde. ");
INSERT INTO ded_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wanacngic uaya gombunga mi medac, ngeni ine ye mema ngadeau kundunnu ukugec kemebeso. Ihai kecdae, yeni kiacma enacngina kisaranggema kecgecde.’ ");
INSERT INTO ded_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kecma Ngicac Medacngo kuc nga kibikperagiagoc nga angero sasawa yenigoc hasikegecde, naso imohai ye ngictau tataha kibikperagiagoc ihai emma tacbesande. ");
INSERT INTO ded_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Amma ye bangeha bangehaac ngicngac sasawa deu hama yeac kicfu kpedzucnedacgecde. Kpedzucnegec garengngo rama nga noning medereyunuande, yeng naso imohai ifi isocngoc medereyunuma ");
INSERT INTO ded_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","rama foiugeng nga noning ine kanaugeng faiyunuude. ");
INSERT INTO ded_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ifi amma ngictaungo ngicngac foiugeng yofi edeyunuude, ‘Ngicngac Mannaac kenecgoc, ngeni yei hagec. Ngeni maridzoming nga amabangecngina megec, imoc bicngoc bangec hanahema fingerecfunac ngeneac negemma faifaia. ");
INSERT INTO ded_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ni yakaac homeba ngeni yaka nenggec nga dokuac anenu doku nenggec neai. Nga kuriha kecbare ngeneng nenggareng anenggec. ");
INSERT INTO ded_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ni wambaac obohoba ngeneng wamba heinenggec. Amma hafei febare ngeni hama wirinugec. Nga witicamau kecbare ngeneng yugucnugec.’ ");
INSERT INTO ded_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ifi deu ngicngac dindingac yeneng yoac yofi meremmigecde, ‘Kebu, ge noc nasou yakaac anggenu gemma gumecguing me noc nasou dokuac anggenu gumecguing? ");
INSERT INTO ded_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Amma noc nasou kuric hana genggareng anggening me wambaac obohona gening? ");
INSERT INTO ded_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Amma noc nasoac hafei me witicamau tacmana gemma yugucguing?’ ");
INSERT INTO ded_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ifi degec ngictaungo yofi edeyunuude, ‘Foracngoc, ngeni munafocna kapiabisic yenearunac mocgunec ubangerec ammigec, imocacsoc ninoc anenggec.’ imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ifi dema kanaugeng nanggecde, yeneac yoac yofi edeyunuude, ‘Ngicngac sowecngunungunuya, ngeni wanuma gerec wisic wisickea kpac, imohai kemma kecbisia. Imoc mangana mingina nga angerofora, yeneac amma dzema fede. ");
INSERT INTO ded_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ni yakaac homeba ngeni yaka mong mi nenggec nga dokuac anenu ngeni doku mong mi nenggec neai. ");
INSERT INTO ded_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nga ni kuric hama kecbare ngeni nenggareng mong mi anenggec nga wambana kpac kecbare mong mi heinenggec. Ni hafei anenec nga witicamau febare ngeni mi yugucnugec.’ ");
INSERT INTO ded_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ifi edeyunuu yeneng degecde, ‘Kebu, ge noc nasou nenedokuga kpac me wambaga kpac amma kuric kecmana neni gemma ihoc bahoc aning? Me dahai hafeiamau me witicamau femana gemma ihoc bahoc anggening?’ ");
INSERT INTO ded_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ifi degec yeng yofi edeyunuude, ‘Foracngoc, ngeni munafocna kapiabisic yenearunac mocgunec ubangerec mi ammigec, imoc ifingoc ni mi anenggec, imoc edengunuduae.’ ");
INSERT INTO ded_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nga yeneng kopocsicac turunga kpendzeng nasoya kpac kpekecbesandaeac kenggecde. Nga areng dindingac yeneng kekecseriu enggecde.” ");
INSERT INTO ded_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesungo yoac imoc sasawa dedaru wisickeu medacfora yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Uameme yohockang femanu makekeng naso imocac hombang ammanu imohaingoc ngic yeneng Ngicac Medac mariponnu kpegecdeac demeseri amma suegecde.” ");
INSERT INTO ded_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Anu womong gareng enara nga yudangic yeneac enarafocngina, yeneng womong garengtoa kpara Kaifa, yeac amaodayagocfu endacma ");
INSERT INTO ded_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesu akikic mema kpegecdeac dekiric amma ");
INSERT INTO ded_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","yofi degec, “Ngicngac botucnginau dzikac sicsauc fingecbacac ye hombang nasou mi mebesonga.” ");
INSERT INTO ded_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Anu Yesungo Betania amau Simong kukuseriagoc, yeac amau yaka netarec. ");
INSERT INTO ded_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Netacmanu ngac mongngo yearu kemma, kirung mong arabastro hocngo memea, imocac kerecdokuya homung kerengagocngo yeac orucfu kpakema nadzicmiec. ");
INSERT INTO ded_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nadzicmiu medac yeneng imoc hemma kerecdoku buma yada anecac dehesi ammigec, “Ye nocac wiac buma engena imoc kpedzonggede? ");
INSERT INTO ded_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Imocngo dzo homac kirecgeu ngic makpekpea yemmeni ngereebac.” ");
INSERT INTO ded_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ifi degec Yesungo imoc negemma yofi edeyunuec, “Ngeni nocac ngacac ifi dema ubaebic meficgemidae. Ye faka gombunga nearu meu ngereede. ");
INSERT INTO ded_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ngic makpekpea yeni nasosoc ngenigoc kecgecde nga neng ine ngenigoc nasosoc mi kecbade. ");
INSERT INTO ded_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ni homeba tonggonugecde, ye imocac sebina mengerema bic nadzicnende. ");
INSERT INTO ded_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Foracngoc, ngic yeni siduc gombung yomoc bangeha bangeha kemma dekperagigecde, imohai yeng ifi anec, imoc ifingoc degec negenggec feude.” ");
INSERT INTO ded_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Anu medacfora 12 yenearunac mong Yuda Karioto amaunac degec, yeng womong gareng enara yenearu kemma ");
INSERT INTO ded_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kpesiyemmeec, “Neng Yesu maringinau faibadeu dzo dafiguc nenggecdeac negendae?” Kpesiyemmeu yeneng siriwa dzo 30 osoma migec. ");
INSERT INTO ded_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Migec, yeng Yesu naso damohai doc meu megecdeac hemmodacma kefec. ");
INSERT INTO ded_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kecma ic sogong yis kpac, hombang imocac hanac hanaheau medac yeni Yesuaru kemma kpesimigec, “Neni ama dahai kemma makekenggac ramamedaha mengerema ohonenideac negennec?” ");
INSERT INTO ded_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ifi degec Yesungo yofi deec, “Ngeni taonnu emma ngic imoc hemma yofi edebisia, ‘Kpoukpouninango geac yofi dede, nasona wegeneu gearu hama ni nga medacfocna neni gegoc makekenggac ramamedaha nenideac negenduae.’” ");
INSERT INTO ded_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nga Yesungo medacfora yoac edeyunuec, imoc tofohodacma makekenggac ramamedaha ohomengere anggec. ");
INSERT INTO ded_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ama toforeu Yesungo medacfora 12 yenigoc yaka netacma ");
INSERT INTO ded_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","yofi edeyunuec, “Foracngoc, ngenearunac mongngo ngaba yeneac mariu fainuude.” ");
INSERT INTO ded_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ifi deu medac yeni ubangina homac manganeu yenearunac mocgu mocgungo kpesimigec, “Kebu imoc sifu neng mi anduae, me?” ");
INSERT INTO ded_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kpesimigec yeng yofi deec, “Ngic nigoc kurungterau ic sogong nemuruckedic, yennoc doc faiu menugecde. ");
INSERT INTO ded_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngic ye Ngicac Medac doc meude, ye sowehagoc. Ye nonggeaac here manaunac mi fingecbac dede efaimibac. Nga Ngicac Medac neac negemma mitikibiu yoac yofi oho ohoya fede, yeng wangunuma kenudenoc.” ");
INSERT INTO ded_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ifi deu Yudango Yesu docfu faiudeac negenecmoc, yeng ifingoc kpesimiec, “Kpoukpou, ge neac denec me?” Deu Yesungo yofi edeec, “Ge geanggaoc imocnoc denec.” ");
INSERT INTO ded_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Anu yeni yaka nemagec Yesungo ic sogong mong mema Anutuac ubangerec dema mendzicma medacfora yofi dema yemmeec, “Ngeni mema negec, yomoc fusina.” ");
INSERT INTO ded_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Ifi dema kpakenec mong mema Anutuac ubangerec ammima numumima yofi dema yemmeec, “Yomocngo dzadzahac gboriaac sacna, imoc ngicngac homac yeneac kopocsic kpac anudeac kpetic kpetinggea, imocac ngeni sasawango imoc negec. ");
INSERT INTO ded_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ni edengunuba negenggec, waing gbomeaac dokuya monggoc mi nene kecbarengoc Mannaac eucererennu nenahafoc sing gboriaac arennu nenide.” ");
INSERT INTO ded_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nga yeni ubangerec yegec heima amaunac mama edibigeng Oriwa tikiu enggec. ");
INSERT INTO ded_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sinnu kemma Yesungo yofi edeyunuec, “Tofocnac yomohai ngeni sasawango neac negemma makpema wanudacgecde. Faka imocac yofi oho ohoya fede, ‘Ni gareng kpeba ramahabu yeni sinsararang kpegecde.’ ");
INSERT INTO ded_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nga homecfunac yacmaguc waraingemmema Gariraia bangecfu kemba ngeni ihai habisia.” ");
INSERT INTO ded_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ifi deu Petorongo edeec, “Goa yeni sasawa geac ifi dema wagugecde nga neng ine naric mi wagubade.” ");
INSERT INTO ded_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ifi deu yofi edeec, “Ni forangoc edeguba, tofocnac yomohai kokorec mi arohomanu geng sebiheinenna atac harebec anude.” ");
INSERT INTO ded_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Deu deec, “Ge guma ni nubeso degec sebi naric mi heibade.” Petorongo ifi deu medacfora meficgema imocngoc dedacgec. ");
INSERT INTO ded_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Anu Yesungo kengkecma ua bangec mong kpara Gedzemane, ihai kensikema medacfora yofi edeyunuec, “Ngeni yei tacmagec ni edi kemma numubade.” ");
INSERT INTO ded_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ifi dema Petoro nga Dzebedaio medahora meyunuu kenggec. Kemma Yesungo ubaebictoa yombong memanu dzonoma fedeu ");
INSERT INTO ded_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","yofi edeyunuec, “Ubaongana ebiriyombonggeu homebeso anende, imocac ngeni yei nigoc ubagbori tacmina.” ");
INSERT INTO ded_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ifi dema kpesima kemma kicmesuya bangecfu hetutuckema yofi numuec, “Manna, negenna angana andeu ge kpakenec yomoc meickena feracnuu. Amma neac songo kpac, geac songo nga negen negeng imocngo seribeso.” ");
INSERT INTO ded_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ye ifi numuma medac yenearu dzigene kemma yenenu gau fegec. Gau fegec yenemma Petoro yofi edeec, “Ngeni sifu aua mocguacsoc nigoc gaugbori kecgec. ");
INSERT INTO ded_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ngeni faitobannu embauac ubagbori kecma numugec. Foracngoc, ongaasungo efaiande nga sebingo ine ebiriude.” ");
INSERT INTO ded_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nga ye monggoc kemma yofi numuec, “Manggacna, kpakenec yomocngo feracnuudeac negenna mi ngereeu imoc nebare geac yoac seribeso.” ");
INSERT INTO ded_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ifi numuma hama henu medacfora yeni kicngina gaungoc anu fegec. Femagec yenemma ");
INSERT INTO ded_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","monggoc wayunu kemma numuu atac harebec anu yoac warac deec, imocngoc dema numuec. ");
INSERT INTO ded_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Numudacma medac yenearu dzigene hama yofi edeyunuec, “Ngeni gaungoc fema kecdae, imoc naric kpac. Naso wegenede, ngic yeni Ngicac Medac kererema kopocsicmeme yeneac mariu faigecde. ");
INSERT INTO ded_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Benukererec ngicngo hadeac amma yacgec kenni.” ");
INSERT INTO ded_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ye ifi dema nammanu medac 12 yenearunac ogongina Yuda, yeng ngichabutoa kuneng yombong enara waraiyemmeu hagec. Womong gareng enara nga yudangic enarafocngina yeneng sueyunugec wasaibeang nga gbarucnginagoc hasikegec. ");
INSERT INTO ded_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sikegec benukererec ngic yeng waraima faka anudeac derec derecgeyoac yofi bic edeyunuec, “Ngic titikokoc ammibade, ngeni ngic imocnoc mendanggema mebisia.” ");
INSERT INTO ded_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ifi dema yeng imohaingoc Yesuaru kemma, “Ohec, kpoukpou.” ifi dema titikokoc ammiec. ");
INSERT INTO ded_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ifi ammiu Yesungo yofi edeec, “Ogo, ge noc ua menadeac yei hadang?” Deu yeni hama Yesu maria noboc noboc mema mendanggegec. ");
INSERT INTO ded_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Anu ngic Yesugoc kecgec, yenearunac mongngo wasaibeanga kpedzima womong garengtoa yeac wanacngic kpema kedzaha noboc herecgeec. ");
INSERT INTO ded_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Herecgeu mau Yesungo yofi edeec, “Ngic mong ye dzikac kpeude turunga dzikacngoc kiude, imoc fingecgembacac wasaibeangga ameau monggoc faina kemeu. ");
INSERT INTO ded_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Neac memeficsing mong mi fede, imoc negemma ifi annec. Nga Manna yagucnoc numumibai dede yeng angero kpetengina 6 tauseng arenga 12, angero habutoa ifia naric sueyunuu mama meficnubau. ");
INSERT INTO ded_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nga meficnubau dede mitikibiu faka yomoc fingerudeac oho ohoya fede, imoc fora mi fingecbac.” ");
INSERT INTO ded_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ifi dema ngichabu yofi edeyunuec, “Ngeni mendannuma godzungic meandae, ifi isoc wasaibeang nga gbarucnginagoc hadae. Nga ni wenaha wenaha Anutuac womonnu edekpou angemmema kecanduae, imohai ine naric menubau. ");
INSERT INTO ded_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amma yoc ine profete yeni mitikibiu yoac ohogec fede, imoc fora fingerudeac imoc sasawa fingecdacde.” Ifi deu medacfora sasawango Yesu wama woradacgec. ");
INSERT INTO ded_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Anu mitiac negen negengngic nga yudangic enarafocngina yeni womong garengtoa Kaifa yeac amau bic kpedzucnema tacgec, ihai Yesu wangecma kenggec. ");
INSERT INTO ded_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yeni Yesu mendanggema ifi mekemmagec Petorongo ngadenginau hereaungoc Yesu modacma kenec. Kensikema, Yesuac yoac desigecde, imoc negenudeac womong garengtoaac ama imocac oda manau kemema uamedac yeneac botucfu matarec. ");
INSERT INTO ded_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Anu womong gareng enara nga yudangic tutumangtoaac memba yeni hafoangoc tacma Yesu homecfu faigecde nga ye enacfu faifai ammima boi anggecdeac negengising anggec. ");
INSERT INTO ded_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ifi anggec ngic homacngo hama enacfu faifaiyoac degec, imocngo Yesu homecfu faigecdeacsoc mi anu hofocmangoc kecma ngic yohockang yereng fingecma boi amma deoc, ");
INSERT INTO ded_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Yesungo yofi deec, ‘Ni Anutuac womong hembarackema uameme harebec ammanu monggoc mebade, ni kucna imocacsoc fede.’” ");
INSERT INTO ded_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ifi deec womong garengtoango yacma Yesu kpesimiec, “Geac yoac dedae, imocac noboha mong mi denade me?” ");
INSERT INTO ded_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ifi deu Yesungo ine waickema nanec. Nanu womong garengtoango edeec, “Anutu kekec mingina, yeac kicfu kpesigemba ge deserina, geng Messia Anutuac medac me kpac, imoc edenununa.” ");
INSERT INTO ded_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ifi deu yeng meremma yofi edeec, “Imoc gennoc denec. Nga edengunuba negenggec, yaguc nga namma enude Ngicac Medacngo Kuctoa Minginaac foiaugeng tarude. Amma ye kurumenggac hoeng witiau hau ngeni imoc henggecde.” ");
INSERT INTO ded_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ifi deu womong garengtoango yoac imoc negemmanganema wambaya membarackema yofi deec, “Ye Anutu bic emmidacac yoacninaac boingicac monggoc mi obohonide. ");
INSERT INTO ded_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngeneng yoac imoc negemma dafi dedae?” Deu yeneng meremmigec, “Ye homeudeac arennoc.” ");
INSERT INTO ded_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ifi dema yeni Yesu kicmesuya sofohoma mari tuema kpekpefac ammigec nga goa yeneng dzikacngo kpema ");
INSERT INTO ded_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","degec, “Messia, merang gudac, imocac kpefingyoac edenununa.” ");
INSERT INTO ded_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ifi amma kecmagec Petorongo oda manau ama sobennu tarec. Tacmanu wanac naroang mongngo yearu kemma deec, “Ge gariraiangicnoc Yesugoc kecannec.” ");
INSERT INTO ded_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Deu ye ngic sasawa tacgec, yeneac kicfu sebi heima deec, “Ge yoac denec, imoc obohoduae.” ");
INSERT INTO ded_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ifi dema naguu kemmanu wanac naroang mongngo hemma ngicngac ihai nanggec, yeni edeyunuec, “Ngic imoc ye Yesu Nadzaretenac, yegoc kecandenoc.” ");
INSERT INTO ded_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Edeyunuu Petorongo Anutuac kicfu serima monggoc busickpema deec, “Ni ngic imoc mi negenduae.” ");
INSERT INTO ded_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ifi dema nammanu ngic yeneng Petoroaru kemma degec, “Neni ubadzidziga negendimbe, ge foracngoc yeneac arennunac.” ");
INSERT INTO ded_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Edegec ye yengenaoc sowecemema sopecemema deec, “Ni ngic imoc mi negemmiduae.” Deu imohaingoc kokorecngo arohoec. ");
INSERT INTO ded_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nga Yesungo yoac yofi bic edeec, “Kokorecngo mi arohomanu geng ni mi negennunec dema sebiheina atac harebec anude.” Petorongo yoac imoc negensima kemema ubahodung kuneng negemma kiac hodung kiarec. ");
INSERT INTO ded_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ama wereckenu womong gareng enara nga yudangic enarafocngina yeni uba mocgu amma Yesu homeudeac deserigec. ");
INSERT INTO ded_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Deserima Yesu maria dedeckema Yudaia bangecac gawana Pirato, yearu mekemma yeac mariu faigec. ");
INSERT INTO ded_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Anu Yesu homeudeac deserigec, Yuda benukererec ngicngo imoc hemma deec, “Ni nocac ifi andua?” Ifi dema ubea manganeu siriwa dzo 30 migec, imoc mekemma womong gareng enara nga yudangic enarafocngina yeni monggoc merengyemmema ");
INSERT INTO ded_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","edeyunuec, “Negenggec, ni kererema ngic kopocsiha kpac, ye sac nadzicmiai.” Ifi deu yeneng degec, “Imoc neneac ebic kpac, imoc geac ebic.” ");
INSERT INTO ded_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yeni ifi dema dzo wagec, yeng imoc mekemma womonnu ukuu enu wama kemma ubasac neec. ");
INSERT INTO ded_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nga womong gareng enara yeneng siriwa dzo imoc kpedzucnema degec, “Dzo imocngo sac bummeec. Imocac amma dzo imoc sesekatapau faifai, imoc singngo mi dede.” ");
INSERT INTO ded_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dema yeni yoac dedzege amma dzo imocngo kuric yeneac kicsere fingerudeac enang kudzimemengic yeac ua bangec bummegec. ");
INSERT INTO ded_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bummegec bangec imocac kpara Sacbangec hanahema degec nga imoc yaguc fedengoc. ");
INSERT INTO ded_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Profete Yeremiango yoac yofi deec, imoc imohai foragoc anec, “Faka yofi fingerudeac Kebungo edenuec, Israe medacfora yeni ngic imocac buma kpetea faima, “Ye siriwa dzo 30 imocacsoc.” ifi degec. Nga yeni dzo imoc mema imocngo enang kudzimemengic yeac ua bangec bummegec.’” ");
INSERT INTO ded_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Anu yeni Yesu mekemma gawanaac kicfu faigec nammanu yeng kpesimiec, “Ge yudangic yeneac ngictau me?” Ifi deu Yesungo yofi meremmiec, “Imocnoc geanggaoc denec.” ");
INSERT INTO ded_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Anu womong gareng enara nga yudangic enarafocngina yeneng namma haniaya degec Yesungo yoac turunga mong mi merengyemmeu ");
INSERT INTO ded_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Piratongo kpesimiec, “Yeni yoacfu faiguma yoac homac yombong dedae, ge imoc mi negennec me?” ");
INSERT INTO ded_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Deu yeng yoac monnec mong mi merenu gawanango kerectegec yombong anec. ");
INSERT INTO ded_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Anu gawanango hombannu yofi angkefec, yuda ngichabu yeni witicngic monggac kpara kpacgec, yeng ngic imoc yungeru witicamaunac maande. ");
INSERT INTO ded_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Naso imohai godzungic kpara kekena mong witicamau kefec, kpara Baraba. ");
INSERT INTO ded_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nga ngicngac kpedzucnedacma nammagec Piratongo yofi kpesiyemmeec, “Merac yungecngemmebadeac negendae, Baraba me Yesu, kpara mong Kristo deandae?” ");
INSERT INTO ded_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yudangic yeni Yesu eng keracmangang ammima yearu faigec, imoc negemmanoc ifi deec. ");
INSERT INTO ded_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nga Pirato ye desi desi tatahau tacmanu enemango yearu yoac yofi faiu kenec, “Ge ngic kpetiac yomocac yoac mi kpeserena, imoc wana. Ni tofocnac fema gaukpefing hemma yeac amma ubaebic homac medua.” ");
INSERT INTO ded_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nga womong gareng enara nga yudangic enarafocngina yeneng habu fenggeyemmegec yeneng Baraba yungecyemmeudeac degec nga Yesu ine kpehomegecdeac degec. ");
INSERT INTO ded_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nga gawanango kpesiyemmeec, “Ngic yohockang nandape yerearunac merac yungecngemmebadeac negendae?” ifi deu yeni imohaingoc degec, “Baraba.” ");
INSERT INTO ded_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ifi degec kpesiyemmeec, “Ifi anu Yesu, kpara mong Kristo deandae, yeac dafi ambade?” Kpesiyemmeu yeni sasawango degec, “Ye mariponnu kpena homeu.” ");
INSERT INTO ded_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ifi degec, yeng kpesiyemmeec, “Imoc dafiac nga noc kopocsicac?” Ifi deu yeni arohomumunggema degec, “Ye mariponnu kpebesonga.” ");
INSERT INTO ded_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ifi dema nanggec hemma Piratongo yoac dindingac deudeac obohoec. Nga yeni ine serima kpacma nanggec kpeborongtoa hanahema fingeru yeng doku mema ngicngac habutoa kicnginau namma maria dzuacma yofi deec, “Ngic yomocac sacac kopocsic, imocngo nearu mi tacbeso, imoc ngenearu febeso.” ");
INSERT INTO ded_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ifi deu ngicngac yeni sasawango yoara meremma degec, “Yeac sacac kopocsicngo neni nga nambaracfocnina nenearu febeso.” ");
INSERT INTO ded_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nga Pirato ye Baraba yungecyemmema Yesu ine dzikacngo kpema mariponnu kpegecdeac wasaingic maringinau wayemmeec. ");
INSERT INTO ded_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Anu gawanaac wasaingicfora yeneng Yesu ama manaunac memama ama tegiau wasaingic oda manau kecandae, imohai meemma wasaiareng sasawa hafoangoc kpedzucnegec. ");
INSERT INTO ded_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kpedzucnedacma Yesu yengena wamba hesimima ngakpi mong kpauc kpauc heimigec kemeu ");
INSERT INTO ded_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","somang batihema oruhau heimigec kemeec. Kemeu yasu mong memigec marifoiango mema nanec. Ifi amma kiwau fafoc heima defagoc ammigec, “Ohec, yudangic yeneac ngictau.” ");
INSERT INTO ded_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Amma yeni sofohoma yasu wangecma imocngo oruhau kpegec. ");
INSERT INTO ded_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Defagoc ammikecgec wisickeu yenang ngakpi hesimima yengena wamba monggoc heimigec kemeu mariponnu kpegecdeac hesicke kenggec. ");
INSERT INTO ded_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mekemma sinnu ngic mong meficgegec, kpara Simong, Kirene taonnunac, yeng Yesuac maripong tofohoudeac ngombonggegec tofohou kenggec. ");
INSERT INTO ded_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kengkecma bangec buma mong kpara Gorigata, kpara mong Hatasic degec, ihai kensikegec. ");
INSERT INTO ded_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kensikema waing doku wiac hodungagocngo yerec yerecgea, imoc gumegec ye imoc nenegemma waec. ");
INSERT INTO ded_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nga yeni ye mariponnu kpegec nammanu wambaya kpeing kpema mederegec. ");
INSERT INTO ded_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ifi amma garenga tacgec. ");
INSERT INTO ded_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nga ye nanu oruha witiau maripongau kopocsicac haniaya yofi ohogec, “Yomoc Yesu, yudangic yeneac ngictau.” ");
INSERT INTO ded_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Anu yeni godzungic yohockang yegoc momoc mariponnu yuruma mong foiugeng nga mong kanaugeng, ifi faiyurugec. ");
INSERT INTO ded_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nga ngic ihai kengha anggec, yeni Yesu deengdema ammima orucngina kpatitickema ");
INSERT INTO ded_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","degec, “Ge Anutuac womong hembarackema wenac harebec ammanu medacbesonga denec, ge geangga onggongemena. Nga Anutuac medac kecnec isoc mariponnunac mesiemema mana.” ");
INSERT INTO ded_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nga womong gareng enara nga mitiac negen negengngic amma yudangic enarafocngina yeneng ifingoc desusuic ammigec, ");
INSERT INTO ded_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ye ngic goa onggongyunukefec nga yengena ine naric mi onggongemeude. Ye israengic nenang ngictau kecdeu mariponnunac mesiemema mau ye negensinggenide. ");
INSERT INTO ded_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ye yofi dema negen negensinga Anutuaru faiec, ‘Ni Anutuac medac.’ ifi deu Anutungo yeac ammikecdeu mesibeso.” ");
INSERT INTO ded_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nga godzungic yegoc momoc yurugec, yeri yoac siriha ifiangoc deendema ammioc. ");
INSERT INTO ded_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Anu wenac dzongiau 12 kiroc ammanu imohai ama kundung kpema kundungngo bangec sokoma fekemmanu 3 kiroc marai anec. ");
INSERT INTO ded_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nga 3 kiroc imohai Yesungo ubaudumeng kunengngoc kpacma yofi deec, “Eri, Eri rema sabaktani.” Imocac titiha yofi, Anutuna Anutuna, ge nocac wanudang? ");
INSERT INTO ded_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Anu ngic nanggec, yenearunac goango negemma degec, “Ye Eria kpacsambic ammide.” ");
INSERT INTO ded_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ifi kparu ngic mongngo negemma gereagoc nedzima kemma kondung sobing mong mema waingdoku aengagocfu nemuruckema kpinnu faima Yesu gumeec. ");
INSERT INTO ded_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nga goango ine degec, “Ngeni imoc wagec, Eria foracngoc hama meficgeu henni.” ");
INSERT INTO ded_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nga Yesungo monggoc ubaudumeng kunengngoc kparu asuya ereec. ");
INSERT INTO ded_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ereu homeec, imohaingoc Anutuac womonnu kpoructoa womongmana kpetiac yombong naguyau nanec, imocngo wihacnac botuhaungoc tohoma mama yohockang anec. Amma usoctoa meu fagannu hoctoa toa tohogec. ");
INSERT INTO ded_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nga kicsere fekenec, imoc anggeu ngic kpetiac warac homegec, yenearunac homacngo sebigoc gborigec. ");
INSERT INTO ded_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesungo kicsereaunac gborima yaru yeni ngade kicserenginaunac erema taong kpetiac, imohai hama ngic homac fingecyemmegec. ");
INSERT INTO ded_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nga wasaigareng nga ngicfora Yesuac gareng nanggec, yeni usoc nga wiac fingerec, imoc hemma damuyunuu wareckema degec, “Foracngoc, ngic yomoc ye Anutuac medacnoc.” ");
INSERT INTO ded_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nga Yesu kpegec, imohai ngac homacngo araing namma wiac hennegeng anggec. Yeni Gariraia bangecfunac hanahema Yesu modacma hama kingang kpemigec, ");
INSERT INTO ded_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","yenearunac ngac goa kpacngina yofi, Maria kpara mong Madara amma Maria mong, Yakobo nga Yosefe, yereac nonggongira amma ngac mong Dzebedaioac medahora, yereac nonggongira, yeneng ngachabu yenigoc nanggec. ");
INSERT INTO ded_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Anu Arimataia taonnunac ngic mong finactoayagoc, kpara Yosefe, yeng Yesuac yoac negemma yeac arennu ifingoc kefec. Ye ama toforebeso ammanu ");
INSERT INTO ded_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Piratoaru kemma Yesuac fareng meudeac kpesimiec. Kpesimiu Piratongo migecdeac deu wamigec. ");
INSERT INTO ded_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wamigec Yosefengo Yesuac farenga mema linengkporuc mong kongaha, imoc mema imocngo tembonggema mekenec. ");
INSERT INTO ded_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mekemma yengena kicsere gboria dema hocsirau singa usu usuya feec, Yesuac fareng imohai faima hocyada mong kpedidinggeu kicsere naguya imocngo hedzickeu taru kenec. ");
INSERT INTO ded_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Anu Maria Madara nga Maria ogea yereng kicsere naguya nonongkac ihaigeng fiec kenu taroc. ");
INSERT INTO ded_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wereckengau sabata asoac anu womong gareng enara nga farisaio yeni kpeturanggema Piratoaru kemma ");
INSERT INTO ded_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","degec, “Kunennina, ikocngic imocngo gbori kecmangoc, yoac mong deec, neni imoc negensidimbe, imoc edeguni negenna, ‘Ni homema wenac harebec ammanu Anutungo homecfunac megborinuu monggoc yacbade.’ ");
INSERT INTO ded_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nga medacfora yeneng kemma farenga hamangec meworagec, ifi debauac, ‘Ye homecfunac yacdac.’ imocac ge kicsere garenggegecdeac edeyununa uameme harebec garenggebisia. Warac ikoc mong anec, imoc femanu ngadeac ikocngo witiau enu yadibacac imoc edegudimbe.” ");
INSERT INTO ded_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ifi degec Piratongo yofi edeyunuec, “Naric, wasaingic ngemmeba ngeni wangecyunu kemma kicsere garenggegecdeac kuc mekecdae, imocac sirihau garenggebisia.” ");
INSERT INTO ded_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ifi deu yeni kemma kicsereac hocnagu mi kpedidinggegecdeac witiau kpae faigec. Faima wasaingic yeneng gareng nanggecdeac edeyunugec. ");
INSERT INTO ded_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabata naso wisickeu sonda gboria hanac hanaheau ama werec wereckenggac Maria Madara amma Maria ogea, yeri kicsere hembesonga kenoc. ");
INSERT INTO ded_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kemmaec Kebuac angero mongngo kurumennunac mau usoctoa kucbiricngoc meu yeng kicsereac hoc kpedidinggeu kenu witiau emma tarec. ");
INSERT INTO ded_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tarec, ye siriha pirac pirac siric nga wambaya kongac kongac hoeng isoc. ");
INSERT INTO ded_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nga gareng yeneng ye hemma kengecyunuu dzonongngina fedeu homebesonga amma fekenggec. ");
INSERT INTO ded_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nga ngac yeri kensikemaec angerongo yofi edeyuruec, “Ngeri mi kengecnguruu, ngeri Yesu mariponnu kpekpea, ye hembeso hadape, imoc negenduae. ");
INSERT INTO ded_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nga ye ine yei mi fede. Ye edengunuecmoc, ifi yacdac. Ngeri yoc hama fefea henec. ");
INSERT INTO ded_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ngereng imoc hemma bic kemma medacfora yofi edeyunuec, ‘Yesungo homecfunac bic yacdac. Ye waraingemmema Gariraia bangecfu kenu ngeni ihai kemma meficgegecde.’ Yoac imoc yagucnoc edenguruba negendape.” ");
INSERT INTO ded_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ifi anu yeri kicsere wama damu nga sogac sogaitoagoc medacfora siduc edeyunugecdeac nedzima bic kenoc. ");
INSERT INTO ded_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nedzi kemma Yesugoc ewacgec yeng yofi deec, “Wenacngerec.” ifi deu yeri hoangau ngonducnema haniau mema afeheoc. ");
INSERT INTO ded_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nga Yesungo yofi edeyuruec, “Ngeri mi kengecnguruu. Ngeri kemma tosofocna Gariraia bangecfu kenggecdeac edeyunuec, yeni ihai kemma nenggecde.” ");
INSERT INTO ded_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Anu ngahoc yeri kemmaec wasai ngichabu kicsere garenggegec yenearunac goango taonnu emma wiac fingerec, imocac siduc womong gareng enara edeyunudacgec. ");
INSERT INTO ded_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Edeyunugec yeni yudangic enarafocngina yenigoc adzorogec. Adzoroma yoac deserima wasaingic kicsere garenggegec, yeni yoac degecdeac dzo imocacsoc yemmema ");
INSERT INTO ded_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yofi dema deracyunugec, “‘Neni tofocnac gau femina yeac medacfora yeneng hama farenga hamangec medau.’ ngeni ifi debisia. ");
INSERT INTO ded_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nga gawanango yoac imoc negemma wiac mong angemmebacac mi kengecngunubeso. Neneng demekiri naric amminide.” ");
INSERT INTO ded_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ifi dema edeyunugec wasaingic yeni dzo imoc mema yoac ede edeyunuya, imoc deyadigec. Ikocyoacngina imocngo yudangic yenearu sokoma feecngo fedengoc. ");
INSERT INTO ded_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Anu medac 11 yeni Gariraia bangecfu tiki mong Yesungo bic derecgeyemmeec, ihai enggec. ");
INSERT INTO ded_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Emma yengena hemma afehegec nga ngic mocgu mocgungo ine ubayohoc anggec. ");
INSERT INTO ded_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nga Yesungo kicnginau hama yofi edeyunuec, “Negenggec, bangec nga kurumenggac kuc sasawa ni bic nendac nendara. ");
INSERT INTO ded_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Imocac ngeni kemma ngicngacareng sasawa neac sing negemma yoac modac modacareng anggec ngeneng meyunuma yenenggareng ayemmebisia. Amma ngeneng Manggac nga Medac amma Tiri Asu yeac kpacfu doku nadzicyemmebisia. ");
INSERT INTO ded_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nga neng yoac sasawa dederecge angemmekefai, ngeni imoc hafoangoc modacdacgecdeac kpouyemmebisia. Amma negendae, ni wenaha wenaha ngenigoc kecbare naso wisickebesande.” ");
INSERT INTO ded_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yomoc Yesu Kristo Anutuac Medac, yeac siduc gombung hanahema fingerec, ");
INSERT INTO ded_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","imocac siduc. Profete Yesaiango yofi ohoec, “Negenna, ni siducdedena sueba yeng waraigemma singga mengeregenude. ");
INSERT INTO ded_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nga bangec kisiu kpakpac mong yofi fingerude, ‘Ngeni Kebuac sing wisima singa heitumeigec.’” ");
INSERT INTO ded_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yoac imocac sirihau Yohanengo haec. Hama bangec kisiu kecma ngicngac ubangina dzigeneu kopocsicngina kpac anudeac mitidoku nadzicgecdeac edekpou ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nga ngicngac yeni Yudaia prowins nga Yerusareng taonnunac amanene yearu kenggec. Kemma kopocsicngina deficgemagec yeng Yodang dokuu namma doku nadzicyemmeec. ");
INSERT INTO ded_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane ye ngakpia kamere dzoeango memea, imoc heima fadenga mong yangseberango memea, imocngo kebangau dzegeec. Amma ye ipua nga kateac kukundzau nekefec. ");
INSERT INTO ded_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ye ngicngac yoac yofi edekpou ayemmeec, “Ngic neac ngadeu haude, yeac kucngo neac kuc ferahade. Ni ifiango ngonducnema yeac hanitabea witiha yungecba naric mi ngereeude. ");
INSERT INTO ded_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ni doku nadzicngemmeduae nga yeng hama Tiri Asungo nadzicngemmeude.” ");
INSERT INTO ded_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naso imohai Yesungo Nadzarete taong Gariraia bangec wama Yodang dokuu hasikeec. Hasikeu Yohanengo doku nadzicmiec. ");
INSERT INTO ded_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nadzicmiu Yesungo dokuunac eremanu imohaingoc kurumeng anggeu Asungo kebesacac siric amma yearu mau henec. ");
INSERT INTO ded_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hemmanu kurumennunac enacudumeng mong yofi fingeru negenec, “Ge neac songomedacna, ni gengsongo anggenduae.” ");
INSERT INTO ded_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nga imohaingoc Asungo Yesu sueu bangec kisiu kenec. ");
INSERT INTO ded_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kemma uameme 40 kecmanu Satangngo ye tobanggeec. Tobanggeu imohai kateyang yenigoc kecmanu angero yeneng henggareng ammigec. ");
INSERT INTO ded_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ngic yeneng Yohane witicamau faigec tacmanu Yesungo Gariraia bangecfu kemma Anutuac siduc gombung edekpou ayemmema ");
INSERT INTO ded_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","yofi deec, “Naso bic hau Anutuac eucererengngo mewegenengunudeac ngeni ubangina dzigeneu siduc gombung negensinggegec.” ");
INSERT INTO ded_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Anu Yesungo Gariraia dzohong tegiau kengkecma Simong nga munea Anderea yerenu yeri uficngira ukuma nanoc. Nocac yeri kondungyang meme ngic. ");
INSERT INTO ded_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeremma Yesungo yofi edeyuruec, “Ngeri hama modacnuec ngic yeneng kondungyang meandae, ngeri ifi isoc ngicmeme ua meecdeac kpoungemecbade.” ");
INSERT INTO ded_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ifi deu yeri imohaingoc uficngira wama Yesu modaroc. ");
INSERT INTO ded_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nga yeni kapianec kemma Yesungo Dzebedaioac medahora Yakobo nga munea Yohane yerenec. Yeri gombau uficngira memengere amma taroc. ");
INSERT INTO ded_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tarec yeng yeremma kpacyuruu yeri negenoc. Negemma imohaingoc mangngira Dzebedaio nga ua ngicfora gombau tacmagec wayunuma Yesu modaroc. ");
INSERT INTO ded_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Anu yeni Kafanaung taonnu kensikegec. Kensikemagec sabata naso anu Yesungo kpekpeturang amau emma Anutuac yoac kpouyemmeec. ");
INSERT INTO ded_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kpouyemmeu ngicngac yeneng kpoukpouyoara negemma imoc negenggec engena anec. Ye kpouyemmeec, imoc ngic uakibi mekecdae, yeneac siricfu kuhagoc amma mitiac negen negengngic yeneac dede isoc mi deec. ");
INSERT INTO ded_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Anu naso imohaingoc kpekpeturang amau ngic mong asu seuhagocngo tacma arohoec. ");
INSERT INTO ded_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu Nadzarete mingina, neneac wiac imoc geac mi ande. Ge memanganenununadeac hanec me? Ni gensiduaenoc, ge Anutuac kpetiac ngic.” ");
INSERT INTO ded_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ifi deu Yesungo asu seuhagoc ngaba ammima yofi edeec, “Ge waickema ngicfunac erema kenna!” ");
INSERT INTO ded_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ifi deu asu seuhagocngo ngic mekpefac ammima kucgoc arohoma erema kenec. ");
INSERT INTO ded_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kenu ngicngac sasawango kerectegec amma yenaocngoc kpesiemegec, “Imoc noc wiac? Imoc kpoukpou gboria nga yeng ua minginaac kuhagoc kpounemmeu asu seuhagoc ifingoc yoac edeyunuu yeni yoara negemma tofohogec.” ");
INSERT INTO ded_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nga siduhango Gariraia prowinsiu bic kemma sokodarec. ");
INSERT INTO ded_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Anu yeni kpekpeturang amaunac mama Yakobo nga Yohane yerigoc Simong nga Anderea yereac amau kenggec. ");
INSERT INTO ded_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kemma enggec, imohai Simong sefena sebigerec ammiu feec, imoc Yesu edegec. ");
INSERT INTO ded_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Edegec Yesungo yearu kemma mariau mema miaru imohaingoc hafeia kpac anu yenenggareng ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ifi anu wenac kiwa kemeu ama tofore hamanu ngicngac yeneng hafeigoc nga hadehade amma yafinggoc sasawa Yesuaru meyunu kenggec. ");
INSERT INTO ded_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nga taonggac ngicngac sasawa yeni ama naguyau kpedzucnegec. ");
INSERT INTO ded_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kpedzucnemagec Yesungo ngicngac hafeingina hania haniagoc mengereyunuma hadehade nga yafingngina homac kporarec. Nga hadehade nga yafing kporacyunuec, yeni haniaya negenggecac yoac degecdeac dederac ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Anu ama mi wereckemmanu Yesungo kundunnungoc yacma ama wama bangec botuc mong ngiha kpacfu kemma numuec. ");
INSERT INTO ded_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Numuu Simong nga tosofora yeni ye hofockemma meficgema edegec, “Ngicngac sasawango ge hofocgudae.” ");
INSERT INTO ded_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ifi degec yofi edeyunuec, “Nenang taong goa wegenac tackende, imohai ifingoc kemma yoac edekpou ayemmebade. Nocac ua imocnoc mebadeac hadua.” ");
INSERT INTO ded_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ifi deu yeni Gariraia bangec yerecge kenggec. Kemma kpekpeturang amasoc yeng yoac edekpou ayemmema hadehade nga yafing kporacyunuec. ");
INSERT INTO ded_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Anu ngic kubecserigoc mongngo yearu hama fafoc heima desambic ammima deec, “Geng negenna naric anu naric medzuacnubang.” ");
INSERT INTO ded_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ifi deu Yesungo ubea manganeu maria sinema ngic kpeserema yofi deec, “Ngereenadeac songona fede.” ");
INSERT INTO ded_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Demanu imohaingoc kubeha mosiu sebia ngereec. ");
INSERT INTO ded_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ngereeu Yesungo ngic derahema suema yofi deec, ");
INSERT INTO ded_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Negenna, sebigau faka fingecdac, imocac ngic mong mi edebesena. Ge womong gareng yearu kemma sebiga edzahema Mosengo seseac deec, imocac sirihau modacma faibesena! Ge ifi faina yeneng sesega hemma negentegecgecde.” ");
INSERT INTO ded_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ifi deu yeng ine kemma siduc imoc sifu deyadiec. Imocac amma Yesungo taonnu fingec fingec monggoc mi enec. Ye ine ngadeau bangec kisiu kecmanu ngicngac noboc nobocnacngo yearu hakecgec. ");
INSERT INTO ded_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Uameme goa wisickemanu Yesungo monggoc Kafanaung taonnu kenec. Kenu ngicngac homacngo imoc negemma ama wakema naguya hedzickemagec yeng Anutuac yoac edekpou ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ammanu ngic 4 yeneng ngic mong hanimaria homemea tofohoma yearu mekenggec. ");
INSERT INTO ded_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mekenggec ngic homacngo nanggecac hoangau faigecdeac obohoma ama witiau enggec. Emma ama bubuya meickegec titinga fingerec. Fingeru yeni Yesu nanecfu imohai ngicpuring dzakeagoc faigec kemeec. ");
INSERT INTO ded_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kemeu Yesungo negen negensingngina hemma ngicpuring yofi edeec, “Medacna, kopocsicga bic wawaya.” ");
INSERT INTO ded_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ifi deu mitiac negen negengngic goa ihai tacgec, yeneng ubanginau yofi negenggec. ");
INSERT INTO ded_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ngic imoc ye nocac yoac ifi dema Anutu emmide! Anutu mocgungo kopocsic naric waude.” ");
INSERT INTO ded_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yeni ifi negenggec Yesungo ongaasuyau negengyemmema yofi edeyunuec, “Ngeni nocac negen negeng ifia ubanginango negensidae? ");
INSERT INTO ded_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Damocngo efea ande? Ngic puring yeac debesonga, ‘Kopocsicga kpac ande’, me ‘Ge yacma tofoga mema kenna.’ ");
INSERT INTO ded_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nga Ngicac Medac, yeng bangecfu kopocsic wawaac uayoac nga kuc femide, ngeni imoc negenggecdeac amma yofi deba.” Ye ifi dema ngicpuring yofi edeec, ");
INSERT INTO ded_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ni edeguduae, ge yacma dzakega mema amagau kenna.” ");
INSERT INTO ded_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ifi deu imohaingoc ngic ye yacma dzakea mema ngicngac kicnginau kenec. Kenu ngicngac sasawango imoc hemma kpidohoma kerectegec amma Anutu dengerema degec, “Wiac yomoc mi hehennina yaguc fingeru hendimbe.” ");
INSERT INTO ded_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Anu Yesungo ama imohanac mama dzohong tegiau kenec. Kenu ngicngac homacngo yearu kenggec kpoukpou ua meec. ");
INSERT INTO ded_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nga kemma Rewi Arifaioac medac takesimeme ameau taru hemma yofi edeec, “Ge hama ni modacnuna!” Ifi deu yeng yacma modarec. ");
INSERT INTO ded_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kecma Yesungo Rewiac amau yaka nema tacmanu takesimeme ngic nga manganameme ngic homacngo Yesu nga medacfora yenigoc yaka momoc negec. Ngic ifia homacngo yeni modacyunuma kenggec. ");
INSERT INTO ded_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ifi anu Yesungo takesimeme nga manganameme yenigoc tacma yaka neu farisaio yenearunac mitiac negen negengngic goa, yeneng imoc hemma medacfora kpesiyemmegec, “Ye nocac takesimeme nga manganameme yenigoc yaka nede?” ");
INSERT INTO ded_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ifi degec Yesungo negemma yofi edeyunuec, “Ngicngac hafeingina kpac kecdae, yeni dotaac mi ayemmeude. Nga hafeinginagoc, yeneng ine dotaac ayemmeude. Nga ni ngicngac dindingac kpacyunubadeac mi mayai, kpac. Ni ine manganameme ngic kpacyunubadeac mayai.” ");
INSERT INTO ded_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yohaneac medacfora nga farisaio yakasege kecandae, yenearunac goango hama Yesu kpesimigec, “Yohane nga farisaio medacfocngina yeni yakasege angandae. Nga geac medacfocga yeneng nocac yaka sege mi angandae?” ");
INSERT INTO ded_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ifi kpesigec Yesungo yofi edeyunuec, “Memeturang ngicngo tosofora yenigoc taru yeneng yakasege naric mi kecgecde. Monggoc deba, yeng yenigoc tacmanungoc yakasege naric mi kecgecde. ");
INSERT INTO ded_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kecma naso monnu ngic yeneng memeturanggac ngic yenearunac meickegecde, naso imohai yakasege anggecde. ");
INSERT INTO ded_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ngac mongngo ngakpi eseau kporucsusuc gboria mong mi kpebiude. Kporucsusu gboriango esea taiu dzamema titingtoa fingecbac. ");
INSERT INTO ded_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nga ngic mongngo waing gboria bokong yang seberango memea eseau naric mi kpeu kemeude, kpac. Waing gboriango bokong esea tindziru yerahafoc manganebaoc. Imocac waing gboria imoc bokong gboriau kpeu kemeude.” ");
INSERT INTO ded_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Naso monnu sabata nasou Yesungo wit ua dzongiau sing modac kemmanu medacfora yeneng wit fora mocgu mocgu merecgema megec. ");
INSERT INTO ded_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Merecgegec farisaio yeneng degec, “Henna, yeni nocac sabata nasou faka mi angana andae?” ");
INSERT INTO ded_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ifi degec Yesungo yofi merengyemmeec, “Dawidi nga uamedacfora yeni yakaac obohoma herenginaac homema faka anggec, ngeni imoc osonegeng mi angandae gedang. ");
INSERT INTO ded_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatango womong garengtoa kefec, naso imohai Dawidingo Anutuac womonnu enec. Emma ic sogong Anutuac sese faifaia, imoc menema uamedacfora ifingoc gumecyunuec. Nga ic sogong imoc womong gareng yenengsac naric negecde, ngictehec yeneng kpac.” ");
INSERT INTO ded_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ifi dema yofi edeyunuec, “Ngicngo sabataac amma mi fingerec, sabatango ine ngicngac ngeneac amma fingerec. ");
INSERT INTO ded_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngicac Medac ye sabataac Kebu kecdengoc.” ");
INSERT INTO ded_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesungo naso monnu kpekpeturang amau enu ngic mong maria noboc homemea, ye ihai tarec. ");
INSERT INTO ded_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nga ngic goa yeni Yesu yoacfu faigecdeac negensigec amma ngic imoc sabata nasou mengereude me kpac, imocac hembikecgec. ");
INSERT INTO ded_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hembikecgec Yesungo ngic marimangang yofi edeec, “Ge yacma botucninau nanna.” ");
INSERT INTO ded_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ifi dema yofi kpesiyemmeec, “Sabata nasou noc faka naric ambesonga, faka gombunga me mangana? Amma homebeso andae, yeni agengngina tinide me yunuhomenide?” Ifi deu yeneng engsac ning kpegec. ");
INSERT INTO ded_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ning kpegec yeng ubaseringinaac negenghodungaima herea buu kic fikengfiha amma ngic yofi edeec, “Ge mariga sinena!” deu ngic ye maria sineu ngereec. ");
INSERT INTO ded_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ngereeu farisaio yeneng naso imohaingoc Herodeac arengfora yenearu ioha kemma dafiu mema kpegecdeac yoac dedzege anggec. ");
INSERT INTO ded_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Anu Yesu nga medacfora yeni amabangec wama Gariraia dzohonnu kemmagec Gariraia bangecfunac habu kunengngo modacyunugec. ");
INSERT INTO ded_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ngicngac Yudaia bangecfunac nga Yerusareng taonnunac amma Idumaia bangecfunac nga Yodang edibigeng amma Tiro nga Sidong bangecfunac, habutoa imoc yeni Yesungo faka sasawa meec, imocac siduc negemma yearu hagec. ");
INSERT INTO ded_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nga Ngicngac homacngo hasikema Yesu igockebauac medacfora yeneng wage wegenac faigecdeac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nga ye ngic homac mengereyunuu hafeigoc yeneng kemma kpeseregecdeac hefacemegec. ");
INSERT INTO ded_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nga asu seuhagoc yeneng Yesu hemma ngonducnema yofi dema kpacma degec, “Genoc Anutuac medac.” ");
INSERT INTO ded_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ifi degec hania dekperagibauac Yesungo dederac ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Anu ye tikiu emma medac goa ubango negenggosi ayemmeecmoc, deu yearu kenggec. ");
INSERT INTO ded_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Kenggec medac 12 meisingyunuma aposoro kpac yemmeec. Yemmeu yeni yegoc kecmagec yoac edekpou ayemmegecde nga hadehade nga yafing kporacyemmegecdeac uayoac nga kuc yemmeec. ");
INSERT INTO ded_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ngic 12 meisingyunuec, yeneac kpacngina yofi, Simong, kpara mong Petoro miec, ye ");
INSERT INTO ded_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","amma Dzebedaioac medahora Yakobo nga munea Yohane, yereac kpacngira Boanerges yemerec. Imocac titiha, parandanggac medac. ");
INSERT INTO ded_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Nga Anderea amma Firipo nga Batoromaio amma Mataio nga Toma amma Yakobo, imoc Arifaioac medac nga Tadaio amma Simong Kananaio nga Yuda Karioto amaunac, yeng kecma Yesu kerereu megec. ");
INSERT INTO ded_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Anu Yesungo amau kensikeu habutoango hama kpedzucnegec medacforagoc yakaneneac titing mong mi fingerec. ");
INSERT INTO ded_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wiacfora yeneng yofi negenggec, “Ye ubea sufude.” ifi dema megecdeac kenggec. ");
INSERT INTO ded_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nga mitiac negen negengngic Yerusarennac hagec, yeneng degec, “Ye hadehade nga yafing yeneac ngictaungina Bedzeburu, yeac kucfu hadehade nga yafing ngicngac yenearunac kporacande.” ");
INSERT INTO ded_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ifi degec Yesungo kpacyunuma yoac heima yofi edeyunuec, “Satang yengenaocngoc dafi kporacemeude? ");
INSERT INTO ded_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bangec monggac ngicngac yeni ngaba angemema tohogecdeu bangec imocngo naric mi fekefude, kpac. ");
INSERT INTO ded_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nga amamana mocgungo tohoma ngaba angemeudeu amamana imocngo kpac anude. ");
INSERT INTO ded_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nga Satangngo tohoma yengenaocngoc kporacemeudeu ye ifingoc kpac anude. ");
INSERT INTO ded_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ngic mongngo ngic kuhagoc, yeac amau emma iwaiya naric mi wangerude, kpac. Ye ngic kuhagoc imoc witickemaguc amea manau emma iwaiya tacde, imoc naric wangerude. ");
INSERT INTO ded_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Foracngoc, ngicngac yeni kopocsic hania hania angandae nga wiac hania haniaac deendema nga dedenggbaring angandae, kopocsic ifia sasawa, imocac wawa fede, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nga ngic mongngo Tiri Asu denggbaringgeude, yeac kopocsic ine wawaya mi fede. Kopocsihaac turunga imoc fekengkecbesande.” ");
INSERT INTO ded_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeneng degec, “Ye asu seuhagoc.” imocac amma yeng ifi edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Anu Yesuac nonggo munafora yeneng sobennu kensikema ngic mong suema degec, “Yesu ye mabeso.” ge ifi edena. ");
INSERT INTO ded_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ifi degec Yesungo habu yeneac botucfu tacmanu ngicngac yeneng edegec, “Nonggo munafocga ngadeau namma ge hofocgudae.” ");
INSERT INTO ded_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ifi degec yeng merengyemmeec, “Damoc yeneng neac nonggo munafocna?” ");
INSERT INTO ded_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ifi dema yegoc momoc tacgec, kiwa yenearu fima yofi deec, “Nonggo munafocna imoc ngicngac ngeni yomoc tacdae. ");
INSERT INTO ded_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nga ngic Anutuac songo nga negen negeng modacma yeac ua mekecdae, yeneng neac nonggo naing nga dacmunafocna.” ");
INSERT INTO ded_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesungo dzohong tegiau monggoc kemma ngicngac edekpou ayemmeu homacngo yearu kpedzucnema hagec. Imocac yeng gomba monnu emma ihai tacma edekpou ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Amma ye yoac heima yoac homac kpouyemmema yofi deec, ");
INSERT INTO ded_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Negenggec, gbome kpegi kpegingic mongngo gbomea kpegiudeac uau kenec. ");
INSERT INTO ded_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kemma kpegiu gbome goa mama sinnu heiu neng yeneng hama nedacgec. ");
INSERT INTO ded_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nga goa harongannu heiu ihai bangec efeanec feecac gbome imoc bic nemonggema ereec. ");
INSERT INTO ded_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Erema godea ine homac mi faiecac wenacngo erema kpeu gbome imoc ururuema homeec. ");
INSERT INTO ded_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nga gbome goa haseng manau heiu hasengngo yadima heihomeu fora kpac anec. ");
INSERT INTO ded_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nga gbome goango bangec gombungau heima kpea nemonggema fora gombunga anec. Monggac imoc gbomea 30 nga monggac 60 amma monggac 100, ifi fingerec.” ");
INSERT INTO ded_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesungo ifi dema yofi edeyunuec, “Kedzahagoc yeng yoac yomoc negembeso.” ");
INSERT INTO ded_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Anu ngicngac habutoa kenggec medacfora 12 nga ngicngac goa yegoc kecgec, yeneng yoac heihei imocac hania Yesu kpesimigec ");
INSERT INTO ded_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","yeng yofi edeyunuec, “Anutuac eucererenggac negen negeng sufu sufuya, imoc ngeni bic ngemmengemmea. Nga ngicngac ngadeau kecdae, yeni ine yoac heiheiusingsac yoac sasawa negenggecde. ");
INSERT INTO ded_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ifi anu ‘Yeni kicnginango hemma wiac mong ine mi henggecde nga kedzacnginango negemma wiac mong sifu mi negentegecgecde. Imocac yeni ubangina mi dzigeneu kopocsicngina kpac ambacac kopocsic wawa mi anggecde.’” ");
INSERT INTO ded_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Anu Yesungo yofi edeyunuec, “Ni yoac heima deduae, ngeni imocac hania mi negendaeu yoac heiheiac hania goa monggoc deba imoc ifingoc dafi negentegecgecde. ");
INSERT INTO ded_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Gbome kpegi kpegi ngicngo Anutuac yoac kpegiec. ");
INSERT INTO ded_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gbome sinnu heiec, imoc ngic goa yeni yoara negenggec nga Satang ye ine bic hama gbome ubanginau kpegi kpegia meickeude. ");
INSERT INTO ded_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nga gbome harongannu heiec, imoc ngic goa Anutuac yoac negemma heresongogoc bic hoanggegecde. ");
INSERT INTO ded_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amma yoac ubanginau godea mi meecac naso wegenanecsac taru Anutuac yoacac amma kpendzeng me yunukporac faka fingeru yeni makpegecde. ");
INSERT INTO ded_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nga gbome hasennu heiec, imoc goa yeni Anutuac yoac negenggec. ");
INSERT INTO ded_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Negemma bangectoa bangec yomocac kekecac fagung nga dzofinacac faitobang nga wiac goaac hensongo angandae, imoc sasawango ubanginau kemema yoac heihomeu fora mong mi fingerude. ");
INSERT INTO ded_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nga gbome goa bangec kerehagocfu heiec, imoc ngic goango Anutuac yoac negemma mekecgec fora fingerude. Goango 30 nga goango 60 amma goango 100 meficgeude.” ");
INSERT INTO ded_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesungo monggoc yofi edeyunuec, “Ngic mongngo kifa kpiacma pake bageau faima mi kperahaude me tatac bageu faiu tarude, imoc kpac. Kifa imoc tatahau faini tacande. ");
INSERT INTO ded_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wiac sufu sufuu fede, imoc kecma didiu fingectegerude nga wiac seme semea, imoc kecma kperagiau fingectegerude. ");
INSERT INTO ded_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mong ye kedzahagocngo yoac yomoc negembeso.” ");
INSERT INTO ded_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Amma Yesungo yofi edeyunuec, “Ngeni yoac yomoc negentegecbisia. Ngeni wiac kpetea isinggema ngicngac yemmeandae, ngic yeneng kpete siriha ifiangoc isinggema turung kpoungemmegecde. Yeni kpoungemmema imocac sirihau meemma monggoc ngemmegecde. ");
INSERT INTO ded_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Imoc yofiac, mong ye wiac goa femide, ye wiac monggoc migecde. Nga mong ye wiac mong mi femide, yearunac wiacbisic femide, imoc ifingoc wangecgecde.” ");
INSERT INTO ded_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Amma monggoc yofi deec, “Anutuac eucererenggac siriha, imoc ngic mongngo gbome kpegiec, ifi isoc. Kpegiu hadzing toforec feyac ammanu gbome imoc nesarima ereude. Nga imoc dafiac erede, imoc ngicngo mi negentegecde. ");
INSERT INTO ded_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nga bangec yengenaoc wiac meyadiu erema tebang angkecde. Amma fora amma wadzima kpaueude. ");
INSERT INTO ded_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kpaueu fora kpememe naso anu ye semeng bic kperecgeude.” ");
INSERT INTO ded_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesungo monggoc yofi deec, “Nenang Anutuac eucererenggac siriha yofi heima deni naric anude. ");
INSERT INTO ded_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Anutuac eucerereng imoc mastet gbomea isoc. Mastet gbomea imoc gbome sasawa yeneac kapiangina. Nga imoc bangecfu faini erema yadima semeng uaac mondzang feracyunuma fawa kuneng angande. Nga sawau neng yeneng imocac nokumucfu hama faec heima tacgecde.” ");
INSERT INTO ded_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesungo yoac heima yoac ifia homac dema ngicngac negen negengnginaac sirihau Kebuac yoac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Amma yoac deec, imoc ine yoac heimasac edeyunukefec. Edeyunuma medacfora meyunuma tembucfu kemma hania dekperagima edeyunukefec. ");
INSERT INTO ded_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Anu ama marai anu Yesungo medacfora yofi edeyunuec, “Nenang dzohong noboc kenni.” ");
INSERT INTO ded_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ifi deu yeni ngicngac habutoa wayunuma Yesu gombau bic tacmanu yeni ye wangecma kenggec. Kemmagec gomba goango ifingoc modacyunugec. ");
INSERT INTO ded_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nga imohai firang engena kpeu tembong kucgoc kpeu dokungo gomba manau erema gomba mewakebeso anec. ");
INSERT INTO ded_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Anu Yesungo gomba ngadeau kparicgang heima gau femanu medacfora yeneng midima degec, “Kpoukpou, kemebesonga andimbe, ge imocac fagung mong mi annec me?” ");
INSERT INTO ded_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ifi degec ye gauunac yacma firang kpetarimima dzohong yofi edeec, “Ge waickema fena!” ifi deu firang kpac anu dzohong imoc ning kpema eng feec. ");
INSERT INTO ded_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Feu Yesungo medac yeneac yofi deec, “Ngeni nocac kengec andae, negen negensingngina mong mi fede me?” ");
INSERT INTO ded_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ifi deu yeni kengec nga damutoa yombong amma kpesiemegec, “Ye noc ngic, firang nga dzohongtoa yereng yeac enac tofohodape.” ");
INSERT INTO ded_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Anu dzohong ferecgema Gerasene bangecfu edigeng kenggec. ");
INSERT INTO ded_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kensikema Yesungo gombaunac mamanu ngic mong asu seuhagocngo kicsereunac hama Yesu meficgeec. ");
INSERT INTO ded_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ngic imoc ye kicsereu feyac angkefu ngic mongngo ye witickeudeacsoc mi anec. Nga yeni sengngo witickebeso ifingoc obohogec. ");
INSERT INTO ded_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ngic yeni naso homac hanimaria sengngo witickegec yeng seng kperecgedarec nga hania aiengngo witickegec, imoc ifingoc kperecgedarec. Nga ngic sasawa yeni ye mendanggegecdeac obohogec. ");
INSERT INTO ded_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ngic imoc ye hadzing toforec kicsereu nga fagannu arohoma yengenaoc sebia hocfu heiherecge angemekefec. ");
INSERT INTO ded_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Amma ye hereaungoc Yesu hemma nedzikemma haniau makpeec. ");
INSERT INTO ded_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Makpema seriangoc arohoma deec, “Yesu Anutu engenatoaac Medac, neac wiac imoc geac mi ande. Ni Anutuac kicfu edeguduae, ge kpendzennu mi fainuna.” ");
INSERT INTO ded_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yesungo asu seuhagoc kporaru yearunac erema kenudeac edeec, imocac amma ngicngo ifi deec. ");
INSERT INTO ded_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ifi deu Yesungo yofi kpesimiec, “Ge kpacga merac?” kpesimiu deec, “Ni kpacna habutoa, nocac neni homac.” ");
INSERT INTO ded_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ifi deu ye kporacyunuu bangec imoc mi wagecdeac seriyombonggema derecgeec. ");
INSERT INTO ded_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Anu bangec botuc imohai berechabutoa mong fagang wegenacfu surukpema kecgec. ");
INSERT INTO ded_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kecgec asu seuhagoc yeneng yofi dema desambic ammigec, “Ge suenununa berecfu kemeni.” ");
INSERT INTO ded_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ifi degec Yesungo negengyemmeu yeni ngicfunac erema berechabu yenearu kemegec. Kemegec berec yeni fagannunac nedzima dzohonnu kemema doku nema homedacgec. Nga berec homegec, yeneac kpetengina imoc 2 tauseng isoc. ");
INSERT INTO ded_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Anu berecgareng yeneng kengec worama taonnu nga amabisicfu ngic kecgec, yenearu kemma faka fingerec, imocac siduc edeyunugec yeneng imoc hengecdeac hagec. ");
INSERT INTO ded_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nga yeni Yesuaru hasikema henggec ngic hadehadehabugoc warac kefec, yeng negentegecma wamba heima taru yeni ye hemma kengecyunuec. ");
INSERT INTO ded_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nga ngic kicnginango faka imoc henggec, yeneng ngic hadehadegoc, yearu faka fingerec nga berec yeneac siduc momoc ngicngac ayemmegec. ");
INSERT INTO ded_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nga yeni yoac imoc negendacma Yesungo amabangecngina waudeac edegec. ");
INSERT INTO ded_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ifi edegec ye gombau emmanu ngic hadehadegoc ngereec, yeng yegoc kenudeac derecgeec. ");
INSERT INTO ded_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Derecgeu Yesungo ine kpetarimima yofi deec, “Ge amagau kemma Kebungo geac ubea manganeu wiac sasawa anggendac, imocac siduc tosofocga ayemmebesena.” ");
INSERT INTO ded_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ifi deu ye kemma Yesungo faka sasawa yearu meec, imocac siduc Dekaporisi bangecfu ngicngac yoac dekperagiyemmeu yeni imoc negemma kerectegec anggec. ");
INSERT INTO ded_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Anu Yesungo gombau emma monggoc dzohong ferecgema hasike nammanu ngicngac homacngo yearu heockema kemma kpedzucnegec. ");
INSERT INTO ded_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kpedzucnemagec kpekpeturang amaac gareng mong kpara Yairo, yeng hama Yesuac haniau makpema desambic amma deec, ");
INSERT INTO ded_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Naroanna homebeso ande. Ge hama marigango witiau faina ngereeude.” ");
INSERT INTO ded_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Edeu negemma kemmaec ngicngac habutoango hefacemema yearu hagec. ");
INSERT INTO ded_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Anu ngac mong ihaingoc nanec, ye sacherec amma kecmanu kifa 12 bic anec. ");
INSERT INTO ded_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Amma ye kpendzeng kpema dota homac yenearu kemma hiedzoya eng kpedzonggeu sebiau ngerec ngeree mong ine mi fingecmiu eng monggoc manganeec. ");
INSERT INTO ded_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Amma ngac imoc ye Yesuac siduc negemma ngicngac ngadenginausing kemma yofi negenec, “Ni ngakpia kpeserema ngereebadenoc.” ifi negemma Yesuac ngakpihereha kpesereec. ");
INSERT INTO ded_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kpesereu imohaingoc sawa gbanggeu sebia nomaneu kpendzenga kpac anu negengemeec. ");
INSERT INTO ded_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nga Yesungo yofi negenec, kucna tosea ferecgedac, imocac amma habutoa yenearu dzigenema yofi kpesiyemmeec, “Merang ngakpina kpeseredac?” ");
INSERT INTO ded_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ifi deu medacfora yeneng degec, “Ngicngac homac yeneng hefacgumagec geng merang kpeserenude dema kpesinec, imoc mi heide.” ");
INSERT INTO ded_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nga Yesu ye ine ngacngo kpesereec, ye hentegerudeac fikengfiha anec. ");
INSERT INTO ded_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ammanu ngac ye kengec kpeu dzonoma fedeu Yesuac haniau makpema haniaya hafoangoc deficgedarec, nocac sebiau faka fingerec, imoc negenec. ");
INSERT INTO ded_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Deficgeu Yesungo yofi edeec, “Naroang, negen negensinggango mengeregudac. Ge sebiga ngereeu ruaegoc kenna!” ");
INSERT INTO ded_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Anu Yesungo yoac denammanungoc ngic goa yeneng kpebung garenggac amaunac hama Yairo edegec, “Naroangga bic homedac, kpoukpou monggoc ebic mi mina!” ");
INSERT INTO ded_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ifi degec Yesungo yoacngina wama gareng yofi edeec, “Ge mi kengecguu, eng negensinggena.” ");
INSERT INTO ded_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ifi dema habu kpetariyemmema Petoro nga Yakobo amma munea Yohane, yeni meyunuu kenggec. ");
INSERT INTO ded_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kemma garenggac amau kensikema henu ngicngac habu yeni ubahodung amma kpeborongtoa kpema kiacsonggong anggec. ");
INSERT INTO ded_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nga Yesungo ine ama manau emma ngicngac yofi edeyunuec, “Ngeni nocac kpeborong kpema kiacdae? Naroang ye mi homedac, ye gau fede.” ");
INSERT INTO ded_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ifi deu yeni dzomoremigec. Yeng ine ngicngac sasawa kporacyunuu ngadeau madacgec. Magec naroanggac nonggomama nga medacfora harebec meyunuu naroang feec, ihai enggec. ");
INSERT INTO ded_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Emma mariau mema yofi edeec, “Tarita koumi!” imocac titiha yofi, “Ngacbisic, ni edeguduae, ge yacna.” ");
INSERT INTO ded_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ifi deu naroang ye imohaingoc yacma kengha anu yeneng hemma kpidohoma negenggec imoc wiac engena anec. Naroang imoc ye kifaya 12 anec. ");
INSERT INTO ded_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nga Yesungo faka fingerec, imoc mi deficgegecdeac seria deracyunuma naroang yaka migec neudeac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesungo bangec imoc wama yengena amabangehau kenu medacfora yeneng modacgec. ");
INSERT INTO ded_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nga sabata naso anu ye kpekpeturang amau emma ngic edekpou ayemmeu ngicngac negemma tacgec yeneng kerectegec amma degec, “Negen negeng imoc merang kpoumiec nga uayoac merang miecac mariango faka kuhagoc ifia mekecde? ");
INSERT INTO ded_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ye Mariaac medac nga amamemengic. Ye Yakobo nga Yosec amma Yuda nga Simong yeneac dacngina nga naingfora yeni nenanggoc kecdae.” Yeni ifi dema dehesi amma wagec. ");
INSERT INTO ded_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nga Yesungo yofi edeyunuec, “Profeteac amafora nga sactosofora amma arengfora, yenengsac yeac ewea mi heiandae.” ");
INSERT INTO ded_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nga ye faka kuhagoc mong yenearu meudeacsoc mi anec. Ye ngic hafeigoc mocgu mocgusac mariango kpesereyunuu ngereegec. ");
INSERT INTO ded_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nga yeni mi negensinggegecac negenu naric mi anec. Amma ye guruama tackenec, imohai yerecgema edekpou ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesungo medacfora 12 kpacyunuma yohockang yohockang hendzicyunuma asu seuhagoc kporacgecdeac uayoac nga kuc yemmema sueyunuec. ");
INSERT INTO ded_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Amma yeng yofi dema dederecge ayemmeec, “Ngeni singgac mefic mong mi mema yasusac mebisia. Ngeni yaka me hie mi mebisia amma dzo mong fadeng nabehau mi baribisia. ");
INSERT INTO ded_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ngeni hanitabe faima ngakpi yohockang ine mi mekembisia.” ");
INSERT INTO ded_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ifi dema yofi edeyunuec, “Ngeni kemma ama monnu kensikegec ngic yeneng ama heingemmegec ngeni ama imohai tacyac angkecgec wisickeu wama amabangec monnu kembisia. ");
INSERT INTO ded_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nga amabangec monnu kenggec ngic yeni mi hoangngunugecde amma yoacngina mi negenggecdeu ngeni haninginaunac yube kpegec mau amabangec imoc wabisia. Nga ngic yeni imoc hemma haniangina negentegecbisia.” ");
INSERT INTO ded_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesungo ifi deu yeni kemma ngicngac ubangina merenggecdeac Anutuac yoac edekpou ayemmegec. ");
INSERT INTO ded_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Amma yeni hadehade nga yafing homac kporacyunugec nga ngicngac hafeigoc kerecngo nadzicyemmema mengereyunugec. ");
INSERT INTO ded_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuac siduc imoc bangeha bangeha sokoma kenu ngictau Herodengo yoac imoc negemma yofi negenec, “Yohane dokunadzicngo homecfunac gborima yarecac amma faka kuhagoc meudeac kuc femide.” ");
INSERT INTO ded_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ifi degec ngic goa yeneng degec, “Imoc Eria.” nga goango degec, “Ye profete. Profete warac kecgec, yeni isoc.” ");
INSERT INTO ded_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Anu Herodengo ine yoac imoc negemma deec, “Yohane ubea kperecgeai, yennoc gboriec kecde.” ");
INSERT INTO ded_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nga Herodengo munea Firipoac enema kpara Herodia, ye hamangec mema mekefec. Faka imocac amma Yohanengo Herode yofi edeec, “Ge munagaac enema menec, imoc singngo mi dede.” Ifi deu Herodengo ngicfora edeyunuu Yohane mema witickema witicamau faigec. ");
INSERT INTO ded_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Anu Herodiango Yohaneac herebu negenec. Negenu Herode ye ine Yohaneac kengec kpeu garenggeecac amma Herodiango kpeudeac sing obohoec. ");
INSERT INTO ded_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Imoc yofiac, Yohane ye ngic dindingac nga kpetiac, Herodengo imoc negentegecma henggareng ammikefec. Amma ye yeac yoac negemma naso homac negengyohoc meficgema sifu yoara negenudeac ammiec. ");
INSERT INTO ded_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kecma Herodiaac naso gombunga mong yofi fingerec. Herodengo fingec fingec nasoyau ngickuneng yeac bageau kecgec nga wasaingicforaac enara amma Gariraia bangecfunac ngicenara, yeni heitaiyunuma neneyaka ohoyemmegec. ");
INSERT INTO ded_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ohoyemmema tacmagec Herodiaac naroangngo hama kicnginau yegec fedeec. Fedeu Herode nga ngic yegoc yaka negec, yeneng imoc hemma songo negenggec. Imocac amma ngictaungo naroanggac deec, “Ge wiac monggac negemma derecgenenna imoc naric gembade.” ");
INSERT INTO ded_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dema nemuya monggac kpacfu yofi deseriec, “Ge wiac sasawa derecgenenna gengyombonggebade nga bangecna nobohaac dena mendzicma gembade.” ");
INSERT INTO ded_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ifi deu naroang ye kemma nonggea kpesimiec, “Ni noc wiacac debade?” deu nonggeango deec, “Ge Yohane dokunadzicac oruha dena.” ");
INSERT INTO ded_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ifi deu naroang ye imohaingoc ngictau yearu kemma deec, “Yohane dokunadzicac oruha yagucngoc terau faima nennadeac anende.” ");
INSERT INTO ded_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ifi deu ngictaungo ubaebic meec. Amma ngic tacgec, yeneac kicfu yoac bic deseriecac amma ine imoc wabesonga negenu naric mi anec. ");
INSERT INTO ded_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nga ye imohaingoc wasaingic mong sueu Yohaneac hatea mehaudeac witicamau kenec. Kemma Yohaneac ubia kperecgema ");
INSERT INTO ded_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","hatea imoc terau faima mehama naroang miu naroangngo imoc mekemma nonggea miec. ");
INSERT INTO ded_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Anu Yohaneac medacfora yeneng siduc imoc negemma kemma farenga mehama tonggogec. ");
INSERT INTO ded_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposoro yeni monggoc Yesuaru kpeturangge hama wiac sasawa anggec megec nga edekpou ayemmegec, imocac siduc ammigec. ");
INSERT INTO ded_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nga ngicngac homac yeneng kengha anggecac tacnegeng nga yakaneneac titing mong mi fingerec. Imocac Yesungo medacfora yofi edeyunuec, “Ngeni hagec tembucnina kecnideac nigoc bangec kisiu kemma kecnegembisia.” ");
INSERT INTO ded_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ifi deu yeni tembucngina gombau emma bangec mong ngiha kpacfu kenggec. ");
INSERT INTO ded_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kemmagec ngicngac homacngo ine yenemma yenentegecma taong tackenec, imohacnac nedzima warac warac ihai kensikegec. ");
INSERT INTO ded_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kensikema Yesungo gombaunac mama ngicngac habutoa ifi yenemma yeneac ubahodung negenec. Nocac yeni rama garengngina kpac kecdae, ifi isoc kecgec. Ifi negemma wiac homac edekpou ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ayemmema kefu marai anu medacfora yeneng yearu hama degec, “Bangec yomoc ngiha kpac anu naso bic kendacde. ");
INSERT INTO ded_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Imocac ge ngicngac sueyununa ama tackende, imohai kemma yaka bummenec ambisia.” ");
INSERT INTO ded_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ifi degec yeng yofi deec, “Ngeneng yaka yemmegec negec.” Ifi deu merenggec, “Neni kemma 200 denaringo yaka bummehama yemmeni negecdeac denec me?” ");
INSERT INTO ded_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ifi degec Yesungo yofi kpesiyemmeec, “Ngenearu ic sogong dafiguc fede, ngeni kemma henggec.” Ifi deu kenghemma edegec, “Ic sogong marimong nga kondungyang yohockang metacdimbe.” ");
INSERT INTO ded_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Ifi degec yeng ngicngac kpindzinnu matacgecdeac edeyunuec. Edeyunuu yeni mama goa 100 nga goa 50 ifi habu mema kpindzinnu tackenggec. ");
INSERT INTO ded_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tacmagec Yesungo ic sogong marimong nga kondungyang yohockang imoc meec. Mema kiwa kurumennu fiu enu kenehema ic sogong tuema medacfora ngicngac gumecyunugecdeac yemmeec. Yemmema kondungyang ifingoc mederema yemmeu medacgec. ");
INSERT INTO ded_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mema ngicngac sasawango negebec amma ");
INSERT INTO ded_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ic sogong nga kondungyang tosea neti anggec feu kpedzucnegec kemema sakac 12 wakeec. ");
INSERT INTO ded_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ngic yaka negec, imoc yeneac kpetengina 5 tauseng. ");
INSERT INTO ded_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nedacgec wisickeu Yesungo ngicngac faiyunuudeac namma medacfora sueyunuu yeni waraima gombau emma Besaida taonnu kenggec. ");
INSERT INTO ded_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kemmagec ye ngicngac faiyunuma numuudeac tikiu enec. ");
INSERT INTO ded_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nga ama toforeyemmeu gombango dzohong dzongiau kemmanu Yesungo tembuha yeigeng kefec. ");
INSERT INTO ded_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kefu medacfora kemmagec ama werec wereckenggac firangngo kenggecfusing haecac puri kpebibiegec. Ifi anggec Yesungo yenemma yenearugeng dzohong witiau titi kemma feracyunubeso anec. ");
INSERT INTO ded_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ye dzohong witiau titi kenecac yeni hemma ine wosongango hade, ifi negemma kengec amma arohogec ");
INSERT INTO ded_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yeng yofi bic edeyunuec, “Ngeni wosongina makiu, imoc ni, ngeni mi kengecngunuu.” ");
INSERT INTO ded_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ifi dema gombau emma yenigoc taru firang kpac anec. Nga yeni ongangina worau kerectegec anggec. ");
INSERT INTO ded_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Amma yeni herengina dzege dzegea feecac amma yakau faka fingerec, imoc mi negentegecgec. ");
INSERT INTO ded_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Anu yeni dzohong ferecgema Genesarete bangecfu kensikema gombangina dzegegec tarec. ");
INSERT INTO ded_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Taru gombaunac mamagec ngicngac yeneng Yesu bic hensigec. ");
INSERT INTO ded_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hensima amea amea nedzikemma ngicngac hafeigoc tofou faiyunuma, “Ye ihai me ihai kecde.” imoc negemma ihai meyunu hakecgec. ");
INSERT INTO ded_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesungo taonnu nga amabisicfu endaru ngicngac yeneng ngicngac hafeigoc meyunuma didiu faiyunugec ngakpia susiaac witiha kpeseregecdeac derecgegec. Amma kpeseregec, yeni sasawango ngereegec. ");
INSERT INTO ded_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisaio nga Yerusarennac mitiac negen negengngic goa yeneng Yesuaru hama kpeturanggema kecgec, ");
INSERT INTO ded_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","imohai Yesuac medacfora goa yeni maringina mi dzuac dzuac yaka menec anggec yenenggec. ");
INSERT INTO ded_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Imoc yofiac, farisaio nga yudangic sasawango bangecfocnginaac singyoac modacma maringina dzuacmaguc yaka neandae. ");
INSERT INTO ded_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Amma yeni emenecfunac hama doku nadzic nadziha kpac yaka eng mi menec amma faka goa ifia momoc kpabanggema angandae. Yeni kpakenec nga sokoc amma birikeng ifingoc dzuacmaguc neandae. ");
INSERT INTO ded_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ifi anu farisaio nga mitiac negen negengngic yeneng Yesu kpesimigec, “Medacfocga yeni nocac bangecfocnina nga esangabofocnina yeneac singyoac mi modacma maringina mi dzuac dzuac yaka eng menec angandae?” ");
INSERT INTO ded_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ifi degec yeng yofi edeyunuec, “Profete Yesaiango ngic ikoha ngeneacnoc kpefing fora yombong yofi ohoec, ‘Ngichabu yomoc yeni enacbibicngo sesehenuandae nga herenginango ine neac hereau kecdae. ");
INSERT INTO ded_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yeni ngicngac wiac kpouyemmeandae, imoc ngicac singyoac edekpou ayemmeandae amma ni eng dengerenugec hemba fora kpac angkecde.’ ");
INSERT INTO ded_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ngeni Anutuac dedeseriyoac meickema ngic yeneac singyoac hoanggeandae.” ");
INSERT INTO ded_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Amma monggoc yofi edeyunuec, “Ngeni ngenang singyoac hoanggeandaeac Anutuac dedeseriyoac meickeyombonggegecde. ");
INSERT INTO ded_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosengo yoac mong yofi deec, ‘Ge nonggo manghocga seseheyurubesena.’ nga ‘Ngic mong ye nonggea me mamaac sowecyoac deude, ye homebeso.’” ");
INSERT INTO ded_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngeneng ine yofi deandae, “Ngic mongngo nonggea me mama yofi edema deude, ‘Wiac gemba nanggegudeac dedua, imoc bic Anutuac sese dedua.’ ");
INSERT INTO ded_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ifi deu ngeni ngic nonggea me mama meficgeudeac dekpetari ammigecde. ");
INSERT INTO ded_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Amma ngeni singyoacngina kpabanggema Anutuac yoac semema faka goa ifia homac angandae.” ");
INSERT INTO ded_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesungo ifi dema ngichabu monggoc kpacyunuu hagec yofi edeyunuec, “Ngeni kedzac kpema negentegecdacgec. ");
INSERT INTO ded_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wiac mongngo ngadeaunac kemeande, imocngo ngic ubahere naric mi heidzadzu kpeude, kpac. Nga ngic heremanaunac wiac ereande, imocngo ine ngic heidzadzu kpeude. ");
INSERT INTO ded_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ngic kedzahagoc kecde, yeng yoac yomoc negembeso.” ");
INSERT INTO ded_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ye ifi dema ngicngac wayunuma amau enu medacfora yeneng yoac heima deec, imocac kpesimigec yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Ngeni negen negentegecngina kpac, ifi isoc kecdaengoc. Ngadeaunac wiac mong heremanau kemeande, imocngo naric mi heidzadzu kpeude, ngeni imoc mi negentegecdae me? ");
INSERT INTO ded_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Wiac imocngo ubanginau mi kemeandeac hereu kemema isinggeu keractennu kemeude.” Yesungo ifi dema yaka sasawa nenideac desorongaiec. ");
INSERT INTO ded_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Amma torokpema yofi deec, “Wiac mong ngic ubahereunac ereande, imocngo ine heidzadzu kpeude. ");
INSERT INTO ded_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Nga ngic ubahereunac wiac yofia ereande, negen negeng mangana nga Kaiserofaka amma hamangecfaka nga ngickpekpe amma eweeneng mewa nga kic hodung amma manganaac areng meme nga ikoc faka amma faka sicsauha nga keracmangang amma desureyoac nga sebiengeng amma ubafong, ");
INSERT INTO ded_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","imoc sasawango ubahereunac erema ngic heidzadzu kpeude.” ");
INSERT INTO ded_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Anu Yesungo yacma imohacnac kenec. Kemma Tiro nga Sidong amabangecfu kensikema ama monnu enec. Enu ngicngac yeni taong imohai siduha mi negenggecdeac, ifi negenec amma ye ine sufuma tarudeac obohoec. ");
INSERT INTO ded_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ammanu imohaingoc Sirofoinikia bangecfunac grikngac mongngo haec. Hama Yesuac haniu makpema naroanga asu seuhagoc kporacmiudeac derecgemiec. ");
INSERT INTO ded_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Derecgemiu Yesungo yofi edeec, “Nambarac yeni yaka warac warac nema gebecyunubeso. Nambarac yeneac yaka wangecyunuma kasi yenearu ukunide, imocngo faka gombunga kpac.” ");
INSERT INTO ded_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ifi deu ngacngo meremmiec, “Kebu, imoc negenduae, amma kasi yeni sifu nambarac yeneng yaka kisisickegec tebo bageau maande, imocsac neandae.” ");
INSERT INTO ded_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ifi deu Yesungo yofi edeec, “Ge yoac ifi denecac kenna, hadehade ye naroangga bic wadac.” ");
INSERT INTO ded_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ifi deu ngac ye ameau kemma henu hadehadengo naroanga bic wau naroang ye fefeau waickema feec. ");
INSERT INTO ded_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesungo Tiro bangecfunac dzigenema Sidong taong ferecgema Dekaporisi bangecfu sing kemma Gariraia dzohonnu kensikeec. ");
INSERT INTO ded_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kensikemanu ngicngac yeneng ngic mong kedzacfong nga yoac dedeac enara ebiria, ye mehama Yesu mariango kpesereudeac desambic ammigec. ");
INSERT INTO ded_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ifi degec negemma ye ngichabu yenearunac meickema ngic ngadeau faiu nanu gbongango kedzahau faima mariau sofohoma nedzaranga kpesereec. ");
INSERT INTO ded_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kpeserema kurumennu fiu enu asu heima deec, “Effata!” Imocac titiha yofi, “Ge sarina!” ");
INSERT INTO ded_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ifi deu ngic kedzaha bic sariu nedzaranga monggoc merenu yoac tongganang deec. ");
INSERT INTO ded_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ifi deu Yesungo faka fingerecmoc, imoc ngicngac yeneng mi deyadigecdeac seria yombong deracyunuu yeni ine imoc monggoc deyadiyombonggema degec. ");
INSERT INTO ded_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ifi degec ngicngac yeni homac wareckema kerectegec amma degec, “Ye wiac sasawa mema kecde, imoc ngereeyombonggedacde. Ye ngicngac kedzacfong yeneac kedzac mesariude nga yoacngina kpac, yeni yoac meficgeyemmeude.” ");
INSERT INTO ded_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naso imohai ngicngac habutoa yeni monggoc Yesuaru hama kpeturanggegec. Nga yakangina kpac anu Yesungo medacfora kpacyunuma yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ngicngac yomoc yeni yakangina kpac uameme harebec bic nigoc kecdauac ubana manganede. ");
INSERT INTO ded_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Goa yeni amabangec hereaunac hagecac yakaya kpacfu sueyunuba amanginau kengkecma kicgigi ayemmebacac.” ");
INSERT INTO ded_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ifi deu medacfora yeneng degec, “Nenang bangec kisi yofiau yaka dafiu meficgema habutoa yemmeni gebecyunuude?” ");
INSERT INTO ded_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ifi degec Yesungo kpesiyemmeec, “Ngeni ic sogong dafiguc mekecdae?” deu yeni “Seweng” degec. ");
INSERT INTO ded_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ifi degec negemma Yesungo habu bangecfu matacgecdeac edeyunuec. Edeyunuma ic sogong seweng mema Anutuac ubangerec dema tuema medacfora yemmeu yeneng mederema ngicngac arennu yemmegec. ");
INSERT INTO ded_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Amma ye kondungyangbisic bisic goa metacgecmoc, imoc ifingoc Anutu ubangerec edema faiyemmegecdeac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Faiyemmegec yeni negec gebecyunuu yaka tosea tarec, imoc mema kpedzucnegec sakac 7 anec. ");
INSERT INTO ded_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nga ngic 4 tauseng ihai tacgec, yeni negec wisickeu sueyunuu kengha anggec. ");
INSERT INTO ded_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nga Yesu ye imohaingoc medacforagoc gombau emma Darimanuta bangecfu kenggec. ");
INSERT INTO ded_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisaio yeneng hama Yesugoc yoacngina engemmama anec. Yeni kuha isinggegecdeac faka kuhagoc mong kurumennunac meu henggecdeac derecgemigec. ");
INSERT INTO ded_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ifi degec yeng ongaasuyau ebic meficgema yofi deec, “Naso yomocac ngicngac ngeni nocac faka kuhagoc henggecdeac derecgeandae? Foracngoc, ngicngacareng yomoc ngenearu faka kuhagoc mong naric mi fingecngemmeude, imoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ifi dema ngic imoc wayunuma gombau monggoc emma dzohong nobocgeng kenggec. ");
INSERT INTO ded_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naso imohai medac yeni ic sogong nigecyunuu mocgusac gombau taru mekenggec. ");
INSERT INTO ded_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nga Yesungo gorongina kpema yofi edeyunuec, “Ngeni farisaio nga Herode yeneac yis, imocac henghomema kecbisia.” ");
INSERT INTO ded_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ifi deu yenaocngoc denegeng amma degec, “Nenang ic sogonnina kpac, imocac amma ifi dede.” ");
INSERT INTO ded_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ifi denegeng anggec ye imoc negemma edeyunuec, “Ngeni ic sogong mi mehadauac denegeng andae nga ngeni yoac imoc wagec. Ngeni herenegen negengngina dzege dzegeaac amma wiac mong mi negentegecdae. ");
INSERT INTO ded_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ngeni kicnginagocngo wiac mi hengandae nga kedzacnginagoc ammanu wiac mi negengandae. ");
INSERT INTO ded_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ni ic sogong 5 tuema ngic 5 tauseng gumecyunuba tosea taru sakac dafiguc kpedzucnegec wakeec, imoc bic nigecngunuec me?” Kpesiyemmeu yeni 12 degec. ");
INSERT INTO ded_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Anu monggoc ic sogong 7 tuema ngic 4 tauseng gumecyunuba tosea taru sakac dafiguc kpedzucnegec wakeec?” kpesiu yeni 7 degec. ");
INSERT INTO ded_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ifi degec yeng yofi edeyunuec, “Ngeni yaguc ifingoc negen negengngina mi ireckedengoc.” ");
INSERT INTO ded_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Anu yeni Betsaida amabangecfu kensikemagec ngicngac yeneng ngic kicpisic mong Yesuaru mehama mariango kpesereudeac desambic ammigec. ");
INSERT INTO ded_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ifi anggec ye kicpisic mariau mema guruama ngadeau hesicke kemma kiwau sofohoma mariango witiau faima kpesimiec, “Ge wiac mong hennec me?” ");
INSERT INTO ded_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kpesimiu kicpisic yeng kic fima deec, “Ngic yeni siricngina ic isoc yenemba kengha andae.” ");
INSERT INTO ded_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ifi deu Yesungo kiwau maria monggoc faiu ngereema wiac sasawa gombunga nga dindingac henec. ");
INSERT INTO ded_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Henu suema yofi edeec, “Ge amagau kemma taonnusing mi embesena.” ");
INSERT INTO ded_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Amma Yesungo medacfora yenigoc Kaisarea Firipo taonnu kenggec. Sinnu kemmagec yeng medacfora yofi kpesiyemmeec, “Ngicngac yeni neac merac deandae?” ");
INSERT INTO ded_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ifi deu degec, “Ngic goango Yohane dokunadzic deandae nga goango Eria amma goa yeneng ine profete mong esea deandae.” ");
INSERT INTO ded_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ifi degec yofi kpesiyemmeec, “Anu ngeni ngenaoc ine neac merac deandae?” deu Petorongo deec, “Ge Messia.” ");
INSERT INTO ded_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ifi deu yeng yoac imoc ngic mong mi edeyunugecdeac deracyunuec. ");
INSERT INTO ded_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Anu Yesungo yofi edekpou ayemmeec, “Ngicac Medac ye kpendzeng homac kpebeso. Yudangic enarafocngina nga womong gareng enara amma mitiac negen negengngic yeneng ye ubango wama kpegec homebeso. Homeu uameme harebec ammanu monggoc gborima yacbeso.” ");
INSERT INTO ded_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yoac imocac didiu yombong edeyunuu Petorongo ngadeau wangec kemma tembucfu namma kpetarimiyombonggeec. ");
INSERT INTO ded_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kpetarimiu Yesungo dzigenema kiwa medac yenearu fima Petoro kpetarimima edeec, “Satang, ge ngadenau hakenna. Ge wiac negennec, imoc Anutuarunac kpac, imocngo ine ngicac negen negeng ande.” ");
INSERT INTO ded_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesungo habu nga medacfora kpacyunuma yofi edeyunuec, “Ngic mong ye ni modacnubeso negendeu ye yengena ubasebiaac songo memama mariponga miacma tofohoma modacnubeso. ");
INSERT INTO ded_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Imoc yofiac, ngic mong ye kekeha segereudeac negemma uaya mede, ye kekeha sufumiude. Nga ngic mong ye neac amma nga siduc gombunggac amma kekeha waude, ye ine kekeha fingecmiude. ");
INSERT INTO ded_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Imocac ngic mongngo bangectoa bangec yomocac wiac sasawa meficgeecac kekeha ukuu sufuude, imocngo ngic naric mi meficgeude. ");
INSERT INTO ded_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngickekec monggoc memeaac sing mong mi fede. ");
INSERT INTO ded_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Imoc yofiac, ngic mongngo neac negenu gameagoc anude amma neac yoacnaac negenu gameagoc ande, yearu yofi fingerude, Ngicac Medacngo Mamaac kuc nga kibikperagiau angero kpetiac yenigoc haude, yeng ngic imoc yeac ifingoc negenu gameagoc anude.” ");
INSERT INTO ded_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesungo torokpema yofi edeyunuec, “Foracngoc, ngic yomoc nandae, ngenearunac goa mi homemagec Anutuac eucerereng kuhagoc fingectegeru henggecde, imoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Anu uameme 6 wisickemanu Yesungo Petoro nga Yakobo amma Yohane meyunuu tikitoa herea monnu tembucngina kecgecdeac enggec. Emma sebia kicnginau heimeremma siriha mong yombong anec. ");
INSERT INTO ded_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ngakpia hereha kperagima kongac koporarac yombong anec. Bangecfu ngic mongngo wamba kongac kongac ifia naric mi meficgeude. ");
INSERT INTO ded_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Anu imohaingoc Mose nga Eria fingecyemmema Yesugoc yoac denegeng anoc. ");
INSERT INTO ded_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ifi anggec Petorongo Yesu edeec, “Kpoukpou, yei kecni songea andeac bedzo bedzo harebec meni. Geac mong nga Moseac mong amma Eriaac mong.” ");
INSERT INTO ded_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yeni homac kengecyunuecac ye noc wiac debeso, imoc obohoec. ");
INSERT INTO ded_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ifi nammagec hoeng mongngo hama semeyunumanu hoeng manaunac yoacudumeng mong yofi fingerec, “Yomoc neac Songomedacna, ngeni yeac yoac negembisia!” ");
INSERT INTO ded_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yoac wisickeu imohaingoc yeni fikengfiha amma Yesungosac yenigoc nanu henggec nga ngic mong mi henggec. ");
INSERT INTO ded_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nga yeni tikiunac mamagec Yesungo deracyunuma yofi deec, “Ngeni wiac hendaumoc, imocac siduc ngic mi edeyunubisia. Kecma Ngicac Medac homecfunac gborima yaruguc ine debisia.” ");
INSERT INTO ded_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Edeyunuu medac yenaocngoc kpesiemegec, “Homecfunac gborima yacyac, imocac hania dafi?” ");
INSERT INTO ded_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yeni yofi dema kpesimigec, “Mitiac negen negengngic yeni dafiac Eriango waraima haudeac deandae?” ");
INSERT INTO ded_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ifi degec yofi edeyunuec, “Eriangonoc hama wiac sasawa memengere anude. Nga mitikibiu yofi oho ohoya fede, ‘Ngicac Medac ye kpendzeng homac kpeu desure ammigecde.’ imoc dafiac negensidae?” ");
INSERT INTO ded_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amma yofi edengunuba, “Eria ye bic haec nga ngic yeni songonginaac arennu faka hania hania ammigec, imoc yeacnoc oho ohoya fede.” ");
INSERT INTO ded_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yeni tikiunac mama medacfora goa yeneng yenearu hama henggec ngicngac homac yeneac botucfu mitiac negen negengngic yenigoc yoacngina engemmama anec. ");
INSERT INTO ded_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nga ngicngac nanggec, yeneng Yesu hemma kpidohoma bic nedzikemma wenacngerec demigec. ");
INSERT INTO ded_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ifi anggec Yesungo kpesiyemmeec, “Ngeni nocac yoacngina engemmama ande?” ");
INSERT INTO ded_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ifi deu habu yenearunac ngic mongngo deec, “Kpoukpou, hadehade mong yoara kpacngo medacnaac enac mema medzickeu gearu mehaduae. ");
INSERT INTO ded_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nga hadehadengo naso homac ye mema kpekpefac ammiande. Ammiu ye hanimaria goriu enaraunac nambang sofororoc ereu enara kirandziande. Imocac medacfocga yeneng asu mangana kporacmigecdeac deba yeni kporacbibiema wadau.” ");
INSERT INTO ded_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ifi deu Yesungo yofi merenec, “Areng yomoc ngeni negen negensingngina kpac yombong. Ni ngenigoc naso herea monggoc tacbadeac modzona tide. Ngeni medac imoc megec hau.” ");
INSERT INTO ded_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ifi deu mekenggec hadehadengo Yesu hemma medac kpefahau bangecfu makpeec. Makpeu enaraunac nambang nga sofororoc ereec. ");
INSERT INTO ded_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ereu Yesungo mama kpesimiec, “Hafei yomoc noc nasoac hanahema fingecmiec?” deu mamango deec, “Imoc sabahaungoc fingecmiec. ");
INSERT INTO ded_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Fingecmiu hadehadengo naso homacngoc medac kpehomeudeac gerecfu me dokuu kpefahau kemeande. Nga ge meficnurunadeacsoc andeu sifu ubaga manganeu meficnuruna.” ");
INSERT INTO ded_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ifi deu Yesungo yofi edeec, “Imoc ambadeacsoc, denec. Ngic mong ye negensinggede, yearu wiac sasawa naric fingerude.” ");
INSERT INTO ded_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ifi deu imohaingoc medac mamango arohoma deec, “Ni negensingguba negen negensinna wegenedeac geng meficnuna.” ");
INSERT INTO ded_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ifi deu ngicngac homacngo Yesuaru nedzima kenggec yeng yenemma asu seuhagoc yoac seria ammima yofi edeec, “Asu kedzacfong amma yoacga kpac, ni edeguduae, ge medac imoc wama erema kemma monggoc dzigenema yearu mi kembesena.” ");
INSERT INTO ded_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ifi deu hadehadengo kucgoc yombong arohoma tima erema kenu medac ye homemea isoc feec. Feu ngic yeneng imoc hemma bic homedac degec. ");
INSERT INTO ded_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ifi degec Yesungo ine mariau mema miaru yarec. ");
INSERT INTO ded_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yaru Yesungo amau enu medacfora yeneng tembucfu yegoc tacma kpesimigec, “Neni dafiac hadehade imoc kporacnideac obohoding?” ");
INSERT INTO ded_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ifi degec yeng yofi edeyunuec, “Hadehade ifia yakasege kecma nunumungo kporacbesonga.” ");
INSERT INTO ded_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu nga medacfora yeni ama imoc wama yofi negemma Gariraia bangec ferecgema kenggec, “Ngicngac yeneng imoc mi negembisia.” ");
INSERT INTO ded_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nga ye imohai kemma medacfora yofi edekpou ayemmeec, “Ngicngac yeni Ngicac Medac kererema ngic yeneac mariu faigecde. Faigec yeneng ye kpegec homeude. Homeu uameme harebec ammanu gborima monggoc yarude.” ");
INSERT INTO ded_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ifi deu yeni ine imoc mi negentegecma kpesigecdeac kengecyunuec. ");
INSERT INTO ded_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Anu Yesungo Kafanaung taonnu kensikema amau emma medacfora yofi kpesiyemmeec, “Ngeni sinnu noc wiacac denegeng andau?” ");
INSERT INTO ded_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kpesiyemmeu waickema tacgec nocac yeni sinnu yenanggarunac merang engena kecde, imocac denegeng anggec. ");
INSERT INTO ded_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tacgec Yesungo medacfora 12 kpacyunuma yofi edeyunuec, “Ngic mong ye enara kecbeso negende, yeng ngic tosofora sasawa, ngeneac ngadeu kecma ngeneac kingangkpekpe ambeso.” ");
INSERT INTO ded_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ifi dema nambarac yenearunac mong mema botucnginau faima hoanggema yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ngic mong ye nambarac yenearunac mong yofia neac kpacfu hoanggeude, ye ni hoannuude. Nga ngic mong ni hoannude, yeng nisac mi hoannuude, kpac. Yeng Anutu suenuec, ye ifingoc hoanggeude.” ");
INSERT INTO ded_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Anu Yohanengo Yesu yofi edeec, “Kpoukpou, ngic mong ye geac kpacfu hadehade nga yafing kporacyemmeu hending. Amma ye nenanggoc mi kecdeac kpetarimiding.” ");
INSERT INTO ded_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ifi deu Yesungo yofi deec, “Ngeni mi kpetarimibisia. Ngic mong ye neac kpacfu ua mong kuhagoc meude, yeng kpacna bic mi demanganeude. ");
INSERT INTO ded_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ngic mong ye neneac ngaba mi ande, yeng ogonina anude. ");
INSERT INTO ded_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nga ngic mong ye ngeni Kristoac medac dema doku kpakenecfu kpengemmeu negecde, foracngoc, yeng wiac imocac buma mi obohoude, imoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Amma nambarac kapia mongngo ni negensinnukecde, ngic mongngo nambarac ifia faka mangana kpoumibacac amma ye yagucnoc dzamandzingtoa ubeau ubahemima kondungtoau ukugec kemeu, imocngo ngic yearu ngereebac. ");
INSERT INTO ded_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nga mariga mongngo anggenu kopocsic meficgenadeu ge imoc herecgema ukubesena. Mariga yohockanggoc kecma hofeac gerec pisic pisickea kpac, imohai kemebanggac maritegec kecma kekecseriu enna ngereeude. ");
INSERT INTO ded_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‘Hofeu kamangina mi homeude nga gerecngo mi pisickeude.’ ");
INSERT INTO ded_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Amma haniga mongngo anggenu kopocsic meficgenadeu imoc herecge ukubesena. Haniga yohockanggoc kecma hofeu kemebanggac hanitegec kecma kekecseriu enna ngereeude. ");
INSERT INTO ded_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘Hofeu kamangina mi homeude nga gerecngo mi pisickeude.’ ");
INSERT INTO ded_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Me kicga mongngo anggenu kopocsic meficgenadeu imoc mesiukubesena. Kicga yohockanggoc kecma hofeu kemebanggac kicga mocgusacgoc kecma Anutuac eucerereng manau enna ngereeude. ");
INSERT INTO ded_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Hofeu kamangina mi homeude nga gerecngo mi pisickeude.’ ");
INSERT INTO ded_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ngicngac kondung hosoandae, ifi isoc ngicngac sasawa gerecngo hosoyunubesonga. ");
INSERT INTO ded_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kondung imoc wiac gombunga nga imocngo ine kiacma songea kpac anudeu geng songea monggoc naric mi meficgenade. Ngeni kondung songea ubaherenginau mekecma ruaefaka angemmebisia.” ");
INSERT INTO ded_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesungo bangec imoc wama Yudaia bangecfu Yodang nobocgengau kenec. Kensikeu ngicngac habutoango yearu monggoc kemma kpeturanggegec. Kpeturanggegec ye fakaya modacma edekpou ayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nga farisaio goa yeni ye tobanggegecdeac negemma kpesimigec, “Ngic mong ye enema naric waude, imoc singngo dede me kpac?” ");
INSERT INTO ded_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ifi degec yofi merengyemmeec, “Mosengo imocac dedeseriyoac dafi ngemmeec?” ");
INSERT INTO ded_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ifi deu yeneng degec, “Mosengo yofi naric annideac deec, ‘Mong ye ngac wabeso dema yeng wawakibi mima wau kembeso.’” ");
INSERT INTO ded_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ifi degec Yesungo yofi edeyunuec, “Ngeni ngic ubaseri nga herengina dzege dzegea, imocac Mosengo dedeseriyoac imoc ohongemmeec. ");
INSERT INTO ded_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nga hanac hanaheau Anutungo siricngira ngic nga ngac anecdeac, ifi meficyuruec. ");
INSERT INTO ded_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Imocac amma ngicngo nonggomama wayuruma enemaaru kpeketahau ");
INSERT INTO ded_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yegoc sebi mocgu anecde. Ifi anecdeac yohockang monggoc mi andape, yeri sebi mocgu anecde. ");
INSERT INTO ded_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutungo wiac dzegeec, imoc ngicngo naric mi herecgebeso.” ");
INSERT INTO ded_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nga yeni amau monggoc emma medacfora yeneng imocac kpesimigec ");
INSERT INTO ded_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesungo yofi edeyunuec, “Ngic mongngo enema wama ngac mong meude, ye serofaka enema esea ammiude. ");
INSERT INTO ded_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nga ngac mongngo ewea wama ngic mong meude, ye serofaka ammiude.” ");
INSERT INTO ded_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ngicngac goa yeni Yesungo nambaracfocngina mariango kpesereyunuudeac meyunu hagec. Hagec medacfora yeneng ine kpetariyemmegec. ");
INSERT INTO ded_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ifi anggec Yesungo imoc hemma negenu homac manganeu yofi edeyunuec, “Nambaracbisic yeni nearu naric hagec, ngeni kpae mi heiyemmegec. Kurumenggac eucerereng imoc nambaracbisic yofia yeneac. ");
INSERT INTO ded_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Foracngoc, ngic mong ye nambarac kapia yeni isoc mi anudeu ye Anutuac eucererennu naric mi enude, imoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ifi dema nambarac tabucyunuma maria witinginau faima kenecyunuec. ");
INSERT INTO ded_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesungo kembesonga kemmanu ngic mongngo yearu nedzikemma yeac kicfu fafoc heima kpesimiec, “Kpoukpou gombunga, ni dafi amma kekecseriac maridzoming mebade?” ");
INSERT INTO ded_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ifi deu Yesungo yofi edeec, “Ge nocac gombunga denennec? Anutu mocgungo gombunga kecde. ");
INSERT INTO ded_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ge dedeseriyoac bic negennec, ‘Ge ngicngac mi yunuhomebesena, kaisero mi ambesena, hamangec mi mebesena, enacfu faifai mi ambesena, ngic yeneac wiac mong mi wangecyunubesena, nonggo manghocga seseheyurubesena.’” ");
INSERT INTO ded_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ifi deu yeng meremma edeec, “Kpoukpou, ge denec, imoc sasawa sebigborinaungoc angereai.” ");
INSERT INTO ded_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ifi deu Yesungo yearu kic fima yeac songo negemma yofi edeec, “Ge wiac mocguac kpedadanggenec. Ge kemma finacga sasawa fegende, imoc suena dzo kirecgeu imoc ngicngac makpekpea yemmebesena. Ifi anna kurumenggac dzofinac fingecgenu hama modacnubesena!” ");
INSERT INTO ded_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ifi deu ngic ye ubea manganeu negengebirima kenec nocac ye dzofinaha homac femiec. ");
INSERT INTO ded_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kenu Yesungo fikengfiha amma medacfora yofi edeyunuec, “Ngic dzofinactoanginagoc yeneng Anutuac eucerereng manau enggecdeac ambibieyombonggegecde.” ");
INSERT INTO ded_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ifi deu medac yeneng yoac imoc negemma kerectegec anggec monggoc yofi edeyunuec, “Nambaracfocna negenggec, ngic finactoayagocngo Anutuac eucerereng manau engeng, imoc uatoayagoc. ");
INSERT INTO ded_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamerengo bungic singau engeng, imoc ua efea nga dzofinactoagoc yeng Anutuac eucererennu engeng, imocngo ine uatoayagoc.” ");
INSERT INTO ded_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ifi deu yeni kerectegec yombong amma degec, “Ifi anu merang naric komoc kpeude?” ");
INSERT INTO ded_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ifi degec Yesungo kiwa yenearu fima yofi deec, “Ngicngac yeni imoc ambibiema wagecde nga Anutungo wiac sasawa naric mema wiac monggac mi obohoude.” ");
INSERT INTO ded_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ifi deu Petorongo deec, “Negennec, neni wiacnina sasawa wadacma ge modacguma kecdimbe.” ");
INSERT INTO ded_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ifi deu Yesungo yofi deec, “Ni fora yombong edengunuba, ngic mong ye amabangeha me daramunea me nonggomama me nambaracfora me amauaya, imoc neac nga siduc gombunggac amma waude, ");
INSERT INTO ded_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yeng turunga mi obohoude. Amma ye wiac wadac, imocac turunga naso 100 monggoc meude. Ngicngac yeni naso yomohai ama nga daramuna amma nonggonasia nga nambaracfora amma amaua migecde, imoc sisic ammima kpekporac ammimagec mekefude. Nga ngade bangec siriha mong haude, imohai Kebungo kekecseri ifingoc miude. ");
INSERT INTO ded_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Anu ngic warac warac kecdae, yenearunac homacngo ngadea anggecde nga ngadea kecdae, yenearunac homacngo warac warac anggecde.” ");
INSERT INTO ded_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Anu yeni sing modacma Yerusarennu kengkecmagec Yesungo waraiu medacfora yeni ye modacma negenggec wiac kuneng anec nga goa ye modacgec, yeneng kengec anggec. Nga Yesungo medacfora 12 ngadeau meyunuma wiac fingecmiude, imocac yoac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Negenggec, nenang Yerusarennu endimbe. Enni ngic yeneng Ngicac Medac womong gareng enara nga mitiac negen negengngic yeneac mariu faigec, yeneng ye homeudeac desigecde. Desima ye bangec monnunac ngic Anutu mi negemmidae, yeneac mariu faigecde. ");
INSERT INTO ded_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Faigec, yeneng faifagoc ammima sofohoma dzikacngo kpema kpehomegecde. Nga uameme harebec ammanu ye monggoc gborima yarude.” ");
INSERT INTO ded_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Anu Dzebedaioac medahora, Yakobo nga Yohane, yereng Yesuaru kemma deoc, “Kpoukpou, neri wiac monggac derecgede anecmenadeac negendipe?” ");
INSERT INTO ded_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ifi deec kpesiyemerec, “Ni noc wiac angecmebadeac negendape?” ");
INSERT INTO ded_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kpesiyemeru deoc, “Kecma kibikperagigau nerearunac mongngo foigau nga mongngo kanagau tacdede, imoc deserinemecna.” ");
INSERT INTO ded_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ifi deec Yesungo yofi edeyuruec, “Ngeri wiac kpesidape, imocac hania mi negenghomedape. Neng kpendzenggac kpakenecfu nebade, ngeri imoc ifingoc neecdeac dedape nga doku nadzicbade, ngeri imohai nadzirecde me?” ");
INSERT INTO ded_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ifi deu yereng deoc, “Oc, naric andede.” ifi deec Yesungo yofi edeyuruec, “Ni kpakenecfu nebade, imoc ngeri ifingoc neecde nga doku nadzicbade, imoc ngeri ifingoc nadzirecde. ");
INSERT INTO ded_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nga merang foinau me kananau tarude, imocac fora ine neng naric mi desibade. Tatac imoc ngic damoc yeneac mengec mengerea fede, yeneng ihai tacgecde.” ");
INSERT INTO ded_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Anu medacfora 10 yeneng imoc negemma Yohane nga Yakobo yereac negenggec manganeec. ");
INSERT INTO ded_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Manganeu Yesungo kpacyunuu kenggec yofi edeyunuec, “Bangec monnunac ngicngac enarafocngina deyecdeyemmea, yeni ngicngac yeneac ngickuneng siricfu yenigoc kecandaeac kuc feyemmede. Nga kunengfocngina yeni kuc feyemmeu ngicngacfocngina yeneng yoacngina modacgecde, ngeni imocnoc negendae. ");
INSERT INTO ded_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nga ngenearu faka ifia ine mi fingecbeso, kpac. Ngenearunac ngic mongngo engena kecbeso ammide, yeng ine botucnginau kingang kpekpengina kecbeso. ");
INSERT INTO ded_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Amma ngeneac botucfunac mongngo warac warac ambeso ammide, yeng tosofora sasawa, yeneac wanacngic kecbeso. ");
INSERT INTO ded_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Imoc yofiac, ngicngac yeneng Ngicac Medac kingang kpemigecdeac mi maec, kpac. Yeng ine yeneac kingang kpema ngicngac homac yungecyunuma kekeha wau yeneac doudeac maec.” ");
INSERT INTO ded_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu nga medacfora yeni Yeriko taonnu kensikegec. Ihai kecma ngicngac habutoa yenahafoc Yeriko monggoc wagec. Wamagec ngic kicpisic mong kpara Batimaio, imocac titiha Timaioac medac, yeng sing tegiau tacma iwaiac derecgekefec. ");
INSERT INTO ded_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Derecgekefu Yesu Nadzarete taonnunac, yeng hama kende, yeni yoac ifi degec ye imoc negemma kucgoc kpacma deec, “Yesu, Dawidiac bangec, ge neacnec ubaga manganeu.” ");
INSERT INTO ded_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ye serima ifi kparu ngicngac homacngo waicke tarudeac edegec. Edegec yeng ine seria monggoc kparec, “Dawidiac bangec, ge neacnec ubaga manganeu.” ");
INSERT INTO ded_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kparu Yesungo namma yofi deec, “Ngeni kpacgec ye nearu hau.” deu ngic yeneng ngic kicpisicac kpacma degec, “Ye kpacgude, ge ubaga ngereeu yacma kenna.” ");
INSERT INTO ded_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ifi degec ngic ye ngakpihereha ukuma futucke yacma Yesuaru kenec. ");
INSERT INTO ded_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kenu Yesungo kpesimiec, “Ni noc wiac anggembadeac negennec?” deu ngic kickundungngo deec, “Kpoukpou, kicfifi ambadeac negenduae.” ");
INSERT INTO ded_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ifi deu Yesungo yofi edeec, “Negen negensinggango mengeregudac imocac naric kenna!” Ifi deu ye imohaingoc kicfifi amma Yesu sinnu modacma kenec. ");
INSERT INTO ded_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Anu yeni kengkecma Yerusareng taong mewegenebeso amma Oriwa tikiu Betefage nga Betani amabangec tarocfu kensikegec. Kensikemagec Yesungo medacfora yenearunac ngic yohockang sueyuruma yofi deec, ");
INSERT INTO ded_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ngeri dindingac kemma guruama sing enarau tacde, imohai emma donggi medaha mong ngicngo witiau mi tatara, imoc witickegec nande, ngeri imoc meficgema witic yungecma mema haec. ");
INSERT INTO ded_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yungerec ngic mongngo kpesingemecma deude, ‘Ngeri dafi anecdeac andape?’ ifi deu yofi edebesera, ‘Kebungo imocgoc ua meudeac dede.’ ifi deec minginango donggi bic faiu haude.” ");
INSERT INTO ded_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ifi deu yeri kemma donggi medaha sinnu ama naguyau witic witickea nanec, imoc hemma yungeroc. ");
INSERT INTO ded_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yungerec ngic goa ihai nanggec, yeneng yeremma degec, “Ngeri dafi negemma donggi medaha yungecdape?” ");
INSERT INTO ded_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ifi degec yeri Yesungo yoac edeyuruec, imoc edeyunuec yeni negemma wayurugec kenoc. ");
INSERT INTO ded_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kemma donggi Yesuaru mekemma ngakpingira herea hesima donggi medaha witiau tiameec Yesungo imocac witiau tarec. ");
INSERT INTO ded_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Taru ngicngac homacngo ngakpingina herea hesima sinnu tiamegec goango ua tegiaunac ic fawa herecgema sinnu faikenggec. ");
INSERT INTO ded_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nga ngicngac kiwau kenggec nga ngadeau modacgec, yeneng kpacma yofi degec, “Ohec, ngic Kebuac kpacfu hade, ye kenehagoc, hosanna. ");
INSERT INTO ded_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mannina Dawidiac eucerereng hade, imoc kenehagoc. Wi kurumennu kpara dengeregec, ohec waec, hosanna.” ");
INSERT INTO ded_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesungo ifi Yerusarennu emma Anutuac womonnu enec. Emma hennegeng andacma ama marai anecac medacfora 12 meyunuu Betania amau kenggec. ");
INSERT INTO ded_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wereckengau yeni Betania wama mama Yesungo hereaac homeec. ");
INSERT INTO ded_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Homema hereau fima fig ic mong maria tengging tengging henec. Hemma negenu foragoc isoc anu ic haniau kensikema maria meficgeec. Fig nasoya mi anecac ifi anec. ");
INSERT INTO ded_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nga ye fora hofocma ic yofi edeec, “Gearunac ngic mongngo fora monggoc mi nebeso.” ifi deu medacfora yeneng yoac imoc negenggec. ");
INSERT INTO ded_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesungo Yerusarennu kensikema Anutuac womonggac oda manau enec. Emma ngic wiac emekpesi anggec, yeni imohacnac kporacyunuec. Ye ngic hiedzo emekpesi anggec, yeneac tebo heimerenec nga kebesac emegec, yeneac tatac heimeremma ");
INSERT INTO ded_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Anutuac womong manau wiac ifia meenggecdeac kpetariyemmeec. ");
INSERT INTO ded_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kpetariyemmema yofi edekpou ayemmeec, “Yoac yofi oho ohoya fede, ‘Amana imoc bangeha bangeha ngicngac sasawa yeneac nunumuama, kpara ifi kpacbesonga.’ Nga ngeneng merenggec imoc ine hamangecngic yeneac sufu sufuama ande.” ");
INSERT INTO ded_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ifi deu womong gareng enara nga mitiac negen negengngic yeneng imoc negemma ye kpegecdeac sing hofocgec. Nga habu sasawango yeac kpoukpouyaac negenggec engena anec nga yeni ine yeac kengecyunuec. ");
INSERT INTO ded_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nga ama marai anu Yesu nga medacfora yeni taong wama kenggec. ");
INSERT INTO ded_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wereckengau yeni sinnu kemma henggec fig ic imoc godeaunacngoc sokuema nanec. ");
INSERT INTO ded_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nanu Petorongo imoc hemma negensima Yesu edeec, “Kpoukpou ge henna, ge fig ic soweckedang, imoc bic ururuema nande.” ");
INSERT INTO ded_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ifi deu Yesungo yofi merennec, “Ngeni Anutu negensinggebisia. ");
INSERT INTO ded_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Foracngoc, ngic mong ye ubeau negengyohoha kpac kecma wiac mong me mong dema imocac fora fingerudeac negensiudeu yeng tiki edimoc yacma kondunnu kemeu deu imoc foranoc fingerude, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ni imocac amma yofi edengunuduae, ngeni wiac imocac me imocac negensima menide, ifi negemma negensinggema numugec wiac imoc fingecngemmeude. ");
INSERT INTO ded_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Anu ngeni namma numuandae, imohai ngic monggac wiac me monggac ngaba mekecdaeu kopocsiha wabisia. Ifi anggec kurumeng Mangnginango ngeneac kopocsic ifingoc waude. ");
INSERT INTO ded_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nga ngeni ngic yeneac kopocsic mi wagecdeu ine Kurumeng Mangnginango ngeneac kopocsic ifingoc mi waude.” ");
INSERT INTO ded_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu medacforagoc yeni Yerusarennu dzigene enggec. Emma Yesungo Anutuac womong manau yerecgemanu womong gareng enara nga mitiac negen negengngic amma enarafocngina, yeneng yearu hama kpesimigec, ");
INSERT INTO ded_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Ge noc kucfu ua yomoc menec nga merang ua imoc menadeac uayoac genec?” ");
INSERT INTO ded_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ifi degec Yesungo yofi merengyemmeec, “Ni yoac mong kpesingemmeba turunga edenugecguc ni ifingoc uakibinaac hania imoc edengunubade. ");
INSERT INTO ded_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohanengo dokunadzic ua mekefec, ua imoc kurumennunac me ngicfunac, ngeni imoc edenugec negemba.” ");
INSERT INTO ded_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ifi deu yeni yenaocngoc denegeng amma degec, “‘Imoc kurumennunac.’ ifi denideu yeng yofi kpesinemmeude, ‘Ifi negemmaguc ngeni nocac ye mi negensinggegec?’” ");
INSERT INTO ded_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nga ngicfunac, imoc debesonga ngic yeneac amma kengecyunuec. Nocac ngic yeni sasawango Yohane ye profete fora, ifi negenggec. ");
INSERT INTO ded_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Imocac yeni Yesu meremmigec, “Imoc mi negendimbe.” degec Yesungo yofi merengyemmeec, “Ifi degec, ni ifingoc noc uayoacac kucfu ua mekecduae, imoc mi edengunubade.” ");
INSERT INTO ded_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesungo monggoc yoac heima yofi edeyunuec, “Ngic mongngo waing ua gboria mong homecma oda dzegeec. Dzegema waing tidzac tidzameac teng usuma gareng yeneac kicfifiac amaherec meec. Meu wisickeu waing ua garenggegecdeac ngic meficyunuma yenigoc yoac dedzege anggec nga yengenaoc ine bangec hereau kenec. ");
INSERT INTO ded_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kemma kecmanu fora kpememe naso hau wanacngiha mong sueu waingngic yenearunac waing uaac fora noboha yeac anec, imoc meudeac kenec. ");
INSERT INTO ded_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kensikemanu waingngic yeni wanacngic mema dzoboya kpema entegeng suegec kenec. ");
INSERT INTO ded_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kenu minginango wanacngic mong yenearu sueu kenu yeneng ye kpefuhama desofoc ammigec. ");
INSERT INTO ded_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ifi ammigec ua minginango serima wanacngic monggoc mong sueu yenearu kenu ye kpehomegec. Kpehomegec ua minginango wanacngic homac sueyunuu kenggec ua ngic yeneng medac goa dzoboyunugec nga goa ine yunuhomegec. ");
INSERT INTO ded_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wisic wisickeau ua minginango songomedacyombonga mocgu kefec, ye yofi negemma sueec, ‘Yeni sifu medacyombonna eweheimigecde.’ ");
INSERT INTO ded_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ifi negemma sueu ua ngic yeneng ine medacyombonga hemma denegeng amma edeemegec, ‘Yeng kecma ua yomoc tiu enude, imocac ngeni hagec kpeni bangeha nga maridzominga imoc nenang ambeso.’ ");
INSERT INTO ded_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yeni ifi dema ua minginaac medacyombonga mema kpehomema farenga waing ua ngadeau ukugec kemema feec. ");
INSERT INTO ded_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Anu ua minginango dafi anude? Ye hama waing ua ngic yunuhomema waing uaya imoc ua ngic areng mong yemmeude. ");
INSERT INTO ded_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mitikibiu yoac yofi oho ohoya fede, ‘Amameme ngic yeneng hoc mong mangana dema ukugec. Nga hoc imocngo amaac hoc wotung amma seria nanude. ");
INSERT INTO ded_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nga faka imoc Kebu yengenaoc meu ngicngo hensongo ammidimbe.’ Ngeni yoac imoc osonegeng angandae.” ");
INSERT INTO ded_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nga Yesungo enara yeneac negemma yoac imoc heima deec, yeni imoc bic negenggec. Nga yeneng ye mendanggegecdeac sing ine hofocgec. Nocac yeni ngicngac yeneac kengecyunuu wama kenggec. ");
INSERT INTO ded_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ngicenara yeneng Yesu tobanggegec yoacdedeau makpeu yoacfu faigecdeac negemma yofi anggec. Yeni farisaio nga Herodeac arennunac ngic goa yearu sueyunugec ");
INSERT INTO ded_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","yeneng Yesuaru hama degec, “Kpoukpou, yoac fora dema ngic engena me mamea yeneac mi negensiannec. Ge ngicngac areng socfungoc ayemmekecnec, imoc negendimbe. Nga ge Anutuac sing dindingac edekpou anemmekecnec. Ifi anu ngictau Sisa takesi mibesonga me mi mibesonga, singngo dafi dede? Nenang ngictau Sisa takesi naric minide me kpac?” ");
INSERT INTO ded_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ifi degec Yesungo ikocfakangina negentegecma yofi edeyunuec, “Ngeni nocac faitobannu fainudae? Ngeni dzo mong meficgema edzacnugec hemba.” ");
INSERT INTO ded_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ifi deu yeni dzo mong migec yeng imoc hemma yofi kpesiyemmeec, “Onga nga kibi yoc, imoc meracac?” kpesiyemmeu degec, “Imoc Sisaac.” ");
INSERT INTO ded_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ifi degec Yesungo yofi edeyunuec, “Imocac ngeni Sisaac wiac, imoc Sisa mibisia nga Anutuac wiac, imoc Anutu mibisia!” Ifi edeyunuu negemma kpidohogec. ");
INSERT INTO ded_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukaio areng yeni homecfunac yacyac mi fede, ifi dekecdae. Nga yenearunac ngic goa Yesuaru hama kpesimigec, ");
INSERT INTO ded_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kpoukpou, Mosengo dedeseriyoac yofi ohonemmeec, ‘Ngic mong ye ngac mema gboriha mong mi kpeficge kecma homeudeu ngac ye kefu muneango daraac hodzec mema gboric kpeficgema daraac kpac miacbeso.’ ");
INSERT INTO ded_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Naso monnu daramuna seweng yeni kecgec. Nga waracdacnginango ngac mong mema gboriha kpac kecma homeec. ");
INSERT INTO ded_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Homeu muneango ngac imoc mema ye ifingoc gboriha kpac kecma homeec. Homeu munea mongngo faka imocngoc anec. ");
INSERT INTO ded_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nga daramuna seweng yeni ngac imocngoc mema gboricfocngina kpac kecma homedacgec. Homedacgec hodzecngina kecma ngade homeec. ");
INSERT INTO ded_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Homeu ngic seweng yeneng ngac imocngoc megecac kecma yacyac nasou homecfunac yacgecde, imohai ngac imoc meracac enema anude?” ");
INSERT INTO ded_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ifi degec Yesungo meremma yofi edeyunuec, “Ngeni mitikibi nga Anutuac kuc, imoc mi negentegecdae, imocac amma yoac desufudae. ");
INSERT INTO ded_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kecma homegec yeneng homecfunac yacgecde, imohai ngicngac yeni mi meemegecde. Nga manggac mongngo ‘Ni naroanna ngic mibade.’ imoc naric mi deude. Yeni imohai kurumenggac angero, yeni isoc anggecde. ");
INSERT INTO ded_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nga homecfunac yacyac deba, ngeni yoac yomoc Moseac kibiu imoc osoandae, Mosengo icfu gerecborang fingeru hemma ihai kenu Anutungo yofi edeec, ‘Ni Abrahang nga Isaka amma Yakobo, yeneac Anutu.’ ");
INSERT INTO ded_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nga ye ngic homemea yeneac Anutu kpac. Ye ngic gbori kecdae, yeneac Anutu. Ngeni sing homac yombong segema kecdae.” ");
INSERT INTO ded_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anu Yesugoc demereng anggec, yeng turunga gombunga merengyemmeu mitiac negen negengngic yenearunac mongngo imoc hemma Yesuaru hama kpesimiec, “Dedeseriyoac damocngo engena yombong ande?” ");
INSERT INTO ded_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ifi kpesimiu Yesungo yofi deec, “Dedeseriyoac engenangina yofi fede, ‘Israengic ngeni negenggec, Kebu Anutunina ye mocgu nga ");
INSERT INTO ded_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ge ubaherega nga ongaga amma negen negengga nga kucga sasawa, imoc hafoangoc Kebu Anutugaac heresongo negemma kecbesena.’ ");
INSERT INTO ded_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nga mong yofi, ‘Ge geangga anggengande, siriha imocngoc ngicngac gegoc wegena kecdae, yeni heresongogoc hoangyunubesena.’ Dedeseriyoac imoc yereac engena mong mi fede.” ");
INSERT INTO ded_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ifi deu mitiac negen negengngicngo meremmiec, “Gombunga kpoukpou, ge fora yombong denec. Anutu ye mocgu, mongngo ye isoc mi kecde. ");
INSERT INTO ded_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nga ubaherega hafoangoc nga negen negengga hafoangoc amma kucga hafoangoc yeac songo heregoc negemma kecbesena amma geangga anggengande, siriha imocngoc ngicngac gegoc wegena kecdae, yeni heresongogoc hoangyunubesena, wiac imocngonoc Anutuac hosuc heihei amma sese hania hania ferahade.” ");
INSERT INTO ded_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ngic ye gombunga yombong merenu Yesungo negemma yofi edeec, “Ge Anutuac eucererenggac hereau mi kecnec.” Ifi deu yeni Yesu monggoc kpesimigecdeac kengecyunuu wagec. ");
INSERT INTO ded_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesungo Anutuac womonnu edekpou ayemmema yofi kpesiyemmeec, “Mitiac negen negengngic yeneng Messia ye Dawidiac kisicfunac nocac deandae?” ");
INSERT INTO ded_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawidi ye Asungo meefaiu yengenaoc yofi deec, “KEBUNGO neac Kebu edeec, ‘Ge foinaugeng tacmana ngabafocga yeni hanigaac bageu faiyunubade.’ ");
INSERT INTO ded_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawidi yengenaoc ‘Neac Kebu’, kparec. Nga Messia ye dafiu Dawidiac bangeha ande?” Ifi deu ngicngac habutoa yeneng negendzidziegec. ");
INSERT INTO ded_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ifi anggec Yesungo edekpou ayemmema yoac yofi torokpema edeyunuec, “Ngeni mitiac negen negengngic yeneac henghomema kecbisia. Yeni songonginaac amma ngakpi herea heima kecgec ngicngac yeneng wenacngerec deyemmegecdeac emenecfu kenghaandae. ");
INSERT INTO ded_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Amma kpekpeturang amau nga yakatoa nasou warac warac tatacfu tacbesonga songongina angkecde. ");
INSERT INTO ded_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Amma yeni ine ngachodzec yeneac ama wangecyunuandae. Amma negen ngereengunugecdeac nunumu herea here numuandae. Yeni ikocfaka ifia angandaeac turunga ebiriangoc megecde.” ");
INSERT INTO ded_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Anu Yesungo womonggac sesekatapa nobohau tacma henu ngicngac homacngo dzo imohai faigec kemeu ngic finactoagoc homacngo hama dzo ebiriangoc faigec kemeec. ");
INSERT INTO ded_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Anu ngac hodzec mongngo ifingoc hama peni sacsac yohockang faiu kemeec, imoc toea mong kapianecsac. ");
INSERT INTO ded_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Faiu Yesungo medacfora deu hagec yofi edeyunuec, “Foracngoc, ngac hodzec hiedzoya kpac yombong dzo faidacmoc, yeng ngicngac sasawa sese faidau, yeni feracyunude, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ngicngac tosea sasawa, yeneng finactoangina wakema made, imohacnac sesengina faidau. Nga ngac ye ine wiac femidac, imocnoc hafoangoc faidacma entegeng kecde.” ");
INSERT INTO ded_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Anu Yesungo Anutuac womonnunac mama kemmanu medacfora yenearunac mongngo edeec, “Kpoukpou, hoc gombunga gombunga nga ama kuneng kuneng tackende, imoc henna.” ");
INSERT INTO ded_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ifi deu Yesungo yofi edeec, “Ama kuneng kuneng tackenu hennec, imoc kecma naso mong haude, imohai wasaingic yeneng imoc sasawa hembarackegecde. Hembarackegec hoc mongngo monggac witiau wagec mi tarude.” ");
INSERT INTO ded_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesungo Oriwa tikiu Anutuac womong kiwa dindingacfu tacmanu Petoro nga Yakobo amma Yohane nga Anderea, yeneng yegoc tembucfu kecma kpesimigec, ");
INSERT INTO ded_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ge yoac dedang, imoc noc nasoac fingerude nga naso imohai noc soi fingecmanu yoac sasawa imoc seriude?” ");
INSERT INTO ded_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ifi degec Yesungo yofi edeyunuec, “Ngic mongngo ikocfu wangecngunubacac ngeni henghomema kecbisia. ");
INSERT INTO ded_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ngic homac yeneng hama neac kpac kpacma degecde, ‘Ni Messia.’ ifi dema ngicngac homac uba mesufu ayemmegecde. ");
INSERT INTO ded_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dzikactoaac siduc bangec wegenaunac nga bangec hereaunac hau ngeni imoc negemma mi kpidohobisia. Foracngoc, faka ifia fingecbeso. Nga naso wisic wisickea ine imohai bic mi haude. ");
INSERT INTO ded_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bangecareng goa yeneng bangecareng ogofocnginagoc dzikac kpema kecgecde. Nga ngictau monggac arengngo ngictau monggac areng yenigoc ngaba angemegecde. Bangec monnu nga monnu usoc meude amma bodinaso fingeckenude. Nga faka yomoc, imoc wiac gboria fingecbeso andeac ngac gadze kiude ifi isoc ande. ");
INSERT INTO ded_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Imocac ngeni ngenaocngoc garengemema kecbisia. Ngic yeni yoacfu faingunugecde amma kpekpeturang amau dzikacngo ngunugecde. Amma yeni neac amma ngictau nga gawana yenearu yoacfu faingunugec ngeneng ihai namma ni dekperaginubisia. ");
INSERT INTO ded_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ngeni bangeha bangeha ngicngac siduc gombung edekpou ayemmegec negendacgecguc ");
INSERT INTO ded_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ngic mengunuma ngic goa yeneac mariu faingunugecde, ngeni naso imohai, ‘Dafi denide?’ dema mi negengebiribisia. Tiri Asungo naso imohai yoac enacnginau faiude, ngeni imoc debisia. Ngeni yoac imohai degecde, imoc Tiri Asuarunac ambeso. ");
INSERT INTO ded_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Anu dac mongngo munea enara yeneac mariu faiu yeneng homecfu faigecde nga manggac mongngo medahaac imocngoc anude. Nga nambarac yeneng nonggo mangfocngina deendema ayemmema homecfu faiyunugecde. ");
INSERT INTO ded_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nga ngicngac sasawa yeneng neac kpacnaac amma ngeni ubango ukungunugecde. Nga ngic mong ye seserigoc kecmanu nasotoa haude, yeng komoc kpeude. ");
INSERT INTO ded_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Anu ngic mong ye yoac yomoc osoude, yeng imoc negentegecbeso. Wiac mangac manganea wiac sasawa kpetotieude, imocngo ama kpaeagocfu emma nanu henggecde, faka imoc fingeru ngicngac Yudaia bangecfu kecdae, ngeni worama tikiu embisia. ");
INSERT INTO ded_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nga mong ye ama witiau tacde, ye kemema ama manau emma wiac mong mi mebeso. ");
INSERT INTO ded_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nga mong ye semeng uau nande, ye ngakpi hereha meudeac mi dzigenebeso. ");
INSERT INTO ded_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Amma ngac heregoc kecdae nga nenggac sabac namuu meyunukecdae, yeni naso imohai ebictoanginagoc anggecde. ");
INSERT INTO ded_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Naso imohai kpendzeng kuneng siriha mong yombong figerude. Anutungo hanac hanaheaunac bangec sasawa meficgeecfunacngoc erema yaguc kecdimbe, naso imocac manau kpendzeng ifia mong mi fingerec amma ngade naric mi fingecbesande. Imocac amma ngeni wiac imoc nomannasou mi fingerudeac numubisia. ");
INSERT INTO ded_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kebungo naso imoc mi mewegenebac dede ngic mongngo komoc naric mi kpebac. Ngic meisingyunuyunuya, yeneac amma naso imoc bic herec herecgea fede. ");
INSERT INTO ded_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Naso imohai yoac yofi fingerude, ‘Henggec, Messia yei fingecde.’ me, ‘Ye edi fingecde.’ Ngicngac ifi degecdeu ngeni mi negensingyunubisia. ");
INSERT INTO ded_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Imoc yofiac, ngicngac fingecma ikoc amma degecde, ‘Ni Messia.’ yeni nga profete ikoha yeneng fingecma ngicngac uba mesufu ayemmegecdeac ngicngac tobangyunuma faka kuhagoc nga morora megecde. Amma yeni sing meficgegecdeu ngicngac meisingyunuyunuya ifingoc ikocfu wangecyunugecde. ");
INSERT INTO ded_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Faka sasawa imoc mi fingecmanu imoc bic edengunuduae. Ngeni imocac negemma henghomebisia. ");
INSERT INTO ded_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Anu kpendzeng imoc wisickemanu imohai ‘wenackiwa kundung kpeu afokperagia mi fingerude. ");
INSERT INTO ded_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nga asomeng yeni kurumennunac fotockema magec kurumenga kurumenga yeneac kuc sasawa kpemindzahegecde.’ ");
INSERT INTO ded_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naso imohai ngeni Ngicac Medac henggec yeng kuctoaya nga kibikperagitoayagocngo hoennu haude. ");
INSERT INTO ded_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hama angerofora sueyunuu bangec nga kurumeng tegia noboc noboc wisickede, imohai kenggec yengenaoc ngicngac meisingyunuec, yeni kpedzucyunugecde. ");
INSERT INTO ded_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Fig icngo hania edekpou angemmeu ngeni imoc negenghomebisia. Fawaya doku doku amma besaiu ngic ngeni yofi negengandae, wenac naso ande. ");
INSERT INTO ded_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nga ngeni wiac dedua, imoc fingeru hemma ifingoc yofi negembisia, Ngicac Medac nasoya bic wegenema hama nagu ngadeau nandenoc. ");
INSERT INTO ded_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Foracngoc, areng yomoc ngeni mi homemagec wiac yomoc fingecdarude, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Foracngoc, bangec nga kurumeng yeri kecma kpac anecde nga neac yoac ine mi kpac anude. ");
INSERT INTO ded_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nga faka imoc noc uamemeu amma aua nofu fingerude, imoc mongngo naric mi negenude. Kurumenggac angero yeni imoc mi negenggecde nga Medacngo ifingoc mi negenude. Manggacngosac naso imoc negende. ");
INSERT INTO ded_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ngeni garengngina mema ubagbori kecbisia. Nocac ngeni naso mi negendae. ");
INSERT INTO ded_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Imohai faka yofi isoc fingerude, ngic mongngo amea wama bangec monnu kenudeac negenec. Ifi amma ye amagareng wanacngicfora amaac wiac uanginaacsoc garenggegecdeac uayoac deyemmema nagugareng naguu kicfifi nanudeac edeec. ");
INSERT INTO ded_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Imocac ngeni ubagbori kecbisia. Minginango ama toforemanu me tofocnac dzongiau me ama werec wereckenggac me asoac nasou dzigeneude, ngeni imoc mi negendae. ");
INSERT INTO ded_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","37","Ngeni gaufemagec hama ngenembacac yoac yomoc ngeni nga ngicngac goa sasawa edengunuduae. Ngeni imoc negemma ubagbori kecbisia.” ");
INSERT INTO ded_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Makekenggac naso nga ic sogong yisya kpac nene, imocac hombanggac uameme yohockang feec. Femanu womong gareng enara nga mitiac negen negengngic yeni Yesu nofusing kic mesufu ammima mema kpegec homeudeac sing hofocma ");
INSERT INTO ded_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","yofi degec, “Ngicngac yenearu dzikac sicsauc fingecbacac amma ye hombang nasou mi mebesonga.” ");
INSERT INTO ded_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Anu Yesungo Betania amau ngic mong kpara Simong kubecserigoc, yeac amau yaka netarec. Netacmanu ngac mongngo alabastros kirung mong kerecdoku homung kerengagoc metarec, imoc mehaec. Doku imoc narda foraunac memea amma buma engena yombong. Ngacngo imocnoc mehama kirung ubea kpetackema Yesuac oruhau kpakema nadzicmiec. ");
INSERT INTO ded_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nadzicmiu ngic goa ihai tacgec, yeneng imoc hemma dehesi amma degec, “Ye nocac wiac buma engena ifi kpedzonggede? ");
INSERT INTO ded_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Doku homuna gombunga ifiango kifa mocguac uabung ferahema kirecgeu yeni imoc ngicngac makpekpea yemmegec ngereebac.” Ifi dema ngac yoac gereagoc ammigec. ");
INSERT INTO ded_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ifi ammigec Yesungo yoacngina negemma yofi edeyunuec, “Ngeni nocac ngacac ifi degec ubaebic meficgeude? Ngeni faka imoc wagec. Ye faka gombunga yombong anende. ");
INSERT INTO ded_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ngic makpekpea yeni nasosoc ngenigoc kecgec ngeni meficyunubeso angemmeu naric meficyunukecgecde. Nga neng ine ngenigoc nasosoc mi kecbade. ");
INSERT INTO ded_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ngac yomocngo sebina doku homunagocngo nadzicmiu ngeni farenna tonggogecde, imocacnoc yeng hanahema meefainude. Meefainuma yeac uaareng fede, imoc bic mesiude. ");
INSERT INTO ded_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Foracngoc, ngicngac yeneng siduc gombung bangectoa bangec, imohai kemma ngicngac edekpou ayemmegecde, imohai ngac yomocngo faka anec, imoc ifingoc degec negenggec feude, imoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Anu medacfora 12 yenearunac mong kpara Yuda Karioto amaunac, yeng Yesu meyemmeudeac dema womong gareng enara yenearu kenec. ");
INSERT INTO ded_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kenu yeni ubangerec negemma dzo migecdeac degec. Ifi degec Yudango naso gombung damohai Yesu doc mema yereac mariu faiude, imocac kicfifi kefec. ");
INSERT INTO ded_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ic sogong yis kpac, hombang imocac hanac hanaheau makekenggac ramamedaha kpeherecge angandae, naso imohai Yesuac medacfora yeneng Yesu kpesimigec, “Neni dahai kemma makekenggac ramamedaha nenideac memengere annideac negennec?” ");
INSERT INTO ded_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ifi kpesimigec yeng medac yohockang yofi dema sueyuruec, “Ngeri taonnuu emma ngic mong dokuenanga tofohoma hau yegoc ewacma ye modacbesera. ");
INSERT INTO ded_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Modarec kemma amau enude, ama imohai ama mingina yofi edebesera, ‘Kpoukpoungo yofi kpesigende, “Ama mana damohai mengerenenna ni medacfocnagoc makekenggac ramamedaha nenide?” ’ ");
INSERT INTO ded_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ifi deec yeng ama witiau amamana mong kuneng ihai wiac bic mengec mengerea tacdacde, imoc edzacnguruu ngeri imohai iwainina mengerebesera.” ");
INSERT INTO ded_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ifi deu medac yeri ama wama taonnu enoc. Emma Yesungo edeyuruec, imocac sirihau wiac meficgedacma makekenggac ramamedaha ohomengere anoc. ");
INSERT INTO ded_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Anu ama toforemanu Yesu nga medacfora 12 yenigoc kensikegec. ");
INSERT INTO ded_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kensikema yaka netacma Yesungo yofi deec, “Foracngoc, ngenearunac mongngo ni ngaba yeneac mariu fainuude, yennoc nigoc yaka nede, imoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ifi deu medac yeni negengebirima tembuc tembuc kpesimigec, “Ge imoc neac denec me?” ");
INSERT INTO ded_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ifi degec, yeng yofi merengyemmeec, “Imoc medac 12 ngenearunac mong anu yeng nigoc ic sogong terau nemuruckede. ");
INSERT INTO ded_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngicac Medac ye wangunuma kenude, imoc neac negemma oho ohoya bic fede. Nga ngic ye Ngicac Medac doc meude, ye ine sowehagoc. Ye nonggeaac here manaunac mi fingecbacfu efaibac.” ");
INSERT INTO ded_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Anu netacmagec Yesungo ic sogong mong mema Anutu ubangerec edema ic sogong imoc mendzicma medacfora yemmema yofi deec, “Ngeni yomoc megec, imoc fusina.” ");
INSERT INTO ded_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ifi dema kpakenec mong mema Anutuac ubangerec dema sasawa yemmeu negec. ");
INSERT INTO ded_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Negec yofi edeyunuec, “Yomoc neac sac, imocngo dzadzahac amma imoc ngicngac homac yeneac amma kpetic kpetinggea. ");
INSERT INTO ded_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Foracngoc, ni waing gbomeaac dokuya monggoc mi nene kecbarengoc Anutuac eucerereng manau waing gboria nebade, imoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Anu yeni Anutuac yegec heigec, Heima taong wama Oriwa tikiu enggec. ");
INSERT INTO ded_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Emma Yesungo yofi edeyunuec, “Ngeni sasawango neac negemmangang amma wanugecde, imoc yofi bic oho ohoya fede. ‘Ni ramagareng kpeba yeni sasawango sinsararang kpegecde.’ ");
INSERT INTO ded_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Anu neng ine gborima yacma waraingemmema Gariraia bangecfu kembade.” ");
INSERT INTO ded_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ifi deu Petorongo deec, “Ngicngac sasawango negemmangang amma wagugecdeu neng ine imoc naric mi ambade.” ");
INSERT INTO ded_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ifi deu Yesungo yofi edeec, “Foracngoc, yaguc tofocnac kokorecngo arohou atac yohockang mi ammanu geng neac busickpena harebec bic anude, imoc edeguduae.” ");
INSERT INTO ded_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ifi deu Petorongo serimangoc deec, “Ni gegoc homebade isoc sebi ine naric mi heibade.” Ifi deu ogofora yeni sasawango imocngoc degec. ");
INSERT INTO ded_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu nga medacfora yeni ua bangec mong kpara Gedzemane, imohai kenggec. Kensikema yeng medacfora yofi edeyunuec, “Ngeni yei tacmagec ni numubade.” ");
INSERT INTO ded_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ifi dema Petoro nga Yohane amma Yakobo meyunuu kenggec. Kemma negen negenga fonggou negengebirima ");
INSERT INTO ded_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","yofi edeyunuec, “Ubaonganango ebiriyombonggeu homebeso anende, imocac ngeni yei garengngina meemema tacgec.” ");
INSERT INTO ded_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ifi dema kpesima kemma bangecfu makpefema yofi numuec, “Imoc naric anu naso imocngo feracnubeso.” ifi ");
INSERT INTO ded_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","numuma yofi deec, “O Manggac manna, gearu wiac sasawa imoc efea. Ge kpakenec yomoc wangecnuna. Anu neac songo ine mi seribeso, kpac. Geac songo nga negen negeng imoc seribeso.” ");
INSERT INTO ded_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ifi numuu wisickeu dzigenema medacfora yenearu hama yenenu yeni gau fegec Petoro yofi edeec, “Simong, ge gau fenec, ge naric aua mocguac manau gaugbori kecbang me? ");
INSERT INTO ded_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nga faitobannu embauac ngeni ubagbori kecma numugec. Ongaasungo efaide nga sebingo ine ebiride.” ");
INSERT INTO ded_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ye ifi dema monggoc kemma nunumu imocngoc numuec. ");
INSERT INTO ded_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Numuma hama yenenu yeni monggoc gau fegec. Nocac yeni kicngina ebiriec. Nga ye yoac deu yeni meremmigecdeac obohogec. ");
INSERT INTO ded_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nga ye atac harebecfu dzigene hama yenemma yofi deec, “Ngeni gau femangoc kecdae, imoc naric mi ande. Yaguc ine wisickede nga naso bic hadac. Negenggec, ngic yeni Ngicac Medac kererema kopocsicmeme yeneac mariu faigecde. ");
INSERT INTO ded_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Benukererec ngicngo hadeac amma ngeni yacgec kenni!” ");
INSERT INTO ded_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Anu Yesu ye ifi demanungoc medac 12 yenearunac mong Yuda, yeng hau habu kunengngo wasaibeang nga gbarucnginagoc ye modacgec. Anu yeni womong gareng enara nga mitiac negen negengngic amma yudangic enarafocngina sueyunugec, yenearunac hagec. ");
INSERT INTO ded_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Hagec benukererec ngicngo yofi derecgeyemmeec, “Ni ngic muduckebade, ngeni yenoc mendanggema garenggeyombonggema mekembisia.” ");
INSERT INTO ded_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Anu Yuda ye hama Yesuaru bic kemma, “Kpoukpou.” dema muduckeec. ");
INSERT INTO ded_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Muduckeu yeni Yesu maria noboc noboc mema mendanggegec. ");
INSERT INTO ded_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mendanggegec medac yenearunac mongngo ine wasaibeang kpedzima womong garengtoaac wanacngic kpema kedzaha noboc herecgeec. ");
INSERT INTO ded_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Nga Yesungo yofi edeyunuec, “Ni wenacsoc ngenigoc kecma womonnu edekpou angemmeba ngeni imohai ine mi menugec. Nga yaguc ine godzungic meandae, ngeni ifi isoc wasaibeang nga gbaruc mema menugecdeac hadae.” Yoac mitikibiu fede, imoc sasawango ine fingecdacbeso. ");
INSERT INTO ded_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesungo ifi deu yeac areng sasawango ye wama kengec woragec. ");
INSERT INTO ded_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Anu sebigborimedac mongngo kporuc linengngo memea imocsac kpeec, yeng Yesu modaru megec. ");
INSERT INTO ded_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Memagec, yeng kporuc kpesima senggang worama kenec. ");
INSERT INTO ded_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Anu yeni Yesu mema womong garengtoa yenearu mekenggec. Mekenggec womong gareng enara sasawa nga enarafocngina amma mitiac negen negengngic, yeni kpeturanggema hagec. ");
INSERT INTO ded_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nga Petoro ye ngadenginau hereaungoc modacyunu kemma womong garengtoa yeac amaac oda manaungoc enec. Emma imohai uamedac yenigoc gerec dzeunegemma tarec. ");
INSERT INTO ded_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Anu womong gareng enara nga yudangic yeneac tutumangtoa memba sasawa adzorogec. Adzoroma yeni Yesungo faka mangana dafi anec dema kpehomegecdeac manganaac kopocsicac yoac anggecdeac obohogec. ");
INSERT INTO ded_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nga ngic homacngo ikoc amma yeac enacfu faifaiyoac degec nga gubeyoacnginango socfungoc mi anec. ");
INSERT INTO ded_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ngic goa yeneng kicnginau emma namma yofi dema enacfu faifai ammigec, ");
INSERT INTO ded_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ye yoac mong yofi deu negening, ‘Ni womong yomoc ngicmaringo memea, imoc hembarackema uameme harebecac manau mong ngicmaringo mi memea mebade.’” ");
INSERT INTO ded_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nga kopocsicac yoacngina imocngo ine ifingoc socfu mi anec. ");
INSERT INTO ded_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Anu womong garengtoango yacma botucnginau namma Yesu yofi kpesimiec, “Geac yoac dedae, imocac noboha mong mi denade me?” ");
INSERT INTO ded_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ifi deu Yesungo ine waicke namma turunga mong mi merennec. Nga womong garengtoango monggoc kpesimiec, “Ge Messia, Kenec keneheac medac me?” ");
INSERT INTO ded_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ifi deu Yesungo deec, “Ni imocnoc. Anu kecma ngeni Ngicac Medac Kuctoa mingina yeac foiaugeng tacma kurumenggac hoennu kicnginau hau henggecde.” ");
INSERT INTO ded_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ifi deu womong garengtoa yeng ngakpihereha membarackema deec, “Yoacninaac boingicac monggoc mi obohonide. ");
INSERT INTO ded_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ye Anutu emmima deu bic negendau, imocac dafi negendae?” Ifi deu sasawango ye kopocsihagoc negemma homeudeac deserigec. ");
INSERT INTO ded_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ifi deserigec ngic goa yeneng sofohoma kiwa kporucngo biranggema marigbung gbungngo heima degec, “Ge kpefingyoac dena!” degec gareng nanggec, yeneng ye mema kpegec. ");
INSERT INTO ded_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Anu Petorongo oda manau nammanu womong garengtoaac wanac naroang mongngo ihai haec. ");
INSERT INTO ded_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hama henu Petoro ye gerec dzeunegemma taru kiwa yearu fima deec, “Ge ifingoc Yesu Nadzaretenac, yegoc kefoc.” ");
INSERT INTO ded_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ifi deu Petorongo ine sebi heima deec, “Ye mi negemmiduae nga yoac denec, imoc mi negentegecduae.” Ifi dema ama naguyau kemeu kokorec arohoec. ");
INSERT INTO ded_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Arohou wanac naroangngo Petoro hemma ngic wegenac nanggec, torokpema yeni monggoc edeyunuec, “Ngic yomoc ye yenearunac mong.” ");
INSERT INTO ded_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ifi deu Petorongo ine monggoc busickpeec. Nga naso mi hereemanu ngic imohai nanggec, yeneng monggoc degec, “Foracngoc, ge yenearunac mong. Ge Gariraia bangecfunacngoc.” ");
INSERT INTO ded_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ifi degec ye yengenaoc sowecemema desopec amma deec, “Ngeni ngic dedae, ye mi negemmiduae.” ");
INSERT INTO ded_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ifi deu imohaingoc kokorecngo arohou yohockang anec. Anu Petoro ye Yesungo yoac edeec, imoc negensiec, “Kokorecngo arohou atac yohockang mi ammanu geng neac busickpena harebec bic anude.” Petorongo imoc negensima ubahodung kuneng mema kiachodung kiarec. ");
INSERT INTO ded_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Asoacngoc yombong womong gareng enara nga yudangic enarafocngina amma mitiac negen negengngic nga yudangic yeneac tutumangtoa memba sasawa, yeneng yoac deserigec. Deserima Yesu maria dedeckema Piratoaru mekenggec. ");
INSERT INTO ded_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mekenggec Piratongo Yesu kpesimiec, “Ge yudangic yeneac ngictau me?” ifi deu merenec, “Imocnoc geanggaoc denec.” ");
INSERT INTO ded_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nga womong gareng enara yeneng Yesu yoacfu faima yeac haniaya homac degec. ");
INSERT INTO ded_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ifi degec Piratongo monggoc kpesimiec, “Yeni geac yoac homac yombong dedaemoc, imoc negemma turunga mong mi merennade me?” ");
INSERT INTO ded_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ifi deu Yesungo turunga monggoc mi merenu Piratongo negen negeng ua homac meec. ");
INSERT INTO ded_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Anu makekeng nasousoc ngic mong witicamau takefu yudangic yeneng yeac kpara kpacgec Piratongo yenoc witicamaunac wau makefec. ");
INSERT INTO ded_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Amma ngic goa warac ngicngac here miac miac faka amma ngic goa yunuhomegec witicamau faiyunugec, yenearunac ngic mong kpara Baraba. ");
INSERT INTO ded_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","10","Nga womong gareng enara yeni Yesuac keracmangang amma yeac mariu mekenggec, Piratongo imoc bic negenec. Ifi negenu habutoa yeneng hama Piratongo angkefec, ifi isoc anudeac kpesimigec yeng meremma yofi kpesiyemmeec, “Yudangic ngeneac ngictau yungecngemmebadeac negendae me?” ");
INSERT INTO ded_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ifi deu womong gareng enara yeneng habu fenggeyemmegec yeneng Yesu wama ine Baraba naric yungecyemmegecdeac degec. ");
INSERT INTO ded_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ifi degec Piratongo monggoc meremma kpesiyemmeec, “Anu ni yudangic ngeneac ngictau dedae, yeac dafi ambade?” ");
INSERT INTO ded_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kpesiyemmeu yeneng arohogec, “Ge ye mariponnu kpena homeu.” ");
INSERT INTO ded_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ifi degec Piratongo monggoc kpesiyemmeec, “Nga ye noc kopocsic meec?” deu ine yeneng monggoc seriangoc arohogec, “Ye mariponnu kpebesena.” ");
INSERT INTO ded_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ifi degec Piratongo habu yeneac negen negeng modarudeac negemma Baraba wau kenec. Nga yeni Yesuac sebia dzikacngo kpemaguc mariponnu kpegecdeac wasai maringinau wayemmeec. ");
INSERT INTO ded_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Anu wasaingic yeneng Yesu mema gawamang yeneac amaoda manau emma wasaingic sasawa hafoangoc kpedzucnegec. ");
INSERT INTO ded_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kpedzucnedacma ngakpiherec mong giweng giweng heimima somang batihema ira isoc oruhau heimigec kemeec. ");
INSERT INTO ded_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kemeu eweheihei siricfu kpacma edegec, “Ohec, yudangic yeneac ngictau.” ");
INSERT INTO ded_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dema yasungo oruhau kpema sofohoma haniau fafoc heima numumigec. ");
INSERT INTO ded_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Anu yeni defagoc ammigec wisickeu ngakpiherec sacsac imoc hesima yengena wamba heimigec kemeu mariponnu kpegecdeac mema ngadeau kenggec. ");
INSERT INTO ded_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kemmagec Kirene taonnunac ngic mong kpara Simong, ye Aresande nga Rufu yereac mangngira, yeng semeng uaunac sinnu hamanu wasaingic yeneng Yesuac maripong tofohoudeac ngombonggegec tofohoec. ");
INSERT INTO ded_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tofohou yeni bangec buma mong kpara Gorigata, titiha hatasic, imohai Yesu mekenggec. ");
INSERT INTO ded_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mekemma sopo mong aengagoc kpara mira, imoc wainggoc yerecgema migec nga yeng ine imoc waec. ");
INSERT INTO ded_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Anu yeni ye mariponnu kpema wambaya mederema wiac mong me mong merang meude, imocac kpeing kpegec. ");
INSERT INTO ded_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yeni asoac 9 kirocfu Yesu mariponnu kpegec. ");
INSERT INTO ded_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kpema ye yoacfu faigec, imocac hania tafebisicfu yofi ohogec, “Yudangic yeneac ngictau.” ");
INSERT INTO ded_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Anu yeni godzungic yohockang, mong foiau nga mong kanayau yegoc mariponnu momoc yunugec. Ifi anggec yoac mitikibiu oho ohoya yomoc seriec, “Ye manganameme yenearunac mong, ifi negenggec.” ");
INSERT INTO ded_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Anu ngic ihai kengha anggec, yeni Yesu deendema ammima orucngina kpatitickema degec, “Ngeni ngic imoc henggec, yeng womong hembarackema wenac harebecac manau monggoc meudeac deec. ");
INSERT INTO ded_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ge geanggaoc onggongemema mariponnunac mesiemema mana!” ");
INSERT INTO ded_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Anu womong gareng enara nga mitiac negen negengngic, yeneng ifingoc ye desusuic ammima denegeng amma degec, “Ye ngic goa onggongyunukefec nga yengena ine naric mi onggongemeude. ");
INSERT INTO ded_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ye Messia, Israe neneac ngictau kecdengo yaguc mariponnunac mau hemma negensinggenide.” Nga ngic yohockang mariponnu ifingoc yurugec, yereng ifingoc deendema ammioc. ");
INSERT INTO ded_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wenac dzongiau 12 kiroc ammanu imohai ama kundung kpema kundungngo bangec sokoma fekemmanu 3 kiroc marai anec. ");
INSERT INTO ded_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Imohai Yesungo ubaudumeng kunengngoc kpacma yofi deec, “Eroi, Eroi rama sabaktani.” Imocac titiha yofi, “Anutuna Anutuna, ge nocac wanudang.” ");
INSERT INTO ded_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ye ifi kparu ngic wegenac nanggec, yenearunac goango imoc negemma degec, “Negenggec, ye Eria kpacsambic ammide.” ");
INSERT INTO ded_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ifi degec ngic mongngo nedzikemma kondung sobing mong mema waing aengagocfu nemuruckema yasuu faiu Yesuac enarau enu deec, “Tomai namma henni, Eriango hama mesiude me kpac!” ");
INSERT INTO ded_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ifi demanu Yesungo ine ubaudumeng kunengngoc kparu asuya ereec. ");
INSERT INTO ded_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ereu womonggac kporuc kuneng imoc dzongiausing wihacnac tohoma mau yohockang anec. ");
INSERT INTO ded_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Anu wasaigareng yeac kicfu nanec, yeng Yesungo kparec nga homeec, imoc hemma yofi deec, “Foracngoc, ngic yomoc ye Anutuac medacnoc.” ");
INSERT INTO ded_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nga ngac goa ifingoc hereau namma faka fingerec, imoc henggec, yeneac botucfu Maria kpara mong Madara nga Maria, Yakobo mong munea deandae, ye nga Yosec yereac nonggongira amma Sarome, yeni yenahafoc nanggec. ");
INSERT INTO ded_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesungo Gariraia bangecfu kefu ngac imoc yenennoc ye modacma meficgekecgec. Amma ngac tosea homac, yeni Yerusarennu yegoc bic kemma ihai ye hemma nanggec. ");
INSERT INTO ded_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Marai bic anu hombanggac memengereac naso wegene hau sabataac naso femanu ");
INSERT INTO ded_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosefe Arimataia taonnunac, yeng ihai haec. Ngic ye kpactoayagoc yudangic yeneac tutumangtoa, imocac membangina mong amma ye Anutuac eucererenggac tomai kefec. Yeng kengeha kpac Piratoaru kemma Yesuac fareng meudeac kpesimiec. ");
INSERT INTO ded_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kpesimiu Pirato ye Yesungo bic homeec, imocac kpidohoma wasaienara kpacma Yesu bic homedac me kpac, imocac kpesimiec. ");
INSERT INTO ded_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kpesimiu Yesu bic homedac deu Yesuac fareng Yosefe desimiec. ");
INSERT INTO ded_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Desimiu Yosefengo linengkporuc mong bummema Yesuac farenga mariponnunac mesiu mau kporucngo tembonggema kicsereu mekenec. Kicsere imoc hocsirau singa usu usuya, imohai farenga faima hoctoa mong kpedidinggeu singa hedzickeec. ");
INSERT INTO ded_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Anu Maria Madara nga Maria Yosec nonggea, yereng Yesuac farenga dahai faiec, imoc henoc. ");
INSERT INTO ded_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabata tatac naso wisickeu imohai Maria Madara nga Maria Yakoboac nonggea amma Sarome, yeneng kemma Yesuac fareng nadzicmigecdeac kerec homunagoc bummegec. ");
INSERT INTO ded_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bummema sonda gboria hanac hanaheau asoacngoc ama wereckenu kicsereu kemmagec wenac ereec. ");
INSERT INTO ded_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Anu kemma yenaocngoc denegeng amma degec, “Merang hocsingaac naguya imohacnac hoc kpedidinggenemmeude?” ");
INSERT INTO ded_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ifi dema kic fima henggec hoctoa imoc ine bic kpedic kpedidinggea. Nga hoc imoc kunengtoa yombong. ");
INSERT INTO ded_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hemma kicsereu emma henggec medac mongngo ngakpihereha kongac kongac mong heiec, yeng foiugeng taru hemma kpidohoma kerectegec anggec. ");
INSERT INTO ded_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ifi anggec yeng yofi edeyunuec, “Ngeni mi kengecngunuu. Yesu Nadzaretenac mariponnu kpegecmoc, ngeni ye hembeso hadae nga ye bic gborima yacdac, yei mi fede. Faigec fedac, fefea imoc henggec. ");
INSERT INTO ded_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ngeni kemma medacfora nga Petoro yofi edeyunugec, ye waraingemmema Gariraia bangecfu kende. Anu ngeni imohai kemma ye meficgegec, yengenaoc edengunuec, ifi isoc.” ");
INSERT INTO ded_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ifi edeyunuu yeni kpidohoma dzonongngina fedeecac kicsereunac worama kenggec. Amma yeni homac yombong kpidohoma kengecyunuecac amma ngic mong mi edeyunugec. ");
INSERT INTO ded_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesungo sondau yarec, naso imohai hanahema Maria Madara fingecmiec. Ye warac hadehade 7 yearunac kporarec, ngac imocnoc fingecmiec. ");
INSERT INTO ded_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Fingecmiu Mariango kemma ogofora yegoc momoc kecgec, yeni ubahodung negemma kiac kecmagec yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Yesungo bic yacdac kecde, ni hendua.” ifi deu yeneng ye mi negensinggegec. ");
INSERT INTO ded_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Anu imocac ngadeau ngic yohockang yeri amabangec monnu kembesonga kemmaec ye siriha mong amma fingecyemerec. ");
INSERT INTO ded_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Fingecyemeru yeri dzigenema goa edeyunugec, yeneng ine mi negensinggegec. ");
INSERT INTO ded_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Anu medacfora 11 yeni yaka nema tacmagec Yesungo fingecyemmeec. Nga ye yarec hemma edeyunugec, imoc mi negensinggegec nga ubangina seriecac amma ngaba siricfu yoac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Edeyunuma yoac yofi deec, “Ngeni bangectoa bangec, imohai kemma wiac sasawa Anutungo deu fingerec, yeni siduc gombung edekpou ayemmebisia. ");
INSERT INTO ded_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Anu ngic me ngac mong negensinggema mitidoku nadziru Anutungo ye ebicfunac mesiu komoc kpeude. Nga mong ye mi negensinggeude, yeng ine yoacfu makpeude. ");
INSERT INTO ded_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nga negensinggegecde, ngenearu faka kuhagoc yofi fingerude. Ngeni neac kpacfu hadehade nga yafing kporacyunugecde amma nedzarangyoac uba gboriausing degecde. ");
INSERT INTO ded_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ngeni boidzoc maringo megecde nga doku hodungagoc ngic memanganeyunuande, ngeni imoc negecdeu, imocngo mi memanganengunuude. Nga ngeni ngicngac hafeigoc yenearu mari faigec, yeni ngereegecde.” ");
INSERT INTO ded_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kebu Yesungo yoac ifi edeyunuu wisickeu Anutungo ye kurumennu meenu yeac foiau tacde. ");
INSERT INTO ded_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Anu medac yeni noboc noboc kemma siduc gombung ngicngac edekpou ayemmegec. Nga Kebungo yenigoc kefu yeni ua megec faka kuhagoc fingerec, imocngo yoara meseriec. ");
INSERT INTO ded_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Kunenna Teofiro, profete yeneng yoac degec, imocngo botucninau fora fingerec, imocac siduc ohogenduae. Ngicngac yeni hanac hanaheaunacngoc erema kicnginango faka fingerec, imoc hemma yeni siduc gombunggac kingangkpekpefora anggec. Yeni faka fingerec, imocac siduc edenunugec homacngo imoc hanahema ohogec. Imocac siduc edenunugec amma ohogec, imoc isinggema hanac hanaheaunac erema fingerecmoc, imoc dindingac arenggema ohogemba naric anudeac negensiai. ");
INSERT INTO ded_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ge yoac yomoc osoma yoac kpougenggec, imocac fora ande, imoc naric negennade. ");
INSERT INTO ded_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yuda bangecac ngictau Herode yeac nasou Abia ua arennunac womong gareng mong kefec, kpara Dzekaria. Yeac enema kpara Erisabete ye Aronggac fingecsahe, imohacnac. ");
INSERT INTO ded_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ngicngahoc imoc yeri Anutuac kicfu dindingac yombong kecma dedeseriyoac nga singyoac sasawa modacma ikocngira kpac amma kpetiac kefoc. ");
INSERT INTO ded_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Yeri kufing kefocac amma Erisabetengo sabaha kpac kefu yeri kecma ngicngac yada bic anoc. ");
INSERT INTO ded_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nga naso botuc ihai Dzekariango Anutuac kicfu uaarengfora yenigoc ua megec ");
INSERT INTO ded_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","yeni fakangina modacma merang sesegerec homuna gombunga kpedzereckeude, imocac kpeing kpegec Dzekaria heficgeec. ");
INSERT INTO ded_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Heficgeu sesegerec imoc kpedzereckebesonga nasoya hau ye Anutuac womong manau enec. Enu ngicngac habutoa yeni ngadeau numuma nanggec. ");
INSERT INTO ded_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ifi ammagec Kebuac angero mongngo hosuc heiheiac arata, imohai Dzekaria fingecmiec. Fingecmima foiaugeng nanec. ");
INSERT INTO ded_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nga Dzekariango hemma kpidohoma kengec ebiria anu ");
INSERT INTO ded_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","angerongo yofi edeec, “Dzekaria, ge mi kengecguu, Anutungo nunumuga bic negendac nga enengga Erisabetengo medac mong kpenanggema megenude. Ge kpara Yohane, ifi kpacbesena. ");
INSERT INTO ded_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yeng geac ubangerec nga sogac sogai anude. Nga ngicngac homacngo ye fingerecac amma ifingoc ubangerec negenggecde. ");
INSERT INTO ded_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Imoc yofiac, yeng Kebuac kicfu kuneng anude. Amma waing doku me doku seria mong naric mi neude. Ye nonggo heremanaunacngoc Tiri Asu wake wakeagoc amma ");
INSERT INTO ded_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israe ngicngacfora homac wangecyunuu yeni ubangina Kebu Anutungina, yearu merenggecde. ");
INSERT INTO ded_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Amma medac ye manggac wangecyunuu ubangina meremma heregoc nambaracfocngina yeneac songo negenggecde. Amma yoackpekpe yeni negen negeng dindingac meficgeyemmeudeac ua meude. Nga yeng Kebuac kicfu kecma Eriaac onga nga kucfu uaya mekefude. Ifi mekecma ngicngac meefaiyunuu yeni Kebuac kicfu efaima yeac ngicngacfora anggecde.” ");
INSERT INTO ded_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ifi deu Dzekariango angero yofi edeec, “Ni neanna ngicyada nga enenna ifingoc, ye kifaya bic homac ammanu geac yoac dafiugeng negemba fora anude?” ");
INSERT INTO ded_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ifi deu angerongo deec, “Ni Gabirie. Anutuac kicfu nanganduae nga ye yengenaoc yoac edegubadeac suenuu hama siduc gombung yomoc edeguduae. ");
INSERT INTO ded_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Negennec, yoac deduae, imocac nasoya hau foraya fingerude. Nga ge yoacna imoc mi negensinggedanggac ge yoacga kpac anu ifi kecmana wiac deduaemoc, imocac nasoya hama fingerude. Fingeru wenac imohaingoc yoacgagoc monggoc annade.” ");
INSERT INTO ded_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Anu ngicngacareng yeni Dzekariaac tomai namma ye Anutuac womonnu naso herea yombong nanecac kerectegec anggec. ");
INSERT INTO ded_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ifi anggec ye ngadeau mau yoara kpac anu yoac edeyunuudeac obohou yeni bic negentegecgec, “O, ye womonnu emma onga mong hendac.” Kecma ye yoara kpac anu mariangosac faka anec. ");
INSERT INTO ded_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Anu Dzekariaac womong garenggac ua nasoya wisickeu ye mama ameau monggoc dzigenema kenec. ");
INSERT INTO ded_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kenu naso mi hereemanu enema Erisabete ye hereagoc amma afo 5 sufu sufuu kefec. Kecma yofi negenec, ");
INSERT INTO ded_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yomoc Kebuac faka mong, yeng neac negensima naso yomohai gamena mesawerema faka yomoc anendac. Nga ngicngac yeneng neac deendema monggoc mi anggecde.” ");
INSERT INTO ded_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Anu Erisabeteac afoya 6 ammanu Anutungo angero mong kpara Gabirie sueu Gariraia prowinsiu taong mong kpara Nadzarete, ihai kenec. ");
INSERT INTO ded_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kemma ngac naroang kpara Maria, ye fingecmiec. Maria ye ngic mong kpara Yosefe, yeac enema anude, imoc bic deserigec amma Yosefe ye Dawidiac kisicfunac. ");
INSERT INTO ded_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angerongo Mariaac yofi deec, “Ohec, Kebungo gegoc kecde, wosoefactoayango gearu fedeac ubangerec negembesena.” ");
INSERT INTO ded_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ifi deu Maria ye imoc negemma kerectegec kuneng anec, “Angerongo noc wiacac negemma ifi edenude?” imoc negenu obohou negen negeng ua homac meec. ");
INSERT INTO ded_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Memanu angerongo yofi edeec, “Maria, ge mi kengecguu, Kebungo geac negenu ngereeande. ");
INSERT INTO ded_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Amma negenna, ge sabac mong kpenanggema menade. Amma ge medac yeac kpara Yesu kpacbesena. ");
INSERT INTO ded_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Medac imocngo engena yombong anude. Yeng Anutu Engenatoaninaac Medac, yeac kpara ifi kpacgecde. Nga Kebu Anutungo ye kisiha Dawidi yeac ngictauac tatac miu ihai tarude. ");
INSERT INTO ded_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Amma yeng Yakoboac kisicfora yeneac ngictau amma nasoya kpac kefude nga amabangeha garenggeude, imoc wisic wisickea kpac feeng kefude.” ");
INSERT INTO ded_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ifi deu Mariango angero edeec, “Ni ngicgoc mong mi fedua nga imoc dafiugeng fingerudeac denec?” ");
INSERT INTO ded_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ifi kpesimiu yofi deec, “Tiri Asungo gearu mau Engenatoaac kucngo geac nokumuc amma kperacguude. Imocac amma sabacga kpetiac fingerude, yeac kpara Anutuac Medac degecde. ");
INSERT INTO ded_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Negenna, geac areng mocgu Erisabete, ye ngacyada amma sifu medac kpenanggeec. Ngicngac yeni ye kufing kecde, ifi degec nga yeng hereagoc anu afoya 6 bic ande. ");
INSERT INTO ded_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutuaru faka kpungge kpunggea mi fede.” ");
INSERT INTO ded_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ifi deu Mariango deec, “Negenna, Anutu ye neac minginna imocac ge yoac dedang, imoc naric fingecnembeso.” Ifi deu angerongo wama kenec. ");
INSERT INTO ded_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Naso mi hereemanu Mariango efaima Yudaiaac sifec bangecfu taong monnu kenec. ");
INSERT INTO ded_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kemma Dzekariaac amau emma Erisabete wenacngerec demiec. ");
INSERT INTO ded_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nga Erisabetengo Mariaac yoac negenu sabac hereau tarec, imocngo kpidohoec. Kpidohou Tiri Asungo Erisabetearu wakeu ");
INSERT INTO ded_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ye kunengngoc kpacma deec, “Ge ngac botucninau kenecgagoc nga sabac heregau tacde, ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kebunaac nonggeango nearu hau faka yomoc fingecnende, imoc faka kuneng. ");
INSERT INTO ded_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Negenna, ge wenacngerecyoacga dena kedzacnango negembare sabacngo herenau sogaima yuengyuma andac. ");
INSERT INTO ded_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ngac ye Kebungo yoac edeu imocngo fora fingerudeac negensinggeude, ngac imoc ye kenehagoc.” ");
INSERT INTO ded_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ifi deu Mariango deec, “Anutu, ge kicga fima nenna wanac naroangga mamea yombong amma kefai. Imocac amma ubaonganango Kebu heiwayong anggenu ");
INSERT INTO ded_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Anutu memengerecna, ongaasunango geac amma sogaide. ");
INSERT INTO ded_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yeng kingang naroang mamea kecde, imoc hentegecdac nga yofinenggac namma feengkefude, ngicngacareng sasawango negennemma yofi degecde, ‘Ye kenehagoc.’ ");
INSERT INTO ded_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kuctoa Minginango fakatoaya kuneng yombong anendac nga yeac kpara kpetiac. ");
INSERT INTO ded_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kisicfunac kisic yeac ewea heimiandae, yeneac witiu yeac ubamangangngo feengkefude. ");
INSERT INTO ded_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nga ngicngac yenang uba negen negengnginaac negenggec engena ande, yenearu kucfakaya mema maria sinema medereyunuu singsararang kpegecde.” ");
INSERT INTO ded_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“Ye ngictau kucnginagoc, yeni tatacnginaunac meicyunuma ngic kpac kuneng mong mi mekecgec, yeni memiacyunuec. ");
INSERT INTO ded_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nga ngicngac here home homegoc kecdae, yeng yeni yengena wiac gombunga yemmema mewakeyunuec amma finactoanginagoc, yeni ine maringinau wiac mong mi faima eng sueyunuu kenggec. ");
INSERT INTO ded_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Anutungo yoara bangecnina Abrahang nga fingecsaheyaac edeyunuec, imoc mi nigeckpeec, kpac. Ye kingangkpekpefora Israe siriha ifiangoc meficyunuma wosoefac ayemmeude.” ");
INSERT INTO ded_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Amma Mariango afo harebec isoc Erisabetegoc kecma monggoc ameau dzigene kenec. ");
INSERT INTO ded_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kenu Erisabete ye sabac fingec fingec nasoya wegeneu medac meec. ");
INSERT INTO ded_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Meu amafora nga yengena arengfora yeneng Kebungo yearu wosoefactoa ammiec, imocac negemma yegoc momoc sogaigec. ");
INSERT INTO ded_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Anu uameme 8 ammanu yeni medac sebi tosea herecgegecdeac hama ngic yeneng yeac kpara Dzekaraia, mamaac wase megecdeac degec. ");
INSERT INTO ded_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ifi degec nonggea Erisabetengo kpetarima deec, “Yeac kpara Yohane kpacbesonga.” ");
INSERT INTO ded_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ifi deu yeneng degec, “Geac arengfocga yenearunac kpac ifia mong mi kpacgec fede.” ");
INSERT INTO ded_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ifi dema yeni maringo faka amma medac kpara merac kpacnide, imocac mama kpesimigec. ");
INSERT INTO ded_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kpesimigec Dzekariango kibi oho ohoac tafe, imocac kpesiyemmeu migec yofi ohoec, “Medac yeac kpara Yohane.” Ifi ohou yeni sasawango kerectegec anggec. ");
INSERT INTO ded_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nga naso imohaingoc Dzekariaac enara anggeu nedzaranga heimerenu ye monggoc yoacdede amma Anutu dengerema kefec. ");
INSERT INTO ded_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Anu amafora yeni sasawango kengec anggec nga ngicngac Yudaia sifec bangectoau kecgec, yeni faka fingerec, imocac denegeng amma kecgec. ");
INSERT INTO ded_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nga ye Kebuac kucngo sabacgoc kefec, imocac amma ngicngac siduc negenggec, yeneng yoac imoc negen negenginau faima yofi negemma kpesiemegec, “Sabac imocngo kecma dafi ambesande?” ");
INSERT INTO ded_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Anu Tiri Asungo sabacac mama Dzekariaaru wakeu, yeng kpefingyoac yofi deec, ");
INSERT INTO ded_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kebu Israeac Anutu kenehebisina. Yeng ngicngacfora nenannu hama witicfunac bic yungecnunuec. ");
INSERT INTO ded_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Amma ye bicngoc yombong profete yeneac enacfu yoac faiu degecmoc, imoc modacma kingangngiha Dawidi, yeac fingecsaheunacngo ngic mong ebicfunac yungecnunuuu komoc kpenide, ye meficgenemmeec. ");
INSERT INTO ded_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yeng ngabafocnina kecdae nga ubango ukununuandae, yeneac mariunac mesinunuudeac negenec. ");
INSERT INTO ded_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Nga Anutungo kisicnina Abrahanggoc yoac deserima deec, imoc negensima dzadzahac kpataninga modacma kisicfocnina wosoefac ayemmema ");
INSERT INTO ded_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ngabafocnina yeneac mariunac mesinunuu kecma kengeha kpac eweheimima kecnide. ");
INSERT INTO ded_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kecni kekecnasonina fedesoc, imohai yeac kicfu kpataning nga dindingac kecnideac ifi anemmeec. ");
INSERT INTO ded_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Anu sabacna gennoc waraima Kebuac sing mengerema singa heitumeinadeac amma Engenatoa yeac profete, ifinoc kpacgugecde. ");
INSERT INTO ded_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ge yeac ngicngacfora kopocsicngina kpac anudeac kpouyemmenade nga yeni ebicfunac mesi mesi nga komoc kpegecdeac sing, imoc naric negentegecgecde. ");
INSERT INTO ded_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nga Anutuninango songo nga wosoefac engena yombong anemmekecdeac ifi fingerude. Yeac songotoayaac kuc imoc wenac isoc erema nenanggaru mama ngicngac ");
INSERT INTO ded_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kundung manau nga homecac nokumucfu kecdae, yeni mekperagiyunuu nenang ruaeac sinnu kennideac hanianina garenggema sing imoc edzacnunuude.” ");
INSERT INTO ded_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anu sabac ye sebiugeng nga asuu yadiseri amma bangec kisiu kecma Israe ngicngac yeneac kicfu fingectegerudeac nasoac tomai kefec. ");
INSERT INTO ded_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Kwiriniungo Siria bangecac gawana kefec, naso imohai Roma bangecac ngictau Sisa Agustongo bangeha bangeha kpacarengngina mengeregecdeac yoac faiu kendarec. Nga osokporeng ua ifia warac mi feec. ");
INSERT INTO ded_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ifi anu ngicngac sasawango kpacarengngina mengeregecdeac taongngina fekenec, imocacsoc kendacgec. ");
INSERT INTO ded_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefe ye Dawidiac kisicfunac, imocac amma yeng Gariraia prowinsiunac erema Nadzarete wama Yudaia prowinsiu Dawidiac taongbisic kpara Betereheng, ihai kenec. ");
INSERT INTO ded_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nga enembingeha Maria ye hereagoc anu yegoc yerahafoc kpacngira kpacarennu ohogecdeac kenoc. ");
INSERT INTO ded_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yeri ihai kecmaec sabacac fingec fingecnaso haec. ");
INSERT INTO ded_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Anu yeri amatatacfu titinga mong mi feecac yeri ngadeau tacmaec morocmedacngira fingeru Mariango sangohoma ramaburumaka otou ihai faiu keema feec. ");
INSERT INTO ded_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Anu toforecfu ramagareng goa yeni Betereheng ama wegenacfu ramafocngina garengyunuma kecgec. ");
INSERT INTO ded_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kecmagec Kebuac angero mongngo fingecyemmeu Kebuac kibikperagitoayango mekperagiyunuu yeni kengec ebiria anggec. ");
INSERT INTO ded_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","11","Ifi anggec yeng edeyunuec, “Ngeni kengec mi anggec. Imoc yofiac, yaguc yombong ngeneac amma Dawidiac taonnu Messia Kebungina fingecdac, ye ebicnginaunac mesingunuude. Nga ngicngac sasawa yeac amma ebiriangoc sogaigecde, ni siduc gombung imoc dekperagingemmeduae. ");
INSERT INTO ded_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sabac ye merac imoc negenggecdeac ma yomoc ngemmebade, ngeni kemma ramaburumaka otou sabac mong kporucngo birac biranggea feu meficgegecde.” ");
INSERT INTO ded_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ye ifi demanu imohaingoc kurumenggac angerohabu kuneng, yeneng fingecma yegoc namma Anutu dengerema yofi degec, ");
INSERT INTO ded_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anutu ohec, wi kurumennu febeso nga bangecfu ruae fingecbeso. Anutungo ngicngac wosoefac ayemmede.” ");
INSERT INTO ded_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ifi dema angero yeni kurumennu dzigenema enggec ramagareng yeni yenaocngoc denegeng amma degec, “Betereheng taonnu faka fingeru Kebungo edenunudac, imoc bic kemma henni.” ");
INSERT INTO ded_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ifi dema yeni bic kemma Maria nga Yosefe amma sabac oto manau feec, yeni meficyunuma yenenggec. ");
INSERT INTO ded_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yenemma angerongo sabac yeac yoac deecmoc, imoc edeyunugec negendacgec. ");
INSERT INTO ded_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nga ramagareng yeneng siduc anggec nga ngicngac imoc negenggec, yeni kerectegec andacgec. ");
INSERT INTO ded_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariango ine faka fingechaec, imoc hereau faima negensima kefec. ");
INSERT INTO ded_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nga angerongo yoac ramagareng edeyunuec, yeni imoc sasawa fora hemma negemma dzigenema Anutu afec afehe kenggec. ");
INSERT INTO ded_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Uameme 8 wisickeu sabac sebi tosea herecgegecdeac nasoya hau yeni kpara Yesu kpacgec. Kpac imoc ye nonggeango mi kpenanggemanu angerongo bic kparec. ");
INSERT INTO ded_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kecma Moseac dedeseriyoac modacma dzuac dzuacnasoac mitikibiu oho ohoya nande, nasongina imoc wisickeu yeni sabacngo Kebuac kicfu fingerudeac Yerusarennu meenoc. ");
INSERT INTO ded_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kebuac dedeseriyoacfu yoac yofi oho ohoya fede, “Waracmedac fingeckecgecdesoc yeni Kebuac kpataning areng.” ");
INSERT INTO ded_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nga sese faibesonga, imoc kebesac yohockang me gomoc gomocmedaha yohockang faibesonga, imoc Kebuac dedeseriyoacfu fede nga yeri imoc modacma mekenoc. ");
INSERT INTO ded_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naso imohai ngic mong Yerusarennu kefec, kpara Simeong. Ye ngic dindingac amma Anutu eweheimima Tiri Asugoc kefec. Amma ye Israengic yenearu memeseri fingerudeac tomai anec. ");
INSERT INTO ded_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nga Asungo warac yofi deficgema edeec, “Ge mi homemana Anutuac Messia fingeru hennade.” ");
INSERT INTO ded_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nga Yesuac nonggomama yereng dedeseriyoac feec, imoc modacma sabacngira Anutuac womonnu meenoc. Meenec Asungo Simeong bic wangeru womong manau emma ");
INSERT INTO ded_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","sabac menamma Anutu dengerema yofi deec, ");
INSERT INTO ded_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Kebu minginna, ni wanacngicga kicnango Memengerecga hembadeac denec, imoc bic henduaac ruaegoc kekecna mewegenena kembade. ");
INSERT INTO ded_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ge ngicngac sasawa yeneac kicfu sing imoc bic mengeredang. ");
INSERT INTO ded_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nga yeng bangeha bangeha ngicngac ge mi negensinggudae, yeni mekperagiyunuma kperagingina anude amma ye israengicngacfocga yeneac kibikperagitoa.” ");
INSERT INTO ded_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ifi deu sabac nonggomama yeri yeac yoac imoc negemma kerectegec anoc. ");
INSERT INTO ded_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nga Simeongngo kenecyunuma sabac nonggea Maria yofi edeec, “Negenna, Israengic homacngo medac yomocac amma mayunuude nga homacngo yeac amma yacma nanggecde, ifi fingerudeac Anutungo meisinggeec. Nga ngic homac yeni ye hemma yeac ngaba amma deendema ammigecde. ");
INSERT INTO ded_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ammigec geac ubaherega ifingoc dzikacac beangngo herecgeude. Ifi anu ngicngac homac yeneac negen negeng sufuma feec, imoc didiu fingerude.” ");
INSERT INTO ded_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Anu profete ngac mong kpara Hanna, ye ifingoc womonnu kefec. Ye Fanuereac naroang Aseac kisicfunac. Amma ye ngic mema yegoc kifa 7 kecmanu ewea homeec. ");
INSERT INTO ded_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Homeu ye hodzec kecmanu kifaya 84 anec. Amma yeng womong mi wawa hadzing toforec yaka segekecma Anutu numumikefec. ");
INSERT INTO ded_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kecma naso imohaingoc yenigoc wegena namma Anutu dengereec. Dengerema ngic Yerusarenggac tembuckekecngina fingerudeac tomai kecdacgec, yeni sabacac siduc dekperagiyemmeec. ");
INSERT INTO ded_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosefe nga Maria yeri Kebuac dedeseriyoacngo dede, imoc sasawa andarec wisickeu Gariraia prowinsiu dzigenema Nadzarete amanginau kemma kecgec. ");
INSERT INTO ded_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kecgec medacngo yadiu Anutuac ubangerecngo yearu feu yeng kuc nga negen negentegec wake wakea meec. ");
INSERT INTO ded_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesuac nonggomama yeri makekenggac hombang henecdeac kifasoc Yerusareng taonnu engkefoc. ");
INSERT INTO ded_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Amma yeni hombanggac faka modacma Yesungo kifaya 12 ammanu yenahafoc hombannu kenggec. ");
INSERT INTO ded_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kemma kecmagec hombang naso wisickeu dzigene hagec Yesungo Yerusarennu tarec. Taru nonggomama yereng imoc mi negemma hama ");
INSERT INTO ded_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","yofi negenoc, “Ye habu yenigoc sinnu kecde.” Ifi negemma yeri uameme mocgu sinnu eng kenggec wisickeu Yesu hoforoc. Hofocma tosofocngina nga arengfocngina yenearu yerecgema ");
INSERT INTO ded_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","mong mi meficgeocac monggoc dzigenema Yerusarennu meficgeecdeac kenoc. ");
INSERT INTO ded_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Uameme harebec wisickeu Anutuac womong manau emma Yesu meficgeoc. Meficgeec yeng kpoukpou yeneac botucfu womonnu tacma negengyemmema dekpesi ayemmeec. ");
INSERT INTO ded_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Amma Yesungo negen negenggoc yombong ngic sasawa yoacngina merenecac yeni kpidohoma imoc wiac engena ande, ifi negenggec. ");
INSERT INTO ded_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nga nonggomama yereng ye hemma kpidohoma nonggeango yofi edeec, “Medac, ge nocac faka ifia anecmenec? Manggagoc nereng negengyohoc amma hofocgukecdic.” ");
INSERT INTO ded_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ifi deu yeng edeyuruec, “Ngeri nocac hofocnudape? Mannango ua mekecde, ua imoc mebadeac denenec, imoc mi negendape me?” ");
INSERT INTO ded_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ifi deu yeri yoac imocac obohooc. ");
INSERT INTO ded_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nga ye nonggomama yerigoc dzigenema Nadzarete taonnu kemma imohai enacngira tofohoma kefec. Nga nonggeango faka sasawa fingerec, imoc negen negengau faiu feec. ");
INSERT INTO ded_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nga Yesungo negen negeng nga kifayaac arennu yadiseri anu Anutu nga ngic yeni yenahafoc hendzidziegec. ");
INSERT INTO ded_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ngictau Sisa Tiberiongo kifa 15 tatahau bic tackefec. Nga Pontio Piratongo Yudaia bangecac gawana kefec. Kecmanu Herodengo Gariraia bangecac gareng anec nga munea Firipongo Ituraia nga Trakoniti bangecac gareng anec amma Risaningo Abireneac gareng, ifingoc kecgec. ");
INSERT INTO ded_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ifi kecmagec Hannas nga Kaifa yereng womong garengtoa kefoc. Naso imohaingoc Dzekariaac medac Yohanengo bangec kisiu kefu Anutuac yoacngo yearu haec. ");
INSERT INTO ded_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohanengo Yodang doku noboc noboc bangec fekende, imohai yerecgema ngicngac yofi dekperagiyemmeec, “Ngeni kopocsicngina kpac anudeac ubangina dzigeneu mitidoku nadzicbisia.” ");
INSERT INTO ded_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Profete Yesaiango yoac imoc deec, yeac kibiu yofi oho ohoya fede, “Bangec kisiu kpakpac mong yofi fingecde, ‘Ngeni Kebuac sing wisima singa heitumegec. ");
INSERT INTO ded_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yeni kperemeng sasawa semegecde nga tikifagang sasawa imoc heitumegecde amma sing gbaring gbaring mengeregec dindingac anude nga sing kopocsiragoc heisorongaigec ");
INSERT INTO ded_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anutungo ngicngac manganaunac mesinunuude, imoc ngiha ngihango hendacgecde.’” ");
INSERT INTO ded_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ifi anu ngicngac homacngo Yohanearu kenggec. Kemma doku nadzicyemmeudeac edegec Yohanengo yofi edeyunuec, “Boidzocac gboricfora, Anutuarunac turunga habeso ande, ngeni imohacnac woragecdeac sing fede, merang goroyoac imoc edengunuec? ");
INSERT INTO ded_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Imocac ngeni doku nadzicma ubamerenggac siricfu fora meficgebisia. Nga ngeni yofinenggac ngenanggac yofi mi negengemebisia, ‘Abrahang ye bangecnina.’ Anutungo hoc yomoc yenearu faka meu yenearunac Abrahanggac bangecfora naric fingecgecde. ");
INSERT INTO ded_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Naka ye bic ic haniau tacdeac ic goa fora gombunga mi anggecde, imoc sasawa heiu kpeu gerecfu ukuyunuude.” ");
INSERT INTO ded_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ifi deu ngicngac yeneng kpesimigec, “Ifi anu neni dafi annide?” ");
INSERT INTO ded_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ifi degec yofi merengyemmeec, “Ngic mongngo ngakpia yohockang mekecde, ye mong hesima ngakpia kpac kecde, ye meficgebeso. Nga nenesemengagoc kecde, yeng faka imocngoc ambeso.” ");
INSERT INTO ded_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nga takesimeme goa yeneng ifingoc hama doku nadzicyemmeudeac hama degec, “Kpoukpou, neni dafi annide?” ");
INSERT INTO ded_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ifi degec Yohanengo edeyunuec, “Ngeni hiedzo megecdeac dengemmegec, imoc mi ferahema sirihausac mebisia.” ");
INSERT INTO ded_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nga wasaingic goa yeneng ifingoc kpesimigec, “Anu neni dafi annide?” Ifi degec deec, “Ngeni godzufaka me ikocfu amma degbedicfu monggarunac hiedzo mi mebisia. Ngeni uanginaac bummekecdae, hiedzo imocsac fengemmebeso.” ");
INSERT INTO ded_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Anu ngicngac yeni Messiaac tomai kecgecac amma ubaherenginau negenggec, “Yohane yenoc Messia gedang.” ");
INSERT INTO ded_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ifi negenggecac Yohanengo yofi merengyemmeec, “Ni doku nadzicngemmeduae nga ngic ngadenau hade, yeng ine Tiri Asu nga gerecgoc nadzicngemmeude. Nga yeac kucngo neac kuc ferahade, ni ifiango yeac hanitabea witiha yungecba naric mi ngereeude. ");
INSERT INTO ded_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ye meic meicke saraha mariau mehama wit seuhagoc meic meicke sobengau feu, imoc fima seuha meickema fora mekpedzuc amma ameau faiude. Faima seuha wanggema gerec pisic pisickea kpac, imohai ukuu dzeude.” ");
INSERT INTO ded_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanengo yoac siriha homac dema ngicngac dederecge ayemmema siduc gombung edeyunukefec. ");
INSERT INTO ded_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Anu ngictau Herodengo ine muneaac ngac kpara Herodia hamangec mema faka mangana goa homac angkefecac Yohanengo faka mangana imocac nonoyoac ededarec. ");
INSERT INTO ded_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Edeu Herodengo yoara negemma monggoc Yohaneac ngaba amma witicamau faiec. ");
INSERT INTO ded_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ngicngac sasawango mitidoku nadzicmagec Yesungo ifingoc mitidoku nadzirec. Nadzicma numuma nammanu kurumeng anggeu ");
INSERT INTO ded_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tiri Asungo kebesacac siric amma yearu maec. Mau kurumennunac enacudumeng mong yofi fingerec, “Ge songomedacna, ni gengsongo anggengkecduae.” ");
INSERT INTO ded_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesungo kifaya 30 ammanu uaya hanaheec. Nga ngicngac yeneng yofi negenggec, ye Yosefeac medac. Nga Yosefe ye Heriac medac ");
INSERT INTO ded_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","nga Heri ye Matataac medac. Matata ye Rewiac medac nga Rewi ye Merikiac medac. Meriki ye Yanaiac medac nga Yanai ye Yosefeac medac. ");
INSERT INTO ded_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefe ye Matatiaac medac nga Matatia ye Amosiac medac. Amosi ye Nahunggac medac nga Nahung ye Esiriac medac. Esiri ye Nagaiac medac ");
INSERT INTO ded_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","nga Nagai ye Mahataac medac. Mahata ye Matatiaac medac nga Matatia ye Semeinggac medac. Semeing ye Yosekeac medac nga Yoseke ye Yudaac medac. ");
INSERT INTO ded_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda ye Yohananggac medac nga Yohanang ye Resaac medac. Resa ye Dzorobabeac medac nga Dzorobabe ye Saratiereac medac. Saratiere ye Neriac medac ");
INSERT INTO ded_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","nga Neri ye Merikiac medac. Meriki ye Adiac medac nga Adi ye Kosanggac medac. Kosang ye Erimadanggac medac nga Erimadang ye Erieac medac. ");
INSERT INTO ded_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri ye Yesouac medac nga Yesou ye Eriedzeac medac. Eriedze ye Yoringgac medac nga Yoring ye Matataac medac. Matata ye Rewiac medac ");
INSERT INTO ded_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","nga Rewi ye Simeonggac medac. Simeong ye Yudaac medac nga Yuda ye Yosefeac medac. Yosefe ye Yonanggac medac nga Yonang ye Eriakinggac medac. ");
INSERT INTO ded_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriaking ye Mereaac medac nga Merea ye Menaac medac. Mena ye Matataac medac nga Matata ye Natanggac medac. Natang ye Dawidiac medac ");
INSERT INTO ded_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","nga Dawidi ye Isaiac medac. Isai ye Obedeac medac nga Obede ye Boasiac medac. Boasi ye Saraac medac nga Sara ye Nasonggac medac. ");
INSERT INTO ded_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasong ye Aminadaac medac nga Aminada ye Adaminggac medac. Adaming ye Araniac medac nga Arani ye Hesoronggac medac. Hesorong ye Pereseac medac nga Perese ye Yudaac medac. ");
INSERT INTO ded_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ye Yakoboac medac nga Yakobo ye Isakaac medac. Isaka ye Abrahanggac medac nga Abrahang ye Taraac medac. Tara ye Nahoreac medac ");
INSERT INTO ded_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nga Nahore ye Seruguac medac. Serugu ye Ragauac medac nga Ragau ye Peregeac medac. Perege ye Ebereac medac nga Ebere ye Seraac medac. ");
INSERT INTO ded_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sera ye Kenanggac medac nga Kenang ye Arapakisaac medac. Arapakisa ye Senggac medac nga Seng ye Noaac medac. Noa ye Rametac medac, ");
INSERT INTO ded_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","nga Ramec ye Metuseraac medac. Metusera ye Enokoac medac nga Enoko ye Yaredeac medac. Yarede ye Maharareac medac nga Maharare ye Kenanggac medac. ");
INSERT INTO ded_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenang ye Enosiac medac nga Enosi ye Seteac medac. Setengo Adanggac medac nga Adang yeng ine Anutuac medac. ");
INSERT INTO ded_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Anu Tiri Asungo Yesu mewakeu Yodang dokuunac dzigene eremanu yeng bangec kisiu wangeru kenoc. ");
INSERT INTO ded_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesungo ihai kemma kecmanu uameme 40ac manau mangana minginango ye tobanggeec. Tobanggemanu imohai Yesungo yakaya kpac kecmanu uameme 40 wisickeu hereaac homeec. ");
INSERT INTO ded_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hereaac homema kecmanu mangana minginango edeec, “Ge Anutuac medac kecnecfu hoc yomoc dena imoc ic sogong anu.” ");
INSERT INTO ded_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ifi deu Yesungo meremmiec, “Yoac yofi oho ohoya fede, ‘Ngicngo ic sogonggacsac mi kefude, kpac.’” ");
INSERT INTO ded_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ifi deu yeng Yesu bangecbuma monnu wangec enu piratac isoc fingeru bangeha bangeha gawamangnginagoc edzahema ");
INSERT INTO ded_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","deec, “Bangeha bangeha yomocac kibikperagia nga imoc garenggebadeac kuc bic nenggec. Nga ni imoc ngic mong me mong mibadeac kuc fenende. ");
INSERT INTO ded_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Imocac ge eweheinennadeu ni imoc sasawa waba geac andarude.” ");
INSERT INTO ded_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ifi deu Yesungo yofi meremmiec, “Yoac yofi oho ohoya fede, ‘Ge Kebu Anutuga mocgu eweheimima kingang kpemibesena.’” ");
INSERT INTO ded_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ifi deu yeng Yesu monggoc wangecma Yerusarennu kemma Anutuac womong imocac oda herea wi yombong nande, imocac bumau faiu nanu edeec, “Ge Anutuac Medac fora kecnecfu geanggaoc yomohacnac yuma kemena. ");
INSERT INTO ded_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yoac yofi oho ohoya fede, ‘Ye angerofora uayoac yemmeu yeneng ge sing sasawa kengkecnec, imohai garenggugecde.’ ");
INSERT INTO ded_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","amma ‘Ge haniga hocngo heibacac yeneng maringina witiau faiguma sesehegugecde.’” ");
INSERT INTO ded_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ifi deu Yesungo deec, “Yoac yofi dedea fede, ‘Ge Kebu Anutuga faitobannu mi faibesena.’” ");
INSERT INTO ded_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ifi deu mangana minginango faitobang ammidaru wisickeu wama kemma naso monggac tomai kefec. ");
INSERT INTO ded_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Anu Tiri Asungo Yesuaru wakema feu ye Gariraia bangecfu monggoc dzigeneu bangec fekende, imocac ngicngac sasawango siduha negendacgec. ");
INSERT INTO ded_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nga yeng kpekpeturang amanginau emma kpouyemmeu ngicngac sasawango dengeregec. ");
INSERT INTO ded_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Anu Yesungo yadi yadibangeha Nadzarete, imohai kemma kpekpeturang amau engande, faka imoc modacma ihai enec. Emma mitikibi osoudeac nanu ");
INSERT INTO ded_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","yeni profete Yesaiaac kibi kpou kpouya migec ye imoc yungecma kibiu yoac yofi feec, imoc meficgeec. ");
INSERT INTO ded_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kebuac Asungo nigoc kecde nga neng ngicngac makpekpea siduc gombung edeyunubadeac Kebungo dzimbonga nadzicnenec. Ngic witicfu kecdae, yeni witicngina kpac anude nga kicpisicngo kicfifi anggecde, imoc edeyunubadeac yeng suenuec. Suenuu hama ebicgoc kecdae, yeni ebicngina meickema wangecyunubade. ");
INSERT INTO ded_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nga Kebuarunac naso gombunga hangemmeude, imoc ifingoc dekperagibade.” ");
INSERT INTO ded_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesungo kibi imoc monggoc kpouma kibigareng miec. Mima mataru kpekpeturang amau ngicngac tacgec, yeni kicngina yearu sasawa fidacgec. ");
INSERT INTO ded_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Figec yeng yofi edeyunuec, “Yoac mitikibiu osoba negendau, imocac fora yaguc hafoangoc fingecngemmede.” ");
INSERT INTO ded_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nga yeac enacfunac yoac dedea imocngo wosoefac nga kuhagoc anecac ngicngac sasawango yeac negenggec naric anu kerectegec amma yeac kpesiemegec, “Ngic yomoc ye Yosefeac medacngo ifi dede.” ");
INSERT INTO ded_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ifi degec Yesungo yofi edeyunuec, “‘Dota, ge geanggaoc mengereemena.’ Yoac heihei imoc fede nga ngeni imoc bic edenubeso andae. Amma monggoc yofi, ‘Ge Kafanaung taonnu ua mena siducga negengandimbe, imoc yei bangecgau ifingoc mena henni.’” ");
INSERT INTO ded_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dema monggoc torokpema deec, “Foracngoc, profete mong ye yengena bangecfu kenu ngicngac yeneng naric mi hoanggegecde, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Eria bic kefec, naso imohai Israe bangecfu ngac hodzec homacngo kecgec. Kecmagec kurumeng nagu heiu kia mi kpeec, kifa harebec nga afo 6 bangec imohai boditoa fingerec. ");
INSERT INTO ded_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Fingeru Anutungo Eria sueu Israe ngac yenearu mong mi kenec. Nga ye Sidong bangecac Sarepac taonnu ngac hodzec mong kefec, yearu sueec. ");
INSERT INTO ded_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nga profete Erisango Israe bangecfu kefec, naso imohai ngicngac homacngo kukuserigoc kecgec, yenearunac mongngo mi ngereec, kpac. Nga Siria bangecfunac ngic mong kpara Naimang, yengsac ine ngereec.” ");
INSERT INTO ded_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ifi deu ngicngac sasawa kpekpeturang amau tacgec, yeni imoc negemma herengina buu ");
INSERT INTO ded_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","yacma Yesu igockema meickema taong ngadeau kemegec. Kemema taongngina tikiu tarec ihai hofe mong nanec, imohai kemma ukugec kemeudeac negemma wangecma kenggec. ");
INSERT INTO ded_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kenggec, yeng ine ngicngac botucnginau nedereyunuma kenec. ");
INSERT INTO ded_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesungo Gariraia bangecac taong mong kpara Kafanaung, ihai kemema sabata nasou ngicngac Anutuac yoac kpouyemmeec. ");
INSERT INTO ded_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nga yeac kpoukpoungo ngicngac uakibi mekecdae, yeneac siricfu kuhagoc yombong ngicngac yeneng imoc negenggec engena anec. ");
INSERT INTO ded_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Amma kpekpeturang amau ngic mong yafing seuhagoc kefec, yeng yoac kuhagoc kpacma deec, ");
INSERT INTO ded_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ah, Yesu Nadzaretenac, neneac wiac imoc geac mi ande. Ge memanganenununadeac hanec me? Gensiduaenoc, ge Anutuac kpetiac ngic.” ");
INSERT INTO ded_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ifi deu Yesungo yafing yoac seria ammima yofi edeec, “Ge waickema ngicfunac erema kenna!” Ifi deu yafing ye ngic kpefaheu botucnginau makpeu yearunac erema kenec. Nga ye ngic imoc mong mi memanganeec. ");
INSERT INTO ded_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ngicngac sasawango imoc hemma kerectegec amma denegeng amma degec, “Ye noc yoac mekecde? Ngic yomoc ye kuc mimia nga kuhagoc yombong, yeng asu seuhagoc edeyunuu erema kendae.” ");
INSERT INTO ded_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ifi fingeru Yesuac siducngo bangec imocac tegia noboc noboc amasoc kendaru negenggec. ");
INSERT INTO ded_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesungo kpekpeturang ama wama Simonggac amau kenec. Nga Simong sefena sebigerectoa ammiu feu Yesungo sefena mengereudeac edegec. ");
INSERT INTO ded_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Edegec Yesungo namma ngac feu hemma sebigerec yoac seria edema kpetarimiu sebigerecngo ngac wama meickeec. Meickeu ngac ye naso imohaingoc yacma yenenggareng anec. ");
INSERT INTO ded_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Anu wenackiwa keme kemeac ngicngac sasawango ogofocngina hafei hania hania ayemmeec, yeni meyunuma Yesuaru hagec. Hagec Yesungo ngicngac hafeinginagoc sasawa maria witinginau faima mengereyunudarec. ");
INSERT INTO ded_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mengereyunuu yafing nga hadehade ifingoc ngicngac homac yenearunac erema yofi kpacgec, “Ge Anutuac Medac.” Nga ye Messia, imoc negenggecac yeneng yoac imoc mi degecdeac deracyunuec. ");
INSERT INTO ded_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wereckengau Yesungo taong wama bangec botuc mong ngiha kpacfu kenu ngicngac yeneng ye hofocgec. Hofocma meficgema yeng yenigoc kefudeac negemma ye monnu mi kembeso degec. ");
INSERT INTO ded_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ifi degec ine edeyunuec, “Taong goa fekendae, ni imohai ifingoc kemma Anutuac eucererenggac siduc gombung dekperagiyemmebesare. Anutungo imocacnoc suenuec.” ");
INSERT INTO ded_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ifi dema Yudaia bangecfu kpekpeturang amangina fekenec, imohai Anutuac yoac dekpou ayemmema kefec. ");
INSERT INTO ded_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Naso monnu Yesungo Genesarete dzohong tegiau nammanu ngicngac yeneng Anutuac yoac negenggecdeac hama igocemema oronggegec botucnginau nanec. ");
INSERT INTO ded_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Namma kic fima henu gomba yohockang dzohong tegiau taroc. Nga kondungyang memengic yeneng gombangina faigec taru uficngina dzuacma nanggec. ");
INSERT INTO ded_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nanggec Yesungo gomba mong, Simonggac gomba, imohai emma tacma Simong edeu yeng gomba kapianec kpesiu dzohonnu kenu ngicngac edekpou ayemmeec. ");
INSERT INTO ded_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wisickeu Simong yofi edeec, “Kondungyang mebesonga dzohonnu doku keme kemea fede, ngeni ihai kemma uficngina ukuma kondungyang megec.” ");
INSERT INTO ded_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ifi deu Simongngo meremmiec, “Kunenna, neni tofocnac yomohai hafoanoc uatoa mema kondungyang mong mi meding nga geng denecac ine kemma ufic ukubade.” ");
INSERT INTO ded_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ifi deu yeni uficngina ihai ukuma kondungyang homac yombong megecac uficngina wakema barackebesonga anec. ");
INSERT INTO ded_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ifi anu yeni ogofocngina gomba monnu tacgec, yeni marikarac heiyemmegec hama meficyunugec. Meficyunuma kondungyang gomba yohockang mewakegecac gomba yereng kondunnu kemebesonga anoc. ");
INSERT INTO ded_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simong Petorongo faka imoc hemma Yesuac haniu makpema fafoc heimima deec, “Kebu, ni ngic kopocsicnagoc anduaeac wanuma kenna.” ");
INSERT INTO ded_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simong nga ngic yegoc kecdacgec, yeneng kondungyang homac yombong megecac amma kerectegec anggecac ifi deec. ");
INSERT INTO ded_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nga Sebedaioac medahora, Yakobo nga Yohane, yeri Simonggoc kondungyang mema kecma ifingoc imoc hemma negenec wiac engena yombong anec. Nga Yesungo Simong edeec, “Ge mi kengecguu. Ge kondungyang meme nga yaguc ngicmeme annade.” ");
INSERT INTO ded_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ifi deu yeni gombangina mema tegiau faima wiac sasawa wama Yesu modacgec. ");
INSERT INTO ded_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Anu Yesungo taong monnu kecmanu ngic mong kukuseringo sebia semedaru manganeyombonggeec, yeng ihai kecma Yesu hemma makpema kiwa bangecfu hetutuckema kpacsambic ammima deec, “Kebu, ge negenna naric anu medzuacnubang.” ");
INSERT INTO ded_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ifi deu Yesungo maria sinema kpeserema deec, “Ge ngereenadeac songona fede.” Ifi deu imohaingoc kukuseringo ngic imoc waec. ");
INSERT INTO ded_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Wau Yesungo derahema deec, “Sebigau faka fingecdac, imocac ngic mong mi edebesena. Ge womong gareng yearu kemma sebiga edzahena. Amma Mosengo seseac deec, imocac sirihau sese faina ngicngac yeneng sesega imoc hemma negentegecgecde.” ");
INSERT INTO ded_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nga Yesuac siduc, imoc ine kuneng yombong yadima kenu ngicngac habutoa homac yeneng yeac yoac negenggecde nga yeng hafeingina mengereudeac hagec. ");
INSERT INTO ded_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ifi anggec Yesungo naso homac kperecge tegecma bangec goa ngiha kpacfu kemma numukefec. ");
INSERT INTO ded_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kecma naso monnu Yesungo Anutuac yoac edekpou ayemmemanu farisaio nga dedeseriyoacac kpoukpoungic goa Gariraia nga Yudaia amabisic sasawa amma Yerusarennac hama tacgec. Nga hafei mengec mengereac kuc Kebuarunac, imocngo Yesuaru feec. ");
INSERT INTO ded_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ifi femanu ngic goango hama ngic mong hanimaria homemea dzakeu faima tofohoma ama manau Yesuac kicfu faigecdeac negemma mekenggec. ");
INSERT INTO ded_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mekenggec ngicngac homacngo hedzickema nanggecac yeni Yesuac kicfu faigecdeac sing hofocma ngic imoc amabubuyau tofoho emma ama bubuya hesarima ihacsing ngic botucnginau Yesuac hoannu dzakeagoc faigec kemeec. ");
INSERT INTO ded_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kemeu Yesungo negen negensingngina hemma yofi deec, “Ngic, kopocsicga imoc bic wawaya.” ");
INSERT INTO ded_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ifi deu mitiac negen negengngic nga farisaio yeni yenaocngoc yofi negenggec, “Ngic imoc noc ngicngo Anutu emmide? Anutu mocgungo kopocsic naric waude.” ");
INSERT INTO ded_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ifi negenggec Yesungo wiac ubanginau negensigec, imoc hemma yofi edeyunuec, “Ngeni nocac ubanginau ifi negensidae? ");
INSERT INTO ded_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yoac damocngo deni efea ande, ‘Kopocsicga kpac ande.’ me yofi, ‘Ge yacma kenna.’ ");
INSERT INTO ded_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngicac Medac ye bangecfu kopocsic wawaac uayoac nga kuc femide, ngeni imoc negenggecdeac amma yofi deba.” Ye ifi dema ngic puringgac yofi deec, “Ni edeguduae, ge yacma dzakega mema amagau kenna.” ");
INSERT INTO ded_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ifi deu yeng imohaingoc ngicngac sasawa yeneac kicfu yacma fefea feande, imoc mema Anutu dengerema ameau kenec. ");
INSERT INTO ded_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kenu ngicngac sasawango homac yombong kpidohoma kerectegec amma Anutu dengeredacgec. Nga kengecngo mewakeyunuu degec, “Neni faka morora mi hengennina yaguc kicninango hending.” ");
INSERT INTO ded_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Anu Yesungo imohacnac mama kemma takesimeme ngic mong kpara Rewi, ye takesimeme amau tacmanu hemma yofi edeec, “Ge hama ni modacnuna.” ");
INSERT INTO ded_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ifi deu Rewingo yacma wiac sasawa wadacma Yesu modarec. ");
INSERT INTO ded_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nga Rewi ye Yesuac amma ameau yaka kuneng ohou takesimeme nga ngicngac homacngo yenigoc tacma yaka negec. ");
INSERT INTO ded_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ifi anggec farisaio nga miti negen negengngicfocngina yeneng negenggec naric mi anu Yesu medacfora yeneac yoackpekpengina kpema degec, “Ngeni nocac takesimeme nga manganameme yenigoc nenedoku nedae?” ");
INSERT INTO ded_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ifi degec Yesungo yofi merengyemmeec, “Ngicngac sebingina hafeia kpac kecandae, yeni dotaac mi ayemmekecde. Hafeinginagoc, yeneng ine dotaac ayemmekecde. ");
INSERT INTO ded_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ni ngicngac dindingac kpacyunubadeac mi mayai, kpac. Ni ine manganameme yeni ubangina merenggecdeac kpacyunubesonga mayai.” ");
INSERT INTO ded_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ngicngac goa yeneng Yesu kpesimigec, “Yohaneac medacfora nga farisaio yeneac medacfocngina yeni naso homac yakasege kecma nunumu ua meandae. Nga geac medacfocga yeneng ine nenedoku nekecdae.” ");
INSERT INTO ded_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ifi degec Yesungo yofi merengyemmeec, “Memeturang ngicngo ogofora yenigoc kecma yakasege anggecdeac naric mi deude. ");
INSERT INTO ded_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kecma naso monnu memeturanggac ngic yenearunac meickegecde, naso imohai ine yakasege anggecde.” ");
INSERT INTO ded_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesungo torokpema yoac mong heima yofi edeyunuec, “Mongngo kporuc gboriaunac sintaha herecgema mema eseau naric mi faima kpebiude. Ifi anudeu kporuc gboria manganeude amma gboria nga esea kpeturangyuruu siriha naric mi fingerude. ");
INSERT INTO ded_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nga ngic mongngo waing gboria bokong yangseberango memea eseau naric mi kpeu kemeude, kpac. Ifi anudeu waing gboriango bokong esea imoc tindziru manganeu dokuya maude. ");
INSERT INTO ded_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Imocac waing gboriango bokong gboriau kpeni kemeu naric ande. ");
INSERT INTO ded_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Amma ngic mongngo waing esea bic neec, yeng waing gboria neudeac songo naric mi negenude, kpac. Ye yofisac deude, ‘Waing esea imoc gombunga yombong.’” ");
INSERT INTO ded_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesungo sabata naso monnu wit uausing kemmanu medacfora yeneng wit fora merecgema sebera kpetima asasahema negec ");
INSERT INTO ded_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","farisaio goango yenemma kpesiyemmegec, “Ngeni sabata nasou faka mi angana imoc nocac andae?” ");
INSERT INTO ded_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kpesiyemmegec Yesungo yofi merengyemmeec, “Dawidingo uamedacforagoc herenginaac homema faka anggec, ngeni imoc mi osonegeng angandae gedang. ");
INSERT INTO ded_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ye Anutuac womonnu emma ic sogong Anutuac sese faifaia, imoc mema yengena nema uamedacfora ifingoc yemmeec. Nga ic sogong imoc womong gareng yenengsac naric neandae, ngictehec yeneng kpac.” ");
INSERT INTO ded_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ifi dema yofi edeyunuec, “Ngicac Medac ye sabataac Kebu.” ");
INSERT INTO ded_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabata naso monggac Yesungo kpekpeturang amau emma Anutuac yoac kpouyemmeec, imohai ngic mong marifoia homemeango yenigoc tarec. ");
INSERT INTO ded_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nga Yesungo sabata nasou hafeigoc memengerecua mong meu yeni haniaya mong meficgema yoacfu faigecdeac miti negen negenngic nga farisaio, yeni garemmema nanggec. ");
INSERT INTO ded_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesungo ine negen negengngina hemma ngic yeac yofi deec, “Ge yacma erahama botucninau nanna.” Ifi deu ngic ye yacma ekemma botucnginau nammanu ");
INSERT INTO ded_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesungo yofi edeyunuec, “Wiac mong kpesingemmeba, sabatanasou damocngo angana ande? Faka gombunga me faka mangana ayemmebesonga amma homebeso andae, agengngina tigecdeac dede me goa memanganeyununideac dede?” ");
INSERT INTO ded_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ye ifi dema kiwa fikengfiha amma yenendacma ngic yeac deec, “Mariga sinena.” Ifi deu ngic ye maria sineu maria ngereeu ");
INSERT INTO ded_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","yeni herebutoa yombong negemma yenaocngoc Yesu dafi ammigecdeac denegeng anggec. ");
INSERT INTO ded_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yesungo naso imohai numuudeac tikiu emma tofocnac hafoa Anutu numumima kecmanu ");
INSERT INTO ded_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ama wereckenu medac kpacyunuu kenggec medac 12 meisingyunuma aposoro kpac imoc yemmeec. Nga aposoro yeneac kpacngina yofi: ");
INSERT INTO ded_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simonggac kpara mong Petoro kparec nga yeac munea Anderea, Yakobo nga Yohane, Firipo nga Batoromaio. ");
INSERT INTO ded_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio nga Toma amma Arifaioac medac Yakobo nga Simong, yeac kpara mong Dzerote. ");
INSERT INTO ded_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Amma Yuda, Yakoboac medac nga Yuda Karioto taonnunac, yeng kecma Yesu kerereu megec. ");
INSERT INTO ded_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Anu Yesungo tikiunac medacfora 12 yenigoc mama bangec tumia monnu medacfora homac yenigoc nanec. Nanu ngicngac habu kunengngo Yudaia bangec noboc noboc nga Yerusarennac amma Tiro nga Sidonggac kondunnu amabangec fekende, imohacnacngo hagec. ");
INSERT INTO ded_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hama Yesuac yoac negenggecde nga yeng hafeingina mengereudeac hagec. Amma ngicngac asu seuhagoc hama yeneng ifingoc ngereegec. ");
INSERT INTO ded_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nga kucngo yearunac yenearu kemma ngicngac sasawa mengereyunuecac yeni sasawango ye kpeseregecdeac negenggec. ");
INSERT INTO ded_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ifi anggec Yesungo kiwa medacfora yenearu fima deec, “Ngicngac wanac kecdae, ngeni kenecnginagoc, nocac Anutuac eucerereng imocnoc ngeneac. ");
INSERT INTO ded_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nga ngicngac yaguc herenginaac homedae, ngeni kenecnginagoc, ngeni yaka nema gebecngunuude. Amma kiac ubahodunggoc yaguc kecdae, ngeneng kenecnginagoc, ngenennoc kecma dzomoregecde. ");
INSERT INTO ded_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nga ngicngac yeneng Ngicac Medacac amma ngeni ubango ukungunuma demanganengunuma ngadeau faingunuma kpac mangana kpacngunugecde, imoc ngeni kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ngeni naso deduaemoc, imohai ubangerec negemma yuengyuma amma sogaibisia, nocac kurumennu bungngina kuneng tomaingina fede. Nga ngic yeneac bangecfocnginango warac profete faka imocngoc profete ayemmegec. ");
INSERT INTO ded_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngicngac dzofinacgoc kecdae, ngeni sowecnginagoc, nocac ngeni wiacngina songeagoc hafoa bic megec wisickeec. ");
INSERT INTO ded_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nga ngicngac semeng negebec yaguc angkecdae, ngeni sowecnginagoc. Ngeni kecma herenginaac homegecde. Nga yaguc dzomocgoc kecdae, ngeni sowecnginagoc. Ngeni kecma ubamangang negemma kiacgecde. ");
INSERT INTO ded_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Amma ngicngacngo dengerengunukecdae, ngeneac deduae, ngeni sowecnginagoc, nocac yeneac bangecfocnginango warac profete ikoha ifingoc dengereyunukecgec. ");
INSERT INTO ded_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ngicngac yoacnaac kedzac kpeandae, ngeni ine yofi edengunuduae, ngeni ngabafocngina heresongogoc hoangyunubisia amma ngic ubango ukungunuandae, yeni faka gombunga ayemmebisia. ");
INSERT INTO ded_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nga ngic sowecyoac edengunuandae, ngeni yeni kenecyunubisia amma memanganengunuandae, ngeni yeneac numubisia. ");
INSERT INTO ded_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nga ngic mongngo munggungga noboc kpeudeu ge munggungga noboha ifingoc wamibesena nga mongngo ngakpiga witiau meudeu ngakpiga mana ifingoc wana mebeso. ");
INSERT INTO ded_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nga ngic yeneng gearunac wiac monggac derecgeandae, ge wiac imoc yemmebesena amma mongngo geangga wiac wangecguu monggoc meremma genudeac mi hatahemibesena. ");
INSERT INTO ded_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ngic yeneng noc faka angemmegecdeac negensiandae, ngeni faka siriha imocngoc ayemmebisia. ");
INSERT INTO ded_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nga ngic goa yeneng ngeneac songo negenggec ngeneng yeneac songo negenggecdeu ngeneac ubangerecyoac homac mi debesonga. Kopocsicmeme ngic yeneng ifingoc ngic damoc yeneac songo negengandae, yeneac songo negenggecde. ");
INSERT INTO ded_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nga ngicngac goa faka gombunga angemmekecgec ngeni faka gombunga ayemmegecdeu ngeneac ubangerecyoac homac mi debesonga. Kopocsicmeme ngic yeni imoc ifingoc angandae. ");
INSERT INTO ded_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Anu ngic ngenearu turung anggec ngeni turunga ifiangoc kpoungemmegecdeac negensigecdeu ngeneac ubangerecyoac homac mi debesonga. Ngic kopocsicnginagoc yeni ifingoc manganameme ogofocngina wiacngina turungagoc yemmeandae. ");
INSERT INTO ded_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Anu ngeni ine ngabafocngina heregoc yeneac songo negemma faka gombunga ayemmebisia. Amma ngeni turungngina wagec yenearu febeso nga kpougecdeac mi negembisia. Ngeni ifi anggecdeu faka gombungaac bungngina kuneng feude nga ngeneng Mangngina Anutu Engenatoa yeac nambaracfora anggecde. Yeng ngicngac ihoc bahoha nga kichodungnginagoc nga ngic mangana faka gombunga ayemmeude. ");
INSERT INTO ded_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mangnginango ngicngac wosoefac ayemmekecde, ngeneng ifi isocngoc wosoefac ayemmebisia.” ");
INSERT INTO ded_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ge ngicngac mi demanganeyunubesena, yoac imoc modacnadeu ngic yeneng ifingoc mi demanganegugecde. Amma ge ngicngac mi isingyununa nga mi desiyunubesena, yoac imoc modacnadeu ngic yeneng ifingoc mi isinggugecde nga mi desigugecde. Nga ngicngac kopocsicngina wana. Ifi anna yeni ifingoc geac kopocsic wagecde. ");
INSERT INTO ded_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ngeni wiacngina ngicngac naric yemmebisia, ifi anggecdeu, Kebungo wiacngina turunggeu kemeu kpemindzaiude. Amma monggoc kpakeu wakema kpetinggeu noboha tabunginau mau megecde. Nocac ngeni wiac kpetengina isinggema ngicngac yemmeandae, kpete siriha ifiangoc yeni isinggema turung kpoungemmegecde.” ");
INSERT INTO ded_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesungo monggoc yoac heima yofi edeyunuec, “Ngic kicpisic mongngo kicpisic ogea mong naric mi wangerude, yeri ifi amma yerahafoc tennu kemeecde. ");
INSERT INTO ded_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nga negen negengmeme medac mongngo kpoukpouyaac engena mi anude. Kpoukpoungo medacfora hafoangoc kpouyemmedaru wisickeu yeni yeac siric andacgecde. ");
INSERT INTO ded_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Anu ge tosogaac kicfu gocbisic mong tacdemoc, imoc hemma geangga kicfu ic kebanga fede, imoc ine mi negensiannec, faka imoc naric mi ande. ");
INSERT INTO ded_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ifi amma ogogaac yofi mi debesena, ‘Toso, ge negemmana kicgau gocbisic tacde, imoc meickebadeac negenduae.’ Ikocngic, geangga kicfu ic kebanga kuneng fede mi hemma imoc naric mi annade. Ge geangga kicfunac ic kebanga meickemaguc ogogaac kicfu gocbisic tacde, imoc hentegecma naric meickenade. ");
INSERT INTO ded_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ic mong gombungau fora mangana naric mi fingerude nga ic manganau fora gombunga naric mi fingerude. ");
INSERT INTO ded_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ic sasawa yeni foranginango haniangina mekperagigecde. Ge witic waeyagoc, imohacnac fig icac fora naric mi mesinade nga wainggac fora imoc fareng nga gberafecfunac naric mi mesinade. ");
INSERT INTO ded_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wiac gombunga ngic gombungaac ubatohong gombungaunac ereude. Nga ngic mangana yeac tohong manganaunac wiac mangana ereude. Wiac ngic ubahereau wakema fede, enarango imocnoc dekperagiude. ");
INSERT INTO ded_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ngeni nocac Kebuna Kebuna kpacnuandae nga yoacna wama mi modacnugecde? ");
INSERT INTO ded_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ngic mong ye hama yoacna negemma imoc modacma uaya ifingoc meudeu, ye ngic dafia, imoc edzacngunubade. ");
INSERT INTO ded_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ngic mong ye ama meudeac dema bangec usuu peperandzi fingeru imocac witiau wotunga ukuu kemeec, ngic imoc ye isoc. Ye ama seria meecac kia tunggbaungtoango hama ama imoc memanganeudeacsoc mi anec. ");
INSERT INTO ded_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nga ngicngac goa yoacna negemma uaya mi meandae, yeni ngic mong ye ama meudeac dema wotunga bangec pereckeau ukuu kemeude, ye isoc. Kia kpeu doku yadima ama imoc kpeu ama imocngo bic barackema mama kpedzamedarec.” ");
INSERT INTO ded_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesungo yoac imoc sasawa ngicngac edeyunudaru negenggec wisickeu Kafanaung taonnu kenec. ");
INSERT INTO ded_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kemma ihai wasai gareng monggac wanacngic ye homebesonga amma feec. Amma ye ngic gombungango mingina yeac ewea heimiande. ");
INSERT INTO ded_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","4","Nga wasai garengngo Yesuac siduc negemma yudangic enarafocngina goa Yesuaru sueyunuu kemma ngombonggema degec, “Ge wasai garenggac wanacngic mong mengerenadeac hana. Wasai gareng ye ngic gombunga, ye naric meficgena. ");
INSERT INTO ded_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ye israengic nenanggac songea negengande nga yeng kiwa amma kpekpeturang amanina meec.” ");
INSERT INTO ded_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Edegec Yesungo yenigoc kemma ama mewegenemanu wasai garengngo ogofora goa sueyunuu yofi edegecdeac kenggec, “Kunenna, nasoga homac mi wana. Ge noc gombunnaac amawarocnau erenade, ni ifiango gearu naric mi habade, imocac ge ihai namma yoac dena medacna ngereeu. ");
INSERT INTO ded_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Imoc yofi, ni ifingoc ngic kucnginagoc yeneac bageu kecbadeac fainugec. Amma neac bageu wasaifocna kecandae. Nga monggac kenna deba kenude nga monggac hana deba haude. Amma wanacngicnaac yomoc mena deba meudenoc.” ");
INSERT INTO ded_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ifi deu Yesungo imoc negemma kerectegec amma dzigenema habu modacgec, yeni yofi edeyunuec, “Ni wiac mong edengunuba negenggec, Israe bangecfu negen negensingngina kuhagoc yofia mong mi henai.” ");
INSERT INTO ded_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nga ngic sueyunuyunuya, yeni garenggac amau dzigenema kemma henggec wanacngiha ye hafeia kpac anec. ");
INSERT INTO ded_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Anu Yesungo taong mong kpara Naing, ihai kenu medacfora nga ngicngac homacngo ye modacgec. ");
INSERT INTO ded_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kemma taongodaac nagutoayau kensikemanu ngic yeni medac mong homeec, yeac farenga tofohoma magec. Medac imoc ye ngac hodzec monggac medaha mocgusac anu ngicngac habu homacngo ye modacma taonnunac magec. ");
INSERT INTO ded_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ifi magec Kebungo ngac imoc hemma ubea manganeu deec, “Ge mi kiacna.” ");
INSERT INTO ded_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ifi dema kemma katapa imoc kpesereu ngic tofohogec, yeni wama nanggec Yesungo deec, “Medac, ni edeguduae, ge yacna.” ");
INSERT INTO ded_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ifi deu homemeango yacma yoac deec. Nga Yesungo medac imoc nonggea monggoc miec. ");
INSERT INTO ded_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nga ngicngac yeneng imoc hemma kpidohoma homac kengecyunuu Anutu dengerema degec, “Profete kuneng mongngo nenannu fingecma kecde nga Anutungo ngicngacfora nenang yugucnunuma kecde.” ");
INSERT INTO ded_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Siduc imocngo Yudaia bangecfu nga bangec goa nobohau tacdae, ihai kenu sasawango yoac imoc negenggec. ");
INSERT INTO ded_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Yohaneac medacfora yeneng kemma siduc imoc ammigec Yohanengo medahora yohockang kpacyuruu haec yeri Kebuaru kemma yofi dema kpesimiecdeac sueyuruec, “Hanemmeudeac dedea, imoc ge me neni ngic monggac tomai kecbisina?” ");
INSERT INTO ded_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ifi dema sueyuruu yeri Yesuaru kensikema yofi dema kpesimioc, “Hanemmeudeac dedea, imoc ge me neni ngic monggac tomai kecbisina? Yohane dokunadzicngo imoc kpesigendedeac suenurude.” ");
INSERT INTO ded_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sueyuruec, naso imohaingoc Yesungo ngicngac homac hafeinginagoc nga kucmama amma asu manganagoc mengereyunuec amma kicpisic homac mengereyunuu kicfifi anggec. ");
INSERT INTO ded_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nga ngihoc yereng ifi edeec Yesungo deec, “Ngeri kemma wiac hennegeng andaoc, imocac siduc Yohane ammibesera. Ngic kicpisic yeni kicfifi andae nga hanimangang yeni sing kendae amma kukuseringinagoc yeni sebingina ngereede. Nga kedzacfong yeni yoac negendae amma homemea, yeneng gboridae nga ngicngac makpekpea yeneng siduc gombung negendae. ");
INSERT INTO ded_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nga mongngo neac amma negemmangang mi angande, ye kenehagoc.” ");
INSERT INTO ded_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Anu Yohaneac medahora kemmaec Yesungo yeac yofi dema habu edeyunuec, “Ngeni bangec kisiu noc wiac henggecdeac kenggec? Komba mong firangngo kpeu kockpac anu, imoc henggecdeac kenggec me? ");
INSERT INTO ded_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Imoc kpac anu noc wiac hembesonga kenggec? Ngic mong wambaya kibiagoc me? Negenggec, ngic wambangina kibia gombunga gombunga heiandae nga bangecac songotoagoc kecandae, yeni ngictau amau kecandae. ");
INSERT INTO ded_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngeni profete mong hembesonga kenggec me? Yeng profete goa sasawa feracyunude, ifinoc deduae. ");
INSERT INTO ded_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yeacnoc yofi oho ohoya fede, ‘Negennec, ni enacdedena sueba yennoc waraigemma singga mengeregenude.’ ");
INSERT INTO ded_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ni yofi deba negenggec, ngic ngacfunac fingecgec, yenearunac mongngo Yohane naric mi ferahaec. Anu Anutuac eucererenggac manau mamea, yeng ine Yohaneac engena.” ");
INSERT INTO ded_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ngicngac sasawa nga takesimemengic momoc, yeni imoc negemma yofi negenggec, Anutu ye yoac fora nga dindingacac mingina, ifi dema Yohanearu kemma mitidoku nadzicgec. ");
INSERT INTO ded_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nga Farisaio amma dedeseriyoacac negen negengngic yeni ine Anutungo sing deyemmeec, imoc ngadehema Yohanearu mitidoku mong mi nadzicgec. ");
INSERT INTO ded_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Anu Yesungo yofi deec, “Ngicngac yofinenggac kecdae, ngeneac fakangina yofi. ");
INSERT INTO ded_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ngeni nambarac sobenu takecdae isoc. Yeni tacma yenaocngoc yofi dema kpacemeandae, ‘Neni kungac fifini ngeni nocac yegec mi fededau nga ubahodung yegec heini nocac mi kiacdau?’ ");
INSERT INTO ded_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohane dokunadzicngo hama ic sogong nga waing mong mi neec, imohai ngeni yofi degec, ‘Ye yafingagoc.’ ");
INSERT INTO ded_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nga Ngicac Medac ye hama nenedoku neande, imohai yofi deandae, ‘Henggec, ye nenedoku efea mi nekecde nga takesimeme nga manganameme yeneac tosongina.’ ");
INSERT INTO ded_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nga Anutuac negen negentegec imoc gombunga ande imocac nambaracfora yeneac fakanginau ireckeude.” ");
INSERT INTO ded_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisaio mong kpara Simong ye Yesugoc yaka neudeac ameau heitaiu yeac amau emma taroc. ");
INSERT INTO ded_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tarec manganamemengac mongngo taong imohai kefec, ye yoac yofi degec negenec, “Yesungo Simonggac amau tacde.” ifi degec negemma kirung mong arabastro hocngo memea kerecdokuyagoc homuna gombunga, imoc mekenec. ");
INSERT INTO ded_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mekemma Yesuac ngadeaugeng haniau namma kiaru kickumiango mama Yesuac hani heiu urucsusiango imoc mekerenggema hania titikokoc ammima kerecdoku homuna gombunga imocngo hania nadzicmiec. ");
INSERT INTO ded_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nadzicmiu farisaio Yesu heitaiec, yeng imoc hemma yengenaocngoc yofi negenec, “Ngac hadac ye manganamemengac. Nga ngic yomocngo profete fora ambac dede ye dafiugeng kpeserema faka yomoc ande, imoc negemmibac.” ");
INSERT INTO ded_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ifi negenu Yesungo yofi edeec, “Simong, ni yoac mong edegubeso negenduae.” ifi deu deec, “Oc, kpoukpou dena.” ");
INSERT INTO ded_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ifi deu yofi edeec, “Ngic yohockang yeri dzogareng mong yearunac turung anoc, mongngo 500 denari nga mongngo 50. ");
INSERT INTO ded_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Amma yeri turung imoc kpoumiecdeac osima kefecac turungngira waec. Wau yerearunac damocngo dzogarenggac songo homac negenude?” ");
INSERT INTO ded_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kpesimiu Simongngo merenec, “Dzo homac wamiec yeng, ifi negenduae.” deu Yesungo deec, “Negenggosi amma yoac dindingac denec.” ");
INSERT INTO ded_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Anu yeng ngac yearu dzigenema Simong yofi edeec, “Ge ngac yomoc henna. Ni amagau ereba ge haninaac doku mong mi nendang, yeng ine kickumiango hanina dzuacma yengena orucsusiango hanina mekerenggedac. ");
INSERT INTO ded_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nga amagau haba geng ubangerecac titikokoc mong mi anendang nga yeng hadua, imohacnacngoc haninau titikokoc anendac. ");
INSERT INTO ded_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nga geng orucna kerecdokungo mong mi nadzicnendang nga yeng hanina kerecdoku homunagocngo nadzicnendac. ");
INSERT INTO ded_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Imocac edeguba negenna, ye heresongoya hafoangoc edzacnudacac kopocsiha hafoangoc ifingoc wamiba kpac andacde. Mong ye kopocsiha kapianec wawaya, ye ine songo kapianecsac femide.” ");
INSERT INTO ded_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ifi dema ngac yofi edeec, “Kopocsicga imoc bic wawaya.” ");
INSERT INTO ded_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ifi deu ngicngac goa tatacfu tacgec, yeni yenaocngoc denegeng amma degec, “Yomoc merac ngic? Ye kopocsic ifingoc wayemmede.” ");
INSERT INTO ded_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nga Yesungo ngacac yofi deec, “Ge ruaegoc kenna. Negen negensinggango ebicfunac mesigudac.” ");
INSERT INTO ded_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yesungo taong nga amabisicfu yerecge kemma Anutuac eucererenggac siduc gombung edeyunukefec. Ifi kenu medacfora 12 ");
INSERT INTO ded_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","nga warac ngac goa asu mangana nga hafeinginagoc mengereyunuec, yeneng yegoc momoc kengkecmagec dzofinacnginango meficyunugec. Ngac homac ifi anggec yenearunac mong kpara Maria kpara mong Madara, Yesungo warac yearunac hadehade 7 kporacmiec. Nga mong Yoana, ye Herodeac gareng Kusaac enema amma mong kpara Susana. ");
INSERT INTO ded_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ngicngac homac yeni taong tackenecsoc, imohacnacngoc Yesuaru hama habu kuneng anggec yeng yoac mong heima yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Gbome kpegi kpegingic mongngo gbome kpegiudeac uau kenec. Kemma gbome kpegiu gbome goango mama sinnu heiu ngic yeneng witiau tigec nga neng yeneng hama nedacgec. ");
INSERT INTO ded_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nga goa harongannu heima nemonggema ereu bangec dokuya kpac anecac sokuema homeec. ");
INSERT INTO ded_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Amma gbomea goa haseng manau heiu haseng nga gbomea yerahafocngoc yadiec hasengngo imoc heihomeec. ");
INSERT INTO ded_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nga gbome goango bangec gombungau heima kpea nemonggema fora 100 sasawa fingecdarec.” Ifi dema kunengngoc yofi kpacma edeyunuec, “Kedzahagoc yeng yoac yomoc negembeso.” ");
INSERT INTO ded_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Anu medacfora yeneng yoac heiheiac hania, imocac kpesimigec ");
INSERT INTO ded_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","yofi merengyemmeec, “Anutuac eucererenggac negen negeng sufu sufuya, imoc ngeneng negentegecgecdeac bic ngemmengemmea. Amma goa yeni kicngina fikecma mi henggecde nga kedzacnginango negengkecma naric mi negentegecgecde, imocac yoac heiheiausing yoac sasawa yemmeyemmea.” ");
INSERT INTO ded_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Yoac heiheiac hania imoc yofi, gbome imoc Anutuac yoac. ");
INSERT INTO ded_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nga gbome sinnu heiec, imoc ngicngac goa yeni yoara negenggec. Nga mangana minginango hama yoac imoc ubanginaunac meickeu yeni negensinggebeso obohoma komoc mi kpegecde. ");
INSERT INTO ded_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Gbome harongannu heiec, imoc ngic goango Anutuac yoac negemma heresongogoc bic hoanggegecde nga yoacngo ubanginau godea mong mi meecac naso wegenanecsac taru faitobannaso hau yeni wagecde. ");
INSERT INTO ded_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nga gbome hasennu heiec, imoc ngic goango Anutuac yoac negenggec, yeni kekecnginaac negengyohoc nga dzofinacac faitobang amma bangecac kekec hensongo angkecgec, imocngo yoac heihomeu fora mangana amma kpac angkecde.” ");
INSERT INTO ded_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Anu gbome bangec kerehagocfu heiec, imoc ngic goa yeneng Anutuac yoac negemma ubaherenginau faima sing dindingac nga gombunga mekecgecde. Mekecma seserigoc kecma fora meficgegecde.” ");
INSERT INTO ded_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ngic mongngo kifa kpedzereckema tera bageau faima mi kperahaude nga fefe bageau faiu mi tarude. Imoc kpac, ye kifa tatahau faiu tacma ngicngac amau eregecde, yeneng kperagi hendacgecde. ");
INSERT INTO ded_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Imoc yofiac, wiac sasawa sufu sufuya fede, imoc didiu fingectegerude nga wiac seme semea fede, imoc kecma kperagiau fingectegerude. Imoc sufu sufu mi kengkefude. ");
INSERT INTO ded_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ngic mong ye wiac goa femide, ye wiac monggoc migecde nga mong ye wiac mong mi femide, yearunac wiac fenende dema negende, imoc ifingoc wangecgec eng kefude. Imocac amma ngeni yoac negendae, imoc henghomema negemma kecbisia.” ");
INSERT INTO ded_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Anu Yesuac nonggo munafora yeneng yearu kenggec ngicngac homacngo hedzickegecac amma naric mi henggec. ");
INSERT INTO ded_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ifi anggec goa yeneng Yesuaru yofi degec enec, “Nonggo munafocga yeni hama genggecdeac ngadeau nandae.” ");
INSERT INTO ded_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ifi degec Yesungo deec, “ngicngac Anutuac yoac negemma modackecdae, yeneng nonggo munafocna andae.” ");
INSERT INTO ded_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Naso monnu Yesungo medacfora yenigoc gombau emma yofi edeyunuec, “Nenang dzohong noboc kenni.” Ifi deu kemmagec ");
INSERT INTO ded_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yesungo gau feu kia firangtoango hama dzohongtoa kpeu dokungo gomba mewakebeso anu yeni kemebeso anggec. ");
INSERT INTO ded_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Amma medac yeneng Yesuaru kemma midima degec, “Kunennina, Kunennina, neni kemebesonga andimbe.” Ifi degec Yesungo yacma firang nga dokuac siritembong dekpetari ayecmeu firang kpac anu dzohongngo ning kpema feec. ");
INSERT INTO ded_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Feu medacfora yeneac deec, “Ngeni negen negensingngina kpac, ifi isoc ande.” Ifi deu medac yeni kengecyunuu kerectegec amma yenaocngoc denegeng amma degec, “Ye noc ngic? Yeng firang nga dzohong yoac edeyuruu yeac enac tofohodape.” ");
INSERT INTO ded_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu nga medacfora yeni dzohong ferecgema Gerasene bangecfu kenggec. Bangec imoc Gariraia dzohong noboc. ");
INSERT INTO ded_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kensikema Yesungo gombaunac mama taong imocac ngic mong hadehadeforagoc meficgeec. Ngic imoc ye naso herea bic senggang kecma amau ngisitataha kpac kicsereu kecande. ");
INSERT INTO ded_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ngic imocngo Yesu hemma seriangoc arohoma Yesuac hoannu makpema yofi kparec, “Yesu Anutu engenatoaac Medac, neac wiac imoc geac mi ande. Ni desambic anggenduae, ge kpendzennu mi fainubesena.” ");
INSERT INTO ded_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nga Yesungo asu seuhagoc yearunac kporaru erema kenudeac bic edeec, imocac ifi deec. Asu seuhagoc imocngo naso herea ammiu ngic yeneng mema sengngo hanimaria kpema garenggegec. Nga ye seng kperecgedacma asu seuhagocngo wangecma bangec kisiu kengkefec. ");
INSERT INTO ded_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nga Yesungo kpesimiec, “Ge kpacga merac?” Kpesimiu deec, “Habutoa.” Hadehade homacngo yeac hereu kemema kecgecac amma yeng ifi deec. ");
INSERT INTO ded_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nga hadehade yeneng Yesu desambic ammigec, “Ge hofeu suenununa mi kemeni.” ");
INSERT INTO ded_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nga bangec imohai berechabu kunengngo fagannu surukpema kecgec. Anu yeni kporacyunuu berecfu kemegecdeac desambic ammigec yeng ifi anggecdeac negengyemmeec. ");
INSERT INTO ded_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Negengyemmeu yeni ngicfunac erema berec habu yenearu kemegec berec yeneng fagannunac nedzima dzohonnu kemema doku nema homedacgec. ");
INSERT INTO ded_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Homedacgec berecgareng yeneng faka fingerec, imoc hemma kengec worama siduc deyadigec taonnu nga bedzou kenec. ");
INSERT INTO ded_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kenu ngicngac yeneng imoc negemma faka fingerec, imoc henggecdeac Yesuaru hagec. Hama ngic hadehadeagoc kefec, ye henggec. Yeng negentegecma wamba heima Yesuac haniu tarec. Ifi taru yeni hemma kengecyunuec. ");
INSERT INTO ded_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nga ngic hadehadeforagoc kefecngo dafiu ngereedac, imoc ngic kicnginango faka fingeru henggec, yeneng siduc ayemmegec. ");
INSERT INTO ded_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ayemmegec gerasenengic yeneac amabangec, imocac ngicngac sasawango kengec homac yunuecac amma Yesungo wayunuudeac edegec. Edegec Yesungo dzigenema kenudeac gombau enec. ");
INSERT INTO ded_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Enu ngic hadehade kporacmiec, yeng Yesugoc kenudeac derecgeu Yesungo ine suema yofi edeec, ");
INSERT INTO ded_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ge amagau dzigene kemma Anutungo fakatoa anggendac, imoc dekperagibesena.” Ifi deu ngic ye kemma Yesungo yearu fakatoa meec, imoc taong hafoangoc dekperagiyemmedarec. ");
INSERT INTO ded_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesungo dzohong noboc kensikemanu ngicngac yeneng ye heitaigec. Yeni sasawango yeac tomai kecgec. ");
INSERT INTO ded_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Nga kpekpeturang amaac gareng mong kpara Yairo, yeng haec. Ye naroanga mocgusac, kifaya 12 ammanu homebesonga anecac amma ngic ye hama Yesuac haniau makpema ameau kenudeac desambic ammiec. Ammiu yeni kemmagec ngicngac habutoango noboc noboc hedzickegec. ");
INSERT INTO ded_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Anu ngac mong ye sacherec amma kecmanu kifaya 12 anu ye dzofinaha sasawa dota hania hania yemmeu mongngo ye mengereudeac sing mi meficgeec. ");
INSERT INTO ded_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ngac imoc ye habu yeneac botucfu Yesuac ngadeausing kemma ngakpiherehaac witic susia kpesereu sawa bic gbanggeec. ");
INSERT INTO ded_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Gbanggeu Yesungo kpesiec, “Merang kpeserenudac?” Ifi deu yeneng degec, “Imoc mi negendimbe.” nga Petorongo edeec, “Kebu, ngicngac homacngo orongguma hedzicgudae.” ");
INSERT INTO ded_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ifi deu Yesungo yofi deec, “Mongngo kpeserenudac, kuc wanuma monggaru kenu negendua.” ");
INSERT INTO ded_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ifi deu ngac ye yofi negenec, “Ye bic meficgedac.” Ifi negemma sufu sufu worabeso osima dzonoma fedeu hama Yesuac haniau makpeec. Amma ye Yesu kpeseredac nga dafiu ngerec ngeree bic yombong fingecmidac, ngicngac yeneac kicfu imoc dekperagidarec. ");
INSERT INTO ded_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dedaru Yesungo yofi edeec, “Naroanna, ge ruaegoc kenna. Negen negensinggango mengeregudac.” ");
INSERT INTO ded_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Amma ye yoac denammanungoc kpebung gareng, yeac amaunac yoac yofi haec, “Naroangga bic homedac, ge kpoukpou monggoc ebic mi mina.” ");
INSERT INTO ded_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ifi degec Yesungo imoc negemma Yairo edeec, “Ge mi kengecguu eng negensinggena. Ye kekec monggoc meficgeude.” ");
INSERT INTO ded_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesungo ifi dema amau kensikema ngic mongngo amau mi enudeac kpetarima Petoro nga Yohane amma Yakobo nga naroanggac nonggomama, yenigocsac enudeac deec. ");
INSERT INTO ded_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dema ngicngac hafoangoc yeni naroanggac kiacsonggong anggec yofi edeyunuec, “Ngeni kiac wagec, naroang ye mi homedac, ye gau fede.” ");
INSERT INTO ded_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ifi deu yeni dzomoremigec. Naroang ye bic homedac, ifi negenggec. ");
INSERT INTO ded_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nga ye ine naroanggac mariau mema kpacma deec, “Naroang, ge yacna.” ");
INSERT INTO ded_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ifi deu asuya monggoc kpoduu imohaingoc yacma taru Yesungo yaka migecdeac edeyunuec. ");
INSERT INTO ded_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nga nonggomama yereng kerectegec anec Yesungo ine ngic mong mi edeyunuecdeac kpae heiyemerec. ");
INSERT INTO ded_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesungo medacfora 12 kpacyunuu hadacgec hadehade nga yafing sasawa kporacyunugecdeac nga hafei hania hania mengeregecdeac uayoac nga kuc yemmeec. ");
INSERT INTO ded_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yemmema Anutuac eucerereng dekperagigecdeac nga hafeigoc mengereyunugecdeac sueyunuma ");
INSERT INTO ded_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","yofi edeyunuec, “Ngeni singgac mefic mong mi mekembisia, hie nga yaka amma yasu nga dzo mong mi mebisia nga ngakpi yohockang mi mekembisia. ");
INSERT INTO ded_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nga ama monnu kensikegec, ngic yeneng ama heingemmegec ngeni ama imohai tacyac angkecgec wisickeu taong monnu kembisia. ");
INSERT INTO ded_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nga taong mong imocac ngicngac yeneng mi hoangngunugecdeu ngeni taong imoc wama haninginaunac yube kpegec mau yeni imoc henggec faka imocngo manganangina edzacyunubeso.” ");
INSERT INTO ded_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ifi deu yeni amea amea kemma siduc gombung dekperagikecma hafeinginagoc mengereyunugec. ");
INSERT INTO ded_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ifi anu Gariraia bangecac gawanatoa kpara Herode, yeng wiac sasawa fingerec, imocac siduc negenu obohoec. Nocac ngic goa yeneng yofi degec, “Yohane dokunadzicngo homecfunac gborima yacma kecde.” ");
INSERT INTO ded_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ifi degec goango yofi degec, “Eriango fingecma kecde.” nga goa yeneng degec, “Profete bicngoc yombong kecgec, yenearunac mongngo hadac.” ");
INSERT INTO ded_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nga Herodengo deec, “Neng Yohane ubea bic kperecgeai nga yomoc ine merac ngicac siduc negengkecduae.” Dema Yesu henudeac kicfifi kefec. ");
INSERT INTO ded_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Anu aposoro yeni dzigenema ua megec, imocac siduc Yesu ammidacgec. Ammigec yeng meyunuma meickema tembuha tacbesonga taong mong kpara Betsaida, imohaigeng kenggec. ");
INSERT INTO ded_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kenggec habutoa yeneng imoc negemma ye modacgec. Modacgec, yeng hoangyunuma Anutuac eucerereng dekperagiyemmema ngerec ngereeac ayemmeec, yeni mengereyunuec. ");
INSERT INTO ded_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ama marai anu medacfora 12 yeneng Yesuaru hama degec, “Bangec yomoc ngiha kpacfu kecmina ama marai andeac habu sueyununa amabangec tackende, imohai kemma yaka meficge nema imohai febisia.” ");
INSERT INTO ded_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ifi degec deec, “Ngeneng yaka yemmegec negec.” Ifi deu merenggec, “Neni ic sogong marimong nga kondungyang yohockangsac mekecdimbe. Neni yaka mong mi bummebing dede habu sasawa yeneacsoc naric mi ambac.” ");
INSERT INTO ded_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ngic imoc yeneac kpetengina 5 tauseng, ifi isocngo kecgecac amma ifi degec Yesungo medacfora yofi edeyunuec, “Ngeni ngicngac edeyunugec, yeni 50 habusoc ifi kpedzucnema tackenggec.” ");
INSERT INTO ded_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ifi deu medac yeneng ngicngac ifi anggecdeac edeyunugec sasawango matacgec. ");
INSERT INTO ded_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Matacgec Yesungo ic sogong marimong nga kondungyang yohockang, imoc mema kiwa kurumennu fiu enu kenehema mendzirec. Mendzicma ngicngac mederema yemmegecdeac medacfora yemmeu ");
INSERT INTO ded_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","yeneng imoc mederema ngicngac yemmegec. Yemmegec ngicngac sasawango negebec amma yaka tosea neti anggec, imoc kpedzucnegec kemema sakac 12 wakeec. ");
INSERT INTO ded_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yesungo naso monnu yengenaocngoc numuudeac kecmanu medacfora yegoc kecgec yeni kpesiyemmeec, “Ngicngac yeni neac merac deandae?” ");
INSERT INTO ded_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ifi deu degec, “Goango Yohane dokunadzic nga goango Eria amma goa yeneng ine profete mong esea, yeng gborima kecde deandae.” ");
INSERT INTO ded_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ifi degec deec, “Nga ngeni ngenaoc ine neac merac deandae?” Ifi deu Petorongo deec, “Ge Anutuac Messia.” ");
INSERT INTO ded_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ifi deu, yeni yoac imoc ngic mong mi edeyunugecdeac deracyunuec. ");
INSERT INTO ded_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nga Yesungo yofi deec, “Ngicac Medac ye kpendzeng homac kpebeso. Yudangic enarafocngina nga womong gareng enara amma mitiac negen negengngic yeneng ye ubango wama kpegec homebeso. Homeu uameme harebec ammanu monggoc gborima yacbeso.” ");
INSERT INTO ded_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesungo habu sasawa yofi edeyunuec, “Ngic mong ye ni modacnubeso negendeu ye yengena ubasebiaac songo memama wenacsoc mariponga miacma tofohoma modacnubeso. ");
INSERT INTO ded_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ngic mong ye yengena kekeha segereudeac negemma uaya mekecde, ye kekeha sufumiude. Nga mong ye neac amma kekeha waude, ye ine kekeha fingecmiude. ");
INSERT INTO ded_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Imoc yofiac, ngic mong ye bangecac wiac sasawa meficgema mekecde, ye ine kekeha sufumidarude nga yengena memanganeemeu kekeha imoc fora kpac anude. ");
INSERT INTO ded_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nga ngic mongngo neac negenu gameagoc ande amma neac yoacnaac negenu gameagoc anude, yeac siduc yofi, Ngicac Medac ye Mamaac nga angeroforaac amma yengena kibikperagitoagoc haude, naso imohai yeng ngic imoc yeac ifingoc negenu gameagoc anude. ");
INSERT INTO ded_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nga ngic yomoc nandae, ngenearunac goa yeni mi homemagec Anutuac eucerereng hau henggecde, imoc forangoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Anu yoac imoc deec, imocac sonda mocgu isoc wisickemanu Yesungo Petoro nga Yakobo amma Yohane meyunuu numugecdeac tikiu enggec. ");
INSERT INTO ded_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Emma numumanu kicmesuya heimerenu siriha mong anu wambaya kperagima kongac koporarac yombong anec. ");
INSERT INTO ded_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ifi ammanu imohaingoc ngic yohockang, Mose nga Eria yereng fingecma yegoc denegeng anoc. ");
INSERT INTO ded_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yeri kibikperagitoangiragocngo fingecma Yesungo Yerusarennu kemma kekeha mesima wayunuma enudeac denegeng anggec. ");
INSERT INTO ded_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nga Petoro ogohoragoc, yeni gautoa fegec. Fegecfunac gborima yacma Yesuac kibikperagitoa nga ngic yohockang yegoc nanec yenenggec. ");
INSERT INTO ded_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nga ngic yohockang yeri Yesu wama kemmaec Petorongo Yesu edeec, “Kunenna, yei kecni songea andeac bedzo bedzo harebec meni, geac mong, Moseac mong nga Eriaac mong.” Ye wiac imoc mi negentegecma eng ifi deec. ");
INSERT INTO ded_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yoac denammanu hoeng mongngo fingecma mama semeyunuu kengec amma hoeng manau kemmagec ");
INSERT INTO ded_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","hoeng manaunac ubaudumeng mong yofi kpacma deec, “Yomoc neac Meisingmedacna, ngeni yeac yoac negembisia.” ");
INSERT INTO ded_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ubaudumeng imoc kpac anu yeni kic fima Yesu tembuha nanu henggec. Hemma medac yeni yoacngina waickema nanggec. Nga naso imohai wiac henggec, imocac ngic mong mi edegec. ");
INSERT INTO ded_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wereckengau Yesungo medacfora harebec yenigoc tikiunac kememagec ngicngac habu kunengngo meficgegec. ");
INSERT INTO ded_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Anu habu yeneac botucfunac ngic mongngo Yesuac kpacma derecgema deec, “Kpoukpou, ge hama medacna henna, ye medacna mocgusac. ");
INSERT INTO ded_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hadehade mongngo medac mendanggeu ye arohou asu manganango mema kpekpefac ammima sebia mekuc kpekutung meu enaraunac sofororoc ereande. Asu imocngo medac mi wama naso homac memanganeyombonggeande. ");
INSERT INTO ded_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nga medacfocga yeneng kporacmigecdeac edeyunuba yeni kporacbibiema wadau.” ");
INSERT INTO ded_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ifi deu Yesungo yofi deec, “Ngicngac areng yomoc ngeni negen negensingngina kpac amma fakangina sicsauha. Naso herea ngenigoc monggoc tacbadeac modzona tide. Ge medacga nearu mehana.” ");
INSERT INTO ded_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ifi deu medac ye wegena kemmanu asu seuhagocngo medac kpefaheu bangecfu makpeu yeac sebia mekuc kpekutung meu Yesungo asu seuhagoc yoac seria ammima medac mengerema mama monggoc miec. ");
INSERT INTO ded_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Miu ngicngac yeneng Anutuac kuctoa imoc hemma kerectegec amma negenggec wiac engena anec. Amma yeni Yesuac ua sasawa hemma kerectegec anggec. Ifi ammagec yeng medacfora yofi edeyunuec, ");
INSERT INTO ded_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ngeni kedzac kpema yoac yomoc negenggec. Naso mi hereemanu yeni Ngicac Medac kererema ngicngac yeneac mariu faigec kpegecde.” ");
INSERT INTO ded_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ifi deu medac yeni yoac imoc mi negentegecgecdeac Anutungo uba negen negengngina hedzickeec. Hedzickeu yeni Yesuac yoac obohoma imocac hania kpesimigecdeac kengecyunuec. ");
INSERT INTO ded_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Anu medac yenearunac merang engena ande, imocac yenaocngoc yoacngina engemmama anec. ");
INSERT INTO ded_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ifi anggec Yesungo negen negeng ubanginau feec, imoc bic negemma medacbisic mong mema yegoc faiu nanu ");
INSERT INTO ded_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yofi edeyunuec, “Ngic mong ye kpacna negemma medac yomoc hoanggeude, yeng ni ifingoc hoannude. Nga ni hoannude, yeng Kebu suenuec, ye ifingoc hoanggeude. Imoc yofiac, ngeneac botucfunac ngic mong mamea kecande, yeng engena ande.” Ifi deu ");
INSERT INTO ded_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanengo deec, “Kebu, ngic mongngo geac kpacfu hadehade nga yafing kporacyemmeu neni imoc hemma nenanggoc mi kecdeac amma kpetarimiding.” ");
INSERT INTO ded_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ifi deu yofi deec, “Ngic mong ye uanginaac ngaba mi ande, yeng ogongina ande. Imocac ngeni ye mi kpetarimibisia.” ");
INSERT INTO ded_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesungo kurumennu enudeac nasoya wegene hau negen negenga Yerusarennu sueu kenec. ");
INSERT INTO ded_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kenu ngic goa sueyunuu yeni waraima nenesemeng nga amagerec mengeregecdeac Samariaac guruama monnu kensikegec. ");
INSERT INTO ded_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kensikegec Yesungo Yerusarennu kenude, ngicngac yeneng imoc negenggecac Yesu ama mong mi heimigec. ");
INSERT INTO ded_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ifi anggec medahora Yakobo nga Yohane yereng imoc hemma yofi deoc, “Kebu, neni kurumennunac gerec deni mama ngic yomoc yonohodaru, imoc naric ambing me?” ");
INSERT INTO ded_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Deec Yesungo dzigenema yoac ifia negembesonga kpae heiyemeru ");
INSERT INTO ded_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","medacforagoc guruama monnu kenggec. ");
INSERT INTO ded_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sinnu kemma ngic mongngo Yesu edeec, “Ge ihai me ihai kennadesoc modacguma gegoc kembadeac negenduae.” ");
INSERT INTO ded_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ifi deu yeng yofi meremmiec, “Katekasi yeni bangec manau fefenginagoc nga sawa neng yeni faecnginagoc amma Ngicac Medacngo ine kparicganga kpac.” ");
INSERT INTO ded_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ye ngic mong yofi edeec, “Ge hama ni modacnuna.” Ifi deu yeng deec, “Kebu, negennemmana kemma manna tonggomaguc habade.” ");
INSERT INTO ded_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ifi deu meremmiec, “Homec yeni yenaocngoc tonggoemegec nga geng ine wayunuma kemma Anutuac eucerereng dekperagima kecbesena.” ");
INSERT INTO ded_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nga ngic mongngo deec, “Kebu, ni modacgubadeac negenduae nga kemma arengfocna edeyunumaguc ine habade, imoc naric me?” ");
INSERT INTO ded_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ifi deu Yesungo yofi edeec, “Ngic mong ye negen negenga bic suemaguc dzigenekpe ande, ngic ifiango Anutuac eucererenggacsoc mi ande.” ");
INSERT INTO ded_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Imoc wisickeu Kebungo ngic 72 meisingyunuma yohockang yohockang hendzicyunuec. Hendzicyunuma yengena taong nga amabisic kembesonga negensiec, imohai yeneng waraimigecdeac sueyunuma yofi edeyunuu kenggec, ");
INSERT INTO ded_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Semeng fora homacngoc kpauedac fede nga ua ngic ine efeanecsac kecdae. Imocac ngeni semeng mingina numumigec yeng ua ngic sueyunuu yeneng kemma foraya mekpedzuc ambisia. ");
INSERT INTO ded_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Negenggec, ramamedahango katekasi yeneac botucfu kecdae, siriha imocacsoc suengunuba kembisia. ");
INSERT INTO ded_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ngeni dzobirang me hie nga hanitabe mi mema kembisia. Amma sinnu ngic mong meficgema yoac mi mebisia. ");
INSERT INTO ded_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Amma ngeni ama imohai me imohai enggecde imohai emma yofi debisia, ‘Ruae ngenearu febeso.’ ");
INSERT INTO ded_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ifi degec ruaengic mong imohai kecdeu ngeneac ruaengo ye hoanggeude nga mi kecdeu ruae imoc monggoc ngenanu dzigeneude. ");
INSERT INTO ded_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ngicngac ama ngemmegec ngeni imohaingoc tacbisia. Nga yeni yaka nga doku ngemmegec ngeni imocnoc nebisia. Ngeni amayuguc mi kembisia. Uango ua ngic uabungngina meficgeyemmebeso, imocngo ngereeude. ");
INSERT INTO ded_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ngeni taong monnu kenggec ngic yeneng ama heingemmema wiac mong negecdeac ngemmedae, ngeni imoc nebisia. ");
INSERT INTO ded_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ngeni taong imohai ngicngac hafeinginagoc mengereyunuma yofi edeyunubisia, ‘Anutuac eucererengngo ngenearu bic mewegenengunuma hama fede.’ ");
INSERT INTO ded_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nga ngeni taong monnu enggec ama mi heingemmegecdeu ngeni ine amasingnginau kemma yofi edeyunubisia, ");
INSERT INTO ded_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Taongnginaac yubengo hanininau mendanggedac, neni imoc ifingoc kpeni mama imocngo manganangina edzacngunubeso. Nga ngeni ine yofi negembisia. Anutuac eucererengngo yei bic mewegenengunuma hama fede.’ ");
INSERT INTO ded_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Amma nasoya hau taong imocac turunga ebiria yombong haude, imoc Sodong amabangec ferahema fingerude, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Korasing nga Besaida ngicngac, ngeni sowecnginagoc. Ngenearu kucfaka homac bic fingerec. Amma kucfaka ifia Tiro nga Sidong taonnu fingecbacfu yeni kopocsicnginaac ubahodunggac wamba bic heima hama nadzicma tacma ubamereng ambau. ");
INSERT INTO ded_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nga ising ising nasotoau Anutungo Tiro nga Sidong areng, yeneac ubamangang negemma turunga efeanec yemmema ngeni ine turunga ebiriangoc ngemmeude. ");
INSERT INTO ded_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Amma Kafanaung, geng kurumennu ennadeac ifi negengkecnec nga kpac yombong. Ge homecamau megu keme kemea siriha annec. ");
INSERT INTO ded_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ngic mong ye kedzaha ngenearu faide, yeng kedzaha nearu faide. Nga ngeni ngadengunuude, yeng ni ngadenuude nga Kebu suenuec, ye ifingoc ngadeheude.” ");
INSERT INTO ded_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Anu ngic 72 yeni sogac sogaigoc dzigenema degec, “Kebu, neni kpacga kpacni hadehade nga yafing yeneng yoacnina tofohoma woragecde.” ");
INSERT INTO ded_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ifi degec Yesungo yofi merengyemmeec, “Ni Satang hemba yeng piratac isoc heima kurumennunac maec. ");
INSERT INTO ded_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Negenggec, ni uayoac nga kuc bic ngemmeai. Ngemmeba ngeni boudzoc nga wemeweme witinginau naric tigecde amma ngabanina nga yeac arengfora sasawa yeneng ngeneac bageu kecgecde. Nga wiac mongngo ngeni naric mi memanganengunuude, kpac. ");
INSERT INTO ded_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nga hadehade nga yafingngo enacngina tofohoma woraandae, ngeni imocac homac mi sogaibisia. Nga kpacarengngina kurumennu oho ohoya fede, ngeni imocac homac yombong sogaibisia.” ");
INSERT INTO ded_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naso imohaingoc Tiri Asungo Yesu ammiu sogac sogai songongo mewakemiu yoac yofi deec, “Manggac, kurumeng nga bangec mingina, geng wiacga sasawa yomoc mesufuyemmenecac ngicareng negen negentegecnginagoc nga fitira kecdae, yeni imoc mi hennegeng andae. Amma nambaracbisic bisic, yeni wiac yomoc mekperagiyemmenec, imocac dengereguduae. Manggac, ge imoc hemma ubaga ngereede, imoc fora. ");
INSERT INTO ded_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mannango wiac sasawa nenec imoc mekecduae. Nga mongngo Medahaac hania naric mi negende, Manggacngosac negemmide. Ifi isocngoc mongngo Manggacac hania naric mi negende, Medacngosac ye negemmide. Amma Medacngo ngicngac meisingyunuma Manggac edzacyunude, yeneng ifingoc ye negemmigecde.” ");
INSERT INTO ded_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Anu Yesungo medacfora yenearu dzigenema yeneacsac yofi dema edeyunuec, “Faka yomoc fingeru kicnginango hengkecdae, ngeni kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ni edengunuba negenggec, warac profete nga ngictau homac yeneng ngeni wiac hengandae, imoc hembeso negemma sifu mi henggec. Nga ngeni wiac yomoc kedzacnginango negengandae, yeneng imoc ifingoc negembeso ayemmeu mong mi negenggec.” ");
INSERT INTO ded_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Anu dedeseriyoac negen negengngic mongngo hama Yesu faitobannu faiudeac negemma deec, “Kpoukpou, ni faka dafi amma kekecseriac maridzoming mebade?” ");
INSERT INTO ded_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ifi deu Yesungo yofi meremmiec, “Dedeseriyoacfu yoac oho ohoya fede, ge kibi imohai dafi osonegeng angannec?” ");
INSERT INTO ded_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ifi deu ngicngo meremmiec, “Ge ubaherega nga ubaongaga nga kucga amma negen negengga hafoangoc Kebu Anutuga heresongogoc hoanggebesena.” Amma, “Ge geangga anggengande, siriha imocngoc gegoc wegena kecdae, yeni heresongogoc hoangyunubesena.” ");
INSERT INTO ded_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ifi deu Yesungo yofi edeec, “Ge yoac dindingac dema merennendang. Ifi amma kecengkecbesannec.” ");
INSERT INTO ded_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nga ngic ye Yesungo yeac ngic dindingac debeso, ifi negemma kpesimiec, “Nga ngicngac neac wegena kecdae, imoc merac yombong?” ");
INSERT INTO ded_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kpesimiu Yesungo meremmiec, “Ngic mongngo Yerusarennac Yeriko taonnu kemeudeac kemma godzungic yeneac mariu heiec. Heiu yeneng wambaya hesima kpegec homebeso anu ukugec feu woragec. ");
INSERT INTO ded_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Femanu womong gareng mongngo imohacsing kemema ngic feec, ye hemma kpegegenggema nobocsing kenec. ");
INSERT INTO ded_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kenu womong gareng yeneac memefic ngic mongngo ifingoc imohai kemeec. Kemema ngic imoc henu feu ye ifingoc kpegegenggema nobocsing kenec. ");
INSERT INTO ded_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Anu samariangic mongngo sing imocngoc modacma kemema ngic feec, ye hemma yeac ubea manganeec. ");
INSERT INTO ded_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Manganeu yearu kemma kerec doku nga waing dokuya kubehau kpakema kubeha biranggemiec. Biranggema yengena donggi witiau faima kiangamau mekemma henggareng ammiec. ");
INSERT INTO ded_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Amma wereckengau siriwa dzo yohockang kiangamaac gareng mima yofi edeec, ‘Ge ngic yomoc henggareng ammima kecbesena. Ni monggoc dzigeneba dzo imocngo mi heiude isoc, imohaingoc imocac turunga gembade.’” ");
INSERT INTO ded_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ifi dema Yesungo dedeseriyoac negen negengngic yofi kpesimiec, “Ge dafi negennec? Ngic ye godzungic yeneac mariu manganeec. Nga ngic harebec yenearunac ngic merang yeac ogo amma wegena kefec?” ");
INSERT INTO ded_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ifi kpesimiu yeng meremmiec, “Yeac ubamangang negemma meficgeec, yeng.” Ifi deu Yesungo yofi edeec, “Ge geanggaoc kemma ye anec, ifi isoc angkecbesena.” ");
INSERT INTO ded_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu nga medacfora yeni kengkecma guruama monnu kensikegec. Kensikema ngac mong kpara Mata, yeng Yesu ameau enudeac heitaiec. ");
INSERT INTO ded_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Heitaiu Mataac munea kpara Maria, yeng Kebuac haniu matacma yoara negenec. ");
INSERT INTO ded_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Negemmanu Matango ine dzandzung namma yenigoc mi tacma ha namma Yesu edeec, “Kebu, ge neac negengyohoc mi annec. Ni tembucna ngenenggareng ua mebadeac munana wanudac, ye edena meficnuu.” ");
INSERT INTO ded_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ifi deu Kebungo yofi meremmiec, “Mata Mata, ge wiac homacac negengyohoc amma ebic mekecnec. ");
INSERT INTO ded_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Amma wiac mocgusac imoc megec ngereeude. Maria ye wiac gombunga isinggema mekecde, imoc mongngo yearunac naric mi meickeude.” ");
INSERT INTO ded_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesungo naso monnu kemma botuha monnu numuu wisickeu medacfora yenearunac mongngo deec, “Kebu, Yohane ye medacfora numugecdeac sing kpouyemmeec, ge ifingoc ifia goa kpounemmena.” ");
INSERT INTO ded_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ifi deu Yesungo yofi deec, “Ngeni yofi dema numubisia, ‘Manggac, geac kpac kpetiac febeso. Anu eucererengga imocngo hanemmebeso. ");
INSERT INTO ded_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ge wenacsoc yaka socnina nemmebesena. ");
INSERT INTO ded_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kopocsicnina wanemmena. Neni ifingoc ngic yeneac kopocsicnginaac turung kpoukpouac wayemmekecdimbe. Faitobannu mi fainunubesena.’” ");
INSERT INTO ded_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ifi dema yofi edeyunuec, “Ngenearunac mongngo tofocnac dzongiau ogea monggac amau kemma debac, ‘Ogona, ge ic sogong harebec meficnuna turunga ngade gembade. ");
INSERT INTO ded_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ogona mongngo sing hereaunac hama tofocnac amanau hau yakana kpac anu noc gumebadeac obohoduae.’ ");
INSERT INTO ded_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ifi deu ogea ama manau tacma debac, ‘Ge ebic mi nenna. Nagunina bic meserima nambaracfocnagoc gaufedimbeac naric mi yacma megembade.’ ");
INSERT INTO ded_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ni edengunuba, ye ogeaac amma ic sogong mi mibac dede yeng ngombonggema engngoc kpesimibac, imocac amma ye sifu yacma ic sogong miude. ");
INSERT INTO ded_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Ngic mong ye numukecde, yeng wiac imoc meude nga hofockecdengo wiac imoc meficgeude amma naguu heiande, yeac nagu witimigecde. Imocac ngeni numugec turunga ifi ngemmeude nga ngeni hofocma foraya meficgegecde amma naguu heigec nagu witingemmegecde. ");
INSERT INTO ded_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ngeneac botucfu manggac monggac medahango kondungyanggac kpesimiu yeng boidzoc mangana naric mi miude. ");
INSERT INTO ded_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nga ye kokorec gbomeaac kpesimiu weme weme naric mi miude. ");
INSERT INTO ded_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ngic ngeni mangana angandaengo sifu nambaracfocngina ubangerecac wiac gombunga yemmegecdeac negentegecdae. Imocac yofi negenggec, kurumeng Mangnginango fakangina gombunga imoc homac feraheu ngicngac Tiri Asuya yemmeudeac kpesimidae, yeni Tiri Asuya naric yemmeude.” ");
INSERT INTO ded_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Naso monnu Yesungo hadehade mong yoara kpac, imoc ngicfunac kporarec. Kporaru hadehadengo ngicfunac erema kenu ngic yoara kpac kefec, yeng yoac deu ngicngac yeneng kerectegec anggec. ");
INSERT INTO ded_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nga ngicngac goa yeni ine yofi degec, “Ye hadehade nga yafing yeneac ngictaungina Bedzeburu yeac kucfu ngicngac yenearunac kporacande.” ");
INSERT INTO ded_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Anu goa yeneng ine Yesu kuha isinggegecdeac negemma kurumennunac faka kuhagoc mong meudeac edegec. ");
INSERT INTO ded_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Edegec Yesungo negen negengngina bic negemma yofi edeyunuec, “Bangec monggac ngic yeneng ngaba angemema tohogecdeu bangec imoc kisi fingeru ama mongngo ama monggac witiau makpema kpac anude. ");
INSERT INTO ded_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nga Satangngo tohoma yengenaocngoc kporacemeudeu ye nga arengfora naric mi serima nanggecde, kpac. Nga ngeni neac ine deandae, ‘Ye Bedzeburungo ammiu yeac kucfu hadehade nga yafing kporacyunuande, imoc obohode.’ ");
INSERT INTO ded_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Neng Bedzeburuac kucfu hadehade nga yafing kporacyunubai dede ngeneac medacfocngina yeni ifingoc yeac kucfu hadehade nga yafing kporacyunubau. Ifi anu ngeneac medacfocnginango yoacngina isinggema desigecde. ");
INSERT INTO ded_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nga Anutungo gbonga faiu ni imocngo hadehade nga yafing kporacyunuduaeu Anutuac eucererengngo ngenearu bic hadac kecde, ngeni imoc negenggec.” ");
INSERT INTO ded_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ngic kuhagoc mongngo dzikacac iwaiya mema ameaac gareng kecmanu finaha gombunga feude. ");
INSERT INTO ded_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nga ngic mong kuha monggoc, yeng yearu hama yegoc ewema firang anudeu yeng ngic yeac dzikacac iwaia wangecmidarude. Wangeru ama minginango dzikac wiac, imocac kucfu seria kefec, imoc kpac anu ngic kuha monggocngo yeac finaha hamangec mema hendzicma ngicngac goa yemmeude. ");
INSERT INTO ded_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ifi anu mong ye neac ogona mi ande, ye ubeango wanude. Nga mong ye nigoc mekpedzuc ua mi meude, yeng neac wiac sinsararang kpeudeac ua meude.” ");
INSERT INTO ded_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Asu seuhagoc yeng ngicfunac erema bangec dokuya kpac, ihai kemma tacnegenudeac tatac hofocma yerecgema kecande. Kecma tatac mong mi meficgeudeu yengenaocngoc yofi deude, ‘Amana warac tacma wayai, imohai monggoc dzigenema kembadeac negenduae.’ ");
INSERT INTO ded_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ifi dema kemma ama imoc wangge memengere angana henude. ");
INSERT INTO ded_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hemma monggoc kemma arengfora 7 wangecyunuu hagecde. Arengfora imoc yeneng ye ferahema mangana yombong andae, yeni meyunuma kemma ama imohai enarangina anu tacgecde. Tacgec ngic ye warac mangana kefec, imoc ferahema imocac mangana yombong kefude.” ");
INSERT INTO ded_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesungo yoac ifi demanu ngac mongngo habu yeneac botucfunac kpacma deec, “Ngac meguma namuu garengguec, ye kenehagoc.” ");
INSERT INTO ded_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kparu Yesungo imoc wama yofi deec, “Ngicngac Anutuac yoac negemma hoanggeandae, yeni kenecnginagoc.” ");
INSERT INTO ded_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ngicngac habu yeni engngoc hamangoc fegec Yesungo yoac torokpema yofi deec, “Naso yomocac ngicngac ngeni areng mangana yombong. Ngeni kucna isinggegecdeac faka kuhagoc fingecngemmeudeac derecgeandae. Nga ngeni faka kuhagoc mong mi ngemmengemmea, Yonaaru kucfaka fingerec, ifiasac henggecde. ");
INSERT INTO ded_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Niniwe taonggac ngicngac yeneng negensinggegecdeac Kebungo Yonaaru faka kuhagoc meec. Nga siriha imocngoc Ngicac Medac yengenaoc ngicngac yomocngo negensinggegecdeac fakaya kuhagoc meude. ");
INSERT INTO ded_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Seba bangecac ngactau ye Saromoac negen negentegec meudeac bangec tegiau sautfunac haec. Imocac amma yeng ising ising nasou ngicngac yomoc yenigoc yacma nammagec fakangina isinggema yeneac mangana deyemmeude. Anu negenggec, yomocngo Saromoac negen negeng ferahade. ");
INSERT INTO ded_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniwe taonggac ngic yeni Yonaac dedekperagiyoac negemma ubamereng anggecac amma yeneng ising ising nasou ngicngac yomoc yenigoc yacma nammagec yeneac fakangina isinggema yeneac mangana deyemmegecde. Negenggec, yomocngo Yonaac faka ferahade. ");
INSERT INTO ded_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mongngo kifa kpedzereckema sufu sufuu me pake bageau naric mi faiude, ye kifa imoc tatahau faiu tacma kperagiu ngicngac yeni erema kperagia henggecde. ");
INSERT INTO ded_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kicga imoc sebigaac kifa amma kicga gombunga fema sebiga sasawa mekperagidarude. Nga ge kickerec me kicmangang mekecma kicgango manganeudeu ine sebiga sasawa kundung kpeude. ");
INSERT INTO ded_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Imocac amma ge kperagia fegende, imoc kundung kpebacac amma garengemema kecbesena. ");
INSERT INTO ded_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ge sebiga sasawango kundunga kpac kperagigoc feudeu sebiga kperagiango sokoma feude. Imoc kifa mong kperagitoayagoc mekperagiguande, ifi isoc.” ");
INSERT INTO ded_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Anu Yesungo yoac demanungoc farisaio mongngo yegoc yaka neudeac heitaiu yeac amau emma taroc. ");
INSERT INTO ded_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Matacma maria mi dzuacma yaka eng neudeac anu farisaiongo imoc hemma kpidohou ");
INSERT INTO ded_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kebungo ine yofi edeec, “Farisaio ngeni teratasengina ngadeasac dzuacandae nga ngeni ubaherengina manau ine kickerec amma wiac manganango wake wakea fede. ");
INSERT INTO ded_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ngeni negen negengtegecngina kpac. Kebungo ngadeau wiac meec, yeng manaac ifingoc meec. ");
INSERT INTO ded_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ngeni imocac amma ngicngac makpekpea wiac heregoc yemmebisia. Ifi anggec wiacngina sasawa dzuac dzuara anude. ");
INSERT INTO ded_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisaio, ngeni romboc nga gime amma mondzangngina sasawa imocac kpete mema 10 imohacnac mocgu hendzicma Anutu miandae. Nga faka dindingac nga heregoc Anutuac songo negembesonga, imoc ine ihoc bahoc amma waandae, imocac ngeni sowecnginagoc. Ngeni faka gombunga imoc modacbisia amma tosea mi wabisia. ");
INSERT INTO ded_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisaio, ngeni kpekpeturang amau tatac warac warac imohai tacgecdeac angemmeande nga ngicngac yeneng kpedzaroc sobennu eweheihei faka angemmegecdeac songo negengandae, imocac ngeni sowecnginagoc. ");
INSERT INTO ded_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kicsere esea mong wiaha kpac ngic yeneng mi negemma eng witiau kengha andae, ngeni kicsere ifia isoc kecdae, imocac ngeni sowecnginagoc.” ");
INSERT INTO ded_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ifi deu dedeseriyoacac negen negengngic yenearunac mongngo edeec, “Kpoukpou, ge ifi dema neni ifingoc denggbarinnununec.” ");
INSERT INTO ded_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ifi deu Yesungo yofi merenec, “Dedeseriyoacac negen negengngic, ngeni ifingoc sowecnginagoc. Ngeni ngic yeneac ngadenginau finac ngicngo memeacsoc kpac, imoc faiandae nga ngenang ine ngicngac ebicngina efea anude, imoc meficyunugecdeac gbongngina mong mi sinegecde. ");
INSERT INTO ded_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bangecfocnginango profete esea yunuhomegec homegecmoc yeneac kicsereu simengngina miacandae, imocac ngeni sowecnginagoc. ");
INSERT INTO ded_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yeneng profete yunuhomegec nga ngeneng kicserengina simenggoc miackeandae, ngeni ifi amma yofi dekperagidae, ‘Neni fakaninau uba mocgu kecdimbe.’ ");
INSERT INTO ded_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ngeneac amma Anutuac negen negentegecngo bicngoc yofi deec, ‘Ni profete nga aposoro yenearu sueyunuba yeneng goa yunuhomegecde nga goa yunukporac ayemmegecde.’ ");
INSERT INTO ded_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Imocac amma bangec hanac hanaheaunacngoc erekecma profete yunuhomegec sacngina maec, imocac turunga yagucac ngicngac kecdae, ngenearunacngo kpoudacgecde. ");
INSERT INTO ded_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Turung imoc Abeac sacfunac hanahema erekecma Dzekariaac sacfu erede. Yeni Dzekaria arata nga kpetiac ama botucngirau kpehomegec. Oc, ngicngac areng yomoc ngeneng turunga imoc kpoudacbisia, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Dedeseriyoacac negen negengngic, ngeni Anutu negemmigecdeac ki, imoc ngicngac yenearunac meickegec. Amma ngenang imohai mi emma ngicngac yeneng embesonga ammagec ine kpae bic faiandae, imocac ngeni sowecnginagoc.” ");
INSERT INTO ded_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Anu Yesungo wama ngadeau kemeu mitiac negen negengngic nga farisaio, yeneng yeac negemmangang amma kpesi kpesi hania hania kpesimigec. ");
INSERT INTO ded_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yeni, “Yoac goa segeu meni.” dema yeac gareng mema kecgec. ");
INSERT INTO ded_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ngicngac homac yombong, teng tauseng nga noc ifiacsoc yeni kpezucnema nanggecac yenaocngoc timbimbingemegec. Nga Yesungo medacfora, yeneac negemma yofi deec, “Ngeni farisaio yeneac ikoc fakangina imocac henghomema kecbisia, imoc yis isoc ic sogonnu sokoude. ");
INSERT INTO ded_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wiac mong sangoyagoc fede, imoc kecma nonongkac fingectegerude nga sufu sufuya fede, imoc negendacgecde. ");
INSERT INTO ded_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Imocac ngeni kundunnu yoac sasawa deandae, imoc kperagiau negenggecde nga ama mana kapiau kedzacnginau sangic sangic deandae, yeni imoc ama witiau namma dekperagigecde. ");
INSERT INTO ded_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nga tosofocna, ngic goa yeni sebingina kpehomegecdeac kuc mekecma monggoc memanganengunugecdeac kuc hofocandae, ngeni yeneac mi kengecngunubeso, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngeni ine Kebu monggacsac damungunubeso. Yeng ngunuhomema gerechofeu ukungunuu kemegecdeac uayoac nga kuc mekecde. O, yofi deduae, ngeni yeac ine damungunubeso. ");
INSERT INTO ded_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ngicngac yeni nengbisic 5 faigec peni yohockang sacsacngo bummeandae nga Anutungo neng imoc yenearunac mong naric mi nigeckpeude. ");
INSERT INTO ded_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Amma ngeneac orucdzongina kpete, imoc ifingoc oso osodara. Nga ngeneng sawaac nengarengtoa yeni feracyunudae, imocac ngeni mi kengecngunubeso. ");
INSERT INTO ded_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ngic mong ye ngic yeneac kicfu Ngicac Medac yeac deande, ‘Ni yeac areng anduae.’ ifi deu Ngicac Medacngo yeac ifingoc Anutuac angerofora yeneac kicfu yofi deude, ‘Ye neac ngic.’ ");
INSERT INTO ded_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nga ngic mong ye ngic yeneac kicfu ine ni busicnuude, neng ye ifingoc Anutuac angerofora yeneac kicfu busic kpebade. ");
INSERT INTO ded_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ngic mong ye Ngicac Medac emmiude, yeac kopocsic wamigecde nga mongngo Tiri Asu denggbaringgema emmiude, imocac kopocsic wawaya ine mi fede. ");
INSERT INTO ded_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ngic yeneng mengunuma kpekpeturang amau nga yoacgarenggac enara nga ngickuneng, yeneac kicfu faingunugecde, ngeni naso imohai negengyohoc amma yofi mi debisia, ‘Neni turunga dafi merennide nga noc yoac denide?’ ");
INSERT INTO ded_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Naso imohaingoc Tiri Asungo yoac enacnginau faiu ngeni imoc debisia.” ");
INSERT INTO ded_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anu ngicngac habu yeneac botucfunac ngic mongngo Yesuac deec, “Kpoukpou, dacna ye mannaac maridzoming tembuha mekecde, imocac geng dena noboha ni mederema nenu.” ");
INSERT INTO ded_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ifi deu Yesungo yofi meremmiec, “Ngic, ngereac iwai mederema gareng ambadeac mongngo mi fainuec.” ");
INSERT INTO ded_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ifi dema torokpema yeneac yofi deec, “Ngeni dzofinactoaac kichodung ambauac garengngina mebisia. Ngic monggac dzofinactoa, imocngo yengena kekehaac siriha mi heficgeude.” ");
INSERT INTO ded_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ifi dema yoac mong heima yofi edeyunuec, “Ngic dzofinactoagoc mongngo uayau semeng fora homac anu ");
INSERT INTO ded_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","semenga dahai faiudeac negengemema ");
INSERT INTO ded_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","yofi ambade negenec, ‘Ni semengama dafiguc mekecduae, yeni hembarackema monggoc meyadiyunuma mema semeng nga wiacna gombunga sasawa kpedzucnema ihai kpeturanggebade. ");
INSERT INTO ded_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kpeturanggeba wisickeu neanna ubaonganaac yofi debade, ni kifa homacacsoc wiac gombunga bic kpedzucnedua, imocngo kekecna meefaiu menec amma sogac sogaigoc kecbade.’ ");
INSERT INTO ded_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ifi deu Anutungo yeac yofi deec, ‘Kapangic, tofocnac yomohaingoc kekecga wangecgugecde. Nga wiacga mekpedzuc amma wanade, imoc goa yeneng megecde.’” ");
INSERT INTO ded_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nga Yesungo monggoc torokpeec, “Ngic mong ye yengenaac amma bangecac dzofinactoa mekpedzuc amma Anutuac kicfu ine dzofinaha kpac kecde, yeac kekeha imocacsoc anude.” ");
INSERT INTO ded_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Imocac amma Yesungo medacfora yofi edeyunuec, “Neni noc yaka nenide nga sebininau noc wamba heima kecni. Ngeni imocac kekecnginaac defagung mi ambisia. ");
INSERT INTO ded_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kekecngo yaka ferahaude nga sebingo ngakpikporuc ferahaude. ");
INSERT INTO ded_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ngeni wondong yenenggec. Yeni heikpenec nga netohong mong mi negenggec Anutungo sifu eng semeng yemmekecde. Nga Anutuac kicfu ngeneng neng yeneac engena andae. ");
INSERT INTO ded_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ngenearunac mongngo dewaidzoc amma kefu imocngo kekecnasoya kapianec monggoc naric mi mehereeude. ");
INSERT INTO ded_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ngeni wiac kapia ifiaac obohoma tosea goaac ifingoc negengyohoc mi ambisia. ");
INSERT INTO ded_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Dzaring eng tohoandae, ngeni yenembisia. Yeni witic mi yumuandae amma uatoa mi mema sifu yadiandae. Ngictau Saromongo warac wamba kibia gombunga gombunga heikefu kibikperagitoayango ine dzaring yeneac kibi kereng kereng mi ferahaec. ");
INSERT INTO ded_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nga dzaring amasobennu eng tohoandae, yeni yagucac fingecdae nga ngic yeni wereckenu herecgema gerecfu ukuyunugecde. Nga Anutungo dzaringtehec ifia wamba heiyemmeudeu yeng ifingoc ngicngac negen negensingngina kapia mekecdae, ngeni ngakpikporucngina torokpeu torokpe imoc monggoc ngemmeude. ");
INSERT INTO ded_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Imocac ngeni noc yaka nga doku dahacnac fima negecdeac negengyohoc nga demadzac imoc wabisia. ");
INSERT INTO ded_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nga bangeha bangeha ngicngac yeneng imoc megecdeac negen negengngina imohai faigec fekecde. Nga ngeni wiac imocac obohoandae, Mangnginango imoc bic negende. ");
INSERT INTO ded_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ngeni yeac eucerereng meficgegecdeac ua mebisia nga wiac imocnoc ifingoc torokpeu torokpe megecde.” ");
INSERT INTO ded_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Habubisic, ngeni mi ebiribisia. Mangngina ye eucererenga ngemmeudeac negenu ngereede. ");
INSERT INTO ded_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ngeni finacngina suegec ngicngac yeneng imoc bummedacgec ngeni dzo imoc mema ngicngac makpekpea kecdae, yeni ubangerecac wiac imoc yemmebisia. Ngeni dzobirang mi barackeudeac meficgebisia. Nga ngeni dzofinac kuha mi maude, imoc kurumennu kpedzucnebisia. Ihai hamangecngic yeni mi hagecde nga dzaukpadzadzangngo wiac mi memanganeude. ");
INSERT INTO ded_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Imoc yofiac, ngeni dzofinacngina nofu faigec fede, imohaingoc ubasongongina ifingoc feude.” ");
INSERT INTO ded_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ngeni kporucngina seria kpema kifangina kpedzereckema efaima kecbisia. ");
INSERT INTO ded_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ngic kuneng ye memeturang amaunac hama naguu heiu ua ngihango yeac tomai kecma nagu bic witimiude, ngeni ifi isoc tomai kecbisia. ");
INSERT INTO ded_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nga mingingnginango hama uamedacfora yeni gaugbori kecgec meficyunuude, yeni kenecnginagoc. Foracngoc, ye yengenaoc yeneac kingang kpeudeac kporuha mewegenema ‘Ngeni tacmagec.’ deu tacgec yaka meha yemmeu negecde, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ye tofocnac dzongiau me ama werec wereckenggac gaugbori kecmagec hama yenenudeu uamedac imoc yeni kenecnginagoc. ");
INSERT INTO ded_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hamangecngic ye ama hetackema engande. Nga ama mingina mong ye hamangecngic noc nasou haude negendeu ye hamangecngic kpae heimiude. ");
INSERT INTO ded_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nga ngeni Ngicac Medacac aua mi negemmagec ye haude, imocac amma ngeni ifingoc efaima kecbisia.” ");
INSERT INTO ded_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Anu Petorongo deec, “Kebu, ge yoac heima dedammoc, imoc neneac me ngicngac sasawa yeneac denec?” ");
INSERT INTO ded_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ifi deu Kebungo yofi merenec, “Amagareng gombunga mong negen negentegehagoc minginaac yoac dede modacande, minginango amagareng ifia uayoac miu ye uamedacfora yeneac enarangina amma yaka nasou hendzicma deecfu negecdeac yemmekefude. ");
INSERT INTO ded_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yemmekefu minginango dzigene hama henu uamedacngo ua imoc medarudeu uamedac ye kenehagoc. ");
INSERT INTO ded_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Foracngoc, minginango wiara sasawa garenggeudeac demiude, imoc fora yombong. ");
INSERT INTO ded_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Anu wanacngic mong ye yengenaocngoc ine yofi negensiudeu, ‘Minginnango bic mi haude.’ Ifi dema ua ngicngac goa yunuma minginaac wiac nedacma doku seria nema ubea sufuude. ");
INSERT INTO ded_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ifi anudeu wanacngic ye tomai mi kecma minginaac uamemenaso nga auaya mi negemmanu minginango haude. Hama uamedac imoc herecge meickeu kemema negen negensingngina kpac, yenigoc kefude. ");
INSERT INTO ded_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nga wanacngic mong ye minginaac yoac negemma mi efaima kecde, yeng dzikac ebiria kiude. ");
INSERT INTO ded_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nga wanacngic mong ye minginaac uayoac nga songo mi negemma dzikacac arennu faka goa angande, ye dzikac efeanecsac kiude. Ngicngac yeneng ngic mong wiac ebiria migec mekecde, yearu wiac ebiriangoc fingecmiudeac negenggecde. Nga yeni ngic mong wiac homac garenggeudeac uayoac migec mekecde, yeng wiac monggoc negen negengtegecgoc garenggeu imoc mi memanganeudeac negenggecde. ");
INSERT INTO ded_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ni bangecfu gerec habuya habuya fiba dzeudeac mayai. Amma gerec imoc bic dzebacfu ubana ngereebac. ");
INSERT INTO ded_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amma ni dokunadzic siriha mong nadzicbesare. Ni imoc negemma herenango ebiriu kecma uana imoc hafoangoc wisickeu herena ngereeude. ");
INSERT INTO ded_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ni bangecfu ruae meficgebadeac mayai, ngeni imoc mi negembisia, imoc kpac. Ni ine tohoemegecdeac mayai, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nga yofinenggac nga namma enude, imohai ngicngac 5 ama mana monnu kecdae, yeni tohoma kecgecde. Harebec yeneng yohockang yerigoc nga yohockang yeri harebec yenigoc ngaba ngaba angemegecde. ");
INSERT INTO ded_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yeni tohoma manggacngo medac yegoc ngaba anude nga medac yeng mamagoc ngaba anecde. Nenggac ye naroangagoc ngaba anude nga naroangngo nonggeagoc ngaba angemeecde. Nga erangi yeri tohoemema ngaba angemeecde.” ");
INSERT INTO ded_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Anu Yesungo ngicngac yeneac yofi deec, “Ngeni wenac keme kemeau hoeng mong hemma yofi bic deandae, ‘Kia kuneng kpeude.’ ifi degec kia kpeude. ");
INSERT INTO ded_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nga sautfunac firang kpeu negemma yofi deandae, ‘Bangec gerea anude.’ degec ifi angkecde. ");
INSERT INTO ded_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ikocngic, ngeni bangecfu nga sawau wiac fingecande, imoc hemma naric isinggegecde. Nga naso yofinenggac kecdimbe, imocac faka hemma isinggebau dede imocngo naric ambac. ");
INSERT INTO ded_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Amma ngeni faka damocngo dindingac ande, imoc ngenaoc isinggebau dede imoc naric ambac. ");
INSERT INTO ded_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Anu ngabaga mongngo yoacfu faiguudeac meguu ngerahafoc sinnu kengkecdape, ge imohai yoacngira dengereecdeac uatoa mebesena. Ifi mi annadeu ye desi desingic yearu faiguude. Nga desi desingicngo keracnatanggaru faiguu keracnatangngo witicamau faiguude. ");
INSERT INTO ded_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Faiguu ge ihai takecma ngabagaac turung hafoangoc nga dzo wisic wisickea yombong kpoumaguc witicamaunac manade, imoc edeguduae.” ");
INSERT INTO ded_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Naso imohaingoc ngic goa yeneng Yesu siduc yofi ammigec, “Gariraiangic goa yeni sesenginaac yang Anutuac hosuc heimagec Piratongo deu ngicfora yeneng kemma yunuhomema sacngina imoc sesenginaac yang sawagoc meturanggegec.” ");
INSERT INTO ded_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ifi degec Yesungo yofi kpesiyemmeec, “Ngic homegec, yeneac kopocsicngo gariraiangic sasawa yeneac kopocsic ferahaecac ifi fingecyemmeec, ngeni imoc negensidae me? ");
INSERT INTO ded_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nga imoc kpac yombong. Ngeni ubangina mi merenggecdeu ngeni sasawango yeni homegec, ifi isocngoc homedacgecde, imoc edengunuduae. ");
INSERT INTO ded_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nga Siroang amaherecngo barackema ngicngac 18 witinginau mama yunuhomeec. Imocac ngeni dafi negensidae, yeneac kopocsicngo Yerusarennu ngicngac sasawa kecdae, yeneac ferahade me? ");
INSERT INTO ded_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Imoc kpac yombong. Nga ngeni ine ubangina mi merenggecdeu ngeni sasawango yeni homegec, ifi isocngoc homedacgecde, imoc edengunuduae.” ");
INSERT INTO ded_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Anu Yesungo yoac mong heima yofi edeyunuec, “Ngic mong ye fig ic mong waing uayau homeru nanec. Nanu ye kemma fora hofocma ");
INSERT INTO ded_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","waing uaac gareng edeec, ‘Ic yomocac fora hofocma kecbare kifa harebec bic ande nga ye nocac eng namma bangec kereha nedarude? Imocac ic imoc herecgema ukuna.’ ");
INSERT INTO ded_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ifi deu waing uagarengngo deec, ‘Kunenna, ge imoc wana kifa yomohai ifingoc nammanu haniau usuma bangec goa kerehagoc heikecbesare. ");
INSERT INTO ded_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ifi amba ngadeguc fora gombunga anude gedang. Nga fora mi anudeu ge naric herecgema ukubesena.’” ");
INSERT INTO ded_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabata naso monnu Yesungo kpekpeturang ama monnu emma kpoukpou ua meec. ");
INSERT INTO ded_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Meu ngac mong imohai tarec, ye hafeiac hadehade mongngo ngadea mendanggeu ngadehokuc kefu kifaya 18 bic anu naric mi kpehengaibac. ");
INSERT INTO ded_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nga Yesungo ye hemma yearu haudeac kpacma edeec, “Ngac negenna, ni hafeiga meickeba kpac ande.” ");
INSERT INTO ded_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ifi dema maria witiau faimanu ngac ye ngadea bic kpehengaima sorongaiu yacma namma Anutu dengereec. ");
INSERT INTO ded_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ifi anu kpekpeturang amaac gareng yeng ine Yesungo sabatau mengec mengere ua meecac herebu negemma ngicngac edeyunuec, “Uameme 6 fede, imohai ua mebesonga. Ifi anu ngeni naso imohai hagec mengerengunugecde nga sabata nasou ine kpac.” ");
INSERT INTO ded_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ifi deu Kebungo meremmiec, “Ikocngic, ngeni sasawa burumaka nga donggifocngina doku yemmegecdeac sabata nasou yungecyunugec, yeni amanginaunac magec meyunu kengandae, imocngo ngereede. ");
INSERT INTO ded_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nga ngac yomoc Abrahanggac naroannoc, ye ine Satangngo kifa 18 bic dzegeu kecmanu sabata nasou yungec yungera anude, imoc negenggec ifingoc ngereede.” ");
INSERT INTO ded_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesungo ngabafora turunga ifi merengyemmeu yeni gameyunudarec. Nga ngicngac tosea yeni ine faka engena sasawa meu henggec, imocac sogac sogai andacgec. ");
INSERT INTO ded_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Imocac Yesungo yofi deec, “Ni noc wiacfusing yoac heiba ngeni Anutuac eucererenggac siriha naric negentegecgecde? ");
INSERT INTO ded_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Imoc mastet gbomea isoc, ngic mongngo mastet gbomea mema uayau homeru yadima ic wegena anu sawau neng yeneng hama fawau faec heigec.” ");
INSERT INTO ded_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ifi dema Yesungo monggoc deec, “Anutuac eucerereng, imoc noc wiacfusing yoac heiba negenggecde, ");
INSERT INTO ded_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Imoc yis isoc, ngac mongngo farawa 20 kiroacsoc meu uuha yisgoc yerecgema meu hafoangoc yisagoc