﻿USE sofia;
DROP TABLE IF EXISTS sofia.dao_vpl;
CREATE TABLE dao_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dao_vpl WRITE;
INSERT INTO dao_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hin cun Davita capa, Abrahama capa, Jesuh Khritawa ksawn tähnak cajina kyaki. ");
INSERT INTO dao_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahama ca Isak, Isaka ca Jakop, acunüng Jakop naw Judah ja a bena he a jah canak. ");
INSERT INTO dao_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah naw Tamari am Pereh ja Sherah a jah canak, Pereh naw Heron ca na lü, acunüng Heron naw Ram a canak. ");
INSERT INTO dao_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rama ca Aminadap, Aminadapa ca Nashon, Nashona ca Salmon. ");
INSERT INTO dao_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon naw Rahap am Bozah a canak, Bozah naw Rutah am Obet a canak, Obet naw Jise a canak. ");
INSERT INTO dao_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jise naw Sangpuxang Davit a canak. Sangpuxang Davit naw Sangpuxang Solamon a canak, a nu cun Urijaa khyu Davit naw a khämbea kyaki. ");
INSERT INTO dao_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solamona ca Rehobawm, Rehobawma ca Abijah, Abijaha ca Asa. ");
INSERT INTO dao_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaa ca Jehosaphat, Jehosaphata ca Jehoram, Jehoram naw Usia a canak. ");
INSERT INTO dao_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiaa ca Jotham, Jothama ca Ahaz, Ahaza ca Hezakiha kyaki. ");
INSERT INTO dao_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezakiha ca Manaseh, Manaseha ca Amon, Amona ca Josiah. ");
INSERT INTO dao_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Isarel he jah man u lü Babalunga ami jah cehpüi, acun k'um üng Josiah naw Jekhonih ja a bena he a jah canak. ");
INSERT INTO dao_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babalunga ami jah cehpüi käna Jekhoniha ca Shaltilah, Shaltilaha ca Zerubabel. ");
INSERT INTO dao_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabela ca Abiud, Abiuda ca Eliakim, Eliakima ca Azora kyaki. ");
INSERT INTO dao_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azora ca Zadok, Zadoka ca Achim, Achima ca Eliud. ");
INSERT INTO dao_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda ca Elezar, Elezara ca Matthan, Matthana ca Jakopa kyaki. ");
INSERT INTO dao_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Acunüng Jakopa ca cun Josep, Mariha ceia kyaki, Marih cun Khritaw Mesijah ti Jesuha nua kyaki. ");
INSERT INTO dao_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham üngka naw Davit cäpa ksawn xaleikphyü lawki. Davit üngka naw Babalung mpya vaia ami jah cehpüi cäpa ksawn xaleikphyü lawki. Acunüng Babalung mpya üngka naw Messijah hmi law cäpa ksawn xaleikphyü lawki. ");
INSERT INTO dao_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesuh Khritaw a hmi lawa mawng cun hikbaa kyaki. A nu Marih cun Josepa khyu vaia ami mkhyäp käna, atänga am ani awm ham üng, Marih cun Ngmüimkhya Ngcim naw a mpyaisak. ");
INSERT INTO dao_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A cei vaia Josep cun khyang ngsungpyuna kya lü, khyang he maa Marih cun am luthui hmaiset hlüsak lü, ampyua hawih be khaia büki. ");
INSERT INTO dao_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Acunüngpi, acukba a ngaih k'um üng, a ngmang üng Bawipaa khankhawngsä ngdang vai lü, “Davita capa Josep, Marih na khyunak vai käh cäia. Isetiakyaküng a mpyai hin ta Ngmüimkhya Ngcima mpyaisak ni. ");
INSERT INTO dao_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ani cun kpamicaa ca khai, a khyang he ami mkhyekatnak üngkhyüh jah küikyan khaia kyase a ngming cun Jesuha na sui khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ahina mawng cun Bawipa naw Sahma he üngkhyüh a pyen khawi a kümnak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Pamhnama ngthu ta, “Teng ua, nglamica mpyai law lü, cangpyang ca na law khai, a ngming cun Imanuelaha sui law khai he,” ti hlü ta, “Pamhnam cun mi hlawnga awmki,” tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep cun ip lü a let law üng, Bawipa khankhawngsä naw a pyena kba Marih a khyunak. ");
INSERT INTO dao_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Acunüngpi, Josep ja Marih cun Marih a camah veia alanga am ip khawi ni. Josep naw hnasena ngming cun Jesuha a sui. ");
INSERT INTO dao_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sangpuxang Herod a Bawi kcün üng Jesuh cun Judah khaw Bethlehem mlüha hmi lawki. Acunüng nghngilawa ka khyang kthem he Jerusalem da lawki he. ");
INSERT INTO dao_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Hawia ni Judahea Sangpuxang vai hmi lawki hnasen cun. Ania aisi nghngilaw da lut lawki hmu u lü sawkhah khaia kami lawki he ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sangpuxang Herod naw acun ngja üng cäicing pyangmaki. Jerusalem mlüha awmkia khyang he naküt pi cäicing hngaki he. ");
INSERT INTO dao_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sangpuxang Herod naw, ktaiyü ngvai he ja thum mthei he jah mkhäm lü, “Khritaw hawia hmi khai ni?” ti lü a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Amimi naw, “Judah khaw, Bethlehema hmi khaia Sahma naw a yuk ni” ti lü ami pyen. ");
INSERT INTO dao_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Judah hne Bethlehem mlüh, Nang hin Judah mlühe üng na ngming ngthang khai ni. Nang üngka naw Bawi ngtüi law khai, ani naw ka khyang Isarel he lam jah msüm khai.” ");
INSERT INTO dao_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Acunüng, Herod naw khyang kthem he cun angmpyua jah khü lü, aisi angdang lawa kcün cun angsinga a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Acunüng, Herod naw Bethlehema jah tüih lü, “Cit u lü hnasen cun akdawa va sui ua. Nami hmuh üng na mtheh law be uki se, kei pi cit lü ka va sawkhah hnga khai” a ti. ");
INSERT INTO dao_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Acunüng cit u lü, nghngilaw da ami hmuh kunga aisi cun hmu betüki he. Ami hmuh üng jekyai tawngki he. Aisi cun ami maa cit lü hnasena awmnaka ngdang a pha üng ngdüiki. ");
INSERT INTO dao_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Im k'uma va lut u lü hnasen ja a nu Marih ami jah hmuh üng ngdäng u lü, hnasen kpamica cun sawkhahki he. Acunkäna ami lawpüia khawhthem he jah nghmawng u lü xüi, Frankisen ja Mura ng'ui he jah peki he. ");
INSERT INTO dao_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Acunkäna Sangpuxang Heroda awmnak lam da käh ami ceh be vaia, Pamhnam naw ami ngmang üng jah mtheh se, lam kce üng ami khyawngpe da cu cit beki he. ");
INSERT INTO dao_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Acun he ami ceh be käna, Bawipaa khankhawngsä mat law lü, Josepa ngmang üng, “Tho law lü, hnasen ja a nu Egypt pea jah cenpüia, ka ning jah mtheh law be vei cäpa acuia awm u, isetiüng ta Herod naw hnasen hnim khaia sui hüki ni” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Acuna mthan üng Josep cun tho law lü, naca ja a nu jah cehpüi lü Egypt pea dawngki. ");
INSERT INTO dao_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sangpuxang Herod a thih vei cäpa acuia awmki he. Ahlana Bawipa naw sahma üng a pyen “Egypt pea ka ca ka khü be ni” ti lü awmki cen kümcei lawnak vaia phäh ni. ");
INSERT INTO dao_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nghngilaw khyang kthem he naw mhleiki he ti Sangpuxang Herod naw a ksing law üng thüi law lü Bethlehem ja apeia awmki hnasen kpamica kum nghngiha kke üngka naküt a jah hnimsak. Acun cun khyang kthema veia a ksing aisi akcük a ngdang law üngkhyüh kum nghngih lawkia kya se, kum nghngih lawki Judah hnasen naküt a jah hnimsak. ");
INSERT INTO dao_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Acukba sahma Jeramih naw ahlana a na pyen law küm lawki ni. ");
INSERT INTO dao_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramah mlüha sünnak, mbawikyahnak ngja ve u. Rachel naw a ca kyahei ve; mhlawhmcah vai pi mah ve, a ca he thih päiha phäh ni” ti lü awmki. ");
INSERT INTO dao_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod a thih käna Bawipa khankhawngsä mat Josepa ngmang üng ngdang vai lü, ");
INSERT INTO dao_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Tho law lü, hnasen ja a nu Isarel pea jah cehpüi bea, hnasen hnim hlüki he thih päng ve u” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Acunüng, Josep cun tho law lü hnasen ja a nu jah cehpüi lü Isarel khyawngpe da cit beki. ");
INSERT INTO dao_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Acunüng, Sangpuxang Heroda capa Akhejah, a paa hnün üng Judah Bawia thawnki ni ti ngjak lü, Josep kyühei lü cit be damki. Pamhnam naw a ngmang üng a mtheha mäiha Kalile hneha cit lü acuia awmki. ");
INSERT INTO dao_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Acunüng, Nazaret mlüha im sa lü awmki. Sahma he naw ami na pyen, “Ani cun Nazaret khyanga sui khai he” ti a kümcei lawnak ni. ");
INSERT INTO dao_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Acun k'um üng Baptican Johan naw Judah khaw khawmkyang khawa law lü ngthu a pyen ta, ");
INSERT INTO dao_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nami mkhyekatnak üngka naw nghlat be hnüh ua. Isetiakyaküng Pamhnama khaw ng'et law ve” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ahin va sahma Hesajah naw a pyen, khawmkyang khawa khyang mat, “Bawipa lam cun pyan u lü, a lam he cen jah ngsungsak ua” ti lü ngpyangki. ");
INSERT INTO dao_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johan cun naw sanghngüksaüa mu am ami pyang kcu suisa lü, savun ksawmyüi vawp lü, mkhaü ja mawkpyawnga ka khawitui jah ei lü awmki. ");
INSERT INTO dao_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem, Judah hne alum ja Jordan mliktui peia ka khyang he cun a veia cit u lü, ");
INSERT INTO dao_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ami mkhyekatnak he jah phyah u se Jordan tui am Baptican a jah pet. ");
INSERT INTO dao_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pharise he ja Saduke he a veia Baptican kham khaia lawki he a jah hmuh üng, “Nangmi kphyu he, Pamhnama mlungso lawnak vai üngkhyüh nami lät khaia u naw a ning jah mtheh ni?” ");
INSERT INTO dao_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Acunakyase, akcanga nami ngjut a ngsing vaia nami ngtheipai am mdan ua. ");
INSERT INTO dao_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Abraham cun kami pu ania phäh mkhyekatnak üngka naw nami lät khaia käh ngai kawm uki, “Ngai ua, ning jah mtheh veng, Pamhnam cun hina lunge pi Abrahama ca he vaia jah pyang khawhki ni.” ");
INSERT INTO dao_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Acunakyase, akdawa am ngtheiki thing naküt cun jah khyu lü mei üng jah mkhih vaia, xäi cun thing phunga msäm päng ni. ");
INSERT INTO dao_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nangmi nami ngjut vaia kei naw tui am baptican ka ning jah peki. Cunsepi ka hnua lawki mat awmki, ani cun keia kthaka hlüngtai bawki, kei cun ania khawdawkyüi sut khaia pi am ka nglawiki ni. Ani naw Ngmüimkhya Ngcim la mei am baptican ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A hlawnga cang hjapnak vai kphya awmki ni, angtak he cun kheia jah ta lü, anghi he cun am thih theikia mei üng jah mkhih khai, a ti. ");
INSERT INTO dao_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Acunüng, Jesuh cun Kalile üngkhyüh Johana veia baptican khan khaia Jordan mliktui da lawki. ");
INSERT INTO dao_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Cunsepi, Johan naw a na mah lü, “Kei va nanga veia Baptican ka khan khai sü, ivaia ka veia ksaia na lawki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Acunüng pi, Jesuh naw msang lü, “Pamhnama ngjak hlü mi pawhkia kya lü ahikba kya se,” ti se, Johan naw kcangnaki. ");
INSERT INTO dao_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Baptican a khan päng ja, Jesuh tui üngka naw tho law beki. Acunüng khankhaw a vei da nghmawng law lü, Pamhnama Ngmüimkhya cun müma mäiha a khana ngaw law se Jesuh naw a hmuh. ");
INSERT INTO dao_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Acunüng, khankhaw üngka naw kthai pha lawki ta, “Hin cun ka mhläkphyanak kcanga ka capa ni, ani cun angläta ka jenak ni,” tia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Acunüng Jesuh cun Khawyai naw a hlawhlep vaia Ngmüimkhya naw khawmkyang khawa a cehpüi. ");
INSERT INTO dao_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesuh cun khawmhnüp kphyükip la mthan kphyükip ei jeih se, a ei cawi lawki. ");
INSERT INTO dao_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Acunüng Khawyai cun a veia law lü, “Nang Pamhnama caa na kya kcang üng, hina lung he hin muka thawn law khai hea jah mtheha” a ti. ");
INSERT INTO dao_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesuh naw “Khyang cun muk am xüngki am ni, cunüngpi Pamhnama ngthukhyü am va xüngki tia cangcim üng awmki” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Acunkäna Khawyai naw Jesuh cun Jerusalem Mlüh Ngcim, a hlüngnak säih Temple khana cehpüi lü, ");
INSERT INTO dao_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Nang Pamhnama capa kcang na ni üng, ahin üngka naw kco lü ‘Pamhnam naw a khankhawngsä he jah mtheh khai ni; acun he naw ami kut am ning na man khaie ni, acunüng na khaw naw lung he am jah hne yah khai ni’” ti lü cangcim üng awmki ni a ti. ");
INSERT INTO dao_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesuh naw, “Na Bawipa Pamhnam ä na hlawhlep vai ti lü pi cangcim üng ng'yuki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Acunkäna Khawyai naw Jesuh cun khawmcung k'hlüngnua khana cehpüi lü khawmdeka bawinak ja a hlüngtainak he cun a mhnüh. ");
INSERT INTO dao_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Khawyai naw, “Ngdäng lü na na sawkkhah üng ahin he avan ka ning pe khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesuh naw, “Satan akcea cita, na Pamhnam däk va sawkhah lü, ani däka khut va na pawh vai ti lü cangcim üng awmki” a ti. ");
INSERT INTO dao_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Acunkäna Khawyai naw ceh ta se, khankhawngsä he law u lü Jesuh cun kuei lawki he. ");
INSERT INTO dao_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Johan thawngim üng ami khyum a ngjak üng Jesuh cun Kalilea citki. ");
INSERT INTO dao_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret khaw ceh ta lü Zebulung ja Naptalih hne, Kalile tuilinu pei Kapenawm mlüha awmki. ");
INSERT INTO dao_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Acun cun sahma Hesajah naw a na pyen a kümceinak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mliktui da lamki lam läka awmki; Zebulung khaw la Naptalih khaw, Jordan mliktui yea, khyang mjükce hea venak Kalile, ");
INSERT INTO dao_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","nghmüp k'uma awmki hea khyang he naw akvai hmu khaie. Thihnak khaw nghmüp k'uma awmki hea khana akvai pha law khai ni” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Acun üngkhyüh tün lü Jesuh naw, “Ngjut ua, Khankhaw Pe ng'et law ve” ti lü ngthu pyenki. ");
INSERT INTO dao_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesuh Kalile tuili kama a ceh üng ngbengna xawi Sihmon (Pita ami ti) ja a na Andru ngaksui xawi, ng'üntui üng ngvai ani vawi k'um üng jah hmu lü, ");
INSERT INTO dao_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesuh naw, “Na läk law nia, nga nani suia mäiha kei naw khyang ksui ning ka ning jah mthei khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Acunüng ani ngvai jah hawih hüt ni lü Jesuh läki xawi. ");
INSERT INTO dao_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Acunkäna va cit betü lü ngbengna xawi Jakuk ja Johan, Zebedea ca xawi, ani pa mah am mlawng üng ani ngvai jah pyanei ni se jah hmu lü a jah khü. ");
INSERT INTO dao_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Acunüng akjanga ani mlawng ja ani pa jah hawih hüt ni lü Jesuh läki xawi. ");
INSERT INTO dao_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesuh cun Kalile pei avan üng cit hü lü, Sinakok k'uma jah mthei lü, Pamhnama Khawa thangkdaw jah mtheh lü am phetkiea natnak hlikhaü mjüküm üng khuikhaki he jah mdaw beki. ");
INSERT INTO dao_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesuh cun Siria hne abäng üng ngthang hü se, khyang kkun he, hlikhaü mjüküm naw a jah hui he, khawyaia a jah awmnak he, mcimpawm nawt lü ngtawng hüki he, akxo he a veia jah lawpüi u se a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kalile khaw üngka, Dekapoli khaw üngka, Jerusalem mlüh üngka, Judah khaw üngka, Jordan mliktui kam üngka, khyang khawhah naw Jesuha hnu läki he. ");
INSERT INTO dao_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesuh naw khyang pänu he a jah hmuh üng khawmcung khana cit lü ngaw se, axüisaw he a veia lawki he. ");
INSERT INTO dao_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Acunüng, a ngawhnak üngkhyüh hikba a jah mthei, ");
INSERT INTO dao_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ngmüimkhya lama mpyaki he ta ami josen ve, isetiüng ta Khankhaw Pe cun amimia phäh ni. ");
INSERT INTO dao_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Thüisei pukseki he ta ami josen ve, isetiüng Pamhnam naw mlung üpnak jah pe khai. ");
INSERT INTO dao_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mlung mhnemki he ta ami josen ve, isetiüng Pamhnama khyütam yahei khaie. ");
INSERT INTO dao_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ngsungpyunnak eia cawi lü tuiha xaiki he ta ami josen ve, isetiüng ami ngjak hlü kümbe law khai. ");
INSERT INTO dao_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Khyang mpyeneinak taki he ta ami josen ve, isetiüng Pamhnama mpyeneinak yah be khaie. ");
INSERT INTO dao_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ami mlungkaw ngcingcaihki he ta ami josen ve, isetiüng Pamhnam hmu acun he. ");
INSERT INTO dao_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Dimdeihnak pyangki he ta ami josen ve, isetiüng Pamhnam naw ka ca he tia jah khü khai. ");
INSERT INTO dao_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pamhnama ngjak hlü ami bilawha phäh mkhuimkhanak khameiki he ta ami josen ve, isetiüng Khankhaw Pe cun ami kaa kyaki. ");
INSERT INTO dao_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ka hnukläka nami thawna phäh, khyang he naw ning jah mkhuimkha, ksekha na u lü ami ning jah mhleimhlakei üng ta jekyai ua. ");
INSERT INTO dao_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Isetiüng ta, khankhawa aphu nami yah vai khawhah awmki he kyase, jekyai lü xexawk na ua. Acukba bäa sahma he pi ahlana jah na mkhuimkha khawikie ni. ");
INSERT INTO dao_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nangmi cun khawmdek khyang mjü naküta phäh, mcia nami kyaki. Acunüngpi mci a tuinak apäih üng i am tuisak be vai ni? Xawtin u lü khyang he naw ami khaw am ami leh sawxata thea ia am daw. ");
INSERT INTO dao_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nangmi cun khawmdek lum vaisaki akvaia nami kyaki he ni. Mcunga mdüiha mlühnu pi am ngthup thei. ");
INSERT INTO dao_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“U naw meiim dawn üng am khüp khawi, khukhawng khana va ta lü im k'um avan üng vai hü khaia tak khawia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Acuna kba ni, khyang hea maa nami vainak cun vaisak ua. Khyang he naw nami khut pawh ja nami awmih dawki ti hmu u lü, khana nami Pa mhlünmtai law khaie. ");
INSERT INTO dao_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mosia Thum la Pamhnama sahma hea pyen jah nawt khaia ka lawkia ä ngai ua, acun he jah kümceisak khaia ka lawki ni. ");
INSERT INTO dao_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngai ua, akcanga ka ning jah mthehki, khawmdek la khankhaw khyük ni lü pi Thum üngka canglung matca pi akümkawi kaa am khyük yah khai ni. ");
INSERT INTO dao_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Acunakyase, au pi ahina ngthupet üngka matca pi am läklam lü jah mtheiki cun khankhawa akdik säiha kyak khai, cunüngpi läklam lü jah mtheiki cun khankhawa khyang k'hlüngtaia kyak khai. ");
INSERT INTO dao_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ka ning jah mtheh betüki ngai ua, Pharise he la thum mthei he kthaka nami ngsungpyun bawk üng ni khankhaw nami pha kawm. ");
INSERT INTO dao_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ahlana ami pyen khawi cun, khyang käh nami hnim vai, au pi khyang hnimki cun ngthumkhyahnak kham khai” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Acunüng pi tuh ka ning jah mthehki: a bena thüinaki cun ngthumkhyahnak khamei khai. Au pi a bena üng ia am mawngmei veki a ti üng, kawngci maa ngdüi khai. Acunüng na bena üng ak'yaw tinaki naküt cun am dim khawhkia Mulai meia cit khai. ");
INSERT INTO dao_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Acunakyase, Pamhnama kpyawngkunga khawthem pet vaia na lawpüi k'um üng, na bena naw am a ning jenak na süm üng ta, ");
INSERT INTO dao_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Na lawpüia khawhthem cun kpyawngkunga hawih hüt lü, akcüka na bena veia cit lü va ng'yäppüi be maa. Acun käna law be lü na pet vaia khawhthem cun Pamhnam üng pe kawpi. ");
INSERT INTO dao_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ning khya hlüki am lama nani ceh yüm üng angxita na ng'yäppüi vai. Am ani üng ta ngthumkhyah mkhawng üng ning kkhya se, acun he naw palik he üng ning ap se amimi naw thawngim üng ning khyum khaie ni. ");
INSERT INTO dao_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Akcanga ka ning jah mthehki, tangka na tak naküt üng am na ngthawng bea küt üng am lät be theiki. ");
INSERT INTO dao_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Khyanga khyuca am käh nami mkhyekat vai ti nami ngja khawiki, ");
INSERT INTO dao_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kei naw ka ning jah mtheh hlü ta: au pi nghnumi mkhyekat hlünaka mlungmthin am tengki naküt cun a mlung k'uma mkhyekat pängki ni. ");
INSERT INTO dao_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Acunakyase na kkhet mik naw a ning mkhyekatsak üng, kawihin lü xawtina. Isetiüng na pumsa avan küm se mulaia na ceha kdama ta na pumsa üngka mat khyük se na awm hin daw bawki ni. ");
INSERT INTO dao_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na khet kut naw a ning mkhyekatsak üng, kyükin lü xawtin kawpi. Isetiüng na pumsa avan küm se mulaia na ceha kdama ta na pumsa üngka mat khyük se na awm hin daw bawki ni. ");
INSERT INTO dao_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Acunkäna ami na pyen khawi nami ngjak khawi ta, “Aupi a khyu hawih lü ngtainaka kca yuk lü pe yah khai, ti lü Mosia thum üng awmki.” ");
INSERT INTO dao_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Acunüng pi kei naw ka ning jah mtheh hlü ta: au pi a khyu kpami kcea dä am ipawm ni se akcea phäh hawihki cun a khyu mkhyekatsaki ni. Acuna thea acuna nghnumi khyu na beki pi mkhyekatkia kyaki ni. ");
INSERT INTO dao_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Na bekhüt käh na lümkan vai, Pamhnama veia bekhüt na taka mäiha na pawh vai” ti nami ngja khawiki. ");
INSERT INTO dao_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Cunüngpi kei naw ka ning jah mtheh hlü ta: khankhaw be lü käh nami ng'yünce süm vai. Isetiüng khankhaw cun Mhnama a bawi ngawhnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Khawmdek pi be lü käh nami ng'yünce vai. Isetiüng khawmdek cun Pamhnama khaw taknaka kyaki. Jerusalem be u lü pi käh nami ng'yünce vai. Isetiüng Jerusalem cun Sangpuxang Bawia mlüha kyaki. ");
INSERT INTO dao_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na lu be lü käh na ng'yünce vai. Isetiüng na lusam matca pi abawk ja alea am pyang khawhki. ");
INSERT INTO dao_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Acunakyase ‘Ä’ am ani üng ‘Ka’ nami ti vai. Ahina thea nami pyen cun khawyaiksea a ning jah pyensaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mik vanga phäh mik vang, ha mata phäh ha mat phusui vai ti nami ngja khawiki. ");
INSERT INTO dao_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Acunüngpi kei naw ka ning jah mtheh hlü ta: ning jah mkhyekatnaki käh thungei be ua. Nami khet ngbeng ning jah kbeiki üng nami kcawng ngbeng pi jah säng petsih vai. ");
INSERT INTO dao_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Khyang mat naw nami kcu ning jah hut hlü lü junga a ning jah ngcuhpüi üng ta, na jih pi na petsih vai. ");
INSERT INTO dao_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“Khyang naw mäng mat a phüih a ning phüih hlüsak üng ta, mäng nghngih na phüih pet vai. ");
INSERT INTO dao_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Nami ka ning jah täeiki üng nami pet vai. Acunüng nami veia pu hlüki a awm üng nami kpu vai. ");
INSERT INTO dao_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Na püi mhläkphya na lü na ye na hneng vai ti nami ngja khawiki.” ");
INSERT INTO dao_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Acunüng pi kei naw ka ning jah mtheh hlü ta: na ye na mhläkphyanak vai, ning mkhuimkhaki ktaiyü pea. ");
INSERT INTO dao_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Acunüng ta khankhawa ka nami pa Pamhnama ca hea nami kya khai. Isetiüng Pamhnam naw khyang kse he ja khyang kdaw hea khana khawhngi angteha sosak lü, khyang ngsungpyun ja am ngsungpyunki hea khana pi khaw angteha aksaki ni. ");
INSERT INTO dao_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ning jah mhläkphyanaki däk nami mhläkphyanak be üng ta aphu i nami yah khai ni? Akhawn mkhäm he naw pi acukba ta pawh khawhki he ni? ");
INSERT INTO dao_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na püi he däk am na ngthuminei üng khyang kce he kthaka i na pawhki ni? Pamhnam am ksingki he naw pi acukba ta am pawh khawhki he aw? ");
INSERT INTO dao_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Acunakyase, nami pa khana ka a kümkawia mäiha nangmi pi kümkawi ua.” ");
INSERT INTO dao_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Khyang hea maa, khyang he hmuha käh nami petmsawt vai. Khyanga hmuha nami bilawh üng ta khana ka nami pa naw aphu ning jah pe khaia am kya. ");
INSERT INTO dao_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Acunakyase msih mpyaki he üng nami jah petmsawt üng angdang käh nami pet vai. Ngpumim ja lama khyanga jah hmuh hmuha khyanga jah mhlünmtai vai hlawheikie hypocrite kba käh nami pawh vai. Ka ning jah mthehki, acun he cun ami ngkhengnak yah pängki he ni. ");
INSERT INTO dao_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Cunüngpi na petmsawt üng na kut vang naw a pet cen na kut vang naw käh ksing se. ");
INSERT INTO dao_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na petmsawt üng anghmüa nami petmsawt vai. Acunüng, angthupa ka pi hmuh theiki nami pa naw angdanga ning jah kheng khai. ");
INSERT INTO dao_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nami ktaiyü üng hypocritea kba käh ktaiyü ua! Amimi cun naw Sinakok ja lam kyuma khyanga hmuh vaia ngdüi hü u lü ktaiyüki he ni. Ka ning jah mthehki, acun he cun naw ngkhengnak yah pängki he ni. ");
INSERT INTO dao_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Acunüngpi, na ktaiyü üng na im k'um ahinaka lut lü ksawh na khaih käna, ahawia pi ve lü am hmuh theia na Pamhnama veia na ktaiyü üng ning pe khai. ");
INSERT INTO dao_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nami ktaiyü üng am jumeikia khyang he naw ami pyen kce ami pyen be bea kba käh nami ktaiyü vai. Ami ktaiyü a saüa phäh ami mhname naw jah ngjak khaia ngaieikie. ");
INSERT INTO dao_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Acun he mäiha käh nami ve vai. Isetiüng ta i nami hlüki ti cun nami pa naw am nami tä ham üng a ksing päng ni. ");
INSERT INTO dao_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Acunakyase, hikba nami ktaiyü vai: Khana vekia kami pa, na ngming ngcim naw leisawngnak yah se. ");
INSERT INTO dao_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na khaw pha law se; Na hlüei khankhawa ami pawha kba khawmdeka pi pawh u se. ");
INSERT INTO dao_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tuhngawi kami ei khyawh vai ei jah pe bä. ");
INSERT INTO dao_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kami khana mkhyekatki he kami jah mhläta kba, kami mkhyekatnak pi jah mhlät bä. ");
INSERT INTO dao_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mkhyekat vaia hlawhlepnaka käh jah cehpüi lü, Khawyaipaa kut üngkhyüh pi jah yung kawpi.Khaw ni, johit ja hlüngtainak he cun na kaa kya se. Amen. ");
INSERT INTO dao_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Khyang hea ami ning jah mkhyekatnak nami jah mhlät üng khankhawa ka nami pa naw pi nangmia mkhyekatnak pi ning jah mhlät khai. ");
INSERT INTO dao_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Acunüng pi khyang hea ami mkhyekatnak am nami jah mhlät üng, khana ka nami pa naw pi nami mkhyenak am ning jah mhlät khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ei nami jeih üng hypocrit hea kba pukseki hea mäiha nami hmai käh nami tak vai. Khyang he naw ei jeihki he ti ami jah ksing vaia ami hmai hngasaki he ni. Akcanga ka ning jah mtheh hlüki. Acun he cun ami ngkhengnak yah pängki he ni. ");
INSERT INTO dao_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ei nami jeih üng nami lu ksi am hluk u lü mthik lü nami hmaiei vai. ");
INSERT INTO dao_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Acunüng, khyang he naw ei nami jeih am ksing u. Nami pa angthupnaka ve lü angthup hmuh theiki däk naw angdanga ning jah khyeng khai. ");
INSERT INTO dao_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mthiek ja mkhyaa ei thei ja, mpyukei hea kpyeh thei, khawmdek khana khawhthem käh mcun ua. ");
INSERT INTO dao_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mthiek ja mkhyaa am a ei thei ja mpyukei hea am ami kpyeh thei khankhaw khawh mcun ua. ");
INSERT INTO dao_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Isetiüng ta, khawhthem nami taknaka nami mlungmthin, nami ngainak ve khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mik cun pumsa akvai ni. Acunakyase na mik a daw üng, na pumsa avan vai khai. ");
INSERT INTO dao_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Acunüng pi, na mik a mü üng ta na pumsa avan nghmüp päihki ni. Acunakyase, na pumsa k'uma veki akvai hin anghmüp ani üng ihlawka kyühkse khai aw? ");
INSERT INTO dao_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","U naw pi bawi nghngiha khut am pawh khawh. Bawi mat kphya na lü; bawi mat hneng khai. Am ani üng mata pyen ngai lü, mat ksekha na khai. Nangmi pi Pamhnam ja ngui xüi ani nghngiha khut am jah mkhyawp khawh uki. ");
INSERT INTO dao_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Acunakyase, ka ning jah mtheh hlü ta, i ka ei khai, i ka aw khai, i ka suisak khai ti lü nami pumsaa phäh käh cäicing ua. Sak hin eiawka kthaka am phumah bawki aw? Pumsa hin suisaka kthaka am phumah bawki aw? ");
INSERT INTO dao_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Khana kha he jah teng ua: mci am saw u, cang am at u, kheia pi am mcunei u. Cunüngpi nami pa khana ka naw jah mcahki ni! Kha hea kthak nami phumah bawkie am niki aw? ");
INSERT INTO dao_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Acun he nami cäicingnaka phäh a khawkum apica saülawki veki aw? ");
INSERT INTO dao_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Acunakyase, ivaia suisaka phäha nami cäicingki he ni? Mawkpyawnga ka he lili khyeipai he cen jah teng süm ua, ami suisak vai am khüi na u, nghmüi pi am bi u. ");
INSERT INTO dao_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ka ning jah mthehki, Sangpuxang Solamona a khawhkhyam naküt naw khyeipai matcaa ngtongtai pi am kpha. ");
INSERT INTO dao_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nami jumnak ngceki he aw, tuhngawi xüng lü angawi üng thikia khyeipai he pi Pamhnam naw a jah ngtongtaisak üng ta, acuna kthaka daw bawkia ning jah msuimsak khai ni. ");
INSERT INTO dao_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Acunakyase, i kami ei khai, i kami aw khai, i kami suisak khai? ti lü ä cäicing ua. ");
INSERT INTO dao_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Ahin he cun Pamhnam am ksingki he naw ni ami suihjap khawi.) Nangmi cun khana ka nami pa naw nami hlükaw naküt cun ksingki. ");
INSERT INTO dao_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Akcüka Pamhnama khaw ja a hlüei sui ma ua, acun käna ahin he avan ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Acunakyase, khawngawia phäha käh cäicing ua, khawngawi amäta phäh cäicingei khai ni. Tuhngawi na cäicingnak hin tuhngawia phäha khäk ve. ");
INSERT INTO dao_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Pamhnama ngthumkhyahnak üngka naw nami lät vaia khyanga lei käh nami mtai vai. ");
INSERT INTO dao_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Khyang nami mtainak am khyang naw ning jah mtai be lü, khyang nami mcäpnak am khyang naw ning jah mcäp pet be khai. ");
INSERT INTO dao_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ivaia na mik üng cungbäng veki am hmuhei lü, na püia mik üngka mikbengca na hmuh petki ni? ");
INSERT INTO dao_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ihawkba na mik üng cungbäng am hmuhei lü, na püi üng “Na mik ek ning lawh pe vang” na tiki ni? ");
INSERT INTO dao_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hypocrite aw, akcüka na mik üngka cungbäng loei maki lü, acunkäna na püia mik ek na lawh pet vaia angtea na hmuh khai. ");
INSERT INTO dao_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ui am angcimcaih käh nami pet vai, nghlat lü ning jah cui khaie. Pale Lunge vawk üng käh nami jah pet vai, ami kainaka thea ning jah nghlatsih u lü ning jah cui khaie ni. ");
INSERT INTO dao_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tä ua nami yah khai; sui ua nami hmuh khai; ksawh khawk ua, ning jah nghmawn pet khai ni. ");
INSERT INTO dao_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Au pi täki naw yahki, suiki naw hmuki, ksawh khawki üng nghmawn pet khai ni. ");
INSERT INTO dao_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nangmi üng a ca naw muk tä se lung pe khai u veki ni? ");
INSERT INTO dao_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nami ca naw nga tä se kphyu pe khai u veki ni? ");
INSERT INTO dao_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nangmi khyang ksee naw pi nami ca üng akdaw pet vai nami ksing üng, nami pa khana ka naw täki üng nangmia kthaka dawki pe khai aw? ");
INSERT INTO dao_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Namimäta khana khyang naw a pawh vai nami ngjak hlüa mäiha, namimät naw pi khyanga khana nami pawh vai. Acun cun Mosia thum ja sahma he naw jah mtheh pängki he ni. ");
INSERT INTO dao_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mkawt kdik üng lut ua, isetiüng ta mulaia cehnak lam cun ngbaü lü ceh pi jäkia kyase khyang khawkäna cehnak lam ni. ");
INSERT INTO dao_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mkawt kdik cun khak lü, xünnaka lama kya se, cetkia khyang ngcekie. ");
INSERT INTO dao_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Pamhnama sahma mäiha nghmüneikie nami jah yeteinak vai, toa vun büng u lü, nami veia law kyawkie, ak'uma mhngea kyaki he. ");
INSERT INTO dao_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Acun he cun ami ngtheipai am nami jah ksing khai. Nghling thing capyita ngthei khawiki aw? Nghling thing üng fik ngthei khawiki aw? ");
INSERT INTO dao_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Acuna mäiha thing kdaw naküt naw kthei kdaw ktheih na lü, thing kse naküt naw kthei ksea ngtheiki. ");
INSERT INTO dao_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Thing kdaw cun ktheih ksea am ngthei, thing kse naw pi ktheih kdaw am kthei na khawi. ");
INSERT INTO dao_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aktheih am dawki thing naküt cun khyu u lü, mei üng ami xawtin khawi. ");
INSERT INTO dao_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Acunakyase, sahma ksee cun ami kthei am nami jah ksing khai. ");
INSERT INTO dao_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Bawipa, Bawipa ti lü na khüki naküt khankhaw pha khaie am ni, ka pa khana kaa hlüei pawhki va khankhaw pha khai. ");
INSERT INTO dao_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ngthumkhyahnaka mhnüp üng, “Bawipa, Bawipa, na ngming üng Pamhnam ngthu pyen lü, na ngming üng khawyame jah ksät lü, müncanksee kami jah pawhki am niki aw? ti law khaie. ");
INSERT INTO dao_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Acunüng kei naw, “Nangmi am ning jah ksing khawi nawng, khyang ksee, ka vei üngka naw cit ua” ka ti khai. ");
INSERT INTO dao_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Acunakyase, au pi ka pyen ngja lü ka pyena mäiha veki cun lunga khana im saki khyang kthem üng tängki ni. ");
INSERT INTO dao_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Khaw a law lü tui däm law sepi, khawkhi naw buh law lü pi, isüm am kyu. Isetiüng ta lunga khana saka kyase am kyu thei. ");
INSERT INTO dao_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Cunüngpi ka jah pyene jah ngja lü ka pyena mäiha am veki cun mdiha khana im sakia khyang nghmawng üng tängki ni. ");
INSERT INTO dao_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Khaw ngkyawi law lü, tui kdäm naw ceh khai, khawkhi naw buk law se mdiha khana im cun kyu lü pyüpye theiki ni. ");
INSERT INTO dao_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesuh naw acukba a pyen käna khyangpäe naw a jah mtheimthang cun müncan na lawki he. ");
INSERT INTO dao_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Isetiüng ta, Jesuh cun thum mthei hea mäih am ni, khyaihbahnak takia mäiha a jah mtheimthanga phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesuh mcunga khyüh a kyum law be üng khyangpänue naw läk lawki he. ");
INSERT INTO dao_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Acunüng, mnehkse mnehki mat naw Jesuha vei law lü, “Bawipa aw, na hlüei üng ta na ngcimcaihsak bea” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesuh naw a kut am do lü hnetki naw, “Ka hlüeiki ni, ngcim se” a ti ja a mnehkse cun daw beki. ");
INSERT INTO dao_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Acunkäna Jesuh naw mtheh lü, “U üng pi käh mtheh bä, cet ktäi lü ktaiyü üng na pumsa va mhnuha. Khyang hea ksing law vaia Mosia thuma kba ngkengtaihnak na pawh vai” a ti. ");
INSERT INTO dao_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesuh Kapenawm mlüha a vang üng, yekap ngvai mat law lü Jesuh nghui naki naw, ");
INSERT INTO dao_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bawipa aw, ka mpya kun lü ima thih law hlü ngsai lü ngjän ve” ti lü a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesuh naw, “Law lü ka mdaw law be khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yekap ngvai naw, “Bawipa aw, na lawnak vaia ka im am nglawingkawih naw. Ngthu mkhap matca na pyen üng ka mpya daw be khai ni. ");
INSERT INTO dao_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Angvai säiha kea ka veki ni. Keia kea pi yekap khawhah veki. Mat üng cita ka ti üng, cit lü; mat betü lawa ka ti üng, lawki, ka mpya mat “Hin pawha” ka ti üng, pawhki ni. ");
INSERT INTO dao_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesuh naw acun a ngjak üng mküiei law lü axüisaw hea üng, “Akcanga ka ning jah mthehki, ahikba sena jumnak ta Isarele üng pi am hmuh khawi nawng” a ti. ");
INSERT INTO dao_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ka ning jah mtheh hlüki, nghngilaw ja khawkyaka kae khawkän law hü u lü Abraham, Isak ja, Jakop am alanga Khankhaw Pe pawia ngaw yüm khaie ni. ");
INSERT INTO dao_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Acunüngpi Khawmahe ta kpunga anghmüpnaka jah xawt u se, acuia mni cui ha kyet üng kyap khaie. ");
INSERT INTO dao_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Acunkäna Jesuh naw yekap ngvai üng “Na ima cit bea, na jumeia mäiha thawn se” a ti. Acuna kcün bäbä üng a mpya cun yai beki. ");
INSERT INTO dao_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Acunkäna Jesuh Pitaa ima law lü, Pitaa khyua nu mhnat lü ngjän se a hmuh. ");
INSERT INTO dao_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesuh naw Pita a pi cun a kut üng hnet se mhnat naw a khyah. Acun ja Pitaa pi naw tho law lü a jah khinnak. ");
INSERT INTO dao_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Khawmü lama khyang he khawyai naw a jah venake khawhah Jesuha veia jah lawpüi u se Jesuh naw ngmüimkhya ksee cun ngthu mkhap mat am jah ksät lü, am phetkie pi avan a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Acun cun sahma Hesajah naw ahlana a na pyen, “Amät naw mi mhnatnake jah lawh pe lü, mi hlikhaü naküt jah phüih pe ve” ti a kümnak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesuh naw a peia khyang khawhah a jah hmuh üng, tuili caye kama va pek khai hea a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Thum mthei mat a veia law lü, “Saja aw, na cehnak naküta ka ning läk khai” a ti. ");
INSERT INTO dao_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesuh naw, “Sauie naw khui taki he, khana khae naw pi ngbu taki he. Cunsepi khyanga capa naw ta a hüieinak vai hnün am ve ve” a ti. ");
INSERT INTO dao_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Axüisawe üngka mat naw, “Bawipa aw, cit be lü ka pa va k'ut ma vang” a ti. ");
INSERT INTO dao_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesuh naw, “Na läk lawa, akthie naw akthi k'ut u se” ti lü a mtheh. ");
INSERT INTO dao_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesuh mlawnga khana a kai üng, axüisaw he ahlawnga cit hngakie. ");
INSERT INTO dao_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tuilia khawkhi ksenu khi law lü, mlawng tui üng lut law hlüki. Acunüngpi Jesuh ta ipeiki. ");
INSERT INTO dao_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Axüisawe a vei law u lü, “Bawipa aw, ngcum law hlü ve u üng jah yung lawa,” ti lü, ami mhlet. ");
INSERT INTO dao_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesuh naw, “Aw, jumeinak ngcekia khyang he aw, ivaia nami kyükyawkie ni?” a ti. Acunkäna tho law lü khawkhi ja tuingnawk cun hüp khai xawia jah mtheh se, dipki xawi. ");
INSERT INTO dao_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","“Khawkhi ja tuingnawk naw pi a pyen ngjaki xawi ta ia khyang ni? ti lü avan müncan tawngkie. ");
INSERT INTO dao_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesuh tuilia caye Kadaja hnea a law üng, khawyai naw a jah umnak khyang nghngih cun jah kyüh u lü, u naw pi am a cehnak data lam, lungdü üngka naw acuna khyang nghngih cun thäng law ni se a jah khyum. ");
INSERT INTO dao_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Acun xawi naw, “Keini üng i na hlüeiki, Pamhnama capa aw? Akcün am pha ham se na jah mkhuimkha khaia na lawki aw?” ti lü ngpyangki xawi. ");
INSERT INTO dao_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Acuna peia vawke ngsuieikie awmki he. ");
INSERT INTO dao_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yaie naw Jesuh aw, “Keimi na jah ksät a ni üng pi vawkea k'uma bä jah tüiha” ti lü nghuikie. ");
INSERT INTO dao_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesuh naw, “Cit ua” ti se, yaie cun lut law u lü, vawkea k’uma lutkie. Acunüng vawke avan xema ngtäng lü tui üng ngcum lü, thih päihkie. ");
INSERT INTO dao_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vawk mcahkie naw mlüh k'uma dawng u lü yaia a umnaka khyang nghngih ja vawkea thiha mawng avan cun ami va pyen. ");
INSERT INTO dao_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Acunüng mlüh üng veki avan Jesuh hmuh khaia law u lü, Jesuh ami hmuh üng ami khaw ceh ta lü akcea cit khaia nghuinakie. ");
INSERT INTO dao_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesuh cun mlawnga khana kai lü, Kalile tuili leh pah lü a venak Kapenawm mlüha cit beki. ");
INSERT INTO dao_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Acuia a kut khaw xoki khyang mat cun kyäp üng a ngjännak üng Jesuha veia ami kawh law. Jesuh naw ami jumnak hmuh lü, “Ka ca aw, käh ng'äa, na mkhyekatnake cun mhlät päng ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Acunüng thum mthei he akhäk naw ami mlung k’uma, “Hin naw Pamhnam ksekha na ve” ti lü ngaikie. ");
INSERT INTO dao_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Acunüng pi Jesuh naw ami mlung k’uma ami ngaih jah ksing lü, “Ivai am dawkia nami ngaikie ni?” ");
INSERT INTO dao_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","A kut khaw xoki üng, “Na mkhyekatnake cun mhlät päng ni, ti mä ajä? am ani üng “Tho law lü cita” ti mä ajä?” ");
INSERT INTO dao_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Khyanga capa naw khawmdek khana mkhyekatnake jah mhlätnaka johit taki ti nami ksing vaia, ti lü, akxo üng, “Tho law lü, na ngjännak phak lo lü na ima cit bea” a ti. ");
INSERT INTO dao_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Akxo cun tho law lü a im da cit beki. ");
INSERT INTO dao_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Khyang he naw ami hmuh üng cäi law u lü, acukba khyang üng akdaw pekia Pamhnam cun mhlünmtaikie. ");
INSERT INTO dao_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Acuna hnün ceh ta lü Jesuh a ceh hü üng, Mahte ngming naki khyang mat, ngcawn ngcawnaka im üng a na ngaw se hmuh lü, “Na läk lawa,” ti se, Mahte naw tho law lü Jesuh läki. ");
INSERT INTO dao_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesuh naw Mahtea ima buh a ei k’um üng, ngcawng nglawke ja mdimei khyang he law u lü Jesuh ja axüisaw hea hlawnga ngaw law hngakie. ");
INSERT INTO dao_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharise he avang naw hmuh u lü axüisaw hea üng, “Ivai nami saja ngcawn nglawke ja mdimei khyang hea dä ei yümkie ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesuh naw ngja lü, “Khyang kphete naw dawkta am hlü u, khyang kune naw ni dawkta ami hlü. ");
INSERT INTO dao_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Keia hlüei ta mpyeneinak ni, khyüngsei am ngkengtaihnak am ni,” ti hin i a ti hlünak ni? Cit u lü va ngthei ua. Isetiüng ta “Khyang ngsungpyune jah khü khaia ka lawki am ni, mdimei khyang he jah khü khaia ni ka law.” ");
INSERT INTO dao_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Acunüng Baptican Johana hnukläke Jesuh veia law u lü, “Ise keimi ja Pharise he ahüt hüt üng ei jeih u üng se nanga na hnukläke ei am jeih khawikie ni?” ti lü Jesuh ami kthäh u. ");
INSERT INTO dao_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesuh naw, “Khine cun Cambumkia hlawnga ami vea küt üng, a khine ei kaa ve khai hea nami ngaikie aw? Am ve u! Acunsepi cambumki a khine am ami ngkya lawa mhnüp pha law khai, acunüng amimi naw ei jeih khaie ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","U naw suisak kphyüm akthai am am bu khawi. Acukba ami bu üng akthai naw akphyüm ei päk se angbaüa päk law dämdäm khai. ");
INSERT INTO dao_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Acuna kba ni, u naw awi kphyüm üng capyit tui sü am than khawi u. Acukba ami than üng awi se law lü capyit tui sü ngsawi päih lü, awi pi pye khai. Capyit tui sü cun awi kthai üng ni ami than khawi. Acukba ami than üng va ani nghngih am pye thei ni. ");
INSERT INTO dao_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Acukba ngthu a pyen k'um üng, Judah ngvai mat Jesuh veia law lü a mkhuk am ngdängki naw, “Ka canu tuh hi thi ve. Acunüngpi law lü, na kut a khana na taih law üng ta xüng law be khai ni” ti lü, a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Acunüng Jesuh naw tho law lü läk se axüisaw he naw pi läk hngakie. ");
INSERT INTO dao_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nghnumi mat, khawkum xaleinghngih a thi put lü khuikhaki Jesuha hnua law lü, a kcu mdawngca a hneh. ");
INSERT INTO dao_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Acuna nghnumi naw, “A suisak mdawngca hleng ka hneh üng ta ka daw be khai ni” ti lü ngaieiki. ");
INSERT INTO dao_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesuh naw nghlat law lü ani a hmuh üng, “Ka canu aw, käh cäia. Na jumeinak naw ning mdaw be ve,” ti se, acunja nghnumi cun daw beki. ");
INSERT INTO dao_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Acunüng Jesuh Judah ngvaia ima va lutki. Yawk kcing tumkie ja kyahkie a jah hmuh vai üng, ");
INSERT INTO dao_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Avan kpunga cit ua! Ahina nghnumica thiki am ni ipki ni” ti se, acun he naw ami yaihei. ");
INSERT INTO dao_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cunüngpi khyang he kpunga ami va luh ja, Jesuh nghnumicaa venak im k’uma lut lü a kut üng kaih se tho law beki. ");
INSERT INTO dao_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Acuna mawng cun khaw lum üng ngthang hüki. ");
INSERT INTO dao_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesuh acun üngka naw a va ceh üng, amikmü nghngih naw läk ni lü, “Aw, Davita capa jah mpyeneia” ti lü ngpyangki xawi. ");
INSERT INTO dao_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesuh ima k’uma a luh üng, amikmü xawi a veia law ni se, Jesuh naw “Kei naw ka ning jah mdaw be khawh khai ti nami jumki aw” ti se, “Bawipa aw, kani jumki ni” ani ti. ");
INSERT INTO dao_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Acunüng Jesuh naw ani mik jah hne lü, “Nani jumeia mäiha thawn se” a ti. ");
INSERT INTO dao_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Acunja ani mik vai law be se Jesuh naw, “U üng pi käh nani mtheh vai” ti lü a jah ksük. ");
INSERT INTO dao_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Acunüngpi ani va ceh jah Jesuha mawng cun khaw avan üng ani sang hü. ");
INSERT INTO dao_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Acun üngka naw ami va ceh üng, khawyaia venak ak’ang khyang mat Jesuha veia ami lawpüi u. ");
INSERT INTO dao_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesuh naw khawyai a ksät käna acuna khyang ngthuhei law be thei se, khyang he naw “Hina mäih Isarele üng am mi hmuh khawi” ti lü müncannakie. ");
INSERT INTO dao_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Acunsepi pharisee naw, “Hin naw khawyaiea ngvai naw a peta johit am khawyaie jah ksät ve” ti lü pyeneikie. ");
INSERT INTO dao_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesuh mlühe naküt, ngname naküt üng cit hüki. Sinakoka k’uma jah mthei hü lü, Pamhnama khawa mawng thangkdaw pyen hüki. Am phetkie ja hlikhaü mjüküm naw a jah pawhe naküt jah mdaw beki. ");
INSERT INTO dao_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesuh naw khyang päe, toksäm am ve se khuikhakia toca hea mäih a jah hmuh üng aktäa jah mpyeneiki. ");
INSERT INTO dao_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Acunüng Jesuh naw axüisaw hea üng, “Cang hmin lü da sepi, at lü mkhäm khai ngcek ve,” ");
INSERT INTO dao_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cangmah naw cang at khai khawhah a tüih law vaia cangmaha veia ktaiyü ua” a ti. ");
INSERT INTO dao_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesuh naw axüisaw xaleinghngih jah khü lü ngmüimkhya ksee jah ksätnak, am phetkie naküt ja natnak naküt jah mdawnak be khawha johit a jah pet. ");
INSERT INTO dao_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Axüisaw xaleinghngihea ami ngminge ta akcüka, Sihmon (Pita ami ti) ja a be Andru, Zebedea capa Jakuk ja a na Johan, ");
INSERT INTO dao_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip ja Batolame, Thomah ja ngcawnklawk Mahte, Alaphaha capa Jakuk ja Thade ami ti ja, ");
INSERT INTO dao_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Kanan khyang Sihmon ja Jesuh phyaheikia Judah Iskarota kyaki he. ");
INSERT INTO dao_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ahina xaleinghngihe Jesuh naw jah tüih lü, “Khyangmjü kce hea lam üng käh nami ceh vai, Samarih khyang hea venak mlühe pi käh nami leh vai,” ti lü a jah cük. ");
INSERT INTO dao_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Acunüngpi, khyükia to am tängki Isarel khyang hea veia nami ceh vai. ");
INSERT INTO dao_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cit u lü, “Pamhnama Khaw ng'et law ve” ti lü jah mtheh hü ua. ");
INSERT INTO dao_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Khyang kune jah mdaw be u lü, mnehkse mnehkie nami jah ngmangsak be vai, khyangkthie nami jah mthawh be vai, khawyaie nami jah ksät vai. Amdanga nami yah amdanga khyang üng nami pet vai. ");
INSERT INTO dao_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ngui im pi ni se, xüi im pi ni se käh nami cehei vai. ");
INSERT INTO dao_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Cä pi käh nami phüihei vai, kcu nghngih, khawdawk nghngih käh nami cehei vai, ksawngkhe käh nami cehei vai. Isetiüng ta, khut pawhkie üng ami hlükaw cun jah pe khai. ");
INSERT INTO dao_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mlüha pi ni se, ngnama pi ni se, nami ceh üng ning jah khina thei khai bükteng lü, nami law be veia acuia nami ve vai. ");
INSERT INTO dao_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Im üng nami va luh üng, im mah üng, “Dimdeihnak ve se” ti lü, dawnak nami jah pet vai. ");
INSERT INTO dao_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Im mahe naw ami ning dokham üng, dimdeihnak ami khana pha law khai. Acunüngpi am ami ning dokham üng ta dimdeihnak cun nangmi da nghlat law be se. ");
INSERT INTO dao_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aia mlüh, aia ngnam üng pi am ning jah dokham lü nami ngthu am ami ngjak hlü üng, a im üngka naw pi ni se, ami khaw üngka naw pi ni se, nami nghlat be üng nami khawpha mput nami kphawng hüt vai. ");
INSERT INTO dao_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Akcanga ka ning jah mthehki, ngthumkhyahnaka mhnüp üng acuna mlühea kthaka ta Sodom ja Komorah mlühe ka jah mpyenei bawk khai ni. ");
INSERT INTO dao_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ngai ua, mhngeea ksunga toca mäiha ning jah tüi veng. Acunakyase kphyua mäiha cingcai u lü müma mäiha nami hniphnawi vai. ");
INSERT INTO dao_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Khyang he nami jah mceiei vai. Isetiüng ta ning jah man khaie veia ning jah cehpüi u lü sinakokea k’uma ning jah kpai khaie. ");
INSERT INTO dao_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Keia phäha acawjah ngvaie ja Sangpuxangea veia ning jah cehpüi khaie. Acunüng keia mawng cun khyang mjükce he üng nami jah mtheh thei khai. ");
INSERT INTO dao_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ami ning jah man u üng, i pyen vai, hawkba ve vai ti käh cäi na ua. I nami pyen vai ti cun akcün a pha law üng ning jah mtheh khai ni. ");
INSERT INTO dao_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pyen khai cun nanimät däk am ni, nami paa ngmüimkhya naw ning jah pyensak khai ni. ");
INSERT INTO dao_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ngbengna xawi mat naw mat ami jah hnim vaia ng'apei law khai xawi. A pa naw a ca ceng law khai, hnasene naw ami nupa hneng law u lü, ami thihnak vaia ceng law khaie. ");
INSERT INTO dao_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Keia ngminga phäha khyang naküt naw ning jah hneng law khaie. Acunsepi adütnak cäpa sitih lü jumeiki naw küikyannak yah khai. ");
INSERT INTO dao_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mlüh mat üng ami ning jah mkhuimkha üng, mlüh kcea nami dawng vai. Akcanga ka ning jah mthehki Isarel mlühe avan üng thangkdaw am nami pyen päih ham üng Khyanga Capa kyum law be khai. ");
INSERT INTO dao_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ahnukläk cun angvaia kthaka am kyäp khawi, mpya pi amahpa khana am ve khawi. ");
INSERT INTO dao_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ahnukläk angvaia mäih a law hin khäk lü, a mpya amahpa mäih a law hin khäki ni. Imbung khawng hin Beelzebul ti lü ami khü üng ta, imbung üngkae ta acuna kthaka sekia va jah sui khaie! ");
INSERT INTO dao_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Khyang he käh jah kyüh ua. Isetiüng ta, thupvih naküt po päih khai, mjih naküt pi ngte law päih khai ni. ");
INSERT INTO dao_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Anghmüpnaka ka ning jah mtheh naküt cen adeinaka khyang he üng nami jah mtheh be vai, a sithawta nami ngjak naküt im mkyung üngka naw nami sang be vai. ");
INSERT INTO dao_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pumsa hnim khawh lü, ngmüimkhya xünnak am hnim khawhki käh kyüh ua. Pumsa ja ngmüimkhya xünnak mulai mei üng kphum khawhki Pamhnam va nami kyüh vai. ");
INSERT INTO dao_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Khaca nghngih ngui phe mata am mi jawi khawi mä? Acun he matca pi nami pa naw am a ksinga khawmdeka am kya law sawxat khawi u. ");
INSERT INTO dao_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na lusam ikän veki ti avan Pamhnam naw ksing päihki. ");
INSERT INTO dao_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Acunakyase, käh kyühkyawk ua, nangmi cun khaca hea kthaka nami daw bawkie ni. ");
INSERT INTO dao_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Au pi khyang he maa “Kei Jesuha hnukläk ni” ti lü pyen hlüki cun kei naw pi khankhawa ka paa maa ka hnukläk ni ti lü ka pyen be khai. ");
INSERT INTO dao_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Acunüngpi khyang he maa kei na maki cun, kei naw pi khankhawa ka Paa maa am ksing üng ka ti be khai. ");
INSERT INTO dao_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Khawmdek khana dimdeihnak lawpüi khaia ka lawkia käh ngai ua. Keia lawpüi ta dimdeihnak am ni, ngtainak vai kcimcei ni ka lawpüi. ");
INSERT INTO dao_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A ca naw a pa hneng lü, a canu naw a nu ngtukpüi khai ja, a pai naw a ni a hnengnak vaia ka lawki ni. ");
INSERT INTO dao_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ami ye cun amäta khuiim kyawnglawng üng kaea kya khai. ");
INSERT INTO dao_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Aupi a pa pi ni se a nu pi ni se, keia kthaka kphya naki ta keia hnukläka am nglawi. A capa pi ni se, a canu pi ni se keia kthak kphyanaki cun keia hnu läk khaia am nglawiki ni. ");
INSERT INTO dao_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aupi amäta kutlamktung kawt lü ka hnu am na läk lawki ta ka hnukläka am nglawi. ");
INSERT INTO dao_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aupi a xünnak vai suiki naw a sak mkhyüh khai. Cunüngpi keia phäha a sak tawnki naw angsäi xünnak yah khai. ");
INSERT INTO dao_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nangmi ning jah dokhamki cun kei na dokhamki ni. Kei na dokhamki cun kei na tüih lawki dokhamki ni. ");
INSERT INTO dao_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Au pi Pamhnama sahma, sahma a nia phäh dokhamki naw a doa khen yah khai. Au pi khyang ngsungpyun, khyang ngsungpyun a nia phäh dokhamki naw a doa khen yah khai. ");
INSERT INTO dao_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aupi ka hnukläk üngka mat üng ka hnukläk a nia phäha tui khawt matca tuki naw, a tua phu yah be khai. ");
INSERT INTO dao_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Axüisawe xaleinghngih a jah mtheh käna, mlüh kce hea ngthu pyen hü khaia Jesuh citki. ");
INSERT INTO dao_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Baptican Johan thawngim üngka naw Jesuha pawhmsahe a jah ngjak üng hnukläk nghngih Khritawa veia a jah tüih. ");
INSERT INTO dao_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Acun xawi naw Jesuh veia, “Johan naw law khai a pyen cen nang mä? Am ani üng akce kami na äp khai aw” ti lü ani kthäh. ");
INSERT INTO dao_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesuh naw jah msang lü, “Nghlat be ni lü nani hmuh ja nani ngjake naküt Johan üng va mtheh be nia” a ti. ");
INSERT INTO dao_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Amikmüe naw hmuh be u lü, akxoe pi cit be thei ve u, mnehkse mnehkie daw be ve u, a nghnga kpange naw ngja be ve u, akthihe tho law be u lü, thangkdaw pi msih mpyaki he üng jah mtheh päng ve u. ");
INSERT INTO dao_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Keia phäha a mlung am uplatsaki ta a josenki ni” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Johana axüisaw he ami ceh be üng Jesuh naw Johana mawng khyangpäe üng jah mtheh lü, “Johana veia khawkhyawng khawa nami ceh üng, i hmu khaia ni nami ceh? Khawkhi naw a ksün khuhnah bükteng khaia mä nami ceh? ");
INSERT INTO dao_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","“I bükteng khaia ja nami ceh? Suisak akdaw suisaki bükteng khaia mä nami ceh? Suisak akdaw suisakie cun Sangpuxangea ima ni ami ve khawi. ");
INSERT INTO dao_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Na mtheh ua, I teng khaia ni nami ceh? Sahma mä? Ä, ning jah mtheh veng, sahmaa pi kyäp bawki ve ve. ");
INSERT INTO dao_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Ahina mawng ni cangcim üng ng'yu lü, “Pamhnam naw, na maa ka ngsä na lam pyang khai ka tüih law khai. ");
INSERT INTO dao_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Akcanga ka ning jah mthehki, nghngicim naküt üng Baptican Johana kthaka daw bawki u am ve. Acunüngpi khankhawa veki akdik säih cun Johana kthaka daw bawki ni. ");
INSERT INTO dao_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Baptican Johana a ngthu pyen üngkhyüh tuh vei cäpa khankhaw naw tuknak khameiki, ngtuatkia khyang ksee naw khaw ami yah vaia kthanakie. ");
INSERT INTO dao_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pamhnama sahma he naküt ja Mosia thume naw Johana a ve vei cäpa Pamhnama Khawa mawng cun pyenkie. ");
INSERT INTO dao_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ami pyen nami jum hlü üng, Johan cun law khaia ami na pyen khawi Elijaha kyaki. ");
INSERT INTO dao_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A nghnga veki naw ngja se. ");
INSERT INTO dao_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Acunsepi atuh khyang he hin i am ni ka jah mtumtäng kawm? Ahin he cun hnasen lumeikie ami püi khü u lü, ");
INSERT INTO dao_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Pülün ning jah tum pe ngü se am nami nglamkie, yawk ng’äi mcuk ngü sepi am mbawikyap uki. ");
INSERT INTO dao_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Johan a law üng am ei aw se, “Khyang naküt naw khawyaia venak” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Khyanga Capa law lü ei aw se khyang naküt naw, “Teng ua, meng lü capyittui aw ve, akhawn kawke ja khyangkaea püi hin” ami ti. “Acunüng pi ksinghmatnak cun a bilawh üng ngsingki” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Acunüng Jesuh naw müncanksee aktunga a pawhnaka mlühe cun am ami ngjuta phäha a jah ksenak. ");
INSERT INTO dao_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korazin mlüh aw na jo se ve, Bethsaida mlüh aw na jo se ve. Isetiüng ta, nangni üng mdana mäiha müncanksee hin Turah ja Sidon mlüha mdang vai sü ta, ahlana va kpyawnkse ngbung u lü, mput awt u lü ngjut päng khaie sü. ");
INSERT INTO dao_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Akcanga ka ning jah mthehki, ngthumkhyahnaka mhnüp üng Turah ja Sidon mlüh xawi cun nangnia kthaka Pamhnam naw jah mpyenei khai. ");
INSERT INTO dao_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nang Kapenawm mlüh pi, namät naw namät khankhaw cäpa na mhlünmtaiei hlüki aw? Mulaia ning khyakin vai. Nang üng mdana mäiha Sodom mlüh üng müncanksee jah mdan vai sü üng ta tuh vei cäpa ve ham khai sü. ");
INSERT INTO dao_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka ning jah mthehki, “Ngthumkhyahnaka mhnüp üng nanga kthaka Sodom mlüh üng Pamhnama mpyeneinak däm khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesuh naw pyen lü, “Ka pa, khawmdek ja khankhawa Bawipa aw! Khyang ktheme üng jah thup lü a mlung mhnemki hnasena mäihe üng na jah mhnüha phäh na ngming ka mküiki. ");
INSERT INTO dao_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ä, ka pa aw, ahin cun na ngjak hlüa kyaki ni. ");
INSERT INTO dao_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ka pa naw avan a na pet päng. U naw a capa am ksing, ka pa däk naw ni a ksing. Ka pa pi u naw am ksing, a capa däk naw ni a ksing. Acun ja a capa naw a mtheh däk naw ni a ksing. ");
INSERT INTO dao_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","A phüih yüh lü bawngbaiki naküt ka veia law ua, ka ning jah hüieisak khai. ");
INSERT INTO dao_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ka kawhcung kawt ua. Ngmüimkhya lama ka mlungmthin hniphnawi lü nemkia kyase, ka veia ngtheingthang law ua. Acunüng, nami ngmüimkhyaa hüieinak nami yah khai. ");
INSERT INTO dao_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","“Isetiüng ta, ka ning jah pet vaia kawhcung cun jäi lü, nami khana ka mtaih vaia phüih pi hangki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jesuh sabbath mhnüp üng loma lama cit se, axüisaw he ami ei ngaih u lü lomaa cangvüi kpyat lü eikie. ");
INSERT INTO dao_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pharise he naw ami jah hmuh üng, Jesuh üng, “Tenga, sabbath mhnüp üng jeih vai sü, am pawh vai na xüisawe naw pawh ve u” ti lü ami pyen. ");
INSERT INTO dao_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesuh naw, “Davit a ei ngaih lü a khyang he am i pawhkie ti cangcim üng am nami kheh khawiki aw? ");
INSERT INTO dao_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pamhnama ima lut u lü Pamhnam üng peta muk, ktaiyü he däk naw va eia nglawiki. Amimia eia am nglawiki a khyang he am eikie. ");
INSERT INTO dao_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Am ani üng, ktaiyü he sabbath mhnüp üng khut ami pawh msawk üng pi mkhyekiea am jah ngaih, ti cangcim üng am nami khe khawiki aw? ");
INSERT INTO dao_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Acunsepi ka ning jah mthehki, ngpumima kthaka daw bawki hia ve ve, ");
INSERT INTO dao_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Ngkengtaihnaka kdama mpyeneinak ngaih veng” ti nami ksinga ta ngsungpyunkie am nami jah mkatei khai sü. ");
INSERT INTO dao_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Isetiüng ta, “Khyanga capa cun sabbatha Bawi ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesuh acun üngka naw cit lü, ami sinakoka lutki. ");
INSERT INTO dao_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Acuia akutxo a na veki. Ami mkatei vaia phäha, “Sabbath mhnüp üng mdawnak bea khut pawh nglawiki aw?” ti lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesuh naw, “Nangmi üngka mata toca mat däk a tak sabbath mhnüp üng khuia k’uma kya se am na lo be khai aw, na hawihin khai aw. ");
INSERT INTO dao_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","To mata kthaka khyang mat sabbath mhnüp üng mdaw be vai cun daw bawki. Acunakyase, mi Thum üng pi sabbath mhnüp üng khyang mat kuei vai hin nglawiki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Acunkäna Jesuh naw akutxo üng, “Na kut sänga” ti se, a kut a säng ja a kut akce mäiha daw law beki. ");
INSERT INTO dao_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Acunüng Pharise he akcea cit u lü Jesuh ami mkhyüh vaia cengkie. ");
INSERT INTO dao_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesuh naw ami hnim hlü cun a ksingei üng, akcea jah ceh ta se khyangpä naw läki he. Mhnatei nakütki a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesuh naw ania mawng i käh ami kcüinak vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Acun cun Pamhnam naw a pyensak sahma Hesajah naw a na pyen a kümceinak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Tenga, ka mpya, ka xü cen, ka kphyanak ja ka mlunga jenak. Ka ngmüimkhya a khana ka tüih khai, ani naw ngthumkhyahnak cun khyangmjüe üng jah mtheh khai. ");
INSERT INTO dao_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ngpyang lü ngcuhpüi am ve, u naw a kthai lama käh ngja khai. ");
INSERT INTO dao_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ngkunkia kyaicung käh k’ekbät lü, meisui mkhu pi käh mthih khai. Ngpyunnak a ngnäng veia, ");
INSERT INTO dao_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A ngming üng khyang he naw äpeinak ta khaie. ");
INSERT INTO dao_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Acunüng khawyaia venak a mik mü lü am ngthuhei theiki khyang mat ami lawpüi Jesuh naw mdaw be se, ngthuhei lü hmuh law be theiki. ");
INSERT INTO dao_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Khyangpäe naw Jesuha pawh cun hmu lü müncan law u lü, “Hina khyang hin Davita capa ni khawh khai aw?” ");
INSERT INTO dao_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pharise he naw acun ami ngjak üng, “Hina khyang naw Beelzebul yaiea mkhawnga pet johit am yaie jah ksät ve” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesuh naw ami cungaih jah ksing lü, “Aia pe pi animäte ngcawhkie cun khawvei am kham lü ngtai khawikie. Aia mlüh pi imbung üng pi, animäte ngcawhkie cun am ngsawn khawi u.” ");
INSERT INTO dao_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Acunüng khawyai naw khawyai a ksät üng, amät naw amät mtaikia kya se, ikba a khaw ngsawng khawh khai ni? ");
INSERT INTO dao_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nangmi naw Beelzebul yai mkhawnga na pet johit am yaie ka jah ksät vaia nami pyenki. Acun a ni üng, u naw nami hnukläke üng jah ksätnaka johit jah peki ni? Nami hnukläke naw nami mkhye ngdangsak ve u, a ti. ");
INSERT INTO dao_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Am ni, Beelzebula johit am ni. Mhnama ngmüimkhyaa johit am ka jah ksät üng va Pamhnama Khaw nami khana pha lawki. ");
INSERT INTO dao_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Am ani üng u naw khyang kyan yüi üng am pin ma lü, a ima ka khawhkhyame jah loei thei khai ni? ");
INSERT INTO dao_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Au pi, kei da am veki cun kei na hnengki ni. Kei am alanga am na mcunpüiki cun ngphyüingphyakia kyaki ni. ");
INSERT INTO dao_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Acunakyase ka ning jah mthehki, mkhyekatnak naküt ja, Pamhnam ksekha nakie cun jah mhläta kya khai. Cunsepi Ngmüimkhya Ngcim ksekhanaki cun mhlät theia am kya. ");
INSERT INTO dao_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aupi Khyanga Capa mkhyekat na lü ksekhanaki cun mhläta kya khai. Cunsepi Ngmüimkhya Ngcim ksekhanaki cun tuh pi ngawia pi mhlät theia am kya. ");
INSERT INTO dao_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Akthei üng a thing ksing theia kya se, akthei a daw üng a thing daw lü, akthei a set üng a thing seki ti nami ksing vai. ");
INSERT INTO dao_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kphyuksee aw, ihawkba se u lü akdaw nami pyen thei khai ni? Mlung üng veki va mpyawng üng lut law khawiki. ");
INSERT INTO dao_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Khyang kdaw naw a mlung kdaw üngka akdawe jah pyen khawi lü, khyang kse naw a mlung kse üngka aksee jah pyen khawiki. ");
INSERT INTO dao_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ka ning jah mthehki, akse pyenkia khyang naküt a pyena phu cun ngthumkhyahnaka mhnüp üng thung be khai. ");
INSERT INTO dao_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na ngthu naw ning lätsak lü na ngthu bä naw ning mkat khai” a ti. ");
INSERT INTO dao_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Acunüng thum mthei he avang ja Pharise he naw Jesuh üng, “Saja aw, müncankse mat na pawh kami hmuh hlüki” ti lü tä u se, ");
INSERT INTO dao_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesuh naw, “Tuh kän khyang he ihlawka se lü mtuihmlehkie ni. Nangmi naw müncankse nami täkie aw? Jonaha müncanksea thea i käh ning jah mhnuh vai” a ti. ");
INSERT INTO dao_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah nganua k’uma mhnüp kthum ja mthan kthum a vea mäiha khyanga capa pi mdek k’uma mhnüp kthum ja mthan kthum ve khai. ");
INSERT INTO dao_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninevih mlüha khyang he naw ngthumkhyahnaka mhnüp üng ngdüi u lü ning jah mtai law khaie. Isetiüng Jonaha ngthu pyena phäh ami mkhyenak üngka naw ngjutkie. Teng u, Jonaha kthaka kyäp bawkie ve ve u. ");
INSERT INTO dao_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ngthumkhyahnaka mhnüp üng Sheba Sangpuxangnu naw ngdüi lü ning jah cijang law khai. Ani cun Solamona themngvainak ngai khaia athuknak a khaw üngka naw lawki. Teng ua, Solamona kthaka kyäp bawki hia ve khü. ");
INSERT INTO dao_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ngmüimkhyakse khyang üngka naw a lut law üng, mkyanga a hüieinak vai hnün sui hü lü am hmu lü, ");
INSERT INTO dao_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“ka venak kphyüm ima ka cit be khai” ti lü a ceh be üng, a na ngcim lü a na phephaih, a na ngkhämtawng se a hmuh. ");
INSERT INTO dao_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Cit be lü amäta kthaka se bawkia ngmüimkhya ksee khyüh jah khü law se lut u lü, acuia awmki he. Acunüng, acuna khyang üng kya law khai cun akma kaa kthaka kyühkse bawki ni. Acukba tukbäih hina khyang ksee üng pi thawn law hnga khai” a ti. ");
INSERT INTO dao_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Acukba khyang khawhahea veia a ngthuei k'um üng a nu ja a benae naw ami ngthuheipüi vaia sui hü u lü kpunga ngdüikie. ");
INSERT INTO dao_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Acunüng mat naw, “Tenga na nu ja na benae naw ning ngthuei hlüpüi lü kpunga ngdüi ve u” ti lü a mtheh. ");
INSERT INTO dao_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesuh naw, “U ni ka nu, ue ni ka benae cun” a ti. ");
INSERT INTO dao_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Acunüng Jesuh naw axüisaw he maa a kut säng lü, “Hine hin ka nu ja ka benae ni.” ");
INSERT INTO dao_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Au pi, ka pa khankhawa kaa ngjak hlü pawhki naküt cun ka benae, ka cinae ja ka nua kyaki he ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Acuna mhnüp üng, Jesuh im üngkhyüh cit lü tuilia kama jah mthei khaia ngawki. ");
INSERT INTO dao_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ani ngbum lawki khyangpäe nung u se ta Jesuh mlawnga khana kai lü a ngaw üng, khyangpäe cun tuili kama ngdüikie. ");
INSERT INTO dao_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesuh naw msuimcäpnake am ngthu pyen lü, “Ahlana mci saw khaia khyang mat citki.” ");
INSERT INTO dao_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Acukba a phuh hü üng, mci avang lama kya se khae naw ami ei u. ");
INSERT INTO dao_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Avang lunga danak, nglei a ngceknaka kya se akjanga cawt lawki. ");
INSERT INTO dao_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Khaw so law lü ngling law se, apya am vekia kya lü ngjaiei päihki. ");
INSERT INTO dao_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mci avang nghlinga ksunga kya se nghling naw saü law lü a jah yaiin. ");
INSERT INTO dao_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Cunsepi, mci avang ngleia dawnaka kya se daw lü, avang aphya, avang khyukip, avang thumkipa ngtheipai lawki. ");
INSERT INTO dao_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aupi a ngjaknak vai a nghnga veki naw ngja se” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Acunüng axüisaw he Jesuha veia law u lü, “Khyang he am na ngthuei üng ivaia msuimcäpnake na jah sumeiki ni?” ti lü ami kthäh u. ");
INSERT INTO dao_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesuh naw, “Nangmi cun Khankhaw Pea küia mawng ksingnak ka ning jah mtheh päng ni, amimi üng ta am jah mtheh nawng” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Takia khyang üng a tak law dämdäm vaia petsih vai. I pi am taki üng a tak naküt pi hutei be vai. ");
INSERT INTO dao_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ami veia msuimcäpnak am ngthu ka pyen hin teng kyaw u lü pi am hmu u, ngai kyaw u lü pi am ngjakya u. ");
INSERT INTO dao_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Acunakyase sahma Hesajah naw Hina khyang he naw ngai lü ngaikie, cunüngpi am ngjakya u; teng lü tengkie, cunüngpi am hmu u, ");
INSERT INTO dao_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Isetiüng ami mlung nghlangkia kyase, ami nghnga naw am ngja ti, ami mik naw am hmu ti. Ami mik naw hmu lü, ami nghnga naw a ngjak vai sü ta, ami mlung üng ngjakya khaie sü, acunüng ka veia nghlat law be u se, ka jah mdaw be vai sü” a pyen khawi. ");
INSERT INTO dao_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nangmi ta nami mik naw hmuh lü nami nghnga naw ngja se nami kam daw ve. ");
INSERT INTO dao_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Akcanga ka ning jah mthehki, sahma khawkän ja Pamhnama khyang he naw nami hmuh hin hmuh hlü u lü pi am hmuh khawh u, nami ngjak hin ngja hlü u lü pi am ngja hüt u. ");
INSERT INTO dao_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Acunakyase, mciksaw msuimcäpnak üng pyen hlü hin ngai lü ngthei ua. ");
INSERT INTO dao_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Khankhaw Pea mawng ngthu ngja lü am ngjakyaki cun lama khana kyaki mci am tängki ni. Khawyaipa naw law lü a mlung k’uma sawnglin cun a lawheiin pet. ");
INSERT INTO dao_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lunga khana kyaki mci cun ngthu ngja lü jekyainak am a ngjak ja dokhameiki. ");
INSERT INTO dao_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Acunüngpi am phungpya mahkia kyase khawvei am kham. Acun ngthua phäh khuikhatnak ja mkhuimkhanak apha law üng pyaiei beki. ");
INSERT INTO dao_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nghling hmua kyakia mci cun Mhnama ngthu ngja kyawki, khawmdeka cäicingnak ja bawimangnak naw a mhleia phäh a ngthu ngjak cun kpyeh se, am ngtheipai lü veeiki. ");
INSERT INTO dao_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ngleia dawnak üng kyakia mci cun ta ngthu ngja lü ngjakyaki: acunüng ngtheipaikie, avang aphya, akhäk khyukip ja amsah thumkipa ngtheipai bekie” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Msuimcäpnak akce a jah mtheh betü ta, “Khankhaw Pe cun a loa mci kdaw sawki khyang mat am tängki ni. ");
INSERT INTO dao_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Khyang he ami ih k'um mthan mat üng, ye naw law lü mci kdawa ksunga mci kse saw lü akcea citinki. ");
INSERT INTO dao_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cang pyo law lü a vuipai law üng, mphyaw pi ngdang lawki. ");
INSERT INTO dao_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A mpyae naw law u lü amahpaa veia, “Angvai aw, na lo üng mcikdaw va na saw am niki aw? Hawia khyüh hina mphyawe po lawki he ni? ti lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lomah naw, “Yee naw ahikba ami pawh ni” a ti. A mpyae naw lomah üng cit lü kami jah phukin vai aw? ami ti. ");
INSERT INTO dao_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Lomah naw, “Kaa, mphyaw nami phuk üng cangkdaw pi nami phuksih khai ni.” ");
INSERT INTO dao_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Cang ah veia ani nghngih veei yüm ni se. Cang ah law üng mphyawe cun jah phu ma lü mei üng jah mkhih vai ja, cange cun jah at hnga u lü, ka kheia ami tak vaia cangk'at he üng ka jah mtheh khai,” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesuh naw msuimcäpnak akce a jah mtheh betü cun, “Khankhaw Pe cun khyang naw anca ui cehpüi lü a loa a phuha mäi ni,” ");
INSERT INTO dao_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Anca ui cun mciui naküt üng akdik säiha kya lü pi a cawt law üng, kpue naküt kthaka ngbaü lawki. A thinga thawn law se khae naw pi law u lü, a kpyang üng ngbu tuhei law khawikie,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Msuimcäpnak mat a jah mtheh betü cun, “Khankhaw Pe cun nghnumi mat naw nghngen lo lü khai tawng kthum üng kcaw se, khai kphawm lawki üng tängki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesuh naw msuimcäpnak am khyangpäe üng ngthu jah mthehki; msuimcäpnaka kaa i am pyen. ");
INSERT INTO dao_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sahma naw a pyen khawi, “Msuimcäpnak am amimia veia ngthu ka pyen khai; khawmdek mhnünmceng üngka naw khyüngthupe ka jah mtheh khai,” ti aküm lawnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesuh naw khyangpä cun akcea jah ceh ta lü im k’uma lut se, axüisaw he a veia law u lü, “Loa mphyawa mawng msuimcäpnaka suilam i ni, jah mtheha” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesuh naw, “Mcikdaw sawki cun Khyanga Capa ni.” ");
INSERT INTO dao_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Lo cun khawmdek ni, mcikdawe cun Khankhaw Pea ca hea kya u lü, mphyawe cun Khawyama ca he ni. ");
INSERT INTO dao_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mphyaw sawki ye cun Khawyam ni. Cang ah kcün cun khawmdeka päihnaka mhnüp ni, cang atkie cun khankhawngsä he ni. ");
INSERT INTO dao_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Acukba mphyawe jah mcun lü mei üng ami jah mkhiha mäiha, akcün päih law üng thawn law khai. ");
INSERT INTO dao_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Khyanga Capa naw a khankhawngsä he jah tüih law se, acun he naw a Khankhaw Pe üng khyang he jah mkhyekatsakie ja akse pawhkie avan cun jah mkhäm khai, ");
INSERT INTO dao_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kyap u lü ami mnicui hakyet khai hea mulai mei kdäi üng jah xawt law khaie. ");
INSERT INTO dao_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Acunüng Pamhnam ca he ta khawnghngia deikhanga mäiha ami Paa Khankhaw Pea kdeikhang khaie. Na nghnga a ve üng ngjaa! ");
INSERT INTO dao_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Khankhaw Pe cun loa thupa khawhthem üng tängki ni. Khyang mat naw acuna khawh cun hmu lü thup beki naw, jekyai lü a tak naküt va jawi lü a yah lawa ngui am acuna lo cun a khyäih. ");
INSERT INTO dao_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Acunkäna, Khankhaw Pe cun aphu küiki lungtaü kdaw sui hü lü kunpanki khyang mat veki. ");
INSERT INTO dao_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Acuna lungtaü a hmuh üng a tak naküt jawi päih lü acuna lungtaü cun a khyäih am tängki ni. ");
INSERT INTO dao_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Khankhaw Pe cun ngvai am pi tängki ni. Ngaksui avang naw tuia ami ngvai ami vawih üng nga amjüküm ng’awki. ");
INSERT INTO dao_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ngvai cun nga beei se kawnga kaih u lü nga cun ami ngawh sawa phyäihkie: nga kdawe cun cä üng jah xawn u lü, am dawkia ngakse naküt cun ami jah xawtin. ");
INSERT INTO dao_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Acukba akcüna päih law üng thawn law khai: khankhawngsä he naw law u lü khyang ngsungpyunea ksunga khyangkae cun jah xü khai. ");
INSERT INTO dao_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kyap lü ami mnicui hakyet khai hea, mulai meikdäia jah xawtin vai” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesuh naw, “Ahin he hin nami jah ngjakyaki aw?” ti se, “Ä, kami ngjakyaki ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesuh naw, “Acunakyase Khankhaw Pea mawng mtheiki thum mthei he naküt cun immahpa naw a im k’uma ka khawh akthai ja akphyüm a cümnak üngka naw loki am tängki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesuh naw acuna msuimcäpnake a jah mtheh päng üng, acuna hnün hawih lü, ");
INSERT INTO dao_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A hminak mlüha cit beki. Sinakoka k’uma jah mtheimthang se ngja lü müncan ngenkie. “Ahina themngvainak müncankse pawhnaka johit hin hawia a jah yah ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Imksaa ca am ni mä? A nu pi Marih, a benae pi Jakuk, Josep, Sihmon ja Judah ami ti am nikie mä? ");
INSERT INTO dao_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A cinae am pi ahia awmki he am ni mä? Hawia ka hin naw ahikba johit hin a jah yah hü ni? ami ti. ");
INSERT INTO dao_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Acukba Jesuh cun ami ma. Jesuh naw, “Sahma cun hnün naküt üng leisawngkie ni, a hminak a khaw ja a imbunga ni am leisawngnak a yah khawi,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Am jumkiea kyase acuia müncankse i am pawh. ");
INSERT INTO dao_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Acun k'um üng Kalile Upki Herod naw Jesuha mawng cun ngja lü, ");
INSERT INTO dao_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","a khyang he üng, “Ani cun Baptican Johan ni, thihnak üngka naw tho beki, acunakyase ni müncanksee jah pawhnak khawha johit taki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod naw Johan cun man lü, a na Philipa khyu Herodiha phäha thawngim üng ahlana a khyuma kyaki. ");
INSERT INTO dao_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Johan naw Herod üng, “Na naa khyu na khyunak vai ta am nglawiki ni,” a tia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod naw Johan hnim hlüki kyaw Judah khyang he a jah kyüh. Isetiakyaküng Johan cun Judah khyang he naw sahmaa ami ngaiha kyaki. ");
INSERT INTO dao_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Heroda hminaka mhnüp üng, Herodiha canu cun Herod ja a khinea maa nglamki. Herod amsüma jeki. ");
INSERT INTO dao_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“Ka ng’yünki, na hlüei na tä naküt ka ning pe khai” ti lü Herod naw Herodiha canu üng bekhüt a pet. ");
INSERT INTO dao_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A nu naw a cüka kba nglaca cun naw, “Mlikbe üng Baptican Johana lu na pea!” a ti. ");
INSERT INTO dao_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sangpuxang cun pukseki, cunüngpi a khinea maa a khyütama pänga kyase nglacaa hlüei cun ami pawh vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Acunüng thawngima khyang tüih lü Johana lu a khyüngsak. ");
INSERT INTO dao_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Johana lu cun mlikbe üng lawpüi lü nglaca üng pe u se, nglaca naw a nua veia a cehpüi. ");
INSERT INTO dao_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Johana hnükläke law u lü a yawk cehpüi lü, k’utkie naw Jesuh üng ami va mtheh. ");
INSERT INTO dao_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesuh naw Johana mawng a ngjak üng, mlawng am ngcum lü ahinak mawkpyawnga citki. Acun ngjaki khyang he naw ami mlüh jah hawih hüt lü ami khaw am läki he. ");
INSERT INTO dao_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mlawng üngka naw a kyum law üng Jesuh naw khyangpänu jah hmuh lü jah mpyeneiki, am phetkie a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Khaw a mü law hlü üng axüisaw he a veia law u lü, “Ahin hin maw ni, khaw pi mthan hnühki ni. Khyang he hin jah tüiha, ami ei vai ngnamea ami ei phäh phäh vai khyäiei hü u se” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesuh naw, “Athuknaka ami ceh vai am hlü, nangmi naw ami ei vai aipi jah pe ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Amimi naw, “Muk mhma ja nga nghngihca däk ni kami tak ve u,” ti u se, ");
INSERT INTO dao_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Acunüng Jesuh naw, “Ka veia lawpüi ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Khyang he cun msaia khana ngaw khai hea a jah mtheh. Acunkäna muk mhma ja nga nghngih cun jah lo lü khana mang lü Pamhnam üng jenak mthehki. Muke cun jah bo lü axüisaw he üng a jah pet. A axüisaw he naw khyang he üng ami jah pet. ");
INSERT INTO dao_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Avan naw ei lü phü u se, ami ei k’hläi cun axüisaw he naw ami mcun be üng cä xaleinghngiha lawki. ");
INSERT INTO dao_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eikie naküt cun nghnumi ja hnasen am pakia, kpami däk thawngmhma lawki he. ");
INSERT INTO dao_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Acunüng Jesuh naw khyang he a jah tüih be käna, axüisaw he cun mlawng üng cayea a jah na cehsak. ");
INSERT INTO dao_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Acukba khyang he a jah tüih be päng üng, amätca mcunga ktaiyü khaia kaiki. Khaw mü law se, amät däk acuia veki. ");
INSERT INTO dao_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Acunüng mlawng cun kawng üngka naw a thuknak tuili nglunga ve se tuingnawk naw a ceh hü. ");
INSERT INTO dao_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Khaw athaih law hlü üng, Jesuh tuia khana a khaw am axüisaw hea veia lawki. ");
INSERT INTO dao_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Axüisawe naw tuia khana a law ami hmuh üng kyühei law u lü, “Hin hin ngmüimkhya ni,” ti u lü ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesuh naw, “Käh kyüei ua, Kei ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita naw msang lü, “Bawipa aw, nang na ni üng, tuia khana ka law hnga khaia na mtheha,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Lawa,” Jesuh naw a ti. Acunüng Pita mlawng üngka naw kco law lü Jesuha veia cit khaia tuia khana citki. ");
INSERT INTO dao_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Acunüngpi khawa khi law a hmuh üng kyühei lü tui üng ju ngcumei lü, “Bawipa aw, na küikyana,” ti lü ngpyang se, ");
INSERT INTO dao_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesuh naw man be lü, “Jumeinak ngcekia khyang aw, ivaia na mlung uplatki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mlawng üng ani kai be ja khawkhi ngdüm beki. ");
INSERT INTO dao_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mlawnga k’uma veki axüisaw he naw hjawkhah law u lü, “Nang hin Pamhnama Capa na kya kcangki ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tuili cayea va pek u lü Kenesaret hnea lawki he. ");
INSERT INTO dao_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Acuia ka khyang he naw Jesuh ami ksing üng, acuna pipei üngkae pe naküt üng khyang he jah tüih hü u lü am phetkie naküt ami jah lawpüi u. ");
INSERT INTO dao_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","A suisak mdawngca hman hneh vaia nghuinakie, acunüng, aupi hneki naküt cun phet bekie. ");
INSERT INTO dao_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Acunüng Pharise he avang ja thumksinge Jerusalem üngka naw Jesuh veia law u lü, ");
INSERT INTO dao_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ise, na xüisawe naw pupa thum am läklamkie ni? Ise ami kut akdawa am mthiei lü ei suxatkie ni?” ti lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesuh naw, “Nangmi pi ivaia nami pupa thum läk u lü Mhnama thum am nami läki ni. ");
INSERT INTO dao_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Isetiüng Mhnam naw, ‘Na nu ja na pa na jah leisawng vai, na nu pi ni se na pa pi ni se na jah yünce üng nang cun na thi khai,’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Acunsepi nangmi naw, Khyang naw a nu ja pa a jah kueinak vaia mkawt a ve üng, ‘Pamhnam üng pet päng ni’ nami tiki. ");
INSERT INTO dao_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A nu pa a leisawng vai am hlü.Acukba nangmi cun Pamhnama thum pi käh ngtäh khaia nami thum am nami pawhki. ");
INSERT INTO dao_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hypocrite aw, Hesajah naw nami mawng a pyen cen cang ve, ");
INSERT INTO dao_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Hine naw ami mpyawng am na leisawng kyaw u lü pi, ami mlungmthin ta Kei üngka naw thuk ve u. ");
INSERT INTO dao_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Akhawvaa na sawkhah ve u, isetiüng nghngicim thume cun Ka thuma hana jah mthei ve u!’” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Acunüng khyangpäe cun Jesuh naw a veia jah khü lü, “Ngai u lü ksing ua. ");
INSERT INTO dao_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Khyanga mpyawng üng ju lutki naw khyang am mtüihkhehsak, a k'um üngka naw mpyawnga lut lawki naw ni khyang a mtüihkhehsak ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Acunüng axüisaw he a veia law u lü, “Pharise he naw na ngthupyen ami ngjak üng ami mlung seki ti na ksingki aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesuh naw, “Ka pa, khana ka naw am a nglin naküt cun phuka kya khai.” ");
INSERT INTO dao_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Käh jah cäi na ua! Ami mik mükie ni. Amikmü naw amikmü lam a msüm üng ani nghngih khuikhawk üng kya khai xawi,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita naw msang lü, “Hina msuimcäpnak jah mtheh ngkhaia,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesuh naw, “Tuh vei üng khyang kce hea kthaka am na cing hamki aw.” ");
INSERT INTO dao_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Na mpyawng üng ju lutki naküt na khawnua pha lü na mtisa lum üng pha hüki ti am nami ksing hamki aw.” ");
INSERT INTO dao_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","“Acunsepi, mpyawng üngka naw lut lawki naküt cun mlungmthin üngka naw law lü, khyang mtüihkhehsaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Isetiüng khyang hnimnak, khyanga khyuca bäühmanak, mpyuknak, hleihlatnak, Pamhnam ksekhanake naküt cun am dawkia ngaihkyunak üngka naw cawm lawkia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ahin he naw ni khyang mtüihkhehsak u lü, kut käh mthiei lü ei naw khyang am mtüihkhehsak,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesuh acun üngka naw cit lü Turah ja Sidon mlüh peisua citki. ");
INSERT INTO dao_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Acuna mlüh pipei üng veki Kanan nghnumi naw law lü, “Davita capa Bawipa aw, na mpyeneia, ka ca nghnumica khawyai naw aknuia pawh ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Cunsepi Jesuh naw mkhap matca am pi am msang be. Axüisawe lawki he naw, “Hina nghnumi hin akcea tüiha, jah läk law lü kpamcai ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Acunüng Jesuh naw, “Kei hin Isarelea khuiimkyawng üngka naw khyükia toea phäh ni Pamhnam naw a na tüih law,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A veia law lü sawkhahki naw, “Bawipa aw, na mpyena,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesuh naw, “Hnasenea ei lo lü, uie üng jah xawt pet vai hin nglawiki aw,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nghnumi naw, “Bawipa aw, acukba lang va. Acunüngpi, uie naw pi ami mahpa buhkbaw mthüpeia thum am veki aw,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesuh naw, “Jumeinak dämkia nghnumi aw, na ngjak hlüa thawn se,” a ti. Acun ja a canu cun daw beki. ");
INSERT INTO dao_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesuh acun üngka naw Kalile tuili läkläka citki. Mcunga kai lü ngawki. ");
INSERT INTO dao_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Khyangpänue naw akxo, amikmü, ak'ang, am kümkia hmikie ja, amjümjü natnake jah lawpüi u lü Jesuha khaw kunga jah msän u se, a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ak'ange ngthuhei law be thei lü, a kut khaw kbäte daw be u lü, akxoe cit be thei u lü, amikmüe naw hmu law be thei u se, khyang he naw ami jah hmuh üng, müncan ngen u lü Isarelea Pamhnam cun mhlünmtaikie. ");
INSERT INTO dao_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesuh naw axüisaw hea jah khü lü, “Hina khyang he hin ka hlawnga mhnüp kthum ve pängki he , atuh ta ei vai am ve se jah mpyenei veng. Ami ei kaa jah tüih vai am daw. Ei ngaih lü lama khuikha hü khaie ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Axüisawe naw, “Hawia hina khawmkyanga khyang hikäna ei vai mi hmuh khai ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesuh naw, “Muk ikän nami taki” ti se, “Khyüh ja ngaca api ve ve” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Acunüng Jesuh naw khyang he ngaw khai hea a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Acunüng muk khyüh ja ngaca jah lo lü, Pamhnama veia jenak mtheh lü a bo. Acun cun axüisaw he üng jah pe se axüisaw he naw khyang he üng ami jah pet. ");
INSERT INTO dao_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Avan naw ei u lü, ami phü käna ak’hläi jah mcun u se cä khyüh üng beki. ");
INSERT INTO dao_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Eikie cun nghnumi ja hnasen käh pakia kpami däk thawngkphyü lawki he. ");
INSERT INTO dao_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Acunüng Jesuh naw khyang he jah tüih be lü mlawng üng kai be lü, Makadalah khawa citki. ");
INSERT INTO dao_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pharise avang ja Sadukee law u lü Jesuh ami mhnütnak vaia Pamhnam naw ning ksingki ti a ngsingnak vaia, müncankse jah mhnuha” ti lü täkie. ");
INSERT INTO dao_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesuh naw jah msang lü, “Khaw kyak law hlü üng, ‘Khankhaw mliki khawngawi ta khaw sen hlü ve’ nami ti khawiki.” ");
INSERT INTO dao_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ngawilama, “Khaw ngmei lü anghmüp law üng, tuhngawi ta khaw ah hlü ve,” nami ti khawiki. Khawa sen vai ja a ak vai cun khankhaw teng lü nami ksing kyawkie. Cunüngpi akcünmka üng sängeikia müncanksee ta am ksing khawh uki. ");
INSERT INTO dao_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Tuh kän khyang he ihlawka se lü mtuihmlehkie ni. Nangmi naw müncankse nami täkie aw? Jonaha müncanksea thea i käh ning jah mhnuh vai” ti lü a jah ceh tak. ");
INSERT INTO dao_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Acunüng, axüisaw he tuilia cayea ami law üng, muk law vai ami mhnih. ");
INSERT INTO dao_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesuh naw, “Pharise he ja Sadukeea nghngen nami jah cäieinak vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Animäte naw ngai u lü, “Ahin hin muk am mi lawpüia phäha kya ngaiki,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesuh naw ami pyen ksing lü, “Jumeinak ngcekia khyang he aw, i nami sumkyamkie ni. Ise muk am nami taka phäh vaia nami ngaikie ni? ");
INSERT INTO dao_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Muk mhma pacawng thawng mhmaa phäh ka bo cen am nami sümkie aw? Cä ikän ja nami msap law? Am nami ksing hamkie aw? ");
INSERT INTO dao_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Muk khyüh khyang thawng kphyü naw ei u se, cä ikän hläiki ti am nami sümkie aw? ");
INSERT INTO dao_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“Eia mawng ka ning jah mthehki am ni, ise am nami ksing u ni? Pharise he ja Sadukeea ngneikse nami cäieinak vaia ka ning jah mthehki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Acunüng muk üng ami kcaw nghngen a pyen am ni, Pharise he ja Sadukeea jah mtheimthangnak ami cäieinak vaia a jah mtheh tia ami ksing. ");
INSERT INTO dao_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesuh Kesari Philipih mlüh pei cit lü acuia axüisaw he üng, “Khyang he naw Khyanga Capa hin u ami pyen ni,” ti lü a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Amsah naw Baptican Johan, amsah naw Elijah, amsah naw Jeramih, am ani üng sahma mat mat va ni khai ti ve u,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesuh naw, “Nangmi naw mä ua jah nami na ngaih?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sihmon Pita naw, “Nang cun Khritaw, xüngseiki Pamhnama Capa ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesuh naw msang lü“Johana ca Sihmon, na jo daw ve. Isetiüng ta, ahin hin khyanga ning mtheh am ni, khana ka Pa naw a ning mtheh ni.” ");
INSERT INTO dao_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ka ning mthehki, Pita aw nang lung ni, ahina lunga khana ka sangcim ka mdüih khai, thihnak naw pi käh näng khai ni. ");
INSERT INTO dao_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Khankhaw Pe tawhe ka ning pe khai, aipi khawmdek khana am na mhlät naküt cun khankhawa pi mhläta am kya, ai naküt pi khawmdek khana na mhlät cun khankhawa pi mhläta kya khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Acunüng axüisaw he üng Khritaw a ninak u üng pi käh ami mtheh vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Acunüng tünei lü Jesuh naw “Jerusalema ka cit khai, axüe, ktaiyü he ja thumksingea mkhuimkhanak ka khamei khai. Na hnim khaie, cunüngpi amhnüp kthum üng ka tho be khai” ti lü axüisaw he üng a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita naw akcea khü lü, “Bawipa aw, acukba käh kya khai, na khana acukba käh thawn yah khai,” ti lü Jesuh a pyen. ");
INSERT INTO dao_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesuh naw nghlat law lü Pita üng, “Khawyam aw, ka peia käh vea, nang hin ka kyukngtängnak vaia na kyaki ni. Isetiakyaküng, na ngaihnak hin Mhnam üngka naw lawki am ni, khyang üngka naw lawki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesuh naw axüisaw he üng, “Nangmi üngka mat naw ka hnu läk khaia a bü üng a hlükaw naküt hawih lü, amäta kutlamktung kawt lü na läk law se.” ");
INSERT INTO dao_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Na sak küinak khaia na bü üng sak am yahki, cunüngpi keia phäha na sak tawn khaia na bü üng ta angsäi xünnak na yah khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Khyang naw khawmdeknu avan ka na lü, a ngmüimkhya xünnak am a yah üng i am ni a thawnei be thei kawm? ");
INSERT INTO dao_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Khyanga Capa, a pa hlüngtainak ja a khankhawngsä he am law be hnühki, khyang naküt cun khut a pawha kba jah kheng khai. ");
INSERT INTO dao_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Akcanga ka ning jah mthehki, “Ahin üng awmki he avang naw am thih ham u lü, Khyanga Capa Sangpuxanga kba law be se hmuh khaie,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Amhnüp khyuk käna Jesuh naw Pita, Jakuk ja a na Johan mcunga hlüngnaka a jah cehpüi. ");
INSERT INTO dao_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Acunüng Jesuh a hmai khawnghngia mäiha vai lü, a suisak pi akvai mäiha bawk lawki. ");
INSERT INTO dao_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Acunüng axüisaw kthum naw Jesuh cun Mosi ja Elijah naw ngthuheipüi ni se ami jah hmuh. ");
INSERT INTO dao_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Acunüng Pita naw Jesuh üng, “Bawipa aw, ahia mi ve vai hin daw ve. Na hlüei üng ta, nanga phäh mat, Mosia phäh mat, Elijaha phäh mat, sam kthum ka pha vai sü,” ti lü a mtheh. ");
INSERT INTO dao_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Acukba a pyen k'um üng, khawngmei bawk naw jah msung law lü, “Hin hin ka mhläkphyanak pipia ka Capa ni, ani üng ka jeki, a pyen ngai ua” tia, kthai cun ngmei üngka naw ngjakie. ");
INSERT INTO dao_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Axüisawe naw ami ngjak üng, aktäa kyühei u lü mce da ngmümkie. ");
INSERT INTO dao_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesuh naw law lü jah hnetki naw, “Tho law u, käh kyüei ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ami jeng mdei üng Jesuh amät däk ve se ami hmuh. ");
INSERT INTO dao_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mcung üngka naw ami kyum law be üng, Jesuh naw axüisaw he üng, “Khyanga Capa thihnak üngka naw am a thawh be hama küt üng nami hmuha mdannak hin u üng pi käh nami mtheh vai,” ti lü, a jah cük. ");
INSERT INTO dao_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Axüisawe naw Jesuh üng, “Acunüng ise thumksinge naw Elijah law ma khai ami ti ni? ti u se, ");
INSERT INTO dao_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesuh naw, “Akcanga Elijah cun law ma lü ahmäi jah pyang law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Acunüngpi ka ning jah mthehki, Elijah cun law pängki ni. Cunsepi am ksingki he naw ami ngaih ngaiha ami mkhuimkha, acukba bäa Khyanga Capa pi mkhuimkha khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Acunüng, axüisaw he naw Baptican Johana mawng jah mthehkia ami ksing. ");
INSERT INTO dao_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Khyang hea veia ami nghlat law be üng, khyang mat Jesuha veia law lü ngdängki naw, ");
INSERT INTO dao_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bawipa aw, ka capa mpyeneia! Kphyaw se aläa tui üng ngcum lü am ani üng mei üng lut lü khuikha ve.” ");
INSERT INTO dao_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","“Acunakyase, na xüisawea veia ka lawpüi kyaw amimi naw pi am mdaw be khawh ve u,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesuh naw, “Jumeinak am takia khyang ksee aw, ivei nami veia ka ve khai ni? Ivei ka ning jah msawkei vai ni? Kpamica ka veia lawpüi ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesuh naw khawyai jüi se kpamica üngka naw lut law beki. Acunja kpamica cun daw beki. ");
INSERT INTO dao_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Acunüng axüisaw he Jesuha veia ampyua law u lü, “Ise keimi naw am kami ksät khawh ni,” ti lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesuh naw, “Nami jumeinak a ngceka phäh ni, akcanga ka ning jah mthehki, anca ui teh jumnak nami tak üng, hina mcung üng ‘Caia ngpyawta’ nami ti üng ngpyawt khai. Ai pi, am nami pawh khawh käh ve khai,” ti lü, a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ahina ngkhaw cun ei jeihnak ja ktaiyünak am ni mkhüt khawh” a ti. ");
INSERT INTO dao_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kalilea ami ve üng Jesuh naw, “Khyanga Capa, khyang hea kut üng petnak vaia kcün pha lawki ni,” ");
INSERT INTO dao_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","hnim u se, amhnüp kthum üng tho law be khai,” ti lü jah mtheh se, axüisaw he aktäa vedamkie. ");
INSERT INTO dao_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kapenawm mlüh Jesuh ja axüisaw he ami law üng, temple khawn kawkie cun Pita veia law u lü, “Nami saja naw temple khawn am pe hlüki mä? ti lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita naw, “Ä, peki ni,” a ti. Pita im k'uma a luh üng, ‘Jesuh naw, “Sihmon Pita, ihawkba na ngaiki ni” Khawmdek Sangpuxange naw akhawn ami mkhäm üng, ua veia ni ami tä khawi? Khaw mahea veia mä, pekce khyang hea veia mä ami tä khawi? a ti, ");
INSERT INTO dao_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita naw, “Pekce khyang hea veia,” a ti. Jesuh naw Pita üng, “Acukba ani üng, khaw mahe naw akhawn pet vai am hlü.” ");
INSERT INTO dao_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Acunüngpi, akhawn am mi peta phäh ami mlung käh se khaia, tuia va cit lü nga va mkaiha. Akcüka na phaa nga lo lü a mka na phyen vai. Acunüng tangka mat na hmuh khai. Acun lo lü ka phäh ja na phäha temple khawn va pea,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Acuna k'um üng, axüisaw he a veia law u lü Jesuh üng, “U ja Khankhaw Pea a kyäp säih kawm?” ti lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Acunüng Jesuh naw hnasenca mat khü lü, ami maa a ngdüihsak. ");
INSERT INTO dao_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Akcanga ka ning jah mthehki, nghlat be u lü hnasena mäiha am nami ve üng Khankhaw Pe am pha hlawt uki.” ");
INSERT INTO dao_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Acunakyase, Khankhaw Pea a kyäp säih vai cun hina hnasenca mäiha a mlung mnemki ni a kyäp säih kawm. ");
INSERT INTO dao_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Aupi, ka ngming üng je lü hina hnasenca mäih dokhamki cun kei na dokhamki ni. ");
INSERT INTO dao_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Cunsepi, kei na jumkia hina hnasen mat, mkhyekat khaia kyukngtängsakia khyang cun a nghngü üng ksum khawp lü lia thuknak tuia xawtin hin a phäha daw bawk khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jesuh naw, “Khyang he jah mkhyekatsaki khawmdeka da se khawmdeknu hin ihlawka kyühei phyaki ni! Acuna mkhyekatnaka ngkhawe cun aläa thawn khai. Cunüngpi, mkhyekatnak vaia pawhkia khyanga phäh ihlawka kyühei phya khai ni. ");
INSERT INTO dao_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na kut am a ni üng na khaw naw a ning mkhyekatsak üng, kyükin lü xawtin kawpi. Na kut khaw küm se angsäia mulaia ning xawtina kdama ta, na kut khaw kaa angsäi xünnaka na ceh hin daw bawki ni. ");
INSERT INTO dao_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Acunkäna na mik naw a ning mkhyekatsak üng, kawihin lü xawtin kawpi. Na mik küm se mulaia ning xawtina kdama ta, na mik mat däng am angdäi xünnaka na ceh hin kyäp bawki ni. ");
INSERT INTO dao_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ahina hnasenca he käh jah hmuhmsit ua. Ami khankhawngsä he cun ka pa vei khankhawa awmki he ni, ti ka ning jah mthehki. ");
INSERT INTO dao_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Isetiüng ta, khyanga Capa hin khyükie jah thawngkhyah khaia lawki ni. ");
INSERT INTO dao_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ihawkba ni nami ngaih? Khyang mat naw toca aphya a tak üngka mat khyük se i pawh khai ni? A taw kawkip ja kaw jah hawih hüt lü khyükia taw mat sui khaia mcunga cit khai. ");
INSERT INTO dao_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Acun a hmuh be üng, veki kawkip ja kawa kthaka pi acuna khyüki mat a hmuh bea phäha aktäa jeki. ");
INSERT INTO dao_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Acukba kunga,hina hnasenca he üngka matca pi amdanga a khyüh vaia nami pa khana ka naw am hlüei. ");
INSERT INTO dao_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Na bena naw a ning mkhyekatnak üng, a veia cet lü a mkhyekatnak nanimäta ksinga a mkhyenak na mtheh vai, na mtheh a ngjak üng na mkhüta kyaki. ");
INSERT INTO dao_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Acunüngpi na mtheh am a ngjak üng, a mkhyekatnak angsingnak ksing khaia khyang nghngih mat bang jah cehpüi lü na ceh vai. Cangcim naw “Mkhyekatnak naküt üng saksiki nghngih kthum ve yah khai” a tia kba na pawh vai. ");
INSERT INTO dao_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Acunüng, acun hea pyen pi am a jah ngaih üng, avana sangcim üng nami sang vai. Akpäihnaka sangcima pyen pi am a ngaihsim üng khyang k'yu ja akhawnkawka nami ngaih vai. ");
INSERT INTO dao_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Akcanga ka ning jah mthehki, khawmdek khana nami mhlät naküt cun khankhawa pi mhläta kya khai, khawmdek khana am nami mhlät naküt cun khankhawa pi mhläta am kya. ");
INSERT INTO dao_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ka ning jah mtheh betüki, khawmdek khana aipi nghngih naw atänga ngaisim ni lü nani täsam üng, nani täsam naküt cun ka Pa khankhawa ka naw ning jah pawh pet khai. ");
INSERT INTO dao_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“Ahawia pi, nghngih kthum ka ngming üng ngcun u lü ami ve üng ami ksunga kei ka veki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Acunüng, Pita Jesuha veia law lü, “Bawipa aw, ka bena naw a na mkhyekatnak üng ivei ka mhlät vai ni? Khyüh vei aw?” ti se, ");
INSERT INTO dao_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesuh naw, “Khyüh vei am ni, khyühkip ja khyüh vei na mhlät vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Acunakyase, Khankhaw Pe cun Sangpuxang mat a mpyaea pupawng ngui jah bükteng lawki üng tängki ni. ");
INSERT INTO dao_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Acukba a jah teng law üng ngui tan xa k’hläih lei naki mat cun a veia ami lawpüi. ");
INSERT INTO dao_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngui a pu am thung be hlawt se Sangpuxang naw man lü amät mpyaa jawi lü,a khyuca he ja a khawhkhyam naküt pi jah jawisih lü, a lei ami thung vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Acuna mpya cun Sangpuxanga maa a mkhuk am ngdäng lü, “Ka Bawipa aw, na bä ni, na msawkei canga,” avan ka ning thung law be khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Sangpuxang naw mpyenei lü hläh be lü a lei naküt avan pi a mhlät. ");
INSERT INTO dao_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Acunüng, acuna mpya cun cit lü a püi mpyae üngka mat, ngui api a kpu a va hmuh. Man lü “Na pu na thung law bea” ti lü a k'aw üng a kbüh. ");
INSERT INTO dao_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A püi mpya naw a mkhuk am ngdäng lü, “Na mpyenei lü, na msawk canga, ka ning thung law be päih khai ni,” ti lü, a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Cunsepi, käh mpyenei lü am a thung be khawh vei thawng im üng a khyum. ");
INSERT INTO dao_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Acun cun mpya kce he naw ami hmuh üng aktäa ami mlung na se, Sangpuxang üng acuna mawng cun ami va mtheh u. ");
INSERT INTO dao_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Acunüng ami Sangpuxang naw khü lü, “Ia am na mawngki nang khyang kse, na nghui naki se na lei naküt ka ning mhlät. ");
INSERT INTO dao_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ka ning mhläta mäiha mpyeneinak na püi mpyaa khana pi na tak vai sü.” ");
INSERT INTO dao_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sangpuxang thüi lawki naw a mpya cun a lei naküt am a thung be khawh veia thawngim üng a khyum. ");
INSERT INTO dao_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Acukba bäa, khyang naküt naw nami mlungmthin kcang am nami benaa mkhyekatnak am nami mhlät üng khankhawa kaa Ka Pa naw pi nami mkhyekatnak am ning jah mhlät khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesuh ngthu a pyen päng ja Kalile üngka naw cit lü Jordan mliktuia caye Judah khawa citki. ");
INSERT INTO dao_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Khyangpänu naw läk law u se Jesuh naw acuia a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pharise he a veia law u lü ami mhnüteinak am, “Khyang mat naw a khyu ia phäha pi ni se a hlüeia kcün üng a hawih vai hin mi thum üng nglawiki aw?” ti lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesuh naw, “Akcüka jah mhnünki naw kpami ja nghnumi a jah mhnün ti hin am nami khe khawikie aw?” ");
INSERT INTO dao_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pamhnam naw ‘Kpami naw a nu ja pa jah ceh ta lü a khyua vei ngdawn se nghngih xawi cun mtisa mata kya law khai xawi’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Acunkäna, nghngiha am ni ti ni, mata kyaki. Acunakyase, Pamhnam naw a jah lu hlin khawsawm cun khyang naw käh jah mtai se,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pharise he naw, “Am ani üng ivaia Mosi naw ngkyanaka kca pe u lü hawih vaia a jah mtheh ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesuh naw, “Nami mlungmthin nghlang lü mtheh am ngja uki se, Mosi naw nami khyu nami hawih vaia a ning jah mtheh ni. Cunüngpi a jah mhnünceng üng acukba am ni” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Acunüng Jesuh naw, “Ka ning jah mthehki, aupi a khyu kpami kce am käh bäühma ni se akcea phäha hawih lü, khyu mah beki cun mkhyeki ni, acuna nghnumi khyu na beki pi mkhyekatki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Acunüng axüisaw he naw, “Acukba ani üng ta am khyu mah üng ni a daw hlü bawk ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesuh naw, “Ahina ngthu cun khyang naküt naw am ngaisim u. Acunüngpi, ngaisim khai hea a jah xü naw ni a mi ngaihsim hlü ve. ");
INSERT INTO dao_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Avang cun a nua puk'um üngka naw käh khyuca mah khai hea a jah mhnün, avang cun khyang naw käh khyuca mah khaia ami jah pyang, avange cun Khankhaw Pea phäh animät käh khyuca mah khai hea nghnüneikie, aupi khyuca mah khaia tängki naw ngaisim se,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jesuh naw Hnasenea khana a kut mtaih lü a jah ktaiyü pet vaia a veia jah lawpüi u se, axüisaw he naw ami jah ksenak. ");
INSERT INTO dao_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesuh naw, “Hnasene ka veia law u se, käh jah mah ua, Khankhaw Pe cun amimia mäiha phäh ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesuh naw hnasenea khana a kut mtaih lü acunkäna akcea citki. ");
INSERT INTO dao_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Khyang mat law lü, “Saja aw, khankhawa angsäi xünnak ka yah vaia akdaw i ja ka pawh kawm?” ti se, ");
INSERT INTO dao_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesuh naw, “I dawki ti ivai na na kthähki ni? Dawki ta mat däk ni a ve. Angsäi xünnak na yah hlü üng ngthumkhäne jah läklama” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Cawngpyang naw, “Ia ngthumkhäne ni? a ti. Jesuh naw, “Khyang käh na hnim vai, khyanga khyuca käh na mkhyekatnak vai, käh na mpyuk vai, käh na hleihlak vai,” ");
INSERT INTO dao_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Na nu ja na pa na jah leisawng vai, namät naw namät na jawngnaka mäiha na impei loceng na jawngnak vai,” a ti, ");
INSERT INTO dao_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Cawngpyang naw, “Ahin he cun ka dikca üngkhyüh ka jah läk päih ni, i ka pawh ham khai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesuh naw, “Na kümkawi vai na ngai üng, cit lü na tak naküt jawi lü sih mpyaki he üng ngui na jah yet vai. Acunüng khana na khawh vai ve khai, acunkäna na läk law kawpi,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cawngpyang naw acun a ngjak üng, pukse lü akcea citeiki. Isetiüng ani cun bawimangkia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Acunüng Jesuh naw axüisaw he üng, “Akcanga ka ning jah mthehki, bawimangki hin Khankhaw Pe a luh vai aktäa küi ve,” ");
INSERT INTO dao_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bawimangki Pamhnama Khaw a luha kthaka ta sanghngüksaü mpyüma nghnga khuia a luh vai jä bawki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Axüisawe naw ami ngjak üng aktäa müncan u lü, “Acunüng u naw küikyannak yah khawh khai ni?” ti lü ngthähkie. ");
INSERT INTO dao_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesuh naw jah teng lü, “Ahin cun khyanga phäha i am thawn thei lü pi Pamhnama phäha am thawn theiki am ve” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Acunüng Pita naw, “Tenga ahmäi naküt hawih lü kami ning läk lawki, kami ning läk law phäha i kami ngmangnak khai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesuh naw, “Akcanga ka ning jah mthehki, Tuha Khyanga Capa amäta hlüngtainak ja a bawingawhnak üng a ngawh law üng, nami na läk hlükie pi bawingawhnak xaleinghngih üng ngaw hnga u lü, Isarel paca xaleinghngih nami jah uk khai,” ");
INSERT INTO dao_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aupi keia ngminga phäh a ima pi kyase, a bena cinae pi kyase, a nu pa pi kyase, a ca hea pi kyase, a khawmdeka pi kyase, jah ceh taki cun acun kän cima aphya kthaka yah be lü, angsäi xünnak pi yah khai. ");
INSERT INTO dao_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Acunsepi akmae hnu u lü akhnuae ma law khaie,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Khankhaw Pe cun capyit ngvawng taki khyang mat am tängki ni. Ngawi mat üng a ngvawnga nghlawh khaie a jah ngvah vai sui hüki. ");
INSERT INTO dao_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mhnüp at üng tangka mat hlawhei khaia khyang he jah hmuh lü a capyit ngvawnga a jah tüih. ");
INSERT INTO dao_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Khawpyanga va cit hü lü ngnam k'uma amdanga veeikie jah va hmuh lü, ");
INSERT INTO dao_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Nangmi pi ka capyit ngvawnga cit lü va nghlawh hnga ua, ka ning jah khyeng khai,” ti se, citkie. ");
INSERT INTO dao_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Naji xaleinghngih mhnüpngsung ja mkeng naji kthum üng va cit lü pi acukba bäa jah va hmuh lü a ngvawnga a jah nghlawhsak. ");
INSERT INTO dao_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Acunüng naji mhma bang üng pi va cit hü lü amdamnga veeikie a jah hmuh üng, “Ivaia ahikba amdanga nami veeikie ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Acun he naw, “Jah ngvatki u am ve se va,” ami ti, acunüng ngvawngmah naw “Nangmi pi ngvawnga cit lü va nghlawh hnga ua” a ti. ");
INSERT INTO dao_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Acunüng khaw a mü law üng, ngvawngmah naw a lo ngängki üng, “Nghlawhkie ami van jah khü lü, anghnu säih üng cutei lü akma säih üng dütkia kami ngkheng jah pea,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Acunüng, mülam naji mhma üng cuteikie cun law u lü, ami khüi khen tangka mat ci do lawki he. ");
INSERT INTO dao_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Khüi makie cun law u lü khawhah yah khai hea ngai u se pi acukba bäa tangka mat ci däk yah hngakie. ");
INSERT INTO dao_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Acukba tangka mat däk ci ami do law hnga üng ngvawngmaha veia mtai law u lü, ");
INSERT INTO dao_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Anghnua lawki hine naji mat däk va khüikie, amhnüpa khawngling khamei lü kami khüikie am angteha na jah kheng,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ngvawngmah naw mat üng, “Ngaia ka püi, am ning mhlei nawng. Mhnüp mat khüi lü tangka mat hlawhei vai na jumki cen ta.” ");
INSERT INTO dao_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na ka ceh lü na ima cita. Hina anghnua lawki he üng pi nang üng ka pet kän ka pe hlüki. ");
INSERT INTO dao_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ka ngui cun kamäta ngjak hlüa am ka pawh thei khai aw? Käh ngvang na lü ka ning jah peta phäh na na mkeiki aw? ");
INSERT INTO dao_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Acunakyase, akmae hnu u lü, hnukie hma law khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesuh Jerusalem da cit lü axüisaw he xaleinghngih lam peia jah khü lü, ");
INSERT INTO dao_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ngai ua, Jerusalem da mi cit khai, acuia Khyanga Capa cun ktaiyü he ja thumksingea kut üng msuma kya khai. Amimi naw thi khaia mkatei khaie. ");
INSERT INTO dao_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Khyanga Capa cun yaihei u lü, kpai acun he, kutlamktung üng ami hnim vaia khyang mjü kce hea kut üng msum acun he. Acunüngpi amhnüp kthum üng tho be khai,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Acunüng, Zebedea khyu, a cakpa xawi maha Jesuha veia lawki. A mkhuk üng ngdäng lü iyaw täeiki. ");
INSERT INTO dao_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesuh naw, “I ja na ngjak hlü?” a ti. Nghnumi naw, “Hina ka cakpa xawi, Sangpuxanga na thawn law üng, mat na khet da, mat na kcawng da ngaw khai xawia bekhüt na pea,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesuh naw, “I nami tä hman am ksing niki. Ka awk law vaia khawt, nani aw khawh khai aw? Baptican ka khan law vai, nani khan khawh khai aw?” ti se, “Ä, yah khai,” ani ti. ");
INSERT INTO dao_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesuh naw, “Ka awk vaia khawt na awk khawh üng pi, ka khet da ja kcawng da nani ngawh vai cun keia xü thei am ni. Ahina ngawhnak cun ka Pa naw a jah xüea phäha kyaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Axüisawe xa naw ami ngjak üng, acuna ngbengna xawi cun jah thüinakie. ");
INSERT INTO dao_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesuh naw axüisaw he alanga jah khü lü, “Nami ksinga mäiha, khyang mjü kce hea bawie cun khyang hea khana aktäa bawi u lü, aktäa ami ana sumeikie.” ");
INSERT INTO dao_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Cunsepi, ahina mäih nangmi üng käh ve se, nangmi üngka mat a kyäp säih vai ngja hlüki ta nami mpyaa kya se. ");
INSERT INTO dao_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nangmi üngka mat akma säih vai ngja hlüki ta nami mpyaa thawn se. ");
INSERT INTO dao_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Khyanga Capa cun khyanga khüih vaia am law; khyang khüih lü a xünnak jah pe lü khyang khawkän jah thawng khaia a lawa mäiha, nami ve vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesuh ja axüisaw he Jerikho mlüh üngka naw ami ceh üng khyangpänu naw jah läki he. ");
INSERT INTO dao_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Amikmüki nghngih lam peia ngawhki xawi naw Jesuh lam üng citki tia ani ngjak üng ngpyang ni lü, “Davita Capa, Bawipa aw, jah mpyeneia,” ti lü ngpyangki xawi. ");
INSERT INTO dao_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Khyangpänu naw käh ani ngpyang ti vaia jah mtheh u sepi, aksetama, “Davita Capa, Bawipa aw, jah mpyeneia,” ti lü ngpyang dämdämki xawi. ");
INSERT INTO dao_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesuh naw ngdüi lü, “I ka ning jah pawh pet vai ni nani hlüei,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Anini naw, “Bawipa aw, kani mika vai be vai ngaih ve ning,” ani ti. ");
INSERT INTO dao_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesuh naw jah mpyenei lü ani mik a jah hneh pet. Acunja ani mik vai law be se, Jesuh läki xawi. ");
INSERT INTO dao_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesuh ja axüisaw he Jerusalema law u lü Olip mcung, Betphake ngnam ami pha law üng Jesuh naw, “Axüisaw xawi nghngih maa jah na tüih lü, ");
INSERT INTO dao_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nani maa vekia ngnama cit ni lü, sanghngaksaü mat ja, a ca ami jah kphung nani hmuh khai. Jah sut ni lü ka veia nani jah lawpüi vai.” ");
INSERT INTO dao_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Khyang naw a ning jah kthäh üng, “Bawipanaw jah hlüei ve,” nani ti vai. Acunüng angxita ning jah tüih law khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ahin avan cun sahma naw a na pyen law, ");
INSERT INTO dao_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion mlüh üng mtheh ua, Tenga, na Sangpuxang na veia law ve! Ani cun a mlung nem lü sanghngaksaü, ja sanghngaksaüca xawia khana ngcumki,” ti akümkawinak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Acunüng, axüisaw xawi naw cit ni lü, Jesuh naw a jah mtheha mäiha ani va pawh. ");
INSERT INTO dao_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sanghngaksaü ja a ca cun jah lawpüi u lü, ami suisake a khana jah mtaikie naw, Jesuh cun a khana ami ngawhsak. ");
INSERT INTO dao_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Khyangpänu naw ami suisak lama ami jah phah üng, avang naw nghleng hnahe jah ksawm u lü jah phahkie. ");
INSERT INTO dao_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Khyangpä a ma a na citkie ja amät läki he naw, “Hosana Davita Capa, Bawipa ngming am lawki josennak be se! A hlüngnak säih khankhawa Hosana,” ti lü, ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalem a pha law üng, mlüh üngka ami van üicai u lü, “Ani u ni?” ti lü pyenkie. ");
INSERT INTO dao_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Khyangpänu naw, “Hin cun sahma Jesuh, Kalile hne, Nazaret mlüh üngka ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesuh Temple k'uma lut lü Temple k’uma jawitukie ja kheikie jah sät lü tangka mhlaikie ja müm jawikiea ngawhnake, avan a jah hukxänin. ");
INSERT INTO dao_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Acunüng Jesuh naw, “Cangcim üng, ‘Ka im cun ktaiyünak ima sui khaie’ ti lü ng’yuki, nangmi naw mpyukeiea ngthupnak ima pyang ve uki” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Amikmü ja akxoe, temple k'uma law u se Jesuh naw a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ktaiyü ngvaie ja Thum mtheie naw müncanksee a pawhmsah ja, hnasene naw, “Hosana Davita Capa,” ti lü, ami ngpyang hmuh u lü aktäa ami mlung soki. ");
INSERT INTO dao_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesuh üng, “Amimi naw i pyenkie ti na jah ngjaki aw?” ami ti. Jesuh naw, “Ä, hnasene ja cihtui k’aw naca hea mpyawng üng mhlünmtainak na yahki ni,” ti lü ng’yuki am nami khe khawiki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesuh naw jah hawih hüt lü Bethanih mlüha cit lü acuna mthan cun acuia ipki. ");
INSERT INTO dao_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ngawilama mlüh da a nghlat law be üng, a ei ngaih lawki. ");
INSERT INTO dao_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kthei thing lam peia hmu lü kthei thing da cit kyawki, am ngthei lü a hnah däk ve se a hmuh. “Käh ngthei ti sümsüm kawpi,” ti se, acunüng kthei thing cun ngjai lü thiei lawki. ");
INSERT INTO dao_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Axüisawe naw acun ami hmuh üng, “Ihawkba Fik dung akjangnua khyawngei lawki ni?” ti lü müncankie. ");
INSERT INTO dao_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesuh naw jah msang lü, “Akcanga ka ning jah mthehki, jumei kcang lü mlung hlawthlatnak am nami tak üng hina Fikdung däk am ni lü, hina mcung üng, ‘Hin üngka naw ngnawn lü mliktuia kya se’ nami ti üng nami tia mäiha kya khai.” ");
INSERT INTO dao_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nami jumei üng nami täsam naküt nami yah khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Templea law be lü a jah mthei k'um üng, ktaiyü ngvaie ja a xüe a veia law u lü, “Ahin he jah pawh vaia ia ana ja na tak? U naw ahin he na jah pawhak vai ana a ning pet ja?” ti lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesuh naw jah msang lü, “Kei pi mat däk ka ning jah kthäh khai. Nami na msang üng, kei naw pi ahin he ka jah pawhnak vaia ia ana ka tak cun ka ning jah mtheh khai.” ");
INSERT INTO dao_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Johana a baptican hin hawia khyüh lawki ni? Pamhnam üngkhyüh mä. Khyang üngkhyüh mä” a ti. Amimäte naw ngcuh u lü, “I mi ti khai ni. Pamhnam üngka naw ni” mi ti üng mä, “Ise Johan am nami kcangnaki ni,” ti hlü kbak. ");
INSERT INTO dao_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Khyang üngka naw” mi ti üng pi khyang he naw i ami pawh vai ti kyühei phyaki. Isetiüng, khyang avan naw Johan cun sahma mat ti ksingki he,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jesuh üng, “Am ksing ve u nawng,” ami ti. Jesuh naw, “Kei pi ia ana am ka pawh ti am ning jah mtheh hlü veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ihawkba nami ngaiki ni? Ahlana nghngih canaki khyang mat veki. Akdäma veia cit lü, “Ka ca aw, tuhngawi ngvawnga cit lü va khüia,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A ca naw, “Kaa! am cit hlü veng,” a ti kyaw, akäna a mlung nglat law be lü citki. ");
INSERT INTO dao_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Acunüng anghngihnaka veia cit lü acukba bäa a mtheh. Ani naw, “Ä ja, cit kawng,” ti lü am cit. ");
INSERT INTO dao_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ahin xawi üng u naw ni a paa ngjakhlü a pawh?” a ti. Amimi naw, “Akdäm ni,” ami ti. Acunüng Jesuh naw, “Akcanga ka ning jah mthehki, akhawnkawke ja nghnumi ksee nami maa Pamhnama Khawa lut ve u.” ");
INSERT INTO dao_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Isetiüng ta Baptican Johan lam kdaw ning jah mhnuh khaia law se am jumei uki; cunsepi, akhawnkawke ja nghnumi ksee naw ani jumkie. Acun nami hmuh käna pi ngjut lü am jum uki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesuh naw, “Msuimcäpnak akce ngai betü ua: khyang mat ngvawngmah veki, acun naw capyit ngvawng pyang lü ngvawng lü capyittui suinak vai khui co lü, ngängnak vai kyäng a sak. Khüikie üng jah khah lü athuknaka khaw kcea kdungki. ");
INSERT INTO dao_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Capyit angtheih lawa kcün üng, amäta hama capyit ngthei kbit khai hea a mpyae ngvawng ngängkiea veia a jah tüih. ");
INSERT INTO dao_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngvawng ngängkie naw ngvawngmaha a mpyae jah man u lü mat ami kpaih, mat ami hnim, mat lung am ami vawih. ");
INSERT INTO dao_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Acunüng ngvawngmah naw akcüka kaa kthak nungkia, a mpya kce he a jah tüih betü. Acunsepi acukba kunga ami jah na pawh betü. ");
INSERT INTO dao_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Akpäihnaka amäta ca, “Ahin ta leisawng khaie ni, am pawh hngaläk u” ti lü a tüih betü. ");
INSERT INTO dao_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cunsepi ngvawng ngänge naw ami hmuh üng, “Hin hin ngvawngmaha ca va ni kbak. Law ua mi hnim lü a khawh mi bi vai u,” ti u lü, ");
INSERT INTO dao_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","man lü ngvawng kpunga xawt lü ami hnimin u. ");
INSERT INTO dao_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Tuh ta ngvawngmah a law üng, ngvawng ngängkie cun ihawkba jah pawh khai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Msang u lü, “Acuna khyang ksee cun jah hnim khaia ngsing ve. Ngvawng pi capyit angthei law kcün üng, tha law khai hea khyang kce he üng jah khah khai,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesuh naw “Cangcim naw a pyen am nami khe khawikie aw? “Imksae naw am daw se ami hawiha lung cen, akdaw säih lunga thawn law khawiki. Ahin cun Bawipa naw a pawha kyaki, ahin cun müncan vaia kyaki, ihlawka müncan phyaki ni!” ");
INSERT INTO dao_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Acunakyase, ka ning jah mthehki, “Pamhnama Khaw ning jah hut lü ngtheisak pungpyahsak khaia khyang he üng jah pet vai. ");
INSERT INTO dao_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Aupi, hina lung üng kyaki cun khuikhaiei khaia bo vai. Ahina lung naw a kyaknak cun mput khuia thawn khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ktaiyü ngvaie ja Pharise he naw acuna msuimcäpnak cun ami ngjak üng, amimi a jah tinak ti ksingki he. ");
INSERT INTO dao_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Acunüng, man khai hea ami bü. Cunsepi Jesuh cun sahma tia jumeikia khyangpänu ami jah kyüh. ");
INSERT INTO dao_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesuh naw msuimcäpnake am khyang he üng a jah mtheh betü. ");
INSERT INTO dao_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Khankhaw Pe cun a capaa phäh cambum khaia ngtünki Sangpuxang mat am tängki. ");
INSERT INTO dao_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“Cambumnaka law lü buh pawi bükei law khai khine jah khü khai hea a mpyae a jah tüih, cunsepi, am law hlü u. ");
INSERT INTO dao_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Acunüng, a mpya kce he jah tüih betü lü, “Müei vai pyang päng ni, ka semce ja khyükseie akthaü säih jah hnim veng, ahmäi küm päng ve, cambumnaka law ua,” ti lü khine üng jah mtheh u bä’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Cunsepi, khine naw käh cuhlihei u lü animäta khut pawh khaia citei hükie: mat a loa cit lü, mat betü kdungei hüki. ");
INSERT INTO dao_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Avang naw Sangpuxanga mpyae jah man u lü jah kpai lü ami jah hnim u. ");
INSERT INTO dao_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Acun Sangpuxang naw a ngjak üng thüi lü a yekape a jah tüih. A mpyae jah hnimkie cun ami van jah hnim lü ami mlüh pi mei am a jah mkhih pet. ");
INSERT INTO dao_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Acunkäna a mpyae jah khü lü, ‘Cambumnak pyang päng ni, cunsepi, jah cükeia khyang he ei khaia am ngkawih ve u. ");
INSERT INTO dao_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","‘Tuh ta lamnuea cit hü u lü nami hmuh naküt jah va khü hü ua’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Acunüng, a mpyae cun lam naküt üng cit hü u lü, ami hmuh naküt akdaw akse jah mkhäm lü jah lawpüi u se, cambumnaka im cun khin am beki. ");
INSERT INTO dao_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sangpuxang cun khine jah bükteng khaia im k’uma a law üng, khin mat cambumnak suisak am jihki a hmuh. ");
INSERT INTO dao_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“Sangpuxang naw, ‘Ka püi aw, ihawkba, cambumnaka suisak am jih lü na lawki ni?’ a ti. Cunsepi acuna khyang naw i pi am ti be. ");
INSERT INTO dao_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Acunüng, Sangpuxang naw a mpyae üng, ‘A kutkhawe jah pinpawk lü anghmüpnaka xawt ua. Acuia a mni cui hakyetnak am kyap khai’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Jesuh naw, “Khüa khyang da kyaw lüpi xüa khyang ngcek ve” a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Acunüng, Pharise he naw a ngthähnak am Jesuh man vaia lam sui lü cengkie. ");
INSERT INTO dao_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pharise he naw ami hnukläke avang ja Heroda hnukläke avang Jesuha veia jah tüih u lü, “Saja aw, nang cun akcang na pyenki ti kami ksingki. Akce he naw ihawkba ngai khaie ti käh cäi na lü, Pamhnam naw khyang he a jah ngjak hlüa mawng khyüngtak na jah mtheiki. Isetiüng nang cun naw ua mikhmai pi am tengki. ");
INSERT INTO dao_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","“Ihawkba na ngaih jah mtheha? Mi thum naw Empero üng akhawn pet vai hin nglawiki aw, am nglawiki aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Acunsepi, Jesuh naw ami ngneikse jah ksing lü, “Hypocrite aw, ise nami na mhnüteikie ni? ");
INSERT INTO dao_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","“Akhawn ngui hawia ni? Na mhnuh ua” a ti. Acunüng tangka mat a veia ami lawpüi. ");
INSERT INTO dao_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Acunüng, Jesuh naw, “Hin hin ua lup ja ua ngming ni a ve?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Empero ni,” ami ti. Acunüng Jesuh naw, “Acukba ani üng, Empero üng sängeiki Empero üng pe ua, Pamhnam üng sängeiki Pamhnam üng pe ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Acun ami ngjak üng, müncan u lü akcea ami ceh tak. ");
INSERT INTO dao_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Acuna mhnüp üng, khyang kthi am tho be khawi u tiki Sadukee avang Jesuha veia lawki he. ");
INSERT INTO dao_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Saja aw! Mosi naw khyang mat am ca lü a thih üng, a na naw khäm be lü a casak vai. Acunüng akthia caa ngai vai,” a ti ni. ");
INSERT INTO dao_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Tuh a bena khyüh xüngkie, a khyu hmeinu cun a na naw a khäm be. ");
INSERT INTO dao_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","“Acukba bäa anghngihnak ja akthumnak pi am ca u lü, akhyühnak cäpa thih päihkie. ");
INSERT INTO dao_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","“Akdüta acuna nghnumi pi thiki. ");
INSERT INTO dao_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Acunakyase, thikie ami thawh law bea mhnüp üng, acuna nghnumi cun ngbengna khyüh üng ua khyua kya khai ni? Angtu naw ami khyunak” ti lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesuh naw jah msang lü, “Nami mkhyekie ni! Cangcim ja Pamhnama khyaihbahnak am nami ksinga phäh ni. ");
INSERT INTO dao_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","“Akthie ami thawh law bea mhnüp üng, amimi cun khankhawa khankhawngsä hea mäiha am ngkhyungla ti u. ");
INSERT INTO dao_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Pamhnam naw nami veia akthiea thawhnak bea mawng a pyen am nami khe khawikie aw? ");
INSERT INTO dao_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kei Abrahama Pamhnam, Isaka Pamhnam, Jakopa Pamhnam’ Pamhnam cun akthiea Pamhnama am ni, akxüngea Pamhnam ni,” ti lü, a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Acun khyangpäe naw ami ngjak üng, a jah mtheimthang cun müncan nakie. ");
INSERT INTO dao_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Acunüng, Sadukee jah mkhütki ti, Pharise he naw ami ksing üng alanga ngcun law u lü, ");
INSERT INTO dao_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ami ksung üngka mat, thum ksingki naw kthähnak üng man vaia ngtängki. ");
INSERT INTO dao_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Saja aw, i ni Mosia thum üng akü säiha ngthupet cun?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesuh naw, “Na Bawipa Pamhnam cun na mlung avan, na ngmüimkhya avan, ja na ksingnak avan am na mhläkphyanak vai.’ ");
INSERT INTO dao_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","“Ahin cun akdäm säih ja akü säiha ngthupeta kyaki. ");
INSERT INTO dao_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","“Anghngihnak cun: ‘Na impei loceng namät na kphyanaka mäiha na kphyanak vai.’ ");
INSERT INTO dao_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“Ahina ngthupet nghngih üng Mosia thum naküt ja sahma hea mtheimthang naküt avan phungki ni,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Acunüng, Pharise he avang ami ngcun law üng Jesuh naw jah kthähki. ");
INSERT INTO dao_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mesijah hin ia ni nami ngaih? Ua ksawn üngka ni?” a ti. “Ani cun Davita ksawn üngka ni,” ti lü ami msang. ");
INSERT INTO dao_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","‘Acunüng Jesuh naw, “Ise ngmüimkhya naw Davit üng “Khritaw cun Bawipa aw” ti lü a khüsak?” Davit naw pyen lü, ");
INSERT INTO dao_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bawipa naw ka bawipa üng a mtheh ta: ka khet da ngawa na yee na khawa kea am ka jah taka küt üng” a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Davit naw Khritaw üng Bawipa ti lü a khü üng, ihawkba Mesijah cun Davita ksawn thei vai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","U naw pi ngthu mkhap matca am pi am msang be u. Acuna mhnüp üngka naw cutei lü u naw i pi am kthäh ti u. ");
INSERT INTO dao_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Acunüng, Jesuh naw axüisaw he ja khyangpäe jah mthehki. ");
INSERT INTO dao_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Thum mtheie ja Pharise he Mosia ngawhnak üng ngawkie. ");
INSERT INTO dao_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","“Acunakyase, aipi ami ning jah mtheha mäiha nami ve vai, cunsepi ami pawh käh nami jah läkei vai. Ami pyena mäiha i am pawh khawi u. ");
INSERT INTO dao_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Aktäa yüh lü phüi sekia phüih pyang u lü khyanga ngkyang üng mtaihkie. Amimät naw ta ami kut mdawngca am pi am hnet hlü u. ");
INSERT INTO dao_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Khyang he naw ami jah hmuh hmuh vaia khut pawhkie. Cangcim üng a vea kba; khyang naw ami jah münnak vaia, ami mcea sawm lü ami ban ami pinnak mehvun yüiteng ua. ");
INSERT INTO dao_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Eiawknak pawia adawnak säih ngawhnak üng ngaw hlükie. Sinakoka pi akdaw säiha ngawhnak üng ngawh vai jawngnakie. ");
INSERT INTO dao_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","“Jawihtuknaka pi ami jah leisawng vai, ‘Saja aw’ ti lü jah khü vai jawngnakie. ");
INSERT INTO dao_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Nangmi naw ta ‘Saja aw’ ti lü ami ning jah khü vaia käh ve ua. Isetiüng ta, nangmi cun avan tängei u lü Saja pi mat ni nami tak. ");
INSERT INTO dao_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“Khawmdek khana u pi, ‘Pa aw,’ ti lü käh khü ua. Isetiüng ta nami pa mat däk khankhawa veki ni. ");
INSERT INTO dao_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Mkhawnga ami ning jah khü vaia käh ve ua. Isetiüng ta, nami mkhawng cun Mesijah mat däk ni. ");
INSERT INTO dao_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Nangmi üng kyäp säihki cun nami mpyaa kya yah khai. ");
INSERT INTO dao_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","“Aupi, amät mhlünmtaieiki cun nem säih khai, amät mhnemeiki cun mhlünmtaia kya khai. ");
INSERT INTO dao_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nangmi thumksinge ja Pharise he, hypocrite aw, nami jo se ve. Isetiüng ta, khyang hea maa Khankhaw Pe ksawh khai ve uki, nanimät pi käh lut u lü lut khaie pi nami jah mkhyawhki. ");
INSERT INTO dao_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Thum mtheie ja Pharise he, nangmi hypocrite aw, nami jo se ve. Isetiüng ta, hmeinue jah ei aw u lü ami im nami jah huteiki. Mkhyekatnak am a ngdangnak vaia, khawvei veia nami ktaiyüki. Acunakyase, ksehlen bawkia mkatnak nami khamei khai. ");
INSERT INTO dao_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Thum mtheie ja Pharise he, nangmi hypocrite aw, nami jo se ve. Isetiüng ta, Judahea jumeinak üng khyang matca a law vaia tuilawng khawkawng naküt lümkan lü nami cit hüki. Ngpyawt lawki pi namimäta kthaka anghngiha Mulai Pea nami cehsaki. ");
INSERT INTO dao_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Khyang mikmüe aw! nami jo se ve, “Aupi Temple be lü ng’yünceki cun amdang ni, aupi Temple üngka xüi be lü ng’yünceki cun a pyena mäiha kyaki ni,” nami tiki. ");
INSERT INTO dao_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Amikmü yawk’ange aw, i ja adaw bawk? Xüi mä a daw bawk? Xüi ngcimsakia Temple mä a daw bawk? ");
INSERT INTO dao_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Kpyawngkung be lü ng’yünceki cun amdang ni, kpyawngkunga khana peta petmsawt be lü ng’yünceki cun a pyena mäiha kyaki ni,” ti lü nami jah mtheiki. ");
INSERT INTO dao_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Ihlawka nami mik müki ni, i ni a daw bawk? Petmsawt mä a daw bawk? Acuna petmsawt ngcimcaihsakia kpyawngkung mä a daw bawk? ");
INSERT INTO dao_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Acunakyase, kpyawngkung be lü ng’yünceki cun acuna kpyawngkung ja a khana vekia petmsawte, avan be lü ng’yünceki ni. ");
INSERT INTO dao_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Temple be lü ng’yünceki cun acuna Temple ja a khuia veki Pamhnam be lü ng’yünceki ni. ");
INSERT INTO dao_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","“Khankhaw be lü ng’yünceki cun Pamhnama ngawhnak ja acunüng ngawki be lü ng’yünceki ni. ");
INSERT INTO dao_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Thum mtheie ja Pharise he, nangni hypocrite aw, nami jo se ve. Thingkthei yawpai ja tawikxüng ankseie xa üng mat nami peki. Acunsepi, aktung bawk thum üng jah läklam vai: ngsungpyunkia bilawhnak, mpyeneinak ja cingcainake jah hawihinkie. Ahin he cun käh jah hawih lü nami jah läklam vai. ");
INSERT INTO dao_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Lam msümki khyang mikmüe aw, mkhoyang mat pi käh pa khaia tui mcim u lü sanghngüksaü nami mjaweiki. ");
INSERT INTO dao_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Thum mtheie ja Pharise he, nangni hypocrite aw! nami jo se ve. Isetiüng, khawt ja kbe a kpung nami mthiki, a k’uma hleihlaknak ja ngtawngeinak am beki ni. ");
INSERT INTO dao_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“Pharise mikmüe aw, khawt ja kbe a ngcim vaia a k’um mthi ma ua. Acunüng a kpung pi ngcim hnga khai ni. ");
INSERT INTO dao_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Thum mtheie ja Pharise he, nangni hypocrite aw, nami jo se ve. Isetiüng ta, nangmi cun ng'utnak lungdü akbawk, a kpunga angtoa ngdang lü a k’um yuhe ja yawk kthue am be lü mtüihkhehki am nami tängki. ");
INSERT INTO dao_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","“Acukba nangmi pi akpunga khyang naküta veia ngsungpyunkia mäiha nami ngdangki, acunsepi nami mlung k’uma Pamhnam khut pawhkia nami ngsaihnak ja am dawkia ngaihnak mkhyekatnak beki. ");
INSERT INTO dao_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Thum mtheie ja Pharise he, nangmi hypocrite aw, nami jo se ve. Isetiüng ta, sahma hea mkhya ime jah sa u lü akdawa xüng lü awmki hea phäh yepim nami saki. ");
INSERT INTO dao_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","“Mi pupaea kcün üng, mi na ngtüi law hngaa ta, sahma he ami jah hnimnak üng am mi na bawibeng hnga khai sü,’ nami tiki. ");
INSERT INTO dao_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Acunakyase, sahma hnimkia ksawna nami kya cun nami ksingki ni. ");
INSERT INTO dao_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","“Nami pupaea mkhyekat nami kpha vaia nangmi pi mkhyekat betü ua. ");
INSERT INTO dao_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Nangmi kphyue ja kphyua ca he aw, mulai nami cehnak vai üngka naw ihawkba nami lät thei khai ni? ");
INSERT INTO dao_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Acunakyase, cangcim üng a na pyen khawi cun, ‘Sahmae, khyang ktheme ja, ngthungcim ksinge, ka ning jah tüih law pet khai. Avang nami ja hnim khai, avang kutlamktung üng nami jah taih khai, avang sinakok k’uma jah kpai u lü, mlüh mat üngka naw mlüh mata cit lü nami jah mkhuimkha khai. ");
INSERT INTO dao_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Acunakyase, khyangdüng Abelaha thisen üng tün lü, Temple k'uma ja, Temple ja kpyawngkunga nglaka nami hnim Barakiha capa Zakhariha thisen cäp, ja khawmdek khana khyangsungpyune, ami jah hnim naküta thisen cun nami khana pha khai. ");
INSERT INTO dao_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Akcanga ka ning jah mthehki, khyang hnima phäh ksükcetnak avan cun tuh ka khyang hea khana pha law khai! ");
INSERT INTO dao_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Aw Jerusalem, Jerusalem, sahma he jah hnim lü na veia ami jah tüih law khyang he lung am na jah vawiki aw! Ainu naw, a ca he a ngphya keha a jah mkhäma kbaa, khawvei na canae jah mkhäm be vai ka ngaihki? Cunüngpi, acun am na jumki. ");
INSERT INTO dao_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","“Acunakyase Na temple cun axawnga na veia ning hawih peta kya ve. ");
INSERT INTO dao_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“Ka ning jah mthehki, tuh üngkhyüh ‘Bawipa ngming üng lawki Pamhnam naw josennak be se’ am nami tia küt cäpa, ka hmai am na hmu ti uki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesuh Temple üngka naw akcea a ceh üng, axüisaw he naw Temple ime mhnuh khai hea a veia lawki he. ");
INSERT INTO dao_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesuh naw, “Hin avan nami jah hmuki am niki aw? Akcanga ka ning jah mthehki, lung matca pi, hin üng am ve khaia a pyehnak vaia kcün pha law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Olip mcunga khana a ngawh üng axüisaw he ampyua law u lü, “Itüha, acukba thawn law khai ni? Na lawnak vaia akcün ja akpäihnak kcün msingnak vai cun i ni? Jah mtheha” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesuh naw, “U naw pi käh a ning jah mhleimhlak vaia mceiei ua. ");
INSERT INTO dao_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Khyang khawkän ka ngming üng law lü, Keia hana ngsaih lü ‘Kei, Khritaw ni’ ti lü khyang khawhah jah mhlei law khaie. ");
INSERT INTO dao_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Nami peia ngtuknake kthaie ja athuknaka pi ngtuknaka thange cun nami jah ngja law khai. Cunüngpi käh cäicing kawm uki. Acuna ngkhawe cun thawn law khaie, cunüngpi akcüna päihnak tinak am ni. ");
INSERT INTO dao_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Pee mat ja mat, pungnu mat ja mat, ngtung’at law khaie. Mdek alum üng, khaw jaw khyat pai law khai, ngkhyü ngsün law khai. ");
INSERT INTO dao_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","“Ahin he cun na hmi hlüki a huiheia mäiha khuikhanakea cuteinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Acunüng ning jah man u lü ami ning jah mkhuimkha vai ja ami ning jah hnim vaia khyang hea kut üng ning jah ap khaie. Khyang naküt naw keia phäh ning jah hneng khaie. ");
INSERT INTO dao_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","“Acuna kcün üng khyang khawhah naw ami jumnak hawih u lü mat ja mat nghneng law khaie, hleihlak law khaie. ");
INSERT INTO dao_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Sahma ksee po law u lü khyang khawhah jah mhleimhlak law khaie. ");
INSERT INTO dao_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“Am dawkia khut pawhnak da law lü mhläkphyanak ng’yeng law khai. ");
INSERT INTO dao_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","“Cunsepi, adütnak vei cäpa jumeiki naw küikyannak yah khai. ");
INSERT INTO dao_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Khankhaw Pea mawng thangkdaw cun khawmdek van üng sang lü khyang naküta veia saksia mdanga kya khai. Acun käna akcüna päihnak pha law khai. ");
INSERT INTO dao_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Sahma Danjelah naw cangcim üng a pyena kba, ‘Kpyükpye theiki kyükyawkse angcimcaihnak säiha ngdüi se, nami hmu khai. ");
INSERT INTO dao_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Acunüng Judaha veki naküt mcungea dawng u se. ");
INSERT INTO dao_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","“Mkhyung khana veki im k’uma a ka lo khaia käh kyum law se. ");
INSERT INTO dao_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","“Loa veki naw pi a suisak loei khaia käh nghlat be se. ");
INSERT INTO dao_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Acuna mhnüp üng mpyaikie ja cihtui k’aw naca kpawmeikie ta aktäa khuikha khaie ni. ");
INSERT INTO dao_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Nami dawngnak vaia mhnüp cun khawksik khya ja Sabbath mhnüpa käh a kya vaia Pamhnama veia ktaiyü ua. ");
INSERT INTO dao_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“Khawmdek a ngtüi üngkhyüh am hmuh khawi, malama pi am hmuh be ti vai khuikhatnak kyühkse cun pha law khai. ");
INSERT INTO dao_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Khawmhnüpe cun Pamhnam naw a jah tawisak päng ni; am a tawisak vai sü üng, u pi xüng khai am ve. A jah xüa khyang hea phäh Pamhnam naw khawmhnüpe cun jah tawisak khai. ");
INSERT INTO dao_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Hia ni Khritaw, cuia ni Khritaw’ tiki a ve üng, käh nami kcangnak vai. ");
INSERT INTO dao_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“Isetiüng ta, Khritaw kcang am nikie ja sahma ksee po law khaie. Pamhnama jah xü khyang he pi a thawn theia ta, ami jah mhleinak vaia müncanksee pi jah pawh law khaie. ");
INSERT INTO dao_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Ngai ua, akcün am a pha law ham üng ma lü ka ning jah mtheh päng ni. ");
INSERT INTO dao_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Acunakyase, ‘Mesijah cun khawmkyanga ni’ ami ti üng käh nami ceh vai! Ani cun ‘Angthupnaka ve ve’ ami ti üng pi käh jah kcang na ua. ");
INSERT INTO dao_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“Nghngilaw da mlaih se khawkyak cäpa khaw a vaia kba, Khyanga Capa cun law be khai. ");
INSERT INTO dao_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ahawia pi akthia venaka, langktahe ngcun khaie ni. ");
INSERT INTO dao_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Acuna, khuikhatnaka mhnüpe käna, khaw nghmüp law khai. Khyalawn pi am vai law ti. Aisie khankhaw üngkhyüh kya law khaie, khankhaw khyaihbahnake pi ami venak üngka naw jah ksät khai. ");
INSERT INTO dao_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Acunüng khyanga Capa msingnak cun khana ngdang law khai. Khawmdek khyang naküt Khyanga Capa hlüngtai kyäpsawknak am khana khawngmei ngcum lü law be se, hmu u lü kyap khaie. ");
INSERT INTO dao_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","“Pungnu tum lü a khankhawngsä he naw a xüe cun khawmdek avan üng jah mkhäm hü be khai hea jah tüih law khai. ");
INSERT INTO dao_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Hina Fikdung üngka naw ngtheingthang ua. A kpyange tawi law u lü a hnah a hlip law üng, khawkhye cäh lawki ti, nami ksingki he. ");
INSERT INTO dao_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","“Acuna kba ni, nangmi naw ahin he nami jah hmuh üng, akcün cäh law lü mkawt pei pha lawki ti ksing ua. ");
INSERT INTO dao_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Akcanga ka ning jah mthehki, tukbäih ksawn üng khyang he am ami thi päih ham üng acun he avan cun kümcei law khaie ti süm ua. ");
INSERT INTO dao_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","“Khawmdek ja khankhaw khyük ni sepi, ka khyü nglung matca pi a kümcei kaa käh khyük yah khai. ");
INSERT INTO dao_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Acuna mhnüp ja akcün cun iti üng pha law khai ti, u naw pi am ksing. Khankhawngsäe naw pi am ksing u. Capanaw pi am ksing. Ka pa däk naw ni a ksing. ");
INSERT INTO dao_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Khyanga Capa a law be vai cun Nawea kcün üngkaa mäiha kya law khai. ");
INSERT INTO dao_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","“Mlikpitui am a phu law hama kcüne üngka naw Nawe mlawng k’uma a luh vei cäp, khyang he cun ei awkie, nghnumi ja kpami ngkhyunglakie; ");
INSERT INTO dao_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","“Mlikpitui phu law lü khyang avan a jah cehin vei cäpa i käh sim lü awmki he. Acun üng ami vea mäiha, Khyanga Capa a law be vai üng pi acukba kya law khai. ");
INSERT INTO dao_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Loa ve yümki xawi üng mat jäk lü mat hawih hüt khai. ");
INSERT INTO dao_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","“Ksum su yümki nghnumi nghngih üng mat jäk lü mat hawih hüt khai. ");
INSERT INTO dao_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nami Bawipa a lawnak vaia akcün am nami ksingkia kya se, a na ngäng ua. ");
INSERT INTO dao_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Im mah naw mpyukei a law vaia kcün a ksing vai sü ta, a im mpyukei naw käh a kpye vaia mtät kyet khai ti nami ksingki. ");
INSERT INTO dao_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","“Acuna mäiha, nangmi pi a na ngcüngcei ua. Isetiüng ta, Khyanga Capa cun am nami sümhmuha kcün üng law be khai. ");
INSERT INTO dao_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Im mahpa naw, a imbunga eiawk akcün phäh phäh üng jah pyangmtham pawhmsah khaia a mcawn themngvai lü cingcaikia mpya cen u ni? ");
INSERT INTO dao_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","“Acun he jah na pawhmsah se a mahpa naw ima a law be üng, a hmuh lawa mpya ta a josen ve. ");
INSERT INTO dao_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Akcanga ka ning jah mthehki, amahpa naw acuna mpya üng a khawh naküt ap khai. ");
INSERT INTO dao_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Cunsepi, mpya kse ania üng ta, ‘ka mahpa a law be vai hjo ham khai ni’ ti lü ngaihnipki. ");
INSERT INTO dao_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","“A püi mpyae jah kpai lü ju awk ktai k’eiea hlawnga a na eiawk hü hngaki. ");
INSERT INTO dao_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","“Am a ngaihhmuh ja am a na ksinga kcün mhnüp mat üng, acuna mpyaa mahpa law be khai. ");
INSERT INTO dao_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","“A mahpa naw a mtemtea mawilü hypocritea venaka vesak hnga se, acuia kyahnak ja, mnicui hakyetnak am khuikhatnak khamei khai. ");
INSERT INTO dao_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Acunkäna, Khankhaw Pe cun nglamica xa, ami meiim jah ceh lü ca mbumki a na do khaia, citkie üng tängki ni. ");
INSERT INTO dao_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","“Mhma cun am cingcai u, akce mhma ta cingcaikie. ");
INSERT INTO dao_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","“Am cingcaikie cun ami meiim cehpüi u lü meitui um üng am ceheisih u. ");
INSERT INTO dao_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","“Acunsepi, akcinge cun ami meiim üng meitui a bea thea um üng meitui abe ceheisihkie. ");
INSERT INTO dao_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Ca mbumki am pha law nai se, ami van ngam u lü ipeikie. ");
INSERT INTO dao_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mthan nglunga, ‘Ca mbumki law ve, law lü do law ua,’ ti lü ngpyang kthai ngthang lawki. ");
INSERT INTO dao_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Nglamica he cun ami van xak law u lü ami mei ime jah pyaneikie. ");
INSERT INTO dao_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Am cingcaikie naw, ‘Akcinge üng nami meitui jah pe lawca ua, kami meiim thi law hlü ve’ ami ti. ");
INSERT INTO dao_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Akcinge naw, ‘Kaa, keimi ja nangmia phäh meitui am khäk hlü ve. Cit lü namimäta phäh va khyäiei ua’ ami ti. ");
INSERT INTO dao_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Acunüng, meitui khyäi khai hea ami va ceh k’um üng, ca mbumki law lü meitui taki he cun am atänga ca mbumnaka jah lutpüi lü ksawh ami khaih u. ");
INSERT INTO dao_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Acunkäna, nglamica kce he pi law hnga u lü, ‘Bawipa aw, Bawipa aw, lut law hnga vang ung’ ami ti. ");
INSERT INTO dao_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ani naw, ‘Akcanga ka ning jah mthehki, nangmi am ning jah ksing nawng’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ia kcün ja amhnüp üng Khyanga Capa law be khai ti, am nami ksingkia kya se, a na ngcüngceiei ua. ");
INSERT INTO dao_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Khankhaw Pe cun khyang mat kdunglawng hü khai naw a mpyae jah khü lü a khawhkhyeme jah mceisaki am tängki ni. ");
INSERT INTO dao_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","“Ami khyaihnak üng ngkäkia, mat üng ngui thawng mhma, mat üng thawng nghngih ja mat üng thawng at cima jah pe hüt lü kdung hüki. ");
INSERT INTO dao_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Thawng mhma yahki naw ta cit ktäi lü a ngui cun am kungpang hü lü thawng mhmaa a pungsak. ");
INSERT INTO dao_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","“Acukba bäa thawng nghngih yahki naw pi thawng nghngiha a pungsak. ");
INSERT INTO dao_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Cunüngpi, thawng mat yahki naw ta amahpa ngui cun cehpüi lü mdek k’uma a va cümin. ");
INSERT INTO dao_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Khawvei angsawk käna ami mahpa law be lü a jah pet hüt nguia mawng a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Thawng mhma yahkia mpya naw ta a yaha ngui thawng mhma lawpüi lü, ‘Ka mahpa aw, thawng mhma na na pet hüt; tenga, thawng mhma ka yahsih ni’ ti lü a msum be. ");
INSERT INTO dao_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Amahpa naw, ‘Daw ve, nang hin daw lü sitihkia mpya ni; apica üng na sitihkia kyase, kei naw khawhaha ka ning ap khai ni. Law lü na mahpaa dä ayüma jekyaia’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Acunüng, thawng nghngih yahki pi law hnga lü a yaha ngui thawng nghngih lawpüi lü, ‘Ka mahpa aw, thawng nghngih na na pet hüt; tenga, thawng nghngih ka yahsih ni’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Amahpa naw, ‘Daw ve, nang hin daw lü sitihkia mpya ni; apica üng na sitihkia kyase, kei naw khawhah ka ning ap khai ni. Law lü na mahpaa dä ayüma jekyaia’ a ti. ");
INSERT INTO dao_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Thawng mat yahki pi law lü, ‘Ka mahpa aw, nang cun na khaki, am na sawnaka na atki, mci am na phuhnakaa pi na mcunki’ ti ka ksingki. ");
INSERT INTO dao_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","“Acunakyase kyühei lü, ka va citki naw mdek k’uma ka k’uhin ni. Tenga, acuna mä se na ka bi bea,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Amahpa naw, ‘Nang mpya kse, mpya kdam! Am ka sawnaka ka atki, mci am ka phuhnaka ka mcunki’ ti na ksingki am niki aw? ");
INSERT INTO dao_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","“Ka ngui cun ngui cümnak ima jah va kpuki se, ka law be üng ka ngui pung se ka yah be vai sü. ");
INSERT INTO dao_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Tuh ta, hina veia ngui la be lü ngui thawng xa taki üng pe ua. ");
INSERT INTO dao_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Isetiakyaküng, khawkän yah thei lü taki üng, a tak law dämdäm vaia pet sih vai. Cunüngpi, i pi am ta lü am sui theiki üng, a takca naküt huh be vai. ");
INSERT INTO dao_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Ia pi am ngmangnaka mpya, anghmüpnak, kpunga va xawt tawn hü ua. Acuia khuikha mpyensetnak am mnicui hakyet lü ve khai,’ ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Khyanga Capa cun Sangpuxanga mäiha a khankhawngsä ngcime am atänga a law be üng, a Bawingawhnak üng ngaw khai. ");
INSERT INTO dao_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","“A maa, khyang mjü naküt ngcun law khaie. Acunüng toksäm naw a toe mee ksung üngkhyüh a jah mtaia kba khyang mjü naküt cun jah mtai law khai. ");
INSERT INTO dao_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","“Khyang ngsungpyune cun a khet da jah ta lü, akce he cun a kcawng da jah ta khai. ");
INSERT INTO dao_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Acunüng, Sangpuxang naw a khet da kae üng, ‘Law ua, ka pa naw dawkyanak am a ning jah kbe, khawmdek angtüi üngkhyüh nami phäha pyan päng Khankhaw Pe cen ka na ua. ");
INSERT INTO dao_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‘Ei ka cawi üng na na tumbeiki; tui ka xai üng tui na na peki; Khina ka kya üng pi na ima na na khin naki; ");
INSERT INTO dao_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","‘Suisak kpuma ka ve üng, nami na msuimsaki; am ka phetyai üng, nami na msümcei büktengki; thawng ima ka ve üng pi, ka veia nami lawki he,’ ti law khai. ");
INSERT INTO dao_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Khyang ngsungpyune naw, ‘Bawipa aw, itüh üng ei cawiki se ning hmu u lü, kami ning mbei ni? Itüh üng tui xaiki se tui kami ning tu ni? ");
INSERT INTO dao_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","‘Itüh üng, khina kya lü, kami ning khinnak ni? Itüh üng suisak kpuma veki se, kami ning msuimsak ni? ");
INSERT INTO dao_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","‘Itüh üng am phetyai lü thawng ima veki se, kami ning bükteng law ni? ami ti. ");
INSERT INTO dao_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Sangpuxang naw, ‘Akcanga ka ning jah mthehki, hina ka hnükläke üngka akdikca säiha khana nami bi naküt cun keia phäh nami bi ni,’ ti law khai. ");
INSERT INTO dao_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Acunkäna, a kcawng da kae üng, ‘Pamhnama yünsenak khameikie aw, Khawyam ja a khankhawngsä hea phäha pyang mulaia ka venak üngkhyüh cit ua. ");
INSERT INTO dao_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‘Isetiüng, ei ka cawi üng, ei am na mbei uki; tui xai üng se, awk vai tui am na pe uki; ");
INSERT INTO dao_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","‘Khina ka kyak üngpi am nami na khinaki; suisak kpuma ve üng se, am nami na msuimsaki; am ka phetyai lü thawng ima ka um üng pi, am nami na bükteng lawki.’ ");
INSERT INTO dao_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Acunüng, amimi naw, ‘Bawipa aw, itüh üng ei cawi lü, tui ngaih lü, khina kya lü, akpuma na ve, am phetyai lü thawng ima veki se, ning hmu u lü, am kami ning kueiki ni?” ti law khaie. ");
INSERT INTO dao_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Sangpuxang naw, ‘Akcanga ka ning jah mthehki, hina akdikca kuei vai nami hai cun Kei nami na haia kyaki,’ ti lü, jah msang be. ");
INSERT INTO dao_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Acunüng, acun he avan angsäia khuikhatnak mulaia cit u se, ngsungpyunkie ta angsäia xünnaka cit khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesuh naw acuna mtheimthangnake a jah pyen päng üng, axüisaw he üng, ");
INSERT INTO dao_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Lätnak Pawi a phanak vai mhnüp nghngih hlü hamki ti nami ksingki, Khyanga Capa kutlamktung üng ami hnim vaia man law khaie,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Acunüng, ktaiyü ngvaie, thumksinge ja, angvaie cun, ktaiyü ngvai säih Kaiphah ami tia abawi ima ngbum lawki he. ");
INSERT INTO dao_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jesuh ampyuaa man lü hnim khai hea cengkie. ");
INSERT INTO dao_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Acunsepi, lätnak pawi k’um üng ta käh pawh vai, khyang he suksak khaie ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesuh Bethanih mlüh, mnehkse mnehki Sihmona ima veki. ");
INSERT INTO dao_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesuh naw buh a ei k’um üng, nghnumi mat naw aphu küi alabasta ksi ng’ui um mat üng lawpüi lü, a lu khana a buih law. ");
INSERT INTO dao_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Axüisawe naw hmuh u lü ami mlung so se, “Ivai ahikba a päihcaihsak ni? ");
INSERT INTO dao_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Hina ksi ng'ui khawhaha jawi lü, khuikha msih mpyaki he üng jah pet vai sü,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesuh naw ami pyen ksing lü, “Ivai hina nghnumi nami suksakeikie ni? Ani naw ka khana akdaw säih pawhki ni. ");
INSERT INTO dao_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","“Sih mpyaki he cun aläa nami hlawnga ve khaie. Acunsepi, kei cun nami hlawnga aläa am ve hlü nawng. ");
INSERT INTO dao_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","“Hina ksi ng'ui ka khana a buih hin ka ng'utnak vaia pyangki ni. ");
INSERT INTO dao_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","“Akcanga ka ning jah mthehki, khawmdek van üng hawia pi, thangkdaw ami sang hü u üng, hina nghnumi naw hikba a pawha mawng pi ani sümnak vaia pyensih khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Acunüng, axüisaw he xaleinghngih üngka mat Judah Iskarot naw ktaiyü ngvaiea veia cit lü, ");
INSERT INTO dao_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Ani nami veia ka phyehei üng, i ja nami na pet kawm?” a ti. Ngui thumkip khe ma u lü ami pet. ");
INSERT INTO dao_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Acunkäna Judah Isakarot naw Jesuh a phyeheinak vaia lam suiki. ");
INSERT INTO dao_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nghngen am ngcawkia buh pawhnaka mhnüp kcük üng, axüisaw he Jesuh veia law u lü, “Hawia ni, Lätnak pawi buh na ei vaia kami pyen vai na ngjak hlü?” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesuh naw, “Ngnam k'uma khyang mata veia cit u lü, ‘Saja naw Ka kcün pha law ve; ka hnükläke ja Kei naw na ima Lätnak pawi buh ei khai, ti ve’ va ti ua” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesuh naw a jah mtheha mäiha axüisaw he naw Lätnak pawi buh pyang vaikie. ");
INSERT INTO dao_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Khaw amü law üng, axüisaw xaleinghngihe ja Jesuh ei khaia ngaw yümkie. ");
INSERT INTO dao_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ami ei k’um üng Jesuh naw, “Ka ning jah mthehki, nangmi üngka mat naw na phyehei khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Axüisawe amsüma pukse u lü, “Bawipa aw, acun mä kei vai aw?” ti lü mat mat cima ami kthäh u. ");
INSERT INTO dao_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesuh naw, “Kbe mat üng atänga na kpuiheipüiki naw na phyehei khai. ");
INSERT INTO dao_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","“Khyanga Capa cun Cangcim üng a ng'yuka mäiha thi khai. Acunsepi, Khyanga Capa phyehei khaia phäh ihlawk kyühkse khai ni. Acuna khyang hin angtüia käh a ngtüi law xaa ta a phäha daw bawk khai sü,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Phyehei khaia khyang Judah naw, “Rabbi, acun mä kei phäi aw?” a ti. Jesuh naw, “Ä, na pyen cang ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Acukba ami ei k’um üng, Jesuh naw muk lo lü ktaiyü ma lü boki naw, axüisaw he üng a jah pet. “Lo u lü, ei ua; hin hin keia mtisa ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Acunüng, Jesuh naw khawt lo lü Pamhnam üng jenak mtheh lü, axüisaw he üng a jah pet. “Nami van naw hin aw ua. ");
INSERT INTO dao_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hin hin ka thisen, Pamhnama khyütamnak kthai, khyang khawhah mkhyekatnak mhlätnak vaia lawngki ka thisen ni. ");
INSERT INTO dao_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ka ning jah mthehki, ka paa Uknaka Khawa nangmi am ahina capyittui kthai am mi awk be yüm vei cäpa, hina capyittui kthai am ka aw be ti khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Acunüng, ng’äi mat ami mcuh käna, Olip mcung da citkie. ");
INSERT INTO dao_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","“Tuh mthan, kei na hawih hüt u lü nami cen päih khaie. Cangcim üng a ng’yuka kba, ‘Pamhnam naw toksäm hnim se, toe cun ngpyangtaiei hü päih khaie’ ");
INSERT INTO dao_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Acunsepi, ka thawh be käna Kalile khawa nami maa ka na cit khai,” ti lü Jesuh naw a pyen. ");
INSERT INTO dao_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita naw msang lü, “Ami van naw ning cen ta päih u sepi, kei naw ta isüm am ning cen ta ngü,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesuh naw, “Ka ning mthehki, tuh mthan ai am khawng ham se, nang naw kthum vei am na na ksing vaia na pyen khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita naw, “Na thihnaka thih hnga vai ngü sepi acukba ta am ka pyen khai ni,” a ti. Acukba bäa axüisaw he ami van naw ti law hngakie. ");
INSERT INTO dao_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Acunüng, Jesuh axüisaw he am alanga, Ketaseman ami tinaka hnün mat ami pha law üng, axüisaw he üng, “Caia ka va ktaiyü k’um üng, hin üng a na ngaw ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pita ja Zebedea capa xawi jah ngkhahpüi lü, a mlung na leng lengki. ");
INSERT INTO dao_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Acunüng Jesuh naw jah mtheh lü, “Thi hlü awnga ka mlung khuikha ve. Ahin üng ve lü na ngängpüi ua,” ti lü a cehpüi kthum üng a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesuh cun va cetca lü, mdeka a hmai bun lü, “Aw, ka pa aw, a thawn thei üng ta, hina khuikhatnak khawt hin ka vei üngka naw loina. Cunüngpi, keia ngjakhlüa käh thawn lü, na ngjakhlüa thawn se,” ti lü ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Acunüng law be lü, a hnükläk kthum cun a na ipei u se jah hmuh lü Pita üng, “Naji matca pi ami na na k’äihpüi khawhki aw? ");
INSERT INTO dao_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hlawhlepnak üng nami lut msawk khai ni, ngäng lü ktaiyü ua. Mlungmthin ta yäng kyawki mtisa naw am lüi ve,” ti lü a mtheh. ");
INSERT INTO dao_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Anghngihnaka va cit lü, “Aw ka pa aw, kei naw hina khuikhatnak khawt hin am aw ngü se am a thawn thei üng ta, na ngjakhlüa kya se,” ti lü ktaiyü betüki. ");
INSERT INTO dao_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ami veia a law be üng a axüisaw he a na ip betü u lü am mdei khaw u se a jah hmuh. ");
INSERT INTO dao_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jah hawih hüt lü akthumnaka acukba bä pyen lü va ktaiyü betüki. ");
INSERT INTO dao_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Acunüng, axüisaw hea veia cit be lü, “Atuh vei cäpa ip lü nami hüieikie aw? Teng ua, Khyanga Capa cun khyangkaea kut üng msum vaia kcün pha law ve. ");
INSERT INTO dao_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","“Tho law ua, mi cit vai. Teng ua, na phyeheikia khyang law ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Acukba, a na ngthuhei k'um üng, axüisaw he üngka Judah law lü, ktaiyü ngvaie, thumksinge ja axü ngvaie naw ami jah tüih law khyangpänu li kcim jah kpawmeikie a jah lawpüi. ");
INSERT INTO dao_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Phyeheiki naw msingnak jah pe lü, “Ka mhnama khyang cun na ngjakhlüa khyanga kya khai, ani nami man vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judah cun Jesuh veia cit lü, “Rabbi, dimdeihnak ve se,” ti lü a mhnam. ");
INSERT INTO dao_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesuh naw, “Ka püi aw, ise na lawki ni?” a ti. Acun ja lawsih lü ami man u. ");
INSERT INTO dao_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jesuha a ngkhahpüi he üngka mat naw kcim ksetei lü ktaiyü ngvai säiha mpyaa hngakawi a ksawm pit. ");
INSERT INTO dao_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesuh naw, “Na kcim a venak üng ta bea, kcim xatnakie cun kcim am ni ami thih kawm. ");
INSERT INTO dao_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tukbäih ka pa veia ktaiyü ngü se, ani naw khankhawngsä he xaleinghngih khläih na tüih law pe khawhki ti, am nami ksingki aw? ");
INSERT INTO dao_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ka ktaiyü üng, ihawkba Cangcim naw ahikba thawn law khai a ti, kümbe law khai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Acunkäna Jesuh naw, “Li kcime jah kawtei u lü Kei na man khaia nami lawki he aw? Kei hin khyang kse aw? Amhnüp tä, nami hlawnga ngaw lü templea jah mthei ngü se, am nami na manki. ");
INSERT INTO dao_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Acunsepi, ahin avan cun sahma hea pyen akümnak vaia kyaki ni,” a ti. Acunüng axüisaw he ami van naw hawih lü ami dawng tak. ");
INSERT INTO dao_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesuh mankia khyang he naw ktaiyü ngvai säih Kaiphah ima, thumksinge ja axü ngvaiea ngcunnaka ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita athuknak üngka naw ktaiyü ngvaia ngvawng cäpa läk hngaki. Lut hnga lü i a thawn law teng khaia, yekapa am ngaw yümkie. ");
INSERT INTO dao_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ktaiyü ngvaie ja Kawngci üngka ami van naw Jesuh ami hnimnak vaia am cangkia saksi suikie. ");
INSERT INTO dao_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Cunüngpi, khyang khawkän naw maa law u lü Jesuh mhleieikie kyaw, cunsepi i am hmuh u. Akpäihnaka khyang nghngih law ni lü, ");
INSERT INTO dao_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Hina khyang naw, ‘Kei naw Pamhnama temple kpye lü amhnüp kthum üng ka sa be khawh khai’ tiki,” ti lü ani pyen law. ");
INSERT INTO dao_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ktaiyü ngvai säih naw tho law lü, “Ami ning mkatei na jah msangnak vai am na ksingeiki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Acunsepi, Jesuh am khihkheh. Ktaiyü ngvai säih naw msang lü, “Xüngseikia Pamhnama ngming be lü ka ning kthähki: Pamhnama Capa, Khritaw Mesijaha na kya üng jah mtheha,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesuh naw, “Na pyen cang ve. Acunsepi, tuha Khyanga Capa cun a Johitmah säih khet da ngaw lü, ngmei üng kyum law se nami hmuh khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Acunüng, ktaiyü ngvai säih naw a suisake jah ktekin lü, “Hin naw Pamhnam pyenksenaka ngthu pyen ve! Ahina thea ia saksi am hlü ti? Tuh kung Pamhnam a pyetsenak nami ngjaki. ");
INSERT INTO dao_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ihawkba nami ngaikie ja?” a ti. Amimi naw, “Ani mkhyekatki, thih kung khaia ngkawih ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Acunüng, a hmai üng msawh lü thäkie. Avang naw ami mja am kbei u lü, ");
INSERT INTO dao_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nang Khritaw! Na nghmaki. U ja ni kbeiki? jah mtheha” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ngvawnga kpunga ngaw se, ktaiyü ngvaia mpya nghnumi mat naw a veia law lü, “Nang pi Kalile khyang Jesuh am nani ve yümki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Cunsepi, Pita naw ami vana maa ngcim lü, “I na pyenki, am ksing nawng,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Acunüng, akce mkawt da cit se, acuia mpya akce nghnumi naw hmuh lü, “Hina khyang pi, Nazaret Jesuh am ve yümki va ni kbak,” ti lü acuia awmki he üng a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita naw, “Ka ng’yünki, acuna khyang kei am ksing nawng” ti lü ngcim betüki. ");
INSERT INTO dao_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ivei am ngsawk se acuia ngdüikie naw law u lü, “Akcanga nang pi acun he üngka mata na kyaki ni, na ngthuhei üng ngsingei ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Acunüng Pita naw, “Ka ng’yünki, akcang ni ka pyen. Ka hlei ka pyen üng Pamhnam naw na hmuh se. Acuna khyang am ksing nawng” a ti. Acukba a ngcim betü ja ainghlüi khawngki. ");
INSERT INTO dao_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jesuh naw, “Ainghlüi am khawng ham se kthum vei ngcim lü na na ma khai,” a ti cen Pita naw süm law be lü kpunga cit lü aknuia kyapki. ");
INSERT INTO dao_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Khaw athaih law üng, ktaiyü ngvaie ja axü ngvaie ami van naw Jesuh hnimnak vaia lam suikie. ");
INSERT INTO dao_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lakkhit am khit u lü cehpüikie naw Romah Khaw Uk Pilat üng ami msum. ");
INSERT INTO dao_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Phyeheiki Judah naw Jesuh ami hnim vaia mkateikie ti a ksing üng ngjut lü, tangka thumkip ktaiyü ngvaie ja axü ngvaiea veia a lawpüi be. ");
INSERT INTO dao_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Khyang ngcim phyehei lü mkhyekat veng,” a ti. Amimi naw, “Keimi üng acun i sängei se ja? Namät üng va sängeiki” ti lü ami pyen. ");
INSERT INTO dao_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judah naw tangka cun templea xawtin hüt lü acun üngka naw dawng lü amät va ng’awk ngengki. ");
INSERT INTO dao_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ktaiyü ngvaie naw tangka lo u lü, “Hina ngui hi thisena phu ni, Templea khawh taknak üng tak vaia am nglawi,” ti lü, ");
INSERT INTO dao_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","atänga sumkyam u lü acuna ngui am pekce khyang he jah k’utnak vai k’am kvawa khawmdek ami khyäih u. ");
INSERT INTO dao_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Acunakyase, acuna mdek cun tuhvei cäpa “Thisen khawmdek” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Acunüng, sahma Jeramih naw a pyen, “Isarele khyang he naw ania phu tangka thumkipa ami mkhyäp päng cun la u lü, ");
INSERT INTO dao_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","tangka thumkip cen am k’am vawkia mdek khyäihnak vaia sum ve u,” a ti kümcei lawki. ");
INSERT INTO dao_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesuh Romah Ukia ma ngdüi se, Khaw Uk naw, “Nang Judahea Sangpuxanga na kyaki aw?” ti lü a kthäh. Jesuh naw, “Ä, na pyen cang ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Acunüngpi, ktaiyü ngvaie ja axü ngvaiea mkateinak üng ta mkhap matca am pi am jah msang be. ");
INSERT INTO dao_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Acunüng, Pilat naw, “Ami ning mkatei hin na ngjaki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Acunüngpi, mkhap matca üng am jah msang lü ve betü se, Khaw Uk naw a münnak law. ");
INSERT INTO dao_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Romah Uk naw Lätnak pawi buh pawh mhnüp üng, thawngkyum mat, khyang he naw ami ngai mat cim a jah mhlät pet khawia thum veki. ");
INSERT INTO dao_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Acunüng thawngim üngka a ngming ngthangki, mat Jesuh Barabah ami ti veki. ");
INSERT INTO dao_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Acunakyase, khyang he ami ngcun law üng Pilat naw, “U ja nami phäha ka mhlät vai nami ngai? Barabah mä, Khritaw ami ti Jesuh mä?” a ti. ");
INSERT INTO dao_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Isetiakyaküng, Jesuh cun Judah ngvaie naw hneng lü ami lawpüi ti, a ksinga phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilat, ngthumkhyahnaka ngawhnak üng a ngawh üng, a khyu naw “Hina khyang ngsungpyun, ia käh pawh kawpi, tuh mthan ka ngmang üng ania phäh aktäa ka khuikhaki ni,” ti lü a cük law. ");
INSERT INTO dao_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ktaiyü ngvaie ja axü ngvaie naw Barabah mhlät lü Jesuh hnim vaia, khyangpä naw ami tä vaia ami jah ksük. ");
INSERT INTO dao_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Cunsepi Pilat naw jah kthäh lü, “Hina khyang nghngih üng u ni ka mhlät vai nami jum?” a ti. Amimi naw, “Barabah,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Acunüng Pilat naw, “Khritaw ami tia Jesuh ia ka pawh vai ni?” a ti. Ami van naw, “Kutlamktung üng taiha,” ami ti u. ");
INSERT INTO dao_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Cunsepi Pilat naw, “Ia mkhyenak pawh se ni?” a ti. Acunüng, “Kutlamktung üng taih vai,” ti lü, ngpyang law dämdämkie. ");
INSERT INTO dao_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Acunüng Pilat naw i am ti thei ti. Khyang he suksak law khaie ti ksing lü, “Hina khyang ngcima thisen üng kei am sängei veng, nangmia pawha ni a kya hlü ve” ti lü, khyang hea maa a kut tui am a kpyaw. ");
INSERT INTO dao_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Khyangpä van naw, “Hina a thisen ta kamimät ja kami ca hea khana kya law kawm,” ti lü, ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Acunüng Pilat naw Barabah jah mhlät pet lü; Jesuh a kpai päng ja kutlamktung üng ami taih vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Acunkäna Pilata yekape naw Jesuh, Khaw Uka Bawiima k’uma luhpüi u se, läk lawki he naw ami kbumin law. ");
INSERT INTO dao_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A suisak jah suh pet u lü suisak sen ami jihsak. ");
INSERT INTO dao_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Acunüng nghling lukhum pyang u lü ngbüngsakie; a khet kut da ksawngkhe ami kcüngeisak. Ami mkhuk am ngdäng lü ngkun u lü, “Judahea Sangpuxang, na sak saü se,” ti u lü yaiha ami pawh u. ");
INSERT INTO dao_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Msawh lü ksawngkhe lokie naw a lu üng ami kpai. ");
INSERT INTO dao_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ami yaihei law päng üng, suisak sen suh pe lü a suisak jihsak bekie naw, kutlamktung üng ami taih vaia ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Acukba ami lawpüi üng, lama Kurenih khawa ka Sihmon hmuh u lü, yekape naw Jesuha kutlamktung asihlinga ami kawhsak u. ");
INSERT INTO dao_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kolkotha (Acun cun lukawi hnün tinaka kyaki) ami tia hnün pha lawki he. ");
INSERT INTO dao_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Seitui kha am ami kcaw capyitui awk hlüsak u se, mdep lü am aw hlü. ");
INSERT INTO dao_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kutlamktung üng taih u lü cung kphawng u lü a suisake ami jah ng’yatei u. ");
INSERT INTO dao_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Acunkäna acuia ngaw u lü tengeikie. ");
INSERT INTO dao_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hnengnaka kca, “Hin hin Jesuh, Judahea Sangpuxang,” ti lü yuk u lü a lu khana ami taih u. ");
INSERT INTO dao_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Acunüng mpyukei nghngih, mat a khet da, mat a kcawng da kutlamktung üng ami jah taih hnga. ");
INSERT INTO dao_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Acuna lam üng cet hükie naküt naw pi ami lu kting lü, ");
INSERT INTO dao_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Nang naw temple kpye lü amhnüp kthum üng na sa be hlüki, Pamhnama Capa na kya üng ngküikyaneia; kutlamktung üngka naw kyum lawa,” ti lü Jesuh yaiheikie. ");
INSERT INTO dao_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Acukba bäa ktaiyü ngvaie, thumksinge ja axü ngvaie naw pi yaihei u lü, ");
INSERT INTO dao_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Hin naw akce he ta jah küikyanki, amäta am ngküikyanei khawh ve. Isarelea Sangpuxanga am ni mä? Kutlamktung üngka naw a kyum law üng, kami jumei khaie ni. ");
INSERT INTO dao_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pamhnam jumeiki ni, “Kei cun Pamhnama na ca ni” a ti. Daw ve! Pamhnam naw küikyan law hlü khü mi teng vai u” ti lü yaiheikie. ");
INSERT INTO dao_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kutlamktung üng ami jah taih yüma mpyukei xawi naw pi acukba bäa ani yaihei hnga. ");
INSERT INTO dao_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mhnüp ngsung üngkhyüh cutei lü mkeng naji kthum cäpa khawmdek avan cun nghmüp nghmawei päihki. ");
INSERT INTO dao_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naji kthum bang üng, Jesuh angsanga, “Eli, Eli, lemaa sabathani?” ti lü, ngpyangki. Acun cun, “Ka Pamhnam, Ka Pamhnam; ise na na hawihinki ni?” tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Acun üng ngdüiki khyang avang naw ami ngjak üng, “Hina khyang naw Elijah khü ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Acun üngka mat naw angsenga dawng lü spawng lo lü capyit kthui am kphümki naw cungmdawng üng a tak. Jesuha mpyawng üng a awk vaia a jeng säng pet. ");
INSERT INTO dao_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Avang naw, “Asäng ve cang se! Yung khaia Elijah law hlü khe, mi teng vai u,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesuh angsanga ngpyang betü ja a sak päihki. ");
INSERT INTO dao_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Acunüng, Templea veki jihnu akhan üngka naw a le cäpa tekinki. Ngkhyü ngsün lü lungnue pi ngbokie. ");
INSERT INTO dao_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lungdüa ng’utnake nghmawng law u se, Pamhnama khyang ngcime thikie pi tho bekie. ");
INSERT INTO dao_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesuh a thawh be käna ng’utnake jah hawih hüt u lü mlüh ngcingcaih Jerusalem k’uma lut vai u se khyang khawkän naw jah hmuhkie. ");
INSERT INTO dao_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Acunüng yekap ngvai ja Jesuh mtätkie naw mkhyüa ngsün ja thawnghlawki naküt ami jah hmuh üng, “Ani hin, Pamhnama Capa kcang ni,” ti lü kyükyawkie. ");
INSERT INTO dao_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kalilea a ve üng, Jesuha hnu läk lü ei awk tumbeiki nghnumie naw pi khawsang üngkhyüh jah teng hngakie. ");
INSERT INTO dao_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Acun he üngka Marih Makdalin, Marih Jakuk ja Josepa ani nu, acun ja Zebedea khyu xawia kyaki he. ");
INSERT INTO dao_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Khaw amü law üng, Arimahte mlüha ka bawimang lü Jesuha hnukläk hngaki Josep pha lawki. ");
INSERT INTO dao_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilata veia cit lü Jesuha yawk cun a va tä. Pilat naw Jesuha yawk Josep üng ami pet vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Acunüng Josep naw yawk cun la lü jih kthai am hlawpki naw, ");
INSERT INTO dao_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","amäta ng’utnak vaia lung a pyangei üng k’ut lü Lungdü mkawt cun lungnu am khai hüt lü a ceh tak. ");
INSERT INTO dao_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Acuia Marih Makdalin ja Marih kce mat cun lungdü da mang lü ngawki xawi. ");
INSERT INTO dao_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Angawi, Sabbath mhnüp üng, ktaiyü ngvaie ja Pharise he Pilata veia ngcun lawki he. ");
INSERT INTO dao_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Saja aw, jah mhleimhlaki naw a xün ham üng, ‘Amhnüp kthum üng ka tho be khai’ a ti kami sümki. ");
INSERT INTO dao_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Axüisawe naw mthana law u lü a yawk mpyu law be u lü, ‘Jesuh thihnak üngka naw tho be ve’ ti lü, khyang he üng jah mtheh u se, ak’hnua hleihlaknak hin akmaa ka kthaka sehlen khai ni. Acunakyase, a ng’utnak mhnüp kthum mtäh vaia ngthu mkhyaha,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat naw, “Mtät khaie jah khü lü nami khyaih khawha üp khaia va mtät ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Acunüng mtät khaia yekape am cit u lü lung cun msingnak am msing u lü lungdü cun mtätkie. ");
INSERT INTO dao_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabbath käna, amhnüp khyühnak ngawilam, khaw athaih law hlü hnüh üng, Marih Makdalin ja a püi Marih kce mat am, ng’utnak teng khaia cetki xawi. ");
INSERT INTO dao_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pamhnama khankhawngsä mat khankhaw üngkhyüh kyum law se, ngkhyü aknuia ngsünki. K’utnak mkawta lungnu mkawt üngka ktawngin lü lunga khana ngawki. ");
INSERT INTO dao_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A hmai khawmlaiha mäih law lü a suisak pi khuia mäiha bawki. ");
INSERT INTO dao_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mkawt mtäte naw khankhawngsä cun hmu u lü kyühei ngen u lü akthi kcea mäiha awmki he. ");
INSERT INTO dao_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Khankhawngsä naw nghnumie üng, “Käh kyühei ua, kutlamktung üng ami taih Jesuh nami sui hüki ti ka ksingki. ");
INSERT INTO dao_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","“Ani hia am ve; a pyena kba, tho be pängki ni. Hia law lü Bawipaa ngkawhnak teng law ua. ");
INSERT INTO dao_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“Akjanga cit u lü, “Jesuh thihnak üngkhyüh tho be lü, nami ma Kalile khawa cet ve, acuia nami hmu khai ni ti” axüisaw he üng jah mtheh ua. Ka ning jah mtheh khawi cen süm be ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Acunüng kyühnak ja aktäa jenak am, lungdü üngkhyüh cet lü axüisaw he üng jah mtheh khai hea dawngkie. ");
INSERT INTO dao_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ahunata Jesuh naw lama jah na khyum lü, “Dimdeihnak am ve ua,” ti se, law u lü, a khawe jah mhjut mtham u lü hjawkhahkie. ");
INSERT INTO dao_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesuh naw, “Käh kyühei ua. Cet u lü ka benae Kalile khawa ami na ceh vaia jah va mtheh ua, acuia na hmu khaie ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nghnumie ami ceh k’um üng, yekap avang mlüh k’uma cet u lü thawnhlawki naküt cun ktaiyü ngvaie üng ami jah mtheh vai. ");
INSERT INTO dao_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ktaiyü ngvaie naw axüe ngvai jah va nghmu u lü, yekape üng ngui khawkän jah pe u lü, ");
INSERT INTO dao_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Mthana, kami ih k’um üng axüisaw he naw a yawk ami mpyuk law ni ti lü, nami jah mtheh vai. ");
INSERT INTO dao_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Acunüng Khaw Uk naw a ngjak taw üng, nangmia mkhye am ni ti a ksing vaia kami mcäi khaie ni,” ti lü ami pyen. ");
INSERT INTO dao_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yekape naw ngui cun la u lü ami jah mtheha mäiha ami pawh u. Acunakyase ahina ngthu cun tuh vei cäpa Judahea ksunga ngthang hüki. ");
INSERT INTO dao_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Axüisawe xaleiate cun Kalile khawa cet lü Jesuh naw a jah mthehnak mcunga kaikie. ");
INSERT INTO dao_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesuh ami hmuh üng hjawkhahkie. Cunüngpi avang cun ami mlung uplatki. ");
INSERT INTO dao_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesuh naw thäih law lü, “Khawmdek ja khankhawa anaa naküt cun ka kut k’uma pet pänga kyaki. ");
INSERT INTO dao_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Acunakyase, cit u lü khyang naküt ka hnukläkea jah pyang u lü, Pa, Capa ja ngmüimkhya ngcima ngming üng baptican jah pe ua. ");
INSERT INTO dao_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ahmäi ka ning jah mthehe ami jah läklam vaia jah mthei ua. Khawmdeka düt vei cäpa nami hlawnga ka ve khai,” a ti.");
INSERT INTO dao_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hin hin Pamhnama Capa Jesuh Khritawa mawng Thangkdaw ni. ");
INSERT INTO dao_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","“Pamhnam naw, ‘na maa ka ngsä, lam pyang khaia ka tüi law khai.’ ");
INSERT INTO dao_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Khyang mat, khawkhyawng khawa ngpyangki naw, ‘Bawipa a lam pyang ua; a cehnak vai lam ngdüngsak ua!’ a ti” tia, akphyüma sahma Hesajah naw, a yuka kba. ");
INSERT INTO dao_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Acunüng, Johan khawkhyawng khawa ngdang law lü, baptican jah pe law lü, jah mtheimthang law lü, “Nami katnak nghlata u lü Baptican khan ua, Pamhnam naw nami katnak he ning jah mhlät khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Acunüng, Judah khaw la Jerusalem mlüha khyang he ngthu ngai khaia Johana veia citki he. Ami katnak he jah phyeh u se Jordan tuinu üng Johan naw baptican a jah khansak. ");
INSERT INTO dao_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johan cun samu am ami pyan suisak suisa lü, savunksawmyüi a kcawi üng vawp lü, mkhaü he la mawkpyawnga khawitui jah ei awki. ");
INSERT INTO dao_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Johan naw sang lü, “Ka hnua law khaia khyang ta keia kthaka kyäp bawk ve, kei cun kawp lü a khawdawkyüi ka kphyan pe khaia pi am ka ngkawihki ni. ");
INSERT INTO dao_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kei naw tui am baptican ka ning jah peki, cunsepi ani naw Ngmüimkhya Ngcim am Baptican ning jah pe khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Acun käna ivei am ngsawk se, Jesuh Kalile khaw Nazaret üngka naw law se, Johan naw Jordan tuinu üng baptican a pet. ");
INSERT INTO dao_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tui üngka naw angxita a thawh law be üng, khankhaw nghmawng law lü, Ngmüimkhya cun mümca kba a khana kyum law se a hmuh. ");
INSERT INTO dao_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Acunüng khankhaw üngka kthai naw, “Nang, ka ning jawng'engnak kcanga ka Capa, na khana ka je leng lengki,” tia, ngthang lawki. ");
INSERT INTO dao_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Acun la Ngmüimkhya naw khawkhyawng khawa a tüih. ");
INSERT INTO dao_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Acuia khawmhmüp kphyükip khawyam naw hlawhlep se awmki. Khisa he pi awmki he, acunüngpi khankhawngsä he naw law u lü ami msümcei law. ");
INSERT INTO dao_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Johan thawngim üng ami khyum käna, Jesuh Kalile khawa cit lü, Mhnama Thangkdaw pyen hü lü, ");
INSERT INTO dao_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Akcün pha lawpäng ve, Mhnama khaw ng’et law ve! Nami katnak he jah nghlata u lü, thangkdaw jum ua!” a ti. ");
INSERT INTO dao_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kalile tuili kama Jesuh a ceh üng, Sihmon la a na Andru ngvai vawiki xawi jah hmu lü, ");
INSERT INTO dao_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesuh naw, “Na läk law nia, kei naw khyang man khaia ka ning jah mthei khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Acunüng angxita ani ngvai jah yawk hüt ni lü, Jesuha hnu läki xawi. ");
INSERT INTO dao_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Acun üngka naw, asäng va cit lü, Zebedea capa Jakuk la a na Johan, mlawnga khana ani ngvai jah na pyangei ni se a jah hmuh. ");
INSERT INTO dao_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesuh naw a jah hmuh la jah khü se, ani pa Zebede la mlawnga khana ani jah ngvaha khyang he jah yawk hüt ni lü, Jesuha hnu läki xawi. ");
INSERT INTO dao_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesuh la axüisaw he Kapenawm mlüha law u se, angawi Sabbath mhmüp üng Jesuh naw Sinakok k’uma lut lü, a jah mthei. ");
INSERT INTO dao_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Thum jah mtheiki hea kba am kya lü, ana takia kba jah mthei se khyang he aktäa cäiki he. ");
INSERT INTO dao_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Acunüng, ami Sinakoka k’uma khyang mat, ngmüimkhyaksea awmnak naw, ");
INSERT INTO dao_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nazaret Jesuh aw, i mi nglak ve se ja? Na jah kpyeh khaia na lawki aw? Nang u ti ka ksingki. Nang cun Mhnama ngsä ngcim ni!” ti lü, ngpyangki. ");
INSERT INTO dao_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesuh naw, “Ä khihkhe lü, a k’um üngka naw, angxita lut lawa,” ti lü, ngmüimkhya kse a ksät. ");
INSERT INTO dao_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Khawyai naw acuna khyang cun ksün lü, angsanga ngpyang lü, lut lawki. ");
INSERT INTO dao_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Khyang he ami van cäi law u lü, “Hin hin ia ngkhaw ni? Ahina mtheimthangnak hin akthai am niki aw? Ana takia kba khawyai he pi jah ksät se, a pyen ngaiki he hin,” tia mat la mat ngthähki he. ");
INSERT INTO dao_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Acun la angxita, Kalile khaw avan üng Jesuha mawng ngthang hüki. ");
INSERT INTO dao_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesuh la axüisaw he Sinakok üngka naw lut law u lü, Jakuk la Johan am, Sihmon la Andrua ima cit ktäiki he. ");
INSERT INTO dao_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sihmona pi, mhnatei se ngjänki, Jesuh a pha law la ami mtheh. ");
INSERT INTO dao_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesuh naw a veia cit lü, a kut üng kaih lü, a mthawh la mhnat naw khya se, acun la a jah khinak. ");
INSERT INTO dao_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mü lam khawkyak käna, am phetki he avan la khawyai he naw a jah awmnak avan he cun Jesuha veia ami jah lawpüi. ");
INSERT INTO dao_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mlüh üngka khyang avan mkawt maa ngcun lawki he. ");
INSERT INTO dao_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesuh naw natnak ahmäi hmäia phäha am phetki he jah m’yai be lü khawyai he a jah ksät. Khawyai he naw ani cun ami ksinga phäha ani naw ä a jah ngthuheisak. ");
INSERT INTO dao_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ngawi lam khaw am a thaih phat üng, Jesuh tho law lü im ceh ta lü, anghinaka hmüna cit lü, va ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Cunsepi Sihmon la a püi he cun Jesuh sui khai hea citki he. ");
INSERT INTO dao_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Acunüng, ami hmuh law üng, “Khyang avan naw ning suihüki he ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Cunsepi, Jesuh naw, “Ahina pipei ngnam hea pi, ngthu ka pyen khaia mi cit khai, acun vaia ni kei ka law,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Acukba, Jesuh cun Kalile khaw avan üng cit hü lü, Sinakok hea ngthu pyen hü lü, khawyai he pi jah ksätki. ");
INSERT INTO dao_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mnehkse mnehki khyang mat Jesuha veia law lü, a mkhuk ngdäng lü, “Na hlüei üng ta, na na ngcimcaihsak theiki ni,” ti lü, a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesuh naw m'yeneinak am a kut sängki naw hnet lü, “Ä, hlüei veng, ngcima,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Acukba a pyen la angxita mnehkse cun khyük se, ani cun ngcimcai law beki. ");
INSERT INTO dao_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Acunüng Jesuh naw ksükki naw a tüih be. ");
INSERT INTO dao_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Acukba a pyen käna, “U am icapi ä na mtheh vai, cit lü, ktaiyü am na va ngtengei kyusak vai, acunüng Mosi naw a jah mtheha kba, na ngcimcainak ami msingnak vaia ngkengnak va pawha,” ti lü a tüih be. ");
INSERT INTO dao_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Cunsepi, acuna khyang naw cit lü acuna mawng cun avan üng va sang hü se, Jesuh angdanga mlüh k’uma am lut thei lü anghinaka awmki. Acuia, khyang pung akce kce üngka he naw ami ceh si. ");
INSERT INTO dao_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Khaw mhmüp asäng ngsawk se Jesuh Kapenawma cit be lü ima awmki tia mawng cun ngthang hüki. ");
INSERT INTO dao_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ami luhnak vai khuiim am nghäng lü, mkawt peia pi thetkia, khyang khawjah ngcun lawki he. Acunüng Jesuh naw ngthu pyenki. ");
INSERT INTO dao_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Acunüng, akxo cun khyang kphyü naw kawt u lü, Jesuha veia ami lawpüi. ");
INSERT INTO dao_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Khuiima khyang be se, Jesuha veia am ami cehpüi thei. Acunakyase Jesuha ngdanga mkyung ami kpäk. Acunüng mkyung kpäk lawpäng u lü akxo cun a ihnak phak mah maha ami ju khyak. ");
INSERT INTO dao_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuh naw ihlawka ami jumeinak dämki ti hmu lü, akxo üng, “Ka capa aw, na katnak he cun jah mhlät pänga kya ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Acunüng thum jah mtheiki avang ngawki he naw ami mlungmthin k’uma ngai kyu u lü, ");
INSERT INTO dao_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“I vaia hina khyang naw Mhnam ksekhanaka ngthu a pyen ni? Mhnama thea ta u naw katnak he jah mhlät thei khai ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuh naw acunkba ami ngaihkyu cun angxita ksing lü, “I vai acunkba nami ngaikyuki ni? ");
INSERT INTO dao_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Ini akxoa veia pyen a jäi bawk kawm? Na katnak he jah mhlät pänga kya ve ti la; tho law lü na ihphak lo lü cita ti aw a jäi bawk? ");
INSERT INTO dao_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Khyanga Capa naw khawmdek khana katnak he jah mhlät theinaka ana taki ti nami ksingnak vaia ka mdang khai,” ti lü, akxo üng, ");
INSERT INTO dao_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ka ning mthehki, tho law, na ihphak lo lü, na ima cit bea,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Avan naw ami teng k’um üng tho law lü, a ihphak lo lü, cit se aktäa cäi u lü, Mhnam mhlünmtai u lü, “Hina mäih am mi hmu khawi naw!” tia ng’yüngki he. ");
INSERT INTO dao_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesuh Kalile tuili kama cit beki. A veia khyang he law u se, Jesuh naw a jah mthei. ");
INSERT INTO dao_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A ceh lama, Levih naki Alphaha capa ngcawnklawk junga ngaw se hmu lü, “Na läk lawa,” ti se, Levih naw ngdüi law lü a läk. ");
INSERT INTO dao_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Acun käna Jesuh cun Leviha ima ei eiki. Ngcawnklawk he la akxawi he am Jesuh la axüisaw he ei ei khaia atänga ngaw hmaihki he. Isetiakyaüng, acuia awmki he cun khawjah law u lü, ami van naw Jesuh ami läka phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Acukba Jesuh ngcawnklawk he la khyangka he am ei aw hmaih u se Mosia Thum jah mtheikia pharise he naw ami hmu üng, axüisaw he üng, “Ise hin naw ngcawnklawk he la khyangka hea veia ei aw hngaki ni? ti u se, ");
INSERT INTO dao_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Acunüng Jesuh naw ngja lü, “Khyang kphetyai he naw Seibawi am hlü u, am phetyaikie naw ni Seibawi ami hlü, kei hin khyang ngsungpyune jah khü khaia am law lü khyangka he ngjutnaka jah khü khaia ni ka law,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Johana axüisaw he la pharise he naw ei jeihki he. Mhmüp mat üng khyang avang Jesuha veia law u lü, “Johana axüisaw he la pharise he naw ami ei jeihki he, ise nanga xüisaw he naw ami ei am jeihki he ni?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Acunüng Jesuh naw, “Khin he cun cambumkia cangpyang ami veia a awma küt üng ami ei ka cit be khai he aw? Cangpyang ami junga a awma küt üng ami ei am jeih u. ");
INSERT INTO dao_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","“Cunsepi cangpyang ami vei üngka naw, ami lakin lawnaka kcün pha law khai. Acunüng acuna mhmüp he üng ami ei jeih law khai he. ");
INSERT INTO dao_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“U naw suisak akthai kpyawn akphyüm am am kbun khawi naw, ami kbun üng akthai naw eitek se, acun käna ateknak ksehlen law khai. ");
INSERT INTO dao_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“U naw capyittui asü capyit um akphyüm üng am than khawi naw, acunkba ami than üng capyittui asü naw capyit um eipäk se, capyittui ngsawi lü capyit um pi se khai. Acunakyase capyittui asü cun capyit um akthai üng than khawiki he,” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesuh axüisaw he am loma lama Sabbath mhmüp üng ami ceh üng, axüisaw he naw cangvui he ami jah kpyat. ");
INSERT INTO dao_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Acun Pharise he naw hmu u lü Jesuh üng, “Tenga, Sabbath mhmüp üng na xüisaw he naw hinkba ami pawh hin mi thum üng am nglawiki ni!” tia ami pyen. ");
INSERT INTO dao_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesuh naw jah msang lü, “Davit naw acuna mhmüp üng a khyang he am ami ei ngai law u lü ami pawh am nami kheh khawiki aw? ");
INSERT INTO dao_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Acuna Pamhnama im üng lut lü Pamhnam üng peta muk eiki. Ktaiyü ktung Abithaa kcün pät üng kyaki. Mi thum üng ktaiyü ktung he däng naw ami ei theia muk Davit naw ei lü a khyang he üng pi a jah pet cen,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesuh naw, “Sabbath cun khyanga dawnak vaia pyana kyaki; khyang cun Sabbatha phäha pyana am kya. ");
INSERT INTO dao_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Acunakyase Khyanga Capa cun Sabbatha Bawia pi kyaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Acunüng Jesuh Sinakoka khuia a luh be üng, acuia a kut vang lam xokia khyang mat awmki. ");
INSERT INTO dao_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ami mkateinak vaia, Sabbath üng akxo a mdaw law be täng täng la am a mdaw law be k’et u lü ami teng. ");
INSERT INTO dao_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Acunüng Jesuh naw akutxo üng, “Ngdüi lü maa lawa,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Acunüng khyang he üng, “Mi thum naw Sabbath üng i ti vai ni a jah mtheh? Kpüi vai aw, mkhuimkha vai aw? Khyanga xünnak küikyan vai aw, mkhyüh vai aw?” ti lü jah kthäh se, I pi am pyen be u. ");
INSERT INTO dao_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesuh naw jah teng hü lü aktäa a mlung soki, cunsepi ami mlung nghlang lü ami kata phäha a pukseki. Acunüng akxo üng, “Na kut sänga,” ti se, akutxo naw a kut a säng la daw law beki. ");
INSERT INTO dao_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Acunüng pharise he Sinakok ceh ta u lü, Heroda khyang he am nghmu u lü Jesuh ami mkhyühnak vaia cengki he. ");
INSERT INTO dao_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesuh la axüisaw he Kalile tuilia cit u se khyang khawjah naw ami läk. Acuna khyang he cun Kalile khaw, Judah khaw, ");
INSERT INTO dao_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem mlüh, Idume khaw, Jordan pipei üngka he, Turah la Sidon mlüh hea pipei üngka naw law hüki he. Acun he cun Jesuh naw a bilawh he khawjah ami ngjaka phäha a veia lawkia kyaki he. ");
INSERT INTO dao_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Khyang aktäa adaa phäha a hama mlawngca ami nghängsak thüp thüp vaia axüisaw he a jah mtheh. Acun cun khyang he naw am ami net vaia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Khyang khawjah jah m’yai bekia kyase, ami hneh vaia ami ngcun law si. ");
INSERT INTO dao_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Khawyai hea awmnaka khyang he naw ami hmuh üng a maa kawp u lü, ngpyang u lü, “Nang Mhnama Capa!” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesuh naw khawyai he üng a unak ä ami pyen hü vaia a jah ksük. ");
INSERT INTO dao_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Acunüng Jesuh mcunga khana kai lü amäta ngaih he, a veia jah khü se lawki he. ");
INSERT INTO dao_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Acunüng, ngsä hea a jah sui a xü xaleinghngih he jah xü lü, “Ka veia nami ve khaia ka ning jah xüki” ti lü a jah mtheh. “Ngthu nami sang hü khaia ka ning jah tüi khai, ");
INSERT INTO dao_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","acunüng khawyai he nami jah ksät khaia ana nami ta khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A jah xüa xaleinghngih he cun: Sihmon, (Jesuh naw Pita a sui); ");
INSERT INTO dao_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedea capa xawi Jakuk la Johan, (Jesuh naw Boneraketa a jah sui, acun cun, “Mkyeka capa xawi”); tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Philip, Batolame, Mahte, Thomah, Alaphaha capa Jakuk, Thade, Zelot Sihmon ");
INSERT INTO dao_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","la Judah Iskarot, Jesuh cengkia khyanga kyaki he. ");
INSERT INTO dao_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Acunüng, Jesuh ima citki. Khyang khawjah ngcun law be u se, Jesuh la axüisaw he ami ei pi am ei hlawt u. ");
INSERT INTO dao_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Khyang he naw, “Hin hin yaw lawki va ni mäih ja,” ami ti a khuiim kyawnglawng naw sim u lü ngdumsak khai hea büki he. ");
INSERT INTO dao_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Thum mtheiki he avang Jerusalem üngka naw lawki he naw, “Hina k’uma Beelzebul um ve! acuna khawyai hea mkhawnga ana am ni khawyai he a jah ksät ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Acunüng, Jesuh naw a veia jah khü lü, msuimcäpnak am, “Ihawkba Khawyam naw Khawyam ksät thei khai? ");
INSERT INTO dao_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ia pung pi amimät ngtung’atki he cun khawvei am khäng u naw. ");
INSERT INTO dao_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ia khuiim kyawnglawng pi amimät ngtung’atiki he cun ngkyangtai khai he ni. ");
INSERT INTO dao_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Acunakyase Khawyam khaw ahnga hnga a ngkyangtai üng khawvei am khäng lü düt khai. ");
INSERT INTO dao_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“U naw khyang kyana im akcüka amät am a pinpawk ma küt üng a ima lut lü a khawhthem am yut thei naw. Acunakyase, im mah akyan cun khit ma khai. ");
INSERT INTO dao_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Akcanga ka ning jah mthehki, nghnicim khyanga ca hea katnak avan la Mhnam pyetsenaka katnakavan cun mhläta kya khai. ");
INSERT INTO dao_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Cunsepi, Ngmüimkhya Ngcim pyetseki cun itia pi mhläta am kya. Isetiakyaküng acun cun anglät katnaka kyaki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jesuh naw acun cun, “Hin naw khawyai a k’uma ta ve,” ami tia phäha a pyena kyaki.) ");
INSERT INTO dao_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Acunüng, Jesuha nu la a bena he pha lawki he. Kpunga ngdüi u lü khyang mat tüi u lü ami va khüsak. ");
INSERT INTO dao_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Khyang he a peia ngawki he naw, “Tenga, na nu la na bena he kpunga ve u lü ning sui ve u,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesuh naw jah msang lü, “U ni ka nu? Ue ni ka bena he?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A peia ngawki he ngvei lü jah tengki naw, “Teng u! hin he hin ka nu la ka bena he ni! ");
INSERT INTO dao_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","U pi Mhnama a ngjakhlü tiki avan cun ka bena, ka cina la ka nua kyaki he ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Acunüng, Kalile tuili peia jah mthei be se, khyang khawjah a veia ngcun lawki he. Acunüng lawkia khyang he cun aktäa dämda u se, Jesuh mlawnga khana kai lü ngawki. Khyang avan tui kama tuinu ma na u lü, ngkhäm lawki he. ");
INSERT INTO dao_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesuh naw msuimcäpnak he am hinkba khawjah a jah mthei, ");
INSERT INTO dao_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ngai ua, mhmüp mat üng khyang mat mci saw khaia citki. ");
INSERT INTO dao_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A saw k’um üng, mci avang lam khana kyakia kyase, kha he naw jawng law u lü, ami ei. ");
INSERT INTO dao_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mci avang nglei am a danak bäk, lunga danaka kyaki. Nglei am thahkia kyase angxita pyo lawki. ");
INSERT INTO dao_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nghngi lut law lü, khaw ngling law se, a pya am saükia kyase, ng’yawngki. ");
INSERT INTO dao_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mci avang nghling hmua kyaki, nghling saü law lü, yai se am vuipai thei. ");
INSERT INTO dao_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Cunsepi, mci avang nglei kdaw üng kyaki, cawt law lü, saü law lü, avang thumkip, khyukip la aphyaa ngtheipai lawki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Akbäihnaka Jesuh naw, “A ngjaknak vaia a nghnga taki naw ngja se,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesuh amät a ve üng, xaleinghngih he la akce läk hngaki he naw a veia law u lü msuimcäpnaka suilam a jah mtheh vaia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesuh naw, “Nangmia phäha ta, Pamhnama khawa mawng athukhlüng ksingnak vai ning jah peta kya ve, Cunsepi khyang kce hea phäha avan msuimcäpnak am pyena kyaki. ");
INSERT INTO dao_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Acunakyase, ‘Teng u lü pi, am hmu u, ngja u lü pi, am ksing u. Hmu ngja u lü Pamhnama veia ami nghlat be vai sü ta ani naw jah mhlät khai sü,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Acunüng Jesuh naw, “Hina msuimcäpnak am nami ksingki aw? Acunüng ihawkba msuimcäpnak avan nami ksing thei kawm? ");
INSERT INTO dao_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mciksaw naw Mhnama ngthu a saw. ");
INSERT INTO dao_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Acunüng, avang he cun lam kpema kyaki mci hea mäih lawki he, ngthu ami ngai la khawyam naw law lü ngthu cun a lawhei. ");
INSERT INTO dao_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Khyang avang he cun lunga danaka kyaki mci hea mäih lawki he. Ngthu ami ngjak üng jekyainak am doeiki he. ");
INSERT INTO dao_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Cunsepi, amimät üng apya am ve se, ivei am khäng. Acun käna thangkdaw phäha, mkhuimkhanaka pi kyase, khuikhanaka pi kyase, a pha law üng pyai beki he. ");
INSERT INTO dao_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Khyang avang he cun nghling hmua sawa mci hea mäih lawki he. Acun he cun ngthu ngjaki he, ");
INSERT INTO dao_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","cunsepi khawmdek cäicanak he, bawimangnak vai mnaiheinak la iyaw akce kce mnaiheinak he naw ngthu cun yai law u se, am vuipai thei. ");
INSERT INTO dao_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Cunsepi khyang kce he cun nglei kdaw üng sawa mci hea mäih lawki he. Acun he cun ngthu ngja u lü doeiki he, acunüng avang thumkip, avang khyukip, avang aphya vuipai lawki he,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Acuna thea Jesuh naw, “Mei kdäi u naw lawpüi lü kphya k’uma, am ani üng ihnaka kea thup khawiki aw? Angdangnaka vai khaia am ta khai aw? ");
INSERT INTO dao_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ipi ä ngdang khaia thup cun mdana kya law lü, ipi ä ngphyäü khaia mjih cun phyeha kya law khai. ");
INSERT INTO dao_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","A ngjaknak vaia a nghnga awmki naw ngja se,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesuh naw, “Nami ngjak cäi na ua! Khyang nami mtehnak am Mhnam naw ning jah mteh be khai, acuna kthaka pi ning jah mteh be khai. ");
INSERT INTO dao_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Upi taki üng pet däm däma kya lü, upi am taki cun a takca pi yuh pet bea kya khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesuh naw, “Pamhnama khaw cun khyang mat mci a loa sawki am tängki. ");
INSERT INTO dao_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mciksaw mthana ip lü mhmüpa tho lawki. Acun k’um üng mci cun pawk law lü ngbang lawki. Cunsepi ihawkba akya law am ksing. ");
INSERT INTO dao_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nglei amät naw vuipaiei lawsak khawiki. Akcüka aphung, avui, acunüng avui üngka naw akcang ngdang law khawiki. ");
INSERT INTO dao_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Avui a hmin law la, khyang naw cang ah kcünkia kyase, angxita ngvinca am atki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesuh naw, “Pamhnama khaw cun i am mtäng vai? Msuimcäpnak i am mtumtäng vai? ");
INSERT INTO dao_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pamhnama khaw cun khyang mat naw khawmdek khana jaw säihki anca ui lo lü nglei üng a saw am tängki. ");
INSERT INTO dao_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Cunsepi asäng ngsawk se, a cawt law üng loa sawngling avana kthaka ngbangbu law lü ngban mah law se kha he naw law u lü ami ngbu ami tuknak khawi,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesuh naw acunkba msuimcäpnak khawjah am ami ksing thei vaia ngthu a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Msuimcäpnaka kaa khyang hea veia ngthu am pyen khawi. Cunsepi, axüisaw he amimät ami awmnaka avan a jah mtheh be khai. ");
INSERT INTO dao_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Acuna mhmüp khaw a mü law üng, Jesuh naw axüisaw he üng, “Tuilia caye lama mi va pek vai u,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Acuna, khyang he akdäm jah yawk hüt u lü, Jesuh mlawng üng ngaw se ami cehpüi. Akce mlawngca he pi acunüng awmki he. ");
INSERT INTO dao_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Acunüng, khawkhi ksenu khi law se tuimvawn cun mlawng üng be law hlüki. ");
INSERT INTO dao_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesuh cun ngkhumnak üng ngkhumei lü mlawnga hnu lama ip lü ve se axüisaw he naw, “Saja aw, mi thih vai hin am na cäinaki aw?” ti u lü ami mthawh. ");
INSERT INTO dao_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesuh naw tho law lü khawkhi kse üng, “Ngdüma!” ti lü a mtheh. Acunüng tuimvawn üng, “Pyaia” ti se avan ngdüm lawki he. ");
INSERT INTO dao_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Acunüng Jesuh naw axüisaw he a veia, “I vaia nami kyükyawk aihki ni? Ise jumnak am nami taki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Cunsepi kyü law ngen u lü, “Khawkhi la tuimvawn naw pi a mtheh ani ngjak hin ia khyang ni?” tia ngthehei kyuki he. ");
INSERT INTO dao_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesuh la axüisaw he Kalile tuili caye, Kerasa khawa pha lawki he. ");
INSERT INTO dao_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mlawng üngka naw Jesuh a kco law la, ng’uhnün üngka naw lawki khawyaia awmnaka khyang mat naw ana khyum. ");
INSERT INTO dao_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Acun cun ng’uhnüna awmki, u naw mthiyüi am pi am ami khih thei; ");
INSERT INTO dao_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Khawveia mthiyüi am a kut la a khaw ami jah khih üng pi mthiyüie jah ksäkpat lü amcäm cäma a jah pawh. U naw pi am ami mcing theia vai aktä ktha mahki. ");
INSERT INTO dao_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Amhmüp amthan ng’uhnün he la khawmcung hea cit hü lü ngpyang lü, amät la amät lung am ng’at kyu lü awmki. ");
INSERT INTO dao_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesuh akhawsang üngka naw a hmuh üng a veia dawng lü a ma ngdäng lü, ");
INSERT INTO dao_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Jesuh, ak'hlüng säih Mhnama Capa aw! i ni nglak na se ni? Ä na na mkhuimkha vaia Pamhnama ngming am ning nghui na veng,” ti lü, angsanga ngpyangki. ");
INSERT INTO dao_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Acukba a tinak cun Jesuh naw, “Ngmüimkhya kse aw, hina khyang üngka naw lut lawa,” ti lü, a ksenaka phäha kyaki). ");
INSERT INTO dao_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Acunüng Jesuh naw, “Na ngming u ni?” ti se, Ani naw, “Ka ngming cun ‘Apä ni’ keimi cun khawjah kami lawki tinaka kyaki” a ti. ");
INSERT INTO dao_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Acun käna ngmüimkhya kse he naw khaw üngka naw ä a jah ksät vaia Jesuh aktäa a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Acuia mcung peia vawk khawjah ami jah mcah awmki. ");
INSERT INTO dao_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Acuna ngmüimkhya naw Jesuh üng, “Vawk hea veia jah tüia, acuia kami lut khai,” ti u lü, ami nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesuh naw ami luh vaia ti se, ngmüimkhya kse he cun khyang üngka naw lut law u lü vawk hea k’uma lutki he. Thawng nghngih lawkia vawk he cun ami van tuilia dawng u lü, kdang üng ngtäng u lü tui üng ngcumki he. ");
INSERT INTO dao_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vawk sämki he dawng u lü, mlüh k’um la ngnam k’uma jah va mtheh u se khyang he cun i thawnhlawki ti cun teng khai hea lawki he. ");
INSERT INTO dao_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesuha veia law u lü yai pä hea awmnaka khyang cun ngsuingsa lü akdawa a na ngaw se ami hmuh üng, aktäa kyüei lawki he. ");
INSERT INTO dao_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Acun hmuki he naw khawyai he awmnaka khyang ikba a awm la, vawk he ihawkba ami kya cun khyang he üng pi ami jah mtheh be. ");
INSERT INTO dao_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Acuna, Jesuh naw ami khaw a ceh tak vaia ami nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesuh mlawnga khana a kai be üng khawyai hea awmnak khawia khyang naw, “Na hlawnga cit hnga vang” ti lü a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Cunsepi Jesuh naw mah lü, “Na ima cit be lü, Bawipa naw na phäha ihlawka a pawh la na khana m'yeneinak a tak jah va mtheha,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Acunüng, acuna khyang naw cit lü Jesuh naw a phäha a pawh peta mawng cun Mlüh Xa üng va sang hü se ngjaki avan cäiki he. ");
INSERT INTO dao_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesuh tuilia caye kama mlawng am va pek se, acuia khyang khawjah a veia ngcun lawki he. ");
INSERT INTO dao_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sinakok mkhawng Jairuh ngmingnaki mat lawki naw Jesuh a hmuh üng a khaw kunga ngdäng lü, ");
INSERT INTO dao_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Ka ca, nghnumica aktäa mhnatei ve, phet be lü a xüngseinak vaia law lü na kut a khana mtaih lawa” ti lü aknuia a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Acunüng Jesuh a veia cit se khyang khawjah naw läk law u lü a hnuma kcung lawki he naw ami hneh. ");
INSERT INTO dao_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Acuia nghnumi kum xaleinghngih a thi put lü khuikhaki mat awmki. ");
INSERT INTO dao_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Seibawi khawjah naw ami ngnünak, ngui a tak avan am ngsawiei sepi am kyäpei be lü ksehlen law bawki. ");
INSERT INTO dao_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesuh ami ti a ngjak üng a hnua khyang hea ksunga lawki. ");
INSERT INTO dao_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“A suisak dänga hleng ka hneh üng ta ka phet be khai ni,” tia ngai kyuki. ");
INSERT INTO dao_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jesuha suisak a hneh. Acun la a thia put ngdüm lü a pumsa üng natnak daw bekia a sim. ");
INSERT INTO dao_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Acun la Jesuh naw a johit amät üngka naw akcea lut lawki ti a ksing la khyang hea ksunga nghlat lü, “U ni ka suisak hnetki?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Axüisaw he naw, “Hinkba khyang khawjah naw ning hneh u se hmu ye lü, ‘U ni na hnetki’ na tiki hin” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Cunsepi Jesuh naw hnetki hmu khaia nghlat lü teng hü se, ");
INSERT INTO dao_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nghnumi naw kyüh lü ngxet lü amät üng ihawkba akya ksingki naw law lü Jesuha ma ngdäng lü, a thawnhlawk akcang naküt a mtheh. ");
INSERT INTO dao_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Acunüng Jesuh naw, “Ka canghnu aw, na jumnak naw ning dawsak be ve. Dim’yenak am cita, na natnak üngka naw yai bea,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Acukba ana ngthuhei k’um üng khyang avang Sinakok mkhawng Jairuha im üngka naw law u lü, “I vaia Saja na kbawngkbaieiki ni? Na canu thihpäng ye se,” ami ti law. ");
INSERT INTO dao_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesuh naw ami pyen ia am msui lü Sinakok mkhawnga veia, “Ä kyüha, a jum dänga juma,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Acunüng Jesuh naw Pita, Jakuk la a na Johana thea u pi a hlawnga am ngkhahpüi. ");
INSERT INTO dao_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairuha ima ami law üng Jesuh naw ana üicai u lü, ana mbawikyapki he a jah hmu üng, ");
INSERT INTO dao_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Im k’uma lut lü, “I vaia üicai u lü nami kyapki ni? Hnasen cun thiki am ni, ipki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Acun he naw ami yaihei. Acuna Jesuh naw ami van kpunga a jah tüih käna hnasena a pa la a nu, acunüng amät jah a ngkhahpüi he am hnasen ami msännaka a jah luhpüi. ");
INSERT INTO dao_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Acunüng, hnasen cun a kut üng kpang lü, “Talita, Kumi,” a ti, acun cun “Nghnumica aw, tho lawa ti veng!” tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Acun la angxita nghnumica cun tho law lü cit hüki. (Ani cun kum xaleinghngih lawki). Acunüng avan cäi lawki he. ");
INSERT INTO dao_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Cunsepi, Jesuh naw u üng pi ä ami mtheh vaia jah ksük lü, “A ei vai iyaw pe ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Acuna hmün Jesuh naw ceh ta lü a ngnama cit be se axüisaw he naw pi ami läk. ");
INSERT INTO dao_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabbath mhmüp pha law se Sinakoka k’uma a jah mthei. Acunüng khyang khawjah awmki he; a ngthu pyen ngja u lü, “Hin naw hawia hina ngkhaw he a jah yahei hü ni? Hina veia themnak pet hin, ia themnak ni? Ahinkba sena müncankse he jah pawhki ni? ");
INSERT INTO dao_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hina khyang hin Mariha ca Jakuk, Josep, Judah la Sihmona ami ktai, imksa am kya aih se? A na he pi hin üng am awmki hea kya aih u se?” tia ami ma. ");
INSERT INTO dao_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesuh naw, “Sahma he cun amimäta ngnam, amimäta mjükphyüi la khuikkyawnga thea ta hmün naküta mhlünmtainak yahki he,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Am phetkia khyang he ajawca hea khana a kut mtaih lü a jah m’yai be thea ta müncankse bilawh i pi am pawh. ");
INSERT INTO dao_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Khyang he naw am ami jumeia phäha Jesuh aktäa müncaki. Acunüng ngnam he üng jah mthei hü lü ngvei hüki. ");
INSERT INTO dao_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesuh naw xaleinghngih he a veia jah khü lü nghngih cia a jah tüih. Ngmüimkhya kse he jah nängnaka ana a jah pet. ");
INSERT INTO dao_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ami ceh üng, “Ksawngkhe thea muk, kthäheinaka ngja, nami kcukcawk üng ngui ä nami jah cehei vai. ");
INSERT INTO dao_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Khawdawk nami ngcum vai, kcu nghngih ä nami cehei vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Acuna thea pi Jesuh naw, “Ahawiapi ami ning jah jenak üng nami ceh be vei acuna im üng nami awm vai. ");
INSERT INTO dao_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Am ami ning jah jenak la nami ngthu am ami ngainaka mlüha nami law üng, ceh ta u lü nami khaw üngka mput nami kha hüt vai. Acun cun ami phäha ngthumkhyanak vaia msingnaka kya khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Acunüng cit u lü, acuna khyang he ami katnak he üngka naw ami nghlat lawnak vaia ngthu va pyenki he. ");
INSERT INTO dao_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Khawyai he khawjah jah ksät u lü am phetki he khawjah Olip ksi am jah hluk u se yai beki he. ");
INSERT INTO dao_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sangpuxang Herod naw Jesuha ngming aktäa ngthang lawkia kyase a ngjak law. Khyang avang he naw, “Baptican Johan thihnak üngka naw tho law be ve. Acunakyase ni, hinkba khyaihbahnak he ani üng awm khai,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Avang he naw, “Elijah ni” ami ti. Avang he naw, “Hin hin ajana ka sahma hea kba, sahma mat ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod naw a ngjak üng, “Hin hin a lu ka khyüna Johan ni, thihnak üngka naw tho law beki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Isetiakyaüng, Herod naw a na Philipa khyu, Herodih yut lü khyu naki naw, acuna nghnumia phäha Johan cun jah mansak lü thawngim üng a khyuma kyaki. ");
INSERT INTO dao_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Johan naw Herod üng, “Na naa khyu na khyunak hin nglawiki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Acunakyase Herodih naw Johan cun hneng lü a mkhyüh vaia a bü, cunsepi Heroda phäha am hnim thei. ");
INSERT INTO dao_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Sangpuxang Herod naw Johan cun khyang kdawa kya lü, ngcimcaihkia ksingki naw kyüh lü aktäa a yung. Johana ngthu pyena phäha kyükyawk sepi, a ngthu pyen cun ngai hlüki. ");
INSERT INTO dao_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mhmüp mat üng, Herod naw a hminaka khawmhmüp pawi pawh lü a khyang ngvai he, yekap ngvai he, bawi he la, Kalile khaw üng khyang ngvai he am buh a jah pawh pet. Acunüng Heroda khyu Herodih naw Johan a hnimnak vaia kcün kdaw yahki. ");
INSERT INTO dao_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiha canu, nglaca law lü nglam lawki naw, Herod la a ngawhpüia khin he ami mlung aktäa a jah jesak. Acuna sangpuxang naw, “Ipi na ngaih kthäha, ka ning pe khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Acunüng Herod naw khyütam na lü, “Ipi na ngaih kthäha, ka uka khaw amte pi ka ning pe khai” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Acuna nglaca naw a nua veia cit lü, “Ini ka kthäh kawm?” ti se, A nu naw, “Baptican Johana lu,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Acunja nglaca angxita sangpuxanga veia va cit be lü, “Baptican Johana lu, angxita mlikbe üng na na pet vai ngaih veng!” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sangpuxang cun aktäa ngjutki, cunsepi a sitiha phäha la a veia ngawki khin hea phäha am ma thei. ");
INSERT INTO dao_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Acuna sangpuxang naw yekap angxita tüi lü, Johana lu a lawpüi vaia a mtheh. Yekap naw thawngima cit lü Johana lu a va khyün. ");
INSERT INTO dao_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Acunüng, Johana lu mlikbe üng lawpüi lü nglaca am pe se, nglaca naw a nu üng a pet. ");
INSERT INTO dao_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Johana axüisaw he naw ami ngjak üng a yawk va mhläm u lü ami k’ut. ");
INSERT INTO dao_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ngsä he Jesuha veia law be u lü ami pawhmsah he la ami jah mtheimthange avan ami mtheh law be. ");
INSERT INTO dao_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Khyang khawjah citcawn hüki hea kyase, Jesuh la axüisaw he ei, ami ei vaia pi am ngbünei u. Acuna Jesuh naw “Khyang am a awmnaka mi cit vai u, namimät awm u lü asäng nami xüieinak thei vaia,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Acuna angxinaka mlawng am amimät citki he. ");
INSERT INTO dao_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Cunsepi ami ktawih jah hmu u lü, ami unak jah ksingki he naw, ami van mlüh avan üngka naw kawng lama ana dawng u lü, Jesuh la axüisaw he am ami pha phat üng phaki he. ");
INSERT INTO dao_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesuh mlawng üngka naw kyum law lü khyang aktäkpai, toksäm am awmkia to hea kba law u se jah hmu lü, aktäa mthinmhnateiki. Acunüng tün lü khawjah a jah mthei. ");
INSERT INTO dao_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Khaw mü law se axüisaw he a veia law u lü, “Hin hin angxinak khawkhyawng khawa kyaki, khaw pi mü pängki. ");
INSERT INTO dao_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Khyang he jah tüi bea, ahina pipei ngnam he la lomaea ami ei vai kheihei hü u se,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesuh naw, “Nangmi naw ami ei vai iyaw jah pe ua,” a ti. Axüisaw he naw, “Cit u lü, denarih ngui phya nghngihphu muk ei vai va khei u lü kami jah pe khai aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesuh naw, “Muk, ijah nami taki aw? Cit u lü va teng ua,” ti se. Hmu u lü, “Muk mhma la nga nghngih,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesuh naw axüisaw he üng msai kxünga khana aphäh phäha ami jah ngawhsak vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Acunüng avang aphya, avang mhmakip phäh phäha ngawki he. ");
INSERT INTO dao_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Acunüng Jesuh naw muk mhma la nga nghngih jah lo lü, khana mang lü, Mhnama veia jenak pyen lü, muk cun boki naw ami yet vaia axüisaw he üng a jah pet. Nga nghngih pi bo lü a jah pet. ");
INSERT INTO dao_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ami van naw ei u lü phüki he. ");
INSERT INTO dao_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Axüisaw he naw muk la nga mnawi mkhäm u se, cä xaleinghngih lawki. ");
INSERT INTO dao_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Muk eiki he cun kpami däng thawng mhma lawki he. ");
INSERT INTO dao_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesuh naw khyang he a jah ngpyengsak k’um üng, axüisaw he mlawnga khana jah luhsak ktäih lü, caye tuili kam Bethsaida mlüh da a jah cehsak. ");
INSERT INTO dao_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Acukba khyang he a jah khyah käna amät cun ktaiyü khaia mcunga citki. ");
INSERT INTO dao_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Khawmü lama mlawng tuili nglung üng ve se, Jesuh amät kawnga awmki. ");
INSERT INTO dao_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Acunüng khawkhi naw ami mlawng vei hü hü se, am va pek thei u lü ami ve k’um üng, ngawi lam naji kthum la khyuka nglak üng Jesuh tuia khana ami veia lawki. Jah khye law hlü lü, ");
INSERT INTO dao_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","tuia khana cit se hmuki he naw ngmüimkhyaa sui u lü ngpyangki he. ");
INSERT INTO dao_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ami van naw hmu u lü, kyühki he. Jesuh naw, “Dim’yenak am ve ua, kei ni, ä kyüh ua,” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Acunüng ami veia mlawnga khana kai hnga se khawkhi ngdümki. Acunüng ami van aktäa cäi leng lengki he. ");
INSERT INTO dao_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Isetiakyaüng muk am a jah mcaha mawng pi akcanga am ami ksing theia phäha kyaki; ami ngaikyunak naw am ksing thei. ");
INSERT INTO dao_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tuili khe u lü ami va pek käna Kenesaret mlüh kawnga pha law u lü, tui kama ami mlawng cun ami kphung. ");
INSERT INTO dao_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mlawng üngka naw ami kyum law la khyang he naw Jesuh cun ami ksing law. ");
INSERT INTO dao_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Acunakyase khaw üngka avan dawng law u lü, Jesuh awmki ti ami ngjaknak avana, am phetki he cun ami ngjännak maha a veia ami jah kawh law. ");
INSERT INTO dao_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ahawia pi Jesuh a cehnak ngnam avan, mlüh avan la loma avana, am phetkia khyang he jah lawpüi u lü khyang hea ngcunnak hmüna jah ta hüt u lü, a suisak mdawngca hleng hnet vaia ami nghuinak. Acunüng hnetki avan cun phet beki he. ");
INSERT INTO dao_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pharise avang he la thum jah mtheiki he Jerusalem üngka naw law u lü Jesuha veia ngcun lawki he. ");
INSERT INTO dao_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Acunüng axüisaw he naw ami kut mtüihkheh am ei u se jah hmu u lü ami jah msing, acun cun Pharise hea kba ami kut am ami mthiheia kyaki. ( ");
INSERT INTO dao_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Isetiakyaüng, Pharise he la Judah he naw pupa thum läk u lü ami kut aküa am ami mthi üng ei am ami ei khawia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jawituknak üngka naw ami lawpüi ipi am mthi lü am ei u. Pupa thum khawjah läk piling vaia ami ngai he cun khawt he, k’am he, mlikbe he la ihnak he jah mthia ngkhaw hea kyaki.) ");
INSERT INTO dao_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Acuna Pharise he la thum jah mtheiki he naw, “Ise na xüisaw he naw pupa he naw jah mthei u lü ami jah tak hüta thum am läk u lü, ami kut mtüihkheh am ei aw sawxatki he ni?” tia, ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesuh naw jah msang lü, “Hesajah naw nangmia hleihlaknak hinkba a pyen hin cang ve: ‘Hina khyang he naw ami m'yawng am na ngak u lü, ami mlungmthin am na thuk ta ve u. ");
INSERT INTO dao_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Amdanga na sawkhah u lü, khyanga thum he Mhnama thum hea kba jah mtheiki he!’ a ti cen, ");
INSERT INTO dao_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pamhnama ngthupet yawk u lü khyanga thumcam nami läki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesuh naw pyen be lü, “Pamhnama ngthupet nami yawknak vaia phäha namimäta thumcam nami ktung naki. ");
INSERT INTO dao_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosi naw, ‘Na nu la na pa na jah mhlünmtai vai, u pi a nu la a pa jah ksenaki cun mkhyüh vai’ a ti ");
INSERT INTO dao_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Cunsepi khyang naw a nu la a pa üng a pet vaia khawhthem ta mah mah lü, ‘hin hin Koban ni’ (Koban ti cun mhnama ka ni tinaka kyaki) ti lü, ");
INSERT INTO dao_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","a nu pa am a jah kpüikpaknak vaia lam suiki. ");
INSERT INTO dao_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ahinkba namimäta nami jah mtheimthangnak am Mhnama ngthu nami yawkki. Acukba am dawki nami pawh khawjah awmki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Acunüng Jesuh naw khyang khawjah a veia jah khü be lü, “Nami van naw na ngai u lü, ksing ua. ");
INSERT INTO dao_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nami m'yawng üng ju lutkia nami ei naw pamhnam hjawhkhahnak vaia am ning jah mtüihkhehsak ve, cunsepi nami m'yawng üng lut lawkia ngthu naw ni a ning jah mtüihkhehsak ve” a ti. ");
INSERT INTO dao_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesuh cun khyang he jah yawk lü ima lut se, axüisaw he naw acuna suilam a jah mtheh khai vaia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesuh naw, “Nangmi pi ahikba sena am nami ngsümki aw? Am nami ksingki he aw? M'yawng üng lutkia ei naw khyang am mtüihkhehsaki tia angsinga nami ksingki. ");
INSERT INTO dao_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","M'yawng üng lutki cun khyanga mlungmthin k’uma am lut lü a khawnua k’uma ni a luh ve. Acunüng a pumsa üngka naw kpunga lut law bekia kyaki,” a ti. (Acun a pyenak am Jesuh naw ei avan ei vaia nglawiki a tinaka kyaki.) ");
INSERT INTO dao_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesuh naw pyen be lü, “Khyanga k’um üngka naw lut lawki naw va khyang mtüihkhehsak theiki. ");
INSERT INTO dao_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Isetiakyaüng khyanga mlungmthin k’uma am dawkia ngaihkyunak, m'yuknak, khyang hnimnak, ");
INSERT INTO dao_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","khyanga khyuca katnak, khyanga ka mnaiheinak, am dawkyaki avan jah pawhmsahnak; hleihlaknak, hüipawmnak, ng’eihkyünak, pyenksenak, awhcahnak ja yunak, ");
INSERT INTO dao_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ahina am dawki he avan cun khyanga k’um üngka naw lut law lü khyang mtüihkhehsakia kyaki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Acunüng Jesuh tho law lü Turah mlüh hne peia citeiki. Im mata lut lü u naw pi am a ksing vai ngaih teki, am ngthup thei. ");
INSERT INTO dao_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nghnumi mata a canu ngmüimkhya ksea awmnak Jesuha mawng a ngjak üng law lü a khaw kunga ngdäng lawki. ");
INSERT INTO dao_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Acuna nghnumi cun Krik nghnumi, Siria khaw Phoinikia hnea hmikia khyanga kyaki. Ani naw a canu üngka khawyai Jesuh naw a ksät vaia a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Cunsepi Jesuh naw, “Ca he jah mbei ma vai. Ca hea ei lo u lü ui he jah tawn pet vai hin am nglawiki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nghnumi naw, “Bawipa aw, cang veki, cunsepi ui he naw pi hnasena buhkbaw mthüpei khawiki he ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Acunüng Jesuh naw, “Na ngthua phäha, ima cita, canu üngka naw khawyai dawng päng se na hmu khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nghnumi naw ima cit be lü a canu üngka khawyai dawng se, a canu a ihnak üng ngkaw se a hmuh. ");
INSERT INTO dao_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesuh Turah üngka naw Sidon mlüh da cit lü Kalilea phaki. Mlüh Xa khe pah lü citki. ");
INSERT INTO dao_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Khyang he naw khyang mat am ngthuhei thei lü a nghnga pi pangki Jesuha veia lawpüi u lü a khana a kut a taih vaia ami nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Acunüng Jesuh naw khyang hea ngbumnak üngka naw akcea khü lü a kutpyün a nghnga khuia ktun lü, a mci am msawh lü a mlei a hneh. ");
INSERT INTO dao_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Acunüng Jesuh khankhaw da jeng mang lü, “Ephata,” a ti. Acun cun “Nghmawng lawa!” tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Acunja angxita ngja law be thei lü a mleiyüi pi daw law se angsinga ngthuhei law theiki. ");
INSERT INTO dao_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Acunüng Jesuh naw u üng pi ä ami mtheh vaia a jah ksük; Cunsepi jah mtheh däm däm se ami sang däm däm u. ");
INSERT INTO dao_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Acunüng aktäa cäi law u lü, “Hin naw avan jah mdaw be ve! A nghnga kpange pi jah ngjaksak be lü angki he pi jah ngthuheisak be ve!” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","I vei am ngsawk ham se, khyang khawjah Jesuha veia ngbum law be tüki he. Ami ei vai ipi am lawei u se, Jesuh naw axüisaw he jah khü lü, ");
INSERT INTO dao_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Hina khyang he naw na mthimhmatei ve u, mhmüp kthum ka veia awm pängki he atuh ami ei vai ipi am ve. ");
INSERT INTO dao_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ei ka ami ima ka jah tüih be üng mä lam cäpa bawng u lü khuikha khai he ni; isetiüng avang he bawk bawk ta ami lawnak thuksihki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Axüisaw he naw, “U naw, hina khawkhyawng khawa khyang hijaha ei khyawh vai hmu thei khai ni?” tia ami msang. ");
INSERT INTO dao_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesuh naw, “Muk ijah nami taki?” ti lü jah kthäh se, “Khyüh” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesuh naw khyang he mdeka khana a jah ngawsak. Acunüng muk khyüh lo lü Pamhnama veia jenaka ngthu pyen lü, jah bo lü, axüisaw he am khyang hea veia ami jah yet vaia jah pe se, axüisaw he naw ami jah yet. ");
INSERT INTO dao_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nga ajaw ami tak pi Jesuh naw Pamhnama veia jenak pyen lü ami yet vaia axüisaw he a jah pet. ");
INSERT INTO dao_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ami van naw ei u lü phüki he. Ami ei käna axüisaw he naw mkhäm u se akpawih cä khyüh lawki. ");
INSERT INTO dao_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eikie cun thawng phyü lawki he. Acun käna jah tüih be se ");
INSERT INTO dao_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","mlawng üng axüisaw he am lut u lü Damanuta khawa citki he. ");
INSERT INTO dao_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharise avang Jesuha veia law u lü ngcuhpüiki he naw, Pamhnam naw a kcangnak angsingnak vaia mhnüteinak khanaka müncankse ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Cunsepi Jesuh naw a mlungmthin k’uma aktäa ngko lü, “Ise atuha kcün khyang he naw müncankse ami kthäh ni? Akcanga ka ning jah mthehki! Msingnak mat pi am ning jah mhnüh hlü ve nawng,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jah yawk hütki naw mlawng üng lut be lü tuili cayea citki. ");
INSERT INTO dao_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Axüisaw he naw ami ei khyawh vai muk mhnih hüt u lü mlawng üng muk mat däng taki he. ");
INSERT INTO dao_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesuh naw, “Pharise hea nghngenla Heroda nghngen üng ngxungei kyu u lü ngcäiei na ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Axüisaw he naw, “Muk am mi ta se va hinkba pyen mäih ja,” tia ngthähki he. ");
INSERT INTO dao_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesuh naw ami ngthäh kyu jah ksing lü, “I vai muk am nami taka phäha nami ngthäh kyuki ni? Atuh pi nami mlungmthin am am nami ksing hamki aw? Nami mlung nghlang hamki aw? ");
INSERT INTO dao_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mik mah u lü am nami hmuki aw? Nghnga mah u lü am nami ngjaki aw? Am nami süm hamki aw? ");
INSERT INTO dao_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kei naw muk mhma khyang thawng mhma phäha ka pawh üng, kpawihki cä ijaha ni nami kaw?” ti se, amimi naw, “Xaleinghngih,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Acun käna muk khyüh khyang thawng kphyüa phäha ka pawh üng kpawihki cä ijah ni nami kaw?” ti se, amimi naw, “Cä khyüh,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesuh naw, “Acunüng ihawkba am ksing u lü nami awmki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bethsaida khawa law u se Jesuha veia a mik müki mat khyang avang naw lawpüi u lü a hnet vaia ami nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesuh naw a mik müki a kut üng kpang lü ngnam kpunga cehpüiki naw, a mik üng msawh lü a kut a khana mtaih lü, “Ini na hmu thei,” ti lü, a kthäh. ");
INSERT INTO dao_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A mik müki naw jeng mang lü, “Ä, khyang he thinga mäiha cit hü u se jah hmu veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesuh naw a kut cun a mika khana mtaih beki naw, yet lü a teng süm vaia a mtheh. Acunüng a mik vai law be se, avan a ngkhaia hmu theiki. ");
INSERT INTO dao_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesuh naw a ima tüi be lü, “Ngnam k’uma ä cit bea,” ti lü a mtheh. ");
INSERT INTO dao_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Acunüng Jesuh la axüisaw he cun Kesari Philipih pei ngnam hea citki he. Lama, “Khyang he naw, ua ni ami na ngaih?” ti se, ");
INSERT INTO dao_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Baptican Johan; avang naw Elijah; avang naw sahma he üngka mat mat,” ti ve u ami ti. ");
INSERT INTO dao_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesuh naw, “Nangmi naw mä ua ni nami na ngaih?” ti se, Pita naw, “Nang cun Mesijah ni,” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Acunüng Jesuh naw, “U pi ä mtheh ua” a ti. ");
INSERT INTO dao_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Acunüng Jesuh naw, “Khyanga Capa cun mkhuimkha khai he, axüngvai he , ktaiyü ktung he la, thum jah mtheiki he naw mah u lü, hnim khai he, acunüng amhmüp kthum üng tho law be khai,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Acukba angsinga ngthu jah mtheh se Pita naw akcea khü lü a ksenak. ");
INSERT INTO dao_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Cunsepi Jesuh naw nghlat hü lü, axüisaw he jah teng lü, Pita üng, “Khawyam aw, ka vei üngka naw cita; na ngaihkyunak Pamhnama vei üngkaa am kya lü khyang üngkaa ni a kya ve,” ti lü a ksenak be. ");
INSERT INTO dao_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Acunüng Jesuh naw khyang he la axüisaw he a veia jah khü lü, “Upi ka veia na läk law khaia büki naw amät naw amät yawk lü, a kutlamktung kawt lü, na läk law se. ");
INSERT INTO dao_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Isetiakyaüng, upi amäta xünnak küikyanei khaia büki naw mkhyüh lü, upi a xünnak keia phäha ja thangkdaw phäha mkhyühki cun naw küikyanei khai. ");
INSERT INTO dao_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Khyang naw khawmdek avan ka na lü, a xünnak a mkhyüh üng i ngmang na khai ni? I am ngmang na. ");
INSERT INTO dao_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A xünnak a yahnak be thei vaia i am pi am thawng be thei. ");
INSERT INTO dao_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hina Mhnam am ktäkie la katnaka mhmüp he üng, upi kei la keia mtheimthangnaka phäh ngkekhyakeiki he cun Khyanga Capa naw pi a Pa hlüngtainak la khankhawngsä ngcim he am a law be üng jah ngkekhyakei na be khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Acunüng amät kung naw ami veia, “Ka ning jah mthehki, hin üng ngdüiki he avang cun Pamhnama khaw hlüngtainak am pha law se, am hmu pha u lü am thi khai he awmki he,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Amhmüp khyuk käna Jesuh naw, Pita, Jakuk la Johan jah khü lü angxinak khawmcung, a hlüngnaka a jah cehpüi. Acunüng ami maa Jesuh a hmai halangei lawki. ");
INSERT INTO dao_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A suisak he cun khawmdek khana suisak msawpkie u naw pi acunkba bawk khaia am ami msawp thei vaia bawk lawki. ");
INSERT INTO dao_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Acunüng Elijah la Mosi cun Jesuh am ngthuhei ni se axüisaw kthum he naw ami jah hmuh. ");
INSERT INTO dao_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita naw, “Saja aw, hia mi ve hin daw ve! na phäha mat, Mosia phäha mat, Elijaha phäha mat, sam kthum pha va üng,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ami van kyü ngenki hea kyase, Pita naw i a ti vai am ksingei. ");
INSERT INTO dao_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Acunüng khawngmei lawki naw a jah ksungin law; kthaih ngmei üngka naw, “Hin hin ka jawng'engnaka ka Capaa kyaki ni, a ngthu ngai ua,” tia ngthang lawki. ");
INSERT INTO dao_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Acun käna ami pipei ami teng üng i pi am hmu u lü Jesuh däng ami veia ve se ami hmuh. ");
INSERT INTO dao_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mcung üngka naw ami kyum law be üng Jesuh naw, “Khyanga Capa thihnak üngka naw am a thawh law be phata küt üng nami hmuhtheh he u pi ä jah mtheh ua” ti lü a jah ksük. ");
INSERT INTO dao_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","A mtheh ngjaki he, acunüngpi, “Thihnak üngka naw thawh be tia suilam hin i ni?” tia amimät ngthäh kyuki he. ");
INSERT INTO dao_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Axüisaw he naw Jesuh üng, “Ise thum jah mtheiki he naw Elijah law ma khai ami ti ni?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesuh naw, “Elijah cun law ma kung lü avan jah pyangtham law be khai. Ise cangcim naw Khyanga Capa mah u se aktäa khuikha khai a ti ni? ");
INSERT INTO dao_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ka ning jah mthehki, Elijah pi law päng se a mawngma a ng’yuka kba amimäta ngaih ngaiha ami pawh,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesuh axüisaw he a veia a law üng khyang he khawjah naw jah ngbum si u lü, thum jah mtheiki he naw jah mtaipüi u se a jah hmuh. ");
INSERT INTO dao_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Acunüng Jesuh ami hmuh la khyang ami van naw aktäa cäi law u lü a veia dawngkie naw ami hnukset law. ");
INSERT INTO dao_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesuh naw a xüisaw he üng, “Acane am i nami ngcuhki ni?” ti lü a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Khyang mat ami ksung üngka naw, “Saja aw, ka capa khawyai naw ve na se am ngthuheiki na veia ka lawpüi. ");
INSERT INTO dao_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A man law naküt üng mdek üng a kyuksak; acunüng a mcimvawne jah mhlawn lü, a ha jah kyet lü, cai law lü, ve khawiki; na xüisaw he am ami ksät vaia ka jah mtheh amimi naw pi am ksät khawh ve u,” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesuh naw, “Aw, jumeinak am takia khyang he, ivei nami hlawnga ka awm khai aw? Ivei nami hlawnga ka ve khai ni? Ka veia hnasen cun lawpüi ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jesuha veia ami lawpüi. Khawyai naw Jesuh a hmuh la, hnasen cun aknuia pawh lü mdek vawih na se ngtat hü lü a mcimvawn lawng lawki. ");
INSERT INTO dao_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesuh naw a pa üng, “Ahinkba a awmnak ivei law pängki ni?” ti lü kthäh se a pa naw, “Angmawca üng a tünei ni, ");
INSERT INTO dao_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","hnim hü lü khawvei mei üng, tui üng a buhtawn khawi; Cunsepi na mdaw be khawh üng ta jah m’yenei lü jah kpüia,” ti lü a nghuinak. ");
INSERT INTO dao_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesuh naw “Ä” ti lü, “Na jumki aw? Jumkia phäha avan kya theiki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hnasena pa naw ngpyang lü, “Jum veng, Cunsepi ka jumnak am khäk ve; ka jum lawnak däm vaia na kpüia,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesuh naw khyang he naw jah k’et lawki he ti a jah ksing üng khawyai üng, “Pang lü, angkia ngmüimkhya, hina hnasen üngka naw lut law lü, a veia ä lut be tia,” ti lü a ksenak. ");
INSERT INTO dao_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Acunüng khawyai cun ngpyang lü, hnasen kthüng lü, lut lawki. Hnasen cun akthia mäiha ve law se khyang naküt naw, “Thi ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesuh naw hnasen cun a kut üng kpang lü mtho se, ngdüi lawki. ");
INSERT INTO dao_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Acun käna Jesuh im k’uma a luh law üng axüisaw he naw, “Ise keimi naw am kami ksät thei ni?” tia, ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesuh naw, “Hina mäih cun ktaiyünaka thea ta i am ksät thei vaia am kya naw,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesuh la axüisaw he ngnam ceh ta u lü Kalile da citki he. Jesuh naw a awmnak u naw pi a ksing vai am a ngaih. ");
INSERT INTO dao_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Isetiakyaüng, axüisaw he üng, “Khyanga Capa cun khyang he üng ap khai he, hnima kya khai, acun käna amhmüp kthum üng tho law be khai,” ti lü a jah mtheia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Cunsepi axüisaw he naw a jah mtheimthangnak am ksing u, ami kthäh vaia pi kyüh u lü, am kthäh u. ");
INSERT INTO dao_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapenawma law u lü, im k’uma ami ve k’um üng, Jesuh naw axüisaw he üng, “Lam cäpa i nami mtaiki?” ti lü a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lam cäpa amimät he üng u kyäp säih khai tia mtaiki hea kyase ami van naw am ami msang. ");
INSERT INTO dao_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Acunüng Jesuh naw a ngawhnak üng xaleinghngih he jah khü lü, “Upi a ma säih vai ngjahlüki cun hnu säih lü, avana m'yaa kya se,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesuh naw hnasenca mat khü lü ami ksung üng a ngdüihsak. Acunüng a kut am kpawm lü, ");
INSERT INTO dao_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Upi hina hnasenca he üngka mat ka ngming üng doeiki cun kei na dokia kyaki; acunüng upi kei na doki cun, kei däng na dokia am kya lü kei na tüih lawkia ka Pa pi dokia kyaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johan naw, “Saja aw, khyang mat mi hlawnga am ngkhap hü hngaki naw na ngming am khawyai he jah ksät se kami hmuh, mi hlawnga am ngkhap hü hngakia kyase a bilawh kami mkhye,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesuh naw, “Ä mkhye pe ua, ka ngming am müncankse vai pawhmsahki naw acun käna akjäiha am na pyetse khai ni. ");
INSERT INTO dao_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mimi am jah hnengki cun mimi da awmkia kyaki ni. ");
INSERT INTO dao_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ka ning jah mthehki, upi ka khyanga nami kyaa phäha awk vai tui a khawtca ning jah peki cun a ngkhyengnak vai am lap khai ni. ");
INSERT INTO dao_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Upi hnasena kba kei na jumki kyukngtängsaki cun a nghngü üng ksumnu khawp u lü mliktui üng tawnin üng daw bawk khai ni. ");
INSERT INTO dao_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Acunakyase na kut naw a ning katkawngsaki üng khyüngina! Kut nghngih küm se, am dim theikia mulaia na ceha kdama ta, kut am küm se xünnaka pha hin na phäha daw bawki ni. ");
INSERT INTO dao_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Na khaw naw a ning katkawngsak üng xüngina! Khaw nghngih küm se, mei am dim theikia mulaia na ceha kdama ta, khaw am küm se xünnaka pha hin na phäha daw bawki ni. ");
INSERT INTO dao_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na mik naw a ning katkawngsak üng kawihina! Na mik küm se mulaia na ceha kdama ta, mik mat däng am Pamhnama khaw na luh hin daw bawki ni. ");
INSERT INTO dao_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Acuia jah eikia mkyüt am thi lü jah uikia mei pi am dim thei. ");
INSERT INTO dao_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ngkengnaka sa mci am caihsaka kba khyang avan mei am caisak vai. ");
INSERT INTO dao_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mci hin dawki ni; Cunsepi a tuinak a khyüh üng ihawkba nami tuisak be khai ni? Mcia kba tuikia ngkhawteinak ta u lü, mat la mat dim’yenak am awm ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Acunüng Jesuh Judah khaw da cit lü Jordan mliktui khe paki. Khyang he a veia ngcun law be u se Jesuh naw a ti khawia kba a jah mthei be. ");
INSERT INTO dao_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharise avang naw law u lü a ngthu ami man vaia phäha, “Khyang naw a khyu a yawk vai hin mi thum üng nglawiki aw?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesuh naw, “Mosi naw ia thum ni a ning jah pet?” ti lü ngthähnak am a jah msang be. ");
INSERT INTO dao_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Amimi naw, “Mosi naw ngtainaka kca yu u lü, khyu cun mtai vaia a ti ni,” tia ami msang. ");
INSERT INTO dao_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesuh naw, “Ning jah mthei vaia nami mlung nghlang se, Mosi naw acunkba thum a ning jah yuk pet ni. ");
INSERT INTO dao_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Cunsepi, cangcim naw a pyena kba, ‘mhmünmcengnak atünei üng Mhnam naw nghnumi la kpami a jah mhmün’ tia kyaki. ");
INSERT INTO dao_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Acunakyase kpami naw a nu la a pa jah yawk lü, a khyua veia ngdawnkhai, ");
INSERT INTO dao_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","acunüng nghngih cun mata kya law khai.’ Acunüng ni nghngiha am kya ti lü mata kya law khai. ");
INSERT INTO dao_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Acunakyase Mhnam naw atänga a jah mdawn päng khyang naw ä jah mtai se,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ima ami ceh be käna axüisaw he naw acuna mawng bä cun ami kthäh be tü. ");
INSERT INTO dao_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesuh naw, “Upi a khyu yawk lü akce khyu na beki cun a khyu katnaki ni. ");
INSERT INTO dao_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Acun kba nghnumi pi a cei yawk lü akce cei na beki cun a cei katnaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Avang naw hnasen he, Jesuh naw ami khana a kut a mtaih vaia a veia jah lawpüi u se, axüisaw he naw lawpüiki he ami jah kdunak. ");
INSERT INTO dao_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesuh naw ksing lü thüiki naw, “Hnasen he ka veia law u se, ä jah mah ua, Pamhnama khaw cun amimia mäiha phäha kyaki ni. ");
INSERT INTO dao_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Akcanga ka ning jah mthehki, upi Pamhnama khaw hina hnasen naw a dokhameia kba am dokhameiki cun acuia am lut khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Acunüng Jesuh naw hnasen he a ban am jah jäk lü, ami khana a kut mtaih lü, josenak am jah kbeki. ");
INSERT INTO dao_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesuh lam üng a ceh k’um üng khyang mat a veia dawng law lü, a ma ngdäng lü, “Saja kdaw aw, anglät xünnak ka yahnak thei vaia i ka pawh khai?” ti lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesuh naw, “Ivai saja kdaw tia, na na khüki ni? Mhnama thea u mat pi am daw naw. ");
INSERT INTO dao_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","‘Khyanga khyu ä na katnak vai; khyang ä na hnim vai; ä na m'yuk vai; ä na hleihlak vai; khyanga ka am hman müi se ä na bi vai; na nu la na pa na jah mhlünmtai vai’ tia ngthupet he cun na jah ksingki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Acuna khyang naw, “Saja aw, ahin he avan cun ka nghmawca üng tün lü, ka jah läk päng ni,” ti se, ");
INSERT INTO dao_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesuh naw jawng'engnaka mlungmthin am teng lü, “Mat kpawih na veki. Cit lü na taka khawhthem avan jawi lü sim'yaki he am jah pea, khankhawa bawimangnak na yah khai ni; acunüng law lü na läk lawa,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Acun bawimangpa naw a ngjak la aktäa khawhthem danakia kyase, a hmai se lü thuiseinak am citki. ");
INSERT INTO dao_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Acunüng Jesuh naw mdei hü lü axüisaw he üng, “Khawhthem danaki he, Pamhnama khaw ami luh vai aktäa khak ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Acuna ngthua phäha axüisaw he cun aktäa cäiki he. Acunüng Jesuh naw, “Ka ca he aw, Pamhnama khaw luh vai aktäa khak ve! ");
INSERT INTO dao_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bawimangki, Pamhnama khaw a luha kdama ta, kulauk mpyüma nghnga üng a luh vai jäi bawk ve,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Acuna axüisaw he aksehlena cäi law u lü, amimät la amimät, “Am ani üng u küikyana kya thei khai aw?” tia ngthäh kyuki he. ");
INSERT INTO dao_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesuh naw jah teng lü, “Khyanga phäha hin hin khaki ni, Cunsepi Mhnama phäha khaki i am ve naw,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Acunüng Pita naw msang lü, “Tenga, avan jah yawk hüt u lü kami ning läk law hin,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesuh naw, “Akcanga ka ning jah mthehki, kei la thangkdaw phäha a im, a bena he la, a nu pa, a ca he, a khawloe jah yawkki naw, ");
INSERT INTO dao_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Atuh xün k’um üng däm bawki jah yah be khai. Ime, a bena he, a nu pa he, a ca he, a khawloe la mkhuimkhanak he pi aphyaa däm bawki jah yah be lü, pha law khaia kcün üng anglät xünnak pi yah be khai. ");
INSERT INTO dao_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cunsepi, atuh khawjah maki he hnu u lü, hnuki he ma law khai he,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesuh la axüisaw he Jerusalem cehnaka lam üng awmki he. Jesuh cun axüsaw hea hmaia ma lü cit se kcäväki he. A hnu läk law hngaki he kyü lawki he. Jesuh naw xaleinghngih he akcea jah khü lü a khana pha law khai jah mthehki naw, ");
INSERT INTO dao_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ngai u, Jerusalema mi jeng cit khai he, acuia Khyanga Capa cun ktaiyü ktung he la thum jah mtheiki hea veia cenga kya khai. Amimi naw thi khaia mkatei u lü khyangmjükce he üng msum khai he. ");
INSERT INTO dao_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Acun he naw yaihei khai he, msawh khai he, kpai khai he, hnim khai he; Cunsepi amhmüp kthum üng tho law be khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Acunüng Zebedea capa xawi Jakuk la Johan Jesuha veia law ni lü, “Saja aw, kani phäha na jah pawh pet vai kani ngjak hlü iyaw awmki,” ani ti. ");
INSERT INTO dao_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesuh naw jah kthäh lü, “Ini ka ning jah pawh pet vai na ni ngjak hlü?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Anini naw, “Na hlüngtainaka khawa, na bawingawhnak üng na ngawh law üng, mat na kpat da mat na k'eng da na jah ngawhsak vai kani ngjahlüki,” ani ti. ");
INSERT INTO dao_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesuh naw, “Nani kthäh am ksingei ve niki. Ka awk vaia khuikhanaka khawt nani aw khawh khai aw? Baptican ka khan vaia kba pi nani khan khawh khai aw?” ti se, ");
INSERT INTO dao_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","anini naw, “Kani khyaih khai ni” ani ti. Jesuh naw, “Ka awk vaia khawt nani aw thei kcang taw khai, Baptican ka khan vaia kba pi nani khan thei kcang taw khai; ");
INSERT INTO dao_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Cunsepi ka kpat lama ngaw khai ja ka k'eng lama ngaw khai cun keia xü vaia am kya naw. Acun cun ani naw a jah pyan peta khyang hea phäha acuna hmün he jah pe khai cun Mhnama kyaki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Akce xa he naw ngja law u lü Jakuk la Johana khana aktäa thüiki he. ");
INSERT INTO dao_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Acunakyase Jesuh naw a veia jah khü lü, “Khyangmjükce hea khana mkhawnga ami jah mcawn he cun ana atäa taki he ti nami ksingki. ");
INSERT INTO dao_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Cunsepi acunkba nangmi üng ä kya se. Nangmi üng a kyäp säih vai ngjahlüki cun nami m'ya a kya se. ");
INSERT INTO dao_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nangmi üng a ma säih vai ngjahlüki cun avana m'yaa kyase. ");
INSERT INTO dao_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Khyanga Capa cun khyanga khüih vaia am law lü; khyang jah khüih lü khawjah thawnnak vaia a xünnak pe khaia ni a law ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jerikho mlüha law u se, Jerikho üngka naw axüisaw he la khyang khawjah am ami ceh be üng, kthäheiki amikmü, Timea capa Batihme cun lam peia a na ngawki. ");
INSERT INTO dao_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazaret Jesuh ni ti a ngjak la, “Jesuh! Davita Capa! na m'yeneia,” ti lü ngpyangki. ");
INSERT INTO dao_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Khyang khawjah naw kse na u lü ä khihkheh khaia mtheh u se pi, “Davita Capa, na m'yeneia!” ti lü ngpyang law däm dämki. ");
INSERT INTO dao_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Acunüng Jesuh naw ngdüi lü, “Khü ua,” ti se, khyang he naw amikmü khü u lü, “ä cäi lü, ngdüi lawa, ning khü ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Acunja amikmü cun a jih ngvaih tawnin lü, ngtawp lü, Jesuha veia lawki. ");
INSERT INTO dao_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesuh naw, “Na phäha ini ka ning pawh pet vai na ngjak hlü?” ti se amikmü naw, “Saja aw, ka hmuh be vai ngaih veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Acunüng Jesuh naw, “Cita, na jumnak naw ning m’yai be ve,” ti se. Acunja angxita hmu law be lü lama Jesuha hnu läki. ");
INSERT INTO dao_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalem pha law hlü lü Betphake la Bethanih mlüh pei ami pha law üng Olip mcunga lawki he. Acunüng Jesuh naw axüisaw he üngka nghngih la na tüi lü, ");
INSERT INTO dao_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Nani maa ngnama va cit nia. Nani va pha la sanghngaksaü ngphungki, u naw pi am a ngcumnak ham nani hmu khai. Sut ni lü hia lawpüi nia. ");
INSERT INTO dao_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Khyangnaw, ‘Ivai acen nani pawhki ni?’ ami ti üng, ‘Bawi naw ngjahlü ve, asäng tha law be khai ni’ nani ti vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Acunüng cit ni lü sanghngaksaü cun lama pei mkawt üng ngphung se, hmu ni lü, ani suh. ");
INSERT INTO dao_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Acunüng ngdüikia khyang avang naw, “Ise, acena sanghngaksaü nani sutki ni?” ami ti u. ");
INSERT INTO dao_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesuh naw a jah mtheha kba jah mtheh ni se, acunüng ami jah cehsak. ");
INSERT INTO dao_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Acuna sanghngaksaü cun Jesuha veia lawpüi ni se, a khana ami suisak mtaih u lü Jesuh ngawki. ");
INSERT INTO dao_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Khyang he naw ami suisak he lama jah phah u se, avang naw thing hnah he jah ksawm u lü lama ami jah phah. ");
INSERT INTO dao_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A ma citki he la a hnua läkia khyang he naw, “Hosana! ‘Bawipa ngming üng lawki hin Pamhnam naw dawnak pe seh!’ ");
INSERT INTO dao_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pha law khaia khaw cun Davita uknaka kcün üngka kba josenaka am be se,” tia ngpyangki he. ");
INSERT INTO dao_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesuh Jerusalema lawki, temple k’uma lut lü avan jah tengki. Khaw mü law hlükia kyase axüsaw xaleinghngih he am Bethanih mlüha citki he. ");
INSERT INTO dao_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Angawi, Bethanih üngka naw ami law be üng Jesuh a ei ngaih lawki. ");
INSERT INTO dao_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Fik thing a hnah naw a bu athuknak üngka naw hmu lü akthei ve khai aw, ti lü teng khaia citki. Cunsepi a phung a pha üng a ngtheinaka kcüna am kyakia kyase a hnah däng a hmuh. ");
INSERT INTO dao_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesuh naw fik dung üng, “U naw pi na ktheih ä ei be ti se,” ti se, axüisaw he naw ami ngjak. ");
INSERT INTO dao_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem ami pha law üng Jesuh temple üng lut lü, ngui mthawngki hea ngawhnak he la müme jah jawituki hea ngawhnak he a jah hukin. ");
INSERT INTO dao_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesuh naw Temple jawihtuknaka kba ami summang vai am ti. ");
INSERT INTO dao_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Acunüng jah mthei lü, “Cangcim üng Pamhnam naw, ‘Ka im cun khyangmjü avana ktaiyünaka im ti khai he, tia ng’yuki,’ Cunsepi nangmi naw m'yukei hea umnaka pawh ve uki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Acun ktaiyü ktung he la thum jah mtheiki he naw ami ngjak üng Jesuh ami hnimnak vaia lam suiki he. Ani cun kyühki he isetiakhyaüng a ja mtheimthanga phäha khyang he ami cäileta phäh kyaki. ");
INSERT INTO dao_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Khaw mü law se Jesuh la axüisaw he cun Jerusalem üngka naw akcea citeiki he. ");
INSERT INTO dao_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Angawi ngawilam, ami ceh lama fik thing a pya cäpa ng’yawngei se ami hmuh. ");
INSERT INTO dao_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita naw süm law be lü, “Saja aw tenga, Fik thing na yünce cen ng’yawngei ve!” a ti. ");
INSERT INTO dao_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesuh naw jah msang lü, “Pamhnam jum ua. ");
INSERT INTO dao_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Akcanga ka ning jah mthehki, u naw pi a pyena kba kya khai tia jum lü hina khawmcung üng, ‘Ngnawn lü mliktui üng kyaa’ a ti üng, a tia kba kya khai. ");
INSERT INTO dao_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Acunakyase ka ning jah mthehki, ipi ktaiyünak am nami kthäh üng yah lü nami ka na khaia ksing ua, acunüng nami yah khai. ");
INSERT INTO dao_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nami ktaiyü üng ua khana pi mlung am jenak nami tak üng mhlät ua. Acunüng nami Pa, khankhawa ka naw nangmia katnak pi ning jah mhlät khai” a ti. ");
INSERT INTO dao_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalema law be tüki he. Jesuh temple k’uma a ceh üng, ktaiyü ktung he, thum jah mtheiki he la, axüngvai he a veia law u lü, ");
INSERT INTO dao_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Ia ana am hina ngkhaw he na jah pawhki ni? U naw hina ana a ning pet ni?” tia, ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesuh naw jah msang lü, “Kei pi mat ka ning jah kthäh khai, nami na msang üng kei naw pi ia ana am hina ngkhaw he ka jah pawh ning jah mtheh kawng. ");
INSERT INTO dao_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Johana Baptican petnak hawia ka naw lawki? Mhnam üngka naw lawki aw, khyang üngka naw lawki aw? Na mtheh ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Amimät he ngthäh u lü, “I mi ti khai? Mhnam üngka mi ti üng mä, acunüng ise Johan am nami jumki ni? ti khai. ");
INSERT INTO dao_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Khyang üngka mi ti üng mä, (Khyang avan naw Johan cun sahma mata ami ngaia kyase)” tia khyang he jah kyüh u lü, ");
INSERT INTO dao_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","“Am ksing ve ung,” ami ti. Jesuh naw jah msang lü, “Kei naw pi ia ana am hina ngkhaw he ka jah pawh am ning jah mtheh hlü veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Acunüng Jesuh naw msuimcäpnak am ami veia ngthu pyen lü, “Khyang mat naw capyit nglin lü, ngvawng lü, capyittui msawihnak vai khui co lü, ngängnak vaia im sa lü, lokbi he üng jah khah lü, a im ceh ta lü kdunglawngki. ");
INSERT INTO dao_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Capyit kbih kcün üng capyit ngvawng ngängki hea veia a m'ya mat capyitkthei a yah vai la khaia a tüih. ");
INSERT INTO dao_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Capyit ngängki he naw m'ya cun man u lü kpaiki he naw a jünga ami tüih be. ");
INSERT INTO dao_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Acunüng capyit ngvawng mah naw a m'ya akce ami veia a tüih be; acun pi a lu kpai u lü, am hmuhtheh phyakia pawh u lü, ami tüih be. ");
INSERT INTO dao_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Acunüng ngvawng mah naw akce ami veia tüih be tü se, ani cun hnim u lü, acunkba bäa akce he pi avang jah kpai u lü, avang ami jah hnim. ");
INSERT INTO dao_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","A tüih vai mat däng awmki cun amäta jawngnak leng lenga a capa mat dänga kyaki. Anghnua a capa cun ngvawng kngängea veia a tüih. ‘Hina ka capa ta leisawng khai hea ngsingki ni’ a ti. ");
INSERT INTO dao_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Cunsepi capyit ngvawng ngängki he naw, ‘Hin hin ngvawng maha capa va ni kbak. Law ua, mi hnim u lü, a khawh mi ka na vai’ tia pyen u lü, ");
INSERT INTO dao_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","acunkba manki he naw hnim u lü capyit ngvawng kpunga ami tawnin. ");
INSERT INTO dao_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Acunüng capyit ngvawng mah naw i ti law khai? Ngvawng mah law lü ngvawng ngängki he jah hnim lü capyit ngvawng cun akce he üng jah pe khai. ");
INSERT INTO dao_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","‘Sawngsaki he naw ami yawka lung cun , avana kthaka kyäp law be säihki ni. ");
INSERT INTO dao_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ahin cun Bawipa pawha kyaki; ihlawka mi ma kyühkse vaia kyaki ni’ ti hin cangcim üng am nami kheh khawiki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Acunüng Judah mkhawng he naw amimi a jah pyennaka msuimcäpnak ni ti ksing u lü man khai hea ami bü. Cunsepi khyang he jah kyüh u lü yawk u lü ami cehtak. ");
INSERT INTO dao_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pharise avang he la Heroda khyang üngka he ngthähnak am Jesuh man khai hea Jesuha veia ami jah tüih. ");
INSERT INTO dao_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A veia law u lü, “Saja aw, nang cun u pi am na cäinaki, khyang naw hawkba a ning ngaih pi am cäi na lü, khyanga hmai am teng lü, nghnicima phäha Pamhnama ngthungtak ngjak hlü na jah mtheiki ti kami ksingki. Romah Sangpuxang üng ngcawn pet vai hin mi thum üng nglawiki aw? Pet vai aw am pet vai aw?” jah mtheha ami ti. ");
INSERT INTO dao_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesuh naw ami hleihlaknak jah ksing lü, “Ivaia nami na mhnüteiki he ni? Denarih ngui na pe law ua, teng vang,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Denarih ngui mat a veia lawpüi u se Jesuh naw, “Hin hin ua müihmai la ua ngming ni?” ti se amimi naw, “Empero” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Acunüng Jesuh naw jah msang lü, “Emperoa ka Empero üng pe u lü, Mhnama ka Mhnam üng pe ua,” ti se, Ami van cäi lawki he. ");
INSERT INTO dao_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Acunüng Saduke he avang thihnak üngka naw thawhnak be am ve tikie Jesuha veia law u lü, ");
INSERT INTO dao_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Saja aw, Mosi naw mi phäha thum a yuknak üng, ‘Khyang naw am ca lü a khyu a thih tak üng a na naw a ktaia cangsawn am düt khaia, acuna hmeinu cun a khäm be vai a ti.’ ");
INSERT INTO dao_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bena khyüh awmki he; axüngvai he säih khyumahki am ca mah lü thiki. ");
INSERT INTO dao_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Acunüng anghngihnak naw nghnumi a khäm be ani pi am ca lü thiki. Akthumnak naw acunkba bäa khämki naw am ca lü a thihtak. ");
INSERT INTO dao_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Acukba ami van naw ami khäm be; ami khyüh am ca u lü thiki he. Anghnua nghnumi pi thiki. ");
INSERT INTO dao_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Thikie thawhnak bea mhmüp üng ami thawh law be üng nghnumi cun ua khyua kya khai ni, ami khyüh naw ami khyunaka kyaki,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesuh naw jah msang lü, “Ihlawka nami hmaki he! Ise am nami ksing ni tia kyaküng, Mhnama johit la cangcim am nami ksinga phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Akthi he ami thawh law be üng khankhawngsä hea kba law khai he, ngkhyunglanak am ve be ti khai. ");
INSERT INTO dao_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Thihnak üngka naw thawh bea mawnglam: Pamhnam naw Mosi üng, ‘Kei Abrahama Mhnam, Isaka Mhnam, Jakopa Mhnama ka kyaki’ tia a mtheh cen, Mosia cauk üng kpyap meiha a däinaka manwg ng’yuki am nami khe khawiki he aw? ");
INSERT INTO dao_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mhnam cun akthi hea Mhnama am kya, akxüng hea Mhnama kyaki. Aktäa am ngtäikia ngai kyu ve uki,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ami ngcuhnak ngjaki thum jah mtheiki mat awmki. Jesuh naw Saduke he akdawa jah msangki ti hmu lü ngthäh khaia a veia lawki naw, “Ia ngthupet ni aktung säih?” tia a kthäh law. ");
INSERT INTO dao_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesuh naw msang lü, “Ngthupet he üngka aktung säih cun, ‘Aw Isarel ngaia! Bawipa mi Pamhnam mat däng ni mi Bawipaakya ve. ");
INSERT INTO dao_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bawipa na Pamhnam cun na mlungmthin, na xünnak, na ksingnak la na kyannak avan am na jawngnak vai’ tia kyaki. ");
INSERT INTO dao_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Anghngihnak cun: ‘Na impeiloceng namät na jawngnaka kba na jawngnak vai’ tia kyaki. Ahina thea kyäp bawkia ngthupet akce i am ve ti,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Acunüng thum jah mtheiki naw, “Saja aw, pyen thei veki! na kcang pyen veki, Bawipa däng ni Mhnama akya ve, Ania thea Mhnam akce am ve. ");
INSERT INTO dao_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nghngicim naw a mlungmthin, a ksingnak la a kyannak avan am Mhnam a jawngnak vaia kyaki; acunüng a impeiloceng, amät a jawngnaka kba a jawngnak vai. Xüngkseie la akce he am Mhnama veia ngkengnak pawha kthaka a mtheh ngjak hin daw bawki ni,” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Thum jah mtheiki naw mcei ye lü msang beki ti Jesuh naw ksing lü, “Nang naw Pamhnama khaw am thuk na veki,” a ti. Acun käna u naw i pi am kthäh dat u. ");
INSERT INTO dao_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesuh naw temple k’uma a jah mthei k’um üng jah kthäh lü, “Mesijah cun Davita mjükphyüi ni tia thum jah mtheiki he naw ihawkba ami ti thei ni? ");
INSERT INTO dao_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngmüimkhya Ngcim naw pyensak se, Davit amät naw pi pyen lü: ‘Bawipa naw ka Bawipa veia: Na ye he na khawkunga ka jah tak law vei däa, ka kpat da ngawa’ a ti ni? ");
INSERT INTO dao_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davit amät ye naw, ‘Bawipa’; tia a khü hin ihawkba a mjükphyüia kya khai ni?” a ti. Acunüng khyang khawjah naw jekyai u lü ami ngaih. ");
INSERT INTO dao_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Acukba a jah mthei k’um üng Jesuh naw, “Thum jah mtheiki he jah cäiei na ua, suisak akkyu suisa u lü ami ngtaw hü vai jawngnaki he, jawituknaka khyang hea jah mhlünmtai vai ngaihki he. ");
INSERT INTO dao_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sinakoka ngawhnak akdaw säih ja buh pawhnaka hmün akdaw säih ngjahlüki he. ");
INSERT INTO dao_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hmeinu hea khawhthem ei aw u lü, khyang hleihlaknak vaia aksoa ktaiyüki he. Ahin he naw mkhuimkhanak khamei däm khai he,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesuh cun khawhthem ami petnaka peia ngaw lü, khyang he naw ihawkba khawhthem pung k’uma ami ktawk jah tengki. Aktäa bawimangki he naw ngui khawjah ktawki he. ");
INSERT INTO dao_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Acunüng hmeinu m'yenkse mat naw law lü, tangka ajawca nghngih a ktawk law. ");
INSERT INTO dao_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Acunüng Jesuh naw axüisaw he atänga jah khü lü, “Akcanga ka ning jah mthehki, hina hmeinu m'yenkse naw pung üng akdäm bawk pe ve. ");
INSERT INTO dao_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Peki he ami van naw ami taka ngui kpawih üngka va peki he; Cunsepi hina hmeinu naw a m'yenksenak üngka a xünnak vaia a takca avan pe ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Acunüng temple üngka naw a ceh be üng axüisaw he üngka mat naw, “Saja aw, tenga, lunge la ime cun pi khyäp ve u bä!” ti se, ");
INSERT INTO dao_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesuh naw msang lü, “Hina im he na jah hmuki aw? Lung matca pi ahin üng am ve tikia ami van pyeh bäih khai he,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesuh Olip mcunga ngaw lü temple da mang se Pita, Jakuk, Johan la Andru a veia law u lü, ");
INSERT INTO dao_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Itia acukba kya law khai? Acuna ngkhaw hea pha law vai ia msingnak he ngdang law khai?” jah mtheha ti u lü ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesuh naw, “U naw ä a ning jah mhleimhlak vaia mceiei ua. ");
INSERT INTO dao_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Khyang khawjah ka phäha ngthu pyenki hea ngsaih u lü, ‘Kei ania ka kyaki ni! ti u lü khyang khawjah jah mhleimhlak law khai he. ");
INSERT INTO dao_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Acunüng ngtuknak la ngtuknak vaia mawng ng’et lawki la so hünki tia ngthu nami ngjak üng ä nami kyüh vai; acun he cun ve law kung khai, cunsepi adütnak pha law pängki tinaka am kya. ");
INSERT INTO dao_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pung la pung ngtu law khai he; khaw kce la khaw kce ngtu law khai he. Hmün naküta ngkhyü ngsün law lü, khawkjaw law lü, khuikhanak he awm law khai he. Acun he cun na hmi hlüki a huiei law kcüka mäiha khuikhanak hea tüneinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Acunüngpi ana cäiei na u; ning jah kpang u lü ngthu mkhyahnaka junga ning jah cehpüi khai he. Sinakok hea k’uma ning jah kpai khai he. Thangkdaw nami jah mtheh khaia, ngvai he la sangpuxang hea ma keia phäha nami ngdüi law khai. ");
INSERT INTO dao_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Cunsepi adütnak am pha law ham se, thangkdaw khyang avana veia sanga kya khai. ");
INSERT INTO dao_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Acunüng ning jah kpang u lü ngthu mkhyanak junga ami ning jah cehpüi üng, i nami pyen vai ä cäi na ua; Akcün a pha law üng ipi a ning jah pet nami pyen vai. Nami pyen vai cun nami mäta ngthua am kya lü Ngmüimkhya Ngcim üngka naw law khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Khyang he naw ami bena he thi khaia jah ap law khai he, ami pa naw pi acunkba bäa ami ca he thi khaia jah ap law khai he. Ami ca he naw ami nupa he jah hneng law u lü thi khaia jah ap law khai he. ");
INSERT INTO dao_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Keia phäha khyang he naw ning jah hneng law khai he. Acunsepi adütnak cäpa ling lü sitihki cun küikyana kya khai. ");
INSERT INTO dao_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Acunakyase, ‘pyükpyeh thei lü, mtüihkhehki’ am a ngdüihnak vai üng ngdüi se, nami hmu üng, (khehki avan naw asuilam ksing kawm) Judah khawa awmki he mcunga dawng u se; ");
INSERT INTO dao_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","mkyum khana awmki im k’uma iyaw lo khaia ä kyum law be se, akcün bäih khai ni. ");
INSERT INTO dao_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Loa awmki naw a jih loei khaia ima ä nghlat be se. ");
INSERT INTO dao_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Acuna mhmüp cun pawieiki he la cihtui awkia hnasen kpawmeikia nu hea phäha aktäa khuikhanaka kya khai. ");
INSERT INTO dao_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nami dawngnak khawksik khyaa ä akyanak vaia Mhnama veia ktaiyü ua. ");
INSERT INTO dao_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Acuna mhmüp cun mkhuimkhanaka mhmüpa kya khai, acuna kba khuikhanak cun Pamhnama pyang khawmdeka ngtüi üng tün lü, atuh cäpa am ve khawi, i tia pi am ve be ti. ");
INSERT INTO dao_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bawipa naw acuna mhmüp he am a tawisak vai sü üng ua ca pi am xüng khai sü, cunsepi a jah xü hea phäha acuna mhmüp he cun a jah tawisaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Acunüng khyang naw, “Tenga, hia Mesijah ve ve, ‘Tenga caia ve ve’ ami ti üng, acun ä nami kcangnak vai. ");
INSERT INTO dao_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Isetiakyaüng, Mesijah kcang he am niki he la sahma kcanga am niki he awm law khai he. Akya thei vai süta Pamhnama xü he pi ami jah mhleihlaknak vaia müncankse he la cäicatnak he jah pawh law khai he. ");
INSERT INTO dao_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cunsepi cäiei na u, akcün am a pha law ham üng avan ka ning jah na mthehki ni. ");
INSERT INTO dao_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Acuna khuikhanaka mhmüp he käna, khawnghngi nghmüp law lü, khya pi am vai law ti. ");
INSERT INTO dao_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Khankhaw üngka naw aisi he kya law khai he, khana johite ngsün law khai he. ");
INSERT INTO dao_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Acunüng Khyanga Capa hlüngtainak la johit am khawngmei üng law lü ngdang law khai. ");
INSERT INTO dao_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A khankhawngsä he jah tüi lü, khawmdeka cum, sip, nghngilaw, khawkyak avan üng Pamhnama xü he atänga jah mkhäm law khai. ");
INSERT INTO dao_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Fik thing üng ngtheingthang ua. A ngban he mkim law u lü a hlip law üng, khaw khye law hlüki ti nami ksingki. ");
INSERT INTO dao_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Acuna kba ahin hea kya law u se, akcün ng’et law lü tün law hlükiti nami ksing khai he. ");
INSERT INTO dao_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Atuha khyang he am thi ham u se, ahin he thawn law khai he ti süm ua. ");
INSERT INTO dao_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Khawmdek la khankhaw khyük ni se pi ka ngthu itia pi am khyük. ");
INSERT INTO dao_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Acuna khawmhmüp la akcün cun Pa dänga thea, u naw am ksing; khana khankhawngsä he la a Capa naw pi am ksing u. ");
INSERT INTO dao_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Akcüna pha law vai am nami ksingkia kyase, ana mceiei ua. ");
INSERT INTO dao_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hin cun khyang mat athuknak punga citki, a im yawk hüt lü a m'ya he üng ami ham phäh phäh khüih vai jah pe hütki naw mkawt ngängki üng a teng vaia a mtheh hüta kba kyaki. ");
INSERT INTO dao_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Imah a lawnak be vai cun mü lam aw? Mthan nglunga aw? Khawthaih hlan aw? Nghngi luh law aw? ti am nami ksingkia kyase angläta ana ngängei ua. ");
INSERT INTO dao_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Am nami äpa kcün üng a law be üng nami ih ä ning jah hmu se. ");
INSERT INTO dao_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nangmi üng ka ning jah mtheh cun khyang avan üng pi ka mtheh ni. Ana ngcüngcei ua!” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Atuh hin lätnak pawi la nghngen am bawikia buhpawhnak pawi a pha vai amhmüp nghngihnak ni. Ktaiyü ktung he la thum jah mtheiki he naw, Jesuh man u lü ampyua ami mkhyühnak vaia lam suiki he. ");
INSERT INTO dao_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Cunsepi, “Pawi k’um üng ta am kya kawm, khyang he suksak khai he ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesuh Bethanih ngnam mnehkse mnehki Sihmona ima awmki. Buh a ei k’um üng nghuminu mat naw aphu küi alabasta sing’ui cun aphu küikia um üng abea lawpüi lü, um seih ak lü Jesuha lu khana a buih law. ");
INSERT INTO dao_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Acunüng awmki he avang naw am kyäpsak u lü, “Ivai hina sing’ui päihcaihsaki ni? ");
INSERT INTO dao_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ahin hin ngui phya kthuma (kum mat hlawheia däm bawki phu naki) jawi lü m'yenkse he üng jah pet vai sü,” tia nghnumi ami pyenei. ");
INSERT INTO dao_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Cunsepi Jesuh naw, “Amäta ngaiha ti se. I vaia am nami pyenksaeiki ni? Hin naw ka phäha akdaw pawh ye se. ");
INSERT INTO dao_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","M'yenkseki he cun anglät se nami hlawnga ve hlü ye u se, anglätse nami ngaiha kcün üng nami jah kpüi theiki. Cunsepi kei cun anglätse nami hlawnga am ve hlü nawng. ");
INSERT INTO dao_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hina nghnumi naw a khyaihca pawh ve; ka pumsa k’ut vaia kcün am a pha ham üng, ka ng’utnak vai pyang ve. ");
INSERT INTO dao_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Akcanga ka ning jah mthehki, khawmdek khan naküta thangkdaw sang hünak naküt üng hina nghnumia a bilawh pi ani sümnak vaia pyen sih khai he ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Acunüng Judah Iskarot, xaleinghngih he üngka mat cun Jesuh ceng khaia ktaiyü ktung hea veia citki. ");
INSERT INTO dao_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","A pyen ami ngjak üng aktäa je na u lü, ngui ami pet vaia ami khyütamnak. Acunüng, Judah naw a jah kpanaksak vaia kcün suiki. ");
INSERT INTO dao_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nghngen am bawikia buhpawhnaka mhmüp kcük, lätnak toca he ami jah hnimnak khawia mhmüp üng, axüisaw he naw, “Lätnak pawi buh na einak vaia hawia ni kami va pyan vai na hlüei?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Acunüng Jesuh naw axüisaw xawi nghngih jah tüi lü, “Mlüh k’uma va cit ni lü kpami mat k’am üng tui kawtki naw ning jah na khyum khai. Acun nani läk vai. ");
INSERT INTO dao_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","A luhnaka im üng lut ni lü, ‘Saja naw, ka xüisaw he am lätnak pawi buh kami einak hmaih vai im hawia ni?’ ti ve nani ti vai. ");
INSERT INTO dao_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Acunüng ani naw im khan angsawngnu, mi phäha avan küm khaia ami pyan päng ning jah mhmuh khai, acuia ei vai nami pyang vai” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Axüisaw xawi cit ni lü mlüh k’uma cit ni se, a jah mtheha kba va hmu ni lü, lätnak pawi buh ani va pyang. ");
INSERT INTO dao_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Khaw a mü law üng Jesuh axüisaw he xaleinghngih am lawki he. ");
INSERT INTO dao_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ngaw u lü ami ei k’um üng Jesuh naw, “Akcanga ka ning jah mthehki, nangmi üngka mat, kani ei hmaihki naw na ceng khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Axüisaw he thüisei law u lü, “Acun mä kei na na pyenak aw, am ni aw? tia kthäh law tüi tüiki he. ");
INSERT INTO dao_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesuh naw jah msang lü, “Xaleinghngih üngka mat, kbe üng na kpuiheipüi hmaihkia kyaki ni. ");
INSERT INTO dao_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Khyanga Capa cun amawng cangcim üng ana ng’yuka kba thih khai; cunsepi Khyanga Capa cengki hin a jo se ve! Acuna khyang hin am a hmi law a phäha daw bawk khai sü,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ami ei k’um üng Jesuh naw muk lo lü, jekyainaka ngthu am ktaiyü lü, boki naw jah pe lü, “Ei ua, hin cun ka pumsa ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Acunüng capyittui khawt lo lü, jekyainak Mhnam üng mtheh lü, jah pe se; ami van naw awki he. ");
INSERT INTO dao_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesuh naw, “Hin hin ka thisen khyang khawjaha phäha ngsawiki, Pamhnama ngthumkhänmsingnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Akcanga ka ning jah mthehki, Pamhnama khawa capyittui akthai ka awknaka mhmüp am a pha law hama küt üng, hina capyittui am ka aw be ti khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Acunüng ng’äi mcuk u lü, Olip mcung da citki he. ");
INSERT INTO dao_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesuh naw jah mtheh lü, ‘Pamhnam naw toksäm hnim se, to he ngpyeng hü khai he’ tia cangcim üng a awma kba, “Na yawk u lü nami van naw nami na cen ta khai. ");
INSERT INTO dao_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cunsepi ka thawh be käna Kalile khawa nami ma ka na cit khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita naw msang lü, “Ami van naw ning dawng ta u se pi, kei naw ta am ka ning dawng ta süm süm khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesuh naw, “Akcanga ka ning mthehki, tuhmü mthan, ai nghngih vei am khawng ham se kthum vei na ngcim khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita naw, “Na hlawnga ka thih hnga vai üng pi, am ka ngcim khai,” a ti. Acukba ami van naw ami ti hnga. ");
INSERT INTO dao_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ketaseman ami tia hmüna lawki he Jesuh naw, “Hin üng a na ngaw u, va ktaiyü vang,” ti lü axüisaw he a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Acunüng Pita, Jakuk la Johan jah ngkhahpüi lü, aktäa a mlung na se khüikhaki. ");
INSERT INTO dao_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Acunüng Jesuh naw, “Ka mlungmthina khuikhanak cun aktä leng lenga na lü na mthih khaia kya ve. Hin üng awm u lü ana mdei ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ajawha va cit lü, mdeka ngbawk lü, akya thei vai sü ta acuna khuikhanak am a khamei vaia ktaiyü lü, ");
INSERT INTO dao_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Ka Pa aw, ka pa aw! Nang üng avan kya theiki ni. Hina khuikhanaka khawt hin ka khan üngka naw loa. Cunsepi keia ngjakhlüa am ni na ngjakhlüa kyase,” ti lü ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Acunüng a nghlat law be üng axüisaw he kthum ip u se jah hmu lü Pita üng, “Sihmon, na ipeiki aw? Naji matca pi am na mdei theiki aw? ");
INSERT INTO dao_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hlawhlepnak üng am nami kyukngtängnak vaia, ngäng u lü ktaiyü ua. Ngmüimkhya ta yäng teki pumsa naw am läih ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesuh va cit be lü, a pyena kba pyen lü va ktaiyü beki. ");
INSERT INTO dao_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Acunüng axüisaw hea veia a law be üng ami ihmik am caikia kpi ana ipei be u lü, ihawkba ami msang vaia pi am ksing u lü awmki he. ");
INSERT INTO dao_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Akthumnaka a law be üng, “Atuh vei cäpa ip u lü nami xüieiki aw? Khäk ve! akcün pi pha law päng ve! teng u, Khyanga Capa cun khyangka hea kut üng mansak vaia kya ve. ");
INSERT INTO dao_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tho law ua mi cit vai. Teng u, na cengki pha law päng ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Acukba ana ngthuhei k’um üng xaleinghngih üngka mat Judah pha lawki. Ani mah maha likcim la kpaihmäng kpawmkia khyang khawjah; ktaiyü ktung he, thum jah mtheiki he la axüngvai hea ami jah tüi law pha lawki he. ");
INSERT INTO dao_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesuh cengki naw khyang he üng msingnak a jah pet: “Ka mhnama khyang cun nami ngaiha khyanga kyaki. Acun kpang u lü, mcei u lü nami cehpüi vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judah naw a pha law ja Jesuha veia cit lü, “Saja aw!” ti lü a mhnam. ");
INSERT INTO dao_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Acunüng Jesuh akceta ami kpan. ");
INSERT INTO dao_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Acunüng ngdüiki üngka mat naw a kcim kphawngei lü ktaiyü ktunga m'yaa nghngakawi a ksawmpat. ");
INSERT INTO dao_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Acunüng Jesuh naw jah msang lü, “Khyang kse man khai hea kba likcim he la kpaihmänge jah kpawmei u lü nami lawki he aw? ");
INSERT INTO dao_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Amhmüp tä temple k’um üng ning jah mthei lü nami veia ve ni se, am nami na manki. Cunsepi cangcima kümkawinak vaia kya ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Acunüng axüisaw he ami van naw yawk u lü ami dawngtak. ");
INSERT INTO dao_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Cawngpyang mat jihca däng sui lü Jesuh ana läk hü hngaki man hlü u se, ");
INSERT INTO dao_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a jihca pi yawk hüt lü akawnga dawngki. ");
INSERT INTO dao_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Acunüng Jesuh ktaiyü ngvai säiha ima ami cehpüi. Acuia ktaiyü ktung he, axüngvai he la thum jah mtheiki he ami van ngcunki he. ");
INSERT INTO dao_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita athuknakca üngka naw ktaiyü ngvai säiha im ngvawng mkawt cäpa Jesuh läk hngaki. Acuia xungki hea hlawnga ngaw lü mei awmei hngaki. ");
INSERT INTO dao_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ktaiyü ktung he la kawngci he naw Jesuh ami mkhyühnak vaia ami kpuknak vai suiki he, cunsepi i pi am hmu u. ");
INSERT INTO dao_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Khyang khawjah naw hleihlaknak am ami kpuk law, cunsepi ami pyenksak he naw am jah cangsak. ");
INSERT INTO dao_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Acunüng avang he ngdüi law u lü ami hleihlaknak am, ");
INSERT INTO dao_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hin naw, ‘khyanga saka temple kpyeh lü, amhmüp kthum üng khyanga am saka temple ka sa be khai,’ ti se kami ngjaki ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ami hleihlak ami pyen naw pi amimät am jah kcang na. ");
INSERT INTO dao_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ktaiyü ktung säih cun ami maa ngdüi law lü Jesuh üng, “Na katnak ami ning kpuknak he hin i am pi am na jah msangki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Cunsepi Jesuh am khihkheh lü i pi am pyen. Acunüng ktaiyü ktung säih naw, “Nang Mesijah, Mhnama Capaa na kyaki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesuh naw, “Ä, khyanga Capa hlüngtaiki Mhnama kpat da ngaw lü, khankhawa khawngmei üng law se nami van naw nami hmu law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ktaiyü ktung säih naw a suisak he jah ktek lü, “Ia saksi am hlü be ve! ");
INSERT INTO dao_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pamhnam a pyenksenak nami ngjak, ihawkba ni nami ngaih?” ti se. Ami van naw thi khaia ngkawih ve ami ti. ");
INSERT INTO dao_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Avang naw ami mci am msawh u lü, avang naw a mik hlawp u lü pung u lü, “U naw ning pungki ni?” ami ti. Ngängki he naw ami kut am ami kbeih. ");
INSERT INTO dao_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita cun ktaiyü ngvai säiha m'ya, nghnumica mata peia a law üng, im ngvawnga k’keh lama ana awm hünki. ");
INSERT INTO dao_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita mei ana awmei se hmu üng tengki naw, “Nang pi Nazaret Jesuh am nani awm hü hmaih khawiki va ni mäih ja,” ti se, ");
INSERT INTO dao_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pita naw, “Am ksing nawng, na pyena mawng am ksing thei veng,” tia ngcim lü kawma lama va cit se ai khawngki. ");
INSERT INTO dao_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Acuia nghnumica naw hmu be tü lü, acunüng ngdüiki hea veia, “Hin hin acun he üngka mat ni,” ti se, ");
INSERT INTO dao_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita ngcim be tüki. Acun käna pi acunüng ngdüiki he naw, “Acun he üngka na kya am ngcim theiki. Isetiakyaküng nang pi Kalile khyang ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Acunüng Pita naw, “Akcang ka pyenki ni! Akcang am ka pyen üng ta Mhnam naw na ju khmu law kawm tia ng'yün veng! Nami pyena khyang kei am ksing veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Acun la anghngihnaka ai khawngki. Acunüng Pitaa veia Jesuh naw, “Ai nghngih vei am a khawng ham üng nang naw am ksing nawng ti lü kthum vei na ngcim khai,” a ti cun süm law be lü aktäa kyapki. ");
INSERT INTO dao_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Khaw a thaih law la ktaiyü ktung he naw axüngvai he, thum jah mtheiki he la kawngci bawi he jah nghmuhpüi u lü, Jesuh cun khitkie naw cehpüi u lü, Pilat üng ami msum. ");
INSERT INTO dao_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat naw, “Nang Judah hea Sangpuxanga na kyaki aw?” ti lü kthäh se, Jesuh naw msang lü, “Na pyena kba kya ve” a ti. ");
INSERT INTO dao_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ktaiyü ktung he naw aktäa mkatei law u se, ");
INSERT INTO dao_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilat naw kthäh be lü, “Am na jah msang hlü beki aw? Ami ning mkatnak he jah ngaia,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Acunüng pi Jesuh naw am msang be tü se Pilat cäi lawki. ");
INSERT INTO dao_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lätnak pawi buh pawh mhmüp üng Pilat naw thawngim üngka khyang mat mat, u pi khyang hea kthäh a mhlät khawia thum awmki. ");
INSERT INTO dao_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Acuna mhmüp üng khyang khnim mat Barabah ami tia la Romah he a uknak kpetmjaki he am atänga jah man hmaih u lü thawngim üng ami khyum awmki. ");
INSERT INTO dao_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Khyang he naw ngcun law u lü a jah pawh pet khawia kba dawnak a jah pawh pet vaia ami mso law. ");
INSERT INTO dao_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Acunüng Pilat naw jah kthäh lü, “Hina Judah hea Sangpuxang ka ning jah mhlät pet vai nami ngaihki he aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ktaiyü ktung he naw Jesuh ami k’eia phäh ni a veia ami lawpüi ti Pilat naw ksing lü acunkba a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Cunsepi ktaiyü ktung he naw Jesuha kdama ta Barabah a mhlät vaia mso khai hea khyang he ami jah ksük. ");
INSERT INTO dao_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat naw jah msang be lü, “Acunüng Judah Sangpuxang nami ti hin ihawkba ka pawh vai ni?” ti se, ");
INSERT INTO dao_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngpyang u lü, “Kutlamktung üng taiha!” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Acunüng Pilat naw, “Ia katnak pawhki ni?” ti lü jah kthäh se. Ami van naw ngpyang law däm däm u lü, “Kutlamktung üng taiha!” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat naw khyang hea mlung a je vai ngaih lü Barabah a mhlät. Acun käna Jesuh kpai lü kutlamktung üng taih vaia a jah ap. ");
INSERT INTO dao_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yekap he naw Jesuh cun bawia mkhyumima luhpüi u lü, yekap akce he pi ami jah cehpüi. ");
INSERT INTO dao_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bawi jihnu suisak u lü, nghling am pyanga bawilukhum a lu üng ami ngbüngsak. ");
INSERT INTO dao_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Acunüng, “Judah hea Sangpuxang, na xünnak saü se,” ti u lü ngpyangki he. ");
INSERT INTO dao_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Cung am a lu üng kpai u lü ami msawh, ami mkhuk am ngdäng u lü sawkhahkia ngsaihkie. ");
INSERT INTO dao_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Acukbaa ami yaihei law päng üng Bawi jihnu lo be u lü amäta suisak kphyüm msuimsak beki he naw kutlamktung üng ami taih vaia ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kpami mat Sihmon ngming naki, pung kce üngka naw mlüha lawki yekap he naw hmu u lü Jesuha kutlamktung amthuia ami kawhsak. (Sihmon cun Kurenih khyang, Aleksanda la Rufuha paa kyaki.) ");
INSERT INTO dao_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kolkotha tia hmüna ami cehpüi, acun cun “Lukawi hmün,” tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Acuia mura ami tia seitui am ami kcawa capyittui a awk vaia pe u se, Jesuh naw maki. ");
INSERT INTO dao_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Acunüng kutlamktung üng taihkie naw, u naw hawn bi khai tia mtainak vaia cung kphawng u lü a suisak ng’yeteiki he. ");
INSERT INTO dao_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesuh kutlamktung üng ami taihnak cun ngawi lam naji kawa kyaki. ");
INSERT INTO dao_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ami ksekhanaka kca: “JUDAHEA SANGPUXANG” tia a lu khana ami taih. ");
INSERT INTO dao_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesuh am atänga m'yukei xawi nghngih pi mat a kpat lam, mat a k'eng lama ami jah taih hnga. ");
INSERT INTO dao_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Acukba, “Ani cun khyangka he am ami jah taih hmaih,” tia cangcim kümkawi lawki. ");
INSERT INTO dao_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Acunüng cit hükia khyang he naw ami lu kting u lü, “Ajä! Nang Pamhnama temple kpyeh lü mhmüp kthum üng na sa hlü beki, ");
INSERT INTO dao_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Atuh namät naw namät küikyanei lü kutlamktung üngka naw kyum lawa,” tia ami ksekhanak. ");
INSERT INTO dao_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Acukba bäa ktaiyü ktung he la thum jah mtheiki he naw pi yaihei u lü, “Khyang he ta jah küikyan khawhki, amät am ngküikyanei thei ve! ");
INSERT INTO dao_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mesijah, Isarel hea Sangpuxanga a kyak üng ta, kutlamktung üngka naw atuh kyum law se; mi hmu u lü mi jum kawm,” ami ti. Jesuh am ami jah taih hmaih xawi naw pi ani ksenak hnga. ");
INSERT INTO dao_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mhmüp ngsung üngka naw tün lü, naji kthum bang so khaia khaw avan üng nghmüp lawki. ");
INSERT INTO dao_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Naji kthum üng Jesuh naw, “Eloi, Eloi, lema Sabathani?” ti lü angsanga ngpyangki. Acun cun, “Ka Pamhnam, ka Pamhnam, ise na na yawki ni?” tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Acunüng ngdüikia khyang avang naw ngja u lü, “Ngai ua, hin naw Elijah khü ve!” ami ti. ");
INSERT INTO dao_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Acunüng khyang mat naw dawng lü kpyawn lo lü, capyit kthui üng mcawiki naw, cungmdawng üng a tak. Acunüng Jesuha m'yawng üng a awk vaia han säng lü, “Asäng ve se! Yung khaia Elijah a law la am a law mi na teng vai u,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Acunüng Jesuh angsanga ngpyang lü thiki. ");
INSERT INTO dao_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Temple k’uma ngbangkia jihnu cun khan üngka naw aphung düta nghngiha tek lawki. ");
INSERT INTO dao_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yekap bawi kutlamktunga maa ngdüiki naw Jesuh a thih hmu lü, “Hina khyang hin Mhnama Capa kcanga kya ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nghnumi avang Marih Makdalin, Jakuk la Josepa nu Marih la Salome naw pi athuknak üngka naw tengki he. ");
INSERT INTO dao_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Acun he cun Jesuh Kalile khawa a ve üng läk law u lü khüihki hea kyaki he. Nghnumi kce he khawjah Jerusalema amät maha law hngaki he pi awmki he. ");
INSERT INTO dao_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Josep Arimahte cun khawmü lama pha lawki. Ani cun Pamhnama Khaw a pha law vai a na ngängki, aktäa ami leisawng kawngci ngvaia kyaki. Acuna ngcüngceinaka mhmüp (Sabbath a phanak vai mhmüp mat) üng Pilata veia cit lü Jesuha yawk a kthäh. ");
INSERT INTO dao_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat naw Jesuh thi pängki ti ngja lü cäiki. Yekap bawi khüki naw, “A thihnak so pängki aw?” ti lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yekap bawia pyen a ngjak käna Pilat naw Josep üng Jesuha yawk a lak vaia a mtheh. ");
INSERT INTO dao_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Acunüng Josep naw jih kthai khyei lü, Jesuha yawk cun la lü, jih am hlawp lü, lung ami cawh ng’utnaka ng’uhnüna k’uma ta lü, lungnu am mkawt a khaih hüt. ");
INSERT INTO dao_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Marih Makdalin la Josepa nu Marih naw ami k’utnak cun tengki xawi naw Jesuha yawk cun ani hmuh. ");
INSERT INTO dao_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabbath a bäih üng, Marih Makdalin, Jakuka nu Marih la Salome naw Jesuh ami hluknak vaia ngsi’ui khyei u lü, ");
INSERT INTO dao_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ngpum mhmüp ngawi, khawnghngia luh law üng ng’uhnüna citki he. ");
INSERT INTO dao_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ami ceh k’um üng amimät he, “U naw ng’uhnün mkawt üngka lungnu a jah ktän pet vai aw?” tia ngthähki he. (Acuna lungnu cun aktäa ngbaüki.) ");
INSERT INTO dao_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Acunüng ami jeng mang üng acuna lungnu cun a na ngtängin päng se ami hmuh. ");
INSERT INTO dao_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ng’uhnün ami va luh üng suisak abawk suisakia cawngpyang mat kpat lam da ngaw se ami hmuh üng cäiki he. ");
INSERT INTO dao_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Acunüng ani naw, “Ä cäi ua, kutlamktung üng ami taiha Nazaret Jesuh nami sui hüki ti ka ksingki, ani cun tho be pängki ni, hia am ve, ami msännak pi teng ua. ");
INSERT INTO dao_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Atuh cit u lü axüisaw he la Pita üng, ‘nami maa Kalile khawa ana cit hlü ve,’ tia jah va mtheh ua, amäta pyena kba acuia nami hmu khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Acunüng aktäa kyüh u lü ng’uhnün üngka naw dawngkie. Kyüh ngen u lü u üng ipi am mtheh u.  ");
INSERT INTO dao_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ngpum mhmüp ngawi lam üng Jesuh tho law be lü, akcüka khawyai khyüh a puk k’um üngka a ksät peta Marih Makdalina veia ngdangki. ");
INSERT INTO dao_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ani naw cit lü Jesuha awmpüi khawie üng a jah va mtheh. A na mbawikyapki he, ");
INSERT INTO dao_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ani naw Jesuh xüngki a hmuh pyen se ami ngjak üng, am kcang na u. ");
INSERT INTO dao_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Acun käna nghngih xawi mlüha ani ceh k’um üng, Jesuh ani veia khyang kcea kba va ngdangki. ");
INSERT INTO dao_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Acun xawi naw law be ni lü akce he üng jah mtheh law ni se, acun he naw pi am jah kcang na u. ");
INSERT INTO dao_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Anghnua Jesuh axüisaw xaleiat he ami ei ana ei k’um u se ami veia ngdangki. Jesuh a thawh be käna hmukia khyang he am ami jah kcangnak la ami mlunga nghlanga phäha a jah ksenak. ");
INSERT INTO dao_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesuh naw, “Khawmdek avan üng cit u lü thangkdaw khyang avana veia sang hü ua. ");
INSERT INTO dao_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Upi jum lü baptican khanki cun küikyana kya khai; upi am jumki avan cun mkatnak yah khai. ");
INSERT INTO dao_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jumeiki he üng müncankse he ami pawhnak thei vaia johit jah peta kya khai. Ka ngming am khawyai he jah ksät khai he; ngthu kthai he am ngthuhei law khai he; ");
INSERT INTO dao_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kphyu ami kut am kpang u lü thihnak vaia tui ami awk üng pi ia am kya u; am phetki hea khana ami kut mtaih u se yai be khai he,” a ti. ");
INSERT INTO dao_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bawipa Jesuh ami veia ngthuhei päng lü khankhawa kai be lü Pamhnama kpat lama ngawki. ");
INSERT INTO dao_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Axüisaw he pung naküt üng cit hü u lü ngthu sang hüki he. Bawipa naw jah khüipüi lü, ami ngthu sang hü cun cangki tia müncankse he jah pawhnak am ngdangsaki. {9} Nghnumi he naw Pita la a püi hea veia cit u lü ami ngjak avan aktawia ami jah va mtheh. {10} Acun käna Jesuh amät naw axüisaw he am nghngilaw lam üngka naw khawkyak lam düta ngcimcaihki la, anglät küikyanaka kyakia, anglät xünnaka ngthu cun a jah sang hüsak.");
INSERT INTO dao_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ka püi Theophiluh aw; ajana thawn khawikia mawng cun, khyang khawjah naw mi ksunga pyena ngthu yu khai hea ana ktha na khawiki he. ");
INSERT INTO dao_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Akcüka ana hmu u lü ngthu ana sang khawiki he naw mi veia ami pyen ana yuki he. ");
INSERT INTO dao_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Acunakyase nang angvai aw, angsinga ka ngaihkyu käna, acuna mawng cun, angsinga na hama yuk üng daw khaia ngaikyu veng. ");
INSERT INTO dao_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ajana ngthu ami ning mthei he cen ngthungtak ni ti na ksingnak vaia ka yuka kyaki ni. ");
INSERT INTO dao_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judah khawa sangpuxang Herod a bawi kcün üng, ktaiyü Abijaha khuikyawng üngka ktaiyü mat Zakharih ngming naki awmki; acun naw ktaiyüa khuikyawng üngka a khyunak, a ngming cun Elizabeta kyaki. ");
INSERT INTO dao_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ani nghngih Pamhnama mik hmuha akdawa xüngseiki xawi, pyen vai am hlü khaia Bawipa ngthupet la, ngthummkhän avan läki xawi. ");
INSERT INTO dao_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elizabet cingkia kyase am ca ni lü, aktäa xüki xawi. ");
INSERT INTO dao_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mhmüp mat üng Zakharih cun ktaiyüa khüih khawia kba Pamhnama Temple k'uma a khüih k'um üng, ");
INSERT INTO dao_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ktaiyüa thuma Bawipa Temple k'uma lut lü, ng'uinghnam mkhih khaia xüa kyaki. ");
INSERT INTO dao_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Acunüng, ng'uinghnam a mkhih k'um üng khyang he ami van kpunga ktaiyüki he. ");
INSERT INTO dao_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Acunüng, Bawipa khankhawngsä mat Zakhariha veia ngdang law lü, ng'uinghnam mkhihnaka kpat lama ngdüi lawki. ");
INSERT INTO dao_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakharih naw khankhawngsä a hmuh üng kyüh lü ngxetki. ");
INSERT INTO dao_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Acunüng, khankhawngsä naw, “Zakharih, ä kyüa, na ktaiyünak ngjak pänga kya ve, acunakyase na khyu Elizabet naw cangpyang mat ca na se, Johana na sui khai. ");
INSERT INTO dao_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nang jekyai lü na hlim khai, khyang khawjah ania hmi lawa phäha jekyai khai he. ");
INSERT INTO dao_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ani cun Bawipa ngaiha kyäp khai, ju naki i am ei aw khai. A nua puk k'um üng tün lü ngcimcaihkia ngmüimkhya am be khai. ");
INSERT INTO dao_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Acunüng ani naw Isarela ca he khawjah, ami Bawipa Pamhnama veia jah nghlat sak be khai. ");
INSERT INTO dao_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ani naw pa he la ca he alanga jah lawpüi be lü, am cingcaihki he ngsungpyunak ksingnaka lam üng jah nghlat sak be lü, khyang he Pamhnama phäha jah ngtünngceisak khai, Elijaha ngmüimkhya la khyaihbahnak am Pamhnama maa cit khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Acunüng Zakharih naw khankhawngsä üng, “Ikba acun ka ksing vai aw? Kei pakse ni, ka xü pängki, ka khyu pi nukpüi lü, a khawkum xü pängki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Khankhawngsä naw, “Kei Kabriel, Pamhnama ma ngdüikia ka kyaki, nanga veia hina jekyainaka ngthu lawpüi khaia tüih lawa ka kyaki. ");
INSERT INTO dao_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cunsepi Ngaia, ka ngthu akcün üng kümkawi law khai am na juma phäha, hina ka ngthu am a kümkawi law ham üng am ngthuhei thei lü, na ang khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Khyang he Zakharih kpunga ana ngängki he, Temple k'uma a di lawa phäha aktäa cäiki he. ");
INSERT INTO dao_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Acunüng, a luh law be üng ami veia am ngthuhei thei lü, a kut am jah kha hü se, Temple k'uma mdannak hmukia ami ksing. ");
INSERT INTO dao_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Acunüng, ktaiyü a binaka kcün ngpäng se a ima cit beki. ");
INSERT INTO dao_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Acunkäna a khyu Elizabet m’yai law lü im k'uma khya mhma ngküpki. ");
INSERT INTO dao_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Acunüng Elizabet naw “Khyang hea ami na ksekhanak Pamhnam naw na kpüi lü a na lawhin pet ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Acunüng, akhya khyuk üng Pamhnam naw khankhawngsä Kabriel Kalile khaw, Nazareta a tüih. ");
INSERT INTO dao_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Acuna nglami cun Davita pakhui üngka, Josep ngming nakia khyu vaia ami mkhyäpa kyaki. Nglamia ngming cun Marih naki. ");
INSERT INTO dao_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Acunüng, khankhawngsä naw Mariha veia lut lü, “Pamhnama hlüei la jekyainak, dim’yenak am awma, Pamhnam na veia awm ve, nghnumi he avan üng na josen säih ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Acuna khankhawngsäng naw i a ti hlünak am ksing lü aktäa cäi lü kyüki. ");
INSERT INTO dao_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Acunüng, khankhawngsä naw, “Marih aw, ä kyüa; Pamhnam na veia dawki ni, ");
INSERT INTO dao_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","m’yai lü, kpamica na ca khai, a ngming Jesuha na sui khai. ");
INSERT INTO dao_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ani cun kyäpsawk law se, ak'hlüng säiha Capa ti khai he, Bawipa Pamhnam naw a pu Davita mäiha sangpuxanga pawh law khai. ");
INSERT INTO dao_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ani naw Jakopa mjü he angläta jah uk se, a khaw am düt khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marih naw, khankhawngsä üng, “Kei am ka ceimahki hin ikba acunkba kya thei khai aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Khankhawngsä naw msang lü, “Ngmüimkhya Ngcim na khana pha law se, hlüng säihkia johit naw ning hlawp tawm law khai, acunakyase hmi law khaia khyang ngcim pi Mhnama Capa ti khai he. ");
INSERT INTO dao_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Acunüng ngaia, cingki ami ti khawi na püi Elizabet pi a xü käna kpamica m’yai na se atuh khya khyuk law pängki. ");
INSERT INTO dao_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pamhnama am a ti thei i am awm naw,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Marih naw, “Kei Bawipa ana m’ya nu ni, na ngthua kba ka khana kya kawm,” ti se, acunüng khankhawngsä naw a ceh tak. ");
INSERT INTO dao_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Acunüng, Marih tho law lü, angxita mcunga awmkia mlüh, Judah khawnu mata cit lü, ");
INSERT INTO dao_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakhariha ima lutki naw, Elizabet a hnukset. ");
INSERT INTO dao_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Acunüng, Elizabet naw Marih a hnukset a sim la, a puk k'uma naca ngsün law se, Elizabet ngmüimkhya Ngcim am be law lü, ");
INSERT INTO dao_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","angsanga, “Nghnumi he avan üng na jo sen säih ve, na canak vai pi a jo sen ve! ");
INSERT INTO dao_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ka Bawipaa nu, ka veia na lawnak sen vaia ta ia ngjo ni? ");
INSERT INTO dao_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na na hnuksetnak ka hnga üng a luh la hnasen jekyai lü ka k'uma ngsün ve. ");
INSERT INTO dao_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jumeikia nghnumi pi a jo sen ve, isetiakyaküng a veia Bawipa naw ngthu a pyen he cun kümkawi law khai hea akya phäha kyaki” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Acunüng Marih naw, “Ka mlungmthin naw Bawipa mküimto ve; ");
INSERT INTO dao_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ka ngmüimkhya pi na küikyankia Pamhnama khana aktäa jekyai ve, ");
INSERT INTO dao_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","a na m'yanua hnemnak hmu lü, na süm ve; atuh üng tün lü, khyang avan naw a jo senki na ti na khai he. ");
INSERT INTO dao_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Akyan säih naw ka khana akyäp säih na pawh pe ve, A ngming pi, ngcimcaiki ni; ");
INSERT INTO dao_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A m’yeneinak cun angsawn täh se amät kyühki hea khana awmsaki. ");
INSERT INTO dao_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","“A ban am a kyannak mdang lü, khyang awhcaki he cun ami ngaikyunak am akcea a jah ngtaisak. ");
INSERT INTO dao_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“Ami bawingawhnak üng ngawki hea bawi he a hnemnaka jah khya lü, ami mlung hnemsaki he a jah mhlünmtai. ");
INSERT INTO dao_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","“Ami ei cawiki he, akdaw am jah kphü lü, bawimangki he, ami kut xawnga a jah tüih. ");
INSERT INTO dao_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","“Mi pupa he, a jah na khyütamnakpüi kümkawisak lü, a m'ya Isarel he jah kpüi khaia law ve. ");
INSERT INTO dao_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","A jah m'yeneinak Abraham la a ngsawn hea veia angläta süm ve” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Acunüng Marih, Elizabeta veia khya kthum awm lü a ima cit beki. ");
INSERT INTO dao_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabet na a hmi vai kha law se, kpamicaa caki. ");
INSERT INTO dao_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A impeiloceng he la, a paca he naw, Pamhnam naw a m'yenei ni ti ksing u lü, aktäa ami jekyaipüi. ");
INSERT INTO dao_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Acunüng pat mat küm se, naca a vun mawih vaia law u lü, a ngming a pa ngminga kba Zakhariha sui vaia ami bü. ");
INSERT INTO dao_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Acunüng a nu naw, “Ka! Johana sui vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Acunüng amimi naw, “Na ngsawn, na khui üngka, acunkba ngming naki u am ve khawi naw,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Acunüng a pa ami kut am, “A ngming ua sui üng daw khai aw?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakharih naw, a yuknak vai lungphek kthäh lü, “A ngming Johan,” ti lü yu se, ami van cäi lawki he. ");
INSERT INTO dao_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Acunüng angxita ngthuhei law be thei lü Pamhnam mküimto lawki. ");
INSERT INTO dao_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Acunüng, ami van cäicah lawki he. Acuna mawng cun Judah khaw avan üng ngthang hüki. ");
INSERT INTO dao_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Acun ngjaki avan naw, ami mlung k'uma ta u lü, “Acuna hnasen cun ia mäih vai ni?” ami ti. Ani cun Pamhnam naw a johit am awmpüiki tia ami van naw ksingki he. ");
INSERT INTO dao_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Johana pa Zakharih cun ngmüimkhya Ngcim am be lü, ");
INSERT INTO dao_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isarel hea Bawipa Pamhnam cun mi mhlünmtai vai, a khyang he jah law si lü, jah mhlät be ve, ");
INSERT INTO dao_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A m'ya Davita ngsawn he ak'hlüngtaia Küikyan bawi jah pe ve, ");
INSERT INTO dao_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Acun cun a sahma ngcim he üng ajana a jah na khyütamnaka kba, ");
INSERT INTO dao_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","mi ye he la jah hnengkiea kut üngka naw la küikyan khaia, ");
INSERT INTO dao_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","mi pupa hea veia m'yeneinaka ngthumkhän ana tak a kümsak vai la, a khyütam ngcim a sümnak vaia, ");
INSERT INTO dao_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","mi pa Abrahama veia a khyütamnaka kba, ");
INSERT INTO dao_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","mi ye hea kut üng mi lät lü, am kyü u lü, ");
INSERT INTO dao_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mi xüna küt üng ngcimcaihnak la, ngsungpyunak am a ma a khut mi pawhnak vaia, ");
INSERT INTO dao_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","nang ka ca, Bawipa a lam pyang khaia na cit ma khaia kyase, ak'hlüng säih Mhnama sahma ning ti na khai he, ");
INSERT INTO dao_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ami katnak he jah mhlätnak am, küikyanak, a khyang he üng jah ksingsak khai, ");
INSERT INTO dao_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","mi Pamhnam cun m'yeneinak la hniphnawinak am bebang lü mi khana küikyanaka nghngi vai law sak khai, ");
INSERT INTO dao_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","a nghmüpnak la, thihnaka k'uma awmki he, akvai jah pe khai la, mlung üpnaka lama jah cehpüi khai” a ti. ");
INSERT INTO dao_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Acunüng, a nghmaw cun ngbaü law lü, a mlung ngaihnak kyan law ksetam lü, Isarel hea veia am a ngdang law hama üng khawkhyawng khawa awmki. ");
INSERT INTO dao_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Acunüng, sangpuxang Awkastan naw Romah khaw avan üng ami ngming ami yuk vaia ngthu a jah pet. ");
INSERT INTO dao_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ahina ngming yuknak cun Kurenih, Siria üng a bawi kum üng akcük säiha ngming yuknaka kyaki. ");
INSERT INTO dao_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Acunüng, khyang ami van ami ngming yu khai hea, ami khaw nu phäh phäha citki he. ");
INSERT INTO dao_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep pi Davita khui üngka la ksawna akyaa phäha, Kalile khaw Nazaret üngka naw, Judah hne Davita mlüh Bethlehem ami tia, ");
INSERT INTO dao_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","a khyu vaia ami mkhyäp Marih a m’yai mah am ani ngming yu khai xawia citki xawi. ");
INSERT INTO dao_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bethlehema ani ve üng Marih cun a canak vaia mhmüp küm lawki. ");
INSERT INTO dao_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Acunüng, a ca kcük kpamica a canak, jih am hlawp lü, khin ima am ani ngsut hnga phäha, sepata einak kawng üng a msän. ");
INSERT INTO dao_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Acunüng, acuna khawa toksäm he, kpyawnga ami to he jah k’äih u lü mthana awmki he. ");
INSERT INTO dao_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ng'ngaia Bawipa khankhawngsä mat ami maa ngdüi law lü, Bawipa a hlüngtainak ami ksunga vai law se, aktäa kyükyawki he. ");
INSERT INTO dao_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Acunüng, khankhawngsä naw, “Ä kyü ua, ng'ngai ua, khyang avana phäha, jekyainaka thangkdaw ka ning jah thak lawki ni. ");
INSERT INTO dao_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","“Tuhngawi Davita mlüha küikyan bawi, Bawipa Khritaw, nami hama hmiki. ");
INSERT INTO dao_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“Hin hin nami msingnak vaia kya ve: Hnasen jih am hlawp, sepata einak kawng üng ngjän se nami hmu khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Acunja, khankhawngsä pä he la khankhawngsä cun Pamhnama veia mhlünmtainak ng’äi mcuki he. ");
INSERT INTO dao_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pamhnam cun ak'hlüng säih khankhaw cäpa hlüngtai se, khawmdek khana a jah jenak khyang hea khana ngkhawtnak ve se,” tia, Pamhnam mküimtoki he. ");
INSERT INTO dao_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Acunüng, hinkba kyaki, khankhawngsä he naw khankhawa ami jah cehtak be la, toksäm he naw, “Atuh Bethlehem khaw cäpa mi cit u lü, Bawipa naw ngthu a jah mtheh pha lawki cun mi va teng vai,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Acunüng cit tele u lü, Marih, Josep la, sepata einak kawng üng ngjänkia hnasen ami jah hmuh. ");
INSERT INTO dao_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Acunüng, ami va hmuh khap üng, hnasena mawng khankhawngsä naw a jah mtheh cun aktäa ami pyen. ");
INSERT INTO dao_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Acunüng, toksäm hea ngthu pyen ngjaki he avan cun, aktäa cäicahki he. ");
INSERT INTO dao_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Cunsepi Marih naw, acuna ngthu avan cun ngai lü, a mlung k'uma a tak. ");
INSERT INTO dao_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Toksämke naw, khankhawngsäa a jah mtheha kba, ahmäi hmu u lü ami sima phäha, Pamhnam mhlünmtai mküimto u lü cit beki he. ");
INSERT INTO dao_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Acunüng, a vun mawihnak vai pat mat aküm käna a nua puk k'um üng am a awm hlan üng khankhawngsä he naw ami suia kba, Jesuha ami sui. ");
INSERT INTO dao_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Acunüng, Mosia ngthumkhän peta kba, ngcimcaihnak vaia mhmüp a küm law üng, a nu la a pa naw hnasen cun Jerusalema cehpüi ni lü, ");
INSERT INTO dao_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ca kcük kpamica he cun Pamhnama ka vaia jah ngcimcaihsak vai tia Mosia ngthumkhän üng a awma kba, Pamhnama veia pe ni lü, ");
INSERT INTO dao_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bawipa ngthumkhän üng mümca nghngih, am acunüng mümkyap nghngih jah hnim vai ti lü a awma kba ani pawh. ");
INSERT INTO dao_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Acunüng, Jerusalema Simeon ngming naki khyang mat awmki, acun cun khyangsungpyun, Pamhnam jum lü, Isarel hea küikyanak vai a na ngak'uhki, a khana ngmüimkhya ngcim naw a awmnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ani cun Bawipa Khritaw am a hmuh hama küt üng am thi khai tia ngmüimkhya Ngcim naw ana ksingsaka kyaki. ");
INSERT INTO dao_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Acunüng, hnasen Jesuh, a nu la a pa naw Temple k'uma, thuma kba pawh pet vaia ani lawpüi üng, Simeon cun ngmüimkhya naw ngkhahpüi se Temple k'uma law lü, ");
INSERT INTO dao_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","a kut am hnasen kpawmki naw, Pamhnam mküimto lü, ");
INSERT INTO dao_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bawipa aw, atuh na ngthua kba na m'ya dim’yenak am na cehsak be khaia kya ve, ");
INSERT INTO dao_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","na küikyanak atuh ka mik am hmu veng, ");
INSERT INTO dao_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","khyang avana hmuh vaia na pyan cen: ");
INSERT INTO dao_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Paca kcea veia na vainak sang hü khai la, na khyang Isarel hea hlüngtainak vai cun,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Acunüng acunkba hnasena mawng a pyen cun a nu la a pa naw aktäa ani kyühkhyai. ");
INSERT INTO dao_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Acunüng Simeon naw ani cun josenak am kbe lü, a nu Mariha veia, “Ngaia, hina hnasen hin Isarel he üng khyang khawjaha pyehnak vai la küikyanak vaia Mhnam naw a xü ni. Acunüng khyang naw ami pyenei vaia msingnaka mcawna kyaki. ");
INSERT INTO dao_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","“Khyang khawjaha ami ngaihkyunak a ngdangnak vaia, kcim naw namäta mlung pi ning sun khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Acunüng sahma hmeinu mat Anna ami ti Panuelaha canu, Ashea mjü üngka awmki. ");
INSERT INTO dao_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Acunüng kum khyüh cei mah lü kum khyetkip la kphyü lawki hmeinu, Pamhnama Temple am ceh ta lü, amhmüp amthan, a ei jeih lü ktaiyü lü, Pamhnam sawkhahki. ");
INSERT INTO dao_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ani pi acun la Pamhnama ima law lü, Pamhnama veia jekyainaka ngthu pyen lü, Jerusalema lätnak vai ngak'uheiki hea veia, hnasena mawng cun a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Acunüng, Bawipa ngthupeta kba Josep la Marih cun ahmäi ani pawh khap üng, animäta khaw Kalile, Nazaret khawa cit beki xawi. ");
INSERT INTO dao_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Acunüng, anghmaw cun ngbaü law lü, a mlung ngainak kyan law ksetam tam lü, ksingkhyapnak am be law se, Pamhnama m'yeneinak a khana awmki. ");
INSERT INTO dao_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kphyawnpawi buhpawhnaka Jesuha nu la a pa akum tä se Jerusalema cit khawiki xawi. ");
INSERT INTO dao_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Acunüng, Jesuh a kum xaleinghngih üng buhpawhnaka, ami thum khawia kba Jerusalema hang citki he. ");
INSERT INTO dao_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Acuna mhmüp ngpäng se, ami nghlat law be üng, kpamica Jesuh cun Jerusalema awmei hütki. Acun, a nu la Josep naw am ani ksing. ");
INSERT INTO dao_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A nu la Josep naw Jesuh cun a püi anghmawea veia awmkia ngai ni lü, mhmüp mat ana citki xawi, acunüng ami püi he la ami mjü hea veia ani sui hü. ");
INSERT INTO dao_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Acunüng, am ani hmu üng, Jerusalema nghlat be ni lü ani sui. ");
INSERT INTO dao_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Acunüng, amhmüp kthum käna, Temple k'uma saja hea ksunga ngaw lü, ami pyen jah ngai lü, jah kthäh lü awm se ani hmuh be. ");
INSERT INTO dao_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Acunüng, a ngthu ngjaki he naw, a ksingnak la a jah msangnakea phäha aktäa cäiki he. ");
INSERT INTO dao_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Acunüng, ani va hmuh üng, aktäa cäi ni lü, a nu naw, “Ka capa aw, ivai hinkba na awmki ni? Ngaia na pa la kei cäi ni lü, kani ning sui hüki hin,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesuh naw, “Ivai nani na sui hüki ni? Ka pa ima ka awm khai ti am nani ksingki aw?” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Cunsepi, a jah msangnaka suilam cun am ani ksing. ");
INSERT INTO dao_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Acunüng, ani hlawnga law be lü, Nazareta law beki, acuia ani mtheh ngai lü awmki. Acunüng a nu naw, avan a mlung k'uma a tak. ");
INSERT INTO dao_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Acunüng, Jesuh cun ngvai lawca lü, ksingkhyapnak am kümbe law ksetam lü, Mhnam la khyang hea mik khamei law ksetam tamki. ");
INSERT INTO dao_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ketah sangpuxang Tiberiha a bawi k'um, akum xaleimhma üng, Pontas Pilat cun Judah khaw ukia kyaki. Herod cun Kalile bawia kya lü, a na Philip cun Ituhrih la Tarakonik khawa bawi lü, Abilin khawa Luhtari cun bawia kyaki, ");
INSERT INTO dao_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Acunüng, Anna la Kaiphah ktaiyü ngvaia ani kya k'um üng, khawkhyawng khawa Pamhnama ngthu, Zakhariha capa Johana veia pha lawki. ");
INSERT INTO dao_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Acunüng, Johan cun Jordan tuinu kama, khaw avan üng cit hü lü, “Pamhnam naw nami katnak aning jah mhlätnak vaia, ngjut u lü baptican khan ua” ");
INSERT INTO dao_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sahma Hesajah naw, “Khawkhyawng khawa ngpyang hüki mata ngthu cun, ‘Bawipa lam pyang ua, a lam he jah ngdüngsak ua. ");
INSERT INTO dao_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nghawi naküt jah kbe ua. Mcung naküt pi jah ngmisak u lü, lam ngkhep he pi jah ngdüngsak ua, ");
INSERT INTO dao_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","khyang avan naw Pamhnama küikyanak hmu khai he’ tia, a ng’yuka kba,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Acunüng, khyang he baptican khan khai hea Johana veia lawki he üng, “Kphyuksea mjü he aw! Mhnama mlungsonak pha law khai üng nami lät khaia u naw aning jah mtheh ni? ");
INSERT INTO dao_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Acunakyase nami ngjutnak cun nami bilawh üng mdan ua. ‘Kami pu Abraham ni’ ä ti ua. Ka tiki ni, Pamhnam naw hina lung üngka Abrahama ca hea jah mcawm theiki ni. ");
INSERT INTO dao_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Thingphung avan üng xei msäna kyaki. Akdawa am ngtheihkia thing avan cun ksawm pit u lü mei üng tawna kya khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Acunüng khyang he naw, “Ini kami pawh kawm?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Johan naw jah msang lü, “Upi kcu nghngih taki naw am taki üng mat pe se; upi ei vai taki naw am taki üng pe se,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ngcawn klawk he pi a veia baptican khan khaia law u lü, “Saja aw, ini kami pawh kawm?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Johan naw, “Ami ning jah kthähsaka däm bawki ä kthäh ti ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Acukba yekap he naw pi, “Ini kami pawh kawm?” tia ami kthäh. Acunüng Johan naw, “Ua ngui pi ä yutei ua, amdanga khyang i ä kpuk sawxat ua, nami ngkhengnak khäksak ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Acunüng, khyang he naw ngak'uhei u lü, khyang avan naw Johan cun ami mlung k'uma, “Mesijaha am kyaki aw?” tia ami ngaihkyu k'um üng, ");
INSERT INTO dao_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Johan naw, jah msang lü, “Kei naw tui üng baptican ka ning jah khansak khawiki; cunsepi keiha kyäp bawki law khai, a khawdawk yüi kphyan pe khaia pi am ngkawi nawng; ani naw Ngmüimkhya Ngcim la mei am baptican ning jah khan lawsak khai, ");
INSERT INTO dao_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Angsi a jahnak vaia a kut üng kphya kpawmki; angtak kheia ta lü angsi cun am thi theihkia mei üng mkhih khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Acunüng ami ngneiksak ami thuhlaih vaia jah mcäi lü, thangkdaw pi jah mthehki. ");
INSERT INTO dao_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Cunsepi sangpuxang Herod cun a na a khyu Herodih a khyunaka phäha la katnak khawjah a pawha phäha Johan naw a jüih. ");
INSERT INTO dao_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Acunüng Herod naw aksehlena Johan cun thawngim üng a khyüm. ");
INSERT INTO dao_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Khyang he ami van baptican ami khan law päng üng, Jesuh pi baptican khan hngaki. Ktaiyü se khankhaw nghmawng law lü, ");
INSERT INTO dao_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ngmüimkhya Ngcim cun mümca kba ngdang law lü a khana cu lawki, acunüng khankhaw üngka naw ngthu, “Nang ka jawng'engnak leng lenga ka capa; na khana ka jekyai leng lengki ni,” tia ngthang lawki. ");
INSERT INTO dao_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuh khawkum thumkip acum üng Pamhnama khut tünei lawki. Khyanga ngaiha ani cun Josepa capa kyaki. Acun cun Helia capa kyaki, ");
INSERT INTO dao_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helia pa Mathat, Mathata pa Levih, Leviha pa Mekhih, Melkiha pa Janai, Janaia pa Josep, ");
INSERT INTO dao_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josepa pa Matatih, Matatiha pa Amos, Amosa pa Nahum, Nahuma pa Esali, Esalia pa Nakai, ");
INSERT INTO dao_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakaia pa Mat, Mata pa Matatih, Matatiha pa Seming, Seminga pa Josek, Joseka pa Joda, ");
INSERT INTO dao_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodaa pa Jonan, Jonana pa Resa, Resaa pa Zerubabel, Zerubabela pa Selatih, Selatiha pa Nerih, ");
INSERT INTO dao_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriha pa Melkih, Mekiha pa Adi, Adia pa Kosam, Kosama pa Elamadam, Elamadama pa Erah, ");
INSERT INTO dao_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eraha pa Josuh, Josuha pa Elisa, Elisaa pa Jorim, Jorima pa Mathat, Mathata pa Levih, ");
INSERT INTO dao_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leviha pa Simeon, Simeona pa Judah, Judaha pa Josep, Josepa pa Jonam, Jonama pa Elakim, ");
INSERT INTO dao_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakima pa Melah, Melaha pa Mena, Menaa pa Matatha, Matathaa pa Natan, Natana pa Davit, ");
INSERT INTO dao_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davita pa Jesse, Jessea pa Obet, Obeta pa Bozah, Bozaha pa Salmon, Salmona pa Nashon, ");
INSERT INTO dao_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashona pa Aminadap, Aminadapa pa Ani, Ania pa Heron, Herona pa Pereh, Pereha pa Judah, ");
INSERT INTO dao_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaha pa Jakop, Jakopa pa Isak, Isaka pa Abraham, Abrahama pa Terah, Teraha pa Nahor, ");
INSERT INTO dao_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahora pa Seruh, Seruha pa Reuh, Reuha pa Pelek, Peleka pa Ebar, Ebara pa Shelah, ");
INSERT INTO dao_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelaha pa Kenan, Kenana pa Aphazad, Aphazada pa Shem, Shema pa Nawe, Nawea pa Lameh, ");
INSERT INTO dao_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameha pa Matuselah, Matuselaha pa Enawk, Enawka pa Jaret, Jareta pa Mahalelah, Mahalelaha pa Kenan, ");
INSERT INTO dao_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenana pa Enos, Enosa pa Shet, Sheta pa Adam, Adama pa Mhnama kyaki. ");
INSERT INTO dao_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesuh Ngmüimkhya Ngcim am beki, Jordan tuinu üngka naw a nghlat law be üng Ngmüimkhya naw khawkhyawng khawa cehpüi se, ");
INSERT INTO dao_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","mhmüp kphyükip khawyai naw a hlawhlep. Acunüng ipi am ei se, anghnua a ei cawi lawki. ");
INSERT INTO dao_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Khawyai naw, “Nang Mhnama capa na kyak üng, hina lung muka ngthawn law khaia ngthu pea,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Acunsepi Jesuh naw msang lü, “Khyang cun ei däng üng am xüng, tia cangcim üng ng’yuki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Acunüng khawyai naw Jesuh khawmcung a hlüngnaka kaipüiki naw khawmdeka khana khawe avan mik mkhyüp üng jah mhmuh lü, ");
INSERT INTO dao_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Hin he avan ka veia peta kyaki, upi ka ngaih üng ka peki, hina ana avan la a kyäpsawknak avan ka ning pe khai, ");
INSERT INTO dao_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","acunakyase na sawhkhah lü, avan na kaa kya khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesuh naw a veia, “Cangcim üng, ‘Na Bawipa Pamhnam sawhkhah lü, ani däng na khüih vai,’ tia ng’yuki,’” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Acunüng khawyai naw Jerusalema cehpüiki naw, Temple khan, amsumnaka ta lü, “Mhnama capa na kyak üng hin üngka naw mcea namät kcoa, ");
INSERT INTO dao_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‘Ani naw khankhawngsä he ning na k’äih u lü, ning na mcei khai hea jah mcawn khai, ");
INSERT INTO dao_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na khaw am lung am na su khaia, ami kut am ning na mcei khai he’ tia, ng’yüki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Cunsepi Jesuh naw, “Na Bawipa, Pamhnam ä na mhnütei vai,’ tia kyaki ni,” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Acunüng khawyai naw a hlawhlepnak vai avan am a hlawhlep käna asäng a ceh tak ma. ");
INSERT INTO dao_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Acunüng Jesuh, Ngmüimkhya Ngcima khyaihnak am Kalilea nghlat be se, a mawng cun acuna khaw pei avan üng ngthang hüki. ");
INSERT INTO dao_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Acunüng sinakoka jah mthei hü se, khyang avan naw ngak u lü, ami mhlünmtai. ");
INSERT INTO dao_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Acunüng angvainak Nazareta a law be üng a thum khawia kba Sabbath mhmüp üng, Sinakoka k'uma lut lü ngthungcim khe khaia ngdüiki. ");
INSERT INTO dao_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Acunüng sahma Hesajah cauk ami pet. Acunüng cauk ktawm a kphyan üng hinkba angyuknak a kheh, ");
INSERT INTO dao_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bawipa Ngmüimkhya ka khana awmki, ani naw thangkdaw m'yyenkse hea veia ka sang khaia a na xü. Ami mlung naki he ka jah mhlät be khai, khuikhaki hea veia lätnaka thangkdaw ka sang khai, amikmü he ka jah mdaw be khai, ami jah man he ka jah mhlät khaia la, ");
INSERT INTO dao_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bawipa naw a khyang he a jah küikyanak vaia kcün pha lawki ti, ka sang khaia ana tüih law ni,” tia kyaki. ");
INSERT INTO dao_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesuh naw cauk ktawmki naw jah pe be lü ngawki. Acunüng Sinakoka k'uma ngawki he avan naw kcävä u lü ami teng. ");
INSERT INTO dao_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Acunüng Jesuh naw, “Tuhngawi hina thungcim nami sim kümkawi law ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Acunüng ami van naw, a ngthu pyen cun aktäa ngai hlü u lü, aktäa kyühkhyai u lü, “Hin hin Josepa capa am kyakia kya aih se,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesuh naw, “Hina msuimcäpnak, ‘Sibawi, namät la namät m’yai bea! Ipi Kapenawm khawa pawh hina khaw üng pi pawh lü mdang lawa’ nami ti khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Acunüng Jesuh naw, “Akcanga ka ning jah mthehki, sahma cun amäta khawa am dokhamei khawi u. ");
INSERT INTO dao_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Cunsepi ka ning jah mthehki, Elijaha kcün üng, khawkum kthum la khya khyuk khaw am a se, khaw avan üng khaw a set law üng, hmeinu khawjah Isarel khawa awmki he, ");
INSERT INTO dao_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","cunsepi ua veia pi Elijah tüiha am kya naw, Sidon khaw da Sarepta khawa hmeinu mata veia ni tüiha akya ve. ");
INSERT INTO dao_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Acunüng sahma Elishaa kcün üng pi Isarel khawa mnehkse mnehki khawjah awmki he; cunsepi Naman, Siria khawa ka dänga thea upi ngcimsak bea am kya naw,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Acunüng Sinakoka k'uma awmki he ami van acun ami ngjak üng, aktäa ami mlung soki. ");
INSERT INTO dao_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Acunüng tho law u lü, mlüh üngka naw ktämki he naw ami mlüha awmnak mcunga khana ami buhtawn vaia ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Cunsepi Jesuh ami ksunga ngjui lü akcea citeiki. ");
INSERT INTO dao_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Acunüng Jesuh naw Kalile mlüh, Kapenawma cit lü Sabbath mhmüp üng a jah mthei. ");
INSERT INTO dao_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A ngthu pyen ana a awma phäha aktäa cäicah lawki he. ");
INSERT INTO dao_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Acunüng Sinakoka k'uma khyang mat ngmüimkhya ksea awmnak awmki cun, ");
INSERT INTO dao_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nazaret Jesuh, i mi nglak awm se ni? Jah mkhyüh khaia na lawki aw? Nang ka ning ksingki, nang Mhnama ngsä ngcima na kyaki ni,” ti lü ngpyangki. ");
INSERT INTO dao_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesuh naw, “Ä khikheh lü a k'um üngka naw lut law,” ti lü jüi se, acunüng khawyai naw khyang hea maa mkhyu lü, ia pi am pawh lü a ceh tak. ");
INSERT INTO dao_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Acunüng awmki he ami van naw cäi u lü, “Hin hin ia ngthu ni? Ana la khyaihnak am khawyai kse he jah jüi se lut lawki he hin,” tia ngthäh kyuki he. ");
INSERT INTO dao_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Acunüng acuna pipei, khaw avan üng a mawng ngthang hüki. ");
INSERT INTO dao_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesuh Sinakok üngka naw ktawih lü Sihmona ima citki. Acuia Sihmona pi aktäa mhnatei se ami mtheh. ");
INSERT INTO dao_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesuh naw a peia ngdüi lü a mhnat jüi se mhnat naw a khyah. Acunüng angxita tho law lü a jah khüih. ");
INSERT INTO dao_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Acunüng khaw kya se, natnak akce kcea jah hui, am phetki he avan a veia ami jah lawpüi; acunüng ami vana khana a kut mtaih lü a jah m’yai be. ");
INSERT INTO dao_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Khawyai he naw, “Pamhnama Capa na kyaki ni,” tia, ngpyang u lü, khyang khawjaha k'um üngka naw lut lawki he. Acunüng Jesuh naw jah jüi se, Mesijaha kyaki ti ami ksinga phäha am a jah ngthuhei sak. ");
INSERT INTO dao_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Khawa thaih law la, Jesuh mlüh ktawi ta lü angkhyinaka cit se, khyang he naw sui u lü a veia law siki he naw, am a jah ceh tak vaia ami khyawh. ");
INSERT INTO dao_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Cunsepi Jesuh naw, “Pung kcea pi Pamhnama khawa mawng thangkdaw ka pyen khaia kyaki, acun vaia tüih lawa ka kyaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Acunakyase acuna khawaa awmkia Sinakok hea k'uma ngthu sang hüki. ");
INSERT INTO dao_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Khawmhmüp at üng khyang he Pamhnama ngthu ngai khai hea ami ngbum law üng Jesuh Kenesaret tuili kama ngdüi lü, ");
INSERT INTO dao_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","tuili kama mlawng nghngih ve se a hmuh, cunsepi ngaksuie cun acun üngka naw kco u lü ami ngvai he jah mthi khai hea citki he. ");
INSERT INTO dao_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sihmona mlawng mata khana Jesuh kai lü, lawngkam üngka naw ajawha tui da ahei mhnawn vaia a mtheh. Acunüng mlawng üng ngaw lü khyang he a jah mthei. ");
INSERT INTO dao_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Acunüng ngthu a pyen law päng üng Sihmona veia, “Tui alinaka hei mhnawna, na püi he am ngvai vawi u lü nga kpang ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sihmon naw, “Saja aw, amthana vawi u lü, i pi am kami yahki, cunsepi na ngthua kba vawi vang,” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Acunüng vawi u se ami ngvai pi tek hlü hnap khaia nga aktäa kpangki he. ");
INSERT INTO dao_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ami püi mlawng kce üng awmki he law u lü ami jah kpüi law vaia ami kut ami hei kha. Acun he law u se mlawng nghngih üng ngcum law hlü ngsai khaia nga ami tak. ");
INSERT INTO dao_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sihmon Pita cun Jesuha khaw kunga kawp lü, “Bawipa aw, kei khyangka ni, na ceh taa,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nga khawjah ami kpana phäha awm hmaihki he am aktäa cäiki he. ");
INSERT INTO dao_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sihmona püi he bä, Zebedea capa Jakuk la Johan naw pi aktäa ani kyüh. Acunüng Jesuh naw Sihmon üng, “Ä kyüa, tukbäi üngka naw khyang na kpang khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Acunüng ami mlawnge lawngkama jah kaipüiki he naw, a hmäi ceh ta u lü Jesuh cun ami läk. ");
INSERT INTO dao_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesuh mlüh mata a awm üng khyang mat mnehkse natnak am beki awmki naw Jesuh hmu law lü, mdek üng kawp lü, “Saja aw, na hlüei üng na na ngcimsak be theiki ni,” ti lü a nghüinak. ");
INSERT INTO dao_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesuh naw a kut han sängki naw hnet lü, “Ka hlüeiki ni ngcim lawa,” a ti. Acunüng angxita a mnehkse cun khyük lawki. ");
INSERT INTO dao_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesuh naw a veia, “U üng pi ä na mtheh vai, cunsepi ktaiyü üng va ngtengei kyusak lü, Mosia thuma kba khyang hea ksinga na ngcim angsingnak vaia pemsawtnak mat va pawha,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Cunsepi Jesuha mawng cun ngthang hü ksetam se, khyang khawjah a ngthu ami ngai hlüa phäh la, ami natnak he a jah mdaw be vai ami ngaia phäha aktäa ngcun lawki he. ");
INSERT INTO dao_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Cunsepi Jesuh amät khawkhyawng khawea ktaiyü khaia citeiki. ");
INSERT INTO dao_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mhmüp mat a jah mthei k'um üng, Kalile, Judah la Jerusalem üngka naw lawki hea Pharise he la, Mosia thum jah mtheikia saja he a peia ngawki he. Acunüng yainak Bawipa a khyaihnak cun a veia awmki. ");
INSERT INTO dao_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Khyang avang naw akxo mat a ngjännak üng kawt lawki he naw Jesuha ma tak vaia ami bü. ");
INSERT INTO dao_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Khyang däm se, ami luhnakpüi vai am hmu u lü, im khana kaipüiki he naw, im khan üngka naw mkyung kpäk u lü, anglung üng Jesuha ma a ngjänak maha ami ju khyak. ");
INSERT INTO dao_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesuh naw ami jumnak hmu lü, ka püi aw, “Na katnak he jah mhlät pänga kya ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Thum ksing he la Pharise he naw ngaikyu u lü, “Hin hin u ni, Pamhnam ksekhanaka ngthu pyenki? Mhnama thea u naw katnak he jah mhlät thei se ni?” tia ng’yüngki he. ");
INSERT INTO dao_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesuh naw ami ngaihkyunak he jah ksing lü, “Ivai nami mlung k'uma nami ngaikyuki ni? ");
INSERT INTO dao_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Ini ajäi bawk? Na katnak he jah mhlät pänga kya ve, ti vai aw? Am acunüng tho law lü cita ti vai aw? ");
INSERT INTO dao_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","“Cunsepi khyanga capa naw khawmdeka khana katnak he jah mhlätnaka ana taki ni ti nami ksingnak vaia,” ti lü, akxo üng, “Tho law, na ngjänak lo lü na ima cita, ti veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Acunla akxo cun ami ma ngdüi law lü, a ngjänak lo lü, Pamhnam mküimto lü, a im lama cit beki. ");
INSERT INTO dao_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ami van cäi law u lü, Pamhnam mküimto u lü, kyühnak am be u lü, “Tuhngawi am hmuh khawia cäicahnak mi hmu law ve,” tia, ng’yüngkoki he. ");
INSERT INTO dao_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Acunkäna ava ceh üng, ngcawnklawk Levih ngming naki ngcawn lawknaka ngaw se hmu lü, “Na läk lawa,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Acunüng Levih naw tho law lü ahmäi jah yawk lü a läk. ");
INSERT INTO dao_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Acunüng Levih naw a ima, Jesuh khina lü, buh aknuia pawh se, acuia ngcawnklawki he la akce khawjah ngaw hmaihki he. ");
INSERT INTO dao_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pharise avang la ca k'yu avang naw Jesuha axüisaw he üng, “Ivai ngcawnklawk he la khyangka he am nami ei hmaihki he ni?” tia ami jah pyen. ");
INSERT INTO dao_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesuh naw jah msang lü, “Khyang kphet he naw sibawi am hlü u, am phetki he naw ni sibawi ami hlü. ");
INSERT INTO dao_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Kei khyang ngsungpyune jah khü khaia ka lawkia am kya naw; khyangka he ngjutnaka jah khü khaia ni ka law ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Khyang avang naw, “Johana axüisaw he angläta ami ei jeih u lü ktaiyüki he, Pharise hea ami xüisaw he pi acunkba ami ei jeih u lü ktaiyü khawiki he, ise nanga xüisaw he ei awki he ni,” tia, Jesuh ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesuh naw, “Cambumki a püi he am ami awm hmaiha küt üng, ei nami jah jeihsak thei khai aw? Am jeih u. ");
INSERT INTO dao_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","“Cunsepi cambumkia cangpyang ami vei üngka naw lak lawnaka kcün pha law khai, acuna kcün üng ami ei jeih law khai he,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesuh naw msuimcäpnak jah mtheh lü, “U naw jih kthai ktek lü jih kphyüm kpäk üng am kbun khawi u, ami kbun üng akthai tek khai. Ami kbunak akthai la akphyüm am nghlawi khai xawi. ");
INSERT INTO dao_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“U naw capyitui asü awi akphyüm üng am than khawi u, ami than üng capyitui asü naw awi akphyüm ütpäk se ngsawi bäih lü awi pi ak khai. ");
INSERT INTO dao_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","“Capyitui asü awi akthai üng than vai, acunüng va ani nghngih am se khai xawi. ");
INSERT INTO dao_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“U naw capyittui akphyüm ami awk käna akthai am ngaih khawi u naw, ‘Akphyüm daw bawki’ ti khawiki he,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabbath mhmüp üng Jesuh lo hmu lama cit se axüisaw he naw kyung cangvui jah kpyat u lü ami kut am mnawiki he naw ei u se, ");
INSERT INTO dao_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pharise avang he naw, “Ivai Sabbath mhmüp üng am nghlawiki nami pawhki ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesuh naw jah msang lü, “Davit a ei cawi law lü, a püi he am i ami pawh am nami kheh khawiki aw? ");
INSERT INTO dao_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pamhnama ima lut lü, ktaiyüe däng naw ami ei ngkawi muk lo lü, ei lü, a püi he üng pi a jah pet cen,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Acunüng Jesuh naw, “Khyanga capa hin Sabbatha bawi ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabbath akce üng Sinakoka lut lü a jah mthei. Acunüng khyang mat a kut kpat lam xoki awmki. ");
INSERT INTO dao_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Thum ksing he la Pharise he avang naw ami mkateinak vaia, Sabbath mhmüp üng mdaw law be khai aw tia a peia awm u lü ami mcih. ");
INSERT INTO dao_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesuh naw ami ngaihkyunak jah ksingki naw akutxo üng, “Tho law lü maa lawa” ti se, akxo cun tho law lü ngdüiki. ");
INSERT INTO dao_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Acunüng Jesuh naw, “Mat ka ning jah kthäh khai. Sabbath mhmüp üng kpüi vai aw angkawih? Kpyeh vai aw angkawih? Xünak küikyan vai aw angkawih? Kpyeh vai aw angkawi?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Acunüng ami van jah teng law päng lü; akxo üng, “Na kut sänga” ti se, acunkba a säng la vanglama ka kba a kut daw law beki. ");
INSERT INTO dao_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Acunüng ami mlung naw jah uimsoei se ikba Jesuh ami pawh vaia ngthäh kyuki he. ");
INSERT INTO dao_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Acunüng, Jesuh ktaiyü khaia mcunga ktawih lü, Pamhnama veia mthai mhlän lü ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Khaw athaih law la axüisaw he a veia jah khü lü, xaleinghngih ngsä hea a jah xü he cun, ");
INSERT INTO dao_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pitaa a sui Sihmon la a na Andru; Jakuk la Johan, Philip la Batolame, ");
INSERT INTO dao_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mahte la Thomah, Alaphaha capa Jakuk, Patriot naki Sihmon, ");
INSERT INTO dao_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jakuka ca Judah la Jesuh ceng lawkia Judah Iskarota kyaki he. ");
INSERT INTO dao_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesuh a ngsä he am mcung üngka naw ami kyum law be üng, a donak üng axüisaw he khawjah am ngdüiki he. Acuia khyang khawjah, Judah khaw avan üngka he la, Jerusalem üngka he, Turah la Sidon mlüh lam tuikam üngka khyang khawjah; ");
INSERT INTO dao_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","a ngthu ngai khai he la ami natnak a jah mdaw be vaia law hüki he. Acunüng ngmüimkhya kse hea jah pawhe pi law u se a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A vei üngka naw khyaibahnak lut law lü jah yai sak se, khyang avan naw ami hnet vaia ktha naki he. ");
INSERT INTO dao_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesuh naw axüisaw he jah teng lü, “M'yenkseki he aw nami jo sen ve; Pamhnama khaw nami hama kyaki! ");
INSERT INTO dao_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nangmi atuh nami ei nami cawiki nami jo sen ve; nami ei nami phü law khaia kyaki! “Nangmi atuh nami mbawikyapki he nami jo sen ve; nami yaiyüng law khaia kyaki! ");
INSERT INTO dao_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Khyanga Capaa phäha khyang he naw ning jah hneng u lü, ning jah jüi u lü nami ngming am dawki ti u lü ami ning jah yawk üng nami jo senki! ");
INSERT INTO dao_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Jekyai u lü, hlim u lü, nglam ua, khankhawa nami ngkhengnak vai khawjah awmki. Acukba ami pupa he naw sahma hea khana ana pawh khawiki he ni. ");
INSERT INTO dao_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Cunsepi atuh nami bawimangki he nami jo se ve; hlimnak nami yah pängkia kyaki! ");
INSERT INTO dao_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Nangmi atuh nami phüki nami jo se ve; nami cawi law khaia kyaki! “Nangmi atuh nami yaiyüngkie nami jo se ve; ktha se lü nami mbawikyap law khaia kyaki! ");
INSERT INTO dao_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Khyang he naw ami ning jah mhlünmtai üng nami jo se ve; ami pupa he naw sahma kcang he am niki he khana acunkba ana pawh khawiki he ni. ");
INSERT INTO dao_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ka ngthu ngjaki he aw, nami ye jawng na u lü ning jah hnengkie ami dawnak vaia pawh u. ");
INSERT INTO dao_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Ning jah yünceki he josenak am jah kbe u lü ning jah mkhuimkhaki he jah ktaiyü pe u. ");
INSERT INTO dao_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Nami ngbeng vanglam ning jah kbeiki üng vanglam pi dunei pe u, acunüng nami jih ning jah lawhei peki am nami kcu a lawhei vaia pi ä nami mkhyawh vai. ");
INSERT INTO dao_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Ning jah kthäheiki üng pe u lü nami ka ning jah lawhei peki ä kthäh be u. ");
INSERT INTO dao_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Khyang naw nami khana akdaw a pawh vai nami ngjak hlüa kba khyanga khana akdaw pawh ua. ");
INSERT INTO dao_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ning jah jawng naki däng nami jawngnak be üng ngkhengnak i nami yah khai ni? Khyangka he naw pi jah jawng naki cun jawng na beki he ni. ");
INSERT INTO dao_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Acunüng nami khana dawki hea veia däng nami daw be üng ngkhengnak i nami yah khai ni? Khyangka he naw pi acunkba cui pawh hngaki he ni. ");
INSERT INTO dao_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Ning jah thung be thei khai däng üng yah be vaia ngak'uheinak am iyaw nami kpu üng ngkhengnak i nami yah khai ni? Khyangka he naw pi yah be vaia ngak'uhnak am khyangka he üng jah kpu hngaki he ni. ");
INSERT INTO dao_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Cunsepi nami ye he jah jawng na u lü ami dawnak vai pawh u lü jah kpu ua, acunkba nami pawh üng ngkhengnak nami yah be vai ä ngai ua. Acunüng Akhlüng säih Mhnama ca hea nami kya khai. Mhnam cun bänak am ksingki la am dawki hea veia pi m'yeneinak taki ni. ");
INSERT INTO dao_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Acunakyase nami Pa m'yeneinak am a bea kba khyang m'yenei hnga ua. ");
INSERT INTO dao_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Khyang ä nami jah ngthumkhya pet vai, acunüng ngthumkhyanak am am nami awm khai; ä nami jah mkatei vai, acunüng mkateinak am am nami awm khai; jah mhlät u, acunüng mhlätnak am nami awm hnga khai, ");
INSERT INTO dao_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Khyang üng pe u, Pamhnam naw ning jah pe be khai. Akcanga kbäi dänga ä kyase hnawm u lü, khyün u lü, pyep khaia ning jah pe khai he. Nami kbäinak bä am Mhnam naw ning jah kbäi pe be khaia kyaki” a ti. ");
INSERT INTO dao_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Acunüng Jesuh naw msuimcäpnak mat ami veia pyen lü, “Amikmü naw, amikmü cehpüi thei khai aw? Amikmü naw a cehpüi üngta ani nghngih khuia k'uma am kya khai xawi aw? ");
INSERT INTO dao_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Ngtheiki cun mtheikia kthaka am kyäp bawk naw, upi ami ngthei käna jah mtheikia mäih ni ami law kawm. ");
INSERT INTO dao_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ivaia nami mäta mik üng thingmtawn awmki am ngai u lü, nami bena mik üngka mik ek cun nami hmuh ni? ");
INSERT INTO dao_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“Ikba nami mäta mik üngka thingmtawn am hmuei u lü na benaa mik üngka ‘Na mik ek ning lawh pe vang’ nami ti thei ni?’ Hypocrit he, akcüka nami mäta mik üngka thingmtawn loei ma u lü, acunüng nami benaa mik üngka mik ek nami lawh pet vaia angsinga nami hmu khai. ");
INSERT INTO dao_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Thing kdaw naw akse am ngtheih khawi naw, thing kse pi akdawa am ngtheih khawi naw. ");
INSERT INTO dao_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","“Thing avan a ktheih üng ksinga kyaki. Khyang u naw nghling kpyap üng ktheih am kbit khawi u, u naw kpyap üng capyit am kbit khawi u. ");
INSERT INTO dao_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Khyang kdaw naw akdaw a mlungmthin üngka akdaw mhluh law khawiki; khyang kse naw akse a mlungmthin üngka akse mhluh law khawiki. Isetiakyaküng a mlungmthin üng beki a mka naw a pyen khawia kyaki. ");
INSERT INTO dao_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ivai ka ning jah mtheh am bi u lü, ‘Bawipa, Bawipa’ tia nami na khüki ni? ");
INSERT INTO dao_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Khyang ka veia law lü ka ngthu ngai lü ka ngthua kba awmki avan cun u am tängki tia kyak üng, ");
INSERT INTO dao_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","lunga khana angkyunga co lü imsaki am tängki ni. Tui däm law lü tui naw acuna im cun tu law se pi lunga khana saka kyase am ngsün lü awmki. ");
INSERT INTO dao_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Ka ngthu ngja lü ka ngthua kba am awmki cun, akhängnak am awmki, mdeka khana imksa am tängki. Tui däm law lü tui naw acuna im cun tu law se angxita kyu lü avan pyehki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesuh naw ngthu pyen law päng lü Kapenawma citki. ");
INSERT INTO dao_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Acunüng Romah ngvai naw a jawngnaka m'ya mat thi law hlü khaia a mhnat awmki. ");
INSERT INTO dao_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesuha mawng a ngjak üng, a m'ya mdaw law be khaia, Jesuh va nghui na u lü, khü khai hea, Judah ngvai he a jah tüih. ");
INSERT INTO dao_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jesuha veia law u lü aktäa nghui naki he naw, “Hina khyang ta na kpüi vaia ngkawi ve, ");
INSERT INTO dao_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ani cun mi khyang he jah jawng na lü, Sinakok pi jah sak peki ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Acuna Jesuh ami veia citki. Acunüng a pha law tawm tawm la Romah ngvai naw a püi he jah tüi lü, “Bawipa aw, ka im na luhnak ngkawi vaia am kya ve, ä kha heia, ");
INSERT INTO dao_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","acunakyase, na veia ka law vaia pi ka ngkawikia am ngai kyu veng, ngthu däng pyen lü, ka m'ya daw be khai ni. ");
INSERT INTO dao_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Isetiakyaküng, kei haw anaa takia keha ka awmki. Ka keha yekap he awmki he, mat am ‘cita’ ka ti üng citki, akce mat am ‘lawa’ ka ti üng lawki, ka m'ya am hin pawha ka ti üng pawhki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesuh naw acun a ngjak üng, cäieiki naw, mang hü lü, amät läkia khyang he üng, “Isarel he üng pi ahikba sena jumeiki am hmu khawi nawng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","A khyang tüihe ima ami ceh be üng, m'ya cun daw be se ami hmuh. ");
INSERT INTO dao_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Acun käna Jesuh Nai ami tia mlüha cit se, axüisaw he la khyang khawjah a veia cit hngaki he. ");
INSERT INTO dao_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mlüh mkawt pei a pha law üng, hmeinu naw mat däng a canak, khyang kthi ami yawknak kawt law u se, mlüh üngka he khawjah law hngaki he. ");
INSERT INTO dao_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Acunüng, Bawipa naw acuna hmeinu a hmuh üng, m'yenei leng leng lü, “Ä kyapa” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesuh naw law lü, yawkkawng hnet se, kawtki he ngdüiki he. Acunüng Jesuh naw, “Cawngpyang, tho law, ti veng,” ti se, ");
INSERT INTO dao_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","akthi cun tho law lü ngthuhei law se, Jesuh naw a nu üng a pet. ");
INSERT INTO dao_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Acunüng, ami van kyü lawki he naw, Pamhnam mküimto u lü, “Mi ksunga sahma akyäp awm law ve; Pamhnam a khyang he jah küikyan khaia law ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Acuna Jesuha mawng cun khaw avan la a pipeia hne avan üng ngthang hüki. ");
INSERT INTO dao_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Johana axüisaw he naw acuna mawng avan cun Johan üng ami mtheh. ");
INSERT INTO dao_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Acunüng, Johan naw axüisaw nghngih jah khüki naw, Bawipa veia jah tüi lü, “Johan naw law khai a tia khyanga na kyaki aw? Akce kami na äpei khai aw?” tia a jah va kthähsak. ");
INSERT INTO dao_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Acunüng, Jesuh veia law u lü, “Law khai mata na kyaki aw? Akce kami na äpei khai aw? tia ni kthäh vaia baptican Johan naw na veia a jah tüih law ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Acunapät üng Jesuh naw, a jah huieie, natnak khihlau akce kcea jah awmnak he, ngmüimkhya ksea awmnak he khawjah jah mdaw be lü, amikmü khawjah a jah mdeisak be. ");
INSERT INTO dao_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesuh naw, “Citbe u lü, nami hmuh la nami sim he Johan üng jah va mtheh ua; amikmüe mdei law be ve u, akhawkxo he ami khaw am cit ve u, mnehkse mnehkie ngcim be ve u, ami nghnga kpangki he pi ami nghnga ngjang be ve u, akthi he xüng law be ve u, khuikha m’yetsekiea veia thangkdaw sanga kya ve. ");
INSERT INTO dao_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“Upi, keia phäha, a mlung am hlawtlatki ta a jo sen ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Johana xüisaw he ami ktawih be käna, Jesuh naw Johana mawng khyang he üng jah mtheh lü, “Johana veia, khawkhyawng khawa nami ceh üng, i teng khaia ni nami ceh? Khawkhia aksün khuhlip teng khaia aw nami ceh? ");
INSERT INTO dao_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Am acunüng i teng khaia ni nami ceh? Suisak akdaw suisaki teng khaia aw nami ceh? Suisak akdaw suisaki he cun sangpuxang hea ima ni ami awm khawi. ");
INSERT INTO dao_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Am acunüng sahma teng khaia aw nami ceh? Ä, ka ning jah mtheki, sahmaa kthaka pi kyäp bawki hia awm ve, ");
INSERT INTO dao_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","cangcim naw ‘Ngaia ka khyang na ma ka tüih, ani naw na maa lam pyang khai’ tia a mawng ami yuk cen ahina Johan ni. ");
INSERT INTO dao_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Ka ning jah mthehki, nghnumi hea ca avan üng Johana kyäp bawki sahma am awm naw; cunsepi, Pamhnama khawa akjaw säih pi Johana kthaka kyäp bawki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Acunüng, khyang avan naw ami ngjak; aktunga ngcawnklawk he cun Pamhnama ngsungpyunak vaia Johana baptican khanki he. ");
INSERT INTO dao_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Cunsepi, Pharise he la, thum mksingki he naw, ami hama Pamhnama pyan ma u lü, Johana baptican ä khanki he. ");
INSERT INTO dao_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesuh naw pyen be tü lü, “Tuhkbäiha ngsawn he hin i am ni ka jah msuimcäp kawm? Ia mäih ni ami law? ");
INSERT INTO dao_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","“Ahin he cun Anghmawe jawihtuknaka ngawki he, ngkhü kyu u lü, ‘Cambumak pülün ning jah tum pe ung se am nami nglamki, yawk la sa ung se pi am nami kyapki’ ti am tängki he. ");
INSERT INTO dao_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Baptican Johan a law üng ei nghmü lü capyitui am aw se, ‘khawyaia awmnak’ nami tiki. ");
INSERT INTO dao_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","“Khyanga Capa law lü ei aw se, ‘Teng u, eiaw aih ve, ngcawnklawk he la khyang kse hea püi cen’ nami tiki. ");
INSERT INTO dao_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Mhnama ksingkhyapnak cun dokhameiki he naw a cangnak mdangki he ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharise mat naw a veia buh ei khaia khü se, Jesuh Pharisea ima lut lü buh ei khaia ngawki. ");
INSERT INTO dao_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Acuna mlüh üng nghnumi kse mat awmki naw Pharisea ima Jesuh buh ei lü awmki ti, a ksing üng, alabasta um üng situi ngui lawpüiki naw, ");
INSERT INTO dao_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesuha hnu, a khaw kunga kyap lü ngdüiki. A miktui naw a khawpha msüi se, a lusam am xüt lü, a khawpha mhnamki naw, situi ng'ui am a hluk. ");
INSERT INTO dao_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pharise naw hmu lü, a mlung k'uma, “Hin hin sahma kcanga a kya vai sü, hnetkia nghnuminu hin u ni, ia mäih ni ti ksing khai sü. Khyangka kyalang se,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesuh naw, “Sihmon, na veia ngthu mat ka pyen vai awm ve,” ti lü a msang. Acunüng Sihmon naw, “Saja aw pyena,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesuh naw, “Ngui jah kpuki, mat naw, khyang nghngih üng ngui a jah kpu; mat üng phya mhma a kpu, mat am mhmakip a kpu. ");
INSERT INTO dao_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","“Ani thungnak be vai am ta ni se, ani nghngih a jah mhlät. Acunüng, acun xawi üng u naw jawng na bawk khai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sihmon naw, “A mhlät däm naw jawng na bawk khaia ngai veng,” ti lü, msang se, Jesuh naw, “Cang veki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Acunüng, nghnumi nghlat si lü, Sihmona veia, “Hina nghnuminu na hmuki aw? Na ima lut law ni se, ka khaw ka mthinak vaia tui am na na peki, hina nghnuminu naw a miktui am ka khaw mthi lü, a lusam am xütki. ");
INSERT INTO dao_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","“Nang naw am na na mhnamki, hina nghnumi naw ka luh law üng tün lü ka khawpha am pyai lü mhnamki. ");
INSERT INTO dao_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Nang naw ka lü situi am na hluki, hina nghnumi naw ka khawpha situi am hluki. ");
INSERT INTO dao_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Acunakyase, ning mtheh veng, aktäa jawng nakia kyase, a katnak he khawjah cun mhlät pänga kya ve. A katnak ajaw däng mhlät naw ajawha jawng naki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Acunüng, Jesuh naw nghnumi üng, “Na katnak he jah mhlät pänga kya ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Buh a eipüi he naw, “Katnak pi jah mhlätki hin u ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Acunüng, Jesuh naw nghnumi üng, “Na jumnak naw ning küikyan ve, dim’yenak am cita,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Akäna Jesuh naw, mlüh he, ngnam he üng cit hü lü Pamhnama khawa mawng thangkdaw sang hü se, xaleinghngih he pi a veia citki he. ");
INSERT INTO dao_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Acunüng, nghnumi he khawyaia awmnak daw beki he la, natnak üngka naw yai beki he pi awmki he. Acuna nghnumi he cun, a k'um üngka naw khawyai khyüh lut lawkia Makdalin ami ti Marih naki, ");
INSERT INTO dao_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Heroda khawhthem mceiki Joanah, Cuza a khyu, Susanah la, amimäta ka am Jesuh tumbeiki hea nghnumi kce hea kyaki he. ");
INSERT INTO dao_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mlüh mat ngpäng se mat üngka khyang he law hü u lü, ngbum law u se, Jesuh naw, msuimcäpnak am ngthu jah mtheh lü, ");
INSERT INTO dao_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mciksaw, mci saw khaia loa citki, acunüng a saw k'um üng avang lam üng kya se khyang he naw ami leh, kha he naw ami ei. ");
INSERT INTO dao_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","“Mci avang lunga danaka khana kyaki a pyo law la mdek ä ngsüikia kyase ng’yawngei bäihki. ");
INSERT INTO dao_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Mci avang nghlinghmua kyaki, nghling naw pyo lawpüi lü a mthihin. ");
INSERT INTO dao_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Cunsepi, avang ngleihkdaw üng kyaki, pyo law lü, aphya a, vuipai lawki,” a ti. Acunüng, acun a pyen law päng üng, Jesuh naw, “Nami ngjaknak vaia nami nghnga a ve üng ngja ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Axüisaw he naw, “Hina msuimcäpnaka suilam hin i ni?” tia kthäh u se, ");
INSERT INTO dao_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesuh naw, “Nangmi cun Pamhnama khankhawa mawng ksingnak ning jah peta kyaki, cunsepi avanga veia msuimcäpnak am pyena kyaki, ‘Teng u se pi am hmu kcangki he, ngja u se pi am ksingki he.’ ");
INSERT INTO dao_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Msuimcäpnak cun hinkba kyaki; Mci cun Mhnama ngthua kyaki. ");
INSERT INTO dao_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Lam kpema kyaki he cun ngthu ngjaki he, am jumei u lü küikyana am ami kyanak vaia, khawyai naw law lü ami mlungmthin üngka ngthu cun a lawhei. ");
INSERT INTO dao_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Lunga khana kyaki he cun, ngthu ngja u lü jekyainak am dokhameiki hea kyaki, cunsepi ami pya am awmse, asäng jumki he te hlawhlepnak a pha law üng kyukngtängeiki he. ");
INSERT INTO dao_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Nghling hmua kyaki he cun, ngthu ngjaki he; cunsepi khawmdek cäicahnak, bawimangnak, hlimtuinak he naw jah bawngkha sak se am vüipai law thei u. ");
INSERT INTO dao_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Cunsepi, ngleih kdawa khana kyaki he cun, ngthu cun ngja u lü, ami mlung khyawnga ta u lü, mtheh ngjaknaka mlungmthin am ami ngtheipai vei cäpa biloki he. ");
INSERT INTO dao_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“U naw meiim mdäi lü kphya am am mük khawi u, ihnaka keha pi am thup khawi u, lutki avan naw akvai ami hmuh vaia, taknak ngkawi üng ta khawiki he. ");
INSERT INTO dao_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ipi ä ngphyeh khaia mjih ngphyeh law lü, ipi ä ngdang khaia thup ngdang law lü akvainaka law püia kya law khai. ");
INSERT INTO dao_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Acunakyase, ikba nami ngjak cäiei na ua; upi taki üng petsih u lü, upi am taki cun a takca a ngaih pi yuh pet vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesuh a nu la, a bena he a veia lawki he, khyang dämkia kyase a peia am pha u se, ");
INSERT INTO dao_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","“Na nu la na bena he ning hmu khaia bü u lü, kpunga ngdüi ve u,” tia ami mtheh. ");
INSERT INTO dao_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesuh naw, “Hina Pamhnama ngthu ngai u lü, kcang naki he hin, ka nu la ka bena he ni,” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Khaw mhmüp mat cun axüisaw he am mlawng üng ami awm üng Jesuh naw, “Lia, cayea, mi va pek vai u,” a ti. Acunüng citki he. ");
INSERT INTO dao_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ami ceh k'um üng Jesuh ipeiki; acunüng tuili üng khaw khi law sawxat lü, ami mlawng tui am be law se kyü u lü, khuikhaki he. ");
INSERT INTO dao_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Axüisaw he a veia citki he naw mtho u lü, “Saja aw, Saja aw, khyük law hlü ve üng” ami ti. Acunüng Jesuh naw tho law lü, khawkhi la tuiyüi jah jüi se, pyai lü ngdüm lawki. ");
INSERT INTO dao_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Acunüng Jesuh naw, “Nami jumnak hawia ni?” a ti. Acunsepi kyü u lü, cäicah lawki he naw, “Hin hin u ni? Khawkhi la tuiyüi naw pi ngthu jah pe se, ani ngaih?” tia ng’yüngkoki he. ");
INSERT INTO dao_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesuh la axüisaw he Kalile üngka naw tuili üng ngtäi u lü Kerasa khawa citki he. ");
INSERT INTO dao_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesuh ava kco la, khawyai naw khawvei a awmnak, suisak am suisaki, ima am awm lü ng’uhnün he cia awmkia khyang mat naw ana khyum. ");
INSERT INTO dao_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Acunüng, Jesuh a hmuh la, a maa kyu lü, angsanga, “Jesuh, ak'hlüng säih Mhnama Capa, ikba na na pawh hlüki ni? Ä na mkhuimkhaa, ning huina veng,” ti lü ngpyangki. ");
INSERT INTO dao_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Isetiakyaküng, Jesuh naw khawyai acuna khyang üngka naw cit khaia ngthu ana pet khawia phäha kyaki. Acuna khyang cun khawyai naw a man khawia kyaki; mthiyüi am a kutkhaw he jah pin u lü thawngim üng ami khyum üngpi ami pinpawknak he jah tipat lü mawkpyawnga dawng khaia khawyai naw a pawh khawia kyaki. ");
INSERT INTO dao_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesuh naw, “Na ngming u ni?” ti lü kthäh se, khawyai naw, “Ka ngming cun apä ni,” a ti, (isetiakyaküng, a k'uma khawyai khawjah a luha phäha kyaki). ");
INSERT INTO dao_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Acunüng, khui kthuknua am a jah tüih vaia ami nghuinak. ");
INSERT INTO dao_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Acunüng, mkyanga vawk khawjah ami jah mcaha k'uma ami luhnak vaia Jesuh nghuina u se, Jesuh naw a jah pet. ");
INSERT INTO dao_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Khawyai he khyanga khui üngka naw lut law u lü, vawka k'uma lut u se, vawk he kdanga dawng u lü, tui üng ngcumki he. ");
INSERT INTO dao_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vawksäm he naw ami hmu üng, dawng u lü, ngnamthe la loa ami va sang. ");
INSERT INTO dao_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Acunüng, ia akya, teng khai hea nghlawm u lü citki he, acuia Jesuha veia ami pha law üng, khawyai hea cehtak cun Jesuha khaw kunga suisa lü ngaikyunak akdaw am ngaw se ami hmu üng, aktäa kyüki he. ");
INSERT INTO dao_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Acun hmuki he naw anghnua lawki he üng acuan khyang ihawkba a yai be ami jah mtheh. ");
INSERT INTO dao_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Acunüng acuna khaw pipei üngka he ami van kyü law u lü, ami khaw üngka naw angxita a ktawih be vaia ami nghuinak. Acunüng, Jesuh mlawng üng lut lü cit beki. ");
INSERT INTO dao_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Khawyaia, a cehtaka khyang naw, Jesuh veia a ceh ngha vaia nghuina se, Jesuh naw, ");
INSERT INTO dao_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Na ima nghlat be lü, Pamhnam naw aktäa, i na hama a ning pawh pet jah va mtheha,” ti lü, a tüih be. Acunüng mlüh üng cit lü, Jesuh naw a hama a pawh peta a hlüngtaia mawng cun sang hüki. ");
INSERT INTO dao_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesuha tuili acayea a nghlat law be üng, khyang he naw ana ngängki he naw, aktäa ami na jekyainak. ");
INSERT INTO dao_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Acunüng, Sinakoka ngvai mat Jairuh naki lawki, Jesuha khaw kunga kawp lü, a ima cit khaia a nghuinak law. ");
INSERT INTO dao_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mat däng a canak nghnumica, kum xaleinghngih lawki, thi law hlü ngsaikia a kuna phäha kyaki. Acunüng Jesuh a ceh k'um üng khyang he naw ami kcung. ");
INSERT INTO dao_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Acunüng, nghnumi mat, kum xaleinghngih a thi putki, a ngui tak avan seibawi hea veia a ngsawieinak bäih, acunüng u naw pi am ami mdaw be thei, ");
INSERT INTO dao_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesuha hnua law lü, a suisak mdawngca hnet law se, acun la angxita a thi put ye beki. ");
INSERT INTO dao_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesuh naw, “U ni na hnetki?” a ti. Acunüng, “Kei ta am ni nawng,” ti u se, Pita naw, “Saja aw, khyang he naw ning kcung na u lü ning hnet ye u se” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Cunsepi, Jesuh naw, “U yaw naw ta na hnetki ni, johit ka khui üngka naw lut law se sim veng” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nghnumi naw, ä ngthup theiki ti ksing lü, a ngkhet maha law lü, Jesuha maa kawp lü, a hneta suilam la, a daw be ngxita mawng cun, khyang avana hmuha, a phyeh. ");
INSERT INTO dao_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesuh naw, “Ka canu aw, na jumnak naw ning dawsak be ve, dim'yenak am cita,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Acukba ana ngthuhei k'um üng, Sinakok ngvaia im üngka naw khyang mat law lü, “Saja ä kbawng kbaia, na canu thi päng ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Acun Jesuh naw a ngjak üng msang lü, “Ä cäia, a jum dänga mah juma, na canu daw be khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Acunüng, Jesuh ima law lü, Pita, Jakuk, Johan la, hnasena nu la pa dänga thea, upi im k'uma am a jah luhsak. ");
INSERT INTO dao_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ami van aktäa ana mbawikyap u se Jesuh naw jah hmu lü, “Ä kyap ua, hnasen am thiki ni, ipki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Acuna thi pängkia ksingki he naw ami yaihei. ");
INSERT INTO dao_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Cunsepi Jesuh naw nghnumica cun a kut üng manki naw, “Ka ca aw, tho law,” ti lü, a khü. ");
INSERT INTO dao_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Acunüng, a xünak naw kpan law be se, angxita tho law beki. Acunüng, Jesuh naw ei vai iyaw ami pet vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Acunüng, a nu la a pa aktäa cäi lawki xawi, Jesuh naw a bilawh u am pi am ani jah mtheh vaia a jah ksük. ");
INSERT INTO dao_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Acunüng Jesuh naw axüisaw he xaleinghngih atänga jah khü lü, khawyai he avan jah mkhütnaka johit la natnak he jah m'yainak be theinak jah pe lü, ");
INSERT INTO dao_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pamhnama khawa mawng sang hü khai he la, am phetki he jah m’yai be khai hea a jah tüih. ");
INSERT INTO dao_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Acunüng Jesuh naw, “Nami cehnaka ipi ä nami cehei vai, ksawngkhea pi kyase, kthäheinaka ngjaa pi kyase, eia pi kyase, nguia pi kyase, ä nami cehei vai, kcu nghngih ä nami cehei vai. ");
INSERT INTO dao_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Acunüng nami phanaka ima nami awm laih laih vai, acun üngka naw nami ktawih be vai. ");
INSERT INTO dao_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Am ning jah dokhamki cun, acuna mlüh üngka naw nami ktawih be üng, ami ngsingnak vaia nami khawpha üngka mvut nami khawk hüt vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Acunüng axüisaw he cun ktawih u lü, ngnam naküta cit hü u lü, thangkdaw sang hü u lü, hmün naküt üng ami jah m’yai hü be. ");
INSERT INTO dao_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Acunüng, Kalile uki Herod naw ahmäi ngja law lü aktäa cäi lawki; avang he naw, “Baptican Johan xüng law beki ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Avang naw, “Elijah ngdang lawki ni,” ti u se, avang he naw, “Ajana sahma mat mat xüng law beki he ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Acunüng, Herod naw, “Johan cun a lu ka xün päng ni, ahikba sena a mawng ka ngjak hin u ni?” a ti. Acunüng Herod naw Jesuh a hmuh vai aktäa ngjahlüki. ");
INSERT INTO dao_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Acunüng, ngsä he law be u lü, ami bilawh he Jesuh üng ami jah mtheh law. Acunüng, Jesuh naw jah ngkhahpüi lü Bethsaida mlüh ami tia, a jah cehpüi. ");
INSERT INTO dao_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Cunsepi, khyang he naw sim u lü, ami läk laih laih, acunüng Jesuh naw aktäa jah dokham lü, Pamhnama khawa mawng ngthu jah mtheki naw, m’yai be vai avan a jah m’yai be. ");
INSERT INTO dao_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Acunüng, nghngi kya law hlü se, xaleinghngih he Jesuha veia law u lü, “Khyang he mi peisu ngnam he la loea jah tüia, ngsutnak la ei vai hmuei khai hea, hina mäih khawkhyawng khawa mi awm ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Acunüng Jesuh naw jah msang lü, “Nangmi naw ami ei vai jah pe ua,” a ti. Acunüng axüisaw he naw, “Muk mhma la nga nglung nghngih ni kami tak. Hin he avana hama, ei vai kami va kheih vai ti aih lü? ami ti. ");
INSERT INTO dao_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kpami däng pi thawng mhma lawki hea kyaki. Acunüng Jesuh naw, axüisaw he üng, “Mhmakip cia, aphäh phäha jah ngawhsak u,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Acunüng acunkba ami van ami jah ngawhsak. ");
INSERT INTO dao_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesuh naw muk mhma la nga nglung nghngih lo lü, khankhawa hang mang lü, josenak am kbe lü, boki naw, khyang hea maa, ami tak vaia axüisaw he üng a jah pet. ");
INSERT INTO dao_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Acunüng, ami van naw ei u lü phü u se, ami ei mnawi cä xaleinghngiha ami kaw. ");
INSERT INTO dao_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Acunüng hinkba kyaki, Jesuh amät ktaiyü se, axüisaw he a veia lawki he, Jesuh naw, “Khyang he naw ua ni ami na ngaih,” ti lü a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Acunüng, axüisaw he naw, “Baptican Johana ning ngai ve u; cunsepi, avang naw, ‘Elijaha’ ning ngai ve u, avang naw, ‘Akphyüma sahma mat mat xüng law beki ni’ ti ve u,” tia ami msang. ");
INSERT INTO dao_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Acunüng Jesuh naw, “Acuna akyaküng, nangmi naw mä ua ni nami na ngaih,” a ti. Pita naw, “Nang cun Mhnama Mesijah ni” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Acunüng, upi acuna mawng ä ami mtheh vaia a jah ksük. ");
INSERT INTO dao_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Acunüng Jesuh naw, “Khyanga capa naw aktäa khuikhanak khamei khai, angvai he, ktaiyü ngvai he la thum ksing he naw ma khai he, hnima kya khai, amhmüp kthum üng tho law be khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Acunüng, ami vana veia, “Upi na läk law khai ngaiki naw amät ä ngaikyu lü, a kutlamktung amhmüp tä se kawt lü na läk law se. ");
INSERT INTO dao_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Upi a xünnak küikyanei khai büki naw mkhyüh lü, upi keia phäha, a xünnak mkhyühki naw küikyanei khai. ");
INSERT INTO dao_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Khyang naw khawmdek avan ka na lü, amät la amät pyeh se, am acunüng xükse, ia ni a ngmangnak kawm? ");
INSERT INTO dao_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Upi, kei la ka ngthu ngkekhyakei naki cun, khyanga Capa naw, a pa hlüngtainak, amäta hlüngtainak la khankhawngsä ngcim he am a law be üng, ngkekhyakei na be khai. ");
INSERT INTO dao_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Akcanga ka ning jah mthehki, hin üng ngdüiki he avang, Pamhnama khaw am ami hmuh hlana küt üng am thi khai he awmki he” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Acuna ngthu a pyen kän amhmüp khyet üng, Pita, Johan la Jakuk jah ngkhahpüi lü, ktaiyü khaia mcunga kaiki. ");
INSERT INTO dao_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","A ktaiyü k’um üng, a hmai hnga law lü, a suisak he a ktäa bawk law lü ngkah lawki. ");
INSERT INTO dao_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Acunüng, khyang nghngih Jesuh am ngthuheiki xawi, acun kxawi cun Mosi la Elijaha kyaki xawi, ");
INSERT INTO dao_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","khankhaw hlüngtai kyäpsawknak suiawi ni lü, Jerusalema a khuikhanak vaia mawng pyenki xawi. ");
INSERT INTO dao_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Acunüng, Pita la a püi he ipeiki he let law u lü, a hlüngtainak la a peia khyang nghngih ngdüiki xawi ami jah hmuh. ");
INSERT INTO dao_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Acun xawi naw Jesuh ani ktawih law hlü tak üng, Pita naw i a pyen ä ksingei lü Jesuh üng, “Saja aw, hia awm hin daw ve, na hama mat, Mosia hama mat, Elijaha hama mat samca kthum kami sa khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Acukba a pyen k’um üng khawngmei naw jah msungin law se, axüisaw he kyü lawki he. ");
INSERT INTO dao_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ngmei üng “Hin hin ka xüa ka Capa ni, a ngthu ngai u,” tia ngthu ngthang lawki. ");
INSERT INTO dao_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Acunüng, ngthu a ngdüm la, Jesuh amät däng ami hmuh. Axüisaw he cun am khikheh u lü, ami hmuha mawng cun, acuna pät üng u üng pi am mtheh u. ");
INSERT INTO dao_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A ngawi üng mcung üngka naw axüisaw kthum am kyum be u se, khyang khawjah naw ami na khyum. ");
INSERT INTO dao_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Acunüng, khyang hea ksunga khyang mat ngpyang lü, “Saja aw, amät däng ka canak ka capa teng law, ning hui na veng. ");
INSERT INTO dao_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","“Khawyai naw man khawi se, ngpyangin sawxat xatki, a mci mvawn pi kya law khaia pawh lü mdek üng a kyuk sak khawi, acunkba mkhuimkha lü am ceh hlü ta. ");
INSERT INTO dao_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","“Acunüng, na xüisaw he üng ami ktäm vaia jah nghui na ni se, amimi naw pi ani cun am ami ktäm thei,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesuh naw, “Jumnak am ta lü, üpnak am awmkia khyang he, nami veia ivei ka awm khai aw? Ivei ka ning jah msawk vai aw?” ti lü, acuna khyang üng, “Na ca hia lawpüia,” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Acunüng, hnasen a law k'um üng, khawyai naw khawmdek khana kyuk sak lü, aknaa a pawh. Cunsepi, Jesuh naw, khawyai kse jüi lü, anghmaw mdaw beki naw a pa üng a pet. ");
INSERT INTO dao_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Acunüng, khyang avan naw Pamhnama hlüngtainak cun aktäa kyühkhyai lawki he. Ami van naw acunkba, a bilawh he ami kyühkhyai law üng, Jesuh naw axüisaw he üng, ");
INSERT INTO dao_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ka ning jah mtheh hlü ä mhnih u; Khyanga Capa, khyang hea kut üng mansak vai ng'et law ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Cunsepi, a ngthu pyena suilam cun am ami ksing, ami ksing vaia mjiha kyaki, ami kthäh vaia pi ami kyüh. ");
INSERT INTO dao_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Acunüng, u kyäp säih khai tia amimät he ana ngcuh hü u se, ");
INSERT INTO dao_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesuh naw ami ngaikyunak jah ksing lü, hnasenca mat kai lü, a peia taki naw, ");
INSERT INTO dao_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Upi hina hnasenca, ka ngming üng dokhamki cun, kei na dokhamki ni, acunüng u pi, kei na dokhamki cun, kei na tüi lawki pi dokhamki ni. Nangmi üng jaw säihki, acun cen kyäp säih khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Acunüng Johan naw, “Saja aw, khyang mat naw na ngming am khawyai he jah ktäm se kami hmuh, keimi üngka am nikia kyase am a pawh ti vaia kami kpyai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Acunüng, Jesuh naw, “Ä kpyai ti ua, u pi nangmi am ning jah hnengki cun nami püia kyaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Acunüng, khankhawa a cehnak vai ng'et law se, Jerusalema a ceh vai lingki. ");
INSERT INTO dao_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ngsä he a ma a jah na tüih. Acunüng, ana dawng u lü, ana ngtün pe khai hea Samarih khaw mata lutki he. ");
INSERT INTO dao_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jerusalema cit khaia a büa phäha Samarih khyang he naw am a na dokham u. ");
INSERT INTO dao_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Acunüng, axüisaw xawi Johan la Jakuk naw acun ani ksing la, “Bawipa aw, hin he ami ngkhihnak bäih vaia, khankhawa mei han khü vaia na ngjahlüki aw?” tia ani kthäh. ");
INSERT INTO dao_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Acunüng, Jesuh naw ani veia nghlat law lü, a jah jüih. ");
INSERT INTO dao_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Acunüng ngnam kcea citki he. ");
INSERT INTO dao_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lam ami ceh k'um üng khyang mat naw, “Na cehnak avana ka ning läk khai,” ti lü Jesuh a mtheh, ");
INSERT INTO dao_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesuh naw, “Sauie naw khui ta u lü, kha he naw pi ngbu taki he, khyanga Capa naw ta a lu a khännak vai la a xüieinak vai pi am ta ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Acunüng, Jesuh naw khyang kcea veia, “Na läk lawa,” a ti. Cunsepi ani naw, “Bawipa aw, cit be lü ka pa va k'ut hüt ma vang,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Acunüng Jesuh naw, “Khyangkthi he naw amimät akthi k'utei u se; nang ta Pamhnama khawa mawng ngthu va sanga,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Akce naw pi, “Saja aw, ka ning läk law khai; cunsepi, ka im üngka he, ngthukdaw am jah va ngkhyahpüi ma vang,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Acunüng, Jesuh naw mtheh lü, “Upi, lai thawn khaia ngtün lü, a hnu lam tengki cun Pamhnama khaw am ä nghlawiki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Acunkäna, Jesuh naw akce khyühkip la nghngih jah mcawn lü, a cehnak vaia mlüh la hmun avana, a maa, nghngih ci a jah tüih. ");
INSERT INTO dao_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Acunüng Jesuh naw, “Cang ah vai khawjah awmki, cunsepi atki ngcek ve; acunakyase, cang at khai a jah tüih law vaia, cangmah kthäh u lü ktaiyü ua. ");
INSERT INTO dao_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Cit u; he hea ksunga to hea kba ka ning jah tüiki. ");
INSERT INTO dao_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Ngui ip, kthäheinaka ngja, khawdawke ä nami jah cehei vai, lama khyang ä nami hnukset vai. ");
INSERT INTO dao_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Nami luhnak im avana, akma säiha, ‘Hina im üng dim'yenak pha law se’ nami ti vai. ");
INSERT INTO dao_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","“Acuna im üng dim'yenak ngjahlüki a awm üng nami pyena dim'yenak acunüng ani üng awm khai, ngjahlüki am a ve üng nami hnuksetnak nami lakin be vai. ");
INSERT INTO dao_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Acuna im üng awm laih laih u lü, ami ning jah pet nami eiawk vai; khüiki cun ngkheng khawiki ni. Im avan üng ä nami kai hü vai. ");
INSERT INTO dao_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nami luhnaka mlüh avan üng ami ning jah pet nami ei vai, ");
INSERT INTO dao_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","“Ami mlüha am phetki he nami jah m’yai be vai, ami veia, ‘Pamhnama khaw naw ning jah k'et law ve’ nami ti vai. ");
INSERT INTO dao_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Mlüh nami luhnaka am ami ning jah cäinak üng, ami lam üng cit hü u lü, ");
INSERT INTO dao_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nami mlüh üngka mvut, kami khawpha üng kawpki pi nami khana kami khawki; cunsepi Pamhnama khaw naw ning jah k’et law ve’ nami ti vai. ");
INSERT INTO dao_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Ka ning jah mthehki, ngthumkhyanaka mhmüp üng, Pamhnam naw acuna mlüha kthaka Sodom mlüh m'yenei bawk khai. ");
INSERT INTO dao_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korazin mlüh aw, na jo se ve! Bethsaida mlüh aw, na jo se ve! Nangmi üng mdana kba müncankse he Turah la Sidon mlüha mdan vai sü ta, ajan denga jihkpyawn sui ni lü, mvut üng ngaw ni lü, ngjut päng khai sü xawi. ");
INSERT INTO dao_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Cunsepi, ngthumkhyanaka mhmüp üng Pamhnam naw nanga kthaka ta Turah la Sidon mlüh jah m'yenei hlü bawk ve. ");
INSERT INTO dao_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Nang Kapenawm mlüh, khankhaw däa mhlünmtaia kya lü pi, mulai mei däa ning khyaka na kya khai” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesuh naw, “Upi, nami ngthu ngaiki cun, keia ngthu ngaikia kyaki; upi nami ngthu ä ngaiki cun keia ngthu ä ngaikia kyaki ni; upi keia ngthu ä ngaiki cun kei na tüi lawkia ngthu ä ngaikia kyaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Acunüng, khyühkip la nghngihe jekyainak am nghlat law be u lü, “Bawipa aw, na ngming am khawyai he kami jah ksäta kba awmki he,” ti u se, ");
INSERT INTO dao_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesuh naw, “Khawyam mkeka kba khankhaw üngka naw kya law se ka hmuh. ");
INSERT INTO dao_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“Ngai u, kphyukse he, jawngk’ai hea khana ngleheinak la, ye he jah nängnaka khyaihnak ka ning jah peki, i naw am ning jah lembawisak khai. ");
INSERT INTO dao_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Cunsepi khawyai he nami ti tia ami awma phäha ä jekyai ua; khankhawa nami ngming he angyuka phäha jekyai ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Acunüng, Jesuh Ngmüimkhya Ngcim üng jekyainak am be lü, “Mce la khankhaw Bawipa, ka Pa aw! khyang ktheme la ngtheingthangki hea veia hina ngthu mjih lü, ä ngtheingthangki hea veia na ngdangsaka phäha ning jekyai na veng; ka Pa aw, acun cun na ngaiha dawki ni. ");
INSERT INTO dao_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ka Pa naw ahmäi na pe pängki. Capa u ni ti cun Pa dänga thea u naw am ksing; Pa u ni ti cun Capa la Capa naw a xüa khyang hea thea u naw am ksing thei u,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Acunüng, Jesuh axüisaw hea veia nghlat lü, anghmüa, “Atuh hmuh vai he nami jah hmuki he nami jo sen ve; ");
INSERT INTO dao_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","“Ka ning jah mthehki, sahma khawjah la, sangpuxang khawjah naw, nami jah hmuh la nami jah ngjak he, hmu hlü u lü ngja hlü kyawki he, am hmu u lü am ngja hlawt u,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Acunüng, thumksing mat naw Jesuh a mhnüteinak am, “Saja aw, anglät xünnak ka yahnak vaia i ni ka pawh kawm?” ti se, ");
INSERT INTO dao_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesuh naw, “Cangcim üng i ng’yu se, ihawkba na ksingki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ani naw, “Bawipa na Pamhnam cun na mlungmthin avan, na xünnak avan, na kyannak avan la, na ngaikyunak avan am na jawngnak vai, acunüng na impeiloceng namäta kba na jawngnak vai’ tia awmki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Acunüng Jesuh naw, “Msang thei veki, acunkba va pawha, na xüng khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Acunüng, acuna khyang naw ngnäng khaia bü lü, Jesuh üng, “Acunüng ka impeiloceng he ta u he ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesuh naw msang lü, “Khyang mat Jerusalem üngka naw Jerikhoa ju cit khai sü, khyang m'yuk’eie jah sawngei msawk se, acun he naw a suisak jah suh pe u lü, thi khyo khaia kpaiki he naw ami ceh tak. ");
INSERT INTO dao_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Acunüng, ktaiyü mat, acuna lam bä üng citki naw, a hmuh la lam kpema ngpeng lü a ceh tak. ");
INSERT INTO dao_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Acukba bäa, Levih khyang mat pi acuna hmun pha law lü, a hmuh la lam kpema ngpeng lü citeiki. ");
INSERT INTO dao_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Cunsepi, Samarih khyang mat a kdungnak lama, acuna awmnak pha law hngaki naw, a hmuh la m'yenei leng leng lü, ");
INSERT INTO dao_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","a veia va cit lü, a nghma üng situi la capyitui am jah bui lü, hlawpki naw, amäta sangnghngaksaü üng taih lü, khin ima cehpüiki naw, a msümcei. ");
INSERT INTO dao_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“A ngawi üng, denarih tangka nghngih, khin im ngängki üng pe hüt lü, ‘Ana msümceia, hina thea pi na bäihnak, avan pi ka nghlat law be üng ning thung be kawng’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Acuna kthum he üng m'yuk’eie jah sawngeikia khyanga khana impei locenga kba biloki cun ua ni na ngaih?” ti se, ");
INSERT INTO dao_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Thumksing naw, “M'yeneinak taki cen” a ti. Acunüng Jesuh naw, “Nang pi acunkba va pawha,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Acunüng, Jesuh la axüisaw he ami ceh lama ngnam mat üng lut u se, acuia a ngming Matah naki naw a na khinak. ");
INSERT INTO dao_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Acuna, nghnumia hnunpüi Marih naki nghnumica mat awmki. Acuna nghnumica cun Jesuha khaw kunga ngthu ngai lü ngawki. ");
INSERT INTO dao_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Acunüng, Matah cun khüi lü am ngbüneiki, Jesuha veia law lü, “Bawipa aw, ka na naw ka mät däng ka khüi khaia ana yawkin hin na dawsaki aw? Na kpüi law khaia mtheha,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Acunüng Jesuh naw, “Matah, Matah, aktäa ngaikyu lü bawngbai veki; ");
INSERT INTO dao_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","“Cunsepi, aktung mat däng awmki. Marih naw akdaw xüei ve, acun cun u naw pi yuhei hlawt vaia am kya ve,” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mhmüp mat üng Jesuh ktaiyü se, a ktaiyü khap üng axüisaw mat naw, “Bawipa aw, Johan naw ktaiyünak axüisaw he üng a jah mtheia kba jah mtheia,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Acunüng Jesuh naw, “Nami ktaiyü üng hinkba ti ua, ‘Kami Pa, Na ngming ngcim leisawngnak am ve se. Na khaw pha law se. ");
INSERT INTO dao_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amhmüp tä kami ei khyawh buh jah pe. ");
INSERT INTO dao_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jah katnaki kami mhlät khawia kba, nang naw pi kami katnak he jah mhläta. Hlawhlepnaka am jah cehsak kaw pi,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Acunüng Jesuh naw, “Nangmi üng mat naw, mthan nglunga a püia veia cit lü, ‘Ka püi aw, muk kthum na kpu lawa; ");
INSERT INTO dao_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ka khin law ve, mbei vai i am ta veng’ a ti üng; ");
INSERT INTO dao_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","im k'um üngka naw, ‘Ä na kpyaneia; ksaw khai päng veng, ka ca he pi ihnak üng ip päng ve u; tho law lü am ning pe law hlü thei veng’ ti lü, a msang te, ");
INSERT INTO dao_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka ning jah mthehki, a püia akya aphäha, tho law lü am ava pete, ä khyakei lü a kthähei nua phäha tho law lü, a ngaih jah pe khai. ");
INSERT INTO dao_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Acunakyase, ka ning jah mthehki, kthäh ua, acunüng nami yah khai; sui ua, acunüng nami hmu khai; khawk ua, acunüng ksawh ning jah mhmawn pe khai he. ");
INSERT INTO dao_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","“Upi, kthähki avan naw yah khawiki, upi suiki naw hmu khawiki, upi khawki am ksawh mhmawn pe khai he. ");
INSERT INTO dao_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nangmi üngka pa, a ca naw muk kthäh se, u naw lung pe khai aw? Nga kthäh se, u naw ngaa nghnün üng kphyu pe khai aw? ");
INSERT INTO dao_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","“Acunüng aiktui kthäh se, u naw jawngk’ai pe khai aw? ");
INSERT INTO dao_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","“Nangmi khyang kse he naw pi nami ca üng akdaw pet vai nami ksing üng, nami Pa khankhawa ka naw, kthähki avan üng Ngmüimkhya Ngcim aktäa pe hlü ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Acunüng, Jesuh naw khawyai am ngthuhei theiki mat a ktäm. Acunüng khawyai a kco law la ä ngthuhei theikia khyang cun ngthuhei law be thei se khyang he aktäa cäicah lawki he. ");
INSERT INTO dao_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Khyang avang he naw, “Khawyai mkhawng Beelzebula johit am ni khawyai he a jah ktäm,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Avang naw ami mhnüteinaka, khan üngka ti ksingnak vai müncankse kthähki he. ");
INSERT INTO dao_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Acunüng, Jesuh naw ami ngaihkyunak jah ksing lü, “Ia pung pi amimät ngcawhki he cun pyeh khawiki he ni; khuiim mat üngka he pi amimät ngcawhki he cun khyük khawiki he ni. ");
INSERT INTO dao_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Khawyama khaw pi amimät ami ngtuk üng ihawkba a khaw khäng khai ni? Beelzebula a peta johit am khawyai he jah ksätki nami tiki ni. ");
INSERT INTO dao_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Acukba ka jah ksätkia akya üng, ihawkba nami hnukläk he naw khawyai jah ksätkie ni? Nami mäta hnukläk he naw nami hleinak mdan ve u. ");
INSERT INTO dao_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“Cunsepi, kei naw Pamhnama johit am khawyai he jah ktäm khawikia ka kya üng, Pamhnama khaw nami veia pha law pängki. ");
INSERT INTO dao_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Khyang kyan naw likcim kpawmei lü a im a ngänga küt üng, a khawhthem mä lü awm khawiki; ");
INSERT INTO dao_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","“Cunsepi amäta kyan bawki naw tu law lü, a näng law üng, a üpnaka likcim he jah yut lü, a khawhthem lo lü, jah yet hü khai. ");
INSERT INTO dao_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Acunakyase, upi ka hlawnga am awmki cun, ka yea kyaki; upi am na mkhämpüiki cun kthehkia kyaki. ");
INSERT INTO dao_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Acunüng, khawyai khyanga k'um üngka naw a luh law üng, a xüieinak vai sui hü lü, tuia am a awmnak hnünea ngvak hü khawiki; acunüng, xüieinak vai am hmu lü, ‘Ka luh lawnaka ima nghlat be vang’ ti lü, ");
INSERT INTO dao_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ava pha be üng ana phekphaih u lü a na dawkya sak u se a hmuh. ");
INSERT INTO dao_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","“Acun la va cit be lü, amäta pi se bawki khawyai kce khyüh jah lawpüi se, acunüng lut u lü awmki he, acuna khyanga awm law vai cun akma a na awm khawia pi ksehlen bawki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Acukba ngthu ana pyen k'um üng, khyang hea ksunga nghnumi mat ngpyang law lü, a veia, “Ning pawi nakia pum la ning tukia cih ta a jo sen ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Acunüng Jesuh naw, “Acuna kthaka ta, Pamhnama ngthu ngai lü acuna kba awmki he, ami jo sen bawk ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Acunüng, khyang he a veia ami ngbum law üng, Jesuh naw, “Atuh ngsawn he hin se ve u; müncankse suiki he, cunsepi, Jonaha müncankse dänga thea msingnak ä jah pet vai. ");
INSERT INTO dao_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","“Jonah Ninevih khyang hea msingnaka a kyaa kba, khyanga Capa pi atuh khyang hea hama msingnaka kya khai. ");
INSERT INTO dao_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Sheba sangpuxangnu, Solamona themnak ngaiei khaia athuknak üngka naw lawkia kyase, ngthumkhyanaka mhmüp üng, atuh ngsawn hea veia tho law ha lü jah mkat law khai. Ngai u Solamona kthaka kyäp bawki hia awm ve. ");
INSERT INTO dao_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Ninevih khyang he, Jonaha ngthu pyena phäha ngjutki hea kyase, ngthumkhyanaka mhmüp üng, atuh ngsawn hea veia ngdüi law hnga u lü, jah mkat law khai he; ngai u, Jonaha kthaka kyäp bawki hia awm ve. ");
INSERT INTO dao_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“U naw meiim mdäi lü am thup khawi u, cäa k'umapi am thup khawi u, lutki he naw ami hmuh vaia angdangnak üng ni ami tak khawi. ");
INSERT INTO dao_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Pumsa meiim cun mika kyaki. Acunakyase na mik avai üng na pumsa avan vai bäihki. Cunsepi, na mik a pyeh üng na pumsa avan nghmüpki. ");
INSERT INTO dao_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Acunakyase, akvai nami k'uma awmki, am a nghmüp vaia cäi na u. ");
INSERT INTO dao_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","“Acunüng na pumsa ä nghmüp lü avan a vai üng, meiim naw aktäa a kcäiha kba, na pumsa vai bäih khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesuh ana ngthuhei k'um üng Pharise mat naw buh ei khaia khü se cit lü buh eiki. ");
INSERT INTO dao_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Acunüng a kut am mthih lü buh ei se a hmuh üng, Pharise aktäa cäiki. ");
INSERT INTO dao_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Acunüng Bawipa naw, “Nangmi Pharise he khawt la kbe akpung lama nami mthi khawiki; cunsepi nami mlungmthin k'uma setnak la katnak am nami beki. ");
INSERT INTO dao_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“Khyang k'ang he aw! Akpung pi pyang lü ak’um pi pyangki cun Pamhnam am niki aw? ");
INSERT INTO dao_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","“Acunakyase, nami khawt la nami kbe üng awmki m'yenkseki he üng jah pe ua. Acunüng, ahmäi nami hama ngcim hei law khai ni. ");
INSERT INTO dao_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nangmi Pharise he, nami jo se ve! Kcingyüt paibänge la khuhlip kce he pi xa üng mat pet vaia nami khüiki. Cunsepi, hmankanak la Pamhnam jawng'engnak am nami cäi naki. Ahin he va jah pawh ma u lü akce he pi nami jah pawh vai sü. ");
INSERT INTO dao_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nangmi Pharise he nami jo se ve, Sinakoka ngawhnak akdaw säih la jawihtuknaka nghnukset kyu nami jawng naki. ");
INSERT INTO dao_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Nami jo se ve, ng’uhnün tia ä ngsing se, khyang he naw ä ksing u lü, a khana ami ceh hünak am nami tängki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Acunüng, thum ksingki mat naw, “Saja aw, hina ngthu na pyen hin keimi pi na jah ksenaki ni” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Acunüng Jesuh naw, “Thumksing he aw, nangmi pi nami jo se ve! Phüi kse khyanga khana nami mtaihki, namimät naw nami kutmdawng am pi am nami hnet hlüki. ");
INSERT INTO dao_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nami jo se ve! nami pupa he naw ami hnim, sahma hea mkhya im nami saki. ");
INSERT INTO dao_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","“Acunakyase, nami pupa hea ami bilawh cun jah ksingpüi u lü, nami jah ngaisimpüiki ni; amimi naw hnim u se, nangmi naw ami mkhya ime nami jah saki. ");
INSERT INTO dao_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Acunakyase, Pamhnama ksingnak naw pi pyen lü, ‘Sahma he la ngsä he jah tüih pe ni se, avang jah mkhuimkha u lü, jah hnim khai he,’ ");
INSERT INTO dao_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","acunakyase, khawmdeka ngtüi üng tün lü, ngsawikia sahma hea thisen, ");
INSERT INTO dao_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abela thisen üngka naw tün lü, Temple la kphyawnkunga nglaka ami hnim Zakhariha thisen naw hina ngsawn hea phu jah kthäh be khai. Ä, akcanga ka ning jah mthehki, acun naw hina ngsawn hea phu jah kthäh be khai. ");
INSERT INTO dao_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Thumksing he, ksingnaka imksawh mhmawnak tawh nami thupkia kyase nami jo se ve. Namimät pi am lut u lü lut hlüki he pi nami jah mkhyawhki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesuh naw acuna hmün a cehtak üng thumksing he la Pharise he naw ami mkateinak vaia, ");
INSERT INTO dao_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","a pyen law msawk ami man hlüa phäha, ngäng u lü ang'enga ahmäi hmäi ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Khyang kdäm he ngleh kyu u lü, ami ngbum law üng, Jesuh naw, axüisaw he üng, “Pharise hea nghen cäei na ua. ");
INSERT INTO dao_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Ä ngdang khaia thup avan ngdang lü, ä ngsing khaia mjih avan ngphyeh khai. ");
INSERT INTO dao_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","“Acunakyase, nghmüp üng nami pyen avan avainaka ngjaka kya khai; asithawta nami pyen avan im khana sang khai he. ");
INSERT INTO dao_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ka püi he aw, ning jah mtheh veng, ‘Pumsa hnim lü, acun käna akce i am pawh theiki he ä jah kyüh ua. ");
INSERT INTO dao_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","“Cunsepi, nami kyüh vai ta; Aning jah hnim päng üng, mulai mei üng ning jah tawn thei khai Mhnam kyüh ua. Ka ning jah mthehki ani cen kyüh ua. ");
INSERT INTO dao_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Khaca mhma peni tangka nghngiha am jawi khawiki he aw? Acuna khaca matca pi Pamhnam naw am mhnih khawi naw. ");
INSERT INTO dao_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","“Nami lusam pi täh bäiha kyaki. Khaca khawjaha pi nami küi bawki ni, am kyü ua. ");
INSERT INTO dao_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Acunüng ka ning jah mtheki, khyang hea maa na yungki cun, Pamhnama khankhawngsä hea maa, khyanga Capa naw yung hnga khai. ");
INSERT INTO dao_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","“Cunsepi, khyang hea ma na maki cun, Pamhnama Capa naw Mhnama khankhawngsä hea hmaia ma khai. ");
INSERT INTO dao_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Acunüng, khyanga Capa pyetseki avan cun, ami pyetsenak mhläta kya khai; cunsepi, Ngmüimkhya Ngcim pyetseki cun, mhläta am kya. ");
INSERT INTO dao_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Acunüng Sinakok he, bawi he la khaw uki hea veia ami ning jah cehpüi üng ‘ikba ka jah msang khai, i ka pyen khai,’ tia ä nami cäi vai, ");
INSERT INTO dao_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","acuna kcün üng nami pyen vai cun Ngmüimkhya Ngcim naw ning jah mthehei law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Acunüng, khyang hea ksunga mat naw Jesuh üng, “Saja aw, ka hnunpüi he naw khawh ami na ngpaipüi vaia jah mtheha,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Acunüng Jesuh naw, “Nghngicim nangmia khana u naw ngthumkhya khai la khawh yet khaia ana mcawn ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Acunüng ami veia, “Cäiei u lü, mnaiheinak avan üng ngxungei kyu u; ihlawka bawimang u lü pi bawimangnak üng nami xünak am ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Acunüng, Jesuh naw ami veia msuimcäpnak pyen lü, “Bawimangki mat, a khaw daw se, eiawk da na leng lengki naw, ");
INSERT INTO dao_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ngaikyu lü, ‘Hawkba ni ka ti kawm? Eiawk taknak vai am ta veng’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Acunüng, ‘Hikba pawh vang; ka khei he jah phye lü, angbaü bawka sa lü, acunüng eiawk he la, ka khawhthem he ka jah ta khai. ");
INSERT INTO dao_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Acunüng ka ngmüimkhya üng, ‘Ka ngmüimkhya aw, khawkum khawvei khäk khai khawhthem na taki ni; xüiei lü, ei lü aw lü, hlimtui lü awma, ka ti khai,’ tia ngai kyuki. ");
INSERT INTO dao_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Cunsepi, Pamhnam naw, ‘Khyang k'ang aw, tuhngawi mthan na ngmüimkhya khyük khaia kyaki; acunakyase, na mcuneia khawhthem u naw ka na khai aw?’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Amäta hama khawhthem mcun lü, Pamhnam üng am bawimangki he cun, acuna mäih lawki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Acunüng, Jesuh naw axüisaw he üng, “Acunakyase, ka ning jah mtheki, ‘I ka ei khai?’ tia, nami xünnak vai ja, ‘I ka suisa khai?’ tia, nami pumsa phäha nami mlung ä bawngbai sak ua. ");
INSERT INTO dao_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","“Eia kthaka ta xünnak kyäp bawki ni, suisaka kthaka ta pumsa kyäp bawki ni. ");
INSERT INTO dao_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Vangak he jah ngai u, cang am saw u, am at u, mcunnak am ta u, khei am ta u; cunsepi, Pamhnam naw jah mcahki, nangmi cun kha hea kthaka ta nami küi bawki ni. ");
INSERT INTO dao_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Nangmi üng u naw a mlung bawngkhasak lü a xünnak msaüei thei khai ni? ");
INSERT INTO dao_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Ahinca he pi am jah pawh thei u lü, ivaia akcea phäha nami mlung nami bawngkha saki ni? ");
INSERT INTO dao_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lili kheipai he cen jah teng ua; khut am pawh u, nghmüi pi am bi u; cunsepi ka ning jah mthehki, Solamon pi a hlüngtainak avan am ngcüngceiei se, hina lili kheipai matca pi am tängeipüi khai ni. ");
INSERT INTO dao_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“Acunakyase, atuh xüng se, angawia mei üng tawnena khuhlip pi Pamhnam naw a thuihawi sak üng, nangmi cun acuna kthaka pi am ning jah thüihawi sak bawk khai aw. Ihlawka nami jumnak ngceki ni! ");
INSERT INTO dao_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Acunakyase, nami ei vai la nami awk vai ä sui ua; ä cäicing ua. ");
INSERT INTO dao_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","“Am jumeiki he naw acuna ngkhaw avan cun sui khawiki he ni; acun nami hlüki ti nami Pa naw ksingki ni. ");
INSERT INTO dao_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","“Akcüka Pamhnama khaw sui u, acun käna acun he avan ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ka hnukläk toca he aw, ä kyü ua; nami Pa naw khaw aning jah pet vai ngjahlüki ni. ");
INSERT INTO dao_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Nami ka avan jah jawitu u lü, m'yenkseki he üng jah pe ua; nami mäta suiawi la nami khawhthem ä sui u lü m’yuk’ei naw am a m’yuk thei kca naw pi am a kpyeh thei khankhaw bawimangnak sui ua. ");
INSERT INTO dao_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Isetiakyaküng, nami khawhthema awmka nami mlung awm theikia kyaki. ");
INSERT INTO dao_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ahmäi apha law üngka vaia ngsuingsa u lü, a na ngcüngcei u lü, nami meiim mdäiei u; ");
INSERT INTO dao_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","“M'ya he naw ami mahpa cambumnak pawi üngka naw law be lü ksaw a khawk law üng ksawh mhmawn ngxit khaia ami na k’äiha kba a na ve ua. ");
INSERT INTO dao_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","“Ami mahpa a law be üng, a na ngäng u se a jah hmuh lawa m'ya he cun ihlawka jekyai khai he ni; akcanga ka ning jah mthehki, a mahpa cun a khyü vawpei lü, buh ei khai hea jah ngawhsak lü, amät naw jah ngäng law khai. ");
INSERT INTO dao_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“Mthan lunga pi kyase, acun käna pi kyase, ami mahpa naw law lü, acunkba a jah hmuh lawa m'ya he ta, ami jo sen ve. ");
INSERT INTO dao_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Cunsepi, hin hin ksing ua, m'yük'eia law vai imah naw a ksing vai sü ta, a im am a phyet vaia ngäng khai sü. ");
INSERT INTO dao_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","“Acunakyase, nangmi pi ana ngtünei u lü awm u, am nami simeia kcün üng khyanga Capa law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Acunüng Pita naw, “Bawipa aw, hina msuimcäpnak hin, keimi däng üng aw na jah mtheh? Akce hea hama pi kyaki aw? ti se, ");
INSERT INTO dao_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bawipa naw, “Khawhthem mceiki, üpnak cang, ngsüm kcangki, a mahpa naw akha law üng ami ei vai pawh khaia, mkhawnga a mcawn vai ta, u ni? ");
INSERT INTO dao_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","“A mahpa naw, a law be üng, acunkba ana pawh se a hmuh lawa m'ya ta ihlawka jekyai khai ni. ");
INSERT INTO dao_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Akcanga ka ning jah mthehki, ani üng a tak avana khana mkhawnga mcawn law khai. ");
INSERT INTO dao_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Cunsepi, acuna m'ya naw a mlung k'uma, ‘Ka mahpa am law be ng’xit khai’ ti lü, m'yanu, m'yapa he jah na kpai lü, a na ei aw ktat lü, a na awm k'um üng, ");
INSERT INTO dao_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","am a na sümei, am a na ksingeia mhmüp üng a mahpa law be lü, acuna m'ya cun amcäm cäma khyüng lü pyen ä ngjakia hlawnga atänga jah ta hmaih khai. ");
INSERT INTO dao_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“M'ya, a mahpa a ngaih ksing mah mah lü, a mahpaa ngaiha pi am a na pawhmsahki cun, khawveia kpai khai he. ");
INSERT INTO dao_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Cunsepi, a mahpaa ngaih am bilo lü kpaihnak vaia iyaw bilo msawkia m'ya cun ajaw dänga kpai khai he. Upi, akdäm ami peta veia akdäm kthäh be khai he; Upi, akdäm bawk ami peta veia akdäm bawk kthäh be khai he. ");
INSERT INTO dao_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Khawmdek khana mei däi sak khaia ka lawki, atuh pi acutei vai ngja hlü veng! ");
INSERT INTO dao_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“Cunsepi, baptican mat ka khan vai awm ve, acuna baptican am ka khan hlan üng ka mlung aktäa khuikha ve! ");
INSERT INTO dao_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Khawmdek khana ng'yäpnak lawpüi khaia ka lawkia nami ngaiki aw? Acukba vaia am law nawng. Ngpainak lawpüi khaia ni ka law ve. ");
INSERT INTO dao_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Atuh käna, im mat üng mhma ngpai khai he, kthum naw nghngih hneng law khai, nghngih naw kthum hneng law khai. ");
INSERT INTO dao_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“Pae naw capa he jah hneng law u se, capa he naw pa he jah hneng law khai he; ami nu he naw ami canu he jah hneng law u se, ami canu he naw ami nu he jah hneng law khai he; ami ni he naw ami pai he jah hneng law u se, ami pai he naw ami ni he jah hneng law khai he,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Acunüng Jesuh naw, khyang hea veia, “Khawnghngi kyak lama khawngmei ngjing se nami hmuh üng, ‘khaw a hlü ve’ ti u lü, nami tia kba kya law khawiki. ");
INSERT INTO dao_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","“Acunüng, cum khawkhi nami ksing üng, ‘khaw ngling hlü ve’ ti u lü, nami tia kba kya law khawiki. ");
INSERT INTO dao_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“Nangmi Hypocrit he naw, khawmdek la khankhawa ngtünawngnak pi nami ksingki naw, ise atuha kcün hin am nami ksing theiki ni? ");
INSERT INTO dao_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ise angtäia pawh vaia cun namimät naw pi am nami mtaiei theiki ni? ");
INSERT INTO dao_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Acunüng, ning hnengki am ngthumkhyakia veia nani ceh hmai üng, nani ceh lama nani ng’yäpnak vai na sui vai; am acunüng ta ngthumkhyakia veia ning cehpüi se, ngthumkhyaki naw khyang manki am ning man sak se, khyang manki naw thawngim üng ning khyüm khai ni. ");
INSERT INTO dao_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","“Ka pyenki, pet vaia ngui am na peta küt üng thawngim üngka naw am na lät khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Acunüng, Kalile khaw khyang he ngkengnak ami pawh k'um üng Pilat naw a jah hnima mawng Jesuh üng ami mtheh. ");
INSERT INTO dao_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Acunüng Jesuh naw, “Acuna Kalile khyang he, acunkba ami khuikha phäha, akce Kalile khyang hea kthaka mkhyekat bawki hea nami ngaiki aw? ");
INSERT INTO dao_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Akcanga ka ning jah mthehki, acunkba am kya; nangmi pi am nami ngjut üng acunkba nami thi hnga khai. ");
INSERT INTO dao_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Am acunüng khyang xaleikhyet Silawng im ksaü naw jah kyuk si se thiki he cen, Jerusalema awmki hea kthaka mkhyekat pawki hea nami ngaiki aw? ");
INSERT INTO dao_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","“Akcanga ka ning jah mthehki, acunkba am kya; nangmi pi am nami ngjut üng acunkba nami thi hnga khai” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Acunüng, Jesuh naw msuimcäpnak pyen lü, “Khyang mat naw capyit a ngvawng k'uma a ngling mat awmki, law lü a ktheih a sui law üng a ngtheih mat hman pi am a hmuh. ");
INSERT INTO dao_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“Acunüng, ngvawng kbi üng, Tenga, law lü a ktheih ka sui lawnak khawkum kthum law pängki, a ktheih matca pi am hmu veng. Khyua! ivai amdanga khawmdek kyawh lü awmki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Acunüng, ngvawng kbi naw, ‘Ka mahpa aw, tuhmü kum ahikba awm tang se, a phung co lü, sea ek am mcah kawng; ");
INSERT INTO dao_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","‘Seng kum a ngthei üng aktäa daw lü, am a ngtei üng khyu kaw pi” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Acunüng, Jesuh naw Sinakoka k’uma Sabbath mhmüp üng a jah mthei. ");
INSERT INTO dao_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Acunüng kum xaleikhyet ngmüimkhya kse naw awm na se khuikha lü ngkunki, amät angdünga am ngdüiei thei süm sümki nghnumi mat awmki. ");
INSERT INTO dao_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Acunüng, Jesuh naw a hmuh la khü lü, “Nghnumi aw, am na yainak üngka naw lät veki” ti lü, ");
INSERT INTO dao_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","a khana a kut taih se, acun la angxita ngdüng law lü, Pamhnam mküimtoki. ");
INSERT INTO dao_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Acunüng, Jesuh naw Sabbath mhmüp üng khyang a mdaw bea phäha Sinakok ngvai a mlung so lawki naw, khyang he jah mtheh lü, “nghngicim khüihnak vai mhmüp khyuk awmki, acunüng law u lü ngmangei law kyusak ua, Sabbath mhmüp üng ä law ua” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Acunüng, Bawipa naw msang lü, “Nangmi Hypocrit he, Sabbath mhmüp üng nami se, nami sanghngaksaü sut u lü, tui aw khaia am nami cehpüi khawikia kya aih se? ");
INSERT INTO dao_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","“Hina nghnumi hin Abrahama canua kyaki, teng u, khawyam naw kum xaleikhyet a manei Sabbath mhmüp üng ä lät sak vai aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Acunüng, acunkba pyen se hnengkie ami van ami hmai seki; acunüng, khyang he ami van Jesuh naw hlüngtai kyäpsawknak a pawha phäha jekyaiki he. ");
INSERT INTO dao_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Acunüng Jesuh naw, “Pamhnama khaw cun i mäih ni a law? I am ni ka msümcäp kawm? ");
INSERT INTO dao_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anca ui mat, khyang naw lo lü a ngvawng k'uma a phu am tängki ni; acun cun cawt law lü, thinga kya law se, kha he naw angban üng ami ngbu ami pawhnak am tängki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Acunüng Jesuh naw, “Pamhnama khaw cun i am ni ka msuimcäp kawm?” ti be lü, ");
INSERT INTO dao_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","“Pamhnama khaw cun, nghnumi naw nghngen lo lü, khai tawng kthum üng thun se, khai avan thawh sakia nghngnen am tängki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Acunüng, Jesuh cun mlüh he la ngnam he üng jah hei mthei vü lü, Jerusalem khawa citki. ");
INSERT INTO dao_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Acunüng, khyang mat naw Jesuh üng, “Saja aw, akjaw däng japaw küikyana ami kya kawm?” ti se, Jesuh naw, ");
INSERT INTO dao_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mkawt ngcek üng nami luh vaia ktha na ua; ka ning jah mthehki, khyang khawjah lut khaia ngtün u sepi, am lut thei khai he. ");
INSERT INTO dao_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Imah tho law lü, ksaw a khai käna nangmi kpunga ngdüiki he naw, ‘Bawipa aw, ksawh jah mhmawna’ tia ksawh nami khawk law üng, ani naw, ‘nangmi hawia ka he, am ning jah ksing khawi nawng? ti lü ning jah msang khai. ");
INSERT INTO dao_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Acunüng nangmi naw, ‘Mi ei aw hmaih khawiki, kami khawloa pi na jah mthei hü khawiki ni’ nami ti law khai. ");
INSERT INTO dao_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Acunüng ani naw, ‘Ka ning jah mthehki, nangmi hawia ka he am ning jah ksing khawi nawng, nangmi khyang kse he, ka vei üngka naw cit ua’ ti law khai. ");
INSERT INTO dao_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Abraham, Isak, Jakop la sahma he avan Pamhnama khaw k’uma awm u se jah hmu u lü, nangmi ngpunga ning jah ktäm ti, nami ksing law üng, acunüng, nami mnicui ha kyet u lü nami kyap khai. ");
INSERT INTO dao_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","“Acunüng, nghngilaw lam la nghngikyak lam, acum la asip üngka naw khyang he law u lü, Pamhnama khaw buhpawhnaka ngaw law khai he. ");
INSERT INTO dao_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Acunüng, atuh hnuki he ma law u lü, atuh maki he hnu law khai he” a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Acunüng Pharise he avang a veia law u lü, “Herod naw aning hnim vai ngaih ve, hina hmün üngka naw ktawih lü akcea cita” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Acunüng Jesuh naw, Acuna saui üng hina ngthu va mtheh ua, ‘Tuhngawi la khawngawi, khawyai he ka jah ktäm khai, am phetki he pi jah mdaw be lü, amhmüp thum üng ka khut ka kpäng khai. ");
INSERT INTO dao_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Acunsepi tuhngawi, khawngawi la a ngawi üng pi ka cit laih laih khaia kyaki. Jerusalema thea ta pung kcea sahma hnim vaia am kya naw, a ti. ");
INSERT INTO dao_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Aw Jerusalem, Jerusalem! sahma he jah hnimki, na veia Pamhnam naw a jah tüih law lung am jah vawiki, ainu naw a ca he a ngphya k’uma a jah awpa kba, na khyang, ivei ni ka jah awp hlü te nang naw am na ngjak hlü veki. ");
INSERT INTO dao_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","“Nami Temple yawka kya khai. Ka ning jah mthehki, ‘Bawipa ngming üng lawki hin Pamhnam naw dawnak pe se’ am nami tia küt üng am nami na hmu be ti khai” a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabbath mhmüp üng Pharise mata ima buh ei khaia cit se, ami mcih. ");
INSERT INTO dao_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Acunüng, a ma a kutkhaw ngphyüngki Jesuha veia law se, ");
INSERT INTO dao_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesuh naw thumksing he la Pharise he jah kthäh lü, “Sabbath mhmüp üng m’yai be vai ngkawiki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Acunüng am ngthuhei u lü awm u se, Jesuh naw, am phetki cun khü lü, m’yai beki naw, a tüih be. ");
INSERT INTO dao_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Acunüng Jesuh naw, “Nangmi üng u naw, a ca pi kyase, a sea pi kyase, sabbath mhmüp üng khui uk'uma kya se angxita am lo be khai aw?” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Acunüng, acuna ngthu cun am msang thei u lü awmki he. ");
INSERT INTO dao_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Acunüng, khin he naw ngawhnak akdaw ami xüei khawi jah hmu lü, msuimcäpnak jah mthehki naw, ");
INSERT INTO dao_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Khyang naw cambumnaka aning khüei üng, akyäpnak säiha ä na ngawh vai, nanga kthaka kyäp bawki khina se, ");
INSERT INTO dao_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“Acunüng, ning khüeiki naw, na veia law lü, ‘Hina khyang am ngawhnak mkena’ ti se, acunüng, ngkekhyakeinak am ahnemnak säiha na ngpyawt khai. ");
INSERT INTO dao_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ami ning khuei üng am adawnak säiha na ngawh vai, acunüng, ning khüeiki naw na veia law lü, ‘Ka püi aw, akyäpnak bawka va ngawa’ ning ti na se, acunüng, na buheipüi hea hmuha mhlünmtaia na kya khai. ");
INSERT INTO dao_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aktäa hlüng khaia ngai kyuki avan hnem lü, hnem khaia ngai kyuki avan mhlünmtaia kya khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Acunüng, Jesuh naw amät Khüeiki üng pi, “Nang naw mhmüp eia pi kyase, müeia pi kyase pawh lü, khyang na khüei üng, na püi he, na bena he, na paca he, bawimangkia na impei locenge ä na jah khuei vai; amimi naw pi ning khüei be u se, ngkhengnak na yah msawk khai ni. ");
INSERT INTO dao_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Acunakyase, buh na pawh üng, m'yenkseki he, am kümkawiki he, akxoe, amikmüe na jah khüei vai. ");
INSERT INTO dao_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","“Acukba na jah khüei üng na jo sen khai. Isetiakyaküng, acun he naw ä ning thung be theiki hea kyase, khyang kdawe ami thawh law bea mhmüp üng Pamhnam naw ning pe be khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Acunüng, a buh eipüi mat naw acuna ngthu cun ngja lü, a veia, “Pamhnama khawa buh ei khai he ta ami jo sen ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Acunüng, Jesuh naw mtheh lü, “Khyang mat naw, müei akyäpa pawh lü, khyang khawjah a jah khüei. ");
INSERT INTO dao_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","“Buh ei kcün üng a jah khüeia khyang he cun, ‘law u, ahmäi ngpäng ve’ ti lü a m'ya a tüih. ");
INSERT INTO dao_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Acunüng, ami van naw atänga lätnak sui u lü, akma säih naw a veia, ‘Khaw kheih ni se, teng khaia cit hlü veng na bä ni na mhläta’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Acunüng, akce mat naw, ‘Se sui xa kheih ni se, adaw aset ka teng khaia cit hlü veng na bä ni na mhläta’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Acunüng akce be tü naw, ‘Khyumah ni se am law hlü thei veng’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Acunüng m'ya naw, a mahpaa veia acuna ngthu cun va mtheh se, a mlung thüi lü a m'ya üng, ‘angxita ktawiha, mlüh ksung, lam avana cit lü, pyenksekie, am kümkawiki he, akxoe la, amikmüe la a khaw kse he jah lawpüia,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Acunüng a m'ya naw, ‘Saja aw, na na mtheha kba ka pawh päng teki khuiim ngsawng lü, kpawihei laih laih ve’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Acunüng, a bawipa naw, a m'ya üng, ‘angxita ktawiha, khaw kpung, lamnu, lamkse avana cit lü, ka ima benak vaia, jah va ling na. ");
INSERT INTO dao_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Ka ning mthehki, ka jah khüeia khyang he mat naw pi ka buh pawh am ei khai he a ti’ ti lü,” a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Acunüng, khyang khawjah naw a veia läk u se, ami veia nghlat lü, ");
INSERT INTO dao_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Upi, ka veia lawki naw a nu la a paa pi kyase, a khyuca hea pi kyase, a hnunpüi kphyaibee la, amäta pi kyase a jawngnaka kthaka kei am ana jawngnak üng, ka xüisawa am kya thei khai. ");
INSERT INTO dao_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Upi, amäta kutlamktung kawt lü am na läk lawki cun ka xüisawa am kya thei khai. ");
INSERT INTO dao_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nangmi üngka mat naw, imnu sa khaia ngtünki naw, a saknak vai ngui ‘khäk khai aw, am khäk khai aw’ ti akcüka ngaw lü am ngaikyu khai aw. ");
INSERT INTO dao_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","“Acukba am akya üngta ktungthing jah nglin päng lü am na kpäng hmuki he naw ning yaihei khai he ni. ");
INSERT INTO dao_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Hina khyang naw, imnu ngtün na lü am mkhüt ve’ tia ni kse na khai he. ");
INSERT INTO dao_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Acunüng, sangpuxang u naw sangpuhxang akce tu khaia a bü üng akcüka ngaw lü, khyang tawng nghngih am amät tu khaia lawki cun, khyang tawng at am mkhüt vai la am mkhüt vai ä ngai kyu khai aw? ");
INSERT INTO dao_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“Am acunüng, sangpuxang kce am a pha law hlan üng, ng’yäpnaka ngthu kthäh khaia ngsä tüi khai. ");
INSERT INTO dao_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Acukba bäa, nangmi üngka upi, a tak naküt am ceh taki cun ka xüisawa am kya thei. ");
INSERT INTO dao_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mci hin dawki ni, cunsepi a paih käna i am mtui be thei vai aw? ");
INSERT INTO dao_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","“Mdeka hama am daw ngsawnglinaka hama pi am daw, amdanga tawn khawiki he. Upi a ngjaknak vaia a nghnga awmki naw ngja se” a ti. ");
INSERT INTO dao_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mhmüp mat üng ngcawnklawk he la khyangka he ngthu ngai khai hea Jesuha veia lawki he. ");
INSERT INTO dao_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Acunüng, Pharise he la thum ksing he naw, “Hin naw khyangka he jah ngkhawtpüi lü, ami veia buh ei hnga ve” tia, ami mkatei. ");
INSERT INTO dao_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Acunüng, Jesuh naw ami veia hina msuimcäpnak a pyen, ");
INSERT INTO dao_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nangmi üngka mat to a phya taki naw, mat a khyüh üng, msaihmua kawkip la kaw jah yawk hüt lü, khyüki am a hmuh bea küt üng am sui lü ve khai aw? ");
INSERT INTO dao_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","“Acunüng, a hmuh be üng jekyainak am a kphyengmcunga khana taihki naw, ");
INSERT INTO dao_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ima a pha be la a püi he la, a impei locenge jah khü lü, ami veia, ‘Ka to khyüki hmu be veng na jekyai lawpüi ua’ am ti khai aw? ");
INSERT INTO dao_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Ka ning jah mthehki, acunkba bäa, ami ngjut vai am hlükia khyang ngsungpyun kawkip la kawa kthaka khyangka mat ngjutkia khana khankhawa jekyainak ve bawk khai. ");
INSERT INTO dao_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Acunüng nghnumi mat naw nguikcang xa a tak, mat a mkhyüh üng, mei mdäiki naw, im phek lü, im avan üng am a hmuh bea küt üng am sui be lü ve khai aw? ");
INSERT INTO dao_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","“Acunüng, a hmuh be üng a püi he la a impei locenge jah khü lü, ‘Ka nguikcang khyüki hmu be veng, na jekyai lawpüi ua’ am ti khai aw? ");
INSERT INTO dao_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Ka ning jah mthehki, acunkba bäa, khyangka mat, a katnaka phäha ngjutkia khana Pamhnama khankhawngsä he jekyai bawk khai he ni” a ti. ");
INSERT INTO dao_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesuh naw jah mtheh be lü, “Khyang mat naw cangpyang nghngih a canak, ");
INSERT INTO dao_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Anghmaw bawk naw a pa üng, ‘Ka pa aw, khawh ka bi vai na pea’ a ti. Acunüng ani pa naw khawh a jah kpai. ");
INSERT INTO dao_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Acunüng, sängsäng se anghmaw bawk cun, a khawh he jah jawi lü, a thuknaka khawa citki naw, acuia hlimtuinak üng ngui a va kpäkcaih bäih. ");
INSERT INTO dao_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Acunüng, a khawhthem a kpäkcaih bäih käna, acuna khaw üng aktäa khawjaw law se, a ei vai aktäa ng’yeng lawki. ");
INSERT INTO dao_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Acunüng, acuna khaw üngka, khyang mat va ngdawn si se, acun naw vawk mcah khaia a loa a tüih. ");
INSERT INTO dao_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","“Acunüng, vawk ei pi ei hlü leng leng khaia, a ei aktäa ngaihki. U naw i pi am pe u. ");
INSERT INTO dao_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Acunüng, a ngsingei law kyu la, ‘Ka pa ima nghlawhkie naw pi am ami ei bäih vaia buh awmei khai se, kei hia ei cawi lü, thi law hlü veng, ");
INSERT INTO dao_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Tho lü, ka pa veia ka cit khai, a veia, ka pa aw, khankhawa Pamhnam la, nanga khana katnak pawh veng, ");
INSERT INTO dao_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","na capa vaia am ngkawi ti veng, na veia nghlawhki mata kba na ngaia, ka ti khai,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Acunüng, tho law lü a pa veia citki. Acunüng athuknaka lama awm se, a pa naw a hmuh üng, aktäa m'yenei leng lengki naw, dawng si lü a nghngü üng kawi lü, aktäa a mhnam. ");
INSERT INTO dao_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Acunüng, a capa naw, ‘Ka pa aw, khankhawa Pamhnam la na khana katnak pawh veng, na capa vaia am ka ngkawiki ni’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Cunsepi, a pa naw a m'ya he üng, ‘Jihnu akdaw säih lawpüi ngxit u lü, ngvuihsak ua, a kut üng kutcüp nak sak u lü, a khaw pha üng khawdawke jah ngcumsak ua, ");
INSERT INTO dao_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“Semce akthaü kcang lawpüi u lü hnim u, hlimtuikia mi ei aw vai u, ");
INSERT INTO dao_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","“Hina ka capa thiki xüng law beki, khyüki hmuh be ni’ a ti. Acunüng eiaw lawki he. ");
INSERT INTO dao_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Acunüng, a capa angvai bawk cun loa awmki, ima a pha law hlü be üng ami kcingbe la ami nglam ngja lü, ");
INSERT INTO dao_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","“M'ya mat khüki naw, ‘Ia ngkhaw he ni?’ ti lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Acunüng, m'ya naw, ‘Na na, law be se phyawng yaikia a hmuh bea phäha, na pa naw semce akthaü kcang hnimki ni’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Acunüng, angvai ngai cun a mlung thüi lü im k’uma am lut hlü se a pa naw lut law lü a nghuinak. ");
INSERT INTO dao_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Cunsepi, ani naw, a pa üng, ‘Ngaia, kum hi vei tamna kba ning khüih lü, na ngthu am ka ngaihnak am ve, ka püi he am hlimtuinak ka pawheinak vaia, meca, mat hman pi am na na pe khawiki, ");
INSERT INTO dao_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","cunsepi, hina na capa, nghnumi kse hea veia, na khawhthem mdi hü bäihki, law be se, a hama semce akthaü na hnim peki’ ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Acunüng, a pa naw, ‘Ka capa aw, ka veia khawvei na awmki ni, ka tak avan cun na ka ni. ");
INSERT INTO dao_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","“Na na, thiki xüng law beki, khyüki hmuh be ni, acunakyase, hlimtuinak la jekyainak am mi ve hlü ye se’ a ti,” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesuh naw axüisaw hea veia hina ngthu a pyen be tü, “Khyang bawimangki mat naw, a khawh mceiki mat a tak. Acuna khawh mceiki naw a mahpaa khawh kpäkcaihsak ve tia mawng a mahpa üng mtheh law u se, ");
INSERT INTO dao_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","acunüng, a mahpa naw, ‘a khawh mceikia m'ya cun khü lü, na mawng ka ngjak hin ia suilam ni? Khawhtheme khana na bilawh na mtheh lawa. Atuh üng tün lü khawh mceikia am na kya ti khai’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Acunüng, khawh mceiki naw a mlung k’uma ngai kyu lü, ‘Ka mahpa naw, a khawh ka mceinak üngka naw na pyaisak ve, lai co lü pi am ka nghlawh theiki, ka kthähei hü vaia pi ka ngkekhyakeiki, ikba ka awm khai ni?’ ");
INSERT INTO dao_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Khawh mceinak üngka naw ami na pyaisak käna, ami ima na awmpüi khai hea püi ka tak üng daw khai ti ka ksingki,’ ti lü, ");
INSERT INTO dao_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","acunüng a mahpaa khawh leinakia khyang he jah khü lü, akcüka veia, ‘Ka mahpaa khawh i kän na lei naki ni?’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Acun naw, ‘Situi pung a phya lei na veng’ ti se, khawh mceiki naw, ‘angxita cajin lawpüi, ngaw lü, mhmakipa yua,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Acunüng, akce mata veia, ‘Nang mä i kän na lei naki ni?’ a ti, ani naw, ‘cang tawng thawng at lei na veng’ ti se, khawh mceiki naw, ‘angxita na cajin lawpüi, ngaw lü, phya khyeta yua,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Acunüng, am dawkia khawh mceiki naw acunkba a jah pawhmsah law a mahpa naw hmu lü, aktäa, a ngak. Khawmdek khyang he amimäta hama ami bilawhnak üng, akvai üng awmki hea kthaka khyaih bawki he ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Acunüng Jesuh bä naw, “Ka ning jah mthehki, nami hama khawmdek khawhthem püi na ua, acunüng ni acun a bäih law üng anglät xünak ima ning jah do khai he. ");
INSERT INTO dao_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Upi ajawcaa khana üpangak vaia awmki cun khawjaha khana pi üpangnak vaia ve khaia kyaki. Upi ajawca khana am üpangnak vaia awmki cun khawjaha khana pi üpangnak vaia am kya. ");
INSERT INTO dao_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","“Acunakyase, khyük theikia khawmdek khawhthema khana pi am üpangnak vaia nami ve üng, u naw khawhthem kcang ning jah khämsak khai aw? ");
INSERT INTO dao_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","“Khyang kcea khawhthema khana pi üpangnak vaia am nami awm üng, u naw nami ka vaia ning jah pe khai aw? ");
INSERT INTO dao_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","M'ya u naw mahpa nghngih am khüih khawi naw, mat ä ngja hlü lü, mat jawng na khai, am acunüng mat kü na lü mat kse na khai. Pamhnam la ngui atänga am nami jah khüih thei khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Acunüng, ngui jawngnaki hea Pharise he naw acuna ngthu ngja u lü, ami yaihei. ");
INSERT INTO dao_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesuh naw jah msang lü, “Khyanga hmuha nami cingcaihkia nami ngseki, cunsepi Pamhnam naw nami mlung ning jah ksingki ni; khyanga hmuha ami mküih cun Pamhnama hmuha msetei phyaki ni. ");
INSERT INTO dao_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mosia thum la sahma hea yuke cun Johana am a pha law hlan üng awmki, Johan üngka naw tün lü Pamhnama khaw thangkdaw cun sanga kyaki. Acunüng, khyang avan amthuia lut khawiki he. ");
INSERT INTO dao_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Cunsepi, thum anglungcaa khyüh theia kthaka ta, khawmdek la khankhawa khyüh vai jäi bawk khai. ");
INSERT INTO dao_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Upi a khyu mtai lü, nghnumi akce khyu naki cun a khyu mkhyekatki ni. Ami mtaia nghnumi khyu naki pi a khyu mkhyekat naki ni. ");
INSERT INTO dao_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Aktäa bawimangkia mangpa, aküi säiha thüi awi lü, amhmüp tä se hlimtui leng leng khaia ei aw lü awmki mat awmki. ");
INSERT INTO dao_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","“Acunüng, khuikha leng lengkia khyang, Lazaruh ngming naki pi mat, a pumsa üng mnehkse am be se, mangpaa mkawt peia ami lawpüi, ");
INSERT INTO dao_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","mangpa buhkbe peia kbuhkbaw ei khaia, a mkawt peia ngjän se ui he naw a mneh ami mleh law pet khawi. ");
INSERT INTO dao_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Acunüng, hinkba kyaki, Lazaruh thi se khankhawngsä he naw Abrahama peia ngaw khaia ami cehpüi. Acunüng, mangpa pi thi se k’uta kyaki. ");
INSERT INTO dao_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Acunüng, khyang kthikhawa aktäa khuikha lü hang mdeiki naw athuknaka Abraham, a peia Lazaruh ngaw se hmu lü, ");
INSERT INTO dao_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‘Aw ka pa Abraham, na m'yeneia. Lazaruh naw a kutmdawngca tui üng hnet lü, ka mlei a ye law sak vaia ka awmnaka tui lawa, hina meikdäi üng khuikha leng leng veng’ ti lü ngpyangki. ");
INSERT INTO dao_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Acunüng Abraham naw, ‘Ka capa aw, na xün k’um üng akdaw yah lü, acunkba Lazaruh naw am dawki a yah cen süma; cunsepi, atuh ani dim’yenak am ve se, nang khuikha veki, ");
INSERT INTO dao_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","acuna thea, hin üngka naw nami veia cit hlüki he am ami cehnak thei vai la upi nangmia awmnak üngka naw keimi veia am ami lawnak thei vaia, mi nglaka nghawinu awmki’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Acunüng mangpa naw, ‘Am acunüng, ka pa aw, ka pa ima Lazaruh na tüih vaia hleng ning nghui na veng, ");
INSERT INTO dao_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ka hnunpüi kpami mhma awmki, hina khuikhanaka ä law msawk khai hea a jah va mtheh vaia’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Acunüng Abraham naw, ‘Mosi la sahma he awmki he, acun hea jah mtheh ngai khai he ni,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Acunüng, mangpa naw, ‘Ka pa Abraham aw, acunkba am kya, khyang kthi he üngka mat, tho law be lü ngthu a pyen üng ta ami katnak nghlat ta khai he ni,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Acunüng Abraham naw, ‘Mosi la sahma hea ngthu am ami ngaih üng, khyang kthi üngka tho law be se pi am kcang na u,’ a ti” a ti. ");
INSERT INTO dao_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesuh naw axüisaw he üng, “Katnak üng khyang kyukngtäng sak khaia biloki cun a jo se ve, ");
INSERT INTO dao_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","“Hina anghmawca he üngka mat a mkhyekat saka kthaka ta a nghngü üng ksum khawp lü mliktui üng tawnin a hama daw bawk khai ni. ");
INSERT INTO dao_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Cäei ua, na bena naw a ning katnak üng na mcäi vai, a ngjut üng na mhlät vai. ");
INSERT INTO dao_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Mhmüp mat üng khyüh vei ning mkhyekat na lü, khyüh vei, ‘ngjut veng’ ti lü, a ning law si üng na mhlät vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Acunüng ngsä he naw, “Kami jumnak jah pung pea” ti u se, ");
INSERT INTO dao_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesuh naw, “Anca ui nglung ata kba jumnak nami tak üng, hina thing üng, ‘Na pya maha ngphawng law lü, mliktuia khana va ngdüia’ ti u lü, nami ngthu ngai khai. ");
INSERT INTO dao_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Cunsepi, nangmi üngka u naw a m'ya lai thawnkia pi kyase, toksäma pi kyase a law be üng, ‘law lü, ei law ktäia’ ti khai aw? ");
INSERT INTO dao_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","“Acukba am pyen lü, ‘ka ei vai na pyan law pea, na suisak suiawi lü, ka eiawk k’um üng na ngänga. Acunkäna namät ei kaw pi’ am ti khai aw? ");
INSERT INTO dao_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“M'ya naw a mahpa a pyena kba a bilawha phäha a mahpa naw, ‘Na bä ni’ ti khai aw? Am ti. ");
INSERT INTO dao_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Acukba ngthupet he avan nami jah pawh käna, ‘Keimi hin kami mahpa kami jekyai sakia am kya naw, kami pawh kung vai kami pawhki ni,’ ti ua” a ti. ");
INSERT INTO dao_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Acunüng hinkba kyaki, Jerusalema ami ceh üng, Samarih la Kalile ng’yü jun üng citki. ");
INSERT INTO dao_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Acunüng, ngnam mata a luh la, mnehkse mnehkia khyang xa naw ami na khyüm, acun he cun athuknaka ngdüi u lü, ");
INSERT INTO dao_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Bawipa Jesuh aw, jah m'yeneia” tia, angsanga ngpyangki he. ");
INSERT INTO dao_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Acunüng Jesuh naw, a jah hmuh üng, “Cit u lü, ktaiyü hea veia va ngtengei kyusak ua” a ti. Acunüng, hinkba kyaki, ami ceh k’um üng ami van ngcim lawki he. ");
INSERT INTO dao_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Acunüng, ami van üngka mat naw, yai beki ti a ksing la, angsanga Pamhnam a mküimto maha, nghlat be lü, ");
INSERT INTO dao_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuha khaw kunga kawp lü, jekyainaka ngthu a pyen; acuna khyang cun Samarih khyanga kyaki. ");
INSERT INTO dao_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Acunüng, Jesuh naw msang lü, “Khyang xa nami ngcim bekia am kya aih se? Kawe cen hawia ni ami ve? ");
INSERT INTO dao_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","“Hina khyangmjükce naw Pamhnam mküimto khaia nghlat law beki hin” a ti. ");
INSERT INTO dao_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Acunüng Jesuh naw, “Tho law lü, cita; na jumnak naw ning yai sak be ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Acunüng, Pharise he naw, “Itia ni Pamhnama khaw a pha law kawm?” tia kthäh u se, Jesuh naw, “Pamhnama khaw cun hmuh thei vaia pha law khaia am kya; ");
INSERT INTO dao_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Teng u, hia ni, cuia ni,’ ti vaia am kya, Pamhnama khaw cun nami k’uma awmki ni,” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Acunüng, axüisaw hea veia, “Khyanga Capa khawmhmüp he, mhmüp matca hleng hmu hlü u lü pi am nami hmuhnak thei vaia kcün pha law khai. ");
INSERT INTO dao_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Acunüng, nami veia, ‘Teng u, hia ni, cuia ni’ ning jah tina khai he, ä cit u lü, ä nami jah läk vai; ");
INSERT INTO dao_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","khaw nghmüm law se ‘khana mkek, khan avan üng a vai lawa kba, khyanga Capa a law bea mhmüp üng acunkba kya law khai. ");
INSERT INTO dao_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","“Cunsepi, am acun ham üng, aktäa khuikhanak khamei lü atuh ngsawn hea ksekhanak vaia awm khai. ");
INSERT INTO dao_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nawea kcün üngka kba khyanga Capa a law be üng pi kya law khai. ");
INSERT INTO dao_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","“Nawe mlawng üng lut se, mlikpitui phu lawki naw ami van a jah mthihnaka mhmüp am a pha law hlana küt üng, ei aw u lü, ngkhyungla u lü awmki he. ");
INSERT INTO dao_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Acunakba Lotaha xün hün üng; ei aw u lü, khei u lü, jawitu u lü, nglingsaw u lü, ngsawngsaki he; ");
INSERT INTO dao_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","cunsepi, Sodom khaw üngka naw, Lotah a ktawiha mhmüp üng khana üngka mei la kat, khawa a lawki naw ami van a jah mthiha kba, ");
INSERT INTO dao_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","khyanga Capa a law bea mhmüp üng kya law khai. ");
INSERT INTO dao_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Acuna mhmüp üng upi, mkyung khana awmki naw, im k’um üngka a khawhthem loei khaia ä kyum law se. Acuna kba laia awmki pi a hnua ä nghlat be se. ");
INSERT INTO dao_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","“Lotah khyu süm ua. ");
INSERT INTO dao_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Upi, amäta xünnak küikyan khaia büki naw mkhyüh lü, upi a xünnak mkhyühki naw küikyanei khai. ");
INSERT INTO dao_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ka ning jah mthehki, acuna mthan üng ihnak mat üng ipki xawia khyang nghngih, mat jäk se mat awm hüt khai. ");
INSERT INTO dao_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","“Ksum suki xawia nghnumi nghngih üngka mat jäk se mat awm hüt khai. ");
INSERT INTO dao_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","“Laia awmki xawi nghngih üngka, mat jäk se mat awm hüt khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Acunüng, axüisaw he naw, “Bawipa aw, hawia ni?” tia ami kthäh. Jesuh naw, “Akthia awmnak naküta nghmukse he ngcun khai he,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Acunüng, am pyai u lü, ktaiyü vai, ti ami ksingnak vaia, ami veia, msuimcäpnak am ngthu jah mtheh lü; ");
INSERT INTO dao_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Mlüh mata, Pamhnam am kyüh lü, khyang ia am msuikia ngthumkhyaki mat awmki. ");
INSERT INTO dao_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Acunüng, acuna mlüh üng hmeinu mat awmki, acun naw, ‘Ka ngcuhpüia veia ngtäi khaia ngthu na mkhya law pea’ ti lü, a law si laih laih. ");
INSERT INTO dao_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Acunüng ngthumkhyaki naw khawvei am a ktä te, akäna a mlung k'uma ngaikyu lü, ‘Pamhnam am kyüh lü, khyang ia am msui ni se pi, ");
INSERT INTO dao_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","hina hmeinu naw na mkhuimkha hlü ve, ngthu va mkhya pe vang, am acunüng ta law laih laih lü na mkhuimkha lü, na bawngkha hlüsak ve,’ a ti,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Acunüng Jesuh naw, “Am ngtäikia ngthumkhyaki naw a pyen cen ngai süm ua. ");
INSERT INTO dao_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","“A jah jawng'engnaka khyang he naw, amhmüp amthan ngpyang u lü, ami kthäh üng, Pamhnam naw ami ngthu am jah mkhyah pe lü, khawvei jah yawkin khai aw? ");
INSERT INTO dao_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","“Ka ning jah mthehki, akdawa amimia phäh ngthu jah mkhya pe khai. Cunsepi khyanga Capa khawmdek khana a law be üng jumnak hmuh khai aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Acunüng, cingcai säikia ngaikyu lü, khyang he jah hmumsit khawiki he pharise hea veia hina msuimcäpnak a pyen, ");
INSERT INTO dao_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Khyang nghngih, Temple na, ktaiyü khaia citki xawi; mat cun Pharisea kya lü, mat cun ngcawnklawka kyaki. ");
INSERT INTO dao_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Pharise cun ngdüi lü, amät däng hinkba ktaiyüki;‘Pamhnam aw, khyang kce hleihlakkie, am cingcäiki he la, hüipawmki hea kba am ka kya la, hina ngcawnklawka kba pi am ka kyaa phäha na khana jekyai veng. ");
INSERT INTO dao_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","“Mhmüp khyüh üng nghngih vei buh jeih lü, ka ktaiyü khawiki, ka tak avan xa üng mat ka pe khawiki,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ngcawnklawk cun a thuknak üngka naw ngdüi lü, khana pi ä hang mdei ngawn lü, ‘Pamhnam aw, kei khyangka ni, na m'yeneia,’ ti lü, a mkyang kbeiki. ");
INSERT INTO dao_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ka ning jah mthehki, Pharise am ni lü ngcawnklawk cun mhlätnak am ima cit beki. Amimät ak'hlünga ngai kyuki he cun hnem u lü, akhnema awmki he jah mhlünmtaia kya khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Khyang he naw Jesuha veia, ami ca he ami khana a kut a mtaih vaia jah lawpüi u se, axüisaw he naw hmu ü lü, ami jah na ksenak. ");
INSERT INTO dao_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Cunsepi, Jesuh naw jah khüki naw, “Anghmawca he ka veia law u se, ä jah mah u; Pamhnama khaw cun hina mäihea ham ni. ");
INSERT INTO dao_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Akcanga ka ning jah mthehki, upi, Pamhnama khaw hnasenca kba am dokhameiki cun, acuia am lut khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Acunüng, Judah hea ngvaipa mat naw Jesuh üng, “Saja kdaw aw, anglät xünnak ka yahnak thei vaia i ka pawh khai?” ti lü, a kthäh. ");
INSERT INTO dao_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Acunüng, Jesuh naw, “Ivai akdaw, na na ti naki ni? Mhnam dänga thea u am daw. ");
INSERT INTO dao_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“Ngthupet he cun na jah ksingki, ‘Khyanga khyuca ä na katnak vai, khyang ä na hnim vai, ä na m'yuk vai, hleihlaknak am khyang ä na kpuk vai, na nu la na pa na jah mhlünmtai vai,’ tie cen,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Acunüng, acuna khyang naw, “Acun he cun ka nghmawca üng tün lü ka jah läk päng ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesuh naw ngja lü, “Atuh mat na pawh vai ve ham ve, na tak avan jawi lü, m'yenkseki he üng jah yeta, acunüng khankhawa khawh na ta khai; acun käna law lü, na läk lawa,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Acuna khyang naw ngja lü, aktäa, bawimangkia kyase a mlung na leng lengki. ");
INSERT INTO dao_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Acunüng Jesuh naw a mlung naki ti hmu lü, “Khawh da naki he, Pamhnama khaw ami luh vai aktäa khak ve, ");
INSERT INTO dao_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","bawimangki Pamhnama khawa a lua kthaka ta, sanghnguksaü mpyüma nghnga k'uma a luh vai jäi bawk ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Acuna ngthu ngjaki he naw, “Acunüng, u küikyana kya thei khai aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesuh naw, “Khyanga am a mkhüt, Mhnam naw mkhütki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita naw, “Tenga, keimi, kami imlo jah yawk hüt u lü, kami ning läk lawki,” ti se, ");
INSERT INTO dao_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesuh naw, “Akcanga ka ning jah mthehki upi, Pamhnama khawa phäha, a ima pi kyase, a khyua pi kyase, a bena hea pi kyase, a nupaa pi kyase, a ca hea pi kyase jah yawkki cun, ");
INSERT INTO dao_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","atuha kcün üng akdäm bawk yah lü pha law khaia kcün üng pi anglät xünnak yah khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Acunüng, Jesuh naw xaleinghngih he akcea jah khü lü, “Ngai u! Jerusalema mi cit khai, sahma hea yuk avan khyanga Capa üng kümkawi law khai. ");
INSERT INTO dao_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","“Khyangmjükcea kut üng msuma kya khai, yaiha pawh khai he, ngkekhyakei sak khai he, ami mci am msawh khai he; ");
INSERT INTO dao_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kpai u lü hnim khai he; acunüng amhmüp thum üng thihnak üngka naw tho law be khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Acunüng, acuna ngthu axüisaw he naw asuilam am ksing u; acuna ngthu cun am ami ksing vaia mjiha kyase, Jesuh naw i pyenki tia pi am ksing u. ");
INSERT INTO dao_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Acunüng, hinkba kyaki, Jerikho a pha law hlü üng, amik müki mat, lam peia kthähei lü ana ngawki. ");
INSERT INTO dao_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Acun naw khyang he lam üng ami ceh ngja lü, “I ni” ti lü jah kthäh se, ");
INSERT INTO dao_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","amimi naw, Nazaret Jesuh a ceha mawng, ami mtheh. ");
INSERT INTO dao_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Acunüng, amikmü naw ngpyang lü, “Davita Capa Jesuh aw! na m'yeneia,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Acunüng, maki he naw am a khihkheh vaia ami mtheh; cunsepi amikmü naw, “Davita Capa, na m'yeneia,” ti lü, ngpyang law ksehlenki. ");
INSERT INTO dao_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Acunüng, Jesuh naw ngdüi lü, a veia ami lawpüi vaia jah mtheh se a pei a pha law üng, ");
INSERT INTO dao_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Jesuh naw, “Na hama i ka pawh vai na ngaiki?” ti lü a kthäh. Acunüng amikmü naw, “Saja aw, hmuh thei vai ngaih veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesuh naw, “Hmua! na jumnak naw ning daw sak be ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Acunüng angxita, hmu law be thei lü, Pamhnam mküimto lü Jesuh läki; acunüng, khyang avan naw hmu u lü, Pamhnam mküimtoki he. ");
INSERT INTO dao_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesuh Jerikhoa lut lü a ceh k'um üng, ");
INSERT INTO dao_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","khyang mat Zake ngming naki, ngcawnklawk ngvai awmki; aktäa bawimangki. ");
INSERT INTO dao_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Acunüng, Jesuh hin khyang ia mäih ni ti, hmu hlü teki, khyang hea daa phäh la, amäta tawia phäha, am hmu thei lü awmki. ");
INSERT INTO dao_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Acunüng, Jesuha lawnak vaia lam üng a na dawng lü, hmu khaia thingpama kaiki. ");
INSERT INTO dao_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesuh naw, acun a pha law üng, han teng lü, a veia, “Zake, angxita kyum law; tuhngawi na ima ka kai khaia kya ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Acunüng, Zake cun, angxita kyum law be lü, Jesuh jekyainak am a khinak. ");
INSERT INTO dao_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Acun hmu u lü khyang van naw, “Khyangka veia kai khaia lut ve,” tia, ami mkatei. ");
INSERT INTO dao_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Acunüng, Zake naw ngdüi law lü Jesuh üng, “Ngaia, saja aw, ka khawhthem atiteh khuikha m'yenkseki he üng ka jah pe khai, khyanga ka iyaw amdanga ka lawhei üng, kphyüa pungkia ka thung be khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesuh naw, “Hin pi Abrahama capa kyase, tuhngawi küikyanak hina khuiim kyawng üng pha law ve. ");
INSERT INTO dao_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“Khyanga Capa hin khyüki he jah sui lü, jah küikyan khaia lawki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Acunüng, Jerusalem mlüh peia pha law u se, Pamhnama khaw ngdang law khaia ami ngaiha phäha khyang hea ksunga msuimcäpnak a pyen be tü cun, ");
INSERT INTO dao_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Khyang kdaw mat, sangpuxanga kyanak ana va yah lü law be khaia athuknaka khawa citki. ");
INSERT INTO dao_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Am a ceh hlan üng a m'ya he xa jah khü lü xüi nguikcang xa jah peki naw, Am ka pha law be ham üng hin am a na bilo u lü, a na pungsak ua,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Acunüng, khaw khyang avang he naw, am ngja hlü u lü, ‘Hina jah uk vai am ngjahlü ve ung’ ti khaia, ngsä a hnua ami tüih. ");
INSERT INTO dao_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Acunüng, sangpuxang yah lü a law be üng, a m'ya he xüi tangka a jah pet cun, ami pung sak a ksingnak vaia a jah khü sak. ");
INSERT INTO dao_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Acunüng, akma säih naw law lü, ‘Saja aw, na xüi nguikcang xaa pungsak veng,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Acunüng ani naw, ‘m'ya kdaw aw, pawh thei veki; ajawca khana kcangnak vaia na awmkia kyase mlüh xaa bawia ning mcawn veng,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Acunüng, anghngihnak pi law lü, ‘Saja aw, na xüi tangka mhmaa pungsak veng,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Acunüng ani naw, ‘Nang pi mlüh mhmaa bawia ning mcawn veng,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Akce be tü law lü, ‘Saja aw, na xüi tangka kpyawn am hlawp lü ka khäm, ");
INSERT INTO dao_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","khyang kyunga na kyakia kyase ka ning kyüheiki; am na tak pi lo lü, am na saw pi na at khawikia kyase’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Acunüng ani naw, ‘M'ya kse, na pyena kba ka ning mkhyah pe khai. Khyang kyunga kya lü am ka tak pi lo lü am ka saw pi ka at khawiki ti na ksing üng, ");
INSERT INTO dao_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ise ka tangka, ngui taknak im üng pung khaia am na tak ni? Ka law be üng apung maha ka yah be vai sü,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Acunüng, a peia ngdüiki he üng, ‘A xüi tangka yut be u lü xüi tangka xa taki üng pe u,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Acunüng awmki he naw, ‘Saja aw, hin naw xüi tangka xa ta ye se’ ami ti. ");
INSERT INTO dao_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Ka ning jah mthehki, taki he üng a taka khana mkhah si u lü am taki he cun ami takca küt pi jah yuh be vai. ");
INSERT INTO dao_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Cunsepi, na hnengkie, ami sangpuxang vaia am na ngjahlüki he jah lawpüi u lü ka ma jah hnim law ua’ a ti,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Acunüng, acunkba a pyen law päng üng, Jerusalem daa ami ma a na citki he. ");
INSERT INTO dao_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Olip mcung ami ti, Betphake ja Bethanih mlüh pei a pha law üng, axüisaw he üngka nghngih jah tüi lü, ");
INSERT INTO dao_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Nani ma ngnam üng va cit ni lü nani va luh la, sanghngaksaü amceca, u naw am a ngcumnak ham, ngphung se nani hmu khai; sut ni lü kaih law ni. ");
INSERT INTO dao_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“Acunüng, ‘Ivai nani sutki ni?’ tia, ami ning jah kthäh üng, ‘Bawipanaw, hlüei ve’ nani ti vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A tüih xawi cit ni lü a jah mtheha kba ani va hmuh. ");
INSERT INTO dao_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sanghngaksaü, ani suh k’um üng kamahe naw hmu u lü, “sanghngaksaüca cen ivai nani sutki ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Bawipa naw, hlüei ve” ani ti. ");
INSERT INTO dao_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesuha veia kaih law ni se sanghngaksaüa khana ami jih he jah phah u lü Jesuh ami ngawhsak. ");
INSERT INTO dao_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A cehnak lam üng ami suisak he ami jah phah. ");
INSERT INTO dao_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Acunüng, Olip mcung üng ju kyumnak ami pha law üng, axüsawa khyang avan naw müncamkse he a jah bilawh ami jah hmuha phäha, jekyainak am angsanga Pamhnam mhlünmtai mküimto u lü, ");
INSERT INTO dao_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Bawipa ngming üng lawkia sangpuxang hin Pamhnam naw dawnak pe seh! khankhawa dim’yenak ve lü, Mhnama veia hlüngtainak ve se” tia, Pamhnam mküimtoki he. ");
INSERT INTO dao_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Acunüng, khyanga ksunga Pharise avang he naw, “Saja aw, na xüisaw he am khihkheh khai hea jah mtheha,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Acunüng Jesuh naw, “Ka ning jah mthehki, hin he ami ngdüm üng lunge ngpyang law khai he,” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Acunüng, Jerusalem a pha law hlü üng Jerusalem hmu lü, ");
INSERT INTO dao_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Tuhngawi üng dim’yenaka phäh hlüki hin na ksinga ta daw khai sü! Cunsepi atuh am hmu thei veki,” ti lü kyapki. ");
INSERT INTO dao_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","“Na ye he naw ning kcung u lü, ning kham u lü, ning küp u lü, ami ning kcungnaka kcün pha law khai. ");
INSERT INTO dao_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","“Ning küikyan khaia Mhnama kcün am na ksingeia phäha na khyang he mah maha ning kpyeh u lü, lung matca hman pi na khana ä ngtaih khaia pawhnaka kcün pha law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Acunüng, Jesuh Temple k’uma va lutki naw, iyaw jah jawituki he jah ktäm lü, ");
INSERT INTO dao_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Ka im ktaiyünaka ima kya khai tia ng’yuki, nangmi naw m'yukei hea ima pawh ve uki,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesuh naw amhmüp tä se Temple k’uma jah mtheiki. Acunüng, ktaiyü ngvai he, thum ksing he la, ngnam üngka ngvai he naw ami mkhyüh vaia ami bü. ");
INSERT INTO dao_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Cunsepi, khyang he naw a ngthu pyen naküt cun am ceh hlü taki hea kyase ikba ami pawh vai am ksing u. ");
INSERT INTO dao_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Acunüng, khaw mhmüp mat cun Temple k'uma khyang he jah mthei lü thangkdaw a pyen k'um üng, ktaiyü ngvai he la thum ksing he cun axüngvai he am law u lü, ");
INSERT INTO dao_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jesuh üng, “Jah mtheha, ia ana am na pawh ni? U naw hina ana aning pet ni?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Acunüng, Jesuh naw jah msang lü, “Kei pi mat ka ning jah kthäh khai na msang u; ");
INSERT INTO dao_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","“Johan naw baptican a jah petnak thei hin Mhnam üngka aw? Khyang üngka aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Acunüng, amimät he ami mlung k’uma, “Mhnam üngka mi ti üng pi, ‘ivai Johan am nami kcangnak ni?’ ti hlü ve. ");
INSERT INTO dao_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Khyang üngka mi ti üng pi khyang avan naw Johan cun sahmaa ami ksinga kyase, lung am jah vawi hlü ve u,” tia ngai kyuki he. ");
INSERT INTO dao_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Acunüng, msang u lü, “Hawia ka ni ti am ksing ve üng,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Acunüng Jesuh naw, “Kei pi ua ana am ka pawh ni ti am ning jah mtheh hlü veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Acunüng, khyang he üng hina msuimcäpnak a jah mtheh, “Khyang mat naw capyit ngvawng pyanki, k’äih khai he üng jah khah hüt lü athuknaka khawa di law khaia citki. ");
INSERT INTO dao_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Acunüng, capyit kbih vai a kha law üng amäta hama capyit ktheih kbit khaia a m'ya mat ngvawng ngängki hea veia a jah tüih. Cunsepi avang he ngängki he naw acuna m’ya cun kpai u lü a jünga ami tüih be. ");
INSERT INTO dao_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Acunüng, a m'ya akce mat ami veia a tüih be kce, ngvawng ngängki he naw, kpai u lü, ngkekhyakei khaia pawhki he naw, a jünga ami tüih be. ");
INSERT INTO dao_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Acunüng, akce m'ya mat ami veia tüi be se acun pi aktäa ngkhe khaia kpai u lü kpunga ami tawn. ");
INSERT INTO dao_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Acunüng, ngvawng mah naw, ‘Ikba ka pawh khai? Ka capa ka jawngnak bawi tüi süm vang, ani ta leisawng hman khai he ni,’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Cunsepi, ngvawng ngängki he naw ami na hmuh la, ‘Hin hin khawh mkhawm khaia khyang ni, mi hnim vai, acunüng a khawh mi ka na khai,’ tia, ami ceng. ");
INSERT INTO dao_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“Acunüng, capyit ngvawng üngka naw kpunga nawt u lü ami hnim. Acunüng capyit ngvawng mah naw ikba jah pawh law khai aw? ");
INSERT INTO dao_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Ngvawng mah law lü, ngvawng ngängki he jah hnim lü ngvawng pi khyang kce he üng jah pe khai,” a ti. Acunüng, acun ami ngjak la, “Acukba ta am kya khai,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Cunsepi, Jesuh naw jah teng lü, “Hina ngthu ng’yuki hin i ni? ‘Sawngsaki he naw ami yawka lung cun, avana kthaka kyäp law säihki ni’ ti hin. ");
INSERT INTO dao_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Upi, acuna lunga khana kyaki cun yawp khai, Upi acuna lung naw a kyaksih cun mvuta mhmüi khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Acunüng, thum ksing he la ktaiyü ngvai he naw man u lü, ami kutnak vaia ami bü te, khyang he ami jah kyühei; msuimcäpnak a pyen cun, amimi jah mkat lü, a pyen ti ami ksinga phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Acunüng, Jesuh naw, ngthu a pyen law msawk man u lü, Romah Empero veia ami khyak vaia phäha, k’äih tele u lü mcih khai hea khyang kdawa kba awmkia khyang he ami jah tüih. ");
INSERT INTO dao_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Amimi naw Jesuh üng, “Saja aw, cang yekia ngthu pyen lü na jah mtheiki, u am hngalang na lü akcanga Pamhnama lama ngthu na jah mthei khawiki ti kami ksingki; ");
INSERT INTO dao_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“Romah bawi üng ngcawn kami ngcawn hin ngkawiki aw,” Am ngkawiki aw?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Cunsepi, Jesuh naw ami hleihlak jah ksing lü, ");
INSERT INTO dao_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Tangka mat na mhmuh law ua, ua müihmai la ua ngming ni a ng’yuk?” a ti. Acunüng, amimi naw, “Romah Bawi” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesuh naw, “Acunüng Romah Bawia ka cun Romah Bawi üng pe u lü, Pamhnama ka cun Pamhnam üng pe ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Acunüng, khyang hea ma ngthu a pyen msawk, ami man vai i am hmu u; a jah msangnak cun aktäa kyüh u lü ä msimsawt u lü awmki he. ");
INSERT INTO dao_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Acunüng, thawhnak be am ve, tikiea Saduke avang he, Jesuha veia law u lü, ");
INSERT INTO dao_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Saja aw, Mosi naw a yuknak üng, khyang naw am ca lü a khyu a thih tak üng angsawn am a dütnak vaia, a bena naw a khäm be vai tia awmki. ");
INSERT INTO dao_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Ajana ngbengna khyüh awmki he. Akcük säih khyu mahki am ca lü thiki. ");
INSERT INTO dao_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","“Acunüng, anghnginak naw a khäm be, ");
INSERT INTO dao_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Acunüng akthumnak naw a khäm be, acunkba bäa akhyühnak cäpa ami khäm be te am ca u lü avan naw ami thih tak. ");
INSERT INTO dao_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","“Akdüta nghnumi pi thiki. ");
INSERT INTO dao_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Ami van khyüh naw ami khyunak. Acunakyase, thawhnak bea mhmüp üng, ua khyua kya hlüki ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Acunüng Jesuh naw, jah msang lü, “Hina khawmdek khyang he ngkhyungla u lü awmki he; ");
INSERT INTO dao_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","cunsepi, tuha thinak üngka naw tho be ngkawikia ngaikyuki he cun ä ngkhyungla be u lü, khyu ca vaia pi am ngpeei kyu be u lü; ");
INSERT INTO dao_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","“Athiha pi am thi be thei ti u, khankhawngsä hea mäih law u lü, thihnak üngka naw ami thawh bea phäha Pamhnama ca hea kyaki he. ");
INSERT INTO dao_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Mosi naw, akthi he tho be khai he ti lü saksiki. Cangcim üng kpyapa däinak pyen lü, ‘Pamhnam cun Abrahama Pamhnam, Isaka Pamhnam, Jakopa Pamhnam’ tia pyenki. ");
INSERT INTO dao_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","“Pamhnam cun akthi hea Mhnama am kya, akxüng hea Mhnama kyaki. Ania phäha avan xüngki he ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Thum ksing avang naw msang u lü, “Saja aw, cang veki,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Acunkäna ipi am ami kthäh be theia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Acunüng, Jesuh naw, “Ikba Mesijah cun Davita capa, ami ti thei ni? ");
INSERT INTO dao_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","“Davit amät naw Mküinaka ng’äi üng pyen lü, ‘Bawipa naw ka Bawipa veia pyen lü: ‘Ka kpat da ngawa, ");
INSERT INTO dao_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Na ye he na khawkunga ka jah tak law vei däa, ka kpat da ngawa’ a ti. ");
INSERT INTO dao_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Acukba Davit naw Mesijah üng, ‘Bawipa aw’ a ti üng ikba a mjükphyüia kya thei khai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Acunüng, khyang he avana ngjaka, axüisaw hea veia, ");
INSERT INTO dao_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Thum ksing he jah cäiei na u; amimi cun suisak aksaü suisa u lü ngtaw hü vai jawngnaki he, jawihtuknaka leisawngnak am nghnukset kyu, Sinakoka ngawhnak kdaw ami yah vai la pawia akdaw säiha hmün ami yah vai ngjahlüki he, ");
INSERT INTO dao_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","hmeinu hea khawhthem eiaw u lü, ami im jah yutei u lü, khyanga jah hmuha khawvei ktaiyüki he. Ami khamei vai akse säh ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesuh naw mang hü lü, bawimangki he naw, Temple khawh petnak üng ami khawh pe u se a jah hmuh. ");
INSERT INTO dao_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Acunüng, m'yenksekia hmeinu mat pi, tangka ca nghngih pe law hnga se hmu lü, ");
INSERT INTO dao_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Akcanga ka ning jah mthehki, hin hea kthaka pi, acuna m'yenkse hmeinu naw a pet däm bawk ve; ");
INSERT INTO dao_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","“Hin he naw ami taka kpawih pe lawki he; cunsepi, hina hmeinu naw a xünnak vaia a tak naküt pe ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Acunüng, axüisaw he avang naw, Temple lunga kyäpa mawng, a dawa mawng la Pamhnam ami petmsawta mawng pyen u se, ");
INSERT INTO dao_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jesuh naw, “Hin atuh nami jah hmuh, hin üng lung matca pi am ve se, avan a kpyehnaka kcün pha law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Amimi naw, “Saja aw, acun cun itia kya law khai? Acun a pha law hlü üng msingnak i ve law khai?” tia, ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesuh naw, “Ä ami ning jah hleihlaknak vaia a na cäiei ua. Khyang khawjah naw, ‘Kei Khritaw ni,’ ‘Akcün pha law hlü ve,’ ti u lü, keia ngming pyen u lü, ngdang law khai he; acun he ä nami jah läk vai. ");
INSERT INTO dao_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Acunüng, ngtungahnak la nghnengnaka ngthu nami ngjak üng, ä nami kyüh vai. Acun he akcüka ve law khai he, cunsepi acuna phäha adütnak ng'et lawkia am kya pha naw. ");
INSERT INTO dao_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Pung la pung ngtu law khai he, khawe la khawe ngtu law khai he; ");
INSERT INTO dao_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","“Mkhyü aknuia ngsün law khai, pung avana khawjaw law khai, mnehmnang da law khai, khankhawa am hmuh khawia msingnak he aktäkpaia ngdang law khai he. ");
INSERT INTO dao_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Acun he avan am a pha law hlan üng, ka ngminga phäha, ning jah man u lü, ning jah mkhuimkha u lü, Sinakok la thawngima ning jah cehpüi khai he. Sangpuxang he la khawbawi hea veia ning jah cehpüi khai he. ");
INSERT INTO dao_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","“Cunsepi, acun cun thangkdaw nami pyenak vaia kcün kdawa kya khai. ");
INSERT INTO dao_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Akcün am a pha law hlan üng ikba nami pyen be vaia ä cäi ua. ");
INSERT INTO dao_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","“Nami ye he naw, am ami ning jah nängnak vaia, khyaihnaka ngthu la ksingnak kei naw ka ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Nami nu la nami pa he, nami hnunpüi he, nami püi he naw pi ning jah ceng u lü ning jah man law sak khai he; avang ning jah hnim khai he. ");
INSERT INTO dao_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","“Keia ngminga phäha khyang avan naw ning jah hneng law khai he. ");
INSERT INTO dao_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","“Cunsepi, nami lusam matca pi am khyük khai ni. ");
INSERT INTO dao_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","“Nami khängceknak am nami ngküikyanei kyu khai. ");
INSERT INTO dao_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Acunüng, yekap he naw Jerusalem nglung law na u se nami hmuh üng, Jerusalem pyeh law hlüki ti nami ksing vai. ");
INSERT INTO dao_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","“Judah khawa awmki he mcung hea dawng u se; mlüh k’uma awmki he kpunga dawng u se; mlüh kpunga awmki he mlüh k’uma ä lut be u se. ");
INSERT INTO dao_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","“Acuna mhmüp cun, cangcim üng ng’yuki akümnak vaia, Mkhuimkhanaka Mhmüpa kya khai. ");
INSERT INTO dao_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Acuna mhmüp üng m'yaieiki he la naca kpawmeiki he ta ami jo se ve; hina mdeka khana khuikhanak cang pha law khai, hina khyang hea khana Mhnama mkhuimkhanak pha law khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","“Avang he Mthikcim am jah hnim khai he, avang he pung kcea jah cehpüi u lü thawngim üng jah khyum khai he; khyangmjükce hea mhmüp am a küm hlana küt üng, Jerusalem cun khyangmjükce hea khaw keha ve khai. ");
INSERT INTO dao_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nghngi, khya la aisi hea khana msingnak he ngdang law khai he; mliktui nghmüm law lü phu law se khawmdek khan avan üng khyang he kyükyawk u lü cäicah law khai he. ");
INSERT INTO dao_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","“Khan ngsün law khaia kyase, khawmdek khana pha law khaia khuikhanak vai ngaihkyunak la kyühkyawk lawa phäha pi khyang he käikang law khai he. ");
INSERT INTO dao_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Acunüng, khyanga Capa cun johit la hlüngtainak am khawngmei üng kyum law lü ngdang law khai. ");
INSERT INTO dao_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Acun hea tünei law üng, ngdüi u lü han teng u, nami hama küikyannak ng'et law ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Acunüng, Jesuh naw ami veia msuimcäpnak pyen be lü, “Fik thing la thing avan jah ngai u; ");
INSERT INTO dao_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","“Hlip law se nami hmuh la khawkhye ng’et lawki ti nami ksingki. ");
INSERT INTO dao_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","“Acukba bäa nangmi pi acun he awm law u se, nami jah hmu üng, Pamhnama khaw pha law hlüki ni ti ksing ua. ");
INSERT INTO dao_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Hina khyang he am thi pha u se, acun he avan pha law khai ti ksing u. ");
INSERT INTO dao_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","“Khankhaw la mce khyük ni se pi ka ngthu am khyük. ");
INSERT INTO dao_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Acunakyase, a na cäiei u, am acunüng ta ei ngang, aw ngang u lü khawmdek khawhthema phäha nami mlunga bawngkha k'um üng, acuna mhmüp am nami sima pha law sawxat khai ni. ");
INSERT INTO dao_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","“Acuna mhmüp cun ngvaia kba khawmdek avan üng awmkia khyang hea khana pha law khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","“Acunakyase, kya law khaia khuikhanak üngka naw phyawng u lü khyanga Capaa ma nami ngdüi hlawt khaia anglät se ktaiyü u lü a na k’äih ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Acunüng Jesuh cun amhmüp tä se Temple k'uma jah mthei lü amthan tä se Olip mcung ami tia ktaiyü khaia citki. ");
INSERT INTO dao_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Angawi tä se a ngthu ngai khai hea khyang avan Temple üng citki he. ");
INSERT INTO dao_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nghngen am bawi khaia buhpawhnaka pawi; lätnakpawi ami ti ng'et lawki. ");
INSERT INTO dao_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ktaiyü ngvai he la thum ksing he naw ami mkhyühnak vaia lam sui tekie khyang he jah kyüh u lü anghmüa hnim khai hea ami bü. ");
INSERT INTO dao_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Acunüng, xaleinghngih üngka Judah Iskarot ami tia k'uma khawyam lut se, ");
INSERT INTO dao_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ktaiyü ngvai he la Temple ngängki hea veia cit lü, Jesuh ikba man vai tia a jah va cengpüi. ");
INSERT INTO dao_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Amimi naw jekyai u lü ngui ami pet vaia ami mkhyäp. ");
INSERT INTO dao_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Acunüng Judah Iskarot naw ngaisim lü khyang he am ami ve üng a jah mansak vaia lam suiki. ");
INSERT INTO dao_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Acunüng nghngen am bawikia buhpawh mhmüp, lätnakpawi vaia toca hnimnaka mhmüp pha law se, ");
INSERT INTO dao_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesuh naw, Pita la Johana veia, Lätnakpawi buh mi einak vai va pawh ni,” ti lü a jah tüih. ");
INSERT INTO dao_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Anini naw, “Hawia pawh vai ni na ngjak hlü?” ani ti. ");
INSERT INTO dao_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesuh naw,Mlüh the nani va luh üng, kpami k'am üng tui kawtki naw ning jah na khyum khai ni, a luhnaka ima nani läk vai. ");
INSERT INTO dao_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","“Imaha veia, ‘Saja naw, ka xüisaw he am lätnakpawi buh kami einak vaia khinim hawia ni? ti ve,’ nani ti vai. ");
INSERT INTO dao_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","“Ani naw khin im angsawng kcang, ahmäi am kümki im khan ning jah mhmuh khai; acunüng va ngtüna ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A jah mtheha kba cit ni lü ani va hmuh, acuia lätnakpawi buh ani va ngtünak. ");
INSERT INTO dao_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Acunüng Jesuh la a ngsä he eikbe üng atänga ei hmaihki he. ");
INSERT INTO dao_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesuh naw, “Am ka thih hlan üng hina lätnakpawi buh atänga ka ning jah eipüi vai ka ngja hlü leng lengki, ");
INSERT INTO dao_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","“Ka ning jah mthehki, Pamhnama khawa hin akcanga am a kya hlana küt üng am ei hlü be ti veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Acunüng khawt lo lü Pamhnama veia jekyainak ngthu pyen lü, “Hin hin lo u lü, ng’yet ua; ");
INSERT INTO dao_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ka ning jah mthehki, atuh üng tün lü Pamhnama khaw am a pha law cäpa capyitui am ka aw be ti khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Acunüng muk lo lü Pamhnama veia jekyainaka ngthu a pyen law päng üng, boki naw jah pe lü, “Hin hin nami hama peta ka mtisa ni, nami na sümnak vaia pawh ua” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Müei a ei law päng üng, acunkba bäa khawt lo lü, “Hina khawt hin ka thisen, nami hama ngsawikia Pamhnama ngthumkhän kthaia kyaki. ");
INSERT INTO dao_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Acunakyasepi, na mansak khaia khyang cun hina eikbea khana kani awm hmaihki ni! ");
INSERT INTO dao_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Khyanga Capa hin Mhnama mkhyaha kba cit khai, cunsepi jah mansak khaia cengkia khyang ta a jo se ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Acunüng axüisaw he amimät, “Acukba kya khai ta u ni?” tia, ngthäh kyuki he. ");
INSERT INTO dao_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Axüisaw he amimät, u ni akyäp säih tia ngcuh u se, ");
INSERT INTO dao_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesuh naw, “Am jumeiki hea sangpuxang he cun khyang hea khana aktäa bawi khawiki he, khaw uki he naw ‘Khyang hea püi he’ tia ami jah khü jawngnaki he. ");
INSERT INTO dao_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Cunsepi, nangmi ta acunkba ä awm u, nangmi üng kyäp säihki cen jaw säihkia kba, mkhawng säiki cen m'yaa kba ve se. ");
INSERT INTO dao_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“U ni a kyäp säih? Ngaw lü buh eiki japaw a kyäp säih? Buh khünki aw a kyäp säih? Ngaw lü buh eikia am kya aih se? Cunsepi, kei ta nami veia ning jah khüihkia kba ka awmki. ");
INSERT INTO dao_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Khuikha lü ka awm üng nami na awmpüiki. ");
INSERT INTO dao_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","“Ka Pa naw uknak thei a na peta kba kei naw pi ka ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nangmi cun ka eikbe üng ngaw u lü ka khawa nami ei aw hnga khai. Bawingawhnak he üng ngaw u lü Isarel pakhui xaleinghngih he ngthu nami jah mkhyah khai. ");
INSERT INTO dao_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Sihmon, Sihmon, Ngaia! lomah naw angsi kphya am a mkhyaha kba, khawyam naw a ning hlawhlepnak vaia akhawn yah päng ve, ");
INSERT INTO dao_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","“Cunsepi, na jumnak am a khyühnak vaia, ka ning ktaiyü peki ni; ka veia na nghlat law be üng, na bena he jah khängsak kaw pi,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita naw, “Bawipa aw, na veia ta thawngim la thihnak üng pi ka ceh vai ling veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesuh naw, “Pita aw, ka ning mthehki, tuhngawi ai am khawng pha se, ‘Ani am ksing nawng’ ti lü kthum vei na ngcim khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesuh naw, “Ajana, nguiip, ngja, khawdawk, am nami cehei khaia ka ning jah tüih üng, nami hlü ei i awmki aw?” ti se amimi naw, “I am hlü naw,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Acunüng Jesuh naw, “Atuh ta aupi nguiip la ngja taki naw cehei se; kcim am taki naw a suisak jawi lü kheihei se. ");
INSERT INTO dao_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Ka ning jah mthehki, ‘Ani cun khyangka he mah maha ami täh si’ tia, ng’yuki ka khana kümkawi law khaia kyaki; keia mawngma ngthu he kümkawi law bäih ve u,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Amimi naw, “Bawipa aw, tenga! kcim nghngih awmki,” ti u se, Jesuh naw, “Khäk ve” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesuh cun a thum khawia kba, Olip mcunga ktawih se, axüisaw he naw ami läk hnga. ");
INSERT INTO dao_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ahmün a va pha üng, “Hlawhlepnaknak üngka naw nami lätnak vaia, ktaiyü ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lung vawi lü aphanak cäpa va cit lü; a mkhuk ngdäng lü, ");
INSERT INTO dao_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ka pa aw, na hlüei üng ta hina khuikhanak khawt ka vei üngka naw loin kawpi, cunsepi keia ngjak hlüa am kya lü, namäta ngjak hlüa kya se,” ti lü ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Khankhaw üngka khankhawngsä mat Jesuh kthayüi pe khaia ngdang lawki. ");
INSERT INTO dao_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aktä leng lenga khuikha lü, kthana kcang lü, ktaiyü se a ngkhyantui thisena mäiha mdek üng ngsawi lawki. ");
INSERT INTO dao_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A ktaiyü law päng üng tho law lü axüisaw hea veia cit teki ami mlunga nata phäha a na ip u se a jah hmuh. ");
INSERT INTO dao_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesuh naw, “Ise nami ipki ni? Hlawhlepnak üngka naw nami lätnak vaia tho law u lü ktaiyü ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Acukba a na ngthuhei k’um üng, xaleinghngih he üngka Judah ami ti naw jah xüi lü, khyang he jah lawpüiki naw, Jesuh mhnam khai bü lü a pan law. ");
INSERT INTO dao_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesuh naw, “Judah aw khyanga Capa hin mhnam khaia bü lü na jah man sak khai aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Acunüng axüisaw he a peia awmki he naw, ia akya law vai sim u lü, “Bawipa aw, kcim am kami jah pawh khai aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Acunüng mat naw ktaiyü ngvai säiha m'yaa nghngakawi kpat lam a ksawm pat. ");
INSERT INTO dao_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesuh naw, “Khäk ve,” ti lü a nghngakawi hnet se daw beki. ");
INSERT INTO dao_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesuh naw a veia lawki hea ktaiyü ngvai he, Temple üng ngvai he la, axüngvai he üng, “Mthikcim la kpaihmäng jah kawtei u lü m'yukei man khai hea kba nami na lawsiki aw? ");
INSERT INTO dao_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Temple üng amhmüp tä nami veia ve ni se am nami na manki. Cunsepi atuh hin nami kcüna kya lü nghmüpa khyaihnaka kya ve,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesuh kpang u lü cehpüiki he naw ktaiyü ngvaia ima ami luhpüi. Acunüng, Pita naw athuknak üngka naw a läk hnga. ");
INSERT INTO dao_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Imngvawng mkawt nglung üng mei awm u lü ngaw u se Pita ami ksunga va ngaw hngaki. ");
INSERT INTO dao_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Meikdäi peia ngaw se nglaca mat naw hmu lü a hmai üng teng kyetki naw, “Hina khyang pi Jesuh am awm khawiki xawi ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita naw, “Nghnumi aw, ani am ksing nawng,” ti lü, ngcimki. ");
INSERT INTO dao_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Acunkäna, khyang kce mat naw hmu lü, “Nang pi acun he üngka mat ni,” ti se, Pita naw, “Khyang aw, am kya nawng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Acunüng naji mat ngsawk se khyang mat naw, “Hina khyang pi Jesuha hlawnga awm khawiki ni; Kalile khaw khyanga kya ye se,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Acunüng, Pita naw, “Khyang aw na pyen am ksing nawng,” a ti. A na ngcim k’um üng angxita ai khawng law ktäihki. ");
INSERT INTO dao_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesuh naw nghlat lü Pita a teng. Pita naw Jesuha pyen, “Tuhngawi, ai am khawng pha se kthum vei, ‘Am ksing nawng’ ti lü na ngcim khai,” a ti cun süm law beki. ");
INSERT INTO dao_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Acunüng, Pita kpunga cit lü aktäa kyapki. ");
INSERT INTO dao_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesuh ngängki he naw yaiha pawh u lü ami kpaih. ");
INSERT INTO dao_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","A mik bu u lü, “U naw ning kpaiki, pyena?” tia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ngthu khawjah am kse na u lü ami jüih. ");
INSERT INTO dao_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Khaw a thaih law la khyang ngvai he, ktaiyü ngvai he la, thum ksing he avang ngcun lawki he naw ami Kawngcia cehpüi u lü, ");
INSERT INTO dao_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Mesijaha na kya kcang üng jah mtheh law,” ami ti. Acunüng, Jesuh naw, “Ning jah mtheh ni se pi am nami na kcang na khai; ");
INSERT INTO dao_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ning jah kthäh ni se pi am nami na msang khai. ");
INSERT INTO dao_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cunsepi, atuh üng tün lü khyanga Capa cun hlüngtai kyäpsawkia Pamhnama kpat da ngaw khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Acunüng ami van naw, “Nang hin Pamhnama Capa kya aih lü?” ami ti. Acunüng Jesuh naw, “Ä, nami pyena kba kya veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Amimi naw, “Ia saksi akce hlü be se ni? Amäta mka ye üng mi ngja ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Acunüng ngbumki he ami van tho law u lü Jesuh Pilata veia cehpüi u lü, ");
INSERT INTO dao_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","“Hin naw, kami khyang he lam jah hma saki, kei Mesijah, sangpuxang ni ti lü Ketah sangpuxanga veia akhawn ä ngcawn vai ti se, kami ngjak,” tia ami mawm. ");
INSERT INTO dao_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat naw, “Judah hea sangpuxanga na kyaki aw?” ti lü kthäh se, Jesuh naw, “Ä, na pyena kba kya veng,” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Acunüng Pilat naw ktaiyü ngvai he la khyang hea veia, “Hina khyanga khana mkhuimkhanak vai ia mkatnak am hmu veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Cunsepi amimi naw “Kalile khaw üng tün lü, ahi düta Judah khaw avan üng jah mthei hü lü khyang avan jah kpyükpyeh hü bäihki,” tia, aksehlena ami pyen. ");
INSERT INTO dao_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilat naw ngja lü “Hina khyang hin Kalile khyang aw?” ti lü a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilat naw Heroda uknaka khaw üngka ti a ksing üng Heroda veia a tüih be. Acunüng, Herod cun Jerusalema awmki. ");
INSERT INTO dao_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod naw Jesuh a hmu üng aktäa jekyaiki; isetiakyaküng a mawngma ngja lü ajandea a hmuh vai a ngaih, müncankse he a jah bilaw iyaw bawi ta a hmuh vai a büa phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ngthu khawjah a kthäh; cunsepi Jesuh naw i am pi am msang be. ");
INSERT INTO dao_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Acunüng ktaiyü ngvai he la thum ksing he naw ngdüi u lü aktäa a mi mkatei. ");
INSERT INTO dao_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod la a yekap he naw Jesuh hmumsit u lü yaiha pawh u lü jinu akyäp cang suisaki he naw Pilata veia ami tüih be. ");
INSERT INTO dao_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Acuna mhmüp üng Pilat la Herod ngpüi kyu naki xawi. Ajana ani püi ana hneng khawiki xawi. ");
INSERT INTO dao_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat naw ktaiyü ngvai he, angvai he la khyang he avan jah khü lü, ");
INSERT INTO dao_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Khyang he lam jah hma saki ti u lü hin ka veia nami lawpüia kyaki; teng u, nami ma a katnak sui ni se nami mkata kba hina khana i a katnak am hmu veng; ");
INSERT INTO dao_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod naw pi a katnak cang am hmu naw, a veia ka tüih päng; teng u, thihnak sen vaia i am pawh ve. ");
INSERT INTO dao_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","“Acunakyase, kpai lü khyah be vang,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Buhpawh pawi üng khyang mat jah mhlät pet khawia thum awmki. ");
INSERT INTO dao_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ami van atänga ngpyang u lü, “Hin hin hnim lü, Barabah jah mhlät pea,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabah cun mlüh k’uma ksuksaknak pawh lü khyang a hnima phäha thawngima khyuma kyaki. ");
INSERT INTO dao_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat naw Jesuh a mhlät vai ngaih lü a jah kthäh be. ");
INSERT INTO dao_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Cunsepi ngpyang u lü, “Kutlamktung üng taiha, Kutlamktung üng taiha,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat naw akthumnaka, “Ise ni? Hin naw ia katnak ni a pawh ve? Thihnak sen vai a khana i am hmu veng; acunakyase kpai lü khyah be vang,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Cunsepi amimi naw angsang yea kutlamktung üng taih vaia amthuia mso u se, acunüng ami ngpyangnak am Pilat ami näng. ");
INSERT INTO dao_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Acuna Pilat naw ami msoa kba Jesuh pawh vaia ngthu a jah pet. ");
INSERT INTO dao_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Suksaknak pawh lü khyang a hnima phäha thawngim üng kyumki ami kthäh jah khyah pe lü; Jesuh cun ami ngaih ngaiha ami pawh vaia a jah pet. ");
INSERT INTO dao_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesuh ami cehpüi k'um üng, Karenih khaw üngka Sihmon naki ngnamca üngka naw lawki ami hmu üng, man u lü Jesuha hnua kutlamktung ami kawh sak. ");
INSERT INTO dao_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A hnua läki hea khyang khawjah üng Jesuh kyahki hea nghnumi avang awmki he. ");
INSERT INTO dao_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Acun he Jesuh naw jah nghlat si lü, “Jerusalema canu he aw, kei am na kyah u lü nami mäta phäh la nami ca hea phäha kyap ua. ");
INSERT INTO dao_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","“Isetiakyaküng, ‘cingkia nghnumi ta a jo sen ve, na am pawinakia pum la na naw am a awk khawia cih ta a jo sen ve’ ami tinaka mhmüp pha law khai. ");
INSERT INTO dao_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Acunüng khawmcunga veia, ‘Jah sip lawa,’ khawngjung khawkawngea veia, ‘Jah mük lawa’ ti law khai he, ");
INSERT INTO dao_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Thing xünga veia pi hinkba ami ti üng akhyawnga veia ta ikba kya khai aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Acunüng a veia khyangka nghngih ami jah hnim vaia ami jah cehpüi hnga. ");
INSERT INTO dao_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Acunüng luyuh hmün ami tinak ami pha law üng acuia a kpat lama mat, a k'eng lama mat, khyangka xawi am kutlamktung üng ami taih. ");
INSERT INTO dao_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesuh naw, “Ka Pa aw, jah mhläta; i ami pawh am ksing hei ve u,” a ti. Acunüng, a suisak he cung kphawng u lü ami jah ngpaiei. ");
INSERT INTO dao_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Khyang he naw ngdüi u lü ami tengei. Angvai he naw, “Khyang kce ta jah küikyan khawiki; Pamhnama a xü Mesijah kcang a ni üng amät pi ngküikyanei kyu se,” tia ami ksenak. ");
INSERT INTO dao_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Yekap he naw pi yaiha ami pawh a veia capyit jukthui lawpüi u lü, peki he naw, ");
INSERT INTO dao_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Judah hea sangpuxanga na kya kcang üng, namät la namät ngküikyanei kyua,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Acunüng a lu khana, “Hin hin, Judah hea sangpuxang ni,” tia ami taih. ");
INSERT INTO dao_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Acunüng, khyangka mat, a peia ami taih naw pi, kse na lü, “Nang Mesijaha na kya üng, namät ngküikyanei kyu lü, keini pi jah küikyan lawa,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Cunsepi, akce mat naw a jüinak am msang lü, “Mhnam ye pi am na kyühki aw? Atänga mkhuimkhanak mi khamei hmaih ye se, ");
INSERT INTO dao_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ningni cun ni khamei kung khaia ni kyaki; ni katnaka phu däng ni hlawheiki ni; hin naw ia katnak am pawh naw,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","“Jesuh aw, Sangpuxanga na law üng na sümeia,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Acunüng, Jesuh naw, “Tuhngawi Paradaia ka hlawnga na ve khaia ning khyütam na veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Acun cun mhmüp naji xaleinghngiha kya lü, mülam naji kthum cäpa nghngi am vai lü avan üng khaw nghmüp lawki. ");
INSERT INTO dao_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Acunüng Temple üng jihnu, anglung üng nghngiha tek lawki. ");
INSERT INTO dao_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Acunüng, Jesuh naw angsanga, “Ka Pa aw, na kut üng ka ngmüimkhya ning pe veng,” a ti. Acun ti lü thiki. ");
INSERT INTO dao_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Acunüng, yekap ngvai naw acun a hmuh üng, “Hin hin akcanga khyang ngsungpyuna kya ve,” ti lü, Pamhnam mküimtoki. ");
INSERT INTO dao_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Khyang avan acun tengei khaia lawki he, acuna awm ihe ami jah hmu üng ami mkyang kbei u lü puksetnak am cit beki he. ");
INSERT INTO dao_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Acunüng, Kalile khaw üngka naw läk lawkia nghnumi he la Jesuh ksingki he avan, acun teng u lü, athuknaka ngdüiki he. ");
INSERT INTO dao_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Acunüng khyang mat Josep naki ngvainu, ngsungpyun lü dawki awmki. ");
INSERT INTO dao_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ani cun Kawngci member kya lü pi ami pawhmsah ami bilawh he am jah ngaisimkia kyaki. Judah khaw, Arimahte khyanga kya lü, Pamhnama khaw a na ngak’uhei khawiki, ");
INSERT INTO dao_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilata veia cit lü Jesuha yawk a kthäh. ");
INSERT INTO dao_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jesuha yawk khya lü jih am hlawpki naw, u pi am ami k'uhnak khawia, ng’uhnün üng a k'uh. ");
INSERT INTO dao_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Acunüng, acuna mhmüp cun kyawngkai amhmanaka kya lü Sabbath mhmüp pha law hlüki. ");
INSERT INTO dao_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Acunüng, Kalile khawa Jesuh läki nghnumi he cun Josep am atänga cit u lü, ng’uhnün la acunüng ikba Jesuha yawk ami tak cun tengki he. ");
INSERT INTO dao_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Acunkäna nghlat be u lü, ng’uinghname la, situie jah pyang u lü thum naw a pyena kba Sabbath mhmüp üng xüieiki he. ");
INSERT INTO dao_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ngpum mhmüp ngawiksik üng, ng'uingnam he jah ceh u lü, nghnumi he ng’uhnüna citki he. ");
INSERT INTO dao_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Acunüng k'utnak üngka lungnu cun akcea ngtäng se hmu u lü, ");
INSERT INTO dao_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","lutki he, acunüng Jesuha yawk cun am ami hmuh. ");
INSERT INTO dao_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Acunüng, acuna phäha ami cäicah k'um üng, khyang nghngih akbawk suisa ni lü, ngdang lawki xawi. ");
INSERT INTO dao_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ami kyühnak am kawp u lü ami ve k'um üng anini naw, “Ivai akthia ksunga akxüng nami suiki ni? ");
INSERT INTO dao_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","“Hia am ve ti naw, tho be päng ve; Kalilea a ve üng nami veia a ngthu pyen cen süm be ua, ");
INSERT INTO dao_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘khyanga Capa, khyangka hea kut üng mansaka kya khai, kutlamktung üng taih khai he, amhmüp thum üng tho be khaia kyaki,’ a ti cen,” ani ti. ");
INSERT INTO dao_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Acunüng a pyen süm law be u lü, ");
INSERT INTO dao_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ng’uhnün üngka naw cit beki he naw, xaleiat la akce hea veia acuna mawngma avan cun ami jah mtheh, ");
INSERT INTO dao_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Acuna nghnumi he cun, Marih Makdalin, Joanah la Jakuka nu Mariha kyaki he; ami veia nghnumi kce he naw pi acuna ngthu cun ngsä he üng ami jah mtheh hnga. ");
INSERT INTO dao_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Cunsepi acuna ngthu cun ngthu sawxata kba, ia am msui u lü am ami kcangnak. ");
INSERT INTO dao_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pita tho law lü ng’uhnüna dawngki; acunüng kawp lü tengki naw, jih he däng ve se hmu lü aktäa cäi lü ima cit beki. ");
INSERT INTO dao_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Acuna mhmüp üng axüisaw xawi nghngih, Jerusalem üngka naw mäng khyüh thukia Emawk khawa ani ceh k'um üng, ");
INSERT INTO dao_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jerusalema iyawa awmih avan sumkyam ni lü citki xawi. ");
INSERT INTO dao_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Acukba sumkyam ni lü ani ceh k'um üng, Jesuh naw jah pan law lü ani veia cit hngaki. ");
INSERT INTO dao_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesuh cun ani hmuh te am ani ksing. ");
INSERT INTO dao_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Acunüng Jesuh naw, “Nani ceh maha i nani sumkyamki ni?” ti lü jah kthäh se, thuisei ni lü ngdüiki xawi. ");
INSERT INTO dao_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Acunüng, Kalawpah naki naw, “Jerusalem khawa tuhmüngawi iyawa awmih am na ksingkia khin hin nang däng aw?” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ani naw, “Ia ngkhaw ni?” ti se, anini naw, “Sahma Nazaret Jesuh, Pamhnam ja khyang avana hmuha a pyenksak la a bilawh üng a ngming ngthanga mawng, ");
INSERT INTO dao_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ktaiyü ngvai he la mi ngvai he naw hnim vaia ami mso, kutlamktung khana ami taiha mawng cen, ");
INSERT INTO dao_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Isarel he jah küikyan khaia kami ngaih’uhei, acuna kyanak cun tuhngawi üng mhmüp thum law pängki. ");
INSERT INTO dao_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Acuna thea pi kami vei üngka nghnumi he, khaw ngawilam ksika a ng'uhnak ng’uhnüna va cit u lü ami jah cäicatei law sak, ");
INSERT INTO dao_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","a yawk am hmu u lü, ‘Pamhnama khankhawngsä he ami hmuha ngdang lawki he naw, Ani xüng ve tia pyen ve u,’ ami ti law. ");
INSERT INTO dao_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Acunüng, kami veia ka avang ng’uhnüna cit u lü, nghnumi hea pyen lawa kba, ami va hmuh, cunsepi, amät cun am ami hmuh,” ani ti. ");
INSERT INTO dao_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Acunüng, Jesuh naw, “Khyang k'ang he aw, sahma hea pyen avan am kcang na thei khaia angki he aw! ");
INSERT INTO dao_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mesijah naw acun avan cun khamei lü a hlüngtainaka lut khaia am kya kungki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Acunüng, Mosi la sahma he avana yük üng tünei lü Pamhnama cangcim avan üng amäta mawngma ng’yuki avana suilam a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Acunüng, ani cehnak vaia ngnam ani pha law hlü üng, Jesuh cun acuna khaw khye lü, athuknaka cit khaia kba ngtün se, ");
INSERT INTO dao_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","anini naw, “Kani veia awmeia khaw mü lü khaw pi mthan law hlü ve,” ti ni se, acunüng ani hlawnga awm khaia lutki. ");
INSERT INTO dao_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Acunüng Jesuh naw ani veia buh ei khaia, a ngawh üng, muk lo lü, josenak am kbeki naw, bo lü, a jah pet. ");
INSERT INTO dao_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Acunüng, ani mik vai law se, Jesuh ni tia ani ksing law üng Jesuh cun khyükeiki. ");
INSERT INTO dao_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Acunüng, axüisaw xawi naw, “Lama a jah ngthuheipüi üng, Pamhnama Cangcim he a jah mtheh k’um üng, ni mlung k'uma meidäikia mäih am kyakia kya kung aih se?” tia, animät ngthäh kyuki xawi. ");
INSERT INTO dao_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Acun la ngdüi law ni lü Jerusalema cit beki xawi naw, xaleiat he la ani püi he awm hmaihki he cun jah hmu ni se amimi naw, ");
INSERT INTO dao_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Bawipa tho law be kcang ve, Sihmona veia pi ngdangki ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Acunüng, anini naw pi lam ani ceh k'um üng, akya lawa mawng, muk bo se, a müi ani ksing lawa mawng cun ani pyen hnga. ");
INSERT INTO dao_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Acuna ngthu ani pyen k'um üng, Jesuh ami ksunga ngdüi law lü, “Nami khana dim’yenak ve se,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cunsepi, aktäa ngmüimkhya hmuki hea ngai u lü, ngpyangki he. ");
INSERT INTO dao_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Cunsepi Jesuh naw, “Ise nami khuikhaki ni? Ise nami mlungmthin k'uma mlung hlawthlatnak awmki ni? ");
INSERT INTO dao_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“Ka kut la ka khawpha he jah teng ua keiha ni ka kya ve, na hnet u lü na teng u; nami na hmuha kba ngmüimkhya naw mtisa la yuh am ta naw,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Acukba a pyen khap üng, a kut la a khawpha he a jah mhmuh. ");
INSERT INTO dao_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Acunüng, ami jekyai law nganga phäha, am kcang na pha u lü, ami awm k'um üng, Jesuh naw, “Ei vai iyaw nami taki aw?” ti lü, a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Acunüng ami sawng päng nga amtawn ami pet. ");
INSERT INTO dao_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Acunüng lo lü ami ma a ei. ");
INSERT INTO dao_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Acunüng, Jesuh naw, “Mosia thum, sahma hea cayuknak la mküinaka ng’äi üng, keia mawng ng’yuki avan kümkawi law khai tia, nami hlawnga ka awm üng ka ning jah mtheh khawi cun ahin he ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Acunüng, Pamhnama ngthu ami ksingnak vaia ami mlung a jah vaisak; ");
INSERT INTO dao_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","acunüng, ami veia, “Mesijah naw khuikhanak khamei lü, amhmüp thum üng thihnak üngka naw tho be khai, ");
INSERT INTO dao_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A ngming am, ngjutnaka ngthu la, katnak mhlätnaka ngthu, Jerusalem khaw üngka naw tün lü, khyang avana veia sang khai he, tia ng’yuki,’ ");
INSERT INTO dao_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Nangmi cun ahin hea saksiha nami kyaki ni. ");
INSERT INTO dao_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Acunüng, ka pa naw a pyen nami khana ka tüi law khai; cunsepi, khana johit am nami yah hlana küt üng Jerusalema a na k’äih ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Acunüng Jesuh naw axüisaw he mlüh üngka naw Bethanih khawa jah cehpüiki naw a kut säng lü josenak am a jah kbe. ");
INSERT INTO dao_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Acukba josenak a jah pet k’um üng axüisaw hea awmnak üngka naw khankhawa kai beki. ");
INSERT INTO dao_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Axüisaw he cun sawhkhah u lü, jekyai leng leng u lü, Jerusalema nghlat beki he. ");
INSERT INTO dao_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Acunüng, Pamhnam mküimto u lü, Temple üng awm nglätki he.");
INSERT INTO dao_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Akcük ma säiha Ngthu a na veki; Ngthu cun Mhnam am atänga veki, Ngthu cun Mhnama kyaki. ");
INSERT INTO dao_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ngthu cun akcük ma säih üngkhyüh Mhnam am a na veki. ");
INSERT INTO dao_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ahmäi naküt ani üngkhyüh Pamhnam naw a mhnüna kyaki; mhnünmceng naküt üng ani am ngpüikia mhnün i pi am ve. ");
INSERT INTO dao_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ngthu cun xünnaka phungnua kyaki; acuna xünnak naw khyangea vei akvai lawpüiki. ");
INSERT INTO dao_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Akvai cun anghmüpnaka vai law se, nghmüp naw am näng mkhüt. ");
INSERT INTO dao_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pamhnam naw a ngsä mat a tüih law, a ngming cun Johana kyaki. ");
INSERT INTO dao_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ani naw khyangea veia akvaia mawng cun pyen se, khyange naw ngja u lü ami jumei law vai ua phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Amät cun akvai am ni, akvaia mawng pyen khaia lawki. ");
INSERT INTO dao_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ani cun akvai kcang, khawmdek khana law lü khyang naküta khana vaiki. ");
INSERT INTO dao_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ngthu cun khawmdek khana veki, khawmdek cun ani üngkhyüh mhnünmcenga kyaki. Acunsepi khawmdek naw ani am ksing. ");
INSERT INTO dao_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Amäta khyangea veia lawki. Acunsepi, amäta khyange naw am dokhamei u. ");
INSERT INTO dao_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Acunsepi, avang naw doei lü jumei u se, Pamhnama caea thawn theinak a jah pet. ");
INSERT INTO dao_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Acun he cun nghngicima mtisa thithaü üngkhyüh cawmbei lawkie am ni. Khyanga pasang üngka naw ngtüi lawkie pi am ni u, amimia pa ta Pamhnam ni. ");
INSERT INTO dao_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ngthu cun nghngicima ngtüi lawki; bäkhäknak ja ngthungtak am be lü mi ksunga veki. Paa ca mat däka hlüngtainaka kba, a hlüngtainak cun mi hmuhki. ");
INSERT INTO dao_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johan naw ania mawng a pyen ta, ‘Ka pyen khawi cen ani ni, “Ani cun ka hnua law kyaw sepi ka maa a na ve pängki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kümceikia ania bäkhäknak am dawkyanaka thea dawkyanak mi van naw mi yahki. ");
INSERT INTO dao_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Thum cun Mosia kut üngkhyüh Pamhnam naw a jah peta kyaki. Acunsepi, bäkhäknak ja ngthungtak ta Jesuh Khritaw üngkhyüh a jah peta kyaki. ");
INSERT INTO dao_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","U naw pi Pamhnam am hmuh khawi. Pamhnam am täng lü, Paa peia veki, a Capa mat däk naw paa mawng jah ksingsak pängki. ");
INSERT INTO dao_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalema veki Judah ngvaie naw, “Nang u ni?” ti lü, kthäh acun hea ktaiyü he ja Levihe Johana veia ami jah tüih. ");
INSERT INTO dao_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Johan naw käh mjih lü, “Kei Mesijah am ni ngü,” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Amimi naw, “Nang u ni? Nang Elijah aw?” ti lü ami kthäh. Johan naw, “Am ni ngü” a ti. “Nang Sahma aw?” ami ti. Johan naw, “Am ni ngü” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Amimi naw, “Acunüng nang u ni, jah mtheha? jah tüih lawkie kami jah mthehnak be vai ami ti. Namäta mawng hin ihawkba na pyenki ni?” ti lü ami kthäh betü u. ");
INSERT INTO dao_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Johan naw, “Sahma Hesajah naw a pyena mäiha, ‘Bawipaa lawnak vai lam ngsungsak u,’ ti lü khawmkyanga ngpyangki kthaia ka kyaki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pharisee naw ami jah tüiha khyange cun naw, ");
INSERT INTO dao_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Mesijah am ni, Elijah am ni, sahmaa pi am na ni üng, ise Baptican na jah peki ni?” ti u lü ami kthäh betü u. ");
INSERT INTO dao_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johan naw, “Kei naw tui am Baptican ka jah pe khawiki, nami ksunga khyang mat am nami ksing ngdüiki. ");
INSERT INTO dao_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ani cun ka hnua law sepi, a khawdawk yüi suh pet khaia pi am nglawi ngü” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ahin avan cun Johan naw baptican a jah petnaka hnün Jordan mliktui pei Bethaniha thawnhlawkia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Angawi üng Johan naw Jesuh a veia law se hmuh lü, “Khawmdeka mkhyekatnak cehpüiki Pamhnama Toca teng u! ");
INSERT INTO dao_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Acan ni, ‘Keia kthaka dämduh bawki, ka hnua lawki kyaw, cunüngpi ka maa a na ve päng kungki ni,’ ka ti cen ani ni. ");
INSERT INTO dao_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Akcüka ani am ksing ngü, cunsepi, Isarele naw ani ami ksing law vaia, kei naw law lü tui am Baptican ka jah peki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johan naw a mawng pyen lü, “Ngmüimkhya cun müma mäiha khankhaw üngka naw kyum law lü a khana ngawki ka hmuh. ");
INSERT INTO dao_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“Akcüka ta ani ni ti am ksing ngü. Cunsepi, tui am Baptican ka jah pe khaia na tüih lawki Pamhnam naw, ‘Ngmüimkhya a khana kyum law lü a ngawhnaka khyang na hmuh üng, ani cun Ngmüimkhya Ngcim am Baptican jah pe khaia Khyang ni’ ti lü a na mtheh. ");
INSERT INTO dao_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Johan naw “Ani ka hmuh pängki, ani Pamhnama Capaa kyaki tia ka ning jah mthehki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Angawi betü üng, Johan naw axüisaw xawi nghngih am ngdüi lü, ");
INSERT INTO dao_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesuh law se hmuh lü, “Acan ni Pamhnama Toca,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Axüisaw xawi naw a pyen ngja ni lü, Jesuh läki xawi. ");
INSERT INTO dao_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesuh naw ani veia nghlat lü läk law ni se a jah hmuh üng, “I nani suiki” ti lü, a jah kthäh. Anini naw, ‘Rabbi (Saja tinak), hawia na veki?” ani ti. ");
INSERT INTO dao_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesuh naw, “Law ni lü nani hmuh khai,” a ti. Cit ni lü a venak ani hmuh, acuna mhnüp cun a hlawnga veeiki xawi; acun cun mülama (Naji kphyü bang) kyaki. ");
INSERT INTO dao_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Johana ngthu pyen ngja ni lü, Jesuh läki nghngih üngka mat cun Sihmon Pita a na Andrua kyaki. ");
INSERT INTO dao_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru naw akcüka a be Sihmon hmuh lü, “Mesijah hmuh ve ung” ti lü, a mtheh (Mesijah ti cun Khritaw tinak ni). ");
INSERT INTO dao_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Acunüng, Sihmon cun Jesuha veia a lawpüi. Jesuh naw teng lü, “Nang hin Johana capa Sihmon na ngmingnaki, Kephaa ning sui khaie,” a ti (Acun cun Pita üng täng lü, “Lung” tinaka kyaki). ");
INSERT INTO dao_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Angawi üng Jesuh Kalile khawa cit khaia a ngtün üng, Philip hmuh lü, “Na läk lawa” a ti. ( ");
INSERT INTO dao_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip cun Bethsaida mlüha kaa kyaki, acun cun Andru ja Pitaa ani venaka mlüha kyaki.) ");
INSERT INTO dao_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip naw Natanelah hmuh lü, “Mosi naw ania mawng Thum üng a yuk, sahma he naw pi a mawng ami yuk, Nazaret üngka, Josepa capa Jesuh, kami hmuhkie” ti lü a mtheh. ");
INSERT INTO dao_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanelah naw, “Nazaret mlüha cimvaiki ve khai aw?” a ti. Philip naw, “Law lü, teng lawa” a ti be. ");
INSERT INTO dao_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesuh naw, Natanelah a veia law se hmuh lü, “A mkhyenak lang am vekia Isarel khyang kcang, teng ua” ti lü, a pyen. ");
INSERT INTO dao_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanelah naw, “Nang naw ihawkba na na ksing ni?” a ti. Jesuh naw, “Philip naw am a ning khü ham lü, Fikdung phunga na ve üng ka ning hmuh päng ni” a ti be. ");
INSERT INTO dao_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanelah naw, “Rabbi, nang Pamhnama Capa ni, Isarelea Sangpuxanga pi kya veki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesuh naw, “Fikdung phunga na ve üng ka ning hmuh päng ni’ ka tia phäha na na kcangnaki aw? Ahina kthaka dämduh bawki na hmuh law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesuh bä naw, “Akcanga ka ning jah mthehki. Tuha khankhaw nghmawng lü Pamhnama khankhawngsäe Khyanga Capaa khana ju kyum jeng kai u se nami jah hmuh law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Amhnüp nghngih käna Kalile hne, Kana mlüha cambumnak veki. Acuia Jesuha nu pi veki. ");
INSERT INTO dao_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesuh ja axüisaw he pi acuia ami jah khüei hnga. ");
INSERT INTO dao_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Capyitui päih se Jesuha nu naw, “Capyitui päih ve,” ti lü Jesuh üng a mtheh. ");
INSERT INTO dao_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesuh naw, “I pawh vai ti cun, nanga na mtheh vai am hlü. Ka kcün am pha ham,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A nu naw mpyae üng, “A ning jah mtheh naküt pawh ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Judahea thuma ngcimcaihnak vaia, kalan mku ja thumkipa keh vangkia mcü khyuk veki. ");
INSERT INTO dao_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesuh naw mpyae üng, “Mcüe tui am jah kbe päih ua,” a ti. Be lü pyep khaia tui ami jah than. ");
INSERT INTO dao_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesuh naw, “Tukbäih tui avang lo u lü pawi tuiktänga veia cehpüi ua,” a ti. Mpyae naw tuiktänga veia ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pawi tuiktäng naw tui cun Capyittuia ngläüh lawki cun mdep lü, angtüi lawnak am ksing, (Tui thanki mpyae naw ta ksingki he). Acunüng cambumki khü lü, ");
INSERT INTO dao_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Khyang naküt naw akcüka Capyittui asü am jah khin na ma lü, ami awk phü käna va akpaih am jah khin na khawikie. Nang naw ta tuh vei cäpa asü am jah khin na veki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesuh naw hina müncankse akcük säih Kalile hne, Kana mlüha mdang lü a hlüngtainak mdangki. Acunüng, axüisaw he naw Jesuh jumkie. ");
INSERT INTO dao_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Acunkäna a nu, a nae ja axüisaw he am, Kapenawm mlüha cit u lü acuia khawmhnüp asäng awmkie. ");
INSERT INTO dao_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judahea Lätnak Pawi kcün pha law se, Jesuh Jerusalema jeng citki. ");
INSERT INTO dao_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Temple k'uma, se mna, to, müme jah jawikie ja, ngui mhlaikia khyange a jah hmuh. ");
INSERT INTO dao_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kpaihnak vaia yüipawk pawh lü, Temple üngka naw se mna ja toe a jah sät. Ngui mhlaikiea ami ngawhnake jah ktukhawngin lü nguikcange a jah hukxänin pet. ");
INSERT INTO dao_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Müm jawikiea üng, “Hine akcea jah cehpüi ua, ka Paa im jawihtuknaka käh pyang ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Axüisawe naw, “Na ima phäha ka ngaihngtühnak naw ka mlung k'uma na uiawng ve,” ti lü, ng’yuki ami süm law be. ");
INSERT INTO dao_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judah ngvaie naw ngthäh u lü, “Ahikba na jah pawhki. Na cangki tia a ngsingnak vaia, ia müncankse na jah mhnuh khai ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesuh naw jah msang lü, “Hina Temple kpye uki se, mhnüp kthum üng ka mdüih be khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judahe naw, “Hina Temple kum kphyükip ja khyuk so khaia sak ni. Ihawkba nang naw mhnüp kthum üng na mdüih be khawh khai ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Cunüngpi Jesuh naw Temple a ti cun amäta pumsa a pyenaka kyaki. ");
INSERT INTO dao_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Acunakyase, Jesuh thihnak üngka naw a thawh law käna, axüisaw he naw ami veia a pyen khawi süm law bekie. Acunüng cangcim ja ngthu Jesuh naw a pyen cun jumkie. ");
INSERT INTO dao_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesuh Jerusalem mlüh Lätnak Pawi buh pawhnaka ve se, müncanksee a jah pawh hmuh u lü, khyang khawhah naw ani jumkie. ");
INSERT INTO dao_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Acunsepi, Jesuh naw khyang naküt jah ksingkia kyase, khyangea veia amät naw amät am ng’apei. ");
INSERT INTO dao_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Khyanga mlung k'uma i veki ti cun ksingkia kyase, khyangea mawng ani üng u naw i a mtheh vai am hlü. ");
INSERT INTO dao_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pharise üngka khyang mat Nikawdim ngming naki, Judahea mkhawng veki. ");
INSERT INTO dao_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ani cun mthana Jesuha veia law lü, “Rabbi, nang Pamhnama vei üngka naw lawkia saja, ti kami ksingki. Isetiakyaküng, müncanksee na jah pawha mäih, Pamhnam am ngpüikia u naw am jah pawh khawh,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesuh naw msang lü, “Akcanga ka ning mthehki, am hmi bekia khyang naw Pamhnama Khaw am hmu thei,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikawdim naw, “Ihawkba khyang axü käna hmi be thei khai ni? A nua pum k'uma lut be lü anghngihnak hmi law be thei khai aw?” ti lü a kthäh be. ");
INSERT INTO dao_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesuh naw, “Akcanga ka ning mthehki, tui ja Ngmüimkhya üng am hmi bekia khyang Pamhnama Khawa am lut thei. ");
INSERT INTO dao_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nghngicim üng hmi lawki cun nghngicim khyanga kya lü, Ngmüimkhya üng hmiki cun ngmüimkhya khyanga kyaki. ");
INSERT INTO dao_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Na hmi be vai ka tia phäha käh cäia. ");
INSERT INTO dao_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Khawkhi a ngaihnak da khiki. A khi kthai na ngja kyawki, lüpi hawia khyüh law lü, haw da citki ti am ksingki. Au pi Ngmüimkhya üng hmiki cun acukba ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikawdim naw msang lü, “Ihawkba acukba thawn thei khai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesuh naw, “Nang cun Isarele khyangmjü üng saja kyäpa pi kya lü, ahin am na ksingki aw? ");
INSERT INTO dao_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","“Akcanga ka ning mthehki, kami ksing ning jah mtheh lü, kami hmuh kami ning jah mhnuh khawiki. Acunüng mat naw pi kami pyen am doei uki. ");
INSERT INTO dao_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","“Khawmdeka mawng ka ning jah mtheh üng am nami na kcangnak üng ta, khankhawa mawng ka ning jah mtheh üng ihawkba nami na kcangnak khai ni? ");
INSERT INTO dao_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Khana khyüh kyum lawki Khyanga Capaa thea, u khana am kai khawi. ");
INSERT INTO dao_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Mosi naw khawmkyanga tangka am pyang kphyu lup a taiha mäiha, Khyanga Capa pi taiha kya khai. ");
INSERT INTO dao_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","“Au pi Ani jumki naküt naw angsäi xünnak yah khaie. ");
INSERT INTO dao_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Pamhnam naw khawmdek a mhläkphyanak leng lenga phäh a Capa mat däk a jah pet. Ani jumki naküt cun käh thi ti lü angsäia xünnak yah khaie. ");
INSERT INTO dao_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Pamhnam naw a Capa, khawmdeka a tüih law cun ngthumkhyah khaia a tüih law am ni. Khawmdek küikyan Bawi vaia a tüih law ni. ");
INSERT INTO dao_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“A Capa jumki cun ngthumkhyahnak am khamei. Acunsepi, Ania ngming am jumki cun Pamhnam Capa mat däk am a jumeia phäha, ngthumkhyahnak khamei pängkia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Hin hin, ngthumkhyahnaka kyaki. Pamhnama akvai khawmdek khana lawki, acunsepi nghngicime naw ami bilawh am a dawa phäha, akvaia kthaka nghmüp jawng na bawkie. ");
INSERT INTO dao_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","“Isetiakyaküng, am dawki bilokie naw akvai cun hnengkie, ami bilawh angdang vai kyüh u lü akvaia veia am law u. ");
INSERT INTO dao_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","“Acunsepi, akcang bilokie naw Pamhnama mtheh ami ngjaka mawngma akvai naw mdan khaia, akvai da law khawikie,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Acunkäna, Jesuh ja axüisaw he cun acuia ve u lü khyange am baptican a jah petnak khawia hnün Judah khaw ngnamea citkie. ");
INSERT INTO dao_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Johan naw Salim pei Anon, acuia tui a daa phäha, baptican a jah pe k’um üng, law u lü Baptican khan lawkie. ");
INSERT INTO dao_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Acunüng, Johan thawngim üng am khyum ham u. ");
INSERT INTO dao_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Acuia Johana xüisawe avang ja Judahea nglak üng, khawning ngcimcaihnaka mawng ngcuhnak ve lawki. ");
INSERT INTO dao_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Johana veia law u lü, “Saja aw, tenga, Jordan mliktuia nghngilawa na hlawnga veki, a mawng na pyen naw Baptican jah pe se, khyang ami van a veia cit ve u,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johan naw jah msang lü, “Au naw pi, khana khyüh am pet üng ta i am yah khawh. ");
INSERT INTO dao_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Kei Mesijah am ni, acunsepi, kei cun ania maa tüih lawa ka kyaki ni’ ka ti cen nangmi hin ka ning jah saksie ni. ");
INSERT INTO dao_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Cambumkia cangpyang üng va cangla cun sängeiki. Cunsepi cangpyanga peia ngdüi lü cangpyanga kthai ngjaki a nglawipüi cun naw cangpyanga kthai a ngjak üng jekyaiki. Acukba ni ka jenak akümbe. ");
INSERT INTO dao_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","“Ani hlüngtai law dämdäm se, kei ka ju nem phätphät khai. ");
INSERT INTO dao_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Khan üngkhyüh lawki cun avana kthaka dämduh bawki ni. Mce üngka cun mce üng sängei lü khawmdeka mawngma va pyetksaki. Cunüngpi, Khankhaw üngkhyüh lawki cun anaküta khana dämduh bawki ni. ");
INSERT INTO dao_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","“A hmuh ja a ngjak jah mtheh kyaw sepi, a pyen u naw pi am dokhamei u. ");
INSERT INTO dao_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","“Au pi, a pyen dokhamki cun Pamhnam cangki tia mdangki ni. ");
INSERT INTO dao_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","“Pamhnama tüih lawa khyang cun naw Mhnama ngthu pyenki. Isetiakyaküng, Pamhnam naw ani üng kümceikia a Ngmüimkhya a peta phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Pa naw a Capa mhläkphya na lü, ahmäi naküt a kut üng a msum. ");
INSERT INTO dao_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Au pi, a Capa jumki naw anglät xünnak yahki; au pi a Capa am jumki naküt naw xünnak am yah. Pamhnama mkhuimkhanaka kea ve khaie,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesuh naw Johana kthaka Baptican jah pe lü, axüisaw hea jah pyangki tia mawng, Pharisee naw ngjakie. ");
INSERT INTO dao_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Akcanga ta, Jesuh amät naw baptican am jah pe, axüisaw he naw ami jah peta kyaki), ");
INSERT INTO dao_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ami pyena mawng Jesuh naw a ngjak ja Judah khaw ceh ta lü, Kalile khaw da, ");
INSERT INTO dao_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samarih khaw sunpah lü cit yahki. ");
INSERT INTO dao_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jakop naw a capa Josep üng a peta khaw pei, Samarih khaw hne Sukhar mlüha pha lawki. ");
INSERT INTO dao_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Acuia Jakopa tuikhui veki. Jesuh lam a lawnak bawngbai lü, tuikhui peia ngawki. Acun cun mhnüp ngsunga kyaki. ");
INSERT INTO dao_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samarih nghnumi tui than khaia law se Jesuh naw, “Ka awk vai tui na pea,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Acun k'um üng, axüisaw he cun mlüh k’uma ei vai khyäi acun hea citkie.) ");
INSERT INTO dao_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samarih nghnumi naw, “Ihawkba, nang Judah khyang naw, kei Samarih nghnumia veia tui na awk vai na täeiki ni?” ti lü, a kthäh be. (Judah khyang mjüe cun Samarih khyangea eiawknak tuikhawt üng eiawk am thum na u.) ");
INSERT INTO dao_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesuh naw, “Pamhnam naw nang üng i ning pet hlüki ti am ksingki, u naw tui ning täeiki ti pi am ksingki. Na ksinga ta, angsäia xünnak tui ning pet vaia na na täei khai sü,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nghnumi naw, “Saja aw, tuikhui thuki, vähnak vai tuipung pi am na taki. Hawia kaa xünnak tui na taki ni? ");
INSERT INTO dao_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","“Hina tuikhui, amät naw aw khawi lü, a cae ja, a khyüngseie naw pi ami awk khawi, kami pu Jakop naw a jah pet, nang ania kthaka kyäp bawk aih lü,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesuh naw msang lü, “Hina tui awki naküt ta, tui cawi be ham khai. ");
INSERT INTO dao_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Acunsepi, kei naw ka pet vaia tui awki naküt ta, tui am cawi ti. Kei naw ka pet vaia tui cun a puk k'uma hna lü, angsäi xünnak tuia kya se, anglät xünnak pi yah khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nghnumi naw, “Saja aw, tui am cawi ti lü, tui than khaia hia käh ka law be ti vaia, acuna tui na pea,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesuh naw, “Cita, na cei va khü lü, law bea,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nghnumi naw, “Ka cei am ve,” ti se, Jesuh naw, “Ka cei am ve na ti cang veki, ");
INSERT INTO dao_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Na cei mhma ve pängki, tuh na vepüi pi na ceia am kya; acen üng akcang pyen veki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nghnumi naw, “Saja aw, sahma mata na kya khaia ning ksing veng. ");
INSERT INTO dao_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Kami pupae naw hina mcung üng Pamhnam a na hjawkhah khawikie. Nangmi Judahe naw, ‘Jerusalema ni Pamhnam hjawkhahnak’ nami tiki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesuh naw, “Nghnumi aw, ka pyen hin juma. Khyang he naw Pa cun ahina mcung ja Jerusalem mlüha am ami hjawkhahnak tia kcün pha law khai. ");
INSERT INTO dao_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","“Nangmi Samarihe naw nami hjawkhah am ksing uki. Cunüngpi, keimi Judahe naw ta u kami hjawkhahki ti kami ksingki. Isetiakyaküng, küikyannak cun Judahe üngka naw lawkia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Acunsepi, akcün pha law khai, hjawkhahkie naw Ngmüimkhya ja akcanga ami hjawkhah vai cun tukbäih yea kya ve. Pa naw acukba hjawkhah khaie jah hlüeiki. ");
INSERT INTO dao_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","“Mhnam cun Ngmüimkhyaa kyaki. Hjawkhahki naküt naw Ngmüimkhya ja ngthungtak am hjawkhah yah vai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nghnumi naw, “Mesijah law khai ti ka ksingki. Ani a law üng, ani naw ahmäi naküt jah mtheh law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesuh naw, “Nang ning ngthuheipüiki hin ani ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Acunüng axüisaw he law bekie naw nghnumi am a na ngthuhei se hmuh u lü müncankie. Acunsepi, u naw pi, “I na ngaihki? Ise hina nghnumi na ngthuheipüiki ni?” ti lü, am kthäh u. ");
INSERT INTO dao_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nghnumi naw a tui um hawih hüt lü, a lawnak khaw da citki naw khyange üng jah mtheh lü, ");
INSERT INTO dao_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Law ua, ka awmih khawi naküt ksingkia khyang mat ve ve, teng law u. Mesijah am niki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mlüh ceh ta u lü, Jesuha veia citkie. ");
INSERT INTO dao_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Acun k'um üng axüisaw he naw, “Rabbi, na ei eia” ti lü, ami mtheh. ");
INSERT INTO dao_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Acunsepi Jesuh naw, “Nangmi naw am nami ksing ka ei vai ta veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Axüisawe amimät üng, “A ei vai tha lawki veki aw” ti lü, ngthähkie. ");
INSERT INTO dao_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesuh naw, “Na tüih lawkia a ngjak hlü bilawh ja, a khut kpäng vai cun keia eiawka kyaki ni. ");
INSERT INTO dao_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“‘Khya kphyü ve hamki, acun käna cang ahnaka kcün pha law khai’ am nami ti khawiki aw? Teng u, ka ning jah mthehki, mang hü u lü, loe jah teng süm ua, hmin päng lü, ah vai kcün ve u. ");
INSERT INTO dao_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Atki naw ngkhyengnak yah lü anglät xünnak vaia a ktheipai mcun ve, sawki ja atki ani nghngih atänga je yüm khai xawi. ");
INSERT INTO dao_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Ahin üng, ‘mat naw saw se, mat naw atki’ tia khuisui cun cang ve. ");
INSERT INTO dao_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","“Am nami khüinak khawia loa cang at khaia ka ning jah tüihki. Acuia akce he naw khüi u se, ami khüinak kce cun nangmia ngmangnak ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Acunüng, “Ka awmih naküt ksingki ve ve,” tia, ngthu, nghnumi naw a pyena phäha Samarih khyang khawhah naw Jesuh jum lawkie. ");
INSERT INTO dao_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samarih khyange Jesuh veia ami law üng ami veia a ve vaia nghui na u se, acuia Jesuh cun mhnüp nghngih awmki. ");
INSERT INTO dao_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesuh a ngthu pyena phäh khyang khawkän naw jum lawkie. ");
INSERT INTO dao_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Acunakyase, nghnumia veia, “Tuh ta, nanga pyena phäha am kya lü, kamimät naw kami ngjak ja akcanga hin hin khawmdeka Küikyan Bawia kyaki ti, kami ksinga phäha kami jumki,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Amhnüp nghngih käna, acun üngka naw Kalile hne da citki. ");
INSERT INTO dao_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Isetiakyaküng, Jesuh amät naw, “Sahma cun amäta hminaka khawa mhlünmtainak am yah khawi naw,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jerusalem Lätnak Pawia cit u lü Pawi k’um üng Jesuh naw a jah pawhmsah naküt jah hmukie naw ta, Kalile khawa Jesuh a law üng, Kalile khyange naw dokhamkie. ");
INSERT INTO dao_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Acun käna Jesuh Kalile khaw Kana, tui cun capyituia a nglatnak sak hnüna law beki. Acuia khyang ngvai mat a capa Kapenawm mlüha a mhnatei veki. ");
INSERT INTO dao_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ani naw Jesuh Judah khaw üngka naw Kalile khawa lawki ti a ngjak üng, a capa thih law hlüki, law lü a mdaw law be vaia cit lü a va nghuinak. ");
INSERT INTO dao_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesuh naw, “U naw pi müncanksee ja cäiletnake am nami hmuh üng amdanga am jum hlü uki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Khyang ngvai naw, “Saja aw, ka ca am a thih ham üng akjanga lawa,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesuh naw, “Cit bea, na capa daw be khai ni,” a ti. Khyang ngvai cun Jesuha pyen jum lü nghlat beki. ");
INSERT INTO dao_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A nghlat be lama a mpyae naw a na khyum u lü, “Na capa dawei law be ve,” ti lü, ami mtheh. ");
INSERT INTO dao_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ngvai naw iti üng a capa a daw law bea mawng jah kthäh se, amimi naw, “Müta, mü lam naji mat üng mhnat naw khyah ve,” ti lü, ami mtheh. ");
INSERT INTO dao_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jesuh naw, “Na capa daw be khai ni,” a tinaka kcüna kyaki ti a ksing. Acunakyase, amät ja a khuiim kyawnglawng ami van naw jumkie. ");
INSERT INTO dao_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ahin cun Jesuh Judah khaw üngka naw Kalile khawa a law käna anghngihnak müncankse a pawha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Acunkäna Judahea pawi mat ve se, Jesuh Jerusalema citki. ");
INSERT INTO dao_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem mlüh, To Mkawt peia Hebru läk am Bethzatha ami ti luhnak mhma lawki tui büm mat veki. ");
INSERT INTO dao_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Am phetkia khyang khawhah, amikmü, akhawkxo, ja a kut khaw thikie ngjän u lü, tuia a ngsün law vai mtäteikie. ");
INSERT INTO dao_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Isetiakyaküng, Bawipaa khankhawngsä, akcün kcün üng tui büm üng kyum law lü, tui a ksün ksün law. Acunüng, au pi, tuia ngsün päng ja tuia khana kco maki cun a natnak naküt daw be khawiki. ");
INSERT INTO dao_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Khyang mat kum thumkip ja khyet kunki veki. ");
INSERT INTO dao_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesuh naw acukba khawvei ve päng lü ngjänki ti ksing lü a hmuh üng, “Na daw be vai na ngja hlüki aw?” ti lü, a kthäh. ");
INSERT INTO dao_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ani naw, “Saja aw, tuia ngsün law üng tui büm da na kaih khai u am ve. Ka law k’um üng akce he naw na khe u lü kcoei ma thakthakie,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesuh naw, “Tho law, na ngjänak lo lü cita,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Angxita ani cun daw beki. A ngjänak lo lü citki. Acuna mhnüp cun Sabbath mhnüpa kyaki. ");
INSERT INTO dao_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Judah ngvaie naw daw bekia veia, “Tuhngawi Sabbath mhnüpa kyaki. Judah Thuma tuhngawi na ngjännak käh na kawh hü vai,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ani naw jah msang lü, “Na mdaw beki naw, ‘Na ngjännak lo lü cita’ a ti ni, ti lü a jah mtheh be. ");
INSERT INTO dao_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Amimi naw, “Na ngjännak lo lü cita tiki u ni?” ti lü, ami kthäh. ");
INSERT INTO dao_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Acunsepi, Jesuh khyangea ksunga khyükei se, ani mdaw bekia Jesuh cun u hmana am ksing. ");
INSERT INTO dao_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Acun käna, Jesuh naw acuna khyang cun Temple a k'uma hmu be lü, “Tenga, na daw be pängki. Käh mkhyekat be ti kawpi; am ani üng ta, ahina ksetam bawk lü na khana pha law khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Daw bekia khyang cun cit lü, ani mdaw beki cun Jesuh ni ti lü Judah ngvaie üng a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Acukba sabbath mhnüp üng a bilawha phäha Judah ngvaie naw Jesuh mkhuimkhakie. ");
INSERT INTO dao_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesuh naw jah msang lü, “Ka Pa aläa khüikia kyase, kei pi ka khüiki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesuh Sabbath käh jeih lü, Mhnam pi amäta Pa ni tia a pyen ja, amät Mhnam am tängkia a pyena phäha, Judah ngvaie naw hnim law hlü bawkbawkie. ");
INSERT INTO dao_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesuh naw jah msang lü, “Akcanga ka ning jah mthehki, Capa amät naw i am pawh thei. Acunsepi, Pa naw a pawh hmu lü pawhki. Pa naw a pawh naküt cun Capa naw pi acukba pawhki. ");
INSERT INTO dao_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","“Pa naw Capa mhläkphya na lü, ahmäi amäta pawh naküt mhnuhki. Nami müncan vaia Pa naw Capa üng ahina kthaka däm bawkie jah mdang law khai. ");
INSERT INTO dao_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pa naw akthie jah mtho be lü, xünnak a jah peta mäiha, akcanga Capa naw pi a hlüeia khyang üng xünnak pe khai. ");
INSERT INTO dao_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pa naw ua lei am mtai, acunsepi, ngthumkhyahnak avan Capa üng a pet päng. ");
INSERT INTO dao_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","“Acun cun, Pa ami leisawnga mäiha khyang naküt naw Capa pi leisawng law khaie. Capa am leisawngki cun ani tüih lawki Pa am leisawngkia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Akcanga, ka ning jah mthehki, ka ngthu ngai lü na tüih lawki jumki naw angsäi xünnak yahki. Ngthumkhyahnak käh khamei khai, thihnak üngka naw xünnak pha pängki ni. ");
INSERT INTO dao_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Akcanga ka ning jah mthehki, thi pängki he naw Pamhnama Capa a ngkhü kthai ngja acun he. Ngjakia khyang naküt a xüng be vaia kcün pha law khai, akcanga ta pha law pängki ni. ");
INSERT INTO dao_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","“Pa amät cun xünnaka phung ania mäiha, Pa naw Capa pi xünnaka phunga kyasaki. ");
INSERT INTO dao_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Acunüng, ngthumkhyahnak vaia ana pi a pet ni. Isetiakyaküng, ani cun Khyanga Capa ania phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ahina phäha käh müncan ua, lungdüa awmki he naküt naw Capa kthai ami ngjaknak vaia kcün pha law khai, ");
INSERT INTO dao_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","akdaw bilokie tho be u lü xünnak yah u se, akse bilokie tho be u lü mkatnak khamei khaie. ");
INSERT INTO dao_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Kamät naw i am pawh thei nawng. Ka ngjaka mäiha lei ka mtaiki; ka ngthumkhyah ngkhaiki. Isetiakyaküng, kamäta ngjak hlü käh sui lü, Pa na tüih lawkia ngjak hlü ka suia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kamäta mawngma ka saksi üng ka saksi cangki ti mdangnak vai am ve. ");
INSERT INTO dao_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","“Ka mawng saksiki akce veki; ani naw ka mawng a saksi cangki ti ka ksingki. ");
INSERT INTO dao_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Johana veia ngsä tüih uki se, ani naw ngthungtak saksi khai. ");
INSERT INTO dao_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Khyang he naw ka mawng ihawkba ami saksi üng kei am ngtungjin nawng. Acunsepi nangmi küikyannak nami yah vaia phäh hin ka pyena kyaki. ");
INSERT INTO dao_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","“Johan cun däi lü vaikia meiim mat am tängki. Ania kvai asäng nami jenak vaia nami ngja hlükie. ");
INSERT INTO dao_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Kei naw Johana saksia kthaka dawki saksi ka taki. Isetiakyaküng, Pa naw a na peta khut ka biki. Ka bia khut naw Pa naw a na tüih law ti cun mdanki. ");
INSERT INTO dao_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Acunüng, na tüih lawkia Pa naw pi keia mawng na saksi petki. Iti üngpi a kthai ngja lü a hmai am hmu khawi uki. ");
INSERT INTO dao_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A tüih law am nami jumeia phäh, Pamhnama ngthu pyen pi nami mlunga am kenei uki. ");
INSERT INTO dao_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Cangcima k'uma angsäia xünnak nami hmu khaia ngai u lü, cangcim nami khe khawi jaiki. Acuna cangcim cun keia mawng saksikia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","“Acunsepi, xünnak nami yah khaia ka veia am law hlü uki. ");
INSERT INTO dao_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Khyanga mhlünmtainak am sui nawng. ");
INSERT INTO dao_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Cunsepi, nangmi cun ia khyang mjü ti ka ksingki. Pamhnam nami mlungmthin kcang üng am nami mhläkphyanak pi ka ksingki. ");
INSERT INTO dao_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","“Ka pa a ngming üng law ngü se, am na dokham uki. Amäta ngming üng lawki khyang ani vai sü ta nami dokham khaie sü. ");
INSERT INTO dao_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Pamhnam mat däka vei üngka naw lawkia hlüngtainak käh sui u lü, namimät üngka hlüngtainak nami hlawheikie naw kei ihawkba nami na jum thei khai ni? ");
INSERT INTO dao_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kei naw, Paa veia ka ning jah khya khaia käh ngai u. Nami üpnak Mosi naw va ning jah khya khai. ");
INSERT INTO dao_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","“Mosi nami jum üng kei nami na jum khai. Isetiüng, ani naw keia mawng va yuk hütki. ");
INSERT INTO dao_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","“Cunsepi, ania yuk am nami jum üng, ihawkba keia pyen nami jum khai?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Acunkäna, Jesuh Kalile Tuili, Tiberi Tuili pi ngmingnaki, a caye kama citki. ");
INSERT INTO dao_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Am phetkie a jah mdaw bea müncanksee hmukie khyangpänu naw läk hükie. ");
INSERT INTO dao_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesuh mcunga kai lü acuia axüisaw he am ngaw yümkie. ");
INSERT INTO dao_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judahea Lätnak Pawi cun cäh law betüki. ");
INSERT INTO dao_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesuh naw mang hü lü khyang aktäkpai a veia lawkie a jah hmuh. Philip üng, “Hinea ei khyawh vai, hawia mi khei khai ni?” ti lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(I pawh vai cun a ksing päng kyaw, Philip a mhnütnaka a pyena kyaki.) ");
INSERT INTO dao_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip naw, “Nguikcang phyanghngih am kheih muk ta, hine naw apica cim ei u sepi am khäk khai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Axüisaw üngka mat, Sihmon Pitaa na Andru naw, ");
INSERT INTO dao_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Hia kpamica hnasen mat naw kyung muk mhma ja ngaca nghngih taki ve ve. Acunüng pi khyang hikäna phäh am khäk hlü ve?” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesuh naw, “Jah ngawhsak ua,” a ti. (Acuna hnün cun msai aktäa sahki.) Khyang avan ngawkie, kpami däk thawngmhma lawkie. ");
INSERT INTO dao_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesuh naw muk lo lü, Pamhnama veia jenak mthehki. Acun käna axüisaw he üng jah pe se, amimi naw ngawhkie üng ami jah pet. Acukba bäa nga pi ami ngaih kän käna ami jah pet u. ");
INSERT INTO dao_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ami phü käna Jesuh naw, axüisaw he üng, “Apica pi käh bawkya khaia akhläi jah mkhäm be ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Muk nglung mhma cim ami eia khläi mkhäm be u se, cä xaleinghngih üng beki. ");
INSERT INTO dao_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Acun üng Jesuha pawh müncankse hmukia khyange naw, “Akcanga hin hin, khawmdek khana law khaia Sahma kcang ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Khyang he naw man lü asihlinga ami sangpuxanga mcawn hlükie ti Jesuh naw ksingki. Acunakyase, mcunga amät kaiki. ");
INSERT INTO dao_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Khaw mü law se axüisaw he tuili da ju citkie. ");
INSERT INTO dao_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mlawng üng kai lü, tuilia a caye Kapenawm mlüha citkie. Khaw nghmüp law sepi, Jesuh ami veia am pha law ham. ");
INSERT INTO dao_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Khaw aknuia khi law se, tui ngnawk law lü kyan law dämdämki. ");
INSERT INTO dao_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mäng kthum kphyü bang tui vak u lü ami pha käna, Jesuh tuia khana law lü mlawng da cäh law se ami hmu üng kyüeikie. ");
INSERT INTO dao_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesuh naw, “Kei ni; käh na kyüei ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mlawng üng Jesuh a na do law u se, angxita ami cehnak vaia kawng mlawng am va phakie. ");
INSERT INTO dao_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Angawi üng, tuili caye kawnga vekia khyange naw mlawng mat däk va veki ti ksing lawkie. Jesuh pi mlawng üng axüisaw hea hlawnga am ve se, axüisaw he amimät mlawng üng citei u se, ami jah hmu. ");
INSERT INTO dao_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tiberi mlüh üngkhyüh Mlawng akce he cun, Bawipa naw Pamhnam üng jenak a mtheh käna muk ami einaka peia lawkie. ");
INSERT INTO dao_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Khyang he naw Jesuh ja axüisaw he acuia am ve u se ami jah hmu üng, amimät mlawnge üng kai u lü, Kapenawm mlüha Jesuh sui khaia citkie. ");
INSERT INTO dao_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Khyang he naw tuili cayea Jesuh a ve hmu u lü, “Rabbi, iti üng ahia na lawki ni?” ti lü, ami kthäh u. ");
INSERT INTO dao_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesuh naw jah msang lü, “Akcanga ka ning jah mthehki: müncanksee nami hmuha phäha nami na suikia am kya, muk ei lü nami phüa phäh nami na suikie ni. ");
INSERT INTO dao_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","“Pyüpye theikia ei käh ktha na u. Khyanga Capa naw a ning jah pet vaia ei, angsäi xünnak ktha na u. Isetiakyaküng, Pa Pamhnam naw amäta msingnak cun Jesuha khana a tak ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Amimi naw, “Pamhnama mlung hlü kami pawhnak vaia, i kami pawh üng daw khai ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesuh naw, “A tüih lawa khyang nami jumei cun Pamhnama mlung hlü nami pawhkia kyaki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Amimi naw, “Hmu lü kami ning jumnak law vaia, ia müncankse ja na bi kawm? I ja na pawh kawm? ");
INSERT INTO dao_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‘Amimi naw muk ami ei vai khana khyüh jah peki’ ti lü, ami yuka mäiha, kami pupae naw manah khawmkyanga eikie,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesuh naw, “Akcanga ka ning jah mthehki: khana ka muk cen Mosia ning jah pet am ni. Khankhawa ka muk kcang ning jah peki ta keia Pa ni. ");
INSERT INTO dao_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","“Pamhnama ning jah pet muk cun naw khankhaw üngkhyüh kyum law lü, khawmdek üng xünnak peki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Amimi naw, “Bawipa aw, acuna muk aläa jah pea,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesuh naw, “Kei cun xünnak muka ka kyaki. Ka veia lawki naküt naw ei am cawi be ti; kei na jumki naküt naw tui am xai be ti,” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nangmi naw nami na hmuha kpheia am na jumei uki, ti ka ning jah mthehki. ");
INSERT INTO dao_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","“Ka Pa naw a na pet naküt ka veia law khaie. Ka veia lawki naküt kei naw am jah nghei ta ngü. ");
INSERT INTO dao_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Isetiakyaküng, kamäta ngjak hlü ka pawh khaia khana khyüh ka kyum lawki am ni. Na tüih lawkia a ngjak hlü ka pawh khaia ka lawki ni. ");
INSERT INTO dao_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","“Na tüih lawkia a ngjak hlü cun a na pete u pi käh jah mkhyüh lü, akpäihnaka khawmhnüp üng avan ka jah xünsak be khai. ");
INSERT INTO dao_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Ka paa ngjak hlü cun Capa hmu lü jumki naküt naw angsäi xünnak a yahnak vai ja, kei naw akpäihnaka khawmhnüp üng ka jah xünsak be khaia kyaki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesuh naw, “Kei khana khyüh ka kyum lawkia muk ni,” a tia phäha Judahe naw aktäa am ngja hlü u. ");
INSERT INTO dao_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Hin hin Jesuh, Josepa capa; a pa ja a nu pi mi jah ksing am niki aw? Ihawkba, ‘Kei khana khyüh ka kyum lawki’ a ti ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesuh naw, “Namimät naw käh ngcuh ti ua. ");
INSERT INTO dao_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","“Na tüih lawkia Pa naw lam am a msüm üng, u ka veia am law thei khai ni. Akpäihnaka khawmhnüp üng ka jah xünsak be khai. ");
INSERT INTO dao_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","‘‘Ami van Pamhnam naw jah mthei khai’ ti lü, sahma he naw ami yuka mäiha, Ka Paa mtheh ngja lü ngtheingthangki naküt ka veia lawki. ");
INSERT INTO dao_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Pamhnama veia ka däka thea, u naw Pa am hmu khawi; Ani däk naw ni a hmuh. ");
INSERT INTO dao_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Akcanga ka ning jah mthehki: kei na jumki naw angsäi xünnak yahki. ");
INSERT INTO dao_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Kei cun xünnak muka ka kyaki. ");
INSERT INTO dao_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“Nami pupae naw khawkhyawng khawa manah ei kyaw u lü pi, amimi cun thikie. ");
INSERT INTO dao_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Cunüngpi khankhaw üngkhyüh kyum lawki hina muk ei nakütki naw thihnak am hmu ti. ");
INSERT INTO dao_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Kei cun khana khyüh kyum lawkia xünnaka muk ni. Acuna muk eiki cun angsäia xüng khai. Khawmdeka xünnak vaia ka ning jah pet vaia muk ta ka mtisa hin ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judahe amimät thüi lü ngcuh u lü, “Hina khyang naw ihawkba a mtisa ei vaia jah pe hlü theiki ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesuh naw, “Akcanga ka ning jah mthehki: Khyanga Capa a mtisa am ei lü, a thisen am awkia khyang naw xünnak am yah. ");
INSERT INTO dao_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","“Ka mtisa ei lü, ka thi awki naküt naw angsäi xünnak yah khai. Akpäihnaka khawmhnüp üng ka jah mtho be khai. ");
INSERT INTO dao_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Isetiakyaküng, ka mtisa cun ei vai kcanga kya lü, ka thisen pi awk vai kcanga kyaki. ");
INSERT INTO dao_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","“Ka mtisa ei lü, ka thisen awki cun kei üng xüng se, kei pi ani üng ka xüng khai. ");
INSERT INTO dao_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Xüngseikia Pa naw na tüih law lü ania phäh kei ka xüngseia kba, ka mtisa eiki naküt cun keia phäh üng xüng khai. ");
INSERT INTO dao_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","“Hin ni khana khyüh kyum lawki xünnaka muk ta. Nami pupae naw ei u lü akäna ami thihnaka mäih am ni. Ahin eikia khyang naküt cun angsäia xüng khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ahin Jesuh naw, Kapenawm mlüh, sinakoka k'uma a jah mthei üng a pyena kyaki. ");
INSERT INTO dao_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Axüisawe khawhah naw ahin ami ngjak üng, “Hina mtheinak akhak hin u naw ksing khawh khai ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","U naw am mtheh xa se, axüisaw he naw a pyen küisakie ti Jesuh naw a ksing üng, “Hina phäha nami mlung seki aw? ");
INSERT INTO dao_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“Khyanga Capa asüa a venaka kai be se nami hmu vai sü ta, ikba nami ti khai sü aw? ");
INSERT INTO dao_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Xünnak peki cun Pamhnama Ngmüimkhya ni. Khyanga khyaihnak naw i am khyaih khawh. Ka ning jah mtheha ngthue naküt hin naw Mhnam üngkhyüh sak xünnak ning jah peki Ngmüimkhya law püiki. ");
INSERT INTO dao_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","“Acunsepi, nangmi üng akhäk naw am na jum hlü uki,” a ti. (Akcük üngkhyüh Jesuh naw am jumkie, ja phyaheikia khyang a ksing pänga kyaki) ");
INSERT INTO dao_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesuh bä naw, “Pa naw am a lawpüia khyang cun ka veia am law thei. Acunakyase, ahin he ka ning jah mthehki ni’ ka ti,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Acunüng axüisaw he khawhah naw ceh ta u lü, am läk ti u. ");
INSERT INTO dao_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesuh naw, axüisaw he xaleinghngiha veia, “Nangmi naw pi nami na ceh ta hlüki aw?” ti se, ");
INSERT INTO dao_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sihmon Pita naw, “Bawipa aw, ua veia kami cit khai ni? Nang üng angsäi xünnaka ngthu veki. ");
INSERT INTO dao_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","“Atuh ta nang cun Pamhnam üngkhyüh law lü, Ngcingcaihkia Khyang tia jum lü kami ksingki ni,” ti lü, a msang. ");
INSERT INTO dao_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesuh naw, “Nangmi xaleinghngih cun keia ning jah xüa am nami kyaki aw? Acunsepi, nangmi üng mat cun khawyai ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesuh naw Sihmon Iskarota capa Judah a pyena kyaki. Judah cun axüisaw xaleinghngih üngkaa kya kyaw lüpi, Jesuh jawiei khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Acunkäna Jesuh Kalile hne da citki, Judahe naw hnim hlü u se Judah hne da am cit hlü. ");
INSERT INTO dao_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judahea Sam Pawi cäh law se, ");
INSERT INTO dao_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","a nae naw, “Na hnukläke naw na pawhmsah ami hmuh vaia, ahin üngkhyüh Judah hnea cita. ");
INSERT INTO dao_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","“U naw amäta ngminga ngthang vai ngja hlü lü, anghmüa i am pawh khawi u. Hin akcanga na jah pawh üng, khawmdek avan naw ksing se,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Amäta nae hngawh naw pi am jum u.) ");
INSERT INTO dao_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesuh naw, “Ka kcün am pha law ham; nangmia kcün cun aläa pha lawki. ");
INSERT INTO dao_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","“Khawmdek naw nangmi am ning jah hneng thei, ami pawhmsah am dawki ka pyena phäh kei na hnengki ni. ");
INSERT INTO dao_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","“Nangmi pawia jeng cit ua, kei ta akcün am a pha law hama phäha tuh pawia am cit hlü ham veng,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Acun jah mtheh lü, Jesuh Kalile khawa ve hamki. ");
INSERT INTO dao_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","A nae pawia ami jeng ceh käna, Jesuh pi khyangea käh ksinga anghmüa heng cit hngaki. ");
INSERT INTO dao_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judah ngvaie naw pawia sui hü u lü, “Hawia veki ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Khyang he naw Jesuha mawng ampyua sumkyemkie. Akhäk naw, “Ani ta khyang kdaw ni,” ti se, avang naw, “Am daw, khyang jah mhleiki ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Acunsepi, Judah ngvaie ami jah kyüha phäh u naw angdanga am pyen u. ");
INSERT INTO dao_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pawia nghning k’um üng, Jesuh naw Temple k’uma jeng cit lü Pamhnama ngthu jah mtheiki. ");
INSERT INTO dao_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judah ngvaie naw, “Hin, i pi am ngthei khawiki naw ihawkba kca ksingki ni?” ti u lü, münakie. ");
INSERT INTO dao_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesuh naw, “Ka ning jah mtheia ngthu hin kamäta ngaiha ka ning jah mthei am ni. Na tüi lawki Pamhnam üngkhyüh lawkia ngthua kyaki. ");
INSERT INTO dao_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","“Au pi, ania ngjak hlü biloki naw ka ngthu pyen hin Pamhnama ngthu ja, kamäta ngaiha ka pyena kyaki aw, ti cun ksing khai. ");
INSERT INTO dao_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Amäta mhnüna ngthu pyenki cun amäta dawnak, hlüngtainak vai suiki ni. Acunsepi ani tüih lawkia hlüngtainak vai suiki cun ngsungpyun lü mkhyenak ani üng am ve. ");
INSERT INTO dao_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosi naw Thum ning jah peki am niki aw? Mat naw pi Thum am nami läki. Ise nami na hnim khaia nami ngtängki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Khyang he naw, “Khawyai naw a ning venak ni; u naw ning hnim hlüki ni,” ti u lü, ami msang. ");
INSERT INTO dao_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesuh naw, “Müncankse mat ka pawh üng avan nami müncankie. ");
INSERT INTO dao_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","“Ahina phäha ni Mosi naw vun mawih vaia Thum ning jah pe se (Acun cun Mosi üng tüna am kya, nami pupae üngkhyüh tüneikia kpamica üng ami na bilawh khawia kyaki), Sabbath mhnüp üng pi kpamicaa vun nami mawikie. ");
INSERT INTO dao_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","“Sabbath üng pi kpamicaa vun mawih uki lü, Mosia Thum lümkankia am a kya üng, kei naw Sabbath mhnüp üng khyang ka mdaw bea phäh ka khana ise am nami jeki ni? ");
INSERT INTO dao_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","“Hmai teng u lü ngthu käh mkhyah ua, ngsungpyun dawkyakia mtai ua,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem mlüha ka avang naw, “Hin hin Judah ngvaie naw hnim vaia ami büa khyang am niki aw? ");
INSERT INTO dao_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Teng u, khyangea ksunga ngthu pyen se, i pi am ti na be u. Ani hin Mesijah ti lü ngvaie naw akcanga ksing pängki he aw? ");
INSERT INTO dao_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mesijah a law üng, u naw pi hawia khyüh a law am ksing. Ani ta a ngtüinak law pi khyang naküt naw mi ksing,” ami ti u. ");
INSERT INTO dao_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Acunakyase, Jesuh naw Temple k'uma a jah mthei üng ngpyang lü, “Kei hawia ka, kei u ti nami na ksing kcangkie aw? Kamäta ngjak hlüa ka lawki am ni. Na tüi lawki cun ngthungtak ni, ani am ksing uki. ");
INSERT INTO dao_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","“Kei naw ani ka ksingki. Isenitiüng, kei cun ani üngka naw ka lawki, ani naw a na tüih law ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Acunüng Jesuh man vaia ami bü kyaw, akcün am pha hamkia kyase, u naw pi am hnet u. ");
INSERT INTO dao_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Khyang avang naw ta jum u lü, “Mesijah a law üng, ania pawhmsaha kthaka daw bawki, müncanksee jah pawhmsah law khai aw” ti u lü amimät ngthäkie. ");
INSERT INTO dao_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Acukba, khyange cun Jesuha mawng sumkyemkie ti Pharisee naw ami ngjak üng, ktaiyü ngvaie am ngthäh u lü, man khaiea yekape ami jah tüih. ");
INSERT INTO dao_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesuh naw, “Asängca nami hlawnga ka ve käna, na tüi lawkia veia ka cit be khai. ");
INSERT INTO dao_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","“Nangmi naw na sui u lü pi, am na hmu uki; ka venaka pi am law thei uki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judah ngvaie amimät sumkyam u lü, “Am mi hmu ti vaia, hin hawia cit hlüki ni? Akce kcea ve hükie Krikea veia cit lü, Krike jah mthei hü hlüki aw’ ");
INSERT INTO dao_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Nangmi naw na sui u lü, am nami na hmu khai; ka venaka pi am law thei uki’ a ti hin, i a ti hlünak ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pawia akpäihnak ja akkü säihkia mhnüp üng, Jesuh ngdüiki naw, ngpyang lü, “Au pi, tui xaiki ka veia law lü aw law se. ");
INSERT INTO dao_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","“Au pi, kei na jumki cun Pamhnama cangcim üng a vea mäiha xünnak Tui Lawng cun ani üngkhyüh lawng law khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jumeikie naw Ngmüimkhya ami yahnak vaia mawng a pyenaka kyaki. Jesuh cun hlüngtainak üng am tho be hamkia kyase, Ngmüimkhya cun jah peta am kya ham. ");
INSERT INTO dao_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Khyang avang naw a pyen ngja u lü, “Hin hin Sahma kcanga kya ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Avang naw, “Ani hin Mesijah ni,” ami ti. Avange naw pi, “Kalile khaw üngka naw Mesijah hmi law thei khai aw? ");
INSERT INTO dao_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mesijah cun Sangpuxang Davita ksawn üngka, Davita venaka mlüh Bethlehem üng hmi law khai ti lü cangcim üng veki” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Acukba Jesuha phäha khyange ngtaikie. ");
INSERT INTO dao_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Avange naw ta man vai ami jum, acunsepi u naw pi am hnet dat u. ");
INSERT INTO dao_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yekape ami ceh be üng, ktaiyü ngvaie ja Pharisee naw “Ise am nami lawpüi ni?” ti u se, ");
INSERT INTO dao_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","yekape naw, “Ania mäiha u naw ngthu am pyen khawi” ti lü ami jah msang be. ");
INSERT INTO dao_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pharisee naw, “Nangmi pi a ning jah nghmawngmhlei hnga aw? ");
INSERT INTO dao_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Ngvaie ja Pharisee üngka ani jumki nami ksing khawiki aw? ");
INSERT INTO dao_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","“Mosia Thum am ksingkia khyange ta yüncenak khamei ve u,” ti lü, ami pyen. ");
INSERT INTO dao_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ahlana mthana Jesuha veia lawkia Pharise üngka khyang mat Nikawdim naw, ");
INSERT INTO dao_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Amäta mpyawng ye üng a ngthu am ngja kaa, a pawhmsah am hmu kaa, mi Thum üng khyang am mi cijang khawi,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Amimi naw, “Nang pi Kalile khyanga na kya hngaki aw? Cangcim üng tenga, Kalile khaw üng sahma, u am hmi law khawi,” ti lü na hmu khai. ");
INSERT INTO dao_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Amimäta im phähphäha cit bekie. Acunüng pi, Jesuh cun Olip Mcunga kaiki. ");
INSERT INTO dao_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ngawilama Templea law be se, khyang naküt a veia lawkie. Acunüng, Jesuh naw ngaw lü jah mtheiki. ");
INSERT INTO dao_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Thum mthei he ja Pharisee naw nghnumi mat kpami am bäühmaki xawi lawpüi u lü; avana maa ami ngdüihsak. ");
INSERT INTO dao_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesuha veia, “Saja aw, hina nghnumi kpami am ani bäühma k’um bäbä üng ami mana kyaki. ");
INSERT INTO dao_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","“Mi Thum üng, Mosi naw hina mäih cun lung am vawi ngen vaia ngthu a mkhyah. Nang naw ihawkba na ngaiki ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Acuna ngthu cun Jesuh mhnüteinaka, a mkhyenak ami suinaka ami kthäha kyaki. Acunsepi Jesuh naw ngmüm lü, a kut mdawng am mdek üng kca yuki. ");
INSERT INTO dao_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kthäh laihlaih u se, ngkyäk law be lü, “Nangmi üng am mkhyekat khawikia khyang naw akcüka lung am vawi se,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Acunüng, ngmüm betü lü a kut mdawng am mdek üng yuk betüki. ");
INSERT INTO dao_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","A pyen ami ngjak üng, amimäta mkhyenake ksing law u lü, axü säih üngka naw akdik säih cäpa mat cia khyük be päihkie. Acunüng Jesuh amät däk ve se, nghnumi anglung üng a venak kung üng veki. ");
INSERT INTO dao_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesuh naw a ngmümnak üngkhyüh ngkyäk law be lü, nghnumi amät däk ve se a hmu üng, “Nghnumi aw, hawia ni ami ve u? Ning mkatei khai u pi am ve se mä?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nghnumi naw, “Bawipa aw, u naw am na mkat ve,” a ti. Jesuh naw, “Kei naw pi am ning mkat veng; cit be lü tuh üngkhyüh ta käh mkhyekat ti kawpi,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesuh naw ami veia ngthu pyen be lü, “Kei cun khawmdeka kvaia ka kyaki. Ka hnu läki naküt cun nghmüpa k'um üng käh xünsei ti lü, xünnaka kvai yahei khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisee naw, “Namäta mawng na pyenki, na pyen am cang ve,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesuh naw, “Kamäta ngthu ka pyen üngpi ka pyen cangki. Isenitiüng, kei naw ka lawnak ja ka cehnak vai ka ksingeiki. Nangmi naw ka lawnak ja ka cehnak vai am ksing uki. ");
INSERT INTO dao_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","“Nangmi naw nghngicim thum üng ngthu nami mkhyah khawiki, kei naw u am mtai pet nawng. ");
INSERT INTO dao_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","“Kei naw ngthu ka mkhyah üngpi ka ngthumkhyah cang khai. Isetiakyaküng, kei kamät däk am ni. Na tüih lawki Pa kei üng a ngpüia phäh ni. ");
INSERT INTO dao_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Nami Thum üng, ‘Ai pi cangki ti ksing vaia saksi nghngih hlüki,” ti lü, ng’yuki. ");
INSERT INTO dao_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","“Kei kamäta ngthu ka saksiki, Pa na tüih lawki naw pi ka mawng saksiki,” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Acunkäna amimi naw, “Na Pa hawia ni?” ti lü ami kthäh. Jesuh naw, “Nangmi naw kei am na ksing uki, ka Pa pi am ksing uki. Kei nami na ksing üng ka Pa pi nami ksing khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Acuna ngthu cun Temple k'uma khawthem petnaka hnüna a jah mtheia kyaki. Cunsepi u naw pi akcün am küm law hamkia kyase am man u. ");
INSERT INTO dao_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesuh naw, “Kei naw akcea ka ning jah ceh ta khai; nangmi naw nami na sui hü khaie. Cunüngpi nami mkhyekatnake üng nami thi khaie. Ka cehnaka am cit thei uki,” ti lü, a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judah ngvaie naw, ‘“Ka cehnaka am cit thei uki,” a ti hin amät nghnimei hlü bang se,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesuh naw, “Nangmi ta khawmdek üng nami sängeiki, kei ta khan üngkhyüh ka lawki. Nangmi cun hina khawmdek üngkhyüh nami ngtüi lawkia kya lü, kei ta khawmdek üng am sängei ve ngü. ");
INSERT INTO dao_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","“Acunakyase, ‘Nami mkhyekatnake üng nami thi khai’ ka ti ni. ‘Kei cun Ania Ka Kyaki’ ti am nami jum üng nami mkhyekatnake üng nami thi kcang khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Amimi naw, “Nang u ni?” ti u se, Jesuh naw“Akcüka nami veia ka pyen khawi cen, ");
INSERT INTO dao_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","nangmia phäha ka pyen vai ja, ka ning jah mkatnak vai khawhah veki. Na tüih lawki cun ngthungtak üng kümceiki; ani üngkhyüh ka ngjak naküt khawmdek üng ka mtheh khawiki,” ti lü a jah msang be. ");
INSERT INTO dao_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesuh naw ami veia a pyena Paa mawng cun am ngjakkya u. ");
INSERT INTO dao_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Acunakyase, Jesuh naw, “Khyanga Capa nami taih käna, ‘‘Kei cun Ania Ka Kyaki’ ti nami ksing law khai. Acun käna, kei naw kamäta ngjak hlüa i am pawh lü, Pa naw a na mtheha mäih cia hina ngthu ka pyenki ti nami ksing law khai. ");
INSERT INTO dao_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","“Na tüih lawki kei üng atänga veki. Kamätca am na hawih. Isetiakyaküng, aläa ania ngjak hlüa ka pawhmsaha phäh kyaki,” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Acuna ngthu a pyen ngjakia khyang khawhah naw jumkie. ");
INSERT INTO dao_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesuh naw jumeiki Judahea veia, “Ka ngthu pyen nami ngjak üng, ka xüisawea nami kya kcang khai. ");
INSERT INTO dao_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","“Ngthungtak nami ksing üng, ngthungtak naw ning jah lätsak khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Amimi naw, “Abrahama mjüa kami kyaki, tuh vei cäpa usüma mpyaa am thawn khawi u nawng, ‘Lätlangnak nami yah khai’ ti hin, i na tinak ni?” ti lü ami kthäh betü. ");
INSERT INTO dao_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesuh naw, “Akcanga ka ning jah mthehki: mkhyekatnak pawhki naküt cun mkhyenaka mpyaa kyaki. ");
INSERT INTO dao_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","“Mpya cun ima asäng ni a ve khawi; capa ta angläta ima ve khawiki. ");
INSERT INTO dao_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","“Acunakyase, Capa naw mpya üngkhyüh a ning jah mhlät üng, nami lät kcang khaie. ");
INSERT INTO dao_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Abrahama mjüa nami kyaki ti ka ksingki. Acunsepi, na hnim khaia nami bü hin, keia mtheimthangnak am nami dodangeia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","“Ka Paa na mhnuh naküt ka pyenki. Acunüng pi nangmi naw nami paa ning jah mtheh nami pawhkie” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Amimi naw, “Keimia pa ta Abraham” ami ti. Jesuh naw, “Abrahama caea nami kya üng Abrahama a awmiha mäiha nami awmih khai sü. ");
INSERT INTO dao_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","“Pamhnama veia ngthungtak ka ngjak naküt ning jah mtheh ngü se, nami na hnim hlüki. Abraham ahikba am ve khawi naw. ");
INSERT INTO dao_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","“Nangmi hin nami paa vea mäiha nami awmki he ni,” a ti. Amimi naw, “Pamhnam däk ni kami pa, ania jah ca kcang ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesuh naw, “Pamhnam nami Pa ani üng nami na mhläkphya na khai sü; Pamhnam üngka naw va ka lawki, kamäta ngaiha ka lawkia am ni, ani naw a na tüih law ni. ");
INSERT INTO dao_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Ise ka pyena suilam am nami ngjakyaki he ni? Ka ngthu pyen am nami ngaih hlüa phäh, am nami ngjakkya u ni. ");
INSERT INTO dao_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Nangmi cun nami pa Khawyama canaa nami kyaka phäh, nami paa ngjak hlü bi vai ni nami mlung ngaih. Khawyam cun akcüka khyüh khyang k’hnima kyaki. Ngthungtak am vekia kyase, ngthungtak üng am xüngsei. A ngthuei üngpi, hleihlak lü hleihlaknaka pa a thawna phäh, amät am ngkäki va anaküt biloki. ");
INSERT INTO dao_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Ngthungtak ka pyena phäh, nangmi naw am nami na jumki. ");
INSERT INTO dao_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Ka mkhyekatnak mdang thei khai u nami veki ni? Ngthungtak ka pyen üng nangmi naw ise am nami na jumkie ni? ");
INSERT INTO dao_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","“Pamhnam üngkhyüh ngtüiki naw Pamhnama ngthu ngai khawiki, nangmi cun Pamhnam üngkhyüh am nami ngtüikia kyase Pamhnama ngthu am nami ngaiki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judahe naw, “Nang Samarih khyang, khawyaia venaka kya veki kami ti hin am kami cangki aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesuh naw, “Khawyaia venaka am kya nawng. Ka Pa ka leisawngki, cunüng pi nangmi naw am na leisawng ve uki. ");
INSERT INTO dao_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Kei naw ta kamät ami na leisawngnak vai am sui veng; acun suihjap lü keia phäh cijangki mat veki. ");
INSERT INTO dao_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","“Akcanga ka ning jah mthehki: ka ngthu ngaiki naküt isüm käh thi khai,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judahe naw, “Khawyaia venaka na kyak hman tuh ni kami ksing ve u. Abraham ja sahma he pi thi päng u se, nang naw ‘Na ngthu ngaiki naküt isüm käh thi khai’ ti veki. ");
INSERT INTO dao_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","“Kami pu, Abraham kthaka na däm bawki aw? Ani pi thi pängki, sahma he pi thi pängki he . Namät hin ua na ngaieiki ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesuh naw, “Kamät ka mhlünmtaiei üng, ia käh ka mawng khai. ‘Kami Pamhnam,’ nami tia, ka Pa naw na mhlünmtaiki ni. ");
INSERT INTO dao_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","“Nangmi naw ani am ksing khawi uki. Cunüng pi, kei naw ta ani ka ksingki. ‘Ani am ksing nawng’ ka ti üng nangmia mäiha ka hleihlak hngakia kya khai. Acunakyase, ani ksing lü, a mtheh ka ngjaki. ");
INSERT INTO dao_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Nami pa Abraham naw, ka law vaia khawmhnüp a hmuh vaia phäh jekyaiki. Acunüng, hmu law lü je khütki,” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judahe naw, “Na kum mhmakip pi am law ham lü, Abraham na hmuki pängki aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesuh naw, “Akcanga ka ning jah mthehki: Abraham am a ve ham üng, ka veki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ami vawihnak vaia lung jah loei u se, Jesuh cun ngthup lü, Temple üngkhyüh akcea citki. ");
INSERT INTO dao_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesuh lama a ceh k’um üng, a hmi law üngkhyüh a mik müki khyang mat a hmuh. ");
INSERT INTO dao_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Axüisawe naw, “Saja aw, a mik müa hmiki hin ua mkhyenaka phäha ni? Amäta mkhyenaka phäh aw, a nupaa ani mkhyenaka phäh aw?” ti lü, ami kthäh u. ");
INSERT INTO dao_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesuh naw, “Amäta mkhyenaka phäh am ni, a nupaa mkhyenaka phäha pi am ni. Ani üng Pamhnama johit khyange naw ami hmuh vaia phäha ni. ");
INSERT INTO dao_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","“A mhnüp ham üng na tüih lawkia khut mi pawh khai. U naw pi khut am a binak theia mthan pha law hlüki. ");
INSERT INTO dao_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","“Khawmdeka khana ka vea küt üng khawmdeka kvaia ka kyaki,” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Acukba a pyen käna, mdek üng a mci msawh lü, a mci am mdek mthaü lü acun am a mikmüa mik a jut. ");
INSERT INTO dao_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A mikmü üng, “Cit lü Silawng Tuili üng va hmaieia,” a ti. (Silawng ti cun “Tüih” tinak ni) Acunüng, cit lü va hmaiei se a mik vai law beki. ");
INSERT INTO dao_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A impei locenge ja, ahlana täei se hmu khawikie naw, “Hin hin ngaw lü täei khawiki am niki aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Avang naw, “Acun ni” ami ti. Avang naw, “Acun ta am ni” a tängpüi ni” ami ti. Amät naw, “Kei acun ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Amimi naw, “Na mik ihawkba vai beki?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ani naw, “Jesuh ami ti naw mdek mthaü lü, ka mik üng jut lü, ‘Silawng Tuilia va cit lü va hmaieia’ ti se, cit lü hmaiei ngü se ka mik vai law beki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Ani hawia veki ni?” ti lü a mi kthäh üng, ani naw “Am ksing veng” a ti be. ");
INSERT INTO dao_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","A mik mü khawikia khyang cun Phariseea veia ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesuh naw mdek mthaü lü a mik a vaisak bea mhnüp cun Sabbath mhnüpa kyaki. ");
INSERT INTO dao_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pharisee naw, a mik a vai law bea mawng kthäh u se, ani naw, “Lawk am ka mik na nawi se, hmaei lü, ka hmu law be theiki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharise avang naw, “Acuna khyang naw Sabbath am a jeiha phäha, Pamhnama üngkhyüh lawki ta am ni khü vai,” ami ti. Avang naw, “Khyangka naw ihawkba hina mäih müncanksee jah pawh khawh khai aw?” ami ti. Phariseea ksunga ngtainak ve lawki. ");
INSERT INTO dao_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Acun käna, amikmü üng, “Na mik a vaisak bea phäha, nang naw ihawkba ani na ngaiki ni?” ti u lü, ami kthäh betü üng, “Ani cun Sahma ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judah ngvaie naw, a mik vai law bekia nu ja pa, am ami jah khü ham veia, amikmü khawiki vai law beki ni tia mawng am kcang na u. ");
INSERT INTO dao_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","A nu ja a paa üng, “Hin hin nami ca, amikmüa hmi lawki nami ti khawi am niki aw? Ihawkba atuh hmu law be theiki ni?” ti u lü, ami jah kthäh. ");
INSERT INTO dao_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A nu ja pa naw, “Hin kami ca ti kami ksingki, amikmüa hmi lawki ti pi kami ksing. ");
INSERT INTO dao_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Cunsepi, ihawkba atuh hmu law beki ti am kani ksingki, hmuhsak beki pi am ksing ve ning. Amät kthäh ua; khyang teh lawki; amäta mawng cun amät naw pyen se,” ti ni lü, ani jah msang. ");
INSERT INTO dao_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A nu ja pa naw Judah ngvaie ami jah kyüha phäha acukba ani pyena kyaki. Am acun ham üng pi, “Ani cun Mesijah ni” tiki naküt cun sinakok üngkhyüh ksät vaia ami mkhyäp thüpthüpa kyaki. ");
INSERT INTO dao_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Acunakyase, a nu ja pa naw, “Khyang teh lawki, amät kthäh ua” ani tia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Anghngihnaka amikmüa hmi lawki cun khü betü u lü, “Pamhnama veia akcang ka pyen khai tia sitih taa, nang ning mdaw beki cun khyangka ti kami ksingki ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ani naw, “Khyangka a ni ja am a ni am ksing nawng. Mat ka ksing cun ahlana ka mik mü khawiki, tuh ka hmu law beki,” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Amimi naw, “Na khana i ja a pawh? Na mik ihawkba ja a vaisak be?” ti lü, ami kthäh. ");
INSERT INTO dao_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ani naw, “Cükta üng ka ning jah mtheh päng, am nami na ngai hlüki. Ise nami ngja hlü betükie ni? Nangmi pi axüisaw hea nami thawn hngaa nami yüki aw?” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Amimi naw ksekha na u lü, “Nang hin ania xüisawa na kyaki ni, keimi ta Mosia axüisaw he ni. ");
INSERT INTO dao_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Pamhnam naw Mosi ngthuhei püiki ti kami ksingki, cunüngpi Jesuh hawia ka naw lawki ti am ksing u nawng,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","“Ani naw ka mik vaisak be kyaw sepi, ani hawia khyüh lawki ti am nami ksing hin müncankse ni. ");
INSERT INTO dao_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","“Pamhnam naw khyangkaa ngthu am ngai khawiki ti mi ksingki. Acunsepi, au naw pi Pamhnam mhläkphya na lü a ngjakhlü a pawh üng Pamhnam naw ngaih pet khawiki. ");
INSERT INTO dao_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","“Khawmdek a ngtüi üngkhyüh, a mikmüa hmi lawki vaisak be ve u, tia u naw am mi ngja khawi. ");
INSERT INTO dao_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","“Hin hin Pamhnam üngkhyüh lawki am a ni ta, i am pawh khawh,” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Amimi naw, “Na hmi law üng, mkhyenake am hmi law lü, na jah mthei lawki aw?” ti u lü, msangkie naw, Sinakok üngka naw ami ksät u. ");
INSERT INTO dao_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ksätkie ti Jesuh naw ksing lü hmuki naw, “Khyanga Capa na jumki aw?” ti lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ani naw, “Bawipa aw, ka jum law vaia, ani u ni na mtheha?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesuh naw, “Ani na hmu päng ni, atuh ning ngthuheipüiki hin ani ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ani naw, “Bawipa aw, jum veng,” ti lü, Jesuh hjawkhahki. ");
INSERT INTO dao_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesuh naw, “Ngthumkhyah khaia hina khawmdek khana ka lawki, amikmüea mik vai be lü, a mik kvaiea mik a münak vaia ka lawki ni,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ahlawnga vekia Pharisee naw, acun ngja u lü, “Keimi pi kami mik mü hngaki aw?” ti lü, ami kthäh u. ");
INSERT INTO dao_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesuh naw, “Nami mik a mü üng mkhyenak am ta uki. Acunsepi, atuh ‘Kami mik vaiki’ nami tia phäh nami mkhyekatki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesuh naw“Akcanga ka ning jah mthehki: to ngvawng mkawt üng käh lut lü, akce üngka naw kai lü lutki cun mpyukeiea ja tome manei hlükiea kyaki. ");
INSERT INTO dao_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","“Mkawt üng lutkia khyang cun toksäma kyaki. ");
INSERT INTO dao_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","“Mkawt mtät naw ani cun mkawt nghmawn pet se, toe naw a kthai ksing khawikie; amäta toe ami ngming phähphäh am jah khü lü kpunga jah ceh püi khawiki. ");
INSERT INTO dao_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","“Kpunga a jah khü üng, ami hmaia cit lü lam jah msüm se ani cun läk khawikie. Isetiakyaküng, a kthai cun a toe naw ksingki he. ");
INSERT INTO dao_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","“Acunsepi, khyang kce cun a kthai am ami ksinga kyase, am läk u, dawngin ta khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ahina msuimcäpnak Jesuh naw jah mtheh se, i a ti hlü hman am ksing u. ");
INSERT INTO dao_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Acunüng, Jesuh naw, “Akcanga ka ning jah mthehki: kei cun toe phäh mkawta ka kyaki. ");
INSERT INTO dao_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Keia hmaia law maki naküt cun mpyukei ja tome manei hlükiea kyaki he, to naw pi a kthai am jah ngja. ");
INSERT INTO dao_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Kei mkawta ka kyaki. Kei üngkhyüh lutki naküt naw küikyanak yah khai; a k’uma lut lü, akpunga lut law lü, a ei vai hmu khai. ");
INSERT INTO dao_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Mpyukei cun mpyu khai, hnim khai ja kpye khaia va law khawiki. Kei cun xünnak ami yahnak vai däka am kya lü kümkawikia xünnak ami yah vaia phäha ka lawki ni. ");
INSERT INTO dao_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Kei toksäm kdawa ka kyaki; toksäm kdaw naw toea phäha a sak tawn khawhki. ");
INSERT INTO dao_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","“Toksäm am niki, ami ngvaha toksäm naw mhnge law se a hmuh üng toe jah hawih lü jah dawng ta se, mhnge naw toe jah hutei lü jah kpyang khawiki. ");
INSERT INTO dao_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","“Ami ngvaha toksäm cun ngvaha kyase, toe am jah cäi na lü jah dawng taki. ");
INSERT INTO dao_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Kei cun dawkia toksäm ni. Pa naw na ksing se kei naw pi Pa ka ksinga mäiha, ka toe ka jah ksingki. Ka toe naw pi na ksingki he. “Ami phäha ta ka thih khawhki. ");
INSERT INTO dao_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Ahina to ngvawnga k'uma am veki toe pi ka jah ta hamki. Acun he pi ka jah lawpüi khai. Acun he naw pi ka kthai ngai u se, to pä mat, toksäm mat däka kya law khai. ");
INSERT INTO dao_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kei naw ka sak tawn lü, xünnak ka yah be khaia kyase, Pa naw na mhläkphyanaki. ");
INSERT INTO dao_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","“U naw ka sak am lak thei. Kamäta hlüeia ka sak ka pet ni. Ka sak cun pe lü, ka loei be khawhnaka khyaibahnak ka taki. Ahina ngthupet hin ka Paa veia ka yaha kyaki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Acuna ngthua phäha Judahea ksunga ngtainak ve lawki. ");
INSERT INTO dao_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aknung bawk naw, “Ani üng khawyai umki ni, yawki ni; ise a ngthu nami ngaiki ni?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Avang naw, “Khawyaia venak naw ahin he am jah pyen thei. Khawyai naw ihawkba amikmüe jah vaisak be khawh khai ni? ami ti. ");
INSERT INTO dao_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Khawksik khya üng Jerusalem mlüh Temple Kainaka Pawi veki. ");
INSERT INTO dao_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesuh cun Temple k'um, Solamon Luhnak üng ve hlü se, ");
INSERT INTO dao_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judahe naw a peia ngbäm law u lü, “Am ngsingngkyaikia i vei na ve ham khai ni? Mesijah na kyak üng angsinga jah mtheha,” ti lü kthähkie. ");
INSERT INTO dao_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesuh naw, “Ka ning jah mtheh päng ni, am nami jumki; ka Paa ngming am khut ka pawhe cun ka saksie ni. ");
INSERT INTO dao_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","“Acunsepi, ka toea am nami nia phäh, am na jum uki.” ");
INSERT INTO dao_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“Ka toe naw ka kthai ksing khawikie, kei naw jah ksing ngü se, na läk law khawikie. ");
INSERT INTO dao_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Amimi üng angsäia xünnak ka jah pet, i tia pi am thi u. Amimi cun u naw pi am na jah hutei thei u. ");
INSERT INTO dao_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","“Amimi na jah pekia ka Pa cun anaküta kthaka hlüngtai bawki; u naw pi Paa kut üngka am loei thei. ");
INSERT INTO dao_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","“Kei ja ka Pa cun mata kani kyaki,” a ti. ");
INSERT INTO dao_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Judahe naw ami khawngnak vaia lung loei betükie. ");
INSERT INTO dao_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Cunsepi Jesuh naw jah msang lü, “Nami hmuha Pa naw a na pet khut akdaw khawhah ka pawhki ni, ia phäha lung am nami na khawng hlüki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judahe naw, “Khut akdaw na pawha phäha lung am kami ning khawng hlüki am ni. Pa na pyenkse ja, nang nghngicim khyanga kya kphei lü Mhnama na ngsuieia phäh ni,” ti lü, ami msang. ");
INSERT INTO dao_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesuh naw, “Namimäta Thum üng, ‘Nangmi cun mhnamea nami kyaki ka ti’ ti lü am ng’yuk mä? ");
INSERT INTO dao_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Cangcima pyen naküt cun anghläia cangki ti mi ksingki. Pamhnam naw mhnamea a jah suia khyange üng a ngthu jah peki. ");
INSERT INTO dao_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Pa naw mcawn lü khawmdek khana a na tüih law kei naw, ‘Kei Mhnama Capa ka tia phäha, ‘Mhnam na pyenkseki’ nami na tinaki aw? ");
INSERT INTO dao_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Ka Paa ngjak hlü am ka pawh üng, käh na jum kawm uki. ");
INSERT INTO dao_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","“Acunsepi, ka Pa a khut ka pawh üng ta, kei am nami na jum üng pi, Pa kei üng a ve ja Pa üng kei ka vea mawng ahun nami ksing hin anglät cäng khaia, ka pawhmsahea hleng ta nami jum vai sü” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jesuh man khaiea ami bü be kyaw, acunsepi, ami kut üngka naw lätei betüki. ");
INSERT INTO dao_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jordan Mliktuia caye, Johan naw akcüka Baptican a jah petnak da cit lü acuia veki. ");
INSERT INTO dao_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Khyang khawkän a veia law u lü, “Johan naw müncankse i am pawh; acunsepi Johan naw hina mawng a pyen naküt cang ve” tikie. ");
INSERT INTO dao_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Acunüng, acuia khyang khawkän naw Jesuh jumkie. ");
INSERT INTO dao_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lazaruh ngmingnaki am khyaihki cun Bethanih mlüha veki. Acuna Bethanih mlüh cun Marih ja a na Matah ami venaka kyaki. ");
INSERT INTO dao_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Hina Marih cun (A na Lazaruh am khyaihki) ksi ng’ui am Jesuh jut lü a khaw a lusam am xuh petki. ");
INSERT INTO dao_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazaruha ci xawi naw, “Bawipa aw, na mhlänak na püi am khyaih ve” ti lü Jesuh ani cük. ");
INSERT INTO dao_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesuh naw acun ksing lü, “Acuna natnak cun thihnak vaia natnak am ni; Pamhnama hlüngtainak a ngdangnak vaia kyaki ni, ahina phäha Pamhnama Capa a ngming hlüngtai khai” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesuh naw Matah, a na Marih ja Lazaruh cun aktäa jah mhläkphyanaki. ");
INSERT INTO dao_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Acunakyase, Lazaruh am khyaihki ti a ngjak käna pi am cit lü, a venaka mhnüp nghngih ve hamki. ");
INSERT INTO dao_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Acun käna, axüisaw hea üng, “Judah khawa mi cit be vai u” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Axüisawe naw, “Rabbi, ahlana Judahe naw lung am ning khawng hlükie; acuia na cit hlü betüki aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesuh naw, “Khaw mhnüp mat üng naji xaleinghngih lawki, am niki aw. Mhnüpa cit hükia khyang ta khawmdeka kvai hmuh lü am ngsukngvän khawi. ");
INSERT INTO dao_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Acunsepi, mthana a ceh hü üng akvai am vekia kyase, ngsukngvänei khawiki” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Acun a pyen päng ja, “Mi püi u Lazaruh ipki; ipki mtho be khaia ka cit khai” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Axüisawe naw, “Bawipa aw, a ih üng ta daw law be khai ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesuh naw a thiha mawng a pyen kyaw, amimi naw ipei sawxatkia ami ngaih u. ");
INSERT INTO dao_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Acunakyase, Jesuh naw, “Lazaruh thiki” ti lü angsinga a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","“Acuia am ka ve hin nami jumnak vaia, nami phäh ka jeki; acunsepi a veia mi cit vai u” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomah (Angphia ami sui) naw a püi he üng, “A thihnak üng thi hnga khaia, Saja am atänga mi cit vai u” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesuh a pha law üng, Lazaruh ami k’uhnak mhnüp kphyü law päng se a hmuh. ");
INSERT INTO dao_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethanih mlüh cun Jerusalem mlüh üngkhyüh mäng nghngih bang thuki. ");
INSERT INTO dao_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ani be thi se, Judahe cun naw jah mbawikyahpüi khaiea Matah ja Mariha veia lawkie. ");
INSERT INTO dao_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Matah naw Jesuh pha law hlüki ti a ngjak üng do khaia citki. Acunüng Marih cun ima a na veki. ");
INSERT INTO dao_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matah naw Jesuh üng, “Bawipa aw, ahia na vea ta ka be am thi khai sü. ");
INSERT INTO dao_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","“Tuh pi Pamhnama veia na kthäh naküt Pamhnam naw ning pe khai ti ka ksingki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesuh naw, “Na be tho law be khai” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matah naw, “Akpäihnaka khawmhnüp üng tho law be khai ti ka ksingki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesuh naw, “Kei hin thawhnak be ja xünnaka ka kyaki ni. Kei na jumeiki naküt cun xüng khai, a thih üngpi angsäia xüng khai; ");
INSERT INTO dao_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","xüng lü, kei na jumki naküt cun itüha pi am thi ti u. Ka pyen na jumki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Matah naw “Bawipa aw, jum veng. Nang cun khawmdeka law khaia Mesijah, Mhnama Capaa na kyaki ti jum veng” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Acukba a pyen päng ja Matah cit lü a ci Marih anghmüa khü lü, “Bawipa pha law lü ning khü ve” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Marih naw a ngjak ja tho law ngxit lü Jesuh hmuh khaia citki. ");
INSERT INTO dao_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesuh cun ngnam k'uma am lut law ham lü, Matah naw a va hmuhnak, a venaka ve hamki. ");
INSERT INTO dao_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Im k'uma mbawikyahpüi u lü awmki hea Judahe naw Marih angxita tho law lü va kco se ami hmuh üng, lungdüa kyap khaia cit hlükia ngai lü läki he. ");
INSERT INTO dao_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Marih cun Jesuha venaka a va pha üng, a hmuh ja a khaw kunga kawp lü, “Bawipa aw, hia na vea ta ka be am thi khai sü” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mariha kyah ja läk lawkiea kyah a hmuh üng Jesuha mlung aktäa na lü pukseki. ");
INSERT INTO dao_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesuh naw, “A yawk hawia nami tak ni?” a ti. Amimi naw, “Bawipa aw law lü teng lawa” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesuh naw hmu lü kyapki. ");
INSERT INTO dao_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judahe naw, “Teng u, Lazaruh ihlawka a mhläkphyanak ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Acunsepi avang naw, “Hin, amikmü pi vaisak beki am niki aw. Lazaruh pi käh thi khaia am pawh theiki aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesuh aktäa pukse lü, ng’ui hnün da lawki. Acuna ng’utnak cun mdek khüia kya lü lung am ami khaih. ");
INSERT INTO dao_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesuh naw, “Lung loa” a ti. Thikia a ci Matah naw, “Bawipa aw, a thihnak mhnüp kphyü law pängki, tuh ta thu päng khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesuh naw, “Na jum üng Pamhnama hlüngtainak na hmu khai, ti lü am ka ning mtheh pängki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Lung lo u se, Jesuh naw khana jeng mang lü, “Ka Pa aw, ka ngthu na ngaiha phäh, ning je na veng, ");
INSERT INTO dao_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","“Aläa ka ngthu na ngai khawiki ti ksing veng; acunsepi hin üng veki khyange naw kei hin nang naw na na tüih law ti ami jumnak thei vai ka pyen ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Acukba a pyen päng ja, “Lazaruh, lut lawa” ti lü, angsanga ngpyangki. ");
INSERT INTO dao_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Akthi cun a kut khaw hlawpnaka jih ja a hmai hlawpnaka jih mahmaha lut law se Jesuh naw, “Sut u lü, cehsak ua” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Marih vepüikiea Judah avang naw Jesuha bilawh hmu u lü Jesuh jumkie. ");
INSERT INTO dao_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Acunsepi avang ta Phariseea veia cit u lü, Jesuh naw a pawhmsahe ami jah va mtheh. ");
INSERT INTO dao_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ktaiyü ngvaie ja Pharisee naw Kawngci ngvaie jah ngkhämpüi u lü, “Ihawkba mi pawh khai? Hina khyang naw müncanksee khawhah pawh ve. ");
INSERT INTO dao_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ahikba mi hawihin üng ta, khyang naküt naw ani jum law u se, acunüng, Romah ngvaie naw mi Temple ja mi khyangmjü jah kpyükpye law khaie ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ami hlawnga ka khyang mat Kaiphah, acuna kum üng Ktaiyü Ngvaisäih naw, “Ise nami yawkie ni, ");
INSERT INTO dao_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","mi khyangmjü naküt a pyüpye kthaka khyang mat a thih hin daw bawki ti am nami ksingki he aw” a ti. ");
INSERT INTO dao_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Acuna ngthu cun amät naw mhnün lü a pyen sawxat am ni. Acuna kum üng Ktaiyü Ngvai säiha kyase, Jesuh cun Judah khyang mjüea phäh a thih vaia mawng malam a pyena kyaki. ");
INSERT INTO dao_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Acuna khyange däka phäh am ni lü, khawmdeka khana ngpyeng hükia Pamhnama khyange cun pumsa mata a jah mkhämnak be vai phäha pi kyaki. ");
INSERT INTO dao_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Acuna mhnüp üngkhyüh Judah ngvaie naw Jesuh hnim khaia cengkie. ");
INSERT INTO dao_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Acunakyase, Jesuh cun Judahea khaw ksunga angdanga käh citcawn hü ti lü, acun üngka naw mkyangkhawa, mlüh mat Epharam ami tia citeiki. Acuia axüisaw he am awmki he. ");
INSERT INTO dao_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judahea Lätnak Pawi cäh law se, khyang khawkän ami khaw üngka naw Jerusalem mlüha amimät naw khawning ngcingcaihnak pawi am a pha law ham üng bi khaiea jeng citkie. ");
INSERT INTO dao_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesuh sui hü u lü, Temple k’uma ngkhäm u lü, “Pawi pawhnaka am law khai aw, ihawkba nami ngaiki ni?” ti lü ami püi kthäkie. ");
INSERT INTO dao_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ktaiyü ngvaie ja Pharisee naw, Jesuh ami mannak thei vaia, au pi, a venak ksingki naw a pyen vaia ami jah mtheh. ");
INSERT INTO dao_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Lätnak Pawi a phanak vai a mhnüp khyuk üng, thi se a mthawh be Lazaruha venak, Bethanih mlüha Jesuh pha lawki. ");
INSERT INTO dao_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Acuia Jesuha mü ei vai buh pyangnaka Matah naw jah kpüiki. Acuia Lazaruh pi Jesuh am atänga ngaw hngaki. ");
INSERT INTO dao_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Marih naw aktäa a phu küikia natuh ksi ng’ui liter uma cäpcäp lawpüi lü, Jesuha khaw jah buiki naw a lusam am a xuh pet. Acuna ksi ng’ui cun im k’um naküt üng ng'uiki. ");
INSERT INTO dao_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Acunsepi, axüisaw he üngka mat, Judah Iskarot, Jesuh phyahei khai naw, ");
INSERT INTO dao_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Hina ksi ng’ui hin, ise ngui phya kthuma jawi lü, msih mpyaki he üng am a jah pet ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Msih mpyaki he a jah mpyeneia phäh acukba a pyen am ni, khyang mpyukeia a kyaa thea, nguiip cüm lü, a k’uma ngui a lawhei khawia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesuh naw, “Hawih ua, ka ng’utnak mhnüpa phäh pawh se. ");
INSERT INTO dao_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","“Msih mpyaki he cun aläa nami hlawnga awmki he ni. Kei cun aläa nami hlawnga ka ve khaia am kya” a ti. ");
INSERT INTO dao_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesuh Bethaniha veki ti Judahe naw ksing u lü, ami lawsih. Jesuh däk lawsihkie am ni, thihnak üngka naw a mthawh be Lazaruh pi ami hmuh hlüa phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ktaiyü ngvaie naw Lazaruh pi ami hnim vaia cengkie; ");
INSERT INTO dao_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lazaruha phäha Judah khyang khawhah naw jah hawih u lü, Jesuh ami juma phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Angawi üng, Lätnak Pawia lawkia khyangpänu naw Jesuh Jerusalema law hlüki ti ami ksing üng, ");
INSERT INTO dao_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nghleng hnahe jah kcüngei lü do khaia cit u lü, “Hosana, Bawipa ngming üng lawki Pamhnam naw dawkyanak pe se!” Pamhnam naw Isarelea sangpuxang dawkyanak pe se” ti lü ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesuh naw sanghngaksaü hmu lü, acuna khana ngcumki. Cangcim üng ang’yuka mäiha, ");
INSERT INTO dao_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zion mlüh aw, käh kyüheia; Tenga sanghngaksaüca üng cum lü, na sangpuxang law ve.” ");
INSERT INTO dao_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Asüa ta axüisaw he naw am ksing u. Acunsepi Jesuh mhlünmtai a ni üng, Jesuha mawng cangcim naw a pyen ja ania phäh ahikba ami bilawhe ti cun süm law bekie. ");
INSERT INTO dao_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazaruh, ng’utnak üngka naw a khü be, thihnak üngka a mthawh be üng, a peia awmki hea khyange naw pi a mawngma pyenkie. ");
INSERT INTO dao_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Acunakyase, khyange naw pi a na do u lü ümhlamkie. Acukba müncanksee jah pawhki ni ti ngjakie. ");
INSERT INTO dao_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pharisee amimät naw, “Teng u, i am mi pawh khawhki, khawmdek avan naw a hnu läk päng ve” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pawia Pamhnam hjawkhah khaia Jerusalem mlüha jeng citkie üng Krike avang pi cit hngakie. ");
INSERT INTO dao_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Acun he cun Philipa (Kalile hne Bethsaida mlüha ka kyaki) veia law u lü, “Saja aw, Jesuh kami hmu hlüki” ti lü ami nghuinak. ");
INSERT INTO dao_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip naw Andru mtheh law se ani nghngih naw Jesuh üng ani va mtheh. ");
INSERT INTO dao_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesuh naw jah msang lü, “Khyanga Capa a hlüngtainak vai akcün pha law ve. ");
INSERT INTO dao_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","“Akcanga ka ning jah mthehki: cangmci mdek üng am kya lü am a thih üng mäei khawiki. A thih üng va khawhaha ngtheipai law be khawiki. ");
INSERT INTO dao_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“A xünsak mcehnaki naküt naw a xünsak mkhyüh khai. Hina khawmdek khana a xünsak hnengki naw angsäia xünnak yah khai. ");
INSERT INTO dao_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","“Ka khut pawh hlüki naküt naw na läk law se; ka khut pawhki cun ka venaka ve hnga khai. Ka khut pawhkia khyang cun Pa naw mhlünmtai khai. ");
INSERT INTO dao_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Atuh hin ka mlung khuikha ve. I ka pyen khai ni? ‘Ka Pa aw, hina kcün hin ka khana käh kpha lawa, ka ti khai aw? Iakyasepi, ahina khuikhatnak khamei khaia ni, ka law. ");
INSERT INTO dao_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Ka Pa aw, na ngming hlüngtai se” a ti. Acunüng, “Ka mhlünmtai pängki, ka mhlünmtai betü khai” tia kthai khankhaw üngka naw a ngjak. ");
INSERT INTO dao_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A peia ngdüikia khyange naw ngja u lü, “Khaw nghmümki ni,” ti u se, avang naw, “Khankhawngsä naw ngthuhei püiki ni,” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesuh naw, “Acuna kthai cun ka phäha ngthang lawkia am ni, nangmia phäh ni. ");
INSERT INTO dao_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Tukbäih hina khawmdek ngthumkhyahnaka kcüna kyaki. Tukbäih hina khawmdek ukia sangpuxang cun ksäta kya khai. ");
INSERT INTO dao_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","“Kei, mdek üngka naw khana a na taih law üng, khyang naküt ka veia ka jah kaih khai” a ti. ");
INSERT INTO dao_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Acuna ngthu cun a thih vai ksingnak vaia a pyena kyaki. ");
INSERT INTO dao_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Khyang he naw, “Mesijah cun angdäia ve khai ti mi Thum üng kami hmuki. Nang naw, ‘Khyanga Capa mdek üngka naw khana taiha kya khai’ na ti hin, i ni? Acuna Khyanga Capa cun u ni?” ti u lü, ami msang. ");
INSERT INTO dao_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesuh naw, “Akvai asäng nami hlawnga ve ham ve. Akvai a ve k’um üng cit hü ua, am ani üng ta nghmüp naw ning jah kpha law khai ni. Nghmüp üng cit hüki naw a cehnak am ksingei khawi. ");
INSERT INTO dao_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","“Akvai a ve ham üng akvai jumei ua, akvaia canaa nami kya khai” a ti. Acun a pyen päng ja Jesuh cit lü, am ami hmuhnak vaia ngthupeiki. ");
INSERT INTO dao_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ami maa müncanksee khawkän pawh sepi Jesuh am jum u; ");
INSERT INTO dao_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Sahma Hesajah naw a na pyen: “Bawipa aw, kami pyena ngthu u naw jumki ni? Bawipa naw ua veia a johit mdanki ni?” tia ngthua kümnak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Acuna thea am jum u se, sahma Hesajah naw pyen lü, ");
INSERT INTO dao_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pamhnam naw ami mik a jah müsak, ami mlung jah nghlangsak se, acunüng ami mik naw am hmuh thei, ami lu pi cing se, ka jah mdaw be vaia, ka veia am nghlat law be thei u, ti lü Pamhnam naw pyenki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Hesajah naw Jesuha hlüngtainak hmu lü ania mawng cun a pyena kyaki. ");
INSERT INTO dao_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Acunsepi, Judah ngvaie üngka khawkän naw Jesuh jumkie. Pharisee naw sinakoka k’um üngkhyüh ami jah ksät vai kyüh u lü am phyeh u. ");
INSERT INTO dao_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mhnama jah mhlünmtaia kthaka khyanga jah mhlünmtai ami jawngnaka phäh ni. ");
INSERT INTO dao_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesuh naw, “Kei na jumki naküt cun naw, kei däk na jumki am ni, na tüi lawki pi jumki ni. ");
INSERT INTO dao_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","“Kei na hmuki cun naw, na tüi lawki pi hmuki ni. ");
INSERT INTO dao_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","“Khawmdek vaisak khaia ka lawki ni, kei na jumki naküt cun nghmüp üng am ve ti. ");
INSERT INTO dao_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ka ngthu pyen ngja lü am jum u sepi, kei naw ngthu am jah mkhya pet nawng. Khawmdek ngthumkhyah khaia ka lawki am ni, khawmdek küikyan khaia va ka lawki. ");
INSERT INTO dao_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“Kei na ma lü ka ngthu pyene am ngaiki naw ngthumkhyah pet khai mat taeiki. Ka ngthu pyen, acuna ngthu naw akpäihnaka mhnüp üng ngthumkhyah pet khai. ");
INSERT INTO dao_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Kamät naw khyaihnak am ka pyen am ni; Pa na tüih lawki naw ka pyen vai ja ka sang vai ngthu a na pet ni. ");
INSERT INTO dao_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","“Ania a na peta ngthu cun anglät xünnaka kyaki ti ka ksingki. Acunakyase, ngthu ka pyen naküt cun Pa naw a na mtheh naküta kyaki” ngpyang lü a pyen. ");
INSERT INTO dao_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lätnak Pawi a pha vai mhnüp mat a hlü ham üng, Jesuh naw hina khawmdek ceh ta lü Paa veia a cehnak vai kcün pha lawki ti ksingki. Hina khawmdeka veki a khyange cen aläa jah mhläkphyanak lü adüt vei cäpa jah kphyanaki. ");
INSERT INTO dao_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesuh ja axüisaw he naw mü buh eikie. Sihmona capa, Judaha mlung k’uma, Jesuh phyehei khaia khawyai naw a mhlawmcawk pänga kyaki. ");
INSERT INTO dao_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pa naw ahmäi a mhjum ja Mhnam üngkhyüh law lü Pamhnama veia cit be khai ti cun Jesuh naw ksingki. ");
INSERT INTO dao_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Acunakyase, buh capawi üngka naw tho law lü a jih ngvaih sut lü ngxuheinak jih a vawh. ");
INSERT INTO dao_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kbe ksung üng tui kyäi lü axüisaw hea khaw jah mthih pet lü a jih vawh am a jah xuh pet. ");
INSERT INTO dao_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sihmon Pita veia a pha law üng, “Bawipa aw, ka khaw na na mthih hlü petki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesuh naw, “Tukbäih i ka pawhmsah ti am ksing hamki; acunsepi, tuha ta na ksing law khai ni” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita naw, “Ka khaw käh na mthi sümsüm khai” a ti. Jesuh naw, “Na khaw am ka ning mthih pet üng ta keia hnukläka am kya tiki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Sihmon Pita naw, “Bawipa aw, acun ani üng ta ka khaw däk am ni lü ka kut ja ka lu pi na mthih peta” a ti. ");
INSERT INTO dao_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesuh naw, “Tui nghlawk pängki naküt ngcimki ni, i a mthih vai am hlü, a khaw däk ni a hlü. Nangmi avan ngcimcaih päng ve uki, acunsepi am ngcimcaih hamki mat ve ve” a ti. ( ");
INSERT INTO dao_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","U naw jawiei khai a ksing pänga phäha, “Nami van nami ngcimki, lüpi am ngcimki mat nami ksunga veki” a ti.) ");
INSERT INTO dao_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ami khaw jah mthih pet lü, a jih ngvaih be lü, ngaw beki naw, “Nami khana ka pawh hin asuilam nami ksingki aw? ");
INSERT INTO dao_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nangmi naw Saja aw, Bawipa aw nami na ti na khawiki. Nami cangki, ka kya kungki. ");
INSERT INTO dao_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","“Kei nami na Bawipa ja Saja hngawh naw nami khaw ka ning jah mthih pet üng, nangmi pi mat naw mata khaw nami mthih pet vai. ");
INSERT INTO dao_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","“Nami khana ka pawha mäiha nangmi naw pi nami pawh hnga vaia ka ning jah mhnuhki. ");
INSERT INTO dao_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“Akcanga ka ning jah mtheh ta: mpya cen a mahpa kthaka am däm bawk khawi; ngsäe cun pi jah tüihkia kthaka däm bawkia am kya. ");
INSERT INTO dao_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","“Ahina ngthungtak nami ksingki, nami ksinga mäiha nami xünpüi üng ta ihlawka nami jo sen khai ni. ");
INSERT INTO dao_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nami vana mawng ka pyen am ni. Ka xüe ka jah ksingki. Acunsepi, ‘Kani ei yümki naw am na ngja hlü ve’ ti lü, cangcima kümkawi lawnak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ahin hin am a pha law ham üng, atuh ka ning jah mtheh ni. Acun a pha law üng ‘Kei Ania Ka Kyaki’ ti nami jumnak thei vaia ka ning jah mtheh ni. ");
INSERT INTO dao_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Akcanga ka ning jah mthehki: au pi ka tüi law dokhameiki cun kei na dokhameiki ni; au pi ka tüi law dokhamki naw, kei pi na dokhameikia kyaki. Kei na dokhameiki naw pi na tüi lawki dokhamkia kyaki” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesuh naw acukba a pyen law päng üng a mlung khuikha lü, “Akcanga ka ning jah mthehki: nangmi üngka mat naw na phyehei khai” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","U a pyennak hman am ksing u lü axüisaw he naw ami püi ci teng lü awmki he. ");
INSERT INTO dao_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Axüisawe üngka mat, Jesuha kphyanak cun Jesuha peia ngawki. ");
INSERT INTO dao_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sihmon Pita naw, “U a pyenak ni, na mtheha” ti lü, a kut am khiktawt hü lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Acuna axüisaw naw Jesuh peia va ngnawn lü, “Bawipa aw, u ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesuh naw, “Hina muk mte mcawi lü ka peta khyanga kya khai” ti lü a msang. Muk mte mcawi lü, Sihmona capa Judah üng a pet. ");
INSERT INTO dao_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Muk mte a doei ja khawyam a k’uma lutki. Jesuh naw, “Na pawh vai akjanga pawha” a ti. ");
INSERT INTO dao_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ei kbe kunga ngawkie naw, i a pyennak ti, u naw pi am ksing u. ");
INSERT INTO dao_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Avang naw Judah Iskarot naw nguiip a cüma phäh, Jesuh naw, ‘‘Hina pawi üng mi summang vai va khyeia a tinak ni, am ani üng khuikha si mpyaki he üng ik’eih jah pea” tikia, ami ngai. ");
INSERT INTO dao_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judah naw muk mte lo lü cit ktäihki. Acun cun mthana kyaki. ");
INSERT INTO dao_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Acukba a ceh käna Jesuh naw pyen lü, “Atuh hin Khyanga Capa mhlünmtaia kya ve. Ani üngkhyüh Pamhnam pi mhlünmtaia kya ve. ");
INSERT INTO dao_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","“Ani üngkhyüh Pamhnama hlüngtainak mdan lü, Pamhnam naw Khyanga Capa pi amät üng mhlünmtai khai. Sängsäng se Pamhnam naw ani mhlünmtai khai. ");
INSERT INTO dao_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ka canae aw, nami hlawnga ka ve vai hin am hjo ti. Nami na sui hü khaie. Acunüng, Judah ngvaie üng, ‘Ka cehnak vaia am law thei uki’ ti lü ka pyena mäiha atuh pi acukba bäa ka ning jah mthehki. ");
INSERT INTO dao_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ngthumkhän kthai ka ning jah peki: mat ja mat mhläkphya na ua. Ka ning jah mhläkphyanaka mäiha mat ja mat mhläkphya na u. ");
INSERT INTO dao_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","“Mat ja mat nami mhläkphyanak üng ta, khyang naküt naw ka hnukläke tia ning jah ksing khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sihmon Pita naw, “Bawipa aw, hawia na cit khai?” a ti. Jesuh naw, “Ka cehnak hlüa nang tuh am law theiki; tuha ta na law thei khai” ti lü, a msang. ");
INSERT INTO dao_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita naw, “Bawipa aw, ise atuh na hlawnga am ka law theiki ni? Na phäha ta thih vai pi am kyüh nawng” a ti. ");
INSERT INTO dao_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesuh naw, “Keia phäha na thih vai akcanga am na kyühki aw? Akcanga ka ning mthehki: nang naw ainghlüi am khawng ham se, ani am ksing ngü ti lü kthum vei na ngcim khai” a ti. ");
INSERT INTO dao_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Käh cäicing pukse ua; Pamhnam jumei ua, kei pi na jumei ua. ");
INSERT INTO dao_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","“Ka Paa ima hnün khawhah veki, nangmia phäh hnün pyang khaia ka cit khai. Hnün am a ve üng, am a vea mawng cun ka ning jah mtheh khai. ");
INSERT INTO dao_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","“Cit lü nami phäha hnün ka pyang käna, ka nghlat law be khai. Ka venaka nami ve hnga khaia, ka ning jah la law khai, ");
INSERT INTO dao_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","“Ka cehnak vaia hnün nami ksingki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomah naw, “Bawipa aw, na cehnak vai am ksing ve ung, ihawkba lam kami ksing khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesuh naw, “Kei cun lama ka kyaki. Ngthungtaka pi ka kyaki. Xünnaka pi ka kyaki. Keia thea Pa veia cehnak vaia lam akce am ve. ");
INSERT INTO dao_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","“Kei nami na ksing pängki, ka Pa pi nami ksing khaie; tukbäih üngkhyüh cutei lü ani ksing päng lü hmu päng ve uki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip naw, “Bawipa aw, Pa jah mhnuha, acun ni kami hlüei” a ti. ");
INSERT INTO dao_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesuh naw, “Philip, hi vei nami hlawnga ve ngü se, am na na ksingki aw? Au pi kei na hmuki cun Pa hmuki ni. ‘Pa jah mhnuha’ ise na ti ni? ");
INSERT INTO dao_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","“Kei Pa üng ka ve ja Pa kei üng veki ti, am na jumki aw, Philip? Nami veia ka pyene hin kamäta mhnün ka pyena am ni. Kei üng vekia Pa naw a jah pawha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Pa üng kei ka ve ja kei üng Pa veki ti jum ua. Am ani üng ka jah pawhmsahea phäh hleng ta na jum ua. ");
INSERT INTO dao_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Akcanga ka ning jah mthehki: au pi na jumki naw ka jah pawhmsahe jah pawh khai; ahina kthaka däm bawkie pi jah pawhmsah law khai. Isetiakyaküng Paa veia ka cit khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","“Ka ngming üng ahmäi nami täsam naküt ka ning jah pawh pet khai. Acun cun Pa, Capaa phäh a hlüngtainak vaia phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","“Nangmi naw ka ngming üng ahmäi nami täsam üng, nami täsama mäiha ka ning jah pawh pet khai. ");
INSERT INTO dao_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nangmi naw nami na kphyanak üng, ka ngthumkhäne nami jah läk khai. ");
INSERT INTO dao_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“Pa kthäh ngü se, ani naw ning jah Kpüikpak khai akce ning jah pe khai. Acun naw aläa ning jah vepüi khai. ");
INSERT INTO dao_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","“Ani cun Pamhnama mawng ngthungtak pyenki, Ngmüimkhyaa kyaki. Khawmdek khyange naw ani am hmu lü am ami ksinga phäh, ani am doei khawh u. Cunüng pi nami hlawnga ve lü nami k’uma xüngkia kyase, nangmi naw ta ani nami ksingki. ");
INSERT INTO dao_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ka ceh be üng namimät ka ning hawihin khaia käh ngai ua. Nami veia ka law be khai. ");
INSERT INTO dao_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Asäng üng khawmdek naw am na hmu ti; cunsepi nangmi naw ta nami na hmu khai. Kei ka xüngseikia kyase, nangmi pi nami xüng hnga khai. ");
INSERT INTO dao_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","“Acuna mhnüp a pha law üng, kei Pa üng ka ve, nangmi kei üng nami ve ja kei nangmi üng ka ve nami ksing khai. ");
INSERT INTO dao_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Au pi ka ngthumkhäne jah yah lü, jah läklamki cun kei na mhläkphyanaki ni. Kei na mhläkphyanaki naküt ka Pa naw mhläkphya na khai. Kei naw pi ani mhläkphya na lü kamät ami veia ka ngdang khai” a ti. ");
INSERT INTO dao_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judah (Judah Iskarot am niki) naw, “Bawipa aw, khawmdeka veia am mdan lü, keimia veia namät na mdan vai cun ihawkba ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesuh naw, “Kei na mhläkphyanaki naw ka ngthu läklam se, ka Pa naw ani mhläkphya na khai. Ka Pa ja kei a veia law ni lü ani am kani ve khai. ");
INSERT INTO dao_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","“Au pi, kei am na kphyanaki naw ka ngthu am läklam; ngthu nami ngjake hin kamäta ngthu am ni, Pa na tüi lawkia ngthua kyaki. ");
INSERT INTO dao_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nami hlawnga ka ve ham vei ahin he ka ning jah mthehki. ");
INSERT INTO dao_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","“Ning jah Kpüikpak khai, Ngmüimkhya Ngcim, Pa naw ka ngming üng tüih law khai. Ani naw ahmäi ning jah mthei lü, nami veia ka pyen naküt ning jah sümsak be khai. ");
INSERT INTO dao_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Dimdeihnak ka ning jah tak hütki; kamäta dimdeihnak ka ning jah peki. Khawmdek naw a peta mäiha ka ning jah peki am ni. Käh cäicing, pukse kyühkyawk ua. ");
INSERT INTO dao_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Atuh cit kyaw ngü sepi, nami veia ka law be khai’ ka ning jah mtheh nami ngjaki. Nami na kphyanak üng ta Paa veia ka ceh vaia phäh nami je khai. Isetiakyaküng, Pa cun keia kthaka hlüngtai bawkia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Ahin a thawnhlawk law üng, nami jumnak vaia; ahin am a thawnhlawk law ham üng, atuh ka ning jah mthehki. ");
INSERT INTO dao_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Khawmdek Ukia Mdek bawipa pha law hlükia kyase, khawvei am ning jah ngthuheipüi thei nawng. Ani naw keia khana khyaihnak isüm am ta. ");
INSERT INTO dao_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","“Acunsepi kei naw Pa ka kphyanaki, Pa naw a na mtheha mäiha ka pawh ti khawmdek naw a ksing vaia phäh ni. Tho law u, hin üngka naw mi cit vai u. ");
INSERT INTO dao_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Kei Capyit ngsun kcang ni, ka Pa cun ngvawng kbia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","“Ani naw kei üng am ngtheipaikia kphyem naküt cun ksawm pat lü xawtki, am ngtheipai naküt cun khek lü pawhki. Acunüng ngcingcaih lü a ngtheipai law dämdäm vaia ksekpaih khawiki. ");
INSERT INTO dao_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Ka ning jah mtheimthang naw tuh hin ning jah ngcingcaihsak päng ve. ");
INSERT INTO dao_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","“Kei üng ngphungmanei u, kei pi nangmi üng ka ngmanei khai. Akpyeng cun a phung üng am a ngphunei üng, amät am a ngtheipai khawha mäiha, nangmi pi kei üng am ngphuneiki cun am ngtheipai thei. ");
INSERT INTO dao_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Kei hin Capyit ngsun ni, nangmi cun a kphyengma nami kyaki. Kei üng ngphuneikie veia kei pi ngphunei be ngü se, khawkäna ngtheipai khai; keia kaa i am pawh khawh uki. ");
INSERT INTO dao_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","“Kei üng am ngphunmaneikie cun khyawngkia akpyenga mäiha xawtin vaia kyaki. Acukba a kphyem cun mkhäm lü mei üng mkhihin u se, mei naw jah ui khawiki. ");
INSERT INTO dao_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Nangmi kei üng ve u lü ka ngthu nangmi üng a ve üng, nami hlüei naküt nami täsam üng nami yah khai. ");
INSERT INTO dao_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","“Ka Paa hlüngtainak cun khawkäna nami ngtheipainak naw mdanki. ");
INSERT INTO dao_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Pa naw a na kphyanaka mäiha ka ning jah kphyanaki. Ka kphyanaka kea xüngsei ua. ");
INSERT INTO dao_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","“Ka Paa ngthupete jah läklam lü a kphyanaka kea ka vea kba, ka ngthupete nami jah läklam üng, ka mhläkphyanaka kea nami ve khai. ");
INSERT INTO dao_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Kei naw ning jah je na ngü se, nami jenak a kümcei vaia phäha ahin he ka ning jah mtheh ni. ");
INSERT INTO dao_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Hin hin ka ngthupeta kyaki: kei naw ka ning jah kphyanaka kba mat ja mat mhläkphya na ua. ");
INSERT INTO dao_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","“Na püi hea phäh mhläkphyanak akyäp säih ta, amimia phäh na sak na pet hin ni. ");
INSERT INTO dao_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Ka ning jah mtheh naküt nami läklam üng ka püi hea nami kya khai. ");
INSERT INTO dao_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Mpyaea am ning jah sui ti nawng. A mahpa naw a bilawh cen mpya naw am ksing khawi. ‘Ka püi he aw’ ti lü ka ning jah khüki. Isetiakyaküng, Paa veia ka ngjak naküt ka ning jah mtheha phäh kyaki. ");
INSERT INTO dao_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Nangmi naw kei cun nami na xü am ni, kei naw va ka ning jah xüki. Cit lü khawkäna pungpyah ngtheipai lü käh thuuih theikia ngtheipaia nami kya khaia ka ning jah mcawnki. Ka ngming üng Paa veia nami täsam naküt ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Mat naw mat nami mhläkphyanak vaia phäh ka ning jah mtheh ni. ");
INSERT INTO dao_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Khawmdek naw a ning jah hneng üng, nangmi am a ning jah hneng ham üng kei na hneng pängki ti ksing ua. ");
INSERT INTO dao_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","“Khawmdek üng nami sängei üng, khawmdek naw ning jah jawng na khai. Cunüngpi, kei naw khawmdek üngka naw ning jah xü ngü se, khawmdek üng am sängei uki. Acunakyase, khawmdek naw ning jah hnengki. ");
INSERT INTO dao_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Mpya cun a bawia kthaka däm bawka thum am ve,’ ti ka ning jah mtheh cen süm ua. Khyang he naw ami na mkhuimkha üng, nangmi pi ning jah mkhuimkha khaie. Ka khyübe ami ngaih üng, nangmia pyen pi ning jah ngai khaie. ");
INSERT INTO dao_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","“Cunüngpi ka khyangea nami thawna phäh, khyange naw ahin he nami khana jah pawh law acun he. Isenitiüng, na tüi lawki am ami ksinga phäh kyaki. ");
INSERT INTO dao_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Kei naw law lü am ka jah mtheha ta, mkhyekatnak am ksing khaie sü. Tuh ta ami mkhyenaka phäh ami lätnak vai lam am ve ve. ");
INSERT INTO dao_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","“Kei na hnengki naküt cun ka Pa pi hnengkia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","“U naw pi am a pawh khawie ami maa am ka jah pawha ta, mkhyenak am ksing khaie sü. Tuh ta ka pawhe jah hmu u lü, kei ja ka Pa jah hnengkie ni. ");
INSERT INTO dao_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Acunakyase, “Amdanga na hnengkie ni,” ti ami Thum üng ng’yuki cun kümcei law khaia kya kungki ni. ");
INSERT INTO dao_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Jah Kpüikpak khai Ngmüimkhya law khai. Ani naw Pamhnama mawng ngthungtak pyen lü, Pa üngka naw lawkia kyaki. Ani cun kei naw Pa üngka naw ka tüi law khai, ani naw ka mawng pyen hü khai. ");
INSERT INTO dao_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","“Nangmi naw pi keia mawng nami pyen acun he. Isetiakyaküng ta akcük ma säih üngkhyüh ka hlawnga nami awmki hea kyaki. ");
INSERT INTO dao_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nami jumeinak käh nami hawih vaia ka ning jah mthehki. ");
INSERT INTO dao_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","“Sinakokea k’um üngkhyüh ning jah ksät khaie. Ning jah hnimki naw Pamhnama khut ka pawki ti lü ami ngaihnaka kcün pha law khai. ");
INSERT INTO dao_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","“Amimi naw Pa am ksing u, kei pi am na ksingkiea kya se, nami khana acukba pawh law khaie. ");
INSERT INTO dao_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","“Akcün a pha law üng, ahlana ka ning jah mtheh päng ti cun nami süm vaia tuh ka ning jah mthehki. Nami hlawnga ka ve hama phäh ahin he ahlana am ning jah mtheh khawi nawng. ");
INSERT INTO dao_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Atuh na tüi lawkia veia ka cit khai. Nangmi üng u naw pi, ‘Hawia na cit khai?’ ti lü am na kthäh uki. ");
INSERT INTO dao_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","“Ahin ka pyen nami ngjaka phäh aktäa nami pukseki. ");
INSERT INTO dao_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Acunsepi, akcanga ka ning jah mthehki: ka ceh hin nami phäha daw bawki ni; am ka ceh üng ning jah Kpüikpak khai am law khaia kyaki. Ka ceh üng va nami veia ani ka tüi law khai. ");
INSERT INTO dao_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ani a law üng, khawmdek khyangea mkhyenaka mawng ami ksing mkhye ja, akdaw ami pawh ja Pamhnama ngthumkhyahnaka mawng cun jah mdan law khai. ");
INSERT INTO dao_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“Kei am ami na juma phäh, mkhyenaka mawng ami ksing cun khyekia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","“Kei ka Paa veia cit be ngü se am ami na hmuh tia phäh, akdaw pawh vai am ksing u. ");
INSERT INTO dao_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","“Khawmdek upki cun naw ngthumkhyahnak khamei pängkia kyase, ngthumkhyahnak naw ami mkhyenak ngdangsaki. ");
INSERT INTO dao_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ka ning jah mtheh vai khawhah ve sepi, atuha nangmi naw am ksing päih khawh uki. ");
INSERT INTO dao_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","“Acunsepi, Pamhnama mawng ngthungtak pyenki Ngmüimkhya a pha law üng, ani naw lam ning jah msüm khai. Amäta ana sumei lü pyen khai am ni. Ahmäi a ngjak pyen lü malama pha law khaie pi ning jah mtheh khai. ");
INSERT INTO dao_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","“Keia pyen naküt cun nangmi üng ning jah mtheh be khaia kyase, kei cun ani naw na mhlünmtai khai. ");
INSERT INTO dao_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","“Paa ka naküt cun keia kaa kyaki. Acunakyase, kei naw ka mtheh naküt cun Ngmüimkhya naw nangmi üng ning jah mtheh be khai.” ");
INSERT INTO dao_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Asängca üng nangmi naw kei am na hmu ti u lü, asängca bä üng nami na hmu be khai” a ti. ");
INSERT INTO dao_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Axüisawe avang naw, “I a pyen hlünak ni? ‘Asängca üng am mi hmu u lü, asängca bä üng mi hmu be khai,’ a ti ja, ‘Paa veia ka cit khaia kyase’ a ti hin i ni, ti lü mat ja mat ngthähkie. ");
INSERT INTO dao_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“‘Asängca’ a ti hin i a ti ni? A ngthu pyena suilam am ksing ve u ngü” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kthähkhyah hlükie ti Jesuh naw ksing lü, “Asängca üng nangmi naw kei am na hmu ti u lü, asängca bä üng nami na hmu be khai’ ti lü, ka pyen namimät nami ngthähkie aw? ");
INSERT INTO dao_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","“Akcanga ka ning jah mthehki: nangmi kyap lü nami mbawi khaie, khawmdek ta jekyai khai. Nami pukse khai, cunüngpi nami puksetnak cun jenaka ngläüh khai. ");
INSERT INTO dao_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Nghnumi a ca law hlü üng pukse khawiki. Isetiakyaküng, a huiheinak vaia kcün cäh lawkia kyase ni. Cunüngpi naca hmi lawki a hmuh ja a huihei naküt mhnihinki. Isetiakyaküng, naca cun khawmdek khana a hmi law pänga phäh jekyainak am beki. ");
INSERT INTO dao_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","“Tukbäih nangmi pi nami pukseki; acunsepi ning jah hmu be ngü se jenak am nami kümcei khai. Nami mlung jenak am be se, u naw käh ning jah hutei khai. ");
INSERT INTO dao_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Acuna mhnüp üng nangmi naw i pi am na kthäh ti uki. Akcanga ka ning jah mthehki: Paa veia ahmäi ka ngming am nami täsam naküt Pa naw ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","“Tuh vei cäpa ka ngming üng i am tä ham uki; nami jenaka kümceinak vaia täsam ua, nami yah khai. ");
INSERT INTO dao_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ahina ngthu msuimcäpnak am ka ning jah mtheh pängki. Msuimcäpnak üng am ning jah mtheh lü Paa mawng angsinga ka ning jah mtheh vaia kcün cun pha law khai. ");
INSERT INTO dao_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","“Acuna mhnüp apha law üng, ka ngming üng ania veia nami ktaiyü khai; Pa veia nami kcaha ka ning jah ktaiyü pet khai am ti nawng; ");
INSERT INTO dao_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","“Isetiakyaküng, nangmi naw kei na mhläkphya na u lü, kei Pa üngka naw ka lawki ti nami jumkia kyase Pa naw pi ning jah mhläkphyanaki. ");
INSERT INTO dao_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","“Kei, Pa üngka naw law lü, khawmdek khana ka lawki. Khawmdek ceh ta lü Paa veia ka cit be khaia kyaki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Acunüng, axüisaw he naw, “Tenga, tuh ta msuimcäpnak kaa angsinga ngthu pyen veki. ");
INSERT INTO dao_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","“Nang naw ahmäi na ksingki, u naw ani kthäh vai am hlü ve ti atuh kami ksingki he. Ahina phäha Pamhnam üngka naw na lawki ti jum ve ung” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesuh naw, “Tuh mä nami jum? ");
INSERT INTO dao_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Teng u, akcün pha law hlüki, pha law päng ve. Acuna kcün üng kei kamät däk na hawih u lü, nami im phähphäha nami dawng be khaie. Acunsepi, Pa ka hlawnga vekia kyase kamät däk am ve nawng. ");
INSERT INTO dao_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Kei üngkhyüh dimdeihnak nami yah vaia ahin ka ning jah mtheh päng ni. Khawmdek naw ning jah mkhuimkha khai. Cunsepi, linglai lü ve ua. Kei naw khawmdek ka näng päng ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Acuna ngthu a pyen law käna Jesuh khana mang lü, “Ka Pa aw, akcün pha law päng ve. Capa naw a ning mhlünmtai law vaia, na Capa mhlünmtaia. ");
INSERT INTO dao_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Acukba khyange naküta khana khyaibahnak a na pet am, na peta khyang naküt üng angsäia xünnak a jah pet khawh vaia. ");
INSERT INTO dao_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","“Angsäia xünnak hin ta, nang Pamhnam kcang däk ja na tüi law Jesuh Khritaw ksingnak cen ni. ");
INSERT INTO dao_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Ka pawh vaia khut na na pet mcän lü, khawmdek khana ka ning mhlünmtai pängki. ");
INSERT INTO dao_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","“Aw ka Pa aw, khawmdek am a ngtüi ham üng nang am atänga hlüngtainak ka yah cen atuh pi na hmai maa na pe bea. ");
INSERT INTO dao_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Khawmdek üngka jah xü lü na na jah petea veia na ngming ka jah mtheh päng ni. Amimi na jah kaa kyase, kei üng na na jah pet päng ni. Amimi naw na ngthukhyü pi läklamkie. ");
INSERT INTO dao_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","“Na na jah pet naküt cun nang üngka naw lawki ti ksing päng ve u. ");
INSERT INTO dao_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","“Na na jah peta ngthue pi ka jah pet; acun dokhamei u lü nang üngka naw ka lawki ti angsinga ksing ve u. Nang naw na na tüi law ti pi jumkie. ");
INSERT INTO dao_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ami phäha ktaiyü veng. Khawmdeka phäha am ktaiyü nawng. Nang naw na na jah pete na kaa ami kyaa phäha, hinea phäha ni ka ktaiyü ve. ");
INSERT INTO dao_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","“Ka kaa naküt cun na ka ni, na ka naküt cun pi ka kaa kyaki. Keia hlüngtainak cun acune üngkhyüh ngdang ve. ");
INSERT INTO dao_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Acunüng, na veia ka law khaia kyase, kei khawmdek khana am ve ti nawng. Hine hin khawmdeka khana ve hüt khaie. Ngcingcaihkia ka Pa aw, nini pumata ni kyaa mäiha, amimi pi pumata ami kya thei vaia, na na peta na ngming jomah am jah kcungvawnga. ");
INSERT INTO dao_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“Ami hlawnga ka vea küt üng, na na peta na ngming jomah am ka jah kcungvawng khawiki. Cangcim a küm lawnak vaia, khyükia capa mata thea, u pi am khyük khaia ka jah kcungvawng ni. ");
INSERT INTO dao_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Acunsepi, tukbäih na veia ka law khaia kyase, hine naw keia jenak ami mlung k’uma kümkawikia ami yahei vaia phäh, kei naw hina ngthu khawmdek khana ka ve ham üng ka pyen ni. ");
INSERT INTO dao_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Na ngthu ka jah peki; acunüng, kei khawmdek üng am ka sängeia mäiha, amimi pi khawmdek üng am sängei u se, khawmdek naw jah hnengki. ");
INSERT INTO dao_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Ahin he khawmdek khan üngka naw na jah lak be vaia ka täsamki am ni. Khawyaipaa kut üngkhyüh na jah yungkaih vaia na veia ka täsamki. ");
INSERT INTO dao_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","“Kei khawmdek üng am ka sängeia mäiha, amimi pi khawmdek üng am sängei u. ");
INSERT INTO dao_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","“Amimi, ngthungtak am jah ngcimcaihsaka, na ngthu cun ngthungtaka pi kyaki. ");
INSERT INTO dao_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","“Nang naw kei khawmdeka na na tüiha mäiha, kei naw pi amimi ka jah tüihki. ");
INSERT INTO dao_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","“Amimi akcanga na veia ami ng’apei law vaia phäh, kei ami phäha kamät na veia ka ng’apeiki. ");
INSERT INTO dao_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Hinea phäh däka ka ktaiyüki am ni, hinea ngthu pyena phäh kei na jum law khaiea phäha pi ka ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","“Ami yümmat law vaia ka ktaiyüki. Pa aw, nang kei üng ve lü kei nang üng ka vea mäiha, amimi pi nini üng ve law u se. Amimi ami yümmat üng va, khawmdek khyange naw na na tüi law ti cun jum law khaie. ");
INSERT INTO dao_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Nang ja kei pumsa mata ni thawna mäiha amimi pi pumsa mata ami thawn thei vaia; hlüngtainak na na pet cen ka jah peki. ");
INSERT INTO dao_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","“Kei amimi üng ve lü, nang kei üng veki se, amimi ami yümmat law vaia phäh. Acunüng va, na na tüih law ja na na mhläkphyanaka mäiha, na jah mhläkphyanaki ti cun khawmdek khyange naw ksing law khaie. ");
INSERT INTO dao_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ka Pa aw, khawmdek am a ngtüi ham üng na mhläkphya na lü na na peta hlüngtainak cen, ka venaka ve u lü keia hlüngtainak ami hmu thei vaia hlüei veng. ");
INSERT INTO dao_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Ngsungpyunkia Pa aw, khawmdek naw am ni ksing. Kei naw ta ni ksing veng; hine naw pi na na tüi law ti ksingki he. ");
INSERT INTO dao_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","“Ka hama na taka mhläkphyanak cen amimi üng ve se, kei pi amimi üng ka ve vaia, ami veia na ngming ka jah ksingsaki, ka jah ksingsak ham lä khai” ti lü ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesuh ktaiyü law päng se axüisaw he am Kidron Lawngca caye da va citkie. Acuna hnüna ngvawng veki, acun üng axüisaw he am atänga lutkie. ");
INSERT INTO dao_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesuh cun axüisaw he am acuna hnüna khawvei cit khawikiea kyase, cengkia Judah Iskarot naw acuna hnün cun ksingki. ");
INSERT INTO dao_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judah ngvawng da citki. Romah yekape, ktaiyü ngvaie ja Pharisee naw ami jah tüi law Temple ngängkia khyange avang jah lawpüi se, mthikcime, meiim ja ngtukmei jah kawteikie cun acuia a jah lawpüi. ");
INSERT INTO dao_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesuh naw a khana pha law khai naküt jah ksingei lü, va cit lü, “U nami suiki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Amimi naw, “Nazaret Jesuh,” ni ami ti. Jesuh naw, “Acun cun kei ni” a ti. Cengkia Judah pi ami ksunga ngdüi hngaki. ");
INSERT INTO dao_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesuh naw, “Acun cun kei ni” a ti ja, ami hnua ngnawn u lü mdeka kyukie. ");
INSERT INTO dao_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesuh naw, “U nami suiki ni?” ti lü a jah kthäh betü. Amimi naw, “Nazaret Jesuh” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesuh naw, “Acun cun kei ni, ti lü ka ning jah mtheh päng; kei nami na suikia a kyak üng akce he cit u se” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Acun cun, “Nang naw na na jah pet mat pi käh ka mkhyüh khai ni” ti lü a ngthu pyen akümnak vaia kyaki.) ");
INSERT INTO dao_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sihmon Pita naw kcim a kbahei kset lü Ktaiyü Ngvai säiha mpyaa nghnga khet da a ksawm pat. Acuna mpyaa ngming cun Malakhuha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesuh naw Pita üng, “Kcim a im üng xawn bea; ka Pa naw a na peta khuikhatnak khawt hin am ka aw khai aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Acunüng, Romah yekape ja Temple ngängkia Judah khyange naw Jesuh man u lü, khitkie naw, ");
INSERT INTO dao_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Annaa veia ami cehpüi ma u. Anna cun acuna kum üng Ktaiyü Ngvaisäih Kaiphaha pupua kyaki. ");
INSERT INTO dao_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiphah cun, “Khyang khawhaha phäh khyang mat a thih daw bawki” ti lü, Judah ngvaie jah mthehkia khyanga kyaki. ");
INSERT INTO dao_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sihmon Pita ja axüisaw he üngka mat naw Jesuh läki xawi. Acuna axüisaw üngka mat cun Ktaiyü Ngvaisäih naw ksingki; Ktaiyü Ngvai säiha im ngvawng mkawt k’uma Jesuh am lutki xawi. ");
INSERT INTO dao_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Acunsepi Pita cun khawkpung mkawt peia ngdüiki. Acunüng axüisaw kce mat va nghlat be lü mkawt ksawh ngängki nghnumica kthäh lü Pita a luh lawpüi. ");
INSERT INTO dao_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mkawt ksawh ngängkia nghnumica naw Pita üng, “Nang pi ania xüisawa am na kyaki aw?” a ti. “Am ni nawng” Pita naw a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Khawsikia kyase, mpyae ja Romah yekape naw mei tik lü ngdüi lü mei omkie. Pita pi ami hlawnga va ngdüi lü mei awmei hngaki. ");
INSERT INTO dao_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ktaiyü Ngvaisäih naw axüisaw hea mawng ja a jah mtheia mawng Jesuh üng a kthäh. ");
INSERT INTO dao_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesuh naw msang lü, “Ngthu ka pyen üng khyanga hmuh ngjaka va ka pyenki. Sinakok ja Judahea ami ngbumnak Templea ka jah mthei khawiki, khyange pi ngcun lawkie, ampyua i am pyen khawi nawng. ");
INSERT INTO dao_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","“Ise na na kthäh ni? Ami veia ka ngthu pyena mawng cun ka ngthu ngjakie jah kthäha; acune naw i ka pyen ksingki he” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Acun a pyen üng a peia ngdüiki, yekap mat naw Jesuh kbei lü, “Ktaiyü Ngvaisäih ahikba na msangki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesuh naw, “Ka pyen mkhye a ve üng ahin üng veki naküt üng jah mtheha. Ka pyen cangki ani üng, ise na na kbeiki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Acunüng Anna naw Jesuh a ngkhihnak mahmaha Ktaiyü Ngvaisäih Kaiphah a veia a tüih. ");
INSERT INTO dao_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sihmon Pita ngdüi lü mei om ham se, khyang kce he naw, “Nang pi ania xüisawa am na kyaki aw?” ami ti üng, “Am ni nawng,” ti lü, ngcim betüki. ");
INSERT INTO dao_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ktaiyü Ngvai säiha a mpya Pita naw a nghnga a ksawm pata a mjükphyüi mat naw, “Ani am ngvawnga ve niki se ka ning jah hmuh am ni mä?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita a ngcim betü ja; ainghlüi khawngki. ");
INSERT INTO dao_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Khawa ngawi law üng, Jesuh Kaiphaha im üngkhyüh sangpuxanga Bawingawhnaka ami cehpüi u. Judah ngvaie cun sangpuxanga Bawingawhnaka am lut u. Lätnak Pawi buh ami einak thei vaia, ngcingcaihnak am amimät ami ve vaia phäh kyaki. ");
INSERT INTO dao_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Acunüng, Pilat akpunga lut law lü, “Hina khana i nami mkatnak ve se aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Amimi naw, “Hin hin khyangkaa am a ni üng na veia am lawpüi sawxat u nawng” ti lü ami msang. ");
INSERT INTO dao_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat naw, “Namimät naw cehpüi u lü, nami thuma kba cijang ua,” a ti. Judah mkhawnge naw, “Kami ngaiha u hnim vaia thum am ve” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Acun cun a thih vaia mawng Jesuh naw a pyena mäiha akümnak law vaia kyaki.) ");
INSERT INTO dao_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat naw Bawingawhnaka lut be lü Jesuh khüki naw, “Nang Judahea sangpuxanga na kyaki aw?” ti lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesuh naw, “Hina ngthu hin namäta mlung üngka naw lut lawki aw. Am ani üng ka mawngma khyange naw ning mtheh u se na pyen aw?” ti lü a kthäh be. ");
INSERT INTO dao_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat naw, “Kei Judah khyanga na ngaih aw? Namäta khyang mjüe ja ktaiyü ngvaie naw ka kut üng ami na msum lawa na kyaki. Ia mkhyenak na pawh ni?” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesuh naw, “Ka khaw ta hina khawmdek üng am sängei; ka khaw hin hina khawmdek üng a sängei vai sü ta ka hnukläke naw Judah ngvaiea kut üngkhyüh na yung khaie sü; ka khaw hin hina khawmdeka am ni” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilat naw, “Acunüng, nang sangpuxang aw?” ti se, Jesuh naw, “Ä, na pyena mäiha kei sangpuxang ni. Ka hmi lawnak ja khawmdek khana ka lawnak hin ngthungtak saksinak vaia phäha kyaki. Au pi ngthungtak üng sängeiki naküt naw ka ngthu ngaiki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat naw Jesuh üng, “Ngthungtak cun i ni?” a ti. Acuna ngthu a pyen päng ja Judahea veia cit lü, “Thihnak awng vaia mkhyenak ani üng am hmu veng, ");
INSERT INTO dao_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","acunsepi Lätnak Pawi k’um üng thawng kyum mat ka ning jah mhlät pet vaia thum nami taki. Acunakyase, Judahea sangpuxang hin ka ning jah mhlät pet vaia nami ngaiki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Amimi naw ngpyang u lü, “Ani käh mhläta. Barabah jah mhlät peta” ami ti. (Barabah cun mawa ve lü kcim kcei bikia mpyukeia kyaki.) ");
INSERT INTO dao_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Acunüng, Pilat naw Jesuh cehpüi lü a kpaih. ");
INSERT INTO dao_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yekape naw nghling lukhüm pyang u lü ami ngbüngsak. Acun käna, jih sennu ngvüihsak u lü, ");
INSERT INTO dao_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","a peia law u lü, “Judahea Sangpuxang, xüng soa” ti lü a hmai ami kbeih. ");
INSERT INTO dao_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat naw lut law betü lü, “Teng u, thih vai awnga mkhyenak i pi am hmu nawng ti nami ksing vaia, nami veia ka lawpüi beki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesuh cun nghling lukhüm ngbüng lü jih sennu pi ngvaih lü kpunga lut lawki. Pilat naw, “Teng u, hina khyang” a ti. ");
INSERT INTO dao_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ktaiyü ngvaie ja Temple ngänge naw ami hmu ja, “Kutlamktung üng taiha, kutlamktung üng taiha” ti lü ngpyangkie. Pilat naw, “Nangmi naw cehpüi u lü, kutlamktung üng taih ua; kei naw ta thih awng vai a mkhyenak am hmu veng” a ti. ");
INSERT INTO dao_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judahe naw, “Pamhnama Capaa mhnüneikia kyase, kami thuma tia kba, thi khaia nglawi ve” ti lü ami msang. ");
INSERT INTO dao_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilat naw acun a ngjak ja kyühei law dämdäm lü, ");
INSERT INTO dao_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","a Bawingawhnaka cit be lü, “Nang hawia ka naw na lawki ni?” a ti. Jesuh naw mkhap mat am pi am msang be. ");
INSERT INTO dao_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilat naw, “Am na na msang hlüki aw? Ning khyah be vai ja kutlamktung üng ning taih vai hin keia mkhyaha kya khai, ti cun ksinga” a ti. ");
INSERT INTO dao_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesuh naw, “Pamhnam naw a ning pet pänga phäh däk ni, ka khana khyaibahnak na tak ve. Acunakyase, kei hin na veia ning msum lawki cen mkhyekatnak akdäm bawk pawhki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilat naw acun a ngjak üngkhyüh Jesuh a mhlät vaia lam suiki. Acunsepi Judahe naw ngpyang u lü, “Hina khyang na mhlät üng Emperoa püia käh na kya khai. Sangpuxanga mhnüneiki naküt cun Emperoa yee ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilat naw acun a ngjak ja Jesuh luh lawpüi lü, Hebru läk am Kabbata ami ti Ngthumkhyahnak Lungsüma khana ngawki. ");
INSERT INTO dao_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Acuna mhnüp cun Lätnak Pawi am a pha ham mhnüp mat a hlüa mhnüpa; mhnüp ngsunga kyase, Pilat naw Judahea veia, “Teng u, nami sangpuxang” a ti. ");
INSERT INTO dao_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Amimi naw ngpyang u lü, “Hnima, hnima, mkhyüha, kutlamktung üng taiha” ami ti. Pilat naw, “Nami sangpuxang, kutlamktung üng ka taih vai nami hlüeiki aw?” a ti. Ktaiyü ngvaie naw, “Emperoa thea sangpuxang akce am ta u nawng” ti lü, ami msang. ");
INSERT INTO dao_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Acunüng, Pilat naw Jesuh cun kutlamktung üng taih vaia a jah msum. Jesuh cun ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesuh naw amäta phäha kutlamktung kawt lü ‘Luyuh Hnün’ ami ti, Hebru läk am Kolkothaa citki. ");
INSERT INTO dao_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Acuia kutlamktung üng khyang nghngih am ami jah taih yüm. A peia mat cim jah taih u lü Jesuh anglung üng ami taih. ");
INSERT INTO dao_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat naw, “Nazaret Jesuh, Judahea Sangpuxang” ti lü kca yuk lü kutlamktung khana a taih. ");
INSERT INTO dao_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesuh kutlamktung üng ami taihnaka hnün cun Jerusalem mlüha peia kyaki. Acuna kca cun Hebru, Latin ja Krik läke üng ami yuka kyase Judah khyang khawhah naw khekie. ");
INSERT INTO dao_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ktaiyü ngvaie naw Pilat aw, “Judahea Sangpuxang” ti lü käh yuka, “Kei, Judahea Sangpuxang ni, ti ve” ti lü yuka’” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat naw, “Ka yuk päng cen ka yuka kba ve se” ti lü a jah msang. ");
INSERT INTO dao_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yekape naw kutlamktung khana Jesuh ami taih päng üng a suisake jah lo u lü, kphyüa ktek u lü mat cima ami ng’yatei. Ak’uma a phyang jih cun am xüi u, alu üngka naw ale cäpa taha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yekape naw, “Käh mi ktek vai, u naw a bi vai cungkek mi kphawng vai u” ami ti. Acun cun Pamhnama cangcim üng, “Ka suisake jah ng’yetei u lü, ka kcu nglünglawknak khaie ni” ti a küm lawnak vaia kyaki. Acun cun yekape naw ami pawha kyaki. ");
INSERT INTO dao_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesuha kutlamktung peia, Jesuha nu ja Kalawphaa a khyu Marih ja Marih Makdalin ngdüikie. ");
INSERT INTO dao_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesuh naw a nu ja a kphyanak axüisaw a peia ngdüi ni se jah hmu lü, a nu üng, “Na capa ta ani ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Axüisaw üng, “Ani ni na nu” a ti. Acunüng tün lü, acuna axüisaw naw Jesuha nu cun a ima a cehpüi. ");
INSERT INTO dao_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Acunkäna, atuh ta ahmäi naküt kümcei pängki ti Jesuh naw ksing lü, cangcima kümnak vaia, “Tui cawi veng” a ti. ");
INSERT INTO dao_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Acuia Capyitui kpaih k’am mat ami tak. Hisop Capyitui k'am üng kphum lü cung üng taihkie naw a mpyawng üng ami jeng sun. ");
INSERT INTO dao_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesuh naw Capyitui kpaih a awk päng ja “Ngpäng ve” a ti. Acunüng, a ngmüm üng a sak päihki. ");
INSERT INTO dao_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Judah ngvaie naw kutlamktung üng ami taiha khaw jah k'ek lü, ami yawke ami jah khyak vaia Pilat ami kthäh. Isenitiüng, acuna mhnüp cun Amhma mhnüpa kyaki. Angawi Sabbath mhnüp (Lawkia Sabbath mhnüp cun Judahea thuma aktäa ngcingcaihkia mhnüpa kyaki) üng ami yawke kutlamktung üng a ngtaihei vai am jum u. ");
INSERT INTO dao_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yekape law u lü Jesuh am atänga ami jah taih yüm xawia ani khawe cun ami jah k’ek. ");
INSERT INTO dao_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Acunsepi, Jesuha veia ami law üng, Jesuh thi pängki ti ksing u lü a khawe am jah k’ek u. ");
INSERT INTO dao_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Acunsepi yekape üngka mat naw Jesuha kpem kcei am a sun. Acunüng thi ja tui ngsawi law yümki xawi. ( ");
INSERT INTO dao_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hmuki mat naw pyen lü ngsingsak pängki. A ngsingsak pi cangki. Nami jum vaia a ngthu pyen cangki ti pi ani naw ksing lawki.) ");
INSERT INTO dao_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Acun cun, “A yuh mat pi käh ek khai” ti lü, Cangcima a küm lawnak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Acuna thea cangcim naw, “Khyange naw kcei am a kpem ami sun cun hmu khaie” pi Cangcim naw ti hamki. ");
INSERT INTO dao_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Acunkäna Arimahte mlüha ka Josep, Jesuha axüisaw, acunsepi Judah ngvaie a jah kyüha phäh, ampyua veki. Ani naw Jesuha yawk a cehpüi vaia Pilat kthäh se, Pilat naw a khyah. Josep naw law lü Jesuha a yawk cun a cehpüi. ");
INSERT INTO dao_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ahlana mthana Jesuha veia lawkia Nikawdim naw mura ng'ui ja aloe jah kcaw, khin mku bang cehpüi lü Josep am citki xawi. ");
INSERT INTO dao_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesuha yawk cun lo ni lü Judahea ami ng’utei khawia thuma, mura ng’ui ja jih am ani hlawp. ");
INSERT INTO dao_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kutlamktung üng ami taihnaka peia ngvawng mat veki. Acuna ngvawng üng u pi am ami k’utnak khawia lungdü kthai mat veki. ");
INSERT INTO dao_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Angawi cun Judahea Sabbath mhnüpa kya lü, lungdü ng'etkia kyase, acun üng Jesuh ami k’ut. ");
INSERT INTO dao_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ngpum mhnüp khawa nghmüp ham üng, Marih Makdalin cun lungdüa cit lü ng’utnak ami khaihnak lungnu a na ngpyawtei se a hmuh. ");
INSERT INTO dao_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sihmon Pita ja Jesuha mhlänak axüisaw kcea veia dawng lü, “Ng’utnak üngka naw Bawipa cehpüi ve u, hawia ami tak am ksing veng” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Acunüng,Pita ja axüisaw kce lungdüa citki xawi. ");
INSERT INTO dao_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nghngih cun dawngki xawi; axüisaw mat naw Pita khe lü lungdüa a na pha maki. ");
INSERT INTO dao_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ngmüm lü a teng üng, hlawpnak jih däk ve se a hmuh; acunsepi ak’uma am lut. ");
INSERT INTO dao_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sihmon Pita naw pi hnua pha law lü, ng’utnak k’uma a luh üng hlawpnak jih ja, ");
INSERT INTO dao_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","a lu ami hlawpnak kpyawn cun a hmuh. A pum hlawpnaka jihea hlawnga am ve lü, a pum hlawpnak cun amät ngtawmei hnga se a hmuh. ");
INSERT INTO dao_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Axüisaw kce dawng lü lungdü pha maki naw pi lut hnga lü hmu lü jumki. ( ");
INSERT INTO dao_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Thihnak üngkhyüh tho be khai tia cangcim üng veki cun axüisaw he naw am ksing u.) ");
INSERT INTO dao_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Acunüng, axüisaw he cun animäta ima nghlat beki xawi. ");
INSERT INTO dao_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Marih cun lungdüa peia kyap lü ngdüiki; a kyah sawa ngmüm lü ng’utnaka k’um cun a juk teng; ");
INSERT INTO dao_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","khankhawngsä nghngih jih kbawk suisa ni lü Jesuha yawka peia mat a lu da, mat a khaw da ngaw ni se a jah hmuh. ");
INSERT INTO dao_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Anini naw, “Nghnumi aw, ise na kyapki ni?” ti lü Marih ani kthäh. Marih naw, “Ka Bawipa cehpüi ve u, ami taknak am ksing veng” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Acukba a pyen päng ja, a hnu da nghlat lü Jesuh ngdüi se a hmuh. Acunsepi Jesuh hman tia am ksing. ");
INSERT INTO dao_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesuh naw, “Nghnumi aw, ise na kyapki ni? U na suiki ni?” a ti. Marih naw ngvawng mtäta ngai lü, “Nang naw ani ahin üngkhyüh na cehpüi a ni üng na taknak na mtheha. Cit lü ka lak be vaia” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesuh naw, “Marih” a ti. Marih naw nghlat lü Hebru läk am, “Raboni” a ti; (Acun cun Saja aw, tinaka kyaki.) ");
INSERT INTO dao_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesuh naw, “Käh na mana; Paa veia am kai be ham nawng. Ka naea venaka cit lü ka Paa kyakia nami Pa, Ka Pamhnama kyakia nami Pamhnam ania veia ka kai be vaia mawng jah va mtheha” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Acunüng Marih Makdalin cun axüisaw hea veia cit lü, Bawipa a hmuh ja ngthu a mthehea mawng pi a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ngpum mhnüp mü lama, Judah ngvaie ami jah kyüha phäh ksawh khai u lü, axüisaw he ngbumnakie. Ami ngbumnaka Jesuh law lü, ami ksunga ngdüi lawki naw, “Nami khana dimdeihnak ve se” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Acukba pyen päng lü, a kut ja a kpem a jah mhnuh. Axüisawe naw Bawipa ami hmuh ja aktäa jekie. ");
INSERT INTO dao_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesuh naw, “Nami khana dimdeihnak ve se; Pa naw a na tüiha mäiha ka ning jah tüihki” a ti betü. ");
INSERT INTO dao_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Acunkäna ami khana khawkhi hmut lü, “Ngmüimkhya Ngcim doei ua. ");
INSERT INTO dao_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Khyang hea mkhyenak nami mhlät naküt cun mhläta kya khai; am nami jah mhlät üng jah mhläta am kya” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesuh a law üng, xaleinghngihe üngka (Angphia ami sui) Thomah cun ami hlawnga am ve. ");
INSERT INTO dao_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Acunakyase, axüisaw kce he naw, “Bawipa kami hmuki” ti lü ami mtheh. Thomah naw, “Ami hnennaka a kut nghma am hmu lü, hnennak anghma ka kut pyün üng am mtham lü, a kpem üng hnet lü am ka mhjut üng ta, am jum thei nawng” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pat at mhjawk lü, axüisaw he im k'uma ami ngcun be üng Thomah pi ami hlawnga ve hngaki. Ksawhe pi khai lü ami jah ken kyaw, Jesuh law lü ami nglung üng ngdüi lawki naw, “Nami khana dimdeihnak pha law se” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Thomah üng, “Ka kute jah mthama; ka kute pi jah tenga, na kut säng lü ka kpem hneta. Käh uplat ti lü, jum hnüha” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomah naw, “Ka Bawipa ja ka Pamhnama kya veki” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesuh naw, “Nang naw na na hmuha phäha na na jumki aw? Am na hmu lü na jumkie ta ihlawka ami josenki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Hina caup üng am ami yuksiha müncanksee khawhah, Jesuh naw axüisaw hea maa jah biki. ");
INSERT INTO dao_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Acunsepi, Jesuh cun Mesijah, Pamhnama Capaa kyaki ti cun nami jumnak vai ja, ani nami jumnak am xünnak nami yah vaia, ahin he hin jah yuka kyaki. ");
INSERT INTO dao_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Acunkäna, Jesuh Tiberi Tuili pei, axüisaw hea veia ngdang betüki. Acuia a ngdang betüa mawng ta, ");
INSERT INTO dao_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sihmon Pita, Thomah (Angphi ami ti), Natanelah (Kalile hne Kana mlüha ka), Zebedea capa xawi ja axüisaw kce xawi nghngih awmki he. ");
INSERT INTO dao_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sihmon Pita naw ami vei, “Nga sui khaia ka cit khai” a ti. Amimi naw, “Keimi pi na hlawnga kami law hnga khai” ami ti. Acunüng mlawng am citkie; acuna mthan cun ipi am yah u. ");
INSERT INTO dao_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Khawmik a luh law üng, Jesuh tui kama ngdüiki. Acunsepi axüisaw he naw Jesuh hmana am ksing u. ");
INSERT INTO dao_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesuh naw, “Ka püi he aw, nga i pi am mbawh ham uki aw?” ti lü a jah kthäh. Amimi naw, “Ipi am mbawh u ngü” ami ti. ");
INSERT INTO dao_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesuh naw, “Mlawng khet da ngvai vawi ua, nami yah khai ni” a ti. Ami vawih üng nga khawhah yahkie. Acunüng nga nung lü ngvai am kaih be khawh u. ");
INSERT INTO dao_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesuha mhlänak axüisaw naw Pita üng, “Bawipa va ni kbak” a ti. Bawipa a ni hman Sihmon Pita naw a ngjak üng a kcu jih be lü tui da kcoki, (Akpuma a vea phäha kyaki). ");
INSERT INTO dao_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Axüisaw kce he ngvai üng nga akbea kaih law u lü mlawng am kawng da lawkie. Kawng üngka naw lam khyukip banga thuki. ");
INSERT INTO dao_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kawng ami va pha ja acuia mei k’eh am mei ami tih, a khana nga ngxaih ja muk ve se ami hmuh u. ");
INSERT INTO dao_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesuh naw, “Nga nami mbawh api lawpüi ua” a ti. ");
INSERT INTO dao_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sihmon Pita naw mlawnga khana va kai lü nga angbaü avana phya ja mhmakip ja kthum law se, ngvai kawnga a kaih law. Acukba nung kyaw lü pi ngvai am tek. ");
INSERT INTO dao_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesuh naw, “Ngawi ei, ei law ua” a ti. Bawipa a ni hman ksing u lü, axüisaw he üng u naw pi, “Nang u ni?” ti lü am kthäh dat u. ");
INSERT INTO dao_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesuh naw law lü muk lo lü a jah pet, nga pi acukba a jah pet. ");
INSERT INTO dao_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Acun cun Jesuh thihnak üngkhyüh a thawh be käna axüisaw hea veia a ngdang akthumnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ngawi ei ami ei käna, Jesuh naw Sihmon Pita üng, “Johana capa Sihmon, hinea na mhläkphyanaka kthaka na na mhläkphyanaki aw?” a ti. Ani naw, “Ä, Bawipa aw, ka ning kphyanak na ksingki” a ti. Jesuh naw, “Ka tocae jah tumcah bä” a ti. ");
INSERT INTO dao_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Anghngihnaka Jesuh naw, “Johana capa Sihmon, na na mhläkphyanaki aw?” a ti betü. Ani naw, “Ä, Ka ning mhläkphyanaki ti na ksingki” a ti be. Jesuh naw, “Ka toe jah mcei bä” a ti. ");
INSERT INTO dao_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akthumnaka Jesuh naw, “Johana capa Sihmon, na na mhläkphyanaki aw?” a ti betü. Jesuh naw, “Na na mhläkphyanaki aw?” ti lü kthum vei kthäh se Pita pukse law lü, “Bawipa aw, ahmäi na ksingki, ka ning kphyanak pi na ksingki” a ti. Jesuh naw, “Ka toe jah tumcah bä.” ");
INSERT INTO dao_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Akcanga ka ning mthehki: na dik hama kcün üng na cehnak hlü naküta na cit hü theiki. Acunsepi, na xü law üng na kut jah säng lü, khyang kce naw ning khit lü am na cehnak hlüa ning cehpüi khai” a ti. ");
INSERT INTO dao_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Acuna ngthu cun Pita naw ihawkba thi lü, Pamhnam mhlünmtai khai ti msingnaka a pyena kyaki.) Acukba a pyen käna, Jesuh naw “Na läk lawa” a ti. ");
INSERT INTO dao_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita naw nghlat lü Jesuha mhlänak axüisaw, ahlana müei ami ei üng a peia nghlat law lü, “Bawipa aw, ning phyehei khai cun u ni?” tiki a hnua ngaw se a hmuh. ");
INSERT INTO dao_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita naw Jesuh hmu lü, “Bawipa aw, hina khyang ihawkba vai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesuh naw, “Ka law be veia ani a xüng vai ka hlüei üng mä, nang üng i pi am sängei. Na läk lawa” a ti. ");
INSERT INTO dao_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Acuna mawng cun Jesuha axüisaw hea ksunga, acuna axüisaw am thi khai” ti lü, aktäa ngthang hüki. Acunsepi, Jesuh naw acuna axüisaw am thi khai a ti am ni, “Ka law be veia ani a xüng vai ka hlüei üng, nang üng i pi am sängei” däk va a ti. ");
INSERT INTO dao_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ahina mawngmae jah pyensa lü jah yukthetki cun axüisaw ni; a pyen pi cangki ti kami ksingki. ");
INSERT INTO dao_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ahina thea pi Jesuh naw a jah pawhmsah akce khawhah veki. Acun he jah yuk päih vai ani üng, acun jah yuknaka caupe khawmdek khana taknak vai am khäk khaia ka ngaiki.");
INSERT INTO dao_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theophiluh aw: Ka yuk kcüka cauk cun Jesuh naw jah mtheimthang lü khut a pawh lawnak üng tünei lü, ");
INSERT INTO dao_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","khankhawa a kai be vei cäpa ania mawnglama kyaki. Ani cun naw khankhawa am a kai be ham üng, a xüa Ngsäe cun Ngmüimkhya Ngcima johit am lam jah msüm hütki. ");
INSERT INTO dao_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ani cun a thih käna mhnüp kphyükipa k'um üng Ngsäea veia khawvei ngdang be lü a xün bea mawng cun akcanga mdang hütki. Ngsäe naw ani cun hmukie, ani naw pi Pamhnama pea mawng jah mthehki. ");
INSERT INTO dao_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Acunüng, Ngsäe jah ngbämsaki naw, “Jerusalem käh cehta u lü, ka Paa khyütam, nami ngjaka ka pyen khawi cän ana k'äih ua. ");
INSERT INTO dao_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Johan naw tui üng Baptican ning ja peki, khaw mhnüp am hjo lü Ngmüimkhya Ngcim üng Baptican nami kham khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Acunüng, amimi cun, atänga ngkhäm law u lü, “Bawipa aw, atuha Isarele üng pe na jah pet khai aw?” ti u lü, ami kthäh. ");
INSERT INTO dao_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Acunüng, Jesuh naw, “Akcün ja ahnün cun ka Pa naw amäta themnak üng a cenga kyase, nangmi naw nami ksing vaia am kya ve. ");
INSERT INTO dao_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Acunsepi, Ngmüimkhya Ngcim nami khana a pha law üng, johit am nami be law khai. Acunüng, Jerusalem mlüh, Judah, Samarih ja khawmdeka adütnak cäpa, kei a saksia nami kya khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Acuna ngthu a pyen law päng üng, ami hmuh mahmaha khana kai be se, khawngmei naw am ami hmuh be thei vaia a thupin. ");
INSERT INTO dao_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","A hang kai be üng axüisawe naw khankhawa han bük kyetkie. Acunüng, khyang nghngih suisak abawk jah suisa ni lü, ami peia ngdüi lawki xawi. ");
INSERT INTO dao_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Acu xawi naw, “Kalile khyange aw, ise khankhawa hang mang u lü, nami ngdüikie ni? Hina Jesuh hin nami vei üngkhyüh nami hmuha khana a kaia mäiha, law be khai” ani ti. ");
INSERT INTO dao_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Acunüng, Ngsäe cun Olip mcung ami ti üngka naw Jerusalem mlüha cit bekie. Acuna mcung cun Jerusalem mlüh üngkhyüh kilometer mat banga thuki. ");
INSERT INTO dao_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Amimi cun mlüha pha be u lü, ami im kainaka k'uma lutkie: acune cun, Pita, Johan, Jakuk, Andru, Philip, Thomah, Batolame, Mahte, Alaphaha cakpa Jakuk, Sihmon Zelot ja Jakuka cakpa Judaha kyakie. ");
INSERT INTO dao_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Amimi cun, Jesuha nu Marih ja akce nghnumie ni, Jesuha a nae am, atänga ngkhäm u lü ktaiyü läkie. ");
INSERT INTO dao_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Acunüng, angawi tiktuh üng, jumkia khyange ami ngkhäa phya ja mku cun ngkhäm lawki he. Pita naw ami nglunga ngdüi law lü, ");
INSERT INTO dao_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ka benae aw, Jesuh man khaie üng, lam ja msümkia, Judah Iskarota mawng Cangcim üng veki cun küm päng ve. Acuna Cangcim cun Ngmüimkhya Ngcim naw Davit üngkhyüha a pyena kyaki. ");
INSERT INTO dao_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judah cun axüisaw mata kyase, khut mi binak üng pi ngpüi vaia a xüa kyaki. ");
INSERT INTO dao_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ani cun am daw khaia ngui yah lü khaw hnün mat khyäiki, acunüng kya law lü ta a khawn pawk lü, a khyü avan lut law päihki. ");
INSERT INTO dao_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Acuna mawng cun Jerusalema vekia khyang avan naw ngja u lü, acuna khaw hnün cun, amimäta ngthu am, ‘Akeldama ami sui, acun cun, ‘Thisen Hnün’ tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Salan caup üng, ‘A im xawngei lü, ak'uma u am ve se,’ ti lü ng’yuki, acuna thea ng’yuk betüki ta, ‘khyang kce naw ania hnün bi se’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Acunakyase, Johan naw Baptican a ja petnak üng tün lü, Jesuh khana a kai be cäpa, mi veia citcawn hü lü vekie üngka, Bawipa Jesuha a thawhnak be saksi na lü jah sang püi khaia khyang mat mi mcawn be khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Acunüng, ani cun khyang nghngih üngka mat xü vaia mkyäpkie. Acun xawi ta Josep: Barsaba ami tia Jastas ja Matthias kyaki. ");
INSERT INTO dao_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Acunüng, amimi ktaiyü u lü, “Bawipa, khyanga mlung avan na ksingki, ");
INSERT INTO dao_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a venak vaia cit pängki Judaha hnün üng ngsä khut bi khaia hin xawi üngka u na xüki, jah mtheha” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Acunüng, cung kphawng u lü, Matthias naw cung yah se, ani cun ngsä xaleiate am atänga khutbi hnga khaia mcawnkie. ");
INSERT INTO dao_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos mhnüp a pha law üng, jumeikia khyang avan cun atänga hnün at üng ngkhämkie. ");
INSERT INTO dao_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Acunüng, khankhaw üngkhyüh naw, angxita, khawkhia mäiha ng'yüngki cun ami venaka im üng pha law lü be lawki. ");
INSERT INTO dao_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Acunüng mleie cun meia mäiha däi lü mat cim üng pek se ami hmuh u. ");
INSERT INTO dao_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ami van cun Ngmüimkhya Ngcim am be u se, Ngmüimkhya Ngcim naw a jah ngthuheisaka mäiha, ngthu kce am ngthuei lawki he. ");
INSERT INTO dao_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Acunüng, khankhawa ke khawmdek khan, khyawngpe naküt üngka naw lawki he jumeikia Judahe cun Jerusalem mlüha vekie. ");
INSERT INTO dao_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Acuna ng'yüng ami ngjak ja, khyange ngkhäm lawki he. Axüsawea ngthu pyen cun khyang naküt naw amimäta ngthu a phäh phäh üng ngjak u lü, cäieikie. ");
INSERT INTO dao_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Acunüng, ami ngkhä cäica law u lü, “Hina ngthu pyenkie cen Kalile khyangea am kya u bä! ");
INSERT INTO dao_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ise hina ami ngthu pyen cän mi van naw mi khyü phäh phäh üng mi ksing thei ni? ");
INSERT INTO dao_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mimi cun avang Pontas khaw, Medih khaw, ja Elam khawa kae; avang cun Mesopotemih khaw, Judah khaw, ja Kappadokih khawa kae; avang cun Pontuh khaw ja Asah khawa kae, ");
INSERT INTO dao_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","avang cun Pharikih khaw ja Pampulih khawa kae, avang cun Egypt khaw, ja Kurinih khaw peia Lihbuh khawa kaea mi kyaki. Avang he cun Romah khaw üngka naw kdung lawki hea Judahe ja Judah thum üng ngkhawkia Khyangmjükcea mi kyaki. ");
INSERT INTO dao_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Avang cun Karete khaw ja Arab khaw ja Judah khawa kaea mi kyaki. Cunsepi Pamhnam hlüngtaikia khutbi cun pyen u se, mimäta ngthu phäh phäh üng mi ngjaki ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Amimi cun aktäa cäica u lü, “Hin hin ia suilam ni?” ti u lü ngthähki he. ");
INSERT INTO dao_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Acunüngpi khyang kcee naw, “Hina khyange hin mpyüi lawki he ni” ti u lü jah yaiheikie. ");
INSERT INTO dao_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Acunüng, Pita cun a püi xaleiatea ksunga ngdüi law lü, angsanga, “Judah üngka khyange ja, Jerusalem mlüha nami vekia khyange aw, nami van naw na ngai ua, hina asuilam cun ka ning jah mtheh khai. ");
INSERT INTO dao_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hina khyange cun nami ngaiha mäiha, am mpyüi u, tuh cun ngawilam naji kaw ni a law ham ve. ");
INSERT INTO dao_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Hin cun sahma Jolah naw ana pyen khawia mawng ni: ");
INSERT INTO dao_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Pamhnam naw, akpäihnaka khaw mhnüpe üng, hikba ka pawh law khai, khyang naküta khana ka Ngmüimkhya ka bui law khai. Nami cakpae ja nami canglae naw ka ngthu sang khaie; cawngpyange naw Pamhnama mdan hmu law khaie, axü ngvaie müngmang mah khaie. ");
INSERT INTO dao_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Acuna khaw mhnüpe üng, ka mpyae nghnumi kpami avana khana ka Ngmüimkhya ka bui khai, amimi naw ka ngthu sang khaie. ");
INSERT INTO dao_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Khana vekia khankhawa cäica phyaki he ja, mcea vekia mdek khana kyühkyawk phyaki he ka ja mdang khai. Thisen lawng khai, mei ve law lü meikhu ngmüp khai. ");
INSERT INTO dao_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Hlüngtai kyäpsawkia Bawipaa kyum lawnak vaia Mhnüp am a pha ham üng, jin mü law lü khaw nghmüp law khai, khya pi thisena thawn lü sen law khai. ");
INSERT INTO dao_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Acunüng, au pi Bawipa naw a jah yung vaia khüki naküt küikyannak khai’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isarel khyange aw, hina ngthue cän ngai ua, Pamhnam naw Nazaret Jesuha ana cun müncam phyaki he ja kyühkyawk phyaki he ani üng a mdang pänga kyaki. Acune cun nami veia ngdang pängkia kyase nami van naw nami ksingki. ");
INSERT INTO dao_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pamhnam naw a mlung ngaiha mäiha Jesuh cun nami kut üng ning jah mhjum pängki ni; acunüng, nangmi naw ani cun khyang ksee mah maha kutlamtung üng nami jah hnimsaki. ");
INSERT INTO dao_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Acunüngpi Pamhnam naw thihnak üngka, mtho be lü a lätsaka kyaki. Acunakyase thihnak naw ani cun am a man theia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ania mawng cun Davit naw pyen lü, ‘Bawipa cun am ka ve ham kcüne üng ka hmuki, ani cun ka hlawnga veki, kei üng ng’änak am ve. ");
INSERT INTO dao_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Acunakyase, ka mlung jenak üng be lü ka ngthu pi jekyainak üng beki. Kei cun thi theikia pumsaa ka kya üngpi, äpeinak üng ka ngtungjin khai. ");
INSERT INTO dao_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Isetiakyaküng, nang naw kei cun thihnak khawmdeka am na hawiki; sitihkia na mpya cun ng'uhnaka a thu vai am tängki. ");
INSERT INTO dao_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nang naw xünnaka lam cun na, na mhnuh päng ni, atänga na, na vepüinak naw na jekyaisak khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ka püie, mi pupa üng ngming ngthangkia Davit sangpuxanga mawng cun angsinga ka ning jah mtheh khai ni. Ani cun thi se ami k’ut pänga kyaki, a lungdü pi tuh vei cäpa mi veia ve hamki. ");
INSERT INTO dao_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ani cun sahmaa kyase, ani naw Mhnama khyütam ksingki, Davita ngsawn üngka mat mat cun Davita kba sangpuxanga kya be khai tia Pamhnama khyütam cun ksingki. ");
INSERT INTO dao_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Pamhnam naw ngawia i bi law khai ti cun Davit naw hmu lü, Mesijah a thawh be vaia mawng a pyennak üng, ‘Ani cun thihnak khawmdeka käh hawih khai, a pumsa pi ng'uhnaka käh thuei khai’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Acuna Jesuh cun Pamhnam naw thihnak üngkhyüh mtho be lü, mi van cun acuna saksia mi kyaki. ");
INSERT INTO dao_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ani cun a pa, Pamhnama khet da mhlünmtaia kyaki, a khyütama mäiha Ngmüimkhya Ngcim cun a pa veia yah lü, atuh nami hmu ngjaka a bänak cun mi khana a pha lawsaka kyaki. ");
INSERT INTO dao_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davit cun khankhawa am kai ham; acunsepi ani naw pyen lü, ‘Bawipa naw ka Bawipa veia: Ka khet lama ngawa, ");
INSERT INTO dao_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","na yee cun na khawpha na mtainak vaia am ka jah tak hama küt üng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Acunakyase, Isarel khyange aw, nangmi naw kutlamtung üng taih u lü nami hnima Jesuh cän, Pamhnam naw Bawipa ja Mesijaha thawnsak päng ni ti cän angtea nami ksing vai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Acun ngjakia khyange cun aktäa ami mlung cäicing se, Pita ja ngsä kceea veia, “Benae aw, i kami pawh khai?” ti u lü, kthähkie. ");
INSERT INTO dao_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Acunüng, Pita naw, “Ngjut ua, nami mkhyekat mhlätnak vaia Jesuh Khritawa ngming am Baptican khan ua; acunüng, Pamhnama Ngmüimkhya Ngcim nami yah khai. ");
INSERT INTO dao_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pamhnama khyütam cun, nangmia phäh, nami caea phäh ja, akthuknaka vekiea Bawipa mi Pamhnam naw a veia a jah khü naküta phäha kyaki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Acuna thea, Pita naw ngthu khawha pyen lü, “Hina khyang ksee phäh law khaia mkhuimkhanak üngkhyüh ng’yungei ua” tia, a jah nghuinak. ");
INSERT INTO dao_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Khyang khawhah naw ania ngthu pyen cun jum u lü Baptican khankie, acuna mhnüp üng khyang thawng kthum bang ngkhaw lawki he. ");
INSERT INTO dao_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Acune cun, Ngsäe naw jah mthei u se, atänga ve u lü, atänga eiaw u lü, atänga ktaiyü lü vekie. ");
INSERT INTO dao_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ngsäe naw müncam phyaki he ja kyühkyawk phyaki he khawhah ja pawh u se, khyange cun cäi päihkie. ");
INSERT INTO dao_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jumeikie naküt cun mlungkaw mat am ve u lü ami khawhthem he pi yetca u lü summangkie. ");
INSERT INTO dao_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Amimi cun ami khawhthem he jah jawi u lü, ami yaha ngui cun hlükawki mat cim üng ami jah yet u. ");
INSERT INTO dao_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Amimi cun amhnüp tä se Templea ngkhyum u lü, ami ima pi mlung nemnak ja jekyainak am atänga eiawki he. ");
INSERT INTO dao_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pamhnam mküimto u lü, khyang naküta jenak vaia vekie. Acunüng Bawipa naw küikyannak yahkie cun amhnüp tä se jah mkhaw lü amimi cun a jah nungsak. ");
INSERT INTO dao_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Acunüng, Pita ja Johan cun mü lam naji kthum üng ktaiyü khaia ktaiyünaka kcün üng Templea citki xawi. ");
INSERT INTO dao_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Khyang mat a hmi law üng tün lü xoki ami kaw law. Temple k'uma lutkiea veia kthähei khaia, mkawt ngto ami tia peia, amhnüp tä se ami vesak; ");
INSERT INTO dao_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Acun naw Pita ja Johan Temple k'uma lut hlüki xawi ja hmu lü, ani veia kthäheiki. ");
INSERT INTO dao_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita ja Johan naw ani bükteng, cun üng, Pita naw, “Ja büktenga” a ti. ");
INSERT INTO dao_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Acunüng, ani naw ani veia icamä yah khaia ngai lü, ja han bükteng se, ");
INSERT INTO dao_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita naw, “Ngui ja xüi am ta üng; acunsepi ka tak ka ning pe khai: Nazaret Jesuh Khritawa ngming üng na khaw am ngdüi lü cita” a ti. ");
INSERT INTO dao_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita naw a khet kut man lü mtho se; acun ja angxita a khaw xawi ja a khawmike cun kthamah law bekie. ");
INSERT INTO dao_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ani cun tho law lü, ngdüi lü a khaw am citki. A khaw am cit hü lü, ju jawng hang jawng lü, Pamhnam a mhlünmtai maha Temple k'uma lut haki. ");
INSERT INTO dao_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Acunüng, a khaw am cit hü lü, Pamhnam a mhlünmtai cun khyange naw hmu u lü; ");
INSERT INTO dao_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ani cun Temple mkawt ngto ami tia peia kthähei lü ngaw khawiki tia ksing u lü; ania mawng cun aktäa cäicatnak u lü vekie. ");
INSERT INTO dao_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A khaw daw beki naw Pita ja Johan a jah man k'um üng, khyang naküt cun aktäa cäi u lü Solamona ngvawng mkawt ami tia hnün, ami veia dawng lawki he. ");
INSERT INTO dao_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita naw acun a hmuh ja khyange ja msang lü, “Isarel khyange aw, hin hin ise aktäa nami cäinaki ni? Kamimäta khyaihnak ja kamimäta binak thei am ani cit thei khaia kami pawhkia mäiha i se nami ngaiki ni? ");
INSERT INTO dao_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isak ja Jakopa Pamhnam, mi pupaea Pamhnam naw, a mpya Jesuh cun mhlünmtaiki ni; ani cun nami ja mansak, Pilat naw mhlät vai a ti üngpi am nami tängki. ");
INSERT INTO dao_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ani cun ngcim lü dawki ni lüpi nami mahkie, Khyang ngcimcai ja khyang ngsungpyun am ngai u lü, khyang hnimki mhlät vaia ksaia Pilat nami kthähki. ");
INSERT INTO dao_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Xünnaka Bawi cun nami hnimki; acunsepi Pamhnam naw thihnak üngka a mthawh be ni; acun saksia kami kyaki. ");
INSERT INTO dao_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesuha ngming naw ni hina akxo cen kyanak a pet ve. Nami hmu ja nami ksing hin Jesuha ngming jumnak ka phäha ni akya ve. Tuhkbäih nami hmu thei hin Jesuh üng jumeinaka phäha ni akya ve. ");
INSERT INTO dao_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Acunsepi, ka benae aw, nami ngvaie naw am ami hnaläüa phäha ami pawha mäiha, nami naw pi am ami hnaläü ka ksingki. ");
INSERT INTO dao_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Acunsepi Pamhnam naw sahmae naküt üng, Khritaw naw khuikhanak a khamei vaia ngthu ana pyen law cen, acukba küm lawsaki ni. ");
INSERT INTO dao_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Acunakyase, nami mkhyekatnake ja mkhyünak vaia ngjut u lü nghlat be ua, acunüng, Bawipa naw nami mkhyekatnak ning ja mhlät khai. ");
INSERT INTO dao_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Acunüng, Ngmüimkhya kyanak akcün Bawipa üngka naw pha law se, nami phäha a mcawn päng Mesijah Jesuh cän tüi law khai. ");
INSERT INTO dao_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Acunsepi, Pamhnam naw a sahma ngcimea mpyawng üng ajana a na jah pyen lawe, avan akthaia pyannak bea kcün am a pha hama küt üng, khankhawa ani cun a veia vepüi ma khai. ");
INSERT INTO dao_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosi naw, ‘Bawipa nami Pamhnam naw, keia mäi sahma mat nangmi üngka ning jah tüih law pe khai; ani naw nami veia ngthu a pyen naküt cun nami ngaih pet khai; ");
INSERT INTO dao_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","au pi, acuna sahma a ngthu käh ngaiki naküt cun, Pamhnama khyang üngka naw mkhya lü, mkhyüha kya khai’ a ti ni. ");
INSERT INTO dao_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sahma Samuilah üng tün lü, ak’hnu säiha ngthu pyenkiea sahmae cäpa, ami van naw atuha akcüna mawng cun a na pyen khawikie. ");
INSERT INTO dao_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nangmi cun Pamhnam naw nami pae am a na pyen law, sahmae ja ngthumkhäna caea nami kyaki ni; Pamhnam naw Abrahama veia, ‘Nanga ngsawn am khawmdek khyange naküt jodawnak am be khaie tia, nami pupaea veia a jah ngthumkhän. ");
INSERT INTO dao_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pamhnam naw a Mpya cun xü lü nami veia a tüih law ma, acun naw nami mkhyenak nglata u lü jodawnak ning jah pe khaia kyaki ni” tia khyangea veia a pyen. ");
INSERT INTO dao_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ja Johan naw khyangea veia ngthu ani pyen k'um üng, ktaiyüe, Temple mtätki ngvaie ja, Sadukee cun ani veia pha lawki he, ");
INSERT INTO dao_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","khyang ani ja mthei ja, Jesuha phäha khyang kthi a thaw bea ngthu ani pyena phäha, ami mlung aktäa am je. ");
INSERT INTO dao_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ja man u lü, mü lama akyaa phäha, ngawi cäpa thawngim üng ami ja khyum. ");
INSERT INTO dao_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Acunsepi, ngthu ngaikie jumei u lü; acune cun thawngmhma bang lawki he. ");
INSERT INTO dao_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Acunüng, a ngawia, Judah mkhawnge, ami ngvaie, thum ksinge Jerusalema ngbäm lawki he. ");
INSERT INTO dao_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Amimi cun ktaiyü ngvai säih Anna, Kaiphah, Johan, Aleksanda ja, ktaiyü ngvaia a pacae naküt üng nghmukie. ");
INSERT INTO dao_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pita ja Johan cun anglunga jah ngdüihsak u lü, “Ihawkba ahin nani pawh ni. Ia johit ja ua ngming nani sumei ni” ti u lü ami jah kthäh. ");
INSERT INTO dao_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita naw Ngmüimkhya Ngcim am be lü ami veia, “Khyanga, mkhawnge ja ngvaie aw, ");
INSERT INTO dao_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","a khaw kxo mdaw be üng, ‘Hin hin ise daw law beki ni?’ tia tungawi keini nami jah kthäh üng, ");
INSERT INTO dao_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nami ngkhä naw ksing ua, Isarel khyange naküt naw pi ksing u se, Nazaret Jesuh Khritaw kutlamktung üng nami taih, Pamhnam naw thihnak üngka naw a mthawh be, ania ngming am, hin üng nami hmaia mya lü ngdüiki. ");
INSERT INTO dao_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesuh mawng Cangcim naw a pyen ta, imsae naw ami hawiha lung cun akyäp säiha thawn law be khai, a ti. ");
INSERT INTO dao_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Küikyannak hin ani üngkhyüh ni a law, khankhawa kea jah küikyan khaia ania thea ta Mhnam naw u pi am pe.” ");
INSERT INTO dao_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Acunüng kawngci üng ngpüikie naw Pita ja Johana ani lingnak jah hmu u lü, ca am ksingki xawi, khyang sawxat xawi tia ami ja ksing üng, aktäa cäikie; ani xawi cun ajana Jesuh hlawnga ve khawiki xawi tia ami jah ksing law. ");
INSERT INTO dao_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Acunüng, Pita ja Johan naw ani mdaw be cun ani hlawnga ngdüi se ami hmuh ua kyase, ipi am pyen thei u. ");
INSERT INTO dao_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Acunakyase kawngci k'um üngkhyüh jah ksät u lü ami mät ngthähngkhyahkie. ");
INSERT INTO dao_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Hin xawi hin ihawkba mi jah pawh vai u ni? Müncam phya kcangki pawhki xawi ni tia, Jerusalem mlüha veki avan naw ksingkie; mimi naw pi mi ksingki. ");
INSERT INTO dao_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Acunsepi, khyangea veia am ani jah mtheh hü vaia, atuh üng tün lü, ua veia pi hina Jesuha ngming üng käh ani jah mtheh hü vai ja mi jah pawh vai u ami ti.” ");
INSERT INTO dao_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Acunüng, Pita ja Johan jah khü u lü, Jesuha ngming pyen lü käh ani jah mthei vaia ami jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Acunsepi, Pita ja Johan naw ami msang ta, “Pamhnama hmuha Pamhnama ngthu ngaih hin dawki aw, nangmia ngthu ngaih hin daw bawk khai aw ti cun ngai sum u. ");
INSERT INTO dao_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Keini ta kani hmuh ja kani ngjak cun am pyen lü am ve thei ni ngü” ani ti. ");
INSERT INTO dao_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Acunüng, kawngci ngvaie naw jah mkyüh kse hlen be tü u lü, ami jah mhlät be. Acunüng, ani bilawha phäha khyang naküt naw Pamhnam mküimtokie; khyangea phäha ami jah khuimkhanak vaia am hmu lü vekie. ");
INSERT INTO dao_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Müncam phya khaia ani mdaw be cun kum kphyükipa kthaka dämkia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Acunüng, Pita ja Johan cun ani lät be ja, ani püiea venaka cit ni lü, ktaiyüe ngvaie ja angvaie naw ani veia ami pyen naküt ani ja mtheh be. ");
INSERT INTO dao_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Acunüng, acun ami ngjak üng, atänga Pamhnama veia ami ktaiyü ta, “Bawipa aw, nang khankhaw, khawmdek ja mlik tui ja a k'uma veki naküt mhnünkia na kyaki; ");
INSERT INTO dao_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","nang naw, Ngmüimkhya Ngcim am, na mpya Davit kami pupa naw a pyen ta, ‘Ise khyang mjü kce ami mlungsoki? Ise khyange naw, am ngtähkia ngaikie ni? ");
INSERT INTO dao_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Khawmdek sangpuxange ja jah upkie naw atänga ngkhyum u lü, Bawipa ja Mesijah cun jah ngtük ngkhaih püikie ni’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Hina mlüh üng na mpya ngcim Jesuh, Mesijaha na mcawn hneng u lü, Herod ja Pontas Pilat cun khyang mjü kcee ja Isarele akcanga ngkhyumkie ni. ");
INSERT INTO dao_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Thawn law khaia na khyaihnak ja na ngjak'hlüa ajana na mhnün päng cän pawh khaiea atänga ngcun lawki he. ");
INSERT INTO dao_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Acunüng, Bawipa aw, atuh ami jah mkyüh hin büktenga; na mpya xawi hin lingnak am na ngthu jah pyensaka. ");
INSERT INTO dao_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Khyange jah mdaw be khai xawia, nang naw na kut säng lü; na mpya ngcim Jesuha ngming am, müncamnak ja cäicatnak jah pawhsak kawm pi” tia, ktaiyükie. ");
INSERT INTO dao_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Acunüng, acukba ami ktaiyü law päng ja, ngkhäm u lü, ami venak cun ngsün lawki. Ami van Ngmüimkhya Ngcim am be law u lü Pamhnama ngthu cun ling lü sangkie. ");
INSERT INTO dao_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Acunüng, jummeikia khyange cun, mlung mat takie. U naw pi ami ka üng ka kaa ni am ti u. Ami tak cun avan naw ng’yeteikie. ");
INSERT INTO dao_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Acunüng, ngsä he naw johit däm üng Bawi Jesuha thawnak be cun saksi na u se; ami khana dawkyanak Mhnam naw jah peki. ");
INSERT INTO dao_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Acunüng, ami veia hlükawki u am ve; ime ni, laie ni, jah takie naw jawi u lü, ami jawiha phu ja lawpüi u lü, ");
INSERT INTO dao_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ngsä hea khaw kunga, jah ta law u se, hlükawki üng ahlükawa kba ami jah yet. ");
INSERT INTO dao_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Acunüng, Josep, Kuparuh khaw khyang, Levih paca, ngsä he naw Banabah ami ti, (Acun cun “ngjuktha jah pe theiki”) naw, ");
INSERT INTO dao_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","a lo jawi lü, a yah ngui cun law püi lü, ngsä he üng a jah ap. ");
INSERT INTO dao_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Acunsepi, khyang mat Anani ngmingnaki, a khyu Saphira am veki xawi; Ani xawi naw khawhnün jawi lü, ");
INSERT INTO dao_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","a khyua ksinga khawhnün phu avang thup lü, avang däk lawpüi lü Ngsäea khaw kunga a tak law. ");
INSERT INTO dao_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Acunsepi, Pita naw, “Anani aw, Ngmüimkhya Ngcim na mhlei na khai ja, khawhnün phu avang na mji khaia, ise khawyam naw na mlung üng bi a bi ni? ");
INSERT INTO dao_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Acuna khawhnün cun a ve ham üng na kaa am kyaki aw? Na jawih käna a phu haw na kaa am kya se aw? Ise hikba na ngaiki ni? Khyang na mhleiki am ni, Pamhnam na mhleiki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Acunüng, Anani naw acuna ngthu a ngjak ja kyu lü thiki; acunüng, ksingkie naküt cun aktäa kyüheikie. ");
INSERT INTO dao_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Acunüng, cawngpyange naw ngdüi law u lü, a yawk hlawp u lü kawtkie naw ami va k’ut. ");
INSERT INTO dao_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Acunkäna, naji kthum bang anghjawk ja, a khyu i am ksing lü, lut lawki. ");
INSERT INTO dao_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita naw, “Na mtheha, khawhmün cun hihah däka aw nani jawi?” ti lü, a kthäh. Acunüng, ani naw, “Ä hihah däka ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Acunüng, Pita naw, “Ise Bawipaa Ngmüimkhya cam khaia nani büki ni? Tenga, na cei k’utkiea khawleh mkawt peia veki, nang pi ni kawt hnga khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Acun üng angxita, a khaw kunga kyu lü thi sawxatki; acunüng, cawngpyange lut lawki he naw thi se hmu u lü, kawt u lü a ceia peia ami k’ut hnga. ");
INSERT INTO dao_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Acunüng, sangcime avan ja acuna ngjakie naküt naw aktäa kyüheikie. ");
INSERT INTO dao_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Acunüng, khyangea ksunga Pamhnam naw, Ngsäea khyüh müncamkse ja cäicingnak phyaki he khawha, jah biki. Acunüng, ami cun ami ngkhä mlung mat ta u lü, Solamona mkawt ami tia, atänga nghmukie. ");
INSERT INTO dao_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Khyang kce u pi ami veia am ngkhaw dat; acunsepi khyange naw aktäa jah mhlünmtaikie. ");
INSERT INTO dao_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Acunüng, Bawipa jumei law kthaikia nghnumie ja kpamie khawha cun ami veia ngkhaw lawki; ");
INSERT INTO dao_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Acunüng, Pita cit hü lü a hnge naw a jah hneh vaia am myakie cun lama jah kawt law u lü ihnake ja phakea khana ami jah takie. ");
INSERT INTO dao_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Acunüng, Jerusalem mlüh pipeia kae am myakie, khawyai ksea jah venake cun jah law püi u lü lawki he; acune cun mya be päihkie. ");
INSERT INTO dao_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Acunüng, ktaiyü ngvai säih ja a püie Sadukee law u lü ngsä he ami jah ng’eiha phäh ami khana bi vaia ngtängkie. ");
INSERT INTO dao_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ngsä xawi jah man u lü thawngim üng ami jah khyum. ");
INSERT INTO dao_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Acunakyase mthana, Bawipa khankhawngsä mat naw thawng ksawhe jah mhmawng law lü akpung da jah cehpüiki naw, ");
INSERT INTO dao_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Cit ni, temple k'uma ngdüi ni lü, khyangea veia xünnak kthaia mawng va pyen nia” a ti. ");
INSERT INTO dao_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Acunüng, acuna ngthu ani ngjak ja, khaw thai law üng temple k'uma lut ni lü, jah va mtheimthangki xawi. Acunsepi, ktaiyü ngvai ja a püie law u lü, bawi ja, Judah ngvaie naküt cun kawngcia mkhäm lawki he naw, angsä xawi cun thawngim üngkhyüh ami ja lawpüi vaia thawngim da khyang ami ja tüih. ");
INSERT INTO dao_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Acunsepi, jung ngvaie ami pha law üng thawngima angsä xawi cun am jah hmu u; acunüng, nghlat law be u lü kawngci a ami jah va mtheh, ");
INSERT INTO dao_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Thawngim cun üp yekia ngkhai se, mtätkie pi ksawh peia ngdüi u se kami jah hmuh; acunsepi, kami mhmawng üng, a k'uma u pi am ja hmuh ve üng” ti u lü, ami ja mtheh law. ");
INSERT INTO dao_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Acunüng, temple mtätkie ja ktaiyü ngvaie naw acuna ngthu ami ngjak üng, hikba ngsä hea ve hin i a ngjo ni tia, aktäa cäicingkie. ");
INSERT INTO dao_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Acunüng, khyang mat law lü ami veia, “Teng u, thawngima khyang nami ja khyum xawi naw temple k'uma ngdüi ni lü khyange jah mtheimthang ve ni” a ti law. ");
INSERT INTO dao_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Acunüng, temple ngvai cun ami khyange am va cit u lü, khyange naw lung am ami jah kawng vai kyüh u lü, angsä xawi cun akdawa ami jah lawpüi be u. ");
INSERT INTO dao_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Acunüng, ja pha lawpüikie naw, Kawngci ja ktaiyü ngvai säiha hmaia jah ngdüihsak lü ami jah kthäh. ");
INSERT INTO dao_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ahina ngming am käh nani jah mthei ti vai, tia kami ning jah mtheh päng, ngthu nani ja mtheinak cun Jerusalem üng ngthang hüki, “nani pawh cun ngai nia” ti lü a jah pyen. Ania thinak hin keimi khana nani phaw lawsak vaia nani pawhki aw. ");
INSERT INTO dao_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Acunsepi, Pita ja ngsä kcee naw, “Khyanga pyen kami ngaiha kthaka Pamhnama pyen ni kani ngai khawm. ");
INSERT INTO dao_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","“Nangmi naw Jesuh kutlamktung üng taih u lü, nami hnim cän kami pupaea Pamhnam naw mtho be pängki ni. ");
INSERT INTO dao_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","“Ani cun Pamhnam naw khawngmang ja küikyankia ve khaia Isarele ami mkhyekatnak üngkhyüh ngjut be lü ja mhlät khaia a khet da mhlünmtaiki. ");
INSERT INTO dao_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Acuna saksia kani kyaki ni; Ngmüimkhya Ngcim, Pamhnam bänak cun ani kcangnakia phäh ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Acunüng, acuna ngthu kawngci vawne naw ami ngjak üng, ami mlungso law se, Ngsäe cun jah hnim law hlükie. ");
INSERT INTO dao_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Acunsepi, Kawngci üngka khyang, a ngming Kamaleilah naki, Phariseea thum ksingki, khyange naküt üng a ngming ngthangki cun ngdüi law lü angsä xawi cun ami jah khyah be vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Acunüng, Kawngcia veia, “Nangmi Isarel khyange aw, hin xawia khana nami pawh vaia nami bü cän cäi lü ngai ma ua. ");
INSERT INTO dao_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","“Ahlana pi, Theuhdah naw, ‘Kei khyang sawxat am ni’ ti lü ve se; a veia khyang khawha, phyakphyü bang a veia ngdawn vaikie. Acunsepi ani cun hnim u se, a ngthu läkie naküt pi avan cencawn hü päih u lü, ia am kya bekie ni. ");
INSERT INTO dao_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Ania ve käna, ngming yu u lü ami mkhäm k'um üng, Kalilea ka Judah naki ve law beki; a veia khyang khawhah citkie. Acunsepi, ani pi thi se, a hnu läkie avan khyük päihkie. ");
INSERT INTO dao_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Acunakyase, atuh ka ning jah mtheki, hina khyange käh ja pana u, ani büa ve u se; ani mkhyäp ja ani bilawh, khyanga pawh sawxata akya üng amdanga khyük be sawxat khai ni; ");
INSERT INTO dao_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","acunsepi, Pamhnama bilawha, akya üng, am jah näng thei uki; am acunüng, Pamhnam nami tukia ksaia nami kya khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Acunüng, acuna pyen cun ngaisim u lü, angsä xawi cun jah khükie naw ami jah kpai; ami ja kpai päng üng Jesuha ngming am ngthu käh sang hü be ti khai xawia ami ja khyah be. ");
INSERT INTO dao_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Acunüng, Kawngci üngka naw cit be ni lü, acuna Jesuha phäh luthui hmaisetnak khamei khaia ani nglawia phäha, aktäa jekie. ");
INSERT INTO dao_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Acunüng, amhnüp tä se, temple ja khyangea ima, Jesuh Mesijah mawng cun jah mtheimthang lü sangkie. ");
INSERT INTO dao_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ivei am law ham se, axüisawe nung law u lü, Krik ngthu pyenki Judahe ja Judah ngthu pyenkie cun mtumbäkie. Krik ngthu pyenkie naw kami hmeinue ngcawn ami teyet üng ami jah hawih u ni ami ti. ");
INSERT INTO dao_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Acunüng, a ngsä xaleinghngihe naw jumki khyange avan ja khü u lü “Pamhnama ngthu pyen, hawih u lü ngui xüia phäh kami bi hin am daw ve. ");
INSERT INTO dao_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Acunakyase, ka püie, nami ksunga Ngmüimkhya ja themnak am bekia khyang khyüh xü ua, amimi cun ahin, khut na khaiea kami ja mcawn khai; ");
INSERT INTO dao_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kamimäta, ktaiyünak ja ngthu pyennaka khutbi akcün täse kami bi khai” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Acuna ngthu naw avan cun a jah jesak; acunüng, jumeinak ja Ngmüimkhya Ngcim am beki Stephen, Philip, Pyakhaw, Nikanor, Tihmon, Parmenah, ja khyangmjükce Judahea jumnak üng ngpyawtki Antiok üngka Nikolah cun ami jah xü. ");
INSERT INTO dao_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Acune cun Ngsäea hmaia ja ngdüisak u se, Ngsäe naw ami kut taih u lü ami jah ktaiyü pet. ");
INSERT INTO dao_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Acunüng, Pamhnama ngthu cun hnün khawha üng pha hü se; Jerusalema axüisawe aktäa nung law dämdämkie. Acunüng, ktaiyüe üngkae khawha naw jumnak yahkie. ");
INSERT INTO dao_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Acunüng, Stephen cun Mhnama dawkyanak ja johit am be lü khyangea veia cäicatnake ja müncamkse jah pawhki. ");
INSERT INTO dao_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Acunsepi, khyang avang, “Sinakok üngka mpya kläte” ami ti cun Kurinih hnea Judahe, Aleksandria hnea Judahe, Kilikih hnea khyange, Asah hnea khyange naw lawsih u lü Stephen cun ami ngcuh lawpüi. ");
INSERT INTO dao_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Acunsepi, Ngmüimkhyaa pet themnaka phäh Stephen ngthu a pyen üng am näng khawh u. ");
INSERT INTO dao_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Acunüng, khyange ami hlei pyen khaiea; acune naw, “Mosi ja Pamhnam jah kpetnaka ngthu pyen se kami ngjaki” ami ti vaia ami jah kcük. ");
INSERT INTO dao_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Acunüng, khyange cun, angvaie ja thum ksinge ami jah ksük, ami mlungso law lü, Stephen cun man u lü kawngcia ami cehpüi u. ");
INSERT INTO dao_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Acunüng, ami hlei pyen khaiea ja ksük u se; acune naw, “Hin naw, hina ngcimcaihkia Temple ja Mosia Thum ja kse naki; ");
INSERT INTO dao_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Hina Nazaret Jesuh naw hina Temple phyeh lü Mosi naw a jah peta thume jah nglatsak khaia a pyen kami ngjaki ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Acunüng, Kawngci üng ngawki he naw Stephen cun bükteng u lü, a hmai cun khankhawngsäa hmaia mäiha ami hmuh. ");
INSERT INTO dao_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Acunüng, ktaiyü ngvai naw, “Acuna ngthu kcangki aw?” ti lü, Stephen a kthäh. ");
INSERT INTO dao_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Acunüng Stephen naw msang lü, “Ka bee jah ka pae aw, ngai ua, mi pupa Abraham, Haran khawa am a ceh ham üng Mesopotemiha Pamhnama hlüngtainak a veia ngdang law lü, ");
INSERT INTO dao_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Na khaw ja na im üngka naw cit lü ka ning mhnuh vaia pea cita” a ti. ");
INSERT INTO dao_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Acunüng, Abraham cun Khalade khaw üngka naw cit lü Haran khawa va veki; acunüng, a pa a thih käna hina atuh nami venak khawa Pamhnam naw a ngkawnsak. ");
INSERT INTO dao_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Acunüng, hia ta a venak vai, a khawpa a takeinak vai pi Pamhnam naw am pe; acunsepi, amät ja a ngsawne cäpa khawh a jah pet vaia am a ca ham üng tün lü khyütamki. ");
INSERT INTO dao_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Acunüng, Pamhnam naw, ‘Na mjükphyüie khyanga khawa kum phyakphyü ve khaie, khyanga mpyaa ve u se, jah khuimkha khaie’ tia a pyen. ");
INSERT INTO dao_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Acunüng, Pamhnam naw, ‘Amimi jah mpya na khaia khyang mjüe pi kamät naw ami lei ka jah mtai law pe khai. Acun käna lät law be u lü, hina hnün üng na hjawkhah law khaie’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Acunüng, Pamhnam naw vun mawih vaia ngthumkhän pe se; acunüng, Abraham naw Isak ca na lü amhnüp khyetnak üng a vun a mawi pet; acunüng, Isak naw Jakop ca na se, Jakop naw a ca xaleinghngihea vun a jah mawih pet acune cun nglo ngthangkie mi pupae ni. ");
INSERT INTO dao_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Acunüng, Jakopa cae naw ami na Josep k’eih u lü Egypt pea ami jawihei; acunsepi, Pamhnam naw vepüi lü, ");
INSERT INTO dao_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a khuikhanak naküt üng küikyanki. Josep cun Egypt sangpuxanga maa a pha vai üng Pamhnam naw ani üng themnak ja a hmai vainak pe se, Pharo sangpuxang naw Egypt pe ja a im üng ngvai säiha a mcawn. ");
INSERT INTO dao_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Egypt ja Kanan pe avan üng khawjaw law se, khuikhanak aktäa ve lawki; mi pupae cun ami ei vai i am ta u lü vekie. ");
INSERT INTO dao_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Acunsepi, Jakop naw Egypt pea cang veki tia ksing lü a cae a jah tüih; acun cun ami cehnak akcüksäiha kyaki. ");
INSERT INTO dao_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Acunüng, anghngihnaka ami ceh üng, Josep cun a beea üng jah mtheh se; acunüng, Josepa khuiima mawng cun Pharo naw a jah ksing law. ");
INSERT INTO dao_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Acunüng, Josep naw a pa Jakop ja a benae naküt a jah khüsak; ami van khyühkip ja hma lawki he. ");
INSERT INTO dao_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakop cun Egypt pea ju citki; acunüng, ani ja a tucae cun thikie. ");
INSERT INTO dao_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ami yawke cun Sikem khawa jah cepüi u lü Abraham naw Sikem khawa Hamoa sanga veia ngui am a khyäiha ng'uhnak üng ami ja k’ut. ");
INSERT INTO dao_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Acunüng, Pamhnam naw Abrahama veia khyütam akpha law hlü üng, Jakopa mjükphyüie cun Egypt pea nung mja lawki he. ");
INSERT INTO dao_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Josep am ksingkia sangpuxang akce naw Egypt cun up lawki. ");
INSERT INTO dao_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ani naw mi pupae jah mkhuimkha lü hnasen he pi thi khaia im üngkhyüh a jah xawt tawnsak. ");
INSERT INTO dao_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Acunüng Pamhnama hmaia aktäa ngtokia, Mosi hmi law se, a pa ima khya kthum ami mcah; ");
INSERT INTO dao_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","acun käna ami tawnnaka, Pharoa canu naw lo lü amäta ca vaia a mcahei. ");
INSERT INTO dao_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Acunüng Mosi cun Egypt pea ami ksingkhyapnak naküt jah mthei u se, bilawnak ja pyensaknak thei üng be lawki. ");
INSERT INTO dao_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kum kphyükip a cum üng, a püi Isarele ihawkba vekie ti cun ja va bükteng khaia ngtängki. ");
INSERT INTO dao_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Acunüng Isarel khyang mat Egypt khyang naw khuimkha se hmu lü, yungki naw Egypt khyang cun a hnim. ");
INSERT INTO dao_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Pamhnam naw ani am a khyange jah yung khai tia, a khyange naw ksing khaiea ngai sepi, am ksing u.) ");
INSERT INTO dao_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Angawi law be tü üng amimät üngka xawi ngtunngpyei nise jah hmu law lü, ‘Ka püi xawi aw, bengna xawia nani kyaki, ise nani ngtunngpyeiki ni?’ ti lü ja mkhya khaia bü se, ");
INSERT INTO dao_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","a püi ngtunpüiki naw Mosi buk lü, ‘Kani khana suki ja ngthumkhyah mkhawnga u naw aning mcawn ni? ");
INSERT INTO dao_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Müta Egypt khyang na hnima kba na na hnim khaia na büki aw?’ a kthäh. ");
INSERT INTO dao_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Acun a ngjaka phäha Mosi Midian pea cen lü, acuia cakpa nghngih a canak. ");
INSERT INTO dao_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kum kphyükip a nghjawk käna, Sinai mcung pei khawkhyawng khawa meia däiki kpyap üngka naw, khankhawngsä mat a veia ngdang lawki. ");
INSERT INTO dao_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosi naw acun a hmu üng, aktäa cäi lü bükteng khaia a va k’et üng, Bawipa kthai naw, ");
INSERT INTO dao_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kei cun na pupaea Pamhnam ni, Abrahama Pamhnam, Isaka Pamhnam, Jakopa Pamhnam ni’ ti se, acunüng, Mosi naw kyüh lü am a bükteng dat. ");
INSERT INTO dao_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Acunüng, Bawipa naw, ‘Na khawdawk cän suta; isetiakyaküng na ngdüinak cän hnün ngcimcaiha mdek ni. ");
INSERT INTO dao_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egypt pea ka khyang vekiea ami khuikhanak aktäa hmu veng, ami ngko pi ngja veng, ami jah küikyan khaia ka kyum lawki ni. Tuhkbäih cita, Egypt pea ka ning tüih khai’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Acuna Mosi, ‘Kani khana suki ja ngthumkhyah mkhawnga u naw aning mcawn ni?’ tia Isarele naw ami mah cun, kpyapa k'uma a veia ngdang lawkia khankhawngsä naw kpüi se, Pamhnam naw ani kung cun ngvai ja küikyan khaia a tüiha kyaki. ");
INSERT INTO dao_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ani naw Egypt pe, Mpanglai Sen ja khawkhyawng khawa kum kphyükip üng, cäicatnak vaie ja müncamkse ja pawh lü a ja ngkhah lawpüi. ");
INSERT INTO dao_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Isarel khyange üng ‘Pamhnam naw kei ana mcawna mäiha, nami benae üngka sahma mat ning ja mcawn pe khai’ ti lü jah mthehki cun acuna Mosia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ani cun, khawkhyawng khawa ngkhämkiea veia pi kyase, Sinai mcunga ngthuheipüikia khankhawngsäa veia pi kyase, ja mjükphyüi nakiea veia pi kyase ve lü mimi a jah pet vaia xüngseiki Pamhnama ngthu yahkia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ania ngthu cun mi pupae naw käh ngai u lü, ami mlung üng Egypt pea nghlat be vai ngjahlükie. ");
INSERT INTO dao_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Acunakyase Arona veia, ‘Ja ngkhahpüi khaia mhnam he jah pyan peta; Egypt pe üngka naw jah lawpüikia Mosi ihawkba veki ni am ksing ve üng’ ami ti. ");
INSERT INTO dao_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Acunüng, seca juktuh pyang u lü, acun cun xüngsei hnimki he naw hjawkhah u lü, amimäta kuta pyang cun ngkengtai u lü hlimtuikie. ");
INSERT INTO dao_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Acunakyase Pamhnam naw akcea ja jah nghlat ta lü, khankhawa aisie jah hjawkhah khaiea a jah pawh; acun cun sahmaea yuknak caup üng: ‘Isarel khyange aw, khawkhyawng khawa kum kphyükip üng axüngksei jah hnim u lü ngkengnak nami bilawh hin kei nami na hjawkhahnak am ni. ");
INSERT INTO dao_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Sama k'uma veki Moluk mhnam ceh hü lü aisi mhnam Rephan pi nami hjawkhah vaia a lup nami pyangki, acunakyase, Babalung pea nami mpya khaia ka ning jah tüih khai’ tia veki. ");
INSERT INTO dao_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mi pupae naw khawkhyawng khawa Mhnama venak vai sam takie. Acun cun Mhnama phäh nami pyan vai cun Mosi üng mtheh kba sam nami takie. ");
INSERT INTO dao_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Acun käna, mi pupaea naw sam cun lo u lü Josuh mah maha cit u lü cehpüikie, acun cun Pamhnam naw ni maa a jah ksät khyangmjüea khawa takie. Acun hin Davita a ve law cäpa acua veki. ");
INSERT INTO dao_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Acuna Davit cun Pamhnama mpyeneinak yah lü, Jakopa Pamhnama venak vai pyang khaia kthähki. ");
INSERT INTO dao_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Acunsepi, Solamon naw ni im cun a sak. ");
INSERT INTO dao_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Acunsepi, hlüngtai säihkia Mhnam cun khyanga kut am saka im üng am ve khawi; sahma naw pyen lü: ");
INSERT INTO dao_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Bawipa naw, ‘Khankhaw cun ka Bawingawhnaka kyaki, khawmdek cun ka khawpha ka mtaihnaka kyaki, im ia mäih nami na sak hlü peki ni? Ka venaka hnün cun ia mäih ni? ");
INSERT INTO dao_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kamäta kut am anaküt ka ja mhnünkia am kya aw?’ ti ve, ti lü a pyen ni. ");
INSERT INTO dao_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stephen naw msu lü, “Nami mlung ngcang ve, Pamhnama ngthu am nami ngjaki, anglät se Ngmüimkhya Ngcim nami mahki; nami pupaea ve ja nami ve täng ve. ");
INSERT INTO dao_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nami pupae naw sahmae am ami khuimkha khawi veki aw? Law khaia Ngsungpyunkia Mpyaa mawng sang lawki he Pamhnama ngsä he jah hnimki he. Atuh pi ani cun phyehei lü nami hnimki. ");
INSERT INTO dao_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mhnama thum, khankhawngsä hea naw ami ning jah pet cän yah u lü am nami läki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Acunüng, acuna ngthu cun kawngci khyange naw ami ngjak ja ami mlungso law se, Stephena khana mnicui kyetkie. ");
INSERT INTO dao_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Acunsepi, Stephen cun Ngmüimkhya Ngcim am bekia kya lü, khankhawa hang mangki naw, Pamhnama hlüngtainak ja Pamhnama khet lama Jesuh ngdüi se a hmu. ");
INSERT INTO dao_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Acunüng, Stephen naw, “Teng u.” “Khankhaw nghmawng lü Pamhnama khet lama Khyanga Cakpa ngdüiki pi hmu veng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Amimi cun angsanga ngpyang u lü, ami nghnga jah kbümeikie naw, atänga kyaksih u lü, ");
INSERT INTO dao_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","mlüh k'um üngka naw akpunga kaih u lü, lung am ami khawng. Saksi vai ami suisake cun Sawluh ngming naki cawngpyang mata khaw kunga ami jah tak. ");
INSERT INTO dao_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Acunüng, lung am aktäa ami khawng k'um üng, Stephen naw, “Bawipa Jesuh aw! ka Ngmüimkhya labea” ti lü ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Acunüng, a mkhuk ngdäng lü, angsanga ngpyang lü, “Bawipa aw, hina ami mkhyekatnak cän käh ja thung be kawpi” a ti. Acuna ngthu a pyen päng ja thiki. ");
INSERT INTO dao_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawluh naw Stephen ami hnim vai jah tängpüiki. Acuna mhnüp üng Jerusalem mlüha veki sangcim cun aktäa mkhuimkhanak kham lawki he; acunakyase, Ngsäe däk ve hüt u se, jumeikie naküt cun Judah ja Samarih hnea ngpyeng hükie. ");
INSERT INTO dao_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Acunüng, Pamhnam jumkie naw, Stephen cun k’ut u lü, aktäa ami kya. ");
INSERT INTO dao_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Acunüng, Sawluh naw sangcime aktäa a jah khuimkha, im naküt üng lut hü lü jumeikia nghnumi kpamie jah man lü jah kaih hü lü, thawngim üng a jah khyum. ");
INSERT INTO dao_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Acunüng, pyeng hükia jumkie naw hne naküt üng cit u lü ngthu pyen hükie. ");
INSERT INTO dao_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip cun Samarih hnea mlüh ktunga ju citki naw, Mesijaha mawng khyange veia a ju pyen. ");
INSERT INTO dao_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Khyange naw, ngja u lü Philip naw a mdana müncam phyaki he ami jah hmu üng, a ngthu pyen cun aktäa ami ngaih. ");
INSERT INTO dao_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Isetiakyaküng, khawksea jah venake ami k'um üngka naw khawyaie ngpyang u lü lut lawki he. A khaw kceke ja xokie pi ami daw law bea phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Acuna mlüh üngkae cun aktäa jekyaikie. ");
INSERT INTO dao_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sihmon ngming nakia khyang mat veki; ani naw, ajana acuna mlüh üng, sui pawh lü Samarih khyange jah cäicatsak khawikia kyaki. “Kei cun khyang sawxat am ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mlüha veki naküt khyang akdik akdäm naküt naw “Ani hin ‘Hlüngtaikia Johit’ tia ngthangkia Pamhnama Johit ni” ti lü a ngthu pyen cun mcek lü ngaikie. ");
INSERT INTO dao_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A sui bilaw am, aksoa cäicat kphyaki he a ja bilawh khawha phäha, a ngthu cun aktäa ami münnak. ");
INSERT INTO dao_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Acunsepi, Pamhnama pe thangkdaw ja Jesuh Khritawa ngming thangkdaw Philipa pyen ami jum ja, nghnumi kpami Baptican khan lawki he. ");
INSERT INTO dao_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sihmon naw pi jum law hnga lü Baptican a kham law päng ja Philipa hlawnga ve lü, müncamkse ja müncamnak a jah pawh cun hmu lü cäiki. ");
INSERT INTO dao_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Acunüng, Jerusalema vekia Ngsäe naw Samarih hnea khyange naw pi Pamhnama ngthu jumkie tia ami ksing law üng, ami veia Pita ja Johan ami jah tüih; ");
INSERT INTO dao_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","acu xawi ani ju pha üng, Ngmüimkhya Ngcim ami yahnak vaia ami jah ktaiyü pet. ");
INSERT INTO dao_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Am acun ham üng ta ua khana Ngmüimkhya Ngcim am pha law; Bawi Jesuha ngming am Baptican däk va khan hamkiea kyaki. ");
INSERT INTO dao_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Angsä xawi naw ami khana ani kut taih ni se, Ngmüimkhya Ngcim yaheikie. ");
INSERT INTO dao_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Acunüng, Ngsäea kut taiha phäha Ngmüimkhya Ngcim pha lawki ti cun Sihmon naw a hmuh. Acunüng ngui cun Pita ja Johana veia lawpüiki naw, ");
INSERT INTO dao_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Kei pi, khyange khana ka kut taih ngüse, Ngmüimkhya Ngcim ami yahnak thei vaia johit na pe nia” ti lü a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pamhnama bäkhäknak cun a ngui am khyäi khaia a büa phäha, Pita naw, “Na xünak ja na ngui mulaia cit ni se, ");
INSERT INTO dao_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","na mlung Pamhnama hmaia käh ngsungpyunkia kyase, hin üng käh na ngpüi hngaki, na ham pi am ve; ");
INSERT INTO dao_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","acunakyase, na mkhyekatnak ngjut lü Bawipa veia ktaiyüa, acunüng, na mlung üng na ngaihnak ni mhlät khai ni. ");
INSERT INTO dao_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","“Nang cun püi ng’eihnak am bebang lü mkhyekatnaka thawng kyuma na kyaki ti ksing veng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Acunüng, Sihmon naw, nani pyen ka khana am a pha lawnak vaia, nangni naw Bawipa veia na ktaiyü pe nia” ti lü Pita ja Johan a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Acunüng, ani xawi naw saksi ja Bawipa ngthu ami ksingsak käna, Jerusalem mlüha citbeki xawi. Ani ceh sawa Samarih ngnam khawhah üng Thangkdaw sangki xawi. ");
INSERT INTO dao_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bawipaa khankhawngsä mat naw Philipa veia, “Tho law lü Jerusalem üngkhyüh Kaza khawa cehnaka lam üng cita” a ti (Acuna lam cun tuh ta am sumei ti u.) ");
INSERT INTO dao_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Acunüng, tho law lü citki. Acua Ethiopia khawa Candace, Ethiopia upki nghnumia khawthem naküt msümcei lü nghnumi awmki cun Jerusalem khawa Pamhnam va hjawkhah khaia citki; ");
INSERT INTO dao_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","a nglat law be lama, a senghlea khana ngaw lü sahma Hesajah cauk üngka kheki. ");
INSERT INTO dao_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Acunüng, Ngmüimkhya naw Philipa veia, “Cana senghle veia cit lü a hlawnga va vea” a ti. ");
INSERT INTO dao_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Acunüng, Philip cun acuna ngvaia veia va cit lü sahma Hesajaha cauk khe se ngjaki naw, “Na khea asuilam na ksingki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ani naw, “U naw am a na mtheh cun ihawkba ka ksing thei khai ni?” a ti. Acunüng, a veia ngaw hnga khaia Philip cun a khü. ");
INSERT INTO dao_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Acunüng, Cangcim a khe cun: “Hnim vaia toa mäiha ani cun ami cehpüi; To a mu ami kteih üng käh khihkheh lü a vea mäiha, ani pi käh khihkheh lü veki; ");
INSERT INTO dao_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ani cun hnemnak a khamei üng, am cangkia lei ami mtai pet; u naw pi a mjükphyüi mawng am pyen khawh u, isetiakyaküng khawmdeka ania sak cun päihki” kyaki. ");
INSERT INTO dao_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Acunüng, ngvai naw Philipa veia, “Sahma naw hin hin ua mawng ni a pyen? Amäta mawng mä, khyang kcea mawng mä? Ni kthäh veng na mtheha” a ti. ");
INSERT INTO dao_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Philip naw, thangkdaw cun ahina Cangcim üngkhyüh tünei lü Jesuha mawng cun a mtheh. ");
INSERT INTO dao_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Acunüng, lam ani ceh k'um üng, tuia venak pha ni se; ngvai naw, “Tenga, hin üng tui ve ve, Baptican kham vaia i naw na kyawhki ni?” ti se, ");
INSERT INTO dao_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip naw, “Na mlungmthin avan am na jumei üng na kham theiki” ti se; ngvai naw, “Jesuh Khritaw, Pamhnama Cakpaa kyaki ti ka jumki” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Acunüng, angvai naw senghle ngdüihsak lü, Philipa dä ngvai cun tui da citki xawi. Acun üng Philip naw Baptican a khamsak. ");
INSERT INTO dao_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Acunüng, tui üngka naw ani thaw law be ja, Bawipaa Ngmüimkhya naw Philip cun cehpüi. Angvai naw Philip am hmu ti kyaw lüpi jekyainak am amäta lama citbeki. ");
INSERT INTO dao_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Acunsepi, Philip cun Azuk mlüha ngdang law be lü; a ceh sawa acuna mlüh üngkhyüh Ketarih am a pha hama küt üng, mlüh naküt üng thangkdaw sang hüki. ");
INSERT INTO dao_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sawluh naw Bawipa hnukläk jah mkyüh lü jah hnim khaia ngbüki naw, ");
INSERT INTO dao_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Bawipa tuilam kläklamkie nghnumi kpamie naküt jah khit lü Jerusalema a jah lawpüi vaia, Damatet mlüha sinakoka veki am ca a ja pet vaia Jerusalema ktaiyü ngvaia veia kthäh khaia citki. ");
INSERT INTO dao_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Acukba cit lü Damatet mlüh pei a pha law üng, khankhawa ka akvai cun angxita a peia vai law sawxatki. ");
INSERT INTO dao_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Acunüng, Sawluh mdeka khana kyu lü, “Sawluh, Sawluh, i vai na na mkhuimkhaki ni?” tia kthai a ngjak. ");
INSERT INTO dao_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sawluh naw, “Bawipa, nang u ni?” a ti. “Na mkhuimkha Jesuha ka kyaki ni; tia kthai a ngjak. ");
INSERT INTO dao_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Acunsepi tho law lü mlüh da cita, acunüng na pawh vai ni mtheh khaie ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Acua a hlawnga cit hngakie naw kthai ngja u sepi, u am hmu u. ");
INSERT INTO dao_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawluh cun mdek üngka naw tho law be lü, hang mangki naw ipi am hmu thei se, a kut üng kaih u lü, Damatet mlüha ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mhnüp kthum khawdei am hmu lü i am eiaw lü veki. ");
INSERT INTO dao_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Acunüng, Damateta Anani ngming naki axüisaw mat veki. Pamhnam naw a ngmang üng, “Anani” a ti. Ani naw, “Bawipa aw, hia ve veng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bawipa naw a veia, “Tho law lü, lam ngdüng ami tia lama cita, Sawluh naki Tasuh mlüha ka Judaha ima va suia; acua ktaiyü lü veki ni; ");
INSERT INTO dao_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Anani ngming naki naw lut lü a mik a mdeisak be vaia, a khana a kut mtaih se, hmu päng veng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anani naw, “Bawipa aw, acun cun, Jerusalem mlüha na khyangea khana a jah mkhuimkhanak, khyang ngcim khawhah mpyawng üng ka ngjaki; ");
INSERT INTO dao_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","acunüng, hia pi na ngming pyenki naküt a jah mannak vaia ktaiyü ngvaiea veia ana yah pängki ni” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Acunsepi, Bawipa naw, “Cita, Khyangmjükcee, sangpuxange ja Isarel khyangmjükcee venaka ka ngming cehpüi khaia ka xü ni. ");
INSERT INTO dao_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","“Ka ngminga phäha mkhuimkhanak ihlawka khamei khai tia ka ksing lawsak khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Acunüng, Anani cun va cit lü Sawluha venak ima lutki; a khana a kut mtaih lü, “Ka na Sawluh aw, na mika hmuhnak be vai ja Ngmüimkhya Ngcim am na benak vaia, na law lama Bawipa na veia ngdangki Jesuh naw a na tüih law ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Acunja, a mik üngka naw ngalipa nglawh lawa mäiha nglo law lü, a mik mdei law beki; acunüng, tho law lü, Baptican khanki. ");
INSERT INTO dao_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Acunüng, a ei päng ja, aktha ve law beki. Acunüng, Damatet khawa veki axüisawea veia asäng veki. ");
INSERT INTO dao_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sinakoka cit täih lü, Jesuh cun Pamhnama Cakpa akyaka mawng sangki. ");
INSERT INTO dao_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","A ngthu pyen ngjaki naküt naw cäi u lü, “Hin hin, Jerusalem mlüha hina ngming pyenki naküt ja khuimkha khawikia am kya ai se? Acune cun jah khit lü ktaiyü ngvaiea veia a jah cehpüi vaia lawki ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Acunsepi, Sawluh cun a pyen johit am be law lü, Damateta vekia Judahea pyen naküta ngthu ja msang lü, Jesuh cun Khritaw kcanga akyaka mawng a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Acunüng, asäng nghjawk se, Sawluh hnim khaiea Judahe nghmu u lü cengkie. ");
INSERT INTO dao_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Acunsepi, Sawluh naw ami ceng a ksingei. Sawluh hnim khaiea bü u lü mkawte cun amhnüp mthana ami jah ngnäng. ");
INSERT INTO dao_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Acunsepi, axüisawe naw cehpüi u lü mthana vawh üng takie naw ngvawng üngkhyüh ami ju khyak. ");
INSERT INTO dao_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Acunüng, Sawluh naw Jerusalem mlüh a pha ja, axüisawe jah ngdawn hüpüi se, axüisawa kya hngaki ti am jum u lü ami van naw ami kyühei. ");
INSERT INTO dao_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Banabah naw ngkhahpüi lü axüisawea veia lawpüiki naw, lama Bawipa hmu se a ngthuheipüia mawng, Damatet khawa am kyühei lü Jesuha ngming am ngthu a pyena mawng cun a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Acukba Sawluh cun Jerusalem khawa ami veia cit hü lü Bawipa ngming am ling lü ngthu pyenki. ");
INSERT INTO dao_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Krik khyü pyenki Judahea veia ngthu pyen se, ngcupüikie naw, hnim khaie a ami bü. ");
INSERT INTO dao_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Acunüng, Jumeikie naw ami ksing law üng, Ketarih khawa cehpüi u lü Tasuh khawa ami tüihin u. ");
INSERT INTO dao_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Sangcime cun Judah, Kalile ja Samariha dim’yenak am vekie; acunüng, Ngmüimkhya Ngcim naw ngjuk ktha jah pe lü khyang nung law u lü Bawipa cun aktäa kyühkie. ");
INSERT INTO dao_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita cun hnün naküt üng cit hü lü Ludah mlüha veki Mhnama khyangea venaka ju citki. ");
INSERT INTO dao_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Acua khyang mat, Eni ngming naki, xo lü kum khyet a ihnak üng ngjänki a hmu. ");
INSERT INTO dao_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita naw, “Eni, Jesuh Khritaw naw ning mdaw be ve; tho law lü na ngjännak pyanga” ti se, acun üng, angxita tho lawki. ");
INSERT INTO dao_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ludah mlüh ja Saron mlüha vekie naküt naw, Eni hmu u lü, Bawipa veia nghlatkie. ");
INSERT INTO dao_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jukpei mlüh k'uma Tabitah ngmingnakia nghnumi mat veki. A Krik ngming cun Dorka naki, ‘Sa khyuk’ tinaka kyaki. Acuna nghnumi cun jumei lü, akdaw bilo lü, aktäa petmsawkia nghnumia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Acunüng, ani cun am mya lü thi se, a yawk cun mthi u lü ima khana ami mphän. ");
INSERT INTO dao_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Acunüng, Ludah mlüh cun Jukpei mlüh khyüh am thuk, axüisawe naw Pita acua veki tia ami ksing üng, “Käh sü lü, kami veia law kawpi” tia nghui na khaia, khyang nghngih ami jah tüih. ");
INSERT INTO dao_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Acunüng, Pita cun tho law lü, ami veia cit haki. A pha ja khan ima ami cehpüi; hmeinu naküt cun a peia ngdüi u lü, Dorka naw ami veia a ve ham üng a jah pyana kcue ja jihe jah büktengsak u lü kyapkie. ");
INSERT INTO dao_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Acunsepi, Pita naw ami van kpunga ja lu lawsak lü a mkhuk süm lü ktaiyüki; yawk da nglat lü “Tabitah, tho law” a ti. Acunüng, mdei law lü, Pita a hmu ja tho law lü ngawki. ");
INSERT INTO dao_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Acunüng, Pita naw a kut säng lü mthoki naw, jumeikie ja hmeinue jah khü lü, akxünga a jah mhnuh. ");
INSERT INTO dao_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Acun cun Jukpei mlüh üngkae ami van naw ngja u lü khyang khawha naw Bawipa jumkie. ");
INSERT INTO dao_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita cun Jukpei mlüha mhnüp khawvei savun pyangki Sihmona ima veki. ");
INSERT INTO dao_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Acunüng, Ketarih khawa Konelih ngming naki Romah cetca keptin veki, acun cun Itali yekap ngvai ami ti. ");
INSERT INTO dao_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ani cun Pamhnam üng hlimtui lü, a ima vekie ami van naw Pamhnam kyühkie, mpyenkseki Judah khyange jah petmsawt lü aktäa ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Acuna, mhnüp mülam naji kthum bang üng, Pamhnama khankhawngsä mat law lü, “Konelih aw” ti lü ngkhü lawki cun angsing hmumkthehnak a hmuh. ");
INSERT INTO dao_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Acunüng, Konelih naw a kyühnak am bükteng lü, “Bawipa aw, ini?” a ti. Acunüng, ani naw, “Na ktaiyünak ja na petmsawte naw Pamhnam jesak se, Pamhnam naw na ktaiyünak ning msang khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","“Tuhkbäih Jukpei mlüha khyang ja tüih lü khyang mat Sihmon Pita ngming naki jah khüsaka; ");
INSERT INTO dao_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","savun pyangkia Sihmona veia kaiki ni, a im cun mliktui peia veki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Acunüng, ngthuheipüikia khankhawngsä a ceh be ja, Konelih naw a mpya üngka nghngih ja, anglätse khüikie üngka Pamhnam üpnaki yekap mat khü lü; ");
INSERT INTO dao_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ngthu a jah mtheh päng üng Jukpei mlüha a jah tüih. ");
INSERT INTO dao_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Angawi üng, ami ceh lam mlüh pei ami pha law hlü üng, Pita cun ktaiyü khaia im mkhyuma kaiki. ");
INSERT INTO dao_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A ei naw mcawi law se, bu ei law hlüki; cunsepi, a ei vai ami pawh k'um üng Mhnama mdannak a hmuh. ");
INSERT INTO dao_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Khankhaw nghmawng law lü jihnua mäiha kphyüa kitmaki mdeka kya lawse a hmuh. ");
INSERT INTO dao_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Acuna k'uma, khawmdek üng ngvak hükiea khisa avan ja khankhawa khae naküt vekie. ");
INSERT INTO dao_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","A veia kthai pha lawki cun, “Pita aw, tho law; ja hnim lü jah eia” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Acunsepi, Pita naw, “Bawipa aw, acukba am kya; am ngcimcaiki ja mtüikheh i am ei khawi veng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Acunüng, Khana kthai naw anghnginaka, “Pamhnam naw a ngcimsak päng nang naw am ngcimcaiki käh tia” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Acukba cia kthum vei ngdang law lü; acunüng acuna jiha mäih cun khankhawa a ju jäh law be. ");
INSERT INTO dao_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita naw mdannak a hmuh cun asuilam am ksing lü ana ve k'um üng, Koneliha a tüiha khyange naw Sihmona a im ngthäh law u lü mkawt peia ngdüi lawki he. ");
INSERT INTO dao_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Sihmon Pita ngmingnaki khin cun, acua a pha ja am a pha ngpyang u lü ami ju kthäh. ");
INSERT INTO dao_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Acunüng, Pita naw mdannak a hmu cun, a ngaikyu hui üng, Ngmüimkhya Ngcim naw a veia, “Ngaia, khyang kthum naw ning sui hü ve u. ");
INSERT INTO dao_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Acunakyase, tho law lü ju kyuma, käh cücawn lü jah läka; anini cun keia jah tüih law ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Acunüng, Pita cun, acunea veia kyum lü ami veia, “Nami sui hü hin kei ni; ia phäha nami lawki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Amimi naw, “Konelih, yekap ngvai, khyang kdaw, Pamhnam kyühki, Judah khyange naküt üng ngming dawnak yaki naw a ima nang ning khü lü na ngthu pyen ngai khaia, Pamhnama khankhawngsä mat naw a mtheha kyaki” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita naw, acuna khyange cun im k'uma ja luhpüi lü a jah khinnak. A ngawia Pita cun tho law lü ami veia cit se, Jukpei mlüha ka, jumeikie avange pi a veia cit hngakie. ");
INSERT INTO dao_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Angawi be kce üng, Ketarih mlüha phakie. Acuia, Konelih naw a khyange ja a püie ja khü lü, anini cun ami jah na k'äih. ");
INSERT INTO dao_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita a pha law üng, Konelih naw ana dokham lü a khaw kunga mbawki. ");
INSERT INTO dao_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Acunsepi, Pita naw ani cun mtho lü, “Ngdüia, kei pi nghngicima ni ka kya ve” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A veia a ngthuhei maha va lut lü khyang khawha ana ve se a hmu. ");
INSERT INTO dao_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ami veia, “Judah khyang naw khyangmjükce ngkhawtpüi lü ami veia a ceh hü vai käh nglawiki tia nami ksingki; acunsepi, ‘U pi am ngcim, phyawksak ve’ käh ka ti vaia, Pamhnam naw na mtheh pängki ni. ");
INSERT INTO dao_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Acunakyase, na na khü law ja, käh dam lü ka lawkia kyaki. Acunakyase ka ning jah kthäh khai, “Ia phäha nami na khü lawki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konelih naw, “Ahin kcün mhnüp kthum anghjawk üng, ka ima naji kthum üng ka ktaiyü k'um üng; khyang mat suisak bawk suisa lü, ka maa ngdüi lawki naw, ");
INSERT INTO dao_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Konelih aw, na ktaiyünak Pamhnam naw ngja ve, na petmsawt ja na bilawh naküt pi Pamhnam naw ksing ve. ");
INSERT INTO dao_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Acunakyase, Jukpei mlüha khyang tüi lü Sihmon, Pita ami ti cun, na veia khüa; ani cun mliktui pei, savun pyangki Sihmona ima kaiki ni’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Acunakyase, na veia khyang angxita ka tüih lawa kyaki; na law hin daw ve. Acunakyase, Bawipa naw ngthu aning mtheh naküt ngai khaia, atuh Pamhnama hmuha kami van hin üng kami veki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita naw pyen lü, “Pamhnam naw, khyang naküt atänga jah mceiki tia akcanga ka ksingki; ");
INSERT INTO dao_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","acunsepi, au pi amät hjawkhah lü akdaw pawhkia khyang mjü naküt cun mkhawihnga lü jah dokhamki. ");
INSERT INTO dao_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","“Ani naw, acuna ngthu cun nami ksingki, acun hin Jesuh Khritaw üngkhyüh dim’yenaka thangkdaw Isarel veia a peta kyaki. ‘Jesuh cun khyang naküta Bawia kyaki’ tia nami ksingki. ");
INSERT INTO dao_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Johan naw Baptican khamnaka mawng ngthu a pyen käna, Kalile üngkhyüh cutei lü Isarel khaw naküt üng ngthu ngthang hükia münkse bilawhnake cun nangmi naw pi nami ksingki; ");
INSERT INTO dao_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nazaret Jesuha mawng ta ania khana Pamhnam naw Ngmüimkhya Ngcim ja johit am a besak; ani cun Pamhnama veia vekia kyase, khyanga khana akdaw pawh lü khawyaia jah khuimkhae naküt jah mdaw be lü cit hüki. ");
INSERT INTO dao_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Judahea khaw ja Jerusalem mlüh a jah bilawh naküt kami saksinaki; ani cun kutlamktung üng taih u lü, ami hnim. ");
INSERT INTO dao_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pamhnam naw amhnüp thum üng mtho be lü a ngdangsak, ");
INSERT INTO dao_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","acunsepi, khyang naküta veia am kya lü, keimie kami saksi khaia Pamhnam naw a jah xü, thihnak üngkhyüh a thawh be käna amät am atänga eiaw yüm khaia a jah mtheh ni. ");
INSERT INTO dao_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Acuna Bawipa cun akthie ja akxüng hea khana ngthumkhyah khaia Pamhnam naw a mcawna kyaki tia, khyangea veia sang hü khaiea, jah ksing hüsak khaiea, Pamhnam naw ngthu a jah pet. ");
INSERT INTO dao_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A u pi, ani jumeiki naküt, a ngminga phäha a mkhyekatnak mhlätnak yah khai tia, ania mawng cun sahmae naküt naw ami sang khawi ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita naw acuna ngthu a pyen hui üng, ngthu ngjakie naküta khana, Ngmüimkhya Ngcim pha lawki. ");
INSERT INTO dao_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pitaa veia law hngakie Judah jumeiki khyange naw, khyangmjükceea khana pi Pamhnam naw Ngmüimkhya Ngcim a pha lawsak hmu u lü cäikie. ");
INSERT INTO dao_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Käh ksinga ngthu am ngthuhei u lü Pamhnam mhlünmtai u se, ami jah ksinga phäha kyaki. Acunüng, Pita naw jah msang lü, ");
INSERT INTO dao_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Hine, mimi mäiha Ngmüimkhya Ngcim yah hngakie cun tui üng Baptican am khan khaiea, u naw a jah khyawh ni?” ti lü, ");
INSERT INTO dao_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jesuh Khritawa ngming am Baptican khan khaiea a jah mtheh. Acun käna Pita cun ami veia asäng ve khaia ami nghuinak. ");
INSERT INTO dao_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Judah khawa vekiea Ngsäe ja jumeikie naw, khyangmjükcee naw pi Pamhnama ngthu ja hngakie tia ami ksing. ");
INSERT INTO dao_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Acunüng, Pita Jerusalema a ceh üng, vun mawi hlükie khyangmjükcee naw pi Pita cun kcäh u lü, ");
INSERT INTO dao_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ami vun am mawikiea ima lut lü ami veia na ei haki” ti u lü ami ngcuhpüi. ");
INSERT INTO dao_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Acunsepi, Pita naw aphung üng tünei lü ja mthehki naw, ");
INSERT INTO dao_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Jukpei mlüha ktaiyü lü ka veki; acunüng, jinua mäih üng khankhawa ka naw kya law se ka hmu; ka pei yea na k’et lawki; ");
INSERT INTO dao_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","acun bükteng lü ka ngaikyu hui üng, khisae naküt khawmdek üng ngvak hükie ja khana khae ka jah hmuh. ");
INSERT INTO dao_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Acunüng, kthai naw, ‘Pita, tho law, jah hnim lü ja eia’ ti se, ka ngjak. ");
INSERT INTO dao_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Acunsepi, kei naw, ‘Bawipa aw, acukba am kya, am ngcimcaiki ja mtüikheh ka mka üng am ju lut khawi naw’ ka ti. ");
INSERT INTO dao_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Acunsepi, khankhawa ka kthai naw, ‘Pamhnam naw a ngcimcaihsak haw cen, nang naw am ngcimki käh tia’ ti lü a na msang. ");
INSERT INTO dao_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Acukba kthum vei a ve law päng üng, avan khankhawa a jähei be. ");
INSERT INTO dao_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Acunüng, khyang kthum, Ketarih mlüha kae cun ka veia jah tüi law u se, ka venaka ima pha lawki he. ");
INSERT INTO dao_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ngmüimkhya naw käh cücawn lü ka ja läk khaia a na tüih. Hina jumeiki khyuke naw pi na läk law hnga u se, Koneliha ima kami lutkie; ");
INSERT INTO dao_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ani naw, a ima khankhaw ngsä ngdüi se a hmuh ja, khankhaw ngsä naw a veia, ‘Jukpei mlüha khyang tüi lü, Sihmon Pita ami ti jäng laksaka; ");
INSERT INTO dao_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ani naw ngthu ning mtheh se, acuna ngthu am nang ja na khui im kyawnglawng cun küikyana nami kya khai’ a tia mawng a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Acunüng, ngthu cutei lü ka pyen law ja, Ngmüimkhya Ngcim akcüka mi khana a pha lawa mäiha, amimia khana pi pha lawki. ");
INSERT INTO dao_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Acunüng Bawipa ngthu, ‘Johan naw tui am khyang Baptican jah peki, acunsepi nangmi cun Ngmüimkhya Ngcim üng Baptican nami khan khai’ a ti, ka süm law beki. ");
INSERT INTO dao_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pamhnam naw Bawipa Jesuh Khritaw mi jumei ja, amdanga a jah peta khawh cun khyangmjü kcee pi acuna khawh a jah pet hnga üng, kei cun ia kya lü acuna Pamhnam ka ma khai ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Acuna ngthu ami ngjak ja, jum u lü, “Acuna akyaküng, Pamhnam naw khyangmjükcee haw ngjut be u lü xünnak ami ya vaia mawng cun ja pe ha ve” ti u lü Pamhnam mküimtokie. ");
INSERT INTO dao_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephena phäha ami jah khuimkhae, Phonisia, Kuparuh ja Antiok mlüh cäpa dawng hü u lü Judah khyange dänga veia Pamhnama ngthu sang hükie. ");
INSERT INTO dao_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Acunsepi, avange cun Kuparuh mlüh ja Kuriniha kaea kyakie, acune naw Antiok mlüh ami pha üng, khyangmjükcee veia pi ngthu pyen u lü, Bawipa Jesuha thangkdaw ami sang. ");
INSERT INTO dao_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bawipa johit naw jah vepüi se; khyang khawhah naw jum u lü, Bawipa veia nghlat law päihkie. ");
INSERT INTO dao_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ami mawngma cun Jerusalema veki sangcim naw ngja u lü, Banabah cun Antiok mlüha ami tüih. ");
INSERT INTO dao_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabah a va pha üng, Pamhnama jah pet dawkyanak hmu lü aktäa jeki, ktha na kcang u lü Bawipa üng anglät se ami khäng vaia ami van a jah mcäi. ");
INSERT INTO dao_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabah cun khyang kdawa kya lü, Ngmüimkhya Ngcim ja jumeinak am bekia kyase, Bawipa veia khyang khawhah ngdawn lawki he. ");
INSERT INTO dao_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Acunüng, Banabah cun Sawluh sui khaia Tasuh mlüha citki. ");
INSERT INTO dao_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Va hmu lü Antiok mlüha a cehpüi. Kum mät bang Sangcim üng veki khyange am hmu hnga ni lü, khyang khawha ja mtheimthangki xawi. Acuna Antiok mlüha jumeikie cun “Khritjane” tia ami jah sui law kcüka kyaki. ");
INSERT INTO dao_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Acuna kcün üng, sahma avange cun Jerusalem üngka naw Antioka ju citkie. ");
INSERT INTO dao_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Amimi üngka mat, Akabas ngming naki ngdüi law lü khawmdek khan avan üng khawjaw law khai tia Ngmüimkhya Ngcim am a pyen; acuna khawjawnak cun Ketah sangpuxang Kalawdih naw a jah upa kcün üng pha lawki. ");
INSERT INTO dao_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Axüsawe naw ami khyaih khawha, Judah khawa vekiea jumeikie cun ja kpüikpak vaia ami mkhyah u. ");
INSERT INTO dao_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Acukba ami büa mäiha ami ja kpüikpaknak cun Banabah ja Sawluha kut üngka naw, sangcim ngvaiea veia ami jah kbi. ");
INSERT INTO dao_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Acun üng, sangpuxang Herod naw sangcime üngka avange jah mkhuimkha khaia büki. ");
INSERT INTO dao_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ani naw Johana be Jakop cun kcim am a hnim. ");
INSERT INTO dao_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Acun naw Judahe jah jesaki tia ksing lü Pita pi a va man. (Acuna mhnüp cun nghngen am bawikia muk pawhnaka mhnüpa kyaki). ");
INSERT INTO dao_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Acunüng Pita man lü thawngim üng ami khyum, yekap xaleikhyuk am a jah ngängsak; kphyawnpawi a päng üng khyangea veia a cehpüi vaia tängki. ");
INSERT INTO dao_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Acunakyase, Pita cun thawngim üng a tak ham; acunüngpi, sangcime naw Pita cun Pamhnama veia aktäa ami ktaiyü pet. ");
INSERT INTO dao_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod naw Pita cun khyange vei am lawpüi hama mthan üng, Pita cun yekap nghngih xawia ani keh üng, mthiyüi nghngih am khit u se ipki; K'äihkie naw pi mkawt peia ve u lü mtätkie. ");
INSERT INTO dao_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Acunüng, Bawipaa khankhawngsä mat ngdang law se, thawngim vai lawki. Acunüng, khankhawngsä naw Pita a kphyeng üng va ksün lü, “Akjanga tho lawa” a ti. Acunüng mthiyüie cun a kut üngka naw nghawk lawki he. ");
INSERT INTO dao_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Acunüng, khankhawngsä naw, “Na khapat vawh lü, na khawdawk ngcuma” a ti. Acunüng, Pita naw acukba a pawh. Acunüng, khankhawngsä naw, “Na suisake jih lü, na läk law” a ti. ");
INSERT INTO dao_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita naw kco law lü a läk; khankhawngsäa bilaw cun akcanga am sui lü a ngmanga a ngaih. ");
INSERT INTO dao_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ngäng kcükie ja anghninaka ngängkie a jah hei khe käna, khawk kpunga luhnak vaia mthiksawh va phaki. Acunüng ksawh amät nghmawng law se, lut law u lü lam mat üng ami va ceh üng, khankhawngsä naw Pita cun a cehtak. ");
INSERT INTO dao_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pita naw a ngsüm law ja, “Bawipa naw khankhawngsä tüi law lü, Heroda kut ja Judah khyangea äpeinak üngka naw, a na küikyan akcanga ka ksingki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Acunüng, ngaikyu khap lü, Makuh ngming naki, Johana nu Mariha ima va citki. Acua ktaiyü u lü khyang khawha a na ngkhämkie. ");
INSERT INTO dao_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita naw ksawh a khawk ja Rode ngming naki mpya naw ngai khaia va citki. ");
INSERT INTO dao_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pitaa kthai a ngjak üng jekyai ngen lü, ksawh pi käh mhmawng lü im k'uma va dawng beki naw, Pita ksawh peia ngdüiki tia a jah va mtheh. ");
INSERT INTO dao_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Acunsepi, amimi naw, “Ng’yaw veki” ami na ti. Acunüng, ani naw, “Pita kcang ni” ti lü a pyen. Amimi naw, “Pitaa khankhawngsä va ni vü” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Acunsepi, Pita naw, khawk law laihlaih se, ami hmawn üng ta Pita hmu u lü aktäa cäi lawki he. ");
INSERT INTO dao_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Acunüng, Pita naw, käh ami khihkheh vaia a kut üng ja kha lü, Bawipa naw thawngim üngka naw a mhlät bea mawng cun a jah mtheh. Acunüng, “Hina ngthu hin, Jakuk ja jumeikie üng jah va mtheh ua” a ti. Acunüng, va kco lü akcea citki. ");
INSERT INTO dao_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Khaw athaih law ja, yekape cun, “Pita hawa veki ni?” ti u lü aktäa ami lu cingki. ");
INSERT INTO dao_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod naw Pita a jah suisak, am hmu u. Ngängkie cun jah kthäh lü jah hnim vaia ngthu a jah pet. Acun käna Herod cun Judah khaw üngka naw Ketarih mlüha ju cit lü acua veki. ");
INSERT INTO dao_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Turah ja Sidon khaw khyangea khana aktäa a mlung thüi se veki; acunüng, anini naw bawi im ngängkia khyang, Balatuh cun püi nakie naw, atänga law u lü ngkhawt vaia ami nghuinak, isetiakyaküng, anini cun sangpuxanga khaw üngka eiawk vai ami yaha phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ami xünaka mhnüp üng Herod cun a bawijih jah suisa lü a bawingawhnak üng ngaw lü ami veia ngthu pyenki. ");
INSERT INTO dao_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Acunüng, khyang naküt naw, “Pamhnama kthai ni, nghngicima kthaia am kya naw” ti u lü ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ani naw Pamhnama am leisawngkia kyase, Bawipa khankhawngsä naw kpai se, mkyüt naw ei se thiki. ");
INSERT INTO dao_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Acunsepi, Pamhnama ngthu cun ngthang hü dämdämki. ");
INSERT INTO dao_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabah ja Sawluh naw khüibi ani bilaw päng üng, Jerusalem üngkhyüh naw nghlat be ni lü Johan, a ngming kce Makuh ngming naki cun ani hlawnga ani cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok mlüha sangcime üngka, sahmae ja sajae vekie; acune cun Banabah, Simeon (Khyang le), (Kurinih) khawa ka Lucia, (Herod jah upnakia dä däm lawkia) Manin ja Sawluha kyakie. ");
INSERT INTO dao_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Acunüng, Bawipaa khüibi bi u lü ami ei ami jeih k'um üng, Ngmüimkhya Ngcim naw, “Khutbi khai xawia ka jah mcawna Banabah ja Sawluh cun na jah phyäi hnga ua” a ti. ");
INSERT INTO dao_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ami ei jeih u lu ami ktaiyü law päng üng, ani khana ami kut mtaih u lü, ami ja tüih. ");
INSERT INTO dao_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ngmüimkhya Ngcim naw Banabahh ja Sawluh a jah tüihnak üng Selukih mlüha ju cit ni lü, acun üngka naw Kuparuh kawnga mlawng üng citki xawi. ");
INSERT INTO dao_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Acunüng, Salamih mlüha ani pha üng, Judahea sinakoka Pamhnama ngthu pyenki xawi; Johan ami tia Makuh pi jah kpüi khaia ani cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Acuna kyawn avan üng cit hü ni lü, Papos cäpa cit hüki xawi; acunüng Judah khyang mat sui khyaihki a ngming Bar Jesuh naw kei sahmaki tiki ani hmuh. ");
INSERT INTO dao_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Sekijah Pawluh cun Bar-Jesuh a nglawipüia kyaki. Sekijah Pawluh cun khyang kthema kya lü Papos kyawn upki kyaki. Ani naw Banabah ja Sawluh jah khü lü, Pamhnama ngthu ngai hlüki. ");
INSERT INTO dao_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Acunsepi, sui khyaihki Eluma (Krik ngminga kyaki) naw jah upki cun am jumei khaia, angsä xawi a jah mah. ");
INSERT INTO dao_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sawluh naki Pawluh ami ti naw, Ngmüimkhya Ngcim am be lü, acuna Bar Jesuh cun büktengki naw, ");
INSERT INTO dao_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nang khawyaia ca ni, nang cun dawkyanaka ye ni, kpyüpyehnak naküt am na beki, Bawipaa ngthukcange hleihlaka nghlatsak khai na ktha naki! ");
INSERT INTO dao_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","“Tukbäih Bawipa kut na khana pha lawki tia ksinga, khawkdei käh na hmu khaia na mik mü khai” a ti. Acun ja Eluma cun nghmüp naw jin se, a kut kha hü lü kaih khai suiki. ");
INSERT INTO dao_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Acunüng, kyawn upki naw acun hmuh lü, Bawipa mawng mtheimthangnak cun müna lü aktäa kyühei lü jumeiki. ");
INSERT INTO dao_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pawluh cun a ngkhahpüi xawi am, Papos üngka naw mlawng am cit u lü Pampulih hne Parkah mlüha pha u se, acunüng, Johan naki Makuh naw jah cehta lü, Jerusalem da nglat beki. ");
INSERT INTO dao_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Acunsepi, anini cun Parkah mlüh üngka naw cit laihlaih ni lü, Pisidih hne Antiok mlüh pha ni lü, acunüng, sabbath mhnüp üng sinakoka lut ni lü ngawki xawi. ");
INSERT INTO dao_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mosia Thume ja sahmaea cae ami khe law Päng üng, sinakok ngvaie naw, ani veia khyang tüih u lü, “Bena xawi aw, khyang nani jah mcäinak vaia ngthu a ve üng pyen nia” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pawluh ngdüi law lü a kut säng lü, “Pamhnam kyühkia Isarele ja khyangmjükcee aw, ngai ua. ");
INSERT INTO dao_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Hina Isarel khyangmjüe Pamhnam naw, mi pupae jah xü lü, khina kba Egypt pea ami ve üng khyangmjü kdäma a pawh. Pamhnam naw a themnak am Egypt pe üngkhyüh a jah lawpüi be. ");
INSERT INTO dao_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kum kphyükip khawkhyawng khawa a jah mcei. ");
INSERT INTO dao_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanan pea khyangmjü khyüh ja näng lü acun käna acuna pe cun Isarele am a jah kanaksak. ");
INSERT INTO dao_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Acun käna, sahma Samuilah am a ve law ham üng, kum phyakphyü ja mhmakip ngthumkhyahkie am a jah na pet law. ");
INSERT INTO dao_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Acun käna sangpuxang mso u se, Benjamina mjü üngka Kisah a cakpa Sawluh ngming naki, khawkum kphyükip ami sangpuxang vaia Pamhnam naw a jah pet. ");
INSERT INTO dao_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Acun käna ani ksät lü Isarelea sangpuxang vaia Davit a mcawn be; Pamhnam naw cuna mawng cun ngsingsak lü, ‘Jisea cakpa, Davit, ka mlunga mäi mlung naki hmu veng, ani naw ka ngjakhlü naküt bi khai’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Pamhnam naw khyütam a jah peta mäiha, Isarele jah küikyan khai Davita mjü üngka Jesuh a jah pet, ");
INSERT INTO dao_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesuh naw khutbi, am a tünei law ham üng, Johan naw ami mkhyekatnak nglata u lü baptican ami khan vaia Isarel khyangea veia ngthu a pyen. ");
INSERT INTO dao_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Johana khut binak a päih law hlü üng, Johan naw, ‘U a nami na ngaiki ni? Kei nami ngäng ua am kya nawng. Acunsepi, ngai u, ka hnua law khai khyang ta, kei naw ania khawdawk suh pet khaia pi am nglawi veng’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Abrahama mjü üngka ka püi Isarel khyange ja, hin üng Pamhnam hjawkhah khyangmjükcee aw, hina küikyannaka ngthu cun mi veia a jah kbi lawa kyaki. ");
INSERT INTO dao_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem mlüha vekie ja ami ngvaie naw, Jesuh cun küikyanaka Bawia, am ami ksinga phäha ja sahmaea ngthu sabbath mhnüp naküt üng ami kheh cun am ami ksinga phäha, acuna ngthue cun Jesuh ami mkat üng kümbesakie. ");
INSERT INTO dao_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","A thihnak vai i am hmu u lüpi, Pilata veia hnim vaia msokie. ");
INSERT INTO dao_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Acunüng, a mawng sahmae naküt naw ami yuk, ami kümsak käna, kutlamktung üngka naw khya u lü lungdüa ami k’ut. ");
INSERT INTO dao_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Acunsepi, Pamhnam naw thihnak üngka naw a mthawh be. ");
INSERT INTO dao_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Acun käna Kalile üngka naw, Jerusalema a jah cehpüi khyangea veia khaw mhnüp khawvei ngdang be se, acune cun atuh Isarel khyangea veia saksikiea kyakie. ");
INSERT INTO dao_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Keini naw pi, mi pupaea veia khyütam, thangkdaw ka ning jah mtheh lawki ni, acukba Pamhnam naw Jesuh a mthawh benak am, hina khyütam mi cae üng kümsakki, Salan anghnginak üng pi, ‘Nang ka ning cakpaa na kyaki; tungawi na paa ka kyaki’ tia ng’yuki. ");
INSERT INTO dao_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ng’uh hnüna thukyawnaka käh cit khaia Pamhnam naw ani cun thihnak üngka naw a mthawh be vaia ngthu cun hikba a pyen, ‘Davita veia ngcimcaih lü ngsingkia dawkyanak cän nang üng ka ning pet khai’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Acunakyase, Salan kce üng pi, ‘Sitihki na mpya a thukyaw vai am tängki’ a ti sih. ");
INSERT INTO dao_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davit pi, a xün k'um üng Pamhnama ngjakhlü bi a bi käna, thi se, a pupaea hlawnga k’ut u se, lungdüa kyaw pängki ni. ");
INSERT INTO dao_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Acunsepi, Pamhnam naw thihnak üngkhyüh amthawh be cun acukba am kya. ");
INSERT INTO dao_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Acunakyase, ka püi Isarele aw, acuna Bawi Jesuh üng mkhyekat mhlätnaka ngthu kami pyen law hin nami ksing vai hlüei veng. Mosi naw am a ning jah mhlät khawh mkhye üngkhyüh ani jumeiki avan cun jah mhlät khawhki. ");
INSERT INTO dao_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Au pi ani jumeiki naküt cun Mosia thum naw, am a mhlät thei pi mhlät khai. ");
INSERT INTO dao_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Acunakyase, sahmae naw ami pyen cän nami khana käh apha law vaia mcei ua. ");
INSERT INTO dao_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Acun cun, ‘Hleihlakkie aw, bükteng ua, cäicing u lü thi ua; bi mat ka kpäng, acun cun khyang naw ning jah mtheh u sepi, nami xüna küt üng am jum uki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pawluh ja Banabah cun Sinakok üngka naw ani lu law be üng, khyange naw, acuna ngthu cun sabbath bekce üng pi ani pyen be vaia ami jah nghuinak. ");
INSERT INTO dao_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ngkhämkie ami ngpyen be ja, Judahea ja Judah thuma ngpyawtkie khyangmjükcee naw Pawluh ja Banabah jah läk u se, Pamhnama bäkhäknak üng ami ve nglät vaia jah mcäiki xawi. ");
INSERT INTO dao_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Acunüng, sabbath betü üng, Bawipaa ngthu ngai khaiea, mlüh üngka avan lawki he. ");
INSERT INTO dao_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Acunsepi, Judahe naw khyange ami jah hmuh üng, aktäa jah cawkei u lü, Pawluha a ngthu pyen cun ngcuhpüi u lü ami ksenak. ");
INSERT INTO dao_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Acunüng, Pawluh ja Banabah naw ling ni lü, “Pamhnama ngthu nangmia veia pyen ma vaia kya kungki; acunsepi, mah u lü anglät xünnak am nami yah vaia nami pawha kya se, Pamhnama a jah ah mcäia mäiha khyangmjükceea veia ning jah nghlatak ve ning. ");
INSERT INTO dao_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Acukba Bawipa naw ngthu a na pet cun, ‘Khawmdeka khütnak cäpa küikyanak na bi khaia, khyangmjükceea phäha akvaia ka ning mcawnki’ tia, kyaki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Acunüng, khyangmjükcee naw acuna ngthu ami ngjak üng je u lü Bawipaa ngthu mhlünmtaikie; acunüng, angläta xüng khaia a xü naküt naw jumkie. ");
INSERT INTO dao_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Bawipa ngthu cun acuna khaw avan üng ngthang päihki. ");
INSERT INTO dao_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Acunsepi, Judahe naw mlüh ngvaie ja Pamhnam hjawkhahki khyangmjükcee üngka nghnumie ami jah ksük. Ami naw Pawluh ja Banabah jah khuimkhasak u lü acuna khaw üngka naw ami jah ksät. ");
INSERT INTO dao_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Acunüng, ngsä xawi naw ani khawpha üngka mput cun khawk hüt ni lü Ikonih khawa citki xawi. ");
INSERT INTO dao_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antioka vekia jumeikie cun jekyainak ja Ngmüimkhya Ngcim am bekie. ");
INSERT INTO dao_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniha pi acukba thawnki, Pawluh ja Banabah cun Ikonih khaw sinakoka lut ni lü ngthu pyen ni se, Judahe ja khyangmjükce khawha naw jumei lawki he. ");
INSERT INTO dao_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Acunsepi, am jumei hlükiea Judahe naw khyangmjükcee jah ksük u lü, ami cun ami jah hnengsak. ");
INSERT INTO dao_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Acunakyase, Bawipa üng lingnak am ngthu pyen ni lü, acua khawvei ve ni se, Bawipa naw müncamnak ja cäi phyaki he cun ani kut am jah pawhsak lü, a bänaka ngthu a jah ksingsak. ");
INSERT INTO dao_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Acunsepi, acuna khaw üngkae cun ngpai u lü, avang cun Judahea phäh, avang naw angsä xawia phäh kyaki. ");
INSERT INTO dao_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Acunüng, khyangmjükcee, Judahe ja ami ngvaie naw angsä xawi cun ani hmai se khaia jah pawh u lü, lung am ami jah vawi vaia ami bü law üng, ");
INSERT INTO dao_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","acun ksingei law ni lü, Luhkonih mlüh üng Luhtarah ja Derbe ngnam ja a peia ngnamea dawngki xawi. ");
INSERT INTO dao_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Acua thangkdaw cun sang hü laihlaihki xawi. ");
INSERT INTO dao_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Luhtarah khawa a hmi law üng tün lü a khaw xokia khyang, am cit hü theiki mat veki. ");
INSERT INTO dao_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Acuna khyang naw Pawluha a ngthu pyen ngai se, acunüng, Pawluh naw ani cun bükteng kyet lü a dawnak be vaia jumnak taki ti ksingki naw, ");
INSERT INTO dao_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","angsanga, “Na khaw am angsunga ngdüi lawa” ti se, ani cun ngtawp law lü, cit lawki. ");
INSERT INTO dao_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Khyange naw Pawluha a bilaw hmu u lü, Luhkonih khyü üng, angsanga ngpyang lü, “Mhname cun nghngicima mäiha mi veia kyum law ve u!” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabah cun, “Zutah” tia sui u lü, Pawluh cun ngthu pyenki kyase, “Harmes” tia ami sui. ");
INSERT INTO dao_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Acuna khaw peia vekia Zutah mhnama ktaiyü naw mlüh kpung üngkhyüh se ja paipaie cun luhnaka mkawt peia jah lawpüi lü khyange am ngsä xawia phäh ngkengtainak vaia pawh khaiea ngtängkie. ");
INSERT INTO dao_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Acunsepi, Banabah ja Pawluh naw, acun ani ksing law ja, ani suisak ja ktek ni lü, khyangea ksunga dawng ni lü ngpyangki xawi naw, ");
INSERT INTO dao_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Khyange aw, hin hin ivai nami pawhki ni? Keini pi nangmia mäiha nghngicima kani kyaki ni; nangmi naw amdange jah hawih u lü, mce ja khankhaw, tui acunüng veki naküt jah mhnün lü, anglät se xüngkia Pamhnama veia nami nghlat lawnak vaia thangkdaw kani ning jah mtheh lawki ni. ");
INSERT INTO dao_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Acuna Pamhnam naw ajana khyang naküt amimäta lam üng cit khaiea a jah tüih, ");
INSERT INTO dao_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","acunsepi, nami khana abänak am eiawk phübe u lü nami jekyai vaia, khankhawa ka naw khaw ak lawsak lü kthiktheih yawpaia dawnak khawkum a ning jah pet ni. Acuna Pamhnam veki tia ngsingsaki” tia ani pyen. ");
INSERT INTO dao_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Acukba pyen lü ami ngkengtainak vaia ami hnim hlü cun ngyan üng ani jah pyaisak. ");
INSERT INTO dao_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Acunsepi, Antiok mlüh, pisidih hne ja Ikonih mlüh üngka Judahe avang acua law hngakie naw, khyange jah ksük u se; acuna Pawluh cun lung üng ami khawng, thikia sui u lü mlüh kpunga jäk u lü ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Acunsepi, jumeikie naw ami kcung law ja, Pawluh cun tho law lü mlüh k'uma cit beki. A ngawi üng, ani cun Banabah am Derbe khawa citki. ");
INSERT INTO dao_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Acuna hne üng thangkdaw pyen ni lü, axüisawe khawha ani jah yah käna, Luhtarah, Ikonih ja, Pisidih hne, Antiok mlüha nghlat be ni lü, ");
INSERT INTO dao_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","“Khuikhatnak khawhah khamei lü, Pamhnama pe mi lut khaia kya kungki” tia, jumeikiea mlung ja khängsak ni lü, jumeinak üng ami khängcek vaia ani ja mcäi. ");
INSERT INTO dao_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sangcim naküt üng ngvaie jah mcawn pet ni lü, ei jeih u lü ami ktaiyü law päng üng Bawipa ami ümnak vaia ami jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidih hne avan üng cit hü ni lü, Pampulih hnea phaki xawi. ");
INSERT INTO dao_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Parkah khawa ngthu ani sang päng üng, Ataliha citki xawi. ");
INSERT INTO dao_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Acunüngka naw mlawng am cit ni lü, Antiok pha law beki xawi, acun cun ani bilawh binak üng Pamhnama mpyeneinak ani yah vaia jah ap ni lü ami jah tüihnaka khawa kyaki. ");
INSERT INTO dao_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiok ani pha ja sangcime jah ngkhämsak ni lü Pamhnam naw jah summangei lü khut ani bi naküte ja, khyangmjükcee phäha pi jumnaka ksawh a mhmawnga mawng cun ani jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Acunüng, jumeikiea veia khawvei veki xawi. ");
INSERT INTO dao_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Khyang avange cun Judah khaw üngka naw Antioka law u lü, “Mosia thuma mäiha nami vun am nami mawih üng küikyannak am nami yah khai” tia, jumeikie ami jah mthei. ");
INSERT INTO dao_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Acune am Pawluh ja Banabah cun aktäa ngcuh u se, Pawluh ja Banabah cun angsä avange am, acuna ngthua phäha, Jerusalema vekiea Ngsäe ja sangcim ngvaiea veia hang cit khaiea ami mkhyäp. ");
INSERT INTO dao_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Sangcime naw jah tha u se, ani naw khyangmjükcee ami nghlat law bea mawng cun Phonisia ja Samarih avan üng cit hü ni lü ani pyena kyase, jumeikie naküt ani jah jesak. ");
INSERT INTO dao_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem ani jäng pha üng, sangcime, Ngsäe ja, sangcim ngvaie naw jah na je na u se, Pamhnam naw a jah summangei naküt ani jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Acunsepi, Pharisee üngka, jumeiki avange tho law u lü, “Khyangmjükcee naw ami vun ami mawi vaia kyaki, Mosia thum pi ami läk vaia jah mtheh vai” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ngsäe ja sangcim ngvaie cun, acuna ngthu ngai khaiea ngcunkie. ");
INSERT INTO dao_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ami ngcuh käna Pita naw ngdüi law lü, “Benae aw, khyangmjükcee naw, keia üngkhyüha thangkdaw ngja u lü, jumei khaiea ajana Pamhnam naw nangmi üngkhyüh ana mcawn tia nami ksingki. ");
INSERT INTO dao_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Acunüng, mlung ksingkia Pamhnam naw mimi a jah peta mäiha, Ngmüimkhya Ngcim cun khyangmjükceea veia pi jah peki. ");
INSERT INTO dao_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Mimi ja amimi, mi hngalangnak am ve, jumeikiea kyase ami mkhyekatnak jah mhlätki. ");
INSERT INTO dao_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Acunakyase, mimi ja mi pupae naw pi am ami kpüieia phüi cun ivaia jumeikie am jah phüi hlüsak u lü, Pamhnam nami mhnüteiki ni? ");
INSERT INTO dao_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mimi cun pi amimia mäiha mi jum u lü, Bawi Jesuha bäkhäknak am küikyannak mi yahki” tia a pyen. ");
INSERT INTO dao_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Khyange cun Banabah ja Pawluh naw, Pamhnam naw jah summangei se, khyangmjükceea veia müncamnak ja cäicatnake ani bilawha mawng, ani jah mtheh üng käh khikhe u lü, ngaikie. ");
INSERT INTO dao_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cunüng ani pyen law päng ja Jakuk naw pi pyen hnga lü, “Benae aw, ka pyen na ngai ua, ");
INSERT INTO dao_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pamhnam naw akcüka khyangmjükcee üngka, avange a phäha jah xü lü amimi jah bükteng khaia a lawa mawng cun, Sihmon naw ana pyen pänga kyaki. ");
INSERT INTO dao_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Acuna ngthu cun sahmaea ngthu am tängki. ");
INSERT INTO dao_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Cangcim üng: ‘Acun käna nghlat be lü, Davita khaw ka pyang be khai, apyehnak naküt pi ka mdüi be khai; ");
INSERT INTO dao_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Khyang akcee ja khyangmjükcee, ka ngming am ka jah khüe naküt pi ka veia law khaie. ");
INSERT INTO dao_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Khawmdeka ngtüi üng tün lü, hina ngthu jah mthehkia Bawipa naw ti ve’ tia pyenki. ");
INSERT INTO dao_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Acunakyase, khyangmjükcee üng, Pamhnama veia nghlat lawki he cun käh jah khuimkha u lü, ");
INSERT INTO dao_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","juktuh üng pet, käh ngcimki eiawk, hüipawmnak, khisa käh sawi u lü hnim ja thi käh ami ei vaia, ami veia ca jah kbi üng daw khai tia ngai veng. ");
INSERT INTO dao_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mosia thum cun sinakoka sabbath naküt üng khe khawia kya lü, mlüh naküt üng acuna ngthu cun sang päng kyaki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ngsäe, angvaie ja sangcime naküt naw, mimi üngka khyang xü u lü, Pawluh ja Banabaha veia Antioka tüih üng daw khai ami ti; ami jah xüe cun ami jah leisawnga kyaki. Ami ngming cun, Judah ami ti Barsaba ja, Tilah a kyaki. Acun xawi cun jumeikie üng angvai xawia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Hikba ani xawi üng ca ami ja kbi cun, “Ngsäe ja benae üng sangcim ngvaie naw, Antiok, Siria khaw ja, Kilikih khawa vekiea khyangmjükcee, ning jah hnukset ve u. ");
INSERT INTO dao_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Khyang avange naw, keimi naw am kami jah mtheha, keimi üngka naw law u lü, ‘Nangmi, nami vun nami mawi vai, thum nami läk vai’ tia, nami mlung ning jah bawngbaisakie tia ngja u lü, ");
INSERT INTO dao_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","mi Bawi Jesuha ngminga phäha Banabah ja Pawluh cun naw xünnak am mcehnaki xawi, ");
INSERT INTO dao_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","kami ja mhlänaka Banabah ja Pawluh,Bawipa Jesuh Khritawa phäh ami sak käh mceh naki xawi, atänga ja xü u lü, nami veia kami jah tüih law vaia kami jah tak, ");
INSERT INTO dao_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ahina mawngma ning jah mtheh law khai xawia, Judah ja Tilah cun nami veia kami ja tüih law. ");
INSERT INTO dao_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ngmüimkhya Ngcim ja keimi naw atänga, yühkia phüi cun nami khana mtai üng am daw khaia ngai ve üng, ");
INSERT INTO dao_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","juktuh peta eiawk, khisaa thi, kbüh lü hnima sa käh jah ei u lü hüipawmnak jah cehta ua; ahina ngkhaw nami jah cehtak üng ta nami phäha daw khai ni. Mya u lü ve u” tia ami yuk. ");
INSERT INTO dao_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Acukba ami jah tüih cun cit ni lü, Antiok phaki xawi; acunüng, khyange jah khü ni lü, ca cun ani jah pet. ");
INSERT INTO dao_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ami khe law päng ja, ami ja mcäinaka ngthua phäha aktäa jekie. ");
INSERT INTO dao_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judah ja Tilah cun sahmaa pi kyaki xawia kya lü, ngthu khawha am, benae jah mcäi ni lü, khawvei ktha ani jah pet. ");
INSERT INTO dao_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Acua khawvei ani ve käna, jah tüih lawki hea veia nghlat be khai xawia, benae naw dim’yenak am ami jah tüih be. ");
INSERT INTO dao_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Acunsepi, Tilah cun amät ve hütki. ");
INSERT INTO dao_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pawluh ja Banabah cun Antiok khyang khawhah am ve yüm lü, Bawipa ngthu jah mtheimthang ni lü atänga veki xawi. ");
INSERT INTO dao_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Khawveica angsawk law käna, Pawluh naw Banabaha veia, “Tuhkbäih ni cit be lü, Bawipa ngthu ni sangnaka khaw naküta bena vekie veia cit hü lü ami vecawh ni jah bükteng hü vai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabah naw, Johan Makuh ami ti cun ani veia cehpüi vaia a täng, ");
INSERT INTO dao_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pampulih khaw üngka naw ja hawih hüt lü, khüibi bi khaia ani hlawnga am cit hngakia kyase, Pawluh naw ta Makuh ani hlawng cehpüi vaia am jum. ");
INSERT INTO dao_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Acunakyase, aktäa ngcuhki xawi, ngtai law ni lü, Banabah naw Makuh cun a hlawnga cehpüi lü, Kuparuha mlawng am citki xawi. ");
INSERT INTO dao_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pawluh naw Tilah a xü; acunüng, jumeikie naw Bawipa bäkhäknak ami mcei vai ja ngthu ami jah pet. ");
INSERT INTO dao_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Sangcime jah khäng hüsak lü Siria ja Kilikih khaw avan üng cit hüki. ");
INSERT INTO dao_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pawluh ja Tilah cun Derbe ja Luhtarah citki xawi; acua Timoti ngming naki khritjan mat veki; ani cun jumeikia Judah nghnumia cakpaa kyaki, a pa cun Krika kyaki; ");
INSERT INTO dao_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ani cun Luhtarah ja Ikoniha vekie naw jumeiki ti lü ania mawng cun pyenkie. ");
INSERT INTO dao_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pawluh naw ani cun ami hlawnga ami cehpüi vai a täng. Acunüng, acua vekiea Judahea phäha, a vun a mawihsak, a pa Krika kyaki tia ami van naw ami ksinga phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mlüh naküt üng cit hü ni lü, Jerusalema angvaie ja ngsä he naw ami mkhyaha jah läklam vaie cun jumeikie üng ani jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sangcime cun jumnak üng khäng u lü a mhnüp tä se nung law dämdämkie. ");
INSERT INTO dao_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ngmüimkhya Ngcim naw Asah hne ngthu sang vai am ti se, Pharikih hne ja Kalatih hne avan üng cit hüki xawi. ");
INSERT INTO dao_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mutih ng'yü pei ani pha law ja, Bithunih hnea lut khai xawia büki xawi, acunsepi, Jesuha Ngmüimkhya naw am a jah cehsak. ");
INSERT INTO dao_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mutih khe ni lü, Taros da citki xawi. ");
INSERT INTO dao_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mthana Pawluh naw mdannak üng Maketawniha khawa ka khyang mat ngdüi lü, “Maketawniha khawa law lü, jah kpüi lawa” tia, nghui na se a hmuh. ");
INSERT INTO dao_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Acuna mdannak a hmuh law päng ja, ami veia thangkdaw pyen khaia Pamhnam naw jah khüki tia ksing ni lü, Maketawniha hnea ceh vaia kami ngtünki. ");
INSERT INTO dao_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Taros üngkhyüh mlawng am cit u lü, Samotarat kami citki, angawi üng Nepoliha kami cit be tüki; ");
INSERT INTO dao_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Acun üngka naw Philipih mlüha kami citki, acuna mlüh cun Maketawniha khaw üng mlüh mata kya lü, Romah mlüh ktung üngkaa kyaki. Acuna khaw üng khawvei kami veki. ");
INSERT INTO dao_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabbath mhnüp üng, khaw kpunga cit u lü, tui caye da, Judahea ktaiyünaka hnüna vekia kami ngaih. Acua ngaw lü, ngbäm lawki hea nghnumie veia ngthu kami pyenki. ");
INSERT INTO dao_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Acunüng, Lidia ngming naki, jihsen jawiki, Tuhtirah khawa ka, Pamhnam jumkia nghnumi mat naw kami ngthu ngja lü, Pawluha ngthu pyen cun aktäa ngai khaia Bawipa naw a mlung a mhmawng. ");
INSERT INTO dao_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","A im khyawng avan naw Baptican ami khan law päng üng, “Bawipa jumei kcangkia nami na ngaih üng ka ima kai law ua” tia, jah nghui na lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mhnüp at üng ktaiyünaka hnüna kami ceh k'um üng, mpya nghnumica mat malam pyen lü ngjoki kami khyum. Acuna nghnumica cun Ngmüimkhya kse naw a mahpa phäh malam pyen lü ngui khawh yahki. ");
INSERT INTO dao_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Acun naw Pawluh ja keimi jah läk law lü, “Hina küikyannaka lam ning ja mtheh lawki he cän hlüngsäihki Pamhnama mpyae ni” ti lü, ngpyangki. ");
INSERT INTO dao_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Acukba khaw mhnüp khawvei veki. Acukba kyase Pawluh naw am ngja law hlü lü, nghlat sihki naw, Ngmüimkhya kse üng, “Jesuh Khritawa ngming am ka ning mthehki, a k'um üngka naw lut law” a ti ja lut lawki. ");
INSERT INTO dao_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Acunüng, a mahpae naw, ami ngui suinak päihki tia ksing law u lü, Pawluh ja Tilah jah man u lü, khyang ngkhämnak, angvaiea veia ami jah cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Romah Bawiea veia ja cehpüi u lü, “Hi xawi hin Judah khyang xawia kyaki xawi, kami mlüh jah khuimkha lawki xawi, ");
INSERT INTO dao_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ami naw mi thum kpetki thumcam jah mtheikie. Mimi cun Romah khyanga mi kyaki. Amimia bilawh cun am mi läk dat vaia thum pyeni xawi” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Acunüng khyange cun Pawluh ja Tilah jah pawh khaiea ngkhäm law hngakie, bawie naw ani kcu ja suisak u lü, cung am jah kpai vaia ngthu ami jah pet. ");
INSERT INTO dao_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Khawvei ami jah kpai päng lü, thawngima ja khyumkie naw, thawng ngvai naw ngängki am, üp ye khaia a ngäng vaia ami jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Acukba mtheh u se, thawngim ngvai naw, thawngima ak'um säisäiha ja khyumki naw, ani khaw cun khyaw üng a jah khun. ");
INSERT INTO dao_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Acunsepi, Pawluh ja Tilah cun, mthana Pamhnama veia ktaiyü ni lü, ng’äi mcuk ni se, thawngim üng kyum hngakie naw ami jah ngaih. ");
INSERT INTO dao_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Angxita ngkhyü ngsün law se, thawngima hnün pi ngsün lawki; acunüng, ksawh naküt nghmawng law se, khyange ami jah khihnake cun ngsutei law päihkie. ");
INSERT INTO dao_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Thawng ngvai cun a ihnak üngkhyüh tho lawki, thawngim ksawhe nghmawng u se jah hmu lü, thawng kyume dawng päikiea ngai lü, a kcim lo lü hnimei khaia ngtängki. ");
INSERT INTO dao_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Acunsepi, Pawluh naw, ngpyang lü, “Käh thawna; kami van hia kami veki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Thawng ngvai naw meikdäi akjanga jah kthäh lü, kyühei lü ngkhyet lü, Pawluh ja Tilaha hmaia kawpki. ");
INSERT INTO dao_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kpunga jah cehpüi lü, “Saja xawi aw, küikyannak ka yah vaia i ka pawh khai?” a ti. ");
INSERT INTO dao_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ani xawi naw, “Bawipa Jesuh jumeia, acunüng, namät ja na khuiim khyawng lawnge maha küikyannak nami yah khai” ani ti. ");
INSERT INTO dao_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Acunüng, a veia ja, a ima vekie naküta veia Bawipaa ngthu ani pyen. ");
INSERT INTO dao_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Acuna mthan, acun naji üng jah cehpüi lü, ami jah kpainaka ani nghmae cun a jah mthih pet; acunüng, amät ja a khuiim khyawng lawng ami ngkhä Baptican khankie. ");
INSERT INTO dao_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","A ima ja cehpüiki naw, jah khin na lü, Pamhnam ami jumei lawa phäha, amät cun a khuiim khyawng lawng ami van am aktäa jekie. ");
INSERT INTO dao_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Khaw a thaih law ja, Romah bawie naw, “Acun xawi jah khyah ua” tia, jee ami jah tüih. ");
INSERT INTO dao_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Acunüng, thawng ngvai naw, Pawluha veia, “Bawie naw, ning ja hlät khaiea, khyang jah tüi lawki he ni; acunakyase, atuh lut law ni lü, dim’yenak am cit nia” a ti. ");
INSERT INTO dao_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Acunsepi, Pawluh naw, “Romah khyanga kami kyaki, kami mkhyenak am ve xaki ami jah kpai u, thawngim üng ami jah khyum; atuh anghmüa jah ktäm khaiea bükie aw? Acukba am kya sawxat khai; amimät Romah ngvaie law u lü, jah hlät law u se” tia, je ngvai ani jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Je ngvai naw, acuna ngthu cun Romah ngvaie ami jah mtheh; acunüng, Romah khyanga kyaki xawi tia jah ksing law u lü, kyühei lawki he naw; ");
INSERT INTO dao_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","va cit u lü, ja mcäikie naw, jah nghui na be u lü, thawng üngka naw jah hlät u lü mlüh cun ani cehtak vaia ami jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Acunüng, thawngim üngka naw lut law ni lü, Lidia ima citki xawi; jumeikie jah hmu ni lü, jah dim’yesak ni lü, cit beki xawi. ");
INSERT INTO dao_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pawluh ja Tilah cun Amphipolih ja Apolonih jah khe pah lü, Thesalonikah mlüha Judahea sinakoka venaka citki xawi. ");
INSERT INTO dao_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Acua Pawluh cun a thum khawia mäiha, ami veia lut lü, Sabbath mhnüp kthum vei, khyange mahmah ngthäh ngkhyah u lü pyen u lü, Cangcim üngka jah mtheh lü, ");
INSERT INTO dao_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mesijah naw khuikhanak khamei khaia akyaka mawng, thinak üngkhyüh a tho be vaia mawng cun jah mthehki. “Hina Jesuh ka ning jah mtheh cun Mesijaha kyaki ni” ti lü Pawluh naw a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Avang he naw jum u lü, Krik khyang khawhae ja nghnumi khawhae naw Pawluh ja Tilaha veia law u lü Mhnam mküimto lawki he. ");
INSERT INTO dao_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Acunsepi, Judahe naw, k’eihei u lü, lama i käh pawhkie cun jah lawpüi u lü khyange jah ngcun lawsakie naw, mlüh avan üng suksak lawki he. Acunüng, Jasona ima ngkhäm law u lü, Pawluh ja Tilah cun khyangea hmaia ami jah cehpüi vaia ami täng. ");
INSERT INTO dao_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Am jah hmu u lü, Jason ja jumeikie cun khyang ngvaiea hmaia jah kaihkie naw, ngpyang u lü, “Hina khyange naw avan suksak khaia Khawmdek nglatsakie cun mi mlüha lawki he; ");
INSERT INTO dao_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason naw jah na khin na ve, ahin xawi cun, ‘Jesuh ngming naki, sangpuxang kce veki tia, Emperoa thum am läk ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Acuna khyange naw mlüh ngvaie cun ami jah suksakei; ");
INSERT INTO dao_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jason ja a püie cun ngui jah tä lü jah hlät lü ami jah cehsak be. ");
INSERT INTO dao_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jumeikie naw mthana, Pawluh ja Tilah cun Beriha jah cehsak u se; acua ami va pha ja, Judahea sinakoka lutki xawi. ");
INSERT INTO dao_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Acuna khaw khyange cun, Thesalonikah mlüh khyangea kthaka ana daw u se, mlung jenak am ngthu cun dokhameikie, ani ngthu pyen cun am akcang ja akcang ksingnak vaia, a mhnüp tä se, Cangcim cun büktengkie. ");
INSERT INTO dao_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Acunakyase, khyang khawha naw jum u se; Krik nghnumi kdawe ja kpamie naw pi jum lawki he. ");
INSERT INTO dao_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Acunsepi, Thesalonikah mlüha ka Judahe naw, Pawluh naw Berih mlüha pi Pamhnama ngthu sangki tia ami ksing üng, acua pi va cit u lü, khyange ami jah va ksük. ");
INSERT INTO dao_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jumeikie naw, Pawluh cun tui cayea cit khaia ami tüih. Acunsepi, Tilah ja Timoti cun acua ve hütki xawi. ");
INSERT INTO dao_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pawluh va thakie naw, Aten mlüh cäpa cit u lü Berih da nglat law be lü Pawluh naw a jah cüka kba, Tilah ja Timoti cun naw akjanga a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pawluh naw Atena Tilah ja Timoti jah k'äih lü a ve üng, mlüh cun juktuhe am be lü a hmuha kyase, aktäa a mlung am daw. ");
INSERT INTO dao_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Acunüng, sinakoka Judahe ja Pamhnam jumkie khyangmjükcee jah pyenpüi lü, khyang ami ngkhämnaka law nakütkia veia a mhnüp tä se a jah pyenpüi. ");
INSERT INTO dao_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikurih ja, Stok sajae naw ani ngcuhpüikie. Avang he naw, “Hin ia am ngtäh xaki naw i pyen hlüki ni?” ami ti. Avang he naw, Jesuha mawng ja thawhnak bea mawng a pyena phäha, “Pe kcea ka mhnama mawng pyenki am ni aw” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Pawluh cun man u lü, mlüh kawngci, Arepakaha hmaia lawpüi u lü, “Hina mtheimthangnak akthai na pyen hü hin na jah ksingsak thei khai aw? ");
INSERT INTO dao_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Akthai am kami ngjak khawi cun na sang lawki ni; acunakyase, acuna suilam kami ksing vai täng ve üng” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Aten mlüha khyange ja khine cun, ngthu kthaia akyak üng, ami pyen vai ja ami ngaih vaia phäha ami kcün sumeiki he.) ");
INSERT INTO dao_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pawluh cun kawngci hmaia ngdüi lü, “Nangmi Aten khyange cun, a naküt üng jumnak aktäa nami taki ti ka ksingki. ");
INSERT INTO dao_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ka ceh hü sawa, nami hjawkhahe ka ja bükteng üng, kpyawngkung mata khana, ‘Am ksinga Mhnama phäha’ ti lü ng’yuki ka hmuh. Acunakyase, am ksing u lü nami jumei, acuna mawng ka ning jah mthehki ni. ");
INSERT INTO dao_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Pamhnam, khawmdek ja a k'uma veki naküt ja mhnünki cun, mce ja khana Bawia kyase kut am saka temple üng am ve. ");
INSERT INTO dao_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Khut bi lü a hlüei cun mi pe khai aw, amät kung cun anaküt am xünnak, ngxünak a naküt üng pekia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Acunüng, khawmdek khan naküt üng ve khaia, khyang mat üngka naw khyang mjüe naküt atäng tänga jah mhnün lü, ami phäha akcün ja ami venak vai phäh phähe pi a jah tak pet. ");
INSERT INTO dao_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Acunakyase, Pamhnam cun ami hmuh vaia sui hükie; acunsepi, Pamhnam cun mimi üngkhyüh akthuka am ve. ");
INSERT INTO dao_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Amäta phäha mi xüng lü, mi thoawm lü mi veki; ‘Keimi pi Mhnama a jah caea kami kyaki’ tia nangmi üng khyang mat naw pyenki. ");
INSERT INTO dao_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Acukba Pamhnama caea mi kya ua phäha, nghngicima khyaihnak am pyanga xüie, nguie, lung he lup cun Mhnam am tänga käh jah ngaih vai. ");
INSERT INTO dao_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ahlana Pamhnam am ksing u se, jah na hawih khawi se pi, atuh cun ahawa pi ami mkhyekatnak nghlatak vaia ngthu a jah petki, ");
INSERT INTO dao_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","akcün a na pyang päng thüp thüpa phäha, acuna mhnüp üng, a mcawna nghngicim phäh khawmdek avan cun angsunga ngthumkhyah law pe khai; acun cun Pamhnam naw thihnak üngka naw mtho be lü, khyange naküta veia angsingsak pänga kyaki” tia a pyen. ");
INSERT INTO dao_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Acuna thihnak üngka naw mthawh bea ngthu Pawluh naw pyen se ami ngjak üng avange naw ami yaihei; avange naw, “Hina ngthu na pyen be vai ngja hlü ve üng” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Acunüng Pawluh naw ami ngkhyumnak a jah cehtak. ");
INSERT INTO dao_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Acunsepi, khyang avange Pawluha veia ngdawn law u lü, jumei lawki he; acunüng avange cun, Dajonutih khyang kawngci üngkaa kya u lü avange cun nghnumi mat Damarih jah khyang kcea kyakie. ");
INSERT INTO dao_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Acunüng Pawluh cun Aten mlüh üngka naw Korintuha citki. ");
INSERT INTO dao_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Acuia Akuilah ngming naki Judah khyang mat a hmuh, acun cun Pontasa hmikia kyaki. Sangpuxang Kalawdih naw Judahe naküt Romah hne üngka naw ami ceh vaia jah ktäm se, a khyu Priscilah am Itali üngka naw law thaiki xawia kyaki. Pawluh naw jah hmu khai citki. ");
INSERT INTO dao_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pawluh cun, acu xawia veia phaki, acunüng, ami bi tängkia kyase, ani veia ve lü, ani veia khüikawm hngaki; ami bi cun jih im saka kyaki. ");
INSERT INTO dao_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabbath naküt üng sinakoka yet na kcang lü ngthu pyen khawi lü, Judahe ja Krike jah yah khaia büki. ");
INSERT INTO dao_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tilah ja Timoti cun Maketawniha üngka naw pha law ni lü, Pawluh cun a kcün naküt üng Judahe veia Jesuh cun Mesijah ni ti lü ngthu jah mthehki. ");
INSERT INTO dao_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Acunsepi Judahe naw ma u lü ksenakiea kyase, Pawluh naw a suijih üngka mput kha lü ami veia, “Nami khyüh üng namimäta phäh ni, kei naw am mta na veng. Tuhkbäih khyangmjükceea veia ka cit khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Acun üngka naw citki cun, Tihtuh Jastas ngming nakia ima phaki, acun cun Pamhnam jumki, a im pi sinakoka peia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Acunüng, Kripuh, sinakoka ngvai naw, a khuiim khyawng lawng ami van naw Bawipa jumei law u se, Korintuh khyang khawhae naw pi ngja u lü jumei law hnga u lü, Baptican khankie. ");
INSERT INTO dao_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mthana Bawipa naw mdannak üng, Pawluha veia, “Käh kyühei lü, ngthu na pyen cän käh hjaüha; ");
INSERT INTO dao_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kei na hlawnga ka veki ni, ning hui khaia u naw am ning pawh; hina mlüh üng, ka khyang khawha ka taki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pawluh cun, acua ami veia Pamhnama ngthu jah mthei lü, kum mät ja khya khyuk veki. ");
INSERT INTO dao_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Acunüng, Kalio, Akaijah mlüha sangpuxang Romah naw a mcawn üng, Judahe naw atänga Pawluh man u lü, junga cehpüikie. ");
INSERT INTO dao_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Hin khyang naw, käh nglawi khaia Mhnam jum vaia khyang ksük lü thum lümkanki” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pawluh naw a pyen law hlü üng, Kalio naw Judahea veia, “Judahe aw, hin hin am dawki ja mkhyekatnak a pawh a nia ta, acinglinga ka ning jah ngaih pet vai sü; ");
INSERT INTO dao_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","acunsepi, ngthu nami ngcuh, ngming he ja nami thumea ngkhawa kya üng ta, namimät naw pyensa ua; kei acuna ngkhaw ka cijang vai am täng veng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Acunüng, jung üngka naw, ami van a jah ksät. ");
INSERT INTO dao_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Krike naw, sinakok ngvai Soten mankie naw, junga maa kpai u se, Kalio naw acun cun ia pi am ngai. ");
INSERT INTO dao_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Acun käna Pawluh cun khawvei ve lü; acun käna Korintuha jumeikie cun thangkdaw am jah ngtaipüi lü, acun üngka naw Siria da mlawng am citki, a veia Priscilah ja Akuilah cit hngaki xawi; Pawluh naw ajana sitih ana taka mäiha Kenkirih mlüha a lusam kteih petki. ");
INSERT INTO dao_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ephet mlüha pha u se, acua anini cun jah hawih hüt lü, amät sinakoka k'uma lut lü, Judahea jah ngthähngkhyah püiki. ");
INSERT INTO dao_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Khawvei ve khaia ami nghuinak, acunsepi am yü. ");
INSERT INTO dao_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“Pamhnam naw a hlüeia akyak üng nami veia ka law be khai ni” tia, thangkdaw am jah ngtaipüi lü, Ephet üngka naw mlawng am citki. ");
INSERT INTO dao_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ketarih a pha üng, Jerusalema jäng cit lü, sangcime cun a jah hnukset; acun käna Antiok mlüha cit beki. ");
INSERT INTO dao_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Acua khawvei a ve käna cit be lü, jumeikie ngjuktha jah pe lü, Kalatih hne ja Pharikih hne avan üng cit hüki. ");
INSERT INTO dao_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Judah khyang mat, Aleksandria mlüha hmiki, Apawluh ngming naki, Ephet mlüha lawki; ani cun pyensak yah lü Cangcim aktäa ksingkia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ani cun Bawipa Mawnglam ngthei pängkia kya se, yet na kcang lü, Jesuha mawng kcang aktäa xena lü jah mtheimthangki, acun se pi Johana Baptican däk va ksingkia kyaki. ");
INSERT INTO dao_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Acunüng, sinakoka lingnak kcang am ngthu pyen law se, acua Priscilah ja Akuilah naw a ngthu pyen ngja ni lü, ani ima khüki xawi naw, a veia Pamhnama Mawnglam cun ngsing ngai khaia ani mtheh. ");
INSERT INTO dao_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apawluh cun, Akaijah khawa cit khaia ngtängse, Epheta veki jumeikie naw ami na dokhamnak vaia, jumeikie naw ca yu u lü ami cehsak. Acunüng, a va pha üng Pamhnama bäkhäknak am jumeikie cun aktäa jah kpüikpaki. ");
INSERT INTO dao_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Jesuh cun Mesijaha kyaki tia mawng cun Judahe jah ngcuhngkaih püi lü Cangcim üngka jah mdang lü khyange aktäa a jah näng. ");
INSERT INTO dao_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apawluh Korintuh mlüha a ve k'um üng, Pawluh cun pe k'uma ceh hü päng üng Epheta pha law lü, axüisawe avang a jah hmuh. ");
INSERT INTO dao_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ami veia, “Nami jumei law üng Ngmüimkhya Ngcim nami yahki aw?” a ti. Acunüng, amimi naw, “Ka; Ngmüimkhya Ngcim veki tia pi am ngja khawi u ngü” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ani naw, “Ia Baptican ja nami khan?” a ti. Amimi naw, “Johana Baptican” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pawluh naw, “Johana Baptican cun ami mkhye nglatakia phäh kyaki, ‘Johan naw Isarel khyange üng, ‘Ka hnua law khai cun nami jum vai, “Ani cun Jesuh ni” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Acuna ngthu ami ngjak ja, Bawipa Jesuha ngming üng Baptican khankie. ");
INSERT INTO dao_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pawluh naw, ami khana a kut mtai se, Ngmüimkhya Ngcim ami khana pha lawki; acunüng, läk akce am ngthu pyen u lü, Mhnama mawng sangkie. ");
INSERT INTO dao_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ami vana kpami xaleinghngih lawki he. ");
INSERT INTO dao_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pawluh cun sinakoka k'uma lut lü, khya kthum üng yet lü ngthu pyenki, Pamhnama pea mawng cun khyange jah ngcuhpüi lü jah ksingsaki. ");
INSERT INTO dao_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Acunsepi, avange cun ami mlung ngcang se, am jum u lü khyangea hmaia Bawipaa Mawnglam ami ksekhanak. Pawluh naw jah cehta lü, jumeikie akcea jah cehpüiki naw, amhnüp tä se Turanah ima jah ngthähpüi lü jah mtheimthangki. ");
INSERT INTO dao_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Acukba kum nghngih jah mthei se, Asah hnea vekie naküt Judahe ja Krike naw pi Bawipa ngthu cun ngjakie. ");
INSERT INTO dao_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pamhnam naw Pawluh üngkhyüh müncam phyaki jah pawhki. ");
INSERT INTO dao_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Acunüng, Pawluha pava ja a jih cum am khyaihki vei ami cehpüi, mnehmnange cun khyük u lü khawyaie pi ngsätkie. ");
INSERT INTO dao_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Khawyai ksät hükie Judah avange naw, “Pawluh naw a pyen hü khawia Jesuha ngming am ning jah ksät ve üng” ti u lü, khawyaia venaka khyangea khana, Bawipa Jesuha ngming sumeiki he. ");
INSERT INTO dao_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Judah khyang, ktaiyü ngvai säih mat, Sakevaha cakpa khyühe naw acukba pawh hlüki. ");
INSERT INTO dao_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Acuna khawyai naw ami veia, “Jesuh ka ksingki, Pawluh pi ka ksingki, nangmi hin ue ni?” ti lü a jah kthäh. ");
INSERT INTO dao_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Khawyaia venak naw, jah jawng law sih lü, ami van jah nängei se, acuna im üngkhyüh, lemkie kyase, ami suisak hawih hüt lü dawngkie. ");
INSERT INTO dao_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Epheta vekia Judahe ja Krikea veia, acuna ngthu cun ngthang hüki; acunüng, avan kyüh hü u se, Bawipa Jesuha ngming mhlünmtai lü veki. ");
INSERT INTO dao_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Jumeikie khawhah law hü u lü, ami bilawhe cun khyang ksunga jah phyeh lawki he. ");
INSERT INTO dao_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ngjo khawhae naw pi, ami caupe jah lawpüi u lü, khyang ksunga ami jah mkhih law; acun üng, a phu täh u se, ngui thawng mhmakip phunakia ami ksing. ");
INSERT INTO dao_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ahikba johit am be lü, Bawipaa ngthu cun ngthang hü lü däm law bawk bawki. ");
INSERT INTO dao_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Acun käna Pawluh cun, Maketawniha ja Akaijah üng kdung hü lü, Jerusalema cit khaia ngtängki, “Acua ka ceh käna Romah pi ka hmu khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Khüipüiki xawi nghngih, Timoti ja Eratuh cun Maketawniha hnea jah cehsak lü, amät cun Asah hnea ve hüki. ");
INSERT INTO dao_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Acuna kcün üng Epheta Bawipaa Mawnglama phäh aktäa khuikhanak veki. ");
INSERT INTO dao_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dematarih ngming naki, nguiksep naw Artimih mhnam nghnumicaa alup sep se, a khyange naw khawhthem khawhah yah nakie. ");
INSERT INTO dao_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ani naw, ami bi tängkia nguiksepe jah ngcunpüi lü, “Ka püie aw, hina khawhthem cun hin mi bilawhnak üng lawki tia mi ksingki, ");
INSERT INTO dao_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Tuha Pawluh naw, ‘Khyanga kut am pyang naküt cun mhnama am kya ve’ ti lü, hina Epheta däka am kya, Asah hne naküt üng pi khyang khawha jah ksük se, hmu u lü nami ksingki. ");
INSERT INTO dao_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","“Acunakyase, mi bi, ngui mi yahnak ami jah hmumsit law däk vaia am ni lü mi thang pi se khai ni, hlüngtaikia Artimih mhnam nghnumicaa Temple pi hmumsit law u se, Asah hne üng khyange naküt, khawmdeka khana khyange naw ami jum khawi hin, ia am mawng law khai ni tia pi kyühei phya ve” a ti. ");
INSERT INTO dao_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Acuna ngthu ami ngjak üng ami mlung so law se, “Ephet mlüha ka Artimih hin hlüngtai kcangki ni” tia, ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mlüh avan üng acun ngthang hüki. Kajas ja Aristakhas, Maketawnih khyang xawi Pawluh naw a jah ngkhahpüi cun jah mankie naw, pawi binak ima ami jah cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pawluh cun khyangea maa cit khaia bü se, jumeikie naw ami mkhyawh. ");
INSERT INTO dao_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Acunüng, acuna hne üngka ngvaie, Pawluha püie naw, a veia khyang tüih u lü, pawi binak ima käh cit khai ami nghuinak. ");
INSERT INTO dao_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ngbäm lawki he khawhah naw ami ngbäm lawa suilam pi am ksing u, acunakyase, avang ngthu mat pyen lü ngpyang u se, avang ngthu akce am ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Acunüng, khyang avange naw Aleksanda cun üng mta veki ni ami ti, isetiakyaküng, Judahe naw ani cun maa ami cehsak ni ami ti. Acunüng, Aleksanda naw a kut khyange veia käh khikheh khaiea säng lü, amät sungkhamei khaia ngbüki. ");
INSERT INTO dao_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Acunsepi, ani cun Judah khyanga kyaki ti ami ksing üng, naji nghngih hlawk atänga, “Epheta ka Artimih hin hlüngtaiki ni” tia aktäa ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Acunüng, mlüh kcak’yu naw khyange a jah dimsak lü, “Ephet khyange aw, Ephet mlüh cun hlüngtaikia Artimih Temple ngängki ja khankhawa khyüh lung ngcim kya lawki ni a ti. ");
INSERT INTO dao_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Acunakyase, u am ngtek khawh u ki. Nami dim vai, amdanga i käh nami pawh vai. ");
INSERT INTO dao_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Hin üng nami jah lawpüi xawi hin, Temple phyehkiea am kya ni, nami mhnam pi am ksekha na ni. ");
INSERT INTO dao_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Acunakyase, Dematarih ja a püi nguiksepe naw, nami ngcuh vai am vea kya üng kami ngvaie vekie, junga pi mi cit khaie ami ti. ");
INSERT INTO dao_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Akce mtai vai nami tak üng pi, kcang mkhyah vai mlüha veki khyange am mi ngkhyum khaie ami ti. ");
INSERT INTO dao_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tungawi thawnhlawkia phäha mi kyühkyawk vai suksaknak vaia veki. Isetiakyaküng hina am kcangkia ngbämnak cun ami jah msuhei ta ihawkba pi am mi pyen thei khai ni. ");
INSERT INTO dao_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Acun a pyen päng ja ngbäme a jah tüih be. ");
INSERT INTO dao_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Suksaknak a ngdüm law käna, Pawluh naw jumeikie atänga jah khü lü ngjuktha jah pe lü a jah ngtaipüi. Ani cun jah cehta lü Maketawniha citki. ");
INSERT INTO dao_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A ceh sawa acuna hne cu khyang khawhah ngjuktha jah peki. Acun käna Akhacia cit lü, ");
INSERT INTO dao_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","acua khya kthum veki. Ani cun Siriaa cit khai ngtängki lüpi Judahe naw ami pawh vaia ceng u se, Maketawniha da nglat khaia ngtünki. ");
INSERT INTO dao_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Puruha cakpa Sapotah Beriha ka, Aristakhas ja Sekudah Thesalonikaha ka xawi, Kajas cun Derbea ka, Timoti, Taikikah ja Throphimah Asaha ka xawi, acune cun ani üng atänga veia cit hngakie. ");
INSERT INTO dao_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Acunee cun ana cit ma u lü, Tarosa keimi jah na k'äihkie. ");
INSERT INTO dao_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Keimi cun hngen am kcaw muk pawi käna, Philipih üngka naw mlawng am cit u lü, amhnüp mhma üng Taros kami phaki; acua mhnüp khyüh kami veki. ");
INSERT INTO dao_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Acunüng, mhnüp khyühnak mümlama bu ei yüm vaia kami ngcunki. Acunüng Pawluh cun a ngawi üng cit khaia bükia kyase, ami veia ngthu pyenki naw, mthan nglung cäpa a pyen. ");
INSERT INTO dao_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kami ngcunnak khan ima meiim khawhah ami jah mdäi. ");
INSERT INTO dao_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Etukhuh ngming naki cawngpyang mat mkawt peia ngaw lü, a mik ku se ngam lü veki. Acunüng, Pawluha ngthu pyen thuk law se, ip tawng lü im athat kthumnak üngka naw mcea kya se akthia ami law be. ");
INSERT INTO dao_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Acunüng, Pawluh kyumki naw, a khana ngbawk lü kawiki naw, “Käh ng’ä ua, xüng ham ve” a ti. ");
INSERT INTO dao_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pawluh kai be lü, muk bo lü eiki. Khaw athaih law lü nghngi a pyü law cäpa ngthu pyen lü, acun käna citki. ");
INSERT INTO dao_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Acunüng, cawngpyang cun akxünga ima cehpüi be u se aktäa ami mlung dim’yeki. ");
INSERT INTO dao_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Keimi cun mlawng am law u lü, Asiha kami cit khaia mlawng am kami na cit maki, acunüng Pawluh cun kami ngcum lawpüi vaia kami täng kyaw; a khaw am law khaia ngtängki. ");
INSERT INTO dao_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asiha jah na ngkhyum püi lü, ani kpan law lü Mituliniha kami citki. ");
INSERT INTO dao_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Acunüng ka naw, mlawng am cit u lü, a ngawi üng Kioh kami phaki. A ngawi üng, Samoh pha u lü, a ngawi be tü üng Miletuh kami phaki. ");
INSERT INTO dao_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pawluh cun Asaha khawvei a ve vai am täng lü, Ephet da cun mlawng am cit khaia bü kungkia kyaki, athawn theia kyak üng Jerusalema Pentikos mhnüp üng a pha vai ngsengeiki. ");
INSERT INTO dao_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Acunüng, Miletuh khaw üngka naw, Epheta khyang tüih lü, sangcim ngvaie a jah hmuh vaia a ja khüsak. ");
INSERT INTO dao_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Acunüng, a veia ami pha law üng, Pawluh naw, “Asah hne ka pha law üng tün lü, atuh cäpa ihawkba ka kcün ka sumeiki tia nami ksingki. ");
INSERT INTO dao_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mdihmsuinak ja ka kphyutui baw lü Bawipaa mpya akba khut ka biki. Isetiakyaküng Judahe naw na hnim khai ami büa phäh kyaki. ");
INSERT INTO dao_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nangmi am ka ning jah kuei vaia i pi am ka thupki tia nami ksingki ni, khyangea ksunga ja im naküt üng ka ning jah mthei khawiki. ");
INSERT INTO dao_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judahe ja khyangmjükceea veia pi Pamhnama veia nghlat law be u lü, mi Bawipa Jesuh ami jumei lawnak vaia ngthu ka pyen ni. ");
INSERT INTO dao_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Acunüng, atuha Ngmüimkhya Ngcim kcang na lü Jerusalem da ka cit khai, acua kei ia na pawh khaie am ksingei veng. ");
INSERT INTO dao_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ka cehnak hü mlüh naküta thawng jah mkhuimkhanak naw na k'äihki tia Ngmüimkhya ngcim naw na mthehki ni. ");
INSERT INTO dao_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Acunsepi, ka kcün sak hin ia am kya, isetiakyaküng thangkdaw tinaki Pamhnama bäkhäknak sang lü, Bawipa Jesuh naw a na peta khut ja mission cun ka mcän vai ni ka hlüei ta. ");
INSERT INTO dao_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Acunüng, nangmi, Pamhnama pea mawng sang lü nami veia ka cit hüki. Tuh ta nangmi naw am nami na hmu be ti khai tia ka ksingki. ");
INSERT INTO dao_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Acunakyase, nami khyüha kyak üng keia mtaa am kya ve tia tungawi angtea ning jah mtheh veng. ");
INSERT INTO dao_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Pamhnama a ngjak'hlü naküt avan, nami veia am pyen hlü lü ka mji i am ve. ");
INSERT INTO dao_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Acunakyase, nami mät ja namimät mcei ua, Pamhnam naw a cakpa thisen am a khyäiha sangcim nami mcah khaia Ngmüimkhya Ngcim naw aning jah mceisaka tome cän pi jah mcei ua. ");
INSERT INTO dao_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ka ceh käna mhnge kyung he nami ksunga law u lü, ami naw tomee käh jah mpyenei khaie tia ka ksingki. ");
INSERT INTO dao_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Namimät üngka khyang avange law u lü jumeikie jah mhlei lü ami jah läk vaia thawn law khaie. ");
INSERT INTO dao_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Acunakyase, mcei ua; kum kthum ka kphyutui baw lü, amhnüp amthan ka ning jah mthei cän süm ua. ");
INSERT INTO dao_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Tuhkbäih Pamhnama bäkhäknaka ngthu üng ka ning jah taki, acun naw ning jah sawngsa lü, ani naw Pamhnama dawkyanak a khyangea phäh a tak cun ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ua xüi, ngui, suisak pi am hlüei khawi veng. ");
INSERT INTO dao_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kamät ja ka püiea hlükaw cun kamät bilo lü kami eiawki ti cun namimät naw nami ksingki. ");
INSERT INTO dao_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Acukba nangmi pi khüi u lü, Bawipa Jesuha ngthu nami sümnak am, ktha ngcekie nami jah kpüi vaia, anaküt ka binak am ka ning jah mdanki; amät Jesuh naw, ‘Yahnaka kthaka petmsawtnak üng jekyainak bawk ni” ti lü a pyen. ");
INSERT INTO dao_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Acunüng, acukba ngthu a pyen law päng üng, ami mkhuk jah sümpüi lü ktaiyükie. ");
INSERT INTO dao_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ami van kyap u lü, Pawluh cun kawi u lü aktäa mhnamkie. ");
INSERT INTO dao_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ani am ami hmuh be ti vaia cun a pyena kyase ami mlung thüikiea kyaki. Acunüng, mlawnga venak cäpa cit u lü ami tha. ");
INSERT INTO dao_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Amimi am kami ngtai käna, mlawng am cit u lü Kotah kami pha lawki. Acunüng, angawi üng Rodih pha u lü, acun üngka naw cit u lü, Patarah kami phaki. ");
INSERT INTO dao_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Phonisia cit khaia mlawng mat hmu u ngüse, acun ngcum u lü kami citki. ");
INSERT INTO dao_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kuparuh hmunaka cit u lü, cumlama cit u lü Siria kami phaki. Acunüng Turah tui pei kami phaki. Acua mlawng üngka phüihe jah lawh vaia kyase. ");
INSERT INTO dao_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Acunüng, jumeikie jah hmu u lü, acua mhnüp khyüh kami veki; acunüng, anini naw Pawluh cun Ngmüimkhya am mtheh u lü, Jerusalema käh a ceh vaia ami mtheh. ");
INSERT INTO dao_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Acunsepi, acuna mhnüp päih law se, jah tak hüt lü kami kdungki u lü, cit u ngü se, ami van naw, ami khyucae mah maha mlüh khaw kpung üngkhyüh tui pei cäpa am jah tha law; acua mkhuk msüm u lü kami ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","“Mya lü bä” ti u lü mat jah mat mtheh lü mlawng üng kami ngcum üng amimi cun ami ima nghlat bekie. ");
INSERT INTO dao_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Acunüng, Turah üngka naw mlawng am kami ceh law päng üng, Potalemaia kami phaki, acua jumeikie jah hnukset u lü, ami veia mhnüp mät kami veki. ");
INSERT INTO dao_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","A ngawi be tü üng, Ketarih kami phaki; acua thangkdaw sangki Philipa ima kami lutki, ani cun Jerusalema jah kpüi khaia xü, khyühe üngka mata kyase a veia kami veki. ");
INSERT INTO dao_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ani cun nghnumica phyü jah ca naki. Amimi naw Pamhnama ngthu sang hükie. ");
INSERT INTO dao_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Acua mhnüp khawvei kami vekie, acuna üng Judah hnea ka Akabas ngming naki sahma mat lawki. ");
INSERT INTO dao_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kami veia law lü, Pawluha ksawmyüi lo lü amäta kut khawe jah khit lü, “Jerusalema Judahe naw hikba hina ksawmyüi ka naki khit u lü, khyangmjükceea kut üng ap khaie, Ngmüimkhya Ngcim naw a pyen ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Acuna ngthu kami ngjak ja, Pawluh cun Jerusalema käh cit khaia keimi jah akcee naw kami nghuinak. ");
INSERT INTO dao_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pawluh naw, “I vai kyap u lü, ka mlung nami na puksetsaki ni? Bawipa Jesuha ngminga phäha ta Jerusalema ami na khih däka am kya lü thih vaia pi ka lingki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mtheh lü am ng’yah se, “Bawipa hlüeia kya kawm” kami ti. ");
INSERT INTO dao_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Acua kcün kami sumei käna kami phüie jah pitpyang u lü, Jerusalema kami citki. ");
INSERT INTO dao_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ketariha üngka axüisawe avang kami hlawnga law hngakie naw, Manatung ngming naki jumei kcük üngka, Kuparuha ka mat, kami cehnaka ami ngkhahpüi hnga. ");
INSERT INTO dao_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalem mlüh kami pha üng jumeikie naw hlimtui khaia ami ja na khinnak. ");
INSERT INTO dao_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","A ngawi üng, Pawluh naw Jakuka ima jah cehpüi se, acua sangcim ngvaie veki. ");
INSERT INTO dao_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pawluh naw amimi jah hnukset law päng lü, a khüibinak summangei lü Pamhnam naw khyangmjükceea veia bi a bisak naküt avan a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Amimi naw acuna ngthu ami ngjak üng Pamhnam mhlünmtai u lü, Pawluha veia, “Pawluh aw, Judah khyange thawng khawhah jumei lawki ja ami van naw Thum pi kthanakie; ");
INSERT INTO dao_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","acunsepi, khyangmjükceea veia vekiea Judahea veia, ami cae ami vun käh ami jah mawih vai ja Mosia Thum ami hawih vaia na ja mtheiki tia pyenkie. ");
INSERT INTO dao_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ihawkba kya hlüki ni? Na pha law pi ngjakie ni. ");
INSERT INTO dao_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Acunakyase, na veia kami pawh vai cun hin ni. Khyütam taeiki khyang kphyü kami vekie. ");
INSERT INTO dao_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Acune jah ngkhahpüi lü, ngcimcaihnak pawia va ngpüi hnga lü, lu kteinaka phu jah pet pe kaw pi. Acunüng, khyange naw, ami ngjak am kcangki tia, namät kung naw Mosi thum na läki tia ksing khaie. ");
INSERT INTO dao_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Khyangmjükce jumeikie am, juktuh üng peta eiawk, khisa thi, khisa ami kbüh ja hüipawmnake üng ami ngcimcaih vaia kyaki tia, ca kami yuk päng ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Acuna ngawi üng Pawluh naw, acuna kpamie jah ngkhahpüiki naw, ami veia ngcimcaih hnga lü, Templea k'uma lutki naw, ami ngkhäa phäha petnak akce pawh lü ngcimcaihnaka mhnüpa kümnak vaia mhnüp cun ivei hjo khai ti cun a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mhnüp khyüh a küm law hlü üng, Asah üngka Judahe naw Pawluh templea k'uma hmu u lü, khyange naküt jah ksükie naw ami man. ");
INSERT INTO dao_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ngpyang u lü, “Isarel khyange aw, jah kpüi law ua, hin naw khaw naküt üng khyang naküta veia, Judah khyangea thume, hina Temple jah kse na ve; acun däk am ni, templea k'uma pi Krik khyange jah luhpüi lü, hina Temple ngcimcaiki pi mtüihkhehsaki ni” ami ti. ( ");
INSERT INTO dao_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Am acun ham üng Epheta ka Throphimah naki Pawluh naw mlüh k'uma a ceh hü püi hmu u se, templea k'uma cehpüikia pi ami ngaih.) ");
INSERT INTO dao_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mlüh üngka ami van üng ngthang hü lü, ngbäm lawki he naw, Pawluh man u lü, temple kpunga kaih lawki he naw, asäng üng ksawhe ami jah khaih law. ");
INSERT INTO dao_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pawluh hnim vaia ami bü ja, Jerusalema khyange naküt aktäa suksak lawki he tia ngthu cun Romah yekap ngvai säiha veia phaki. ");
INSERT INTO dao_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Acunüng, ani naw yekape ja yekap ngvaie jah cehpüi lü, ami veia dawng ktäi se; yekap ngvai säih ja yekape jah hmu u lü, Pawluh ami kpai cun ami hjaüh. ");
INSERT INTO dao_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yekap ngvai säih naw Pawluh law sih lü, manki naw, mthiyüi nghngih am jah khisak lü, ua kyaki, i pawh khawiki tia a kthäh. ");
INSERT INTO dao_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Khyange akce pyen u lü ngpyang u se, i ami pyen am ksing thei lü, Pawluh cun yekapea venaka ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Acunüng, khyange naw aktäa kutban na hlü u se thukcakia ceh u lü, yekape naw kawt u lü Pawluh cun ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Khyang naküt naw, “hnim ua” tia Pawluha hnua ngpyangkie. ");
INSERT INTO dao_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pawluh naw yekapea venaka ami luh law hlüpüi üng yekap ngvai säiha veia, “Na veia ngthu pyen lü ng’yah khai aw?” a ti. Acunüng, ani naw, “Krik ngthu pyen theiki aw? ti lü akthäh. ");
INSERT INTO dao_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nang ajana, yea ngthawn lü, khyang thawng kphyü ye vaia kpyawnga ja dawngpüikia Egypt khyanga am na kyaki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pawluh naw, “Kei cun Kilikih hne, Tasuh mlüha ngtüikia Judah khyanga ka kyaki, ka venaka mlüh pi sawxata am kya, mlüh ktung ni, na bä ni hina khyangea veia ngthu na pyensaka” a ti. ");
INSERT INTO dao_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Acunüng, yekap ngvai säih naw täng se, Pawluh naw khyak üng ngdüi lü, khyangea ngdümnak vaia a kut kha lü ami ngdüm law ja, Hebru ngthu am: ");
INSERT INTO dao_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ka püi Isarele aw, ka ngsungkhameinak vai na ngai ua” a ti. ");
INSERT INTO dao_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebru ngthu am, ami veia ngthu pyenki ti ami ksing ja, käh khihkheh law u se, acunüng, Pawluh naw, ");
INSERT INTO dao_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Kei cun Kilikih hne, Tasuh mlüha ngtüikia Judah khyanga ka kyaki, acunsepi, hina Jerusalema Kamaleilaha vei ngthei lü ka ngbang lawki, jah mjükphyüinakiea thume pi ka ngthei khawiki, tungawi üng nangmia mäiha Pamhnama phäha ka ktha na khawiki. ");
INSERT INTO dao_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Acunüng, nghnumi kpami ja man lü thawngim üng jah khyum lü, thihnak vaia acuna Bawipaa Mawnglam läkie cun ka jah mkhuimkha khawiki. ");
INSERT INTO dao_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ktaiyü ngvaie ja kawngcie naküt naw pi acuna ngthu cun cangki tia na ksing püikie, Damateta veki ka püi Judahe vei ami yuk ca pi ka yahki; acuna kyase acua cit lü, jah man lü Jerusalema jah cehpüi lü jah mkhuimkha khaia ka citki. ");
INSERT INTO dao_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Cit lü, Damateta pei ka pha law üng, mhnüp nglunga angxita khana ka akvai aktäa vaiki ka peia vai lawki. ");
INSERT INTO dao_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mdek üng ka kyuk üng, ka veia, “Sawluh, Sawluh, ise na na mkhuimkhaki ni?” tia kthai ka ngjak. ");
INSERT INTO dao_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Acunüng, kei naw, ‘Bawipa aw, nang u ni?’ ti lü ka msang be. Acunüng, ani naw, ‘Kei Nazaret Jesuh, na mkhuimkhaa ka kyaki’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Acunüng, ka püie naw akvai cun ami hmu te, na ngthuheipüikia kthai cun am ngjak u. ");
INSERT INTO dao_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Kei naw, ‘Bawipa aw i ka pawh khai?’ ka ti. Acunüng, Bawipa naw, ‘Tho law lü, Damateta cita, na pawh vai naküt cun ning mtheh khaie ni’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Acuna akvaia phäha ka mik mü se, ka püie naw ami kut am na kaih u lü, Damateta ka citki. ");
INSERT INTO dao_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Khyang mat Anani ngming naki, thum kcang na lü Judahe naw ami leisawng acua veki. ");
INSERT INTO dao_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ka veia law lü, ka peia ngdüi lawki naw, ‘Ka na Sawluh aw, mdei law be a ti. Acunüng, hmu law be ngüse ka teng kyet. ");
INSERT INTO dao_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ani naw, ‘Mi pupaea Pamhnam naw, a hlüei na ksing khaia, ngsungpyunki Mpya na hmu khaia, a ngthu na ngjak khaia, ning xü pängki ni; ");
INSERT INTO dao_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Na hmu ja na ngjaka ngthu cun khyang naküta veia ania phäh saksi khai. ");
INSERT INTO dao_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ise na ve sawxatki ni? Tho law lü, Baptican khana. A veia na ktaiyü üng na mkhyekatnake ja kpyawta kya khai’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jerusalema ka ceh be käna, temple k'uma ka ktaiyü k'um üng, mdangnak ka hmuhki, ");
INSERT INTO dao_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","mdangnak üng Bawipa naw, ‘Angxita Jerusalem üngka naw cita; ka ngthu na sang vai ahin üng am ning ngja hlü ve u’ a ti cun ka khamei yahki. ");
INSERT INTO dao_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Kei naw, ‘Bawipa aw, sinakok naküta jumeiki naküt thawngim üng ja khyum lü, ka jah kpai khawi ksingkie; ");
INSERT INTO dao_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","na saksi Stephena thisen ami hnim üng, kei pi a peia ngdüi hnga lü, a thih vai yüna lü, hnimki hea ami suisak ka na kpawmki’ ka ti. ");
INSERT INTO dao_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ani naw, ‘Cita, hin üngka naw athuknak, khyangmjükceea veia ning tüih veng’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Acuna ngthu a pyen veia khyange naw ngai u lü; acunüng, angsanga ngpyang u lü, “Ceh ta ua! Hnim ua, xüng khaia am daw ve” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ngpyang u lü, ami suisake jah sut u lü, jah kha u lü, mput khan da phuh u se; ");
INSERT INTO dao_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","acunüng, Romah yekap ngvai säih naw, Pawluh ise acukba ami pawh tia ksing hlü lü, “Yekapea venaka ceh u lü, kpai u lü ise Judahe acukba ngpyangkie ti cun kcet ua” ti lü a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Acunüng, khit u lü kpai u se, Pawluh naw, a peia ngdüikia yekap ngvai üng, “Romah khyang naki, am mkhyenak angsinga am ksing xa u lü nami kpai hin nglawiki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Acunüng, yekap ngvai naw, acun a ngjak ja, yekap ngvai säiha veia cit lü, “Na bi law cän ngaia, hin hin Romah khyanga kya ve” ti lü, a mtheh. ");
INSERT INTO dao_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Acunüng, yekap ngvai säih naw law lü, a veia, “Romah, khyanga na kyaki aw? Na mtheha” a ti. Acunüng, ani naw, “Ä, kei Romah khyang ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Acunüng, yekap ngvai säih naw, “Romah khyanga ka kyanak vaia ngui khawha ka peki ni” ti lü, msang se, acunüng, Pawluh naw, “Kei cun Romah khyanga ka ngtüi lawki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Acun ja kcet khaia bükie naw Pawluh cun angxita cehta u se; yekap ngvai säih naw pi, Romah khyang ni tia ksing lü, Romah khyang a khiha phäha aktäa kyühei lawki. ");
INSERT INTO dao_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","A ngawi üng, Judahe naw ise Pawluh ami hneng ti ksing hlü lü, yekap ngvai säih naw Pawluh cun xaki naw, ktaiyü ngvaie ja ngthumkhyahkie naküt jah ngbämsak lü, ani cun lawpüiki naw, ami hmaia a ngdüih lawsak. ");
INSERT INTO dao_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pawluh naw kawngci jah bük lü, “Ka püi Isarele, Tungawi cäpa Pamhnama hmaia ngcimcaihkia mlungmthin am ka xüngseiki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ktaiyü ngvai Anani naw a peia ngdüikie üng Pawluha mpyawng ami kbei vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Acunüng, Pawluh naw, “Nang abawk am hluka lung, Mhnam naw ni kbei khai; ngthumkhyah khaia ngawh lü, am kcang khaia thum pawh lü ami na kbei vaia na pyenki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","A peia kae naw, “Pamhnama ktaiyü ngvai na ksekhanaki aw?” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pawluh naw, “Ka püi Isarele aw, ktaiyü ngvaia akya am ksing veng; ‘Na khyang jah upki käh na ksekhanak vai’ tia Cangcim naw pyenki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pawluh naw, avang Sadukee, avang Pharisee tia ksing lü, “Ka püi Isarele aw, kei Pharisea ka kyaki, Pharisea cakpaa pi ka kyaki; khyangkthi tho be khai tia ka äpeia phäh, ahikba nami na kcetki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Cunüng, acuna ngthu a pyen law päng ja, Pharisee ja Sadukee ngcuh law u lü, ngtai lawki he. ");
INSERT INTO dao_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ami ngtainaka suilam cun, Sadukee naw, “Khyangkthia thawnak be am veki, khankhawngsä he, Ngmüimkhyae am veki” ti khawi u se; Pharisee naw, acuna lam kthum cun veki tia ami juma phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pharise da ka thum ksinge ngdüi law u lü, “Hina a katnak i am ksing ve üng; Ngmüimkhya naw pi kyase, khankhawngsä naw pi kyase, a ngthuheipüi üng pi, ia am kya?” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ngcuh law dämdäm u se, yekap ngvai säih naw, Pawluh man u lü, amte mtea ami pawh law vai kyühki naw, yekape veia cit u lü ami vei üngka naw yekapea venaka ami cehpüi vaia a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Acunüng, mthana Bawipa cun Pawluha peia ngdüi lü, “Käh cäi kawpi, ka ngthu Jerusalema na saksia mäiha Romaha pi na saksi khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Khawthai law lü Judah khyange, Pawluh am ami hnima küt üng i käh eiaw khaiea, ng'yüngce u lü vekie. ");
INSERT INTO dao_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Acukba ng'yüngce u lü ngkhämkie cun khyang kphyükipa kthaka nungkie. ");
INSERT INTO dao_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Acunee cun ktaiyü ngvaie ja ngvaiea veia cit u lü, “Pawluh am kami hnima küt üng i käh kami mdep khaia kami ng'yüngceki ni. ");
INSERT INTO dao_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Acunakyase, khaw ngawia, yekap ngvai säih naw Pawluh cun nangmia veia lawpüi lü, ngkhai ngai khaia nami kcet vaia mäiha, ngvaie am atänga yekap ngvai säiha veia kthäh ua, acun üng Pawluh hnim vai ami täng. Acunüng, Pawluh nami veia am a pha law ham üng keimi cun kami hnim khaia, ngtün päng ve üng” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Acunsepi, Pawluha a naa ca naw, lama ami na maha mawng cun ngja lü, yekapea venakaa va lutki naw, Pawluh am a va mtheh. ");
INSERT INTO dao_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pawluh naw, yekap ngvai mat khü lü, “Hina cawngpyang hin yekap ngvaisäiha veia cehpüia; i mä a pyen vai ve khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yekap ngvaia veia cehpüi lü, “Thawngim üng kyumkia Pawluh naw na khü lü, hina cawngpyang na veia ka lawpüi khaia, ana tüih law, na veia i mä a pyen vai ve ve” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Acunüng, yekap ngvai säih naw a kut üng man lü, akcea cehpüiki naw, “I na na mtheh hlüki?” ti lü a kthäh. ");
INSERT INTO dao_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ani naw “Judah ngvaie naw khaw ngawia Pawluh kawngcia na lawpüi vai ngjak'hlü ve u. Pawluha mawng cun ami naw aksing ngtea ksing hlükie hana ngsaih ve u, a ti.” ");
INSERT INTO dao_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Acunsepi, ami pyen käh jah na kcang na kawpi; khyang kphyükipa kthaka nungkie naw ani k'äih u lü ngthupkie ni, acune cun ani, am ami hnima küt üng i käh eiaw khaiea ng'yüngcekie ni; atuh na ja msangnak be vaia ngthu k'äihkie, ngtün u lü vekie ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Acunüng, yekap ngvaisäih naw cawngpyang cun tüih be lü, “Hina ngthu na na mtheh hin u pi käh ksingsak kawpi” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Yekap ngvai säih naw jung ngvai nghngih jah khü lü, “Tuh mü naji kaw üng, Ketarih khaw cäpa cit khaia yekap phyanghngih, ngsela ngcumki khyang khyühkip, kcei kawtki khyang phyanghngih ngsungcei u se ti lü” a jah mtheh. ");
INSERT INTO dao_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pe uk Felika veia phyawn lü pha khaia, Pawluha ngcumnak vaia ngsela ami pet vaia pi a jah mtheh sih. ");
INSERT INTO dao_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ngvai naw hikba ca yu lü; ");
INSERT INTO dao_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kalawdih Lusik aw ami leisawnga pe uk Felik naw ning hnukset ve. ");
INSERT INTO dao_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Hina khyang Judahe naw man u lü ami hnim law hlü ja, ami veia yekape jah ngkhahpüi lü ka citki, Romah khyang ni tiaa ksing lü ka yung law. ");
INSERT INTO dao_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Acunüng, ami mkatnaka suilam ksing hlü lü, ami kawngciea veia ka cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ami thum ia phäha ami mkat tia ka ksing, acunsepi ami mkatnak üng thihnak vai ja man u lü thawng üng khyum vaia anglawinak i am hmu veng. ");
INSERT INTO dao_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Judahe naw ami hnim vaia kham hükie ni tia khyang naw a na mtheh ja, na veia ka tüih law ni, mkatkie naw pi ami mkatnaka mawng na hmaia ami pyen vaia ngthu ka jah pet ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ngthu a jah peta mäiha yekape naw mthan nglunga Pawluh cun man u lü, Antipatariha ami cehpüi. ");
INSERT INTO dao_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","A ngawi üng, ngsela ngcumkie Pawluh am jah cehsak u lü, amimät cun yekapea venaka nghlat law bekie. ");
INSERT INTO dao_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ketarih ami pha law üng, ca cun pe uk Felik am pe u lü, Pawluh cun pi ami msum. ");
INSERT INTO dao_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pe uk naw a kheh law päng üng, Pawluha venaka khaw a kthäh. Acunüng, Kilikih khawa ka ni tia a ksing law ja, ");
INSERT INTO dao_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Ning mkatkie ami pha law käna, na mawng ka ning ngaih pet khai” a ti. Acunüng, Pawluh cun pe uka junga ami ngäng vaia ngthu a jah pet. ");
INSERT INTO dao_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Amhnüp mhma käna, ktaiyü ngvai säih Anani, ngvaie avang ja seihne Tetulah ngsut lawki he naw, Pawluha mawng cun pe uka veia ami pyen law. ");
INSERT INTO dao_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Acunüng, Pawluh cun khü u lü Tetulah naw mkat law lü, “Bawi kdaw säih aw, nanga phäha dim’yenak am kami vea phäh, kami pea phäh na jah thunghlai hin nanga jah cehcawn phäh ni. ");
INSERT INTO dao_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Angläta, a hawa pi jenak am kami veki cun nanga bänak ni. ");
INSERT INTO dao_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Acunsepi, na kcün khawvei am la hlü veng lüpi, na mlunga a nemnak am ka pyen cun na ngaih pet vaia ning nghui na veng. ");
INSERT INTO dao_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Hina khyang hin, Nazaret ami ti khyange üng ngvai bi lü, khawmdeka khana Judahe naküt jah suksaki kami ksingki. ");
INSERT INTO dao_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Pamhnama temple pi mtüihkhehsaki; acunakyase, kami man ni. ");
INSERT INTO dao_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Na thuma mäiha, a mawng mtai pet vaia kami tängki ni, acunsepi yekap ngvaisäih Lusika naw law lü, kami kut üngka asihlinga jah hut hlawk lü, amät kami mkatkie na veia law vaia ngthu a jah pet. ");
INSERT INTO dao_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Namät naw hina khyang kthäh lü, kami mkatnak naküt cun na ksing khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Acunüng, Judahe naw pi law u lü ahin hin kcangki ni” tia ami pyen sih. ");
INSERT INTO dao_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Pe uk naw Pawluh cun ngthu pyen khaia a kut säng se ta, Pawluh naw, “Nang kum khawvei hina khyangmjü lei jah mkhyah pe lü na veki tia ka ksinga phäha, aktäa jenak am kamäta ngsungkhameinak na hmaia ngthu ka pyen law khai. ");
INSERT INTO dao_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Jerusalema Pamhnam hjawkhah khaia ka cehnak atuh mhnüp xaleinghngih va law hamki tia namät naw na ksing khai. ");
INSERT INTO dao_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Temple k'uma pi, sinakoka pi, mlüha pi, upi ka ngcuhpüi, khyang ka ksük pi am na hmu u. ");
INSERT INTO dao_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Tukbäih pi, ami na mkatnak vai tuilam am mdan thei ve u. ");
INSERT INTO dao_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Acunsepi, hin hin na veia ka phyeh khai, Kami pupaea Mhnam kei naw ka hjawkhah Mawnglam cun am kcang ami ti ni. Sahmaea caupe jah Mosia thum üng ng’yuk nakütki pi ka jum hngaki. ");
INSERT INTO dao_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ka äpnak pi veki ta Pamhnam naw khyang naküt akdaw ja akse pi thihnak üngkhyüh jah mtho law be khai ni. ");
INSERT INTO dao_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Acuna phäha, Pamhnam veia ja nghngicima veia pi, ka mlungmthina käh mkhyemsawh vaia ka ktha naki. ");
INSERT INTO dao_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Acunüng, kum khawvei anghjawk käna ka khyangea ngui jah pet vai ja ngkengtainak pawh khaia ka lawki. ");
INSERT INTO dao_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ngcimngcaihnak pawi päng lü ahine ka jah pawh k'um üng amimi naw Templea na hmuhkie. Ka hlawnga khyange ja suksaknak pi am ve u. ");
INSERT INTO dao_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Acua, Asah üngka Judahe pi vekie, acune naw law u lü ka khana ami pyen vai a vea kyak üng, hin üng na hmaia ve u lü na mkat khaie sü. ");
INSERT INTO dao_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Am acunüng, hina khyange naw, kawngcia hmaia ka ngdüih üng, ka katnak ami hmuh khawia kyak üng atuh pyen u se, ");
INSERT INTO dao_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kawngcia hmaia ka pyen mata, ‘Khyangkthi tho be khai tia ka jumeia phäha na mkatei u lü tuhngawi nami hmaia ami na lawpüi ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Acunüng, Felik naw, Mawnglam cun ana ksing lawa kyase, “Yekap ngvai säih Lusika a pha law üng na mawng ka ning mkhyah pet khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pawluh cun a jah ngängsak vai ja, a püipawe naw pi law u lü ami mbeimbawk law vaia yekap ngvai am ngthu a pet. ");
INSERT INTO dao_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mhnüp khawveica anghjawk käna, Felik cun a khyu Dusilah, Judah nghnumi ngkhahpüi lü law beki naw, Pawluh ja khüsak lü, Khritaw Jesuh jumnaka ngthu cun ngaiki. ");
INSERT INTO dao_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pawluh naw, dawkyanaka ngthu, mät ja mät nängeinaka ngthu, ngthumkhyahnak ve law khaia ngthue a jah mtheh üng, Felik naw aktäa kyüh law lü, “Cit be maa, akcün a awng üng, ning khü law be kawm” a ti. ");
INSERT INTO dao_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pawluh naw ngui a pet vai a ngaihk’uheia kyase, khü lü a kthäha kyaki. ");
INSERT INTO dao_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Acunsepi, kum nghngih päih käna, Pocih Festuh naw Felik mthawng se; acunüng, Felik naw Judahea ksunga a ngminga daw vai ngai lü Pawluh cun thawngim üng a khyum hüt. ");
INSERT INTO dao_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festuh naw khaw a uk law, amhnüp thum käna Ketarih mlüh üngka naw Jerusalema citki. ");
INSERT INTO dao_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ktaiyü ngvaie ja Judah üng axüngvaie naw Pawluha mawng cun akse lama ami na mtheh. ");
INSERT INTO dao_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Jerusalem mlüh üngka naw a jah laksak vaia nghui na u lü, lama a na kham u lü ami hnim vaia ami bü. ");
INSERT INTO dao_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Acunsepi, Festuh naw, “Pawluh cun Ketariha thawngima, kei pi acua ka cit be khai. ");
INSERT INTO dao_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Acunakyase, nami mkhawnge Ketarih khawa Pawluh mkatei khaiea ka hlawnga cit hnga u se, kakia akya üng” ti lü, a jah msang. ");
INSERT INTO dao_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ami veia, mhnüp khyet, mhnüp xa hlawk a ve khap üng, Ketariha ju cit beki; acunüng, a ngawia ngthumkhyahnak üng ngaw lü, Pawluh ami lawpüi vaia ngthu a ja pet. ");
INSERT INTO dao_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Acunüng, ami lawpüi ja, Jerusalem üngka naw ju lawki hea Judahe cun a peia ngdüi u lü, a khana am cangkia mkatnak khawha ami pyen. A mkhyenak kcang cun am ami msuh thei. ");
INSERT INTO dao_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pawluh naw a cangnaka ngthu pyen lü, “Judahea thuma khana pi kyase, Pamhnama temple khana pi kyase, Romah Emperoa khana pi kyase, katnak ka pawh i am ve naw” a ti. ");
INSERT INTO dao_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Acunsepi Festuh naw, Judahea khana a ngminga kdaw vai ngja hlü lü, Pawluh üng “Jerusalema hang cit lü, acuia ka hmaia hina mawng mtai vai na ngaiki aw?” ti lü, a kthäh. ");
INSERT INTO dao_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pawluh naw, “Romah Emperoa ngthumkhyahnaka hmaia ka ngdüi hlüki ni; Judahea khana katnak i am pawh ni se, acun cun nang naw haw angsinga ksing ye lü. ");
INSERT INTO dao_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Thum lümkan lü, thihnak vaia katnak ka pawh üng ta ka thih vai pi am ma nawng; acunsepi, hinea ami na khyaknak aphung i am a ve üng, u süm naw ami veia käh na pe thei khai. Romah Emperoa veia ka ngdüi khai” a ti. ");
INSERT INTO dao_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festuh naw a ngthumkhyahpüie a ja ksük käna, “Romah Emperoa veia ngsut khaia bü veki, Emperoa veia na ngsut law mkyäi khai ni” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Angsawkca käna, sangpuxang Akipah ja Berani cun Ketarih Mlüha ngsut law ni lü, Festuh ani hnukset law. ");
INSERT INTO dao_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Acunüng, mhnüp khawvei acuia veki xawia kyase, Festuh naw Pawluha mawng cun sangpuxanga veia pyen lü, “Felik naw thawngim üng kyumki u aw yawk hüt se; ");
INSERT INTO dao_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalema ka ve hui üng, ktaiyü ngvaie ja Judah ngvaie naw a mawng na mtheh u lü, mkat vaia ami na nghuinak. ");
INSERT INTO dao_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Acunüng, kei naw ami veia, ‘Ami khyaka khyang ja khyakie ngkhyum u se, ami khyaknaka mawng üng cangnak am ami hmu hama küt üng, amät asungkhamei vai akcün am a yaha küt üng khyang u pi mkhuimkha vaia thum hin Romaha mi thuma am kyaki ni’ ti lü, ka ja msang. ");
INSERT INTO dao_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Acune hina khaw ami pha law ja, käh msawk lü, a ngawia ngthumkhyahnak üng ngaw ktäi lü, ani cun ka ja khüsak. ");
INSERT INTO dao_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Khyakie ami ngdüi law ja, ka ngaia mäi kunga, a khana a am dawkia mkhyenak i am pyen thei u. ");
INSERT INTO dao_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ami jumnaka thume ja Jesuh khyang mat thi pängki cen Pawluh naw, ‘Xüng beki ni’ tia pyen se, acuna phäha, a khana katnak veki tia ami khyak lawa kya hüki. ");
INSERT INTO dao_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Acunüng, kei naw acuna mäih cun ihawkba bi vai am ka ksingki naw, Jerusalema cit se, acuia a mawng mtai pet vai a ngai ja am a ngai ka kthäh sum. ");
INSERT INTO dao_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Acunsepi, Pawluh cun yekap am cit u lü hlüng säihkia sangpuxanga mtai pet vaia a nghuinak, acuna Romah Emperoa veia am ka tüih hama küt üng yekape am ka jah mtätsak” a ti. ");
INSERT INTO dao_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Akipah naw Festuha veia, “Kei haw acuna ngthu pyen ka ngai vai ka na ngai khawiki ni” a ti. Acunüng, Festuh naw, “Khawngawia pyen se ngai kaw pi.” ");
INSERT INTO dao_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Acukba, a ngawia, Akipah ja Berani cun hlüngtainak am law ni lü, yekap ngvaie ja mlüh üng khyang kyäp kyäpe am, ngthu pyennaka ima lut ni se; acunüng, Festuh naw Pawluh a ja lawsak. ");
INSERT INTO dao_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festuh naw, “Sangpuxang Akipah ja hin üng vekiea khyange aw, hina nami hmu hin, a mawngmaa phäha, Judahe naküt naw mkatei u lü, käh xüng ti khai tia, Jerusalem mlüha ja hin üngkae naw ka veia ami kthäh. ");
INSERT INTO dao_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Acunsepi, thihnak sen vaia i katnak am pawhki ti ka ksingki; acunüng, amät naw ngvaisäih sangpuxanga veia a ngsut vai ngaikia kyase, tüih vaia ka bü ni; ");
INSERT INTO dao_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","acunsepi, ania mawng Emperoa veia ka yuk vai am ksing veng. Acunakyase, nami hmaia ka lawpüi ni, sangpuxang Akipah nanga maa ka lawpüi ktunga kyaki ni, kthäh lü i yaw hleng yuk vai ka hmunak vaia. ");
INSERT INTO dao_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Khyang kyum, sangpuxang ngvaisäiha veia tüih u lü, a mawng ami khyaknak, käh ksingsak lek cun, am mawngkia ngai veng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Akipah naw Pawluh üng, “Na mäta phäh ngthu pyen lawa” a ti. Pawluh naw, a kut säng lü, a ngsungkhameinak pyen lawki; ");
INSERT INTO dao_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Sangpuxang Akipah aw, Judahe naw ami na khyaknak naküt üng, ka ngsungeinak ngthu tuhngawi na hmaia ka pyen khaia akyaka phäha, dawki ngai veng; ");
INSERT INTO dao_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Judahea thum ja ngcuhnak naküt aktäa ksingki. Na mlung msaü lü na na ngaih vaia ni nghui na veng. ");
INSERT INTO dao_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ka dik ham üng ihawkba ka ve khawiki ti cun Judah khyange avan naw na ksingkie. Akcüka kamäta pe ja Jerusalema ihawkba ka kcün ka sumei pi ksingkie. ");
INSERT INTO dao_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Judah jumnak thum üng aktäa ling lü, Pharisea ka kya khawi cän ajana na ksingkie, ami pyen vai ta saksi na u se. ");
INSERT INTO dao_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kami pupaea vei Pamhnam naw a jah peta khyütam äpeinaka phäha kei hia ka ngdüi law khaia na pawh ve u, ");
INSERT INTO dao_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","amhnüp amthan Pamhnam hjawkhah u lü kami khyange pasang xaleihngihe naw ami yahei vaia äpeikie. Ahina äpeinaka phäh Judahe naw na mkatei ve u ahlüng säih sangpuxang aw. ");
INSERT INTO dao_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Hin üng veki khyange naw ise Pamhnam naw khyangkthi mtho beki ti hin, am a nami jum thei ni? ");
INSERT INTO dao_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Kei naw pi Nazaret Jesuha ngming cawkei lü, ka pawh khawh naküt cun ka bikia ka na ngai law khawiki. ");
INSERT INTO dao_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ahin hin Jerusalema ka bilo khawiki. Ktaiyü ngvaiea veia bilawnak thei ana yah lü, Mhnama khyang khawhae thawngim üng ka ja khyum khawiki; ami jah hnim vai üng kei naw pi ami thih vaia ka täng khawiki. ");
INSERT INTO dao_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Sinakok k'uma jah mkhuimkha lü, ami jumeinak ami cehtak vai khawvei ka pawh khawiki. Aktäa ka mlung na uiawng se, pe kcea ka mlüha vekie pi ka jah mkhuimkha khaia ka cit hü khawiki. ");
INSERT INTO dao_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ahina phäh vaia Ktaiyü ngvaiea vei ana yah lü Damatet mlüha ka citki. ");
INSERT INTO dao_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Sangpuxang aw, ka ceh mhnüp nglunga kyaki, ka jah cehpüia khyange ja kei pei cu nghngi kthaka vaiki akvai cun khan üngkhyüh vai lawki ka hmuh. ");
INSERT INTO dao_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kami van mdek üng kyu u ngüse, Hebru am, ‘Sawluh, Sawluh, i vai na na mkhuimkhaki ni? Se naw a mahpaa kcung a leha mäiha i vai namät naw namät na pawhki ni?’ tia, kthai ka ngjak. ");
INSERT INTO dao_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘Bawipa aw, nang u ni?’ ka ti. Acunüng, Bawipa naw, ‘Kei Jesuh, na mkhuimkhaa ka kyaki. ");
INSERT INTO dao_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Acunsepi, tho law lü; na khaw am ngdüi lawa. Ka ning mpya vaia na veia tuhngawi ka ngdang lawki. Nang naw tungawi na hmu cun jah mtheh lü malama i ka ning mhnuh khai ti cun ka pyen khai. ");
INSERT INTO dao_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Isarel khyange naküt ja Khyangmjükceea kut üngka naw ka ning yung khai; ami mik na ja mdeisak khaia, ami veia ning tüih veng. ");
INSERT INTO dao_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ami mik jah mdeisak lü, nghmüp üngka naw akvaia na jah nghlatsak khaia khawyama johit üngka naw Mhnama veia ja nghlatsak lü, kei ami na jumeinak am ami mkhyekatnake jah mhläta lü Pamhnama xüe khyange am atänga hnün ami yah vaia ni’ a ti. ");
INSERT INTO dao_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Acunakyase, sangpuxang Akipah aw, khankhawa ka, ngdannak cun am kcanga veng. ");
INSERT INTO dao_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Akcüka Damatet ja Jerusalema kaea veia, Judah pe naküta kaea veia, khyangmjükcee veia pi, ngjutnaka nglawia bi bi u lü, ngjut u lü Pamhnama veia ami nghlat lawnak vaia, ka jah mthehki ni. ");
INSERT INTO dao_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ahina phäha ni, Judahe naw temple k'uma na man u lü, ami na hnim hlü. ");
INSERT INTO dao_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Acunsepi, Pamhnama na yungnaka phäha tuhngawi cäpa, hin üng adik ja akdämea veia ka saksi pyen veng. I pyen akcea am kya sahmae ja Mosi naw ami na pyen cun küm law khai ti cun ni ka jah ksinghüsak, ");
INSERT INTO dao_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Mesijah cun mkhuimkhanak khamei lü, thihnak üngka naw akcüka tho beki tia küikyannaka mawng cun khyangmjükcee jah Judahe veia ka sangki,” a ti. ");
INSERT INTO dao_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Acukba Pawluh naw a ngsungkhameinak pyen lü, Festuh angsanga ngpyang lü, “Pawluh aw, ang veki; na ngtheingkhawng khawha naw ning yusak ve” a ti. ");
INSERT INTO dao_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Acunsepi, Pawluh naw, “Akhlüngtai, Festuh aw, am ang veng; ngthu kcang ka pyenki ni. ");
INSERT INTO dao_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Sangpuxang Akipah aw! Hina ngthu avan na ksingkia kyase na veia ling lü ka pyen theiki. Hina mawng avan na süm khaia ka ngaiki. I pi thup vai am ve ti cun pi na ksingki. ");
INSERT INTO dao_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Sangpuxang Akipah aw, sahmaea na jah jumki aw? Na jumkia ka ksingki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Akipah naw Pawluh üng, “Asängca üng Khritjana ka thawn khaia na ngaiki aw?” a ti. ");
INSERT INTO dao_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pawluh naw, “Asänga pi kyase, khawveia pi kyase, nang däka am kyakia, tuhngawi ka pyen ngjaki naküt pi, keia kba ami ve law hnga vaia, mthiyüi am khun käh nikia, Pamhnama veia ka ktaiyüki ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Sangpuxang, pe uki, Berani ja ami peia ngawhkie ngdüi law u lü; ");
INSERT INTO dao_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","a jah cehtak käna, “Hina khyang hin hnim vai ja thawngim üng kyum vaia i pi am pawh” tia ngthähki he. ");
INSERT INTO dao_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Acunüng, Akipah naw Festuh üng, “Hina khyang naw Romah Emperoa veia a pha vaia am a ngtänga ta hlät vai sü” a ti. ");
INSERT INTO dao_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italia mlawng am ceh vai ami mkhyah law ja Pawluh ja thawng kyum avange cun Julijah ngmingnaki, Romah yekap üngka ngvai üng a jah mhjum, “Acun cun sangpuxang yekappä ngvai ami ti.” ");
INSERT INTO dao_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Adramutiha mlawng üngka naw, Asah hne üngka tui pei üngkhyüh ngtünei lü athuknaka kami ciki. Maketawnih hnea ka Aristakhas, Thesalonikah mlüh üngka kami hlawnga veki. ");
INSERT INTO dao_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Angawi üng, Sidon kami phaki. Julijah naw Pawluh mceh na lü a khyah, a püiea veia cit se a püie naw hlükawki ami pet vaia a cehsak. ");
INSERT INTO dao_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Acun üngka naw, tui üng kami cit beki, khawkhi naw akceha jah cehsak se, Kuparuh kyawn da kami citki. ");
INSERT INTO dao_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilikiha ja Pampuliha pei tui kami khe käna, Lukia hne, Muraha kami phaki. ");
INSERT INTO dao_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Acua yekap ngvai naw Aleksandria üngkhyüh Itali cit khai mlawng hmu lü; a jah ngcumsak. ");
INSERT INTO dao_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Mhnüp khawvei angpäicaa cit u lü akpäihnaka Kanidah mlüh kami phaki. Khawkhi am daw se, Karet kyawn cit lü Kep Salmonih ami ti khe lü kami citkie. ");
INSERT INTO dao_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Va thäihca u lü, Laseah mlüh üngkhyüh am thuki Sep Habar ami tia hnün anänga kami pha lawki. ");
INSERT INTO dao_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mhnüp khawvei sumei lü, mlawng am msu lü ceh vai a kyühksea phäha, Thawngnaka Mhnüp pi a khe päng. Pawluh naw jah mcäi lü, ");
INSERT INTO dao_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Khyange aw, atuh mlawng am mi cehta, mlawng ja khawhthem he ami khyüh päih däka am kya lü, mi xünnak pi khyük khaia hmu veng” a ti. ");
INSERT INTO dao_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Acunsepi, yekap ngvai naw Pawluha pyen am kcang na lü keptin ja mlawng maha pyen a jah kcangnak. ");
INSERT INTO dao_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Acuna tui kam cun khawksik khya üng venaka am daw se, cit be tü u lü, Phonenih pha vaia kami kthanaki, a thawn khawh ta acua khawksik khya kami sumei khai kami ngtängki. Phonenih tui pei cun Kareta ve lü, nghngi kyak ja cuma keh, nghngi kyak ja sipa keh da pi kyase ma na hüki. ");
INSERT INTO dao_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Khet da khawkhi nghäi ngtün lü khi law se, khyange naw ami ngaia kba thawn khaia ngai u lü, kpunnak yüi kaih lü Karet tui kam da citkie. ");
INSERT INTO dao_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Acunsepi, asäng üng, Püi Khawkhi ami tia khawkhi cun kyawn da aktäa khi lawki. ");
INSERT INTO dao_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Mlawng a cut law üng, mlawng naw khawkhi am näng se, kami ktha päih lü khawa a khinak da a jah ceh hüpüi. ");
INSERT INTO dao_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kaladeh ngming nakia kyawna kami ngtunjinnak vai kami hmuki. Mlawng käh a pyak vaia ngyan üng kami pawhki. ");
INSERT INTO dao_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Mlawng cun jän kaihca lü khäng khaia yüi am ami kphung. Acunüng Libya kawnga khana a ngtaih vai kyüh u lü, jih ja nemsak lü khawkhia a jah cehnak püia kami citki. ");
INSERT INTO dao_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Angawi üng khawkhikse khi law se, mlawng üngka phüie cun tui üng ami ja tawn. ");
INSERT INTO dao_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","A ngawi be tü üng, ami naw mlawng üngka phüie cun ami jah tawn be tü. ");
INSERT INTO dao_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Khaw mhnüp khawvei nghngi ja aisie pi käh ngdang lü khawkhi naw jah mnawk hü se, kami lät khai pi am kami ngai tiki. ");
INSERT INTO dao_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Khawvei ei kaa kami ve käna, Pawluh ami ksunga ngdüi lawki naw, “Khyange aw, asüa, ka pyen ngai u lü, Karet üngka naw käh mi lawa ta, ahikba pyaknak ja sungpyamnak am mi khamei khai sü. ");
INSERT INTO dao_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Acunsepi, atuh ning jah nghui na veng, ling u lü ve u, mlawng däk khyük lü, nami xünnak am khyük, a ti. ");
INSERT INTO dao_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Isetiakyaküng, tuh mthana, ka jumei ja ka hjawkhah, Pamhnama khankhawngsä mat ka veia law lü, ");
INSERT INTO dao_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Pawluh aw, käh cäia! Empero Sangpuxanga hmaia na ngdüi khai, Pamhnama dawkyanak naw na jah ngkhapkie sak cän jah mpyenei ve.’ ");
INSERT INTO dao_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Acunakyase, khyange aw, ling ua, a na mtheha mäiha kya khai tia Pamhnam ka jumki. ");
INSERT INTO dao_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Acunsepi, tui kam mat mata mi ngtaih khaie” a ti. ");
INSERT INTO dao_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Acunüng, mthan xaleikphyü üng, Adih Mpanglaituia khawkhikse naw a jah mnawk hü. Mthan nglunga yekape naw keimi cun kawng da kami ng’et lawki tia cam hü u lü ami ksing law. ");
INSERT INTO dao_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Acunüng, tuia a thuk cam tü se, lam mku lawkia ami ksing. Asäng nghjawk se ami cam be üng, lam xaleimhma law se ami ksing. ");
INSERT INTO dao_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Lung a suk vai kyühei u lü, mlawnga ngmei da mthimhjum phyü ju khya u lü, khawa thaih law hlah vaia kami ktaiyükie. ");
INSERT INTO dao_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mlawng mawngkie naw, mlawng cun centak vaia ngtäng u lü mlawnga ma mthimhjum khyakia ngsaih u lü mlawngca cun tui üng ami ju khyak. ");
INSERT INTO dao_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Acun ja, Pawluh naw yekap ngvai ja yekapea veia, “Mlawng mawngkie mlawnga khana am nami ve ta am lät uki” a ti. ");
INSERT INTO dao_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yekape naw, mlawngca khihnaka yüie cun, jah cap pat lü, mlawngca cun ami khyah. ");
INSERT INTO dao_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Khawthaih law hlü ja Pawluh naw, ami van naw ei ami ei vaia a jah nghuinak. “Tungawi, mhnüp xaleikphyü law pängki, i am ei u lü ei kaa nami veki. ");
INSERT INTO dao_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Acunakyase, ning jah nghui na veng, nami xün vaia i mä ei ua. Nami lusam matca pi am khyük khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Acun a pyen law päng üng, Pawluh naw muk lo lü, Pamhnama veia jenak mtheh lü khyangea hmaia; mu cun boki lü a ei. ");
INSERT INTO dao_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ami vana cäicingnak dim law lü ami ei pi ei law hngakie. ");
INSERT INTO dao_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Acuna khyange cun phya nghngih ja khyühkip ja khyuk mlawnga khana veki. ");
INSERT INTO dao_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Avan naw kami ei law käna, mlawng hang khaia kyung cun mpanglai üng kami jah tawn. ");
INSERT INTO dao_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Khawa thaih law üng, acuna kawng cun mlawng mawnge naw am ksing u, lüpi tuikam cun ksing u lü mlawng cun acua ngdüi khaia ami pawh vaia ngtün lawki he. ");
INSERT INTO dao_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Acunüng, mthimhjum ja mawngnak ami jah kunnak yüi cun ja mawi pat u lü, tui üng ami mcum. Acun kung üng, jih ja khihnaka yüie cun ja kphyawtkie naw, a ma lama jinu cun khawkhi naw a hmut vaia häi u lü tuikam da citkie. ");
INSERT INTO dao_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Acunsepi, mlawng naw mdih su se, mlawnga lu da cun ngtangei lawki, mlawnga ngmei da cun tuiyüi a kyan lawa phäha pyakeiki. ");
INSERT INTO dao_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Yekape naw thawng kyume cun tui jawh u lü ami cen vai kyühkie naw jah hnim vaia ami bü law. ");
INSERT INTO dao_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Acunsepi, yekap ngvai naw Pawluh a yun vai täng lü, acun ami hnim vaia ami tün cun a jah mkhyawh. Tui jawh theiki naküt cun tui üng kco u lü, kawng da ami jawh ma vaia, ");
INSERT INTO dao_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","avange cun, thing pheka khana, avang mlawnga mtimteea khana pek law khaiea a jah mtheh. Acunüng, kami van kawnga phyawn lü kami pek päihkie. ");
INSERT INTO dao_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tui pei cun akdima kami pek käna, khaw kawng cun Malitah ngming nakia kami ksing law. ");
INSERT INTO dao_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Khaw a lü, khaw sik se, acuna khyang jah mhlänakie. Khaw a lü khaw sik se, khawmahe naw mei tik u lü kami van jah na dokie. ");
INSERT INTO dao_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pawluh naw thing pawk mkhäm lü, mei am a tih üng ngling law se, kphyu lut lawki naw, a kut cui lü a ven law. ");
INSERT INTO dao_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Khyange naw, kphyu cun hmu u lü, “Hina khyang hin, khyang hnimkia kya kung ve, tui üng lät sepi, Phu sui beki naw a xüng vai am ti ve” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Acunsepi, Pawluh ia am thawn lü kphyu cun mei üng a khyak. ");
INSERT INTO dao_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Amimi naw cun, a pumsa hngawh ta ngphyüng law se, thi lü kyu law khaia ami ngai; acunüng pi khawvei ami k’ä ih käna ia pi am veki tia ami ksing üng, ami mlung nglat se, “mhnama kya ve” ami ti law. ");
INSERT INTO dao_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Acuna hnün peia, acuna lai ka nakia ngvai säih, Puhbalih ngming naki naw ja je na lü, mhnüp kthum a ja khinnak. ");
INSERT INTO dao_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Acua Puhbaliha pa mhnatei lü a khawn pi msawi se a ihnaka veki. Pawluh a veia lut lü, a khana a kut mtaihki naw, ktaiyü pe se mya be. ");
INSERT INTO dao_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Acukba a thawn law ja, acuna kyawn üngka khyange am myaki law u se a jah mdaw be. ");
INSERT INTO dao_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Acunee naw, aktäa letsawng ami jah pet; mlawnga khana kami hlükaw naküt cun ami jah pet. ");
INSERT INTO dao_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Khya kthum Aleksandria mlüh üngkhyüh mlawng “Mhnam Ngphi” ngming naki am kami ceh käna, khawsik khyaa kyase Malta kami awmki. ");
INSERT INTO dao_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sarakuh mlüha pha u lü, acua mhnüp kthum kami awmki. ");
INSERT INTO dao_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Acuna mlüh üngka naw cit u lü Rekon mlüh kami phaki. Angawi üng, cum khawkhi law se, mhnüp nghngihnak üng Pawtajolih mlüh kami phaki. ");
INSERT INTO dao_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Acua jumeikie jah hmu u lü, ami veia mhnüp khyüh kami ve khaw ami jah nghuinak. Acukba cu Romah mlüh da kami lawki. ");
INSERT INTO dao_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romaha veki jumeikie naw kami mawng ksing u se, acun üngka naw, Apijah jawihtuknaka hnüna khyüh thukia law u lü, khina kainak hnün kthuma venak cäpa jah na do lawki he. Pawluh naw jah hmu se Pamhnam je na lü a ktha ve lawki. ");
INSERT INTO dao_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romaha kami pha üng, Pawluh cun yekap mat naw k'äih lü amät ami vesak. ");
INSERT INTO dao_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Amhnüp kthum käna Pawluh naw, ngnama Judah ngvaie cun jah khü lü ngkhyumkie. Ami ngkhäm law üng Pawluh naw ami veia, “Ka püi Isarele aw, mi khyange ja mi pupaea thum am ka jah lümkanki, cunsepi, thawng üng na khyum u lü Jerusalem üngka naw Romahe kut üng ami na mhjum ni. ");
INSERT INTO dao_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romah khyange naw na kthäh u lü, thihnak vai hlawka ka bilawh i am hmu u se, ami na hlät be vai ami täng kyaw. ");
INSERT INTO dao_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Cunsepi, Judah khyange naw am täng u lü, Empero Sangpuxanga veia ka ngdang khaia amthuia ami na pawh. Ka khyange cun am jah mkatei veng. ");
INSERT INTO dao_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Acunakyase, nangmi ning ja hmu lü, nami veia ngthueipüi vaia ka ning jah khü ni. Isarele naw ami äpei khyanga phäh kei hin mthiyüi am ami khih ni” a ti. ");
INSERT INTO dao_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Amimi naw a veia, “Na mawngma Judah hne üngka naw ca am ami yahki, mi khyang u pi hia law lü na khana am dawki mawng cun pi am pyen law u. ");
INSERT INTO dao_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Acunsepi, na ngpüinak mawng cun hnün naküta khyange naw ksekhanakie kyase na cungaih cun keimi naw pi kami ngai hlükie ni” ami ti. ");
INSERT INTO dao_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Acunüng khaw mhnüp tamkie. Acuna mhnüp a pha law üng Pawluh venak ima khyang khawha lawki he. Angawi lam üngkhyü tünei lü mü vei cäpa Pamhnama khyawng pe cun Mosia Thum ja sahmaea yuknak üngka Jesuha mawng khe lü khyange cun a jah ksingsak vaia jah mthehki. ");
INSERT INTO dao_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Avang naw a ngthu pyen jum u se, avange naw am jum u. ");
INSERT INTO dao_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Acunüng, käh ngkhawt law u se, Pawluh naw ngthu mat a pyen käna cit bekie. A ngthu pyen cun hina kyaki; “Ngmüimkhya Ngcim naw sahma Hesajah üngkhyüh nami pupae veia a pyen hin ihlawka cangki ni, ");
INSERT INTO dao_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Hina khyangea veia cit lü va pyena, akcanga nami ngai khai, acunsepi a suilam am ksing u. Akcanga bükteng u lü pi, am hmuh thei u, ");
INSERT INTO dao_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","‘isetiakyaküng ami mlung nghmüp lü ami nghnga pi kdenkie lü ami mik pi kbawmkie. Acukba käh thawn lü ami mik naw hmu lü ami nghnga naw pi ngjak khai kyaw. Ami mlung pi ksing u lü kei da nglat law lü ka jah myasak khai ti lü Pamhnam naw a ti.” ");
INSERT INTO dao_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Acunakyase, Pamhnama küikyannaka ngthu cun Khyangmjükceea veia jah tha lü ami naw cungai khaie” akpäihnak a ti. ");
INSERT INTO dao_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Acuna ngthu a pyen päng ja, Judahe amimät naw ngcuh u lü cit bekie. ");
INSERT INTO dao_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pawluh cun kum nghngih acua amät im ngvat lü, a veia lawki he naküt cun akdawa jah dokhamki. ");
INSERT INTO dao_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pamhnama khyawngpe ja Bawia Jesuh Khritawa mawng cun lingnak am sangkhapki.");
INSERT INTO dao_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Jesuh Khritawa mpya ja ngsä vaia khü, Pamhnama thangkdaw sang khaia xüa Pawluh üngkhyüh ni. ");
INSERT INTO dao_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Cangcim üng ang’yuka kba thangkdaw cun ajana Pamhnam naw sahmae veia khyütam a jah peta kyaki. ");
INSERT INTO dao_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Pumsa lama Davita mjü üngkhyüh hmi lawki, a capa, ");
INSERT INTO dao_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","mi Bawipa Jesuh Khritawa mawng, thihnak üngkhyüh a thawhnak be cun naw a johit dämduhki Pamhnama Cakpa üngka ngcimcaihnak mdanki. ");
INSERT INTO dao_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ani üngka Pamhnam naw kei cun Jesuha phäha ngsäa kya lü khyangmjü avan naw jum lü kcangnak vaia lam jah msüm khaia kcün kdaw a na peta kyaki. ");
INSERT INTO dao_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ahin cun nangmi Romahe Pamhnam naw Jesuh Khritaw üng a ning jah ka vaia a ning jah khüa kyaki ni. ");
INSERT INTO dao_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Romah mlüh üng Pa Pamhnama mhläkphyanak ja, ngcimcaih khaia jah khüe naküta veia: ");
INSERT INTO dao_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nami jumnak khawmdek avan üng ngthang hükia kyase, nangmia phäha, Jesuh Khritawa ngming üng akcüka, Pamhnam ka jenaki. ");
INSERT INTO dao_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nami phäha angläta ka ktaiyüki, a Cakpaa thangkdaw sangkhap lü, a khut ka mlungkyawng avan am ka bi hin ka juma Pamhnam cun saksi ni. ");
INSERT INTO dao_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Pamhnam naw a hlükawei ta nami veia ka lawnak hlawt vaia ngläta ka ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Aktäa ning jah hmu hlü veng. Isetiakyaküng nami khängceknak vaia ngmüimkhya dawkyanak ka ning jah teyet hlüa phäh ni. ");
INSERT INTO dao_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ka ti hlü ta, nami jumnak ja ka jumnak am ngjuktha mi ngpetei vai ka ti hlünaka kyaki ni. ");
INSERT INTO dao_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ka püie, nami veia ka law vaia ka ngtün üngpi am ka law vaia na khamki veki ni. Khyangmjükcee ami ngthunghlaia kba, nangmi pi nami ngthunghlai vaia ka hlüeia kyaki. ");
INSERT INTO dao_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kei hin Krike ja khyang kceea pi kyase, khyang ngmawnge ja akthemea pi kyase; khyangmjü naküta phäha ka mta veki. ");
INSERT INTO dao_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Acunakyase, Romaha nami vekiea veia pi thangkdaw pyen khaia ka yüki ni. ");
INSERT INTO dao_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Thangkdaw cun Pamhnama johita kyase jumeikie naküta phäh küikyannaka kyaki tia ka üpeiki. Akcüka Judahe phäha kya lü, acunkäna khyangmjükceea phäha kyaki tia ksing lü thangkdaw cun kei naw am hmaisetei na veng. ");
INSERT INTO dao_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Thangkdaw cun ngdang lü ihawkba Pamhnam naw amät am jah ngsungpyunsaki ti cun jumeinak üng ni tüneinak üngkhyüh akpäihnak vei cäpa a kyak ve. Cangcim naw a pyena akba, “A jumnaka phäh Pamhnam naw a angsungpyunsaka khyang cun xüng khai.” ");
INSERT INTO dao_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ngthu kcang ksingnak vai jah sungkhamkie khyang ksee jah mkhyenakea phäh Pamhnama mlungsonak cun khankhaw üngkhyüh ngdang lawki. ");
INSERT INTO dao_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Isetiakyaküng, Pamhnam naw mkhyekatnak thungki, isetiakyaküng, amimi naw Pamhnam ami ksing vai jäki ni. Pamhnam amät kung naw a jäsak ni. ");
INSERT INTO dao_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Pamhnam naw khawmdek a tüipyan üng am hmuh theia a khyaihnak, angsäia johit ja Pamhnama a kyaknak cun a tüipyange üng ngsingteeiki ni. Acunakyase, acuna khyange naw ami lätnak vai am pyen thei u. ");
INSERT INTO dao_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Pamhnam ksing u lü pi am mhlünmtai u; jenak pi am pyen u; am ngtähkia cungai u se, ami mlungkyawng axawn cun nghmüp am beki. ");
INSERT INTO dao_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Akthemea ngaieikie cunsepi angkie, ");
INSERT INTO dao_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Am thi theikia Pamhnam cun am hjawhkhah u lü, Pamhnama nghnün üng thi theikia nghngicime, khae, khisae ja mcea ngvak hükiea mäih juktuh pyang u lü sawhkhahkie. ");
INSERT INTO dao_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Acunakyase, Pamhnam naw ami mlung hlüa aksekhyue ja ngkekhyakeinak cun mat ja mata khana bilawh vaia a jah pet. ");
INSERT INTO dao_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Pamhnama ngthu kcang cun hleihlaka nglatsak u lü, mhnünmcengki jum vaia hnün üng a mhnünmcenga ksai hjawkhah u lü mküimtokie. Mhnünmcengki cun angläta mküimto vai ni. Amen. ");
INSERT INTO dao_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Isetiakyaküng ahin ami bi cun Pamhnam naw ngkekhyakei phyakia hüipawmnak a jah peta phäha ni. Nghnumie naw pi nglawi khaia venak vaia ami ngtüipüi cun am nglawi khaia nglat lü vecawhnakie. ");
INSERT INTO dao_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Kpami he naw pi nghnumi nglawikia ami ihawm püi vai cun hawih u lü, am dawkia hüipawmnaka mlungmthin am kpami ja kpami am nglawi khaia ipawm u lü, acuna phäh mkhuimkhanak amimät naw amimäta khana pha law khaia bilokie. ");
INSERT INTO dao_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Acunüng, Pamhnam ami ksing vai am ngaikiea kyase, am nglawiki pawh khaiea, am dawkia mlungmthin ta khaiea, Pamhnam naw jah hawihin se, ");
INSERT INTO dao_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","am ngsungpyunnak, mkhyekatnak, kamvanak, ngneingnawng am dawnak naküt am be lawki he; khyang hnimnak, ngvawknak, hleihlaknak, am dawkia vecawhnak am be u lü; am dawkia khyang pyeneikie, ");
INSERT INTO dao_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","khyang am mpyeneikia khyange, Pamhnam hnengkia khyange, khyang mlungso, kyäp säihkia ngaikia khyange, awcahkia khyange, mkhyekatnak akthai mtüikia khyange, nupaa pyen am cungaikia khyange, ");
INSERT INTO dao_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","mät naw mät ksingnak am takia khyange, ami pyena kba am vekie, mhläkphyanak am ngtüipüikia khyange, mpyeneinak am takia khyanga kya lawki he; ");
INSERT INTO dao_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","acuna ngkhaw jah pawhmsahkie naküt cun, thi khai kunga kyaki ni tia Pamhnama thuma pyen cun ksingkie. Amimät däka am kyase, khyang kce acukba pawhmsah khawikiea khana pi aktäa jekie. ");
INSERT INTO dao_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ka püi aw, khyang kce ngthu na mkhyahki aw. Aua na kyak üngpi, na pyen vai i am ve. Khyang kcea lei na mkhyah üng ami bilawh akba bi hnga lü na mät naw na mät pi na mkateiki. ");
INSERT INTO dao_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Acukba vekiea khana, Pamhnama ngthumkhyahnak cun ngthu kcanga kyaki tia mi ksingki. ");
INSERT INTO dao_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ka püi aw, acukba vekie na jah mkhyah peki, namät pi acun kba na ve hngakia kyase, Pamhnama ngthumkhyahnak üng na lät khaia na ngaiki aw. ");
INSERT INTO dao_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Am ani üng Pamhnama dämduhkia mpyeneinak ja cuneinak ja mlungsaünak cun am hnaläüeiki. Pamhnam cun dawki tia akcanga na ksingki, isetiakyaküng, ngjutnak na yah be khaia lam ni msümki ni. ");
INSERT INTO dao_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Na mlung ngcang lü pyen nami mhlihki acunakyase Pamhnam mlungsonak ja ngsungpyunki ngthumkhyahnaka Mhnüp üng däm bawk khaia nami bilawh cun naw mdan law khai. ");
INSERT INTO dao_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Khyang avan mi bilawh akba Pamhnam naw jah thung be khai. ");
INSERT INTO dao_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Akdaw pawh lü, hlüngtainak, mhlünmtainak ja, am thi theikia xünak suikie am, acune üng Pamhnam naw anglät xünak ja pe khai. ");
INSERT INTO dao_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Am dawki ami läknak vaia, cangki mah u lü, amimäta dawnak suikiea khana Pamhnama mlungsonak pha lawki. ");
INSERT INTO dao_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mkhyekatnak pawhkiea khana khuikhanak ja msawhleinak ve law khai, akcüka Judahe, cun päng lü khyangmjükcee khana pha law khai. ");
INSERT INTO dao_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Cunsepi, Pamhnam naw akdaw pawhmsahkie naküta khana hlüngtainak, mhlünmtainak ja dim’yenak jah pe khai, akcüka Judahe üng jah pe lü acun käna, khyangmjükcee üng jah pe khai. ");
INSERT INTO dao_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Isetiakyaküng, Pamhnam naw khyang avana khana angteha ngthumkhyah khai. ");
INSERT INTO dao_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Khyangmjükcee naw Mosia thum am ta u, amimi cun thum kaa mkhyekat u lü khyükie. Judahe cun thum takie, ami mkhyekatnak cun thum am ngthumkhyah khamei khaie. ");
INSERT INTO dao_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Thum ngjaknak sawxat am Pamhnam üng ngsungpyun bea am kya lü Thuma hlüei bilawhnak üng ni a kya. ");
INSERT INTO dao_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Khyangmjükcee naw Thum am ta u, amimäta ngaiha thum ami läk üng, Thum am ksing u lüpi amimäta ngaihnak ami läka kyase, acun cun ami phäha thuma kyaki. ");
INSERT INTO dao_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ami mlung k'uma thum veki ti cun ami ngneingnawng naw mdanki. Amimäta ksingnak naw kcangki tia mdan lü ami cungaihnak naw ahüt üng jah mkatei lü ahüt üng jah mhlätki. ");
INSERT INTO dao_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Acuna Mhnüp üng, ka sanga Thangkdawa mäiha Pamhnam naw Jesuh khritaw am, khyange naw ampyua ami ngaihnake naküt cun ngthumkhyah law khai. ");
INSERT INTO dao_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Nangmi üng avang naw namimät naw Judah khyang tia nami ngsuieiki. Thuma khana ngdüi u lü Pamhnam üng nami awhcahkie. ");
INSERT INTO dao_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Pamhnam naw a ning pawh hlüsak na ksingki, akdaw xü vaia mawng Thum üng na ngthei pängki; ");
INSERT INTO dao_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","amikmüe jah ngkhahpüi lü nghmüp üng vekiea phäha akvaia na kyaki. ");
INSERT INTO dao_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Anghmawnge ja akxawie jah mtheikia na kyaki. Nang cun Thum ksingnak ja ngthungtak ksingnak na taki tia ngsingki. ");
INSERT INTO dao_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Khyang kce na mtheiki naw ise namät am na ngtheiki ni. Khyanga ka mpyuk am daw tia pyen lü, namät na mpyuki aw. ");
INSERT INTO dao_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Khyanga khyu käh bäühmanak vai ti lü namät naw na jah bäühma na hüki aw. Juktuh he jah msetei lü, temple k'uma na mpyueiki aw. ");
INSERT INTO dao_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Pamhnama Thum ka taki ti lü awcah na lü, thum lümkan lü, Pamhnama thang na setsaki aw. ");
INSERT INTO dao_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Cangcim üng a ng’yuka kba, “Nangmi Judahe ning jah hmu u lü Pamhnama ngming khyangmjükcee naw mseteikie.” ");
INSERT INTO dao_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Thum na läkia a kyaküng, vunmawih cun phumah lü thum am na läk üngta vun na mawih cun am mawih üng ni a täng be. ");
INSERT INTO dao_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Acunakyase, vun am mawiki khyangmjükce naw thum a läk üng vun am a mawih pi a mawiha Pamhnam naw am jah ngai khai aw. ");
INSERT INTO dao_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Acunüng, Thum am na läka phäha ca yu lü vun mawiki lüpi khyangmjükcee naw nangmi Judahe ning jah mkatei khaie, isetiakyaküng ami vun am mawi u lüpi Thum ami läka phäh kyaki. ");
INSERT INTO dao_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Akpung däka Judah khyanga kyanak cun Judah kcanga kyanaka am ni. Akpung däka vun mawihnak cun vun mawihnak kcanga am kya. ");
INSERT INTO dao_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Cunsepi, ak'uma Judah khyanga kyaki ni Judah kcanga a kya ve. Acunüng, vun mawih kcang cun, cayuk sawxata am kya lü, Judah kcang cun Ngmüimkhya am mlung mawiha kyaki. Acun naw khyanga mhlünmtainak yahkia am kya lü Pamhnama mhlünmtainak yahkia kyaki ni. ");
INSERT INTO dao_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Judahe cun khyangmjükcee kthaka ami kyäpnak bawk veki aw? Vun mawih khameinak cun kü bawki aw? ");
INSERT INTO dao_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Akcanga anaküt üng akcüka Pamhnam naw amäta ngthu cun Judahe üng jah peki. ");
INSERT INTO dao_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Judah avangea am ami sitihnak naw Pamhnam cun am sitihkia thawnsak thei khai aw? ");
INSERT INTO dao_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Acun kba am ni; Khyang naküt hlei sepi Pamhnam cun cangki ni, “Na ngthu pyen cun cang lü, ngthumkhyah üng pi ngnängnak na yah khai” tia Cangcim naw pyenki. ");
INSERT INTO dao_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Cunsepi am dawkia mi pawhmsahnak naw Pamhnama pawhmsah naküt dawki tia a mdan üng, i mi ti thei khai ni? Pamhnam naw a jah ksücet üng Pamhnam naw akhye pawhki mi ti thei khai aw? (Ahin cun kthäh vaia nglawi kungki ni). ");
INSERT INTO dao_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Acukba am ani üng, Pamhnam am a cang üng ani naw ihawkba khawmdek ngthumkhyah pe khai ni? ");
INSERT INTO dao_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Cunsepi, am ka cangnak naw Pamhnama hlüngtainak cun akcanga mdanki ni. Ise kei khyangka mäiha mkateia ka kya khai ni? ");
INSERT INTO dao_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","“Akdaw a pha law vaia, mkhyekatnak mi pawh vai u” tia ise am mi ti ni? Khyang avang naw ami na mkateinak vaia ahine jah pyenkie ni. Ami yah vai kunga mkateinak yah khaie. ");
INSERT INTO dao_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Acunüng, mimi Judahe cun Khyangmjükce kthaka mi dawnak veki aw? Am ve. Judahe ja khyangmjükce avan cun mkhyekatnaka akea mi veki ti cun ka ning jah mhnuh päng ni. ");
INSERT INTO dao_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Cangcim naw a pyena kba “Upi am ngsungpyun, ");
INSERT INTO dao_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ksingnak taki ja Pamhnam mküimtoki matca pi am ve, ");
INSERT INTO dao_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","“Ami van naw Pamhnam nghlatakie, akcea ami van citkie; akdaw pawhki upi am ve, mat pi am ve. ");
INSERT INTO dao_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Ami khyü nglung he cun thihnak vaia kya lü; ami mleie am hleihlaknak ngthu pyenkie. Ami mkae üng kpyukpyaia sik am beki.” ");
INSERT INTO dao_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Ami pyenksake cun ng'yüncenak am beki.” ");
INSERT INTO dao_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Ami khawe cun khyang hnimnak da hlah u lü; ");
INSERT INTO dao_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ami cehnak naküt üng pyüpyehnak ja khuikhanake jah ta hütkie; ");
INSERT INTO dao_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","dim’yenaka lam pi am ksing u, ");
INSERT INTO dao_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Pamhnam pi am kyühei u.” ");
INSERT INTO dao_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Thum üng ve nakütki hin thuma keha vekiea phäha sängeikia tia mi ksingki; acunakyase, khawmdek khyange nghuingphanak käh jah mhlät lü lei naküt law püi lü Pamhnam naw avana lei cun ngthu jah mkhyah pet khaia kyaki. ");
INSERT INTO dao_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Acukba, thum cun mi mkhyekatnak ksingeinak vaia ve lawkia kyase, thum üng u süm pi Pamhnama hmaia am ngsungpyun hlawt khai. ");
INSERT INTO dao_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Tuhkbäih cun, Pamhnam naw amät am a jah ngsungpyunsak cun mdan pängki ni. Mosia Thum ja sahmae naw ami saksinak kyaw u lü pi Thuma bilawh vai am ve. ");
INSERT INTO dao_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Acun cun, Pamhnama ngsungpyunnak, Jesuh Khritaw jumnaka phäha kya lü, jumeikie avana phäha kyaki. Acunakyase, hngalangnak am ve: ");
INSERT INTO dao_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","khyang naküt mkhyekat lü Pamhnama hlüngtainak üngka naw thuk vaikie. ");
INSERT INTO dao_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Jah lätlangsaki Khritaw Jesuh üngkhyüh, aphu am pe xa lü Pamhnama bäkhäknak am avan naw ngsungpyunnak yaha kyaki. ");
INSERT INTO dao_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Pamhnam naw ani cun a jah pet. Ani mi jumeinak üng a thisena phäha ami mkhyekatnak mhlätnak vaia kyaki. Ahlana ami mkhyekatnake cun mlungsaünak am jah büktengki cunsepi atuh cun amäta ngsungpyunnak a mdannak vaia khyangea mkhyekatnak jah cijang petki. Ahikba a pawhnak am Pamhnam naw amät ngsungpyunnak mdan lü, Jesuh Khritaw jumki naküt cun pi ngsungpyunsaki ni. ");
INSERT INTO dao_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Acukba akya üng, mi awhcahnak vai ve khai aw? Am ve! Thum mi läk lü aw? Am ni. Jumnak üng ni akyak ve. ");
INSERT INTO dao_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Acunakyase, khyang cun jumnak am ngsungpyun lü thuma ngjak'hlü bilawhnaka phäha am ni. ");
INSERT INTO dao_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Am ani üng Pamhnam cun Judahe däka Pamhnama kyaki aw? Khyangmjükceea Pamhnama pi am kyaki aw? Kyaki, khyangmjükceea Pamhnama pi kyaki. ");
INSERT INTO dao_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Pamhnam mat däk kya lü, Judahe cun ami jumnaka phäha amät am jah ngsungpyunsak lü Khyangmjükcee cun ami jumnak üngkhyüh jah ngsungpyunsaki. ");
INSERT INTO dao_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Acunakyaküng, jumeinaka phäha Thum mi hawihki aw? Am mi hawih, mi khängsaki ni. ");
INSERT INTO dao_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Acunakyaküng, Abraham mi pupa, mi ti hin ihawkba mi ti khai ni? Abrahama pawhmsah khawi ta i ni? ");
INSERT INTO dao_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abraham naw bilawhnak am ngsungpyunnak a yah vaisü üng, a awhcahnak vai sü, cunsepi Pamhnama hmaia ta acukba am ni. ");
INSERT INTO dao_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Cangcim naw a pyen ta “Abraham naw Pamhnam jum lü, acuna a jumnak cun Pamhnam naw ngsungpyunnaka a ngaih pet.” ");
INSERT INTO dao_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Khyang naw khut a bi üng, a bia phu cun amdanga a yaha am kya, hlawh lü a yaha kyaki. ");
INSERT INTO dao_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Cunsepi, bilawhnak üng am ni lü jumnak am ngdüi lü Pamhnam jumkia mkhyekatnak cun ngcimki tia a ngaih pet. Isetiakyaküng Pamhnam naw acuna jumnak cun amät am jah ngsungpyunsaki tia Pamhnam naw a ngaih ni. ");
INSERT INTO dao_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ahin hin, Davit naw khyanga bilawhnaka phäha am ni lü, Pamhnam naw ngsungpyunkia a jah ngaih pete cun jodaw ve, ");
INSERT INTO dao_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Ami mkhyenak jah mhlät peta khyange ja ami katnak jah bu pete ta jekyai u se! ");
INSERT INTO dao_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Bawipa naw ami mkhyekatnak am a jah kheh petea khyange cun jekyai u se” tia a pyen ni. ");
INSERT INTO dao_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Davita pyen jekyainak cun vun mawih khamkiea phäh däka mä akya? Am kya! Vun am mawikiea phäha pi kyaki ni. Cangcim üngka mi pyena kba, “Abraham naw Pamhnam jumei lü a jumnak cun ngsungpyunkia a doei pet.” ");
INSERT INTO dao_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Acun cun ihawkba a ngaih pet ni? Vun a mawi käna aw? Am a mawih ham üng aw? Vun a mawih käna am ni, a mawih hlana kyaki. ");
INSERT INTO dao_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Acunakyase, vun am a mawih ham üng a jumnak am ngsungpyunnak yahki tia ksingnak vaia, vun mawi lü msingnak pawhki. Acuna ngsungpyunnak cun ami phäha kya khaia, vun am mawikie üng jumeikie naküta paa kyanak thei vaia ni. ");
INSERT INTO dao_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ani cun vun mawikiea paa pi a kyanak sih vaia, vun mawikie cun pi mi pa Abraham naw vun am mawi lü a xün k'um üng jumnak a taka mäiha jumnak ami tak vaia ni. ");
INSERT INTO dao_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abraham ja a mjükphyüie naw khawmdek ami kanak vaia khyütam cun Thum a läklama phäh am ni, ani naw jum lü a jumnak cun ngsungpyunnaka a doei pet ni. ");
INSERT INTO dao_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Thum läkie üng Pamhnam naw khyütam a jah pet ta jumnak cun am mdanga kya lü Pamhnama khyütam pi am mdang vai ni. ");
INSERT INTO dao_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Thum naw Pamhnama mlungsonak lawpüiki; cunsepi thuma am a ve üng thum lümkan am ve. ");
INSERT INTO dao_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Acunakyase, khyütam cun jumnak üng kya lü Pamhnam naw Abrahama mjükphyüie amdanga a jah pet cun Thum läk sawxatki üng am kya lü Abrahama juma kba jumeikie a jah pet ni. Abraham cun ngmüimkhya lama avana mi pa vaia phäh ni. ");
INSERT INTO dao_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Cangcim naw, “Khyangmjü khawkäna paa ka ning pyang päng ni” tia a pyena kba ni. Khyütam cun Abrahama jum Pamhnama ma daw lü acuna Pamhnam naw thikie jah xünsak lü, am vekie pi ve khaia pawhki ni. ");
INSERT INTO dao_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abraham naw äpei vaia anglawiki äpei lü jumnak am “ani cun khyangmjü khawhaha paa” thawn lawki. Cangcim naw, “Na mjükphyüie cun aisi kän law khaie” tia pyenki. ");
INSERT INTO dao_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","A khawkum a phya law khyäü khaia a mtisa xü lü a yängsänak am ve sepi, a jumnak am ngcek law. Sarah pi am ca khawh ti. ");
INSERT INTO dao_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","A jumnak am khyah, Pamhnama khyütam pi jumeiki. A jumnak cun johit üng be lü Pamhnam mhlünmtaiki. ");
INSERT INTO dao_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Pamhnam naw khyütam cun kümkawi lawsak thei khai tia süm lü a jumnak khäng law bawki. ");
INSERT INTO dao_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Acunakyase Abraham cun a jumnak üng ngsungpyunkia Pamhnam naw ngaih petki. ");
INSERT INTO dao_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Acunakyase, “A jumnak cun a ngsungpyunnaka ngaiha kyaki” ti cun, amäta phäh däka yuka am kya lü, ");
INSERT INTO dao_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","mimia phäha pi kyaki. Mi Bawipa Jesuh, kthihnak üngkhyüh mtho beki mi jumkia kyase, mi jumnak cun ngsungpyunnaka ngai vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Acuna Jesuh cun, mi mkhyekatnaka phäha thikia kya lü, Pamhnam am mi ngsungpyunnak vaia phäh mthawh bea kyaki ni. ");
INSERT INTO dao_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Atuha, jumnaka phäh Pamhnam am ngsungpyunnak mi yahki, Bawi Jesuh Khritaw üngkhyüh Pamhnam am dim’yenak mi taki. ");
INSERT INTO dao_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Atuha mi xünnaka jumnak üng Pamhnama bäkhäknak mi ksing khaia jah law püiki. Pamhnama hlüngtainak yümei lü äpeinak am mi awhcahki. ");
INSERT INTO dao_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Acunüng, acun däka am kyase, mi khuikhanak üng je u lü mi ve vai u, khuikhanak naw khameinak khawh lawpüiki, ");
INSERT INTO dao_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","khameinak khawh naw Pamhnama ksingnak lawpüi lü Pamhnama ksingnak naw äpeinak ve lawsaki; ");
INSERT INTO dao_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","acunüng, mi veia a jah peta Ngmüimkhya Ngcim naw, Pamhnama mhläkphyanak cun, mi mlungkyawng k'uma a büih law pänga phäha, äpeinak naw am jah helatsak khai. ");
INSERT INTO dao_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Jah kpüi khai am a ve üng pi Pamhnama xüa kcün üng Khritaw cun mkhyeki khyange phäha thi lawki. ");
INSERT INTO dao_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Khyang ngsungpyunkia phäha thih vai khak khai, khyang kdawa phäha ta a thih vai lingki ve taw khai. ");
INSERT INTO dao_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mkhyekatnak am mi ve k'um üng, Khritaw mi phäha a thihnak am, Pamhnam naw ihlawka a jah mhläkphyanak cun mdanki. ");
INSERT INTO dao_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Acunakyase, tuhkbäih cun, a thisena phäha ngsungpyunnak mi yah lü, acuna Bawipaa phäha, Pamhnama mlungsonak üngka naw ihlawka küikyannak mi yah khai ni. ");
INSERT INTO dao_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Pamhnama yea mi kya k'um üng pi, a Cakpaa a thihnaka phäh Pamhnama püia mi kya law beki. Tuhbäih ta Pamhnama püia mi kyakia kyase Khritawa xünnak am ihlawka küikyannak mi yah khai. ");
INSERT INTO dao_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Acun däka am kyase, tuhkbäih mi Bawipa Jesuh khritaw üng Pamhnam püiea jah pyangkia kyase mi jekyaiki. ");
INSERT INTO dao_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Acunüng, khyang mata phäha khawmdeka khana mkhyekatnak pha law lü, mkhyekatnaka phäh thihnak a pha lawa mäiha, khyang naküt cun mkhyekatnaka phäha thihnaka phakie, isetiakyaküng khyang avan ami mkhyekata phäh ni. ");
INSERT INTO dao_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Thum am a ve ham üng khawmdek khana mkhyekatnak ve pängki. Cunsepi Thum am a ve üng mkhyekatnake am ve u. ");
INSERT INTO dao_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Cunsepi, Adam üng tün lü Mosia ve law cäpa, Adam naw Pamhnama mtheh am ngja lü a mkhyekata mäiha mkhyekatnak am pawhkiea khana pi thihnak ve lawki. Adam cun ve law khai üng mtängnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Cunsepi, bäkhäknak ja mkhyekatnak am täng. Isetiakyaküng, Pamhnama bäkhäknak cun Adama mkhyekatnak am, am täng. Khyang mata mkhyekata phäha khyang khawhah thiki. Cunsepi, khyang mat Jesuh Khritawa phäha khyang khawhah naw Pamhnam naw amdanga a jah yeta bäkhäknak yahkiea kyase Pamhnama bäkhäknak cun dämduh bawki ni. ");
INSERT INTO dao_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Khyang mata mkhyekatnak ja Pamhnam naw amdanga a jah yet cun am täng ni. Khyang mat a mkhye käna “Mkhyekatnaka” ngthumkhyahnak pha lawki. Cunsepi mkhyenak khawhaha ve law käna “Mkhyekatnak am pawhkia kba” am yah ngkawiha bäkhäknak cun yahki ni. ");
INSERT INTO dao_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Mata mkhyekatnaka phäha pi thihnak naw a jah uk law üng, khyang mat, Jesuh Khritaw bilawha phäh ihlawk dämduhki mi yah khai ni. A bäkhäknak khawhaha yahei lü Khritaw üngkhyüh akxüng mi up lü ani am ngsungpyunsak yahei khaie ni. ");
INSERT INTO dao_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Acunakyase, mata mkhyenak naw khyang naküt jah mkateiki. Acuna mäiha khyang mata ngsungpyunnak naw ngsungpyunnak ja xünnaka khyang naküt jah phapüiki. ");
INSERT INTO dao_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Khyang mat naw pyen am a ngjaka phäha khyang naküt mkhyekatnak am belawki he; acuna mäiha, khyang mat naw pyen a ngjak phäha khyang naküt ngsungpyun khaie. ");
INSERT INTO dao_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Thum pha law lü mkhyekatnak nung lawki. Cunsepi, mkhyekatnak a nungnak naküta Pamhnama bäkhäknak däm law bawki. ");
INSERT INTO dao_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Mkhyekatnak naw thihnak am jah uk lü Pamhnama bäkhäknak naw ngsungpyunnak am uk lü mi Bawipa Jesuh khritaw üngka naw anglät xünnaka jah cehpüiki. ");
INSERT INTO dao_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Acunüng, i mi pyen khai? A bäkhäknaka dämnak vaia mkhyekatnak üng mi xüngei laih laih khai aw? ");
INSERT INTO dao_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Acun kba am ni, mkhyekatnak üng mi thi pängki cun mkhyekatnak üng ihawkba mi xüng be khai? ");
INSERT INTO dao_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Khritaw Jesuh üng baptican khankie naküt cun a thihnak üng baptican khanki tia am nami ksingki aw? ");
INSERT INTO dao_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Acunakyase, a thihnak üng baptican mi khan üng a hlawnga mi ng’ut yümki; Pa a hlüngtainak am thihnak üngka naw Khritawa thawh bea kba mimi pi xüngnak kthai am mi ve hnga khai. ");
INSERT INTO dao_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Baptican mi khamnak am a thihnak üng mi thih hnga u lü xünnak üng a mät am atänga mi tho be yüm khai. ");
INSERT INTO dao_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Mkhyekatnak mtisa kpyehnak vai ja, mkhyekatnaka mpyaa am mi kyanak ti vaia mi khyang kphyüm cun amät am kutlamktung üng taih pänga kyaki tia mi ksingki. ");
INSERT INTO dao_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","A u pi, thih pängki cun mkhyekatnak üngka naw lätki ni. ");
INSERT INTO dao_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Acunüng, Khritawa am mi thi pängkia akya üng a hlawnga mi xüng hnga khai tia mi jumki. ");
INSERT INTO dao_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Khritaw cun, thihnak üngka naw mthawh bea kyaki, am thi be ti khai ti mi ksingki; thihnak naw a khana ngnängnak johit am ta ti. ");
INSERT INTO dao_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","A thihnak cun mkhyekatnak lama anglät vaia mat däka thiki, a xüngnak üng Pamhnama phäha xüngki. ");
INSERT INTO dao_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Acun kba bä, nangmi haw mkhyekatnak lama thi pängkia ngaiei u lü, Pamhnam da Jesuh khritaw üng nami xüngkia ngai kyu ua. ");
INSERT INTO dao_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Acunakyase, thi theikia nami mtisaa ngjak'hlü nami pawh msawk üngpi mkhyekatnak naw nami mtisa üng nängnak käh yah kawm. ");
INSERT INTO dao_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Nami mtisa, kutkhawe cun nami mkhyekatnak vaia akse lama käh jah sumei ua; thihnak üngka naw tho bekia mäiha, Pamhnama veia ngpeei u lü, nami mtisa, kutkhawe pi ngsungpyunnak vaia kya u se. ");
INSERT INTO dao_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Mkhyekatnak cun nami bawia käh kyase, thuma keha nami xüngki am ni, Pamhnama bäkhäknaka keha nami xüngki ni. ");
INSERT INTO dao_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Acunüng ihawkba kya khai? Thuma keha am mi ve ti lü a bäkhäknak keha mi vekia kyase mkhyekatnak mi pawh khai aw? Acukba am kya. ");
INSERT INTO dao_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ua veia pi kyase, a ngthu ngai khaia mpyaa nami kya käna, thihnak vaia katnaka mpyaa pi kyase, ngsungpyunnak vaia ngthu ngainaka mpyaea pi kyase, a ngthu nami ngaiha a mpyaa nami kyaki ti am nami ksingki aw? ");
INSERT INTO dao_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Pamhnam je na ua! Nangmi cun mkhyekatnaka mpyaea kya khawi uki lüpi ning jah mtheia ngthungtak cun nami mlung am nami kcangnaki. ");
INSERT INTO dao_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mkhyekatnak üngka naw nami lät pängkia kyase ngsungpyunnaka mpyaa nami kyaki. ");
INSERT INTO dao_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Am nami ksing theikia kyase nghngicima khyübe am ka ning jah mthehki. Nami mtisa ja nami kutkhawe cun ajana am ngcimcaihki ja phyawksak ksehlen khaia nami peta mäiha, tuhkbäih nami mtisa ja nami kutkhawe cun ngcimcaih khaia ngsungpyunnaka mpya thawnsak ua. ");
INSERT INTO dao_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Mkhyekatnaka mpya üng nami ve ham üng, ngsungpyunnak üng nami lätki. ");
INSERT INTO dao_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Atuha nami ngkeeinak nami jah bilawhe cun i nami daw na khawiki ni? Acunea dütnak cun thihnaka ni akya ve. ");
INSERT INTO dao_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Cunsepi, tuhkbäih cun mkhyekatnak üngka naw lät u lü Pamhnama mpyaea nami kya lawkia kyase, ngcimcaihnak nami ngmangnaki. Adütnak cun anglät xüngnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Mkhyekatnaka phu cun thihnaka kyaki cunsepi, Pamhnam naw amdang a jah yeta a bäkhäknak cun mi Bawipa Jesuh khritaw üng anglät xünaka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Acunakyase, ka püie aw, thum nami ksingkiea kyase i ka pyen khai ti cun nami ksingkie ni. Khyang a xünga küt üng thum naw upki. ");
INSERT INTO dao_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Avaisüa a cei vekia nghnumi cun a cei am a thiha küt üng thuma keha veki, a cei a thih käna cei mahnaka thum üng lätki. ");
INSERT INTO dao_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Acunakyase, a cei a xüng k'um üng kpami akce a vepüi üng ani cun a ceia khana am sitihki ti khaie. A cei a thih üng ta acuna thum üngka naw mhläta kyase, akce a ceinak be üng pi nghnumi “am sitihkia” am kya. ");
INSERT INTO dao_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Acunakyase, ka püie aw, Thum cun asängeia küt üng nangmi pi nami thiki, isetiakyaküng nangmi cun Khritawa kphyema nami kyaki. Nangmi cun thihnak üngka naw tho beki Jesuha mtisa kyase nangmi cun Pamhnama khut pawhnak üng ning jah summangei vai ni. ");
INSERT INTO dao_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Mtisa thuma mi xüngsei üng thum naw mtisa mkhyekatnak mthümhlet law se Thum naw mtisa üng khut bi lü avan thihnak üng mi dütki. ");
INSERT INTO dao_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Cunsepi, tuhkbäihta jah mankia Thum üngka naw mi lätki, isetiakyaküng, acun üng mimi cun mi thi pängkia akyaka phäha ni. Thum kphyüm üng yuka kba mi khüikia am kya lü, Ngmüimkhya thum kthai üng mi khüiki ni. ");
INSERT INTO dao_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Acunüng, Thum a mät kung hin mkhyekatnaka kyaki mi ti khai aw? Am ni! Cunsepi, Mkhyekatnak na ksingsaki cun Thum ni. “Khyanga ka käh na hnaihei vai,” tia Thum naw am a pyen üng ta acuna hnaiheinak ta ini tia am ksing veng. ");
INSERT INTO dao_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Cunsepi, mkhyekatnak naw ngthupet ngmangei na lü hnaiheinak naküt ka khana ve lawsaki. Thuma kaa mkhyekatnak akthi ni. ");
INSERT INTO dao_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kamät kung pi thuma kaa ka xüngki; cunsepi ngthupet a ve law ja, mkhyekatnak xüng lawki; ");
INSERT INTO dao_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Acunüng, kei ka thiki. Xünnak vaia ngthupet cun ka phäha thihnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Mkhyekatnak naw thum ngmangei na lü, na mhlei lü acuna thum am na hnimki. ");
INSERT INTO dao_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Acunakyase, Thum cun ngcimcaihki, acunüng ngthupet cun ngcimcaih lü ngsungpyun lü dawki. ");
INSERT INTO dao_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Akdaw pawh cun, ka phäha thihnaka kyaki aw? Am kya. Mkhyekatnak ni ka phäha thihnaka a kya ve; acunakyase, mkhyekatnak cun mkhyekatnak tia angdangnak thei vaia akdaw sumei lü na hnimki; mkhyekatnak cun ngthupeta phäha aktäa mkhyekatnak tia mdanki. ");
INSERT INTO dao_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Thum cun ngmüimkya lama kyaki tia mi ksingki; cunsepi, kei cun mtisa lama mkhyekatnaka mpyaa jawiha ka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ka pawh am ka ksingki; ka pawh hlü am pawh lü, acuna hnün üng am ka hlüei ka pawhki. ");
INSERT INTO dao_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Acukba am ka pawh hlü ka pawh üng Thum cun cangki tia ka jumki. ");
INSERT INTO dao_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Acunakyase, acuna am dawki ka pawh cun keia pawha am kya lü, mkhyekatnak kei üng vekia a pawha ni akya ve. ");
INSERT INTO dao_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Kei üng akdaw i am ve tia ka ksingki; acun hin mtisa lama kyaki, akdaw pawh hlünak cun kei üng ve teki, akdaw i am pawh ngü. ");
INSERT INTO dao_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Akdaw ka pawh hlü am pawh lü; acuna nghnün üng am ka pawh hlü akse ka pawhki. ");
INSERT INTO dao_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Am ka pawh hlü ka pawh khawi üng, pawhki cun keia am kya lü, mkhyekatnak kei üng vekia ni akya ve. ");
INSERT INTO dao_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Acunakyase, hina thum ka ksing lawki; akdaw pawh vai ka ti üng akse ni ka xüei ta. ");
INSERT INTO dao_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ka mlungkyawng kcang üng cun Pamhnama thum üng aktäa ka jeki. ");
INSERT INTO dao_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Cunsepi, ka mtisa ja ka kutkhawe üng thum kce veki tia ka ksingki, acun naw ka mlungkyawng thum ngcawhpüi lü, ka mtisa ja ka kutkhawe üng vekia mkhyekatnak ngthupeta kut üng mpyaa na pawhki. ");
INSERT INTO dao_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Khuikha veng! Thihnaka na cehpüiki hina mtisa üngkhyüh u naw na yung khai ni? ");
INSERT INTO dao_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mi Bawipa Jesuh Khritawa üngkhyüh ahin pawhkia Pamhnama veia jenak ka mthehki. Acunakyase, ka mlungmthin lama Pamhnama thuma mpyaa ka kyaki, mtisa lama mkhyekatnaka thuma mpyaa ka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Acunakyase, tuhkbäih Khritaw Jesuh üng vekiea phäha mkatnak am ve ti. ");
INSERT INTO dao_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ngmüimkhya thum naw Jesuh khritaw üngkhyüh lawki xünnak ning jah pe khai. Acuna xünnak naw mkhyekatnak ja thihnak üngkhyüh ning jah mhlät pängki. ");
INSERT INTO dao_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ktha ngcekia nghngicim kyase Thum naw am a pawh khawh cun Pamhnam naw a pawh ni. Pamhnam naw nghngicima mäiha amäta Cakpa Jesuh Khritaw tüih law lü ani cun mkhyemsawhki nghngicima mäia law lü mkhyekatnak cun nängeiki. ");
INSERT INTO dao_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Pamhnam naw a pawh hin ngsungpyunki ngjak'hlü Thum cun mimi üng kümkawi lü mimi Ngmüimkhya üng xüng. Acun hin nghngicima mtisa lama am kya. ");
INSERT INTO dao_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Pumsa thuma vekie naw mtisa lama ami mlung takie; Ngmüimkhya thuma vekie naw Ngmüimkhya lama ami mlung takie. ");
INSERT INTO dao_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Pumsa lama mlung tak cun thihnaka kyaki, Ngmüimkhya lama mlung tak cun xünnak ja dim’yenaka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Acunakyase, mtisa thum üng xün law üng Pamhnama yea kya lawki he. Pamhnam thum am läk u lü a läka pi am läk khawh u. ");
INSERT INTO dao_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Acunakyase, mtisa thuma vekie naw, Pamhnam am jesak thei u. ");
INSERT INTO dao_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Cunsepi, Pamhnama Ngmüimkhya nangmi üng ve kcangkia akya üng mtisa üng am ve u lü, Ngmüimkhya üng nami veki ni. Cunsepi, u pi Khritawa Ngmüimkhya am taki cun ania khyanga am kya. ");
INSERT INTO dao_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Cunsepi, Khritaw nangmi üng a ve üng, mkhyekatnaka phäha thi khai mtisa pi Pamhnam am nami ngsungpyunkia kyase Ngmüimkhya cun nami xüngnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Jesuh thihnak üngkhyüh mtho bekia Pamhnama Ngmüimkhya nangmi üng a ve ta, Khritaw thihnak üngkhyüh mtho beki nami k'uma veki ania Ngmüimkhya naw thi theikia nami mtisa üngpi xünnak ning jah pe khai. ");
INSERT INTO dao_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Acunakyase, ka püie aw, mi mta veki, lüpi mtisa thuma a hlüeia mi xün khaia am kya. ");
INSERT INTO dao_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Mtisa thuma nami ve üng nami thi khai; cunsepi, mtisa bilawhe cun Ngmüimkya am nami ja thihsak üng nami xüng khai. ");
INSERT INTO dao_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Pamhnama Ngmüimkya naw a jah khyüisawe cun Pamhnama caa kyakie. ");
INSERT INTO dao_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Pamhnam naw a ning jah peta Ngmüimkhya naw kyühnak ja mpya kyanak be am ning jah pe. Lüpi Ngmüimkhya naw Pamhnama ca thawnnak ja “ka Pa, ka Pa” ti lü ngkhünak vaia ngmüimkhyaa johit ning jah petki. ");
INSERT INTO dao_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Acuna Ngmüimkya Ngcim kung naw mi ngmüimkya üng Pamhnama caea mi kyaki ti cun jah ksingsaki; ");
INSERT INTO dao_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","A caea mi kyak üng a khyangea phäh a tak khawhthem mi yah khai. Pamhnam naw Khritaw üng a tak pet khawhthem pi mi yah khai isetiakyaküng Khritawa khuikhanak pi mi khameipüi lü a hlüngtainak pi mi yümeipüi khai. ");
INSERT INTO dao_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Tuhkbäih khuikhanake hin, malama hlüngtainak ngdang law khai üng am jah mtäng phyaki ni. ");
INSERT INTO dao_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","A mhnünmcenge naküt naw äpeinak am, Pamhnama caea ngdang lawnak vai k'äihkie. ");
INSERT INTO dao_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","A mhnünmcenge naw ami vecawh ning ami mkhyüh hin ami hlüeia am kya lüpi Pamhnam naw acukba a hlüeia kyaki. Lüpi äpeinak veki, ");
INSERT INTO dao_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","A mhnünmcenge kung pi pyüpyenaka mpya üngka naw jah mhläta kya khai, Pamhnama caea hlüngtaikia lätnak yah hnga khaiea kyaki. ");
INSERT INTO dao_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","A mhnünmcenge naküt tuhvei cäpa ngko u lü na hmi law khaia nghnumia mäiha jah msomhlei u lü vekie tia mi ksingki. ");
INSERT INTO dao_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Mhnünmceng däka am kyase, Pamhnam naw amdanga a jah yeta Ngmüimkhya mi taki pi mi mlung k'uma mi ngkoki. Pamhnama caa mi kyaknak vai ja a mhnünmcenge a jah mhlät vai pi mi k'äihei sihki. ");
INSERT INTO dao_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Äpeinak am küikyannak mi yah ve; cunsepi, hmu u lü äpei cun äpeinaka am kya. Khyang naw a hmuh thei cun ihawkba mi äpei khai ni? ");
INSERT INTO dao_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Am mi hmuh thei mi äpei üng, mlung msaünak am mi k'äih khai. ");
INSERT INTO dao_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Acun käna, Ngmüimkhya naw am mi kyannake üng ja kpüiki. Mi ktaiyü üng ihawkba ktaiyü vai tia am mi ksing. Cunsepi, mi ktaiyü üng ngthu üng am pyen theia ngkonak am Ngmüimkhya naw ngko lü jah ktaiyü peki. ");
INSERT INTO dao_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Acunüng, Mi mlung jah teng lü Ngmüimkhya naw i cungaiki ti cun ksingki, isetiakyaküng khyangea kcaha Pamhnama veia a ktaiyü hin Pamhnama ngjak'hlüa kyaki. ");
INSERT INTO dao_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Avan üng atänga Pamhnam mhläkphyanakie, a titänga a jah khüea phäha akdaw vaia biloki tia mi ksingki. ");
INSERT INTO dao_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","A jah ksing pänge cun amäta a ca mäiha ve khaiea a jah na mhnün päng, a Cakpa cun bena khawhahea ksunga ca kcüka a kya lawnak thei vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Acunakyase a jah na phyäi pänge ni a jah khü; a jah khüe ni amät am a jah ngsungpyunsak; a jah ngsungpyunsak pänge ni a jah mhlünmtai. ");
INSERT INTO dao_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Acunüng a hina ngthue üng i mi pyen thei khai? Pamhnam mimi phäha a ve üng u naw jah tu thei khai ni? ");
INSERT INTO dao_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Amäta Cakpa pi am kpamei lü mi vana phäha jah peki naw, avan naküt amdanga am jah pet sih khai aw? ");
INSERT INTO dao_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Pamhnama xüa khyange cun u naw jah ksekha na thei khai ni? Pamhnam amät kung naw am mkhyekat u a ti. ");
INSERT INTO dao_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","U naw jah mkatei thei khai ni? Khritaw Jesuh naw am jah mkatei. Thi lü, thi däkia am kya lü, thihnak üngka naw tho law be lü Pamhnama khet lama ve lü jah ktaiyü peki cun Khritawa kyaki ni. ");
INSERT INTO dao_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Khritawa mhläkphyanak üngka naw u naw ja mtai thei khai aw? Khuikhatnak naw pi kyase, khaknak naw pi kyase, mkhuimkhanak naw pi kyase, cawixainak naw pi kyase, akpuma venak naw pi kyase, kyühkyawknak naw pi kyase, thihnak naw pi kyase, jah mtai thei khai aw? ");
INSERT INTO dao_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","“Nanga phäha anglät se thihnak vai üng kami veki; hnim vaia toca mäia ami jah pawh” tia Cangcim naw pyenki. ");
INSERT INTO dao_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Am jah mtai, jah jawngnakia a bäkhäknaka phäha acune naküt kami jah näng päng ni. ");
INSERT INTO dao_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Isetiakyaküng, thihnaka pi kyase, xünaka pi kyase, khankhaw ngsäa pi kyase, khawyai ksea pi kyase, khankhaw anaa pi kyase, tuhkbäih üngkaea pi kyase, tuha ve law khaiea pi kyase, ");
INSERT INTO dao_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ak’hlünga pi kyase, aknema pi kyase, mhnünmceng naküt üngka i naw pi, mi Bawipa Jesuh Khritaw vei mi yaha Pamhnama mhläkphyanak üngka naw am jah mtai thei khai tia akcanga ka ksingki. ");
INSERT INTO dao_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Khritaw üng, ngthu kcang ka pyenki, am ka hleiki ni, Ngmüimkhya Ngcima phäha, akdaw ja akse ksingnak thei naw pi na ksingpüi se, ");
INSERT INTO dao_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ka khuikhanak ka pyen üng mlung üng am düt theikia natnak ka taki. ");
INSERT INTO dao_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ka khyange mtisa lama ka mjüea phäh kei hin Khritaw üngka naw mtai lü yüncenak ka yah vaia pi hlüei kyaw veng. ");
INSERT INTO dao_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Isarel khyangea kyakiea kyase, caea thawnak, hlüngtainak, khyütame ja Thum jah pe lü ngthumkhän a jah pawh püi. Pamhnam hjawkhahnak ja äpeinake naküt cun ami kaa kya lü; ");
INSERT INTO dao_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ami cun nglongthangkie Hebru pupae üngka naw lawki he. Pumsa lama Khritaw cun amimi üngka naw lawki; Ani cun avan naküta khana veki, angläta mhlünmtai phyakia Pamhnama kyaki! Amen. ");
INSERT INTO dao_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Cunsepi, Pamhnama ngthu cun am ngtähki tia am pyen veng. Isarela mjükphyüie naküt, Isarel kcanga kya päihkiea am kya; ");
INSERT INTO dao_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Abrahama mjükphyüia ami kyaa phäha ami van Abrahama caa am kya u; “Khyütam ka ning peta mjükphyüi cun Isak üngkhyüh na yah khai” tia kyaki. ");
INSERT INTO dao_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Acun cun, mtisa lama cae cun Pamhnama caea am kya u lü khyütamnak am cae cun Abrahama caea kyakie tinaka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Pamhnama khyütam cun hina kyaki; “Atuh üngka naw, akcün kümkawi lü ka law üng, Sarah naw kpamica ca na khai” a ti. ");
INSERT INTO dao_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Acun däka am kya, Rabeka naw mi pu Isaka phäh angphi a mpyainak üng, ");
INSERT INTO dao_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","na ca xawi am ani hmi law ham üng, akdaw ja akse am ani pawh thei ham üng, pawhmsaha phäha am kya lü, khüikia mlung ngaih däka kya lü, xünak üng, Pamhnama bünak a khäng vaia, ");
INSERT INTO dao_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","a veia, “Angvai cun akdika mpyaa kya khai” tia Pamhnam naw a pyen. ");
INSERT INTO dao_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","“Jakop jawng na lü Etaw ka hnengki” tia Cangcim naw a pyen. ");
INSERT INTO dao_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","I mi pyen vai veki? Pamhnam cun am ngsungpyunki mi ti khai aw? Pamhnam am ngsungpyunkia am kya. ");
INSERT INTO dao_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Pamhnam naw, “Ka mpyenei hlü, mpyenei lü, ka bänak hlü ka bänak khai” tia, Mosia veia a pyen. ");
INSERT INTO dao_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Acunakyase, anaküt cun khyanga ngjak'hlü am kya lü Pamhnama mpyeneinaka phäha ni akya ve. ");
INSERT INTO dao_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Cangcim naw Pharoa veia, “Ka khyaihnak nang üngka mdan vaia phäha ja ka ngming khawmdek avan üng a ngthang hünak vaia ka ning mhlünmtaiki” a ti. ");
INSERT INTO dao_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Acunakyase, Pamhnam naw a mpyenei hlü mpyenei lü, a mlung a ngcangsak hlü ngcangsaki. ");
INSERT INTO dao_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Acunakyaküng, “Pamhnam naw ise jah mkateiki ni? U naw a ngjak'hlü mkhyeki ni?” Mat mat naw ti taw khai. ");
INSERT INTO dao_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Cunsepi, ka püi aw, Pamhnam na ngcuhpüi khaia ta nang u ni? Mdek k’am naw sepkia khyang üng, “I vai ahikba na na pyan ni?” ti lü am kthäh khawi. ");
INSERT INTO dao_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","K’amksep naw, mdek üngka lo lü mat akdawa sep lü, mata sep sawxat khaia ana taki ni. K’amksep naw mdek cun a ngjak'hlüa am sumei khai aw? ");
INSERT INTO dao_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Pamhnama bilawhnak üng pi acun kba kyaki. A mlung sonak mdan lü a johit a ngsingnaksak vaia kyaki. Cunsepi a mlungsonak khamei lü, pyüpyeh khaie khana mlung saünak taki. ");
INSERT INTO dao_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","A hlüngtainak yah khaia a jah mhnüna mi kyakia mimia khana a jah peta dämdakia a hlüngtainak cun, a bäkhäknak makie khana pi a mdan vai pawhki. ");
INSERT INTO dao_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Judahe däk üngkaa am kya lü, Khyangmjükcee üngkae pi a jah khü. ");
INSERT INTO dao_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Hosia cauk üng, “Ka khyanga am kya khawikie, ‘ka khyange’ ka jah ti na khai. Acunüng am ka mhläkphyanak khawie cun ‘ka mhläkphyanake’ ka ti khai. ");
INSERT INTO dao_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Acunüng, ami veia hikba kya law khai, ‘Ka khyangea am nami kyakia’ hnün üng xüngseiki Pamhnama cae tia ngsui law khaie” tia pyenki. ");
INSERT INTO dao_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Hesajah naw pi Isarele jah pyen naki naw, “Isarele cun, tuinu kama, kdiyüta mäiha däm u sepi avange däk naw ni küikyannak ami yah kawm. ");
INSERT INTO dao_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Bawipa naw khawmdek khana khyange cun angenga ngthu jah mkhyah pe khaia pha law khai” a ti. ");
INSERT INTO dao_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Hesajah kung naw, “Hlüngtai säihki Bawipa naw mi mjükphyüie am a jah phyäi vai sü üng ta, Sodom mlüh ja Komorah mlüha mäiha mi kham khaie sü” tia a na pyenki. ");
INSERT INTO dao_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Khyangmjükcee vei mi pyen vai ta amimät jah amimät Pamhnam üng am ngsungpyun hlü u lü amimäta pawhmsah üng ngsungpyun hlükie cun jumnak am amät am a jah ngsungpyunsak. ");
INSERT INTO dao_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Isarele ngsungpyunnaka thum ktämkie naw ngsungpyunnaka thum am hmu ve u. ");
INSERT INTO dao_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ise ni? Jumnak üng am ktäm u lü bilawhnak am yah theia mäiha ami ktäma phäha kyaki. “Ngsukeinaka lung” üng ngsukeikie. ");
INSERT INTO dao_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Cangcim naw, “Tenga khyangea ngsukeinak vai lung ja kyukngtänaka lungnu cun Zion mcunga ka taki, au pi Ani jumeikie naküt cun am hela u” tia pyenki. ");
INSERT INTO dao_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ka püie aw, Isarele küikyana ami yahnak thei vaia, ka mlunga ngjak'hlüa kyase, Pamhnama veia ka ktaiyüki. ");
INSERT INTO dao_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ksingnak kcang am ta u sepi Pamhnam da aktäa ktha nakie tia ka ning jah mtheh veng. ");
INSERT INTO dao_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Pamhnam naw amät am a jah ngsungpyunsak cun am ksing u, acuna hnün üng amimäta lam pyangei u lü Pamhnam naw khyang a jah ngsungpyunsaka k'uma am law u. ");
INSERT INTO dao_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Khritaw cun jumeikie naküt naw ngsungpyunnak ami yah vaia Khritaw naw thum dütsaki. ");
INSERT INTO dao_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mosi naw a yuka mawng ta Thum kcangnaki cun Pamhnam naw ngsungpyunsak khai, “Thuma pyen naküt cun ngaiki ta xüng khai” a ti. ");
INSERT INTO dao_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Cangcim naw jumeinak am ngsungpyunnak a pyen cun hin ni, “Khankhawa u kai khai? (Acun cun khritaw kyum lawpüi khai kyaki) ");
INSERT INTO dao_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Mcea u kyum khai? (Acun cun thihnak üngka naw khritaw lawpüi khai tinaka kyaki) tia na ngthäh khai aw? ");
INSERT INTO dao_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Acunüng, pyen be tü lü, “Ngthu naw ni k’et ve, na mka ja na mlung k'uma ve ve” a ti; acun cun jumnaka ngthu kami sang khawi, ");
INSERT INTO dao_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","“Na mlung am Jesuh cun Bawipa ni tia pyen lü, thihnak üngka naw Pamhnam naw mthobeki tia na mlung k'uma na jum üng küikyannak na kya khai” ti cen. ");
INSERT INTO dao_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Mlung k'uma jumnak am Pamhnam üng ngsungpyunnak mi yahki; mpyawng am pyen lü khyang naw küikyannak yahki. ");
INSERT INTO dao_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Cangcim naw, “A u pi ani jumki naküt cun am hela khai ni” a ti. ");
INSERT INTO dao_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Judah ja Krik ami hngalangnak i am ve. Bawipa mat ami vana khana Bawia kyaki, a ngming khüki naküta khana dawnak khawhah am, jah kbeki. ");
INSERT INTO dao_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","“A u pi Bawipa ngming khüki naküt cun küikyannak yah khaie” tia kyaki. ");
INSERT INTO dao_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Acunüng, am ami jum cun ihawkba khü khaie? Ngthu am ami ngjak üng ihawkba jum khaie? Sangki am a ve üng ihawkba ngja khaie? ");
INSERT INTO dao_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Tuha khyang am a ve üng ihawkba sang thei khaie? Acuna kba, Cangcim naw “Thangkdaw lawpüiki ngsä he law vai cun ihlawka müncam phyaki ni” tia pyenki. ");
INSERT INTO dao_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Cunsepi, Thangkdaw cun ami van naw am jum päih u. Acunakyase, Hesajah naw, “Bawipa aw kami ngthu pyen u naw jumki ni?” a ti. ");
INSERT INTO dao_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Acunakyase, jumeinak cun ngthu ngjaknak üngka naw lawki, ngthu cun Khritawa mawng sangnak üngka naw lawki. ");
INSERT INTO dao_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Acunüng, ami nghnga üng, am ngjakie aw? Ngjakie. Cangcim üng, “Ami kthai cun pe naküt üng ngthang hü lü, ami ngthu pi khawmdeka dütnak cäpa ngthang hüki” tia veki. ");
INSERT INTO dao_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ka ning kthäh be tüki; ‘Isarele naw am ksingkie aw? Pamhnam üng Mosi amät naw a kcüka a msang vai ta; “Pacaa am nglawikie jah summangei lü, ka xüa khyange ka jah ngkei lawsak khai; khyangmjükcee am ka xüa khyangea mlung ka sosak khai” tia kyaki. ");
INSERT INTO dao_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Acunüng Hesajah naw, ling lü, “Am na suikie naw na hmu u lü, am na khükiea veia ka ngdang khai” a ti. ");
INSERT INTO dao_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Acunüng, Isarelea mawng pyen be tü lü, “Amhnüpa mtheh am ngja u lü, kpetmjakie veia ka kut ka säng khai” a ti. ");
INSERT INTO dao_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Acunüng, Pamhnam naw a khyange jah mahki aw? Am ja mah. Kei pi Isarel khyang, Abrahama mjükphyüi, Benjamina sang üngkaa ka kyaki ni. ");
INSERT INTO dao_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Pamhnam naw akcüka a jah xüpänga khyange am jah mah khawi. Cangcim naw Elijaha mawng a pyen am nami ngja khawiki aw? Elijah naw Isarelea mawng Pamhnama veia pyen lü, ");
INSERT INTO dao_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Bawipa, na sahmae jah hnim u lü; na kpyawngkunge jah kpyeh u se, kei däk ka xüngki, kei pi na hnim khaiea bükie ni” a ti. ");
INSERT INTO dao_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Acunüng, Pamhnam naw ihawkba jah a msang be? “Am dawkia Baal mhnam am mküimtokiea khyang thawng khyüh ka phäha ka jah taki” ti lü a msang. ");
INSERT INTO dao_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Acukba tuhkbäih pi, a bäkhäknak am a jah xü, ajaw ve hamkie. ");
INSERT INTO dao_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","A bäkhäknak üng a jah xüa akya üng, bilawhnak üng am kya; acukba am akya üng bäkhäknak cun bäkhäknak kcanga mäi am law. ");
INSERT INTO dao_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","I mi pyen khai? Isarele naw ami sui am hmu u. A xüea khyang ngcek naw ni ami sui cun ami hmuh u. Aknung bawk naw Pamhnama khünak am ngja u. ");
INSERT INTO dao_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Cangcim üng, “Pamhnam naw tuhkbäih däa ami mlung ja ami ksingnak jah nghmüpsak se tuhvei cäpa am hmu ngja u” tia pyenki. ");
INSERT INTO dao_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Acunüng, Davit naw, “Ami eiawknak cun ami ng’awhnak vaia kya lü, ami kyukngtänak vaia pi kyase; ");
INSERT INTO dao_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Am hmu thei khaiea, ami mik pi mü law se, khuikhanaka maa anglät se jah ngkunsak vai” a ti. ");
INSERT INTO dao_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ka ning jah kthähki, Isarele cun kyuktäng pyawce khaiea ngvänkie aw? Acukba am kya. Isarelea mkhyekatnak cun khyangmjüceea phäh küikyannak vai ja kya law lü Isarele naw jah k’eihkie. ");
INSERT INTO dao_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Isarelea mkhyekatnak naw khawmdeka bawimangnaka kya lü Ngmüimkhya lama khuikhakie khyangmjücea phäh bawimangnak lawpüiki. Ami kümbenak ami law vai süa ta ihlawka daw khai ni. ");
INSERT INTO dao_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Tuhkbäih Khyangmjükceea veia ka pyenki. Khyangmjükceea veia ngsäa ka kyaa küt üng, ka khutbi ka awhcahnaki. ");
INSERT INTO dao_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Acun cun, kamäta khyange k’eihnak ta khaiea ja pawh lü, avange ka jah küikyannak vaia kyaki. ");
INSERT INTO dao_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ami mahnak cun khawmdek khyang naküta phäh Pamhnama ye üngka naw a püia nglat law bekie ni. Ami a jah dokham cun ihawkba vai ni? Acun cun akthiea phäh xünnak vai ni. ");
INSERT INTO dao_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Acunüng, muk pyan ma Pamhnam üng pet üng, muk avan pi a kaa kya khai, thinga pyae Pamhnam üng pet üng a ngbane pi a kaa kyaki. ");
INSERT INTO dao_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Nglina olip ngban avang ek se, olip kcanga am kyaki acun üng ngsu law khaie. Olip kcang am nikia nangmi khyangmjükcee cun Judahea ngmüimkhya xünak nami yumeipüikie ni, ");
INSERT INTO dao_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","a ngban eke käh jah hmumsita. Nang cun a ngban kya lü käh awhcaha. Awhcah lü pi nang aphung na mcahkia am na kyaki, aphung naw ni a ning mcah ve. ");
INSERT INTO dao_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Acunüng, nang naw, “Ä! ekia ngban naw ka phäha hnün na peki na ti khai.” ");
INSERT INTO dao_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Cang ve, am ami jumeia phäha jah k’eha kyaki, nang na jumeinaka phäha na ngdüiki. Käh awhcah lü kyüheia. ");
INSERT INTO dao_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Pamhnam naw a ngban kcange pi am a jah msawk üng, nang pi am ning msawk law sawxat khai. ");
INSERT INTO dao_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Acunakyase Pamhnama a dawnak ja a kyühksenak cän ngaia, kyukngtängkiea phäha kyüh phyaki ni; a dawnak üng na ve nglät üng nanga phäha cun dawki ni; am acunüng ta nang pi ning ksawmpata na kya hnga khai. ");
INSERT INTO dao_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Acunüng, Judahe naw am ami jumnak ami hawih üng ami venak khawia ve be khaie, Pamhnam naw acukba jah pawh khawhki. ");
INSERT INTO dao_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Nang olip kcanga am na kyaki pi ni ksawm u lü, am nami tängkia olip thing kdaw üng ning mdüna akya üng, a ngbane kcang cun ami phung kung olip thing üng jah mdünnak be vai jah hlüei bawk khai ni? ");
INSERT INTO dao_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ka püie aw, hina khyü ngthup hin nami ksing vai yü na veng. Namimät nami kthemkia käh nami ngai khaia, Khyangmjükceea kcün am a kümkawi law hama küt üng, Isarelea mlung nglangnak cun asäng ni. ");
INSERT INTO dao_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Acukba Isarele naw küikyannak yah khaie; Cangcim üng, “Zion mcung üngka naw jah küikyanki Bawipa pha law lü Pamhnam am ami ksingnak cun Jakopa mjükphyüi üngkhyüh jah mkhyüh law pet khai.” ");
INSERT INTO dao_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","“Ami mkhyekatnake ka jah mhlät law pet üng, acun cun ami veia ka khyütam vaia kyaki” tia pyenki. ");
INSERT INTO dao_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Thangkdaw ami maha phäh, nangmia phäha Pamhnama yeea kyakie. Pamhnama a jah xünnak üng ta ami pupaea phäh Pamhnama püia kyakie. ");
INSERT INTO dao_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Dawnak jah pe lü a jah xüa khana Pamhnam naw a mlung am thunghlai kawi. ");
INSERT INTO dao_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ahlana Pamhnama ngthu am nami ngai khawiki, cunsepi, tuhkbäih cun Judahe naw ngthu am ami ngaih phäha mpyeneinak nami yahki. ");
INSERT INTO dao_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Acukba kunga, tuhkbäih cun Pamhnam naw ning jah mpyenei se mpyeneinak nami yahnak hnga vaia, Judahe naw pi Pamhnama mpyeneinak ami yahnak bawk hnga vaia Pamhnama ngthu am ngai u. ");
INSERT INTO dao_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Pamhnam naw khyang naküt a jah mpyeneinak thei vaia khyang naküt cun ngthu am ngaihnak üng a jah tak päiha kyaki. ");
INSERT INTO dao_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Pamhnama kthemnak ja ksingkhyapnak cun a aktäa ngsawngkang ve. A ngthumkhyahnake cun jah ksing thei vaia am kya lü u naw a tüilame pi ksing khai ni. ");
INSERT INTO dao_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Cangcim naw, “U naw Bawipaa mlung cun ksingki ni? U naw Pamhnam mtheimthang khawiki ni. ");
INSERT INTO dao_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","A thung be vaia pi u naw i pe khawiki ni? ");
INSERT INTO dao_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Avan naküt cun amät naw mhnünmcengki. Anaküt cun amät üngkhyüh ngtüi law lü amäta phäha kyaki. Pamhnam hlüngtainak aläa ve se. Amen. ");
INSERT INTO dao_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Acunakyase, ka püie aw, Pamhnama dämduhkia mpyeneinak am ning jah nghuinak ta, nami mät kung cän Pamhnama veia xüngseikia ngkengnaka mäia ng’apei lü Pamhnama khut bi ua. Acuna khut nami binak naw Pamhnam jesaki ni. Ahin cun akcanga nami pet vaia hjawkhahnak ni. ");
INSERT INTO dao_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Hin khawmdeka thuma käh ve u lü, Pamhnam naw akthaia nami mlung ning jah thunghlai se. Acun üngva Pamhnama ngjakhlü akdaw i ti ja ani cun kümkawikia jenaksak hin i tia nami ksing khai. ");
INSERT INTO dao_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Pamhnam naw amdanga a na peta a bäkhäknaka phäha nangmi üng u naw pi a vea kthaka hlüng khai käh ngai ua ti veng. Acuna kthaka ta aknema ngai u lü Pamhnam naw a ning jah peta jumnaka kba nami mät ngaiei ua. ");
INSERT INTO dao_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Pumsa mat üng ngban khawhah mi taki, mi ngbane naküt a ami bilawh am täng u. ");
INSERT INTO dao_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Acukba kunga mimi khawjah mi law sepi Khritaw üng mtisa mata mi kyaki; lüpi mimi cun mi nghngalang lüpi mat ja mat mtisa mat üng mi ngsuki. ");
INSERT INTO dao_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","A bäkhäknak am a jah pet mi khyaihnak phäh phäh üng khut mi bi vai u. Pamhnama ngthu pyennak vai a jah pet üng ta jumnak mi taka kba mi pyen vai u. ");
INSERT INTO dao_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Khüibi bi khaia akya üng khüibi mi bi vai u; mtheiki naw pi mtheinak mi bi vai u; ");
INSERT INTO dao_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","khyang ngjuktha peki naw pi ngjuktha petnak bi se; petmsawtki naw pi käh pam lü pe se; ana mah naw pi ktha na lü bilo se; khyang mpyeneiki naw pi jekyainak am mpyenei se. ");
INSERT INTO dao_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Mhläkphyanak cun mhläkphyanak kcanga kyase. Mkhyekatnak hneng u lü dawnak kpang ua. ");
INSERT INTO dao_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Khritjanea nami kya kba mat ja mat hnün ata kba mhläkphya na u lü ngkhawtei ua. ");
INSERT INTO dao_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Khüinak lam üng käh dam u lü; mlungkyawng ap lü Bawipa khut bi ua, ");
INSERT INTO dao_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","äpeinak üng jekyai u lü; khuikha khameinak cun cunei u lü, angläta ktaiyü ua. ");
INSERT INTO dao_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","A hlükaw veki khritjane üng jah petmsawt u lü; khine pi nami jah khinnak vai. ");
INSERT INTO dao_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Ning jah mkhuimkhakie, dawkyanak am jah kbe u; käh jah yünce u lü dawkyanak nami ja kbe vai. ");
INSERT INTO dao_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Jekie jah jepüi u lü; kyapkie jah kyahpüi u. ");
INSERT INTO dao_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Ngaihnak thei avana khana atäng ta ua. Käh awhcah u. Mlung nemnak üng dokham ua. Themkia namimät käh ngai ua. ");
INSERT INTO dao_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Khyang naw a ning hmakatsak üngpi käh thungei be u. Khyang avan naw daw khaia ngaih cän pawh a. ");
INSERT INTO dao_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Khyang naküt am nami ngkhawt vaia anaküt cän bi a. ");
INSERT INTO dao_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ka püie aw, u pi käh thungei be u, Pamhnama naw thung be se, “Phu naküt cun keia thung vaia kyaki, kei naw thung be lü kei naw ka pe bekhai ti lü Bawipa naw” Cangcim üng a ti. ");
INSERT INTO dao_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Acunakyase, na ye a ei a cawi üng, a ei vai pea, tui a xai üng a awk vai pea; acukba na bi üngva ngkekhyakei khaie ni. ");
INSERT INTO dao_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Akse naw käh ning jah näng lü akdaw am akse cän näng ua. ");
INSERT INTO dao_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Khyang naküt naw jah upki khawngmanga pyen cun ngai kawm, isetiakyaküng Pamhnam naw ana a jah peta phäha khawngmange cun vekie. Pamhnama jah mcawna kyakie ni. ");
INSERT INTO dao_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Acunakyase, u pi, khawngmang am kcangnaki cun Pamhnama mcawn ksekha nakia kyase; amäta khana ngthumkhyahnak yah khai. ");
INSERT INTO dao_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Akdaw pawhki naw jah upkie cun jah kyüh vai am ni. Lüpi akse pawhkie naw ami jah kyüh vai ni. Am na jah kyüh vai na tängki aw? Akdaw na pawh ta ning mküiei khaie; ");
INSERT INTO dao_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","isetiakyaküng amimi cun Pamhnama mpyaea kya lü nanga phäh akdaw pawh khaie ni. Cunsepi, akse na pawh üng jah kyüh a, amimia mkhuimkhanak khawha ana cun akcang ni, isetiakyaküng jah mkhuimkha khaie ni. Akse pawhkie khana Pamhnama mkhuimkhanak cun biloki Pamhnama mpyaea kyakie ni. ");
INSERT INTO dao_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Acunakyase, Pamhnama mkhuimkhanak na kyüh däka phäh am kya lü namäta ksingeinaka phäha ana takie mtheha vea. ");
INSERT INTO dao_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Acunakyase ni, ngcawn pi na ngcawng ta; isetiakyaküng jah upkie cun naw ami mta ami bi hin Pamhnama phäh khüikie ni. ");
INSERT INTO dao_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Na pet vai mta cun jah pe a. Namäta phäh ja na khawhthema phäh ngcawng cun pe lü jah leisawng kawmki. ");
INSERT INTO dao_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Mata veia pi käh lei mah lü mat ja mat nami mhläkphyanaka thea ta i käh lei na ua. Ahin pawhki naw ta Thum kcangnaki ni. ");
INSERT INTO dao_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Thum naw, “Khyanga khyu, khyanga cei käh na bäühmanak vai; khyang käh na hnim vai; käh na mpyuk vai; khyanga ka käh na hlükawei vai” a ti. Ahin avan ja akce ngthupet naküt cun, “Namät na mhläkphyanaka kba na impei loceng na mhläkphyanak vai” tia ngthupet mat üng kümkawi päihkie. ");
INSERT INTO dao_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Khyang kce na mhläkphyanak üng amimi khana akse am pawhki, mhläkphyanak na tak cun Thum avan na kcangnak ni. ");
INSERT INTO dao_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Nami ihnak üngkhyüh nami thüxak vai akcün pha lawkia kyase hin hin pawh ua. Isetiakyaküng küikyannak hin akcüka mi jumeia kcüna kthaka ng’et law bawki ni. ");
INSERT INTO dao_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Mthan päih law hlü hnüh lü, khaw thai law hlü ve; acunakyase, nghmüp üng mi bilawhe mi jah hawih u lü, akvaia üng ngtuknaka likcime mi jah kawtei vai u. ");
INSERT INTO dao_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Mhnüpa vekie khyangea kba akdawa mi ve vai u. Eiawknak, ju mpyüinak, aksea ngneisak, ngtunngvawknak, hüipawmnak ja ng’eiknak üng käh mi ve vai u. ");
INSERT INTO dao_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Bawipa Jesuh Khritawa likcim cun kawtei u lü nami mtisaa ngjakhlüa mkhyekatnak cän käh pawh ua. ");
INSERT INTO dao_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Acunüng, a jumeinak ktha ngcekie jah dokham lü ami cungaihnak käh jah ngcuhpüi ua. ");
INSERT INTO dao_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Khyang avanga jumeinak naw avan eia nglawiki tia ngai lüpi a jumeinak ngceki naw ta an däk eiki. ");
INSERT INTO dao_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Avan eiki naw avan am eiki käh hmumsit kawm; avan am eiki naw pi avan eiki käh pyenei kawm; Pamhnam naw ani nghngih jah dokhamki ni. ");
INSERT INTO dao_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Khyang kcea mpyae ngthumkhyah khai cun nang u ni? A ngnäng vai ja am a ngnäng vai cun a Mahpa naw mkhyah khai ni. Ani nghngih ngnäng khai xawi, isetiakyaküng Bawipa naw jah ngnängsak khawhki. ");
INSERT INTO dao_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Khyang avang naw khaw mhnüp at cun akce mhnüpea kthaka dawkia ngai lü, khyang kce naw khaw mhnüp avan tängkia ngaiki. Mi mlung mi nängei kawm u. ");
INSERT INTO dao_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Khaw mhnüp ak’hlüng säiha ngaiki naw pi Bawipa leisawng kawm. Anaküt eiki naw pi Bawipa leisawng lü Pamhnam üng eiawka phäh jenak mtheh kawm. Anaküt am eiawki naw pi Bawipa leisawng lü Pamhnam üng jenak mtheh kawm. ");
INSERT INTO dao_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","A u pi, mimäta phäha mi xüngkia am kya, mimäta phäha mi thihkia pi am kya. ");
INSERT INTO dao_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Mi xün üng Bawipa phäha mi xüng u lü, mi thih üng pi Bawipa phäha mi thiki; acunakyase, mi xüng üng pi, mi thih üng pi kyase Bawipa kaa mi kyaki. ");
INSERT INTO dao_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Khritaw thi lü a thawhnak be cun akxüng he ja akthihe phäha Bawipa a thawn vaia phäh kyaki. ");
INSERT INTO dao_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Cunakyase, an eikia na kyak üng i vai akce ngthu na mkhyah petki ni? Nang naw avan na ei üngpi ivai jumeiki akce na hmumsitki ni? Avan cun ngthumkhyahnak khamei vaia Pamhnama ma mi ngdüi law khai. ");
INSERT INTO dao_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Cangcim üng, “Kei xüngkia Pamhnam ni ti lü Bawipa naw pyenki, khyang naküt ka ma mkhuk msüm u lü khyang naküt naw kei cun Pamhnam ni ti khaie” tia pyenki. ");
INSERT INTO dao_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Acunakyase, mi van naw mi bi naküta phäh Pamhnama veia mi phyeh law khaie. ");
INSERT INTO dao_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Khyang üng ngthu mi mkhya pet cän mi hawih kawm u. Acuna kthaka anaküt ami pawh üng akce käh nami kyukngtängsak vaia mcei ua. ");
INSERT INTO dao_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Bawipa Jesuh üng ka vekia kyase ei vai naküt hin ngcim ve. Lüpi eiawk avang hin am ngcim ve tia na jum üngta na phäh am ngcim ve. ");
INSERT INTO dao_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","I mä na eia phäh akcea am adawnak ani üngta na vecawh hin mhläkphyanak üngkhyüh am ni. Khritaw a phäha thiki khyang cun na eiawk üng käh kyukngtängsaka. ");
INSERT INTO dao_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Akdawa na ngaih cun naw ngming kse na yahnak vaia käh kyase. ");
INSERT INTO dao_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Pamhnama Pe cun eiawknak üng am kya. Lüpi Ngmüimkhya Ngcima a jah peta ngsungpyunnak, dim’yenak ja jekyainak üng ni akya ve. ");
INSERT INTO dao_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Ahina tuilam üng Khritawa phäh na bi üng Pamhnam jesaki lü khyang kcee naw pi ni mküiei khaie ni. ");
INSERT INTO dao_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Acunakyase, dim’yenak ja mat ja mat ngjuktha jah pe khaiea ngkaw cän angläta jah bilo ua. ");
INSERT INTO dao_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Eiawk üng Pamhnama khüibi käh na kpyeh vai. Eiawk naküt ei lü ngcimki cunsepi khyang mkhyenak üng a kyukngtäng vaia na eiawk cun am daw ve. ");
INSERT INTO dao_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Jumeiki khyang kce kyukngtängsak khaia meh einak ja ju awknak cun hjawng hin dawki ni. ");
INSERT INTO dao_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Hina mawng üng na jumnak cun Pamhnam ja namäta nglaka ve kawm. Ami bilawh üng mkhyekatnaka am kya tia ngaikie cun ami ngaihnak cangkie cun je u se. ");
INSERT INTO dao_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Cunsepi mlung uplatnak ta lü ami eia khana Pamhnam naw jah mkatei, isetiakyaküng, jumnak üng am ami bilawha phäha kyaki. Jumnak üng am tünei cun mkhyekatnaka kyaki. ");
INSERT INTO dao_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Acunakyase, mi jumnak üng mi dämkie naw, mimäta dawnak däk käh mi sui u lü, kthangcekiea phüih pi mi jah phüihpüi vai u. ");
INSERT INTO dao_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Jumeiki khyang kceea kyäpnak vai ja ami dawnak vai mi teng u lü jumnak üng mi jah sawngsa vai u. ");
INSERT INTO dao_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Khritaw naw pi amäta a dawnak vai am sui, “Nang ni ksenakiea ksenak cun, keia khana kya lawki” tia Cangcim üng ng’yuki. ");
INSERT INTO dao_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Cangcim üng vekie cun, mimi naw mlungsaünak ja mlungüpnak üngkhyüh äpeinak mi yah vaia acune naw jah mthei khaia ng’yukie ni. ");
INSERT INTO dao_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Nangmi cun mlungmsaünak ja mlungüpnaka phungnu Pamhnam naw mlungkaw mat am Khritaw Jesuha ngneisaka kba nami xüngsei khaia, ");
INSERT INTO dao_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","mi Bawipa Jesuh Khritawa Pa ja Pamhnam cun a yüma mlungkaw mat am nami mküimto khaie ni. ");
INSERT INTO dao_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Khritaw naw a ning jah dokhama kba Pamhnama hlüngtainak vaia mat ja mat dokhamei ua. ");
INSERT INTO dao_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Ning jah mtheh veng, Khritawa sak üng a bilawh hin Judahea phäh kya lü Pamhnam hin sitihki. Ami pupaea veia a jah peta khyütam cun akcanga kümkawi lawsaki, ");
INSERT INTO dao_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Khyangmjükcee naw Pamhnama mpyeneinak mhlünmtai law khawh khaie. Acunakyase, Cangcim üng, “Acunakyase, Khyangmjükceea ksunga ning mhlünmtai lü mküimtonak ng’äi ka mcuk khai” a ti. ");
INSERT INTO dao_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","A pyen be tü ta, “Khyangmjükcee aw Pamhnama khyange am atänga jekyai ua” a ti. ");
INSERT INTO dao_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Acun käna, “Khyangmjükce naküt naw Bawipa mküimto ua, khyang avan naw mküimto ua” a ti. ");
INSERT INTO dao_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Acun käna Hesajah naw, “Jisea ngsawn po law khai, ani Khyangmjükcee jah uk law khai, ani üng äpeinak ta law khaie.” ");
INSERT INTO dao_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ngmüimkhya Ngcima johit am nami äpeinak adäm law vaia Pamhnam nami jumnak üng äpeinaka phungnu Pamhnam naw jekyainak ja dimdeihnak üng ning jah kbe se. ");
INSERT INTO dao_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Acunüng, ka püie aw, dawkyanak am bebang u lü, avan nami ksingkia kyase, mat ja mat mtheimkhawngei ua. ");
INSERT INTO dao_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Cunsepi, Pamhnam naw bäkhäknak a na pet cun ling lü, avan üng ka ning jah mtheh hlü be tüa phäh ka ning jah yuk law ni. ");
INSERT INTO dao_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Acun cun, Khyangmjükceea veia Pamhnam üngka thangkdaw cun ktaiyüa nghnün üng pyen veng, Khritaw Jesuha khut bikia ka kyanak vaia kyaki; Ngmüikhya Ngcim naw Khyangmjükceea bilawh cun Pamhnama phäha ngcimsaki ni. ");
INSERT INTO dao_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Acunakyase, Khritaw Jesuh am yüm mat lü Pamhnama khut bi hin ka awcahnak vai veki. ");
INSERT INTO dao_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Khritaw naw kei üngkhyüh khut bi lü khyangmjükcee jah cehpüi lü Pamhnama pyen ami ngjak vaia mawng däk ni lingnak am ka pyen. Ahin cun ngthu ja khutbinak am pi kyase, ");
INSERT INTO dao_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","müncamkse ja cäicatnake am pi kyase, Pamhnama Ngmüimkhya johit üng pi kyase acun am ni a bilawh. Jerusalem üngkhyüh Ilurihkon däa cit hü lü Khritawa mawng Thangkdaw ka sang hüki ");
INSERT INTO dao_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Acukba, khyang kce naw a süma lung khana, lung am mdün veng. Khritawa ngming am ami ngjaknak hama hnüna thangkdaw ka sang hü vaia ni ka bü. ");
INSERT INTO dao_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Acuna mäiha Cangcim üng, “Ngthu am ngja khawikie naw hmu u lü am ngja khawikie naw ksing khaie” tia pyenki. ");
INSERT INTO dao_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Acunakyase, nami veia am ka law thei khaia na khamki veki ni. ");
INSERT INTO dao_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Tuhkbäih cun hina khaw üngka khüinak ka kpäng ni, kum khawvei nami veia ka law khaia ka ngtün pängkia pi kyase, ");
INSERT INTO dao_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Spaina ka ceh naküt üng ka ceh lama ka ning ja hmu law pah khaia ngai veng; nami veia law lü ka jekyai käna, ka cehnak thei vaia nami na kpüi khaia ngai veng. ");
INSERT INTO dao_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Tuhkbäih cun Pamhnama khyange ka jah khüih khaia, Jerusalem mlüha ka cit ma khaia kya ve. ");
INSERT INTO dao_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Isetiakyaküng, Maketawniha hne ja Akaijah hnea sangcime naw Jerusalem mlüha veki Pamhnama khyange ksunga mpyenksekiea phäh petmsawtnak am jah kuei vaia mkhyahkie. ");
INSERT INTO dao_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Amimi jah kuei vaia amimäte naw mkhyahki ni; Judahe naw Khyangmjükcee cun ngmüimkhya lam ami jah yümpüi üng, khawmdek khawhthem am ami jah kuei be vai cun ami mta kung ni. ");
INSERT INTO dao_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Acunakyase, acuna khut cun kpäng lü, ngui jah mhjum lü Spaina ka ceh sawa ka ning jah hmu law pah khai. ");
INSERT INTO dao_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Acunüng, nami veia ka law üng Khritawa dawkyanak am bebang lü ka law khai tia ka ksingki. ");
INSERT INTO dao_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Ka püie aw, ka phäha Pamhnama vei angläta nami na ktaiyüpüi vaia mi Bawipa Jesuh Khritaw ja Ngmüimkhya a jah pet mhläkphyanak am ning jah nghui na veng. ");
INSERT INTO dao_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Am jumeikie Judahea ksunga Pamhnam naw a na yung vai ja Jerusalema ka bilawhe Pamhnama khyange naw ami dokham khawh vaia na ktaiyü pet ua. ");
INSERT INTO dao_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Pamhnam naw hlüei üng ta jekyainak am ka law khai, ka lawnak vai cun atänga ktha mi yahnak vai ni. ");
INSERT INTO dao_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Dimyenaka phung Pamhnam naw ning ja ve püi nglät se. Amen. ");
INSERT INTO dao_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Kenkirih mlüh sangcim üng khut pawhki, kami ci Phobe naw ning ja ksingsak veng. ");
INSERT INTO dao_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Pamhnama khyange nami jah mceia kba Bawipaa ngming üng jah dokham ua. Kpüi vai a hlü naküt üng kpüi u. Ani cun khyang khawjah a jah püinak kba kei pi na püinaki. ");
INSERT INTO dao_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Atänga Khritaw Jesuha khut kami bikia Priscilah ja Akuilah na jah hnukset pe ua. ");
INSERT INTO dao_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Acun xawi naw ka phäha ami sak am mceh na ni. Bäki xawi tia kei däk naw ka pyenkia am kya, Khyangmjükce sangcime naw pi tikie ni. ");
INSERT INTO dao_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Ami ima ngbämkie sangcime pi na ja hnukset pe ua. Asah hnea Khritaw jumei law kcükia ka mhlänak ka püi, Ephamit pi na hnukset pet ua. ");
INSERT INTO dao_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Marih nami phäha ktha na lü khüiki cän na hnukset pet ua. ");
INSERT INTO dao_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Ka mjü Judah khyang Andronikah ja Junih, thawngim üng ka jah kyumpüi xawi pi na ja hnukset pet ua; anini cun ngsä he üng ami ngming aktäa ngthangki xawia kya ni lü, keia kthaka khritaw üng ve maki xawia kyaki xawi ni. ");
INSERT INTO dao_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ka püi, Ampalih, Bawipa üng ka ngkhawt püi cän na hnukset pe ua. ");
INSERT INTO dao_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Khritaw üng khutbi kami bipüi Uraban ja ka mhlänaka Satakah cän na hnukset pe ua. ");
INSERT INTO dao_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Khritaw üng sitih cangkia Apelih cän na hnukset pet ua. Aristobuluha khyang lawng üngkae pi na jah hnukset pet ua. ");
INSERT INTO dao_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ka Judah khyang püi, Erodung cän na hnukset pe ua. Nakituha khyang lawng üng Bawipa üng vekie cän na jah hnukset pet ua. ");
INSERT INTO dao_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Tarupenah ja Taruphotah, Bawipa üng khüi khawiki xawi cen na ja hnukset pe u. Ka mhlänak Peratih, Bawipa üng aktä leng leng se khüiki pi na jah hnukset pet ua. ");
INSERT INTO dao_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Bawipa a jah xü Rufuh ja a nu, a na ca akba na ve püiki pi na jah hnukset pet u. ");
INSERT INTO dao_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asukrit, Phalekung, Hames, Patrobah, Hamas ja, ami veia vekie cen na jah hnukset pet ua. ");
INSERT INTO dao_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Philolokung ja Juli, Niruh ja a na, Olampat ja ami hlawng veki Pamhnama khyange cän na jah hnukset pet ua. ");
INSERT INTO dao_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ngcimkia hnuksetnak üng hnuksetei ua. Khritawa sangcime naküt naw ning jah hnukset ve u. ");
INSERT INTO dao_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Acunüng, ka püie aw, ngtainak pawhkie ja khyanga jumeinak helatsakie cän mceiei u lü, nami yaha mtheimthangnak ning jah hawih hlüsakie nami jah nghlat tak vaia ning jah mtheh veng. ");
INSERT INTO dao_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Acuna mäihe naw mi Bawipa Khritawa khutbi am bi u lü amimäta khawnua phäha khutbikie ni; khyü ktui ja mhläknak ngthu am khyang ngcime jah mhleimhlakie ni. ");
INSERT INTO dao_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Thangkdaw üng nami khäng cun khyang naküta vei a ngthang hüa phäh jekyai veng. Akdaw lama them u lü akse lama pi ngcim ua. ");
INSERT INTO dao_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Dim’yenaka phungnu Pamhnam naw Khawyam cun nami khawa keha mhnüi law khai. Mi Bawipa Jesuha bäkhäknak nami veia ve se. ");
INSERT INTO dao_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Ka khüipüi Timoti, Lucia, Jason, ka Judah khyang püi, Sotihpetae naw ning jah hnukset ve u. ");
INSERT INTO dao_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Hina ca yukia, kei Teratih naw, Bawipa ngming am ning jah hnukset veng. ");
INSERT INTO dao_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Sangcimea ngkhyumnak im, na khinnaki Kajas naw ning jah hnukset ve. Mlüha khawh sämkia Eratuh ja nami na Kawtuh naw ning jah hnukset ve. ");
INSERT INTO dao_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Mi Bawipa Jesuh Khritawa bäkhäknak nami khana ve se. Amen. ");
INSERT INTO dao_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Pamhnam üng hlüngtainak ve se! Ani naw nami jumeinak ning jah khängsak khawhki ni, acuna thangkdaw cun keia sang Jesuh Khritawa mawng, ajana kcün üng ngthup khawikia ngthungtak mdannak ni. ");
INSERT INTO dao_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Sahmaea cauke naw ngthungtak cun angsinga mdan law lü angläta xüngki Pamhnama ngthupet üngkhyüha khyangmjü naküta veia jah ksingsak lü avan naw jum lü ami kcangnak vaia phäh ni. ");
INSERT INTO dao_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Pamhnam amät däk avan ksingnak am bebang lü, Jesuh Khritaw üng angläta hlüngtainak be se. Amen.");
INSERT INTO dao_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Pamhnama hlüeia khü Jesuh Khritawa ngsä, kei Pawluh jah ka na Soten naw, ");
INSERT INTO dao_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Korintuh mlüha vekia Pamhnama sangcime, Khritaw Jesuh üng khyang ngcima kya khaie a jah khüe, hnün naküt üng mi Bawipa Jesuh Khritaw mküimtokie naküta veia; ");
INSERT INTO dao_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Mi Pa, Pamhnam jah Bawipa Jesuh Khritawa veia ka bäkhäknak ja dimdeihnak nami khana ve se. ");
INSERT INTO dao_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Khritaw Jesuh üngkhyüh Pamhnama bäkhäknak aning jah peta phäha Pamhnama veia aläa jenak ka mthehki. ");
INSERT INTO dao_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Khritaw üng yümmat lü ngthu pyennak jah ksingnak üng, amät üng bawimang u lü, nami vea phäha kyaki. ");
INSERT INTO dao_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Acukba Khritaw a ngthu ka ning jah ksingsak nangmi üng khäng lü veki cän ni; ");
INSERT INTO dao_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","A dawkyanak yah lü, mi Bawipa Jesuh Khritawa a ngdannak law vai k'äihei ua. ");
INSERT INTO dao_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Mi Bawipa Jesuh Khritaw a Khaw mhnüp a pha law üng, apäihnak veia ning jah khängsak lü nami mkhye am ve. ");
INSERT INTO dao_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Mi Bawipa kyakia, a Capa Jesuh Khritaw am yümat khaia jah khüikia Pamhnam cun ümnak vai ni. ");
INSERT INTO dao_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ka püie aw, mi Bawipa Jesuh Khritawa ana sumei lü avan ning jah nghüinak ta nami pyen üng ä ti yüm lü nami ksunga ngtainak am ve. Cungaihnak ja ti tängnak üng yüm mat ua. ");
INSERT INTO dao_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Ka püie aw, nami ngcungkaih veki tia mawng cun Kalokuha khui im k