﻿USE sofia;
DROP TABLE IF EXISTS sofia.dan1931_vpl;
CREATE TABLE dan1931_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dan1931_vpl WRITE;
INSERT INTO dan1931_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","I Begyndelsen skabte Gud Himmelen og Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Og Jorden var øde og tom, og der var Mørke over Verdensdybet. Men Guds Ånd svævede over Vandene. ");
INSERT INTO dan1931_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Og Gud sagde: “Der blive Lys!” Og der blev Lys. ");
INSERT INTO dan1931_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Og Gud så, at Lyset var godt, og Gud satte Skel mellem Lyset og Mørket, ");
INSERT INTO dan1931_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","og Gud kaldte Lyset Dag, og Mørket kaldte han Nat. Og det blev Aften, og det blev Morgen, første Dag. ");
INSERT INTO dan1931_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Derpå sagde Gud: “Der blive en Hvælving midt i Vandene til at skille Vandene ad!” ");
INSERT INTO dan1931_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Og således skete det: Gud gjorde Hvælvingen og skilte Vandet under Hvælvingen fra Vandet over Hvælvingen; ");
INSERT INTO dan1931_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","og Gud kaldte Hvælvingen Himmel. Og det blev Aften, og det blev Morgen, anden Dag. ");
INSERT INTO dan1931_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Derpå sagde Gud: “Vandet under Himmelen samle sig på ét Sted, så det faste Land kommer til Syne!” Og således skete det; ");
INSERT INTO dan1931_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","og Gud kaldte det faste Land Jord, og Stedet, hvor Vandet samlede sig, kaldte han Hav. Og Gud så, at det var godt. ");
INSERT INTO dan1931_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Derpå sagde Gud: “Jorden lade fremspire grønne Urter, der bærer Frø, og Frugttræer, der bærer Frugt med Kærne, på Jorden!” Og således skete det: ");
INSERT INTO dan1931_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Jorden frembragte grønne Urter, der bar Frø, efter deres Arter, og Træer, der bar Frugt med Kærne, efter deres Arter. Og Gud så, at det var godt. ");
INSERT INTO dan1931_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Og det blev Aften, og det blev Morgen, tredje Dag. ");
INSERT INTO dan1931_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Derpå sagde Gud: “Der komme Lys på Himmelhvælvingen til at skille Dag fra Nat, og de skal være til Tegn og til Fastsættelse af Højtider, Dage og År ");
INSERT INTO dan1931_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","og tjene som Lys på Himmelhvælvingen til at lyse på Jorden!” Og således sket det: ");
INSERT INTO dan1931_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gud gjorde de to store Lys, det største til at herske om Dagen, det mindste til at herske om Natten, og Stjernerne; ");
INSERT INTO dan1931_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","og Gud satte dem på Himmelhvælvingen til at lyse på Jorden ");
INSERT INTO dan1931_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","og til at herske over Dagen og Natten og til at skille Lyset fra Mørket. Og Gud så, at det var godt. ");
INSERT INTO dan1931_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Og det blev Aften, og det blev Morgen, fjerde Dag. ");
INSERT INTO dan1931_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Derpå sagde Gud: “Vandet vrimle med en Vrimmel af levende Væsener, og Fugle flyve over Jorden oppe under Himmelhvælvingen!” Og således skete det: ");
INSERT INTO dan1931_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Gud skabte de store Havdyr og den hele Vrimmel af levende Væsener, som Vandet vrimler med, efter deres Arter, og alle vingede Væsener efter deres Arter. Og Gud så, at det var godt. ");
INSERT INTO dan1931_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Og Gud velsignede dem og sagde: “Bliv frugtbare og mangfoldige og opfyld Vandet i Havene, og Fuglene blive mangfoldige på Jorden!” ");
INSERT INTO dan1931_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Og det blev Aften, og det blev Morgen, femte Dag. ");
INSERT INTO dan1931_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Derpå sagde Gud: “Jorden frembringe levende Væsener efter deres Arter: Kvæg, Kryb og vildtlevende Dyr efter deres Arter!” Og således skete det: ");
INSERT INTO dan1931_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Gud gjorde de vildtlevende Dyr efter deres Arter, Kvæget efter dets Arter og alt Jordens Kryb efter dets Arter. Og Gud så, at det var godt. ");
INSERT INTO dan1931_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Derpå sagde Gud: “Lad os gøre Mennesker i vort Billede, så de ligner os, til at herske over Havets Fisk og Himmelens Fugle, Kvæget og alle vildtlevende Dyr på Jorden og alt Kryb, der kryber på Jorden!” ");
INSERT INTO dan1931_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Og Gud skabte Mennesket* i sit Billede; i Guds Billede skabte han det, som Mand og Kvinde skabte han dem; { *se til 1 Mos. 2, 15. Visd. 2, 23. Sir. 17, 3. Matt. 19, 4. Mark. 10, 6. 1 Kor. 11, 7. Ef. 4, 24. Kol. 3, 10. 1 Tim. 2, 13. Jak. 3, 9. } ");
INSERT INTO dan1931_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","og Gud velsignede dem, og Gud sagde til dem: “Bliv frugtbare og mangfoldige og opfyld Jorden, gør eder til Herre over den og hersk over Havets Fisk og Himmelens Fugle, Kvæget og alle vildtlevende Dyr, der rører sig på Jorden!” ");
INSERT INTO dan1931_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Gud sagde fremdeles: “Jeg giver eder alle Urter på hele Jorden, som bærer Frø, og alle Træer, som bærer Frugt med Kærne; de skal være eder til Føde; ");
INSERT INTO dan1931_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","men alle Jordens dyr og alle Himmelens Fugle og alt, hvad der kryber på Jorden, og som har Livsånde, giver jeg alle grønne Urter til Føde.” Og således skete det. ");
INSERT INTO dan1931_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Og Gud så alt, hvad han havde gjort, og se, det var såre godt. Og det blev Aften, og det blev Morgen, sjette Dag. ");
INSERT INTO dan1931_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Således fuldendtes Himmelen og Jorden med al deres Hær. ");
INSERT INTO dan1931_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","På den syvende Dag fuldendte Gud det Værk, han havde udført, og han hvilede på den syvende Dag efter det Værk, han havde udført; ");
INSERT INTO dan1931_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","og Gud velsignede den syvende Dag og helligede den, thi på den hvilede han efter hele sit Værk, det, Gud havde skabt og udført. ");
INSERT INTO dan1931_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Det er Himmelens og Jordens Skabelseshistorie. Da Gud HERREN* gjorde Jord og Himmel - { *gengivelse af Jahve, Navnet på Israels Gud; Gud hedder på hebr. Elohim. } ");
INSERT INTO dan1931_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","dengang fandtes endnu ingen af Markens Buske på Jorden, og endnu var ingen af Markens Urter spiret frem, thi Gud HERREN havde ikke ladet det regne på Jorden, og der var ingen Mennesker til at dyrke Agerjorden, ");
INSERT INTO dan1931_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","men en Tåge* vældede op at Jorden og vandede hele Agerjordens Flade - { *den græske overs. har: Kilde. } ");
INSERT INTO dan1931_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","da dannede Gud HERREN Mennesket af Agerjordens Muld og blæste Livsånde i hans Næsebor, så at Mennesket blev et levende Væsen. ");
INSERT INTO dan1931_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Derpå plantede Gud HERREN en Have i Eden ude mod Øst, og der satte han Mennesket, som han havde dannet; ");
INSERT INTO dan1931_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Og Gud HERREN lod af Agerjorden fremvokse alle Slags Træer, en Fryd at skue og gode til Føde, desuden Livets Træ, der stod midt i Haven. og Træet til Kundskab om godt og ondt. ");
INSERT INTO dan1931_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Der udsprang en Flod i Eden til at vande Haven, og udenfor delte den sig i fire Hovedstrømme. ");
INSERT INTO dan1931_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Den ene hedder Pisjon; den løber omkring Landet Havila, hvor der findes Guld ");
INSERT INTO dan1931_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","og Guldet i det Land er godt, Bdellium og Sjohamsten. ");
INSERT INTO dan1931_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Den anden Flod hedder Gihon; den løber omkring Landet Kusj*. { *sædvanligt Navn på Ætiopien. } ");
INSERT INTO dan1931_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Den tredje Flod hedder Hiddekel*; den løber østen om Assyrien. Den fjerde Flod er Frat**. { *Tigris / **Eufrat. } ");
INSERT INTO dan1931_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Derpå tog Gud HERREN Adam* og satte ham i Edens Have til at dyrke og vogte den. { *betyder Menneske. } ");
INSERT INTO dan1931_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Men Gud HERREN bød Adam: “Af alle Træer i Haven har du Lov at spise, ");
INSERT INTO dan1931_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kun af Træet til Kundskab om godt og ondt må du ikke spise; den Dag du spiser deraf, skal du visselig dø!” ");
INSERT INTO dan1931_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Derpå sagde Gud HERREN: “Det er ikke godt for Mennesket at være ene; jeg vil gøre ham en Medhjælp, som passer til ham!” ");
INSERT INTO dan1931_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Og Gud HERREN dannede af Agerjorden alle Markens Dyr og Himmelens Fugle og førte dem hen til Adam for at se, hvad han vilde kalde dem; thi hvad Adam kaldte de forskellige levende Væsener, det skulde være deres Navn. ");
INSERT INTO dan1931_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adam gav da alt Kvæget, alle Himmelens Fugle og alle Markens Dyr Navne - men til sig selv fandt Adam ingen Medhjælp, der passede til ham. ");
INSERT INTO dan1931_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Så lod Gud HERREN Dvale falde over Adam, og da han var sovet ind, tog han et af hans Ribben og lukkede med Kød i dets Sted; ");
INSERT INTO dan1931_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","og af Ribbenet, som Gud HERREN havde taget af Adam, byggede han en Kvinde og førte hende hen til Adam. ");
INSERT INTO dan1931_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Da sagde Adam: “Denne Gang er det Ben af mine Ben og Kød af mit Kød; hun skal kaldes Kvinde*, thi af Manden er hun taget!” { *på hebr. isja-isj dvs. Mandinde-Mand. } ");
INSERT INTO dan1931_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Derfor forlader en Mand sin Fader og Moder og holder sig til sin Hustru, og de to bliver ét Kød. ");
INSERT INTO dan1931_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Og de var begge nøgne, både Adam og hans Hustru, men de bluedes ikke. ");
INSERT INTO dan1931_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Men Slangen var træskere end alle Markens andre Dyr, som Gud HERREN havde gjort og den sagde til Kvinden: “Mon Gud virkelig ham sagt: I må ikke spise af noget Træ i Haven?” ");
INSERT INTO dan1931_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kvinden svarede: “Vi har Lov at spise af Frugten på Havens Træer; ");
INSERT INTO dan1931_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kun af Frugten fra Træet midt i Haven, sagde Gud, må I ikke spise, ja, I må ikke røre derved, thi så skal I dø!” ");
INSERT INTO dan1931_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Da sagde Slangen til Kvinden: “I skal ingenlunde dø; ");
INSERT INTO dan1931_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","men Gud ved, at når I spiser deraf, åbnes eders Øjne, så I blive som Gud til at kende godt og ondt!” ");
INSERT INTO dan1931_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kvinden blev nu var, at Træet var godt at spise af, en Lyst for Øjnene og godt at få Forstand af; og hun tog af dets Frugt og spiste og gav også sin Mand, der stod hos hende, og han spiste. ");
INSERT INTO dan1931_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Da åbnedes begges Øjne, og de kendte, at de var nøgne. Derfor syede de Figenblade sammen og bandt dem om sig. ");
INSERT INTO dan1931_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Da Dagen blev sval, hørte de Gud HERREN vandre i Haven, og Adam og hans Hustru skjulte sig for ham inde mellem Havens Træer. ");
INSERT INTO dan1931_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Da kaldte Gud HERREN på Adam og råbte: “Hvor er du?” ");
INSERT INTO dan1931_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Han svarede: “Jeg hørte dig i Haven og blev angst, fordi jeg var nøgen, og så skjulte jeg mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Da sagde han: “Hvem fortalte dig, at du var nøgen. Mon du har spist af det Træ, jeg sagde, du ikke måtte spise af?” ");
INSERT INTO dan1931_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adam svarede: “Kvinden, som du satte ved min Side, gav mig af Træet, og så spiste jeg.” ");
INSERT INTO dan1931_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Da sagde Gud HERREN til Kvinde: “Hvad har du gjort!” Kvinden svarede: “Slangen forførte mig, og så spiste jeg.” ");
INSERT INTO dan1931_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Da sagde Gud HERREN til Slangen: “Fordi du har gjort dette, være du forbandet blandt al Kvæget og blandt alle Markens Dyr! På din Bug skal du krybe, og Støv skal du æde alle dit Livs Dage! ");
INSERT INTO dan1931_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Jeg sætter Fjendskab mellem dig og Kvinden, mellem din Sæd og hendes Sæd; den skal knuse dit Hoved, og du skal hugge den i Hælen!” ");
INSERT INTO dan1931_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Til Kvinden sagde han: “Jeg vil meget mangfoldiggøre dit Svangerskabs Møje; med Smerte skal du føde Børn; men til din Mand skal din Attrå være, og han skal herske over dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Og til Adam sagde han: “Fordi du lyttede til din Hustrus Tale og spiste af Træet, som jeg sagde, du ikke måtte spise af, skal Jorden være forbandet for din Skyld; med Møje skal du skaffe dig Føde af den alle dit Livs Dage; ");
INSERT INTO dan1931_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Torn og Tidsel skal den bære dig, og Markens Urter skal være din Føde; ");
INSERT INTO dan1931_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","i dit Ansigts Sved skal du spise dit Brød, indtil du vender tilbage til Jorden; thi af den er du taget; ja, Støv er du, og til Støv skal du vende tilbage!” ");
INSERT INTO dan1931_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Men Adam kaldte sin Hustru Eva, thi hun blev Moder til alt levende*. { *på hebr. Ordspil med Navnet Eva. } ");
INSERT INTO dan1931_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Derpå gjorde Gud HERREN Skindkjortler til Adam og hans Hustru og klædte dem dermed. ");
INSERT INTO dan1931_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Men Gud HERREN sagde: “Se, Mennesket er blevet som en af os til at kende godt og ondt. Nu skal han ikke række Hånden ud og tage også af Livets Træ og spise og leve evindelig!” ");
INSERT INTO dan1931_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Så forviste Gud HERREN ham fra Edens Have, for at han skulde dyrke Jorden, som han var taget af; ");
INSERT INTO dan1931_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","og han drev Mennesket ud, og østen for Edens Have satte han Keruberne med det glimtende Flammesværd til at vogte Vejen til Livets Træ. ");
INSERT INTO dan1931_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam kendte sin Hustru Eva, og hun blev frugtsommelig og fødte Kain; og hun sagde: “Jeg har fået* en Søn med HERRENS Hjælp!” { *på hebr. Ordspil med Navnet Kain. } ");
INSERT INTO dan1931_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Fremdeles fødte hun hans Broder Abel. Abel blev Fårehyrde, Kain Agerdyrker. ");
INSERT INTO dan1931_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Nogen Tid efter bragte Kain HERREN en Offergave af Jordens Frugt, ");
INSERT INTO dan1931_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","medens Abel bragte en Gave af sin Hjords førstefødte og deres Fedme. Og HERREN så til Abel og hans Offergave, ");
INSERT INTO dan1931_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","men til Kain og hans Offergave så han ikke. Kain blev da såre vred og gik med sænket Hoved. ");
INSERT INTO dan1931_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Da sagde HERREN til Kain: “Hvorfor er du vred, og hvorfor går du med sænket Hoved? ");
INSERT INTO dan1931_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Du ved, at når du handler vel, kan du løfte Hovedet frit; men handler du ikke vel, så lurer Synden ved Døren; dens Attrå står til dig, men du skal herske over den!” ");
INSERT INTO dan1931_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Men Kain yppede Kiv med sin Broder Abel; og engang de var ude på Marken, sprang Kain ind på ham og slog ham ihjel. ");
INSERT INTO dan1931_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Da sagde HERREN til Kain: “Hvor er din Broder Abel?” Han svarede: “Det ved jeg ikke; skal jeg vogte min Broder?” ");
INSERT INTO dan1931_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Men han sagde: “Hvad har du gjort! Din Broders Blod råber til mig fra Jorden! ");
INSERT INTO dan1931_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Derfor skal du nu være bandlyst fra Agerjorden, som åbnede sig og tog din Broders Blod af din Hånd! ");
INSERT INTO dan1931_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Når du dyrker Agerjorden, skal den ikke mere skænke dig sin Kraft du skal flakke hjemløs om på Jorden!” ");
INSERT INTO dan1931_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Men Kain sagde til HERREN: “Min Straf er ikke til at bære; ");
INSERT INTO dan1931_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","når du nu jager mig bort fra Agerjorden, og jeg må skjule mig for dit Åsyn og flakke hjemløs om på Jorden, så kan jo enhver, der møder mig, slå mig ihjel!” ");
INSERT INTO dan1931_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Da svarede HERREN: “Hvis Kain bliver slået ihjel, skal han hævnes; syvfold!” Og HERREN satte et Tegn på Kain, for at ingen, der mødte ham, skulde slå ham ihjel. ");
INSERT INTO dan1931_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Så drog Kain bort fra HERRENS Åsyn og slog sig ned i Landet Nod* østen for Eden. { *betyder omflakken, hjemløshed. } ");
INSERT INTO dan1931_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain kendte sin Hustru, og hun blev frugtsommelig og fødte Hanok. Han grundede en By og gav den sin; Søn Hanoks Navn. ");
INSERT INTO dan1931_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hanok fik en Søn Irad; Irad avlede Mehujael; Mehujael avlede Mehujael; og Metusjael avlede Lemek. ");
INSERT INTO dan1931_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek tog sig to Hustruer; den ene hed Ada, den anden Zilla. ");
INSERT INTO dan1931_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada fødte Jabal; han blev Stamfader til dem, der bor i Telte og holder Kvæg; ");
INSERT INTO dan1931_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","hans Broder hed Jubal; han blev Stamfader til alle dem, der spiller på Harpe og Fløjte. ");
INSERT INTO dan1931_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Også Zilla fik en Søn, Tubal-Kajin; han blev Stamfader til alle dem, der smeder Kobber og Jern. Tubal-Kajins Søster var Na'ama. ");
INSERT INTO dan1931_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Og Lemek sagde til sine Hustruer: “Ada og Zilla, hør min Røst, Lemeks Hustruer, lyt til mit Ord: En Mand har jeg dræbt for et Sår, en Dreng for en Skramme! ");
INSERT INTO dan1931_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Blev Kain hævnet syvfold, så hævnes Lemek syv og halvfjerdsindstyve Gange!” ");
INSERT INTO dan1931_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam kendte på ny sin Hustru, og hun fødte en Søn, som hun gav Navnet Set; “thi,” sagde hun, “Gud har sat* mig andet Afkom i Abels Sted, fordi Kain slog ham ihjel!” { *på hebr. Ordspil med Navnet Set. } ");
INSERT INTO dan1931_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set fik også en Søn, som han kaldte Enosj; på den Tid begyndte man at påkalde HERRENS Navn. ");
INSERT INTO dan1931_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dette er Adams Slægtebog. Dengang Gud skabte Mennesket, gjorde han det i Guds Billede; ");
INSERT INTO dan1931_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","som Mand og Kvinde skabte han dem, og han velsignede dem og gav dem Navnet “Menneske”, da de blev skabt. ");
INSERT INTO dan1931_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Da Adam havde levet i 130 År, avlede han en Søn, som var ham lig og i hans Billede, og han kaldte ham Set; ");
INSERT INTO dan1931_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","og efter at Adam havde avlet Set, levede han 800 År og avlede Sønner og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","således blev hans fulde Levetid 930 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Da Set havde levet 105 År, avlede han Enosj; ");
INSERT INTO dan1931_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","og efter at Set havde avlet Enosj, levede han 807 År og avlede Sønner og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","således blev Sets fulde Levetid 912 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Da Enosj havde levet 90 År, avlede han Kenan; ");
INSERT INTO dan1931_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","og efter at Enosj havde avlet Kenan, levede han 815 År og avlede Sønner og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","således blev Enosjs fulde Levetid 905 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Da Kenan havde levet 70 År, avlede han Mahalal'el; ");
INSERT INTO dan1931_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","og efter at Kenan havde avlet Mahalal'el, levede han 840 År og avlede Sønner og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","således blev Kenans fulde Levetid 910 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Da Mahalal'el havde levet 65 År, avlede han Jered; ");
INSERT INTO dan1931_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","og efter at Mahalal'el havde avlet Jered, levede han 830 År og avlede Sønner. og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","således blev Mahalal'els fulde Levetid 895 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Da Jered havde levet 162 År, avlede han Enok; ");
INSERT INTO dan1931_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","og efter at Jered havde avlet Enok, levede han 800 År og avlede Sønner og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","således blev Jereds fulde Levetid 962 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Da Enok havde levet 65 År, avlede han Metusalem, ");
INSERT INTO dan1931_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","og Enok vandrede med Gud; og efter at han havde avlet Metusalem, levede han 300 År og avlede Sønner og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","således blev Enoks fulde Levetid 365 År; ");
INSERT INTO dan1931_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","og Enok vandrede med Gud, og han var ikke mere, thi Gud tog ham. ");
INSERT INTO dan1931_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Da Metusalem havde levet 187 År, avlede han Lemek; ");
INSERT INTO dan1931_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","og efter at Metusalem havde avlet Lemek, levede han 782 År og avlede Sønner og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","således blev Metusalems fulde Levetid 969 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Da Lemek havde levet 182 År, avlede han en Søn, ");
INSERT INTO dan1931_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","som han gav Navnet Noa, idet, han sagde: “Han skal skaffe os Trøst* i vort møjefulde Arbejde med Jorden, som HERREN har forbandet.” { *på hebr. Ordspil med Navnet Noa. } ");
INSERT INTO dan1931_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Og efter at Lemek havde avlet Noa, levede han 595 År og avlede Sønner og Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","således blev Lemeks fulde Levetid 777 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Da Noa var 500 År gammel, avlede han Sem, Kam og Jafet. ");
INSERT INTO dan1931_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Da nu Menneskene begyndte at blive talrige på Jorden og der fødtes dem Døtre, ");
INSERT INTO dan1931_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","fik Gudssønnerne Øje på Menneskedøtrenes Skønhed, og de tog: så mange af dem, som de lystede, til Hustruer. ");
INSERT INTO dan1931_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Da sagde HERREN: “Min Ånd: skal ikke for evigt blive i Menneskene, eftersom de jo dog er Kød; deres Dage skal være 120 År.” ");
INSERT INTO dan1931_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","I hine Dage, da Gudssønnerne gik ind til Menneskedøtrene og disse fødte dem Børn men også senere hen i Tiden - levede Kæmperne på Jorden. Det er Heltene, hvis Ry når tilbage til Fortids Dage. ");
INSERT INTO dan1931_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Men HERREN så, at Menneskenes, Ondskab tog til på Jorden, og at deres Hjerters Higen og Tragten kun var ond Dagen lang. ");
INSERT INTO dan1931_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Da angrede HERREN, at han havde gjort Menneskene på Jorden, og det. skar ham i Hjertet. ");
INSERT INTO dan1931_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Og HERREN sagde: “Jeg vil udslette Menneskene, som jeg har skabt, af Jordens Flade, både Mennesker, Kvæg, Kryb og Himmelens, Fugle, thi jeg angrer, at jeg gjorde dem!” ");
INSERT INTO dan1931_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Men Noa fandt Nåde for HERRENS Øjne. ");
INSERT INTO dan1931_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dette er Noas Slægtebog. Noa var en retfærdig, ustraffelig Mand blandt sine samtidige; Noa vandrede med Gud. ");
INSERT INTO dan1931_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa avlede tre Sønner: Sem, Kam og Jafet. ");
INSERT INTO dan1931_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Men Jorden fordærvedes for Guds Øjne, og Jorden blev fuld af Uret; ");
INSERT INTO dan1931_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","og Gud så til Jorden, og se, den var fordærvet, thi alt Kød havde fordærvet sin Vej på Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Da sagde Gud til Noa: “Jeg har besluttet at gøre Ende på alt Kød, fordi Jorden ved deres Skyld et fuld af Uret; derfor vil jeg nu udrydde dem af Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Men du skal gøre dig en Ark af Gofertræ og indrette den med Rum ved Rum og overstryge den med Beg både indvendig og udvendig; ");
INSERT INTO dan1931_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","og således skal du bygge Arken: Den skal være 300 Alen lang, 50 Alen bred og 30 Alen høj; ");
INSERT INTO dan1931_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","du skal anbringe Taget på Arken, og det skal ikke rage længer ud end én Alen fra oven; på Arkens Side skal du sætte Døren, og du skal indrette den med et nederste, et mellemste og et øverste Stokværk. ");
INSERT INTO dan1931_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Se, jeg bringer nu Vandfloden over Jorden for at udrydde alt Kød under Himmelen, som har Livsånde; alt, hvad der er på Jorden, skal forgå. ");
INSERT INTO dan1931_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Men jeg vil oprette min Pagt med dig. Du skal gå ind i Arken med dine Sønner, din Hustru og dine Sønnekoner: ");
INSERT INTO dan1931_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","og af alle Dyr, af alt Kød skal du bringe et Par af hver Slags ind i Arken for at holde dem i Live hos dig. Han og Hundyr skal det være, ");
INSERT INTO dan1931_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","af Fuglene efter deres Arter, af Kvæget efter dets Arter og af alt Jordens Kryb efter dets Arter; Par for Par skal de gå ind til dig for at holdes i Live. ");
INSERT INTO dan1931_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Og du skal indsamle et Forråd af alle Slags Levnedsmidler, for at det kan tjene dig og dem til Føde.” ");
INSERT INTO dan1931_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Og Noa gjorde ganske som Gud havde pålagt ham; således gjorde han. ");
INSERT INTO dan1931_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Derpå sagde HERREN til Noa: “Gå ind i Arken med hele dit Hus, thi dig har jeg fundet retfærdig for mine Øjne i denne Slægt. ");
INSERT INTO dan1931_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Af alle rene Dyr skal du tage syv Par, Han og Hun, og af alle urene Dyr ét Par, Han og Hun, ");
INSERT INTO dan1931_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ligeledes af Himmelens Fugle syv Par, Han og Hun, for at de kan forplante sig på hele Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Thi om syv Dage vil jeg lade det regne på Jorden i fyrretyve Dage og fyrretyve Nætter og udslette alle Væsener, som jeg har gjort, fra Jordens Flade.” ");
INSERT INTO dan1931_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Og Noa gjorde ganske som HERREN havde pålagt ham. ");
INSERT INTO dan1931_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa var 600 År gammel, da Vandfloden kom over Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa gik med sine Sønner, sin Hustru og sine Sønnekoner ind i Arken for at undslippe Flodens Vande. ");
INSERT INTO dan1931_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","De rene og de urene Dyr, Fuglene og alt, hvad der kryber på Jorden, ");
INSERT INTO dan1931_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","gik Par for Par ind i Arken til Noa, Han og Hundyr, som Gud havde pålagt Noa. ");
INSERT INTO dan1931_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Da nu syv Dage var omme, kom Flodens Vande over Jorden; ");
INSERT INTO dan1931_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","i Noas 600de Leveår på den syttende Dag i den anden Måned, den Dag brast det store Verdensdybs Kilder, og Himmelens Sluser åbnedes, ");
INSERT INTO dan1931_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","og Regnen faldt over Jorden i fyrretyve Dage og fyrretyve Nætter. ");
INSERT INTO dan1931_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Selv samme Dag gik Noa ind i Arken og med ham hans Sønner Sem, Kam og Jafet, hans Hustru og hans tre Sønnekoner ");
INSERT INTO dan1931_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","og desuden alle vildtlevende Dyr efter deres Arter, alt Kvæg efter dets Arter, alt Kryb på Jorden efter dets Arter og alle Fugle efter deres Arter, alle Fugle, alt, hvad der har Vinger; ");
INSERT INTO dan1931_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","af alt Kød, som har Livsånde, gik Par for Par ind i Arken til Noa; ");
INSERT INTO dan1931_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Han og Hundyr af alt Kød gik ind, som Gud havde påbudt, og HERREN lukkede efter ham. ");
INSERT INTO dan1931_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Da kom Vandfloden over Jorden i fyrretyve Dage, og Vandet steg og løftede Arken, så den hævedes over Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Og Vandet steg og stod højt over Jorden, og Arken flød på Vandet; ");
INSERT INTO dan1931_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","og Vandet steg og steg over Jorden, så de højeste Bjerge under Himmelen stod under Vand; ");
INSERT INTO dan1931_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","femten Alen stod Vandet over dem, så Bjergene stod helt under Vand. ");
INSERT INTO dan1931_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Da omkom alt Kød, som rørte sig på Jorden, Fugle, Kvæg, vildtlevende Dyr og alt Kryb på Jorden og alle Mennesker; ");
INSERT INTO dan1931_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","alt, i hvis Næse det var Livets Ånde, alt, hvad der var på det faste Land, døde. ");
INSERT INTO dan1931_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Således udslettedes alle Væsener, der var på Jordens Flade, Mennesker, Kvæg, Kryb og Himmelens Fugle; de udslettedes af Jorden, og tilbage blev kun Noa og de, der var hos ham i Arken. ");
INSERT INTO dan1931_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Vandet steg over Jorden i 150 Dage. ");
INSERT INTO dan1931_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Da ihukom Gud Noa og alle de vilde Dyr og Kvæget, som var hos ham i Arken; og Gud lod en Storm fare hen over Jorden, så at Vandet begyndte at falde; ");
INSERT INTO dan1931_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Verdensdybets Kilder og Himmelens Sluser lukkedes, Regnen fra Himmelen standsede, ");
INSERT INTO dan1931_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","og Vandet veg lidt efter lidt bort fra Jorden, og Vandet tog af efter de 150 Dages Forløb. ");
INSERT INTO dan1931_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","På den syttende Dag i den syvende Måned sad Arken fast på Ararats Bjerge, ");
INSERT INTO dan1931_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","og Vandet vedblev at synke indtil den tiende Måned, og på den første Dag i denne Måned dukkede Bjergenes Toppe frem. ");
INSERT INTO dan1931_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Da der var gået fyrretyve Dage: åbnede Noa den Luge, han havde lavet på Arken, ");
INSERT INTO dan1931_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","og sendte en Ravn ud; den fløj frem og tilbage, indtil Vandet var tørret bort fra Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Da sendte han en Due ud for at se, om Vandet var sunket fra Jordens Overflade; ");
INSERT INTO dan1931_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","men Duen fandt intet Sted at sætte sin Fod og vendte tilbage til ham i Arken, fordi der endnu var Vand over hele Jorden; og han rakte Hånden ud og tog den ind i Arken til sig. ");
INSERT INTO dan1931_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Derpå biede han yderligere syv Dage og sendte så atter Duen ud fra Arken; ");
INSERT INTO dan1931_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ved Aftenstid kom Duen tilbage til ham, og se, den havde et friskt Olieblad i Næbbet. Da skønnede Noa, at Vandet var svundet bort fra Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Derpå biede han syv Dage til, og da han så sendte Duen ud, kom den ikke mere tilbage til ham. ");
INSERT INTO dan1931_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","I Noas 601ste Leveår på den første Dag i den første Måned var Vandet tørret bort fra Jorden. Da tog Noa Dækket af Arken, og da han så sig om, se, da var Jordens Overflade tør. ");
INSERT INTO dan1931_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","På den syv og tyvende Dag i den anden Måned var Jorden tør. ");
INSERT INTO dan1931_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Da sagde Gud til Noa: ");
INSERT INTO dan1931_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Gå ud af Arken med din Hustru, dine Sønner og dine Sønnekoner ");
INSERT INTO dan1931_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","og for alle Dyr, der er hos dig, alt Kød, Fugle, Kvæg og alt Kryb, der kryber på Jorden, ud med dig, at de kan vrimle på Jorden og blive frugtbare og mangfoldige på Jorden!” ");
INSERT INTO dan1931_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Da gik Noa ud med sine Sønner, sin Hustru og sine Sønnekoner; ");
INSERT INTO dan1931_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","og alle de vildtlevende Dyr, alt Kvæget, alle Fuglene og alt Krybet, der kryber på Jorden, efter deres Slægter, gik ud af Arken. ");
INSERT INTO dan1931_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Derpå byggede Noa HERREN et Alter og tog nogle af alle de rene Dyr og Fugle og ofrede Brændofre på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Og da HERREN indåndede den liflige Duft, sagde han til sig selv: “Jeg vil aldrig mere forbande Jorden for Menneskenes Skyld, thi Menneskehjertets Higen er ond fra Ungdommen af, og jeg vil aldrig mere tilintetgøre alt, hvad der lever, således som jeg nu har gjort! ");
INSERT INTO dan1931_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Herefter skal, så længe Jorden står, Sæd og Høst, Kulde og Hede, Sommer og Vinter, Dag og Nat ikke ophøre!” ");
INSERT INTO dan1931_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Derpå velsignede Gud Noa og hans Sønner og sagde til dem: “Bliv frugtbare og mangfoldige og opfyld Jorden! ");
INSERT INTO dan1931_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Frygt for eder og Rædsel for eder skal være over alle Jordens vildtlevende Dyr og alle Himmelens Fugle og i alt, hvad Jorden vrimler med, og i alle Havets Fisk; i eders Hånd er de givet! ");
INSERT INTO dan1931_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Alt, hvad der rører sig og lever, skal tjene eder til Føde; ligesom de grønne Urter giver jeg eder det alt sammen. ");
INSERT INTO dan1931_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Dog Kød med Sjælen, det er Blodet, må I ikke spise! ");
INSERT INTO dan1931_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Men for eders eget Blod kræver jeg Hævn; af ethvert Dyr kræver jeg Hævn for det, og af Menneskene indbyrdes kræver jeg Hævn for Menneskenes Liv. ");
INSERT INTO dan1931_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Om nogen udøser Menneskers Blod, ved Mennesker skal hans Blod udøses, thi i sit Billede gjorde Gud Menneskene. ");
INSERT INTO dan1931_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Men I skal blive frugtbare og mangfoldige! Opfyld Jorden og gør eder til Herre over den!” ");
INSERT INTO dan1931_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Derpå sagde Gud til Noa og hans Sønner: ");
INSERT INTO dan1931_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Se, jeg opretter min Pagt med eder og eders Efterkommere efter eder ");
INSERT INTO dan1931_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","og med hvert levende Væsen, som er hos eder, Fuglene, Kvæget og alle Jordens vildtlevende Dyr, alt, hvad der gik ud af Arken, alle Jordens Dyr; ");
INSERT INTO dan1931_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","jeg opretter min Pagt med eder og lover, at aldrig mere skal alt Kød udryddes af Flodens Vande, og aldrig mere skal der komme en Vandflod for at ødelægge Jorden!” ");
INSERT INTO dan1931_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Fremdeles sagde Gud: “Dette er Tegnet på den Pagt, jeg til evige Tider opretter mellem mig og eder og hvert levende Væsen, som er hos eder: ");
INSERT INTO dan1931_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Min Bue sætter jeg i Skyen, og den skal være Pagtstegn mellem mig og Jorden! ");
INSERT INTO dan1931_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Når jeg trækker Skyer sammen over Jorden, og Buen da viser sig i Skyerne, ");
INSERT INTO dan1931_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","vil jeg komme den Pagt i Hu, som består mellem mig og eder og hvert levende Væsen, det er alt Kød, og Vandet skal ikke mere blive til en Vandflod, som ødelægger alt Kød. ");
INSERT INTO dan1931_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Når Buen da står i Skyerne, vil jeg se hen til den og ihukomme den evige Pagt mellem Gud og hvert levende Væsen, det er alt Kød på Jorden.” ");
INSERT INTO dan1931_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Og Gud sagde til Noa: “Det er Tegnet på den Pagt, jeg opretter imellem mig og alt Kød på Jorden!” ");
INSERT INTO dan1931_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noas Sønner, der gik ud af Arken, var Sem, Kam og Jafet; Kam var Fader til Kana'an; ");
INSERT INTO dan1931_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","det var Noas tre Sønner, og fra dem stammer hele Jordens Befolkning. ");
INSERT INTO dan1931_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa var Agerdyrker og den første, der plantede en Vingård. ");
INSERT INTO dan1931_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Da han nu drak af Vinen, blev han beruset og blottede sig inde i, sit Telt. ");
INSERT INTO dan1931_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Da så Kana'ans Fader Kam sin Faders Blusel og gik ud og fortalte sine Brødre det; ");
INSERT INTO dan1931_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","men Sem og Jafet tog Kappen, lagde den på deres Skuldre og gik baglæns ind og tildækkede deres Faders Blusel med bortvendte Ansigter, så de ikke så deres Faders Blusel. ");
INSERT INTO dan1931_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Da Noa vågnede af sin Rus og fik at vide, hvad hans yngste Søn havde gjort ved ham, ");
INSERT INTO dan1931_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","sagde han: “Forbandet være Kana'an, Trælles Træl blive han for sine Brødre!” ");
INSERT INTO dan1931_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Fremdeles sagde han: “Lovet være HERREN, Sems Gud, og Kana'an blive hans* Træl! { *eller: deres. } ");
INSERT INTO dan1931_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Gud skaffe Jafet Plads*, at han må bo i Sems Telte; og Kana'an blive hans** Træl!” { *på hebr. Ordspil med Navnet Jafet. / **eller: deres } ");
INSERT INTO dan1931_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noa levede 350 År efter Vandfloden; ");
INSERT INTO dan1931_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","således blev Noas fulde Levetid 950 År, og derpå døde han. ");
INSERT INTO dan1931_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dette er Noas Sønner, Sem, Kam og Jafets Slægtebog. Efter Vandfloden fødtes der dem Sønner. ");
INSERT INTO dan1931_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafets Sønner: Gomer, Magog. Madaj, Javan, Tubal, Mesjek og Tiras. ");
INSERT INTO dan1931_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomers Sønner: Asjkenaz, Rifat og Togarma. ");
INSERT INTO dan1931_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javans Sønner: Elisja, Tarsis. Kittæerne og Rodosboerne; ");
INSERT INTO dan1931_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","fra dem nedstammer de fjerne Strandes Folk. Det var Jafets Sønner i deres Lande, hver med sit Tungemål, efter deres Slægter og i deres Folkeslag. ");
INSERT INTO dan1931_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kams Sønner: Kusj*, Mizrajim*, Put og Kana'an. { *dvs. Ætiopien. / **dvs. Ægypten. } ");
INSERT INTO dan1931_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusj's Sønner: Seba, Havila, Sabta, Ra'ma og Sabteka. Ra'mas Sønner: Saba og Dedan. ");
INSERT INTO dan1931_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Og Kusj avlede Nimrod, som var den første Storhersker på Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Han var en vældig Jæger for HERRENS Øjne; derfor siger man: “En vældig Jæger for HERRENS Øjne som Nimrod.” ");
INSERT INTO dan1931_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Fra først af omfattede hans Rige Babel, Erek, Akkad og Kalne i Sinear; ");
INSERT INTO dan1931_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","fra dette Land drog han til Assyrien og byggede Nineve, Rehobot-Ir, Kela ");
INSERT INTO dan1931_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","og Resen mellem Nineve og Kela, det er den store By. ");
INSERT INTO dan1931_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizrajim avlede Luderne, Anamerne, Lehaberne, Naftuherne, ");
INSERT INTO dan1931_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patruserne, Kasluherne, fra hvem Filisterne udgik, og Kaftorerne. ");
INSERT INTO dan1931_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kana'an avlede Zidon, hans førstefødte, Het, ");
INSERT INTO dan1931_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebusitterne, Amoritterne, Girgasjitterne, ");
INSERT INTO dan1931_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivvitterne, Arkitterne, Sinitterne, ");
INSERT INTO dan1931_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvaditterne, Zemaritterne og Hamatitterne; men senere bredte Kana'anæernes Slægter sig, ");
INSERT INTO dan1931_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","så at Kana'anæernes Område strakte sig fra Zidon i Retning af Gerar indtil Gaza, i Retning af Sodoma, Gomorra, Adma, og Zebojim indtil Lasja. ");
INSERT INTO dan1931_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Det var Kams Sønner efter deres Slægter og Tungemål i deres Lande og Folk. ");
INSERT INTO dan1931_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Men også Sem, alle Ebersønnernes Fader*, Jafets ældste Broder, fødtes der Sønner. { *dvs. Hebræerne. } ");
INSERT INTO dan1931_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sems Sønner: Elam, Assur, Arpaksjad, Lud og Aram. ");
INSERT INTO dan1931_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arams Sønner: Uz, Hul, Geter og Masj. ");
INSERT INTO dan1931_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksjad avlede Sjela; Sjela avlede Eber; ");
INSERT INTO dan1931_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber fødtes der to Sønner; den ene hed Peleg*, thi på hans Tid adsplittedes Jordens Befolkning, og hans Broder hed Joktan. { *betyder Spittelse. } ");
INSERT INTO dan1931_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan avlede Almodad, Sjelef, Hazarmavet, Jera, ");
INSERT INTO dan1931_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO dan1931_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Saba, ");
INSERT INTO dan1931_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila og Jobab. Alle disse var Joktans Sønner, ");
INSERT INTO dan1931_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","og deres Bosteder strækker sig fra Mesja i Retning af Sefar, Østens Bjerge. ");
INSERT INTO dan1931_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Det var Sems Sønner efter deres Slægter og Tungemål i deres Lande og Folk. ");
INSERT INTO dan1931_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Det var Noas Sønners Slægter efter deres Nedstamning, i deres Folk; fra dem nedstammer Folkene, som efter Vandfloden bredte sig på Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hele Menneskeheden havde ét Tungemål og samme Sprog. ");
INSERT INTO dan1931_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Da de nu drog østerpå, traf de på en Dal i Sinear, og der slog de sig ned. ");
INSERT INTO dan1931_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Da sagde de til hverandre: “Kom, lad os stryge Teglsten og brænde dem godt!” De brugte nemlig Tegl som Sten og Jordbeg som Kalk. ");
INSERT INTO dan1931_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Derpå sagde de: “Kom, lad os bygge os en By og et Tårn, hvis Top når til Himmelen, og skabe os et Navn, for at vi ikke skal spredes ud over hele Jorden!” ");
INSERT INTO dan1931_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Men HERREN steg ned for at se Byen og Tårnet, som Menneskebørnene byggede, ");
INSERT INTO dan1931_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","og han sagde: “Se, de er ét Folk og har alle ét Tungemål; og når de nu først er begyndt således, er intet, som de sætter sig for, umuligt for dem; ");
INSERT INTO dan1931_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","lad os derfor stige ned og forvirre deres Tungemål der, så de ikke forstår hverandres Tungemål!” ");
INSERT INTO dan1931_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Da spredte HERREN dem fra det Sted ud over hele Jorden, og de opgav at bygge Byen. ");
INSERT INTO dan1931_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Derfor kaldte man den Babel, thi der forvirrede* HERREN al Jordens Tungemål, og derfra spredte HERREN dem ud over hele Jorden. { *på hebr. Ordspil med Navnet Babel. } ");
INSERT INTO dan1931_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dette er Sems Slægtebog. Da Sem var 100 År gammel, avlede han Arpaksjad, to År efter Vandfloden; ");
INSERT INTO dan1931_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","og efter at Sem havde avlet Arpaksjad, levede han 500 År og avlede Sønner og Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Da Arpaksjad havde levet 35 År, avlede han Sjela; ");
INSERT INTO dan1931_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","og efter at Arpaksjad havde avlet Sjela, levede han 403 År og avlede Sønner og Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Da Sjela havde levet 30 År, avlede han Eber; ");
INSERT INTO dan1931_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","og efter at Sjela havde avlet Eber, levede han 403 År og avlede Sønner og Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Da Eber havde levet 34 År, avlede han Peleg; ");
INSERT INTO dan1931_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","og efter at Eber havde avlet Peleg, levede han 430 År og avlede Sønner og Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Da Peleg havde levet 30 År, avlede han Re'u; ");
INSERT INTO dan1931_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","og efter at Peleg havde avlet Re'u, levede han 209 År og avlede Sønner og Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Da Re'u havde levet 32 År, avlede han Serug; ");
INSERT INTO dan1931_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","og efter at Re'u havde avlet Serug, levede han 207 År og avlede Sønner og Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Da Serug havde levet 30 År, avlede han Nakor; ");
INSERT INTO dan1931_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","og efter at Serug havde avlet Nakor, levede han 200 År og avlede Sønner og Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Da Nakor havde levet 29 År, avlede han Tara; ");
INSERT INTO dan1931_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","og efter at Nakor havde avlet Tara, levede han 119 År og avlede Sønner og Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Da Tara havde levet 70 År, avlede han Abram, Nakor og Haran. ");
INSERT INTO dan1931_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Dette er Taras Slægtebog. Tara avlede Abram, Nakor og Haran. Haran avlede Lot. ");
INSERT INTO dan1931_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran døde i sin Fader Taras Levetid i sin Hjemstavn i Ur Kasdim. ");
INSERT INTO dan1931_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram og Nakor tog sig Hustruer; Abrams Hustru hed Saraj, Nakors Milka, en Datter af Haran, Milkas og Jiskas Fader. ");
INSERT INTO dan1931_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Men Saraj var ufrugtbar og havde ingen Børn. ");
INSERT INTO dan1931_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tara tog sin Søn Abram, sin Sønnesøn Lot, Harans Søn, og sin Sønnekone Saraj, hans Søn Abrams Hustru, og førte dem fra Ur Kasdim for at begive sig til Kana'ans Land; men da de kom til Karan, slog de sig ned der. ");
INSERT INTO dan1931_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taras Levetid var 205 År; og Tara døde i Karan. ");
INSERT INTO dan1931_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","HERREN sagde til Abram: “Drag ud fra dit Land, fra din Slægt og din Faders Hus til det Land, jeg vil vise dig; ");
INSERT INTO dan1931_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","så vil jeg gøre dig til et stort Folk, og jeg vil velsigne dig og gøre dit Navn stort. og vær en Velsignelse! ");
INSERT INTO dan1931_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Jeg vil velsigne dem, der velsigner dig, og forbande dem, der forbander dig; i dig skal alle Jordens Slægter velsignes!”* { *eller med dig skal alle Jordens Slægter velsigne sig. } ");
INSERT INTO dan1931_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Og Abram gik, som HERREN sagde til ham, og Lot gik med ham. Abram var fem og halvfjerdsindstyve År, da han drog fra Karan; ");
INSERT INTO dan1931_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","og Abram tog sin Hustru Saraj og sin Brodersøn Lot og al den Ejendom, de havde samlet sig, og de Folk, de havde vundet sig i Karan, og de gav sig på Vej til Kana'ans Land og nåede derhen. ");
INSERT INTO dan1931_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Derpå drog Abram gennem Landet til Sikems hellige Sted, til Sandsigerens Træ. Det var dengang Kana'anæerne boede i Landet. ");
INSERT INTO dan1931_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Men HERREN åbenbarede sig for Abram og sagde til ham: “Dit Afkom giver jeg dette Land!” Da byggede han der et Alter for HERREN. som havde åbenbaret sig for ham. ");
INSERT INTO dan1931_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Derpå brød han op derfra og drog til Bjergene østen for Betel, og han slog Lejr med Betel mod Vest og Aj mod Øst; og han byggede HERREN et Alter der og påkaldte HERRENS Navn. ");
INSERT INTO dan1931_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Derpå drog Abram fra Plads til Plads og nåede Sydlandet. ");
INSERT INTO dan1931_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Der opstod Hungersnød i Landet; og da Hungersnøden i Landet blev trykkende, drog Abram ned til Ægypten for at bo der som fremmed. ");
INSERT INTO dan1931_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Da han nu nærmede sig Ægypten, sagde han til sin Hustru Saraj: “Jeg ved jo, at du er en smuk Kvinde; ");
INSERT INTO dan1931_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","når nu Ægypterne ser dig, og de mener, at du er min Hustru, slår de mig ihjel og lader dig leve; ");
INSERT INTO dan1931_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","sig derfor, at du er min Søster, for at det må gå mig godt, og jeg ikke skal miste Livet for din Skyld!” ");
INSERT INTO dan1931_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Da han så drog ind i Ægypten, så Ægypterne, at hun var en såre smuk Kvinde; ");
INSERT INTO dan1931_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","og Faraos Stormænd, der så hende, priste hende for Farao, og så blev Kvinden ført til Faraos Hus. ");
INSERT INTO dan1931_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Men Abram behandlede han godt for hendes Skyld, og han fik Småkvæg, Hornkvæg og Æsler, Trælle og Trælkvinder, Aseninder og Kameler. ");
INSERT INTO dan1931_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Men HERREN ramte Farao og hans Hus med svære Plager for Abrams Hustru Sarajs Skyld. ");
INSERT INTO dan1931_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Da lod Farao Abram kalde og sagde: “Hvad har du gjort imod mig! Hvorfor lod du mig ikke vide, at hun er din Hustru? ");
INSERT INTO dan1931_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Hvorfor sagde du, at hun var din Søster, så at jeg tog hende til Hustru? Se, her har du nu din Hustru, tag hende og gå bort!” ");
INSERT INTO dan1931_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Og Farao bød sine Mænd følge ham og hans Hustru og al deres Ejendom på Vej; ");
INSERT INTO dan1931_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","og Abram drog atter med sin Hustru og al sin Ejendom fra Ægypten op til Sydlandet, og Lot drog med ham. ");
INSERT INTO dan1931_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram var meget rig på kvæghjorde, Sølv og Guld; ");
INSERT INTO dan1931_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","og han vandrede fra Lejrplads til Lejrplads og nåede fra Sydlandet til Betel, til det Sted, hvor hans Teltlejr havde stået første Gang, mellem Betel og Aj, ");
INSERT INTO dan1931_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","til det Sted, hvor han forrige Gang havde rejst et Alter; og Abram påkaldte der HERRENS Navn. ");
INSERT INTO dan1931_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Og Lot, der drog med Abram, ejede ligeledes Småkvæg, Hornkvæg og Telte. ");
INSERT INTO dan1931_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Men Landet formåede ikke at rumme dem, så de kunde bo sammen; thi deres Hjorde var for store til, at de kunde bo sammen. ");
INSERT INTO dan1931_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Da opstod der Strid mellem Abrams og Lots Hyrder; det var dengang Kana'anæerne og Perizzitterne boede i Landet. ");
INSERT INTO dan1931_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram sagde derfor til Lot: “Der må ikke være Strid mellem os to eller mellem mine og dine Hyrder, vi er jo Frænder! ");
INSERT INTO dan1931_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ligger ikke hele Landet dig åbent? Skil dig hellere fra mig; vil du til venstre, så går jeg til højre, og vil du til højre, så går jeg til venstre!” ");
INSERT INTO dan1931_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Da så Lot sig omkring, og da han så, at hele Jordanegnen (det var før HERREN ødelagde Sodoma og Gomorra) var vandrig som HERRENS Have, som Ægyptens Land, hen ad Zoar til, ");
INSERT INTO dan1931_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","valgte han sig hele Jordanegnen. Så brød Lot op og drog østerpå, og de skiltes, ");
INSERT INTO dan1931_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","idet Abram slog sig ned i Kana'ans Land, medens Lot slog sig ned i Jordanegnens Byer og drog med sine Telte fra Sted til Sted helt hen til Sodoma. - ");
INSERT INTO dan1931_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Men Mændene i Sodoma var ugudelige og store Syndere mod HERREN. ");
INSERT INTO dan1931_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Efter at Lot havde skilt sig fra Abram, sagde HERREN til denne: “Løft dit Blik og se dig om der, hvor du står, mod Nord, mod Syd, mod Øst og mod Vest; ");
INSERT INTO dan1931_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","thi hele det Land, du ser, vil jeg give dig og dit Afkom til evig Tid, ");
INSERT INTO dan1931_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","og jeg vil gøre dit Afkom som Jordens Støv, så at det lige så lidt skal kunne tælles, som nogen kan tælle Jordens Støv. ");
INSERT INTO dan1931_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Drag nu gennem Landet på Kryds og tværs, thi dig giver jeg det!” ");
INSERT INTO dan1931_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Så drog Abram fra Sted til Sted med sine Telte og kom til Mamres Lund i Hebron, hvor han slog sig ned og byggede HERREN et Alter. ");
INSERT INTO dan1931_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Dengang Amrafel var Konge i Sinear, Arjok i Ellasar, Kedorlaomer i Elam og Tid'al i Gojim. ");
INSERT INTO dan1931_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","lå de i Krig med Kong Bera af Sodoma, Kong Birsja af Gomorra, Kong Sjin'ab af Adma, Kong Sjem'eber af Zebojim og Kongen i Bela, det et Zoar. ");
INSERT INTO dan1931_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Alle disse havde slået sig sammen og var rykket frem til Siddims Dal, det er Salthavet*. { *dvs. Det døde Hav. } ");
INSERT INTO dan1931_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","I tolv År havde de stået under Kedorlaomer, men i det trettende faldt de fra; ");
INSERT INTO dan1931_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","og i det fjortende År kom Kedorlaomer og de Konger, som fulgte ham. Først slog de Refaitterne i Asjtarot-Karnajim, Zuzitterne i Ham, Emitterne i Sjave-Kirjatajim ");
INSERT INTO dan1931_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","og Horitterne i Se'irs Bjerge hen ad El-Paran til ved Ørkenens Rand; ");
INSERT INTO dan1931_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","så vendte de om og drog til Misjpatkilden, det er Kadesj, og slog Amalekitterne i hele deres Område og ligeså de Amoriter, der boede i Hazazon-Tamar. ");
INSERT INTO dan1931_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Da drog Sodomas, Gomorras, Admas, Zebojims og Belas, det er Zoars, Konger ud og indlod sig i Siddims Dal i Kamp ");
INSERT INTO dan1931_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","med Kong Kedorlaomer af Elam, Kong Tid'al af Gojim, Kong Amrafel af Sinear og Kong Arjok af Ellasar, fire Konger mod fem. ");
INSERT INTO dan1931_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Men Siddims Dal var fuld af Jordbeggruber; og da Sodomas og Gomorras Konger blev slået på Flugt, styrtede de i dem, medens de, der blev tilbage, flyede op i Bjergene. ");
INSERT INTO dan1931_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Så tog Fjenden alt Godset i Sodoma og Gomorra og alle Levnedsmidlerne og drog bort; ");
INSERT INTO dan1931_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ligeledes tog de, da de drog bort, Abrams Brodersøn Lot og alt hans Gods med sig; thi han boede i Sodoma. ");
INSERT INTO dan1931_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Men en Flygtning kom og meldte det til Hebræeren Abram, der boede ved den Lund, som tilhørte Amoriten Mamre, en Broder til Esjkol og Aner, der ligesom han var Abrams Pagtsfæller. ");
INSERT INTO dan1931_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Da nu Abram hørte, at hans Frænde var taget til Fange, mønstrede han sine Husfolk, de hjemmefødte Trælle, 318 Mand, og satte efter Fjenden til Dan; ");
INSERT INTO dan1931_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","der faldt han og hans Trælle over dem om Natten, slog dem på Flugt og forfulgte dem op til Hoba norden for Damaskus. ");
INSERT INTO dan1931_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Derefter bragte han alt Godset tilbage; også sin Frænde Lot og hans Gods førte han tilbage og ligeledes Kvinderne og Folket. ");
INSERT INTO dan1931_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Da han nu kom tilbage fra Sejren over Kedorlaomer og de Konger, der fulgte ham, gik Sodomas Konge ham i Møde i Sjavedalen, det er Kongedalen. ");
INSERT INTO dan1931_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Men Salems Konge Melkizedek, Gud den Allerhøjestes Præst*, bragte Brød og Vin { *på hebr. El eljon. } ");
INSERT INTO dan1931_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","og velsignede ham med de Ord: “Priset være Abram for Gud den Allerhøjeste, Himmelens og Jordens Skaber, ");
INSERT INTO dan1931_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","og priset være Gud den Allerhøjeste, der gav dine Fjender i din Hånd!” Og Abram gav ham Tiende af alt. ");
INSERT INTO dan1931_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodomas Konge sagde derpå til Abram: “Giv mig Menneskene og behold selv Godset!” ");
INSERT INTO dan1931_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Men Abram svarede Sodomas Konge: “Til HERREN, Gud den Allerhøjeste, Himmelens og Jordens Skaber, løfter jeg min Hånd på, ");
INSERT INTO dan1931_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","at jeg ikke vil tage så meget som en Tråd eller en Sandalrem eller overhovedet noget som helst af din Ejendom; du skal ikke sige, at du har gjort Abram rig! ");
INSERT INTO dan1931_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Jeg vil intet have - kun hvad de unge Mænd har fortæret, og mine Ledsagere, Aner, Esjkol og Mamres Del, lad dem få deres Del!” ");
INSERT INTO dan1931_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nogen Tid efter kom HERRENS Ord til Abram i et Syn således: “Frygt ikke, Abram, jeg er dit Skjold; din Løn skal blive såre stor!” ");
INSERT INTO dan1931_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Men Abram svarede: “Herre*, HERRE, hvad kan du give mig, når jeg dog går barnløs bort, og en Mand fra Damaskus, Eliezer, skal arve mit Hus.” { *på hebr. Adonaj. } ");
INSERT INTO dan1931_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Og Abram sagde: “Du har jo intet Afkom givet mig, og se, min Hustræl kommer til at arve mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Og se, HERRENS Ord kom til ham således: “Han kommer ikke til at arve dig, men den, der udgår af dit Liv, han skal arve dig.” ");
INSERT INTO dan1931_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Derpå førte han ham ud i det fri og sagde: “Se op mod Himmelen og prøv, om du kan tælle Stjernerne!” Og han sagde til ham: “Således skal dit Afkom blive!” ");
INSERT INTO dan1931_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Da troede Abram HERREN, og han regnede ham det til Retfærdighed. ");
INSERT INTO dan1931_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Derpå sagde han til ham: “Jeg er HERREN, som førte dig bort fra Ur-Kasdim for at give dig dette Land i Eje!” ");
INSERT INTO dan1931_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Men han svarede: “Herre, HERRE, hvorpå kan jeg kende, at jeg skal få det i Eje?” ");
INSERT INTO dan1931_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Da sagde han til ham: “Tag mig en treårs Kvie, en treårs Ged og en treårs Væder, en Turteldue og en Småfugl!” ");
INSERT INTO dan1931_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Så tog han alle disse Dyr skar dem midt over og lagde Halvdelene over for hinanden; dog skar han ikke Fuglene over. ");
INSERT INTO dan1931_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Da slog der Rovfugle ned på de døde Kroppe, men Abram skræmmede dem bort. ");
INSERT INTO dan1931_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Da Solen så var ved at gå ned, faldt der Dvale over Abram, og se, Rædsel faldt over ham, et stort Mørke. ");
INSERT INTO dan1931_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Og han sagde til Abram: “Vide skal du, at dit Afkom skal bo som fremmede i et Land, der ikke er deres eget; de skal trælle for dem og mishandles af dem i 400 År. ");
INSERT INTO dan1931_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Dog vil jeg også dømme det Folk, de kommer til at trælle for, og siden skal de vandre ud med meget Gods. ");
INSERT INTO dan1931_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Men du skal fare til dine Fædre i Fred og blive jordet i en god Alderdom. ");
INSERT INTO dan1931_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","I fjerde Slægtled skal de vende tilbage hertil; thi endnu er Amoritternes Syndeskyld ikke fuldmoden.” ");
INSERT INTO dan1931_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Da Solen var gået ned og Mørket faldet på, viste der sig en rygende Ovn med en flammende Ildslue, der skred frem mellem de sønderskårne Kroppe. ");
INSERT INTO dan1931_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","På den Dag sluttede HERREN Pagt med Abram, idet han sagde: “Dit Afkom giver jeg dette Land fra Ægyptens Bæk til den store Flod, Eufratfloden, ");
INSERT INTO dan1931_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","det er Kenitterne, Kenizzitterne, Kadmonitterne, ");
INSERT INTO dan1931_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hetitterne, Perizzitterne, Refaitterne, ");
INSERT INTO dan1931_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoritterne, Kana'anæerne, Girgasjitterne, Hivvitterne og Jebusitterne.” ");
INSERT INTO dan1931_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abrams Hustru Saraj fødte ham intet Barn. Men Saraj havde en Ægyptisk Trælkvinde ved Navn Hagar; ");
INSERT INTO dan1931_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","og Saraj sagde til Abram: “HERREN har jo nægtet mig Børn; gå derfor ind til min Trælkvinde, måske kan jeg få en Søn ved hende!” Og Abram adlød Saraj. ");
INSERT INTO dan1931_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Så tog Abrams Hustru Saraj sin Trælkvinde, Ægypterinden Hagar, efter at Abram havde boet ti År i Kana'ans Land, og gav sin Mand Abram hende til Hustru; ");
INSERT INTO dan1931_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","og han gik ind til Hagar, og hun blev frugtsommelig. Men da hun så, at hun var frugtsommelig, lod hun hånt om sin Herskerinde. ");
INSERT INTO dan1931_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Da sagde Saraj til Abram: “Min Krænkelse komme over dig! Jeg lagde selv min Trælkvinde i din Favn, og nu hun ser, at hun skal føde, lader hun hånt om mig; HERREN være Dommer mellem mig og dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram svarede Saraj: “Din Trælkvinde er i din Hånd, gør med hende, hvad du finder for godt!” Da plagede Saraj hende, så hun flygtede for hende. ");
INSERT INTO dan1931_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Men HERRENS Engel fandt hende ved Vandkilden i Ørkenen, ved Kilden på Vejen til Sjur; ");
INSERT INTO dan1931_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","og han sagde: “Hvorfra kommer du, Hagar, Sarajs Trælkvinde, og hvor går du hen?” Hun svarede: “Jeg flygter for min Herskerinde Saraj!” ");
INSERT INTO dan1931_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Da sagde HERRENS Engel til hende: “Vend tilbage til din Herskerinde og find dig i hendes Mishandling!” ");
INSERT INTO dan1931_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Og HERRENS Engel sagde til hende: “Jeg vil gøre dit Afkom så talrigt, at det ikke kan tælles.” ");
INSERT INTO dan1931_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Og HERRENS Engel sagde til hende: “Se, du er frugtsommelig, og du skal føde en Søn, som du skal kalde Ismael*, thi HERREN har hørt, hvad du har lidt; { *dvs. Gud hører. } ");
INSERT INTO dan1931_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","og han skal blive et Menneske Vildæsel, hvis Hånd er mod alle, og alles Hånd mod ham, og han skal ligge i Strid med alle sine Frænder!” ");
INSERT INTO dan1931_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Så gav hun HERREN, der havde talet til hende, Navnet: Du er en Gud, som ser*; thi hun sagde: “Har jeg virkelig her set et Glimt af ham, som ser mig?” { *på hebr. El ro'i. } ");
INSERT INTO dan1931_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Derfor kaldte man Brønden Be'er-lahaj-ro'i*; den ligger mellem Kadesj og Bered. { *dvs. Brønden for den Levende, som ser mig. } ");
INSERT INTO dan1931_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Og Hagar fødte Abram en Søn, og Abram kaldte Sønnen, Hagar fødte ham, Ismael. ");
INSERT INTO dan1931_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram var seks og firsindstyve År gammel, da Hagar fødte ham Ismael. ");
INSERT INTO dan1931_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Da Abram var ni og halvfemsindstyve År gammel, åbenbarede HERREN sig for ham og sagde til ham: “Jeg er Gud den Almægtige; vandre for mit Åsyn og vær ustraffelig, ");
INSERT INTO dan1931_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","så vil jeg oprette min Pagt mellem mig og dig og give dig et overvættes stort Afkom!” ");
INSERT INTO dan1931_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Da faldt Abram på sit Ansigt, og Gud sagde til ham: ");
INSERT INTO dan1931_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Fra min Side er min Pagt med dig, at du skal blive Fader til en Mængde Folk; ");
INSERT INTO dan1931_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","derfor skal dit Navn ikke mere være Abram, men du skal hedde Abraham, thi jeg gør dig til Fader til en Mængde Folk*. { *på hebr. Ordspil med Navnet Abraham. } ");
INSERT INTO dan1931_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Jeg vil gøre dig overvættes frugtbar og lade dig blive til Folk, og Konger skal nedstamme fra dig. ");
INSERT INTO dan1931_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Jeg opretter min Pagt mellem mig og dig og dit Afkom efter dig fra Slægt til Slægt, og det skal være en evig Pagt, at jeg vil være din Gud og efter dig dit Afkoms Gud; ");
INSERT INTO dan1931_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","og jeg giver dig og dit Afkom efter dig din Udlændigheds Land, hele Kana'ans Land, til evigt Eje, og jeg vil være deres Gud!” ");
INSERT INTO dan1931_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Derpå sagde Gud til Abraham: “Men du på din Side skal holde min Pagt, du og dit Afkom efter dig fra Slægt til Slægt; ");
INSERT INTO dan1931_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","og dette er min Pagt, som I skal holde, Pagten mellem mig og eder, at alt af Mandkøn hos eder skal omskæres. ");
INSERT INTO dan1931_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","I skal omskæres på eders Forhud, det skal være et Pagtstegn mellem mig og eder; ");
INSERT INTO dan1931_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","otte Dage gamle skal alle af Mandkøn omskæres hos eder i alle kommende Slægter, både de hjemmefødte Trælle og de, som er købt, alle fremmede, som ikke hører til dit Afkom; ");
INSERT INTO dan1931_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","omskæres skal både dine hjemmefødte og dine købte. Min Pagt på eders Legeme skal være en evig Pagt! ");
INSERT INTO dan1931_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Men de uomskårne, det af Mandkøn, der ikke Ottendedagen omskæres på Forhuden, de skal udryddes af deres Folk; de har brudt min Pagt!” ");
INSERT INTO dan1931_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Endvidere sagde Gud til Abraham: “Din Hustru Saraj skal du ikke mere kalde Saraj, hendes Navn skal være Sara*; { *dvs. Herskerinde. } ");
INSERT INTO dan1931_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","jeg vil velsigne hende og give dig en Søn også ved hende; jeg vil velsigne hende, og hun skal blive til Folk, og Folkeslags Konger skal nedstamme fra hende!” ");
INSERT INTO dan1931_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Da faldt Abraham på sit Ansigt og lo, idet han tænkte: “Kan en hundredårig få Børn, og kan Sara med sine halvfemsindstyve År føde en Søn?” ");
INSERT INTO dan1931_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham sagde derfor til Gud: “Måtte dog Ismael leve for dit Åsyn!” ");
INSERT INTO dan1931_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Men Gud sagde: “Nej, din Ægtehustru Sara skal føde dig en Søn, som du skal kalde Isak*; med ham vil jeg oprette min Pagt, og det skal være en evig Pagt, der skal gælde hans Afkom efter ham! { *dvs. han ler (V. 17.) } ");
INSERT INTO dan1931_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Men hvad Ismael angår, har jeg bønhørt* dig: jeg vil velsigne ham og gøre ham frugtbar og give ham et overvættes talrigt Afkom; tolv Stammehøvdinger skal han avle, og jeg vil gøre ham til et stort Folk. { *se til 1 Mos. 16, 11; 25, 13 ff. } ");
INSERT INTO dan1931_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Men min Pagt opretter jeg med Isak, som Sara skal føde dig om et År ved denne Tid.” ");
INSERT INTO dan1931_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Så hørte han op at tale med ham; og Gud steg op fra Abraham. ");
INSERT INTO dan1931_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Da tog Abraham sin Søn Ismael og alle sine hjemmefødte og de købte, alt af Mandkøn i Abrahams Hus, og omskar selv samme Dag deres Forhud, således som Gud havde pålagt ham. ");
INSERT INTO dan1931_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham var ni og halvfemsindstyve År, da han blev omskåret på sin Forhud; ");
INSERT INTO dan1931_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","og hans Søn Ismael var tretten År, da han blev omskåret på sin Forhud. ");
INSERT INTO dan1931_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Selv samme Dag blev Abraham og hans Søn Ismael omskåret; ");
INSERT INTO dan1931_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","og alle Mænd i hans Hus, både de hjemmefødte og de, der var købt, de fremmede, blev omskåret tillige med ham. ");
INSERT INTO dan1931_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Siden åbenbarede HERREN sig for ham ved Mamres Lund, engang han sad i Teltdøren på den hedeste Tid af Dagen. ");
INSERT INTO dan1931_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Da han så op, fik han Øje på tre Mænd, der stod foran ham. Så snart han fik Øje på dem, løb han dem i Møde fra Teltdøren, bøjede sig til Jorden ");
INSERT INTO dan1931_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","og sagde: “Herre, hvis jeg har fundet Nåde for dine Øjne, så gå ikke din Træl forbi! ");
INSERT INTO dan1931_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Lad der blive hentet lidt Vand, så I kan tvætte eders Fødder og hvile ud under Træet. ");
INSERT INTO dan1931_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Så vil jeg bringe et Stykke Brød, for at I kan styrke eder; siden kan I drage videre - da eders Vej nu engang har ført eder forbi eders Træl!” De svarede: “Gør, som du siger!” ");
INSERT INTO dan1931_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Da skyndte Abraham sig ind i Teltet til Sara og sagde: “Tag hurtigt tre Mål fint Mel, ælt det og bag Kager deraf!” ");
INSERT INTO dan1931_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Så ilede han ud til Kvæget, tog en fin og lækker Kalv og gav den til Svenden, og han tilberedte den i Hast. ");
INSERT INTO dan1931_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Derpå tog han Surmælk og Sødmælk og den tilberedte Kalv, satte det for dem og gik dem til Hånde under Træet, og de spiste. ");
INSERT INTO dan1931_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Da sagde de til ham: “Hvor er din Hustru Sara?” Han svarede: “Inde i Teltet!” ");
INSERT INTO dan1931_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Så sagde han: “Næste År ved denne Tid kommer jeg til dig igen, og så har din Hustru Sara en Søn!” Men Sara lyttede i Teltdøren bag ved dem; ");
INSERT INTO dan1931_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","og da Abraham og Sara var gamle og højt oppe i Årene, og det ikke mere gik Sara på Kvinders Vis, ");
INSERT INTO dan1931_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","lo hun ved sig selv og tænkte: “Skulde jeg virkelig føle Attrå. nu jeg er affældig, og min Herre er gammel?” ");
INSERT INTO dan1931_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Da sagde HERREN til Abraham: “Hvorfor ler Sara og tænker: Skulde jeg virkelig føde en Søn. nu jeg er gammel? ");
INSERT INTO dan1931_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Skulde noget være umuligt for Herren? Næste År ved denne Tid kommer jeg til dig igen, og så har Sara en Søn!” ");
INSERT INTO dan1931_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Men Sara nægtede og sagde: “Jeg lo ikke!” Thi hun frygtede. Men han sagde: “Jo, du lo!” ");
INSERT INTO dan1931_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Så brød Mændene op derfra hen ad Sodoma til, og Abraham gik med for at følge dem på Vej. ");
INSERT INTO dan1931_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Men HERREN sagde ved sig selv: “Skulde jeg vel dølge for Abraham, hvad jeg har i Sinde at gøre. ");
INSERT INTO dan1931_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","da Abraham dog skal blive til et stort og mægtigt Folk, og alle Jordens Folk skal velsignes i ham? ");
INSERT INTO dan1931_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Jeg har jo udvalgt ham, for at han skal pålægge sine Børn og sine Efterkommere at vogte på HERRENS Vej ved at øve Retfærdighed og Ret, for at HERREN kan give Abraham alt, hvad han har forjættet ham.” ");
INSERT INTO dan1931_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Da sagde HERREN: “Sandelig. Skriget over Sodoma og Gomorra er stort, og deres Synd er såre svar. ");
INSERT INTO dan1931_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Derfor vil jeg stige ned og se. om de virkelig har handlet så galt. som det lyder til efter Skriget over dem, der har nået mig - derom vil jeg have Vished!” ");
INSERT INTO dan1931_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Da vendte Mændene sig bort derfra og drog ad Sodoma til; men HERREN blev stående foran Abraham. ");
INSERT INTO dan1931_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Og Abraham trådte nærmere og sagde: “Vil du virkelig udrydde retfærdige sammen med gudløse? ");
INSERT INTO dan1931_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Måske findes der halvtredsindstyve retfærdige i Byen; vil du da virkelig udrydde dem og ikke tilgive Stedet for de halvtredsindstyve retfærdiges Skyld, som findes derinde. ");
INSERT INTO dan1931_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Det være langt fra dig at handle således: at ihjelslå retfærdige sammen med gudløse, så de retfærdige får samme Skæbne som de gudløse - det være langt fra dig! Skulde den, der dømmer hele Jorden, ikke selv øve Ret?” ");
INSERT INTO dan1931_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Da sagde HERREN: “Dersom jeg finder halvtredsindstyve retfærdige i Sodoma, i selve Byen, vil jeg for deres Skyld tilgive hele Stedet!” ");
INSERT INTO dan1931_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Men Abraham tog igen til Orde: “Se, jeg har dristet mig til at tale til min Herre, skønt jeg kun er Støv og Aske! ");
INSERT INTO dan1931_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Måske mangler der fem i de halvtredsindstyve retfærdige - vil du da ødelægge hele Byen for fems Skyld?” Han svarede: “Jeg vil ikke ødelægge Byen, hvis jeg finder fem og fyrretyve i den.” ");
INSERT INTO dan1931_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Men han blev ved at tale til ham: “Måske findes der fyrretyve i den!” Han. svarede: “For de fyrretyves Skyld vil jeg lade det være.” ");
INSERT INTO dan1931_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Men han sagde: “Min Herre må ikke blive vred, men lad mig tale: Måske findes der tredive i den!” Han svarede: “Jeg skal ikke gøre det, hvis jeg finder tredive i den.” ");
INSERT INTO dan1931_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Men han sagde: “Se, jeg har dristet mig til at tale til min Herre: Måske findes de tyve i den!” Han svarede: “For de tyves Skyld vil jeg lade være at ødelægge den.” ");
INSERT INTO dan1931_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Men han sagde: “Min Herre må ikke blive vred, men lad mig kun tale denne ene Gang endnu; måske findes der ti i den!” Han svarede: “For de tis Skyld vil jeg lade være at ødelægge den.” ");
INSERT INTO dan1931_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Da nu HERREN havde talt ud med Abraham, gik han bort; og Abraham vendte tilbage til sin Bolig. ");
INSERT INTO dan1931_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","De to Engle kom nu til Sodoma ved Aftenstid. Lot sad i Sodomas Port, og da han fik Øje på dem, stod han op og gik dem i Møde, bøjede sig til Jorden ");
INSERT INTO dan1931_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","og sagde: “Kære Herrer, tag dog ind og overnat i eders Træls Hus og tvæt eders Fødder; i Morgen tidlig kan I drage videre!” Men de sagde: “Nej, vi vil overnatte på Gaden.” ");
INSERT INTO dan1931_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Da nødte han dem stærkt, og de tog ind i hans Hus; derpå tilberedte han dem et Måltid og bagte usyrede Kager, og de spiste. ");
INSERT INTO dan1931_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Men endnu før de havde lagt sig, stimlede Byens Folk, Indbyggerne i Sodoma, sammen omkring Huset, både gamle og unge, alle uden Undtagelse, ");
INSERT INTO dan1931_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","og de råbte til Lot: “Hvor er de Mænd, der kom til dig i Nat Kom herud med dem, for at vi kan stille vor Lyst på dem!” ");
INSERT INTO dan1931_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Da gik Lot ud til dem i Porten, men Døren lukkede han efter sig. ");
INSERT INTO dan1931_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Og han sagde: “Gør dog ikke noget ondt, mine Brødre! ");
INSERT INTO dan1931_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Se, jeg har to Døtre, der ikke har kendt Mand; dem vil jeg bringe ud til eder, og med dem kan I gøre, hvad I lyster; men disse Mænd må I ikke gøre noget, siden de nu engang er kommet ind under mit Tags Skygge!” ");
INSERT INTO dan1931_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Men de sagde: “Bort med dig! Her er den ene Mand kommet og bor som fremmed, og nu vil han spille Dommer! Kom, lad os handle værre med ham end med dem!” Og de trængte ind på Manden, på Lot, og nærmede sig Døren for at sprænge den. ");
INSERT INTO dan1931_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Da rakte Mændene Hånden ud og trak Lot ind til sig og lukkede Døren; ");
INSERT INTO dan1931_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","men Mændene uden for Porten til Huset slog de med Blindhed, både store og små, så de forgæves søgte at finde Porten. ");
INSERT INTO dan1931_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Derpå sagde Mændene til Lot: “Hvem der ellers hører dig til her, dine Svigersønner, dine Sønner og Døtre, alle, som hører dig til i Byen, må du føre bort fra dette Sted; ");
INSERT INTO dan1931_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","thi vi står i Begreb med at ødelægge Stedet her, fordi Skriget over dem er blevet så stort for HERREN, at HERREN har sendt os for at ødelægge dem.” ");
INSERT INTO dan1931_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Da gik Lot ud og sagde til sine Svigersønner, der skulde ægte hans Døtre: “Stå op, gå bort herfra, thi HERREN vil ødelægge Byen!” Men hans Svigersønner troede, at han drev Spøg med dem. ");
INSERT INTO dan1931_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Da Morgenen så gryede, skyndede Englene på Lot og sagde: “Tag din Hustru og dine to Døtre, som bor hos dig, og drag bort, for at du ikke skal rives bort ved Byens Syndeskyld!” ");
INSERT INTO dan1931_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Og da han tøvede, greb Mændene ham, hans Hustru og hans to Døtre ved Hånden, thi HERREN vilde skåne ham, og de førte ham bort og bragte ham i Sikkerhed uden for Byen. ");
INSERT INTO dan1931_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Og idet de førte dem uden for Byen, sagde de: “Det gælder dit Liv! Se dig ikke tilbage og stands ikke nogetsteds i Jordanegnen, men red dig op i Bjergene, for at du ikke skal omkomme!” ");
INSERT INTO dan1931_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Men Lot sagde til dem: “Ak nej, Herre! ");
INSERT INTO dan1931_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Din Træl har jo fundet Nåde for dine Øjne, og du har vist mig stor Godhed og frelst mit Liv; men jeg kan ikke nå op i Bjergene og undfly Ulykken; den indhenter mig så jeg mister Livet. ");
INSERT INTO dan1931_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Se, den By der er nær nok til at jeg kan flygte derhen; den betyder jo ikke stort, lad mig redde mig derhen, den betyder jo ikke stort, og mit Liv er frelst!” ");
INSERT INTO dan1931_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Da svarede han: “Også i det Stykke har jeg bønhørt dig; jeg vil ikke ødelægge den By, du nævner; ");
INSERT INTO dan1931_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","men red dig hurtigt derhen, thi jeg kan intet gøre, før du når derhen!” Derfor kaldte man Byen Zoar*. { *dvs. ubetydelighed. } ");
INSERT INTO dan1931_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Da Solen steg op over Landet og Lot var nået til Zoar, ");
INSERT INTO dan1931_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","lod HERREN Svovl og Ild regne over Sodoma og Gomorra fra HERREN, fra Himmelen; ");
INSERT INTO dan1931_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","og han ødelagde disse Byer og hele Jordanegnen og alle Byernes Indbyggere og Landets Afgrøde. ");
INSERT INTO dan1931_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Men hans Hustru, som gik efter ham, så sig tilbage og blev til en Saltstøtte. ");
INSERT INTO dan1931_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Næste Morgen, da Abraham gik hen til det Sted, hvor han havde stået hos HERREN, ");
INSERT INTO dan1931_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","og vendte sit Blik mod Sodoma og Gomorra og hele Jordanegnen. så han Røg stige til Vejrs fra Landet som Røgen fra en Smelteovn. ");
INSERT INTO dan1931_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Da Gud tilintetgjorde Jordanegnens Byer, kom han Abraham i Hu og førte Lot ud af Ødelæggelsen, som han lod komme over de Byer, Lot boede i. ");
INSERT INTO dan1931_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Men Lot drog op fra Zoar og slog sig ned i Bjergene med sine Døtre, thi han turde ikke blive i Zoar; og han boede i en Hule med sine to Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Da sagde den ældste til den yngste: “Vor Fader er gammel, og der findes ingen Mænd her i Landet, som kunde komme til os på vanlig Vis. ");
INSERT INTO dan1931_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kom, lad os give vor Fader Vin at drikke og ligge hos ham for at få Afkom ved vor Fader!” ");
INSERT INTO dan1931_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","De gav ham da Vin at drikke samme Nat; og den ældste lagde sig hos sin Fader, og han sansede hverken, at hun lagde sig, eller at hun stod op. ");
INSERT INTO dan1931_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Næste Dag sagde den ældste til den yngste: “Jeg lå i Går Nat hos min Fader; nu vil vi også give ham Vin at drikke i Nat, og gå du så ind og læg dig hos ham, for at vi kan få Afkom ved vor Fader!” ");
INSERT INTO dan1931_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Så gav de atter den Nat deres Fader Vin at drikke, og den yngste lagde sig hos ham, og han sansede hverken, at hun lagde sig, eller at hun stod op. ");
INSERT INTO dan1931_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Således blev begge Lots Døtre frugtsommelige ved deres Fader; ");
INSERT INTO dan1931_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","og den ældste fødte en Søn, som hun kaldte Moab*; han er Moabs Stamfader den Dag i Dag. { *Ordspil med me'ab, “fra Faderen.” } ");
INSERT INTO dan1931_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ligeså fødte den yngste en Søn, som hun kaldte Ben-Ammi*; han er Ammonitternes Stamfader den Dag i Dag. { *dvs. min Frændes Søn. } ");
INSERT INTO dan1931_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Der På brød Abraham op derfra til Sydlandet og slog sig ned mellem Kadesj og Sjur og boede som fremmed i Gerar. ");
INSERT INTO dan1931_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Da nu Abraham sagde om sin Hustru Sara, at hun var hans Søster, sendte Kong Abimelek af Gerar Bud og lod Sara hente til sig. ");
INSERT INTO dan1931_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Men Gud kom til Abimelek i en Drøm om Natten og sagde til ham: “Se, du skal dø for den Kvindes Skyld, som du har taget, thi hun er en anden Mands Hustru!” ");
INSERT INTO dan1931_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek var imidlertid ikke kommet hende nær; og han sagde: “Herre, vil du virkelig slå retfærdige Folk ihjel? ");
INSERT INTO dan1931_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Har han ikke sagt mig, at hun er hans Søster? Og hun selv har også sagt, at han er hendes Broder; i mit Hjertes Troskyldighed og med rene Hænder har jeg gjort dette.” ");
INSERT INTO dan1931_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Da sagde Gud til ham i Drømmen: “Jeg ved, at du har gjort det i dit Hjertes Troskyldighed, og jeg har også hindret dig i at synde imod mig; derfor tilstedte jeg dig ikke at røre hende. ");
INSERT INTO dan1931_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Men send nu Mandens Hustru tilbage, thi han er en Profet, så han kan gå i Forbøn for dig, og du kan blive i Live; men sender du hende ikke tilbage, så vid, at du og alle dine er dødsens!” ");
INSERT INTO dan1931_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tidligt næste Morgen lod Abimelek alle sine Tjenere kalde og fortalte dem det hele, og Mændene blev såre forfærdede. ");
INSERT INTO dan1931_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Men Abimelek lod Abraham kalde og sagde til ham: “Hvad har du dog gjort imod os? Og hvad har jeg forbrudt imod dig, at du bragte denne store Synd over mig og mit Rige? Du har gjort imod mig, hvad man ikke bør gøre!” ");
INSERT INTO dan1931_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Og Abimelek sagde til Abraham: “Hvad bragte dig til at handle således?” ");
INSERT INTO dan1931_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham svarede: “Jo, jeg tænkte: Her er sikkert ingen Gudsfrygt på dette Sted, så de vil slå mig ihjel for min Hustrus Skyld. ");
INSERT INTO dan1931_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Desuden er hun virkelig min Søster, min Faders Datter, kun ikke min Moders; men hun blev min Hustru. ");
INSERT INTO dan1931_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Og da nu Gud lod mig flakke om fjernt fra min Faders Hus, sagde jeg til hende: Den Godhed må du vise mig, at du overalt, hvor vi kommer hen, siger, at jeg er din Broder.” ");
INSERT INTO dan1931_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Derpå tog Abimelek Småkvæg og Hornkvæg, Trælle og Trælkvinder og gav Abraham dem og sendte hans Hustru Sara tilbage til ham; ");
INSERT INTO dan1931_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","og Abimelek sagde til ham: “Se, mit Land ligger åbent for dig; slå dig ned, hvor du lyster!” ");
INSERT INTO dan1931_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Men til Sara sagde han: “Jeg har givet din Broder 1.000 Sekel Sølv, det skal være dig Godtgørelse for alt, hvad der er tilstødt dig. Hermed har du fået fuld Oprejsning.” ");
INSERT INTO dan1931_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Men Abraham gik i Forbøn hos Gud, og Gud helbredte Abimelek og hans Hustru og Medhustruer, så at de atter fik Børn. ");
INSERT INTO dan1931_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","HERREN havde nemlig lukket for ethvert Moderliv i Abimeleks Hus for Abrahams Hustru Saras Skyld. ");
INSERT INTO dan1931_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","HERREN så til Sara, som han havde lovet, og HERREN gjorde ved Sara, som han havde sagt, ");
INSERT INTO dan1931_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","og hun undfangede og fødte Abraham en Søn i hans Alderdom, til den Tid Gud havde sagt ham. ");
INSERT INTO dan1931_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham kaldte den Søn, han fik med Sara, Isak; ");
INSERT INTO dan1931_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","og Abraham omskar sin Søn Isak, da han var otte Dage gammel, således som Gud havde pålagt ham. ");
INSERT INTO dan1931_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham var 100 År gammel, da hans Søn Isak fødtes ham. ");
INSERT INTO dan1931_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Da sagde Sara: “Gud ham beredt mig Latter*; enhver, der hører det, vil le ad mig.” { *se til 1 Mos. 17, 19. } ");
INSERT INTO dan1931_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Og hun sagde: “Hvem skulde have sagt Abraham, at Sara ammer Børn! Sandelig, jeg har født ham en Søn i hans Alderdom!” ");
INSERT INTO dan1931_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Drengen voksede til og blev vænnet fra, og Abraham gjorde et stort Gæstebud, den dag Isak blev vænnet fra. ");
INSERT INTO dan1931_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Men da Sara så Ægypterinden Hagars Søn, som hun havde født Abraham, lege med hendes Søn Isak, ");
INSERT INTO dan1931_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","sagde hun til Abraham: “Jag den Trælkvinde og hendes Søn bort, thi ikke skal denne Trælkvindes Søn arve sammen med min Søn, med Isak!” ");
INSERT INTO dan1931_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Derover blev Abraham såre ilde til Mode for sin Søns Skyld; ");
INSERT INTO dan1931_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","men Gud sagde til Abraham: “Vær ikke ilde til Mode over Drengen og din Trælkvinde, men adlyd Sara i alt, hvad hun siger dig, thi efter Isak skal dit Afkom nævnes; ");
INSERT INTO dan1931_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","men også Trælkvindens Søn vil jeg gøre til et stort Folk; han er jo dit Afkom!” ");
INSERT INTO dan1931_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tidligt næste Morgen tog da Abraham Brød og en Sæk Vand og gav Hagar det, og Drengen satte han på hendes Skulder, hvorpå han sendte hende bort. Som hun nu vandrede af Sted, for hun vild i Be'ersjebas Ørken, ");
INSERT INTO dan1931_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","og Vandet slap op i hendes Sæk; da lagde hun Drengen hen under en af Buskene ");
INSERT INTO dan1931_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","og gik hen og satte sig i omtrent et Pileskuds Afstand derfra, idet hun sagde ved sig selv: “Jeg kan ikke udholde at se Drengen dø!” Og således sad hun, medens Drengen græd højt. ");
INSERT INTO dan1931_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Da hørte Gud Drengens Gråd, og Guds Engel råbte til Hagar fra Himmelen og sagde til hende: “Hvad fattes dig, Hagar? Frygt ikke, thi Gud har hørt Drengens Røst der, hvor, han ligger; ");
INSERT INTO dan1931_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","rejs dig, hjælp Drengen op og tag ham ved Hånden, thi jeg vil gøre ham til et stort Folk!” ");
INSERT INTO dan1931_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Da åbnede Gud hendes Øjne, så hun fik Øje på en Brønd med Vand; og hun gik hen og fyldte Sækken med Vand og gav Drengen at drikke. ");
INSERT INTO dan1931_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Og Gud var med Drengen, og han voksede til; og han bosatte sig i Ørkenen og blev Bueskytte. ");
INSERT INTO dan1931_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Han boede i Parans Ørken, og hans Moder tog ham en Hustru fra Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ved den Tid sagde Abimelek og hans Hærfører Pikol til Abraham: “Gud er med dig i alt, hvad du tager dig for; ");
INSERT INTO dan1931_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","tilsværg mig derfor her ved Gud, at du aldrig vil være troløs mod mig eller mine Efterkommere, men at du vil handle lige så venligt mod mig og det Land, du gæster, som jeg har handlet mod dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Da svarede Abraham: “Jeg vil sværge!” ");
INSERT INTO dan1931_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Men Abraham krævede Abimelek til Regnskab for en Brønd, som Abimeleks Folk havde tilranet sig. ");
INSERT INTO dan1931_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Da svarede Abimelek: “Jeg ved intet om, hvem der har gjort det; hverken har du underrettet mig derom, ej heller har jeg hørt det før i Dag!” ");
INSERT INTO dan1931_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Da tog Abraham Småkvæg og Hornkvæg og gav Abimelek det, og derpå sluttede de Pagt med hinanden. ");
INSERT INTO dan1931_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Men Abraham satte syv Lam til Side, ");
INSERT INTO dan1931_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","og da Abimelek spurgte ham: “Hvad betyder de syv Lam, du der har sat til Side?” ");
INSERT INTO dan1931_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","svarede han: “Jo, de syv Lam skal du modtage af min Hånd til Vidnesbyrd om, at jeg har gravet denne Brønd.” ");
INSERT INTO dan1931_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Derfor kaldte man dette Sted Be'ersjeba*, thi der svor de hinanden Eder; { *dvs. Edsbrønd eller Syvbrønd. } ");
INSERT INTO dan1931_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","og de sluttede Pagt ved Be'ersjeba. Så brød Abimelek og hans Hærfører Pikol op og vendte tilbage til Filisternes Land. ");
INSERT INTO dan1931_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Men Abraham plantede en Tamarisk i Be'ersjeba og påkaldte der HERREN den evige Guds Navn. ");
INSERT INTO dan1931_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Og Abraham boede en Tid lang; som fremmed i Filisternes Land. ");
INSERT INTO dan1931_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Efter disse Begivenheder satte Gud Abraham på Prøve og sagde til ham: “Abraham!” Han svarede: “Se, her er jeg!” ");
INSERT INTO dan1931_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Da sagde han: “Tag din Søn Isak, din eneste, ham, du elsker, og drag hen til Morija Land og bring ham der som Brændoffer på et af Bjergene, som jeg vil vise dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Da sadlede Abraham tidligt næste Morgen sit Æsel, tog to af sine Drenge og sin Søn Isak med sig, og efter at have kløvet Offerbrænde gav han sig på Vandring; til det Sted, Gud havde sagt ham. ");
INSERT INTO dan1931_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Da Abraham den tredje Dag så. op, fik han Øje på Stedet langt borte. ");
INSERT INTO dan1931_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Så sagde Abraham til sine Drenge: “Bliv her med Æselet, medens jeg og Drengen vandrer der. hen for at tilbede; så kommer vi tilbage til eder.” ");
INSERT INTO dan1931_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham tog da Brændet til Brændofferet og lagde, det på sin Søn Isak; selv tog han Ilden og Offerkniven, og så gik de to sammen. ");
INSERT INTO dan1931_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Da sagde Isak til sin Fader Abraham: “Fader!” Han svarede: “Ja. min Søn!” Da sagde han: “Her er Ilden og Brændet, men hvor er Dyret til Brændofferet?” ");
INSERT INTO dan1931_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham svarede: “Gud vil selv udse sig Dyret til Brændofferet, min Søn!” Og så gik de to sammen. ");
INSERT INTO dan1931_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Da de nåede det Sted, Gud havde sagt ham, byggede Abraham der et Alter og lagde Brændet til Rette; så bandt han sin Søn Isak og lagde ham på Alteret oven på Brændet. ");
INSERT INTO dan1931_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Og Abraham greb Kniven og rakte Hånden ud for at slagte sin Søn. ");
INSERT INTO dan1931_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Da råbte HERRENS Engel til ham fra Himmelen: “Abraham, Abraham!” Han svarede: “Se, her er jeg!” ");
INSERT INTO dan1931_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Da sagde Engelen: “Ræk ikke din Hånd ud mod Drengen og gør ham ikke noget; thi nu ved jeg, at du frygter Gud og end ikke sparer din Søn, din eneste, for mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Og da Abraham nu så op, fik han bag ved sig Øje på en Væder, hvis Horn havde viklet sig ind i de tætte Grene; og Abraham gik hen og tog Vædderen og ofrede den som Brændoffer i sin Søns Sted. ");
INSERT INTO dan1931_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Derfor kaldte Abraham dette Sted: HERREN udser sig, eller, som man nu til dags siger: Bjerget, hvor HERREN viser sig. ");
INSERT INTO dan1931_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Men HERRENS Engel råbte atter til Abraham fra Himmelen: ");
INSERT INTO dan1931_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Jeg sværger ved mig selv, lyder det fra HERREN: Fordi du har gjort dette og ikke sparet din Søn, din eneste, for mig, ");
INSERT INTO dan1931_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","så vil jeg velsigne dig og gøre dit Afkom talrigt som Himmelens Stjerner og Sandet ved Havets Bred; og dit Afkom skal tage sine Fjenders Porte i Besiddelse; ");
INSERT INTO dan1931_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","og i din Sæd skal alle Jordens Folk velsignes, fordi du adlød mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Derpå vendte Abraham tilbage til sine Drenge, og de brød op og tog sammen til Be'ersjeba. Og Abraham blev i Be'ersjeba. ");
INSERT INTO dan1931_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Efter disse Begivenheder meldte man Abraham: “Også Milka har født din Broder Nakor Sønner: ");
INSERT INTO dan1931_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, hans førstefødte, dennes Broder Buz, Kemuel, Arams Fader, ");
INSERT INTO dan1931_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildasj, Jidlaf og Betuel; ");
INSERT INTO dan1931_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel avlede Rebekka; disse otte har Milka født Abrahams Broder Nakor, ");
INSERT INTO dan1931_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","og desuden har hans Medhustru Re'uma født Teba, Gaham, Tahasj og Ma'aka.” ");
INSERT INTO dan1931_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara levede 127 År, så mange var Saras Leveår. ");
INSERT INTO dan1931_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara døde i Kirjat-Arba, det er Hebron, i Kana'ans Land. Så gik Abraham hen og holdt Klage over Sara og begræd hende. ");
INSERT INTO dan1931_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Og da han havde rejst sig fra sin døde, talte han således til Hetitterne: ");
INSERT INTO dan1931_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Jeg er Gæst og fremmed hos eder; men giv mig et Gravsted hos eder, så jeg kan jorde min døde og bringe hende bort fra mit Ansigt!” ");
INSERT INTO dan1931_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Da svarede Hetitterne Abraham: ");
INSERT INTO dan1931_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Hør os, Herre! En Guds Fyrste er du jo iblandt os; jord du din døde i en af vore bedste Grave! Ikke en af os vil nægte dig sin Grav og hindre dig i at jorde din døde.” ");
INSERT INTO dan1931_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Men Abraham stod op og bøjede sig for Hetitterne, Folkene der på Stedet, ");
INSERT INTO dan1931_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","og sagde til dem: “Hvis I samtykker i, at jeg jorder min døde og bringer hende bort fra mit Ansigt, så føj mig i at lægge et godt Ord ind for mig hos Efron, Zohars Søn, ");
INSERT INTO dan1931_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","så han giver mig sin Klippehule i Makpela ved Udkanten af sin Mark; for fuld Betaling skal han i eders Nærværelse give mig den til Gravsted!” ");
INSERT INTO dan1931_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Men Efron sad blandt Hetitterne; og Hetitten Efron svarede Abraham i Hetitternes Påhør, så mange som gik ind gennem hans Bys Port: ");
INSERT INTO dan1931_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Gid min Herre vilde høre mig! Marken giver jeg dig, og Hulen derpå giver jeg dig; i mit Folks Nærværelse giver jeg dig den; jord du kun din døde!” ");
INSERT INTO dan1931_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Da bøjede Abraham sig for Folkene der på Stedet ");
INSERT INTO dan1931_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","og sagde til Efron i deres Påhør: “Om du blot - gid du dog vilde høre mig! Jeg giver dig, hvad Marken er værd; modtag det dog af mig, så jeg kan jorde min døde der.” ");
INSERT INTO dan1931_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Da sagde Efron til Abraham: ");
INSERT INTO dan1931_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Gid min Herre vilde høre mig! Et Stykke Land til 400 Sekel Sølv, hvad har det at sige mellem mig og dig? Jord du kun din døde!” ");
INSERT INTO dan1931_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Og Abraham forstod Efron og tilvejede ham den Sum, han havde nævnet i Hetitternes Påhør, 400 Sekel Sølv i gangbar Mønt. ");
INSERT INTO dan1931_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Således gik Efrons Mark i Makpela over for Mamre i hele sin Udstrækning tillige med Klippehulen og alle Træerne på Marken ");
INSERT INTO dan1931_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","over i Abrahams Eje i Hetitternes Nærværelse, så mange som gik ind gennem hans Bys Port. ");
INSERT INTO dan1931_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Derefter jordede Abraham sin Hustru Sara i Klippehulen på Makpelas Mark over for Mamre, det er Hebron, i Kana'ans Land. ");
INSERT INTO dan1931_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Og Marken med Klippehulen derpå gik fra Hetitterne over til Abraham som Gravsted. ");
INSERT INTO dan1931_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham var blevet gammel og til Års, og HERREN havde velsignet ham i alle Måder. ");
INSERT INTO dan1931_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Da sagde Abraham til sin Træl, sit Hus's ældste, som stod for hele hans Ejendom: “Læg din Hånd under min Lænd, ");
INSERT INTO dan1931_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","så jeg kan tage dig i Ed ved HERREN, Himmelens og Jordens Gud, at du ikke vil tage min Søn en Hustru af Kana'anæernes Døtre. blandt hvem jeg bor, ");
INSERT INTO dan1931_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","men drage til mit Land og min Hjemstavn og tage min Søn Isak en Hustru derfra!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Da sagde Trællen: “Men hvis nu Pigen ikke vil følge mig her til Landet, skal jeg så bringe din Søn tilbage til det Land, du vandrede ud fra?” ");
INSERT INTO dan1931_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham svarede: “Vogt dig vel for at bringe min Søn tilbage dertil! ");
INSERT INTO dan1931_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","HERREN, Himmelens Gud, som tog mig bort fra min Faders Hus og min Hjemstavns Land, som talede til mig og tilsvor mig, at han vil give mit Afkom dette Land, han vil sende sin Engel foran dig, så du kan tage min Søn en Hustru derfra; ");
INSERT INTO dan1931_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","men hvis Pigen ikke vil følge dig, så er du løst fra Eden til mig; men i intet Tilfælde må du bringe min Søn tilbage dertil!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Da lagde Trællen sin Hånd under sin Herre Abrahams Lænd og svor ham Eden. ");
INSERT INTO dan1931_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Derpå tog Trællen ti af sin Herres Kameler og alle Hånde kostbare Gaver fra sin Herre og gav sig på Vej til Nakors By i Aram-Naharajim. ");
INSERT INTO dan1931_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Uden for Byen lod han Kamelerne knæle ved Brønden ved Aftenstid, ved den Tid Kvinderne går ud for at hente Vand; ");
INSERT INTO dan1931_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","og han bad således: “HERRE. du min Herre Abrahams Gud, lad det lykkes for mig i dag og vis Miskundhed mod min Herre Abraham! ");
INSERT INTO dan1931_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Se, jeg stiller mig her ved Vandkilden, nu Bymændenes Døtre går ud for at hente Vand; ");
INSERT INTO dan1931_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","og siger jeg nu til en Pige: Hæld din Krukke og giv mig at drikke! og siger så hun: Drik kun, og jeg vil også give dine Kameler at drikke! lad det da være hende, du har udset til din Tjener Isak; således vil jeg kunne kende, at du har vist Miskundhed mod min Herre!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Knap var han færdig med at bede, se, da kom Rebekka, en Datter af Betuel, der var en Søn af Abrahams Broder Nakors Hustru Milka, gående med Krukken på Skulderen, ");
INSERT INTO dan1931_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","en såre smuk Kvinde, Jomfru, endnu ikke kendt af nogen Mand. Hun steg ned til Kilden, fyldte sin Krukke og steg op igen. ");
INSERT INTO dan1931_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Da ilede Trællen hen til hende og sagde: “Giv mig lidt Vand at drikke af din Krukke!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Hun svarede: “Drik, Herre!” og løftede straks Krukken ned på sin Hånd og lod ham drikke; ");
INSERT INTO dan1931_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","og da hun havde slukket hans Tørst, sagde hun: “Jeg vil også øse Vand til dine Kameler, til de har slukket deres Tørst.” ");
INSERT INTO dan1931_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Så skyndte hun sig hen og tømte Krukken i Truget og løb tilbage til Brønden for at øse, og således øste hun til alle hans Kameler. ");
INSERT INTO dan1931_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Imidlertid stod Manden og så tavs på hende for at få at vide, om HERREN havde ladet hans Rejse lykkes eller ej; ");
INSERT INTO dan1931_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","og da Kamelernes Tørst var slukket, tog han en gylden Næsering, der vejede en halv Sekel, og to Armbånd, der vejede ti Guldsekel, og satte dem på hendes Arme; ");
INSERT INTO dan1931_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","og han sagde til hende: “Sig mig, hvis Datter du er! Er der Plads til os i din Faders Hus for Natten?” ");
INSERT INTO dan1931_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Hun svarede: “Jeg er Datter af Betuel, som Milka fødte Nakor;” ");
INSERT INTO dan1931_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","og videre sagde hun: “Der er rigeligt både af Strå og Foder hos os og Plads til at overnatte!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Da bøjede Manden sig og tilbad HERREN, ");
INSERT INTO dan1931_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","idet han sagde: “Lovet være HERREN, min Herre Abrahams Gud. som ikke har unddraget min Herre sin Miskundhed og Trofasthed! HERREN har ført mig på Vejen til min Herres Broders Hus.” ");
INSERT INTO dan1931_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Pigen løb imidlertid hjem og fortalte alt dette i sin Moders Hus. ");
INSERT INTO dan1931_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Men Rebekka havde en Broder ved Navn Laban; han løb ud til Manden ved Kilden; ");
INSERT INTO dan1931_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","og da han så Næseringen og Armbåndene på sin Søsters Arme og hørte sin Søster Rebekka fortælle, hvad Manden havde sagt til hende, gik han ud til Manden, som stod med sine Kameler ved Kilden; ");
INSERT INTO dan1931_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","og han sagde: “Kom, du HERRENS velsignede, hvorfor står du herude? Jeg har ryddet op i Huset og gjort Plads til Kamelerne.” ");
INSERT INTO dan1931_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Så kom Manden hen til Huset og tog Seletøjet af Kamelerne, og Laban bragte Strå og Foder til dem og Vand til Fodtvæt for Manden og hans Ledsagere. ");
INSERT INTO dan1931_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Men da der blev sat Mad for ham, sagde han: “Jeg vil intet nyde, før jeg har røgtet mit Ærinde!” De svarede: “Sig frem!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Så sagde han: “Jeg er Abrahams Træl. ");
INSERT INTO dan1931_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","HERREN har velsignet min Herre i rigt Mål, så han er blevet en velstående Mand, og givet ham Småkvæg og Hornkvæg, Sølv og Guld, Trælle og Trælkvinder, Kameler og Æsler; ");
INSERT INTO dan1931_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","og Sara, min Herres Hustru, har født ham en Søn i hans Alderdom, og ham har han givet alt, hvad han ejer. ");
INSERT INTO dan1931_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Og nu har min Herre taget mig i Ed og sagt: Du må ikke tage min Søn en Hustru blandt Kana'anæernes Døtre, i hvis Land jeg bor; ");
INSERT INTO dan1931_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Men du skal drage til min Faders Hus og min Slægt og tage min Søn en Hustru derfra! ");
INSERT INTO dan1931_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Og da jeg sagde til min Herre: Men hvis nu Pigen ikke vil følge med mig? ");
INSERT INTO dan1931_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","svarede han: HERREN, for hvis Åsyn jeg har vandret, vil sende sin Engel med dig og lade din Rejse lykkes, så du kan tage min Søn en Hustru af min Slægt og min Faders Hus; ");
INSERT INTO dan1931_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","i modsat Fald er du løst fra Eden til mig; kommer du til min Slægt, og de ikke vil give dig hende, er du løst fra Eden til mig! ");
INSERT INTO dan1931_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Da jeg nu i Dag kom til Kilden, bad jeg således: HERRE, du min Herre Abrahams Gud! Vilde du dog lade den Rejse lykkes, som jeg nu har for! ");
INSERT INTO dan1931_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Se, jeg stiller mig her ved Kilden, og siger jeg nu til den Pige, der kommer for at øse Vand: Giv mig lidt Vand at drikke af din Krukke! ");
INSERT INTO dan1931_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","og svarer så hun: Drik selv, og jeg vil også øse Vand til dine Kameler! lad hende da være den Kvinde, HERREN har udset til min Herres Søn! ");
INSERT INTO dan1931_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Og knap var jeg færdig med at tale således ved mig selv, se, da kom Rebekka med sin Krukke på Skulderen og steg ned til Kilden og øste Vand, og da jeg sagde til hende: Giv mig noget at drikke! ");
INSERT INTO dan1931_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","løftede hun straks sin Krukke ned og sagde: Drik kun, og jeg vil også give dine Kameler at drikke! Så drak jeg, og hun gav også Kamelerne at drikke. ");
INSERT INTO dan1931_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Da spurgte jeg hende: Hvis Datter er du? Og hun sagde: Jeg er Datter af Betuel, Nakors og Milkas Søn! Så satte jeg Ringen i hendes Næse og Armbåndene på hendes Arme; ");
INSERT INTO dan1931_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","og jeg bøjede mig og tilbad HERREN, og jeg lovede HERREN, min Herre Abrahams Gud, som havde ført mig den rigtige Vej, så jeg: kunde tage min Herres Broderdatter til hans Søn! ");
INSERT INTO dan1931_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Hvis I nu vil vise min Herre Godhed og Troskab, så sig mig det, og hvis ikke, så sig mig det. for at jeg kan have noget at rette mig efter!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Da sagde Laban og Betuel: “Denne Sag kommer fra HERREN, vi kan hverken gøre fra eller til! ");
INSERT INTO dan1931_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Der står Rebekka foran dig, tag hende og drag bort, at hun kan: blive din Herres Søns Hustru, således som HERREN har sagt!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Da Abrahams Træl hørte deres Ord, kastede han sig til Jorden for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Derpå fremtog Trællen Sølv og Guldsmykker og Klæder og gav Rebekka dem, og til hendes Broder og Moder uddelte han Gaver. ");
INSERT INTO dan1931_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Så spiste og drak han og hans Ledsagere og overnattede der. Da, de var stået op næste Morgen. sagde han: “Lad mig nu fare til. min Herre!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Men Rebekkas Broder og Moder svarede: “Lad dog Pigen blive hos os i nogen Tid, en halv Snes Dage eller så, siden kan du drage bort!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Da sagde han til dem: “Ophold mig ikke, nu HERREN har ladet min Rejse lykkes; lad mig fare! Jeg vil drage til min Herre!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","De svarede; “Lad os kalde på. Pigen og spørge hende selv!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Og de kaldte på Rebekka og; spurgte hende: “Vil du drage med denne Mand?” Hun svarede: “Ja. jeg vil!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Da tog de Afsked med deres, Søster Rebekka og hendes Amme og med Abrahams Træl og hans Ledsagere; ");
INSERT INTO dan1931_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","og de velsignede Rebekka og sagde: “Måtte du, vor Søster, blive til ti Tusind Tusinder, og måtte dit Afkom indtage dine Fjenders Porte!” ");
INSERT INTO dan1931_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Så brød Rebekka og hendes Piger op, og de satte sig på Kamelerne og fulgte med Manden; og Trællen tog Rebekka og drog bort. ");
INSERT INTO dan1931_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak var imidlertid draget til Ørkenen ved Be'er-lahaj-ro'i, og han boede i Sydlandet. ");
INSERT INTO dan1931_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Da han engang ved Aftenstid var gået ud på Marken for at bede, så han op og fik Øje på nogle Kameler, der nærmede sig. ");
INSERT INTO dan1931_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Men da Rebekka så op og fik Øje på Isak, lod hun sig glide ned af Kamelen ");
INSERT INTO dan1931_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","og spurgte Trællen: “Hvem er den Mand der, som kommer os i Møde på Marken?” Trællen svarede: “Det er min Herre!” Da tog hun sit Slør og tilhyllede sig. ");
INSERT INTO dan1931_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Men Trællen fortalte Isak alt, hvad han havde udrettet. ");
INSERT INTO dan1931_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Da førte Isak Rebekka ind i sin Moder Saras Telt og tog hende til Hustru; og han fik hende kær. Således blev Isak trøstet efter sin Moder. ");
INSERT INTO dan1931_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham tog sig en Hustru, som hed Ketura; ");
INSERT INTO dan1931_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","og hun fødte ham Zimran, Joksjan, Medan, Midjan, Jisjbak og Sjua. ");
INSERT INTO dan1931_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksjan avlede Saba og Dedan. Dedans Sønner var Assjuritterne, Letusjitterne og Le'ummitterne. ");
INSERT INTO dan1931_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midjans Sønner var Efa, Efer, Hanok, Abida og Elda'a. Alle disse var Keturas Sønner. ");
INSERT INTO dan1931_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham gav Isak alt, hvad han ejede; ");
INSERT INTO dan1931_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","men de Sønner, Abraham havde med sine Medhustruer, skænkede han Gaver og sendte dem, medens han endnu levede, bort fra sin Søn Isak, østpå til Østlandet. ");
INSERT INTO dan1931_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","De År, Abraham levede, udgjorde 175; ");
INSERT INTO dan1931_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","så udåndede han. Og Abraham døde i en god Alderdom, gammel og mæt af Dage, og samledes til sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Og hans Sønner Isak og Ismael jordede ham i Makpelas Klippehule på Hetitten Efrons Zohars Søns, Mark over for Mamre, ");
INSERT INTO dan1931_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","den Mark, Abraham havde købt af Hetitterne; der jordedes Abraham og hans Hustru Sara. ");
INSERT INTO dan1931_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Og da Abraham var død, velsignede Gud hans Søn Isak. Isak boede ved Be'er-lahaj-ro'i. ");
INSERT INTO dan1931_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dette er Abrahams Søn Ismaels Slægtebog, hvem Saras Trælkvinde, Ægypterinden Hagar, fødte ham. ");
INSERT INTO dan1931_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Følgende er Navnene på Ismaels Sønner efter deres Navne og Slægter: Nebajot, Ismaels førstefødte, Kedar, Adbe'el, Mibsam, ");
INSERT INTO dan1931_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misjma, Duma, Massa, ");
INSERT INTO dan1931_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafisj og Kedma. ");
INSERT INTO dan1931_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Det var Ismaels Sønner, og det var deres Navne i deres Indhegninger og Teltlejre, tolv Høvdinger med deres Stammer. ");
INSERT INTO dan1931_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaels Leveår udgjorde 137; så udåndede han; han døde og samledes til sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","De havde deres Boliger fra Havila til Sjur over for Ægypten hen ad Assjur til. Lige for Øjnene af alle sine Brødre slog han sig ned. ");
INSERT INTO dan1931_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dette er Abrahams Søn Isaks Slægtebog. Abraham avlede Isak. ");
INSERT INTO dan1931_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak var fyrretyve År gammel, da han tog Rebekka, en Datter af Aramæeren Betuel fra Paddan-Aram og Søster til Aramæeren Laban, til Hustru. ");
INSERT INTO dan1931_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Men Isak bad til HERREN for sin Hustru, thi hun var ufrugtbar; og HERREN bønhørte ham, og Rebekka, hans Hustru, blev frugtsommelig. ");
INSERT INTO dan1931_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Men da Sønnerne brødes i hendes Liv, sagde hun: “Står det således til, hvorfor lever jeg da?” Og hun gik hen for at adspørge HERREN. ");
INSERT INTO dan1931_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Da svarede HERREN hende: “To Folkeslag er i dit Liv, to Folk skal gå ud af dit Skød! Det ene skal kue det andet, den ældste tjene den yngste!” ");
INSERT INTO dan1931_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Da nu Tiden kom, at hun skulde føde, var der Tvillinger i hendes Liv. ");
INSERT INTO dan1931_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Den første kom frem rødlig og lodden som en Skindkappe over hele Kroppen; og de kaldte ham Esau. ");
INSERT INTO dan1931_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Derefter kom hans Broder frem med Hånden om Esaus Hæl*; derfor kaldte de ham Jakob. Isak var tresindstyve År gammel, da de fødtes. { *på hebr. Ordspil med Navnet Jakob. } ");
INSERT INTO dan1931_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Drengene voksede til, og Esau blev en dygtig Jæger, der færdedes i Ødemarken, men Jakob en fredsommelig Mand, en Mand, som boede i Telt. ");
INSERT INTO dan1931_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak holdt mest af Esau, thi han spiste gerne Vildt; men Rebekka holdt mest af Jakob. ");
INSERT INTO dan1931_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jakob havde engang kogt en Ret Mad, da Esau udmattet kom hjem fra Marken. ");
INSERT INTO dan1931_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Da sagde Esau til Jakob: “Lad mig få noget af det røde*, det røde der, thi jeg er ved at dø af Sult!” Derfor kaldte de ham Edom. { *på hebr. Ordspil med Navnet Edom. } ");
INSERT INTO dan1931_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Men Jakob sagde: “Du må først sælge mig din Førstefødselsret!” ");
INSERT INTO dan1931_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau svarede: “Jeg er jo lige ved at omkomme; hvad bryder jeg mig om min Førstefødselsret!” ");
INSERT INTO dan1931_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Men Jakob sagde: “Du må først sværge mig det til!” Da svor Esau på det og solgte sin Førstefødselsret til Jakob. ");
INSERT INTO dan1931_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Så gav Jakob Esau Brød og kogte Linser, og da han havde spist og drukket, stod han op og gik sin Vej. Således lod Esau hånt om sin Førstefødselsret. ");
INSERT INTO dan1931_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Da der opstod Hungersnød i Landet - en anden end den forrige på Abrahams Tid - begav Isak sig til Filisterkongen Abimelek i Gerar. ");
INSERT INTO dan1931_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Og HERREN åbenbarede sig for ham og sagde: “Drag ikke ned til Ægypten, men bliv i det Land, jeg siger dig; ");
INSERT INTO dan1931_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","bo som fremmed i det Land, så vil jeg være med dig og velsigne dig; thi dig og dit Afkom vil jeg give alle disse Lande og stadfæste den Ed, jeg tilsvor din Fader Abraham; ");
INSERT INTO dan1931_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","og jeg vil gøre dit Afkom talrigt som Himmelens Stjerner og give dit Afkom alle disse Lande, og i din Sæd skal alle Jordens Folk velsignes, ");
INSERT INTO dan1931_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","fordi Abraham adlød mine Ord og holdt sig mine Forskrifter efterrettelig, mine Bud, Anordninger og Love.” ");
INSERT INTO dan1931_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Så blev Isak boende i Gerar. ");
INSERT INTO dan1931_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Da nu Mændene der på Stedet forhørte sig om hans Hustru, sagde han: “Det er min Søster!” Thi han turde ikke sige, at hun var hans Hustru, af Frygt for at Mændene der på Stedet skulde slå ham ihjel for Rebekkas Skyld; thi hun var meget smuk. ");
INSERT INTO dan1931_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Men da han havde boet der en Tid lang, hændte det, at Filisterkongen Abimelek lænede sig ud af Vinduet og så Isak kærtegne sin Hustru Rebekka. ");
INSERT INTO dan1931_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Så lod Abimelek Isak kalde og sagde: “Hun er jo din Hustru; hvor kunde du da sige, at hun er din Søster” Isak svarede: “Jo, jeg tænkte: Jeg vil ikke udsætte mig for at miste Livet for hendes Skyld.” ");
INSERT INTO dan1931_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Men Abimelek sagde: “Hvad er det dog, du har gjort imod os! Hvor let kunde det ikke være sket, at en af Folket havde ligget hos din Hustru, og så havde du bragt Skyld over os!” ");
INSERT INTO dan1931_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Så bød Abimelek alt Folket: “Hver den, der rører denne Mand eller hans Hustru, skal lide Døden.” ");
INSERT INTO dan1931_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isak såede der i Landet og fik samme År 100 Fold; og HERREN velsignede ham, ");
INSERT INTO dan1931_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","så han blev en mægtig Mand og stadig gik frem, indtil han blev såre mægtig, ");
INSERT INTO dan1931_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","og han havde Småkvæg og Hornkvæg og Trælle i Mængde. Derover blev Filisterne skinsyge på ham. ");
INSERT INTO dan1931_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Alle de Brønde, hans Faders Trælle havde gravet i hans Fader Abrahams Dage, kastede Filisterne til og fyldte dem med Jord; ");
INSERT INTO dan1931_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","og Abimelek sagde til Isak: “Drag bort fra os, thi du er blevet os for stærk!” ");
INSERT INTO dan1931_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Så drog Isak bort og slog Lejr i Gerars Dal og bosatte sig der. ");
INSERT INTO dan1931_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Men Isak lod atter de Brønde udgrave, som hans Fader Abrahams Trælle havde gravet, og som Filisterne havde tilkastet efter Abrahams Død, og gav dem de samme Navne, som hans Fader havde givet dem. ");
INSERT INTO dan1931_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Da nu Isaks Trælle gravede i Dalen, stødte de på en Brønd med rindende Vand; ");
INSERT INTO dan1931_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","men Gerars Hyrder yppede Kiv med Isaks og sagde: “Dette Vand tilhører os!” Derfor kaldte han Brønden Esek*, thi der stredes de med ham. { *dvs. Strid. } ");
INSERT INTO dan1931_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Så flyttede han derfra og lod grave en ny Brønd; og da de også yppede Kiv om den, kaldte han den Sitna*. { *dvs. Fjenskab. } ");
INSERT INTO dan1931_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Så flyttede han derfra og lod grave en ny Brønd; og da de ikke yppede Kiv om den, kaldte han den Rehobot*, idet han sagde: “Nu har HERREN skaffet os Plads, så vi kan blive talrige i Landet!” { *dvs. rummelige Pladser. } ");
INSERT INTO dan1931_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Så drog han derfra til Be'ersjeba. ");
INSERT INTO dan1931_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Samme Nat åbenbarede HERREN sig for ham og sagde: “Jeg er din Fader Abrahams Gud; frygt ikke, thi jeg er med dig, og jeg vil velsigne dig og gøre dit Afkom talrigt for min Tjener Abrahams, Skyld!” ");
INSERT INTO dan1931_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Da byggede Isak et Alter der og påkaldte HERRENS Navn; og der opslog han sit Telt, og hans Trælle gravede der en Brønd. ");
INSERT INTO dan1931_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Imidlertid kom Abimelek til ham fra Gerar med sin Ven Ahuzzat og sin Hærfører Pikol. ");
INSERT INTO dan1931_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak sagde til dem: “Hvorfor kommer I til mig, når I dog hader mig og har jaget mig bort fra eder?” ");
INSERT INTO dan1931_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Men de svarede: “Vi ser tydeligt, at HERREN er med dig, derfor har vi tænkt: Lad der blive et Edsforbund mellem os og dig, og lad os slutte en Pagt med dig, ");
INSERT INTO dan1931_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","at du ikke vil gøre os noget ondt, ligesom vi ikke har voldet dig Men, men kun handlet vel imod dig og ladet dig fare i Fred; du er og bliver jo HERRENS velsignede!” ");
INSERT INTO dan1931_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Så gjorde han et Gæstebud for dem, og de spiste og drak. ");
INSERT INTO dan1931_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Næste Morgen svor de hinanden Eder, og derefter tog Isak Afsked med dem, og de drog bort i Fred. ");
INSERT INTO dan1931_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Samme Dag kom Isaks Trælle og bragte ham Melding om den Brønd, de havde gravet, og sagde: “Vi har fundet Vand!” ");
INSERT INTO dan1931_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Så kaldte han den Sjib'a; og derfor hedder Byen den Dag i Dag Be'ersjeba*. { *jfr. 1 Mos. 21, 31. } ");
INSERT INTO dan1931_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Da Esau var fyrretyve År gammel, tog han Judit, en Datter af Hetitten Be'eri, og Basemat, en Datter af Hetitten Elon, til Ægte. ");
INSERT INTO dan1931_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Det var Isak og Rebekka en Hjertesorg. ");
INSERT INTO dan1931_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Da Isak var blevet gammel og hans Syn sløvet, så han ikke kunde se, kaldte han sin ældste Søn Esau til sig og sagde til ham: “Min Søn!” Han svarede: “Her er jeg!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Da sagde han: “Se, jeg er nu gammel og ved ikke, hvad Dag Døden kommer; ");
INSERT INTO dan1931_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","tag derfor dine Jagtredskaber, dit Pilekogger og din Bue og gå ud på Marken og skyd mig et Stykke Vildt; ");
INSERT INTO dan1931_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","lav mig en lækker Ret Mad efter min Smag og bring mig den, at jeg kan spise, før at min Sjæl kan velsigne dig, før jeg dør!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Men Rebekka havde lyttet, medens Isak talte til sin Søn Esau, og da, Esau var gået ud på Marken for at skyde et Stykke Vildt til sin Fader, ");
INSERT INTO dan1931_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","sagde hun til sin yngste Søn Jakob; “Se, jeg hørte din Fader sige til din Broder Esau: ");
INSERT INTO dan1931_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Hent mig et Stykke Vildt og lav mig en lækker Ret Mad, at jeg kan spise, før at jeg kan velsigne dig for HERRENS Åsyn før min Død. ");
INSERT INTO dan1931_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Adlyd mig nu, min Søn, og gør, hvad jeg pålægger dig: ");
INSERT INTO dan1931_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gå ud til Hjorden og hent mig to gode Gedekid; så laver jeg af dem en lækker Ret Mad til din Fader efter hans Smag; ");
INSERT INTO dan1931_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","bring så den ind til din Fader, at han kan spise, for at han kan velsigne dig før sin Død!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Men Jakob sagde til sin Moder Rebekka: “Se, min Broder Esau er håret, jeg derimod glat; ");
INSERT INTO dan1931_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","sæt nu, at min Fader føler på mig, så står jeg for ham som en Bedrager og henter mig en Forbandelse og ingen Velsignelse!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Men hans Moder svarede: “Den Forbandelse tager jeg på mig, min Søn, adlyd mig blot og gå hen og hent mig dem!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Så gik han hen og hentede dem og bragte sin Moder dem, og hun tillavede en lækker Ret Mad efter hans Faders Smag. ");
INSERT INTO dan1931_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Derpå tog Rebekka sin ældste Søn Esaus Festklæder, som hun havde hos sig i Huset, og gav sin yngste Søn Jakob dem på; ");
INSERT INTO dan1931_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Skindene af Gedekiddene lagde hun om hans Hænder og om det glatte på hans Hals, ");
INSERT INTO dan1931_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","og så gav hun sin Søn Jakob Maden og Brødet, som hun havde tillavet. ");
INSERT INTO dan1931_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Så bragte han det ind til sin Fader og sagde: “Fader!” Han svarede: “Ja! Hvem er du, min Søn?” ");
INSERT INTO dan1931_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Da svarede Jakob sin Fader: “Jeg er Esau, din førstefødte; jeg har gjort, som du bød mig; sæt dig nu op og spis af mit Vildt, for at din Sjæl kan velsigne mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Men Isak sagde til sin Søn: “Hvor har du så hurtigt kunnet finde noget, min Søn?” Han svarede: “Jo, HERREN din Gud sendte mig det i Møde!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Men Isak sagde til Jakob: “Kom hen til mig, min Søn, så jeg kan føle på dig, om du er min Søn Esau eller ej!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Da trådte Jakob hen til sin Fader, og efter at have følt på ham sagde Isak: “Røsten er Jakobs, men Hænderne Esaus!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Og han kendte ham ikke, fordi hans Hænder var hårede som hans Broder Esaus. Så velsignede han ham. ");
INSERT INTO dan1931_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Og han sagde: “Du er altså virkelig min Søn Esau?” Han svarede: “Ja, jeg er!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Da sagde han: “Bring mig det, at jeg kan spise af min Søns Vildt, for at min Sjæl kan velsigne dig!” Så bragte han ham det, og han spiste, og han bragte ham Vin, og han drak. ");
INSERT INTO dan1931_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Derpå sagde hans Fader Isak til ham: “Kom hen til mig og kys mig, min Søn!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Og da, han kom hen til ham og kyssede ham, mærkede han Duften af hans Klæder. Så velsignede han ham og sagde: “Se, Duften af min Søn er som Duften af en Mark, HERREN har velsignet! ");
INSERT INTO dan1931_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Gud give dig af Himmelens Væde og Jordens Fedme, Korn og Most i Overflod! ");
INSERT INTO dan1931_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Måtte Folkeslag tjene dig og Folkefærd bøje sig til Jorden for dig! Bliv Hersker over dine Brødre, og din Moders Sønner bøje sig til Jorden for dig! Forbandet, hvo dig forbander; velsignet, hvo dig velsigner!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Da Isak var færdig med at velsigne Jakob, og lige som Jakob var gået fra sin Fader Isak, vendte hans Broder Esau hjem fra Jagten; ");
INSERT INTO dan1931_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","også han lavede en lækker Ret Mad, bragte den til sin Fader og sagde: “Vil min Fader sætte sig op og spise af sin Søns Vildt, for at din Sjæl kan velsigne mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Så sagde hans Fader Isak: “Hvem er du?” Og han svarede: “Jeg er Esau, din førstefødte!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Da blev Isak højlig forfærdet og sagde: “Men hvem var da han. der bragte mig et Stykke Vildt, som han havde skudt? Og jeg spiste, før du kom, og jeg velsignede ham og nu er og bliver han velsignet!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Da Esau hørte sin Faders Ord: udstødte han et højt og hjerteskærende Skrig og sagde: “Velsign dog også mig, Fader!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Men han sagde: “Din Broder kom med Svig og tog din Velsignelse!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Da sagde han: “Har man kaldt ham Jakob, fordi han skulde overliste mig*? Nu har han gjort det to Gange: Han tog min Førstefødselsret, og nu har han også taget min Velsignelse!” Og han sagde: “Har du ingen Velsignelse tilbage til mig?” { *på hebr. Ordspil med Navnet Jakob. } ");
INSERT INTO dan1931_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Men Isak svarede: “Se, jeg har sat ham til Hersker over dig, og alle hans Brødre har jeg gjort til hans Trælle, med Horn og Most. har jeg betænkt ham hvad kan jeg da gøre for dig, min Søn?” ");
INSERT INTO dan1931_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Da sagde Esau til sin Fader: “Har du kun den ene Velsignelse. Fader? Velsign også mig, Fader!” Og Esau opløftede sin Røst og græd. ");
INSERT INTO dan1931_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Så tog hans Fader Isak til Orde og sagde til ham: “Se, fjern fra Jordens Fedme skal din Bolig være og fjern fra Himmelens Væde ovenfra; ");
INSERT INTO dan1931_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","af dit Sværd skal du leve, og din Broder skal du tjene; men når du samler din Kraft, skal du sprænge hans Åg af din Hals!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Men Esau pønsede på ondt mod Jakob for den Velsignelse, hans Fader havde givet ham, og Esau sagde ved sig selv: “Der er ikke længe til, at vi skal holde Sorg over min Fader, så vil jeg slå min Broder Jakob ihjel!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Da nu Rebekka fik Nys om sin ældste Søn Esaus Ord, sendte hun Bud efter sin yngste Søn Jakob og sagde til ham: “Din Broder Esau vil hævne sig på dig og slå dig ihjel; ");
INSERT INTO dan1931_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","adlyd nu mig min Søn: Flygt til min Broder Laban i Karan, ");
INSERT INTO dan1931_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","og bliv så hos ham en Tid, til din Broders Harme lægger sig, ");
INSERT INTO dan1931_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","til din Broders Vrede vender sig fra dig, og han glemmer, hvad du har gjort ham; så skal jeg sende Bud og hente dig hjem. Hvorfor skal jeg miste eder begge på én Dag!” ");
INSERT INTO dan1931_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Men Rebekka sagde til Isak: “Jeg er led ved Livet for Hets Døtres Skyld; hvis Jakob tager sig sådan en hetitisk Kvinde, en af Landets Døtre, til Hustru, hvad skal jeg da med Livet!” ");
INSERT INTO dan1931_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Da kaldte Isak Jakob til sig og velsignede ham, idet han bød ham: “Du må ikke tage dig en Hustru blandt Kana'ans Døtre. ");
INSERT INTO dan1931_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Drag til Paddan-Aram, til din Morfader Betuels Hus, og tag dig der en af din Morbroder Labans Døtre til Hustru! ");
INSERT INTO dan1931_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Gud den Almægtige velsigne dig og gøre dig frugtbar og give dig et talrigt Afkom, så du bliver til Stammer i Hobetal. ");
INSERT INTO dan1931_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Han give dig og dit Afkom med dig Abrahams Velsignelse, så du får din Udlændigheds Land i Eje, det, Gud skænkede Abraham!” ");
INSERT INTO dan1931_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Så lod Isak Jakob fare, og han drog til Paddan-Aram, til Aramæeren Laban, Betuels Søn, som var Broder til Rebekka, Jakobs og Esaus Moder. ");
INSERT INTO dan1931_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Men Esau fik at vide, at Isak havde velsignet Jakob og sendt ham til Paddan-Aram for at tage sig en Hustru der, og at han, da han velsignede ham, havde pålagt ham ikke at tage sig en Hustru blandt Kana'ans Døtre, ");
INSERT INTO dan1931_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","og at Jakob havde adlydt sin Fader og Moder og var draget til Paddan-Aram. ");
INSERT INTO dan1931_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Da skønnede Esau, at Kana'ans Døtre vakte hans Fader Isaks Mishag, ");
INSERT INTO dan1931_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","og han gik til Ismael og tog Mahalat, en Datter af Abrahams Søn Ismael og Søster til Nebajot, til Hustru ved Siden af sine andre Hustruer. ");
INSERT INTO dan1931_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Så drog Jakob bort fra Be'ersjeba og vandrede ad Karan til. ");
INSERT INTO dan1931_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","På sin Vandring kom han til det hellige Sted og overnattede der, da Solen var gået ned; og han tog en af Stenene på Stedet og brugte den som Hovedgærde og lagde sig til, Hvile der. ");
INSERT INTO dan1931_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Da drømte han, og se, på Jorden stod en Stige, hvis Top nåede til Himmelen, og se, Guds Engle steg op og ned ad den; ");
INSERT INTO dan1931_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","og HERREN stod foran ham og sagde: “Jeg er HERREN, din Fader Abrahams og Isaks Gud! Det Land, du hviler på, giver jeg dig og dit Afkom; ");
INSERT INTO dan1931_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","dit Afkom skal blive som Jordens Støv, og du skal brede dig mod Vest og Øst, mod Nord og Syd; og i dig og i din Sæd skal alle Jordens Slægter velsignes; ");
INSERT INTO dan1931_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","se, jeg vil være med dig og vogte dig, hvorhen du end går og føre dig tilbage til dette Land; thi jeg vil ikke forlade dig, men opfylde alt, hvad jeg har lovet dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Da Jakob vågnede af sin Søvn, sagde han: “Sandelig, HERREN er på dette Sted, og jeg vidste det ikke!” ");
INSERT INTO dan1931_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Og han blev angst og sagde: “Hvor forfærdeligt er dog dette Sted! Visselig, her er Guds Hus, her er Himmelens Port!” ");
INSERT INTO dan1931_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tidligt næste Morgen tog Jakob den Sten, han havde brugt som Hovedgærde rejste den som en Stenstøtte og gød Olie over den. ");
INSERT INTO dan1931_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Og han kaldte dette Sted Betel; før hed Byen Luz. ");
INSERT INTO dan1931_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Derpå gjorde Jakob følgende Løfte: “Hvis Gud er med mig og vogter mig på den Vej, jeg skal vandre, og giver mig Brød at spise og Klæder at iføre mig, ");
INSERT INTO dan1931_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","og hvis jeg kommer uskadt tilbage til min Faders Hus, så skal HERREN være min Gud, ");
INSERT INTO dan1931_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","og denne Sten, som jeg har rejst som en Støtte, skal være Guds Hus, og af alt, hvad du giver mig, vil jeg give dig Tiende!” ");
INSERT INTO dan1931_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Derpå fortsatte Jakob sin Vandring og drog til Østens Børns Land. ");
INSERT INTO dan1931_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Da fik han Øje på en Brønd på Marken og tre Hjorde af Småkvæg, der var lejrede ved den. Ved den Brønd vandede man Hjordene; og over Hullet lå der en stor Sten, ");
INSERT INTO dan1931_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","som man først væltede bort, når alle Hjordene var samlede, for siden, når Dyrene var vandet, at vælte den på Plads igen. ");
INSERT INTO dan1931_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakob spurgte dem: “Hvor er I fra, Brødre?” De svarede: “Fra Karan!” ");
INSERT INTO dan1931_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Da spurgte han dem: “Kender I Laban, Nakors Søn?” De svarede: “Ja, ham kender vi godt.” ");
INSERT INTO dan1931_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Han spurgte da: “Går det ham vel?” De svarede: “Ja, det går ham vel; se, hans Datter Rakel kommer netop med Hjorden derhenne!” ");
INSERT INTO dan1931_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Da sagde han: “Det er jo endnu højlys Dag og for tidligt at drive Kvæget sammen; vand Dyrene og før dem ud på Græsgangene!” ");
INSERT INTO dan1931_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Men de svarede: “Det kan vi ikke, før alle Hyrderne er samlede; først når de vælter Stenen fra Brøndhullet, kan vi vande Dyrene.” ");
INSERT INTO dan1931_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Medens han således stod og talte med dem, var Rakel kommet derhen med sin Faders Hjord, som hun vogtede; ");
INSERT INTO dan1931_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","og så snart Jakob så sin Morbroder Labans Datter Rakel og hans Hjord, gik han hen og væltede Stenen fra Brøndhullet og vandede sin Morbroder Labans Hjord. ");
INSERT INTO dan1931_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Så kyssede han Rakel og brast i Gråd; ");
INSERT INTO dan1931_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","og han fortalte hende; at han var hendes Faders Frænde, en Søn af Rebekka: Da skyndte hun sig hjem til sin Fader og fortalte ham det; ");
INSERT INTO dan1931_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","og så snart Laban hørte om sin Søstersøn Jakob, løb han ham i Møde, omfavnede og kyssede ham og førte ham hjem til sit Hus. Så fortalte Jakob ham alt, hvad der var sket; ");
INSERT INTO dan1931_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","og Laban sagde: “Ja, du er mit Kød og Blod!” Han blev nu hos ham en Måneds tid. ");
INSERT INTO dan1931_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Så sagde Laban til Jakob: “Skulde du tjene mig for intet fordi du er min Frænde? Sig mig. hvad du vil have i Løn!” ");
INSERT INTO dan1931_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Nu havde Laban to Døtre; den ældste hed Lea, den yngste Rakel; ");
INSERT INTO dan1931_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leas Øjne var matte, men Rakel havde en dejlig Skikkelse og så dejlig ud, ");
INSERT INTO dan1931_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","og Jakob elskede Rakel; derfor sagde han: “Jeg vil tjene dig syv År for din yngste Datter Rakel.” ");
INSERT INTO dan1931_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban svarede: “Jeg giver hende hellere til dig end til en fremmed; bliv kun hos mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Så tjente Jakob syv År for Rakel; og de syntes ham kun nogle få Dage, fordi han elskede hende. ");
INSERT INTO dan1931_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Derefter sagde Jakob til Laban: “Giv mig min Hustru, nu min Tjenestetid er ude, at jeg kan gå ind til hende!” ");
INSERT INTO dan1931_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Så indbød Laban alle Mændene på Stedet til Gæstebud. ");
INSERT INTO dan1931_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Men da Aftenen kom, tog han sin, Datter Lea og bragte hende til ham, og han gik ind til hende. ");
INSERT INTO dan1931_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Og Laban gav sin Datter Lea sin Trælkvinde Zilpa til Trælkvinde. ");
INSERT INTO dan1931_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Da det nu om Morgenen viste sig at være Lea, sagde Jakob til Laban: “Hvad er det, du har gjort imod mig? Er det ikke for Rakel, jeg, har tjent hos dig? Hvorfor har, du bedraget mig?” ");
INSERT INTO dan1931_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban svarede: “Det er ikke Skik og Brug her til Lands at give den yngste bort før den ældste; ");
INSERT INTO dan1931_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","men lad nu Bryllupsugen gå til Ende, så vil jeg også give dig hende, imod at du bliver i min Tjeneste syv År til.” ");
INSERT INTO dan1931_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Det gik Jakob ind på, og da Bryllupsugen var til Ende, gav Laban ham sin Datter Rakel til Hustru. ");
INSERT INTO dan1931_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Og Laban gav sin Datter Rakel sin Trælkvinde Bilha til Trælkvinde. ");
INSERT INTO dan1931_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Så gik Jakob også ind til Rakel, og han elskede Rakel højere end Lea. Derpå blev han i Labans Tjeneste syv År til. ");
INSERT INTO dan1931_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Da HERREN så, at Lea blev tilsidesat, åbnede han hendes Moderliv, medens Rakel var ufrugtbar. ");
INSERT INTO dan1931_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Så blev Lea frugtsommelig og fødte en Søn, som hun gav Navnet Ruben; thi hun sagde: “HERREN har set til min Ulykke*; nu vil min Mand elske mig!” { *på hebr. Ordspil med Navnet Ruben. } ");
INSERT INTO dan1931_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Siden blev hun frugtsommelig igen og fødte en Søn; og hun sagde: “HERREN hørte*, at jeg var tilsidesat, så gav han mig også ham!” Derfor gav hun ham Navnet Simeon. { *på hebr. Ordspil med Navnet Simeon. } ");
INSERT INTO dan1931_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Siden blev hun frugtsommelig igen og fødte en Søn; og hun sagde: “Nu må da endelig min Mand holde sig til* mig, da jeg har født ham tre Sønner.” Derfor gav hun ham Navnet Levi. { på hebr. Ordspil på Navnet Levi. } ");
INSERT INTO dan1931_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Siden blev hun frugtsommelig igen og fødte en Søn; og hun sagde: “Nu vil jeg prise* HERREN!” Derfor gav hun ham Navnet Juda. Så fik hun ikke flere Børn. { på hebr. Ordspil på Navnet Juda. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Da Rakel så, at hun ikke fødte Jakob noget Barn, blev hun skinsyg på sin Søster og sagde til Jakob: “Skaf mig Børn, ellers dør jeg!” ");
INSERT INTO dan1931_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Men Jakob blev vred på Rakel og sagde: “Er jeg i Guds Sted? Det er jo ham, der har nægtet dig Livsfrugt!” ");
INSERT INTO dan1931_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Så sagde hun: “Der er min Trælkvinde Bilha; gå ind til hende, så hun kan føde på mine Knæ og jeg få Sønner ved hende!” ");
INSERT INTO dan1931_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Og hun gav ham sin Trælkvinde Bilha til Hustru, og Jakob gik ind til hende. ");
INSERT INTO dan1931_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Så blev Bilha frugtsommelig og fødte Jakob en Søn, ");
INSERT INTO dan1931_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","og Rakel sagde: “Gud har hjulpet mig til min Ret*, han har hørt min Røst og givet mig en Søn.” Derfor gav hun ham Navnet Dan. { *på hebr. Ordspil med Navnet Dan. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Siden blev Rakels Trælkvinde Bilha frugtsommelig igen og fødte Jakob en anden Søn; ");
INSERT INTO dan1931_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","og Rakel sagde: “Gudskampe har jeg kæmpet* med min Søster og sejret.” Derfor gav hun ham Navnet Naftali. { *på hebr. Ordspil med Navnet Naftali. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Men da Lea så, at hun ikke fik flere Børn, tog hun sin Trælkvinde Zilpa og gav Jakob hende til Hustru; ");
INSERT INTO dan1931_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","og da Leas Trælkvinde Zilpa fødte Jakob en Søn, ");
INSERT INTO dan1931_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","sagde Lea: “Hvilken Lykke*!” Derfor gav hun ham Navnet Gad. { *på hebr. Ordspil med Navnet Gad. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Siden fødte Leas Trælkvinde Zilpa Jakob en anden Søn; ");
INSERT INTO dan1931_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","og Lea sagde: “Held mig*! Kvinderne vil prise mit Held*!” Derfor gav hun ham Navnet Aser. { *på hebr. Ordspil med Navnet Aser. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Men da Ruben engang i Hvedehøstens Tid gik på Marken, fandt han nogle Kærlighedsæbler* og bragte dem til sin Moder Lea. Da sagde Rakel til Lea: “Giv mig nogle af din Søns Kærlighedsæbler!” { *på hebr. dudajim, Frugten af Alrune, mandragora vernalis. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea svarede: “Er det ikke nok, at du har taget min Mand fra mig? Vil du nu også tage min Søns Kærlighedsæbler?” Men Rakel sagde: “Til Gengæld for din Søns Kærlighedsæbler må han ligge hos dig i Nat!” ");
INSERT INTO dan1931_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Da så Jakob kom fra Marken om Aftenen, gik Lea ham i Møde og sagde: “Kom ind til mig i Nat, thi jeg har købt dig for min Søns Kærlighedsæbler!” Og han lå hos hende den Nat. ");
INSERT INTO dan1931_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Så bønhørte Gud Lea, og hun blev frugtsommelig og fødte Jakob en femte Søn; ");
INSERT INTO dan1931_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","og Lea sagde: “Gud har lønnet* mig, fordi jeg gav min Mand min Trælkvinde.” Derfor gav hun ham Navnet Issakar. { *på hebr. Ordspil med Navnet Issakar. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Siden blev Lea frugtsommelig igen og fødte Jakob en sjette Søn; ");
INSERT INTO dan1931_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","og Lea sagde: “Gud har givet mig en god Gave*, nu vil min Mand blive* hos mig, fordi jeg har født ham seks Sønner.” Derfor gav hun ham Navnet Zebulon. { *på hebr. Ordspil med Navnet Zebulon. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Siden fødte hun en Datter, som hun gav Navnet Dina. ");
INSERT INTO dan1931_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Så kom Gud Rakel i Hu, og Gud bønhørte hende og åbnede hendes Moderliv, ");
INSERT INTO dan1931_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","så hun blev frugtsommelig og fødte en Søn; og hun sagde: “Gud har borttaget* min Skændsel.” { *på hebr. Ordspil med Navnet Josef. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Derfor gav hun ham Navnet Josef; thi hun sagde: “HERREN give mig endnu* en Søn!” { *på hebr. Ordspil med Navnet Josef. } ");
INSERT INTO dan1931_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Da Rakel havde født Josef. sagde Jakob til Laban: “Lad mig fare, at jeg kan drage til min Hjemstavn og mit Land; ");
INSERT INTO dan1931_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","giv mig mine Hustruer og mine Børn som jeg har tjent dig for, og lad mig drage bort; du ved jo selv, hvorledes jeg har tjent dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Men Laban svarede: “Måtte jeg have fundet Nåde for dine Øjne! Jeg har udfundet, at HERREN bar velsignet mig for din Skyld.” ");
INSERT INTO dan1931_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Og han sagde: “Bestem, hvad du vil have i Løn af mig, så vil jeg give dig den!” ");
INSERT INTO dan1931_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Så sagde Jakob: “Du ved jo selv, hvorledes jeg har tjent dig, og hvad din Ejendom er blevet til under mine Hænder; ");
INSERT INTO dan1931_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","thi før jeg kom, ejede du kun lidet, men nu har du Overflod; HERREN har velsignet dig, hvor som helst jeg satte min Fod. Men når kan jeg komme til at gøre noget for mit eget Hus?” ");
INSERT INTO dan1931_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban svarede: “Hvad skal jeg da give dig?” Da sagde Jakob: “Du skal ikke give mig noget; men hvis du går ind på, hvad jeg nu foreslår dig, vedbliver jeg at være Hyrde for dine Hjorde og vogte dem. ");
INSERT INTO dan1931_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Jeg vil i Dag gå hele din Hjord igennem og udskille alle spættede og blakkede Dyr alle de sorte Får og de blakkede eller spættede Geder skal være min Løn; ");
INSERT INTO dan1931_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","i Morgen den Dag skal min Retfærdighed vidne for mig: Når du kommer og syner den Hjord, der skal være min Løn, da er alle de Geder, som ikke er spættede eller blakkede, og de Får, som ikke er sorte, stjålet af mig.” ");
INSERT INTO dan1931_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban svarede: “Vel, lad det blive, som du siger!” ");
INSERT INTO dan1931_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Så udskilte han samme Dag de stribede og blakkede Bukke og de spættede og blakkede Geder, alle dem der havde hvide Pletter, og alle de sorte Får og overgav dem til sine Sønner, ");
INSERT INTO dan1931_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","og han lod der være tre Dagsrejser mellem dem og Jakob; og Jakob vogtede Resten af Labans Hjord. ");
INSERT INTO dan1931_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Men Jakob tog friske Grene af Hvidpopler, Mandeltræer og Plataner og afskrællede Barken således, at der kom hvide Striber på Grenene; ");
INSERT INTO dan1931_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","og de afskrællede Grene stillede han op i Trugene foran Dyrene, i Vandrenderne, hvor Dyrene kom hen og drak; og de parrede sig, når de kom for at drikke; ");
INSERT INTO dan1931_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Dyrene parrede sig foran Grenene og fødte så stribet, spættet og blakket Afkom. ");
INSERT INTO dan1931_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Og Lammene udskilte Jakob. Og han lod Dyrene vende Hovedet mod de stribede og alle de sorte dyr i Labans Hjord. På den Måde fik han sine egne Hjorde, som han ikke bragte sammen med Labans. ");
INSERT INTO dan1931_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Og hver Gang de kraftige Dyr parrede sig, stillede Jakob Grenene op foran dem i Vandrenderne, for at de skulde parre sig foran Grenene; ");
INSERT INTO dan1931_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","men når det var de svage Dyr, stillede han dem ikke op; således kom de svage til at tilhøre Laban, de kraftige Jakob. ");
INSERT INTO dan1931_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","På den Måde blev Manden overmåde rig og fik Småkvæg i Mængde, Trælkvinder og Trælle, Kameler og Æsler. ");
INSERT INTO dan1931_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Men Jakob hørte Labans Sønner sige: “Jakob har taget al vor Faders Ejendom, og deraf har han skabt sig al den Velstand.” ");
INSERT INTO dan1931_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Og Jakob læste i Labans Ansigt, at han ikke var sindet mod ham som tidligere. ");
INSERT INTO dan1931_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Da sagde HERREN til Jakob: “Vend tilbage til dine Fædres Land og din Hjemstavn, så vil jeg være med dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Så sendte Jakob Bud og lod Rakel og Lea kalde ud på Marken til sin Hjord; ");
INSERT INTO dan1931_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","og han sagde til dem: “Jeg læser i eders Faders Ansigt, at han ikke er sindet mod mig som tidligere, nu da min Faders Gud har været med mig; ");
INSERT INTO dan1931_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","og I ved jo selv, at jeg har tjent eders Fader af al min Kraft, ");
INSERT INTO dan1931_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","medens eders Fader har bedraget mig og forandret min Løn ti Gange; men Gud tilstedte ham ikke at gøre mig Skade; ");
INSERT INTO dan1931_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","sagde han, at de spættede Dyr skulde være min Løn, så fødte hele Hjorden spættet Afkom, og sagde han, at de stribede skulde være min Løn, så fødte hele Hjorden stribet Afkom. ");
INSERT INTO dan1931_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Således tog Gud Hjordene fra eders Fader og gav mig dem. ");
INSERT INTO dan1931_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Og ved den Tid Dyrene parrede sig, så jeg i Drømme, at Bukkene, der sprang, var stribede, spættede og brogede; ");
INSERT INTO dan1931_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","og Guds Engel sagde til mig i Drømme: Jakob! Jeg svarede: Se, her er jeg! ");
INSERT INTO dan1931_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Da sagde han: Løft dit Blik og se, hvorledes alle Bukkene, der springer, er stribede, spættede og brogede, thi jeg har set alt, hvad Laban har gjort imod dig. ");
INSERT INTO dan1931_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Jeg er den Gud, som åbenbarede sig for dig i, Betel, der, hvor du salvede en Stenstøtte og aflagde mig et Løfte; bryd op og forlad dette Land og vend tilbage til din Hjemstavn!” ");
INSERT INTO dan1931_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Så svarede Rakel og Lea ham: “Har vi vel mere Lod og Del i vor Faders Hus? ");
INSERT INTO dan1931_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Har han ikke regnet os for fremmede Kvinder, siden han solgte os og selv brugte de Penge, han fik for os? ");
INSERT INTO dan1931_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Al den Rigdom, Gud har taget fra vor Fader, tilhører os og vore Børn - gør du kun alt, hvad Gud sagde til dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Så satte Jakob sine Børn og sine Hustruer på Kamelerne ");
INSERT INTO dan1931_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","og tog alt sit Kvæg med sig, og al den Ejendom, han havde samlet sig, det Kvæg, han ejede og havde samlet sig i Paddan-Aram, for at drage til sin Fader Isak i Kana'ans, Land. ");
INSERT INTO dan1931_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Medens Laban var borte og klippede sine Får, stjal Rakel sin Faders Husgud*. { *på hebr. terafim. Dom. 17, 5; 18, 14. 1 Sam. 19, 13. } ");
INSERT INTO dan1931_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Og Jakob narrede Aramæeren Laban, idet han ikke lod ham mærke, at han vilde flygte; ");
INSERT INTO dan1931_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","og han flygtede med alt, hvad han ejede; han brød op og satte over Floden* og vandrede ad Gileads Bjerge til. { *dvs. Eufrat. } ");
INSERT INTO dan1931_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tredjedagen fik Laban Melding om, at Jakob var flygtet; ");
INSERT INTO dan1931_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","han tog da sine Frænder med sig, satte efter ham så langt som syv Dagsrejser og indhentede ham: i Gileads Bjerge. ");
INSERT INTO dan1931_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Men Gud kom til Aramæeren Laban i en Drøm om Natten og sagde til ham: “Vogt dig vel for at sige så meget som et ondt Ord til Jakob!” ");
INSERT INTO dan1931_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Da Laban traf Jakob - Jakob havde han opslået sit Telt på Bjerget. Laban med sine Frænder sit i Gileads Bjerge - ");
INSERT INTO dan1931_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","sagde Laban til Jakob: “Hvad har du gjort! Mig har du narret, og mine Døtre har du ført bort. som var de Krigsfanger! ");
INSERT INTO dan1931_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Hvorfor har du holdt din Flugt hemmelig og narret mig og ikke meddelt mig det; så jeg kunde tage Afsked med dig med Lystighed og Sang, med Håndpauker og Harper? ");
INSERT INTO dan1931_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Du lod mig ikke kysse mine Sønner og Døtre - sandelig, det var dårligt gjort af dig! ");
INSERT INTO dan1931_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Det stod nu i min Magt at handle ilde med dig; men din Faders Gud sagde til mig i Nat: Vogt dig vel for at sige så meget som et ondt Ord til Jakob! ");
INSERT INTO dan1931_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nu vel, så drog du altså bort fordi du længtes så meget efter din Faders Hus men hvorfor stjal du min Gud?” ");
INSERT INTO dan1931_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Da svarede Jakob Laban: “Jeg var bange; thi jeg tænkte, du vilde rive dine Døtre fra mig! ");
INSERT INTO dan1931_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Men den, hos hvem du finder din Gud, skal lade sit Liv! Gennemsøg i vore Frænders Påsyn, hvad: jeg har, og tag, hvad dit er!” Jakob vidste nemlig ikke, at Rakel havde stjålet den. ");
INSERT INTO dan1931_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban gik nu ind og ledte i Jakobs, i Leas og i de to Tjenestekvinders Telte men fandt intet; og fra Leas gik han, til Rakels, Telt. ");
INSERT INTO dan1931_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Men Rakel havde taget Husguden og lagt den i Kamelsadlen og sat sig på den. Da Laban nu havde gennemsøgt hele Teltet og intet fundet, ");
INSERT INTO dan1931_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","sagde hun til sin Fader: “Min Herre tage mig ikke ilde op, at jeg ikke kan rejse mig for dig, da det går mig på Kvinders Vis!” Således ledte han efter Husguden uden at finde den. ");
INSERT INTO dan1931_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Da blussede Vreden op i Jakob, og han gik i Rette med Laban; og Jakob sagde til Laban: “Hvad er min Brøde, og hvad er min Synd, at du satte efter mig! ");
INSERT INTO dan1931_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Du har jo nu gennemsøgt alle mine Ting! Hvad har du fundet af alle dine Sager? Læg det frem for mine Frænder og dine Frænder, at de kan dømme os to imellem! ");
INSERT INTO dan1931_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I de tyve År, jeg har været hos dig, fødte dine Får og Geder ikke i Utide, din Hjords Vædre fortærede jeg ikke, ");
INSERT INTO dan1931_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","det sønderrevne bragte jeg dig ikke, men erstattede det selv; af min Hånd krævede du, hvad der blev stjålet både om Dagen og om Natten; ");
INSERT INTO dan1931_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","om Dagen fortærede Heden mig, om Natten Kulden, og mine Øjne kendte ikke til Søvn. ");
INSERT INTO dan1931_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I tyve År har jeg tjent dig i dit Hus, fjorten År for dine to Døtre og seks År for dit Småkvæg, og ti Gange har du forandret min Løn. ");
INSERT INTO dan1931_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Havde ikke min Faders Gud, Abrahams Gud og Isaks Rædsel, stået mig bi, så havde du ladet mig gå med tomme Hænder; men Gud så min Elendighed og mine Hænders Møje, og i Nat afsagde han sin Kendelse!” ");
INSERT INTO dan1931_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Da sagde Laban til Jakob: “Døtrene er mine Døtre, Sønnerne er mine Sønner, Hjordene er mine Hjorde, og alt, hvad du ser, er mit - men hvad skulde jeg i Dag kunne gøre imod mine Døtre eller de Sønner, de har født? ");
INSERT INTO dan1931_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Lad os to slutte et Forlig, og det skal tjene til Vidne mellem os.” ");
INSERT INTO dan1931_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Så tog Jakob en Sten og rejste den som en Støtte; ");
INSERT INTO dan1931_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","og Jakob sagde til sine Frænder: “Sank Sten sammen!” Og de tog Sten og byggede en Dysse og holdt Måltid derpå. ");
INSERT INTO dan1931_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban kaldte den Jegar-Sahaduta*, og Jakob kaldte den Gal'ed. { *Begge Ordene, af hvilke det første er arameisk, det andet hebraisk, betyder Vidne-Dysse. } ");
INSERT INTO dan1931_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Da sagde Laban: “Denne Dysse skal i Dag være Vidne mellem os to!” Derfor kaldte han den Gal'ed ");
INSERT INTO dan1931_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","og Mizpa*; thi han sagde: “HERREN skal stå Vagt mellem mig og dig, når vi skilles. { *Vagtsted. } ");
INSERT INTO dan1931_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Hvis du handler ilde med mine Døtre eller tager andre Hustruer ved Siden af dem, da vid, at selv om intet Menneske er til Stede, er dog Gud Vidne mellem mig og dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Og Laban sagde til Jakob: “Se denne Stendysse og se denne Stenstøtte, som jeg har rejst mellem mig og dig! ");
INSERT INTO dan1931_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Vidne er denne Dysse, og Vidne er denne Støtte på, at jeg ikke i fjendtlig Hensigt vil gå forbi denne Dysse ind til dig, og at du heller ikke vil gå forbi den ind til mig; ");
INSERT INTO dan1931_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahams Gud og Nakors Gud, deres Faders Gud, være Dommer imellem os!” Så svor Jakob ved sin Fader Isaks Rædsel, ");
INSERT INTO dan1931_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","og derpå holdt Jakob Offerslagtning på Bjerget og indbød sine Frænder til Måltid; og de holdt Måltid og blev på Bjerget Natten over. ");
INSERT INTO dan1931_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Tidligt næste Morgen kyssede Laban sine Sønner og Døtre, velsignede dem og drog bort; og Laban vendte tilbage til sin Hjemstavn, ");
INSERT INTO dan1931_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","men Jakob fortsatte sin Rejse. Og Guds Engle mødte ham; ");
INSERT INTO dan1931_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","og da Jakob så dem, sagde han: “Her er Guds Lejr!” derfor kaldte han Stedet Mahanajim*. { *dvs. to Lejre. } ");
INSERT INTO dan1931_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Derpå sendte Jakob Sendebud i Forvejen til sin Broder Esau i Se'irs Land på Edoms Højslette, ");
INSERT INTO dan1931_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","og han bød dem: “Sig til min Herre Esau: Din Træl Jakob lader dig vide, at jeg har levet som Gæst hos Laban og boet der indtil nu; ");
INSERT INTO dan1931_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","jeg har samlet mig Okser, Æsler og Småkvæg, Trælle og Trælkvinder; og nu sender jeg Bud til min Herre med Efterretning herom i Håb om at finde Nåde for dine Øjne!” ");
INSERT INTO dan1931_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Men Sendebudene kom tilbage til Jakob og meldte: “Vi kom til din Broder Esau, og nu drager han dig i Møde med 400 Mand!” ");
INSERT INTO dan1931_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Da blev Jakob såre forfærdet, og i sin Angst delte han sine Folk, Småkvæget, Hornkvæget og Kamelerne i to Lejre, ");
INSERT INTO dan1931_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","idet han tænkte: “Hvis Esau møder den ene Lejr og slår den, kan dog den anden slippe bort.” ");
INSERT INTO dan1931_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Derpå bad Jakob: “Min Fader Abrahams og min Fader Isaks Gud, HERRE, du, som sagde til mig: Vend tilbage til dit Land og din Hjemstavn, så vil jeg gøre vel imod dig! ");
INSERT INTO dan1931_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Jeg er for ringe til al den Miskundhed og Trofasthed, du har udvist mod din Tjener; thi med min Stav gik jeg over Jordan der, og nu er jeg blevet til to Lejre; ");
INSERT INTO dan1931_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","frels mig fra min Broder Esaus Hånd, thi jeg frygter for, at han skal komme og slå mig, både Moder og Børn! ");
INSERT INTO dan1931_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Du har jo selv sagt, at du vil gøre vel imod mig og gøre mit Afkom som Havets Sand, der ikke kan tælles for Mængde!” ");
INSERT INTO dan1931_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Og han blev der om Natten. Af hvad han havde, udtog han så en Gave til sin Broder Esau, ");
INSERT INTO dan1931_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 Geder og 20 Bukke, 200 Får og 20 Vædre, ");
INSERT INTO dan1931_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","34 diegivende Kamelhopper med deres Føl, 40 Køer og 10 Tyre, 20 Aseninder og 10 Æselhingste; ");
INSERT INTO dan1931_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","han delte dem i flere Hjorde og overlod sine Trælle dem, idet han sagde til dem: “Gå i Forvejen og lad en Plads åben mellem Hjordene!” ");
INSERT INTO dan1931_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Og han bød den første: “Når min Broder Esau møder dig og spørger, hvem du tilhører, hvor du skal hen, og hvem din Drift tilhører, ");
INSERT INTO dan1931_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","skal du svare: Den tilhører din Træl Jakob; det er en Gave. han sender min Herre Esau; selv kommer han bagefter!” ");
INSERT INTO dan1931_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Og han bød den anden og den tredje og alle de andre, der fulgte med Hjordene, at sige det samme til Esau, når de traf ham: ");
INSERT INTO dan1931_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","“Din Træl Jakob kommer selv bagefter!” Thi han tænkte: “Jeg vil søge at forsone ham ved den Gave. der drager foran, og først bagefter vil jeg træde frem for ham; måske han da tager venligt imod mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Så drog Gaven i Forvejen, medens han selv blev i Lejren om Natten. ");
INSERT INTO dan1931_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Samme Nat tog han sine to Hustruer, sine to Trælkvinder og sine elleve Børn og gik over Jakobs Vadested; ");
INSERT INTO dan1931_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","han tog dem og bragte dem over Bækken; ligeledes bragte han alt. hvad han ejede, over. ");
INSERT INTO dan1931_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Men selv blev Jakob alene tilbage. Da var der en, som brødes, med ham til Morgengry; ");
INSERT INTO dan1931_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","og da han så, at han ikke kunde få Bugt med ham, gav han ham et Slag på Hofteskålen; og Jakobs Hofteskål gik af Led, da han brødes med ham. ");
INSERT INTO dan1931_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Da sagde han: “Slip mig, thi Morgenen gryr!” Men han svarede: “Jeg slipper dig ikke, uden du velsigner mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Så spurgte han: “Hvad er dit Navn?” Han svarede: “Jakob!” ");
INSERT INTO dan1931_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Men han sagde: “Dit Navn skal ikke mere være Jakob, men Israel; thi du har kæmpet med Gud* og Mennesker og sejret!” { *De hebr. Ord hentyder til Navnet Israel. } ");
INSERT INTO dan1931_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Da sagde Jakob: “Sig mig dit Navn!” Men han svarede: “Hvorfor spørger du om mit Navn?” Og han velsignede ham der. ");
INSERT INTO dan1931_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Og Jakob kaldte Stedet Peniel, idet han sagde: “Jeg har skuet Gud Ansigt til Ansigt og har mit Liv frelst.” { *Peniel (eller Penuel) betyder Guds Ansigt. } ");
INSERT INTO dan1931_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Og Solen stod op, da han drog forbi Penuel, og da haltede han på Hoften. ");
INSERT INTO dan1931_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Derfor undlader Israelitterne endnu den Dag i Dag at spise Hoftenerven, der ligger over Hofteskålen, thi han gav Jakob et Slag på Hofteskålen, på Hoftenerven. ");
INSERT INTO dan1931_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Da Jakob så op, fik han Øje på Esau, der kom fulgt af 400 Mand. Så delte han Børnene mellem Lea, Rakel og de to Trælkvinder, ");
INSERT INTO dan1931_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","idet han stillede Trælkvinderne med deres Børn forrest, Lea med hendes Børn længere tilbage og bagest Rakel med Josef; ");
INSERT INTO dan1931_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","selv gik han frem foran dem og kastede sig syv Gange til Jorden, før han nærmede sig sin Broder. ");
INSERT INTO dan1931_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Men Esau løb ham i Møde og omfavnede ham, faldt ham om Halsen og kyssede ham, og de græd; ");
INSERT INTO dan1931_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","og da han så op og fik Øje på Kvinderne og Børnene, sagde han: “Hvem er det, du har der?” Han svarede: “Det er de Børn, Gud nådig har givet din Træl.” ");
INSERT INTO dan1931_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Så nærmede Trælkvinderne sig med deres Børn og kastede sig til Jorden, ");
INSERT INTO dan1931_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","derefter nærmede Lea sig med sine Børn og kastede sig til Jorden, og til sidst nærmede Josef og Rakel sig og kastede sig til Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Nu spurgte han: “Hvad vilde du med hele den Lejr, jeg traf på?” Han svarede: “Finde Nåde for min Herres Øjne!” ");
INSERT INTO dan1931_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Men Esau sagde: “Jeg har nok, Broder; behold du, hvad dit er!” ");
INSERT INTO dan1931_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Da svarede Jakob: “Nej, hvis jeg har fundet Nåde for dine Øjne, så tag imod min Gave! Da jeg så dit Åsyn, var det jo som Guds Åsyn, og du har taget venligt imod mig! ");
INSERT INTO dan1931_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tag dog den Velsignelse, som er dig bragt, thi Gud har været mig nådig, og jeg har fuldt op!” Således nødte han ham, til han tog det. ");
INSERT INTO dan1931_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Derpå sagde Esau: “Lad os nu bryde op og drage af Sted, og jeg vil drage foran dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Men Jakob svarede: “Min Herre ved jo, at jeg må tage Hensyn til de spæde Børn og de Får og Køer, som giver Die; overanstrenger jeg dem blot en eneste Dag, dør alt Småkvæget. ");
INSERT INTO dan1931_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Vil min Herre drage forud for sin Træl, kommer jeg efter i Ro og Mag, som det passer sig for Kvæget, jeg har med, og for Børnene, til jeg kommer til min Herre i Se'ir.” ");
INSERT INTO dan1931_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Da sagde Esau: “Så vil jeg i alt Fald lade nogle af mine Folk ledsage dig!” Men han svarede: “Hvorfor dog det måtte jeg blot finde Nåde for min Herres Øjne!” ");
INSERT INTO dan1931_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Så drog Esau samme Dag tilbage til Se'ir. ");
INSERT INTO dan1931_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Men Jakob brød op og drog til Sukkot*, hvor han byggede sig et Hus og indrettede Hytter til sit Kvæg; derfor gav han Stedet Navnet Sukkot. { *dvs. Hytter. } ");
INSERT INTO dan1931_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Og Jakob kom på sin Vandring fra Paddan-Aram uskadt til Sikems By i Kana'ans Land og slog Lejr uden for Byen; ");
INSERT INTO dan1931_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","og han købte det Stykke Jord, hvor han havde rejst sit Telt, af Sikems Fader Hamors Sønner for 100 Kesita* { *en Mønt av ukendt værdi. } ");
INSERT INTO dan1931_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","og byggede der et Alter, som han kaldte: Gud, Israels Gud. ");
INSERT INTO dan1931_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Da Dina, den Datter, Jakob havde med Lea, engang gik ud for at besøge Landets Døtre, ");
INSERT INTO dan1931_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","så Sikem, en Søn af Egnens Høvding, Hivviten Hamor, hende og greb hende og lå hos hende; og han krænkede hende; ");
INSERT INTO dan1931_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","men hans Hjerte hang ved Jakobs Datter Dina, og han elskede Pigen og talte godt for hende; ");
INSERT INTO dan1931_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","og Sikem sagde til sin Fader Hamor: “Skaf mig den Pige til Hustru!” ");
INSERT INTO dan1931_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakob hørte, at han havde skændet hans Datter Dina; men da hans Sønner dengang var med hans Kvæg på Marken, tav han, til de kom hjem. ");
INSERT INTO dan1931_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sikems Fader Hamor gik nu til Jakob for at tale med ham. ");
INSERT INTO dan1931_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Men da Jakobs Sønner hørte det, kom de hjem fra Marken; og Mændene græmmede sig og var såre opbragte, fordi han havde øvet Skændselsdåd i Israel ved at ligge hos Jakobs Datter; thi sligt bør ikke ske. ");
INSERT INTO dan1931_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Og Hamor talte med dem og sagde: “Min Søn Sikems Hjerte hænger ved eders Datter; giv ham hende til Hustru ");
INSERT INTO dan1931_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","og indgå Svogerskab med os; giv os eders Døtre og gift eder med vore Døtre; ");
INSERT INTO dan1931_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","tag Ophold hos os, og Landet skal stå eder åbent; slå eder ned og drag frit omkring og saml eder Ejendom der!” ");
INSERT INTO dan1931_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Og Sikem sagde til hendes Fader og Brødre: “Måtte jeg finde Nåde for eders Øjne! Alt, hvad I kræver, vil jeg give; ");
INSERT INTO dan1931_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","forlang så høj en Brudesum og Gave, I vil; jeg giver, hvad I kræver, når I blot vil give mig Pigen til Hustru!” ");
INSERT INTO dan1931_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Da gav Jakobs Sønner Sikem og hans Fader Hamor et listigt Svar, fordi. han havde skændet deres Søster Dina, ");
INSERT INTO dan1931_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","og sagde til dem: “Vi er ikke i Stand til at give vor Søster til en uomskåren Mand, thi det holder vi for en Skændsel. ");
INSERT INTO dan1931_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kun på det Vilkår vil vi føje eder, at I bliver som vi og lader alle af Mandkøn iblandt eder omskære; ");
INSERT INTO dan1931_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","i så Fald vil vi give eder vore Døtre og ægte eders Døtre og bosætte os iblandt eder, så vi bliver ét Folk; ");
INSERT INTO dan1931_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","men hvis I ikke vil høre os og lade eder omskære, så tager vi vor Datter og drager bort!” ");
INSERT INTO dan1931_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Deres Tale tyktes Hamor og Sikem, Hamors Søn, god; ");
INSERT INTO dan1931_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","og den unge Mand tøvede ikke med at gøre således, thi han var indtaget i Jakobs Datter, og han var den, der havde mest at sige i sin Faders Hus; ");
INSERT INTO dan1931_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","og Hamor og hans Søn Sikem gik til deres Bys Port og sagde til, Mændene i deres By: ");
INSERT INTO dan1931_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Disse Mænd er os velsindede; lad dem bosætte sig og drage frit om her i Landet, der er jo Plads nok til dem i Landet; deres Døtre vil vi tage til Hustruer og give dem vore Døtre til Hustruer! ");
INSERT INTO dan1931_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Men kun på det Vilkår vil Mændene føje os og bosætte sig hos os, så vi kan blive ét Folk, at alle af Mandkøn hos os lader sig omskære, således som de er omskårne. ");
INSERT INTO dan1931_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Deres Hjorde og deres Gods og alt deres Kvæg bliver jo dog vort; lad os derfor føje dem, så de kan blive boende hos os!” ");
INSERT INTO dan1931_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Så adlød de Hamor og hans Søn Sikem, så mange som færdedes i hans Bys Port, og alle af Mandkøn, alle, som færdedes i hans Bys Port, lod sig omskære. ");
INSERT INTO dan1931_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Men Tredjedagen, da de havde Sårfeber, tog Jakobs to Sønner Simeon og Levi, Dinas Brødre, hver sit Sværd, trængte ind i Byen, uden at nogen anede Uråd, Og slog alle Mændene ihjel ");
INSERT INTO dan1931_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","og dræbte Hamor og hans Søn Sikem med Sværdet, tog Dina ud af Sikems Hus og drog bort. ");
INSERT INTO dan1931_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Så kastede Jakobs Sønner sig over de faldne og plyndrede Byen, fordi de havde skændet deres Søster; ");
INSERT INTO dan1931_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","deres Småkvæg, Hornkvæg og Æsler, både hvad der var i Byen og på Markerne, tog de med sig, ");
INSERT INTO dan1931_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","og al deres Ejendom og alle deres Børn og Kvinder førte de bort som Bytte, og de udplyndrede Byen for alt, hvad der var der. ");
INSERT INTO dan1931_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Men Jakob sagde til Simeon og Levi: “I styrter mig i Ulykke ved at lægge mig for Had hos Landets Indbyggere, Kana'anæerne og Perizzitterne; thi jeg råder kun over få Folk; samler de sig mod mig og slår mig, så er det ude med mig og mit Hus!” ");
INSERT INTO dan1931_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Men de svarede: “Skal han behandle vor Søster som en Skøge!” ");
INSERT INTO dan1931_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Derpå sagde Gud til Jakob: “Drag op til Betel og bliv der og byg der et Alter for Gud, som åbenbarede sig for dig, da du flygtede for din Broder Esau!” ");
INSERT INTO dan1931_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jakob sagde da til sit Hus og alle sine Folk: “Skaf de fremmede Guder, der findes hos eder, bort, rens eder og skift Klæder, ");
INSERT INTO dan1931_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","og lad os drage op til Betel, for at jeg der kan bygge et Alter for Gud, der bønhørte mig i min Trængselstid og var med mig på den Vej, jeg vandrede!” ");
INSERT INTO dan1931_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","De gav så Jakob alle de fremmede Guder, de førte med sig, og alle de Ringe, de havde i Ørene, og han gravede dem ned under Egen ved Sikem. ");
INSERT INTO dan1931_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Derpå brød de op; og en Guds Rædsel kom over alle Byerne rundt om, så de ikke forfulgte Jakobs Sønner. ");
INSERT INTO dan1931_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Og Jakob kom med alle sine Folk til Luz i Kana'ans Land, det er Betel; ");
INSERT INTO dan1931_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","og han byggede et Alter der og kaldte Stedet: Betels Gud, thi der havde Gud åbenbaret sig for ham, da han flygtede for sin Broder. ");
INSERT INTO dan1931_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Så døde Rebekkas Amme Debora, og hun blev jordet neden for Betel under Egen; derfor kaldte han den Grædeegen. ");
INSERT INTO dan1931_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Gud åbenbarede sig atter for Jakob efter hans Hjemkomst fra Paddan-Aram og velsignede ham; ");
INSERT INTO dan1931_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","og Gud sagde til ham: “Dit Navn er Jakob; men herefter skal du ikke mere hedde Jakob; Israel skal være dit Navn!” Og han gav ham Navnet Israel. ");
INSERT INTO dan1931_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Derpå sagde Gud til ham: “Jeg er Gud den Almægtige! Bliv frugtbar og mangfoldig! Et Folk, ja Folk i Hobetal skal nedstamme fra dig, og Konger skal udgå af din Lænd; ");
INSERT INTO dan1931_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","det Land, jeg gav Abraham og Isak, giver jeg dig, og dit Afkom efter dig giver jeg Landet!” ");
INSERT INTO dan1931_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Derpå for Gud op fra ham på det Sted, hvor han havde talet med ham; ");
INSERT INTO dan1931_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","og Jakob rejste en Støtte på det Sted, hvor han havde talet med ham, en Stenstøtte, og hældte et Drikoffer over den og udgød Olie på den. ");
INSERT INTO dan1931_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Og Jakob kaldte det Sted, hvor Gud havde talet med ham, Betel. ");
INSERT INTO dan1931_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Derpå brød de op fra Betel, Da de endnu var et Stykke Vej fra Efrat, skulde Rakel føde, og hendes Fødselsveer var hårde. ");
INSERT INTO dan1931_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Midt under hendes hårde Fødselsveer sagde Jordemoderen til hende: “Frygt ikke, thi også denne Gang får du en Søn!” ");
INSERT INTO dan1931_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Men da hun droges med Døden - thi det kostede hende Livet - gav hun ham Navnet Ben'oni*; men Faderen kaldte ham Benjamin**. { *dvs. min lidelses Søn. / **dvs. lykkens Søn. } ");
INSERT INTO dan1931_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Så døde Rakel og blev jordet på Vejen til Efrat, det er Betlehem; ");
INSERT INTO dan1931_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","og Jakob rejste en Stenstøtte på hendes Grav; det er Rakels Gravstøtte, som står endnu den Dag i Dag. ");
INSERT INTO dan1931_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Derpå brød Israel op og opslog sit Telt hinsides Migdal Eder. ");
INSERT INTO dan1931_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Men medens Israel boede i den Egn, gik Ruben hen og lå hos sin Faders Medhustru Bilha; og det kom Israel for Øre. Jakobs Sønner var tolv i Tal; ");
INSERT INTO dan1931_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leas Sønner: Ruben, Jakobs førstefødte, Simeon, Levi, Juda, Issakar og Zebulon; ");
INSERT INTO dan1931_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rakels Sønner: Josef og Benjamin; ");
INSERT INTO dan1931_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rakels Trælkvinde Bilhas Sønner: Dan og Naftali; ");
INSERT INTO dan1931_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leas Trælkvinde Zilpas Sønner: Gad og Aser. Det var Jakobs Sønner, der fødtes ham i Paddan-Aram. ");
INSERT INTO dan1931_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Og Jakob kom til sin Fader Isak i Mamre i Kirjat Arba, det er Hebron, hvor Abraham og Isak havde levet som fremmede. ");
INSERT INTO dan1931_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaks Leveår var 180; ");
INSERT INTO dan1931_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","så gik Isak bort; han døde og samledes til sin Slægt, gammel og mæt af Dage. Og hans Sønner Esau og Jakob jordede ham, ");
INSERT INTO dan1931_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dette er Esaus, det er Edoms, Slægtsbog. ");
INSERT INTO dan1931_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau tog sine Hustruer af Kana'ans Døtre: Ada, en Datter af Hetitten Elon, Oholibama, en Datter af Ana, Hivviten Zibons Søn, ");
INSERT INTO dan1931_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","og Ismaels Datter Basemat, Søster til Nebajot. ");
INSERT INTO dan1931_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada fødte Esau Elifaz, Basemat fødte Reuel, ");
INSERT INTO dan1931_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","og Oholibama fødte Je'usj, Jalam og Kora. Det var Esaus Sønner, der fødtes ham i Kana'ans Land. ");
INSERT INTO dan1931_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Derpå tog Esau sine Hustruer sine Sønner og Døtre, hele sin Husstand, sit Kvæg og al den Ejendom, han havde samlet sig i Kana'ans Land, og drog til Landet lige over for sin Broder Jakob; ");
INSERT INTO dan1931_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","deres Gods var for meget til, at de kunde bo sammen, og deres. Udlændigheds Land kunde ikke rumme dem, så store var deres. Hjorde; ");
INSERT INTO dan1931_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","og Esau bosatte sig i Se'irs Bjerge; Esau, det er Edom. ");
INSERT INTO dan1931_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dette er Esaus Slægtebog, han, som var Stamfader til Edomitterne i Se'irs Bjerge. ");
INSERT INTO dan1931_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Følgende var Esaus Sønners Navne: Elifaz, en Søn af Esaus Hustru Ada, og Reuel, en Søn af Esaus Hustru Basemat. ");
INSERT INTO dan1931_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaz' Sønner var Teman, Omar, Zefo, Gatam og Kenaz. ");
INSERT INTO dan1931_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, som var Esaus Søn Elifaz' Medhustru, fødte ham Amalek. Det var Esaus Hustru Adas Sønner. ");
INSERT INTO dan1931_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Følgende var Re'uels Sønner: Nahat, Zera, Sjamma og Mizza. Det var Esaus Hustru Basemats Sønner. ");
INSERT INTO dan1931_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Følgende var Sønner af Esaus Hustru Oholibama, Datter af Zibons Søn Ana; hun fødte for Esau: Je'usj, Jalam og Kora. ");
INSERT INTO dan1931_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Følgende var Esaus Sønners Stammehøvdinger: Elifaz', Esaus førstefødtes, Sønner: Høvdingerne Teman, Omar, Zefo, Kenaz, ");
INSERT INTO dan1931_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam og Amalek. Det var de fra Elifaz stammende Høvdinger i Edoms Land; det var Adas Sønner. ");
INSERT INTO dan1931_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Følgende var Esaus Søn Re'uels Sønner: Høvdingerne Nahat, Zera, Sjamma og Mizza. Det var de fra Reuel stammende Høvdinger i Edoms Land; det var Esaus Hustru Basemats Sønner. ");
INSERT INTO dan1931_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Følgende var Esaus Hustru Oholibamas Sønner: Høvdingerne Je'usj, Jalam og Kora. Det var de Høvdinger, der stammede fra Oholibama, Esaus Hustru, Anas Datter. ");
INSERT INTO dan1931_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Det var Esaus Sønner, og det var deres Stammehøvdinger; det var Edom. ");
INSERT INTO dan1931_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Følgende var Horitten Se'irs Sønner, Landets oprindelige Befolkning: Lotan, Sjobal, Zib'on, Ana, ");
INSERT INTO dan1931_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disjon, Ezer og Risjon. Det var Horitternes Stammehøvdinger, Se'irs Sønner i Edoms Land. ");
INSERT INTO dan1931_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotans Sønner var Hori og Hemam, og Lotans Søster var Timna. ");
INSERT INTO dan1931_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Følgende var Sjobals Sønner: Alvan, Manahat, Ebal, Sjefo og Onam. ");
INSERT INTO dan1931_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Følgende var Zibons Sønner: Ajja og Ana. Det var denne Ana, som fandt de varme Kilder i Ørkenen, da han vogtede sin Fader Zibons Æsler. ");
INSERT INTO dan1931_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Følgende var Anas Børn: Disjon og Oholibama, Anas Datter. ");
INSERT INTO dan1931_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Følgende var Disjons Sønner: Hemdan, Esjban, Jitran og Keran. ");
INSERT INTO dan1931_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Følgende var Ezers Sønner: Bilhan, Za'avan og Akan. ");
INSERT INTO dan1931_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Følgende var Risjons Sønner: Uz og Aran. ");
INSERT INTO dan1931_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Følgende var Horitternes Stammehøvdinger: Høvdingerne Lotan, Sjobal, Zib'on, Ana, ");
INSERT INTO dan1931_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disjon, Ezer og Risjon. Det var Horitternes Stammehøvdinger efter deres Stammer i Se'irs Land. ");
INSERT INTO dan1931_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Følgende var de Konger, der herskede i Edoms Land, før Israelitterne fik Konger: ");
INSERT INTO dan1931_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, Beors Søn, herskede i Edom; hans By hed Dinhaba. ");
INSERT INTO dan1931_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Da Bela døde, blev Jobab, Zeras Søn fra Bozra, Konge i hans Sted. ");
INSERT INTO dan1931_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Da Jobab døde, blev Husjam fra Temanitternes Land Konge i hans Sted. ");
INSERT INTO dan1931_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Da Husjam døde, blev Hadad, Bedads Søn, Konge i hans Sted; det var ham, der slog Midjanitterne på Moabs Slette; hans By hed Avit. ");
INSERT INTO dan1931_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Da Hadad døde, blev Samla fra Masreka Konge i hans Sted. ");
INSERT INTO dan1931_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Da Samla døde, blev Sjaul fra Rehobot ved Floden Konge i hans Sted. ");
INSERT INTO dan1931_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Da Sjaul døde, blev Ba'al-Hanan, Akbors Søn, Konge i hans Sted. ");
INSERT INTO dan1931_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Da Bål Hanan, Akbors Søn, døde, blev Hadar Konge i hans Sted; hans By hed Pa'u, og hans Hustru hed Mehetab'el, en Datter af Matred, en Datter af Mezahab. ");
INSERT INTO dan1931_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Følgende var Navnene på Esaus Stammehøvdinger efter deres Slægter, Bosteder og Navne: Høvdingerne Timna, Alva, Jetet, ");
INSERT INTO dan1931_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO dan1931_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO dan1931_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel og Iram. Det var Edoms Stammehøvdinger efter deres Boliger i det Land, de fik i Eje. Det var Esau, Edoms Fader. ");
INSERT INTO dan1931_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Men Jakob blev boende i sin Faders Udlændigheds Land, i Kana'ans Land. ");
INSERT INTO dan1931_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dette er Jakobs Slægtebog. Da Josef var sytten År gammel, vogtede han Småkvæget sammen med sine Brødre; som Dreng var han hos sin Faders Hustruer Bilhas og Zilpas Sønner, og han bragte ondt Rygte om dem til deres Fader. ");
INSERT INTO dan1931_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel elskede Josef fremfor alle sine andre Sønner, fordi han var hans Alderdoms Søn, og han lod gøre en fodsid Kjortel med Ærmer til ham. ");
INSERT INTO dan1931_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Men da hans Brødre så, at deres Fader foretrak ham for alle sine andre Sønner, fattede de Nag til ham og kunde ikke tale venligt til ham. ");
INSERT INTO dan1931_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Men Josef havde en Drøm, som han fortalte sine Brødre, og som yderligere øgede deres Had til ham. ");
INSERT INTO dan1931_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Han sagde til dem “Hør dog, hvad jeg har drømt! ");
INSERT INTO dan1931_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Se, vi bandt Neg ude på Marken, og se, mit Neg rejste sig op og blev stående, medens eders Neg stod rundt omkring og bøjede sig for det!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Da sagde hans Brødre til ham: “Vil du måske være vor Konge eller herske over os?” Og de hadede ham endnu mere for hans Drømme og hans Ord. ");
INSERT INTO dan1931_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Men han havde igen en Drøm, som han fortalte sine Brødre; han sagde: “Jeg har haft en ny Drøm, og se, Sol og Måne og elleve Stjerner bøjede sig for mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Da han fortalte sin Fader og sine Brødre det, skændte hans Fader på ham og sagde: “Hvad er det for en Drøm, du der har haft Skal virkelig jeg, din Moder og dine Brødre komme og bøje os til Jorden for dig?” ");
INSERT INTO dan1931_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Og hans Brødre fattede Avind til ham, men hans Fader gemte det i sit Minde. ");
INSERT INTO dan1931_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Da hans Brødre engang var gået hen for at vogte deres Faders Småkvæg ved Sikem, ");
INSERT INTO dan1931_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","sagde Israel til Josef: “Dine Brødre vogter jo Kvæg ved Sikem; kom, jeg vil sende dig til dem!” Han svarede: “Her er jeg!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Så sagde Israel til ham: “Gå hen og se, hvorledes det står til med dine Brødre og Kvæget, og bring mig Bud tilbage!” Israel sendte ham så af Sted fra Hebrons Dal, og han kom til Sikem. ");
INSERT INTO dan1931_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Som han nu flakkede om på Marken, var der en Mand, som traf ham og spurgte: “Hvad søger du efter?” ");
INSERT INTO dan1931_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Han svarede: “Efter mine Brødre; sig mig, hvor de vogter deres Kvæg!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Da sagde Manden: “De er draget bort herfra, thi jeg hørte dem sige: Lad os gå til Dotan!” Så gik Josef efter sine Brødre og fandt dem i Dotan. ");
INSERT INTO dan1931_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Men da de så ham langt borte, før han endnu var kommet hen til dem, lagde de Råd op om at dræbe ham ");
INSERT INTO dan1931_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","og sagde til hverandre: “Se, der kommer den Drømmemester! ");
INSERT INTO dan1931_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kom, lad os slå ham ihjel og kaste ham i en Cisterne og sige, at et vildt Dyr har ædt ham; så skal vi se, hvad der kommer ud af hans Drømme!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Men da Ruben hørte det, vilde han redde ham af deres Hånd og sagde: “Lad os ikke tage hans Liv!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Og Ruben sagde til dem: “Udgyd dog ikke Blod! Kast ham i Cisternen her på Marken, men læg ikke Hånd på ham!” Han vilde nemlig redde ham af deres Hånd og bringe ham tilbage til Faderen. ");
INSERT INTO dan1931_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Da Josef nu kom hen til sine Brødre, rev de hans Kjortel af ham, Ærmekjortelen, han havde på, ");
INSERT INTO dan1931_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","tog ham og kastede ham i Cisternen; men Cisternen var tom, der var intet Vand i den. ");
INSERT INTO dan1931_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Derpå satte de sig til at holde Måltid. Og da de så op, fik de Øje på en Karavane af Ismaelitter, der kom fra Gilead, og deres Kameler var belæssede med Tragakantgummi, Mastiksbalsam og Cistusharpiks, som de var på Vej til Ægypten med. ");
INSERT INTO dan1931_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Så sagde Juda til sine Brødre: “Hvad vinder vi ved at slå vor Broder ihjel og skjule Mordet? ");
INSERT INTO dan1931_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Lad os hellere sælge ham til Ismaelitterne og ikke lægge Hånd på ham; han er jo dog vor Broder, vort Kød og Blod!” Og hans Brødre gik ind på Forslaget. ");
INSERT INTO dan1931_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Da nu midjanitiske Købmænd kom der forbi, trak de Josef op af Cisternen. Og de solgte Josef til Ismaelitterne for tyve Sekel Sølv, og disse bragte ham så til Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Da Ruben nu kom tilbage til Cisternen, se, da var Josef der ikke. Så sønderrev han sine Klæder ");
INSERT INTO dan1931_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","og gik tilbage til sine Brødre og sagde: “Drengen er borte! Hvad skal jeg dog gøre!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Så tog de Josefs Kjortel og dyppede den i Blodet af en Gedebuk, som de slagtede; ");
INSERT INTO dan1931_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","og de sendte Ærmekjortelen hjem til deres Fader med det Bud: “Den har vi fundet se efter, om det ikke er din Søns Kjortel!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Da så han efter og udbrød: “Det er min Søns Kjortel! Et vildt Dyr har ædt ham! Josef er visselig revet ihjel!” ");
INSERT INTO dan1931_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Så sønderrev Jakob sine Klæder og bandt Sæk om sine Lænder, og han sørgede over sin Søn i mange Dage. ");
INSERT INTO dan1931_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Og skønt alle hans Sønner og Døtre kom til ham for at trøste ham, vilde han ikke lade sig trøste, men sagde: “Nej, i min Sørgedragt vil jeg stige ned til min Søn i Dødsriget!” Og hans Fader begræd ham. ");
INSERT INTO dan1931_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Men Midjanitterne solgte ham I Ægypten til Faraos Hofmand Potifar, Livvagtens Øverste. ");
INSERT INTO dan1931_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ved den Tid forlod Juda sine Brødre og sluttede sig til en Mand fra Adullam ved Navn Hira. ");
INSERT INTO dan1931_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Der så Juda en Datter af Kana'anæeren Sjua, og han tog hende til Ægte og gik ind til hende. ");
INSERT INTO dan1931_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Hun blev frugtsommelig og fødte en Søn, som hun gav Navnet Er; ");
INSERT INTO dan1931_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","siden blev hun frugtsommelig igen og fødte en Søn, som hun gav Navnet Onan; ");
INSERT INTO dan1931_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","og hun fødte endnu en Søn, som hun gav Navnet Sjela; da hun fødte ham, var hun i, Kezib. ");
INSERT INTO dan1931_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda tog Er, sin førstefødte, en Hustru, der hed Tamar. ");
INSERT INTO dan1931_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Men Er, Judas førstefødte, vakte HERRENS Mishag, derfor lod HERREN ham dø. ");
INSERT INTO dan1931_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Da sagde Juda til Onan: “Gå ind til din Svigerinde og indgå Svogerægteskab med hende for at skaffe din Broder Afkom!” ");
INSERT INTO dan1931_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Men Onan, som vidste, at Afkommet ikke vilde blive hans, lod, hver Gang han gik ind til sin Svigerinde, sin Sæd spildes på Jorden for ikke at skaffe sin Broder Afkom. ");
INSERT INTO dan1931_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Denne hans Adfærd vakte HERRENS Mishag, derfor lod han også ham dø. ");
INSERT INTO dan1931_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Da sagde Juda til sin Sønnekone Tamar: “Bliv som Enke i din Faders Hus, til min Søn Sjela bliver voksen!” Thi han var bange for, at han også skulde dø ligesom sine Brødre. Så gik Tamar hen og blev i sin Faders Hus. ");
INSERT INTO dan1931_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Lang Tid efter døde Judas Hustru, Sjuas Datter; og da Juda var hørt op at sørge over hende, rejste han med sin Ven, Hira fra Adullam, op til dem, der klippede hans Får i Timna. ");
INSERT INTO dan1931_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Og da Tamar fik at vide, at hendes Svigerfader var på Vej op til Fåreklipningen i Timna, ");
INSERT INTO dan1931_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","aflagde hun sine Enkeklæder, hyllede sig i et Slør, så det skjulte hende, og satte sig ved indgangen til Enajim ved Vejen til Timna; thi hun så, at hun ikke blev givet Sjela til Ægte, skønt han nu var voksen. ");
INSERT INTO dan1931_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Da nu Juda så hende, troede han, det var en Skøge; hun havde jo tilhyllet sit Ansigt; ");
INSERT INTO dan1931_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","og han bøjede af fra Vejen og kom hen til hende og sagde: “Lad mig gå ind til dig!” Thi han vidste ikke, at det var hans Sønnekone. Men hun sagde: “Hvad giver du mig derfor!” ");
INSERT INTO dan1931_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Han svarede: “Jeg vil sende dig et Gedekid fra Hjorden!” Da sagde hun: “Ja, men du skal give mig et Pant, indtil du sender det!” ");
INSERT INTO dan1931_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Han spurgte: “Hvad skal jeg give dig i Pant?” Hun svarede: “Din Seglring, din Snor og din Stav, som du har i Hånden!” Så gav han hende de tre Ting og gik ind til hende, og hun blev frugtsommelig ved ham. ");
INSERT INTO dan1931_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Derpå gik hun bort, tog Sløret af og iførte sig sine Enkeklæder. ");
INSERT INTO dan1931_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Imidlertid sendte Juda sin Ven fra Adullam med Gedekiddet for at få Pantet tilbage fra Kvinden; men han fandt hende ikke. ");
INSERT INTO dan1931_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Han spurgte da Folkene på Stedet: “Hvor er den Skøge, som sad på Vejen ved Enajim?” Og de svarede: “Her har ikke været nogen Skøge!” ");
INSERT INTO dan1931_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Så vendte han tilbage til Juda og sagde: “Jeg fandt hende ikke, og Folkene på Stedet siger, at der har ikke været nogen Skøge.” ");
INSERT INTO dan1931_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Da sagde Juda: “Så lad hende beholde det, hellere end at vi skal blive til Spot; jeg har nu sendt det Kid, men du fandt hende ikke.” ");
INSERT INTO dan1931_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","En tre Måneders Tid efter meldte man Juda: “Din Sønnekone Tamar har øvet Utugt og er blevet frugtsommelig!” Da sagde Juda: “Før hende ud, for at hun kan blive brændt!” ");
INSERT INTO dan1931_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Men da hun førtes ud, sendte hun Bud til sin Svigerfader og lod sige: “Jeg er blevet frugtsommelig ved den Mand, som ejer disse Ting.” Og hun lod sige: “Se dog efter, hvem der ejer denne Ring, denne Snor og denne Stav!” ");
INSERT INTO dan1931_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Da Juda havde set efter, sagde han: “Retten er på hendes Side og ikke på min, fordi jeg ikke gav hende til min Søn Sjela!” Men siden havde han ikke Omgang med hende. ");
INSERT INTO dan1931_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Da Tiden kom, at hun skulde føde, se, da var der Tvillinger i hendes Liv. ");
INSERT INTO dan1931_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Under Fødselen stak der en Hånd frem, og Jordemoderen tog og bandt en rød Snor om den, idet hun sagde: “Det var ham, der først kom frem.” ");
INSERT INTO dan1931_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Men han trak Hånden tilbage. og Broderen kom frem; så sagde hun: “Hvorfor bryder du frem? For din Skyld er der sket et Brud*.” Derfor gav man ham Navnet Perez. { *på hebr. samme Ord som Perez. } ");
INSERT INTO dan1931_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Derefter kom Broderen med den røde snor om Hånden frem, og ham kaldte man Zera. ");
INSERT INTO dan1931_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Da Josef var bragt ned til Ægypten, blev han af Ismaelitterne, der havde bragt ham derned, solgt til Faraos Hofmand Potifar, Livvagtens Øverste, en Ægypter. ");
INSERT INTO dan1931_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Men HERREN var med Josef, så Lykken fulgte ham. Han var i sin Herre Ægypterens Hus; ");
INSERT INTO dan1931_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","og hans Herre så, at HERREN var med ham, og at HERREN lod alt, hvad han foretog sig, lykkes for ham. ");
INSERT INTO dan1931_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Således fandt Josef Nåde for hans Øjne og kom til at gå ham til Hånde; og han satte ham over sit Hus og gav alt, hvad han ejede, i hans Hånd; ");
INSERT INTO dan1931_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","og fra det Øjeblik han satte ham over sit Hus og alt, hvad han ejede, velsignede HERREN Ægypterens Hus for Josefs Skyld, og HERRENS Velsignelse hvilede over alt, hvad han ejede, både inde og ude; ");
INSERT INTO dan1931_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","og han betroede alt, hvad han ejede, til Josef, og selv bekymrede han sig ikke om andet end den Mad, han spiste. Men Josef havde en smuk Skikkelse og så godt ud. ");
INSERT INTO dan1931_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Nu hændte det nogen Tid derefter, at hans Herres Hustru kastede sine Øjne på Josef og sagde: “Kom og lig hos mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Men han vægrede sig og sagde til sin Herres Hustru: “Se, min Herre bekymrer sig ikke om noget i Huset, men alt, hvad han ejer, har han givet i min Hånd; ");
INSERT INTO dan1931_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","han har ikke større Magt i Huset end jeg, og han har ikke unddraget mig noget som helst undtagen dig, fordi du er hans Hustru - hvor skulde jeg da kunne øve denne store Misgerning og synde mod Gud!” ");
INSERT INTO dan1931_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Og skønt hun Dag efter Dag talte Josef til, vilde han dog ikke føje hende i at ligge hos hende og have med hende at gøre. ");
INSERT INTO dan1931_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Men en Dag han kom ind i Huset for at gøre sin Gerning, og ingen af Husfolkene var til Stede i Huset, ");
INSERT INTO dan1931_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","greb hun fat i hans Kappe og sagde: “Kom og lig hos mig!” Men han lod Kappen blive i hendes Hånd og flygtede ud af Huset. ");
INSERT INTO dan1931_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Da hun nu så, at han havde ladet hende beholde Kappen og var flygtet ud af Huset, ");
INSERT INTO dan1931_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kaldte hun på sine Husfolk og sagde til dem: “Her kan I se! Han har bragt os en Hebræer til at drive Spot med os! Han kom ind til mig og vilde ligge hos mig, men jeg råbte af alle Kræfter, ");
INSERT INTO dan1931_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","og da han hørte, at jeg gav mig til at råbe, lod han sin Kappe blive hos mig og flygtede ud af Huset!” ");
INSERT INTO dan1931_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Så lod hun Kappen blive liggende hos sig, indtil hans Herre kom hjem, ");
INSERT INTO dan1931_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","og sagde så det samme til ham: “Den hebraiske Træl, du bragte os til at drive Spot med os, kom ind til mig; ");
INSERT INTO dan1931_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","men da jeg gav mig til at råbe, lod han sin Kappe blive hos mig og flygtede ud af Huset.” ");
INSERT INTO dan1931_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Da hans Herre hørte sin Hustrus Ord: “Således har din Træl behandlet mig!” blussede Vreden op i ham; ");
INSERT INTO dan1931_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","og Josefs Herre tog ham og kastede ham i Fængsel der, hvor Kongens Fanger sad fængslet. Således kom Josef i Fængsel. ");
INSERT INTO dan1931_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Men HERREN var med Josef og skaffede ham Yndest og lod ham finde Nåde hos Fængselets Overopsynsmand, ");
INSERT INTO dan1931_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","så at han gav ham Opsyn over alle Fangerne i Fængselet, og han sørgede for alt, hvad der skulde gøres der. ");
INSERT INTO dan1931_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Fængselets Overopsynsmand førte ikke Tilsyn med noget som helst af, hvad der var lagt i Josefs Hånd, eftersom HERREN var med ham og lod alt, hvad han foretog sig, lykkes. ");
INSERT INTO dan1931_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Nogen Tid efter hændte det, at Ægypterkongens Mundskænk og Bager forbrød sig mod deres Herre Ægypterkongen, ");
INSERT INTO dan1931_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","og Farao vrededes på sine to Hofmænd, Overmundskænken og Overbageren, ");
INSERT INTO dan1931_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","og lod dem sætte i Forvaring i Livvagtens Øverstes Hus, i samme Fængsel, hvor Josef sad fængslet; ");
INSERT INTO dan1931_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","og Livvagtens Øverste gav dem Josef til Opvartning, og han gik dem til Hånde. Da de nu havde været i Forvaring en Tid lang, ");
INSERT INTO dan1931_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","drømte Ægypterkongens Mundskænk og Bager, som sad i Fængselet, samme Nat hver sin Drøm med sin særlige Betydning. ");
INSERT INTO dan1931_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Da Josef om Morgenen kom ind til Faraos Hofmænd, der sammen med ham var i Forvaring i hans Herres Hus, og så, at de var nedslåede, ");
INSERT INTO dan1931_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","spurgte han dem: “Hvorfor ser I så ulykkelige ud i Dag?” ");
INSERT INTO dan1931_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Besvarede: “Vi har haft en Drøm, og her er ingen, som kan tyde den.” Da sagde Josef til dem: “Er det ikke Guds Sag at tyde Drømme? Fortæl mig det da!” ");
INSERT INTO dan1931_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Så fortalte Overmundskænken Josef sin Drøm og sagde: “Jeg så i Drømme en Vinstok for mig; ");
INSERT INTO dan1931_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","på Vinstokken var der tre Ranker, og næppe havde den sat Skud. før Blomsterne sprang ud, og Klaserne bar modne Druer; ");
INSERT INTO dan1931_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","og jeg havde Faraos Bæger i Hånden og tog Druerne og pressede dem i Faraos Bæger og rakte Farao det.” ");
INSERT INTO dan1931_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Da sagde Josef: “Det skal udtydes således: De tre Ranker betyder tre Dage; ");
INSERT INTO dan1931_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","om tre Dage skal Farao løfte dit Hoved og genindsætte dig i dit Embede, så du atter rækker Farao Bægeret som før, da du var hans Mundskænk. ");
INSERT INTO dan1931_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Vilde du nu blot tænke på mig, når det går dig vel, og vise mig Godhed og omtale mig for Farao og således hjælpe mig ud af dette Hus; ");
INSERT INTO dan1931_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","thi jeg er stjålet fra Hebræernes Land og har heller ikke her gjort noget, de kunde sætte mig i Fængsel for.” ");
INSERT INTO dan1931_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Da nu Overbageren så, at Josef gav Mundskænken en gunstig Tydning, sagde han til ham: “Jeg havde en lignende Drøm: Se, jeg bar tre Kurve Hvedebrød på mit Hoved. ");
INSERT INTO dan1931_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","I den øverste Kurv var der alle Hånde Bagværk til Faraos Bord, men Fuglene åd det af Kurven på mit Hoved!” ");
INSERT INTO dan1931_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Da sagde Josef: “Det skal udtydes således: De tre Kurve betyder tre Dage; ");
INSERT INTO dan1931_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","om tre Dage skal Farao løfte dit Hoved og hænge dig op på en Pæl, og Fuglene skal æde Kødet af din Krop!” ");
INSERT INTO dan1931_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tre Dage efter, da det var Faraos Fødselsdag, gjorde han et Gæstebud for alle sine Tjenere, og da løftede han Overmundskænkens og Overbagerens, Hoveder iblandt sine Tjenere. ");
INSERT INTO dan1931_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Overmundskænken genindsatte han i hans Embede, så han atter rakte Farao Bægeret, ");
INSERT INTO dan1931_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","og Overbageren lod han hænge, som Josef havde tydet det for dem. ");
INSERT INTO dan1931_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Men Overmundskænken tænkte ikke på Josef; han glemte ham. ");
INSERT INTO dan1931_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","To År senere hændte det, at Farao havde en drøm. Han drømte, at han stod ved Nilen; ");
INSERT INTO dan1931_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","og se, op af Floden steg der syv smukke og fede Køer, som gav sig til at græsse i Engen; ");
INSERT INTO dan1931_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","efter dem steg der syv andre Køer op af Nilen, usle at se til og magre, og de stillede sig ved Siden af de første Køer på Nilens Bred; ");
INSERT INTO dan1931_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","og de usle og magre Køer åd de syv smukke og fede Køer. Så vågnede Farao. ");
INSERT INTO dan1931_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Men han sov ind og havde en Drøm og så syv tykke og gode Aks skyde frem på et og samme Strå; ");
INSERT INTO dan1931_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","men efter dem voksede der syv golde og vindsvedne Aks frem; ");
INSERT INTO dan1931_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","og de golde Aks slugte de syv tykke og fulde Aks. Så vågnede Farao, og se, det var en Drøm. ");
INSERT INTO dan1931_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Men om Morgenen var hans Sind uroligt; og han sendte Bud efter alle Ægyptens Tegnsudlæggere og Vismænd og fortalte dem sin Drøm, men ingen kunde tyde den for Farao. ");
INSERT INTO dan1931_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Da sagde Overmundskænken til Farao: “Jeg må i Dag minde om mine Synder. ");
INSERT INTO dan1931_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Den Gang Farao vrededes på sine Tjenere og lod dem sætte i Forvaring i Livvagtens Øverstes Hus, mig og Overbageren, ");
INSERT INTO dan1931_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","da drømte vi engang samme Nat hver en Drøm med sin særlige Betydning. ");
INSERT INTO dan1931_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Sammen med os var der en Hebraisk Yngling, som var Træl hos Livvagtens Øverste, og da vi fortalte ham vore Drømme, tydede han dem for os, hver på sin Måde; ");
INSERT INTO dan1931_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","og som han tydede dem for os, således gik det: Jeg blev indsat i mit Embede, og Bageren blev hængt.” ");
INSERT INTO dan1931_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Da sendte Farao Bud efter Josef, og man fik ham hurtigt ud af Fangehullet; og efter at have ladet sig rage og skiftet Klæder fremstillede han sig for Farao. ");
INSERT INTO dan1931_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Så sagde Farao til Josef: “Jeg har haft en Drøm, som ingen kan tyde; og nu har jeg hørt om dig, at du kun behøver at høre en Drøm, så kan du tyde den.” ");
INSERT INTO dan1931_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josef svarede Farao: “Ikke jeg - men Gud vil give Farao et gunstigt Svar!” ");
INSERT INTO dan1931_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Da sagde Farao til Josef: “Jeg drømte, at jeg stod på Nilens Bred; ");
INSERT INTO dan1931_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","og se, op af Floden steg der syv fede og smukke Køer, som gav sig til at græsse i Engen; ");
INSERT INTO dan1931_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","efter dem steg der syv andre Køer op, ringe, såre usle og magre, så usle Dyr har jeg ikke set nogetsteds i Ægypten; ");
INSERT INTO dan1931_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","og de magre og usle Køer åd de syv første, fede Køer; ");
INSERT INTO dan1931_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","men da de havde slugt dem, var det ikke til at kende på dem; de så lige så usle ud som før. Så vågnede jeg. ");
INSERT INTO dan1931_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Men jeg sov atter ind og så i Drømme syv fulde og gode Aks skyde frem på et og samme Strå; ");
INSERT INTO dan1931_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","men efter dem voksede der syv udtørrede, golde og vindsvedne Aks frem, ");
INSERT INTO dan1931_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","og de golde Aks slugte de syv gode Aks. Det fortalte jeg mine Tegnsudlæggere, men ingen kunde forklare mig det.” ");
INSERT INTO dan1931_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Da sagde Josef til Farao: “Faraos Drømme betyder begge det samme, og Gud har kundgjort Farao, hvad han vil gøre. ");
INSERT INTO dan1931_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","De syv gode Køer betyder syv År; de syv gode Aks betyder ligeledes syv År; det er en og samme Drøm. ");
INSERT INTO dan1931_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Og de syv magre og usle Køer, der steg op efter dem, betyder syv År, og de syv golde og vindsvedne Aks betyder syv Hungersnødsår. ");
INSERT INTO dan1931_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Det var det, jeg mente, når jeg sagde til Farao: Hvad Gud vil gøre, har han ladet Farao skue! ");
INSERT INTO dan1931_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Se, der kommer syv År med stor Overflod i hele Ægypten; ");
INSERT INTO dan1931_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","men efter dem kommer der syv Hungersnødsår, og man skal gemme al Overfloden i Ægypten; og Hungersnøden skal hærge Jorden, ");
INSERT INTO dan1931_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","så man intet mærker til Overfloden på Jorden på Grund af den påfølgende Hungersnød; thi den bliver såre hård. ");
INSERT INTO dan1931_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Men at Drømmen gentog sig to Gange for Farao, betyder, at Sagen er fast besluttet af Gud, og at han snart vil lade det ske. ");
INSERT INTO dan1931_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Men nu skulde Farao udse sig en indsigtsfuld og klog Mand og sætte ham over Ægypten, ");
INSERT INTO dan1931_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","og Farao skulde tage og indsætte Tilsynsmænd over Landet og opkræve Femtedelen af Ægyptens Afgrøde i Overflodens syv År; ");
INSERT INTO dan1931_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","og de skal samle al Afgrøden fra de gode År, der kommer, og oplagre Høsten som Faraos Eje og bringe Afgrøden under Lås og Lukke i Byerne, ");
INSERT INTO dan1931_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","for at Afgrøden kan tjene til Forråd for Landet i Hungersnødens syv År, som skal komme over Ægypten, at ikke Landet skal gå til Grunde ved Hungersnøden.” ");
INSERT INTO dan1931_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Både Farao og alle hans Tjenere syntes godt om den Tale, ");
INSERT INTO dan1931_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","og Farao sagde til sine Tjenere: “Hvor finder vi en Mand, i hvem Guds Ånd er som i ham?” ");
INSERT INTO dan1931_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Og Farao sagde til Josef: “Efter at Gud har åbenbaret dig alt dette. kan ingen måle sig med dig i Indsigt og Kløgt; ");
INSERT INTO dan1931_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","du skal forestå mit Hus, og efter dit Ord skal alt mit Folk rette sig; kun Tronen vil jeg have forud for dig.” ");
INSERT INTO dan1931_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Og Farao sagde til Josef: “Så sætter jeg dig nu over hele Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Og Farao tog Seglringen af sin Hånd og satte den på Josefs, klædte ham i fine Linnedklæder og hængte Guldkæden om hans Hals: ");
INSERT INTO dan1931_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","han lod ham køre i sin næstbedste Vogn, og de råbte Abrek* for ham. Således satte han ham over hele Ægypten. { *formodentlig et Hyldestråb. } ");
INSERT INTO dan1931_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Og Farao sagde til Josef: “Jeg er Farao, men uden dit Minde skal ingen røre Hånd eller Fod nogetsteds i Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Derpå gav Farao Josef Navnet Zafenat-Panea, og han lod ham ægte Asenat, en Datter af Præsten Potifera i On; og Josef drog omkring i Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josef var tredive År gammel. da han stededes for Farao, Ægyptens Konge. Så forlod Josef Farao og drog omkring i hele Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Og Landet bar i bugnende Fylde i Overflodens syv År; ");
INSERT INTO dan1931_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","og Josef samlede al Afgrøden i de syv År, i hvilke der var Overflod i Ægypten, og bragte den til Byerne; i hver By samlede han Afgrøden fra Markerne der omkring. ");
INSERT INTO dan1931_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Således ophobede Josef Korn i vældig Mængde, som Havets Sand, indtil man opgav at måle det, da det ikke var til at måle. ");
INSERT INTO dan1931_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Før Hungersnødens År kom. fik Josef to Sønner med Asenat, Præsten i On Potiferas Datter; ");
INSERT INTO dan1931_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","og Josef gav den førstefødte Navnet Manasse*, thi han sagde: “Gud har ladet mig glemme al min Møje og hele min Faders Hus.” { *på hebr. Ordspil med Navnet Manasse. } ");
INSERT INTO dan1931_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Og den anden gav han Navnet Efraim*, thi han sagde: “Gud har givet mig Livsfrugt i min Elendigheds Land.” { *på hebr. Ordspil med Navnet Efraim. } ");
INSERT INTO dan1931_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Da Overflodens syv År, som kom over Ægypten, var omme, ");
INSERT INTO dan1931_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","begyndte Hungersnødens syv År, som Josef havde sagt; og der opstod Hungersnød i alle Lande, men i hele Ægypten var der Brød. ");
INSERT INTO dan1931_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Så hungrede hele Ægypten; og Folket råbte til Farao om Brød; men Farao sagde til alle Ægypterne: “Gå til Josef og gør, hvad han siger eder!” ");
INSERT INTO dan1931_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Og der var Hungersnød over hele Jorden. Da åbnede Josef for alle Kornlagrene og solgte Korn til Ægypterne; men Hungersnøden tog til i Ægypten; ");
INSERT INTO dan1931_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","og Alverden kom til Ægypten for at købe Korn hos Josef; thi Hungersnøden tog til over hele Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Da Jakob hørte, at der var Korn at få i Ægypten, sagde han til sine Sønner: “Hvad venter I efter?” ");
INSERT INTO dan1931_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Og han sagde: “Jeg hører, at der er Korn at få i Ægypten; drag ned og køb os noget, at vi kan blive i Live og undgå Døden!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Så drog de ti af Josefs Brødre ned for at købe Korn i Ægypten; ");
INSERT INTO dan1931_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","men Jakob sendte ikke Josefs Broder Benjamin med hans Brødre, thi han tænkte, der kunde tilstøde ham en Ulykke. ");
INSERT INTO dan1931_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Blandt dem, der kom for at købe Korn, var også Israels Sønner; thi der var Hungersnød i Kana'ans Land. ");
INSERT INTO dan1931_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Og da Josef var Hersker i Landet, og han var den, der solgte Korn til alt Folket i Landet, så kom Josefs Brødre og kastede sig til Jorden for ham. ");
INSERT INTO dan1931_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Da Josef så sine Brødre, kendte han dem; men han lod fremmed over for dem, talte dem hårdt til og sagde til dem: “Hvorfra kommer I?” De svarede: “Fra Kana'ans Land for at købe Føde!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josef kendte sine Brødre, men de kendte ikke ham. ");
INSERT INTO dan1931_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Da kom Josef de Drømme i Hu. han havde drømt om dem; og han sagde til dem; “I er Spejdere, I kommer for at se, hvor Landet er åbent!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","De svarede: “Nej, Herre, dine Trælle kommer for at købe Føde! ");
INSERT INTO dan1931_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Vi er alle Sønner af en og samme Mand; vi er ærlige Folk, dine Trælle er ikke Spejdere!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Men han sagde: “Jo vist så! I kommer for at se, hvor Landet er åbent!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","De svarede: “Vi, dine Trælle. var tolv Brødre, Sønner af en og samme Mand i Kana'ans Land; den yngste er for Tiden hjemme hos vor Fader, og én er ikke mere!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Men Josef sagde til dem: “Det er, som jeg siger eder: I er Spejdere! ");
INSERT INTO dan1931_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Men nu skal I sættes på Prøve: Så sandt Farao lever, slipper I ikke herfra, uden at eders yngste Broder kommer hid! ");
INSERT INTO dan1931_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Lad en af eder rejse hjem for at hente eders Broder, og imedens holdes I andre fangne; så vil det. vise sig, om eders Ord er Sandhed; og hvis ikke, så er I, så sandt Farao lever, Spejdere!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Derpå holdt han dem i Forvaring tre Dage. ");
INSERT INTO dan1931_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Men Tredjedagen sagde Josef til dem: “Vil I beholde Livet, så skal I gøre således, thi jeg er en Mand, der frygter Gud: ");
INSERT INTO dan1931_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Er I virkelig ærlige Folk, lad så en af eder blive tilbage som Fange i det Fængsel, som I sad i, medens I andre drager hjem med Korn til at stille Hungeren i eders Huse; ");
INSERT INTO dan1931_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","og bring så eders yngste Broder til mig, så skal eders Ord stå til Troende, og I skal slippe for at dø!” Og således gjorde de. ");
INSERT INTO dan1931_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Da sagde de til hverandre: “Sandelig, nu må vi bøde for, hvad vi forbrød mod vor Broder, da vi så hans Sjælevånde, medens han bønfaldt os, og dog ikke hørte ham; derfor stedes vi nu i denne Vånde!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Men Ruben tog til Orde og sagde til dem: “Sagde jeg eder ikke dengang: Forsynd eder ikke mod Drengen! Men I vilde ikke høre; se, nu kræves hans Blod!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Således talte de. Men de vidste ikke, at Josef forstod det, thi han forhandlede med dem ved Tolk; ");
INSERT INTO dan1931_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","og han vendte sig bort fra dem og græd. Siden vendte han sig til dem og talte med dem; og han tog Simeon fra dem og lod ham fængsle for deres Øjne. ");
INSERT INTO dan1931_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Så gav Josef Befaling til at fylde deres Sække med Korn og lægge Pengene tilbage i hver enkelts Sæk og give dem Rejsekost; og således skete det. ");
INSERT INTO dan1931_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Så læssede de deres Korn på Æslerne og drog bort. ");
INSERT INTO dan1931_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Men da en af dem i Natteherberget åbnede sin Sæk for at give sit Æsel Foder, fik han Øje på sine Penge, der lå oven i Sækken; ");
INSERT INTO dan1931_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","og han sagde til sine Brødre: “Mine Penge er kommet igen; se, de er i min Sæk!” Da sank Hjertet i Livet på dem, og de så forfærdede på hverandre og sagde: “Hvad har Gud dog gjort imod os!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Og da de kom hjem til deres Fader Jakob i Kana'ans Land, fortalte de ham alt, hvad der var hændet dem, og sagde: ");
INSERT INTO dan1931_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Manden, der er Landets Herre, talte os hårdt til og holdt os i Forvaring, som var vi Folk, der vilde udspejde Landet; ");
INSERT INTO dan1931_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","men vi sagde til ham: Vi er ærlige Folk og ikke Spejdere; ");
INSERT INTO dan1931_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","vi var tolv Brødre, Sønner af en og samme Fader; én er ikke mere, og den yngste er for Tiden hjemme hos vor Fader i Kana'ans Land. ");
INSERT INTO dan1931_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Så sagde Manden, der er Landets Herre: Derpå vil jeg kende, at I er ærlige Folk: Lad en af eder blive hos mig, og tag I andre Korn til at stille Hungeren i eders Huse og drag hjem! ");
INSERT INTO dan1931_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Siden skal I bringe eders yngste Broder til mig, for at jeg kan kende, at I ikke er Spejdere, men ærlige Folk; så vil jeg udlevere eders Broder til eder, og I kan frit rejse i Landet.” ");
INSERT INTO dan1931_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Da de nu tømte deres Sække, fandt hver sin Pengepose i sin Sæk; og da de og deres Fader så Pengeposerne, blev de forfærdede. ");
INSERT INTO dan1931_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Og deres Fader Jakob sagde til dem: “I gør mig barnløs; Josef er ikke mere, og Simeon er ikke mere, og nu vil I tage Benjamin; det går alt sammen ud over mig!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Så sagde Ruben til sin Fader: “Du må tage mine to Sønners Liv, hvis jeg ikke bringer ham til dig; betro ham til mig, og jeg skal bringe ham tilbage til dig!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Men han sagde: “Min Søn skal ikke rejse derned med eder, thi hans Broder er død, og han alene er tilbage; tilstøder der ham en Ulykke på den Rejse, I har for, så bringer I mine grå Hår ned i Dødsriget med Sorg!” ");
INSERT INTO dan1931_vpl VALUES ("GN42_39","002_42_39","GEN","42","39","39","Men Hungersnøden var hård i Landet; ");
INSERT INTO dan1931_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","og da de havde fortæret det Korn, de havde hentet i Ægypten, sagde deres Fader til dem: “Køb os igen lidt Føde!” ");
INSERT INTO dan1931_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Men Juda svarede ham: “Manden sagde os ganske afgjort: I bliver ikke stedt for mit Åsyn, medmindre eders Broder er med! ");
INSERT INTO dan1931_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Hvis du derfor vil sende vor Broder med os, vil vi rejse ned og købe dig Føde; ");
INSERT INTO dan1931_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","men sender du ham ikke med, så rejser vi ikke derned, thi Manden sagde til os: I bliver ikke stedt for mit Åsyn, medmindre eders Broder er med!” ");
INSERT INTO dan1931_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Så sagde Israel: “Hvorfor handlede I ilde imod mig og fortalte Manden, at I havde en Broder til?” ");
INSERT INTO dan1931_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","De svarede: “Manden spurgte os nøje ud om os og vor Slægt og sagde: Lever eders Fader endnu? Har I en Broder til? Og vi svarede ham på hans Spørgsmål; kunde vi vide, at han vilde sige: Bring eders Broder herned!” ");
INSERT INTO dan1931_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Men Juda sagde til sin Fader Israel: “Send dog Drengen med mig, så vi kan komme af Sted og blive i Live og undgå Døden, både vi og du og vore Børn! ");
INSERT INTO dan1931_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Jeg svarer for ham, af min Hånd må du kræve ham: bringer jeg ham ikke til dig og stiller ham for dit Åsyn, vil jeg være din Skyldner for bestandig; ");
INSERT INTO dan1931_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","havde vi nu ikke spildt Tiden, kunde vi have været tilbage to Gange!” ");
INSERT INTO dan1931_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Så sagde deres Fader Israel til dem: “Kan det ikke være anderledes, gør da i alt Fald således: Tag noget af det bedste, Landet frembringer, med i eders Sække og bring Manden en Gave, lidt Mastiksbalsam, lidt Honning, Tragakantgummi, Cistusharpiks, Pistacienødder og Mandler; ");
INSERT INTO dan1931_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","og tag dobbelt så mange Penge med, så I bringer de Penge tilbage, som var lagt oven i eders Sække; måske var det en Fejltagelse; ");
INSERT INTO dan1931_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","og tag så eders Broder og drag atter til Manden! ");
INSERT INTO dan1931_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Gud den Almægtige lade eder finde Barmhjertighed hos Manden, så han lader eders anden Broder og Benjamin fare - men skal jeg være barnløs, så lad mig da blive det!” ");
INSERT INTO dan1931_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Så tog Mændene deres Gave og dobbelt så mange Penge med; også Benjamin tog de med, brød op og drog ned til Ægypten, hvor de fremstillede sig for Josef. ");
INSERT INTO dan1931_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Da Josef så Benjamin iblandt dem, sagde han til sin Hushovmester: “Bring de Mænd ind i mit Hus, lad slagte og lave til, thi de skal spise til Middag hos mig.” ");
INSERT INTO dan1931_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Manden gjorde, som Josef bød, og førte Mændene ind i Josefs Hus. ");
INSERT INTO dan1931_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Men Mændene blev bange, da de førtes ind i Josefs Hus, og sagde: “Det er for de Penges Skyld, der forrige Gang kom tilbage i vore Sække, at vi føres herind, for at de kan vælte sig ind på os og kaste sig over os, gøre os til Trælle og tage vore Æsler.” ");
INSERT INTO dan1931_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Derfor trådte de hen til Josefs Hushovmester ved Døren til Huset ");
INSERT INTO dan1931_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","og sagde: “Hør os, Herre! Vi drog en Gang før herned for at købe Føde, ");
INSERT INTO dan1931_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","og da vi kom til vort Natteherberge og åbnede vore Sække, se. da lå vore Penge oven i hver enkelts Sæk, vore Penge til sidste Hvid. Men nu har vi bragt dem med tilbage ");
INSERT INTO dan1931_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","og desuden andre Penge for at købe Føde. Vi ved ikke, hvem der har lagt Pengene i vore Sække!” ");
INSERT INTO dan1931_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Men han svarede: “Vær ved godt Mod, frygt ikke! Eders Gud og eders Faders Gud har lagt en Skat i eders Sække - eders Penge har jeg modtaget!” Og han førte Simeon ud til dem. ");
INSERT INTO dan1931_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Så førte Manden dem ind i Josefs Hus og gav dem Vand til at tvætte deres Fødder og Foder til Æslerne. ");
INSERT INTO dan1931_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Og de fremtog deres Gave, før Josef kom hjem ved Middagstid, thi de hørte, at de skulde spise der. ");
INSERT INTO dan1931_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Da Josef trådte ind i Huset, bragte de ham den Gave, de havde med, og kastede sig til Jorden for ham. ");
INSERT INTO dan1931_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Han hilste på dem og spurgte: “Går det eders gamle Fader vel, ham, I talte om? Lever han endnu?” ");
INSERT INTO dan1931_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","De svarede: “Det går din Træl, vor Fader, vel; han lever endnu!” Og de bøjede sig og kastede sig til Jorden. ");
INSERT INTO dan1931_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Da han så fik Øje på sin kødelige Broder Benjamin, sagde han: “Er det så eders yngste Broder, som I talte til mig om?” Og han sagde: “Gud være dig nådig, min Søn!” ");
INSERT INTO dan1931_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Men Josef brød hurtigt af, thi Kærligheden til Broderen blussede op i ham, og han kæmpede med Gråden; derfor gik han ind i sit Kammer og græd der. ");
INSERT INTO dan1931_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Men da han havde badet sit Ansigt, kom han ud, og han beherskede sig og sagde: “Sæt Maden frem!” ");
INSERT INTO dan1931_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Så blev Maden sat frem særskilt for ham og for dem og for de Ægyptere, der spiste hos ham; thi Ægypterne kan ikke spise sammen med Hebræere, det er dem en Vederstyggelighed. ");
INSERT INTO dan1931_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","De blev bænket foran ham efter Alder, den førstefødte øverst og den yngste nederst, og Mændene undrede sig og så på hverandre; ");
INSERT INTO dan1931_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","og han lod dem bringe Mad fra sit eget Bord, og Benjamin fik fem Gange så meget som hver af de andre. Og de drak og blev lystige sammen med ham. ");
INSERT INTO dan1931_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Derefter befalede han sin Hushovmester: “Fyld Mændenes Sække med Korn, så meget de kan have med sig, og læg hvers Pengesum oven i hans Sæk ");
INSERT INTO dan1931_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","og læg mit eget Sølvbæger oven i den yngstes Sæk sammen med Pengene for hans Korn!” Og han gjorde, som Josef bød. ");
INSERT INTO dan1931_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Da Morgenen gryede, fik Mændene Lov at drage bort med deres Æsler. ");
INSERT INTO dan1931_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Men før de var kommet ret langt fra Byen, bød Josef sin Hushovmester: “Sæt efter Mændene, og når du indhenter dem, sig så til dem: Hvorfor har I gengældt godt med ondt? ");
INSERT INTO dan1931_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hvorfor har I stjålet mit Sølvbæger? Det er jo min Herres Mundbæger, som han bruger til at tage Varsler af! Ilde har I handlet ved at gøre således!” ");
INSERT INTO dan1931_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Og da han havde indhentet dem, sagde han det til dem. ");
INSERT INTO dan1931_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Men de svarede: “Hvor kan min Herre tale således? Det være langt fra dine Trælle at gøre sligt! ");
INSERT INTO dan1931_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Se, de Penge, vi fandt oven i vore Sække, bragte vi tilbage til dig fra Kana'ans Land - hvorfor skulde vi da stjæle Guld eller Sølv fra din Herres Hus! ");
INSERT INTO dan1931_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Den af dine Trælle, det findes hos, skal dø, og desuden vil vi andre være din Herres Trælle!” ");
INSERT INTO dan1931_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Han svarede: “Vel, lad det blive, som I siger: Den, Bægeret findes hos, skal være min Træl, men I andre skal være sagesløse!” ");
INSERT INTO dan1931_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Så skyndte de sig at løfte hver sin Sæk ned på Jorden og åbne den, ");
INSERT INTO dan1931_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","og han undersøgte dem fra den ældstes til den yngstes, og Bægeret blev fundet i Benjamins Sæk. ");
INSERT INTO dan1931_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Da sønderrev de deres Klæder, og efter at have læsset Sækkene hver på sit Æsel vendte de tilbage til Byen. ");
INSERT INTO dan1931_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Da Juda og hans Brødre kom ind i Josefs Hus, hvor han endnu var, kastede de sig til Jorden for ham; ");
INSERT INTO dan1931_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","men Josef sagde til dem: “Hvad har I gjort! Ved I ikke, at en Mand som jeg forstår sig på hemmelige Kunster?” ");
INSERT INTO dan1931_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Da sagde Juda: “Hvad skal vi svare min Herre, hvad skal vi sige, og hvorledes skal vi retfærdiggøre os? Gud har fundet dine Trælles Brøde! Se, vi er min Herres Trælle, både vi andre og han, Bægeret fandtes hos!” ");
INSERT INTO dan1931_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Men han svarede: “Det være langt fra mig at handle således; den, Bægeret fandtes hos, skal være min Træl, men I andre kan i Fred drage hjem til eders Fader.” ");
INSERT INTO dan1931_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Da trådte Juda hen til ham og sagde: “Hør mig, min Herre, lad din Træl tale et Ord for min Herres Øren og lad ikke Vreden blusse op i dig mod din Træl, thi du er jo som Farao! ");
INSERT INTO dan1931_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Min Herre spurgte sine Trælle Har I Fader eller Broder? ");
INSERT INTO dan1931_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Og vi svarede min Herre: Ja, vi har en gammel Fader, og der er en Dreng, som blev født i hans Alderdom; en Broder til ham er død, og selv er han den eneste, hans Moder efterlod sig, og hans Fader elsker ham. ");
INSERT INTO dan1931_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Så sagde du til dine Trælle: Bring ham med herned til mig, at jeg kan se ham med egne Øjne! ");
INSERT INTO dan1931_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Men vi svarede min Herre: Drengen kan ikke forlade sin Fader, thi hans Fader dør, hvis han forlader ham! ");
INSERT INTO dan1931_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Så sagde du til dine Trælle: Kommer eders yngste Broder ikke med herned, så bliver I ikke mere stedt for mit Åsyn! ");
INSERT INTO dan1931_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Vi rejste så op til din Træl. min Fader, og fortalte ham, hvad min Herre havde sagt. ");
INSERT INTO dan1931_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Da vor Fader siden sagde: Rejs atter hen og køb os lidt Føde! ");
INSERT INTO dan1931_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","svarede vi: Vi kan ikke rejse derned, hvis ikke vor yngste Broder følger med, thi vi bliver ikke stedt for Mandens Åsyn, medmindre vor yngste Broder er med! ");
INSERT INTO dan1931_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Så sagde din Træl, min Fader. til os: I ved jo, at min Hustru fødte mig to Sønner; ");
INSERT INTO dan1931_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","den ene gik bort fra mig, og jeg sagde: Han er sikkerlig revet ihjel! Og jeg har ikke set ham siden; ");
INSERT INTO dan1931_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","hvis I nu også tager denne fra mig, og der tilstøder ham en Ulykke, bringer I mine grå Hår i Dødsriget med Smerte! ");
INSERT INTO dan1931_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Kommer jeg derfor hjem til din Træl, min Fader, uden at Drengen. ved hvem han hænger med hele sin Sjæl, er med, ");
INSERT INTO dan1931_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","så bliver det hans Død, når han ser, at Drengen ikke er med. og dine Trælle vil bringe din Træl vor Faders grå Hår i Dødsriget med Sorg. ");
INSERT INTO dan1931_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Men din Træl skal svare sin Fader for Drengen, og jeg har forpligtet mig til at være hans Skyldner for bestandig, hvis jeg ikke bringer ham til ham; ");
INSERT INTO dan1931_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","lad derfor din Træl blive tilbage i Drengens Sted som min Herres Træl, men lad Drengen drage hjem med sine Brødre! ");
INSERT INTO dan1931_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Thi hvorledes skulde jeg kunne drage hjem til min Fader, når jeg ikke har Drengen med? Jeg vil ikke kunne være Vidne til den Ulykke, der rammer min Fader!” ");
INSERT INTO dan1931_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Da kunde Josef ikke længer beherske sig over for alle dem der stod hos ham, og han råbte “Lad alle gå ud!” Således var der ingen til Stede, da Josef gav sig til Kende for sine Brødre. ");
INSERT INTO dan1931_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Så brast han i lydelig Gråd, så Ægypterne hørte det, og det spurgtes i Faraos Hus; ");
INSERT INTO dan1931_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","og Josef sagde til sine Brødre: “Jeg er Josef! Lever min Fader endnu?” Men hans Brødre kunde ikke svare ham, så forfærdede var de for ham. ");
INSERT INTO dan1931_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Så sagde Josef til sine Brødre: “Kom hen til mig!” Og da de kom derhen, sagde Josef: “Jeg er eders Broder Josef, som I solgte til Ægypten; ");
INSERT INTO dan1931_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","men I skal ikke græmme eder eller være forknytte, fordi I solgte mig herhen, thi Gud har sendt mig forud for eder for at opholde Liv; ");
INSERT INTO dan1931_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","i to År har der nu været Hungersnød i Landet, og fem År endnu skal der hverken pløjes eller høstes; ");
INSERT INTO dan1931_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","derfor sendte Gud mig forud for eder, for at I kan få Efterkommere på Jorden, og for at mange hos eder kan reddes og holdes i Live. ");
INSERT INTO dan1931_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Og nu, ikke I, men Gud har sendt mig hid, og han har gjort mig til Fader hos Farao og til Herre over hele hans Hus og til Hersker over hele Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Skynd jer nu hjem til min Fader og sig til ham: Din Søn Josef lader sige: Gud har sat mig til Hersker over hele Ægypten; kom uden Tøven ned til mig ");
INSERT INTO dan1931_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","og tag Bolig i Gosens Land og bo i min Nærhed med dine Sønner og Sønnesønner, dit Småkvæg og Hornkvæg og alt, hvad du ejer og har; ");
INSERT INTO dan1931_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","der vil jeg sørge for dit Underhold - thi Hungersnøden vil vare fem År endnu - for at ikke du, dit Hus eller nogen, der hører dig til, skal gå til Grunde! ");
INSERT INTO dan1931_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Nu ser I, også min Broder Benjamin, med egne Øjne, at det er mig, der taler til eder; ");
INSERT INTO dan1931_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","og I skal fortælle min Fader om al min Herlighed i Ægypten og om alt, hvad I har set, og så skal I skynde eder at bringe min Fader herned.” ");
INSERT INTO dan1931_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Så faldt han grædende sin Broder Benjamin om Halsen, og Benjamin græd i hans Arme. ");
INSERT INTO dan1931_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Og han kyssede alle sine Brødre og græd ved deres Bryst; og nu kunde hans Brødre tale med ham. ");
INSERT INTO dan1931_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Men det spurgtes i Faraos Hus, at Josefs Brødre var kommet, og Farao og hans Tjenere glædede sig derover: ");
INSERT INTO dan1931_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","og Farao sagde til Josef: “Sig til dine Brødre: Således skal I gøre: Læs eders Dyr og drag til Kana'ans Land, ");
INSERT INTO dan1931_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","hent eders Fader og eders Familier og kom hid til mig, så vil jeg give eder det bedste, der er i Ægypten, og I skal nyde Landets Fedme. ");
INSERT INTO dan1931_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Byd dem at gøre således: Tag eder Vogne i Ægypten til eders Børn og Kvinder, sæt eders Fader op og kom hid; ");
INSERT INTO dan1931_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","bryd eder ikke om eders Ejendele, thi det bedste, der er i hele Ægypten, skal være eders!” ");
INSERT INTO dan1931_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Det gjorde Israels Sønner så. Og efter Faraos Bud gav Josef dem Vogne og Rejsekost med; ");
INSERT INTO dan1931_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","hver især gav han dem et Sæt Festklæder, men Benjamin gav han 300 Sekel Sølv og fem Sæt Festklæder; ");
INSERT INTO dan1931_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","og sin Fader sendte han ti Æsler med det bedste, der var i Ægypten og ti Aseninder med Korn, Brød og Rejsetæring til Faderen. ");
INSERT INTO dan1931_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Så tog han Afsked med sine Brødre, og da de drog bort, sagde han til dem: “Kives ikke på Vejen!” ");
INSERT INTO dan1931_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Således drog de hjem fra Ægypten og kom til deres Fader Jakob i Kana'ans Land; ");
INSERT INTO dan1931_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","og de fortalte ham det og sagde: “Josef lever endnu, og han er Hersker over hele Ægypten.” Men hans Hjerte blev koldt, thi han troede dem ikke. ");
INSERT INTO dan1931_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Så fortalte de ham alt, hvad Josef havde sagt til dem; og da han så Vognene, som Josef havde sendt for at hente ham, oplivedes deres Fader Jakobs Ånd atter; ");
INSERT INTO dan1931_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","og Israel sagde: “Det er stort, min Søn Josef lever endnu; jeg vil drage hen og se ham, inden jeg dør!” ");
INSERT INTO dan1931_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Da brød Israel op med alt, hvad han havde, og drog til Be'ersjeba, og han slagtede Ofre for sin Fader Isaks Gud. ");
INSERT INTO dan1931_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Men Gud sagde i et Nattesyn til Israel: “Jakob, Jakob!” Og han svarede: “Se, her er jeg!” ");
INSERT INTO dan1931_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Da sagde han: “Jeg er Gud, din Faders Gud, vær ikke bange for at drage ned til Ægypten, thi jeg vil gøre dig til et stort Folk der; ");
INSERT INTO dan1931_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","jeg vil selv drage med dig til Ægypten, og jeg vil også føre dig tilbage, og Josef skal lukke dine Øjne!” ");
INSERT INTO dan1931_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Da brød Jakob op fra Be'ersjeba; og Israels Sønner satte deres Fader Jakob og deres Børn og Kvinder på de Vogne, Farao havde sendt til at hente ham på. ");
INSERT INTO dan1931_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Og de tog deres Kvæg og al deres Ejendom, som de havde erhvervet sig i Kana'ans Land, og drog til Ægypten, Jakob og alt hans Afkom med ham; ");
INSERT INTO dan1931_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","således bragte han sine Sønner og Sønnesønner, sine Døtre og Sønnedøtre og alt sit Afkom med sig til Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Følgende er Navnene på Israels Sønner, der kom til Ægypten, Jakob og hans Sønner: Ruben, Jakobs førstefødte; ");
INSERT INTO dan1931_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubens Sønner Hanok, Pallu. Hezron og Karmi; ");
INSERT INTO dan1931_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeons Sønner Jemuel, Jamin, Ohad, Jakin, Zohar og Kana'anæerkvindens Søn Sjaul; ");
INSERT INTO dan1931_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levis Sønner Gerson, Kehat og Merari; ");
INSERT INTO dan1931_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judas Sønner Er, Onan, Sjela, Perez og Zera; men Er og Onan døde i Kana'ans Land. Perez' Sønner var Hezron og Hamul. ");
INSERT INTO dan1931_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issakars Sønner Tola, Pua, Jasjub og Sjimron; ");
INSERT INTO dan1931_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulons Sønner Sered, Elon og Jale'el; ");
INSERT INTO dan1931_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","det var Leas Sønner, som hun fødte Jakob i Paddan-Aram; desuden fødte hun ham Datteren Dina; det samlede Tal på hans Sønner og Døtre var tre og tredive. ");
INSERT INTO dan1931_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gads Sønner Zifjon, Haggi, Sjuni, Ezbon, Eri, Arodi og Ar'eli. ");
INSERT INTO dan1931_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asers Sønner Jimna, Jisjva, Jisjvi og Beri'a, og deres Søster Sera; og Beri'as Sønner Heber og Malkiel; ");
INSERT INTO dan1931_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","det var Sønnerne af Zilpa, som Laban gav sin Datter Lea, og som fødte Jakob dem, seksten i alt; ");
INSERT INTO dan1931_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rakels, Jakobs Hustrus, Sønner Josef og Benjamin; ");
INSERT INTO dan1931_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","og Josef fik Børn i Ægypten med Asenat, en Datter af Potifera, Præsten i On: Manasse og Efraim; ");
INSERT INTO dan1931_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamins Sønner Bela, Beker, Asjbel, Gera, Na'aman, Ehi, Rosj, Muppim, Huppim og Ard; ");
INSERT INTO dan1931_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","det var Rakels Sønner, som hun fødte Jakob, fjorten i alt; ");
INSERT INTO dan1931_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dans Søn Husjim; ");
INSERT INTO dan1931_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftalis Sønner Jaze'el, Guni, Jezer og Sjillem; ");
INSERT INTO dan1931_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","det var Sønnerne af Bilha, som Laban gav Rakel, og som fødte Jakob dem, syv i alt. ");
INSERT INTO dan1931_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Hele Jakobs Familie, der kom til Ægypten med ham, fraregnet Jakobs Sønnekoner, udgjorde tilsammen seks og tresindstyve; ");
INSERT INTO dan1931_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","og Josefs Sønner, der fødtes ham i Ægypten, var to; alle de af Jakobs Hus, der kom til Ægypten, udgjorde halvfjerdsindstyve. ");
INSERT INTO dan1931_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Men Juda sendte han i Forvejen til Josef, for at man skulde vise ham Vej til Gosen, og de kom til Gosens Land. ");
INSERT INTO dan1931_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Da lod Josef spænde for sin Vogn og rejste sin Fader i Møde til Gosen; og da han traf ham, omfavnede han ham og græd længe i hans Arme; ");
INSERT INTO dan1931_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","og Israel sagde til Josef: “Lad mig nu kun dø, da jeg har set dit Ansigt, at du endnu lever!” ");
INSERT INTO dan1931_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Men Josef sagde til sine Brødre og sin Faders Hus: “Jeg vil drage hen og melde det til Farao og sige til ham: Mine Brødre og min Faders Hus i Kana'an er kommet til mig; ");
INSERT INTO dan1931_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","disse Mænd er Hyrder, thi de driver Kvægavl, og de har bragt deres Småkvæg og Hornkvæg og alt, hvad de ejer, med. ");
INSERT INTO dan1931_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Når så Farao lader eder kalde og spørger eder, hvad I er, ");
INSERT INTO dan1931_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","skal I sige: Dine Trælle har drevet Kvægavl fra Barnsben af ligesom vore Fædre! for at I kan komme til at bo i Gosens Land. Thi enhver Hyrde er Ægypterne en Vederstyggelighed.” ");
INSERT INTO dan1931_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Så drog Josef hen og meldte det til Farao og sagde: “Min Fader og mine Brødre er kommet fra Kana'ans Land med deres Småkvæg og Hornkvæg og alt, hvad de ejer, og befinder sig i Gosen.” ");
INSERT INTO dan1931_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Og han tog fem af sine Brødre med sig og forestillede dem for Farao. ");
INSERT INTO dan1931_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Da nu Farao spurgte dem, hvad de var, svarede de: “Dine Trælle er Hyrder ligesom vore Fædre!” ");
INSERT INTO dan1931_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Og de sagde til Farao: “Vi er kommet for at bo som Gæster i Landet, thi der er ingen Græsning for dine Trælles Småkvæg, da Hungersnøden er trykkende i Kana'an, og nu vilde dine Trælle gerne bosætte sig i Gosen.” ");
INSERT INTO dan1931_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Da sagde Farao til Josef: “Din Fader og dine Brødre er kommet til dig; ");
INSERT INTO dan1931_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ægypten står til din Rådighed, lad din Fader og dine Brødre bosætte sig i den bedste Del af Landet; de kan tage Ophold i Gosens Land; og hvis du ved, at der er dygtige Folk iblandt dem, kan du sætte dem til Opsynsmænd over mine Hjorde!” ");
INSERT INTO dan1931_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Da hentede Josef sin Fader Jakob og forestillede ham for Farao, og Jakob velsignede Farao. ");
INSERT INTO dan1931_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao spurgte Jakob: “Hvor mange er dine Leveår?” ");
INSERT INTO dan1931_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob svarede ham: “Min Udlændigheds År er 130 År; få og onde var mine Leveår, og ikke når de op til mine Fædres År i deres Udlændigheds Tid.” ");
INSERT INTO dan1931_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Derpå velsignede Jakob Farao og gik bort fra ham. ");
INSERT INTO dan1931_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Men Josef lod sin Fader og sine Brødre bosætte sig og gav dem Jordegods i Ægypten, i den bedste Del af Landet, i Landet Ra'meses, som Farao havde befalet. ");
INSERT INTO dan1931_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Og Josef forsørgede sin Fader og sine Brødre og hele sin Faders Hus med Brød efter Børnenes Tal. ");
INSERT INTO dan1931_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Der fandtes ikke mere brød Korn i Landet, thi Hungersnøden var overvættes stor, og Ægypten og Kana'an vansmægtede af Sult. ");
INSERT INTO dan1931_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Da lod Josef alle de Penge samle, som var indkommet i Ægypten og Kana'an for det Korn, der købtes, og lod dem bringe til Faraos Hus. ");
INSERT INTO dan1931_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Men da Pengene slap op i Ægypten og Kana'an, kom hele Ægypten til Josef og sagde: “Giv os Brødkorn, at vi ikke skal dø for dine Øjne, thi Pengene er sluppet op!” ");
INSERT INTO dan1931_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josef svarede: “Kom med eders Hjorde, så vil jeg give eder Brødkorn for dem, siden Pengene er sluppet op.” ");
INSERT INTO dan1931_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Da bragte de deres Hjorde til Josef, og han gav dem Brødkorn for Hestene, for deres Hjorde af Småkvæg og Hornkvæg og for Æslerne; og han forsørgede dem i det År med Brødkorn for alle deres Hjorde. ");
INSERT INTO dan1931_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Men da Året var omme, kom de til ham det følgende År og sagde: “Vi vil ikke dølge det for min Herre; men Pengene er sluppet op, og Kvæget har vi bragt til min Herre; nu er der ikke andet tilbage for min Herre end vore Kroppe og vor Jord; ");
INSERT INTO dan1931_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","lad os dog ikke dø for dine Øjne, vi sammen med vor Jord, men køb os og vor Jord for Brødkorn, og lad os med vor Jord blive livegne for Farao, og giv os derfor Såsæd, så vi kan blive i Live og slippe for Døden, og vor Jord undgå at lægges øde!” ");
INSERT INTO dan1931_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Da købte Josef al Jord i Ægypten til Farao, idet enhver Ægypter solgte sin Mark, fordi Hungersnøden tvang dem, og således kom Landet i Faraos Besiddelse; ");
INSERT INTO dan1931_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","og Befolkningen gjorde han til hans Trælle i hele Ægypten fra Ende til anden. ");
INSERT INTO dan1931_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kun Præsternes Jord købte han ikke, thi de havde faste Indtægter fra Farao, og de levede af de Indtægter, Farao havde skænket dem; derfor behøvede de ikke at sælge deres Jord. ");
INSERT INTO dan1931_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Derpå sagde Josef til Folket: “Nu har jeg købt eder og eders Jord til Farao; nu har I Såsæd til Jorden; ");
INSERT INTO dan1931_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","men af Afgrøden skal I afgive en Femtedel til Farao, medens de fire Femtedele skal tjene eder til Såsæd på Marken og til Føde for eder og eders Husstand og til Føde for eders Børn.” ");
INSERT INTO dan1931_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","De svarede: “Du har reddet vort Liv; måtte vi eje min Herres Gunst, så vil vi være Faraos Trælle!” ");
INSERT INTO dan1931_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Således gjorde Josef det til en Vedtægt, der endnu den Dag i Dag gælder i Ægypten, at afgive en Femtedel til Farao; kun Præsternes Jord kom ikke i Faraos Besiddelse. ");
INSERT INTO dan1931_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel bosatte sig nu i Ægypten, i Gosens Land; og de tog fast Ophold der, blev frugtbare og såre talrige. ");
INSERT INTO dan1931_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakob levede i Ægypten i sytten År, så at Jakobs Levetid blev 147 År. ");
INSERT INTO dan1931_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Da nu Tiden nærmede sig, at Israel skulde dø, kaldte han sin Søn Josef til sig og sagde til ham: “Hvis jeg har fundet Nåde for dine Øjne, så læg din Hånd under min Lænd og lov mig at vise mig den Kærlighed og Trofasthed ikke at jorde mig i Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Når jeg har lagt mig til Hvile hos mine Fædre, skal du føre mig fra Ægypten og jorde mig i deres Grav!” Han svarede: “Jeg skal gøre, som du siger.” ");
INSERT INTO dan1931_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Da sagde han: “Tilsværg mig det!” Og han tilsvor ham det. Da bøjede Israel sig tilbedende over Lejets Hovedgærde. ");
INSERT INTO dan1931_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Efter disse Begivenheder fik Josef Melding om, at hans Fader var syg. Da tog han sine Sønner, Manasse og Efraim, med sig. ");
INSERT INTO dan1931_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Da det nu meldtes Jakob, at hans Søn Josef var kommet, tog Israel sig sammen og satte sig oprejst på Lejet. ");
INSERT INTO dan1931_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakob sagde til Josef: “Gud den Almægtige åbenbarede sig for mig i Luz i Kana'ans Land og velsignede mig; ");
INSERT INTO dan1931_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","og han sagde til mig: Jeg vil gøre dig frugtbar og give dig et talrigt Afkom og gøre dig til en Mængde Stammer, og jeg vil give dit Afkom efter dig Land til evigt Eje! ");
INSERT INTO dan1931_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Nu skal dine to Sønner, der er født dig i Ægypten før mit komme til dig her i Ægypten, være mine, Efraim og Manasse skal være mine så godt som Ruben og Simeon; ");
INSERT INTO dan1931_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","derimod skal de Børn, du har fået efter dem, være dine; men de skal nævnes efter deres Brødres Navne i deres Arvelod. ");
INSERT INTO dan1931_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Da jeg kom fra Paddan, døde Rakel for mig, medens jeg var undervejs i Kana'an, da vi endnu var et stykke Vej fra Efrat, og jeg jordede hende der på vejen til Efrat, det er Betlehem”. ");
INSERT INTO dan1931_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Da Israel så Josefs Sønner, sagde han: “Hvem bringer du der?” ");
INSERT INTO dan1931_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josef svarede sin Fader: “Det er mine Sønner, som Gud har skænket mig her.” Da sagde han: “Bring dem hen til mig, at jeg kan velsigne dem!” ");
INSERT INTO dan1931_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Men Israels Øjne var svækkede af Alderdom, så at han ikke kunde se. Da førte han dem hen til ham. og han kyssede og omfavnede dem. ");
INSERT INTO dan1931_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Og Israel sagde til Josef: “Jeg havde ikke turdet håbe at få dit Ansigt at se, og nu har Gud endog: ladet mig se dit Afkom!” ");
INSERT INTO dan1931_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Derpå tog Josef dem bort fra hans Knæ og kastede sig til Jorden. på sit Ansigt. ");
INSERT INTO dan1931_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josef tog så dem begge, Efraim i sin højre Hånd til venstre for Israel og Manasse i sin venstre Hånd til højre for Israel, og førte dem hen til ham; ");
INSERT INTO dan1931_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","men Israel udrakte sin højre Hånd og lagde den på Efraims Hoved, uagtet han var den yngste, og sin venstre Hånd lagde han på Manasses Hoved, så at han lagde Hænderne over Kors; thi Manasse var den førstefødte. ");
INSERT INTO dan1931_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Derpå velsignede han Josef og sagde: “Den Gud, for hvis Åsyn mine Fædre Abraham og Isak vandrede, den Gud, der har vogtet mig: fra min første Færd og til nu, ");
INSERT INTO dan1931_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","den Engel, der har udløst mig fra alt ondt, velsigne Drengene, så at mit Navn og mine Fædre Abrahams og Isaks Navn må blive nævnet ved dem, og de må vokse i Mængde i Landet!” ");
INSERT INTO dan1931_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Men da Josef så, at hans Fader lagde sin højre Hånd på Efraims Hoved, var det ham imod, og han greb sin Faders Hånd for at tage den bort fra Efraims Hoved og lægge den på Manasses; ");
INSERT INTO dan1931_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","og Josef sagde til sin Fader: “Nej, ikke således, Fader, thi denne er den førstefødte; læg din højre Hånd på hans Hoved!” ");
INSERT INTO dan1931_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Men hans Fader vægrede sig og sagde: “Jeg ved det, min Søn, jeg ved det! Også han skal blive til et Folk, også han skal blive stor; men hans yngre Broder skal blive større end han, og hans Afkom skal blive en Mangfoldighed af Folkeslag!” ");
INSERT INTO dan1931_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Således velsignede han dem på den Dag og sagde: “Med eder skal Israel velsigne og sige: Gud gøre dig som Efraim og Manasse!” Og han stillede Efraim foran Manasse. ");
INSERT INTO dan1931_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Da sagde Israel til Josef: “Jeg skal snart dø, men Gud skal være med eder og føre eder tilbage til eders Fædres Land. ");
INSERT INTO dan1931_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Dig giver jeg ud over dine Brødre en Højderyg*, som jeg har fravristet Amoritterne med mit Sværd og min Bue!” { *Det hebr. Ord indeholder en Hentydning til Sikem. (1 Mos. 33, 18.) } ");
INSERT INTO dan1931_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Derpå kaldte Jakob sine Sønner til sig og sagde: “Saml eder, så vil jeg forkynde eder, hvad der skal hændes eder i de sidste Dage: ");
INSERT INTO dan1931_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kom hid og hør, Jakobs Sønner, lyt til eders Fader Israel! ");
INSERT INTO dan1931_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, du er min førstefødte, min Styrke og min Mandskrafts første, ypperst i Højhed, ypperst i Kraft! ");
INSERT INTO dan1931_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Du skummer over som Vandet, men du mister din Forret; thi du besteg din Faders Leje. Skændigt handled du da han besteg mit Leje! ");
INSERT INTO dan1931_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon og Levi, det Broder Par, Voldsredskaber er deres Våben. ");
INSERT INTO dan1931_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","I deres Råd giver min Sjæl ej Møde, i deres Forsamling tager min Ære* ej Del; thi i Vrede dræbte de Mænd, egenrådigt lamslog de Okser. { *dvs. min Sjæl. 1 Mos. 34, 25. Judit 9, 2. } ");
INSERT INTO dan1931_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Forbandet være deres Vrede, så vild den er, deres Hidsighed, så voldsom den er! Jeg spreder dem i Jakob, splitter dem ad i Israel! ");
INSERT INTO dan1931_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, dig skal dine Brødre prise*, din Hånd skal gribe dine Fjender i Nakken, din Faders Sønner skal bøje sig for dig. { *på hebr. Ordspil med Navnet Juda. 1 Krøn. 5, 2. } ");
INSERT INTO dan1931_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","En Løveunge er Juda. Fra Rov stiger du op, min Søn! Han ligger og strækker sig som en Løve, ja, som en Løvinde, hvo tør vække ham! ");
INSERT INTO dan1931_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ikke viger Kongespir fra Juda, ej Herskerstav fra hans Fødder, til han, hvem den tilhører; kommer*, ham skal Folkene lyde. { *Ez. 21, 27. Kan også oversettes: “indtil han kommer til Silo”. } ");
INSERT INTO dan1931_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Han binder sit Æsel ved Vinstokken, ved Ranken Asenindens Fole, tvætter i Vin sin Kjortel, sin Kappe i Drueblod, ");
INSERT INTO dan1931_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","med Øjnene dunkle af Vin og Tænderne hvide af Mælk! ");
INSERT INTO dan1931_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon har hjemme ved Havets Kyst, han bor ved Skibenes Kyst, hans Side er vendt mod Zidon. ");
INSERT INTO dan1931_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar, det knoglede Æsel, der strækker sig mellem Foldene, ");
INSERT INTO dan1931_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","fandt Hvilen sød og Landet lifligt; derfor bøjed han Ryg under Byrden og blev en ufri Træl. ");
INSERT INTO dan1931_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan dømmer* sit Folk så godt som nogen Israels Stamme. { *på hebr. Ordspil med Navnet Dan. } ");
INSERT INTO dan1931_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan blive en Slange ved Vejen, en Giftsnog ved Stien, som bider Hesten i Hælen, så Rytteren styrter bagover! - ");
INSERT INTO dan1931_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","På din Frelse bier jeg, HERRE! ");
INSERT INTO dan1931_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, på ham gør Krigerskarer Indhug, men han gør Indhug* i Hælene på dem. { *på hebr. Ordspil med Navnet Gad. } ");
INSERT INTO dan1931_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, hans Føde er fed, Lækkerier for Konger har han at give. ");
INSERT INTO dan1931_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali er en løssluppen Hind, han fremfører yndig Tale. ");
INSERT INTO dan1931_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Et yppigt Vintræ er Josef, et yppigt Vintræ ved Kilden, Ranker slynger sig over Muren. ");
INSERT INTO dan1931_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Bueskytter fejder imod ham, strides med ham, gør Angreb på ham, ");
INSERT INTO dan1931_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","men hans Bue er stærk, hans Hænders Arme rappe; det kommer fra Jakobs Vældige, fra Hyrden, Israels Klippe, ");
INSERT INTO dan1931_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","fra din Faders Gud - han hjælpe dig! Og Gud den Almægtige, han velsigne dig med Himmelens Velsignelser oventil og Dybets Velsignelser nedentil, med Brysters og Moderlivs Velsignelser! ");
INSERT INTO dan1931_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Din Faders Velsignelser overgår de ældgamle Bjerges Velsignelser, de evige Højes Herlighed. Måtte de komme over Josefs Hoved, over Issen på Fyrsten blandt Brødre! ");
INSERT INTO dan1931_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin, den rovlystne Ulv, om Morgenen æder han Rov, om Aftenen deler han Bytte!” ");
INSERT INTO dan1931_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Alle disse er Israels Stammer, tolv i Tal, og det var, hvad deres Fader talte til dem, og han velsignede dem, hver især af dem gav han sin særlige Velsignelse. ");
INSERT INTO dan1931_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Og han sagde til dem som sin sidste Vilje: “Nu samles jeg til mit Folk; jord mig da hos mine Fædre i Hulen på Hetitten Efrons Mark. ");
INSERT INTO dan1931_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","i Hulen på Makpelas Mark over for Mamre i Kana'ans Land. den Mark, som Abraham købte af Hetitten Efron til Gravsted, ");
INSERT INTO dan1931_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","hvor de jordede Abraham og hans Hustru Sara, hvor de jordede Isak og hans Hustru Rebekka, og hvor jeg jordede Lea. ");
INSERT INTO dan1931_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Marken og Hulen derpå blev købt af Hetitterne.” ");
INSERT INTO dan1931_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Dermed havde Jakob givet sine Sønner sin Vilje til Kende, og han strakte sine Fødder ud på Lejet. udåndede og samledes til sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Da kastede Josef sig over sin Faders Ansigt, græd og kyssede ham; ");
INSERT INTO dan1931_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","og Josef befalede de lægekyndige blandt sine Tjenere at balsamere hans Fader, og Lægerne balsamerede Israel. ");
INSERT INTO dan1931_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dermed gik fyrretyve Dage, thi så lang Tid tager Balsameringen: og Ægypterne begræd ham i halvfjerdsindstyve Dage. ");
INSERT INTO dan1931_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Da Grædetiden var omme, sagde Josef til Faraos Husfolk: “Hvis I har Godhed for mig, så sig på mine Vegne til Farao: ");
INSERT INTO dan1931_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Min Fader tog mig i Ed, idet han sagde: Når jeg er død, så jord mig i den Grav, jeg lod mig grave i Kana'ans Land! Lad mig derfor drage op og jorde min Fader og så vende tilbage hertil!” ");
INSERT INTO dan1931_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Da sagde Farao: “Drag kun op og jord din Fader, som han har ladet dig sværge.” ");
INSERT INTO dan1931_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Så drog Josef op for at jorde sin Fader, og med ham drog alle Faraos Tjenere, de ypperste i hans Hus og de ypperste i Ægypten, ");
INSERT INTO dan1931_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","hele Josefs Hus og hans Brødre og hans Faders Hus, kun deres Kvinder og Børn, Småkvæg og Hornkvæg lod de blive tilbage i Gosen; ");
INSERT INTO dan1931_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","og med ham fulgte både Stridsvogne og Ryttere, så det blev en overmåde stor Karavane. ");
INSERT INTO dan1931_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Da de kom til Goren-ha-atad hinsides Jordan, holdt de der en overmåde stor og højtidelig Dødeklage, og han fejrede Sørgefest for sin Fader i syv Dage. ");
INSERT INTO dan1931_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Men da Landets Indbyggere, Kana'anæerne, så denne Sørgefest i Goren-ha-atad, sagde de: “Ægypterne* holder en højtidelig Sørgefest*.” Derfor gav man det Navnet Abel Mizrajim; det ligger hinsides Jordan. { *på hebr. Hentydning til Navnet Abel-Misrajim. } ");
INSERT INTO dan1931_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Og hans Sønner gjorde, som han havde pålagt dem; ");
INSERT INTO dan1931_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","hans Sønner førte ham til Kana'ans Land og jordede ham i Hulen på Makpelas Mark, den Mark, som Abraham havde købt til Gravsted af Hetitten Efron over for Mamre. ");
INSERT INTO dan1931_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Efter at have jordet sin Fader vendte Josef tilbage til Ægypten med sine Brødre og alle dem, der var draget op med ham til hans Faders Jordefærd. ");
INSERT INTO dan1931_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Da Josefs Brødre så, at deres Fader var død, sagde de: “Blot nu ikke Josef vil vise sig fjendsk mod os og gengælde os alt det onde, vi har gjort ham!” ");
INSERT INTO dan1931_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Derfor sendte de Bud til Josef og sagde: “Din Fader pålagde os før sin Død ");
INSERT INTO dan1931_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","at sige til Josef: Tilgiv dog dine Brødres Brøde og Synd, thi de har gjort ondt imod dig! Så tilgiv nu din Faders Guds Tjenere deres Brøde!” Da græd Josef over deres Ord til ham. ");
INSERT INTO dan1931_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Siden kom hans Brødre selv og faldt ham til Fode og sagde: “Se, vi vil være dine Trælle!” ");
INSERT INTO dan1931_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Da sagde Josef til dem: “Frygt ikke, er jeg vel i Guds Sted? ");
INSERT INTO dan1931_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","I tænkte ondt mod mig, men Gud tænkte at vende det til det gode for at gøre, hvad nu er sket, og holde mange Folk i Live; ");
INSERT INTO dan1931_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","frygt ikke, jeg vil sørge for eder og eders Kvinder og Børn!” Således trøstede han dem og satte Mod i dem. ");
INSERT INTO dan1931_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josef blev nu i Ægypten, både han og hans Faders Hus, og Josef blev 110 År gammel. ");
INSERT INTO dan1931_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josef så Børn i tredje Led af Efraim; også Børn af Manasses Søn Makir fødtes på Josefs Knæ*. { *dvs. han adopterede dem. } ");
INSERT INTO dan1931_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Derpå sagde Josef til sine Brødre: “Jeg dør snart, men Gud vil se til eder og føre eder fra Landet her til det Land, han tilsvor Abraham, Isak og Jakob.” ");
INSERT INTO dan1931_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Og Josef tog Israels Sønner i Ed og sagde: “Når Gud ser til eder, skal I føre mine Ben bort herfra!” ");
INSERT INTO dan1931_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josef døde 110 År gammel, og man balsamerede ham og lagde ham i Kiste i Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Dette er Navnene på Israels Sønner, der sammen med Jakob kom til Ægypten med deres Familier: ");
INSERT INTO dan1931_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi og Juda, ");
INSERT INTO dan1931_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zebulon og Benjamin, ");
INSERT INTO dan1931_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan og Naftali, Gad og Aser. ");
INSERT INTO dan1931_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jakobs Efterkommere udgjorde i alt halvfjerdsindstyve, men Josef var i Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Imidlertid døde Josef og alle hans Brødre og hele dette Slægtled. ");
INSERT INTO dan1931_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Men Israelitterne var frugtbare og formerede sig, og de blev mange og overmåde talrige, så at Landet blev fuldt af dem. ");
INSERT INTO dan1931_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Da kom der en ny Konge over Ægypten, som ikke vidste noget om Josef; ");
INSERT INTO dan1931_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","og han sagde til sit Folk: “Se, Israels Folk bliver talrigere og stærkere end vi. ");
INSERT INTO dan1931_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Velan, lad os gå klogt til Værks imod dem, for at de ikke skal blive for mange; ellers kan det hænde, når vi kommer i Krig, at de går over til vore Modstandere og kæmper mod os og til sidst forlader Landet!” ");
INSERT INTO dan1931_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Så satte man Fogeder over dem til at plage dem med Trællearbejde, og de måtte bygge Forrådsbyer for Farao: Pitom og Ra'amses. ");
INSERT INTO dan1931_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Men jo mere man plagede dem, des flere blev de, og des mere bredte de sig, så Ægypterne fik Rædsel for Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Og Ægypterne tvang Israelitterne til Trællearbejde ");
INSERT INTO dan1931_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","og gjorde dem Livet bittert ved hårdt Arbejde med Ler og Tegl og alle Hånde Markarbejde, ved alt det Arbejde, de tvang dem til at udføre for sig. ");
INSERT INTO dan1931_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ægypterkongen sagde da til Hebræerkvindernes Jordemødre, af hvilke den ene hed Sjifra, den anden Pua: ");
INSERT INTO dan1931_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Når I forløser Hebræerkvinderne, skal I se godt efter ved Fødselen, og er det et Drengebarn, tag så Livet af det, men er det et Pigebarn, lad det så leve!” ");
INSERT INTO dan1931_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Men Jordemødrene frygtede Gud og gjorde ikke, som Ægypterkongen havde befalet dem, men lod Drengebørnene leve. ");
INSERT INTO dan1931_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Da lod Ægypterkongen Jordemødrene kalde og sagde til dem: “Hvorfor har I båret eder således ad og ladet Drengebørnene leve?” ");
INSERT INTO dan1931_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Men Jordemødrene svarede Farao: “Hebræerkvinderne er ikke som de Ægyptiske Kvinder, de har let ved at føde; inden Jordemoderen kommer til dem, har de allerede født!” ");
INSERT INTO dan1931_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Og Gud gjorde vel imod Jordemødrene, og Folket blev stort og såre talrigt; ");
INSERT INTO dan1931_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","og Gud gav Jordemødrene Afkom, fordi de frygtede ham. ");
INSERT INTO dan1931_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Da udstedte Farao den Befaling til hele sit Folk: “Alle Drengebørn, der fødes, skal I kaste i Nilen, men Pigebørnene skal I lade leve!” ");
INSERT INTO dan1931_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Og en Mand af Levis Hus gik hen og tog en Levi Datter til Ægte, ");
INSERT INTO dan1931_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","og Kvinden blev frugtsommelig og fødte en Søn. Da hun så, at det var en dejlig Dreng, skjulte hun ham i tre Måneder; ");
INSERT INTO dan1931_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","og da hun ikke længer kunde holde ham skjult, tog hun en Kiste af Papyrusrør, tættede den med Jordbeg og Tjære, lagde drengen i den og satte den hen mellem Sivene ved Nilens Bred. ");
INSERT INTO dan1931_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Og hans Søster stillede sig noget derfra for at se, hvad der vilde ske med ham. ");
INSERT INTO dan1931_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Da kom Faraos Datter ned til Nilen for at bade, og imedens gik hendes Jomfruer ved Flodens Bred. Så fik hun Øje på Kisten mellem Sivene og sendte sin Pige hen for at hente den. ");
INSERT INTO dan1931_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Og da hun åbnede den, så hun Barnet, og se, det var et Drengebarn, der græd. Da ynkedes hun over det og sagde: “Det må være et af Hebræernes Drengebørn!” ");
INSERT INTO dan1931_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Hans Søster sagde nu til Faraos Datter: “Skal jeg gå hen og hente dig en Amme blandt Hebræerkvinderne til at amme Barnet for dig?” ");
INSERT INTO dan1931_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Faraos Datter svarede hende: “Ja, gør det!” Så gik Pigen hen og hentede Barnets Moder. ");
INSERT INTO dan1931_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Og Faraos Datter sagde til hende: “Tag dette Barn med dig og am ham for mig, jeg skal nok give dig din Løn derfor!” Og Kvinden tog Barnet og ammede ham. ");
INSERT INTO dan1931_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Men da Drengen var blevet stor, bragte hun ham til Faraos Datter, og denne antog ham som sin Søn og gav ham Navnet Moses; “thi,” sagde hun, “jeg har trukket ham op* af Vandet.” { *på hebr. Ordspil med Navnet Moses. } ");
INSERT INTO dan1931_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","På den Tid gik Moses, som imidlertid var blevet voksen, ud til sine Landsmænd og så på deres Trællearbejde. Og han så en Ægypter slå en Hebræer, en af hans Landsmænd, ihjel. ");
INSERT INTO dan1931_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Da så han sig om til alle Sider, og efter at have forvisset sig om, at der ingen var i Nærheden, slog han Ægypteren ihjel og gravede ham ned i Sandet. ");
INSERT INTO dan1931_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Da han den næste Dag igen gik derud, så han to Hebræere i Slagsmål med hinanden. Da sagde han til ham, der havde Uret: “Hvorfor slår du din Landsmand?” ");
INSERT INTO dan1931_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Han svarede: “Hvem har sat dig til Herre og Dommer over os? Vil du måske slå mig ihjel, ligesom du slog Ægypteren ihjel?” Og Moses blev bange og tænkte: “Så er det dog blevet bekendt!” ");
INSERT INTO dan1931_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Da Farao fik Nys derom, søgte han at komme Moses til Livs, men Moses flygtede for Farao og tyede til Midjans Land, og der satte han sig ved en Brønd. ");
INSERT INTO dan1931_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Præsten i Midjan havde syv Døtre; de kom nu hen og øste Vand og fyldte Trugene for at vande deres Faders Småkvæg. ");
INSERT INTO dan1931_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Da kom Hyrderne og vilde jage dem bort, men Moses stod op og hjalp dem og vandede deres Småkvæg. ");
INSERT INTO dan1931_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Da de nu kom hjem til deres Fader Reuel, sagde han: “Hvorfor kommer I så tidligt hjem i Dag?” ");
INSERT INTO dan1931_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","De svarede: “Der var en Ægypter, som hjalp os over for Hyrderne, ja han øste også Vand for os og vandede Småkvæget.” ");
INSERT INTO dan1931_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Da sagde han til sine Døtre: “Hvor er han da? Hvorfor har I ladet Manden blive derude? Byd ham ind, at han kan få noget at spise!” ");
INSERT INTO dan1931_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Så bestemte Moses sig til at tage Ophold hos Manden, og han gav Moses sin Datter Zippora til Ægte, ");
INSERT INTO dan1931_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","og hun fødte en Søn, som han kaldte Gersom; “thi,” sagde han, “jeg er blevet Gæst* i et fremmed Land.” { *på hebr. Ordspil med Navnet Gersom. } ");
INSERT INTO dan1931_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Således gik der lang Tid hen, og imidlertid døde Ægypterkongen. Men Israelitterne stønnede og klagede under deres Trældom, og deres Skrig over Trældommen nåede op til Gud. ");
INSERT INTO dan1931_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Da hørte Gud deres Jamren, og Gud ihukom sin Pagt med Abraham, Isak og Jakob, ");
INSERT INTO dan1931_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","og Gud så til Israelitterne, og Gud kendtes ved dem. ");
INSERT INTO dan1931_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses vogtede nu Småkvæget for sin Svigerfader Jetro, Præsten i Midjan, og drev engang Småkvæget hen hinsides Ørkenen og kom til Guds Bjerg Horeb. ");
INSERT INTO dan1931_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Da åbenbarede HERRENS Engel sig for ham i en Ildslue, der slog ud af en Tornebusk, og da han så nærmere til, se, da stod Tornebusken i lys Lue, uden at den blev fortæret. ");
INSERT INTO dan1931_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Da sagde Moses: “Lad mig gå hen og se på dette underfulde Skue, hvorfor Tornebusken ikke brænder op.” ");
INSERT INTO dan1931_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Men da HERREN så, at han gik hen for at se derpå, råbte Gud til ham fra Tornebusken: “Moses, Moses!” Og han svarede: “Se, her er jeg!” ");
INSERT INTO dan1931_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Da sagde han: “Kom ikke nærmere! Drag dine Sko af dine Fødder, thi det Sted, du står på, er hellig Jord!” ");
INSERT INTO dan1931_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Og han sagde: “Jeg er din Faders Gud, Abrahams Gud, Isaks Gud og Jakobs Gud.” Da skjulte Moses sit Ansigt, thi han frygtede for at skue Gud. ");
INSERT INTO dan1931_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Derpå sagde HERREN: “Jeg har set mit Folks Elendighed i Ægypten, og jeg har hørt deres Klageskrig over deres Undertrykkere, ja, jeg kender deres Lidelser; ");
INSERT INTO dan1931_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","og jeg er steget ned for at udfri dem af Ægyptens Hånd og føre dem bort fra dette Land til et godt og vidtstrakt Land, til et Land, der flyder med Mælk og Honning, til Kana'anæernes, Hetitternes, Amoritternes, Perizzitternes, Hivvitternes og Jebusitternes Egn. ");
INSERT INTO dan1931_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Se, nu er Israelitternes Klageskrig nået til mig, og jeg har også set den Trængsel, Ægypterne har bragt over dem. ");
INSERT INTO dan1931_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Derfor vil jeg nu sende dig til Farao, og du skal føre mit Folk, Israelitterne, ud af Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Men Moses sagde til Gud: “Hvem er jeg, at jeg skulde kunne gå til Farao og føre Israelitterne ud af Ægypten?” ");
INSERT INTO dan1931_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Han svarede: “Jo, jeg vil være med dig! Og dette skal være dig Tegnet på, at det er mig, der har sendt dig: Når du har ført Folket ud af Ægypten, skal I dyrke Gud på dette Bjerg!” ");
INSERT INTO dan1931_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Men Moses sagde til Gud: “Når jeg kommer til Israelitterne og siger dem, at deres Fædres Gud har sendt mig til dem, hvad skal jeg så svare dem, hvis de spørger om hans Navn?” ");
INSERT INTO dan1931_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Gud svarede Moses: “Jeg er den, jeg er!” Og han sagde: “Således skal du sige til Israelitterne: JEG ER* har sendt mig til eder!” { *Tydnig af Navnet Jahve (se Ordforklaringen under Herren.) } ");
INSERT INTO dan1931_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Og Gud sagde fremdeles til Moses: “Således skal du sige til Israelitterne: HERREN, eders Fædres Gud, Abrahams Gud, Isaks Gud og Jakobs Gud, har sendt mig til eder; dette er mit Navn til evig Tid, og således skal jeg kaldes fra Slægt til Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Gå nu hen og kald Israels Ældste sammen og sig til dem: HERREN, eders Fædres Gud, Abrahams, Isaks og Jakobs Gud, har åbenbaret sig for mig og sagt: Jeg har givet Agt på eder og på, hvad man har gjort imod eder i Ægypten, ");
INSERT INTO dan1931_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","og jeg har sat mig for at føre eder ud af Ægyptens Elendighed til Kana'anæernes, Hetitternes, Amoritternes, Perizzitternes, Hivvitternes og Jebusitternes Land, til et Land, der flyder med Mælk og Honning! ");
INSERT INTO dan1931_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","De vil høre på dig, og du skal sammen med Israels Ældste gå til Ægypterkongen, og I skal sige til ham: HERREN, Hebræernes Gud, har mødt os, tillad os derfor at drage tre Dagsrejser ud i Ørkenen og ofre til HERREN vor Gud! ");
INSERT INTO dan1931_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Jeg ved vel, at Ægypterkongen ikke vil tillade eder at drage bort uden med Magt; ");
INSERT INTO dan1931_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","men jeg skal udrække min Hånd og ramme Ægypten med alle mine Undergerninger, som jeg vil gøre der; så skal han give eder Lov til at drage af Sted. ");
INSERT INTO dan1931_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Og jeg vil stemme Ægypterne gunstigt mod dette Folk, så at I, når I drager bort, ikke skal drage bort med tomme Hænder. ");
INSERT INTO dan1931_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Enhver Kvinde skal bede sin Naboerske og de Kvinder, som er til Huse hos hende, om Sølv og Guldsmykker og Klæder, og I skal give eders Sønner og Døtre det på. Således skal I tage Bytte fra Ægypterne.” ");
INSERT INTO dan1931_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses svarede; “Hvis de nu ikke tror mig og ikke hører mig, men siger, at HERREN ikke har åbenbaret sig for mig?” ");
INSERT INTO dan1931_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Da sagde HERREN til ham: “Hvad har du der i din Hånd?” Han svarede: “En Stav!” ");
INSERT INTO dan1931_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Og han sagde: “Kast den til Jorden!” Da kastede han den til Jorden, og den blev til en Slange, og Moses flyede for den. ");
INSERT INTO dan1931_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Og HERREN sagde til Moses: “Ræk Hånden ud og grib den i Halen!” Da rakte han sin Hånd ud, og den blev til en Stav i hans Hånd. ");
INSERT INTO dan1931_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“For at de nemlig kan tro, at HERREN, deres Fædres Gud, Abrahams Gud, Isaks Gud og Jakobs Gud, har åbenbaret sig for dig.” ");
INSERT INTO dan1931_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Og HERREN sagde fremdeles til ham: “Stik din Hånd ind på Brystet!” Da stak han sin Hånd ind på Brystet, og da han trak den ud, se, da var den hvid som Sne af Spedalskhed. ");
INSERT INTO dan1931_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Derpå sagde han: “Stik atter Hånden ind på Brystet!” Så stak han atter Hånden ind på Brystet, og da han trak den ud, se, da var den igen som hans øvrige Legeme. ");
INSERT INTO dan1931_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Hvis de nu ikke tror dig og lader sig overbevise af det første Tegn, så vil de tro det sidste; ");
INSERT INTO dan1931_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","men hvis de end ikke tror på disse to Tegn og hører på dig, tag da Vand fra Nilen og hæld det ud på Jorden, så skal Vandet, som du tager fra Nilen, blive til Blod på Jorden.” ");
INSERT INTO dan1931_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Men Moses sagde til HERREN: “Ak, Herre, jeg er ingen veltalende Mand, jeg var det ikke før og er det heller ikke nu, efter at du har talet til din Tjener, thi jeg har svært ved at udtrykke mig og tale for mig.” ");
INSERT INTO dan1931_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Da svarede HERREN ham: “Hvem har givet Mennesket Mund, og hvem gør stum eller døv, seende eller blind? Mon ikke jeg, HERREN? ");
INSERT INTO dan1931_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Gå derfor kun, jeg vil være med din Mund og lære dig, hvad du skal sige!” ");
INSERT INTO dan1931_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Men han sagde: “Ak, Herre, send dog enhver anden end mig!” ");
INSERT INTO dan1931_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Da blussede HERRENS Vrede op imod Moses, og han sagde: “Har du ikke din Broder Aron, Levitten? Han, ved jeg, kan tale for sig. Han er også allerede på Vej for at møde dig, og han vil glæde sig i sit Hjerte, når han ser dig; ");
INSERT INTO dan1931_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","du skal tale til ham og lægge ham Ordene i Munden, så vil jeg være med din og hans Mund og lære eder, hvad I skal gøre. ");
INSERT INTO dan1931_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Han skal tale på dine Vegne til Folket; han skal være din Mund, og du skal være som Gud for ham. ");
INSERT INTO dan1931_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tag nu i din Hånd denne Stav, som du skal gøre Tegnene med!” ");
INSERT INTO dan1931_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Derefter vendte Moses tilbage til sin Svigerfader Jetro og sagde til ham: “Lad mig vende tilbage til mine Landsmænd i Ægypten og se, om de endnu er i Live!” Og Jetro svarede Moses: “Drag bort i Fred!” ");
INSERT INTO dan1931_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Da sagde HERREN til Moses i Midjan: “Vend tilbage til Ægypten, thi alle de Mænd, der stod dig efter Livet, er døde.” ");
INSERT INTO dan1931_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Så tog Moses sin Hustru og sin Søn og satte dem på sit Æsel og vendte tilbage til Ægypten; og Moses tog Guds Stav i Hånden. ");
INSERT INTO dan1931_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Men HERREN sagde til Moses: “Når du vender tilbage til Ægypten, så mærk dig dette: Alle de Undergerninger, jeg giver dig Magt til at udføre, skal du gøre for Farao; men jeg vil forhærde hans Hjerte, så han ikke lader Folket rejse. ");
INSERT INTO dan1931_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Og da skal du sige til Farao: Så siger HERREN: Israel er min førstefødte Søn; ");
INSERT INTO dan1931_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","men da jeg sagde til dig: Lad min Søn rejse, for at han kan dyrke mig! da nægtede du at lade ham rejse. Se, jeg dræber din førstefødte Søn!” ");
INSERT INTO dan1931_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Men undervejs, i Natteherberget, kom HERREN imod ham og vilde dræbe ham. ");
INSERT INTO dan1931_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Da greb Zippora en skarp Sten og afskar sin Søns Forhud og berørte hans Blusel dermed, idet hun sagde: “Du er mig en Blodbrudgom!” ");
INSERT INTO dan1931_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Så lod han ham i Fred. Ved den Lejlighed brugte hun Ordet “Blodbrudgom” med Hentydning til Omskærelsen. ");
INSERT INTO dan1931_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Derpå sagde HERREN til Aron: “Gå Moses i Møde i Ørkenen!” Og han gik ud og traf ham ved Guds Bjerg og kyssede ham. ");
INSERT INTO dan1931_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Og Moses fortalte Aron om alt, hvad HERREN havde pålagt ham, og om alle de Tegn, han havde befalet ham at gøre. ");
INSERT INTO dan1931_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Derefter gik Moses og Aron den og kaldte alle Israelitternes Ældste sammen; ");
INSERT INTO dan1931_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","og Aron fortalte alt, hvad HERREN havde sagt til Moses, og denne gjorde Tegnene i Folkets Påsyn. ");
INSERT INTO dan1931_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Da troede Folket, og da de hørte, at HERREN havde givet Agt på Israelitterne og set til deres Elendighed, bøjede de sig og tilbad. ");
INSERT INTO dan1931_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Derefter gik Moses og Aron hen og sagde til Farao: “Så siger HERREN, Israels Gud: Lad mit Folk rejse, for at de kan holde Højtid for mig i Ørkenen!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Men Farao sagde: “Hvem er HERREN, at jeg skulde adlyde ham og lade Israelitterne rejse? Jeg kender ikke noget til HERREN, og jeg vil heller ikke lade Israelitterne rejse!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","De svarede: “Hebræernes Gud har mødt os; tillad os nu at drage tre Dagsrejser ud i Ørkenen og ofre til HERREN. vor Gud, for at han ikke skal slå os med Pest eller Sværd!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Men Ægypterkongen sagde til dem: “Hvorfor vil I, Moses og Aron, forstyrre Folket i dets Arbejde? Gå til eders Trællearbejde!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Og Farao sagde: “Folket er så vist dovent nok; og nu vil I have dem fri fra deres Trællearbejde!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Samme Dag udstedte Farao følgende Befaling til Fogederne over Folket og dets Opsynsmænd: ");
INSERT INTO dan1931_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“I skal ikke mere som hidtil give Folket Halm til Teglarbejdet; de skal selv gå ud og sanke Halm; ");
INSERT INTO dan1931_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","men alligevel skal I pålægge dem at lave lige så mange Teglsten som hidtil, I må ikke eftergive dem noget; thi de er dovne, og derfor er det, de råber op og siger: Lad os drage ud og ofre til vor Gud! ");
INSERT INTO dan1931_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Strengt Arbejde skal de Mennesker have, for at de kan være optaget deraf og ikke af Løgnetale.” ");
INSERT INTO dan1931_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Da gik Folkets Fogeder og Opsynsmænd ud og sagde til Folket: “Således siger Farao: Jeg vil ikke mere give eder Halm; ");
INSERT INTO dan1931_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","gå selv ud og sank eder Halm, hvor I kan finde det, men i eders Arbejde bliver der intet eftergivet!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Da spredte Folket sig over hele Ægypten for at samle Halmstrå. ");
INSERT INTO dan1931_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Men Fogederne trængte på og sagde: “I skal Dag for Dag yde fuldt Arbejde, ligesom dengang I fik Halm!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Og Israelitternes Opsynsmænd, som Faraos Fogeder havde sat over dem, fik Prygl, og der blev sagt til dem: “Hvorfor stryger I ikke mere det fastsatte Antal Teglsten ligesom før?” ");
INSERT INTO dan1931_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Da gik Israelitternes Opsynsmænd hen og råbte til Farao: “Hvorfor handler du således med dine Trælle? ");
INSERT INTO dan1931_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Dine Trælle får ingen Halm, og dog siger de til os: Lav Teglsten! Og dine Trælle får Prygl; du forsynder dig mod dit Folk.” ");
INSERT INTO dan1931_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Men han svarede: “I er dovne, det er det, I er! Derfor siger I: Lad os rejse ud og ofre til HERREN! ");
INSERT INTO dan1931_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Gå nu hen og tag fat på eders Arbejde; I får ingen Halm, men I skal levere det samme Antal Teglsten!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israelitternes Opsynsmænd følte sig ilde stedt ved at skulle sige: “Der må intet eftergives i, hvad I daglig skal skaffe af Teglsten!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Og da de ved deres Bortgang fra Farao traf Moses og Aron, som stod og ventede på dem, ");
INSERT INTO dan1931_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","sagde de til dem: “HERREN se til eder og dømme eder, fordi I har vakt Afsky mod os hos Farao og hans Tjenere og lagt dem et Sværd i Hånden til at dræbe os med!” ");
INSERT INTO dan1931_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Da vendte Moses sig igen til HERREN og sagde: “Herre, hvorfor har du handlet ilde med dette Folk? Hvorfor har du udsendt mig? ");
INSERT INTO dan1931_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Siden jeg har været hos Farao og talt i dit Navn, har han handlet ilde med dette Folk, og frelst dit Folk har du ikke!” ");
INSERT INTO dan1931_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Men HERREN svarede Moses: “Nu skal du få at se, hvad jeg vil gøre ved Farao! Med Magt skal han blive tvunget til at lade dem rejse, og med Magt skal han blive tvunget til at drive dem ud af sit Land!” ");
INSERT INTO dan1931_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Gud talede til Moses og sagde til ham: “Jer er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","For Abraham, Isak og Jakob åbenbarede jeg mig som Gud den Almægtige, men under mit Navn HERREN gav jeg mig ikke til Kende for dem. ");
INSERT INTO dan1931_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Eftersom jeg har oprettet min Pagt med dem om at skænke dem Kana'ans Land, deres Udlændigheds Land, hvor de levede som fremmede, ");
INSERT INTO dan1931_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","har jeg nu hørt Israelitternes Klageråb over, at Ægypterne holder dem i Trældom, og jeg er kommet min Pagt i Hu. ");
INSERT INTO dan1931_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Derfor skal du sige til Israelitterne: Jeg er HERREN, og jeg vil udfri eder fra det Trællearbejde, Ægypterne har pålagt eder, og frelse eder fra deres Trældom og udløse eder med udrakt Arm og med vældige Straffedomme; ");
INSERT INTO dan1931_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","og så vil jeg antage eder som mit Folk og være eders Gud, og I skal kende, at jeg er HERREN eders Gud, som udfrier eder fra Ægypternes Trællearbejde; ");
INSERT INTO dan1931_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","og jeg vil føre eder til det Land, jeg har svoret at ville skænke Abraham, Isak og Jakob, og give eder det i Eje. Jeg er HERREN!” ");
INSERT INTO dan1931_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses kundgjorde nu dette for Israelitterne; men de hørte ikke på Moses, dertil var deres Modløshed for stor og deres Trællearbejde for hårdt. ");
INSERT INTO dan1931_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Da talede HERREN til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Gå hen og sig til Farao, Ægyptens Konge, at han skal lade Israelitterne drage ud af, sit Land!” ");
INSERT INTO dan1931_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Men Moses sagde for HERRENS Åsyn: “Israelitterne har ikke hørt på mig, hvor skulde da Farao gøre det, tilmed da jeg er uomskåren på Læberne?” ");
INSERT INTO dan1931_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Da talede HERREN til Moses og Aron og sendte dem til Farao, Ægyptens Konge, for at føre Israelitterne ud af Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Følgende var Overhovederne for deres Fædrenehuse: Rubens, Israels førstefødtes, Sønner var: Hanok, Pallu, Hezron og Harmi; det er Rubens Slægter. ");
INSERT INTO dan1931_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeons. Sønner var Jemuel, Jamin, Ohad, Jakin, Zohar og Kana'anæerkvindens Søn Sjaul; det er Simeons Slægter. ");
INSERT INTO dan1931_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Følgende er Navnene på Levis Sønner efter deres Nedstamning: Gerson, Kehat og Merari. Levis Levetid var 137 År. ");
INSERT INTO dan1931_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gersons Sønner var Libni og Sjimi efter deres Slægter. ");
INSERT INTO dan1931_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehats Sønner var Amram, Jizhar, Hebron og Uzziel. Kehats Levetid var 133 År. ");
INSERT INTO dan1931_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Meraris Sønner var Mali og Musji. Det er Levis Slægter efter deres Nedstamning. ");
INSERT INTO dan1931_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram tog sin Faster Jokebed til Ægte; og hun fødte ham Aron og Moses. Amrams Levetid var 137 År. ");
INSERT INTO dan1931_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Jizhars Sønner var Kora, Nefeg og Zikri. ");
INSERT INTO dan1931_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziels Sønner var Misjael, Elzafan og Sitri. ");
INSERT INTO dan1931_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron tog Amminadabs Datter, Nahasjons Søster Elisjeba til Ægte; og hun fødte ham Nadab, Abihu, Eleazar og Itamar. ");
INSERT INTO dan1931_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Koras Sønner var Assir, Elkana og Abi'asaf; det er Koraitternes Slægter. ");
INSERT INTO dan1931_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Arons Søn Eleazar tog en at Putiels Døtre til Ægte; og hun fødte ham Pinehas. Det er Overhovederne for Levitternes Fædrenehuse efter deres Slægter. ");
INSERT INTO dan1931_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Det var Aron og Moses, som HERREN sagde til: “Før Israelitterne ud af Ægypten, Hærafdeling for Hærafdeling!” ");
INSERT INTO dan1931_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Det var dem, der talte til Farao, Ægyptens Konge, om at føre Israelitterne ud af Ægypten, Moses og Aron. ");
INSERT INTO dan1931_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Dengang HERREN talede til Moses i Ægypten, ");
INSERT INTO dan1931_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","talede HERREN til Moses således: “Jeg er HERREN! Forkynd Farao, Ægyptens Konge, alt, hvad jeg siger dig!” ");
INSERT INTO dan1931_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Men Moses sagde for HERRENS Åsyn: “Se, jeg er uomskåren på Læberne, hvorledes skulde da Farao ville høre på mig?” ");
INSERT INTO dan1931_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Da sagde HERREN til Moses: “Se, jeg gør dig til Gud for Farao, men din Broder Aron skal være din Profet. ");
INSERT INTO dan1931_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Du skal sige til ham alt, hvad jeg pålægger dig, men din Broder Aron skal sige det til Farao, for at han skal lade Israelitterne rejse ud af sit Land. ");
INSERT INTO dan1931_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Men jeg vil forhærde Faraos Hjerte og derefter gøre mange Tegn og Undere i Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Farao skal ikke høre på eder, men jeg vil lægge min Hånd på Ægypten og føre mine Hærskarer, mit Folk Israelitterne, ud af Ægypten med vældige Straffedomme; ");
INSERT INTO dan1931_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","og når jeg udrækker min Hånd mod Ægypten og fører Israelitterne ud derfra, skal Ægypterne kende, at jeg er HERREN.” ");
INSERT INTO dan1931_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Da gjorde Moses og Aron, som HERREN pålagde dem. ");
INSERT INTO dan1931_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses var firsindstyve og Aron tre og firsindstyve År gammel, da de talte til Farao. ");
INSERT INTO dan1931_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Og HERREN talede til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Når Farao kræver et Under af eder, sig så til Aron: Tag din Stav og kast den ned foran Farao, så skal den blive til en Slange!” ");
INSERT INTO dan1931_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Da gik Moses og Aron til Farao og gjorde, som HERREN bød; og da Aron kastede sin Stav foran Farao og hans Tjenere, blev den til en Slange. ");
INSERT INTO dan1931_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Men Farao lod som Modtræk Vismændene og Besværgerne kalde, og de, Ægyptens Koglere, gjorde også det samme ved Hjælp af deres hemmelige Kunster; ");
INSERT INTO dan1931_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","de kastede hver sin Stav, og Stavene blev til Slanger, men Arons Stav opslugte deres Stave. ");
INSERT INTO dan1931_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Men Faraos Hjerte blev forhærdet, og han hørte ikke på dem, således som HERREN havde sagt. ");
INSERT INTO dan1931_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","HERREN sagde nu til Moses: “Faraos Hjerte er forstokket, han vægrer sig ved at lade Folket rejse. ");
INSERT INTO dan1931_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Gå derfor i Morgen tidlig til Farao, når han begiver sig ned til Vandet, og træd frem for ham ved Nilens Bred og tag Staven, der forvandledes til en Slange, i Hånden ");
INSERT INTO dan1931_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","og sig til ham: HERREN, Hebræernes Gud, sendte mig til dig med det Bud: Lad mit Folk rejse, at det kan dyrke mig i Ørkenen! Men hidtil har du ikke adlydt. ");
INSERT INTO dan1931_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Så siger HERREN: Deraf skal du kende, at jeg er HERREN: Se, jeg slår Vandet i Nilen med Staven, som jeg holder i min Hånd, og det skal forvandles til Blod, ");
INSERT INTO dan1931_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Fiskene i Nilen skal dø, og Nilen skal stinke, og Ægypterne skal væmmes ved at drikke Vand fra Nilen.” ");
INSERT INTO dan1931_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Og HERREN sagde til Moses: “Sig til Aron: Tag din Stav og ræk din Hånd ud over Ægypternes Vande, deres Floder, Kanaler, Damme og alle Vandsamlinger, så skal Vandet blive til Blod, og der skal være Blod i hele Ægypten, både i Trækar og Stenkar.” ");
INSERT INTO dan1931_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Og Moses og Aron gjorde, som HERREN bød; Moses løftede Staven og slog Vandet i Nilen for Øjnene af Farao og hans Tjenere, og alt Vandet i Nilen forvandledes til Blod; ");
INSERT INTO dan1931_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Fiskene i Nilen døde, og Nilen stank, så Ægypterne ikke kunde drikke Vand fra Nilen, og der var Blod i hele Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Men de Ægyptiske Koglere gjorde det samme ved Hjælp af deres hemmelige Kunster, og Faraos Hjerte blev forhærdet, så han ikke hørte på dem, således som HERREN havde sagt. ");
INSERT INTO dan1931_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Da vendte Farao sig bort og gik hjem, og heller ikke dette lagde han sig på Sinde. ");
INSERT INTO dan1931_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Men alle Ægypterne gravede i Omegnen af Nilen efter Drikkevand, thi de kunde ikke drikke Nilvandet. ");
INSERT INTO dan1931_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Og således gik der syv Dage, efter at HERREN havde slået Nilen. ");
INSERT INTO dan1931_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Derpå sagde HERREN til Moses: “Gå til Farao og sig til ham: Så siger HERREN: Lad mit Folk rejse, for at de kan dyrke mig! ");
INSERT INTO dan1931_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Men hvis du vægrer dig ved at lade dem rejse, se, da vil jeg plage hele dit Land med Frøer; ");
INSERT INTO dan1931_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nilen skal vrimle af Frøer, og de skal kravle op og trænge ind i dit Hus og dit Sovekammer og på dit Leje og i dine Tjeneres og dit Folks Huse, i dine Bagerovne og dine Dejgtruge; ");
INSERT INTO dan1931_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ja på dig selv og dit Folk og alle dine Tjenere skal Frøerne kravle op.” ");
INSERT INTO dan1931_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Da sagde HERREN til Moses: “Sig til Aron: Ræk din Hånd med Staven ud over Floderne, Kanalerne og Dammene og få Frøerne til at kravle op over Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Og Aron rakte sin Hånd ud over Ægyptens Vande. Da kravlede Frøerne op og fyldte Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Men Koglerne gjorde det samme ved Hjælp af deres hemmelige Kunster og fik Frøerne til at kravle op over Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Da lod Farao Moses og Aron kalde og sagde: “Gå i Forbøn hos HERREN, at han skiller mig og mit Folk af med Frøerne, så vil jeg lade Folket rejse, at de kan ofre til HERREN.” ");
INSERT INTO dan1931_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses svarede Farao: “Du behøver kun at befale over mig! Til hvilken Tid skal jeg gå i Forbøn for dig, dine Tjenere og dit Folk om at få Frøerne bort fra dig og dine Huse, så de kun bliver tilbage i Nilen?” ");
INSERT INTO dan1931_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Han svarede: “I Morgen!” Da sagde han: “Det skal ske, som du siger, for at du kan kende, at der ingen er som HERREN vor Gud; ");
INSERT INTO dan1931_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Frøerne skal vige bort fra dig, dine Huse, dine Tjenere og dit Folk; kun i Nilen skal de blive tilbage.” ");
INSERT INTO dan1931_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moses og Aron gik nu bort fra Farao, og Moses råbte til HERREN om at bortrydde Frøerne, som han havde sendt over Farao; ");
INSERT INTO dan1931_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","og HERREN gjorde, som Moses bad: Frøerne døde i Husene, i Gårdene og på Markerne, ");
INSERT INTO dan1931_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","og man samlede dem sammen i Dynger, så Landet kom til at stinke deraf. ");
INSERT INTO dan1931_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Men da Farao så, at han havde fået Luft, forhærdede han sit Hjerte og hørte ikke på dem, således som HERREN havde sagt. ");
INSERT INTO dan1931_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Derpå sagde HERREN til Moses: “Sig til Aron: Ræk din Stav ud og slå Støvet på Jorden med den, så skal det blive til Myg i hele Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Og de gjorde således; Aron udrakte sin Hånd med Staven og slog Støvet på Jorden dermed. Da kom der Myg over Mennesker og Dyr; alt Støvet på Jorden blev til Myg i hele Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Koglerne søgte nu også ved Hjælp af deres hemmelige Kunster at fremkalde Myg, men de magtede det ikke. Og Myggene kom over Mennesker og Dyr. ");
INSERT INTO dan1931_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Da sagde Koglerne til Farao: “Det er Guds Finger!” Men Faraos Hjerte blev forhærdet, så han ikke hørte på dem, således som HERREN havde sagt. ");
INSERT INTO dan1931_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Derpå sagde HERREN til Moses: “Træd i Morgen tidlig frem for Farao, når han begiver sig ned til Vandet, og sig til ham: Så siger HERREN: Lad mit Folk rejse, for at de kan dyrke mig! ");
INSERT INTO dan1931_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Men hvis du ikke lader mit Folk rejse, se, da sender jeg Bremser over dig, dine Tjenere, dit Folk og dine Huse, og Ægypternes Huse skal blive fulde af Bremser, ja endog Jorden, de bor på; ");
INSERT INTO dan1931_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","men med Gosens Land, hvor mit Folk bor, vil jeg til den Tid gøre en Undtagelse, så der ingen Bremser kommer, for at du kan kende, at jeg HERREN er i Landet; ");
INSERT INTO dan1931_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","og jeg vil sætte Skel mellem mit Folk og dit Folk; i Morgen skal dette Tegn ske!” ");
INSERT INTO dan1931_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Og HERREN gjorde således: Vældige Bremsesværme trængte ind i Faraos og hans Tjeneres Huse og i hele Ægypten, og Landet hærgedes af Bremserne. ");
INSERT INTO dan1931_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Da lod Farao Moses og Aron kalde og sagde: “Gå hen og bring eders Gud et Offer her i Landet!” ");
INSERT INTO dan1931_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Men Moses sagde: “Det går ikke an at gøre således, thi til HERREN vor Gud ofrer vi, hvad der er Ægypterne en Vederstyggelighed; og når vi for Øjnene af Ægypterne ofrer, hvad der er dem en Vederstyggelighed, mon de da ikke stener os? ");
INSERT INTO dan1931_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Lad os drage tre Dagsrejser ud i Ørkenen og ofre til HERREN vor Gud, således som han har pålagt os!” ");
INSERT INTO dan1931_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao sagde: “Jeg vil lade eder rejse hen og ofre til HERREN eders Gud i Ørkenen; kun må I ikke rejse for langt bort; men gå i Forbøn for mig!” ");
INSERT INTO dan1931_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses svarede: “Se, så snart jeg kommer ud herfra, skal jeg gå i Forbøn hos HERREN, og Bremserne skal vige bort fra Farao, hans Tjenere og hans Folk i Morgen. Blot Farao så ikke igen narrer os og nægter at lade Folket rejse hen og ofre til HERREN!” ");
INSERT INTO dan1931_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Derpå gik Moses bort fra Farao og gik i Forbøn hos HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Og HERREN gjorde, som Moses bad, og Bremserne veg bort fra Farao, hans Tjenere og hans Folk; der blev ikke en eneste tilbage. ");
INSERT INTO dan1931_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Men Farao forhærdede også denne Gang sit Hjerte og lod ikke Folket rejse. ");
INSERT INTO dan1931_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Derpå sagde HERREN til Moses: “Gå til Farao og sig til ham: Så siger HERREN, Hebræernes Gud: Lad mit Folk rejse, for at de kan dyrke mig! ");
INSERT INTO dan1931_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Men hvis du vægrer dig ved at lade dem rejse og bliver ved med at holde dem fast, ");
INSERT INTO dan1931_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","se, da skal HERRENS Hånd komme over dit Kvæg på Marken, over Hestene, Æslerne og Kamelerne, Hornkvæget og Småkvæget med en såre forfærdelig Pest. ");
INSERT INTO dan1931_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Og HERREN skal sætte Skel mellem Israels Kvæget og Ægypterens Kvæg, så der ikke skal dø noget af, hvad der tilhører Israelitterne.” ");
INSERT INTO dan1931_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Og HERREN satte en Tidsfrist, idet han sagde: “I Morgen skal HERREN lade dette ske i Landet.” ");
INSERT INTO dan1931_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Den følgende Dag lod HERREN det så ske, og alt Ægypternes Kvæg døde, men af Israelitternes Kvæg døde ikke et eneste Dyr. ");
INSERT INTO dan1931_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao sendte da Bud, og se, ikke et eneste Dyr af Israelitternes Kvæg var dødt. Men Faraos Hjerte blev forhærdet, og han lod ikke Folket rejse. ");
INSERT INTO dan1931_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Derpå sagde HERREN til Moses og Aron: “Tag begge eders Hænder fulde af Sod fra Smelteovnen, og Moses skal kaste det i Vejret i Faraos Påsyn! ");
INSERT INTO dan1931_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Så skal det blive til en Støvsky over hele Ægypten og til Betændelse, der bryder ud i Bylder på Mennesker og Kvæg i hele Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Da tog de Sod fra Smelteovnen og trådte frem for Farao, og Moses kastede det i Vejret; og det blev til Betændelse, der brød ud i Bylder på Mennesker og Kvæg. ");
INSERT INTO dan1931_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Og Koglerne kunde ikke holde Stand over for Moses på Grund af Betændelsen, thi Betændelsen angreb Koglerne såvel som alle de andre Ægyptere. ");
INSERT INTO dan1931_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Men HERREN forhærdede Faraos Hjerte, så han ikke hørte på dem, således som HERREN havde sagt til Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Derpå sagde HERREN til Moses: “Træd i Morgen tidlig frem for Farao og sig til ham: Så siger HERREN, Hebræernes Gud: Lad mit Folk rejse, for at de kan dyrke mig! ");
INSERT INTO dan1931_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Thi denne Gang vil jeg sende alle mine Plager mod dig selv og mod dine Tjenere og dit Folk, for at du kan kende, at der er ingen som jeg på hele Jorden. ");
INSERT INTO dan1931_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Thi ellers havde jeg nu udrakt min Hånd for at ramme dig og dit Folk med Pest, så du blev udryddet fra Jordens Overflade; ");
INSERT INTO dan1931_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","dog derfor har jeg ladet dig blive i Live for at vise dig min Magt, og for at mit Navn kan blive forkyndt på hele Jorden. ");
INSERT INTO dan1931_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Endnu stiller du dig i Vejen for mit Folk og vil ikke lade det rejse. ");
INSERT INTO dan1931_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Se, jeg lader i Morgen ved denne Tid et frygteligt Haglvejr bryde løs, hvis Lige ikke har været i Ægypten, fra den Dag det blev til og indtil nu. ");
INSERT INTO dan1931_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Derfor må du sørge for at bringe dit Kvæg og alt, hvad du har på Marken, i Sikkerhed! Thi alle Mennesker og Dyr, der befinder sig på Marken og ikke er kommet under Tag, skal rammes af Haglen og omkomme.” ");
INSERT INTO dan1931_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","De blandt Faraos Tjenere, der frygtede HERRENS Ord, bragte nu deres Trælle og Kvæg under Tag; ");
INSERT INTO dan1931_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","men de, der ikke lagde sig HERRENS Ord på Hjerte, lod deres Trælle og Kvæg blive ude på Marken. ");
INSERT INTO dan1931_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Da sagde HERREN til Moses: “Ræk din Hånd op mod Himmelen, så skal der falde Hagl i hele Ægypten på Mennesker og Dyr og på alle Markens Urter i Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Da rakte Moses sin Stav op mod Himmelen, og HERREN sendte Torden og Hagl; Ild for ned mod Jorden, og HERREN lod Hagl falde over Ægypten; ");
INSERT INTO dan1931_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","og der kom et Haglvejr, med Ildsluer flammende mellem Haglen, så voldsomt, at dets Lige aldrig havde været nogetsteds i Ægypten, siden det blev befolket; ");
INSERT INTO dan1931_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","og i hele Ægypten slog Haglen alt ned, hvad der var på Marken, både Mennesker og Kvæg, og alle Markens Urter slog Haglen ned, og alle Markens Træer knækkede den; ");
INSERT INTO dan1931_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","kun i Gosen, hvor Israelitterne boede, faldt der ikke Hagl. ");
INSERT INTO dan1931_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Da sendte Farao Bud efter Moses og Aron og sagde til dem: “Denne Gang har jeg syndet; HERREN har Ret, og jeg og mit Folk har Uret; ");
INSERT INTO dan1931_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","gå i Forbøn hos HERREN, at det nu må være nok med Guds Torden og Haglvejret, så vil jeg lade eder rejse, og I skal ikke blive længer!” ");
INSERT INTO dan1931_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses svarede ham: “Så snart jeg kommer ud af Byen, skal jeg udbrede mine Hænder mod HERREN; så skal Tordenen høre op, og Haglen skal ikke falde mere, for at du kan kende, at Jorden tilhører HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Dog, jeg ved, at du og dine Tjenere endnu ikke frygter for Gud HERREN.” ");
INSERT INTO dan1931_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Hørren og Byggen blev slået ned, thi Byggen stod i Aks, og Hørren i Blomst; ");
INSERT INTO dan1931_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","derimod blev Hveden og Spelten ikke slået ned, thi de modnes senere. ");
INSERT INTO dan1931_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Da Moses var gået bort fra Farao og var kommet ud af Byen, udbredte han sine Hænder mod HERREN, og da hørte Tordenen og Haglen op, og Regnen strømmede ikke mere ned. ");
INSERT INTO dan1931_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Men da Farao så, at Regnen, Haglen og Tordenen var hørt op, fremturede han i sin Synd, og han og hans Tjenere forhærdede deres Hjerte. ");
INSERT INTO dan1931_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Faraos Hjerte blev forhærdet, så at han ikke lod Israelitterne rejse, således som HERREN havde sagt ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Derpå sagde HERREN til Moses: “Gå til Farao! Thi jeg har forhærdet hans og hans Tjeneres Hjerte, at jeg kan komme til at gøre disse mine Tegn iblandt dem, ");
INSERT INTO dan1931_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","for at du må kunne fortælle din Søn og din Sønnesøn, hvorledes jeg handlede med Ægypterne, og om de Tegn, jeg gjorde iblandt dem; så skal I kende, at jeg er HERREN.” ");
INSERT INTO dan1931_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Da gik Moses og Aron til Farao og sagde til ham: “Så siger HERREN, Hebræernes Gud: Hvor længe vil du vægre dig ved at ydmyge dig for mig? Lad mit Folk rejse, at de kan dyrke mig! ");
INSERT INTO dan1931_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Men hvis du vægrer dig ved at lade mit Folk rejse, se, da vil jeg i Morgen sende Græshopper over dine Landemærker, ");
INSERT INTO dan1931_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","og de skal skjule Landets Overflade, så man ikke kan se Jorden, og opæde Resten af det, som er blevet tilovers for eder efter Haglen, og opæde alle eders Træer, som gror på Marken; ");
INSERT INTO dan1931_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","og de skal fylde dine Huse og alle dine Tjeneres og alle Ægypternes Huse således, at hverken dine Fædre eller dine Fædres Fædre nogen Sinde har oplevet Mage dertil, fra den Dag de kom til Verden og indtil denne Dag!” Dermed vendte han sig bort og forlod Farao. ");
INSERT INTO dan1931_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Men Faraos Tjenere sagde til ham: “Hvor længe skal denne Mand styrte os i Ulykke? Lad dog disse Mennesker rejse og lad dem dyrke HERREN deres Gud! Har du endnu ikke indset, at Ægypten går til Grunde?” ");
INSERT INTO dan1931_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moses og Aron blev nu hentet tilbage til Farao, og han sagde til dem: “Drag af Sted og dyrk HERREN eders Gud! Men hvem er det nu, der vil af Sted?” ");
INSERT INTO dan1931_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses svarede: “Med vore Børn og vore gamle vil vi drage af Sted, med vore Sønner og vore Døtre, vort Småkvæg og vort Hornkvæg vil vi drage af Sted, thi vi skal fejre HERRENS Højtid.” ");
INSERT INTO dan1931_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Da sagde han til dem: “HERREN være med eder, om jeg lader eder rejse sammen med eders Kvinder og Børn! Der ser man, at I har ondt i Sinde! ");
INSERT INTO dan1931_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nej - men I Mænd kan drage bort og dyrke HERREN; det var jo det, I ønskede!” Derpå jog man dem bort fra Farao. ");
INSERT INTO dan1931_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Da sagde HERREN til Moses: “Ræk din Hånd ud over Ægypten og få Græshopperne til at komme; de skal komme over Ægypten og opæde alt, hvad der vokser i Landet, alt, hvad Haglen har levnet!” ");
INSERT INTO dan1931_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moses rakte da sin Stav ud over Ægypten, og HERREN lod en Østenstorm blæse over Landet hele den Dag og den påfølgende Nat; og da det blev Morgen, førte Østenstormen Græshopperne med sig. ");
INSERT INTO dan1931_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Da kom Græshopperne over hele Ægypten, og de slog sig ned i hele Ægyptens Område i uhyre Mængder; aldrig før havde der været så mange Græshopper, og ingen Sinde mere skal der komme så mange. ");
INSERT INTO dan1931_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Og de skjulte hele Jordens Overflade, så Jorden blev sort af dem, og de opåd alt, hvad der voksede i Landet, og alle Træfrugter, alt, hvad Haglen havde levnet, og der blev intet grønt tilbage på Træerne eller på Markens Urter i hele Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Da lod Farao skyndsomt Moses og Aron kalde til sig og sagde: “Jeg har syndet mod HERREN eders Gud og mod eder! ");
INSERT INTO dan1931_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Men tilgiv mig nu min Synd denne ene Gang og gå i Forbøn hos eders Gud, at han dog blot vil tage denne dødbringende Plage fra mig!” ");
INSERT INTO dan1931_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Da gik Moses bort fra Farao og bad til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Og HERREN lod Vinden slå om til en voldsom Vestenvind, som tog Græshopperne og drev dem ud i det røde Hav, så der ikke blev en eneste Græshoppe tilbage i hele Ægyptens Område. ");
INSERT INTO dan1931_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Men HERREN forhærdede Faraos Hjerte, så han ikke lod Israelitterne rejse. ");
INSERT INTO dan1931_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Derpå sagde HERREN til Moses: “Ræk din Hånd op mod Himmelen, så skal der komme et Mørke over Ægypten, som man kan tage og føle på!” ");
INSERT INTO dan1931_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Da rakte Moses sin Hånd op mod Himmelen, og der kom et tykt Mørke i hele Ægypten i tre Dage; ");
INSERT INTO dan1931_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","den ene kunde ikke se den anden, og ingen flyttede sig af Stedet i tre Dage; men overalt, hvor Israelitterne boede, var det lyst. ");
INSERT INTO dan1931_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Da lod Farao Moses kalde og sagde: “Drag hen og dyrk HERREN. Dog skal eders Småkvæg og Hornkvæg blive tilbage, men eders Kvinder og Børn må I tage med.” ");
INSERT INTO dan1931_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Men Moses sagde: “Du må også overlade os Slagtofre og Brændofre, som vi kan bringe HERREN vor Gud; ");
INSERT INTO dan1931_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","også vore Hjorde må vi have med, ikke en Klov må blive tilbage, thi dem har vi Brug for, når vi skal dyrke HERREN vor Gud, og vi ved jo ikke, hvor meget vi behøver dertil, før vi kommer til Stedet.” ");
INSERT INTO dan1931_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Da forhærdede HERREN Faraos Hjerte, så han nægtede at lade dem rejse. ");
INSERT INTO dan1931_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Og Farao sagde til ham: “Gå bort fra mig og vogt dig for at komme mig for Øje mere; thi den Dag du kommer mig for Øje, er du dødsens!” ");
INSERT INTO dan1931_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Da sagde Moses: “Du har sagt det, jeg skal ikke mere komme dig for Øje!” ");
INSERT INTO dan1931_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Derpå sagde HERREN til Moses: “Én Plage endnu vil jeg lade komme over Farao og Ægypterne, og efter den skal han lade eder rejse herfra; ja, når han lader eder rejse med alt, hvad I har, skal han endog drive eder herfra! ");
INSERT INTO dan1931_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sig nu til Folket, at hver Mand skal bede sin Nabo, og hver Kvinde sin Naboerske om Sølv og Guld smykker!” ");
INSERT INTO dan1931_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Og HERREN stemte Ægypterne gunstigt imod Folket, og desuden var den Mand Moses højt anset i Ægypten både hos Faraos Tjenere og hos Folket. ");
INSERT INTO dan1931_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moses sagde*: “Så siger HERREN: Ved Midnatstid vil jeg drage igennem Ægypten, { *til Farao. } ");
INSERT INTO dan1931_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","og så skal alle førstefødte i Ægypten dø, lige fra den førstefødte hos Farao, der skal arve hans Trone, til den førstefødte hos Trælkvinden, der arbejder ved Håndkværnen, og alt det førstefødte af Kvæget. ");
INSERT INTO dan1931_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Da skal der i hele Ægypten lyde et Klageskrig så stort, at dets Lige aldrig har været hørt og aldrig mere skal høres. ");
INSERT INTO dan1931_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Men end ikke en Hund skal bjæffe ad nogen af Israelitterne, hverken ad Folk eller Fæ for at du kan kende, at HERREN gør Skel mellem Ægypterne og Israel. ");
INSERT INTO dan1931_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Da skal alle dine Tjenere der komme ned til mig og kaste sig til Jorden for mig og sige: Drag dog bort med alt det Folk, der følger dig! Og så vil jeg drage bort!” Og han gik ud fra Farao med fnysende Vrede. ");
INSERT INTO dan1931_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Men HERREN sagde til Moses: “Farao skal ikke høre på eder, for at mine Undergerninger kan blive talrige i Ægypten.” ");
INSERT INTO dan1931_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Og Moses og Aron gjorde alle disse Undergerninger i Faraos Påsyn, men HERREN forhærdede Faraos Hjerte, så han ikke lod Israelitterne drage ud af sit Land. ");
INSERT INTO dan1931_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Derpå talede HERREN til Moses og Aron i Ægypten og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Denne Måned skal hos eder være Begyndelsesmåneden, den skal hos eder være den første af Årets Måneder. ");
INSERT INTO dan1931_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tal til hele Israels Menighed og sig: På den tiende Dag i denne Måned skal hver Familiefader tage et Lam, et Lam for hver Familie. ");
INSERT INTO dan1931_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Og dersom en Familie er for lille til et Lam, skal han sammen med sin nærmeste Nabo tage et Lam, svarende til Personernes Antal; hvor mange der skal være om et Lam, skal I beregne efter. hvad hver enkelt kan spise. ");
INSERT INTO dan1931_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Det skal være et lydefrit, årgammelt Handyr, og I kan tage det enten blandt Fårene eller Gederne. ");
INSERT INTO dan1931_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","I skal have det gående til den fjortende Dag i denne Måned, og hele Israels Menigheds Forsamling skal slagte det ved Aftenstid. ");
INSERT INTO dan1931_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Og de skal tage noget af Blodet og stryge det på de to Dørstolper og Overliggeren i de Huse, hvor I spiser det. ");
INSERT INTO dan1931_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","I skal spise Kødet samme Nat, stegt over Ilden, og I skal spise usyret Brød og bitre Urter dertil. ");
INSERT INTO dan1931_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","I må ikke spise noget deraf råt eller kogt i Vand, men kun stegt over Ilden, og Hoved, Ben og Indmad må ikke være skilt fra. ");
INSERT INTO dan1931_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","I må intet levne deraf til næste Morgen, men hvad der bliver tilovers deraf til næste Morgen, skal I brænde. ");
INSERT INTO dan1931_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Og når I spiser det, skal I have Bælte om Lænden, Sko på Fødderne og Stav i Hånden, og I skal spise det i største Hast. Det er Påske for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","I denne Nat vil jeg drage igennem Ægypten og ihjelslå alt det førstefødte i Ægypten både blandt Folk og Fæ; og over alle Ægyptens Guder vil jeg holde Dom. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Men for eder skal Blodet på Husene, hvor I er, tjene som Tegn, og jeg vil se Blodet og gå eder forbi*; intet ødelæggende Slag skal ramme eder, når jeg slår Ægypten. { *Påske og “Forbigang” samme Ord på hebr. } ");
INSERT INTO dan1931_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Denne Dag skal være eder en Mindedag, og I skal fejre den som en Højtid for HERREN, Slægt efter Slægt; som en evig gyldig Ordning skal I fejre den. ");
INSERT INTO dan1931_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","I syv Dage skal I spise usyret Brød. Straks den første Dag skal I skaffe al Surdej bort af eders Huse; thi hver den, som spiser noget syret fra den første til den syvende Dag, det Menneske skal udryddes af Israel. ");
INSERT INTO dan1931_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","På den første dag skal I holde Højtidsstævne og ligeledes på den syvende Dag. Intet Arbejde må udføres på dem; kun det, enhver behøver til Føde, det og intet andet må I tilberede. ");
INSERT INTO dan1931_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","I skal holde det usyrede Brøds Højtid, thi på denne selv samme Dag førte jeg eders Hærskarer ud af Ægypten, derfor skal I højtideligholde denne Dag i alle kommende Slægtled som en evig gyldig Ordning. ");
INSERT INTO dan1931_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","På den fjortende Dag i den første Måned om Aftenen skal I spise usyret Brød og vedblive dermed indtil Månedens en og tyvende Dag om Aftenen. ");
INSERT INTO dan1931_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","I syv Dage må der ikke findes Surdej i eders Huse, thi hver den, som spiser noget syret, det Menneske skal udryddes af Israels Menighed, de fremmede så vel som de indfødte i Landet. ");
INSERT INTO dan1931_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","I må ikke nyde noget som helst syret; hvor I end bor, skal I spise usyret Brød.” ");
INSERT INTO dan1931_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Da kaldte Moses alle Israels Ældste sammen og sagde til dem: “Gå ud og hent eder Småkvæg til eders Familier og slagt Påskeofferet; ");
INSERT INTO dan1931_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","og tag eder Ysopkoste, dyp dem i Blodet i Fadet og stryg noget deraf på Overliggeren og de to Dørstolper; og ingen af eder må gå ud af sin Husdør før i Morgen. ");
INSERT INTO dan1931_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Thi HERREN vil gå omkring og slå Ægypterne, og når han da ser Blodet på Overliggeren og de to Dørstolper, vil han gå Døren forbi og ikke give Ødelæggeren Adgang til eders Huse for at slå eder. ");
INSERT INTO dan1931_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Dette skal I varetage som en Anordning, der gælder for dig og dine Børn til evig Tid. ");
INSERT INTO dan1931_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Og når I kommer til det Land, HERREN vil give eder, således som han har forjættet, så skal I overholde denne Skik. ");
INSERT INTO dan1931_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Når da eders Børn spørger eder: Hvad betyder den Skik, I der har? ");
INSERT INTO dan1931_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","så skal I svare: Det er Påskeoffer for HERREN, fordi han gik Israelitternes Huse forbi i Ægypten, dengang han slog Ægypterne, men lod vore Huse urørte!” Da bøjede Folket sig og tilbad. ");
INSERT INTO dan1931_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Og Israelitterne gik hen og gjorde, som HERREN havde pålagt Moses og Aron. ");
INSERT INTO dan1931_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Men ved Midnatstid ihjelslog HERREN alle de førstefødte i Ægypten lige fra Faraos førstefødte, der skulde arve hans Trone, til den førstefødte hos Fangen, der sad i Fangehullet, og alt det førstefødte af Kvæget. ");
INSERT INTO dan1931_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Da stod Farao op om Natten tillige med alle sine Tjenere og alle Ægypterne, og der lød et højt Klageskrig i Ægypten, thi der var intet Hus, hvor der ikke fandtes en død. ");
INSERT INTO dan1931_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Og han lod Moses og Aron kalde om Natten og sagde: “Bryd op og drag bort fra mit Folk, I selv og alle Israelitterne, og drag ud og dyrk HERREN, som I har forlangt. ");
INSERT INTO dan1931_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tag også eders Småkvæg og Hornkvæg med, som I har forlangt, og drag bort; og bed også om Velsignelse for mig!” ");
INSERT INTO dan1931_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Og Ægypterne trængte på Folket for at påskynde deres Afrejse fra Landet, thi de sagde: “Vi mister alle Livet!” ");
INSERT INTO dan1931_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Og Folket tog deres Dej med sig, før den var syret, og de bar Dejtrugene på Skulderen, indsvøbte i deres Kapper. ");
INSERT INTO dan1931_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Men Israelitterne havde gjort, som Moses havde sagt, og bedt Ægypterne om Sølv og Guldsmykker og om Klæder; ");
INSERT INTO dan1931_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","og HERREN havde stemt Ægypterne gunstigt mod Folket, så de havde givet dem, hvad de bad om. Således tog de Bytte fra Ægypterne. ");
INSERT INTO dan1931_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Så brød Israelitterne op fra Ra'meses til Sukkot, henved 600.000 Mand til Fods foruden Kvinder og Børn. ");
INSERT INTO dan1931_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Desuden fulgte en stor Hob sammenløbet Folk med og dertil Småkvæg og Hornkvæg, en vældig Mængde Kvæg. ");
INSERT INTO dan1931_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Og af den Dej, de havde bragt med fra Ægypten, bagte de usyret Brød; den var nemlig ikke syret, de var jo drevet ud af Ægypten uden at få Tid til noget; de havde ikke engang tilberedt sig Tæring til Rejsen. ");
INSERT INTO dan1931_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Den Tid, Israelitterne havde boet i Ægypten, udgjorde 430 År. ");
INSERT INTO dan1931_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Netop på den Dag da de 430 År var til Ende, drog alle HERRENS Hærskarer ud af Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","En Vågenat var det for HERREN, i hvilken han vilde føre dem ud af Ægypten. Den Nat er viet HERREN, en Vågenat for alle Israelitterne, Slægt efter Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","HERREN sagde til Moses og Aron: “Dette er Ordningen angående Påskelammet: Ingen fremmed må spise deraf. ");
INSERT INTO dan1931_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Men enhver Træl, der er købt for Penge, må spise deraf, såfremt du har fået ham omskåret. ");
INSERT INTO dan1931_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ingen indvandret eller Daglejer* må spise deraf. { *af fremmed Herkomst. } ");
INSERT INTO dan1931_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Det skal spises i et og samme Hus, og intet af Kødet må bringes ud af Huset; I må ikke sønderbryde dets Ben. ");
INSERT INTO dan1931_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Hele Israels Menighed skal fejre Påsken. ");
INSERT INTO dan1931_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Dersom en fremmed bor som Gæst hos dig og vil fejre Påske for HERREN, da skal alle af Mandkøn hos ham omskæres; så må han være med til at fejre den, og han skal være ligestillet med den indfødte i Landet; men ingen uomskåren må spise deraf. ");
INSERT INTO dan1931_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","En og samme Lov skal gælde for den indfødte i Landet og for den fremmede, der bor som Gæst hos eder.” ");
INSERT INTO dan1931_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Og Israelitterne gjorde, som HERREN havde pålagt Moses og Aron. ");
INSERT INTO dan1931_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","På denne selv samme Dag førte HERREN Israelitterne ud af Ægypten, Hærskare for Hærskare. ");
INSERT INTO dan1931_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Du skal hellige mig alt det førstefødte, alt, hvad der åbner Moders Liv hos Israelitterne både af Mennesker og Kvæg; det skal tilhøre mig!” ");
INSERT INTO dan1931_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Og Moses sagde til Folket: “Kom denne Dag i Hu, på hvilken I vandrer ud af Ægypten, af Trællehuset, thi med stærk Hånd førte HERREN eder ud derfra! Og der må ikke spises syret Brød. ");
INSERT INTO dan1931_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","I Dag vandrer I ud, i Abib Måned. ");
INSERT INTO dan1931_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Når nu HERREN fører dig til Kana'anæernes, Hetitternes, Amoritternes, Hivvitternes og Jebusitternes Land, som han tilsvor dine Fædre at ville give dig, et Land, der flyder med Mælk og Honning, så skal du overholde denne Skik i denne Måned. ");
INSERT INTO dan1931_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","I syv Dage skal du spise usyret Brød, og på den syvende Dag skal der være Højtid for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","I disse syv Dage skal der spises usyret Brød, og der må hverken findes syret Brød eller Surdej hos dig nogetsteds inden dine Landemærker. ");
INSERT INTO dan1931_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Og du skal på den Dag fortælle din Søn, at dette sker i Anledning af, hvad HERREN gjorde for dig, da du vandrede ud af Ægypten! ");
INSERT INTO dan1931_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Det skal være dig som et Tegn på din Hånd og et Erindringsmærke på din Pande, for at HERRENS Lov må være i din Mund, thi med stærk Hånd førte HERREN dig ud af Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Og du skal holde dig denne Anordning efterrettelig til den fastsatte Tid, År efter År. ");
INSERT INTO dan1931_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Og når HERREN fører dig til Kana'anæernes Land, således som han tilsvor dig og dine Fædre, og giver dig det, ");
INSERT INTO dan1931_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","da skal du overlade HERREN alt, hvad der åbner Moders Liv; alt det førstefødte, som falder efter dit Kvæg, for så vidt det er et Handyr, skal tilhøre HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Men alt det førstefødte af Æslerne skal du udløse med et Stykke Småkvæg, og hvis du ikke udløser det, skal du sønderbryde dets Hals; og alt det førstefødte af Mennesker blandt dine Sønner skal du udløse. ");
INSERT INTO dan1931_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Og når din Søn i Fremtiden spørger dig: Hvad betyder dette? skal du svare ham: Med stærk Hånd førte HERREN os ud af Ægypten, af Trællehuset; ");
INSERT INTO dan1931_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","og fordi Farao gjorde sig hård og ikke vilde lade os drage bort, ihjelslog HERREN alt det førstefødte i Ægypten både af Folk og Fæ; derfor ofrer vi HERREN alt, hvad der åbner Moders Liv, for så vidt det er et Handyr, og alt det førstefødte blandt vore Sønner udløser vi! ");
INSERT INTO dan1931_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Og det skal være dig som et Tegn på din Hånd og et Erindringsmærke på din Pande, thi med stærk Hånd førte HERREN os ud af Ægypten.” ");
INSERT INTO dan1931_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Da Farao lod Folket drage bort, førte Gud dem ikke ad Vejen til Filisterlandet, som havde været den nærmeste, thi Gud sagde: “Folket kunde komme til at fortryde det, når de ser, der bliver Krig, og vende tilbage til Ægypten.” ");
INSERT INTO dan1931_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Men Gud lod Folket gøre en Omvej til Ørkenen i Retning af det røde Hav. Israelitterne drog nu væbnede ud af Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Og Moses tog Josefs Ben med sig, thi denne havde taget Israels Sønner i Ed og sagt: “Når Gud ser til eder, skal I føre mine Ben med eder herfra!” ");
INSERT INTO dan1931_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","De brød op fra Sukkot og lejrede sig i Etam ved Randen af Ørkenen. ");
INSERT INTO dan1931_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Men HERREN vandrede foran dem, om dagen i en Skystøtte for at vise dem Vej og om Natten i en Ildstøtte for at lyse for dem; så kunde de rejse både Dag og Nat. ");
INSERT INTO dan1931_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Og Skystøtten veg ikke fra Folket om Dagen, ej heller Ildstøtten om Natten. ");
INSERT INTO dan1931_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Sig til Israelitterne, at de skal vende om og lejre sig ved Pi Hakirot mellem Migdol og Havet; lige over for Ba'al-Zefon skal I lejre eder ved Havet. ");
INSERT INTO dan1931_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao vil da tænke om Israelitterne, at de er faret vild i Landet, og at Ørkenen har sluttet dem inde; ");
INSERT INTO dan1931_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","og jeg vil forhærde Faraos Hjerte, så han sætter efter dem, og jeg vil forherlige mig på Farao og hele hans Krigsmagt, og Ægypterne skal kende, at jeg er HERREN!” Og de gjorde således. ");
INSERT INTO dan1931_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Da det nu meldtes Ægypterkongen, at Folket var flygtet, skiftede Farao og hans Tjenere Sind over for Folket og sagde: “Hvor kunde vi dog slippe Israelitterne af vor Tjeneste!” ");
INSERT INTO dan1931_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Da lod han spænde for sin Vogn og tog sine Krigsfolk med sig; ");
INSERT INTO dan1931_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","han tog 600 udsøgte Stridsvogne og alle Ægyptens Krigsvogne, alle bemandede med Vognkæmpere. ");
INSERT INTO dan1931_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Og HERREN forhærdede Ægypterkongen Faraos Hjerte, så han satte efter Israelitterne; men Israelitterne var draget ud under en stærk Hånds Værn. ");
INSERT INTO dan1931_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Og Ægypterne, alle Faraos Heste og Vogne og hans Ryttere og øvrige Krigsfolk, satte efter dem og indhentede dem, da de havde slået Lejr ved Havet, ved Pi-Hakirot over for Ba'al-Zefon. ");
INSERT INTO dan1931_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Da nu Farao nærmede sig, så Israelitterne op og fik Øje på Ægypterne, der drog efter dem, og de grebes af stor Angst; da råbte Israelitterne til HERREN; ");
INSERT INTO dan1931_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","og de sagde til Moses: “Er det, fordi der ingen Grave var i Ægypten, at du har fået os ud for at dø i Ørkenen? Hvad er det dog, du har gjort os, at du førte os ud af Ægypten? ");
INSERT INTO dan1931_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Var det ikke det, vi sagde til dig i Ægypten: Lad os i Fred, og lad os blive ved at trælle for Ægypterne! Thi det er bedre for os at trælle for Ægypterne end at dø i Ørkenen.” ");
INSERT INTO dan1931_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Men Moses svarede Folket: “Frygt ikke! Hold blot Stand, så skal I se HERRENS Frelse, som han i Dag vil hjælpe eder til, thi som I ser Ægypterne i Dag, skal I aldrig i Evighed se dem mere. ");
INSERT INTO dan1931_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","HERREN skal stride for eder, men I skal tie!” ");
INSERT INTO dan1931_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Da sagde HERREN til Moses: “Hvorfor råber du til mig? Sig til Israelitterne, at de skal bryde op! ");
INSERT INTO dan1931_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Løft din Stav og ræk din Hånd ud over Havet og skil det ad i to Dele, så Israelitterne kan vandre gennem Havet på tør Bund. ");
INSERT INTO dan1931_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Se, jeg vil forhærde Ægypternes Hjerte, så de følger efter dem, og jeg vil forherlige mig på Farao og hele hans Krigsmagt, på hans Vogne og Ryttere, ");
INSERT INTO dan1931_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","og Ægypterne skal kende, at jeg er HERREN, når jeg forherliger mig på Farao, hans Vogne og Ryttere.” ");
INSERT INTO dan1931_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Guds Engel, der drog foran Israels Hær, flyttede sig nu og gik bag ved dem; og Skystøtten flyttede sig fra Pladsen foran dem og stillede sig bag ved dem ");
INSERT INTO dan1931_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","og kom til at stå imellem Ægypternes og Israels Hære; og da det blev mørkt; blev Skystøtten til en Ildstøtte og oplyste Natten. Således kom de ikke hinanden nær hele Natten. ");
INSERT INTO dan1931_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses rakte da sin Hånd ud over Havet, og HERREN drev Havet bort med en stærk Østenstorm, der blæste hele Natten, og han gjorde Havet til tørt Land. Og Vandet delte sig. ");
INSERT INTO dan1931_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Da gik Israelitterne midt igennem Havet på tør Bund, medens Vandet stod som en Mur på begge Sider af dem. ");
INSERT INTO dan1931_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Og Ægypterne, alle Faraos Heste, Vogne og Ryttere, satte efter dem og forfulgte dem midt ud i Havet. ");
INSERT INTO dan1931_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Men ved Morgenvagtens Tid skuede HERREN fra Ild og Skystøtten hen imod Ægypternes Hær og bragte den i Uorden; ");
INSERT INTO dan1931_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","og han stoppede Vognenes Hjul, så de havde ondt ved at få dem frem. Da sagde Ægypterne: “Lad os flygte for Israel, thi HERREN kæmper for dem imod Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Men HERREN sagde til Moses: “Ræk din Hånd ud over Havet, så skal Vandet vende tilbage over Ægypterne, deres Vogne og Ryttere!” ");
INSERT INTO dan1931_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Da rakte Moses sin Hånd ud over Havet; og Havet vendte tilbage til sit sædvanlige Leje ved Morgenens Frembrud, medens de flygtende Ægyptere kom lige imod det, og HERREN drev Ægypterne midt ud i Havet. ");
INSERT INTO dan1931_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Da vendte Vandet tilbage og overskyllede Vognene og Rytterne i hele Faraos Krigsmagt, som havde forfulgt dem ud i Havet; ikke en eneste af dem blev tilbage. ");
INSERT INTO dan1931_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Men Israelitterne var gået gennem Havet på tør Bund, medens Vandet stod som en Mur på begge Sider af dem. ");
INSERT INTO dan1931_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Og HERREN frelste på den dag Israel af Ægypternes Hånd, og Israel så Ægypterne ligge døde ved Havets Bred. ");
INSERT INTO dan1931_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Da så Israel den Stordåd, HERREN havde udført mod Ægypterne; og Folket frygtede HERREN, og de troede på HERREN og på hans Tjener Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ved den Lejlighed sang Moses og Israelitterne denne Sang for HERREN: Jeg vil synge for HERREN, thi han er højt ophøjet, Hest og Rytter styrted han i Havet! ");
INSERT INTO dan1931_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","HERREN er min Styrke og min Lovsang, og han blev mig til Frelse. Han er min Gud, og jeg vil prise ham, min Faders Gud, og jeg vil ophøje ham. ");
INSERT INTO dan1931_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","HERREN er en Krigshelt, HERREN er hans Navn! ");
INSERT INTO dan1931_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Faraos Vogne og Krigsmagt styrted han i Havet, hans ypperste Vognkæmpere drukned i det røde Hav, ");
INSERT INTO dan1931_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Strømmene dækked dem, de sank som Sten i Dybet. ");
INSERT INTO dan1931_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Din højre, HERRE, er herlig i Kraft, din højre, HERRE, knuser Fjenden. ");
INSERT INTO dan1931_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I din Højheds Vælde fælder du dine Modstandere, du slipper din Harme løs, den fortærer dem som Strå. ");
INSERT INTO dan1931_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ved din Næses Pust dyngedes Vandene op, Vandene stod som en Vold, Strømmene stivnede midt i Havet. ");
INSERT INTO dan1931_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Fjenden tænkte: “Jeg sætter efter dem, indhenter dem, uddeler Bytte, stiller mit Begær på dem; jeg drager mit Sværd, min Hånd skal udrydde dem.” ");
INSERT INTO dan1931_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Du blæste med din Ånde, Havet skjulte dem; de sank som Bly i de vældige Vande. ");
INSERT INTO dan1931_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Hvo er som du blandt Guder, HERRE, hvo er som du, herlig i Hellighed, frygtelig i Stordåd, underfuld i dine Gerninger! ");
INSERT INTO dan1931_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Du udrakte din højre, og Jorden slugte dem. ");
INSERT INTO dan1931_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Du leded i din Miskundhed det Folk, du genløste, du førte det i din Vælde til din hellige Bolig. ");
INSERT INTO dan1931_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Folkene hørte det og bæved, Skælven greb Filisterlandets Folk. ");
INSERT INTO dan1931_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Da forfærdedes Edoms Høvdinger, Moabs Fyrster grebes af Rædsel, Kana'ans Beboere tabte alle Modet. ");
INSERT INTO dan1931_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Skræk og Angst faldt over dem, ved din Arms Vælde blev de målløse som Sten, til dit Folk var nået frem, o HERRE, til Folket, du vandt dig, var nået frem. ");
INSERT INTO dan1931_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","du førte dem frem og planted dem i din Arvelods Bjerge, på det Sted du beredte dig til Bolig, HERRE, i den Helligdom, Herre, som dine Hænder grundfæsted. ");
INSERT INTO dan1931_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","HERREN er Konge i al Evighed! ");
INSERT INTO dan1931_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Thi da Faraos Heste med hans Vogne og Ryttere drog ud i Havet, lod HERREN Havets Vande strømme tilbage over dem, medens Israelitterne gik gennem Havet på tør Bund. ");
INSERT INTO dan1931_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Da greb Profetinden Mirjam, Arons Søster, Pauken, og alle Kvinderne fulgte hende med Pauker og Danse, ");
INSERT INTO dan1931_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","og Mirjam sang for: Syng for HERREN, thi han er højt ophøjet, Hest og Rytter styrted han i Havet! ");
INSERT INTO dan1931_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Derpå lod Moses Israel bryde op fra det røde Hav, og de drog ud i Sjurs Ørken, og de vandrede tre Dage i Ørkenen uden at finde Vand. ");
INSERT INTO dan1931_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Så nåede de Mara*, men de kunde ikke drikke Vandet for dets bitre Smag, thi det var bittert; derfor kaldte man Stedet Mara. { *betyder Bitterhed. } ");
INSERT INTO dan1931_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Da knurrede Folket mod Moses og sagde: “Hvad skal vi drikke?” ");
INSERT INTO dan1931_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Men han råbte til HERREN, og da viste HERREN ham en bestemt Slags Træ; og da han kastede det i Vandet, blev Vandet drikkeligt. Der gav han dem Bestemmelser om Lov og Ret, og der satte han dem på Prøve. ");
INSERT INTO dan1931_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Og han sagde: “Hvis du vil høre på HERREN din Guds Røst og gøre, hvad der er ret i hans Øjne, og lytte til hans Bud og holde dig alle hans Bestemmelser efterrettelig, så vil jeg ikke bringe nogen af de Sygdomme over dig, som jeg bragte over Ægypterne, men jeg HERREN er din Læge!” ");
INSERT INTO dan1931_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Derpå kom de til Elim, hvor der var tolv Vandkilder og halvfjerdsindstyve Palmetræer, og de lejrede sig ved Vandet der. ");
INSERT INTO dan1931_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Så brød de op fra Elim, og hele Israelitternes Menighed kom til Sins Ørken, der ligger mellem Elim og Sinaj, på den femtende Dag i den anden Måned efter deres Udvandring af Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Men hele Israelitternes Menighed knurrede mod Moses og Aron i Ørkenen, ");
INSERT INTO dan1931_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","og Israelitterne sagde til dem: “Var vi dog blot døde for HERRENS Hånd i Ægypten, hvor vi sad ved Kødgryderne og kunde spise os mætte i Brød! Thi I har ført os ud i denne Ørken for at lade hele denne Forsamling dø af Sult.” ");
INSERT INTO dan1931_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Da sagde HERREN til Moses: “Se, jeg vil lade Brød regne ned fra Himmelen til eder, og Folket skal gå ud og hver Dag samle så meget, som de daglig behøver, for at jeg kan prøve dem, om de vil følge min Lov eller ej. ");
INSERT INTO dan1931_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Og når de på den sjette Ugedag tilbereder, hvad de har bragt hjem, så skal det være dobbelt så meget, som de samler de andre Dage.” ");
INSERT INTO dan1931_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Og Moses og Aron sagde til alle Israelitterne: “I Aften skal I kende, at det er HERREN, som har ført eder ud af Ægypten, ");
INSERT INTO dan1931_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","og i Morgen skal I skue HERRENS Herlighed, thi han har hørt eders Knurren mod HERREN; thi hvad er vel vi, at I knurrer mod os!” ");
INSERT INTO dan1931_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Og Moses tilføjede: “Det skal ske, når HERREN i Aften giver eder Kød at spise og i Morgen Brød at mætte eder med; thi HERREN har hørt, hvorledes I knurrer mod ham; thi hvad er vi? Thi det er ikke os, I knurrer imod, men HERREN.” ");
INSERT INTO dan1931_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Derpå sagde Moses til Aron: “Sig til hele Israelitternes Menighed: Træd frem for HERRENS Åsyn, thi han har hørt eders Knurren!” ");
INSERT INTO dan1931_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Og da Aron sagde det til hele Israelitternes Menighed, vendte de sig mod Ørkenen, og se, HERRENS Herlighed viste sig i Skyen. ");
INSERT INTO dan1931_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Da talede HERREN til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Jeg har hørt Israelitternes Knurren; sig til dem: Ved Aftenstid skal I få Kød at spise, og i Morgen tidlig skal I få Brød at mætte eder med, og I skal kende, at jeg er HERREN eders Gud.” ");
INSERT INTO dan1931_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Da det nu blev Aften, kom en Sværm Vagtler flyvende og faldt i et tykt Lag over Lejren; og næste Morgen lå Duggen tæt rundt om Lejren, ");
INSERT INTO dan1931_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","og da Duggen svandt, var Ørkenen dækket med noget fint, skælagtigt noget, noget fint der lignede Rim på Jorden. ");
INSERT INTO dan1931_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Da Israelitterne så det, spurgte de hverandre: “Hvad* er det?” Thi de vidste ikke, hvad det var; men Moses sagde til dem: “Det er det Brød, HERREN har givet eder til Føde! { *hebr.: “man”. Joh. 6, 31. 1 Kor. 10, 3. } ");
INSERT INTO dan1931_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Og således har HERREN påbudt: I skal samle deraf, enhver så meget som han har behov, en Omer for hvert Hoved; I skal tage deraf i Forhold til Antallet af eders Husfolk, enhver skal tage deraf til dem, der er i hans Telt!” ");
INSERT INTO dan1931_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israelitterne gjorde nu således, og de samlede, nogle mere og andre mindre; ");
INSERT INTO dan1931_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","og da de målte det med Omeren, havde den, der havde meget, ikke for meget, og den, der havde lidt, ikke for lidt, enhver havde samlet, hvad han behøvede til Føde. ");
INSERT INTO dan1931_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Derpå sagde Moses til dem: “Ingen må gemme noget deraf til næste Morgen!” ");
INSERT INTO dan1931_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Dog adlød de ikke Moses, og nogle af dem gemte noget deraf til næste Morgen; men da var det fuldt af Orme og lugtede. Da blev Moses vred på dem. ");
INSERT INTO dan1931_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Således samlede de nu hver Morgen, enhver så meget som han havde behov. Men når Solen begyndte at brænde, smeltede det. ");
INSERT INTO dan1931_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","På den sjette Ugedag havde de samlet dobbelt så meget Brød, to Omer for hver Person. Og alle Menighedens Øverster kom og sagde det til Moses; ");
INSERT INTO dan1931_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","men han sagde til dem: “Det er netop, som HERREN har sagt. I Morgen er det Hviledag, en hellig Sabbat for HERREN. Bag, hvad I vil bage, og kog, hvad I vil koge, men læg det tiloversblevne til Side for at gemme det til i Morgen!” ");
INSERT INTO dan1931_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","De lagde det da til Side til næste Dag, som Moses havde befalet, og det kom ikke til at lugte, og der gik ikke Orm deri. ");
INSERT INTO dan1931_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Derpå sagde Moses: “Det skal I spise i Dag, thi i Dag er det Sabbat for HERREN; i Dag finder I intet ude på Marken. ");
INSERT INTO dan1931_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","I seks Dage skal I samle det, men på den syvende Dag, på Sabbaten, er der intet at finde.” ");
INSERT INTO dan1931_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Alligevel var der nogle blandt Folket, der gik ud på den syvende Dag for at samle; men de fandt intet. ");
INSERT INTO dan1931_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Da sagde HERREN til Moses: “Hvor længe vil I vægre eder ved at holde mine Bud og Love? ");
INSERT INTO dan1931_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Betænk dog, at HERREN har givet eder Sabbaten! Derfor giver han eder på den sjette Dag Brød til to Dage. Enhver af eder skal blive, hvor han er, og ingen må forlade sin Bolig på den syvende Dag!” ");
INSERT INTO dan1931_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Da hvilede Folket på den syvende Dag. ");
INSERT INTO dan1931_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Men Israelitterne kaldte det Manna; det lignede hvide Korianderfrø og smagte som Honningkager. ");
INSERT INTO dan1931_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses sagde fremdeles: “Således har HERREN påbudt: En Omer fuld deraf skal gemmes til eders Efterkommere, for at de kan se det Brød, jeg gav eder at spise i Ørkenen, da jeg førte eder ud af Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Og Moses sagde til Aron: “Tag en Krukke, kom en Omer Manna deri og stil den foran HERRENS Åsyn for at gemmes til eders Efterkommere!” ");
INSERT INTO dan1931_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Og Aron gjorde, som HERREN havde pålagt Moses, og han stillede den foran Vidnesbyrdet* for at gemmes. { *dvs. Vidnesbyrdet om Guds Vilje på Lovens Tavler. } ");
INSERT INTO dan1931_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Og Israelitterne spiste Manna i fyrretyve År, indtil de kom til beboede Egne; de spiste Manna, indtil de kom til Grænsen af Kana'ans Land. ");
INSERT INTO dan1931_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","En Omer er Tiendedelen af en Efa. ");
INSERT INTO dan1931_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Så brød hele Israels Menighed op fra Sins Ørken og drog fra Lejrplads til Lejrplads efter HERRENS Bud. Men da de lejrede sig i Refidim, havde Folket intet Vand at drikke. ");
INSERT INTO dan1931_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Da kivedes Folket med Moses og sagde: “Skaf os Vand at drikke!” Men Moses svarede dem: “Hvorfor kives I med mig, hvorfor frister I HERREN?” ");
INSERT INTO dan1931_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Og Folket tørstede der efter Vand og knurrede mod Moses og sagde: “Hvorfor har du ført os op fra Ægypten? Mon for at lade os og vore Børn og vore Hjorde dø af Tørst?” ");
INSERT INTO dan1931_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Da råbte Moses til HERREN: “Hvad skal jeg gøre med dette Folk? Det er ikke langt fra, at de vil stene mig.” ");
INSERT INTO dan1931_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Men HERREN sagde til Moses: “Træd frem for Folket med nogle af Israels Ældste og tag den Stav, du slog Nilen med, i din Hånd og kom så! ");
INSERT INTO dan1931_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Se, jeg vil stå foran dig der på Klippen ved Horeb, og når du slår på Klippen, skal der strømme Vand ud af den, så Folket kan få noget at drikke.” Det gjorde Moses så i Påsyn af Israels Ældste. ");
INSERT INTO dan1931_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Og han kaldte dette Sted Massa* og Meriba**, fordi Israelitterne der havde kivedes og fristet HERREN ved at sige: “Er HERREN iblandt os eller ej?” { *betyder Fristelse. / **betyder Kiv. } ");
INSERT INTO dan1931_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Derefter kom Amalekitterne og angreb Israel i Refidim. ");
INSERT INTO dan1931_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Da sagde Moses til Josua: “Udvælg dig Mænd og ryk i. Morgen ud til Kamp mod Amalekitterne; jeg vil stille mig på Toppen af Højen med Guds Stav i Hånden!” ");
INSERT INTO dan1931_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josua gjorde, som Moses bød, og rykkede ud til Kamp mod Amalekitterne. Men Moses, Aron og Hur gik op på Toppen af Højen. ");
INSERT INTO dan1931_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Når nu Moses løftede Hænderne i Vejret, fik Israelitterne Overtaget, men når han lod Hænderne synke, fik Amalekitterne Overtaget. ");
INSERT INTO dan1931_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Og da Moses' Hænder blev trætte, tog de en Sten og lagde under ham; så satte han sig på den, og Aron og Hur støttede hans Hænder, hver på sin Side; således var hans Hænder stadig løftede til Solen gik ned, ");
INSERT INTO dan1931_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","og Josua huggede Amalekitterne og deres Krigsfolk ned med Sværdet. ");
INSERT INTO dan1931_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Da sagde HERREN til Moses: “Optegn dette i en Bog, for at det kan mindes, og indskærp Josua, at jeg fuldstændig vil udslette Amalekitternes Minde under Himmelen!” ");
INSERT INTO dan1931_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Derpå byggede Moses et Alter og kaldte det: “HERREN er mit Banner!” ");
INSERT INTO dan1931_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Og han sagde: “Der er en udrakt Hånd på HERRENS Trone! HERREN har Krig med Amalek fra Slægt til Slægt!” ");
INSERT INTO dan1931_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Da Jetro, Præsten i Midjan, Moses' Svigerfader, hørte om alt, hvad Gud havde gjort for Moses og hans Folk Israel, hvorledes HERREN havde ført Israel ud af Ægypten, ");
INSERT INTO dan1931_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","tog Jetro, Moses' Svigerfader, Zippora, Moses' Hustru, som han havde sendt hjem, ");
INSERT INTO dan1931_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","tillige med hendes to Sønner. Af dem hed den ene Gersom; “thi”, havde han sagt, “jeg er blevet Gæst i et fremmed Land”; ");
INSERT INTO dan1931_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","og den anden hed Eliezer; “thi”, havde han sagt, “min Faders Gud har været min Hjælp* og frelst mig fra Faraos Sværd!” { *på hebr. Ordspil med Navnet Eliezer. } ");
INSERT INTO dan1931_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Og Jetro, Moses' Svigerfader, kom med hans Sønner og Hustru til Moses i Ørkenen, hvor han havde slået Lejr ved Guds Bjerg, ");
INSERT INTO dan1931_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","og han lod Moses melde: “Jetro, din Svigerfader, kommer til dig med din Hustru og hendes to Sønner!” ");
INSERT INTO dan1931_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Da gik Moses sin Svigerfader i Møde, bøjede sig for ham og kyssede ham; og da de havde hilst på hinanden, gik de ind i Teltet. ");
INSERT INTO dan1931_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses fortalte sin Svigerfader om alt, hvad HERREN havde gjort ved Farao og Ægypten for Israels Skyld, og om alle de Besværligheder, der havde mødt dem undervejs, og hvorledes HERREN havde frelst dem. ");
INSERT INTO dan1931_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Da glædede Jetro sig over alt det gode, HERREN havde gjort mod Israel, idet han havde frelst dem af Ægypternes Hånd. ");
INSERT INTO dan1931_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Og Jetro sagde: “Lovet være HERREN, som har frelst eder af Ægypternes og Faraos. Hånd!” ");
INSERT INTO dan1931_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nu ved jeg, at HERREN er større end alle Guder, thi netop ved det, de i deres Overmod foretog sig imod dem, frelste han Folket af Ægypternes Hånd. ");
INSERT INTO dan1931_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Derpå udtog Jetro, Moses' Svigerfader, Brændofre og Slagtofre til Gud; og Aron og alle Israels Ældste kom for at holde Måltid for Guds Åsyn med Moses' Svigerfader. ");
INSERT INTO dan1931_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Næste Morgen tog Moses Sæde for at holde Ret for Folket, og Folket stod omkring Moses fra Morgen til Aften. ");
INSERT INTO dan1931_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Men da Moses' Svigerfader så alt det Arbejde, han havde med Folket, sagde han: “Hvad er dog det for et Arbejde, du har med Folket? Hvorfor sidder du alene til Doms, medens alt Folket står omkring dig fra Morgen til Aften?” ");
INSERT INTO dan1931_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses svarede sin Svigerfader: “Jo, Folket kommer til mig for at rådspørge Gud; ");
INSERT INTO dan1931_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","når de har en Retssag, kommer de til mig, og jeg dømmer Parterne imellem og kundgør dem Guds Anordninger og Love.” ");
INSERT INTO dan1931_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Da sagde Moses' Svigerfader til ham: “Det er ikke klogt, som du bærer dig ad med det. ");
INSERT INTO dan1931_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","På den Måde bliver jo både du selv og Folket der omkring dig ganske udmattet, thi det Arbejde er dig for anstrengende, du kan ikke overkomme det alene. ");
INSERT INTO dan1931_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Læg dig nu på Sinde, hvad jeg siger; jeg vil give dig et Råd, og Gud skal være med dig: Du skal. selv træde frem for Gud på Folkets Vegne og forelægge Gud de forefaldende Sager; ");
INSERT INTO dan1931_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","og du skal indskærpe dem Anordningerne og Lovene og lære dem den Vej, de skal vandre, og hvad de har at gøre. ");
INSERT INTO dan1931_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Men du skal af hele Folket udvælge dig dygtige Mænd, som frygter Gud, Mænd, som er til at lide på og hader uretfærdig Vinding, og dem skal du sætte over dem som Forstandere, nogle over tusinde, andre over hundrede, andre over halvtredsindstyve, andre over ti; ");
INSERT INTO dan1931_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","lad dem til Stadighed holde Ret for Folket. Alle vigtigere Sager skal de forebringe dig, men alle mindre Sager skal de selv afgøre. Let dig således Arbejdet og lad dem komme til at bære Byrden med dig. ");
INSERT INTO dan1931_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Dersom du handler således og Gud vil det så, kan du holde ud, og alt Folket der kan gå tilfreds hjem.” ");
INSERT INTO dan1931_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses fulgte sin Svigerfaders Råd og gjorde alt, hvad han foreslog. ");
INSERT INTO dan1931_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Og Moses udvalgte dygtige Mænd af hele Israel og gjorde dem til Øverster over Folket, til Forstandere, nogle over tusinde, andre over hundrede, andre over halvtredsindstyve, andre over ti. ");
INSERT INTO dan1931_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","De holdt derpå til Stadighed Ret for Folket; de vanskelige Sager forebragte de Moses, men alle mindre Sager afgjorde de selv. ");
INSERT INTO dan1931_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Derpå tog Moses Afsked med sin Svigerfader, og denne begav sig til sit Land. ");
INSERT INTO dan1931_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","I den tredje Måned* efter Israelitternes Udvandring af Ægypten, på denne Dag nåede de Sinaj Ørken. { *oprindelig var der vel nævnet en Dato. } ");
INSERT INTO dan1931_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","De brød op fra Refidim og kom til Sinaj Ørken og slog Lejr i Ørkenen. Der slog Israel Lejr lige over for Bjerget, ");
INSERT INTO dan1931_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","men Moses steg op til Gud. Da råbte HERREN til ham fra Bjerget: “Dette skal du sige til Jakobs Hus og kundgøre for Israels Børn: ");
INSERT INTO dan1931_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","I har set, hvad jeg gjorde ved Ægypterne, og hvorledes jeg bar eder på Ørnevinger og bragte eder hid til mig. ");
INSERT INTO dan1931_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Hvis I nu vil lyde min Røst og holde min Pagt, så skal I være min Ejendom blandt alle Folkene, thi mig hører hele Jorden til, ");
INSERT INTO dan1931_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","og I skal blive mig et Kongerige af Præster og et helligt Folk! Det er de Ord, du skal tale til Israels Børn!” ");
INSERT INTO dan1931_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Da gik Moses hen og kaldte Folkets Ældste sammen og forelagde dem alle disse Ord, som HERREN havde pålagt ham. ");
INSERT INTO dan1931_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Og hele Folket svarede, alle som én: “Alt, hvad HERREN har sagt, vil vi gøre!” Da bragte Moses HERREN Folkets Svar. ");
INSERT INTO dan1931_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Derpå sagde HERREN til Moses: “Se, jeg vil komme til dig i en tæt Sky, for at Folket kan høre, at jeg taler med dig, og for stedse tro også på dig!” Og Moses kundgjorde HERREN Folkets Svar. ");
INSERT INTO dan1931_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Da sagde HERREN til Moses: “Gå til Folket og lad dem hellige sig i Dag og i Morgen og tvætte deres Klæder ");
INSERT INTO dan1931_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","og holde sig rede til i Overmorgen, thi i Overmorgen vil HERREN stige ned for alt Folkets Øjne på Sinaj Bjerg. ");
INSERT INTO dan1931_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Og du skal rundt om spærre af for Folket og sige til dem: Vogt eder for at gå op på Bjerget, ja for blot at røre ved Yderkanten deraf; enhver, der rører ved Bjerget, er dødsens! ");
INSERT INTO dan1931_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ingen Hånd må røre ved ham, han skal stenes eller skydes ned; hvad enten det er et Dyr eller et Menneske, skal det miste Livet. Når Vædderhornet lyder, skal de stige op på Bjerget.” ");
INSERT INTO dan1931_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Så steg Moses ned fra Bjerget til Folket og lod Folket hellige sig, og de tvættede deres Klæder; ");
INSERT INTO dan1931_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","og han sagde til Folket: “Hold eder rede til i Overmorgen, ingen må komme en Kvinde nær!” ");
INSERT INTO dan1931_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Da Morgenen gryede den tredje Dag, begyndte det at tordne og lyne, og en tung Sky lagde sig over Bjerget, og der hørtes vældige Stød i Horn. Da skælvede alt Folket i Lejren. ");
INSERT INTO dan1931_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Så førte Moses Folket fra Lejren hen for Gud, og de stillede sig neden for Bjerget. ");
INSERT INTO dan1931_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Men hele Sinaj Bjerg hylledes i Røg, fordi HERREN steg ned derpå i Ild, og Røgen stod i Vejret som Røg fra en Smelteovn; og hele Folket skælvede såre. ");
INSERT INTO dan1931_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Og Stødene i Hornene blev stærkere og stærkere; Moses talte, og Gud svarede ham med høj Røst. ");
INSERT INTO dan1931_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Og da HERREN var steget ned på Sinaj Bjerg, på Toppen af Bjerget, kaldte han Moses op på Toppen af Bjerget, og Moses steg derop. ");
INSERT INTO dan1931_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Da sagde HERREN til Moses: “Stig ned og indskærp Folket, at de ikke må trænge sig frem til HERREN for at se ham, at der ikke skal ske et stort Mandefald iblandt dem. ");
INSERT INTO dan1931_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Selv Præsterne, som ellers træder frem for HERREN, skal hellige sig, for at ikke HERREN skal tynde ud i deres Rækker.” ");
INSERT INTO dan1931_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Da sagde Moses til HERREN: “Folket kan jo ikke stige op på Sinaj Bjerg, thi du har selv indskærpet os at afspærre Bjerget og hellige det.” ");
INSERT INTO dan1931_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Men HERREN sagde til ham: “Stig nu ned og kom atter herop sammen med Aron; men Præsterne og Folket må ikke trænge sig frem for at komme op til HERREN, at han ikke skal tynde ud i deres Rækker.” ");
INSERT INTO dan1931_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Da steg Moses ned til Folket og sagde det til dem. ");
INSERT INTO dan1931_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Gud talede alle disse Ord og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Jeg er HERREN din Gud, som førte dig ud af Ægypten, af Trællehuset. ");
INSERT INTO dan1931_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Du må ikke have andre Guder end mig. ");
INSERT INTO dan1931_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Du må ikke gøre dig noget udskåret Billede eller noget Afbillede af det, som er oppe i Himmelen eller nede på Jorden eller i Vandet under Jorden; ");
INSERT INTO dan1931_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","du må ikke tilbede eller dyrke det, thi jeg HERREN din Gud er en nidkær Gud, der indtil tredje og fjerde Led straffer Fædres Brøde på Børn af dem, som hader mig, ");
INSERT INTO dan1931_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","men i tusind Led viser Miskundhed mod dem, der elsker mig og holder mine Bud! ");
INSERT INTO dan1931_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Du må ikke misbruge HERREN din Guds Navn, thi HERREN lader ikke den ustraffet, der misbruger hans Navn! ");
INSERT INTO dan1931_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Kom Hviledagen* i Hu, så du holder den hellig! { *dvs. Sabbatsdagen. } ");
INSERT INTO dan1931_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","I seks Dage skal du arbejde og gøre al din Gerning, ");
INSERT INTO dan1931_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","men den syvende Dag skal være Hviledag for HERREN din Gud; da må du intet Arbejde udføre, hverken du selv, din Søn eller Datter, din Træl eller Trælkvinde, dit Kvæg eller den fremmede inden dine Porte. ");
INSERT INTO dan1931_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Thi i seks Dage gjorde HERREN Himmelen, Jorden og Havet med alt, hvad der er i dem, og på den syvende Dag hvilede han; derfor har HERREN velsignet Hviledagen og helliget den. ");
INSERT INTO dan1931_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ær din Fader og din Moder, for at du kan få et langt Liv i det Land, HERREN din Gud vil give dig! ");
INSERT INTO dan1931_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Du må ikke slå ihjel! ");
INSERT INTO dan1931_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Du må ikke bedrive Hor! ");
INSERT INTO dan1931_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Du må ikke stjæle! ");
INSERT INTO dan1931_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Du må ikke sige falsk Vidnesbyrd imod din Næste! ");
INSERT INTO dan1931_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Du må ikke begære din Næstes Hus! Du må ikke begære din Næstes Hustru, hans Træl eller Trælkvinde, hans Okse eller Æsel eller noget, der hører din Næste til! ");
INSERT INTO dan1931_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Men da hele Folket fornam Tordenen, Lynene og Stødene i Hornene og så det rygende Bjerg forfærdedes Folket og holdt sig skælvende i Frastand; ");
INSERT INTO dan1931_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","og de sagde til Moses: “Tal du med os, så vil vi lytte til; men lad ikke Gud tale med os, at vi ikke skal dø!” ");
INSERT INTO dan1931_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Men Moses svarede Folket: “Frygt ikke, thi Gud er kommet for at prøve eder, og for at I kan lære at frygte for ham, så I ikke synder.” ");
INSERT INTO dan1931_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Da holdt Folket sig i Frastand medens Moses nærmede sig Mulmet, hvori Gud var. ");
INSERT INTO dan1931_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","HERREN sagde da til Moses: Således skal du sige til Israelitterne: I har selv set, at jeg har talet med eder fra Himmelen! ");
INSERT INTO dan1931_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","I må ikke gøre eder Guder ved Siden af mig; Guder af Sølv eller Guld må I ikke gøre eder! ");
INSERT INTO dan1931_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Du skal bygge mig et Alter af Jord, og på det skal du ofre dine Brændofre og Takofre, dit Småkvæg og dit Hornkvæg; på ethvert Sted, hvor jeg lader mit Navn ihukomme, vil jeg komme til dig og velsigne dig. ");
INSERT INTO dan1931_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Men hvis du opfører mig Altre af Sten, må du ikke bygge dem af tilhugne Sten, thi når du svinger dit Værktøj derover, vanhelliger du dem. ");
INSERT INTO dan1931_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Du må ikke stige op til mit, Alter ad Trin, for at ikke din Blusel skal blottes over det. ");
INSERT INTO dan1931_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","De Lovbud, du skal forelægge dem, er følgende: ");
INSERT INTO dan1931_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Når du køber dig en hebræisk Træl, skal han trælle i seks År, men i det syvende skal han frigives uden Vederlag. ");
INSERT INTO dan1931_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Er han ugift, når han kommer til dig, skal han frigives alene; er han gift, skal hans Hustru frigives sammen med ham. ");
INSERT INTO dan1931_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Hvis hans Herre giver ham en Hustru og hun føder ham Sønner eller Døtre, da skal Hustruen og hendes Børn tilhøre hendes Herre, og Trællen frigives alene. ");
INSERT INTO dan1931_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Hvis han imidlertid erklærer: “Jeg har fået Kærlighed til min Herre, min Hustru og mine Børn, jeg vil ikke have min Frihed!” ");
INSERT INTO dan1931_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","da skal hans Herre føre ham hen til Gud og stille ham op ad Døren eller Dørstolpen, og hans Herre skal gennembore hans Øre med en Syl, og så skal han være hans Træl for Livstid. ");
INSERT INTO dan1931_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Når en Mand sælger sin Datter som Trælkvinde, skal hun ikke frigives som Trællene. ");
INSERT INTO dan1931_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Dersom hun pådrager sig sin Herres Mishag, efter at han har haft Omgang med hende, skal han tillade, at hun købes fri; han har ikke Lov at sælge hende til fremmede Folk, når han har gjort Uret imod hende; ");
INSERT INTO dan1931_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","hvis han derimod bestemmer, at hun skal være hans Søns Hustru, skal han behandle hende, som det tilkommer Døtre. ");
INSERT INTO dan1931_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Hvis han tager sig en anden, har han ikke Lov at forholde den første den Kødspise, Klædning og ægteskabelige Ret, der tilkommer hende. ");
INSERT INTO dan1931_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Forholder han hende nogen af disse tre Ting, skal hun frigives uden Vederlag og Betaling. ");
INSERT INTO dan1931_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Den, der slår en Mand ihjel, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Gør han det imidlertid ikke med Forsæt, men styres hans Hånd af Gud, vil jeg anvise dig et Sted, hvor han kan ty hen. ");
INSERT INTO dan1931_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Når derimod en handler med Overlæg, så han med List slår sin Næste ihjel, da skal du rive ham bort fra mit Alter, for at han kan lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Den, der slår sin Fader eller Moder, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Den, der stjæler et Menneske, skal lide Døden, hvad enten han har solgt det, eller det endnu findes hos ham. ");
INSERT INTO dan1931_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Den, der forbander sin Fader eller Moder, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Når der opstår Strid mellem Mænd, og den ene slår den anden med en Sten eller med Næven, så at han vel ikke dør deraf, men dog må holde Sengen, ");
INSERT INTO dan1931_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","så skal Gerningsmanden være sagesløs, hvis han kan stå op og gå ud støttet til sin Stok; kun skal han godtgøre ham hans Tidsspilde og sørge for hans Helbredelse. ");
INSERT INTO dan1931_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Når en Mand slår sin Træl eller Trælkvinde med sin Stok, så de dør på Stedet, skal han straffes derfor; ");
INSERT INTO dan1931_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","men hvis de bliver i Live en Dag eller to, skal han ikke straffes; det er jo hans egne Penge. ");
INSERT INTO dan1931_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Når Mænd kommer i Slagsmål og støder til en frugtsommelig Kvinde, så hun nedkommer i Utide, men der ellers ingen Ulykke sker, da skal han bøde, hvad Kvindens Mand pålægger ham, og give Erstatning for det dødfødte Barn. ");
INSERT INTO dan1931_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Men hvis der sker en Ulykke, skal du bøde Liv for Liv, ");
INSERT INTO dan1931_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Øje for Øje, Tand for Tand, Hånd for Hånd, Fod for Fod, ");
INSERT INTO dan1931_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Brandsår for Brandsår, Sår for Sår, Skramme for Skramme. ");
INSERT INTO dan1931_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Når en Mand slår sin Træl eller sin Trælkvinde i Øjet og ødelægger det, skal han give dem fri til Erstatning for Øjet; ");
INSERT INTO dan1931_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","og hvis han slår en Tand ud på sin Træl eller Trælkvinde, skal han give dem fri til Erstatning for Tanden. ");
INSERT INTO dan1931_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Når en Okse stanger en Mand eller Kvinde ihjel, skal Oksen stenes, og dens Kød må ikke spises, men Ejeren er sagesløs; ");
INSERT INTO dan1931_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","men hvis Oksen allerede tidligere har villet stange, og dens Ejer er advaret, men alligevel ikke passer på den, og den så dræber en Mand eller Kvinde, da skal Oksen stenes, og dens Ejer skal også lide Døden; ");
INSERT INTO dan1931_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","men hvis der pålægges ham Sonepenge, skal han betale så stor en Løsesum for sit Liv, som der kræves af ham. ");
INSERT INTO dan1931_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Også hvis den stanger en Dreng eller en Pige, skal han behandles efter samme Lovbud. ");
INSERT INTO dan1931_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Men hvis Oksen stanger en Træl eller Trælkvinde, skal han betale deres Herre tredive Sekel Sølv, og Oksen skal stenes. ");
INSERT INTO dan1931_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Når en Mand tager Dækket af en Cisterne eller graver en Cisterne uden at dække den til, og en Okse eller et Æsel så falder deri, ");
INSERT INTO dan1931_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","da skal Brøndens Ejer erstatte det; han skal give Dyrets Ejer Erstatning i Penge, men det døde Dyr skal tilfalde ham, ");
INSERT INTO dan1931_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Når en Mands Okse stanger en andens Okse ihjel, skal de sælge den levende Okse og dele Pengene, og ligeledes skal de dele det døde dyr. ");
INSERT INTO dan1931_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Men hvis det er vitterligt, at Oksen tidligere har villet stange, og dens Ejer ikke har passet på den, da skal han erstatte Okse med Okse, men det døde Dyr skal tilfalde ham. ");
INSERT INTO dan1931_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Når en Mand stjæler en Okse eller et Får og slagter eller sælger dem, skal han give fem Okser i Erstatning for Oksen og fire Får for Fåret. ");
INSERT INTO dan1931_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","(Hvis en Tyv gribes på fersk Gerning ved et natligt Indbrud og bliver slået ihjel, da bliver der ikke Tale om Blodskyld;) ");
INSERT INTO dan1931_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","(men hvis Solen er stået op, pådrager man sig Blodskyld). Erstatning skal han give, og ejer han intet, skal han sælges som Træl til Vederlag for det stjålne; ");
INSERT INTO dan1931_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","hvis derimod det stjålne findes levende i hans Besiddelse, da skal han give dobbelt Erstatning, hvad enten det er en Okse, et Æsel, eller et Får. ");
INSERT INTO dan1931_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Når en Mand afsvider en Mark eller en Vingård og lader Ilden brede sig, så den antænder en andens Mark, da skal han give det bedste af sin Mark eller Vingård i Erstatning; ");
INSERT INTO dan1931_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","men breder Ilden sig ved at tage fat i Tjørnekrat, og Kornneg eller Sæd brænder, eller en Mark svides af, så skal den, der antændte Ilden, give simpel Erstatning. ");
INSERT INTO dan1931_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Når en Mand giver en anden Penge eller Sager i Varetægt, og de stjæles fra hans Hus, da skal Tyven, hvis han findes, give dobbelt Erstatning; ");
INSERT INTO dan1931_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","men hvis Tyven ikke findes, skal Husets Ejer træde frem for Gud og sværge på, at han ikke har forgrebet sig på den andens Gods. ");
INSERT INTO dan1931_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","I alle Tilfælde hvor det drejer sig om Uredelighed med en Okse, et Æsel, et Får, en Klædning eller en hvilken som helst bortkommen Ting, hvorom der rejses Krav, skal de to Parters Sag bringes frem for Gud, og den, som Gud dømmer skyldig, skal give den anden dobbelt Erstatning. ");
INSERT INTO dan1931_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Når en Mand giver en anden et Æsel, en Okse, et Får eller et andet Stykke Kvæg i Varetægt, og Dyret dør, kommer til Skade eller røves, uden at nogen ser det, ");
INSERT INTO dan1931_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","da skal han sværge ved HERREN på, at han ikke har forgrebet sig på den andens Ejendom, og det skal være afgørende imellem dem; Dyrets Ejer skal tage Eden god, og den anden behøver ikke at give Erstatning. ");
INSERT INTO dan1931_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Stjæles det derimod fra ham, skal han give Ejeren Erstatning. ");
INSERT INTO dan1931_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Hvis det sønderrives*, skal han bringe det sønderrevne Dyr med som Bevis; det sønderrevne skal han ikke erstatte. { *af et Rovdyr. } ");
INSERT INTO dan1931_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Når en låner et Dyr af en anden, og det kommer til Skade eller dør, uden at Ejeren er til Stede, skal han give Erstatning; ");
INSERT INTO dan1931_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","er Ejeren derimod til Stede, skal han ikke give Erstatning; var det lejet, er Lejesummen Erstatning. ");
INSERT INTO dan1931_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Når en Mand forfører en Jomfru, der ikke er trolovet, og ligger hos hende, skal han udrede Brudekøbesummen for hende og tage hende til Hustru; ");
INSERT INTO dan1931_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","og hvis hendes Fader vægrer sig ved at give ham hende, skal han tilveje ham den sædvanlige Brudekøbesum for en Jomfru. ");
INSERT INTO dan1931_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","En Troldkvinde må du ikke lade leve. ");
INSERT INTO dan1931_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Enhver, der har Omgang med Kvæg, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Den, der ofrer til andre Guder end HERREN alene, skal der lægges Band på. ");
INSERT INTO dan1931_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Den fremmede må du ikke undertrykke eller forulempe, thi I var selv fremmede i Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Enken eller den faderløse må I aldrig mishandle; ");
INSERT INTO dan1931_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","hvis I mishandler dem, og de råber om Hjælp til mig, vil jeg visselig høre på deres Klageråb, ");
INSERT INTO dan1931_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","og da vil min Vrede blusse op, og jeg vil slå eder ihjel med Sværdet, så eders egne Hustruer bliver Enker og eders Børn faderløse. ");
INSERT INTO dan1931_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Når du låner Penge til en fattig Mand af mit Folk i dit Nabolag, må du ikke optræde som en Ågerkarl over for ham. I må ikke tage Renter af ham. ");
INSERT INTO dan1931_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Hvis du tager din Næstes Kappe i Pant, skal du give ham den tilbage inden Solnedgang; ");
INSERT INTO dan1931_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","thi den er det eneste, han har at dække sig med, det er den, han hyller sit Legeme i; hvad skulde han, ellers ligge med? Og når han råber til mig, vil jeg høre ham, thi jeg er barmhjertig. ");
INSERT INTO dan1931_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Gud må du ikke spotte, og dit Folks Øvrighed må du ikke forbande. ");
INSERT INTO dan1931_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Din Lades Overflod og din Vinperses Saft må du ikke holde tilbage. Den førstefødte af dine Sønner skal du give mig. ");
INSERT INTO dan1931_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ligeså skal du gøre med dit Hornkvæg og dit Småkvæg; i syv Dage skal det blive hos Moderen, men på den ottende Dag skal I give mig det. ");
INSERT INTO dan1931_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","I skal være mig hellige Mænd; Kød af sønderrevne Dyr må I ikke spise, I skal kaste det for Hundene. ");
INSERT INTO dan1931_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Du må ikke udsprede falske Rygter. Gør ikke fælles Sag med den, der har Uret, ved at optræde som uretfærdigt Vidne. ");
INSERT INTO dan1931_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Du må ikke følge Mængden i, hvad der er ondt, eller i dit Vidnesbyrd for Retten tage Hensyn til Mængden, så du bøjer Retten. ");
INSERT INTO dan1931_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Du må ikke tage Parti for den ringe i hans Retssag. ");
INSERT INTO dan1931_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Når du træffer din Fjendes Okse eller Æsel løbende løse, skal du bringe dem tilbage til ham. ");
INSERT INTO dan1931_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Når du ser din Uvens Æsel segne under sin Byrde, må du ikke lade ham i Stikken, men du skal hjælpe ham med at læsse Byrden af. ");
INSERT INTO dan1931_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Du må ikke bøje din fattige Landsmands Ret i hans Retssag. ");
INSERT INTO dan1931_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Hold dig fra en uretfærdig Sag; og den, som er uskyldig og har Ret. må du ikke berøve Livet; nej, du må ikke skaffe den Ret, som har Uret. ");
INSERT INTO dan1931_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Tag ikke mod Bestikkelse, thi Bestikkelse gør den seende blind og fordrejer Sagen for dem, der har Ret. ");
INSERT INTO dan1931_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Undertryk ikke den fremmede; I ved jo, hvorledes den fremmede er til Mode, thi I, var selv fremmede i Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Seks År igennem skal du tilså dit Land og indsamle dets Afgrøde; ");
INSERT INTO dan1931_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","men i det syvende skal du lade det hvile og ligge urørt, så at de fattige i dit Folk kan gøre sig til gode dermed, og Markens vilde Dyr kan æde, hvad de levner; ligeså skal du gøre med din Vingård og dine Oliventræer. ");
INSERT INTO dan1931_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","I seks Dage skal du gøre dit Arbejde, men på den syvende skal du hvile, for at dine Okser og Æsler kan få Hvile og din Trælkvindes Søn og den fremmede hvile ud. ");
INSERT INTO dan1931_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Hold eder alt, hvad jeg siger eder, efterrettelig; du må ikke nævne andre Guders Navn, det må ikke høres i din Mund. ");
INSERT INTO dan1931_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tre Gange om Året skal du holde Højtid for mig. ");
INSERT INTO dan1931_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Du skal fejre de usyrede Brøds Højtid; i syv Dage skal du spise usyret Brød, som jeg har pålagt dig, på den fastsatte Tid i Abib Måned, thi i den Måned vandrede du ud af Ægypten, Man må ikke stedes for mit Åsyn med tomme Hænder. ");
INSERT INTO dan1931_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Fremdeles skal du fejre Højtiden for Høsten, Førstegrøden af dit Arbejde, af hvad du sår i din Mark, og Højtiden for Frugthøsten ved Årets Udgang, når du har bjærget Udbyttet af dit Arbejde hjem fra Marken. ");
INSERT INTO dan1931_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tre Gange om Året skal alle dine Mænd stedes for den Herre HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Du må ikke ofre Blodet af mit Slagtoffer sammen med syret Brød. Fedtet fra min Højtid må ikke gemmes til næste Morgen. ");
INSERT INTO dan1931_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Du skal bringe det første, Førstegrøden af din Jord, til HERREN din Guds Hus. Du må ikke koge et Kid i dets Moders Mælk. ");
INSERT INTO dan1931_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Se, jeg sender en Engel foran dig for at vogte dig undervejs og føre dig til det Sted, jeg har beredt. ");
INSERT INTO dan1931_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Tag dig vel i Vare for ham og adlyd ham; vær ikke genstridig imod ham, thi han skal ikke tilgive eders Overtrædelser, efterdi mit Navn er i ham. ");
INSERT INTO dan1931_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Når du adlyder ham og gør alt, hvad jeg siger, vil jeg være dine Fjenders Fjende og dine Modstanderes Modstander, ");
INSERT INTO dan1931_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ja, min Engel skal drage foran dig og føre dig til Amoritterne, Hetitterne, Perizzitterne, Kana'anæerne, Hivvitterne og Jebusitterne, og jeg vil udrydde dem. ");
INSERT INTO dan1931_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Du må ikke tilbede eller dyrke deres Guder eller følge deres Skikke; men du skal nedbryde dem og sønderslå deres Stenstøtter. ");
INSERT INTO dan1931_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","I skal dyrke HERREN eders Gud, så vil jeg velsigne dit Brød og dit Vand og holde Sygdomme borte fra dig. ");
INSERT INTO dan1931_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Utidige Fødsler eller Ufrugtbarhed skal ikke forekomme i dit Land, og dine Dages Mål vil jeg gøre fuldt. ");
INSERT INTO dan1931_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Jeg vil sende min Rædsel foran dig og bringe Bestyrtelse over alle de Folk, du kommer til, og jeg vil drive alle dine Fjender på Flugt for dig. ");
INSERT INTO dan1931_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Jeg vil sende Gedehamse foran dig, og de skal drive Hivvitterne, Kana'anæerne og Hetitterne bort foran dig. ");
INSERT INTO dan1931_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Men jeg vil ikke drive dem bort foran dig i et og samme År, for at Landet ikke skal lægges øde, og for at Markens vilde Dyr ikke skal tage Overhånd for dig; ");
INSERT INTO dan1931_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","lidt efter lidt vil jeg drive dem bort foran dig, indtil du bliver så talrig, at du kan tage Landet i Besiddelse. ");
INSERT INTO dan1931_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Jeg vil lade dine Landemærker nå fra det røde Hav til Filisternes Hav, fra Ørkenen til Floden, thi jeg giver Landets Indbyggere i eders Hånd, så du kan drive dem bort foran dig. ");
INSERT INTO dan1931_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Du må ikke slutte Pagt med dem eller deres Guder. ");
INSERT INTO dan1931_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","De må ikke blive boende i dit Land, for at de ikke skal forlede dig til Synd imod mig, til at dyrke deres Guder, så det bliver dig til en Snare! ");
INSERT INTO dan1931_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Og han sagde til Moses: “Stig op til HERREN, du og Aron, Nadab og Abihu og halvfjerdsindstyve af Israels Ældste, og tilbed i Frastand; ");
INSERT INTO dan1931_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses alene skal træde hen til HERREN, de andre ikke, og det øvrige Folk må ikke følge med ham derop.” ");
INSERT INTO dan1931_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Derpå kom Moses og kundgjorde hele Folket alle HERRENS Ord og alle Lovbudene, og hele Folket svarede enstemmigt: “Alle de Ord, HERREN har talet, vil vi overholde.” ");
INSERT INTO dan1931_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Da skrev Moses alle HERRENS Ord op; og tidligt næste Morgen rejste han ved Foden af Bjerget et Alter og tolv Stenstøtter svarende til Israels tolv Stammer. ");
INSERT INTO dan1931_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Derefter sendte han de unge Mænd blandt Israelitterne hen for at bringe Brændofre og slagte unge Tyre som Takofre til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Og Moses tog den ene Halvdel af Blodet og gød det i Offerskålene, men den anden Halvdel sprængte han på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Så tog han Pagtsbogen og læste den op i Folkets Påhør, og de sagde: “Vi vil gøre alt, hvad HERREN har talet, og lyde ham!” ");
INSERT INTO dan1931_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Derpå tog Moses Blodet og sprængte det på Folket, idet han sagde: “Se, dette er Pagtens Blod, den Pagt, HERREN har sluttet med eder på Grundlag af alle disse Ord.” ");
INSERT INTO dan1931_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Og Moses, Aron, Nadab og Abihu og halvfjerdsindstyve af Israels Ældste steg op ");
INSERT INTO dan1931_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","og skuede Israels Gud; under hans Fødder var der ligesom Safirfliser, som selve Himmelen i Stråleglans. ");
INSERT INTO dan1931_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Men han lagde ikke Hånd på Israelitternes ypperste Mænd. De skuede Gud, og de spiste og drak. ");
INSERT INTO dan1931_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Og HERREN sagde til Moses: “Stig op til mig på Bjerget og bliv der, så vil jeg give dig Stentavlerne, Loven og Budet, som jeg har opskrevet til Vejledning for dem.” ");
INSERT INTO dan1931_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Da bød Moses og Josua, hans Medhjælper op, og Moses steg op på Guds Bjerg; ");
INSERT INTO dan1931_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","men til de Ældste sagde han: “Vent på os her, til vi kommer tilbage til eder. Se, Aron og Hur er hos eder; er der nogen, der har en Retstrætte, kan han henvende sig til dem!” ");
INSERT INTO dan1931_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Derpå steg Moses op på Bjerget. Da indhyllede Skyen Bjerget, ");
INSERT INTO dan1931_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","og HERRENS Herlighed nedlod sig på Sinaj Bjerg. Og Skyen indhyllede Sinaj Bjerg i seks Dage, men den syvende Dag råbte HERREN ud fra Skyen til Moses; ");
INSERT INTO dan1931_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","og medens HERRENS Herlighed viste sig for Israelitternes Øjne som en fortærende Ild på Bjergets Top, ");
INSERT INTO dan1931_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","gik Moses ind i Skyen og steg op på Bjerget. Og Moses blev på Bjerget i fyrretyve Dage og fyrretyve Nætter. ");
INSERT INTO dan1931_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Sig til Israelitterne, at de skal bringe mig en Offerydelse; af enhver, som i sit Hjerte føler sig tilskyndet dertil, skal I tage min Offerydelse. ");
INSERT INTO dan1931_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Og Offerydelsen, som I skal tage af dem, skal bestå af Guld, Sølv, Kobber, ");
INSERT INTO dan1931_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","violet og rødt Purpurgarn, karmoisinrødt Garn, Byssus, Gedehår, ");
INSERT INTO dan1931_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","rødfarvede Vædderskind, Tahasjskind*, Akacietræ, { *usikkert Ord, sandsynligvis Søkoskind. } ");
INSERT INTO dan1931_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Olie til Lysestagen, vellugtende Stoffer til Salveolien og Røgelsen, ");
INSERT INTO dan1931_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Sjohamsten og Ædelsten til Indfatning på Efoden og Brystskjoldet. ");
INSERT INTO dan1931_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Og du skal indrette mig en Helligdom, for at jeg kan bo midt iblandt dem. ");
INSERT INTO dan1931_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Du skal indrette Boligen og alt dens Tilbehør nøje efter det Forbillede, jeg vil vise dig. ");
INSERT INTO dan1931_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Du skal lave en Ark af Akacietræ, halvtredje Alen lang, halvanden Alen bred og halvanden Alen høj, ");
INSERT INTO dan1931_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","og overtrække den med purt Guld; indvendig og udvendig skal du overtrække den og sætte en gylden Krans rundt om den; ");
INSERT INTO dan1931_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","og du skal støbe fire Guldringe til den og sætte dem på dens fire Fødder, to Ringe på hver Side at den. ");
INSERT INTO dan1931_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Så skal du lave Bærestænger af Akacietræ og overtrække dem med Guld, ");
INSERT INTO dan1931_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","og du skal stikke Stængerne gennem Ringene på Arkens Sider, for at den kan bæres med dem; ");
INSERT INTO dan1931_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Stængerne skal blive i Ringene, de må ikke tages ud. ");
INSERT INTO dan1931_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Og i Arken skal du nedlægge Vidnesbyrdet, som jeg vil give dig. ");
INSERT INTO dan1931_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Så skal du lave et Sonedække* af purt Guld, halvtredje Alen langt og halvanden Alen bredt; { *Luther oversatte: Nådestolen. 3 Mos. 16, 14-16. Rom. 3, 25. } ");
INSERT INTO dan1931_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","og du skal lave to Keruber af Guld, i drevet Arbejde skal du lave dem, ved begge Ender af Sonedækket. ");
INSERT INTO dan1931_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Den ene Kerub skal du anbringe ved den ene Ende, den anden Kerub ved den anden; du skal lave Keruberne således, at de er i ét med Sonedækket ved begge Ender. ");
INSERT INTO dan1931_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Og Keruberne skal brede deres Vinger i Vejret, således at de dækker over Sonedækket med deres Vinger, og de skal vende Ansigtet mod hinanden; nedad mod Sonedækket skal Kerubernes Ansigter vende. ");
INSERT INTO dan1931_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Og Sonedækket skal du lægge over Arken, men i Arken skal du lægge Vidnesbyrdet, som jeg vil give dig. ");
INSERT INTO dan1931_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Der vil jeg mødes med dig, og fra Sonedækket, fra Pladsen mellem de to Keruber på Vidnesbyrdets Ark, vil jeg meddele dig alle de Bud, jeg har at give dig til Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Fremdeles skal du lave et Bord at Akacietræ, to Alen langt, en Alen bredt og halvanden Alen højt, ");
INSERT INTO dan1931_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","og overtrække det med purt Guld og sætte en gylden Krans rundt om det. ");
INSERT INTO dan1931_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Og du skal sætte en Liste af en Hånds Bredde rundt om det og en gylden Krans rundt om Listen. ");
INSERT INTO dan1931_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Så skal du lave fire Guldringe og sætte dem på de fire Hjørner ved dets fire Ben; ");
INSERT INTO dan1931_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","lige ved Listen skal Ringene sidde til at stikke Bærestængerne i, så at man kan bære Bordet. ");
INSERT INTO dan1931_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Og du skal lave Bærestængerne af Akacietræ og overtrække dem med Guld, og med dem skal Bordet bæres. ");
INSERT INTO dan1931_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Og du skal lave de dertil hørende Fade og Kander, Krukker og Skåle til at udgyde Drikoffer med; af purt Guld skal du lave dem. ");
INSERT INTO dan1931_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","På Bordet skal du altid have Skuebrød liggende for mit Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Fremdeles skal du lave en Lysestage af purt Guld, i drevet Arbejde skal Lysestagen, dens Fod og selve Stagen, laves, således af dens Blomster med Bægere og Kroner er i ét med den. ");
INSERT INTO dan1931_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Seks Arme skal udgå fra Lysestagens Side, tre fra den ene og tre fra den anden Side. ");
INSERT INTO dan1931_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","På hver af Armene, der udgår fra Lysestagen, skal der være tre mandelblomstlignende Blomster med Bægere og Kroner, ");
INSERT INTO dan1931_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","men på selve Stagen skal der være fire mandelblomstlignende Blomster med Bægere og Kroner, ");
INSERT INTO dan1931_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","et Bæger under hvert af de tre Par Arme, der udgår fra Lysestagen. ");
INSERT INTO dan1931_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Bægrene og Armene skal være i ét med den, så at det hele udgør ét drevet Arbejde af purt Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Og du skal lave syv Lamper til den og sætte disse Lamper på den, for at de kan lyse Pladsen foran op. ");
INSERT INTO dan1931_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Dens Lampesakse og Bakker skal være af purt Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Der skal bruges en Talent purt Guld til den og til alt dette Tilbehør. ");
INSERT INTO dan1931_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Se til, at du udfører det efter det Forbillede, som vises dig på Bjerget. ");
INSERT INTO dan1931_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Boligen skal du lave af ti Tæpper af tvundet Byssus, violet og rødt Purpurgarn og karmoisinrødt Garn med Keruber på i Kunstvævning. ");
INSERT INTO dan1931_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Hvert Tæppe skal være otte og tyve Alen langt og fire Alen bredt; alle Tæpperne skal have samme Mål. ");
INSERT INTO dan1931_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Tæpperne skal sys sammen, fem og fem. ");
INSERT INTO dan1931_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","I Kanten af det ene Tæppe, det yderste i det ene sammensyede Stykke, skal du sætte Løkker af violet Purpurgarn, og ligeledes skal du sætte Løkker i Kanten af det yderste Tæppe i det andet sammensyede Stykke; ");
INSERT INTO dan1931_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","du skal sætte halvtredsindstyve Løkker på det ene Tæppe og halvtredsindstyve Løkker i Kanten af det tilsvarende Tæppe i det andet sammensyede Stykke, Løkke lige over for Løkke. ");
INSERT INTO dan1931_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Og du skal lave halvtredsindstyve Guldkroge til at forbinde Tæpperne med hinanden, så at Boligen udgør et Hele. ");
INSERT INTO dan1931_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Fremdeles skal du lave Tæpper af Gedehår til et Teltdække uden om Boligen, og her skal du lave elleve Tæpper, ");
INSERT INTO dan1931_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","hvert Tæppe skal være tredive Alen langt og fire Alen bredt; alle Tæpperne skal have samme Mål. ");
INSERT INTO dan1931_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Og du skal sy de fem af Tæpperne sammen for sig og de seks for sig; det sjette Tæppe, det, der kommer til at ligge over Teltets Forside, skal du lægge dobbelt. ");
INSERT INTO dan1931_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Og du skal sætte halvtredsindstyve Løkker i Kanten af det yderste Tæppe i det ene sammensyede Stykke og halvtredsindstyve Løkker i Kanten af det tilsvarende Tæppe i det andet sammensyede Stykke. ");
INSERT INTO dan1931_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Og du skal lave halvtredsindstyve Kobberkroge og stikke dem i Løkkerne og sammenføje Teltdækket, så de udgør et Hele. ");
INSERT INTO dan1931_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Men hvad angår det overskydende af Teltdækkets Tæpper, skal Halvdelen deraf hænge ned over Boligens Bagside, ");
INSERT INTO dan1931_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","og den overskydende Alen på begge Sider af Telttæppernes Længder skal hænge ned over begge Boligens Sider for at dække den. ");
INSERT INTO dan1931_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Fremdeles skal du lave et Dække over Teltdækket af rødfarvede Vædderskind og derover endnu et Dække af Tahasjskind. ");
INSERT INTO dan1931_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Fremdeles skal du lave Brædderne til Boligen af Akacietræ til at stå op, ");
INSERT INTO dan1931_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","hvert Bræt ti Alen højt og halvanden Alen bredt. ");
INSERT INTO dan1931_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","På hvert Bræt skal der være to indbyrdes forbundne Tapper; således skal du indrette det ved alle Boligens Brædder. ");
INSERT INTO dan1931_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Af Brædderne, som du skal lave til Boligen, skal tyve være til Sydsiden, ");
INSERT INTO dan1931_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","og til de tyve Brædder skal du lave fyrretyve Fodstykker af Sølv, to Fodstykker til de to Tapper på hvert Bræt. ");
INSERT INTO dan1931_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Andre tyve Brædder skal laves til Boligens anden Side, som vender mod Nord, ");
INSERT INTO dan1931_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","med fyrretyve Fodstykker af Sølv, to Fodstykker til hvert Bræt. ");
INSERT INTO dan1931_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Og til Bagsiden, der vender mod Vest, skal du lave seks Brædder. ");
INSERT INTO dan1931_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Til Boligens Baghjørner skal du lave to Brædder, ");
INSERT INTO dan1931_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","som skal bestå af to Stykker forneden og ligeledes af to Stykker foroven, indtil den første Ring; således skal de begge indrettes for at danne de to Hjørner. ");
INSERT INTO dan1931_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Altså bliver der til Bagsiden otte Brædder med tilhørende seksten Fodstykker af Sølv, to til hvert Bræt. ");
INSERT INTO dan1931_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Og du skal lave Tværstænger af Akacietræ, fem til de Brædder, der danner Boligens ene Side, ");
INSERT INTO dan1931_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","fem til de Brædder, der danner Boligens anden Side, og fem til de Brædder, der danner Boligens Bagside mod Vest; ");
INSERT INTO dan1931_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","den mellemste Tværstang midt på Brædderne skal nå fra den ene Ende af Væggen til den anden. ");
INSERT INTO dan1931_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Du skal overtrække Brædderne med Guld, og deres Ringe, som Tværstængerne skal stikkes i, skal du lave af Guld, og Tværstængerne skal du overtrække med Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Og du skal rejse Boligen på den Måde, som vises dig på Bjerget. ");
INSERT INTO dan1931_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Fremdeles skal du lave et Forhæng af violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus; det skal laves i Kunstvævning med Keruber på. ");
INSERT INTO dan1931_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Du skal hænge det på fire Piller af Akacietræ, overtrukne med Guld og med Knager af Guld, på fire Fodstykker af Sølv; ");
INSERT INTO dan1931_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","og du skal hænge Forhænget under Krogene* og bringe Vidnesbyrdets Ark ind i Rummet bag ved Forhænget, og Forhænget skal danne eder en Skillevæg mellem det Hellige og det Allerhelligste. { *dvs. de v. 6 omtalte. } ");
INSERT INTO dan1931_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Og Sonedækket skal du lægge over Vidnesbyrdets Ark i det Allerhelligste. ");
INSERT INTO dan1931_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Men Bordet skal du stille uden for Forhænget, og Lysestagen over for Bordet ved Boligens søndre Væg; Bordet skal du altså stille ved den nordre Væg. ");
INSERT INTO dan1931_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Fremdeles skal du lave et Forhæng til Teltets indgang af violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus i broget Vævning; ");
INSERT INTO dan1931_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","og til Forhænget skal du lave fem Piller af Akacietræ, som du skal overtrække med Guld, med Knager af Guld, og du skal støbe fem Fodstykker dertil af Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Fremdeles skal du lave Alteret af Akacietræ, fem Alen langt og fem Alen bredt, firkantet skal Alteret være, og tre Alen højt. ");
INSERT INTO dan1931_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Du skal lave Horn til dets fire Hjørner, således at de er i ét dermed, overtrække det med Kobber ");
INSERT INTO dan1931_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","og lave Kar dertil, for at Asken kan fjernes, ligeledes de dertil hørende Skovle, Skåle, Gafler og Pander; alt dets Tilbehør skal du lave af Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Du skal omgive det med et flettet Kobbergitter, og du skal sætte fire Kobberringe på Fletværket. på dets fire Hjørner. ");
INSERT INTO dan1931_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Og du skal sætte Gitteret neden under Alterets Liste, således at Fletværket når op til Alterets halve Højde. ");
INSERT INTO dan1931_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Fremdeles skal du lave Bærestænger til Alteret, Stænger af Akacietræ, og overtrække dem med Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Og Stængerne skal stikkes gennem Ringene, så at de sidder langs Alterets to Sider, når det bæres. ");
INSERT INTO dan1931_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Du skal lave det hult af Brædder; som det vises dig på Bjerget, skal du lave det. ");
INSERT INTO dan1931_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Boligens Forgård skal du indrette således: På Sydsiden skal der være et Forgårdsomhæng af tvundet Byssus, hundrede Alen langt på denne ene Side, ");
INSERT INTO dan1931_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","med tyve Piller og tyve Fodstykker af Kobber og med Knager og Bånd af Sølv til Pillerne. ");
INSERT INTO dan1931_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Og på samme Måde skal der på den nordre Langside være et Omhæng, hundrede Alen langt, med tyve Piller og tyve Fodstykker af Kobber og med Knager og Bånd af Sølv til Pillerne. ");
INSERT INTO dan1931_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","På Forgårdens Bredside mod Vest skal der være et Omhæng, halvtredsindstyve Alen langt, med ti Piller og ti Fodstykker, ");
INSERT INTO dan1931_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","og Forgårdens Bredside mod Øst skal være halvtredsindstyve Alen lang. ");
INSERT INTO dan1931_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","På den ene Side deraf skal der være femten Alen Omhæng med tre Piller og tre Fodstykker, ");
INSERT INTO dan1931_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","på den anden Side ligeledes femten Alen Omhæng med tre Piller og tre Fodstykker. ");
INSERT INTO dan1931_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Forgårdens Indgang skal have et Forhæng på tyve Alen af violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus i broget Vævning med fire Piller og fire Fodstykker. ");
INSERT INTO dan1931_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Alle Forgårdens Piller rundt omkring skal have Bånd af Sølv, Knager af Sølv og Fodstykker af Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Omhænget om Forgården skal være hundrede Alen på hver Langside, halvtredsindstyve Alen på hver Bredside og fem Alen højt; det skal være af tvundet Byssus, og Fodstykkerne skal være af Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Alle Redskaber, der bruges ved Arbejdet på Boligen, alle dens Pæle og alle Forgårdens Pæle skal være af Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Fremdeles skal du pålægge Israelitterne at skaffe dig ren Olivenolie af knuste Frugter til Lysestagen, og der skal stadig sættes Lamper på. ");
INSERT INTO dan1931_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","I Åbenbaringsteltet uden for Forhænget, der hænger foran Vidnesbyrdet, skal Aron og hans Sønner gøre den i Stand, at den kan brænde fra Aften til Morgen for HERRENS Åsyn. Det skal være en evig gyldig Bestemmelse, der skal påhvile Israelitterne fra Slægt til Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Du skal lade din Broder Aron og hans Sønner tillige med ham træde frem af Israelitternes Midte og komme hen til dig, for at de kan gøre Præstetjeneste for mig, Aron og Arons Sønner, Nadab, Abihu, Eleazar og Itamar. ");
INSERT INTO dan1931_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Og du skal tilvirke din Broder Aron hellige Klæder til Ære og Pryd, ");
INSERT INTO dan1931_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","og du skal byde alle kunstforstandige Mænd, hvem jeg har fyldt med Kunstfærdigheds Ånd, at tilvirke Aron Klæder, for at han kan helliges til at gøre Præstetjeneste for mig. ");
INSERT INTO dan1931_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Klæderne, som de skal tilvirke, er følgende: Brystskjold, Efod, Kåbe, Kjortel af mønstret Stof, Hovedklæde og Bælte. De skal tilvirke din Broder Aron og hans Sønner hellige Klæder, for at de kan gøre Præstetjeneste for mig, ");
INSERT INTO dan1931_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","og dertil skal de bruge Guldtråd, violet og rødt Purpurgarn, Karmoisinrødt Garn og Byssus. ");
INSERT INTO dan1931_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Efoden skal du tilvirke af Guldtråd, violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus i Kunstvævning. ");
INSERT INTO dan1931_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Den skal have to Skulderstykker, der skal være til at hæfte på; den skal hæftes sammen ved begge Hjørner. ");
INSERT INTO dan1931_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Og dens Bælte, som skal bruges, når den tages på, skal være af samme Arbejde og i ét med den; det skal være af Guldtråd, violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus. ");
INSERT INTO dan1931_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Så skal du tage de to Sjohamsten og gravere Israels Sønners Navne i dem, ");
INSERT INTO dan1931_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","seks af Navnene på den ene Sten og de andre seks på den anden efter Aldersfølge; ");
INSERT INTO dan1931_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","med Stenskærerarbejde, som ved Gravering af Signeter, skal du indgravere Israels Sønners Navne i de 14 Sten, og du skal indfatte dem i Guldfletværk. ");
INSERT INTO dan1931_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Disse to Sten skal du fæste på Efodens Skulderstykker, for at Stenene kan bringe Israels Sønner i Minde*, og Aron skal bære deres Navne for HERRENS Åsyn på sine Skuldre for at bringe dem i Minde. { *hos Herren. } ");
INSERT INTO dan1931_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Og du skal tilvirke Fletværk af Guld ");
INSERT INTO dan1931_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","og to Kæder af purt Guld; du skal lave dem i snoet Arbejde, som når man snor Reb, og sætte disse snoede Kæder på Fletværket. ");
INSERT INTO dan1931_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Fremdeles skal du tilvirke Retskendelsens Brystskjold i Kunstvævning på samme Måde som Efoden; af Guldtråd, violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus skal du lave det; ");
INSERT INTO dan1931_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","det skal være firkantet og lægges dobbelt, et Spand langt og et Spand bredt, ");
INSERT INTO dan1931_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Og du skal udstyre det med en Besætning af Sten, fire Rækker Sten: Karneol, Topas og Smaragd i den første Række, ");
INSERT INTO dan1931_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Rubin, Safir og Jaspis i den anden, ");
INSERT INTO dan1931_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Hyacint, Agat og Ametyst i den tredje, ");
INSERT INTO dan1931_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Krysolit, Sjoham og Onyks i den fjerde; og de skal omgives med Guldfletværk i deres Indfatninger. ");
INSERT INTO dan1931_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Der skal være tolv Sten, svarende til Israels Sønners Navne, en for hvert Navn; det skal være graveret Arbejde som Signeter, således at hver Sten bærer Navnet på en af de tolv Stammer. ");
INSERT INTO dan1931_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Til Brystskjoldet skal du lave snoede Kæder af purt Guld, snoet Arbejde, som når man snor Reb. ");
INSERT INTO dan1931_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Til Brystskjoldet skal du lave to Guldringe og sætte disse to Ringe på Brystskjoldets øverste Hjørner, ");
INSERT INTO dan1931_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","og de to Guldsnore skal du knytte i de to Ringe på Brystskjoldets Hjørner; ");
INSERT INTO dan1931_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Snorenes anden Ende skal du anbringe i det Fletværker og fæste dem på Forsiden af Efodens Skulderstykke. ");
INSERT INTO dan1931_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Og du skal lave to andre Guldringe og sætte dem på Brystskjoldets to andre Hjørner på den indre, mod Efoden vendende Rand. ");
INSERT INTO dan1931_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Og du skal lave endnu to Guldringe og fæste dem på Efodens to Skulderstykker forneden på Forsiden, hvor den er hæftet sammen med Skulderstykkerne, oven over Efodens Bælte; ");
INSERT INTO dan1931_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","og man skal med Ringene binde Brystskjoldet fast til Efodens Ringe ved Hjælp af en violet Purpursnor, så at det kommer til at sidde oven over Efodens Bælte og ikke løsner sig fra Efoden. ");
INSERT INTO dan1931_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aron skal således stedse bære Israels Sønners Navne på Retskendelsens Brystskjold på sit Hjerte, når han går ind i Helligdommen, for at bringe dem i Minde for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Og i Retskendelsens Brystskjold skal du lægge Urim og Tummim, så at Aron bærer dem på sit Hjerte, når han går ind for HERRENS Åsyn, og Aron skal stedse bære Israelitternes Retskendelse på sit Hjerte for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Fremdeles skal du tilvirke Kåben, som hører til Efoden, helt og holdent af violet Purpur. ");
INSERT INTO dan1931_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Midt på skal den have en Halsåbning ligesom Halsåbningen på en Panserskjorte, omgivet af en Linning i vævet Arbejde, for at den ikke skal rives itu; ");
INSERT INTO dan1931_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","og langs dens nederste Kant skal du sy Granatæbler af violet og rødt Purpurgarn og karmoisinrødt Garn og mellem dem Guldbjælder hele Vejen rundt, ");
INSERT INTO dan1931_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","så at Guldbjælder og Granatæbler skifter hele Vejen rundt langs Kåbens nederste Kant. ");
INSERT INTO dan1931_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aron skal bære den, når han gør Tjeneste, så at det kan høres, når han går ind i Helligdommen for HERRENS Åsyn, og når han går ud derfra, at han ikke skal dø, ");
INSERT INTO dan1931_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Fremdeles skal du lave en Pandeplade af purt Guld, og i den skal du gravere, som når man graverer Signeter: “Helliget HERREN.” ");
INSERT INTO dan1931_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Den skal du fastgøre med en violet Purpursnor, og den skal sidde på Hovedklædet, foran på Hovedklædet skal den sidde. ");
INSERT INTO dan1931_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aron skal bære den på sin Pande, for at han kan tage de Synder på sig, som klæder ved de hellige Gaver, Israelitterne frembærer, ved alle de hellige Gaver, de bringer; og Aron skal stedse have den på sin Pande for at vinde dem HERRENS Velbehag. ");
INSERT INTO dan1931_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Kjortelen skal du væve i mønstret Vævning af Byssus. Og du skal tilvirke et Hovedklæde af Byssus og et Bælte i broget Vævning. ");
INSERT INTO dan1931_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Også til Arons Sønner skal du tilvirke Kjortler, og du skal tilvirke Bælter til dem og Huer til Ære og Pryd. ");
INSERT INTO dan1931_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Og du skal iføre din Broder Aron og hans Sønner dem, og du skal salve dem, indsætte dem og hellige dem til at gøre Præstetjeneste for mig. ");
INSERT INTO dan1931_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Tillige skal du tilvirke Linnedbenklæder til dem til at skjule deres Blusel, og de skal nå fra Hoften ned på Lårene. ");
INSERT INTO dan1931_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Dem skal Aron og hans Sønner bære, når de går ind i Åbenbaringsteltet eller træder frem til Alteret for at gøre Tjeneste i Helligdommen, at de ikke skal pådrage sig Skyld og lide Døden. En evig gyldig Anordning skal det være for ham og hans Afkom efter ham. ");
INSERT INTO dan1931_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Således skal du bære dig ad med dem, når du helliger dem til at gøre Præstetjeneste for mig: Tag en ung Tyr, to lydefri Vædre, ");
INSERT INTO dan1931_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","usyrede Brød, usyrede Kager, rørte i Olie, og usyrede Fladbrød, smurte med Olie; af fint Hvedemel skal du bage dem. ");
INSERT INTO dan1931_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Læg dem så i én Kurv og bær dem frem i Kurven sammen med Tyren og de to Vædre. ");
INSERT INTO dan1931_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Lad derpå Aron og hans Sønner træde hen til Åbenbaringsteltets Indgang og tvæt dem med Vand. ");
INSERT INTO dan1931_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Tag så Klæderne og ifør Aron Kjortelen, Efodkåben, Efoden og Brystskjoldet og bind Efoden fast på ham med Bæltet. ");
INSERT INTO dan1931_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Læg Hovedklædet om hans Hoved og fæst det hellige Diadem på Hovedklædet. ");
INSERT INTO dan1931_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tag så Salveolien og udgyd den på hans Hoved og salv ham. ");
INSERT INTO dan1931_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Lad dernæst hans Sønner træde frem og ifør dem Kjortler, ");
INSERT INTO dan1931_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","omgjord dem med Bælter og bind Huerne på dem. Og Præsteværdigheden skal tilhøre dem med evig Ret. Så skal du indsætte Aron og hans Sønner. ");
INSERT INTO dan1931_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Før Tyren frem foran Åbenbaringsteltet, og Aron og hans Sønner skal lægge deres Hænder på Tyrens Hoved. ");
INSERT INTO dan1931_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Slagt så Tyren for HERRENS Åsyn ved Indgangen til Åbenbaringsteltet ");
INSERT INTO dan1931_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","og tag noget af Tyrens Blod og stryg det på Alterets Horn med din Finger og udgyd Resten af Blodet ved Alterets Fod. ");
INSERT INTO dan1931_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tag så alt Fedtet på Indvoldene, Leverlappen og begge Nyrerne med Fedtet på dem og bring det som Røgoffer på Alteret; ");
INSERT INTO dan1931_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","men Tyrens Kød, dens Hud og dens Skarn skal du brænde uden for Lejren. Det er et Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Derpå skal du tage den ene Væder, og Aron og hans Sønner skal lægge deres Hænder på dens Hoved. ");
INSERT INTO dan1931_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Slagt så Vædderen, tag dens Blod og spræng det rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Skær så Vædderen i Stykker, tvæt dens Indvolde og Skinneben, læg dem på Stykkerne og Hovedet ");
INSERT INTO dan1931_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","og bring så hele Vædderen som Røgoffer på Alteret. Det er et Brændoffer for HERREN; en liflig Duft, et Ildoffer for HERREN er det. ");
INSERT INTO dan1931_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Derpå skal du tage den anden Væder, og Aron og hans Sønner skal lægge deres Hænder på dens Hoved. ");
INSERT INTO dan1931_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Slagt så Vædderen, tag noget af dens Blod og stryg det på Arons og hans Sønners højre Øreflip og på deres højre Tommelfinger og højre Tommeltå og spræng Resten af Blodet rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Tag så noget af Blodet på Alteret og af Salveolien og stænk det på Aron og hans Klæder, ligeledes på hans Sønner og deres Klæder. så bliver han hellig, han selv og hans Klæder og ligeledes hans Sønner og deres klæder. ");
INSERT INTO dan1931_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Derpå skal du tage Fedtet af Vædderen, Fedthalen, Fedtet på Indvoldene, Leverlappen, begge Nyrerne med Fedtet på dem, dertil den højre Kølle, thi det er en Indsættelsesvædder, ");
INSERT INTO dan1931_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","og en Skive Brød, en Oliebrødkage og et Fladbrød af Kurven med de usyrede Brød, som står for HERRENS Åsyn, ");
INSERT INTO dan1931_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","og lægge det alt sammen på Arons og hans Sønners Hænder og lade dem udføre Svingningen dermed for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Tag det så igen fra dem og bring det som Røgoffer på Alteret oven på Brændofferet til en liflig Duft for HERRENS Åsyn, et Ildoffer er det for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Tag derpå Brystet af Arons Indsættelsesvædder og udfør Svingningen dermed for HERRENS Åsyn: det skal være din Del. ");
INSERT INTO dan1931_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Således skal du hellige Svingningsbrystet og Offerydelseskøllen, det, hvormed Svingningen udføres, og det, som ydes af Arons og hans Sønners Indsættelsesvædder. ");
INSERT INTO dan1931_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Og det skal tilfalde Aron og hans Sønner som en Rettighed, de har Krav på fra Israelitternes Side til evig Tid; thi det er en Offerydelse, og som Offerydelse skal Israelitterne give det af deres Takofre, som deres Offerydelse til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Arons hellige Klæder skal tilfalde hans Sønner efter ham, for at de kan salves og indsættes i dem. ");
INSERT INTO dan1931_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","I syv Dage skal de bæres af den af hans Sønner, som bliver Præst i hans Sted, den, som skal gå ind i Åbenbaringsteltet for at gøre Tjeneste i Helligdommen. ");
INSERT INTO dan1931_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Så skal du tage Indsættelsesvædderen og koge dens Kød på et helligt Sted; ");
INSERT INTO dan1931_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","og Aron og hans Sønner skal spise Vædderens Kød og Brødet i Kurven ved Indgangen til Åbenbaringsteltet; ");
INSERT INTO dan1931_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","de skal spise de Stykker, hvorved der skaffes Soning ved deres Indsættelse og Indvielse, og ingen Lægmand må spise deraf, thi det er helligt. ");
INSERT INTO dan1931_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Og dersom der bliver noget af Indsættelseskødet eller Brødet tilovers til næste Morgen, da skal du opbrænde det tiloversblevne; spises må det ikke, thi det er helligt. ");
INSERT INTO dan1931_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Således skal du forholde dig over for Aron og hans Sønner, ganske som jeg har pålagt dig. Syv Dage skal du foretage Indsættelsen; ");
INSERT INTO dan1931_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","daglig skal du ofre en Syndoffertyr til Soning og rense Alteret for Synd ved at fuldbyrde Soningen på det, og du skal salve det for at hellige det. ");
INSERT INTO dan1931_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Syv dage skal du fuldbyrde Soningen på Alteret og hellige det; således bliver Alteret højhelligt; enhver, der kommer i Berøring med Alteret, bliver hellig.* { *hjemfalder til Gud } ");
INSERT INTO dan1931_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Hvad du skal ofre på Alteret, er følgende: Hver Dag to årgamle Lam som stadigt Offer. ");
INSERT INTO dan1931_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Det ene Lam skal du ofre om Morgenen og det andet ved Aftenstid. ");
INSERT INTO dan1931_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Sammen med det første Lam skal du bringe en Tiendedel Efa fint Hvedemel, rørt i en Fjerdedel Hin Olie af knuste Oliven, og et Drikoffer af en Fjerdedel Hin Vin. ");
INSERT INTO dan1931_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Og det andet Lam skal du ofre ved Aftenstid; sammen med det skal du ofre et Afgrødeoffer og et Drikoffer som om Morgenen til en liflig Duft, et Ildoffer for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Det skal være et stadigt Brændoffer, som I skal bringe, Slægt efter Slægt, ved Indgangen til Åbenbaringsteltet for HERRENS Åsyn, hvor jeg vil åbenbare mig for dig for at tale til dig, ");
INSERT INTO dan1931_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","og hvor jeg vil åbenbare mig for Israels Børn, og det skal helliges ved min Herlighed. ");
INSERT INTO dan1931_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Jeg vil hellige Åbenbaringsteltet og Alteret, og Aron og hans Sønner vil jeg hellige til at gøre Præstetjeneste for mig. ");
INSERT INTO dan1931_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Og jeg vil bo midt iblandt Israels Børn og være deres Gud; ");
INSERT INTO dan1931_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","og de skal kende, at jeg HERREN er deres Gud, som førte dem ud af Ægypten for at bo midt iblandt dem, jeg HERREN deres Gud! ");
INSERT INTO dan1931_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Fremdeles skal du lave et Alter til at brænde Røgelse på: af Akacietræ skal du lave det, ");
INSERT INTO dan1931_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","en Alen langt og en Alen bredt, firkantet skal det være, og to Alen højt, og dets Horn skal være i ét med det. ");
INSERT INTO dan1931_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Du skal overtrække det med purt Guld, både Pladen og Siderne hele Vejen rundt og Hornene, og sætte en Guldkrans rundt om; ");
INSERT INTO dan1931_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","og du skal sætte to Guldringe under Kransen på begge Sider, på begge Sidestykkerne skal du sætte dem til at stikke Bærestænger i, for at det kan bæres med dem; ");
INSERT INTO dan1931_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","og Bærestængerne skal du lave af Akacietræ og overtrække med Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Derpå skal du opstille det foran Forhænget, der hænger foran Vidnesbyrdets Ark, foran Sonedækket oven over Vidnesbyrdet der, hvor jeg vil åbenbare mig for dig. ");
INSERT INTO dan1931_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","På det skal Aron brænde vellugtende Røgelse; hver Morgen, når han gør Lamperne i Stand, skal han antænde den. ");
INSERT INTO dan1931_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Og når Aron sætter Lamperne på Lysestagen ved Aftenstid, skal han ligeledes antænde den; det skal være et stadigt Røgelseoffer for HERRENS Åsyn fra Slægt til Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","I må ikke ofre et lovstridigt Røgelseoffer derpå, ej heller Brændofre eller Afgrødeofre, lige så lidt som I må udgyde Drikofre derpå. ");
INSERT INTO dan1931_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Men én Gang om Året skal Aron skaffe Soning på dets Horn; med noget af Forsoningssyndofferets Blod skal han én Gang om Året skaffe Soning på det, Slægt efter Slægt. Det er højhelligt for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Når du holder Mandtal over Israelitterne, skal enhver, som mønstres, ved Mønstringen give HERREN Sonepenge for sit Liv, at ingen Ulykke skal ramme dem i Anledning af Mønstringen. ");
INSERT INTO dan1931_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Enhver, der må underkaste sig Mønstringen, skal udrede en halv Sekel i hellig Mønt*, tyve Gera på en Sekel, en halv Sekel som Offerydelse til HERREN. { *se til 3 Mos. 5, 15. } ");
INSERT INTO dan1931_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Enhver, der må underkaste sig Mønstringen, fra Tyveårsalderen og opefter, skal udrede HERRENS Offerydelse. ");
INSERT INTO dan1931_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","hen rige må ikke give mere, den fattige ikke mindre end en halv Sekel, når de bringer HERRENS Offerydelse til Soning for deres Sjæle. ");
INSERT INTO dan1931_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Og du skal tage Sonepengene af Israelitterne og bruge dem til Tjenesten ved Åbenbaringsteltet. og de skal tjene til at bringe Israelitterne i Minde for HERRENS Åsyn, til Soning for eders Sjæle. ");
INSERT INTO dan1931_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Du skal lave en Vandkumme med Fodstykke af Kobber til at tvætte sig i op opstille den mellem Åbenbaringsteltet og Alteret og hælde Vand i den, ");
INSERT INTO dan1931_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","for at Aron og hans Sønner kan tvætte deres Hænder og Fødder deri. ");
INSERT INTO dan1931_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Når de går ind i Åbenbaringsteltet, skal de tvætte sig med Vand for ikke at dø; ligeledes når de træder hen til Alteret for at gøre Tjeneste og brænde Ildofre for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","De skal tvætte deres Hænder og Fødder for ikke at dø. Det skal være en evig Anordning for ham og hans Afkom fra Slægt til Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Du skal tage dig vellugtende Stoffer af den bedste Slags, 500 Sekel ædel Myrra, halvt så meget. 250 Sekel, vellugtende Kanelbark, 250 Sekel vellugtende Kalmus ");
INSERT INTO dan1931_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","og 500 Sekel Kassia, efter hellig Vægt, og en Hin Olivenolie. ");
INSERT INTO dan1931_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Deraf skal du tilberede en hellig Salveolie, en krydret Blanding, som Salveblanderne laver den; en hellig Salveolie skal det være. ");
INSERT INTO dan1931_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Med den skal du salve Åbenbaringsteltet, Vidnesbyrdets Ark, ");
INSERT INTO dan1931_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Bordet med alt dets Tilbehør, Lysestagen med dens Tilbehør, Røgelsealteret, ");
INSERT INTO dan1931_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Brændofferalteret med alt dets Tilbehør og Vandkummen med dens Fodstykke, ");
INSERT INTO dan1931_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Således skal du hellige dem, så de bliver højhellige. Enhver, der kommer i Berøring med dem, bliver hellig.* { *se til 2 Mos. 29, 37. } ");
INSERT INTO dan1931_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ligeledes skal du salve Aron og hans Sønner og hellige dem til at gøre Præstetjeneste for mig. ");
INSERT INTO dan1931_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Men til Israelitterne skal du sige således: Dette skal være mig en hellig Salveolie fra Slægt til Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Den må ikke udgydes på noget Menneskes Legeme, og i denne Blanding må I ikke tilberede lignende Salve til eget Brug, hellig er den, og hellig skal den være eder. ");
INSERT INTO dan1931_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Den, der tilbereder lignende Salve eller anvender den på en Lægmand, skal udryddes af sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","HERREN talede fremdeles til Moses og sagde: Tag dig Røgelseoffer, Stakte, Onyksmusling, Galbanum og ren Virak, lige meget af hvert, ");
INSERT INTO dan1931_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","og tilbered deraf en krydret Røgelse, som Salveblanderne laver den, saltet, ren, til hellig Brug. ");
INSERT INTO dan1931_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Deraf skal du støde en Del til Pulver, og noget deraf skal du lægge foran Vidnesbyrdet i Åbenbaringsteltet, hvor jeg vil åbenbare mig for dig. Det skal være eder højhelligt. ");
INSERT INTO dan1931_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Den Røgelse, du tilbereder i denne Blanding, må I ikke tilberede til eget Brug. Hellig skal den være dig for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Den, der tilbereder lignende Røgelse for at nyde dens Duft, skal udryddes af sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Se, jeg har kaldet Bezal'el, en Søn af Hurs Søn Uri, af Judas Stamme ");
INSERT INTO dan1931_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","og fyldt ham med Guds Ånd, med Kunstsnilde, Kløgt og Indsigt i alskens Arbejde ");
INSERT INTO dan1931_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","til at udtænke Kunstværker og til at arbejde i Guld, Sølv og Kobber ");
INSERT INTO dan1931_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","og med Udskæring af Sten til Indfatning og med Træskærerarbejde, kort sagt til at udføre alskens Arbejde. ");
INSERT INTO dan1931_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Og se, jeg har givet ham Oholiab, Ahisamaks Søn, af Dans Stamme til Medhjælper, og alle kunstforstandige Mænds Hjerte har jeg udrustet med Kunstsnilde, for at de kan udføre alt, hvad jeg har pålagt dig, ");
INSERT INTO dan1931_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Åbenbaringsteltet, Vidnesbyrdets Ark, Sonedækket derpå og alt Teltets Tilbehør, ");
INSERT INTO dan1931_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Bordet med dets Tilbehør, Lysestagen af purt Guld med alt dens Tilbehør, Røgelsealteret, ");
INSERT INTO dan1931_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Brændofferalteret med alt dets Tilbehør og Vandkummen med dens Fodstykke, ");
INSERT INTO dan1931_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Pragtklæderne, de hellige Klæder til Præsten Aron og hans Sønners Klædet til Brug ved Præstetjenesten, ");
INSERT INTO dan1931_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Salveolien og den vellugtende Røgelse til Helligdommen. Ganske som jeg har pålagt dig, skal de udføre det. ");
INSERT INTO dan1931_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Du skal tale til Israelitterne og sige: Fremfor alt skal I holde mine Sabbater, thi Sabbaten er et Tegn mellem mig og eder fra Slægt til Slægt, for at I skal kende, at jeg HERREN er den, der helliger eder. ");
INSERT INTO dan1931_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","I skal holde Sabbaten, thi den skal være eder hellig; den, som vanhelliger den, skal lide Døden, ja enhver, som udfører noget Arbejde på den, det Menneske skal udryddes af sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","I seks Dage må der arbejdes, men på den syvende Dag skal I holde en fuldkommen Hviledag, helliget HERREN; enhver, som udfører Arbejde på Sabbatsdagen, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israelitterne skal holde Sabbaten, så at de fejrer Sabbaten fra Slægt til Slægt som en evig gyldig Pagt: ");
INSERT INTO dan1931_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Den skal være et Tegn til alle Tider mellem mig og Israelitterne. Thi i seks Dage gjorde HERREN Himmelen og Jorden, men på den syvende hvilede han og vederkvægede sig. ");
INSERT INTO dan1931_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Da han nu var færdig med at tale til Moses på Sinaj Bjerg, overgav han ham Vidnesbyrdets to Tavler, Stentavler, der var beskrevet med Guds Finger. ");
INSERT INTO dan1931_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Men da Folket så, at Moses tøvede med at komme ned fra Bjerget, samlede det sig om Aron, og de sagde til ham: “Kom og lav os en Gud, som kan drage foran os, thi vi ved ikke, hvad der er blevet af denne Moses, der førte os ud af Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Da sagde Aron til dem: “Riv de Guldringe af, som eders Hustruer, Sønner og Døtre har i Ørene, og bring mig dem!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Så rev hele Folket deres Guldørenringe af og bragte dem til Aron. ");
INSERT INTO dan1931_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Og han modtog dem af deres Hånd, formede Guldet med en Mejsel og lavede en støbt Tyrekalv deraf. Da sagde de: “Her, Israel, er din Gud, som førte dig ud af Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Og da Aron så det, byggede han et Alter for den, og Aron lod kundgøre: “I Morgen er det Højtid for HERREN!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Tidligt næste Morgen ofrede de så Brændofre og bragte Takofre og Folket satte sig til at spise og drikke, og derpå stod de op for at lege. ");
INSERT INTO dan1931_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Da sagde HERREN til Moses: “Skynd dig og stig ned, thi dit Folk, som du førte ud af Ægypten, har handlet ilde; ");
INSERT INTO dan1931_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","hastigt veg de bort fra den Vej jeg bød dem at vandre; de har lavet sig en støbt Tyrekalv og tilbedt den og ofret til den med de Ord: Her, Israel, er din Gud, som førte dig ud af Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Og HERREN sagde til Moses: “Jeg har iagttaget dette Folk og set, at det er et halsstarrigt Folk. ");
INSERT INTO dan1931_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Lad mig nu råde, at min Vrede kan blusse op imod dem så vil jeg tilintetgøre dem; men dig vil jeg gøre til et stort Folk!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Men Moses bønfaldt HERREN sin Gud og sagde: “Hvorfor HERRE skal din Vrede blusse op mod dit Folk, som du førte ud af Ægypten med vældig Kraft og stærk Hånd? ");
INSERT INTO dan1931_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Hvorfor skal Ægypterne kunne sige: I ond Hensigt førte han dem ud, for at slå dem ihjel ude mellem Bjergene og udrydde dem af Jorden? Lad din Vredes Glød høre op, og anger den Ulykke, du vilde gøre dit Folk! ");
INSERT INTO dan1931_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kom Abraham, Isak og Israel i Hu, dine Tjenere, hvem du tilsvor ved dig selv: Jeg vil gøre eders Afkom talrigt som Himmelens Stjerner, og jeg vil give eders Afkom hele det Land, hvorom jeg har talet, og de skal eje det evindelig!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Da angrede HERREN den Ulykke han havde truet med at gøre sit Folk. ");
INSERT INTO dan1931_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Derpå vendte Moses tilbage og steg ned fra Bjerget med Vidnesbyrdets to Tavler i Hånden, Tavler, der var beskrevet på begge Sider, både på Forsiden og Bagsiden var de beskrevet. ");
INSERT INTO dan1931_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Og Tavlerne var Guds Værk, og Skriften var Guds Skrift, ridset ind i Tavlerne. ");
INSERT INTO dan1931_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Da hørte Josua Støjen af det larmende Folk, og han sagde til Moses: “Der høres Krigslarm i Lejren!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Men han svarede: “Det er ikke sejrendes eller slagnes Skrig, det er Sang, jeg hører!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Og da Moses nærmede sig Lejren og så Tyrekalven og Dansen, blussede hans Vrede op, og han kastede Tavlerne fra sig og sønderslog dem ved Bjergets Fod. ");
INSERT INTO dan1931_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Derpå tog han Tyrekalven, som de havde lavet, brændte den i Ilden og knuste den til Støv, strøede det på Vandet og lod Israelitterne drikke det. ");
INSERT INTO dan1931_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Og Moses sagde til Aron: “Hvad har dette Folk gjort dig, siden du har bragt så stor en Synd over det?” ");
INSERT INTO dan1931_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron svarede: “Vredes ikke, Herre! Du ved selv, at Folket ligger i det onde, ");
INSERT INTO dan1931_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","og de sagde til mig: Lav os en Gud, som kan drage foran os, thi vi ved ikke, hvad der er blevet af denne Moses, der førte os ud af Ægypten! ");
INSERT INTO dan1931_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Da sagde jeg til dem: De, der har Guldsmykker, skal rive dem af! De bragte mig da Guldet, og jeg kastede det i Ilden, og så kom denne Tyrekalv ud deraf!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Da Moses nu så, at Folket var tøjlesløst til Skadefryd for deres Fjender, fordi Aron havde givet det fri Tøjler, ");
INSERT INTO dan1931_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","stillede han sig ved Indgangen til Lejren og sagde: “Hvem der er for HERREN, han komme hid til mig!” Da samlede alle Levitterne sig om ham, ");
INSERT INTO dan1931_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","og han sagde til dem: “Så siger HERREN, Israels Gud: Bind alle Sværd om Lænd og gå frem og tilbage fra den ene Indgang i Lejren til den anden og slå ned både Broder, Ven og Frænde!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Og Levitterne gjorde, som Moses havde sagt, og på den Dag faldt der af Folket henved 3.000 Mand. ");
INSERT INTO dan1931_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Og Moses sagde: “Fra i Dag af skal I være Præster for HERREN, thi ingen skånede Søn eller Broder, derfor skal Velsignelse komme over eder i Dag.” ");
INSERT INTO dan1931_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Næste Dag sagde Moses til Folket: “I har begået en stor Synd; men nu vil jeg stige op til HERREN, måske kan jeg skaffe Soning for eders Synd!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Derpå gik Moses atter til HERREN og sagde: “Ak, dette Folk har begået en stor Synd, de har lavet sig en Gud af Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Om du dog vilde tilgive dem deres Synd! Hvis ikke, så udslet mig af den Bog, du fører!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","HERREN svarede Moses: “Den, som har syndet imod mig, ham vil jeg udslette af min Bog! ");
INSERT INTO dan1931_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Men gå nu og før Folket hen, hvor jeg har befalet dig at føre det hen; se, min Engel skal drage foran dig! Men til sin Tid vil jeg straffe dem for deres Synd!” ");
INSERT INTO dan1931_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Og HERREN slog Folket, fordi de havde lavet Tyrekalven, den, Aron lavede. ");
INSERT INTO dan1931_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","HERREN sagde til Moses: “Drag nu bort herfra med Folket, som du førte ud af Ægypten, til det Land, jeg tilsvor Abraham, Isak og Jakob med de Ord: Dit Afkom vil jeg give det! ");
INSERT INTO dan1931_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Jeg sender en Engel foran dig, og han skal drive Kana'anæerne, Amoritterne, Hetitterne, Perizzitterne, Hivvitterne og Jebusitterne bort - ");
INSERT INTO dan1931_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","til et Land, der flyder med Mælk og Honning. Men selv vil jeg ikke drage med i din Midte, thi du er et halsstarrigt Folk; drog jeg med, kunde jeg tilintetgøre dig undervejs!” ");
INSERT INTO dan1931_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Da Folket hørte denne onde Tidende, sørgede de, og ingen tog sine Smykker på. ");
INSERT INTO dan1931_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Da sagde HERREN til Moses: “Sig til Israelitterne; I er et halsstarrigt Folk! Vandrede jeg kun et eneste Øjeblik i din Midte, måtte jeg tilintetgøre dig. Tag du dine Smykker af, så skal jeg tænke over, hvad jeg vil gøre for dig!” ");
INSERT INTO dan1931_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Da aflagde Israelitterne deres Smykker fra Horebs Bjerg af. ");
INSERT INTO dan1931_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moses plejede at tage Teltet og slå det op udenfor Lejren i nogen Afstand derfra; han gav det Navnet “Åbenbaringsteltet”. Enhver som vilde rådspørge HERREN, gik ud til Åbenbaringsteltet uden for Lejren. ");
INSERT INTO dan1931_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Men hver Gang Moses gik ud til teltet, rejste alt Folket sig op og stillede sig alle ved Indgangen til deres Telte og så efter Moses, indtil han kom ind i Teltet. ");
INSERT INTO dan1931_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Og når Moses kom ind Teltet, sænkede Skystøtten sig og stillede sig ved Indgangen til Teltet; da talede HERREN med Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Men når alt Folket så Skystøtten stå ved Indgangen til Teltet, rejste de sig alle op og tilbad ved Indgangen til deres Telte. ");
INSERT INTO dan1931_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Så talede HERREN med Moses Ansigt til Ansigt, som når den ene Mand taler med den anden, og derpå vendte Moses tilbage til Lejren; men hans Medhjælper Josua, Nuns Søn, en ung Mand, veg ikke fra Teltet. ");
INSERT INTO dan1931_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses sagde til HERREN: “Se, du siger til mig: Før dette Folk frem! Men du har ikke ladet mig vide, hvem du vil sende med mig; og dog har du sagt: Jeg kender dig ved Navn, og du har fundet Nåde for mine Øjne! ");
INSERT INTO dan1931_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Hvis jeg nu virkelig har fundet Nåde for dine Øjne, så lær mig dine Veje at kende, at jeg kan kende dig og finde Nåde for dine Øjne; tænk dog på, at dette Folk er dit Folk!” ");
INSERT INTO dan1931_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Han svarede: “Skal mit Åsyn da vandre med, og skal jeg således føre dig til Målet?” ");
INSERT INTO dan1931_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Da sagde Moses til ham: “Hvis dit Åsyn ikke vandrer med, så lad os ikke drage herfra! ");
INSERT INTO dan1931_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Hvorpå skal det dog kendes. at jeg har fundet Nåde for dine Øjne, jeg og dit Folk? Mon ikke på, at du vandrer med os, og der således vises os, mig og dit Folk, en Udmærkelse fremfor alle andre Folkeslag på Jorden?” ");
INSERT INTO dan1931_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","HERREN svarede Moses: “Også hvad du der siger, vil jeg gøre, thi du har fundet Nåde for mine Øjne, og jeg kalder dig ved Navn.” ");
INSERT INTO dan1931_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Da sagde Moses: “Lad mig dog skue din Herlighed!” ");
INSERT INTO dan1931_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Han svarede: “Jeg vil lade al min Rigdom drage forbi dig og udråbe HERRENS Navn foran dig, thi jeg viser Nåde, mod hvem jeg vil, og Barmhjertighed, mod hvem jeg vil!” ");
INSERT INTO dan1931_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Og han sagde: “Du kan ikke skue mit Åsyn, thi intet Menneske kan se mig og leve.” ");
INSERT INTO dan1931_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Og HERREN sagde: “Se, her er et Sted i min Nærhed, stil dig på Klippen der! ");
INSERT INTO dan1931_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Når da min Herlighed drager forbi, vil jeg lade dig stå i Klippehulen, og jeg vil dække dig med min Hånd, indtil jeg er kommet forbi. ");
INSERT INTO dan1931_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Så tager jeg min Hånd bort, og da kan du se mig bagfra; men mit Åsyn kan ingen skue!” ");
INSERT INTO dan1931_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Derpå sagde HERREN til Moses: “Tilhug dig to Stentavler ligesom de forrige, så vil jeg på Tavlerne skrive de samme Ord, som stod på de forrige Tavler, du slog i Stykker. ");
INSERT INTO dan1931_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Gør dig så rede til i Morgen, stig om Morgenen op på Sinaj Bjerg og stil dig hen og vent på mig der på Bjergets Top. ");
INSERT INTO dan1931_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ingen må følge med dig derop, og ingen må vise sig noget Sted på Bjerget, end ikke Småkvæg eller Hornkvæg må græsse i Nærheden af dette Bjerg.” ");
INSERT INTO dan1931_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Da tilhuggede han to Stentavler ligesom de forrige, og tidligt næste Morgen steg Moses op på Sinaj Bjerg, som Gud havde pålagt ham, og tog de to Stentavler med sig. ");
INSERT INTO dan1931_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Da steg HERREN ned i Skyen; og Moses stillede sig hos ham der og påkaldte HERRENS Navn. ");
INSERT INTO dan1931_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Og HERREN gik forbi ham og råbte: “HERREN, HERREN, Gud, som er barmhjertig og nådig, langmodig og rig på Miskundhed og Trofasthed, ");
INSERT INTO dan1931_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","som bevarer Miskundhed mod Tusinder, som tilgiver Brøde, Overtrædelse og Synd, men ikke lader den skyldige ustraffet, som straffer Fædres Brøde på Børn og Børnebørn, på dem i tredje og fjerde Led!” ");
INSERT INTO dan1931_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Da bøjede Moses sig hastelig til Jorden, tilbad ");
INSERT INTO dan1931_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","og sagde: “Har jeg fundet Nåde for dine Øjne, Herre, så drage min Herre med i vor Midte; thi det er et halsstarrigt Folk. Men tilgiv vor Brøde og vor Synd og lad os være din Ejendom!” ");
INSERT INTO dan1931_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Han sagde: “Se, jeg vil slutte en Pagt; i hele dit Folks Påsyn vil jeg gøre Undere, som aldrig før er sket nogetsteds på Jorden og blandt noget Folkeslag, og hele det Folk, i hvis Midte du lever, skal se HERRENS Værk; thi det, jeg vil udføre ved dig, er forfærdeligt. ");
INSERT INTO dan1931_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hold dig det efterrettelig, som jeg i Dag byder dig! Se, jeg vil drive Amoritterne, Kana'anæerne, Hetitterne, Perizzitterne, Hivvitterne og Jebusitterne bort foran dig! ");
INSERT INTO dan1931_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Vogt dig vel for at slutte nogen Pagt med Indbyggerne i det Land, du kommer til, for at de ikke skal blive en Snare for dig, når de lever i din Midte. ");
INSERT INTO dan1931_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Men I skal nedbryde deres Altre, sønderslå deres Stenstøtter og omhugge deres Asjerastøtter! ");
INSERT INTO dan1931_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Thi du må ikke tilbede nogen anden Gud, thi “Nidkær” er HERRENS Navn, nidkær Gud er han. ");
INSERT INTO dan1931_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Du må ikke slutte Pagt med Landets Indbyggere, og når de boler med deres Guder og ofrer til dem og man indbyder dig til at være med, må du ikke spise af deres Ofre; ");
INSERT INTO dan1931_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","og du må ikke af deres Døtre tage Hustruer til dine Sønner, så deres Døtre, når de boler med deres Guder, får dine Sønner til også at bole med dem. ");
INSERT INTO dan1931_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Du må ikke gøre dig noget støbt Gudebillede. ");
INSERT INTO dan1931_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Du skal lejre de usyrede Brøds Højtid; i syv Dage skal du spise usyret Brød, som jeg har pålagt dig, lå den fastsatte Tid i Abib Måned, thi i Abib Måned drog du ud af Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Alt førstefødt tilhører mig; af dine Hjorde skal du ofre mig det førstefødte af Handyrene, både af Okset og småt Kvæg; ");
INSERT INTO dan1931_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","men de førstefødte Æsler skal du udløse med et Stykke småt Kvæg, og hvis du ikke udløser det, skal du sønderbryde Halsen derpå; alle dine førstefødte Sønner skal du udløse. Du må ikke stedes for mit Åsyn med tomme Hænder. ");
INSERT INTO dan1931_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","I seks Dage må du arbejde, men på den syvende skal du hvile; i Pløje og Høsttiden skal du holde Hviledag. ");
INSERT INTO dan1931_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Du skal fejre Ugehøjtid med Førstegrøden af Hvedehøsten og Frugthøsthøjtid ved Jævndøgnstide. ");
INSERT INTO dan1931_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tre Gange om Året skal alle at Mandkøn hos dig stedes for den Herre HERREN Israels Guds Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Thi jeg vil drive Folkeslag bort foran dig og gøre dine Landemærker vide, og ingen skal attrå dit Land, medens du drager hen for at stedes for HERREN din Guds Åsyn tre Gange om Året. ");
INSERT INTO dan1931_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Du må ikke ofre Blodet af mit offer sammen med syret Brød. Påskehøjtidens Offer må ikke gemmes til næste Morgen. ");
INSERT INTO dan1931_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Det bedste af din Jords Førstegrøde skal du bringe til HERREN din Guds Hus. Du må ikke koge et Hid i dets Moders Mælk!” ");
INSERT INTO dan1931_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Og HERREN sagde til Moses: “Skriv disse Ord op, thi på Grundlag af disse Ord slutter jeg Pagt med dig og Israel.” ");
INSERT INTO dan1931_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Og han blev der hos HERREN fyrretyve Dage og fyrretyve Nætter uden at spise eller drikke; og han skrev Pagtsordene, de ti Ord, på Tavlerne. ");
INSERT INTO dan1931_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Da Moses steg ned fra Sinaj Bjerg med Vidnesbyrdets to Tavler i Hånden, vidste han ikke, at hans Ansigts Hud var kommet til at stråle, ved at han talede med ham. ");
INSERT INTO dan1931_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Men Aron og alle Israelitterne så Moses, og se, hans Ansigts Hud strålede, og de turde ikke komme ham nær. ");
INSERT INTO dan1931_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Men Moses kaldte på dem, og da vendte Aron og alle Menighedens Øverster tilbage til ham, og Moses talte til dem. ");
INSERT INTO dan1931_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Derpå kom alle Israelitterne hen til ham, og han pålagde dem alt, hvad HERREN havde talet til ham på Sinaj Bjerg. ");
INSERT INTO dan1931_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Men da Moses var færdig med at tale til dem, lagde han et Dække over sit Ansigt. ");
INSERT INTO dan1931_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Hver Gang han derefter trådte frem for HERRENS Åsyn for at tale med ham, tog han Sløret af, indtil han kom ud igen; og når han kom ud, meddelte han Israelitterne, hvad der var blevet ham påbudt. ");
INSERT INTO dan1931_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Da så Israelitterne, at Moses' Ansigts Hud strålede; og Moses lagde da Dækket over sit Ansigt, indtil han atter gik ind for at tale med ham. ");
INSERT INTO dan1931_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses kaldte hele Israelitternes Menighed sammen og sagde til dem: Dette er, hvad HERREN har pålagt eder at gøre: ");
INSERT INTO dan1931_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","I seks Dage må der arbejdes, men på den syvende Dag skal I holde Helligdag, en fuldkommen Hviledag for HERREN. Enhver, der den Dag udfører noget Arbejde, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","På Sabbatsdagen må I ikke gøre Ild i nogen af eders Boliger. ");
INSERT INTO dan1931_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Derpå sagde Moses til hele Israelitternes Menighed: Dette er, hvad HERREN har påbudt: ");
INSERT INTO dan1931_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","I skal tage en Offerydelse til HERREN af, hvad I ejer. Enhver, som i sit Hjerte føler sig tilskyndet dertil, skal komme med det, HERRENS Offerydelse, Guld, Sølv, Kobber, ");
INSERT INTO dan1931_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","violet og rødt Purpurgarn, karmoisinrødt Garn, Byssus, Gedehår, ");
INSERT INTO dan1931_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","rødfarvede Vædderskind, Tahasjskind, Akacietræ, ");
INSERT INTO dan1931_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Olie til Lysestagen, vellugtende Stoffer til Salveolien og Røgelsen, ");
INSERT INTO dan1931_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Sjohamsten og Ædelsten til Indfatning på Efoden og Brystskjoldet. ");
INSERT INTO dan1931_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Og alle kunstforstandige Mænd iblandt eder skal komme og lave alt, hvad HERREN har påbudt: ");
INSERT INTO dan1931_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Boligen med dens Teltdække og Dække, dens Kroge, Brædder, Tværstænger, Piller og Fodstykker, ");
INSERT INTO dan1931_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Arken med Bærestængerne, Sonedækket og det indre Forhæng, ");
INSERT INTO dan1931_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Bordet med dets Bærestænger og alt dets Tilbehør og Skuebrødene, ");
INSERT INTO dan1931_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Lysestagen med dens Tilbehør, dens Lamper og Olien til Lysestagen, ");
INSERT INTO dan1931_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Røgelsealteret med dets Bærestænger, Salveolien og Røgelsen. Forhænget til Boligens Indgang, ");
INSERT INTO dan1931_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Brændofferalteret med Kobbergitteret, Bærestængerne og alt dets Tilbehør, Vandkummen med dens Fodstykke, ");
INSERT INTO dan1931_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Forgårdens Omhæng, dens Piller og Fodstykker og Forhænget til Forgårdens Indgang, ");
INSERT INTO dan1931_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Boligens og Forgårdens Pæle med Reb, ");
INSERT INTO dan1931_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Pragtklæderne til Tjenesten i Helligdommen, de hellige Klæder til Præsten Aron og hans Sønners Klæder til Brug ved Præstetjenesten. ");
INSERT INTO dan1931_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Da forlod hele Israelitternes Menighed Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Og enhver, som i sit Hjerte følte sig drevet dertil, og hvis Ånd tilskyndede ham, kom med HERRENS Offerydelse til Opførelsen af Åbenbaringsteltet og til alt Arbejdet derved og til de hellige Klæder. ");
INSERT INTO dan1931_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","De kom dermed, både Mænd og Kvinder; enhver, som i sit Hjerte følte sig tilskyndet dertil, kom med Spænder, Ørenringe, Fingerringe og Halssmykker, alle Hånde Guldsmykker. Og enhver, der vilde vie HERREN en Gave af Guld, kom dermed. ");
INSERT INTO dan1931_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Og enhver, i hvis Eje der fandtes violet og rødt Purpurgarn, karmoisinrødt Garn, Byssus, Gedehår, rødfarvede Vædderskind eller Tahasjskind, kom dermed. ");
INSERT INTO dan1931_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Og enhver, der vilde give en Offerydelse af Sølv eller Kobber, kom med HERRENS Offerydelse. Og enhver, der ejede Akacietræ til alt Byggearbejdet, kom dermed. ");
INSERT INTO dan1931_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Og alle kunstforstandige Kvinder spandt med egne Hænder og kom med deres Spind, violet og rødt Purpur, Karmoisin og Byssus. ");
INSERT INTO dan1931_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Og alle Kvinder, som i Kraft af deres Kunstsnilde følte sig tilskyndede dertil i deres Hjerte, spandt Gedehårene. ");
INSERT INTO dan1931_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Og Øversterne kom med Sjohamstenene og Ædelstenene til Indfatningen på Efoden og Brystskjoldet ");
INSERT INTO dan1931_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","og de vellugtende Stoffer og Olien til Lysestagen og til Salveolien og Røgelsen. ");
INSERT INTO dan1931_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Enhver Mand og Kvinde af Israelitterne, som i sit Hjerte følte sig tilskyndet til at bringe, hvad der krævedes til Udførelsen af alt det Arbejde, HERREN gennem Moses havde påbudt, bragte det som en frivillig Gave til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Derpå sagde Moses til Israelitterne: Se, HERREN har kaldet Bezal'el, en Søn af Hurs Søn Uri, af Judas Stamme ");
INSERT INTO dan1931_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","og fyldt ham med Guds Ånd, med Kunstsnilde, Kløgt og Indsigt i alskens Arbejde ");
INSERT INTO dan1931_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","til at udtænke Kunstværker og til at arbejde i Guld, Sølv og Kobber ");
INSERT INTO dan1931_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","og med Udskæring af Sten til Indfatning og med Træskærerarbejde, kort sagt til at udføre alskens Kunstarbejde. ");
INSERT INTO dan1931_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Og tillige har han givet både ham og Oholiab, Ahisamaks Søn, af Dans Stamme Gaver til at lære fra sig. ");
INSERT INTO dan1931_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Han har fyldt dem med Kunstsnilde til at udføre alskens Udskæringsarbejde, Kunstvævning, broget Vævning af violet og rødt Purpurgarn, karmoisinrødt Garn og Byssus og almindelig Vævning, så de kan udføre alt Slags Arbejde og udtænke Kunstværker. ");
INSERT INTO dan1931_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Derfor skal Bezal'el og Oholiab og alle andre kunstforstandige Mænd, hvem HERREN har givet Kunstsnilde og Kløgt, så de forstår sig på Arbejdet, udføre alt Arbejdet ved Helligdommens Opførelse i Overensstemmelse med alt, hvad HERREN har påbudt. ");
INSERT INTO dan1931_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Derpå tilkaldte Moses Bezal'el og Oholiab og alle de kunstforstandige Mænd, hvem HERREN havde givet Kunstsnilde, alle dem, som i deres Hjerte følte sig tilskyndet til at give sig i Lag med Udførelsen af Arbejdet. ");
INSERT INTO dan1931_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Og de modtog af Moses hele den Offerydelse, Israelitterne var kommet med til Arbejdet med Helligdommens Opførelse, for at det kunde blive udført. Men de blev ved at komme med frivillige Gaver til ham, Morgen efter Morgen. ");
INSERT INTO dan1931_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Da kom alle de kunstforstandige Mænd, der udførte alt Arbejdet ved Helligdommen, hver fra den Del af Arbejdet, han var beskæftiget med, ");
INSERT INTO dan1931_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","og sagde til Moses: “Folket kommer med mere, end der kræves til Udførelsen af det Arbejde, HERREN har påbudt!” ");
INSERT INTO dan1931_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Da bød Moses, at følgende Kundgørelse skulde udråbes i Lejren: “Hverken Mænd eller Kvinder skal yde mere som Offergave til Helligdommen!” Så hørte Folket op med at komme med Gaver. ");
INSERT INTO dan1931_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Og det, der var ydet, var dem nok til at udføre hele Arbejdet, ja mer end nok. ");
INSERT INTO dan1931_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Så lavede alle de kunstforstandige Mænd blandt dem, der deltog i Arbejdet, Boligen, ti Tæpper af tvundet Byssus, violet og rødt Purpurgarn og karmoisinrødt Garn; han* lavede dem med Keruber på i Kunstvævning, { *dvs. Bezal'el. 2 Mos. 26, 1 ff. } ");
INSERT INTO dan1931_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","hvert Tæppe otte og tyve Alen langt og fire Alen bredt; alle Tæpperne havde samme Mål. ");
INSERT INTO dan1931_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Han syede Tæpperne sammen, fem og fem. ");
INSERT INTO dan1931_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","I Kanten af det ene Tæppe, det yderste i det ene sammensyede Stykke, satte han Løkker af violet Purpurgarn, og ligeledes satte han Løkker i Kanten af det yderste Tæppe i det andet sammensyede Stykke; ");
INSERT INTO dan1931_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","han satte halvtredsindstyve Løkker på det ene Tæppe og halvtredsindstyve Løkker i Kanten af det tilsvarende Tæppe i det andet sammensyede Stykke, Løkke lige over for Løkke. ");
INSERT INTO dan1931_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Derpå lavede han halvtredsindstyve Guldkroge til at forbinde Tæpperne med hinanden, så at Boligen udgjorde et Hele. ");
INSERT INTO dan1931_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Fremdeles lavede han Tæpper af Gedehår til et Teltdække uden om Boligen, og her lavede han elleve Tæpper, ");
INSERT INTO dan1931_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","hvert Tæppe tredive Alen langt og fire Alen bredt; alle Tæpperne havde samme Mål. ");
INSERT INTO dan1931_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","De fem af Tæpperne syede han sammen for sig og de seks for sig, ");
INSERT INTO dan1931_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","og han satte halvtredsindstyve Løkker i Kanten af det yderste Tæppe i det ene sammensyede Stykke og halvtredsindstyve Løkker i Kanten af det tilsvarende Tæppe i det andet sammensyede Stykke. ");
INSERT INTO dan1931_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Og han lavede halvtredsindstyve Kobberkroge til at sammenføje Teltdækket med, så det udgjorde et Hele. ");
INSERT INTO dan1931_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Fremdeles lavede han over Teltdækket et Dække af rødfarvede Vædderskind og derover endnu et Dække af Tahasjskind. ");
INSERT INTO dan1931_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Derpå lavede han Brædderne til Boligen af Akacietræ til at stå op, ");
INSERT INTO dan1931_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","hvert Bræt ti Alen højt og halvanden Alen bredt, ");
INSERT INTO dan1931_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","og på hvert Bræt to indbyrdes forbundne Tapper; således indrettede han det ved alle Boligens Brædder. ");
INSERT INTO dan1931_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Af Brædderne, som han lavede til Boligen, var tyve til Sydsiden, ");
INSERT INTO dan1931_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","og til de tyve Brædder lavede han fyrretyve Fodstykker af Sølv, to Fodstykker til de to Tapper på hvert Bræt. ");
INSERT INTO dan1931_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Andre tyve Brædder lavede han til Boligens anden Side, som vendte mod Nord, ");
INSERT INTO dan1931_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","med fyrretyve Fodstykker af Sølv, to Fodstykker til hvert Bræt. ");
INSERT INTO dan1931_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Og til Bagsiden, som vendte mod Vest, lavede han seks Brædder. ");
INSERT INTO dan1931_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Til Boligens Baghjørner lavede han to Brædder, ");
INSERT INTO dan1931_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","der bestod af to Stykker forneden og ligeledes af to Stykker foroven, indtil den første Ring; således indrettede han dem begge for at danne de to Hjørner. ");
INSERT INTO dan1931_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Altså blev der til Bagsiden otte Brædder med tilhørende seksten Fodstykker af Sølv, to til hvert Bræt. ");
INSERT INTO dan1931_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Derpå lavede han Tværstænger af Akacietræ, fem til de Brædder, der dannede Boligens ene Side, ");
INSERT INTO dan1931_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","fem til de Brædder, der dannede Boligens anden Side, og fem til de Brædder, der dannede Boligens Bagside mod Vest; ");
INSERT INTO dan1931_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","den mellemste Tværstang lavede han således, at den midt på Brædderne nåede fra den ene Ende af Væggen til den anden. ");
INSERT INTO dan1931_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Brædderne overtrak han med Guld, og deres Ringe, som Tværstængerne skulde stikkes i, lavede han af Guld, og Tværstængerne overtrak han med Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Derpå lavede han Forhænget af violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus, han lavede det i Kunstvævning med Keruber på, ");
INSERT INTO dan1931_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","og han lavede dertil fire Piller af Akacietræ, som han overtrak med Guld, og Knagerne derpå lavede han af Guld, og han støbte fire Fodstykker af Sølv til dem. ");
INSERT INTO dan1931_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Derpå lavede han et Forhæng til Teltets Indgang af violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus i broget Vævning ");
INSERT INTO dan1931_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","og dertil fem Piller med Knager, hvis Hoveder og Bånd han overtrak med Guld, og fem Fodstykker af Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Derpå lavede Bezal'el Arken af Akacietræ, halvtredje Alen lang, halvanden Alen bred og halvanden Alen høj, ");
INSERT INTO dan1931_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","og overtrak den indvendig og udvendig med purt Guld og satte en gylden Krans rundt om den. ");
INSERT INTO dan1931_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Derefter støbte han fire Guldringe til den og satte dem på dens fire Fødder, to Ringe på hver Side af den. ");
INSERT INTO dan1931_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Og han lavede Bærestænger af Akacietræ og overtrak dem med Guld; ");
INSERT INTO dan1931_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","så stak han Stængerne gennem Ringene på Arkens Sider, for at den kunde bæres med dem. ");
INSERT INTO dan1931_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Derpå lavede han Sonedækket af purt Guld, halvtredje Alen langt og halvanden Alen bredt, ");
INSERT INTO dan1931_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","og han lavede to Keruber af Guld, i drevet Arbejde lavede han dem, ved begge Ender af Sonedækket, ");
INSERT INTO dan1931_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","den ene Kerub ved den ene Ende, den anden Kerub ved den anden; han lavede Keruberne således, at de var i ét med Sonedækket ved begge Ender. ");
INSERT INTO dan1931_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Og Keruberne bredte deres Vinger i Vejret, således at de dækkede over Sonedækket med deres Vinger; de vendte Ansigtet mod hinanden; nedad mod Sone, dækket vendte Kerubernes Ansigter. ");
INSERT INTO dan1931_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Derpå lavede han Bordet af Akacietræ, to Alen langt, en Alen bredt og halvanden Alen højt, ");
INSERT INTO dan1931_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","og overtrak det med purt Guld og satte en gylden Krans rundt om det. ");
INSERT INTO dan1931_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Og han satte en Liste af en Hånds Bredde rundt om det og en gylden Krans rundt om Listen. ");
INSERT INTO dan1931_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Og han støbte fire Guldringe og satte dem på de fire Hjørner ved dets fire Ben. ");
INSERT INTO dan1931_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Lige ved Listen sad Ringene til at stikke Bærestængerne i, så at man kunde bære Bordet. ");
INSERT INTO dan1931_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Og han lavede Bærestængerne at Akacietræ og overtrak dem med Guld, og med dem skulde Bordet bæres. ");
INSERT INTO dan1931_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Og han lavede af purt Guld de Ting, som hørte til Bordet, Fadene og Kanderne, Skålene og Krukkerne til at udgyde Drikoffer med. ");
INSERT INTO dan1931_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Derpå lavede han Lysestagen af purt Guld, i drevet Arbejde lavede han Lysestagen, dens Fod og selve Stagen, således at dens Blomster med Bægere og Kroner var i ét med den; ");
INSERT INTO dan1931_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","seks Arme udgik fra Lysestagens Sider, tre fra den ene og tre fra den anden Side. ");
INSERT INTO dan1931_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","På hver af Armene, der udgik fra Lysestagen, var der tre mandelblomstlignende Blomster med Bægere og Kroner, ");
INSERT INTO dan1931_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","men på selve Stagen var der fire mandelblomstlignende Blomster med Bægere og Kroner, ");
INSERT INTO dan1931_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","et Bæger under hvert af de tre Par Arme, der udgik fra den. ");
INSERT INTO dan1931_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Bægrene og Armene var i ét med den, så at det hele udgjorde ét drevet Arbejde af purt Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Derpå lavede han de syv Lamper til den, Lampesaksene og Bakkerne af purt Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","En Talent purt Guld brugte han til den og til alt dens Tilbehør. ");
INSERT INTO dan1931_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Derpå lavede han Røgelsealteret af Akacietræ, en Alen langt og en Alen bredt, i Firkant, og to Alen højt, og dets Horn var i ét med det. ");
INSERT INTO dan1931_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Og han overtrak det med purt Guld, både Pladen og Siderne hele Vejen rundt og Hornene, og satte en Guldkrans rundt om; ");
INSERT INTO dan1931_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","og han satte to Guldringe under Kransen på begge Sider til at stikke Bærestængerne i, for at det kunde bæres med dem; ");
INSERT INTO dan1931_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Bærestængerne lavede han af Akacietræ og overtrak dem med Guld. ");
INSERT INTO dan1931_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Han tilberedte også den hellige Salveolie og den rene, vellugtende Røgelse, som Salveblanderne laver den. ");
INSERT INTO dan1931_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Derpå lavede han Brændofferalteret af Akacietræ, fem Alen langt og fem Alen bredt, firkantet, og tre Alen højt. ");
INSERT INTO dan1931_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Han lavede Horn til dets fire Hjørner, således at de var i ét dermed, overtrak det med Kobber ");
INSERT INTO dan1931_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","og lavede alt Alterets Tilbehør, Karrene, Skovlene, Skålene, Gaflerne og Panderne; alt dets Tilbehør lavede han af Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Derpå omgav han Alteret med et flettet Kobbergitter neden under dets Liste, således at det nåede op til Alterets halve Højde. ");
INSERT INTO dan1931_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Derefter støbte han fire Ringe til Kobbergitterets fire Hjørner til at stikke Bærestængerne i. ");
INSERT INTO dan1931_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Bærestængerne lavede han at Akacietræ og overtrak dem med Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Og Stængerne stak han gennem Ringene på Alterets Sider, for at det kunde bæres med dem. Han lavede det hult af Brædder. ");
INSERT INTO dan1931_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Derpå lavede han Vandkummen med Fodstykke af Kobber og brugte dertil Spejle, som tilhørte Kvinderne, der gjorde Tjeneste ved Indgangen til Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Derpå indrettede han Forgården: Til Sydsiden det hundrede Alen lange Forgårdsomhæng af tvundet Byssus ");
INSERT INTO dan1931_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","med tyve Piller og tyve Fodstykker af Kobber og med Knager og Bånd af Sølv til Pillerne. ");
INSERT INTO dan1931_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Til Nordsiden hundrede Alen med tyve Piller og tyve Fodstykker af Kobber og med Knager og Bånd af Sølv til Pillerne. ");
INSERT INTO dan1931_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Til Vestsiden det halvtredsindstyve Alen lange Omhæng med ti Piller og ti Fodstykker og med Knager og Bånd af Sølv til Pillerne. ");
INSERT INTO dan1931_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Og til Forsiden mod Øst, der var halvtredsindstyve Alen bred, ");
INSERT INTO dan1931_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","det femten Alen lange Omhæng med fire Piller og tre Fodstykker til den ene Side af Indgangen, ");
INSERT INTO dan1931_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","og det femten Alen lange Omhæng med tre Piller og tre Fodstykker til den anden Side af Indgangen. ");
INSERT INTO dan1931_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Alle Omhæng rundt om Forgården var af tvundet Byssus, ");
INSERT INTO dan1931_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Fodstykkerne til Pillerne af Kobber, men deres Knager og Bånd af Sølv; alle Pillernes Hoveder var overtrukket med Sølv; og de havde Bånd af Sølv. ");
INSERT INTO dan1931_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Forhænget til Forgårdens Indgang var af violet og rødt Purpurgarn i broget Vævning, karmoisinrødt Garn og tvundet Byssus, tyve Alen langt og fem Alen højt, svarende til Bredden på Forgårdens Omhæng. ");
INSERT INTO dan1931_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Dertil hørte fire Piller med fire Fodstykker af Kobber; Knagerne var af Sølv og Overtrækket på Hovederne og Båndene ligeledes af Sølv. ");
INSERT INTO dan1931_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Alle Pælene til Boligen og Forgården rundt om var af Kobber. ");
INSERT INTO dan1931_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Her følger Regnskabet over Boligen, Vidnesbyrdets Bolig, som på Moses' Bud blev opgjort af Levitterne under Ledelse af Itamar, en Søn af Præsten Aron; ");
INSERT INTO dan1931_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezal'el, en Søn af Hurs Søn Uri, af Judas Stamme havde udført alt, hvad HERREN havde pålagt Moses, ");
INSERT INTO dan1931_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","sammen med Oholiab, Ahisamaks Søn, af Dans Stamme, som udførte Udskæringsarbejdet, Kunstvævningen og den brogede Vævning af violet og rødt Purpur, Karmoisin og Byssus. ");
INSERT INTO dan1931_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hvad angår Guldet, der anvendtes til Arbejdet, under hele Arbejdet på Helligdommen, så løb det som Gave viede Guld op til 29 Talenter og 730 Sekel efter hellig Vægt. ");
INSERT INTO dan1931_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Det ved Menighedens Mønstring indkomne Sølv løb op til 100 Talenter og 1.775 Sekel efter hellig Vægt: ");
INSERT INTO dan1931_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","en, Beka, det halve af en Sekel efter hellig Vægt, af enhver, der måtte lade sig mønstre, altså fra Tyveårsalderen og opefter, i alt 603.550 Mand: ");
INSERT INTO dan1931_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","De 100 Talenter Sølv medgik til Støbningen af Helligdommens og Forhængets Fodstykker, 100 Talenter til 100 Fodstykker, en Talent til hvert Fodstykke. ");
INSERT INTO dan1931_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Men de 1.775 Sekel anvendte han til Knager til Pillerne, til at overtrække deres Hoveder med og til Bånd på dem. ");
INSERT INTO dan1931_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Det som Gave viede Kobber udgjorde 70 Talenter og 2.400 Sekel. ");
INSERT INTO dan1931_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Deraf lavede han Fodstykkerne til Åbenbaringsteltets Indgang, Kobberalteret med dets Kobbergitter og alt Alterets Tilbehør, ");
INSERT INTO dan1931_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Fodstykkerne til Forgården rundt om og til Forgårdens Indgang og alle Teltpælene til Boligen og alle Teltpælene til Forgården hele Vejen rundt. ");
INSERT INTO dan1931_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Af det violette og røde Purpurgarn og det karmoisinrøde Garn tilvirkede de Pragtklæderne til Tjenesten i Helligdommen; og de tilvirkede Arons hellige Klæder, således som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","De tilvirkede Efoden af Guldtråd, violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus, ");
INSERT INTO dan1931_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","idet de udhamrede Guldet i Plader og skar Pladerne ud i Tråde til at væve ind i det violette og røde Purpurgarn, det karmoisinrøde Garn og det tvundne Byssus ved Kunstvævning. ");
INSERT INTO dan1931_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Derpå forsynede de den med Skulderstykker til at hæfte på; den blev hæftet sammen ved begge Hjørner. ");
INSERT INTO dan1931_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Og dens Bælte, som brugtes, når den skulde tages på, var i ét med den og af samme Arbejde, af Guldtråd, violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus, således som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Derpå tilvirkede de Sjohamstenene, indfattede i Guldfletværk og graverede som Signeter med Israels Sønners Navne; ");
INSERT INTO dan1931_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","og de fæstede dem på Efodens Skulderstykker, for at Stenene kunde bringe Israels Børn i Minde, således som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Derpå tilvirkede de Brystskjoldet i Kunstvævning på samme Måde som Efoden, af Guldtråd, violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus; ");
INSERT INTO dan1931_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","det var firkantet, og de lagde Brystskjoldet dobbelt; det var et Spand langt og et Spand bredt, lagt dobbelt. ");
INSERT INTO dan1931_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","De udstyrede det med fire Rækker Sten: Karneol, Topas og Smaragd i den første Række, ");
INSERT INTO dan1931_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Rubin, Safir og Jaspis i den anden, ");
INSERT INTO dan1931_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Hyacint, Agat og Ametyst i den tredje, ");
INSERT INTO dan1931_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Krysolit, Sjoham og Onyks i den fjerde, omgivne med Guldfletværk i deres Indfatninger. ");
INSERT INTO dan1931_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Der var tolv Sten, svarende til Israels Sønners Navne, en for hvert Navn; det var graveret Arbejde som Signeter, således at hver Sten bar Navnet på en af de tolv Stammer. ");
INSERT INTO dan1931_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Til Brystskjoldet lavede de snoede Kæder af purt Guld, snoet Arbejde, som når man snor Reb. ");
INSERT INTO dan1931_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Derpå lavede de to Guldfletværker og to Guldringe og satte disse to Ringe på Brystskjoldets øverste Hjørner, ");
INSERT INTO dan1931_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","og de to Guldsnore knyttede de i de to Ringe på Brystskjoldets Hjørner; ");
INSERT INTO dan1931_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Snorenes anden Ende anbragte de i de to Fletværker og fæstede dem på Forsiden af Efodens Skulderstykker. ");
INSERT INTO dan1931_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Og de lavede to andre Guldringe og satte dem på Brystskjoldets to andre Hjørner på den indre Rand, der vendte mod Efoden. ");
INSERT INTO dan1931_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Og de lavede endnu to Guldringe og fæstede dem på Efodens to Skulderstykker forneden på Forsiden, hvor den var hæftet sammen med Skulderstykkerne, oven over Efodens Bælte; ");
INSERT INTO dan1931_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","og de bandt med Ringene Brystskjoldet fast til Efodens Ringe ved Hjælp af en violet Purpursnor, så at det kom til at sidde oven over Efodens Bælte og ikke kunde løsne sig fra Efoden, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Derpå tilvirkede de Kåben, som hører til Efoden, i vævet Arbejde, helt og holdent af violet Purpur. ");
INSERT INTO dan1931_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Midt på havde Kåben en Halsåbning ligesom Halsåbningen på en Panserskjorte, omgivet af en Linning, for at den ikke skulde rives itu, ");
INSERT INTO dan1931_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","og langs Kåbens nederste Kant syede de Granatæbler af violet og rødt Purpurgarn, karmoisinrødt Garn og tvundet Byssus, ");
INSERT INTO dan1931_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","og de lavede Bjælder af purt Guld, som de anbragte mellem Granatæblerne langs Kåbens nederste Kant hele Vejen rundt, mellem Granatæblerne, ");
INSERT INTO dan1931_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","så at Bjælder og Granatæbler skiftede hele Vejen rundt langs Kåbens nederste Kant, til at bære ved Tjenesten, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Derpå tilvirkede de Kjortlerne til Aron og hans Sønner af Byssus i vævet Arbejde, ");
INSERT INTO dan1931_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Hovedklædet af Byssus, Embedshuerne af Byssus, Linnedbenklæderne af tvundet Byssus, ");
INSERT INTO dan1931_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","og Bæltet af tvundet Byssus, violet og rødt Purpurgarn og karmoisinrødt Garn i broget Vævning, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Derpå lavede de Pandepladen, det hellige Diadem, af purt Guld og forsynede den med en Indskrift i graveret Arbejde som ved Signeter: “Helliget HERREN.” ");
INSERT INTO dan1931_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Og de fæstede en violet Purpursnor på den til at binde den fast med oven på Hovedklædet, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Således fuldførtes alt Arbejdet ved Åbenbaringsteltets Bolig; og Israelitterne gjorde ganske som HERREN havde pålagt Moses; således gjorde de. ");
INSERT INTO dan1931_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Derpå bragte de Boligen til Moses, Teltdækket med alt dets Tilbehør, Knagerne, Brædderne, Tværstængerne, Pillerne og Fodstykkerne, ");
INSERT INTO dan1931_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Dækket af rødfarvede Vædderskind og Dækket af Tahasjskind, det indre Forhæng, ");
INSERT INTO dan1931_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Vidnesbyrdets Ark med Bærestængerne, Sonedækket, ");
INSERT INTO dan1931_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Bordet med alt dets Tilbehør, Skuebrødene, ");
INSERT INTO dan1931_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Lysestagen af purt Guld med Lamperne, der skulde sættes på den, og alt dens Tilbehør, Olien til Lysestagen, ");
INSERT INTO dan1931_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Guldalteret, Salveolien, den vellugtende Røgelse, Forhænget til Teltets Indgang, ");
INSERT INTO dan1931_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Kobberalteret med Kobbergitteret, Bærestængerne og alt dets Tilbehør, Vandkummen og Fodstykket, ");
INSERT INTO dan1931_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Omhængene til Forgården, Pillerne og Fodstykkerne, Forhænget til Forgårdens Indgang, Rebene og Teltpælene, alt Tilbehør til Tjenesten i Åbenbaringsteltets Bolig, ");
INSERT INTO dan1931_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Pragtklæderne til Tjenesten i Helligdommen, de hellige Klæder til Præsten Aron og hans Sønners Klæder til Præstetjenesten. ");
INSERT INTO dan1931_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Nøjagtigt som HERREN havde pålagt Moses, udførte Israelitterne hele Arbejdet. ");
INSERT INTO dan1931_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Da så Moses hele Arbejdet efter, og se, de havde udført det, som HERREN havde sagt; således havde de udført det. Og Moses velsignede dem. ");
INSERT INTO dan1931_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","På den første Dag i den første Måned skal du rejse Åbenbaringsteltets Bolig. ");
INSERT INTO dan1931_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Sæt så Vidnesbyrdets Ark derind og hæng Forhænget op for Arken. ");
INSERT INTO dan1931_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Og du skal bringe Bordet ind og ordne, hvad dertil hører, og bringe Lysestagen ind og sætte Lamperne på. ");
INSERT INTO dan1931_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Stil Guldalteret til Røgelsen op foran Vidnesbyrdets Ark og hæng Forhænget op foran Boligens Indgang. ");
INSERT INTO dan1931_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Stil Brændofferalteret op foran Indgangen til Åbenbaringsteltets Bolig ");
INSERT INTO dan1931_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","og stil Vandkummen op mellem Åbenbaringsteltet og Alteret og hæld Vand deri. ");
INSERT INTO dan1931_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Rejs Forgården rundt om og hæng Forhænget op foran Forgårdens Indgang. ");
INSERT INTO dan1931_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Tag Salveolien og salv Boligen og alle Ting deri, og du skal hellige den med alt dens Tilbehør, så den bliver hellig. ");
INSERT INTO dan1931_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Du skal salve Brændofferalteret og alt dets Tilbehør og hellige Alteret, så det bliver højhelligt. ");
INSERT INTO dan1931_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Og du skal salve Vandkummen og Fodstykket og hellige den. ");
INSERT INTO dan1931_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Lad så Aron og hans Sønner træde hen til Åbenbaringsteltets Indgang, tvæt dem med Vand ");
INSERT INTO dan1931_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","og ifør Aron de hellige Klæder. salv og hellig ham til at gøre Præstetjeneste for mig. ");
INSERT INTO dan1931_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Lad så hans Sønner træde frem, ifør dem Kjortler ");
INSERT INTO dan1931_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","og salv dem, som du salver deres Fader, til at gøre Præstetjeneste for mig. Således skal det ske, for at et evigt Præstedømme kan blive dem til Del fra Slægt til Slægt i Kraft af denne Salvning, som du foretager på dem. ");
INSERT INTO dan1931_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Og Moses gjorde ganske som HERREN havde pålagt ham; således gjorde han. ");
INSERT INTO dan1931_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","På den første Dag i den første Måned i det andet* År blev Boligen rejst. { *efter Udvandringen. } ");
INSERT INTO dan1931_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses rejste Boligen, idet han anbragte Fodstykkerne, rejste Brædderne, stak Tværstængerne ind, rejste Pillerne, ");
INSERT INTO dan1931_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","spændte Teltdækket ud over Boligen og lagde Teltdækkets Dække ovenover, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Derpå tog han Vidnesbyrdet* og lagde det i Arken, stak Bærestængerne i Arken og lagde Sonedækket oven på den; { *se til 2 Mos. 16, 34; 25, 16. 21. } ");
INSERT INTO dan1931_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","så bragte han Arken ind i Boligen og hængte det indre Forhæng op og tilhyllede således Vidnesbyrdets Ark, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Derpå opstillede han Bordet i Åbenbaringsteltet ved Boligens nordre Væg uden for Forhænget, ");
INSERT INTO dan1931_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","og han lagde Brødene i Række derpå for HERRENS Åsyn, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Derpå satte han Lysestagen ind i Åbenbaringsteltet lige over for Bordet, ved Boligens søndre Væg; ");
INSERT INTO dan1931_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","og han satte Lamperne derpå for HERRENS Åsyn, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Derpå stillede han Guldalteret op i Åbenbaringsteltet foran Forhænget, ");
INSERT INTO dan1931_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","og han tændte vellugtende Røgelse derpå, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Derpå hængte han Forhænget op for Boligens Indgang. ");
INSERT INTO dan1931_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Brændofferalteret opstillede han foran Indgangen til Åbenbaringsteltets Bolig og ofrede Brændofferet og Afgrødeofferet derpå, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Derpå opstillede han Vandkummen mellem Åbenbaringsteltet og Alteret og hældte Vand deri til Tvætning. ");
INSERT INTO dan1931_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Og Moses og Aron og hans Sønner tvættede deres Hænder og Fødder deri; ");
INSERT INTO dan1931_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","når de gik ind i Åbenbaringsteltet og trådte hen til Alteret. tvættede de sig, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Så rejste han Forgården rundt om Boligen og Alteret og hængte Forhænget op for Forgårdens Indgang. Hermed var Moses færdig med Arbejdet. ");
INSERT INTO dan1931_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Da dækkede Skyen Åbenbaringsteltet, og HERRENS Herlighed fyldte Boligen; ");
INSERT INTO dan1931_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","og Moses kunde ikke gå ind i Åbenbaringsteltet, fordi Skyen havde lagt sig derover, og HERRENS Herlighed fyldte Boligen. ");
INSERT INTO dan1931_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Men under hele deres Vandring brød Israelitterne op, når Skyen løftede sig fra Boligen; ");
INSERT INTO dan1931_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","og når Skyen ikke løftede sig. brød de ikke op, men ventede, til den atter løftede sig. ");
INSERT INTO dan1931_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Thi HERRENS Sky lå over Boligen om Dagen, og om Natten lyste Ild i Skyen for alle Israelitternes Øjne under hele deres Vandring. ");
INSERT INTO dan1931_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","HERREN kaldte på Moses og talede til ham fra Åbenbaringsteltet og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Tal til Israelitterne og sig til dem: Når nogen af eder vil bringe HERREN en Offergave af Kvæget, da skal Offergaven, I vil bringe, tages at Hornkvæget eller Småkvæget. ");
INSERT INTO dan1931_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Skal hans Offergave af Hornkvæget være et Brændoffer, så skal det være et lydefrit Handyr, han bringer; til Åbenbaringsteltets Indgang skal han bringe det for at vinde HERRENS Velbehag. ");
INSERT INTO dan1931_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Så skal han lægge sin Hånd på Brændofferdyrets Hoved, for at det kan vinde ham HERRENS Velbehag, idet det skaffer ham Soning. ");
INSERT INTO dan1931_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Derpå skal han slagte den unge Okse for HERRENS Åsyn, og Arons Sønner, Præsterne, skal frembære Blodet, og de skal sprænge Blodet rundt om på Alteret, som står ved Indgangen til Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Så skal han flå Huden af Brændofferdyret og skære det i Stykker, ");
INSERT INTO dan1931_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","og Arons Sønner, Præsterne, skal gøre Ild på Alteret og lægge Brænde på Ilden; ");
INSERT INTO dan1931_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","og Arons Sønner, Præsterne, skal lægge Stykkerne tillige med Hovedet og Fedtet til Rette på Brændet over Ilden på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Men Indvoldene og Skinnebenene skal han tvætte med Vand, og Præsten skal bringe det hele som Røgoffer på Alteret; det er et Brændoffer, et Ildoffer til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Hvis hans Offergave, der skal bruges som Brændoffer, tages at Småkvæget, af Fårene eller Gederne, så skal det være et lydefrit Handyr, han bringer. ");
INSERT INTO dan1931_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Han skal slagte det for HERRENS Åsyn ved Alterets Nordside, og Arons Sønner, Præsterne skal sprænge Blodet deraf rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Så skal han skære det i Stykker, og Præsten skal lægge Stykkerne tillige med Hovedet og Fedtet til Rette på Brændet over Ilden på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Men Indvoldene og Skinnebenene skal han tvætte med Vand. Så skal Præsten frembære det hele og bringe det som Røgoffer på Alteret; det er et Brændoffer, et Ildoffer til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Er hans Offergave til HERREN et Brændoffer af Fuglene, da skal Offergaven, han vil bringe, tages af Turtelduerne eller Dueungerne; ");
INSERT INTO dan1931_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Præsten skal frembære den til Alteret og knække Halsen på den og bringe Hovedet som Røgoffer på Alteret, og dens Blod skal udpresses mod Alterets Side. ");
INSERT INTO dan1931_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Så skal han udtage Kroen med dens Indhold og kaste den på Askedyngen ved Alterets Østside. ");
INSERT INTO dan1931_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Derpå skal han rive Vingerne løs på den uden dog at skille dem fra Kroppen. Så skal Præsten bringe den som Røgoffer på Alteret på Brændet over Ilden; det er et Brændoffer, et Ildoffer til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Når nogen vil frembære et Afgrødeoffer som Offergave for HERREN, skal hans Offergave bestå af fint Hvedemel, og han skal hælde Olie derover og komme Røgelse derpå. ");
INSERT INTO dan1931_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Og han skal bringe det til Arons Sønner, Præsterne; og Præsten skal tage en Håndfuld af Melet og Olien og al Røgelsen, det, som skal ofres af Afgrødeofferet, og bringe det som Røgoffer på Alteret, et Ildoffer til en liflig Duft for HERREN; ");
INSERT INTO dan1931_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","men Resten af Afgrødeofferet skal tilfalde Aron og hans Sønner som en højhellig Del af HERRENS Ildofre. ");
INSERT INTO dan1931_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Men når du som Offergave vil bringe et Afgrødeoffer af Bagværk fra Bagerovnen, skal det bestå af fint Hvedemel, usyrede Kager, rørte i Olie, og usyrede Fladbrød, smurte med Olie. ");
INSERT INTO dan1931_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Er derimod din Offergave et Afgrødeoffer, bagt på Plade, så skal det bestå af usyret fint Hvedemel, rørt i Olie; ");
INSERT INTO dan1931_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","du skal bryde det i Stykker og hælde Olie derover. Det er et Afgrødeoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Men er din Offergave et Afgrødeoffer, bagt i Pande, skal det tilberedes af fint Hvedemel med Olie. ");
INSERT INTO dan1931_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Det Afgrødeoffer, der tilberedes af disse Ting, skal du bringe HERREN; man skal bringe det til Præsten, og han skal bære det hen til Alteret; ");
INSERT INTO dan1931_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","og Præsten skal af Afgrødeofferet udtage det, som skal ofres deraf, og bringe det som Røgoffer på Alteret, et Ildoffer til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Men Resten af Afgrødeofferet skal tilfalde Aron og hans Sønner som en højhellig Del af HERRENS Ofre. ");
INSERT INTO dan1931_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Intet Afgrødeoffer, som I bringer HERREN, må tilberedes syret; thi Surdej eller Honning må I aldrig bringe som Røgoffer, som Ildoffer for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Kun som Offergave af Førstegrøde må I frembære disse Ting for HERREN, men de må ikke komme på Alteret til en liflig Duft. ");
INSERT INTO dan1931_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Og du skal komme Salt i enhver Afgrødeoffergave, du frembærer, du må ikke undlade at komme din Guds Pagts Salt i dit Afgrødeoffer, men du skal frembære Salt med enhver af dine Offergaver. ");
INSERT INTO dan1931_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Dersom du vil frembære HERREN et Afgrødeoffer af Førstegrøden, skal det, du frembærer som Afgrødeoffer af din Førstegrøde, være friske Aks, ristede over Ilden, knuste, af nyhøstet Korn; ");
INSERT INTO dan1931_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","og du skal hælde Olie derover og komme Røgelse derpå. Det er et Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Al Røgelsen og det, som skal ofres af de knuste Aks og Olien, skal Præsten bringe som Røgoffer, et Ildoffer for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Men er hans Offergave et Takoffer, så skal det, hvis han bringer det af Hornkvæget, være et lydefrit Han eller Hundyr, han bringer HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Han skal lægge sin Hånd på sin Offergaves Hoved og slagte Dyret ved Indgangen til Åbenbaringsteltet; og Arons Sønner, Præsterne, skal sprænge Blodet rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Så skal han af Takofferet som Ildoffer for HERREN frembære Fedtet, der dækker Indvoldene, og alt Fedtet på Indvoldene, ");
INSERT INTO dan1931_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","begge Nyrerne med det Fedt. som sidder på dem ved Lændemusklerne, og Leverlappen, som han skal skille fra ved Nyrerne. ");
INSERT INTO dan1931_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Og Arons Sønner skal bringe det som Røgoffer på Alteret oven på Brændofferet på Brændet, der ligger på Ilden, et Ildoffer til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Men hvis hans Offergave, der bringes som Takoffer til HERREN. tages af Småkvæget, skal det være et lydefrit Han eller Hundyr, han bringer. ");
INSERT INTO dan1931_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Er den Offergave, han vil bringe. et Lam, skal han bringe det hen for HERRENS Åsyn ");
INSERT INTO dan1931_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","og lægge sin Hånd på sin Offergaves Hoved og slagte Dyret foran Åbenbaringsteltet, og Arons Sønner skal sprænge Blodet deraf rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Så skal han af Takofferet som Ildoffer for HERREN frembære Fedtet, hele Fedthalen, skilt fra Rygraden, Fedtet, som dækker Indvoldene, og alt Fedtet på Indvoldene, ");
INSERT INTO dan1931_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","begge Nyrerne med det Fedt, som sidder på dem ved Lændemusklerne, og Leverlappen, som han skal skille fra ved Nyrerne. ");
INSERT INTO dan1931_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Og Præsten skal bringe det som Røgoffer på Alteret, Ildofferspise for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Men hvis hans Offergave er en Ged, skal han bringe den hen for HERRENS Åsyn ");
INSERT INTO dan1931_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","og lægge sin Hånd på dens Hoved og slagte den foran Åbenbaringsteltet, og Arons Sønner skal sprænge Blodet rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Så skal han deraf frembære som sin Offergave, som et Ildoffer for HERREN, Fedtet, det dækker Indvoldene, og alt Fedtet på Indvoldene, ");
INSERT INTO dan1931_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","begge Nyrerne med det Fedt, som sidder på dem ved Lændemusklerne, og Leverlappen, som han skal skille fra ved Nyrerne. ");
INSERT INTO dan1931_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Og Præsten skal bringe det som Røgoffer på Alteret, Ildofferspise til en liflig Duft. Alt Fedt skal være HERRENS. ");
INSERT INTO dan1931_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","En evig Anordning skal det være for eder fra Slægt til Slægt, hvor I end bor: Intet Fedt og intet Blod må I nyde! ");
INSERT INTO dan1931_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Tal til Israelitterne og sig: Når nogen af Vanvare forsynder sig mod noget af HERRENS Forbud og overtræder et af dem, da skal følgende iagttages: ");
INSERT INTO dan1931_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Er det den salvede Præst*, der forsynder sig, så der pådrages Folket Skyld, skal han for den Synd, han har begået, bringe HERREN en lydefri ung Tyr som Syndoffer. { *dvs. Ypperstepræsten. } ");
INSERT INTO dan1931_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Han skal føre Tyren hen til Åbenbaringsteltets Indgang for HERRENS Åsyn og lægge sin Hånd på dens Hoved og slagte den for HERRENS Åsyn, ");
INSERT INTO dan1931_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","og den salvede Præst skal tage noget af Tyrens Blod og bringe det ind i Åbenbaringsteltet, ");
INSERT INTO dan1931_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","og Præsten skal dyppe sin Finger i Blodet og stænke det syv Gange for HERRENS Åsyn foran Helligdommens Forhæng*; { *dvs. Forhænget mellem det Hellige og det Allerhelligste. } ");
INSERT INTO dan1931_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","og Præsten skal stryge noget af Blodet på Røgelsealterets Horn for HERRENS Åsyn, det, som står i Åbenbaringsteltet; Resten af Tyrens Blod skal han udgyde ved Foden af Brændofferalteret, som står ved Indgangen til Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Men alt Syndoffertyrens Fedt skal han tage ud Fedtet, som dækker Indvoldene, og alt Fedtet på Indvoldene, ");
INSERT INTO dan1931_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","begge Nyrerne med det Fedt, som sidder på dem ved Lændemusklerne, og Leverlappen, som han skal skille fra ved Nyrerne, ");
INSERT INTO dan1931_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","på samme Måde som det udtages af Takofferoksen. Og Præsten skal bringe det som Røgoffer på Brændofferalteret. ");
INSERT INTO dan1931_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Men Tyrens Hud og alt dens Kød tillige med dens Hoved, Skinneben, Indvolde og Skarn, ");
INSERT INTO dan1931_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","hele Tyren skal han bringe uden for Lejren til et urent Sted, til Askedyngen, og brænde den på et Bål af Brænde; oven på Aske; dyngen skal den brændes. ");
INSERT INTO dan1931_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Men hvis det et hele Israels Menighed, der forser sig, uden at Forsamlingen ved af det, og de har overtrådt et af HERRENS Forbud og derved pådraget sig Skyld, ");
INSERT INTO dan1931_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","da skal Forsamlingen, når den Synd, de har begået mod Forbudet, bliver kendt, bringe en ung, lydefri Tyr som Syndoffer; de skal føre den hen foran Åbenbaringsteltet, ");
INSERT INTO dan1931_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","og Menighedens Ældste skal lægge deres Hænder på Tyrens Hoved for HERRENS Åsyn, og man skal slagte den for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Derpå skal den salvede Præst bringe noget af Tyrens Blod ind i Åbenbaringsteltet, ");
INSERT INTO dan1931_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","og Præsten skal dyppe sin Finger i Blodet og stænke det syv Gange for HERRENS Åsyn foran Forhænget; ");
INSERT INTO dan1931_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","og han skal stryge noget af Blodet på Hornene af Alteret, som står for HERRENS Åsyn i Åbenbaringsteltet; Resten af Blodet skal han udgyde ved Foden af Brændofferalteret, som står ved Indgangen til Åbenbaringsteltet, ");
INSERT INTO dan1931_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Men alt, Fedtet skal han tage ud og bringe det som Røgoffer på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Derpå skal han gøre med Tyren på samme Måde som med den før nævnte Syndoffertyr. Da skal Præsten skaffe dem Soning, så de finder Tilgivelse. ");
INSERT INTO dan1931_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Så skal Tyren bringes uden for Lejren og brændes på samme Måde som den før nævnte Tyr. Det er Menighedens Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Men hvis det er en Øverste. der forsynder sig og af Vanvare overtræder et af HERRENS Forbud og derved på drager sig Skyld, ");
INSERT INTO dan1931_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","og den Synd, han har begået, bliver ham vitterlig, så skal den Offergave, han bringer, være en lydefri Gedebuk. ");
INSERT INTO dan1931_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Han skal lægge sin Hånd på Bukkens Hoved og slagte den der, hvor Brændofferet slagtes for HERRENS Åsyn. Det er et Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Præsten skal tage noget af Syndofferets Blod på sin Finger og stryge det på Brændofferalterets Horn, og Resten af Blodet skal han udgyde ved Brændofferalterets Fod. ");
INSERT INTO dan1931_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Og alt dets Fedt skal han bringe som Røgoffer på Alteret ligesom Fedtet fra Takofferet. Da skal Præsten skaffe ham Soning for hans Synd, så han finder Tilgivelse. ");
INSERT INTO dan1931_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Men hvis det er en af Almuen, der af Vanvare forsynder sig ved at overtræde et af HERRENS Forbud og derved pådrager sig Skyld, ");
INSERT INTO dan1931_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","og den Synd, han har begået, bliver ham vitterlig, så skal Offergaven, han bringer for den Synd, han har begået, være en lydefri Ged. ");
INSERT INTO dan1931_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Han skal lægge sin Hånd på Syndofferets Hoved og slagte Syndofferet der, hvor Brændofferet slagtes. ");
INSERT INTO dan1931_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Præsten skal tage noget af Gedens Blod på sin Finger og stryge det på Brændofferalterets Horn, og Resten af Blodet skal han udgyde ved Alterets Fod. ");
INSERT INTO dan1931_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Og alt Fedtet skal han tage ud, på samme Måde som Fedtet tages ud af Takofferet, og Præsten skal bringe det som Røgoffer på Alteret til en liflig Duft for HERREN. Da skal Præsten skaffe ham Soning, så han finder Tilgivelse. ");
INSERT INTO dan1931_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Men hvis den Offergave, han vil bringe som Syndoffer, er et Lam, da skal det være et lydefrit Hundyr, han bringer. ");
INSERT INTO dan1931_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Han skal lægge sin Hånd på Syndofferets Hoved og slagte det som Syndoffer der, hvor Brændofferet slagtes. ");
INSERT INTO dan1931_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Og Præsten skal tage noget af Syndofferets Blod på sin Finger og stryge det på Brændofferalterets Horn, men Resten af Blodet skal han udgyde ved Alterets fod, ");
INSERT INTO dan1931_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","og alt Fedtet skal han tage ud, på samme Måde som Takofferlammets Fedt tages ud, og Præsten skal bringe det som Røgoffer på Alteret oven på HERRENS Ildofre. Da skal Præsten skaffe ham Soning for den Synd, han har begået, så han finder Tilgivelse. ");
INSERT INTO dan1931_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Hvis nogen, når han hører en Forbandelse* udtale, synder ved at undlade at vidne, skønt han var Øjenvidne eller på anden Måde kender Sagen, og således pådrager sig Skyld, { *nemlig når en, der vil have en Sag opklaret, ved en Forbandelse søger at tvinge dem, der ved Besked, til at udtale sig. } ");
INSERT INTO dan1931_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","eller hvis nogen, uden at det er ham vitterligt, rører ved noget urent, hvad enten det nu er et Ådsel af et urent vildt Dyr eller af urent Kvæg eller urent Kryb, og han opdager det og bliver sig sin Skyld bevidst, ");
INSERT INTO dan1931_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","eller når han, uden at det er ham vitterligt, rører ved Urenhed hos et Menneske, Urenhed af en hvilken som helst Art, hvorved man bliver uren, og han opdager det og bliver sig sin Skyld bevidst, ");
INSERT INTO dan1931_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","eller når nogen, uden at det er ham vitterligt, med sine Læber aflægger en uoverlagt Ed på at ville gøre noget, godt eller ondt, hvad nu et Menneske kan aflægge en uoverlagt Ed på, og han opdager det og bliver sig sin Skyld bevidst i et af disse Tilfælde, ");
INSERT INTO dan1931_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","så skal han, når han bliver sig sin Skyld bevidst i et af disse Tilfælde, bekende det, han har forsyndet sig med, ");
INSERT INTO dan1931_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","og til Bod for den Synd, han har begået, bringe HERREN et Hundyr af Småkvæget, et Får eller en Ged, som Syndoffer; da skal Præsten skaffe ham Soning for hans Synd. ");
INSERT INTO dan1931_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Men hvis han ikke evner at give et Stykke Småkvæg, skal han til Bod for sin Synd bringe HERREN to Turtelduer eller Dueunger, en som Syndoffer og en som Brændoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Han skal bringe dem til Præsten, og Præsten skal først frembære den, der skal bruges til Syndoffer; han skal knække Halsen på den ved Nakken uden at rive Hovedet helt af ");
INSERT INTO dan1931_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","og stænke noget af Syndofferets Blod på Alterets Side, medens Resten af Blodet skal udpresses ved Alterets Fod. Det er et Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Men den anden skal han ofre som Brændoffer på den foreskrevne Måde; da skal Præsten skaffe ham Soning for den Synd, han har begået, så han finder Tilgivelse. ");
INSERT INTO dan1931_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Men hvis han ej heller evner at give to Turtelduer eller Dueunger, skal han som Offergave for sin Synd bringe en Tiendedel Efa fint Hvedemel til Syndoffer, men han må ikke hælde Olie derover eller komme Røgelse derpå, thi det er et Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Han skal bringe det til Præsten, og Præsten skal tage en Håndfuld deraf, det, som skal ofres deraf, og bringe det som Røgoffer på Alteret oven på HERRENS Ildofre. Det er et Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Da skal Præsten skaffe ham Soning for den Synd, han har begået på en af de nævnte Måder, så han finder Tilgivelse. Resten skal tilfalde Præsten på samme Måde som Afgrødeofferet. ");
INSERT INTO dan1931_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Når nogen gør sig skyldig i Svig og af Vanvare forsynder sig mod HERRENS Helliggaver, skal han til Bod derfor som Skyldoffer bringe HERREN en lydefri Vædder af Småkvæget, der er vurderet til mindst to Sølvsekel efter hellig Vægt*; { *rimeligvis den fulde Vægt i modsetning til den gængse Vægt, der ofte var mindre. } ");
INSERT INTO dan1931_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","og han skal give Erstatning for, hvad han har forsyndet sig med over for det hellige, med Tillæg af en Femtedel af Værdien. Han skal give Præsten det, og Præsten skal skaffe ham Soning ved Skyldoffervædderen, så han finder Tilgivelse. ");
INSERT INTO dan1931_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Når nogen, uden at det er ham vitterligt, synder ved at overtræde et af HERRENS Forbud, så han bliver skyldig og pådrager sig Skyld, ");
INSERT INTO dan1931_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","da skal han af Småkvæget bringe en lydefri Vædder, der er taget god, som Skyldoffer til Præsten, og Præsten skal skaffe ham Soning for den uforsætlige Synd, han har begået, uden at den var ham vitterlig, så han finder Tilgivelse. ");
INSERT INTO dan1931_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Det er et Skyldoffer; han har pådraget sig Skyld over for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","Når nogen forsynder sig og gør sig skyldig i Svig mod HERREN, idet han frakender sin Næste Retten til noget, der var ham betroet, et Håndpant eller noget, han har røvet, eller han aftvinger sin Næste noget, ");
INSERT INTO dan1931_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","eller han finder noget, som er tabt, og nægter det, eller han aflægger falsk Ed angående en af alle de Ting, som Mennesket forsynder sig ved at gøre, ");
INSERT INTO dan1931_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","så skal han, når han har forsyndet sig og føler sig skyldig, tilbagegive det, han har røvet, eller det, han har aftvunget, eller det, som var ham betroet, eller det tabte, som han har fundet, ");
INSERT INTO dan1931_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","eller alt det, hvorom han har aflagt falsk Ed; han skal erstatte det med dets fulde Værdi med Tillæg af en Femtedel. Han skal give den retmæssige Ejer det, den Dag han gør Bod. ");
INSERT INTO dan1931_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Og til Bod skal han af Småkvæget bringe HERREN en lydefri Vædder, der er taget god; som Skyldoffer skal han bringe den til Præsten. ");
INSERT INTO dan1931_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Da skal Præsten skaffe ham Soning for HERRENS Åsyn, så han finder Tilgivelse for enhver Ting, hvorved man pådrager sig Skyld. ");
INSERT INTO dan1931_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","HERREN taled fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Giv Aron og hans Sønner dette Bud: Dette er Loven om Brændofferet. Brændofferet skal blive liggende på sit Bål på Alteret Natten over til næste Morgen, og Alterilden skal holdes ved lige dermed. ");
INSERT INTO dan1931_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Så skal Præsten iføre sig sin Linnedklædning, og Linnedbenklæder skal han iføre sig over sin Blusel, og han skal borttage Asken, som bliver tilbage, når Ilden fortærer Brændofferet på Alteret, og lægge den ved Siden af Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Derefter skal han afføre sig sine Klæder og tage andre Klæder på og bringe Asken uden for Lejren til et urent Sted. ");
INSERT INTO dan1931_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Ilden på Alteret skal holdes ved lige dermed, den må ikke gå ud: og Præsten skal hver Morgen tænde ny Brændestykker på Alteret og lægge Brændofferet til Rette derpå og så bringe Takofrenes Fedtdele som Røgoffer derpå. ");
INSERT INTO dan1931_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","En stadig Ild skal holdes ved lige på Alteret, den må ikke gå ud. ");
INSERT INTO dan1931_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Dette er Loven om Afgrødeofferet: Arons Sønner skal frembære det for HERRENS Åsyn, hen til Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Så skal han tage en Håndfuld af Afgrødeofferets Mel og Olie og al Røgelsen, der følger med Afgrødeofferet, det, der skal ofres deraf, og bringe det som Røgoffer på Alteret til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Men Resten deraf skal Aron og hans Sønner spise; usyret skal det spises på et helligt Sted; i Åbenbaringsteltets Forgård skal de spise det. ");
INSERT INTO dan1931_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Det må ikke bages syret. Jeg har givet dem det som deres Del af mine Ildofre; det er højhelligt ligesom Syndofferet og Skyldofferet. ");
INSERT INTO dan1931_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Alle af Mandkøn blandt Arons Sønner må spise det; denne Del af HERRENS Ildofre skal være en evig gyldig Rettighed, de har Krav på fra Slægt til Slægt. Enhver, som rører derved, bliver hellig. ");
INSERT INTO dan1931_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Dette er den Offergave, Aron og hans Sønner skal frembære for HERREN: En Tiendedel Efa fint Hvedemel, et dagligt Afgrødeoffer, Halvdelen om Morgenen og Halvdelen om Aftenen. ");
INSERT INTO dan1931_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Det skal tilberedes på Plade med Olie, og du skal frembære det godt æltet, og du skal bryde det i Stykker; et Afgrødeoffer, som er brudt i Stykker, skal du frembære til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Den Præst iblandt hans Sønner, der salves i hans Sted, skal ofre det; det skal være en evig gyldig Rettighed for HERREN, og som Heloffer skal det ofres. ");
INSERT INTO dan1931_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ethvert Afgrødeoffer fra en Præst skal være et Heloffer; det må ikke spises. ");
INSERT INTO dan1931_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Tal til Aron og hans Sønner og sig: Dette er Loven om Syndofferet. Der, hvor Brændofferet slagtes. skal Syndofferet slagtes for HERRENS Åsyn; det er højhelligt. ");
INSERT INTO dan1931_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Den Præst, der frembærer Syndofferet, skal spise det; det skal spises på et helligt Sted, i Åbenbaringsteltets Forgård. ");
INSERT INTO dan1931_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Enhver, som rører ved Kødet deraf, bliver hellig. Hvis noget af dets Blod stænkes på en Klædning, skal det Stykke, Blodet er stænket på, tvættes på et helligt Sted. ");
INSERT INTO dan1931_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Det Lerkar, det koges i, skal slås i Stykker; og hvis det er kogt i et Kobberkar, skal dette skures og skylles med Vand. ");
INSERT INTO dan1931_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Alle af Mandkøn blandt Præsterne må spise det; det er højhelligt. ");
INSERT INTO dan1931_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Men intet Syndoffer må spises, når noget af dets Blod bringes ind i Åbenbaringsteltet for at skaffe Soning i Helligdommen; det skal opbrændes. ");
INSERT INTO dan1931_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Dette er Loven om Skyldofferet. Det er højhelligt. ");
INSERT INTO dan1931_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Der, hvor Brændofferet slagtes, skal Skyldofferet slagtes. Dets Blod skal sprænges rundt om på Alteret, ");
INSERT INTO dan1931_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","og alt dets Fedt skal frembæres. Fedthalen, Fedtet, der dækker Indvoldene, og alt Fedtet på Indvoldene, ");
INSERT INTO dan1931_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","begge Nyrerne med det Fedt, som sidder på dem ved Lændemusklerne, og Leverlappen, som skal skilles fra ved Nyrerne. ");
INSERT INTO dan1931_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Og Præsten skal bringe det som Røgoffer på Alteret, et Ildoffer for HERREN. Det er et Skyldoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Alle af Mandkøn blandt Præsterne må spise det; på et helligt Sted skal det spises; det er højhelligt. ");
INSERT INTO dan1931_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Det er med Skyldofferet som med Syndofferet, en og samme Lov gælder for dem: Det tilfalder den Præst, der skaffer Soning ved det. ");
INSERT INTO dan1931_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Den Præst, som frembærer nogens Brændoffer, ham skal Huden af det Brændoffer, han frembærer, tilfalde. ");
INSERT INTO dan1931_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ethvert Afgrødeoffer, der bages i Ovnen, eller som er tilberedt i Pande eller på Plade, tilfalder den Præst, der frembærer det; ");
INSERT INTO dan1931_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","men ethvert Afgrødeoffer, der er rørt i Olie eller tørt, tilfalder alle Arons Sønner, den ene lige så vel som den anden. ");
INSERT INTO dan1931_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Dette er Loven om Takofferet, som bringes HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Hvis det bringes som Lovprisningsoffer, skal han sammen med Slagtofferet, der hører til hans Lovprisningsoffer, frembære usyrede Kager, rørte i Olie, usyrede Fladbrød, smurte med Olie, og fint Hvedemel, æltet til Kager, rørte i Olie; ");
INSERT INTO dan1931_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","sammen med syrede Brødkager skal han frembære sin Offergave som sit Lovprisningstakoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Han skal deraf frembære én Kage af hver Offergave som en Offerydelse til HERREN; den tilfalder den Præst, der sprænger Blodet af Takofferet på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Kødet af hans Lovprisningstakoffer skal spises på selve Offerdagen, intet deraf må gemmes til næste Morgen. ");
INSERT INTO dan1931_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Er hans Offergaver derimod et Løfteoffer eller et Frivilligoffer, skal det vel spises på selve Offerdagen, men hvad der levnes, må spises Dagen efter; ");
INSERT INTO dan1931_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","men hvad der så er tilbage af Offerkødet, skal opbrændes på den tredje Dag; ");
INSERT INTO dan1931_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","og hvis der spises noget af hans Takoffers Kød på den tredje Dag, så vil den, som bringer Offeret, ikke kunne finde Guds Velbehag, det skal ikke tilregnes ham*, men regnes for urent Kød, og den, der spiser deraf, skal undgælde for sin Brøde. { *som bragt Offer. } ");
INSERT INTO dan1931_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Det Kød, der kommer i Berøring med noget som helst urent, må ikke spises, det skal opbrændes. I øvrigt må enhver, der er ren, spise Kødet; ");
INSERT INTO dan1931_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","men enhver, som i uren Tilstand spiser Kød af HERRENS Takoffer, skal udryddes af sin Slægt; ");
INSERT INTO dan1931_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","og når nogen rører ved noget urent, enten menneskelig Urenhed eller urent Kvæg eller nogen Slags urent Kryb, og så spiser Kød af HERRENS Takoffer, skal han udryddes af sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Tal til Israelitterne og sig: I må ikke spise noget som helst Fedt af Okser, Får eller Geder. ");
INSERT INTO dan1931_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Fedt af selvdøde og sønderrevne Dyr må bruges til alt, men I må under ingen Omstændigheder spise det. ");
INSERT INTO dan1931_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Thi enhver, der spiser Fedtet af det Kvæg, hvoraf der bringes HERREN Ildofre, den, der spiser noget deraf, skal udryddes af sit Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Og I må heller ikke nyde noget som helst Blod af Fugle eller Kvæg, hvor I end opholder eder; ");
INSERT INTO dan1931_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","enhver, der nyder noget som helst Blod, skal udryddes af sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Tal til Israelitterne og sig: Den, der bringer HERREN sit Takoffer, skal af sit Takoffer frembære for HERREN den ham tilkommende Offergave; ");
INSERT INTO dan1931_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","med egne Hænder skal han frembære HERRENS Ildofre. Han skal frembære Fedtet tillige med Brystet; Brystet, for at Svingningen kan udføres dermed for HERRENS Åsyn; ");
INSERT INTO dan1931_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","og Præsten skal bringe Fedtet som Røgoffer på Alteret, men Brystet skal tilfalde Aron og hans Sønner. ");
INSERT INTO dan1931_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Desuden skal I give Præsten højre Kølle som Offerydelse af eders Takofre. ");
INSERT INTO dan1931_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Den af Arons Sønner, der frembærer Takofferets Blod og Fedtet, ham tilfalder højre Kølle som hans Del. ");
INSERT INTO dan1931_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Thi Svingningsbrystet og Offerydelseskøllen tager jeg fra Israelitterne af deres Takofre og giver dem til Præsten Aron og hans Sønner, en evig gyldig Rettighed, som de har Krav på hos Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Det er Arons og hans Sønners Del af HERRENS Ildofre, den, som blev givet dem, den dag han lod dem træde frem for at gøre Præstetjeneste for HERREN, ");
INSERT INTO dan1931_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","den, som HERREN, den Dag han salvede dem, bød Israelitterne at give dem, en evig gyldig Rettighed, som de har Krav på fra Slægt til Slægt. ");
INSERT INTO dan1931_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Det er Loven om Brændofferet, Afgrødeofferet, Syndofferet, Skyldofferet, Indsættelsesofferet og Takofferet, ");
INSERT INTO dan1931_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","som HERREN pålagde Moses på Sinaj Bjerg, den Dag han bød Israelitterne at bringe HERREN deres Offergaver i Sinaj Ørken. ");
INSERT INTO dan1931_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Tag Aron og hans Sønner sammen med ham, Klæderne, Salveolien, Syndoffertyren, de to Vædre og Kurven med de usyrede Brød ");
INSERT INTO dan1931_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","og kald hele Menigheden sammen ved indgangen til Åbenbaringsteltet!” ");
INSERT INTO dan1931_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moses gjorde som HERREN bød ham, og Menigheden forsamlede sig ved Indgangen til Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Og Moses sagde til Menigheden: “Dette har HERREN påbudt at gøre.” ");
INSERT INTO dan1931_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Da lod Moses Aron og hans Sønner træde frem og tvættede dem med Vand. ");
INSERT INTO dan1931_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Og han gav ham Kjortelen på, omgjordede ham med Bæltet, iførte ham Kåben, gav ham Efoden på, omgjordede ham med Efodens Bælte og bandt dermed Efoden fast på ham; ");
INSERT INTO dan1931_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","så anbragte han Brystskjoldet på ham, lagde Urim og Tummim i Brystskjoldet, ");
INSERT INTO dan1931_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","lagde Hovedklædet om hans Hoved og fæstede Guldpladen, det hellige Diadem, på Forsiden af Hovedklædet, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Derpå tog Moses Salveolien og salvede Boligen og alle Tingene deri og helligede dem; ");
INSERT INTO dan1931_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","så bestænkede han Alteret syv Gange dermed og salvede Alteret og alt dets Tilbehør og Vandkummen med dens Fodstykke for at hellige dem; ");
INSERT INTO dan1931_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","derpå udgød han. noget af Salveolien over Arons Hoved og salvede ham for at hellige ham. ");
INSERT INTO dan1931_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Derefter lod Moses Arons Sønner træde frem, iførte dem Kjortler, omgjordede dem med Bælter og bandt Huer på deres Hoveder, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Så førte han Syndoffertyren frem, og Aron og hans Sønner lagde deres Hænder lå Syndoffertyrens Hoved. ");
INSERT INTO dan1931_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Derefter slagtede Moses den, tog Blodet og strøg med sin Finger noget deraf rundt om på Alterets Horn og rensede Alteret for Synd; men Resten af Blodet udgød han ved Alterets Fod; således helligede han det ved at skaffe Soning for det. ");
INSERT INTO dan1931_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Så tog Moses alt Fedtet på Indvoldene, Leverlappen og begge Nyrerne med Fedtet på dem og bragte det som Røgoffer på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Men Tyren, dens Hud, Kød og Skarn, brændte han uden for Lejren, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Derpå førte han Brændoffervædderen frem, og Aron og hans Sønner lagde deres Hænder på Vædderens Hoved. ");
INSERT INTO dan1931_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Så slagtede Moses den og sprængte Blodet rundt om på Alteret; ");
INSERT INTO dan1931_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","og Moses skar Vædderen i Stykker og bragte Hovedet, Stykkerne og Fedtet som Røgoffer, ");
INSERT INTO dan1931_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","men Indvoldene og Skinnebenene tvættede han med Vand; og så bragte Moses hele Vædderen som Røgoffer på Alteret. Det var et Brændoffer til en liflig Duft, et Ildoffer for HERREN, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Derpå førte han den anden Vædder, Indsættelsesvædderen, frem, og Aron og hans Sønner lagde deres Hænder på Vædderens Hoved. ");
INSERT INTO dan1931_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Så slagtede Moses den, tog noget af dens Blod og strøg det på Arons højre Øreflip og på hans højre Tommelfinger og højre Tommeltå. ");
INSERT INTO dan1931_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Derpå lod Moses Arons Sønner træde frem og strøg noget af Blodet på deres højre Øreflip og på deres højre Tommelfinger og højre Tommeltå, Men Resten af Blodet sprængte han rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Derpå tog han Fedtet, Fedthalen, alt Fedtet på Indvoldene, Leverlappen og begge Nyrerne med Fedtet på dem og den højre Kølle: ");
INSERT INTO dan1931_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Og af Kurven med de usyrede Brød, som stod for HERRENS Åsyn, tog han en usyret Kage, en Oliebrødkage og et Fladbrød og lagde dem oven på Fedtstykkerne og den højre Kølle, ");
INSERT INTO dan1931_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","lagde det så alt sammen på Arons og hans Sønners Hænder og lod dem udføre Svingningen dermed for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Derpå tog Moses det igen fra dem og bragte det som Røgoffer på Alteret oven på Brændofferet. Det var et Indsættelsesoffer til en liflig Duft, et Ildoffer for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Så tog Moses Brystet og udførte Svingningen dermed for HERRENS Åsyn; det tilfaldt Moses som hans Del af Indsættelsesvædderen, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Derefter tog Moses noget af Salveolien og af Blodet på Alteret og stænkede det på Aron og hans Klæder, ligeledes på hans Sønner og deres Klæder, og helligede således Aron og hans Klæder og ligeledes hans Sønner og deres Klæder. ");
INSERT INTO dan1931_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Og Moses sagde til Aron og hans Sønner: “Kog Kødet ved indgangen til Åbenbaringsteltet og spis det der tillige med Brødet, som er i Indsættelseskurven, således som Budet lød til mig: Aron og hans Sønner skal spise det! ");
INSERT INTO dan1931_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Men hvad der levnes af Kødet og Brødet skal I opbrænde. ");
INSERT INTO dan1931_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","I syv Dage må I ikke vige fra Indgangen til Åbenbaringsteltet, indtil eders Indsættelsesdage er omme; thi syv Dage varer eders Indsættelse. ");
INSERT INTO dan1931_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ligesom i Dag har HERREN påbudt eder at gøre også de følgende Dage for at skaffe eder Soning. ");
INSERT INTO dan1931_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ved Indgangen til Åbenbaringsteltet skal I opholde eder Dag og Nat i syv Dage og holde eder HERRENS Forskrift efterrettelig, for at I ikke skal dø; thi således lød hans Bud til mig!” ");
INSERT INTO dan1931_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Og Aron og hans Sønner gjorde alt, hvad HERREN havde påbudt ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Den ottende Dag kaldte Moses Aron og hans Sønner og Israels Ældste til sig ");
INSERT INTO dan1931_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","og sagde til Aron: “Tag dig en Kalv til Syndoffer og en Vædder til Brændoffer, begge uden Lyde, og før dem frem for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Og tal således til Israelitterne: Tag eder en Gedebuk til Syndoffer, en Kalv og et Lam, begge årgamle og uden Lyde, til Brændoffer ");
INSERT INTO dan1931_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","og en Okse og en Vædder til Takoffer for at ofre dem for HERRENS Åsyn og desuden et Afgrødeoffer, rørt i Olie; thi i Dag vil HERREN vise sig for eder!” ");
INSERT INTO dan1931_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Da tog de, hvad Moses havde pålagt dem, og bragte det hen foran Åbenbaringsteltet; og hele Menigheden trådte frem og stillede sig for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Og Moses sagde: “Det er dette, HERREN har pålagt eder at gøre, for at HERRENS Herlighed kan vise sig for eder.” ");
INSERT INTO dan1931_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Så sagde Moses til Aron: “Træd hen til Alteret og bring dit Syndoffer og dit Brændoffer for at skaffe dig og dit Hus Soning og bring så Folkets Offergave for at skaffe det Soning, således som HERREN har påbudt!” ");
INSERT INTO dan1931_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Da trådte Aron hen til Alteret og slagtede sin Syndofferkalv; ");
INSERT INTO dan1931_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","og Arons Sønner bragte ham Blodet, og han dyppede sin Finger i Blodet og strøg det på Alterets Horn; men Resten af Blodet hældte han ud ved Alterets Fod. ");
INSERT INTO dan1931_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Derpå bragte han Syndofferets Fedt, Nyrer og Leverlap som Røgoffer på Alteret, således som HERREN havde pålagt Moses; ");
INSERT INTO dan1931_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","men Kødet og Huden opbrændte han uden for Lejren. ");
INSERT INTO dan1931_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Derefter slagtede han Brændofferet, og Arons Sønner rakte ham Blodet, og han sprængte det rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Så rakte de ham Brændofferet, Stykke for Stykke, tillige med Hovedet, og han bragte det som Røgoffer på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Men Indvoldene og Skinnebenene tvættede han med Vand og bragte det derpå som Røgoffer oven på Brændofferet på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Derefter frembar han Folkets Offergave. Først tog han Folkets Syndofferbuk, slagtede den og ofrede den som Syndoffer på samme Måde som den før nævnte*; { *dvs. den V. 3 omtalede Syndofferbuk. } ");
INSERT INTO dan1931_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","så frembar han Brændofferet og ofrede det på den foreskrevne Måde; ");
INSERT INTO dan1931_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","derefter frembar han Afgrødeofferet, tog en Håndfuld deraf og bragte det som Røgoffer på Alteret foruden det daglige Morgenbrændoffer; ");
INSERT INTO dan1931_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","så slagtede han Oksen og Vædderen som Takoffer fra Folket. Og Arons Sønner rakte ham Blodet, og han sprængte det rundt om på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Men Fedtstykkerne af Oksen og Vædderen, Fedthalen, Fedtet på Indvoldene, Nyrerne og Leverlappen, ");
INSERT INTO dan1931_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","disse Fedtdele lagde de oven på Bryststykkerne, og Fedtstykkerne bragte han som Røgoffer på Alteret, ");
INSERT INTO dan1931_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","men med Bryststykkerne og højre Kølle udførte Aron Svingningen for HERRENS Åsyn, som Moses havde påbudt. ");
INSERT INTO dan1931_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Derefter løftede Aron sine Hænder over Folket og velsignede dem og steg så ned efter at have bragt Syndofferet, Brændofferet og Takofferet. ");
INSERT INTO dan1931_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses og Aron gik derpå ind i Åbenbaringsteltet, og da de kom ud derfra, velsignede de Folket. Da viste HERRENS Herlighed sig for alt Folket; ");
INSERT INTO dan1931_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","og Ild for ud fra HERRENS Åsyn og fortærede Brændofferet og Fedtstykkerne på Alteret. Og alt Folket så det, og de jublede og faldt ned på deres Ansigt. ");
INSERT INTO dan1931_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Men Arons Sønner Nadab og Abihu tog hver sin Pande, kom Ild i dem og lagde Røgelse derpå og frembar for HERRENS Åsyn fremmed Ild, som han ikke havde pålagt dem. ");
INSERT INTO dan1931_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Da for Ild ud fra HERRENS Åsyn og fortærede dem, så de døde for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moses sagde da til Aron: “Det er det, HERREN talede om, da han sagde: Jeg viser min Hellighed på dem, der står mig nær, og min Herlighed for alt Folkets Øjne!” Og Aron tav. ");
INSERT INTO dan1931_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Da kaldte Moses Misjael og Elzafan, Arons Farbroder, Uzziels Sønner, til sig og sagde til dem: “Kom og bær eders Frænder bort fra Helligdommen uden for Lejren!” ");
INSERT INTO dan1931_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Og de kom og bar dem uden for Lejren i deres Kjortler, som Moses havde sagt. ");
INSERT INTO dan1931_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Men Moses sagde til Aron og hans Sønner Eleazar og Itamar: “I må hverken lade eders Hår vokse frit eller sønderrive eders Klæder*, ellers skal I dø og Vrede komme over hele Menigheden; lad eders Brødre, hele Israels Hus, begræde den Brand, HERREN har antændt; { *som tegn på sorg. 3 Mos. 21, 1 ff. } ");
INSERT INTO dan1931_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","og vig ikke fra Åbenbaringsteltets indgang, ellers skal I dø, thi HERRENS Salveolie er på eder!” Og de gjorde som Moses sagde. ");
INSERT INTO dan1931_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Og HERREN talede til Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Vin og stærk Drik må hverken du eller dine Sønner drikke, når I gået ind i Åbenbaringsteltet, for at I ikke skal dø. Det skal være eder en evig gyldig Anordning fra Slægt til Slægt, ");
INSERT INTO dan1931_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","for at I kan gøre Skel mellem det hellige og det, der ikke er helligt, og mellem det urene og det rene, ");
INSERT INTO dan1931_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","og for at I kan vejlede Israelitterne i alle de Love, HERREN har kundgjort dem ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Og Moses sagde til Aron og hans tilbageblevne Sønner Eleazar og Itamar: “Tag Afgrødeofferet, der er levnet fra HERRENS Ildoffer*, og spis det usyret ved siden af Alteret, thi det er højhelligt; { *dvs. det 3 Mos. 9, 17 omtalte. } ");
INSERT INTO dan1931_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","I skal spise det på et helligt Sted; det er jo din og dine Sønners retmæssige Del af HERRENS Ildofre; thi således er det mig påbudt. ");
INSERT INTO dan1931_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Og Svingningsbrystet og Offerydelseskøllen skal I spise på et rent Sted, du, dine Sønner og Døtre, thi de er givet dig tillige med dine Sønner som en retmæssig Del af Israelitternes Takofre; ");
INSERT INTO dan1931_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Offerydelseskøllen og Svingningsbrystet skal man frembære sammen med de til Ildofre bestemte Fedtdele, for at Svingningen kan udføres for HERRENS Åsyn, og de skal tilfalde dig og dine Sønner tillige med dig som en evig gyldig Rettighed, således som HERREN har påbudt!” ");
INSERT INTO dan1931_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Og Moses spurgte efter Syndofferbukken, men se, den var opbrændt. Da blev han fortørnet på Eleazar og Itamar, Arons tilbageblevne Sønner, og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Hvorfor har I ikke spist Syndofferet på det hellige Sted? Det er jo dog højhelligt, og han har givet eder det. for at I skal borttage Menighedens Skyld og således skaffe dem Soning for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Se, Blodet deraf er ikke blevet bragt ind i Helligdommens Indre, derfor havde det været eders Pligt at spise det på det hellige Sted, således som jeg har påbudt!” ");
INSERT INTO dan1931_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Men Aron svarede Moses: “Se, de* har i Dag frembåret deres Syndoffer og Brændoffer for HERRENS Åsyn, og en sådan Tilskikkelse har ramt mig! Om jeg i Dag havde spist Syndofferkød, vilde HERREN da have billiget det?” { *dvs. Arons Sønner. } ");
INSERT INTO dan1931_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Da Moses hørte dette, billigede han det. ");
INSERT INTO dan1931_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","HERREN talede til Moses og Aron og sagde til dem: ");
INSERT INTO dan1931_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Tal til Israelitterne og sig: Af alle Dyr på Jorden må du spise følgende: ");
INSERT INTO dan1931_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Alle Dyr, der har Klove, helt spaltede Klove, og tygger Drøv, må I spise. ");
INSERT INTO dan1931_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Men følgende må I ikke spise af dem der tygger Drøv, og af dem, der har Klove: Kamelen, thi den tygger vel Drøv, men har ikke Klove; den skal være eder uren; ");
INSERT INTO dan1931_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Klippegrævlingen, thi den tygger vel Drøv, men har ikke Klove: den skal være eder uren; ");
INSERT INTO dan1931_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Haren, thi den tygger vel Drøv, men har ikke Klove; den skal være eder uren; ");
INSERT INTO dan1931_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Svinet, thi det har vel Klove, helt spaltede Klove, men tygger ikke Drøv; det skal være eder urent. ");
INSERT INTO dan1931_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Deres Kød må I ikke spise, og ved Ådslerne af dem må I ikke røre; de skal være eder urene. ");
INSERT INTO dan1931_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Af alt, hvad der lever i Vandet, må I spise følgende: Alt i Vandet, både i Havet og i Floderne, som har Finner og Skæl, må I spise; ");
INSERT INTO dan1931_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","men af alt, hvad der rører sig i Vandet, af alle levende Væsener i Vandet, skal det, som ikke har Finner eller Skæl, hvad enten det er i Havet eller Floderne, være eder en Vederstyggelighed. ");
INSERT INTO dan1931_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","De skal være eder en Vederstyggelighed, deres Kød må I ikke spise, og Ådslerne af dem skal I regne for en Vederstyggelighed. ");
INSERT INTO dan1931_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Alt i Vandet, som ikke har Finner eller Skæl, skal være eder en Vederstyggelighed. ");
INSERT INTO dan1931_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Følgende er de Fugle, I skal regne for en Vederstyggelighed, de må ikke spises, de er en Vederstyggelighed: Ørnen, Lammegribben, Havørnen, ");
INSERT INTO dan1931_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Glenten, de forskellige Arter af Falke, ");
INSERT INTO dan1931_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","alle de forskellige Arter af Ravne, ");
INSERT INTO dan1931_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Strudsen, Takmasfuglen, Mågen, de forskellige Arter af Høge, ");
INSERT INTO dan1931_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Uglen, Fiskepelikanen, Hornuglen, ");
INSERT INTO dan1931_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Tinsjemetfuglen, Pelikanen, Ådselgribben, ");
INSERT INTO dan1931_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Storken, de forskellige Arter af Hejrer, Hærfuglen og Flagermusen. ");
INSERT INTO dan1931_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alt vinget Kryb der går på fire, skal være eder en Vederstyggelighed. ");
INSERT INTO dan1931_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Af alt det vingede Kryb, som går på fire, må I dog spise følgende: Dem, der har Skinneben oven over Fødderne til at hoppe med på Jorden. ");
INSERT INTO dan1931_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Af dem må I spise følgende: De forskellige Arter af Græshopper, Solamgræshopper, Hargolgræshopper og Hagabgræshopper. ");
INSERT INTO dan1931_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Men alt andet vinget Kryb, der går på fire, skal være eder en Vederstyggelighed. ");
INSERT INTO dan1931_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ved følgende Dyr bliver I urene, enhver, der rører ved Ådslerne af dem, bliver uren til Aften, ");
INSERT INTO dan1931_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","og enhver, der bærer et Ådsel af dem, skal tvætte sine Klæder og være uren til Aften: ");
INSERT INTO dan1931_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Alle Dyr, der har Klove, men ikke helt spaltede, og som ikke tygger Drøv, skal være urene; enhver, der rører ved dem, bliver uren. ");
INSERT INTO dan1931_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Alle firføddede Dyr, der går på Poter, skal være eder urene; enhver der rører ved et Ådsel af dem, bliver uren til Aften, ");
INSERT INTO dan1931_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","og den, som bærer et Ådsel af dem, skal tvætte sine Klæder og være uren til Aften; de skal være eder urene. ");
INSERT INTO dan1931_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Af Krybet, der kryber på Jorden, skal følgende være eder urene: Væselen, Musen, de forskellige Arter af Firben, ");
INSERT INTO dan1931_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Anakaen, Koadyret, Leta'aen, Hometdyret og Tinsjemetdyret*. { *alle ukendte. } ");
INSERT INTO dan1931_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Det er dem, som skal være eder urene af alt Krybet. Enhver, der rører ved dem, når de er døde, skal være uren til Aften; ");
INSERT INTO dan1931_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","alt, hvad et dødt Dyr af den Slags falder ned på, bliver urent, alle Træting, Klæder, Skind, Sække, overhovedet alt, hvad der bruges ved et eller andet Arbejde; det skal lægges i Vand og være urent til Aften; derpå skal det være rent. ");
INSERT INTO dan1931_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Og falder et af den Slags ned i et Lerkar, så bliver alt, hvad der er deri, urent, og ethvert sådant Kar skal I slå i Stykker; ");
INSERT INTO dan1931_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","alt spiseligt, som man kommer Vand på, og alt flydende, der tjener til Drikke, bliver urent i et sådant Kar. ");
INSERT INTO dan1931_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Alt, hvad et dødt Dyr af den Slags falder ned på, bliver urent; Ovne og Ildsteder skal nedbrydes, de er urene, og urene skal de være eder. ");
INSERT INTO dan1931_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Dog bliver Kilder og Cisterner, Steder, hvor der samler sig Vand, ved at være rene; men den, der rører ved Ådslerne deri, bliver uren. ");
INSERT INTO dan1931_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Falder et dødt Dyr af den Slags ned på nogen som helst Slags Sæd, der bruges til Udsæd, bliver denne ved at være ren; ");
INSERT INTO dan1931_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","men kommes der Vand på Sæden, og der så falder et dødt Dyr af den Slags ned på den, skal den være eder uren. ");
INSERT INTO dan1931_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Når noget af det Kvæg, der tjener eder til Føde, dør, skal den, der rører ved den døde Krop, være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Den, der spiser noget af den døde Krop, skal tvætte sine Klædet og være uren til Aften, og den, der bærer den døde Krop, skal tvætte sine Klæder og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Alt Kryb, der kryber på Jorden, er en Vederstyggelighed, det må ikke spises; ");
INSERT INTO dan1931_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","intet af det, der kryber på Bugen, og intet af det, der går på fire, så lidt som det, der har mange Ben, intet af Krybet, der kryber på Jorden, må I spise thi det er en Vederstyggelighed. ");
INSERT INTO dan1931_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Gør ikke eder selv til en Vederstyggelighed ved noget som helst krybende Kryb, gør eder ikke urene derved, så I bliver urene deraf: ");
INSERT INTO dan1931_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","thi jeg er HERREN eders Gud, og I skal hellige eder og være hellige, thi jeg er hellig. Gør eder ikke urene ved noget som helst Kryb, der rører sig på Jorden; ");
INSERT INTO dan1931_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","thi jeg er HERREN, der førte eder op fra Ægypten for at være eders Gud; I skal være hellige, thi jeg er hellig! ");
INSERT INTO dan1931_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Det er Loven om Dyr og Fugle og alle levende Væsener, der bevæger sig i Vandet, og alle levende Væsener, der kryber på Jorden, ");
INSERT INTO dan1931_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","til Skel mellem det urene og det rene, mellem de Dyr, der må spises, og dem, der ikke må spises. ");
INSERT INTO dan1931_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Tal til Israelitterne og sig: Når en Kvinde bliver frugtsommelig og føder en Dreng, skal hun være uren i syv Dage; ligesom i den Tid hun har sin månedlige Urenhed, skal hun være uren. ");
INSERT INTO dan1931_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","På den ottende Dag skal Drengen omskæres på sin Forhud. ");
INSERT INTO dan1931_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Derefter skal hun holde sig hjemme i tre og tredive Dage, medens hun har sit Renselsesblod; hun må ikke røre ved noget helligt eller komme til Helligdommen, før hendes Renselsestid er omme. ");
INSERT INTO dan1931_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Føder hun derimod et Pigebarn, skal hun være uren i to Uger ligesom under sin månedlige Urenhed; og derpå skal hun holde sig hjemme i seks og tresindstyve Dage, medens hun har sit Renselsesblod. ");
INSERT INTO dan1931_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Når hendes Renselsestid er omme, skal hun, både efter et Drengebarn og et Pigebarn, bringe et årgammelt Lam som Brændoffer og en Dueunge eller Turteldue som Syndoffer til Præsten ved Åbenbaringsteltets Indgang; ");
INSERT INTO dan1931_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","og han skal frembære det for HERRENS Åsyn og skaffe hende Soning, så hun bliver ren efter sit Blodtab. Det er Loven om en Kvinde. der føder, hvad enten det er en Dreng eller en Pige. ");
INSERT INTO dan1931_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Men hvis hun ikke evner at give et Lam, skal hun tage to Turtelduer eller Dueunger, en til Brændoffer og en til Syndoffer, og Præsten skal skaffe hende Soning, så hun bliver ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Og HERREN talede til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Når der på et Menneskes Hud viser sig en Hævelse eller Udslæt eller en lys Plet, som kan blive til Spedalskhed på hans Hud, skal han føres hen til Præsten Aron eller en af hans Sønner, Præsterne. ");
INSERT INTO dan1931_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Præsten skal da syne det syge Sted på Huden, og når Hårene på det syge Sted er blevet hvide og Stedet ser ud til at ligge dybere end Huden udenom, så er det Spedalskhed, og så skal Præsten efter at have synet ham erklære ham for uren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Men hvis det er en hvid Plet på Huden og den ikke ser ud til at ligge dybere end Huden udenom og Hårene ikke er blevet hvide. så skal Præsten lukke den angrebne inde i syv Dage; ");
INSERT INTO dan1931_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","og på den syvende Dag skal Præsten syne ham. Viser det sig da, at Ondet ikke har skiftet Udseende eller bredt sig på Huden, skal Præsten igen lukke ham inde i syv Dage; ");
INSERT INTO dan1931_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","og på den syvende Dag skal Præsten atter syne ham. Hvis det da viser sig, at Ondet er ved at svinde, og at det ikke har bredt sig på Huden, skal Præsten erklære ham for ren; da er det almindeligt Udslæt på Huden; han skal da tvætte sine Klæder og være ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Men hvis Udslættet breder sig på Huden, efter at han har ladet Præsten syne sig for at blive erklæret for ren, og hvis Præsten, når han anden Gang lader sig syne af ham, ");
INSERT INTO dan1931_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ser, at Udslættet har bredt sig på Huden, så skal Præsten erklære ham for uren; det er Spedalskhed. ");
INSERT INTO dan1931_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Når et Menneske angribes af Spedalskhed, skal han føres hen til Præsten, ");
INSERT INTO dan1931_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","og Præsten skal syne ham; og når der da viser sig at være en hvid Hævelse på Huden og Hårene derpå er blevet hvide og der vokser vildt Kød i Hævelsen, ");
INSERT INTO dan1931_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","så er det gammel Spedalskhed på hans Hud, og da skal Præsten erklære ham for uren; han behøver ikke at lukke ham inde, thi han er uren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Men hvis Spedalskheden bryder ud på Huden og Spedalskheden bedækker hele den angrebnes Hud fra Top til Tå, så vidt Præsten kan se, ");
INSERT INTO dan1931_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","og Præsten ser, at Spedalskheden bedækker hele hans Legeme, så skal han erklære den angrebne for ren; han er blevet helt hvid, han er ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Men så snart der viser sig vildt Kød på ham, er han uren; ");
INSERT INTO dan1931_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","og når Præsten ser det vilde Kød, skal han erklære ham for uren; det vilde Kød er urent, det er Spedalskhed. ");
INSERT INTO dan1931_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Hvis derimod det vilde Kød forsvinder og han bliver hvid, skal han gå til Præsten; ");
INSERT INTO dan1931_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","og hvis det, når Præsten syner ham, viser sig, at den angrebne er blevet hvid, skal Præsten erklære den angrebne for ren; han er ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Når nogen på sin Hud har haft en Betændelse, som er lægt, ");
INSERT INTO dan1931_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","og der så på det Sted, som var betændt, kommer en hvid Hævelse eller en rødlighvid Plet, skal han lad sig syne af Præsten; ");
INSERT INTO dan1931_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","og hvis Præsten finder, at Stedet ser ud til at ligge dybere end Huden udenom og Hårene derpå er blevet hvide, skal Præsten erklære ham for uren; det er Spedalskhed, der er brudt frem efter Betændelsen. ");
INSERT INTO dan1931_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Men hvis der, når Præsten syner det, ikke viser sig at være hvide Hår derpå og det ikke ligger dybere end Huden udenom, men er ved at svinde, da skal Præsten lukke ham inde i syv Dage; ");
INSERT INTO dan1931_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","og når det da breder sig på Huden, skal Præsten erklære ham for uren; det er Spedalskhed. ");
INSERT INTO dan1931_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Men hvis den hvide Plet bliver, som den er, uden at brede sig, da er det et Ar efter Betændelsen, og Præsten skal erklære ham for ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Eller når nogen får et Brandsår på Huden, og det Kød, der vokser i Brandsåret, frembyder en rødlighvid eller hvid Plet, ");
INSERT INTO dan1931_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","så skal Præsten syne ham, og hvis det da viser sig, at Hårene på Pletten er blevet hvide og den ser ud til at ligge dybere end Huden udenom, så er det Spedalskhed, der er brudt frem i Brandsåret; og da skal Præsten erklære ham for uren; det er Spedalskhed. ");
INSERT INTO dan1931_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Men hvis det, når Præsten synet ham, viser sig, at der ingen hvide Hår er på den lyse Plet, og at en ikke ligger dybere end Huden udenom, men at den er ved at svinde, så skal Præsten lukke ham inde i syv Dage; ");
INSERT INTO dan1931_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","og på den syvende Dag skal Præsten syne ham, og når den da har bredt sig på Huden, skal Præsten erklære ham for uren; det er Spedalskhed. ");
INSERT INTO dan1931_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Men hvis den lyse Plet bliver, som den er, uden at brede sig på Huden, og er ved at svinde, så er det en Hævelse efter Brandsåret, og da skal Præsten erklære ham for ren; thi det er et Ar efter Brandsåret. ");
INSERT INTO dan1931_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Når en Mand eller Kvinde angribes i Hoved eller Skæg, ");
INSERT INTO dan1931_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","skal Præsten syne det syge Sted, og hvis det da ser ud til at ligge dybere end Huden udenom og der er guldgule, tynde Hår derpå, så skal Præsten erklære ham for uren; det er Skurv, Spedalskhed i Hoved eller Skæg. ");
INSERT INTO dan1931_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Men hvis det skurvede Sted, når Præsten syner det, ikke ser ud til at ligge dybere end Huden udenom, uden at dog Hårene derpå er sorte, da skal Præsten lukke den skurvede inde i syv dage; ");
INSERT INTO dan1931_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","og på den syvende Dag skal Præsten syne ham, og hvis da Skurven ikke har bredt sig og der ikke er kommet guldgule Hår derpå og Skurven ikke ser ud til at ligge dybere end Huden udenom, ");
INSERT INTO dan1931_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","da skal den angrebne lade sig rage uden dog at lade det skurvede Sted rage; så skal Præsten igen lukke den skurvede inde i syv Dage. ");
INSERT INTO dan1931_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","På den syvende Dag skal Præsten syne Skurven, og hvis det da viser sig, at Skurven ikke har bredt sig på Huden, og at den ikke ser ud til at ligge dybere end Huden udenom, så skal Præsten erklære ham for ren; da skal han tvætte sine Klæder og være ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Men hvis Skurven breder sig på Huden, efter at han er erklæret for ren, ");
INSERT INTO dan1931_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","da skal Præsten syne ham; og hvis det så viser sig, at Skurven har bredt sig, behøver Præsten ikke at undersøge, om der er guldgule Hår; han er uren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Men hvis Skurven ikke har skiftet Udseende og der er vokset sorte Hår frem derpå, da er Skurven lægt; han er ren, og Præsten skal erklære ham for ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Når en Mand eller Kvinde får lyse Pletter, hvide Pletter på Huden, ");
INSERT INTO dan1931_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","skal Præsten syne dem; og hvis der da på deres Hud viser sig hvide Pletter, det er ved at svinde, er det Blegner, der er brudt ud på Huden; han er ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Når nogen bliver skaldet på Baghovedet, så er han kun isseskaldet; han er ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Og hvis han bliver skaldet ved Panden og Tindingerne, så er han kun pandeskaldet; han er ren. ");
INSERT INTO dan1931_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Men kommer der på hans skaldede isse eller Pande et rødlighvidt Sted, er det Spedalskhed. der bryder frem på hans skaldede Isse eller Pande. ");
INSERT INTO dan1931_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Så skal Præsten syne ham, og viser det sig da, at Hævelsen på det syge Sted på hans skaldede Isse eller Pande er rødlighvid, af samme Udseende som Spedalskhed på Huden, ");
INSERT INTO dan1931_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","så er han spedalsk; han er uren, og Præsten skal erklære ham for uren; på sit Hoved er han angrebet. ");
INSERT INTO dan1931_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Den, der er spedalsk, den, som lider af Sygdommen, skal gå med sønderrevne Klæder, hans Hår skal vokse frit, han skal tilhylle sit Skæg, og: “uren, uren!” skal han råbe. ");
INSERT INTO dan1931_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Så længe han er angrebet, skal han være uren; uren er han, for sig selv skal han bo, uden for Lejren skal hans Opholdssted være. ");
INSERT INTO dan1931_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Når der kommer Spedalskhed på en Klædning enten af Uld eller Lærred ");
INSERT INTO dan1931_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","eller på vævet eller knyttet Stof af Lærred eller Uld eller på Læder eller Læderting af enhver Art ");
INSERT INTO dan1931_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","og det angrebne Sted på Klædningen, Læderet, det vævede eller knyttede Stof eller Lædertingene viser sig at være grønligt eller rødligt, så er det Spedalskhed og skal synes af Præsten. ");
INSERT INTO dan1931_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Og når Præsten har synet Skaden, skal han lukke den angrebne Ting inde i syv Dage. ");
INSERT INTO dan1931_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","På den syvende Dag skal han syne den angrebne Ting, og dersom Skaden har bredt sig på Klædningen, det vævede eller knyttede Stof eller Læderet, de forskellige Læderting, så er Skaden ondartet Spedalskhed, det er urent. ");
INSERT INTO dan1931_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Da skal han brænde Klædningen eller det af Uld eller Lærred vævede eller knyttede Stof eller alle de Læderting, som er angrebet; thi det er ondartet Spedalskhed, det skal opbrændes. ");
INSERT INTO dan1931_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Men hvis Præsten finder, at Skaden ikke har bredt sig på Klædningen eller det vævede eller knyttede Stof eller på de forskellige Slags Læderting, ");
INSERT INTO dan1931_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","så skal Præsten påbyde, at den angrebne Ting skal tvættes, og derpå igen lukke den inde i syv Dage. ");
INSERT INTO dan1931_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Præsten skal da syne den angrebne Ting, efter at den er tvættet, og viser det sig da, at Skaden ikke har skiftet Udseende, så er den uren, selv om Skaden ikke har bredt sig; du skal opbrænde den; det er ædende Udslæt på Retten eller Vrangen. ");
INSERT INTO dan1931_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Men hvis det, når Præsten syner det, viser sig, at Skaden er ved at svinde efter Tvætningen, så skal han rive det angrebne Sted af Klædningen eller Læderet eller det vævede eller knyttede Stof. ");
INSERT INTO dan1931_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Viser det sig da igen på Klædningen eller det vævede eller knyttede Stof eller de forskellige Læderting, da er det Spedalskhed, der er ved at bryde ud; du skal opbrænde de angrebne Ting. ");
INSERT INTO dan1931_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Men den Klædning eller det vævede eller knyttede Stof eller de forskellige Læderting, hvis Skade svinder efter Tvætningen, skal tvættes på ny; så er det rent. - ");
INSERT INTO dan1931_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Det er Loven om Spedalskhed på Klæder af Uld eller Lærred eller på vævet eller knyttet Stof eller på alskens Læderting; efter den skal de erklæres for rene eller urene. ");
INSERT INTO dan1931_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Dette er Loven om, hvorledes man skal forholde sig med Renselsen af en spedalsk: Han skal fremstilles for Præsten, ");
INSERT INTO dan1931_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","og Præsten skal gå uden for Lejren og syne ham, og viser det sig da, at Spedalskheden er helbredt hos den spedalske, ");
INSERT INTO dan1931_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","skal Præsten give Ordre til at tage to levende, rene Fugle, Cedertræ, karmoisinrødt Garn og en Ysopkvist til den, der skal renses. ");
INSERT INTO dan1931_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Og Præsten skal give Ordre til at slagte den ene Fugl over et Lerkar med rindende Vand. ");
INSERT INTO dan1931_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Så skal han tage den levende Fugl, Cedertræet, det karmoisinrøde Garn og Ysopkvisten og dyppe dem tillige med den levende Fugl i Blodet af den Fugl, der er slagtet over det rindende Vand, ");
INSERT INTO dan1931_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","og syv Gange foretage Bestænkning på den, der skal renses for Spedalskhed, og således rense ham; derpå skal han lade den levende Fugl flyve ud over Marken. ");
INSERT INTO dan1931_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Men den, der skal renses, skal tvætte sine Klæder, afrage alt sit Hår og bade sig i Vand; så er han ren. Derefter må han gå ind i Lejren, men han skal syv Dage opholde sig uden for sit Telt. ");
INSERT INTO dan1931_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","På den syvende Dag skal han afrage alt sit Hår, sit Hovedhår, sit Skæg, sine Øjenbryn, alt sit Hår skal han afrage, og han skal tvætte sine Klæder og bade sit Legeme i Vand; så er han ren. ");
INSERT INTO dan1931_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Men den ottende dag skal han tage to lydefri Vædderlam og et lydefrit, årgammelt Hunlam, desuden tre Tiendedele Efa fint Hvedemel, rørt i Olie, til Afgrødeoffer og en Log Olie. ");
INSERT INTO dan1931_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Så skal den Præst, der foretager Renselsen, stille den, der skal renses, tillige med disse Offergaver frem for HERRENS Åsyn ved Åbenbaringsteltets Indgang. ");
INSERT INTO dan1931_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Og Præsten skal tage det ene Vædderlam og frembære det som Skyldoffer tillige med den Log Olie, som hører dertil, og udføre Svingningen dermed for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Og han skal slagte Lammet der, hvor Syndofferet og Brændofferet slagtes, på det hellige Sted, thi ligesom Syndofferet tilfalder Skyldofferet Præsten; det er højhelligt. ");
INSERT INTO dan1931_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Derpå skal Præsten tage noget af Skyldofferets Blod, og Præsten skal stryge det på højre Øreflip af den, der skal renses, og på hans højre Tommelfinger og højre Tommeltå; ");
INSERT INTO dan1931_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","og Præsten skal tage noget af den Log Olie, som hører dertil, og hælde det i sin venstre Hånd, ");
INSERT INTO dan1931_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","og Præsten skal dyppe sin højre Pegefinger i den Olie, han har i sin venstre Hånd, og med sin Finger stænke Olien syv Gange foran HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Og af den Olie, han har tilbage i sin Hånd, skal Præsten stryge noget på højre Øreflip af den, der skal renses, og på hans højre Tommelfinger og højre Tommeltå oven på Skyldofferets Blod. ");
INSERT INTO dan1931_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Og Præsten skal hælde det, der er tilbage af Olien i hans Hånd, på Hovedet af den, der skal renses, og således skal Præsten skaffe ham Soning for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Derpå skal Præsten ofre Syndofferet og skaffe den, der skal renses, Soning for hans Urenhed. ");
INSERT INTO dan1931_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Og Præsten skal ofre Brændofferet og Afgrødeofferet på Alteret og således skaffe ham Soning; så er han ren. ");
INSERT INTO dan1931_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Men hvis han er fattig og ikke evner at give så meget, skal han tage et enkelt Lam til Skyldoffer. til at udføre Svingningen med, for at der kan skaffes ham Soning. desuden en Tiendedel Efa fint Hvedemel, rørt i Olie, til Afgrødeoffer og en Log Olie ");
INSERT INTO dan1931_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","og to Turtelduer eller Dueunger, hvad han nu evner at give, den ene skal være til Syndoffer, den anden til Brændoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Dem skal han den ottende Dag efter sin Renselse bringe til Præsten ved Åbenbaringsteltets Indgang for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Så skal Præsten tage Skyldofferlammet med den Log Olie, som hører dertil, og Præsten skal udføre Svingningen dermed for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Og han skal slagte Skyldofferlammet, og Præsten skal tage noget af Skyldofferets Blod og stryge det på højre Øreflip af den, der skal renses, og på hans højre Tommelfinger og højre Tommeltå. ");
INSERT INTO dan1931_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Og af Olien skal Præsten hælde noget i sin venstre Hånd, ");
INSERT INTO dan1931_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","og Præsten skal med sin højre Pegefinger syv Gange stænke noget af Olien, som er i hans venstre Hånd, for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Og af Olien, som er i hans Hånd, skal Præsten stryge noget på højre Øreflip af den, der skal renses, og på hans højre Tommelfinger og højre Tommeltå oven på Skyldofferets Blod. ");
INSERT INTO dan1931_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Og Resten af Olien, som er i hans Hånd, skal Præsten hælde på Hovedet af den, der skal renses, for at skaffe ham Soning for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Derpå skal han ofre den ene Turteldue eller Dueunge, hvad han nu har evnet at give, ");
INSERT INTO dan1931_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","den ene som Syndoffer, den anden som Brændoffer, sammen med Afgrødeofferet; og Præsten skal skaffe den, der skal renses, Soning for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Det er Loven om den, der har været angrebet af Spedalskhed og ikke evner at bringe det almindelige Offer ved sin Renselse. ");
INSERT INTO dan1931_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Og HERREN talede til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Når I kommer til Kana'ans Land, som jeg vil give eder i Eje, og jeg lader Spedalskhed komme frem på et Hus i eders Ejendomsland, ");
INSERT INTO dan1931_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","så skal Husets Ejer gå hen og melde det til Præsten og sige: “Der har i mit Hus vist sig noget, der ligner Spedalskhed!” ");
INSERT INTO dan1931_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Da skal Præsten give Ordre til at flytte alt ud af Huset, inden han kommer for at syne Pletten, for at ikke noget af, hvad der er i Huset, skal blive urent; derpå skal Præsten komme for at syne Huset. ");
INSERT INTO dan1931_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Viser det sig da, når han syner Pletten, at Pletten på Husets Vægge frembyder grønlige eller rødlige Fordybninger, der ser ud til at ligge dybere end Væggen udenom, ");
INSERT INTO dan1931_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","skal Præsten gå ud af Huset til Husets Dør og holde Huset lukket i syv Dage. ");
INSERT INTO dan1931_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","På den syvende Dag skal Præsten komme igen og syne det, og hvis det da viser sig, at Pletten har bredt sig på Husets Vægge, ");
INSERT INTO dan1931_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","skal Præsten give Ordre til at udtage de angrebne Sten og kaste dem hen på et urent Sted uden for Byen ");
INSERT INTO dan1931_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","og til at skrabe Lerpudset af Husets indvendige Vægge og hælde det fjernede Puds ud på et urent Sted uden for Byen. ");
INSERT INTO dan1931_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Derefter skal man tage andre Sten og sætte dem ind i Stedet for de gamle og ligeledes tage nyt Puds og pudse Huset dermed. ");
INSERT INTO dan1931_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Hvis Pletten så atter bryder frem i Huset, efter at Stenene er taget ud, Pudset skrabet af og Huset pudset på ny, ");
INSERT INTO dan1931_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","skal Præsten komme og syne Huset, og viser det sig da, at Pletten har bredt sig på Huset, så er det ondartet Spedalskhed, der er på Huset; det er urent. ");
INSERT INTO dan1931_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Da skal man rive Huset ned, Sten, Træværk og alt Pudset på Huset, og bringe det til et urent Sted uden for Byen. ");
INSERT INTO dan1931_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Den, som går ind i Huset, så længe det er lukket, skal være uren til Aften; ");
INSERT INTO dan1931_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","den, der sover deri skal tvætte sine Klæder, og den der spiser deri, skal tvætte sine Klæder. ");
INSERT INTO dan1931_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Men hvis det, når Præsten kommer og syner Huset, viser sig, at Pletten ikke har bredt sig på det, efter at det er pudset på ny, skal Præsten erklære Huset for rent, thi Pletten er helbredt. ");
INSERT INTO dan1931_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Da skal han for at rense Huset for Synd tage to Fugle, Cedertræ, karmoisinrødt Garn og en Ysopkvist. ");
INSERT INTO dan1931_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Den ene Fugl skal han slagte over et Lerkar med rindende Vand, ");
INSERT INTO dan1931_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","og han skal tage Cedertræet, Ysopkvisten, det karmoisinrøde Garn og den levende Fugl og dyppe dem i Blodet af den slagtede Fugl og det rindende Vand og syv Gange foretage Bestænkning på Huset ");
INSERT INTO dan1931_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","og således rense det for Synd med Fuglens Blod, det rindende Vand, den levende Fugl, Cedertræet, Ysopkvisten og det karmoisinrøde Garn. ");
INSERT INTO dan1931_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Og den levende Fugl skal han lade flyve ud af Byen hen over Marken og således skaffe Huset Soning; så er det rent. ");
INSERT INTO dan1931_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Det er Loven om al Slags Spedalskhed og Skurv, ");
INSERT INTO dan1931_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","om Spedalskhed på Klæder og Huse, ");
INSERT INTO dan1931_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","og om Hævelser, Udslæt og lyse Pletter, ");
INSERT INTO dan1931_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","til Belæring om, når noget er urent, og når det er rent. Det er Loven om Spedalskhed. ");
INSERT INTO dan1931_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","HERREN talede fremdeles til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Tal til Israelitterne og sig til dem: Når en Mand får Flåd fra sin Blusel, da er dette hans Flåd urent. ");
INSERT INTO dan1931_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Og således skal man forholde sig med den ved hans Flåd opståede Urenhed: Hvad enten hans Blusel flyder eller holder sit Flåd tilbage, er der Urenhed hos ham. ");
INSERT INTO dan1931_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ethvert Leje, som den, der lider af Flåd, ligger på, skal være urent, og ethvert Sæde, han sidder på, skal være urent. ");
INSERT INTO dan1931_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Den der rører ved hans Leje, skal tvætte sine Klæder og bade sig i Vand og være uren til Aften; ");
INSERT INTO dan1931_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","den, der sidder på et Sæde, som den, der lider af Flåd, har siddet på, skal tvætte sine Klæder og bade sig i Vand og være uren til Aften; ");
INSERT INTO dan1931_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","den, der rører ved en. der lider af Flåd, skal tvætte sine Klæder og bade sig i Vand og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Hvis den, der lider af Flåd, spytter på en, som er uren, skal denne tvætte sine Klæder og bade sig i Vand og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ethvert Befordringsmiddel, som bruges af den, der lider af Flåd, skal være urent. ");
INSERT INTO dan1931_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Den, der rører ved noget, han har ligget eller siddet på, skal være uren til Aften; den, der bærer noget sådant, skal tvætte sine Klæder og bade sig i Vand og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Enhver, som den, der lider af Flåd, rører ved uden at have skyllet sine Hænder i Vand, skal tvætte sine Klæder og bade sig i Vand og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Lerkar, som den, der lider af Flåd, rører ved, skal slås itu, og alle Trækar skal skylles i Vand. ");
INSERT INTO dan1931_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Men når den, der lider af Flåd, bliver ren for sit Flåd, skal han tælle syv Dage frem, fra den Dag han bliver ren, og så tvætte sine Klæder og bade sit Legeme i rindende Vand; så er han ren. ");
INSERT INTO dan1931_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Og den ottende dag skal han tage sig to Turtelduer eller Dueunger og komme hen for HERRENS Åsyn ved Åbenbaringsteltets indgang og give Præsten dem. ");
INSERT INTO dan1931_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Så skal Præsten bringe dem som Offer, den ene som Syndoffer, den anden som Brændoffer, og således skal Præsten skaffe ham Soning for HERRENS Åsyn for hans Flåd. ");
INSERT INTO dan1931_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Når der går Sæd fra en Mand, skal han bade hele sit Legeme i Vand og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Enhver Klædning og alt Læder, der er kommet Sæd på, skal tvættes i Vand og være urent til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Og når en Mand har Samleje med en Kvinde, skal de bade sig i Vand og være urene til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Når en Kvinde har Flåd, idet der flyder Blod fra hendes Blusel, da skal hendes Urenhed vare syv Dage. Enhver, der rører ved hende, skal være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Alt, hvad hun ligger på under sin månedlige Urenhed, skal være urent, og alt, hvad hun sidder på, skal være urent. ");
INSERT INTO dan1931_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Enhver, der rører ved hendes Leje, skal tvætte sine Klæder og bade sig i Vand og være uren til Aften; ");
INSERT INTO dan1931_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","og enhver, der rører ved et Sæde, hun har siddet på, skal tvætte sine Klæder og bade sig i Vand og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Og hvis nogen rører ved noget, der har ligget på Lejet eller Sædet, hun har siddet på, skal han være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Dersom en Mand ligger ved Siden af hende og hendes Urenhed kommer på ham, skal han være uren i syv Dage, og ethvert Leje, han ligger på, skal være urent. ");
INSERT INTO dan1931_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Men når en Kvinde har Blodflåd i længere Tid, uden for den Tid hun har sin månedlige Urenhed, eller når Flåddet varer længere end sædvanligt ved hendes månedlige Urenhed, så skal hun, i al den Tid hendes urene Flåd varer, være stillet, som i de Dage hun har sin månedlige Urenhed; hun skal være uren; ");
INSERT INTO dan1931_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ethvert Leje, hun ligger på, så længe hendes Flåd varer, skal være som hendes Leje under hendes månedlige Urenhed, og et hvert Sæde, hun sidder på, skal være urent som under hendes månedlige Urenhed; ");
INSERT INTO dan1931_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","enhver, der rører derved, bliver uren og skal tvætte sine Klæder og bade sig i Vand og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Men når hun bliver ren for sit Flåd, skal hun tælle syv Dage frem og så være ren. ");
INSERT INTO dan1931_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","På den ottende Dag skal hun tage sig to Turtelduer eller Dueunger og bringe dem til Præsten ved Åbenbaringsteltets Indgang. ");
INSERT INTO dan1931_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Og Præsten skal ofre den ene som Syndoffer, den anden som Brændoffer, og således skal Præsten skaffe hende Soning for HERRENS Åsyn for hendes Urenheds Flåd. ");
INSERT INTO dan1931_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","I skal advare Israelitterne for deres Urenhed, for at de ikke skal dø i deres Urenhed, når de gør min Bolig, som er i deres Midte, uren. ");
INSERT INTO dan1931_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Det er Loven om Mænd, der lider af Flåd, og fra hvem der går Sæd, så de bliver urene derved, ");
INSERT INTO dan1931_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","og om Kvinder, der lider af deres månedlige Urenhed, om Mænd og Kvinder, der har Flåd, og om Mænd, der ligger ved Siden af urene Kvinder. ");
INSERT INTO dan1931_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","HERREN talede til Moses, efter at Døden havde ramt Arons to Sønner, da de trådte frem for HERRENS Åsyn og døde, ");
INSERT INTO dan1931_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","og HERREN sagde til Moses: Sig til din Broder Aron, at han ikke til enhver Tid må gå ind i Helligdommen inden for Forhænget foran Sonedækket på Arken, ellers skal han dø, thi jeg kommer til Syne i Skyen over Sonedækket. ");
INSERT INTO dan1931_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Kun således må Aron komme ind i Helligdommen: Med en ung Tyr til Syndoffer og en Vædder til Brændoffer; ");
INSERT INTO dan1931_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","han skal iføre sig en hellig Linnedkjortel, bære Linnedbenklæder over sin Blusel, omgjorde sig med et Linnedbælte og binde et Linned Hovedklæde om sit Hoved; det er hellige Klæder; og han skal bade sit Legeme i Vand, før han ifører sig dem. ");
INSERT INTO dan1931_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Af Israelitternes Menighed skal han tage to Gedebukke til Syndoffer og en Vædder til Brændoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Så skal Aron ofre sin egen Syndoffertyr og skaffe sig og sit Hus Soning. ");
INSERT INTO dan1931_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Derefter skal han tage de to Bukke og stille dem frem for HERRENS Åsyn ved Indgangen til Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Og Aron skal kaste Lod om de to Bukke, et Lod for HERREN og et for Azazel; ");
INSERT INTO dan1931_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","og den Buk, der ved Loddet tilfalder HERREN, skal Aron føre frem og ofre som Syndoffer; ");
INSERT INTO dan1931_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","men den Buk, der ved Loddet tilfalder Azazel, skal fremstilles levende for HERRENS Åsyn, for at man kan fuldbyrde Soningen* over den og sende den ud i Ørkenen til Azazel. { *dvs. Soningssermonierne. } ");
INSERT INTO dan1931_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aron skal da føre sin egen Syndoffertyr frem og skaffe sig og sit Hus Soning og slagte sin egen Syndoffertyr. ");
INSERT INTO dan1931_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Derpå skal han tage en Pandefuld Gløder fra Alteret for HERRENS Åsyn og to Håndfulde stødt, vellugtende Røgelse og bære det inden for Forhænget. ");
INSERT INTO dan1931_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Og han skal komme Røgelse på Ilden for HERRENS Åsyn, så at Røgelsesskyen skjuler Sonedækket oven over Vidnesbyrdet, for at han ikke skal dø. ");
INSERT INTO dan1931_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Så skal han tage noget af Tyrens Blod og stænke det med sin Finger fortil på Sonedækket, og foran Sonedækket skal han syv Gange stænke noget af Blodet med sin Finger. ");
INSERT INTO dan1931_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Derefter skal han slagte Folkets Syndofferbuk, bære dens Blod inden for Forhænget og gøre med det som med Tyrens Blod, stænke det på Sonedækket og foran Sonedækket. ");
INSERT INTO dan1931_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Således skal han skaffe Helligdommen Soning for Israelitternes Urenhed og deres Overtrædelser, alle deres Synder, og på samme Måde skal han gøre med Åbenbaringsteltet, der har sin Plads hos dem midt i deres, Urenhed. ");
INSERT INTO dan1931_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Intet Menneske må komme i Åbenbaringsteltet, når han går ind for at skaffe Soning i Helligdommen, før han går ud igen. Således skal han skaffe sig selv, sit Hus og hele Israels Forsamling Soning. ");
INSERT INTO dan1931_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Så skal han gå ud til Alteret, som står for HERRENS Åsyn, og skaffe det Soning; han skal tage noget af Tyrens og Bukkens Blod og stryge det rundt om på Alterets Horn, ");
INSERT INTO dan1931_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","og han skal syv Gange stænke noget af Blodet derpå med sin Finger og således rense det og hellige det for Israelitternes Urenheder. ");
INSERT INTO dan1931_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Når han så er færdig med at skaffe Helligdommen, Åbenbaringsteltet og Alteret Soning, skal han føre den levende Buk frem. ");
INSERT INTO dan1931_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aron skal lægge begge sine Hænder på Hovedet af den levende Buk og over den bekende alle Israelitternes Misgerninger og alle deres Overtrædelser, alle deres Synder, og lægge dem på Bukkens Hoved og så sende den ud i Ørkenen ved en Mand, der holdes rede dertil. ");
INSERT INTO dan1931_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Bukken skal da bære alle deres Misgerninger til et øde Land, og så skal han slippe Bukken løs i Ørkenen. ");
INSERT INTO dan1931_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Derpå skal Aron gå ind i Åbenbaringsteltet, afføre sig Linnedklæderne, som han tog på, da han gik ind i Helligdommen, og lægge dem der; ");
INSERT INTO dan1931_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","så skal han bade sit Legeme i Vand på et helligt Sted, iføre sig sine sædvanlige Klæder og gå ud og ofre sit eget Brændoffer og Folkets Brændoffer og således skaffe sig og Folket Soning. ");
INSERT INTO dan1931_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Og Syndofferets Fedt skal han bringe som Røgoffer på Alteret. ");
INSERT INTO dan1931_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Men den, som fører Bukken ud til Azazel, skal tvætte sine Klæder og bade sit Legeme i Vand; derefter må han komme ind i Lejren. ");
INSERT INTO dan1931_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Men Syndoffertyren og Syndofferbukken, hvis Blod blev båret ind for at skaffe Soning i Helligdommen, skal man bringe uden for Lejren, og man skal brænde deres Hud og deres Kød og Skarn. ");
INSERT INTO dan1931_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Og den, der brænder dem, skal tvætte sine Klæder og bade sit Legeme; derefter må han komme ind i Lejren. ");
INSERT INTO dan1931_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Det skal være eder en evig gyldig Anordning. Den tiende Dag i den syvende Måned skal I faste og afholde eder fra alt Arbejde, både den indfødte og den fremmede, der bor iblandt eder. ");
INSERT INTO dan1931_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Thi den Dag skaffes der eder Soning til eders Renselse; fra alle eders Synder renses I for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Det skal være eder en fuldkommen Hviledag, og I skal faste: det skal være en evig gyldig Anordning. ");
INSERT INTO dan1931_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Præsten, som salves og indsættes til at gøre Præstetjeneste i. Stedet for sin Fader, skal skaffe Soning, han skal iføre sig Linnedklæderne, de hellige Klæder, ");
INSERT INTO dan1931_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","og han skal skaffe det Allerhelligste Soning; og Åbenbaringsteltet og Alteret skal han skaffe Soning; og Præsterne og alt Folkets Forsamling skal han skaffe Soning. ");
INSERT INTO dan1931_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Det skal være eder en evig gyldig Anordning, for at der kan skaffes Israelitterne Soning for alle deres Synder én Gang om Året. Og Aron gjorde som HERREN bød Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Tal til Aron og hans Sønner og alle Israelitterne og sig til dem: Dette har HERREN påbudt: ");
INSERT INTO dan1931_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Om nogen af Israels Hus slagter et Stykke Hornkvæg, et Får eller en Ged i Lejren, eller han slagter dem uden for Lejren, ");
INSERT INTO dan1931_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","uden at bringe dem hen til Åbenbaringsteltets Indgang for at bringe HERREN en Offergave foran HERRENS Bolig, da skal dette tilregnes den Mand som Blodskyld; han har udgydt Blod, og den Mand skal udryddes af sit Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Dette er anordnet, for at Israelitterne skal bringe deres Slagtofre, som de slagter ude på Marken, til HERREN, til Åbenbaringsteltets Indgang, til Præsten, og ofre dem som Takofre til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Præsten skal da sprænge Blodet på HERRENS Alter ved Indgangen til Åbenbaringsteltet og bringe Fedtet som Røgoffer, en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Og de må ikke mere ofre deres Slagtofre til Bukketroldene, som de boler med. Det skal være en evig gyldig Anordning for dem fra Slægt til Slægt! ");
INSERT INTO dan1931_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Og du skal sige til dem: Om nogen af Israels Hus eller de fremmede, der bor iblandt eder, ofrer et Brændoffer eller Slagtoffer ");
INSERT INTO dan1931_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","og ikke bringer det hen til Åbenbaringsteltets Indgang for at ofre det til HERREN, da skal den Mand udryddes af sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Om nogen af Israels Hus eller af de fremmede, der bor iblandt dem, nyder noget Blod, så vender jeg mit Åsyn mod den, der nyder Blodet, og udrydder ham af hans Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Thi Kødets Sjæl er i Blodet, og jeg har givet eder det til Brug på Alteret til at skaffe eders Sjæle Soning; thi det er Blodet, som skaffer Soning, fordi det er Sjælen. ");
INSERT INTO dan1931_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Derfor har jeg sagt til Israelitterne: Ingen af eder må nyde Blod; heller ikke den fremmede, der bor iblandt eder, må nyde Blod. ");
INSERT INTO dan1931_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Om nogen af Israelitterne eller af de fremmede, der bor iblandt dem, nedlægger et Stykke Vildt eller en Fugl af den Slags, der må spises, da skal han lade Blodet løbe ud og dække det med Jord. ");
INSERT INTO dan1931_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Thi om alt Køds Sjæl gælder det, at dets Blod er dets Sjæl; derfor har jeg sagt til Israelitterne: I må ikke nyde Blodet af noget som helst Kød, thi alt Køds Sjæl er dets Blod; enhver, der nyder det, skal udryddes. ");
INSERT INTO dan1931_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Enhver, der spiser selvdøde eller sønderrevne Dyr, det være sig en indfødt eller en fremmed, skal tvætte sine Klæder og bade sig i Vand og være uren til Aften; så er han ren. ");
INSERT INTO dan1931_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Men hvis han ikke tvætter sine Klæder og bader sig, skal han undgælde for sin Brøde. ");
INSERT INTO dan1931_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Tal til Israelitterne og sig til dem: Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Som de handler i Ægypten, hvor I opholdt eder, må I ikke handle, og som de handler i Kana'ans Land, hvor jeg fører eder hen, må I ikke handle; I må ikke vandre efter deres Anordninger. ");
INSERT INTO dan1931_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Efter mine Lovbud skal I handle. og mine Anordninger skal I holde, så I vandrer efter dem; jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","I skal holde mine Anordninger og Lovbud; det Menneske, der handler efter dem, skal leve ved dem. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ingen af eder må komme sine kødelige Slægtninge nær, så han blotter deres Blusel. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Din Faders og din Moders Blusel må du ikke blotte; hun er din Moder, du må ikke blotte hendes Blusel! ");
INSERT INTO dan1931_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Din Faders Hustrus Blusel må du ikke blotte, det er din Faders Blusel. ");
INSERT INTO dan1931_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Din Søsters Blusel, hvad enten hun er din Faders eller din Moders Datter, hvad enten hun er født i eller uden for Hjemmet, hendes Blusel må du ikke blotte. ");
INSERT INTO dan1931_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Din Sønnedatters eller Datterdatters Blusel må du ikke blotte, det er din egen Blusel. ");
INSERT INTO dan1931_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","En Datter, din Faders Hustru har med din Fader hun er din Søster hendes Blusel må du ikke blotte. ");
INSERT INTO dan1931_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Din Fasters Blusel må du ikke blotte, hun er din Faders kødelige Slægtning. ");
INSERT INTO dan1931_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Din Mosters Blusel må du ikke blotte, hun er din Moders kødelige Slægtning. ");
INSERT INTO dan1931_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Din Farbroders Blusel må du ikke blotte, du må ikke komme hans Hustru nær, hun er din Faster. ");
INSERT INTO dan1931_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Din Sønnekones Blusel må du ikke blotte, hun er din Søns Hustru, du må ikke blotte hendes Blusel. ");
INSERT INTO dan1931_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Din Broders Hustrus Blusel må du ikke blotte, det er din Broders Blusel. ");
INSERT INTO dan1931_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","En Kvindes og hendes Datters Blusel må du ikke blotte, heller ikke må du ægte hendes Sønnedatter eller Datterdatter, så at du blotter hendes Blusel; de er hendes kødelige Slægtninge; det er grov Utugt. ");
INSERT INTO dan1931_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Søster må du ikke tage til Søsters Medhustru, så længe Søsteren lever, så du blotter både den enes og den andens Blusel. ");
INSERT INTO dan1931_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Du må ikke komme en Kvinde nær under hendes månedlige Urenhed, så du blotter hendes Blusel. ");
INSERT INTO dan1931_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Med din Næstes Hustru må du ikke have Samleje, så du bliver uren ved hende. ");
INSERT INTO dan1931_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Dit Afkom må du ikke give hen til at ofres til Molok*; du må ikke vanhellige din Guds Navn. Jeg er HERREN! { *se Ordforklaringen. } ");
INSERT INTO dan1931_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Hos en Mand må du ikke ligge, som man ligger hos en Kvinde; det er en Vederstyggelighed. ");
INSERT INTO dan1931_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Med intet som helst Dyr må du have Omgang, så du bliver uren derved; en Kvinde må ikke stille sig hen for et dyr til kønslig Omgang; det er en Skændsel. ");
INSERT INTO dan1931_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Gør eder ikke urene med noget sådant, thi med alt sådant har de Folkeslag, jeg driver bort foran eder, gjort sig urene. ");
INSERT INTO dan1931_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Derved blev Landet urent, og jeg straffede det for dets Brøde, og Landet udspyede sine Indbyggere. ");
INSERT INTO dan1931_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Hold derfor mine Anordninger og Lovbud og øv ikke nogen af disse Vederstyggeligheder, det gælder både den indfødte og den fremmede, der bor iblandt eder - ");
INSERT INTO dan1931_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","thi alle disse Vederstyggeligheder øvede Indbyggerne, som var der før eder, og Landet blev urent - ");
INSERT INTO dan1931_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","for at ikke Landet skal udspy eder, når I gør det urent, ligesom det udspyede det Folk, som var der før eder. ");
INSERT INTO dan1931_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Thi enhver, som øver nogen af alle disse Vederstyggeligheder, de, der øver dem, skal udryddes af deres Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Så hold mine Forskrifter, så I ikke øver nogen af de vederstyggelige Skikke, som øvedes før eders Tid, at I ikke skal gøre eder urene ved dem. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Tal til hele Israelitternes Menighed og sig til dem: I skal være hellige, thi jeg HERREN eders Gud er hellig! ");
INSERT INTO dan1931_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","I skal frygte hver sin Moder og sin Fader, og mine Sabbater skal I holde. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Vend eder ikke til Afguderne og gør eder ikke støbte Gudebilleder! Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Når I ofrer Takoffer til HERREN, skal I ofre det således, at I kan vinde Guds Velbehag. ");
INSERT INTO dan1931_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Den Dag, I ofrer det, og Dagen efter må det spises, men hvad der levnes til den tredje Dag, skal opbrændes; ");
INSERT INTO dan1931_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","spises det den tredje Dag, er det at regne for råddent Kød og vinder ikke Guds Velbehag; ");
INSERT INTO dan1931_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","den, der spiser deraf, skal undgælde for sin Brøde, thi han vanhelliger det, som var helliget HERREN, og det Menneske skal udryddes af sin Slægt. ");
INSERT INTO dan1931_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Når I høster eders Lands Høst, må du ikke høste helt hen til Kanten af din Mark, ej heller må du sanke Efterslætten efter din Høst. ");
INSERT INTO dan1931_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Heller ikke må du holde Efterhøst eller sanke de nedfaldne Bær i din Vingård; til den fattige og den fremmede skal du lade det blive tilbage. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","I må ikke stjæle, I må ikke lyve, I må ikke bedrage hverandre. ");
INSERT INTO dan1931_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","I må ikke sværge falsk ved mit Navn, så du vanhelliger din Guds Navn. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Du må intet aftvinge din Næste, du må intet røve; Daglejerens Løn må ikke blive hos dig Natten over. ");
INSERT INTO dan1931_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Du må ikke forbande den døve eller lægge Stød for den blindes Fod, du skal frygte din Gud. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","I må ikke øve Uret, når I holder Rettergang; du må ikke begunstige den ringe, ej heller tage Parti for den store, men du skal dømme din Næste med Retfærdighed. ");
INSERT INTO dan1931_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Du må ikke gå rundt og bagvaske din Landsmand eller stå din Næste efter Livet. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Du må ikke bære Nag til din Broder i dit Hjerte, men du skal tale din Næste til Rette, at du ikke skal pådrage dig Synd for hans Skyld. ");
INSERT INTO dan1931_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Du må ikke hævne dig eller gemme på Vrede mod dit Folks Børn, du skal elske din Næste som dig selv. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Hold mine Anordninger! Du må ikke lade to Slags Kvæg parre sig med hinanden; du må ikke så to Slags Sæd i din Mark; og du må ikke bære Klæder, der er vævede af to Slags Garn. ");
INSERT INTO dan1931_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Når en Mand har Samleje med en Kvinde, og det er en Trælkvinde, en anden Mands Medhustru, som ikke er løskøbt eller frigivet, så skal Afstraffelse finde Sted; dog skal de ikke lide Døden, thi hun var ikke frigivet. ");
INSERT INTO dan1931_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Og han skal bringe sit Skyldoffer for HERREN til Åbenbaringsteltets Indgang, en Skyldoffervædder, ");
INSERT INTO dan1931_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","og Præsten skal med Skyldoffervædderen skaffe ham Soning for HERRENS Åsyn for den Synd, han har begået, så han finder Tilgivelse for den Synd, han har begået. ");
INSERT INTO dan1931_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Når I kommer ind i Landet og planter alskens Frugttræer, skal I lade deres Forhud, den første Frugt, urørt; i tre År skal de være eder uomskårne og må ikke spises; ");
INSERT INTO dan1931_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","det fjerde År skal al deres Frugt under Høstjubel helliges HERREN; ");
INSERT INTO dan1931_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","først det femte År må I spise deres Frugt, for at I kan få så meget større Udbytte deraf. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","I må ikke spise noget med Blodet i. I må ikke give eder af med at tage Varsler og øve Trolddom. ");
INSERT INTO dan1931_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","I må ikke runde Håret på Tindingerne; og du må ikke studse dit Skæg; ");
INSERT INTO dan1931_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","I må ikke gøre Indsnit i eders Legeme for de dødes Skyld eller indridse Tegn på eder. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Du må ikke vanhellige din Datter ved at lade hende bedrive Hor, for at ikke Landet skal forfalde til Horeri og fyldes med Utugt. ");
INSERT INTO dan1931_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Mine Sabbater skal I holde, og min Helligdom skal I frygte. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Henvend eder ikke til Genfærd og Sandsigerånder; søg dem ikke, så I gør eder urene ved dem. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Du skal rejse dig for de grå Hår og ære Oldingen, og du skal frygte din Gud. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Når en fremmed bor hos dig i eders Land, må I ikke lade ham lide Overlast; ");
INSERT INTO dan1931_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","som en af eders egne skal I regne den fremmede, der bor hos eder, og du skal elske ham som dig selv, thi I var selv fremmede i Ægypten. Jeg et HERREN eders Guld! ");
INSERT INTO dan1931_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Når I holder Rettergang, må I ikke øve Uret ved Længdemål, Vægt eller Rummål; ");
INSERT INTO dan1931_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Vægtskåle, der vejer rigtigt, Lodder, der holder Vægt, Efa og Hin, der holder Mål, skal I have. Jeg er HERREN eders Gud, som førte eder ud af Ægypten! ");
INSERT INTO dan1931_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Hold alle mine Anordninger og Lovbud og gør efter dem. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Sig til Israelitterne: Om nogen af Israelitterne eller de fremmede, der bor hos Israel, giver sit Afkom hen til Molok, da skal han lide Døden; Landets Indbyggere skal stene ham, ");
INSERT INTO dan1931_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","og jeg vender selv mit Åsyn imod den Mand og udrydder ham af hans Folk, fordi han gav sit Afkom hen til Molok for at gøre min Helligdom uren og vanhellige mit hellige Navn; ");
INSERT INTO dan1931_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","og ser end Landets Indbyggere igennem Fingre med den Mand, når han giver sit Afkom hen til Molok, og undlader at dræbe ham, ");
INSERT INTO dan1931_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","så vender jeg dog selv mit Åsyn imod den Mand og hans Slægt og udrydder ham og alle dem, der følger i hans Spor og boler med Molok, af deres Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Det Menneske, som henvender sig til Genfærd eller Sandsigerånder og boler med dem, mod det Menneske vil jeg vende mit Åsyn og udrydde ham af hans Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Helliger eder og vær hellige; thi jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Hold mine Anordninger og gør efter dem. Jeg er HERREN, som helliger eder! ");
INSERT INTO dan1931_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Thi enhver, som forbander sin Fader og sin Moder, skal lide Døden; han har forbandet sin Fader og sin Moder, derfor hviler der Blodskyld på ham. ");
INSERT INTO dan1931_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Om nogen bedriver Hor med en anden Mands Hustru, om nogen bedriver Hor med sin Næstes Hustru, da skal de lide Døden, Horkarlen såvel som Horkvinden. ");
INSERT INTO dan1931_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Om nogen har Samleje med sin Faders Hustru, har han blottet sin Faders Blusel; de skal begge lide Døden, der hviler Blodskyld på dem. ");
INSERT INTO dan1931_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Om nogen har Samleje med sin Sønnekone, skal de begge lide Døden; de har øvet Skændselsdåd, der hviler Blodskyld på dem. ");
INSERT INTO dan1931_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Om nogen ligger hos en Mand, på samme Måde som man ligger hos en Kvinde, da har de begge øvet en Vederstyggelighed; de skal lide Døden, der hviler Blodskyld på dem. ");
INSERT INTO dan1931_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Om nogen ægter en Kvinde og hendes Moder, er det grov Utugt: man skal brænde både ham og begge Kvinderne; der må ikke findes grov Utugt iblandt eder. ");
INSERT INTO dan1931_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Om nogen har Omgang med et Dyr, skal han lide Døden, og Dyret skal I slå ihjel. ");
INSERT INTO dan1931_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Om en Kvinde kommer noget Dyr nær for at have kønslig Omgang med det, da skal du ihjelslå både Kvinden og Dyret; de skal lide Døden, der hviler Blodskyld på dem. ");
INSERT INTO dan1931_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Om en Mand tager sin Søster, sin Faders eller sin Moders Datter, til Ægte, så han ser hendes Blusel, og hun hans, da er det en skammelig Gerning; de skal udryddes i deres Landsmænds Påsyn; han har blottet sin Søsters Blusel, han skal undgælde for sin Brøde. ");
INSERT INTO dan1931_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Om en Mand har Samleje med en Kvinde under hendes månedlige Svaghed og blotter hendes Blusel, idet han afdækker hendes Kilde, og hun afdækker sit Blods Kilde, da skal de begge udryddes af deres Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Du må ikke blotte din Mosters og din Fasters Blusel, thi den, der gør det, afdækker sin kødelige Slægtnings Blusel; de skal undgælde for deres Brøde. ");
INSERT INTO dan1931_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Om nogen har Samleje med sin Farbroders Hustru, da har han blottet sin Farbroders Blusel, de skal undgælde for deres Synd og dø barnløse. ");
INSERT INTO dan1931_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Om nogen tager sin Broders Hustru til Ægte, da er det en uren Gerning; han har blottet sin Broders Blusel; de skal blive barnløse. ");
INSERT INTO dan1931_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Hold alle mine Anordninger og Lovbud og gør efter dem, at ikke Landet, jeg føler eder ind at bo i, skal udspy eder. ");
INSERT INTO dan1931_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Følg ikke det Folks Skikke, som jeg driver bort foran eder, thi de har øvet alt dette; derfor væmmedes jeg ved dem ");
INSERT INTO dan1931_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","og sagde til eder: I skal få deres Land i Eje; jeg giver eder det i Eje, et Land, der flyder med Mælk og Honning. Jeg er HERREN eders Gud, som har udskilt eder fra alle andre Folkeslag. ");
INSERT INTO dan1931_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","I skal skelne mellem rene og urene Dyr og mellem urene og rene Fugle for ikke at gøre eder selv til en Vederstyggelighed ved de Dyr og de Fugle og alt, hvad der rører sig på Jorden, alt, hvad jeg har udskilt for eder og erklæret for urent. ");
INSERT INTO dan1931_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Og I skal være mig hellige, thi jeg HERREN er hellig, og jeg har udskilt eder fra alle andre Folkeslag til at høre mig til. ");
INSERT INTO dan1931_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Når der i en Mand eller Kvinde er en Genfærdsånd eller en Sandsigerånd, skal de lide Døden; de skal stenes, der hviler Blodskyld på dem. ");
INSERT INTO dan1931_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Og HERREN sagde til Moses: Tal til Præsterne, Arons Sønner, og sig til dem: Præsten må ikke gøre sig uren ved Lig blandt sin Slægt, ");
INSERT INTO dan1931_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","medmindre det er hans nærmeste kødelige Slægtninge, hans Moder eller Fader, hans Søn eller Datter, hans Broder ");
INSERT INTO dan1931_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","eller Søster, for så vidt hun var Jomfru og endnu hørte til hans Familie og ikke var gift; i så Fald må han gøre sig uren ved hende; ");
INSERT INTO dan1931_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","men han må ikke gøre sig uren ved hende, når hun var gift med en Mand af hans Slægt, og således pådrage sig Vanhelligelse. ");
INSERT INTO dan1931_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","De må ikke klippe sig en skaldet Plet på deres Hoved, ikke studse deres Skæg eller gøre Indsnit i deres Legeme. ");
INSERT INTO dan1931_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Hellige skal de være for deres Gud og må ikke vanhellige deres Guds Navn, thi de frembærer HERRENS Ildofre, deres Guds Spise; derfor skal de være hellige. ");
INSERT INTO dan1931_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","En Horkvinde og en skændet Kvinde må de ikke ægte; heller ikke en Kvinde, der er forstødt af sin Mand, må de ægte; thi han er helliget sin Gud. ");
INSERT INTO dan1931_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Du skal regne ham for hellig, thi han frembærer din Guds Spise; han skal være dig hellig, thi hellig er jeg HERREN, som helliger dem. ");
INSERT INTO dan1931_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Når en Præstedatter vanhelliger sig ved at bedrive Hor, da vanhelliger hun sin Fader; hun skal brændes på Bål, ");
INSERT INTO dan1931_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Den Præst, der er den ypperste blandt sine Brødre, han, over hvis Hoved Salveolien udgydes, og som indsættes ved at iføres Klæderne, må hverken lade sit Hovedhår vokse frit eller sønderrive sine Klæder*. { *ved Sorg over Døde, 3 Mos. 10, 6. } ");
INSERT INTO dan1931_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Han må ikke gå hen til noget som helst Lig, end ikke ved sin Fader eller Moder må han gøre sig uren. ");
INSERT INTO dan1931_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Han må ikke forlade Helligdommen for ikke at vanhellige sin Guds Helligdom, thi hans Guds Salveolies Vielse er på ham; jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Han skal ægte en Kvinde, der er Jomfru; ");
INSERT INTO dan1931_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","en Enke, en forstødt, en skændet, en Horkvinde må han ikke ægte, kun en Jomfru af sin Slægt må han tage til Hustru, ");
INSERT INTO dan1931_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","for at han ikke skal vanhellige sit Afkom blandt sin Slægt; thi jeg er HERREN, som helliger ham. ");
INSERT INTO dan1931_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Tal til Aron og sig: Ingen af dit Afkom i de kommende Slægter, som har en Legemsfejl, må træde frem for at frembære sin Guds Spise, ");
INSERT INTO dan1931_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","det må ingen, som har en Legemsfejl, hverken en blind eller en halt eller en med vansiret Ansigt eller for lang en Legemsdel ");
INSERT INTO dan1931_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","eller med Brud på Ben eller Arm ");
INSERT INTO dan1931_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","eller en pukkelrygget eller en med Tæring eller en, der har Pletter i Øjnene eller lider af Skab eller Ringorm eller har svulne Testikler. ");
INSERT INTO dan1931_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Af Præsten Arons Efterkommere må ingen, som har en Legemsfejl, nærme sig for at frembære HERRENS Ildofre; han har en Legemsfejl, han må ikke nærme sig for at frembære sin Guds Spise. ");
INSERT INTO dan1931_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Han må vel spise sin Guds Spise, både det, som er højhelligt, og det, som er helligt, ");
INSERT INTO dan1931_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","men til Forhænget må han ikke komme, og Alteret må han ikke nærme sig, thi han har en Legemsfejl og må ikke vanhellige mine hellige Ting; thi jeg er HERREN, som helliger dem. ");
INSERT INTO dan1931_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Og Moses talte således til Aron og hans Sønner og alle Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Sig til Aron og hans Sønner, at de skal behandle Israelitternes Helliggaver, som de helliger mig, med Ærefrygt, for at de ikke skal vanhellige mit hellige Navn. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Sig til dem: Enhver af alle eders Efterkommere, som i de kommende Slægter i uren Tilstand kommer de Helliggaver nær, Israelitterne helliger HERREN, det Menneske skal udryddes fra mit Åsyn. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ingen af Arons Efterkommere, der er spedalsk eller lider af Flåd, må spise noget af Helliggaverne, før han bliver ren; den, der rører ved en, som er uren ved Lig, eller den, fra hvem der går Sæd, ");
INSERT INTO dan1931_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","eller den, der rører ved noget Slags Kryb, ved hvilket man bliver uren, eller ved et Menneske, ved hvem man bliver uren, af hvad Art hans Urenhed være kan, ");
INSERT INTO dan1931_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","enhver, der rører ved noget sådant, skal være uren til Aften og må ikke spise af Helliggaverne, før han har badet sit Legeme i Vand. ");
INSERT INTO dan1931_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Når Solen går ned, er han ren, og derefter må han spise af Helliggaverne, thi de er hans Mad. ");
INSERT INTO dan1931_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Selvdøde og sønderrevne Dyr må han ikke spise for ikke at gøre sig uren derved. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","De skal overholde mine Forskrifter, at de ikke skal pådrage sig Synd og dø derfor, fordi de vanhelliger det. Jeg er HERREN, som helliger dem. ");
INSERT INTO dan1931_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ingen Lægmand må spise af det hellige; hverken den indvandrede hos Præsten eller hans Daglejer må spise af det hellige. ");
INSERT INTO dan1931_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Men når en Præst for sine Penge køber sig en Træl, da må denne spise deraf, og ligeledes må hans hjemmefødte Trælle spise af hans Mad. ");
INSERT INTO dan1931_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Når en Præstedatter ægter en Lægmand, må hun ikke spise af de ydede Helliggaver; ");
INSERT INTO dan1931_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","men når en Præstedatter bliver Enke eller forstødes uden at have Børn og vender tilbage til sin Faders Hus og er der som i sine unge År, da må hun spise af sin Faders Mad. Men ingen Lægmand må spise deraf. ");
INSERT INTO dan1931_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Når nogen af Vanvare kommer til at spise af det hellige, skal han erstatte Præsten det hellige med Tillæg af en Femtedel. ");
INSERT INTO dan1931_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Præsterne må ikke vanhellige de Helliggaver, Israelitterne yder HERREN, ");
INSERT INTO dan1931_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","og således bringe Brøde og Skyld over dem, når de spiser deres Helliggaver; thi jeg er HERREN, som helliger dem. ");
INSERT INTO dan1931_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Tal til Aron og hans Sønner og alle Israelitterne og sig til dem: Om nogen af Israels Hus eller af de fremmede i Israel bringer sin Offergave, hvad enten det er deres Løfteoffer eller Frivilligoffer, de bringer HERREN som Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","så skal I bringe dem således, at I kan vinde Guds Velbehag, et lydefrit Handyr af Hornkvæget, Fårene eller Gederne; ");
INSERT INTO dan1931_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","I må ikke ofre noget Dyr, der har en Legemsfejl, thi derved vinder I ikke eders Guds Velbehag. ");
INSERT INTO dan1931_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Når nogen bringer HERREN et Takoffer af Hornkvæget eller Småkvæget enten for at indfri et Løfte eller som Frivilligoffer, da skal det være et lydefrit Dyr, for at det kan vinde Guds Velbehag; det må ingen som helst Legemsfejl have; ");
INSERT INTO dan1931_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","et blindt Dyr eller et Dyr med Brud på Lemmerne eller et såret Dyr eller et Dyr, der lider af Bylder, Skab eller Ringorm, sådanne Dyr må I ikke bringe HERREN, og I må ikke lægge noget Ildoffer af den Slags på Alteret for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Et Stykke Hornkvæg eller Småkvæg med en for lang eller forkrøblet Legemsdel kan du bruge som Frivillig offer, men som Løfteoffer vinder det ikke Guds Velbehag. ");
INSERT INTO dan1931_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Dyr med udklemte, knuste, afrevne eller bortskårne Testikler må I ikke bringe HERREN; således må I ikke bære eder ad i eders Land. ");
INSERT INTO dan1931_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Heller ikke må I af en Udlænding købe den Slags Dyr og ofre dem som eders Guds Spise, thi de har en Lyde, de har en Legemsfejl; ved dem vinder I ikke Guds Velbehag. ");
INSERT INTO dan1931_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Når der fødes et Stykke Hornkvæg, et Får eller en Ged, skal de blive syv Dage hos Moderen; men fra den ottende Dag er de skikkede til at vinde HERRENS Velbehag som Ildoffergave til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","I må ikke slagte et Stykke Hornkvæg eller Småkvæg samme Dag som dets Afkom. ");
INSERT INTO dan1931_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Når I ofrer et Lovprisningsoffer til HERREN, skal I ofre det således, at det kan vinde eder Guds Velbehag. ");
INSERT INTO dan1931_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Det skal spises samme Dag, I må intet levne deraf til næste Morgen. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","I skal holde mine Bud og handle efter dem. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","I må ikke vanhellige mit hellige Navn, for at jeg må blive helliget blandt Israelitterne. Jeg er HERREN, som helliger eder, ");
INSERT INTO dan1931_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","som førte eder ud af Ægypten for at være eders Gud. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Tal til Israelitterne og sig til dem: Hvad angår HERRENS Festtider, hvilke I skal udråbe som Højtidsstævner, da er mine Festtider følgende: ");
INSERT INTO dan1931_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","I seks Dage skal der arbejdes, men den syvende Dag skal være en fuldkommen Hviledag med Højtidsstævne; I må intet Arbejde gøre, det er Sabbat for HERREN, overalt hvor I bor. ");
INSERT INTO dan1931_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Følgende er HERRENS Festtider med Højtidsstævner, som I skal udråbe, hver til sin Tid: ");
INSERT INTO dan1931_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","På den fjortende Dag i den første Måned ved Aftenstid er det Påske for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","På den femtende Dag i samme Måned er det de usyrede Brøds Højtid for HERREN; i syv Dage skal I spise usyret Brød. ");
INSERT INTO dan1931_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","På den første Dag skal I holde Højtidsstævne, I må intet Arbejde gøre. ");
INSERT INTO dan1931_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","I skal bringe HERREN Ildoffer i syv Dage. På den syvende Dag skal der holdes Højtidsstævne, I må intet Arbejde gøre. ");
INSERT INTO dan1931_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Tal til Israelitterne og sig til dem: Når I kommer til det Land, jeg vil give eder, og høster dets Høst, skal I bringe Præsten Førstegrødeneget af eders Høst. ");
INSERT INTO dan1931_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Han skal udføre Svingningen med Neget for HERRENS Åsyn for at vinde eder Guds Velbehag; Dagen efter Sabbaten skal Præsten udføre Svingningen dermed. ");
INSERT INTO dan1931_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Og på den Dag I udfører Svingningen med Neget, skal I ofre et lydefrit, årgammelt Lam som Brændoffer til HERREN, ");
INSERT INTO dan1931_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","og der skal høre to Tiendedele Eta fint Hvedemel, rørt i Olie, dertil som Afgrødeoffer, et Ildoffer for HERREN til en liflig Duft, og ligeledes en Fjerdedel Hin Vin som Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Brød, ristede Aks eller nyhøstet Horn må I ikke spise før denne Dag, før I har frembåret eders Guds Offergave. Det skal være eder en evig gyldig Anordning fra Slægt til Slægt, overalt hvor I bor. ");
INSERT INTO dan1931_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Så skal I fra Dagen efter Sabbaten, fra den dag I bringer Svingningsneget, tælle syv Uger frem - det skal være hele Uger - ");
INSERT INTO dan1931_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","til Dagen efter den syvende Sabbat, I skal tælle halvtredsindstyve Dage frem; da skal I frembære et nyt Afgrødeoffer for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Fra eders Boliger skal I bringe Svingningsbrød, to Brød, som skal laves af to Tiendedele Efa fint Hvedemel og bages syrede, en Førstegrødegave til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Og foruden Brødet skal I bringe syv lydefri, årgamle Lam, en ung Tyr og to Vædre, de skal være til Brændoffer for HERREN med tilhørende Afgrødeoffer og Drikoffer, et Ildoffer for HERREN til en liflig Duft. ");
INSERT INTO dan1931_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Og I skal ofre en Gedebuk som Syndoffer og to årgamle Lam som Takoffer. ");
INSERT INTO dan1931_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Og Præsten skal udføre Svingningen med dem, med de to Lam, for HERRENS Åsyn sammen med Førstegrødebrødet, de skal være HERREN helligede og tilfalde Præsten. ");
INSERT INTO dan1931_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","På denne Dag skal I udråbe og holde et Højtidsstævne; I må intet Arbejde gøre. Det skal være eder en evig gyldig Anordning, overalt hvor I bor, fra Slægt til Slægt. ");
INSERT INTO dan1931_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Når I høster eders Lands Høst, må du ikke høste helt hen til Kanten af din Mark, ej heller må du sanke Efterslætten efter din Høst; til den fattige og den fremmede skal du lade det blive tilbage. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Tal til Israelitterne og sig: Den første dag i den syvende Måned skal I holde Hviledag med Hornblæsning til Ihukommelse og med Højtidsstævne; ");
INSERT INTO dan1931_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","I må intet Arbejde gøre, og I skal bringe HERREN Ildofre. ");
INSERT INTO dan1931_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","På den tiende Dag i samme syvende Måned falder Forsoningsdagen; da skal I holde Højtidsstævne, faste og bringe HERREN Ildofre; ");
INSERT INTO dan1931_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","I må intet Arbejde gøre på denne Dag, thi det er Forsoningsdagen, den skal skaffe eder Soning for HERREN eders Guds Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Thi enhver, som ikke faster på denne Dag, skal udryddes af sin Slægt; ");
INSERT INTO dan1931_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","og enhver, der gør noget som helst Arbejde på denne Dag, det Menneske vil jeg udslette af hans Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","I må intet Arbejde gøre. Det skal være eder en evig Anordning fra Slægt til Slægt, overalt hvor I bor. ");
INSERT INTO dan1931_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Den skal være eder en fuldkommen Hviledag, og I skal faste; på den niende Dag i Måneden om Aftenen, fra denne Aften til næste Aften skal I holde eders Hviledag. ");
INSERT INTO dan1931_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Tal til Israelitterne og sig: Den femtende Dag i samme syvende Måned skal Løvhyttefesten fejres, den skal fejres i syv Dage for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","På den første Dag skal der holdes Højtidsstævne, I må intet Arbejde gøre. ");
INSERT INTO dan1931_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Syv dage skal I bringe HERREN Ildofre; og på den ottende Dag skal I holde Højtidsstævne og bringe HERREN Ildofre; det er festlig Samling, I må intet Arbejde gøre. ");
INSERT INTO dan1931_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Det er HERRENS Festtider, hvilke I skal udråbe som Højtids stævner, ved hvilke der skal bringes HERREN Ildofre, Brændofre og Afgrødeofre, Slagtofre og drikofre, hver Dag de for den bestemte Ofre, ");
INSERT INTO dan1931_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","foruden HERRENS Sabbater og foruden eders Gaver og alle eders Løfteofre og alle eders Frivilligofre, som I giver HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Men den femtende Dag i den syvende Måned, når I har indsamlet Landets Afgrøde, skal I fejre HERRENS Højtid, og den skal fejres i syv Dage. På den første Dag skal der holdes Hviledag, og på den ottende dag skal der holdes Hviledag. ");
INSERT INTO dan1931_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Den første Dag skal I tage eder smukke Træfrugter, Palmegrene og Kviste af Løvtræer og Vidjer fra Bækkene og i syv Dage være glade for HERREN eders Guds Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","I skal fejre den som en Højtid for HERREN syv Dage om Året; det skal være eder en evig gyldig Anordning fra Slægt til Slægt; i den syvende Måned skal I fejre den. ");
INSERT INTO dan1931_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","I skal bo i Løvhytter i syv Dage, alle indfødte i Israel skal bo i Løvhytter, ");
INSERT INTO dan1931_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","for at eders Efterkommere kan vide, at jeg lod Israelitterne bo i Løvhytter, da jeg førte dem ud af Ægypten. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Og Moses kundgjorde Israelitterne HERRENS Festtider. ");
INSERT INTO dan1931_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Byd Israelitterne at skaffe dig ren Olivenolie af knuste Frugter til Lysestagen, så Lamperne daglig kan sættes på. ");
INSERT INTO dan1931_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","I Åbenbaringsteltet uden for Forhænget foran Vidnesbyrdet skal Aron gøre den i Stand, så den bestandig kan brænde fra Aften til Morgen for HERRENS Åsyn. Det skal være eder en evig gyldig Anordning fra Slægt til Slægt; ");
INSERT INTO dan1931_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","på Guldlysestagen skal han holde Lamperne i Orden for HERRENS Åsyn, så de kan brænde bestandig. ");
INSERT INTO dan1931_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Du skal tage fint Hvedemel og bage tolv Kager, to Tiendedele Efa til hver Kage, ");
INSERT INTO dan1931_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","og lægge dem i to Rækker, seks i hver Række, på Guldbordet for HERRENS Åsyn; ");
INSERT INTO dan1931_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","på hver Række skal du lægge ren Røgelse, og den skal være Brødenes Offerdel, et Ildoffer for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Han skal bestandig hver Sabbatsdag lægge dem frem for HERRENS Åsyn; det skal være Israelitterne en evig Pagtspligt. ");
INSERT INTO dan1931_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","De skal tilfalde Aron og hans Sønner, som skal spise dem på et helligt Sted, thi de er højhellige; ham tilfalder de som en evig, retmæssig Del af HERRENS Ildofre. ");
INSERT INTO dan1931_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","En israelitisk Kvindes Søn, hvis Fader var Ægypter, gik ud blandt Israelitterne. Da opstod der Strid i Lejren mellem den israelitiske Kvindes Søn og en Israelit, ");
INSERT INTO dan1931_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","og den israelitiske Kvindes Søn forbandede Navnet* og bespottede det. Da førte man ham til Moses. Hans Moder hed Sjelomit, en Datter af Dibri af Dans Stamme. { *dvs. Herrens Navn. V. 16. } ");
INSERT INTO dan1931_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Og de satte ham i Varetægt for at få en Kendelse af HERRENS Mund. ");
INSERT INTO dan1931_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Før Spotteren uden for Lejren. og alle de, der hørte det, skal lægge deres Hænder på hans Hoved, og derefter skal hele Menigheden stene ham. ");
INSERT INTO dan1931_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Og du skal tale til Israelitterne og sige: Når nogen bespotter sin Gud, skal han undgælde for sin Synd; ");
INSERT INTO dan1931_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","og den, der forbander HERRENS Navn, skal lide Døden; hele Menigheden skal stene ham; en fremmed såvel som en indfødt skal lide Døden når han forbander Navnet. ");
INSERT INTO dan1931_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Når nogen slår et Menneske ihjel, skal han lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Den, der slår et Stykke Kvæg ihjel, skal erstatte det et levende Dyr for et levende Dyr. ");
INSERT INTO dan1931_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Når nogen tilføjer sin Næste Legemsskade, skal der handles med ham, som han har handlet, ");
INSERT INTO dan1931_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Brud for Brud, Øje for Øje, Tand for Tand; samme Skade, han tilføjer en anden, skal tilføjes ham selv. ");
INSERT INTO dan1931_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Den, der slår et Stykke Kvæg ihjel, skal erstatte det; men den, der slår et Menneske ihjel, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","En og samme Ret skal gælde for eder; for den fremmede såvel som for den indfødte; thi jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Og Moses sagde det til Israelitterne, og de førte Spotteren uden for Lejren og stenede ham; Israelitterne gjorde som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Og HERREN talede til Moses på Sinaj Bjerg og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Tal til Israelitterne og sig til dem: Når I kommer til det Land, jeg vil give eder, skal Landet holde Sabbatshvile for. HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Seks År skal du beså din Mark, og seks År skal du beskære din Vingård og indsamle Landets Afgrøde; ");
INSERT INTO dan1931_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","men i det syvende År skal Landet have en fuldkommen Sabbatshvile, en Sabbat for HERREN; din Mark må du ikke beså, og din Vingård må du ikke beskære. ");
INSERT INTO dan1931_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Det selvgroede efter din Høst må du ikke høste, og Druerne på de ubeskårne Vinstokke må du ikke plukke; det skal være et Sabbatsår for Landet. ");
INSERT INTO dan1931_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Hvad der gror af sig selv, medens Landet holder Sabbat, skal tjene eder til Føde, dig selv, din Træl og din Trælkvinde, din Daglejer og den indvandrede hos dig, dem, der bor som fremmede hos dig; ");
INSERT INTO dan1931_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","dit Kvæg og de vilde Dyr i dit Land skal hele Afgrøden tjene til Føde. ");
INSERT INTO dan1931_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Og du skal tælle dig syv Årsabbater frem, syv Gange syv År, så de syv Årsabbater udgør et Tidsrum af ni og fyrretyve År. ");
INSERT INTO dan1931_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Så skal du lade Alarmhornet lyde rundt om på den tiende Dag i den syvende Måned; på Forsoningsdagen skal I lade Hornet lyde rundt om i hele eders Land. ");
INSERT INTO dan1931_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Og I skal hellige det halvtredsindstyvende År og udråbe Frigivelse i Landet for alle Indbyggerne; et Jubelår* skal det være eder; enhver af eder skal vende tilbage til sin Ejendom, og enhver af eder skal vende tilbage til sin Slægt; { *egentlig Jobelår. Jobel betyder Vædderhorn. } ");
INSERT INTO dan1931_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","et Jubelår skal dette År, det halvtredsindstyvende, være eder; I må ikke så og ikke høste, hvad der gror af sig selv i det, eller plukke Druer af de ubeskårne Vinstokke; ");
INSERT INTO dan1931_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","thi det er et Jubelår, helligt skal det være eder; I skal spise, hvad Marken bærer af sig selv. ");
INSERT INTO dan1931_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","I Jubelåret skal enhver af eder vende tilbage til sin Ejendom. ");
INSERT INTO dan1931_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Når du sælger din Næste noget eller køber noget af ham, må I ikke forurette hinanden. ");
INSERT INTO dan1931_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Når du køber noget af din Næste, skal der regnes med Årene siden sidste Jubelår; når han sælger dig noget, skal der regnes med Afgrøderne indtil næste Jubelår. ");
INSERT INTO dan1931_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Jo flere År der er tilbage, des højere må du sætte Prisen, jo færre, des lavere, thi hvad han sælger dig, er et vist Antal Afgrøder. ");
INSERT INTO dan1931_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ingen af eder må forurette sin Næste; du skal frygte din Gud, thi jeg er HERREN din Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","I skal gøre efter mine Anordninger og holde mine Lovbud, så I gør efter dem; så skal I bo trygt i Landet, ");
INSERT INTO dan1931_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","og Landet skal give sin Frugt, så I kan spise eder mætte og bo trygt deri. ");
INSERT INTO dan1931_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Men når I siger: “Hvad skal vi da spise i det syvende År, når vi hverken sår eller indsamler vor Afgrøde?” ");
INSERT INTO dan1931_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","så vil jeg opbyde min Velsignelse til Bedste for eder i det sjette År, så det bærer Afgrøde for de tre År; ");
INSERT INTO dan1931_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","i det ottende År skal I så, men I skal leve af gammelt Korn af den sidste Afgrøde indtil det niende År; indtil dets Afgrøde kommer, skal I leve af gammelt Korn. ");
INSERT INTO dan1931_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Jorden i Landet må I ikke sælge uigenkaldeligt; thi mig tilhører Landet, I er kun fremmede og indvandrede hos mig; ");
INSERT INTO dan1931_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","overalt i det Land, I får i Eje, skal I sørge for, at Jorden kan indløses. ");
INSERT INTO dan1931_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Når din Broder kommer i Trang, så han må sælge noget af sin Ejendom, skal hans nærmeste Slægtning melde sig som Løser for ham og indløse, hvad hans Broder har solgt. ");
INSERT INTO dan1931_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Hvis en ingen Løser har, men selv bliver i Stand til at skaffe den fornødne Løsesum, ");
INSERT INTO dan1931_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","skal han udregne, hvor mange År der er gået siden Salget, og kun tilbagebetale Manden der købte det, for den Tid, der er tilbage, og derpå igen overtage sin Ejendom. ");
INSERT INTO dan1931_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Er han derimod ikke i Stand til at skaffe den fornødne Sum til Tilbagebetalingen, så skal det, han har solgt, blive i Køberens Eje til Jubelåret; men i Jubelåret bliver det frit, så han atter kan overtage sin Ejendom. ");
INSERT INTO dan1931_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Når en Mand sælger et Beboelseshus i en By med Mure om, gælder hans Indløsningsret kun et fuldt År efter Salget; hans Indløsningsret gælder et År. ");
INSERT INTO dan1931_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Hvis derfor Indløsning ikke har fundet Sted, før et fuldt År er omme, går Huset i Byen med Mure om uigenkaldeligt over i Køberens og hans Efterkommeres Eje; det bliver ikke frit i Jubelåret. ");
INSERT INTO dan1931_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Derimod henregnes Huse i Landsbyer, der ikke er omgivne af Mure, til Marklandet; for dem gælder Indløsningsretten, og i Jubelåret bliver de fri. ");
INSERT INTO dan1931_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Men med Hensyn til Levitternes Byer, Husene i de Byer, der tilhører dem, da gælder der en ubegrænset Indløsningsret for Levitterne; ");
INSERT INTO dan1931_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","og når en af Levitterne ikke gør sin Indløsningsret gældende, bliver Huset, han solgte, i de Byer, der tilhører dem, frit i Jubelåret, thi Husene i Levitternes Byer er deres Ejendom blandt Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Heller ikke må Græsmarkerne, der hører til deres Byer, sælges, thi de tilhører dem som evigt Eje. ");
INSERT INTO dan1931_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Når din Broder i dit Nabolag kommer i Trang og ikke kan bjærge Livet, skal du holde ham oppe; som fremmed og indvandret skal han leve hos dig. ");
INSERT INTO dan1931_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Du må ikke tage Rente eller Opgæld af ham, men du skal frygte din Gud og lade din Broder leve hos dig; ");
INSERT INTO dan1931_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","du må ikke låne ham Penge mod Renter eller give ham af din Føde mod Opgæld. ");
INSERT INTO dan1931_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Jeg er HERREN eders Gud, som førte eder ud af Ægypten for at give eder Kana'ans Land, for at være eders Gud. ");
INSERT INTO dan1931_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Når din Broder i dit Nabolag kommer i Trang og han må sælge sig selv til dig, må du ikke lade ham arbejde som Træl, ");
INSERT INTO dan1931_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","men han skal være hos dig som Daglejer eller indvandret; han skal arbejde hos dig til Jubelåret. ");
INSERT INTO dan1931_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Da skal han gives fri sammen med sine Børn og vende tilbage til sin Slægt og sine Fædres Ejendom, ");
INSERT INTO dan1931_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","thi mine Trælle er de, som jeg førte ud af Ægypten; de må ikke sælges, som man sælger Trælle. ");
INSERT INTO dan1931_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Du må ikke bruge din Magt over ham med Hårdhed; du skal flygte din Gud. ");
INSERT INTO dan1931_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Men har du Brug for Trælle og Trælkvinder, skal du købe dem af de Folkeslag, der bor rundt om eder; ");
INSERT INTO dan1931_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","også af Børnene efter de indvandrede, der bor som fremmede hos eder, må I købe og af deres Familier, som er hos eder, og som de har avlet i eders Land; de må blive eders Ejendom, ");
INSERT INTO dan1931_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","og dem må I lade gå i Arv og Eje til eders Børn efter eder; dem må I bruge som Trælle på Livstid; men over Israelitterne, eders Brødre, må du ikke bruge din Magt med Hårdhed, Broder over Broder. ");
INSERT INTO dan1931_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Når en fremmed eller en indvandret hos dig kommer til Velstand, og en af dine Brødre i hans Nabolag kommer i Trang, og han må sælge sig til den fremmede eller den indvandrede hos dig eller til en Efterkommer af en fremmeds Slægt, ");
INSERT INTO dan1931_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","så gælder Indløsningsretten for ham efter Salget; en af hans Brødre må indløse ham, ");
INSERT INTO dan1931_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","eller også må hans Farbroder eller Fætter eller en anden kødelig Slægtning af hans Familie indløse ham; han må også indløse sig selv, hvis han får Evne dertil. ");
INSERT INTO dan1931_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Da skal han sammen med den, der købte ham, udregne Tiden fra det År, han solgte sig til ham, til Jubelåret, og Købesummen skal svare til det Åremål; hans Arbejdstid hos ham skal regnes som en Daglejers. ");
INSERT INTO dan1931_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Er der endnu mange År tilbage, skal han i Løsesum udrede den tilsvarende Del af Købesummen. ");
INSERT INTO dan1931_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Og er der kun få År tilbage til Jubelåret, skal han regne dermed og udrede sin Løsesum i Forhold til de År, han har tilbage. ");
INSERT INTO dan1931_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Som en År for År lejet Daglejer skal han være hos ham; du må ikke roligt se på, at Køberen bruger sin Magt over ham med Hårdhed. ");
INSERT INTO dan1931_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Men indløses han ikke på en af disse Måder, skal han frigives i Jubelåret, både han selv og hans Børn. ");
INSERT INTO dan1931_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Thi mig tilhører Israelitterne som Trælle; mine Trælle er de, thi jeg førte dem ud af Ægypten. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","I må ikke gøre eder Afguder; udskårne Billeder og Stenstøtter må I ikke rejse eder, ej heller må I opstille nogen Sten med Billedværk i eders Land for at tilbede den; thi jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mine Sabbater skal I holde, og min Helligdom skal I frygte. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Hvis I følger mine Anordninger og holder mine Bud og handler efter dem, ");
INSERT INTO dan1931_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","vil jeg give eder den Regn, I behøver, til sin Tid, Landet skal give sin Afgrøde, og Markens Træer skal give deres Frugt. ");
INSERT INTO dan1931_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Tærskning skal hos eder vare til Vinhøst, og Vinhøst skal vare til Såtid. I skal spise eder mætte i eders Brød og bo trygt i eders Land. ");
INSERT INTO dan1931_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Jeg vil give Fred i Landet, så I kan lægge eder til Hvile, uden at nogen skræmmer eder op; jeg vil udrydde de vilde Dyr af Landet, og intet Sværd skal hærge eders Land. ");
INSERT INTO dan1931_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","I skal forfølge eders Fjender, og de skal falde for Sværdet foran eder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Fem af eder skal forfølge hundrede, og hundrede af eder skal forfølge ti Tusinde, og eders, Fjender skal falde for Sværdet foran eder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Jeg vil vende mig til eder, jeg vil gøre eder frugtbare og mangfoldige, og jeg vil stadfæste min Pagt med eder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","I skal spise gammelt Korn, til I for det nye Korns Skyld må tømme Laderne for det gamle. ");
INSERT INTO dan1931_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Jeg vil opslå min Bolig midt iblandt eder, og min Sjæl skal ikke væmmes ved eder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Jeg vil vandre iblandt eder og være eders Gud, og I skal være mit Folk. ");
INSERT INTO dan1931_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Jeg er HERREN eders Gud, som førte eder ud af Ægypten, for at I ikke mere skulde være deres Trælle; jeg sønderbrød eders Ågstænger og lod eder vandre med rank Nakke. ");
INSERT INTO dan1931_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Men hvis I ikke adlyder mig og handler efter alle disse Bud, ");
INSERT INTO dan1931_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","hvis I lader hånt om mine Anordninger og væmmes ved mine Lovbud, så I ikke handler efter alle mine Bud, men bryder min Pagt, ");
INSERT INTO dan1931_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","så vil også jeg gøre lige for lige imod eder og hjemsøge eder med skrækkelige Ulykker: Svindsot og Feberglød, så Øjnene sløves og Sjælen vansmægter. Til ingen Nytte sår I eders Sæd, thi eders Fjender skal fortære den. ");
INSERT INTO dan1931_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Jeg vender mit Åsyn imod eder, så I bliver slået på Flugt for eders Fjender; eders Avindsmænd skal underkue eder, og I skal flygte, selv om ingen forfølger eder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Og hvis I alligevel ikke adlyder mig, så vil jeg tugte eder endnu mere, ja syvfold, for eders Synder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Jeg vil bryde eders hovmodige Trods, jeg vil gøre eders Himmel som Jern og eders Jord som Kobber. ");
INSERT INTO dan1931_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Til ingen Nytte skal I slide eders Kræfter op, thi eders Jord skal ikke give sin Afgrøde, og Landets Træer skal ikke give deres Frugt. ");
INSERT INTO dan1931_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Og hvis I alligevel handler genstridigt imod mig og ikke adlyder mig, så vil jeg slå eder endnu mere, ja syvfold, for eders Synder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Jeg vil sende Markens vilde Dyr imod eder, for at de skal røve eders Børn fra eder, udrydde eders Kvæg og mindske eders Tal, så eders Veje bliver øde. ");
INSERT INTO dan1931_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Og hvis I alligevel ikke tager mod min Tugt, men handler genstridigt imod mig, ");
INSERT INTO dan1931_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","så vil også jeg handle genstridigt imod eder og slå eder syvfold for eders Synder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Jeg vil bringe et Hævnens Sværd over eder til Hævn for den brudte Pagt; og søger I Tilflugt i eders Byer, vil jeg sende Pest iblandt eder, så I må overgive eder i Fjendens Hånd. ");
INSERT INTO dan1931_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Når jeg bryder Brødets Støttestav for eder, skal ti Kvinder bage eders Brød i én Bagerovn og give eder Brødet tilbage efter Vægt, så I ikke han spise eder mætte. ");
INSERT INTO dan1931_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Og hvis I alligevel ikke adlyder mig, men handler genstridigt mod mig, ");
INSERT INTO dan1931_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","så vil også jeg i Vrede handle genstridigt mod eder og tugte eder syvfold for eders Synder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","I skal fortære eders Sønners Kød, og eders Døtres Kød skal I fortære. ");
INSERT INTO dan1931_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Jeg vil lægge eders Offerhøje øde og tilintetgøre eders Solsøjler; jeg vil dynge eders Lig oven på Ligene af eders Afgudsbilleder, og min Sjæl skal væmmes ved eder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Jeg vil lægge eders Byer i Ruiner og ødelægge eders Helligdomme og ikke indånde eders liflige Offerduft. ");
INSERT INTO dan1931_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Jeg vil lægge eders Land øde, så eders Fjender, der bor deri, skal blive målløse derover; ");
INSERT INTO dan1931_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","og eder selv vil jeg sprede blandt Folkeslagene, og jeg vil gå bag efter eder med draget Sværd. Eders Land skal blive en Ørken, og eders Byer skal lægges i Ruiner. ");
INSERT INTO dan1931_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Da skal Landet, medens det ligger øde, og I er i eders Fjenders Land, få sine Sabbater godtgjort, da skal Landet hvile og få sine Sabbater godtgjort; ");
INSERT INTO dan1931_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","medens det ligger øde, skal det få den Hvile, det ikke fik på eders Sabbater, dengang I boede deri. ");
INSERT INTO dan1931_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Men dem, der bliver tilbage af eder, over deres Hjerter bringer jeg Modløshed i deres Fjenders Lande, så at Lyden af et raslende Blad kan drive dem på Flugt, så de flygter, som man flygter for Sværdet, og falder, skønt ingen forfølger dem; ");
INSERT INTO dan1931_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","de skal falde over hverandre, som om Sværdet var efter dem, skønt ingen forfølger dem; og I skal ikke holde Stand over for eders Fjender. ");
INSERT INTO dan1931_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","I skal gå til Grunde blandt Folkeslagene, eders Fjenders Land skal fortære eder. ");
INSERT INTO dan1931_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","De, der bliver tilbage af eder, skal sygne hen for deres Misgernings Skyld i eders Fjenders Lande, også for deres Fædres Misgerninger skal de sygne hen ligesom de. ");
INSERT INTO dan1931_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Da skal de bekende deres Misgerning og deres Fædres Misgerning, den Troløshed, de begik imod mig. Også skal de bekende, at fordi de handlede genstridigt mod mig, ");
INSERT INTO dan1931_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","måtte også jeg handle genstridigt mod dem og føre dem bort til deres Fjenders Land; ja, da skal deres uomskårne Hjerter ydmyges, og de skal undgælde for deres Skyld. ");
INSERT INTO dan1931_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Da vil jeg komme min Pagt med Jakob i Hu, også min Pagt med Isak, også min Pagt med Abraham vil jeg komme i Hu, og Landet vil jeg komme i Hu. ");
INSERT INTO dan1931_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Men først må Landet forlades af dem og have sine Sabbater godtgjort, medens det ligger øde og forladt af dem, og de skal undgælde for deres Skyld, fordi, ja, fordi de lod hånt om mine Lovbud og væmmedes ved mine Anordninger. ");
INSERT INTO dan1931_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Men selv da, når de er i deres Fjenders Land, vil jeg ikke lade hånt om dem og ikke væmmes ved dem til deres fuldkomne Undergang, så jeg skulde bryde min Pagt med dem; thi jeg er HERREN deres Gud! ");
INSERT INTO dan1931_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Jeg vil til deres Bedste ihukomme Pagten med Fædrene, som jeg førte ud af Ægypten for Folkeslagenes Øjne for at være deres Gud. Jeg er HERREN! ");
INSERT INTO dan1931_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Det er de Anordninger, Lovbud og Love, HERREN fastsatte mellem sig og Israelitterne på Sinaj Bjerg ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Tal til Israelitterne og sig til dem: Når nogen vil indfri et Løfte til HERREN med et Pengebeløb, et Løfte, der gælder Mennesker, ");
INSERT INTO dan1931_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","så skal Vurderingssummen for Mænd fra det tyvende til det tresindstyvende År være halvtredsindstyve Sekel Sølv efter hellig Vægt; ");
INSERT INTO dan1931_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","men for en Kvinde skal Vurderingssummen være tredive Sekel. ");
INSERT INTO dan1931_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Fra det femte til det tyvende År skal Vurderingssummen for Mandspersoner være tyve Sekel, for Kvinder ti. ");
INSERT INTO dan1931_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Fra den første Måned til det femte År skal Vurderingssummen for et Drengebarn være fem Sekel Sølv, for et Pigebarn tre. ");
INSERT INTO dan1931_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Fra det tresindstyvende År og opefter skal Vurderingssummen være femten Sekel, hvis det er en Mand, men ti, hvis det er en Kvinde. ");
INSERT INTO dan1931_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Men hvis Vedkommende er for fattig til at udrede Vurderingssummen, skal man stille ham frem for Præsten, og Præsten skal foretage en Vurdering af ham; Præsten skal foretage Vurderingen således, at han tager Hensyn til, hvad den, der har aflagt Løftet evner. ");
INSERT INTO dan1931_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Hvis det drejer sig om Kvæg. hvoraf man kan bringe HERREN Offergave, så skal alt, hvad man giver HERREN, være helligt; ");
INSERT INTO dan1931_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","man må ikke erstatte eller ombytte det, hverken et bedre med et ringere eller et ringere med et bedre; men hvis man dog ombytter et Dyr med et andet, da skal ikke blot det, men også det, som det ombyttes med, være helligt. ");
INSERT INTO dan1931_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Men er det et urent Dyr, af den Slags man ikke kan bringe HERREN som Offergave, skal man fremstille Dyret for Præsten, ");
INSERT INTO dan1931_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","og Præsten skal vurdere det, alt efter som det er godt eller dårligt; den Vurderingssum, Præsten fastsætter, skal gælde. ");
INSERT INTO dan1931_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Men vil man selv indløse det, skal man foruden Vurderingssummen yderligere udrede en Femtedel. ");
INSERT INTO dan1931_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Når nogen helliger HERREN sit Hus som Helliggave, skal Præsten vurdere det, alt efter som det er godt eller dårligt, og det skal da stå til den Værdi, Præsten fastsætter. ");
INSERT INTO dan1931_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Men vil den, der har helliget Huset, selv indløse det, skal han betale Vurderingssummen med Tillæg af en Femtedel; så skal det være hans. ");
INSERT INTO dan1931_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Hvis nogen helliger HERREN noget af sin Arvejord, skal Vurderingssummen rette sig efter Udsæden: en Udsæd på en Homer Byg skal regnes til halvtredsindstyve Sølvsekel. ");
INSERT INTO dan1931_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Helliger han sin Jord fra Jubelåret af, skal den stå til den fulde Vurderingssum; ");
INSERT INTO dan1931_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","helliger han den derimod i Tiden efter Jubelåret, skal Præsten beregne ham Summen i Forhold til de År, der er tilbage til næste Jubelår, så der sker Fradrag i Vurderingssummen. ");
INSERT INTO dan1931_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Vil da han, der har helliget Jorden, indløse den, skal han udrede Vurderingssummen med Tillæg af en Femtedel; så går den over i hans Eje. ");
INSERT INTO dan1931_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Men hvis han ikke indløser Jorden og alligevel sælger den til en anden, kan den ikke mere indløses; ");
INSERT INTO dan1931_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","da skal den, når den i Jubelåret bliver fri, være HERREN helliget på samme Måde som en Mark, der er lagt Band på, og tilfalde Præsten som Ejendom. ");
INSERT INTO dan1931_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Hvis nogen helliger HERREN Jord, han har købt, og som ikke hører til hans Arvejord, ");
INSERT INTO dan1931_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","skal Præsten udregne ham Vurderingssummen til næste Jubelår, og han skal da straks erlægge Vurderingssummen som Helliggave til HERREN; ");
INSERT INTO dan1931_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","i Jubelåret går Jorden så tilbage til den Mand, han købte den af, hvis Arvejord den var. ");
INSERT INTO dan1931_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Enhver Vurdering skal ske efter hellig Vægt, tyve Gera på en Sekel. ");
INSERT INTO dan1931_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ingen må hellige HERREN noget af det førstefødte af Kvæget, da det som førstefødt allerede tilhører ham. Hvad enten det er et Stykke Hornkvæg eller Småkvæg, tilhører det HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Hører det derimod til de urene Dyr, kan man løskøbe det efter Vurderingssummen med Tillæg af en Femtedel; indløses det ikke, skal det sælges for Vurderingssummen. ");
INSERT INTO dan1931_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Intet, der er lagt Band på, intet af, hvad nogen af sin Ejendom helliger HERREN ved at lægge Band derpå, være sig Mennesker, Kvæg eller Arvejord, må sælges eller indløses; alt, hvad der er lagt Band på, er højhelligt, det tilhører HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Intet Menneske, der er lagt Band på, må løskøbes, det skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Al Tiende af Landet, både af Landets Sæd og Træernes Frugt, tilhører HERREN, det er helliget HERREN. ");
INSERT INTO dan1931_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Hvis nogen vil indløse noget af sin Tiende, skal han yderligere udrede en Femtedel. ");
INSERT INTO dan1931_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Hvad angår al Tiende af Hornkvæg og Småkvæg, alt hvad der går under Staven*, da skal hvert tiende dyr være helliget HERREN. { *dvs. hvad Hyrden tæller med sin Stav. } ");
INSERT INTO dan1931_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Der må ikke skelnes imellem gode og dårlige Dyr, og ingen Ombytning må finde Sted; hvis nogen ombytter et Dyr, skal ikke blot det, men også det, som det ombyttes med, være helligt; det må ikke indløses. ");
INSERT INTO dan1931_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Det er de Bud, HERREN gav Moses til Israelitterne på Sinaj Bjerg. ");
INSERT INTO dan1931_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","HERREN talede således til Moses i Sinaj Ørken i Åbenbaringsteltet på den første Dag i den anden Måned af det andet år efter deres Udvandring fra Ægypten: ");
INSERT INTO dan1931_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Optag det samlede Tal på hele Israelitternes Menighed efter deres Slægter, efter deres Fædrenehuse, ved at tælle Navnene på alle af Mandkøn, Hoved for Hoved; ");
INSERT INTO dan1931_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","fra Tyveårsalderen og opefter skal du og Aron mønstre alle våbenføre Mænd i Israel, Hærafdeling for Hærafdeling; ");
INSERT INTO dan1931_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","en Mand af hver Stamme skal hjælpe eder dermed, Overhovedet for Stammens Fædrenehuse. ");
INSERT INTO dan1931_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Navnene på de Mænd, der skal stå eder bi, er følgende: Af Ruben Elizur, Sjede'urs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","af Simeon Sjelumiel, Zurisjaddajs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","af Juda Nahasjon, Amminadabs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","af Issakar Netan'el, Zuars Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","af Zebulon Eliab, Helons Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","af Josefs Sønner: Af Efraim Elisjama, Ammihuds Søn, af Manasse Gamliel, Pedazurs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","af Benjamin Abidan, Gid'onis Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","af Dan Ahiezer, Ammisjaddajs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","af Aser Pag'iel, Okrans Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","af Gad Eljasaf, De'uels Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","og af Naftali Ahira, Enans Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Det var de Mænd, der udtoges af Menigheden, Øversterne for deres Fædrenestammer, Overhovederne for Israels Stammer. ");
INSERT INTO dan1931_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Da tog Moses, og Aron disse Mænd, hvis Navne var nævnet, ");
INSERT INTO dan1931_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","og de kaldte hele Menigheden sammen på den første Dag i den anden Måned. Så lod de sig indføre i Familielisterne efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, Hoved for Hoved, ");
INSERT INTO dan1931_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","som HERREN havde pålagt Moses. Således mønstrede han dem i Sinaj Ørken. ");
INSERT INTO dan1931_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Rubens, Israels førstefødtes, Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene Hoved for Hoved, alle af Mandkøn fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","de, som mønstredes af Rubens Stamme, udgjorde 46.500. ");
INSERT INTO dan1931_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeons Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, så mange af dem, som mønstredes ved Optælling af Navnene Hoved for Hoved, alle af Mandkøn, fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","de, som mønstredes af Simeons Stamme, udgjorde 59.300. ");
INSERT INTO dan1931_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gads Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","de, som mønstredes af Gads Stamme, udgjorde 45.650. ");
INSERT INTO dan1931_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Judas Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","de, som mønstredes af Judas Stamme, udgjorde 74.600. ");
INSERT INTO dan1931_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Issakars Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","de, som mønstredes af Issakars Stamme, udgjorde 54.400. ");
INSERT INTO dan1931_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zebulons Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","de, som mønstredes af Zebulons Stamme, udgjorde 57.400. ");
INSERT INTO dan1931_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Josefs Sønner: Efraims Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","de, som mønstredes af Efraims Stamme, udgjorde 40.500; ");
INSERT INTO dan1931_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manasses Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","de, som mønstredes af Manasses Stamme, udgjorde 32.200. ");
INSERT INTO dan1931_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benjamins Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd. ");
INSERT INTO dan1931_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","de, som mønstredes at Benjamins Stamme, udgjorde 35.400. ");
INSERT INTO dan1931_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dans Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","de, som mønstredes af Dans Stamme, udgjorde 62.700. ");
INSERT INTO dan1931_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Asers Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","de, som mønstredes af Asers Stamme, udgjorde 41.500. ");
INSERT INTO dan1931_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naftalis Sønner, deres Efterkommere efter deres Slægter, efter deres Fædrenehuse, ved Optælling af Navnene fra Tyveårsalderen og opefter, alle våbenføre Mænd, ");
INSERT INTO dan1931_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","de, som mønstredes af Naftalis Stamme, udgjorde 53.400. ");
INSERT INTO dan1931_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Det var dem, som mønstredes, dem, Moses og Aron og Israels tolv Øverster, en for hvert Fædrenehus, mønstrede. ");
INSERT INTO dan1931_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Og alle, som mønstredes af Israelitterne efter deres Fædrenehuse fra Tyveårsalderen og opefter, alle våbenføre Mænd i Israel, ");
INSERT INTO dan1931_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","alle, som mønstredes, udgjorde 603.550. ");
INSERT INTO dan1931_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Men Levitterne efter deres Fædrenestamme mønstredes ikke sammen med dem. ");
INSERT INTO dan1931_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Kun Levis Stamme må du ikke mønstre, og dens samlede Tal må du ikke optage sammen med de andre Israelitters. ");
INSERT INTO dan1931_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Du skal overdrage Levitterne Tilsynet med Vidnesbyrdets Bolig, alle dens Redskaber og alt dens Tilbehør; de skal bære Boligen og alle dens Redskaber, de skal betjene den, og rundt om Boligen skal de have deres Lejr. ");
INSERT INTO dan1931_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Når Boligen skal bryde op, skal Levitterne tage den ned, og når Boligen skal gå i Lejr, skal Levitterne rejse den. Enhver Lægmand, der kommer den nær, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israelitterne skal lejre sig hver i sin Lejrafdeling og under sit Felttegn, Hærafdeling for Hærafdeling, ");
INSERT INTO dan1931_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","men Levitterne skal lejre sig rundt om Vidnesbyrdets Bolig, for at der ikke skal komme Vrede over Israelitternes Menighed; og Levitterne skal tage Vare på, hvad der er at varetage ved Vidnesbyrdets Bolig. ");
INSERT INTO dan1931_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Og Israelitterne gjorde ganske, hvad HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","HERREN talede til Moses og, Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Israelitterne skal lejre sig hver under sit Felttegn, under sit Fædrenehus's Mærke; i en Kreds om Åbenbaringsteltet skal de lejre sig. ");
INSERT INTO dan1931_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","På Forsiden mod Øst skal Juda lejre sig under sin Lejrs Felttegn, Hærafdeling for Hærafdeling, med Nahasjon, Amminadabs Søn, som Øverste over Judæerne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","de mønstrede, som udgør hans Hærafdeling, løber op til 74.600 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ved Siden af ham skal Issakars Stamme lejre sig med Netan'el, Zuars Søn, som Øverste over Issakaritterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","de mønstrede, som udgør hans Hærafdeling, løber op til 54.400 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Dernæst Zebulons Stamme med Eliab, Helons Søn, som Øverste over Zebulonitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","de mønstrede, som udgør hans Hærafdeling, løber op til 57.400 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","De mønstrede i Judas Lejr udgør i alt 186.400 Mand, Hærafdeling for Hærafdeling. De skal bryde op først. ");
INSERT INTO dan1931_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ruben skal lejre sig under sin Lejrs Felttegn mod Syd, Hærafdeling for Hærafdeling, med Elizur, Sjede'urs Søn, som Øverste over Rubenitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","de mønstrede, som udgør hans Hærafdeling, løber op til 46.500 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ved Siden af ham skal Simeons Stamme lejre sig med Sjelumiel, Zurisjaddajs Søn, som Øverste over Simeonitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","de mønstrede, som udgør hans Hærafdeling, løber op til 59.300 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Dernæst Gads Stamme med Eljasaf, Re'uels Søn, som Øverste over Gaditterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","de mønstrede, som udgør hans Hærafdeling, løber op til 45.650 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","De mønstrede i Rubens Lejr udgør i alt 151.450 Mand, Hærafdeling for Hærafdeling. De skal bryde op i anden Række. ");
INSERT INTO dan1931_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Derpå skal Åbenbaringsteltet, Levitternes Lejr, bryde op midt imellem de andre Lejre; i den Rækkefølge, de lejrer sig, skal de bryde op, hver på sin Plads, Felttegn for Felttegn. ");
INSERT INTO dan1931_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Efraim skal lejre sig under sin Lejrs Felttegn mod Vest med Elisjama, Ammihuds Søn, som Øverste over Efraimitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","de mønstrede, som udgør hans Hærafdeling, løber op til 40.500 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ved Siden af ham skal Manasses Stamme lejre sig med Gamliel, Pedazurs Søn, som Øverste over Manassitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","de mønstrede, som udgør hans Hærafdeling, løber op til 32.200 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Dernæst Benjamins Stamme med Abidan, Gidonis Søn, som Øverste over Benjaminitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","de mønstrede, som udgør hans Hærafdeling, løber op til 35.400 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","De mønstrede i Efraims Lejr udgør i alt 108.100 Mand, Hærafdeling for Hærafdeling. De skal bryde op i tredje Række. ");
INSERT INTO dan1931_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dan skal lejre sig under sin Lejrs Felttegn mod Nord, Hærafdeling for Hærafdeling, med Ahiezer, Ammisjaddajs Søn, som Øverste over Danitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","de mønstrede, som udgør hans Hærafdeling, løber op til 62.700 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ved Siden af ham skal Asers Stamme lejre sig med Pag'iel, Okrans Søn, som Øverste over Aseritterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","de mønstrede, som udgør hans Hærafdeling, løber op til 41.500 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Dernæst Naftalis Stamme med Ahira, Enans Søn, som Øverste over Naftalitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","de mønstrede, som udgør hans Hærafdeling, løber op fil 53.400 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","De mønstrede i Dans Lejr udgør i alt 157.600 Mand. De skal bryde op sidst, Felttegn for Felttegn. ");
INSERT INTO dan1931_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Det var de mønstrede af Israelitterne efter deres Fædrenehuse, alle de mønstrede i Lejrene, Hærafdeling for Hærafdeling, 603.550 Mand. ");
INSERT INTO dan1931_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Men Levitterne mønstredes ikke sammen med de andre Israelitter, således som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Og ganske som HERREN havde pålagt Moses, slog Israelitterne Lejr, Felttegn for Felttegn, og i den Rækkefølge brød de op, enhver med sine Slægter, med sit Fædrenehus. ");
INSERT INTO dan1931_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Følgende var Arons og Moses' Efterkommere, på den Tid HERREN talede på Sinaj Bjerg. ");
INSERT INTO dan1931_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Navnene på Arons Sønner var følgende: Nadab, den førstefødte, Abihu, Eleazar og Itamar; ");
INSERT INTO dan1931_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","det var Navnene på Arons Sønner, de salvede Præster, som indsattes til Præstetjeneste. ");
INSERT INTO dan1931_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Men Nadab og Abihu døde for HERRENS Åsyn, da de frembar fremmed Ild for HERRENS Åsyn i Sinaj Ørken, og de havde ingen Sønner. Således kom Eleazar og Itamar til at gøre Præstetjeneste for deres Fader Arons Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Lad Levis Stamme træde frem og stil dem frem for Præsten Aron, for at de kan gå ham til Hånde. ");
INSERT INTO dan1931_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","De skal tage Vare på, hvad han og hele Menigheden har at varetage foran Åbenbaringsteltet, og således udføre Arbejdet ved Boligen, ");
INSERT INTO dan1931_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","og de skal tage Vare på alle Åbenbaringsteltets Redskaber og på, hvad Israelitterne har at varetage, og således udføre Arbejdet ved Boligen. ");
INSERT INTO dan1931_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Altså skal du overgive Aron og hans Sønner Levitterne; de er ham overgivet som Gave fra Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Men Aron og hans Sønner skal du sætte til at tage Vare på deres Præstetjeneste; enhver Lægmand, som trænger sig ind deri, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Se, jeg har selv udtaget Levitterne af Israelitternes Midte i Stedet for alt det førstefødte, der åbner Moders Liv hos Israelitterne, og Levitterne er blevet min Ejendom; ");
INSERT INTO dan1931_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","thi mig tilhører alt det førstefødte. Dengang jeg dræbte alt det førstefødte i Ægypten, helligede jeg mig alt det førstefødte i Israel, både af Mennesker og Dyr; mig HERREN skal de tilhøre. ");
INSERT INTO dan1931_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","HERREN talede til Moses i Sinaj Ørken og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Du skal mønstre Levis Sønner efter deres Fædrenehuse, efter deres Slægter; alle af Mandkøn fra en Måned og opefter skal du mønstre. ");
INSERT INTO dan1931_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Da mønstrede Moses dem på HERRENS Bud, som der var ham pålagt. ");
INSERT INTO dan1931_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Følgende var Levis Sønner efter deres Navne: Gerson, Kehat og Merari. ");
INSERT INTO dan1931_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Følgende var Navnene på Gersons Sønner efter deres Slægter: Libni og Sjim'i; ");
INSERT INTO dan1931_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kehats Sønner efter deres Slægter var: Amram, Jizhar, Hebron og Uzziel; ");
INSERT INTO dan1931_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Meraris Sønner efter deres Slægter var: Mali og Musji. Det var Levitternes Slægter efter deres Fædrenehuse. ");
INSERT INTO dan1931_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Fra Gerson nedstammede Libnitternes og Sjimitternes Slægter; det var Gersonitternes Slægter. ");
INSERT INTO dan1931_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","De, som mønstredes af dem, da alle af Mandkøn fra en Måned og opefter blev optalt, de, som mønstredes af dem, udgjorde 7.500. ");
INSERT INTO dan1931_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gersonitternes Slægter havde deres Lejrplads bag ved Boligen mod Vest. ");
INSERT INTO dan1931_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Øverste for Gersonitternes Fædrenehus var Eljasar, Laels Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gersonitterne havde ved Åbenbaringsteltet at tage Vare på selve Boligen og Teltdækket, dets Dække, Forhænget for Åbenbaringsteltets Indgang, ");
INSERT INTO dan1931_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Forgårdens Omhæng, Forhænget for Indgangen til Forgården, der omgav Boligen og Alteret, og dens Teltreb, alt Arbejdet dermed. ");
INSERT INTO dan1931_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Fra Kehat nedstammede Amramitternes, Jizharitternes, Hebronitternes og Uzzielitternes Slægter; det var Kehatitternes Slægter. ");
INSERT INTO dan1931_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","De, der mønstredes af dem, da alle af Mandkøn fra en Måned og opefter blev optalt, udgjorde 8.600*, som tog Vare på, hvad der var at varetage ved Helligdommen. { *vistnok Feilskrift for 8.300, ellers stemmer Sammentællingen (v. 39) ikke. } ");
INSERT INTO dan1931_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kehatitternes Slægter havde deres Lejrplads ved Boligens Sydside. ");
INSERT INTO dan1931_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Øverste for Kehatitternes Slægters Fædrenehus var Elizafan, Uzziels Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","De havde at tage Vare på Arken, Bordet, Lysestagen, Altrene, Helligdommens Redskaber, som brugtes ved Tjenesten, og Forhænget med dertil hørende Arbejde. ");
INSERT INTO dan1931_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Øverste over Levitternes Øverster var Eleazar, Præsten Arons Søn, som havde Tilsyn med dem, der tog Vare på, hvad der var at varetage ved Helligdommen. ");
INSERT INTO dan1931_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Fra Merari nedstammede Malitternes og Musjitternes Slægter; det var Meraris Slægter. ");
INSERT INTO dan1931_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","De, som mønstredes af dem, da alle af Mandkøn fra en Måned og opefter blev optalt, udgjorde 6.200. ");
INSERT INTO dan1931_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Øverste for Meraris Slægters Fædrenehus var Zuriel, Abihajils Søn. De havde deres Lejrplads ved Boligens Nordside. ");
INSERT INTO dan1931_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Meraritterne var sat til at tage Vare på Boligens Brædder, Tværstænger, Piller og Fodstykker, alle dens Redskaber og alt det dertil hørende Arbejde, ");
INSERT INTO dan1931_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Pillerne til Forgården, som var rundt om den, med Fodstykker, Pæle og Reb. ");
INSERT INTO dan1931_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Foran Boligen, på Åbenbaringsteltets Forside mod Øst, havde Moses, Aron og hans Sønner deres Lejrpladser, og de tog Vare på alt det, Israelitterne havde at varetage ved Boligen. Enhver Lægmand, der trængte sig ind i det, måtte lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","De mønstrede af Levitterne, de, som Moses og Aron mønstrede på HERRENS Bud efter deres Slægter, alle af Mandkøn fra en Måned og opefter, udgjorde i alt 22.000. ");
INSERT INTO dan1931_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","HERREN sagde til Moses: Du skal mønstre alle førstefødte af Mandkøn blandt Israelitterne fra en Måned og opefter og optage Tallet på deres Navne. ");
INSERT INTO dan1931_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Så skal du udtage Levitterne til mig HERREN i Stedet for alle Israelitternes førstefødte og ligeledes Levitternes Kvæg i Stedet for alt det førstefødte af Israelitternes Kvæg. ");
INSERT INTO dan1931_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Og Moses mønstrede, som HERREN havde pålagt ham, alle Israelitternes førstefødte; ");
INSERT INTO dan1931_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","og da Navnene på dem fra en Måned og opefter optaltes, udgjorde de førstefødte af Mandkøn, alle de, som mønstredes i alt 22.273. ");
INSERT INTO dan1931_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Derpå talede HERREN til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Tag Levitterne i Stedet for alle Israelitternes førstefødte og ligeledes Levitternes Kvæg i Stedet for deres Kvæg, så at Levitterne kommer til at tilhøre mig HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Men til Udløsning af de 273, hvormed Antallet af Israelitternes førstefødte overstiger Levitternes Antal, ");
INSERT INTO dan1931_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","skal du tage fem Sekel for hvert Hoved, efter hellig Vægt skal du tage dem, tyve Gera på en Sekel; ");
INSERT INTO dan1931_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","og Pengene skal du give Aron og hans Sønner som Udløsning for de overskydende. ");
INSERT INTO dan1931_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Da tog Moses Løsepengene af de overskydende, dem, der ikke var udløst ved Levitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","af Israelitternes førstefødte tog han Pengene, 1.365 Sekel efter hellig Vægt. ");
INSERT INTO dan1931_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Og Moses gav Aron og hans Sønner Løsepengene efter HERRENS Bud, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","HERREN talede til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Optag blandt Levitterne Tallet på Kehatitterne efter deres Slægter, efter deres Fædrenehuse, ");
INSERT INTO dan1931_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","fra Trediveårsalderen og opefter til Halvtredsårsalderen, alle, der skal gøre Tjeneste med' at udføre Arbejde ved Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kehatitternes Arbejde ved Åbenbaringsteltet skal være med de højhellige Ting. ");
INSERT INTO dan1931_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Når Lejren bryder op, skal Aron og hans Sønner gå ind og tage det indre Forhæng ned og tildække Vidnesbyrdets Ark dermed; ");
INSERT INTO dan1931_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ovenover skal de lægge et Dække af Tahasjskind og derover igen brede et ensfarvet violet Purpurklæde; derpå skal de stikke Bærestængerne ind. ");
INSERT INTO dan1931_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Og over Skuebrødsbordet skal de brede et violet Purpurklæde og stille Fadene, Kanderne, Skålene og Krukkerne til Drikofferet derpå, og Brødet, som stadig skal ligge fremme, skal ligge derpå; ");
INSERT INTO dan1931_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ovenover skal de brede et karmoisinrødt Klæde og dække dette til med et Dække af Tahasjskind; derpå skal de stikke Bærestængerne ind. ");
INSERT INTO dan1931_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Så skal de tage et violet Purpurklæde og dermed tildække Lysestagen, dens Lamper, Sakse, Bakker og alle Oliekrukkerne, de Ting, som bruges ved Betjeningen deraf, ");
INSERT INTO dan1931_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","og de skal lægge den med alt dens Tilbehør i et Dække af Tahasjskind og så lægge det på Bærebøren. ");
INSERT INTO dan1931_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Over Guldalteret skal de ligeledes brede et violet Purpurklæde og dække dette til med et Dække af Tahasjskind; derpå skal de stikke Bærestængerne ind. ");
INSERT INTO dan1931_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Og de skal tage alle Redskaber, som bruges ved Tjenesten i Helligdommen, og lægge dem i et violet Purpurklæde og dække dem til med et Dække af Tahasjskind og lægge dem på Bærebøren. ");
INSERT INTO dan1931_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Fremdeles skal de rense Alteret for Aske og brede et rødt Purpurklæde derover ");
INSERT INTO dan1931_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","og på det lægge alle Redskaberne, som bruges til Tjenesten derved, Panderne, Gaflerne, Skovlene og Skålene, alle Alterets Redskaber, og derover skal de brede et Dække af Tahasjskind; derpå skal de stikke Bærestængerne ind. ");
INSERT INTO dan1931_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Når så ved Lejrens Opbrud Aron og hans Sønner er færdige med at tilhylle de hellige Ting og alle de hellige Redskaber, skal Kehatitterne træde til og bære dem; men de må ikke røre ved de hellige Ting; thi gør de det, skal de dø. Det er, hvad Kehatitterne skal bære af Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Med Eleazar, Præsten Arons Søn, påhviler Tilsynet med Olien til Lysestagen, den vellugtende Røgelse, det daglige Afgrødeoffer og Salveolien og desuden Tilsynet med hele Boligen og alt, hvad der er deri af hellige Ting og deres Tilbehør. ");
INSERT INTO dan1931_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","HERREN talede til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Sørg for, at Kehatitternes Slægters Stamme ikke udryddes af Levitternes Midte! ");
INSERT INTO dan1931_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Således skal I forholde eder med dem, for at de kan blive i Live og undgå Døden, når de nærmer sig de højhellige Ting: Aron og hans Sønner skal træde til og anvise hver enkelt af dem, hvad han skal gøre, og hvad han skal bære, ");
INSERT INTO dan1931_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","for at de ikke et eneste Øjeblik skal komme til at se de hellige Ting; thi gør de det, skal de dø. ");
INSERT INTO dan1931_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Optag også Tallet på Gersonitterne efter deres Fædrenehuse, efter deres Slægter; ");
INSERT INTO dan1931_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","fra Trediveårsalderen og opefter til Halvtredsårsalderen skal du mønstre dem, alle, der skal gøre Tjeneste med at udføre Arbejdet ved Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Dette er Gersonitternes Arbejde, hvad de skal gøre, og hvad de skal bære: ");
INSERT INTO dan1931_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","De skal bære Boligens Tæpper, Åbenbaringsteltet med dets Dække og Dækket af Tahasjskind ovenover, Forhænget til Åbenbaringsteltets Indgang, ");
INSERT INTO dan1931_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Forgårdens Omhæng og Forhænget for Indgangen til Forgården, der er rundt om Boligen og Alteret, dens Teltreb og alle Redskaber, som hører til Arbejdet derved; og alt, hvad der skal gøres derved, skal de udføre. ");
INSERT INTO dan1931_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Efter Arons og hans Sønners Bud skal Gersonitterne udføre deres Arbejde både med det, de skal bære, og med det, de skal gøre; og I skal anvise dem alt, hvad de skal bære, Stykke for Stykke. ");
INSERT INTO dan1931_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Det er det Arbejde, Gersonitternes Sønners Slægter skal have ved Åbenbaringsteltet, og de skal varetage det under Itamars, Præsten Arons Søns, Tilsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Meraritterne skal du mønstre efter deres Slægter, efter deres Fædrenehuse; ");
INSERT INTO dan1931_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","fra Trediveårsalderen og opefter til Halvtredsårsalderen skal du mønstre dem, alle, som skal gøre Tjeneste med at udføre Arbejde ved Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Dette er, hvad der påhviler dem at bære, alt, hvad der hører til deres Arbejde ved Åbenbaringsteltet: Boligens Brædder, dens Tværstænger, Piller og Fodstykker, ");
INSERT INTO dan1931_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Pillerne til Forgården, som er rundt om den, med Fodstykker, Pæle og Reb, alle tilhørende Redskaber og alt, hvad der hører til Arbejdet derved; Stykke for Stykke skal I anvise dem alle de Ting, det påhviler dem at bære. ");
INSERT INTO dan1931_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Det er det Arbejde, der påhviler Meraritternes Slægter, alt, hvad der hører til deres Arbejde ved Åbenbaringsteltet, under Itamars, Præsten Arons Søns, Tilsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Så mønstrede Moses og Aron og Menighedens Øverster Kehatitternes Sønner efter deres Slægter, efter deres Fædrenehuse, ");
INSERT INTO dan1931_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","fra Trediveårsalderen og opefter til Halvtredsårsalderen, alle, som skulde gøre Tjeneste med at udføre Arbejde ved Åbenbaringsteltet, ");
INSERT INTO dan1931_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","og de, der mønstredes af dem efter deres Slægter, udgjorde 2.750. ");
INSERT INTO dan1931_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Det var dem, som mønstredes af Kehatitternes Slægter, alle dem, der skulde udføre Arbejde ved Åbenbaringsteltet, som Moses og Aron mønstrede efter HERRENS Bud ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","De, der mønstredes af Gersonitterne efter deres Slægter, efter deres Fædrenehuse, ");
INSERT INTO dan1931_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","fra Trediveårsalderen og opefter til Halvtredsårsalderen, alle, som skulde gøre Tjeneste med at udføre Arbejde ved Åbenbaringsteltet, ");
INSERT INTO dan1931_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","de, der mønstredes af dem efter deres Slægter, efter deres Fædrenehuse, udgjorde 2.630. ");
INSERT INTO dan1931_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Det var dem, som mønstredes af Gersonitternes Slægter, alle dem, der skulde udføre Arbejde ved Åbenbaringsteltet, som Moses og Aron mønstrede efter HERRENS Bud. ");
INSERT INTO dan1931_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","De, der mønstredes af Meraritternes Slægter efter deres Slægter, efter deres Fædrenehuse, ");
INSERT INTO dan1931_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","fra Trediveårsalderen og opefter til Halvtredsårsalderen, alle, som skulde gøre Tjeneste med at udføre Arbejde ved Åbenbaringsteltet, ");
INSERT INTO dan1931_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","de, der mønstredes af dem efter deres Slægter, udgjorde 3.200. ");
INSERT INTO dan1931_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Det var dem, som mønstredes af Meraritternes Slægter, som Moses og Aron mønstrede efter HERRENS Bud ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Alle, som mønstredes, som Moses og Aron og Israels Øverster mønstrede af Levitterne efter deres Slægter, efter deres Fædrenehuse, ");
INSERT INTO dan1931_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","fra Trediveårsalderen og opefter til Halvtreds års alderen, alle, som skulde udføre Arbejde ved Åbenbaringsteltet både med hvad der skulde gøres, og hvad der skulde bæres, ");
INSERT INTO dan1931_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","de, der mønstredes af dem, udgjorde 8.580. ");
INSERT INTO dan1931_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Efter HERRENS Bud ved Moses anviste man hver enkelt af dem, hvad han skulde gøre eller bære; det blev dem anvist, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Byd Israelitterne at fjerne alle spedalske fra Lejren, alle, der lider af Flåd, og alle, der er blevet urene ved Lig; ");
INSERT INTO dan1931_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","både Mænd og Kvinder skal I fjerne og føre uden for Lejren, for at de ikke skal gøre deres Lejr uren, hvor jeg bor midt iblandt dem. ");
INSERT INTO dan1931_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Det gjorde Israelitterne så; de førte dem uden for Lejren, således som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Sig til Israelitterne: Når en Mand eller Kvinde begår nogen af alle de Synder, som Mennesker begår, således at han gør sig skyldig i Svig mod HERREN, og det Menneske derved pådrager sig Skyld, ");
INSERT INTO dan1931_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","så skal de bekende Synden, de har begået, og Gerningsmanden skal erstatte det, han har forbrudt sig med, efter dets fulde Værdi med Tillæg af en Femtedel og give det til den, han har forbrudt sig imod. ");
INSERT INTO dan1931_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Og hvis denne ikke har efterladt sig nogen Løser, hvem han kan yde Erstatningen, så skal Erstatningen, som ydes, tilfalde HERREN, det vil sige Præsten, foruden den Soningsvædder, ved hvilken der skaffes ham Soning. ");
INSERT INTO dan1931_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Al Offerydelse, alle Helliggaver, som Israelitterne frembærer til Præsten, skal tilfalde ham. ");
INSERT INTO dan1931_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Alle Helliggaver skal tilfalde ham; hvad nogen giver Præsten, skal tilfalde ham. ");
INSERT INTO dan1931_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Tal til Israelitterne og sig til dem: Når en Hustru forser sig imod sin Mand og er ham utro, ");
INSERT INTO dan1931_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","idet en anden Mand har Samleje med hende, uden at det er kommet til hendes Mands Kundskab, og uden at det er blevet opdaget, skønt hun har besmittet sig, og uden at der er noget Vidne imod hende, da hun ikke er grebet på fersk Gerning, ");
INSERT INTO dan1931_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","og han gribes af Skinsygens Ånd, så han bliver skinsyg på sin Hustru, som også i Virkeligheden har besmittet sig, eller han gribes af Skinsygens Ånd, så han bliver skinsyg på sin Hustru, skønt hun ikke har besmittet sig, ");
INSERT INTO dan1931_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","så skal Manden bringe sin Hustru til Præsten og medbringe som Offergave for hende en Tiendedel Efa Bygmel; han må hverken hælde Olie over eller komme Røgelse på, thi det er et Skinsyge Afgrødeoffer, et Minde Afgrødeoffer, der skal minde om Brøde. ");
INSERT INTO dan1931_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Så skal Præsten føre hende frem og stille hende for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Og Præsten skal tage helligt Vand i et Lerkar, og af Støvet på Boligens Gulv skal Præsten tage noget og komme i Vandet. ");
INSERT INTO dan1931_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Så skal Præsten stille Kvinden frem for HERRENS Åsyn, løse hendes Hår og lægge Minde Afgrødeofferet i hendes Hænder; det er et Skinsyge Afgrødeoffer; og Præsten skal have den bitre Vandes Forbandelsesvand i Hånden. ");
INSERT INTO dan1931_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Derpå skal Præsten besværge Kvinden og sige til hende: “Hvis ingen har haft Samleje med dig, hvis du ikke har forset dig imod din Mand og besmittet dig, så skal dette den bitre Vandes Forbandelsesvand ikke skade dig. ");
INSERT INTO dan1931_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Men har du forset dig imod din Mand og besmittet dig, og har en anden end din Mand haft Samleje med dig” - ");
INSERT INTO dan1931_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Præsten besværger nu kvinden med Forbandelsens Ed og siger til hende - “så gøre HERREN dig til en Forbandelse og Besværgelse i dit Folk*, idet han lader din Lænd visne og din Bug svulme op; { *dvs. hendes Navn skal bruges ved Forbandelser og Besværgelser. Jer. 24, 9; 42, 18. } ");
INSERT INTO dan1931_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Forbandelsesvandet her komme ind i dine Indvolde, så din Bug svulmer op og din Lænd visner!” Og kvinden skal sige: “Amen, Amen!” ");
INSERT INTO dan1931_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Derpå skal Præsten skrive disse Forbandelser op på et Blad og vaske dem ud i den bitre Vandes Vand ");
INSERT INTO dan1931_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","og give Kvinden den bitre Vandes Forbandelsesvand at drikke, for at Forbandelsesvandet kan komme ind i hende til bitter Vånde. ");
INSERT INTO dan1931_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Derefter skal Præsten tage Skinsyge Afgrødeofferet af Kvindens Hånd, udføre Svingningen dermed for HERRENS Åsyn og bære det hen til Alteret. ");
INSERT INTO dan1931_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Og Præsten skal tage en Håndfuld af Afgrødeofferet, det, som skal ofres deraf, og bringe det som Røgoffer på Alteret og derpå give Kvinden Vandet at drikke. ");
INSERT INTO dan1931_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Når han har givet hende Vandet at drikke, vil Forbandelsesvandet, dersom hun har besmittet sig og været sin Mand utro, blive til bitter Vånde, når det kommer ind i hende, hendes Bug vil svulme op og hendes Lænd visne, og Kvinden bliver en Forbandelse i sit Folk. ");
INSERT INTO dan1931_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Men dersom Kvinden ikke har besmittet sig, dersom hun er ren, bliver hun uskadt og kan få Børn. ");
INSERT INTO dan1931_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Det er Loven om Skinsyge; når en Hustru forser sig imod sin Mand og besmittes, ");
INSERT INTO dan1931_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","eller når en Mand gribes af Skinsygens Ånd og bliver skinsyg på sin Hustru, så skal han fremstille Hustruen for HERRENS Åsyn, og Præsten skal handle med hende efter alt i denne Lov; ");
INSERT INTO dan1931_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Manden skal være sagesløs, men sådan en Hustru skal undgælde for sin Brøde. ");
INSERT INTO dan1931_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Tal til Israelitterne og sig til dem: Når en Mand eller Kvinde vil aflægge et Nasiræerløfte for således at indvie sig til HERREN, ");
INSERT INTO dan1931_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","skal han afholde sig fra Vin og stærk Drik; Vineddike og stærk Drik må han ikke drikke, ej heller nogen som helst drik af Druer; han må hverken spise friske eller tørrede Druer; ");
INSERT INTO dan1931_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","så længe hans Indvielse varer, må han intet som helst nyde, der kommer af Vinstokken, hverken umodne Druer eller friske Skud. ");
INSERT INTO dan1931_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Så længe hans Indvielsesløfte gælder, må ingen Ragekniv komme på hans Hoved; indtil Udløbet af den Tid han indvier sig til HERREN, skal han være hellig og lade sit Hovedhår vokse frit. ");
INSERT INTO dan1931_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Hele den Tid han har indviet sig til HERREN, må han ikke komme Lig nær; ");
INSERT INTO dan1931_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","selv når hans Fader eller Moder, hans Broder eller Søster dør, må han ikke pådrage sig Urenhed ved dem, thi han bærer sin Guds indvielse på sit Hoved. ");
INSERT INTO dan1931_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Så længe hans Indvielse varer, er han helliget HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Men når nogen uventet og pludselig dør i hans Nærhed, og han således bringer Urenhed over sit indviede Hoved, skal han rage sit Hoved, den Dag han atter bliver ren; den syvende Dag skal han rage det; ");
INSERT INTO dan1931_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","og den ottende Dag skal han bringe to Turtelduer eller Dueunger til Præsten ved Åbenbaringsteltets Indgang. ");
INSERT INTO dan1931_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Og Præsten skal ofre den ene som Syndoffer og den anden som Brændoffer og skaffe ham Soning, fordi han har syndet ved at røre ved Lig. Derpå skal han samme Dag atter hellige sit Hoved ");
INSERT INTO dan1931_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","og atter indvie sig til HERREN for lige så lang Tid, som han før havde indviet sig, og bringe et årgammelt Lam som Skyldoffer; den forløbne Tid regnes ikke med, da han har bragt Urenhed over sit indviede Hoved. ");
INSERT INTO dan1931_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Dette er Loven om Nasiræeren: Når hans indvielsestid er til Ende, skal han begive sig til Åbenbaringsteltets Indgang ");
INSERT INTO dan1931_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","og som Offergave bringe HERREN et årgammelt, lydefrit Vædderlam til Brændoffer, et årgammelt, lydefrit Hunlam til Syndoffer og en lydefri Vædder til Takoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","en Kurv med usyret Bagværk, Kager af fint Hvedemel, rørte i Olie, og usyrede Fladbrød, smurte med Olie, desuden det tilhørende Afgrødeoffer og de tilhørende Drikofre. ");
INSERT INTO dan1931_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Så skal Præsten bringe det for HERRENS Åsyn og ofre hans Syndoffer og Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","og Vædderen skal han ofre som Takoffer til HERREN tillige med de usyrede Brød i Kurven; derpå skal Præsten ofre hans Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Så skal Nasiræeren ved Indgangen til Åbenbaringsteltet rage sit indviede Hoved og tage sit indviede Hovedhår og kaste det i Ilden under Takofferet. ");
INSERT INTO dan1931_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Og Præsten skal tage den kogte Bov af Vædderen og én usyret Kage og ét usyret Fladbrød af Kurven og lægge dem på Nasiræerens Hænder, efter at han har afraget sit indviede Hovedhår. ");
INSERT INTO dan1931_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Og Præsten skal udføre Svingningen dermed for HERRENS Åsyn; det tilfalder Præsten som Helliggave foruden Svingningsbrystet og Offerydelseskøllen. Derefter må Nasiræeren atter drikke Vin. ");
INSERT INTO dan1931_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Det er Loven om Nasiræeren, der aflægger Løfte, om hans Offergave til HERREN i Anledning af Indvielsen, foruden hvad han ellers evner at give; overensstemmende med Løftet, han aflægger, skal han forholde sig efter den for hans Indvielse gældende Lov. ");
INSERT INTO dan1931_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Tal til Aron og hans Sønner og sig: Når I velsigner Israelitterne, skal I sige til dem: ");
INSERT INTO dan1931_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","HERREN velsigne dig og bevare dig, ");
INSERT INTO dan1931_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","HERREN lade sit Ansigt lyse over dig og være dig nådig, ");
INSERT INTO dan1931_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","HERREN løfte sit Åsyn på dig og give dig Fred! ");
INSERT INTO dan1931_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Således skal de lægge mit Navn på Israelitterne, og jeg vil velsigne dem. ");
INSERT INTO dan1931_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Da Moses var færdig med at rejse Boligen og havde salvet og helliget den med alt dens Tilbehør og ligeledes salvet og helliget Alteret med alt dets Tilbehør, ");
INSERT INTO dan1931_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","trådte Israels Øverster, Overhovederne for deres Fædrenehuse, Stammernes Øverster, der havde forestået Mønstringen, frem ");
INSERT INTO dan1931_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","og førte deres Offergave frem for HERRENS Åsyn, seks lukkede Vogne og tolv Stykker Hornkvæg, en Vogn for hver to Øverster og et Stykke Hornkvæg for hver én, og de bragte dem hen foran Boligen. ");
INSERT INTO dan1931_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Da sagde HERREN til Moses: ");
INSERT INTO dan1931_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Modtag dette af dem, for at det kan bruges til Arbejdet ved Åbenbaringsteltet, og giv Levitterne det med Henblik på hver enkeltes særlige Arbejde! ");
INSERT INTO dan1931_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Så modtog Moses Vognene og Hornkvæget og gav Levitterne dem. ");
INSERT INTO dan1931_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","To Vogne og fire Stykker Hornkvæg gav han Gersonitterne med Henblik på deres særlige Arbejde, ");
INSERT INTO dan1931_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","og fire Vogne og otte Stykker Hornkvæg gav han Meraritterne med Henblik på deres særlige Arbejde under Itamars, Præsten Arons Søns, Ledelse. ");
INSERT INTO dan1931_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Derimod gav han ikke Kehatitterne noget, thi dem var Arbejdet med de hellige Ting overdraget, og de skulde bære dem på Skuldrene. ");
INSERT INTO dan1931_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Fremdeles bragte Øversterne Offergaver til Alterets indvielse, dengang det blev salvet, og Øversterne bragte deres Offergaver hen foran Alteret. ");
INSERT INTO dan1931_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Da sagde HERREN til Moses: Lad hver af Øversterne få sin Dag til at bringe sin Offergave til Alterets Indvielse. ");
INSERT INTO dan1931_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Den, som første Dag bragte sin Offergave, var Nahasjon, Amminadabs Søn af Judas Stamme. ");
INSERT INTO dan1931_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Og hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","og til Takoffer to Stykker Hornkvæg, fem Væddere, fem Bukke og fem årgamle Lam. Det var Nahasjons, Amminadabs Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Anden Dag bragte Netan'el, Zuars Søn, Issakars Øverste, sin Offergave; ");
INSERT INTO dan1931_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","han bragte som Offergave et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","og til Takoffer to Stykker Hornkvæg, fem Væddere, fem Bukke og fem årgamle Lam. Det var Netan'els, Zuars Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Tredje Dag kom Zebulonitternes Øverste, Eliab, Helons Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke og fem årgamle Lam. Det var Eliabs, Helons Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Fjerde Dag kom Rubenitternes Øverste, Elizur, Sjede'urs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","en ung Tyr, en Vædder, ");
INSERT INTO dan1931_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","et årgammelt Lam til Brændoffer, en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke og fem årgamle Lam. Det var Elizurs, Sjede'urs Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Femte Dag kom Simeonitternes Øverste, Sjelumiel, Zurisjaddajs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke. og fem årgamle Lam. Det var Sjelumiels, Zurisjaddajs Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Sjette Dag kom Gaditternes Øverste, Eljasaf, De'uels Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","hans Offergaver et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke og fem årgamle Lam. Det var Eljasafs, De'uels Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Syvende Dag kom Efraimitternes Øverste, Elisjama, Ammihuds Søn: ");
INSERT INTO dan1931_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","hans offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke og fem årgamle Lam. Det var Elisjamas, Ammihuds Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ottende Dag kom Mannassitternes Øverste, Gamliel, Pedazurs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke og fem årgamle Lam. Det var Gamliels, Pedazurs Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Niende dag kom Benjaminitternes Øverste, Abidan, Gidonis Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","og til Takoffer to Stykker Hornkvæg, fem, Vædre, fem Bukke og fem årgamle Lam. Det var Abidans, Gidonis Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Tiende Dag kom Danitternes Øverste, Ahiezer, Ammisjaddajs Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke og fem årgamle Lam. Det var Ahiezers, Ammisjaddajs Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ellevte Dag kom Aseritternes Øverste, Pag'iel, Okrans Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","en Kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke og fem årgamle Lam. Det var Pag'iels, Okrans Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Tolvte Dag kom Naftalitternes Øverste, Ahira, Enans Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","hans Offergave var et Sølvfad, der vejede 130 Sekel, og en Sølvskål på 70 Sekel efter hellig Vægt, begge fyldte med fint Hvedemel, rørt i Olie, til Afgrødeoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","en kande på 10 Guldsekel, fyldt med Røgelse, ");
INSERT INTO dan1931_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","en ung Tyr, en Vædder, et årgammelt Lam til Brændoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","en Gedebuk til Syndoffer ");
INSERT INTO dan1931_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","og til Takoffer to Stykker Hornkvæg, fem Vædre, fem Bukke og fem årgamle Lam. Det var Ahiras, Enans Søns, Offergave. ");
INSERT INTO dan1931_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Det var Gaverne fra Israelitternes Øverster til Alterets Indvielse, dengang det blev salvet: 12 Sølvfade, 12 Sølvskåle, 12 Guldkander, ");
INSERT INTO dan1931_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","hvert Sølvfad på 130 Sekel og hver Sølvskål på 70 Sekel, alle Sølvkar tilsammen 2.400 Sekel efter hellig Vægt; ");
INSERT INTO dan1931_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","12 Guldkander, fyldte med Røgelse, hver på 10 Sekel efter hellig Vægt, alle Guldkander tilsammen 120 Sekel. ");
INSERT INTO dan1931_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Kvæget til Brændofferet var i alt 12 unge Tyre, 12 Vædre, 12 årgamle Lam med tilhørende Afgrødeofre, 12 Gedebukke til Syndoffer; ");
INSERT INTO dan1931_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Kvæget til Takofferet var i alt 24 unge Tyre, 60 Vædre, 60 Bukke og 60 årgamle lam. Det var Gaverne til Alterets indvielse, efter at det var salvet. ");
INSERT INTO dan1931_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Da Moses gik ind i Åbenbaringsteltet for at tale med HERREN, hørte han Røsten tale til sig fra Sonedækket oven over Vidnesbyrdets Ark, fra Pladsen mellem de to Keruber. Og han talede til ham. ");
INSERT INTO dan1931_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Tal til Aron og sig til ham: Når du sætter Lamperne på, skal du sætte dem således, at de syv Lamper kaster Lyset ud over Pladsen foran Lysestagen! ");
INSERT INTO dan1931_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Det gjorde Aron så; han satte Lamperne på således, at de vendte ud mod Pladsen foran Lysestagen, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Men Lysestagen var lavet af Guld i drevet Arbejde, fra Foden til Kronerne var den drevet Arbejde; efter det Forbillede, HERREN havde vist ham, havde Moses lavet Lysestagen. ");
INSERT INTO dan1931_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Udtag Levitterne af Israelitternes Midte og rens dem! ");
INSERT INTO dan1931_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Således skal du gå frem, når du renser dem: Stænk Renselsesvand på dem og lad dem gå hele deres Legeme over med Ragekniv, tvætte deres klæder og rense sig. ");
INSERT INTO dan1931_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Derpå skal de tage en ung Tyr til Brændoffer med tilhørende Afgrødeoffer af fint Hvedemel, rørt i Olie, og du skal tage en anden ung Tyr til Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Lad så Levitterne træde hen foran Åbenbaringsteltet og kald hele Israelitternes Menighed sammen. ");
INSERT INTO dan1931_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Når du så har ladet Levitterne træde frem for HERRENS Åsyn, skal Israelitterne lægge deres Hænder på Levitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Derpå skal Aron udføre Svingningen med Levitterne for HERRENS Åsyn som et Offer fra Israelitterne, for at de kan udføre HERRENS Arbejde. ");
INSERT INTO dan1931_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Så skal Levitterne lægge deres Hænder på Tyrenes Hoved, og derefter skal du ofre den ene som Syndoffer og den anden som Brændoffer til HERREN for at skaffe Levitterne Soning. ");
INSERT INTO dan1931_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Derpå skal du stille Levitterne frem for Aron og hans Sønner og udføre Svingningen med dem for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Således skal du udskille Levitterne fra Israelitterne, så at Levitterne kommer til at tilhøre mig. ");
INSERT INTO dan1931_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Derefter skal Levitterne komme og gøre Arbejde ved Åbenbaringsteltet; du skal foretage Renselsen og udføre Svingningen med dem, ");
INSERT INTO dan1931_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","thi de er skænket mig som Gave af Israelitternes Midte; i Stedet for alt hvad der åbner Moders Liv, alle førstefødte hos Israelitterne, har jeg taget mig dem til Ejendom. ");
INSERT INTO dan1931_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Thi mig tilhører alt det førstefødte hos Israelitterne, både af Mennesker og Kvæg. Dengang jeg slog alle de førstefødte i Ægypten, helligede jeg dem til at være min Ejendom. ");
INSERT INTO dan1931_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Jeg tog Levitterne i Stedet for alt det førstefødte hos Israelitterne ");
INSERT INTO dan1931_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","og skænkede Levitterne som Gave til Aron og hans Sønner af Israelitternes Midte til at udføre Israelitternes Arbejde ved Åbenbaringsteltet og skaffe Israelitterne Soning, for at ingen Plage skal ramme Israelitterne, om de selv nærmer sig Helligdommen. ");
INSERT INTO dan1931_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Og Moses, Aron og hele Israelitternes Menighed gjorde således med Levitterne; ganske som HERREN havde pålagt Moses med Hensyn til Levitterne, gjorde Israelitterne med dem. ");
INSERT INTO dan1931_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levitterne lod sig rense for Synd og tvættede deres Klæder, og Aron udførte Svingningen med dem for HERRENS Åsyn, og Aron skaffede dem Soning, så de blev rene. ");
INSERT INTO dan1931_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Derpå kom Levitterne for at udføre deres Arbejde ved Åbenbaringsteltet under Arons og hans Sønners Tilsyn; som HERREN havde pålagt Moses med Hensyn til Levitterne, således gjorde de med dem. ");
INSERT INTO dan1931_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Dette er, hvad der gælder Levitterne: Fra Femogtyveårsalderen og opefter skal de komme og gøre Tjeneste med Arbejdet ved Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Men fra Halvtredsårsalderen skal de holde op med at gøre Tjeneste og ikke arbejde mere; ");
INSERT INTO dan1931_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","de kan gå deres Brødre til Hånde i Åbenbaringsteltet med at tage Vare på, hvad der skal varetages; men Arbejde skal de ikke mere gøre. Således skal du gøre med Levitterne i alt, hvad de har at varetage. ");
INSERT INTO dan1931_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","HERREN talede således til Moses i Sinaj Ørken i den første Måned af det andet År efter deres Udvandring fra Ægypten: ");
INSERT INTO dan1931_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Israelitterne skal fejre Påsken til den fastsatte Tid, ");
INSERT INTO dan1931_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","på den fjortende Dag i denne Måned ved Aftenstid skal I fejre den til den fastsatte Tid; overensstemmende med alle Anordningerne og Lovbudene om den skal I fejre den! ");
INSERT INTO dan1931_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Da sagde Moses til Israelitterne, at de skulde fejre Påsken; ");
INSERT INTO dan1931_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","og de fejrede Påsken i Sinaj Ørken den fjortende Dag i den første Måned ved Aftenstid; nøjagtigt som HERREN havde pålagt Moses, således gjorde Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Men der var nogle Mænd, som var blevet urene ved et Lig og derfor ikke kunde fejre Påske den Dag. Disse Mænd trådte nu den Dag frem for Moses og Aron ");
INSERT INTO dan1931_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","og sagde til ham: “Vi er blevet urene ved et Lig; hvorfor skal det da være os forment at frembære HERRENS Offergave til den fastsatte Tid sammen med de andre Israelitter?” ");
INSERT INTO dan1931_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses svarede dem: “Vent, til jeg får at høre, hvad HERREN påbyder angående eder!” ");
INSERT INTO dan1931_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Da talede HERREN til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Tal til Israelitterne og sig: Når nogen af eder eller eders Efterkommere er blevet uren ved et Lig eller er ude på en lang Rejse, skal han alligevel holde Påske for HERREN; ");
INSERT INTO dan1931_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","den fjortende Dag i den anden Måned ved Aftenstid skal de holde den; med usyret Brød og bitre Urter skal de spise Påskelammet. ");
INSERT INTO dan1931_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","De må intet levne deraf til næste Morgen, og de må ikke sønderbryde noget af dets Ben. De skal fejre Påsken i Overensstemmelse med alle de Anordninger, som gælder for den. ");
INSERT INTO dan1931_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Men den, som undlader at fejre Påsken, skønt han er ren og ikke på Rejse, det Menneske skal udryddes af sin Slægt, fordi han ikke har frembåret HERRENS Offergave til den fastsatte Tid. Den Mand skal undgælde for sin Synd. ");
INSERT INTO dan1931_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Og når en fremmed, der bor hos eder, vil holde Påske for HERREN, skal han holde den efter de Anordninger og Lovbud, som gælder for Påsken. En og samme Lov skal gælde for eder, for den fremmede og for den indfødte. ");
INSERT INTO dan1931_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Den Dag Boligen blev rejst, dækkede Skyen Boligen, Vidnesbyrdets Telt; men om Aftenen var der som et Ildskær over Boligen, og det holdt sig til om Morgenen. ");
INSERT INTO dan1931_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Således var det til Stadighed: Om dagen dækkede Skyen den, om Natten Ildskæret. ");
INSERT INTO dan1931_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Hver Gang Skyen løftede sig fra Teltet, brød Israelitterne op, og der, hvor Skyen stod stille, slog Israelitterne Lejr. ");
INSERT INTO dan1931_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","På HERRENS Bud brød Israelitterne op, og på HERRENS Bud gik de i Lejr, og så længe Skyen hvilede over Boligen, blev de liggende i Lejr; ");
INSERT INTO dan1931_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","når Skyen blev over Boligen i længere Tid, rettede Israelitterne sig efter, hvad HERREN havde foreskrevet dem, og brød ikke op. ");
INSERT INTO dan1931_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Det hændte, at Skyen kun blev nogle få Dage over Boligen; da gik de i Lejr på HERRENS Bud og brød op på HERRENS Bud. ");
INSERT INTO dan1931_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Og det hændte, at Skyen kun blev der fra Aften til Morgen; når Skyen da løftede sig om Morgenen, brød de op. Eller den blev der en Dag og en Nat; når Skyen da løftede sig, brød de op. ");
INSERT INTO dan1931_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Eller den blev der et Par Dage eller en Måned eller længere endnu, idet Skyen i længere Tid hvilede over Boligen; så blev Israelitterne liggende i Lejr og brød ikke op, men når den løftede sig, brød de op. ");
INSERT INTO dan1931_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","På HERRENS Bud gik de i Lejr, og på HERRENS Bud brød de op; de rettede sig efter, hvad HERREN havde foreskrevet dem, efter HERRENS Bud ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Du skal lave dig to Sølvtrompeter; i drevet Arbejde skal du lave dem. Dem skal du bruge, når Menigheden skal kaldes sammen, og når Lejrene skal bryde op. ");
INSERT INTO dan1931_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Når der blæses i dem begge to, skal hele Menigheden samle sig hos dig ved Indgangen til Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Blæses der kun i den ene, skal Øversterne, Overhovederne for Israels Stammer, samle sig hos dig. ");
INSERT INTO dan1931_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Når I blæser Alarm med dem, skal Lejrene på Østsiden bryde op; ");
INSERT INTO dan1931_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","blæser Alarm anden Gang, skal Lejrene på Sydsiden bryde op: tredje Gang skal Lejrene mod Vest bryde op, fjerde Gang Lejrene mod Nord; der skal blæses Alarm, når de skal bryde op. ");
INSERT INTO dan1931_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Men når Forsamlingen skal sammenkaldes skal I blæse på almindelig Vis, ikke Alarm. ");
INSERT INTO dan1931_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Arons Sønner, Præsterne, skal blæse i Trompeterne; det skal være eder en evig gyldig Anordning fra Slægt til Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Når I drager i Krig i eders Land mod en Fjende, der angriber eder, og blæser Alarm med Trompeterne, skal I ihukommes for HERREN eders Guds Åsyn og frelses fra eders Fjender. ");
INSERT INTO dan1931_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Og på eders Glædesdage, eders Højtider og Nymånedage, skal I blæse i Trompeterne ved eders Brændofre og Takofre; så skal de tjene eder til Ihukommelse for eders Guds Åsyn. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Den tyvende Dag i den anden Måned af det andet År løftede Skyen sig fra Vidnesbyrdets Bolig. ");
INSERT INTO dan1931_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Da brød Israelitterne op fra Sinaj Ørken, i den Orden de skulde bryde op i, og Skyen stod stille i Parans Ørken. ");
INSERT INTO dan1931_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Da de nu første Gang brød op efter Guds Bud ved Moses, ");
INSERT INTO dan1931_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","var Judæernes Lejr den første, der brød op under sit Felttegn, Hærafdeling for Hærafdeling; deres Hær førtes af Nahasjon, Amminadabs Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Issakaritternes Stammes Hær førtes af Netanel, Zuars Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","og Zebulonitternes Stammes Hær af Eliab, Helons Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Da derpå Boligen var taget ned, brød Gersonitterne og Meraritterne op og bar Boligen. ");
INSERT INTO dan1931_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Så brød Rubens Lejr op under sit Felttegn, Hærafdeling for Hærafdeling; deres Hær førtes af Elizur, Sjede'urs Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeonitternes Stammes Hær førtes af Sjelumiel, Zurisjaddajs Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","og Gaditternes Stammes Hær af Eljasaf, De'uels Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Så brød Kehatitterne, der bar de hellige Ting, op; og før deres Komme havde man rejst Boligen. ");
INSERT INTO dan1931_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Så brød Efraimitternes Lejr op under sit Felttegn, Hærafdeling for Hærafdeling; deres Hær førtes af Elisjama, Ammihuds Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manassitternes Stammes Hær førtes af Gamliel, Pedazurs Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","og Benjaminitternes Stammes Hær af Abidan, Gidonis Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Så brød Danitternes Lejr op under sit Felttegn som Bagtrop i hele Lejrtoget, Hærafdeling for Hærafdeling; deres Hær førtes af Ahiezer, Ammisjaddajs Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aseritternes Stammes Hær førtes af Pag'iel, Okrans Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","og Naftalitternes Stammes Hær af Ahira, Enans Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Således foregik Israelitternes Opbrud, Hærafdeling for Hærafdeling. Så brød de da op. ");
INSERT INTO dan1931_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Men Moses sagde til Midjaniten Hobab, Re'uels Søn, Moses' Svigerfader: “Vi bryder nu op for at drage til det Sted, HERREN har lovet at give os; drag med os! Vi skal lønne dig godt, thi HERREN har stillet Israel gode Ting i Udsigt.” ");
INSERT INTO dan1931_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Men han svarede ham: “Jeg vil ikke drage med; nej, jeg drager til mit Land og min Slægt.” ");
INSERT INTO dan1931_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Da sagde han: “Forlad os ikke! Du kender jo de Steder, hvor vi kan slå Lejr i Ørkenen; vær Øje for os! ");
INSERT INTO dan1931_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Drager du med os, skal vi give dig Del i alt det gode, HERREN vil give os.” ");
INSERT INTO dan1931_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Derpå brød de op fra HERRENS Bjerg og vandrede tre Dagsrejser frem, idet HERRENS Pagts Ark drog i Forvejen for at søge dem et Sted, hvor de kunde holde Hvil. ");
INSERT INTO dan1931_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Og HERRENS Sky svævede over dem om Dagen, når de brød op fra Lejren. ");
INSERT INTO dan1931_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Og hver Gang Arken brød op, sagde Moses: “Stå op, HERRE, at dine Fjender må splittes og dine Avindsmænd fly for dit Åsyn!” ");
INSERT INTO dan1931_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Og hver Gang den standsede, sagde han: “Vend tilbage, HERRE, til Israels Stammers Titusinder!” ");
INSERT INTO dan1931_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Men Folket knurrede højlydt for HERREN over deres usle Kår; og da HERREN hørte det, blussede hans Vrede op, og HERRENS Ild brød løs iblandt dem og åd om sig i den yderste Del af Lejren. ");
INSERT INTO dan1931_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Da råbte Folket til Moses, og Moses gik i Forbøn hos HERREN. Så dæmpedes Ilden. ");
INSERT INTO dan1931_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Derfor kaldte man dette Sted Tab'era, fordi HERRENS Ild brød løs* iblandt dem. { *På hebr. Ordspil med Navnet Tab'era. } ");
INSERT INTO dan1931_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Men den sammenløbne Hob, som fandtes iblandt dem, blev lysten. Så tog også Israelitterne til at græde igen, og de sagde: “Kunde vi dog få Kød at spise! ");
INSERT INTO dan1931_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Vi mindes Fiskene, vi fik at spise for intet i Ægypten, og Agurkerne, Vandmelonerne, Porrerne, Hvidløgene og Skalotterne, ");
INSERT INTO dan1931_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","og nu vansmægter vi; her er hverken det ene eller det andet, vi ser aldrig andet end Manna.” ");
INSERT INTO dan1931_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mannaen lignede Korianderfrø og så ud som Bdellium. ");
INSERT INTO dan1931_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Folket gik rundt og sankede den op; derpå malede de den i Håndkværne eller stødte den i Mortere; så kogte de den i Gryder og lavede Kager deraf; den smagte da som Bagværk tillavet i Olie. ");
INSERT INTO dan1931_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Når Duggen om Natten faldt over Lejren, faldt også Mannaen ned over den. ");
INSERT INTO dan1931_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Og Moses hørte, hvorledes alle Folkets Slægter græd, enhver ved Indgangen til sit Telt; da blussede HERRENS Vrede voldsomt op, og det vakte også Moses' Mishag. ");
INSERT INTO dan1931_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Da sagde Moses til HERREN: “Hvorfor har du handlet så ilde med din Tjener, og hvorfor har jeg ikke fundet Nåde for dine Øjne, siden du har lagt hele dette Folk som en Byrde på mig? ");
INSERT INTO dan1931_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Mon det er mig, der har undfanget hele dette Folk, mon det er mig, der har født det, siden du forlanger, at jeg i min Favn skal bære det hen til det Land, du tilsvor dets Fædre, som en Fosterfader bærer det diende Barn? ");
INSERT INTO dan1931_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Hvor skal jeg gå hen og skaffe hele dette Folk Kød? Thi de græder rundt om mig og siger: Skaf os Kød at spise? ");
INSERT INTO dan1931_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Jeg kan ikke ene bære hele dette Folk, det er mig for tungt. ");
INSERT INTO dan1931_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Hvis du vil handle således med mig, så dræb mig hellere, om jeg har fundet Nåde for dine Øjne, så at jeg ikke skal være nødt til at opleve sådan Elendighed!” ");
INSERT INTO dan1931_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","HERREN svarede Moses: “Kald mig halvfjerdsindstyve af Israels Ældste sammen, Mænd, som du ved hører til Folkets Ældste og Tilsynsmænd, før dem hen til Åbenbaringsteltet og lad dem stille sig op hos dig der. ");
INSERT INTO dan1931_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Så vil jeg stige ned og tale med dig der, og jeg vil tage noget af den Ånd, der er over dig, og lade den komme over dem, for at de kan hjælpe dig med at bære Folkets Byrde, så du ikke ene skal bære den. ");
INSERT INTO dan1931_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Men til Folket skal du sige: Helliger eder til i Morgen, så skal I få Kød at spise! I har jo grædt højlydt for HERREN og sagt: Kunde vi dog få Kød at spise! Vi havde det jo bedre i Ægypten! Derfor vil HERREN give eder kød at spise; ");
INSERT INTO dan1931_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","og ikke blot én eller to eller fem eller ti eller tyve Dage skal I spise det, ");
INSERT INTO dan1931_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","men en hel Måned igennem, indtil det står eder ud af Næsen, og I væmmes derved, fordi I har ringeagtet HERREN, der er i eders Midte, og grædt for hans Åsyn og sagt: Hvorfor drog vi dog ud af Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moses svarede: “600.000 Fodfolk tæller det Folk, jeg bar om mig, og du siger: Jeg vil skaffe dem Kød, så de har nok at spise en hel Måned! ");
INSERT INTO dan1931_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Kan der slagtes så meget Småkvæg og Hornkvæg til dem, at det kan slå til, eller kan alle Fisk i Havet samles sammen til dem, så det kan slå til?” ");
INSERT INTO dan1931_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","HERREN svarede Moses: “Er HERRENS Arm for kort? Nu skal du få at se, om mit Ord går i Opfyldelse for dig eller ej.” ");
INSERT INTO dan1931_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Da gik Moses ud og kundgjorde Folket HERRENS Ord. Og han samlede halvfjerdsindstyve af Folkets Ældste og lod dem stille sig rundt om Teltet. ");
INSERT INTO dan1931_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Så steg HERREN ned i Skyen og talede til ham; og han tog noget af den Ånd, der var over ham, og lod den komme over de halvfjerdsindstyve Ældste, og da Ånden hvilede over dem, kom de i profetisk Henrykkelse noget, som ikke siden hændtes dem. ");
INSERT INTO dan1931_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Imidlertid var to Mænd blevet tilbage i Lejren, den ene hed Eldad, den anden Medad. Også over dem kom Ånden, thi de hørte til dem, der var optegnede, men de var ikke gået ud til Teltet, og nu kom de i profetisk Henrykkelse inde i Lejren. ");
INSERT INTO dan1931_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Da løb en ung Mand ud og fortalte Moses det og sagde: “Eldad og Medad er kommet i profetisk Henrykkelse inde i Lejren.” ");
INSERT INTO dan1931_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Josua, Nuns Søn, der fra sin Ungdom af havde gået Moses til Hånde, sagde da: “Min Herre Moses, stands dem i det!” ");
INSERT INTO dan1931_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Men Moses sagde til ham: “Er du skinsyg på mine Vegne? Gid alt HERRENS Folk var Profeter, gid HERREN vilde lade sin Ånd komme over dem!” ");
INSERT INTO dan1931_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Derpå trak Moses sig tilbage til Lejren med Israels Ældste. ");
INSERT INTO dan1931_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Da rejste der sig på HERRENS Bud en Vind, som førte Vagtler med sig fra Havet og drev dem hen over Lejren så langt som en Dagsrejse på begge Sider af Lejren i en Højde af et Par Alen over Jorden. ");
INSERT INTO dan1931_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Så gav Folket sig hele den Dag, hele Natten og hele den næste Dag til at samle Vagtlerne op; det mindste, nogen samlede, var ti Homer. Og de bredte dem ud til Tørring rundt om Lejren. ");
INSERT INTO dan1931_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Medens Kødet endnu var imellem Tænderne på dem, før det endnu var spist, blussede HERRENS Vrede op imod Folket, og HERREN lod en meget hård Straf ramme Folket. ");
INSERT INTO dan1931_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Og man kaldte Stedet Kibrot-Hatta'ava*, thi der blev de lystne Folk jordet. { *dvs. lysthedens Grave. } ");
INSERT INTO dan1931_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Fra Kibrot-Hatta'ava drog Folket til Hazerot, og de gjorde Holdt i Hazerot. ");
INSERT INTO dan1931_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mirjam og Aron tog til Orde mod Moses i Anledning af den kusjitiske* Kvinde, han havde ægtet - han havde nemlig ægtet en kusjitisk Kvinde - { *Ordet betyder i Regelen Ætiopisk, men her betyder det rimeligvis, at Kvinden hørte til den Hab. 3, 7 ved siden af Midjan nævnte Stamme Kusjan. } ");
INSERT INTO dan1931_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","og sagde: “Har HERREN kun talet til Moses? Mon han ikke også har talet til os?” Og HERREN hørte det. ");
INSERT INTO dan1931_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Men den Mand Moses var såre sagtmodig, sagtmodigere end noget andet Menneske på Jorden. ");
INSERT INTO dan1931_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Da sagde HERREN i det samme til Moses, Aron og Mirjam: “Gå alle tre ud til Åbenbaringsteltet!” Og de gik alle tre derud. ");
INSERT INTO dan1931_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Men HERREN steg ned i Skystøtten og stillede sig ved Indgangen til Teltet og kaldte på Aron og Mirjam, og de gik begge derud. ");
INSERT INTO dan1931_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Da sagde han: “Hør, hvad jeg siger: Når der ellers er en Profet iblandt eder, giver jeg mig til Kende for ham i Syner eller taler med ham i Drømme. ");
INSERT INTO dan1931_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Anderledes er det med min Tjener Moses: han er tro i hele mit Hus; ");
INSERT INTO dan1931_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","med ham taler jeg Ansigt til Ansigt, ikke i Syner eller Gåder, han skuer HERRENS Skikkelse; hvor tør I da tage til Orde mod min Tjener Moses?” ");
INSERT INTO dan1931_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Og HERRENS Vrede blussede op imod dem, og han gik bort. ");
INSERT INTO dan1931_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Da så Skyen trak sig bort fra Teltet, se, da var Mirjam hvid som Sne af Spedalskhed, og da Aron vendte sig mod Mirjam, se, da var hun spedalsk. ");
INSERT INTO dan1931_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Da sagde Aron til Moses: “Ak, Herre, lad os dog ikke undgælde for den Synd, vi i Dårskab begik! ");
INSERT INTO dan1931_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Lad hende dog ikke blive som et dødfødt Barn, hvis Kød er halvt fortæret, når det kommer ud af Moders Liv!” ");
INSERT INTO dan1931_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moses råbte da til HERREN og sagde: “Ak, gør hende dog rask igen!” ");
INSERT INTO dan1931_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Og HERREN svarede Moses: “Hvis hendes Fader havde spyttet hende i Ansigtet, måtte hun da ikke have båret sin Skam i syv Dage? Derfor skal hun i syv Dage være udelukket fra Lejren; så kan hun atter optages.” ");
INSERT INTO dan1931_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Da blev Mirjam udelukket fra Lejren i syv Dage, og Folket brød ikke op, før Mirjam atter var optaget. ");
INSERT INTO dan1931_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Så brød Folket op fra Hazerot og slog Lejr i Parans Ørken. ");
INSERT INTO dan1931_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Send nogle Mænd af Sted for at undersøge Kana'ans Land, som jeg vil give Israelitterne; én Mand af hver Fædrenestamme skal I sende, og kun Mænd, der er Øverster iblandt dem!” ");
INSERT INTO dan1931_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Da udsendte Moses dem fra Parans Ørken på HERRENS Bud, Mænd, der alle var Overhoveder for Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Deres Navne var følgende: Af Rubens Stamme Sjammua, Zakkurs Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","af Simeons Stamme Sjafat, Horis Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","af Judas Stamme Kaleb, Jefunnes Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","af Issakars Stamme Jig'al, Josefs Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","af Efraims Stamme Hosea, Nuns Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","af Benjamins Stamme Palti, Rafus Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","af Zebulons Stamme Gaddiel, Sodis Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","af Josefs Stamme, det er Manasses Stamme, Gaddi, Susis Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","af Dans Stamme Ammiel, Gemallis Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","af Asers Stamme Setur, Mikaels Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","af Naftalis Stamme Nabi, Vofsis Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","af Gads Stamme Ge'uel, Makis Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Det var Navnene på de Mænd, Moses udsendte for at undersøge Landet. Men Moses gav Hosea, Nuns Søn, Navnet Josua. ");
INSERT INTO dan1931_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Og Moses sendte dem af Sted for at undersøge Kana'ans Land. Og han sagde til dem: “Drag herfra op i Sydlandet og drag op i Bjergene ");
INSERT INTO dan1931_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","og se, hvordan Landet er, og om Folket, som bor der, er stærkt eller svagt, fåtalligt eller talrigt, ");
INSERT INTO dan1931_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","om Landet, de bor i, er godt eller dårligt, og om Byerne, de bor i, er Teltlejre eller Fæstninger, ");
INSERT INTO dan1931_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","og om Landet er fedt eller magert, om der findes Træer deri eller ej. Vær ved godt Mod og tag noget af Landets Frugt med tilbage!” Det var netop ved den Tid, de første Druer var modne. ");
INSERT INTO dan1931_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Så drog de af Sted og undersøgte Landet lige fra Zins Ørken til Rehob, Egnen hen imod Hamat. ");
INSERT INTO dan1931_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Så begav de sig op i Sydlandet og kom til Hebron; der boede Ahiman, Sjesjaj og Talmaj, Anaks Efterkommere. Men Hebron var grundlagt syv År før Zoan i Ægypten. ");
INSERT INTO dan1931_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Da de nåede Esjkoldalen, afskar de en Ranke med en Drueklase, som der måtte to Mand til at bære på en Bærestang, og plukkede nogle Granatæbler og Figener. ");
INSERT INTO dan1931_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Man kaldte dette Sted Esjkoldalen* med Hentydning til den Drueklase, Israelitterne der skar af. { *Esjkol betyder Drueklase. } ");
INSERT INTO dan1931_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Efter fyrretyve Dages Forløb vendte de tilbage efter at have undersøgt Landet; ");
INSERT INTO dan1931_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","og de kom til Moses og Aron og hele Israelitternes Menighed i Parans Ørken i Kadesj og aflagde Beretning for dem og hele Menigheden og viste dem Landets Frugt. ");
INSERT INTO dan1931_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","De fortalte ham: “Vi kom til landet, du sendte os til; det er virkelig et Land, der flyder med Mælk og Honning, og her er Flugt derfra; ");
INSERT INTO dan1931_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","men stærkt er Folket, som bor i Landet, og Byerne er befæstede og meget store; ja, vi så også Efterkommere af Anak der. ");
INSERT INTO dan1931_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek bor i Sydlandet, Hetitterne, Jebusitterne og Amoritterne i Bjerglandet og Kana'anæerne ved Havet og langs Jordan.” ");
INSERT INTO dan1931_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Da søgte Kaleb at bringe Folket til Tavshed over for Moses og sagde: “Lad os kun drage op og underlægge os det, thi vi kan sikkert tage det!” ");
INSERT INTO dan1931_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Men de Mænd, der havde været med ham deroppe, sagde: “Vi kan ikke drage op imod dette Folk, thi det er stærkere end vi!” ");
INSERT INTO dan1931_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Og de talte nedsættende til Israelitterne om Landet, som de havde undersøgt, og sagde: “Landet, som vi har rejst igennem og undersøgt, er et Land, der fortærer sine Indbyggere, og alle de Folk, vi så der, var kæmpestore. ");
INSERT INTO dan1931_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Vi så der Kæmperne - Anaks Sønner, der er af Kæmpeslægten - og vi forekom både os selv og dem som Græshopper!” ");
INSERT INTO dan1931_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Da opløftede hele Menigheden sin Røst og brød ud i Klageråb, og Folket græd Natten igennem. ");
INSERT INTO dan1931_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Og alle Israelitterne knurrede imod Moses og Aron, og hele Menigheden sagde til dem: “Gid vi var døde i Ægypten eller her i Ørkenen! ");
INSERT INTO dan1931_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Hvorfor fører HERREN os til dette Land, når vi skal falde for Sværdet og vore Kvinder og Børn blive til Bytte? Var det dog ikke bedre for os at vende tilbage til Ægypten?” ");
INSERT INTO dan1931_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Og de sagde til hverandre: “Lad os vælge os en Fører og vende tilbage til Ægypten!” ");
INSERT INTO dan1931_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Da faldt Moses og Aron på deres Ansigt foran hele den israelitiske Menigheds Forsamling. ");
INSERT INTO dan1931_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Men Josua, Nuns Søn, og Kaleb, Jefunnes Søn, der havde været med til at undersøge Landet, sønderrev deres Klæder ");
INSERT INTO dan1931_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","og sagde til hele Israelitternes Menighed: “Landet, vi har rejst igennem og undersøgt, er et såre, såre godt Land. ");
INSERT INTO dan1931_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Hvis HERREN har Behag i os, vil han føre os til det Land og give os det, et Land, der flyder med Mælk og Honning. ");
INSERT INTO dan1931_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Gør kun ikke Oprør imod HERREN og frygt ikke for Landets Befolkning, thi dem tager vi som en Bid Brød; deres Skygge* er veget fra dem, men med os er HERREN; frygt ikke for dem!” { *dvs. deres Værn, her vel deres Guder (Es. 30, 2.) } ");
INSERT INTO dan1931_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Hele Menigheden tænkte allerede på at stene dem; men da kom HERRENS Herlighed til Syne for alle Israelitterne ved Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Og HERREN sagde til Moses: “Hvor længe skal dette Folk håne mig, og hvor længe vil det vægre sig ved at tro på mig, til Trods for alle de Tegn jeg har gjort i det? ");
INSERT INTO dan1931_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Jeg vil slå det med Pest og udrydde det, men dig vil jeg gøre til et Folk, større og stærkere end det!” ");
INSERT INTO dan1931_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Men Moses sagde til HERREN: “Ægypterne har hørt, at du i din Vælde har ført dette Folk bort fra dem; ");
INSERT INTO dan1931_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","og ligeledes har alle dette Lands Indbyggere hørt, at du, HERRE, er midt iblandt dette Folk, thi du, HERRE, åbenbarer dig synligt, idet din Sky står over dem, og du vandrer foran dem om Dagen i en Skystøtte og om Natten i en Ildstøtte. ");
INSERT INTO dan1931_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Hvis du nu dræber dette Folk alle som én, vil de Folk, der har hørt dit Ry, sige: ");
INSERT INTO dan1931_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Fordi HERREN ikke evnede at føre dette Folk til det Land, han havde tilsvoret dem, lod han dem omkomme i Ørkenen. ");
INSERT INTO dan1931_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Derfor, HERRE, lad din Vælde nu vise sig i sin Storhed, således som du forjættede, da du sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","HERREN er langmodig og rig på Miskundhed, han forlader Misgerning og Overtrædelse, men han lader ingen ustraffet, og han hjemsøger Fædrenes Brøde på Børnene i tredje og fjerde Led. ");
INSERT INTO dan1931_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Så tilgiv nu dette Folk dets Misgerning efter din store Miskundhed, således som du har tilgivet dette Folk hele Vejen fra Ægypten og hertil!” ");
INSERT INTO dan1931_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Da sagde HERREN: “Jeg tilgiver dem på din Bøn. ");
INSERT INTO dan1931_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Men så sandt jeg lever så sandt hele Jorden skal opfyldes af HERRENS Herlighed: ");
INSERT INTO dan1931_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Ingen af de Mænd, der har set min Herlighed og de Tegn, jeg har gjort i Ægypten og i Ørkenen, og dog nu for tiende Gang har fristet mig og ikke villet lyde min Røst, ");
INSERT INTO dan1931_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ingen af dem skal se det Land, jeg tilsvor deres Fædre! Ingen af dem, der har hånet mig, skal få det at se; ");
INSERT INTO dan1931_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","kun min Tjener Kaleb lader jeg komme til det Land, han har været i, og hans Efterkommere skal få det i Eje, fordi han havde en anden Ånd og viste mig fuld Lydighed. ");
INSERT INTO dan1931_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Men Amalekitterne og Kana'anæerne bor i Lavlandet. Vend derfor om i Morgen, bryd op og drag ud i Ørkenen ad det røde Hav til!” ");
INSERT INTO dan1931_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Fremdeles talede HERREN til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Hvor længe skal jeg tåle denne onde Menighed, dem, som bestandig knurrer imod mig? Jeg har hørt Israelitternes Knurren, hørt, hvorledes de knurrer imod mig. ");
INSERT INTO dan1931_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sig til dem: Så sandt jeg lever - lyder det fra HERREN - som I har råbt mig i Øret, således vil jeg handle med eder! ");
INSERT INTO dan1931_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","I Ørkenen her skal eders Kroppe falde, alle I, der blev mønstret, så mange I er fra Tyveårsalderen og opefter, I, som har knurret imod mig. ");
INSERT INTO dan1931_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Sandelig, ingen af eder skal komme til det Land, jeg med løftet Hånd svor at ville giver eder at bo i, med Undtagelse af Kaleb, Jefunnes Søn, og Josua, Nuns Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Eders små Børn, som I sagde vilde blive til Bytte, dem vil jeg lade komme derhen, og de skal tage det Land i Besiddelse, som I har vraget, ");
INSERT INTO dan1931_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","men eders egne Kroppe skal falde i Ørkenen her, ");
INSERT INTO dan1931_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","og eders Sønner skal flakke om i Ørkenen i fyrretyve År og undgælde for eders Bolen, indtil eders Kroppe er gået til Grunde i Ørkenen. ");
INSERT INTO dan1931_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Som I brugte fyrretyve Dage til at undersøge Landet, således skal I undgælde for eders Misgerninger i fyrretyve År, ét År for hver Dag, og således få mit Mishag at føle. ");
INSERT INTO dan1931_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Jeg HERREN har sagt det: Sandelig, således vil jeg handle med hele denne onde Menighed, der har rottet sig sammen imod mig; i Ørkenen her skal de gå til Grunde, i den skal de dø!” ");
INSERT INTO dan1931_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Og de Mænd, Moses havde udsendt for at undersøge Landet, og som efter deres Tilbagekomst havde fået hele Menigheden til at knurre imod ham ved at tale nedsættende om Landet, ");
INSERT INTO dan1931_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","de Mænd, der havde talt nedsættende om Landet, fik en brat Død for HERRENS Åsyn: ");
INSERT INTO dan1931_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","kun Josua, Nuns Søn, og Kaleb, Jefunnes Søn, blev i Live af de Mænd, der var draget hen for at undersøge Landet. ");
INSERT INTO dan1931_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Men da Moses forebragte alle Israelitterne disse Ord, grebes Folket af stor Sorg; ");
INSERT INTO dan1931_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","og tidligt næste Morgen drog de op mod det øverste af Bjerglandet og sagde: “Se, vi er rede til at drage op til det Sted, HERREN har talet om, thi vi, har syndet.” ");
INSERT INTO dan1931_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Da sagde Moses: “Hvorfor vil I overtræde HERRENS Bud? Det vil ikke gå godt! ");
INSERT INTO dan1931_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Drag ikke derop, thi HERREN er ikke iblandt eder; gør I det, bliver I slået af eders Fjender! ");
INSERT INTO dan1931_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Thi Amalekitterne og Kana'anæerne vil møde eder der, og I skal falde for Sværdet; I har jo vendt eder fra HERREN, og HERREN er ikke med eder!” ");
INSERT INTO dan1931_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Alligevel formastede de sig til at drage op mod det øverste af Bjerglandet; men HERRENS Pagts Ark og Moses forlod ikke Lejren. ");
INSERT INTO dan1931_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Da steg Amalekitterne og Kana'anæerne, der boede der i Bjerglandet, ned og slog dem og adsplittede dem lige til Horma. ");
INSERT INTO dan1931_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Tal til Israelitterne og sig til dem: Når I kommer til det Land, jeg vil give eder at bo i, ");
INSERT INTO dan1931_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","og I vil ofre HERREN et Ildoffer, Brændoffer eller Slagtoffer, af Hornkvæg eller Småkvæg for at indfri et Løfte eller af fri Drift eller i Anledning af eders Højtider for at berede HERREN en liflig Duft, ");
INSERT INTO dan1931_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","så skal den, der bringer HERREN sin Offergave, som Afgrødeoffer bringe en Tiendedel Efa fint Hvedemel, rørt i en Fjerdedel Hin Olie; ");
INSERT INTO dan1931_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","desuden skal du som Drikoffer til hvert Lam ofre en Fjerdedel Hin Vin, hvad enten det er Brændoffer eller Slagtoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Men til en Vædder skal du som Afgrødeoffer ofre to Tiendedele Efa fint Hvedemel, rørt i en Tredjedel Hin Olie; ");
INSERT INTO dan1931_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","desuden skal du som Drikoffer frembære en Tredjedel Hin Vin til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Og når du ofrer en ung Tyr som Brændoffer eller Slagtoffer for at indfri et Løfte eller som Takoffer til HERREN, ");
INSERT INTO dan1931_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","skal du foruden Tyren frembære som Afgrødeoffer tre Tiendedele Efa fint Hvedemel, rørt i en halv Hin Olie; ");
INSERT INTO dan1931_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","desuden skal du som Drikoffer frembære en halv Hin Vin, et Ildoffer til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Således skal der gøres for hver enkelt Tyr, hver enkelt Vædder eller hvert Lam eller Ged; ");
INSERT INTO dan1931_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","således skal I gøre for hvert enkelt Dyr, så mange I nu ofrer. ");
INSERT INTO dan1931_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Enhver indfødt skal gøre disse Ting på denne Måde, når han vil bringe et Ildoffer til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Og når en fremmed bor hos eder, eller nogen i de kommende Tider bor iblandt eder, og han vil bringe et Ildoffer til en liflig Duft for HERREN, skal han gøre på samme Måde som I selv. ");
INSERT INTO dan1931_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Inden for Forsamlingen skal en og samme Anordning gælde for eder og den fremmede, der bor hos eder; det skal være eder en evig gyldig Anordning fra Slægt til Slægt: hvad der gælder for eder, skal også gælde for den fremmede for HERRENS Åsyn*; { *dvs. i alt, hvad der vedrører Gudsdyrkelsen. } ");
INSERT INTO dan1931_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","samme Lov og Ret gælder for eder og den fremmede, der bor hos eder. ");
INSERT INTO dan1931_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Tal til Israelitterne og sig til dem: Når I kommer til det Land, jeg fører eder til, ");
INSERT INTO dan1931_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","og spiser af Landets Brød, skal I yde HERREN en Offerydelse. ");
INSERT INTO dan1931_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Som Førstegrøde af eders Grovmel* skal I yde en Kage som Offerydelse; på samme Måde som Offerydelsen af Tærskepladsen skal I yde den. { *eller måskje dej. } ");
INSERT INTO dan1931_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Af Førstegrøden af eders Grovmel skal I give HERREN en Offerydelse, Slægt efter Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Dersom I synder af Vanvare og undlader at udføre noget af alle de Bud, HERREN har kundgjort Moses, ");
INSERT INTO dan1931_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","noget af alt det, HERREN har pålagt eder gennem Moses, fra den Dag HERREN udstedte sit Bud og frem i Tiden fra Slægt til Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","så skal hele Menigheden, hvis det sker af Vanvare uden Menighedens Vidende, ofre en ung Tyr som Brændoffer til en liflig duft for HERREN med det efter Lovbudene dertil hørende Afgrødeoffer og Drikoffer og desuden en Gedebuk som Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Og Præsten skal skaffe hele Israelitternes Menighed Soning, og dermed opnår de Tilgivelse; thi det skete af Vanvare, og de bar bragt deres Offergave som et Ildoffer til HERREN og desuden deres Syndoffer for HERRENS Åsyn, for hvad de gjorde af Vanvare. ");
INSERT INTO dan1931_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Således får både hele Israelitternes Menighed og den fremmede, der bor hos dem, Tilgivelse; thi alt Folket har Del i den Synd, der bliver begået af Vanvare. ");
INSERT INTO dan1931_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Men hvis et enkelt Menneske synder af Vanvare, skal han bringe en årgammel Ged som Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Og Præsten skal skaffe den, der synder af Vanvare, Soning for HERRENS Åsyn ved at udføre Soningen for ham, og således opnår han Tilgivelse. ");
INSERT INTO dan1931_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","For den indfødte hos Israelitterne og den fremmede, der bor iblandt dem, for eder alle gælder en og samme Lov; når nogen synder af Vanvare. ");
INSERT INTO dan1931_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Men den, der handler med Forsæt, hvad enten han er indfødt eller fremmed, han håner Gud, og det Menneske skal udryddes af sit Folk. ");
INSERT INTO dan1931_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Thi han har ringeagtet HERRENS Ord og brudt hans Bud; det Menneske skal udryddes, hans Misgerning kommer over ham. ");
INSERT INTO dan1931_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Medens Israelitterne opholdt sig i Ørkenen, traf de en Mand, som sankede Brænde på en Sabbat. ");
INSERT INTO dan1931_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","De, der traf ham i Færd med at sanke Brænde, bragte ham til Moses, Aron og hele Menigheden, ");
INSERT INTO dan1931_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","og de satte ham i Varetægt, da der ikke forelå nogen bestemt Kendelse for, hvad der skulde gøres ved ham. ");
INSERT INTO dan1931_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Da sagde HERREN til Moses: Den Mand skal lide Døden; hele Menigheden skal stene ham uden for Lejren! ");
INSERT INTO dan1931_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Hele Menigheden førte ham da uden for Lejren og stenede ham til Døde, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Tal til Israelitterne og sig til dem, at de Slægt efter Slægt skal sætte Kvaster på Fligene af deres Klæder, og at de på hver enkelt Kvast skal sætte en violet Purpursnor. ");
INSERT INTO dan1931_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Det skal tjene eder til Tegn, så at I, hver Gang I ser dem, skal komme alle HERRENS Bud i Hu og handle efter dem og ikke lade eder vildlede af eders Hjerter eller Øjne, af hvilke I lader eder forlede til Bolen - ");
INSERT INTO dan1931_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","for at I kan komme alle mine Bud i Hu og handle efter dem og blive hellige for eders Gud. ");
INSERT INTO dan1931_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Jeg er HERREN eders Gud, som førte eder ud af Ægypten for at være eders Gud. Jeg er HERREN eders Gud! ");
INSERT INTO dan1931_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Men Kora, en Søn af Jizhar, en Søn af Levis Søn Kehat, og Datan og Abiram, Sønner af Eliab, en Søn af Rubens Søn Pallu, gjorde Oprør. ");
INSERT INTO dan1931_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","De gjorde Oprør mod Moses sammen med 250 israelitiske Mænd, Øverster for Menigheden, udvalgte i Folkeforsamlingen, ansete Mænd. ");
INSERT INTO dan1931_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Og de samlede sig og trådte op imod Moses og Aron og sagde til dem: “Lad det nu være nok, thi hele Menigheden er hellig, hver og en, og HERREN er i dens Midte; hvorfor vil I da ophøje eder over HERRENS Forsamling?” ");
INSERT INTO dan1931_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Da Moses hørte det, faldt han på sit Ansigt. ");
INSERT INTO dan1931_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Derpå talte han til Kora og alle hans Tilhængere og sagde: “Vent til i Morgen, så vil HERREN give til kende, hvem der tilhører ham, og hvem der er hellig, så at han vil give ham Adgang til sig; den, han udvælger, vil han give Adgang til sig. ");
INSERT INTO dan1931_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Således skal I gøre: Skaf eder Pander, du Kora og alle dine Tilhængere, ");
INSERT INTO dan1931_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","og læg så i Morgen Gløder på og kom Røgelse på for HERRENS Åsyn, så skal den, HERREN udvælger, være den, som er hellig; lad det nu være nok, I Levisønner!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Fremdeles sagde Moses til Kora: “Hør nu, I Levisønner! ");
INSERT INTO dan1931_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Er det eder ikke nok, at Israels Gud har udskilt eder af Israels Menighed og givet eder Adgang til sig for at udføre Arbejdet ved HERRENS Bolig og stå til Tjeneste for Menigheden? ");
INSERT INTO dan1931_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Han har givet dig og med dig alle dine Brødre, Levis Sønner, Adgang til sig og nu attrår I også Præsteværdigheden! ");
INSERT INTO dan1931_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Derfor, du og alle dine Tilhængere, som har rottet eder sammen mod HERREN, hvad er Aron, at I vil knurre mod ham!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Da sendte Moses Bud efter Datan og Abiram, Eliabs Sønner, men de sagde: “Vi kommer ikke! ");
INSERT INTO dan1931_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Er det ikke nok, at du har ført os bort fra et Land, der flyder med Mælk og Honning, for at lade os dø i Ørkenen, siden du oven i Købet vil opkaste dig til Herre over os! ");
INSERT INTO dan1931_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Du har sandelig ikke ført os til et Land, der flyder med Mælk og Honning, eller givet os Marker og Vinbjerge! Tror du, du kan stikke disse Mænd Blår i Øjnene? Vi kommer ikke!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Da harmedes Moses højlig og sagde til HERREN: “Vend dig ikke til deres Offergave! Ikke så meget som et Æsel har jeg frataget dem, ej heller har jeg gjort en eneste af dem noget ondt!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Og Moses sagde til Kora: “I Morgen skal du og alle dine Tilhængere komme frem for HERRENS Åsyn sammen med Aron; ");
INSERT INTO dan1931_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","og enhver af eder skal tage sin Pande, lægge Gløder på og komme Røgelse på og frembære sin Pande for HERRENS Åsyn, 250 Pander, du selv og Aron skal også tage hver sin Pande!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Da tog hver sin Pande, lagde Gløder på og kom Røgelse på, og så stillede de sig ved indgangen til Åbenbaringsteltet sammen med Moses og Aron; ");
INSERT INTO dan1931_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","og Kora kaldte hele Menigheden sammen imod dem ved Indgangen til Åbenbaringsteltet. Da kom HERRENS Herlighed til Syne for hele Menigheden, ");
INSERT INTO dan1931_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","og HERREN talede til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Skil eder ud fra denne Menighed, så vil jeg i et Nu tilintetgøre den!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Men de faldt på deres Ansigt og sagde: “O Gud, du Gud over alt Køds Ånder, vil du vredes på hele Menigheden, fordi en enkelt Mand synder?” ");
INSERT INTO dan1931_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Da talede HERREN til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Tal til Menigheden og sig: Fjern eder fra Pladsen omkring Koras, Datans og Abirams Bolig!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moses gik nu hen til Datan og Abiram, fulgt af Israels Ældste, ");
INSERT INTO dan1931_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","og han talte til Menigheden og sagde: “Træk eder tilbage fra disse ugudelige Mænds Telte og rør ikke ved noget af, hvad der tilhører dem, for at I ikke skal rives bort for alle deres Synders Skyld!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Da fjernede de sig fra Pladsen om Koras, Datans og Abirams Bolig, og Datan og Abiram kom ud og stillede sig ved indgangen til deres Telte med deres Hustruer og Børn, store og små. ");
INSERT INTO dan1931_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Og Moses sagde: “Derpå skal I kende, at HERREN har sendt mig for at gøre alle disse Gerninger, og at jeg ikke handler i Egenrådighed: ");
INSERT INTO dan1931_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Dersom disse dør på vanlig menneskelig Vis, og der ikke rammer dem andet, end hvad der rammer alle andre, så har HERREN ikke sendt mig; ");
INSERT INTO dan1931_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","men hvis HERREN lader noget uhørt ske, så Jorden spiler sit Gab op og sluger dem med alt, hvad der tilhører dem, så de farer levende ned i Dødsriget, da skal I derpå kende, at disse Mænd har hånet HERREN!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Og straks, da han havde talt alle disse Ord, åbnede Jorden sig under dem, ");
INSERT INTO dan1931_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","og Jorden lukkede sit Gab op og slugte dem og deres Boliger og alle Mennesker, der tilhørte Kora, og alt, hvad de ejede; ");
INSERT INTO dan1931_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","og de for levende ned i Dødsriget med alt, hvad der tilhørte dem, og Jorden lukkede sig over dem, og de blev udryddet af Forsamlingen. ");
INSERT INTO dan1931_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Men hele Israel, der stod omkring dem, flygtede ved deres Skrig, thi de sagde: “Blot ikke Jorden skal opsluge os!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Og Ild for ud fra HERREN og fortærede de 250 Mænd, der frembar Røgelse. ");
INSERT INTO dan1931_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Da talede HERREN til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Sig til Eleazar, Præsten Arons Søn, at han skal tage Panderne ud af Branden og strø Gløderne ud noget derfra; thi hellige ");
INSERT INTO dan1931_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","er de Pander, der tilhørte disse Mænd, som begik en Synd, der kostede dem Livet. De skal udhamre dem til Plader til Overtræk på Alteret, thi de frembar dem for HERRENS Åsyn, og derfor er de hellige; de skal nu tjene Israelitterne til Tegn.” ");
INSERT INTO dan1931_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Da tog Præsten Eleazar Kobberpanderne, som de opbrændte Mænd havde frembåret, og hamrede dem ud til. Overtræk på Alteret ");
INSERT INTO dan1931_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","som et Mindetegn for Israelitterne om, at ingen Lægmand, ingen, som ikke hører til Arons Efterkommere, må træde frem for at ofre Røgelse for HERRENS Åsyn, for at det ikke skal gå ham som Kora og hans Tilhængere, således som HERREN havde sagt ham ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Men Dagen efter knurrede hele Israels Menighed mod Moses og Aron og sagde: “Det er eder, der har, dræbt HERRENS Folk!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Men da Menigheden samlede sig mod Moses og Aron, vendte de sig mod Åbenbaringsteltet, og se, Skyen dækkede det, og HERRENS Herlighed kom til Syne. ");
INSERT INTO dan1931_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Da trådte Moses og Aron hen foran Åbenbaringsteltet, ");
INSERT INTO dan1931_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","og HERREN talede til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Fjern eder fra denne Menighed, så vil jeg i et Nu tilintetgøre dem!” Da faldt de på deres Ansigt, ");
INSERT INTO dan1931_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","og Moses sagde til Aron: “Tag din Pande, læg Gløder fra Alteret på og kom Røgelse på og skynd dig så hen til Menigheden og skaf den Soning, thi Vreden er brudt frem fra HERREN, Plagen har allerede taget fat!” ");
INSERT INTO dan1931_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Da tog Aron det, således som Moses havde sagt, og løb midt ind i Forsamlingen. Og se, Plagen havde allerede taget fat blandt Folket, men han kom Røgelsen på og skaffede Folket Soning. ");
INSERT INTO dan1931_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Og som han stod der midt imellem døde og levende, hørte Plagen op. ");
INSERT INTO dan1931_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Men de, der omkom ved Plagen, udgjorde 14.700 Mennesker foruden dem, der omkom for Koras Skyld. ");
INSERT INTO dan1931_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Så vendte Aron tilbage til Moses ved Indgangen til Åbenbaringsteltet, efter at Plagen var ophørt. ");
INSERT INTO dan1931_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Sig til Israelitterne, at Øversterne for Fædrenehusene skal give dig en Stav for hvert Fædrenehus, tolv Stave i alt, og skriv så hver enkelts Navn på hans Stav ");
INSERT INTO dan1931_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","og skriv Arons Navn på Levis Stav, thi hvert Overhoved for Fædrenehusene skal have én Stav. ");
INSERT INTO dan1931_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Læg dem så ind i Åbenbaringsteltet foran Vidnesbyrdet, der, hvor jeg åbenbarer mig for dig. ");
INSERT INTO dan1931_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Den Mand, jeg udvælger, hans Stav skal da grønnes; således vil jeg bringe Israelitternes Knurren imod eder til Tavshed, så jeg kan blive fri for den.” ");
INSERT INTO dan1931_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moses sagde nu dette til Israelitterne, og alle deres Øverster gav ham en Stav, så der blev en Stav for hver Øverste efter deres Fædrenehuse, tolv Stave i alt, og Arons Stav var imellem Stavene. ");
INSERT INTO dan1931_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Derpå lagde Moses Stavene hen foran HERRENS Åsyn i Vidnesbyrdets Telt. ");
INSERT INTO dan1931_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Da Moses næste Dag kom ind i Vidnesbyrdets Telt, se, da var Arons Stav, Staven for Levis Hus, grønnedes; den havde sat Skud, var kommet i Blomst og bar modne Mandler. ");
INSERT INTO dan1931_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Da tog Moses Stavene bort fra HERRENS Åsyn og bar dem ud til Israelitterne, og de så på dem og tog hver sin Stav. ");
INSERT INTO dan1931_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Men HERREN sagde til Moses: “Læg Arons Stav tilbage foran Vidnesbyrdet, for at den kan opbevares til Tegn for de genstridige, og gør Ende på deres Knurren, så jeg kan blive fri for den, at de ikke skal dø!” ");
INSERT INTO dan1931_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Og Moses gjorde som HERREN havde pålagt ham; således gjorde han. ");
INSERT INTO dan1931_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Men Israelitterne sagde til Moses: “Se, vi omkommer, det er ude med os, det er ude med os alle sammen! ");
INSERT INTO dan1931_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Enhver, der kommer HERRENS Bolig nær, dør. Skal vi da virkelig omkomme alle sammen?” ");
INSERT INTO dan1931_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","HERREN sagde til Aron: Du tillige med dine Sønner og dit Fædrenehus skal have Ansvaret for Helligdommen, og du tillige med dine Sønner skal have Ansvaret for eders Præstetjeneste. ");
INSERT INTO dan1931_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Men også dine Brødre, Levis Stamme, din Fædrenestamme, skal du lade træde frem sammen med dig, og de skal holde sig til dig* og gå dig til Hånde, når du tillige med dine Sønner gør Tjeneste foran Vidnesbyrdets Telt; { *på hebr. Ordspil med Navnet Levi. } ");
INSERT INTO dan1931_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","og de skal tage Vare på, hvad du har at varetage, og på alt, hvad der er at varetage ved Teltet, men de må ikke komme de hellige Ting eller Alteret nær, at ikke både de og I skal dø. ");
INSERT INTO dan1931_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","De skal holde sig til dig og tage Vare på, hvad der er at varetage ved Åbenbaringsteltet, alt Arbejdet derved, men ingen Lægmand må der komme eder nær. ");
INSERT INTO dan1931_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Men I skal tage Vare på, hvad der er at varetage ved Helligdommen og Alteret, for at der ikke atter skal komme Vrede over Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Se, jeg har selv udtaget eders Brødre Levitterne af Israelitternes Midte som en Gave til eder, de er givet HERREN til at udføre Arbejdet ved Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Men du tillige med dine Sønner skal tage Vare på eders Præstegerning i alt, hvad der angår Alteret og det, der er inden for Forhænget, og udføre Arbejdet derved. Som en Gave skænker jeg eder Præstedømmet; men enhver Lægmand, der trænger sig ind deri, skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","HERREN talede fremdeles til Aron: Se, jeg giver dig, hvad der skal lægges til Side af mine Offerydelser; alle Israelitternes Helliggaver giver jeg dig og dine Sønner som eders Del, en evig gyldig Rettighed. ");
INSERT INTO dan1931_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Følgende skal tilfalde dig af det højhellige, fraregnet hvad der opbrændes: Alle deres Offergaver, der falder ind under Afgrødeofre, Syndofre og Skyldofre, som de bringer mig til Erstatning; som højhelligt skal dette tilfalde dig og dine Sønner. ");
INSERT INTO dan1931_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","På et højhelligt Sted skal du spise det, og alle af Mandkøn må spise deraf; det skal være dig helligt. ");
INSERT INTO dan1931_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Fremdeles skal følgende tilfalde dig som Offerydelse af deres Gaver: Alle Gaver fra Israelitterne, hvormed der udføres Svingning, giver jeg dig tillige med dine Sønner og Døtre som en evig gyldig Rettighed; enhver, som er ren i dit Hus, må spise deraf. ");
INSERT INTO dan1931_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Alt det bedste af Olien, Mosten og Kornet, Førstegrøden deraf, som de giver HERREN, giver jeg dig. ");
INSERT INTO dan1931_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","De første Frugter af alt, hvad der gror i deres Land, som de bringer HERREN, skal tilfalde dig; enhver, som er ren i dit Hus, må spise deraf. ");
INSERT INTO dan1931_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Alt, hvad der lægges Band på i Israel, skal tilfalde dig. ");
INSERT INTO dan1931_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Af alt Kød, som de bringer til HERREN, såvel af Mennesker som af Dyr, skal alt, hvad der åbner Moders Liv, tilfalde dig; dog skal du lade de førstefødte Mennesker udløse, og ligeledes skal du lade de førstefødte urene Dyr udløse. ");
INSERT INTO dan1931_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Hine skal du lade udløse, når de er en Måned gamle eller derover, med en Vurderingssum af fem Sekel efter hellig Vægt, tyve Gera på en Sekel. ");
INSERT INTO dan1931_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Men de førstefødte Stykker Hornkvæg, Lam eller Geder må du ikke lade udløse; de er hellige, deres Blod skal du sprænge på Alteret, og Fedtet skal du bringe som Røgoffer, et Ildoffer til en liflig Duft for HERREN; ");
INSERT INTO dan1931_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","men Kødet tilfalder dig; ligesom Svingningsbrystet og højre Kølle tilfalder det dig. ");
INSERT INTO dan1931_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Al Offerydelse af Helliggaver, som Israelitterne yder HERREN, giver jeg dig tillige med dine Sønner og Døtre som en evig gyldig Rettighed; det skal være en evig gyldig Saltpagt for HERRENS Åsyn for dig tillige med dine Efterkommere. ");
INSERT INTO dan1931_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","HERREN sagde fremdeles til Aron: Du skal ingen Arvelod have i deres Land, og der skal ikke tilfalde dig nogen Lod iblandt dem; jeg selv er din Arvelod og Del blandt Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Men se, Levisønnerne giver jeg al Tiende i Israel som Arvelod til Løn for det Arbejde, de udfører ved Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Israelitterne må herefter ikke komme Åbenbaringsteltet nær, for at de ikke skal pådrage sig Synd og dø; ");
INSERT INTO dan1931_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","kun Levitterne må udføre Arbejdet ved Åbenbaringsteltet, og de skal have Ansvaret derfor. Det skal være eder en evig gyldig Anordning fra Slægt til Slægt. Men nogen Arvelod skal de ikke have blandt Israelitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","thi Tienden, Israelitterne yder HERREN som Offerydelse, giver jeg Levitterne til Arvelod. Derfor sagde jeg dem, at de ikke skal have nogen Arvelod blandt Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Tal til Levitterne og sig til dem: Når I af Israelitterne modtager Tienden, som jeg har givet eder som den Arvelod, I skal have af dem, så skal I yde HERREN en Offerydelse deraf, Tiende af Tienden; ");
INSERT INTO dan1931_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","og denne eders Offerydelse skal ligestilles med Offerydelsen af Kornet fra Tærskepladsen og Overfloden fra Vinpersen*. { *dvs. fra de andre Israelitter. } ");
INSERT INTO dan1931_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Således skal også I yde HERREN en Offerydelse af al den Tiende, I modtager af Israelitterne, og denne HERRENS Offerydelse skal I give Præsten Aron. ");
INSERT INTO dan1931_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Af alle de Gaver*, I modtager, skal I yde HERRENS Offerydelse, af alt det bedste deraf, som hans Helliggave. { *dvs. Tienden. } ");
INSERT INTO dan1931_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Og sig til dem: Når I yder det bedste deraf, skal det ligestilles med Offerydelsen af, hvad der kommer fra Tærskepladsen og Vinpersen*. { *jfr. V. 27. } ");
INSERT INTO dan1931_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","I må spise det hvor som helst sammen med eders Familie, thi det er eders Løn for eders Arbejde ved Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Når I blot yder det bedste deraf, skal I ikke for den Sags Skyld pådrage eder Synd og ikke vanhellige Israelitternes Helliggaver og udsætte eder for at dø. ");
INSERT INTO dan1931_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","HERREN talede fremdeles til Moses og Aron og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Dette er det Lovbud, HERREN har kundgjort: Sig til Israelitterne, at de skal skaffe dig en rød, lydefri Kvie, der er uden Fejl og ikke har båret Åg. ");
INSERT INTO dan1931_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Den skal I overgive til Præsten Eleazar, og man skal føre den uden for Lejren og slagte den for hans Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Så skal Præsten Eleazar tage noget af dens Blod på sin Finger og stænke det syv Gange i Retning af Åbenbaringsteltets Forside. ");
INSERT INTO dan1931_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Derpå skal Kvien brændes i hans Påsyn; dens Hud, Kød og Blod tillige med Skarnet skal opbrændes. ");
INSERT INTO dan1931_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Derefter skal Præsten tage Cedertræ, Ysop og karmoisinrødt Uld og kaste det på Bålet, hvor Kvien brænder. ");
INSERT INTO dan1931_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Så skal Præsten tvætte sine Klæder og bade sit Legeme i Vand og derefter vende tilbage til Lejren. Men Præsten skal være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ligeledes skal den Mand, der brænder Kvien, tvætte sine Klæder med Vand og bade sit Legeme i Vand og være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Og en Mand, der er ren, skal opsamle Kviens Aske og lægge den hen på et rent Sted uden for Lejren, hvor den skal opbevares for Israelitternes Menighed for at bruges til Renselsesvand. Det er et Syndoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Og den, der opsamler Kviens Aske, skal tvætte sine Klæder og være uren til Aften. For Israelitterne og den fremmede, der bor iblandt dem, skal dette være en evig gyldig Anordning: ");
INSERT INTO dan1931_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Den, der rører ved en død, ved noget som helst Lig, skal være uren i syv Dage. ");
INSERT INTO dan1931_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Han skal lade sig rense for Synd med Asken på den tredje og syvende Dag, så bliver han ren; men renser han sig ikke på den tredje og syvende Dag, bliver han ikke ren. ");
INSERT INTO dan1931_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Enhver, der rører ved en død, et Lig, og ikke lader sig rense for Synd, besmitter HERRENS Bolig, og det Menneske skal udryddes af Israel, fordi der ikke er stænket Renselsesvand på ham; han er uren, hans Urenhed klæber endnu ved ham. ");
INSERT INTO dan1931_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Således er Loven: Når et Menneske dør i et Telt, bliver enhver, der træder ind i Teltet, og enhver, der er i Teltet, uren i syv Dage; ");
INSERT INTO dan1931_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","og ethvert åbent Kar, et, der ikke er bundet noget over, bliver urent. ");
INSERT INTO dan1931_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ligeledes bliver enhver, der på åben Mark rører ved en, der er dræbt med Sværd, eller ved en, der er død, eller ved Menneskeknogler eller en Grav, uren i syv Dage. ");
INSERT INTO dan1931_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","For sådanne urene skal man da tage noget af Asken af det brændte Syndoffer og hælde rindende Vand derover i en Skål. ");
INSERT INTO dan1931_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Derpå skal en Mand, der er ren, tage en Ysopstængel, dyppe den i Vandet og stænke det på Teltet og på alle de Ting og Mennesker, der har været deri, og på den, der har rørt ved Menneskeknoglerne, den ihjelslagne, den døde eller Graven. ");
INSERT INTO dan1931_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Således skal den rene bestænke den urene på den tredje og syvende Dag og borttage hans Synd på den syvende Dag. Derefter skal han tvætte sine Klæder og bade sig i Vand, så er han ren, når det bliver aften. ");
INSERT INTO dan1931_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Men den, som bliver uren og ikke lader sig rense for Synd, han skal udryddes af Forsamlingen; thi han har besmittet HERRENS Helligdom, der er ikke stænket Renselsesvand på ham, han er uren. ");
INSERT INTO dan1931_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Det skal være eder en evig gyldig Anordning. Den, der stænker Renselsesvandet, skal tvætte sine Klæder, og den, der rører ved Renselsesvandet, skal være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Alt, hvad den urene rører ved skal være urent, og enhver, der rører ved ham, skal være uren til Aften. ");
INSERT INTO dan1931_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Derpå nåede Israelitterne, hele Menigheden, til Zins Ørken i den første Måned*, og Folket slog sig ned i Kadesj. Der døde Mirjam, og der blev hun jordet. { *vistnok Ørkenvandringens sidste År. 4 Mos. 33, 38. } ");
INSERT INTO dan1931_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Men der var ikke Vand til Menigheden; derfor samlede de sig mod Moses og Aron, ");
INSERT INTO dan1931_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","og Folket kivedes med Moses og sagde: “Gid vi var omkommet, dengang vore Brødre omkom for HERRENS Åsyn! ");
INSERT INTO dan1931_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Hvorfor førte I HERRENS Forsamling ind i denne Ørken, når vi skal dø her, både vi og vort Kvæg? ");
INSERT INTO dan1931_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Og hvorfor førte I os ud af Ægypten, når I vilde have os hen til dette skrækkelige Sted, hvor der hverken er Korn eller Figener, Vintræer eller Granatæbler, ej heller Vand at drikke?” ");
INSERT INTO dan1931_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Men Moses og Aron begav sig fra Forsamlingen hen til Åbenbaringsteltets indgang og faldt på deres Ansigt. Da viste HERRENS Herlighed sig for dem, ");
INSERT INTO dan1931_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Tag Staven og kald så tillige med din Broder Aron Menigheden sammen og tal til Klippen i deres Påsyn, så giver den Vand; lad Vand strømme frem af Klippen til dem og skaf Menigheden og dens Kvæg noget at drikke!” ");
INSERT INTO dan1931_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Da tog Moses Staven fra dens Plads foran HERRENS Åsyn, som han havde pålagt ham; ");
INSERT INTO dan1931_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","og Moses og Aron kaldte Forsamlingen sammen foran Klippen, og han sagde til dem: “Hør nu, I genstridige! Mon vi formår at få Vand til at strømme frem til eder af denne Klippe?” ");
INSERT INTO dan1931_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Og Moses løftede sin Hånd og slog to Gange på Klippen med sin Stav, og der strømmede Vand frem i Mængde, så at Menigheden og dens Kvæg kunde drikke. ");
INSERT INTO dan1931_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Men HERREN sagde til Moses og Aron: “Fordi I ikke troede på mig og helligede mig for Israelitternes Øjne, skal I ikke komme til at føre denne Forsamling ind i det Land, jeg vil give dem!” ");
INSERT INTO dan1931_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Dette er Meribas* Vand, hvor Israelitterne kivedes med HERREN, og hvor han åbenbarede sin Hellighed på dem. { *betyder kiv. 2 Mos. 17, 7. } ");
INSERT INTO dan1931_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Fra Kadesj sendte Moses Sendebud til kongen af Edom med det Bud: “Din Broder Israel lader sige: Du kender jo alle de Besværligheder, som er vederfaret os, ");
INSERT INTO dan1931_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","hvorledes vore Fædre drog ned til Ægypten, hvorledes vi boede der i lange Tider, og hvorledes Ægypterne mishandlede os og vore Fædre; ");
INSERT INTO dan1931_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","da råbte vi til HERREN, og han hørte vor Røst og sendte en Engel og førte os ud af Ægypten. Se, nu er vi i Byen Kadesj ved Grænsen af dine Landemærker. ");
INSERT INTO dan1931_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Lad os få Lov at vandre igennem dit Land. Vi vil hverken drage hen over Marker eller Vinhaver eller drikke Vandet i Brøndene; vi vil gå ad Kongevejen, vi vil hverken bøje af til højre eller venstre, før vi er nået igennem dit Land!” ");
INSERT INTO dan1931_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Men Edom svarede ham: “Du må ikke vandre igennem mit Land, ellers drager jeg imod dig med Sværd i Hånd!” ");
INSERT INTO dan1931_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Da sagde Israelitterne til ham: “Vi vil følge den slagne Landevej, og der som jeg eller mit Kvæg drikker af dine Vandingssteder, vil jeg betale derfor det er da ikke noget at være bange for, jeg vil kun vandre derigennem til Fods!” ");
INSERT INTO dan1931_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Men han svarede: “Du må ikke drage her igennem!” Og Edom rykkede imod ham med mange Krigere og stærkt rustet. ");
INSERT INTO dan1931_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Da Edom således formente Israel at drage igennem sine Landemærker, bøjede Israel af og drog udenom. ");
INSERT INTO dan1931_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Derpå brød Israelitterne, hele Menigheden, op fra Kadesj og kom til Bjerget Hor. ");
INSERT INTO dan1931_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Og HERREN talede til Moses og Aron ved Bjerget Hor ved Grænsen til Edoms Land og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aron skal nu samles til sin Slægt, thi han skal ikke komme ind i det Land, jeg vil give Israelitterne, fordi I var genstridige mod mit Bud ved Meribas Vand. ");
INSERT INTO dan1931_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Tag Aron og hans Søn Eleazar og før dem op på Bjerget Hor; ");
INSERT INTO dan1931_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","affør så Aron hans Klæder og ifør hans Søn Eleazar dem, thi der skal Aron tages bort og dø!” ");
INSERT INTO dan1931_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Da gjorde Moses som HERREN bød, og de gik op på Bjerget Hor i hele Menighedens Påsyn; ");
INSERT INTO dan1931_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","og efter at Moses havde afført Aron hans Klæder og iført hans Søn Eleazar dem, døde Aron deroppe på Bjergets Top. Men Moses og Eleazar steg ned fra Bjerget, ");
INSERT INTO dan1931_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","og da hele Menigheden skønnede, at Aron var død, græd de over Aron i tredive Dage, hele Israels Hus. ");
INSERT INTO dan1931_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Men da Kana'anæeren, Kongen af Arad, der boede i Sydlandet, hørte, at Israel rykkede frem ad Atarimvejen, angreb han Israel og tog nogle af dem til Fange. ");
INSERT INTO dan1931_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Da aflagde Israel et Løfte til Herren og sagde: “Hvis du giver dette Folk i min Hånd, vil jeg lægge Band på deres Byer!” ");
INSERT INTO dan1931_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Og HERREN hørte Israels Røst og gav Kana'anæerne i deres Hånd, hvorefter de lagde Band* på dem og deres Byer. Derfor gav man Stedet Navnet Horma. { *på hebr. Ordspil med Navnet Horma. } ");
INSERT INTO dan1931_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Så brød de op fra Bjerget Hor i Retning af det røde Hav for at komme uden om Edoms Land. Undervejs blev Folket utålmodigt ");
INSERT INTO dan1931_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","og talte mod Gud og Moses og sagde: “Hvorfor førte I os ud af Ægypten, når vi skal dø i Ørkenen? Her er jo hverken Brød eller Vand, og vi er lede ved denne usle Føde.” ");
INSERT INTO dan1931_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Da sendte HERREN Giftslanger blandt Folket, og de bed Folket så en Mængde af Israel døde. ");
INSERT INTO dan1931_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Så kom Folket til Moses og sagde: “Vi har syndet ved at tale imod HERREN og dig; gå i Forbøn hos HERREN, at han tager Slangerne fra os!” Og Moses gik i Forbøn for Folket. ");
INSERT INTO dan1931_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Da sagde HERREN til Moses: “Lav dig en Slange og sæt den på en Stang, så skal enhver slangebidt, der ser hen på den, leve!” ");
INSERT INTO dan1931_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Da lavede Moses en Kobberslange og satte den på en Stang; og enhver, der så hen på Kobberslangen, når en Slange havde bidt ham, beholdt Livet. ");
INSERT INTO dan1931_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Så brød Israelitterne op og slog Lejr i Obot; ");
INSERT INTO dan1931_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","og de brød op fra Obot og slog Lejr i Ijje-Ha'abarim i Ørkenen østen for Moab. ");
INSERT INTO dan1931_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Derfra brød de op og slog Lejr i Zereddalen. ");
INSERT INTO dan1931_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Derfra brød de op og slog Lejr i Ørkenen hinsides Arnon, som udspringer på Amoritternes Område, thi Arnon var Moabs Grænse mod Amoritterne. ");
INSERT INTO dan1931_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Derfor hedder det i Bogen om HERRENS Krige: Vaheb i Sufa og Dalene, Arnon og Dalenes Skrænt, ");
INSERT INTO dan1931_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","som strækker sig til Ars Sæde og læner sig til Moabs Grænse. ");
INSERT INTO dan1931_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Derfra brød de op til Be'er*; det er det Be'er, HERREN havde for Øje, da han sagde til Moses: “Kald Folket sammen, så vil jeg give dem Vand!” { *betyder Brønd. } ");
INSERT INTO dan1931_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Da sang Israelitterne denne Sang: Brønd, væld frem! Syng til dens Pris! ");
INSERT INTO dan1931_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Brønd, som Høvdinger grov, som Folkets ædle bored med Herskerspir og Stave! Fra Ørkenen brød de op til Mattana; ");
INSERT INTO dan1931_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","fra Mattana til Nahaliel; fra Nahaliel til Bamot; ");
INSERT INTO dan1931_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","fra Bamot til halen på Moabs Højslette, til Pisgas Top, som rager op over Ørkenen. ");
INSERT INTO dan1931_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel sendte nu Sendebud til Amoritterkongen Sihon og lod sige: ");
INSERT INTO dan1931_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Lad mig få Lov at drage igennem dit Land! Vi vil ikke dreje ind på Marker eller i Vinhaver, vi vil ikke drikke Vand af Brøndene, vi vil følge Kongevejen, indtil vi er nået igennem dit Land!” ");
INSERT INTO dan1931_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Men Sihon tillod ikke Israel at drage igennem sit Land; derimod samlede han alt sit krigsfolk og rykkede ud i Ørkenen imod Israel, og da han nåede Jaza, angreb han Israel. ");
INSERT INTO dan1931_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Men Israel slog ham med Sværdet og underlagde sig hans Land fra Arnon til Jabbok, til Ammonitternes Land; thi Ja'zer ligger ved Ammonitternes Grænse; ");
INSERT INTO dan1931_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","og Israel indtog alle disse Byer, og Israel bosatte sig i alle Amoritternes Byer, i Hesjbon og alle tilhørende Småbyer. ");
INSERT INTO dan1931_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Thi Hesjbon var Amoritterkongen Sihons By; han havde angrebet Moabs forrige konge og frataget ham hele hans Land indtil Arnon. ");
INSERT INTO dan1931_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Derfor synger Skjaldene: Kom hid til Hesjbon, lad den blive bygget og grundfæstet, Sihons By! ");
INSERT INTO dan1931_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Thi Ild for ud fra Hesjbon, Ildslue fra Sihons Stad, den fortærede Moabs Byer, opåd Arnons Højder. ");
INSERT INTO dan1931_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ve dig, Moab! Det er ude med dig, Kemosj's Folk! Han* gjorde sine Sønner til Flygtninge og sine Døtre til Krigsfanger for Sihon, Amoritternes Konge. { *dvs. Kemosj, Moabs Gud. } ");
INSERT INTO dan1931_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Og vi skød dem ned, Hesjbon er tabt indtil Dibon; vi lagde dem øde til Nofa, som ligger ved Medeba. ");
INSERT INTO dan1931_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Så bosatte Israel sig i Amoritternes Land. ");
INSERT INTO dan1931_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Derpå sendte Moses Spejdere til Ja'zer; og de erobrede det tillige med tilhørende Småbyer, og han drev de der boende Amoritter bort. ");
INSERT INTO dan1931_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Derpå vendte de om og drog ad Basan til. Da rykkede Og, Kongen af Basan, ud imod dem med alle sine Krigere og angreb dem ved Edre'i. ");
INSERT INTO dan1931_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Men HERREN sagde til Moses: “Frygt ikke for ham! Thi jeg giver ham og alle hans krigere og hans Land i din Hånd, så at du kan handle med ham, som du handlede med Amoritterkongen Sihon, der boede i Hesjbon.” ");
INSERT INTO dan1931_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Da slog de ham og hans Sønner og alle hans Krigere, så at ikke en eneste af dem undslap, og derpå underlagde de sig hans Land. ");
INSERT INTO dan1931_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Derefter brød Israelitterne op derfra og slog Lejer på Moabs Sletter hinsides Jordan over for Jeriko. ");
INSERT INTO dan1931_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Da Balak, Zippors Søn, så alt, hvad Israel havde gjort ved Amoritterne, ");
INSERT INTO dan1931_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","grebes Moab af Rædsel for Folket, fordi det var så talrigt, og Moab gruede for Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Da sagde Moab til Midjanitternes Ældste: “Nu vil denne Menneskemasse opæde alt, hvad der er rundt omkring os, som Okserne opæder Græsset på Marken!” På den Tid var Balak, Zippors Søn, Konge over Moab. ");
INSERT INTO dan1931_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Han sendte nu Sendebud til Bileam, Beors Søn, i Petor, der ligger ved Floden, til Ammonitternes Land, og bad ham komme til sig, idet han lod sige: “Se, et Folk er udvandret fra Ægypten; se, det har oversvømmet Landet og slået sig ned lige over for mig. ");
INSERT INTO dan1931_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Kom nu og forband mig det Folk, thi det er mig for mægtigt: måske jeg da kan slå det og jage det ud af Landet. Thi jeg ved, at den, du velsigner, er velsignet, og den, du forbander, forbandet!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Da gav Moabs og Midjans Ældste sig på Vej, forsynede med Spåmandsløn, og da de kom til Bileam, overbragte de ham Balaks Ord. ");
INSERT INTO dan1931_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Han sagde til dem: “Bliv her Natten over, så skal jeg give eder Svar, efter som HERREN vil tale til mig!” Moabs Høvdinger blev da hos Bileam. ");
INSERT INTO dan1931_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Men Gud kom til Bileam og spurgte: “Hvem er de Mænd, som er hos dig?” ");
INSERT INTO dan1931_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Men Bileam svarede Gud: “Zippors Søn, Kong Balak af Moab, har sendt mig det Bud: ");
INSERT INTO dan1931_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Se, et Folk er udvandret fra Ægypten og har oversvømmet Landet! Kom nu og forband mig det, måske jeg da kan overvinde det og jage det bort!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Men Gud sagde til Bileam: “Du må ikke gå med dem, du må ikke forbande det Folk, thi det er velsignet!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Næste Morgen stod Bileam op og sagde til Balaks Høvdinger: “Vend tilbage til eders Land, thi HERREN vægrer sig ved at give mig Tilladelse til at følge med eder!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Da brød Moabs Høvdinger op, og de kom til Balak og meldte: “Bileam vægrede sig ved at følge med os!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Men Balak sendte på ny Høvdinger af Sted, flere og mere ansete end de forrige; ");
INSERT INTO dan1931_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","og de kom til Bileam og sagde til ham: “Således siger Balak, Zippors Søn: Undslå dig ikke for at komme til mig! ");
INSERT INTO dan1931_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Jeg vil lønne dig rigeligt og gøre alt, hvad du kræver af mig. Kom nu og forband mig det Folk!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Men Bileam svarede Balaks Folk: “Om Balak så giver mig alt det Sølv og Guld, han har i sit Hus, formår jeg dog hverken at gøre lidt eller meget imod HERREN min Guds Befaling; ");
INSERT INTO dan1931_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","bliv derfor også I her Natten over, for at jeg kan få at vide, hvad HERREN yderligere vil tale til mig!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Da kom Gud om Natten til Bileam og sagde til ham: “Er disse Mænd kommet til dig for at hente dig, så følg med dem; men du må ikke gøre andet, end hvad jeg siger dig!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Så stod Bileam op næste Morgen og sadlede sit Æsel og fulgte med Moabs Høvdinger. ");
INSERT INTO dan1931_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Men Guds Vrede blussede op, fordi han fulgte med, og HERRENS Engel stillede sig på Vejen for at stå ham imod, da han kom ridende på sit Æsel fulgt af sine to Tjenere. ");
INSERT INTO dan1931_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Da nu Æselet så HERRENS Engel stå på Vejen med draget Sværd i Hånden, veg det ud fra Vejen og gik ind på Marken; men Bileam slog Æselet for at tvinge det tilbage på Vejen. ");
INSERT INTO dan1931_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Da stillede HERRENS Engel sig i Hulvejen mellem Vingårdene, hvor der var Mure på begge Sider; ");
INSERT INTO dan1931_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","og da Æselet så HERRENS Engel, trykkede det sig op til Muren, så det trykkede Bileams Fod op mod Muren, og han gav sig atter til at slå det. ");
INSERT INTO dan1931_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","HERRENS Engel gik nu længere frem og stillede sig i en Snævring, hvor det ikke var muligt at komme til Siden, hverken til højre eller venstre. ");
INSERT INTO dan1931_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Da Æselet så HERRENS Engel, lagde det sig ned med Bileam. Da blussede Bileams Vrede op, og han gav sig til at slå Æselet med Stokken. ");
INSERT INTO dan1931_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Men HERREN åbnede Æselets Mund, og det sagde til Bileam: “Hvad har jeg gjort dig, siden du nu har slået mig tre Gange?” ");
INSERT INTO dan1931_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileam svarede Æselet: “Du har drillet mig; havde jeg haft et Sværd i Hånden, havde jeg slået dig ihjel!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Men Æselet sagde til Bileam: “Er jeg ikke dit eget Æsel, som du har redet al din Tid indtil i Dag? Har jeg ellers haft for Vane at bære mig således ad over for dig?” Han svarede: “Nej!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Da åbnede HERREN Bileams Øjne, og han så HERRENS Engel stå på Vejen med draget Sværd i Hånden; og han bøjede sig og kastede sig ned på sit Ansigt. ");
INSERT INTO dan1931_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Men HERRENS Engel sagde til ham: “Hvorfor slog du dit Æsel de tre Gange? Se, jeg er gået ud for at stå dig imod, thi du handlede overilet ved at rejse imod min Vilje. ");
INSERT INTO dan1931_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Æselet så mig og veg tre Gange til Side for mig; og var det ikke veget til Side for mig, havde jeg slået dig ihjel, men skånet dets Liv!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Da sagde Bileam til HERRENS Engel: “Jeg har syndet, jeg vidste jo ikke, at det var dig, der trådte i Vejen for mig. Men hvis det er dig imod, vil jeg atter vende tilbage.” ");
INSERT INTO dan1931_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","HERRENS Engel sagde til Bileam: “Følg blot med disse Mænd, men du må kun sige de Ord, jeg siger dig!” Så fulgte Bileam med Balaks Høvdinger. ");
INSERT INTO dan1931_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Da Balak nu hørte, at Bileam var undervejs, gik han ham i Møde til Ar Moab ved den Grænse, Arnon danner, den yderste Grænse. ");
INSERT INTO dan1931_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Og Balak sagde til Bileam: “Sendte jeg dig ikke Bud og bad dig komme? Hvorfor kom du da ikke til mig? Skulde jeg virkelig være ude af Stand til at lønne dig?” ");
INSERT INTO dan1931_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bileam sagde til Balak: “Se, nu er jeg kommet til dig; men mon det står i min Magt at sige noget? Det Ord, Gud lægger mig i Munden, må jeg tale!” ");
INSERT INTO dan1931_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Da fulgte Bileam med Balak, og de kom til Kirjat-Huzot. ");
INSERT INTO dan1931_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak ofrede her Hornkvæg og Småkvæg og sendte noget til Bileam og Høvdingerne, der var hos ham. ");
INSERT INTO dan1931_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Næste Morgen tog Balak Bileam med sig og førte ham op til Bamot Ba'al, hvorfra han kunde øjne den yderste Del af Folket. ");
INSERT INTO dan1931_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Og Bileam sagde til Balak: “Byg mig syv Altre her og skaf mig syv unge Tyre og syv Vædre herhen!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak gjorde, som Bileam sagde, og Balak og Bileam ofrede en Tyr og en Vædder på hvert Alter. ");
INSERT INTO dan1931_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Derpå sagde Bileam til Balak: “Bliv stående her ved dit Brændoffer, så vil jeg gå hen og se, om HERREN mulig kommer mig i Møde. Hvad han da lader mig skue, skal jeg lade dig vide.” Så gik han op på en nøgen Klippetop. ");
INSERT INTO dan1931_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Da kom Gud Bileam i Møde. Og han sagde til ham: “Jeg har gjort de syv Altre i Stand og ofret en Tyr og en Vædder på hvert.” ");
INSERT INTO dan1931_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Og Gud lagde Bileam Ord i Munden og sagde: “Vend tilbage til Balak og tal således til ham!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Da vendte han tilbage til ham, og se, han stod ved sit Brændoffer sammen med alle Moabs Høvdinger. ");
INSERT INTO dan1931_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Og han fremsatte sit Sprog: Fra Aram lod Balak mig hente, Moabs Konge fra Østens Bjerge: “Kom og forband mig Jakob, kom og kald Vrede ned over Israel!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Hvor kan jeg forbande, når Gud ej forbander, nedkalde Vrede, når HERREN ej vredes! ");
INSERT INTO dan1931_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Jeg ser det fra Klippernes Top, fra Højderne skuer jeg det, et Folk, der bor for sig selv og ikke regner sig til Hedningefolkene. ");
INSERT INTO dan1931_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Hvem kan måle Jakobs Sandskorn, hvem kan tælle Israels Støvgran? Min Sjæl dø de oprigtiges Død, og mit Endeligt vorde som deres! ");
INSERT INTO dan1931_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Da sagde Balak til Bileam: “Hvad har du gjort imod mig! Jeg lod dig hente, for at du skulde forbande mine Fjender, og se, du har velsignet dem!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Men han svarede: “Skal jeg ikke omhyggeligt sige, hvad HERREN lægger mig i Munden?” ");
INSERT INTO dan1931_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Da sagde Balak til ham: “Følg med mig til et andet Sted, hvorfra du kan se Folket, dog kun den yderste Del deraf og ikke det hele, og forband mig det så fra det Sted!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Og han tog ham med til Udkigsmarken på Toppen af Pisga og rejste der syv Altre og ofrede en Tyr og en Vædder på hvert. ");
INSERT INTO dan1931_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Derpå sagde Bileam til Balak: “Bliv stående her ved dit Brændoffer, medens jeg ser efter, om der møder mig noget!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Da kom Gud Bileam i Møde og lagde ham Ord i Munden og sagde: “Vend tilbage til Balak og tal således!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Så kom han hen til ham, og se, han stod ved sit Brændoffer sammen med Moabs Høvdinger; og Balak spurgte ham: “Hvad har HERREN sagt?” ");
INSERT INTO dan1931_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Da fremsatte han sit Sprog: Rejs dig, Balak, og hør, lyt til mig, Zippors Søn! ");
INSERT INTO dan1931_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Gud er ikke et Menneske, at han skulde lyve, et Menneskebarn, at han skulde angre; mon han siger noget uden at gøre det, mon han taler uden at fuldbyrde det? ");
INSERT INTO dan1931_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Se, at velsigne er mig givet, så velsigner jeg og tager intet tilbage! ");
INSERT INTO dan1931_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Man skuer ej Nød i Jakob, ser ej Trængsel i Israel; HERREN dets Gud er med det, og Kongejubel lyder hos det. ");
INSERT INTO dan1931_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Gud førte det ud af Ægypten, det har en Vildokses Horn. ");
INSERT INTO dan1931_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Thi mod Jakob hjælper ej Galder, Trolddom ikke mod Israel. Nu siger man om Jakob og om Israel: “Hvad har Gud gjort?” ");
INSERT INTO dan1931_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Se, et Folk, der står op som en Løvinde, rejser sig som en Løve! Det lægger sig først, når det har ædt Rov og drukket de dræbtes Blod. ");
INSERT INTO dan1931_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Da sagde Balak til Bileam: “Vil du ikke forbande det, så velsign det i alt Fald ikke!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Men Bileam svarede og sagde til Balak: “Har jeg ikke sagt dig, at alt, hvad HERREN siger, det gør jeg!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Da sagde Balak til Bileam: “Kom, jeg vil tage dig med til et andet Sted, måske det vil behage Gud, at du forbander mig det fra det Sted.” ");
INSERT INTO dan1931_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Og Balak førte Bileam op på Toppen af Peor, der rager op over Ørkenen. ");
INSERT INTO dan1931_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Så sagde Bileam til Balak: “Byg mig syv Altre her og skaf mig syv unge Tyre og syv Vædre herhen!” ");
INSERT INTO dan1931_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak gjorde, som Bileam sagde, og ofrede en Tyr og en Vædder på hvert Alter. ");
INSERT INTO dan1931_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Men da Bileam så, at HERRENS Hu stod til at velsigne Israel, gik han ikke som de forrige Gange hen for at søge Varsler, men vendte sig mod Ørkenen; ");
INSERT INTO dan1931_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","og Bileam så op og fik Øje på Israel; som lå lejret Stamme for Stamme. Da kom Guds Ånd over ham, ");
INSERT INTO dan1931_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","og han fremsatte sit Sprog: Så siger Bileam, Beors Søn, så siger Manden, hvis Øje er lukket, ");
INSERT INTO dan1931_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","så siger han, der hører Guds Ord og kender den Højestes Viden, som skuer den Almægtiges Syner, hensunken, med opladt Øje: ");
INSERT INTO dan1931_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Hvor herlige er dine Telte, Jakob, og dine Boliger, Israel! ");
INSERT INTO dan1931_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Som Dale, der strækker sig vidt, som Haver langs med en Flod, som Aloetræer, HERREN har plantet, som Cedre ved Vandets Bred. ");
INSERT INTO dan1931_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Dets Spande flyder over med Vand, dets Korn får rigelig Væde. Mægtigere end Agag er dets Konge, og ophøjet er dets kongedømme. ");
INSERT INTO dan1931_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gud førte det ud af Ægypten, det har en Vildokses Horn; det opæder de Folkeslag der står det imod, søndrer deres Ben og knuser deres Lænder. ");
INSERT INTO dan1931_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Det lægger sig, hviler som en Løve, ja, som en Løvinde, hvo tør vække det! Velsignet, hvo dig velsigner, forbandet, hvo dig forbander! ");
INSERT INTO dan1931_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Da blussede Balaks Vrede op mod Bileam, og han slog Hænderne sammen; og Balak sagde til Bileam: “For at forbande mine Fjender bad jeg dig komme, og se, nu har du velsignet dem tre Gange! ");
INSERT INTO dan1931_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Skynd dig derhen, hvor du kom fra! Jeg lovede dig rigelig Løn, men mon har HERREN unddraget dig den!” ");
INSERT INTO dan1931_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Men Bileam sagde til Balak: “Sagde jeg ikke allerede til Sendebudene, du sendte mig: ");
INSERT INTO dan1931_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Om Balak så giver mig alt det Sølv og Guld, han har i sit Hus, kan jeg ikke være ulydig mod HERREN og gøre noget som helst af egen Vilje; hvad HERREN siger, vil jeg sige! ");
INSERT INTO dan1931_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Vel, jeg drager til mit Folk, men kom, jeg vil lade dig vide, hvad dette Folk skal gøre ved dit Folk i de sidste Dage.” ");
INSERT INTO dan1931_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Derpå fremsatte han sit Sprog: Så siger Bileam, Beors Søn, så siger Manden, hvis Øje er lukket, ");
INSERT INTO dan1931_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","så siger han, der hører Guds Ord og kender den Højestes Viden, som skuer den Almægtiges Syner, hensunken, med opladt Øje: ");
INSERT INTO dan1931_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Jeg ser ham, dog ikke nu, jeg skuer ham, dog ikke nær! En Stjerne opgår af Jakob, et Herskerspir løfter sig fra Israel! Han knuser Moabs Tindinger og alle Setsønnernes* Isse. { *en ukendt Stamme. } ");
INSERT INTO dan1931_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom bliver et Lydland, og Se'irs undslupne går til Grunde, Israel udfolder sin Magt, ");
INSERT INTO dan1931_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","og Jakob kuer sine Fjender. ");
INSERT INTO dan1931_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Men da han så Amalekitterne, fremsatte han sit Sprog: Det første af Folkene er Amalek, men til sidst vies det til Undergang! ");
INSERT INTO dan1931_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Og da han så Kenitterne, fremsatte han sit Sprog: Urokkelig er din Bolig, din Rede bygget på Klippen. ");
INSERT INTO dan1931_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Kain er dog hjemfalden til Undergang! Hvor længe? Assur skal føre dig bort! ");
INSERT INTO dan1931_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Derpå fremsatte han sit Sprog: Ve! Hvo bliver i Live, når Gud lader det ske! ");
INSERT INTO dan1931_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Der kommer Skibe fra Kittæernes Kyst; de kuer Assur, de kuer Eber - men også han* er viet til Undergang! { *dvs. den Magt, der sender Skibene. } ");
INSERT INTO dan1931_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Så drog Bileam tilbage til sin Hjemstavn; og Balak gik også bort. ");
INSERT INTO dan1931_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israelitterne slog sig derpå ned i Sjittim. Men Folket begyndte at bedrive Hor med de moabitiske Kvinder; ");
INSERT INTO dan1931_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","og da de indbød Folket til deres Guders Slagtofre, spiste Folket deraf og tilbad deres Guder. ");
INSERT INTO dan1931_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Og Israel holdt til med Ba'al-Peor; derover blussede HERRENS Vrede op mod Israel, ");
INSERT INTO dan1931_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","og HERREN sagde til Moses: “Kald alle Folkets Overhoveder sammen og hæng dem op for HERREN under åben Himmel, for at HERRENS Vrede må vige fra Israel!” ");
INSERT INTO dan1931_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Og Moses sagde til Israelitternes Dommere: “Enhver af eder skal slå dem af sine Mænd ihjel, der har holdt til med Ba'al Peor!” ");
INSERT INTO dan1931_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Og se, en af Israelitterne kom og førte en midjanitisk Kvinde hen til sine Landsmænd lige for Øjnene af Moses og hele Israelitternes Menighed, medens de stod og græd ved Indgangen til Åbenbaringsteltet. ");
INSERT INTO dan1931_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Da nu Pinehas, Præsten Arons Søn Eleazars Søn, så det, trådte han frem af Menighedens Midte, greb et Spyd, ");
INSERT INTO dan1931_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","fulgte den israelitiske Mand ind i Sengekammeret og gennemborede dem begge, både den israelitiske Mand og Kvinden, hende gennem Underlivet. Da standsede Plagen blandt Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Men Tallet på dem, Plagen havde kostet Livet, løb op til 24.000. ");
INSERT INTO dan1931_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Da talede HERREN således til Moses: ");
INSERT INTO dan1931_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Pinehas, Præsten Arons Søn Eleazars Søn, har vendt min Vrede fra Israelitterne, idet han var nidkær iblandt dem med min Nidkærhed, så at jeg ikke tilintetgjorde Israelitterne i min Nidkærhed. ");
INSERT INTO dan1931_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Derfor skal du sige: Se, jeg giver ham min Fredspagt! ");
INSERT INTO dan1931_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Et evigt Præstedømmes Pagt skal blive hans og efter ham hans Efterkommeres Lod, til Løn for at han var nidkær for sin Gud og skaffede Israelitterne Soning.” ");
INSERT INTO dan1931_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Den dræbte Israelit, han, der dræbtes sammen med den midjanitiske kvinde, hed Zimri, Salus Søn, og var Øverste for et Fædrenehus blandt Simeonitterne; ");
INSERT INTO dan1931_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","og den dræbte midjanitiske Kvinde hed Kozbi og var en Datter af Zur, der var Stammehøvding for et Fædrenehus blandt Midjanitterne, ");
INSERT INTO dan1931_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Fald over Midjanitterne og slå dem; ");
INSERT INTO dan1931_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","thi de faldt over eder med de Rænker, de spandt imod eder i den Sag med Peor og med Kozbi, den midjanitiske Høvdings Datter, deres Landsmandinde, der dræbtes, den Dag Plagen brød løs for Peors Skyld.” ");
INSERT INTO dan1931_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Efter denne Plage talede HERREN til Moses og Eleazar, Præsten Arons Søn, og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Hold Mandtal over hele Israelitternes Menighed fra Tyveårsalderen og opefter, Fædrenehus for Fædrenehus, alle våbenføre Mænd i Israel!” ");
INSERT INTO dan1931_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Da mønstrede Moses og Præsten Eleazar dem på Moabs Sletter ved Jordan over for Jeriko ");
INSERT INTO dan1931_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","fra Tyveårsalderen og opefter, som HERREN havde pålagt Moses. Og Israelitterne, som var udvandret fra Ægypten, var følgende: ");
INSERT INTO dan1931_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, Israels førstefødte; Rubens Sønner: Fra Hanok stammer Hanokitternes Slægt, fra Pallu Palluitternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","fra Hezron Hezronitternes Slægt og fra Karmi Karmitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Det var Rubenitternes Slægter, og de af dem, som mønstredes, udgjorde 43.730. ");
INSERT INTO dan1931_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallus Søn var Eliab; ");
INSERT INTO dan1931_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliabs Sønner: Nemuel, Datan og Abiram; det var den Datan og den Abiram, Menighedens udvalgte, som satte sig op imod Moses og Aron sammen med Koras Tilhængere, da de satte sig op imod HERREN; ");
INSERT INTO dan1931_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","og Jorden åbnede sit Gab og slugte dem sammen med Kora, da hans Tilhængere omkom, idet Ilden fortærede de 250 Mænd, og de blev et Tegn til Advarsel. ");
INSERT INTO dan1931_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Men Koras Sønner omkom ikke. ");
INSERT INTO dan1931_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeons Sønners Slægter var følgende: Fra Nemuel stammer Nemuelitternes Slægt, fra Jamin Jaminitternes Slægt, fra Jakin Jakinitternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","fra Zera Zeraitternes Slægt og fra Sja'ul Sja'ulitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Det var Simeonitternes Slægter, 22.200. ");
INSERT INTO dan1931_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gads Sønners Slægter var følgende: Fra Zefon stammer Zefonitternes Slægt, fra Haggi Haggitternes Slægt, fra Sjuni Sjunitternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","fra Ozni Oznitternes Slægt, fra Eri Eritternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","fra Arod Aroditternes Slægt og fra Ar'eli Ar'elitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Det var Gads Sønners Slægter, de af dem, som mønstredes, 40.500. ");
INSERT INTO dan1931_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Judas Sønner var Er og Onan. men Er og Onan døde i Kana'ans Land. ");
INSERT INTO dan1931_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Judas Sønners Slægter var følgende: Fra Sjela stammer Sjelanitternes Slægt, fra Perez Perezitternes Slægt og fra Zera Zeraitternes Slægt; ");
INSERT INTO dan1931_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Perez' Sønner: Fra Hezron stammer Hezronitternes Slægt og fra Hamul Hamulitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Det var Judas Slægter, de af dem, som mønstredes, 76.500. ");
INSERT INTO dan1931_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Issakars Sønners Slægter var følgende: Fra Tola stammer Tolaitternes Slægt, fra Pua Punitternes Slægt; ");
INSERT INTO dan1931_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","fra Jasjub Jasjubitternes Slægt og fra Sjimron Sjimronitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Det var Issakars Slægter, de af dem, som mønstredes, 64.300. ");
INSERT INTO dan1931_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zebulons Sønners Slægter var følgende: Fra Sered stammer Sereditternes Slægt, fra Elon Elonitternes Slægt og fra Jale'el Jale'elitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Det var Zebulonitternes Slægter, de af dem, som mønstredes, 60.500. ");
INSERT INTO dan1931_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Josefs Sønners Slægter var følgende: Manasse og Efraim; ");
INSERT INTO dan1931_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasses Sønner: Fra Makir stammer Makiritternes Slægt; Makir avlede Gilead, fra Gilead stammer Gileaditternes Slægt; ");
INSERT INTO dan1931_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gileads Sønner var følgende: Fra Abiezer stammer Abiezritternes Slægt, fra Helek Helekitternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","fra Asriel Asrielitternes Slægt, fra Sjekem Sjekemitternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","fra Sjemida Sjemidaitternes Slægt og fra Hefer Heferitternes Slægt; ");
INSERT INTO dan1931_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","men Zelofhad, Hefers Søn, havde ingen Sønner, kun Døtre; Zelofhads Døtre hed Mala, Noa, Hogla, Milka og Tirza. ");
INSERT INTO dan1931_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Det var Manasses Slægter, og de af dem, som mønstredes, udgjorde 52.700. ");
INSERT INTO dan1931_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efraims Sønners Slægter var følgende: Fra Sjutela stammer Sjutelaitternes Slægt, fra Beker Bekeritternes Slægt og fra Tahan Tahanitternes Slægt; ");
INSERT INTO dan1931_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sjultelas Sønner var følgende: Fra Eran stammer Eranitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Det var Efraimitternes Slægter, de af dem, som mønstredes, 32.500. Det var Josefs Sønners Slægter. ");
INSERT INTO dan1931_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Benjamins Sønners Slægter var følgende: Fra Bela stammer Belaitternes Slægt, fra Asjbel Asjbelitternes Slægt, fra Ahiram Ahiramitternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","fra Sjufam Sjufamitternes Slægt og fra Hufam Hufamitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belas Sønner: Ard og Na'aman; fra Ard stammer Arditternes Slægt, fra Na'aman Na'amitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Det var Benjamins Sønners Slægter, og de af dem, som mønstredes, udgjorde 45.600. ");
INSERT INTO dan1931_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dans Sønners Slægter var følgende: Fra Sjuham stammer. Sjuhamitternes Slægt. Det var Dans Slægter, Slægt for Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Alle Sjuhamitternes Slægter, de af dem, som mønstredes, udgjorde 64.400. ");
INSERT INTO dan1931_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asers Sønners Slægter var følgende: Fra Jimna stammer Jimnitternes Slægt, fra Jisjvi Jisjvitternes Slægt og fra Beri'a Beri'aitternes Slægt; ");
INSERT INTO dan1931_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","fra Beri'as Sønner: Fra Heber stammer Hebritternes Slægt og fra Malkiel Malkielitternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asers Datter hed Sera. ");
INSERT INTO dan1931_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Det var Asers Sønners Slægter, og de af dem, som mønstredes, udgjorde 53.400. ");
INSERT INTO dan1931_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naftalis Sønners Slægter var følgende: Fra Jaze'el stammer Jaze'elitternes Slægt, fra Guni Gunitternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","fra Jezer Jezeritternes Slægt og fra Sjillem Sjillemitternes Slægt, ");
INSERT INTO dan1931_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Det var Naftalis Slægter, Slægt for Slægt, og de af dem, som mønstredes, udgjorde 45.400. ");
INSERT INTO dan1931_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Det var dem af Israelitterne, som mønstredes, 601.730. ");
INSERT INTO dan1931_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Til dem skal Landet udskiftes til Arv og Eje efter de optalte Navne. ");
INSERT INTO dan1931_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","En stor Stamme skal du give en stor Arvelod, en lille Stamme en lille; enhver af dem skal der gives en Arvelod efter Tallet på de mønstrede i den. ");
INSERT INTO dan1931_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Dog skal Landet udskiftes ved Lodkastning; de skal have deres Arvelodder efter Navnene på deres fædrene Stammer; ");
INSERT INTO dan1931_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ved Lodkastning skal enhver Stamme, stor eller lille, have sin Arvelod tildelt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Følgende er de af Levitterne, der mønstredes, Slægt for Slægt: Fra Gerson stammer Gersonitternes Slægt, fra Kehat Kehatitternes Slægt og fra Merari Meraritternes Slægt. ");
INSERT INTO dan1931_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Følgende er Levis Slægter: Libnitternes Slægt, Hebronitternes Slægt, Malitternes Slægt, Musjitternes Slægt og Koraitternes Slægt. Kehat avlede Amram. ");
INSERT INTO dan1931_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amrams Hustru hed Jokebed, Levis Datter, som fødtes Levi i Ægypten; hun fødte for Amram Aron, Moses og deres Søster Mirjam. ");
INSERT INTO dan1931_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","For Aron fødtes Nadab, Abihu, Eleazar og Itamar. ");
INSERT INTO dan1931_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Men Nadab og Abihu omkom, da de frembar fremmed Ild for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","De af dem, der mønstredes, udgjorde 23.000, alle af Mandkøn fra en Måned og opefter. De mønstredes nemlig ikke sammen med de andre Israelitter, da der ikke var givet dem nogen Arvelod blandt Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Det var dem, der mønstredes af Moses og Præsten Eleazar, da disse mønstrede Israelitterne på Moabs Sletter ved Jordan over for Jeriko. ");
INSERT INTO dan1931_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Blandt dem var der ingen, som var mønstret af Moses og Præsten Aron, da de mønstrede Israelitterne i Sinaj Ørken; ");
INSERT INTO dan1931_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","thi HERREN havde sagt til dem, at de skulde dø i Ørkenen. Derfor var der ingen tilbage af dem undtagen Kaleb, Jefunnes Søn, og Josua, Nuns Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Men Zelofhads Døtre, hvis Fader var en Søn af Hefer, en Søn af Gilead, en Søn af Makir, en Søn af Manasse - de hørte altså til Josefs Søn Manasses Slægter, og deres Navne var Mala, Noa, Hogla, Milka og Tirza - trådte hen ");
INSERT INTO dan1931_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","og stillede sig frem for Moses, Præsten Eleazar, Øversterne og hele Menigheden ved Indgangen til Åbenbaringsteltet og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Vor Fader døde i Ørkenen - han hørte ikke med til Koras Tilhængere, dem, der rottede sig sammen mod HERREN, men døde for sin egen Synds Skyld - og han havde ingen Sønner. ");
INSERT INTO dan1931_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Hvorfor skal nu vor Faders Navn udslettes af hans Slægt, fordi han ingen Søn havde? Giv os Ejendom blandt vor Faders Brødre!” ");
INSERT INTO dan1931_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Og Moses lagde deres Sag frem for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Da talede HERREN således til Moses: ");
INSERT INTO dan1931_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Zelofhads Døtre har Ret i, hvad de siger; giv dem Ejendom til Arvelod mellem deres Faders Brødre og lad deres Faders Arvelod tilfalde dem. ");
INSERT INTO dan1931_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Og til Israelitterne skal du tale og sige således: Når en Mand dør uden at efterlade sig nogen Søn, da skal I lade hans Arvelod gå i Arv til hans Datter; ");
INSERT INTO dan1931_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","har han heller ingen Datter, skal I give hans Arvelod til hans Brødre; ");
INSERT INTO dan1931_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","har han heller ingen Brødre, skal I give hans Arvelod til hans Farbrødre; ");
INSERT INTO dan1931_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","og har hans Fader ingen Brødre, skal I give hans Arvelod til hans nærmeste kødelige Slægtning, som så skal arve den. Det skal være Israelitterne en retsgyldig Anordning, som HERREN har pålagt Moses.” ");
INSERT INTO dan1931_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Og HERREN sagde til Moses: “Stig op på Abarimbjerget her og se ud over Landet, som jeg vil give Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Og når du har set ud over det, skal også du samles til din Slægt ligesom din Broder Aron; ");
INSERT INTO dan1931_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","I var jo genstridige mod mit Ord i Zins Ørken, dengang Menigheden yppede Kiv, så at I ikke helligede mig i deres Påsyn ved at skaffe Vand.” Det er Meriba-Kadesjs Vand i Zins Ørken. ");
INSERT INTO dan1931_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Og Moses talte således til HERREN: ");
INSERT INTO dan1931_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Måtte HERREN, Gud over alt Køds Ånder, indsætte en Mand over Menigheden, ");
INSERT INTO dan1931_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","som kan drage ud og hjem i Spidsen for dem og føre dem ud og hjem, for at ikke HERRENS Menighed skal blive som en Hjord uden Hyrde!” ");
INSERT INTO dan1931_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Da sagde HERREN til Moses: “Tag Josua, Nuns Søn, en Mand, i hvem der er Ånd, læg din Hånd på ham, ");
INSERT INTO dan1931_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","fremstil ham for Præsten Eleazar og hele Menigheden og indsæt ham således i deres Påsyn; ");
INSERT INTO dan1931_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","og overdrag ham noget af din Værdighed, for at hele Israelitternes Menighed kan adlyde ham. ");
INSERT INTO dan1931_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Men han skal træde frem for Præsten Eleazar, for at han kan skaffe ham Urims Kendelse for HERRENS Åsyn; på hans Bud skal han drage ud, og på hans Bud skal han vende hjem, han og alle Israelitterne, hele Menigheden.” ");
INSERT INTO dan1931_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moses gjorde som HERREN havde pålagt ham; han tog Josua og fremstillede ham for Præsten Eleazar og hele Menigheden; ");
INSERT INTO dan1931_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","og han lagde sine Hænder på ham og indsatte ham, således som HERREN havde påbudt ved Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Byd Israelitterne og sig til dem: I skal omhyggeligt bringe mig mine Offergaver, min Ildofferspise til en liflig Duft, til de fastsatte Tider! ");
INSERT INTO dan1931_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Og sig til dem: Dette er det Ildoffer, I skal bringe HERREN: Hver Dag to årgamle, lydefri Lam som dagligt Brændoffer; ");
INSERT INTO dan1931_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","det ene Lam skal du ofre om Morgenen, det andet ved Aftenstid; ");
INSERT INTO dan1931_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","og som Afgrødeoffer dertil en Tiendedel Efa fint Hvedemel, rørt i en Fjerdedel Hin Olie af knuste Frugter - ");
INSERT INTO dan1931_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","det er det daglige Brændoffer, som ofredes ved Sinaj Bjerg til en liflig Duft, et Ildoffer for HERREN - ");
INSERT INTO dan1931_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","fremdeles som Drikoffer dertil en Fjerdedel Hin Vin for hvert Lam; i Helligdommen skal der udgydes Drikoffer af stærk Drik for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Det andet Lam skal du ofre ved Aftenstid; med samme Afgrødeoffer og Drikoffer som om Morgenen skal du ofre det, et Ildoffer til en liflig Duft for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","På Sabbatsdagen skal det være to årgamle, lydefri Lam og som Afgrødeoffer to Tiendedele Efa fint Hvedemel, rørt i Olie, med tilhørende Drikoffer, ");
INSERT INTO dan1931_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","et Sabbatsbrændoffer på hver Sabbat foruden det daglige Brændoffer med tilhørende Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","På den første Dag i hver Måned skal I som Brændoffer bringe HERREN to unge Tyre, en Vædder og syv årgamle Lam, lydefri Dyr, ");
INSERT INTO dan1931_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","og som Afgrødeoffer dertil for hver Tyr tre Tiendedele Efa fint Hvedemel, rørt i Olie, som Afgrødeoffer for hver Vædder to Tiendedele Efa fint Hvedemel, rørt i Olie, ");
INSERT INTO dan1931_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","og som Afgrødeoffer for hvert Lam en Tiendedel Efa fint Hvedemel, rørt i Olie, et Brændoffer til en liflig Duft, et Ildoffer for HERREN; ");
INSERT INTO dan1931_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","desuden de tilhørende Drikofre, en halv Hin Vin for hver Tyr, en Tredjedel Hin for hver Vædder og en Fjerdedel Hin for hvert Lam. Det er det månedlige Brændoffer for hver af Årets Måneder. ");
INSERT INTO dan1931_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Tillige skal der foruden det daglige Brændoffer ofres HERREN en Gedebuk som Syndoffer med tilhørende Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","På den fjortende Dag i den første Måned skal der være Påske for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Den femtende Dag i den Måned er det Højtid; i syv Dage skal der spises usyrede Brød. ");
INSERT INTO dan1931_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","På den første Dag skal der være Højtidsstævne, intet som helst Arbejde må I udføre. ");
INSERT INTO dan1931_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Da skal I bringe som Ildoffer, som Brændoffer for HERREN, to unge Tyre, en Vædder og syv årgamle Lam, lydefri Dyr skal I tage ");
INSERT INTO dan1931_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","og som Afgrødeoffer dertil fint Hvedemel rørt i Olie; tre Tiendedele Efa skal I ofre for hver Tyr, to Tiendedele for hver Vædder ");
INSERT INTO dan1931_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","og en Tiendedel for hvert af de syv Lam; ");
INSERT INTO dan1931_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","desuden en Buk som Syndoffer for at skaffe eder Soning. ");
INSERT INTO dan1931_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Foruden Morgen brændofferet, det daglige Brændoffer, skal I ofre det. ");
INSERT INTO dan1931_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Sådanne Ofre skal I bringe hver af de syv Dage som Ildofferspise til en liflig Duft for HERREN; de skal ofres med tilhørende Drikoffer foruden det daglige Brændoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","På den syvende Dag skal I holde Højtidsstævne; intet som helst Arbejde må I udføre. ");
INSERT INTO dan1931_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","På Førstegrødens Dag, når I bringer HERREN Afgrødeoffer af den ny Afgrøde på eders Ugefest, skal I holde Højtidsstævne; intet som helst Arbejde må I udføre. ");
INSERT INTO dan1931_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Da skal I som Brændoffer til en liflig Duft for HERREN ofre to unge Tyre, en Vædder og syv årgamle Lam ");
INSERT INTO dan1931_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","og som Afgrødeoffer dertil fint Hvedemel, rørt i Olie, tre Tiendedele Efa for hver Tyr, to Tiendedele for hver Vædder ");
INSERT INTO dan1931_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","og en Tiendedel for hvert af de syv Lam; ");
INSERT INTO dan1931_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","desuden en Gedebuk for at skaffe eder Soning. ");
INSERT INTO dan1931_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Foruden det daglige Brændoffer med tilhørende Afgrødeoffer skal I ofre det, lydefri Dyr skal I tage, med tilhørende Drikofre. ");
INSERT INTO dan1931_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","På den første Dag i den syvende Måned skal I holde Højtidsstævne, intet som helst Arbejde må I udføre; I skal fejre den som en Hornblæsningsdag. ");
INSERT INTO dan1931_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Da skal I som Brændoffer til en liflig Duft for HERREN ofre en ung Tyr, en Vædder og syv årgamle Lam, lydefri Dyr; ");
INSERT INTO dan1931_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","som Afgrødeoffer dertil fint Hvedemel, rørt i Olie, tre Tiendedele Efa for Tyren, to Tiendedele for Vædderen ");
INSERT INTO dan1931_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","og en Tiendedel for hvert af de syv Lam; ");
INSERT INTO dan1931_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","desuden en Gedebuk som Syndoffer for at skaffe eder Soning; ");
INSERT INTO dan1931_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","alt foruden Nymånebrændofferet med tilhørende Afgrødeoffer og det daglige Brændoffer med tilhørende Afgrødeoffer og Drikofre efter de derom gældende forskrifter, til en liflig Duft, et Ildoffer for HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","På den tiende dag i samme syvende Måned skal I holde Højtidsstævne, I skal faste og må intet som helst Arbejde udføre. ");
INSERT INTO dan1931_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Da skal I som Brændoffer til en liflig duft for HERREN ofre en ung Tyr, en Vædder og syv årgamle Lam, lydefri Dyr skal I tage, ");
INSERT INTO dan1931_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","og som Afgrødeoffer dertil fint Hvedemel, rørt i Olie, tre Tiendedele Efa for Tyren, to Tiendedele for Vædderen ");
INSERT INTO dan1931_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","og en Tiendedel for hvert af de syv Lam; ");
INSERT INTO dan1931_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","desuden en Gedebuk som Syndoffer; alt foruden Soningssyndoffer, det og det daglige Brændoffer med tilhørende Afgrødeoffer og Drikofre. ");
INSERT INTO dan1931_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","På den femtende Dag i den syvende Måned skal I holde Højtidsstævne, I må intet som helst Arbejde udføre, og I skal holde Højtid for HERREN i syv Dage. ");
INSERT INTO dan1931_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Da skal I som Brændoffer, som Ildoffer til en liflig Duft for HERREN ofre tretten unge Tyre, to Vædre og fjorten årgamle Lam, lydefri Dyr skal det være, ");
INSERT INTO dan1931_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","og som Afgrødeoffer dertil fint Hvedemel, rørt i Olie, tre Tiendedele Efa for hver af de tretten Tyre, to Tiendedele for hver af de to Vædre ");
INSERT INTO dan1931_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","og en Tiendedel for hvert af de fjorten Lam; ");
INSERT INTO dan1931_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","desuden en Gedebuk som Syndoffer; alt foruden det daglige Brændoffer med tilhørende Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","På den anden Dag skal I ofre tolv unge Tyre, to Væddere og fjorten årgamle Lam, lydefri Dyr, ");
INSERT INTO dan1931_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","med tilhørende Afgrødeoffer og Drikofre for Tyrene, Vædderne og Lammene efter deres Tal på den foreskrevne Måde; ");
INSERT INTO dan1931_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","desuden en Gedebuk som Syndoffer; alt foruden det daglige Brændoffer med tilhørende Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","På den tredje Dag skal I ofre elleve unge Tyre, to Væddere og fjorten årgamle Lam, lydefri Dyr, ");
INSERT INTO dan1931_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","med tilhørende Afgrødeoffer og Drikofre for Tyrene, Vædderne og Lammene efter deres Tal på den foreskrevne Måde; ");
INSERT INTO dan1931_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","desuden en Gedebuk som Syndoffer; alt foruden det daglige Brændoffer med tilhørende Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","På den fjerde Dag skal I ofre ti Tyre, to Vædre og fjorten årgamle Lam, lydefri Dyr, ");
INSERT INTO dan1931_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","med tilhørende Afgrødeoffer og Drikofre for Tyrene, Vædderne og Lammene efter deres Tal på den foreskrevne Måde; ");
INSERT INTO dan1931_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","desuden en Gedebuk som Syndoffer; alt foruden det daglige Brændoffer med tilhørende Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","På den femte Dag skal I ofre ni Tyre, to Vædre og fjorten årgamle Lam, lydefri Dyr, ");
INSERT INTO dan1931_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","med tilhørende Afgrødeoffer og Drikofre for Tyrene, Vædderne og Lammene efter deres Tal på den foreskrevne Måde; ");
INSERT INTO dan1931_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","desuden en Gedebuk som Syndoffer; alt foruden det daglige Brændoffer med tilhørende Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","På den sjette Dag skal I ofre otte Tyre, to Væddere og fjorten årgamle Lam, lydefri Dyr, ");
INSERT INTO dan1931_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","med tilhørende Afgrødeoffer og Drikofre for Tyrene, Vædderne og Lammene efter deres Tal på den foreskrevne Måde; ");
INSERT INTO dan1931_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","desuden en Gedebuk til Syndoffer; alt foruden det daglige Brændoffer med tilhørende Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","På den syvende dag skal I ofre syv Tyre, to Vædre og fjorten årgamle Lam, lydefri Dyr, ");
INSERT INTO dan1931_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","med tilhørende Afgrødeoffer og Drikofre for Tyrene, Vædderne og Lammene efter deres Tal på den foreskrevne Måde; ");
INSERT INTO dan1931_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","desuden en Gedebuk som Syndoffer; alt foruden det daglige Brændoffer med tilhørende Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","På den ottende Dag skal I holde festlig Samling, I må intet som helst Arbejde udføre. ");
INSERT INTO dan1931_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Da skal I som Brændoffer, som Ildoffer til en liflig Duft for HERREN ofre en Tyr, en Vædder og syv årgamle Lam, lydefri Dyr, ");
INSERT INTO dan1931_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","med tilhørende Afgrødeoffer og Drikofre for Tyren, Vædderen og Lammene efter deres Tal på den foreskrevne Måde; ");
INSERT INTO dan1931_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","desuden en Gedebuk som Syndoffer; alt foruden det daglige Brændoffer med tilhørende Afgrødeoffer og Drikoffer. ");
INSERT INTO dan1931_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Disse Ofre skal I bringe HERREN på eders Højtider, bortset fra eders Løfte og Frivilligofre, hvad enten det nu er Brændofre, Afgrødeofre, Drikofre eller Takofre. ");
INSERT INTO dan1931_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Og Moses talte til Israelitterne, ganske som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Moses talte fremdeles til Overhovederne for Israelitternes Stammer og sagde: Dette er, hvad HERREN har påbudt: ");
INSERT INTO dan1931_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Når en Mand aflægger et Løfte til HERREN eller ved Ed forpligter sig til Afholdenhed i en eller anden Retning, må han ikke bryde sit Ord, men skal holde hvert Ord, der er udgået af hans Mund. ");
INSERT INTO dan1931_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Men når en Kvinde aflægger et Løfte til HERREN og forpligter sig til Afholdenhed i en eller anden Retning, medens hun endnu i sine unge År opholder sig i sin Faders Hus. ");
INSERT INTO dan1931_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","og hendes Fader, når han hører om hendes Løfte og den Forpligtelse til Afholdenhed, hun har påtaget sig, ikke siger noget til hende, så skal alle hendes Løfter stå ved Magt, og enhver Forpligtelse til Afholdenhed, hun har påtaget sig, skal stå ved Magt. ");
INSERT INTO dan1931_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Hvis hendes Fader derimod formener hende det, samme Dag han får det at høre, skal ingen af hendes Løfter eller af de Forpligtelser til Afholdenhed, hun har påtaget sig, stå ved Magt, og HERREN skal tilgive hende, fordi hendes Fader har forment hende det. ");
INSERT INTO dan1931_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Hvis hun bliver gift medens der påhviler hende Løfter eller en Forpligtelse, hun har påtaget sig ved et uoverlagt Ord, ");
INSERT INTO dan1931_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","og hendes Mand ikke siger noget til hende, samme Dag han får det at høre, skal hendes Løfter stå ved Magt, og den Forpligtelse til Afholdenhed, hun har påtaget sig, skal stå ved Magt. ");
INSERT INTO dan1931_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Hvis hendes Mand derimod formener hende det, samme Dag han får det at høre, gør han dermed det Løfte, der påhviler hende, og den Forpligtelse til Afholdenhed, hun har påtaget sig ved et uoverlagt Ord, ugyldig, og HERREN skal tilgive hende. ");
INSERT INTO dan1931_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","En Enkes og en forstødt Hustrus Løfte, enhver Forpligtelse til Afholdenhed, hun har påtaget sig, er bindende for hende. ");
INSERT INTO dan1931_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Hvis en Kvinde i sin Mands Hus aflægger et Løfte eller ved Ed forpligter sig til Afholdenhed i en eller anden Retning, ");
INSERT INTO dan1931_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","og hendes Mand, når han får det at høre, ikke siger noget til hende og ikke formener hende det, skal alle hendes Løfter stå ved Magt, og enhver Forpligtelse til Afholdenhed, hun har påtaget sig, skal stå ved Magt. ");
INSERT INTO dan1931_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Hvis hendes Mand derimod, samme Dag han får det at høre, gør det ugyldigt, så står intet af det, hun har udtalt, ved Magt, hverken hendes Løfter eller den påtagne Forpligtelse til Afholdenhed; hendes Mand har gjort dem ugyldige, og HERREN skal tilgive hende. ");
INSERT INTO dan1931_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ethvert Løfte og enhver ved Ed påtagen Forpligtelse til Faste kan hendes Mand stadfæste eller gøre ugyldig. ");
INSERT INTO dan1931_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Men hvis hendes Mand tier stille over for hende til næste Dag, stadfæster han alle hendes Løfter og alle de Forpligtelser til Afholdenhed, hun har påtaget sig; han har stadfæstet dem, thi han sagde ikke noget til hende, samme Dag han fik det at høre; ");
INSERT INTO dan1931_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","og hvis han vil gøre dem ugyldige, en Tid efter at han fik det at høre, skal han undgælde for hendes Brøde. ");
INSERT INTO dan1931_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Det er de Anordninger, HERREN gav Moses om Forholdet mellem Mand og Hustru og mellem Fader og Datter, medens hun endnu i sine unge År opholder sig i hans Hus. ");
INSERT INTO dan1931_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Skaf Israelitterne Hævn over Midjanitterne; så skal du samles til din Slægt!” ");
INSERT INTO dan1931_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Da talte Moses til Folket og sagde: “Udrust Mænd af eders Midte til Kamp, for at de kan falde over Midjan og fuldbyrde HERRENS Hævn på Midjan; ");
INSERT INTO dan1931_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","1.000 Mand af hver af Israels Stammer skal I sende i Kamp!” ");
INSERT INTO dan1931_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Af Israels Tusinder udtoges da 1.000 af hver Stamme, i alt 12.000 Mand, rustede til Kamp. ");
INSERT INTO dan1931_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Og Moses sendte dem i kamp, 1.000 af hver Stamme, og sammen med dem Pinehas, Præsten Eleazars Søn, der medbragte de hellige Redskaber og Alarmtrompeterne. ");
INSERT INTO dan1931_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","De drog så ud i kamp mod Midjanitterne, som HERREN havde pålagt Moses, og dræbte alle af Mandkøn; ");
INSERT INTO dan1931_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","og foruden de andre, der blev slået ihjel, dræbte de også Midjans Konger, Evi, Rekem, Zur, Hur og Reba, Midjans fem Konger; også Bileam, Beors Søn, dræbte de med Sværdet. ");
INSERT INTO dan1931_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Og Israelitterne bortførte Midjanitternes kvinder og Børn som Krigsfanger, og alt deres Kvæg alle deres Hjorde og alt deres Gods tog de med som Bytte; ");
INSERT INTO dan1931_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","og alle deres Byer på de beboede Steder og alle deres Teltlejre stak de Ild på. ");
INSERT INTO dan1931_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Og alt det røvede og hele Byttet, både Mennesker og Dyr, tog de med sig, ");
INSERT INTO dan1931_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","og de bragte Fangerne, Byttet og det røvede til Moses og Præsten Eleazar og Israelitternes Menighed i Lejren på Moabs Sletter ved Jordan over for Jeriko. ");
INSERT INTO dan1931_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Men Moses, Præsten Eleazar og alle Menighedens Øverste gik dem i Møde uden for Lejren, ");
INSERT INTO dan1931_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","og Moses blev vred på Hærens Førere, Tusindførerne og Hundredførerne, som kom tilbage fra Krigstoget. ");
INSERT INTO dan1931_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Og Moses sagde til dem: “Har I ladet alle Kvinder i Live? ");
INSERT INTO dan1931_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Det var jo dem, der efter Bileams Råd blev Årsag til, at Israelitterne var troløse mod HERREN i den Sag med Peor, så at Plagen ramte HERRENS Menighed. ");
INSERT INTO dan1931_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Dræb derfor alle Drengebørn og alle kvinder, der har kendt Mand og haft Samleje med Mænd; ");
INSERT INTO dan1931_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","men alle Piger, der ikke har haft Samleje med Mænd, skal I lade i Live og beholde, ");
INSERT INTO dan1931_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Men selv skal I lejre eder uden for Lejren i syv Dage, enhver, som har dræbt nogen, og enhver, som har rørt ved en dræbt, og rense eder på den tredje og den syvende Dag, både I selv og eders Krigsfanger. ");
INSERT INTO dan1931_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Og enhver Klædning, enhver Læder ting, alt, hvad der er lavet af Gedehår, og alle Træredskaber skal I rense!” ");
INSERT INTO dan1931_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Og Præsten Eleazar sagde til Krigerne, der havde været med i Kampen: “Dette er det Lovbud, HERREN har givet Moses: ");
INSERT INTO dan1931_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Kun Guld, Sølv, kobber, Jern, Tin og Bly, ");
INSERT INTO dan1931_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","alt, hvad der kan tåle Ild, skal I lade gå gennem Ild, så bliver det rent; dog må det renses med Renselsesvand. Men alt, hvad der ikke kan tåle Ild, skal I lade gå gennem Vand. ");
INSERT INTO dan1931_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Og eders klæder skal I tvætte på den syvende Dag, så bliver I rene og kan gå ind i Lejren.” ");
INSERT INTO dan1931_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Sammen med Præsten Eleazar og Overhovederne for Menighedens Fædrenehuse skal du opgøre det samlede Bytte, der er taget, både Mennesker og Dyr. ");
INSERT INTO dan1931_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Derefter skal du dele Byttet i to lige store Dele mellem dem, der har taget Del i Krigen og været i Kamp, og hele den øvrige Menighed. ");
INSERT INTO dan1931_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Derpå skal du udtage en Afgift til HERREN fra krigerne, der har været i Kamp, et Stykke af hver fem Hundrede, både af Mennesker, Hornkvæg, Æsler og Småkvæg; ");
INSERT INTO dan1931_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","det skal du tage af den Halvdel, som tilfalder dem, og give Præsten Eleazar det som Offerydelse til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Men af den Halvdel, der tilfalder de andre Israelitter, skal du tage et Stykke af hver halvtredsindstyve, både af Mennesker, Hornkvæg, Æsler og Småkvæg, alt Kvæget, og give det til Levitterne, som tager Vare på, hvad der er at varetage ved HERRENS Bolig!” ");
INSERT INTO dan1931_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Da gjorde Moses og Præsten Eleazar, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Og det, de havde taget, det tiloversblevne af Byttet, som Krigsfolket havde gjort, udgjorde 675.000 Stykker Småkvæg, ");
INSERT INTO dan1931_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72.000 Stykker Hornkvæg, ");
INSERT INTO dan1931_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61.000 Æsler ");
INSERT INTO dan1931_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","og 32.000 Mennesker, Kvinder, der ikke havde haft Samleje med Mænd. ");
INSERT INTO dan1931_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Den Halvdel, der tilfaldt dem, der havde været i Kamp, udgjorde altså et Tal af 337.500 Stykker Småkvæg, ");
INSERT INTO dan1931_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","hvoraf Afgiften til HERREN udgjorde 675 Stykker Småkvæg, ");
INSERT INTO dan1931_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36.000 Stykker Hornkvæg, hvoraf 72 i Afgift til HERREN, ");
INSERT INTO dan1931_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30.500 Æsler, hvoraf til i Afgift til HERREN, ");
INSERT INTO dan1931_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","og 16.000 Mennesker, hvoraf 32 i Afgift til HERREN. ");
INSERT INTO dan1931_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Og Moses overgav Afgiften, HERRENS Offerydelse, til Præsten Eleazar, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Og af den Halvdel, som tilfaldt de andre Israelitter, og som Moses havde taget som deres del fra de Mænd, der havde været i Kamp - ");
INSERT INTO dan1931_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","denne Menighedens Halvdel udgjorde 337.500 Stykker Småkvæg, ");
INSERT INTO dan1931_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36.000 Stykker Hornkvæg, ");
INSERT INTO dan1931_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30.500 Æsler ");
INSERT INTO dan1931_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","og 16.000 Mennesker - ");
INSERT INTO dan1931_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","af den Halvdel, som tilfaldt de andre Israelitter, udtog Moses et Stykke for hver halvtredsindstyve, både af Mennesker og Kvæg, og gav dem til Levitterne, som tog Vare på, hvad der var at varetage ved HERRENS Bolig, som HERREN havde pålagt Moses. ");
INSERT INTO dan1931_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Da trådte Førerne for Hærens Afdelinger, Tusindførerne og Hundredførerne, hen til Moses ");
INSERT INTO dan1931_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","og sagde til ham: “Dine Trælle har holdt Mandtal over de krigere, der stod under os; og der manglede ikke en eneste af os; ");
INSERT INTO dan1931_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","derfor frembærer nu enhver af os som Offergave til HERREN, hvad han har taget af Guldsmykker, Armbånd, Spange, Fingerringe, Ørenringe og Halssmykker, for at skaffe os Soning for HERRENS Åsyn.” ");
INSERT INTO dan1931_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moses og Præsten Eleazar modtog Guldet af dem, alskens med Kunst virkede Smykker; ");
INSERT INTO dan1931_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","og alt Offerydelsesguldet, som de ydede HERREN, udgjorde 16.750 Sekel, hvilket Tusindførerne og Hundredførerne bragte som Gave. ");
INSERT INTO dan1931_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Krigerne havde taget Bytte hver for sig. ");
INSERT INTO dan1931_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Så modtog Moses og Præsten Eleazar Guldet af Tusindførerne og Hundredførerne og bragte det ind i Åbenbaringsteltet, for at det skulde bringe Israelitterne i Minde for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rubenitterne og Gaditterne havde meget Kvæg i store mængder. Da de nu så Ja'zers Land og Gileads Land, fandt de, at Stedet egnede sig til Kvægavl. ");
INSERT INTO dan1931_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Derfor kom Gaditterne og Rubenitterne og sagde til Moses og Præsten Eleazar og Menighedens Øverste: ");
INSERT INTO dan1931_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarot, Dibon, Ja'zer, Nimra, Hesjbon, El'ale, Sebam, Nebo og Beon, ");
INSERT INTO dan1931_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","det Land, HERREN har erobret for Israels Menighed, er et Land, der egner sig til Kvægavl, og dine Trælle ejer Hjorde.” ");
INSERT INTO dan1931_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Og de sagde: “Dersom vi har fundet Nåde for dine Øjne, så lad dine Trælle få dette Land i Eje; før os ikke over Jordan!” ");
INSERT INTO dan1931_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Men Moses sagde til Gaditterne og Rubenitterne: “Skal eders Brødre drage i Krig, medens I bliver boende her? ");
INSERT INTO dan1931_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Og hvorfor vil I betage Israelitterne Modet til at drage over til det Land, HERREN har givet dem? ");
INSERT INTO dan1931_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Det gjorde eders Fædre, da jeg fra Kadesj-Barnea sendte dem hen for at se på Landet; ");
INSERT INTO dan1931_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","da de var draget op til Esjkoldalen og havde set på Landet, det og de Israelitterne Modet til at drage ind i det Land, HERREN havde givet dem. ");
INSERT INTO dan1931_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Men HERRENS Vrede blussede den Gang op, og han svor: ");
INSERT INTO dan1931_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","De Mænd, der er draget op fra Ægypten, fra Tyveårsalderen og opefter, skal ikke få det Land at se, jeg tilsvor Abraham, Isak og Jakob, fordi de ikke viste mig fuld lydighed, ");
INSERT INTO dan1931_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","med Undtagelse af Kenizzitten Kaleb, Jefunnes Søn, og Josua, Nuns Søn, thi de viste HERREN fuld Lydighed! ");
INSERT INTO dan1931_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Og HERRENS Vrede blussede op mod Israel, og han lod dem vanke om i Ørkenen i fyrretyve År, indtil hele den Slægt var gået til Grunde, der gjorde, hvad der var ondt i HERRENS Øjne. ");
INSERT INTO dan1931_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Og se, I træder nu i eders Fædres Fodspor, en Yngel af Syndere, for yderligere at øge HERRENS Vrede mod Israel! ");
INSERT INTO dan1931_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Når I viger bort fra ham, vil han lade det blive endnu længer i Ørkenen, og I bringer Fordærvelse over hele dette Folk.” ");
INSERT INTO dan1931_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Da trådte de frem for ham og sagde: “Vi vil kun bygge Kvægfolde til vore Hjorde her og Byer til vore Familier; ");
INSERT INTO dan1931_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","men selv vil vi ruste os til Kamp og drage i Spidsen for Israelitterne, til vi har bragt dem hen til deres Sted; imens skal vore Familier blive i de befæstede Byer i Ly for Landets indbyggere. ");
INSERT INTO dan1931_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Vi vil ikke vende tilbage til vore Huse, før enhver af Israelitterne har fået sin Arvelod; ");
INSERT INTO dan1931_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","thi vi vil ikke have Arvelod sammen med dem på den anden Side af Jordan og længere borte, eftersom vi har fået vor Arvelod her på denne Side af Jordan på Østsiden.” ");
INSERT INTO dan1931_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Da sagde Moses til dem: “Hvis I gør det, hvis I ruster eder til Kamp for HERRENS Åsyn, ");
INSERT INTO dan1931_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","hvis alle eders kamprustede Mænd overskrider Jordan for HERRENS Åsyn og bliver der, indtil han har jaget sine Fjender bort fra sit Åsyn, ");
INSERT INTO dan1931_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","og hvis I først vender tilbage, når Landet er undertvunget for HERRENS Åsyn, skal I være sagesløse over for HERREN og Israel, og så skal Landet her blive eders Ejendom for HERRENS Åsyn. ");
INSERT INTO dan1931_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Men hvis I ikke gør det, se, da synder I mod HERREN, og da skal I få eders Synd at mærke, den skal nok finde eder. ");
INSERT INTO dan1931_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Byg eder Byer til eders Familier og Folde til eders Småkvæg og gør, som I har sagt!” ");
INSERT INTO dan1931_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Da sagde Gaditterne og Rubenitterne til Moses: “Dine Trælle vil gøre, som min Herre byder; ");
INSERT INTO dan1931_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","vore Børn, Kvinder, Hjorde og alt vort Kvæg skal blive der i Gileads Byer, ");
INSERT INTO dan1931_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","men dine Trælle vil drage over og tage Del i Krigen, så mange som er rustet til Kamp for HERRENS Åsyn, således som min Herre har sagt.” ");
INSERT INTO dan1931_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Så gav Moses Præsten Eleazar og Josua, Nuns Søn, og Overhovederne for de israelitiske Stammers Fædrenehuse Befaling om dem, ");
INSERT INTO dan1931_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","og Moses sagde til dem: “Hvis Gaditterne og Rubenitterne, så mange som er rustet til Kamp for HERRENS Åsyn, går over Jordan sammen med eder og Landet bliver eder underlagt, skal I give dem Gilead i Eje; ");
INSERT INTO dan1931_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","men hvis de ikke går over sammen med eder, rustede til Kamp, skal de have Bopæl anvist blandt eder i Kana'ans Land.” ");
INSERT INTO dan1931_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Da svarede Gaditterne og Rubenitterne: “Hvad HERREN har talt til dine Trælle, vil vi gøre; ");
INSERT INTO dan1931_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","vi vil, rustede til Kamp for HERRENS Øjne, drage over til Kana'ans Land, men vor Arvelod på den anden Side af Jordan bliver i vort Eje.” ");
INSERT INTO dan1931_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Da gav Moses Gaditterne, Rubenitterne og Josefs Søn Manasses halve Stamme Amoritterkongen Sihons Kongerige og kong Og af Basans kongerige, Landet med Byerne og deres Område, Landets Byer rundt om. ");
INSERT INTO dan1931_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Så byggede Gaditterne Dibon, Atarot, Aroer. ");
INSERT INTO dan1931_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atarot-Sjofan, Ja'zer, Jogbeha, ");
INSERT INTO dan1931_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimra, Bet-Haran, befæstede Byer, og Kvægfolde; ");
INSERT INTO dan1931_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","og Rubenitterne byggede Hesjbon, El'ale og Kirjatajim, ");
INSERT INTO dan1931_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo og Ba'al-Meon, hvis Navne ændredes, og Sibma; og de opkaldte Byerne, som de byggede, efter deres Navne. ");
INSERT INTO dan1931_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Og Manasses Søn Makirs Sønner drog til Gilead og erobrede det og drev de der boende Amoritter bort; ");
INSERT INTO dan1931_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","og Moses overdrog Gilead til Manasses Søn Makir, og han bosatte sig der; ");
INSERT INTO dan1931_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","men Manasses Søn Ja'ir drog hen og erobrede deres Teltbyer og kaldte dem Ja'irs Teltbyer. ");
INSERT INTO dan1931_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Og Noba drog hen og erobrede Kenat med tilhørende Småbyer og kaldte det Noba efter sit eget Navn. ");
INSERT INTO dan1931_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Følgende er de enkelte Strækninger på Israelitternes Vandring, de tilbagelagde på Vejen fra Ægypten, Hærafdeling for Hærafdeling, under Anførsel af Moses og Aron. ");
INSERT INTO dan1931_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moses optegnede på HERRENS Bud de Steder, de brød op fra, Strækning for Strækning; og følgende er de enkelte Strækninger efter de Steder, de brød op fra: ");
INSERT INTO dan1931_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","De brød op fra Ra'meses på den femtende Dag i den første Måned; Dagen efter Påske drog Israelitterne ud, værnede af en stærk Hånd, for Øjnene af alle Ægypterne, ");
INSERT INTO dan1931_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","medens Ægypterne jordede alle de førstefødte, som HERREN havde slået iblandt dem; thi HERREN havde holdt Dom over deres Guder. ");
INSERT INTO dan1931_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Israelitterne brød altså op fra Ra'meses og slog Lejr i Sukkot. ");
INSERT INTO dan1931_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Så brød de op fra Sukkot og slog Lejr i Etam, der ligger ved Ørkenens Rand. ");
INSERT INTO dan1931_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Så brød de op fra Etam og vendte om mod Pi-Hakirot over for Ba'al-Zefon og slog Lejr over for Migdol. ");
INSERT INTO dan1931_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Så brød de op fra Pi-Hakirot og drog tværs igennem Havet til Ørkenen; og de vandrede tre Dagsrejser i Etams Ørken og slog Lejr i Mara. ");
INSERT INTO dan1931_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Så brød de op fra Mara og kom til Elim; i Elim var der tolv Vandkilder og halvfjerdsindstyve Palmetræer, og der slog de Lejr. ");
INSERT INTO dan1931_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Så brød de op fra Elim og slog Lejr ved det røde Hav. ");
INSERT INTO dan1931_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Så brød de op fra det røde Hav og slog Lejr i Sins Ørken. ");
INSERT INTO dan1931_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Så brød de op fra Sins Ørken og slog Lejr i Dofka. ");
INSERT INTO dan1931_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Så brød de op fra Dofka og slog Lejr i Alusj. ");
INSERT INTO dan1931_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Så brød de op fra Alusj og slog Lejr i Refidim, hvor Folket ikke havde Vand at drikke. ");
INSERT INTO dan1931_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Så brød de op fra Refidim og slog Lejr i Sinaj Ørken. ");
INSERT INTO dan1931_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Så brød de op fra Sinaj Ørken og slog Lejr i Kibrot Hatta'ava, ");
INSERT INTO dan1931_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Så brød de op fra Kibrot-Hatta'ava og slog Lejr i Hazerot. ");
INSERT INTO dan1931_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Så brød de op fra Hazerot og slog Lejr i Ritma. ");
INSERT INTO dan1931_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Så brød de op fra Ritma og slog Lejr i Rimmon-Perez. ");
INSERT INTO dan1931_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Så brød de op fra Rimmon-Perez og slog Lejr i Libna. ");
INSERT INTO dan1931_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Så brød de op fra Libna og slog Lejr i Rissa. ");
INSERT INTO dan1931_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Så brød de op fra Rissa og slog Lejr i Kehelata. ");
INSERT INTO dan1931_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Så brød de op fra Kehelata og slog Lejr ved Sjefers Bjerg. ");
INSERT INTO dan1931_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Så brød de op fra Sjefers Bjerg og slog Lejr i Harada. ");
INSERT INTO dan1931_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Så brød de op fra Harada og slog Lejr i Makhelot. ");
INSERT INTO dan1931_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Så brød de op fra Makhelot og slog Lejr i Tahat. ");
INSERT INTO dan1931_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Så brød de op fra Tahat og slog Lejr i Tara. ");
INSERT INTO dan1931_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Så brød de op fra Tara og slog Lejr i Mitka. ");
INSERT INTO dan1931_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Så brød de op fra Mitka og slog Lejr i Hasjmona. ");
INSERT INTO dan1931_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Så brød de op fra Hasjmona og slog Lejr i Moserot. ");
INSERT INTO dan1931_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Så brød de op fra Moserot og slog Lejr i Bene-Ja'akan. ");
INSERT INTO dan1931_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Så brød de op fra Bene-Ja'akan og slog Lejr i Hor-Haggidgad. ");
INSERT INTO dan1931_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Så brød de op fra Hor-Haggidgad og slog Lejr i Jotbata. ");
INSERT INTO dan1931_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Så brød de op fra Jotbata og slog Lejr i Abrona. ");
INSERT INTO dan1931_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Så brød de op fra Abrona og slog Lejr i Ezjongeber. ");
INSERT INTO dan1931_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Så brød de op fra Ezjongeber og slog Lejr i Zins Ørken, det er Kadesj. ");
INSERT INTO dan1931_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Så brød de op fra Kadesj og slog Lejr ved Bjerget Hor ved Randen af Edoms Land. ");
INSERT INTO dan1931_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Og Præsten Aron steg på HERRENS Bud op på Bjerget Hor og døde der i det fyrretyvende År efter Israelitternes Udvandring af Ægypten, på den første Dag i den femte Måned; ");
INSERT INTO dan1931_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","og Aron var 123 År gammel, da han døde på Bjerget Hor. ");
INSERT INTO dan1931_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Men Kana'anæeren, Kongen af Arad, der boede, i Sydlandet i Kana'ans Land, hørte, at Israelitterne var under Fremrykning. ");
INSERT INTO dan1931_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Så brød de op fra Bjerget Hor og slog Lejr i Zalmona. ");
INSERT INTO dan1931_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Så brød de op fra Zalmona og slog Lejr i Punon. ");
INSERT INTO dan1931_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Så brød de op fra Punon og slog Lejr i Obot. ");
INSERT INTO dan1931_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Så brød de op fra Obot og slog Lejr i Ijje Ha'abarim ved Moabs Grænse. ");
INSERT INTO dan1931_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Så brød de op fra Ijje Ha'abarim og slog Lejr i det gaditiske Dibon. ");
INSERT INTO dan1931_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Så brød de op fra det gaditiske Dibon og slog Lejr i Almon-Diblatajim. ");
INSERT INTO dan1931_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Så brød de op fra Almon-Diblatajim og slog Lejr på Abarimbjergene over for Nebo. ");
INSERT INTO dan1931_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Så brød de op fra Abarimbjergene og slog Lejr på Moabs Sletter ved Jordan over for Jeriko; ");
INSERT INTO dan1931_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","og de slog Lejr ved Jordan fra Bet-Jesjimot og til Abel Sjittim på Moabs Sletter. ");
INSERT INTO dan1931_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Og HERREN talede til Moses på Moabs Sletter ved Jordan over for Jeriko og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Tal til Israelitterne og sig til dem: Når I kommer over Jordan til Kana'ans Land, ");
INSERT INTO dan1931_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","skal I drive Landets Beboere bort foran eder og tilintetgøre alle deres Billedværker, alle deres støbte Billeder skal I tilintetgøre, og alle deres Offerhøje skal I ødelægge; ");
INSERT INTO dan1931_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","I skal underlægge eder Landet og bosætte eder der, thi eder har jeg givet Landet i Eje; ");
INSERT INTO dan1931_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","og I skal udskifte Landet mellem eder ved Lodkastning efter eders Slægter, således at I giver en stor Slægt en stor Arvelod og en lille Slægt en lille. Der, hvor Loddet falder for dem, skal deres Del være; efter eders Fædrenestammer skal I udskifte Landet mellem eder. ");
INSERT INTO dan1931_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Men hvis I ikke driver Landets Beboere bort foran eder, så skal de, som I levner af dem, blive Torne i eders Øjne og Brodde i eders Sider, og de skal bringe eder Trængsel i det Land, I bor i, ");
INSERT INTO dan1931_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","og hvad jeg havde tænkt at gøre ved dem, gør jeg da ved eder.” ");
INSERT INTO dan1931_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Byd Israelitterne og sig til dem: Når i kommer til Kana'ans Land - det er det Land, der skal tilfalde eder som Arvelod, Kana'ans Land i hele dets Udstrækning - ");
INSERT INTO dan1931_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","så skal eders Sydside strække sig fra Zins Ørken langs med Edom; eders Sydgrænse skal mod Øst begynde ved Enden af Salthavet; ");
INSERT INTO dan1931_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","så skal eders Grænse dreje sønden om Akrabbimpasset, nå til Zin og ende sønden for Kadesj-Barnea; så skal den løbe hen til Hazar-Addar og nå til Azmon; ");
INSERT INTO dan1931_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","fra Azmon skal Grænsen dreje hen til Ægyptens Bæk og ende ved Havet. ");
INSERT INTO dan1931_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Hvad Vestgrænsen angår, skal det store Hav være eders Grænse; det skal være eders Vestgrænse. ");
INSERT INTO dan1931_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Eders Nordgrænse skal være følgende: Fra det store Hav skal I udstikke eder en Linie til Bjerget Hor; ");
INSERT INTO dan1931_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","fra Bjerget Hor skal I udstikke en Linie til Egnen hen imod Hamat, så at Grænsen ender ved Zedad; ");
INSERT INTO dan1931_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","derpå skal Grænsen gå til Zifron og ende ved Hazar-Enan. Det skal være eders Nordgrænse. ");
INSERT INTO dan1931_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Men til Østgrænse skal I afmærke eder en Linie fra Hazar-Enan til Sjefam; ");
INSERT INTO dan1931_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","og fra Sjefam skal Grænsen gå ned til Ribla østen for Ajin, og Grænsen skal løbe videre ned, til den støder til Bjergskrænten østen for Kinneretsøen*; { *Genezaret Sø. } ");
INSERT INTO dan1931_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","derpå skal Grænsen løbe ned langs Jordan og ende ved Salthavet. Det skal være eders Land i hele dets Udstrækning til alle Sider. ");
INSERT INTO dan1931_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Og Moses bød Israelitterne og sagde: Det er det Land, I skal udskifte mellem eder ved Lodkastning, og som efter HERRENS Bud skal gives de ni Stammer og den halve Stamme. ");
INSERT INTO dan1931_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Thi Rubenitternes Stamme efter deres Fædrenehuse og Gaditternes Stamme efter deres Fædrenehuse og Manasses halve Stamme har allerede fået deres Arvelod. ");
INSERT INTO dan1931_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","De to Stammer og den halve Stamme har fået deres Arvelod hinsides Jordan over for Jeriko, mod Øst, mod Solens Opgang. ");
INSERT INTO dan1931_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Og HERREN talede til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Navnene på de Mænd, der skal udskifte Landet mellem eder, er følgende: Præsten Eleazar og Josua, Nuns Søn; ");
INSERT INTO dan1931_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","desuden skal I udtage én Øverste af hver Stamme til at udskifte Landet. ");
INSERT INTO dan1931_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Navnene på disse Mænd er følgende: Af Judas Stamme Kaleb, Jefunnes Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","af Simeonitternes Stamme Sjemuel, Ammihuds Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","af Benjamins Stamme Elidad, Kislons Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","af Danitternes Stamme én Øverste, Bukki, Joglis Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","af Josefs Sønner: af Manassitternes Stamme én Øverste, Hanniel, Efods Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","og af Efraimitternes Stamme én Øverste, Kemuel, Sjiftans Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","af Zebulonitternes Stamme én Øverste, Elizafan, Parnaks Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","af Issakaritternes Stamme én Øverste, Paltiel, Azzans Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","af Aseritternes Stamme én Øverste, Ahihud, Sjelomis Søn, ");
INSERT INTO dan1931_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","og af Naftalitternes Stamme én Øverste, Peda'el, Ammihuds Søn. ");
INSERT INTO dan1931_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Det var dem, HERREN pålagde at udskifte Kana'ans Land mellem Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","HERREN talede fremdeles til Moses på Moabs Sletter ved Jordan over for Jeriko og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","byd Israelitterne, at de af de Besiddelser, de får i Arv, skal give Levitterne nogle Byer at bo i; I skal også give Levitterne Græsmarker rundt om disse Byer, ");
INSERT INTO dan1931_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Disse Byer skal de have at bo i, og deres Græsmarker skal de have til deres Kvæg, deres Hjorde og andre Dyr. ");
INSERT INTO dan1931_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Græsmarkerne om Byerne, som I skal give Levitterne, skal strække sig 1.000 Alen fra Bymuren ud til alle Sider; ");
INSERT INTO dan1931_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","og uden for Byen skal I til Østside opmåle 2.000 Alen, til Sydside 2.000, til Vestside 2.000 og til Nordside 2.000, med Byen i Midten. Det skal tilfalde dem som Græsgange til Byerne. ");
INSERT INTO dan1931_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Hvad de Byer angår, som I skal give Levitterne, så skal I give dem de seks Tilflugtsbyer, som Manddrabere kan ty ind i, og desuden to og fyrretyve Byer. ");
INSERT INTO dan1931_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","De Byer, I skal give Levitterne, bliver således i alt otte og fyrretyve Byer med tilhørende Græsmarker. ");
INSERT INTO dan1931_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Og af de Byer, I skal give dem af Israelitternes Besiddelser, skal I lade de større Stammer give flere, de mindre færre; hver Stamme skal give Levitterne så mange af sine Byer, som svarer til den Arvelod, der tildeles den. ");
INSERT INTO dan1931_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","HERREN talede fremdeles til Moses og sagde: ");
INSERT INTO dan1931_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Tal til Israelitterne og sig til dem: Når I kommer over Jordan til Kana'ans Land, ");
INSERT INTO dan1931_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","skal I udse eder nogle Byer, I kan have som Tilflugtsbyer, så at en Manddraber, der begår et Drab af Vanvare, kan ty derhen. ");
INSERT INTO dan1931_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","I disse Byer skal I have Ret til at søge Tilflugt for Blodhævneren, for at ikke Manddraberen skal dø, før han er blevet stillet for Menighedens Domstol. ");
INSERT INTO dan1931_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Det skal være seks Byer, I skal afstå til Tilflugtsbyer; ");
INSERT INTO dan1931_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","de tre skal I afstå hinsides Jordan og de tre andre i Kana'ans Land; de skal være Tilflugtsbyer. ");
INSERT INTO dan1931_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Israelitterne, de fremmede og de indvandrede iblandt dem skal have Ret til at søge Tilflugt i de seks Byer, så at enhver, der begår et Drab af Vanvare, kan ty derhen. ");
INSERT INTO dan1931_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Men slår han ham ihjel med et Jernredskab, så er han en Manddraber, og Manddraberen skal lide Døden; ");
INSERT INTO dan1931_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","og slår han ham ihjel med en Sten, som han har i Hånden, og som kan slå en Mand ihjel, så er han en Manddraber, og Manddraberen skal lide Døden; ");
INSERT INTO dan1931_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","og slår han ham ihjel med et Træredskab, som han har i Hånden, og som kan slå en Mand ihjel, så er han en Manddraber, og Manddraberen skal lide Døden. ");
INSERT INTO dan1931_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Blodhævneren skal dræbe Manddraberen; når han træffer ham, skal han dræbe ham. ");
INSERT INTO dan1931_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Og støder han til ham af Had eller kaster noget på ham i ond Hensigt, så han dør deraf, ");
INSERT INTO dan1931_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","eller slår han ham med Hånden i Fjendskab, så han dør deraf, skal drabsmanden lide Døden, thi han er en Manddraber; Blodhævneren skal dræbe Manddraberen, når han træffer ham. ");
INSERT INTO dan1931_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Støder han derimod til ham af Vanvare, ikke i Fjendskab, eller kaster han et Redskab på ham, uden at det er i ond Hensigt, ");
INSERT INTO dan1931_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","eller rammer han ham uden at se ham med en Sten, som kan slå en Mand ihjel, så han dør deraf, og han ikke er hans Uven eller har pønset på ondt imod ham, ");
INSERT INTO dan1931_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","så skal Menigheden dømme Drabsmanden og Blodhævneren imellem på Grundlag af disse Lovbud; ");
INSERT INTO dan1931_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","og Menigheden skal værne Manddraberen mod Blodhævneren, og Menigheden skal føre ham tilbage til hans Tilflugtsby, hvorhen han var tyet, og der skal han blive boende, indtil den med hellig Olie salvede Ypperstepræst dør. ");
INSERT INTO dan1931_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Men hvis Manddraberen for lader sin Tilflugtsbys Område, hvorhen han er tyet, ");
INSERT INTO dan1931_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","og Blodhævneren træffer ham uden for hans Tilflugtsbys Område, så kan Blodhævneren dræbe Manddraberen uden at pådrage sig Blodskyld; ");
INSERT INTO dan1931_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","thi han skal blive i sin Tilflugtsby indtil Ypperstepræstens Død; først efter Ypperstepræstens Død kan Manddraberen vende tilbage til den Jord, han ejer. ");
INSERT INTO dan1931_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Det skal være eder en retsgyldig Anordning fra Slægt til Slægt, hvor I end bor. ");
INSERT INTO dan1931_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Når nogen slår et Menneske ihjel, må man kun dræbe Manddraberen efter flere Vidners Udsagn. Et enkelt Vidnes Udsagn er ikke nok til en Dødsdom. ");
INSERT INTO dan1931_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","I må ikke tage mod Sonebøde for en Manddraber, når han har forbrudt sit Liv; han skal lide Døden, ");
INSERT INTO dan1931_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Heller ikke må I tage mod Sonebøde, således at den, der er tyet til sin Tilflugtsby, før Ypperstepræstens Død kan vende tilbage og bosætte sig i Landet. ");
INSERT INTO dan1931_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Vanhelliger ikke det Land, I er i, thi Blodet vanhelliger Landet, og Landet får kun Soning for det Blod, der er udgydt deri, ved dens Blod, der har udgydt det. ");
INSERT INTO dan1931_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Gør ikke det Land urent, I er bosat i, og i hvis Midte jeg bor; thi jeg HERREN bor midt iblandt Israels Børn. ");
INSERT INTO dan1931_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Overhovederne for Fædrenehusene i Gileaditternes Slægt Gilead var en Søn af Manasses Søn Makir af Josefs Sønners Slægter trådte frem og talte for Moses og Øversterne, Overhovederne for Israelitternes Fædrenehuse, ");
INSERT INTO dan1931_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","og sagde: “HERREN har pålagt min Herre at udskifte Landet mellem Israelitterne ved Lodkastning, og min Herre har i HERRENS Navn påbudt at give vor Frænde Zelofhads Arvelod til hans Døtre. ");
INSERT INTO dan1931_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Men hvis de nu indgår Ægteskab med Mænd, der hører til en anden af Israels Stammer, så unddrages deres Arvelod jo vore Fædres Arvelod, og således øges den Stammes Arvelod, som de kommer til at tilhøre, medens den Arvelod, der er tilfaldet os ved Lodkastning, formindskes; ");
INSERT INTO dan1931_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","og når Israelitterne får Jubelår, lægges deres Arvelod til den Stammes Arvelod, som de kommer til at tilhøre, og således unddrages deres Arvelod vor fædrene Stammes Arvelod.” ");
INSERT INTO dan1931_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Da udstedte Moses efter HERRENS Ord følgende Bud til Israelitterne: “Josefs Sønners Stamme har talt ret! ");
INSERT INTO dan1931_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Således er HERRENS Bud angående Zelofhads Døtre: De må indgå Ægteskab med hvem de ønsker, men det må kun være Mænd af deres Faders Stammes Slægt, de indgår Ægteskab med. ");
INSERT INTO dan1931_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Thi ingen Arvelod, der tilhører Israel, må gå over fra en Stamme til en anden, men Israelitterne skal holde fast hver ved sin fædrene Stammes Arvelod. ");
INSERT INTO dan1931_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Enhver Datter, som får en Arvelod i en af Israelitternes Stammer, skal indgå Ægteskab med en Mand af sin fædrene Stammes Slægt, for at Israelitterne kan beholde hver sine Fædres Arvelod som Ejendom; ");
INSERT INTO dan1931_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","og ingen Arvelod må gå over fra den ene Stamme til den anden, men Israelitternes Stammer skal holde fast hver ved sin Arvelod!” ");
INSERT INTO dan1931_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Zelofhads Døtre gjorde da, som HERREN pålagde Moses, ");
INSERT INTO dan1931_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","idet Mala, Tirza, Hogla, Milka og Noa, Zelofhads Døtre, indgik Ægteskab med deres Farbrødres Sønner; ");
INSERT INTO dan1931_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","de indgik Ægteskab med Mænd, som hørte til Josefs Søn Manasses Sønners Slægter, så at deres Arvelod vedblev at tilhøre deres fædrene Slægts Stamme. ");
INSERT INTO dan1931_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Det er de Bud og Lovbud, HERREN gav Israelitterne ved Moses på Moabs Sletter ved Jordan over for Jeriko. ");
INSERT INTO dan1931_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Dette er de Ord, Moses talte til hele Israel hinsides Jordan i Ørkenen, i Arabalavningen, lige over for Suf, mellem Paran og Tofel, Laban, Hazerot og Di-Zahab, ");
INSERT INTO dan1931_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","elleve Dagsrejser fra Horeb, regnet over Se'irs Bjerge til Kadesj-Barnea. ");
INSERT INTO dan1931_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","I det fyrretyvende År på den første Dag i den ellevte Måned kundgjorde Moses Israelitterne alt, hvad HERREN havde pålagt ham angående dem, ");
INSERT INTO dan1931_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","efter at han havde slået Amoritterkongen Sihon, der boede i Hesjbon, og Kong Og af Basan, der boede i Asjtarot og Edre'i. ");
INSERT INTO dan1931_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Hinsides Jordan i Moabs Land tog Moses sig for at fremsætte følgende Lovudlægning: ");
INSERT INTO dan1931_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","HERREN vor Gud talede til os ved Horeb og sagde: “I har nu længe nok opholdt eder ved Bjerget her; ");
INSERT INTO dan1931_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","bryd derfor op og drag til Amoritternes Bjerge og til alle deres Naboer i Arabalavningen, på Bjergene, i Lavlandet, i Sydlandet og ved Kysten, til Kana'anæernes Land og Libanon, lige til den store Flod, Eufratfloden. ");
INSERT INTO dan1931_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Se, jeg giver Landet i eders Magt; drag derind og tag det Land i Besiddelse, som jeg tilsvor eders Fædre, Abraham, Isak og Jakob, at ville give dem og deres Afkom efter dem.” ");
INSERT INTO dan1931_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Dengang talte jeg til eder og sagde: “Jeg kan ikke ene bære eder. ");
INSERT INTO dan1931_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","HERREN eders Gud har gjort eder talrige, og se, I er nu så mange som Stjernerne på Himmelen; ");
INSERT INTO dan1931_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","måtte kun HERREN, eders Fædres Gud, gøre eder tusinde Gange så talrige endnu og velsigne eder, som han har forjættet eder - ");
INSERT INTO dan1931_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","men hvorledes skal jeg ene kunne bære hele Besværet og Arbejdet med eder og eders Stridigheder? ");
INSERT INTO dan1931_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Sørg derfor for at finde nogle kloge, forstandige og erfarne Mænd i hver Stamme, som jeg kan sætte i Spidsen for eder!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Dertil svarede I og sagde: “Det Forslag, du har fremsat, er godt!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Derfor tog jeg Overhovederne for eders Stammer, kloge og erfarne Mænd, og satte dem i Spidsen for eder som Øverste over tusinde, hundrede, halvtredsindstyve eller ti og som Tilsynsmænd over eders Stammer. ");
INSERT INTO dan1931_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Dengang gav jeg så eders Dommere det Påbud: “Hold Forhør, når der er Stridigheder mellem eders Landsmænd, og døm retfærdigt, når en Mand har en Sag, enten det er med en Landsmand eller med en, der bor som fremmed hos ham; ");
INSERT INTO dan1931_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","vis ingen Personsanseelse for Retten; hør på den ringeste som på den største og frygt ikke for nogen; thi Dommen er Guds! Men Sager, som er eder for vanskelige, skal I forebringe mig, så skal jeg holde Forhør i dem!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Og dengang gav jeg eder så Pålæg om alt, hvad I skulde gøre. ");
INSERT INTO dan1931_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Derpå brød vi op fra Horeb og drog gennem hele denne store, grufulde Ørken, som I selv har set, i Retning af Amoritternes Bjerge, således som HERREN vor Gud havde pålagt os. Og vi kom til Kadesj-Barnea. ");
INSERT INTO dan1931_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Da sagde jeg til eder: “I er nu kommet til Amoritternes Bjerge, som HERREN vor Gud vil give os. ");
INSERT INTO dan1931_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Se, HERREN din Gud har givet Landet i din Magt, drag derfor op og tag det i Besiddelse, således som HERREN, dine Fædres Gud, har sagt til dig. Frygt ikke, men vær uforsagt!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Da kom I alle hen til mig og sagde: “Lad os sende nogle Mænd i forvejen til at udspejde Landet for os og bringe os Underretning om den Vej, vi skal drage op ad, og om de Byer, vi kommer til!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Jeg billigede det og udtog tolv Mænd iblandt eder, en af hver Stamme. ");
INSERT INTO dan1931_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","De begav sig på Vej og drog op i Bjergene og kom til Esjkoldalen og udspejdede den; ");
INSERT INTO dan1931_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","og de tog nogle af Landets Frugter med og bragte dem ned til os, og de meldte os tilbage: “Det er et herligt Land, HERREN vor Gud vil give os!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Men I vilde ikke drage op, I var genstridige mod HERREN eders Guds Befaling. ");
INSERT INTO dan1931_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","I knurrede i eders Telte og sagde: “Af Had til os førte HERREN os ud af Ægypten for at give os i Amoritternes Hånd og lade os gå til Grunde! ");
INSERT INTO dan1931_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Hvor er det dog, vi skal hen? Vore Brødre tog Modet fra os, da de sagde: Det er et Folk, der er større og højere end vi, og der er store Byer med himmelhøje Fæstningsværker, ja, vi så endog Efterkommere af Anakitterne der!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Men jeg sagde til eder: “Lad eder ikke skræmme og frygt ikke for dem! ");
INSERT INTO dan1931_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","HERREN eders Gud, der vandrer foran eder, vil selv stride for eder, som I så, han gjorde det for eder i Ægypten ");
INSERT INTO dan1931_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","og i Ørkenen, hvor du så, at HERREN din Gud bar dig, som en Mand bærer sin Søn, hele den Vej I har vandret, lige til I nåede hertil!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Men alligevel troede I ikke på HERREN eders Gud, ");
INSERT INTO dan1931_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","skønt han vandrede foran eder på Vejen for at udsøge Lejrpladser til eder, om Natten i Ilden, for at I kunde se, hvor I skulde gå, og om dagen i Skyen. ");
INSERT INTO dan1931_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Men da HERREN hørte eders Ord, blev han vred og svor: ");
INSERT INTO dan1931_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Ikke en eneste af disse Mænd, af denne onde Slægt, skal få det herlige Land at se, som jeg svor at ville give eders Fædre, ");
INSERT INTO dan1931_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","undtagen Kaleb, Jefunnes Søn; han alene skal få det at se, og ham og hans Børn vil jeg give det Land, han har betrådt, fordi han har vist HERREN fuld Lydighed!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Også på mig blev HERREN vred for eders Skyld, og han sagde: “Heller ikke du skal komme derind! ");
INSERT INTO dan1931_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Josua, Nuns Søn, der står i din Tjeneste, han skal komme derind; sæt Mod i ham, thi han skal skaffe Israel det i Eje.” ");
INSERT INTO dan1931_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Og dets små Børn, som I sagde skulde blive til Bytte, eders Børn, som i Dag ikke kender Forskel på godt og ondt, de skal komme derind, dem vil jeg give det, og de skal tage det i Besiddelse. ");
INSERT INTO dan1931_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","I selv derimod skal vende om og begive eder på Vej til Ørkenen i Retning af det røde Hav! ");
INSERT INTO dan1931_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Da svarede I og sagde til mig: “Vi har syndet imod HERREN! Vi vil drage op og kæmpe, som HERREN vor Gud har befalet os!” Og alle iførte I eder eders Våben og vilde i Letsindighed drage op i Bjergene. ");
INSERT INTO dan1931_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Men HERREN sagde til mig: “Sig til dem: Drag ikke op og indlad eder ikke i Kamp, thi jeg er ikke iblandt eder; gør I det, bliver I slået af eders Fjender!” ");
INSERT INTO dan1931_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Men da jeg sagde det til eder, adlød I ikke, men var genstridige mod HERRENS Bud og formastede eder til at drage op i Bjergene. ");
INSERT INTO dan1931_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Da drog Amoritterne, der bor i Bjergene der, ud imod eder, og de forfulgte eder som Bier og slog eder fra Se'ir til Horma. ");
INSERT INTO dan1931_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Da I så kom tilbage, græd I for HERRENS Åsyn; men HERREN vilde ikke høre eder og låne eder Øre. ");
INSERT INTO dan1931_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Så blev I hele den lange Tid i Kadesj. ");
INSERT INTO dan1931_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Så vendte vi om og brød op til Ørkenen i Retning af det røde Hav, således som HERREN havde pålagt mig, og i lang Tid vandrede vi rundt om Se'irs Bjerge. ");
INSERT INTO dan1931_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Da sagde HERREN til mig: ");
INSERT INTO dan1931_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Nu har I længe nok vandret rundt om Bjergene her; vend eder nu mod Nord! ");
INSERT INTO dan1931_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Men byd Folket og sig: Når I nu drager igennem eders Brødres, Esaus Sønners, Landemærker, de, som bor i Se'ir, og de bliver bange for eder, så skal I tage eder vel i Vare ");
INSERT INTO dan1931_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","for at indlade eder i Krig med dem; thi jeg vil ikke give eder så meget som en Fodsbred af deres Land; thi Esau har jeg givet Se'irs Bjerge i Arv og Eje. ");
INSERT INTO dan1931_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Fødevarer at spise skal I købe af dem for Penge, også Vand at drikke skal I købe af dem for Penge; ");
INSERT INTO dan1931_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","thi HERREN din Gud har velsignet dig i alt, hvad du har taget dig for, han har sørget for dig på din Vandring gennem denne store Ørken; i fyrretyve År har HERREN din Gud nu været med dig, du har ikke manglet noget.” ");
INSERT INTO dan1931_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Derpå drog vi fra Elat og Ezjongeber ad Arabavejen gennem vore Brødres, Esaus Sønners Land, de, som bor i Se'ir; så drejede vi af og drog videre ad Vejen til Moabs Ørken. ");
INSERT INTO dan1931_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Og HERREN sagde til mig: “Du må ikke angribe Moab eller indlade dig i Krig med dem, thi jeg vil ikke give dig noget af deres Land i Eje; thi Lots Sønner har jeg givet Ar i Eje. ");
INSERT INTO dan1931_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Fordum beboedes det af Emitterne, et stort og talrigt Folk, kæmpestore som Anakitterne;) ");
INSERT INTO dan1931_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","(også de henregnes ligesom Anakitterne til Refaitterne, men Moabitterne kalder dem Emiter.) ");
INSERT INTO dan1931_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","(I Se'ir boede derimod fordum Horitterne, som Esaus Sønner drev bort og udryddede foran sig, hvorefter de bosatte sig der i deres Sted, ligesom Israel gjorde ved sit Ejendomsland, som HERREN gav dem). ");
INSERT INTO dan1931_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Bryd nu op og gå over Zeredbækken!” Så gik vi over Zeredbækken. ");
INSERT INTO dan1931_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Der var gået otte og tredive År fra vort Opbrud fra Kadesj-Barnea, til vi gik over Zeredbækken, til hele din Slægt af våbenføre Mænd var uddød af Lejren, således som HERREN havde svoret dem; ");
INSERT INTO dan1931_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","også HERRENS Hånd havde været imod dem, så de blev udryddet af Lejren til sidste Mand. ");
INSERT INTO dan1931_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Men da alle våbenføre Mænd var uddøde af Folket, ");
INSERT INTO dan1931_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","talede HERREN til mig og sagde: ");
INSERT INTO dan1931_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Når du nu drager gennem Moabs Landemærker, gennem Ar, ");
INSERT INTO dan1931_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","og således når hen til Ammonitterne, så må du ikke angribe dem eller indlade dig i Krig med dem, thi jeg vil ikke give dig noget af Ammonitternes Land i Eje; thi det har jeg givet Lots Børn i Eje. ");
INSERT INTO dan1931_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Også det henregnes til Refaitternes Land; det beboedes fordum af Refaitter, men Ammonitterne kalder dem Zamzummitter.) ");
INSERT INTO dan1931_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","(Det var et stort og talrigt Folk, kæmpestore som Anakitterne. Men HERREN udryddede dem foran dem, så de drev dem bort og bosatte sig der i deres Sted,) ");
INSERT INTO dan1931_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","(ligesom han gjorde for Esaus Sønner, der bor i Se'ir, for hvem han udryddede Horitterne, så de drev dem bort og bosatte sig der i deres Sted, og de bor der den Dag i dag.) ");
INSERT INTO dan1931_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","(Men Avvijitterne, der boede i Landsbyer i Egnene henimod Gaza, dem drev Kaftorerne, der var udvandret fra Kaftor, bort og bosatte sig der i deres Sted). ");
INSERT INTO dan1931_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Bryd nu op og gå over Arnonfloden! Se, jeg har givet Hesjbons Konge, Amoritten Sihon, og hans Land i din Hånd; giv dig kun til at drive ham bort og føre Krig med ham! ");
INSERT INTO dan1931_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Fra i Dag af begynder jeg at vække Frygt og Rædsel for dig hos alle Folkeslag under Himmelen; blot de hører om dig, skal de ryste og bæve for dig! ");
INSERT INTO dan1931_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Da udsendte jeg Sendebud fra Kedemots Ørken til Kong Sihon af Hesjbon med følgende fredelige Tilbud: ");
INSERT INTO dan1931_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Lad mig drage gennem dit Land; jeg skal holde mig til Vejen uden at bøje af til højre eller venstre. ");
INSERT INTO dan1931_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Fødevarer at spise skal du sælge mig for Penge, og Vand at drikke skal du give mig for Penge, jeg beder kun om at måtte drage igennem til Fods, ");
INSERT INTO dan1931_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","således som Esaus Sønner, der bor i Se'ir, og Moabitterne, der bor i Ar, tillod mig, indtil jeg kommer over Jordan ind i det Land, HERREN vor Gud vil give os!” ");
INSERT INTO dan1931_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Men Kong Sihon i Hesjbon vilde ikke tillade os at drage igennem; thi HERREN din Gud forhærdede hans Ånd og gjorde hans Hjerte hårdt for at give ham i din Hånd, som det nu er sket. ");
INSERT INTO dan1931_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Derpå sagde HERREN til mig: “Se, jeg har allerede begyndt at give Sihon og hans Land i din Magt; giv dig kun til at drive ham bort for at tage hans Land i Besiddelse!” ");
INSERT INTO dan1931_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Så rykkede Sihon med alle sine Krigere ud imod os til Kamp ved Jaza; ");
INSERT INTO dan1931_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","og HERREN vor Gud gav ham i vor Magt, og vi slog ham og hans Sønner og alle hans Krigere. ");
INSERT INTO dan1931_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Og vi indtog dengang alle hans Byer og lagde i enhver By Band på Mænd, Kvinder og Børn uden at lade en eneste undslippe; ");
INSERT INTO dan1931_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","kun Kvæget tog vi selv som Bytte, tillige med hvad vi røvede i de erobrede Byer. ");
INSERT INTO dan1931_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Fra Aroer ved Arnonflodens Bred og Byen, der ligger i Dalen, og til Gilead var der ikke en By, som var os uindtagelig; HERREN vor Gud gav dem alle i vor Magt. ");
INSERT INTO dan1931_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Men på Ammonitternes Land forgreb du dig ikke, hverken det, der ligger langs Jabbokfloden, eller Byerne i Bjergene, således som HERREN vor Gud havde påbudt. ");
INSERT INTO dan1931_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Derpå brød vi op og drog mod Basan. Og Kong Og af Basan rykkede med alle sine Krigere ud imod os til Kamp ved Edre'i. ");
INSERT INTO dan1931_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Da sagde HERREN til mig: “Frygt ikke for ham, thi jeg giver ham i din Hånd tillige med hele hans Folk og Land, og du skal gøre ved ham, som du gjorde ved Sihon, Amoritterkongen i Hesjbon.” ");
INSERT INTO dan1931_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Så gav HERREN vor Gud også kong Og af Basan og alle hans Krigere i vor Hånd, og vi slog ham, så ikke en eneste undslap. ");
INSERT INTO dan1931_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Vi indtog dengang alle hans Byer; der var ikke én By, vi ikke fratog dem, i alt tresindstyve Byer, hele Landskabet Argob, Ogs Kongerige i Basan, ");
INSERT INTO dan1931_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","lutter Byer, der var befæstet med høje Mure, Porte og Portslåer, foruden de mange åbne Byer; ");
INSERT INTO dan1931_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","og vi lagde Band på dem, ligesom vi havde gjort ved Kong Sihon i Hesjbon, i enhver By lagde vi Band på Mænd, Kvinder og Børn; ");
INSERT INTO dan1931_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","men alt Kvæget, og hvad vi røvede fra Byerne, tog vi selv som Bytte. ");
INSERT INTO dan1931_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Således erobrede vi dengang Landet fra de to Amoritterkonger hinsides Jordan fra Arnonfloden til Hermonbjerget - ");
INSERT INTO dan1931_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Zidonierne kalder Hermon Sirjon, men Amoritterne kalder det Senir - ");
INSERT INTO dan1931_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","alle Byerne på Højsletten, hele Gilead og hele Basan lige til Salka og Edre'i, Byer i kong Ogs Rige i Basan. ");
INSERT INTO dan1931_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Thi Kong Og af Basan var den eneste, der endnu var tilbage af Refaitterne; hans Kiste, en Jernkiste, står jo endnu i Rabba i Ammon, ni Alen lang og fire Alen bred efter vanligt Mål). ");
INSERT INTO dan1931_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Således tog vi dengang dette Land i Besiddelse. Landet fra Aroer, der ligger ved Arnonfloden, og Halvdelen af Gileads Bjerge med Byerne der gav jeg Rubenitterne og Gaditterne; ");
INSERT INTO dan1931_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","men Resten af Gilead og hele Basan, Ogs Rige, gav jeg til Manasses halve Stamme, hele Landskabet Argob. (Det er hele dette Basan, man kalder Refaitterland.) ");
INSERT INTO dan1931_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manasses Søn Ja'ir erobrede hele Landskabet Argob indtil Gesjuritternes og Ma'akatitternes Egne og kaldte dem Ja'irs Teltbyer efter sig selv, som de hedder endnu den Dag i Dag. ");
INSERT INTO dan1931_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Og Makir gav jeg Gilead; ");
INSERT INTO dan1931_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","og Rubenitterne og Gaditterne gav jeg Landet fra Gilead til Arnonfloden med Dalens Midtlinie som Grænse og til Jabbokfloden, Ammonitternes Grænse, ");
INSERT INTO dan1931_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","og Arabalavningen med Jordan som Grænse fra Kinneret til Araba- eller Salthavet ved Foden af Pisgas Skrænter mod Øst. ");
INSERT INTO dan1931_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Dengang gav jeg eder følgende Påbud: “HERREN eders Gud har givet eder dette Land i Eje; men I skal, så mange krigsdygtige Mænd I er, drage væbnede i Spidsen for eders Brødre Israelitterne - ");
INSERT INTO dan1931_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","kun eders Kvinder, Børn og Kvæg (jeg ved, at I har meget Kvæg) skal blive tilbage i de Byer, jeg giver eder - ");
INSERT INTO dan1931_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","indtil HERREN bringer eders Brødre til Hvile ligesom eder, og de også får taget det Land i Besiddelse, som HERREN eders Gud vil give dem hinsides Jordan; så kan enhver af eder vende tilbage til den Ejendom, jeg har givet eder!” ");
INSERT INTO dan1931_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Og Josua gav jeg dengang følgende Påbud: “Du har med egne Øjne set alt, hvad HERREN eders Gud har gjort ved disse to Konger; således vil HERREN også gøre ved alle de Riger, du drager over til. ");
INSERT INTO dan1931_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Du skal ikke frygte for dem; thi HERREN eders Gud vil selv kæmpe for eder!” ");
INSERT INTO dan1931_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Og dengang bad jeg således til HERREN: ");
INSERT INTO dan1931_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Herre, HERRE! Du har begyndt at vise din Tjener din Storhed og din stærke Hånd! Thi hvem er den Gud i Himmelen og på Jorden, der kan gøre sådanne Gerninger og Storværker som du? ");
INSERT INTO dan1931_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Lad mig da få Lov at drage over og se det herlige Land hinsides Jordan, det herlige Bjergland og Libanon!” ");
INSERT INTO dan1931_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Men HERREN var vred på mig for eders Skyld og hørte mig ikke, men han sagde til mig: “Lad det være nok, tal ikke mere til mig om den Sag; ");
INSERT INTO dan1931_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","men stig op på Pisgas Tinde, løft dit Blik mod Vest og Nord, mod Syd og Øst, og tag det i Øjesyn. Thi du kommer ikke til at drage over Jordan dernede; ");
INSERT INTO dan1931_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","men sig Josua, hvad han skal, og sæt Mod i ham og styrk ham, thi det bliver ham, der skal drage over i Spidsen for dette Folk, og ham, der skal give dem det Land, du ser, i Eje.” ");
INSERT INTO dan1931_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Så blev vi i Dalen lige over for Bet-Peor. ");
INSERT INTO dan1931_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Og nu, Israel! Hør de Anordninger og Lovbud, som jeg vil lære eder at holde, for at I kan blive i Live og komme ind og tage det Land i Besiddelse, som HERREN, eders Fædres Gud, vil give eder. ");
INSERT INTO dan1931_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","I må hverken lægge noget til eller trække noget fra, hvad jeg byder eder, men I skal holde HERREN eders Guds Bud, som jeg pålægger eder. ");
INSERT INTO dan1931_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","I har med egne Øjne set, hvad HERREN gjorde i Anledning af Ba'al-Peor: Hver eneste Mand, som fulgte Ba'al-Peor, udryddede HERREN din Gud af din Midte. ");
INSERT INTO dan1931_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Men I, som holdt fast ved HERREN eders Gud, er alle i Live den Dag i Dag. ");
INSERT INTO dan1931_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Se, jeg har lært eder Anordninger og Lovbud, således som HERREN min Gud har pålagt mig, for at I skal handle derefter i det Land, I skal ind og tage i Besiddelse; ");
INSERT INTO dan1931_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","hold dem og følg dem! Thi det skal være eders Visdom og eders Kløgt i de andre Folks Øjne. Når de hører om alle disse Anordninger, skal de sige: “Sandelig, det er et vist og klogt Folk, dette store Folk!” ");
INSERT INTO dan1931_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Thi hvor er der vel et stort Folk, som har Guder, der kommer til det, således som HERREN vor Gud gør det, når vi kalder på ham; ");
INSERT INTO dan1931_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","og hvor er der vel et stort Folk, der har så retfærdige Anordninger og Lovbud som hele denne Lov, jeg forelægger eder i Dag? ");
INSERT INTO dan1931_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Kun skal du vogte dig og omhyggeligt tage Vare på dig selv, at du ikke glemmer, hvad du med egne Øjne har set, og at det ikke viger fra dit Hjerte, så længe du lever; og du skal fortælle dine Sønner og dine Sønners Sønner derom. ");
INSERT INTO dan1931_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Glem ikke den Dag, du stod for HERREN din Guds Åsyn ved Horeb, da HERREN sagde til mig: “Kald mig Folket sammen, for at jeg kan kundgøre dem mine Ord, så de kan lære at frygte mig, så længe de lever på Jorden, og lære deres Sønner det samme!” ");
INSERT INTO dan1931_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Da trådte I frem og stod ved Bjergets Fod, medens Bjerget brændte i lys Lue helt ind i Himmelen, hyllet i Mørke, Skyer og Mulm; ");
INSERT INTO dan1931_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","og da HERREN talede til eder ud fra Ilden, hørte I kun Ordene, men nogen Skikkelse så I ikke, kun en Røst fornam I. ");
INSERT INTO dan1931_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Da kundgjorde han eder sin Pagt, som han bød eder at holde, de ti Ord, og han skrev dem på to Stentavler. ");
INSERT INTO dan1931_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Og mig bød HERREN dengang at lære eder Anordninger og Lovbud, som I skulde overholde idet Land, I nu skal over og tage i Besiddelse. ");
INSERT INTO dan1931_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Eftersom I ikke så nogen Skikkelse, dengang HERREN talede til eder på Horeb ud fra Ilden, så vogt eder nu omhyggeligt for ");
INSERT INTO dan1931_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","at handle så ryggesløst, at I laver eder et Gudebillede, en Stenstøtte i en eller anden Skikkelse, enten det nu er et Afbillede af en Mand eller en Kvinde ");
INSERT INTO dan1931_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","eller et Afbillede af et eller andet Dyr, der lever på Jorden, eller et Afbillede af en eller anden vinget Fugl, der flyver under Himmelen, ");
INSERT INTO dan1931_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","eller et Afbillede af et eller andet Kryb, der kryber på Jorden, eller et Afbillede af en eller anden Fisk i Vandet under Jorden; ");
INSERT INTO dan1931_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","og når du løfter dit Blik til Himmelen og ser Solen og Månen og Stjernerne, hele Himmelens Hær, så vogt dig for at lade dig forføre til at tilbede og dyrke dem. Thi HERREN din Gud har tildelt alle de andre Folk under hele Himmelen dem; ");
INSERT INTO dan1931_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","men eder tog HERREN og førte ud af Smelteovnen, af Ægypten, for at I skulde være hans Ejendomsfolk, som I nu er. ");
INSERT INTO dan1931_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Men HERREN blev vred på mig for eders Skyld og svor, at jeg ikke skulde komme over Jordan ind i det herlige Land, som HERREN din Gud vil give dig i Eje, ");
INSERT INTO dan1931_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","thi jeg skal dø i Landet her; jeg skal ikke komme over Jordan, men I skal komme over og tage dette herlige Land i Besiddelse. ");
INSERT INTO dan1931_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Så vogt eder for at glemme HERREN eders Guds Pagt, som han sluttede med eder, og for at lave eder noget Gudebillede i Skikkelse af noget som helst, HERREN din Gud har forbudt dig. ");
INSERT INTO dan1931_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Thi HERREN din Gud er en fortærende Ild, en nidkær Gud! ");
INSERT INTO dan1931_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Når du får Børn og Børnebørn, og I bliver gamle i Landet, og I da handler så ryggesløst, at I laver eder Gudebilleder i en eller anden Skikkelse og gør, hvad der er ondt i HERREN din Guds Øjne, så at I fortørner ham, ");
INSERT INTO dan1931_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","så kalder jeg i Dag Himmelen og Jorden til Vidne imod eder på, at I hastigt skal blive udryddet af det Land, I skal over Jordan og tage i Besiddelse; I skal ikke få noget langt Liv der, men visselig gå til Grunde; ");
INSERT INTO dan1931_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","og HERREN vil splitte eder mellem Folkene, og kun nogle få af eder skal blive tilbage blandt de Folkeslag, HERREN driver eder hen iblandt. ");
INSERT INTO dan1931_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Der skal I komme til at dyrke Guder, der er Menneskehænders Værk, Træ og Sten, som hverken kan se eller høre, spise eller lugte! ");
INSERT INTO dan1931_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Der skal I så søge HERREN din Gud, og du skal finde ham, når du søger ham af hele dit Hjerte og hele din Sjæl. ");
INSERT INTO dan1931_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","I de kommende Dage, når du er i Nød, og alle disse Ting kommer over dig, skal du vende om til HERREN din Gud og adlyde hans Røst. ");
INSERT INTO dan1931_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Thi en barmhjertig Gud er HERREN din Gud; han slipper dig ikke og lader dig ikke gå til Grunde og glemmer ikke Pagten med dine Fædre, som han tilsvor dem. ");
INSERT INTO dan1931_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Thi gransk dog i de henfarne Tider, der gik forud for dig, lige fra den Tid af da Gud skabte Menneskene på Jorden, og fra den ene Ende af Himmelen til den anden, om der er sket noget så stort som dette, eller om dets Lige er hørt. ");
INSERT INTO dan1931_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Har noget Folk hørt Guds Røst ud fra Ilden, således som du hørte det, og levet? ");
INSERT INTO dan1931_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Eller har nogen Gud søgt at komme og hente sig et Folk midt ud af et andet Folk ved Prøvelser, Tegn og Undere, ved Krig, med stærk Hånd og udstrakt Arm og store Rædsler, således som du med egne Øjne så HERREN eders Gud gøre med eder i Ægypten? ");
INSERT INTO dan1931_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Du fik det at se, for at du skulde vide, at HERREN og ingen anden er Gud. ");
INSERT INTO dan1931_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Fra Himmelen lod han dig høre sin Røst for at undervise dig, og på Jorden lod han dig se sin store Ild, og hans Ord hørte du ud fra Ilden. ");
INSERT INTO dan1931_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Og fordi han elskede dine Fædre og udvalgte deres Afkom efter dem og selv førte dig ud af Ægypten ved sin store Vælde ");
INSERT INTO dan1931_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","for at drive Folk bort foran dig, der er større og mægtigere end du selv, og lade dig komme ind i deres Land og give dig det i Eje, som det nu er sket, ");
INSERT INTO dan1931_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","derfor skal du i Dag vide og lægge dig på Sinde, at HERREN og ingen anden er Gud oppe i Himmelen og nede på Jorden. ");
INSERT INTO dan1931_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Og du skal holde hans Anordninger og Bud, som jeg pålægger dig i Dag, for at det kan gå dig og dine Børn efter dig vel, og for at du alle Dage kan leve længe i det Land, HERREN din Gud giver dig! ");
INSERT INTO dan1931_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","På den Tid udskilte Moses tre Byer hinsides Jordan, på den østre Side, ");
INSERT INTO dan1931_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","som Tilflugtssteder for Manddrabere, der uforsætligt slår et andet Menneske ihjel uden i Forvejen at have båret Nag til ham, for at de kan redde Livet ved at ty til en af disse Byer, ");
INSERT INTO dan1931_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","nemlig Bezer i Ørkenen på Højsletten for Rubenitterne, Ramot i Gilead for Gaditterne og Golan i Basan for Manassitterne. ");
INSERT INTO dan1931_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Dette er den Lov, Moses forelagde Israelitterne. ");
INSERT INTO dan1931_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Dette er de Vidnesbyrd, Anordninger og Lovbud, Moses kundgjorde Israelitterne, da de drog bort fra Ægypten, ");
INSERT INTO dan1931_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","hinsides Jordan i Dalen lige for Bet-Peor i det Land, der havde tilhørt Amoritterkongen Sihon, som boede i Hesjbon, og som Moses og Israelitterne