﻿USE sofia;
DROP TABLE IF EXISTS sofia.daf_vpl;
CREATE TABLE daf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES daf_vpl WRITE;
INSERT INTO daf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu 'ö Atanna ‑ya ‑ya Mɛdhamɛ 'ka bha‑ \"bhɛma ‑nu 'tɔ ‑bhiëë ꞊nɛ: 'Mɛ 'wo ‑gban Ablaamö bha 'ö dho 'ö zun‑ 'ka Davi ‑bha, 'ö go Davi ‑bha 'ö dho 'ö zun Yesu ‑bha. ‑A ‑mɛ \"gblʋ̈gblʋ̈ ‑wo ꞊plɛ, wo ꞊në‑ 'wo Ablaamö waa‑ Davi ‑a ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaamö bha ꞊në Izaakö kpɔ, 'yö Izaakö ‑yö Zakɔbö kpɔ, 'yö Zakɔbö ‑dɩ 'pö 'ö Zuda waa‑ ö dheebhang ‑nu ‑a ‑nu kpɔ. ");
INSERT INTO daf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","꞊Dhɛ 'ö Zuda ꞊ya Fadhɛzö waa‑ Zedha ‑a ‑nu kpɔ, ‑a ‑nu dhe 'wo‑ ‑dhɛ Tama bha‑ \"dhiʋ̈, 'yö Fadhɛzö ‑dɩ 'pö 'ö Eslɔɔmö kpɔ, 'yö Eslɔɔmö ‑yö Adhamö kpɔ, ");
INSERT INTO daf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","'yö Adhamö ‑yö Abinadabö kpɔ, 'yö Abinadabö ‑yö Naasɔn kpɔ, 'yö Naasɔn ‑yö Samɔ kpɔ, ");
INSERT INTO daf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","'yö Samɔ ‑yö Boazö kpɔ Dhaabö \"dhiʋ̈, 'yö Boazö ‑yö Obɛdö kpɔ, 'yö 'wo‑ ‑bha dhe ‑dhɛ 'pö Dhutö. Obɛdö bha ꞊në Izai kpɔ, ");
INSERT INTO daf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","'yö Izai ‑zë 'ö gun ‑na ‑gblüdë Davi 'kpɔ. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Davi ‑yö Sadhomɔ kpɔ, Sadhomɔ bha ꞊në‑ dhe ‑yö gun Udhi ‑bha dhebhɔ 'ka \"kɛɛ 'yö Davi ‑ya bho‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","'Yö Sadhomɔ ‑yö Dhoboamö kpɔ, 'yö 'wo Dhoboamö gbö ‑dhɛ Abia, 'yö 'wo Abia gbö ‑dhɛ Aza. ");
INSERT INTO daf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza ‑bha gbö ꞊nɛ 'wo‑ ‑dhɛ 'pö Zozafa, 'yö 'wo Zozafa gbö ‑dhɛ Zolamö, 'yö 'wo Zolamö gbö ‑dhɛ Ozia, ");
INSERT INTO daf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozia bha ꞊në Zoatamö kpɔ, 'yö Zoatamö ‑yö Akazö kpɔ, 'yö Akazö ‑yö Ezekiasö kpɔ, ");
INSERT INTO daf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","'yö 'wo Ezekiasö gbö ‑dhɛ 'pö Manase, 'yö Manase ‑yö Amɔ kpɔ, 'yö Amɔ ‑yö Zozia kpɔ. ");
INSERT INTO daf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zozia bha 'yö Zekonia waa‑ ö dheebhang ‑nu ‑a ‑nu kpɔ \"tʋ̈ng 'wo Izraɛdhö ‑mɛ ‑nu kun‑ 'ka 'wo dho‑ ‑nu 'ka ꞊dhuëngdhɛ 'gü Babidhɔnö bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","꞊Dhɛ 'ö Izraɛdhö ‑mɛ ‑nu ꞊wa 'go Babidhɔnö ꞊wa nu, 'yö Zekonia ‑yö Sadhasiɛdhö kpɔ, 'yö Sadhasiɛdhö ‑yö Zodhobabɛdhö kpɔ. ");
INSERT INTO daf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","'Yö Zodhobabɛdhö ‑yö Abiudö kpɔ, 'yö Abiudö ‑yö Edhiakimö kpɔ, 'yö Edhiakimö ‑yö Azɔɔ kpɔ, ");
INSERT INTO daf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","'yö Azɔɔ ‑yö Sadɔkö kpɔ, 'yö Sadɔkö ‑yö Asimö kpɔ, 'yö Asimö ‑yö Edhiudö kpɔ, ");
INSERT INTO daf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Edhiudö bha 'yö Edheazaa kpɔ, 'yö Edheazaa ‑yö Matan kpɔ, Matan bha ꞊në Zakɔbö kpɔ, ");
INSERT INTO daf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","'yö Zakɔbö ‑yö Zosɛfu 'ö ‑kë Madhi 'ö Yesu 'wo‑ ‑dhɛ Atanna ‑bha ‑Yamɛ bha‑ kpɔ bha‑ ‑bha gɔn 'ka bha‑ kpɔ. ");
INSERT INTO daf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yesu \"bhɛma ‑nu 'ö go Ablaamö ‑bha 'ö dho 'ö zun Davi ‑bha ‑wo mɛ ‑kaɔng do ga ‑yiisiö, 'yö 'mɛ 'wo go Davi ‑bha 'wo dho 'wo zun \"tʋ̈ng 'wo Izraɛdhö ‑mɛ ‑nu kun‑ 'ka, 'wo dho Babidhɔnö ‑a ‑bha bha 'wo ‑kaɔng do ga ‑yiisiö 'pö, 'yö 'mɛ 'wo go 'pö \"tʋ̈ng 'dhɛ bha‑ ‑bha 'wo nu 'wo zun‑ 'ka Atanna ‑bha ‑Yamɛ bhɔ \"tʋ̈ng ‑bha 'pö 'wo ‑kaɔng do ga ‑yiisiö. ");
INSERT INTO daf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","‑Kɔ 'ö Yesu Klisi ‑yö bhɔ‑ 'ka ‑kaa ‑ga 'ö ya: Madhi 'ö ‑kë Yesu 'kpɔdhe 'ka bha ‑yö ‑gun Zosɛfu dhɔɔbhaa ‑mɛ 'ka. ‑Wo ‑to ‑dhɔ bha ꞊në‑ 'gü kö 'wii ‑da ꞊kö wo 'ko ꞊keng‑ \"ɛɛn kö Madhi 'yii ‑da ꞊kö Zosɛfu ‑gɔ 'kɔɔdhö kö ‑yö kë‑ ‑bha dhe 'ka, 'yö Madhi ‑yö 'gu sü Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑bha 'gügbɩɩdhɛ ‑kɔ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","꞊Dhɛ 'ö ‑kë ꞊dhɛ Zosɛfu 'ö ‑kë Madhi dhɔɔbhaamɛ 'ka bha ‑yö ‑gun \"klʋsëmɛ 'ka, 'ö 'yaa gun‑ \"piʋ̈ ꞊dhɛ 'ö Madhi \"pëng ‑pɛn bha, 'yö‑ ‑ya ö zuë\" \"piʋ̈ ꞊dhɛ waa‑ Madhi 'wo \"kan ‑bin 'gü 'gu 'ö‑ sü \"dhʋ̈ bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","꞊Dhɛ 'ö ö ‑zʋ 'gɔn sië 'wɔn bha‑ 'gü \"dhʋ̈, 'yö kwa Dëmɛ ‑bha \"kië do ‑yö ö ‑dɩ ‑zɔn ‑dhɛ kö ‑yö yi zë sië 'yö‑ pö‑ ‑dhɛ: «Zosɛfu, Davi suu 'gü ‑në, \"sika 'ya 'dho ‑da i 'gü Madhi ‑sü i ‑bha dhe 'ka ‑sü ‑wɔn 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'gu 'ö‑ sü bha‑ ‑dɩ 'gü \"slë 'yaa ‑mü, \"kɛɛ Atanna ‑bha 'Nii‑ ‑bha 'gügbɩɩdhɛ ꞊në‑ ‑kë 'yö 'gbiödhe 'ka bha. ");
INSERT INTO daf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","'Në 'ö dho‑ 'kpɔ bha 'nëgɔɔn ‑mü. ꞊Yaa‑ 'kpɔ, 'i‑ ‑dhɛ Yesu, (꞊Waa‑ pö \"dhʋ̈ kö ‑wa ‑pö ‹Mɛdhamɛ›). ‑A ‑gɛn ‑mü ꞊dhɛ 'në bha ꞊në dho ö ‑bha \"sɛgümɛ ‑nu ‑gɔ ‑ta 'dhɔ ‑a ‑nu ‑bha 'wɔn yaa ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","'Wɔn ‑nu 'wo \"dhʋ̈ bha ‑wo ‑kë \"dhʋ̈ kö 'pë 'ö kwa Dëmɛ Atanna ‑yö bɔ‑ 'ka ö ‑wʋdhiʋ̈loomɛ ‑ta 'ö‑ pö yi 'bha 'ka bha ꞊në‑ ‑nu 'gü ‑wɔn ‑yö kë. ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","(Ka ‑dho \"kan ka ‑ta kö) 'nëdhebhɔ do 'ö 'yii ‑zuö gɔɔn‑ ‑bha do ꞊ya 'gu 'sü kö ꞊ya 'nëgɔɔn do 'kpɔ, ‑a 'në bha ‑wo ‑dho ‑a ‑dhɛ Maniɛ.» (꞊Waa‑ pö \"dhʋ̈ kö ‑wa pö ‹Atanna ‑yö kwa \"piʋ̈›.) ");
INSERT INTO daf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","꞊Dhɛ 'ö Zosɛfu ꞊ya ‑bö, 'yö‑ ‑kë ꞊dhɛ ‑kɔ 'ö Atanna ‑bha \"kië ‑ya pö‑ 'ka‑ ‑dhɛ bha‑ 'dhö, 'yö Madhi sü dhe 'ka, ");
INSERT INTO daf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","\"kɛɛ ‑a ‑nu ‑bha sɛɛ\" 'yii kë do 'ö dho 'ö zun‑ 'ka Madhi 'në 'kpɔ ‑yi ‑bha. ꞊Dhɛ 'ö ꞊yaa‑ 'kpɔ, 'yö Zosɛfu ‑ya 'tɔ kpɔ, 'yö 'wo‑ ‑dhɛ Yesu. ");
INSERT INTO daf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu ‑yö ‑bhɔ Zude ‑pö do 'bha 'wo‑ ‑dhɛ Betedhɛmö bha ꞊në‑ 'gü Edhodö ‑bha ‑gblüdëdhɛ \"tʋ̈ng 'gü. ꞊Dhɛ 'ö ꞊ya bhɔ, 'yö 'wɔndɔmɛ ‑nu 'wo \"susëngga ‑nu ‑bho 'koo ‑dɔ bha 'wo go \"sɛgɔ 'bha 'ö 'yënng‑ ‑wo ‑zian 'ka ‑a 'gü bha 'wo nu 'wo ꞊loo Zedhizadhɛmö. ");
INSERT INTO daf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","'Yö 'wo mɛ ‑nu dhɛɛ\" kpɔ 'wo‑ pö: «'Në 'ö dho kë Zuifö ‑nu ‑bha ‑gblüdë 'ka 'ö bhɔ yö bha ‑yö 'mɛ? Yi‑ ‑bha \"susëngga ‑yö kö ꞊ya ‑wo \"yɛa‑ yi ‑gɔ \"sɛ 'gü 'yënng‑ ‑wo ‑zian 'ka 'yö 'yi nu kö 'yi‑ ‑dhɔkë.» ");
INSERT INTO daf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","꞊Dhɛ 'ö ‑gblüdë Edhodö ꞊ya 'wɔn bha‑ ma, 'yö \"sika 'dhö ‑da waa‑ Zedhizadhɛmö ‑mɛ ‑nu ꞊gban \"pɛpɛ 'gü (kö ‑yö ö ‑zʋ 'gɔn sië ꞊dhɛ ‑gblüdë ‑dee 'dhɛ 'ö bhɔ bha yöö ö ‑bha mɛdhɛ kɔɔ‑ ö 'ka). ");
INSERT INTO daf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","'Yö 'wo \"saabhomɛ ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu 'wo‑ ‑gɔ \"sɛ bha‑ 'gü ‑a ‑nu ꞊gban \"pɛpɛ ꞊loo 'ko ‑ta, 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Dhɛ ‑mɛɛ ꞊në Atanna ‑bha ‑Yamɛ dho bhɔ‑ ‑bha 'wo‑ pö 'kpa 'ö 'ka‑ dɔ?» ");
INSERT INTO daf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","'Yö 'wo‑ pö‑ ‑dhɛ: «‑Wa ‑dhɛ ‑dhɛ Betedhɛmö, ‑a ‑dhɛ ‑yö Zude ‑sɛ 'gü.» ‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ‑ya ‑ya Atanna ‑bha 'sëëdhɛ 'gü 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«Betedhɛmö ‑pö 'i Zude ‑sɛ 'gü, bhi ‑zë 'bhii kë 'pödhɛ 'tɔbhɔsü ‑nu 'wo Zude ‑sɛ 'gü ‑a ‑bhaasü ‑sü 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ ‑gblüdë do‑ ‑dho 'go i 'gü, 'ö zun ma Izraɛdhö ‑sɛgümɛ ‑nu ‑dhɛ \"dhiʋ̈ ꞊dhɛ ‑kɔ 'ö ‑tuʋ̈ ‑maakëmɛ ‑yö zun‑ 'ka ‑tuʋ̈ ‑nu ‑dhɛ \"dhiʋ̈ bha‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Edhodö ‑yö 'wɔndɔmɛ ‑nu bha‑ ‑nu ‑dhɛ ‑bin 'gü, 'yö‑ ‑nu dhɛɛ\" kpɔ \"tʋ̈ng ꞊dede 'ö \"susëngga bha 'ö ‑wo 'ka ‑a ‑nu ‑dhɛ \"yɛa‑ ‑a 'ka. ");
INSERT INTO daf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö ö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: «‑Ka 'dho Betedhɛmö kö 'ka 'në bha‑ ‑dhɛ mɔɔ‑ ‑së 'ka. ꞊Ya kë ꞊dhɛ 'ka‑ ‑dhɛ yö kö 'ka nu 'ka‑ pö n ‑dhɛ kö mang ‑dɩ 'pö 'a 'dho‑ ‑dhɔkë ‑dhɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","꞊Dhɛ 'ö ‑gblüdë ꞊ya ö ‑wʋ 'kpɔ‑ ‑nu ‑bha ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö 'wo dho. ‑A ‑nu 'dho ‑sü 'ka, 'yö 'wo \"susëngga 'wo‑ yö wo ‑gɔ \"sɛ 'gü 'yënng‑ ‑wo ‑zian 'ka bha‑ yö 'zü ‑deewo kö ꞊ya zun‑ ‑nu ‑dhɛ \"dhiʋ̈, ");
INSERT INTO daf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","꞊Dhɛ 'ö \"susëngga bha ꞊ya 'dho ꞊ya ꞊loo 'kɔ 'ö Yesu \"blë ‑dee ‑yö gun‑ 'gü bha‑ ‑dhɛta \"dhʋ̈ng 'gü, 'yö ö bo \"ta 'sü ‑sü 'ka, 'yö‑ 'gü ‑wɔn ‑yö ‑dhi ‑a ‑nu ‑dhɛ ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","'Yö 'wo dho 'wo ‑da 'kɔ bha‑ 'gü, 'yö 'wo Madhi waa‑ ö gbö Yesu ‑a ‑nu yö, 'yö 'wo zun 'në bha‑ ‑dhɛ wo kpiö 'gü 'yö 'wo 'tɔ ꞊loo‑ ‑bha 'yö 'wo woo‑ ꞊naɔ ꞊kwɛɛ‑ ‑nu \"dhi ‑pʋ, 'yö 'wo \"sënng ‑nu waa‑ pë 'bha ‑nu 'ö ꞊waa‑ \"gʋ̈ 'ö‑ ꞊fii 'dhö ‑kë ‑së ꞊dhɛ ‑dhasiklɔɔ \"yi ꞊fii 'dhö 'wo‑ ‑dhɛ ansansö bha waa‑ \"yi ꞊fii ‑së bha 'wo‑ ‑dhɛ 'pö 'miidhö bha‑ ꞊gbaɔ ‑a ‑nu ‑gɔ. (Pë ‑nu 'wo \"dhʋ̈ bha‑ ‑nu sɔng 'ö 'dhö ‑ma 'yaa‑ wo‑ ‑bha). ");
INSERT INTO daf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Atanna ‑ya pö 'wɔndɔmɛ ‑nu bha‑ ‑nu ‑dhɛ \"yɛɛn ‑wʋ 'gü ꞊dhɛ ‑a ‑nu yee kë ‑sü 'ka 'wa 'dho bɔ Edhodö ‑zian 'ka, \"kɛɛ ‑wo bɔ zian \"wɛɛ 'ka kö ‑wo 'dho wo ‑gɔ \"sɛ 'gü. 'Yö 'wo bɔ zian \"wɛɛ 'ka 'wo dho. ");
INSERT INTO daf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","꞊Dhɛ 'ö 'wɔndɔmɛ ‑nu bha ꞊wa 'dho, 'yö Atanna ‑bha \"kië do ‑yö ö ‑dɩ ‑zɔn Zosɛfu ‑dhɛ kö ‑yö yi zë sië, 'yö‑ pö‑ ‑dhɛ: «Zosɛfu, ‑bhö \"wlü kö 'i 'në waa‑ ö dhe bha‑ ‑nu 'sü kö 'ka 'dho ka ‑gblɛn 'kpɔ Ezitö ‑sɛ 'gü kö ‑yö 'dho ‑yö zun‑ 'ka ‑dhɛkpaɔyi 'a dho‑ pö‑ 'ka i ‑dhɛ ꞊dhɛ 'ka ka yee kë 'ka nu‑ 'ka i ‑gɔ \"sɛ 'gü yö bha‑ ‑bha. ‑A ‑gɛn ‑mü ꞊dhɛ Edhodö ‑dho 'në ya‑ mɔɔ‑ kö 'ö‑ zë.» ");
INSERT INTO daf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Yö Zosɛfu ‑yö ꞊wlü 'yö 'në waa‑ ö dhe bha‑ ‑nu sü gbeng, 'yö dho‑ ‑nu 'ka Ezitö ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","'Yö 'wo to 'mü 'ö dho 'ö zun‑ 'ka Edhodö ga ‑yi ‑bha. 'Wɔn ‑nu bha ‑wo ‑kë \"dhʋ̈ kö 'pë 'ö kwa Dëmɛ ‑ya pö 'ö bɔ‑ 'ka ö ‑wʋdhiʋ̈loomɛ ‑ta bha‑ 'gü ‑wɔn ꞊në ‑yö kë ꞊dhɛ: «'Ma n Gbö ‑dhɛ 'nu kö ‑yö 'go Ezitö ‑sɛ 'gü ‑yö nu.» ");
INSERT INTO daf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","꞊Dhɛ 'ö Edhodö ꞊yaa‑ 'wɔn dɔ ꞊dhɛ 'wɔndɔmɛ ‑nu bha ꞊wa 'kpɔ ö 'ka, 'yö bhlɔɔ ‑yö ma‑ 'gü ꞊dedewo, 'yö‑ pö ö ‑bha \"sɔdha ‑nu ‑dhɛ ‑wo 'dho kö ‑wo 'nëgɔɔn \"pɛpɛ 'kö‑ ‑kwɛ ꞊ya ꞊mɔɔ ꞊plɛ ‑bha, \"ɛɛn ‑a mɛ 'dhɛ ‑zian 'ö‑ ‑nu ‑bha ꞊plɛ ‑naa \"dhiʋ̈ 'yii pa ꞊kö, 'ö 'wo Betedhɛmö ‑dhɛ waa‑ ö ‑züzü ‑dhɛ ‑nu 'gü bha‑ ꞊gban zë, (kë \"dhʋ̈ kö 'në bha 'ya 'dho dha ö ‑gɔ). ‑A kë 'ö‑ wo \"dhʋ̈ bha ‑ya dhʋng ‑sü ‑sü \"tʋ̈ng 'ö 'wɔndɔmɛ ‑nu bha 'wo‑ ꞊kpaɔ‑ 'ka bha ꞊në‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Pë 'ö Atanna ‑wʋdhiʋ̈loomɛ Zedhemi ‑ya pö yi 'bha 'ka bha‑ 'gü ‑wɔn ‑yö ‑kë ‑kɔ bha ꞊në‑ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ");
INSERT INTO daf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Zedhemi ‑ya ‑pö 'ö‑ pö: «꞊Wa mɛ \"gblawʋ ma Dhama ‑pö 'gü, \"gbʋ ꞊gbang 'ö ‑dɔn bho ‑wʋ 'dhö‑ \"piʋ̈ yö ‑mü, Dhasɛdhö suu 'gü ‑në ‑nu ‑bha dhong ‑nu ꞊në 'wo wo bhang ‑nu ‑gbʋ bɔ sië, 'yö 'waa \"wɩ‑ ‑bha kö ‑wa ‑nu ‑dhɛa ga bha, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu bhang ‑nu bha ꞊wa ga.» ");
INSERT INTO daf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","꞊Dhɛ 'ö Edhodö ꞊ya ga, 'yö Atanna ‑bha \"kië do 'bha ‑yö dhiang zë 'zü Zosɛfu ‑dhɛ Ezitö ‑sɛ 'gü kö ‑yö yi zë sië ");
INSERT INTO daf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","'yö‑ pö‑ ‑dhɛ: «‑Bhö \"wlü kö 'i 'në waa‑ ö dhe bha‑ ‑nu 'sü 'zü ‑deewo kö 'ka ka yee kë 'ka 'dho Izraɛdhö ‑sɛ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'wo gun‑ \"piʋ̈ ꞊dhɛ 'wo 'në bha‑ zë bha ꞊wa ga.» ");
INSERT INTO daf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","'Yö Zosɛfu ‑yö ꞊wlü, 'yö 'në waa‑ ö dhe bha‑ ‑nu sü, 'yö 'wo wo yee ‑kë 'wo dho Izraɛdhö ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","\"Kɛɛ ꞊dhɛ 'ö ꞊yaa‑ ma 'zü ꞊dhɛ Asedhausö ꞊ya ‑ya ö dë Edhodö \"gblʋʋ 'gü ‑gblüdëdhɛ 'gü Zude ‑sɛ bha‑ 'gü, 'yö ‑ya \"sɛ ‑gɔ bha‑ 'gü ‑sü \"suʋ̈ ‑ya ‑kë, ꞊dhɛ 'ö ‑kɔ 'ö dho‑ kë‑ 'ka Atanna ꞊yaa‑ ‑zɔn 'zü‑ ‑dhɛ \"yɛɛn ‑wʋ 'gü, ");
INSERT INTO daf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","'yö dho Gadhidhe ‑sɛ 'gü, 'yö ‑ya ‑a 'pö‑ 'kpii‑ do 'wo‑ ‑dhɛ Nazadhɛtö bha‑ 'gü kë \"dhʋ̈ kö 'pë 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑wa pö ꞊dhɛ «‑wo ‑dho ‑a ‑dhɛ Nazadhɛtö mi» bha‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","‑A \"tʋ̈ng 'ö \"dhʋ̈ bha‑ 'gü, 'yö mɛ do 'bha 'wo‑ ‑dhɛ Zan Mɛzumɛ bha 'ö nu \"tʋngtadhɛ 'dhɛ 'ö Zude ‑sɛ 'gü bha‑ 'gü, 'yö ‑ya Atanna ‑bha ‑dhɛa \"dhiʋ̈ bho ‑sü ‑bha mü ");
INSERT INTO daf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","'ö‑ pö: «‑Ka ka kwaa‑ ka kë ‑sɔng yaya ‑nu ‑zü kö 'ka ka zuë\" slëë‑ Atanna \"piʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑bha ‑gblüdëdhɛ ꞊ya ꞊yɔɔn ka \"sɔɔ!» ");
INSERT INTO daf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zan bha ꞊në Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑yö 'wɔn 'ö ‑gban ‑bha ‑a ‑dhiang zë yi 'bha 'ka 'ö‑ pö: «'Mɛ 'ö \"gbla sië \"tʋng ‑ta bha ‑ya pö: ‑Ka kwa Dëmɛ ‑bɔ ‑ta ‑zian baa‑ kö ‑a ‑ta ‑dhɛ ‑yö wɔ ‑tɛkpɛ ‑tɛkpɛdhö, kö 'ka‑ dɔ ꞊zinng 'gü!» ");
INSERT INTO daf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zan bha‑ ‑dasɔ ‑yö ‑gun ‑yɔɔnmɛa kaa‑ ꞊në‑ 'ka, 'yö kwi \"pɛn ‑ya ö ‑gɔ sɔ ‑ta, 'yö ‑kpaa waa‑ \"zɔyɔn ‑nu ‑bhö. (‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'wo gun ‑tosɛa kë sië \"tʋng ‑ta \"tʋ̈ng bha‑ 'gü ‑a ‑nu ‑bhöpë waa‑ ‑nu sɔ ‑da ‑kɔ ꞊në gun bha.) ");
INSERT INTO daf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","'Yö Zedhizadhɛmö ‑mɛ ‑nu waa‑ 'mɛ 'wo Zude ‑sɛ \"pɛpɛ ꞊gban 'gü waa‑ mɛ 'dhɛ 'wo bɔ \"yiga 'kpii‑ 'wo‑ ‑dhɛ Zuudɛn bha‑ \"pɛan \"piʋ̈, ‑a ‑nu ꞊gban \"pɛpɛ 'wo nu‑ \"piʋ̈ mü. ");
INSERT INTO daf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'Yö 'wo wo kë ‑sɔng yaya ꞊gban pö‑ ‑dhɛ mɛ ꞊gban \"yaan mü, 'yö Zan ‑ya ‑nu ‑go 'wɔn yaa 'gü ‑zu bho Zuudɛn ꞊bhaa. ");
INSERT INTO daf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","꞊Dhɛ 'ö Zan ꞊ya Fadhiziɛn ‑nu waa‑ Sadusiɛn ‑nu yö kö ‑wo nu sië ö \"piʋ̈ 'gbɛ kö 'ö‑ ‑nu \"zu, (\"kɛɛ kö ‑ya 'wɔn dɔ ꞊dhɛ 'waa‑ \"piʋ̈ ꞊dhɛ 'wo wo kwaa‑ wo kë ‑sɔng yaya ‑nu ‑zë ‑zü) 'yö‑ pö‑ ‑nu ‑dhɛ: «\"Gblʋ̈ʋ̈dhɛgblɛɛnmɛ ‑nu 'ö 'ka ꞊dhɛ ꞊bhʋ̈ʋ̈ 'dhö ya, 'dee‑ pö ka ‑dhɛ ꞊dhɛ ka ‑mɔɔ ‑bha 'ka dha Atanna ‑bha ‑mawɔnsiödhe yi 'ö nu sië bha‑ ‑gɔ?» ");
INSERT INTO daf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","꞊Dhɛ 'ö ‑kë ꞊dhɛ 'ka ka zuë\" slëë‑ Atanna \"piʋ̈, \"ta ‑kɔ ‑së 'ö dho‑ ‑zɔn ꞊dhɛ 'ka ka zuë\" slëë‑ Atanna \"piʋ̈ ꞊dedewo tɛan‑ 'ka, 'ka \"gla bha ꞊në, ‑kaa kë! ");
INSERT INTO daf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Ka 'dho‑ pö ka ‑dɩ ‑dhɛ ꞊dhɛ: «Ablaamö suu ‑mü yi 'ka, (ö \"dhʋ̈ kö Atanna 'yii 'dho za dɔ ka ‑bha)», ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑mɔɔ ‑bha 'ö ‑gwë ‑nu ya‑ ‑nu ‑gla Ablaamö suu 'gü ‑në ‑nu 'gü! ");
INSERT INTO daf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","꞊Dua ‑yö wɔ ‑sü 'ka \"dhü gɛnngdhö ‑a bɔ ‑yan ‑ta. \"Dhü 'ö 'yii bhɛ ‑së dɔ, ‑wo ‑dho ‑a \"kan 'wo‑ ‑gʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'Yö Zan ‑ya pö 'zü ꞊dhɛ: «Ma ‑zë ‑a ka ‑zu \"yi ꞊në‑ 'ka, kö ‑ya ‑zɔn ꞊dhɛ 'ka ka zuë\" slëë‑, \"kɛɛ mɛ do 'bha ‑dho nu n zian‑ ‑ta bha, yö ‑zë ‑yö ‑dho ka pa‑ ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ waa‑ pɛng ꞊në‑ 'ka. Yö ‑zë ꞊bhlëë ‑yö 'kpii‑ 'ö ‑ziö n ‑ta, ‑a ‑gɛn 'gü ‑sabha ‑zian fië‑ ‑dhö n 'ka. ");
INSERT INTO daf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","‑A ‑bha 'dhaa‑ ‑ya ‑gɔ kö ‑yö ö ‑bha mɛ ‑nu ‑piö 'gü ꞊dhɛ ‑mlü 'dhö, kö ‑ya ga ꞊loo \"bhutu 'gü, kö ‑ya \"kɛa ‑nu waa‑ ꞊flee ‑nu ‑zë \"gʋ̈ pɛng 'ö 'yaa \"dhuu ‑a 'gü. ");
INSERT INTO daf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö go Gadhidhe ‑sɛ 'gü, 'yö nu \"yiga 'wo‑ ‑dhɛ Zuudɛn bha‑ ꞊bhaa Zan \"piʋ̈ kö ‑yö ö \"zu. ");
INSERT INTO daf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","\"Kɛɛ Zan yii‑ \"wɩ‑ ‑bha, 'yö‑ ‑yɔ bɔ‑ ‑gɔ 'yö‑ pö‑ ‑dhɛ: «Ma 'kö ma ‑zë maa nu i \"piʋ̈ kö 'i n \"zu kö 'a kë \"slʋ̈ʋ̈slʋ̈ bha 'yö bhi ꞊në 'i nu n \"piʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","\"Kɛɛ 'yö Yesu ‑ya pö‑ ‑dhɛ 'ö‑ pö: «‑Bhö \"wɩ‑ ‑bha kö ‑yö kë \"dhʋ̈ ꞊kö \"tʋ̈ng ya‑ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑dhɛa ‑bha ‑dhɛ 'a‑ kë ꞊dhɛ ‑kɔ 'ö Atanna ‑ya pö‑ 'ka ꞊në‑ 'dhö.» 'Yö Zan ‑yö ‑wɩ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","꞊Dhɛ 'ö Yesu 'dhö 'go sië \"yi ꞊bhaa (kö Zan ꞊ya bo‑ \"zu ‑sü 'ka), 'ö dho ‑dhɛ ‑ga kö dhang‑ \"dhi ꞊ya \"pʋ ‑a wëëdhö kö Atanna ‑bha 'Nii‑ ‑yö 'go sië dhang‑ 'gü 'ö ꞊lɔɔ‑ ‑ta ꞊dhɛ ‑tong 'dhö, ");
INSERT INTO daf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","'yö‑ \"tʋ 'dhö ‑da 'zü ‑wʋ do 'bha 'gü kö ‑yö \"wɩ sië dhang‑ 'gü 'ö‑ pö: «N Gbö doseng 'ö n ‑gɔ 'yö dɔ bha‑ ‑dhɔ 'ö n kë ‑a \"sinma 'yaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Atanna ‑bha 'Nii‑ ‑yö zun Yesu ‑dhɛ \"dhiʋ̈ 'yö dho‑ 'ka \"tʋng ‑ta kö Sɔtraan ‑ya 'gü dan. ");
INSERT INTO daf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","'Yö ‑ziö 'ö dho mü. ꞊Dhɛ 'ö ꞊ya 'sunng‑ 'ma ‑dhɛkpaɔyi ‑kaɔng ‑yiisiö 'ka 'yënng‑ 'gü waa‑ gbeng 'gü, 'yö din‑ ‑ya kun. ");
INSERT INTO daf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Yö Sɔtraan ‑yö ꞊yɔɔn‑ \"sɔɔ 'yö‑ pö‑ ‑dhɛ: «꞊Ya kë ꞊dhɛ 'i Atanna Gbö 'ka ꞊dedewo tɛan‑ 'ka, ‑bhö dhiang zë ‑gwë ‑nu ya‑ ‑nu ‑dhɛ kö ‑wo \"gla ‑bhöpë 'gü kö 'i‑ ‑bhö!» ");
INSERT INTO daf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Abin, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü ꞊dhɛ: ‹‑Bhöpë yöö do 'aa mü 'ö mɛ ‑bha ‑tosɛa ‑kë ‑bha ‑pë 'ka, mɛ‑ mɔɔ‑ ‑bha 'ö mɛ ‑yö ‑tosɛa ‑kë 'pö ‑wʋ \"pɛpɛ 'ö go Atanna \"dhi ‑a ‑bha.› ");
INSERT INTO daf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","꞊Dhɛ 'ö ꞊yaa‑ pö‑ ‑dhɛ \"dhʋ̈, 'yö‑ sü 'zü ‑deewo 'ö dho‑ 'ka 'pödhɛ \"slʋ̈ʋ̈slʋ̈ 'wo‑ Zedhizadhɛmö ‑dhɛ ‑kë bha‑ 'gü, 'yö‑ dɔ Atanna ‑dhɔkëgükɔ 'ö mü bha‑ ‑ta \"dhʋ̈ng 'gü, ");
INSERT INTO daf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'yö‑ pö‑ ‑dhɛ 'zü ‑deewo 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'i Atanna Gbö 'ka ꞊dedewo, ‑bhö dɔ yö kö 'i kwaa‑ i ‑dɩ ‑zü \"sia‑ ꞊kö 'dhɛ ꞊ee! ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'gü ꞊dhɛ: ‹Atanna ‑dho ö ‑bha \"kië ‑nu bɔ 'ö 'wo ‑kɔ kpɔ i ‑gɔ kö i ‑gɛn \"dhiʋ̈ 'ya 'dho ‑zuö ‑gwë ‑bha.› ");
INSERT INTO daf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","'Yö Yesu ‑ya pö 'pö‑ ‑dhɛ 'zü 'ö‑ pö: «‑Abin, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka 'pö Atanna ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: ‹'Bha 'dho i Dëmɛ 'ö i ‑bha Atanna 'ka bha‑ 'gü dan!› ");
INSERT INTO daf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","꞊Dhɛ 'ö ꞊waa‑ pö wo 'ko ‑dhɛ \"dhʋ̈, 'yö Sɔtraan ‑yö Yesu sü 'zü ‑dee wo 'ö dho‑ 'ka ‑tɔn ꞊gblɛɛn do ꞊gbin‑, 'yö \"sɛ \"pɛpɛ 'ö \"kpʋng ꞊taa ‑a ꞊gban ‑zɔn ‑dhɛ waa‑ ‑nu ‑bha ‑sëdhɛ ‑nu 'dhö ");
INSERT INTO daf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'yö‑ pö‑ ‑dhɛ: «‑Bhö ‑dhɛ ‑ga, ꞊ya kë ꞊dhɛ 'bha zun n ‑dhɛ kpiö 'gü, kö 'i n ‑dhɔkë, a ‑dho pë \"pɛpɛ bha‑ ꞊gban nu i ‑dhɛ kö 'i ‑ya ‑gɔ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Sɔtraan, ‑bhö ziö 'i 'go bha, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü ꞊dhɛ: ‹I ‑dho i Dëmɛ, i ‑bha Atanna yöö do ꞊në‑ ‑dhɔkë, 'bhii 'dho pë \"wɛɛ 'bha ‑dhɔkë yö ‑zë zian 'gü›. ");
INSERT INTO daf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Sɔtraan ‑yö ö ꞊kwaa‑ ‑zü ꞊kö ‑a 'dhɛ bha‑ 'gü 'yö dho. 'Yö Atanna ‑bha \"kië ‑nu 'wo nu‑ \"sɔɔ mü 'yö 'wo zun‑ 'gü ‑ziö wo ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","꞊Dhɛ 'ö Yesu ꞊yaa‑ ma ꞊dhɛ ꞊wa Zan ‑da ‑kaso 'gü, 'yö dho Gadhidhe ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","\"Kɛɛ 'yii \"wɩ‑ ‑bha kö ‑yö ‑ya Nazadhɛtö ‑pö 'ö \"klʋ bho‑ 'gü bha‑ 'gü, 'yö dho 'yö ‑ya Kapɛɛnaɔmö ‑pö 'ö ‑ya ‑sü 'ka \"yitagbɛa 'ö Gadhidhe, Zabidhɔng ‑sɛ waa‑ Nɛfutali ‑sɛ ‑a ‑nu 'gü bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","‑A ‑kë 'ö‑ wo \"dhʋ̈ bha ꞊në ‑kë ‑wʋ 'ö Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑ya pö yi 'bha 'ka bha‑ 'gü ‑wɔn kë ‑kɔ 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ Ezai ‑ya ‑pö yi 'bha 'ka 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zabidhɔng ‑sɛ waa‑ Nɛfutali ‑sɛ 'ö 'ka ꞊wee ‑yi \"pɛan \"piʋ̈ Zuudɛn ꞊taama, 'ö 'kaa Zuifö 'ka, a‑ ‑pö ka ‑dhɛ ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","'mɛ 'wo ‑tosɛa kë sië ‑dhɛtiidhɛ 'gü ('ö 'waa Atanna dɔ) bha, ‑dhɛpuudhɛ ‑dho 'sɔ‑ ‑nu ‑ta ('ö 'wo‑ dɔ)! 'Ö 'mɛ 'wo ‑tosɛa kë sië ‑dhɛ 'ö ga dhɔng ꞊ya ‑dhɛ tröö‑ ‑ta ('waa Atanna dɔ ‑sü ‑wɔn 'gü) bha, 'wo ‑dhɛpuudhɛ yö ('ö 'wo‑ dɔ).» ");
INSERT INTO daf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesu ‑yö ö ‑bha 'wɔn ‑taɔng ‑së pö ‑sü 'zü ‑bho \"tʋ̈ng bha ꞊në‑ 'gü 'yö‑ pö: «‑Ka ka zuë\" slëë‑ Atanna \"piʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑bha ‑gblüdëdhɛ ꞊ya ꞊tëng ka ‑ta!» ");
INSERT INTO daf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö ‑kpan 'nëglɔɔn ‑nu ꞊plɛ 'wo ‑kë dheebhangzë ‑nu 'ka, 'wo ‑kë \"nuuzuömɛ 'ka, 'ö 'wo‑ mɛ do ‑dhɛ Simɔ 'wo‑ 'tɔ ꞊ya ‑ta ‑dhɛ Piɛdhö bha waa‑ dheebhang Andre, ‑a ‑nu ‑bha kö ‑wo woo‑ \"nuu ‑zuö sië \"yi ‑ta \"gbɛa 'ö Gadhidhe bha‑ ꞊bhaa, kö yöö ‑dɩ 'pö ‑yö \"ta 'sü sië \"yi bha‑ \"kpʋng \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","'Yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka nu 'kwa 'dho! A ‑dho ka kë \"nuu ‑zuö mɛ ‑gɔ ‑mɛ 'ka kö 'ka nu‑ ‑nu 'ka n ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","꞊Dhɛ 'ö ꞊waa‑ ma \"dhʋ̈, ‑wo ‑to ‑dhɛ do bha‑ 'gü 'wo wo ꞊kwaa woo‑ \"nuu ‑nu bha‑ ‑nu ‑zü 'wo ‑ziö ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","꞊Dhɛ 'ö ꞊ya ꞊yɔɔn ö \"dhiʋ̈ 'zü 'dɛdɛ, 'yö ‑kpan 'zü dheebhangzë ‑nu ꞊plɛ 'wo‑ mɛ do ‑dhɛ Zakö 'wo‑ mɛ do ‑dhɛ Zan, 'wo ‑kë Zebede gbö ‑nu 'ka 'pö bha‑ ‑nu ‑bha waa‑ ‑nu dë 'dhö kö ‑wo \"kplagɔnë 'gü kö ‑wo woo‑ \"nuu ‑nu pë kë sië, 'yö‑ ‑nu ‑dhɛ 'pö. ");
INSERT INTO daf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","‑Wo ‑to ‑dhɛ do bha‑ 'gü 'pö 'wo wo dë oo, ‑a \"yitagɔ oo, (‑a \"nuu ‑nu oo), ‑a ꞊gban \"pɛpɛ to, 'yö 'wo ‑ziö Yesu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ‑gun ziö sië ‑kɔ bha ꞊në‑ 'gü Gadhidhe ‑sɛ ꞊gban \"pɛpɛ 'gü Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü mɛ ‑nu ꞊klang ‑kë Atanna ‑wʋ 'ka ‑sü ‑nu waa‑ 'wɔn ‑taɔng ‑së 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑bha bha‑ ‑dhiang zë ‑sü 'ka. 'Yö \"yua suu ꞊gban \"pɛpɛ bho mɛ ‑nu bha, 'yö ꞊niɔɔmɛ ꞊gban \"pɛpɛ ꞊niɔɔdhɛ ‑nu bho‑ ‑nu ‑bha 'pö. ");
INSERT INTO daf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","'Yö‑ 'tɔ 'dhö ‑ya bhɔ ‑sü ‑bha Siidhi ‑sɛ 'gü ‑dhɛ ꞊gban \"pɛpɛ 'gü, 'yö \"yua suu \"ʋʋ suu 'ö 'mɛ 'kö‑ ‑nu ‑bha \"sɛ bha‑ 'gü 'ö sëë ‑zë bho sië, 'yö 'wo ‑ya nu ‑sü ‑bha ‑a ‑nu 'ka ‑a ‑dhɛ. \"Yina yaa 'dhö 'mɛ ‑nu 'ö‑ ‑nu 'gü waa‑ glɔɔdhɛmɛ ‑nu waa‑ ‑gɛnloomɛ ‑nu, 'yö‑ ‑nu ꞊gban ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","'Yö mɛ \"dhaa ‑yö ‑ya ‑klëën ‑zü ‑sü ‑bha, 'mɛ 'wo go Gadhidhe oo, 'wo go 'pö‑ \"gblʋ̈gblʋ̈ ‑kaɔng do 'wo \"sɛ 'ö‑ 'gü bha‑ 'gü oo, 'mɛ 'wo go Zedhizadhɛmö ‑dhɛ waa‑ Zude ‑dhɛ ‑nu 'gü oo, mɛ 'dhɛ 'wo go \"sɛ \"pɛan 'dhɛ 'ö Zuudɛn ꞊taama bha‑ 'gü, 'yö 'wo ‑ya ziö ‑sü ‑bha ‑a ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","꞊Dhɛ 'ö Yesu ꞊ya mɛ \"bhɩɩ‑ \"dhaa bha‑ yö kö ꞊wa ꞊klëën ö ‑zü ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö ‑da ‑tɔn 'në 'bha bha‑ ꞊gbin‑ 'yö 'yaanu. 'Yö‑ ‑bha ꞊klangdhiʋ̈ ‑nu 'wo ‑da 'pö‑ ꞊keng‑ mü. ");
INSERT INTO daf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'Yö ‑ya dhiang zë ‑sü ‑bha ‑a ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«'Mɛ 'wo‑ 'wɔn dɔ wo zuë\" \"piʋ̈ ꞊dhɛ 'waa pë 'bha 'ka Atanna wëëdhö bha‑ ‑nu ‑bha ‑së; ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑bha ‑gblüdëdhɛ bha ‑ya wo ꞊në‑ ‑nu ‑bha 'ka. ");
INSERT INTO daf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","'Mɛ 'wo \"gbʋ bɔ sië \"tʋ̈ng ya‑ 'gü ‑a ‑nu ‑bha ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑dho ‑a ‑nu ‑dhɛa ga. ");
INSERT INTO daf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","'Mɛ 'ö 'wɔn 'yaa ‑siö ‑nu ‑dhɛ bha‑ ‑nu ‑bha ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑dho \"sɛ nu‑ ‑nu ‑dhɛ yi do 'ka ꞊dhɛ ‑kɔ 'ö‑ \"plüün bho‑ 'ka bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","'Mɛ 'ö Atanna dhɔɔbhaa kë ‑sü ‑dhɔ ‑ya ‑nu ‑kë 'böbödhö 'ö 'wo ‑ya ‑a zuën ‑ta bha‑ ‑nu ‑bha ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑dho ‑a ‑kë \"dhʋ̈ ‑sü ‑faan nu‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","'Mɛ 'ö mɛ ‑wëë ‑ya ‑nu ‑kë ‑a ‑nu ‑bha ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑dho ‑a ‑nu ‑wëëdhɛ yö 'pö. ");
INSERT INTO daf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","'Mɛ 'ö‑ ‑nu zuëpiʋ̈dhɛ 'dhö \"puu ‑a ‑nu ‑bha ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ ‑wo ‑dho Atanna yö. ");
INSERT INTO daf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","'Mɛ 'wo mɛ ‑nu ‑kɔ wü 'koo ‑a ‑nu ‑bha ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑dho ‑a ‑nu ‑dhɛ ö bhang ‑nu. ");
INSERT INTO daf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mɛ 'wo‑ ‑nu ‑wëëdhɛ bho sië Atanna dhɔɔbhaa kë ‑sü ‑wɔn 'gü ‑a ‑nu ‑bha ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑bha ‑gblüdëdhɛ ‑ya wo ꞊në‑ ‑nu ‑bha 'ka. ");
INSERT INTO daf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","꞊Wa \"si bho ka ‑gɔ kö ‑wo ka ‑wëë ‑kë ꞊gban \"pɛpɛ suu wo, kö ‑wo ꞊sua ‑nu ‑ya ka ‑bha, kö ‑wo dhiang yaa ꞊gban suu 'do 'do zë ka ‑bha ka ‑bha ‑kë n ‑bha 'ka ‑sü ‑wɔn 'gü kö ka ‑bha ꞊ya kë ‑së, ");
INSERT INTO daf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ka ꞊nii ‑yö ‑da kö 'ka ka \"dhia bho, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ꞊trɔɔn 'kpii‑ ‑yö ‑ya ‑sü 'ka ka ‑gɔ dhang‑ 'gü. ‑Kɔ 'wo Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'wo gun ka \"dhiʋ̈ ‑a ‑nu ‑wëëdhɛ bho‑ 'ka yi 'bha 'ka 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","'Yö‑ pö: «Ka ꞊në 'ka ꞊dhɛ \"kpʋngtaadhɛ ‑bha ꞊wee 'dhö, \"kɛɛ ꞊wee ‑zë ꞊ya kë 'ɔtɔɔ, ‑më ꞊në 'wo dho‑ ‑da ‑bha 'zü ‑deewo kö ‑yö kë \"nɛɛnɛɛ? ꞊Ya kë \"dhʋ̈ kö‑ ‑zun \"dhiʋ̈ ‑bhlɔɔ 'yaa 'dhö 'zü, kö ꞊ya 'to ‑wɛnng \"kpɛnng ‑pë ꞊në‑ 'ka kö ‑wo taa‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ka ꞊në 'ka \"kpʋngtaadhɛ ‑bha ‑dhɛpuudhɛ 'ka, \"ɛɛn 'pödhɛ 'ö ‑ya ‑sü 'ka ‑tɔn ꞊gbin‑ ‑a ‑dhɛ ‑yö ‑dhɛng ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","'Sa 'waa ‑dhangbha dɔ 'pö 'waa‑ ‑da gbɔ ‑zë ꞊wlöö, \"kɛɛ ‑wa ‑dɔ pë 'bha ꞊në‑ ‑ta 'yö ‑dhɛ ‑pʋ mɛ \"pɛpɛ 'wo 'kɔɔdhö ‑a ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","꞊Dhɛ 'ö ‑kë ꞊dhɛ ka ꞊në 'ka \"kpʋngtaadhɛ ‑bha ‑dhangbha 'ka 'pö bha, ‑a ‑dhɛa ‑bha ꞊dhɛ ka 'bhü ‑yö \"flʋ̈ kö mɛ ꞊gban ‑wa yö. Ka 'bhü 'ö dho bhɔ 'ö mɛ ꞊gban ‑wa yö bha yö ‑mü 'wɔn ‑sɛsɛngbɔ ‑nu 'ka dho‑ kë bha ꞊në‑ 'ka, yö ꞊në ꞊waa‑ yö, 'yö 'wo dho ka Dë Atanna 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha‑ 'tɔ bhɔ‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","'Yö‑ pö: «'Ya 'dho kë ka 'gü ꞊dhɛ a ‑nu kö 'tɔng‑ ‑nu 'ö Moizö ‑ya ‑bɛn zë bha waa‑ ‑wʋ ‑nu 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑wa pö yi 'bha 'ka 'ö‑ ‑gɔ 'sëëdhɛ 'gü bha 'a‑ 'bha bho \"gblʋʋ, \"kɛɛ a ‑nu kö 'a‑ 'gü ‑wɔn ꞊në‑ kë. ");
INSERT INTO daf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: \"Sɛ waa‑ dhang‑ ‑zë 'wo ‑tun ꞊kö, 'tɔng‑ ‑nu bha‑ ga do 'yii 'dho 'go \"gblʋʋ, aa\" ꞊ni ‑a ꞊blün 'në ‑zian 'yii dho 'sü‑ ‑bha 'ö dho 'ö zun‑ 'ka pë \"pɛpɛ ꞊gban \"dhiʋ̈toyi ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yö ꞊në‑ ‑wɔn 'gü 'yö mɛ \"ʋʋ mɛ 'ö dho 'tɔng‑ bha‑ 'dɛdɛ 'në 'bha ‑zian bho, 'ö dho 'ö‑ ‑kɔ ‑zɔn mɛ \"wɛɛ ‑nu ‑dhɛ, ‑a ‑mɛ ꞊në dho 'to mɛ ꞊gban \"pɛpɛ 'dɛdɛ ‑sü 'ka Atanna ‑bha ‑gblüdëdhɛ 'ö dho 'go dhang‑ 'gü bha‑ kë ‑yi 'ka. \"Kɛɛ 'mɛ 'kö 'tɔng‑ bha‑ kun, 'ö‑ ꞊bhlëë ‑ya, 'ö‑ ‑kɔ ‑zɔn 'pö mɛ \"wɛɛ ‑nu ‑dhɛ, ‑yö ‑dho ‑duɛ 'kpii‑ ꞊slɔɔ ‑gblüdëdhɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Ka ‑bha Atanna dhɔɔbhaawɔn kë ‑sü 'yii ziö Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu ‑bha ‑ta, 'kii 'dho ‑da Atanna ‑bha ‑gblüdëdhɛ bha‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","'Yö‑ pö: «Ka‑ ‑ma ꞊dhɛ ‑wo ka‑ ‑pö ka \"bhɛma ‑nu ‑dhɛ yi 'bha 'ka ꞊dhɛ: Mɛ 'bha 'ya 'dho mɛ zë, mɛ 'ö ya mɛ zë kö ꞊ya za ‑ya ö ‑dɩ ‑bha. ‑Wo 'dho‑ 'ka 'pödë ‑nu ‑dhɛ kö ‑wo za dɔ‑ ‑bha, ");
INSERT INTO daf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","\"kɛɛ ma ‑zë a‑ ‑pö ka ‑dhɛ: Mɛ \"ʋʋ mɛ 'ö yaa‑ ö ‑siö ‑dhɛ ‑wɔn ‑yö ö \"tɛado \"piʋ̈ kö dhɛɛ\" 'kpɔ ‑ya ‑mɛ ‑bha, kö ‑wo ‑dho 'dho‑ 'ka 'pödë ‑nu ‑kuu \"dhiʋ̈ kö ‑wo za dɔ‑ ‑bha. Mɛ 'ö yaa‑ ‑pö ö \"tɛado ‑dhɛ \"yaaki 'yaa i ‑bha, ‑wo ‑dho 'dho‑ ‑mɛ 'ka ‑kwɛazë ‑nu ‑kuu \"dhiʋ̈. Mɛ 'ö yaa ö \"tɛado ‑dhɛ slaamɛ, kö pɛng 'ö ꞊geebɔɔ bha ‑dho 'gü ‑mɛ do 'bha ꞊në bha. ");
INSERT INTO daf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","꞊Ya kë ꞊dhɛ 'bha 'dho \"saa‑ bho Atanna \"dhiʋ̈ ‑a ‑bha \"saabhodhɛ 'gü, kö 'i 'to mü kö i ‑zʋ ‑yö ‑bö ꞊dhɛ 'wɔn 'bha ‑yö i dheebhang 'bha ‑zʋ \"piʋ̈ i ‑bha, ");
INSERT INTO daf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","‑bhö i ‑bha \"saapë 'to ‑dhɛ bha‑ 'gü kö 'i 'dho bhɛa\" i dheebhang bha‑ ‑dhɛ kö i gun ‑na nu 'i \"saa‑ bha‑ bho Atanna \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","꞊Ya kë ꞊dhɛ mɛ 'bha ꞊ya i ‑da zadɔmɛ ‑nu ‑dhɛ, 'ka 'dho sië ka \"kwëë ‑a ‑nu ‑kuu \"dhiʋ̈ kö 'ka ziö‑ ‑gɛn 'gü, ‑bhö ‑a \"slë mɔɔ‑ kö 'ka ꞊mɔɔ‑ 'gü kö ka ‑tun zian ‑ta. Kö 'ya 'dho i ‑da \"sɔdha ‑nu ꞊kwɛɛ‑ 'ö 'wo i ‑da ‑kaso 'gü. ");
INSERT INTO daf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A‑ ‑pö i ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ i ‑dho 'to ‑kaso bha‑ 'gü \"dhʋ̈ 'ö dho 'ö zun‑ 'ka mɛ 'ö‑ ‑bha 'wɔn 'dhö i ‑bha bha‑ ‑bha ‑suganë 'ö i ‑gɔ ‑a ‑kpɛa nu ‑yi ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","'Yö‑ pö: «Ka‑ ‑ma 'zü ꞊dhɛ mɛ 'bha 'ya 'dho ‑zua zë, ");
INSERT INTO daf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","\"kɛɛ ma ‑zë a‑ ‑pö ka ‑dhɛ ꞊dhɛ mɛ \"ʋʋ mɛ 'i mɛ ‑nu ‑bha dhe yö, 'ö i zuë\" ‑yö bhɔ‑ ‑bha kö 'bha ‑da \"piʋ̈ i zuë\" 'gü ꞊yën ꞊naa bha. ");
INSERT INTO daf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, ꞊ya kë ꞊dhɛ i ‑kɔ ‑së 'gü \"yanga ꞊ya kë i ‑pö 'wɔn yaa 'gü ‑pë 'ka, ‑bhö ‑a bho \"kɛa 'gü kö 'i‑ ‑zuö i 'ka ꞊gblɛɛn, (\"tʋ̈ng 'ö 'yii i ‑da 'ka ꞊kö 'wɔn yaa 'gü bha‑ 'ka); ‑a ‑gɛn ‑mü ꞊dhɛ i daɔ do ‑go i ‑bha ‑sü kö 'i dha ‑a fië‑ ‑dhö i daɔ ꞊gban ‑to i ‑bha ‑sü 'ö 'i dho ꞊geebɔɔ ‑pɛng 'gü ‑a ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","꞊Ya kë 'zü ꞊dhɛ i ‑kɔ ‑së 'gü ‑gbe ꞊në ꞊ya kë i ‑pö 'wɔn yaa 'gü ‑pë 'ka, ‑bhö ‑a \"kplü bho kö 'i‑ ‑zuö i 'ka ꞊gblɛɛn, (\"tʋ̈ng 'ö 'yii i ‑da 'ka ꞊kö 'wɔn yaa 'gü bha‑ 'ka); ‑a ‑gɛn ‑mü ꞊dhɛ i daɔ do ‑kan i ‑bha ‑sü 'ö 'i dha ‑a fië‑ ‑dhö i ‑dhü ‑todhʋ̈sü 'ö dho ꞊geebɔɔ ‑pɛng 'gü ‑a ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","'Yö‑ pö: «Ka‑ ‑ma 'pö ꞊dhɛ mɛ 'ö dho ö ‑bha dhebhɔ bho \"bü, ‑ya ‑bho \"bü 'sëëdhɛ kë kö ‑ya ꞊nëng‑ ‑bha, ");
INSERT INTO daf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","\"kɛɛ ma ‑zë a‑ ‑pö ka ‑dhɛ ꞊dhɛ mɛ \"ʋʋ mɛ 'ö‑ ‑bha dhebhɔ 'yii‑ to ‑zë wo kö ‑yö dho ‑zua zë ‑dhɛ 'gü, ꞊yaa‑ bho \"bü 'wɔn \"wɛɛ 'bha ‑zë 'gü kö ‑a dhebhɔ bha ‑yö gwaan‑ \"wɛɛ 'kpɔ, kö‑ ‑bha gɔn bha ꞊në‑ \"yan dɔ ‑gɛan. 'Sa mɛ \"ʋʋ mɛ 'i dhe ‑bho \"bü ‑sü sü, kö ‑da ꞊në 'i‑ wo mɛ ‑nu ‑bha dhe \"piʋ̈ bha.» ");
INSERT INTO daf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","'Yö‑ pö: «Ka‑ ‑ma 'zü ꞊dhɛ ‑wo ka‑ ‑pö ka \"bhɛma ‑nu ‑dhɛ yi 'bha 'ka ꞊dhɛ mɛ 'bha 'ya 'dho ‑sö ‑bhö 'ö 'yaa‑ 'gü ‑wɔn kë, ꞊dhɛ mɛ ꞊ya ‑sö ‑bhö 'wɔn suu \"ʋʋ suu 'ö‑ 'gü kwa Dëmɛ ‑dhɛ, ‑a ‑mɛ ‑ya 'gü ‑wɔn kë gbonggbongdhö, ");
INSERT INTO daf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","\"kɛɛ ma ‑zë a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'ka 'dho ‑sö ‑zian ꞊në‑ ‑bhö tongtongdhö. 'Ka 'dho‑ ‑bhö dhang‑ 'gü ‑dhɛ 'tɔ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ ‑gbloo ‑mü. ");
INSERT INTO daf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","\"Ɛɛn 'ka 'dho‑ ‑bhö \"kpʋngtaadhɛ 'tɔ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑gɛndɔdhɛ ‑mü. 'Ka 'dho‑ ‑bhö 'zü Zedhizadhɛmö ‑dhɛ 'tɔ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑gblüdë 'kpii‑ ‑bha 'pödhɛ ‑mü. ");
INSERT INTO daf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","'Ka 'dho‑ ‑bhö 'pö ka ‑dɩ 'tɔ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'kaa ꞊mɔɔ‑ ‑bha kö 'ka ka ‑gɔdhɛ ga do ‑zian \"flʋ̈ \"ɛɛn kö 'ka‑ trö ka ‑dɩ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","\"Kɛɛ kaa‑ ꞊iin ‑yö kë ꞊iin 'ka, ‑a 'dhɛ 'ka‑ pö 'zü 'aa bhoo, ‑ka 'to 'aa bhoo ‑ta, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a 'dhɛ 'kö 'ka‑ ‑da ‑ta ‑a 'dhɛ bha‑ zian‑ ‑ta bha ‑yö ‑go Sɔtraan ꞊në‑ \"piʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","'Yö‑ pö: «‑Wa ‑pö 'zü ka \"bhɛma ‑nu ‑dhɛ yi 'bha 'ka ꞊dhɛ: ‹'Mɛ ꞊ya mɛ \"yan 'wü ‑wa \"yan 'wü 'pö, 'mɛ ꞊ya mɛ \"sɔnga do \"yɛ ‑wa ‑bha \"yɛ 'pö› ");
INSERT INTO daf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","\"kɛɛ ma ‑zë a‑ ‑pö ka ‑dhɛ ꞊dhɛ: 'Ka 'dho ka ‑dɩ bhlɔɔ bho mɛ 'ö 'wɔn yaa ‑kë ka 'ka ‑a ‑gɔ. Mɛ 'ö ka \"tʋ ‑ma ka ‑kɔ ‑së 'gü, ‑ka ka ꞊kwaa 'gü \"tʋ slëë‑ ‑mɛ ‑ta kö ‑ya ‑ma 'pö. ");
INSERT INTO daf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mɛ ꞊ya ka ‑da zadɔmɛ ‑nu ‑dhɛ kö ‑wo kaa‑ \"bhɛɛ 'sü ka ‑gɔ ka ‑san ‑bha, ‑ka kaa‑ ꞊gbauu‑ dɔ‑ ‑mɛ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","꞊Ya kë ꞊dhɛ 'mɛ 'ö ‑ziö ka ‑gɔ ꞊ya ‑kpan ka ‑bha zian ‑ta kö ‑yö faan wɔ ka ‑ta kö ‑yö ꞊kwɛɛ 'gbiin‑ ‑ya ka ꞊gbin‑ kö ‑ya pö 'ka ziö ‑tɔn do ‑ta, ‑ka ziö ‑tɔn ꞊plɛ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mɛ 'ö pë ‑gbadhɛ ka ‑gɔ, ‑kaa nu‑ ‑mɛ ‑dhɛ, mɛ 'ö nu pë \"siëng 'sü ka ‑gɔ, 'ka 'dho ‑kɔ ‑mɛ ‑dhɛ ‑a ‑pë ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","'Yö‑ pö: «꞊Ya 'go yö ‑zë 'gü, ‑wo ka‑ ‑pö ka \"bhɛma ‑nu ‑dhɛ 'pö ꞊dhɛ ka këyɔɔ ‑nu ‑dhɔ ‑yö ka kë kö ka 'yaɔ‑ ‑nu ‑zë ‑a ‑nu ‑san ‑yö ka kë. ");
INSERT INTO daf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","\"Kɛɛ ma ‑zë a‑ ‑pö ka ‑dhɛ ꞊dhɛ ka 'yaɔ‑ ‑nu ‑dhɔ ‑yö ka kë kö 'mɛ 'wo ka ‑wëëdhɛ bho sië 'ka bhɛa\" Atanna ‑dhɛ ‑a ‑nu ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'Ka yö ꞊në‑ kë \"dhʋ̈ kö 'ka bhɔ ka Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha‑ ‑bha. ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ö ‑bha 'yënng‑ ‑wo 'wɔnyaakëmɛ ‑nu ‑dhɛ ꞊dhɛ ‑kɔ do 'ö‑ ‑wo 'ka 'wɔnsëkëmɛ ‑nu ‑dhɛ bha ꞊në‑ 'dhö, 'yö dha ban 'zü ö 'wɔnsëkëmɛ ‑nu ‑dhɛ ꞊dhɛ 'wɔnyaakëmɛ 'dhö 'pö. ");
INSERT INTO daf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","‑Ya kë ꞊dhɛ 'mɛ 'ö ka ‑dhɔ 'dhö‑ ‑nu ‑kë ꞊në‑ ‑nu ‑dhɔ ꞊ya ka kë doseng kö ‑më ‑wɔn ꞊në dho kë mɛ 'kɔn ‑wɔn 'ka ka ‑bha ‑kë Atanna ‑bha mɛ 'ka ‑sü \"gblʋʋ \"piʋ̈, 'yö Atanna dho ka ꞊trɔɔn ‑da ‑a ‑wɔn 'gü. 'Niisɔngkunmɛ ‑nu ('wo mɛ ‑nu ‑ta ꞊në‑ ‑bhö bha) ‑wa ‑kë 'pö ꞊dhɛ ‑kɔ 'dhɛ 'kö bha‑ 'dhö bhoo! ");
INSERT INTO daf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","꞊Ya kë 'zü ꞊dhɛ 'ka ka dheebhang ‑nu ‑dɩ ‑slɔɔ ꞊në‑ ‑nu ꞊tua bho doseng kö \"dhabhliwɔn ‑mɛɛ ꞊në 'ka‑ ‑kë 'wɔn bha‑ 'gü, mɛ 'waa Atanna dɔ ‑wa kë 'pö \"dhʋ̈! ");
INSERT INTO daf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pö 'yaa ka Dë Atanna 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha‑ ‑bha ‑kɔ do 'ö‑ 'gü bha, pö 'ya 'dho kë ka ‑bha 'pö‑ ‑kɔ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö go mü 'zü 'ö‑ pö: «‑Kaa kë ‑së kö ka ‑bha 'wɔn ‑së kë ‑sü 'ya 'dho kë ꞊dhɛ pë ‑yaan kë ‑sü 'dhö. ꞊Ya kë ꞊dhɛ 'ka‑ kë \"dhʋ̈ kö 'kii 'dho ka ꞊trɔɔn yö ka Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha‑ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","‑A ‑wɔn 'gü 'bha‑ pö bhii 'wëëga ꞊gbaɔ ‑wëëmɛ ‑gɔ, ‑bhö ‑a kë ‑suɛɛdhö kö mɛ \"yan 'ya 'dho ꞊loo i ‑ta ꞊dhɛ ‑kɔ 'ö ꞊naɔyaankëmɛ ‑nu 'wo‑ kë‑ 'ka Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü, \"ɛɛn ‑kpinng ‑ta ‑dhɛ ‑nu 'gü (\"kɛɛ kö ‑a ‑nu \"ta ‑kɔ ‑zë 'bha 'yaa ‑së) bha‑ 'dhö. ‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'kö 'wo bha ‑wa ‑kë \"dhʋ̈ kö ‑wo wo 'tɔ ꞊në‑ bhɔ. A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ wo ‑zë ꞊wa wo ꞊trɔɔn ꞊slɔɔ 'nu (mɛ \"bhɩɩ‑ ‑nu ‑bha ‑a ‑nu 'tɔ bhɔ ‑sü bha‑ 'ka ꞊naa bha). ");
INSERT INTO daf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","\"Kɛɛ bhi ‑zë 'bha‑ pö 'i 'wëëga nu ‑wëëmɛ ‑dhɛ ‑a \"slë mɔɔ‑ kö mɛ ‑zian 'ö dɔ ‑sü 'ka i \"sɔɔ 'ya 'dho 'wɔn ꞊slɔɔ‑ 'gü! ");
INSERT INTO daf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kë \"dhʋ̈ kö gbaɔ‑ 'i‑ wo bha ‑yö 'to ‑bin 'gü kö i Dë 'ö 'wɔn 'bha 'yaa ‑bin ‑bha bha ‑yö i ꞊trɔɔn nu.» ");
INSERT INTO daf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","'Yö go mü 'zü 'ö‑ pö: «'Ka bhɛa\" sië Atanna ‑dhɛ 'ka 'dho‑ kë ꞊dhɛ mɛ ‑yaankëmɛ ‑nu 'dhö; ‑a ‑gɛn ‑mü ꞊dhɛ wo ꞊në ꞊wa dɔ ‑kpinng ‑ta ‑dhɛ ‑nu waa‑ Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü ‑dhɛ ‑nu 'gü, 'yö 'wo ꞊bhɛa kö mɛ ‑nu \"yan ‑yö ꞊mɔɔ wo \"dhiʋ̈ ꞊dhɛ Atanna ‑dhɔkëmɛ ‑mü wo 'ka. A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'wo \"dhʋ̈ bha ꞊wa wo ꞊trɔɔn ꞊slɔɔ ‑ya bo. ");
INSERT INTO daf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","\"Kɛɛ bhi ‑zë 'bha‑ pö bhii bhɛa\" Atanna ‑dhɛ, ‑bhö ‑da i ‑gɔ 'kɔɔdhö kö 'i \"kwɛɛ ta i ‑ta kö 'i bhɛa\"‑ ‑dhɛ. ꞊Ya kë \"dhʋ̈ i Dë 'ö 'wɔn 'bha 'yaa ‑bin ‑bha 'ö i \"piʋ̈ ‑bin 'gü mü bha ‑yö ‑dho i ꞊trɔɔn nu; ‑a ‑gɛn ‑mü ꞊dhɛ ‑a \"yan ‑yö i ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","꞊Ya 'go yö ‑zë 'gü, 'ka bhɛa\" sië Atanna ‑dhɛ, 'ka 'dho‑ wo ‑dhɛ do 'gü kplɔnkplɔndhö ꞊dhɛ mɛ‑ pë wo ‑dhɔkëpë ‑nu ‑dhɛ mɛ 'waa Atanna dɔ ꞊në 'ö ‑kë ‑nu 'gü ꞊dhɛ ‑bhɛa ‑dhɛ do 'gü kplɔnkplɔndhö ‑sü ꞊në ꞊ya kë \"dhʋ̈ 'yö mɛ ‑wʋ ma, 'yö‑ ‑yɔ ‑bɔ mɛ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","‑Abin! Ka ‑zë 'ka 'dho ka ‑bha kë \"dhʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ \"sanni 'ka pë ‑gbadhɛ, pë 'ö ka ‑mawɔn 'dhö‑ ‑bha, ka Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha ‑ya ‑dɔ 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü 'ka‑ pö 'ka bhɛa\" Atanna ‑dhɛ ‑kaa pö: Yi Dë Atanna 'i ‑ya ‑sü 'ka dhang‑ ‑nu 'gü, i 'tɔ 'ö \"slʋ̈ʋ̈slʋ̈ bha ‑yö bhɔ ‑dhɛ ꞊gban \"pɛpɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","I ‑bha ‑gblüdëdhɛ ‑yö nu, i dhɔɔbhaawɔn ꞊në ‑yö kë \"kpʋng ꞊taa ꞊dhɛ ‑kɔ 'ö‑ 'ka dhang‑ 'gü ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","‑Bhöpë 'ö ꞊mɔɔ yi ‑bha ꞊dɛɛ, ‑bhö ‑a nu yi ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","‑Bhö yi ‑kë ‑sɔng yaya ‑nu ‑mawɔn 'to ꞊dhɛ ‑kɔ 'yi 'mɛ 'wo 'wɔn yaa ‑kë 'pö yi 'ka ‑a ‑nu ‑mawɔn to‑ 'ka 'pö ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'Bha 'dho kwaa‑ yi ‑zü 'ö 'yi dho 'wɔn yaa kë ‑zian ‑ta, \"kɛɛ ‑bhö yi dha Sɔtraan ‑gɔ; ‑a ‑gɛn ‑mü ꞊dhɛ ‑gblüdëdhɛ, 'gügbɩɩdhɛ waa‑ 'tɔbhɔdhe ‑wo bhi ꞊në i ‑gɔ 'ö‑ zübhoyi 'yaa 'dhö, 'ö‑ \"dhiʋ̈todhɛ 'yaa 'dhö. Kö ‑yö kë \"dhʋ̈ bha 'aa ‑yö kë! ");
INSERT INTO daf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","꞊Ya kë ꞊dhɛ 'wɔn yaa 'ö mɛ ‑nu ‑wa ‑kë ka 'ka, 'ka‑ ‑nu ‑mawɔn 'to, ka Dë 'ö dhang‑ 'gü ‑yö ‑dho ka ‑bha 'wɔn yaa ‑nu ‑mawɔn 'to 'pö. ");
INSERT INTO daf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","\"Kɛɛ ꞊ya kë ꞊dhɛ 'kii‑ ‑nu ‑bha 'wɔn yaa ‑nu ‑mawɔn 'to ‑zë wo, kaa ‑dɩ 'pö 'yii dho ka ‑mawɔn 'to.» ");
INSERT INTO daf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","'Yö‑ pö: «꞊Ya kë ꞊dhɛ 'ka 'sunng‑ 'ma sië kö 'ka bhɛa\" Atanna ‑dhɛ, 'ka 'dho ka wë 'gü ‑siö ꞊dhɛ ‑kɔ 'ö ‑dɩ ‑to mɛ ‑nu \"yënngmɛ ‑nu 'wo‑ kë‑ 'ka ‑a 'dhö! 'Ö 'wo wo wë 'gü ‑siö kö mɛ ꞊gban \"pɛpɛ ‑wa 'wɔn dɔ ꞊dhɛ ‑wo 'sunng‑ 'ma sië. A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: 'Mɛ 'wo bha ꞊wa wo ꞊trɔɔn ꞊slɔɔ \"pɛpɛdhö ꞊naa bha. ");
INSERT INTO daf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","\"Kɛɛ bhi ‑zë, a‑ ‑pö i ‑dhɛ ꞊dhɛ i 'sunng‑ 'ma sië, ‑bhö i wëë' \"zu \"pɛpɛdhö kö 'i i ‑gɔ 'gü ‑piö ‑së 'ka ");
INSERT INTO daf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kö mɛ 'bha 'ya 'dho‑ 'wɔn dɔ ꞊dhɛ i 'sunng‑ ma sië; i Dë doseng 'ö 'wɔn 'bha 'yaa ‑bin ‑bha, 'ö i \"piʋ̈ mü bha ꞊në dho‑ 'wɔn dɔ, 'yö 'wɔn ‑nu 'i‑ kë sië bha‑ ‑gɔ \"yɔɔ dɔ i ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","'Yö dhiang zë‑ ‑nu ‑dhɛ 'ö‑ pö: «'Ka 'dho kaa‑ ꞊naɔ ‑nu ‑duɛ bho \"kpʋngtaadhɛ 'ö pë see‑ ‑pë waa‑ \"kɔɔ ‑nu 'wo‑ ‑bha, 'ö ꞊kwaanmɛ ‑nu 'wo 'kpong ‑nu wü faandhɛ bha, 'wo pë ꞊kwaan‑ ‑bha ya‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","\"Kɛɛ ‑ka ka ‑bha ꞊naɔ ‑nu ‑duɛ bho dhang‑ 'gü ‑dhɛ, 'ö pë see‑ ‑pë bha waa‑ \"kɔɔ ‑nu 'waa‑ ‑bha, \"ɛɛn 'ö ꞊kwaanmɛ ‑nu 'waa 'kpong 'wü‑ ‑bha kö ‑wo pë ꞊kwaan bha ꞊në‑ 'gü! ");
INSERT INTO daf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","‑A ‑gɛn ‑mü ꞊dhɛ ‑dhɛ 'ö i ‑bha ꞊naɔ 'dhö‑ ‑bha, 'yö i zuë\" 'dhö ‑kë ‑bha 'pö.» ");
INSERT INTO daf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","'Yö go mü 'ö‑ pö: «Mɛ \"yanga ꞊në ꞊dhɛ mɛ kwi ‑bha ‑dhɛpuudhɛ 'dhö. ꞊Ya kë ꞊dhɛ mɛ \"yanga 'dhö ö 'flëë‑ 'gü kö pë 'bha ‑pë 'bha 'yaa‑ ‑bha, kö i kwi ꞊gban \"pɛpɛ ‑yö \"puu 'pö. ");
INSERT INTO daf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","\"Kɛɛ ꞊ya kë ꞊dhɛ i \"yanga ‑zë ‑a ‑dhɛ ꞊ya ‑ya ‑bha 'yaa ‑dhɛ yö sië 'zü, kö i kwi ‑dɩ 'pö ꞊ya ‑da ‑dhɛ tii 'gü ꞊naa bha. ꞊Ya kë ꞊dhɛ 'pë 'ö dho i gba ‑dhɛpuudhɛ 'ka, ꞊ya kë ‑dhɛtiidhɛ 'ka, kö ‑dhɛtiidhɛ bha ‑yö ‑dho kë ‑ziisü.» ");
INSERT INTO daf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","'Yö Yesu ‑yö dho dhiang 'ka ö \"dhiʋ̈ 'ö‑ pö: «Mɛ do 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö yë kë mɛ ꞊plɛ \"piʋ̈. ‑A mɛ do ‑dhɔ ‑dho ‑a kë, 'ö‑ mɛ do ‑san ‑ya ‑kë \"wɛ gbonggbongdhö. ‑Yö ‑dho ‑kplü mɛ do ‑bha 'ö ‑kan mɛ 'dhɛ 'ö 'dhö‑ ‑bha, ‑kɔ do bha‑ 'gü, 'kii 'dho ꞊mɔɔ‑ ‑bha 'pö kö 'ka ka ‑dɩ nu Atanna waa‑ ꞊naɔ ‑a ‑nu ‑dhɛ \"kwëë. ");
INSERT INTO daf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","'Yö‑ pö: «'Wɔn 'ö‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ: 'Ka 'dho ‑ya pë ‑nu 'ka dho‑ ‑bhö \"ɛɛn 'ö 'ka dho‑ mü kö 'ka ‑tosɛa kë‑ ‑ta, \"ɛɛn sɔ ‑nu 'ka dho‑ ‑da bha‑ 'bha ‑wɔn zuën ‑ta bha 'yö bha; ‑a ‑gɛn ‑mü ꞊dhɛ ‑tosɛa kë ‑sü ‑wɔn ‑yö \"gbɩɩ‑ 'ö‑ ‑ziö ‑bhöpë ‑wɔn ‑ta, \"ɛɛn 'zü mɛ kwi ‑wɔn ‑yö \"gbɩɩ‑ 'ö ‑ziö sɔ ‑wɔn ‑zë ‑ta, \"ɛɛn ꞊sua ‑mü ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","‑Maa ‑nu 'wo ziö sië dhang‑ 'gü bha ‑kaa ‑nu ‑ga! 'Waa pë ta kö woo‑ ‑a \"kan kö ‑wa ‑kɔ dɔ, \"kɛɛ ka Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha ‑ya ‑nu \"dhiʋ̈ ‑gba. \"Ɛɛn ‑a ‑ga 'ka‑ wo bha ‑maanë ‑nu ‑zë ‑a ‑nu ‑wɔn ‑yö \"gbɩɩ‑ 'ö ‑ziö ka ‑zë ka ‑ta ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","De ‑mü 'ka ka kpö 'gü 'yö ꞊mɔɔ‑ ‑bha 'ö ö ‑dɩ ‑bha ‑tosɛa ‑dhɛkpaɔyi do ‑zian ‑da 'gü ö ‑dɩ ‑dhɛ ‑a ‑bha ‑ya ö ‑dɩ ‑wɔn zuën ‑ta ‑sü 'gü? ");
INSERT INTO daf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‑Më ꞊në ‑kë 'sa 'yö 'ka ‑ya ka ‑dasɔ ‑nu ‑wɔn zuën ‑ta? ‑Kɔ 'ö blëë ‑nu 'wo \"bin ‑ya sië‑ 'ka \"bü bha ‑kaa ‑ga kö 'ka‑ 'suan‑ bho! 'Waa yë 'bha kë \"ɛɛn 'waa sɔ bɔ. ");
INSERT INTO daf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","\"Kɛɛ 'sa a‑ ‑pö ka ‑dhɛ tɛan‑ 'ka ꞊dhɛ ‑gblüdë 'bha 'ö gun Izraɛdhö ‑sɛ 'gü yi 'bha 'ka 'wo‑ Sadhomɔ ‑kë bha‑ ‑bha ‑gblüdëdhɛ ꞊gban waa‑ ‑bha ‑bha, 'yii sɔ suu 'ö‑ \"yan 'dhö ‑së ꞊dhɛ blëë ‑nu bha‑ do 'dhö bha‑ ‑da tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","\"Bü ‑blëë \"wɛɛwɛɛ dhe ‑nu 'ö ꞊wa \"bin ‑ya ꞊dɛɛ 'ö dhia\" kö ꞊wa \"kpɛa 'kpɔ 'wo dho‑ ‑nu \"kan 'wo‑ ‑gʋ̈ bha Atanna ꞊ya wo ‑zë ‑a ‑nu dhi \"sinma ‑sinma wo \"dhʋ̈ bha ‑oo, 'yö ka ‑zë ꞊wɛ? ‑Më ꞊në ‑kë 'yö 'yaa sɔ ‑da ka ‑bha (\"kɛɛ kö ka ‑zë ka ꞊bhlëësü wo ‑zë ‑a ‑nu ‑bha)? 'Dhang 'ö kaa‑ bho Atanna \"dhiʋ̈ 'kpakpadhö bha 'yö ‑kë! ");
INSERT INTO daf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","A‑ ‑pö ka ‑dhɛ \"sika 'ya 'dho kë ka 'gü ka ‑bhöpë ‑wɔn 'gü; \"sika 'ya 'dho kë ka 'gü ka müpë ‑nu \"ɛɛn ka ‑dasɔ ‑nu ‑wɔn 'gü, ");
INSERT INTO daf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","'mɛ 'waa Atanna dɔ ꞊në 'wo pë ‑nu bha‑ ‑nu ꞊mɔɔ‑ ‑kpɛawo, \"kɛɛ ka Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü ‑ya 'wɔn ‑dɔ ꞊dhɛ ka ‑mawɔn ‑ya ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","'Pë 'ö 'ka dho‑ ꞊mɔɔ‑ ‑blɛɛsü yö ‑mü Atanna ‑bha ‑gblüdëdhɛ waa‑ ‑a dhɔɔbhaawɔn ‑nu kë ‑sü ꞊në‑ 'ka kö pë 'dhɛ 'wo to yöö ꞊dede ‑ya nu ka ‑dhɛ ‑a taa 'ka. ");
INSERT INTO daf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, 'ka 'dho ‑ya ‑dhɛ 'ö dho ꞊kpaɔ dhia\" ‑a ‑wɔn zuën ‑ta, ‑a ‑gɛn ‑mü ꞊dhɛ ‑dhɛkpaɔyi \"pɛpɛ ꞊gban ‑bha 'gü ‑wɔn ‑yö 'do 'do. ‑Dhɛ 'dhɛ ꞊ya ꞊kpaɔ 'yö‑ ‑bha 'gü sëëbhodhe 'ö ꞊mɔɔ‑ ‑bha 'yö ‑kë 'pö‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","'Yö‑ pö: «'Ka 'dho za dɔ mɛ 'bha ‑bha, kö Atanna ‑dɩ 'pö 'ya 'dho za dɔ ka ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ‑dho za dɔ ka ‑bha ꞊dhɛ ‑kɔ 'ö kaa ‑dɩ 'pö 'ka‑ dɔ‑ 'ka mɛ ‑nu ‑bha bha ꞊në‑ 'dhö; 'ka mɛ ‑nu ‑bha dɔ ‑mawɔn yaa ‑dhɛ ‑bha, ‑yö ‑dho ka ‑bha dɔ ‑mawɔn yaa ‑dhɛ ‑bha 'pö. ");
INSERT INTO daf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","‑Më ꞊në ‑kë 'yö \"yɛ ‑bi 'ö ‑da i \"tɛado \"yan ‑bha 'yö 'i yö ‑zë yö, 'yö 'bhaa \"dhü ‑blün kö bhi ‑zë i \"yan ‑bha bha‑ yö. ");
INSERT INTO daf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","I ‑dho pö i dheebhang ‑dhɛ ‑kɔ kë ꞊dhɛ ꞊dhɛ ‹‑bhö dɔ kö 'a \"yɛ ‑bi bho i \"yënng› kö bhi ‑zë \"dhü ‑blün ‑yö i \"yënng? ");
INSERT INTO daf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","꞊Flümɛ, ‑bhö \"dhü ‑blün bho ꞊kö i \"yan ‑bha ‑blɛɛsü kö i ‑dhɛ yö kö 'i gun ‑na \"yɛ ‑bi bho i dheebhang \"yan ‑bha 'pö!» ");
INSERT INTO daf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","'Yö go mü 'ö‑ pö: «'Ka 'dho 'pë 'ö ꞊bhlëësü ‑a nu 'gbɛn‑ ‑nu ‑dhɛ, 'ö 'wo ꞊slëë ka ‑bha 'wo ka kun. 'Ka 'dho ka ‑bha pë ꞊bhlëësü ‑nu ‑zuö ‑bhɔ ‑nu ‑dhɛ kö 'wa 'dho taa‑ ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","'Yö go mü 'zü 'ö‑ pö: «‑Ka pë ‑gbadhɛ, ka ‑dho ‑a ꞊slɔɔ! ‑Ka pë mɔɔ‑, ka ‑dho ‑a yö! ‑Ka \"kwɛɛ ‑ta ‑ma, ‑wo ‑dho \"kwɛɛ \"pʋ ka ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","‑A ‑gɛn ‑mü ꞊dhɛ mɛ 'ö pë ‑gbadhɛ 'yö‑ ꞊slɔɔ, 'mɛ 'ö pë ꞊mɔɔ 'pö 'yö‑ yö, 'yö 'wo \"kwɛɛ ‑pʋ 'mɛ 'ö \"kwɛɛ ‑ta ‑ma ‑a ‑gɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mɛ 'bha ‑yö ‑dhö ka kpö 'gü 'ö‑ ‑bha 'në ꞊ya 'bluu‑ ‑gbadhɛ ‑gɔ, 'yö ‑gwë kpö nu‑ ‑dhɛ ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","\"Ɛɛn mɛ 'bha‑ ‑dhö ka kpö 'gü 'yö‑ ‑bha 'në ꞊ya 'yuʋ̈‑ ‑gbadhɛ ‑gɔ, 'yö ‑mlɛɛ \"yaandhe nu‑ ‑dhɛ ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","꞊Ya kë \"dhʋ̈ ka 'ö ka ‑zë ka këwɔn 'dhö 'ya‑ bha, 'ka dɔ pë ‑së ‑nu ka ‑bha 'në ‑nu ‑dhɛ ‑dhɛ 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, ‑më ꞊në ‑kë 'yö ka Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha 'yaa pë ‑së nu 'mɛ 'wo‑ ‑gbadhɛ ‑gɔ ‑a ‑nu ‑dhɛ 'pö? ");
INSERT INTO daf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","꞊Ya 'go mü pë \"pɛpɛ 'ka‑ \"piʋ̈ ꞊dhɛ mɛ ‑nu ‑wa kë ka ‑dhɛ bha, ‑kaa kë‑ ‑nu ‑dhɛ 'pö, ‑a ‑gɛn ‑mü ꞊dhɛ 'pë 'ö Moizö ‑bha 'tɔng‑ waa‑ Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑bha 'sëëdhɛ 'wo‑ pö bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","'Yö go mü 'ö‑ pö: «‑Kë Atanna ‑bha mɛ 'ka ‑sü bha‑ ‑dhɛ ‑yö 'ya‑ ꞊dhɛ 'kɔ 'ö‑ \"dhi 'dhö \"sɔɔsɔɔ, ‑da ‑a 'gü ‑sü 'dhö, \"kɛɛ bɔdhɛ 'ö 'dhö 'yö bha, kö 'ka kë‑ ‑bha 'ka! ‑A ‑gɛn ‑mü ꞊dhɛ ꞊geebɔɔ ‑pɛng 'gü ‑zian bha‑ ‑sɔ ‑dhɛ ‑yö \"gbɛa, 'yö‑ ‑tadhɛ 'dhö ‑basü 'ka \"pɛpɛdhö, 'yö 'mɛ 'wo bɔ mü ꞊në 'wo 'gbɛ. ");
INSERT INTO daf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","'Yö zian 'dhɛ kö dho ꞊sii 'ö 'yaa yën ‑a këdhɛ 'gü bha 'ö \"sɔɔsɔɔ, 'yö ‑bɔ ‑ta ‑dhɛ 'dhö \"gbɩɩ‑ ꞊dedewo, 'yö mɛ 'wo bɔ‑ ‑ta 'waa 'gbɛ.» ");
INSERT INTO daf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","'Yö‑ pö: «‑Ka ka ‑dɩ 'kun ‑së Atanna ‑wʋdhiʋ̈loomɛ ꞊flüsü ‑nu ‑gɔ! 'Wɔn 'ö‑ ‑wɔn 'gü, 'yö 'a‑ pö \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ: ‑Wo ‑dho nu ka \"piʋ̈ kö ꞊wa wo tɔng 'ka ꞊dhɛ \"bhlaanë 'dhö, \"kɛɛ kö 'gba ‑dɔ ka ‑bha kö 'wo ka 'gü see‑ ‑wɔn ꞊në‑ ‑nu 'gü ꞊dhɛ gwee ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","\"Kɛɛ ka ‑dho ‑a ‑nu dɔ 'kpakpadhö ‑a ‑nu këwɔn ‑nu ꞊në‑ ‑bha; ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu këwɔn 'yaa ‑së ");
INSERT INTO daf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","‑A 'klɔɔ‑ ‑mü ꞊dhɛ \"dhü 'ö \"dhü ‑së 'ka ‑a bhɛ din ‑yö ‑kë ‑së; ‑a 'dhɛ 'yaa ‑së 'pö, ‑a bhɛ din 'yaa dhi. ");
INSERT INTO daf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","\"Dhü 'ö ‑së ‑a bhɛ ‑zë din 'yaa ‑siö, ‑a 'dhɛ 'ö 'ya‑ 'pö, ‑a bhɛ din 'yaa dhi. ");
INSERT INTO daf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","‑A ‑kë \"dhʋ̈ ‑sü 'gü, \"dhü 'ö 'yaa bhɛ ‑së dɔ, ‑a \"kan ꞊në 'wo dho‑ wo 'yö 'wo‑ ‑zuö pɛng 'gü. ");
INSERT INTO daf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'Wo \"dhü ‑së dɔ‑ bhɛ ‑bha ‑kɔ do 'ö‑ 'gü bha, ka ‑dho Atanna ‑wʋdhiʋ̈loomɛ ꞊flüsü ‑nu bha‑ ‑nu dɔ ‑kɔ do bha ꞊në‑ 'gü 'pö.» ");
INSERT INTO daf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","'Yö go mü 'zü 'ö‑ pö: «Mɛ \"pɛpɛ 'wo n ‑dhɛ sië ‹n Dëmɛ, n Dëmɛ› bha, ‑a ‑nu ꞊gban 'wii 'dho ‑da Atanna ‑bha ‑gblüdëdhɛ 'gü kö 'yii kë mɛ 'kö n Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha‑ dhɔɔbhaawɔn ‑kë ‑a 'ka. ");
INSERT INTO daf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Atanna ‑bha za ‑dɔ mɛ ‑bha yi bha ꞊ya ꞊loo, mɛ 'gbɛ‑ ‑dho pö n ‑dhɛ: ‹N Dëmɛ, n Dëmɛ, yi Atanna ‑wʋ \"dhiʋ̈ ꞊loo i 'tɔ 'gü, 'ö 'yi \"yina yaa ‑nu kë mɛ ‑nu 'gü i 'tɔ 'gü, 'ö 'yi \"dhabhliwɔn 'gbɛ ꞊dede ‑kë i 'tɔ 'gü› ");
INSERT INTO daf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","\"kɛɛ ‑a ‑dho pö‑ ‑nu ‑dhɛ: 'Maa ka dɔ tongtongdhö, ‑a ‑gɛn ‑mü ꞊dhɛ ka ‑to 'wɔn yaa kë ‑sü ‑bha ‑kpɛawo, ‑ka bhɔ n ‑dhɛ taa‑!» ");
INSERT INTO daf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","'Yö go mü 'zü 'ö‑ pö: «\"Kɛɛ mɛ \"ʋʋ mɛ 'ö ö \"tʋ to 'wɔn ‑nu 'a go sië‑ pö bha‑ ‑bha, 'ö‑ 'gü ‑wɔn ‑nu ‑kë kö‑ ‑mɛ ‑yö ꞊dhɛ 'wɔndɔmɛ do 'ö ö ‑bha 'kɔ dɔ ‑gwë ‑ta ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","꞊Dhɛ 'ö ꞊ya ö ‑bha 'kɔ bha‑ ‑dɔ ‑gwë 'saa‑ \"dhiʋ̈ ꞊ya ö bo, 'yö dha ‑yö ban, 'yö \"yi ‑yö pa, 'yö \"tɛɛ \"gbɩɩ‑ ‑nu 'wo ‑ziö, \"kɛɛ 'yö 'kɔ bha 'yii 'wü, ‑a ‑gɛn ‑mü ꞊dhɛ kö‑ ‑gɛn ‑yö ‑gban ‑sü 'ka ‑gwë ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","\"Kɛɛ mɛ \"ʋʋ mɛ 'ö 'wɔn 'ka 'go sië‑ ma bha‑ ma, 'ö 'yaa‑ 'gü ‑ta 'sü, kö‑ ‑mɛ ‑yö ꞊dhɛ ‑tamamɛ 'ö 'yaa ö ‑zʋ 'gɔn 'ö dho 'ö 'kɔ dɔ \"yɛɛn ‑ta ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","꞊Dhɛ 'ö ꞊ya 'kɔ dɔ, 'yö dha ‑yö ban, 'yö \"yi ‑yö pa, 'yö \"tɛɛ \"gbɩɩ‑ ‑nu 'wo ‑ziö, 'yö 'kɔ bha 'ö wü, 'yö‑ ꞊gban ‑yö ꞊see dee\" wo \"pɛɛpɛdhö.» ");
INSERT INTO daf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","꞊Dhɛ 'ö Yesu ꞊ya ö bo dhiang ‑nu bha‑ ‑nu zë ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö‑ ‑bha mɛ draan‑ ‑kɔ bha‑ 'wɔn ‑yö mɛ 'wo gun mü bha‑ ‑nu ꞊gban \"pɛpɛ kɔn; ");
INSERT INTO daf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑bha mɛ draan‑ ‑kɔ bha ‑yö ‑gun bho sië Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu ‑bha \"piʋ̈, 'ö mɛ ꞊draan ‑wʋgbiindhɛ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","꞊Dhɛ 'ö Yesu ꞊ya 'go ‑tɔn ꞊gbin‑, 'yö mɛ kpö 'gbɛ 'wo ‑ziö ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","'Wo dho ‑dhɛ ‑ga kö ꞊weemɛ do ꞊ya ꞊yɔɔn‑ \"sɔɔ kö ꞊ya zun ö kpiö 'gü‑ ‑dhɛ, kö ꞊yaa‑ pö: «N Dëmɛ, a‑ 'wɔn ‑dɔ ꞊dhɛ i ‑mɔɔ ‑bha 'i n ‑kë \"klʋ̈ʋ̈klʋ̈, \"kɛɛ kö i ‑dho \"wɩ‑ ‑bha ꞊tɔn n ‑gɔ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Yö Yesu ‑yö ö ‑gbe 'gü ‑pʋ 'yö‑ zun‑ ‑bha 'yö‑ pö: «'Ma \"wɩ‑ ‑bha, ‑bhö kë \"klʋ̈ʋ̈klʋ̈!» ‑Yö ‑to ‑dhɛ do bha‑ 'gü, 'ö‑ ‑bha ꞊wee ‑yua ‑yö go‑ ‑bha 'yö kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑ya pö‑ ‑dhɛ: «‑Bhö i \"tʋ 'to ‑së 'ka, 'bha 'dho 'wɔn ya‑ ‑gɛn do mɛ 'bha ‑dhɛ, \"kɛɛ ‑bhö 'dho 'i i ‑dɩ ‑zɔn \"saabhomɛ ꞊në‑ ‑dhɛ kö ‑kɔ 'dhɛ 'i‑ ‑bha ꞊dɛɛ bha ‑ya yö! ꞊Ya 'go mü kö 'i \"saa‑ bho Atanna \"dhiʋ̈ ꞊dhɛ ‑kɔ 'ö Moizö ‑ya ‑zɔn 'ka ‑a 'dhö kö mɛ ꞊gban ‑wa 'wɔn dɔ ꞊dhɛ 'bha kë \"klʋ̈ʋ̈klʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","꞊Dhɛ 'ö Yesu 'dhö ‑da sië Kapɛɛnaɔmö ‑pö 'gü, 'yö Wlɔmö ‑mɛ ‑nu ‑bha \"sɔdha këng do ‑gɔdhiʋ̈mɛ do ‑yö nu‑ \"piʋ̈, 'yö \"ta bhoo ‑da ‑dhɛ ");
INSERT INTO daf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","'ö‑ pö: «N Dëmɛ, ‑bhö \"ta n ‑dhɛ, ma gwëëmi do ‑yö \"yua \"dhiʋ̈ sië ‑ziisü, ‑a ‑dhɛ ꞊gban \"pɛpɛ ꞊ya ga‑ ‑bha, ‑yö wɔ sië 'kɔɔdhö.» ");
INSERT INTO daf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","'Yö Yesu ‑ya pö‑ ‑dhɛ: «A ‑dho 'dho 'a ‑wo i ‑gɔ 'kɔɔdhö kö 'a‑ dha.» ");
INSERT INTO daf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","\"Kɛɛ 'yö \"sɔdha ‑gɔmɛ bha 'ö‑ pö‑ ‑dhɛ 'ö‑ pö: «N ꞊kɔɔnmɛ, a ꞊dhɛ ‑më 'dhö 'yö 'i‑ \"piʋ̈ kö 'i ‑da n ‑gɔ 'kɔɔdhö, a‑ 'wɔn ‑dɔ ꞊dhɛ ‑wʋ dosengseng ‑ya 'go i \"dhi 'bha‑ pö, ma gwëëmi bha‑ ‑dho kë \"klʋ̈ʋ̈klʋ̈; ");
INSERT INTO daf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","‑a ‑gɛn ‑mü ꞊dhɛ ma 'ö n ‑gɔdhiʋ̈mɛ ‑nu 'wo 'dhö 'pö ya, mang ‑dɩ 'pö n ‑kɔwlöömɛ ‑nu ‑wo ‑dhö 'ö 'ma‑ pö mɛ do ‑dhɛ: ‹‑Bhö 'dho ‑dhɛ 'ö ꞊ni‑ 'gü!› 'ö dho 'ö 'ma‑ pö‑ mɛ 'bha ‑dhɛ: ‹‑Bhö nu!› 'ö nu, 'ö 'ma‑ pö ma gwëëmi do ‑dhɛ: ‹‑Bhö ‑a kë ꞊ni!› 'ö‑ ‑kë. (\"Sanni n ‑bha ‑zë ‑yö kë \"dhʋ̈ bha ‑oo, 'yö bhi ‑zë ꞊wɛ?)» ");
INSERT INTO daf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","꞊Dhɛ 'ö Yesu ꞊yaa‑ ‑wʋ ma ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö‑ \"dhia ‑yö ma‑ 'gü, 'yö‑ pö 'mɛ 'wo gun‑ ꞊keng‑ bha‑ ‑nu ‑dhɛ: «‑Ka ‑dhɛ ‑ga, a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'dhang ‑bho n \"dhiʋ̈ ‑kɔ suu ya, 'mii‑ yö mɛ 'bha ‑gɔ Izraɛdhö ‑sɛ ‑zian ya‑ 'gü do kö maa ‑dhɛ \"wɛɛ ꞊në‑ pö!» ");
INSERT INTO daf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","\"Kɛɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ mɛ 'gbɛ ꞊dede ‑dho 'go 'yënng‑ ‑wo ‑zian 'ka, 'wo go 'yënng‑ ‑pö ‑zian 'ka 'wo pë ‑bhö wo 'kwëë‑ waa‑ Ablaamö ‑nu, Izaakö ‑nu waa‑ Zakɔbö ‑nu 'dhö Atanna ‑bha ‑gblüdëdhɛkëdhɛ 'ö dhang‑ 'gü bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","'Yö 'mɛ 'kö‑ ‑dhɛ gun‑ ‑bha ‑dhɛ ‑wo ‑da Atanna ‑bha ‑gblüdëdhɛkëdhɛ bha‑ 'gü bha 'wo‑ ‑nu ‑zuö \"kpɛnng ‑dhɛtiidhɛ 'gü, ('yö 'wo ꞊saan mü,) 'yö 'wo \"gbʋ bɔ kö ‑wo wo \"sɔn \"dhiʋ̈ ‑bhö sië klöklödhö.» ");
INSERT INTO daf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","꞊Dhɛ 'ö Yesu ꞊ya dhiang bha‑ zë‑ ‑nu ‑dhɛ \"dhʋ̈, 'yö‑ pö \"sɔdha ‑gɔmɛ bha‑ ‑dhɛ: «‑Bhö 'dho i ‑gɔ 'kɔɔdhö, ‑yö ‑dho kë i ‑dhɛ ꞊dhɛ ‑kɔ 'i ‑zʋ yö‑ 'ka n ‑dhɛ bha‑ 'dhö!» ‑A \"tʋ̈ng ꞊dede 'wo‑ pö sië‑ 'ka \"dhʋ̈ bha, 'yö \"sɔdha ‑gɔmɛ ‑bha gwëëmi bha 'ö ‑kë 'ka \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu waa‑ ‑bha ꞊klang ‑nu 'wo dho Piɛdhö ‑gɔ 'kɔɔdhö. 'Yö ‑kpan Piɛdhö ‑bha dhebhɔ dhe ‑bha kö \"nɛnɛ ꞊ya nu‑ ‑ta kö ‑yö 'waanu ‑sü 'ka‑ 'ka \"wɛ tɔnklɔɔndhö. ");
INSERT INTO daf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","'Yö ö ‑kɔ pa‑ ‑kɔ 'ka. ‑Yö ‑to ‑dhɛ do bha‑ 'gü 'ö \"nɛnɛ ‑yö ‑kan 'gü, 'yö ꞊wlü 'ö‑ ‑nu \"dhiʋ̈ ‑ziö wo. ");
INSERT INTO daf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","꞊Dhɛ 'ö yɛan\" \"piʋ̈ ꞊ya ꞊loo, 'yö 'wo nu mɛ 'gbɛ 'ö \"yina yaa ‑nu 'wo‑ ‑nu 'gü ‑a ‑nu 'ka Yesu ‑dhɛ. 'Yö \"yina yaa ‑nu bha‑ ‑nu ‑kë ö ‑wʋ 'ka, 'yö \"yuëdhi \"pɛpɛ 'wo gun 'mü ‑a ‑nu ‑kë \"klʋ̈ʋ̈klʋ̈ 'pö. ");
INSERT INTO daf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","‑Wʋ 'ö Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑ya pö yi 'bha 'ka bha‑ 'gü ‑wɔn ‑yö ‑kë ‑kɔ bha ꞊në‑ 'gü ꞊dhɛ: «‑Yö yi ꞊niɔɔdhɛ ‑nu ‑bho yi ‑bha, 'ö yi ‑bha \"yua ‑nu ‑kwɛɛ bho yi ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","꞊Dhɛ 'ö Yesu ꞊ya 'mɛ 'wo ꞊klëën‑ ‑zü bha‑ ‑nu ‑ta ‑ga, 'yö‑ pö‑ ‑bha ꞊klang ‑nu ‑dhɛ ꞊dhɛ ‑wo \"yi \"kan kö ‑wo bɔ \"yi ꞊taama. ");
INSERT INTO daf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'Yö Zuifö ‑nu ‑bha 'tɔnggɔmɛ do ‑yö ꞊yɔɔn‑ \"sɔɔ 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ, ‑dhɛ \"pɛpɛ 'i dho 'dho‑ 'gü, a ‑dho 'dho i ꞊keng‑.» ");
INSERT INTO daf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «\"Sakpadë ‑nu ‑wɔ 'gü ‑yɛ ‑yö ‑dhö, 'ö ‑maa ‑nu ‑dɩ 'pö 'wo 'kɔ ‑nu dɔ 'wo ‑wɔ 'gü, \"kɛɛ mang Mɛgbömɛ ‑zë ‑dhɛ ‑zian 'a dho n \"tɛɛ pa‑ 'gü 'yaa 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","‑Wo ‑to ‑dhɛ do bha‑ 'gü, 'yö‑ ‑bha ꞊klang ‑nu bha‑ mɛ do ‑ya pö‑ ‑dhɛ: «N Dëmɛ, ‑bhö dɔ \"gbɩɩ‑ bhɛa\" ꞊në 'a‑ wo i ‑dhɛ kö 'i i ‑kɔ bho n 'gü ꞊kö kö 'a 'dho, kö n dë ꞊ya ga 'ma‑ ‑wɛɛ bho kö 'a nu 'a 'to i ꞊keng‑ ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Bhi ‑zë ‑bhö nu kö 'kwa 'dho! ‑Bhö kwaa‑ 'mɛ Atanna ‑ya ‑nu ‑sü ꞊dhɛ mɛ ꞊gee 'dhö bha‑ ‑nu ‑zü kö ‑wo wo 'ko ‑nu ‑wɛɛ bho.» ");
INSERT INTO daf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","꞊Dhɛ 'ö Yesu ꞊ya bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö ‑da \"yitagɔ 'gü waa‑ ‑bha ꞊klangdhiʋ̈ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","'Wo dho \"kan wo ‑ta kö \"tɛɛ \"gbɩɩ‑ ꞊ya ‑ya ziö ‑sü ‑bha, kö \"yitagɔ ꞊ya ‑ya ꞊bang \"bang kë ‑sü ‑bha, kö \"yi ‑yö ‑ma sië‑ ‑bha \"gbɩɩ‑ 'ka, kö \"yi kpö ‑nu ‑wo \"wlü sië ‑dhɛ ꞊gban \"pɛpɛ 'gü, 'ö‑ 'bha ‑nu 'wo ‑pö ‑nu wo \"yitagɔ 'gü ‑dhɛ ‑nu 'gü, \"kɛɛ kö Yesu ‑zë ‑yö yi ꞊në‑ zë sië. ");
INSERT INTO daf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","'Yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ 'wo pa‑ ‑bha, 'yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, ‑bhö kwa dha ‑dhe, ga ꞊ya dun kwa ‑ta ꞊zɔɔ ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Më ꞊në ‑kë 'yö 'ka ‑suʋ̈ \"gbɩɩ‑ \"dhʋ̈? Ka 'dhang bho ‑sü ꞊në 'yaa n \"dhiʋ̈ 'kpakpadhö ‑ee?» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ꞊wlü 'yö ꞊gbla \"tɛɛ 'ö gun ziö sië bha waa‑ \"yi 'ö gun ꞊bang \"bang kë sië 'pö bha‑ ‑nu ‑ta, 'yö ‑dhɛta ‑yö dɔ dingdhö. ");
INSERT INTO daf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Yö‑ 'wɔn ‑yö mɛ ꞊gban kɔn, 'yö 'wo ‑ya pö ‑sü ‑bha: «De suu ꞊në ꞊ni ꞊zɔɔ 'yö \"tɛɛ ‑nu waa‑ \"yi ‑nu ꞊gban 'wo‑ ‑wʋ ma ꞊ni ‑oo?» ");
INSERT INTO daf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","꞊Dhɛ 'ö Yesu ꞊ya \"yi \"kan ꞊ya bɔ \"yi ꞊taama Gadadha ‑mɛ ‑nu ‑gɔ \"sɛ 'gü ‑zian \"piʋ̈, 'yö gɔɔn‑ ‑nu ꞊plɛ 'wo go mɛ ‑wɛɛbhodhɛ 'bha bha‑ 'gü 'wo nu‑ \"dhiʋ̈ ‑gɔ. Mɛ ꞊plɛ 'wo \"dhʋ̈ bha \"yina yaa ‑yö ‑gun ‑nu 'gü, ‑a ‑nu \"kɛɛkë ‑kɔ yaa bha‑ ‑wɔn 'gü kö zian 'ö bɔ ‑dhɛ bha‑ 'gü ꞊ya \"kan, kö mɛ 'bha 'yaa bɔ mü 'zü. ");
INSERT INTO daf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","'Yö 'wo ‑ya \"gbla ‑sü ‑bha 'wo‑ pö: «Atanna Gbö, i ‑bha ‑më ‑wɔn ꞊në yi ‑bha! \"Ɛɛn ‑yö i \"piʋ̈ ꞊dhɛ 'i 'wɔn wɔ yi ‑ta kö‑ \"tʋ̈ng 'yii ꞊loo ꞊kö ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","\"Tʋ̈ng 'wo‑ pö sië‑ 'ka \"dhʋ̈ bha kö ‑bhɔ ‑kplü 'kpii‑ do ‑yö bhɔ sië‑ ‑nu \"sɔɔ ‑dhɛ 'bha 'gü mü. ");
INSERT INTO daf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","'Yö \"yina ‑nu bha 'wo ‑ya bhɛa\" ‑sü ‑bha Yesu ‑dhɛ 'wo‑ pö: «꞊Ya kë ꞊dhɛ 'i dho yi \"piʋ̈ ‑zë kë 'mɛ 'wo ya‑ ‑nu 'gü kö ‑bhö dɔ \"gbɩɩ‑ bhɛa\" ꞊në 'yi‑ wo i ‑dhɛ kö 'i yi bɔ ‑bhɔ ‑kluu ya‑ 'gü!» ");
INSERT INTO daf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «'Ma \"wɩ‑ ‑bha, ‑ka 'dho!» 'Yö \"yina yaa ‑nu bha 'wo 'go gɔɔn‑ ‑nu ꞊plɛ bha‑ ‑nu 'gü, 'yö 'wo ‑sɔ ‑bhɔ ‑kluu bha‑ 'gü. 'Yö ‑bhɔ ‑nu bha 'wo ‑sɔ ‑bɛang 'sü ‑sü ‑bha goo ‑bha ‑dhɛ bha‑ 'gü, 'yö 'wo dho 'wo ꞊wɛnng \"yi ꞊bhaa 'yö \"yi ‑ya ‑nu ꞊gban zë dee\" wo \"pɛpɛdhö. ");
INSERT INTO daf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö ‑bhɔ ‑kpluu bha‑ ‑gɔdhiʋ̈mɛ ‑nu 'wo ‑ziö ‑bɛang 'ka 'wo dho 'wo ‑wo 'pödhö. 'Yö 'wo ‑ya 'wɔn bha‑ ‑gɛn dɔ ‑sü ‑bha mɛ ‑nu ‑dhɛ waa‑ 'wɔn 'dhɛ 'ö ‑gban mɛ ꞊plɛ 'ö \"yina yaa ‑yö gun‑ ‑nu 'gü bha‑ ‑nu ‑bha bha‑ 'dhö 'pö. ");
INSERT INTO daf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö mɛ \"pɛpɛ 'wo 'pö‑ bha‑ 'gü bha 'wo kpö dɔ 'wo dho dɔ Yesu ‑gɔ zian‑. ꞊Dhɛ 'wo ‑kpan ‑bha, 'yö 'wo ꞊bhɛa‑ ‑dhɛ kö ‑yö 'dho ‑yö 'go wo ‑gɔ \"sɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","꞊Dhɛ 'wo‑ pö Yesu ‑dhɛ \"dhʋ̈, 'yö ‑da \"yitagɔ 'gü 'yö \"yi bha‑ ‑kan 'zü ‑deewo 'yö dho ö ‑gɔ 'pödhö Kapɛɛnaɔmö. ");
INSERT INTO daf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Yö 'wo nu‑ ‑dhɛ ‑gɛnloomɛ do 'ö wɔ ‑sü 'ka \"gbang ‑ta ‑a 'ka. ꞊Dhɛ 'ö Yesu ꞊yaa‑ 'wɔn dɔ ꞊dhɛ mɛ 'wo bha ‑zʋ ‑yö ö ‑dhɛ ‑sü ‑ya ‑nu ‑gɔ, 'yö‑ pö ‑gɛnloomɛ bha‑ ‑dhɛ: «‑Bhö i ‑zʋ ‑gban, n \"taɔngdë, 'ma i ‑bha 'wɔn yaa ‑nu ‑mawɔn 'to!» ");
INSERT INTO daf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'Yö Zuifö ‑nu ‑bha 'tɔnggɔmɛ 'bha ‑nu 'wo ‑ya ‑a pö ‑sü ‑bha wo zuë\" \"piʋ̈ ꞊dhɛ: «'Mɛ 'ö ya ꞊ya ‑da Atanna \"dhiʋ̈!» ");
INSERT INTO daf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","꞊Dhɛ 'ö ‑kë 'pö ꞊dhɛ Yesu ‑ya ‑nu ‑zʋgɔngüwɔn ‑nu bha‑ ‑dɔ bha 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Më ꞊në ‑kë 'yö ‑zʋgɔndhe suu bha 'ö ‑da ka zuë\" \"piʋ̈? ");
INSERT INTO daf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‑A pö ‑sü 'ö \"trüünyuamɛ ‑dhɛ ꞊dhɛ ‹‑bhö \"wlü kö 'i i ‑wɔtapë 'sü 'kii ziö› waa‑ pö ‑sü 'ö‑ ‑dhɛ ꞊dhɛ ‹'bɔn ꞊ya 'go i ‑bha» ‑a ‑mɛɛ ꞊në \"gbɩɩ‑?› ");
INSERT INTO daf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","\"Kɛɛ ‑a kë 'a‑ wo bha a‑ ‑kë \"dhʋ̈ kö 'ka‑ 'wɔn ꞊në‑ dɔ ꞊dhɛ mang Mɛgbömɛ n ‑kɔ ‑yö ‑mɔɔ ‑bha kö 'a mɛ ‑bha 'wɔn yaa ‑nu ‑mawɔn 'to \"kpʋng ya‑ ꞊taa.» ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑ya pö \"trüünyuamɛ bha‑ ‑dhɛ: «‑Bhö \"wlü kö 'i i ‑wɔtapë 'sü 'i 'dho i ‑gɔ 'kɔɔdhö!» ");
INSERT INTO daf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'Yö gɔndënë bha 'ö ꞊wlü, 'yö ö ‑wɔtapë sü 'yö ‑ziö. ");
INSERT INTO daf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","꞊Dhɛ 'ö mɛ \"dhaa 'wo gun ‑dhɛ bha‑ 'gü bha‑ ‑nu \"yan ꞊ya ‑da 'wɔn bha‑ ‑dhɛ 'gü, 'yö \"suʋ̈ 'dhö ‑da ‑nu 'gü 'yö 'wo ‑ya Atanna 'tɔ bhɔ ‑sü ‑bha 'wɔn suu ‑nu bha‑ kë ‑faan 'ö‑ nu mɛbhɩɩdhe ‑dhɛ bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ziö 'ö dho. ‑A 'dho ‑sü 'ka 'yö ‑kpan gɔndë do 'wo‑ ‑dhɛ Matiö ‑a ‑bha kö ‑yö ‑ya sië 'nii‑ sɔng ‑bho 'gü ‑kɔ 'gü 'yö‑ pö‑ ‑dhɛ: «‑Bhö nu kö 'i ‑da n ꞊keng‑!» 'Yö Matiö ‑yö ꞊wlü 'yö ‑ziö ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yi do 'ka kö Yesu ‑yö pë ‑bhö sië Matiö bha‑ ‑gɔ 'kɔɔdhö, 'yö 'niisɔngkunmɛ ‑nu 'gbɛ waa‑ 'mɛ 'ö‑ ‑nu 'tɔ ꞊ya zë ‑a ‑nu këwɔn yaa ‑nu ‑wɔn 'gü bha, 'wo nu 'wo wo ‑yɛa kun Yesu waa‑ ‑bha ꞊klang ‑nu ‑a ‑nu kpö 'gü pë ‑bhö ‑dhɛ 'gü mü. ");
INSERT INTO daf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","꞊Dhɛ 'ö Fadhiziɛn ‑nu 'wo‑ ‑dhɛ yö \"dhʋ̈ 'yö 'wo‑ pö‑ ‑bha ꞊klang ‑nu ‑dhɛ: «‑Më ꞊në ‑kë 'yö ka ‑gɔmɛ waa‑ 'niisɔngkunmɛ, ꞊flümɛ ‑nu bha waa‑ 'mɛ 'ö‑ ‑nu 'tɔ ꞊ya zë ‑a ‑nu kë ‑sɔng ‑nu ‑wɔn 'gü bha 'wo pë ‑bhö sië wo \"kwëë?» ");
INSERT INTO daf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","꞊Dhɛ 'ö Yesu ꞊yaa‑ ‑nu ‑wʋ bha‑ ma, 'yö‑ pö‑ ‑nu ‑dhɛ: «'Mɛ 'ö \"yua 'yaa‑ ‑nu ‑bha bha, ‑a ‑nu ‑mawɔn 'yaa zun ‑dhɔtrɔɔ ‑bha, \"kɛɛ 'mɛ 'ö‑ ‑nu 'gü 'yaa ‑së bha ꞊në 'wo ‑dhɔtrɔɔ ꞊mɔɔ; ");
INSERT INTO daf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‑a ‑gɛn ‑mü ꞊dhɛ 'pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'sëëdhɛ 'gü ‑ya ‑pö: ‹'Mɛ 'ö mɛ ‑nu ‑wëë ‑ga 'yö‑ ‑dhɔ ‑yö n ‑kë, \"kɛɛ \"saapë ‑nu ‑zë \"dhia 'yaa n 'gü 'gbɛ.› ‑Ka 'dho kö 'ka ‑wʋ bha‑ 'klɔɔ‑ mɔɔ‑! \"Kɛɛ ma ‑zë 'mii nu 'mɛ 'wo‑ pö wo ‑dɩ ‑dhɛ ꞊dhɛ pö 'aa wo ‑bha wo ‑zë ‑a ‑nu ‑dhɛ ‑dhɛ 'gü, a ‑nu kö 'a 'wɔnyaakëmɛ ‑nu ꞊në‑ ‑nu ‑dhɛ kö ‑wo wo bo 'wɔn yaa kë ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Zan Mɛzumɛ ‑bha ꞊klang ‑nu 'wo nu 'wo ꞊yɔɔn Yesu \"sɔɔ, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «‑Yö ‑kë mü ꞊dhɛ 'yö yaa‑ Fadhiziɛn ‑nu ‑zë 'yi 'sunng‑ ma ‑kpɛawo (꞊dhɛ ‑kɔ 'ö Atanna ‑wʋ ‑ya pö‑ 'ka ‑a 'dhö), 'yö i ‑bha ꞊klang ‑nu ‑zë 'waa‑ 'ma?» ");
INSERT INTO daf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Mɛ 'wo‑ ‑nu ‑dhɛ dhe 'sü troo kë ‑dhɛ 'gü ‑a ‑dhɛ 'yaa‑ ‑bha ꞊dhɛ ‑wo wo wë 'gü ‑siö \"tʋ̈ng 'ö dhesügɔn 'dhö‑ 'ka‑ ‑nu \"piʋ̈ bha‑ 'ka (‑a ‑gɛn ‑mü ꞊dhɛ kö‑ ‑nu ꞊nii ‑yö ‑da sië), \"kɛɛ ‑a \"tʋ̈ng ‑yö nu sië 'ö 'wo dho dhesügɔn 'sü‑ 'ka‑ ‑nu ‑gɔ; ‑a \"tʋ̈ng bha ꞊në 'wo dho 'sunng‑ 'ma‑ 'ka (‑a ‑gɛn ‑mü ꞊dhɛ kö zuëdhiʋ̈tɛɛ ꞊ya ‑ya ‑nu ‑bha). ");
INSERT INTO daf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‑A ‑gɛn ‑mü ꞊dhɛ mɛ 'bha 'yaa sɔ \"kplü ‑dee ꞊nëng sɔ zii ‑bha kö ‑ya ‑wɔ. ꞊Ya kë \"dhʋ̈ ‑a sɔ \"pɛn ‑dee bha ‑ya zii bha‑ ‑gan 'ö‑ \"pɛ ‑dhɛ ‑da \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","\"Ɛɛn 'waa we ‑kiansü ‑da puu\" zii 'gü, ‑a puu\" ‑yö ‑wü 'ö‑ we ‑yö ꞊wɛnng 'yö ‑kë pë see‑ ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ‑yö ‑to dhiang ‑zë ‑a ‑nu ‑dhɛ ‑dhɛ 'gü, 'yö Zuifö ‑nu ‑gɔmɛ do ‑yö nu 'yö zun ö kpiö 'gü ‑a ‑kuu \"dhiʋ̈ 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ, n 'dhu ꞊ya ga ‑dede ya‑ 'gü ‑wa! ‑Bhö \"ta n ‑dhɛ kö 'i i ‑kɔ 'pa‑ 'ka kö ‑yö ‑bö ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","'Yö Yesu waa‑ ö ‑bha ꞊klang ‑nu 'wo ‑ziö ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","꞊Dhɛ 'wo 'dho sië 'yö dhebhɔ do 'ö ꞊yɔɔn yën ‑yua ‑yö zun‑ ‑bha 'ö‑ ‑kwɛ ꞊ya kë ‑kaɔng do ga ꞊plɛ bha 'ö bɔ Yesu ꞊kee‑ ‑ta 'yö ö ‑kɔ pa‑ ‑bha ‑sɔ \"zɔ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","‑A kë 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ ‑yö ö ‑zʋ ‑gɔn ꞊dhɛ: «'Ya ꞊mɔɔ‑ ‑bha kö ö ‑kɔ ‑zian ‑yö 'pa‑ ‑bha sɔ \"zɔ 'ka kö‑ ‑bha \"yua ya ꞊ya bo ꞊naa bha.» ");
INSERT INTO daf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","꞊Dhɛ 'ö ꞊ya ö ‑kɔ \"yɛ‑ ‑bha sɔ \"zɔ ‑bha ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö Yesu ‑yö ꞊slëë ö 'gü. ꞊Dhɛ 'ö‑ yö, 'yö‑ pö‑ ‑dhɛ: «i ‑zʋ ‑gban, n \"tɛado, i ‑bha ‑zʋ ‑yö n ‑dhɛ ‑sü ꞊ya i dha!» ꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, dhebhɔnë bha ‑yö ‑to ‑dhɛ do bha‑ 'gü 'yö‑ ‑bha \"yua ‑yö bo. ");
INSERT INTO daf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö dho 'yö ꞊loo Zuifö ‑nu ‑gɔmɛ bha‑ ‑gɔ 'kɔɔdhö kö \"truupiömɛ ‑nu waa‑ mɛ \"wɛɛwɛɛ ‑nu ‑wo \"gbʋ bɔ sië, 'ö 'wo ꞊gbang dɔ‑ 'ka yuudhö kö ‑wo ‑gblagbla ‑nu bho sië. 'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«‑Ka 'go, ‑ka zun \"kpɛnng! 'Në ya 'yii ga, ‑yö yi ꞊në‑ zë!» 'Yö 'wo ꞊wɛɛ dɔ‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","꞊Dhɛ 'ö ꞊wa 'mɛ 'wo bha‑ ꞊gban zun \"kpɛnng, 'yö Yesu ‑yö ‑da 'kɔdhi bha‑ 'gü, 'yö 'nëdhebhɔ bha‑ ‑bö, 'yö‑ kun‑ ‑kɔ ‑bha 'yö‑ ꞊wlü. ");
INSERT INTO daf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","'Yö 'wɔn bha‑ ‑taɔng ‑yö sɔ \"sɛ bha‑ 'gü ‑dhɛ ꞊gban \"pɛpɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","꞊Dhɛ 'ö Yesu ꞊ya 'go ‑dhɛ bha‑ 'gü 'ö dho sië ö \"dhiʋ̈, 'ö ziö sië ‑dhɛ 'bha bha‑ 'gü, 'yö \"yan ꞊wlümɛ ꞊plɛ 'wo ‑ziö ꞊keng‑ \"gbla ‑sü 'ka kö ‑wa pö sië: «(Yi \"bhɛma) Davi Gbö, ‑bhö yi ‑wëë ‑ga ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ‑da 'kɔɔdhö, 'yö \"yanwlümɛ ꞊plɛ bha 'wo ꞊yɔɔn‑ \"sɔɔ, 'yö Yesu ‑ya ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «Ka 'dhang ‑bho \"dhiʋ̈ ꞊dhɛ a ‑mɔɔ ‑bha 'a ka ‑kë \"klʋ̈ʋ̈klʋ̈ ‑ee?» 'Yö 'wo‑ pö‑ ‑dhɛ: «꞊Iin! Yi Dëmɛ, 'yi 'dhang ‑bho \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö ö ‑kɔ pa‑ ‑nu \"yan 'ka 'yö‑ pö: «Kö ‑yö kë 'sa ka ‑dhɛ ꞊dhɛ ‑kɔ 'ka ka ‑zʋ yö‑ 'ka n ‑dhɛ bha‑ 'dhö!» ");
INSERT INTO daf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'Yö mɛ ꞊plɛ bha‑ ‑nu \"yan ‑yö ‑dhɛ yö. 'Yö Yesu ‑yö ‑dhio dɔ‑ ‑nu ‑ta glɔglɔdhö 'ö‑ pö: «‑Ka ka \"tʋ 'to ‑së 'ka, 'wɔn ya mɛ 'bha 'ya dho‑ ma!» ");
INSERT INTO daf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","\"Kɛɛ ꞊dhɛ 'ö ꞊wa zun \"kpɛnng, 'yö 'wo to 'wo zun‑ ‑dhiang ‑zë \"sɛgɔ \"pɛan 'dhɛ bha‑ 'gü ‑sü ‑bha ‑dhɛ ꞊gban \"pɛpɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","꞊Dhɛ 'ö ꞊ya 'go ‑dhɛ 'dhɛ bha‑ 'gü 'ö 'dho sië, 'yö 'wo nu‑ ‑dhɛ gɔndënë do 'ö \"yina yaa 'dhö‑ 'gü ‑a 'ka. Gɔndënë 'ö \"dhʋ̈ bha ‑yö ‑gun \"bhʋbhʋ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","꞊Dhɛ 'ö Yesu ꞊ya \"yina yaa bha‑ kë 'ö ꞊ya 'dho, 'yö gɔndënë bha 'ö ‑ya dhiang zë ‑sü ‑bha. 'Yö 'wɔn bha‑ 'wɔn ‑yö mɛ kpö 'gbɛ 'wo gun mü bha‑ ‑nu kɔn 'yö 'wo‑ pö: «'Wɔn 'dhɛ 'kö‑ suu 'dhö ya 'yii‑ ‑dhɛ yö Izraɛdhö ‑sɛ ya‑ 'gü do ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","\"Kɛɛ kö Fadhiziɛn ‑nu ‑zë ‑wa pö sië Sɔtraan ꞊në 'gügbɩɩdhɛ suu bha‑ ‑nu Yesu ‑dhɛ 'yö \"yina yaa ‑nu kë sië‑ 'ka mɛ 'gü bha.» ");
INSERT INTO daf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ‑yö ‑gun ziö sië 'pö‑ ‑nu ‑bhiëë ‑ta 'dɔɔɔndhö kö ‑yö 'dho sië Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü 'ö dhiang zë mɛ ‑nu ‑dhɛ, naɔ ‑së 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑bha ‑a pö ‑sü 'ka kö ‑yö \"yuëdhi suu ꞊gban \"pɛpɛ ‑bha \"yua ‑nu bho sië‑ ‑nu ‑bha, 'ö ꞊niɔɔmɛ ‑nu suu ꞊gban \"pɛpɛ ‑kë \"klʋ̈ʋ̈klʋ̈ 'pö. ");
INSERT INTO daf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","'Yö ‑wëë 'dhö ‑ya ‑da ‑ta ‑sü ‑bha mɛ kpö 'gbɛ 'ö‑ ‑nu yö sië bha‑ ‑nu ‑wɔn 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ kö‑ ‑nu 'gü ꞊ya ga, kö faan 'yaa‑ ‑nu 'gü 'zü, kö ꞊wa kë ꞊dhɛ \"bhlaa ‑nu 'ö‑ ‑nu ‑maakëmɛ 'yaa 'dhö 'ö ꞊wa ‑pɛn ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'Wɔn 'ö‑ ‑wɔn 'gü 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ ꞊dhɛ: «‑Bɔ Atanna 'ka ‑dhɔ 'dhö 'mɛ 'ö‑ ‑nu ‑bha ‑wo 'gbɛ ꞊dedewo, \"kɛɛ 'ö ꞊dhɛ ‑mlü \"kan ‑sü 'dhö, kö‑ \"kanmɛ ꞊në 'yaa 'dhö bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'Yö‑ pö ꞊dhɛ 'ö \"dhʋ̈ kö ‑ka bhɛa\" Atanna ‑dhɛ kö 'ö ꞊dhɛ ‑mlü \"kan ‑sü 'dhö kö ‑yö mɛ bɔ kö ‑wa \"kan!» ");
INSERT INTO daf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","'Ö go mü 'yö Yesu ‑yö ö ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ ‑nu ‑dhɛ, 'yö 'gügbɩɩdhɛ ‑nu ‑nu ‑dhɛ kö ‑wo \"yina yaa ‑nu kë‑ 'ka mɛ ‑nu 'gü, kö‑ ‑nu ‑kɔ ‑yö ziö‑ 'ka \"yua suu ꞊gban \"pɛpɛ ‑gɔ, waa‑ ꞊niɔɔ ‑kɔ suu ꞊gban 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesu ‑bha bɔmɛ ‑nu 'wo \"dhʋ̈ bha‑ ‑nu 'tɔ ꞊nɛ: ‑A mɛ ‑blɛɛsü ꞊nɛ 'wo‑ ‑dhɛ Simɔ 'yö 'wo‑ ‑tɔ ‑ya ‑ta ‑dhɛ Piɛdhö, 'yö‑ dheebhang Andre, 'yö Zakö waa‑ ö dheebhang Zan 'wo kë Zebede gbö ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","'Yö Fidhipö, Batedhemi, Toma, Matiö 'ö ‑kë 'niisɔngkunmɛ 'ka, 'yö Zakö 'ö ‑kë 'pö Adhöfe gbö 'ka, 'yö Tade, ");
INSERT INTO daf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","'yö Simɔ 'ö ‑kë \"sɛtakozëmɛ 'ka waa‑ Zuda Isikadhiɔtö 'ö Yesu ‑da ö 'yaɔ‑ ‑nu ꞊kwɛɛ‑ bha. ");
INSERT INTO daf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Yesu ‑bha bɔmɛ ‑nu ‑kaɔng do ga ꞊plɛ bha‑ ‑nu 'tɔ ꞊në bha: 'Mɛ 'wo bha ꞊në Yesu ‑ya ‑nu bɔ 'yö ö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: Izraɛdhö ‑mɛ ‑nu 'ö ꞊wa 'go Atanna ‑bha zian ‑ta ꞊wa kë ꞊dhɛ \"bhlaa ‑nu 'ö‑ ‑nu ‑gɔdhiʋ̈mɛ 'yaa 'dhö, 'ö ꞊wa ꞊dhɛng ‑a ‑nu 'dhö bha ꞊në ‑ka 'dho‑ ‑nu ‑zian 'ka, 'ka 'dho 'dho 'mɛ 'waa Izraɛdhö ‑mɛ ‑nu 'ka bha‑ ‑nu ‑zian 'ka, 'ka 'dho ‑da Samadhi ‑pö ‑nu 'bha ‑zian yaan‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","‑Ka ‑da zian ‑gloo \"piʋ̈ ‑dhɛ ‑nu 'gü kö 'ka Atanna ‑wʋ pö‑ ‑nu ‑dhɛ 'ka‑ pö: «Atanna ‑bha ‑gblüdëdhɛ bha ꞊ya dun ka ‑ta! ");
INSERT INTO daf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","'Ka 'dho ‑ka \"yua ‑nu bho mɛ ‑nu ‑bha kö 'ka 'mɛ ꞊wa ga ‑a ‑nu ‑bö kö 'ka ꞊wee ‑yua bho mɛ ‑nu ‑bha, kö 'ka \"yina yaa ‑nu kë 'ka‑ ‑nu bho mɛ 'gü! 'Gügbɩɩdhɛ 'ö Atanna ‑ya nu ka ‑dhɛ kö 'ka pë ‑nu bha‑ ‑nu kë‑ 'ka bha ‑ya ‑gbaɔ ka ‑gɔ \"wɛɛwɛɛ. Kaa ‑dɩ 'pö, ‑ka 'wɔn ‑së ‑nu bha‑ kë mɛ ‑nu ‑dhɛ \"wɛɛwɛɛ. ");
INSERT INTO daf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","'Ka dho \"sënng waa‑ 'wëë‑ ‑da ka ‑ta (‑a ‑gɛn ‑mü ꞊dhɛ 'pë ka ‑mawɔn ‑yö zun‑ ‑bha ‑wo ‑dho ‑a nu ka ‑dhɛ). ");
INSERT INTO daf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","꞊Ya 'go mü 'zü, 'ka 'dho \"ta ‑kpɔ 'ka glɛɛ\" 'kun ka ‑kɔ \"piʋ̈, 'ka 'dho \"bhɛɛ ꞊plɛ ‑naa 'sü, ‑sabha 'ya 'dho kë ka ‑gɔ, \"ɛɛn \"dhü 'ya 'dho kë ka ‑kɔ \"piʋ̈! ‑A ‑gɛn ‑mü ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'mɛ 'ö yë kë sië, 'ö‑ kë sië 'mɛ 'ö‑ ‑dhɛ bha ‑ya gba ‑bhöpë 'ka. ");
INSERT INTO daf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","꞊Ya kë ꞊dhɛ 'ka ‑da 'pö‑ \"gblʋ̈gblʋ̈ ‑nu 'gü, \"ɛɛn 'pö‑ 'sɛɛnnë ‑nu 'gü, 'mɛ 'ö dho ‑kɔ ‑ya ka ‑dhɛng ‑bha, ‑kaa mɛ mɔɔ‑ kö 'ka 'dho‑ ‑gɔ 'kɔɔdhö 'ka 'to mü ‑yö 'dho ‑yö zun‑ 'ka ka ‑bha ‑go 'pö‑ bha‑ 'gü ‑yi ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Kɔ \"pɛpɛ 'ö 'ka dho ‑da 'gü, ‑kaa pö‑ 'gü ‑mɛ ‑nu ‑dhɛ: «Zuëwaanusü ‑yö kë ka ‑gɔ! ");
INSERT INTO daf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","꞊Ya kë ꞊dhɛ 'kɔ bha‑ 'gü ‑mɛ ‑nu ꞊wa ka ‑dhɛng bun, kö ka ‑bha zuëwaanu 'dhuë‑ 'ka‑ ‑kë ‑nu ‑bha bha ‑yö ‑dho ‑nu 'kun‑. \"Kɛɛ ꞊ya kë ꞊dhɛ 'wii ka ‑dhɛng 'kun, 'dhuë‑ bha 'yii 'dho‑ ‑nu 'kun‑ ‑yö ‑dho ö yee kë 'ö nu ka \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","꞊Ya kë ꞊dhɛ 'ka ‑da 'pö‑ 'bha 'gü, \"ɛɛn 'ö 'kɔ ‑zian ꞊në‑ 'ka 'ö 'wii \"wɩ‑ ‑bha kö ‑wo ka ‑dhɛng 'kun, \"ɛɛn kö ‑wo wo \"tʋ ‑to ka ‑wʋ ‑bha, ‑ka 'go mü kö 'ka ka ‑gɛn ‑bha ‑ma kö \"sɛ 'ö dɔ ka ‑gɛn ‑bha 'pö‑ bha‑ 'gü bha ‑yö 'go ka ‑gɛn ‑bha (kö‑ ‑nu ‑bha \"dhang bha ‑yö dɔ‑ ‑nu ‑ta). ");
INSERT INTO daf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Zadɔyi 'ka 'wɔn 'ö ‑wɔ Sodɔmö waa‑ Gomɔɔ ‑mɛ ‑nu ‑ta, ‑yö ‑dho kë 'dɛdɛ 'pödhɛ bha‑ 'gü ‑mɛ ‑nu ‑bha ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","'Yö Yesu ‑yö dhiang zë‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka ka \"tʋ 'to! Ka bɔ 'a‑ wo sië bha a ka ‑bɔ ꞊dhɛ \"bhlaanë 'wo‑ bɔ laa ‑nu kpö 'gü ꞊në‑ 'dhö. ‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, ‑ka kë ‑glengsü kö ka \"gblʋ̈ʋ̈dhɛ ‑yö kë \"puu! ");
INSERT INTO daf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kö 'ka ka ‑zʋ kë ka ‑dɩ 'gü mɛ \"bhɩɩ‑ ‑nu ‑gɔ, ‑a ‑gɛn ‑mü ꞊dhɛ ‑wo ‑dho 'dho ka 'ka zadɔgükɔ ‑nu 'gü, 'ö 'wo ka ‑ma ‑nu wo ꞊klangga 'ka Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","'Ö 'wo dho ka 'ka mɛ ‑gɔdhiʋ̈mɛ ‑nu waa‑ ‑gblüdë ‑nu ‑kuu \"dhiʋ̈ ‑dhɛ ‑nu 'gü n ‑wɔn 'gü kë \"dhʋ̈ kö 'ka \"sɛɛdhɛ kë n ‑bha ‑a ‑nu ‑dhɛ, \"ɛɛn 'mɛ 'waa Zuifö 'ka ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","\"Kɛɛ ꞊wa ka 'kun ꞊wa 'dho ka 'ka zadɔgükɔ ‑nu 'gü (n ‑wɔn 'gü), 'ka 'dho ‑ya dhiang ‑nu 'ka dho‑ zë, \"ɛɛn ‑kɔ ‑nu 'ka dho‑ zë‑ 'ka ‑a zuën ‑ta. ‑A \"tʋ̈ng ꞊dede bha‑ 'ka, ‑wʋ ‑nu 'ö 'ka dho‑ pö ‑wo ‑dho dɔ ka \"dhi. ");
INSERT INTO daf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","‑Wʋ ‑nu 'wo \"dhʋ̈ bha 'wii 'dho kë ‑wʋ 'ö go ka ‑dɩ 'gü ‑a 'ka, \"kɛɛ Atanna 'ö ka Dë 'ka bha‑ ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ bha ꞊në dho bɔ ka 'gü 'ö dhiang zë. ");
INSERT INTO daf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dheebhangzë ‑nu ‑dho wo 'ko ‑da mɛ ‑nu ꞊kwɛɛ 'wo‑ ‑nu zë. 'Në dë ‑nu ‑dɩ 'pö ‑wo ‑dho woo‑ 'në ‑nu kë ‑kɔ do bha‑ 'gü. 'Ö 'në ‑nu ‑dɩ 'pö 'wo dɔ wo dë ‑nu ‑gɔ, 'ö 'wo‑ ‑nu ‑da 'pö mɛ ꞊kwɛɛ‑ 'wo‑ ‑nu zë. ");
INSERT INTO daf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ka ‑san ‑dho mɛ ꞊gban \"pɛpɛ kë n ‑wɔn 'gü, \"kɛɛ 'mɛ 'ö dho‑ 'kun \"gbɩɩ‑ 'ö dho 'ö zun‑ 'ka ‑a \"dhiʋ̈todhɛ ‑bha, ‑yö ‑dho dha. ");
INSERT INTO daf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","꞊Ya kë ꞊dhɛ ꞊wa 'wɔn wɔ ka ‑ta 'pö‑ 'kpii‑ do 'gü, ‑ka ꞊dua 'ka 'dho ‑a 'bha 'gü kö 'ka 'dho‑ 'ka \"dhiʋ̈ ‑kpɛawo! A‑ ‑pö ka ‑dhɛ tɛan‑ 'ka ꞊dhɛ 'kii 'dho ka bo ‑ziö Izraɛdhö ‑pö ꞊gban 'gü ‑sü 'ka kö mang Mɛgbömɛ 'mii nu ꞊kö. ");
INSERT INTO daf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‑A pö 'a‑ wo ka ‑dhɛ \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ ꞊klangdhiʋ̈ 'në 'bha 'yaa 'kpii‑ kö ‑yö ziö‑ 'ka ö ‑gɔmɛ ‑zë ‑ta, \"ɛɛn 'zü yëkëmɛ 'bha 'yaa 'kpii‑ kö ‑yö ziö‑ 'ka ö ‑gɔmɛ ‑zë ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","\"Kɛɛ ‑a ‑dhɛa ‑bha ꞊dhɛ ꞊klangdhiʋ̈ 'në ‑yö kë ꞊dhɛ ö ‑gɔmɛ ꞊në‑ 'dhö, kö yëkëmɛ ‑dɩ 'pö ‑yö kë ꞊dhɛ ö dëmɛ 'dhö. ‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ ma 'ö ma ‑zë 'a 'kɔ dëmɛ 'ka bha ꞊wa n ‑dhɛ Bɛɛzebidhö, 'yö ka 'kö 'ka 'kɔgünë ‑nu 'ka ꞊wɛ? (꞊Waa‑ pö Bɛɛzebidhö kö ‑wa ‑pö Sɔtraan.) ");
INSERT INTO daf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","'Yö go mü 'ö‑ pö: «'Ka 'dho \"suʋ̈ mɛbhɩɩdhe ‑gɔ! Pë \"pɛpɛ 'wo ‑bin ‑sü 'ka ‑wo ‑dho ‑wo zang ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pë ‑nu 'a‑ pö sië ka ‑dhɛ ‑dhɛtiidhɛ 'gü ya, ‑kaa ‑nu pö ‑dhɛbongdhɛ 'gü, \"ɛɛn 'wɔn ‑nu 'a‑ pö sië ka ‑dhɛ ꞊plɛ 'gü ya, ‑kaa pö \"gbɩɩ‑ 'ka \"dhɛɛdhɛ ‑nu 'gü! ");
INSERT INTO daf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","'Ka 'dho \"suʋ̈ 'mɛ 'wo ꞊mɔɔ‑ ‑bha 'wo ka zë, \"kɛɛ 'ö 'waa ꞊mɔɔ‑ ‑bha kö ‑wo ka 'nii‑ ‑zë zë bha‑ ‑nu ‑gɔ! \"Kɛɛ ‑ka \"suʋ̈ Atanna 'kö‑ ‑kɔ ‑yö ꞊mɔɔ‑ ‑bha kö ‑yö ka zë kö ‑yö 'dho ‑yö ka 'nii‑ ‑nu ꞊gban zë kö ‑ya ‑zuö ꞊geebɔɔ pɛng 'gü bha ꞊në‑ ‑gɔ! ");
INSERT INTO daf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ka‑ 'wɔn ‑dɔ ꞊dhɛ ‑wo ‑mɔɔ ‑bha kö ‑wo zöng ꞊plɛ \"dhɔɔ dɔ ‑suga do ‑bha, (‑a ‑nu ꞊bhlëë 'yaa 'dhö ‑sü ‑wɔn 'gü), \"kɛɛ 'sa kö‑ do 'yaa ‑pö \"sia‑ \"wɛɛwɛɛ kö ka Dë Atanna 'yii \"wɩ‑ ‑bha. ꞊Ya kë \"dhʋ̈ 'yö ka ‑zë ꞊wɛ? ");
INSERT INTO daf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ka ‑zë ka wun \"dhɛ ‑zian 'ö ka ‑gɔ ‑bha bha ‑yö dhong ‑sü 'ka 'ö‑ \"dhi 'dhö ka dë bha‑ \"yaan. ");
INSERT INTO daf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","'Wɔn 'ö‑ ‑wɔn 'gü, 'yö 'a‑ pö \"suʋ̈ 'ya 'dho ka kë, ka ‑wɔn ‑yö \"gbɩɩ‑ 'ö ziö zöng ‑nu ‑ta bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","'Yö‑ pö: «Mɛ \"ʋʋ mɛ 'ö dho‑ pö mɛ ꞊gban \"pɛpɛ wëëdhö ꞊dhɛ 'ö n ‑bha 'ka, mang ‑dɩ 'pö a ‑dho pö n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bha‑ wëëdhö (yi do 'ka) ꞊dhɛ ‑yö n ‑bha 'ka 'pö. ");
INSERT INTO daf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","\"Kɛɛ 'mɛ 'ö dho‑ pö mɛ ‑nu wëëdhö ꞊dhɛ 'yaa n dɔ, mang ‑dɩ 'pö a ‑dho pö‑ ‑mɛ ‑bha n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü, ‑a wëëdhö ꞊dhɛ 'maa‑ dɔ.» ");
INSERT INTO daf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ‑ya mü 'zü 'ö‑ pö: «'Ya 'dho kë ka 'gü ꞊dhɛ ‑dhi 'ko ‑dhɛ ‑sü ꞊në 'a nu‑ 'ka \"kpʋngtaamɛ ‑nu ‑dhɛ. 'Mii nu ‑dhi 'ko ‑dhɛ ‑sü 'ka, a ‑nu ‑siödhe ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‑A ‑gɛn ‑mü ꞊dhɛ a ‑nu kö 'a 'gügblüdhe ꞊në‑ ‑da 'nëgɔɔn waa‑ dë ‑a ‑nu ꞊zinng 'gü, 'nëdhebhɔ waa‑ dhe ‑a ‑nu ꞊zinng 'gü, \"ɛɛn gbö ‑bha dhebhɔ waa‑ gɔndhe ‑a ‑nu ꞊zinng 'gü. ");
INSERT INTO daf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","'Kɔ do 'gü ‑mɛ ‑nu ‑dho ‑siö wo 'ko ‑dhɛ n ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","'Mɛ 'ö‑ dë waa‑ dhe ‑nu ‑dhɔ dho‑ kë kö ‑yö ziö‑ 'ka n ‑ta, kö 'yaa n ꞊bhlëëgümɛ 'ka; 'mɛ 'ö‑ gbö \"ɛɛn ‑a 'dhu ‑dhɔ ‑ya ‑kë 'ö ‑ziö 'ka n ‑ta kö 'yaa n ꞊bhlëëgümɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'Mɛ 'wɔn ‑kun mɛ ‑bha ‑sü 'ö ꞊dhɛ n ‑dɔ ‑bha \"dhü bha‑ 'dhö bha 'yii kë‑ ‑gɔ kö ‑ya bun ö ‑bha ‑tosɛa 'gü kö ‑yö ziö‑ 'ka n ꞊keng‑ kö 'yaa n ꞊bhlëëgümɛ 'ka, kö ‑a ‑dhɛ 'yaa‑ ‑bha kö ‑yö kë ma mɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","'Mɛ 'ö dho‑ pö 'ö ö ‑dɩ dha, ‑a ‑mɛ ‑gɔ ‑dho 'to‑ 'gü, \"kɛɛ 'mɛ 'ö dho \"wɩ‑ ‑bha kö ö ‑gɔ 'to n ‑wɔn 'gü, ‑a ‑mɛ ‑dho dha. ");
INSERT INTO daf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö go mü 'zü 'ö‑ pö: «'Mɛ 'ö ꞊ya 'ö ‑kɔ ‑ya ka ‑dhɛng ‑bha, kö ꞊ya ö ‑kɔ ‑ya n ‑dhɛng ‑bha. Mɛ 'ö ꞊ya ö ‑kɔ ‑ya n ‑dhɛng ‑bha 'pö, kö n Dë Atanna 'ö n bɔ bha ꞊ya ö ‑kɔ ‑ya ‑a ‑dhɛng ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","'Mɛ 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑dhɛng bun ‑a ‑bha ‑kë Atanna ‑wʋdhiʋ̈loomɛ 'ka ‑sü ‑wɔn 'gü, ꞊trɔɔn 'ö dho‑ ‑nu ö ‑wʋdhiʋ̈loomɛ ‑dhɛ bha, ‑yö ‑dho ‑a ‑mɛ ‑bha nu 'pö. 'Mɛ 'ö dho 'mɛ 'ö pö 'aa‑ ‑bha ‑a ‑dhɛng bun ‑a ‑bha ‑kë mɛ \"slʋ̈ʋ̈slʋ̈ 'ka ‑sü ‑wɔn 'gü, ꞊trɔɔn 'ö Atanna dho‑ nu 'mɛ 'ö \"dhʋ̈ bha‑ ‑dhɛ bha, ‑yö ‑dho ‑a ‑mɛ ‑bha nu 'pö. ");
INSERT INTO daf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Yö‑ pö a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Mɛ \"ʋʋ mɛ 'ö \"yi ‑sɛa ‑kɔɔ do ‑zian nu mɛ ‑dhɛ, ‑a ‑mɛ ‑bha ‑kë ma ꞊klangdhiʋ̈ 'ka ‑sü ‑wɔn 'gü, n Dë Atanna ‑dho ‑a ‑mɛ ꞊trɔɔn nu, 'yii 'dho 'to‑ 'gü tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","꞊Dhɛ 'ö Yesu ꞊ya ö bo ö ‑bha mɛ draan‑ ‑wʋ ‑zɔn ‑sü 'ka ö ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ ‑nu ‑dhɛ ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö go ‑dhɛ bha‑ 'gü 'ö dho mɛ draan‑ ‑sü waa‑ Atanna ‑wʋ pö ‑sü 'ka 'pö‑ ‑nu 'gü \"sɛ bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","‑A \"tʋ̈ng bha‑ 'ka kö Zan Mɛzumɛ ‑yö ‑kaso 'gü, 'yö yë 'ö Klisi 'dhö‑ kë sië bha‑ ‑wɔn ma. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö ö ‑bha ꞊klang ‑nu 'bha bɔ ");
INSERT INTO daf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kö ‑wo Yesu dhɛɛ\" 'kpɔ ꞊dhɛ: «'Mɛ 'wo‑ dɔ ꞊dhɛ ‑yö ‑dho nu bha yö ‑mü ‑a 'ka ‑ee \"ɛɛn wo ‑tun ꞊kö ‑ya mɛ \"wɛɛ 'bha‑ ‑gɔ 'zü ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Ka 'dho kö 'pë 'ka‑ ma \"ɛɛn 'ö ka \"yan dɔ‑ 'gü bha 'ka‑ ‑gɛn dɔ Zan ‑dhɛ ");
INSERT INTO daf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","꞊dhɛ \"yënngtiimɛ ‑nu ‑wo ‑dhɛ yö sië, ‑ta 'bebedhö ‑mɛ ‑nu ‑wo \"ta sië ‑së 'ka, ꞊weeyuamɛ ‑nu 'ö‑ ‑nu kwi ꞊ya see‑ 'nu ‑blɛɛsü bha, ‑wo kë sië \"klʋ̈ʋ̈klʋ̈, 'ö \"tʋwlümɛ ‑nu 'wo 'wɔn ma sië, gamɛ ‑nu ‑dɩ 'pö ‑wo ‑bö sië 'wo go ga 'gü, 'ö 'wɔn ‑taɔng ‑së 'dhö pö sië ‑wëëmɛ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","꞊Dhɛ 'ö \"dhʋ̈ mɛ \"ʋʋ mɛ 'ö‑ 'gü 'yii ga ‑zʋ ‑yö Atanna ‑dhɛ ‑sü 'ka kö‑ ‑mɛ ‑bha ‑së! ");
INSERT INTO daf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","꞊Dhɛ 'ö Zan ‑bha ꞊klang ‑nu bha ꞊wa 'dho, 'yö Yesu ‑yö 'wɔn 'ö ‑gban Zan ‑bha ‑a pö ‑sü zü bho mɛ kpö 'wo gun 'mü bha‑ ‑nu ‑dhɛ 'ö‑ pö: «'Dho 'ka‑ wo \"tʋng ‑ta bha, ka ‑dho ‑më ꞊në‑ ‑ga ‑dhɛ 'gü? ‑Kaadhüga 'ö \"tɛɛ ‑ya ‑vin ꞊në 'ka dho‑ ‑ga ‑dhɛ 'gü ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","\"Ɛɛn 'mɛ 'wo ‑gblüdëdhɛ ‑sɔ ‑da ‑sü 'ka ‑ee? ‑Abin! ‑A ‑gɛn ‑mü ꞊dhɛ mɛ 'dhɛ 'kö 'wo \"dhʋ̈ bha ‑wo ‑gblüdëdhɛ ‑kɔ ‑nu ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","\"Kɛɛ ka ‑dho 'sa ‑më ꞊në‑ kë mü yö ‑zë 'gü? \"Ɛɛn ka ‑dho Atanna ‑wʋdhiʋ̈loomɛ do bha ꞊në‑ ‑ga ‑dhɛ 'gü ‑ee? A‑ ‑pö ka ‑dhɛ ꞊ma ꞊iin, Atanna ‑wʋdhiʋ̈loomɛ ‑mü, yö ‑zë ‑a \"dhiʋ̈ ‑zian ‑yö ‑ziö Atanna ‑wʋdhiʋ̈loomɛ ‑kpɛa ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑ya ‑pö ö ‑bha 'sëëdhɛ 'gü yö ꞊në‑ ‑bu 'gü 'ö‑ pö: ‹‑Dhɛ ‑ga, 'ma ma bɔmɛ do bɔ i \"dhiʋ̈ kö ‑yö i ‑bha zian ‑glootadhɛ ‑pë kë.› ");
INSERT INTO daf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ mɛ \"ʋʋ mɛ 'wo zun bhɔ ‑sü ‑bha \"kpʋng ꞊taa yi 'bha 'ka 'ö nu 'ö zun‑ 'ka ꞊dɛɛ ‑bha bha, ‑a mɛ 'bha 'ö dho kë 'kpii‑ kö ‑yö ‑ziö Zan Mɛzumɛ ‑ta 'yaa 'dhö, \"kɛɛ 'sa Atanna 'dhö ö ‑bha ‑gblüdëdhɛ bha‑ ‑ta \"pʋ ‑sü 'ka 'mɛ 'ö‑ ‑nu ‑dhɛ ꞊dɛɛ bha‑ mɛ 'dɛdɛ ‑sü ‑zian 'ö‑ 'gü ‑a ꞊bhlëë ‑yö 'kpii‑ Zan ‑zë ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","'Ö go \"tʋ̈ng 'ö Zan Mɛzumɛ ‑yö Atanna ‑wʋ pö‑ 'ka bha ‑bha, 'ö dho 'ö zun‑ 'ka ꞊dɛɛ ‑bha, Atanna ‑bha ‑gblüdëdhɛ bha‑ ‑wɔn ꞊ya kë ꞊dhɛ ‑gblü ꞊në‑ 'dhö, ‑a ‑kun \"gbɩɩ‑ ‑mɛ ‑nu ꞊në 'wo‑ ꞊slɔɔ sië. ");
INSERT INTO daf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Atanna ‑wʋdhiʋ̈loomɛ ‑nu \"pɛpɛ ꞊gban waa‑ Moizö 'dhö 'tɔng‑ 'ö‑ ‑bɛn zë kwa ‑dhɛ bha ‑wo 'wɔn 'ö ‑gban ‑a ‑bha ‑gblüdëdhɛ bha‑ ‑bha bha ꞊në‑ ‑dhiang zë 'ö nu 'ö zun‑ 'ka Zan Mɛzumɛ ‑bha yi ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","꞊Ya kë ꞊dhɛ 'ka‑ \"piʋ̈ ꞊dhɛ 'ka 'dhang bho n \"dhiʋ̈ kö a‑ ‑pö ka ‑dhɛ ꞊dhɛ: Zan bha ꞊në Edhi 'wo‑ nu ‑wɔn ‑dhiang zë Atanna ‑bha 'sëëdhɛ 'gü bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","꞊Ya kë ꞊dhɛ 'wɔn 'gü ma ‑tʋ 'dhö ka ‑gɔ ‑bha, ‑kaa \"pʋ ‑së 'ka kö 'ka‑ ma! ");
INSERT INTO daf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","'Yö go mü 'ö‑ pö \"kɛɛ kö 'mɛ 'wo ꞊dɛɛ ‑yën ya‑ 'gü ya, a ‑dho ‑a ‑nu ‑zɔn 'ka ‑zɔn ‑më ꞊në‑ 'ka ‑ee? ‑Wo ‑kë ꞊dhɛ 'në 'sɛɛnnë ‑nu 'wo ‑ya ‑sü 'ka \"dhɛɛ 'kpii‑ 'gü 'wo‑ pö sië wo 'ko ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","«'Ya \"tan bho kö 'ka nu yi ‑wʋ ‑bha \"kɛɛ 'kii‑ ‑yɔ bɔ. \"Ɛɛn 'ya gata ‑gbʋ bɔ kö 'ka nu yi ‑wʋ ‑bha, \"kɛɛ ‑wëë 'yii bɔ ka ‑ta bha ꞊në‑ ‑nu 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pë 'ö ‑kë 'yö 'a 'mɛ 'wo ꞊dɛɛ ‑a ‑nu ‑bha ‑tosɛa ‑zɔn 'në 'sɛɛnnë ‑nu 'wo troo kë sië \"dhɛɛ 'kpii‑ 'gü ‑a ‑nu 'ka bha, ‑a ‑gɛn ‑mü ꞊dhɛ: Zan 'dhö nu 'yaa gun ‑bhöpë ꞊dede ‑bhö sië \"ɛɛn 'yaa gun we mü sië 'yö 'wo‑ pö‑ ‑bha ꞊dhɛ: «\"Yina yaa ‑ya 'gü!» ");
INSERT INTO daf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","꞊Dhɛ 'ö mang Mɛgbömɛ 'ma nu 'zü, 'ö 'ma pë ‑bhö 'ö 'ma we mü ꞊dhɛ mɛ \"wɛɛ ꞊gban 'dhö, 'yö 'wo‑ pö: «Mɛ bha we mü ‑dudu waa‑ pë ‑bhö ‑dudu ‑mü. ꞊Ya 'go mü 'zü waa‑ 'niisɔngkunmɛ ‑nu waa‑ 'wɔnyaakëmɛ ‑nu ꞊në 'wo ꞊nëng 'kwëë‑!» \"Kɛɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ Atanna ‑bha 'wɔndɔdhe ‑yö ö ‑dɩ ‑zɔn mɛ \"bhɩɩ‑ ‑nu ‑dhɛ ‑dhɛ bha ꞊në‑ 'gü ꞊dhɛ Zan ‑yö ‑gun Atanna ‑bha zian ꞊në‑ ‑zɔn sië mɛ \"bhɩɩ‑ ‑nu ‑dhɛ tɛan‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö zun ‑wëëwʋ ‑kpɔ 'pö‑ ‑nu 'ö \"dhabhliwɔn 'gbɛ ‑kë 'gü bha‑ ‑nu 'gü ‑mɛ ‑nu ‑bha, wo zuë\" slëë‑ 'ö 'wii‑ wo Atanna \"piʋ̈ bha‑ ‑wɔn 'gü 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«\"Eke! Kodhazɛn ‑mɛ ‑nu, ka ‑bha ‑yö ‑wëësü, Bɛsaida ‑mɛ ‑nu, ka ‑bha ‑yö ‑wëësü; ‑a ‑gɛn ‑mü ꞊dhɛ \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu 'a‑ ‑kë ka ‑gɔ 'pö‑ ‑nu 'gü bha a‑ ‑kë Tii‑ ‑dhɛ waa‑ Sidɔn ‑dhɛ ‑nu ('ö‑ 'gü ‑mɛ ‑nu gun bhɔkɔyaamɛ ꞊në‑ 'ka yi 'bha 'ka bha ꞊në‑ 'gü 'nu, kö ꞊wa wo zuë\" slëë‑ Atanna \"piʋ̈ ‑a yi ꞊ya ꞊gwëë. Kö ꞊wa bhɔɔ sɔ ‑da wo ‑bha 'nu ꞊wa \"yʋʋ dɔ wo ‑ta kö ‑wa ‑zɔn ꞊dhɛ ‑yö wo \"piʋ̈ ꞊dhɛ 'wo wo bo 'wɔn yaa kë ‑sü 'ka kö 'wo wo zuë\" slëë‑ Atanna \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yö ꞊në‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ: Zadɔyi 'ka, 'wɔn 'ö dho wɔ Tii ‑mɛ ‑nu waa‑ Sidɔn ‑mɛ ‑nu ‑ta, ‑yö ‑dho kë ꞊zɔngsü ka ‑bha ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapɛɛnaɔmö ‑mɛ ‑nu, kaa ‑dɩ 'pö, ‑yö ka \"piʋ̈ 'ka kpɛa‑ kö ka ‑gɔ ‑yö zun dhang‑ ‑bha ‑ee? Ka ‑dho 'dho ‑zian ꞊në‑ wo \"sia‑ 'ö 'ka dho 'ka ‑sɔ 'ka ꞊geebɔɔ ‑pɛng 'gü. ‑A ‑gɛn ‑mü ꞊dhɛ \"dhabhliwɔn ‑nu 'ö ‑kë ka ꞊plöö bha, ꞊ya kë ꞊dhɛ ‑yö ‑kë 'nu Sodɔmö ‑pö 'gü, (kö ‑wo ‑dho wo kwaa‑ wo këwɔn yaa ‑nu ‑zü 'ö 'wo wo zuë\" ꞊slëë Atanna \"piʋ̈,) kö Sodɔmö ‑pö ‑tun 'nu ꞊dɛɛ. ");
INSERT INTO daf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","(Ka ‑zë ka n ‑wʋ ‑ma, \"kɛɛ 'kaa ka kwaa‑ ka kë ‑sɔng yaya ‑nu ‑zü kö 'ka ka zuë\" slëë‑ Atanna \"piʋ̈) 'wɔn 'ö‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ zadɔyi 'ka, 'wɔn 'ö ‑wɔ Sodɔmö ‑dhɛta ‑yö ‑dho kë 'dɛdɛ ka ‑bha ‑bha bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","‑A \"tʋ̈ng do bha ꞊në‑ 'gü 'yö Yesu ‑ya pö: «'A, n Dë, bhi 'ö 'i \"sɛ waa‑ dhang‑ ‑nu ‑mɛ 'ka bha a i nuɛ\" bho ꞊dedewo 'pë 'ö ‑gblɛn 'kpɔ ‑sü 'ka ‑glengmɛ ‑nu waa‑ 'wɔndɔmɛ ‑nu ‑gɔ ‑a ‑zɔn 'i‑ wo ('mɛ 'ö pë draan‑ ‑dhɔ ‑ya ‑nu ‑kë ꞊dhɛ 'në 'sɛɛnnë ‑nu 'dhö) ‑a ‑nu ‑dhɛ bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","꞊iin, n Dë, a i nuɛ\" ‑bho, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑kë \"dhʋ̈ kö ‑kɔ 'i‑ ‑ya 'ka i zuë\" \"piʋ̈ bha 'i‑ kë yö ꞊në‑ ‑kɔ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","'Yö Yesu ‑ya pö 'zü ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «N Dë ꞊ya pë ꞊gban \"pɛpɛ dɔ n ‑kɔ 'ka. Mɛ 'bha 'yaa mang Atanna gbö ‑mɛ n dɔ kö 'yii kë n Dë 'ka, \"ɛɛn mɛ 'bha 'yaa n Dë dɔ kö 'yii kë mang Atanna gbö ‑mɛ \"ɛɛn 'zü 'mɛ 'ö n \"piʋ̈ 'a‑ ‑zɔn ‑nu ‑dhɛ ‑a ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","‑A ‑wɔn 'gü mɛ \"pɛpɛ 'ö ꞊kwɛɛ 'gbiin‑ 'dhö ka ‑ta, 'ö ka 'gü ꞊ya ga ‑a 'sü ‑sü 'ka, ‑ka nu n \"piʋ̈ kö 'a \"tɛɛpasü nu ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","‑Ka ꞊nëng ma 'tɔng‑ ‑bha kö 'ka ka kwaa‑ ka ‑dɩ ‑zü n ‑gɔ, kö 'a ka draan‑ 'wɔn dɔ ‑sü ‑bha; ‑a ‑gɛn ‑mü ꞊dhɛ ma ‑zë ma 'wɔn‑ ‑së, 'ö n zuë\" 'dhö ‑sɛa; ꞊ya kë \"dhʋ̈ ka ‑dho ‑ya ka ‑dɩ 'flëë‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","‑A ‑gɛn ‑mü ꞊dhɛ 'tɔng‑ ‑nu 'a dho nu ka ‑dhɛ kö 'ka‑ 'kun bha‑ ‑nu 'kundhɛ 'yaa \"gbɩɩ‑, ꞊ya 'go yö ‑zë 'gü ꞊kwɛɛ‑ 'dhɛ 'a dho‑ nu ka ‑dhɛ bha 'pö ‑yö 'fʋ̈ʋ̈‑.» ");
INSERT INTO daf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","꞊Dhɛ 'ö \"tʋ̈ng 'bha ꞊ya ziö, 'yö Yesu 'dhö gun ziö sië ‑mlü suu 'wo 'bluu‑ ‑kë 'ka 'wo‑ ble ‑kë bha‑ ‑bhlaa ‑nu 'gü Zuifö ‑nu ꞊glooyi 'ka kö din‑ ‑ya ‑bha ꞊klang ‑nu kë sië, 'yö 'wo zun ‑mlü bha‑ ‑kpaa 'bha ‑wo 'gü ‑sü ‑bha 'wo‑ \"flɩɩ‑ bho 'wo‑ ‑bhö. ");
INSERT INTO daf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","꞊Dhɛ 'ö Fadhiziɛn ‑nu 'wo‑ ‑nu yö, 'yö 'wo‑ pö Yesu ‑dhɛ: «‑Bhö ‑dhɛ ‑ga bha, pë 'ö kwa ‑bha 'tɔng‑ ‑ya pö 'kwa 'dho‑ kë ꞊glooyi 'ka bha‑ ‑ga 'ö i ‑bha ꞊klang ‑nu 'wo‑ kë sië ya!» ");
INSERT INTO daf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Kii 'wɔn 'ö Davi ‑ya kë yi 'bha 'ka waa‑ ö ꞊keng‑ ‑mɛ ‑nu 'dhö kö din‑ ꞊yaa‑ ‑nu 'kun 'ö ‑bɛn zë ‑sü 'ka bha‑ ‑wʋ pö do ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","‑Da 'ö‑ wo Atanna ‑gɔ 'kɔɔdhö waa‑ ö ꞊keng‑ ‑mɛ ‑nu 'dhö, ('ö 'wo 'bluu‑ 'wo Atanna ‑dhɔkë 'ka bha‑) sü 'wo‑ ‑bhö, \"kɛɛ kö‑ ‑dhɛ 'yaa‑ ‑bha kö ‑wa ‑bhö bha, 'kii‑ ma ‑ee? ‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ kwa ‑bha 'tɔng‑ ‑ya ‑pö \"saa‑ ‑bho Atanna ‑dhɛ ‑mɛ ‑nu ‑dɩ ‑slɔɔ ꞊në 'wo‑ ‑bhö ‑mɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","\"Ɛɛn 'zü, 'kii‑ ‑wʋ pö Moizö ‑bha 'tɔng‑ 'sëëdhɛ 'gü do ꞊dhɛ kwa ‑bha ꞊glooyi 'ka \"saa‑ ‑bho Atanna ‑dhɛ ‑mɛ ‑nu 'ö yë 'dhö‑ ‑nu ꞊kwɛɛ‑ Atanna ‑dhɔkëgükɔ 'gü, 'waa 'tɔng‑ 'ö ‑gban ꞊glooyi ‑bha bha‑ 'kun, \"kɛɛ Atanna 'yaa‑ ‑nu 'kun tëë 'ka ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Pë do 'bha ‑yö ‑dhɛ ya‑ 'gü 'ö ꞊bhlëësü 'ö ‑ziö Atanna ‑dhɔkëgükɔ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","꞊Ya kë ꞊dhɛ pë 'ö ‑bɛn zë ‑sü 'ka, ka‑ 'gü ‑ma 'nu kö 'mɛ 'ö 'wɔn 'bha 'yaa‑ ‑nu ‑bha bha, 'kii 'dho za dɔ‑ ‑nu ‑bha. ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka ꞊dhɛ mɛ ‑wëë ‑bha ka kë ‑sü ꞊në‑ \"dhia 'dhö n 'gü, \"kɛɛ \"saa‑ ‑bho wü 'ka n ‑dhɛ ‑sü ‑zë ‑a \"dhia 'yaa n 'gü 'gbɛ. ");
INSERT INTO daf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ mang Mɛgbömɛ ꞊në ma ꞊glooyi 'dhö 'dhö. (‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü kö 'wɔn 'ö ma ꞊klang ‑nu ‑wa ‑kë bha 'yaa 'wɔn yaa 'ka.)» ");
INSERT INTO daf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö go ‑dhɛ 'dhɛ bha‑ 'gü 'yö dho Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ do 'gü. ");
INSERT INTO daf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gɔndë do 'ö‑ ‑kɔ do‑ gun ga ‑sü 'ka‑ ‑bha ‑yö ‑gun ‑dhɛ bha‑ 'gü, 'yö 'mɛ 'wo gun mü bha 'wo Yesu dhɛɛ\" kpɔ 'wo‑ pö: «‑A ‑dhɛa ‑bha kö ‑wo mɛ kë \"klʋ̈ʋ̈klʋ̈ ꞊glooyi 'ka \"wɛ ‑ee?» ‑Wo Yesu dhɛɛ\" ‑kpɔ \"dhʋ̈ kö ‑wa ‑gɛn ꞊në‑ mɔɔ‑. ");
INSERT INTO daf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'Yö‑ ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «De ‑mü 'ka ka kpö 'gü 'yö‑ ‑bha \"bhlaanë dosengseng 'ö‑ ‑gɔ, ꞊ya ‑pö ‑klɔng 'gü ꞊glooyi 'ka 'yö dho‑ 'to mü? ");
INSERT INTO daf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","‑A ‑wɔn 'gü a‑ ‑pö ka ‑dhɛ ꞊dhɛ mɛbhɩɩdhe \"yaandhe ‑wɔn ‑zë 'waa waa‑ \"bhlaanë ‑wɔn ‑a ‑nu ‑ya 'ko \"dhiʋ̈. ꞊Ya kë \"dhʋ̈ kö 'wɔn ‑së ‑zë ‑wo ‑mɔɔ ‑bha 'wo‑ ‑kë ꞊glooyi 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑ya pö gɔndënë ‑gbe ‑ga ‑bha ‑sü bha‑ ‑dhɛ: «‑Bhö i ‑gbe 'gü \"pʋ!» 'Yö‑ ‑pʋ, 'yö ‑kë ‑a ‑gbe do bha‑ bo ‑sü 'ka 'yö ‑kë ꞊dhɛ‑ do 'dhɛ to ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","꞊Dhɛ 'kö ꞊ya bo‑ kë ‑sü 'ka \"dhʋ̈, Fadhiziɛn ‑nu 'wo gun mü bha ‑wo zun ꞊në‑ wo \"kpɛnng, 'yö 'wo Yesu zë ‑wɔn ‑yakwëë ‑kë. ");
INSERT INTO daf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","꞊Dhɛ 'ö ꞊yaa‑ ma ꞊dhɛ ‑wo ö zë ‑wɔn ‑ya 'kwëë‑ kë sië, 'yö go ‑dhɛ bha‑ 'gü. ‑A 'dho ‑sü 'ka mɛ kpö 'gbɛ ‑wo ‑gun ꞊keng‑. 'Yö \"yuëdhi \"pɛpɛ 'wo gun 'mɛ 'wo bha‑ ‑nu kpö 'gü, 'yö‑ ‑nu ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","\"Kɛɛ 'yö ‑dhio dɔ‑ ‑nu ‑ta glɔɔglɔdhö 'ö‑ pö 'wa 'dho ö ‑kë Atanna Gbö 'ka ‑wɔn pö mɛ 'bha ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kë \"dhʋ̈ kö ‑wʋ 'ö Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑ya pö yi 'bha 'ka bha‑ 'gü ‑wɔn ‑yö kë; ‑a ‑gɛn ‑mü ꞊dhɛ Ezai ‑yö ka‑ ‑pö 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Atanna ‑ya ‑pö: Ma yëkëmɛ 'a‑ ‑ya 'yö ya, Yö ꞊në‑ ‑dhɔ ‑yö n ‑kë, 'yö 'a n ‑gɔ ‑wɔn ꞊gban \"kplëng bho ‑sü 'ka i ‑bha. Yö ꞊në 'a ‑dho ma 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑ya 'gü kö ‑yö 'wɔn 'ö pö 'aa‑ ‑bha ‑a kë ‑sü ‑dhiang zë \"kpʋngtaamɛ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Waa‑ mɛ 'bha 'wii 'dho ‑dɔn bho, \"ɛɛn 'yii 'dho \"gbla mɛ 'bha ‑ta, \"ɛɛn mɛ 'bha ‑mɛ 'bha 'yii 'dho‑ yö kö ‑yö \"plüün bho sië 'ö ꞊ziö‑ 'ka ‑kpinng \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","‑Kaadhüga 'dhɛ 'ö ꞊klɔngsü 'ka 'yii 'dho‑ ‑kpɛa \"yɛ do, \"ɛɛn pɛng kpuu' 'dhɛ 'ö‑ \"gbiën 'në 'bha ‑zë 'ö ‑tun kö bhɔ, 'yii 'dho‑ ‑kpɛa \"dhuu do. ‑Yö ‑dho 'to‑ ‑kë \"dhʋ̈ ‑sü ‑bha 'ö to‑ 'ka \"dhʋ̈, 'ö zun‑ 'ka Atanna ‑bha tɛanwɔn ‑to ‑bha ‑yi ‑bha, ");
INSERT INTO daf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'ö \"sɛ \"wɛɛ ꞊gban 'wo wo ‑zʋ yö‑ ‑dhɛ 'yö 'wo \"yan to‑ ‑gɔ.» ('Pë 'ö ‑kë 'yö Yesu gun‑ pö sië 'wa 'dho ö dɔ ‑kɔ pö mɛ 'bha ‑dhɛ bha 'yö bha.) ");
INSERT INTO daf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","꞊Dhɛ 'ö ꞊ya bo ‑kë ‑sü 'ka \"dhʋ̈, 'yö 'wo nu \"yanwlümɛ do 'ö \"bhʋbhʋ 'ka ‑a 'ka Yesu ‑dhɛ. 'Mɛ 'ö bha‑ kë \"dhʋ̈ ‑gɛn ‑mü ꞊dhɛ kö \"yina yaa ‑ya 'gü. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö gɔndënë bha‑ ‑kë \"klʋ̈ʋ̈klʋ̈, 'yö dhiang zë, 'yö ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö mɛ kpö 'wo gun 'mü bha‑ 'wɔn ‑ya ‑nu kɔn 'yö 'wo‑ pö: «Kö ‑yö ‑dho kë Davi suu 'gü ‑në 'ö 'kwa ‑ya ‑gɔ bha‑ 'ka 'sa.» ");
INSERT INTO daf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","\"Kɛɛ ꞊dhɛ 'ö Fadhiziɛn ‑nu ‑wa ‑nu ‑wʋ bha‑ ma \"dhʋ̈ 'yö 'wo‑ pö: «'Mɛ bha ‑yö \"yina yaa ‑nu bha‑ ‑nu ‑kë \"dhʋ̈ \"yina ‑nu ‑bha ‑gblüdë 'wo‑ Bɛɛzebidhö ‑kë bha ꞊në‑ faan 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","\"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ Yesu ‑ya ‑nu ‑zʋgɔngüwɔn ‑nu bha‑ ‑dɔ bha, 'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Yö kë ka \"yaan ꞊dhɛ \"sɛ \"ʋʋ \"sɛ 'ö‑ 'gü ‑mɛ ‑nu ꞊wa ‑ya 'ko ‑zë wo \"kwëë ‑sü ‑bha kö \"sɛ 'dhɛ 'kö bha ꞊ya 'wü ꞊naa bha. \"Ɛɛn 'pödhɛ suu \"ʋʋ suu \"ɛɛn 'kɔdhi suu \"ʋʋ suu 'ö‑ 'gü ‑mɛ ‑nu 'wo 'ko zë sië wo \"kwëë kö ꞊ya 'wü ꞊naa bha. ");
INSERT INTO daf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","‑Kɔ do bha‑ 'gü, ꞊ya kë ꞊dhɛ 'ka‑ pö Sɔtraan ꞊në \"yina yaa ‑nu 'wo bɔ‑ 'ka bha‑ ‑nu kë sië bha kö 'yii ‑gblü gɔɔn ö ‑dɩ 'ka ꞊naa bha ‑ee? Kö‑ ‑bha ‑gblüdëdhɛ 'yii \"pɛ ‑ee? ꞊Ya kë \"dhʋ̈ ‑a ‑bha ‑gblüdëdhɛ ‑dho ꞊gwëë ‑kɔ ‑kë ꞊dhɛ? ");
INSERT INTO daf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","꞊Ya kë 'zü ꞊dhɛ ma ‑zë 'ma \"yina yaa kë Bɛɛzebidhö faan 'ka bha ‑oo, 'yö ka ‑bha ꞊klang ‑nu ‑zë ꞊wɛ? ‑Wo wo ‑bha ‑kë de ꞊në‑ faan 'ka? Yö ꞊në‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ ka ‑bha ꞊klang ‑nu bha ꞊në 'wo dho ka zë za 'ka ‑dhɛ 'bha ꞊kpaɔ ‑yi ‑bha (Atanna wëëdhö, ‑a ‑gɛn ‑mü ꞊dhɛ 'wii wo ‑bha bha‑ kë mɛ \"wɛɛ 'bha faan 'ka kö 'yii kë Atanna ‑zë 'ka). ");
INSERT INTO daf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","\"Kɛɛ ‑kaa 'wɔn dɔ ꞊dhɛ a \"yina yaa ‑nu ‑kë Atanna ‑bha 'Nii‑ ꞊në‑ faan 'ka, ‑Kaa 'wɔn dɔ 'pö ꞊dhɛ ꞊ya kë \"dhʋ̈ kö‑ ‑bha ‑gblüdëdhɛ yöö yö‑ ‑bha ꞊në‑ wo, 'yö‑ \"zɔ ꞊ya ‑wo ka ‑ta bha. ");
INSERT INTO daf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","\"Ɛɛn ‑yö ka 'gü ꞊dhɛ mɛ 'bha ‑kɔ ‑mɔɔ ‑bha 'ö ‑da ‑kɛgbaan 'bha ‑gɔ 'kɔɔdhö 'ö ‑ya ‑bha ꞊kwɛɛ‑ ‑nu ‑wlösü ‑bha kö 'yii‑ ‑lö ‑zë wo ꞊kö ‑blɛɛsü ‑ee? \"Fɔn kö ꞊ya ‑kɛgbaan bha‑ ‑lö, 'yö‑ ‑kɔ gun ‑na ꞊mɔɔ‑ ‑bha kö ‑ya ‑bha ꞊kwɛɛ‑ ‑nu ‑wlö. ");
INSERT INTO daf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü a‑ ‑pö ka ‑dhɛ ꞊dhɛ: 'Mɛ 'ö 'yii bɔ n 'ka kö ‑yö ‑nu n ‑gɔ. 'Sa 'mɛ 'yii mɛ mɔɔ‑ ‑zë wo ꞊dhɛ n 'dhö kö ‑yö nu‑ 'ka kö 'yi‑ ꞊loo 'ko ‑ta, kö mɛ ‑kan n ‑bha ‑mɛ ‑mü. ");
INSERT INTO daf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yö ꞊në‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ: 'Mɛ 'ö Atanna ‑bha 'fang bho, (꞊ya bhɛa\"‑ ‑dhɛ) ‑yö ‑dho ‑a ‑mawɔn 'to, 'mɛ 'ö 'wɔn yaa ‑kë, (꞊ya bhɛa\"‑ ‑dhɛ) ‑yö ‑dho ‑a ‑mɛ ‑mawɔn 'to, \"kɛɛ 'mɛ 'ö dho Atanna ‑bha 'Nii‑ ‑zë ‑bha 'fang bho, 'yii 'dho‑ ‑mɛ ‑mawɔn 'to tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mɛ \"ʋʋ mɛ 'ö dho mang Mɛgbömɛ n ‑bha 'fang bho, Atanna ‑dho ‑a ‑mɛ ‑mawɔn 'to, \"kɛɛ mɛ \"ʋʋ mɛ 'ö Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑bha 'fang bho, 'yii 'dho‑ ‑mɛ ‑mawɔn 'to ꞊dɛɛ, 'yii 'dho‑ 'to dhia\".» ");
INSERT INTO daf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","'Yö go mü 'zü 'ö‑ pö: «'Bha \"dhü ‑së ta 'yö bhɛ ‑së ‑ya, 'bha \"dhü yaa ta ‑yö bhɛ yaa ꞊në‑ ‑ya. \"Dhü 'ö ‑së ‑wa ‑dɔ ‑a bhɛ ꞊në‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","‑Mawɔnyaamɛ ‑nu, ka ‑dho dhiang ‑së zë ‑kɔ ‑kë ꞊dhɛ kö ka suu 'yaa ‑së. ‑A ‑gɛn ‑mü ꞊dhɛ 'pë 'ö mɛ zuë\" \"piʋ̈, 'yö ‑wo mɛ \"dhi ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","'Mɛ 'ö‑ \"klʋ 'dhö ‑së, 'ö‑ këwɔn 'dhö ‑së 'yö 'wɔn ‑së ‑yö ‑kë ‑mɛ zuë\" \"piʋ̈, 'yö dhiang ‑së zë. ‑Mawɔnyaamɛ ‑dɩ 'pö, ‑a zuëpiʋ̈dhɛ ‑yö kë pa ‑sü 'ka 'wɔn yaa ꞊në‑ 'ka. ꞊Ya kë 'pö \"dhʋ̈ pë 'ö‑ \"dhi ‑ya pö‑ ꞊gbaan ‑kë pë yaa ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A‑ ‑pö ka ‑dhɛ ꞊dhɛ: ‑Dhɛkpaɔyi 'ö Atanna dho za dɔ‑ 'ka mɛ \"bhɩɩ‑ ‑bha bha, \"wlaa‑ ‑dhiang \"pɛpɛ 'wo‑ zë, ‑wo ‑dho ziö‑ ꞊gban 'gü ‑a wëëdhö. ");
INSERT INTO daf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","‑A ‑gɛn ‑mü ꞊dhɛ i zë ‑dhiang ‑nu 'wo \"kpʋng ꞊taa yö bha ꞊në 'wo dho za dɔ i ‑bha. 'Bha‑ ‑së zë i ‑dho dha, 'bha‑ yaa zë, Atanna ‑dho 'wɔn bho i 'gü. ");
INSERT INTO daf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","'Ö go‑ 'dhɛ bha‑ 'gü, 'yö Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu 'bha ‑nu waa‑ Fadhiziɛn ‑nu 'bha ‑nu 'wo‑ pö Yesu ‑dhɛ 'wo‑ pö: «Yi Dëmɛ, ‑yö yi \"piʋ̈ ꞊dhɛ 'i \"dhabhliwɔn do 'bha kë kö yi \"yan ‑yö ‑da ‑dhɛ 'gü (kö ‑ya ‑zɔn yi ‑dhɛ ꞊dhɛ Atanna ꞊në i bɔ ꞊dedewo tɛan‑ 'ka)!» ");
INSERT INTO daf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Wɔnyaakëmɛ ‑nu 'wo ꞊dɛɛ ‑yën ya‑ 'gü, 'ö 'waa 'to ‑kplü ‑sü 'ka Atanna ‑bha bha ‑wa \"piʋ̈ ꞊dhɛ 'a \"dhabhliwɔn do kë kö 'wo‑ ‑dhɛ yö, \"kɛɛ \"dhabhliwɔn ‑dee 'bha 'yii 'dho kë kö ‑yö kë ‑a ‑nu ‑bha 'wɔn 'suan‑ ‑bho ‑bha pë 'ka kö 'yii kë ‑a 'dhɛ 'kö ‑kë Atanna ‑wʋdhiʋ̈loomɛ Zonasö 'ka yi 'bha 'ka bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","‑Kɔ do 'ö Zonasö ‑yö ‑dhɛkpaɔyi ‑yaaga waa‑ gbeng 'gü ‑yaaga ‑kë 'ka 'yuʋ̈‑ 'kpii‑ do \"gblʋ̈ʋ̈‑ yi 'bha 'ka bha, mang Mɛgbömɛ a ‑dho ‑dhɛkpaɔyi ‑yaaga waa‑ gbeng 'gü ‑yaaga kë 'pö ‑kɔ do bha‑ 'gü \"sɛɛdhö. ");
INSERT INTO daf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Atanna ‑bha za bha‑ dɔ ‑yi 'ka, a‑ ‑pö ka ‑dhɛ ꞊dhɛ Ninivö ‑mɛ ‑nu ‑dho \"wlü Atanna ‑kuu \"dhiʋ̈ 'wo 'mɛ 'ka ꞊dɛɛ ka zë za 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊dhɛ 'ö Zonasö ‑yö dho 'ö Atanna ‑wʋ pö Ninivö ‑mɛ ‑nu ‑dhɛ, ‑wo kë wo kwaa‑ wo këwɔn yaya ‑nu ‑zü, 'ö 'wo wo zuë\" ꞊slëë‑ \"piʋ̈, \"kɛɛ ka ‑zë mɛ 'dhɛ 'kö‑ ‑duɛ 'dhö 'kpii‑ 'ö ‑ziö Zonasö ‑bha ‑ta, 'ö ka kpö 'gü ꞊dɛɛ bha ꞊ya Atanna ‑wʋ pö ka ‑dhɛ, 'kaa \"wɩ‑ ‑bha kö 'ka ka zuë\" slëë‑ Atanna \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","‑Gblüdëdhe 'ö go \"sɛgɔ 'wo‑ Seba ‑sɛ ‑kë bha‑ 'gü bha ‑yö ‑dho \"wlü 'pö 'ö 'mɛ 'ka ꞊dɛɛ bha ka zë za 'ka zadɔyi bha‑ 'ka. ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö kë ‑go ö ‑gɔ \"sɛgɔ ꞊gblɛɛn bha‑ 'gü, 'ö nu 'ö \"tʋ to Sadhomɔ ‑bha dhiang ‑nu 'ö gun‑ zë sië 'wɔndɔdhe ‑bha bha‑ ‑bha. 'Sa a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mɛ 'ö‑ ‑duɛ 'dhö 'kpii‑ 'ö ‑ziö Sadhomɔ ‑bha ‑ta, ‑yö ka kpö 'gü yö, \"kɛɛ 'kaa ka \"tʋ 'to‑ ‑wʋ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","'Yö Yesu ‑yö dhiang zë 'zü 'ö‑ pö: «꞊Ya kë ꞊dhɛ \"yina yaa ꞊ya 'go mɛ 'gü, 'yö dho \"tʋng ‑ta ö ‑yɛa mɔɔ‑, \"kɛɛ 'yii‑ ‑dhɛ yö 'yö‑ pö ö ‑dɩ ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‹‑Ka 'go 'a n yee kë 'a 'dho ‑dhɛ 'a go‑ 'gü bha‑ 'gü.› ꞊Ya ö yee kë yö ‑zë 'gü kö ‑yö nu kö mɛ 'bha 'yaa‑ ꞊yëë \"dhiʋ̈ ‑kɔ bha‑ 'gü, \"kɛɛ kö ‑a ‑dhɛ ‑yö ‑gblö ‑sü 'ka, kö pë ‑sɛngbɔ ‑nu 'wo 'kɔɔ ‑dhɛ ‑dhi waa‑ ‑nu dɔ 'kɔɔdhö 'mü, ");
INSERT INTO daf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'yö ö yee ‑dee 'bha ‑kë 'yö dho ‑a mɛ 'dhɛ 'wo ‑nɛnɛsü 'wo ‑ziö yö ‑zë ‑ta bha‑ ‑nu \"saɔplɛ mɔɔ‑ ‑dhɛ 'gü 'yö‑ ‑nu ‑dhɛ 'yö 'wo nu 'wo ‑ya mü. ꞊Ya bo kë ‑sü 'ka \"dhʋ̈ 'yö‑ ‑mɛ 'dhö ‑kë ‑wëësü 'ö ‑ziö 'ka ‑blɛɛsü ‑bha ‑ta. ꞊Dɛɛ ‑mɛ ‑nu 'wo 'wɔn yaa kë ‑zian ‑ta bha‑ ‑nu ‑bha ‑dho kë ‑kɔ do bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu ‑yö ‑to dhiang zë ‑dhɛ 'gü mɛ kpö bha‑ ‑nu ‑dhɛ, 'yö‑ dhe waa‑ dheebhang ‑nu 'wo nu. ‑Yö ‑gun ‑nu \"piʋ̈ ꞊dhɛ 'wo dhiang zë‑ ‑dhɛ, \"kɛɛ kö ‑wo dɔ sië 'kɔdhi \"dhiʋ̈ \"kpɛnng. ");
INSERT INTO daf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Yö mɛ \"wɛɛ do 'bha ‑ya pö Yesu ‑dhɛ 'ö‑ pö: «‑Bhö ‑dhɛ ‑ga, i dhe waa‑ i 'zlaabɔ ‑nu ꞊wa nu, ‑wo dɔ sië i ‑gɔ \"kpɛnngdhö, ‑ya ‑nu \"piʋ̈ ꞊dhɛ 'wo dhiang 'bha zë i ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'Yö Yesu ‑ya ‑yɔ bɔ 'mɛ 'ö dhiang \"dhiʋ̈ ꞊loo‑ ‑bha bha‑ ‑gɔ 'ö‑ pö: «N dhe ꞊në de 'ka? \"Ɛɛn n dheebhang ‑nu ꞊në 'wo 'mɛ?» ");
INSERT INTO daf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ö ‑kɔ ‑zɔn ö ‑bha ꞊klang ‑nu 'ka 'ö‑ pö: «‑Bhö ‑dhɛ ‑ga, n dhe waa‑ n dheebhang ‑nu ‑ga 'wo ya! ");
INSERT INTO daf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bha‑ ‑dhidhɛwɔn ‑kë bha kö‑ ‑mɛ ꞊në n dheebhang dhebhɔ, \"ɛɛn n dheebhang gɔɔn‑ \"ɛɛn n dhe ‑nu ꞊gban 'ka. ");
INSERT INTO daf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","‑A yi 'ö \"dhʋ̈ bha‑ 'ka 'yö Yesu ‑yö go 'kɔɔdhö 'yö dho 'yö ‑ya \"yitagbɛa bha‑ \"kpʋng \"dhiʋ̈ kö 'ö mɛ ‑nu ꞊klang kë. ");
INSERT INTO daf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","'Yö mɛbhɩɩdhe ‑yö bho \"dhuu 'yö 'wo ꞊klëën‑ ‑zü. ꞊Dhɛ 'ö ‑gɛnziödhɛ 'bha 'yaa 'dhö 'zü mɛbhɩɩdhe ‑gɔ, 'yö ‑da \"yitagɔ 'gü 'yö ‑ya mü. 'Yö 'mɛ 'wo bha 'wo to \"yi \"kpʋng \"dhiʋ̈, ");
INSERT INTO daf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","'yö zun 'wɔn 'gbɛ 'klɔɔ‑ ‑pö ‑nu ‑dhɛ \"gwënng 'gü ‑sü ‑bha 'ö‑ pö: «Yi do 'ka 'yö mɛ do 'bha ‑yö ꞊wlü 'yö dho pë ta ‑dhɛ 'gü ö ‑gɔ 'bhlaa. ");
INSERT INTO daf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","꞊Dhɛ 'ö ꞊ya zun 'pë 'ö dho‑ ta bha‑ ga ꞊wɛnng ‑sü ‑bha, 'yö‑ ga 'bha ‑nu 'wo ꞊wɛnng zian ‑gloo ‑ta ('yö 'wii 'dho \"sɛɛdhö), 'yö ‑maa ‑nu 'wo nu 'wo‑ ‑bhö. ");
INSERT INTO daf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","'Yö‑ ga 'bha ‑nu 'wo ‑pö ‑gwë 'saa‑ 'ö \"sɛ 'yaa‑ ‑ta 'gbɛ ‑a \"dhiʋ̈, 'yö 'wo to 'wo bhɔ, ‑a ‑gɛn ‑mü ꞊dhɛ \"sɛ 'ö waa‑ ‑gwë ‑nu ‑a ‑nu ꞊zinng 'gü 'yaa 'gbɛ. ");
INSERT INTO daf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","꞊Dhɛ 'ö 'yënng‑ ꞊ya ‑ya 'bhü ‑sü ‑bha, 'yö‑ \"plüün ꞊gban \"pɛpɛ ‑yö ga, ‑a yun 'dho ‑dhɛ 'ö 'yaa gun bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'Yö‑ ga 'bha ‑nu 'wo ‑pö \"glɛɛn ‑kpɔɔ 'gü. ꞊Dhɛ 'ö ꞊wa bhɔ, 'yö ‑kpɔɔ ‑yö ‑da ‑nu ‑ta 'yö‑ zë. ");
INSERT INTO daf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","\"Kɛɛ 'yö‑ ga 'bha ‑nu 'wo ‑pö \"sɛ ‑së 'gü, 'yö 'wo ‑da ꞊nii 'gü 'yö 'wo dho 'wo ‑wo 'gü, 'yö‑ 'bha ‑nu ga ‑yö ‑kë ö ‑kpaa ‑bha këng do, 'yö‑ ‑kpaa 'bha ‑nu bha ga‑ ‑kë ‑kaɔng \"saɔdo, 'yö‑ 'bha ‑nu ‑bha ‑yö ‑kë ‑kaɔng ‑yaaga.» ");
INSERT INTO daf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","꞊Dhɛ 'ö ꞊ya bo‑ ‑pö \"dhʋ̈ ‑sü 'ka 'yö‑ pö‑ ‑nu ‑dhɛ: «'Mɛ 'i 'wɔn 'gü ma ‑mɛ 'ka, kö a‑ zë i ‑dhɛ, (‑bhö i \"tʋ 'to ‑së 'ka 'kii‑ 'gü ma).» ");
INSERT INTO daf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yö ꞊në‑ ‑wɔn 'gü 'yö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ‑wo ‑yɔɔn \"sɔɔ, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «‑Më ꞊në ‑kë 'yö 'i dhiang ꞊gban \"pɛpɛ zë‑ ‑nu ‑dhɛ \"gwënng ꞊në‑ 'gü ya?» ");
INSERT INTO daf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A kë 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'wɔn 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑bha bha, ꞊ya \"dhɛ bho‑ ‑ta ka ‑zë ka ‑dhɛ. \"Kɛɛ 'yaa‑ ‑ta \"pʋ ‑sü 'ka wo ‑zë ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö pë 'dhö‑ ‑gɔ 'ö‑ ‑ziö 'gü ‑ziö ꞊në 'wo dho‑ taa kë, 'yö‑ ‑bha ‑yö ‑kë 'gbɛ \"kɛɛ 'mɛ 'kö pë 'bhaa‑ ‑gɔ ‑a 'dɛdɛ 'në 'dhɛ yaa‑ ‑kë ‑gɔ, \"kɛɛ 'ö 'yaa‑ ‑ziö 'gü ‑zë ziö bha ‑wo ‑dho ‑a 'sü ‑zian ꞊në‑ wo‑ ‑mɛ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Wɔn 'ö‑ ‑wɔn 'gü 'yö 'a dhiang zë‑ ‑nu ‑dhɛ \"gwënng 'gü bha yö bha; ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn ‑nu 'ö‑ ‑nu \"yan 'dhö dɔ‑ 'gü bha 'waa‑ yö. 'Wɔn 'wo‑ ma ‑nu wo bha 'waa‑ 'klɔɔ‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","\"Kɛɛ ‑yö ‑kë \"dhʋ̈ kö 'pë 'ö Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑ya pö yi 'bha 'ka bha ꞊në‑ 'gü ‑wɔn ‑yö kë. ‑A ‑gɛn ‑mü ꞊dhɛ Ezai ‑yö dhiang ‑zë ‑a ‑nu ‑dhɛ yi 'bha 'ka 'ö‑ pö: ‹Ka \"tʋ‑ ‑dho 'wɔn ma, \"kɛɛ 'kii 'dho‑ 'klɔɔ‑ dɔ, ka ‑dho ‑dhɛ ‑ga 'kpakpadhö, \"kɛɛ 'kii 'dho ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","‑A ‑gɛn ‑mü ꞊dhɛ \"sɛ ya‑ 'gü ‑mɛ ‑nu zuë\" ꞊ya kë \"glɔɔglɔ, ꞊wa wo \"tʋ ta kö 'wa 'dho 'wɔn 'bha ma, ꞊wa wo \"yan ta kö 'wa 'dho ‑dhɛ yö, kë \"dhʋ̈ kö 'wa 'dho 'wɔn 'gü ma 'ö 'wo wo zuë\" ꞊slëë n \"piʋ̈ 'ö 'a‑ ‑nu dha.› ");
INSERT INTO daf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","\"Kɛɛ ka ‑zë ka ‑bha ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ ka \"yan ‑yö ‑dhɛ ‑yö 'ö ka \"tʋ ‑yö 'wɔn ma. ");
INSERT INTO daf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ 'gbɛ ꞊dede zuë\" ‑gun ‑bha waa‑ dhɔɔbhaawɔn këmɛ ‑nu 'dhö, ꞊dhɛ wo \"yan ‑yö dɔ 'wɔn 'ka‑ ‑dhɛ yö sië ꞊dɛɛ ya‑ 'gü kö 'wɔn ‑nu 'ka‑ ma sië ya 'wo‑ ma 'pö, \"kɛɛ 'wii‑ ‑dhɛ yö \"ɛɛn 'wii‑ ma.» ");
INSERT INTO daf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","'Yö‑ pö: «‑A ‑wɔn 'gü ka ‑zë ‑ka ka \"tʋ 'to \"gwënng 'a‑ ‑da 'ö ‑gban pëtamɛ ‑bha bha‑ 'klɔɔ‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","'Mɛ 'ö Atanna ‑bha ‑gblüdëdhɛ bha‑ ‑dhiang ma 'ö ‑ziö ‑mɛ \"tʋ 'gü ‑gɛn 'ka 'ö 'yaa‑ 'gü ma bha kö‑ mɛ ꞊në ꞊dhɛ zian ‑gloo ‑ta ‑dhɛ 'ö ‑mlüga ‑yö ‑pö 'gü bha‑ 'dhö. \"Yina yaa ꞊ya nu 'yö Atanna ‑wʋ 'dhɛ 'ö‑ ‑da ‑mɛ zuë\" \"piʋ̈ bha‑ bho 'mü ꞊dhɛ ‑kɔ do 'ö ‑maa ‑nu 'wo ‑mlüga 'ö ꞊wɛnng zian ‑gloo \"piʋ̈ bha‑ ‑bhö 'ka bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mɛ 'dhɛ 'ö‑ ‑nu ‑bha ‑yö bhɔ ‑mlüga 'dhɛ 'ö ꞊wɛnng ‑gwë 'saa‑ \"dhiʋ̈ bha‑ ‑bha bha wo ꞊në ꞊wa Atanna ‑wʋ ma ‑dhɛ 'ö‑ 'gü, 'yö 'wo to 'mü 'wo ‑wɩ ‑bha \"yɩɩ 'ka, ");
INSERT INTO daf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","\"kɛɛ 'waa wo kwaa‑ ‑zü kö‑ yun ‑yö ziö‑ ‑nu 'gü, 'yö 'wɔn \"gbɩɩ‑ ꞊ya ‑da ‑nu ‑ta Atanna ‑wʋ 'wo‑ ma bha‑ ‑wɔn 'gü, 'yö 'wo wo ‑kɔ ‑kan \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","'Yö‑ mɛ 'bha ‑nu ‑dɩ 'pö 'wo ‑kë ꞊dhɛ \"glɛɛn ‑kpɔɔ 'ö tapë ga ‑yö ‑pö 'gü bha‑ 'dhö. 'Yö ꞊wa Atanna ‑wʋ ma 'wo 'dhang bho‑ \"dhiʋ̈, \"kɛɛ 'yö 'waa ‑ya yö ‑zë ‑wɔn zuën ‑ta. 'Yö ‑zʋ ‑gɔn \"kpʋng ꞊taa ‑wɔn ‑nu 'ka ‑sü waa‑ ꞊naɔ ‑dhɔ ‑nu 'wo‑ ‑nu ‑gɔ 'gü ꞊see, 'yö‑ ‑nu ꞊trɔɔn 'yaa kë Atanna ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","\"Kɛɛ 'yö‑ mɛ 'bha ‑nu ‑dɩ 'pö ‑a ‑nu ‑bha ‑yö ‑kë ꞊dhɛ ‑mlüga 'dhɛ 'ö ‑pö \"sɛ ‑së 'gü bha‑ 'dhö. 'Yö ꞊wa Atanna ‑wʋ ma 'yö 'wo 'dhang bho‑ \"dhiʋ̈, 'yö 'wo ꞊trɔɔn ‑kë ‑dhɛ 'yö‑ ‑nu ꞊trɔɔn ‑yö ‑wɔ zian ꞊gban 'ka ꞊dhɛ tapë 'dhɛ 'ö‑ ‑kpaaga do ga ‑yö ‑kë këng do \"ɛɛn ‑kaɔng \"saɔdo \"ɛɛn ‑kaɔng ‑yaaga bha‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö go mü 'ö \"gwënng ‑dee 'bha ‑da ‑nu ‑dhɛ 'ö‑ pö: «Atanna ‑bha ‑gblüdëdhɛ bha‑ \"sinma ‑yö ‑kë ꞊dhɛ mɛ do 'bha 'ö ö ‑bha ‑bhöpë ta ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","꞊Dhɛ 'ö ꞊ya ‑bhöpë ta ö ‑gɔ ‑dhɛ bha‑ 'gü 'ö gbeng ꞊ya ꞊loo kö mɛ ꞊gbaan yi zë, 'yö‑ 'yaɔ‑ ‑yö nu 'yö blëë yaa ga ‑pɛn ‑a ‑gɔ 'bhlaadhɛ bha‑ 'gü 'yö‑ to 'yö ‑ziö. ");
INSERT INTO daf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","꞊Dhɛ 'ö tapë bha ꞊ya bhɔ 'ö ꞊ya ‑ya ‑wo 'gü ‑sü ‑bha, 'yö blëë bha yöö ‑dɩ 'pö 'ö ‑ya ‑da ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","'Yö 'bhlaadhɛ bha‑ dëmɛ ‑bha yëkëmɛ ‑nu 'wo nu 'wo‑ pö‑ ‑dhɛ: «Yi dëmɛ, gun 'kwa‑ wo ya, ‑bhöpë ‑dɩ ‑slɔɔ 'aa mü 'i‑ bɔ i ‑bha ‑dhɛ ya 'gü 'nu ya \"wɛ ‑ee? 'Yö blëë yaa 'kö ya ‑yö go 'mɛ 'yö bhɔ‑ 'gü \"dhʋ̈?» ");
INSERT INTO daf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «N 'yaɔ‑ ꞊në bhɔ bha.» 'Yö 'wo‑ ‑slëë ‑ta ‑kë 'pö‑ ‑gɔ 'wo‑ pö: ꞊Dhɛ 'ö \"dhʋ̈ 'sa kö ‑bhö dɔ kö 'yi 'dho kö 'yi‑ 'gü bho kö 'yi‑ blëë yaa ‑nu bha‑ ꞊gban ‑wo \"pɛɛpɛdhö ‑dhe.» ");
INSERT INTO daf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","\"Kɛɛ 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Abin, ‑kaa 'to \"dhʋ̈ \"sɛnngdhö, ‑a ‑gɛn ‑mü ꞊dhɛ 'ka‑ pö 'ka‑ 'gü bho \"tʋ̈ng ya‑ 'gü, ka ‑dho ‑bhöpë ‑gɔ ꞊nëng blëë ‑gɔ ‑bha 'ka‑ ‑wo 'ka. ");
INSERT INTO daf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","\"Kɛɛ ‑ka ka kwaa‑ ‑nu ‑zü kö ‑wo kpɛa‑ wo \"kwëë kö tapë bha‑ \"kan \"tʋ̈ng ‑yö ꞊loo! ꞊Ya kë ꞊dhɛ ‑a \"tʋ̈ng ꞊ya ꞊loo, 'yö 'a‑ pö‑ \"kanmɛ ‑nu ‑dhɛ: «‑Ka blëë yaa ‑nu ‑wo ꞊kö kö 'ka‑ ‑nu ‑be kë, kö 'ka‑ ‑nu \"gʋ̈! Kö 'ka ‑bhöpë ‑zë 'dhu n ‑gɔ ꞊gbaandhö.» ");
INSERT INTO daf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö \"gwënng do 'bha ‑da 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «'Wɔn ‑taɔng ‑së 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑bha bha ‑yö ‑bhɔ \"dhü 'wo‑ seneve ‑kë bha‑ ga ꞊në‑ ‑bha. \"Dhüga bha ꞊në mɛ do ‑ya sü yi do 'ka 'yö‑ ta ö ‑gɔ 'bhlaa. ");
INSERT INTO daf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yö ꞊në tapë 'kö 'wo‑ ta ‑a ga ꞊gban \"pɛpɛ suu 'dɛdɛ ‑sü 'ka, \"kɛɛ ꞊ya kpɛa‑ ‑yö ‑ziö tapë ‑zë ꞊gban \"pɛpɛ ‑ta, 'ö ꞊ya dɔ 'mü kö ‑maa ‑nu ‑wo wo 'kɔ ‑nu dɔ sië‑ kwɛɛ\" ‑nu 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","'Yö \"gwënng \"wɛɛ 'bha ‑da 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «'Wɔn ‑taɔng ‑së 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑bha bha ‑yö ‑kë ꞊dhɛ \"sɛkɛ 'wo‑ ‑da 'bluubi ‑bha ꞊sië bha ꞊në‑ 'dhö. ꞊Waa‑ ‑bi 'në 'bha 'sü kö ‑wa ‑da 'bluubi 'gbɛ \"piʋ̈ kö ‑wa \"yi bho 'yö ‑da, 'yö‑ ‑bʋ̈ʋ̈ ‑yö 'pë 'wo‑ ‑ma 'gü bha‑ pa.» ");
INSERT INTO daf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ‑yö dhiang \"pɛpɛ bha‑ ꞊gban ‑zë mɛ kpö bha‑ ‑nu ‑dhɛ \"gwënng ꞊në‑ 'gü, 'yii‑ 'bha zë‑ ‑nu ‑dhɛ \"wɛɛwɛɛ. ");
INSERT INTO daf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kë \"dhʋ̈ kö 'pë 'ö Atanna ‑wʋdhiʋ̈loomɛ do 'bha ‑ya pö yi 'bha 'ka bha‑ 'gü ‑wɔn ‑yö kë: «꞊Dhɛ a ‑dho dhiang zë‑ ‑nu ‑dhɛ \"gwënng ꞊në‑ 'gü kö pë ‑nu 'wo ‑bin ‑sü 'ka 'ö go‑ 'ka \"kpʋngtaadhɛ kë ‑yi ‑bha 'ö nu 'ö zun‑ 'ka ꞊dɛɛ ‑bha bha 'a‑ ‑ta \"pʋ‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö ‑kan mɛ kpö bha‑ ‑nu ‑bha 'yö dho 'kɔɔdhö. ꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ‑wo 'kɔɔdhö 'yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ 'yö 'wo‑ pö‑ ‑dhɛ: «\"Gwënng 'i ‑da ꞊diö 'ö ‑gban blëë yaa 'ö gɔndë 'yaɔ‑ ‑ya ta‑ ‑gɔ 'bhlaa bha‑ ‑bha bha‑ 'klɔɔ‑ pö yi ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Mang Mɛgbömɛ ma ꞊në 'a ‑bhöpë bha‑ tamɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","\"Kpʋngtaadhɛ ꞊në ꞊dhɛ 'bhlaadhɛ 'a tapë bha ta‑ 'gü bha‑ 'dhö, 'yö mɛ ꞊wa kë Atanna ‑bha ‑gblüdëdhɛ 'gü ‑mɛ ‑nu 'ka bha 'wo ꞊dhɛ 'pö ꞊dhɛ tapë bha‑ 'dhö, 'yö 'mɛ 'wo Sɔtraan ‑bha ‑gɔ 'gü bha 'wo ꞊dhɛ 'pö ꞊dhɛ blëë yaa bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","'Yö‑ 'yaɔ‑ 'ö blëë yaa bha‑ ta \"dhʋ̈ bha, 'yö ‑kë ‑a Sɔtraan ꞊dede bha‑ 'ka, ‑a ‑bhöpë \"kan \"tʋ̈ng bha yö ‑mü \"kpʋngtaadhɛ yën \"tʋ̈ng ꞊në‑ 'ka. Atanna ‑bha \"kië ‑nu bha 'pö ꞊në 'wo ‑bhöpë bha‑ \"kanmɛ ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","\"Kpʋngtaadhɛ \"dhiʋ̈toyi 'ka ‑kɔ do 'wo blëë yaa bha ‑wo 'ka 'wo‑ ‑zuö pɛng 'gü bha ‑yö ‑dho kë 'pö \"dhʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","‑A 'yi bha‑ 'ka, mang Mɛgbömɛ a ‑dho Atanna ‑bha \"kië ‑nu 'wo ‑ya ‑sü 'ka ma ‑ya 'gü bha‑ ‑nu bɔ 'ö 'wo 'mɛ 'wo mɛ ‑nu ‑pö sië 'wɔn yaa 'gü bha waa‑ 'wɔnyaakëmɛ ‑nu \"pɛpɛ ꞊gban bho ma ‑gblüdëdhɛkëdhɛ 'gü, ");
INSERT INTO daf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","'ö 'wo‑ ‑nu ‑zuö pɛng 'gü, ‑wo ‑dho ‑wëë ‑gbʋ bɔ ‑dhɛ bha ꞊në‑ 'gü 'yö 'wo wo \"sɔn zun‑ 'ka 'ko \"dhiʋ̈ \"kʋ̈ükʋ̈üdhö. ");
INSERT INTO daf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","\"Kɛɛ mɛ 'dhɛ 'kö 'wo to Atanna dhɔɔbhaa ‑zian ‑ta bha, ‑a ‑nu 'bhü ‑dho bhɔ ꞊dhɛ 'yënng‑ 'bhü 'dhö bhɔ ꞊sië ‑kɔ 'ö‑ 'gü bha‑ 'dhö ‑a ‑nu Dë ‑bha ‑gblüdëdhɛkëdhɛ bha‑ 'gü.» 'Yö‑ pö‑ ‑nu ‑dhɛ: «'Wɔn 'gü ma ‑tʋ 'dhö 'mɛ 'ö i ‑gɔ ‑bha kö yö ꞊në 'a‑ pö bha (i \"tʋ 'to‑ ‑bha ‑së 'ka 'kii‑ 'gü ma).» ");
INSERT INTO daf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","'Yö go mü 'ö‑ pö: «‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ bha ‑yö ꞊dhɛ ꞊naɔ 'ö ‑bin ‑sü 'ka 'bhlaadhɛ do 'bha 'gü ꞊në‑ 'dhö. 'Mɛ ꞊yaa‑ yö, 'yaa ö \"dhi ‑wo ‑ta mɛ 'bha ‑dhɛ, \"kɛɛ ‑a ‑dhi ‑dhɛ ‑kɔ yaa bha‑ ‑wɔn 'gü, ‑yö 'dho ꞊në wo 'yö ö ꞊slɔɔpë ꞊gban \"pɛpɛ \"dhɔɔ dɔ 'yö nu 'yö 'bhlaadhɛ bha‑ dhɔ.» ");
INSERT INTO daf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","'Yö‑ pö: «‑A ‑gɛn ‑mü 'zü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ bha ‑yö ꞊dhɛ ‑zlɔɔ ꞊bhlëësü \"dhɔɔdɔmɛ 'ö‑ mɔɔ‑ sië ꞊në‑ 'dhö. ꞊Yaa‑ 'dhɛ 'ö‑ sɔng 'dhö \"gbɩɩ‑ ‑a yö, ");
INSERT INTO daf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","'yö dho 'yö ö ꞊kwɛngpë ꞊gban \"dhɔɔ dɔ 'yö nu 'yö‑ dhɔ.» ");
INSERT INTO daf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","'Yö‑ pö: «‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn 'bha ‑mü 'zü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ bha ‑yö ꞊dhɛ \"nuu 'wo‑ ‑zuö \"yi ꞊gblü 'kpii‑ ‑ta 'ö 'yuʋ̈‑ ꞊gban \"pɛpɛ suu 'do 'do sü bha ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","꞊Ya kë ꞊dhɛ ꞊waa‑ ‑zuö bha‑ wo \"dhʋ̈ ꞊ya pa, 'yö‑ \"nuuzuömɛ ‑nu 'wo‑ ‑gan 'wo dho‑ 'ka \"kpʋng ꞊taa 'yö 'wo‑ ‑zë 'gü ‑kë, 'yö‑ 'dhɛ 'ö‑ ‑zun \"dhiʋ̈ ‑bhlɔɔ 'yaa 'dhö bha 'wo‑ ꞊wɛnng \"yi ꞊bhaa. ");
INSERT INTO daf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","‑Yö ‑dho kë ‑kɔ do bha ꞊në‑ 'gü \"kpʋngtaadhɛ yën ‑yi 'ka. Atanna ‑bha \"kië ‑nu ‑dho nu 'ö 'wo 'wɔnsëkëmɛ ‑nu waa‑ 'wɔnyaakëmɛ ‑nu ‑kan 'kwëë‑. ");
INSERT INTO daf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","'Yö 'wo 'wɔnyaakëmɛ ‑nu ‑da pɛng 'gü. ‑Dhɛ bha ꞊në 'wo dho ‑wëë ‑gbʋ bɔ‑ 'gü 'ö‑ ‑nu \"sɔn ‑yö zun‑ 'ka 'ko \"dhiʋ̈ \"kʋ̈ükʋ̈üdhö.» ");
INSERT INTO daf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","'Yö Yesu ‑ya ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «'Ka‑ 'gü ma 'kpakpadhö ‑ee? 'Yö 'wo‑ pö: «꞊Iin, 'ya‑ 'gü ma.» ");
INSERT INTO daf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'Yö‑ pö 'zü‑ ‑nu ‑dhɛ ‑deewo ꞊dhɛ: «‑A ‑kë \"dhʋ̈ ‑sü 'gü, 'tɔnggɔmɛ \"pɛpɛ 'wo 'wɔn 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑bha bha‑ dɔ 'kpakpadhö bha, ‑wo ꞊dhɛ ꞊naɔmɛ do 'ö pë ‑dee waa‑ pë zizi ‑nu sü ö ‑bha ꞊naɔ 'gü 'ö‑ 'gü ꞊gblü mɛ ‑nu ‑ta ꞊në‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","꞊Dhɛ 'ö Yesu ꞊ya ö bo \"gwënng ‑nu bha‑ ‑nu 'klɔɔ‑ ‑pö ‑nu ‑dhɛ ‑sü 'ka, 'yö go ‑dhɛ 'dhɛ bha‑ 'gü, ");
INSERT INTO daf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","'yö dho 'pödhɛ 'dhɛ 'ö 'nëdhɛ ‑kë 'gü bha‑ 'gü, 'yö dho Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ 'gü 'yö ‑ya mɛ draan‑ ‑sü ‑bha mü. 'Yö‑ 'wɔn ‑yö mɛ \"pɛpɛ 'wo gun 'mü ‑a ‑nu ꞊gban kɔn, 'yö 'wo ‑ya pö ‑sü ‑bha: «'Wɔndɔdhe suu 'kö ya ‑yö ‑go ‑a 'ka 'mɛ? \"Dhabhliwɔn ‑nu 'ö‑ kë sië ya ‑ya ‑nu ‑draan 'mɛ?» ");
INSERT INTO daf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","\"Ɛɛn \"dhüyënmɛ gbö (do \"wɛ 'ö mɛ ꞊gban 'kwa‑ dɔ) ya 'yaa ‑mü ‑ee? \"Ɛɛn Madhi gbö ya 'yaa kë ꞊ni ‑ee? \"Ɛɛn ‑a 'zlaabɔ ‑nu 'waa ‑mü Zakö, Zosɛfu, Simɔ waa‑ Zudë ‑nu 'ka ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","\"Ɛɛn ‑a 'zlaa‑ dhong ‑nu 'waa mü 'wo kwa \"piʋ̈ ‑dhɛ ya‑ 'gü ya ‑ee? 'Wɔn \"gblʋ̈gblʋ̈ ‑nu 'ö‑ kë sië ya ‑yö ‑go kë ‑faan 'ka 'mɛ 'sa?» ");
INSERT INTO daf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","‑A ‑kë \"dhʋ̈ ‑sü ‑wɔn 'gü 'wii 'dhang bho Yesu \"dhiʋ̈. Yesu ‑ya ‑pö yö ꞊në‑ ‑wɔn 'gü ‑a ‑nu ‑dhɛ 'ö‑ pö: «‑Wo Atanna ‑wʋdhiʋ̈loomɛ ꞊bhlëë ‑ya 'pödhɛ \"wɛɛ ꞊gban 'gü, \"kɛɛ 'waa‑ ꞊bhlëë ‑ya ‑a ‑dɩ ‑gɔ 'pödhɛ waa‑ ‑dɩ ‑gɔ 'kɔɔdhɛ ꞊në‑ 'gü tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","'Mɛ 'wo bha‑ ‑nu ‑bha gɔɔgbɩɩdhɛ 'ö 'dhang ‑bho Yesu \"dhiʋ̈ ‑sü 'yaa gun‑ ‑nu ‑gɔ bha‑ ‑wɔn 'gü 'yii \"dhabhliwɔn 'gbɛ 'bha kë mü. ");
INSERT INTO daf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","‑A \"tʋ̈ng bha‑ 'gü kö Edhodö ꞊në ‑gblüdë 'ka Gadhidhe ‑sɛ 'gü, 'yö Yesu ‑wɔn ma. ");
INSERT INTO daf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'Yö‑ pö ö ‑bha gwëëzë ‑nu ‑dhɛ ꞊dhɛ Zan Mɛzumɛ ꞊në ꞊ya 'go ga 'gü 'ö ꞊ya ‑bö. Yö ꞊në‑ ‑wɔn 'gü 'yö \"sɩ 'dhö‑ ‑dhɛ 'yö \"dhabhliwɔn ‑nu kë sië bha. ");
INSERT INTO daf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊yaa‑ pö 'nu ö ‑bha gwëëzë ‑nu bha‑ ‑nu ‑dhɛ ꞊dhɛ ‑wo Zan kun kö ‑wa ‑da ‑kaso 'gü. Kö ꞊waa‑ 'kun ꞊waa‑ ‑lö ꞊waa‑ ‑da ‑kaso 'gü. 'Ö gun \"dhʋ̈ kö Edhodö ꞊ya ö dheebhang Fidhipö ‑bha dhebhɔ 'wo‑ ‑dhɛ Edhodiadö bha‑ 'sü‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kö Zan ꞊yaa‑ pö‑ ‑dhɛ ꞊dhɛ 'yaa ‑së kö ‑a dheebhang ‑bha dhebhɔ ‑zë ‑yö ‑ya ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kö ‑a pö 'ö Zan ‑ya wo \"dhʋ̈ bha ꞊ya ꞊sië Edhodö ‑dhɛ kö ‑ya \"piʋ̈ ꞊dhɛ 'ö‑ zë, \"kɛɛ kö ‑yö \"suʋ̈ sië Zuifö ‑nu ‑gɔ, ‑a ‑gɛn ‑mü ꞊dhɛ kö ‑a ‑nu ꞊gban \"pɛpɛ ‑wo Zan ‑dɔ Atanna ‑wʋdhiʋ̈loomɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","\"Kɛɛ ꞊dhɛ 'ö Edhodö bhɔ \"tʋ̈ng bha‑ trookëyi ꞊ya ꞊loo, 'ö Edhodiadö 'dhu 'dhö \"tan kë sië 'mɛ 'wo nu troo ‑ta bha‑ ‑nu ‑kuu \"dhiʋ̈, 'yö ‑dhi Edhodö ‑dhɛ yaa 'gü yaa wo. ");
INSERT INTO daf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'Yö ‑sö ‑bhö 'në bha‑ ‑dhɛ 'ö‑ pö: «Pë \"ʋʋ pë 'ö dho‑ ‑wɔn pö ö ‑dhɛ ö ‑dho ‑a nu‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'Ö \"dhʋ̈ bha kö 'në bha‑ dhe ꞊ya ‑wʋ 'kpɔ‑ ‑bha kö ꞊yaa‑ pö ‑yö Zan Mɛzumɛ ‑gɔ ꞊në ‑wɔn pö. 'Yö 'në bha 'ö dɔ ö dhe ‑wʋ bha‑ ‑ta 'yö‑ pö Edhodö ‑dhɛ ‑yö Zan ‑gɔ ‑ya 'tɛa‑ do 'gü kö ‑yö ö gba‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","‑A pö 'ö 'në bha ‑ya wo \"dhʋ̈ bha 'yii dhi ‑gblüdë Edhodö ‑dhɛ, \"kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ ꞊ya \"plüün bho 'mɛ 'ö‑ ‑nu ‑dhɛ troo ‑ta bha‑ ‑nu wëëdhö 'ö ꞊ya ‑sö ‑nu ꞊gban ‑bhö bha‑ ‑wɔn 'gü, 'yö‑ pö ö ‑bha gwëë\" ‑nu ‑dhɛ ꞊dhɛ ‑wo 'dho kö ‑wo nu Zan Mɛzumɛ ‑gɔ 'ka‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","'Yö mɛ do bɔ kö ‑yö 'dho Zan ‑gɔ \"kan ‑dhɛ 'gü ‑kaso 'kɔ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'Yö 'mɛ bha 'ö dho 'yö Zan ‑gɔ ‑kan 'yö ‑da 'tɛa‑ do 'gü 'yö nu‑ 'ka 'nëdhiëngnë bha‑ ‑dhɛ, 'yö dho‑ 'ka ö dhe ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","'Yö Zan ‑bha ꞊klangdhiʋ̈ ‑nu 'wo nu 'wo‑ ꞊gee sü 'wo dho‑ 'ka 'wo‑ bun bho, 'yö 'wo dho 'wo ‑ziö ‑gɛn 'gü Yesu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","꞊Dhɛ 'ö Yesu ꞊ya 'wɔn bha‑ ma, 'yö ‑da \"kplagɔnë 'gü ö do 'ka 'yö dho ‑dhɛ \"dhiʋ̈ ꞊nëng ‑dhɛ 'bha 'gü. \"Kɛɛ ꞊dhɛ 'ö mɛ kpö 'gbɛ ꞊waa‑ 'wɔn ‑dɔ, 'yö 'wo go 'pö‑ ‑nu 'gü 'wo ‑ta wo ‑gɛn ‑ta \"yi \"piʋ̈ \"yɛɛdhö 'wo dho‑ \"gblʋʋ ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu ‑bha ‑go \"kplagɔnë 'gü ‑sü kö ‑yö zun \"sia‑ kö mɛ \"dhaa ‑yö ꞊klëën ‑sü 'ka ‑dhɛ bha‑ 'gü, 'yö‑ ‑nu ‑wëë ‑ya ‑kë, 'yö \"yuëdhi ‑nu \"pɛpɛ 'wo gun‑ ‑nu kpö 'gü mü bha‑ ‑nu ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","꞊Dhɛ 'ö dhɔng ꞊ya ‑da, 'yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ 'wo‑ pö‑ ‑dhɛ: «\"Bin ꞊ya 'ma ꞊ya bo, \"kɛɛ 'sa ‑dhɛ 'kwa‑ ‑bha ya ‑dhɛ \"dhiʋ̈ ꞊nëng ‑dhɛ ‑mü, ‑bhöpë 'bha 'yaa ꞊slɔɔ mü, ꞊dhɛ 'ö \"dhʋ̈ ‑bhö ‑a pö 'mɛ 'wo ya‑ ‑nu ‑dhɛ ‑wo 'dho 'pö‑ ‑nu 'gü kö ‑wo woo‑ ‑bhöpë ‑nu mɔɔ‑!» ");
INSERT INTO daf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Aa bhoo, ‑a ‑dhɛ 'yaa‑ ‑bha kö ‑wo 'dho \"dhʋ̈, ka ꞊në ‑kaa ‑nu gba ‑bhöpë 'ka!» ");
INSERT INTO daf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","\"Kɛɛ 'yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «‑Bhöpë 'kö ꞊ya 'to yi ‑gɔ yö ꞊ya 'to 'bluu‑ bhɛ \"sɔɔdhu waa‑ 'yuʋ̈‑ ꞊plɛ.» ");
INSERT INTO daf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'Yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka nu‑ 'ka n ‑dhɛ yö!» ");
INSERT INTO daf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö‑ pö 'mɛ 'wo bha‑ ‑nu ‑dhɛ ‑wo ‑ya 'kpaa‑ ‑ta. ꞊Dhɛ 'ö‑ ‑nu ꞊gban \"pɛpɛ ꞊wa 'yaanu, 'yö ö ‑kɔ ‑da 'bluu‑ bhɛ \"sɔɔdhu waa‑ 'yuʋ̈‑ ꞊plɛ bha‑ 'gü, 'yö ö \"yan \"dhiʋ̈ ꞊wlü dhang‑ 'gü 'yö ꞊bhɛa Atanna ‑dhɛ 'yö‑ nuɛ\" bho 'yö‑ \"kplükplü bho 'yö‑ nu ö ‑bha ꞊klang ‑nu ‑dhɛ, 'yö 'wo‑ 'gü ‑gblü 'mɛ 'wo bha‑ ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","'Yö 'mɛ 'wo bha 'wo pë ‑bhö 'wo kën, 'yö ‑bhöpë 'bha ‑yö to, 'yö‑ 'dhɛ 'ö to bha 'wo‑ ꞊loo 'ko ‑ta, 'yö ‑kë 'bluu‑ \"kplü töö ‑yan ‑kaɔng do ga ꞊plɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","'Mɛ 'ö Yesu ‑ya ‑nu \"dhi gba \"dhʋ̈ bha‑ gɔɔn‑ ‑nu ‑dɩ ‑slɔɔ kö 'wii 'në ‑nu waa‑ dhong ‑nu dhʋng, ‑wo ‑mɔɔ mɛ \"gblü \"sɔɔdhu ‑nu ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","‑A ‑nu ‑bö pë ‑bhö ‑sü 'ka ‑sü oo, 'yö Yesu ‑yö to 'ö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ ‑wo ‑da \"kplagɔnë 'gü \"vaandhö kö ‑wo \"yi \"kan, \"sanni ö ‑bo ‑wʋ ‑kpɔ 'mɛ bha‑ ‑nu ‑bha ‑sü kö ‑wo dho wo ‑gɔ 'pö‑ ‑nu 'gü ‑sü ꞊zinng 'gü. ");
INSERT INTO daf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","꞊Dhɛ 'ö ꞊ya bo ö ‑wʋ ‑kpɔ mɛ kpö bha‑ ‑nu ‑bha ‑sü 'ka, 'yö ‑da ‑tɔn 'në 'bha bha‑ ꞊gbin‑ kö ‑yö bhɛa\" Atanna ‑dhɛ 'mü. ‑Yö ‑to ‑tɔn ꞊gbin‑ mü ö do 'ka 'yö \"bin ‑yö ma. ");
INSERT INTO daf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","\"Tʋ̈ng 'ö kë sië‑ 'ka \"dhʋ̈ bha kö‑ ‑bha ꞊klang ‑nu ‑zë ꞊wa ‑gɛn ‑yan kpö \"ta sü \"yi ‑ta, \"kɛɛ kö \"tɛɛ \"gbɩɩ‑ ‑yö ziö sië, 'ö go‑ ‑nu 'dho ‑zian 'ka, kö \"yi ‑yö ꞊bang \"bang kë sië 'ö \"yi kpö ‑nu 'wo ‑ma \"yitagɔ bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","꞊Dhɛ 'ö ‑dhɛkpaɔ \"dhiʋ̈ ꞊ya ꞊loo, 'wo dho ‑dhɛ ‑ga kö Yesu ‑yö \"ta sië \"yi ‑ta \"wɛ tuaa ꞊tuaa tuaadhö 'ö nu‑ ‑nu ‑zian 'ka. ");
INSERT INTO daf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","\"Kɛɛ ꞊dhɛ 'wo wo \"yan ‑kpan ‑bha kö ‑yö nu sië ꞊dhɛ ‑kɔ bha‑ 'dhö \"yi ‑ta, 'yö \"suʋ̈ 'dhö ‑da ‑nu 'gü, 'yö 'wo ‑ya \"gbla ‑sü ‑bha 'wo‑ pö: «Mɛ ‑zii ‑mü!» 'Yö 'wo ‑ya \"ta bhoo ‑da ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","\"Kɛɛ 'yö Yesu ‑yö to 'ö‑ pö‑ ‑nu ‑dhɛ: «‑Ka ka zuë\" kë ‑sɛa, 'ka 'dho \"suʋ̈, ma ‑mü!» ");
INSERT INTO daf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","'Yö Piɛdhö ‑ya pö‑ ‑dhɛ: «N Dëmɛ, ꞊ya kë i 'ka ꞊dedewo tɛan‑ 'ka kö ‑bhö dɔ kö mang ‑dɩ 'pö 'a \"ta \"yi ‑ta ꞊dhɛ i 'dhö kö 'a nu i ‑dhɛ 'gü!» ");
INSERT INTO daf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Bhö nu!» 'Yö Piɛdhö ‑yö go \"yitagɔ 'gü 'yö ‑da \"yi ‑ta 'yö gun 'dho sië Yesu \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","\"Kɛɛ 'ö 'dho sië \"dhʋ̈ kö \"tɛɛ ‑yö ziö sië \"gbɩɩ‑ 'ka \"dhʋ̈ ‑kpɛawo, 'yö \"suʋ̈ 'dhö ‑da Piɛdhö 'gü, 'yö ‑ya 'pö ‑dho \"yi ꞊wlöö ‑sü ‑bha, \"kɛɛ 'yö ꞊gbla 'ö‑ pö: «N Dëmɛ, ‑bhö n dha!» ");
INSERT INTO daf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Yö to 'yö Yesu ‑yö ö ‑gbe 'gü ‑pʋ ‑a \"tʋ̈ng 'ka 'yö‑ sën‑ ‑kɔ ‑bha 'yö‑ pö‑ ‑dhɛ: «\"Eke, i ‑bha ‑zʋ ‑yö n ‑dhɛ ‑sü ‑yö 'dɛdɛ ꞊tɔn ‑kɛɛ, Piɛdhö! ‑Më ꞊në ‑kë 'yö 'i 'zëë‑ 'zë ‑kë?» ");
INSERT INTO daf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","꞊Dhɛ 'ö‑ ‑nu ꞊gban ꞊plɛ ꞊wa ‑da \"yitagɔ 'gü, 'yö \"tɛɛ ‑yö bo ziö ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Yö‑ ‑bha ꞊klang ‑nu 'dhɛ 'wo to \"yitagɔ 'gü 'wo zun‑ ‑dhɛ wo kpiö 'gü 'wo‑ pö: «'Aa, yi Dëmɛ, Atanna Gbö ‑mü i 'ka ꞊dedewo tɛan‑ 'ka!» ");
INSERT INTO daf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","꞊Dhɛ 'ö ꞊wa \"yi bha‑ \"kan ꞊wa zun \"sia‑ Zenezadhe ‑sɛ 'gü, ");
INSERT INTO daf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","'mɛ 'wo \"pɛan bha‑ \"piʋ̈ ‑wo ‑to ‑mü 'wo Yesu dɔ, 'yö 'wo ‑ya ‑a nu ‑wɔn ‑dhɛa \"dhiʋ̈ bho ‑sü ‑bha \"sɛ 'gü ‑dhɛ ꞊gban 'gü 'yö 'wo nu woo‑ \"yuëdhi ‑nu 'ka‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","'Yö 'wo ꞊bhɛa‑ ‑dhɛ kö \"yuëdhi ‑nu bha ‑wo wo ‑kɔ \"fiëfiëdë ‑zë 'pa‑ ‑bha ‑sɔ \"zɔ 'ka (kë \"dhʋ̈ kö ‑wo dha). 'Yö 'mɛ 'wo wo ‑kɔ pa‑ ‑dasɔ \"zɔ 'ka \"dhʋ̈ bha‑ ꞊gban \"pɛpɛ 'wo ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Fadhiziɛn ‑nu waa‑ Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu 'wo go Zedhizadhɛmö 'wo nu Yesu \"piʋ̈, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«‑Më ꞊në ‑kë 'yö 'wluu‑ 'ö kwa \"bhɛma ‑nu ‑wa ‑ya bha, i ‑bha ꞊klang ‑nu 'waa‑ ‑yaki ‑ya? ‑A ‑gɛn ‑mü ꞊dhɛ ꞊waa‑ pö 'wo pë ‑bhö 'waa wo ‑kɔ \"zu ꞊dhɛ ‑kɔ 'kwa‑ ‑kë 'ka kwa wɔ ‑kɔ 'gü ‑a 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Kaa ‑dɩ 'pö ꞊wɛ, ‑më ꞊në ‑kë 'yö 'kaa Atanna ‑bha 'tɔng‑ ‑nu ‑yaki ‑ya ka ‑bha 'wluu‑ ‑nu 'wɔn 'gü? ");
INSERT INTO daf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑ya ‑pö 'ö‑ pö: ‹‑Bhö i dë waa‑ i dhe ‑a ‑nu ꞊bhlëë ‑ya› ꞊ya 'go mü 'zü: ‹'Mɛ 'ö ꞊ya dhiang yaa zë ö 'kpɔmɛ ‑nu ‑bha ‑wa ‑mɛ zë.› ");
INSERT INTO daf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","\"Kɛɛ 'yö ka ‑zë 'ka mɛ ‑nu ꞊draan 'ka‑ pö: ‹'Në ꞊yaa‑ pö ö dë waa‑ ö dhe ‑a ‑nu ‑dhɛ ꞊dhɛ: 'Pë 'ö gun n \"piʋ̈ ꞊dhɛ 'a ka ‑ta 'kun‑ 'ka bha 'ma‑ ‑ya Atanna ‑bha 'ka› kö‑ ‑mɛ ‑ya ‑kë ‑së ꞊naa bha, kö‑ 'kpɔmɛ ‑nu ‑bha tëë 'yaa‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'Sa 'ka‑ kë \"dhʋ̈ kö ka Atanna ‑wʋ 'ma ꞊në 'wo sië ‑zukplü ‑bha kaa‑ 'wluu‑ ‑nu ‑wɔn 'gü bha. ");
INSERT INTO daf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","꞊Flümɛ ‑nu! ꞊Ya kë \"dhʋ̈ kö tɛanwɔn ‑gun Ezai \"piʋ̈ Atanna ‑wʋ 'ö‑ pö ka ‑dhɛ yi 'bha 'ka 'ö‑ pö ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Atanna ‑ya ‑pö: \"Sɛ ya‑ 'gü ‑mɛ ‑nu 'wo ya ‑wo n ‑dhiang zë wo ‑bɛn \"dhiʋ̈ \"wɛɛwɛɛ, n ‑dhɔ 'yaa‑ ‑nu zuë\" ‑zë ‑bha, ");
INSERT INTO daf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","‑a ‑wɔn 'gü n ‑dhɔ 'wo‑ ‑kë bha ‑wa ‑kë \"wɛɛwɛɛ; ‑a ‑gɛn ‑mü ꞊dhɛ ‑wo mɛ ‑nu ‑draan 'wluu‑ ‑nu 'wo go mɛ \"bhɩɩ‑ ‑nu 'gü bha ꞊në‑ 'ka ꞊dhɛ 'pë 'ö go ma ꞊në n 'gü ‑a 'dhö» bha‑ 'gü.›» ");
INSERT INTO daf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","꞊Dhɛ 'ö Yesu ꞊ya ö bo‑ ‑pö ‑nu ‑dhɛ \"dhʋ̈ ‑sü 'ka, 'yö mɛ kpö 'wo gun 'mü bha‑ ‑nu ‑dhɛ 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka ka \"tʋ 'to kö dhiang 'ö maa zë bha 'ka‑ 'gü ma ‑së 'ka!» ");
INSERT INTO daf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","'Yö‑ pö‑ ‑nu ‑dhɛ: «'Pë 'ö ‑da mɛ \"dhi 'gü yö ‑zë 'yaa mɛ kë ‑dhiisü Atanna wëëdhö, \"kɛɛ 'pë 'ö go mɛ \"dhi bha ꞊në mɛ ‑kë ‑dhiisü.» ");
INSERT INTO daf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ 'yö 'wo‑ pö‑ ‑dhɛ: «'Bhaa‑ 'wɔn ꞊në‑ dɔ ꞊dhɛ ‑wʋ ‑nu 'i‑ pö sië bha ‑yö \"yɛ sië Fadhiziɛn ‑nu ‑bha ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Pë \"pɛpɛ 'dhɛ 'kö ‑kë ꞊dhɛ n Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü 'yii‑ ta, ‑a ꞊gban \"pɛpɛ ‑dho bho \"sɛɛ. ");
INSERT INTO daf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","‑Kaa ‑nu 'to \"dhʋ̈. \"Yanwlümɛ ‑nu ꞊në 'wo zian bho sië \"yanwlümɛ ‑nu 'ka bha! \"Kɛɛ \"yanwlümɛ ‑zë ꞊ya zian bho \"yanwlümɛ 'ka, ꞊wa 'dho ‑a ‑naa ‑mü ‑a ‑nu ‑pö ‑gblüga 'gü ‑sü 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","꞊Dhɛ ꞊yaa‑ pö \"dhʋ̈, 'yö Piɛdhö ‑ya pö‑ ‑dhɛ 'ö‑ pö: «‑Bhö \"gwënng 'i‑ ‑da bha‑ ‑ta \"pʋ yi ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'Yö Yesu ‑ya pö: «Kaa ‑dɩ 'pö 'kii 'wɔn 'gü ma ꞊në wo ꞊kö ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","\"Ɛɛn 'kaa‑ 'wɔn ꞊në‑ dɔ ꞊dhɛ pë 'kö mɛ ‑ya ‑bhö bha yö ‑zë ‑yö ‑bɔ mɛ \"gblʋ̈ʋ̈‑ 'ö ‑wo zang ‑ta, ");
INSERT INTO daf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","\"kɛɛ ‑wʋ 'ö go mɛ zuë\" 'gü 'ö bɔ mɛ \"dhi bha ꞊në mɛ ‑kë ‑dhiisü Atanna wëëdhö ‑ee? A‑ ‑pö ka ‑dhɛ ꞊dhɛ mɛ ‑wʋ bha ꞊në mɛ ‑dhii kun Atanna wëëdhö. ");
INSERT INTO daf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ ‑dhɛ 'ö mɛ zuë\" \"piʋ̈ bha ꞊në ‑zʋgɔndhe yaya ‑nu 'wo go‑ 'gü, 'yö 'wo‑ ‑mɛ zü ꞊yɔɔn mɛ zë ‑sü ‑nu oo, ‑da dhe \"piʋ̈ ‑sü \"ɛɛn ‑ziö mɛ ‑nu ‑bha gɔn ꞊keng‑ ‑sü ‑nu oo, ‑zua zë ‑sü ‑nu oo, ꞊kwaan bho ‑sü ‑nu, ꞊sua kë ‑sü ‑nu waa‑ mɛ ‑nu ‑dhiang yaa zë ‑sü ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Pë ‑nu 'wo mɛ ‑dhii kun ꞊në 'wo bha, \"kɛɛ pë ‑bhö ‑sü 'kö kö 'wii wo ‑kɔ \"zu ꞊dhɛ ‑kɔ 'ö kwa \"bhɛma ‑nu ‑wa 'wluu‑ ‑ya 'ka ‑a 'dhö bha yö ‑zë 'yaa mɛ ‑dhii 'kun.» ");
INSERT INTO daf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö go ‑dhɛ bha‑ 'gü 'yö dho Tii ‑pö waa‑ Sidɔn ‑pö ‑nu 'gü waa‑ ‑bha ꞊klang ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","꞊Dhɛ 'ö ꞊wa ꞊loo mü, 'yö dhebhɔnë do 'bha 'ö 'yaa Zuifö 'ka 'ö go Kanaa ‑sɛ 'gü 'ö ‑ya ‑sü 'ka \"sɛ bha‑ 'gü bha 'ö nu \"gbla ‑sü 'ka \"gbʋ 'ka Yesu \"piʋ̈ 'ö‑ pö: «N Dëmɛ, Davi Gbö, ‑bhö \"ta n ‑dhɛ n ‑wëë ‑bha ‑dhe! \"Yina yaa 'ö n 'dhu 'gü ya ‑ya ‑wëë ‑dhɛ wo sië \"gbɩɩ‑ ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","\"Kɛɛ 'yö Yesu 'yii‑ ‑yɔ bɔ, 'yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ 'wo‑ pö‑ ‑dhɛ: «‑Bhö dhebhɔnë ya‑ \"piʋ̈ kë kö ‑yö ziö, ‑a ‑wʋ ꞊ya kë ‑fɛɛsü \"gbla 'ö‑ wo sië 'ö ‑ziö 'ka kwa ꞊keng‑ bha‑ ‑wɔn 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Ka ‑dhɛ ‑ga, Atanna ‑yö n ‑bɔ 'mɛ 'wo ꞊dhɛ \"bhlaa ‑tuʋ̈ ‑nu 'ö ꞊wa ꞊dhɛng ‑a 'dhö Izraɛdhö ‑sɛ ya‑ 'gü bha ꞊në‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","\"Kɛɛ 'yö dhebhɔnë bha 'ö nu 'ö zun ö kpiö 'gü Yesu ꞊wlöö 'ö‑ pö: «N Dëmɛ, ‑bhö \"ta ꞊në wo n ‑dhɛ ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑A ‑dhɛ 'yaa‑ ‑bha kö ‑wo 'në ‑nu ‑bhöpë 'sü ‑wa nu 'gbɛn‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","\"Kɛɛ 'yö dhebhɔnë bha 'ö‑ ‑yɔ bɔ 'pö Yesu ‑gɔ 'ö‑ pö: «‑Yö \"dhʋ̈ tɛan‑ 'ka, n Dëmɛ, \"kɛɛ ‑a ꞊blün 'dhɛ 'kö kɔn 'gbɛn‑ ‑mɛ ‑nu ‑kɔ 'ka 'ö ꞊wɛnng 'gbɛn‑ ‑nu ‑wa yö ‑zë ‑bhö.» ");
INSERT INTO daf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","'Yö Yesu ‑ya pö‑ ‑dhɛ: «'Aa dhebhɔ 'i ya! i 'dhang bho Atanna \"dhiʋ̈ ꞊dedewo ‑kɛɛ! ‑Bhö 'dho, ‑yö ‑dho kë i ‑dhɛ ꞊dhɛ ‑kɔ 'i‑ ꞊mɔɔ‑ 'ka bha‑ 'dhö!» ‑A \"tʋ̈ng ꞊dede bha‑ 'gü, 'yö‑ 'dhu 'dhö ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö go bha 'zü 'yö dho \"yitagbɛa 'ö Gadhidhe ‑dhɛ \"sɔɔ bha‑ \"kpʋng \"dhiʋ̈, 'yö ‑da ‑tɔn do ꞊gbin‑ 'yö ‑ya mü. ");
INSERT INTO daf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","'Yö ‑mɛ 'gbɛ ‑ta ‑gbɛ 'wo nu‑ \"piʋ̈ woo‑ ‑ta 'bebedhö ‑mɛ ‑nu oo, \"yanwlümɛ ‑nu oo, ꞊niɔɔmɛ ‑nu oo, \"bhʋbhʋ ‑nu waa‑ \"yuëdhi 'gbɛ ꞊dede 'ka, 'yö‑ ‑nu ꞊gban \"pɛpɛ dha. ");
INSERT INTO daf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","꞊Dhɛ 'ö 'mɛ 'wo bha ꞊waa‑ ‑dhɛ yö kö \"bhʋbhʋ ‑nu ‑wo \"wɩ sië 'ö ꞊niɔɔmɛ ‑nu 'wo ‑kë \"klʋ̈ʋ̈klʋ̈ 'ö ‑ta 'bebedhö ‑mɛ ‑nu 'wo dɔ ꞊zinng 'gü, 'ö \"yanwlümɛ ‑nu 'wo ‑dhɛ yö, 'yö‑ 'wɔn ‑ya ‑nu kɔn ꞊dedewo, 'yö 'wo ‑ya Izraɛdhö ‑mɛ ‑nu ‑bha Atanna 'tɔ bhɔ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö ö ‑bha ꞊klang ‑nu ‑dhɛ 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka ‑dhɛ ‑ga! 'Mɛ 'wo ya‑ ‑nu ‑wëë ‑yö n kë sië, ‑a ‑gɛn ‑mü ꞊dhɛ 'wo ‑da n ꞊keng‑ ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa ꞊në \"kɛɛ kö ‑bhöpë 'bha 'yaa‑ ‑nu ‑gɔ, \"kɛɛ 'yaa n \"piʋ̈ 'pö ꞊dhɛ 'a ‑wʋ 'kpɔ‑ ‑nu ‑bha kö 'wii pë 'bha ‑bhö, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu faan ‑ya yën, kë \"dhʋ̈ kö \"yiyaadhe 'ya 'dho‑ ‑nu bho 'ö 'wo ‑pö zian‑ kö ‑wo 'dho sië.» ");
INSERT INTO daf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","'Yö‑ ‑bha ꞊klang ‑nu 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Mɛ ‑tu \"tu 'wo ya ‑dhɛ ‑mɛɛ ꞊në 'kwa dho‑ ‑nu ‑bhöpë ꞊slɔɔ‑ ‑bha \"tʋngtadhɛ ya‑ 'gü ꞊zɔɔ?» ");
INSERT INTO daf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","'Yö Yesu ‑ya ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «'Bluu‑ bhɛ ꞊dhɛ ꞊në ka ‑gɔ?» 'Yö 'wo‑ pö‑ ‑dhɛ: «'Bluu‑ bhɛ \"saɔplɛ waa‑ 'yuʋ̈‑ 'nësɛnsɛnnë 'bha ꞊në yi ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","꞊Dhɛ 'wo‑ pö \"dhʋ̈ 'yö‑ pö mɛ kpö bha‑ ‑nu ‑dhɛ ‑wo ‑ya \"sia‑ 'dɔɔɔndhö. ");
INSERT INTO daf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'Yö 'bluu‑ bhɛ \"saɔplɛ waa‑ 'yuʋ̈‑ 'në ‑nu bha‑ ‑nu sü 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü 'yö‑ ‑nu \"kplükplü bho, 'yö‑ nu ö ‑bha ꞊klang ‑nu ‑dhɛ 'yö 'wo‑ 'gü ‑gblü 'mɛ 'wo bha‑ ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","'Yö‑ ‑nu ꞊gban 'wo pë ‑bhö 'wo kën. 'Yö‑ ‑kpɛa ‑yö to, 'yö‑ ‑bha ꞊klang ‑nu 'wo dho 'yö 'wo‑ \"kplükplü ‑nu 'wo to ‑a ‑nu ꞊loo 'ko ‑ta, 'yö kë töö ‑yan \"saɔplɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","'Mɛ 'wo 'bluu‑ ‑bhö \"dhʋ̈ bha‑ gɔɔn‑ ‑nu ‑dɩ ‑slɔɔ ‑kpaa 'kwëë‑ ‑sü kö 'wii dhong ‑nu waa‑ 'në ‑nu ‑a ‑nu dhʋng, 'yö 'wo ‑kë mɛ \"gblü ‑yiisiö. ");
INSERT INTO daf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","꞊Dhɛ 'ö ꞊wa 'wo bo pë ‑bhö ‑sü 'ka \"dhʋ̈, 'yö ö ‑wʋ kpɔ‑ ‑nu ‑bha, 'yö yöö ‑dɩ 'pö 'ö ‑da \"kplagɔnë 'gü 'yö dho Magadan ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yi do 'ka 'yö Fadhiziɛn ‑nu waa‑ Sadusiɛn ‑nu 'wo nu Yesu \"piʋ̈ ‑a 'gü dan ‑dhɛ 'gü, 'yö 'wo‑ pö‑ ‑dhɛ ꞊dhɛ ‑yö \"dhabhliwɔn do kë wo \"yaan kö ‑ya ‑zɔn wo ‑dhɛ ꞊dhɛ Atanna ꞊në‑ bɔ ꞊dedewo tɛan‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'yënng‑ ‑gɔ ꞊ya bhɔ ‑pö ‑dhɛ ‑bha kö dhang‑ ‑bha ‑dhɛ ‑yö ‑gblö ‑sü 'ka 'kaa‑ pö ꞊dhɛ ‑dhɛ ‑dho ꞊kpaɔ ‑së 'ka dhia\" ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","\"Ɛɛn 'zü ‑dhɛ ꞊ya ꞊kpaɔ kö dhang‑ ‑bha ‑dhɛ ‑yö 'gbiin‑, 'kaa‑ pö dha‑ ‑dho ban ꞊dɛɛ ‑ee? 'Wɔn ‑nu 'kö 'wo bha ka ‑kɔ ‑mɔɔ wo ‑zë ‑a ‑nu 'suan‑ bho ‑sü ‑bha dhang‑ 'gü ꞊dhɛ ‑kɔ bha‑ 'dhö, \"kɛɛ 'wɔn 'suan‑ ‑bho ‑bha ‑wɔn ‑nu 'kö 'wo kë sië ꞊dɛɛ ‑yën ya‑ 'gü ya 'kaa ꞊mɔɔ yö ‑zë 'suan‑ bho ‑sü ‑bha ‑oo? ");
INSERT INTO daf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Suu yaa ‑mɛ ‑nu 'wo ꞊dɛɛ ‑yën ya‑ 'gü 'ö 'waa 'to wo ‑wʋ ‑ta Atanna ‑dhɛ bha ‑ya ‑nu \"piʋ̈ ꞊dhɛ 'wo \"dhabhliwɔn ‑dhɛ yö, \"kɛɛ 'wii 'dho \"dhabhliwɔn \"wɛɛ 'bha ‑dhɛ yö kö 'yii kë‑ suu 'ö ‑kë Zonasö 'ka yi 'bha 'ka bha‑ 'ka.» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑nu to 'mü 'ö ‑ziö. ");
INSERT INTO daf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu waa‑ ö ‑bha ꞊klang ‑nu 'dho ‑sü 'ka kö ‑wo \"yi \"kan ‑wo 'dho \"yi ꞊taama, ‑a ‑bha ꞊klang ‑nu ‑zʋ ‑yö ‑bhɔ 'bluu‑ 'sü ‑wɔn 'ka. ꞊Dhɛ 'ö ꞊wa \"yi \"kan ꞊wa bɔ \"yi ꞊taama, ");
INSERT INTO daf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Ka ka ‑dɩ 'kun \"sɛkɛ 'ö Fadhiziɛn ‑nu waa‑ Sadusiɛn ‑nu ‑gɔ bha‑ ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Yö‑ ‑bha ꞊klang ‑nu 'wo ‑ya zaɔkpadhe ‑da ‑sü ‑bha ꞊dhɛ: «‑Yö kë 'ö‑ wo ꞊dhɛ 'kwii 'bluu‑ 'sü bha 'yö ‑kë 'yö‑ pö sië \"dhʋ̈ bha.» ");
INSERT INTO daf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","꞊Dhɛ 'ö Yesu ꞊yaa‑ 'wɔn dɔ ꞊dhɛ ‑wo zaɔdhe ‑da sië wo \"kwëë 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Më ꞊në ‑kë 'yö 'ka ‑ya 'bluu‑ 'sü ‑sü zuën ‑ta? Ka ‑bha 'dhang ‑bho n \"dhiʋ̈ ‑sü ‑yö 'dɛdɛ ‑kɛɛ! ");
INSERT INTO daf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","\"Ɛɛn 'wɔn 'gü ꞊dede ꞊në 'kii ma ꞊kö \"dhʋ̈ bha ‑ee? \"Ɛɛn ka ‑zʋ ꞊në ꞊ya 'to ꞊ya bhɔ 'bluu‑ bhɛ \"sɔɔdhu 'a‑ 'gü ‑gblü mɛ \"gblü \"sɔɔdhu ‑ta 'ö‑ töö ‑yan ‑kpɛa ‑yö to bha‑ ‑wɔn 'ka \"dhʋ̈ bha ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","\"Ɛɛn 'zü 'bluu‑ bhɛ \"saɔplɛ 'a‑ 'gü ‑gblü mɛ \"gblü ‑yiisiö ‑ta 'ö‑ töö ‑yan ‑kpɛa ‑yö to bha ka ‑zʋ ꞊në ꞊ya 'to ꞊ya bhɔ‑ ‑wɔn 'ka \"dhʋ̈ bha ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","\"Ɛɛn ‑yö kë ‑kɔ ‑kë ꞊dhɛ 'yö 'ka ka ‑zʋ gɔn ꞊dhɛ a ‑wɩ 'bluu‑ ꞊dede ꞊në‑ 'ka? A‑ ‑pö ka ‑dhɛ ꞊dhɛ 'ka ka ‑dɩ 'kun Fadhiziɛn ‑nu waa‑ Sadusiɛn ‑nu ‑bha ꞊gɔng bha‑ ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'wo‑ 'wɔn dɔ ꞊dhɛ 'yii \"wɩ \"sɛkɛ ꞊dede 'wo‑ ‑da 'bluu‑ ‑bha bha‑ 'ka, \"kɛɛ ‑yö ‑wɩ Fadhiziɛn ‑nu waa‑ Sadusiɛn ‑nu ‑bha mɛ draan‑ ‑kɔ ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","꞊Dhɛ 'ö Yesu ꞊ya 'dho ꞊ya ꞊loo \"sɛgɔ 'ö Fidhipö ‑bha Sezadhe ‑dhɛ ‑züzü bha‑ 'gü, 'yö ö ‑bha ꞊klang ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «Ka‑ ‑ma mɛ ‑nu ‑ta ꞊dhɛ de suu ꞊në mang Mɛgbömɛ n 'ka?» ");
INSERT INTO daf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Mɛ 'bha ‑nu ‑wa ‑pö i ‑bha ꞊dhɛ Zan Mɛzumɛ ‑mü i 'ka, 'ö mɛ 'bha ‑nu ‑wa pö (Atanna ‑wʋdhiʋ̈loomɛ) Edhi 'ö gun yi 'bha 'ka bha yö ‑mü i 'ka, 'ö mɛ 'bha ‑nu ‑dɩ 'pö 'wo‑ pö ‑a mɛ 'dhɛ 'wo‑ Zedhemi ‑kë bha yö ‑mü i 'ka, kö mɛ 'bha ‑nu ‑wa pö sië 'zü Atanna ‑wʋdhiʋ̈loomɛ \"wɛɛ 'bha ‑mü i 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «'Yö ka ‑zë ꞊wɛ, ka ka ‑bha ‑pö ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","'Yö Simɔ Piɛdhö ‑ya pö‑ ‑dhɛ 'ö‑ pö: Atanna ‑bha ‑Yamɛ 'ö‑ bɔ yö ‑mü i 'ka! Atanna \"yaandhe Gbö ‑mü i 'ka!» ");
INSERT INTO daf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Yesu ‑ya pö‑ ‑dhɛ: «Simɔ, Zan gbö, i ‑bha ‑së! ‑A ‑gɛn ‑mü ꞊dhɛ tɛanwɔn 'dhɛ 'kö 'i‑ pö bha 'yii 'go mɛbhɩɩdhe 'gü, n Dë Atanna 'ö ‑ya ‑sü 'ka dhang‑ 'gü bha ꞊në‑ ‑zɔn i ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü mang ‑dɩ 'pö a‑ ‑pö i ‑dhɛ ꞊dhɛ ‑wo i ‑dhɛ Piɛdhö (꞊waa‑ pö \"dhʋ̈ kö ‑wa ‑pö ‑gwë). ‑Gwë 'i‑ suu 'ka bha, bhi ꞊në 'i dho kë ꞊dhɛ ‑gwë 'wo 'kɔ \"kpan ‑ya ‑ta bha n ‑bha 'dhö, (bhi ꞊në 'i dho Atanna ‑bha mɛ ‑nu ‑loo 'ko ‑ta ‑sü bha‑ zü bho), 'mɛ 'wo \"dhʋ̈ bha ga ‑kɔ 'yii 'dho ꞊mɔɔ‑ ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A ‑dho Atanna ‑bha ‑gblüdëdhɛ ‑dhaklɩ nu i ‑dhɛ, kö 'bha‑ \"dhiʋ̈ ta mɛ \"ʋʋ 'mɛ 'ö‑ ‑gɔ \"kpʋng ꞊taa yö kö ‑yö kë ta ‑sü 'ka‑ ‑mɛ ‑gɔ dhang‑ 'gü, \"ɛɛn kö 'bha‑ \"pʋ 'pö mɛ \"ʋʋ 'mɛ 'ö‑ ‑gɔ \"kpʋng ꞊taa yö kö ‑yö kë \"pʋ ‑sü 'ka‑ ‑mɛ ‑gɔ dhang‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö ‑dhio dɔ‑ ‑nu ‑ta glɔɔglɔdhö ꞊dhɛ 'wa 'dho‑ pö mɛ 'bha ‑dhɛ ꞊dhɛ Atanna ‑bha ‑Yamɛ 'ö‑ bɔ yö ‑mü ö 'ka. ");
INSERT INTO daf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","꞊Dhɛ 'ö ꞊yaa‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈, 'ö sü‑ 'yi bha ‑bha 'ö dho‑ 'ka \"dhiʋ̈, 'yö zun ö ‑dɩ ‑wɔn ‑ta \"pʋ ‑sü ‑bha ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «N ‑dho Zedhizadhɛmö ‑wɔn ‑yö ‑dhö kö ‑kwɛagbö ‑nu waa‑ \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu ‑wo n ‑wëëdhɛ ꞊dede bho. ‑Wo ‑dho n zë 'ö 'a‑ bo ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Piɛdhö ‑ya sü ꞊plɛ 'gü, 'yö ‑ya ‑dɔn ‑bho 'ka ‑sü ‑bha. 'Ö‑ pö: «'Aa n Dëmɛ, ‑më ‑dhiang ꞊në 'i‑ zë \"dhʋ̈, ‑a 'dhɛ 'kö bha Atanna ‑ya dɔ i 'ka ꞊gblɛɛn.» ");
INSERT INTO daf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","\"Kɛɛ 'yö Yesu ‑yö ꞊slëë ö 'gü, 'ö‑ pö Piɛdhö ‑dhɛ: «‑Bhö bhɔ n 'ka taa‑ ꞊gblɛɛn, Sɔtraan! ‑Yö i \"piʋ̈ ꞊dhɛ 'i n ‑da Atanna \"dhiʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ kɛng ka ‑zʋgɔngüwɔn 'yaa do, i i ‑zʋ ‑gɔn ꞊dhɛ mɛ \"bhɩɩ‑ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «'Ö mɛ \"ʋʋ mɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ö ziö n ꞊keng‑, ‑a ‑mɛ ‑yö bo ‑ya ö ‑dɩ ‑wɔn zuën ‑ta ‑sü 'ka kö ‑yö sëëbhodhe 'ö n ‑wɔn \"glʋʋ \"piʋ̈ 'ö ꞊dhɛ ‑a ‑mɛ ‑dɔ ‑bha \"dhü 'dhö bha‑ 'sü kö ‑yö ziö‑ 'ka n ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö‑ \"piʋ̈ 'ö ö ‑dɩ dha ‑a ‑mɛ ‑gɔ ‑dho 'to‑ 'gü, \"kɛɛ 'mɛ 'ö‑ ‑gɔ ‑yö to n ‑wɔn ‑bha, ‑a mɛ ‑dho dha. ");
INSERT INTO daf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","\"Ɛɛn ꞊ya kë ꞊dhɛ mɛ 'bha \"kpʋngtaapë ꞊gban \"pɛpɛ suu ꞊slɔɔ \"kɛɛ kö i 'nii‑ ‑zë ‑yö ꞊dhɛng Atanna \"piʋ̈ bha ‑oo, kö‑ ꞊trɔɔn ‑mü ‑më 'ka? \"Ɛɛn ‑më ꞊në mɛ‑ dho ꞊mɔɔ‑ ‑bha kö ‑ya nu Atanna ‑dhɛ ö 'nii‑ ‑gɔtadhɔpë 'ka. ");
INSERT INTO daf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","‑Ka ‑dhɛ ‑ga, mang Mɛgbömɛ ‑a ‑dho nu n Dë ‑bha 'tɔbhɔdhe bha‑ 'gü yaa‑ ma \"kië ‑nu ‑dhö, 'yö 'a 'mɛ 'dhɛ \"dhʋ̈ ‑a ꞊saa bho ‑a ‑tosɛa kë ‑kɔ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'wo ‑dhɛ ya‑ 'gü ‑a mɛ 'gbɛ 'wii 'dho ga kö 'wii mang Mɛgbömɛ ma ‑gblüdëdhɛ nu ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","꞊Dhɛ 'ö ‑dhɛkpaɔyi \"saɔdo ꞊ya ziö, 'yö Yesu ‑yö Piɛdhö 'dhö, Zakö waa‑ Zan 'ö ‑kë Zakö dheebhang 'ka bha‑ ‑nu ‑dhɛ 'yö 'wo dho ‑tɔn ꞊gblɛɛn do ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","'Yö‑ ‑gla ‑a ‑nu \"yaan mü, 'yö‑ wëëdhɛ 'gü 'dhö ‑ya 'bhü ‑sü ‑bha ꞊dhɛ 'yënng‑ 'dhö, 'yö‑ ‑bha ‑sɔ 'bhü 'dhö ‑ya bhɔ ‑sü ‑bha 'yö ‑dhɛ ‑pʋ ‑a ‑zü. ");
INSERT INTO daf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","'Yö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ‑yaaga bha 'wo wo \"yan ‑kpan Moizö waa‑ Edhi ‑a ‑nu ‑bha (kö ꞊wa 'go dhang‑ 'gü ꞊wa nu) kö waa‑ Yesu ‑nu ‑wo dhiang zë sië wo 'ko ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","'Yö Piɛdhö ‑ya pö Yesu ‑dhɛ 'ö‑ pö: «N Dëmɛ, 'kwa ‑ya yö ‑yö ‑dho kë ‑së \"dhɛ! ‑Bhö dɔ 'sa kö 'a sɔ 'kɔ 'në ‑nu ‑yaaga dɔ 'yö kö‑ do‑ kë i ‑bha 'ka, kö‑ do‑ kë Moizö ‑bha 'ka, kö‑ do 'dhɛ 'ö to ‑yö kë Edhi ‑bha 'ka ‑dhe! ");
INSERT INTO daf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piɛdhö ‑yö ‑to dhiang bha‑ zë ‑dhɛ 'gü, 'yö \"dhuu kpö \"yan bhɔ ‑sü 'bha ‑yö nu 'yö sɔ‑ ‑nu ‑ta, 'yö ‑wʋ do ‑yö bɔ \"dhuu kpö bha‑ 'gü 'ö‑ pö: «N Gbö (do 'ö n ‑gɔ) 'yö ya ‑a ‑dhɔ ‑yö n ‑kë ꞊dedewo, 'a n ‑gɔ ‑wɔn \"pɛpɛ ꞊gban ꞊loo ‑sü 'ka yö ꞊në‑ ꞊kwɛɛ‑. ꞊Ya 'pë 'ö‑ pö ka ‑dhɛ ‑kaa kë.» ");
INSERT INTO daf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","꞊Dhɛ 'wo ‑wʋ bha‑ ma, 'yö \"suʋ̈ 'dhö ‑da ‑nu 'gü 'yö 'wo zun wo kpiö 'gü 'yö 'wo wo ‑gɔ \"gblëënu Yesu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","'Yö Yesu ‑yö ꞊yɔɔn‑ ‑nu \"sɔɔ, 'yö ö ‑kɔ ‑yɛ ‑a ‑nu ‑bha 'ö‑ pö: «‑Ka \"wlü, \"suʋ̈ 'ya 'dho ka kë!» ");
INSERT INTO daf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","'Wo dho wo \"yan \"dhiʋ̈ \"wlü kö Yesu yöö do ꞊në ꞊ya 'to mü. ");
INSERT INTO daf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","꞊Dhɛ 'ö ꞊wa zun ‑tɔn lɔɔ‑ ‑sü ‑bha, 'yö Yesu ‑yö ‑dhio dɔ‑ ‑nu ‑ta glɔglɔdhö 'ö‑ pö: «'Wɔn ka \"yan 'dhö ‑da 'gü bha, 'ma 'dho‑ ma ka \"dhi tongtongdhö kö ka‑ ‑gɛn dɔ sië mɛ 'bha ‑dhɛ \"dhɛ! ‑Yö 'to ka zuë\" \"piʋ̈ ‑yö 'to‑ ka \"dhʋ̈ ‑yö zun‑ 'ka mang Mɛgbömɛ n ‑bö ‑yi ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑bha ꞊klang ‑nu 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «\"Kɛɛ ‑a pö 'ö kwa ‑bha 'tɔnggɔmɛ ‑nu ‑wa wo 'sa ꞊dhɛ Edhi ‑dho nu ꞊kö ‑blɛɛsü, 'yö Atanna ‑bha ‑Yamɛ ‑yö gun ‑na nu ya‑ ‑gɛn ‑mü ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A pö 'wo‑ wo \"dhʋ̈ bha tɛan‑ ‑mü, ‑a ‑gɛn ‑mü ꞊dhɛ Edhi ‑dho nu kö ‑yö Atanna ‑wɔn ꞊gban ‑ya ‑yɛa 'gü ‑deewo (\"pɛpɛdhö, 'yö ‑a ‑bha ‑Yamɛ gun ‑na nu). ");
INSERT INTO daf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","\"Kɛɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ Edhi ꞊ya nu 'nu, \"kɛɛ 'wii wo \"tʋ këwɔn ‑bha 'wɔn 'ö ‑dhi ‑nu ‑dhɛ ꞊në 'wo‑ ‑wɔ ‑ta. ‑Kɔ do 'wo Edhi ‑wëëdhɛ bho‑ 'ka bha ꞊në 'wo dho mang Mɛgbömɛ n ‑wëëdhɛ bho‑ 'ka 'pö. ");
INSERT INTO daf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö‑ 'wɔn to 'ö ‑da ‑bha ꞊klang ‑nu \"yaan ꞊dhɛ ‑yö \"wɩ sië Zan Mɛzumɛ ꞊në‑ 'ka bha. ");
INSERT INTO daf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","꞊Dhɛ 'ö ꞊wa nu ꞊wa ꞊loo ‑dhɛ 'wo mɛ \"dhaa to‑ ‑bha bha‑ 'gü, 'yö gɔndë do 'bha bha 'ö ꞊yɔɔn Yesu \"sɔɔ, 'yö zun ö kpiö 'gü‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","'Yö‑ pö: «N Dëmɛ, ‑bhö n gbö ya‑ ‑wëë ‑ga ‑dhe. Glɔɔ \"dhɛ ‑yua 'ö‑ 'gü ya ‑ya ‑wëë ‑kë wo sië \"gbɩɩ‑ ‑wa. (‑A \"su yaa ꞊ya bhɔ,) ‑ya ‑pö pɛng \"dhiʋ̈ ‑dhɛ ‑nu waa‑ \"yi ꞊bhaa ‑dhɛ ‑nu 'gü \"kwëë klö klö ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A kë ‑nu 'nu‑ 'ka i ‑bha ꞊klang ‑nu ꞊në‑ ‑nu ‑dhɛ kö ‑wa dha n ‑dhɛ, \"kɛɛ 'wii ꞊mɔɔ‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","꞊Dhɛ 'ö 'mɛ bha ꞊ya bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «Gɔɔgbɩɩmɛ ‑nu, suuyaamɛ ‑nu 'ka ya! ‑Dhɛkpaɔyi ꞊dhɛ ꞊në 'a dho 'sü 'zü ‑deewo kö 'a‑ kë ka \"piʋ̈? \"Ɛɛn a ‑dho ka ‑kwɛɛ bun 'zü ‑dhɛkpaɔyi ꞊dhɛ ꞊në 'ka ‑deewo kö 'ka gun ‑na 'wɔn 'gü ma kö 'ka 'dhang bho n \"dhiʋ̈? 'Yö‑ pö ‑ka nu n ‑dhɛ 'në bha‑ 'ka!» ");
INSERT INTO daf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","꞊Dhɛ 'wo nu‑ 'ka, 'yö ꞊gbla \"yina yaa 'ö gun‑ bha‑ 'gü bha‑ ‑ta. ‑Yö ‑to ‑dhɛ do bha‑ 'gü 'ö go‑ 'gü 'yö ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö‑ ‑bha ꞊klang ‑nu bha 'wo‑ ‑dhɛ ‑dɩ ‑wɔn \"dhiʋ̈ 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi ‑kɔ 'ö 'yii ꞊mɔɔ \"yina yaa 'dhɛ ya‑ ‑bha bha‑ ‑gɛn ‑mü ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A ‑gɛn ‑mü ꞊dhɛ 'kaa 'dhang ꞊në‑ bho Atanna \"dhiʋ̈. A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ꞊Ya kë ꞊dhɛ ka ‑bha ‑zʋ ‑yö Atanna ‑dhɛ ‑sü ꞊blünga ꞊ya kë ꞊dhɛ kplɔɔ\" ga ‑zian ꞊në‑ 'dhö, ka ‑dho ꞊mɔɔ‑ ‑bha 'ka‑ pö ‑tɔn ‑dhɛ: ‹‑Bhö 'go i \"gblʋʋ bha‑ 'gü 'i 'dho ‑dhɛ ya‑ 'gü!› 'ö ‑kë ꞊dhɛ ‑kɔ bha‑ 'dhö. Ka ‑fiëbhawɔn 'yii dho kë.» ");
INSERT INTO daf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","\"Kɛɛ \"yina yaa suu 'dhɛ 'kö bha‑ ‑kë mɛ 'gü ‑sü ‑faan ‑yö ‑slɔɔ ‑bhɛa Atanna ‑dhɛ ‑sü waa‑ 'sunng‑ 'ma ‑sü ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","꞊Dhɛ 'ö yi do 'ka kö waa‑ ‑bha ꞊klang \"dhiʋ̈ ‑nu ꞊gban \"pɛpɛ ‑wo ‑dhɛ do 'gü Gadhidhe ‑sɛ 'gü, 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'zü 'ö‑ pö: «‑Wo ‑dho mang Mɛgbömɛ n \"dhiʋ̈ dɔ mɛ \"bhɩɩ‑ ‑nu ‑dhɛ ");
INSERT INTO daf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","'ö 'wo n zë. \"Kɛɛ ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa bha, a ‑dho ‑bö 'ka.» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ‑wëë ‑yö bɔ‑ ‑bha ꞊klang ‑nu bha‑ ‑nu ‑ta ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","꞊Dhɛ 'ö Yesu waa‑ ö ‑bha ꞊klang ‑nu ꞊wa 'dho ꞊wa ꞊loo Kapɛɛnaɔmö ‑pö 'gü, 'yö Atanna ‑dhɔkëgükɔ 'niisɔngkunmɛ ‑nu 'wo ꞊yɔɔn Piɛdhö \"sɔɔ 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Ka ‑gɔmɛ ‑yö Atanna ‑dhɔkëgükɔ 'nii‑ sɔng ‑bho \"wɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","'Yö Piɛdhö ‑ya pö: «꞊Iin, ‑ya ‑bho.» ꞊Dhɛ 'ö Piɛdhö ꞊yaa‑ pö \"dhʋ̈, 'ö ‑da sië 'kɔɔdhö, Yesu ꞊në dhiang zë‑ ‑dhɛ ‑blɛblɛsü 'ö‑ pö: «Simɔ, 'nii‑ sɔng bho ‑sü ‑nu waa‑ pë bho ‑sü ‑nu 'ö \"kpʋng ꞊taa ‑gblüdë ‑nu ‑dhɛ bha i i ‑bha ‑pö 'gü ꞊dhɛ? ‑A ‑dhɛa ‑bha kö de ‑nu ꞊në ‑wa bho, ‑a ‑nu gbö ‑nu ‑ee, \"ɛɛn mɛ \"wɛɛ ‑nu ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","'Yö Piɛdhö ‑ya pö: «‑A ‑dhɛ 'yaa‑ ‑bha kö ‑gblüdë gbö ‑nu ‑zë ‑wa bho.» 'Yö Yesu ‑ya ‑yɔ bɔ Piɛdhö ‑gɔ 'ö‑ pö: «‑Yö \"dhʋ̈ tɛan‑ 'ka, ‑a ‑dhɛ 'yaa‑ ‑bha kö ‑gblüdë gbö ‑nu ‑zë ‑wa bho (꞊ya kë \"dhʋ̈ kö‑ ‑dhɛ 'yaa‑ ‑bha ꞊dhɛ 'a‑ ‑bho 'pö).» ");
INSERT INTO daf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","\"Kɛɛ yö ꞊në‑ ꞊gban 'gü, 'kwa 'dho 'mɛ 'wo ya‑ ‑nu ‑siödhɛwɔn kë, ꞊dhɛ 'ö \"dhʋ̈, ‑bhö 'dho \"yi \"kpʋng \"dhiʋ̈ kö 'i piʋ̈\" ‑da, 'yuʋ̈‑ ‑blɛɛsü 'ö bhaa‑ ‑sü bha 'i‑ \"dhi \"pʋ kö 'i ‑dhɛ ‑ga ‑a \"dhiëng 'gü, i ‑dho \"tanmaga do 'ö ꞊mɔɔ kwɛng koo‑ 'nii‑ sɔng ‑bha ‑a yö 'mü kö 'i‑ 'sü 'i nu‑ 'ka kö 'i koo 'nii‑ sɔng bho‑ 'ka ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yesu ‑bha ꞊klang ‑nu ‑wo ‑yɔɔn \"sɔɔ ‑a \"tʋ̈ng ꞊dede bha ꞊në‑ 'gü 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «'Mɛ 'yi i ꞊keng‑ ya de ꞊në ‑duɛ 'dhö 'kpii‑ Atanna ‑bha ‑gblüdëdhɛkëdhɛ 'ö dhang‑ 'gü bha‑ 'gü, yi Dëmɛ?» ");
INSERT INTO daf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","꞊Dhɛ 'ö ꞊waa‑ dhɛɛ\" bha‑ 'kpɔ \"dhʋ̈, 'yö Yesu ‑yö 'në 'në 'dɛdɛ 'në do ‑dhɛ, 'yö‑ dɔ‑ ‑nu wëëdhö 'yö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«‑Ka ‑dhɛ ‑ga, a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ kö 'kii ka zuë\" slëë‑ kö 'ka \"wɩ 'wɔn ‑bha ꞊dhɛ 'në 'sɛnsɛn 'në ‑nu 'dhö 'kii 'dho ka ‑duɛ ‑zian ꞊slɔɔ Atanna ‑bha ‑gblüdëdhɛpö 'ö dhang‑ 'gü bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö‑ ‑duɛ 'dhö 'kpii‑ Atanna ‑bha ‑gblüdëdhɛ bha‑ 'gü, yö ‑mü 'mɛ 'ö‑ \"tʋ 'yaa kë ö ‑dɩ ‑wɔn ‑bha ꞊dhɛ 'në 'ö ya‑ 'dhö bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Mɛ 'ö dho 'në ‑nu 'ö‑ ‑nu suu 'dhö ya‑ ‑nu ‑dhɛng bun n ‑wɔn 'gü, kö ‑yö ma ꞊në n ‑dhɛng bun bha.» ");
INSERT INTO daf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","'Yö‑ pö: «Mɛ \"ʋʋ 'mɛ 'ö dho kë 'në ‑nu 'wo 'dhang bho n \"dhiʋ̈ \"dhʋ̈ bha‑ mɛ do ‑zian ‑pö 'wɔn yaa 'gü ‑mɛ 'ka, ‑a fië‑ ‑to kö ‑wo ‑gwë kpö 'gbiin‑ do dun‑ ‑mɛ bhɔ ‑bha kö ꞊wa ‑zuö 'ka ꞊weeyi ꞊bhaa kö ‑ya zë ('wɔn 'ö Atanna dho‑ wɔ‑ ‑ta bha‑ ‑bha). ");
INSERT INTO daf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","\"Kpʋngtaamɛ ‑nu ‑bha ‑yö ‑wëësü, ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn ‑nu 'wo dho mɛ ‑nu ‑da 'wɔn yaa kë ‑sü 'gü \"dhʋ̈ bha ‑wo ‑dhö. ‑A ‑wɔn 'gü ‑wo ‑dho 'to kë ‑sü ‑bha ‑kpɛawo, \"kɛɛ 'mɛ 'kö dho kë ‑a kë ‑mɛ 'ka bha ꞊në‑ ‑mɛ ‑bha 'dhö ‑wëësü! ");
INSERT INTO daf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","꞊Ya kë ꞊dhɛ i ‑kɔ waa‑ i ‑gɛn ꞊wa kë i ‑da 'wɔn yaa 'gü ‑pë 'ka, ‑bhö ‑a ‑nu \"kan i ‑bha kö 'i‑ ‑nu ‑zuö ‑dhɛ ꞊gblɛɛn 'gü (\"tʋ̈ng 'ö 'bhii‑ kë ꞊kö bha‑ 'ka). ‑A ‑gɛn ‑mü ꞊dhɛ ‑da i ‑kɔ waa‑ i ‑gɛn \"kplü 'ka ‑sü 'ö Atanna ‑bha ‑gblüdëdhɛkëdhɛ 'gü, ‑a fië‑ ‑dhö i ‑kɔ waa‑ i ‑gɛn ꞊gban ‑to i ‑bha ‑sü 'ö 'wo i ‑zuö 'ka pɛng 'ö 'yaa \"dhuu ‑a 'gü ‑sü ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","꞊Ya kë ꞊dhɛ i \"yanga do ꞊ya kë i ‑da 'wɔn yaa 'gü ‑pë 'ka, ‑bhö ‑a bho 'mü kö 'i‑ ‑zuö ‑dhɛ ꞊gblɛɛn 'gü (\"tʋ̈ng 'ö 'bhii‑ kë ꞊kö bha‑ 'ka), ‑a ‑gɛn ‑mü ꞊dhɛ i ‑da Atanna ‑bha ‑gblüdëdhɛkëdhɛ 'gü ‑sü 'ö i \"yanga do 'ka, ‑a fië‑ ‑dhö 'ö ‑ziö 'ka i \"yanga ꞊gban ꞊plɛ ‑to mü ‑sü 'ö 'wo i ‑zuö 'ka pɛng 'ö 'yaa \"dhuu ‑a 'gü ‑sü ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","'Yö go mü 'ö‑ pö: «‑Ka ka ‑dɩ 'kun 'në ‑nu 'wo ya‑ mɛ do ‑zian ‑zë \"dhiisü ‑bha! ‑A ‑gɛn ‑mü ꞊dhɛ 'a‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Atanna ‑bha \"kië ‑nu 'wo dhang‑ 'gü ꞊në 'wo \"yan ‑to ‑nu ‑bha ‑mɛ ‑nu 'ka, 'yö 'wo dɔ ‑sü 'ka n Dë 'ö dhang‑ 'gü ‑a wëëdhö \"tʋ̈ng ꞊gban 'gü (kö ‑wa ‑nu ‑bha za dɔ). ");
INSERT INTO daf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","‑A ‑gɛn ‑mü ꞊dhɛ mang Mɛgbömɛ a ‑nu 'mɛ 'wo ꞊dhɛng ‑sü 'ka ꞊në‑ ‑nu dha ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","\"Ɛɛn ꞊ya kë ꞊dhɛ \"bhlaa këng do ꞊ya kë mɛ do ‑gɔ kö ‑a do ‑yö ꞊dhɛng, 'yii 'dho‑ ‑kaɔng \"sueisiö ga \"sueisiö ‑kpɛa 'ö to‑ 'to ‑tɔn ꞊gbin‑ 'ö dho ‑a 'dhɛ 'ö ꞊dhɛng bha‑ mɔɔ‑ ‑dhɛ 'gü ‑ee? \"Ɛɛn 'yaa \"dhʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ꞊Yaa‑ yö, ‑a zuë\" ꞊nii ‑yö ‑da \"bhlaa doseng bha‑ yö ‑wɔn 'gü, 'ö ‑ziö 'ka ‑a ‑kaɔng \"sueisiö ga \"sueisiö 'ö 'wii ꞊dhɛng bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ka Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bha, 'yaa‑ \"piʋ̈ ꞊dhɛ 'mɛ 'wo (bɔ ö 'ka 'wo) ꞊dhɛ 'në ‑nu ya 'dhö bha‑ mɛ doseng ‑zian ‑yö ꞊dhɛng ‑kɔ do bha ꞊në‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","'Yö go mü 'zü 'ö‑ pö: ꞊Ya kë ꞊dhɛ i dheebhang ꞊ya 'wɔn yaa kë, ‑bhö 'dho‑ \"piʋ̈ kö 'pë 'ö‑ ‑kë 'ö 'ya‑ bha 'i‑ ‑zɔn ‑dhɛ, \"kɛɛ 'ka kë 'mü ꞊plɛ. ꞊Ya kë ꞊dhɛ ꞊ya \"wɩ i ‑wʋ ‑bha kö 'bha‑ dha ꞊naa bha. ");
INSERT INTO daf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","꞊Ya kë 'zü ꞊dhɛ 'yii \"wɩ i ‑wʋ ‑bha, ‑bhö 'dho 'i mɛ do \"ɛɛn mɛ ꞊plɛ ‑dhɛ kö ‑wo ꞊nëng i ‑bha kö 'ka 'dho mü. Kë \"dhʋ̈ kö pë \"ʋʋ pë 'ö 'ka dho‑ pö 'mü bha kö 'ka‑ pö mɛ ꞊plɛ \"ɛɛn mɛ ‑yaaga \"yaan kö ‑wo kë ka \"sɛɛ‑ 'ka ꞊dhɛ ‑kɔ 'ö Atanna ‑wʋ ‑ya pö‑ 'ka‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","꞊Ya kë 'zü ꞊dhɛ 'yii \"wɩ mɛ ‑yaaga bha ka ‑wʋ ‑bha, ‑bhö Atanna ‑bha mɛ ‑nu ꞊loo 'ko ‑ta kö 'i‑ ‑da ‑nu ‑dhɛ. ꞊Ya kë ꞊dhɛ 'yii ö \"tʋ 'to mɛ 'wo bha‑ ‑nu ‑wʋ ‑bha tongtongdhö, ‑bhö ‑a ‑ga ꞊taamasü 'gü ꞊dhɛ 'mɛ 'yaa Atanna dɔ ꞊në‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Mɛ \"ʋʋ mɛ 'ö ka dho‑ 'tɔng‑ ‑ya ‑ta Atanna ‑bha zian ‑ta \"kpʋng ꞊taa yö, 'tɔng‑ ‑dho kë‑ ‑mɛ ‑ta dhang‑ 'gü. \"Ɛɛn mɛ \"ʋʋ mɛ 'ka dho‑ ‑mawɔn 'to \"kpʋng ꞊taa yö, Atanna ‑dho ‑a ‑mɛ ‑mawɔn 'to dhang‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A‑ ‑pö ka ‑dhɛ 'pö ꞊dhɛ: Kö mɛ ꞊plɛ ‑wʋ ‑yö kë 'wɔn 'gü do ka kpö 'gü \"kpʋng ꞊taa yö, kö ‑wo bhɛa\" n Dë Atanna ‑dhɛ pë \"ʋʋ pë 'kö‑ ‑wɔn 'gü, yö 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bha, ‑yö ‑dho ‑a nu‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","‑A ‑gɛn ‑mü ꞊dhɛ ‑dhɛ 'ö mɛ ꞊plɛ \"ɛɛn mɛ ‑yaaga 'wo ‑ya ‑sü 'ka wo kpö 'ka‑ ‑bha n 'tɔ 'gü, kö a‑ ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö Piɛdhö ‑yö ꞊yɔɔn‑ \"sɔɔ 'ö‑ dhɛɛ\" kpɔ 'ö‑ pö: «N Dëmɛ, n dheebhang 'ö 'wɔn yaa ‑kë n 'ka ‑kpɛawo, a ‑dho ‑a ‑bha 'wɔn yaa ‑mawɔn 'to ‑gɛn ‑yan 'ka ꞊dhɛ? \"Ɛɛn 'a‑ kë \"dhʋ̈ ‑gɛn ‑yan 'ka \"saɔplɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","'Yö Yesu ‑ya pö‑ ‑dhɛ 'ö‑ pö: «‑Abin! 'Mii‑ pö i ‑dhɛ ‑gɛn ‑yan 'ka \"saɔplɛ, \"kɛɛ ‑gɛn ‑yan ‑kaɔng \"saɔplɛ ‑gaɔ \"saɔplɛ. ");
INSERT INTO daf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","(꞊Ya kë \"dhʋ̈ kö‑ \"dhiʋ̈todhɛ 'yaa 'dhö ꞊naa bha.) Yö ꞊në‑ ‑wɔn 'gü, 'yö 'a dho‑ pö ka ‑dhɛ ꞊dhɛ: Atanna ‑bha ‑gblüdëdhɛ bha ‑yö ‑bhɔ ‑gblüdë do 'bha ‑bha 'wɔn ‑bha. ‑Gblüdë 'bha bha ꞊në‑ pö ö ‑bha gwëëzë ‑nu ‑dhɛ yi do 'ka ꞊dhɛ: «Ma ꞊naɔ \"pɛpɛ 'ö ka ‑gɔ bha, ‑ka nu‑ 'ka kö 'kwa‑ dhʋng!» ");
INSERT INTO daf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","꞊Dhɛ 'ö ꞊wa nu ꞊naɔ bha‑ 'ka, 'ö ꞊wa zun‑ dhʋng ‑sü ‑bha ‑së 'ka, 'yö 'wo ‑wo mɛ do 'ö‑ ‑bha 'wëë‑ \"gblü këng drun \"pɔ ‑yö gun‑ ‑bha bha‑ 'ka, 'yö 'wo nu‑ 'ka‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","'Ö gun \"dhʋ̈ kö gɔndënë bha pë \"ʋʋ pë 'bha 'yaa‑ ‑gɔ kö ‑yö \"pɔ bha‑ bho‑ 'ka. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö‑ dëmɛ ‑ya pö‑ 'dhö, ‑a ‑bha dhebhɔ 'dhö, ‑a ‑bha 'në ‑nu 'dhö, ‑wa nu 'go ꞊dhuëng 'ka waa‑ ꞊slɔɔpë ꞊gban 'dhö kö ö ‑bha 'wëëga bha ‑yö ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑bha gwëëmi bha 'ö zun ö kpiö 'gü‑ ‑dhɛ 'yö ꞊bhɛa 'ö‑ pö: «N Dëmɛ, ‑bhö i zuë\" kë ‑sɛa n \"piʋ̈ kö 'a i ‑bha \"pɔ pë bha‑ mɔɔ‑ ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","꞊Dhɛ ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑wëë 'dhö ‑gblüdë bha‑ ‑kë 'yö‑ pö‑ ‑dhɛ: «'Ma i ‑mawɔn 'to, ‑bhö 'dho!» ");
INSERT INTO daf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","꞊Dhɛ 'ö gɔndënë 'ö ‑gblüdë ‑ya ‑mawɔn 'to bha ꞊ya zun \"kpɛnng, 'yö ‑kpan ö yëkëyɔɔ 'ö wɛng 'wo yë ‑kë ‑gblüdë do bha‑ \"piʋ̈, \"kɛɛ 'ö yö ‑zë ‑a ‑bha 'wëë‑ këng ꞊plɛ ‑nu \"sinma \"pɔ 'dhö‑ ‑bha bha‑ ‑bha. 'Yö sa‑ ‑ta, 'yö kun bhɛa\" kpɛnngkpɛnngdhö 'yö‑ pö‑ ‑dhɛ: «‑Bhö ma 'wëëga bha‑ nu!» ");
INSERT INTO daf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","'Yö‑ yëkëyɔɔ bha 'ö zun‑ ‑dhɛ kpiö 'gü, 'yö ꞊bhɛa 'ö‑ pö: «‑Bhö dɔ \"gbɩɩ‑ kö 'i i zuë\" kë ‑sɛa n \"piʋ̈ kö 'a i bha \"pɔ pë 'ö bha‑ mɔɔ‑!» ");
INSERT INTO daf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","\"Kɛɛ 'yö yö ‑zë 'yii \"wɩ‑ ‑bha, 'yö‑ kun 'ö‑ ‑da ‑kaso 'gü 'yö dho ö zun‑ 'ka ‑a ‑bha \"pɔ bha‑ ꞊gban bho ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","꞊Dhɛ 'ö‑ \"tɛabɔ ‑nu 'wo 'wɔn bha‑ ‑dhɛ yö, 'yö ‑wëë ‑yö bɔ‑ ‑nu ‑ta ꞊dedewo, 'yö 'wo dho 'wo ‑ziö 'gü wo ‑gɔmɛ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","꞊Dhɛ 'ö‑ ‑nu ‑gɔmɛ ‑yö 'wɔn bha‑ ma, 'yö ö ‑bha gwëëmi bha‑ ‑dhɛ 'yö‑ pö‑ ‑dhɛ: «Gwëë\" \"klʋ yaasü! Bhɛa\" ꞊në 'i‑ wo n ‑dhɛ ma 'wëëga 'ö i ‑bha bha‑ ‑wɔn 'gü 'yö 'a‑ ꞊gbaɔ i ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","꞊Ya kë \"dhʋ̈ ‑a ‑dhɛa bha 'nu kö i \"tɛado bha‑ ‑wëë ‑yö i kë 'pö ꞊dhɛ ‑kɔ 'ö i ‑wëë ‑yö n ‑kë 'ka bha‑ 'dhö, \"kɛɛ 'yö 'bhii yö ‑zë kë.» ");
INSERT INTO daf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Wɔn bha‑ ‑siö ‑gɔmɛ bha‑ ‑bha ‑kɔ yaa bha‑ ‑wɔn 'gü, 'yö‑ kun 'pö 'ö‑ ‑da ‑kaso 'gü kö ‑wa ‑wëë ‑kë wo ꞊dedewo ‑yö 'dho ‑yö zun‑ 'ka ‑a ‑bha \"pɔ bha‑ ꞊gban bho ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","'Yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «꞊Ya kë ꞊dhɛ 'mɛ 'ka \"dhʋ̈ 'do 'do 'ka 'kii ka dheebhang ‑mawɔn 'to ka zuë\" ꞊gban 'ka, n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü, ‑yö ‑dho ka kë ‑kɔ do bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","꞊Dhɛ 'ö Yesu ꞊ya bo ‑a ‑nu ꞊klang kë ‑sü 'ka 'wɔn ‑nu bha‑ 'ka, 'yö go Gadhidhe ‑sɛ 'gü 'yö dho Zude ‑sɛ \"pɛan 'dhɛ 'ö bɔ \"yi 'wo‑ Zuudɛn ‑kë bha‑ ꞊taama bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mɛ kpö 'gbɛ ꞊dede ‑wo ‑dho 'zü‑ ꞊keng‑ mü 'ö‑ ‑nu dha ‑a ‑nu ‑bha \"yua ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","‑Dhɛ bha ꞊në Fadhiziɛn ‑nu ga 'bha 'wo nu Yesu ‑gɛn mɔɔ‑ ‑dhɛ 'gü mü, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «'Mɛ i ‑bha dhebhɔ ꞊ya i ‑siödhɛwɔn kë bha ‑oo, 'kö 'zü 'ö ‑kë 'wɔn suu \"ʋʋ suu 'ö‑ 'ka, ‑yö ‑së kö‑ ‑mɛ ‑ya ‑bha dhebhɔ bha‑ bho \"bü ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'gü 'kaa‑ dɔ ꞊në wo ‑ee? ‹‑A zübhoyi 'ka Atanna ‑yö gɔɔn‑ waa‑ dhebhɔ ꞊në‑ ‑nu ‑da.› ");
INSERT INTO daf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","'Yö go mü 'ö‑ pö: ‹‑A ‑kë \"dhʋ̈ ‑sü 'gü, gɔɔn‑ ‑dho \"kan ö dë waa‑ ö dhe ‑a ‑nu ‑bha, 'yö waa‑ ‑bha dhebhɔ 'wo ‑tosɛa ‑kë, 'yö wɛng 'wo ‑kë pë do 'ka.› ");
INSERT INTO daf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","꞊Ya kë \"dhʋ̈ kö dhe waa‑ gɔn 'wo bha 'waa mɛ ꞊plɛ 'ka 'zü, kö ꞊wa kë pë do ꞊në‑ 'ka. ‑A ‑kë \"dhʋ̈ ‑sü 'gü kö 'pë 'ö Atanna ꞊yaa‑ ꞊nëng 'kwëë‑ bha, mɛ 'bha 'ya 'dho‑ pö 'ö‑ \"kan 'kwëë‑.» ");
INSERT INTO daf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'Yö Fadhiziɛn ‑nu ‑wa dhɛɛ\" kpɔ 'zü 'wo‑ pö: «‑Yö ‑kë 'sa ꞊dhɛ 'yö Moizö ‑zë 'ö‑ pö mɛ \"ʋʋ mɛ 'ö ꞊yaa‑ pö 'ö dhe bho \"bü, ‑a ‑mɛ ‑ya ‑bho \"bü 'sëëdhɛ kë kö ‑ya ꞊nëng‑ ‑bha?» ");
INSERT INTO daf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Kaa‑ gɔɔgbɩɩdhɛ bha ꞊në‑ ‑kë 'yö Moizö ‑ya pö \"dhʋ̈, \"kɛɛ 'yaa gun \"dhʋ̈ ‑blɛɛsü. ");
INSERT INTO daf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A‑ ‑pö ka ‑dhɛ ꞊dhɛ: Mɛ \"ʋʋ mɛ 'ö ö ‑bha dhebhɔ bho \"bü, kö‑ ‑gɛn 'yii kë‑ ‑zuazëwɔn ‑zë 'ka, kö ‑yö 'dho ‑yö dhe \"wɛɛ 'sü, kö‑ ‑mɛ ‑yö ‑da ꞊në wo mɛ ‑nu ‑bha dhe \"piʋ̈ bha.» ");
INSERT INTO daf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","'Yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ 'wo‑ pö‑ ‑dhɛ: «꞊Ya kë \"dhʋ̈ yö ‑zë 'gü kö ‑to ‑kiɛgbaɔ 'ka ‑sü fië‑ ‑dhö 'sa ‑dhe.» ");
INSERT INTO daf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Wʋ 'dhɛ 'kö 'a go‑ pö bha mɛ ꞊gban 'wii 'dho yö ‑zë 'gü ma, kö 'yii kë mɛ 'dhɛ 'kö Atanna ‑ya 'gü ma ‑sü nu‑ ‑nu ‑dhɛ ‑a ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","'Wɔn ‑gɛn 'gbɛ ‑yö ‑dhö 'ö mɛ 'gbɛ 'waa ꞊mɔɔ‑ ‑bha kö ‑wo dhe 'sü‑ ‑wɔn 'gü. Mɛ 'bha ‑nu ‑wo ‑bhɔ wo ‑bha 'ka, 'ö mɛ 'bha ‑nu ‑dɩ 'pö mɛ \"bhɩɩ‑ ‑nu ꞊në 'wo‑ ‑nu ‑kë \"dhʋ̈. 'Yö‑ mɛ 'bha ‑nu ‑dɩ 'pö, ‑a ‑nu ‑to ‑kɛgbaɔ 'ka ‑wɔn ‑gɛn 'dhö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑wɔn ‑bha. Kë \"dhʋ̈ kö 'wo‑ ‑bha yë kë woo‑ ‑tosɛa ꞊gban 'ka. 'Ma‑ pö \"dhʋ̈, ‑a 'gü ma ‑mɛ ‑ya ma!» ");
INSERT INTO daf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö mɛ ‑nu ‑wo nu 'në 'sɛɛnnë ‑nu 'ka‑ ‑dhɛ kö ‑yö ö ‑kɔ kpa ‑a ‑nu ‑ta kö ‑yö bhɛa\" Atanna ‑dhɛ ‑a ‑nu ‑wɔn 'gü, \"kɛɛ 'yö‑ ‑bha ꞊klang ‑nu 'wo ‑ya ‑ya 'mɛ 'wo bha‑ ‑nu \"yan 'gü ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Ka ka kwaa‑ 'nësɛɛnnë ‑nu ‑zü kö ‑wo nu n \"piʋ̈ 'ka 'dho ‑a ‑nu \"piʋ̈ kë, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ ‑yö 'mɛ 'wo bhɔ 'në ‑nu ya‑ ‑nu ‑bha ꞊në‑ ‑nu ‑bha 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","'Yö ö ‑kɔ ‑ya ‑nu ꞊gbin‑, 'yö 'dhuë‑ ‑kë ‑nu ‑bha 'yö ‑ziö. ");
INSERT INTO daf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","꞊Dhɛ 'ö dho 'ö ꞊loo ‑dhɛ 'bha bha‑ 'gü, 'yö 'nëglɔɔnnë do 'bha bha 'ö nu‑ \"piʋ̈ 'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «N Dëmɛ, ‑më ‑wɔn ‑së ꞊në 'ma‑ kë 'yö 'a dho ꞊sii 'ö 'yaa yën ‑a ꞊slɔɔ?» ");
INSERT INTO daf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","'Yö Yesu ‑ya pö‑ ‑dhɛ 'ö‑ pö: «I n dhɛɛ\" ‑kpɔ 'wɔn 'ö ‑gban 'wɔn ‑së ‑bha ‑a ‑wɔn 'ka ‑më ‑wɔn 'gü? Atanna yöö do ꞊në‑ këwɔn 'dhö ‑së. ꞊Ya kë ꞊dhɛ ꞊sii 'ö 'yaa yën bha‑ ‑dhɔ ꞊ya kë i ‑bha kö ‑bhö i 'gü dɔ \"gbɩɩ‑ kö 'i Atanna ‑bha 'tɔng‑ ‑nu ꞊në‑ ꞊bhlëë ‑ya!» ");
INSERT INTO daf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","'Yö‑ pö Yesu ‑dhɛ 'ö‑ pö: «'Tɔng‑ ‑mɛɛ?» 'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Tɔng‑ 'ö‑ pö ꞊dhɛ: ‹'Bha 'dho mɛ zë, 'bha 'dho ‑da mɛ ‑nu ‑bha dhe \"piʋ̈, 'bha 'dho ꞊kwaan bho, 'bha 'dho ꞊sua ‑ya mɛ 'bha ‑bha, ");
INSERT INTO daf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‑bhö i dë waa‑ i dhe‑ ‑nu ‑ya ꞊bhlëë 'gü, i këyɔɔ ‑dhɔ ‑yö i kë ꞊dhɛ i ‑dɩ 'dhö bha‑ yö.›» ");
INSERT INTO daf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","'Yö 'nëglɔɔnnë bha 'ö‑ pö Yesu ‑dhɛ: «'Tɔng‑ 'dhɛ 'kö bha 'ma‑ ꞊gban 'kun, ‑a ‑mɛɛ ꞊në ꞊ya 'to?» ");
INSERT INTO daf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","'Yö Yesu ‑ya pö‑ ‑dhɛ: «'Bha‑ pö‑ \"dhiʋ̈ ‑yö pa Atanna wëëdhö, ‑bhö 'dho kö pë \"pɛpɛ 'ö i ‑gɔ 'i‑ ꞊gban 'go, kö 'i‑ sɔng bha‑ ꞊gbaɔ \"flɛɛmɛ ‑nu ‑gɔ kö 'i nu 'i ‑da n ꞊keng‑. 'Bha‑ kë \"dhʋ̈ i ‑dho ꞊naɔ 'dhɛ 'ö dhang‑ 'gü ‑a ꞊slɔɔ.» ");
INSERT INTO daf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","\"Kɛɛ ꞊dhɛ 'ö 'nëglɔɔnnë bha 'ö ‑wʋ ‑nu bha‑ ma, 'yö ö wë 'gü ‑siö, 'yö ‑ziö 'ö dho, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊naɔ‑ ‑gun ‑gɔ ꞊dedewo, (‑a ‑wɔn 'gü, 'yaa gun‑ \"piʋ̈ ꞊dhɛ 'ö ö ‑kɔ bho‑ 'gü). ");
INSERT INTO daf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","꞊Dhɛ 'ö ꞊ya 'dho, 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ꞊Naɔmɛ ‑nu ‑bha ‑da Atanna ‑bha ‑gblüdëdhɛ 'gü ‑dhɛ ‑dho kë \"gbɩɩ‑. ");
INSERT INTO daf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","'Ö 'a‑ pö 'zü ka ‑dhɛ ꞊dhɛ: ‑Yɔɔnmɛa ‑bha bɔ ‑sɛdha ‑yɛ 'ka ‑dhɛ ‑yö 'ya‑, \"kɛɛ ꞊naɔmɛ ‑nu ‑bha ‑da Atanna ‑bha ‑gblüdëdhɛ 'gü ‑sü ‑yö \"gbɩɩ‑ 'ö ‑ziö ‑yɔɔnmɛa ‑bha ‑ziö ‑sɛdha ‑yɛ 'ka ‑sü ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","꞊Dhɛ 'ö‑ ‑bha ꞊klangdhiʋ̈ ‑nu 'wo ‑wʋ bha‑ ma, 'yö‑ 'wɔn ‑ya ‑nu kɔn ꞊dedewo 'yö 'wo‑ pö‑ ‑dhɛ: «꞊Ya kë \"dhʋ̈ yö ‑zë 'gü 'sa kö 'dee dho dha?» ");
INSERT INTO daf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","'Yö Yesu ‑ya ‑nu ‑ga \"sɛnngdhö, 'yö‑ pö: «Mɛ \"bhɩɩ‑ ‑zë ‑kɔ 'yaa ꞊mɔɔ‑ ‑bha, \"kɛɛ Atanna ‑zë ‑fiëbhawɔn 'yaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","'Yö Piɛdhö ‑ya pö Yesu ‑dhɛ 'ö‑ pö: «'Yö 'mɛ 'kö yi ‑zë 'ya yii‑ pë ꞊gban ‑pë ꞊gban 'to, 'ö 'ya ‑da i ꞊keng‑ 'sa ya ꞊wɛ, ‑më ꞊në dho kë yi ‑zë yi ‑dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ mang Mɛgbömɛ 'a dho ‑ya ma ‑gblüdëdhɛ ‑gbloo ꞊bhlëësü bha‑ 'gü \"kpʋngtaadhɛ ‑dee bha‑ 'gü ‑dhɛkpaɔyi 'ö‑ 'ka, mɛ ‑kaɔng do ga ꞊plɛ 'ka ‑ziö n ꞊keng‑ bha, kaa ‑dɩ 'pö ka ‑dho ‑ya ‑gblüdëdhɛ ‑gbloo ‑nu ‑ta kö 'ka za dɔ Izraɛdhö \"sɛgɔ ‑kaɔng do ga ꞊plɛ bha‑ 'gü ‑mɛ ‑nu ‑bha yi 'ö bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","꞊Ya 'go mü mɛ \"pɛpɛ 'wo dho woo‑ 'kɔ ‑nu waa‑ wo dheebhang gɔɔn‑ ‑nu waa‑ dhong ‑nu, wo dë ‑nu, wo dhe ‑nu waa‑ woo‑ dhebhɔ ‑nu, woo‑ 'në ‑nu \"ɛɛn woo‑ 'bhlaa‑ ‑nu 'to n ‑wɔn 'gü, ‑wo ‑dho ‑a \"dhiʋ̈ ‑ziö ‑ta ꞊slɔɔ, 'ö 'wo dho 'wo ꞊sii 'ö 'yaa yën bha‑ ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","\"Kɛɛ 'mɛ 'wo mɛ ‑blɛɛsü ‑nu 'ka \"tʋ̈ng ya‑ 'gü bha, ‑a mɛ 'gbɛ ‑dhɛ ‑dho 'to ꞊taama, 'ö 'mɛ 'wo ꞊taama 'pö \"tʋ̈ng ya‑ 'gü bha‑ mɛ 'gbɛ 'wo bɔ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","'Yö Yesu ‑ya pö: «‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ ‑yö ꞊dhɛ gɔndë do 'ö yëkëmɛ ‑da ö ‑gɔ 'bhlaa‑ kö ‑ya ꞊saa bho ꞊në‑ 'dhö. Gɔndënë bha ‑dhɛkpaɔ tii 'gü yi do 'ka 'yö dho mɛ mɔɔ‑ ‑dhɛ 'gü kö ‑wo yë kë ö ‑gɔ ‑drɔɔ ‑dhü ‑bhlaa 'gü. ");
INSERT INTO daf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","'Yö 'wo ꞊mɔɔ‑ ꞊saa \"dhi 'gü ‑suga do ‑dhɛkpaɔyi do, 'yö‑ ‑nu bɔ yë kë ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","꞊Dhɛ 'ö 'yënng‑ \"tɛɛ ꞊ya ‑wo ‑së 'ka, 'yö dho 'zü mɛ 'bha mɔɔ‑ ‑dhɛ 'gü. 'Yö dho 'yö ‑kpan mɛ kpö 'bha ‑bha kö ‑wo dɔ sië \"dhɛɛdhö kö yë 'yaa‑ ‑nu ‑gɔ ");
INSERT INTO daf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","'yö‑ pö‑ ‑nu ‑dhɛ: Kaa ‑dɩ 'pö ‑ka 'dho n ‑gɔ ‑drɔɔdhɛ 'gü kö 'ka yë kë 'mü, a ‑dho ka ꞊saa bho‑ bho ‑kɔ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","꞊Dhɛ 'ö‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈, 'yö 'mɛ 'wo bha 'pö 'wo ‑ziö 'wo dho. ꞊Dhɛ 'ö 'yënng‑ ‑ya ‑mɛ ‑gɔ ꞊zinng 'gü \"tʋ̈ng bha ꞊ya ꞊loo, 'yö ‑drɔɔ ‑bhlaa dëmɛ bha 'ö dho 'zü mɛ 'bha mɔɔ‑ ‑dhɛ 'gü, 'yö 'dho 'bha wo kö 'yënng‑ ꞊ya 'kpɔ mɛ ‑gɔ 'ka, 'yö ‑kpan 'zü mɛ 'bha ‑nu ‑bha, 'yö ‑wʋ do bha‑ pö‑ ‑nu ‑dhɛ 'yö 'wo dho 'pö. ");
INSERT INTO daf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","꞊Dhɛ 'ö 'yënng‑ ‑gɔ ꞊ya ‑ya ‑tɔn ‑ta, 'yö dho 'bha wo 'yö ‑kpan mɛ kpö 'bha ‑bha 'zü kö ‑wo dɔ sië \"dhɛɛdhɛ bha‑ 'gü, 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Më ‑wɔn 'ö mü 'yö 'ka dɔ ‑dhɛ ya‑ 'gü \"wɛɛwɛɛ 'yö 'kii yë 'bha kë ꞊dɛɛ?» ");
INSERT INTO daf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «'Mɛ 'ö dho yi 'sü ꞊në‑ ‑mɛ 'yaa 'dhö ‑wa!» 'Yö‑ pö‑ ‑nu ‑dhɛ: «꞊Dhɛ 'ö \"dhʋ̈ kö ‑ka 'dho kö 'ka yë kë n ‑gɔ ‑drɔɔ ‑bhlaa 'gü!» 'Yö 'wo dho 'pö. ");
INSERT INTO daf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","꞊Dhɛ 'ö \"bin ꞊ya 'ma, 'yö 'bhlaadë ‑ya pö ö ‑kɔdhiʋ̈mɛ ‑dhɛ 'ö‑ pö: «‑Bhö yëkëmɛ ‑nu bha‑ ‑nu ‑dhɛ 'kii‑ ‑nu ꞊saa bho, \"kɛɛ ‑a zü bho 'mɛ 'wo nu ꞊taama bha ꞊në‑ ‑nu ‑ta kö 'i‑ \"dhiʋ̈ ta 'mɛ 'wo nu ‑blɛɛsü bha‑ ‑nu ‑ta!» ");
INSERT INTO daf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'mɛ 'wo nu yë \"dhiʋ̈ kö 'yënng‑ ‑gɔ ꞊ya ‑ya ‑tɔn ‑ta bha 'wo nu 'yö 'wo‑ ‑nu ꞊saa bho ‑suga 'do 'do 'ka. ");
INSERT INTO daf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","'Yö 'mɛ 'ö woo ‑dɩ 'pö, 'wo ‑da yë 'gü ‑blɛɛsü bha 'wo nu. ‑Yö ‑kë ‑nu 'gü ꞊dhɛ ‑a ‑nu ‑bha ‑dho ziö 'mɛ 'wo nu ꞊taama bha‑ ‑nu ‑bha ‑ta, \"kɛɛ 'yö 'wo ‑suga 'do 'do ‑gblü ‑a ‑nu ‑ta 'pö. ");
INSERT INTO daf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","꞊Dhɛ 'wo ‑suga 'do 'do bha‑ sü 'yö 'wo ‑ya ‑dɔn bho ‑sü ‑bha wo yun 'gü ‑drɔɔdhɛ dëmɛ bha‑ 'ka ");
INSERT INTO daf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'wo‑ pö: «'Mɛ 'wo ‑da yë 'gü kö \"bin ꞊ya ma ya, i‑ ‑nu ꞊saa ‑bho 'pö ꞊dhɛ 'mɛ yi ‑zë 'yi yë ‑kë 'yënng‑ 'ka 'yi ꞊gloo ‑bha yö yi 'dhö ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'Yö‑ ‑yɔ bɔ mɛ do ‑gɔ 'ö‑ pö: «N \"taɔngdë, 'mii \"kpënng‑ kë ka ‑gɔ ‑wa, \"ɛɛn 'kwii ꞊mɔɔ ‑suga do ꞊në ‑wɔn 'gü, 'yö 'ka gun ‑na yë zü bho ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","꞊Dhɛ 'ö \"dhʋ̈, ‑ka kaa‑ 'dho wo ka ꞊saa bha‑ 'ka, mɛ 'dhɛ 'wo nu ꞊taama bha‑ ‑nu ꞊saa ‑bho \"dhʋ̈ ‑wɔn ‑yö ‑ga ma ꞊në n 'gü 'yö 'a‑ bho \"dhʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","\"Ɛɛn n ‑dɩ ‑bha ꞊naɔ 'yaa ‑mü, pë 'ö ‑dhi n ‑dhɛ 'maa ꞊mɔɔ‑ ‑bha 'kaa‑ ‑kë 'ka ‑ee? \"Ɛɛn n \"klʋ ‑kë ‑së ‑wɔn ꞊në ‑siö ka ‑dhɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","'Yö Yesu ‑ya pö: «'Pë 'ö ‑kë 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ (Atanna ‑bha 'wɔn kë ‑kɔ waa‑ mɛ \"bhɩɩ‑ ‑bha 'waa do, ‑a ‑wɔn 'gü) 'mɛ 'ö nu ‑blɛɛsü waa‑ 'mɛ 'ö nu ꞊taama ‑a ‑nu ꞊saa‑ ‑dho kë do bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","'Ö gun kö Yesu ‑yö 'dho sië Zedhizadhɛmö, waa‑ ö ‑bha ꞊klang ‑nu 'yö mɛ ‑kaɔng do ga ꞊plɛ bha‑ ‑nu ‑dhɛ ꞊plɛ 'gü \"ta ‑zian bha‑ ‑ta 'yö‑ pö‑ ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«‑Ka ‑dhɛ ‑ga, 'dho do 'kwa‑ wo sië Zedhizadhɛmö ya, ‑wo ‑dho mang Mɛgbömɛ n ꞊gbaɔ \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu ‑gɔ 'ö 'wo n zë za 'ka, ");
INSERT INTO daf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'yö 'wo n ‑dɔ 'mɛ 'waa Zuifö 'ka‑ ‑nu ‑gɔ, 'yö 'wo ꞊wɛɛ dɔ n ‑bha, 'yö 'wo n ‑ma ‑sabhlü 'ka, 'yö 'wo n dɔ \"dhü ‑bha 'yö 'a ga 'yö‑ ‑dhɛkpaɔyi ‑yaaga ‑naa 'ka 'a ‑bö. ");
INSERT INTO daf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","꞊Dhɛ 'ö go yö ‑zë 'gü, 'yö Zebede ‑bha dhebhɔ ‑yö ꞊yɔɔn Yesu \"sɔɔ 'waa‑ ö gbö ‑nu 'wo gun‑ ꞊keng‑ ‑a ‑bha ꞊klangdhiʋ̈ 'ka bha‑ ‑nu 'dhö 'yö zun ö kpiö 'gü‑ ‑dhɛ ‑bhɛa ‑dhɛ kian 'ka. ");
INSERT INTO daf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","'Yö Yesu ‑yö to 'ö‑ dhɛɛ\" kpɔ 'ö‑ pö: «‑Yö i \"piʋ̈ ꞊dhɛ 'a kë i ‑dhɛ ꞊dhɛ? 'Yö dhebhɔ bha 'ö‑ pö: «‑Bhö dɔ \"gbɩɩ‑, n dëmɛ, kö n gbö ‑nu ꞊plɛ ya, ‑duɛ 'ö i \"piʋ̈ dhang‑ 'gü bha‑ ꞊bhlëësü ꞊dede 'ö‑ 'gü bha 'i‑ nu‑ ‑nu ‑dhɛ i ‑bha ‑gblüdëdhɛ ‑yö ‑bha ‑yi 'ka ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'Yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «Pë ‑nu 'ka‑ pö sië bha 'kaa‑ 'klɔɔ‑ dɔ. \"Ɛɛn 'wɔn \"gbɩɩ‑ 'ö maa‑ \"yi mü ya ka ‑mɔɔ ‑bha 'ka‑ mü ‑ee?» 'Yö 'wo‑ pö‑ ‑dhɛ: «꞊Iin, yi ‑mɔɔ ‑bha 'yi‑ mü.» ");
INSERT INTO daf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","'Yö‑ pö 'zü‑ ‑nu ‑dhɛ: «‑Yö \"dhʋ̈ ‑zë wo tɛan‑ 'ka ꞊dhɛ 'wɔn \"gbɩɩ‑ do 'ö maa‑ \"yi mü bha ka ‑dho ka ‑bha mü, \"kɛɛ ‑a 'dhɛ 'kö ‑gban ‑duɛ 'ö n \"piʋ̈ dhang‑ 'gü ‑a ‑blɛɛsü ‑sü ‑wɔn ‑zë ‑bha bha, ma ‑zë 'maa‑ ‑nu mɛ ‑dhɛ ‑mɛ 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yɛa ‑nu 'wo \"dhʋ̈ bha 'mɛ 'ö n Dë ‑ya ‑ya ‑a ‑nu ‑gɔ ‑ya wo ꞊në‑ ‑nu ‑bha 'ka.» (Yö ꞊në‑ ‑nu ‑a ‑nu ‑dhɛ ‑mɛ 'ka). ");
INSERT INTO daf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","꞊Dhɛ 'ö‑ ‑bha ꞊klang ‑nu bha‑ mɛ ‑kaɔng do 'wo to 'wo 'wɔn bha‑ ma, 'yö ‑siö ‑nu ‑dhɛ mɛ ꞊plɛ 'dhɛ 'wo bha‑ ‑nu kwi ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «Ka‑ 'wɔn ‑dɔ 'kpakpadhö ꞊dhɛ \"sɛgɔdhiʋ̈mɛ ‑nu ‑wo ‑gbaɔn woo‑ \"sɛgümɛ ‑nu ‑ta, 'ö faanmɛ ‑nu 'wo faan ‑dhɛ ‑wo mɛ ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","\"Kɛɛ ‑a ‑dhɛ 'yaa‑ ‑bha kö ka ‑zë ka ‑bha ‑yö kë \"dhʋ̈. Ka ‑zë ka ‑bha 'ka 'mɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ö kë mɛ ꞊bhlëësü ꞊dede 'ka Atanna 'gü bha‑ ‑dhɛa ‑bha kö‑ ‑mɛ ꞊në ‑yö kë ka \"dhiʋ̈ ‑ziö wo ‑mɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","'Mɛ 'ö‑ \"piʋ̈ 'zü ꞊dhɛ ö ‑duɛ kë 'kpii‑ (Atanna \"piʋ̈), ‑a ‑dhɛa ‑bha kö‑ ‑mɛ ꞊në ‑yö kë kaa‑ ꞊dhuëng 'ka. ");
INSERT INTO daf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'Wɔn 'ö‑ ‑wɔn 'gü 'yö mang Mɛgbömɛ 'mii nu kö ‑wo ma ‑zë n \"dhiʋ̈ ‑ziö wo, \"kɛɛ 'yö 'a ‑nu kö ma ꞊në 'a mɛ \"bhɩɩ‑ ‑nu \"dhiʋ̈ ‑ziö wo kö 'a n ‑dɩ nu ‑a ‑nu dha ‑wɔn 'gü bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","‑A ‑nu 'dho ‑sü 'ka, ꞊dhɛ 'ö ꞊wa 'go Zedhiko, mɛ 'gbɛ ꞊dede ‑wo ‑ziö 'zü Yesu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","\"Yanwlümɛ ꞊plɛ ‑wo ‑gun ‑ya ‑sü 'ka zian \"gʋ̈ng \"piʋ̈ ‑dhɛ 'bha 'gü mü. ꞊Dhɛ 'ö ꞊waa‑ ma ꞊dhɛ Yesu ‑yö ziö sië, 'yö 'wo ‑ya \"gbla ‑sü ‑bha 'wo‑ pö: «Yi Dëmɛ, Davi Gbö, ‑bhö \"ta yi ‑dhɛ ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Yö mɛ kpö 'wo gun Yesu ꞊keng‑ bha 'wo ‑ya \"gbla ‑sü ‑bha ‑a ‑nu ‑ta 'wo‑ pö ‑wo wo \"dhi ta. \"Kɛɛ 'yö 'wo wo ‑wʋ \"dhiʋ̈ ꞊wlü 'pö \"gbɩɩ‑ 'ka 'wo‑ pö: «Yi Dëmɛ, Davi Gbö, ‑bhö \"ta yi ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","'Yö Yesu ‑yö 'daɔnnu, 'yö‑ ‑nu ‑dhɛ, 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «Ka‑ ‑pö 'a‑ kë ka ‑dhɛ ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","'Yö 'wo‑ pö: «Yi Dëmɛ, ‑bhö yi \"yan \"dhiʋ̈ \"pʋ!» ");
INSERT INTO daf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈ 'yö ‑wëë ‑yö bɔ Yesu ‑ta, 'yö ö ‑kɔ ‑yɛ ‑a ‑nu \"yan ‑bha, ‑wo ‑to ‑dhɛ do bha‑ 'gü 'ö‑ ‑nu \"yan \"dhiʋ̈ ‑yö ‑pʋ 'yö 'wo ‑dhɛ yö, 'yö 'wo ‑ziö Yesu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊yɔɔn Zedhizadhɛmö ‑dhɛ \"sɔɔ, 'yö 'wo bɔ 'pödhɛ 'wo‑ ‑dhɛ Bɛtöfaze 'ö Odhivie ‑tɔn \"pɛan \"piʋ̈ bha‑ 'gü. ꞊Dhɛ 'ö ꞊wa ꞊loo 'pö‑ bha‑ \"saan \"dhiʋ̈, 'yö Yesu ‑yö ö ‑bha ꞊klang ‑nu ꞊plɛ bɔ, 'yö ö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«‑Ka 'dho 'pödhɛ 'ö ‑ya ka \"dhiʋ̈ bha‑ 'gü, 'ka 'dho ka ‑dho ‑kpan ꞊soofëng ‑dhee do waa‑ ö 'në ‑a ‑nu ‑bha kö ‑wo ‑kplü ‑sü 'ka, kö 'ka‑ ‑nu \"pʋ 'ka nu‑ ‑nu 'ka n ‑dhɛ! ");
INSERT INTO daf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","꞊Ya kë ꞊dhɛ ꞊wa ka dhɛɛ\" 'kpɔ ‑kaa pö‑ ‑mɛ ‑dhɛ: ‹Yi Dëmɛ ‑mawɔn ‑ya ‑bha›. Ka‑ pö \"dhʋ̈ ‑yö ‑dho 'to ‑dhɛ do bha‑ 'gü 'ö ö ‑kɔ bho ka 'gü 'ö 'ka nu‑ nu 'ka n ‑dhɛ yö! ");
INSERT INTO daf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","'Pë 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑ya pö 'ö‑ pö ꞊dhɛ: ‹Siɔn ‑mɛ ‑nu, ‑ka ‑dhɛ ‑ga, kaa‑ ‑gblüdë ‑yö nu sië ka \"piʋ̈, ‑a ‑bha ‑gblüdëdhɛ ‑yö dhɔng ‑sü, ‑yö ‑ya ‑sü 'ka ꞊soofëng do ‑ta, \"kɛɛ ꞊soofëng 'në \"gbɔng ‑zian 'ö ‑tun ö dhe ꞊keng‑ ꞊në 'ö ‑ya ‑sü 'ka‑ ‑ta› bha‑ 'gü ‑wɔn ‑yö ‑kë ‑kɔ bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","'Yö ꞊klang ‑nu ꞊plɛ bha 'wo dho, 'yö 'wo‑ ‑kë ꞊dhɛ ‑kɔ 'ö Yesu ‑ya pö‑ 'ka‑ ‑nu ‑dhɛ bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","'Yö 'wo nu ꞊soofëng ‑dhee waa‑ ö 'në bha‑ ‑nu 'ka Yesu ‑dhɛ. 'Yö 'wo woo‑ sɔ ‑nu kpɔ‑ ‑nu ‑ta, 'yö Yesu ‑yö ‑ya ꞊soofëng 'në bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö mɛ kpö 'gbɛ bha 'wo ‑ya wo ‑bha ‑sɔ ‑nu 'kpɔ ‑sü ‑bha zian ‑ta. 'Yö mɛ 'bha ‑nu ‑dɩ 'pö 'wo \"dhü kwɛɛ\" ‑nu ‑kan 'wo‑ ‑nu ꞊loo ‑zian ‑ta ‑dhɛ ꞊gban 'gü (‑a \"dhiama kian 'ka). ");
INSERT INTO daf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","'Mɛ 'wo bha‑ ‑nu kpö 'bha‑ ‑gun Yesu \"dhiʋ̈, 'yö‑ 'bha ‑yö gun‑ ꞊taama, kö ‑wo 'dho sië \"gɛɛ kë ‑sü 'ka‑ ‑zü, 'ö 'wo ‑bhabhoo kun‑ ‑ta 'wo‑ pö: «\"Sookwedhi, ‑bha ‑bha ‑bha, Davi Gbö 'tɔ ‑yö bhɔɔɔɔ! 'Mɛ 'ö nu kwa Dëmɛ 'tɔ 'gü bha‑ 'tɔ ‑yö bhɔɔɔ, ‑yö ‑bhɔ \"kpʋng ꞊taa! ‑Yö bhɔ \"dhʋ̈ dhang‑ \"güüü! ");
INSERT INTO daf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu ‑bha ‑da Zedhizadhɛmö ‑sü 'gü, ‑a ‑ting ‑yö ‑da 'ö 'wo ‑ya wo 'ko ‑nu dhɛɛ\" 'kpɔ ‑sü ‑bha 'wo‑ pö: «Dee ya!» ");
INSERT INTO daf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","꞊Waa‑ pö \"dhʋ̈, 'yö mɛ \"dhaa 'wo gun‑ ꞊keng‑ bha ꞊waa‑ pö: «Atanna ‑wʋdhiʋ̈loomɛ 'wo‑ ‑dhɛ Yesu, 'ö go Nazadhɛtö Gadhidhe ‑sɛ 'gü bha yö ‑mü.» ");
INSERT INTO daf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","'Yö Yesu ‑yö dho 'yö ‑da Atanna ‑dhɔkëgükɔ 'ö 'plöö mü bha‑ 'gü. 'Yö 'mɛ 'wo gun \"dhɔɔ dɔ sië oo, 'mɛ 'wo gun pë 'dhɔ sië oo, 'yö ‑ya ‑a ‑nu kë ‑sü ‑bha, 'yö ‑ya 'mɛ 'wo nu 'wëë‑ fië bho ‑dhɛ 'gü 'wëë‑ 'dhɛ 'ö Atanna ‑dhɔkëgükɔ 'gü mü bha‑ ‑bha bha‑ ‑nu ‑bha 'kpongpaa ‑nu 'wo gun 'wëë‑ fië bho sië‑ ‑ta bha‑ ‑nu \"dhiʋ̈ ‑zuö ‑sü ‑bha, waa‑ 'mɛ 'wo gun ‑tong ‑nu \"dhɔɔ dɔ sië mü (kö ‑wo \"saa‑ bho‑ 'ka bha‑) ‑nu ‑ya ‑ta ‑gbloo ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","꞊Dhɛ 'ö ꞊ya ö bo 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Yö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü ꞊dhɛ: ‹‑Wo ‑dho ma 'kɔ ‑dhɛ ‑bhɛa Atanna ‑dhɛ 'gü ‑kɔ› \"kɛɛ ka ‑zë 'ka‑ kë ꞊kwaanmɛ ‑nu ‑ya 'gü ‑yɛ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö \"yanwlümɛ ‑nu waa‑ ‑gɛnloomɛ ‑nu 'wo nu Yesu \"piʋ̈ Atanna ‑dhɔkëgükɔ 'gü mü, 'yö‑ ‑nu dha ‑a ‑nu ‑bha \"yua ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yesu 'dhö gun 'wɔn ‑sɛsɛngbɔ ‑nu bha‑ ‑nu kë sië \"dhʋ̈ kö 'në 'sɛɛnnë ‑nu ‑wo ‑zlöö bho sië‑ ‑zü Atanna ‑dhɔkëgükɔ 'gü 'wo‑ pö: «‑A 'tɔ ‑yö bhɔ! Davi Gbö 'tɔ ‑yö bhɔ! ꞊Dhɛ 'ö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑gɔmɛ ‑nu 'wo‑ ‑dhɛ yö \"dhʋ̈, 'yö ‑siö ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","'Yö 'wo‑ pö Yesu ‑dhɛ 'wo‑ pö: «\"Gbla ‑kɔ suu 'wo‑ kë sië ya i‑ ‑dhɛ ‑yö ‑ee?» 'Yö Yesu ‑ya pö: «꞊Iin, a‑ ‑ma \"kɛɛ 'yaa ‑bɛn zë ‑sü 'ka Atanna ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: ‹I 'tɔ bhɔ ‑sü ‑dho 'go 'në 'sɛɛnnë ‑nu \"dhi 'gü, waa‑ 'në \"blë ‑dee ‑nu 'dhö ‑ee?› \"Ɛɛn 'kii‑ ‑wʋ pö do ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö go 'pödhɛ bha‑ 'gü 'yö dho Betani 'yö ‑wɔ mü. ");
INSERT INTO daf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","꞊Dhɛ 'ö gun ö yee kë sië kö ‑yö 'dho Zedhizadhɛmö ‑a ‑tadhɛkpaɔta dhia\" \"piʋ̈, 'yö din‑ ‑ya kun zian ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","'Yö dho 'ö ‑kpan figö ‑dhü do ‑bha zian 'ka, 'yö ꞊yɔɔn‑ \"sɔɔ kö‑ ‑kpʋ 'bha 'dhö mü kö 'ö‑ bho 'ö‑ ‑bhö, \"kɛɛ 'yö 'yii pë 'bha yö‑ 'gü, 'yö‑ \"dhɛ ‑dɩ ‑slɔɔ ꞊në yö mü, (‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö figö ‑pë kë \"tʋ̈ng 'yii ꞊loo ꞊kö), ‑yö \"dhang ‑da figö ‑dhü bha‑ ‑bha yö ꞊në‑ ‑wɔn 'gü 'ö‑ pö: «I bhɛ 'ya 'dho ‑ya i 'gü 'zü tongtongdhö!» Figö ‑dhü bha ‑yö ‑to ‑dhɛ do bha‑ 'gü 'ö ga. ");
INSERT INTO daf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","꞊Dhɛ 'ö‑ ‑bha ꞊klang ‑nu bha 'wo‑ ‑dhɛ yö \"dhʋ̈, 'yö‑ 'wɔn ‑ya ‑nu kɔn ꞊dedewo 'yö 'wo‑ pö Yesu ‑dhɛ: «‑Yö kë ‑kɔ ‑kë ꞊dhɛ 'yö figö ‑dhü 'kö ya 'ö ga 'gü klöö‑ ‑bha \"dhʋ̈?» ");
INSERT INTO daf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ꞊Ya kë ꞊dhɛ kö ‑zʋ ‑yö Atanna ‑dhɛ ‑sü ‑yö kë ka ‑gɔ kö 'kömüdhe 'yii kë‑ \"piʋ̈, 'wɔn 'a‑ ‑kë figö ‑dhü bha‑ 'ka bha, ka ‑dho ‑a kë 'ö ka ‑ya mü 'ka‑ pö ‑tɔn ‑zian ‑dhɛ: ‹‑Bhö 'go i \"gblʋʋ bha‑ 'gü kö 'i dho ‑pö ꞊weeyi ꞊bhaa!› 'ö ‑kë \"dhʋ̈ ka ‑wʋ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","꞊Ya kë ꞊dhɛ 'ka ka ‑zʋ yö Atanna ‑dhɛ, pë \"pɛpɛ 'ka dho‑ ‑gbadhɛ ‑a ‑gɔ ka ‑bha bhɛa\" ‑sü 'gü, ‑yö ‑dho ‑a kë ka ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","꞊Dhɛ 'ö ꞊wa 'dho \"dhʋ̈ ꞊wa ꞊loo Zedhizadhɛmö, 'yö Yesu ‑yö ‑da 'zü ‑deewo Atanna ‑dhɔkëgükɔ 'gü, 'yö ‑ya mɛ draan‑ ‑sü ‑bha mü. 'Yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu 'wo \"sɛ 'gü, 'wo nu 'yö 'wo‑ pö‑ ‑dhɛ: «'Wɔn ‑nu 'i‑ ‑kë ‑nu wo ya, i‑ ‑kë de ꞊në‑ ‑bha kë 'gü? \"Ɛɛn de ꞊në‑ pö 'i‑ kë \"dhʋ̈?» ");
INSERT INTO daf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","'Yö Yesu ‑ya ‑yɔ bɔ 'pö‑ ‑nu ‑gɔ 'ö‑ pö: «A ‑dho ka dhɛɛ\" do 'kpɔ 'pö, ꞊ya kë ꞊dhɛ 'ka‑ ‑yɔ bɔ n ‑gɔ kö mang ‑dɩ 'pö 'a 'wɔn ‑nu bha‑ kë 'mɛ 'ö‑ ‑bha kë 'gü kö 'a‑ ‑mɛ pö ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","De ꞊në Zan bɔ kö ‑yö mɛ \"zu? Atanna ‑ee, \"ɛɛn mɛ \"bhɩɩ‑ ‑nu ‑ee?» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'wo ‑ya ‑a ‑pö wo 'ko ‑dhɛ ‑sü ‑bha 'wo‑ pö: «꞊Ya kë ꞊dhɛ 'kwa‑ pö‑ ‑dhɛ ꞊dhɛ Atanna ‑mü, ‑yö ‑dho kwa dhɛɛ\" 'kpɔ 'zü 'ö‑ pö: ‹\"Kɛɛ ‑yö ‑kë ‑mü ꞊dhɛ 'yö 'kii 'dhang bho ‑wʋ 'ö‑ pö n ‑bu 'gü bha‑ \"dhiʋ̈?›. ");
INSERT INTO daf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'Kwii kë‑ pö \"dhʋ̈ 'zü 'kwa‑ pö: ‹Mɛ \"bhɩɩ‑ ‑nu ‑mü› 'kwa ‑kpla \"sɛgümɛ ‑nu ‑gɔ, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ ꞊gban \"pɛpɛ ‑wa 'wɔn ‑dɔ ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ꞊në gun Zan 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'wo‑ ‑yɔ bɔ Yesu ‑gɔ 'wo‑ pö: «'Yaa‑ ‑mɛ dɔ.» 'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'pö 'ö‑ pö: «‑Ɛɛ, kö mang ‑dɩ 'pö 'mii 'dho n ‑bha ‑gɛn pö ka ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","꞊Dhɛ 'ö Yesu ꞊ya ö bo‑ ‑pö ‑nu ‑dhɛ \"dhʋ̈ ‑sü 'ka, 'yö‑ pö: «\"Gwënng 'ö maa ‑da bha, 'ka ka ‑bha 'sü‑ 'gü!» 'Yö‑ pö: «Gɔndënë do 'bha bha‑ gbö ‑nu ‑wo ‑gun ꞊plɛ. Yi do 'ka 'yö‑ pö‑ mɛ ‑blɛɛsü ‑dhɛ: «Gɔnnë, ‑bhö 'dho ꞊dɛɛ ‑zë 'gü n ‑gɔ 'bhlaa‑ kö 'i yë kë 'mü!» ");
INSERT INTO daf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'Yö 'në bha 'ö‑ pö ö dë ‑dhɛ: «N dë, 'mii 'dho 'dho.» \"Kɛɛ ꞊dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'ö ꞊ya ö \"tɛɛ 'në 'bha 'pa 'ö ꞊ya ö ‑zʋ 'gɔn, 'yö ‑ziö 'yö dho mü. ");
INSERT INTO daf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","‑A mɛ 'dhɛ 'ö to bha 'yö‑ dë ‑ya pö 'pö‑ ‑dhɛ ꞊dhɛ ‑kɔ do 'ö‑ pö‑ 'ka mɛ ‑blɛɛsü ‑dhɛ bha‑ 'dhö. 'Yö yö ‑zë 'ö‑ pö: «‑A ꞊oo, n dë, 'bha‑ pö \"dhʋ̈ 'ma‑ ma.» \"Kɛɛ 'yö 'yii 'dho. ");
INSERT INTO daf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","꞊Ya kë \"dhʋ̈ kö mɛ ꞊plɛ bha‑ de ‑sü 'pö kë ö dë ‑wʋ ‑ya ꞊bhlëë 'gü?» 'Yö 'wo‑ pö‑ ‑dhɛ: «‑A mɛ ‑blɛɛsü.» 'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ꞊Flümɛ ‑nu 'wo ‑kë 'niisɔngkunmɛ ‑nu 'ka bha waa‑ ‑zuadhe ‑nu ‑wo ‑dho ‑da Atanna ‑gɔ ‑gblüdëdhɛ 'gü ka \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","‑A ‑gɛn ‑mü ꞊dhɛ Zan kë ‑nu 'ö zian 'ö‑ du 'yaa ‑bha ‑a ‑zɔn ka ‑dhɛ, \"kɛɛ 'kii 'dhang bho‑ ‑wʋ \"dhiʋ̈, \"kɛɛ 'sa 'niisɔngkunmɛ ‑nu 'kö 'wo bha waa‑ ‑zuadhe ‑nu ‑zë ‑wo kë 'dhang bho‑ ‑wʋ \"dhiʋ̈, 'ö‑ ‑kë \"dhʋ̈ ‑sü ꞊gban waa‑ ‑bha ‑bha, ka zuë\" 'yii slëë‑ tongtongdhö kö 'ka 'dhang bho‑ ‑wʋ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑ya pö 'zü‑ ‑nu ‑dhɛ ‑deewo 'ö‑ pö: «‑Ka ka \"tʋ 'to \"gwënng 'ö maa‑ ‑da bha‑ ‑bha!» 'Yö‑ pö: «Gɔndënë do ꞊në gun, 'yö ‑drɔɔ ‑bhlaa ‑yö gun‑ ‑gɔ. 'Yö‑ ‑zü ꞊klëën, 'yö ‑drɔɔ \"yi ‑bho 'gü ‑yɛ do pɔn, 'yö dho 'yö 'kɔ 'në do dɔ kö ‑yö ‑nu kë ‑dhɛ bha‑ ‑maa ‑kë ꞊wlöö ‑kɔ 'ka. 'Yö ö ‑bha 'bhlaadhɛ bha‑ ‑da buzan 'gü, 'yö dho \"ta 'gü. ");
INSERT INTO daf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","꞊Dhɛ 'ö‑ ‑ga ꞊dhɛ ‑drɔɔ ga bho \"tʋ̈ng ꞊ya ꞊loo, 'yö ö ‑bha gwëëzë ‑nu bɔ kö buzankëmɛ ‑nu bha ‑wo ö ‑bha 'ö ꞊slɔɔ ‑a dɔ‑ ‑nu ‑gɔ kö ‑wo nu‑ 'ka ö ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","\"Kɛɛ 'yö 'mɛ 'wo bha 'wo gwëëzë ‑nu bha‑ ‑nu kun 'yö 'wo‑ mɛ do ‑ma tëëtëëdhö, 'yö 'wo‑ mɛ do zë, 'yö 'wo‑ mɛ ‑yaaga ‑naa ‑zuö ‑gwë 'ka 'yö to‑ \"dhiʋ̈ 'ö ga 'pö. ");
INSERT INTO daf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","'Yö 'bhlaa dëmɛ ‑yö dɔ 'zü 'yö‑ mɛ 'bha bɔ, 'yö mɛ 'dhɛ 'wo bha 'wo ‑kë 'gbɛ 'ö ‑ziö 'mɛ 'wo gun ‑blɛɛsü ‑a ‑nu ‑ta, \"kɛɛ 'yö buzankëmɛ ‑nu bha 'wo‑ ‑nu ‑kë 'zü ꞊dhɛ ‑kɔ do 'wo mɛ ‑blɛɛsü ‑nu ‑kë 'ka bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'bhlaa‑ dëmɛ bha 'ö ö ‑zʋ gɔn ꞊dhɛ ‑yö kë 'ö‑ wo gwëëzë ‑nu 'ka 'yö ‑kë. 'Yö ö gbö bɔ. ");
INSERT INTO daf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","\"Kɛɛ ꞊dhɛ 'ö buzankëmɛ ‑nu bha 'wo‑ gbö bha‑ yö, 'yö 'wo‑ pö wo 'ko ‑dhɛ 'wo‑ pö: «'Mɛ 'ö yöö kë 'bhlaa‑ ya‑ ‑mɛ 'ka yiplɛɛbha 'yö bha, ‑ka kwaa‑ 'kun 'kwa‑ zë kö ‑dhɛ bha ‑yö 'to kwa ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'Yö 'wo‑ kun 'yö 'wo‑ sü 'wo go‑ 'ka ‑drɔɔ ‑bhlaa 'gü, 'yö 'wo‑ zë. ");
INSERT INTO daf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","'Yö Yesu ‑yö 'mɛ 'wo \"tʋ 'to sië‑ ‑wʋ ‑bha bha‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «Ka ka ‑zʋ ‑gɔn ꞊dhɛ 'bhlaadhɛ bha‑ ‑mɛ bha ꞊ya nu, ‑yö ‑dho buzankëmɛ ‑nu bha‑ ‑nu kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Mɛ ‑mawɔn yaa ‑nu bha ‑yö ‑dho ‑a ‑nu 'kun ꞊në‑ wo 'ö‑ ‑nu zë, ‑a ‑nu ‑wëë 'yii 'dho‑ kë, 'yö ö ‑bha ‑dhɛ bha‑ sü 'ö ‑dɔ mɛ \"wɛɛ ‑nu 'ö ꞊waa‑ ‑yë kë 'wo dho‑ ‑bha nu‑ ‑dhɛ ‑a ‑nu \"tʋ̈ng ‑bha bha‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'gü ꞊dhɛ: ‹‑Gwë 'ö 'kɔdɔmɛ ‑nu 'wo wo ꞊kwaa‑ ‑zü bha ꞊në, kë ‑kë 'kɔ \"kpan ‑ya ‑ta ‑gwë 'ka› bha 'kii‑ ma do ‑ee? \"Ɛɛn 'yaa ‑bɛn zë ‑sü 'ka \"dhʋ̈ ‑ee? ‹Kë 'ö‑ wo \"dhʋ̈ bha ‑yö ‑go kwa Dëmɛ ꞊në‑ 'gü, ‑yö \"dhabhliwɔn 'ka kwa ‑zë kwa \"yan 'gü.›» ");
INSERT INTO daf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","'Yö‑ pö‑ ‑nu ‑dhɛ 'zü 'ö‑ pö: «Yö ꞊në ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ: Atanna ‑dho ö ‑bha ‑gblüdëdhɛ bha‑ 'sü (Zuifö ‑nu) ka ‑gɔ 'ö‑ nu mɛ \"wɛɛ ‑nu 'wo ꞊mɔɔ‑ ‑bha 'wo‑ ꞊trɔɔn ‑së ‑kë ‑a ‑dhɛ bha‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","‑A ‑gɛn ‑mü ꞊dhɛ ‑gwë 'ö 'kɔdɔmɛ ‑nu ‑wo wo ꞊kwaa‑ ‑zü \"dhʋ̈ bha 'mɛ 'ö dho ‑pö ‑ta, ‑a ‑mɛ ‑dho \"yɛ, 'sa yö ‑zë yaa‑ ‑pö 'mɛ 'ö‑ ‑ta ‑a ‑mɛ ‑dho ‑bʋ̈ʋ̈ bho.» ");
INSERT INTO daf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yesu 'dhö \"gwënng ‑nu 'ö ‑da \"dhʋ̈ bha ꞊dhɛ 'ö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu 'wo‑ ma, ‑wo kë‑ 'wɔn ‑dɔ ꞊dhɛ ‑yö ‑wɩ wo ꞊në wo 'ka. ");
INSERT INTO daf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","'Yö 'wo ‑ya ‑a \"slë mɔɔ‑ ‑sü ‑bha kö 'wo‑ 'kun, \"kɛɛ kö ‑wo \"suʋ̈ sië mɛ kpö bha‑ ‑nu ‑gɔ, ‑a ‑gɛn ‑mü ꞊dhɛ kö wo ‑zë ‑wo Yesu 'sü sië ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö dhiang 'bha zë 'zü \"tʋ ‑to ö ‑wʋ ‑bha ‑mɛ ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Atanna ‑bha ‑gblüdëdhɛ bha‑ ꞊tɛni ‑kë ꞊dhɛ ‑gblüdë do 'ö ö gbö ‑bha dhe 'sü ‑sü troo yi kpɔ ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","꞊Dhɛ 'ö troo bha‑ yi ꞊ya ꞊loo, 'yö ö ‑bha gwëëzë ‑nu bɔ 'mɛ 'ö‑ ‑nu ‑dhɛ troo bha‑ ‑ta bha‑ ‑nu ‑dhɛ ‑dhɛ 'gü, \"kɛɛ 'yö 'mɛ 'ö‑ ‑nu ‑dhɛ bha 'wo ‑kɔ. ");
INSERT INTO daf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","'Yö ‑ya mü 'zü 'ö mɛ 'bha bɔ 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka 'dho 'ka‑ pö‑ 'mɛ 'a‑ ‑nu ‑dhɛ bha‑ ‑nu ‑dhɛ ꞊dhɛ ‑bhöpë ꞊gbaan ma, 'ma ma ‑du ‑nu waa‑ ma ‑tuʋ̈ \"wɛɛ ‑nu 'ö ꞊wa \"yɔn kë ‑a ꞊gban zë, ‑a ‑gbɔ ꞊ya 'go pɛng ‑ta, ‑wo nu kö 'kwa dhe dɔ ‑pë bha‑ ‑bhö.» ");
INSERT INTO daf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","\"Kɛɛ 'yö 'mɛ 'ö‑ ‑nu ‑dhɛ bha 'wii wo \"tʋ kë ‑a ‑bha ꞊dhiɔwʋ bha‑ ‑bha, 'yö 'wo dho wo ‑mawɔn ‑nu kë ‑dhɛ 'gü. ‑A mɛ 'bha ꞊ya \"wlü 'yö dho ö ‑gɔ 'bhlaa‑, 'yö‑ mɛ 'bha ‑yö ꞊wlü 'yö dho ö ‑bha \"dhɔɔ dɔ ‑zian 'ka. ");
INSERT INTO daf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","'Yö‑ mɛ 'bha ‑nu ‑dɩ 'pö 'wo gwëëzë ‑nu bha‑ ‑nu kun 'wo‑ ‑nu ‑wëëdhɛ bho 'yö 'wo‑ ‑nu zë. ");
INSERT INTO daf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","‑A kë 'wo‑ wo \"dhʋ̈ bha, 'pu 'ö‑ wo ‑gblüdë bha‑ ‑bha ‑a ‑naa 'yii kë. 'Yö ö bha \"sɔdha ‑nu bɔ 'yö 'wo dho 'wo mɛzëmɛ ‑nu bha‑ ‑nu zë, 'yö 'wo‑ ‑nu ‑bha 'pö‑ ‑nu ‑gʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","꞊Dhɛ 'ö go mü, 'yö‑ pö ö ‑bha gwëëzë ‑nu ‑dhɛ ꞊dhɛ: «‑Dhɔkëpë ya ꞊ya ma, \"kɛɛ mɛ ‑blɛɛsü ‑nu 'a‑ ‑nu ‑dhɛ bha 'waa gun‑ ꞊bhlëë 'gü ‑mɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","꞊Dhɛ 'ö \"dhʋ̈, ‑ka 'dho zian ‑gloo ‑ta ‑dhɛ ‑nu 'gü 'dɔɔndhö, kö mɛ \"pɛpɛ 'ka dho ‑kpan ‑a ‑nu ‑bha kö 'ka‑ ‑nu ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑bha gwëëzë ‑nu bha 'wo dho zian ‑gloo ‑ta ‑dhɛ ‑nu 'gü 'yö 'wo 'wɔnsëkëmɛ ‑nu oo, 'wɔnyaakëmɛ ‑nu oo, mɛ \"pɛpɛ kö 'wo ‑kpan ‑bha, 'yö 'wo‑ ‑nu ‑dhɛ, 'yö ‑dhɔkëdhe ‑kë 'gü ‑kɔ bha 'ö pa. ");
INSERT INTO daf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","꞊Dhɛ 'ö mɛ ꞊ya 'kɔ pa ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö ‑gblüdë ‑yö nu kö 'ö ö \"yan ‑kpan 'mɛ 'wo nu ö ‑bha ꞊dhiɔwʋ ‑bha bha‑ ‑nu ‑bha. ꞊Dhɛ 'ö ꞊ya ‑da 'kɔɔdhö, 'yö ö \"yan ‑kpan gɔndë do 'bha ‑bha mü kö ‑dhɔkëdhe bha‑ ‑ta ‑sɔ ('ö‑ ‑pë ‑kë ‑a ‑yan ‑ta kö 'ö‑ ꞊gbaɔ 'mɛ 'wo dho ‑da 'kɔ bha‑ 'gü ‑a ‑nu ‑gɔ ꞊dhɛ ‑kɔ 'wo‑ ‑kë 'ka wo wɔ ‑kɔ 'gü ‑a 'dhö 'ö 'yaa 'mɛ 'ö‑ ‑gɔ 'yaa ‑da ‑dhɔkëdhɛ ‑kë 'gü ‑kɔ 'gü bha) 'yaa‑ ‑bha, ");
INSERT INTO daf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «N \"taɔngdë, i ‑da 'kɔ ya‑ 'gü ‑kɔ ‑kë ꞊dhɛ kö ‑dhɔkëdhe ‑ta ‑sɔ 'kö ya 'yaa i ‑bha? \"Kɛɛ dhɛɛ\" kpɔ 'ö bha‑ ‑yɔ 'yii‑ ꞊slɔɔ 'mɛ bha‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","'Yö ‑gblüdë ‑ya pö ö ‑bha gwëëzë ‑nu ‑dhɛ 'ö‑ pö: «‑Kaa 'kun 'ka‑ ‑kɔ waa‑ ‑gɛn ‑nu ‑lö kpɛnngkpɛnngdhö kö 'ka‑ ‑zuö ‑dhɛtiidhɛ 'gü \"kpɛnngdhö kö ‑yö ‑wëë ‑gbʋ bɔ kö ‑yö ö \"sɔn \"dhiʋ̈ ‑bhö 'ka klöklödhö. ");
INSERT INTO daf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö ö ‑wʋ \"zɔ dɔ 'ö‑ pö: «‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ mɛ 'ö Atanna ‑ya ‑nu ‑dhɛ kö ‑wo ‑ya ö ‑bha ‑ya 'gü bha ‑wo 'gbɛ \"dhʋ̈ tɛan‑ 'ka, \"kɛɛ mɛ 'dhɛ 'wo dho kë ‑a dhɔɔbhaamɛ ꞊dede 'ka 'ö 'wo dho 'to‑ ‑bha 'to 'gü ꞊në 'waa 'gbɛ. ");
INSERT INTO daf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","꞊Dhɛ 'ö Yesu ꞊ya bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö Fadhiziɛn ‑nu 'wo zun ‑a \"slë mɔɔ‑ ‑sü ‑bha kö 'wo‑ 'kun ‑a ‑dɩ ‑wʋ ‑bha, 'yö 'wo‑ ‑ya 'kwëë‑ ‑kë. ");
INSERT INTO daf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","'Yö 'wo woo‑ ꞊klangdhiʋ̈ ‑nu 'bha ‑nu waa‑ Edhodö ‑bha mɛ 'bha ‑nu bɔ Yesu \"piʋ̈, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi Dëmɛ, yi‑ 'wɔn ‑dɔ ꞊dhɛ i tɛanwɔn ꞊në‑ pö, 'ö 'i mɛ ꞊klang ‑nu ‑kë tɛanwɔn 'ö zian 'ö dho Atanna \"piʋ̈ ꞊në‑ ‑zɔn mɛ ‑dhɛ ‑a 'ka, 'bhaa \"suʋ̈ mɛ \"bhɩɩ‑ ‑nu ‑gɔ, ‑a ‑gɛn ‑mü ꞊dhɛ 'bhaa ‑kpla mɛ 'bha ‑gɔ ‑a ‑bha kë ‑tiandhö ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, 'nii‑ sɔng 'yi‑ bho sië Wlɔmö ‑mɛ ‑nu ‑bha ‑gblüdë 'kpii‑ ‑dhɛ ya ‑yö këwɔn 'ka, \"ɛɛn 'yaa këwɔn 'ka? i ‑bha 'ö 'i i ‑zʋ gɔn‑ 'ka ‑a pö yi ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","\"Kɛɛ 'ö gun \"dhʋ̈ kö Yesu ‑ya ‑nu zuëpiʋ̈wɔn ‑dɔ, 'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «꞊Flümɛ ‑nu 'ka ya, 'wɔn 'ö ka ‑zʋ \"piʋ̈ 'yaa kë \"dhʋ̈, n 'gü ꞊në 'ka nu‑ dan.» ");
INSERT INTO daf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","'Yö‑ pö: «‑Ka 'wëëga 'wo 'nii‑ sɔng bho‑ 'ka bha‑ do ‑zɔn n ‑dhɛ!» 'Yö 'wo \"tanmaga do nu‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","'Yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «De ꞊në‑ ‑gɔ \"blɛɛn‑ waa‑ ‑a 'tɔ 'wo 'wëëga ya‑ ‑ta ya?» 'Yö 'wo‑ pö‑ ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","«Wlɔmö ‑mɛ ‑nu ‑bha ‑gblüdë 'kpii‑ ‑mü.» 'Yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Kö ‑ka 'pë 'ö‑ ‑bha 'ka ‑a nu‑ ‑dhɛ kö 'ka‑ 'dhɛ 'ö Atanna ‑bha 'ka ‑a nu Atanna ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","꞊Dhɛ 'ö 'mɛ 'wo bha 'wo dhiang ‑yɔ 'ö Yesu ‑ya bɔ bha‑ ma, 'yö‑ 'wɔn ‑ya ‑nu kɔn 'yö 'wo‑ to 'mü 'wo ‑ziö. ");
INSERT INTO daf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","‑A yi do bha‑ 'ka 'yö 'mɛ 'wo ‑kë 'pö Sadusiɛn ‑nu 'ka 'ö 'wo‑ pö 'mɛ ꞊ya ga 'yaa ‑bö 'zü bha 'yö‑ mɛ ga 'bha 'wo nu Yesu \"piʋ̈ 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Yi Dëmɛ, Moizö ‑ya ‑pö yi 'bha 'ka ꞊dhɛ ꞊ya kë ꞊dhɛ mɛ 'bha ꞊ya ga kö 'në 'yaa‑ ‑mɛ ‑gɔ, ‑a ‑dhɛa ‑bha kö‑ ‑mɛ 'zlaa‑ ‑ya ‑mɛ ‑bha dhebhɔ bha‑ 'sü kö wɛng ‑wo 'në 'kpɔ ‑a ꞊dhoo 'ö ga bha‑ ‑bha 'kpɔ 'gü kö ‑yö kë‑ ꞊dhoo bha‑ 'tɔ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","\"Kɛɛ 'sa dheebhangzë ‑nu \"saɔplɛ 'bha ‑wo ‑gun yi kpö 'gü yi 'bha 'ka, 'yö‑ mɛ 'kpiisü ‑yö dhe sü 'yö dho 'ö ga kö 'wii 'në 'bha 'kpɔ. ꞊Dhɛ 'ö ‑kë ꞊dhɛ 'wii 'në 'kpɔ bha 'yö‑ ‑bha dhebhɔ bha 'ö ‑ya ‑a 'zlaa‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","‑A mɛ ꞊plɛ ‑naa bha 'zü waa‑ dhebhɔ bha 'wii 'në 'kpɔ 'yö ga, 'yö‑ mɛ ‑yaaga ‑naa ‑bha 'dhö ‑kë 'pö \"dhʋ̈ 'yö 'wo dho‑ 'ka \"dhʋ̈ \"dhʋ̈ \"dhʋ̈, 'yö dho 'ö zun‑ mɛ \"saɔplɛ ‑naa ‑bha, 'yö ga kö 'wii 'në 'kpɔ do. ");
INSERT INTO daf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","꞊Dhɛ 'ö‑ ‑nu ꞊gban ꞊wa ga, 'yö dhebhɔnë bha yöö ‑dɩ 'pö 'ö ga. ");
INSERT INTO daf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","꞊Ya kë \"dhʋ̈, yi 'ö 'mɛ ꞊wa ga 'wo dho ‑bö 'ka bha ꞊ya ꞊loo bha ‑oo, ‑a dhebhɔ bha‑ ‑dho kë mɛ \"saɔplɛ bha‑ de ‑sü ꞊në‑ ‑bha dhebhɔ 'ka kpɛnngdhö? Dhɛɛ\" 'yi‑ kpɔ \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu ꞊gban ‑wo kë‑ ‑sü dhe 'ka!» ");
INSERT INTO daf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Ka ka ‑dɩ ‑pö, ‑a ‑gɛn ‑mü ꞊dhɛ 'kaa 'pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü bha‑ dɔ. ꞊Ya 'go mü 'zü 'kaa Atanna ‑bha 'gügbɩɩdhɛ dɔ. ");
INSERT INTO daf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ 'mɛ ꞊wa ga ‑a ‑nu ‑bö ‑yi bha‑ 'ka, dhe 'sü ‑wɔn 'yii 'dho kë, \"ɛɛn gwaan‑ 'kpɔ ‑wɔn 'yii 'dho kë, mɛ ꞊gban‑ ‑dho ‑tosɛa kë ꞊dhɛ Atanna ‑bha \"kië ‑nu 'wo dhang‑ 'gü bha ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","‑A 'dhɛ 'ö ‑gban 'mɛ ꞊wa ga ‑a ‑nu ‑bö ‑sü ‑bha 'pö bha, 'pë 'ö Atanna ‑ya pö ka ‑dhɛ ‑a ‑bu 'gü 'kii‑ ma ꞊në wo do ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Atanna ‑ya ‑pö: ‹Ma ꞊në 'a Ablaamö ‑bha Atanna 'ka, 'a Izaakö ‑bha Atanna 'ka, 'yö 'a Zakɔbö ‑bha Atanna 'ka.› A‑ ‑pö ka ‑dhɛ ꞊dhɛ ꞊ya kë 'nu ꞊dhɛ 'mɛ ꞊ya ga kö ꞊ya ga 'yaa ‑bö 'zü, kö ‑a pö 'ö Atanna ‑ya wo \"dhʋ̈ bha‑ ‑gɛn 'yaa 'dhö, \"kɛɛ ‑yö kë ka \"yaan ꞊dhɛ mɛ 'yaa ga kö mɛ‑ 'to‑ 'gü, 'mɛ ꞊wa ga bha ‑wo \"yaan, 'wɔn 'ö‑ ‑wɔn 'gü 'ö‑ ‑nu 'tɔ pö ö ‑bha bha 'yö bha, ('yaa \"dhʋ̈ 'nu kö ‑yö ‑dho ‑a pö ma ꞊në 'a gun‑ ‑nu ‑bha Atanna 'ka). ");
INSERT INTO daf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","'Wɔn bha‑ ‑yɔ 'ö Yesu ‑ya bɔ \"dhʋ̈ bha, 'mɛ 'wo‑ ma ‑wo ‑gun kpö 'ka, \"kɛɛ ‑a 'wɔn ꞊në‑ ‑nu kɔn ‑zianwo. ");
INSERT INTO daf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","꞊Dhɛ 'ö Fadhiziɛn ‑nu waa‑ ma ꞊dhɛ dhiang ‑yɔ 'ö Yesu ‑ya bɔ Sadusiɛn ‑nu ‑gɔ bha yaa‑ ‑nu \"dhi ta ꞊wa 'dho, 'yö 'wo ꞊loo 'ko ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Yö‑ ‑nu ‑bha mɛ do 'ö kë Atanna ‑bha 'sëëdhɛ dɔ mɛ 'kpii‑ 'ka, 'yö Yesu dhɛɛ\" kpɔ ‑a 'gü dan kian 'ka 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«N Dëmɛ, Atanna ‑bha 'tɔng‑ ‑nu 'wo‑ ‑gɔ 'sëëdhɛ 'gü bha‑ ‑mɛɛ ‑sü ꞊dede ꞊në‑ ꞊bhlëësü 'ka?» ");
INSERT INTO daf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Tɔng‑ ‑nu bha‑ ꞊bhlëësü ꞊dede 'ö‑ 'gü yö ‑mü ꞊dhɛ: ‑A ‑dhɛa ‑bha kö i Dëmɛ i ‑bha Atanna bha a‑ ‑dhɔ ‑yö i kë 'böbödhö, kö 'i‑ ‑wɔn 'kun i 'nii‑ 'ka klöklödhö, kö‑ ‑dhɔ bha ꞊në ‑yö kë i ‑zʋgɔngüwɔn ꞊gban \"pɛpɛ ‑gɛn ‑gban ‑dhɛ 'ka bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Atanna ‑bha 'tɔng‑ ‑nu bha‑ 'dhɛ 'ö‑ ‑wɔn 'dhö \"gbɩɩ‑ 'ö ‑ziö ‑a ꞊gban \"pɛpɛ ‑ta 'yö bha. ");
INSERT INTO daf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","‑A ꞊plɛ ‑naa 'ö dɔ‑ 'dhɛ bha‑ \"piʋ̈, \"kɛɛ 'ö wɛng 'wo do yö ‑mü ꞊dhɛ: I këyɔɔ ‑dhɔ ‑yö i kë ꞊dhɛ ‑kɔ 'ö i ‑dɩ ‑dhɔ ‑yö i ‑dɩ kë‑ 'ka bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","‑Wʋ ꞊plɛ bha ꞊në Moizö ‑bha 'sëëdhɛ ꞊gban \"pɛpɛ waa‑ Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑bha ꞊gban zü ‑gban 'gü 'ka. ");
INSERT INTO daf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","'Ö gun kö Fadhiziɛn ‑nu ꞊wa ꞊loo 'ko ‑ta, 'yö Yesu ‑yö dhɛɛ\" 'kpɔ do ‑kë ‑nu ‑gɔ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ka ka ‑zʋ ‑gɔn Atanna bha ‑Yamɛ bha‑ ‑wɔn 'gü ‑kɔ kë ꞊dhɛ? Ka ka ‑zʋ ‑gɔn ꞊dhɛ ‑yö ‑dho 'go de ꞊në‑ suu 'gü?» ");
INSERT INTO daf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «‑Yö ‑dho 'go Davi ꞊në‑ suu 'gü.» 'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: \"Kɛɛ ‑yö ‑kë ‑mü ꞊dhɛ 'sa 'yö Davi ‑zë 'ö‑ ‑dhɛ Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑kɔ 'ka, n Dëmɛ? ‑A ‑gɛn ‑mü ꞊dhɛ Davi ‑ya ‑pö yö ꞊në‑ ‑bu 'gü yi 'bha 'ka 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Atanna ‑ya ‑pö n Dëmɛ ‑dhɛ: ‑Bhö ‑ya ‑yɛa ꞊bhlëësü ya‑ 'gü ‑yö 'dho‑ 'ka \"dhʋ̈ ‑yö zun‑ 'ka yi 'a dho i 'yaɔ‑ ‑nu ‑da 'ka i ‑gɛn ꞊wlöö bha‑ ‑bha!› ");
INSERT INTO daf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","‑A ‑kë \"dhʋ̈ ‑sü 'gü 'mɛ 'kö Davi ‑zë 'ö‑ ‑dhɛ ö Dëmɛ, ‑yö ‑mɔɔ ‑bha 'ö ‑kë yö ‑zë bhaanë 'ka ‑kɔ ‑kë ꞊dhɛ? ");
INSERT INTO daf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dhɛɛ\" 'kpɔ 'ö Yesu ‑ya wo \"dhʋ̈ bha‑ ‑yɔ 'yii ꞊slɔɔ mɛ do ‑zian ‑gɔ 'mɛ bha‑ ‑nu kpö 'gü kö ‑ya bɔ‑ ‑gɔ. ‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, 'ö sü yi 'dhɛ 'kö bha‑ ‑bha 'ö dho‑ 'ka \"dhiʋ̈, ‑a ‑nu 'bha 'wii‑ dhɛɛ\" 'kpɔ 'zü. ");
INSERT INTO daf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö zun dhiang ‑zë ö ‑bha ꞊klang ‑nu ‑dhɛ ‑sü ‑bha waa‑ mɛ kpö 'wo gun mü bha‑ ‑nu 'dhö 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu ‑wo dɔ sië Moizö ‑duɛ ꞊në‑ 'gü bha kö ‑wa ‑bha 'tɔng‑ ‑zɔn ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","꞊Dhɛ 'ö \"dhʋ̈ pë \"pɛpɛ 'wo dho‑ pö ka ‑dhɛ ‑kaa kë! \"Kɛɛ kɛng‑ ‑nu ka \"ta ‑kɔ ‑zë 'ya 'dho kë do, ‑a ‑gɛn ‑mü ꞊dhɛ ‑wo mɛ ‑nu ꞊klang ‑kë 'ka \"kɛɛ wo ‑zë 'waa‑ kë. ");
INSERT INTO daf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wo ‑zë ‑a ‑nu ‑bha 'tɔng‑ ‑zɔn ‑sü bha ‑yö ‑kë ꞊dhɛ ꞊kwɛɛ 'gbiin‑ dhu ‑sü kö ‑wa ‑ya mɛ ꞊gbin‑ bha ꞊në‑ 'dhö. ‑Wo mɛ ‑nu dɔ ꞊në‑ bho‑ 'ka, \"kɛɛ 'waa \"wɩ‑ ‑bha kö wo ‑zë ‑wo wo kɔngga do ‑zian ‑ya ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","‑Wo wo ‑bha 'wɔn ꞊gban ‑wɔn ꞊gban ‑kë kö mɛ \"bhɩɩ‑ ‑nu ꞊në ‑wa ‑nu yö. Yö ꞊në‑ ‑wɔn 'gü 'yö 'wo Atanna ‑wʋ \"kplükplü ‑nu ‑bɛn zë 'sëëdhɛ ‑ta, 'yö 'wo‑ ‑da wü kwi \"gbɛagbɛa ‑nu 'gü, 'yö 'wo‑ ‑ya wo ‑kpong \"dhiʋ̈ ‑dhɛ ‑nu waa‑ wo ‑gbe ‑bha ‑dhɛ ‑nu 'gü, 'yö‑ ‑nu ‑bha ꞊gbauu‑ ‑nu \"sɛɛ 'dhö ‑kë ꞊gblɛɛngblɛɛn. ");
INSERT INTO daf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Yö 'wo ‑yɛa ꞊bhlëësü ‑nu ꞊në‑ ꞊mɔɔ ‑dhɔkëdhe ‑ta ‑dhɛ ‑nu 'gü, 'yö 'wo ‑yɛa ‑sɛsɛngbɔ ‑nu ꞊në‑ ꞊mɔɔ kö 'wo ‑ya 'gü Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü, ");
INSERT INTO daf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'yö‑ ‑nu \"piʋ̈ ꞊dhɛ ‑wo wo ꞊në wo ꞊bhlëë ‑ya \"tʋ̈ng ꞊gban \"pɛpɛ 'gü \"dhɛɛdhɛ ‑nu 'gü kö mɛ ꞊gban \"pɛpɛ ‑wo wo ‑dhɛ ‹n Dëmɛ› bha, ");
INSERT INTO daf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","\"kɛɛ ka ‑zë 'ka 'dho \"wɩ‑ ‑bha 'wo ka ‑dhɛ wo Dëmɛ, ‑a ‑gɛn ‑mü ꞊dhɛ dheebhangzë ‑nu ‑mü mɛ ꞊gban ka 'ka. ꞊Ya 'go mü 'zü ka Dëmɛ 'ö 'dhö ‑yö dosengseng. ");
INSERT INTO daf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mɛ 'bha 'ya dho‑ pö 'ka ö ‑dhɛ \"kpʋng ꞊taa yö ka dë ‑a ꞊bhlëë ‑ya ‑wɔn 'gü 'ö 'ka ‑wɩ ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ ka Dë ‑yö doseng, yö ꞊në dhang‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'Ka 'dho \"wɩ‑ ‑bha 'zü 'wo ka ‑dhɛ wo dëmɛ, ‑a ‑gɛn ‑mü ꞊dhɛ ka Dëmɛ ‑yö doseng, yö ‑mü Atanna ‑bha ‑Yamɛ bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","'Mɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ö ‑duɛ 'kpii‑ ꞊slɔɔ ka kpö 'gü, ‑a ‑dhɛa ‑bha kö‑ ‑mɛ ꞊në ‑yö kë yë ‑kë ka ‑dhɛ ‑mɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö dho‑ pö 'ö ö ‑dɩ fië‑ bho ö \"tɛabɔ ‑nu ‑bha, Atanna ‑dho ‑a ‑mɛ ‑da ‑a \"tɛabɔ ‑nu ꞊wlöö. \"Kɛɛ 'mɛ 'ö dho \"wɩ‑ ‑bha kö ‑yö ö ‑dɩ ‑da ö \"tɛabɔ ‑nu ꞊gban ꞊wlöö bha, Atanna ‑dho ‑a ‑mɛ gba ‑duɛ 'kpii‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑ya pö Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu ‑dhɛ 'ö‑ pö: «'Tɔnggɔmɛ ‑nu kaa‑ Fadhiziɛn ‑nu, ka ‑bha ‑yö ‑wëësü, ꞊flümɛ ‑nu! ‑A ‑gɛn ‑mü ꞊dhɛ ka Atanna ‑bha ‑gblüdëdhɛ \"dhiʋ̈ ꞊në‑ ta mɛ ‑nu ‑gɔ. Kaa ꞊dede 'kaa \"wɩ‑ ‑bha kö ‑yö kë kaa‑ ‑gblüdë 'ka, \"kɛɛ 'sa 'kaa \"wɩ‑ ‑bha kö‑ ‑dhɔ 'dhö 'mɛ 'kö‑ ‑nu ‑bha ‑yö kë‑ ‑nu ‑bha ‑gblüdë 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","'Tɔnggɔmɛ ‑nu kaa‑ Fadhiziɛn ‑nu, ka ‑bha ‑yö ‑wëësü, ꞊flümɛ ‑nu, ‑a ‑gɛn ‑mü ꞊dhɛ ka ꞊në 'ka ꞊gɛandhe ‑nu ‑tabhö ‑sü ‑gɔ ‑bha, \"kɛɛ 'ka 'go mü 'sa 'yö 'ka ‑bhɛa Atanna ‑dhɛ ‑kɔ 'gü ꞊gblɛɛngblɛɛn ‑nu bha‑ ‑kë, kë \"dhʋ̈ kö ‑wo ka yö 'dhang ‑bho \"dhiʋ̈ ‑mɛ ‑nu 'ka. Yö ꞊në‑ ‑wɔn 'gü, 'yö 'wɔn 'ö Atanna dho‑ wɔ ka ‑ta 'yö dho kë ‑ziisü. ");
INSERT INTO daf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ka ‑bha ‑yö ‑wëësü, 'tɔnggɔmɛ ‑nu kaa‑ Fadhiziɛn ‑nu, \"gblʋ̈ʋ̈dhɛtiimɛ ‑nu, ‑a ‑gɛn ‑mü ꞊dhɛ ka \"ta ‑kpɔ \"kpʋngtaadhɛ ꞊gban \"pɛpɛ 'gü, \"ɛɛn ꞊weeyi ‑ta ‑dhɛ ‑nu 'gü kö 'mɛ 'yaa Zuifö 'ka, \"kɛɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ö ‑da Zuifö ‑nu ‑bha ‑bhɛa Atanna ‑dhɛ ‑kɔ 'gü bha 'ka‑ yö, kö 'ka‑ kë ‑dho pɛng ‑kaso 'ö ꞊geebɔɔ ‑a 'gü ‑mɛ 'ka, 'yö 'ka‑ ‑kë 'yö‑ ‑mɛ ‑bha ‑kë pë yaa 'ka ‑sü \"dhiʋ̈ ‑yö ‑ziö ka ‑bha ‑zë ‑ta ‑gɛn ‑yan 'ka ꞊dhɛ pë ꞊plɛ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Zian ‑bho mɛ 'ka ‑mɛ \"yan 'wü ‑sü ‑nu, ka ‑bha ‑yö ‑wëësü! ‑A ‑gɛn ‑mü ꞊dhɛ ka‑ ‑pö ꞊dhɛ: Mɛ ꞊ya ‑sö ‑bhö Atanna ‑dhɔkëgükɔ 'tɔ 'gü kö ‑sö ‑bhö ‑sü 'yaa \"dhʋ̈, \"kɛɛ 'mɛ 'ö ‑sö ‑bhö \"sënng 'ö‑ ‑dhɔkëgükɔ 'gü bha ꞊në‑ 'tɔ 'gü kö ꞊ya ‑sö ‑bhö ꞊dedewo.» ");
INSERT INTO daf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","‑Gɔgütiimɛ ‑nu, \"yanwlümɛ ‑nu! Pë ꞊plɛ bha‑ ‑mɛɛ ꞊në‑ ꞊bhlëë 'dhö 'kpii‑? ‑A \"sënng bha \"ɛɛn ‑a Atanna ‑dhɔkëgükɔ 'kö‑ \"sënng ‑kë \"slʋ̈ʋ̈slʋ̈ bha‑ yö ‑mü ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","'Ka 'go mü 'zü, 'yö 'ka‑ pö ꞊dhɛ: 'Mɛ 'ö ‑sö ‑bhö \"saa‑ ‑bho ‑ta ‑pë 'tɔ 'gü kö 'yii ‑sö ‑bhö. \"Kɛɛ 'mɛ 'ö‑ ‑bhö \"saapë 'ö \"saabhotapë ‑ta bha ꞊në‑ 'tɔ 'gü kö ꞊ya ‑sö ꞊dede ‑bhö. ");
INSERT INTO daf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","‑Gɔgütiimɛ ‑nu! Pë ꞊plɛ bha‑ ‑mɛɛ ꞊në ꞊bhlëësü? \"Saabhodhɛ ‑ee ɛɛn \"saapë ‑ee? 'Sa \"saabhodhɛ ꞊në \"saapë ‑kë ꞊bhlëësü. ");
INSERT INTO daf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","A‑ ‑pö ka ‑dhɛ ꞊dhɛ mɛ 'ö ‑sö ‑bhö \"saabhodhɛ 'tɔ 'gü kö ‑ya ‑bhö \"saapë ‑nu ꞊gban ꞊në‑ 'tɔ 'gü bha. ");
INSERT INTO daf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","'Mɛ 'ö ‑sö ‑bhö 'zü Atanna ‑dhɔkëgükɔ 'tɔ 'gü, kö ‑ya ‑bhö Atanna 'ö‑ 'kɔɔdhö ‑mü bha ꞊në‑ ꞊gban 'tɔ 'gü bha. ");
INSERT INTO daf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'Mɛ 'ö ‑sö ‑bhö dhang‑ 'tɔ 'gü kö ‑ya ‑bhö Atanna ‑bha ‑gblüdëdhɛ ‑gblooa‑ yö 'ö‑ ‑yɛa 'dhö ‑mü bha ꞊në‑ ‑nu 'tɔ 'gü bha. ");
INSERT INTO daf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Fadhiziɛn ‑nu kaa‑ 'tɔnggɔmɛ ‑nu, ka ‑bha ‑yö ‑wëësü, ꞊flümɛ ‑nu! ‑A ‑gɛn ‑mü ꞊dhɛ pë ‑nu ‑zian 'ö‑ ‑zun \"dhiʋ̈ ‑bhlɔɔ 'yaa 'dhö ꞊dhɛ kpiëng ‑nu, \"dhʋngbhɛɛ ‑nu, \"ɛɛn siɔnng\" ga ‑nu 'dhö bha ka wo ‑zë ꞊gban \"pɛpɛ 'nii‑ ‑bho Atanna ‑dhɛ, \"kɛɛ 'yö 'ka ka ‑ta yö mɛ draan‑ ‑wʋ 'kö‑ ‑wɔn 'dhö \"gbɩɩ‑, 'ö ‑kë Atanna ‑bha 'tɔng‑ 'ka ꞊dhɛ, ‑kë kpengdhö ‑sü ‑nu oo, \"klʋsëdhɛ ‑nu oo, ‑to ‑wʋ ‑ta ‑sü ‑nu 'dhö bha wo ‑zë ‑a ‑nu ‑bha, \"kɛɛ 'sa kö yö ꞊në kë ‑pë 'ka ‑blɛɛsü 'yö‑ ‑kpɛa ‑yö gun ‑na dɔ‑ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Zian ‑bho mɛ 'ka ‑mɛ \"yan 'wü ‑sü ‑nu! Ka 'ö 'ka ka mü ‑we ‑ziö ‑pee 'gü kë \"dhʋ̈ kö ꞊flanflannë ‑zian 'ya 'dho 'to‑ ꞊bhaa 'ö 'ka‑ mü‑ 'ka bha, \"kɛɛ 'sa ka pë \"gblʋ̈gblʋ̈ ‑zë ‑mëng! ");
INSERT INTO daf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ka ‑bha ‑yö ‑wëësü, 'tɔnggɔmɛ ‑nu, Fadhiziɛn ‑nu, ꞊flümɛ ‑nu! ‑A ‑gɛn ‑mü ꞊dhɛ ka ꞊dhɛ 'mɛ 'ö \"yitakɔɔ ‑nu waa‑ pë ‑bhö 'gü ‑tɛa ‑nu kwi ‑bha ‑dhɛ ‑zë ‑zu, \"kɛɛ 'ö‑ 'gü ‑zian ‑zë to \"dhʋ̈ ꞊në‑ 'dhö. (Ka 'wɔn 'në sɛɛnnë ‑nu 'kö bha‑ ‑kë ꞊dhɛ ‑kɔ bha‑ 'dhö kë \"dhʋ̈ kö 'ka bhɔ mɛ ‑nu 'gü Atanna ꞊bhlëëyamɛ ‑nu ‑bha \"kɛɛ kö) ka 'kɔɔ ‑zian ‑zë ‑yö pa ‑sü 'ka kaa‑ ꞊kwaanpë ‑nu waa‑ pë yaya ‑nu 'ö ka zuë\" ‑yö bhɔ‑ ‑bha bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fadhiziɛn ‑nu, \"yanwlümɛ ‑nu! ‑Ka kaa‑ pë ‑bhö 'gü ‑tɛa ‑nu 'gü ‑dhɛ \"zu ꞊kö ‑blɛɛsü kö 'ka gun ‑na ‑bha ‑dhɛ \"zu kö ‑yö kë \"puu! ");
INSERT INTO daf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ka ‑bha ‑yö ‑wëësü, Fadhiziɛn ‑nu kaa‑ 'tɔnggɔmɛ ‑nu, \"gblʋ̈ʋ̈dhɛtiimɛ ‑nu! ‑A ‑gɛn ‑mü ꞊dhɛ ka ‑bhɔ bun ö ꞊wa \"yɔɔ \"puu ‑da ‑bha ꞊në‑ ‑bha. 'Bha‑ kwi ‑bha ‑dhɛ yö i‑ pö pë ‑së ‑zë 'bha ꞊nɛ, \"kɛɛ kö‑ 'gü ‑zian ‑zë ‑yö pa ‑sü 'ka mɛ ga zlɔɔ\" waa‑ pë \"busü ‑dɩ ‑slɔɔ ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","‑Kɔ do bha ꞊në 'ka‑ ‑bha, ꞊wa ka ‑ga ka kwi ‑bha ka ‑bhɔ mɛ ‑nu 'gü 'mɛ 'ö pö 'aa‑ ‑bha ‑a ‑bha, \"kɛɛ ka \"gblʋ̈ʋ̈dhɛ ‑zë ‑yö pa ‑sü 'ka \"kpënng‑ ‑kë mɛ ‑nu ‑gɔ ‑sü waa‑ 'wɔn yaa \"wɛɛ 'gbɛ ꞊në‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","'Yö go mü 'ö‑ pö: «Ka ‑bha ‑yö ‑wëësü, 'tɔnggɔmɛ ‑nu kaa‑ Fadhiziɛn ‑nu, \"gblʋ̈ʋ̈dhɛtiimɛ ‑nu! ‑A ‑gɛn ‑mü ꞊dhɛ ka Atanna ‑wʋdhiʋ̈loomɛ ‑nu bun ‑nu ‑pë ‑kë ‑së 'ka, 'ö 'ka 'mɛ 'ö pö 'aa‑ ‑nu ‑bha ‑tosɛa ‑bha 'pö ꞊dhɛ ‑a ‑nu 'dhö bha‑ ‑nu bun ‑pë ‑kë ‑së 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Ö 'ka‑ pö ꞊dhɛ: ‹꞊Ya kë 'nu ꞊dhɛ yi ‑tosɛa ‑kë yi \"bhɛma ‑nu ‑bha \"tʋ̈ng 'gü kö yi ‑wʋ 'yii 'dho kë‑ ‑nu ‑bha \"piʋ̈ Atanna ‑wʋdhiʋ̈loomɛ ‑nu zë ‑wɔn 'gü.› ");
INSERT INTO daf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","꞊Ya kë \"dhʋ̈ kö kaa ꞊dede ka‑ 'wɔn ‑dɔ ꞊dhɛ 'mɛ 'wo Atanna ‑wʋdhiʋ̈loomɛ ‑nu zë bha‑ ‑nu 'gü ‑në ‑nu ‑mü ka 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","꞊Dhɛ 'ö \"dhʋ̈ kö ‑ka ka 'gü dɔ \"gbɩɩ‑ kö yë 'ö ka \"bhɛma ‑nu ‑wa zü bho bha 'ka‑ \"dhiʋ̈ ‑ya! ");
INSERT INTO daf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","꞊Flümɛ ‑nu 'ka ya! ꞊Ya kë \"dhʋ̈ ka ‑dho dha ‑kɔ kë ꞊dhɛ ‑wëëdhɛ bhodhe 'ö ꞊geebɔɔ pɛng 'gü bha‑ ‑gɔ? ");
INSERT INTO daf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","꞊Dhɛ 'ö \"dhʋ̈ ‑ka ka \"tʋ to, a ‑dho Atanna ‑wʋdhiʋ̈loomɛ ‑nu bɔ ka ‑dhɛ waa‑ mɛ ꞊kpaɔsü ‑nu waa‑ 'wɔndɔmɛ ‑nu 'dhö. Ka ‑dho mɛ 'bha ‑nu zë 'ö 'ka‑ mɛ 'bha ‑nu dɔ \"dhü ‑bha 'ö 'ka dho 'ka‑ mɛ 'bha ‑nu ‑ma ‑nu wo ꞊klangga 'ka kaa‑ ‑yakwëëkëgükɔ ‑nu 'gü 'ö 'ka‑ ‑nu ‑wëëdhɛ bho 'pö‑ ‑nu 'gü 'ka ‑ziö 'ka. ");
INSERT INTO daf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kë \"dhʋ̈ kö Atanna ‑bha mɛ ‑nu 'wo‑ ‑nu zë \"wlaa‑ 'gü \"wɛɛwɛɛ 'wo ‑bhɔ 'ka yi 'bha 'ka 'ö‑ zü ‑yö bho Abɛdhö 'ö pö 'aa gun‑ ‑bha bha‑ ‑ta 'ö dho 'ö zun‑ 'ka Zakadhi 'ö ‑kë Badhasi gbö 'ka 'ö 'ka‑ zë Atanna ‑dhɔkëgükɔ 'gü, \"saabhodhɛ waa‑ Atanna ‑dhɔkëdhɛ ꞊dede ‑a ‑nu ꞊zinng 'gü bha‑ ‑bha bha‑ \"dhang ‑yö ka ꞊në ka 'kun. ");
INSERT INTO daf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: 'Mɛ 'wo‑ ‑nu zë 'dɔɔndhö \"dhʋ̈ bha‑ 'gü ‑wɔn ‑dho nu 'mɛ 'wo \"tʋ̈ng ya‑ 'gü ya ꞊në‑ ‑nu ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","'Yö Yesu ‑ya pö: «Zedhizadhɛmö ‑mɛ ‑nu, Zedhizadhɛmö ‑mɛ ‑nu, ka 'ö 'ka Atanna ‑wʋdhiʋ̈loomɛ ‑nu zë sië 'ö 'ka‑ mɛ 'bha ‑nu ‑zuö sië ‑gwë 'ka 'ka‑ ‑nu zë‑ 'ka bha, 'ma‑ \"slë mɔɔ‑ ‑kɔ ꞊gban ‑kɔ ꞊gban 'gü kö 'a ka ꞊loo 'ko ‑ta ꞊dhɛ ‑kɔ 'ö ‑tɔ ‑dhee ‑yö ö 'në ‑nu ꞊loo‑ 'ka ö gban ꞊wlöö bha‑ 'dhö, \"kɛɛ 'kii‑ ‑yɔ bɔ n ‑gɔ! ");
INSERT INTO daf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","‑Ka ‑dhɛ ‑ga, a ‑dho n kwaa‑ ka ‑wɔn ‑zü 'ö ka ‑yɛabhaadhɛ ‑yö to \"fië. ");
INSERT INTO daf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","‑Ka ‑dhɛ ‑ga! A‑ pö ka ‑dhɛ ꞊dhɛ 'ö sü \"tʋ̈ng ya‑ ‑bha 'ö dho 'ö zun‑ 'ka \"tʋ̈ng 'ka dho‑ pö‑ 'ka ꞊dhɛ 'dhuë‑ ‑yö 'to 'mɛ 'ö dho nu kwa Dëmɛ 'tɔ 'gü bha‑ ‑ta bha‑ ‑bha, 'kii 'dho n yö 'zü. ");
INSERT INTO daf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","꞊Dhɛ 'ö Yesu ‑ya ö bo dhiang ‑nu bha‑ ‑nu zë ‑sü 'ka, 'yö go Atanna ‑dhɔkëgükɔ bha‑ 'gü 'yö dho. ꞊Dhɛ 'ö 'dho sië 'yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ, 'yö 'wo‑ pö‑ ‑dhɛ 'wo‑ pö: «Yi Dëmɛ, Atanna ‑dhɔkëgükɔ ya i \"yan ‑ya ‑bha \"wɛ ‑ee? ‑A dhi ‑kɔ bha‑ ‑ga bha!» ");
INSERT INTO daf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","\"Kɛɛ ꞊dhɛ ꞊waa‑ pö \"dhʋ̈, 'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Ka \"yan ‑yö pë ‑nu bha‑ ‑nu ‑bha ‑ee? ‑Ka ‑dhɛ ‑ga! A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: 'Kɔ 'ka‑ ‑ga sië bha‑ ‑gwë kpö do ‑zian 'yii 'dho 'to 'ko ‑ta \"dhʋ̈ng 'gü, ‑a ꞊gban ‑dho 'wü trëntrëndhö.» ");
INSERT INTO daf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo Odhivie ‑tɔn ꞊gbin‑, 'yö Yesu ‑yö dho \"sia‑ 'yö 'yaanu, 'yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ ꞊plɛ 'gü 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi Dëmɛ, 'wɔn ‑nu 'i go‑ ‑pö yi ‑dhɛ ‑dhɛ 'gü ya, ‑wo ‑dho kë \"dhʋ̈ ‑më \"tʋ̈ng ꞊në‑ 'gü, \"ɛɛn ꞊ya kë ꞊dhɛ 'bha 'dho dhang‑ 'gü i \"dhiʋ̈ yee kë ‑sü waa‑ \"sɛ \"dhiʋ̈toyi ‑nu bha, yi ‑dho ‑a ‑nu 'suan‑ bho ‑më ‑nu ꞊në‑ ‑bha?» ");
INSERT INTO daf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Ka ‑dhɛ ‑ga, ‑ka ka ‑zʋ kë ka ‑dɩ \"piʋ̈ kö mɛ 'bha 'ya 'dho \"kpënng‑ kë ka ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","‑A ‑gɛn ‑mü ꞊dhɛ mɛ 'gbɛ‑ ‑dho nu n 'tɔ 'gü 'ö 'wo‑ pö ꞊dhɛ wo ꞊në 'wo Atanna ‑bha ‑Yamɛ bha‑ 'ka. ‑Wo ‑dho \"kpënng‑ kë mɛ 'gbɛ ‑gɔ 'ö 'wo‑ ‑nu ‑kan Atanna ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","꞊Ya 'go yö ‑zë 'gü, ka ‑dho ‑gblü ‑da ‑wɔn ‑nu ma ka ‑züzü ‑dhɛ ‑nu 'gü 'ö 'ka‑ ‑taɔng ‑nu ma ‑dhɛ ꞊gblɛɛn 'gü, \"kɛɛ ꞊ya kë \"dhʋ̈ ka \"gblʋ̈ʋ̈dhɛ 'ya 'dho \"muu bho, ‑ka ka ‑zʋ ‑gban, ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn ‑nu 'bha ‑wo ‑dho kë gbonggbongdhö 'yii 'dho 'to‑ 'gü, \"kɛɛ 'sa kö \"kpʋngtaadhɛ \"dhiʋ̈toyi 'yii ꞊loo ꞊kö. ");
INSERT INTO daf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","\"Sɛgɔ 'bha‑ ‑dho \"wlü 'ö ‑pö \"sɛgɔ 'bha‑ ‑ta 'ö 'wo ‑gblü gɔɔn, 'ö ‑gblüdë 'bha ‑yö ꞊wlü 'ö dho 'ö ‑gblü ‑da ‑gblüdë 'bha ‑ta, 'ö \"vʋ̈ʋ̈ ‑yö ‑da, 'ö \"sɛ ‑yö ꞊zii \"sɛgɔ 'bha ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","\"Kɛɛ yö ‑zë ꞊gban ‑dho kë ꞊dhɛ 'në 'kpɔ \"gblükë zü bho ‑sü ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","꞊Ya 'go yö ‑zë 'gü, ka ‑san ‑dho mɛ \"bhɩɩ‑ ‑nu kë 'ö 'wo ka \"dhiʋ̈ dɔ ‑gɔmɛ ‑nu ‑dhɛ, 'ö 'wo ka ‑wëë ‑kë wo 'ö 'wo ka zë ‑nu wo n ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mɛ 'gbɛ ꞊dede ‑dho 'go Atanna ‑bha zian ‑ta ‑a \"tʋ̈ng bha ꞊në‑ 'gü 'ö 'wo wo 'ko ‑nu ‑san ‑kë 'ö 'wo ‑da wo 'ko ‑nu ‑dhɛ pë \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","'Ö Atanna ‑wʋdhiʋ̈loomɛ ꞊flüsü ‑nu 'wo nu 'wo‑ \"kpënng‑ ‑kë mɛ 'gbɛ ‑gɔ 'ö 'wo‑ ‑nu ‑kan Atanna ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'Wɔn yaa kë ‑sü ‑dho kë ꞊dhɛ \"yi 'dhö 'ö pa, 'ö \"sanni ‑yö dɔ 'mü kö pë 'wo‑ ‑dhɛ ‑dhɔ, mɛ 'bhaa‑ dɔ 'zü. ");
INSERT INTO daf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","\"Kɛɛ 'mɛ 'ö dho ö 'gü dɔ \"gbɩɩ‑ 'ö 'dho 'ö zun‑ \"dhiʋ̈todhɛ ‑bha ‑yö ‑dho dha. ");
INSERT INTO daf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","'Wɔn ‑taɔng ‑së 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑wɔn ‑bha bha ‑wo ‑dho ‑a ‑dhiang zë \"sɛ ꞊gban \"pɛpɛ 'gü kö mɛ ꞊gban \"pɛpɛ \"tʋ ‑yö ‑da n ‑wɔn 'gü. Yö ꞊në ꞊ya bo ‑kë \"dhʋ̈ ‑sü 'ka \"pɛɛpɛdhö, 'yö \"kpʋngtaadhɛ \"dhiʋ̈ yöö 'to 'yö gun ‑na 'to.» ");
INSERT INTO daf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","'Yö‑ pö: «\"Sɛ yën \"tʋ̈ng bha 'ö 'to sië klöö\" \"tʋ̈ng 'ö‑ 'gü, ka \"yan‑ ‑dho ‑da pë yaa ‑yënng ‑yënngsü 'ö Atanna ‑wʋdhiʋ̈loomɛ Daniɛ ‑ya ‑dhiang zë yi 'bha 'ka, Atanna ꞊bhlëë ‑siö ‑pë 'ka bha‑ ‑bha kö ‑yö ‑ya sië‑ ‑dhɔkëdhɛ \"slʋ̈ʋ̈slʋ̈ 'ö 'yaa‑ ‑yɛa 'ka bha‑ 'gü. ('Yö Matiö ‑ya pö) 'mɛ 'ö dho 'sëëdhɛ ya‑ ‑wʋ pö, ‑a ‑mɛ ‑ya 'gü ma ö 'klɔɔ‑ 'ka! ");
INSERT INTO daf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","‑A \"tʋ̈ng bha‑ 'gü, 'mɛ 'wo dho kë Zude ‑sɛ 'gü ꞊waa‑ pö 'wo ziö ‑bɛang 'ka ‑a ‑dhɛa ‑bha kö ‑wo wo wë dɔ ‑tɔn ‑gbeng 'gü ‑zian ꞊në‑ 'ka kö ‑wo 'dho wo ‑gblɛn 'kpɔ mü. ");
INSERT INTO daf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","‑A \"tʋ̈ng bha yaa‑ wo 'mɛ 'ö‑ ‑bha kö ‑yö \"kpɛnng, 'ya 'dho‑ pö 'ö 'dho pë 'bha 'sü ö ‑gɔ 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","‑Ɛɛ 'mɛ 'ö yaa‑ kë 'zü ö ‑gɔ 'bhlaa‑, 'ya 'dho‑ pö 'ö ö yee kë kö 'ö 'dho ö ‑bha ꞊gbauu‑ 'sü ‑dhɛ 'gü 'pödhö. ");
INSERT INTO daf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","‑A \"tʋ̈ng bha‑ 'gü, dhong ‑nu 'ö waa‑ ‑kë 'gbiödhe 'ka, \"ɛɛn 'ö 'në ꞊yaa‑ ‑kë ‑a ‑nu ‑gɔ 'yɔn ‑bha ‑a ‑nu ‑bha ‑dho kë ‑wëësü ꞊dedewo! ");
INSERT INTO daf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","‑Ka bhɛa\" Atanna ‑dhɛ kö ka ‑bha ꞊dua ‑sü ‑gɛn 'ya 'dho ‑ya \"nɛnɛ yi ‑bha \"ɛɛn Atanna ‑bha ꞊glooyi ‑bha! ");
INSERT INTO daf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","‑A ‑gɛn ‑mü ꞊dhɛ ‑wëëwɔn ‑nu 'wo dho kë \"tʋ̈ng bha‑ 'gü bha, ‑yö ‑dho kë ‑ziisü ꞊dedewo. 'Ö sü \"kpʋngtaadhɛ kë ‑yi ‑bha 'ö nu 'ö zun‑ 'ka ꞊dɛɛ ‑bha, ‑a suu 'yii kë do, 'sa ‑a ‑bhɔ ‑bha 'yii 'dho kë 'pö 'zü 'ö to‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","꞊Ya kë ꞊dhɛ Atanna 'yii ‑dhɛkpaɔyi bha‑ 'bha \"kan‑ \"dhiʋ̈ 'nu ‑zianwo kö ‑dha 'wɔn bha‑ ‑gɔ ‑mɛ 'yii 'dho ꞊slɔɔ. \"Kɛɛ ‑kë ‑së \"kë \"së, Atanna ꞊yaa‑ 'bha bho‑ \"dhiʋ̈ 'mɛ 'ö‑ ‑nu sü ö ‑bha 'ka bha‑ ‑nu ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‑A \"tʋ̈ng bha ꞊ya ꞊loo, mɛ \"ʋʋ mɛ 'ö‑ pö ka ‑dhɛ ꞊dhɛ: ‹Atanna ‑bha ‑Yamɛ bha ‑yö yö!› \"ɛɛn ‹‑Yö ‑dhɛ 'bha 'gü tii‑ ‑dhe!› 'ka 'dho 'dhang bho‑ \"dhiʋ̈! ");
INSERT INTO daf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","‑A ‑gɛn ‑mü ꞊dhɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mɛ 'wo dho‑ pö wo ‑dɩ ‑dhɛ ꞊dhɛ wo ꞊në 'wo Atanna ‑bha ‑Yamɛ bha‑ 'ka, waa‑ Atanna ‑wʋdhiʋ̈loomɛ ꞊flüsü ‑nu ‑dho nu \"tʋ̈ng bha‑ 'gü, 'ö 'wo \"slë \"gblʋ̈gblʋ̈ ‑nu ‑kë 'ö 'wo \"dhabhliwɔn ‑nu ‑kë, kë \"dhʋ̈ kö aa\" ꞊ni 'mɛ 'ö Atanna ‑ya ‑nu sü ö ‑bha 'ka bha, ‑a ‑nu ‑kɔ ‑zë ꞊ya ꞊mɔɔ‑ ‑bha kö ‑wa ‑nu \"kan Atanna ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","‑Ka ‑dhɛ ‑ga! 'Wɔn bha 'ma‑ 'to mü ꞊gblɛɛn 'ma‑ pö ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‑A ‑kë \"dhʋ̈ ‑sü 'gü, kö 'zü ꞊ya kë ꞊dhɛ mɛ ‑zian ꞊në ꞊ya nu ꞊yaa‑ pö ka ‑dhɛ ꞊dhɛ ‹Atanna ‑bha ‑Yamɛ bha ꞊ya nu, ‑yö \"tʋngtadhɛ ya‑ 'gü!› \"ɛɛn ‹‑Yö ‑dhɛ 'ö ‑kë ꞊ni‑ 'gü!› 'ka 'dho 'dhang bho‑ \"dhiʋ̈ tongtongdhö \"ɛɛn 'ka 'dho 'dho mü. ");
INSERT INTO daf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","‑A ‑gɛn ‑mü ꞊dhɛ mang Mɛgbömɛ n nu ‑sü ‑zë ‑yö ‑dho kë ꞊dhɛ ‑kɔ do 'ö dha ‑yö \"yan kun‑ 'ka dhang‑ 'gü, 'ö ‑gban 'yënng‑ ‑wo ‑zian 'ka, 'ö \"dhiʋ̈ ta 'yënng‑ ‑pö ‑zian 'ka bha ꞊në‑ 'dhö, 'yii 'dho ‑bin mɛ 'bha ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‑A ‑gɛn ‑mü ꞊dhɛ ‑kɔ do 'ö pë ꞊gee 'dhö ‑dhɛ 'ö‑ ‑bha ‑a ‑dhɛ yö ‑sü 'yaa ꞊gbaɔn \"gblëë‑ ‑nu ‑ta bha, ꞊në mang Mɛgbömɛ n nu ‑sü dho kë‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","'Yö‑ pö: «\"Kɛɛ ‑wëëwɔn \"nɛnɛgasü 'a‑ ‑dhiang zë ka ‑dhɛ bha‑ ‑dhɛkpaɔyi ya bo zun ‑sü 'ka 'ko \"dhiʋ̈, 'yënng‑ ‑dho 'to ‑dhɛ do bha‑ 'gü 'ö ꞊tröö ‑blünblündhö, 'ö \"su ‑yö ö bo 'bhü ‑sü 'ka, 'ö \"susëngga ‑nu 'wo dhang‑ ‑bha 'wo go 'mü 'wo ꞊wɛnng. 'Ö ‑ta \"mlüü bɔ ‑pë ‑nu 'wo dhang‑ 'gü 'wo go \"gblʋ̈ʋ̈‑. ");
INSERT INTO daf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yö ꞊në ꞊ya kë \"dhʋ̈, 'yö 'wɔn 'suan‑ ‑bho ‑bha ‑pë 'ö dho‑ ‑zɔn ‑dhɛ mang Mɛgbömɛ n nu \"tʋ̈ng ꞊ya ꞊loo bha 'ö ‑wo \"yɛa‑ dhang‑ ‑bha, 'yö \"sɛgɔ \"pɛpɛ 'wo \"kpʋng ꞊taa ‑a 'gü ‑mɛ ‑nu ꞊gban \"pɛpɛ 'wo ‑ya ‑wʋ 'kpɔ ‑sü ‑bha ꞊tɔn, kö ‑wo wo ‑kuu ‑ta ‑ma sië \"gbʋ 'ka, 'yö 'wo wo \"yan ‑kpan mang Mɛgbömɛ n ‑bha kö a nu sië dha 'kpong‑ ‑ta dhang‑ 'gü, 'gügbɩɩdhɛ waa‑ 'tɔbhɔdhe ‑ziisü 'ka. ");
INSERT INTO daf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","\"Truu 'kpii‑ bha ‑yö ‑dho \"wɩ 'yi bha ꞊në‑ 'ka, 'yö 'a ma \"kië ‑nu bɔ \"kpʋngtaadhɛ ꞊gban \"pɛpɛ 'gü, 'yö 'wo 'mɛ 'a‑ ‑nu sü n ‑bha 'ka bha‑ ‑nu sü ‑dhɛ \"pɛpɛ bha‑ ꞊gban 'gü, 'yö 'wo‑ ‑nu ꞊loo 'ko ‑ta ‑dhɛ do 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","'Yö 'go mü 'ö‑ pö: «‑Ka 'wɔn 'suan‑ bho 'wɔn ‑zɔn 'ka 'ö maa‑ ‑zɔn ka ‑dhɛ bha ꞊në‑ ‑bha. Yö ‑mü ꞊dhɛ \"tʋ̈ng 'ö figö ‑dhü 'dhö ö ‑gbeng ‑dee dɔ sië, 'ö ö \"dhɛ ‑dee ‑ya sië kö 'ka‑ 'wɔn dɔ ꞊dhɛ blɛa\" ꞊ya ziö, ‑nɛɛ 'gü ꞊ya ꞊loo. ");
INSERT INTO daf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","‑Kɔ do bha‑ 'gü, ka \"yan 'dhö ‑da sië 'wɔn ‑nu 'a ‑ziö 'gü bha‑ ‑nu 'gü, ‑kaa 'wɔn dɔ ꞊dhɛ ‑a \"tʋ̈ng ꞊ya ꞊tëng, ꞊dhɛ 'ma ‑ya \"saan ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'wo \"yaan ꞊dɛɛ ‑yën ya‑ 'gü ya, ‑a ‑nu ꞊gban 'wii 'dho ga 'ö 'wɔn 'a‑ pö sië ka ‑dhɛ bha‑ ꞊gban 'gü ‑wɔn ‑yö ‑kë. ");
INSERT INTO daf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","‑Yö kë ka \"yaan ꞊dhɛ \"sɛ waa‑ dhang‑ ‑wo ‑dho ziö, \"kɛɛ n ‑wʋ ‑zë do 'yii 'dho 'go \"gblʋʋ tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","'Yö go mü 'ö‑ pö: «꞊Ya 'go yö ‑zë 'gü, ‑a 'dhɛ 'kö ‑gban n nu ‑yi waa‑ n nu \"tʋ̈ng ꞊dede ‑zë ‑bha bha, Atanna ‑bha \"kië ‑nu oo, ‑a mang ‑zian 'a‑ Gbö 'ka 'a \"wɩ sië ka ‑dhɛ ya mɛ 'bha 'yaa yö ‑zë dɔ kö 'yii kë n Dë Atanna ‑zë 'ka. ");
INSERT INTO daf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","'Wɔn do 'ö ‑kë Noe ‑bha \"tʋ̈ng 'gü ꞊në dho kë mang Mɛgbömɛ n nu ‑yi 'ka. ");
INSERT INTO daf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","'Ö gun \"tʋ̈ng bha‑ 'gü, kö \"yi 'kpii‑ bha 'yii pa ꞊kö mɛ \"bhɩɩ‑ ‑nu \"tʋ 'yaa gun Atanna ‑wɔn ‑bha, ‑wo ‑gun pë ꞊në‑ ‑bhö sië, 'wo we mü, 'wo dhe sü, 'wo 'në ‑nu dɔ gwaan‑ ‑bha 'ö dho‑ 'ka \"dhʋ̈ 'ö zun‑ 'ka yi 'ö Noe ‑yö ‑da 'ka \"yitagɔ 'gü bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","‑A ‑nu \"tʋ 'yaa gun 'wɔn \"wɛɛ 'bha ‑bha ‑a 'dhɛ 'kö bha‑ zian 'gü 'ö 'to‑ 'ka \"dhʋ̈ 'ö zun‑ 'ka dha 'kpii‑ 'ö ban 'ö \"yi ‑yö \"kpʋngtaadhɛ bho bha‑ ban ‑yi ‑bha, 'ö \"yi ‑yö nu 'ö sɔ‑ ‑nu ‑ta. ‑Yö ‑dho kë 'pö ‑kɔ do bha ꞊në‑ 'gü mang Mɛgbömɛ n nu ‑yi 'ka. ");
INSERT INTO daf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A‑ ‑pö ka ‑dhɛ ꞊dhɛ ‑a 'yi bha‑ 'ka, gɔɔn‑ ‑nu ꞊plɛ 'wo dho kë 'bhlaa‑ do 'gü, ‑a mɛ 'dhɛ 'ö 'dhang bho n \"dhiʋ̈ ‑yö ‑dho 'dho 'ö‑ mɛ do ‑yö to. ");
INSERT INTO daf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dhong ‑nu ꞊plɛ 'wo dho kë pë zɔn ‑dhɛ 'gü \"wlʋ̈ do 'gü, ‑a mɛ 'ö 'dhang bho n \"dhiʋ̈ ‑yö ‑dho 'dho 'ö‑ mɛ do ‑yö to. ");
INSERT INTO daf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, ‑ka ‑ya ka \"yaan, ‑a ‑gɛn ‑mü ꞊dhɛ yi 'ö ka Dëmɛ dho nu‑ 'ka 'kaa‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","‑Yö kë ka \"yaan ꞊dhɛ 'kɔdëmɛ ‑yö \"tʋ̈ng 'ö ꞊kwaanmɛ dho nu‑ 'ka gbeng ‑a ‑dɔ 'nu kö ‑yö ‑dho ‑ya ö \"yaan 'ö 'waa‑ ‑bha 'kɔ 'wü. ");
INSERT INTO daf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yö ꞊në‑ ‑wɔn 'gü 'yö kaa ‑dɩ 'pö ꞊dhɛ 'ö ‑kë ꞊dhɛ 'kaa n nu \"tʋ̈ng dɔ bha, 'yö ka ‑dho ‑ya ka \"yaan; ‑a ‑gɛn ‑mü ꞊dhɛ \"tʋ̈ng 'ö ka ‑zʋ 'yaa 'ka ꞊dhɛ mang Mɛgbömɛ a ‑dho nu bha ꞊në 'a dho \"kan‑ 'ka ka 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","꞊Dhɛ 'ö Yesu ꞊ya dhiang ‑nu bha‑ zë \"dhʋ̈, 'yö \"gwënng do 'bha ‑da ‑nu ‑dhɛ 'ö‑ pö: «꞊Ya kë \"dhʋ̈ yö ‑zë 'gü kö 'mɛ 'ka bha 'dee dho kë gwëë\" \"klʋsë 'ö 'wɔn dɔ ‑a 'ka? Gwëë\" \"klʋsë 'ö \"dhʋ̈ bha ꞊në‑ dëmɛ ‑ya ‑ya ‑a \"tɛabɔ ‑nu ‑gɔ \"dhiʋ̈ kö ‑yö ‑bhöpë nu‑ ‑nu ‑dhɛ ‑a nu \"tʋ̈ng ‑bha 'yö nu 'yö ‑kpan ‑bha kö ‑ya kë sië ꞊dhɛ ‑kɔ 'wo ‑wʋ kpɔ 'ka‑ ‑bha bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","‑A mɛ 'dhɛ 'kö \"dhʋ̈ bha kö‑ ‑bha ꞊ya kë ‑së. ");
INSERT INTO daf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: «Mɛ 'ö \"dhʋ̈ bha‑ dëmɛ ꞊ya nu, ‑yö ‑dho ‑a ‑ya ö ꞊slɔɔpë ꞊gban \"pɛpɛ ‑gɔ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","\"Kɛɛ ꞊ya kë ꞊dhɛ gwëëmi bha‑ \"klʋ ꞊ya kë 'ya‑, ‑yö ‑dho ‑a pö ö ‑dɩ ‑dhɛ ꞊dhɛ: «'Dho 'ö n dëmɛ ‑ya wo ya, ‑yö ‑dho nu ‑më yi 'ka?» ");
INSERT INTO daf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'Yö ‑ya ö \"tɛabɔ ‑nu ‑ma ‑sü ‑bha, 'yö ‑ya pë ‑bhö ‑sü waa‑ we mü ‑sü ‑bha we mü ‑dudu ‑nu \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","‑Yö ‑dho 'to‑ ‑kë \"dhʋ̈ ‑sü ‑bha, 'yö‑ dëmɛ ‑yö nu 'yö ‑kan 'gü \"tʋ̈ng ꞊dede 'ö‑ ‑zʋ 'yaa‑ ‑bha bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mɛ 'dhɛ 'kö bha kö‑ ‑bha ꞊ya kë ‑wëësü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑gɔmɛ ‑dho 'wɔn wɔ‑ ‑ta 'ö ‑kë ‑ziiziisü, 'yö 'wɔn suu 'wo dho‑ wɔ ꞊flümɛ ‑nu ‑ta bha, 'yö 'wo‑ ‑wɔ ‑ta 'pö. ‑Yö ‑dho \"gbʋ bɔ ‑dhɛ bha ꞊në‑ 'gü 'yö ö \"sɔn \"dhiʋ̈ ‑bhö 'ka klöklödhö.» ");
INSERT INTO daf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈ 'yö \"gwënng do 'bha ‑da ‑nu ‑dhɛ 'zü 'ö‑ pö: «Atanna ‑bha ‑gblüdëdhɛ kë \"tʋ̈ng‑ ‑dho kë ꞊dhɛ 'nëdhiëng ‑nu ‑kaɔng do 'wo woo‑ ‑dhangbha ‑nu sü 'wo dho dhedɔ troo ‑ta ‑a ‑nu ‑bha 'wɔn 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","'Nëdhiëng ‑nu ‑kaɔng do bha‑ mɛ \"sɔɔdhu 'waa gun ꞊kpaɔsü, 'yö‑ mɛ \"sɔɔdhu 'dhɛ 'wo to wo ‑zë 'wo gun ‑glengmɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","‑A mɛ \"sɔɔdhu 'dhɛ 'wo gun ‑taamasü 'ka bha, 'yö 'wo woo‑ ‑dhangbha ‑nu sü \"kɛɛ 'yö 'wii pɛng \"yi ‑zë 'bha kun wo ‑kɔ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Yö‑ mɛ 'dhɛ wo ‑zë 'wo gun ‑glengsü bha, 'yö wo ‑zë 'wo‑ ‑kë \"dhʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊gwëë mü 'ö dhesügɔn bha 'yaa nu sië, 'yö yi ‑yö ‑da ‑nu \"yan ‑bha, ‑pling 'yö 'wo ‑da yi 'gü. ");
INSERT INTO daf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","꞊Dhɛ 'ö gbeng ꞊zinng 'gü ꞊ya ꞊loo, 'yö 'wo mɛ do 'bha ‑wʋ ma kö ‑yö \"gbla sië 'ö‑ pö: «Dhesügɔn ꞊ya nu bhoo! Dhesügɔn ꞊ya nu bhoo! ‑Ka 'dho dɔ‑ ‑gɔ zian‑ bhoo! ‑Ka 'dho dɔ‑ ‑gɔ zian‑ bhoo!» ");
INSERT INTO daf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","'Yö 'nëdhiëngnë ‑nu bha 'wo ‑bö 'mɛ bha‑ ‑wʋ 'ka, 'yö 'wo woo‑ ‑dhangbha ‑nu ‑pë ‑kë, 'yö 'wo zun \"kpɛnng. ");
INSERT INTO daf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","‑A mɛ 'dhɛ 'waa ꞊kpaɔsü 'ö 'wii pɛng \"yi 'bha 'kun wo ‑kɔ \"piʋ̈ bha 'wo dho ‑dhɛ ‑ga kö ‑a ‑nu ‑bha ‑dhangbha ‑nu ‑wo 'dho sië \"sia‑ \"wɛ ‑yɔɔndhö 'yö 'wo‑ pö 'mɛ 'dhɛ 'wo ꞊kpaɔsü bha‑ ‑nu ‑dhɛ 'wo‑ pö: «‑Ka yi ‑bha pɛng \"yi 'në 'dɛdɛ 'në 'bha nu ‑dhe, yii‑ ‑dhangbha ‑yö \"dhuu sië ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Yö 'wo‑ pö‑ ‑nu ‑dhɛ: «'Aa bhoo! Yi ‑bha ya ꞊ya bhɔ‑ ‑bha ꞊dhɛ 'pë 'yii 'dho ꞊mɔɔ‑ 'dhö, ‑ka 'dho pɛng \"yi \"dhɔɔdɔmɛ ‑nu \"piʋ̈ kö 'ka ka ‑bha taa 'dhɔ!» ");
INSERT INTO daf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","꞊Dhɛ 'ö ꞊waa‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈, 'yö 'mɛ bha 'wo ‑ziö 'wo dho woo‑ pɛng \"yi mɔɔ‑ ‑dhɛ 'gü kö 'wo‑ 'dhɔ. ‑Wo ‑tɔ pɛng \"yi mɔɔ‑ ‑zian 'ka 'yö dhesügɔn ‑yö nu, 'yö ö ‑kɔ ‑da mɛ 'dhɛ 'wo gun wo baa‑ ‑sü 'ka bha‑ ‑nu 'gü 'yö 'wo ‑da 'kɔɔdhö, 'yö 'wo \"kwɛɛ ta 'wo \"dhü ‑ziö 'gü. ");
INSERT INTO daf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","꞊Dhɛ 'ö ꞊wa ‑da 'kɔɔdhö 'ö‑ yi 'në 'bha ꞊ya ꞊gwëë, 'yö‑ mɛ \"sɔɔdhu 'dhɛ 'wo gun ꞊taama bha 'wo nu, 'yö 'wo zun \"gbla ‑sü ‑bha 'wo‑ pö: «Yi dëmɛ, yi dëmɛ, ‑bhö dɔ \"gbɩɩ‑ kö i \"kwɛɛ \"pʋ yi ‑gɔ ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","\"Kɛɛ 'yö dhesügɔn ‑yö bɔ 'kɔɔdhö 'ö‑ pö‑ ‑nu ‑dhɛ: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'maa ka dɔ!» ");
INSERT INTO daf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","꞊Dhɛ 'ö Yesu ‑yö \"gwënng bha‑ ‑da ‑nu ‑dhɛ ꞊dhɛ ‑kɔ bha‑ 'dhö, ‑a \"dhiʋ̈todhɛ bha 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka ‑ya ka \"yaan! ‑A ‑gɛn ‑mü ꞊dhɛ yi 'a dho nu‑ 'ka \"ɛɛn \"tʋ̈ng 'a dho nu‑ 'ka 'kaa‑ dɔ!» ");
INSERT INTO daf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","'Yö‑ pö 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «Atanna ‑bha ‑gblüdëdhɛ bha ‑yö ‑dho kë 'zü ꞊dhɛ gɔndënë do 'bha 'ö dho \"ta 'gü ‑a ‑bha 'wɔn 'dhö. ꞊Dhɛ 'ö yöö 'dho 'yö ö ‑bha gwëëzë ‑nu ‑dhɛ 'yö ö ꞊slɔɔpë ꞊gban sü 'yö‑ ‑kɛfama bho‑ ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'Yö \"sënng kpö këng \"sɔɔdhu nu mɛ do ‑dhɛ, 'yö dho 'yö‑ këng ꞊plɛ nu mɛ ꞊plɛ ‑naa ‑dhɛ, 'yö dho 'yö‑ këng do nu mɛ ‑yaaga ‑naa ‑dhɛ. ꞊Dhɛ 'ö ꞊yaa‑ dan, 'ö 'mɛ 'dhö‑ ‑bha 'ö‑ ‑kɔ dho ꞊mɔɔ‑ ‑ziö 'gü ziö ‑sü ‑bha ꞊yaa‑ nu‑ ‑dhɛ 'yö dho. ");
INSERT INTO daf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","꞊Dhɛ 'ö ꞊ya 'dho 'yö mɛ 'dhɛ 'ö \"sënngga këng \"sɔɔdhu ꞊slɔɔ bha, 'yö dho 'yö‑ ‑ziö 'gü ‑ziö 'yö dho 'yö‑ kpö këng \"sɔɔdhu 'bha ꞊slɔɔ 'yö‑ ‑da ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Yö mɛ 'dhɛ 'ö‑ këng ꞊plɛ ꞊slɔɔ 'pö bha, 'yö dho 'yö‑ ‑ziö 'gü ‑ziö, 'yö‑ këng ꞊plɛ 'bha ‑yö ‑da 'gü. ");
INSERT INTO daf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","\"Kɛɛ 'yö 'mɛ 'kö‑ ‑bha gun këng do bha 'yö dho 'yö \"sɛ pɔn, 'yö ö dëmɛ bha \"sënngga bha‑ ꞊loo mü, 'yö \"sɛ kpa‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","꞊Dhɛ 'ö \"tʋ̈ng 'bha ꞊ya ziö 'ö‑ yi ꞊ya ꞊gwëë, 'yö‑ ‑nu dëmɛ bha 'ö nu 'yö‑ pö‑ ‑nu ‑dhɛ mɛ 'ö \"dhʋ̈ ‑yö nu kö ‑yö ö \"kplëng bho ö ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","'Yö‑ mɛ ‑blɛɛsü 'ö \"sënngga këng \"sɔɔdhu nu‑ ‑dhɛ bha 'ö nu. 'Yö‑ 'dhɛ 'wo‑ nu‑ ‑dhɛ bha‑ këng \"sɔɔdhu 'bha ꞊nëng‑ ‑bha 'yö‑ pö ö dëmɛ ‑dhɛ 'ö‑ pö: «N dëmɛ, \"sënng kpö këng \"sɔɔdhu 'i‑ nu n ‑dhɛ bha‑ këng \"sɔɔdhu ꞊në 'a ꞊slɔɔ i zian 'gü 'yö 'a‑ ꞊nëng‑ ‑bha, yö ꞊nɛ!» ");
INSERT INTO daf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Yö‑ dëmɛ ‑ya pö‑ ‑dhɛ 'ö‑ pö: «꞊Ya dhi n ‑dhɛ, ma gwëëmi, i këwɔn ‑yö ‑së. 'Wlɔɔ‑ ‑mü i 'ka, i ‑to i ‑wʋ ‑ta. ꞊Dhɛ 'kö 'bha kë 'wlɔɔ‑ 'ka pë 'në 'dɛdɛ 'a‑ to i \"piʋ̈ bha‑ ‑wɔn 'gü bha, ‑a ‑dho i 'sü 'a i ‑ya ‑a 'kpiki ‑kpiki ‑gɔ \"dhiʋ̈. ꞊Dhɛ 'ö \"dhʋ̈, ‑bhö nu kö 'kwa kwa \"dhia bho. ");
INSERT INTO daf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","꞊Dhɛ 'ö 'mɛ 'dhɛ bha ꞊ya ziö 'yö‑ mɛ ꞊plɛ ‑naa 'ö‑ dëmɛ ‑yö \"sënngga këng ꞊plɛ nu‑ ‑dhɛ bha 'yö nu. 'Yö‑ pö ö ‑gɔmɛ ‑dhɛ 'ö‑ pö: «N dëmɛ, \"sënngga këng ꞊plɛ 'i‑ to n ‑gɔ bha‑ këng ꞊plɛ ꞊në 'a‑ ꞊slɔɔ i zian 'gü 'yö ‑da ‑ta, yö ꞊nɛ!» ");
INSERT INTO daf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Yö‑ dëmɛ ‑ya pö‑ ‑dhɛ 'ö‑ pö: «꞊Ya dhi n ‑dhɛ, i këwɔn ‑yö ‑së, 'wlɔɔ‑ ‑mü i 'ka, i ‑to i ‑wʋ ‑ta. ꞊Dhɛ 'ö 'bha 'wlɔɔ‑ ‑dhɛ kë pë 'në 'dɛdɛ 'a‑ to i ‑gɔ bha‑ ‑wɔn 'gü bha, a ‑dho i 'sü 'a i ‑ya ‑a 'kpiki ‑kpiki ‑gɔ \"dhiʋ̈. ꞊Dhɛ 'ö \"dhʋ̈, ‑bhö nu kö 'kwa‑ 'gü \"dhia bho. ");
INSERT INTO daf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'Yö dho 'yö zun 'mɛ 'dhɛ 'ö \"sënngga këng do nu‑ ‑dhɛ bha‑ ‑bha. 'Yö ꞊yɔɔn 'pö ö dëmɛ \"sɔɔ kö 'ö ö \"kplëng bho. 'Yö‑ pö ö dëmɛ ‑dhɛ: «N dëmɛ, a‑ 'wɔn ‑dɔ ꞊dhɛ i ‑bha 'wɔn kë ‑dhɛ 'yaa ‑së. A‑ 'wɔn ‑dɔ ꞊dhɛ 'bhii pë ta ‑dhɛ 'ö‑ bha i‑ ‑bho mü, 'ö 'bhii pë 'kpɔ ꞊dhɛ 'ö 'gü 'i dho 'i pë ‑wlö mü. ");
INSERT INTO daf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","'Wɔn 'ö‑ \"suʋ̈ ‑yö n ‑kë 'yö 'mii i ‑bha \"sënngga 'i‑ to n ‑gɔ bha‑ ‑ziö 'gü ziö bha 'yö bha. A ka ‑dho 'a‑ ‑da \"sɛɛdhö 'yö 'a \"sɛ kpa‑ ‑ta, ‑a yö ꞊nɛ.» ");
INSERT INTO daf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Yö‑ ‑gɔmɛ ‑ya pö‑ ‑dhɛ 'ö‑ pö: «'Bha‑ pö \"dhʋ̈ 'ma‑ ma. Gwëëmi ‑mawɔn yaasü, \"fiamɛ, mangga i‑ ‑pö i‑ 'wɔn ‑dɔ ꞊dhɛ 'mii pë ta ‑dhɛ 'ö‑ 'gü ‑a ‑bho mü, 'ö 'mii pë 'kpɔ ‑dhɛ 'ö‑ 'gü, 'a‑ ‑wlö mü ‑kɛɛ? \"Ɛɛn 'bhii‑ pö \"dhʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","꞊Dhɛ 'ö ‑kë ꞊dhɛ i‑ 'wɔn ‑dɔ \"dhʋ̈ bha, ‑më ꞊në ‑kë 'sa 'yö 'bhii ma ꞊naɔ bha‑ ‑duɛ bho 'wëë‑ ‑kɔ 'gü kö \"sanni 'a n \"dhiʋ̈ yee kë kö ‑a ꞊trɔɔn ꞊ya ‑da ‑ta kö 'a ma pë 'sü.» ");
INSERT INTO daf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'Yö‑ pö ö ‑bha gwëëzë ‑nu ‑dhɛ 'ö‑ pö: «‑Ka \"sënngga këng do 'ö‑ ‑gɔ bha‑ 'sü‑ ‑gɔ kö 'ka‑ dɔ mɛ 'ö‑ \"gblü do 'dhö‑ ‑gɔ bha‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‑A ‑gɛn ‑mü ꞊dhɛ pë ꞊ya kë 'mɛ 'ö‑ ‑gɔ 'ö‑ ‑ziö 'gü ‑ziö bha ꞊në 'wo dho‑ mɛ taa kë 'yö‑ ‑bha 'dhö ‑kë 'gbɛ, \"kɛɛ mɛ 'dhɛ 'kö pë ‑tiandhö 'bha 'yaa‑ ‑gɔ, \"kɛɛ 'ö‑ 'dhɛ 'ö‑ ‑gɔ 'yaa‑ ‑ziö 'gü ‑zë ziö bha, ‑a 'dhɛ 'në ‑zian 'ö dho kë‑ ‑gɔ ꞊në 'wo dho‑ 'sü‑ ‑mɛ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","꞊Ya 'go yö ‑zë 'gü gwëëmi 'dhɛ 'ö‑ ꞊trɔɔn 'yaa 'dhö 'ö dɔ bha, ‑kaa 'kun 'ka‑ ‑zuö \"kpɛnng ‑dhɛtiidhɛ 'gü, ‑yö ‑dho \"gbʋ bɔ ‑dhɛ bha ꞊në‑ 'gü, 'yö ö \"sɔn \"dhiʋ̈ ‑bhö klöklödhö.» ");
INSERT INTO daf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","'Yö go mü 'zü 'ö‑ pö: «Mang Mɛgbömɛ 'a dhiang zë sië ka ‑dhɛ ya, dho 'ö maa‑ wo ya, n \"dhiʋ̈ yee kë ‑yi 'ka, a ‑dho nu ma ‑gblüdëdhɛ 'gü kö Atanna ‑bha \"kië ‑nu \"pɛpɛ ꞊gban ‑wo n ꞊keng‑, 'yö 'a ‑ya ma ‑gblüdëdhɛ ‑gbloo 'gü. ");
INSERT INTO daf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","‑A 'yi bha ꞊në‑ 'ka 'yö \"sɛgɔ ꞊gban \"pɛpɛ 'gü ‑mɛ ‑nu dho ꞊loo 'ko ‑ta n wëëdhö, 'yö 'a‑ ‑nu bho 'koo ꞊dhɛ ‑kɔ 'ö ‑tuʋ̈ ‑gɔdhiʋ̈mɛ ‑yö \"bhlaa ‑nu waa‑ ‑bhʋ ‑nu bho‑ 'ka 'koo ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","'Mɛ 'wo dho kë ꞊dhɛ \"bhlaa ‑nu 'dhö, a ‑dho ‑a ‑nu bɔ n ‑kɔ ‑së 'gü, 'yö 'mɛ 'wo dho kë ꞊dhɛ ‑bhʋ ‑nu 'dhö, 'a‑ ‑nu bɔ n ꞊kwaa‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'Ma bo ‑a ‑nu ‑kan 'koo ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö 'a‑ pö 'mɛ 'wo dho kë n ‑kɔ ‑së 'gü bha‑ ‑nu ‑dhɛ 'mɛ 'ö n Dë Atanna bha 'dhuë‑ 'dhö ka 'kun ‑sü 'ka bha, ‑ka nu ‑yɛa 'ö n Dë ‑ya ‑pë ‑kë ö ‑bha ‑gblüdëdhɛkëdhɛ 'ka yi 'bha 'ka bha kö 'ka ‑ya 'gü. ");
INSERT INTO daf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‑A ‑gɛn ‑mü ꞊dhɛ din‑ 'dhö gun n kë sië \"tʋ̈ng 'ö‑ 'gü ka kë ‑bhöpë ‑nu n ‑dhɛ, 'ö ꞊dhɛ 'ö \"yi mü ‑dhɔ ‑ya n 'kun 'ka \"yi nu n ‑dhɛ. 'A ‑kë ‑dhɛng 'ka \"tʋ̈ng 'ö‑ 'gü bha ka ꞊në 'ka n ꞊yëë bho. ");
INSERT INTO daf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yi 'a gun‑ 'ka n 'kpee‑ ‑ka bha ka ꞊në 'ka sɔ ‑da n ‑bha. \"Tʋ̈ng 'ö‑ 'ka 'ö n 'gü 'yaa gun ‑së bha, ka ꞊në 'ka nu 'ka ‑wo n ‑bha. Yi 'a gun‑ 'ka ‑kaso 'gü bha ka ꞊në 'ka nu zun n ‑dhɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'Yö mɛ 'ö pö 'aa‑ ‑nu ‑bha bha 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi dëmɛ, yi ‑mɛɛ ꞊në 'yi ‑kpan 'ka i ‑bha kö din‑ ‑yö i ‑bha, 'yö 'yi i gba ‑bhöpë 'ka? \"Ɛɛn yi ‑mɛɛ ꞊në \"yi mü ‑dhɔ ‑yö gun‑ 'ka i ‑bha 'yö yi \"yi nu i ‑dhɛ? ");
INSERT INTO daf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yi ‑mɛɛ ꞊në 'yi ‑kpan 'ka i ‑bha kö i ‑dhɛng 'ka, 'yö 'yi i ꞊yëë bho \"ɛɛn kö i 'kpee‑ 'ka 'yö 'yi sɔ ‑da i ‑bha? ");
INSERT INTO daf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yi ‑mɛɛ ꞊në i 'gü 'yaa gun‑ 'ka ‑së, 'yö 'yi nu 'yi ‑wo i ‑bha, \"ɛɛn 'zü kö i ‑kaso 'gü, 'yö 'yi ‑wo i ‑bha?» ");
INSERT INTO daf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‑Gblüdë ‑dho pö‑ ‑nu ‑dhɛ yö ꞊në‑ 'gü 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ mɛ ‑wëësü ‑nu 'ö‑ ‑nu ꞊bhlëë 'bha 'yaa 'dhö mɛ 'bha wëëdhö, 'ö 'wo n dheebhang 'ka, 'ka 'wɔn ‑së ‑kë mɛ do ‑zian 'ö‑ ‑dhɛ bha kö ka‑ ‑kë ma ꞊në n ‑dhɛ bha.» ");
INSERT INTO daf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","꞊Ya 'go mü 'yö‑ pö 'mɛ 'wo‑ ꞊kwaa‑ 'gü bha‑ ‑nu ‑dhɛ 'ö‑ pö: «\"Dhang ‑mɛ ‑nu! ‑Ka 'go n ‑bha bha! Pɛng 'wo‑ ‑ya Sɔtraan waa‑ ö ‑bha \"kië ‑nu ‑dhɛ bha ka ‑zë kaa 'dho yö ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‑A ‑gɛn ‑mü ꞊dhɛ \"tʋ̈ng 'ö din‑ 'dhö gun n kë sië‑ 'ka, 'kii ‑bhöpë nu n ‑dhɛ, \"yi mü ‑dhɔ 'dhö n kun 'kii \"yi nu n ‑dhɛ, ");
INSERT INTO daf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","'a gun ‑dhɛng 'ka 'kii n ꞊yëë bho, 'a gun n 'kpee‑ 'ka 'kii sɔ ‑da n ‑bha, n 'gü 'yaa gun ‑së, a ‑gun ‑kaso 'gü 'kii ꞊mɔɔ‑ ‑bha kö 'ka ‑wo n ‑dhɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‑Wo ‑dho ‑yɔ bɔ‑ ‑gɔ 'pö 'wo‑ pö: «Yi Dëmɛ, yi ‑kpan i ‑bha 'mɛ kö din‑ ‑yö i ‑bha, \"ɛɛn kö \"yi mü ‑dhɔ ‑yö i ‑bha \"ɛɛn 'zü kö i ‑dhɛng 'ka \"ɛɛn 'zü kö i i 'kpee‑ 'ka \"ɛɛn kö i 'gü 'yaa ‑së, yi ‑mɛɛ ꞊në 'yi ‑kpan 'ka i ‑bha 'zü kö i ‑kaso 'gü, 'yö 'yii \"ta i ‑dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","'Yö‑ ‑yɔ bɔ 'pö‑ ‑nu ‑gɔ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: N dheebhang ‑nu 'ö‑ ‑nu ꞊bhlëë 'bha 'yaa gun mɛ ‑nu wëëdhö bha, 'kii‑ kë‑ mɛ do ‑zian ‑dhɛ. ꞊Ya kë \"dhʋ̈ kö 'kii‑ kë ma ꞊në n ‑dhɛ bha.» ");
INSERT INTO daf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","꞊Dhɛ 'ö‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈ 'yö‑ ‑ta yɔ 'ö‑ pö: «'Mɛ 'wo \"dhʋ̈ bha ‑dhɛ 'ö Atanna dho 'wɔn wɔ mɛ ‑ta ‑a 'gü, 'ö‑ \"dhiʋ̈ 'to ‑dhɛ 'yii 'dho kë tongtongdhö bha ‑wo ‑dho 'dho yö ꞊në‑ 'gü, 'yö 'mɛ 'ö pö 'aa‑ ‑nu ‑bha bha 'wo dho ꞊sii 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha‑ kë ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","꞊Dhɛ 'ö Yesu ꞊ya ö bo 'wɔn ‑nu bha‑ ‑nu pö ‑sü 'ka, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ka‑ 'wɔn ‑dɔ ꞊dhɛ ‑dhɛkpaɔyi ꞊ya 'to do ‑a ꞊plɛ ‑naa bha ꞊në dho kë Pakö yi 'ka, ‑a yi 'ö bha ꞊në dho kë mang Mɛgbömɛ n ‑da pë ꞊kwɛɛ‑ ‑yi 'ka kö ‑wo n ‑dɔ \"dhü ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö \"saabhomɛ ‑nu waa‑ ‑kwɛagbö ‑nu 'wo \"sɛ bha‑ 'gü, 'wo ꞊loo 'ko ‑ta \"saabhomɛ 'kpii‑ 'wo‑ Kaifö ‑kë bha‑ ‑gɔ 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","'Yö ‑kɔ 'wo dho‑ kë‑ ‑bha kö 'wo Yesu 'kun ‑gleng 'gü 'wo‑ zë bha 'wo‑ ‑ya 'kwëë‑ ‑kë ‑dhɛ bha‑ 'gü, 'yö‑ ‑nu ‑wʋ ‑yö to‑ bha do ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","«'Kwa 'dho‑ 'kun Pakö yi 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ 'kwa‑ kë \"dhʋ̈ mɛ 'wo dho nu Pakö ‑ta bha ‑wo ‑dho \"wlü kwa \"piʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","'Ö gun kö Yesu ‑yö Simɔ 'ö ꞊wee ‑yua ‑yö gun‑ ‑bha bha‑ ‑gɔ 'kɔɔdhö Betani, kö ‑wo pë ‑bhö sië, 'yö dhebhɔ 'në do 'bha bha 'ö ꞊yɔɔn‑ \"sɔɔ kö ‑sangdhe suu 'bha 'wo‑ ‑kë gënng' ‑gwë 'ka bha‑ do 'ö ‑dhasiklɔɔ \"yi 'bha 'ö‑ sɔɔn 'dhö \"gbɩɩ‑ 'ka ꞊dhɛ pë 'bha 'dhö bha ‑ya 'gü, kö ‑yö dhebhɔ bha‑ ‑gɔ. Dhebhɔ bha ‑yö Yesu ‑to pë ‑bhö ‑dhɛ 'gü mü, 'yö pë \"yi bha‑ ꞊wɛnng‑ ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","'Wɔn bha ꞊dhɛ 'ö‑ ‑bha ꞊klang ‑nu 'wo‑ ‑dhɛ yö, 'yö ‑siö ‑nu ‑dhɛ 'yö 'wo‑ pö: «Pë 'gü see‑ ‑kɔ suu ‑mɛɛ ꞊në ꞊ni? ‑A kë 'ö‑ wo \"dhʋ̈ ya‑ ꞊trɔɔn ‑mü ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","꞊Ya kë ꞊dhɛ ‑dhasiklɔɔ \"yi ꞊fii ‑së ya‑ \"dhɔɔ ꞊në 'yi‑ dɔ 'nu sɔng \"gbɩɩ‑ bha, 'ö yi‑ 'wëëga bha‑ sü 'yi‑ ꞊gbaɔ ‑wëëmɛ ‑nu ‑gɔ kö ꞊trɔɔn 'yaa‑ 'gü ‑ee!» ");
INSERT INTO daf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","'Yö Yesu \"tʋ 'dhö ‑da dhiang 'wo‑ zë bha‑ 'gü 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Ka dhebhɔnë bha‑ ‑din ‑yën \"dhʋ̈ ‑më ‑wɔn 'gü? 'Kaa‑ 'wɔn dɔ ꞊dhɛ 'wɔn ‑së ꞊në 'ö‑ kë n ‑dhɛ bha ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","‑Ka ‑dhɛ ‑ga, \"flɛɛmɛ ‑nu, \"ɛɛn ‑wëëmɛ ‑nu ‑zë ‑wo ka \"piʋ̈ yö ‑kpɛawo, \"kɛɛ ma ‑zë 'mii 'dho kë ka \"piʋ̈ yö yi ꞊gban 'ka. ");
INSERT INTO daf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, dhebhɔnë bha 'ö pë \"yi 'ö‑ ꞊wɛnng n ‑ta bha, dhasiklɔɔ \"yi 'ö 'wo dho‑ ziö n ꞊gee ‑bha 'wo n ‑wɛɛ bho‑ 'ka bha ꞊në ꞊yaa‑ 'to \"dhiʋ̈ 'yö yaa‑ kë bha. ");
INSERT INTO daf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: 'Wɔn 'ö dhebhɔnë bha 'ö‑ ‑kë bha, ‑dhɛ \"pɛpɛ 'wo dho 'wɔn ‑taɔng ‑së ya‑ pö‑ ‑bha \"kpʋng ꞊taa, ‑wo ‑dho ‑a ‑dhiang zë mü kö mɛ 'bha ‑zʋ 'ya 'dho bhɔ‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ mɛ 'dhɛ 'wo‑ ‑dhɛ Zuda Isikadhiɔtö bha 'yö ꞊wlü 'yö dho \"saabhomɛ ‑nu ‑gɔmɛ ‑nu \"piʋ̈, ");
INSERT INTO daf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'ma Yesu nu ka ‑dhɛ, ka ‑dho n gba ‑më ꞊në‑ 'ka?» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'mɛ 'wo bha 'wo 'wëë‑ \"puu ga ‑kaɔng ‑yaaga ꞊dhʋng 'yö 'wo‑ nu Zuda ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö Zuda ‑yö zun ‑kɔ 'ö dho‑ kë 'ka kö 'ö Yesu \"dhiʋ̈ dɔ 'mɛ bha‑ ‑nu ‑gɔ ‑a \"slë mɔɔ‑ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","꞊Dhɛ 'ö \"dhɔɔgɔ 'ö 'bluu‑ 'ö \"sɛkɛ 'yaa‑ ‑bha 'wo‑ ‑bhö 'ka 'wo‑ Pakö ‑kë bha‑ ‑dhɛkpaɔyi ‑blɛɛsü ꞊ya ꞊loo, 'yö Yesu ‑bha ꞊klang ‑nu 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «‑Yö i \"piʋ̈ ꞊dhɛ 'yi Pakö ‑bhöpë ya‑ ‑kpa i ‑dhɛ ‑dhɛ ‑mɛɛ ꞊në‑ 'gü?» ");
INSERT INTO daf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Ka 'dho 'pödhɛ 'ö ‑ya ka \"dhiʋ̈ bha‑ 'gü kö'ka 'dho 'mɛ 'ö ꞊ni bha‑ ‑gɔ 'kɔɔdhö kö 'ka‑ pö‑ ‑dhɛ: «Yi Dëmɛ ‑ya ‑pö ö ‑bha \"tʋ̈ng ꞊ya ꞊loo, \"kɛɛ yöö Pakö ‑bhöpë ya ö ‑bha ‑bhö i ‑gɔ 'kɔɔdhɛ ꞊në‑ 'gü waa‑ ö bha ꞊klang ‑nu 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","꞊Dhɛ 'ö ꞊ya ö ‑wʋ 'kpɔ‑ ‑nu ‑bha ‑dhɛ ‑kɔ bha‑ 'dhö, 'yö 'wo dho 'wo‑ ‑kë ꞊dhɛ ‑kɔ 'ö‑ pö‑ 'ka‑ ‑nu ‑dhɛ bha‑ 'dhö, 'yö 'wo Pakö ‑pë bha‑ ‑kpa mü. ");
INSERT INTO daf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","꞊Dhɛ 'ö \"bin ꞊ya 'ma, 'yö Yesu waa‑ ö ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha 'wo dho pë ‑bhö ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","꞊Dhɛ 'wo pë ‑bhö sië 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «‑Ka ‑dhɛ ‑ga! A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'ka bha mɛ do‑ dho n \"dhiʋ̈ dɔ n 'yaɔ‑ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","\"Kɛɛ ꞊dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö ‑siö ‑a ‑bha ꞊klang ‑nu bha‑ ‑nu ‑dhɛ ꞊dedewo 'yö 'wo wo wë 'gü ‑siö, 'yö 'mɛ ꞊ya dɔ 'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «Mɛ kpö 'yi ya de ‑mü, n Dëmɛ? \"Ɛɛn ma ‑mü ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","'Yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «'Mɛ 'ö yɛng 'yi yi ‑kɔ ‑da sië 'tɛa‑ 'gü ya ꞊në dho ‑da n ‑dhɛ pë \"piʋ̈.» 'Yö ö ‑wʋ ‑ta ‑yɔ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","«‑Yö \"dhʋ̈ tɛan‑ 'ka ꞊dhɛ mang Mɛgbömɛ a ‑dho ga ꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka‑ 'ka n ‑bu 'gü Atanna ‑bha 'sëëdhɛ 'gü ꞊në‑ 'dhö, \"kɛɛ 'mɛ 'ö yaa‑ ‑kë ö ‑bha 'wɔn 'ka ꞊në‑ ‑mɛ ‑bha 'dhö ‑wëësü. ‑Yö ‑së ‑zianwo ‑mɛ ‑bha 'ka 'nu kö 'ya 'dho bhɔ.» ");
INSERT INTO daf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö Zuda ꞊dede 'ö yöö‑ \"dhiʋ̈ dɔ bha 'ö‑ dhɛɛ\" kpɔ 'pö 'ö‑ pö: «N Dëmɛ, \"ɛɛn ma ‑mü ‑ee?» 'Yö Yesu ‑ya pö‑ ‑dhɛ 'ö‑ pö: «'Bha yö ꞊në‑ pö bha.» ");
INSERT INTO daf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","꞊Dhɛ 'wo pë ‑bhö sië 'yö Yesu ‑yö 'bluu‑ sü. ꞊Dhɛ 'ö ꞊ya Atanna nuɛ\" bho‑ ‑wɔn 'gü, 'yö‑ \"kplükplü bho 'yö‑ nu ö ‑bha ꞊klang ‑nu ‑dhɛ 'yö‑ pö: «‑Ka ‑dhɛ ‑ga, n kwi \"blɛɛn‑ ꞊nɛ. ‑Kaa 'sü kö 'ka‑ ‑bhö.» ");
INSERT INTO daf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","꞊Dhɛ 'ö ꞊ya ö bo 'yö we ‑kɔɔ ‑yan do sü 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü, 'yö‑ nu‑ ‑nu ‑dhɛ 'ö‑ pö: «Mɛ ꞊gban \"pɛpɛ ‑ka ka ‑bɛn ‑ya ‑ta 'dɔɔndhö, ");
INSERT INTO daf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","‑a 'dhɛ 'ö bha n ꞊yɔɔn \"blɛɛn‑ ꞊në bha. N ꞊yɔɔn bha ꞊në dho ꞊wɛnng mɛ kpö 'gbɛ ꞊dede ‑wɔn 'gü, kö Atanna ‑ya ‑nu ‑mawɔn 'to. Yöö do bha ꞊në ‑mlɛɛ 'ö maa‑ ‑da waa‑ mɛ \"bhɩɩ‑ ‑nu ‑a ‑nu ꞊zinng 'gü bha‑ zü ‑bho ‑dhɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: «‑Drɔɔ ya, ꞊ya 'go ꞊dɛɛ 'gü, 'mii 'dho‑ mü 'zü 'ö dho 'ö zun‑ 'ka yi 'ö kwɛng‑ ‑nu 'kwa dho‑ ‑dee mü‑ 'ka n Dë ‑bha ‑gblüdëdhɛ 'gü bha‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö 'wo troo 'ö kë Pakö troo 'ka bha‑ ‑ta \"tan ‑nu 'wo Atanna 'tɔ bhɔ \"tan ‑nu 'ka bha‑ bho, 'yö 'wo ‑ziö 'wo dho Odhivie ‑tɔn ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","꞊Dhɛ 'wo 'dho sië 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «A ‑dho kë ka ‑gɛn \"dhiʋ̈ ‑zuö ‑bha ‑pë 'ka gbeng do 'ö ꞊dɛɛ‑ 'gü. ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'sëëdhɛ 'gü ꞊dhɛ: ‹A ‑dho ‑tuʋ̈ ‑gɔdhiʋ̈mɛ ‑ma 'yö‑ ‑bha ‑tuʋ̈ ‑nu 'wo dɔ bunnggɛɛdhö.› ");
INSERT INTO daf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","\"Kɛɛ 'ma ‑bö kö 'a 'go ga 'gü, a ‑dho ‑da ka \"dhiʋ̈ 'a dho Gadhidhe.» ");
INSERT INTO daf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Piɛdhö ‑ya pö‑ ‑dhɛ 'ö‑ pö: «'Kö 'zü 'mɛ 'yi ya mɛ \"pɛpɛ ꞊gban woo \"kan i ‑bha, \"kɛɛ ma ‑zë 'mii 'dho \"kan i ‑bha tongtongdhö, n Dëmɛ.» ");
INSERT INTO daf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","\"Kɛɛ 'yö Yesu ‑ya pö‑ ‑dhɛ 'ö‑ pö: «A‑ ‑pö i ‑dhɛ tɛan‑ ꞊dede 'ka, Piɛdhö, ꞊dhɛ gbeng do 'ö ꞊dɛɛ‑ 'gü, \"sanni ‑wa pö ꞊dhɛ ‑tɔgɔn ꞊ya \"wɩ kö 'bha n ‑wɔn zaɔ‑ ‑gɛn ‑yan 'ka ‑yaaga.» ");
INSERT INTO daf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","'Yö Piɛdhö ‑ya pö‑ ‑dhɛ 'ö‑ pö: «'Kö 'zü 'ö ‑kë n ‑gɔ ‑to 'gü ‑wɔn 'ka, kö n ‑gɔ ꞊në dho 'to‑ 'gü, \"kɛɛ 'mii 'dho i ‑wɔn ‑zë zaɔ‑ 'ö to‑ ‑bha. 'Yö‑ ‑bha ꞊klang ‑nu bha‑ ꞊gban \"pɛpɛ 'wo‑ pö 'pö \"dhʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","'Yö Yesu waa‑ ‑bha ꞊klang ‑nu bha 'wo dho \"dhʋ̈ 'wo ꞊loo ‑dhɛ do 'bha 'wo‑ Zɛsemane ‑dhɛ ‑kë bha‑ 'gü. ꞊Dhɛ 'ö ꞊wa ꞊loo mü 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Ka ‑ya yö kö ma ‑zë 'a bhɔ 'në 'bha wo taa‑ kö 'a 'dho bhɛa\" Atanna ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","'Yö ‑ziö 'yö Piɛdhö 'dhö, Zebede gbö ‑nu ꞊plɛ 'dhö, 'yö‑ ‑nu sü 'yö 'wo dho, \"kɛɛ kö \"suʋ̈ ꞊ya ‑da 'gü, kö \"nɛnɛga ‑sɛa ꞊ya ‑ya bha ‑sü ‑bha ‑a ‑bha, kö ‑wëë ‑yö bɔ sië‑ ‑ta ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","꞊Dhɛ 'ö ꞊wa bhɔ 'në 'bha wo 'mɛ 'wo bha‑ ‑nu ‑dhɛ taa‑, 'yö‑ pö 'mɛ 'wo gun‑ ꞊keng‑ bha‑ ‑nu ‑dhɛ: «‑Ka ‑ya yö kö 'kwa ‑toyaan kë, ‑a ‑gɛn ‑mü ꞊dhɛ ga ‑zii ꞊ya kpa n ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö bhɔ 'në 'bha wo ‑a ‑nu 'ka taa‑ 'bleng ‑bleng, 'yö \"gblëënu 'yö ꞊bhɛa Atanna ‑dhɛ 'ö‑ pö: «N Dë, 'ö ꞊ya kë ꞊dhɛ 'ö dho kë ‑mɔɔ \"kwëë ‑wɔn 'ka kö ‑bhö dɔ \"gbɩɩ‑ kö 'wɔn \"gbɩɩ‑ 'ö maa‑ \"yi mü ya 'i‑ bho n ‑bha, \"kɛɛ yö ‑zë ꞊gban 'gü, ‑yö n \"piʋ̈ ꞊dhɛ ‑yö kë bhi ꞊në i dhɔɔbhaa 'ka 'ya 'dho 'to ma ‑zë n ‑bha ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","꞊Dhɛ ꞊ya ö bo ‑bhɛa Atanna ‑dhɛ ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö ‑ziö 'ö dho zun ö ‑bha ꞊klang ‑nu ‑yaaga 'dhɛ 'wo nu \"kwëë bha‑ ‑nu ‑dhɛ 'gü, 'ö dho 'ö ꞊loo mü kö ‑wo yi zë sië (꞊dhɛ 'ö ꞊ya 'pa‑ ‑nu ‑bha). 'Yö‑ pö Piɛdhö ‑dhɛ: «Piɛdhö, yi ‑zian ꞊në‑ 'ka‑ zë sië, 'kii ꞊mɔɔ‑ ‑bha kö 'ka \"tʋ̈ng do ‑zian ‑to \"yaan kë n \"piʋ̈ ‑wa? ");
INSERT INTO daf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","A‑ ‑pö 'ka ‑ya ka \"yaan kö 'ka bhɛa\" kö Sɔtraan ‑bha \"kpënng‑ ‑kɔ 'ya 'dho ꞊mɔɔ ka ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö mɛ 'nii‑ 'kö mɛ 'gü bha‑ \"piʋ̈ ꞊dhɛ 'ö Atanna ‑dhidhɛwɔn ꞊në kë yi ꞊gban 'ka, \"kɛɛ \"sɩ 'yaa mɛ kwi ꞊në‑ ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö‑ ‑nu to 'zü ꞊plɛ ‑naa wo, 'yö dho ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü 'ö‑ pö: «N Dë, 'ö ꞊ya kë ꞊dhɛ 'wɔn \"gbɩɩ‑ 'ö yöö wɔ n ‑ta bha, ‑a ‑bho n ‑ta ‑wɔn 'yii 'dho kë ‑mɔɔ \"kwëë ‑wɔn 'ka kö ‑a 'dhɛ 'ö ‑dhi i ‑dhɛ ꞊në ‑yö 'to‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","꞊Dhɛ 'ö ꞊ya ö bo, 'yö ö yee ‑kë 'zü ‑deewo 'ö dho ö ‑bha ꞊klang ‑nu bha‑ ‑nu ‑dhɛ 'gü, 'yö ‑kpan 'zü‑ ‑nu ‑bha ‑dee 'bha wo kö ꞊wa yi zë, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö‑ ‑nu \"yankɔ ꞊gbaan kë 'gbiin‑ yi kaɔ. ");
INSERT INTO daf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","'Yö Yesu ‑yö ‑kan 'zü‑ ‑nu ‑bha ‑deewo 'yö dho 'yö bhɛa\" ‑kɔ ‑yaaga ‑naa 'bha wo 'zü Atanna ‑dhɛ ‑wʋ do bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Yö ö yee ‑kë 'ö nu ö ‑bha ꞊klang ‑nu bha‑ ‑nu \"piʋ̈ ‑dee 'bha wo ('yö pa‑ ‑nu ‑bha) 'yö‑ pö‑ ‑nu ‑dhɛ: «Ka ‑zë yi ꞊në 'ka zë sië ꞊zɔɔ 'yö 'ka ka 'gü ꞊dhië sië‑ 'ka ‑wa! ‑Ka ‑dhɛ ‑ga, \"tʋ̈ng 'a gun‑ ‑dhiang zë sië ka ‑dhɛ bha ꞊ya ꞊loo, mang Mɛgbömɛ n \"dhiʋ̈ ‑dɔ 'wɔnyaakëmɛ ‑nu ‑gɔ \"tʋ̈ng bha ꞊ya ꞊loo. ");
INSERT INTO daf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","‑Ka \"wlü kö 'kwa 'dho! 'Mɛ yöö ‑da n ‑dhɛ pë \"piʋ̈ bha ꞊ya ꞊tëng kwa ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Dhiang bha ‑yö ‑to Yesu \"dhi 'yö Zuda 'ö ‑kë ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ mɛ do 'ka bha 'ö ‑wo kö mɛ kpö 'gbɛ 'ö \"dhü \"kpla ‑nu oo, ‑siang ‑nu 'wo‑ ‑nu ꞊kwɛɛ‑ 'ö Zuifö ‑nu ‑bha \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu 'wo \"sɛ bha‑ 'gü 'wo‑ ‑nu bɔ bha kö ‑wa ꞊keng‑ \"wɛ ‑dungdhö. ");
INSERT INTO daf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","'Ö gun \"dhʋ̈ kö Zuda 'ö ‑da Yesu ‑dhɛ pë \"piʋ̈ bha ꞊ya ö ‑wʋ 'kpɔ‑ ‑nu ‑bha 'nu kö ꞊yaa‑ pö: «꞊Ya kë ꞊dhɛ 'kwa ꞊loo mü, 'mɛ 'a dho‑ ꞊loo‑ ‑bha bha kö 'mɛ bha 'yö bha, kö 'ka‑ 'kun.» ");
INSERT INTO daf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo mü 'yö Zuda ‑yö ‑yɔɔn Yesu \"sɔɔ 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ, 'bha ꞊boo mü!» ꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö ꞊loo‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N \"taɔngdë, 'wɔn 'i nu‑ kë ‑bhö i bha pë kë wo i ‑ta \"puu 'ka!» ꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka 'yö 'mɛ 'wo bha 'wo ꞊yɔɔn‑ ‑bha 'yö 'wo‑ kun. ");
INSERT INTO daf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","꞊Dhɛ 'ö ꞊waa‑ 'kun 'yö 'mɛ 'wo gun Yesu ꞊keng‑ bha‑ mɛ do 'dhö ö ‑bha ‑siang bho ö ‑kpee 'gü, 'yö \"saabhomɛ 'kpii‑ ‑bha gwëëmi zë‑ 'ka‑ \"tʋ kpö ‑bha \"wɛ \"bɛidhö 'yö‑ bho mü. ");
INSERT INTO daf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'Yö Yesu ‑ya pö‑ ‑dhɛ 'ö‑ pö: «N \"taɔngdë, ‑bhö i ‑bha ‑dhaa bha‑ ‑da ‑kpee 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ \"ʋʋ mɛ 'ö dho ‑piö 'si mɛ \"piʋ̈, ‑a ‑mɛ ‑dho 'to ‑piö ꞊në‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","\"Ɛɛn 'bhaa‑ 'wɔn ꞊në‑ dɔ ꞊dhɛ a ‑mɔɔ ‑bha 'a \"tabhoo ‑da n Dë Atanna ‑dhɛ 'ö ö ‑bha \"kië ‑nu 'wo‑ ‑bha \"sɔdha 'ka 'ö mɛ 'yaa ꞊mɔɔ‑ ‑bha kö mɛ ‑ya a \"dhi dɔ bha‑ ‑nu bɔ n ‑dhɛ kö 'wo n ‑ta ‑gblü gɔɔn ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","\"Kɛɛ ꞊ya kë ꞊dhɛ 'ma‑ kë \"dhʋ̈ kö 'pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑gɔ 'sëëdhɛ 'gü bha‑ 'gü ‑wɔn ‑dho kë ‑kɔ ‑kë ꞊dhɛ \"kɛɛ kö‑ ‑dhɛa ‑bha ꞊dhɛ ‑yö kë ꞊dhɛ ‑kɔ bha ꞊në‑ 'dhö?» ");
INSERT INTO daf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑ya pö mɛ kpö bha‑ ‑nu ‑dhɛ 'ö‑ pö: «Ka ‑nu n 'kun ‑dhɛ 'gü \"dhü \"kpla ‑nu waa‑ ‑siang ‑nu 'ka ꞊dhɛ mɛ‑ dɔ 'wɔnyaakëmɛ 'bha 'ka ‑më ‑wɔn ꞊në‑ 'gü \"kɛɛ kö a ‑gun 'dho sië ka kpö 'gü Atanna ‑dhɔkëgükɔ 'gü yi ꞊gban \"pɛpɛ 'ka 'ö 'a mɛ ‑nu ꞊klang ‑nu kë mü 'yö 'kii n 'kun yö ‑zë 'bha 'gü! ");
INSERT INTO daf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","\"Kɛɛ ‑yö ‑kë \"dhʋ̈ kö 'pë 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑wa pö n ‑bu 'gü bha‑ 'gü ‑wɔn ꞊në ‑yö kë. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö‑ ‑bha ꞊klang ‑nu ꞊gban \"pɛpɛ 'wo ‑kan ‑zü 'kwëë‑ 'wo dho. ");
INSERT INTO daf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","꞊Dhɛ 'ö ꞊wa Yesu 'kun, 'yö 'wo dho‑ 'ka \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ 'wo‑ Kaifö ‑kë bha‑ ‑kuu \"dhiʋ̈, 'yö Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu waa‑ ‑nu ‑bha ‑kwɛagbö ‑nu 'wo ꞊loo 'ko ‑ta ‑dhɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","'Wo gun 'dho sië Yesu 'ka \"dhʋ̈ kö Piɛdhö ‑ya ꞊keng‑ \"klëngklëngdhö 'wɔn 'suan‑ bho ‑sü 'ka, 'ö 'wo dho‑ 'ka \"dhʋ̈ 'wo ꞊loo‑ 'ka \"saabhomɛ ‑gɔmɛ 'kpii‑ bha‑ ‑gɔ \"kwɛandhö. ꞊Dhɛ 'ö ꞊wa ‑da \"kwɛandhɛ bha‑ 'gü, 'yö Piɛdhö ‑yö dho 'yö ‑ya \"yan ‑to 'kɔ ‑bha ‑mɛ ‑nu kpö 'gü kö 'wɔn bha‑ \"dhiʋ̈‑ dho ‑ya ‑kɔ 'kö‑ ‑bha ‑zë wo 'ö‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Ö gun \"dhʋ̈ kö 'mɛ 'wo ‑kë \"saabhomɛ ‑nu ‑gɔmɛ ‑nu 'ka waa‑ 'mɛ 'wo ‑kë zagɔbhomɛ ‑nu 'ka waa‑ Zuifö ‑nu ‑bha ‑kwɛagbö ‑nu 'dhɛ 'wo to kö 'pë 'wo dho‑ pö Yesu ‑bha, 'kö 'zü 'ö ‑kë ꞊sua 'ka \"kɛɛ 'ö dho kë‑ zë ‑gɛn ‑zë 'ka bha ‑wa mɔɔ‑ sië. ");
INSERT INTO daf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","\"Kɛɛ kö mɛ 'gbɛ ꞊dede ꞊waa‑ dan kö 'wo ꞊sua ‑za ‑nu mɔɔ‑ kö 'wo‑ ‑ya ‑bha kö ꞊waa‑ dan ꞊wa ꞊fië‑ ‑bha. ꞊Dhɛ 'ö mɛ kpö 'gbɛ ꞊wa ziö mü, 'ö‑ 'bha ‑bha 'yii 'to‑ ‑bha, 'yö mɛ ꞊plɛ 'bha bha 'wo ꞊wlü 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«'Mɛ 'ö dɔ bha ꞊në‑ pö, Atanna ‑dhɔkëgükɔ bha ö ‑dho 'wü 'ö‑ ‑dee dɔ ‑dhɛkpaɔyi ‑yaaga 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈ 'yö \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ bha 'ö ꞊wlü 'ö‑ pö Yesu ‑dhɛ: «'Wɔn 'ö 'mɛ 'wo ya 'wo‑ pö sië i ‑bha ya, 'bhaa‑ ma ꞊në‑ wo 'yö 'bhaa‑ ‑yɔ bɔ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","\"Kɛɛ 'yö Yesu ‑yö ö \"dhi ta 'yö 'yii \"wɩ. 'Yö \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ bha 'ö‑ pö 'zü‑ ‑dhɛ ‑deewo 'ö‑ pö: «'I‑ ‑zë Atanna \"yaandhe ꞊dede ‑dhɛ, ꞊sii ꞊dede ‑ta, bhi ꞊në 'i‑ ‑bha ‑Yamɛ 'ö‑ Gbö 'ka bha‑ 'ka ‑ee? 'Ö ꞊ya kë ꞊dhɛ bhi ꞊në 'i‑ 'ka tɛan‑ ꞊dede 'ka, ‑bhö ‑a pö yi ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «꞊Iin, ma ‑mü, \"kɛɛ yö ‑zë ꞊gban 'gü a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'ö sü ꞊dɛɛ ‑bha 'ö dho‑ 'ka \"dhiʋ̈ ka \"yan‑ ‑dho ‑kpan mang Mɛgbömɛ n ‑bha kö a ‑ya ‑sü 'ka Atanna 'ö‑ 'gü 'dhö \"gbɩɩ‑ 'ö pë 'bha 'yaa ꞊mɔɔ‑ 'ka bha‑ \"sɔɔ ‑dhɛ ꞊bhlëësü 'ö dhang‑ 'gü bha‑ 'gü. ꞊Ya 'go mü 'zü ka ‑dho n \"dhiʋ̈ yee kë ‑sü yö kö a nu sië dha 'kpong‑ ‑ta dhang‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","꞊Dhɛ ꞊yaa‑ pö \"dhʋ̈ 'yö ‑siö \"saabhomɛ 'kpii‑ bha‑ ‑dhɛ ꞊dedewo 'yö ö ‑bha ‑sɔ ‑nu ‑pɛ 'yö‑ pö: «\"Sɛɛ‑ ‑wɔn ‑zian 'yaa‑ 'gü 'zü, ꞊ya \"si bho Atanna ‑gɔ! \"Ɛɛn dhiang 'ö‑ zë bha 'kii‑ ma ‑ee? ");
INSERT INTO daf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ka ka ‑bha ‑pö 'wɔn bha‑ 'gü ꞊dhɛ? ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «‑A zë ꞊në ‑yö wo!» ");
INSERT INTO daf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","‑Wo ‑to ‑wʋ bha ꞊në‑ ‑ta, 'yö 'wo \"dhidhi ‑suʋ̈ ‑a wëëdhö kö ‑wa zë sië ‑kɔ kpö ‑nu 'ka ('yö 'wo sɔ \"pɛn ‑kplü ‑a \"yan \"dhiʋ̈). ");
INSERT INTO daf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","'yö mɛ bha ‑nu 'wo‑ \"tʋ ‑nu ‑ma kö ‑wa pö sië 'wo‑ pö: «Atanna ‑bha ‑Yamɛ, (bhii‑ pö i ‑dɩ ‑dhɛ ‑a ‑wʋdhiʋ̈loomɛ ‑mü i 'ka ‑ee) i‑ ‑zë \"dhʋ̈ de në i ‑ma bha?» ");
INSERT INTO daf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","'Wo gun‑ ‑bha \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü bha kö Piɛdhö ‑zë ‑yö ‑ya sië \"kpɛnng \"kwɛandhö mü. 'Yö gwëëdhe do ‑yö ꞊yɔɔn‑ \"sɔɔ 'yö‑ pö ꞊dhɛ: «Bhi 'i ya ꞊ya bhɔ‑ ‑bha ꞊dhɛ i ‑gun 'pö Yesu 'ö go Gadhidhe bha‑ ꞊keng‑ \"dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","\"Kɛɛ 'yö Piɛdhö ‑ya ꞊zaɔ mɛ \"pɛpɛ 'wo gun mü bha‑ ‑nu \"yan \"dhiʋ̈ mü 'ö‑ pö: «'Wɔn 'dhɛ 'kö 'i‑ pö sië bha ‑yö \"yɛ i ‑ta ‑wa.» ");
INSERT INTO daf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Piɛdhö ‑yö ꞊wlü 'yö ö wë dɔ \"kwɛɛ \"dhi ‑zian 'ka. 'Yö gwëëdhe ‑nu bha‑ mɛ \"wɛɛ do 'bha ‑ya yö kö ‑yö 'dho sië 'yö‑ pö 'mɛ 'wo gun 'mü bha‑ ‑nu ‑dhɛ 'ö‑ pö: «'Mɛ 'ö 'dho sië ya ‑yö ‑gun 'pö Yesu 'ö go Nazadhɛtö bha‑ ꞊keng‑!» ");
INSERT INTO daf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","'Yö Piɛdhö ‑ya ꞊zaɔ 'zü ‑deewo, 'yö ‑sö ‑bhö 'ö‑ pö: «('A‑ zë Atanna ‑dhɛ) a‑ ‑pö ka ‑dhɛ 'maa 'mɛ bha‑ dɔ! (꞊Ya kë ꞊dhɛ ‑a pö 'a‑ wo sië bha ꞊ya kë ꞊sua 'ka 'a ga).» ");
INSERT INTO daf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","꞊Dhɛ 'ö \"tʋ̈ng 'në 'bha ꞊ya ziö 'zü, 'ö 'mɛ 'wo gun mü bha ꞊wa ꞊yɔɔn Piɛdhö \"sɔɔ 'yö 'wo‑ pö‑ ‑dhɛ 'wo‑ pö: «'Wɔn 'wo‑ pö sië i bha ya tɛan‑ ‑mü, 'mɛ 'ö ya‑ ‑bha mɛ ‑nu bha‑ mɛ do ‑mü i 'ka, ‑a zaɔ‑ ‑dhɛ 'bha 'yaa 'dhö, ‑a ‑gɛn ‑mü ꞊dhɛ i ‑wʋ ‑zian 'ö i \"dhi bha ‑yö ‑bhɔ 'mɛ 'wo bha ꞊në‑ ‑nu ‑wʋ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈, 'yö Piɛdhö ‑ya pö: «Dhiang 'a‑ zë sië ka ‑dhɛ bha ꞊ya kë ꞊sua 'ka 'a ga. A‑ ‑pö ka ‑dhɛ ꞊dhɛ 'maa 'mɛ bha‑ dɔ tongtongdhö.» ‑A ‑pö \"dhʋ̈ ‑sü ‑yö ‑to Piɛdhö \"dhi 'yö ‑tɔgɔn ‑yö ‑wɩ. ");
INSERT INTO daf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Yö Piɛdhö ‑dɩ 'pö‑ ‑zʋ 'dhö to 'ö ‑bö ‑wʋ 'ö Yesu ‑ya pö‑ ‑dhɛ ꞊dhɛ ‹\"sanni ‑tɔgɔn ‑yö \"wɩ ꞊dɛɛ kö 'bha n ‑wɔn zaɔ‑ ‑gɛn ‑yan 'ka ‑yaaga› bha‑ 'ka. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'ö Piɛdhö ꞊ya zun \"kpɛnng 'yö ‑ya \"gbʋ bɔ ‑sü ‑bha ꞊dedewo 'yö ‑kë ‑wëëwëësü 'ka ꞊ni. ");
INSERT INTO daf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'ö‑ ‑tadhɛ ꞊ya ꞊kpaɔ, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu bha 'wo ‑suʋ̈ 'wo dho \"slën 'gü, 'yö 'wo Yesu zë ‑wɔn ‑ya 'kwëë‑ ‑kë 'yö‑ ‑nu ‑wʋ ‑yö to‑ ‑bha do. ");
INSERT INTO daf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","'Yö 'wo dho 'wo Yesu ‑lö, 'yö 'wo dho‑ 'ka Wlɔmö ‑mɛ ‑nu 'wo 'mɛ 'ö‑ ‑ya \"sɛdë 'ka Zuifö ‑nu ‑gɔ \"dhiʋ̈ 'wo‑ Pidhatö ‑kë bha‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","꞊Dhɛ 'ö Zuda 'ö ‑da Yesu ‑dhɛ pë \"piʋ̈ bha ꞊yaa‑ 'wɔn dɔ ꞊dhɛ 'wɔn bha ꞊ya kë Yesu ‑gɔtogüwɔn 'ka, 'yö ‑da 'gü ‑zinngdhö, 'yö‑ zuë\" 'dhö ‑ya za ‑dɔ ‑bha ‑sü ‑bha, 'yö ‑ya ‑a \"slë mɔɔ‑ ‑sü ‑bha kö 'ö ö \"gblʋʋ ‑ta baa‑. 'Yö \"tanma ‑kaɔng ‑yaaga 'ö \"Saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu 'wo‑ nu‑ ‑dhɛ bha‑ sü 'yö dho‑ 'ka‑ ‑nu ‑dhɛ ");
INSERT INTO daf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'yö‑ pö: «'Ma 'wɔn yaa kë, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'a‑ \"dhiʋ̈ dɔ ka ‑dhɛ bha 'wɔn yaa 'bha kö yöö‑ kë kö 'a‑ dɔ 'yaa 'dhö.» 'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «'Yö ‑yö ‑dɔ yi ‑zë yi ‑gɔ 'mɛ? I ‑ta ‑wɔn ꞊në yö ‑zë 'ka. ");
INSERT INTO daf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","'Yö Zuda ‑yö 'wëë‑ \"puu ga ‑kaɔng ‑yaaga bha‑ ꞊wɛnng Atanna ‑dhɔkëgükɔ 'gü mü, 'yö ‑ziö 'yö dho 'yö ö ‑dɩ dun. ");
INSERT INTO daf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","꞊Dhɛ 'ö Zuda ꞊ya bo 'dho ‑sü 'ka, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu bha 'wo 'wëë‑ bha‑ ‑wlö. ꞊Dhɛ 'ö ꞊wa wo bo‑ ‑wlö ‑sü 'ka 'yö 'wo‑ pö: «'Yaa ‑së kö 'kwa 'wëëga 'ö‑ suu 'dhö ya ‑da Atanna ‑bha ꞊naɔ ‑pë 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ zë 'wëë‑ ‑mü. ");
INSERT INTO daf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","꞊Dhɛ 'ö ꞊wa wo bo‑ ‑ya 'kwëë‑ kë ‑sü 'ka, 'yö 'wo dho 'wo gbɔdɔmɛ ‑bha 'bhlaa‑ dhɔ‑ 'wëë‑ bha‑ 'ka kö 'wo ‑dhɛ kë ‑dhɛng ‑nu bun bho ‑dhɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","'Wɔn 'ö‑ ‑wɔn 'gü 'yö go‑ 'yi bha‑ ‑bha 'ö nu 'ö zun‑ 'ka ꞊dɛɛ ‑bha, 'yö 'wo‑ 'bhlaadhɛ bha‑ ‑dhɛ ‹mɛ ꞊yɔɔn sɔɔn ‑bhlaa› bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","\"Kɛɛ 'sa yö ꞊në ‑kë 'pö ‑wʋ 'ö Atanna ‑wʋdhiʋ̈loomɛ Zedhemi ‑ya pö yi 'bha 'ka 'ö‑ pö ꞊dhɛ: ‹'Wëë‑ \"tanmaga ‑kaɔng ‑yaaga, 'wëëga 'ö Izraɛdhö ‑mɛ ‑nu 'wo ꞊mɔɔ‑ 'gü kö ‑wa nu mɛ ꞊bhlëësü bha‑ ‑wɔn 'gü bha ‑wa ‑sü ");
INSERT INTO daf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'yö 'wo gbɔdɔmɛ ‑bha 'bhlaadhɛ dhɔ‑ 'ka ꞊dhɛ ‑kɔ 'ö kwa Dëmɛ ‑ya pö‑ 'ka n ‑dhɛ ‑a 'dhö› bha‑ 'gü ‑wɔn kë ‑kɔ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö dho 'ö ꞊loo Pidhatö ‑kuu \"dhiʋ̈. ꞊Dhɛ 'ö 'mɛ 'wo dho‑ 'ka \"sɛdë ‑kuu \"dhiʋ̈ bha ꞊waa‑ ‑gɛn bho‑ ‑dhɛ 'kpakpadhö, 'yö Yesu dhɛɛ\" kpɔ 'ö‑ pö: «Bhi ꞊në 'i Zuifö ‑nu ‑bha ‑gblüdë 'wo ‑wɩ 'ka bha‑ 'ka ‑ee?» 'Yö‑ pö‑ ‑dhɛ 'ö‑ pö: «꞊Iin, ma ‑mü.» ");
INSERT INTO daf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","\"Kɛɛ ‑a pö 'ö‑ wo \"dhʋ̈ bha za 'kö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu 'wo dɔ‑ ‑bha ꞊suasua ‑dhiang ‑nu 'ka bha 'yii yö ‑zë 'bha ‑yɔ bɔ. ");
INSERT INTO daf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pidhatö ‑ya ‑pö ‑dhɛ yö ꞊në‑ ‑wɔn 'gü 'ö‑ pö: «Dhiang 'gbɛ 'wo‑ zë sië i bha ya 'bhaa‑ ma ꞊në‑ wo ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","\"Kɛɛ Yesu 'yii‑ \"wɩ‑ ‑bha kö ‑ya 'bha ‑yɔ bɔ, yö ꞊në‑ 'wɔn ‑yö ‑gblüdë Pidhatö kɔn ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","‑A \"tʋ̈ng bha‑ 'gü kö Pakö yi ꞊ya ꞊loo ‑kɔ 'ö‑ ‑bha 'do 'do, 'yö ‑gblüdë ꞊ya 'mɛ 'wo ‑kaso 'gü bha‑ mɛ 'dhɛ Zuifö ‑nu ‑wo wo ‑kɔ ‑yɛ ‑bha bha‑ bho ‑kaso 'gü ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","\"Tʋ̈ng 'wo Yesu kun‑ 'ka \"dhʋ̈ bha, kö \"gasagɔn do 'bha 'ö mɛ ꞊gban \"pɛpɛ 'wo‑ dɔ ‑a këwɔn yaa ‑nu ‑bha 'wo‑ ‑dhɛ Badhabasö bha ‑yö ‑kaso 'gü. ");
INSERT INTO daf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","꞊Dhɛ 'ö Pidhatö ‑yö mɛ kpö bha‑ yö ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «Mɛ ꞊plɛ 'wo ya‑ de ‑sü ꞊në 'ka‑ \"piʋ̈ ꞊dhɛ 'a‑ bho ‑kaso 'gü ka ‑dhɛ ‑kwɛ ya‑ 'ka? Badhabasö ‑ee? \"Ɛɛn ‑a mɛ 'dhɛ 'wo‑ ‑dhɛ Yesu Klisi ya ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑ya 'wɔn ‑dɔ 'kpakpadhö ꞊dhɛ gblɛɛn\" ꞊në ‑da ‑nu 'gü 'yö 'wo‑ \"piʋ̈ ꞊dhɛ 'wo Yesu zë bha. ");
INSERT INTO daf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pidhatö ‑yö ‑to 'wɔn ‑nu bha ꞊në‑ ‑nu kë ‑sü ‑bha zadɔdhɛ 'gü mü \"dhʋ̈, 'yö‑ ‑bha dhebhɔ ‑yö naɔ bɔ‑ ‑dhɛ 'ö‑ pö: «'Ka 'dho ‑kaa pö Pidhatö ‑dhɛ ‑yö ö ‑dɩ 'kun kö‑ ‑kɔ ꞊ya 'dho ‑da 'mɛ bha‑ zë ‑wɔn 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊sɔng 'bha 'yaa‑ ‑bha. \"Kɛɛ 'mii yi zë ꞊dɛɛ gbeng 'mɛ bha‑ ‑wɔn 'gü, \"yɛɛn 'a‑ bho ꞊dɛɛ ‑yö ‑gban 'mɛ bha ꞊në‑ ‑bha, \"kɛɛ ‑yö ‑ziisü.» ");
INSERT INTO daf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","\"Kɛɛ kö Zuifö ‑nu ‑bha ‑kwɛagbö ‑nu waa‑ \"saabhomɛ ‑nu ‑gɔmɛ ‑nu ‑zë ‑wo ‑wʋ ꞊në‑ 'ma sië mɛ \"dhaa 'wo gun mü bha‑ ‑nu \"tʋʋ, 'wo ‑da ‑nu ‑gɔ 'gü kö ‑wa pö ‑gblüdëdhɛ ꞊dhɛ ‑yö Badhabasö ꞊në‑ lɔɔ‑ wo ‑dhɛ kö ‑yö Yesu ‑zë zë. ");
INSERT INTO daf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö ‑gblüdë ‑ya ‑nu dhɛɛ\" 'bha kpɔ 'ö‑ pö: «Ka‑ ‑pö 'a mɛ ꞊plɛ ya‑ de ‑sü ꞊në lɔɔ‑ ka ‑dhɛ!» 'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Badhabasö.» ");
INSERT INTO daf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","'Yö Pidhatö ‑ya pö‑ ‑nu ‑dhɛ: «꞊Dhɛ 'ö \"dhʋ̈ ‑yö ka \"piʋ̈ ꞊dhɛ 'a Yesu 'wo‑ ‑dhɛ Klisi ya‑ kë ꞊dhɛ?» 'Yö‑ ‑nu ꞊gban \"pɛpɛ ‑wa pö: «‑Bhö ‑a dɔ \"dhü ‑bha! (‑Bhö ‑a dɔ \"dhü ‑bha!)» ");
INSERT INTO daf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","'Yö ‑gblüdë bha 'ö‑ pö: «‑Yö ‑më ‑wɔn yaa ꞊në‑ ‑kë?» \"Kɛɛ 'yö 'wo ꞊gbang dɔ ‑yuudhö \"gbɩɩ‑ 'ka 'wo‑ pö: «Bhi ‑zë, ‑bhö ‑a dɔ ‑zë wo \"dhü ‑bha ꞊zɔɔ!» ");
INSERT INTO daf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","꞊Dhɛ 'ö Pidhatö ꞊yaa‑ 'wɔn dɔ ꞊dhɛ 'ya ꞊nëng 'wɔn bha‑ 'gü kö yöö 'to 'mɛ bha‑ ‑nu \"yënng \"wɛɛwɛɛ, kö ‑wo ꞊gbang ꞊në‑ dɔ sië do 'wo dho‑ 'ka 'waa \"tʋ ‑zian ‑dɔ ö ‑wʋ ‑bha, 'yö \"yi sü, 'yö ö ‑kɔ ‑zu 'ka 'mɛ 'wo bha‑ ꞊gban \"pɛpɛ \"yan \"dhiʋ̈ mü 'yö‑ pö: «'Mɛ 'ö ꞊sɔng 'bha 'yaa‑ ‑bha ‑a zë ‑wɔn 'ka dɔ‑ 'ka bha ma ‑zë n ‑kɔ 'yaa‑ 'gü, ‑yö 'to kaa do kaa 'wɔn 'ka. ");
INSERT INTO daf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","'Yö mɛ \"pɛpɛ bha‑ ꞊gban 'wo‑ pö: «꞊Iin, ‑yö kë \"dhʋ̈, ‑yö 'to yaa yii‑ 'në ‑nu yii‑ 'wɔn 'ka!» ");
INSERT INTO daf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","꞊Dhɛ 'ö ꞊waa‑ pö Pidhatö ‑dhɛ \"dhʋ̈, 'yö ö ‑kɔ bho‑ ‑nu ‑dhɛ Badhabasö 'gü. 'Yö \"sɔdha ‑nu ‑ya Yesu ‑zë ‑bha kö ‑wa ‑ma ‑sabhlüga 'ka kö ‑wa dɔ \"dhü bha. ");
INSERT INTO daf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Pidhatö ‑bha \"sɔdha ‑nu 'wo Yesu sü 'wo dho‑ 'ka Pidhatö ‑gɔ 'kɔɔdhö, 'yö \"sɔdha ‑nu bha‑ ꞊gban 'wo ꞊klëën‑ ‑zü mü. ");
INSERT INTO daf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'Yö 'wo‑ ‑bha sɔ bho‑ ‑bha, 'yö 'wo ‑tɔyang ‑zaɔndhö do ‑da ‑bha, ");
INSERT INTO daf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","'Yö 'wo \"glɛɛn ‑kloo do \"kɛɛga ‑kë 'yö 'wo‑ ‑ya ‑gɔ ‑bha ꞊dhɛ‑ ‑bha ‑gblüdëdhɛ 'faan‑ 'dhö. ('Yö 'wo ‑kaadhü do ‑da ‑a ‑kɔ ‑së 'gü ꞊dhɛ ‑gblüdë ‑nu ‑bha ‑taadhü 'dhö.) ꞊Dhɛ 'ö ꞊waa‑ kë \"dhʋ̈, 'yö 'wo zun wo kpiö 'gü ‑a wëëdhö 'wo‑ pö: «Zuifö ‑nu ‑bha ‑gblüdë, 'bha ꞊boo mü!» 'Yö 'wo ꞊wɛɛ dɔ‑ 'ka‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","'Yö 'wo wo \"dhidhi ‑nu ‑suʋ̈ ‑bha, 'yö 'wo ‑kaadhüga ‑nu sü 'wo‑ ‑ma 'ka‑ ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","꞊Dhɛ 'ö ꞊wa wo bo ꞊wɛɛ ‑dɔ ‑bha ‑sü 'ka, 'yö 'wo ‑tɔyang 'wo‑ ‑da ‑bha bha‑ bho‑ ‑bha, 'yö 'wo‑ ‑bha sɔ ‑da ‑bha 'zü ‑deewo 'yö 'wo dho‑ 'ka kö ‑wa dɔ \"dhü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","꞊Dhɛ 'wo 'go sië 'pödhö kö ‑wo 'dho‑ ‑dɔ \"dhü ‑bha ‑dhɛ 'gü, 'yö 'wo ‑kpan gɔndë do 'wo‑ ‑dhɛ Simɔ, 'ö go 'pödhɛ 'wo‑ ‑dhɛ Sidhɛnö ‑a 'gü bha‑ ‑bha. 'Yö 'wo faandhɛ ‑wɔ 'mɛ bha‑ ‑ta 'wo‑ pö ‑yö Yesu ‑dɔ ‑bha \"dhü bha‑ 'sü ");
INSERT INTO daf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","'Yö 'wo dho 'wo ꞊loo ‑dhɛ 'bha 'wo‑ ‑dhɛ eblö ‑wʋ 'gü Gɔgota bha‑ 'gü (꞊waa‑ pö \"dhʋ̈ kö ‑wa ‑pö ‹mɛ ‑gɔ \"kpɛa ‑tɔn›). ");
INSERT INTO daf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo mü, 'yö 'wo nu ‑drɔɔ suu 'bha 'ö ꞊wa wü \"këë wü‑ ꞊bhaa bha‑ 'ka Yesu ‑dhɛ kö ‑ya mü (kë \"dhʋ̈ kö pë ‑nɛɛ ‑ma 'ka ‑sü bha ‑yö 'dho 'në 'bha wo \"sia‑). \"Kɛɛ ꞊dhɛ 'ö ö ‑bɛn ‑ya ‑ta, 'yö ‑kɔ ‑a mü ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","꞊Dhɛ 'ö ꞊wa wo bo‑ ‑dɔ \"dhü ‑bha ‑sü 'ka, 'ö ꞊wa \"pɔni ‑gban ‑a ‑kɔ waa‑ ‑gɛn ‑nu ‑ta, 'yö 'wo‑ ‑bha sɔ ‑nu 'gü ‑gblü wo 'ko ‑ta zë \"kpʋ̈ü kë ‑sü 'ka kë \"dhʋ̈ kö ‑wʋ 'ö Atanna ‑wʋdhiʋ̈loomɛ do 'bha ‑ya pö yi 'bha 'ka 'ö‑ pö ꞊dhɛ: «‑Wo kë n ‑dasɔ ‑nu 'gü ‑gblü wo 'ko ‑ta, 'ö 'wo zë \"kpʋ̈ü ‑kë ma ‑da sɔ ꞊wlöö ‑sɔ ‑ta» bha‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","꞊Dhɛ 'ö ꞊wa wo bo, 'yö 'wo ‑ya ‑a ‑maa ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","'Yö 'wo pë ‑bɛn zë ‑a ‑dɔ ‑bha \"dhü bha‑ ‑bha ‑a ‑gɔ ‑ta \"dhʋ̈ng 'gü 'wo‑ pö: «Yesu, Zuifö ‑nu ‑bha ‑gblüdë bha yö ꞊nɛ!» Kë \"dhʋ̈ kö 'mɛ ꞊ya ꞊loo mü ‑ya zë ‑gɛn dɔ. ");
INSERT INTO daf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","‑Dhɛ 'wo Yesu dɔ \"dhü ‑bha 'gü bha, 'yö 'wo dho 'wo mɛzëmɛ ꞊plɛ dɔ \"dhü ‑bha 'pö‑ \"sɔɔ mü. 'Yö 'wo mɛ do dɔ‑ ‑kɔ ‑së 'gü, 'yö 'wo mɛ do dɔ‑ ꞊kwaa 'gü. ");
INSERT INTO daf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","'Mɛ 'wo gun zian ziö sië 'pö Yesu ‑dɔ \"dhü ‑bha ‑dhɛ bha‑ 'gü, ꞊wa ‑kpan ‑bha 'yö 'wo wo ‑gɔ 'gü zë‑ ‑dhɛ, 'wo \"si bho‑ ‑gɔ 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Bhi 'ö 'i‑ pö i ‑mɔɔ ‑bha 'i Atanna ‑dhɔkëgükɔ wü 'i‑ dɔ ‑dhɛkpaɔyi ‑yaaga 'ka bha, bhi 'aa mü i dɔ bha ‑ee? ‑Bhö i ‑dɩ dha ‑dhe! ꞊Ya kë ꞊dhɛ 'i Atanna Gbö 'ka ꞊dedewo tɛan‑ 'ka, ‑bhö 'go \"dhü bha‑ ‑bha kö 'i zun \"sia‑!» ");
INSERT INTO daf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kö 'mɛ 'wo ‑kë \"saabhomɛ ‑nu ‑gɔmɛ ‑nu 'ka oo, 'tɔnggɔmɛ ‑nu oo, ‑kwɛagbö ‑nu bha ‑wo ꞊wɛɛ dɔ sië‑ ‑bha 'pö 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«꞊Ya mɛ \"wɛɛ ‑nu dha \"kɛɛ 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö ö ‑dɩ ‑zë dha! 'Yii‑ pö ö ‑dɩ ‑dhɛ Izraɛdhö ‑mɛ ‑nu ‑bha ‑gblüdë ‑mü ö 'ka ‑ee? ꞊Ya kë ꞊dhɛ 'ö \"dhʋ̈ tɛan‑ 'ka, ‑yö 'go \"dhü bha‑ ‑bha kö ‑yö zun \"sia‑ kö 'yi‑ ‑dhɛ yö, ꞊ya kë \"dhʋ̈ kö 'ya 'dhang bho‑ \"dhiʋ̈! ");
INSERT INTO daf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‑Ɛɛ, 'ö ö ‑zʋ yö 'zü Atanna 'ö‑ ‑dhɛ bha, ꞊ya kë ꞊dhɛ ‑a ‑dhɔ 'dhö‑ ‑kë ꞊dedewo, ‑yö nu kö ‑ya bho \"dhü bha‑ ‑bha! 'Yaa gun‑ pö sië ö ‑dɩ ‑dhɛ ꞊dhɛ Atanna Gbö ‑mü ö 'ka ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kö mɛzëmɛ ‑nu 'wo‑ ‑nu dɔ 'pö \"dhü ‑bha ‑a \"sɔɔ mü bha, ‑wo \"si bho sië‑ ‑gɔ 'pö ‑kɔ do bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","(꞊Dhɛ 'ö Yesu ga \"tʋ̈ng ꞊ya ꞊tëng) 'ö sü 'yënng‑ ‑ya mɛ ‑gɔ ꞊zinng 'gü \"tʋ̈ng bha‑ ‑bha, 'ö dho 'ö zun‑ 'ka \"wɔ \"yɛ ‑yën ‑bha, ‑dhɛ 'gü‑ kë ‑tröö \"kpʋngtaadhɛ ꞊gban 'gü gbluungdhö. ");
INSERT INTO daf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","꞊Dhɛ 'ö 'yënng‑ ꞊ya 'kpɔ mɛ ‑gɔ 'ka ‑së 'ka, 'ö \"tʋ̈ng ‑yaaga ‑naa ö yɛan\" \"piʋ̈ bha ꞊ya ꞊loo, 'yö Yesu ‑yö ꞊gbla \"gbɩɩ‑ 'ka eblö ‑wʋ 'gü 'ö‑ pö: Edhi, Edhi, dhama sabatami!» ꞊Waa‑ pö \"dhʋ̈ kö ‑wa ‑pö: «Ma Atanna, ma Atanna, ‑më ꞊në ‑kë 'yö 'i i ‑kɔ ‑kan n \"dhiʋ̈ \"dhʋ̈?» ");
INSERT INTO daf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'mɛ 'wo gun mü bha‑ mɛ 'bha ‑nu 'wo ‑ya pö ‑sü ‑bha ꞊dhɛ: «‑Yö (Atanna ‑wʋdhiʋ̈loomɛ Edhi 'ö gun yi 'bha 'ka bha‑) ‑dhɛ sië ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈, 'yö mɛ do ‑yö ‑bɛang sü 'ö dho ‑fuu 'sü, 'yö dho‑ 'ka 'ö‑ ‑da ‑drɔɔ 'wangwang 'bha bha‑ ꞊bhaa, 'yö‑ ‑ya ‑kaadhü \"dhiʋ̈ 'yö‑ nu‑ ‑dhɛ kö ‑ya mü. ");
INSERT INTO daf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","\"Kɛɛ kö mɛ ‑kpɛa ‑zë ‑wa pö sië‑ ‑dhɛ: «‑Bhö kwaa‑ ‑zü ꞊kö, 'bha mü \"dhʋ̈ Edhi ‑dho nu 'ö‑ dha.» ");
INSERT INTO daf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö \"gbla do 'bha wo 'zü \"gbɩɩ‑ 'ka, 'yö‑ 'nii‑ 'dhö ‑pö. ");
INSERT INTO daf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, \"tʋ̈ng ꞊dede 'ö Yesu 'nii‑ 'dhö ‑pö 'ka bha 'yö sɔ 'ö gun Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö ‑a 'gü ‑kan 'gü ‑sɔ 'ka bha, 'ö ‑pɛ 'gü ꞊zinng 'gü gbanngdhö 'ö‑ zü ‑yö bho ‑a \"zɔ \"dhiʋ̈ \"dhʋ̈ng 'gü 'ö zun‑ 'ka \"sia‑ (kö ‑ya ‑zɔn ꞊dhɛ ꞊zinng 'yaa Atanna waa‑ mɛ \"bhɩɩ‑ ‑nu ‑a ‑nu ꞊zinng 'gü 'zü Yesu Klisi 'saa‑ 'gü). 'Yö \"sɛ 'dhö ꞊zii 'yö ‑gwë ‑tɔn ‑nu 'wo ‑pɛ ‑nu wo. ");
INSERT INTO daf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","'Yö mɛ bun ‑nu 'wo wü, 'yö 'mɛ 'wo ‑kë Atanna ‑bha mɛ ‑nu 'ka 'ö ꞊wa ga 'nu zii, 'yö‑ mɛ 'gbɛ 'wo ‑bö. ");
INSERT INTO daf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","꞊Dhɛ 'ö 'mɛ 'wo bha ‑wa 'go ga 'gü, 'ö ꞊wa ‑bö ‑nu wo ꞊dhɛ ‑kɔ bha‑ 'dhö, 'ö Yesu ꞊ya 'go ga 'gü 'pö ꞊ya ‑bö, 'yö 'wo dho 'wo ‑da Zedhizadhɛmö ‑pö 'ö ‑kë Atanna ‑bha 'pö‑ 'ka bha‑ 'gü, 'yö mɛ 'gbɛ ꞊dede 'wo wo \"yan ‑kpan ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","꞊Dhɛ 'ö \"sɔdha ‑gɔmɛ 'ö waa‑ ö ‑bha \"sɔdha ‑nu 'wo gun ‑ya ‑sü 'ka Yesu ‑maa ‑gɔ bha ꞊wa \"sɛ 'ö ꞊zii bha waa‑ \"dhabhliwɔn ‑nu 'ö ‑kë bha‑ ‑dhɛ yö, 'yö \"suʋ̈ 'dhö ‑da ‑nu 'gü ꞊dedewo 'yö 'wo‑ pö: «'Mɛ 'ö ya Atanna Gbö ꞊në gun‑ 'ka ꞊dedewo, ‑a zaɔ ‑dhɛ 'bhaa 'dhö 'zü.» ");
INSERT INTO daf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","'Ö gun \"dhʋ̈ kö dhong ‑nu 'ö waa‑ Yesu ‑nu 'wo go wo \"kwëë Gadhidhe 'wo gun‑ \"dhiʋ̈ ‑ziö wo sië bha ‑wo dɔ sië ꞊gblɛɛn 'wo‑ ‑dhɛ ‑ga. ");
INSERT INTO daf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Madhi 'ö go Madadha bha waa‑ Madhi 'dhɛ 'ö ‑kë Zakö waa‑ Zosɛfu ‑a ‑nu dhe 'ka bha, waa‑ Zebede gbö ‑nu 'ö 'wo gun Yesu ꞊keng‑ bha‑ ‑nu dhe ‑nu ‑wo ‑gun dhong ‑nu bha‑ ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","꞊Dhɛ 'ö \"bin ꞊ya 'ma, 'yö gɔndë do 'ö ‑kë ꞊naɔmɛ 'ka 'ö go Adhimate ‑pö 'gü 'wo‑ ‑dhɛ Zosɛfu, 'ö ‑kë 'pö Yesu bha ꞊klangdhiʋ̈ do 'ka bha 'ö nu. ");
INSERT INTO daf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","'Yö gɔndënë bha 'ö dho Pidhatö \"piʋ̈ 'yö Yesu ꞊gee ‑gbadhɛ ‑gɔ. 'Yö Pidhatö ‑ya pö ‑wa dɔ‑ ‑gɔ, ");
INSERT INTO daf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","'yö Zosɛfu ‑yö Yesu ꞊gee bha‑ sü 'yö sɔ \"puu bɔ‑ ‑bha ");
INSERT INTO daf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'yö dho‑ 'ka 'ö‑ ‑da ‑a ‑dɩ ‑bha mɛ ‑wɛɛ bho ‑dhɛ ‑dee 'wo‑ pɔn‑ ‑dhɛ ‑gwë ‑tɔn 'gü bha‑ 'gü, 'yö ‑gwë gɔn 'kpii‑ do ꞊glün 'ö‑ ‑ya ‑yɛ bha‑ \"dhiʋ̈ 'yö dho. ");
INSERT INTO daf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","'Ö \"dhʋ̈ bha kö Madhi 'ö go Madadha bha waa‑ Madhi 'dhɛ 'ö bha ‑wo ‑ya sië \"gʋ̈ng ‑ta bunbhodhɛ bha‑ \"sɔɔ mü. ");
INSERT INTO daf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","(‑Wo Yesu ‑zë Zuifö ‑nu ‑bha ꞊glooyi yɛan\" \"piʋ̈ 'ka.) ꞊Dhɛ 'ö‑ ‑tadhɛ ꞊ya ꞊kpaɔ ‑a ‑nu ꞊glooyi ꞊dede bha‑ 'ka, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu 'wo dho Pidhatö \"piʋ̈ waa‑ Fadhiziɛn ‑nu 'dhö ");
INSERT INTO daf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","'yö 'wo‑ pö‑ ‑dhɛ: «Yi dëmɛ, 'wɔn do 'bha ‑yö ‑dhö. Yö ‑mü ꞊dhɛ 'ö gun kö ꞊suakëmɛ bha ‑yö ‑tun \"yaan, ‑yö kë‑ ‑pö 'ö‑ pö ꞊dhɛ: «'Ma ga yi 'ö‑ 'ka, a ‑dho ‑bö kö ‑dhɛkpaɔyi ꞊plɛ ꞊ya ziö, ‑a ‑yaaga ‑naa bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","꞊Dhɛ 'ö \"dhʋ̈, ‑bhö mɛ bɔ kö ‑wo ‑ya bun bha‑ ‑maa ‑gɔ kö ‑yö 'dho‑ 'ka \"dhʋ̈ ‑yö zun‑ 'ka‑ ‑dhɛkpaɔyi ‑yaaga ‑naa bha‑ ‑bha kö ‑a ‑bha ꞊klang ‑nu 'wa 'dho nu 'wo‑ ꞊gee ꞊kwaan 'wo dho 'wo ꞊sua ‑kë \"sɛgümɛ ‑nu ‑dhɛ ꞊dhɛ ꞊ya ‑bö ꞊ya 'go ga 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ kö‑ ‑nu ‑kɔ ‑yö ‑mɔɔ 'wɔn 'dhɛ 'kö bha‑ kë ‑sü ‑bha, ‑a 'gü ꞊sua 'wo dho‑ kë ‑yö ‑dho kë ‑ziisü 'ö ‑ziö ‑blɛɛsü ‑bha ‑zë ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","'Yö Pidhatö ‑ya pö‑ ‑nu ‑dhɛ: «‑Ka 'iin, ‑ka \"sɔdha ‑nu 'kun kö ‑wo 'dho kö ‑wa ‑maa kë ‑kɔ 'ö ‑dhi ka ‑dhɛ ‑a 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","'Yö 'wo ‑ziö 'wo dho. ꞊Dhɛ 'ö ꞊wa ꞊loo mü, 'yö 'wo 'klëë‑ kpɔ‑ bun bha‑ ‑bha kö mɛ ꞊yaa‑ \"dhiʋ̈ \"pʋ kö ‑wa ‑dhɛ yö, 'yö 'wo \"sɔdha ‑nu bha‑ ‑nu ‑ya ‑a ‑gɔ \"dhiʋ̈ kö ‑wo wo \"yan 'to‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","꞊Dhɛ 'ö Zuifö ‑nu ꞊glooyi bha ꞊ya ziö 'ö‑ ‑tadhɛ ꞊ya ꞊kpaɔ, 'yö Madhi 'ö go Madadha bha waa‑ Madhi 'dhɛ 'ö 'dhö 'wo ‑suʋ̈ 'piö‑ 'yö 'wo dho wo bhɔɔ\" bho Yesu bun ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","‑Wo ‑to mü 'yö \"sɛ 'dhö ‑ya ꞊zii ‑sü ‑bha ꞊dhɛ mɛ‑ ‑më ‑kë. \"Sɛ 'ö ꞊zii ‑ziisü 'ka \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö Atanna ‑bha \"kië do ꞊ya 'go dhang‑ 'gü ꞊ya nu kö ꞊ya ‑gwë 'ö gun Yesu bun \"dhiʋ̈ bha‑ bho 'mü kö ꞊yaa‑ glün‑ ꞊ya ‑ya ‑ta. ");
INSERT INTO daf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Atanna ‑bha \"kië bha‑ 'bhü‑ ‑gun ꞊dhɛ dha 'ö \"yaan kun‑ 'dhö, 'yö‑ ‑bha ‑sɔ ‑yö ‑flʋ̈ ‑papadhö. ");
INSERT INTO daf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Yö 'mɛ 'wo gun bun ‑maa kë sië bha \"suʋ̈ 'dhö ‑da ‑nu 'gü, 'yö 'wo ‑ya ꞊zii ‑sü ‑bha 'yö 'wo ‑pö \"sia‑ 'yö 'wo ‑kë ꞊dhɛ 'pë ꞊wa ga ꞊në‑ wo 'dhö. ");
INSERT INTO daf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","\"Kɛɛ 'yö Atanna ‑bha \"kië bha 'ö dhiang zë dhong ‑nu 'kö 'wo bha‑ ‑nu ‑dhɛ 'ö‑ pö: «\"Suʋ̈ 'ya 'dho ka ‑zë ka kë, ‑a ‑gɛn ‑mü ꞊dhɛ a‑ 'wɔn ‑dɔ ꞊dhɛ Yesu 'wo‑ dɔ \"dhü ‑bha bha ꞊në 'ka nu‑ mɔɔ‑ ‑dhɛ 'gü yö. ");
INSERT INTO daf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","\"Kɛɛ 'yaa yö 'zü ꞊ya 'go ga 'gü ꞊ya ‑bö ꞊dhɛ ‑kɔ 'ö‑ pö‑ 'ka ka ‑dhɛ kö 'yii ga ꞊kö bha‑ 'dhö. ‑Ka nu kö ‑dhɛ 'ö gun wɔ sië‑ ‑bha bha 'ka‑ ‑dhɛ ‑ga, ");
INSERT INTO daf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","kö 'ka 'dho 'ka‑ pö‑ ‑bha ꞊klang ‑nu ‑dhɛ ꞊dhɛ ꞊ya ‑bö, ꞊ya ‑da ka \"dhiʋ̈ ꞊ya 'dho Gadhidhe. Ka ‑dho ‑kpan ‑bha mü ꞊naa. 'Wɔn 'ö gun n \"piʋ̈ 'a‑ pö ka ‑dhɛ 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","'Yö 'wo dɔ ‑bɛang ‑bha 'wo dho kö \"suʋ̈ ‑ya ‑nu kë sië, \"kɛɛ kö ‑a ‑nu ꞊nii ‑yö ‑da sië 'pö ꞊dedewo. 'Yö 'wo dho kö 'wo‑ ‑gɛn dɔ Yesu ‑bha ꞊klang ‑nu bha‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","꞊Dhɛ 'wo 'dho sië 'wo dho \"kan wo ‑ta kö Yesu ꞊ya nu dɔ‑ ‑nu ‑gɔ zian‑ ꞊yaa‑ pö‑ ‑nu ‑dhɛ: «'Ka ꞊boo mü!» ꞊Dhɛ 'ö ꞊waa‑ yö, 'yö 'wo dho 'wo zun wo kpiö 'gü‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «\"Suʋ̈ 'ya 'dho ka kë, ‑ka 'dho 'ka‑ pö n dheebhang ‑nu ‑dhɛ ꞊dhɛ ‑wo 'dho Gadhidhe ‑sɛ 'gü, ‑wo ‑dho ‑kpan n ‑bha ‑dhɛ bha ꞊në‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","\"Tʋ̈ng 'ö dhong ‑nu bha 'wo 'dho sië‑ 'ka 'wɔn bha‑ ‑gɛn dɔ ‑dhɛ 'gü Yesu ‑bha ꞊klang ‑nu ‑dhɛ bha, kö bun ‑maakëmɛ ‑nu ‑dɩ 'pö‑ mɛ 'bha ‑nu ‑wo ‑da sië 'plöö 'wo ‑ziö Yesu ‑bö ‑kɔ zü bho ‑kɔ waa‑ \"dhiʋ̈ ‑ya ‑kɔ ꞊gban 'gü \"saabhomɛ ‑nu ‑gɔmɛ ‑nu bha‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","'Mɛ 'wo bha ꞊dhɛ 'ö ꞊wa ziö 'wɔn bha‑ ‑gɛn 'gü‑ ‑nu ‑dhɛ \"pɛɛpɛdhö, 'yö 'wo dho \"slën 'gü, 'yö 'wo wo ‑bha ‑ya 'kwëë‑ ‑kë waa‑ ‑kwɛagbö ‑nu 'dhö. ꞊Dhɛ 'ö‑ ‑nu ‑wʋ ꞊ya 'to do, 'yö 'wo nu 'wo 'wëë‑ 'gbɛ ꞊dede sü 'wo‑ nu \"sɔdha ‑nu bha‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","'Yö 'wo‑ pö‑ ‑nu ‑dhɛ 'wo‑ pö: «‑Kaa pö 'ö gun kö yi yi zë sië gbeng, 'yö‑ ‑bha ꞊klang ‑nu 'wo nu 'wo‑ ꞊kwaan, 'yö 'wo dho‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","꞊Ya kë ꞊dhɛ \"sɛdë ꞊ya 'wɔn bha‑ ma kö ‑ya pö 'ö 'wɔn 'bha kë ka 'ka ‑a ‑wɔn 'gü, yi ꞊në 'yi dho kpa‑ ‑zʋ ‑ta, 'yö 'yaa ka kë ‑kɔ 'bha 'gü. ");
INSERT INTO daf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","꞊Dhɛ 'ö ꞊waa‑ pö \"sɔdha ‑nu bha‑ ‑nu ‑dhɛ \"dhʋ̈, 'yö 'wo wo ‑kɔ ‑da 'wëë‑ bha‑ 'gü, 'yö 'wo‑ ‑kë ꞊dhɛ ‑kɔ 'wo ‑wʋ kpɔ‑ 'ka‑ ‑nu ‑bha bha‑ 'dhö. \"Kɛɛ 'yö ‑wʋ 'ö ‑gɔmɛ ‑nu ‑wa kpɔ bun ‑maakëmɛ ‑nu ‑bha bha‑ ‑wʋ ‑yö sɔ \"sɛ bha‑ 'gü ‑dhɛ ꞊gban \"pɛpɛ 'gü, 'ö nu 'ö zun‑ 'ka ꞊dɛɛ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","꞊Dhɛ 'ö Yesu ‑bha ꞊klang ‑nu bha ꞊wa 'wɔn bha‑ ma, 'yö 'wo dho Gadhidhe ‑sɛ 'gü, ‑tɔn 'ö Yesu ‑ya ‑dhɛ ‑zɔn ‑nu ‑dhɛ bha‑ ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo mü, 'yö 'wo ‑kpan ‑bha, 'yö 'wo zun‑ ‑dhɛ wo kpiö 'gü, \"kɛɛ yö ‑zë ꞊gban 'gü, 'mɛ 'wo bha‑ mɛ 'bha ‑nu ‑gun mü 'ö 'waa gun 'dhang bho sië Yesu ‑go ga 'gü ‑wɔn bha‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","꞊Dhɛ 'ö ꞊wa zun‑ ‑dhɛ kpiö 'gü \"dhʋ̈, 'yö Yesu ‑yö ꞊yɔɔn‑ ‑nu \"sɔɔ 'yö ö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: «‑Kɔ ‑ziö \"sɛ waa‑ dhang‑ ‑nu 'gü ‑pë ꞊gban \"pɛpɛ ‑gɔ ‑faan bha Atanna ꞊yaa‑ nu n ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","꞊Dhɛ 'ö \"dhʋ̈ ‑ka 'dho 'ka n ‑wɔn ‑dhiang zë \"sɛ \"pɛpɛ ꞊gban 'gü mɛ ‑nu ‑dhɛ kö ‑wo wo zuë\" slëë‑ n \"piʋ̈ kö 'ka‑ ‑nu ‑bɔ n 'ka ‑zu bho n Dë 'tɔ 'gü, ‑a Gbö 'tɔ 'gü, ‑a ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'tɔ 'gü. ");
INSERT INTO daf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kö 'ka‑ ‑nu ꞊klang kë ‑zʋ ‑kë pë \"pɛpɛ 'a‑ ‑bɛn zë 'a‑ to ka ‑gɔ bha‑ \"piʋ̈ ‑sü 'ka. ‑Yö kë ka \"yaan ꞊dhɛ a ka \"piʋ̈ yi ꞊gban 'ka 'ö to‑ 'ka \"dhʋ̈ 'ö zun‑ 'ka \"sɛ \"dhiʋ̈toyi ‑bha.»");
INSERT INTO daf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Naɔ ‑së 'ö go Atanna \"piʋ̈ 'ö ‑gban ‑a Gbö Yesu Klisi ‑wɔn ‑bha bha‑ zü bho ‑kɔ ꞊nɛ. ");
INSERT INTO daf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Atanna ‑wʋdhiʋ̈loomɛ Ezai ꞊në‑ ‑bɛn zë ö ‑gɔ 'sëëdhɛ 'gü yi 'bha 'ka 'ö‑ pö: «Atanna ‑ya pö (ö Gbö Yesu Klisi ‑nu \"kpʋng ꞊taa ‑wɔn 'gü) 'ö‑ pö: ‑Bhö i \"yan 'to, a ‑dho mɛ bɔ i \"dhiʋ̈ kö ‑yö zian bho i ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‑Dhɛa \"dhiʋ̈ bho ‑wʋ 'ö 'go sië \"tʋng ‑ta bha‑ ‑gɛn ꞊në bha ‑ya ‑pö: ‑Ka kwa Dëmɛ ‑bha zian ‑ba kö 'ka‑ du bho‑ 'gü kö 'ka‑ ‑tadhɛ ‑pë kë kö ‑yö wɔ drëngdrëngdhö!» ");
INSERT INTO daf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","'Mɛ 'wo‑ ‑dhɛ Zan 'ö gun mɛ ‑go 'wɔn yaa 'gü ‑zu bho sië bha, ‑yö ‑wlü ‑kɔ bha ꞊në‑ 'gü \"tʋng ‑ta, 'yö zun ‑dhɛa \"dhiʋ̈ bho ‑sü bha 'ö‑ pö: «‑Ka kaa‑ ‑tosɛa slëë‑ 'gü kö 'ka bɔ Atanna 'ka kö ‑wo ka \"zu, kö ‑yö kaa‑ 'wɔn yaa ‑nu ‑mawɔn 'to!» ");
INSERT INTO daf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, Zude ‑sɛgümɛ ‑nu \"pɛpɛ, 'ö dho 'ö ‑da 'ka Zedhizadhɛmö ‑mɛ ‑nu ‑bha, ‑wo ‑gun nu sië‑ \"piʋ̈, 'ö 'wo ‑wɩ wo këwɔn yaa ‑nu ‑bha mɛ ꞊gban \"yan \"dhiʋ̈, 'yö‑ ‑nu ‑zu \"yi 'wo‑ ‑dhɛ Zuudɛn bha‑ ꞊bhaa. ");
INSERT INTO daf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zan bha‑ ‑dasɔ ‑gun ‑yɔɔnmɛa kaa‑ wo‑ \"bhɛɛ ‑wɔ ꞊në‑ 'ka 'yö kwipɛn ‑kë bhiëga 'ka 'ö‑ dɔ ö ‑gɔ sɔ ‑ta, 'yö ‑kpaa ‑yö gun‑ ‑bhöpë 'ka waa‑ \"zɔyɔn 'dhö. (‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'wo gun ‑tosɛa kë sië \"tʋng ‑ta \"tʋ̈ng bha‑ 'gü ‑a ‑nu sɔ ‑da ‑kɔ waa‑ ‑nu ‑bhöpë ꞊në gun bha). ");
INSERT INTO daf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yö 'ö bha ꞊në gun‑ pö sië 'mɛ 'wo nu bha‑ ‑nu ‑dhɛ 'ö‑ pö: «Mɛ do 'bha ‑yö nu sië, ‑yö ‑dho nu n zian‑ ‑ta, yö ‑zë 'gü ‑yö \"gbɩɩ‑ 'ö ‑ziö n ‑ta, \"kɛɛ ‑a ‑gɛn 'gü ‑sabha ‑zian fië‑ ‑dhö n 'ka. ");
INSERT INTO daf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ma ‑zë a ka ‑zu \"yi ꞊në‑ 'ka, \"kɛɛ yö ‑zë ‑yö ‑dho ka pa 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ö go Atanna \"piʋ̈ ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, yi do 'bha bha‑ 'ka 'yö Yesu ‑yö ꞊wlü Nazadhɛtö ‑pö 'ö Gadhidhe ‑sɛ 'gü bha‑ 'gü, 'yö dho Zan \"piʋ̈, 'yö‑ ‑zu Zuudɛn ꞊bhaa. ");
INSERT INTO daf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","꞊Dhɛ 'ö ꞊ya ö bo ‑a \"zu ‑sü 'ka, 'ö Yesu 'dhö 'go sië \"yi ꞊bhaa, 'ö dho ‑dhɛ ‑ga kö dhang‑ \"dhi ꞊ya \"pʋ, kö 'Nii‑ 'ö go Atanna \"piʋ̈ ‑yö lɔɔ‑ sië‑ ‑ta ꞊dhɛ ‑tong 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","'Yö‑ \"tʋ 'dhö ‑da Atanna ‑wʋ 'gü kö ‑yö \"wɩ sië dhang‑ 'gü 'ö‑ pö: «Bhi ꞊në 'i n Gbö 'ka, i ‑dhɔ 'ö n ‑kë \"sinma \"yɔɔ 'yaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","꞊Dhɛ 'ö ꞊ya bo ‑kë \"dhʋ̈ ‑sü 'ka, 'yö 'Nii‑ 'ö go Atanna \"piʋ̈ 'ö ‑da 'gü bha 'ö ‑yö ‑dhɛ \"dhiʋ̈ 'yö dho‑ 'ka \"tʋng ‑ta (‑dhɛ 'bha bha‑ 'gü). ");
INSERT INTO daf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","'Dho 'ö Yesu ‑ya wo bha, ‑yö ‑dhɛkpaɔyi ‑kaɔng ‑yiisiö ꞊në‑ ‑kë mü kö \"yina ‑nu ‑bha ‑gblüdë 'wo‑ Sɔtraan ‑kë bha, ‑ya 'gü dan sië. Waa‑ \"bü ‑wü ‑nu ꞊në 'wo gun ‑tosɛa kë sië wo \"kwëë kö Atanna ‑bha \"kië ‑nu ‑wa \"dhiʋ̈ ‑ziö wo sië. ");
INSERT INTO daf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","꞊Dhɛ 'ö ꞊wa Zan 'kun ꞊waa‑ ‑da ‑kaso 'gü, 'yö Yesu ‑yö ꞊wlü, 'yö dho Atanna ‑bha naɔ ‑së bha‑ dɔ ‑dhɛ 'gü Gadhidhe ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","'Yö‑ pö 'mɛ 'wo mü ‑a ‑nu ‑dhɛ 'ö‑ pö: «\"Tʋ̈ng 'ö Atanna ‑ya ‑ya kö \"plüün 'ö‑ bho mɛ \"bhɩɩ‑ ‑nu ‑dhɛ bha 'ö‑ 'gü ‑wɔn kë‑ 'ka bha ꞊ya ꞊loo. ‑A ‑bha ‑gblüdëdhɛ kë \"tʋ̈ng 'yaa ꞊gblɛɛn 'zü. ꞊Dhɛ 'ö \"dhʋ̈, ‑ka ka bo ka ꞊sɔng 'ka kö 'ka ka zuë\" slëë‑ Atanna \"piʋ̈ kö 'ka 'dhang bho naɔ ‑së 'ö‑ bɔ ka ‑dhɛ ya‑ \"dhiʋ̈!» ");
INSERT INTO daf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","꞊Dhɛ 'ö yi do 'ka kö Yesu ‑yö ziö sië \"yitagbɛa 'ö Gadhidhe bha‑ \"kpʋng \"dhiʋ̈, 'yö ‑kpan \"nuuzuömɛ ꞊plɛ, Simɔ waa‑ ö dheebhang Andre ‑a ‑nu ‑bha kö ‑wo \"nuu ‑zuö sië \"yi bha‑ ꞊bhaa, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu ‑bha yë ꞊në gun 'yuʋ̈‑ zë ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","'Yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka nu kö 'ka ‑da n ꞊keng‑ kö 'a ka kë \"nuu ‑zuö mɛ ‑gɔ ‑mɛ ‑nu 'ka kö 'ka nu‑ 'ka n ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","‑Wo ‑to ‑dhɛ do bha‑ 'gü 'wo wo ꞊kwaa woo‑ \"nuu ‑nu ‑zü, 'yö 'wo ‑ziö ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","꞊Dhɛ 'ö go ‑dhɛ bha‑ 'gü 'ö \"ta 'në 'bha sü 'ö dho ꞊gblɛɛn, 'yö ‑kpan Zakö waa‑ ö dheebhang Zan 'wo ‑kë Zebede gbö ‑nu 'ka ‑a ‑nu ‑bha kö ‑wo ‑ya sië \"yitagɔ do 'gü kö ‑wo woo‑ \"nuu ‑nu ‑pë kë sië. ");
INSERT INTO daf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","꞊Dhɛ 'ö‑ ‑nu yö, 'yö to mü 'ö‑ ‑nu ‑dhɛ, 'yö 'wo wo dë Zebede waa‑ ö ‑bha yëkëmɛ ‑nu to 'mü, 'yö 'wo ‑ziö Yesu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","꞊Dhɛ 'wo dho 'wo ꞊loo 'pödhɛ do 'bha 'wo‑ Kapɛɛnaɔmö ‑dhɛ ‑kë bha‑ 'gü, 'ö Zuifö ‑nu ꞊glooyi ꞊ya ꞊loo, 'yö Yesu ‑yö dho ‑a ‑nu ‑bha ‑yakwëëkëgükɔ 'gü, 'yö ‑ya Atanna ‑wɔn ‑dhiang ‑zë mɛ ‑nu ‑dhɛ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","'Mɛ 'wo gun mü, 'ö 'wo‑ ‑wʋ ma, 'yö‑ 'wɔn ‑ya ‑nu kɔn, ‑a ‑gɛn ‑mü ꞊dhɛ \"trüün ‑yö ‑gun yö ‑zë ‑a ‑wʋ 'gü, ‑a ‑bha mɛ draan‑ ‑kɔ 'yaa gun ꞊dhɛ ‑a ‑nu ‑bha 'tɔnggɔmɛ ‑nu ‑bha 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","‑A \"tʋ̈ng ꞊dede bha‑ 'ka 'yö gɔndënë do 'bha 'ö \"yina yaa 'dhö‑ 'gü 'ö ‑da 'kɔɔdhö mü. 'Yö 'mɛ bha 'ö ꞊gbla 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yesu, Nazadhɛtö mi, 'kwa‑ ma mü? \"Ɛɛn i ‑nu kö 'i yi 'gü see‑ ‑ee? ‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ a i ‑gɛn ‑gban ‑kɔ ‑dɔ. A‑ 'wɔn ‑dɔ 'kpakpadhö ꞊dhɛ Atanna ‑bha ‑Yamɛ 'ö‑ bɔ yö ‑mü i 'ka!» ");
INSERT INTO daf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","'Yö Yesu ‑yö ꞊gbla‑ ‑ta 'ö‑ pö: «I \"dhi ta kö 'i ziö 'i 'go 'mɛ bha‑ 'gü!» ");
INSERT INTO daf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","'Yö \"yina yaa bha 'ö go 'mɛ bha‑ 'gü kö ‑yö \"gbla sië \"gbɩɩ‑ 'ka, \"kɛɛ kö 'mɛ bha ‑yö ‑gblagbla bho sië. ");
INSERT INTO daf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","'Yö mɛ \"pɛpɛ 'wo gun mü, 'wo zun \"kaabho ‑sü bha kö ‑wa pö sië wo 'ko ‑dhɛ 'wo‑ pö: «‑Më ‑wɔn suu ꞊në ꞊ni ‑oo? Mɛ 'ö ya‑ ‑bha mɛ draan‑ ‑kɔ ‑dee 'dhɛ 'kö ya‑ faan‑ 'gbiin‑ 'pö ‑kɛɛ! \"Yina yaa ‑nu ‑zian ‑wa ‑wʋ ‑ma 'wo ꞊dua‑ ‑gɔ ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö Yesu 'tɔ 'dhö zun‑ bhɔ ‑sü ‑bha Gadhidhe ‑sɛ bha‑ 'gü ‑dhɛ ꞊gban \"pɛpɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","꞊Dhɛ 'wo go Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ bha‑ 'gü, 'yö 'wo dho Simɔ waa‑ Andre ‑nu ‑gɔ 'kɔɔdhö kö Zakö waa‑ Zan ‑wa ‑nu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","'Ö \"dhʋ̈ bha kö Simɔ ‑bha dhebhɔ dhe ‑yö 'waanu ‑sü 'ka, kö \"nɛnɛ ꞊ya nu‑s‑ta, 'yö 'wo to 'wo nu 'wo‑ pö Yesu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","'Yö Yesu ‑yö ꞊yɔɔn‑ \"sɔɔ, 'yö ö ‑kɔ ‑da ‑a ꞊kwɛɛ‑, 'yö‑ ꞊wlü, ‑yö ‑to ‑dhɛ do bha‑ 'gü 'ö ‑kë \"klʋ̈ʋ̈klʋ̈, 'yö zun‑ ‑nu \"dhi mɔɔ‑ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","꞊Dhɛ 'ö dhɔng ꞊ya ‑da, kö 'yënng‑ ‑gɔ ꞊ya bo ‑pö ‑sü 'ka, 'yö 'wo nu \"yuëdhi ‑nu \"pɛpɛ 'wo gun ‑dhɛ bha‑ 'gü waa‑ 'mɛ 'ö \"yina yaa ‑yö gun‑ ‑nu 'gü ‑a ‑nu 'ka Yesu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kö 'pögümɛ ‑nu ꞊gban \"pɛpɛ ꞊wa bho 'ko ‑ta \"dhiëngdhö mü. ");
INSERT INTO daf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","'Yö \"yua suu 'do 'do 'ö gun 'mɛ ‑a ‑nu ‑bha 'do 'do 'ka, 'yö‑ mɛ 'gbɛ ꞊dede dha, 'yö \"yina yaa 'gbɛ ꞊dede ‑kë mɛ 'gü, \"kɛɛ 'yaa gun \"wɩ sië‑ ‑bha kö \"yina yaa ‑nu bha ‑wo \"wɩ, kë \"dhʋ̈ kö mɛ \"bhɩɩ‑ ‑nu 'wa 'dho ö dɔ ‑kɔ dɔ, ‑a ‑gɛn ‑mü ꞊dhɛ kö wo ‑zë ‑wa ‑dɔ. ");
INSERT INTO daf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","꞊Dhɛ 'ö‑ ‑tadhɛ ꞊ya ꞊kpaɔ, 'yö ‑suʋ̈ ‑dhɛkpaɔ tii 'gü, 'yö dho \"tʋngtadhɛ 'bha bha‑ 'gü 'yö ꞊bhɛa Atanna ‑dhɛ mü. ");
INSERT INTO daf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","'Yö Simɔ waa‑ ‑bha ꞊klang ‑nu ‑kpɛa 'wo to 'wo ‑ya ‑a mɔɔ‑ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","꞊Dhɛ 'wo dho 'wo ‑kpan ‑bha, 'yö 'wo‑ pö‑ ‑dhɛ: «Mɛ ꞊gban \"pɛpɛ ‑wo i mɔɔ‑ sië.» ");
INSERT INTO daf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","'Yö‑ pö‑ ‑nu ‑dhɛ: «‑Yö \"dhʋ̈ \"kɛɛ ‑ka ‑kwa 'dho 'pö‑ \"wɛɛwɛɛ 'dhɛ ‑nu 'wo kwa ‑züzü ya‑ 'gü kö 'a Atanna ‑wʋ pö 'mü 'pö, ‑a ‑gɛn ‑mü ꞊dhɛ n ‑nu \"kpʋng ꞊taa ‑gɛn ꞊në bha.» ");
INSERT INTO daf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","'Yö ‑da Gadhidhe ‑sɛ \"piʋ̈ Atanna ‑wʋ pö ‑sü 'ka Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü kö ‑yö \"yina yaa ‑nu kë sië. ");
INSERT INTO daf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yi do 'ka 'yö ꞊weeyuamɛ do ‑yö nu‑ \"piʋ̈, 'yö zun‑ ‑dhɛ ö kpiö 'gü, 'yö ꞊bhɛa‑ ‑dhɛ 'ö‑ pö: «N Dëmɛ, a ‑nu kö 'i n dha, ‑a ‑gɛn ‑mü ꞊dhɛ a 'dhang ‑bho \"dhiʋ̈ ꞊dhɛ ꞊ya ga ‑zë wo i 'gü, i ‑mɔɔ ‑bha 'i n ‑kë \"klʋ̈ʋ̈klʋ̈!» ");
INSERT INTO daf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ‑wëë ‑yö bɔ Yesu ‑ta, 'yö ö ‑kɔ pa‑ 'ka 'ö‑ pö: «꞊Ya ga n 'gü, ꞊dhɛ 'ö \"dhʋ̈, ‑bhö kë \"klʋ̈ʋ̈klʋ̈!» ");
INSERT INTO daf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mɛ bha ‑yö ‑to ‑dhɛ do bha‑ 'gü 'ö ꞊wee ‑yua bha 'ö bho‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ö ‑kɔ bho‑ 'gü, \"kɛɛ 'yö ‑dhio dɔ‑ ‑ta glɔglɔdhö 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Kë 'i‑ wo \"klʋ̈ʋ̈klʋ̈ bha, 'mii‑ pö 'i‑ ‑gɛn dɔ mɛ 'bha ‑mɛ 'bha ‑dhɛ ꞊kö, ‑bhö 'dho kö 'i i ‑dɩ ‑zɔn \"saabhomɛ ꞊në‑ ‑dhɛ ꞊kö ‑blɛɛsü kö ‑ya 'wɔn dɔ ꞊dhɛ 'bha kë \"klʋ̈ʋ̈klʋ̈ 'kpakpadhö, kö \"saa‑ 'ö Moizö ‑ya ‑zɔn 'ö Atanna ‑bha 'tɔng‑ 'sëëdhɛ 'gü 'ö ‑gban ‑kë \"klʋ̈ʋ̈klʋ̈ ‑kɔ suu bha‑ ‑bha bha 'i‑ bho kö mɛ ꞊gban \"pɛpɛ ‑wa 'wɔn dɔ‑ ‑bha ꞊tɔn ꞊dhɛ 'bha kë \"klʋ̈ʋ̈klʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","\"Kɛɛ 'mɛ bha 'ö bo 'go ‑sü ‑zë 'ka Yesu ‑kuu \"dhiʋ̈ kö ‑yö 'dho, ‑yö ‑ya ꞊në‑ wo 'wɔn bha‑ ‑dhiang zë ‑sü ‑bha ‑dhɛ ꞊gban \"pɛpɛ 'gü, 'yö‑ ‑taɔng ‑yö ꞊mɔɔ ‑dhɛ ꞊gban 'gü. ‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, 'ö dɔ mü kö Yesu 'yaa ꞊mɔɔ‑ ‑bha 'zü kö ‑yö ‑da 'pö‑ ‑nu 'gü mɛ 'bha \"yaan ('mɛ 'wo gun nu sië \"tʋ to‑ ‑wʋ ‑bha bha‑ ‑nu ‑kë 'gbɛ ‑kɔ yaa bha‑ ‑wɔn 'gü), kö ‑yö ‑dɔ ‑dhɛ \"gbɛadhɛ ‑nu 'wo 'pö‑ ‑züzü bha ꞊në‑ 'gü, waa‑ \"tʋngtadhɛ ‑nu 'dhö, 'yö mɛ ‑yö go ‑dhɛ ꞊gban \"pɛpɛ 'gü 'wo nu‑ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","꞊Dhɛ 'ö ‑dhɛkpaɔyi 'bha ꞊ya ziö, 'yö Yesu ‑yö ꞊wlü 'zü ‑deewo 'ö dho Kapɛɛnaɔmö ‑pö 'gü. 'Yö 'wo‑ ma ꞊dhɛ ꞊ya ꞊loo ö ꞊yëë \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mɛbhɩɩdhe doseng 'ö bho \"dhuu ‑zianwo yö ‑zë 'gü, ‑dɔ \"tɛɛ \"dhiʋ̈ ‑kɔ 'yii kë, 'ö ꞊yɔɔn mü kö ‑duɛ 'yaa 'kɔ \"dhiëngdhɛ ‑zian 'gü 'zü, 'yö Atanna ‑wɔn ‑dhiang zë‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","'Wo dho ‑dhɛ ‑ga kö ‑gɛnloomɛ do 'ö mɛ ‑yiisiö 'wo‑ 'sü ‑sü 'ka, ‑wo nu sië‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","\"Kɛɛ ‑dhɛ 'wo dho bɔ‑ ‑bha kö ‑wo ‑kpan Yesu ‑bha, ‑a ‑dhɛ 'yaa gun mɛ ‑kë 'gbɛ ‑kɔ ‑ziisü bha‑ ‑wɔn 'gü. ‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, 'yö 'wo ‑da 'kɔ 'ö gun‑ 'gü bha‑ ‑ta \"dhʋ̈ng 'gü, 'yö 'wo dho 'wo‑ \"dhi bho Yesu ‑ta \"dhʋ̈ng 'gü ‑dhɛ ꞊dede 'gü. 'Yö 'wo \"trüünyuamɛ bha‑ to ö ‑wɔtapë ‑ta, 'yö 'wo‑ ꞊lɔɔ bhië\" ‑bha Yesu ‑kuu \"dhiʋ̈ 'kɔɔdhö mü ");
INSERT INTO daf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","꞊Dhɛ 'ö ꞊yaa‑ 'wɔn dɔ ꞊dhɛ 'dhang ꞊dede ꞊në 'mɛ bha 'wo‑ bho ö \"dhiʋ̈, 'yö‑ pö ‑gɛnloomɛ bha‑ ‑dhɛ 'ö‑ pö: «N \"taɔngdë, 'ma i ‑bha 'wɔn yaa ‑nu ‑mawɔn 'to!» ");
INSERT INTO daf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","\"Kɛɛ 'ö gun‑ pö sië \"dhʋ̈ ‑dhɛ 'ö‑ 'gü bha kö 'tɔnggɔmɛ ‑nu 'bha ‑nu ‑wo ‑ya ‑sü 'ka mü kö ‑wo wo ‑zʋ gɔn sië 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Dhiang suu 'kö ya‑ zë ‑gɛn 'kö 'mɛ ya‑ ‑gɔ ‑a ‑gɛn ‑mü ‑më 'ka? ‑Yö ‑da ꞊në‑ wo sië Atanna \"dhiʋ̈ bha. 'Dee ꞊mɔɔ‑ ‑bha 'ö mɛ ‑bha 'wɔn yaa ‑mawɔn to kö 'yii kë Atanna ‑zë 'ka?» ");
INSERT INTO daf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","'Wɔn 'wo gun wo ‑zʋ 'gɔn sië 'ka \"dhʋ̈ bha, Yesu ‑ya ‑to ‑a ‑nu zuë\" \"piʋ̈ 'ö‑ dɔ, 'yö‑ pö‑ nu ‑dhɛ 'ö‑ pö: «Ka ‑zʋ 'gɔn ‑kɔ suu bha‑ kë ‑më ‑wɔn 'gü? ");
INSERT INTO daf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","‑A pö ‑sü 'ö \"trüünyuamɛ ‑dhɛ ꞊dhɛ «'bɔn ꞊ya 'go i ‑bha!» 'pö \"gbɩɩ‑ ‑ee? \"Ɛɛn ‑a pö ‑sü 'ö‑ ‑dhɛ ꞊dhɛ ‹‑bhö \"wlü kö 'i i ‑wɔtapë 'sü 'kii ziö!› yö ꞊në \"gbɩɩ‑?» ");
INSERT INTO daf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","'Yö‑ pö: «‑A kë 'a‑ wo \"dhʋ̈ bha a‑ ‑kë \"dhʋ̈ kö 'ka‑ 'wɔn ꞊në‑ dɔ ꞊dhɛ 'wɔn yaa ‑bho mɛ \"bhɩɩ‑ ‑nu ‑bha ‑sü 'ö \"kpʋng ꞊taa yö bha‑ \"sɩ ‑yö mang Mɛgbömɛ n ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ pö ‑gɛnloomɛ bha‑ ‑dhɛ: «Ma ꞊në 'a‑ pö, ‑bhö \"wlü kö 'i i ‑wɔtapë 'sü 'i 'dho i ‑gɔ 'kɔɔdhö!» ");
INSERT INTO daf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","‑Yö ‑to mɛ ꞊gban \"yan \"dhiʋ̈ ‑dhɛ do bha‑ 'gü mü 'ö ꞊wlü 'ö ö ‑wɔtapë sü 'ö ‑ziö. Kë 'ö‑ wo \"dhʋ̈ bha 'yö‑ 'wɔn ‑yö mɛ ꞊gban kɔn ꞊dedewo, 'yö 'wo‑ pö: «Atanna 'tɔ ‑yö bhɔ, ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn suu 'dhɛ 'kö ya, yi \"yan 'yii ‑da ‑dhɛ 'gü do!» ");
INSERT INTO daf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","꞊Dhɛ 'ö Yesu ‑yö go 'pö‑ bha‑ 'gü, 'yö ö wë ‑dee 'bha dɔ 'zü \"yitagbɛa 'ö Gadhidhe bha‑ \"pɛan \"piʋ̈. 'Yö mɛ kpö 'gbɛ ꞊dede 'wo nu‑ ‑dhɛ 'gü, 'yö Atanna ‑wɔn ‑dhiang zë‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","꞊Dhɛ 'ö ziö sië, 'yö Dhevi 'ö ‑kë Adhöfe gbö 'ka bha‑ yö kö ‑yö ‑ya ‑sü 'ka 'nii‑ sɔng bho‑ 'gü ‑kɔ 'gü, 'yö‑ pö‑ ‑dhɛ: «‑Bhö nu kö 'kwa 'dho!» 'Yö Dhevi ‑yö ꞊wlü 'ö ‑ziö ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo Dhevi ‑gɔ 'kɔɔdhö, 'ö Yesu ꞊ya zun pë ‑bhö ‑sü ‑bha, 'yö 'niisɔngkunmɛ ‑nu 'gbɛ waa‑ mɛ 'ö‑ ‑nu 'tɔ ꞊ya see‑ ‑a ‑nu këwɔn ‑nu ‑wɔn 'gü, waa‑ Yesu ‑bha ꞊klang ‑nu bha 'wo dho‑ \"piʋ̈, 'yö 'wo zun pë ‑bhö ‑sü ‑bha wo \"kwëë, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ suu 'wo \"dhʋ̈ bha‑ 'gbɛ ꞊në gun Yesu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","꞊Dhɛ 'ö 'tɔnggɔmɛ ‑nu 'wo Fadhiziɛn 'ka bha 'wo Yesu yö kö waa‑ 'niisɔngkunmɛ ‑nu waa‑ 'mɛ‑ ‑nu 'tɔ ꞊ya zë bha ‑wo pë ‑bhö sië wo \"kwëë, 'yö 'wo‑ pö‑ ‑bha ꞊klang ‑nu ‑dhɛ 'wo‑ pö: «‑Yö 'ö ‑kɔ ‑da 'niisɔngkunmɛ ‑nu, ꞊flümɛ ‑nu bha waa‑ Atanna ‑bha 'tɔngbhomɛ ‑nu bha‑ ‑nu \"piʋ̈ ‑më ‑wɔn 'gü?» ");
INSERT INTO daf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","꞊Dhɛ 'ö Yesu ‑ya ‑nu ‑wʋ bha‑ ma, 'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Nu 'a‑ wo \"kpʋng ꞊taa ya a ‑nu 'wɔnyaakëmɛ ‑nu ꞊në‑ ‑nu mɔɔ‑ kö ‑wo wo bo 'wɔn yaa kë ‑sü 'ka, 'mii nu 'mɛ 'wo‑ pö wo ‑dɩ ‑dhɛ ꞊dhɛ 'bɔn 'bha ‑bha 'bha 'yaa wo ‑bha bha‑ ‑nu mɔɔ‑ ‑dhɛ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö‑ 'gü 'yaa ‑së ꞊në‑ ‑mawɔn ‑yö zun ‑dhɔtrɔɔ ‑bha. ('Mɛ 'kö \"klʋ̈ʋ̈klʋ̈ ‑a ‑mawɔn 'yaa kë ‑dhɔtrɔɔ ‑bha.)» ");
INSERT INTO daf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yi do 'ka kö Zan Mɛzumɛ ‑bha ꞊klangdhiʋ̈ ‑nu ‑wo 'sunng‑ 'ma sië, waa‑ Fadhiziɛn ‑nu 'dhö, 'yö mɛ 'bha ‑nu bha 'wo nu Yesu \"piʋ̈, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «‑Yö ‑kë mü ꞊dhɛ 'yö Zan ‑bha ꞊klang ‑nu waa‑ Fadhiziɛn ‑nu ‑bha ‑nu ‑zë 'wo 'sunng‑ ma ꞊dhɛ ‑kɔ 'ö Atanna ‑wʋ ‑ya pö‑ 'ka ‑a 'dhö, 'yö i ‑bha ‑nu ‑zë 'waa‑ 'ma?» ");
INSERT INTO daf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Yö ka 'gü ꞊dhɛ 'mɛ 'ö ꞊wa nu‑ ‑bha dhe dɔ, ‑a ‑bha dhedɔmɛ ‑nu ‑dho ꞊gloo din‑ 'ka kö yöö ꞊dede ‑yö mü ‑ee? ‑Abin! 'Waa ꞊mɔɔ‑ ‑bha kö ‑wo din‑ \"dhiʋ̈ \"tʋ̈ng 'dhɛ 'kö bha‑ 'gü, (‑a ‑gɛn ‑mü ꞊dhɛ kö‑ ‑nu ꞊nii ‑yö ‑da ‑sü 'ka). ");
INSERT INTO daf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","\"Kɛɛ ‑a \"tʋ̈ng ‑yö nu sië, \"tʋ̈ng 'wo dho dhemɛdë 'sü‑ 'ka ‑a ‑nu ‑gɔ bha kö‑ ‑nu 'sunng‑ 'ma \"tʋ̈ng ꞊ya ꞊loo, (‑a ‑gɛn ‑mü ꞊dhɛ kö zuëdhiʋ̈tɛɛ ꞊ya ‑ya ‑nu ‑bha). ");
INSERT INTO daf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ mɛ 'bhaa sɔ zii \"pɛn ꞊nëng sɔ ‑dee ‑bha kö ‑wa ‑wɔ 'ka, ꞊ya kë \"dhʋ̈ ‑a sɔ ‑dee \"pɛn bha ‑yö sɔ zii bha‑ ‑gan, 'ö‑ \"pɛ ‑dhɛ ‑yö ‑da \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","\"Ɛɛn 'zü mɛ 'bhaa we ‑kiansü ꞊loo puu\" zii 'gü, ‑a we ‑yö puu\" bha‑ ‑bhö 'ö zua, 'ö ‑kë pë ꞊plɛ 'gü see‑ ‑sü 'ka. ‑Wo we ‑kiansü ‑da puu\" ‑dee ꞊në‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Zuifö ‑nu ‑bha ꞊glooyi do 'bha 'ka, kö Yesu waa‑ ‑bha ꞊klang ‑nu ‑wo zian ziö sië tapë suu 'bha 'ö bhɔ ‑mlü ‑bha, 'wo 'bluu‑ ‑kë 'ka, 'wo‑ ‑dhɛ 'ble‑ bha‑ ‑bhlaa 'gü. 'Yö‑ ‑bha ꞊klang ‑nu 'wo zun‑ ga ‑vlɔ ‑a ‑kpaa ‑bha ‑sü ‑bha kö ‑wa ‑bhö. ");
INSERT INTO daf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","꞊Dhɛ 'ö Fadhiziɛn ‑nu ‑wa ‑dhɛ yö, 'yö 'wo Yesu dhɛɛ\" kpɔ 'wo‑ pö: «‑Bhö i ‑bha ꞊klang ‑nu ‑ga! 'Wɔn 'wo‑ kë sië bha kë ‑pë ‑mü ꞊glooyi 'ka \"wɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «A‑ ‑pö bhaa, 'wɔn 'ö Davi ‑ya ‑kë yi 'bha 'ka kö din‑ ‑ya kë sië, waa‑ ꞊kengmɛ ‑nu 'dhö bha 'kii‑ ‑wʋ pö ꞊në‑ wo do Atanna ‑bha 'sëëdhɛ 'gü ‑ee? ");
INSERT INTO daf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","'Kii‑ ma do ‑dhɛ 'ö gun kö Abiataa ‑yö \"saabhomɛ ‑nu ‑gɔmɛ 'ka, Davi kë ‑da Atanna ‑gɔ 'kɔɔdhö 'ö 'bluu‑ 'wo‑ ‑dhɔkë 'ka mü, 'ö mɛ \"wɛɛ 'bha 'yaa‑ ‑bhö kö 'yii kë Atanna ‑bha \"saabhomɛ ‑nu ‑zë ‑nu 'ka bha‑ ‑bhö, 'ö go mü 'ö‑ 'bha ‑zian nu ö ꞊kengmɛ ‑nu ‑dhɛ 'wo‑ ‑bhö 'pö ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","꞊Dhɛ 'ö ꞊yaa‑ ‑nu dhɛɛ\" 'kpɔ \"dhʋ̈, 'yö go mü 'ö‑ pö‑ ‑nu ‑dhɛ: «Atanna ‑yö ꞊glooyi ‑da mɛbhɩɩdhe ꞊në ‑dhɛ, 'yii mɛ \"bhɩɩ‑ ‑zë ‑da ꞊glooyi ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","‑A ‑kë \"dhʋ̈ ‑sü 'gü, mang Mɛgbömɛ ꞊në ma ꞊glooyi 'dhö 'dhö, (꞊dhɛ 'ö \"dhʋ̈, kö 'wɔn 'ö ma ꞊klang ‑nu ‑wa ‑kë bha 'yaa 'wɔn yaa 'ka).» ");
INSERT INTO daf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö dho 'zü ‑deewo 'ö ‑sɔ Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ 'gü. ‑A yi 'ö bha‑ 'ka, kö mɛ do 'bha 'ö‑ ‑kɔ 'dhö ga ‑sü 'ka‑ ‑bha bha ‑yö mü. ");
INSERT INTO daf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","'Mɛ 'wo gun mü bha ‑wo ‑gun Yesu 'suan‑ bho sië 'pö, kë \"dhʋ̈ kö ꞊ya 'mɛ bha‑ kë \"klʋ̈ʋ̈klʋ̈ ꞊glooyi bha‑ 'ka kö 'wo‑ kë woo‑ za ‑gɛn 'ka ‑a ‑bha kö 'wo‑ 'kun ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","'Yö Yesu ‑ya pö mɛ ‑kɔ ꞊niɔɔsü bha‑ ‑dhɛ: «‑Bhö \"wlü kö 'i dɔ i ‑gɛan mɛ kpö 'gü bha!» ");
INSERT INTO daf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ pö 'mɛ 'wo gun‑ ‑gɛn mɔɔ‑ sië bha‑ ‑nu ‑dhɛ 'ö‑ pö: «Kwa ‑bha 'tɔng‑ ‑ya ‑pö ꞊dhɛ? ‑Ya ‑pö ‑wo 'wɔn ‑së ꞊në‑ kë ꞊glooyi 'ka \"ɛɛn ‑wo 'wɔn yaa ꞊në‑ kë? ‑Wo mɛ dha ꞊në‑ wo, \"ɛɛn ‑wa ‑mɛ 'to ꞊në‑ wo mü kö‑ 'gü‑ see‑?» \"Kɛɛ 'yö‑ ‑nu dhɛɛ\" 'ö‑ kpɔ \"dhʋ̈ bha, 'yö ‑dhɛa ‑yö ga‑ ‑nu ‑ta dingdhö, 'yö mɛ do 'yii ꞊slɔɔ‑ ‑nu kpö 'gü kö ‑ya ‑yɔ bɔ. ");
INSERT INTO daf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ö \"yan ꞊nië‑ ‑nu ‑ta ‑drüüüdhö, \"kɛɛ kö‑ ‑nu zuë\" ‑kë \"glɔɔglɔɔ ‑kɔ bha, ꞊ya ‑siö ‑dhɛ ꞊dedewo kö bhlɔɔ ꞊ya 'ma‑ 'gü. 'Yö‑ pö mɛ ‑kɔ ꞊niɔɔsü bha‑ ‑dhɛ: «‑Bhö i ‑gbe 'gü \"pʋ!» 'Yö‑ 'gü ‑pʋ, ‑yö ‑to mü 'ö‑ ‑kɔ bha 'ö bo. ");
INSERT INTO daf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö Fadhiziɛn ‑nu bha 'wo zun \"kpɛnng, 'yö waa‑ ‑gblüdë Edhodö \"piʋ̈ ‑mɛ ‑nu 'wo dho Yesu zë ‑wɔn \"slën 'gü. ");
INSERT INTO daf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","'Yö Yesu ‑yö go ‑dhɛ 'dhɛ bha‑ 'gü, 'yö ö wë dɔ \"yitagbɛa 'ö Gadhidhe bha‑ \"pɛan \"piʋ̈ waa‑ ‑bha ꞊klang ‑nu 'dhö. 'Yö mɛ kpö 'gbɛ ꞊dede 'wo go Gadhidhe ‑sɛ oo, ");
INSERT INTO daf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Zude ‑sɛ ‑nu oo, Zedhizadhɛmö ‑dhɛ ‑nu oo, Idume ‑sɛ ‑nu oo, Tii‑ ‑dhɛ waa‑ Sidɔn ‑dhɛ ‑nu ‑züzü ‑dhɛ ‑nu waa‑ Zuudɛn ꞊taama ‑dhɛ ‑nu 'gü, 'yö mɛ kpö ‑ziisü bha 'wo nu‑ ‑dhɛ 'gü, kö 'wɔn ‑nu 'ö‑ kë sië bha ꞊waa‑ ma. ");
INSERT INTO daf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","꞊Dhɛ 'ö 'mɛ 'wo bha‑ ‑nu ‑ta ‑ga kö ꞊ya kë ‑ziisü, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ ꞊dhɛ ‑wo 'dho kö ‑wo \"yitagɔ 'në 'dɛdɛ do 'sü kö ‑wo nu‑ 'ka ö ‑dhɛ kö 'ö dɔ‑ 'gü kö 'wa 'dho ö bhlʋʋ‑. ");
INSERT INTO daf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ mɛ \"pɛpɛ 'ö‑ ‑nu 'gü 'yaa gun ‑së, ‑wo ‑gun drun ꞊në‑ dɔ sië‑ ‑ta kë \"dhʋ̈ kö 'wo zun‑ ‑bha, \"yua 'ö gun‑ bho sië mɛ ‑nu ‑bha bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","\"Yinayaamɛ ‑nu ꞊waa‑ yö, 'yö 'wo zun‑ ‑dhɛ wo kpiö 'gü 'wo‑ pö: «Atanna Gbö ‑mü i 'ka!» ");
INSERT INTO daf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","\"Kɛɛ 'yö Yesu ‑yö ‑dhio dɔ‑ ‑nu ‑ta glɔglɔdhö, 'ö ö kɔngga ꞊ziö‑ 'ka‑ ‑nu ‑dhɛ \"sɛɛ 'ö‑ pö 'wa 'dho ö ‑kë Atanna Gbö 'ka ‑wɔn pö mɛ 'bha ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","'Ö go mü 'yö dho 'ö ‑da ‑tɔn ꞊gbin‑, 'yö 'mɛ 'ö‑ ‑nu ‑dhɛ ‑wɔn ‑yö ga‑ 'gü ‑a ‑nu ‑dhɛ, 'yö 'wo dho‑ ‑dhɛ 'gü ‑tɔn ꞊gbin‑ mü. ");
INSERT INTO daf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","'Yö dho 'yö‑ mɛ ‑kaɔng do ga ꞊plɛ ‑ya kö wo ‑zë ‑wo kë ö ꞊keng‑, ");
INSERT INTO daf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kö 'ö faan ‑da ‑nu 'gü kö 'ö‑ ‑nu bɔ Atanna ‑bha ꞊naɔ dɔ ‑dhɛ 'gü, kö ꞊wa 'dho kö ‑wo \"yina yaa ‑nu kë faan bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mɛ ‑kaɔng do ga ꞊plɛ 'ö‑ ‑nu ‑ya \"dhʋ̈ bha, ‑wa mɛ do ‑dhɛ Simɔ, 'yö yö ‑zë 'ö‑ 'tɔ kpɔ Piɛdhö, ");
INSERT INTO daf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","'yö Zebede gbö ‑nu ꞊plɛ Zakö waa‑ ö dheebhang Zan 'ö‑ ‑nu 'tɔ kpɔ 'ö‑ pö ‑wa ‑nu ‑dhɛ Boanɛzɛsö (꞊waa‑ pö \"dhʋ̈ kö ‑wa ‑pö ‹'mɛ 'wo bhɔ dha \"wɩ ‑sü ‑bha›), ");
INSERT INTO daf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","'yö Andre, 'yö Fidhipö, 'yö Batedhemi, 'yö Matiö, 'yö Toma, 'yö Adhöfe gbö Zakö, 'yö Tade, 'yö Simɔ 'ö go \"sɛ ‑ta ‑ko zë ‑mɛ ‑nu suu 'gü, ");
INSERT INTO daf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","'yö Zuda Isikadhiɔtö 'ö Yesu \"dhiʋ̈ dɔ bha. ");
INSERT INTO daf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","꞊Dhɛ 'ö Yesu waa‑ ö ‑bha ꞊klang ‑nu ꞊wa wo yee kë ꞊wa nu \"kwɛandhö, 'yö mɛ ‑yö bho 'zü \"dhuu ‑deewo 'yö 'wo nu mü, 'yö waa‑ ö ‑bha ꞊klang ‑nu woo‑ kë ‑zianwo ‑kɔ 'ö 'gü kö ‑wo pë ‑bhö ‑a ‑kɔ 'yaa gun. ");
INSERT INTO daf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","꞊Dhɛ 'ö‑ ‑bha mɛ ‑nu 'wo 'wɔn ‑nu 'ö‑ kë sië bha‑ ma, 'yö 'wo nu kö 'wo‑ 'kun kö 'wo 'dho‑ 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö wo ‑zë ‑wa pö sië pë ꞊në ꞊ya ‑da \"yan 'gü. ");
INSERT INTO daf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","\"Kɛɛ kö 'tɔnggɔmɛ ‑nu 'kö 'wo go Zedhizadhɛmö 'wo nu bha, wo ‑zë ‑wa pö sië ꞊dhɛ: «\"Yina ‑gblüdë 'wo‑ Bɛɛzebidhö ‑kë bha ꞊në‑ 'gü, kö mɛ 'bha ‑nu ‑wa pö sië 'pö ꞊dhɛ ‑yö \"yina yaa ‑nu ‑kë ‑a ‑nu ‑gɔmɛ bha ꞊në‑ faan 'ka. ");
INSERT INTO daf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","꞊Dhɛ 'ö Yesu ꞊yaa‑ ma, 'yö‑ ‑nu ‑dhɛ, 'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ \"gwënng 'gü 'ö‑ pö: «Sɔtraan ‑zë ‑yö Sɔtraan \"piʋ̈ kë ‑kɔ ‑kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","'Yö‑ pö: «꞊Ya kë ꞊dhɛ \"sɛgɔ do ꞊ya \"pɛ kö‑ 'gü ‑mɛ ‑nu ‑wo ‑gblü gɔɔn wo \"kwëë, ‑a \"sɛ bha ‑yö dɔ ‑kɔ ‑kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","'Yö‑ pö: «꞊Ya kë ꞊dhɛ 'kɔ do 'gü ‑mɛ ‑nu ꞊wa \"pɛ 'gü kö ‑wo ‑ya 'ko ‑san 'ka, ‑a 'kɔ bha ‑yö pa ‑kɔ ‑kë ꞊dhɛ? ");
INSERT INTO daf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","꞊Ya kë \"dhʋ̈, 'ka‑ pö ꞊dhɛ a \"yina yaa \"piʋ̈ kë sië Sɔtraan ꞊në‑ faan 'ka, kö‑ ‑bha 'kɔ 'yii \"pɛ‑ 'gü ꞊naa bha ‑ee? ꞊Ya kë \"dhʋ̈, ‑yö ‑mɔɔ ‑bha 'ö‑ 'kɔ 'kö bha ö dɔ ‑kɔ ‑kë ꞊dhɛ? ꞊Ya kë \"dhʋ̈, kö‑ 'kɔ 'dhɛ 'kö bha 'yii 'wü ꞊naa bha ‑ee? ");
INSERT INTO daf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","\"Ɛɛn ‑wo ‑mɔɔ ‑bha 'wo ‑da ‑kɛgbaan 'bha ‑gɔ 'kɔɔdhö, 'yö 'wo zun‑ ꞊kwɛɛ‑ ‑nu ‑wlö ‑sü ‑bha kö 'wii‑ ‑lö ꞊kö ‑blɛɛsü kpɛnngkpɛnngdhö ‑ee? ‑Abin! ‑A ‑mɛ 'yaa 'dhö. \"Fɔn kö ‑wa ‑mɛ ‑lö ꞊në‑ wo ‑blɛɛsü ꞊kö kö ‑kɔ gun ‑na ꞊mɔɔ‑ ‑bha kö ‑wa ꞊kwɛɛ‑ ‑nu ‑wlö.» ");
INSERT INTO daf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Atanna ‑dho 'wɔn yaa ꞊gban \"pɛpɛ suu 'do 'do ‑mawɔn 'to mɛ \"bhɩɩ‑ ‑nu ‑dhɛ (kö ꞊wa bhɛa\"‑ ‑dhɛ ‑a ‑wɔn 'gü), 'ö ꞊ya kë ꞊dhɛ yöö ‑zian ꞊në ꞊waa‑ ‑bhafang bho ‑kɔ suu \"ʋʋ suu 'ö‑ 'gü, 'ö ‑mɔɔ ‑bha 'ö‑ ‑mɛ ‑mawɔn to (kö ꞊ya bhɛa\"‑ ‑dhɛ), ");
INSERT INTO daf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","\"kɛɛ mɛ \"ʋʋ mɛ 'ö ‑da Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ \"dhiʋ̈, 'ö‑ ‑bhafang bho, Atanna 'yii 'dho‑ ‑mɛ ‑mawɔn 'to tongtongdhö. Kö 'wɔn yaa suu 'ö ꞊waa‑ kë 'ö‑ 'bɔn ‑yö to mɛ bha ‑todhʋ̈ 'ka ꞊në ꞊yaa‑ kë bha. ");
INSERT INTO daf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","‑A pö 'ö Yesu ‑ya wo \"dhʋ̈ bha, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊waa‑ pö ꞊në‑ wo‑ ‑dhɛ ꞊dhɛ \"yina yaa ꞊në‑ 'gü, 'yö \"yina yaa ‑nu kë sië‑ faan 'ka bha. ");
INSERT INTO daf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","‑Yö ‑to dhiang ‑nu bha‑ ‑nu zë ‑dhɛ 'gü, 'yö‑ dhe waa‑ dheebhang ‑nu 'wo nu, 'yö 'wo dɔ \"kpɛnng 'wo mɛ bɔ‑ ‑dhɛ ‑dhɛ 'gü 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","'Mɛ 'ö dho bha ‑yö ‑kpan ‑bha kö mɛ kpö ꞊wa ꞊klëën‑ ‑zü, 'yö‑ pö‑ ‑dhɛ: «‑Bhö ‑dhɛ ‑ga, i dhe waa‑ i dheebhang ‑nu ꞊wa nu i mɔɔ‑ ‑dhɛ 'gü, ‑wo dɔ sië \"kpɛnngdhö.» ");
INSERT INTO daf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","'Yö‑ ‑yɔ bɔ‑ ‑mɛ ‑gɔ 'ö‑ pö: «De në 'ka‑ ‑dhɛ sië n dhe \"ɛɛn n dheebhang ‑nu bha?» ");
INSERT INTO daf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ö \"yan ꞊nië 'mɛ 'wo gun ꞊klëën ‑sü 'ka‑ ‑zü bha‑ ‑nu ‑ta 'yö‑ pö: «‑Ka ‑dhɛ ‑ga, n dhe waa‑ n dheebhang ‑nu ꞊në 'wo ya. ");
INSERT INTO daf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","‑A ‑gɛn ‑mü ꞊dhɛ mɛ \"ʋʋ mɛ 'ö n Dë Atanna ‑dhidhɛwɔn ‑kë kö yö ꞊në n dhe \"ɛɛn n dheebhang 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","꞊Dhɛ 'ö Yesu ‑yö go mü, 'yö dho 'zü ‑deewo Atanna ‑wʋ ‑pö mɛ ‑nu ‑dhɛ ‑dhɛ 'gü \"yitagbɛa 'ö Gadhidhe bha‑ \"kpʋng \"dhiʋ̈. ꞊Dhɛ 'ö mɛ 'gbɛ ꞊dede ꞊wa nu ꞊wa ꞊loo mü ('ö ‑gɛnziödhɛ 'bhaa 'dhö 'zü mɛbhɩɩdhe ‑gɔ), 'yö dho 'ö ‑da \"yitagɔ do 'gü \"yi ‑ta. 'Yö mɛ \"pɛpɛ bha‑ ꞊gban to \"sia‑ \"yi \"kpʋng \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","'Yö dhiang 'gbɛ ꞊dede zë‑ ‑nu ‑dhɛ \"gwënng 'gü 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«‑Ka ka \"tʋ 'to! Yi do 'ka, 'yö 'kekëmɛ do ‑yö ꞊wlü 'ö dho ö ‑bha pë ta ‑dhɛ 'gü ö ‑gɔ 'bhlaa. ");
INSERT INTO daf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","꞊Dhɛ 'ö zun 'pë 'ö dho‑ ta bha‑ ‑pɛn ‑sü ‑bha, 'yö‑ \"pɛan 'bha ‑yö ꞊wɛnng zian ‑gloo \"piʋ̈ ('yö 'yii 'dho \"sɛɛdhö), 'yö ‑maa ‑nu 'wo nu 'wo‑ ‑bhö. ");
INSERT INTO daf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'Yö‑ ‑kɔ \"pɛan 'bha ‑yö ꞊wɛnng ‑gwë 'saa‑ \"dhiʋ̈, ‑dhɛ 'ö \"sɛ 'yaa mü 'gbɛ bha‑ 'gü, 'yö to 'ö bhɔ 'dho 'ö 'yii‑ wo \"sɛɛdhö ꞊gblɛɛn bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","\"Kɛɛ ꞊dhɛ 'ö 'yënng‑ ꞊ya zun 'bhü ‑sü ‑bha, 'yö‑ ꞊gban ‑yö \"kpɛa kpɔ \"pɛɛpɛdhö ‑a yun ziö ‑dhɛ 'ö 'yaa 'dhö bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'Yö‑ ‑kɔ \"pɛan 'bha‑ dho 'zü 'ö ꞊wɛnng \"glɛɛn ‑kpɔɔ 'gü. ꞊Dhɛ 'ö waa‑ \"glɛn ‑nu bha‑ ‑nu ꞊gban ꞊wa bhɔ, 'yö \"glɛɛn ‑kpɔɔ faan ‑yö ‑kë ‑ta 'gbiin‑ 'yö‑ ‑kpaa 'yii kë. ");
INSERT INTO daf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'Yö‑ ‑kɔ \"pɛan 'bha ‑yö ꞊wɛnng \"sɛ ‑së 'gü, 'yö bhɔ, 'yö ꞊kpɛa, 'yö yö ‑zë 'ö ‑dhi. 'Yö‑ ‑kpaaga do ga ‑yö ‑kë ‑bha ‑kaɔng ‑yaaga, ‑kaɔng \"saɔdo, \"ɛɛn këng do ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","꞊Dhɛ 'ö ꞊ya ö bo \"gwënng bha‑ ‑da ‑sü 'ka, 'yö‑ pö: «'Mɛ 'ö‑ 'wɔn ma ‑tʋ 'dhö 'dhö ‑ya 'gü ma!» ");
INSERT INTO daf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","꞊Dhɛ 'wo to wo do 'ka, 'yö‑ ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha ‑waa 'mɛ 'wo gun‑ ꞊keng‑ mü 'wo‑ dhɛɛ\" kpɔ \"gwënng ‑nu 'ö‑ ‑da bha‑ 'klɔɔ‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Ka ꞊në Atanna 'dhö ö ‑bha ‑gblüdëdhɛ 'ö ‑bin ‑sü 'ka bha‑ ‑ta \"pʋ ‑sü 'ka ka ‑dhɛ, \"kɛɛ 'mɛ ‑kpɛa 'kö 'wo to ‑wo ‑dho wo ‑bha ma \"gwënng ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kë \"dhʋ̈ kö ('pë 'ö Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑ya pö yi 'bha 'ka ꞊dhɛ: Kë \"dhʋ̈ kö) ‑Wa ‑dhɛ yö wo \"yan 'ka, \"kɛɛ kö 'wa 'dho‑ dɔ, kö ‑wa ma wo \"tʋ 'ka, \"kɛɛ kö 'wa 'dho‑ 'gü ma ö 'klɔɔ‑ 'ka 'ö 'wo wo zuë\" ꞊slëë Atanna \"piʋ̈, 'ö‑ ‑nu ‑mawɔn 'to bha‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö go mü 'ö‑ pö‑ ‑nu ‑dhɛ: «\"Gwënng 'a‑ ‑da bha 'kaa‑ 'klɔɔ‑ dɔ ‑ee? ꞊Ya kë ꞊dhɛ 'kii‑ 'dhɛ 'kö bha‑ 'gü ma, ka ‑dho ‑a ‑kpɛa 'ö to‑ 'gü ma 'sa ‑kɔ ‑kë ꞊dhɛ? ");
INSERT INTO daf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","\"Gwënng 'a‑ ‑da bha‑ 'klɔɔ‑ ꞊nɛ: Pëtamɛ 'ö pëga ‑pɛn bha ꞊në ꞊dhɛ Atanna ‑bha naɔdɔmɛ 'dhö, 'yö‑ tapë ga bha 'ö‑ Atanna ‑wʋ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","'Yö \"tʋ ‑to ‑a ‑wʋ ‑bha ‑mɛ ‑nu bha‑ mɛ 'bha ‑nu zuë\" 'dhö ꞊dhɛ zian ‑gloo \"piʋ̈ ‑dhɛ 'dhö. 'Yö dhiang 'wo‑ zë‑ ‑nu ‑dhɛ bha 'ö ꞊dhɛ pëga 'ö ꞊wɛnng zian ‑gloo ‑ta bha‑ 'dhö. ꞊Wa bo Atanna ‑wʋ ma ‑sü 'ka, 'yö Sɔtraan ‑yö nu 'yö‑ ꞊gban bho‑ ‑nu ‑zʋ ‑bha \"pɛɛpɛdhö. ");
INSERT INTO daf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","'Yö‑ mɛ 'bha ‑nu zuë\" 'dhö ‑kë 'zü ꞊dhɛ ‑gwë 'saa‑ \"dhiʋ̈ ‑dhɛ 'ö \"sɛ 'yaa mü 'gbɛ ‑a 'dhö. ꞊Wa bo Atanna ‑wʋ ma ‑sü 'ka, ‑wo ‑to mü 'ö‑ ‑nu ‑zʋ kun 'ö 'wo ‑wɩ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","\"Kɛɛ ‑a zü 'yaa kë ‑gban ‑sü 'ka ‑a ‑nu zuë\" \"piʋ̈. ꞊Wa bo 'dhang ‑bho Atanna ‑wʋ \"dhiʋ̈ ‑sü 'ka, 'yö 'wo ꞊nëng‑ ‑bha \"tʋ̈ng 'në 'bha 'ka, \"kɛɛ ꞊dhɛ 'ö sëëbhodhe ‑yö nu, 'ö 'wo zun Atanna ‑bha mɛ ‑nu ‑wëëdhɛ bho ‑sü ‑bha, 'yö 'wo ‑kan ‑a ‑wʋ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","'Yö‑ mɛ 'bha ‑nu zuë\" 'gü ‑dhɛ 'dhö ꞊dhɛ \"glɛɛn ‑kpɔɔ 'gü ‑dhɛ 'dhö; ‑wo Atanna ‑wʋ ma ‑zë ‑wo, ");
INSERT INTO daf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","\"kɛɛ 'yö ‑tosɛa kë ‑sü 'ö \"kpʋng ꞊taa bha‑ ‑zʋgɔndhe waa‑ ꞊naɔ ‑wɔn ‑nu waa‑ pë \"wɛɛ ‑nu ‑wɔn ‑zʋgɔndhe ‑yö dho 'ö sɔ Atanna ‑wʋ 'wo‑ ma bha‑ ‑ta 'yö‑ ꞊trɔɔn 'yaa kë. ");
INSERT INTO daf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","\"Kɛɛ 'yö‑ mɛ 'bha ‑nu ‑dɩ 'pö‑ ‑nu zuë\" ‑yö ‑kë ꞊dhɛ \"sɛ ‑së 'dhö, 'yö ꞊wa Atanna ‑wʋ ma, 'yö 'wo 'dhang bho‑ \"dhiʋ̈, 'yö 'wo ꞊trɔɔn ‑kë Atanna ‑dhɛ, 'yö ‑kë ꞊dhɛ ‑mlü 'ö‑ ‑kpaaga do ga‑ ‑kë ‑bha ‑kaɔng ‑yaaga, ‑kaɔng \"saɔdo, këng do ‑nu 'gü bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'Yö go mü 'ö‑ pö: «\"Ɛɛn ‑yö ka 'gü ꞊dhɛ ‑dhangbha 'wo dɔng ꞊sië 'kɔɔdhö bha, ‑wa ‑dɔ kö ‑wa ‑da gbɔ ꞊wlöö ꞊naa, \"ɛɛn kö ‑wa ‑da 'dhii‑ ꞊wlöö ꞊naa ‑ee? ꞊Waa‑ dɔ 'waa‑ ‑ya ‑dhangbha ‑dɔtapë ‑zë ‑ta ‑ee? ");
INSERT INTO daf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","‑Yö kë ka \"yaan ꞊dhɛ pë \"pɛpɛ 'ö ‑gblɛn 'kpɔ 'gü, ‑a ꞊gban ‑dho zun zang ‑ta. ꞊Dhɛ 'wɔn 'bha ‑wɔn 'bha 'gü 'yii 'dho 'to tii 'ka kö ‑dhɛ 'yii yö‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","꞊Dhɛ 'ö \"dhʋ̈, 'mɛ 'ö‑ 'wɔn ma ‑tʋ 'dhö 'dhö ‑ya dɔ ‑së 'ka kö ‑ya 'gü ma!» ");
INSERT INTO daf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","'Yö go mü 'zü 'ö‑ pö‑ ‑nu ‑dhɛ: «‑Ka ka \"tʋ̈ng kë ‑wʋ ‑nu 'ka‑ ma sië bha‑ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ pë do 'ka‑ sü 'ka pë dan‑ 'ka mɛ ‑dhɛ bha ꞊në Atanna dho‑ 'sü 'yö ka ‑bha dan‑ 'ka 'pö, 'yö ka taa ‑da ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ pë 'dhö 'mɛ 'ö‑ ‑gɔ 'ö‑ ‑ziö 'gü ‑ziö, 'yö 'wo dho‑ ‑mɛ taa kë, \"kɛɛ mɛ 'dhɛ 'kö‑ ‑bha 'yaa 'gbɛ, \"kɛɛ 'ö 'yaa‑ ‑ziö 'gü ziö bha, ‑a 'dhɛ 'në 'ö‑ ‑gɔ ꞊në 'wo dho‑ 'sü‑ ‑gɔ ‑zianwo do.» ");
INSERT INTO daf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","'Yö go mü 'zü 'ö‑ pö: «Atanna ‑bha ‑gblüdëdhɛ bha ‑yö ꞊dhɛ mɛ 'ö ꞊wlü 'ö dho 'ö pë ta ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","꞊Ya ö bo‑ ‑da ‑sü ‑zë 'ka \"sɛɛdhö, ‑yö ‑to \"yaan oo, ‑yö yi ‑zian ꞊në zë oo, tapë 'kö bha ‑yö ‑bhɔ 'ö ö ‑bha \"gla ꞊gban wo ö ‑dɩ ‑ta kö 'yaa‑ ‑kɔ 'bha dɔ. ");
INSERT INTO daf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","\"Sɛ 'ö pë ta‑ 'gü bha ꞊në ö ‑dɩ 'gü \"slë ‑kë, 'yö 'pë 'wo‑ ta bha 'ö bhɔ, 'yö dho 'ö ‑kë pë ‑bhong 'ka, 'yö dho 'yö ö ‑kpaa ‑ya, kö‑ ga 'ö‑ ‑kpaa ‑bha bha‑ \"flɩɩ‑ ‑ya 'gü mü \"dhʋ̈ do. ");
INSERT INTO daf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","꞊Ya bo ‑pë kë ‑sü 'ka, 'yö 'wo ‑dhaa ‑da 'gü, kö‑ \"kan \"tʋ̈ng ꞊në ꞊loo bha.» ");
INSERT INTO daf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","꞊Dhɛ 'ö go mü, 'yö \"gwënng do 'bha ‑da ‑a ‑nu ‑dhɛ 'zü ‑deewo 'ö‑ zü bho 'ö‑ pö: «‑Më ꞊në 'kwa ꞊mɔɔ‑ ‑bha 'kwa Atanna ‑bha ‑gblüdëdhɛ ‑zɔn 'ka? \"Ɛɛn 'kwa‑ pö 'kwa‑ kë \"gwënng 'ka kö 'kwa‑ ‑da, kwa ‑dho ‑a ‑da ‑kɔ kë ꞊dhɛ kö ‑wa 'gü ma?» ");
INSERT INTO daf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","'Yö‑ pö: «‑Yö ꞊dhɛ tapë 'wo‑ ‑dhɛ seneve bha‑ 'dhö. ‑A ga 'kö mɛ ‑ya ‑da \"sɛɛdhö bha mɛ‑ mɛ \"yan \"nuu ꞊në‑ dɔ‑ ‑ta, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ga 'yaa ꞊mɔɔ tapë \"pɛpɛ 'kö 'wo‑ ta‑ 'bha ga 'ka. ");
INSERT INTO daf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","\"Kɛɛ ꞊waa‑ ta ꞊ya bhɔ, 'yö ‑gla, 'yö dho 'ö ziö tapë ꞊gban \"pɛpɛ suu ‑ta. 'Yö ‑gbeng bho, 'yö ꞊diëë, 'yö ꞊bhlɛɛ, ꞊ya dɔ mü kö ‑maa ‑nu ‑wo nu sië 'wo 'kɔ dɔ‑ \"dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ‑gun Atanna ‑wʋ pö sië mɛ ‑nu ‑dhɛ \"gwënng ‑nu ꞊në‑ ‑da ‑sü 'ka 'gbɛ 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, \"kɛɛ ‑a 'dhɛ 'ö ꞊yaa‑ ‑da 'wo ꞊mɔɔ‑ ‑bha 'wo‑ 'gü ma ꞊në 'ö gun‑ ‑da sië \"tʋ ‑to ö ‑wʋ ‑bha ‑mɛ ‑nu ‑dhɛ, kë \"dhʋ̈ kö ‑wa 'gü ma. ");
INSERT INTO daf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","'Yaa gun dhiang 'bha zë sië‑ ‑nu ‑dhɛ \"wɛɛwɛɛ kö 'yii‑ kë \"gwënng 'ka, \"kɛɛ ꞊yaa‑ ‑da \"dhʋ̈, ꞊wa 'to wo do 'ka, 'yö ꞊yaa‑ 'klɔɔ‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","‑A yi do bha‑ 'ka yɛan\" \"piʋ̈, 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ ꞊dhɛ 'wo \"yi \"kan kö 'wo bɔ \"yi ꞊taama. ");
INSERT INTO daf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","\"Yitagɔ 'gbɛ ꞊në gun ‑dhɛ bha‑ 'gü. ꞊Dhɛ 'ö ꞊wa wo bo mɛ \"dhaa bha‑ ‑nu ‑dɔ zian ‑sü 'ka 'ö ꞊wa 'dho, 'yö waa‑ ‑bha ꞊klang ‑nu 'wo dho 'wo ‑da \"yitagɔ 'dhɛ 'ö gun ‑ya sië‑ 'gü, 'ö dhiang zë bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","꞊Dhɛ 'ö ꞊wa ‑da \"yi ‑ta 'wo 'dho sië, 'wo dho \"kan wo ‑ta kö \"tɛɛ ‑ziiziisü ꞊ya ‑ya ziö ‑sü ‑bha. Kö \"yi ꞊ya ‑ya zɔn ‑sü ‑bha, kö \"yikpö ‑nu ꞊wa ‑ya ‑da ‑sü ‑bha \"yitagɔ bha‑ 'gü, \"tɛɛ 'gü 'kun ‑kɔ yaa bha‑ ‑wɔn 'gü, ‑wo ‑to ‑dhɛ do bha‑ 'gü 'ö \"yi ‑yö zun \"yitagɔ bha‑ pa ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","'Wɔn ‑nu bha 'wo kë sië \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü bha kö Yesu ‑zë ꞊ya ö ‑gɔ dɔ ‑gɔdɔtapë ‑ta kö ‑yö ö ‑bha yi zë sië ö 'flëë‑ 'gü \"yitagɔ zü \"piʋ̈ ‑zian 'ka. 'Yö‑ ‑bha ꞊klang ‑nu 'wo pa‑ ‑bha, 'yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, ga 'ö kwaa‑ wo ya 'bhaa‑ ‑dhɛ ꞊në yö ‑ee? \"Ɛɛn 'yaa i 'gü ꞊në wo 'wɔn 'bha 'ka ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","꞊Dhɛ 'ö ‑bö, 'yö ꞊gbla \"tɛɛ 'ö gun ziö sië bha‑ ‑ta. 'Yö‑ pö \"yi bha‑ ‑dhɛ: «‑Bhö dɔ! ‑Dhɛa ga i ‑ta!» 'Yö \"tɛɛ ‑yö bo ziö ‑sü 'ka, 'yö ‑dhɛta ‑yö dɔ dingdhö. ");
INSERT INTO daf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","'Yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «Ka \"suʋ̈ \"sinma kö \"dhʋ̈‑ ‑wo ‑më ‑wɔn 'gü? \"Ɛɛn 'kii 'dhang ꞊në bho ꞊kö n \"dhiʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'Yö \"suʋ̈ ‑ziisü ‑yö ‑da 'mɛ 'wo gun mü bha‑ ‑nu 'gü 'wɔn 'ö Yesu ‑ya ‑kë bha‑ ‑wɔn 'gü. 'Yö 'wo zun wo 'ko dhɛɛ\" 'kpɔ ‑sü ‑bha 'wo‑ pö: «De suu 'ö ya ꞊zɔɔ 'yö \"tɛɛ waa‑ \"yi ‑nu ꞊gban 'wo wo ‑gɔ dho‑ ‑dhɛ \"sia‑ ꞊ni?» ");
INSERT INTO daf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu waa‑ ‑bha ꞊klang ‑nu 'wo \"yitagbɛa 'ö Gadhidhe bha‑ ‑kan, 'yö 'wo bɔ‑ ꞊taama Zedhazeni ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","꞊Dhɛ 'ö go \"yitagɔ 'gü 'ö zun \"sia‑ bhoo, 'yö gɔndë do 'ö \"yina yaa ‑yö gun‑ 'gü 'ö gun wɔ sië mɛ ꞊gee ‑bho 'gü ‑yɛ ‑nu 'wo ‑tɔn 'gü ‑a ‑nu 'gü bha, 'ö go bun ꞊taa ‑zian 'ka 'yö nu‑ ‑gɔ zian‑. ");
INSERT INTO daf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","'Mɛ bha ‑yö ‑gun wɔ sië ‑dhɛ bha ꞊në‑ 'gü, kö mɛ 'bha ‑kɔ 'yaa ꞊mɔɔ‑ ‑bha 'zü kö ‑ya ‑lö ‑piö lɔɔ\" ‑zian 'ka. ");
INSERT INTO daf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","‑A ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊waa‑ ‑gɛn ‑nu waa‑ ‑kɔ ‑nu ‑lö ‑piö döngga ‑nu waa‑ ‑piö lɔɔ\" ‑nu 'ka ‑blɛɛsü, \"kɛɛ kö ꞊yaa‑ ꞊gban \"kan \"pɛɛpɛdhö kö mɛ 'bha ‑kɔ 'yaa ꞊mɔɔ‑ ‑bha 'zü kö ‑ya 'kun. ");
INSERT INTO daf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kö buntaadhɛ ‑nu waa‑ ‑tɔn ‑bha ‑dhɛ ‑nu bha ꞊në ꞊wa 'to‑ ꞊gloodhɛ 'ka 'yënng‑ 'gü waa‑ gbeng 'gü ‑nu 'gü kö ‑yö \"gbla sië, 'ö ö ‑dɩ ‑pɛ ‑nu wo ‑gwë 'ka. ");
INSERT INTO daf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","꞊Dhɛ 'ö Yesu yö kö ‑yö nu sië ‑dhɛ ꞊gblɛɛn 'gü, 'yö dho‑ ‑gɔ zian‑ ‑bɛang 'ka. ꞊Dhɛ 'ö dho 'ö ꞊loo‑ ‑dhɛ 'gü, 'yö Yesu ‑ya pö \"yina yaa 'ö gun gɔndënë bha‑ 'gü bha‑ ‑dhɛ 'ö‑ pö: «‑Bhö 'go 'mɛ bha‑ 'gü 'kii ziö!» 'Yö 'mɛ bha 'ö zun Yesu ‑dhɛ ö kpiö 'gü, 'yö \"yina 'ö gun‑ 'gü bha 'ö ꞊gbla \"gbɩɩ‑ 'ka 'ö‑ pö: «'Kwa ma mü, Atanna 'ö dhang‑ 'gü ‑a Gbö Yesu? Bhɛa\" ꞊në 'a‑ wo i ‑dhɛ kö i dɔ \"gbɩɩ‑ kö 'i‑ kë Atanna ‑dhɛ kö 'bha 'dho n kë ‑kɔ 'bha 'gü ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","'Yö Yesu ‑ya dhɛɛ\" kpɔ 'ö‑ pö: «I 'tɔ‑ de?» 'Yö‑ pö: «‑Wo n ‑dhɛ ‑gblü \"dhaa, ‑a ‑gɛn ‑mü ꞊dhɛ yi 'gbɛ ‑ziisü.» ");
INSERT INTO daf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","'Yö \"yina yaa ‑nu bha 'wo zun ‑gbɛʋʋ kë ‑sü bha Yesu ‑dhɛ 'wo‑ pö ‑yö dɔ \"gbɩɩ‑ kö 'ya 'dho wo kë \"sɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","\"Tʋ̈ng 'wo kë sië‑ 'ka \"dhʋ̈ bha kö ‑bhɔ ‑kpluu 'kpii‑ 'bha ‑yö ‑bhöpë mɔɔ‑ sië ‑tɔn ‑bha ‑a ‑nu \"sɔɔ ‑dhɛ 'bha 'gü mü, ");
INSERT INTO daf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","'yö \"yina yaa ‑nu bha 'wo ꞊bhɛa Yesu ‑dhɛ 'wo‑ pö: «‑Bhö dɔ \"gbɩɩ‑ kö 'bha‑ pö 'i yi kë, kö 'i yi bɔ ‑bhɔ ‑kplü ya‑ 'gü kö 'yi ‑da 'gü!» ");
INSERT INTO daf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","'Yö Yesu ‑ya pö: «'Ma \"wɩ‑ ‑bha, ‑ka 'dho mü!» 'Yö \"yina yaa ‑nu bha 'wo go 'mɛ bha‑ 'gü, 'yö 'wo dho 'wo ‑da ‑bhɔ ‑nu bha‑ ‑nu 'gü, 'yö ‑bhɔ 'ö ꞊mɔɔ \"gblü ꞊plɛ ‑nu ‑bha bha 'wo ‑pɛn, 'yö 'wo dɔ ‑bɛang ‑bha goo bha‑ ‑bha, 'wo dho 'wo ‑pö \"yitagbɛa bha‑ ꞊bhaa, 'yö \"yi ‑ya ‑nu zë. ");
INSERT INTO daf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","'Yö 'mɛ 'wo gun ‑bhɔ ‑kplü bha‑ ‑maa kë sië bha, 'wo ꞊dua 'wo dho 'wɔn bha‑ ‑taɔng 'ka ‑a ‑nu ‑bha 'pö‑ ‑nu waa‑ ꞊gbɛatadhɛ ‑nu 'gü. 'Yö mɛ ‑yö bho \"dhuu 'wo go ‑dhɛ ‑nu bha‑ 'gü, 'wo nu 'wɔn bha‑ ‑dhɛ ‑ga ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","'Yö 'wo nu Yesu ‑dhɛ 'gü, 'yö 'wo 'mɛ 'ö \"yina yaa \"gblü ꞊plɛ ‑yö gun‑ 'gü bha‑ yö kö ‑yö ‑ya ‑sü 'ka Yesu \"sɔɔ, kö sɔ ‑ya ‑bha, kö ꞊ya kë \"klʋ̈ʋ̈klʋ̈ 'kpakpadhö, 'yö‑ \"suʋ̈ 'dhö ‑da ‑a ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","'Yö 'mɛ 'ö‑ ‑nu \"yan 'dhö gun 'mɛ 'ö \"yina yaa ‑yö gun‑ 'gü bha‑ ‑kë \"klʋ̈ʋ̈klʋ̈ ‑dhɛ 'gü, waa‑ 'wɔn 'ö ‑kë ‑bhɔ ‑nu bha‑ ‑nu 'ka bha‑ 'dhö bha, 'wo ‑ya ‑a ‑gɛn dɔ ‑sü ‑bha 'mɛ 'wo nu bha‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","꞊Dhɛ 'ö \"sɛgümɛ ‑nu bha 'wo 'wɔn bha‑ ma, 'yö 'wo zun ‑bhɛa Yesu ‑dhɛ ‑sü ‑bha kö ‑yö 'go wo ‑gɔ \"sɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","꞊Dhɛ 'ö 'mɛ 'ö \"yina yaa ‑yö gun‑ 'gü bha 'ö Yesu yö kö ‑yö ‑da sië \"yitagɔ 'gü, 'yö ꞊bhɛa‑ ‑dhɛ 'ö‑ pö: «A ‑dho 'dho i ꞊keng‑.» ");
INSERT INTO daf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","\"Kɛɛ 'yii \"wɩ‑ ‑bha, 'yö‑ pö‑ ‑dhɛ: «‑Bhö 'dho i ‑gɔ 'kɔɔdhö kö ‑kɔ 'ö i ‑wëë ‑yö Atanna ‑kë 'ka, 'ö i dha, waa‑ 'wɔn ‑së 'ö‑ ‑kë i ‑dhɛ bha 'i‑ ‑gɛn dɔ i ‑gɔ 'kɔɔmɛ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","'Yö 'mɛ bha 'ö dho, 'yö ‑ya 'wɔn 'ö Yesu ‑ya ‑kë ‑dhɛ bha‑ ‑gɛn dɔ ‑sü bha \"sɛgɔ 'wo‑ ‑dhɛ 'pödhɛ ‑kaɔng do ‑sɛ bha‑ 'gü ‑dhɛ ꞊gban \"pɛpɛ 'gü. 'Yö‑ 'wɔn ‑yö mɛ ꞊gban kɔn. ");
INSERT INTO daf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","'Yö Yesu waa‑ ö ‑bha ꞊klang 'nu 'wo ‑da \"yitagɔ 'gü, 'yö 'wo \"yitagbɛa bha‑ ‑kan 'zü ‑deewo. ꞊Dhɛ 'ö ꞊wa \"yi \"kan, ꞊wa bɔ \"yi ꞊taama, 'yö mɛ ‑yö bho 'zü \"dhuu, 'yö 'wo nu 'wo ꞊klëën‑ ‑zü \"yi \"kpʋng \"dhiʋ̈ mü. ");
INSERT INTO daf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","'Wo dho \"kan wo ‑ta kö Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑gɔmɛ do 'wo‑ ‑dhɛ Zɛdhiusö bha, ꞊ya nu. ꞊Dhɛ 'ö Yesu yö, 'yö nu 'ö \"gblëënu‑ ꞊wlöö, ");
INSERT INTO daf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'yö ‑gbɛ \"ʋʋ ‑kë ‑dhɛ 'ö‑ pö: «N Dëmɛ, n 'dhunë ‑ya wɔ 'ya‑, ‑bhö dɔ \"gbɩɩ‑ kö 'i 'dho 'i i ‑kɔ 'pa‑ 'ka n ‑dhɛ kö ‑yö dha.» ");
INSERT INTO daf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö waa‑ Yesu ‑nu 'wo ‑ziö, kö mɛ kpö 'gbɛ ꞊dede ‑wa ꞊keng‑ kö ‑wa bhlʋʋ sië wo 'ko ꞊zinng 'gü. ");
INSERT INTO daf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yaa\" kë 'wo‑ wo sië bha, dhebhɔ do 'bha ‑ya ‑nu kpö 'gü mü, ꞊yɔɔn yën ‑yua 'ö zun‑ ‑bha ‑a ‑kwɛ ꞊ya ꞊mɔɔ ‑kaɔng do ga ꞊plɛ ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","꞊Yaa‑ kë ‑dho ‑dhɔtrɔɔ ‑nu \"piʋ̈ ‑sü 'ka ‑a 'gü ꞊ya ga. ‑A ꞊kwɛɛ ꞊gbaan ꞊wɛnng ö ‑dɩ ‑pë kë ‑sü ‑ta ‑dhɔtrɔɔ ‑nu \"piʋ̈, \"kɛɛ kö‑ 'bha 'yii 'wɔn 'kun do, ‑a \"yua 'bha ꞊në ‑da 'gü ‑kpɛawo 'ö dho‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","꞊Dhɛ 'ö Yesu ‑taɔng ma, 'yö nu 'yö ‑da mɛ kpö bha‑ 'gü Yesu ꞊kee‑ ‑ta, 'yö dho 'ö ö ‑kɔ pa‑ ‑bha sɔ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","‑A kë 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑yö 'dhang ‑bho \"dhiʋ̈, 'ö‑ pö ö ‑dɩ ‑dhɛ ꞊dhɛ: «꞊Ya kë ꞊dhɛ kö n ‑kɔ ‑zian ‑yö 'pa‑ ‑bha sɔ 'ka kö 'ma dha.» ");
INSERT INTO daf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","'Ö ö ‑kɔ pa‑ ‑bha sɔ 'ka ‑dhɛ do 'ö‑ 'gü 'pö bha, ‑yö ‑to mü 'ö‑ ‑bha \"yua bha 'ö bo, 'ö yöö ꞊dede 'ö 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ 'ya kë \"klʋ̈ʋ̈klʋ̈ 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu ‑yö ‑to 'pö ‑dhɛ do bha‑ 'gü 'ö‑ 'wɔn dɔ ꞊dhɛ ö faan 'bha ꞊ya 'go ö 'gü ꞊ya zun \"kpɛnng, 'yö ꞊slëë ö 'gü mɛ kpö bha‑ 'gü 'ö‑ pö: «De ꞊në pa ma sɔ 'ka bha?» ");
INSERT INTO daf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","'Yö‑ ‑bha ꞊klang ‑nu ‑wa pö‑ ‑dhɛ: «'Aa, yi Dëmɛ, i ‑mɔɔ ‑bha 'i dhɛɛ\" 'kpɔ suu bha‑ ‑kë, \"kɛɛ kö i dɔ sië mɛ \"bhɩɩ‑ \"dhaa 'gü ꞊dhɛ 'pë 'ya 'dhö ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","\"Kɛɛ kö ‑yö ‑dhɛ ‑ga sië ö ‑zü ‑zü \"dhʋ̈ do kö 'mɛ 'ö bhɔ bha 'ö‑ mɛ dɔ. ");
INSERT INTO daf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","꞊Dhɛ 'ö dhebhɔ bha ꞊ya 'wɔn ꞊slɔɔ 'gü ꞊dhɛ mɛ 'ö pa Yesu ‑bha sɔ 'ka bha, ‑ya mɛ mɔɔ‑ sië, 'yö \"suʋ̈ 'dhö ‑da 'gü, 'yö ‑ya ꞊zii ‑sü ‑bha, \"kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ ‑ya 'wɔn dɔ 'kpakpadhö ꞊dhɛ 'ya dha, 'yö nu 'yö \"gblëënu Yesu ꞊wlöö, 'yö ‑kɔ 'ö ‑kë 'ka 'yö ‑ziö ‑dhɛ ‑a ‑gɛn 'gü \"pɛɛpɛdhö. ");
INSERT INTO daf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","\"Kɛɛ 'yö Yesu ‑ya pö‑ ‑dhɛ: «N \"tɛado, i ‑bha 'dhang bho n \"dhiʋ̈ ‑sü ꞊në i dha bha. ‑Bhö i ‑bha 'dho wo i 'flëë‑ 'gü, 'bha kë \"klʋ̈ʋ̈klʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dhiang bha ‑yö ‑to Yesu \"dhi, 'yö mɛ ‑yö go Zɛdhiusö ‑gɔ 'kɔɔdhö, 'yö 'wo nu 'wo‑ pö Zɛdhiusö ‑dhɛ: «Yi Dëmɛ, 'bha 'dho kwa Dëmɛ ziö \"yɛ 'gü \"wɛɛwɛɛ, i 'dhu 'yaa mü 'zü, ");
INSERT INTO daf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","\"kɛɛ ‑a pö 'wo‑ wo \"dhʋ̈ bha, 'yii 'dho Yesu ꞊gbin‑, 'yö‑ pö Zɛdhiusö ‑dhɛ: «‑A 'to \"dhʋ̈ ꞊zɔɔ 'dhɛ, 'bha 'dho \"suʋ̈, ‑bhö 'dhang bho n \"dhiʋ̈ doseng!» ");
INSERT INTO daf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Zɛdhiusö ‑bha 'kɔɔ ‑zian sü, \"kɛɛ ‑a 'dho ‑sü 'ka 'yii \"wɩ‑ ‑bha kö mɛ \"wɛɛ 'bha ‑yö 'dho 'ö dɔ kö 'yii kë Piɛdhö, Zakö waa‑ ö 'zlaa‑ Zan ‑nu ‑zë 'ka. ");
INSERT INTO daf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","'Yö 'wo dho 'wo ꞊loo Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑gɔmɛ bha‑ ‑gɔ \"kwɛandhö. 'Wo ꞊loo mü kö ‑wo \"tabhoo ‑da sië mü ‑yuudhö, kö mɛ 'bha ‑nu ‑wo \"gbʋ bɔ sië 'wo ꞊gbla‑ 'ka \"gbɩɩ‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","'Yö ‑da 'kɔɔdhö, 'yö‑ pö 'mɛ 'wo gun mü bha‑ ‑nu ‑dhɛ: «‑Më ‑wɔn ꞊në 'ka‑ \"gbʋ bɔ 'yö 'ka ꞊gbang dɔ sië‑ 'ka ‑yuudhö ya? ꞊Ya 'to 'në 'kö ya‑ ‑bha ‑zë ‑bha kö 'yii ga, ‑yö yi ꞊në‑ zë. ");
INSERT INTO daf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","꞊Dhɛ 'wo‑ ma \"dhʋ̈, 'yö 'wo zun ꞊wɛɛ dɔ ‑sü ‑bha ‑a ‑bha. \"Kɛɛ 'yö mɛ ꞊gban \"pɛpɛ zun \"kpɛnng, 'yö to ‑a 'dhö, 'në dë bha‑ 'dhö, 'në dhe 'dhö ‑a ‑nu ‑bha waa‑ ‑bha ꞊klang ‑nu ‑yaaga 'wo nu‑ dɔ bha‑ ‑nu 'dhö, 'yö 'wo dho 'wo ‑da 'kɔ 'ö 'në ꞊gee ‑yö gun‑ 'gü bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","'Yö dho 'ö 'në bha‑ kun‑ ‑kɔ ‑bha 'ö‑ pö‑ ‑dhɛ (eblö ‑wʋ 'gü) 'ö‑ pö: «Tadhita kumi!» ꞊Waa‑ pö \"dhʋ̈ kö ‑wa pö: «'Nëdhiëngnë, ma ꞊në 'a‑ pö, ‑bhö \"wlü!» ");
INSERT INTO daf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","'Në bha ‑yö ‑to ꞊kwɛng mü 'ö ꞊wlü 'ö dɔ ö ‑gɛan, 'ö zun \"ta 'sü ‑sü ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö‑ ‑kwɛ ꞊ya kë ‑kaɔng do ga ꞊plɛ. 'Wɔn bha 'yö 'mɛ 'wo gun mü bha‑ ‑nu ꞊gban \"dhi dɔ bong 'ka. ");
INSERT INTO daf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","'Wɔn bha ꞊dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ‑dhio dɔ 'mɛ 'wo gun mü bha‑ ‑nu ‑ta, 'ö ö kɔngga ziö‑ 'ka‑ ‑nu ‑dhɛ \"sɛɛ glɔglɔdhö kö mɛ 'bha 'ya 'dho 'wɔn ꞊slɔɔ‑ 'gü. 'Yö go mü 'ö‑ pö‑ 'kpɔmɛ ‑nu ‑dhɛ ‑wo ‑bhöpë nu 'nëdhiëngnë bha‑ ‑dhɛ kö ‑ya ‑bhö. ");
INSERT INTO daf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö go ‑dhɛ bha‑ 'gü, 'yö dho Nazadhɛtö, 'pödhɛ 'ö ‑gla 'gü bha‑ 'gü waa‑ ‑bha ꞊klang ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","꞊Dhɛ 'ö Zuifö ‑nu ‑bha ꞊glooyi ꞊ya ꞊loo, 'yö dho‑ ‑nu ‑bha ‑yakwëëkëgükɔ 'gü 'yö ‑ya mɛ draan‑ ‑sü ‑bha. 'Yö mɛ kpö 'wo‑ ‑wʋ ma bha‑ 'wɔn ‑ya ‑nu kɔn, 'yö 'wo zun‑ pö ‑sü ‑bha: «'Yö ‑yö ‑go ꞊zɔɔ ö ‑bha 'wɔndɔdhe ‑nu, ꞊kpaɔdhɛ ‑nu waa‑ \"dhabhliwɔn ‑nu 'ö‑ kë sië ya‑ 'ka 'mɛ? ");
INSERT INTO daf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","\"Ɛɛn \"dhüyënmɛ (do \"wɛ 'ö mɛ ꞊gban 'kwa‑ dɔ ya) 'yaa ‑mü ‑ee? \"Ɛɛn Madhi gbö ya 'yaa ‑mü ‑ee? \"Ɛɛn Zakö, Zozö, Zudë waa‑ Simɔ ‑nu dheebhang ya 'yaa kë ꞊ni ‑ee? \"Ɛɛn ‑a dheebhang dhong ‑nu ya 'aa mü 'wo kwa kpö 'gü ya ‑ee?» 'Yö \"mɔnɛ ‑yö ma‑ ‑nu 'gü, 'yö Yesu ‑kë ‑nu ‑gɔ ꞊dhɛ ‑a ‑nu ‑gɛn \"dhiʋ̈ ‑zuö ‑bha ‑gwë 'dhö ('dhang 'ö 'wii‑ bho‑ \"dhiʋ̈ bha‑ ‑wɔn 'gü). ");
INSERT INTO daf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A ‑pö \"dhʋ̈ ‑dhɛ ‑mü ka ‑gɔ, ‑a ‑gɛn ‑mü ꞊dhɛ ‑wo Atanna ‑wʋdhiʋ̈loomɛ ꞊bhlëë ‑ya ‑dhɛ ꞊gban \"pɛpɛ 'gü, \"kɛɛ ‑a ‑gɔ \"sɛgümɛ ‑nu oo, ‑a ‑bha 'kɔdhigümɛ ‑nu waa‑ ‑gɔ 'kɔɔmɛ ‑nu ‑zë 'waa‑ yö pë 'bha 'ka. ");
INSERT INTO daf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","'Dhang 'ö 'wii‑ bho‑ \"dhiʋ̈ bha‑ ‑wɔn 'gü, 'yii ꞊mɔɔ‑ ‑bha kö ‑yö \"slë \"wɛɛ 'bha kë kö 'yii kë ö ‑kɔ 'ö‑ ‑ya \"yuëdhi 'do 'do 'bha ‑nu ‑ta, 'wo dha ‑a 'ka, kö‑ ‑nu ‑bha gɔɔgbɩɩdhɛ bha‑ 'wɔn ꞊yaa‑ 'kɔn ꞊dedewo. ꞊Dhɛ 'ö go mü, 'yö ‑da 'pö‑ ‑nu 'wo‑ ‑nu ‑züzü mü bha‑ ‑nu ‑bhiëë ‑ta mɛ ‑nu ꞊klang ‑kë Atanna ‑wʋ 'ka ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yi do 'ka 'yö ö ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ ‑nu ‑dhɛ, 'yö‑ ‑nu dan ꞊plɛ ꞊plɛ 'yö‑ ‑nu bɔ (‑dhɛ ‑nu 'gü) kö ꞊ya ‑kɔ ‑ziö \"yina yaa ‑nu ‑gɔ ‑faan nu‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","'Yö ö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: «'Ka 'dho sië, 'ka 'dho pë 'bha 'kun ka ‑kɔ \"piʋ̈ kö 'yii kë \"dhünë 'ö ka ꞊kwɛɛ‑ ‑a 'ka. 'Ka 'dho ‑bhöpë 'sü, \"ɛɛn 'ka 'dho 'wëëga ‑da ka ‑ta (‑a ‑gɛn ‑mü ꞊dhɛ 'pë ka ‑mawɔn dho zun‑ ‑bha ‑wo ‑dho ‑a nu ka ‑dhɛ). \"Ta ‑kpɔ 'ka bhɔɔ 'ya 'dho kë ka ‑ta, ");
INSERT INTO daf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","'ka 'dho \"bhɛɛ ꞊plɛ ‑da 'ko ‑ta, ‑ka ‑sabha ꞊në ‑ya ka ‑gɛn ‑bha doseng.» ");
INSERT INTO daf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","'Yö go mü 'zü 'ö‑ pö‑ ‑nu ‑dhɛ: «'Ka 'dho 'ka ‑da 'pö‑ \"ʋʋ 'pö‑ 'ö‑ 'gü, ꞊wa ka ꞊yëë bho 'kɔ 'ö‑ 'gü, ‑ka 'to‑ 'gü ‑yö 'to \"dhʋ̈ ‑yö zun‑ 'ka ka ‑go 'pö‑ bha‑ 'gü ‑yi ‑bha (kë \"dhʋ̈ 'ö 'wɔn ‑yö ‑siö ka ‑dhɛngbhɔɔ ‑nu ‑dhɛ ka \"piʋ̈). ");
INSERT INTO daf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Pödhɛ 'dhɛ 'wii ‑kɔ ‑ya ka ‑dhɛng ‑bha ‑a 'gü, \"ɛɛn 'ö 'wii \"tʋ 'to ka ‑wʋ ‑bha, ‑ka 'go 'plöö mü kö 'ka 'dho ‑dhɛ \"wɛɛ 'bha 'gü, \"kɛɛ 'ka‑ pö 'ka 'dho, ‑ka ka ‑kɔ ‑ma ka ‑gɛn ‑bha kö ‑bobi 'ö ‑dɔ ka ‑gɛn ‑bha 'pö‑ bha‑ 'gü bha, ‑yö 'go ka ‑gɛn ‑bha, kö ‑yö kë Atanna ‑bha za ‑bha ‑a ‑nu zë ‑gɛn 'ka dhia\".» ");
INSERT INTO daf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","꞊Dhɛ 'ö ö bo ‑wʋ ‑kpɔ ‑a ‑nu ‑bha ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö 'wo dho, 'yö 'wo Atanna ‑bha naɔ bha‑ dɔ ‑dhɛ ꞊gban \"pɛpɛ 'gü ꞊dhɛ ‑wo wo bo wo kë ‑sɔng yaa ‑nu 'ka kö ‑wo bɔ Atanna 'ka. ");
INSERT INTO daf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","'Wo dho ‑wo ‑gun \"yina yaa 'gbɛ kë sië 'pö mɛ \"bhɩɩ‑ ‑nu 'gü, 'ö 'wo \"yɔn ꞊gii \"yuëdhi 'gbɛ ‑nu ‑bha ‑nu wo 'wo dha. ");
INSERT INTO daf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","‑Gblüdë Edhodö ‑yö Yesu ‑wɔn ‑ma \"tʋ̈ng bha ꞊në‑ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö‑ 'tɔ ꞊ya ꞊mɔɔ \"sɛ bha‑ 'gü ‑dhɛ ꞊gban \"pɛpɛ 'gü (\"dhabhliwɔn ‑nu 'ö gun‑ kë sië bha‑ ‑wɔn 'gü), \"kɛɛ 'mɛ 'wo gun‑ ‑dhiang zë sië \"dhʋ̈ bha‑ ‑nu ‑wʋ 'yaa gun do. Mɛ 'bha ‑nu ‑gun pö sië ꞊dhɛ Zan Mɛzumɛ 'wo‑ zë bha ꞊në ꞊ya ‑bö ‑deewo, 'yö‑ ‑wɔn 'gü 'yö \"dhabhliwɔn ‑nu kë sië bha. ");
INSERT INTO daf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kö mɛ 'bha ‑nu ‑wa pö sië Edhi ('ö gun Atanna ‑wʋdhiʋ̈loomɛ 'ka yi 'bha 'ka bha yö ‑mü). Kö mɛ 'bha ‑nu ‑dɩ 'pö ‑wa pö sië: «‑Yö ‑dho kë Atanna ‑wʋdhiʋ̈loomɛ do 'bha ꞊në‑ 'ka ꞊dhɛ ‑a 'mɛ 'wo gun zii 'kpa ‑a ‑nu 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","\"Kɛɛ ꞊dhɛ Edhodö ‑zë 'ö‑ ma, 'yö‑ pö: «Zan Mɛzumɛ 'a‑ ‑gɔ ‑kan bha ꞊në ꞊ya ‑bö bha!» ");
INSERT INTO daf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ yöö ꞊dede ꞊në kë ö ‑wʋ kpɔ mɛ ‑bha, 'yö 'wo Zan kun 'wo‑ ‑lö, 'yö 'wo‑ ‑da ‑kaso 'gü, ‑a pö 'ö Zan ‑ya wo‑ ‑dhɛ ꞊dhɛ ꞊ya ö dheebhang Fidhipö ‑bha dhebhɔ Edhodiadö bho‑ ‑gɔ ꞊ya 'wɔn yaa kë bha‑ ‑wɔn 'gü. ‑A ‑gɛn ‑mü ꞊dhɛ Zan‑ kë‑ ‑pö ‑dhɛ ‑ta \"puu 'ka 'ö‑ pö: «‑A ‑dhɛ 'yaa ‑bha kö 'i i dheebhang ‑bha dhe bho‑ ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","‑A pö 'ö Zan ‑ya wo \"dhʋ̈ bha 'yö ‑siö Edhodiadö ‑dhɛ. ‑A bhlɔɔ ‑ma 'gü ‑kɔ yaa bha, 'yö gun \"piʋ̈ ꞊dhɛ 'ö Zan zë, ");
INSERT INTO daf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","\"kɛɛ 'yö‑ ‑kɔ 'yaa gun, ‑a ‑gɛn ‑mü ꞊dhɛ Edhodö ‑gun \"suʋ̈ sië Zan ‑gɔ ‑a ‑bha ‑kë mɛ 'ö ꞊sɔng 'bhaa‑ ‑bha 'ö tɛanwɔn pö, \"kɛɛ 'ö Atanna dhɔɔbhaamɛ 'ka ‑sü ‑wɔn 'gü. ‑Yö ‑gun ö \"tʋ ‑nu dɔ sië‑ ‑wʋ ‑bha 'ö‑ ‑wʋ \"dhia ‑yö ma‑ 'gü, 'ö ꞊ya ö \"tʋ 'to‑ ‑wʋ ‑bha ‑kɔ 'ö‑ 'gü 'do 'do, 'ö‑ \"gblʋ̈ʋ̈dhɛ ‑yö \"muu bho, ‑yö ‑gun Zan ‑maa kë sië yö ꞊në‑ ‑wɔn 'gü Edhodiadö ‑gɔ kö 'ya 'dho‑ zë ö tii' 'ka. ");
INSERT INTO daf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","\"Kɛɛ yö ꞊në‑ ꞊gban 'gü, yi do‑ kë ‑slɔɔ 'ö ‑kë Edhodiadö bhlɔɔ bho ‑yi 'ka. ‑Yö ‑kë \"dhʋ̈ yi 'ö Edhodö 'kpɔ ‑kwɛ ‑yö zun‑ 'ka 'ko \"dhiʋ̈ bha ꞊në‑ 'ka. ‑A ‑dhɛkpaɔyi bha‑ 'ka, 'yö Edhodö ‑yö trooyi ‑da ‑a ‑bha mɛ ‑tiandhö ‑nu, ‑a ‑bha \"sɔdha ‑gɔmɛ ‑nu waa‑ 'tɔmɛ ‑nu 'wo Gadhidhe ‑sɛ 'gü ‑a ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","꞊Dhɛ 'ö 'mɛ 'wo‑ ‑nu ‑dhɛ bha ꞊wa nu, 'ö ꞊wa ‑da trookëgükɔ 'gü, 'ö ‑dhɔkëdhe zü ꞊ya bho, 'yö Edhodiadö 'dhu ‑yö ‑da 'kɔɔdhö, 'yö zun \"tan kë ‑sü ‑bha, 'yö‑ \"dhia ‑yö ma Edhodö waa‑ ö ‑bha trootamɛ ‑nu bha‑ ‑nu 'gü. 'Yö Edhodö ‑ya pö 'nëdhiëngnë 'ö \"tan kë sië bha‑ ‑dhɛ 'ö‑ pö: «Pë \"ʋʋ pë 'ö ‑dhi i ‑dhɛ, ‑a ‑gbadhɛ n ‑gɔ kö 'a‑ nu i ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö go mü 'ö ‑sö ‑bhö 'ö‑ pö: «Pë \"ʋʋ pë 'ö ‑dhi i ‑dhɛ, ‑a pö, 'kö ‑kë ma ‑gblüdëdhɛ \"pɛan do ‑zian 'ka, a ‑dho ‑a nu i ‑dhɛ. ('Mii‑ kë \"dhʋ̈, Atanna ‑yö n 'sü).» ");
INSERT INTO daf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","꞊Dhɛ 'ö ‑gblüdë ‑ya pö \"dhʋ̈, 'yö 'në bha 'ö 'kwama kun, 'yö zun \"kpɛnng 'yö dho‑ ‑zɔn ö dhe ‑dhɛ, 'yö‑ dhe ‑ya pö‑ ‑dhɛ: «‑Bhö 'dho 'kii‑ pö ‑yö Zan Mɛzumɛ ‑gɔ nu i ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","'Yö ö yee kë ‑bɛang 'ka 'ö dho Edhodö ‑dhɛ 'gü 'yö‑ pö‑ ‑dhɛ: «N dëmɛ, ‑yö n \"piʋ̈ ꞊dhɛ 'i Zan Mɛzumɛ ‑gɔ ꞊në‑ ‑ya 'tɛa‑ 'gü ꞊dede ya‑ 'gü kö 'i n gba‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","'Nëdhiëngnë bha‑ pö 'ö‑ wo ‑wo ö gba Zan ‑gɔ ꞊në‑ 'ka bha, 'yii dhi ‑gblüdë Edhodö ‑dhɛ, \"kɛɛ yöö kë ꞊tɔn ꞊dhɛ kö ꞊ya ö bo ‑sö ‑bhö ‑sü 'ka. 'Yö zë ‑sö 'ö‑ ‑bhö waa‑ 'mɛ 'ö‑ ‑nu ‑dhɛ bha‑ ‑nu ‑wɔn ‑dhɛ, kö ‑a kë ‑kɔ ‑zë \"wɛɛ 'bhaa 'dhö 'zü, ");
INSERT INTO daf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","'yö \"sɔdha 'wo‑ ‑maa kë bha‑ do bɔ Zan ‑gɔ 'sü ‑dhɛ 'gü kö ‑yö nu‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'Yö 'mɛ bha 'ö dho, 'yö Zan ‑gɔ ‑kan, 'yö‑ ‑da 'tɛa‑ 'gü 'ö nu‑ 'ka, 'yö‑ dɔ 'nëdhiëngnë bha‑ ‑gɔ, 'yö‑ sü 'pö 'ö dho‑ 'ka ö dhe ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","꞊Dhɛ 'ö Zan ‑bha ꞊klangdhiʋ̈ ‑nu 'wo‑ ma ꞊dhɛ ꞊wa Zan zë, 'yö 'wo dho 'wo‑ bhingkplü 'ö to bha‑ sü 'wo dho‑ 'ka 'wo‑ ‑wɛɛ bho. ");
INSERT INTO daf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","꞊Dhɛ 'ö Yesu ‑bha bɔmɛ ‑nu 'ö‑ ‑nu bɔ bha, ꞊wa wo yee kë ꞊wa nu, yi do 'bha bha‑ 'ka 'yö 'wo bho 'ko ‑ta Yesu ‑kuu \"dhiʋ̈, 'yö 'wo zun 'wo \"kplëng bho ‑sü ‑bha. 'Yö 'wɔn \"pɛpɛ 'wo‑ ‑kë, waa‑ 'wo Atanna ‑wɔn ‑dhiang zë ‑kɔ ‑nu 'ö‑ ‑bha, 'yö 'wo ‑ya ‑ziö ‑gɛn 'gü ‑sü ‑bha Yesu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","'Yö‑ ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka nu kö 'kwa 'dho \"tʋngtadhɛ 'bha 'gü kö 'ka ka \"tɛɛ 'në 'bha 'pa.» ‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö 'mɛ 'wo 'dho sië 'wo nu sië ꞊wa kë 'gbɛ ꞊dedewo kö ‑kɔ 'ö Yesu waa‑ ‑bha yëkëmɛ ‑nu 'wo dho‑ kë‑ 'ka kö ‑wo pë ‑zian ‑bhö ‑a ‑kɔ 'yaa 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","'Yö 'wo dho 'wo ‑da \"yitagɔ 'gü 'wo dho ‑dhɛ 'ö mɛ 'bhaa mü 'ö 'wo dho wo ‑dɩ ‑slɔɔ ‑bha bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","\"Kɛɛ 'yö mɛ 'gbɛ ‑wa ‑nu 'dho ‑dhɛ yö, 'yö 'wo‑ ‑nu dɔ, 'yö mɛ ‑yö go 'pödhɛ \"pɛpɛ 'wo mü ‑a ꞊gban 'gü 'do 'do, 'yö 'wo dho wo ‑gɛn ‑ta, 'yö 'wo ‑da ‑nu \"dhiʋ̈ ‑dhɛ 'wo 'dho sië‑ ‑bha bha‑ 'gü. \"Sanni Yesu waa‑ ö ꞊kengmɛ ‑nu ‑wo nu kö ‑wo ꞊loo mü kö 'mɛ 'wo bha ꞊wa ꞊loo mü 'nu. ");
INSERT INTO daf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","꞊Dhɛ 'ö Yesu ‑yö go \"yitagɔ 'gü 'ö zun \"sia‑, kö mɛ ꞊ya ‑dhɛ ꞊gban pa tingtingdhö; 'yö ‑wëë ‑yö zun bɔ ‑sü ‑bha ‑a ‑ta ‑a ‑nu ‑wɔn 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊yaa‑ ‑nu ‑ga, ‑wo ‑kë 'gü ꞊dhɛ ‑tuʋ̈ 'ö‑ ‑gɔdhiʋ̈mɛ 'yaa 'dhö ꞊në‑ 'dhö. 'Yö zun 'wɔn 'gbɛ 'ö ‑gban Atanna ‑wɔn ‑bha ‑a 'klɔɔ‑ ‑pö ‑nu ‑dhɛ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","꞊Dhɛ 'ö‑ ‑bha ꞊klang ‑nu 'wo‑ ‑ga ꞊dhɛ 'yënng‑ ‑gɔ ꞊ya ‑ya ‑tɔn ‑ta, 'yö 'wo ꞊yɔɔn‑ \"sɔɔ 'wo‑ pö‑ ‑dhɛ: «‑Dhɛ 'kwa‑ ‑bha ya \"tʋngtadhɛ ‑mü, 'sa \"bin ꞊ya 'ma. ");
INSERT INTO daf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'Dho‑ ‑bha kö 'i ‑wʋ 'kpɔ 'mɛ bha‑ ‑nu ‑bha kö ‑wo 'dho wo ‑bhöpë 'dhɔ ‑dhɛ 'gü 'pö‑ ‑nu 'wo kwa ‑züzü ya waa‑ gbɛɛtadhɛ ‑nu 'gü kö ‑wa ‑bhö. ");
INSERT INTO daf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Aa bhoo, kaa ꞊dede ꞊në ‑kaa ‑nu gba ‑bhöpë 'ka!» \"Kɛɛ 'yö 'wo‑ pö: «'Aa, 'mɛ 'wo ya ‑wo 'gbɛ \"gbɩɩ‑ ‑wa! ‑Yö i \"piʋ̈ ꞊dhɛ 'yi 'dho 'wëë‑ 'wo dho yëkëmɛ do ꞊saa bho‑ 'ka \"su \"saaga \"piʋ̈ bha‑ 'bluu‑ ‑dhɔ kö 'yi‑ nu‑ ‑nu ‑dhɛ kö ‑wa ‑bhö ‑ee? \"Kɛɛ kö 'zü yii‑ kë \"dhʋ̈ 'yii 'dho ꞊mɔɔ‑ ‑nu ‑ta zɔɔ ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","'Yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «‑Ka 'dho ꞊zɔɔ kö 'ka ka bhɔɔ\" bho mü, 'bluu‑ bhɛ ꞊dhɛ ꞊në ꞊ya 'to mü? ꞊Dhɛ 'wo dho 'wo wo bhɔɔ\" bho mü 'ö 'wo 'pë ꞊ya 'to ‑a ꞊dhʋng ‑së 'ka, 'yö 'wo nu 'wo‑ pö‑ ‑dhɛ: «'Bluu‑ bhɛ \"sɔɔdhu waa‑ 'yuʋ̈‑ ꞊plɛ ꞊në ꞊ya 'to mü.» ");
INSERT INTO daf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","꞊Dhɛ 'ö ꞊waa‑ pö‑ ‑dhɛ \"dhʋ̈, 'yö‑ pö ‑wo 'mɛ 'wo bha‑ ‑nu ‑ya kpö kpö 'ka blëë ‑nɛɛ ‑ta mü. ");
INSERT INTO daf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'Yö 'wo ‑ya kpö kpö 'ka, këng do këng do, \"ɛɛn ‑kaɔng \"sɔɔdhu \"sɔɔdhu. ");
INSERT INTO daf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","'Yö ö ‑kɔ ‑da 'bluu‑ bhɛ \"sɔɔdhu bha‑ 'gü, waa‑ 'yuʋ̈‑ ga ꞊plɛ bha‑ 'dhö, 'yö ö \"yan \"dhiʋ̈ ꞊wlü dhang‑ 'gü, 'yö Atanna nuɛ\" bho 'bluu‑ bha‑ ‑wɔn 'gü waa‑ 'yuʋ̈‑ bha‑ 'dhö, 'yö 'bluu‑ bha‑ \"kplü \"kplü bho, 'yö‑ dɔ ö ‑bha ꞊klang ‑nu ‑gɔ kö ‑wa 'gü ‑gblü 'mɛ 'wo bha‑ ‑nu ‑ta. 'Yö dho 'ö 'yuʋ̈‑ ꞊plɛ bha‑ nu 'pö‑ ‑nu ‑dhɛ, 'yö 'wo‑ 'gü ‑gblü 'pö 'mɛ 'wo bha‑ ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","'Yö 'mɛ 'wo bha‑ ꞊gban \"pɛpɛ 'wo 'bluu‑ bha‑ ‑bhö 'wo kën, 'yö‑ ‑kpɛa ‑yö to. ");
INSERT INTO daf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","'Yö 'bluu‑ waa‑ 'yuʋ̈‑ bha‑ ‑nu ‑da 'ko ‑ta ‑sü ‑kpɛa 'ö to 'ö dho 'ö ꞊mɔɔ töö ‑yan ‑kaɔng do ga ꞊plɛ ‑bha, ");
INSERT INTO daf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","\"kɛɛ 'sa kö gɔɔn‑ ‑nu 'wo 'pë bha‑ ‑bhö ‑wo gun mɛ \"gblü \"sɔɔdhu (kö 'wii 'në ‑nu waa‑ dhong ‑nu ‑a ‑nu ‑da mü). ");
INSERT INTO daf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","꞊Dhɛ 'wo wo bo 'pë bha‑ ‑bhö ‑sü 'ka, 'yö Yesu ‑yö zun ‑fɛɛ ‑ya ö ‑bha ꞊klang ‑nu ‑bha ‑sü ‑bha 'ö‑ pö wo ‑zë ‑wo ‑da ꞊sië \"yitagɔ 'gü kö ‑wo \"yi \"kan \"vaandhö, ‑wo ‑da ö \"dhiʋ̈ ‑wo 'dho Bɛsaida \"pɛan \"piʋ̈ kö yö ‑zë 'ö ö ‑wʋ 'kpɔ 'mɛ 'wo bha‑ ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","꞊Dhɛ 'ö ö ‑wʋ kpɔ‑ ‑nu ‑bha \"pɛpɛdhö, 'ö 'wo dho, 'yö dho ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü ‑tɔn ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","꞊Dhɛ 'ö‑ ‑bha ꞊klang ‑nu bha 'wo \"yi \"kan sië 'ö ꞊wa 'dho ꞊wa ꞊loo \"yi ꞊zinng 'gü, \"kɛɛ kö \"bin ꞊ya 'ma‑ ‑nu ‑bha ꞊dedewo, kö Yesu ‑zë ‑yö ‑tun \"sia‑ \"yi ꞊taama ö ‑dɩ ‑ta, ");
INSERT INTO daf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","'yö 'wɔn ꞊slɔɔ‑ 'gü ꞊dhɛ \"yi \"kan ‑sü ‑yö ꞊gbaɔn sië ö ‑bha ꞊klang ‑nu ‑ta ꞊dedewo, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö \"tɛɛ ꞊ya ‑siö ‑a ‑nu ‑gɔ, kö \"tɛɛ ‑yö go sië‑ ‑nu 'dho ‑zian 'ka, 'ö \"yitagɔ ‑blü 'ö dho‑ 'ka. ꞊Dhɛ 'wo dɔ ‑dhɛkpaɔ \"dhiʋ̈, 'yö dho‑ ‑nu ꞊keng‑ kö ‑yö \"ta sië \"yi bha‑ ‑ta, \"kɛɛ kö ꞊ya kë ꞊dhɛ yöö ziö‑ ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","꞊Dhɛ 'ö‑ ‑bha ꞊klang ‑nu 'wo‑ yö kö ‑yö \"ta sië \"yi ‑ta 'ö nu, ‑wa ‑ga mɛ ‑zii 'ka, 'yö 'wo zun \"tabhoo ‑da ‑sü ‑bha, ");
INSERT INTO daf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kö \"suʋ̈ ꞊ya ‑da ‑nu 'gü kö‑ ‑nu \"gblʋ̈ʋ̈‑ ‑yan ꞊gbaan 'wü, 'yö to 'ö dhiang ‑da ‑nu ‑ta 'ö‑ pö: «Ma ‑mü, ‑ka ka ‑zʋ ‑gban, \"suʋ̈ 'ya 'dho ka kë!» ");
INSERT INTO daf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Yö ‑da ‑nu \"piʋ̈ \"yitagɔ 'gü, 'yö \"tɛɛ ‑yö bo ziö ‑sü 'ka, 'yö‑ 'wɔn ‑ya ‑bha ꞊klang ‑nu bha‑ ‑nu kɔn ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","‑A ‑gɛn ‑mü ꞊dhɛ \"slë 'ö Yesu ‑ya ‑kë 'bluu‑ 'ö‑ 'gü ‑gblü bha‑ ‑wɔn 'gü bha 'wii‑ ꞊taama dɔ, gun 'ö‑ wo \"dhʋ̈ kö 'wɔn 'gü ma zuë\" 'yii ‑da ‑nu \"gblʋ̈ʋ̈‑ ꞊kö bha‑ ‑wɔn 'gü, (‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu 'dhang bho ‑sü 'yaa gun‑ \"dhiʋ̈ ꞊dhɛ ‑yö ‑mɔɔ ‑bha 'ö 'wɔn suu ‑nu bha‑ ‑nu ‑kë). ");
INSERT INTO daf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","꞊Dhɛ 'wo bo \"yi bha‑ \"kan ‑sü 'ka, 'wo ‑da Zenezadhe ‑sɛ 'gü, 'yö 'wo woo‑ \"yitagɔ to \"yi \"dhiʋ̈ mü. ");
INSERT INTO daf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","‑A ‑nu ‑go \"yitagɔ 'gü ꞊në \"gbɩɩ‑, 'yö mɛ ꞊gban 'wo to 'wo Yesu dɔ. ");
INSERT INTO daf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","'Yö ꞊ya ꞊loo ‑dhɛ \"ʋʋ ‑dhɛ 'ö‑ 'gü, ‑yö ‑kë 'pö‑ 'kpii‑ 'ka oo, ‑yö ‑kë 'pö‑ 'sɛɛnnë 'ka oo, \"ɛɛn ‑yö ‑kë 'bhlaa ꞊gbɛatadhɛ ‑zian ꞊në‑ 'ka oo, 'yö‑ 'gü ‑mɛ ‑nu 'wo dɔ ‑bɛang ‑bha 'wo dho woo‑ \"yuëdhi ‑nu 'sü \"nuu ‑nu 'gü 'wo nu‑ 'ka, 'yö 'wo‑ ‑nu ꞊loo \"dhɛɛdhɛ \"gbɛa do 'gü, 'yö 'wo ꞊bhɛa Yesu ‑dhɛ kö 'mɛ 'wo bha ‑wo zun‑ ‑bha sɔ ‑bha (kö ‑wo dha). 'Yö mɛ \"ʋʋ mɛ 'ö‑ ‑kɔ ‑zë ‑yö zun‑ ‑bha sɔ \"zɔdhiʋ̈ ‑zian ‑bha, 'yö‑ ‑nu ꞊gban \"pɛpɛ 'wo ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yi do 'ka, 'yö Fadhiziɛn ‑nu waa‑ 'tɔnggɔmɛ ‑nu 'wo go Zedhizadhɛmö 'wo bho 'ko ‑ta Yesu ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","'Yö 'wo Yesu ‑bha ꞊klang ‑nu yö kö‑ mɛ 'bha ‑nu ‑wo pë ‑bhö sië wo ‑kɔ ‑dhii 'ka, kö 'wii wo ‑kɔ \"zu (꞊dhɛ ‑kɔ 'wo‑ ‑kë 'ka ‑a ‑nu wɔ ‑kɔ 'gü Atanna ‑wɔn \"gblʋʋ \"piʋ̈ kö 'wo kë \"slʋ̈ʋ̈slʋ̈ ‑a wëëdhö bha‑ 'dhö). ");
INSERT INTO daf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","\"Kɛɛ 'sa kö Fadhiziɛn ‑nu waa‑ mɛ \"pɛpɛ 'kö 'wo Zuifö ‑zë 'ka, ‑a ‑nu 'bha ‑bha 'bha 'yaa pë ‑bhö kö 'yii ö ‑kɔ \"zu 'kpakpadhö (kë \"dhʋ̈ 'ö ‑kë ‑dhiisü Atanna wëëdhö), ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu \"bhɛma ‑nu 'wo 'wluu‑ ‑nu 'ö‑ ‑ya bha \"yi 'yaa zun‑ 'bha ‑wɔn ‑bha ‑a ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","‑A ‑wɔn 'gü, ꞊wa 'go \"dhɛɛdhö kö ‑wo nu, 'wii 'bɔn ‑bho wo ‑bha ‑zu bha‑ wo ꞊kö, 'waa ‑bhöpë ‑bhö. ꞊Ya 'go‑ 'dhɛ bha‑ 'gü, ‑a ‑nu ‑bha 'wluu‑ \"wɛɛwɛɛ 'në ‑dhɛ ‑nu 'wo ‑gban \"yitakɔɔ ‑nu oo, \"yitagbɔ ‑nu \"ɛɛn ‑piögagbɔ waa‑ ‑nu ‑wɔtapë ‑nu \"zu ‑sü ‑nu ‑bha ‑wo kpö 'ka. ");
INSERT INTO daf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fadhiziɛn ‑nu waa‑ 'tɔnggɔmɛ ‑nu ‑wa ‑zë 'wɔn bha ꞊në ‑dhɛ 'yö ꞊dhɛ 'ö ꞊wa Yesu ‑bha ꞊klang ‑nu bha‑ ‑nu yö kö ‑wo pë ‑bhö sië kö 'wii wo ‑kɔ \"zu, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «‑Yö mü ꞊dhɛ 'yö i ‑bha ꞊klang ‑nu 'waa 'wluu‑ 'ö kwa \"bhɛma ‑nu ‑wa ‑ya bha‑ ‑ya ꞊bhlëë 'gü, 'yö 'wo pë ‑bhö wo ‑kɔ ‑dhii 'ka?» ");
INSERT INTO daf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «\"Gblʋ̈ʋ̈dhɛgblɛɛnmɛ ‑nu 'ka ya, Atanna ‑wʋdhiʋ̈loomɛ Ezai 'dhö dhiang 'ö‑ zë ka ‑bha yi 'bha 'ka 'ö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü 'ö‑ pö: ‹Atanna ‑ya ‑pö: \"Sɛgɔ ya‑ 'gü ‑mɛ ‑nu ‑wo n ꞊bhlëë ‑ya wo \"dhi 'gü \"wɛɛwɛɛ, \"kɛɛ‑ ‑nu zuë\" ‑zë ‑yö n 'ka ꞊gblɛɛn, ‑a ‑nu ‑bha n ‑dhɔkë ‑gɛn 'yaa 'dhö, ‑a ‑gɛn ‑mü ꞊dhɛ 'wluu‑ ‑nu 'ö mɛ \"bhɩɩ‑ ‑nu ‑wa ‑ya bha ꞊në, 'wo wo 'ko ꞊draan‑ ‑bha ꞊dhɛ 'pë 'ö go Atanna ꞊në‑ \"piʋ̈ ‑a 'dhö› bha 'yii ꞊sua kë; ");
INSERT INTO daf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","‑a ‑gɛn ‑mü ꞊dhɛ ka ka ‑kwaa Atanna ‑bha 'tɔng‑ ‑zë ‑zü 'ö 'ka‑ ‑zuö ka ‑kɔ ꞊kee‑ ‑ta, 'yö 'ka 'wluu‑ 'ö mɛ \"bhɩɩ‑ ‑nu ‑wa ‑ya bha ꞊në‑ ‑ya ꞊bhlëë 'gü. ");
INSERT INTO daf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","'Yö go mü 'zü 'ö‑ pö‑ ‑nu ‑dhɛ: «Ka \"tʋ 'yaa Atanna ‑bha 'tɔng‑ ‑bha 'wɔn 'ö‑ 'gü 'yö bha, kë \"dhʋ̈ kö kaa‑ 'wluu‑ ‑nu ꞊në ‑wo 'to. ");
INSERT INTO daf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","‑A ‑gɛn ‑mü ꞊dhɛ Moizö ‑yö 'tɔng‑ ‑dɔ 'ö‑ pö: ‹I dë waa‑ i dhe ‑a ‑nu ꞊bhlëë ‑yö kë i ‑gɔ.› 'Yö go mü 'zü 'ö‑ pö: Mɛ \"ʋʋ mɛ 'ö dhiang yaa ze ö 'kpɔmɛ ‑nu ‑dhɛ, ‑wa ‑mɛ zë, ");
INSERT INTO daf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","\"kɛɛ ka ‑zë, ka‑ ‑pö ꞊dhɛ: «Mɛ ꞊yaa‑ pö ö 'kpɔmɛ ‑nu ‑dhɛ ꞊dhɛ 'pë 'ö gun n \"piʋ̈ ꞊dhɛ 'a‑ nu ka ‑dhɛ bha 'ma‑ ꞊gbaɔ Atanna ‑gɔ, kö‑ 'dhɛ bha ꞊ya zun ꞊naa bha.» ");
INSERT INTO daf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kö‑ ‑dhɛ 'yaa ‑bha 'zü ꞊dhɛ ‑a ‑mɛ ‑yö 'wɔn 'bha kë ö dë waa‑ ö dhe ‑a ‑nu ‑dhɛ, ");
INSERT INTO daf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","'yö 'ka bhluu\" ma‑ 'ka Atanna ‑bha 'tɔng‑ ‑nu ‑bha, ka ‑bha 'wluu‑ ‑nu 'ka‑ ‑ya bha‑ ‑wɔn 'gü. 'Yö 'wɔn suu ‑nu 'wo \"dhʋ̈ 'ka‑ 'gbɛ ‑kë. ");
INSERT INTO daf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","꞊Dhɛ 'ö ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö mɛ kpö 'wo gun mü bha‑ ‑nu ‑dhɛ 'zü ‑deewo, 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka ka \"tʋ 'to n ‑bha ‑së 'ka kö dhiang 'ö maa‑ zë bha 'ka‑ 'gü ma.» ");
INSERT INTO daf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","'Yö‑ pö: «Pë \"ʋʋ pë 'ö go \"kpɛnng 'ö ‑da mɛ \"dhi 'ö mɛ ‑ya ‑bhö, ‑a 'bha 'yaa mɛ kë ‑dhiisü Atanna wëëdhö, \"kɛɛ 'pë 'ö go‑ ‑mɛ zuë\" 'gü 'ö zun \"kpɛnng bha ꞊në‑ ‑mɛ ‑kë 'wɔnyaakëmɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","'Yö‑ pö ‑a zë 'a‑ wo sië bha 'mɛ 'wɔn 'gü ma ‑mɛ 'ka, ‑ya 'gü ma. ");
INSERT INTO daf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","꞊Dhɛ 'ö mɛ kpö bha‑ ‑nu to 'ö dho 'ö ‑da 'kɔɔdhö, 'yö‑ ‑bha ꞊klang ‑nu 'wo‑ dhɛɛ\" kpɔ \"gwënng 'ö‑ ‑da bha‑ 'klɔɔ‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'Yö‑ pö‑ ‑nu ‑dhɛ: «Kaa ‑dɩ 'pö 'kii kë 'wɔn 'gü ma ‑mɛ 'ka ꞊në wo ꞊kö ‑ee? \"Ɛɛn 'kaa‑ 'wɔn dɔ ꞊dhɛ pë 'dhɛ 'kö go \"kpɛnng 'ö ‑da mɛ \"dhi 'ö mɛ ‑ya ‑bhö, ‑a 'bha 'yaa mɛ ‑dhii kun Atanna wëëdhö ‑ee? ");
INSERT INTO daf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ pë 'dhɛ 'kö mɛ ‑ya ‑bhö ‑a 'bhaa 'dho mɛ zuë\" ‑zë 'gü, ‑yö ‑dho mɛ \"gblʋ̈ʋ̈dhɛ ꞊në‑ 'gü, ꞊ya 'go mü 'yö mɛ dho‑ 'ka blëë 'gü.» (‑A pö 'ö Yesu ‑ya wo \"dhʋ̈ bha ꞊në‑ ‑zɔn ꞊dhɛ ‑bhöpë ‑zë 'bha 'yaa mɛ \"kian 'ka.) ");
INSERT INTO daf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","'Yö go mü 'zü 'ö‑ pö: «'Pë 'ö go mɛbhɩɩdhe 'gü ꞊në mɛ ‑dhii kun Atanna wëëdhö. ");
INSERT INTO daf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","‑A ‑gɛn ‑mü ꞊dhɛ mɛ zuëpiʋ̈dhɛ bha ꞊në ‑zʋ yaa ‑gɔn mɛ 'ka ‑sü ‑nu oo, ‑da dhe \"piʋ̈ ‑sü ‑nu \"ɛɛn ‑ziö mɛ ‑nu ‑bha gɔn ꞊keng‑ ‑sü ‑nu oo, \"yënng dɔ ‑sü ‑nu oo, mɛ zë ‑sü ‑nu oo, ");
INSERT INTO daf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","꞊kwaan bho ‑sü ‑nu oo, zuë\" ‑dɔ ꞊naɔ ‑bha ‑sü ‑nu oo, suu yaa ‑dhɛ ‑nu, ꞊flü kë ‑sü ‑nu, 'wɔn ‑ma 'koo ‑sü kë ‑sü ‑nu, zuë\" ‑bhɔ mɛ ‑nu ‑bha pë ‑bha ‑sü, mɛ ‑nu 'tɔ zë ‑sü ‑nu, ‑dɩ ‑sü 'kpii‑ ‑sü ‑nu waa‑ slaa\" ‑dhɛ ‑wɔn kë ‑sü ‑nu 'wo go‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","'Wɔn yaa suu \"pɛpɛ 'ö \"dhʋ̈ bha, ‑yö ‑go mɛ zuë\" ꞊në‑ \"piʋ̈, 'yö mɛ ‑kë 'wɔnyaakëmɛ 'ka Atanna wëëdhö.» ");
INSERT INTO daf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","꞊Dhɛ 'ö ö bo dhiang ‑nu bha‑ ‑nu zë ‑sü 'ka, 'yö go ‑dhɛ bha‑ 'gü 'ö dho Tii‑ ‑sɛ 'gü. 'Yö‑ pö ö ‑dɩ ‑dhɛ 'ö 'dho kö 'ö ö ‑gblɛn 'kpɔ 'kɔ 'bha 'gü kö mɛ 'bha 'ya 'dho ö nu ‑wɔn 'wɔn dɔ, \"kɛɛ 'yö 'yii zun‑ ‑gɔ 'kɔ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","‑A ‑gɛn ‑mü ꞊dhɛ ꞊dhɛ 'ö dhebhɔnë do 'bha 'ö \"yina yaa ‑yö gun‑ 'dhu 'gü bha, 'ö‑ ma ꞊dhɛ Yesu ꞊ya nu ꞊ya ꞊loo mü, 'yö dho 'ö \"gblëënu‑ ꞊wlöö. ");
INSERT INTO daf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","‑A dhebhɔ 'ö \"dhʋ̈ bha 'yaa gun Zuifö 'ka, Glɛkö ꞊në gun‑ 'ka, 'yii go Izraɛdhö ‑sɛ 'gü, ‑yö ‑go Sidhofenisi ‑sɛ 'gü. \"Kɛɛ 'yö nu 'ö ꞊bhɛa Yesu ‑dhɛ 'ö‑ pö ‑yö dɔ \"gbɩɩ‑ kö \"yina yaa 'ö‑ 'dhu 'gü bha ‑ya kë. ");
INSERT INTO daf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Bhö dɔ kö 'në ‑nu ‑wo 'kën ꞊kö, ‑a ‑gɛn ‑mü ꞊dhɛ 'yaa ‑së kö ‑wo ‑bhöpë 'sü 'në ‑nu ‑bɛn \"dhiʋ̈ kö ‑wa nu 'gbɛnnë ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'Yö dhebhɔnë bha 'ö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Yö \"dhʋ̈ tɛan‑ 'ka, n Dëmɛ, \"kɛɛ ‑a ꞊blün 'kö go 'në ‑nu ‑kɔ ‑bha 'ö ꞊wɛnng ‑a ‑nu ‑gɛn \"piʋ̈ bha 'gbɛnnë ‑nu ‑wa yö ‑zë ‑bhö.» ");
INSERT INTO daf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Bhö 'dho, \"yina yaa ꞊ya 'go i 'dhu bha‑ 'gü ‑a pö i‑ wo \"dhʋ̈ bha‑ ‑wɔn 'gü.» ");
INSERT INTO daf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","꞊Dhɛ 'ö ö yee kë 'ö dho 'ö ꞊loo ö ‑gɔ 'kɔɔdhö, ‑yö ‑kpan ö 'dhunë ‑bha kö ‑yö wɔ sië \"gbang ‑ta, kö \"yina yaa ꞊gbaan 'dho. ");
INSERT INTO daf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö go Tii ‑sɛ 'gü 'ö bɔ Sidɔn, 'yö dho \"yitagbɛa 'ö Gadhidhe bha‑ \"pɛan \"piʋ̈. ‑A 'dho ‑sü 'ka ‑yö ‑bɔ \"sɛ ‑gɔ 'ö‑ 'pö‑ 'dhö ‑kaɔng do bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","'Yö 'wo nu‑ ‑dhɛ \"bhʋbhʋgɔn do 'ka, 'yö 'wo ꞊bhɛa‑ ‑dhɛ kö ‑yö ö ‑kɔ ‑ya ‑ta kö ‑yö bhɛa\" Atanna ‑dhɛ ‑a ‑wɔn 'gü kö ‑yö kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","'Yö 'mɛ bha‑ sü, 'yö bhɔ‑ 'ka mɛ kpö bha‑ ‑nu 'ka taa‑ 'bleng ‑bleng, 'yö ö kɔngga ‑da ‑a \"tʋ ꞊gban ꞊plɛ 'gü, 'yö ö ‑kɔ ‑yɛ 'ö \"dhidhi ‑bha 'yö‑ zun‑ 'nɛɛ‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","꞊Dhɛ 'ö ꞊ya ö bo, 'yö ö \"yan \"dhiʋ̈ ꞊wlü dhang‑ 'gü, 'yö ö ‑fʋʋ ꞊loo \"yuëdhi bha‑ ‑wëë 'ö gun‑ kë sië bha‑ ‑wɔn 'gü, 'yö‑ pö‑ ‑dhɛ: «Efata!» (꞊Waa‑ pö \"dhʋ̈ ‑a ‑nu ‑wʋ 'gü kö ‑wa pö ‹‑bhö \"pʋ!›.) ");
INSERT INTO daf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","‑Yö ‑to ‑dhɛ do bha‑ 'gü, 'ö‑ \"tʋ \"dhiʋ̈ ‑yö ‑pʋ 'ö dhiang ma, 'ö‑ 'nɛɛ‑ ‑yö zun ‑slëë 'gü ‑sü ‑bha 'ö dhiang zë 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'Yö Yesu ‑yö ‑dhio dɔ‑ ‑nu ‑ta 'ö‑ pö 'wa 'dho‑ ‑gɛn dɔ mɛ 'bha ‑dhɛ. \"Kɛɛ 'yii 'wɔn \"dhiʋ̈ 'kun, ꞊yaa‑ pö \"dhʋ̈ ‑yö ‑kë ‑zianwo ꞊dhɛ ‑ya pö ‑ka ka faan dɔ. ‑A ‑gɛn dɔ mɛ ‑nu ‑dhɛ ‑sü 'bha ꞊në ‑da 'gü‑ ‑nu ‑gɔ 'ö dho‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","\"Dhabhliwɔn ‑nu 'ö Yesu ‑ya ‑kë bha, 'yö‑ 'wɔn ‑ya ‑nu kɔn ꞊dedewo, 'yö 'wo‑ pö: «'Aa mi, mɛ 'ö ya‑ këwɔn ‑së ꞊tɔn ‑kɛɛ! ‑Yö \"tʋ ꞊wlü ‑mɛ ‑zian ‑kë dhiangmamɛ 'ka 'ö \"bhʋbhʋ ‑nu ꞊gban ‑kë \"wɩmɛ 'ka ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","‑A yi 'ö bha‑ 'ka 'zü kö mɛ kpö 'gbɛ ꞊dede ꞊wa bho \"dhuu Yesu ‑dhɛ 'gü, \"kɛɛ kö 'pë 'ö woo‑ ‑bhö 'yaa 'dhö, 'yö ö ‑bha ꞊klang ‑nu ‑dhɛ, 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«'Mɛ 'wo ya‑ ‑nu ‑wëë ꞊dede ‑yö n kë sië, ‑a ‑gɛn ‑mü ꞊dhɛ 'wo nu n \"piʋ̈ ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa ꞊nɛ, \"kɛɛ ‑bhöpë 'bha 'ö yöö kë‑ ‑nu ‑gɔ kö ‑wa ‑bhö 'yaa 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","꞊Ya kë ꞊dhɛ 'ma‑ ‑nu 'to din‑ 'ka ꞊dhɛ ‑kɔ ya‑ 'dhö, kö 'a ‑wʋ 'kpɔ‑ ‑nu ‑bha kö ‑wo 'dho, \"yiyaadhe ‑dho ‑a ‑nu bho kö 'wii ꞊loo ꞊kö wo ‑dɩ ꞊plöö, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a mɛ 'bha ‑nu 'godhɛ ‑yö ꞊gblɛɛn.» ");
INSERT INTO daf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","'Yö‑ ‑bha ꞊klang ‑nu 'wo ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Mɛ \"sinma 'wo ma ya‑ ‑nu ‑bhöpë ‑dho 'go 'mɛ \"tʋngtadhɛ 'kwa dɔ‑ ‑bha ya‑ 'gü?» ");
INSERT INTO daf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Bluu‑ bhɛ ꞊dhɛ ꞊në ka ‑gɔ?» 'Yö 'wo‑ ‑yɔ bɔ 'wo‑ pö: «'Bluu‑ bhɛ \"saɔplɛ.» ");
INSERT INTO daf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'Yö Yesu ‑ya pö ‑wo 'mɛ 'wo bha‑ ‑nu ꞊gban \"pɛpɛ 'yaanu \"sia‑. ꞊Dhɛ 'wo‑ ‑nu ꞊gban 'yaanu \"pɛɛpɛdhö, 'yö 'bluu‑ bhɛ \"saɔplɛ bha‑ sü, 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü 'yö‑ \"kplü \"kplü bho 'yö‑ nu ö ‑bha ꞊klang ‑nu ‑dhɛ kö ‑wa 'gü ‑gblü ‑a ‑nu ‑ta. 'Yö 'wo‑ 'gü ‑gblü mɛ kpö bha‑ ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","'Ö gun \"dhʋ̈ kö 'yuʋ̈ga 'në 'sɛnsɛnnë 'bha ‑nu ‑ya ‑nu ‑gɔ. 'Yö Yesu ‑ya ‑nu sü 'pö, 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü, 'yö 'wo‑ 'gü ‑gblü ‑a ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","'Yö 'mɛ 'wo bha 'wo 'bluu‑ bha‑ ‑bhö 'wo kën, 'yö‑ \"kplü \"kplü ‑kpɛa 'ö to 'wo‑ ꞊loo töö 'gü, 'yö dho 'ö ‑kë töö ‑yan \"saɔplɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","'Mɛ 'wo 'bluu‑ bha‑ ‑bhö \"dhʋ̈ bha, ‑wo ‑gun mɛ \"gblü ‑yiisiö. ꞊Dhɛ 'wo wo bo pë ‑bhö ‑sü 'ka, 'yö ö ‑wʋ kpɔ‑ ‑nu ‑bha, 'yö 'wo dho. ");
INSERT INTO daf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","‑Wo ‑to ‑dhɛ do bha‑ 'gü, 'yö Yesu waa‑ ö ‑bha ꞊klang ‑nu 'wo ‑da \"kplagɔnë 'gü, 'yö 'wo \"yi ‑kan 'wo dho Damanuta ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo mü, 'yö Fadhiziɛn ‑nu 'wo bho \"dhuu, 'yö waa‑ Yesu ‑nu 'wo ‑ya zaɔdhe ‑da ‑sü ‑bha. 'Yö 'wo‑ pö Yesu ‑dhɛ ‑a 'gü dan kian 'ka ꞊dhɛ ‑yö \"slë do 'bha kë wo \"yaan kö ‑ya ‑zɔn wo ‑dhɛ ꞊dhɛ Atanna ꞊në‑ bɔ tɛan‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","꞊Dhɛ 'wo‑ pö \"dhʋ̈, 'yö Yesu ‑yö ö ‑fʋʋ ꞊loo pinngdhö, 'yö go mü 'ö‑ pö: «\"Tʋ̈ng ya‑ 'gü ‑mɛ ‑nu ‑wo n ‑wɔn 'suan‑ ‑bho ‑bha ‑pë ‑mɔɔ ‑më ‑wɔn 'gü? A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: 'Mii 'dho \"slë ‑zë \"wɛɛwɛɛ 'bha kë ꞊dɛɛ 'gü ‑mɛ ‑nu ka ‑dhɛ tongtongdhö kö 'ka 'wɔn 'suan‑ bho‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ‑da \"kplagɔnë 'gü, 'yö‑ ‑nu to 'ö \"yi ‑kan 'zü ‑deewo 'ö dho \"yi ꞊taama. ");
INSERT INTO daf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","‑A ‑nu 'dho ‑sü 'ka, 'yö‑ ‑bha ꞊klang ‑nu ‑zʋ ‑yö bhɔ 'bluu‑ 'sü ‑wɔn 'ka, 'sa 'ö gun \"dhʋ̈ kö 'bluu‑ bhɛ do ꞊në‑ ‑nu ‑gɔ \"kplagɔnë 'gü mü. ");
INSERT INTO daf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","꞊Dhɛ 'wo ‑da zian ‑ta, 'yö Yesu ‑yö ‑dhio dɔ‑ ‑nu ‑ta 'ö‑ pö: «‑Ka ka ‑dɩ 'kun ꞊gɔng 'ö Edhodö waa‑ Fadhiziɛn ‑nu ‑gɔ bha‑ ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","‑A pö 'ö‑ wo \"dhʋ̈ bha, 'yö ‑kë ‑nu 'gü ꞊dhɛ ‑yö ‑wɩ 'bluu‑ ꞊në‑ 'ka, 'yö 'wo ‑ya ‑a pö ‑sü ‑bha wo 'ko ‑dhɛ ꞊dhɛ: «‑Yö kë 'ö‑ wo ꞊dhɛ 'bluu‑ 'yaa kwa ‑gɔ bha 'yö‑ pö sië \"dhʋ̈ bha.» ");
INSERT INTO daf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","꞊Dhɛ 'ö Yesu ꞊yaa‑ 'wɔn dɔ ꞊dhɛ ‑wa pö sië \"dhʋ̈, 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Ka ka ‑zʋ ‑gɔn \"dhʋ̈ ‑më ‑wɔn 'gü? 'Kii kë 'wɔn 'gü ma ‑mɛ ꞊në‑ 'ka ꞊kö 'yö dhiang 'kö 'a‑ zë bha 'kii‑ 'gü ma ‑ee? ");
INSERT INTO daf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","\"Ɛɛn ka zuë\" ꞊dede ꞊në \"glɔɔglɔ \"dhʋ̈, 'yö ka \"yan 'dhö 'dhö, \"kɛɛ 'yö 'kaa ‑dhɛ yö, \"ɛɛn 'zü 'yö ka \"tʋ 'dhö 'dhö, \"kɛɛ 'yö 'kaa 'wɔn ma \"dhʋ̈ bha ‑ee? \"Ɛɛn ka ‑zʋ bhɔ ‑dhɛ ꞊në ‑së ꞊dedewo \"dhʋ̈ bha ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","'Yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «'Bluu‑ bhɛ \"sɔɔdhu 'a mɛ \"gblü \"sɔɔdhu \"dhiʋ̈ gba‑ 'ka 'nu bha, ‑a töö ‑yan ꞊dhɛ ꞊në kë to?» 'Yö 'wo‑ ‑yɔ bɔ 'wo‑ pö: «‑A töö ‑yan ‑kaɔng do ga ꞊plɛ.» ");
INSERT INTO daf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","'Yö‑ ‑nu dhɛɛ\" 'bha kpɔ 'ö‑ pö: «'Yö‑ \"saɔplɛ 'dhɛ 'a mɛ \"gblü ‑yiisiö \"dhiʋ̈ gba‑ 'ka 'zü bha ꞊wɛ, ‑a töö ‑yan ꞊dhɛ ꞊në kë to?» 'Yö 'wo‑ ‑yɔ bɔ 'wo‑ pö: «‑A töö ‑yan \"saɔplɛ.» ");
INSERT INTO daf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","'Yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «'Kii‑ 'gü ma ꞊kö yö ‑zë 'bha 'gü ‑ee? (‑Yö ‑kë ka 'gü ꞊dhɛ a ‑wɩ 'bluu‑ ꞊në‑ 'ka ‑ee?)» ");
INSERT INTO daf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","'Yö 'wo dho 'wo ꞊loo Bɛsaida ‑pö 'gü. 'Yö 'wo nu \"yanwlümɛ do 'ka Yesu ‑dhɛ, 'yö 'wo ꞊bhɛa‑ ‑dhɛ kö ‑yö ö ‑kɔ pa‑ 'ka kë \"dhʋ̈ kö ‑yö kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","'Yö ö ‑kɔ ‑da ꞊kwɛɛ‑, 'yö go‑ 'ka 'plöö 'yö dho‑ 'ka \"saan ‑gɔ ‑bha. 'Yö ö \"dhidhi ‑ziö ‑a \"yan \"dhiʋ̈, 'yö ö ‑kɔ ‑ya ‑a \"yan ‑ta, 'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «I ‑dhɛ yö sië ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","'Yö 'mɛ bha 'ö ‑dhɛ ‑ga zuudhö, 'yö‑ pö: «꞊Iin, a mɛ \"bhɩɩ‑ ‑yö kö ‑yö \"ta sië, \"kɛɛ ‑yö kë n \"yan 'gü ꞊dhɛ \"dhü 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","'Yö Yesu ‑yö ö ‑kɔ kpa 'zü ‑deewo \"yan \"dhiʋ̈, ꞊dhɛ 'ö ö ‑kɔ bho mü, 'yö 'mɛ bha 'ö ‑dhɛ ‑ga 'zü zuudhö, 'yö‑ \"yan 'gü 'dhö ‑pʋ, 'yö pë ꞊gban yö 'kpakpadhö ‑së 'ka. ");
INSERT INTO daf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","'Yö Yesu ‑ya pö‑ ‑dhɛ ‑yö 'to mü kö ‑yö 'dho ö ‑gɔ 'kɔɔdhö, 'yö‑ pö‑ ‑dhɛ: «‑Bhö 'dho, 'bha 'dho ‑da 'plöö 'zü!» ");
INSERT INTO daf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yi do 'ka kö Yesu waa‑ ö ‑bha ꞊klang ‑nu ‑wo 'dho sië 'pödhɛ 'wo‑ ‑dhɛ Fidhipö ‑bha Sezadhe ‑pö ‑nu bha‑ ‑nu 'gü, 'yö‑ ‑nu dhɛɛ\" kpɔ zian 'ka 'ö‑ pö: «Ka‑ ‑ma mɛ ‑nu ‑ta ꞊dhɛ de suu ‑mü n 'ka?» ");
INSERT INTO daf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Mɛ 'bha ‑nu ‑wa ‑pö Zan Mɛzumɛ ‑mü i 'ka, 'yö‑ mɛ 'bha ‑nu ‑wa pö Atanna ‑wʋdhiʋ̈loomɛ Edhi ('ö gun yi 'bha 'ka bha yö) ‑mü i 'ka, kö mɛ 'bha ‑nu ‑wo pö sië 'pö ‑a mɛ 'dhɛ 'wo gun yi 'bha 'ka 'pö bha‑ mɛ do ‑mü i 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","꞊Dhɛ 'wo‑ pö \"dhʋ̈ 'dɔɔndhö, 'yö‑ pö‑ ‑nu ‑dhɛ: «Yö ka ‑zë ꞊wɛ? Ka ka ‑bha ‑pö 'gü ꞊dhɛ?» 'Yö Piɛdhö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Mɛ 'ö Atanna ‑ya ‑ya 'ö‑ ‑wɔn \"plüün bho bha, yö ‑mü i 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","'Yö ‑dhio dɔ‑ ‑nu ‑ta glɔglɔdhö 'ö‑ pö 'wa 'dho‑ pö mɛ \"wɛɛwɛɛ 'bha ‑dhɛ \"dhʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","‑Yö ‑zun ö ga ‑wɔn waa‑ ö ‑bö ‑wɔn ‑dhiang zë ‑sü ‑bha ö ‑bha ꞊klang ‑nu ‑dhɛ \"tʋ̈ng bha ꞊në‑ 'gü 'ö‑ pö: «‑A ‑dhɛa ‑bha ꞊dhɛ mang Mɛgbömɛ 'a sëë bho ꞊dedewo, kö ‑kwɛagbö ‑nu 'wo Izraɛdhö ‑sɛ 'gü waa‑ \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu ‑wo wo ‑kɔ \"kan n \"dhiʋ̈, kö ‑wo n zë, \"kɛɛ 'ma ga a ‑dho ‑bö ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","‑Yö ‑gun dhiang ‑nu bha‑ zë sië‑ ‑nu ‑dhɛ \"puu 'ka. 'Yö Piɛdhö ‑ya ‑dhɛ ꞊plɛ 'gü, 'yö ‑ya ‑dɔn ‑bho 'ka ‑sü ‑bha (‑a pö 'ö‑ wo \"dhʋ̈ bha‑ ‑wɔn 'gü). ");
INSERT INTO daf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","\"Kɛɛ 'yö Yesu ‑yö ꞊slëë ö 'gü 'yö ö ‑bha ꞊klang ‑nu ‑ta ‑ga, 'yö ꞊gbla Piɛdhö ‑ta 'ö‑ pö: «'Go n \"sɔɔ bha, Sɔtraan! ‑A ‑gɛn ‑mü ꞊dhɛ mɛbhɩɩdhe zuëga ꞊në i ‑gɔ, 'wɔn 'dhɛ 'kö go Atanna \"piʋ̈ ‑a 'bha 'yaa 'dho i ꞊gbin‑.» ");
INSERT INTO daf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","꞊Dhɛ 'ö ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö mɛ kpö 'wo gun‑ ꞊keng‑ bha‑ ‑nu ‑dhɛ, waa‑ ‑bha ꞊klang ‑nu 'dhö, 'yö‑ pö‑ ‑nu ‑dhɛ: «Mɛ \"ʋʋ mɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ö bɔ n 'ka, ‑a ‑mɛ ‑yö bo ö ‑dɩ 'ka n ‑wɔn 'gü, kö ‑yö saan\" ꞊dhɛ ‑kɔ 'a ꞊saan‑ 'ka ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö yaa‑ ‑pö 'ö ö ‑dɩ dha, ‑a ‑mɛ ‑gɔ ‑dho 'to‑ 'gü, \"kɛɛ mɛ 'ö bo ö ‑dɩ 'ka n ‑wɔn waa‑ 'wɔn ‑taɔng ‑së ‑wɔn 'gü, ‑yö ‑dho dha. ");
INSERT INTO daf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ ꞊ya kë ꞊dhɛ mɛ ꞊ya pë \"pɛpɛ 'ö \"kpʋng ꞊taa‑ ꞊gban ꞊slɔɔ, \"kɛɛ kö‑ 'nii‑ ‑zë ‑yö ꞊dhɛng, 'dhang 'ö 'yii‑ bho n \"dhiʋ̈ bha‑ ‑wɔn 'gü, kö‑ ‑tosɛa kë ‑gɛn ꞊në kë ‑kë ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","‑Më ꞊në dho ꞊slɔɔ mɛbhɩɩdhe ‑gɔ kö ‑yö ö 'nii‑ ‑gɔ ‑ta 'dhɔ‑ 'ka Atanna ‑gɔ?» ");
INSERT INTO daf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","'Yö‑ pö: «‑A pö 'a‑ wo 'zü \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ mɛ \"ʋʋ mɛ 'ö dho 'yiʋ̈‑ kë n ‑wɔn 'ka, \"ɛɛn 'ö dho 'yiʋ̈‑ kë n ‑wʋ \"dhiʋ̈ ꞊loo ‑sü 'ka 'mɛ ꞊wa \"kan Atanna ‑bha zian ‑bha 'ö ꞊wa kë ꞊dhɛ dhebhɔ 'ö ꞊ya 'go gwaan‑ bha 'ö ‑zua zë sië‑ 'dhö, 'ö 'wɔn yaa ꞊në‑ ‑nu ‑bhöpë 'ka ya‑ ‑nu ‑bha, mang Mɛgbömɛ a ‑dho 'yiʋ̈‑ kë 'pö‑ ‑mɛ ‑nu 'tɔ ‑ya n ‑bha ‑sü 'ka yi 'a dho nu‑ 'ka n Dë ‑bha mɛdhɛ ‑kwi 'gü kö‑ ‑bha \"kië ‑nu 'wo ‑ya ‑sü 'ka‑ ‑bha ‑ya 'gü bha ‑wo n ꞊keng‑ bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","꞊Dhɛ 'ö ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö go mü 'zü 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'ka ma bha mɛ 'bha ‑nu ‑wo ka kpö 'gü 'wii 'dho ga kö 'wii Atanna ‑bha ‑gblüdëdhɛ 'a \"wɩ sië‑ 'ka bha‑ nu ‑dhɛ yö faan 'gü. ");
INSERT INTO daf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","꞊Dhɛ 'ö ‑dhɛkpaɔyi \"saɔdo ꞊ya ziö, 'yö Yesu ‑yö Piɛdhö 'dhö, Zakö 'dhö, Zan 'dhö, ‑a ‑nu ‑da ö ꞊keng‑, 'yö wɛng‑ ‑nu 'wo ‑ziö 'wo dho ‑tɔn ꞊gblɛɛn 'bha ꞊gbin‑, kö mɛ \"wɛɛ 'bha 'yaa‑ ‑nu \"piʋ̈ mü. 'Yö ‑gla ‑a ‑nu \"yaan. ");
INSERT INTO daf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'Yö sɔ 'ö gun‑ ‑bha bha‑ \"yan 'dhö zun bhɔ ‑sü ‑bha, 'ö dɔ mü kö \"flʋ̈ 'ö‑ wo sië kö‑ ‑zɔn 'ka ‑pë 'bhaa 'dhö \"kpʋng ꞊taa 'zü. ");
INSERT INTO daf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","'Wo dho \"kan wo ‑ta kö Edhi waa‑ Moizö ('ö ꞊wa ga 'nu yi 'bha 'ka bha ꞊wa 'go dhang‑ 'gü ꞊wa nu), kö waa‑ Yesu ‑nu ‑wo dhiang zë sië. ");
INSERT INTO daf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","'Yö Piɛdhö ‑ya pö Yesu ‑dhɛ 'ö‑ pö: «N Dëmɛ, ‑dhɛ 'ö ya ‑yö ‑së \"dhɛ! 'Kwa ‑ya yö ‑yö ‑dho kë ‑së ꞊zɔɔ ‑wa! ‑Bhö dɔ kö 'yi bɔɔ\" ‑yaaga dɔ kö‑ do‑ kë i ‑bha 'ka, kö‑ do‑ kë Moizö ‑bha 'ka, kö‑ do‑ kë Edhi ‑bha 'ka ‑dhe.» ");
INSERT INTO daf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","‑A pö 'ö Piɛdhö ‑ya wo \"dhʋ̈ bha‑ \"sɩ 'yaa gun‑ ‑dhɛ. ‑Yö \"suʋ̈ ‑ziisü 'ö ‑da ‑a ‑nu 'gü 'wɔn bha‑ 'gü bha ꞊në‑ \"dhiʋ̈ ‑dhiang zë. ");
INSERT INTO daf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","'Wo dho \"kan 'zü wo ‑ta kö \"dhuu ꞊ya ‑ya ‑a ‑nu ‑ta ‑susudhö. 'Yö Atanna ‑yö bɔ \"dhuu bha‑ 'gü 'ö dhiang zë‑ ‑nu ‑dhɛ 'ö‑ pö: «N Gbö (do 'ö n ‑gɔ) 'yö ya, ‑a ‑dhɔ 'ö n ‑kë ‑a \"sinma 'yaa 'dhö, ‑ka ka \"tʋ 'to‑ ‑wʋ ‑bha kö 'ka‑ ꞊bhlëë ‑ya!» ");
INSERT INTO daf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","'Wo dho \"kan 'zü wo ‑ta 'bha wo kö Yesu yöö do ꞊në ꞊ya 'to‑ ‑nu \"piʋ̈ mü. ");
INSERT INTO daf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","꞊Dhɛ 'wo go sië ‑tɔn ꞊gbin‑ 'wo lɔɔ‑ sië, 'yö ‑dhio dɔ‑ ‑nu ‑ta 'ö‑ pö 'wa 'dho 'wɔn 'wo‑ ‑dhɛ yö bha‑ ‑gɛn dɔ mɛ 'bha ‑mɛ 'bha ‑dhɛ ‑yö 'to‑ 'ka \"dhʋ̈ ‑yö zun‑ 'ka yi 'ö yöö Mɛgbömɛ 'ö dho 'go‑ 'ka ga 'gü 'ö ‑bö bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","‑A pö 'ö‑ wo \"dhʋ̈ bha, ‑yö ‑to ‑nu \"yaan, \"kɛɛ kö‑ 'dhɛ 'kö zun‑ ‑go ga 'gü kö ‑yö ‑bö ‑wɔn ‑bha bha 'waa‑ 'gü ma, kö ‑wo wo 'ko dhɛɛ\" 'kpɔ sië 'wo‑ pö: «꞊Yaa‑ pö ꞊dhɛ 'pɛ 'dhö kö ꞊ya ‑pö ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","'Yö‑ ‑bha ꞊klang ‑nu ‑wa dhɛɛ\" kpɔ 'wo‑ pö: «\"Kɛɛ ‑a pö 'ö 'tɔnggɔmɛ ‑nu ‑wa wo 'sa ꞊dhɛ Edhi ‑dho nu, 'yö Atanna ‑bha ‑Yamɛ gun ‑na nu ya‑ 'klɔɔ‑ ‑mü ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Tɛan‑ ‑mü, Edhi dho nu ꞊kö ‑blɛɛsü kö ‑yö Atanna ‑wɔn ꞊gban zun ö zun ‑dhɛ 'gü \"pɛɛpɛdhö ‑së 'ka, ('yö‑ ‑bha ‑Yamɛ ‑yö gun ‑na nu). \"Kɛɛ ‑wʋ 'ö ‑bɛn zë ‑sü 'ka 'pö Atanna ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: ‹‑Wo ‑dho ꞊bhlëë bho Mɛgbömɛ ‑bha 'ö 'wo‑ ‑wëë ‑kë wo \"yan ‑ziö 'gü 'ka› bha‑ 'klɔɔ‑ ‑mü ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A‑ ‑pö ka ‑dhɛ ꞊dhɛ Edhi ꞊ya nu 'nu, 'yö 'wɔn 'ö ‑dhi ‑nu ‑dhɛ ꞊waa‑ wɔ‑ ‑ta ꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka‑ 'ka Atanna ‑gɔ 'sëëdhɛ 'gü ‑a 'dhö.» Edhi 'ö Yesu ‑yö ‑wɩ 'ka \"dhʋ̈ bha ꞊në Zan Mɛzumɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","꞊Dhɛ 'wo dho 'wo ꞊loo‑ ‑bha ꞊klang ‑nu 'dhɛ 'wo to ‑tɔn ‑gɛnngdhö bha‑ ‑nu \"sɔɔ, ‑wo ‑kpan mɛ kpö 'kpii‑ ‑bha kö ꞊wa ꞊klëën‑ ‑nu ‑zü, kö‑ ‑bha ꞊klang ‑nu bha waa‑ 'tɔnggɔmɛ ‑nu ‑wo zaɔdhe ‑da sië wo \"kwëë. ");
INSERT INTO daf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mɛ kpö bha ‑wo Yesu ‑yö ‑kan 'gü 'ka. ꞊Dhɛ 'wo‑ yö, 'yö 'wo dɔ ‑bɛang ‑bha 'wo dho‑ ꞊tua bho ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","꞊Dhɛ 'ö dho 'ö ꞊loo ö ‑bha ꞊klang ‑nu bha‑ ‑nu ‑dhɛ 'gü, 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Më ‑wɔn ꞊në kɛng‑ ‑nu 'ka‑ zaɔdhe ‑da sië?» ");
INSERT INTO daf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Yö mɛ do‑ bɔ mɛ kpö bha‑ 'gü 'ö‑ ‑yɔ bɔ 'ö‑ pö: «N Dëmɛ, ma ꞊në \"yina yaa 'dhö n gbö ya‑ 'gü, 'yö 'yaa \"wɩ, 'yö 'a‑ sü 'a nu‑ 'ka i \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","\"Yina 'ö‑ 'gü bha ꞊ya ‑da ‑ta ‑dhɛ 'ö‑ 'gü, 'yö‑ ‑zuö \"sia‑, 'yö‑ \"dhidhi \"vuu 'dhö ‑ya ‑kpɔkpɔdhö kö ‑yö ö \"sɔn \"dhiʋ̈ ‑bhö sië, ꞊ya 'go mü 'yö dɔ zɛɛndhö. ꞊Dhɛ 'a nu 'ö 'mii i yö, 'yö 'a ꞊bhɛa i ‑bha ꞊klang ‑nu ‑dhɛ kö ‑wo \"yina yaa bha‑ kë, \"kɛɛ 'wii ꞊mɔɔ‑ ‑bha. ('Wɔn 'ö 'yi‑ zɔadhe ‑da sië bha 'yö bha).» ");
INSERT INTO daf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Yesu ‑yö ‑dɔn bho ö ‑bha ꞊klang ‑nu 'ka 'ö‑ pö: «'Mɛ 'ö ‑zʋ ‑yö Atanna ‑dhɛ ‑sü 'yaa ka ‑gɔ ya, ka ‑dho 'dhang bho n \"dhiʋ̈ ‑më yi ꞊në‑ 'ka, \"ɛɛn ‑yö ka 'gü ꞊dhɛ a ‑dho 'to ka \"piʋ̈ ‑kpɛawo, 'ö 'a ka ‑kwɛɛ bun 'ö‑ \"dhiʋ̈todhɛ 'yaa kë ‑ee?» 'Yö‑ pö: «‑Ka nu‑ 'në 'ka n ‑dhɛ yö!» 'Yö 'wo nu‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'Në bha 'ö Yesu yö ‑dhɛ do 'ö‑ 'gü ‑yö ‑to mü 'ö \"yina bha 'ö ‑da 'gü, 'yö zun ‑dɩ ‑zë ‑sü ‑bha \"gbɩɩ‑ 'ka, 'yö ‑pö, 'yö zun glün‑ ‑sü bha ꞊dhɛ mɛ‑ sɛɛ\" ‑be ‑kë kö‑ \"dhidhi \"vuu‑ bhɔ sië. ");
INSERT INTO daf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","'Yö Yesu ‑ya dë dhɛɛ\" kpɔ 'ö‑ pö: «'Wɔn ya 'ö i gbö ꞊slɔɔ ‑a ‑kwɛ ꞊ya kë ꞊dhɛ?» 'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑A zü‑ ‑bho kö ‑yö 'në 'ka. ");
INSERT INTO daf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","\"Ta ꞊në ‑bhö ‑a wo yi ‑dhɛ, \"kɛɛ ꞊ya kë ‑nu wo ꞊sië ‑zianwo \"yina bha ‑yö ma 'në bha‑ ‑zuö pɛng \"dhiʋ̈ ‑dhɛ ‑nu waa‑ \"yi ꞊bhaa ‑dhɛ ‑nu ꞊gban 'gü kö 'ö‑ zë. ꞊Ya kë ꞊dhɛ yi ‑ta 'kun \"sɩ ‑zë ꞊ya kë i ‑dhɛ kö ‑bhö dɔ ꞊në wo \"gbɩɩ‑ kö yi ‑wëë ‑yö i kë kö 'i \"ta yi ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","'Yö Yesu ꞊ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «I ‑ta 'kun \"sɩ ‑kë n ‑dhɛ ‑wɔn ꞊në 'i‑ pö ‑ee? Ma ‑zë i dhɛɛ\" ꞊në maa‑ 'kpɔ ꞊dhɛ: ‑Zʋ ‑yö Atanna ‑dhɛ ‑sü ‑yö i ‑gɔ ‑ee? ‑A ‑gɛn ‑mü ꞊dhɛ mɛ \"ʋʋ mɛ 'ö ö ‑zʋ yö Atanna ‑dhɛ ‑a ‑mɛ ‑fië ‑bha 'wɔn 'yaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","'Yö 'në dë bha 'ö to 'ö ‑gbla 'ö‑ pö: «A 'dhang ‑bho Atanna \"dhiʋ̈, \"kɛɛ ma 'dhang ‑bho ‑a \"dhiʋ̈ ‑sü bha 'yaa 'kpakpadhö ꞊në‑ wo. ‑Bhö n ‑ta 'kun kö ‑a \"dhiʋ̈ ‑ya pa!» ");
INSERT INTO daf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","꞊Dhɛ 'ö Yesu ‑yö mɛ kpö bha‑ ‑nu yö kö ꞊wa dɔ ‑bɛang ‑bha, ‑wo nu sië ö ‑ta, 'yö ꞊gbla \"yina yaa bha‑ ‑ta 'ö‑ pö: «\"Yina 'i mɛ ‑kë \"bhʋbhʋ 'ka 'i mɛ \"tʋ wü 'i 'në ya‑ 'gü ya ma ꞊në 'a‑ pö ‑bhö 'go 'në bha‑ 'gü, 'bha 'dho, 'bha 'dho i yee kë 'i nu mü 'zü!» ");
INSERT INTO daf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","'Yö \"yina bha 'ö go 'në bha‑ 'gü kö ‑yö \"gbla sië, kö 'në ‑yö ö ‑dɩ ‑zë sië \"gbɩɩ‑ ꞊dedewo. 'Ö go mü 'yö ‑wɔ ꞊dhɛ mɛ ꞊ya ga‑ 'dhö, kö mɛ 'gbɛ ‑wa pö sië ꞊dhɛ ꞊ya ga ‑zian ꞊në‑ wo. ");
INSERT INTO daf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","\"Kɛɛ 'yö Yesu ‑yö ö ‑kɔ ‑da ‑a ꞊kwɛɛ‑ 'ö‑ ꞊wlü. 'Yö ꞊wlü 'ö dɔ ö ‑gɛan. ");
INSERT INTO daf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'ö Yesu ꞊ya 'dho ö ꞊yëë \"dhiʋ̈, 'ö waa‑ ‑bha ꞊klang ‑nu ꞊wa 'to wo do 'ka, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi Dëmɛ, yi ‑kɔ 'ö 'yii ꞊mɔɔ \"yina ya‑ kë ‑sü ‑bha ya‑ ‑gɛn ꞊në ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Bhɛa Atanna ‑dhɛ ‑sü 'ö ‑sɔbhɛɛ ‑bha ꞊në \"yina suu 'dhɛ 'kö bha‑ dho.» ");
INSERT INTO daf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'wo go ‑dhɛ 'dhɛ bha‑ 'gü 'wo bɔ Gadhidhe ‑sɛ 'gü, \"kɛɛ 'yaa gun Yesu \"piʋ̈ ꞊dhɛ mɛ 'bha ‑yö 'wɔn ꞊slɔɔ ö ‑bɔ mü ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","‑A ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö 'wɔn 'ö yöö kë ö 'ka bha ‑ya ‑ta \"pʋ sië ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «‑Wo ‑dho mang Mɛgbömɛ n ꞊gbaɔ mɛ \"bhɩɩ‑ ‑nu ‑gɔ 'ö 'wo n zë, \"kɛɛ ꞊wa n zë \"dhʋ̈, a ‑dho ‑bö ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa bha‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑bha ꞊klang ‑nu 'wii‑ 'gü ma ö 'klɔɔ‑ 'ka, \"kɛɛ 'sa kö‑ dhɛɛ\" 'kpɔ ‑sü \"suʋ̈ ‑ya ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","'Yö 'wo dho \"dhʋ̈ 'wo ꞊loo Kapɛɛnaɔmö ‑pö 'gü. ꞊Dhɛ Yesu ꞊ya bo ‑da ‑sü 'ka 'kɔɔdhö, 'yö ö ‑bha ꞊klang ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Më ‑wɔn ꞊në 'ka gun‑ zaɔkpadhe ‑da sië zian ‑ta bha?» ");
INSERT INTO daf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","\"Kɛɛ ꞊dhɛ 'ö‑ ‑nu dhɛɛ\" kpɔ \"dhʋ̈, 'yö ‑dhɛa ‑yö ga‑ ‑nu ‑ta dingdhö, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑duɛ 'kpii‑ ‑dhɛ 'ö dhang‑ 'gü ꞊waa‑ ‑wɔn zaɔdhe ‑da zian ‑ta kë \"dhʋ̈ kö 'mɛ 'ö‑ ‑duɛ 'dhö 'kpii‑ 'wo‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö 'yaanu, 'yö ö ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ ‑nu ‑dhɛ, 'yö‑ pö‑ ‑nu ‑dhɛ: «'Ö 'mɛ 'dhɛ 'ö‑ \"piʋ̈ ꞊dhɛ yö ꞊në ö ‑duɛ kë 'kpii‑, ‑a ‑mɛ ‑yö ö ‑dɩ ‑da mɛ ꞊gban \"pɛpɛ ꞊wlöö kö ‑yö kë mɛ ꞊gban \"dhiʋ̈ ‑ziö wo ‑mɛ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","'Yö ‑ziö 'ö ö ‑kɔ ‑da 'në 'dɛdɛ do 'gü, 'yö‑ dɔ‑ ‑nu kpö 'gü, 'yö go mü 'ö‑ sü, 'ö‑ ‑wɔ ö ‑gbe 'gü, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Mɛ \"ʋʋ mɛ 'ö yaa ö ‑kɔ ‑ya 'mɛ 'wo ꞊dhɛ 'në ‑nu ya‑ ‑nu 'dhö, ‑a mɛ do ‑zian ‑dhɛng ‑bha, ‑a ‑mɛ ‑bha kë n ‑bha 'ka ‑sü ‑wɔn 'gü, kö ‑yö ö ‑kɔ ‑ya ma ꞊në n ‑dhɛng ‑bha bha, 'sa mɛ \"ʋʋ mɛ 'ö ‑kɔ ‑ya n ‑dhɛng ‑bha, kö 'yii mang do n ‑dhɛng 'kun, kö n Dë Atanna 'ö n ‑bɔ bha ꞊në 'ö ö ‑kɔ ‑ya ‑dhɛng ‑bha 'pö bha.» ");
INSERT INTO daf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ ꞊ya ö bo, 'yö Zan ‑ya pö‑ ‑dhɛ: «N Dëmɛ, yi ‑kpan mɛ do 'bha ‑bha yi do 'ka kö ‑yö \"yina yaa kë sië mɛ ‑nu 'gü i 'tɔ 'gü \"kɛɛ 'sa kö 'yaa kwa ꞊keng‑, 'yö 'yi‑ ‑kɔ bho‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","'Yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «\"Dhabhliwɔn 'bha ꞊ya kë \"dhʋ̈ ꞊taamasü 'gü, 'ka 'dho‑ ‑mɛ ‑kɔ bho‑ ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ 'ö 'wɔn suu 'ö \"dhʋ̈‑ ‑kë n 'tɔ 'gü, 'yii 'dho 'go mü 'zü kö ‑yö n ‑dhiang yaa zë ö \"gblʋʋ pɛng ‑sü do bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","‑Yö kë ka \"yaan ꞊dhɛ 'mɛ 'yii dɔ kwa ‑gɔ ‑gɔn ‑yan 'gü kö ‑yö ‑bɔ kwa 'ka. ");
INSERT INTO daf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mɛ \"ʋʋ mɛ 'ö dho ka gba \"yi ‑kɔɔ ‑yan do 'ka 'ka‑ mü, ka ‑bha ‑kë mang Klisi ‑mɛ ma mɛ 'ka ‑sü ‑wɔn 'gü, a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ‑a ‑mɛ 'yii 'dho ꞊fië ö ꞊trɔɔn 'ka tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","'Yö go mü 'ö‑ pö: «\"Kɛɛ mɛ \"ʋʋ mɛ 'ö dho kë 'mɛ 'wo ꞊dhɛ 'nësɛɛnnë ‑nu 'dhö 'dhang ‑bho n \"dhiʋ̈ ‑sü 'gü bha‑ mɛ do ‑zian ‑bho Atanna ‑bha ziantamɛ 'ka, ‑gwë kpö 'kpii‑ do ‑kplü ‑a ‑mɛ bhɔ ‑bha ‑sü ‑zian 'wo‑ ‑mɛ ‑zuö 'ka ꞊weeyi ꞊bhaa ‑a fië‑ ‑dhö 'wɔn 'ö (Atanna) dho kë‑ ‑mɛ 'ka dhia\" bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","‑A ‑kë \"dhʋ̈ ‑sü ‑wɔn 'gü, ꞊ya kë ꞊dhɛ i ‑kɔ 'ö i \"dhiʋ̈ bha ꞊ya kë i ‑da Atanna \"dhiʋ̈ ‑pë 'ka, ‑bhö ‑a \"kan i ‑bha. (\"Tʋ̈ng 'ö 'bhii‑ kë ꞊kö‑ 'ka bha‑ 'ka). I ‑to ‑gbe \"kplü 'ka ‑sü 'ö 'i ‑da 'ka Atanna ‑bha ‑tosɛa 'ö 'yaa yën ‑a 'gü ‑sü fië‑ ‑dhö i ‑gbe ꞊gban ‑to i ‑bha ‑sü 'ö 'i dho‑ 'ka ꞊geebɔɔ ‑pɛng 'ö 'yaa \"dhuu ‑a 'gü ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‑Dhɛ 'ö \"dhʋ̈ bha bhiënë ‑nu 'wo mɛ ‑bhö mü bha 'waa ga tongtongdhö \"ɛɛn pɛng 'ö mü 'yaa \"dhuu. ");
INSERT INTO daf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","꞊Ya kë 'zü ꞊dhɛ i ‑gɛn do ꞊ya kë i ‑da Atanna \"dhiʋ̈ ‑pë 'ka, ‑bhö ‑a bho i ‑bha. (\"Tʋ̈ng 'ö 'bhii‑ kë‑ 'ka ꞊kö bha‑ 'ka). ‑A ‑gɛn ‑mü ꞊dhɛ i ‑da ‑sü 'ö ꞊niɔɔsü 'ka ‑tosɛa 'ö 'yaa yën‑ kë ‑dhɛ 'gü ‑sü fië‑ ‑dhö i ‑gɛn ꞊plɛ ꞊gban ‑to mü ‑sü 'ö 'i dho‑ 'ka ꞊geebɔɔ ‑pɛng 'gü ‑a ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‑Dhɛ 'ö \"dhʋ̈ bha bhiënë ‑nu 'wo mɛ ‑bhö mü bha 'waa ga tongtongdhö \"ɛɛn pɛng 'ö mü 'yaa \"dhuu. ");
INSERT INTO daf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","I \"yanga do ꞊ya kë i ‑da Atanna \"dhiʋ̈ ‑pë 'ka, ‑bhö ‑a bho mü, (\"tʋ̈ng 'ö 'yii i ‑da ꞊kö 'wɔn yaa 'gü bha‑ 'ka) i ‑da i \"yanga do 'ka Atanna ‑bha ‑gblüdëdhɛpö 'gü ‑sü fië‑ ‑dhö i \"yanga ꞊gban ꞊plɛ ‑to mü ‑sü 'ö 'i dho‑ 'ka ꞊geebɔɔ ‑pɛng 'gü, ");
INSERT INTO daf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‑dhɛ 'ö ꞊yuun 'ö mü ꞊ya ‑da mɛ 'gü 'yaa ga tongtongdhö, \"ɛɛn 'ö pɛng 'ö mü 'yaa \"dhuu tongtongdhö bha‑ 'gü ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑dho mɛ ꞊gban kwa këwɔn ‑nu \"zu pɛng 'ka ꞊dhɛ ‑kɔ 'wo ꞊wee ‑da sië‑ 'ka \"tʋʋ ‑bha bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","꞊Dhɛ 'ö \"dhʋ̈, kaa ꞊wee ‑yö kë ka 'gü kö 'ka 'to ka 'ko ‑dhɛ ‑së, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ ꞊gban kwa‑ 'wɔn ‑dɔ ꞊dhɛ ꞊wee bha pë ‑së ‑mü, \"kɛɛ ꞊ya kë ꞊dhɛ ‑a din ꞊ya bo 'go ‑sü 'ka ‑bha, ‑më \"wɛɛ 'bha ꞊në 'wo dho‑ 'sü kö ‑wa din dhi‑ 'ka 'zü ‑deewo? ꞊Ya kë \"dhʋ̈ kö ‑zun \"dhiʋ̈ ‑bhlɔɔ ꞊në 'yaa 'dhö 'zü bha (kö ꞊ya 'to ‑zuöpë ꞊në‑ 'ka.).» ");
INSERT INTO daf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","꞊Dhɛ 'ö Yesu ‑yö go ‑dhɛ bha‑ 'gü, waa‑ ö ‑bha ꞊klang ‑nu 'dhö 'yö ‑ziö 'ö dho Zude ‑sɛ 'gü, Zuudɛn ꞊taama. 'Yö mɛ \"bhɩɩ‑ ‑yö ta gblaa‑ ‑bha 'zü ‑deewo 'wo nu‑ ‑dhɛ 'gü, 'yö zun 'zü‑ ‑nu ꞊klang kë ‑sü ‑bha Atanna ‑wɔn 'ka ꞊dhɛ ‑kɔ 'ö‑ ‑kë 'ka ‑kpɛawo ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","'Yö Fadhiziɛn 'bha ‑nu 'wo nu 'wo‑ dhɛɛ\" kpɔ ‑a 'gü dan kian 'ka 'wo‑ pö: «Mɛ‑ ‑mɔɔ ‑bha 'ö mɛ ‑yö dhe bho \"bü ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","'Yö Yesu ‑ya ‑nu dhɛɛ\" kpɔ 'pö 'ö‑ pö: «Moizö ‑ya ‑pö ka ‑dhɛ ꞊dhɛ ö ‑bha 'tɔng‑ 'sëëdhɛ 'ö‑ ‑bɛn zë bha‑ 'gü?» ");
INSERT INTO daf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","'Yö 'wo‑ ‑yɔ bɔ 'pö 'wo‑ pö: «‑Ya ‑pö 'mɛ 'ö dho dhe bho \"bü ‑yö 'sëëdhɛ kë kö ‑ya ꞊nëng ‑bha kö ‑ya bho‑ 'ka \"bü.» ");
INSERT INTO daf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑A pö 'ö Moizö ‑ya wo \"dhʋ̈ bha ‑yö ‑sü kaa‑ gɔɔgbɩɩdhɛ ꞊në‑ ‑bha, ");
INSERT INTO daf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","\"kɛɛ Atanna ‑zë ‑yö gɔn waa‑ dhe ꞊në‑ ‑nu ‑da \"kpʋngtaadhɛ ‑da \"tʋ̈ng 'gü. ");
INSERT INTO daf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yö ꞊në‑ ‑wɔn 'gü, 'yö gɔɔn‑ dho \"kan ö dhe waa‑ ö dë ‑a ‑nu ‑bha, 'yö ‑kplü ö ‑bha dhebhɔ ‑bha, ");
INSERT INTO daf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","'yö mɛ ꞊plɛ bha 'wo ‑kë pë do 'ka. ꞊Ya kë \"dhʋ̈ kö 'waa mɛ ꞊plɛ 'ka 'zü, kö ꞊wa kë pë do ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","‑A ‑kë \"dhʋ̈ ‑sü ‑wɔn 'gü, ‑a ‑dhɛ 'yaa‑ ‑bha kö 'pë 'ö Atanna ꞊yaa‑ ꞊nëng 'kwëë‑ bha mɛ \"bhɩɩ‑ ‑zë ‑ya \"kan 'kwëë‑.» ");
INSERT INTO daf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","꞊Dhɛ 'ö waa‑ ‑bha ꞊klang ‑nu 'wo dho 'wo ꞊loo wo ꞊yëë \"dhiʋ̈, 'yö 'wo‑ dhɛɛ\" ‑dee 'bha kpɔ 'zü 'wɔn do bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Mɛ \"ʋʋ mɛ 'ö ö ‑bha dhe bho \"bü 'ö‑ ‑dee sü, kö‑ ‑mɛ ‑yö 'wɔn yaa ꞊në ‑kë ö ‑bha dhebhɔ ‑blɛɛsü 'ka bha, \"kɛɛ kö ‑yö ‑da ꞊në wo mɛ ‑nu ‑bha dhe \"piʋ̈ bha. ");
INSERT INTO daf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","꞊Ya kë 'pö ꞊dhɛ kö dhebhɔ ‑yö 'go gwaan‑ ‑bha kö ‑yö gwaan‑ \"wɛɛ 'kpɔ, kö ‑yö ‑zua ꞊në‑ zë. ");
INSERT INTO daf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'wo nu 'në 'sɛɛnnë 'bha ‑nu 'ka Yesu ‑dhɛ, kë \"dhʋ̈ kö ‑yö ö ‑kɔ 'pa‑ ‑nu 'ka kö ‑yö 'dhuë‑ kë‑ ‑nu ‑bha, \"kɛɛ 'yö‑ ‑bha ꞊klang ‑nu 'wii \"wɩ‑ ‑bha, 'yö 'wo zun pɛng ꞊wɛnng 'mɛ 'wo bha‑ ‑nu \"yan 'gü ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","꞊Dhɛ 'ö Yesu ‑ya ‑dhɛ yö, 'yii dhi‑ ‑dhɛ, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «'Ka 'dho 'në 'sɛɛnnë ‑nu kë n ‑bha, ‑kaa ‑nu 'to mü kö ‑wo nu n \"piʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ bha ‑yö 'mɛ 'ö‑ ‑nu ‑bha 'wɔn 'gü ma ‑kɔ 'dhö ꞊dhɛ ‑a ‑nu 'dhö ꞊në‑ ‑nu ‑bha 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'yii \"wɩ Atanna ‑bha ‑gblüdëdhɛ ‑wɔn ‑bha ꞊dhɛ 'në 'sɛɛnnë ‑nu ‑wɩ 'wɔn ‑bha ‑kɔ 'dhö, 'yii 'dho ‑da mü tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö 'në ‑nu bha‑ ‑nu ‑wɔ ö ‑gbe 'gü 'do 'do, 'yö ö ‑kɔ ‑ya ‑nu ‑ta, 'yö 'dhuë‑ ‑kë ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","꞊Dhɛ 'ö Yesu ‑yö go ‑dhɛ bha‑ 'gü 'ö ‑da zian ‑ta, 'yö gɔndë do ‑yö dɔ ‑bɛang ‑bha 'yö nu 'yö zun‑ ‑dhɛ ö kpiö 'gü, 'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «N Dëmɛ \"klʋsësü, a ‑dho ‑a kë ‑kɔ ‑kë ꞊dhɛ kö 'a ꞊sii 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha‑ ‑slɔɔ?» ");
INSERT INTO daf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","'Yö Yesu ‑ya pö‑ ‑dhɛ: «I n ‑dhɛ \"klʋsëmɛ ‑më ‑wɔn 'gü? \"Klʋsëmɛ 'bha 'yaa 'dhö kö 'yii kë Atanna ‑zë 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","'Yö go mü 'ö‑ pö: «Mangga 'tɔng‑ 'kö ‑bɛn zë ‑sü 'ka Atanna ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: ‹'Bha 'dho ‑zua zë, 'bha 'dho mɛ zë, 'bha 'dho ꞊kwaan bho, 'bha 'dho ꞊sua ‑ya mɛ ‑nu ‑bha, 'bha 'dho kwɛɛ\" yaa ‑za bho mɛ 'bha ‑bha, \"ɛɛn ü dhe waa‑ i dë ‑a ‑nu ꞊bhlëë ‑ya› bha, i yö ‑zë dɔ ‑kɛɛ?» ");
INSERT INTO daf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","'Yö gɔndë bha ‑ya ‑yɔ bɔ 'ö‑ pö: «‑A 'dhɛ 'kö bha yö ‑zë n kë ‑pë ‑mü 'a go‑ 'ka n 'nëdhe 'gü, n Dëmɛ.» ");
INSERT INTO daf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","꞊Dhɛ 'ö Yesu ‑ya ‑ga zuudhö, 'yö‑ \"dhia ‑yö ma‑ 'gü, 'yö‑ pö‑ ‑dhɛ: «‑Yö (\"dhʋ̈ tɛan‑ 'ka, \"kɛɛ) pë do ꞊në‑ këwɔn ꞊ya 'to i ‑bha, ‑bhö 'dho kö pë \"pɛpɛ 'ö i ‑gɔ 'i‑ ꞊gban \"dhɔɔ dɔ, kö 'i‑ ‑naɔ ꞊gbaɔ \"flɛɛmɛ ‑nu ‑gɔ. Atanna ‑dho ‑a ‑gɔ \"yɔɔ dɔ i ‑gɔ ꞊naɔ 'dhɛ 'ö dhang‑ 'gü ‑a 'ka, 'bha 'go mü kö 'i nu 'i ‑da n ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","\"Kɛɛ ‑a pö 'ö Yesu ‑ya wo 'mɛ bha‑ ‑dhɛ \"dhʋ̈ bha 'yö ma‑ 'ka, 'yö ö ‑bha 'dho wo ö wë ‑ta ‑sɛa 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊naɔ 'ö gun‑ ‑gɔ ‑a ‑dhiang 'yaa zë, (‑a ‑wɔn 'gü, 'yaa gun‑ \"piʋ̈ ꞊dhɛ 'ö ö ‑kɔ bho‑ 'gü). ");
INSERT INTO daf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","꞊Dhɛ 'ö 'mɛ bha ꞊ya 'dho, 'yö Yesu ‑yö ‑dhɛ ‑ga ö ‑züzü, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «꞊Naɔmɛ ‑nu ꞊dede ‑zë ‑a ‑nu ‑da Atanna ‑bha mɛ ‑nu kpö 'gü ‑dhɛ ‑dho kë 'ya‑!» ");
INSERT INTO daf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","‑A pö 'ö Yesu ‑ya wo \"dhʋ̈ bha, 'yö‑ 'wɔn ‑ya ‑bha ꞊klang ‑nu kɔn. 'Yö go mü 'yö‑ ‑ta ‑pʋ ‑a ‑nu ‑dhɛ 'ö‑ pö: «N bhang ‑nu, a‑ ‑pö ka ‑dhɛ ꞊dhɛ ‑da Atanna ‑bha ‑gblüdëdhɛ 'gü ‑dhɛ ‑yö 'ya‑! ");
INSERT INTO daf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","‑Yɔɔnmɛa ‑bha ‑bɔ ‑sɛdha ‑yɛ 'ka ‑sü ‑yö \"gbɩɩ‑, \"kɛɛ ꞊naɔmɛ ‑bha ‑da Atanna ‑bha ‑gblüdëdhɛ 'gü ‑sü ‑yö \"gbɩɩ‑ 'ö ‑ziö yö ‑zë ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","'Yö‑ 'wɔn ‑ya ‑bha ꞊klang ‑nu kɔn 'zü 'ö ziö mü, 'yö 'wo ‑ya wo 'ko ‑nu dhɛɛ\" 'kpɔ ‑sü ‑bha 'wo‑ pö: «Yö ‑zë ꞊ya kë \"dhʋ̈ 'sa kö 'dee dho dha?» ");
INSERT INTO daf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","'Yö Yesu ‑ya ‑nu ‑ga 'ö‑ pö: «Mɛ \"bhɩɩ‑ ‑nu ‑zë 'waa ꞊mɔɔ‑ ‑bha, \"kɛɛ Atanna ‑zë ‑yö ‑mɔɔ ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑zë ‑fiëbhawɔn 'yaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","'Yö Piɛdhö ‑ya pö‑ ‑dhɛ: «'Yö 'mɛ 'kö yi ‑zë 'ya \"kan yii‑ pë ꞊gban \"pɛpɛ ‑bha 'ya ‑da i ꞊keng‑ yö ꞊wɛ?» ");
INSERT INTO daf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ kö ‑yö 'to ka \"yaan ꞊dhɛ mɛ \"ʋʋ mɛ 'ö zë n ‑wɔn ‑dhɛ, \"ɛɛn 'ö zë 'wɔn ‑taɔng ‑së 'ö go Atanna ‑a ‑wɔn ‑dhɛ, 'ö go ö ‑gɔ 'kɔɔdhö, \"ɛɛn 'ö ‑kan ö dheebhang gɔɔn‑ ‑nu, \"ɛɛn dhong ‑nu, ö dë waa‑ ö dhe \"ɛɛn ö ‑bha 'në ‑nu waa‑ ö ‑bha 'bhlaa‑ ‑nu ‑bha, ");
INSERT INTO daf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","‑a ‑mɛ ‑dho ‑a ‑gaɔ këng do ꞊slɔɔ \"kpʋng ꞊taa yö, 'kɔ ‑nu 'ö‑ ‑mɛ ‑ya to bha oo, \"ɛɛn ‑a dheebhang dhong ‑nu, gɔɔn ‑nu 'ö‑ ‑nu to oo, ‑a dhe ‑nu oo, ‑a ‑bha 'në ‑nu \"ɛɛn ‑a ‑bha \"sɛ ‑nu 'ö‑ to bha, ‑yö ‑dho ‑a \"wɛɛ ꞊slɔɔ, \"kɛɛ ‑yö ‑dho ‑a ꞊slɔɔ \"yënng ꞊gbaɔn 'gü kö ‑wa ‑wëë ‑kë wo sië n ‑wɔn 'gü. \"Kɛɛ ꞊ya 'go mü, ‑a ‑mɛ ‑dho ꞊sii 'ö 'yaa yën 'ö Atanna \"piʋ̈, ‑a ‑slɔɔ ‑a ‑dhɛkpaɔ dhia\" saan 'ka. ");
INSERT INTO daf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","\"Kɛɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mɛ 'wo \"dhiʋ̈, \"tʋ̈ng ya‑ 'gü bha‑ mɛ 'gbɛ‑ ‑dho bɔ ꞊taama, 'ö 'mɛ 'wo gun ꞊taama bha‑ mɛ 'gbɛ ‑wo bɔ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","꞊Dhɛ 'ö ꞊wa ‑da 'zü zian ‑ta 'wo 'dho sië Zedhizadhɛmö, kö ‑ya ‑nu ‑dhɛ \"dhiʋ̈, kö‑ ‑bha ꞊klang ‑nu ꞊gban \"gblʋ̈ʋ̈dhɛ ꞊ya \"muu bho, \"kɛɛ kö ‑wa ꞊keng‑ \"suʋ̈ 'ka mü \"dhʋ̈, ‑yö mɛ ‑kaɔng do ga ꞊plɛ bha‑ ‑nu ‑dhɛ ö \"sɔɔ, 'yö zun 'wɔn 'ö yöö kë ö 'ka bha‑ ‑gɛn bho ‑sü ‑bha ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","'Yö‑ pö: «‑Ka ‑dhɛ ‑ga, 'dho do 'kwa‑ wo sië Zedhizadhɛmö ya, ‑wo ‑dho mang Mɛgbömɛ n 'kun, 'ö 'wo n nu \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu ‑dhɛ, 'ö 'wo n zë za 'ka, 'wo‑ pö ‑wo n zë, 'ö 'wo dho 'wo n nu 'mɛ 'waa Atanna dɔ 'wo go \"sɛ \"wɛɛ 'gü bha‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","'Ö 'wo ꞊wɛɛ dɔ n ‑bha, 'ö 'wo wo \"dhidhi ‑pɛn n ‑bha, 'ö 'wo n ma \"dhü 'ka, 'ö 'wo n zë, \"kɛɛ ‑dhɛkpaɔyi ‑yaaga ꞊ya ziö, a ‑dho 'go ga 'gü 'a ‑bö.» ");
INSERT INTO daf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","꞊Dhɛ 'ö ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö Zakö waa‑ Zan 'wo ‑kë Zebede gbö ‑nu 'ka bha, 'wo ꞊yɔɔn‑ \"sɔɔ, 'yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, 'pë 'ö yi \"piʋ̈ 'yi‑ ‑gbadhɛ i ‑gɔ ‑bha, ‑bhö dɔ \"gbɩɩ‑ kö 'i‑ kë yi ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Yö ka \"piʋ̈ 'a‑ kë ka ‑dhɛ ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","'Yö 'wo‑ pö: «Yi Dëmɛ, ‑bhö dɔ \"gbɩɩ‑ kö yi 'ö i ‑bha ‑gblüdëdhɛ dho ‑ya ‑bha ‑a 'ka bha, mɛ ꞊plɛ 'yi ya ‑duɛ 'ö mü bha i yi gba ‑a ꞊bhlëësü ‑sü 'ka ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Pë 'ka‑ ‑gbadhɛ sië n ‑gɔ bha ka‑ ‑dɔ ‑ee? Ka ‑mɔɔ ‑bha 'ö \"yi ‑dhiisü 'ö maa mü bha 'ka‑ mü ‑ee? \"Ɛɛn saan\" 'ö maa‑ wo bha ka ‑dho ꞊mɔɔ‑ wo ‑sü ‑bha ‑ee?» 'Yö 'wo‑ pö‑ ‑dhɛ: «꞊Iin, yi ‑dho ꞊mɔɔ‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","'Yö Yesu ꞊ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Yö \"dhʋ̈ tɛan‑ 'ka ꞊dhɛ 'wɔn \"gbɩɩ‑ 'ö maa‑ \"yi mü bha waa‑ saan\" 'ö maa‑ wo bha, ka ‑dho ka ‑bha wo, ");
INSERT INTO daf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","\"kɛɛ ‑a 'dhɛ 'kö ‑gban mɛ ‑bha ‑ya n ‑kɔ ‑së \"ɛɛn n ꞊kwaa 'gü ‑sü ‑wɔn ‑bha, 'yaa ma ‑zë ma 'wɔn 'ka. ꞊Ya 'go mü, 'mɛ 'ö 'wɔn 'dhɛ bha Atanna ‑ya ‑ya ‑nu ‑bha 'ka ꞊në 'wo dho‑ ꞊slɔɔ.» ");
INSERT INTO daf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","꞊Dhɛ 'ö‑ ‑bha ꞊klang ‑nu bha‑ mɛ ‑kaɔng do 'dhɛ 'wo to 'wo 'wɔn bha‑ ma, 'yö ‑kë ‑nu ‑siödhɛwɔn 'ka Zan waa‑ Zakö ‑a ‑nu kwi ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","꞊Dhɛ 'ö Yesu ‑yö 'wɔn ꞊slɔɔ‑ 'gü, 'yö‑ ‑nu ‑dhɛ 'yö‑ pö‑ ‑nu ‑dhɛ: «Ka‑ 'wɔn dɔ ꞊dhɛ ‑gblüdë ‑nu 'wo \"kpʋng ꞊taa yö 'wɔn 'ö ‑dhi ‑nu ‑dhɛ, 'yö 'wo‑ ‑wɔ woo‑ \"sɛgümɛ ‑nu ‑ta, 'yö 'mɛ 'wo mɛ ‑tiandhö ‑nu 'ka, 'wo mɛ ‑dhɛ ‑faan ‑wɔ wo ꞊kɔɔnmɛ ‑nu ‑ta, ");
INSERT INTO daf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","\"kɛɛ ka ‑zë ka ‑bha 'yaa \"dhʋ̈. 'Mɛ 'ö‑ \"piʋ̈ ꞊dhɛ ö ‑duɛ kë 'kpii‑ ka kpö 'gü Atanna wëëdhö, ‑a ‑mɛ ‑zian ꞊në ‑yö kë ka \"dhiʋ̈ ‑ziö wo ‑mɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kö 'mɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ö kë mɛ ꞊bhlëësü 'ka ka kpö 'gü (Atanna wëëdhö), yö ꞊në ‑yö kë mɛ ꞊gban ka ‑bha ꞊dhuëng 'ka. ");
INSERT INTO daf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ mang Mɛgbömɛ nu 'a‑ wo \"kpʋng ꞊taa bha, 'mii nu kö mɛ ‑yö ma ‑zë n \"dhiʋ̈ ‑ziö wo, \"kɛɛ kö ma ꞊në 'a ka \"dhiʋ̈ ‑ziö wo, kö 'a n ‑dɩ nu ka ‑gɔtadhɔpë 'ka kö mɛ 'gbɛ ‑wo kë dhamɛ 'ka ‑dhɛkpaɔ dhia\" 'gü.» ");
INSERT INTO daf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","'Yö waa‑ ‑bha ꞊klang ‑nu 'wo dho \"dhʋ̈ 'wo ꞊loo Zedhiko. ꞊Dhɛ 'ö ꞊ya 'go 'pö‑ bha‑ 'gü, waa‑ mɛ kpö 'kpii‑ 'ö gun‑ ꞊keng‑ bha‑ 'dhö, kö Time gbö 'wo‑ ‑dhɛ Batime 'ö gun gbadhɛmɛ 'ka ‑a ‑kë \"yan ‑wlü 'ka ‑sü ‑wɔn 'gü bha, ‑yö ‑ya sië zian \"gʋ̈ng \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","꞊Dhɛ 'ö‑ ma ꞊dhɛ Yesu 'ö go Nazadhɛtö bha ꞊në ziö sië bha, 'yö zun \"gbla ‑sü ‑bha 'ö‑ pö: «Yesu, Davi suu, ‑bhö n ‑wëë ‑ga kö 'i \"ta n ‑dhɛ ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","'Ö gun \"gbla sië \"dhʋ̈ kö mɛ 'gbɛ ‑wo ‑dɔn bho sië‑ 'ka 'wo‑ pö ‑yö ö \"dhi ta. \"Kɛɛ ꞊waa‑ pö‑ ‑dhɛ \"dhʋ̈ ‑yö ‑kë ꞊dhɛ 'pë 'wo‑ pö ‑yö \"gbla 'bha ꞊në wo \"gbɩɩ‑ 'ka ‑a 'dhö, 'yö ö ‑wʋ \"dhiʋ̈ ꞊wlü 'zü 'ö ‑ziö ‑a 'dhɛ 'ö gun ‑blɛɛsü bha‑ ‑ta 'ö‑ pö: «Davi Gbö, ‑bhö n ‑wëë ‑ga ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","'Yö Yesu ‑yö 'daɔnnu 'ö‑ pö: «‑Kaa ‑dhɛ!» 'Yö 'wo \"yanwlümɛ bha‑ ‑dhɛ 'wo‑ pö: «‑Bhö i 'gü dɔ \"gbɩɩ‑ kö 'i \"wlü 'i 'dho, ‑ya ‑pö 'i nu!» ");
INSERT INTO daf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","'Yö ö ‑bha ꞊gbauu‑ 'ö gun‑ ‑bha bha‑ bho 'mü 'ö‑ ‑zuö \"sia‑ (kö 'ya 'dho ‑da ö ‑gɛn 'gü), 'yö ꞊wlü 'vadhö 'ö dho Yesu ‑zian 'ka. ");
INSERT INTO daf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","꞊Dhɛ 'ö ꞊loo mü, 'yö Yesu ‑ya pö‑ ‑dhɛ: «‑Më ꞊në i \"piʋ̈ ꞊dhɛ 'a‑ kë i ‑dhɛ?» 'Yö‑ pö‑ ‑dhɛ: «N Dëmɛ, ‑yö n \"piʋ̈ ꞊dhɛ 'i \"ta n ‑dhɛ kö n \"yan ya ꞊në ‑yö ‑dhɛ yö ‑deewo!» ");
INSERT INTO daf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Bhö 'dho, i ‑bha 'dhang ‑bho n \"dhiʋ̈ ‑sü ꞊në i dha bha.» ‑Yö ‑to ‑dhɛ do bha‑ 'gü 'ö‑ \"yan ‑yö ‑dhɛ yö ‑deewo, 'yö ‑ziö Yesu ꞊keng‑ 'yö 'wo dho zian 'ö gun 'dho sië‑ 'ka bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","꞊Dhɛ 'wo 'dho sië 'ö ꞊wa ꞊yɔɔn Zedhizadhɛmö ‑pö \"sɔɔ, \"kɛɛ 'ö ꞊wa ꞊loo 'pödhɛ 'wo Bɛfaze ‑dhɛ ‑kë bha waa‑ Betani ‑dhɛ ‑a ‑nu \"saan \"dhiʋ̈, ‑tɔn 'wo‑ Odhivie ‑tɔn ‑kë bha‑ \"pɛan \"piʋ̈, 'yö ö ‑bha ꞊klang ‑nu bha‑ mɛ ꞊plɛ bɔ. ");
INSERT INTO daf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","'Yö ö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: «‑Ka 'dho 'pö‑ 'ö ‑ya ka \"dhiʋ̈ bha‑ 'gü, ka ‑dho ‑kpan ꞊soofëng 'në do ‑bha kö ‑yö ‑kplü ‑sü 'ka ka ‑da 'plöö ‑dhɛ 'gü, mɛ 'bha 'yii ‑ya ‑ta do, 'ka 'dho ‑kaa \"pʋ kö 'ka nu‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","꞊Ya kë ꞊dhɛ ꞊wa ka dhɛɛ\" kë kö ‑wa pö: ‹Ka‑ ‑kë \"dhʋ̈ ꞊dhɛ?› ‑kaa pö: ‹Yi Dëmɛ ꞊në‑ ‑mawɔn ꞊ya zun‑ ‑bha, \"kɛɛ ꞊ya ö bo ‑yö ‑dho ö ‑kɔ bho‑ 'gü 'ö 'yi nu‑ 'ka.›» ");
INSERT INTO daf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","'Yö 'mɛ 'wo bha 'wo dho, 'yö 'wo ‑kpan ꞊soofëng 'në bha‑ ‑bha kö ‑yö ‑kplü ‑sü 'ka \"kpɛnng 'kɔdhi \"dhiʋ̈ zian \"sɔɔ, 'yö 'wo‑ ‑pʋ. ");
INSERT INTO daf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","'Yö 'mɛ 'wo gun mü bha‑ mɛ kpö 'bha 'wo‑ pö‑ ‑nu ‑dhɛ: «‑Më ꞊në 'ka‑ kë sië bha? Ka ꞊soofëng 'në bha‑ ‑pʋ ‑më ‑wɔn 'gü?» ");
INSERT INTO daf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'Yö 'wo‑ ‑yɔ bɔ ꞊dhɛ ‑kɔ 'ö Yesu ‑ya pö‑ 'ka‑ ‑nu ‑dhɛ bha‑ 'dhö. ꞊Dhɛ 'wo‑ pö \"dhʋ̈ 'yö 'wo wo ‑kɔ bho‑ 'gü, 'yö 'wo dho‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","꞊Dhɛ 'wo dho 'wo ꞊loo ꞊soofëng 'në bha‑ 'ka Yesu ‑dhɛ 'gü, 'yö 'wo woo‑ sɔ ‑nu ꞊loo‑ ‑ta, 'yö Yesu 'dhö ‑ya ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","'Yö mɛ 'gbɛ 'wo woo‑ sɔ kpɔ zian ‑ta ‑dhɛ ‑nu 'gü, waa‑ \"dhü kwɛɛ\" ‑nu 'ö mɛ 'bha ‑nu ‑wa ‑kan 'bhlaa‑ ‑nu 'gü ‑a ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kö 'mɛ 'wo Yesu \"dhiʋ̈ waa‑ 'mɛ 'wo‑ ꞊taama ‑dhɛ ‑nu 'gü, ‑wo \"gɛɛ kë sië 'wo ꞊gbla ‑nu wo 'wo‑ pö: \"Sookwedhi! \"Sookwedhi! 'Mɛ 'ö nu sië kwa Dëmɛ ‑bha nu 'gü bha‑ 'tɔ ‑yö bhɔ! ");
INSERT INTO daf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kwa dë Davi ‑bha ‑gblüdëdhɛ 'ö nu sië bha ‑yö ꞊bhlɛɛ! 'Mɛ 'ka dhang‑ 'gü, ‑ka ‑bhabhoo 'kun kö 'ka‑ pö \"sookwedhi!» ");
INSERT INTO daf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","'Yö Yesu ‑yö dho \"dhʋ̈ 'ö ‑da Zedhizadhɛmö, 'yö dho Atanna ‑dhɔkëgükɔ 'gü. ꞊Dhɛ 'ö 'wɔn ‑nu 'wo mü ‑a ꞊gban 'suan‑ bho ‑së 'ka, \"kɛɛ kö 'yënng‑ ꞊ya 'dho, 'yö waa‑ ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha 'wo wo yee ‑kë 'wo dho Betani ‑pö 'gü. ");
INSERT INTO daf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","꞊Dhɛ 'ö ꞊ya wɔ mü 'ö‑ ‑tadhɛ ꞊ya ꞊kpaɔ, 'ö 'wo 'go sië Betani 'wo 'dho sië 'zü ‑deewo Zedhizadhɛmö, 'yö din‑ ‑yö Yesu kun. ");
INSERT INTO daf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","'Yö dɔ ꞊gblɛɛn 'ö figö ‑dhü do yö kö‑ \"dhɛ ‑ya ‑ta, 'yö dho 'ö ‑wo ‑bha kö‑ ‑kpʋ 'bha 'dhö mü kö 'ö‑ bho 'ö‑ ‑bhö, (‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö figö ‑pë kë \"tʋ̈ng 'yii ꞊loo ꞊kö), \"kɛɛ 'ö 'dho ꞊yɔɔn‑ \"sɔɔ ‑yö ‑kpan ‑a \"dhɛ ‑dɩ ‑slɔɔ ꞊në‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","‑Yö \"dhang ‑da figö ‑dhü bha‑ ‑bha yö ꞊në‑ ‑wɔn 'gü 'ö‑ pö: «'Bha 'dho bhɛ dɔ 'zü tongtongdhö 'ö mɛ ‑ya ‑bhö!» ‑A pö 'ö‑ wo \"dhʋ̈ bha, 'yö‑ ‑wʋ ‑yö ‑da ‑a ‑bha ꞊klang ‑nu \"tʋʋdhö. ");
INSERT INTO daf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo Zedhizadhɛmö, 'yö Yesu ‑yö dho 'ö ‑da Atanna ‑dhɔkëgükɔ 'gü. 'Yö ‑ya 'mɛ 'wo gun \"dhɔɔ ‑nu dɔ sië, \"ɛɛn 'wo gun pë 'dhɔ sië 'kɔɔdhö mü bha‑ ‑nu kë ‑sü ‑bha, 'yö 'mɛ 'wo nu 'wëë‑ fië bho ‑dhɛ 'gü 'wëë‑ 'dhɛ 'ö Atanna ‑dhɔkëgükɔ 'gü mü bha‑ ‑bha bha‑ ‑nu ‑bha 'kpongpaa ‑nu 'wo gun 'wëë‑ fië bho sië‑ ‑ta, waa‑ 'mɛ 'wo gun ‑tong \"dhɔɔ dɔ sië mü (kö ‑wo \"saa‑ bho‑ 'ka bha‑) ‑nu ‑yata ‑gbloo ‑nu ꞊wɛnng. ");
INSERT INTO daf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","'Yö ‑kɔ mɛ ‑bha zian ‑kan pë 'bha 'ka ‑sü ‑zian 'ö Atanna ‑dhɔkëgükɔ 'gü mü bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","'Yö zun dhiang ‑zë 'mɛ 'wo gun mü ‑a ‑nu ‑dhɛ ‑sü ‑bha 'ö‑ pö: «‑Yö ‑bɛn zë ‑sü 'ka Atanna ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: ‹‑Wo ‑dho ma 'kɔ ‑dhɛ \"sɛ ꞊gban \"pɛpɛ 'gü ‑mɛ ‑nu ‑bha ‑bhɛa Atanna ‑dhɛ 'gü ‑kɔ› \"kɛɛ yö ꞊në ka ‑zë 'ka‑ kë ꞊kwaanmɛ ‑nu ‑ya 'gü ‑yɛ ꞊në‑ 'ka bha.» ");
INSERT INTO daf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","꞊Dhɛ 'ö Yesu ‑wʋ bha 'ö ‑da \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu \"tʋʋdhö, 'yö ‑yɛ ‑nu ‑bha ꞊dedewo, 'yö 'wo ‑ya ‑a \"slë mɔɔ‑ ‑sü ‑bha kö 'wo‑ zë ‑gblɛn 'kpɔ 'gü. ‑A ‑gɛn ‑mü ꞊dhɛ ‑wo ‑gun \"suʋ̈ sië‑ ‑gɔ, ‑a ‑nu ‑suʋ̈ ‑gɔ 'klɔɔ‑ ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö‑ ‑bha mɛ draan‑ ‑kɔ bha ꞊ya mɛ ꞊gban ‑zʋ 'kun, (‑a ‑wɔn 'gü ꞊waa‑ pö 'wo‑ 'kun \"dhɛɛ ‑ta kö woo‑ ‑nu ‑zuö ‑gwë 'ka). ");
INSERT INTO daf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","꞊Dhɛ 'ö \"bin ꞊ya bo 'ma ‑sü 'ka, 'yö Yesu ‑yö go ö ‑bha ꞊klang ‑nu 'ka pö yaan‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","꞊Dhɛ 'ö‑ ‑tadhɛ ꞊ya ꞊kpaɔ, 'ö Yesu waa‑ ö ‑bha ꞊klang ‑nu 'wo ziö sië, 'yö‑ ‑bha ꞊klang ‑nu 'wo figö ‑dhü 'ö \"dhang ‑da ‑bha bha‑ yö kö ꞊ya ga klöngklöngdhö ꞊ya ‑da 'ka ‑a yun 'gü \"sɛɛdhö. ");
INSERT INTO daf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","‑Dhɛ 'ö Piɛdhö ‑zʋ ‑yö ‑bö ‑kɔ 'ö ‑kë 'ka yaan \"dhiʋ̈ bha‑ 'ka, 'yö‑ pö Yesu ‑dhɛ: «N Dëmɛ, ‑bhö ‑dhɛ ‑ga ꞊zɔɔ, figö ‑dhü 'i \"dhang ‑da ‑bha yaan \"dhiʋ̈ bha ꞊ya ga.» ");
INSERT INTO daf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","'Yö Yesu ‑yö dhiang zë‑ ‑nu ‑dhɛ 'ö‑ pö: «‑A 'wɔn 'ya 'dho ka 'kɔn. 'Pë 'ö‑ ‑wɔn 'dhö ka ‑bha yö ‑mü ‑zʋ ‑yö Atanna ‑dhɛ ‑sü ꞊në‑ 'ka doseng (꞊dhɛ‑ ‑fiëbhawɔn 'yaa 'dhö). ");
INSERT INTO daf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'dhang ‑bho Atanna \"dhiʋ̈ ‑sü ꞊ya kë ka ‑gɔ ꞊dedewo 'kpakpadhö, 'ka‑ pö ‑tɔn 'ö dɔ ya‑ ‑dhɛ ‑yö 'go ö \"gblʋ̈ kö ‑yö 'dho ‑yö ‑pö ꞊weeyi ꞊bhaa, kö 'kii dɔ 'kën 'gü, ka ‑dho ‑a ‑dhɛ yö kö ꞊ya kë. ");
INSERT INTO daf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yö ꞊në‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ pë \"pɛpɛ 'ö 'ka dho‑ ‑gbadhɛ Atanna ‑gɔ kö ka bhɛa\" sië‑ ‑dhɛ bha, ‑ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ 'ka‑ ꞊slɔɔ, ka ‑dho ‑a yö kö ‑a 'gü ‑wɔn ‑yö kë sië. ");
INSERT INTO daf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","꞊Ya kë ꞊dhɛ 'ka bhɛa\" sië Atanna ‑dhɛ, kö ka ‑zʋ ‑yö ‑bö ꞊dhɛ 'wɔn ‑yö kaa mɛ 'bha ka ꞊zinng 'gü, ‑kaa ‑mɛ ‑mawɔn 'to, kë \"dhʋ̈ kö ka Dë 'ö dhang‑ 'gü ‑yö kaa‑ 'wɔn yaa ‑nu ‑mawɔn 'to 'pö. ");
INSERT INTO daf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","\"Kɛɛ ꞊ya kë ꞊dhɛ 'kii \"wɩ‑ ‑bha kö 'ka‑ mɛ ‑mawɔn 'to, ka Dë 'ö dhang‑ 'gü, 'yii 'dho kaa‑ 'wɔn yaa ‑nu ‑mawɔn 'to 'pö.» ");
INSERT INTO daf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo ‑deewo Zedhizadhɛmö, 'ö Yesu 'dhö ziö sië Atanna ‑dhɔkëgükɔ 'gü, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu oo, 'tɔnggɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu 'wo nu‑ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'Yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «'Wɔn 'i‑ kë sië ya, i‑ ‑kë de ‑bha kë 'gü? \"Ɛɛn i wɛa ‑loo ‑dhɛ ‑mɛ ‑mü de 'ka?» ");
INSERT INTO daf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «A ‑dho ka dhɛɛ\" do 'kpɔ 'pö, ꞊ya kë ꞊dhɛ 'ka‑ ‑yɔ bɔ n ‑gɔ kö 'a ka ‑bha bha‑ ‑yɔ bɔ: ");
INSERT INTO daf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Zan ‑bha mɛ ‑bɔ Atanna 'ka ‑zu 'ö gun‑ bho sië bha Atanna ꞊në‑ pö \"ɛɛn mɛ \"bhɩɩ‑ ‑nu ꞊në 'wo‑ bho wo ‑dɩ 'gü? ‑Kaa ‑yɔ bɔ n ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","\"Kɛɛ 'yö 'wo ‑ya ‑a \"slën bho ‑sü ‑bha wo \"kwëë 'wo‑ pö: «꞊Ya kë ꞊dhɛ 'ya‑ pö Atanna ꞊në‑ pö, ‑yö ‑dho ‑a pö kwa ‑dhɛ: ‹‑Yö ‑kë mü ꞊dhɛ 'sa 'yö 'kii 'dhang bho‑ \"dhiʋ̈?› ");
INSERT INTO daf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","\"kɛɛ 'sa 'ya‑ pö ꞊dhɛ mɛ \"bhɩɩ‑ ‑nu ꞊në 'wo‑ bho wo ‑dɩ 'gü kö ‑nnn!» (‑A pö 'wo wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑wo \"suʋ̈ sië \"sɛgümɛ ‑nu ‑gɔ, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ mɛ ꞊gban \"pɛpɛ‑ ‑gun 'dhang bho sië Zan \"dhiʋ̈ ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ꞊dede ‑mü.) ");
INSERT INTO daf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'wo‑ ‑yɔ bɔ Yesu ‑gɔ 'wo‑ pö: «'Yaa‑ 'wɔn dɔ.» 'Yö‑ ‑yɔ bɔ 'pö‑ ‑nu ‑gɔ 'ö‑ pö: «Mang ‑dɩ 'pö, 'mii 'dho n ‑bha ya‑ wɛa ‑loo ‑dhɛ ‑mɛ pö ka ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","꞊Dhɛ 'ö ꞊wa wo bo dhiang ‑nu bha‑ ‑nu zë ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö Yesu ‑yö zun dhiang ‑zë ‑a ‑nu ‑dhɛ ‑sü ‑bha \"gwënng 'gü 'ö‑ pö: «Yi do 'ka 'yö gɔndë do 'bha ‑yö ö ‑bha ‑drɔɔ ‑bhlaa kpɔ. 'Yö‑ ‑zü ꞊klëën \"dhʋʋ 'ka kpɛnngkpɛnngdhö, 'yö dho 'ö‑ \"yibhogüpë ‑pë ‑kë, 'yö dho 'ö 'kɔ dɔ‑ \"dhiʋ̈ (kö ‑yö kë ‑dhɛ bha‑ ‑maa ‑kë ꞊wlöö ‑kɔ 'ka), 'yö dho 'ö 'bhlaa‑ bha‑ ‑da buzan 'gü 'yö dho \"ta 'gü. ");
INSERT INTO daf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","꞊Dhɛ 'ö ‑drɔɔ ga bho \"tʋ̈ng ꞊ya ꞊loo, 'yö ö ‑bha gwëëmi do bɔ buzankëmɛ ‑nu bha‑ ‑nu \"piʋ̈ kö ꞊wa wo bo kö ‑wa ‑gblü kö ‑wo ö ‑bha dɔ ö ‑bha gwëëmi bha‑ ‑gɔ kö ‑yö nu‑ 'ka ö ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'Yö buzankëmɛ ‑nu bha 'wo gwëëmi bha‑ kun, 'yö 'wo‑ ‑ma ‑tɛkpɛ ‑tɛkpɛdhö 'wo wo ꞊kwaa‑ ‑zü 'yö dho ö ‑kɔ 'gü \"fië 'ka ö dëmɛ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","'Yö ꞊slëë 'zü 'yö mɛ \"wɛɛ 'bha bɔ, 'yö 'mɛ 'wo bha 'wo mɛ 'dhɛ bha‑ kun 'zü 'wo‑ ‑ma ‑tëkë ‑tëkëdhö, 'yö 'wo bhië ‑ya ‑gɔ ‑bha, 'yö 'wo \"si bho‑ ‑gɔ ‑kɔ ꞊gban ‑kɔ ꞊gban 'gü ");
INSERT INTO daf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","'yö dho 'ö‑ mɛ ‑yaaga ‑naa bɔ, 'yö 'wo dho 'wo yö ‑zë zë, 'yö dho 'ö mɛ kpɔ 'bha bɔ 'zü ꞊taama, \"kɛɛ 'yö‑ 'bha 'yii 'wɔn \"dhiʋ̈ 'kun, 'yö 'wo‑ ‑nu ‑ma, \"ɛɛn 'wo‑ ‑nu zë. ");
INSERT INTO daf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","7","‑A \"tʋ̈ng bha‑ 'ka kö ‑drɔɔdhɛ dëmɛ bha‑ gbö do 'në 'ö‑ ‑bha 'wɔn ꞊gban \"pɛpɛ 'ka ꞊në ꞊ya 'to‑ ‑gɔ, kö yö ꞊në ꞊ya 'to ꞊dhɛ bɔmɛ 'dhö ‑a ‑kɔ \"dhiʋ̈ ꞊taamasü 'gü. 'Yö‑ pö ö ‑dɩ ‑dhɛ ꞊dhɛ mɛ 'dhɛ 'kö ya ‑yö kë 'ö‑ wo n gbö 'ka bha, ‑wo ‑dho ‑a ꞊bhlëë ‑ya 'ö 'wo wo \"tʋ to‑ ‑wʋ ‑bha. 'Yö ‑ziö 'ö‑ bɔ, \"kɛɛ ꞊dhɛ 'ö‑ gbö bha 'ö dho 'ö ꞊loo mü, 'yö buzankëmɛ ‑nu bha 'wo‑ ‑ya 'kwëë‑ ‑kë 'wo‑ pö: «Mɛ ꞊dede 'ö yöö 'kɛan‑ bha‑ 'sü ‑zianwo 'yö nu bha, ‑ka ‑kwaa 'kun 'kwa‑ zë, kö 'kɛan‑ bha ‑yö 'to kwa ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'Yö 'wo‑ kun 'wo‑ zë, 'yö 'wo dɔ‑ ꞊gee ‑bha 'wo‑ ‑zuö \"bü ꞊gblɛɛn. ");
INSERT INTO daf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'Mɛ 'ka dɔ bha, ꞊ya kë \"dhʋ̈ kö ‑më ‑wɔn ꞊në ‑drɔɔdhɛ dëmɛ yöö kë ꞊taamasü 'gü? Kö yöö ꞊dede ꞊në‑ nu ‑wɔn ꞊ya 'to, kö ‑yö buzankëmɛ ‑nu bha‑ ‑nu zë, kö ‑yö ö bha 'bhlaa‑ 'sü ‑ya dɔ mɛ \"wɛɛ ‑nu ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","꞊Dhɛ 'ö‑ pö \"dhʋ̈ 'ö ö bo, 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Wʋ 'ö ‑bɛn zë ‑sü 'ka Atanna ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: ‹‑Gwë 'ö 'kɔdɔmɛ ‑nu 'wo wo ꞊kwaa‑ ‑zü bha ꞊në kë ‑kë 'kɔ \"kpan ‑ya ‑ta ‑gwë 'ka bha 'kii‑ ma do ‑ee? ");
INSERT INTO daf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","‑A ‑bha ‑kë 'kɔ \"kpan ‑ya ‑ta ‑gwë 'ka ‑sü bha, ‑yö ‑dhi Atanna ꞊në‑ ‑dhɛ, ‑yö \"dhabhliwɔn ‑zian ꞊në‑ 'ka.›» ");
INSERT INTO daf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","꞊Dhɛ 'ö ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka bhoo, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu bha 'wo‑ 'wɔn dɔ ꞊dhɛ ‑yö \"gwënng bha‑ ‑da wo ꞊në wo ‑dhɛ. 'Yö 'wo zun‑ \"slë mɔɔ‑ ‑sü ‑bha kö 'wo‑ 'kun, \"kɛɛ kö ‑wo \"suʋ̈ sië \"sɛgümɛ ‑nu kpö 'wo gun 'mü bha‑ ‑nu ‑gɔ, 'yö 'wo‑ to 'mü 'wo woo‑ 'dho wo. ");
INSERT INTO daf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","꞊Dhɛ 'ö 'mɛ 'wo bha 'wo dho, 'yö 'wo Fadhiziɛn 'bha ‑nu waa‑ Edhodö ‑bha mɛ 'bha ‑nu bɔ kö ‑wo Yesu ‑wʋ mɔɔ‑, kö‑ ‑wʋ ꞊ya ꞊dië ‑dhɛ 'ö‑ 'gü kö ‑yö kë‑ ‑nu bɔdhɛ 'ka kö‑ ‑nu ‑kɔ ‑yö ꞊mɔɔ‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","꞊Dhɛ 'wo nu, 'yö 'wo‑ pö Yesu ‑dhɛ: «Yi Dëmɛ, ‑a 'wɔn ‑yö yi \"yaan ꞊dhɛ tɛanwɔn pömɛ ‑mü i 'ka, ꞊dhɛ 'bhaa \"suʋ̈ mɛ 'bha ‑mɛ 'bha ‑gɔ, 'sa 'bhaa ‑kpla mɛ 'bha ‑gɔ ‑a ‑bha ‑kë ‑tiandhö ‑sü ‑wɔn 'gü kö i ꞊flü kë mɛ ‑gɔ, ꞊dhɛ tɛan‑ ‑zian 'ö go Atanna \"piʋ̈ ꞊në 'i‑ ‑zɔn mɛ ‑dhɛ. ‑A ‑kë \"dhʋ̈ ‑sü 'gü, 'wɔn 'ö ‑gban 'nii‑ sɔng ‑bho Wlɔmö ‑mɛ ‑nu ‑bha ‑gblüdë 'kpii‑ ‑dhɛ ‑sü ‑bha ya i i ‑bha ‑pö 'gü ꞊dhɛ? 'Yi‑ bho ‑ee? \"Ɛɛn 'ya 'dho‑ bho ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","꞊Dhɛ 'ö Yesu ‑ya 'wɔn dɔ ꞊dhɛ kpa ꞊në 'wo‑ wo sië ö ‑dhɛ 'gu ‑ta bha, 'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Ka n 'gü ‑dan ‑më ‑wɔn 'gü? ‑Ka nu n ‑dhɛ \"tanmaga do 'ka kö 'a‑ ‑ga!» ");
INSERT INTO daf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'Yö 'wo nu‑ ‑dhɛ ‑a do 'ka. 'Yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «De ꞊në‑ ‑gɔ \"blɛɛn‑ waa‑ 'tɔ 'wo‑ ‑ta ya?» 'Yö 'wo‑ pö‑ ‑dhɛ: «Wlɔmö ‑mɛ ‑nu ‑bha ‑gblüdë 'kpii‑.» ");
INSERT INTO daf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","'Yö‑ pö‑ ‑nu ‑dhɛ: «꞊Dhɛ 'ö \"dhʋ̈, ‑ka 'dho kö pë 'dhɛ 'ö ‑gblüdë bha‑ ‑bha 'ka 'ka‑ dɔ‑ ‑gɔ, kö‑ 'dhɛ 'ö Atanna ‑bha 'ka 'ka‑ nu Atanna ‑dhɛ!» ‑A ‑yɔ 'ö‑ bɔ‑ ‑nu ‑gɔ \"dhʋ̈ bha, 'yö‑ 'wɔn ‑ya ‑nu kɔn ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'mɛ 'wo‑ ‑nu Sadusiɛn ‑nu ‑kë 'ö 'waa 'dhang bho 'mɛ ꞊wa ga ‑a ‑nu ‑bö ‑wɔn \"dhiʋ̈ bha, 'wo nu Yesu \"piʋ̈, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Yi Dëmɛ, 'pë 'ö Moizö ‑ya ‑bɛn zë 'ö‑ to kwa ‑gɔ 'yö ya. ‑Ya ‑pö 'mɛ 'ö‑ dheebhang ꞊ya dhe 'sü, kö ‑yö ga kö waa‑ ‑bha dhebhɔ bha 'wii 'në ꞊slɔɔ, ‑a ‑dhɛa ‑bha ꞊dhɛ ‑a ‑mɛ dheebhang 'zlaa‑ ‑ya 'kɛandhe bha‑ 'sü dhe 'ka kö wɛng ‑wo 'në 'kpɔ kö ‑yö kë‑ dheebhang 'ö ga bha‑ suu 'ka. ");
INSERT INTO daf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","\"Kɛɛ ‑bhö ‑a ‑ga, dheebhangzë ‑nu \"saɔplɛ ꞊në 'wo gun, 'yö‑ mɛ 'kpiisü ‑yö dhe sü, 'yö 'wii 'në 'kpɔ 'yö ga. ");
INSERT INTO daf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'Yö 'mɛ 'dhɛ dɔ mü 'ö‑ 'kɛan‑ ‑dhe bha‑ sü, 'yö 'wii 'në 'kpɔ 'pö, 'yö ga. 'Yö‑ mɛ ‑yaaga ‑naa ‑bha dho 'pö 'ö ‑kë ‑dhɛ ‑kɔ do bha‑ 'dhö, ");
INSERT INTO daf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","'yö dho‑ 'ka \"dhʋ̈ 'yö mɛ \"saɔplɛ bha‑ ꞊gban 'wo dhe do bha‑ sü, 'yö‑ ‑nu \"wɛɛ 'bha 'wii 'në 'kpɔ, 'yö‑ ꞊gban ‑wo ga. ꞊Dhɛ 'ö gɔɔn‑ ‑nu bha‑ ‑nu ꞊gban ꞊wa ga, 'yö dhebhɔ bha 'ö ga 'pö. ");
INSERT INTO daf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","'Mɛ 'wo bha‑ ‑nu ꞊gban ꞊wa dhe do bha‑ 'sü ꞊tɔn. ꞊Ya kë \"dhʋ̈ yi 'ö 'mɛ ꞊wa ga 'wo dho bɔ‑ 'ka bha ꞊ya ꞊loo, dhebhɔ bha‑ ‑dho kë 'mɛ 'wo bha‑ de ‑sü ꞊në‑ bha dhe 'ka kpɛnngdhö?» ");
INSERT INTO daf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Zian ꞊në 'ka‑ to 'yö 'ka \"wɩ sië bha, ‑a ‑gɛn ‑mü ꞊dhɛ 'pë 'ö Atanna ‑wʋ ‑ya pö 'kaa 'bha 'gü ma, \"ɛɛn 'kaa 'wɔn 'ö Atanna ‑bha 'gügbɩɩdhɛ ‑yö ꞊mɔɔ‑ ‑bha 'ö‑ ‑kë ‑a 'bha dɔ.» ");
INSERT INTO daf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","'Yö‑ pö: «‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ yi 'ö 'mɛ ꞊wa ga 'wo dho ‑bö 'ka bha, mɛ 'bha 'yii 'dho dhe 'sü, \"ɛɛn dhebhɔ 'bha 'yii 'dho gwaan‑ 'kpɔ, \"kɛɛ mɛ ꞊gban ‑dho kë ꞊dhɛ Atanna ‑bha \"kië ‑nu ꞊në‑ 'dhö dhang‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","\"Ɛɛn 'wɔn 'ö ‑gban 'mɛ ꞊wa ga 'nu ‑a ‑nu ‑bö ‑wɔn ‑bha ‑a ‑dhiang 'ö Atanna ‑ya zë, 'ö ‑bɛn zë ‑sü 'ka Moizö ‑gɔ 'sëëdhɛ 'gü, kö ꞊ya ö ‑dɩ ‑zɔn ‑dhɛ ‑kpɔɔ kpö 'gü bha 'kii‑ ma do ‑ee? ‑A pö 'ö‑ wo ꞊dhɛ: ‹Ma ꞊në 'a Ablaamö oo, Izaakö oo, Zakɔbö oo, a ‑nu ‑bha Atanna 'ka› bha, 'kii‑ ma ‑ee? (A‑ ‑pö ka ‑dhɛ ꞊dhɛ Atanna ‑yö dhiang bha‑ zë Moizö ‑dhɛ \"dhʋ̈ kö 'mɛ 'wo bha ꞊wa ga 'nu kö‑ yi ꞊ya ꞊gwëë. \"Kɛɛ ‑ya ‑pö Moizö ‑dhɛ 'ö‑ pö: «Ma ꞊në 'a‑ ‑nu ‑bha Atanna 'ka», 'yii‑ pö: «Ma ꞊në 'a gun‑ ‑nu ‑bha Atanna 'ka.») ");
INSERT INTO daf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","꞊Ya kë \"dhʋ̈ kö kwa‑ 'wɔn ‑dɔ ꞊dhɛ Atanna bha ‑yö 'mɛ 'wo \"yaandhe 'ka ꞊në‑ ‑nu ‑bha Atanna 'ka, 'mɛ ꞊wa ga bha‑ ‑nu ‑bha Atanna 'yaa ‑mü. ‑A ‑kë \"dhʋ̈ ‑sü 'gü, ꞊ya kë ꞊dhɛ 'ka ka ‑zʋ 'gɔn ꞊dhɛ 'mɛ ꞊wa ga 'waa ‑bö, kö \"kpënng‑ ꞊në 'ka‑ kë sië ka ‑dɩ ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","꞊Dhɛ 'ö 'tɔnggɔmɛ ‑nu 'wo gun mü bha 'wo‑ 'wɔn dɔ ꞊dhɛ zaɔdhe 'ö Sadusiɛn ‑nu waa‑ Yesu ‑nu 'wo‑ ‑da bha ꞊yaa‑ ‑yɔ bɔ ‑kɔ ‑së kë ‑a ‑nu ‑gɔ, 'yö‑ ‑mɛ do ‑yö ꞊yɔɔn 'pö‑ \"sɔɔ 'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «Atanna ‑bha 'tɔng‑ \"pɛpɛ bha‑ ‑mɛɛ ꞊në‑ ꞊bhlëë 'dhö 'kpii‑?» ");
INSERT INTO daf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑A 'kpiisü ꞊në: Izraɛdhö ‑mɛ ‑nu, ‑a 'wɔn kë ka \"yaan ꞊dhɛ kwa Dëmɛ 'ö kwa ‑bha Atanna 'ka bha ꞊në 'ö Atanna ‑zë 'ka \"dhʋ̈ doseng, ");
INSERT INTO daf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","꞊dhɛ 'ö \"dhʋ̈, kwa Dëmɛ bha‑ ‑dhɔ ‑yö ka kë ka zuë\" ꞊gban 'ka, ka ‑zʋtakɔ ꞊gban 'ka, ka faan ꞊gban 'ka bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","‑A 'dhɛ dɔ‑ \"piʋ̈ ꞊në‑ pö ꞊dhɛ: «I këyɔɔ ‑dhɔ ‑yö i kë ꞊dhɛ i ‑dɩ ‑dhɔ 'dhö i ‑dɩ ‑kë ‑kɔ 'ö‑ ‑bha bha‑ 'dhö.» 'Tɔng‑ \"wɛɛwɛɛ 'bhaa 'kpii‑ kö ‑yö ziö ‑a ꞊plɛ 'kö bha ꞊në‑ ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","'Yö 'tɔnggɔmɛ bha 'ö‑ pö‑ ‑dhɛ: ‑Yö \"dhʋ̈ tɛan‑ 'ka, n Dëmɛ, ‑a pö 'i‑ wo ꞊dhɛ Atanna ‑yö doseng ‑a \"wɛɛ 'bhaa 'dhö yö ‑zë zian 'gü bha 'yaa ꞊sua 'ka, ");
INSERT INTO daf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","\"ɛɛn 'zü ‑a pö 'i‑ wo ꞊dhɛ Atanna bha‑ ‑dhɔ ‑bha mɛ kë ‑sü 'ö i zuë\" ꞊gban 'ka, i ‑zʋgɔngüwɔn ꞊gban 'ka, i 'nii‑ ꞊gban 'ka, \"ɛɛn i faan ꞊gban 'ka, \"ɛɛn 'zü i këyɔɔ ‑dhɔ ‑bha i kë ‑sü 'ö ꞊dhɛ i ‑dɩ 'dhö bha‑ ꞊bhlëë‑ 'kpii‑ 'ö ‑ziö \"saa‑ ꞊gban \"pɛpɛ suu ‑ta bha‑ 'bha 'yaa ꞊sua 'ka. ");
INSERT INTO daf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","꞊Dhɛ 'ö Yesu ‑ya dɔ ꞊dhɛ ‑a ‑yɔ 'ö 'tɔnggɔmɛ bha 'ö‑ bɔ bha ‑ya ‑bɔ ꞊kpaɔdhɛ ‑bha 'yö‑ pö‑ ‑dhɛ: «Bhi ‑zë 'bha ꞊tëng ‑da Atanna ‑bha ‑gblüdëdhɛ 'gü ‑sü ‑ta.» 'Ö go yö ‑zë 'gü, mɛ 'bha 'yii ꞊mɔɔ‑ ‑bha kö ‑ya dhɛɛ\" 'kpɔ 'zü. ");
INSERT INTO daf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö zun 'zü mɛ ꞊klang kë ‑sü ‑dee ‑bha Atanna ‑dhɔkëgükɔ bha‑ 'gü. 'Yö dho 'ö dhɛɛ\" do kpɔ 'ö‑ pö: «‑A pö 'ö 'tɔnggɔmɛ ‑nu ‑wa wo ꞊dhɛ Izraɛdhö ‑mɛ ‑nu Dhamɛ Klisi bha Davi suu ‑mü ya‑ ‑gɛn ‑mü ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","\"kɛɛ kö Davi yöö ꞊dede ꞊në‑ pö Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑kɔ 'ka yi 'bha 'ka ꞊dhɛ: ‹Atanna ‑ya pö n Dëmɛ ‑dhɛ 'ö‑ pö: ‑Bhö ‑ya ‑yɛa ꞊bhlëësü 'ö n \"sɔɔ ya‑ 'gü ‑yö 'to‑ 'ka \"dhʋ̈ ‑yö zun‑ 'ka yi 'a dho i 'yaɔ‑ ‑nu kë‑ 'ka i ‑gɛn ꞊wlöö ‑sabha 'ka bha‑ ‑bha.› ");
INSERT INTO daf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mɛ 'ö Davi yöö ꞊dede 'ö‑ ‑dhɛ ö Dëmɛ bha, ‑yö kë ‑kɔ ‑kë ꞊dhɛ 'yö dho 'ö ‑kë 'zü yö ‑zë bhaanë 'ka?» 'Ö gun \"dhʋ̈ kö mɛ kpö 'gbɛ ꞊dede ‑wo \"tʋ 'to sië‑ ‑wʋ ‑bha 'ö‑ \"dhia ‑yö ma‑ ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","40","'Yö zun 'mɛ 'wo bha‑ ‑nu ꞊klang kë ‑sü ‑bha 'ö‑ pö: «‑Ka ka ‑dɩ 'kun 'tɔnggɔmɛ ‑nu ‑gɔ. ‑A ‑gɛn ‑mü ꞊dhɛ sɛɛ\" ‑kpɔ mɛ ‑nu ‑dhɛ \"yigblütamɛ ‑nu ‑mü. ‑Tɔyang ꞊gblɛɛngblɛɛn bha ꞊në‑ ‑da ‑dhɔ ‑ya ‑nu ‑kë, waa‑ ‑bhɛa Atanna ‑dhɛ ‑kɔ 'gü ꞊gblɛɛngblɛɛn ‑nu bha‑ 'dhö, kë \"dhʋ̈ kö mɛ ꞊gban \"pɛpɛ ‑wa ‑nu ꞊bhlëë ‑ya, \"ɛɛn kö mɛ ꞊gban \"yan ‑ya ‑nu 'kun, kö ꞊wa ꞊loo \"dhɛɛdhɛ ‑nu 'gü, kö ‑wa ‑nu ꞊bhlëë ‑ya, kö ‑wa ‑nu ꞊tua bho ‑së ꞊dede 'ka, \"ɛɛn 'zü kö ‑wo ‑yɛa ꞊bhlëësü ꞊në‑ nu wo ‑dhɛ ‑dhɔkëdhɛ kë ‑dhɛ ‑nu waa‑ Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü, \"kɛɛ 'sa kö wo ꞊në 'wo ꞊gɛandhe ‑nu ‑ta ‑bhö ‑sü ‑gɔ ‑bha. ‑A kë 'wo‑ wo sië \"dhʋ̈ bha, Atanna ‑dho 'wɔn bho‑ ‑nu 'gü 'ö ‑ziö mɛ ꞊gban ‑bha ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","꞊Dhɛ 'ö ö bo dhiang ‑nu bha‑ ‑nu zë ‑sü 'ka, 'yö dho 'ö ‑ya 'wëëga 'wo‑ ꞊gbaɔ Atanna ‑gɔ ‑a ‑dagüpë 'ö Atanna ‑dhɔkëgükɔ 'gü mü bha‑ \"tʋ̈ng 'gü ꞊dhɛ ꞊dede 'gü. 'Yö zun 'wɔn 'suan‑ bho ‑sü bha kö gbaɔ‑ 'ö 'mɛ 'wo gun mü bha 'wo‑ wo sië‑ Atanna ‑gɔ bha 'ö‑ ‑dhɛ yö ‑së 'ka. ꞊Naɔmɛ 'gbɛ ‑wo ‑gun mü 'ö 'wo gun‑ ‑da sië mü wɛɛ\" wɛɛdhö ");
INSERT INTO daf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","‑Yö ‑to ‑a ‑dhɛ ‑ga ‑dhɛ 'gü, 'yö ꞊gɛandhe \"flɛɛsü 'në 'bha bha 'ö nu, 'yö 'wëë‑ \"puu ga 'ö‑ ꞊bhlëë 'yaa ꞊mɔɔ 'wëëga do ‑zian ‑bha bha‑ ga ꞊plɛ ‑da 'pë bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","꞊Dhɛ 'ö Yesu ‑ya ‑dhɛ yö, 'yö ö ‑bha ꞊klang ‑nu ‑dhɛ 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka ‑dhɛ ‑ga, a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ꞊gɛandhe ya 'pë 'ö‑ ꞊gbaɔ Atanna ‑gɔ ya ‑yö 'kpii‑ 'ö ‑ziö mɛ \"pɛpɛ 'ö ꞊wa pë ꞊gbaɔ Atanna ‑gɔ ꞊dɛɛ ‑a ‑nu ꞊gban ‑bha ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'wo bha‑ ꞊gban \"pɛpɛ ‑wo ꞊naɔ ‑yaan ꞊në‑ kë sië, ‑a ‑nu ‑kɔ ‑kë ‑a ‑nu 'kën ‑gu ‑ta ‑sü ‑wɔn 'gü, \"kɛɛ dhebhɔnë 'kö ya, 'pë 'ö ꞊ya gun ꞊ya 'to‑ ‑gɔ ‑a ‑bha pë ꞊gban ‑pë ꞊gban 'ka ꞊në 'ö‑ nu bha.» ");
INSERT INTO daf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","꞊Dhɛ 'ö Yesu ‑yö ö bo dhiang ‑nu bha‑ ‑nu zë ‑sü 'ka, 'ö go Atanna ‑dhɔkëgükɔ bha‑ 'gü 'ö zun \"kpɛnng, 'yö‑ ‑bha ꞊klang ‑nu bha‑ mɛ do ‑yö ꞊yɔɔn‑ \"sɔɔ 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ, ‑bhö 'kɔ ya‑ ‑ga ꞊zɔɔ, ‑gwë suu ‑nu 'wo‑ dɔ‑ 'ka bha ‑bhö ‑a ‑ga kö 'i‑ ‑kë 'kpii‑ ‑kɔ waa‑ dhi ‑kɔ ‑nu bha‑ ‑ga.» ");
INSERT INTO daf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Kɔ suu ‑nu 'wo dɔ bha i \"yan ‑ya ‑nu ‑bha ‑ee? ‑A ‑gwë ‑nu 'i‑ ‑ga sië bha‑ 'bha 'yii 'dho 'to 'ko ‑ta \"dhʋ̈ng 'gü, ‑a ꞊gban ‑dho 'wü 'ö wü trëntrëndhö.» ");
INSERT INTO daf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","꞊Dhɛ 'ö ö bo dhiang bha‑ ‑yɔ bɔ ‑sü 'ka, 'yö dho 'ö ‑ya ‑tɔn 'wo Odhivie ‑tɔn ‑kë bha‑ ꞊gbin‑, Atanna ‑dhɔkëgükɔ bha‑ wëëdhɛ ꞊dede 'gü. 'Yö‑ ‑bha ꞊klang ‑nu bha‑ mɛ 'dhɛ 'wo‑ Piɛdhö ‑kë bha oo, Zakö oo, Zan oo, Andre oo, 'wo‑ dhɛɛ\" kpɔ ꞊plɛ 'gü 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«'Wɔn 'i go‑ pö yi ‑dhɛ ya, ‑yö ‑dho kë \"dhʋ̈ ‑më \"tʋ̈ng 'gü? \"Ɛɛn 'zü ‑a kë \"tʋ̈ng ꞊ya ꞊loo yi ‑dho ‑a 'suan‑ bho ‑më ‑wɔn waa‑ ‑më ‑wɔn ‑nu ꞊në‑ ‑bha?» ");
INSERT INTO daf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","꞊Dhɛ 'wo dhɛɛ\" bha‑ kpɔ \"dhʋ̈, 'yö zun dhiang ‑zë ‑a ‑nu ‑dhɛ ‑sü ‑bha 'ö‑ pö: «‑Ka ka ‑dɩ 'kun ‑së kö 'wa 'dho \"kpënng‑ kë ka ‑gɔ, ");
INSERT INTO daf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","‑a ‑gɛn ‑mü ꞊dhɛ mɛ 'gbɛ‑ ‑dho nu n 'tɔ 'gü, 'ö 'wo‑ pö wo ꞊në 'wo n 'ka. 'Ö 'wo mɛ 'gbɛ ꞊dede bho Atanna ‑bha zian ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","\"Tʋ̈ng 'ö ka dho‑ ma‑ 'ka ꞊dhɛ \"sɛ 'ö ꞊ni waa‑ \"sɛ 'ö ꞊ni ‑wo ‑gblü gɔɔn sië, \"ɛɛn 'ö‑ gɔn ‑taɔng ‑nu dho ‑da 'ka ka \"tʋʋdhö ka \"sɔɔ, \"ɛɛn 'zü ka 'ka ꞊gblɛɛn bha ka \"gblʋ̈ʋ̈dhɛ 'ya 'dho \"muu bho, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ 'wɔn 'ö dho kë 'ö 'yii 'dho 'to‑ 'gü yö ‑mü, \"kɛɛ yö ‑zë 'yii 'dho kë \"kpʋngtaadhɛ \"dhiʋ̈toyi 'ka. ");
INSERT INTO daf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","\"Sɛgɔ 'bha‑ ‑dho \"wlü 'ö dho 'ö ‑pö \"sɛgɔ 'bha ‑ta, 'ö ‑gblüdë 'bha ‑yö ꞊wlü, 'ö dho 'ö ‑gblü ‑da ‑gblüdë bha ‑ta, 'ö \"sɛ 'dhö ꞊zii ‑nu wo ‑dhɛ ‑nu 'gü 'ka‑ ma, 'ö \"vʋ̈ʋ̈ 'dhö ‑da ‑dhɛ ‑nu 'gü, \"kɛɛ yö ‑zë ꞊gban‑ ‑dho kë ꞊dhɛ 'nëkpɔdhe ‑bha \"gblü kë zübhosü ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‑Ka ka ‑zʋ 'kpɔ ka ‑dɩ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑wo ‑dho 'dho ka 'ka za ꞊gblü \"dhiʋ̈ ‑dhɛ ‑nu 'gü, 'ö 'wo ka ‑ma Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü, 'ö 'wo dho ka 'ka \"sɛdë ‑nu ‑kuu \"dhiʋ̈, 'ö 'wo dho ka 'ka ‑gblüdë ‑nu ‑kuu \"dhiʋ̈ ka ‑bha ‑kë n ‑bha 'ka ‑sü ‑wɔn 'gü, kë \"dhʋ̈ kö 'ka kë n \"sɛɛ‑ 'ka ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","꞊Ya 'go yö ‑zë 'gü, Atanna ‑bha naɔ ‑së bha 'yii \"kpʋngtaadhɛ zun 'ko \"dhiʋ̈ ꞊kö, \"kpʋngtaadhɛ \"dhiʋ̈ 'yii 'dho 'to. ‑A ‑dhɛa ‑bha ꞊dhɛ \"sɛ ꞊gban \"pɛpɛ 'gü ‑mɛ ‑nu ‑wa ma. ");
INSERT INTO daf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","\"Tʋ̈ng 'a \"wɩ sië 'ka bha ꞊ya ꞊loo, ꞊wa ka 'kun kö ‑wo 'dho ka 'ka \"sɛdë ‑nu waa‑ ‑gblüdë ‑nu ‑kuu \"dhiʋ̈ n ‑wɔn 'gü, dhiang 'ö kaa‑ zë mü ‑a \"sika 'ya 'dho kë ka 'gü, ‑a 'dhɛ 'ö dho nu ka zuë\" \"piʋ̈‑ \"tʋ̈ng ꞊dede bha‑ 'gü bha ‑kaa pö, ‑a ‑gɛn ‑mü ꞊dhɛ 'yii 'dho 'go kaa ꞊dede ka 'gü, Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ö ka 'gü bha ꞊në dho‑ dɔ ka \"dhi. ");
INSERT INTO daf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","‑A \"tʋ̈ng bha ꞊ya ꞊loo, 'në waa‑ ꞊dhoo ‑wo ‑dho wo 'ko \"dhiʋ̈ dɔ ga ‑gɔ, 'ö 'në dë ‑yö ö gbö \"ɛɛn ö 'dhu \"dhiʋ̈ dɔ, 'ö 'në ‑nu ‑wo ꞊wlü wo 'kpɔmɛ ‑nu \"piʋ̈ 'wo‑ ‑nu \"dhiʋ̈ dɔ 'wo‑ ‑nu zë. ");
INSERT INTO daf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ka ‑san ‑dho mɛ ꞊gban \"pɛpɛ kë ka ‑bha ‑kë n ‑bha 'ka ‑sü ‑wɔn 'gü, \"kɛɛ 'mɛ 'ö 'yii ö bo n 'ka, 'mɛ 'ö yaa ‑to ‑kplü ‑sü 'ka n ‑wɔn ‑bha \"dhʋ̈ kö‑ 'to‑ 'ka \"dhʋ̈ ‑yö ꞊loo‑ 'ka ‑a \"dhiʋ̈yadhɛ 'gü, ‑a ‑mɛ ‑dho dha.» ");
INSERT INTO daf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","'Yö go mü 'ö‑ pö: «‑A \"tʋ̈ng bha ꞊ya ꞊loo, ka ‑dho 'pë 'wo‑ ‑dhɛ Atanna ꞊bhlëësiöpë 'yaa ‑yënngyënngsü, 'ö dho zë‑ ‑wɔn ‑dhɛ 'ö bo ö ‑bha 'kɔ 'ka bha‑ yö kö ‑yö ‑ya ‑sü 'ka ‑a ‑dhɔkëgükɔ 'gü ‑dhɛ 'ö 'yaa‑ ‑yɛa 'ka bha‑ 'gü. ('Yö Makö ‑ya pö: «A‑ ‑pö \"dhʋ̈ kö 'mɛ 'ö 'sëëdhɛ ya‑ ‑wʋ pö sië ‑ya pö ö 'suan‑ 'ka.») 'Ka‑ ‑dhɛ yö \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü, 'mɛ 'ka dho kë Zude ‑sɛ 'gü, ‑ka ꞊dua 'ka 'dho ‑tɔn ‑gbeng 'gü ‑dhɛ ‑nu 'gü 'ka ka ‑gblɛn 'kpɔ mü. ");
INSERT INTO daf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","'Mɛ 'ö yaa‑ ‑kë 'zü \"kpɛnng, 'ya 'dho‑ pö ö ‑dɩ ‑dhɛ ꞊dhɛ 'ö 'dho pë 'bha 'sü ö ‑gɔ 'kɔɔdhö kö 'ö gun ‑na ziö ‑bɛang 'ka. ");
INSERT INTO daf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Mɛ 'ö yaa‑ ‑kë 'zü 'bhlaa‑, 'ya 'dho‑ pö 'ö ö yee kë kö 'ö nu ö ‑bha \"bhɛɛ 'sü ‑dhɛ 'gü 'pödhö, ");
INSERT INTO daf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","\"kɛɛ dhebhɔ ‑nu 'kö waa‑ ‑kë 'gbiö‑ \"tʋ̈ng bha‑ 'gü, \"ɛɛn 'ö 'në yaa‑ ‑kë ‑nu ‑gɔ 'yɔn ‑bha, wo ‑zë ‑a ‑nu ‑bha ‑dho kë ‑wëësü ꞊dedewo! ");
INSERT INTO daf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","‑Ka bhɛa\" Atanna ‑dhɛ kö 'wɔn bha 'ya 'dho kë \"dhʋ̈ \"nɛnɛ yi 'ka, ");
INSERT INTO daf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn 'ö dho kë \"tʋ̈ng bha‑ 'gü bha, ‑a ‑bha ‑kë ‑wëësü ‑sü ‑dhiang ‑zian 'yaa zë. Atanna 'dhö \"kpʋngtaadhɛ ‑da \"dhʋ̈ yi bha‑ 'ka, ‑a ‑wëëwɔn suu 'ö \"dhʋ̈ 'yii kë do, \"ɛɛn ‑a \"sinma 'yii 'dho kë 'zü 'ö to‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","꞊Ya kë ꞊dhɛ ‑dhɛkpaɔyi 'ö \"dhʋ̈ bha Atanna 'yii‑ 'bha \"kan‑ \"dhiʋ̈ 'nu, kö dhamɛ ‑zian 'yii 'dho ꞊slɔɔ, \"kɛɛ ꞊yaa‑ 'bha \"kan‑ \"dhiʋ̈ 'mɛ 'ö‑ ‑nu ‑ya ‑dɩ ‑ta ö ‑bha 'ka bha‑ ‑nu ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‑A ‑kë \"dhʋ̈ ‑sü 'gü, ꞊waa‑ pö ka ‑dhɛ ꞊dhɛ Klisi ꞊ya nu, ‑yö ‑dhɛ 'ö ya‑ 'gü, \"ɛɛn ‑yö ‑dhɛ 'ö ꞊ni‑ 'gü, 'ya 'dho bhɔ ka 'gü tɛan‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","‑A ‑gɛn ‑mü ꞊dhɛ ‑dɩ ‑kë Klisi 'ka ‑mɛ ‑nu waa‑ Atanna ‑wʋdhiʋ̈loomɛ ꞊flü ‑sü ‑nu 'gbɛ‑ ‑dho \"wlü \"tʋ̈ng bha‑ 'gü, 'ö 'wo \"slë ‑nu waa‑ \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu ‑kë, kë \"dhʋ̈ kö ‑wo 'mɛ 'ö Atanna ‑ya ‑nu ‑ya 'ö 'wo bɔ‑ 'ka bha‑ ‑nu bho‑ ‑bha zian ‑ta \"ni kö‑ ‑nu faan ‑zë ꞊ya ꞊mɔɔ‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","‑A ꞊gban 'to 'a‑ wo \"dhiʋ̈ 'a‑ pö ka ‑dhɛ bha a‑ ‑kë \"dhʋ̈ kö 'ka ‑ya ꞊në‑ wo ka 'suan‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö go mü 'ö‑ pö: «'Wɔn \"nɛnɛgasü 'a‑ ‑dhiang zë ka ‑dhɛ bha yö ꞊në ꞊ya bo kë ‑sü 'ka kö ‑a ‑dhɛkpaɔyi ‑yö zun 'ko \"dhiʋ̈, 'yö 'yënng‑ ‑gɔ 'dho ꞊tröö, 'yö \"su ‑dɩ 'pö 'ö bo 'bhü ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","'Yö \"susëngga ‑nu 'wo go dhang‑ ‑bha 'wo ꞊wɛnng, 'yö pë ‑ziisü ‑ziisü ‑nu 'wo dhang‑ 'gü ‑a ‑nu ꞊gban 'wo go \"glʋʋ. ");
INSERT INTO daf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","'Yö 'wo gun ‑na mang Mɛgbömɛ n yö kö a nu sië dha 'kpong‑ ‑ta ma ‑gblüdëdhɛ ‑faan waa‑ 'gü 'tɔbhɔdhe bha‑ 'ka ‑yɛɛdhö. ");
INSERT INTO daf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'Yö 'a gun ‑na ma \"kië ‑nu bɔ \"kpʋngtaadhɛ ꞊gban \"pɛpɛ 'gü kö ‑wo 'mɛ 'wo bɔ n 'ka 'ö Atanna ‑ya ‑nu ‑ya bha‑ ‑nu ꞊loo 'ko ‑ta ‑dhɛ do 'gü. ");
INSERT INTO daf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","꞊Dhɛ 'ö ö bo, 'yö‑ pö 'wɔn ‑nu bha‑ ‑nu 'suan‑ ‑bho ‑bha ‑pë 'a dho‑ ‑zɔn ka ‑dhɛ yö ‑mü figö ‑dhü ꞊në‑ 'ka, 'ka \"dhü bha‑ yö, kö ‑yö ö ‑trɔng ‑dee \"pʋ sië kö 'ka 'to 'ka‑ 'wɔn dɔ ꞊dhɛ ‑a bhɛ dɔ \"tʋ̈ng ꞊ya ꞊loo ꞊gban wo. ");
INSERT INTO daf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","꞊Ya kë ꞊dhɛ 'ka 'wɔn ‑nu 'a‑ ‑dhiang zë ka ‑dhɛ bha‑ kë ‑dhɛ yö 'pö ꞊dhɛ ‑kɔ bha‑ 'dhö, kö ‑yö kë ka \"yaan ꞊dhɛ n nu \"tʋ̈ng ꞊ya ꞊loo, ꞊dhɛ 'ma dɔ \"kpan \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'wo ‑tosɛa kë sië dɔ ‑kɔ ya‑ 'gü ya, ‑a ‑nu ꞊gban 'wii 'dho ga kö 'pë 'a‑ pö bha‑ ꞊gban 'yii kë ꞊kö. ");
INSERT INTO daf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","‑Yö kë ka \"yaan ꞊dhɛ \"sɛ waa‑ dhang‑ ‑wo ‑dho ziö, \"kɛɛ n ‑wʋ 'yii 'dho go \"gblʋʋ tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö‑ ‑ta yɔ‑ ‑nu ‑dhɛ 'ö‑ pö: «N nu ‑yi ‑zë mɛ 'bhaa‑ dɔ waa‑ n nu \"tʋ̈ng ꞊dede 'dhö kö 'yii kë n Dë Atanna ‑zë 'ka, mang ꞊dede ‑zian 'a‑ gbö 'ka ya 'maa‑ dɔ kö yöö ‑nu 'to‑ ‑bha \"kië ‑nu ꞊në‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","꞊Dhɛ 'ö \"dhʋ̈, ‑ka ‑ya ka \"yaan kö 'ka bhɛa\" kö 'ka ka \"tʋ̈ng kë 'wɔn ‑nu 'a‑ pö ka ‑dhɛ bha‑ ‑nu 'gü kö ‑wo 'to ka \"yaan. ‑A ‑gɛn ‑mü ꞊dhɛ 'kaa yi 'ö bha‑ ꞊loo \"tʋ̈ng dɔ. ");
INSERT INTO daf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","‑Yö ‑dho kë ꞊dhɛ gɔndënë do 'ö dho \"ta 'gü ꞊në‑ 'dhö. ꞊Dhɛ 'ö yöö 'dho, 'yö ö ‑bha 'kɔ to, 'yö ö ‑wʋ kpɔ ö ‑bha gwëëzë ‑nu ‑bha, 'yö‑ pö 'kɔ ‑maakëmɛ ‑dhɛ ‑yö ö ‑zʋ kë 'kɔ bha‑ 'gü kö ‑ya ‑maa kë, 'ya 'dho yi zë. ");
INSERT INTO daf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kaa ‑dɩ 'pö, ‑ka ‑ya ka \"yaan ‑kɔ do bha‑ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'kaa ka Dëmɛ nu \"tʋ̈ng dɔ, kö ‑yö ‑dho nu yɛan\" \"piʋ̈ ‑ee? Kö ‑yö ‑dho nu gbeng ꞊zinng 'gü ‑ee? Kö ‑yö ‑dho nu ‑dhɛkpaɔ \"dhiʋ̈ ‑ee? \"Ɛɛn kö ‑yö ‑dho nu dhia\" \"piʋ̈ ‑ee? Kaa‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","꞊Dhɛ 'ö ‑kë ꞊dhɛ ‑yö ‑dho \"kan ꞊në‑ wo ka 'gü bha, ‑ka kë ka 'suan‑ 'ka kö 'ya 'dho ‑kpan ka ‑bha kö ka yi 'gü. ");
INSERT INTO daf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","(‑Gɔngɔɔnmɛ ‑nu ‑bha ‑dhio ‑yö do), 'ma‑ pö ka ‑dhɛ \"dhʋ̈ kö mɛ ꞊gban \"pɛpɛ ꞊në 'a‑ ‑nu ‑bha dhiang zë bha do, ‑ka ‑ya ka \"yaan!» ");
INSERT INTO daf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","꞊Dhɛ 'ö ‑dhɛkpaɔyi ꞊ya 'to ꞊plɛ kö Pakö troo waa‑ 'bluu‑ 'ö \"sɛkɛ 'yaa‑ ‑bha ‑a ‑bhö ‑yi ‑yö ꞊loo, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu 'wo zun‑ \"slë mɔɔ‑ ‑sü ‑bha kö 'wo \"kpënng‑ kë Yesu ‑gɔ 'wo‑ 'kun ‑suɛɛdhö 'wo‑ zë. ");
INSERT INTO daf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","‑A 'klɔɔ‑ ‑mü ꞊dhɛ kö ‑wa pö sië ꞊dhɛ ꞊ya kë troo yi ꞊dede 'ka wo ‑kɔ 'yii 'dho ꞊mɔɔ‑ ‑bha kö 'wo‑ 'kun, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊ya kë \"dhʋ̈ \"sɛgümɛ ‑nu ‑dho \"wlü wo \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","'Ö gun kö Yesu ‑yö Simɔ 'ö go Betani 'ö ꞊wee ‑yua gun‑ ‑bha bha‑ ‑gɔ 'kɔɔdhö Betani, 'yö dhebhɔ do ‑yö ‑da 'kɔɔdhö, ‑a \"tʋ̈ng bha‑ 'ka kö ‑wo pë ‑bhö sië. 'Ö ‑da 'kɔɔdhö kö ‑dhasiklɔɔ \"yi sɔng \"gbɩɩ‑ 'wo‑ ‑pë ‑kë \"dhü 'wo‑ naadhö ‑kë bha‑ yun 'ka bha, ‑yö ‑gwë \"puu ‑sangdhe do pa ‑sü 'ka kö ‑ya ‑gɔ. ꞊Dhɛ 'ö ‑da 'kɔɔdhö, 'yö ‑sangdhe bha‑ ‑gɔ bho‑ \"dhiʋ̈, 'yö ‑dhasiklɔɔ \"yi 'ö gun‑ 'gü bha‑ ꞊wɛnng Yesu ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","‑A kë 'ö‑ wo \"dhʋ̈ bha 'yii dhi 'mɛ 'wo gun mü bha‑ mɛ 'bha ‑nu ‑dhɛ, 'yö 'wo‑ pö: «'Yö ‑dhasiklɔɔ sɔng \"gbɩɩ‑ suu 'kö ya‑ ‑see ꞊ni ‑gɛn ‑mü ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","꞊Ya kë 'nu ꞊dhɛ ‑a \"dhɔɔ ꞊në 'kwa‑ dɔ, ‑yö ‑mɔɔ ‑bha 'nu 'ö 'wëë‑ 'kpii‑ ꞊dede ꞊slɔɔ, 'yö 'wëëga 'kö bha 'kwa‑ 'gü ‑gblü \"flɛɛmɛ ‑nu ‑ta, (\"kɛɛ yö ꞊në ꞊waa‑ ꞊gban see‑ bha!)» 'Yö 'wo zun ‑dɔn bho ‑sü bha dhebhɔ bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","\"Kɛɛ 'yö Yesu ‑ya pö: «‑Ka ka kwaa dhebhɔ bha‑ ‑zü. Ka‑ ‑din ‑yën ‑më ‑wɔn 'gü? ꞊Ya ö ‑bha 'wɔn ‑së ꞊në kë n ‑dhɛ bha, ");
INSERT INTO daf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","‑a ‑gɛn ‑mü ꞊dhɛ \"flɛɛmɛ ‑nu ‑zë ‑wo ‑dho kë ka \"piʋ̈ \"kpʋng ꞊taa yi ꞊gban 'ka, 'wɔn ‑së ‑kë ‑a ‑nu ‑dhɛ ‑wɔn ꞊ya ga ka 'gü \"tʋ̈ng \"ʋʋ \"tʋ̈ng 'ö‑ 'gü ka ‑mɔɔ ‑bha 'ka‑ ‑kë ‑a ‑nu ‑dhɛ, \"kɛɛ ma ‑zë, 'mii 'dho kë ka \"piʋ̈ yö yi ꞊gban 'ka, 'ö \"dhʋ̈ kö ‑a \"tʋ̈ng ꞊në ‑tun ya kö 'ka‑ ‑zɔn n ‑dhɛ ꞊dhɛ n ‑dhɔ ‑yö ka ‑kë. ");
INSERT INTO daf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dhebhɔ bha‑ ‑bha 'ö‑ ‑kɔ ꞊mɔɔ‑ ‑bha 'yö‑ kë bha. ‑Dhasiklɔɔ \"yi 'ö yöö‑ ꞊wɛnng n ꞊gee ‑bha 'nu kö ‑wo n ‑wɛɛ bho‑ 'ka bha ꞊në 'ö‑ yi to \"dhiʋ̈ 'yö ꞊wɛnng n ‑ta bha. ");
INSERT INTO daf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'wɔn 'ö dhebhɔnë ya 'ö‑ ‑kë bha, 'wo dho Atanna ‑bha naɔ ‑së ya‑ dɔ ‑dhɛ \"ʋʋ ‑dhɛ 'ö‑ 'gü \"kpʋng ꞊taa, ‑wo ‑dho ‑a ‑dhiang zë mü 'pö kö mɛ 'bha ‑zʋ 'ya 'dho bhɔ‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Zuda Isikadhiɔtö 'ö ‑kë ‑a ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ ‑mɛ do 'ka bha, 'ö ꞊wlü 'ö dho \"saabhomɛ ‑nu ‑gɔmɛ ‑nu \"piʋ̈, kö 'ö Yesu \"dhiʋ̈ dɔ‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","꞊Dhɛ 'ö dho 'ö ö \"kplëng bho ‑a ‑nu ‑dhɛ, 'yö‑ 'gü ‑wɔn ‑yö ‑dhi ‑a ‑nu ‑dhɛ ꞊dedewo, 'yö 'wo \"plüün bho‑ ‑dhɛ 'wo‑ pö wo ‑dho ‑a gba 'wëë‑ 'ka. ꞊Dhɛ 'ö Zuda ‑yö go mü, 'yö zun \"tʋ̈ng ‑së 'ö‑ ‑kɔ dho ꞊mɔɔ‑ 'ka‑ ‑bha kö ‑ya \"dhiʋ̈ dɔ‑ 'ka ‑a ‑nu ‑dhɛ bha‑ mɔɔ‑ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","꞊Dhɛ 'ö troo 'ö 'wo 'bluu‑ 'ö \"sɛkɛ 'yaa‑ ‑bha ‑a ‑bhö ‑ta bha‑ yi ‑blɛɛsü 'ö‑ yi ꞊bhlëësü ꞊dede 'ka, 'ö ‑tuʋ̈ ‑zian 'wo dho‑ zë troo 'ö‑ ‑nu ‑zʋ ‑da ‑a ‑nu \"bhɛma ‑nu ‑go Ezitö ‑yi ‑ta, 'wo‑ Pakö ‑kë bha‑ zë‑ 'ka bha ꞊ya ꞊loo, 'yö‑ ‑bha ꞊klang ‑nu bha 'wo‑ pö‑ ‑dhɛ: «‑Dhɛ ‑mɛɛ ꞊në i \"piʋ̈ ꞊dhɛ 'yi 'dho‑ ‑bha kö 'yi i ‑bha Pakö ‑pë ‑kpa mü, yi Dëmɛ?» ");
INSERT INTO daf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","'Yö ö ‑bha ꞊klang ‑nu bha‑ mɛ ꞊plɛ bɔ, 'yö ö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: «‑Ka 'dho Zedhizadhɛmö, 'ka 'dho ka ‑dho ‑kpan gɔndë do 'bha ‑bha kö \"yipë ‑ya ‑gɔ, 'ka‑ yö ‑ka ziö‑ ꞊keng‑, ");
INSERT INTO daf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'ka 'dho, yaa‑ ‑da 'kɔ 'ö‑ 'gü bha, ‑kaa pö‑ 'kɔ bha‑ dëmɛ ‑dhɛ ꞊dhɛ: ‹Yi dëmɛ ‑ya ‑pö 'yi nu kö 'yi i dhɛɛ\" 'kpɔ kö 'kɔdhi 'ö waa‑ ö ‑bha ꞊klang ‑nu wo dho Pakö ‑bhöpë ‑bhö 'gü bha 'i‑ ‑zɔn yi ‑dhɛ.› ");
INSERT INTO daf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","'Ka‑ pö \"dhʋ̈, ‑yö ‑dho 'kɔ 'gü 'bong ‑bong do, 'ö‑ 'güdhɛ ꞊gban 'dhö ‑pë kë ‑sü 'ka ‑së 'ka, 'ö ‑yatapë ꞊gban 'dhö mü ‑a ‑dhɛ ‑zɔn ka ‑dhɛ 'kɔ ‑ta \"dhʋ̈ng 'gü. ‑Dhɛ bha ꞊në 'ka dho kwa ‑bha Pakö ‑pë ‑kpa ‑a 'gü.» ");
INSERT INTO daf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","'Yö‑ ‑bha ꞊klang ‑nu ꞊plɛ bha 'wo dho. 'Yö 'wo ‑kpan ‑bha ꞊dhɛ ‑kɔ do 'ö‑ pö‑ 'ka ‑a ‑nu ‑dhɛ bha‑ 'dhö. 'Yö 'wo Pakö ‑pë ‑kpa mü. ꞊Dhɛ 'wo wo bo, 'yö 'wo wo yee ‑kë 'wo dho‑ ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","꞊Dhɛ 'ö ꞊wa ꞊gloo mü 'ö \"bin ꞊ya 'ma, 'yö waa‑ ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha 'wo ꞊loo Pakö ‑pë ‑bhö ‑dhɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","꞊Dhɛ 'wo ꞊klëën ‑bhöpë bha‑ ‑zü, 'ö 'wo‑ ‑bhö ‑sü zü bho ‑së 'ka, 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Kwa‑ ‑bha ‑zë wo, \"kɛɛ tɛanwɔn do 'bha‑ ‑dhö 'a dho‑ pö ka ‑dhɛ. Yö ‑mü ꞊dhɛ 'mɛ 'ö kwɛng‑ ‑nu kwa ‑kɔ 'dhö 'tɛa‑ do 'gü ya, mɛ do‑ ‑dho n \"dhiʋ̈ dɔ n 'yaɔ‑ ‑nu ‑gɔ ");
INSERT INTO daf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","‑A pö 'ö‑ wo \"dhʋ̈ bha, 'yö‑ ‑nu \"gblʋ̈ʋ̈dhɛ \"muu bho, 'yö ‑wëë ‑yö zun ‑da ‑sü ‑bha ‑a ‑nu ‑ta, ‑a ‑gɛn ‑mü ꞊dhɛ 'yaa gun‑ ‑nu \"piʋ̈ ꞊dhɛ 'wɔn suu bha ‑yö kë Yesu 'ka. 'Yö 'mɛ 'ö \"dhʋ̈ 'ö zun‑ dhɛɛ\" 'kpɔ ‑sü ‑bha 'ö‑ pö: «‑A ‑ga 'i‑ wo bha ꞊wɛ, n Dëmɛ, ‑yö i 'gü ꞊dhɛ ma ‑mü ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Mɛ ‑kaɔng do ga ꞊plɛ 'ka bha mɛ do ‑mü. Mɛ 'dhɛ yɛng yi ‑kɔ 'dhö 'tɛa‑ do 'gü bha yö ‑mü.» ");
INSERT INTO daf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","'Yö go mü 'ö‑ pö: «‑Yö \"dhʋ̈ tɛan‑ 'ka ꞊dhɛ mang Mɛgbömɛ n ga ‑wɔn ‑yö ‑dhö ꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka‑ 'ka Atanna ‑gɔ 'sëëdhɛ 'gü‑ 'dhö, \"kɛɛ 'mɛ 'ö dho kë ‑a ‑gbɔ ‑dɔ ö ‑dɩ ꞊gbin‑ ‑mɛ 'ka bha ꞊në‑ ‑mɛ ‑bha 'dhö ‑wëësü. ‑A fië‑ ‑dhö ‑zianwo 'nu kö‑ ‑mɛ 'ya 'dho bhɔ.» ");
INSERT INTO daf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","'Wo gun pë ‑bhö sië, 'yö Yesu ‑yö 'bluu‑ sü, 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü, ꞊dhɛ 'ö ö bo, 'yö‑ \"kplü \"kplü bho, 'yö‑ 'gü ‑gblü ö ‑bha ꞊klang ‑nu ‑ta, 'yö‑ pö‑ ‑nu ‑dhɛ: «N kwi \"blɛɛn‑ ꞊nɛ, ‑kaa 'kun 'ka‑ ‑bhö.» ");
INSERT INTO daf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","'Yö go mü 'zü 'ö we ‑kɔɔ sü, 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü, ꞊dhɛ 'ö ö bo, 'yö‑ nu‑ ‑nu ‑dhɛ, 'yö‑ ‑nu ꞊gban 'wo‑ mü. ");
INSERT INTO daf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","'Yö‑ pö‑ ‑nu ‑dhɛ: «N ꞊yɔɔn 'ö yöö ‑wɛnng kö ‑yö kë ‑mlɛɛ ‑dee 'ö maa‑ ‑da n Dë Atanna waa‑ mɛ kpö 'gbɛ ‑a ‑nu ꞊zinng 'gü kö ‑ya ‑nu ‑kɔ ‑da 'ko ꞊kwɛng bha‑ \"blɛɛn‑ ꞊nɛ.» ");
INSERT INTO daf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ꞊Ya 'go ꞊dɛɛ 'gü, 'mii 'dho ‑drɔɔ mü 'ö dho 'ö zun‑ 'ka yi 'a dho‑ ‑dee mü‑ 'ka Atanna ‑bha ‑gblüdëdhɛpö 'gü bha‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","꞊Dhɛ 'wo wo bo 'yö 'wo Pakö \"tan ‑nu bho, 'yö 'wo ‑ziö 'wo dho Odhivie ‑tɔn ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","꞊Dhɛ 'wo dho 'wo ꞊loo mü 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «Mɛ \"pɛpɛ 'ka bha mɛ ꞊gban ka ‑dho \"kan n ‑zü 'kwëë‑, 'ö 'ka ꞊dua. ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü ꞊dhɛ: A ‑dho ‑tuʋ̈ ‑maagɔmɛ zë, 'yö‑ ‑bha ‑tuʋ̈ ‑nu 'wo dɔ bunnggɛɛdhö. ");
INSERT INTO daf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","\"Kɛɛ ꞊wa n zë \"dhʋ̈, a ‑dho ‑bö 'zü ‑deewo. ꞊Ya kë ꞊dhɛ 'ma bo ‑bö ‑sü 'ka, a ‑dho ‑da ka \"dhiʋ̈ 'a dho Gadhidhe ‑sɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö Piɛdhö ‑ya pö‑ ‑dhɛ: «(N Dëmɛ,) 'kö 'zü mɛ ꞊gban \"pɛpɛ ꞊wa bo i 'ka, \"kɛɛ ma ‑zë, 'mii 'dho bo i 'ka tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Piɛdhö, a‑ ‑pö i ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ bhii ꞊dede ‑zian 'i \"wɩ sië bha, gbeng do 'ö ꞊dɛɛ 'yii 'dho ziö kö 'wɔn 'a‑ pö bha 'bha‑ kë. ‑A ‑gɛn ‑mü ꞊dhɛ \"sanni ‑wa pö ‑tɔgɔn ꞊ya \"wɩ ꞊dhɛ pë ꞊plɛ 'dhö, kö 'bha bo n 'ka ‑gɛnyan 'ka ‑yaaga.» ");
INSERT INTO daf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","\"Kɛɛ 'yö Piɛdhö ‑ya zë 'zü ö ‑sɔbhɛɛ ꞊dede ‑bha 'ö‑ pö: «'Kö ꞊ya kë ga ‑zian ꞊në‑ 'ka, yi ‑dho ‑a wo yi \"kwëë, \"kɛɛ 'mii 'dho \"kan ‑zë wo i ‑bha tongtongdhö, n Dëmɛ.» 'Yö 'mɛ 'wo bha‑ ‑nu ꞊gban 'wo ‑wʋ do bha‑ pö. ");
INSERT INTO daf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Yö 'wo ‑ziö 'zü 'wo dho ‑dhɛ do 'bha 'wo‑ Zɛsemane ‑dhɛ ‑kë bha‑ 'gü. ꞊Dhɛ 'wo ꞊loo mü 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «‑Ka ‑ya n ‑gɔ yö kö 'a 'dho ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","'Yö Piɛdhö 'dhö, Zakö 'dhö, Zan 'dhö ‑a ‑nu ‑dhɛ, 'yö 'wo dho. \"Kɛɛ \"tʋ̈ng 'wo dho sië‑ 'ka \"dhʋ̈ bha, kö \"suʋ̈ ꞊ya ‑da ‑a 'gü, kö \"nɛnɛga ‑sɛa ꞊ya ‑ya bha ‑sü ‑bha ‑a ‑bha, kö ‑wëë ‑yö ‑da sië‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","'Yö‑ pö mɛ ‑yaaga bha‑ ‑nu ‑dhɛ 'ö‑ pö: «Ga ‑sü zii ꞊ya kpa n ‑ta, ꞊dhɛ 'ö \"dhʋ̈, ‑ka 'to yö, \"kɛɛ ‑ka ‑ya ka \"yaan 'ka 'dho yi zë.» ");
INSERT INTO daf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö ꞊yɔɔn 'dɛdɛ wo ö \"dhiʋ̈, 'yö ꞊kwaa ö ‑dɩ ‑zü \"sia‑, 'yö ꞊bhɛa Atanna ‑dhɛ kö ꞊ya kë ꞊dhɛ ꞊ya kë‑ ‑dhidhɛwɔn 'ka, kö \"tʋ̈ng bha ‑ya dɔ ö 'ka ꞊gblɛɛn. ");
INSERT INTO daf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","'Yö ꞊bhɛa 'ö‑ pö: «N Dë, bhi ꞊në i ‑fiëbhawɔn 'yaa 'dhö, ‑bhö dɔ \"gbɩɩ‑, \"ni kö ꞊ya kë i ‑dhidhɛwɔn ‑zë 'ka, kö 'wɔn \"gbɩɩ‑ 'ö maa‑ \"yi mü ya 'i‑ 'kpɔ n 'ka, \"kɛɛ yö ꞊në‑ ꞊gban 'gü, kö ‑yö ga bhi ꞊në i 'gü, kö 'ya 'dho kë ma ‑zë n ‑dhidhɛwɔn 'ka.» ");
INSERT INTO daf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","꞊Dhɛ 'ö ꞊bhɛa Atanna ‑dhɛ \"dhʋ̈ 'ö ö bo, 'yö ö yee ‑kë 'ö nu ö ‑bha ꞊klangdhiʋ̈ ‑nu ‑yaaga bha‑ ‑nu ‑dhɛ 'gü. 'Ö nu ‑yö ‑kpan ‑nu ‑bha kö ꞊wa yi zë. 'Yö pa‑ ‑nu ‑bha 'yö‑ pö Piɛdhö ‑dhɛ: «Simɔ, 'bha yi zë 'nu ‑wa! 'Aa, Piɛdhö, bhii ꞊mɔɔ‑ ‑bha kö 'i \"tʋ̈ng do ‑zian ‑to \"yaan kë ‑wa? ");
INSERT INTO daf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","‑Ka ‑ya ka \"yaan kö 'ka bhɛa\", kë \"dhʋ̈ kö Sɔtraan ‑bha \"kpënng‑ ‑kɔ 'ya 'dho ꞊mɔɔ ka ‑bha 'ö ka ‑da Atanna \"dhiʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ ‑to Atanna dhɔɔbhaa ‑zian ‑ta ‑dhɔ ‑yö kë mɛ \"bhɩɩ‑ ‑nu ‑bha, \"kɛɛ ‑a kë \"sɩ ꞊në 'yaa kë‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","'Yö ‑ziö 'zü ‑deewo 'ö dho ‑dhɛ do 'ö ꞊bhɛa Atanna ‑dhɛ ‑a 'gü ‑blɛɛsü bha‑ 'gü, 'yö ꞊bhɛa 'zü ꞊dhɛ ‑kɔ do 'ö ꞊bhɛa‑ 'ka ‑blɛɛsü bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","'Yö nu 'zü ‑deewo ö ‑bha ꞊klang ‑nu ‑dhɛ 'gü, 'ö nu ‑yö ‑kpan ‑a ‑nu ‑bha kö ꞊wa yi zë 'zü ‑deewo. ‑A ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö‑ ‑nu \"yankɔ ꞊gbaan kë 'gbiin‑ yi kaɔ. Woo dhiang 'ö‑ zë‑ ‑dhɛ 'wii‑ ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","'Yö ‑ziö 'zü ‑deewo 'ö dho. Nu ‑yaaga ‑naa 'ö‑ wo, 'yö pa‑ ‑nu ‑bha 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Yi ‑zian ꞊në 'ka‑ zë sië \"dhʋ̈ do ‑wa! ‑Yö 'to \"dhʋ̈! \"Tʋ̈ng 'a gun \"suʋ̈ sië‑ ‑gɔ ꞊ya ꞊loo ‑ya bo, ‑a ‑gɛn ‑mü ꞊dhɛ mang Mɛgbömɛ n \"dhiʋ̈ ‑dɔ 'wɔnyaakëmɛ ‑nu ‑dhɛ \"tʋ̈ng bha ꞊ya ꞊loo. ");
INSERT INTO daf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","‑Ka \"wlü 'kwa 'dho, 'mɛ 'ö yöö n \"dhiʋ̈ dɔ bha ꞊ya dun kwa ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dhiang bha ‑yö ‑to Yesu \"dhi, 'yö‑ ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ mɛ 'dhɛ 'wo Zuda ‑kë bha 'ö ‑wo, kö mɛ kpö 'kpii‑ 'ö ‑siang ‑nu waa‑ \"dhünë ‑nu 'wo‑ ‑nu ‑ta, 'ö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu oo, 'tɔnggɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha ‑kwɛagbö ‑nu 'wo‑ bɔ bha ‑wa ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yö ‑zë 'ö gun kë sië \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü bha kö Zuda 'ö dho‑ \"dhiʋ̈ dɔ‑ 'kunmɛ ‑nu ‑dhɛ bha ꞊ya ö ‑wʋ 'kpɔ 'mɛ wɛng‑ ‑nu 'wo nu sië bha‑ ‑nu ‑bha ꞊yaa‑ pö: «꞊Ya kë ꞊dhɛ 'kwa 'dho, 'mɛ 'a dho‑ ꞊loo‑ ‑bha bha kö 'mɛ 'a ‑wɩ 'ka bha 'yö bha, kö 'ka‑ 'kun 'ka 'dho‑ 'ka, \"kɛɛ 'ka‑ 'kun ‑së (kö 'ya 'dho dha ka ‑gɔ).» ");
INSERT INTO daf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","꞊Dhɛ 'wo nu 'wo ꞊loo‑ ‑nu ‑dhɛ 'gü, 'yö to 'ö dho Yesu ‑zian 'ka, 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ!» 'Yö‑ ꞊loo‑ ‑bha, ");
INSERT INTO daf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","'yö 'mɛ 'wo bha 'wo Yesu kun. ");
INSERT INTO daf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'Yö 'mɛ 'wo gun Yesu ꞊keng‑ bha‑ mɛ do ‑yö ‑kɔ ‑da ö ‑bha ‑siang 'gü, 'yö bho ö kwɛɛ\", 'yö \"saabhomɛ ‑gɔmɛ 'kpii‑ ‑bha gwëëmi zë‑ 'ka‑ ‑gɔ ‑bha, 'yö‑ \"tʋ kpö bho mü. ");
INSERT INTO daf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","'Yö Yesu ‑yö dhiang zë 'mɛ 'wo nu‑ 'kun bha‑ ‑nu ‑dhɛ 'ö‑ pö: «Nu 'ka‑ wo n 'kun ‑dhɛ 'gü ‑siang ‑nu waa‑ \"dhünë ‑nu 'ka ꞊dhɛ mɛ‑ dɔ mɛzëmɛ 'ka ya‑ ‑gɛn ‑mü ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ka \"yan 'yaa gun n ‑bha ka kpö 'gü yi ꞊gban \"pɛpɛ 'ka kö a mɛ ‑nu ꞊klang kë sië Atanna ‑dhɔkëgükɔ 'gü ‑dhɛ ya 'gü ‑ee? ‑Yö ‑kë ‑mü ꞊dhɛ 'yö 'kii n 'kun‑ \"tʋ̈ng 'dhɛ 'kö bha yö ‑zë 'bha 'gü? \"Kɛɛ 'yaa 'wɔn 'bha 'ka, ‑yö ‑kë \"dhʋ̈ kö 'pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑gɔ 'sëëdhɛ 'gü n ‑bu 'gü bha ꞊në‑ 'gü ‑wɔn ‑yö kë.» ");
INSERT INTO daf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'Ö bo kë ‑sü 'ka \"dhʋ̈, 'yö 'mɛ 'wo gun‑ ꞊keng‑ bha‑ ꞊gban 'wo ‑kan ‑zü 'kwëë‑ 'wo ꞊dua 'wo dho. ");
INSERT INTO daf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","'Nëglɔɔnnë do 'ö ‑kpata doseng ꞊në gun‑ gban \"dhiʋ̈ bha ‑yö ‑gun ꞊keng‑ kö ꞊waa‑ 'kun ‑wo 'dho sië‑ 'ka. 'Yö 'wo dho 'wo yöö ‑dɩ 'pö‑ kun. ");
INSERT INTO daf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","\"Kɛɛ 'yö yö ‑zë 'ö ö ‑bha ‑kpata bha‑ to‑ ‑nu ꞊kwɛɛ‑ 'yö ‑ziö ‑bɛang 'ka 'ö dho ö 'kpee‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","꞊Dhɛ 'wo Yesu kun, 'yö 'wo dho‑ 'ka \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ ‑kuu \"dhiʋ̈, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu \"pɛpɛ 'wo to oo, ‑kwɛagbö ‑nu waa‑ 'tɔnggɔmɛ ‑nu 'wo bho 'ko ‑ta ‑a ‑gɔ \"kwɛandhö mü. ");
INSERT INTO daf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","‑A ‑nu 'dho ‑sü 'ka kö Piɛdhö ‑ya ‑nu ꞊keng‑, \"kɛɛ 'yaa ꞊yɔɔn‑ ‑nu \"sɔɔ, 'yö 'wo dho 'wo ‑da 'ka \"kwɛandhɛ bha‑ 'gü. 'Yö Piɛdhö dho 'ö ‑ya pɛng ‑bha gwëëzë ‑nu \"sɔɔ, kö pɛng 'në 'bha ‑yö ‑ma ö bha kö \"nɛnɛ ‑yö go ö 'gü. ");
INSERT INTO daf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","'Yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu \"pɛpɛ bha waa‑ zagɔbhomɛ ‑nu 'wo nu bha 'wo zun 'wɔn do 'wo dho‑ ꞊slɔɔ Yesu ‑bha ‑tosɛa 'gü kö ‑yö kë‑ zë ‑gɛn 'ka ‑a mɔɔ‑ ‑sü ‑bha, \"kɛɛ 'yö 'wii‑ ꞊slɔɔ tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","‑A ‑gɛn ‑mü ꞊dhɛ mɛ 'gbɛ ꞊dede ‑wo nu 'wo ꞊sua ‑dhiang ‑nu zë‑ ‑bha, \"kɛɛ mɛ 'bha ꞊ya nu ꞊yaa‑ 'bha pö, mɛ 'dhɛ ꞊ya 'dho dɔ mɛ 'dhɛ bha‑ \"piʋ̈, ꞊ya nu 'yö‑ \"wɛɛ 'bha pö, 'yö‑ ‑nu ‑wʋ 'yaa kë do. ");
INSERT INTO daf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kö mɛ 'bha ‑nu ‑wo \"wlü sië 'wo ꞊sua ‑ya ‑bha 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Yi ‑zë yi‑ ‑ma \"dhi kö ‑ya pö sië ꞊dhɛ: ‹Atanna ‑dhɔkëgükɔ 'wo‑ dɔ wo ‑kɔ \"dhiʋ̈ ya, ö ‑dho ‑a 'wü 'ö‑ ‑dee 'ö 'yii dho kë mɛ ‑kɔ \"gblʋʋ 'ka 'a‑ dɔ ‑dhɛkpaɔyi ‑yaaga 'ka.› ");
INSERT INTO daf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aa\" ꞊ni ‑a ‑dhɛ ‑zian 'wo‑ pö \"dhʋ̈ bha, ‑a ‑nu ‑wʋ 'yaa gun‑ 'gü do. ");
INSERT INTO daf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","꞊Dhɛ 'ö ꞊wa 'wɔn ‑nu bha‑ pö \"dhʋ̈ 'dɔɔndhö, 'yö \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ bha 'ö ꞊wlü mɛ \"dhaa bha‑ 'gü, 'yö‑ pö Yesu ‑dhɛ 'ö‑ pö: «Dhiang \"pɛpɛ 'ö 'mɛ 'wo nu i 'ka n ‑dhɛ ya 'wo‑ zë i ‑bha ya i \"tʋ ‑ya ꞊gban 'gü, i ‑bha ‑yɔ 'i‑ dɔ‑ 'gü yö ‑mü ‑më 'ka? \"Ɛɛn ‑a ‑yɔ 'yaa i ‑gɔ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","\"Kɛɛ 'yö Yesu ‑yö ö \"dhi ta, 'yö 'yii \"wɩ. 'Yö \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ bha 'ö‑ dhɛɛ\" 'bha kpɔ 'ö‑ pö: «\"Ɛɛn bhi ꞊në 'i Atanna ‑bha ‑Yamɛ, Atanna 'kwa‑ ‑dhɔkë ya‑ Gbö 'ka ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","'Yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «꞊Iin, yö ‑mü n 'ka. ꞊Ya 'go mü ka \"yan ‑dho mang Mɛgbömɛ n yö kö a ‑ya ‑sü 'ka Atanna 'gügbɩɩsü bha‑ ‑yɛa 'ö ꞊bhlëësü 'ka bha‑ 'gü, 'ö 'ka n yö 'zü kö a 'go sië dhang‑ 'gü 'a nu dha 'kpong‑ ‑ta.» ");
INSERT INTO daf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","꞊Dhɛ 'ö \"saabhomɛ ‑nu ‑gɔmɛ bha 'ö ‑wʋ bha‑ ma, 'yö ‑siö ‑dhɛ, 'yö ö ‑bha ‑sɔ ‑pɛ, 'yö go mü 'ö‑ pö: «'Mɛ 'ka ma bha, kwa ‑mawɔn 'yaa \"sɛɛ‑ ‑zian ‑bha 'zü. ");
INSERT INTO daf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","\"Ɛɛn ö ‑dɩ 'ö‑ dan Atanna 'ka bha 'kii‑ ‑dhɛ yö ‑ee? \"Ɛɛn ka ka ‑bha pö‑ 'gü ꞊dhɛ?» 'Yö mɛ \"pɛpɛ 'wo gun mü bha‑ ‑nu ‑wʋ 'dhö to‑ ‑bha do ꞊dhɛ za 'bhaa‑ 'gü 'zü, \"kɛɛ ‑a zë ‑wɔn ꞊në to‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","‑Wo ‑to mü 'yö mɛ 'bha ‑nu 'wo zun \"dhidhi ‑suʋ̈ ‑bha ‑sü ‑bha, 'yö 'wo sɔ kpa‑ \"yan \"dhiʋ̈, 'yö 'wo zun‑ ‑zë ‑kɔkpö 'ka ‑sü ‑bha kö ‑wo ꞊wɛɛ dɔ sië‑ ‑bha 'wo‑ pö: «Atanna ‑wʋdhiʋ̈loomɛ, 'mɛ 'ö i ‑ma bha de ‑mü? ‑A ‑mɛ pö \"kpʋ̈üdhö!» 'Yö gwëëzë ‑nu 'wo wo ‑kɔ ‑da 'gü kö 'wo 'dho‑ 'ka, \"kɛɛ kö ‑wa \"tʋ ‑nu ‑ma sië \"dhʋ̈ do. ");
INSERT INTO daf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","\"Tʋ̈ng 'ö kë sië‑ 'ka \"dhʋ̈ bha kö Piɛdhö ‑ya ‑nu ꞊wlöö \"sia‑ \"kpɛnngdhö, \"kwɛandhɛ bha‑ 'gü mü kö Yesu ‑zë ‑yö 'kɔɔdhö 'kɔ ‑ta \"dhʋ̈ng 'gü. ‑Yö ‑to ‑dhɛ bha ꞊në‑ 'gü, 'yö \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ bha‑ ‑bha gwëëdhe do ‑yö nu. ");
INSERT INTO daf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","꞊Dhɛ 'ö Piɛdhö yö kö ‑yö ‑ya sië pɛng ‑bha, 'yö‑ ‑ga \"sɛnngdhö, 'yö‑ pö‑ ‑dhɛ: «Bhii ‑dɩ 'pö i ‑gun Yesu 'ö go Nazadhɛtö bha‑ ꞊keng‑ \"dhɛ!» ");
INSERT INTO daf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","\"Kɛɛ 'yö Piɛdhö ‑ya ꞊zaɔ 'ö‑ pö: «'Pë 'i‑ pö sië bha 'maa‑ dɔ, 'maa‑ 'gü ‑zian ma.» ꞊Dhɛ 'ö‑ pö \"dhʋ̈ 'yö ‑ziö 'ö dho 'ö dɔ \"kwɛandhɛ bha‑ \"dhi ‑wo ‑dhɛ 'gü, 'yö to 'yö ‑tɔgɔn ‑blɛɛsü ‑yö ‑wɩ. ");
INSERT INTO daf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","꞊Dhɛ 'ö dhebhɔ bha 'ö Piɛdhö yö 'zü ‑deewo, 'yö‑ pö 'mɛ 'wo gun mü ‑a ‑nu ‑dhɛ 'ö‑ pö: «'Mɛ 'wo bha‑ mɛ do ꞊nɛ!» 'Yö Piɛdhö ‑ya ꞊zaɔ 'zü ‑deewo. ");
INSERT INTO daf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","꞊Dhɛ 'ö \"tʋ̈ng 'në 'bha ꞊ya ziö, 'yö 'mɛ 'wo gun mü bha 'wo‑ pö 'zü Piɛdhö ‑dhɛ: «‑A pö 'wo‑ wo ꞊dhɛ 'mɛ 'wo ya‑ mɛ do ‑mü i 'ka ya 'yaa ꞊sua 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ mɛ ‑ya ‑dhɛ ‑yö i \"dhiwʋ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","꞊Dhɛ 'kö 'wo‑ pö \"dhʋ̈, 'yö Piɛdhö ‑yö zun ‑sö ‑bhö ‑sü ‑bha 'ö‑ pö: «'A‑ zë ma Atanna ‑dhɛ, 'mɛ 'ka \"wɩ sië‑ 'ka bha, 'maa‑ dɔ. (꞊Ya kë ꞊dhɛ ‑a pö 'a‑ wo sië ya ꞊ya kë ꞊sua 'ka 'a ga!)» ");
INSERT INTO daf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dhiang bha ‑yö ‑to \"dhi, 'yö ‑tɔgɔn ꞊plɛ ‑naa ‑yö ‑wɩ. 'Yö‑ ‑zʋ ‑yö ‑bö dhiang 'ö Yesu ‑ya zë‑ ‑dhɛ 'ö‑ pö: «\"Sanni ‑tɔgɔn ‑yö \"wɩ ꞊plɛ kö ꞊ya bo ö 'ka ꞊dhɛ pë ‑yaaga 'dhö bha‑ 'ka. ꞊Dhɛ 'ö‑ ‑zʋ 'dhö ‑bö 'wɔn bha‑ 'ka, 'yö zun \"gbʋ bɔ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","‑Dhɛ ‑zë 'ö ꞊kpaɔ bhoo, mɛ \"pɛpɛ 'wo Atanna ‑wɔn ‑gɔ ‑ta, \"saabhomɛ ‑nu ‑gɔmɛ oo, ‑kwɛagbö ‑nu oo, 'tɔnggɔmɛ ‑nu waa‑ zagɔbhomɛ ‑nu ‑wo ‑ya 'kwëë‑ ꞊në‑ ‑kë ‑dhɛkpaɔ tii bha‑ 'gü kö 'wo dho Yesu ‑wɔn 'kun ‑kɔ 'ö‑ 'gü 'wo‑ dɔ. ꞊Dhɛ 'ö‑ ‑nu ‑wʋ ꞊ya kë do, 'yö 'wo‑ kun 'wo‑ ‑kɔ ꞊nëng 'kwëë‑ 'wo‑ ‑lö, (kö 'ya 'dho ꞊dua) 'yö 'wo dho‑ 'ka Wlɔmö mi 'ö gun‑ ‑nu ‑bha \"sɛ bha‑ ‑gɔdhiʋ̈mɛ 'ka 'wo‑ ‑dhɛ Pidhatö bha‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","꞊Dhɛ 'wo dho 'wo ꞊loo Pidhatö ‑kuu \"dhiʋ̈, 'yö Yesu dhɛɛ\" kpɔ 'ö‑ pö: «Bhi ꞊në 'i Zuifö ‑nu ‑bha ‑gblüdë 'ka ya ‑ee?» 'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «꞊Iin, ma ‑mü.» ");
INSERT INTO daf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu bha 'wo zun za 'gbɛ ‑dɔ ‑bha ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","'Yö Pidhatö ‑ya dhɛɛ\" ‑dee 'bha kpɔ 'ö‑ pö: «Za \"pɛpɛ 'wo‑ dɔ sië i ‑bha ya 'bhaa‑ ma ꞊në‑ wo 'yö 'bhaa‑ ‑yɔ 'bha bɔ ‑ee? \"Ɛɛn ‑a ‑yɔ ꞊në 'yaa i ‑gɔ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","\"Kɛɛ Yesu 'yii‑ ‑yɔ 'bha bɔ 'zü tongtongdhö, 'yö‑ 'wɔn ‑yö Pidhatö kɔn ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","‑A \"tʋ̈ng bha‑ 'gü, kö Pakö yi ꞊ya ꞊loo ‑kɔ 'ö‑ 'gü 'do 'do, 'yö ‑gblüdë ꞊ya 'mɛ 'wo ‑kaso 'gü bha‑ mɛ 'dhɛ Zuifö ‑nu ꞊waa‑ pö ‑ya bho ‑kaso 'gü wo ‑dhɛ, 'yö ꞊yaa‑ bho ‑kaso 'gü. ");
INSERT INTO daf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","\"Tʋ̈ng 'wo Yesu kun‑ 'ka bha kö gɔndënë do 'wo Badhabasö ‑kë, 'ö waa‑ ö \"tɛabɔ ‑nu 'wo mɛ zë kö ꞊wa \"wlü \"sɛgɔmɛ \"piʋ̈ bha ‑yö ‑kaso 'gü. ");
INSERT INTO daf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","'Yö mɛ kpö 'gbɛ ꞊dede 'wo ꞊wlü 'yi bha‑ 'ka 'wo dho Pidhatö \"piʋ̈, 'yö 'wo ꞊bhɛa‑ ‑dhɛ kö ‑yö mɛ do bho wo ‑dhɛ ‑kaso 'gü ꞊dhɛ ‑kɔ 'ö‑ ‑kë 'ka zii‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","'Yö Pidhatö ‑ya ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Yö ka \"piʋ̈ ꞊dhɛ 'a n ‑kɔ bho Zuifö ‑nu ‑bha ‑gblüdë ya‑ 'gü ka ‑dhɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Dhɛɛ\" 'ö Pidhatö ‑ya kpɔ \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑ya 'wɔn dɔ ꞊dhɛ gblɛɛn\" ꞊në \"saabhomɛ ‑gɔmɛ ‑nu bha 'wo gun gɔn sië Yesu 'ka, 'yö‑ ‑wɔn 'gü 'yö 'wo nu‑ 'ka ö ‑dhɛ, \"kɛɛ ꞊sɔng 'bhaa‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","\"Kɛɛ ꞊dhɛ 'ö dhɛɛ\" bha‑ kpɔ \"dhʋ̈, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu bha 'wo ‑da mɛ kpö bha‑ ‑nu ‑gɔ 'gü, 'yö 'wo ‑wʋ ma‑ ‑nu \"tʋʋ, kë \"dhʋ̈ kö Pidhatö ‑yö ö ‑kɔ bho Badhabasö ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","'Yö Pidhatö ‑ya ‑nu dhɛɛ\" ‑dee 'bha kpɔ 'zü 'ö‑ pö: «‑Yö ka \"piʋ̈ 'sa ꞊dhɛ 'mɛ 'ka‑ ‑dhɛ Zuifö ‑nu ‑bha ‑gblüdë ya 'a‑ kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","'Yö 'wo ꞊gbla \"gbɩɩ‑ 'ka 'wo‑ pö: «‑Bhö ‑a dɔ \"dhü ‑bha!» ");
INSERT INTO daf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","'Yö Pidhatö ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A ‑dɔ \"dhü ‑bha ‑gɛn ‑mü ‑më 'ka? ‑Yö ‑më ‑wɔn yaa ꞊në‑ ‑kë?» \"Kɛɛ 'yö 'wo ꞊gbla 'zü \"gbɩɩ‑ ꞊dede 'ka 'wo‑ pö: «Yi‑ ‑pö 'i dɔ \"dhü ‑bha!» ");
INSERT INTO daf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","'Yö Pidhatö ‑ya zë mɛ kpö bha‑ ‑nu dhɔɔbhaawɔn kë ‑sü ‑dhɛ, 'yö ö ‑kɔ bho Badhabasö 'gü. 'Yö \"sɔdha ‑nu ‑ya Yesu ‑zë ‑bha 'yö 'wo‑ ‑ma. ꞊Dhɛ 'wo‑ ‑ma 'bha wo, 'yö ö ‑kɔ bho‑ 'gü kö ‑wo 'dho‑ 'ka kö ‑wa dɔ \"dhü ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","꞊Dhɛ 'ö Pidhatö ‑yö ö ‑kɔ bho Yesu 'gü \"sɔdha ‑nu ‑dhɛ, 'yö 'wo‑ sü za ꞊gblü \"dhiʋ̈ 'yö 'wo dho‑ 'ka ‑gblüdë ‑gɔ 'kɔɔdhɛ ꞊dede 'gü, 'yö 'wo wo këyɔɔ ꞊gban \"pɛpɛ ‑dhɛ mü. ");
INSERT INTO daf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","'Yö 'wo ‑gblüdë ‑nu ‑da ꞊gbauu‑ \"yan ‑zaɔndhö 'bha bha‑ ‑da ‑bha kö ‑yö kë ꞊dhɛ ‑gblüdë 'dhö, kö 'wo ꞊wɛɛ ‑dɔ ‑bha ‑dhɛ yö, 'yö 'wo dho 'wo \"glɛn 'faan‑ bɔ 'wo‑ ‑ya ‑gɔ ‑bha, ");
INSERT INTO daf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'yö 'wo zun‑ ꞊wɛɛ ‑dɔ ‑bha ‑sü ‑bha 'wo‑ ꞊tua bho 'wo‑ pö: «Zuifö ‑nu ‑bha ‑gblüdë, 'bha ꞊boo!» ");
INSERT INTO daf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","'Yö 'wo zun‑ ‑ma ‑sü ‑bha \"dhü 'ka ‑a ꞊gbin‑, kö ‑wo \"dhidhi ‑pɛn sië‑ ‑bha, kö ‑wo zun sië wo kpiö 'gü, 'wo‑ ꞊bhlëë ‑ya ꞊dhɛ ‑gblüdë 'dhö. ");
INSERT INTO daf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","꞊Dhɛ 'wo wo bo ꞊wɛɛ ‑dɔ ‑bha ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö 'wo ꞊gbauu‑ bha‑ bho‑ ‑bha, 'yö 'wo‑ ‑dɩ ‑a sɔ ‑da ‑bha, 'yö 'wo dho‑ 'ka ‑a ‑dɔ \"dhü ‑bha ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","꞊Dhɛ 'ö ꞊wa ‑da zian ‑ta 'wo 'dho sië, 'yö 'wo ‑kpan Simɔ 'wo‑ gbö do ‑dhɛ Dhɛzandrö, 'wo‑ mɛ do 'bha ‑dhɛ Dhufusö 'ö go Sidhɛnö bha‑ ‑bha kö ‑yö 'go sië ö ‑gɔ gbɛɛ 'gü ‑yö ziö sië. 'Yö 'wo zun‑ \"dhiʋ̈ 'wo‑ pö‑ ‑dhɛ ‑yö Yesu ‑dɔ ‑bha \"dhü bha‑ 'sü kö 'wo 'dho‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","'Yö 'wo Yesu sü 'wo dho‑ 'ka ‑dhɛ 'wo‑ ‑dhɛ eblö ‑wʋ 'gü Gɔgota bha‑ 'gü (꞊waa‑ pö \"dhʋ̈ kö ‑wa ‑pö ‹mɛ ‑gɔ \"kpɛa ‑tɔn›.) ");
INSERT INTO daf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","꞊Dhɛ 'wo dho 'wo ꞊loo mü, 'yö 'wo pë 'bha 'wo‑ 'miidhö ‑kë, 'ö pë ‑nɛɛ ‑ma mɛ 'ka ‑sü dho \"sia‑ bha‑ ‑da ‑drɔɔ \"piʋ̈ 'yö 'wo‑ nu‑ ‑dhɛ, \"kɛɛ 'yii \"wɩ‑ ‑bha kö ‑ya mü. ");
INSERT INTO daf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","꞊Dhɛ 'ö ꞊waa‑ ꞊gban kë \"dhʋ̈ ꞊wa wo bo, 'yö 'wo‑ sü 'wo‑ dɔ \"dhü ‑bha, 'yö 'wo \"pɔni ‑gban ‑a ‑kɔ waa‑ ‑gɛn ‑nu ‑ta. 'Yö 'wo‑ ‑bha ‑sɔ ‑nu bha‑ ‑nu 'gü ‑gblü wo 'ko ‑ta ‑a zë \"kpʋ̈ü kë ‑sü 'ka, kë \"dhʋ̈ kö mɛ 'ö 'dhö ‑a ‑bha 'ö dho‑ ꞊slɔɔ kö ‑ya dɔ. ");
INSERT INTO daf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","‑Wa ‑dɔ \"dhü ‑bha \"dhʋ̈ dhia\" \"piʋ̈ 'yënng‑ \"tɛɛ \"gbɩɩ‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pë ‑bɛn 'wo‑ zë kö ꞊wa ꞊nëng ‑a ‑dɔ ‑bha ‑dhü bha‑ ‑bha kö mɛ ꞊gban \"pɛpɛ ‑wa zë ‑gɛn dɔ bha, 'yö 'wo‑ pö: «Zuifö ‑nu ‑bha ‑gblüdë ꞊nɛ». 'Yö 'wo‑ ꞊nëng \"dhü ‑bha ‑a ‑gɔ ‑ta \"dhʋ̈ng 'gü. ");
INSERT INTO daf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","‑Wo waa‑ mɛzëmɛ ‑nu ꞊plɛ ꞊në‑ ‑nu dɔ \"dhü ‑bha 'ko \"tʋ̈ng do 'gü. 'Yö 'wo‑ mɛ do dɔ‑ ‑kɔ ‑së 'gü, 'yö 'wo mɛ do dɔ‑ ꞊kwaa 'gü. ");
INSERT INTO daf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kë \"dhʋ̈ kö ‑wʋ 'ö ‑bɛn zë ‑sü 'ka Atanna ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: «‑Wo kë‑ ‑dɔ 'wɔnyaakëmɛ ‑nu ‑bhiëë 'gü» bha‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","'Kö 'mɛ 'wo zian ziö sië ‑wo \"si bho sië‑ ‑gɔ 'ö 'wo wo ‑gɔ 'gü zë‑ 'ka‑ ‑dhɛ 'wo‑ pö: «‑Aao! ‑A 'dhɛ 'i‑ ‑dhɛ ꞊mɔɔ 'yö bha! 'Bhii‑ pö i ‑mɔɔ ‑bha 'i Atanna ‑dhɔkëgükɔ wü, 'i‑ ‑dee dɔ ‑dhɛkpaɔyi ‑yaaga 'ka ‑ee? ");
INSERT INTO daf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","‑Bhö i ‑dɩ dha ‑dhe! ‑Bhö 'go \"dhü bha‑ ‑bha ꞊tɔn kö 'i zun \"sia‑ ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu ‑dɩ 'pö ‑wo ꞊wɛɛ dɔ sië‑ ‑bha waa‑ 'tɔnggɔmɛ ‑nu 'dhö, 'wo‑ pö wo 'ko ‑dhɛ: «꞊Ya mɛ ‑nu dha, \"kɛɛ ‑a ‑kɔ 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö ö ‑dɩ ‑zë dha!» ");
INSERT INTO daf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","'Ö 'wo‑ pö: «'Bhii‑ pö i ‑dɩ ‑dhɛ ꞊dhɛ bhi ꞊në 'i Izraɛdhö ‑mɛ ‑nu ‑bha ‑gblüdë 'ka, ꞊dhɛ bhi ꞊në 'i 'mɛ 'ö Atanna ‑ya ‑ya kö 'ö‑ bɔ yi dha ‑dhɛ 'gü ‑a 'ka ‑ee? 'Bha‑ pö 'yi 'dhang bho i \"dhiʋ̈, ‑bhö i ‑dɩ bho \"dhü bha‑ ‑bha kö 'i lɔɔ‑ kö 'yi‑ ‑dhɛ yö kö 'yi 'dhang bho i \"dhiʋ̈!» Kö 'mɛ 'wo wɛng‑ ‑nu ‑a ‑nu ‑gban \"dhü ‑bha ‑dhɛ do 'gü bha, ‑wo \"si bho sië‑ ‑gɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","꞊Dhɛ 'ö 'yënng‑ ꞊ya ‑ya mɛ ‑gɔ ꞊zinng 'gü, 'yö ‑dhɛ ‑yö ꞊tröö \"kpʋngtaadhɛ ꞊gban \"pɛpɛ 'gü, 'yö dho 'ö zun‑ 'ka \"wɔ \"yɛ ‑yën ‑bha. ");
INSERT INTO daf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","꞊Dhɛ 'ö 'yënng‑ ꞊ya 'kpɔ mɛ ‑gɔ 'ka ‑së 'ka, 'yö Yesu ‑yö ꞊gbla \"gbɩɩ‑ 'ka eblö ‑wʋ 'gü 'ö‑ pö: «Edhoi, dhama sabatami! (꞊Waa‑ pö \"dhʋ̈ kö ‑wa ‑pö: «\"Eke n Dë Atanna, \"eke, i i ‑kɔ ‑kan n \"dhiʋ̈ ꞊ni ‑më ‑wɔn 'gü?» ");
INSERT INTO daf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","꞊Dhɛ 'ö 'mɛ 'wo gun mü bha 'wo‑ ‑wʋ ma ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö‑ mɛ ga 'bha ‑wa pö: «‑Ka dɔ! ‑Yö Edhi ‑dhɛ sië ‑wa!» ");
INSERT INTO daf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Yö‑ mɛ do ‑yö dɔ ‑bɛang ‑bha 'ö dho 'ö ‑fuu ‑kɔn 'bha bha‑ ‑da we 'wangwang 'bha bha‑ ꞊bhaa, 'yö‑ ‑ya \"dhü \"dhiʋ̈, 'yö nu‑ 'ka‑ ‑dhɛ kö ‑ya mü, \"kɛɛ kö ‑ya pö sië: «‑Kaa 'to mü kö (Atanna ‑wʋdhiʋ̈loomɛ) Edhi 'ö‑ ‑dhɛ sië bha ‑yö nu kö ‑ya lɔɔ 'kwa‑ ‑dhɛ yö!» ");
INSERT INTO daf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","\"Kɛɛ ꞊dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ꞊gbla \"gbɩɩ‑ 'ka, 'yö ‑kë ‑a 'nii‑ ‑pö ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","‑A 'nii‑ 'dhö ‑pö \"tʋ̈ng ꞊dede 'ö‑ 'ka bha, 'yö sɔ 'ö gun Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gü, ‑a 'gü ‑kan 'gü ‑sɔ 'ka bha 'ö ‑pɛ ꞊zinng 'gü gbanngdhö, 'yö go‑ 'ka \"dhʋ̈ng 'gü 'ö zun‑ 'ka \"sia‑ (kö ‑ya ‑zɔn ꞊dhɛ ꞊zinng 'yaa Atanna waa‑ mɛ \"bhɩɩ‑ ‑nu ‑a ‑nu ꞊zinng 'gü 'zü Yesu Klisi 'saa‑ 'gü). ");
INSERT INTO daf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","꞊Dhɛ 'ö Wlɔmö ‑mɛ ‑nu ‑bha \"sɔdha këng do ‑gɔmɛ 'ö gun dɔ sië Yesu wëëdhö mü bha 'ö‑ ga ‑kɔ bha‑ 'suan‑ bho, 'yö yöö ꞊dede 'ö‑ ‑kan ö \"dhi 'ka 'ö‑ pö: «'Mɛ 'ö ya Atanna Gbö ꞊në gun‑ 'ka tɛan‑ ꞊dede 'ka!» ");
INSERT INTO daf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","'Ö gun \"dhʋ̈ 'pö kö dhong ‑nu kpö 'bha bha ‑wo dɔ sië ꞊gblɛɛn 'wo‑ ‑dhɛ ‑ga. Dhong ‑nu 'wo gun ‑dhɛ ‑ga sië \"dhʋ̈ bha, Madhi 'ö go Madadha oo, Madhi 'dhɛ 'ö ‑kë Zakö sɛɛnnë waa‑ Zoze ‑a ‑nu dhe 'ka bha waa‑ Sadhome ‑wo ‑gun ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mɛ 'dhɛ 'kö 'wo bha wo ‑zë ‑wo gun Yesu ꞊keng‑ kö ‑yö ‑tun \"yaan, wo ꞊në 'wo gun‑ \"dhiʋ̈ ‑ziö wo sië kö ‑yö Gadhidhe, \"kɛɛ dhebhɔ ‑nu 'gbɛ ꞊dede 'wo ‑ziö Yesu ꞊keng‑ kö ‑yö 'dho sië Zedhizadhɛmö, ‑wo ‑gun mü 'pö. ");
INSERT INTO daf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","꞊Dhɛ 'ö ‑kë ꞊dhɛ 'wɔn bha ‑yö ‑kë \"dhʋ̈ Zuifö ‑nu ‑bha ꞊glooyi yɛan\" \"piʋ̈ 'ka, 'ö 'wɔn \"pɛpɛ 'wo dho‑ kë ꞊glooyi 'ka 'wo‑ ꞊gban ꞊baa 'yi bha ꞊në‑ 'ka, \"kɛɛ kö \"bin ꞊ya 'ma ꞊gban wo, 'yö gɔndë do 'wo‑ ‑dhɛ Zosɛfu 'ö go Adhimate ‑pö 'gü bha 'ö nu. ");
INSERT INTO daf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zosɛfu bha ‑yö ‑gun mɛ ‑tiandhö 'wo‑ ꞊bhlëë ‑ya ꞊dedewo ‑a 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ za ‑gɔ \"yɛ ‑mɛ ‑nu 'wo gun \"sɛ bha‑ 'gü ‑a mɛ do ꞊në gun‑ 'ka, \"kɛɛ yö ‑zë ‑yö ‑gun 'mɛ 'ö 'dhang bho Atanna ‑bha ‑gblüdëdhɛ ‑wɔn \"dhiʋ̈, 'ö ‑ya ‑sü 'ka‑ ‑bha ‑ya 'gü ‑a 'ka. ꞊Dhɛ 'ö nu, 'yö ö ‑zʋ ‑gban 'ö dho Pidhatö \"piʋ̈, 'yö Yesu ꞊gee ‑gbadhɛ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","\"Kɛɛ Yesu ‑ga 'piö‑ ‑wɔn 'ö \"dhʋ̈ bha‑ 'wɔn ‑yö Pidhatö ‑kɔn ꞊dedewo. ‑Yö \"sɔdha ‑gɔmɛ bha‑ ‑dhɛ yö ꞊në‑ ‑wɔn 'gü, 'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «'Mɛ bha‑ ga ‑yi ꞊ya ꞊gwëë 'pö wo ‑ee?» ");
INSERT INTO daf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","꞊Dhɛ 'ö bo‑ ꞊iin pö ‑sü 'ka, ‑yö ö ‑kɔ ꞊në bho Yesu ꞊gee 'gü Zosɛfu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","꞊Dhɛ 'ö Yesu ꞊gee nu Zosɛfu ‑dhɛ, 'yö Zosɛfu dho 'yö sɔ \"puu dhɔ, 'yö nu 'yö Yesu ꞊gee bha‑ bho \"dhü ‑bha, 'yö sɔ \"puu bɔ‑ ‑bha, 'yö dho‑ 'ka 'ö‑ ‑wɛɛ bho ‑gwë ‑yɛ 'bha 'ö ꞊waa‑ 'pɔn 'nu ‑blɛɛsü bha‑ 'gü, 'yö ‑gwë kpö 'kpii‑ do 'bha ꞊glün 'ö nu‑ 'ka 'ö‑ zun ‑gwë ‑yɛ bha‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","‑A \"tʋ̈ng 'ö‑ kë sië‑ 'ka \"dhʋ̈ bha kö Madhi 'ö go Madadha bha waa‑ Zoze dhe Madhi ‑a ‑nu \"yan ‑ya ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","꞊Dhɛ 'ö Zuifö ‑nu ꞊glooyi bha‑ 'yënng‑ ‑gɔ ꞊ya bo ‑pö ‑sü 'ka, 'yö Madhi 'ö go Madadha bha‑ 'dhö, Zakö dhe Madhi 'dhö, Sadhome 'dhö, 'wo dho 'wo ‑dhasiklɔɔ \"yɔn dhɔ, kö 'wo 'dho‑ 'ka 'wo‑ ziö Yesu ꞊gee ‑bha (꞊dhɛ ‑kɔ 'wo‑ ‑kë 'ka ‑a ‑nu wɔ ‑kɔ 'gü ‑a 'dhö). ");
INSERT INTO daf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya ꞊kpaɔ, kö 'yënng‑ \"tɛɛ ꞊ya ‑wo ‑së 'ka, 'yö 'wo ‑ziö 'wo dho Yesu bun ꞊taa. ");
INSERT INTO daf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","\"Kɛɛ 'wo gun 'dho sië kö \"sika ‑ya ‑nu 'gü, kö ‑wa pö sië: «Kwa 'dho ‑zë wo sië, \"kɛɛ 'de yöö ‑gwë 'gbɔng bha‑ bho ꞊zɔɔ kwa ‑dhɛ ‑yɛ bha‑ \"dhiʋ̈?» ");
INSERT INTO daf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","꞊Dhɛ 'wo dho 'wo ꞊loo mü, 'wo dho wo \"yan \"dhiʋ̈ \"wlü kö ‑wo ‑dhɛ ‑ga, kö ‑gwë 'gbɔng ‑ziisü 'ö gun ‑ya ‑sü 'ka ‑yɛ bha‑ \"dhiʋ̈ bha 'yaa mü 'zü, kö ꞊waa‑ glün‑ ꞊wa 'dho‑ ‑ya zian \"wɛɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","'Yö 'wo dho 'wo ‑da ‑gwë ‑yɛ 'wo Yesu ‑wɛɛ bho‑ 'gü bha‑ 'gü, 'yö 'wo Atanna ‑bha \"kië do yö kö sɔ \"puu ‑ya ‑bha kö ‑yö ‑ya ‑sü 'ka‑ 'ka ‑a ‑nu ‑kɔ ‑së \"pɛan \"piʋ̈ ‑yɛ 'gü mü. 'Yö \"suʋ̈ 'dhö ‑da ‑a ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","'Yö‑ pö‑ ‑nu ‑dhɛ: «\"Suʋ̈ 'ya 'dho ka kë, Yesu 'ö go Nazadhɛtö 'wo‑ dɔ \"dhü ‑bha bha 'aa mü 'ka‑ mɔɔ‑ sië ‑ee? ꞊Ya ‑bö 'nu, 'yaa yö 'zü, ‑ka nu kö 'ka‑ wɔdhɛ ‑ga! ");
INSERT INTO daf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","‑Ka 'dho kö 'ka‑ pö‑ ‑bha ꞊klang ‑nu ‑dhɛ, \"kɛɛ kö 'ka‑ pö Piɛdhö ‑dhɛ ꞊dhɛ ꞊ya 'go ga 'gü, ꞊ya ‑da ka \"dhiʋ̈ ꞊ya 'dho Gadhidhe. Ka ‑dho ‑kpan ‑bha ‑dhɛ bha ꞊në‑ 'gü ꞊dhɛ ‑kɔ 'ö‑ pö‑ 'ka ka ‑dhɛ kö 'yii ga ꞊kö bha‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","'Yö 'wo go ‑yɛ bha‑ 'gü 'wo ‑ziö ‑bɛang 'ka, kö \"suʋ̈ ꞊ya ‑da ‑nu 'gü kö‑ ‑nu \"gblʋ̈ʋ̈dhɛ ꞊gbaan \"muu bho \"suʋ̈ yaa 'gü yaa 'ö ‑da ‑a ‑nu 'gü bha‑ ‑wɔn 'gü, 'wii ꞊mɔɔ‑ ‑bha kö ‑wa ‑gɛn dɔ mɛ bha ‑dhɛ ‑zianwo. ");
INSERT INTO daf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","꞊Dhɛ 'ö Yesu ‑yö ‑bö Zuifö ‑nu ꞊glooyi bha‑ ‑tadhɛkpaɔ ‑ta, mɛ ‑blɛɛsü 'ö ö ‑dɩ ‑zɔn ‑dhɛ 'yö ‑kë Madhi 'ö go Madadha 'ö Yesu ‑yö \"yina yaa \"saɔplɛ ‑kë 'gü \"tʋ̈ng 'bha 'gü bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","'Yö dho 'ö‑ pö 'mɛ 'wo gun Yesu ꞊keng‑ ‑blɛɛsü bha ꞊në‑ ‑nu ‑dhɛ. 'Ö dho 'ö ꞊loo mü kö Yesu ga ‑wɔn zuëdhiʋ̈tɛɛ 'ö ‑ya ‑nu ‑bha bha ‑wo ‑tun ꞊kö‑ 'gü \"gbʋ bɔ‑. ");
INSERT INTO daf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","꞊Dhɛ 'ö Madhi ‑ya ‑gɛn dɔ‑ ‑nu ‑dhɛ, 'ö 'wo‑ ma‑ ‑ta ꞊dhɛ ‑yö \"yaandhe 'ka, \"kɛɛ 'ya 'ö \"yanga ꞊plɛ ‑kpan ‑a ‑kpong 'gü ‑dhɛ ‑bha, 'wii 'dhang bho‑ \"dhiʋ̈ tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","꞊Dhɛ 'ö go yö ‑zë 'gü, 'yö dho 'ö ö ‑dɩ ‑zɔn 'zü ‑deewo 'mɛ 'wo gun‑ ꞊keng‑ bha‑ mɛ ꞊plɛ 'wo gun 'go sië Zedhizadhɛmö, 'wo dho 'pö‑ ‑kɔ 'gü ‑a ‑nu ‑dhɛ, \"kɛɛ 'wii‑ dɔ zü bho ‑yi 'ka. ");
INSERT INTO daf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","'Yö woo ‑dɩ 'pö 'wo nu 'wo‑ ‑gɛn dɔ mɛ ‑kpɛa ‑dhɛ, \"kɛɛ 'wii 'dhang bho‑ ‑nu ‑wʋ \"dhiʋ̈ yö ‑zë 'bha 'gü. ");
INSERT INTO daf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","'Yö gun ‑na ö ‑dɩ ‑zɔn ö ‑bha ꞊klang ‑nu ‑kaɔng do ga do 'wo to bha‑ ‑nu ‑dhɛ \"dhʋ̈ kpɔɔ\" ‑ɔɔdhö yi do 'ka kö ‑wo pë ‑bhö sië. 'Yö ‑dɔn bho‑ ‑nu 'ka ‑a ‑nu ‑bha gɔɔgbɩɩdhɛ waa‑ 'dhang ‑bho ö \"dhiʋ̈ ‑sü 'ö 'yii kë‑ ‑nu ‑gɔ bha‑ ‑wɔn 'gü. ‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'wo‑ \"yaandhe yö, 'ö 'wo nu 'wo‑ ‑gɛn dɔ‑ ‑nu ‑dhɛ bha, 'wii 'dhang bho‑ 'bha \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","꞊Dhɛ 'ö ‑dɔn bho‑ ‑nu 'ka \"dhʋ̈ 'ö ö bo, 'yö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: «‑Ka 'dho \"kpʋngtaadhɛ ꞊gban \"pɛpɛ 'gü kö naɔ ‑së bha 'ka‑ dɔ \"kpʋngtaamɛ ꞊gban \"pɛpɛ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mɛ \"ʋʋ mɛ 'ö yaa‑ ‑wɩ ka ‑wʋ bha‑ ‑bha kö ‑yö 'dhang bho n \"dhiʋ̈, kö ‑wa ‑mɛ ‑bɔ n 'ka ‑zu bho, ‑a ‑mɛ ‑dho dha, \"kɛɛ 'mɛ 'yii \"wɩ‑ ‑bha, Atanna ‑dho 'wɔn bho‑ ‑mɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","'Yö go mü 'ö‑ pö: «‑Ka ‑dhɛ ‑ga: Mɛ \"ʋʋ mɛ 'ö 'dhang bho 'wɔn bha‑ \"dhiʋ̈, \"dhabhliwɔn ‑nu 'ö‑ ‑mɛ dho‑ kë ‑kaa ‑ga, ‑a ‑mɛ ‑dho \"yina yaa kë mɛ 'gü n 'tɔ 'gü, 'ö Atanna ‑yö ‑wʋ ‑dee 'ö‑ 'yaa‑ dɔ tongtongdhö ‑a dɔ‑ \"dhi 'ö‑ pö. ");
INSERT INTO daf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","‑A ‑mɛ ‑dho ‑mlɛɛ 'kun ö ‑kɔ 'ka 'ö 'yaa‑ kë ‑kɔ 'bha‑ 'gü, müpë 'ö waa mü 'ö mɛ zë, ‑a ‑mɛ ‑dho ‑a mü, 'ö 'yaa‑ kë ‑kɔ 'bha 'gü. ‑A ‑mɛ ꞊ya ö ‑kɔ ‑ya \"yuëdhi ‑bha kö ‑yö bhɛa\" Atanna ‑dhɛ ‑a ‑wɔn 'gü, ‑yö ‑dho kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","꞊Dhɛ 'ö kwa Dëmɛ ‑yö ö bo ‑wʋ ‑kpɔ ö ‑bha ꞊klang ‑nu ‑bha ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö Atanna ‑ya ꞊wlü, 'yö dho dhang‑ 'gü, 'yö dho 'ö ‑ya ‑yɛa ꞊bhlëësü 'ö Atanna ‑kɔ ‑së 'gü mü bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","'Yö‑ ‑bha ꞊klang ‑nu bha 'wo ‑ziö 'wo dho, 'yö 'wo zun Atanna ‑wʋ pö ‑sü ‑bha ‑dhɛ ꞊gban \"pɛpɛ 'gü. Kwa Dëmɛ ‑gun ‑a ‑nu ꞊keng‑ 'pö ‑dhɛ ꞊gban 'gü 'ö wɛng‑ ‑nu 'wo yë bha‑ kë wo \"kwëë, 'ö ꞊wa dhiang zë ‑dhɛ 'ö‑ 'gü, 'ö \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu ‑wo ‑kë ‑a ‑nu ‑kɔ ‑ta, kë \"dhʋ̈ kö mɛ ꞊gban ‑wa 'wɔn dɔ ꞊dhɛ yö ꞊në‑ ‑nu bɔ.");
INSERT INTO daf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","꞊Bhlëëmɛ Teofidhö, 'wɔn ‑nu 'wo kë ‑sü 'ka kwa ‑kwɛ ya‑ 'ka 'ö ‑gban Yesu Klisi ‑wɔn ‑bha bha, 'mɛ 'ö‑ ‑nu \"yan 'dhö dɔ‑ ‑dhɛ 'gü, 'ö 'wo‑ zü bho ‑kɔ waa‑ \"dhiʋ̈ ‑ta ‑kɔ ꞊gban dɔ, 'ö naɔ ‑së bha‑ dɔ ‑sü ‑yö gun‑ ‑nu ‑bha yë 'ka, ‑kɔ ꞊dede 'wo‑ ‑gɛn dɔ‑ 'ka kwa ‑dhɛ bha mɛ 'gbɛ ‑wa \"dhiʋ̈ \"wlü ‑sü 'ka‑ ‑bha 'wo‑ ‑bɛn zë \"kpʋ̈üdhö ꞊dhɛ ‑kɔ 'wo‑ pö‑ 'ka ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, mang Dhukö ‑mɛ ‑zë n ‑bha 'ka, ‑yö ‑kë 'pö n 'gü ‑së kö 'wɔn 'ö \"dhʋ̈ bha 'a‑ ‑bha mɔɔ‑ kö ‑kɔ 'ö ‑kë 'ka kpɛnngdhö ‑a zübhoyi 'ka bha 'a‑ ‑bɛn zë 'sëëdhɛ 'gü kö 'a‑ bɔ i ‑dhɛ, ");
INSERT INTO daf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kë \"dhʋ̈ kö 'i 'dhang bho 'mɛ 'wo i ꞊klang ‑kë 'wɔn bha‑ 'ka bha‑ ‑nu \"dhiʋ̈ kö 'i‑ 'wɔn dɔ ꞊dhɛ 'pë 'wo‑ pö bha 'yaa ꞊sua 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","\"Tʋ̈ng 'ö Edhodö ‑yö gun‑ 'ka \"sɛdë 'ka Zude ‑sɛ 'gü bha, \"saabhomɛ do 'bha ‑yö gun‑ ‑gɔ 'kɔɔdhö 'wo gun‑ ‑dhɛ sië Zakadhi. Zakadhi bha ‑yö ‑kë \"saabhomɛ ‑nu 'wo gun Izraɛdhö ‑sɛ 'gü \"tʋ̈ng bha‑ 'gü bha‑ ‑nu kpö 'dhɛ 'wo‑ ‑dhɛ Abia ‑bha mɛ ‑nu bha ꞊në‑ mɛ do 'ka. 'Yö 'wo gun‑ ‑bha dhebhɔ ‑dhɛ sië Dhizabɛtö, 'yö ‑kë 'pö \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ 'wo gun‑ Aadhɔn kë sië bha‑ suu 'gü ‑në do 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mɛ ꞊plɛ 'wo \"dhʋ̈ bha ‑wo ‑gun 'wɔn ‑ma Atanna ‑ta ‑mɛ ꞊dede 'ka, 'ö pö 'aa gun‑ ‑nu ‑bha 'wɔn 'bha 'gü Atanna wëëdhö, 'ö 'wo‑ ‑bha 'tɔng‑ ꞊gban kun 'ö 'wo‑ ꞊bhlëë ‑ya 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","\"Kɛɛ 'yö 'në 'bha 'yaa gun‑ ‑nu ‑gɔ, ‑a ‑gɛn ‑mü ꞊dhɛ Dhizabɛtö bha ‑yö ‑gun ꞊gblöödhe 'ka, \"kɛɛ kö ‑a ‑nu ꞊gban ꞊plɛ ꞊wa kë mɛ ‑zʋgbansü ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","\"Kɛɛ ꞊dhɛ 'ö yi do 'ka, 'ö Zakadhi ‑nu ‑bha kpö bha‑ ‑da \"dhɛɛdhö ‑yi ꞊ya ꞊loo kö ‑wo Atanna ‑dhɔkë, kö ‑wo ‑dhasiklɔɔ \"gʋ̈‑ ‑dhɛ, 'ö ꞊waa‑ zë \"kpʋ̈ü kë ꞊dhɛ ‑kɔ 'wo‑ ‑kë 'ka \"saabhomɛ ‑nu wɔ ‑kɔ 'gü ‑a 'dhö, 'ö ꞊ya 'to Zakadhi ‑bha ‑bha, 'ö ‑dhasiklɔɔ bha‑ \"gʋ̈ sië Atanna ‑dhɔkëgükɔ 'gü, kö‑ ꞊fii ‑së bha ‑yö 'dho‑ ‑gɔ, ");
INSERT INTO daf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","kö Zuifö ‑nu \"pɛpɛ 'wo nu Atanna ‑dhɔkëdhɛ 'gü mü bha ‑wo kpö dɔ ‑sü 'ka 'pö \"kpɛnngdhö kö ‑wo bhɛa\" sië‑ ‑dhɛ \"tʋ̈ng do bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","'Yö‑ ‑bha \"kië do ‑yö ö ‑dɩ ‑zɔn Zakadhi ‑dhɛ ‑dhasiklɔɔ \"gʋ̈ ‑dhɛ bha‑ 'gü. ‑A ‑bha \"kië bha ‑yö ‑gun dɔ sië \"saabhotapë bha‑ ‑kɔ ‑së 'gü \"pɛan \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","꞊Dhɛ 'ö Zakadhi ‑ya yö, 'yö \"suʋ̈ ‑yö ‑da 'gü, 'yö‑ \"gblʋ̈ʋ̈dhɛ 'dhö \"muu bho. ");
INSERT INTO daf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","\"Kɛɛ 'yö Atanna ‑bha \"kië bha 'ö‑ pö‑ ‑dhɛ: «\"Suʋ̈ 'ya 'dho i kë, Zakadhi, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ꞊ya i ‑bha bhɛawʋ ma. I ‑bha dhebhɔ Dhizabɛtö ‑dho 'nëgɔɔn do 'kpɔ i ‑gɔ, i ‑dho ‑a ‑dhɛ Zan. ");
INSERT INTO daf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","‑Yö ‑dho kë i ‑gɔ zuë\" ꞊nii ‑da 'gü ‑wɔn 'kpii‑ ꞊dede 'ka 'ö 'i i \"dhia bho, 'ö‑ ‑bha bhɔ ‑sü ‑yö mɛ 'gbɛ ꞊nii ‑da ꞊dedewo, ");
INSERT INTO daf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","‑a ‑gɛn ‑mü ꞊dhɛ 'në bha‑ ‑duɛ ‑dho kë 'kpii‑ Atanna ‑kuu \"dhiʋ̈, ‑a ‑dhɛ 'yaa‑ ‑bha kö 'në 'ö \"dhʋ̈ bha ‑yö we mü \"ɛɛn pë 'ö ꞊waa‑ mü 'ö mɛ kun kö ‑yö zun‑ 'bha ‑bha; ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑dho bhɔ kö ‑yö pa ‑sü 'ka Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","‑Yö ‑dho mɛ 'gbɛ \"dhiʋ̈ yee kë Izraɛdhö ‑mɛ ‑nu kpö 'gü 'ö dho‑ ‑nu 'ka ‑a ‑nu Dëmɛ, ‑a ‑nu ‑bha Atanna \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","'Gügbɩɩdhɛ 'ö gun Atanna ‑wʋdhiʋ̈loomɛ Edhi 'gü ‑a ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ faan 'ka bha ‑yö ‑dho kë‑ 'gü, 'ö \"ta sü‑ 'ka Atanna wëëdhö, kë \"dhʋ̈ kö ‑yö 'në waa‑ dë nu ‑kɔ 'wü 'koo kö ‑a ‑nu ‑wʋ ‑yö kë do, 'kö ‑yö gɔɔgbɩɩmɛ ‑nu dɔ zian ‑ta kö ‑wo ‑gleng 'sü 'mɛ 'wo 'dhang bho Atanna \"dhiʋ̈ ‑a ‑nu ‑bha, kö ‑yö Izraɛdhö ‑sɛgümɛ ‑nu ‑ya \"yaan Atanna ‑wɔn \"gblʋʋ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","\"Kɛɛ 'yö Zakadhi ‑ya pö Atanna ‑bha \"kië bha‑ ‑dhɛ 'ö‑ pö: «‑A 'wɔn 'dhɛ 'kö bha a ‑dho 'dhang bho‑ \"dhiʋ̈ ‑kɔ kë ꞊dhɛ kö‑ mɛ ꞊plɛ 'yi‑ 'nëkpɔmɛ 'ka mɛ ꞊gban ꞊plɛ 'ya kë zii!» ");
INSERT INTO daf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'Yö Atanna ‑bha \"kië bha 'ö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Ma 'ö i n ‑ga ya, ma ꞊në 'wo n ‑dhɛ Gabliɛ, ma ꞊në 'a dɔ Atanna wëëdhö ‑a ‑bha \"kië ‑nu kpö 'gü 'yö 'a‑ \"dhiʋ̈ ‑ziö wo, yö ꞊në n bɔ kö 'a nu 'a dhiang zë i ‑dhɛ ꞊dhɛ ‑kɔ bha‑ 'dhö, kö 'a naɔ ‑së bha‑ dɔ i ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","\"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ 'wɔn 'a nu‑ pö i ‑dhɛ 'ö‑ 'gü ‑wɔn ‑nu dho kë ö kë \"tʋ̈ng 'gü bha, 'bhii 'dhang bho‑ \"dhiʋ̈ 'ö bha‑ zaɔ bha, i ‑dho \"gla \"bhʋbhʋ 'gü, 'bhii 'dho \"wɩ 'ö dho 'ö zun‑ 'ka 'wɔn bha‑ kë ‑yi ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","'Ö kë sië \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü bha kö mɛ \"pɛpɛ 'wo gun \"kpɛnng \"yasa 'gü mü bha ‑wo \"yan 'to sië Zakadhi ‑gɔ, kö ꞊gwëë 'ö‑ wo sië Atanna ‑dhɔkëgükɔ 'gü bha‑ 'wɔn ꞊yaa‑ ‑nu 'kɔn. ");
INSERT INTO daf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","꞊Dhɛ 'ö Zakadhi ꞊ya zun \"kpɛnng, 'yii ꞊mɔɔ‑ ‑bha kö ‑yö dhiang zë 'mɛ 'wo bha‑ ‑nu ‑dhɛ kö‑ \"dhi ꞊ya ta. 'Mɛ 'wo bha ‑wa 'wɔn ‑dɔ yö ꞊në‑ ‑wɔn 'gü ꞊dhɛ ‑a \"yan 'gü ꞊në gun ‑da sië 'yö ꞊gwëë 'kɔɔdhö \"dhʋ̈ bha, ‑a ‑gɛn ‑mü ꞊dhɛ kö ‑yö ö ‑kɔ \"paa 'gü ꞊në zë sië‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'ö‑ ‑bha yë ‑kë Atanna ‑gɔ 'kɔɔdhö ‑dhɛkpaɔyi ꞊ya yën, 'yö dho ö ꞊plöö. ");
INSERT INTO daf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","꞊Dhɛ 'ö \"tʋ̈ng 'në bha ꞊ya ziö, 'yö‑ ‑bha dhebhɔ Dhizabɛtö bha 'ö 'gu sü, 'yö ö ‑gblɛn kpɔ 'gu bha‑ 'ka \"su \"sɔɔdhu 'ka kö ‑ya pö sië ö ‑dɩ ‑dhɛ ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«‑Gasitɛ 'dhɛ 'kö ya n Dëmɛ ꞊në yö ‑zë ‑kë n ‑dhɛ, 'yö ö wë bɔ n ‑ta, kë \"dhʋ̈ kö 'ö 'yiʋ̈‑ bho n ‑ta mɛ ꞊zinng 'gü ('yö ꞊ya n kë 'nëkpɔmɛ 'ka ya). ");
INSERT INTO daf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dhizabɛtö ‑bha 'gu bha‑ \"su \"saɔdo ‑naa 'ka, 'yö Atanna ‑yö ö ‑bha \"kië Gabliɛ do bha‑ bɔ 'zü Gadhidhe ‑pö do 'bha 'wo‑ ‑dhɛ Nazadhɛtö ‑a 'gü. ");
INSERT INTO daf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","‑A bɔ 'ö‑ wo \"dhʋ̈ bha ‑ya ‑bɔ ‑dhaagadhee do, 'ö gɔndënë do 'ö ‑kë Davi suu 'gü ꞊në‑ 'ka 'wo‑ ‑dhɛ Zosɛfu bha ꞊yaa‑ ‑za dɔ ꞊në‑ \"piʋ̈. ‑A ‑dhaagadhee 'ö \"dhʋ̈ bha ‑wa ‑dhɛ Madhi. ");
INSERT INTO daf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","꞊Dhɛ 'ö Atanna ‑bha \"kië bha ꞊ya 'dho ꞊ya ‑da Madhi ‑gɔ 'kɔɔdhö 'yö‑ pö‑ ‑dhɛ: «Madhi, 'bha ꞊boo mü,! Atanna ‑yö i \"piʋ̈! Kwa Dëmɛ Atanna ꞊ya ‑gasitɛ 'kpii‑ do kë i ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","꞊Tua bho kë ‑kɔ suu 'ö Atanna ‑bha \"kië ‑ya ‑kë 'ka bha 'yö Madhi \"gblʋ̈ʋ̈dhɛ \"muu bho, 'yö ‑ya ‑a 'klɔɔ‑ mɔɔ‑ ‑sü ‑bha ö ‑dɩ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","‑Yö ‑to ‑a 'klɔɔ‑ mɔɔ‑ ‑dhɛ 'gü 'yö Atanna ‑bha \"kië bha 'ö‑ pö‑ ‑dhɛ: «Madhi, i \"gblʋ̈ʋ̈dhɛ 'ya 'dho \"muu bho, ‑a ‑gɛn ‑mü ꞊dhɛ i ꞊bhlëë ‑yö ‑dhö Atanna wëëdhö. ");
INSERT INTO daf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","‑Dhɛ ‑ga, i ‑dho 'gu sü 'ö 'i 'në do kpɔ. 'Në 'i dho‑ 'kpɔ \"dhʋ̈ bha, 'tɔ 'ka dho‑ ‑dhɛ 'ka ꞊në Yesu 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","'Në bha ‑yö ‑dho \"gla 'ö‑ ‑duɛ ‑yö ‑kë 'kpii‑. ꞊Ya kë \"dhʋ̈ yi 'ö‑ 'ka, ‑wo ‑dho ‑a 'tɔ kpɔ 'wo‑ ‑dhɛ Atanna 'ö ‑ya ‑sü 'ka dhang‑ 'gü ‑a Gbö. Kwa Dëmɛ Atanna ‑dho ‑a \"bhɛma Davi ‑bha ‑gblüdëdhɛ bha‑ nu‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","‑Yö ‑dho mɛdhɛ kë Zakɔbö ‑bha 'kɔdhi bha‑ 'gü ‑todhʋ̈ 'ka 'ö‑ ‑bha mɛdhɛ \"dhiʋ̈todhɛ 'yaa kë.» ");
INSERT INTO daf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","'Yö Madhi ‑ya pö Atanna ‑bha \"kië bha‑ ‑dhɛ 'ö‑ pö: «\"Kɛɛ ‑a 'wɔn 'dhɛ 'kö bha ‑yö ‑dho kë ‑kɔ kë ꞊dhɛ ꞊zɔɔ, n Dëmɛ, kö 'maa gɔɔn‑ ‑wɔn ‑bhokoo 'bha dɔ ya!» ");
INSERT INTO daf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'Yö Atanna ‑bha \"kië bha 'ö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Dhɛ ‑ga, Madhi, Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑dho lɔɔ i ‑ta, Atanna ‑bha 'gügbɩɩdhɛ ꞊në dho 'wɔn bha‑ kë. Yö ꞊në‑ ‑wɔn 'gü, 'yö 'në \"slʋ̈ʋ̈slʋ̈ 'i dho‑ kpɔ bha, 'wo dho‑ ‑dhɛ Atanna Gbö. ");
INSERT INTO daf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","‑Dhɛ ‑ga, Dhizabɛtö 'ö ‑kë i dëbhang dhebhɔ 'ka bha, yöö ‑dɩ 'pö ꞊ya ö ‑bha 'nëgɔɔn do ‑gu 'sü. Yö 'wo gun‑ ‑dhɛ sië ꞊gblöödhe bha 'ö 'gu sü ‑a \"su \"saɔdo ‑naa ꞊nɛ. ");
INSERT INTO daf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","'Pë 'ö‑ ‑wɔn 'gü 'yö 'wɔn ‑nu bha 'wo ‑kë \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ Atanna ‑fiëbhawɔn 'yaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","'Yö Madhi ‑ya pö: «‑Ɛɛ, n Dëmɛ ‑bha gwëëdhe ‑mü n 'ka, ‑yö kë n ‑dhɛ ꞊dhɛ ‑kɔ 'i‑ pö‑ 'ka bha‑ 'dhö!» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Atanna ‑bha \"kië bha 'ö ziö 'ö dho. ");
INSERT INTO daf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","‑A \"tʋ̈ng do bha‑ 'gü, 'yö Madhi ‑yö ꞊wlü 'yö dho ‑bɛang 'ka Zuda ‑pö do 'bha 'ö ‑ya ‑sü 'ka ‑tɔn ‑gbeng 'gü bha‑ 'gü, ");
INSERT INTO daf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","'yö dho 'yö ‑da Zakadhi ‑gɔ 'kɔɔdhö 'yö Dhizabɛtö ꞊tua bho. ");
INSERT INTO daf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","꞊Dhɛ 'ö Dhizabɛtö \"tʋ 'dhö ‑da Madhi ꞊tua bho kë ‑wʋ bha‑ 'gü, 'yö 'në 'ö‑ \"gblʋ̈ʋ̈‑ bha 'ö pa ö diëë 'ka. 'Yö to ‑dhɛ do bha‑ 'gü 'yö pa Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ka, ");
INSERT INTO daf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'yö ꞊gbla \"gbɩɩ‑ 'ka 'ö‑ pö: «Atanna ‑bha 'dhuë‑ ‑yö bhi ꞊në i 'kun ‑sü 'ka dhong‑ ‑nu ꞊gban \"pɛpɛ kpö 'gü, yö ꞊në‑ ‑wɔn 'gü 'yö 'në 'i dho‑ 'kpɔ bha 'dhuë‑ bha 'ö‑ 'kun ‑sü 'ka 'pö. ");
INSERT INTO daf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","‑A kë ‑sü kö ma ‑zë n Dëmɛ dhe ‑yö ‑da n ‑gɔ 'kɔɔdhö, ‑a 'wɔn ꞊në n kɔn! ");
INSERT INTO daf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","‑A ‑gɛn ‑mü ꞊dhɛ ꞊dhɛ 'ö i ‑bha ꞊tua bho kë ‑wʋ ꞊ya ‑da n \"tʋ 'gü bhoo, 'yö to 'yö 'në 'ö n \"gblʋ̈ʋ̈‑ ya 'ö pa ö diëë ꞊niidadhe 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","I ‑bha ‑yö ‑së! ‑A ‑gɛn ‑mü ꞊dhɛ 'pë 'ö n Dëmɛ ‑ya pö 'ö‑ 'gü ‑wɔn dho kë bha i ka 'dhang bho‑ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","'Yö Madhi ‑ya ‑wʋ \"dhiʋ̈ kun 'ö‑ pö: «'Ma n Dëmɛ nuɛ\" bho, 'ma‑ 'badhika ‑ya ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","N zuë\" ꞊nii ꞊ya ‑da ꞊dedewo Atanna 'ö n Dhamɛ 'ka bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ‑wɩ ‑bha 'ö ö \"yan ꞊lɔɔ 'ö‑ ‑da ma 'a ‑kë ‑a ‑bha gwëëdhe 'ö‑ ꞊bhlëë 'yaa 'dhö ‑a 'ka bha n ‑ta. Yö ꞊në‑ ‑wɔn 'gü, 'yö go ꞊dɛɛ ‑bha 'ö dho 'ö zun‑ 'ka \"sɛ \"dhiʋ̈toyi ‑bha 'yö mɛ ꞊gban \"pɛpɛ suu dho‑ pö ꞊dhɛ ma ꞊në n ‑bha 'dhö ‑së. ");
INSERT INTO daf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","‑A ‑gɛn ‑mü ꞊dhɛ 'gügbɩɩ Atanna 'ö‑ 'tɔ 'dhö \"slʋ̈ʋ̈slʋ̈ bha, ꞊ya 'wɔn ‑së 'kpii‑ kë n ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","'Mɛ 'wo ‑suʋ̈ ‑gɔ 'wo‑ ꞊bhlëë ‑ya, ‑a ‑nu ‑wëë ‑dho ‑a kë 'ö‑ \"dhiʋ̈todhɛ 'yaa kë. ");
INSERT INTO daf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yö ꞊në 'wɔn \"gblʋ̈gblʋ̈ ‑nu ‑kë ö ‑kɔ 'ka, faan ‑ya 'gü. Yö ꞊në‑ ‑wɔn 'gü 'yö 'mɛ 'ö ‑dɩ ‑sü 'kpii‑ 'dhö‑ ‑nu 'gü 'yö bhluu\" ma‑ ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yö ꞊në ‑gblüdë \"gblʋ̈gblʋ̈ ‑nu bho ‑yɛa ‑bha. 'Yö 'mɛ 'ö‑ ‑nu ꞊bhlëë 'yaa 'dhö bha‑ ‑nu ‑ya ‑dhɛ \"gblʋ̈gblʋ̈ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yö 'ö bha ꞊në din‑ 'dhö 'mɛ 'ö‑ ‑bha, 'yö‑ ‑mɛ gba ‑bhöpë ‑së ꞊dede 'ka, 'yö ꞊naɔmɛ ‑nu \"piʋ̈ ‑kë, 'yö 'wo dho wo ‑kɔ 'gü \"fië 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yö 'ö bha ꞊në‑ yi to \"dhiʋ̈ ꞊gblɛɛn, 'yö‑ pö kwa \"bhɛma ‑nu ‑dhɛ Ablaamö waa‑ 'gü ‑në ‑nu yi ‑wëë ‑dho ‑a kë \"dhʋ̈ \"dhʋ̈ 'ö‑ ‑naa 'yaa kë. ‑Kɔ do 'ö‑ pö‑ 'ka‑ ‑bha yi 'bha 'ka bha ꞊në 'ö‑ kë ‑sü 'ka‑ ‑bha ꞊dɛɛ, 'yö 'mɛ 'kwa ‑kë Izraɛdhö ‑mɛ ‑nu 'ka, 'yö kwa bho ‑sü 'ka 'wɔn 'gü bha.» ");
INSERT INTO daf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Madhi ‑yö ‑to Dhizabɛtö \"piʋ̈ mü \"su ‑yaaga \"sinma 'ka 'yö gun ‑na 'dho ö ‑dɩ ꞊plöö. ");
INSERT INTO daf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'ö Dhizabɛtö 'në yö \"tʋ̈ng ꞊ya ꞊loo, 'yö dho 'yö \"bɔ bho 'nëgɔɔn do 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","'Wɔn bha ꞊dhɛ 'ö‑ ‑yayɔɔ ‑nu waa‑ 'kpɔmɛ ‑nu ꞊waa‑ ma ꞊dhɛ ‑a ‑wëë ꞊ya Atanna kë ꞊yaa‑ gba 'në 'ka, 'yö ꞊wɛnng ‑nu 'wo‑ ꞊niidadhe ‑kë wo \"kwëë. ");
INSERT INTO daf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","꞊Dhɛ 'ö 'në bha ꞊ya bhɔ, ‑a ‑dhɛkpaɔyi \"saaga ‑naa \"dhiʋ̈ pa ‑yi bha, 'yö mɛ ‑nu ‑wo nu mü kö ‑wa kë 'gbannë 'ka ꞊dhɛ ‑kɔ 'wo‑ ‑kë 'ka ‑a ‑nu wɔ ‑kɔ 'gü ‑a 'dhö. 'Yö 'wo‑ 'tɔ kpɔ‑ dë 'tɔ ‑bha 'wo‑ ‑dhɛ Zakadhi. ");
INSERT INTO daf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","\"Kɛɛ ꞊dhɛ 'ö ꞊waa‑ 'tɔ kpɔ \"dhʋ̈, 'yö‑ dhe ‑ya pö: «‑Abin! 'Në bha ‑wa ‑dhɛ Zan.» ");
INSERT INTO daf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","'Yö 'wo‑ pö‑ ‑dhɛ: «I suu 'gü ‑mɛ ‑mɛɛ ꞊në 'wo‑ ‑dhɛ Zan, 'yö bhii 'në ‑da ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'Yö 'wo wo \"yan zë Zakadhi ‑dhɛ kë \"dhʋ̈ kö ‑yö ö \"dhi ‑da 'wɔn bha‑ 'gü (‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö 'yaa \"wɩ), kö 'tɔ 'ö dho‑ ‑ya 'në bha‑ ‑bha 'wo‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","'Yö Zakadhi ‑yö ö ‑kɔ 'gü zë‑ ‑nu ‑dhɛ kö ‑wo nu ö ‑dhɛ 'kpongpaa 'në 'bha 'ka. ꞊Dhɛ 'ö ꞊wa nu‑ 'ka 'yö 'në bha‑ 'tɔ ‑ya ‑ta 'ö‑ pö ‑wa ‑dhɛ Zan. 'Yö‑ 'wɔn ‑yö mɛ ꞊gban \"pɛpɛ kɔn. ");
INSERT INTO daf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","‑Yö ‑to ‑dhɛ do bha‑ 'gü, 'yö‑ \"dhi ‑yö ‑pʋ, 'yö‑ 'nɛɛga ‑yö go‑ \"dhiëng 'gü 'yö \"wɩ ‑sü zü bho, kö ‑yö Atanna 'tɔ bhɔ sië. ");
INSERT INTO daf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","'Wɔn bha kë 'ö‑ wo \"dhʋ̈ bha, 'yö \"suʋ̈ ‑da mɛ \"pɛpɛ 'wo gun‑ ‑nu ‑züzü bha‑ ‑nu ꞊gban 'gü, 'yö 'wo ‑ya ‑dhiang zë ‑sü ‑bha ‑tɔn 'gü mü ‑dhɛ ꞊gban \"pɛpɛ 'gü Zude ‑sɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","'Yö mɛ \"pɛpɛ 'ö ꞊wa 'wɔn 'ö Zakadhi ‑ya pö 'në bha‑ ‑bu 'gü bha‑ ma, 'yö 'wo‑ ‑da woo‑ ‑gleng \"piʋ̈ kö ‑wa pö sië: «‑A 'në 'kö ya ‑yö ‑dho kë ‑më ꞊në‑ suu 'ka?» \"Kɛɛ 'sa Atanna ‑yö gun 'në bha‑ \"piʋ̈ tɛan‑ ꞊dede 'ka. ");
INSERT INTO daf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'në bha‑ dë 'ö ‑kë Zakadhi 'ka bha, 'yö pa Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ka ‑a \"tʋ̈ng do 'ö‑ ɔngyaa ga ‑yö go‑ 'ka‑ \"dhiëng 'gü bha‑ 'gü, 'yö‑ ‑wʋ \"dhiʋ̈ ꞊loo 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Kwa Dëmɛ 'tɔ ‑yö bhɔ, Izraɛdhö ‑mɛ ‑nu ‑bha Atanna 'tɔ ‑yö ‑bhɔ, ‑a ‑gɛn ‑mü ꞊dhɛ yö 'ö bha ꞊në‑ ‑zʋ ‑yö ‑bö kwa ‑wɔn 'ka, 'yö nu 'ö kwa ‑gɔ ‑ta dhɔ. ");
INSERT INTO daf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","'Yö mɛ 'gügbɩɩ do 'ö dho kë kwa Dhamɛ 'ka, ‑a sü ‑a ‑bha gwëëmi Davi suu 'gü 'yö‑ bɔ kwa ‑dhɛ ");
INSERT INTO daf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","꞊dhɛ ‑kɔ 'ö‑ ‑dhiang zë‑ 'ka, ‑a ‑wʋdhiʋ̈loomɛ ‑nu 'wo \"slʋ̈ʋ̈slʋ̈ ‑a ‑nu \"dhi 'gü yi 'bha 'ka bha‑ 'dhö, ");
INSERT INTO daf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","꞊dhɛ ö ‑dho Mɛdhamɛ do 'ö dho kwa bho kwa 'yaɔ‑ ‑nu waa‑ 'mɛ 'ö kwa ‑san ‑ya ‑nu ‑kë ‑a ‑nu ꞊kwɛɛ‑ ‑a bɔ. ");
INSERT INTO daf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kwa \"bhɛma ‑nu ‑wëë ‑ya ‑kë ‑kɔ bha ꞊në‑ 'gü, 'yö‑ ‑zʋ ‑yö ‑bö ‑mlɛɛ \"slʋ̈ʋ̈slʋ̈ 'ö‑ ‑da wɛng‑ ‑nu ‑a ‑nu ꞊zinng 'gü yi bha‑ 'ka bha‑ ‑ta, ");
INSERT INTO daf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","‑yö \"plüün bha‑ ‑bho \"dhʋ̈ 'ö ‑sö ‑bhö 'ka kwa 'ziʋ̈‑ Ablaamö ꞊në‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kë \"dhʋ̈ kö 'ya kwa dha kwa 'yaɔ‑ ‑nu ‑gɔ kö 'kwa 'dho‑ ‑dhɔkë \"suʋ̈ 'ka, ");
INSERT INTO daf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","\"kɛɛ kö 'kwa kë mɛ 'ö \"slʋ̈ʋ̈slʋ̈ 'ö pö 'aa‑ ‑bha ‑a 'ka ö wëëdhö kö ‑yö 'to‑ 'ka \"dhʋ̈ ‑yö zun‑ 'ka kwa ga ‑yi ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","'Yö ꞊në‑ ‑wɔn 'gü, 'yö bhi 'i bha ma 'në, 'yö 'wo dho i ‑dhɛ Atanna 'ö ‑ya ‑sü 'ka dhang‑ 'gü ‑a ‑wʋdhiʋ̈loomɛ; ‑a ‑gɛn ‑mü ꞊dhɛ bhi ꞊në 'i dho ‑da kwa Dëmɛ bha‑ ‑dhɛ \"dhiʋ̈, 'yö 'i‑ ‑bɔ ‑ta ‑zian ꞊baa, ");
INSERT INTO daf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","'yö 'i‑ ‑wɔn \"dhiʋ̈ ꞊loo‑ ‑gɔ \"sɛgümɛ ‑nu ‑bha 'yö 'wo‑ dɔ ꞊dhɛ yö ꞊në dho‑ ‑nu dha, 'yö‑ ‑nu ‑bha 'wɔn yaa ‑nu 'wo‑ ‑kë bha‑ ‑nu ‑mawɔn to. ");
INSERT INTO daf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","‑A ‑gɛn ‑mü ꞊dhɛ mɛ \"bhɩɩ‑ ‑nu kwa ‑wëë 'ö kwa Dë Atanna ‑kë bha‑ \"sinma \"yɔɔ 'yaa 'dhö, ‑gasitɛ 'yii‑ ‑bha mɛ ‑wëë ‑bha ‑a kë zuëga bha ꞊në‑ ꞊slɔɔ, 'yö‑ ‑bha mɛdhɛ 'ö go dhang‑ 'gü bha‑ 'bhü ꞊ya 'sɔ ‑sü zü bho kwa ‑ta ꞊dhɛ 'yënng‑ \"tɛɛ 'bhü 'dhö bha, ");
INSERT INTO daf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kë \"dhʋ̈ kö 'mɛ 'wo \"ta sië \"yënng tii 'gü, 'ö ga dhɔng ꞊ya kpa ‑nu ‑ta bha, kö ‑yö ‑dhɛ \"pʋ wo ꞊në‑ ‑nu ‑ta, kë \"dhʋ̈ kö ‑yö ‑to 'ko ‑dhɛ ‑së ‑zian bho kwa 'ka.» Zakadhi ‑yö 'tɔ ‑loo Atanna ‑bha ‑kɔ bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö 'në bha 'ö ‑gla, \"kɛɛ 'yö kë \"yaakimɛ ꞊dede 'ka, 'yö dho 'ö ‑ya \"tʋngtadhɛ 'bha 'gü, 'yö to 'mü 'ö dho 'ö zun‑ 'ka ‑a ‑dɩ ‑zɔn Izraɛdhö ‑sɛgümɛ ‑nu ‑dhɛ ‑yi ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","‑A \"tʋ̈ng do bha ꞊në‑ 'gü 'yö \"sɛkɔɔnmɛ 'kpii‑ 'ö gun Wlɔmö ‑sɛ ‑gɔ \"dhiʋ̈ 'wo gun‑ ‑dhɛ sië Sezaa Wogisi bha 'ö mɛ bɔ ‑a ‑bha \"sɛ ‑ta ‑dhɛ ꞊gban \"pɛpɛ 'gü kö ‑wo mɛ ꞊gban dhʋng. ");
INSERT INTO daf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mɛ dhʋng ‑kɔ ‑blɛɛsü 'ö \"dhʋ̈ bha 'ö ‑kë kö 'mɛ 'ö ‑gblüdë bha‑ ‑kɔdhiʋ̈mɛ 'ka Siidhi ‑sɛ 'gü ‑wa ‑dhɛ Kidhinisö. ");
INSERT INTO daf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","'Yö mɛ ꞊gban \"pɛpɛ 'wo ‑ya 'dho ‑sü ‑bha wo 'kpɔpö ‑nu 'gü kö ‑wo wo dhʋng mü. ");
INSERT INTO daf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","'Ö gun \"dhʋ̈ kö Zosɛfu ‑yö ‑ya ‑sü 'ka 'pödhɛ 'wo‑ ‑dhɛ Nazadhɛtö 'ö Gadhidhe ‑sɛ 'gü bha‑ 'gü. ꞊Dhɛ 'ö ꞊yaa‑ ma ꞊dhɛ mɛ ꞊gban ‑wo 'dho sië wo 'kpɔpö ‑nu 'gü, 'yö ꞊wlü 'pö 'yö dho Betedhɛmö, ‑gblüdë Davi ‑bha 'pödhɛ 'ö Zude ‑sɛ 'gü bha‑ 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö go Davi ‑gɔ 'kɔɔdhö, Davi suu 'gü ‑në ‑mü ‑a 'ka. ");
INSERT INTO daf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","‑Yö ‑dho \"dhʋ̈ kö 'ö waa‑ Madhi wo dhʋng mü, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊ya Madhi ‑za dɔ kö 'ö‑ 'sü dhe 'ka. 'Sa 'wo gun 'dho sië‑ \"dhʋ̈ \"tʋ̈ng 'ö‑ 'ka bha kö Madhi ‑yö 'gbiödhe 'ka. ");
INSERT INTO daf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo Betedhɛmö, 'ö Zosɛfu 'dhö 'wɔn bha‑ 'gü ‑ziö ‑nu wo sië, 'yö Madhi \"bɔ bho \"tʋ̈ng ‑yö ꞊loo. ");
INSERT INTO daf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'Yö ö ‑bha 'nëgɔɔn ‑blɛɛsü bha‑ kpɔ 'kɔ 'wo gun‑ 'gü bha‑ 'gü. ꞊Dhɛ 'ö 'në bha ꞊ya bhɔ, 'yö sɔ bɔ‑ ‑bha 'yö‑ ‑wɔ ‑tuʋ̈ ‑nu pë ‑bhö ‑dhɛ 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊wa ‑dhɛng ꞊yëë bho 'kɔ 'wo gun‑ 'gü bha‑ wɔdhɛ ‑zë 'gü. ");
INSERT INTO daf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","‑Tuʋ̈ ‑maakëmɛ 'bha ‑nu ‑wo ‑gun Zude \"sɛgɔ bha‑ gbɛɛtadhɛ 'bha 'gü mü. ");
INSERT INTO daf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'Mɛ 'wo bha 'wo dho \"kan wo ‑ta kö Atanna ‑bha \"kië do ꞊ya ‑wo ‑nu ‑ta kö‑ ‑bha ‑gblüdëdhɛ 'bhü 'ö ꞊dhɛ 'yënng‑ 'bhü 'dhö bha ꞊ya 'sɔ‑ ‑nu ‑ta, 'yö pɛng ‑yö ‑kan ‑nu ‑bha \"wɛ ‑budhö, 'yö \"suʋ̈ ‑ziisü ‑yö ‑da ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","\"Kɛɛ 'yö Atanna ‑bha \"kië bha 'ö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «\"Suʋ̈ 'ya 'dho ka kë, ‑a ‑gɛn ‑mü ꞊dhɛ naɔ 'a nu‑ dɔ ka ‑gɔ bha‑ 'gü ‑wɔn ‑dho dhi \"sɛgümɛ ‑nu ꞊gban \"pɛpɛ ‑dhɛ 'ö‑ ‑nu ꞊nii ‑da ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yö ‑mü ꞊dhɛ Atanna ‑bha bɔmɛ Klisi 'ö‑ ‑ya Mɛdhamɛ 'ka, kwa Dëmɛ bha ꞊në ꞊ya bhɔ ꞊dɛɛ Davi ‑gɔ 'pödhö. ");
INSERT INTO daf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","(‑Ka 'dho kö 'ka ‑wo mü), ꞊ya kë ꞊dhɛ 'ka 'dho 'ka ꞊loo mü, pë 'ka dho‑ 'suan‑ bho‑ ‑bha ꞊dhɛ 'wɔn 'a‑ pö bha tɛan‑ ‑mü, ꞊dhɛ Mɛdhamɛ bha ꞊ya bhɔ, yö ‑mü ꞊dhɛ ka ‑dho ‑kpan 'në do 'ö sɔ 'dhö bɔ ‑sü 'ka‑ ‑bha ‑a ‑bha kö ‑wa wɔ ‑sü 'ka ‑tuʋ̈ ‑nu pë ‑bhö ‑dhɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","꞊Dhɛ 'ö Atanna ‑bha \"kië bha ꞊yaa‑ pö \"dhʋ̈, 'wo dho \"kan 'zü wo ‑ta kö‑ kpö 'kpii‑ 'bha ꞊ya nu 'zü kö ꞊wa ‑da mɛ 'dhɛ bha‑ ‑bha kö ‑wo \"yʋʋ 'sü sië Atanna ‑dhɛ (\"tan 'ka) 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Atanna 'i dhang‑ 'gü, kwaa‑ \"yʋʋ ‑mü! Kwaa‑ \"yʋʋ ‑mü! I 'tɔ ‑yö bhɔ, ‑a ‑gɛn ‑mü ꞊dhɛ \"kpʋngtaamɛ ‑nu ‑dhɔ ‑yö i ‑kë, ‑a ‑wɔn 'gü 'bha i ‑bha zuë\" ‑ya \"gblʋ̈ʋ̈‑ 'ö dhang‑ 'gü bha‑ nu‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","꞊Dhɛ 'ö Atanna ‑bha \"kië ‑nu bha ꞊wa ‑wawa bho \"dhʋ̈ 'ö ꞊wa wo yee kë ꞊wa 'dho dhang‑ 'gü, 'yö ‑tuʋ̈ ‑maakëmɛ ‑nu bha 'wo‑ pö wo 'ko ‑dhɛ: «‑Ka nu kö 'kwa 'dho Betedhɛmö kö 'wɔn ‑së 'ö Atanna ‑ya ‑kë 'ö‑ \"blɛɛn‑ ‑zɔn kwa ‑dhɛ bha kwa \"yan ‑yö ‑da ‑dhɛ 'gü!» ");
INSERT INTO daf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","'Yö 'wo dɔ ‑bɛang ‑bha 'wo dho 'mü. 'Yö 'wo dho 'wo ‑kpan Zosɛfu waa‑ Madhi ‑a ‑nu ‑bha kö 'në bha 'pö ‑yö wɔ sië ‑tuʋ̈ pë ‑bhö ‑dhɛ 'gü ‑a ‑nu \"sɔɔ mü. ");
INSERT INTO daf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","꞊Dhɛ 'wo 'në bha‑ yö, 'yö 'wɔn 'ö Atanna ‑bha \"kië ‑ya pö‑ ‑nu ‑dhɛ 'në bha‑ ‑bu 'gü bha 'wo‑ ‑gɛn dɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","'Wɔn 'ö ‑tuʋ̈ ‑maakëmɛ ‑nu ‑wa ‑gɛn dɔ bha mɛ \"pɛpɛ 'kö 'wo‑ ma, 'yö‑ 'wɔn ‑ya ‑nu ꞊gban kɔn, ");
INSERT INTO daf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","\"kɛɛ kö Madhi ‑zë ‑ya 'kun ꞊në wo sië ö zuë\" \"piʋ̈ 'ö ö \"yan ‑ta 'gü 'ö dho‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö ‑tuʋ̈ ‑maakëmɛ ‑nu bha 'wo wo yee ‑kë 'wo dho wo ꞊plöö kö ‑wo Atanna nuɛ\" bho sië 'ö 'wo 'tɔ ꞊loo‑ ‑bha 'wɔn ‑nu 'ö‑ ‑nu \"yan 'dhö ‑da 'gü waa‑ 'dhɛ ‑nu 'wo‑ ma bha kë 'ö‑ wo tɛan‑ 'ka ꞊dhɛ ‑kɔ 'ö‑ ‑bha \"kië ‑ya pö 'ka‑ ‑nu ‑dhɛ ‑a 'dhö bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","꞊Dhɛ 'ö Yesu ꞊ya bhɔ 'ö‑ ‑dhɛkpaɔyi ꞊ya kë \"saaga, 'yö mɛ ‑nu ‑wo nu kö ‑wa kë 'gbannë 'ka. 'Yö‑ 'tɔ 'ö Atanna ‑bha \"kië ‑ya kpɔ kö 'wii‑ ‑gu ‑zian 'sü ꞊kö bha 'wo‑ ‑ya ‑bha, 'yö 'wo‑ pö ‑wa ‑dhɛ Yesu. ");
INSERT INTO daf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","꞊Dhɛ 'ö ‑dhɛkpaɔyi 'ö dhebhɔ 'ö ꞊ya \"bɔ bho 'ö‑ ‑kë 'kɔɔdhö 'yö gun ‑na 'dho Atanna ‑dhɔkëgükɔ 'gü ꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka‑ 'ka ‑a ‑bha 'tɔng‑ 'sëëdhɛ 'ö Moizö ‑ya ‑bɛn zë bha‑ 'gü bha‑ 'dhö, 'ö‑ ‑dhɛkpaɔyi ‑kaɔng ‑yiisiö 'ka bha ꞊ya zun 'ko \"dhiʋ̈, 'yö Zosɛfu waa‑ Madhi 'wo Yesu sü 'wo dho‑ 'ka Zedhizadhɛmö kö 'wo‑ \"kplëng bho kwa Dëmɛ ‑dhɛ ");
INSERT INTO daf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka‑ 'ka Atanna ‑bha 'tɔng‑ 'sëëdhɛ 'gü ꞊dhɛ: «'Nëgɔɔn ‑blɛɛsü \"pɛpɛ 'ka dho‑ 'kpɔ, ka ‑dho ‑a \"kplëng bho Atanna ‑dhɛ» bha‑ 'dhö. Kë 'pö \"dhʋ̈ kö‑ 'dhɛ 'ö ‑bɛn zë ‑sü 'ka 'pö ꞊dhɛ ꞊ya kë 'zü \"dhʋ̈: ");
INSERT INTO daf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","«'Ka ‑tong ꞊plɛ \"ɛɛn ‑a suu 'bha 'ö mü bha‑ \"gbɔng ꞊plɛ nu \"saabhomɛ ‑nu ‑dhɛ kö ‑wo \"saa‑ bho‑ 'ka Atanna \"dhiʋ̈» bha ‑wa 'gü ‑wɔn kë ꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka‑ 'ka ‑a 'dhö (kë \"dhʋ̈ 'pö kö Madhi ‑yö kë \"slʋ̈ʋ̈slʋ̈). ");
INSERT INTO daf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","‑A \"tʋ̈ng do bha‑ 'gü kö gɔndë do 'bha ‑yö Zedhizadhɛmö ‑pö bha‑ 'gü 'wo‑ ‑dhɛ Simeɔn. 'Mɛ 'ö ꞊sɔng 'bha 'yaa‑ ‑bha, 'ö Atanna ꞊bhlëë ‑ya ꞊dedewo ꞊në gun gɔndënë bha‑ 'ka. 'Sa 'ö gun \"dhʋ̈ kö ‑yö ö \"yan 'to sië 'mɛ 'ö dho Izraɛdhö ‑mɛ ‑nu dha bha ꞊në‑ ‑gɔ. Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑yö ‑gun 'gü. ");
INSERT INTO daf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","'Ö gun \"dhʋ̈ kö Atanna ꞊ya bɔ 'nu ö bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑ta kö Yesu bhɔ \"tʋ̈ng ‑zian 'yii ꞊loo ꞊kö kö ꞊yaa‑ pö Simeɔn ‑dhɛ ꞊dhɛ 'yii 'dho ga kö 'yii ö \"yan ‑kpan ꞊kö 'mɛ 'ö kwa Dëmɛ ‑ya ‑ya Izraɛdhö ‑mɛ ‑nu Dhamɛ 'ka bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","‑A ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ do bha ꞊në zun 'zü‑ ‑dhɛ \"dhiʋ̈ 'yi bha‑ 'ka 'yö dho‑ 'ka Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gü. ꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo mü, 'ö dho ‑dhɛ ‑ga kö Yesu dë ‑nu ‑wo nu sië‑ 'ka kö 'pë 'ö Atanna ‑bha 'tɔng‑ ‑ya pö bha ‑wa 'gü ‑wɔn kë. ");
INSERT INTO daf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","꞊Dhɛ 'ö ꞊yaa‑ ‑nu yö, 'yö ö ‑kɔ kpɔ 'në bha‑ ‑gɔ 'yö 'tɔ ꞊loo Atanna ‑bha 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«‑A \"tʋ̈ng ꞊ya ꞊loo ꞊tɔn, n Dëmɛ, kö 'i i ‑kɔ bho ma 'a i ‑bha gwëëmi 'ka bha n 'gü, kö 'a nu i \"piʋ̈ zuëniida 'ka ꞊dhɛ ‑kɔ 'ö i ‑wʋ ‑ya pö‑ 'ka ‑a 'dhö; ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn 'i‑ yi to \"dhiʋ̈ 'i‑ \"plüün bho yi ‑dhɛ bha‑ 'gü ‑wɔn ꞊ya kë. ");
INSERT INTO daf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","‑A ‑gɛn ‑mü ꞊dhɛ Mɛdhamɛ 'i‑ bɔ 'ö 'i‑ ‑ya \"sɛgɔ ꞊gban \"pɛpɛ Dhamɛ 'ka bha, mang ꞊dede n \"yanga ꞊plɛ ꞊ya ‑kpan ‑a ‑kponggüdhɛ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","'Mɛ 'ö dho kë \"sɛgɔ \"pɛpɛ ꞊gban 'gü ‑mɛ ‑nu ‑bha ‑dhɛpuudhɛ 'ka, 'ö dho‑ ‑nu \"yan \"dhiʋ̈ \"pʋ kö ‑wo i dɔ, 'ö dho Izraɛdhö ‑mɛ ‑nu 'i yi sü 'i yi ‑ya ‑dɩ ‑ta i ‑bha 'ka bha yi 'tɔ ‑wo bha 'ma‑ yö.» ");
INSERT INTO daf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dhiang ‑nu 'ö Simeɔn gun‑ zë sië Yesu ‑bu 'gü \"dhʋ̈ bha, ‑ya dhe waa‑ dë ‑a ‑nu ‑kɔn. ");
INSERT INTO daf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'dhuë‑ ‑kë ‑nu ‑bha, 'yö go mü 'ö‑ pö Yesu dhe Madhi ‑dhɛ: «'Në 'i‑ kpɔ bha, Atanna ‑ya ‑ya kö ‑yö kë Izraɛdhö ‑sɛgümɛ ‑nu 'bha ‑nu ‑pö ‑bha ‑pë 'ka, \"kɛɛ kö ‑yö kë mɛ 'bha ‑nu ‑dɩ 'pö ‑a ‑nu ‑wlübhamɛ 'ka. ‑Yö ‑dho kë Atanna ‑bha 'wɔn 'suan‑ ‑bho ‑bha ‑mɛ ꞊në‑ 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ mɛ \"bhɩɩ‑ ‑nu ‑dho wo ꞊taa zun‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yö ꞊në dho kë 'wɔn ‑nu 'wo ‑gblɛn 'kpɔ ‑sü 'ka mɛ 'gbɛ zuë\" \"piʋ̈ bha‑ ‑nu ‑wo zangtamɛ 'ka. \"Kɛɛ bhi ‑zë, i ‑bha 'ka zuë\" \"dhiʋ̈ \"tɛɛ‑ ‑dho i zuë\" ‑gi ꞊dhɛ ‑kɔ 'ö ‑siangga ‑yö mɛ zua 'ka bha‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","‑A \"tʋ̈ng do bha‑ 'gü, Atanna ‑wʋ \"dhiʋ̈ ꞊loo ‑dhe do 'bha ‑yö ‑gun \"sɛ bha‑ 'gü 'wo‑ ‑dhɛ Anö, 'ö kë Fanuɛ 'dhu 'ka, 'ö go Asɛɛ ‑gɔ 'kɔdhi 'gü. Dhebhɔ bha 'ö gun \"dhʋ̈ kö ꞊ya kë zii ꞊dedewo, \"kɛɛ kö 'ö dho gwaan‑ ‑bha ‑yö ‑kwɛ ‑kë mü \"saɔplɛ, 'yö‑ ‑bha gɔn ‑yö ga. ");
INSERT INTO daf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","‑A ꞊gɛandhe ‑sü bha kö‑ ‑kwɛ ꞊ya kë ‑kaɔng \"saaga ö ga ‑yiisiö, \"kɛɛ 'yaa 'go Atanna ‑dhɔkëgükɔ 'gü tongtongdhö kö ‑yö 'dho ‑dhɛ 'bha 'gü. Kö ‑ya ‑dhɔkë 'yënng‑ 'gü waa gbeng ‑nu ꞊gban 'gü ‑bhɛa ‑a ‑dhɛ ‑sü waa‑ 'sunng‑ 'ma ‑sü ‑nu 'ka ‑kpɛawo. ");
INSERT INTO daf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yöö ‑dɩ 'pö ‑yö ꞊loo mü \"tʋ̈ng ꞊dede 'wo dho Yesu 'ka ‑a 'gü mü bha ꞊në‑ 'gü. ꞊Dhɛ 'ö Yesu \"blë \"puu bha‑ yö, 'yö ‑ya Atanna nuɛ\" bho ‑sü ‑bha, 'yö dho‑ ‑wɔn ‑gɛn dɔ ‑sü 'ka mɛ \"pɛpɛ 'ö‑ ‑nu \"yan ‑yö gun Zedhizadhɛmö ‑dhɛ ‑bho ꞊dhuëngdhɛ 'gü ‑yi ‑gɔ bha‑ ‑nu ꞊gban \"pɛpɛ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","꞊Dhɛ 'ö 'mɛ 'wo bha ꞊wa 'wɔn 'ö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'tɔng‑ 'gü bha‑ ꞊gban 'gü \"ta sü 'ö ꞊ya ꞊mɔɔ \"kwëë, 'yö Zosɛfu waa‑ Madhi 'wo wo yee ‑kë 'wo nu ‑a ‑nu ‑gɔ 'pödhö Nazadhɛtö, Gadhidhe ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","'Në bha ‑yö ‑gla 'pö‑ bha ꞊në‑ 'gü, 'yö ‑kë faanmɛ 'ka, ‑yö ‑gun \"yaakimɛ ꞊dede 'ka, 'yö Atanna ‑yö gun‑ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesu 'kpɔmɛ ‑nu ‑wo ‑gun 'dho sië Pakö troo ‑ta Zedhizadhɛmö ‑kwɛ ꞊gban \"pɛpɛ ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","꞊Dhɛ 'ö Yesu ‑kwɛ ꞊ya kë ‑kaɔng do ga ꞊plɛ 'ö Pakö yi bha‑ 'bha ꞊ya ꞊loo, 'yö 'wo dho 'zü ꞊dhɛ ‑kɔ do 'wo dho‑ 'ka zii 'kpa ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","꞊Dhɛ 'ö ꞊wa 'dho 'ö ꞊wa troo bha‑ kë ꞊ya yën, 'ö 'wo wo yee kë sië kö ‑wo nu wo ꞊plöö, 'yö Yesu ‑yö to Zedhizadhɛmö \"kɛɛ ‑a dhe waa‑ dë 'wii 'wɔn ꞊slɔɔ‑ 'gü, ");
INSERT INTO daf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","kö ‑wo wo ‑zʋ 'gɔn sië ꞊dhɛ ‑yö wo \"tayɔɔ ‑nu kpö 'gü. ꞊Dhɛ 'ö ꞊wa ‑dhɛkpaɔyi do \"ta sü, 'yö 'wo ‑ya ‑a mɔɔ‑ ‑sü ‑bha woo‑ mɛ ‑nu waa‑ ‑a ‑nu dɔmɛ ‑nu \"wɛɛwɛɛ ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","꞊Dhɛ 'ö ꞊waa‑ mɔɔ‑ \"dhʋ̈ 'ö 'wii‑ yö, 'yö 'wo wo yee ‑kë 'zü ‑deewo 'wo dho Zedhizadhɛmö ‑a mɔɔ‑ ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","‑Wa ‑mɔɔ ‑dhɛkpaɔyi ‑yaaga. ‑A ‑yaaga ‑naa bha‑ 'ka 'yö 'wo dho 'wo ‑kpan ‑bha Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gü, kö ‑yö ‑ya sië mɛ ‑nu ‑draan Atanna ‑wʋ ‑bha ‑mɛ ‑nu ‑gɔmɛ \"gblʋ̈gblʋ̈ ‑nu bha‑ ‑nu kpö 'gü, 'ö ö \"tʋ 'to‑ ‑nu ‑wʋ ‑bha 'ö‑ ‑nu dhɛɛ\" ‑nu 'kpɔ. ");
INSERT INTO daf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Dhiang ‑yɔ ‑nu 'ö gun‑ bɔ sië, waa‑ dhɛɛ\" ‑nu 'ö‑ kpɔ bha 'mɛ 'wo‑ ma, ‑a 'wɔn ‑ya ‑nu ‑kɔn ꞊dedewo ꞊kpaɔdhɛ 'ö gun‑ ‑gɔ waa‑ dhiang ‑yɔ bɔ ‑kɔ ‑nu bha‑ ‑nu ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","꞊Dhɛ 'ö‑ 'kpɔmɛ ‑nu ꞊waa‑ yö, 'yö‑ 'wɔn ‑ya ‑nu kɔn. 'Yö‑ dhe ‑ya pö‑ ‑dhɛ 'ö‑ pö: «Yesu n gbö, ‑më ‑wɔn suu ꞊në 'i‑ kë yi 'ka \"dhʋ̈? 'Bha yi zuë\" ‑ya \"yi ‑ta \"gbɩɩ‑ ‑wa! Yaa‑ i dë 'yi ‑bhɔ i mɔɔ‑ ‑sü 'ka ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa ꞊nɛ. ");
INSERT INTO daf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Ka n ‑mɔɔ ‑më 'ka? \"Ɛɛn ‑a 'wɔn 'yaa ka \"yaan ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'a n dë ‑gɔ ‑wɔn ‑nu kë ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","\"Kɛɛ ‑a pö 'ö Yesu ‑ya wo \"dhʋ̈ bha 'wii‑ 'gü ma‑ 'klɔɔ‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö wɛng‑ ‑nu 'wo ‑ziö 'wo dho Nazadhɛtö, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑gun ‑a ‑nu ꞊bhlëë ‑ya sië ꞊dedewo. 'Wɔn \"pɛpɛ 'wo gun‑ kë sië \"dhʋ̈ bha kö ‑a dhe ‑dɩ 'pö ‑ya 'kun sië ö zuë\" \"piʋ̈ ‑dhɛkpaɔ dhia\" ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kö Yesu ‑dɩ 'pö ‑yö \"gla sië, 'ö‑ ‑bha ꞊kpaɔdhɛ ‑ta ‑yö ‑da, 'ö‑ ‑dhɔ ‑yö Atanna ‑kë waa‑ mɛ \"bhɩɩ‑ ‑nu ꞊gban 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","\"Tʋ̈ng 'ö Tibɛɛ ‑yö gun‑ 'ka \"sɛkɔɔnmɛ 'kpii‑ 'ka bha‑ ‑kwɛ ‑kaɔng do ga \"sɔɔdhu ‑naa 'ka, kö Pɔngsö Pidhatö ꞊në Zude ‑sɛgɔdhiʋ̈, 'yö Edhodö 'dhö Gadhidhe ‑sɛ 'gü 'pö, kö Edhodö dheebhang 'wo‑ Fidhipö ‑kë 'pö bha ‑yö Itudhö ‑sɛ waa‑ Trasonitö ‑sɛ 'gü, kö mɛ 'dhɛ 'wo‑ ‑dhɛ Dhizania bha ‑yö Abidhɛnö ‑sɛ 'gü 'pö, 'yö Atanna ‑yö dhiang zë Zan 'ö ‑kë Zakadhi gbö 'ka bha‑ ‑dhɛ \"tʋng ‑ta. ‑A \"tʋ̈ng bha‑ 'gü 'pö kö 'mɛ 'wo \"saabhomɛ \"gblʋ̈gblʋ̈ ‑nu 'ka Izraɛdhö ‑sɛ 'gü ‑wa mɛ do ‑dhɛ Anö 'ö 'wo‑ mɛ do ‑dhɛ Kaifö. ");
INSERT INTO daf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","꞊Dhɛ 'ö Zan ꞊ya Atanna ‑wʋ ma ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö ꞊wlü 'yö dho 'ö ‑da ꞊gwaanga 'wo‑ Zuudɛn ‑kë bha‑ \"piʋ̈, \"sɛgɔ ‑nu 'wo mü bha‑ ‑nu 'gü 'do 'do 'ka, 'yö ö ‑wʋ \"dhiʋ̈ ꞊wlü \"gbɩɩ‑ 'ka mɛ \"bhɩɩ‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka nu kö 'ka bɔ Atanna 'ka kö ‑wo ka ‑go 'wɔn yaa 'gü ‑zu bho kö ‑yö ka këwɔn yaa ‑nu ‑mawɔn 'to; ");
INSERT INTO daf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","꞊dhɛ ‑kɔ 'ö‑ ‑wʋdhiʋ̈loomɛ Ezai ‑ya ‑bɛn zë‑ 'ka ö ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: ‹Mɛ 'bha ꞊në ‑dhɛa \"dhiʋ̈ bho sië \"tʋng ‑ta bha. ‑A ‑mɛ ‑ya ‑pö: ‑Ka kwa Dëmɛ ‑ziö ‑ta ‑zian baa‑ kö 'ka‑ dɔ ꞊zinng 'gü kpengdhö. ");
INSERT INTO daf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kö 'ka ‑tɔn ‑gbeng 'gü ‑dhɛ ‑nu ta, kö 'ka ‑tɔn ‑nu waa‑ \"trʋʋ ‑nu 'wü, kö‑ ‑dhɛ ‑yö wɔ ‑tɛkpɛ ‑tɛkpɛdhö, kö 'ka zian dudu ‑nu bho‑ 'gü, kö‑ ‑tadhɛ 'ö yanggeedhö ‑dhɛ ‑nu 'ö‑ 'gü kö 'ka‑ ‑dhɛ ‑pë kë \"pɛɛpɛdhö. ");
INSERT INTO daf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","꞊Ya kë \"dhʋ̈ Atanna dho ö ‑bha Mɛdhamɛ 'ö‑ bɔ bha mɛ ꞊gban ‑dho ‑a yö› bha‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü mɛ kpö‑ ‑gun 'dho sië yi ꞊gban 'ka Zan \"piʋ̈ kö ‑ya ‑nu \"zu. \"Kɛɛ ꞊wa 'dho \"dhʋ̈ 'yö‑ pö‑ ‑nu ‑dhɛ: «Suuyaamɛ ‑nu 'ö 'kaa ka ‑dɩ dɔ 'ka ya! Za 'kpii‑ 'ö Atanna dho‑ dɔ ka ‑bha ‑dhɛ 'bha ꞊kpaɔyi ‑bha bha de ꞊në ‑dua ‑gɔ ‑sü ‑gleng ‑da ka ‑bha? ");
INSERT INTO daf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'Ö ꞊ya kë ꞊dhɛ 'ka ka bo ka sɔng 'ka ꞊dedewo tɛan‑ 'ka kö ‑kaa ‑zɔn ka \"ta ‑kɔ ‑bha kö mɛ ꞊gban ‑wa ‑dhɛ yö ꞊dhɛ 'ka ka zuë\" slëë\" ꞊dedewo tɛan‑ 'ka, 'ka 'dho‑ pö ka ‑dɩ ‑dhɛ ꞊dhɛ Ablaamö suu ‑mü ka 'ka ('ö \"dhʋ̈ kö Atanna ‑bha 'në ‑nu ‑mü ka 'ka ꞊naa bha), ‑a ‑gɛn ‑mü ꞊dhɛ a‑ pö ka ‑dhɛ ꞊dhɛ ‑yö ‑mɔɔ ‑bha 'ö ‑gwë ‑nu ya‑ ‑nu ‑gla Ablaamö suu 'gü ‑në ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","꞊Dua ‑zian ‑yö ‑ya ‑sü 'ka \"dhü ‑bho \"sɛɛ ‑yan ‑ta 'nu ‑blɛɛsü. ‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, \"dhü 'ö 'yaa bhɛ ‑së dɔ ‑a \"kan ꞊në yöö wo kö ‑yö \"gʋ̈.» ");
INSERT INTO daf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","‑A pö 'ö Zan ‑ya wo \"dhʋ̈ bha, 'yö mɛ \"dhaa 'wo gun mü bha 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «'Ö \"dhʋ̈ 'sa 'yi‑ kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","꞊Dhɛ 'ö ꞊wa dhɛɛ\" bha‑ 'kpɔ, 'yö Zan ‑ya ‑yɔ bɔ 'ö‑ pö: «‑Ka 'dho kö \"bhɛɛ ꞊plɛ 'dhö 'mɛɛ‑ ‑gɔ, kö ‑ya do ꞊gbaɔ‑ 'bha 'yaa 'mɛɛ‑ ‑gɔ bha‑ ‑gɔ. Kö ‑bhöpë 'dhö 'mɛɛ‑ ‑gɔ ‑a ‑mɛ ‑ya 'gü ‑gblü kö ‑yö pë 'bha 'yaa 'mɛɛ‑ ‑gɔ ‑a ‑bha nu.» ");
INSERT INTO daf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'ö ꞊ya ö bo, 'yö 'mɛ 'wo ‑kë 'niisɔngkunmɛ ‑nu 'ka 'wo nu 'pö wo \"zu ‑wɔn 'gü ‑a \"piʋ̈, 'yö 'wo‑ dhɛɛ\" kpɔ 'pö 'wo‑ pö: «Yi dëmɛ, 'yö yi ‑zë ꞊wɛ, 'yi‑ kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'ka 'dho 'wëë‑ 'kun ‑dhɛ 'gü, ‑a 'dhɛ 'wo‑ \"dhi pö ka ‑dhɛ bha ꞊në ‑kaa 'kun, 'ka 'dho ziö yö ‑zë ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","꞊Dhɛ 'ö ꞊ya ‑wʋ 'kpɔ mɛ 'dhɛ bha‑ ‑nu ‑bha, 'yö \"sɔdha ‑nu ‑dɩ 'pö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «'Yö yi ‑zë ꞊wɛ?» 'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'pö 'ö‑ pö: «'Ka 'dho ‑pö mɛ 'bha ‑ta 'ka faan ‑wɔ ‑ta 'ka‑ ‑bha pë sü‑ ‑gɔ, \"ɛɛn 'ka 'dho mɛ 'bha ‑tabhö, \"kɛɛ ‑ka ka \"tʋ̈ng kë ka ꞊saa ꞊në‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","‑A kë 'ö Zan gun‑ wo sië \"dhʋ̈ bha, 'yö \"sɛgümɛ ‑nu 'wo ‑ya wo ‑zʋ 'gɔn ‑sü ‑bha ꞊dhɛ yö ꞊në Atanna ‑bha ‑Yamɛ 'wo ‑ya ‑gɔ bha‑ 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö‑ ‑nu \"yan ‑yö ‑Yamɛ bha ꞊në‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","꞊Dhɛ 'ö Zan ꞊ya 'wɔn ꞊slɔɔ 'gü ꞊dhɛ 'mɛ 'wo bha‑ ‑nu zuë\" ꞊ya kë ꞊plɛ, 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Ma ‑zë a ka ‑zu \"yi ꞊në 'ka, \"kɛɛ mɛ do 'bha ‑yö ‑dhö, ‑yö nu sië, yö ‑zë 'gü ‑yö \"gbɩɩ‑ 'ö ‑ziö n ‑ta. Yö ‑zë ‑gɛn 'gü ‑sabha ‑zian fië‑ ‑dhö n 'ka. Yö ‑zë ꞊ya nu ‑yö ‑dho ka pa Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ waa‑ pɛng ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yö ‑zë ‑bha 'dhaa‑ ‑ya ‑gɔ do 'ö nu‑ 'ka kö ‑yö ö ‑bha ‑mlü ‑piö 'gü, kö ꞊yaa‑ ‑piö kö ‑ya ga zlɔɔ\" ꞊loo \"bhutu 'gü kö ‑ya dɔ ꞊gbaandhö, kö ‑ya ‑gbʋ waa‑ ꞊flee ‑nu bha‑ ‑nu ꞊pia pɛng 'ö 'yaa \"dhuu tongtongdhö bha‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zan‑ ‑gun 'wɔn ‑taɔng ‑së pö sië \"sɛgümɛ ‑nu ‑dhɛ ‑kɔ bha ꞊në‑ 'gü, 'yö ‑dhio \"wɛɛ ‑nu dɔ‑ ‑nu ‑ta ‑nu wo 'pö 'gbɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","‑Yö kë ‑dɔn ‑bho Edhodö 'ka \"tʋ̈ng do bha ꞊në‑ 'gü, ‑a dheebhang ‑bha dhebhɔ 'wo‑ ‑dhɛ Edhodiadö bha‑ bho 'ö‑ wo‑ ‑gɔ, waa‑ 'wɔn yaa \"wɛɛwɛɛ ‑nu 'ö‑ ‑kë ‑a ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","\"Kɛɛ yö ꞊në‑ ꞊gban 'gü, Edhodö \"tʋ 'yii kë mü, ‑yö kë ö ‑bha 'wɔn yaa bha‑ ‑ta ‑zian ꞊në‑ pa Zan ‑da ‑kaso 'gü ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","'Ö gun kö 'wii Zan 'kun ꞊kö kö ‑wa ‑da ‑kaso 'gü, \"sɛgümɛ ‑nu ꞊gban \"pɛpɛ‑ ‑gun 'dho sië ‑yö ꞊në‑ \"piʋ̈ 'yö‑ ‑nu ‑go 'wɔn yaa 'gü ‑zu bho. Yi do 'ka 'yö Yesu ‑dɩ 'pö 'ö dho kö Zan ‑ya \"zu. ꞊Dhɛ 'ö ꞊ya bo‑ \"zu ‑sü 'ka 'ö Yesu 'dhö bhɛa\" sië Atanna ‑dhɛ, 'yö dhang‑ \"dhi 'dhö ‑pʋ. ");
INSERT INTO daf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","'Yö Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑yö ‑gla 'yö ‑kë ꞊dhɛ ‑tong 'dhö 'yö go dhang‑ 'gü 'ö ꞊lɔɔ Yesu ‑ta. 'Yö ‑wʋ do 'bha ‑yö bɔ dhang‑ 'gü 'ö ‑wɩ 'ö‑ pö: «Bhi ꞊në i n gbö do 'ö n ‑gɔ ‑a 'ka, i ‑dhɔ 'ö n ‑kë bha‑ \"sinma 'yaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ‑yö ö ‑bha yë zü ‑bho kö‑ ‑kwɛ ꞊ya ꞊mɔɔ ‑kaɔng ‑yaaga ‑nu \"sinma ‑bha. Mɛ ꞊gban \"pɛpɛ ‑gun wo ‑zʋ 'gɔn sië ꞊dhɛ Yesu bha Zosɛfu ꞊në‑ gbö 'dhö ‑mü, 'yö Edhi ‑zë 'ö Zosɛfu kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","'yö 'wo Edhi ‑bha dë ‑dhɛ Mata, 'yö Dhevi ‑yö Mata kpɔ, 'yö Dhevi ‑bha dë ‑yö ‑kë Mɛdhöki 'ka, 'yö Zanai ‑yö Medhöki kpɔ, 'yö Zosɛfu ‑yö Zanai kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","'yö Matasia ‑yö Zosɛfu kpɔ, 'yö Amɔsö ‑yö Matasia kpɔ, 'yö Naɔmö ‑yö Amɔsö kpɔ, 'yö Ɛsidhi ‑yö Naɔmö kpɔ, 'yö Nagai ‑yö Ɛsidhi kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","'yö Maatö ‑yö Nagai kpɔ, 'yö Matasia ‑yö Maatö kpɔ, 'yö Semei ‑yö Matasia kpɔ, 'yö Zosɛsö ‑yö Semei kpɔ, 'yö Zoda ‑yö Zosɛsö kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","'yö Zoana ‑yö Zoda kpɔ, 'yö Dhesa ‑yö Zoana kpɔ, 'yö Zodhobabɛdhö ‑yö Dhesa kpɔ, 'yö Sadhasiɛdhö ‑yö Zodhobabɛdhö kpɔ, 'yö Nedhi ‑yö Sadhasiɛdhö kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","'yö Mɛdhosi ‑yö Nedhi kpɔ, 'yö Adi ‑yö Mɛdhosi kpɔ, 'yö Kosamö ‑yö Adi kpɔ, 'yö Ɛdhömadamö ‑yö Kosamö kpɔ, 'yö Ɛdhö ‑yö Ɛdhömadamö kpɔ ");
INSERT INTO daf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","'yö Yesu ‑yö Ɛdhö kpɔ, 'yö Edhiezɛɛ ‑yö Yesu kpɔ, 'yö Zodhimö ‑yö Edhiezɛɛ kpɔ, 'yö Mata ‑yö Zodhimö kpɔ, 'yö Dhevi ‑yö Mata kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","'yö Simeɔn ‑yö Dhevi kpɔ, 'yö Zuda ‑yö Simeɔn kpɔ, 'yö Zosɛfu ‑yö Zuda kpɔ, 'yö Zona ‑yö Zosɛfu kpɔ, 'yö Edhiakimö ‑yö Zona kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","'yö Medhea ‑yö Edhiakimö kpɔ, 'yö Mena ‑yö Medhea kpɔ, 'yö Matata ‑yö Mena kpɔ, 'yö Natan ‑yö Matata kpɔ, 'yö Davi ‑yö Natan kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","'yö Izai ‑yö Davi kpɔ, 'yö Zɔbɛdö ‑yö Izai kpɔ, 'yö Boozö ‑yö Zobɛdö kpɔ, 'yö Salmɔ ‑yö Boozö kpɔ, 'yö Naasɔn ‑yö Salmɔ kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","'yö Aminadabö ‑yö Naasɔn kpɔ, 'yö Adimi ‑yö Abinadabö kpɔ, 'yö Adhimi ‑yö Adimi kpɔ, 'yö Ɛsrɔn ‑yö Adhimi kpɔ, 'yö Pedhɛtö ‑yö Ɛsrɔn kpɔ, 'yö Zuda ‑yö Pedhɛtö kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","'yö Zakɔbö ‑yö Zuda kpɔ, 'yö Izaakö ‑yö Zakɔbö kpɔ, 'yö Ablaamö ‑yö Izaakö kpɔ, 'yö Tadha ‑yö Ablaamö kpɔ, 'yö Nasɔɔ ‑yö Tadha kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","'yö Sedhusö ‑yö Nasɔɔ kpɔ, 'yö Dhago ‑yö Sedhusö kpɔ, 'yö Fadhɛkö ‑yö Dhago kpɔ, 'yö Ebɛ ‑yö Fadhɛkö kpɔ, 'yö Sadha ‑yö Ebɛ kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","'yö Kainamö ‑yö Sadha kpɔ, 'yö Apasadö ‑yö Kainamö kpɔ, 'yö Sɛmö ‑yö Apasadö kpɔ, 'yö Noe ‑yö Sɛmö kpɔ, 'yö Dhamɛsö ‑yö Noe kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","'yö Matusadha ‑yö Dhamɛsö kpɔ, 'yö Enɔkö ‑yö Matusadha kpɔ, 'yö Zadhɛdö ‑yö Enɔkö kpɔ, 'yö Malelɛdhö ‑yö Zadhɛdö kpɔ, 'yö Kaina ‑yö Malelɛdhö kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","'yö Enɔsö ‑yö Kaina kpɔ, 'yö Sɛtö ‑yö Enɔsö kpɔ, 'yö Adan ‑yö Sɛtö kpɔ, 'yö Atanna ‑yö Adan ‑da. ");
INSERT INTO daf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu ‑go Zuudɛn ꞊bhaa ‑sü 'ka kö Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ꞊yaa‑ pa. 'Yö 'Nii‑ bha 'ö zian bho‑ 'ka, 'yö dho‑ 'ka \"tʋng ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","‑Yö ‑dhɛkpaɔyi ‑kë ‑dhɛ bha‑ 'gü ‑kaɔng ‑yiisiö kö Sɔtraan ‑ya 'gü dan sië kö 'yaa pë 'bha ‑pë 'bha ‑bhö. ꞊Dhɛ 'ö ‑dhɛkpaɔyi ‑kaɔng ‑yiisiö bha ꞊ya zun 'ko \"dhiʋ̈, 'yö din‑ ‑ya kun, ");
INSERT INTO daf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","'yö Sɔtraan ‑ya pö‑ ‑dhɛ: «Atanna Gbö 'yaa ‑mü i 'ka ‑ee? ‑Bhö ‑gwë ya‑ \"gla ‑bhöpë 'gü kö 'i‑ ‑bhö ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Atanna ‑ya ‑pö ö ‑wʋ 'sëëdhɛ 'gü ꞊dhɛ: ‹Mɛbhɩɩdhe ‑tosɛa ‑kë ‑ta ‑pë 'yaa ‑mü ‑bhöpë yöö doseng 'ka!›» ");
INSERT INTO daf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","'Yö Sɔtraan ‑ya sü 'zü 'yö dho‑ 'ka ‑tɔn ꞊gblɛɛn do ꞊gbin‑, 'yö \"sɛgɔ \"pɛpɛ 'ö \"kpʋng ꞊taa 'ö ‑gblüdëdhɛ 'dhö‑ 'gü ‑a ꞊gban ‑zɔn ‑dhɛ 'dɔɔndhö ꞊dhɛ mɛ‑ mɛ \"yan zë, ");
INSERT INTO daf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","'yö‑ pö‑ ‑dhɛ: «\"Sɛ \"pɛpɛ 'i‑ yö bha‑ ꞊gban ‑yö ma ꞊në n ‑bha 'ka, ‑a ‑nu mɛ \"ʋʋ mɛ 'ö‑ ‑dhɛ ‑dhɔ ꞊ya n kë 'ma‑ nu‑ ‑dhɛ n dhɛɛkpɔmɛ 'yaa 'dhö; ‑a ‑gɛn ‑mü ꞊dhɛ ꞊wa n gba‑ 'ka waa‑ 'gü ‑naɔ ꞊gban 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","꞊Dhɛ 'ö \"dhʋ̈, ‑bhö zun n ‑dhɛ kpiö 'gü. ꞊Ya kë ꞊dhɛ 'bha zun n ‑dhɛ kpiö 'gü, a ‑dho ‑a ꞊gban \"pɛpɛ nu i ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Yö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'sëëdhɛ 'gü ꞊dhɛ: ‹'Mɛ 'ö ‑zun ‑dhɛ kpiö 'gü ‑mɛ 'ka kö ‑wa ‑dhɔkë, yö ‑mü Atanna 'ö mɛ \"pɛpɛ ꞊gban Dëmɛ 'ka bha ꞊në‑ 'ka, ‑a \"wɛɛ 'bha 'yaa yö ‑zë zian 'gü.›» ");
INSERT INTO daf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","'Yö Sɔtraan ‑ya sü 'zü ‑deewo 'ö dho‑ 'ka Atanna ‑bha 'kɔ 'kpii‑ 'ö Zedhizadhɛmö bha‑ ꞊gbin‑, 'yö‑ pö‑ ‑dhɛ: «꞊Ya kë ꞊dhɛ 'i Atanna Gbö 'ka ꞊dedewo tɛan‑ 'ka, ‑bhö dɔ ‑dhɛ ya‑ 'gü kö 'i ‑wlö 'i zun \"sia‑, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka 'pö Atanna ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‹‑Yö ‑dho ‑wʋ 'kpɔ ö ‑bha \"kië ‑nu ‑bha kö ‑wo i ‑maa kë› ꞊ya 'go mü 'zü: ");
INSERT INTO daf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‹‑Wo ‑dho i ‑ya wo ‑kɔ ‑ta, kë \"dhʋ̈ kö i ‑gɛn \"dhiʋ̈ 'ya 'dho ‑zuö ‑gwë 'bha ‑bha.›» ");
INSERT INTO daf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Atanna ‑ya ‑pö 'pö ꞊dhɛ: ‹I Dëmɛ 'ö i ‑bha Atanna 'ka bha 'bha 'dho‑ 'gü dan tongtongdhö!›» ");
INSERT INTO daf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","꞊Dhɛ 'ö Sɔtraan ꞊yaa‑ 'gü dan ‑kɔ ꞊gban ‑kɔ ꞊gban 'gü 'ö‑ ‑kɔ 'yii ꞊mɔɔ‑ ‑bha, 'yö ö ꞊kwaa‑ ‑zü ꞊kö 'në bha wo kö 'ö \"yan 'to \"tʋ̈ng \"wɛɛ 'bha ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu 'ö pa ‑sü 'ka 'Nii‑ \"slʋ̈ʋ̈slʋ̈ faan 'ka bha 'ö ꞊wlü 'ö dho Gadhidhe ‑sɛ 'gü. 'Yö‑ 'tɔ 'dhö ‑ya bhɔ ‑sü ‑bha \"sɛ \"pɛpɛ 'wo‑ ‑züzü mü bha‑ ꞊gban 'gü. ");
INSERT INTO daf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","'Yö ‑ya mɛ ‑nu ꞊klang kë ‑sü ‑bha Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü, 'yö mɛ ꞊gban \"pɛpɛ 'wo ‑ya ‑a ‑dhiang ‑së zë ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yi do 'ka 'yö dho Nazadhɛtö, 'pödhɛ 'ö \"klʋ bho‑ 'gü bha‑ 'gü. ꞊Dhɛ 'ö Zuifö ‑nu ‑bha ꞊glooyi bha ꞊ya ꞊loo, 'yö ꞊wlü 'ö dho ‑a ‑nu ‑bha ‑ya 'kwëë‑ kë 'gü ‑kɔ 'gü ꞊dhɛ ‑kɔ 'ö‑ kë‑ 'ka zii 'kpa ‑a 'dhö. ꞊Dhɛ 'ö ꞊ya ꞊loo mü, 'yö ꞊wlü 'ö dɔ ö ‑gɛan kö 'ö Atanna ‑bha 'sëëdhɛ ‑wʋ pö. ");
INSERT INTO daf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'Yö 'wo Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑bha 'sëëdhɛ ‑be bha‑ sü 'wo‑ nu‑ ‑dhɛ, 'yö‑ \"dhi ‑pʋ. ‑Dhɛ 'ö‑ \"dhi ‑pʋ ‑bha bha kö ‑yö ‑bɛn zë ‑sü 'ka mü ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Atanna ꞊ya ö ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑ya n 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ma ꞊në n ‑ya kö 'a‑ ‑bha naɔ ‑së bha‑ dɔ ‑wëëmɛ ‑nu ‑gɔ, kö 'a zuëwaanusü nu 'mɛ 'wo \"yënnggbaɔndhe 'gü ‑a ‑nu ‑dhɛ Kö 'mɛ 'wo ‑kaso 'gü 'a‑ ‑nu bho mü, kö 'a ‑ya ‑dɩ 'flëë‑ 'gü ‑sü nu‑ ‑nu ‑dhɛ. Kö 'mɛ 'ö‑ ‑nu \"yan 'gü 'dhö tii 'ö 'waa ‑dhɛ yö 'a‑ ‑nu \"yan \"dhiʋ̈ \"pʋ. Kö 'mɛ 'ö 'wɔn ꞊ya ꞊gbaɔn‑ ‑nu ‑ta 'a‑ ‑nu ‑ta 'kun kö ‑wo ‑ya ‑dɩ 'flëë‑ 'gü ‑sü ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kö 'a Atanna ‑bha ‑gasitɛ ‑kë mɛ \"bhɩɩ‑ ‑nu ‑dhɛ ‑kwɛ ‑dhiang zë mɛ ꞊gban \"pɛpɛ ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","꞊Dhɛ 'ö ꞊ya ö bo 'sëëdhɛ bha‑ ‑wʋ pö ‑sü 'ka, 'yö‑ ‑be sü 'ö‑ dɔ 'mɛ 'ö yë ‑kë 'kɔɔdhö mü 'ö gun mü bha‑ ‑gɔ, 'yö dho \"sia‑ 'yö 'yaanu (꞊dhɛ ‑kɔ 'wo‑ ‑kë 'ka‑ ‑nu ‑gɔ mü ‑a 'dhö kö 'ö‑ ‑nu ꞊klang kë). Kö mɛ \"pɛpɛ 'wo ‑yakwëëkëgükɔ bha‑ 'gü ‑a ‑nu ꞊gban ꞊wa wo \"yan bɔ‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","'Yö dhiang zë ‑sü zü bho‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka ‑dhɛ ‑ga! Atanna ‑wʋ 'ö ‑bɛn zë ‑sü 'ka 'a go‑ ‑wʋ pö bha ꞊në‑ 'gü ‑wɔn ꞊ya kë ꞊dɛɛ ya.» ");
INSERT INTO daf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","꞊Dhɛ 'ö 'mɛ 'wo gun mü bha ‑wʋ ‑nu 'ö‑ pö bha 'ö‑ ‑nu ‑zʋ kun kö ‑wʋ \"nɛɛnɛɛ ‑nu 'wo 'go sië‑ \"dhi bha‑ din‑ dhi sië‑ ‑nu 'gü, 'yö‑ 'wɔn ‑ya ‑nu kɔn, 'yö 'wo ‑ya ‑a pö ‑sü bha: «‑A! Zosɛfu gbö do \"wɛ 'ö ya 'yaa ‑mü ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «A‑ 'wɔn dɔ ꞊dhɛ ka ‑mɔɔ ‑bha 'ka \"gwënng ‑da n ‑dhɛ 'ka‑ pö: «‑Dhɔtrɔɔgɔn, ‑bhö i ‑dɩ ‑zë dha ꞊kö ‑blɛɛsü kö 'i gun ‑na mɛ \"wɛɛ dha». \"Ɛɛn 'ö 'ka‑ pö 'zü ꞊dhɛ: «'Wɔn \"gblʋ̈gblʋ̈ ‑nu 'i‑ ‑kë Kapɛɛnaɔmö 'yi‑ ma bha, ‑bhö ‑a 'bha kë 'pö i ‑dɩ ꞊plöö ‑dhɛ ya‑ 'gü kö 'yi‑ ‑dhɛ yö»». ");
INSERT INTO daf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","'Yö‑ ‑gɔ dɔ 'ö‑ pö: «\"Kɛɛ a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ 'bha 'yaa 'dhö kö‑ ꞊bhlëë ‑yö kë ö dë ‑pö 'gü. ");
INSERT INTO daf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'ö gun Edhi ‑bha \"tʋ̈ng 'gü, ꞊gɛandhe 'gbɛ ꞊në gun Izraɛdhö ‑sɛ 'gü, \"tʋ̈ng 'ö Atanna ‑yö dhang‑ \"dhi ta‑ 'ka 'ö dha 'yii ban ‑kwɛ ‑yaaga waa‑ \"su \"saɔdo 'ka, 'ö \"vʋ̈ʋ̈ 'dhö ‑da 'ka \"kpʋng ꞊taa bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","\"Kɛɛ yö ꞊në‑ ꞊gban 'gü, 'yii Edhi bɔ ꞊gɛandhe 'gbɛ bha‑ 'bha \"piʋ̈ kö ‑ya ‑ta 'kun kö 'yii kë dhebhɔnë 'ö go Sadhɛta, Sidɔn ‑sɛ 'ö \"sɛ \"wɛɛ 'ka bha‑ 'gü bha yö ‑zë 'ka. ");
INSERT INTO daf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","'Ö gun 'zü Edhize 'ö ‑kë Atanna ‑wʋdhiʋ̈loomɛ 'ka bha‑ ‑bha \"tʋ̈ng 'gü, ꞊weeyuamɛ 'gbɛ ꞊në gun Izraɛdhö ‑sɛ 'gü, \"kɛɛ yö ꞊në‑ ꞊gban 'gü mɛ 'gbɛ bha‑ ‑nu 'bha 'wii dha Edhize ‑kɔ ‑ta ‑a ‑nu ‑bha \"yua ‑gɔ kö 'yii kë Naama ('ö yö ‑zë 'ö gun ‑dhɛng 'ka) 'ö go Siidhi ‑sɛ 'ö \"sɛ \"wɛɛ 'ka 'pö bha‑ 'gü bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","꞊Dhɛ 'ö 'mɛ 'wo gun‑ ‑nu ‑bha ‑yakwëëkëgükɔ 'gü mü bha 'wo 'wɔn ‑nu bha‑ ma, 'ö 'wo‑ 'wɔn dɔ ꞊dhɛ ‑yö ‑ya ꞊në‑ wo sië wo \"yan 'gü bha, 'yö ‑siö ‑nu ‑dhɛ ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","'Yö 'wo ꞊wlü 'wo zun Yesu kë ‑sü ‑bha, 'yö 'wo dho‑ 'ka \"dhʋ̈ 'wo ꞊loo‑ 'ka ‑tɔn 'ö‑ ‑nu ‑bha 'pö‑ gun‑ ꞊gbin‑ bha‑ \"dhiʋ̈ ‑dhɛ ꞊dede 'gü, kë \"dhʋ̈ kö 'wo wo ‑kɔ ꞊yɔɔn‑ ‑bha kö ‑yö ‑pö baandhö; ");
INSERT INTO daf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","\"kɛɛ 'yö go‑ ‑nu kpö 'gü 'ö dho. ");
INSERT INTO daf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ‑ziö 'ö dho 'pödhɛ 'ö Gadhidhe ‑sɛ 'gü 'wo‑ Kapɛɛnaɔmö ‑dhɛ ‑kë bha‑ 'gü, 'yö ‑ya mɛ ‑nu draan‑ ‑sü ‑bha Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ 'gü mü ꞊glooyi bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","\"Trüün‑ ‑gun ‑wʋ 'gü, 'ö‑ ‑bha mɛ draan‑ ‑kɔ bha‑ ‑gleng ‑yö mɛ ꞊gban kɔn. ");
INSERT INTO daf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gɔndënë do ‑yö ‑gun 'kɔɔdhö mü 'ö \"yina yaa ‑yö gun‑ 'gü. 'Yö 'mɛ bha 'ö zun \"gbla ‑sü ‑bha \"gbɩɩ‑ 'ka 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«'Aa! Yesu, Nazadhɛtö mi, 'kwa ma mü! A ‑suʋ̈ i ‑gɔ ‑wa! ‑A ‑gɛn ‑mü ꞊dhɛ a i ‑gɛn 'godhɛ ‑dɔ, Atanna ‑bha ‑Yamɛ \"slʋ̈ʋ̈slʋ̈! \"Ɛɛn i ‑nu kö 'i yi ‑wëë ‑kë wo ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","'Yö Yesu ‑yö ꞊gbla‑ ‑ta 'ö‑ pö: «‑Dhɛa ga i ‑ta kö 'i 'go 'mɛ bha‑ 'gü!» 'Yö \"yina yaa bha 'ö 'mɛ bha‑ \"dhiʋ̈ pɔn mɛ kpö bha‑ 'gü, \"kɛɛ ‑a ‑dhɛ 'bha 'yii ‑gi, 'yö go‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","'Yö mɛ \"pɛpɛ 'wo gun mü bha‑ 'wɔn ‑ya ‑nu kɔn, 'yö 'wo ‑ya \"kaa ‑sü bha 'wo‑ pö: «\"Nn‑, ‑më ‑wɔn suu ꞊nɛ ‑oo? 'Mɛ 'ö ya \"trüün ‑ya ‑wʋ 'gü, \"kɛɛ yöö do bha 'zü ‑yö faan ‑wɔ \"yina yaa ‑nu ꞊gban ‑ta 'wo ꞊dua‑ ‑gɔ ‑wa! ");
INSERT INTO daf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","'Yö‑ 'tɔ 'dhö ‑ya 'dho ‑sü ‑bha \"sɛgɔ \"pɛpɛ 'wo‑ ‑nu ‑züzü bha‑ ꞊gban 'gü. ");
INSERT INTO daf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","꞊Dhɛ 'ö Yesu ‑yö go ‑yakwëëkëgükɔ bha‑ 'gü, 'yö dho Simɔ ‑gɔ 'kɔɔdhö. ‑A \"tʋ̈ng bha‑ 'gü kö‑ \"na 'gü 'yaa ‑së, kö \"nɛnɛ ‑ya kë sië ꞊dedewo ‑sɔbhɛɛ 'ka. 'Yö 'wo ꞊bhɛa Yesu ‑dhɛ kö ‑yö \"ta wo ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Yö dho 'yö dun Simɔ \"na bha‑ ‑ta, 'yö ‑ya \"yua bha‑ \"yan 'gü. ꞊Dhɛ 'ö ꞊ya ‑ya \"yan 'gü \"dhʋ̈, 'yö \"nɛnɛ ‑ziisü 'ö gun dhebhɔ bha‑ ‑bha bha 'ö bo 'gbaandhö, 'yö ꞊wlü 'ö zun‑ ‑nu \"dhi mɔɔ‑ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","꞊Dhɛ 'ö 'yënng‑ ‑gɔ ꞊ya bo ‑pö ‑sü 'ka ('ö ꞊waa‑ 'wɔn dɔ ꞊dhɛ ‑a ‑nu ‑bha ꞊glooyi ꞊ya ziö \"pɛɛpɛdhö, ꞊dhɛ wo ‑mɔɔ ‑bha 'wo yë kë ‑sü zü bho), 'yö mɛ \"pɛpɛ 'ö \"yuëdhi ‑nu 'ö \"yua suu 'do 'do ꞊gban 'dhö‑ ‑nu ‑bha 'wo‑ ‑nu ‑gɔ 'kɔɔdhɛ ‑nu 'gü bha 'wo nu‑ ꞊gban \"pɛpɛ 'ka Yesu \"piʋ̈, 'yö ö ‑kɔ ‑ya ‑a ‑nu ‑ta 'do 'do 'ka 'yö 'wo dha. ");
INSERT INTO daf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kö \"yina yaa ‑nu ‑wo ꞊dua sië 'wo go mɛ 'gbɛ 'gü kö ‑wo \"gbla sië 'wo‑ pö: «Atanna Gbö ‑mü i 'ka! Atanna Gbö ‑mü i 'ka!» \"Kɛɛ ꞊waa‑ pö \"dhʋ̈ 'yö ‑ya ‑nu \"yan 'gü kë \"dhʋ̈ kö 'wa 'dho \"wɩ; ‑a ‑gɛn ‑mü ꞊dhɛ wo ‑zë ‑wa ‑dɔ ꞊dhɛ Yesu ꞊në Atanna ‑bha ‑Yamɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","꞊Dhɛ 'ö‑ ‑tadhɛ ꞊ya ꞊kpaɔ, 'yö Yesu ‑yö ꞊wlü 'yö dho ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü ö ‑dɩ ‑ta \"tʋngtadhɛ 'bha bha‑ 'gü. 'Yö mɛ kpö 'wo ‑ya ‑a mɔɔ‑ ‑sü ‑bha 'wo dho‑ 'ka \"dhʋ̈ 'wo ꞊loo‑ 'ka ‑dhɛ 'ö gun‑ ‑bha bha‑ 'gü. ꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ‑kpan ‑bha, 'yaa gun ‑zian wo‑ ‑nu \"piʋ̈ ꞊dhɛ ‑yö \"kan wo ‑bha kö ‑yö 'dho ‑dhɛ 'bha 'gü ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü, ");
INSERT INTO daf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","\"kɛɛ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Atanna ‑yö n ‑bɔ kö 'a 'wɔn ‑taɔng ‑së ya ꞊në‑ pö mɛ ꞊gban \"pɛpɛ ‑dhɛ. ‑A ‑kë \"dhʋ̈ ‑sü 'gü, ‑a ‑dhɛa ‑bha 'pö ꞊dhɛ 'pödhɛ ‑dhɛ ‑nu 'wo to 'ö 'mii 'dho‑ ‑nu 'gü ꞊kö bha 'a 'dho mü kö 'a naɔ ‑së 'ö ‑gban ‑a ‑bha ‑gblüdëdhɛ ‑bha bha‑ dɔ‑ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ‑ziö 'yö dho ‑yakwëëkëgükɔ ‑nu 'wo Izraɛdhö ‑sɛ 'gü mü bha‑ ‑nu ‑bhiëë ‑ta 'dɔɔndhö Atanna ‑wʋ pö ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo \"yi ‑ta \"gbɛa 'wo‑ Zenezadhe ‑yi ‑kë bha‑ \"sɔɔ, kö mɛ \"bhɩɩ‑ ꞊ya ꞊klëën‑ ‑zü tingtingdhö kö ‑wo ‑yɛa ‑nu mɔɔ‑ sië ‑bɛang 'ka kö 'wo wo \"tʋ 'to Atanna ‑wʋ ‑bha, ");
INSERT INTO daf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","'ö dho ‑dhɛ ‑ga kö \"kplagɔnë ꞊plɛ ‑wo dɔ sië \"yi \"kpʋng \"dhiʋ̈ mü kö 'mɛ 'wo gun‑ 'gü bha ꞊wa lɔɔ‑ \"yi ꞊bhaa kö ‑wo woo‑ \"nuu ‑nu \"zu sië. ");
INSERT INTO daf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Yö ‑da \"kplagɔnë bha‑ do 'gü, 'ö ‑da ‑a 'dhɛ 'ö‑ 'gü bha ‑yö ‑gun Simɔ ꞊në‑ ‑bha 'ka, 'yö ꞊bhɛa ‑dhɛ 'ö‑ pö ‑ya ꞊yɔɔn 'dɛdɛ 'në 'bha wo \"yi ꞊bhaa kö 'ö bhɔ 'në 'bha wo \"kpʋngtaadhɛ 'ka taa‑ 'bleng ‑bleng. ꞊Dhɛ 'ö Piɛdhö ꞊yaa‑ kë \"dhʋ̈, 'yö Yesu ‑yö ‑ya mü 'yö zun mɛ kpö 'wo bha‑ ‑nu ꞊klang kë ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","꞊Dhɛ 'ö ꞊ya ö bo dhiang zë ‑sü 'ka, 'yö‑ pö Simɔ ‑dhɛ: «‑Bhö ꞊yɔɔn \"kplagɔnë bha‑ 'ka \"yi ꞊zinng 'gü kö kaa‑ i \"tayɔɔ ‑nu bha 'ka \"nuu bha‑ ‑së do ‑zuö mü.» ");
INSERT INTO daf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","'Yö Simɔ ‑ya pö‑ ‑dhɛ: «N Dëmɛ, 'ya wɔ \"yaan \"nuu ‑zuö ‑sü ‑bha 'yii pë 'bha 'sü, \"kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ 'bha‑ pö \"dhʋ̈, a ‑dho ‑a ‑së do ‑zuö mü kö 'a‑ ‑bha ‑ga.» ");
INSERT INTO daf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","'Yö Simɔ ‑yö \"nuu bha‑ ‑zuö Yesu ‑wʋ bha‑ \"dhiʋ̈, 'yö 'wo ‑ya ‑a \"gan ‑sü ‑bha, 'wo dho ‑dhɛ ‑ga kö 'yuʋ̈‑ ‑ya pa ‑sü 'ka, kö‑ \"nuu ga ‑nu ‑wo \"kan sië. ");
INSERT INTO daf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'Yö 'wo wo ‑kɔ \"paa 'gü zë 'mɛ 'wo \"kplagɔ 'dhɛ 'ö to ‑a 'gü bha‑ ‑nu ‑dhɛ kö ‑wo nu wo \"piʋ̈ kö ‑wo wo ‑ta 'kun. 'Yö 'wo nu 'wo 'yuʋ̈‑ bha‑ bho \"nuu bha‑ 'gü, 'yö 'wo‑ ꞊loo \"kplagɔnë ꞊plɛ bha‑ 'gü, 'yö‑ ꞊gban ꞊plɛ pa, 'ö dɔ mü kö ‑wo 'dho sië \"yi ꞊wlöö. ");
INSERT INTO daf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","꞊Dhɛ 'ö Simɔ \"yan 'dhö ‑da 'wɔn bha‑ ‑dhɛ 'gü, 'yö dho 'ö zun ö kpiö 'gü Yesu ‑dhɛ 'ö‑ pö: «N Dëmɛ, 'bha 'dho dɔ n \"sɔɔ, ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔnyaakëmɛ ‑mü n 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","‑A pö 'ö Piɛdhö ‑ya wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö \"suʋ̈ ꞊ya ‑da waa‑ \"tɛabɔ ‑nu bha‑ ‑nu 'gü ꞊dedewo 'yuʋ̈‑ 'wo‑ sü \"nuu 'ka bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","\"Suʋ̈‑ ‑gun ‑da ‑sü 'ka Zan waa‑ Zakö 'wo ‑kë Zebede gbö ‑nu 'ka 'ö waa‑ Piɛdhö ‑nu 'wo gun \"nuu ‑zuö sië bha‑ ‑nu 'gü 'pö ꞊dedewo. Yesu ‑ya ‑pö Simɔ ‑dhɛ yö ꞊në‑ ‑wɔn 'gü 'ö‑ pö: «Simɔ, \"suʋ̈ 'ya 'dho i kë, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊ya 'go ꞊dɛɛ 'gü, i ‑dho kë \"nuu ‑zuö mɛ ‑gɔ ‑mɛ ꞊në‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","꞊Dhɛ 'ö 'mɛ 'wo bha ꞊wa nu woo‑ \"kplagɔnë ‑nu bha‑ ꞊gban 'ka \"yi \"kpʋng \"dhiʋ̈, 'yö 'wo‑ to 'mü 'wo dho Yesu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","'Ö gun kö Yesu ‑yö 'pö‑ ‑nu bha‑ do 'bha 'gü, 'ö dho ‑dhɛ ‑ga kö mɛ do 'bha 'ö ꞊wee ‑yua ꞊ya \"bhɛɛ ‑da ‑bha bha ꞊ya nu kö ꞊ya \"gblëënu‑ ꞊wlöö kö ꞊ya bhɛa\" ‑dhɛ ꞊yaa‑ pö: «N Dëmɛ, ‑bhö \"ta n ‑dhɛ ‑dhe! ‑A ‑gɛn ‑mü ꞊dhɛ ꞊ya kë ꞊dhɛ ꞊ya ga ‑zë wo i 'gü, i ‑kɔ ‑mɔɔ ‑bha kö 'i \"yua ya‑ bho n ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Yesu ‑yö ö ‑kɔ ‑pʋ 'yö ‑kɔ pa 'mɛ bha‑ 'ka, 'yö‑ pö‑ ‑dhɛ: «꞊Ya ga n 'gü, ‑bhö kë \"klʋ̈ʋ̈klʋ̈!» ‑Yö ‑to 'pö ‑dhɛ do bha‑ 'gü 'ö‑ ‑bha \"yua bha 'ö bo. ");
INSERT INTO daf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö ‑dhio dɔ‑ ‑ta 'ö‑ pö: «'Bha 'dho, 'bha 'dho‑ ‑gɛn dɔ mɛ 'bha ‑dhɛ, \"kɛɛ ‑bhö 'dho kö 'i i ‑dɩ ‑zɔn \"saabhomɛ ‑nu ꞊në‑ ‑nu ‑dhɛ kö \"saa‑ 'ö Moizö ‑ya ‑bɛn zë Atanna ‑bha 'tɔng‑ 'sëëdhɛ 'gü yi 'bha 'ka bha 'i‑ bho kö mɛ ꞊gban ‑wa 'wɔn dɔ‑ ‑bha ꞊dhɛ 'bha kë \"klʋ̈ʋ̈klʋ̈.» ");
INSERT INTO daf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'Yö‑ 'tɔ bhɔ ‑sü 'bha 'dhö ‑da 'gü ‑kpɛawo, 'yö‑ 'tɔ 'dhö dho ‑dhɛ ꞊gban \"pɛpɛ 'gü, 'yö 'wo go ‑dhɛ ‑nu 'gü kpö kpö 'ka 'wo nu \"tʋ ‑to ‑a ‑wʋ ‑bha ‑dhɛ 'gü, \"ɛɛn 'zü kö 'wo kë \"klʋ̈ʋ̈klʋ̈; ");
INSERT INTO daf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","\"kɛɛ 'yö Yesu ‑zë ꞊ya kë 'yö dho ö ‑dɩ ‑ta \"tʋngtadhɛ ‑nu 'gü 'yö ꞊bhɛa Atanna ‑dhɛ mü. ");
INSERT INTO daf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","꞊Dhɛ 'ö yi do 'ka kö Yesu ‑yö mɛ ꞊klang kë sië, kö Fadhiziɛn ‑nu waa‑ 'tɔnggɔmɛ ‑nu ꞊wa 'go 'pödhɛ \"pɛpɛ 'wo Gadhidhe ‑sɛ 'gü ‑dhɛ ‑nu, Zude ‑sɛ 'gü ‑dhɛ ‑nu waa‑ Zedhizadhɛmö ‑dhɛ ‑nu 'gü ꞊wa nu, kö ‑wo 'yaanu sië kö Yesu ‑yö Atanna ‑bha 'gügbɩɩdhɛ ‑zɔn sië mɛ ‑nu ‑kë \"klʋ̈ʋ̈klʋ̈ ‑sü 'ka, ");
INSERT INTO daf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","'wo dho ‑dhɛ ‑ga kö mɛ kpö 'bha bha ꞊wa \"trüünyuamɛ do 'sü \"gbang ‑ta kö ‑wo nu sië‑ 'ka. ꞊Dhɛ 'ö ꞊wa nu ꞊wa ꞊loo mü, 'yö 'wo ‑ya ‑a \"slë mɔɔ‑ ‑sü ‑bha kö 'wo ‑da 'mɛ bha‑ 'ka 'kɔɔdhö kö 'wo‑ wɔ‑ ‑kuu \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","\"Kɛɛ ꞊dhɛ 'ö ꞊waa‑ \"slë mɔɔ‑ 'ö 'wii‑ yö mɛ \"dhaa 'wo gun 'mü bha‑ ‑nu ‑gɔ, 'yö 'wo 'mɛ bha‑ sü 'wo ‑da 'ka 'kɔ ‑ta, 'yö 'wo‑ ‑yɛ bho, 'yö 'wo 'mɛ bha‑ bɔ ‑yɛ bha‑ ‑bha waa‑ ‑wɔ ‑ta \"gbang bha‑ 'dhö, 'yö 'wo‑ ꞊lɔɔ bhiëga ‑bha mɛ kpö 'gü Yesu wëëdhö mü. ");
INSERT INTO daf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","꞊Dhɛ 'ö Yesu ꞊ya 'mɛ 'wo bha‑ ‑nu ‑bha 'dhang ‑bho ö \"dhiʋ̈ ‑kɔ ('ö ꞊dhɛ ‑yö ‑mɔɔ ‑bha 'ö 'mɛ bha‑ dha) bha‑ ‑dhɛ yö, 'yö‑ pö \"yuëdhi bha‑ ‑dhɛ 'ö‑ pö: «N \"taɔngdë, 'ma i ‑bha 'wɔn yaa ‑nu ‑mawɔn to, 'bɔn ꞊ya 'go i ‑bha!» ");
INSERT INTO daf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","\"Kɛɛ 'yö 'mɛ 'wo ‑kë 'tɔngdɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu 'ka bha 'wo ‑ya ‑a pö ‑sü ‑bha ꞊dhɛ: «De suu ꞊në ya ꞊zɔɔ 'yö Atanna ꞊bhlëë 'yaa ‑gɔ ꞊ni ‑oo? De ꞊në‑ ‑kɔ ꞊mɔɔ‑ ‑bha \"kpʋngtaadhɛ ya‑ 'gü kö ‑yö mɛbhɩɩdhe ‑bha 'wɔn yaa ‑mawɔn 'to kö 'yii kë Atanna ‑zë 'ka?» ");
INSERT INTO daf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","꞊Dhɛ 'wo wo ‑zʋ 'gɔn sië \"dhʋ̈, 'ö Yesu ꞊yaa‑ ‑nu ‑zʋgɔngüwɔn bha‑ dɔ, 'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Më ꞊në ‑kë 'yö 'ka ka ‑zʋ gɔn ꞊dhɛ ‑kɔ bha‑ 'dhö? ");
INSERT INTO daf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'Wɔn ꞊plɛ bha‑ ‑mɛɛ ꞊në \"gbɩɩ‑? ‑A pö ‑sü 'ö mɛ ‑dhɛ ꞊dhɛ 'ma i ‑bha 'wɔn yaa ‑nu ‑mawɔn 'to yö ꞊në \"gbɩɩ‑ ‑ee, \"ɛɛn ‑a pö ‑sü 'ö‑ ‑mɛ ‑dhɛ ꞊dhɛ 'bha kë \"klʋ̈ʋ̈klʋ̈, ‑bhö \"wlü kö 'i \"ta yö ꞊në \"gbɩɩ‑ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö go mü 'zü 'ö‑ pö: «‑A ‑dhɛa ‑bha ꞊dhɛ 'ka‑ 'wɔn dɔ ꞊dhɛ mɛ ‑bha 'wɔn yaa ‑mawɔn 'to \"sɩ ‑yö mang Mɛgbömɛ n ‑dhɛ \"kpʋng ꞊taa yö. 'Yö‑ pö \"trüünyuamɛ bha‑ ‑dhɛ: «‑Bhö \"wlü kö 'i i ‑kɔ ‑da i ‑bha \"gbang 'gü kö 'i 'dho i ‑gɔ 'kɔɔdhö!» ");
INSERT INTO daf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö 'mɛ bha 'ö to ‑dhɛ do bha‑ 'gü 'ö ‑kë \"klʋ̈ʋ̈klʋ̈, 'yö ꞊wlü 'mɛ 'wo bha‑ ‑nu \"yaan mü 'yö ö ‑kɔ ‑da ö ‑bha \"gbang 'gü, 'yö dho ö ‑gɔ 'kɔɔdhö Atanna 'tɔ bhɔ ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","'Wɔn bha 'yö‑ 'wɔn ‑yö 'mɛ 'wo gun mü bha‑ ꞊gban \"pɛpɛ kɔn, 'yö \"suʋ̈ 'dhö ‑da ‑a ‑nu 'gü, 'yö 'wo ‑ya Atanna 'tɔ bhɔ ‑sü ‑bha 'wo‑ pö: «'Aa! Yi \"yan ꞊ya ‑da 'wɔn ‑ziisü ‑dhɛ 'gü ‑dhɛkpaɔyi 'ö ꞊dɛɛ bha‑ 'ka!» ");
INSERT INTO daf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö zun \"kpɛnng 'yö dho. ꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo ‑dhɛ 'bha bha‑ 'gü, 'yö ‑kpan 'niisɔngkunmɛ do 'bha 'wo‑ ‑dhɛ Dhevi bha‑ ‑bha kö ‑yö ‑ya sië 'nii‑ sɔng ‑kun 'gü ‑kɔ 'gü. ꞊Dhɛ 'ö ꞊yaa‑ yö 'yö‑ pö‑ ‑dhɛ: «Dhevi, nu 'kii ‑da n ꞊keng‑!» ");
INSERT INTO daf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","'Yö 'mɛ bha 'ö ö ꞊kwaa pë \"pɛpɛ 'ö gun‑ ‑gɔ ‑a ꞊gban ‑zü 'yö ‑ziö Yesu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Dhevi ‑yö Yesu ‑dhɛ ö ‑gɔ 'kɔɔdhö kö 'ö‑ ‑dhɔkë. ‑Dhɔkëdhe bha‑ kë \"tʋ̈ng 'gü, 'niisɔngkunmɛ ‑nu bha‑ mɛ 'gbɛ ‑wo ‑gun mü waa‑ mɛ \"wɛɛ ‑nu 'ö 'wo 'wɔnyaakëmɛ ‑nu 'ka 'pö ‑a ‑nu 'dhö, 'yö waa‑ Yesu ‑nu ꞊gban 'wo zun pë ‑bhö ‑sü ‑bha wo \"kwëë waa‑ ‑bha ꞊klang ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","꞊Dhɛ 'ö Fadhiziɛn ‑nu waa‑ 'tɔnggɔmɛ ‑nu 'wo Yesu yö kö waa‑ 'mɛ 'wo bha ‑wo wo ‑kɔ ‑da sië pëfië do 'gü, 'yö 'wo zun ‑dɔn bho ‑sü ‑bha wo yun 'gü, 'yö 'wo‑ pö Yesu ‑bha ꞊klang ‑nu ‑dhɛ: «'Wɔnyaakëmɛ ‑nu 'kö 'wo ya kɛng‑ ‑nu ‑zë ka ‑kɔ ‑da 'tɛa‑ do 'gü ‑gɛn ‑mü ‑më 'ka (\"kɛɛ kö 'waa Atanna ꞊bhlëë dɔ).» ");
INSERT INTO daf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Mɛ 'wo \"klʋ̈ʋ̈klʋ̈ wo ‑zë ‑a ‑nu ‑mawɔn 'yaa kë ‑dhɔtrɔɔ ‑bha, mɛ ꞊dede 'ö‑ ‑nu 'gü 'yaa ‑së bha ꞊në‑ ‑nu ‑mawɔn ‑yö zun‑ bha. ");
INSERT INTO daf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nu 'a‑ wo \"kpʋng ꞊taa ya 'mii nu kö 'a 'mɛ 'wo‑ pö wo ‑dɩ ‑dhɛ ꞊dhɛ pö 'aa wo ‑bha bha wo ‑zë ‑a ‑nu ‑dhɛ Atanna \"piʋ̈, a ‑nu kö 'wɔnyaakëmɛ ‑nu bha ꞊në 'a‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","'Yö 'mɛ 'wo bha 'wo‑ pö Yesu ‑dhɛ: «'Bha‑ pö \"dhʋ̈ 'kwa‑ ma, \"kɛɛ 'wɔn do 'bha‑ ‑dhö. ꞊Ya kë ‑nu wo Zan ‑bha ꞊klang ‑nu 'waa Fadhiziɛn ‑nu ‑bha ꞊klang ‑nu ‑wo 'sunng‑ ‑nu ‑ma 'ö 'wo ꞊bhɛa Atanna ‑dhɛ, \"kɛɛ 'yii‑ ‑dhɛ yö i ‑bha ꞊klang ‑nu 'kö 'wo ya‑ ‑nu ‑gɔ do, ‑më ꞊në ‑kë 'yö ‑kë \"dhʋ̈?» ");
INSERT INTO daf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A ‑dhɛ 'yaa‑ ‑bha kö 'mɛ 'wo nu dhe dɔ troo ‑ta ‑wa pö‑ ‑nu ‑dhɛ ꞊dhɛ 'wa 'dho ‑bhöpë zun wo \"dhi ‑bha, \"kɛɛ kö dhesügɔn yöö ꞊dede ‑yö mü (kö‑ ‑nu ꞊nii ‑yö ‑da sië). ");
INSERT INTO daf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","‑A ‑gɛn ‑mü ꞊dhɛ ‑a \"tʋ̈ng ‑yö nu sië 'ö‑ ‑nu \"yan‑ dho ꞊fië dhesügɔn bha‑ 'ka, ‑a yi 'ö bha ꞊në ꞊ya ꞊loo kö‑ ‑nu 'sunng‑ 'ma \"tʋ̈ng ꞊ya ꞊loo, (‑a ‑gɛn ‑mü ꞊dhɛ kö ꞊wa kë ‑wëësü).» ");
INSERT INTO daf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","'Yö to 'mü 'ö \"gwënng do ‑da ‑nu ‑dhɛ 'ö‑ pö: «Mɛ 'bha 'yaa sɔ ‑dee \"pɛ kö ‑ya \"pɛn 'sü ‑ya ꞊nëng sɔ zii ꞊dhong \"dhiʋ̈, ꞊ya kë \"dhʋ̈ kö‑ ‑mɛ ꞊ya sɔ ‑dee ‑sü bha‑ \"pɛ \"wɛɛwɛɛ, ‑a ‑gɛn ‑mü ꞊dhɛ yö ‑zë ‑ya \"pɛdhɛ ‑da ꞊në‑ wo \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","꞊Ya 'go mü 'zü, mɛ 'bha 'yaa we ‑kiansü ‑da puu\" zii 'gü, ‑ya ‑wü 'ö‑ we ‑yö ꞊wɛnng, 'yö ‑kë pë ꞊plɛ 'gü see‑ ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","\"Kɛɛ ‑wo we suu bha‑ ‑loo puu\" ‑dee ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","꞊Ya 'go mü 'zü, 'mɛ 'ö ꞊ya we \"dhiʋ̈‑ 'gü dɔ, we ‑dee ‑dhɔ 'yaa‑ kë, ‑ya zii fië‑ ‑bho ‑a ‑dee ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Zuifö ‑nu ‑bha ꞊glooyi do 'ka kö Yesu ‑yö ziö sië ‑mlü suu 'wo‑ ‑kë 'bluu‑ 'ka 'wo‑ ‑dhɛ 'ble‑ bha‑ ‑bhlaa do 'gü, kö din‑ ꞊yaa‑ ‑bha ꞊klang ‑nu 'kun, 'yö 'wo ‑ya ‑mlü bha‑ ‑kpaa ‑wo 'gü ‑sü ‑bha, 'yö 'wo‑ ꞊slëë wo ꞊kwɛɛ‑ 'yö 'wo‑ ga bɔ wo \"dhi 'wo‑ ‑bhö. ");
INSERT INTO daf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","꞊Dhɛ 'ö Fadhiziɛn ‑nu 'wo‑ ‑dhɛ yö 'yö 'wo‑ pö‑ ‑nu ‑dhɛ: «‑Yö mü ꞊dhɛ 'yö 'wɔn 'ö kwaa‑ 'tɔng‑ ‑ya kë ‑sü ‑bha ‑dhio dɔ ꞊glooyi 'ka bha ka ‑zë 'ka‑ ‑kë?» ");
INSERT INTO daf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Wɔn 'ö Davi ‑ya kë yi 'bha 'ka 'ö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü bha 'kii‑ ‑wʋ ꞊në‑ pö \"ɛɛn 'kaa‑ 'gü ꞊në‑ ma ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","(‑A pö 'ö‑ wo ꞊dhɛ) ꞊dhɛ 'ö din‑ ꞊ya waa‑ ö ꞊kengmɛ ‑nu 'kun, ‑yö ‑dho 'ö ‑da Atanna ‑dhɔkëgükɔ 'gü, 'ö 'bluu‑ 'wo‑ ‑ya Atanna ‑dhɔkë 'ka ‑pë 'ka bha‑ sü 'ö dho‑ 'ka 'ö waa‑ ‑bha mɛ ‑nu 'wo‑ ‑bhö, \"kɛɛ 'sa kö ‑yö ‑bɛn zë ‑sü 'ka kwaa‑ 'tɔng‑ 'gü ꞊dhɛ ‑yö \"saabhomɛ ‑nu ‑dɩ ‑slɔɔ ꞊në‑ ‑nu ‑bhöpë 'ka bha 'kii‑ ma ‑ee? ꞊Ya kë \"dhʋ̈ kö 'wɔn 'ö ma ꞊klang ‑nu ‑wa ‑kë bha‑ ‑kë 'wɔn yaa 'ka ‑dhɛ ꞊në 'mɛ?» ");
INSERT INTO daf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'go mü 'ö‑ pö‑ ‑nu ‑dhɛ: «‑Yö kë ka \"yaan ꞊dhɛ mang Mɛgbömɛ ma ꞊në ma ꞊glooyi 'dhö 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Zuifö ‑nu ‑bha ꞊glooyi do 'bha 'ka 'zü, 'yö Yesu ‑yö dho ‑a ‑nu bha ‑yakwëëkëgükɔ 'gü 'yö ‑ya mɛ draan‑ ‑sü ‑bha. 'Mɛ 'ö gun‑ ‑nu ꞊klang kë sië \"dhʋ̈ bha mɛ do‑ ‑gun mü 'ö‑ ‑kɔ ‑së 'gü ‑gbe ‑yö gun ga ‑sü 'ka‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Atanna ‑bha 'tɔnggɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu 'wo gun mü bha 'ö gun \"dhʋ̈ kö wo Yesu 'suan‑ bho sië, 'ö 'wo wo \"yan kpɔ‑ këwɔn ‑nu \"piʋ̈ 'kpakpadhö, kë \"dhʋ̈ kö ꞊ya \"yuëdhi 'bha dha 'yi bha‑ 'ka kö 'wo‑ ‑dhɛ yö; ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑wa ‑gɛn mɔɔ‑ sië kö za 'wo dho‑ dɔ‑ ‑bha ‑wa ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","꞊Dhɛ 'ö ‑kë ꞊dhɛ Yesu ‑yö 'mɛ 'wo bha‑ ‑nu ‑zʋ \"piʋ̈ ‑wɔn ‑dɔ, 'yö‑ pö 'mɛ 'ö‑ ‑kɔ do‑ gun ga ‑sü 'ka‑ ‑bha bha‑ ‑dhɛ 'ö‑ pö: «‑Bhö \"wlü kö 'i dɔ mɛ kpö 'gü yö!» ꞊Dhɛ 'ö 'mɛ bha ꞊ya \"wlü ꞊ya dɔ ö ‑gɛan 'mɛ 'wo bha‑ ‑nu ꞊zinng 'gü, ");
INSERT INTO daf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","'yö Yesu ‑ya ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «'Wɔn 'ö kwaa‑ 'tɔng‑ ‑yö kwa ꞊klang ‑kë 'ka ꞊glooyi ‑wɔn 'gü yö ‑mü ‑më 'ka? ‑Ya ‑pö 'kwa 'wɔn ‑së kë ‑ee? \"Ɛɛn 'kwa 'wɔn yaa ꞊në‑ kë ‑ee, 'kwa mɛ dha ‑ee, \"ɛɛn 'kwa‑ ‑mɛ to mü kö‑ 'gü ‑yö see‑ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑nu ‑ta ‑ga, 'yö‑ pö 'mɛ bha‑ ‑dhɛ: «‑Bhö i ‑gbe 'gü \"pʋ!» 'Yö‑ 'gü ‑pʋ, 'yö‑ ‑kɔ bha 'ö pa ö diëë, 'yö bo. ");
INSERT INTO daf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Wɔn 'ö Yesu ‑ya ‑kë \"dhʋ̈ ꞊glooyi 'ka bha, 'pu 'ö‑ wo ‑gɔmɛ ‑nu bha‑ ‑nu ‑bha, ‑a ‑naa 'yii kë, 'yö 'wo ‑ya 'pë 'wo dho‑ kë Yesu 'ka ‑a \"slën bho ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","‑A \"tʋ̈ng ꞊dede 'ö \"dhʋ̈ bha‑ 'ka, 'yö Yesu ‑yö ꞊wlü 'yö dho ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü ‑tɔn ꞊gbin‑, 'yö ‑wɔ 'gü \"yaan 'yö ‑dhɛ ‑yö ꞊kpaɔ. ");
INSERT INTO daf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","꞊Dhɛ 'ö ‑dhɛ ꞊ya ꞊kpaɔ, 'yö ö ‑bha ꞊klang ‑nu ‑dhɛ, 'yö‑ mɛ ‑kaɔng do ga ꞊plɛ zë‑ 'gü, 'yö‑ ‑nu ‑ya ö ‑bha bɔmɛ ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","'Mɛ 'ö‑ ‑nu ‑ya \"dhʋ̈ bha ‑wa mɛ do ‑dhɛ Simɔ, 'yö‑ 'tɔ ‑ya ‑ta ‑dhɛ Piɛdhö. 'Yö 'wo‑ mɛ do 'bha ‑dhɛ Andre, 'yö ‑kë Piɛdhö 'zlaa‑ 'ka, 'yö Zakö waa‑ Zan, 'yö Fidhipö, 'yö Batedhemi, ");
INSERT INTO daf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","'yö Matiö, Toma, 'yö Adhöfe gbö Zakö, 'yö Simɔ 'dhɛ 'wo‑ ‑dhɛ «\"sɛtakozëmɛ» ");
INSERT INTO daf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","'yö Zudë 'ö ‑kë Zakö gbö 'ka waa‑ Zuda Isikadhiɔtö 'ö Yesu go bha. ");
INSERT INTO daf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","꞊Dhɛ 'ö ꞊ya ö ‑bha bɔmɛ ‑nu bha‑ ‑nu ‑ya \"dhʋ̈, 'yö wɛng‑ ‑nu 'wo ꞊lɔɔ, 'yö 'wo dho 'wo ꞊loo ‑dhɛ \"gbɛa ‑dhɛ do 'gü, kö‑ ‑bha ꞊klang ‑nu kpö 'dhɛ 'wo to ‑wo dɔ sië‑ ‑gɔ mü, waa‑ mɛbhɩɩdhe \"dhaa 'wo go Zude ‑sɛ ꞊gban \"pɛpɛ 'gü waa‑ Zedhizadhɛmö ‑dhɛ ‑nu waa‑ 'pödhɛ ‑nu 'wo \"yi \"kpʋng \"dhiʋ̈ ‑dhɛ ‑nu 'gü, Tii‑ ‑dhɛ ‑nu waa‑ Sidɔn ‑dhɛ ‑nu 'gü ‑a ‑nu 'dhö, kö ꞊wa nu kö ‑wo wo \"tʋ 'to‑ ‑wʋ ‑bha, kö ‑yö wo dha woo‑ \"yua ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","'Yö 'mɛ 'ö \"yina yaa ‑yö gun‑ ‑nu ‑wëë ‑kë wo sië bha 'wo nu‑ \"piʋ̈, 'yö 'wo dha. ");
INSERT INTO daf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mɛ \"pɛpɛ 'wo bha‑ ‑nu ꞊gban‑ ‑gun ‑kɔ ‑zun Yesu bha ‑dhɛ ꞊në‑ mɔɔ‑ sië, ‑a ‑gɛn ‑mü ꞊dhɛ 'gügbɩɩdhɛ 'ö gun‑ 'gü bha ꞊në gun‑ ‑nu dha sië‑ ‑nu ‑bha \"yua ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'daɔnnu 'yö ö ‑bha ꞊klang ‑nu ‑ta ‑ga 'yö‑ pö: «'Mɛ 'ka \"flɛɛmɛ ‑nu 'ka ka ‑bha ‑së; ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ ‑yö ‑ya kaa‑ ‑ya 'gü. ");
INSERT INTO daf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'Mɛ 'ö din‑ 'dhö ka ‑bha ka ‑bha ‑së; ‑a ‑gɛn ‑mü ꞊dhɛ ka 'kën ‑wɔn ‑yö ‑dhö! 'Mɛ 'ka \"gbʋ bɔ sië \"tʋ̈ng ya‑ 'gü ka ‑bha ‑së; ‑a ‑gɛn ‑mü ꞊dhɛ ka ꞊niida ‑wɔn ‑yö ‑dhö! ");
INSERT INTO daf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Mɛ 'ö mɛ \"bhɩɩ‑ ‑nu 'wo dho ‑ya ka ‑san 'ka \"ɛɛn 'wo dho 'tɔng ‑ya ka ‑ta ‑nu wo, \"ɛɛn 'wo \"si ‑nu bho ka ‑gɔ, \"ɛɛn 'wo kpaɔ ‑pɛ ka ‑bha mang Mɛgbömɛ n ‑wɔn 'gü, kö ka ‑bha ‑së. ");
INSERT INTO daf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","꞊Ya kë \"dhʋ̈ ka ꞊nii ‑yö ‑da kö 'ka ‑së kë‑ \"dhiʋ̈, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ ka ‑dho ‑a ꞊trɔɔn 'kpii‑ ꞊slɔɔ dhang‑ 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu \"bhɛma ‑nu ‑dɔ 'ka ‑mü, ‑wo kë ‑kë \"dhʋ̈ Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'ka yi 'bha 'ka. ");
INSERT INTO daf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","\"Kɛɛ 'mɛ 'kö ka ‑zë 'ka ꞊naɔmɛ ‑nu 'ka \"tʋ̈ng ya‑ 'gü bha ka ‑bha ‑yö ‑wëësü; ‑a ‑gɛn ‑mü ꞊dhɛ ka ‑bha ꞊në 'ka‑ kë sië bha (\"kɛɛ dhia\" ‑zë 'yaa ka ‑bha ‑së!) ");
INSERT INTO daf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","'Mɛ 'ka 'kënsü 'ka \"tʋ̈ng ya‑ 'gü bha ka ‑bha ‑yö ‑wëësü; ‑a ‑gɛn ‑mü ꞊dhɛ din‑ ‑dho ka kë. 'Mɛ 'ka \"yɩɩ 'to sië \"tʋ̈ng ya‑ 'gü bha, ka ‑bha ‑yö ‑wëësü; ‑a ‑gɛn ‑mü ꞊dhɛ ‑wëë ‑dho bɔ ka ‑ta 'ö 'ka \"gbʋ bɔ! ");
INSERT INTO daf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'Mɛ 'ö mɛ ꞊gban \"pɛpɛ 'wo ka ‑dhiang ‑së zë sië bha, ka ‑bha ‑yö ‑wëësü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu \"bhɛma ‑nu kë ‑gleng do bha ꞊në‑ ‑kë Atanna ‑wʋ ꞊kwaanmɛ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yö ꞊në‑ ‑wɔn 'gü, 'yö 'mɛ 'ka ka \"tʋ 'to sië n ‑wʋ ‑bha bha, 'a dho‑ pö ka ‑dhɛ ꞊dhɛ ka ‑zë ka 'yaɔ‑ ‑nu ‑dhɔ ‑yö ka kë, kö 'ka 'wɔn ‑së kë 'mɛ ka ‑san ‑ya ‑nu ‑kë ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","‑Ka 'dhuë‑ kë 'mɛ 'wo \"dhang ‑da sië ka ‑bha bha‑ ‑nu ‑bha, kö 'ka bhɛa\" Atanna ‑dhɛ 'mɛ 'wo ka ‑wëëdhɛ bho sië‑ ‑nu ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","꞊Ya kë ꞊dhɛ ꞊wa ka \"tʋ \"pɛan do ‑ma, ‑kaa \"pɛan do 'dhɛ 'ö to‑ slëë‑ ‑mɛ ‑ta kö ‑ya ‑ma 'pö. ꞊Ya kë ꞊dhɛ ꞊wa ka ‑bha ꞊gbauu‑ 'sü ka ‑gɔ (faandhɛ ‑bha), ‑kaa ‑mɛ 'to mü kö ‑yö kaa‑ \"bhɛɛ ‑nu ꞊gban 'sü. ");
INSERT INTO daf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mɛ \"ʋʋ mɛ 'ö pë ‑gbadhɛ ka ‑gɔ, ‑kaa nu‑ ‑mɛ ‑dhɛ. ꞊Ya kë ꞊dhɛ mɛ 'bha ꞊ya ka ꞊slɔɔpë 'sü ka ‑gɔ, ‑kaa 'to‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","'Pë 'ö 'ka‑ \"piʋ̈ ꞊dhɛ ‑wa kë ka ‑dhɛ bha kaa ‑dɩ 'pö ‑kaa kë mɛ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","꞊Ya kë ꞊dhɛ 'mɛ 'ö ka ‑dhɔ ‑ya ‑nu ‑kë wo ꞊në‑ ‑nu ‑dhɔ ꞊ya ka kë doseng bha ‑oo, kö ka ‑bho \"kpʋngtaamɛ ‑nu \"piʋ̈ ‑dhɛ 'pö 'mɛ? Mɛ ꞊gban ‑wa 'dhɛ 'kö bha‑ ‑kë! ");
INSERT INTO daf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","꞊Ya kë 'zü ꞊dhɛ 'ka 'wɔn ‑së kë 'mɛ 'wo 'wɔn ‑së ‑kë ka ‑dhɛ ꞊në‑ ‑nu ‑dhɛ doseng bha ‑oo, kö ka ‑bho 'ko \"piʋ̈ ‑dhɛ 'pö 'mɛ? 'Wɔnyaakëmɛ ‑nu ‑wa yö ‑zë ‑kë 'pö! ");
INSERT INTO daf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","꞊Ya kë ꞊dhɛ 'ka \"pɔ dɔ 'mɛ 'ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ ‑yö ‑dho ‑a bho bha ꞊në‑ ‑mɛ ‑bha doseng bha ‑oo, kö ka ‑bho \"kpʋngtaamɛ ‑nu \"piʋ̈ ‑dhɛ 'pö 'mɛ? Woo ‑dɩ 'pö ‑wo \"pɔ ‑dɔ mɛ ‑nu ‑bha \"dhʋ̈ kë \"dhʋ̈ kö 'wo‑ \"wɛɛ ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ka ‑zë ka 'yaɔ‑ ‑nu ‑dhɔ ka kë kö 'ka 'wɔn ‑së kë do 'ka 'dho‑ 'ka, kö 'ka \"pɔ dɔ 'ka 'dho ka ‑zʋ 'gɔn‑ bho ‑wɔn ‑dhɛ. ꞊Ya kë \"dhʋ̈ ka ꞊trɔɔn‑ ‑dho kë 'kpii‑ dhang‑ 'gü, 'ö mɛ ꞊gban 'wo ka dɔ Atanna 'ö dhang‑ 'gü ‑a ‑bha 'në ‑nu 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a \"klʋ ‑yö ‑së 'mɛ 'waa 'wɔn ‑së dɔ bha waa‑ \"gblüyaamɛ ‑nu ꞊gban 'ka. ");
INSERT INTO daf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","‑A ‑kë \"dhʋ̈ ‑sü ‑wɔn 'gü, ka Dë 'ö dhang‑ 'gü bha mɛbhɩɩdhe ‑wëë 'dhö‑ kë ‑kɔ do 'ö‑ ‑bha bha mɛ ‑wëë ‑yö ka kë 'pö‑ ‑kɔ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","'Ka 'dho mɛ ‑nu ‑dhiang yaa zë kö Atanna ‑dɩ 'pö 'ya 'dho za dɔ ka ‑bha. 'Ka 'dho 'tɔng‑ ‑ya mɛ ‑ta kö Atanna yöö ‑dɩ 'pö 'ya 'dho 'tɔng‑ ‑ya ka ‑ta. ‑Ka mɛ ‑nu ‑mawɔn 'to kö Atanna ‑dɩ 'pö ‑yö ka ‑mawɔn 'to. ");
INSERT INTO daf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","‑Ka gbaɔ‑ mɛ ‑nu ‑gɔ, kö Atanna ‑dɩ 'pö ‑yö gbaɔ‑ ka ‑gɔ. ‑Yö ‑dho pë dan 'ö pë pa 'ö ꞊wɛnng ‑zü 'ö‑ sü 'ö‑ ꞊loo ka ‑gɔ ꞊gbauu‑ \"yië‑ 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ pë do 'ka dho‑ 'sü 'ka pë dan‑ ‑bha mɛ ‑nu ‑dhɛ bha ꞊në 'ö dho‑ 'sü 'pö 'ö ka ‑bha dan‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","'Yö \"gwënng \"wɛɛ do 'bha ‑da ‑a ‑nu ‑dhɛ 'ö‑ pö: «\"Ɛɛn ‑yö ka 'gü ꞊dhɛ \"yanwlümɛ ‑mɔɔ ‑bha 'ö zun \"yanwlümɛ 'bha ‑dhɛ \"dhiʋ̈, 'yö‑ ꞊gban ꞊plɛ 'waa ‑pö ‑yɛ 'gü ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","‑Yö kë ka \"yaan ꞊dhɛ ꞊klangdhiʋ̈ ‑zë yöö pë dɔ ‑kɔ \"ʋʋ ‑kɔ 'ö‑ 'gü, 'yii 'dho ziö ö ‑gɔmɛ ‑zë ‑ta. ꞊Ya kë ꞊dhɛ ꞊ya pë dɔ \"gbɩɩ‑, ‑yö ‑mɔɔ ‑bha 'ö ꞊mɔɔ ö ‑gɔmɛ 'ka, \"kɛɛ 'yii 'dho ziö ‑zë wo‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‑Më ꞊në ‑kë 'yö 'i \"yɛ ‑bi yö mɛ ‑nu ‑zë ‑nu \"yan ‑bha, 'yö 'bhaa \"dhü ꞊blün 'kö bhi ‑zë i \"yan ‑bha bha‑ yö? ");
INSERT INTO daf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","\"Ɛɛn i ‑mɔɔ ‑bha 'i‑ pö mɛ ‑dhɛ ꞊dhɛ: «N \"taɔngdë, ‑bhö dɔ kö 'a blëë bho i \"yan ‑bha ‑kɔ kë ꞊dhɛ kö \"dhü ꞊blün 'ö bhi ‑zë i \"yënng bha 'bhii‑ bho mü. \"Gblʋ̈ʋ̈dhɛtiimɛ, ‑bhö \"dhü ꞊blün 'ö i \"yënng bha‑ bho 'mü ꞊kö ‑blɛɛsü kö 'i ‑dhɛ yö ‑së 'ka kö 'i gun ‑na \"yɛ ‑bi bho i \"tɛado \"yënng ");
INSERT INTO daf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‑Yö kë ka \"yaan ꞊dhɛ \"dhü ‑së 'yaa bhɛ yaa dɔ, \"ɛɛn \"dhü yaa 'yaa bhɛ ‑së dɔ 'pö; ");
INSERT INTO daf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","‑a ‑gɛn ‑mü ꞊dhɛ \"dhü 'ö 'dhö ‑wa suu ‑dɔ ö bhɛ ꞊në‑ ‑bha. 'Waa \"dhü \"wɛɛ bhɛ bho \"dhü \"wɛɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Zuëga ‑së 'dhö 'mɛ 'ö \"gblʋ̈ʋ̈‑ ‑a ‑mɛ ‑bha \"klʋsëdhɛ ‑gɛn ‑yö ‑gban ‑a zuëga bha ꞊në‑ ‑bha, 'yö zuëga yaa 'dhö mɛ 'ö \"gblʋ̈ʋ̈‑ 'ö‑ ‑bha ‑mawɔnyaadhɛ ‑gɛn ‑yö go 'pö‑ zuë\" 'gü ꞊dhɛ ‑kɔ do bha‑ 'dhö; ‑a ‑gɛn ‑mü ꞊dhɛ pë 'ö mɛ zuë\" \"piʋ̈ 'yö ‑wo mɛ \"dhi ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «N ‑dhɛ 'ka‑ wo n Dëmɛ, n Dëmɛ ya‑ ‑gɛn ‑mü ‑më 'ka \"kɛɛ kö 'pë 'a‑ pö ka ‑dhɛ 'kaa‑ 'bha kë? ");
INSERT INTO daf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","'Mɛ ꞊ya bɔ n 'ka 'ö n ‑wʋ ‑ya 'klɔɔ‑ \"dhiʋ̈, 'ö ‑tosɛa ‑kë ‑bha bha 'ö bhɔ pë 'dhɛ 'ö‑ ‑bha a ‑dho ‑a pö ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","‑A ‑mɛ ‑yö ‑bhɔ gɔndënë do 'ö‑ pö yöö 'kɔ dɔ, 'ö ö ‑bha 'kɔ bha‑ \"kpan \"sɛ pɔn 'ö dho 'ö zun‑ 'ka ‑gwë ‑bha, 'ö dho 'ö 'kɔ bha‑ ‑gɛn ‑gban ‑gwë ‑ta ꞊në‑ ‑bha. ꞊Dhɛ 'ö ꞊yaa‑ 'kɔ bha‑ dɔ, yi do 'ka 'yö dha ‑yö ban, 'yö \"yi ‑yö pa, 'yö \"yi \"tɛɛ ‑yö nu ‑yö ‑gban 'kɔ bha‑ ‑bha, \"kɛɛ 'yö 'yii 'wü, ‑a ‑gɛn 'ö ‑gban ‑sü 'ka ‑gwë ‑ta bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","\"Kɛɛ mɛ 'ö bɔ n 'ka 'ö n ‑wʋ ma, \"kɛɛ 'ö 'yaa‑ ‑yaki ‑ya, 'ö‑ \"tʋ 'yaa kë‑ ‑bha ‑a ‑mɛ ‑yö ‑bhɔ 'mɛ 'ö‑ pö 'ö 'kɔ dɔ, 'ö 'yii 'kɔ \"kpan \"sɛ 'pɔn kö ‑ya ‑gɛn ‑da \"sɛɛ, \"kɛɛ 'ö‑ \"kpan ‑ya 'tëng‑ ‑ta \"wɛɛwɛɛ ꞊në‑ ‑bha. ꞊Dhɛ 'ö ꞊yaa‑ dɔ, 'yö dha ‑yö ban, 'yö \"yi ‑yö pa, 'yö \"yi \"tɛɛ ‑yö nu 'ö ‑gban 'kɔ ‑bha. \"Kɛɛ 'yö 'yii dha‑ ‑gɔ, ‑pö 'ö‑ wo 'ö wü, ‑yö kë ‑wü ‑trëkë ‑trëkëdhö. ");
INSERT INTO daf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","꞊Dhɛ 'ö Yesu ꞊ya ziö 'mɛ 'wo bha‑ ‑nu ‑dhɛ 'wɔn ‑nu 'gü \"dhʋ̈ 'dɔɔndhö, 'yö ‑ziö 'ö dho Kapɛɛnaɔmö. ");
INSERT INTO daf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","'Ö gun \"dhʋ̈ kö Wlɔmö ‑mɛ ‑nu ‑bha \"sɔdha ‑gɔmɛ do 'bha bha‑ ‑bha gwëëmi 'ö‑ ‑wɔn 'dhö‑ ‑gɔ \"gbɩɩ‑ ꞊dedewo bha‑ 'gü 'yaa ‑së, kö ꞊ya wɔ \"dhëng yaa \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","꞊Dhɛ 'ö \"sɔdha ‑gɔmɛ bha 'ö Yesu ‑wɔn ‑taɔng ma, 'yö Zuifö ‑nu ‑bha mɛ zizi 'bha ‑nu bɔ 'mü kö ‑wo 'dho ‑wo bhɛa\" Yesu ‑dhɛ kö ‑yö nu kö ‑yö ö ‑bha gwëëmi bha‑ dha ö ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","'Yö 'mɛ 'wo bha 'wo dho 'wo ꞊loo Yesu ‑dhɛ 'gü, 'yö 'wo ꞊bhɛa‑ ‑dhɛ ꞊dedewo ‑sɔbhɛɛ 'ka 'wo‑ pö: «‑Bhö dɔ ꞊në‑ wo \"gbɩɩ‑ kö 'i \"ta 'mɛ bha‑ ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ bha 'mɛ 'ö ꞊ya mɛ ‑dhɛ 'ö mɛ‑ dho‑ ‑bha ꞊dhiɔwʋ ‑bha ‑a ‑mɛ ‑mü; ");
INSERT INTO daf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","‑a ‑gɛn ‑mü ꞊dhɛ yii‑ \"sɛgɔ ya‑ ‑dhɔ ‑ya ‑kë, yö ꞊në yii‑ ‑yakwëëkëgükɔ ya‑ dɔ.» ");
INSERT INTO daf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","'Mɛ 'wo bha 'yö waa‑ Yesu ‑nu 'wo ‑ziö 'wo dho. ꞊Dhɛ 'ö ꞊wa ꞊tëng \"sɔdha ‑gɔmɛ bha‑ ‑bha 'kɔ ‑ta, 'yö gɔndë bha 'ö ö ‑sëmɛ 'bha ‑nu bɔ Yesu ‑dhɛ. 'Yö 'mɛ bha 'wo‑ pö Yesu ‑dhɛ: «Yi Dëmɛ, yi \"taɔngdë ‑ya pö 'yi nu kö 'yi‑ pö i ‑dhɛ ꞊dhɛ 'bha 'dho i ‑dɩ ziö \"yɛ 'gü \"wɛɛwɛɛ, \"kɛɛ ö ꞊bhlëë 'yaa 'dhö kö 'i ‑da ö ‑gɔ 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yö ꞊në‑ ‑wɔn 'gü 'yö yöö ꞊dede 'yii nu i ‑dhɛ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ö ‑dɩ ‑dɔ ꞊dhɛ 'yaa ‑wo i wëëdhö ‑mɛ 'ka. \"Kɛɛ 'ö 'dhang ‑bho \"dhiʋ̈ ꞊dhɛ 'bha 'to yö kö 'i \"dhiyanwʋ do ‑zian pö, ö ‑bha gwëëmi bha‑ ‑dho dha. ");
INSERT INTO daf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","‑A ‑gɛn ‑mü ꞊dhɛ yöö ‑dɩ 'pö ö ‑gɔdhiʋ̈mɛ ‑dhö, \"kɛɛ ‑yö ö ‑bha ‑pö 'pö ö ‑kɔwlöömɛ ‑nu ‑dhɛ 'wo‑ ma, 'ö‑ pö mɛ 'bha ‑dhɛ: «‑Bhö 'dho!» 'ö dho, 'ö‑ pö mɛ 'bha ‑dhɛ: «‑Bhö nu!» 'ö nu, 'ö‑ pö ö ‑bha gwëëmi ‑dhɛ: «‑Bhö ‑a kë ꞊ni!» 'ö‑ ‑kë. (\"Sanni ‑wa kë yö ‑zë ö ‑dhɛ \"dhʋ̈ 'yö bhi ‑zë ꞊wɛ?») ");
INSERT INTO daf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","꞊Dhɛ 'wo naɔ bha‑ dɔ Yesu ‑gɔ 'ö‑ ma ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö \"sɔdha ‑gɔmɛ bha‑ ‑wɔn \"dhia ‑yö ma‑ 'gü ‑a ‑wʋ bha‑ \"piʋ̈. 'Yö ö wɔ ꞊slëë mɛ kpö 'wo gun‑ ꞊keng‑ bha‑ ‑nu ‑ta 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mii 'dhang bho n \"dhiʋ̈ ‑mɛ 'ö ꞊dhɛ 'mɛ ya‑ 'dhö ‑a yö Izraɛdhö ‑mɛ ‑nu ‑zian kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","'Mɛ 'wo nu naɔ dɔ bha‑ ‑nu yee kë ‑sü 'ka kö ‑wo 'dho \"kwɛandhö, \"sanni ‑wo 'dho kö ‑wo ꞊loo kö gwëëmi 'ö‑ 'gü 'yaa gun ‑së bha ꞊ya kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","‑A ‑dhɛkpaɔyi 'dhɛ 'ö dɔ‑ \"piʋ̈, 'yö Yesu ‑yö dho 'pödhɛ do 'bha 'wo‑ ‑dhɛ Naɛ bha‑ 'gü kö‑ ‑bha ꞊klang ‑nu waa‑ mɛ kpö 'gbɛ ‑wa ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo 'pö‑ \"saan \"dhiʋ̈, 'wo dho ‑dhɛ ‑ga kö ‑wo 'dho sië mɛ ꞊gee do 'bha ‑wɛɛ bho ‑dhɛ 'gü, 'nëglɔɔnnë 'wo gun 'dho sië‑ 'ka \"dhʋ̈ bha ꞊gɛandhe 'bha gbö ꞊në gun‑ 'ka, \"kɛɛ ‑yö ‑gun ö dhe ‑gɔ \"dhʋ̈ doseng. Kö mɛ kpö 'kpii‑ 'wo go 'pödhɛ bha‑ 'gü 'wo 'dho sië 'në bha ‑wɛɛ bho ‑dhɛ 'gü bha ꞊wa dɔ dhebhɔ bha‑ ꞊keng‑ \"wɛ ‑dungdhö. ");
INSERT INTO daf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","꞊Dhɛ 'ö kwa Dëmɛ ‑ya yö, 'yö ‑wëë ‑yö bɔ‑ ‑ta 'yö‑ pö‑ ‑dhɛ: «'Bha 'dho \"gbʋ bɔ, dhebhɔnë!» ");
INSERT INTO daf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","'Yö ꞊yɔɔn mɛ ꞊gee bha‑ \"sɔɔ, 'yö ö ‑kɔ ‑ya ‑bha. 'Yö 'mɛ 'wo gun‑ bun sië bha 'wo wo bo 'wo 'daɔnnu, 'yö‑ pö: «'Nëglɔɔnnë, ‑bhö \"wlü, ma ꞊në 'a‑ pö!» ");
INSERT INTO daf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö mɛ bha 'ö ꞊wlü 'ö ‑ya ö ‑gɛan, 'yö zun dhiang zë ‑sü ‑bha. 'Yö Yesu ‑ya sü 'ö‑ nu‑ dhe ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","'Yö \"suʋ̈ 'dhö ‑da mɛ 'wo gun mü bha‑ ‑nu ꞊gban \"pɛpɛ 'gü, 'yö 'wo ‑ya Atanna 'tɔ bhɔ ‑sü ‑bha 'wo‑ pö: «Atanna ꞊ya ö ‑wʋdhiʋ̈loomɛ 'kpii‑ do bɔ kwa ‑dhɛ, ‑a ‑zʋ ꞊ya ‑bö (Izraɛdhö ‑mɛ ‑nu 'ö yi sü 'ö yi ‑ya ‑dɩ ‑ta ö ‑bha 'ka) bha yi ‑wɔn ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","'Wɔn 'ö Yesu ‑ya ‑kë \"dhʋ̈ bha, 'yö‑ ‑taɔng ‑yö dho 'ö ꞊mɔɔ Izraɛdhö ‑sɛ ꞊gban \"pɛpɛ 'gü waa‑ ‑züzü ‑dhɛ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","'Yö 'wɔn ‑nu 'ö Yesu gun‑ kë sië bha Zan ‑bha ꞊klang ‑nu 'wo dho 'wo‑ ꞊gban ‑gɛn dɔ‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'Yö Zan ‑ya mɛ ꞊plɛ ‑dhɛ 'yö‑ ‑nu bɔ Yesu \"piʋ̈ kö ‑wa dhɛɛ\" 'kpɔ ‑wa pö: «'Mɛ 'wo ‑ya ‑gɔ bha yö ‑mü yö ꞊në‑ 'ka ‑ee, \"ɛɛn ‑wo ‑tun ꞊kö dɔ mɛ \"wɛɛ 'bha ‑gɔ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo mü, 'yö 'wo‑ pö Yesu ‑dhɛ: «Zan Mɛzumɛ ‑yö yi ‑bɔ i \"piʋ̈ kö 'yi i dhɛɛ\" 'kpɔ ꞊dhɛ 'mɛ 'yi ‑ya ‑gɔ bha yö ‑mü i 'ka ‑ee, \"ɛɛn yi ‑tun ꞊kö ‑ya mɛ \"wɛɛ 'bha ‑gɔ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","‑Wo ‑to ‑dhɛ do bha‑ 'gü, 'yö Yesu ‑yö mɛ 'gbɛ dha ‑a ‑nu ‑bha \"yua ‑nu oo, ‑a ‑nu ‑bha ꞊niɔɔdhɛ ‑nu waa \"yina yaa ‑nu ‑gɔ, 'yö \"yanwlümɛ 'gbɛ \"yan \"dhiʋ̈ ‑pʋ. ");
INSERT INTO daf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Yö dhɛɛ\" bha‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Wɔn 'ö ka \"yan ‑ya yö 'ö ka \"tʋ ‑yö ‑da 'gü bha, ‑ka 'dho 'ka‑ ‑gɛn dɔ Zan ‑dhɛ kö 'ka‑ pö‑ ‑dhɛ ꞊dhɛ: «\"Yanwlümɛ ‑nu ‑wo ‑dhɛ yö sië, 'ö ‑gɛnloomɛ ‑nu 'wo \"ta sü, ꞊weeyuamɛ ‑nu ‑wo kë sië \"klʋ̈ʋ̈klʋ̈, 'ö \"tʋwlümɛ ‑nu 'wo 'wɔn ma, 'ö 'mɛ ꞊wa ga 'wo ‑bö sië, 'ö 'wo Atanna ‑bha naɔ ‑së bha‑ dɔ sië ‑wëëmɛ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mɛ \"ʋʋ mɛ 'ö 'mii kë ꞊dhɛ ‑a ‑gɛn \"dhiʋ̈ ‑zuö ‑bha ‑gwë 'dhö Atanna ‑bha zian ‑ta kö ‑yö ‑pö ‑a ‑wɔn 'gü, kö‑ ‑mɛ ‑bha ‑së.» ");
INSERT INTO daf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","꞊Dhɛ 'ö 'mɛ 'ö Zan ‑ya ‑nu bɔ bha ꞊wa 'dho, 'yö Yesu ‑yö zun dhɛɛ\" 'kpɔ ‑sü ‑bha 'mɛ 'wo gun mü bha‑ ‑nu ‑gɔ Zan ‑bu 'gü 'ö‑ pö: «\"Tʋngtadhɛ 'ö Zan gun‑ 'gü bha, ‑më ꞊në 'ka kë dho‑ ‑ga ‑dhɛ 'gü mü bha? ‑Kaadhüga 'ö \"tɛɛ ‑ya ‑vin 'ö dho‑ 'ka ꞊ni 'ö dho‑ 'ka ꞊ni yö ‑mü ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","\"Ɛɛn mɛ 'bha 'ö sɔ ‑së ‑yö gun‑ ‑bha yö ‑mü ‑ee? \"Ɛɛn ‑më ꞊në 'ka kë dho‑ ‑ga ‑dhɛ 'gü? ‑Ka ‑dhɛ ‑ga! 'Mɛ 'ö sɔ ‑së 'dhö‑ ‑nu ‑bha 'ö 'wo ‑tosɛa ‑së kë sië, ‑wo ‑kë ‑gblüdëdhɛ ‑kɔ ‑nu ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","‑Më ꞊në 'ka kë dho ‑ga ‑dhɛ 'gü 'sa? Atanna ‑wʋdhiʋ̈loomɛ ‑ee? A‑ ‑pö ka ‑dhɛ ꞊ma ꞊iin, ‑a yöö ‑zian ‑zë ꞊bhlëë‑ 'kpii‑ Atanna ‑wʋdhiʋ̈loomɛ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","'Mɛ 'ö Atanna ‑ya ‑dhiang zë ö ‑gɔ 'sëëdhɛ 'gü 'ö‑ pö‑ ‑bha ꞊dhɛ: ‹‑Bhö ‑dhɛ ‑ga, 'ma mɛ bɔ i \"dhiʋ̈ kö ‑yö i ‑bɔ ‑ta ‑zian ‑pë kë bha 'yö bha.› ");
INSERT INTO daf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A‑ ‑pö ka ‑dhɛ kpɛnngdhö ꞊dhɛ: Mɛ \"pɛpɛ 'kö dhebhɔ ‑ya ‑nu kpɔ, ‑a mɛ 'bha 'kö‑ ‑duɛ dho kë 'kpii‑ kö ‑yö ziö Zan ‑bha ‑ta 'yaa 'dhö, \"kɛɛ 'sa kö 'mɛ 'ö mɛ \"bhlëngsü 'ka Atanna ‑bha ‑gblüdëdhɛpö 'gü, yö ‑zë ‑duɛ ‑yö 'kpii‑ Zan ‑zë ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","'Sa mɛ \"pɛpɛ 'kö 'wo Zan dhiang zë ‑dhɛ yö, aa\" ꞊ni 'niisɔngkunmɛ ‑nu ‑zian ‑wo kë 'dhang ‑bho ‑wʋ \"dhiʋ̈ 'ö 'wo tɛanwɔn nu Atanna ‑dhɛ, 'ö 'wo ‑wɩ ‑bha kö ‑yö wo ‑go 'wɔn yaa 'gü ‑zu bho. ");
INSERT INTO daf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","\"Kɛɛ Fadhiziɛn ‑nu waa‑ Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu ‑zë 'wii‑ ‑yɔ bɔ, 'wii \"wɩ‑ ‑bha kö Zan ‑yö wo \"zu. Yö ꞊në‑ ‑wɔn 'gü, 'yö ‑a ‑nu dha 'ö Atanna yöö‑ wo 'nu bha 'wo wo ‑dɩ ꞊fië ‑sü 'ka‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","'Yö go mü 'ö‑ pö: «꞊Ya kë \"dhʋ̈ kö 'mɛ 'wo ꞊dɛɛ ‑yën ya‑ 'gü, ‑a ‑dho ‑a ‑nu ‑zɔn ‑më ꞊në‑ 'ka? ");
INSERT INTO daf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","‑A ‑nu ꞊tɛni‑ ‑kë ꞊dhɛ nuë\" ‑nu 'wo ‑ya ‑sü 'ka \"dhɛɛ 'kpii‑ 'gü, 'wo dhiang zë sië wo 'ko ‑dhɛ ‑a ‑nu 'dhö ꞊dhɛ: «'Ya \"tan bho ka ‑dhɛ kö 'ka‑ kë, \"kɛɛ 'kii \"wɩ‑ ‑bha kö 'ka \"tan kë. Kaa do bha 'ya \"gbʋ bɔ 'zü ka ‑dhɛ, \"kɛɛ 'kii \"gbʋ bɔ! ");
INSERT INTO daf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ ꞊dhɛ 'ö Zan Mɛzumɛ ꞊ya nu \"kpʋng ꞊taa 'ö 'yii we mü, 'ö 'yii ‑bhöpë ‑bhö, 'yö 'ka‑ pö‑ ‑bha ꞊dhɛ \"yina yaa ‑ya 'gü. ");
INSERT INTO daf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","꞊Dhɛ 'ö mang Mɛgbömɛ 'ma nu 'zü 'ö ma ‑zë 'mii we waa‑ ‑bhöpë ‑nu ‑kian 'to, 'yö ka‑ pö n ‑bha ꞊dhɛ we mü ‑dudu ‑mü n 'ka. \"Ɛɛn 'zü a ‑nëng 'niisɔngkunmɛ ‑nu \"ɛɛn Atanna 'tɔ zë ‑mɛ ‑nu ‑bha! ");
INSERT INTO daf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","\"Kɛɛ yö ꞊në‑ ꞊gban 'gü, 'mɛ 'kö 'wo 'wɔndɔmɛ ‑nu 'ka, ‑a ‑nu ꞊gban \"pɛpɛ ‑wo kë‑ 'wɔn ‑dɔ ꞊dhɛ zian 'ö Zan ‑ya ‑zɔn bha ꞊në tɛan‑ ‑zian 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yi do 'ka 'yö Fadhiziɛn mi do ‑yö Yesu ‑dhɛ ‑bhöpë 'ka ö ‑gɔ 'kɔɔdhö. 'Yö dho. ꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo mü, ('yö 'waanu ꞊dhɛ ‑kɔ 'wo‑ ‑kë 'ka wo wɔ ‑kɔ 'gü ‑a 'dhö), 'yö 'wo zun pë ‑bhö ‑sü ‑bha, ");
INSERT INTO daf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","\"kwɛɛkwɛɛkëdhe do 'bha ‑yö ‑gun 'pödhɛ bha‑ 'gü. ꞊Dhɛ 'ö ꞊ya Yesu ‑kë Fadhiziɛn mi bha‑ ‑gɔ 'kɔɔdhö ‑wɔn ma, 'yö dho mü kö ‑sangdhe do 'ö ‑dhasiklɔɔ \"yi 'dhö‑ pa ‑sü 'ka ‑ya ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo mü, 'yö bɔ Yesu ꞊kee‑ ‑ta, 'yö dho‑ ‑gɛn \"piʋ̈ 'yö zun ö kpiö 'gü, 'yö ‑ya \"gbʋ bɔ ‑sü ‑bha, 'yö‑ \"yanyi ‑yö zun ꞊wɛnng ‑sü ‑bha Yesu ‑gɛn ‑ta ‑wla ‑wla ‑wladhö, 'yö ö ‑gɔ \"gblëënu 'yö ö ‑gɔdhɛ kun 'ö‑ ‑ziö ö \"yanyi bha‑ ‑bha, 'yö ö \"dhi ꞊gblü Yesu ‑gɛn bha‑ ‑bha 'yö‑ ‑bha mü, 'yö ‑dhasiklɔɔ \"yi bha‑ ꞊wɛnng‑ ‑gɛn ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","꞊Dhɛ 'ö Fadhiziɛn mi 'ö Yesu ‑dhɛ bha 'ö 'wɔn bha‑ ‑dhɛ yö, 'yö ‑ya ö ‑zʋ 'gɔn ‑sü ‑bha 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'mɛ 'ö ya ‑yö Atanna ‑wʋdhiʋ̈loomɛ ꞊dede 'ka 'nu, kö ‑yö ‑dho dhebhɔ 'ö kë sië‑ ‑bha bha‑ dɔ, 'ö‑ suu dɔ ꞊dhɛ ꞊niëdhe ‑mü. ");
INSERT INTO daf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","\"Kɛɛ Yesu ‑yö ‑zʋgɔndhe bha‑ ‑to ‑a \"gblʋ̈ʋ̈dhö 'ö‑ pö‑ ‑dhɛ: «Simɔ, ‑yö n \"piʋ̈ ꞊dhɛ 'a 'wɔn do 'bha pö i ‑dhɛ.» 'Yö Simɔ ‑ya pö‑ ‑dhɛ: «N Dëmɛ, n \"tʋ ‑yö i ‑wʋ ‑bha, ‑a pö!» ");
INSERT INTO daf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","'Yö‑ pö: «Simɔ, gɔndë do 'bha ꞊në gun 'yö \"pɔ dɔ mɛ ꞊plɛ ‑bha. 'Yö 'wëë‑ \"gblü ‑kaɔng ꞊plɛ \"pɔ dɔ mɛ do bha, 'yö dho 'yö 'wëë‑ \"gblü ꞊plɛ nu mɛ do 'dhɛ to bha‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","꞊Dhɛ 'ö \"pɔ bha ꞊ya ꞊gwëë, 'ö ꞊yaa‑ 'wɔn dɔ ꞊dhɛ ‑a bho \"sɩ 'yaa‑ ‑nu ‑dhɛ, 'yö‑ to \"dhʋ̈ 'ö‑ ꞊gbaɔ‑ ‑nu ‑gɔ.» 'Yö Yesu ‑ya pö Simɔ ‑dhɛ: «'Ma i dhɛɛ\" 'kpɔ: Mɛ ꞊plɛ 'wo‑ ‑nu ‑mawɔn to bha, ‑a de ‑sü 'pö 'mɛ 'ö‑ ‑nu ‑mawɔn to bha‑ ‑dhɔ dho‑ kë 'ö ‑ziö mü?» ");
INSERT INTO daf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","'Yö Simɔ ‑ya ‑yɔ bɔ 'ö‑ pö: «A n ‑zʋ ‑gɔn ꞊dhɛ 'mɛ 'ö‑ ‑bha 'wëë‑ gun 'kpii‑ bha yö ‑mü.» 'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Yö \"dhʋ̈ tɛan‑ 'ka, Simɔ!» ");
INSERT INTO daf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ꞊slëë ö 'gü 'ö ö wë bɔ dhebhɔnë bha‑ ‑ta 'ö‑ pö Simɔ ‑dhɛ 'zü ‑deewo 'ö‑ pö: «‑Bhö ‑dhɛ ‑ga! 'Bha dhebhɔ ya yö ‑ee?» Nu 'a‑ wo i ‑gɔ 'kɔɔdhö ya 'bhii n ‑gɛn ‑bha \"zu (꞊dhɛ ‑kɔ 'kwa‑ ‑kë 'ka kwa wɔ ‑kɔ 'gü bha‑ 'dhö), \"kɛɛ yö ‑zë ꞊ya n ‑gɛn ‑bha \"zu ö \"yanyi 'ka ꞊ya ö wundhɛ ziö‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","'A ‑da i ‑gɔ 'kɔɔdhö 'bhii ‑së kë n ‑bha kö 'i ꞊loo n ‑bha (꞊dhɛ ‑kɔ 'kwa kwa 'ko ꞊tua bho‑ 'ka kwa wɔ ‑kɔ 'gü bha‑ 'dhö), \"kɛɛ 'a ‑da ‑zë wo 'kɔɔdhö yö ꞊dɛɛ, yö ‑zë 'ö zun ‑loo n n ‑gɛn ‑bha ‑sü 'ö‑ bha 'yö‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","'Bhii ‑dhasiklɔɔ \"yi zun n ꞊gbin‑ kö ‑yö kë ꞊dhɛ 'bha ꞊bhlëë ‑ya n ‑bha (꞊dhɛ ‑kɔ 'ö‑ 'ka kwa wɔ ‑kɔ 'gü ‑a 'dhö), \"kɛɛ yö ‑zë ꞊ya ‑dhasiklɔɔ ꞊wɛnng n ‑gɛn ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yö ꞊në‑ ‑wɔn 'gü, Simɔ, 'yö 'a dho‑ pö i ‑dhɛ ꞊dhɛ 'pë 'ö ‑kë 'yö n ‑dhɔ ‑yö dhebhɔnë bha‑ ‑kë \"gbɩɩ‑ \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'wɔn yaa \"pɛpɛ 'ö‑ ‑kë 'ö‑ ‑naa 'yaa gun bha‑ ꞊gban bian ꞊ya 'go‑ ‑bha \"pɛɛpɛdhö; ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'wo‑ ‑mawɔn to 'wɔn 'dɛdɛ 'gü, 'yö‑ mɛ ‑dhɔ ‑ya ‑kë 'dɛdɛ.» ");
INSERT INTO daf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","'Yö‑ pö dhebhɔ bha‑ ‑dhɛ: «Dhebhɔnë, 'bɔn 'ö gun i ‑bha bha‑ ꞊gbaan 'go i ‑bha!» ");
INSERT INTO daf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'mɛ wɛng‑ ‑nu 'wo gun pë ‑bhö sië wo \"kwëë bha 'wo zun wo ‑zʋ 'gɔn ‑sü ‑bha 'wo‑ pö: «'Mɛ 'ö ya de suu ‑mü ꞊zɔɔ 'yö mɛ ‑nu ‑bha 'wɔn yaa ‑nu ꞊gban ‑mawɔn to ya ‑oo?» ");
INSERT INTO daf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","\"Kɛɛ 'yö Yesu 'yii ö \"tʋ kë yö ‑zë ‑bha, 'yö‑ to \"dhʋ̈ 'ö‑ pö dhebhɔnë bha‑ ‑dhɛ: «‑Bhö i ‑bha dho wo i ‑ta \"puu 'ka, i ‑bha 'dhang ‑bho n \"dhiʋ̈ ‑sü ꞊në i dha bha.» ");
INSERT INTO daf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ‑da 'pö‑ \"gblʋ̈gblʋ̈ ‑nu waa‑ 'sɛɛnnë ‑nu ‑bhiëë \"piʋ̈, Atanna ‑bha naɔ ‑së 'ö ‑gban ‑a ‑bha ‑gblüdëdhɛ ‑bha bha‑ dhiang zë ‑sü 'ka. Kö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ‑kaɔng do ga ꞊plɛ bha ‑wa ꞊keng‑ waa‑ dhong ‑nu 'bha ‑nu 'ö‑ ‑nu dha \"yua ‑gɔ, \"ɛɛn 'ö \"yina yaa ‑kë ‑nu 'gü bha‑ ‑nu 'dhö. Dhong ‑nu bha ‑wa mɛ do ‑dhɛ Madhi 'ö go 'pödhɛ 'wo‑ ‑dhɛ Madadha bha‑ 'gü. Madhi bha ꞊në \"yina yaa \"saɔplɛ ‑yö gun‑ 'gü, 'yö Yesu ‑ya bho‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","'Yö Zanö, 'ö ‑kë ‑gblüdë Edhodö ‑bha \"kwɛangɔdhiʋ̈ 'wo‑ ‑dhɛ Suza bha‑ ‑bha dhebhɔ 'ka, 'yö Sizanö waa‑ mɛ kpö 'bha 'ö woo ‑dɩ 'pö 'wo gun waa‑ ‑bha ꞊klang ‑nu ‑a ‑nu ‑ta 'kun sië ‑a ‑nu ꞊slɔɔpë ‑nu 'ka bha‑ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","꞊Dhɛ 'ö yi do 'ka kö mɛ ꞊ya 'go 'pö‑ ‑nu 'gü 'do 'do 'ka ꞊wa bho wo 'ko ‑ta \"tʋ ‑to ‑a ‑wʋ ‑bha ‑dhɛ 'gü, 'yö \"gwënng do ‑da ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Yi do 'ka 'yö gɔndë do ‑yö ꞊wlü 'yö dho ‑mlü bɔ ‑dhɛ 'gü ö ‑gɔ 'bhlaa‑. ꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo mü, 'yö zun ‑mlü ‑pɛn ‑sü ‑bha. ‑A ‑pɛn 'ö‑ wo bha 'yö‑ ga 'bha ‑nu 'wo ꞊wɛnng zian ‑gloo \"piʋ̈ ('yö \"sɛ 'yii kpa‑ ‑ta), 'yö zian ziö ‑mɛ ‑nu 'wo taa‑ ‑ta, 'yö ‑maa ‑ya ‑kpɛa ‑bhö. ");
INSERT INTO daf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","'Yö‑ ‑kɔ \"pɛan 'bha ‑yö ꞊wɛnng ‑gwë 'saa‑ \"dhiʋ̈, ꞊dhɛ 'ö ꞊ya bhɔ 'yö \"kpɛaga \"yi 'ö 'yaa gun \"sɛɛdhö mü bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'Yö‑ ‑kɔ \"pɛan 'bha ‑yö ꞊wɛnng \"glɛɛn ‑kpɔɔ 'gü, 'yö bhɔ, \"kɛɛ waa‑ \"glɛn ‑wo ‑bhɔ 'ö 'wo ꞊kpɛa wo \"kwëë, 'yö \"glɛn faan ‑yö ‑kë ‑ta 'gbiin‑ 'yö‑ zë. ");
INSERT INTO daf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","'Yö‑ ‑kɔ \"pɛan 'dhɛ 'ö to 'ö ꞊wɛnng \"sɛ ‑së 'gü, 'yö bhɔ faan ꞊dede 'ka 'yö ‑dhi, 'yö‑ ‑kpaaga do ga‑ ‑kë ‑bha këng do.» ꞊Dhɛ 'ö ꞊ya ö bo \"gwënng bha‑ ‑da ‑sü 'ka \"dhʋ̈, 'yö ö ‑wʋ \"dhiʋ̈ ꞊wlü 'ö‑ pö: «'Mɛ 'ö 'wɔn 'gü ma ‑mɛ 'ka ‑ya 'gü ma!» ");
INSERT INTO daf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «\"Gwënng 'i‑ ‑da bha‑ 'klɔɔ‑ ‑mü ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Ka ‑zë Atanna ‑bha ‑gblüdëdhɛ 'gü ‑wɔn ‑nu 'ö gun ‑gblɛn 'kpɔ ‑sü 'ka 'ö mɛ 'bha 'yaa gun‑ dɔ sië bha ꞊yaa‑ ‑ta \"pʋ ka ‑dhɛ, \"kɛɛ mɛ ‑kpɛa 'kö 'wo to ‑a ‑nu ‑bha ‑zë, a ‑dho ‑dhiang zë‑ ‑nu ‑dhɛ \"gwënng ꞊në‑ 'gü, kë \"dhʋ̈ kö‑ ‑nu \"yan ‑ya ‑dhɛ yö \"kɛɛ kö 'wa 'dho‑ dɔ, kö‑ ‑nu \"tʋ ‑ya ma, \"kɛɛ kö 'wa 'dho‑ 'klɔɔ‑ dɔ tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","\"Kɛɛ \"gwënng 'a‑ ‑da bha‑ 'klɔɔ‑ ꞊nɛ: Atanna ‑wʋ bha ꞊në ꞊dhɛ ‑mlüga 'wo‑ bɔ bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","‑A 'dhɛ 'ö ꞊wɛnng zian ‑gloo \"piʋ̈ bha ꞊në ꞊dhɛ 'mɛ 'wo Atanna ‑wʋ ma 'ö ꞊ya 'go mü 'ö Sɔtraan ‑yö nu 'ö‑ bho‑ ‑nu ‑zʋ ‑bha, kë \"dhʋ̈ kö 'wa 'dho 'dhang bho‑ \"dhiʋ̈ 'ö 'wo dha bha‑ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","‑A 'dhɛ 'ö ꞊wɛnng ‑gwë saa‑ \"dhiʋ̈ bha ꞊në ꞊dhɛ 'pö ꞊dhɛ 'mɛ ꞊wa Atanna ‑wʋ ma, 'ö 'wo sa‑ ‑ta 'wo‑ kun wo faan 'ka, \"kɛɛ 'ö‑ yun 'yaa ziö‑ ‑nu 'gü, 'ö 'wɔn \"gbɩɩ‑ 'në 'bha ꞊ya ‑da ‑nu ‑ta kö ꞊wa \"tʋ̈ng 'në 'bha kë 'mü 'wo ‑kan Atanna ‑wʋ ‑bha bha‑ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","‑A 'dhɛ 'ö ꞊wɛnng \"glɛn 'gü bha ꞊në ꞊dhɛ 'pö ꞊dhɛ 'mɛ 'wo Atanna ‑wʋ ma, 'ö 'wo 'dhang bho‑ \"dhiʋ̈, \"kɛɛ 'yö \"kpʋngtaapë ‑nu 'ö ‑gban ‑zʋgɔndhe ‑nu oo, ꞊naɔ ‑dhɔ ‑nu oo, ꞊niidadhe kë ‑sü ‑nu 'ö \"kpʋng ꞊taa yö ‑a ‑wɔn ‑bha bha 'ö‑ ‑nu ‑kan Atanna ‑bha 'yö 'wo‑ ‑wʋ 'ö‑ ma bha‑ ꞊trɔɔn 'yaa kë‑ ‑nu ‑bha bha‑ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","‑A 'dhɛ 'ö ꞊wɛnng \"sɛ ‑së 'gü bha ꞊në ꞊dhɛ 'pö ꞊dhɛ 'mɛ 'wo Atanna ‑wʋ ma, 'ö 'wo ‑wɩ ‑bha zuë\" ‑së 'ka 'ö 'wo ‑kplü ‑bha wo faan ꞊gban 'ka, 'ö 'wo ꞊trɔɔn ‑kë ‑dhɛ zuësɛadhɛ 'gü ‑a ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö \"gwënng ‑dee 'bha ‑da 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «Mɛ 'bha 'yaa ‑dhangbha dɔ 'yaa 'dho 'yaa 'tɛa‑ kpa‑ ‑ta, \"ɛɛn 'yaa dho 'yaa‑ ‑da \"gbang ꞊wlöö, \"kɛɛ ‑ya ‑sü 'ö‑ dɔ ‑dhangbha ‑dɔtapë ꞊në‑ ‑ta kë \"dhʋ̈ kö mɛ ꞊ya ‑da 'kɔɔdhö kö ‑yö ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","‑A ‑gɛn ‑mü ꞊dhɛ pë \"ʋʋ pë 'dhɛ 'kö ‑bin 'gü, ‑a ꞊gban‑ ‑dho ‑wo \"yɛa‑, ‑a 'bha 'yii 'dho 'to ‑gblɛn 'kpɔ 'gü, 'sa 'wɔn \"pɛpɛ 'ö‑ 'gü 'dhö tii, ‑a ꞊gban ‑ta ‑dho \"pʋ 'ö ‑ya 'yënng‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","꞊Dhɛ 'ö \"dhʋ̈, ‑ka ka ‑zʋ 'to ka ‑dɩ 'gü ka \"tʋ ‑to 'wɔn ‑bha ‑kɔ 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö pë 'dhö‑ ‑gɔ 'ö‑ ‑ziö 'gü ‑ziö ꞊në 'wo dho‑ ‑mɛ taa kë, \"kɛɛ 'mɛ 'kö pë 'bha 'yaa‑ ‑gɔ, 'ö‑ sɛɛn\" 'në 'dhɛ ‑zian 'ö‑ ‑gɔ 'yaa‑ ‑ziö 'gü ziö bha, ‑a 'dhɛ 'në ö ‑zʋ 'gɔn sië‑ ‑dhɛ bha, ‑wo ‑dho ‑a 'sü‑ ‑mɛ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","‑Yö ‑to ‑dhɛ bha‑ 'gü 'yö‑ dhe waa‑ dheebhang ‑nu 'wo nu‑ ꞊keng‑. \"Kɛɛ ‑kɔ 'wo dho‑ kë‑ 'ka kö ‑wo ‑kpan ‑bha, 'wii‑ ‑kɔ yö mɛ \"bhɩɩ‑ \"dhaa 'wo gun‑ ꞊klëën ‑sü 'ka‑ ‑zü bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","'Yö 'wo nu 'wo‑ pö Yesu ‑dhɛ: «I dhe waa‑ i dheebhang ‑nu ꞊wa nu, ‑wo \"kpɛnngdhö, ‑wa \"piʋ̈ ꞊dhɛ 'ka ka 'ko yö.» ");
INSERT INTO daf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «N dheebhang 'bha 'yaa 'dhö kö 'yii kë 'mɛ 'kö 'wo wo \"tʋ 'to Atanna ‑wʋ ‑bha 'wo‑ 'gü ‑wɔn ‑kë bha‑ ‑nu 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yi do 'ka 'yö Yesu waa‑ ‑bha ꞊klang ‑nu 'wo ‑da \"kplagɔnë do 'gü, 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka ‑kwa \"yi \"kan 'kwa bɔ \"yi ꞊taama!» 'Yö 'wo ‑ziö. ");
INSERT INTO daf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","꞊Dhɛ 'wo 'dho sië, 'yö \"tɛɛ ‑dha ‑ziisü ‑yö ‑ya ban ‑sü ‑bha ‑a ‑nu ‑bha \"yi ‑ta mü, 'yö \"yi 'dhö ‑ya \"kplagɔnë bha‑ pa ‑sü ‑bha \"wɛ ‑yaan ‑yaandhö, kö ꞊wa dɔ ‑dhëng yaa \"dhiʋ̈, \"kɛɛ 'kö Yesu ‑zë ‑yö yi ꞊në‑ zë sië. ");
INSERT INTO daf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'Yö‑ ‑bha ꞊klang ‑nu 'wo ꞊yɔɔn‑ \"sɔɔ 'wo pa‑ ‑bha 'wo‑ pö: «Yi Dëmɛ, yi Dëmɛ, ꞊ya dɔ 'ya‑ ꞊zɔɔ ‑wa, ga ꞊ya dun kwa ‑ta ‑wa!» ꞊Dhɛ 'ö ꞊wa 'pa‑ ‑bha \"dhʋ̈, 'yö ꞊wlü 'yö ꞊gbla \"tɛɛ waa‑ \"yi kpö kpö ‑nu 'wo gun ‑da sië‑ ‑nu ‑gɔ \"kplagɔnë 'gü bha‑ ‑ta, 'yö \"tɛɛ ‑yö bo ziö ‑sü 'ka, 'yö \"yi ‑dɩ 'pö 'ö bo zɔn ‑sü 'ka, 'yö ‑dhɛ ‑ta ‑yö dɔ dingdhö. ");
INSERT INTO daf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","꞊Dhɛ 'ö ꞊ya bo ‑kë \"dhʋ̈ ‑sü 'ka, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «Ka ‑zʋ ‑yö n ‑dhɛ ‑dhɛ ꞊në 'mɛ 'sa?» \"Kɛɛ 'ö gun \"dhʋ̈ kö \"suʋ̈ ‑ya ‑nu kë sië ꞊dedewo kö 'wɔn bha‑ 'wɔn ꞊yaa‑ ‑nu 'kɔn, 'yö 'wo ‑ya ‑a pö ‑sü ‑bha wo 'ko ‑nu ‑dhɛ 'wo‑ pö: «De suu ꞊në ya ꞊zɔɔ 'yö yö ‑zë 'ö ö faan ‑wɔ \"tɛɛ waa‑ \"yi ‑nu ꞊gban ‑ta 'yö 'wo‑ ‑wʋ ma ꞊ni ‑oo?» ");
INSERT INTO daf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","'Yö 'wo dho 'wo ꞊loo ‑dhɛ 'wo gun dho sië‑ ‑bha Zedhazeni ‑sɛ 'ö Gadhidhe ‑sɛ \"tʋ̈ng 'gü bha‑ 'gü bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","꞊Dhɛ 'ö Yesu ꞊ya 'go \"kplagɔnë 'gü ꞊ya zun \"sia‑, 'yö mɛ do 'bha 'ö go 'pödhɛ bha‑ 'gü bha 'ö nu dɔ‑ ‑gɔ zian‑. Mɛ 'ö \"dhʋ̈ bha \"yina yaa kpö 'në 'bha ‑yö ‑gun 'gü. 'Ö gun \"dhʋ̈ kö‑ yi ꞊ya ꞊gwëë kö 'yaa sɔ ‑da ö ‑bha, kö 'yaa wɔ 'kɔɔdhö 'zü ‑zianwo, kö ‑yö ‑wɔ bun ꞊taa ‑dhɛ ‑nu ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","꞊Dhɛ 'ö Yesu yö, 'yö ꞊gbla \"gbɩɩ‑ 'ka, 'yö zun ö kpiö 'gü Yesu ‑dhɛ kö ‑ya pö sië \"gbɩɩ‑ 'ka 'ö‑ pö: «Yesu, Atanna 'ö dhang‑ 'gü ‑a gbö, 'kwa ma mü? \"Ɛɛn i ‑nu kö 'i n ‑wëëdhɛ bho ‑ee? ‑Bhö dɔ \"gbɩɩ‑ bhɛa\" ꞊në 'a‑ wo i ‑dhɛ, 'bha 'dho n ‑wëëdhɛ bho!» ");
INSERT INTO daf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö Yesu ‑ya pö sië‑ ‑dhɛ ꞊dhɛ 'mɛ 'ö ö ‑yɛa kun‑ 'gü 'ö‑ yi ꞊ya ꞊gwëë bha ‑yö 'go‑ 'gü. 'Sa kö 'mɛ 'ö bha ‑kɔ 'yaa ꞊mɔɔ‑ ‑bha 'zü, kö ꞊waa‑ ‑lö lɔɔga ‑nu waa‑ ‑piö döngga ‑zian 'ka ‑a ‑gɛn ‑bha, ‑ya ‑kan 'ö \"yina ‑nu bha 'wo‑ sü 'wo dho‑ 'ka \"tʋngtadhɛ ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","'Yö Yesu ‑ya dhɛɛ\" kpɔ 'ö‑ pö: «‑Wo i ‑dhɛ ꞊dhɛ?» 'Yö‑ pö: «‑Wo n ‑dhɛ ‹‑gblü \"dhaa›»; ‑a ‑gɛn ‑mü ꞊dhɛ \"yina ‑nu 'wo gun‑ 'gü bha ‑wo ‑gun 'gbɛ yaa wo. ");
INSERT INTO daf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","\"Kɛɛ kö ‑wo bhɛa\" sië Yesu ‑dhɛ ꞊dedewo kö 'ya 'dho wo kë 'mɛ bha‑ 'gü 'ö‑ ‑nu bɔ ‑klɔng züziösü 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","\"Tʋ̈ng 'wo‑ kë sië‑ 'ka \"dhʋ̈ bha kö ‑bhɔ kpö 'bha ‑yö ‑bhöpë mɔɔ‑ sië goo ‑bha ‑dhɛ 'bha 'gü ‑tɔn ‑bha mü. 'Yö \"yina ‑nu bha 'wo ꞊bhɛa Yesu ‑dhɛ kö ꞊ya wo kë 'mɛ bha‑ 'gü ‑yö dɔ \"gbɩɩ‑ ‑yö wo bɔ ‑bhɔ kpö bha‑ 'gü kö 'wo ‑da ‑a ‑nu 'gü. 'Yö Yesu ‑ya ‑nu bɔ mü. ");
INSERT INTO daf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","'Yö \"yina ‑nu bha 'wo go 'mɛ bha‑ 'gü, 'yö 'wo dho 'wo ‑da ‑bhɔ ‑kpluu bha‑ 'gü, 'yö ‑bhɔ ‑nu bha 'wo dɔ ‑bɛang ‑bha 'wo go‑ 'ka goo ‑bha ‑dhɛ bha‑ 'gü, 'yö 'wo dho 'wo drung dɔ \"yi ‑ta \"gbɛa 'ö gun mü bha‑ ꞊bhaa, 'yö \"yi ‑ya ‑nu ꞊gban zë. ");
INSERT INTO daf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","꞊Dhɛ 'ö 'mɛ 'wo gun ‑bhɔ ‑kpluu bha‑ ‑gɔdhiʋ̈mɛ ‑nu 'ka bha 'wo 'wɔn bha‑ ‑dhɛ yö, 'yö 'wo dɔ ‑bɛang ‑bha 'wo dho‑ ‑taɔng 'ka 'pödhɛ bha waa‑ ‑züzüdhɛ ꞊gban \"pɛpɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","'Yö mɛ ‑yö go ‑dhɛ ‑nu bha‑ 'gü 'wo nu 'wɔn bha‑ ‑dhɛ ‑ga ‑dhɛ 'gü. 'Yö 'wo dho 'wo ‑kpan 'mɛ bha‑ ‑bha kö ꞊ya kë \"klʋ̈ʋ̈klʋ̈ ꞊ya sɔ ‑da ö ‑bha kö ‑yö ‑ya sië Yesu \"sɔɔ, kö \"yina yaa bha‑ ꞊gbaan 'go‑ 'gü dee\" wo \"pɛpɛdhö kö‑ \"yan 'gü ꞊ya ꞊söng. ꞊Dhɛ 'wo‑ ‑dhɛ yö \"dhʋ̈, 'yö \"suʋ̈ 'dhö ‑da ‑a ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","'Yö 'mɛ 'kö wo ‑zë 'wo gun 'mɛ bha‑ ‑kë \"klʋ̈ʋ̈klʋ̈ ‑dhɛ ꞊dede 'gü bha, ‑kɔ 'ö ‑kë 'ka 'yö 'mɛ 'ö \"yina ‑kpaa ‑yö gun‑ 'gü bha 'ö dha, 'yö 'wo‑ ‑gɛn dɔ 'mɛ 'wo nu bha‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö \"suʋ̈ 'dhö ‑da mɛ \"pɛpɛ 'wo gun Zenezadhe ‑sɛ bha‑ 'gü bha‑ ‑nu ꞊gban \"pɛpɛ 'gü ꞊dedewo, 'yö 'wo nu 'wo ꞊bhɛa Yesu ‑dhɛ kö ‑yö 'dho ‑yö 'go wo ‑gɔ \"sɛ 'gü. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ‑da \"kplagɔnë 'gü 'yö ö yee ‑kë 'ö dho. ");
INSERT INTO daf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","'Yö 'mɛ 'ö \"yina yaa ‑yö gun‑ 'gü bha 'ö ꞊bhɛa‑ ‑dhɛ kö 'ö 'to‑ ꞊keng‑. \"Kɛɛ 'yö 'yii \"wɩ‑ ‑bha, 'yö‑ pö‑ ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«‑Bhö 'dho i ‑gɔ 'kɔɔdhö kö 'wɔn 'ö Atanna ‑ya ‑kë i ‑dhɛ bha 'i‑ ‑gɛn dɔ 'mɛ 'wo mü‑ ‑nu ‑dhɛ. 'Yö 'mɛ bha 'ö dho 'yö ‑da 'wɔn 'ö Yesu ‑ya ‑kë ö ‑dhɛ bha‑ ‑gɛn dɔ ‑sü 'ka 'pö‑ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","꞊Dhɛ 'ö ꞊ya ö \"dhiʋ̈ yee kë 'ö ꞊ya \"yi ‑ta \"gbɛa 'ö Zenezadhe bha‑ \"kan 'zü ‑deewo, ꞊ya 'dho ꞊ya ꞊loo ‑dhɛ 'wo \"ta zü bho‑ ‑bha ‑blɛɛsü bha‑ 'gü kö mɛ ꞊gban \"pɛpɛ \"yan ‑ya ‑gɔ, kö mɛ \"dhaa ‑yö dɔ sië‑ ‑gɔ mü, ");
INSERT INTO daf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","'yö gɔndënë do 'ö ‑kë Zuifö ‑nu ‑bha Atanna ‑dhɔkëgükɔ ‑gɔmɛ 'ka 'wo‑ ‑dhɛ Zɛdhiusö bha 'ö nu‑ \"piʋ̈, 'yö zun‑ ‑dhɛ ö kpiö 'gü, 'yö ꞊bhɛa‑ ‑dhɛ kö 'wo 'dho ö ‑gɔ 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö‑ 'dhunë do 'ö‑ ‑gɔ, 'ö‑ ‑kwɛ ꞊ya ꞊mɔɔ ‑kaɔng do ga ꞊plɛ ‑nu ‑bha bha‑ 'gü 'yaa ‑së, kö ꞊ya wɔ 'ya‑. Yesu 'dhö gun 'dho sië mü \"tʋ̈ng 'ö‑ 'gü bha, kö mɛbhɩɩdhe ‑ya ꞊keng‑ ‑yɛɛdhö, kö ꞊ya dɔ‑ ‑nu ‑kɔ \"bhɔ 'gü sɔkɔtɔdhö. ");
INSERT INTO daf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","'Mɛ 'wo gun‑ ꞊keng‑ \"dhʋ̈ bha, dhebhɔnë do 'bha ‑yö ‑gun ‑nu kpö 'gü, 'ö‑ 'gü 'yaa gun ‑së. 'Ö gun \"dhʋ̈ kö ꞊yɔɔn yën ‑yua 'ö zun‑ ‑bha ‑a ‑kwɛ ꞊ya kë ‑kaɔng do ga ꞊plɛ. Kö‑ ꞊kwɛɛ ꞊gbaan ꞊wɛnng \"yua bha‑ ‑pë kë ‑sü ‑ta ‑dhɔtrɔɔ ‑nu \"piʋ̈, kö‑ ‑nu 'bha ‑kɔ 'yii ꞊mɔɔ‑ dha ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Dhebhɔ bha 'yö bɔ Yesu ꞊taama, 'yö ꞊yɔɔn‑ \"sɔɔ, 'yö ö ‑kɔ ‑yɛ ‑bha sɔ \"zɔ ‑bha. ‑Yö ‑to ‑dhɛ do bha‑ 'gü, 'ö‑ ‑bha \"yua 'ö gun‑ ‑bha bha 'ö bo. ");
INSERT INTO daf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'Yö Yesu ‑ya pö: «‑Ka dɔ! De ꞊në‑ ‑kɔ pa n 'ka bha?» ꞊Dhɛ 'ö mɛ ꞊gban 'wo zun ‑dɩ ‑zë ‑sü ‑bha dhɛɛ\" 'kpɔ 'ö‑ ‑kë bha‑ \"dhiʋ̈, 'yö Piɛdhö ‑ya pö‑ ‑dhɛ: «'Yö dhɛɛ\" suu ‑mɛɛ ꞊në 'i‑ kpɔ \"dhʋ̈, n Dëmɛ? Mɛ \"dhaa 'ö ma i ‑zü ya 'bhaa‑ yö ꞊në wo ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «A‑ ‑pö mɛ 'bha ꞊ya ‑kɔ 'pa n 'ka! ‑A ‑gɛn ‑mü ꞊dhɛ faan 'bha ꞊ya 'go n 'gü, 'ma‑ ‑dhɛ yö.» ");
INSERT INTO daf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","꞊Dhɛ 'ö dhebhɔnë bha ꞊yaa‑ 'wɔn dɔ ꞊dhɛ 'slüü‑ ꞊ya bho ö ‑ta, 'yö ‑ya ꞊zii ‑sü ‑bha, 'yö dho 'ö zun ö kpiö 'gü Yesu ꞊wlöö, 'yö 'wɔn 'ö‑ ‑wɔn 'gü, 'ö pa‑ ‑bha sɔ 'ka bha 'ö‑ ‑gɛn bho mɛ ꞊gban \"pɛpɛ \"yaan, 'yö ‑kɔ 'ö to‑ 'ka 'pö ‑dhɛ do bha‑ 'gü, 'ö‑ ‑bha \"yua ‑yö bo bha 'ö‑ ꞊gban pö. ");
INSERT INTO daf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","'Yö Yesu ‑ya pö‑ ‑dhɛ: «N \"tɛado, i ‑bha 'dhang ‑bho n \"dhiʋ̈ ‑sü ꞊në i dha bha, ‑bhö i ‑bha 'dho wo i 'flëë‑ 'gü!» ");
INSERT INTO daf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","‑Yö ‑to ‑a pö \"dhʋ̈ ‑dhɛ 'gü, 'yö mɛ ‑yö go Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑gɔmɛ bha‑ ‑gɔ 'kɔɔdhö, 'yö‑ pö gɔndë bha‑ ‑dhɛ: «'Bha 'dho kwa Dëmɛ ziö \"yɛ 'gü \"wɛɛwɛɛ, i 'dhu 'yaa mü 'zü.» ");
INSERT INTO daf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","\"Kɛɛ ꞊dhɛ 'ö Yesu ‑yö ‑wʋ bha‑ ma, 'yö‑ pö ‑yakwëëkëgükɔ ‑gɔmɛ bha‑ ‑dhɛ 'ö‑ pö: «'Bha 'dho \"suʋ̈, 'bha 'dhang bho n \"dhiʋ̈, i 'dhu bha ‑yö ‑dho dha.» ");
INSERT INTO daf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","꞊Dhɛ 'ö dho 'ö ꞊loo mü, 'yii \"wɩ‑ ‑bha kö mɛ 'bha ‑yö ‑da ö ꞊keng‑ 'kɔɔdhö kö 'yii kë Piɛdhö 'dhöö, Zan 'dhöö, Zakö waa‑ 'në bha‑ dhe waa‑ dë ‑nu ‑zë 'ka. ");
INSERT INTO daf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kö 'mɛ 'kö 'wo gun mü, ‑a ‑nu ꞊gban \"pɛpɛ ‑wo \"gbʋ ꞊në‑ bɔ sië, 'ö 'wo ‑wëë ‑wʋ kpɔ 'në bha‑ ga ‑sü ‑wɔn 'gü. 'Yö Yesu ‑ya ‑nu ‑dhɛa ‑ga 'ö‑ pö: «'Ka 'dho \"gbʋ bɔ, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö yi ꞊në‑ ‑zë 'yii ga.» ");
INSERT INTO daf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö 'wo ꞊wɛɛ dɔ‑ ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑wa 'wɔn ‑dɔ 'kpakpadhö ꞊dhɛ ꞊ya ga. ");
INSERT INTO daf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","\"Kɛɛ ꞊dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö 'në bha‑ kun‑ ‑kɔ ‑bha, 'yö ꞊gbla \"gbɩɩ‑ 'ka 'ö‑ pö: «'Nëdhiëngnë, ‑bhö \"wlü!» ");
INSERT INTO daf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'Në bha ‑yö ‑to ‑dhɛ do bha‑ 'gü 'yö‑ 'nii‑ ‑sɛa ‑yö ‑da 'gü, 'yö ꞊wlü, 'yö Yesu ‑ya pö ‑wo nu‑ ‑dhɛ ‑bhöpë 'ka kö ‑ya ‑bhö. ");
INSERT INTO daf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","'Yö 'wɔn bha‑ 'wɔn ‑yö 'në bha‑ 'kpɔmɛ ‑nu kɔn ꞊dedewo, \"kɛɛ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'wa 'dho‑ ‑gɛn dɔ mɛ 'bha ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yi do 'ka 'yö Yesu ‑yö ö ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ ‑nu ‑dhɛ ‑dhɛ do 'gü, 'yö \"yina yaa ‑nu ‑kë mɛ 'gü ‑sü waa‑ \"yuëdhi ‑nu ‑kë \"klʋ̈ʋ̈klʋ̈ ‑sü ‑faan ‑da ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","꞊Dhɛ 'ö ꞊yaa‑ kë \"dhʋ̈, 'yö dho 'yö‑ ‑nu bɔ Atanna ‑bha ‑gblüdëdhɛ ‑dhiang zë ‑dhɛ 'gü mɛ ‑nu ‑dhɛ, kö ꞊wa 'dho ‑wo \"yuëdhi ‑nu dha. ");
INSERT INTO daf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","꞊Dhɛ 'ö woo ziö, 'yö‑ pö‑ ‑nu ‑dhɛ: «Ka 'dho ‑sü 'ka, 'ka 'dho pë 'bha ‑pë 'bha 'kun ka ‑kɔ \"piʋ̈ \"ta ‑kpɔ 'ka ‑pë 'ka, 'ka 'dho ‑taadhü 'kun ka ꞊kwɛɛ‑, \"ɛɛn ꞊kwɛɛsügüpë 'bha 'ya 'dho kë ka ‑gɔ, ‑bhöpë 'ya 'dho kë ka ‑ta, \"ɛɛn 'wëëga 'ya 'dho kë ka ‑ta. ‑Ka 'dho ka ‑kɔ 'waa ka ‑gɛn 'ka, sɔ do 'ö ka ‑bha bha ꞊në ‑yö 'to ka ‑bha, 'ka 'dho‑ \"wɛɛ bha 'sü. ");
INSERT INTO daf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","꞊Ya kë ꞊dhɛ 'ka 'dho, ꞊wa ka ꞊yëë bho 'kɔ 'ö‑ 'gü, ‑ka 'to yö ꞊në‑ 'gü kö ‑yö 'to \"dhʋ̈ ‑yö zun‑ 'ka ka 'dho ‑yi ‑bha, kö 'ka 'dho 'go mü 'ö 'ka dho ka ꞊yëë bhɔ ‑dhɛ \"wɛɛ 'bha 'gü ('ö ‑siö ka ‑dhɛng bhɔɔ ‑nu ‑dhɛ ka \"piʋ̈). ");
INSERT INTO daf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","꞊Ya kë ꞊dhɛ 'ka ‑da 'pödhɛ 'ö‑ 'gü, ‑a 'gü ‑mɛ ‑nu 'wii \"wɩ ka ꞊yëë bho ‑wɔn ‑bha, ‑ka 'go mü kö 'ka 'dho. \"Kɛɛ ka 'dho ‑sü 'ka, 'ka ka ‑gɛn ‑bha ‑ma kö ‑bobi 'ö dɔ ka ‑gɛn ‑bha 'pö‑ bha‑ 'gü bha, ‑yö 'go ka ‑gɛn ‑bha kö ‑wa 'wɔn dɔ ꞊dhɛ ('wa wo ‑dɩ zë za 'ka Atanna wëëdhö dhia\").» ");
INSERT INTO daf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","꞊Dhɛ 'ö ꞊ya ö bo ö ‑wʋ ‑kpɔ ‑a ‑nu ‑bha ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö 'wo dho 'wo ‑da 'pö‑ ‑nu ‑bhiëë \"piʋ̈, Atanna ‑bha ‑gblüdëdhɛ ‑wɔn ‑dhiang zë ‑sü 'ka, kö ‑wo \"yua ‑nu bho sië mɛ ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","꞊Dhɛ 'ö Edhodö 'ö gun Gadhidhe ‑sɛ ꞊kɔɔnmɛ 'ka bha ꞊ya 'wɔn ‑nu 'wo gun kë sië bha‑ ‑nu ma, yöö ö ‑bha pö ‑kɔ 'ö‑ 'gü ‑a ‑kɔ 'yaa gun, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ 'kö 'mɛ 'wo Yesu ‑wɔn ‑dhiang zë sië ‑a ‑nu ‑wʋ 'yaa do. Kö mɛ 'bha ‑nu ‑wa pö sië ꞊dhɛ Zan Mɛzumɛ 'ö Edhodö ‑ya zë bha ꞊në ꞊ya ‑bö, ");
INSERT INTO daf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","\"ɛɛn Atanna ‑wʋdhiʋ̈loomɛ Edhi 'ö gun yi 'bha 'ka bha ꞊në ꞊ya nu, \"ɛɛn 'zü ‑a ‑wʋdhiʋ̈loomɛ \"wɛɛ 'bha ‑nu ꞊në‑ mɛ do 'bha ꞊ya ‑bö ‑deewo, (kö ‑wo \"wɩ sië‑ 'ka \"dhʋ̈ yuudhö). ");
INSERT INTO daf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","\"Kɛɛ kö Edhodö ‑zë ‑ya pö sië: «\"Kɛɛ mɛ 'dhɛ 'kö 'wo‑ ‑dhiang \"sinma zë sië ya de ‑mü 'sa \"kɛɛ kö 'ma Zan ‑zë zë?» Kö ‑ya \"slë mɔɔ‑ sië kö 'ö ‑kpan Yesu ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","꞊Dhɛ 'ö Yesu ‑bha bɔmɛ ‑nu bha ꞊wa wo yee kë ꞊wa nu, 'yö 'wo ‑ya 'wɔn ‑nu 'wo‑ ‑kë mü ‑a ‑nu ‑gɛn dɔ ‑sü ‑bha ‑a ‑dhɛ. 'Yö‑ ‑nu sü, 'yö 'wo dho wo ‑dɩ ‑ta ‑dhɛ 'bha 'ö 'pödhɛ 'wo Bɛsaida ‑dhɛ ‑kë bha‑ \"sɔɔ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","꞊Dhɛ 'ö mɛ \"dhaa 'wo gun Yesu ꞊keng‑ bha 'wo‑ 'wɔn dɔ ꞊dhɛ ꞊ya 'dho, 'yö 'wo ‑ziö ꞊keng‑. ꞊Dhɛ 'ö ꞊yaa‑ ‑nu yö kö ‑wo nu sië ö mɔɔ‑ ‑dhɛ 'gü, 'yö ö ‑kɔ ‑ya ‑a ‑nu ‑dhɛng ‑bha. 'Yö zun Atanna ‑bha ‑gblüdëdhɛ ‑dhiang zë ‑sü ‑bha ‑a ‑nu ‑dhɛ, kö ‑yö mɛ 'dhɛ \"yua 'dhö gun‑ ‑nu ‑bha 'ö‑ ‑nu ‑mawɔn 'dhö gun dha ‑sü ‑bha ‑a ‑nu dha sië 'pö. ");
INSERT INTO daf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","꞊Dhɛ 'ö ꞊ya dhiang zë 'mɛ bha‑ ‑nu ‑dhɛ \"dhʋ̈, 'ö \"bin 'dhö 'ma sië, 'yö‑ ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha 'wo ꞊yɔɔn‑ \"sɔɔ 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, ‑bhö i ‑wʋ 'kpɔ 'mɛ 'wo ya‑ ‑nu ‑bha kö 'wo 'dho wo ꞊yëë ‑nu, waa‑ wo ‑bhöpë ‑nu mɔɔ‑ ‑dhɛ 'gü, 'pö‑ ‑nu \"ɛɛn gbɛɛtadhɛ ‑nu 'wo kwa ‑züzü ya‑ ‑nu 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ ‑dhɛ 'kwa‑ bha ya \"tʋngtadhɛ ‑mü, 'kɔ 'bha 'yaa mü kö yöö 'to ‑bhöpë ꞊në‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Ka ꞊në ‑kaa ‑nu \"dhiʋ̈ gba!» \"Kɛɛ 'yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «'Bluu‑ bhɛ \"sɔɔdhu waa‑ 'yuʋ̈ga ꞊plɛ ꞊në ꞊ya 'to, 'pë 'ö yi ‑gɔ ‑a ‑kpɛa ꞊në bha. ꞊Ya 'to yö ‑zë ‑bha kö 'dho ꞊në yii‑ wo mɛ ‑tu \"tu ya‑ ‑nu ‑bhöpë 'dhɔ ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","\"Kɛɛ 'sa 'mɛ 'wo gun ‑dhɛ bha‑ 'gü, ‑wo ‑gun 'gbɛ ꞊dedewo tɛan‑ 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ gɔɔn‑ ‑nu 'wo gun mü ‑wo ‑mɔɔ mɛ \"gblü \"sɔɔdhu ‑nu ‑bha (kö 'wii 'në ‑nu waa‑ dhong ‑nu ‑da mü). 'Yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «‑Kaa ‑nu dan ‑kaɔng \"sɔɔdhu \"sɔɔdhu kö 'ka‑ ‑nu ‑yɛa baa‑.» ");
INSERT INTO daf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","'Yö 'wo‑ ‑nu ‑yɛa ꞊baa ꞊dhɛ ‑kɔ 'ö‑ pö‑ 'ka bha‑ 'dhö, 'yö‑ ‑nu ꞊gban \"pɛpɛ 'wo wo ‑yɛa kun. ");
INSERT INTO daf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","'Yö Yesu ‑yö ö ‑kɔ ‑da 'bluu‑ bhɛ \"sɔɔdhu waa‑ 'yuʋ̈ga ꞊plɛ bha‑ 'gü, 'yö ö \"yan \"dhiʋ̈ ‑wlü dhang‑ 'gü, 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü, 'yö‑ ‑nu \"kplü \"kplü bho, 'yö‑ nu ö ‑bha ꞊klang ‑nu ‑dhɛ kö ‑wa 'gü ‑gblü 'mɛ 'wo bha‑ ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","'Yö 'wo‑ 'gü ‑gblü, 'yö 'mɛ 'wo bha‑ ‑nu ꞊gban \"pɛpɛ 'wo pë ‑bhö 'wo kën kpɛnngkpɛnngdhö, 'yö‑ ‑kpɛa ‑yö to, 'yö‑ ‑bha ꞊klang ‑nu 'wo‑ ‑kpɛa bha‑ ꞊loo töö ‑kaɔng do ga ꞊plɛ 'gü 'yö‑ pa. ");
INSERT INTO daf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","꞊Dhɛ 'ö yi do 'ka kö Yesu ‑yö bhɛa\" sië Atanna ‑dhɛ ö ‑dɩ ‑ta ‑dhɛ 'bha bha‑ 'gü waa‑ ‑bha ꞊klang ‑nu 'dhö, 'yö dhɛɛ\" ya‑ kpɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Ka‑ ‑ma ꞊dhɛ de suu ꞊në n 'ka?» ");
INSERT INTO daf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «('Mɛ 'wo i ‑dhiang zë sië) ‑a ‑nu ‑wʋ 'yaa do, mɛ 'bha ‑nu ‑wa ‑pö Zan Mɛzumɛ ‑mü i 'ka, \"ɛɛn Edhi ‑mü i 'ka, \"ɛɛn 'zü Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'wo gun yi 'bha 'ka bha ꞊në‑ mɛ 'bha ꞊ya ‑bö.» ");
INSERT INTO daf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «'Yö ka ‑zë ꞊wɛ, ka ka ‑bha ‑pö 'gü ꞊dhɛ?» 'Yö Piɛdhö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Atanna ‑bha ‑Yamɛ ‑mü i 'ka, n Dëmɛ.» ");
INSERT INTO daf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","'Yö ‑dhio dɔ‑ ‑nu ‑ta glɔɔglɔdhö 'ö‑ pö 'wa 'dho‑ pö \"dhʋ̈ mɛ \"wɛɛ 'bha ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","꞊Dhɛ 'ö ꞊yaa‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈, 'yö go mü ö‑ ‑ta yɔ 'ö‑ pö: «‑A ‑dhɛa ‑bha ꞊dhɛ mang Mɛgbömɛ 'a sëë bho ꞊dedewo, kö Zuifö ‑nu ‑bha mɛ zii ‑nu ‑wo wo ‑kɔ \"kan n \"dhiʋ̈, waa‑ \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu 'dhö, kö ‑wo n zë, kö 'a ‑bö ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö‑ pö 'mɛ 'wo gun mü ‑a ‑nu ꞊gban \"pɛpɛ ‑dhɛ 'ö‑ pö: «'Mɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ö bɔ n 'ka, ‑a mɛ ‑yö ö bo ö ‑dɩ 'ka kö ‑yö sëë bho 'pö ꞊dhɛ n 'dhö yi ꞊gban 'ka. ");
INSERT INTO daf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ mɛ \"ʋʋ mɛ 'ö dho kë‑ \"piʋ̈ ꞊dhɛ 'ö ö ‑dɩ dha ‑dhɛ mɔɔ‑ ö ‑dɩ ‑dhɛ, ‑a ‑mɛ ‑gɔ ‑dho 'to‑ 'gü, \"kɛɛ mɛ 'ö ‑kɔ ‑kan ö ‑dɩ ‑wɔn \"dhiʋ̈ ma ‑zë n ‑wɔn 'gü, ‑a ‑mɛ ‑dho dha. ");
INSERT INTO daf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","\"Ɛɛn pë \"pɛpɛ 'ö \"kpʋng ꞊taa ‑a ꞊gban ꞊slɔɔ ‑sü kö ‑yö kë mɛ ‑gɔ, \"kɛɛ kö‑ ‑mɛ 'nii‑ ‑zë ‑yö ꞊dhɛng, \"ɛɛn kö‑ 'gü ‑yö see‑, ('kö 'ya 'dho ‑da Atanna ‑bha ‑gblüdëdhɛkëdhɛ 'gü ‑dhɛ 'bha ꞊kpaɔ ‑yi 'ka) ‑gɛn ‑mü ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ 'mɛ \"ʋʋ mɛ 'ö dho 'yiʋ̈‑ kë n 'tɔ ‑pö ö ‑bha ‑sü 'ka, \"ɛɛn 'ö dho 'yiʋ̈‑ kë n ‑wʋ ‑pö mɛ ‑nu ‑dhɛ ‑sü 'ka, a ‑dho 'yiʋ̈‑ kë 'pö‑ ‑mɛ ‑gɔ yi 'ö mang Mɛgbömɛ 'a dho nu‑ 'ka ma 'tɔbhɔdhe 'gü yaa ma \"kië \"slʋ̈ʋ̈slʋ̈ ‑nu bha‑ ‑nu 'dhö n dë ‑bha ‑gblüdëdhɛ 'gü bha‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Mɛ 'wo ‑dhɛ ya‑ 'gü ya‑ ꞊gban 'wii 'dho ga kö Atanna ‑bha mɛdhɛ bha‑ zü 'yii bho ꞊kö.» ");
INSERT INTO daf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","꞊Dhɛ 'ö ꞊ya ö bo dhiang ‑nu bha‑ zë ‑sü 'ka \"dhʋ̈, 'ö ‑dhɛkpaɔyi ꞊ya kë \"saaga, 'yö Piɛdhö 'dhö, Zan 'dhö, Zakö 'dhö ‑a ‑nu sü 'yö 'wo dho ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü ‑tɔn 'bha bha‑ ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","꞊Dhɛ 'ö ꞊wa zun bhɛa\" ‑sü ‑bha, 'yö Yesu wëëdhɛ ‑yö ‑gla, 'yö‑ ‑bha ‑sɔ 'bhü 'dhö ‑ya bhɔ ‑sü ‑bha ‑papadhö. ");
INSERT INTO daf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","'Wo dho \"kan wo ‑ta kö mɛ ꞊plɛ ‑wo dɔ sië‑ \"sɔɔ mü kö ‑wo wo ‑gɔ dun sië. Atanna ‑wʋdhiʋ̈loomɛ ‑nu ꞊plɛ 'bha 'wo gun yi 'bha 'ka 'wo‑ mɛ do ‑dhɛ Moizö, 'wo‑ mɛ do ‑dhɛ Edhi bha. ");
INSERT INTO daf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","\"Kɛɛ kö Atanna ‑bha ‑gblüdëdhɛ ö dhang‑ 'gü bha‑ 'bhü ‑yö dɔ sië‑ ‑nu ‑bha, kö‑ ‑nu kwi \"yan‑ bhɔ sië ‑papadhö, kö 'wɔn 'ö yöö 'dho‑ kë Zedhizadhɛmö, ‑a zë 'ö woo‑ wo kö ‑yö kë 'wɔn 'ö nu‑ 'gü \"kpʋng ꞊taa ‑a ‑gɔ dɔ ‑kɔ 'ka bha ‑wa ‑dhiang zë sië. ");
INSERT INTO daf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","‑A \"tʋ̈ng bha‑ 'gü kö Piɛdhö waa‑ ö \"tɛabɔ ‑nu ‑a ‑nu \"yankɔ ꞊gbaan kë 'gbin‑ 'gbin‑ 'ka yi kaɔ, \"kɛɛ yö ‑zë ꞊gban 'gü, ‑wo ‑to wo \"yaan 'ö 'wo wo \"yan ‑kpan Yesu ‑bha mɛdhɛ 'bhü bha‑ ‑bha waa‑ mɛ ꞊plɛ bha‑ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","꞊Dhɛ 'ö mɛ ꞊plɛ bha woo \"kan Yesu ‑bha, 'yö Piɛdhö ‑ya pö‑ ‑dhɛ 'ö‑ pö: «N Dëmɛ, 'kwa ‑ya ‑dhɛ ya‑ 'gü ‑yö ‑dho kë ‑së \"dhɛ! ‑Ka nu kö 'kwa sɔ ‑kɔ ‑yaaga dɔ ‑dhɛ ya‑ 'gü kö ‑a do ‑yö kë i ‑bha 'ka, kö‑ do ‑yö kë Moizö ‑bha 'ka, kö‑ do ‑yö kë Edhi ‑bha 'ka ‑dhe!» \"Kɛɛ ‑a pö 'ö gun wo sië \"dhʋ̈ bha 'yaa gun‑ 'gü ma sië ö ‑dɩ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","‑Yö ‑to dhiang bha‑ zë ‑dhɛ 'gü, 'yö \"dhuu ‑yö go dhang‑ 'gü 'yö nu 'yö kpa Yesu waa‑ mɛ ꞊plɛ 'ö wɛng‑ ‑nu 'wo gun wo ‑gɔ dun sië bha‑ ‑nu ‑bha. ꞊Dhɛ 'ö ꞊klang ‑nu bha 'wo‑ ‑nu ‑da \"dhuu 'gü ‑dhɛ yö \"dhʋ̈, 'yö \"suʋ̈ 'dhö ‑da ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","'Yö ‑wʋ do 'bha ‑yö bɔ \"dhuu bha‑ 'gü 'ö ‑wɩ 'ö‑ pö: «N Gbö (do 'ö n ‑gɔ) 'yö ya, ‑ka ka \"tʋ to‑ ‑wʋ ‑bha!» ");
INSERT INTO daf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","꞊Dhɛ 'ö ‑wʋ bha ꞊ya bo \"wɩ ‑sü 'ka \"dhʋ̈, 'wo dho ‑dhɛ ‑ga kö Yesu ꞊ya 'to ö do 'ka. \"Kɛɛ 'wɔn 'wo‑ ‑dhɛ yö bha 'wo go mü 'wii‑ ‑gɛn dɔ mɛ 'bha ‑mɛ 'bha ‑dhɛ ‑a \"tʋ̈ng 'dhɛ kö bha‑ 'gü, (‑yö kë ‑to ‑a ‑nu zuë\" \"piʋ̈). ");
INSERT INTO daf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya ꞊kpaɔ, 'ö ꞊wa 'go ‑tɔn ꞊gbin‑ ꞊wa lɔɔ‑, 'yö mɛ kpö 'bha ‑yö nu Yesu ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'Yö mɛ do ‑yö bɔ 'mɛ 'wo bha‑ ‑nu kpö 'gü 'ö‑ pö: «N Dëmɛ, ‑bhö \"ta n ‑dhɛ ‑dhe! ‑Bhö dɔ \"gbɩɩ‑ kö 'i n gbö ya‑ ‑wëë ‑ga ‑dhe! ‑Yö n ‑gɔ \"dhʋ̈ doseng ‑wa, ");
INSERT INTO daf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","\"yua 'ö ma 'në ya‑ ‑bha ya \"yina ‑yua ‑mü. ‑A \"yina bha ꞊ya ‑da 'gü, 'yö ‑ya \"gbla ‑sü ‑bha, 'yö ꞊ya ‑dɩ zë‑ 'ka ‑gblagbladhö. 'Yö‑ \"dhidhi \"vuu ‑yö bhɔ, 'yö 'yaa \"wɩ‑ ‑bha kö ‑yö 'go‑ ‑ta \"vaandhö \"kɛɛ kö ꞊yaa‑ ‑zlukpa bho kö \"sɩ 'bha 'yaa‑ ‑dhɛ 'zü. ");
INSERT INTO daf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","꞊Dhɛ 'a nu‑ 'ka, a‑ ‑nu i ‑bha ꞊klang ‑nu ya ꞊në‑ ‑nu ‑dhɛ ꞊kö ‑blɛɛsü kö ‑wa dha n ‑dhɛ, \"kɛɛ 'yö‑ ‑nu ‑kɔ 'yii ꞊mɔɔ‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö Yesu ‑ya pö 'mɛ 'wo gun mü bha‑ ‑nu ‑dhɛ 'ö‑ pö: «Gɔɔgbɩɩmɛ ‑nu, suuyaamɛ ‑nu 'ka ya, 'kaa \"wɩ 'ö‑ wo‑ ‑bha kö 'ka 'dhang bho Atanna ‑bha 'gügbɩɩdhɛ \"dhiʋ̈ ya ‑yö ka 'gü ꞊dhɛ a ‑dho 'to ka \"piʋ̈ 'ö 'a ka ‑kwɛɛ bun \"dhʋ̈ ‑kpɛawo ‑ee?» 'Yö‑ pö 'mɛ bha‑ ‑dhɛ: «‑Bhö nu i gbö bha‑ 'ka n ‑dhɛ yö!» ");
INSERT INTO daf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","꞊Dhɛ 'ö 'në bha 'ö ꞊yɔɔn Yesu \"sɔɔ, 'yö \"yina bha 'ö ꞊wlü‑ 'gü, 'yö‑ ‑zuö \"sia‑, 'yö zun ‑dɩ zë ‑sü ‑bha \"gbɩɩ‑ 'ka, \"kɛɛ 'yö Yesu ‑yö ꞊gbla \"yina yaa bha‑ ‑ta, 'yö 'në bha‑ dha, 'yö‑ sü 'ö‑ dɔ‑ dë ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö mɛ ꞊gban \"pɛpɛ 'wo 'dhang bho Atanna ‑bha 'gügbɩɩdhɛ ‑bha ‑kë ‑ziisü ‑sü \"dhiʋ̈. \"Dhabhliwɔn ‑nu 'ö Yesu gun kë sië bha, 'mɛ 'wo bha ‑wo ‑to ‑a din \"piʋ̈, 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«'Mɛ 'kö 'ka bha ka ‑zë, ‑ka ka \"tʋ 'to n ‑ta ‑së 'ka kö dhiang 'ö maa‑ zë ka ‑dhɛ bha ꞊në 'ya 'dho 'go ka \"yaan. Yö ‑mü ꞊dhɛ mang Mɛgbömɛ ‑wo ‑dho n ꞊gbaɔ mɛ \"bhɩɩ‑ ‑nu ‑gɔ, ");
INSERT INTO daf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","\"kɛɛ ‑a ‑bha ꞊klang ‑nu ‑zë 'waa gun ‑wʋ bha‑ 'gü ma sië, ‑a 'gü‑ ‑gun ‑nu 'gü tii, 'ö 'waa‑ 'klɔɔ‑ dɔ. 'Sa ‑wo gun \"suʋ̈ sië‑ ‑gɔ, 'wii‑ dhɛɛ\" 'kpɔ kö ‑ya 'klɔɔ‑ pö‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","\"Kɛɛ 'sa kö 'wɔn 'ö ‑gban 'mɛ 'wo bha‑ mɛ 'dhɛ 'ö‑ ‑duɛ dho kë 'kpii‑ dhang‑ 'gü dhia\" ‑a ‑wɔn ‑bha bha ‑wo wo 'ko 'kun sië‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","꞊Dhɛ 'ö Yesu ꞊ya 'wɔn 'ö gun‑ ‑nu ‑gɔ 'gü bha‑ dɔ, 'yö 'në 'dɛdɛ do sü 'yö‑ dɔ ö \"sɔɔ, ");
INSERT INTO daf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","'yö‑ pö‑ ‑nu ‑dhɛ: «Mɛ \"ʋʋ mɛ 'ö ꞊bhlëë ‑ya 'në suu 'ö ꞊ni‑ ‑bha n ‑wɔn 'gü kö ‑yö ꞊bhlëë ‑ya ma ꞊në n ‑bha bha. 'Mɛ 'ö n ꞊bhlëë ‑ya 'pö kö ‑yö ꞊bhlëë ‑ya 'mɛ 'ö n bɔ ꞊në‑ ‑bha bha. ‑A ‑kë \"dhʋ̈ ‑sü ‑wɔn 'gü, 'mɛ 'ö dho ö ‑dɩ kë mɛ sɛɛn\" 'nësü 'ka ka kpö 'gü bha, ‑a ‑mɛ ꞊në dho kë mɛ 'kpii‑ 'ka dhang‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö Zan ‑ya pö‑ ‑dhɛ: «N Dëmɛ, 'dho 'yi‑ wo i ‑bha naɔ ‑së bha‑ dɔ ‑dhɛ 'gü bha yi ‑kpan mɛ 'bha ‑bha kö ‑yö \"yina yaa kë sië mɛ ‑nu 'gü i 'tɔ 'gü, \"kɛɛ kö 'yaa‑ dɔ, 'yö 'yi‑ pö‑ ‑dhɛ ‑yö 'to‑ ‑gɔ ‑naa 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Ka 'dho‑ ‑kɔ bho‑ ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'kö 'yii dɔ ka ‑gɔ ‑gblü gɔɔn ‑yan ‑zë 'gü kö ‑yö ‑bɔ ka 'ka. ");
INSERT INTO daf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","꞊Dhɛ 'ö \"tʋ̈ng 'ö Yesu dho 'go‑ 'ka \"kpʋng ꞊taa ꞊ya 'to klöö‑, 'yö‑ \"dhiʋ̈ ꞊wlü‑ ‑bha kö 'ö 'dho Zedhizadhɛmö. ");
INSERT INTO daf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","꞊Dhɛ 'ö ‑da zian ‑ta, 'yö mɛ bɔ ö \"dhiʋ̈. 'Mɛ 'ö‑ ‑nu bɔ bha 'yö 'wo dho 'wo ‑da Samadhi ‑pö do 'bha bha‑ 'gü, 'yö 'wo ‑ya Yesu ꞊yëë bhɔ 'gü ‑kɔ mɔɔ‑ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","\"Kɛɛ 'yö 'wii \"wɩ‑ ‑bha kö ‑wa ꞊yëë bho 'dho 'ö‑ wo sië Zedhizadhɛmö Atanna ‑dhɔkëdhɛ 'gü bha‑ ‑wɔn 'gü (‑a ‑gɛn ‑mü ꞊dhɛ 'waa gun \"wɩ sië‑ ‑bha kö Zuifö ‑nu ‑wo bɔ wo ‑gɔ 'pödhö ‑wo 'dho wo ‑bha Atanna ‑dhɔkëdhɛ 'gü Zedhizadhɛmö). ");
INSERT INTO daf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","꞊Dhɛ 'ö Zakö waa‑ Zan 'wo ‑kë ‑a ‑bha ꞊klangdhiʋ̈ ‑nu 'ka bha, 'wo 'wɔn bha‑ ‑dhɛ yö, 'yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, ‑bhö dɔ 'sa kö 'yi pɛng ‑gbadhɛ Atanna ‑gɔ dhang‑ 'gü kö ‑yö 'mɛ 'wo ya‑ ‑nu ‑bhö ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","'Yö Yesu ‑yö ö wë bɔ‑ ‑nu ‑ta, 'yö ‑dɔn bho‑ ‑nu 'ka 'ö‑ pö: «\"Yina suu 'ö ‑da ka 'gü 'yö 'ka dhiang suu bha‑ zë sië bha 'kaa‑ dɔ; ");
INSERT INTO daf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","‑a ‑gɛn ‑mü ꞊dhɛ mang Mɛgbömɛ 'mii nu kö 'a mɛ ‑nu 'nii‑ zë 'gü see‑, a ‑nu kö 'a‑ ‑nu dha ꞊në‑ wo. 'Yö 'wo ‑ziö 'wo dho 'pödhɛ \"wɛɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","꞊Dhɛ 'ö ꞊wa ziö 'wo 'dho sië, 'yö mɛ do 'bha ‑ya pö‑ ‑dhɛ: «N Dëmɛ, a ‑dho 'dho i ꞊keng‑ ‑dhɛ ꞊gban \"pɛpɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «('Bha‑ pö \"dhʋ̈ ma ‑zë n ‑bha 'yaa \"gbɩɩ‑ \"kɛɛ) ‑yö kë i \"yaan ꞊dhɛ \"sakpadë ‑nu ‑yɛ ‑dhö 'wo ‑wɔ 'gü, 'ö ‑maa ‑nu 'kɔ 'dhö 'dhö, \"kɛɛ mang Mɛgbömɛ ‑zë, n ‑gɔ ‑dɔ ꞊wlöö ‑pë ‑zian 'yaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","'Yö‑ pö mɛ \"wɛɛ 'bha ‑dhɛ: «‑Bhö nu kö 'i ‑da n ꞊keng‑!» \"Kɛɛ 'yö 'mɛ bha 'ö‑ ‑yɔ bɔ Yesu ‑gɔ 'ö‑ pö: «N Dëmɛ, ‑bhö dɔ \"gbɩɩ‑ kö 'a 'dho ꞊kö kö n dë ꞊ya ga yi 'ö‑ 'ka 'ma‑ ‑wɛɛ bho kö 'a nu ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'pö 'ö‑ pö: «‑Bhö i kwaa‑ 'mɛ Atanna ‑ya ‑nu sü ꞊dhɛ mɛ ꞊gee 'dhö bha‑ ‑nu ‑zü kö ‑wo wo 'ko ‑nu ‑wɛɛ bho, bhi ‑zë, ‑bhö 'dho Atanna ‑bha ‑gblüdëdhɛ ‑wɔn ‑dhiang zë mɛ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","'Yö mɛ do \"wɛɛ 'bha ‑ya pö: «N Dëmɛ, a ‑dho 'dho i ꞊keng‑, \"kɛɛ ‑bhö dɔ kö 'a 'dho n ‑wʋ ‑da ‑dhɛ 'gü n ‑gɔ 'kɔɔmɛ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Mɛ \"ʋʋ mɛ 'ö ꞊ya 'dhang bho n \"dhiʋ̈, ‑a ‑dhɛa ‑bha ꞊dhɛ‑ ‑mɛ ‑yö ‑dhɛ ‑ga ö \"dhiʋ̈ do kö ‑yö 'dho‑ 'ka, kö 'ya 'dho ‑dhɛ ‑ga ö ꞊taama, 'mɛ 'ö ‑dhɛ ‑ga ö ꞊taama kö‑ ‑mɛ 'yaa ‑tosɛa ‑kë Atanna ‑bha ‑gblüdëdhɛ 'gü ‑mɛ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö ‑kɔ ‑yɛ 'zü 'mɛ 'wo gun‑ ꞊keng‑ bha‑ mɛ ‑kaɔng \"saɔplɛ \"wɛɛ 'bha ‑bha, 'yö‑ ‑nu dan ꞊plɛ ꞊plɛ, 'yö‑ ‑nu bɔ ö \"dhiʋ̈ 'pödhɛ \"pɛpɛ 'ö ‑bɔ 'gü ‑wɔn ‑yö gun‑ ‑bha bha‑ ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","꞊Dhɛ 'ö yöö‑ ‑nu bɔ ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö ‑wʋ kpɔ‑ ‑nu ‑bha 'ö‑ pö: «Atanna ‑bha yë 'ö‑ këwɔn 'dhö 'dhö bha ‑kaa ‑ta ‑ga. 'Ö ꞊dhɛ ‑mlü 'dhö kö yö ꞊në ꞊ya ‑pë kë ‑dhɛ ꞊gban \"pɛpɛ 'gü bha, \"kɛɛ ‑a \"kan ‑mɛ 'yaa 'dhö. ꞊Dhɛ 'ö \"dhʋ̈, ‑ka bhɛa\" 'bhlaadë ‑dhɛ kö ‑yö ö ‑bha ‑mlü bha‑ \"kan ‑mɛ bɔ.» ");
INSERT INTO daf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","'Yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka 'dho, \"kɛɛ ka bɔ 'a‑ wo bha‑ 'wɔn kë ka \"yaan ꞊dhɛ a ka ‑bɔ ꞊dhɛ mɛ \"bhlaanë ‑nu bɔ laa ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka 'dho ‑sü 'ka 'ka 'dho 'wëëga ‑da ka ‑ta, ꞊kwɛɛsügüpë 'bha 'ya 'dho kë ka ‑gɔ. \"Ɛɛn 'ka 'dho ‑sabha ꞊plɛ ‑naa ‑da ka ‑ta. 'Mɛ \"ʋʋ mɛ 'ö 'ka ‑kpan ‑bha zian ‑ta, 'ka 'dho‑ ꞊tua bho. ");
INSERT INTO daf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","'Ka 'dho 'ka ‑da 'kɔ \"ʋʋ 'kɔ 'ö‑ 'gü, 'ka ‑da 'kɔɔdhö 'mü, ‑wʋ ‑blɛɛsü 'ka dho‑ pö yö ‑mü ꞊dhɛ: «Zuëwaanusü ‑yö kë 'kɔ ya‑ 'gü ‑mɛ ‑nu ka ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","'Ka‑ pö \"dhʋ̈, ꞊ya kë ꞊dhɛ 'mɛ 'ö zuë\" 'waanu ‑sü 'ö go Atanna \"piʋ̈ bha‑ ‑dhɔ 'dhö‑ ‑bha ꞊ya kë 'kɔ bha‑ 'gü, ka ‑bha 'dhuë‑ bha ‑yö ‑dho ‑a ‑mɛ 'kun, \"kɛɛ yö ‑zë 'yii kë \"dhʋ̈, ka ‑bha 'dhuë‑ ‑dho ö yee kë 'ö nu ka \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'Ka 'dho ziö 'kɔ 'gü ‑zaadhö (kë \"dhʋ̈ 'ö ‑siö ka ꞊dhɛng bhɔɔ ‑nu ‑dhɛ), ꞊wa ka ꞊yëë bho 'kɔ 'ö‑ 'gü, ‑ka 'to mü kö 'pë 'wo‑ nu ka ‑dhɛ, ‑yö ‑kë ‑bhöpë 'ka oo, ‑yö ‑kë müpë 'ka oo, kö 'ka‑ ‑bhö, \"ɛɛn kö 'ka‑ mü; ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö yë ‑kë, ‑a ‑dhɛa ‑bha ꞊dhɛ ‑wa ꞊saa bho. ");
INSERT INTO daf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'Ka ‑da 'pö‑ \"ʋʋ 'pö‑ 'ö‑ 'gü kö ‑wo ka ‑dhɛng ‑zë 'kun, pë \"ʋʋ pë 'wo‑ nu ka ‑dhɛ ‑bhöpë ‑zë 'ka ‑kaa ‑bhö. ");
INSERT INTO daf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kö 'ka \"yuëdhi ‑nu 'wo 'pö‑ bha‑ 'gü ‑a ‑nu dha, kö 'ka‑ pö 'pö‑ bha‑ 'gü ‑mɛ ‑nu ‑dhɛ: «Atanna ‑bha ‑gblüdëdhɛ ꞊ya ꞊tëng ka ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","꞊Ya kë ꞊dhɛ 'ka ‑da 'pö‑ \"ʋʋ 'pö‑ 'ö 'gü kö‑ 'gü ‑mɛ ‑nu 'wii ka ꞊yëë bho (Atanna ‑wʋ ‑san ‑bha ‑a ‑mɛ ‑nu kë ‑sü ‑wɔn 'gü), ‑ka 'dho kö 'ka dɔ \"dhɛɛdhö 'ka‑ pö 'pö‑ bha‑ 'gü ‑mɛ ‑nu ‑dhɛ ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«‑Bobi ‑zian 'ö yi ‑gɛn kun ka ‑gɔ 'pö‑ ya‑ 'gü ya ꞊në 'yi‑ bho sië yi ‑bha ya, (kö ka ‑bha \"dhang 'ka‑ ꞊mɔɔ bha ‑yö 'to ka ‑ta). \"Kɛɛ ‑yö kë ‑zë wo ka \"yaan ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ ꞊ya dun ka ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","꞊Ya kë ꞊dhɛ 'ka‑ pö \"dhʋ̈, a‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ kö Atanna ‑bha mɛ \"bhɩɩ‑ ‑nu dhɛɛ\" 'kpɔ ‑yi bha ‑yö ꞊loo, 'wɔn 'ö dho wɔ 'pö‑ bha‑ 'gü ‑mɛ ‑nu ‑ta ‑a \"dhiʋ̈ ‑dho ziö 'wɔn 'ö‑ ‑wɔ Sodɔmö ‑mɛ ‑nu ('ö‑ ‑wɔn \"dhia 'yaa gun‑ ‑nu 'gü 'pö yi 'bha 'ka bha‑ ‑nu ‑ta) bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yö ꞊në‑ ‑wɔn 'gü 'yö Yesu ‑ya pö: «Kodhazɛn ‑mɛ ‑nu, ka 'vee‑! Bɛsaida ‑mɛ ‑nu, ka 'vee‑! ‑A ‑pö ka ‑dhɛ \"dhʋ̈ ‑gɛn ‑mü ꞊dhɛ \"dhabhliwɔn ‑nu 'a‑ ‑kë ‑nu wo ka kpö 'gü bha, ꞊ya kë ꞊dhɛ a‑ ‑kë \"dhʋ̈ Tii‑ ‑pö waa‑ Sidɔn ‑pö ‑nu ꞊në‑ 'gü, kö‑ ‑nu ‑gbɛʋʋ kë Atanna ‑dhɛ ‑yi 'yaa ꞊dɛɛ. ");
INSERT INTO daf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","‑A ‑kë \"dhʋ̈ ‑sü 'gü, Atanna ‑bha mɛ \"bhɩɩ‑ ‑nu dhɛɛ\" 'kpii‑ 'kpɔ ‑yi bha ꞊ya ꞊loo yi 'ö‑ 'ka, 'wɔn 'ö ‑kë 'mɛ 'wo gun 'pödhɛ 'wo‑ Sidɔn waa‑ Tii ‑pö ‑kë bha‑ 'gü yi 'bha 'ka bha‑ ‑nu 'ka bha‑ fië‑ ‑dho kë ka ‑bha ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapɛɛnaɔmö ‑mɛ ‑nu, kaa ‑dɩ 'pö ꞊wɛ! ‑Yö ‑kë ka 'gü ꞊dhɛ ka ‑zë 'ka kpɛa‑ ka ‑gɔ ꞊ya zun dhang‑ ‑bha, \"kɛɛ ka ‑gɔ ‑dho lɔɔ‑ 'ö dho 'ö ‑sɔ pɛng ‑kaso 'ö ꞊geebɔɔ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö go mü 'zü 'ö‑ pö ö bha ꞊klang ‑nu bha‑ ‑nu ‑dhɛ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'ka 'dho mɛ 'ö ꞊ya \"tʋ 'to ka ‑wʋ ‑bha kö ꞊ya \"wɩ ma ꞊në n ‑wʋ ‑bha bha, ‑ɛɛ 'mɛ 'ö ‑kɔ 'zü ka ‑wʋ 'ka kö ‑yö ‑kɔ ma ꞊në n ‑wʋ 'ka bha, 'sa kö‑ ‑mɛ ‑yö ‑kɔ 'pö 'mɛ 'ö n bɔ ꞊në‑ ‑wʋ 'ka bha. ");
INSERT INTO daf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","꞊Dhɛ 'ö mɛ ‑kaɔng \"saɔplɛ bha ꞊wa 'dho, ‑a ‑nu yee kë ‑sü 'ka ‑wo ‑nu ꞊niidadhe ꞊dede 'ka. ꞊Dhɛ 'wo nu 'yö 'wo‑ pö wo Dëmɛ ‑dhɛ: «Yi Dëmɛ, 'dho 'yi‑ wo bha \"yina yaa ‑nu ‑zian ‑wo kë wo ‑gɔ ‑lɔɔ yi ‑dhɛ i 'tɔ 'gü!» ");
INSERT INTO daf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A ‑kë \"dhʋ̈ ‑sü 'wɔn 'ya 'dho ka 'kɔn,) ‑a ‑gɛn ‑mü ꞊dhɛ n ‑kɔ ꞊ya ziö Sɔtraan ‑gɔ, ");
INSERT INTO daf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","꞊ya 'go mü, 'ma ‑kɔ ‑ziö ‑a zü ‑gban 'gü ‑pë \"pɛpɛ ꞊gban ‑gɔ ‑sü ‑faan ‑da ka 'gü 'pö, kë \"dhʋ̈ kö pë \"ʋʋ ‑pë 'bha ‑kɔ 'ya 'dho ꞊mɔɔ ka ‑bha, ‑a ‑wɔn 'gü ka ‑dho taa‑ ‑mlɛɛ ‑nu waa‑ gɛan\" ‑nu ‑ta 'ö 'waa ka kë ‑kɔ 'bha 'gü, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ a kë Sɔtraan yö kö ‑yö 'go sië dhang‑ 'gü 'ö ‑pö ꞊dhɛ dha 'ö \"yaan‑ kun ‑a 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","\"Kɛɛ 'kö 'zü yöö kë \"dhʋ̈, 'wɔn 'ö yöö kë ka ꞊nii ‑da 'gü ‑wɔn 'ka 'yaa \"yina yaa ‑nu ‑bha ‑gɔ ‑dho ka ‑dhɛ \"sia‑ ‑wɔn ‑zë 'ka. 'Wɔn 'ö dho ka ꞊nii ‑da yö ‑mü ꞊dhɛ mɛ 'ka bha ka 'tɔ ‑bɛn ‑yö zë ‑sü 'ka dhang‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dhiang bha ‑yö ‑to Yesu \"dhi 'yö zuëniidadhe ‑ya pa Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑kɔ 'ka 'yö‑ pö: «'A, n Dë Atanna, 'ma i nuɛ\" bho ꞊dedewo, \"sɛ waa‑ dhang‑ ‑a ‑nu 'gü ‑pë ꞊gban ‑gɔdhiʋ̈mɛ, ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn ‑nu ya 'bha‑ ‑bin 'wɔn dɔ ‑mɛ ‑nu waa‑ \"yaakimɛ ‑nu 'wo \"kpʋngtaadhɛ ya‑ 'gü ‑nu ‑gɔ, 'yö 'bha‑ ‑ta \"pʋ 'mɛ 'wo ꞊dhɛ 'në 'sɛɛnnë ‑nu 'dhö ꞊në‑ ‑nu ‑dhɛ. Tɛan‑ ꞊dede 'ka, n Dë, a i nuɛ\" ‑bho \"wɩ 'i‑ wo‑ bha kö ‑yö kë \"dhʋ̈ bha‑ ‑wɔn 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'Yö go 'mü 'yö‑ pö: «N Dë ꞊ya 'wɔn ꞊gban \"pɛpɛ dɔ n ‑kɔ 'ka, mɛ 'bha 'yaa yɛng yi ‑bho \"kʋʋ dɔ. Ma 'a ‑kë ‑a Gbö 'ka, mɛ 'bha 'yaa n dɔ kö 'yii kë n Dë 'ka, \"ɛɛn yö 'ö ‑kë 'pö n Dë 'ka, mɛ 'bha 'yaa‑ dɔ kö 'yii kë ma 'a kë ‑a Gbö 'ka, \"ɛɛn 'zü 'mɛ 'kö 'a‑ ‑ta ‑pʋ ‑a ‑nu ‑dhɛ bha kwa 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ö wë bɔ ö ‑bha ꞊klang ‑nu ‑ta, 'yö‑ pö‑ ‑nu ‑dhɛ ‑dɩ ‑wɔn \"dhiʋ̈ 'ö‑ pö: «'Mɛ 'ö‑ ‑nu \"yan ‑yö ‑dhɛ 'ö 'ka yö sië ya‑ yö, ‑a ‑nu ‑bha ‑së! ");
INSERT INTO daf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","‑A 'klɔɔ‑ ‑mü ꞊dhɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ ‑yö ‑gun Atanna ‑wʋdhiʋ̈loomɛ ‑nu waa‑ ‑gblüdë 'gbɛ \"piʋ̈ ꞊dhɛ wo \"yan ‑yö ‑da 'wɔn ‑nu 'a‑ ‑kë ka‑ ‑dhɛ yö sië ya‑ ‑dhɛ 'gü, \"kɛɛ 'wii‑ ‑dhɛ yö, ꞊dhɛ wo \"tʋ ‑yö ‑da 'wɔn ‑nu 'ka‑ ma sië ya‑ 'gü, \"kɛɛ 'wii‑ ma.» ");
INSERT INTO daf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö Atanna ‑bha 'tɔnggɔmɛ do ‑yö ꞊wlü 'yö‑ pö 'ö‑ 'gü dan 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ, a ‑dho ‑a kë ‑kɔ kë ꞊dhɛ kö 'a kë ‑tosɛa 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha‑ kë ‑mɛ 'ka?» ");
INSERT INTO daf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Më ‑wɔn ꞊në ‑bɛn zë ‑sü 'ka Atanna ‑bha 'tɔng‑ 'sëëdhɛ 'gü 'wɔn bha‑ \"gblʋʋ \"piʋ̈ 'i‑ dɔ, \"ɛɛn 'bha‑ ‑wʋ pö i‑ 'gü ma ‑kɔ ‑kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","'Yö ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Atanna ‑wʋ ‑ya ‑pö ꞊dhɛ: Bha‑ pö 'i ‑da ‑a ‑bha ꞊sii 'ö 'yaa yën bha‑ kë ‑dhɛ 'gü, ‑a ‑dhɛa ‑bha ꞊dhɛ ‑a ‑dhɔ ‑yö i kë i zuë\" ꞊gban 'ka, i 'nii‑ ꞊gban 'ka, i faan ꞊gban 'ka, ꞊ya 'go mü kö i këyɔɔ ‑dhɔ ‑yö i kë ꞊dhɛ i ‑dɩ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","'Yö Yesu ‑ya pö‑ ‑dhɛ: «I‑ ‑pö ‑së, 'bha 'dho ‑bhö ‑a kë \"dhʋ̈, i ‑dho ‑da ‑bha ‑gblüdëdhɛkëdhɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","\"Kɛɛ 'yaa gun 'tɔnggɔmɛ bha‑ \"piʋ̈ ꞊dhɛ dhiang ‑yɔ ‑yö 'to ö ‑ta, 'yö‑ pö Yesu ‑dhɛ: «De suu ꞊në 'wo‑ ‑dhɛ mɛ këyɔɔ?» ");
INSERT INTO daf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","'Yö Yesu ‑yö dhiang zü ‑dee bho 'ö‑ pö: «Yi do 'ka 'yö mɛ do 'bha 'dhö gun 'go sië Zedhizadhɛmö kö ‑yö 'dho sië Zedhiko. 'Yö dho 'yö ‑da 'wɔnyaakëmɛ ‑nu ꞊kwɛɛ‑. 'Yö 'wo ‑pö ‑ta 'wo‑ ‑bha pë ꞊gban \"pɛpɛ sü‑ ‑gɔ, 'yö 'wo‑ ‑ma ‑tëkë ‑tëkëdhö. ꞊Dhɛ 'wo‑ ‑ga ꞊dhɛ ꞊ya wɔ 'ya‑ 'yö 'wo wo ꞊kwaa‑ ‑zü 'wo dho. ");
INSERT INTO daf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","'Yö \"saabhomɛ ‑nu 'wo Atanna ‑dhɔkëgükɔ 'gü bha‑ mɛ do 'dhö gun 'go sië 'pö Zedhizadhɛmö, 'yö bɔ zian do bha‑ ‑ta, 'yö dho 'yö ‑kan 'mɛ 'wo‑ \"dhama ‑da bha‑ 'gü, 'yö kpɔ‑ 'ka 'yö bɔ zian \"wɛɛ 'ka 'yö dho. ");
INSERT INTO daf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","'Yö Dhevi ‑gɔ 'kɔɔmɛ ‑nu ('ö woo ‑dɩ 'pö 'wo \"saabhomɛ ‑nu ‑ta kun Atanna ‑bha yë kë ‑sü ‑bha) bha‑ mɛ do 'bha 'ö gun bɔ sië 'pö ‑dhɛ do bha‑ 'gü, 'yö ‑kpan 'mɛ bha‑ ‑bha. 'Yö kpɔ‑ 'ka 'pö 'yö dho. ");
INSERT INTO daf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","\"Kɛɛ ꞊dhɛ 'ö Samadhi mi do 'bha bha 'ö gun ö bha \"ta 'kpɔ sië, 'yö nu 'ö ꞊loo ‑dhɛ bha‑ 'gü 'yö 'mɛ bha‑ yö, 'yö ‑wëë ‑yö bɔ‑ ‑ta ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","'Yö ꞊yɔɔn 'mɛ bha‑ \"sɔɔ 'yö‑ ‑bha bhië ‑nu ‑zu \"pɛɛpɛdhö, 'yö pë ‑ya \"dhiʋ̈, 'yö sɔ \"pɛn ꞊piʋ̈‑ 'ka, 'yö‑ sü 'ö‑ ‑ya ö ‑dɩ ‑bha ꞊soo bha‑ ‑ta, 'yö dho‑ 'ka ‑dhɛng ‑nu ꞊yëëbhogükɔ do 'bha 'gü, 'yö‑ \"dhiʋ̈ ‑ziö wo ‑së 'ka. ");
INSERT INTO daf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","꞊Dhɛ 'ö ꞊wa wɔ mü 'ö‑ ‑ta ‑dhɛ ꞊ya ꞊kpaɔ, 'yö ‑kɔ ‑da ö ‑gɔ \"yië‑ 'gü, 'yö 'wëë‑ këng do ‑nu \"sinma sü 'mü, 'yö‑ nu wo ‑dhɛngbhɔɔdë bha‑ ‑dhɛ, 'yö ö ‑wʋ kpɔ‑ ‑bha 'ö‑ pö: «'I i ‑zʋ kë ma mɛ ya‑ 'gü n ‑dhɛ ‑së 'ka. 'Ma 'dho a nu sië, 'pë ʋʋ pë 'i dho‑ see‑ ‑bha n zian 'gü, 'ma nu kö 'i‑ pö n ‑dhɛ kö 'a i gba‑ \"wɛɛ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","'Yö 'tɔnggɔmɛ bha‑ dhɛɛ\" kpɔ 'ö‑ pö: «Mɛ ‑yaaga bha‑ de ‑sü ꞊në 'i‑ dɔ ꞊dhɛ 'mɛ 'ö ‑pö 'wɔnyaakëmɛ ‑nu ꞊kwɛɛ‑ bha‑ këyɔɔ 'dhö?» ");
INSERT INTO daf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Yö‑ ‑yɔ bɔ Yesu ‑gɔ 'ö‑ pö: «Mɛ 'dhɛ ‑a ‑wëë ‑ya ‑kë bha ꞊në‑ këyɔɔ 'ka.» 'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Ɛɛ, kö 'bha 'dho 'sa ‑bhö ‑a kë 'pö ꞊dhɛ 'mɛ bha‑ 'dhö!» ");
INSERT INTO daf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","꞊Dhɛ 'ö Yesu waa‑ ö ‑bha ꞊klang ‑nu ꞊wa ‑da zian ‑ta 'wo 'dho sië Zedhizadhɛmö, 'yö 'wo ꞊loo 'pödhɛ 'bha bha‑ 'gü, 'yö dhebhɔnë do 'bha 'wo‑ ‑dhɛ Matö bha, 'ö‑ ꞊yëë bho ö ‑gɔ 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matö bha‑ dheebhang do‑ ‑gun mü 'wo‑ ‑dhɛ Madhi. ꞊Dhɛ 'ö Yesu ꞊ya 'dho ꞊ya ‑da 'kɔɔdhö, 'yö Madhi dho 'ö ‑ya ‑a \"sɔɔ kö 'ö ö \"tʋ 'to‑ ‑wʋ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kö Matö ‑zë ‑yö 'kɔɔdhö ‑yë ‑nu kë sië, 'yö Matö nu 'ö‑ pö Yesu ‑dhɛ: «N Dëmɛ, n 'to 'ö n 'zlaa‑ Madhi ‑ya wo yë ‑bha 'ö nu \"tʋ ‑to i ‑wʋ ‑bha ‑dhɛ 'gü ya i i ‑bha ‑pö 'gü ꞊dhɛ? ‑A pö‑ ‑dhɛ kö ‑yö n ‑ta 'kun ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Matö n \"tɛado, 'wɔn 'gbɛ ꞊në 'i dɔ sië 'kën 'gü ‑a ‑wɔn 'gü 'yö i zuëdhiʋ̈tɛɛ sië bha, ");
INSERT INTO daf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","\"kɛɛ pë dosengseng ꞊në‑ ‑wɔn 'dhö \"gbɩɩ‑, yö ꞊në Madhi ‑ya sü bha. 'Pë 'ö Madhi ‑ya ‑sü bha ꞊në mɛ 'bha ‑kɔ 'yaa ꞊mɔɔ‑ ‑bha kö ‑ya 'sü‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","‑Dhɛkpaɔyi do 'ka, 'yö Yesu ‑yö ꞊wlü 'ö dho ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü ‑dhɛ do 'bha 'gü. ꞊Dhɛ 'ö ö bo ‑bhɛa ‑a ‑dhɛ ‑sü 'ka, 'yö‑ ‑bha ꞊klangdhiʋ̈ ‑nu bha‑ mɛ do ‑ya pö‑ ‑dhɛ: «N Dëmɛ, ‑bhö ‑bhɛa Atanna ‑dhɛ ‑kɔ ‑zɔn yi ‑dhɛ ꞊dhɛ ‑kɔ 'ö Zan ‑ya ‑zɔn 'ka ö ‑bha ꞊klang ‑nu ‑dhɛ bha‑ 'dhö ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «'Kwa‑ ma! 'ka‑ pö 'ka bhɛa\" Atanna ‑dhɛ, ‑kaa pö: «Yi Dë, i 'tɔ ‑yö kë ꞊bhlëësü, 'wɔn‑ 'to bhi ꞊në i ‑bha ‑bha \"kpʋng ꞊taa yö ꞊dhɛ ‑kɔ 'ö‑ 'ka dhang‑ 'gü ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","‑Bhö dɔ \"gbɩɩ‑ kö ‑dhɛ \"puu 'ö ꞊kpaɔ 'i yi ‑bhöpë nu yi ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","‑Bhö yi këwɔn yaa ‑nu ‑mawɔn 'to ꞊dhɛ ‑kɔ 'ö mɛ ꞊ya 'wɔn yaa kë 'pö yi 'ka, 'yi‑ ‑mɛ ‑mawɔn to 'ka bha‑ 'dhö. ‑Bhö yi ‑maa kë kö 'ya 'dho ‑da 'wɔn yaa 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","꞊Dhɛ 'ö Yesu ꞊ya ö bo ‑bhɛa Atanna ‑dhɛ ‑kɔ ‑zɔn ‑sü 'ka ‑a ‑nu ‑dhɛ \"dhʋ̈, 'yö‑ \"gwënng do ‑da ‑nu ‑dhɛ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'mɛ 'ka bha mɛ 'bha ꞊ya \"wlü gbeng ꞊zinng 'gü kö ‑yö 'dho ö \"taɔngdë \"piʋ̈ kö ‑ya pö‑ ‑dhɛ: «N \"taɔngdë, ‑bhö ‑bhöpë \"pɔ dɔ n ‑bha! ");
INSERT INTO daf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","N \"taɔngdë ‑dhɛng 'bha ꞊në ꞊ya bhɔ n ‑ta, \"kɛɛ maa pë 'ö‑ ‑kpa ‑dhɛ n \"yan 'yaa‑ \"dhiʋ̈, ‑bhö dɔ \"gbɩɩ‑!» ");
INSERT INTO daf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kö‑ \"taɔngdë bha ‑yö bɔ 'kɔɔdhö ‑ya pö‑ ‑dhɛ: «‑Fɛɛ bha! 'Ma \"kwɛɛ ta 'nu, yaa‑ n \"piʋ̈mɛ ‑nu 'ya 'waanu, 'mii 'dho ꞊mɔɔ‑ ‑bha 'zü kö 'a \"wlü kö 'a ‑bhöpë nu i ‑dhɛ», \"kɛɛ kö‑ \"taɔngdë 'ö nu 'bluu‑ ‑gbadhɛ bha ‑yö ‑fɛɛ ‑ya ‑bha, ");
INSERT INTO daf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'kö 'zü 'ö ‑kë ꞊dhɛ 'mɛ bha 'yii \"wlü kö ‑yö ‑bhöpë bha‑ nu ö \"taɔngdë bha‑ ‑dhɛ ‑a ‑bha ‑kë ‑a \"taɔngdë 'ka ‑sü ‑wɔn 'gü, \"kɛɛ ‑yö ‑dho \"wlü zë wo 'ö pë \"pɛpɛ 'ö‑ ‑mawɔn 'dhö‑ ‑bha bha‑ nu ‑dhɛ 'ö ‑fɛɛ 'ö‑ ‑ya ‑bha bha yö ‑zë ‑wɔn 'gü.» (‑Bhɛa Atanna ‑dhɛ ‑sü bha 'ö ‑kɔ 'ö‑ ‑bha 'yö bha.) ");
INSERT INTO daf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yö ꞊në‑ ‑wɔn 'gü, 'yö ma ‑zë 'a‑ pö ka ‑dhɛ: «‑Ka pë ‑gbadhɛ Atanna ‑gɔ, ‑yö ‑dho ‑a nu ka ‑dhɛ. ‑Ka pë mɔɔ‑, ka ‑dho ‑a ꞊slɔɔ. ‑Ka \"kwɛɛ ‑ta ‑ma, ‑wo ‑dho \"kwɛɛ \"pʋ ka ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö pë ‑gbadhɛ Atanna ‑gɔ, 'yö‑ nu‑ ‑dhɛ, 'mɛ 'ö pë ꞊mɔɔ 'yö‑ yö, 'mɛ 'ö \"kwɛɛ ‑ta ‑ma 'yö 'wo‑ ‑pʋ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","\"Ɛɛn 'në dë 'bha‑ ‑kë 'yö‑ ‑bha 'në ꞊ya 'bluu‑ ‑gbadhɛ ‑gɔ, 'yö 'bluu‑ 'kö bha‑ to 'yö ‑gwë nu‑ ‑dhɛ ‑ee? \"Ɛɛn 'ö ꞊ya 'yuʋ̈ga ‑gbadhɛ, 'yö‑ to 'yö ‑mlɛɛ \"yaandhe nu‑ ‑dhɛ ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","\"Ɛɛn mɛ 'bha ‑yö ka kpö 'gü, 'yö‑ ‑bha 'në ꞊ya ‑tɔyaan ‑gbadhɛ ‑gɔ, 'yö gɛan\" nu‑ ‑dhɛ ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","\"Sanni ka 'kö ka \"gblü 'dhö 'ya‑ bha 'ka pë ‑sɛngbɔ ‑nu nu kaa‑ 'në ‑nu ‑dhɛ ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö n Dë 'kö‑ \"klʋ 'dhö ‑së ꞊wɛ, ‑yö ‑dho ‑kɔ 'mɛ 'wo 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑gbadhɛ ‑gɔ ‑a ‑nu ‑dhɛ ‑kɔ kë ꞊dhɛ ‑a ‑ta? ");
INSERT INTO daf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yi do 'ka, 'yö Yesu ‑yö \"yina yaa 'ö gun mɛ do 'bha 'gü 'ö gun‑ kë sië \"bhʋbhʋ 'ka bha‑ ‑kë, 'yö go 'mɛ bha‑ 'gü 'yö dhiang zë. 'Yö‑ 'wɔn ‑yö mɛ kpö 'wo gun mü bha‑ ‑nu kɔn, 'yö 'wo \"dhi dɔ Yesu ‑bha bong 'ka. ");
INSERT INTO daf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","\"Kɛɛ 'yö mɛ 'bha ‑nu ‑wa pö: «'Mɛ 'ö bha \"yina ‑nu 'ö‑ \"piʋ̈ kë sië bha, Bɛɛzebidhö 'ö kë \"yina yaa ‑nu ‑bha ‑gblüdë 'ka bha ꞊në‑ ‑faan nu‑ ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kö 'mɛ 'wo‑ 'güdandhɛ mɔɔ‑ sië 'pö ‑wa pö sië‑ ‑dhɛ 'wo‑ pö: «'Ö ꞊ya kë ꞊dhɛ faan 'ö i 'gü 'i 'wɔn ‑nu kë sië‑ ‑bha bha 'ö go Atanna ꞊në‑ \"piʋ̈ dhang‑ 'gü tɛan‑ 'ka, ‑bhö \"dhabhliwɔn 'bha kë kö 'yi‑ ‑dhɛ yö!» ");
INSERT INTO daf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","\"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ Yesu ‑ya ‑nu zuëpiʋ̈wɔn ‑dɔ, 'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Yaa ka 'gü ꞊dhɛ \"sɛ \"ʋʋ \"sɛ 'ö‑ 'gümɛ ‑nu ꞊wa ‑ya 'ko ‑zë 'wo \"kwëë ‑sü ‑bha, kö‑ \"sɛ bha ꞊ya 'wü ꞊naa bha ‑ee? ꞊Ya kë \"dhʋ̈ ‑a 'kɔdhi ‑nu 'waa 'wü ꞊në wo 'wo dho‑ 'ka ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","꞊Ya kë \"dhʋ̈ 'ka‑ pö ꞊dhɛ Sɔtraan ꞊në faan nu n ‑dhɛ 'yö 'a \"yina yaa ‑nu ‑kë 'ka mɛ ‑nu 'gü bha oo, ꞊ya kë ꞊dhɛ Sɔtraan ꞊ya ö ‑gɛn ‑da ö ‑dɩ ‑bha mɛdhɛ 'gü kö ‑yö ‑gblü gɔɔn ö ‑dɩ 'ka bha ‑oo, ‑a ‑bha ‑gblüdëdhɛ ‑dho ꞊gwëë ‑kɔ ‑kë ꞊dhɛ? ");
INSERT INTO daf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","꞊Ya kë ꞊dhɛ 'ka‑ pö ma ‑zë a \"yina ‑nu ‑kë mɛ 'gü Bɛɛzebidhö ꞊në‑ faan 'ka bha ‑oo, 'yö ka gbö ‑nu ‑zë ꞊wɛ? Yö ꞊në‑ ‑wɔn 'gü 'yö 'a dho‑ pö ka ‑dhɛ ꞊dhɛ ka ‑dɩa 'në ‑nu bha ꞊në 'wo dho ka zë za 'ka yi do 'ka. ");
INSERT INTO daf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","\"Kɛɛ ꞊ya kë ‑zë wo ꞊dhɛ a \"yina yaa ‑nu bha‑ ‑nu ‑kë Atanna faan ꞊në‑ 'ka, kö‑ ‑bha ‑gblüdëdhɛ ꞊ya nu ka \"piʋ̈.» ");
INSERT INTO daf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑ta \"gwënng ‑da ‑nu ‑dhɛ 'ö‑ pö: «'Mɛ 'ö ‑kɛgbaan 'ka, 'ö ‑gblü ‑gɔɔn 'ka ‑kwɛɛ 'dhö‑ ‑gɔ, ꞊ya ö ‑bha \"kwɛandhɛ ‑maa kë, ‑a ꞊slɔɔpë ‑nu ‑wo ‑kë wo 'flëë‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","\"Kɛɛ 'mɛ 'ö‑ faan 'dhö \"gbɩɩ‑ 'ö ‑ziö yö ‑zë ‑ta ꞊ya nu, kö‑ ‑kɔ ‑zë ‑yö wɔ‑ ‑ta, ‑ya 'kpee‑ ꞊në‑ bho, 'yö‑ ‑bha 'ko ‑zë 'ka ‑kwɛɛ ꞊gban sü‑ ‑gɔ 'yö‑ ꞊slɔɔpë ꞊gban \"pɛpɛ 'gü ‑gblü mɛ ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mɛ 'yii bɔ n 'ka kö ‑yö ‑nu n ‑gɔ, 'yö 'mɛ 'yii n ‑ta 'kun n \"piʋ̈ ‑mɛ ‑nu ‑loo 'ko ‑ta ‑sü ‑bha, kö‑ ‑nu ‑kan 'kwëë‑ ‑mɛ ꞊në ‑mü.» ");
INSERT INTO daf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","'Yö go mü 'ö‑ pö: «꞊Ya 'go yö ‑zë 'gü, \"yina yaa ꞊ya 'go mɛ 'gü ꞊ya 'dho, ‑yö ‑dhɛ \"kpɛadhɛ ‑nu ꞊në‑ ꞊mɔɔ kö 'ö ‑ya 'gü. ꞊Ya kë ꞊dhɛ ꞊yaa‑ ‑dhɛ mɔɔ‑ 'yii‑ yö 'yö‑ pö: «'A, ꞊ya 'to yö ‑zë ‑bha kö a ‑dho n yee kë 'a dho n ‑gɔ 'kɔɔdhɛ 'a go‑ ‑bha bha‑ 'gü \"dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","꞊Ya kë \"dhʋ̈ ꞊ya ö yee kë kö ‑yö nu, kö 'kɔɔdhɛ bha ꞊waa‑ ‑gblö \"pɛɛpɛdhö, kö ꞊wa 'kɔɔdhɛ dhipë ‑nu ꞊loo mü ‑dhɛ ꞊gban 'gü, ");
INSERT INTO daf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","'yö ö yee ‑dee 'bha ‑kë 'ö dho 'yö ö ‑kɔ ‑da \"yina yaa ‑dee \"saɔplɛ 'ö wo ‑zë ‑a ‑nu ‑mawɔn 'dhö 'ya‑ 'ö ‑ziö ö ‑ta ‑a ‑nu 'gü, 'yö 'wo nu 'zü ‑deewo 'wo ‑da 'mɛ bha‑ 'gü, 'yö 'wo wo ‑yɛa kun mü. ꞊Wa wo ‑yɛa ‑dee 'dhɛ 'kö bha‑ 'kun ꞊dhɛ ‑kɔ bha‑ 'dhö, ‑a 'mɛ bha‑ këwɔn ꞊ya ‑siö ‑zianwo ꞊taamasü bha‑ 'gü, ‑yö kë ꞊dhɛ 'pë 'yii pë 'bha kë ‑blɛɛsü ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu ‑yö ‑to dhiang ‑nu bha‑ ‑nu zë ‑dhɛ 'gü, 'yö dhebhɔnë do ‑yö bɔ mɛ kpö 'gü 'yö ö ‑wʋ \"dhiʋ̈ ꞊wlü 'ö‑ pö: «'Aami, 'në suu 'kö ya 'ö ‑wɔ dhebhɔ 'kö \"gblʋ̈ʋ̈‑, 'ö 'yɔn mü‑ ‑gɔ ‑a ‑bha ‑së ꞊tɔn ‑kɛɛ!» ");
INSERT INTO daf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «Mɛ ‑zian 'kö 'wo wo \"tʋ 'to Atanna ‑wʋ ‑bha 'ö 'wo‑ 'gü ‑ta sü wo ‑zë ‑a ‑nu ‑bha ‑së 'ö ‑ziö dhebhɔ kö n kpɔ bha‑ ‑bha ‑ta!» ");
INSERT INTO daf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yi do 'bha bha‑ 'ka 'zü, kö Yesu ꞊ya mɛ ‑nu yö kö ‑wo nu sië \"tʋ ‑to ö ‑wʋ ‑bha ‑dhɛ 'gü ‑dhɛ ꞊gban 'gü yuudhö, 'yö ‑ya dhiang zë ‑sü ‑bha ‑a ‑nu ‑dhɛ 'ö‑ pö: «\"Tʋ̈ng ya‑ 'gü ‑mɛ ‑nu këwɔn 'bha ‑bha 'bha 'yaa ‑së, \"kɛɛ ‑ya ‑nu \"piʋ̈ 'sa ꞊dhɛ 'a \"dhabhliwɔn do 'bha kë ‑a ‑nu \"yaan kö 'wo‑ 'suan‑ bho‑ ‑bha ꞊dhɛ Atanna ꞊në n bɔ tɛan‑ 'ka. \"Kɛɛ 'mii 'dho \"dhabhliwɔn ‑zë ‑dee 'bha kë 'zü ‑a ‑nu \"yan \"dhiʋ̈ kö 'yii kë 'wɔn 'ö ‑kë Atanna ‑wʋdhiʋ̈loomɛ Zonasö 'ka yi 'bha 'ka, ('ö ‑dhɛkpaɔyi ‑yaaga ‑kë 'yuʋ̈‑ \"gblʋ̈ʋ̈‑ 'yö ‑wo 'zü \"yɛa‑ 'ö ‑tosɛa ‑kë bha yö ‑zë suu 'ka). ");
INSERT INTO daf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ Zonasö ‑wɔn 'dhö ‑kë Ninivö ‑mɛ ‑nu ‑gɔ \"dhabhliwɔn 'ka ‑kɔ do 'ö‑ 'gü yi 'bha 'ka bha, mang Mɛgbömɛ mang ‑dɩ 'pö n ‑wɔn ‑dho kë \"tʋ̈ng ya‑ 'gü ‑mɛ ‑nu ‑gɔ ‑kɔ do bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","‑A ‑wɔn 'gü, Atanna ‑bha mɛ \"bhɩɩ‑ ‑nu dhɛɛ\" 'kpii‑ 'kpɔ ‑yi bha ꞊ya ꞊loo yi 'ö‑ 'ka, ‑gblüdëdhe 'ö gun Seba ‑sɛ ‑gɔ \"dhiʋ̈ yi 'bha 'ka bha ꞊në dho \"wlü 'yö 'mɛ 'wo \"tʋ̈ng ya‑ 'gü bha‑ ‑nu zë za 'ka Atanna ‑kuu \"dhiʋ̈; ‑a ‑gɛn ‑mü ꞊dhɛ yö ‑zë ‑yö kë ‑go \"sɛ ꞊gblɛɛn ꞊dede 'gü 'ö nu 'ö ö \"tʋ to (‑gblüdë) Sadhomɔ zë ‑dhiang ‑nu ‑bha, \"yaaki 'ö Atanna ‑ya nu Sadhomɔ ‑dhɛ bha‑ \"piʋ̈, 'sa a‑ ‑pö ka ‑dhɛ ꞊dhɛ ma 'kö a ka kpö 'gü ya, (ma ‑zë ma 'wɔn dɔ ‑sü ‑yö ‑ziö Sadhomɔ ‑bha ‑ta, \"kɛɛ 'sa mɛ 'bha 'yaa ö \"tʋ to n ‑wʋ ‑bha). ");
INSERT INTO daf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivö ‑mɛ ‑nu ‑dɩ 'pö ‑wo ‑dho \"wlü 'yi bha‑ 'ka Atanna wëëdhö, 'ö 'wo \"tʋ̈ng ya‑ 'gü ‑mɛ ‑nu zë za 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ ꞊dhɛ 'ö Zonasö ꞊ya 'dho ꞊ya dhiang zë 'mɛ 'wo bha‑ ‑nu ‑dhɛ ‑wo kë wo zuë\" ‑slëë Atanna \"piʋ̈. \"Kɛɛ 'sa a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mɛ 'ö dhiang zë sië ka ‑dhɛ ya, yö ‑zë ‑duɛ ‑yö 'kpii‑ Zonasö ‑zë ‑bha (\"kɛɛ yö ꞊në‑ ꞊gban 'gü 'waa \"wɩ‑ ‑bha kö ‑wo wo zuë\" slëë‑ Atanna \"piʋ̈).» ");
INSERT INTO daf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","'Yö‑ pö: «Mɛ 'bha 'yaa ‑dhangbha dɔ kö ‑yö gbɔ ‑gblü ‑ta, \"ɛɛn 'zü kö ‑ya ‑gblɛn 'kpɔ, \"kɛɛ ꞊waa‑ dɔ ‑wa ‑ya ‑dhangbha ‑dɔtapë ꞊në‑ ‑ta, 'yö 'mɛ ꞊ya ‑da 'kɔɔdhö 'yö ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","‑Kɔ do bha‑ 'gü, mɛ \"yan ꞊në ꞊dhɛ mɛ kwi ‑bha ‑dhangbha 'dhö. \"Tʋ̈ng 'ö mɛ \"yan ‑dhɛ 'bha 'yaa‑ ‑bha, 'ö 'flëë‑ 'gü ‑së 'ka kö mɛ kwi ‑yö ‑dhɛpuudhɛ 'gü 'pö. \"Kɛɛ mɛ \"yan ‑dhɛ ꞊ya ‑ya ‑bha kö mɛ kwi ꞊ya ‑da ‑dhɛtiidhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","꞊Dhɛ 'ö \"dhʋ̈ kö ‑ka ka ‑zʋ 'kpɔ ka ‑dɩ 'gü kö ‑dhɛpuudhɛ 'ö ka 'gü bha 'ya 'dho \"gla ‑dhɛtiidhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","꞊Ya kë ꞊dhɛ ‑dhɛ 'dhö \"pʋ ‑sü 'ka mɛ ‑dhɛ ꞊gban ‑dhɛ ꞊gban ‑ta, kö i ‑dhɛ 'bha 'yaa ‑dhɛtiidhɛ 'gü 'zü, kö ‑dhɛ ꞊ya \"pʋ i ‑ta blongdhö ꞊naa bha. ꞊Ya kë \"dhʋ̈ kö 'bha kë ꞊dhɛ 'mɛ 'ö dɔ sië ‑dhangbha 'bhü \"dhiʋ̈, 'ö ‑dhɛ ꞊ya \"pʋ‑ ‑zü zian ꞊gban 'ka ‑a 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","‑Yö ‑to dhiang bha‑ zë ‑dhɛ 'gü, 'yö Fadhiziɛn mi do ‑ya ‑dhɛ ‑bhöpë 'ka ö ‑gɔ 'kɔɔdhö 'yö dho. ");
INSERT INTO daf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","꞊Dhɛ 'wo gun pë ‑bhö sië, 'ö Yesu 'yii ö ‑kɔ \"zu ꞊kö kö ‑yö gun ‑na pë ‑bhö ꞊dhɛ ‑kɔ 'ö‑ 'ka ‑a ‑nu 'tuʋ̈‑ 'ka ‑a 'dhö, 'yö‑ 'wɔn ‑yö Fadhiziɛn mi bha‑ kɔn. ");
INSERT INTO daf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","\"Kɛɛ 'yö kwa Dëmɛ ‑ya pö‑ ‑dhɛ 'ö‑ pö: «Fadhiziɛn ‑nu, 'ka bha ka ꞊dhɛ 'mɛ 'wo \"yitakɔɔ ‑nu waa‑ pëbhögütɛa ‑nu ‑bha ‑dhɛ ‑zu 'ö 'wo‑ 'gü ‑dhɛ ‑zë to \"dhʋ̈ ꞊në‑ 'dhö. Ka pa ‑sü 'ka ka dhɔɔbhaa ‑pë ‑nu ‑dhɔ waa‑ ꞊kwaan bho ‑sü ‑nu waa‑ \"gblüyaadhɛ ‑nu ꞊në‑ 'ka kpɛnngkpɛnngdhö. ");
INSERT INTO daf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","꞊Ya kë \"dhʋ̈ kö 'wɔn ‑ma 'koo ‑sü 'aa mü 'ka kë‑ sië bha ‑ee? ‑Gɔgütiimɛ ‑nu 'ka ya! \"Ɛɛn Atanna 'ö pë kwi ‑bha ‑zian ‑da bha 'yii‑ 'gü ‑zian ‑zë ‑da ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","‑Ka 'wɔn ‑nu 'wo ka zuë\" \"piʋ̈ bha ꞊në‑ bho 'mü ꞊kö ‑blɛɛsü kö pë ‑së 'ö go mü bha 'ka‑ ꞊gbaɔ ‑wëëmɛ ‑nu ‑gɔ. 'Ka yö ꞊në‑ kë \"dhʋ̈ kö ka ꞊slɔɔpë ꞊gban \"pɛpɛ ꞊ya kë \"slʋ̈ʋ̈slʋ̈ Atanna 'gü. ");
INSERT INTO daf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","\"Kɛɛ ka ‑bha ‑yö ‑wëësü, Fadhiziɛn ‑nu! ‑A ‑gɛn ‑mü ꞊dhɛ ka kaa‑ tapë ‑nu 'nii‑ bho Atanna ‑dhɛ 'ö 'ka dho 'ka \"tʋʋdhɛ ‑nu ꞊gban ‑zian 'nii‑ bho, \"kɛɛ 'yö 'wɔn 'dhɛ 'kö këwɔn 'ka 'kaa‑ kë; ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑dhɔ ‑bha mɛ kë ‑sü waa‑ dhɔɔbhaawɔn kë ‑sü 'ö‑ ‑dhio dɔ bha, yö ‑zë 'yaa 'dho ka ꞊gbin‑. \"Kɛɛ 'sa kö yö ꞊në këpë 'ka 'nu ‑blɛɛsü, 'yö‑ 'dhɛ 'kö bha 'ö dɔ‑ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ka ‑bha ‑yö ‑wëësü, Fadhiziɛn ‑nu! ‑A ‑gɛn ‑mü ꞊dhɛ ‑yɛa ‑blɛɛsü ‑nu 'wo Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ 'gü ‑dhɛ ‑nu 'gü 'ö ꞊bhlëësü bha ꞊në ‑ya 'gü ‑dhɔ ‑yö ka ‑kë. 'Yö ka \"piʋ̈ ꞊dhɛ 'ka kë mɛ kpö 'gü \"dhɛɛdhɛ ‑nu 'gü, ‑wo ka ꞊në ka ꞊tua bho ꞊bhlëësü 'ka kö ‑yö ziö mɛ ‑kpɛa ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ka ‑bha ‑kë ‑wëësü ‑gɛn ‑mü ꞊dhɛ ka ꞊dhɛ mɛ bun 'ö‑ 'suan‑ ‑bho ‑bha ‑pë 'yaa 'dhö, 'ö mɛ ‑yö ꞊taa‑ ‑ta mɛ tii' 'ka, 'ö‑ bian ‑yö mɛ kun bha ꞊në‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'tɔnggɔmɛ ‑nu 'wo gun mü bha‑ mɛ do ‑ya pö‑ ‑dhɛ 'ö‑ pö: «N Dëmɛ, ‑a 'dhɛ 'kö bha 'bha‑ pö \"dhʋ̈ kö i \"si bho sië mɛ ꞊gban \"pɛpɛ ꞊në yi ‑gɔ bha 'sa ‑wa!» ");
INSERT INTO daf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Tɔnggɔmɛ ‑nu, kaa ‑dɩ 'pö ka ‑bha ‑yö ‑wëësü; ‑a ‑gɛn ‑mü ꞊dhɛ 'tɔng‑ ‑nu 'ka‑ dɔ mɛ ‑nu ‑dhɛ bha ‑yö ‑kë ꞊dhɛ ꞊kwɛɛ‑ 'gbiin‑ 'ö mɛ 'bha 'yaa ꞊mɔɔ‑ ‑bha 'ö 'ka‑ dhu 'ka mɛ ‑nu dɔ‑ 'ka ꞊në‑ 'dhö. Mɛ ‑nu ꞊në 'ka‑ ‑nu ‑ta dɔ‑ 'ka, \"kɛɛ kö ka ‑zë 'kaa \"wɩ‑ ‑bha kö 'ka ka kɔngga ‑zian zun‑ ‑bha kö yöö ‑nu to‑ 'sü ‑wɔn ꞊në‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","A‑ ‑pö ka ‑bha ‑yö ‑wëësü, ‑a ‑gɛn ‑mü ꞊dhɛ bun ‑sɛngbɔ ‑nu ꞊në 'ka Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'ö ka \"bhɛma ‑nu ‑wa zë yi 'bha 'ka bha‑ ‑nu ‑wɔ sië‑ 'gü, \"kɛɛ kö kaa ꞊dede ka‑ 'wɔn ‑dɔ ꞊dhɛ wo ꞊në 'wo‑ ‑nu zë. ");
INSERT INTO daf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","‑A kë 'ka‑ wo \"dhʋ̈ bha ꞊në‑ ‑zɔn ꞊dhɛ kaa‑ ka \"bhɛma ‑nu ka zü ‑yö do, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊dhɛ 'wo‑ ‑nu zë 'yö ka ‑zë 'ka 'kɔ dɔ‑ ‑nu bun ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","'Wɔn 'ö‑ ‑wɔn 'gü 'yö Atanna ‑ya pö ö ‑bha ꞊kpaɔdhɛ ‑bha yi 'bha 'ka ꞊dhɛ: ‹A ‑dho n ‑wʋdhiʋ̈loomɛ ‑nu bɔ‑ ‑nu ‑dhɛ, waa‑ ma bɔmɛ ‑nu 'dhö, 'yö 'wo‑ mɛ 'bha ‑nu zë, 'yö 'wo‑ mɛ ‑kpɛa ‑wëëdhɛ bho› bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","‑A ‑kë \"dhʋ̈ ‑sü 'gü, Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'wo ‑gban ‑a ‑nu zë ‑sü bha \"dhʋ̈ yi 'bha ‑yi 'bha 'ka 'ö nu 'ö zun ꞊dɛɛ ‑bha bha, ‑a \"dhang ‑dho 'mɛ 'ka \"tʋ̈ng ya‑ 'gü bha ꞊në ka 'kun. ");
INSERT INTO daf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","'Ö go Abɛdhö ‑bha 'ö dho 'ö zun‑ 'ka Zakadhi 'wo‑ zë \"saabhodhɛ waa‑ Atanna ‑dhɔkëgükɔ ‑a ‑nu ꞊zinng 'gü bha‑ ‑bha, a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'ka ꞊dɛɛ ‑yën ya‑ 'gü ya ꞊në‑ \"dhang 'dhö ka ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Tɔngdɔmɛ ‑nu, ka ‑bha ‑yö ‑wëësü, ‑a ‑gɛn ‑mü ꞊dhɛ zian 'ö dho Atanna \"piʋ̈ 'ö tɛan‑ ‑zian 'ka bha, 'ka‑ ta mɛ \"bhɩɩ‑ ‑nu ‑gɔ 'ka‑ ‑dhaklɩ ‑da ka ‑ta. Mɛ dha ‑zian bha 'kaa \"wɩ‑ ‑bha kö 'ka ‑da ‑ta, \"kɛɛ 'sa 'ka zun mɛ ‑kpɛa ‑gɔ zian‑, ‑a ‑nu ‑da mü ‑kɔ 'bhaa 'dhö, \"kɛɛ kö ‑a ‑dhɔ ‑ya wo ‑zë ‑a ‑nu ‑bha 'sa.» ");
INSERT INTO daf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","꞊Dhɛ 'ö Yesu ꞊ya ö bo dhiang ‑nu bha‑ ‑nu zë ‑sü 'ka 'ö 'dho sië, 'yö Fadhiziɛn ‑nu waa‑ 'tɔnggɔmɛ ‑nu 'wo wo wë 'gü ‑siö kö ‑wo ꞊nëng sië‑ \"sɔn 'gü 'wo dhɛɛ\" ꞊gban \"pɛpɛ suu 'do 'do kpɔ‑ ‑gɔ ");
INSERT INTO daf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","‑a ‑gɛn mɔɔ‑ kian 'ka, kë \"dhʋ̈ kö 'wo‑ 'kun‑ ‑dɩ \"dhi ‑dhiang ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yö ‑zë 'ö kë sië \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü bha kö mɛ \"bhɩɩ‑ 'ö bho 'ko ‑ta kö ꞊ya kë ‑ziisü. Kö‑ ‑nu pɛng ꞊ya bhɔ 'ko zë ꞊dhɛ ‑bha. 'Mɛ 'wo gun ‑dhɛ bha‑ 'gü ‑wo ‑mɔɔ mɛ \"gblü drun ꞊dede ‑bha. ‑Yö ‑ya ‑dhio dɔ ‑sü ‑bha ö ‑bha ꞊klang ‑nu ‑ta yö ꞊në‑ 'gü 'ö‑ pö: «‑Ka ka ‑dɩ 'kun Fadhiziɛn ‑nu ‑bha ꞊gɔng 'wo‑ ‑da mɛ ‑nu ‑gɔ \"gblʋ̈ʋ̈dhɛ ꞊gblɛɛndhɛ ‑bha bha ꞊në‑ ‑gɔ ('kö 'ka 'dho kë ꞊dhɛ‑ ‑nu 'dhö), ");
INSERT INTO daf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn \"pɛpɛ 'wo ‑bin ‑sü 'ka ‑a 'bha 'yii 'dho 'to ‑bin 'gü kö \"dhɛ 'yii bho‑ ‑ta, \"ɛɛn 'wɔn \"pɛpɛ 'wo‑ ‑kë ‑bin 'gü, ‑a 'bha 'yii 'dho 'to ‑gblɛn 'kpɔ 'gü, ‑a ꞊gban‑ ‑dho ‑wo zang ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Yö 'wɔn 'ö‑ ‑wɔn 'gü 'yö 'wɔn \"pɛpɛ 'ka dho‑ pö ‑dhɛtiidhɛ 'gü, 'yö‑ ꞊gban dho ‑wo \"yɛa‑ ‑dhɛpuudhɛ 'gü, 'yö dhiang ‑nu 'ka dho‑ zë \"waa 'gü ka ‑gɔ 'kɔɔdhɛ ‑nu 'gü bha 'wo‑ ꞊gban pö \"dhɛɛ ‑ta bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","'Mɛ 'ka n \"taɔngdë ‑nu 'ka bha ꞊në 'a dhiang ‑nu bha‑ zë ka ‑dhɛ ꞊dhɛ: \"Suʋ̈ 'ya 'dho ka kë 'mɛ ꞊wa ka zë 'wii 'dho ꞊mɔɔ‑ ‑bha kö ‑wo 'wɔn \"wɛɛ 'bha kë ka 'ka yö ‑zë zian‑ ‑ta bha‑ ‑nu ‑gɔ, ");
INSERT INTO daf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","\"kɛɛ 'mɛ 'ö ‑suʋ̈gɔmɛ 'ka, a ‑dho ‑zɔn ka ‑dhɛ. Atanna 'ö ꞊ya ka zë 'ö ꞊mɔɔ‑ ‑bha 'ö ka 'nii‑ ‑da pɛng ‑kaso 'gü bha ꞊në ‑suʋ̈gɔmɛ 'ka. A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'ö ‑suʋ̈ ‑gɔ ‑mɛ 'ka 'yö bha. ");
INSERT INTO daf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Zöngnë ‑nu ꞊në 'wo ꞊mɔɔ‑ ‑bha 'wo‑ \"sɔɔdhu \"dhɔɔ dɔ ‑suga ꞊plɛ ‑bha, \"kɛɛ 'sa kö ‑a ‑nu ‑bha ‑kë 'sɛɛnnë ‑sü ꞊gban waa‑ ‑bha ‑bha Atanna ‑zʋ 'yaa bhɔ‑ do ‑zian 'ka. ");
INSERT INTO daf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","'Sa ka ‑zë ka ‑gɔdhɛ ‑zian 'ö ka ‑gɔ ‑bha ‑yö dhong‑ ‑sü 'ka 'ö‑ \"dhi 'dhö Atanna \"yaan. A‑ ‑pö yö ꞊në‑ ‑wɔn 'gü ka ‑dhɛ ꞊dhɛ 'ka 'dho \"suʋ̈; ‑a ‑gɛn ‑mü ꞊dhɛ ka ꞊bhlëë ‑yö 'kpii‑ 'ö ‑ziö zöngnë 'gbɛ ꞊dede ‑zian ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","A‑ ‑pö ka ‑dhɛ ꞊dhɛ: Mɛ \"ʋʋ mɛ 'ö dɔ \"dhɛɛ ‑ta 'ö‑ pö ö ‑bɔ n 'ka, mang ‑dɩ 'pö a ‑dho dɔ Atanna ‑bha \"kië ‑nu wëëdhö yi do 'ka 'a‑ pö a ‑bɔ ‑a ‑mɛ 'ka, mang Mɛgbömɛ ma ꞊në 'a‑ pö. ");
INSERT INTO daf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","\"Kɛɛ mɛ \"ʋʋ mɛ 'ö bo n 'ka \"dhɛɛ ‑ta, mang ‑dɩ 'pö a ‑dho bo‑ ‑mɛ 'ka Atanna ‑bha \"kië ‑nu \"yan \"dhiʋ̈ yi do 'ka. ");
INSERT INTO daf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","꞊Ya 'go yö ‑zë 'gü, mɛ \"ʋʋ mɛ 'ö mang Mɛgbömɛ n ‑bhafang bho, Atanna ‑dho ‑a ‑mɛ ‑mawɔn to, \"kɛɛ mɛ \"ʋʋ mɛ 'ö‑ ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑bhafang bho, 'yii 'dho‑ ‑mɛ ‑mawɔn 'to tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","꞊Ya kë ꞊dhɛ ꞊wa ka 'kun kö ‑wo 'dho ka 'ka Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü, \"ɛɛn zadɔmɛ ‑nu ‑kuu \"dhiʋ̈, \"ɛɛn 'zü ‑gɔmɛ \"gblʋ̈gblʋ̈ ‑nu ‑kuu \"dhiʋ̈ (ma ‑zë n ‑wɔn 'gü), 'ka dho ka ‑dɩ ‑ta za dɔ ‑kɔ ‑nu 'ö‑ 'gü, \"ɛɛn dhiang ‑nu 'ka dho‑ zë, ‑a 'bha \"sika 'ya 'dho kë ka 'gü; ");
INSERT INTO daf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ bha ‑yö ‑dho ‑a ‑da ka zuë\" \"piʋ̈ ‑a \"tʋ̈ng ꞊dede bha‑ 'gü 'yö 'pë 'ö pöpë 'ka ‑a dɔ ka \"dhi. ");
INSERT INTO daf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesu ‑yö ‑to ‑a pö \"dhʋ̈ ‑dhɛ 'gü, 'yö mɛ do 'bha ‑yö bɔ mɛ kpö bha‑ 'gü 'ö‑ pö: «N Dëmɛ, ‑bhö ‑a pö n ꞊dhoo ya‑ ‑dhɛ ‑yö kwa dë 'kɛan‑ bha‑ 'gü ‑gblü kö ‑yö n ‑bha nu.» ");
INSERT INTO daf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N \"taɔngdë, de ꞊në n ‑ya ka ‑gɔ \"dhiʋ̈, \"ɛɛn 'ö n ‑ya kaa‑ 'kɛan‑ 'gü ‑gblü ‑mɛ 'ka?» ");
INSERT INTO daf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","'Yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Ka ka ‑dɩ 'kun ‑së ꞊naɔ ‑dhɔ ‑bha ka kë ‑sü yaa 'gü yaa ‑gɔ, 'ka 'dho 'to ‑kplü ‑sü 'ka ꞊naɔ ‑bha; ‑a ‑gɛn ‑mü ꞊dhɛ 'kö 'zü 'mɛ 'bha ꞊naɔ ꞊slɔɔ ‑kɔ \"ʋʋ ‑kɔ 'ö‑ 'gü, \"kɛɛ mɛbhɩɩdhe ‑bha ‑tosɛa kë ‑sü 'yaa ‑gban ꞊naɔ ‑kë mɛ ‑gɔ ‑sü ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Yö \"gwënng do ‑da ‑nu ‑dhɛ 'ö‑ pö: «꞊Naɔmɛ 'kpii‑ do 'bha ꞊në gun yi 'bha 'ka, 'yö 'ke‑ 'kpii‑ ‑kë ‑kwɛ 'bha bha‑ ‑ta, 'yö 'ke‑ ‑yö ‑dhi ‑gɔ ꞊dedewo ‑kwɛ bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tapë ‑dhi ‑gɔ ‑kɔ yaa 'ö ‑kwɛ bha‑ ‑ta bha‑ ‑wɔn 'gü, 'yö ‑ya ö ‑zʋ 'gɔn ‑sü ‑bha 'ö‑ pö: «‑Bhöpë 'ö \"sinma 'dhö ya‑ ꞊loo ‑dhɛ ‑yö 'mɛ? Maa‑ kë ‑kɔ kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Yö ö ‑zʋ gɔn \"sɛnngdhö 'yö‑ pö: «‑ën 'hëëën! 'Pë 'ö maa‑ kë 'ma‑ dɔ. Ma ‑bhöpë ‑loo 'gü ‑kɔ ‑nu 'ö ꞊wa kë 'sɛɛnnë bha ꞊në maa‑ 'wü kö 'a ‑dee dɔ kö 'a ma tapë ‑nu ꞊loo‑ 'gü, waa‑ n ꞊slɔɔpë ‑kpɛa 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","꞊Ya kë ꞊dhɛ 'ma n bo, 'yö 'a‑ pö n ‑dɩ ‑dhɛ ꞊dhɛ: ‑Kwɛ ꞊ya dhi, ‑bhöpë ꞊ya ziö n ‑ta, 'mii 'dho 'ke‑ kë ‑kwɛ kpö 'ka, maa n \"tɛɛ pa kö 'a pë ‑bhö kö 'a pë mü kö 'a n 'flëë‑ bho.» ");
INSERT INTO daf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","\"Kɛɛ 'yö Atanna ‑ya pö‑ ‑dhɛ 'ö‑ pö: «A ‑tamamɛ 'i ya! I ‑dho ga gbeng do 'ö ꞊dɛɛ‑ 'gü kö‑ ꞊naɔ bha 'mɛ 'ö yöö ö 'flëë‑ bho‑ 'gü 'i‑ ‑mɛ pö?» ");
INSERT INTO daf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","꞊Dhɛ 'ö Yesu ꞊ya ö bo \"gwënng bha‑ ‑da ‑sü 'ka, 'yö‑ ‑ta yɔ ‑nu ‑dhɛ 'ö‑ pö: «Mɛ \"ʋʋ mɛ 'ö ꞊naɔ ꞊mɔɔ 'ö‑ drung dɔ ö ‑dɩ ‑dhɛ \"kpʋng ꞊taa yö, 'ö 'yaa ö ‑zʋ 'gɔn 'ö ‑dhɛkpaɔ dhia\" 'ö Atanna wëëdhö ‑a 'ka, ‑a ‑mɛ ‑kë ꞊dhɛ 'mɛ bha ꞊në‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","'Yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «'Pë 'ö‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ: 'Ka 'dho ‑ya kaa‑ ‑tosɛa ‑wɔn zuën ‑ta bha 'yö bha. Ka ‑bhöpë ‑wɔn ‑nu oo, ka ‑dasɔ ‑wɔn ‑nu oo, 'ka 'dho ‑ya ‑a 'bha ‑wɔn zuën ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","‑A ‑gɛn ‑mü ꞊dhɛ mɛ 'nii‑ ‑zë ‑wɔn ‑yö \"gbɩɩ‑ 'ö ‑ziö ‑bhöpë ‑wɔn ‑ta, 'yö mɛ kwi ‑dɩ 'pö‑ ‑wɔn 'dhö \"gbɩɩ‑ 'ö ‑ziö sɔ ‑wɔn ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","‑Ka 'wɔn 'suan‑ bho gɔngdë ‑nu ‑bha! ‑An ‑bha 'bhlaadhɛ ‑yö 'mɛ kö woo‑ ‑mlü \"kan? 'Kɔ ‑zian 'yaa‑ ‑nu ‑gɔ kö yöö 'to‑ ꞊gbaandhɛ kë ‑sü ‑bha. \"Kɛɛ 'sa ‑wo pë ‑bhö yi ꞊gban 'ka 'wo kën. Atanna ꞊në‑ ‑nu \"dhiʋ̈ gba. ‑Ka ‑dhɛ ‑ga, ka ‑zë ka ꞊bhlëë 'ö Atanna ‑gɔ ‑yö ‑ziö ‑maa ‑nu ‑ta. ‑A ‑dhiang ‑zian 'yaa zë. ");
INSERT INTO daf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","\"Ɛɛn mɛ 'bha ‑yö ka kpö 'gü 'ö‑ ‑mɛ ‑bha ‑ya ö ‑dɩ ‑bha ‑tosɛa ‑wɔn zuën ‑ta ‑sü ‑wɔn 'gü, 'ö ꞊mɔɔ‑ ‑bha 'ö ö ‑dɩ ‑bha ꞊sii \"pɛn 'në 'dɛdɛ ‑zian ‑da 'gü ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","'Kii ꞊mɔɔ 'wɔn 'në ‑bhaasü 'kö bha‑ kë ‑sü ‑bha, ka ‑ya 'sa 'wɔn ‑kpɛa 'ö to ‑a ‑nu zuën ‑ta ‑më ‑wɔn 'gü?» ");
INSERT INTO daf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","'Yö‑ pö: «‑Ka \"dhü ‑nu 'wo \"bin ‑ya sië bha‑ ‑nu ‑ga, 'waa yë 'bha kë, 'waa sɔ bɔ, \"kɛɛ sɔ 'wo‑ ‑da wo ‑bha bha a‑ ‑pö ka ‑dhɛ ꞊dhɛ (‑gblüdë) Sadhomɔ 'ö gun ꞊naɔmɛ ‑ziisü 'ka yi 'bha 'ka bha, ‑a ‑bha 'tɔbhɔdhe ꞊gban waa‑ ‑bha ‑bha, 'yii‑ sɔ suu bha‑ ‑da tongtongdhö 'ö to‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yö ꞊në‑ ‑wɔn 'gü 'yö 'a‑ pö 'ka ka ‑zʋ yö Atanna ꞊në‑ ‑dhɛ. Kaa‑ ‑zʋ ‑yö ‑a ‑dhɛ ‑sü ꞊në 'dɛdɛ. 'Yaa yö ‑zë 'ka, \"sanni ‑yö sɔ ‑da \"bü ‑zë ‑bha ꞊dhɛ ‑kɔ bha‑ 'dhö bha ‑oo, 'yö ka ‑zë ꞊wɛ? ");
INSERT INTO daf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ka ‑zë 'ka 'dho ka ‑bhöpë \"ɛɛn ka müpë mɔɔ‑, 'ka 'dho ‑ya ‑zianwo ‑a ‑wɔn zuën ‑ta; ");
INSERT INTO daf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'waa Atanna dɔ ꞊në 'wo pë 'dhɛ ‑nu bha‑ ‑nu ꞊mɔɔ. \"Kɛɛ ka ‑zë, ka Dë bha ‑ya 'wɔn ‑dɔ ꞊dhɛ ka ‑mawɔn ‑ya ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Pë 'ö mɔɔpë 'ka ka ‑zë ka ‑bha 'ka ‑blɛɛsü yö ‑mü ‑a ‑bha ‑gblüdëdhɛ 'ö dhang‑ 'gü bha ꞊në‑ 'ka, 'ka yö ꞊në‑ kë \"dhʋ̈ 'yö pë \"pɛpɛ 'ö ka ‑mawɔn 'dhö‑ ‑bha, 'yö‑ nu ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‑A ‑wɔn 'gü, 'mɛ 'ka bɔ n 'ka 'ö ka kpö 'në 'dhö ꞊dhɛ ‑tuʋ̈ kpö 'dhö ya, \"suʋ̈ 'bha ‑bha 'bha 'ya 'dho ka kë! ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ‑ga ka Dë Atanna ꞊në‑ 'gü 'yö ö ‑bha ‑gblüdëdhɛ bha‑ nu ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","‑Ka ka ꞊slɔɔpë ‑nu 'go kö 'ka‑ sɔng ꞊gbaɔ ‑wëëmɛ ‑nu ‑gɔ kö ꞊naɔ 'ö 'yaa see‑, \"ɛɛn 'ö 'yaa kë zii bha ꞊në 'ka‑ mɔɔ‑, kö 'ka ꞊naɔ 'ö 'yaa yën bha ꞊në‑ ꞊loo 'ko ‑ta dhang‑ 'gü. ‑Dhɛ bha ꞊në ꞊kwaanmɛ 'bha 'yaa 'dho mü \"ɛɛn 'ö ꞊zɛ 'yaa pë see‑ ‑bha tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ ‑dhɛ 'ö mɛ ꞊slɔɔpë 'dhö‑ ‑bha ꞊në mɛ zuë\" 'yaa 'go mü.» ");
INSERT INTO daf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","'Yö go mü 'ö‑ pö: «꞊Ya 'go yö ‑zë 'gü, ka ‑ta ‑yö kë 'kun ‑sü 'ka \"tʋ̈ng ꞊gban \"pɛpɛ 'gü kö kaa‑ ‑dhangbha ‑nu ‑wo kë dɔ ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ka ‑zë ‑ka kë ꞊dhɛ gwëëzë ‑nu 'ö‑ ‑nu Dëmɛ ꞊ya 'dho dhedɔ troo ‑ta ‑dhɛ 'bha 'gü, 'ö 'wo ‑ya sië‑ ‑gɔ kö ꞊ya nu ꞊ya \"kwɛɛ ‑ta ‑ma kö ‑wo 'to ‑wo \"kwɛɛ \"pʋ‑ ‑gɔ ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Gwëë\" 'ö suu 'dhö \"dhʋ̈ 'ö‑ ‑gɔmɛ yaa‑ ‑go \"ta 'gü 'ö dho nu 'ö ‑kpan ‑bha kö ‑yö ‑ya sië ö \"yaan \"dhʋ̈ bha kö‑ ‑bha ‑së. A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ‑yö ‑dho ö ‑ta kun 'ö‑ ‑nu 'yaanu. 'Ö ꞊wa bo 'yaanu ‑sü 'ka 'ö‑ ‑nu \"dhiʋ̈ ‑ziö wo. ");
INSERT INTO daf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yaa‑ ‑nu \"tʋ̈ng \"ʋʋ \"tʋ̈ng 'ö‑ 'gü, ‑yö ‑kë gbeng ꞊zinng 'gü oo, ‑yö ‑kë ‑dhɛkpaɔ \"dhiʋ̈ oo, 'mɛ 'ö dho ‑kpan ‑a ‑nu ‑bha kö ‑wo ‑ya sië wo \"yaan ‑a ‑bha gwëëzë ‑nu bha‑ ‑nu kpö 'gü, kö‑ ‑nu ‑bha ‑së. ");
INSERT INTO daf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","‑Yö kë ka \"yaan ꞊dhɛ ꞊ya kë 'nu ꞊dhɛ 'kɔdë 'ö 'dhö ‑yö \"tʋ̈ng 'ö ꞊kwaanmɛ dho nu‑ 'ka ö ‑gɔ 'kɔɔdhö ‑a ‑dɔ, kö ‑yö ‑dho ‑ya ö \"yaan 'ö 'waa ꞊kwaan bho‑ ‑ta 'ö 'waa‑ ‑bha 'kɔ zua. ");
INSERT INTO daf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","꞊Dhɛ 'ö \"dhʋ̈, kaa ‑dɩ 'pö ‑ka kë baa‑ ‑sü 'ka yi ꞊gban \"pɛpɛ 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ mang Mɛgbömɛ a ‑dho nu \"tʋ̈ng 'ö ka ‑zʋ 'yaa‑ ‑bha ꞊në‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","'Yö Piɛdhö ‑ya pö‑ ‑dhɛ 'ö‑ pö: «N Dëmɛ, \"gwënng 'i‑ ‑da bha i‑ ‑da 'mɛ 'yi ‑kë i ‑bha ꞊klang ‑nu 'ka ya ꞊në yi ‑dhɛ, \"ɛɛn i ‑wɩ mɛ ꞊gban \"pɛpɛ ꞊në yi 'ka bha do ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Gwëëmi ‑towʋtasü 'ö ꞊kpaɔsü \"dhʋ̈ bha yö ‑mü de ꞊në‑ 'ka 'sa? Yö ‑mü 'mɛ 'ö‑ Dëmɛ dho ö ‑bha 'kɔ 'to‑ \"piʋ̈ 'ö ö ‑zʋ ‑kë 'gü, 'ö ‑bhöpë nu‑ dëmɛ ‑bha yëkëmɛ ‑nu ‑dhɛ ‑a nu \"tʋ̈ng ‑bha bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'Mɛ 'ö‑ dëmɛ yaa‑ ‑nu kö ‑ya kë sië \"dhʋ̈ bha kö‑ ‑bha ‑së. ");
INSERT INTO daf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ‑yö ‑dho ‑a ‑ya ö ꞊slɔɔpë ꞊gban \"pɛpɛ ‑gɔ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","\"Kɛɛ ꞊ya kë ‑zë wo ꞊dhɛ ‑a gwëëmi ꞊yaa‑ pö ö ‑dɩ ‑dhɛ ꞊dhɛ: «‑Ee', 'mɛ bha 'yii 'dho nu 'piö‑, ꞊ya ‑ya ö dëmɛ ‑bha yëkëmɛ ‑nu ‑ma ‑sü ‑bha, ꞊ya ‑ya pë ‑bhö ‑sü waa‑ we mü ‑sü ‑bha, kö ‑ya mü kö ‑ya 'kun, ");
INSERT INTO daf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","‑a gwëëmi suu bha‑ dëmɛ ‑dho \"kan‑ 'gü 'ö nu yi 'ö‑ ‑zʋ 'yaa‑ ‑bha waa‑ \"tʋ̈ng 'ö 'yaa‑ dɔ bha ꞊në‑ 'ka. 'Yö ꞊ya nu bha‑ wo \"dhʋ̈ 'yö‑ gwëëmi bha‑ kun 'yö 'wɔn bho‑ 'gü ꞊dedewo, 'yö‑ sü 'yö waa‑ 'wɔnyaakëmɛ ‑nu 'ö 'wii 'to ‑kplü ‑sü 'ka Atanna ‑bha bha‑ ‑nu bɔ ‑dhɛ do 'gü, ");
INSERT INTO daf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Gwëëmi 'ö ö dëmɛ ‑dhidhɛwɔn dɔ \"kɛɛ 'ö 'yaa‑ kë bha‑ dëmɛ ‑dho \"dhü ‑yan 'bha bho‑ 'gü ‑sɔbhɛɛ ꞊dede 'gü. ");
INSERT INTO daf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gwëëmi 'dhɛ 'ö 'yii ö Dëmɛ dhɔɔbhaawɔn dɔ, yö ‑zë ꞊ya mɛ ‑ma 'gü ‑wɔn kë, ‑wo ‑dho ‑a ‑ma ‑zë wo 'pö, \"kɛɛ 'yii 'dho kë ꞊dhɛ mɛ ‑blɛɛsü ‑bha 'dhö; ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'wo pë 'gbɛ nu‑ ‑dhɛ, 'yö 'wo ꞊trɔɔn 'kpii‑ mɔɔ‑ ‑mɛ \"dhiʋ̈ 'pö, 'yö 'wo ꞊nëng‑ \"sɔn 'gü pë 'gbɛ 'wo‑ nu‑ ‑dhɛ bha‑ ‑wɔn 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","'Yö‑ pö: «Nu 'a‑ wo \"kpʋng ꞊taa bha a ‑nu pɛng ꞊në ‑da ‑dhɛ 'gü. ꞊Ya kë ꞊dhɛ ꞊ya ‑dhɛ ‑bhö ‑sü zü bho 'nu n \"yaan ‑yö ‑dho dhi n ‑dhɛ ꞊dedewo! ");
INSERT INTO daf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","\"Kɛɛ 'wɔn \"gbɩɩ‑ 'ö ‑bɔ 'gü ‑wɔn 'dhö ‑tun n ‑bha bha ꞊në‑ ‑zii 'dhö ‑tun n ‑ta 'ö dho 'ö zun‑ 'ka ‑a ‑gɔ ‑da 'plöö ‑yi ‑bha! ");
INSERT INTO daf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","‑Yö ‑kë ka 'gü ꞊dhɛ zuëwaanusü ꞊në 'a nu‑ 'ka \"kpʋng ꞊taa yö ‑ee? A‑ ‑pö ka ‑dhɛ ‑abin! 'Mii nu zuëwaanusü 'ka, a ‑nu ‑kankwëësü ꞊në‑ 'ka \"kpʋng ꞊taa. ");
INSERT INTO daf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","‑A ‑gɛn ‑mü ꞊dhɛ ꞊ya 'go ꞊dɛɛ 'gü, 'mɛ 'wo 'kɔ do 'gü ꞊wa kë \"sɔɔdhu, ‑wo ‑dho \"pɛ 'gü 'ö mɛ ‑yaaga 'wo 'dhang bho n \"dhiʋ̈ 'wo bɔ \"pɛan do \"piʋ̈, 'ö‑ mɛ ꞊plɛ 'ö 'waa 'dhang bho n \"dhiʋ̈ 'wo bɔ 'pö \"pɛan do \"piʋ̈, \"ɛɛn 'zü mɛ ꞊plɛ‑ ‑dho bɔ \"gʋ̈ng 'bha \"piʋ̈, 'ö mɛ ‑yaaga bɔ \"gʋ̈ng 'bha \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","'Nëdë ‑dho ‑siö ö gbö ‑bha, 'ö 'në 'dhö ‑siö ö dë ‑bha. 'Nëdhe ‑dho ꞊sië ö 'dhu ‑bha, 'ö‑ 'dhu ‑dɩ 'pö 'ö ‑siö ö dhe ‑bha. Gɔndhe ‑dho ‑siö ö gbö ‑bha dhebhɔ ‑bha, 'ö‑ gbö ‑bha dhebhɔ ‑dɩ 'pö 'ö ‑siö ö \"na ‑bha (n ‑wɔn 'gü).» ");
INSERT INTO daf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","'Yö‑ pö 'zü mɛ kpö bha‑ ‑nu ‑dhɛ 'ö‑ pö: «'Ka dha 'kpong‑ 'suan‑ bho kö ꞊ya ‑ya dhang‑ ‑bha dha gɛnngdhö, 'yö 'ka‑ pö: «Pë ꞊gban yöö kë, dha ‑dho ban ꞊dɛɛ», 'yö dha bha ö ban 'pö tɛan‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","'Yö 'ka \"tɛɛ yö kö ‑yö 'go sië dha gɛnngdhö 'yö 'ka‑ pö: «'Yënng‑ ‑dho 'bhü ꞊dɛɛ», 'yö kë 'pö \"dhʋ̈ tɛan‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ka 'wɔn ‑nu kö 'wo ‑gban \"sɛ waa‑ dhang‑ ‑nu ‑a ‑nu ‑bha wo ‑zë ‑a ‑nu 'suan‑ ‑bho, 'ö 'ka‑ ‑bhokoo dɔ, ‑yö kë ‑kɔ ‑kë ꞊dhɛ 'sa 'yö 'kaa 'wɔn 'suan‑ ‑bho ‑bha pë ‑nu 'ö Atanna 'dhö‑ kë sië \"tʋ̈ng ya‑ 'gü bha yö ‑zë 'suan‑ bho kö 'ka‑ dɔ, \"gblʋ̈ʋ̈dhɛ ꞊gblɛɛn ‑mɛ ‑nu 'ka ya! ");
INSERT INTO daf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‑Yö kë ‑kɔ kë ꞊dhɛ 'yö 'kaa 'wɔn 'ö ‑së, 'ö pö 'aa‑ ‑bha ‑a ‑bhokoo dɔ? ");
INSERT INTO daf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","A‑ ‑pö ka ‑dhɛ ꞊dhɛ: 'Mɛ 'ö kaa‑ i za dɔ \"yɔɔ 'ka 'dho sië za ꞊gblü \"dhiʋ̈, ‑kaa \"slë mɔɔ‑ kö kaa‑ ‑mɛ 'ka mɔɔ‑ 'gü kö ka ‑tun zian ‑ta, kë \"dhʋ̈ kö i za dɔ \"yɔɔ 'ya 'dho i \"dhiʋ̈ dɔ zadɔmɛ ‑nu ‑gɔ, 'ö woo ‑dɩ 'pö 'wo i \"dhiʋ̈ dɔ \"sɔdha ‑nu ‑gɔ, 'ö 'wo i ‑da ‑kaso 'gü. ");
INSERT INTO daf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A‑ ‑pö i ‑dhɛ \"puu 'ka ꞊dhɛ kö ‑wo bo i ‑da ‑sü ‑zë 'ka ‑kaso 'gü, mɛ ‑nu ‑bha \"pɔ 'ö i ‑bha bha‑ ‑suga ‑zian 'yii dho 'to i ‑bha kö ‑wo i bho ‑kaso bha‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","‑A \"tʋ̈ng do bha‑ 'gü, 'yö mɛ 'bha ‑nu ‑wo nu 'yö 'wo ‑ya 'wɔn 'ö Pidhatö ‑ya ‑kë, 'ö ‑gban mɛ 'bha ‑nu 'wo go Gadhidhe 'wo gun Atanna ‑dhɔkë sië, 'ö Pidhatö ‑ya pö ‑wa ‑nu zë kö ‑wo \"saa‑ bho sië Atanna ‑dhɛ ‑a ‑nu ‑wɔn ‑bha bha‑ ‑gɛn dɔ ‑sü ‑bha Yesu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Yö ka 'gü ꞊dhɛ Gadhidhe ‑mɛ ‑nu 'wo‑ ‑nu ‑wëë ‑kë \"dhiʋ̈ bho \"dhʋ̈ bha ꞊në‑ ‑nu këwɔn 'dhö ya 'ö ‑ziö mɛ ‑kpɛa 'wo to ‑a ‑nu ‑ta ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ ‑abin, \"kɛɛ ꞊ya kë ꞊dhɛ 'kii ka kwaa‑ ka \"ta ‑kɔ yaya ‑nu bha‑ ‑nu ‑zü, kö 'ka ka wë bɔ Atanna \"piʋ̈, ka ‑dho ‑wëëga wo 'pö ꞊dhɛ 'mɛ 'wo bha‑ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","\"Ɛɛn 'zü ‑yö ka 'gü ꞊dhɛ mɛ ‑kaɔng do ga \"saaga 'ö Sidhoe ‑kɔ ‑yö wü‑ ‑nu ‑ta yi 'bha 'ka 'ö‑ ‑nu zë bha wo ꞊në‑ ‑nu \"ta ‑kɔ ‑yö gun 'ya‑ 'ö ‑ziö Zedhizadhɛmö ‑mɛ ꞊gban \"pɛpɛ ‑ta ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ ‑abin! \"Kɛɛ ꞊ya kë ꞊dhɛ 'kii ka kwaa‑ ka \"ta ‑kɔ yaya ‑nu bha‑ ‑nu ‑zü, kö 'ka ka wë bɔ Atanna \"piʋ̈, ka ‑dho ‑wëë ‑ga wo 'pö ꞊dhɛ 'mɛ 'wo bha‑ ‑nu 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","'Yö to 'mü 'ö \"gwënng do 'bha ‑da ‑a ‑nu ‑dhɛ 'ö‑ pö: «Figö ‑dhü do 'bha ‑yö ‑gun gɔndënë do 'bha bha‑ ‑gɔ 'bhlaa. 'Yö yi do 'ka, 'yö 'bhlaadhɛ dëmɛ bha 'ö nu kö 'ö \"dhü bha‑ bhɛ bho, 'yö 'yii pë 'bha yö mü. ");
INSERT INTO daf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'Yö‑ pö 'bhlaadhɛ bha‑ ‑yëkëmɛ ‑nu ‑dhɛ 'ö‑ pö: «'A ‑gban nu sü ‑bha \"dhü do ya‑ bhɛ bho ‑dhɛ 'gü ‑a ‑kwɛ ‑yaaga ‑naa ꞊nɛ, \"kɛɛ 'mii‑ bhɛ yö‑ 'gü do. ꞊Dhɛ 'ö \"dhʋ̈, ‑bhö ‑a \"kan; ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ta ‑gɛn 'yaa 'dhö, ‑yö ‑dɔ ‑duɛ bha‑ 'gü \"wɛɛwɛɛ, ‑a ꞊trɔɔn 'bhaa 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","'Yö‑ figö ‑dhɛ ‑yëkëmɛ bha 'ö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N Dëmɛ, ‑bhö ‑a 'to \"dhʋ̈ kö ‑kwɛ do ya ‑yö ziö, a ‑dho ‑a \"piʋ̈ 'pɔn 'a \"sɛ ‑së ꞊loo‑ ‑gɛn \"piʋ̈ kö kwa‑ ‑bha ‑ga ‑kwɛ dhia\" 'ka. ");
INSERT INTO daf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'Bha mü \"dhʋ̈ ‑yö ‑dho bhɛ kë ꞊wɛ. ꞊Ya kë 'zü ꞊dhɛ 'yii \"wɩ‑ ‑bha kö ‑yö ö bhɛ kë yö ‑zë 'gü, kö‑ \"kan ‑wɔn ꞊në dho 'to‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yi do 'ka, Yesu ‑gun dhiang zë sië mɛ ‑nu ‑dhɛ 'ö‑ ‑nu ꞊klang ‑kë 'wɔn ‑nu 'wo ‑gban Atanna ‑bha ‑a 'ka Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ do 'bha 'gü. ");
INSERT INTO daf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","'Mɛ 'ö gun dhiang zë sië‑ ‑nu ‑dhɛ \"dhʋ̈ bha, dhebhɔ do 'bha ‑yö ‑gun ‑nu kpö 'gü 'ö dhang‑ ‑yua ‑yö gun‑ ‑bha. \"Yua 'ö \"dhʋ̈ bha \"yina yaa ‑nu 'wo gun dhebhɔ 'bha‑ 'gü ꞊në 'wo‑ ‑da 'gü. ‑A \"tʋ̈ng bha‑ 'gü kö‑ ‑kwɛ ꞊ya kë ‑kaɔng do ga \"saaga kö dhebhɔ bha 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö \"wlü kö ‑yö dɔ ö ‑gɛan tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","꞊Dhɛ 'ö Yesu ꞊ya yö 'yö‑ pö‑ ‑dhɛ: «Dhebhɔ, i ꞊niɔɔdhɛ 'ö i ‑bha bha ꞊ya bo ꞊dɛɛ, 'bha kë \"klʋ̈ʋ̈klʋ̈!» ");
INSERT INTO daf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","'Yö ö ‑kɔ ‑ya dhebhɔ bha‑ ‑ta. ‑Yö ‑to ‑dhɛ do bha‑ 'gü, 'ö ꞊wlü 'ö dɔ ö ‑gɛan, 'yö zun Atanna 'tɔ bhɔ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","\"Kɛɛ ꞊dhɛ 'ö ꞊ya kë \"dhʋ̈, 'wɔn bha 'yii dhi ‑yakwëëkëgükɔ bha‑ ‑gɔdhiʋ̈mɛ ‑dhɛ, 'yö zun ‑dɔn bho ‑sü ‑bha 'mɛ 'wo gun mü bha‑ ‑nu 'ka 'ö‑ pö: «‑Dhɛkpaɔyi 'ö Atanna ‑ya ‑ya kö ‑wo yë kë‑ 'ka ‑yö \"saɔdo, ‑a \"saɔplɛ ‑naa ‑zë ꞊glooyi ‑mü. 'Ka‑ pö 'ka nu ka ‑kë \"klʋ̈ʋ̈klʋ̈ ‑dhɛ mɔɔ‑ ‑dhɛ 'gü, ‑ka nu yi \"wɛɛ ‑nu bha‑ ‑nu 'ka, 'ya 'dho kë ꞊glooyi ‑zë 'ka!» ");
INSERT INTO daf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «A gblɛɛn\" ‑gɔn mɛ ‑nu 'ka ‑mɛ ‑nu 'ka ya! Kaa‑ ‑du ‑nu waa‑ kaa‑ ꞊soofëng ‑nu ꞊wa kë ‑kplü ‑sü 'ka 'kaa‑ ‑nu \"pʋ ꞊glooyi 'ka 'waa 'dho \"yi mü ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","\"Ɛɛn 'yaa ka 'gü ꞊dhɛ dhebhɔ 'ö Sɔtraan ꞊yaa‑ ‑kplü 'ö‑ ‑kwɛ ‑kaɔng do ga \"saaga ‑naa 'dhö ya bha, Ablaamö bhang do 'bha ‑mü 'pö ‑ee? ‑Më ꞊në ‑kë 'yö 'waa‑ dha ꞊glooyi 'ka?» ");
INSERT INTO daf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","\"Tʋ̈ng 'ö Yesu gun‑ pö sië‑ 'ka \"dhʋ̈ bha kö‑ 'yaɔ‑ ‑nu bha‑ ‑nu ꞊gban wë ꞊ya lɔɔ‑ dee\" wo \"pɛɛpɛdhö, \"kɛɛ kö mɛ kpö kö 'wo bha‑ ‑nu ꞊nii ꞊në ‑da sië Atanna 'tɔ bhɔ ‑wɔn ‑nu 'ö‑ kë sië bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","'Yö go mü 'zü 'ö \"gwënng do 'bha ‑da 'ö‑ pö: «Atanna ‑bha ‑gblüdëdhɛ bha ‑yö ‑bhɔ ‑më ꞊në‑ ‑bha, \"ɛɛn ‑a ‑zɔn 'ka ‑mü ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","‑A suu‑ ‑kë ꞊dhɛ tapë 'wo‑ seneve ‑kë bha‑ ga 'ö gɔndënë do ‑ya ta ö ‑gɔ \"dhü ‑bhlaa 'gü ꞊në‑ 'dhö. (Pë 'ö bha mɛ‑ mɛ \"yan \"nuu ꞊në‑ dɔ‑ ga ‑ta.) \"Kɛɛ ꞊dhɛ 'ö gɔndënë bha ꞊yaa‑ ta, 'ö ꞊ya bhɔ, 'yö ꞊kpɛa, 'yö ꞊kpɛa, 'yö 'dho ö ‑kë \"dhü 'kpii‑ 'ka, 'yö ‑maa ‑nu 'wo go dhang‑ 'gü 'wo nu 'wo 'kɔ dɔ‑ kwɛɛ\" 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","'Yö go mü 'zü 'ö‑ pö: «Atanna ‑bha ‑gblüdëdhɛ bha a ‑mɔɔ ‑bha 'zü 'a‑ ‑zɔn ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A ‑mɔɔ ‑bha 'a‑ ‑zɔn \"sɛkɛ 'ö dhebhɔ do ‑ya sü 'ö‑ ‑da 'bluu‑ ‑bi \"kidhʋng ‑kaɔng ꞊plɛ ga \"sɔɔdhu ‑bha, 'ö ꞊ya kë \"dhʋ̈ 'ö ö ‑yagüpë pa 'ö ꞊wɛnng ‑zü bha ꞊në‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ‑gun 'dho sië 'pö‑ \"gblʋ̈gblʋ̈ ‑nu waa‑ 'pö‑ 'sɛɛnnë ‑nu 'gü mɛ ‑nu ꞊klang kë ‑sü 'ka kö ‑yö 'dho sië Zedhizadhɛmö. ");
INSERT INTO daf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yi do 'ka, 'yö mɛ do 'bha ‑ya dhɛɛ\" kpɔ 'ö‑ pö: «N Dëmɛ, 'mɛ 'wo dho dha ‑wo ‑dho kë 'gbɛ \"wɛ ‑ee?» 'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«‑Ka ka 'gü dɔ \"gbɩɩ‑ kö 'ka ka ziö ‑dhɛ yö (kö 'ka bɔ Atanna \"piʋ̈), 'yaa yö ‑zë 'ka a‑ ‑pö ka ‑dhɛ ꞊dhɛ ‑yö ‑dho kë mɛ 'gbɛ \"piʋ̈ ꞊dhɛ 'wo bɔ‑ 'ka, \"kɛɛ 'wii 'dho ꞊mɔɔ‑ ‑bha; ‑a ‑gɛn ‑mü ꞊dhɛ ‑kë Atanna ‑bha 'ka ‑dhɛ ‑yö 'ya‑. ‑A ‑dhɛ ‑yö ꞊dhɛ ‑da 'kɔ 'ö‑ \"dhi 'dhö \"sɔɔsɔɔ ‑a 'gü ‑sü 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","\"Kɛɛ ꞊ya kë ‑zë wo ꞊dhɛ kö 'kɔdë ‑yö \"wlü kö ‑yö 'dho ‑yö \"kwɛɛ ta, kö ka ‑zë 'kii ‑da 'kɔɔdhö ꞊kö, kö 'ka bɔ \"kpɛnng 'ka \"kwɛɛ ‑ta ‑ma 'ka‑ pö: «N Dëmɛ, n Dëmɛ, ‑bhö \"kwɛɛ \"pʋ yi ‑gɔ! ‑Yö ‑dho bɔ 'kɔɔdhö 'ö‑ pö ka ‑dhɛ: «'Maa ka 'godhɛ dɔ.» ");
INSERT INTO daf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","꞊Ya bo kë ‑sü 'ka \"dhʋ̈, ka ‑dho bɔ \"kpɛnng yö ꞊në‑ 'gü 'ka‑ pö: «I‑ pö ‑zë ‑wo ꞊dhɛ 'bhaa yi 'godhɛ dɔ, \"kɛɛ kwɛng‑ ‑nu kwa kë ‑kɔ ‑da pëfië do 'gü kwa \"kwëë, 'ö ‑ya mü 'zü 'i dhiang ‑nu zë 'i bɔ‑ 'ka yii‑ 'pö‑ ‑nu 'gü, ‑kpinng ‑ta ‑dhɛ ‑nu 'gü ‑wa! ");
INSERT INTO daf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","'Yö‑ ‑yɔ bɔ ka ‑gɔ 'ö‑ pö: «‑Ka bhɔ n 'ka taa‑ ꞊gblɛɛn, 'wɔnyaakëmɛ ‑nu! 'Maa mɛ 'bha ka 'godhɛ dɔ; ‑a ‑gɛn ‑mü ꞊dhɛ ka ‑to kaa‑ 'wɔn yaa kë ‑sü ꞊në‑ ‑bha 'ö‑ 'wɔn‑ yën. ");
INSERT INTO daf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","\"Gbʋ‑ ‑dho \"wɩ ‑dhɛ bha ꞊në‑ 'gü, 'ö 'wo wo \"sɔn \"dhiʋ̈ ‑bhö klöklödhö, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a \"tʋ̈ng bha‑ 'gü kö 'ka ka \"yan ‑kpan Ablaamö oo, Izaakö waa‑ Zakɔbö ‑nu ‑bha, waa‑ Atanna ‑wʋdhiʋ̈loomɛ ‑nu ꞊gban \"pɛpɛ 'dhö ‑a ‑bha ‑gblüdëdhɛ bha‑ 'gü, \"kɛɛ kö ka ‑zë ꞊wa ka ‑zuö \"kpɛnngdhö. ");
INSERT INTO daf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mɛ‑ ‑dho 'go 'yënng‑ ‑wo ‑zian 'ka, 'ö go 'yënng‑ ‑pö ‑zian 'ka, 'ö go mɛ ‑kɔ ‑së 'gü, 'ö go mɛ ꞊kwaa 'gü, 'ö 'wo wo ‑kɔ ‑da 'tɛa‑ do 'gü Atanna ‑bha ‑gblüdëdhɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","‑A yi 'ö bha‑ 'ka, ꞊taama ‑gɛn 'bha ‑nu ‑dho bɔ \"dhiʋ̈, 'ö \"dhiʋ̈ ‑gɛn 'bha ‑nu 'wo bɔ ꞊taama.» ");
INSERT INTO daf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","‑A yi do bha‑ 'ka, 'yö Fadhiziɛn ‑nu 'bha ‑nu 'wo nu 'wo‑ pö‑ ‑dhɛ: «‑Bhö ziö kö 'i 'dho, ‑bhö 'go ‑dhɛ ya‑ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ Edhodö ‑ya ‑dhɛ mɔɔ‑ sië kö 'ö i zë.» ");
INSERT INTO daf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","'Yö‑ ‑yɔ bɔ 'ö‑ pö: «‑Ka 'dho kö 'ka‑ pö \"gblʋ̈ʋ̈dhɛtiimɛ bha‑ ‑dhɛ ꞊dhɛ a ‑tun kö \"yina yaa ‑nu kë mɛ \"bhɩɩ‑ 'gü ‑dhɛ ya‑ 'gü, 'ö 'a \"yuëdhi ‑nu dha ꞊dɛɛ waa‑ dhia\" ‑nu 'gü 'yö 'a‑ ‑gɔ ‑da 'plöö dhia\" ꞊taama, 'yö 'a gun ‑na 'dho‑. ");
INSERT INTO daf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","‑A ‑gɛn ‑mü ꞊dhɛ 'kö 'zü 'ö ‑ya \"yan \"ʋʋ \"yan 'ö‑ ‑ta, \"kɛɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'a \"ta bha‑ 'sü \"dhʋ̈ ꞊dɛɛ waa‑ dhia\" 'gü kö 'a 'dho 'a ‑da 'ka Zedhizadhɛmö ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa 'ka, ‑a pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ ‑a ‑dhɛ 'yaa ‑bha ꞊dhɛ 'mɛ 'ö ‑kë Atanna ‑wʋdhiʋ̈loomɛ 'ka ‑wa zë ‑dhɛ \"wɛɛ 'bha 'gü kö 'yii kë Zedhizadhɛmö ‑dhɛ ‑zë 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ‑ya \"gbʋ bɔ ‑sü ‑bha Zedhizadhɛmö ‑dhɛ ‑bha 'ö‑ pö: «Zedhizadhɛmö ‑mɛ ‑nu, Zedhizadhɛmö ‑mɛ ‑nu, ka 'kö kaa‑ yë 'dhö ‑mü Atanna ‑wʋdhiʋ̈loomɛ zë ‑sü 'ka, 'ö 'mɛ 'wo‑ ‑nu bɔ ka ‑dhɛ kö ‑wo 'pa ka ‑bha 'ka ‑gwë ‑zuö ‑nu 'ka‑ ‑nu zë‑ 'ka bha, ‑yö ‑gun n \"piʋ̈ ꞊dhɛ 'a‑ \"slë mɔɔ‑ ‑kɔ ꞊gban ‑kɔ ꞊gban 'gü kö 'a ka ꞊loo 'ko ‑ta n gban ꞊wlöö ꞊dhɛ ‑kɔ 'ö ‑tɔdhee \"buɛdhe ‑yö ö 'në ‑nu ‑kë 'ka ‑a 'dhö, \"kɛɛ 'kii‑ ‑yɔ bɔ n ‑gɔ! ");
INSERT INTO daf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yö ꞊në‑ ‑wɔn 'gü, 'yö 'a dho n kwaa‑ ka ‑wɔn ‑zü, \"kɛɛ a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ka \"yan 'yii 'dho ‑kpan n ‑kpong 'gü ‑dhɛ ‑bha 'zü 'ö dho 'ö zun‑ 'ka yi 'ka dho‑ pö‑ 'ka ꞊dhɛ: «'Mɛ 'ö nu kwa Dëmɛ 'tɔ 'gü bha, Atanna ‑bha 'dhuë‑ ‑ya ‑mɛ 'kun!» bha‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yi do 'ka 'yö Fadhiziɛn ‑nu ‑gɔmɛ do 'bha ‑yö Yesu ‑dhɛ ö ‑gɔ 'kɔɔdhö kö 'wo pë ‑bhö. ‑Yö ‑kë \"dhʋ̈ Zuifö ‑nu ‑bha ꞊glooyi do 'ka. 'Yö dho 'yö ‑da 'kɔɔdhö. Yaa\" kë 'wo wo sië bha Fadhiziɛn ‑nu ‑kpɛa 'wo to ‑wo Yesu 'suan‑ ꞊në‑ bho sië. ");
INSERT INTO daf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'Wo dho ‑dhɛ ‑ga kö mɛ do 'bha 'ö ‑bhla ‑yua 'dhö‑ 'gü ‑yö dɔ sië‑ wëëdhö. ");
INSERT INTO daf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","'Yö 'tɔnggɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu 'wo gun mü bha‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «'Wɔn 'ö ‑gban \"yuëdhi ‑nu dha ‑sü ‑bha ꞊glooyi 'ka bha kwa ‑bha 'tɔng‑ ‑ya ‑pö ꞊dhɛ ‑a ‑wɔn 'gü? 'Kwa‑ kë ‑ee \"ɛɛn 'kwa 'dho‑ ‑kë ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Yö ‑dhɛa ‑yö ga‑ ‑nu ‑ta, 'yö 'wo dɔ dingdhö. ‑Yö ‑to 'gü 'yö Yesu ‑yö ö ‑kɔ pa \"yuëdhi bha‑ 'ka 'yö‑ dha, 'yö‑ pö‑ ‑dhɛ ‑yö 'dho. ");
INSERT INTO daf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","꞊Dhɛ 'ö ꞊ya bo ‑wʋ ‑kpɔ 'mɛ 'ö‑ ‑kë \"klʋ̈ʋ̈klʋ̈ bha‑ ‑bha ‑sü 'ka, 'yö‑ pö 'mɛ 'wo to‑ ‑nu ‑dhɛ 'ö‑ pö: «'Mɛ 'ka bha de ‑mü 'ka ka kpö 'gü 'yö‑ ‑bha 'në \"ɛɛn ‑a ‑bha ‑du ꞊ya ‑da ‑klɔng 'gü ꞊glooyi 'ka, 'yö 'yii 'dho 'to 'ö‑ bho mü? ");
INSERT INTO daf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","‑An dhɛɛ\" 'ö‑ kpɔ \"dhʋ̈ bha, ‑a ‑yɔ 'yii ꞊slɔɔ‑ ‑nu ‑gɔ kö ‑wa bɔ. ");
INSERT INTO daf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö \"gwënng do ‑da 'mɛ 'wo‑ ‑nu ‑dhɛ ‑dhɔkëdhe ‑ta 'wo gun ‑yɛa ‑blɛɛsü kɔɔ‑ sië bha‑ ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«꞊Wa 'mɛ i ‑dhɛ ‑dhɔkëdhe ‑ta, ꞊dhɛ dhe dɔ ‑dhɛ ‑nu 'dhö, 'bha 'dho ‑yɛa ‑blɛɛsü mɔɔ‑, ‑a ‑gɛn ‑mü ꞊dhɛ 'kö 'mɛ 'wo ka ‑dhɛ bha‑ mɛ 'bha‑ mü 'ö‑ ꞊bhlëë 'dhö 'kpii‑ 'ö ‑ziö i ‑bha ‑ta 'bhaa‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kë \"dhʋ̈ kö 'mɛ 'ö ka ‑dhɛ bha 'ya 'dho nu 'ö‑ pö i ‑dhɛ: ‹‑Bhö 'go ‑yɛa 'dhɛ bha‑ 'gü kö 'mɛ 'ö ya ‑yö ‑ya mü›. ꞊Ya kë \"dhʋ̈ kö ꞊ya kë kpaɔ 'ka ꞊ya \"pɛ i ‑bha. Kö i ‑bha ‑go ‑yɛa 'dhɛ bha‑ 'gü ‑sü kö 'i 'dho ‑ya ꞊taama bha‑ 'yiʋ̈‑ yöö i kë. ");
INSERT INTO daf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","\"Kɛɛ 'mɛ 'ö ꞊wa i ‑dhɛ ‑dhɔkëdhe ‑ta, ‑bhö 'dho kö 'i ‑ya ‑yɛa ‑totaamasü ꞊në‑ 'gü, kë \"dhʋ̈ kö 'mɛ 'ö ka ‑dhɛ bha ꞊ya nu kö ‑ya pö i ‑dhɛ: «N \"taɔngdë, ‑bhö bɔ \"dhiʋ̈!» ꞊Ya kë \"dhʋ̈, i ‑gɛngbɔ ‑dho kë \"gblʋ̈gblʋ̈ mɛ \"pɛpɛ 'wo ‑dhɔkëdhe ‑ta mü bha‑ ‑nu ꞊gban 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","'Yö‑ pö: «‑A pö 'a‑ wo ka ‑dhɛ \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'mɛ 'i dho i ‑dɩ 'sü ‑kiandhö i \"tɛabɔ ‑nu ‑bha, Atanna ‑dho i ‑da ‑a ‑nu ꞊wlöö, \"kɛɛ 'mɛ 'i dho i ‑dɩ ‑da i \"tɛabɔ ‑nu ꞊wlöö, ‑yö ‑dho i gba ‑duɛ 'kpii‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","꞊Dhɛ 'ö ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö‑ pö 'mɛ 'ö‑ ‑dhɛ 'ö wɛng‑ ‑nu 'wo gun‑ ‑gɔ 'kɔɔdhö bha‑ ‑dhɛ 'ö‑ pö: «N \"taɔngdë, ꞊ya kë ꞊dhɛ 'bha‑ pö 'i mɛ ‑nu ‑dhɔkë, \"ɛɛn 'bha‑ pö 'i ‑dhɔkëdhe kë, 'bha 'dho i \"taɔngdë ‑nu oo, i dheebhang ‑nu oo, i 'kɛ‑ ‑nu \"ɛɛn i ‑yayɔɔ ‑nu 'wo ꞊naɔmɛ 'ka ‑a ‑nu ‑dhɛ ‑dhɔkëdhe ‑ta, kë \"dhʋ̈ kö 'wa 'dho i ‑dhɛ 'pö 'ö 'wo 'wɔn 'i‑ ‑kë bha‑ ‑gɔyɔɔ dɔ i ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","\"Kɛɛ 'bha‑ pö bhii ‑dhɔkëdhe kë, ‑bhö ‑wëëmɛ ‑nu waa‑ ꞊niɔɔmɛ ‑nu, \"ta ‑sü 'bebedhö ‑mɛ ‑nu waa‑ \"yanwlümɛ ‑nu ꞊në‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Bha‑ kë \"dhʋ̈, i zuë\" ꞊nii ‑dho ‑da, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'wo bha 'waa ꞊mɔɔ‑ ‑bha kö ‑wa ‑gɔyɔɔ dɔ i ‑dhɛ, ꞊ya 'go mü 'zü, Atanna ‑dho ‑a ‑gɔyɔɔ dɔ i ‑dhɛ, 'mɛ 'wo 'dhang bho‑ \"dhiʋ̈ ‑a ‑nu ‑bö ‑yi 'ka. ");
INSERT INTO daf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","꞊Dhɛ 'ö 'mɛ 'ö wɛng‑ ‑nu ‑a ‑nu ‑kɔ ‑yö gun 'tɛa‑ do 'gü bha 'wo 'wɔn bha‑ ma, 'yö‑ mɛ do ‑ya pö Yesu ‑dhɛ: «꞊Ya kë \"dhʋ̈ yö ‑zë 'gü 'sa kö 'mɛ 'ö dho pë ‑bhö Atanna ‑bha ‑gblüdëdhɛkëdhɛ 'gü kö‑ ‑mɛ ‑bha ‑së \"dhɛ!» ");
INSERT INTO daf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Bhö ‑dhɛ ‑ga zɔɔ, yi do 'ka 'yö mɛ do 'bha ‑yö ‑dhɔkëdhe 'kpii‑ do ‑kë, 'yö mɛ 'gbɛ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","꞊Dhɛ 'ö pë ‑bhö \"tʋ̈ng ꞊ya ꞊loo, 'yö ö ‑bha gwëëmi do bɔ 'mɛ 'ö‑ ‑nu ‑dhɛ bha‑ ‑nu ‑dhɛ ‑dhɛ 'gü 'yö‑ pö ‑wo nu, ‑bhöpë ꞊ya ma. ");
INSERT INTO daf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","\"Kɛɛ 'yö 'mɛ 'wo bha‑ ‑nu ꞊gban \"pɛpɛ 'wo ‑kɔ 'dho ‑sü ‑bha. 'Yö mɛ ‑blɛɛsü ‑ya pö: «N ‑kpladhɛ ‑yö n ‑bha, 'bhlaadhɛ do 'bha 'a‑ dhɔ ya, ‑a ‑dhɛa ‑bha ꞊dhɛ 'a 'dho kö 'a ‑wo mü, ꞊dhɛ 'ö \"dhʋ̈ ‑yö n ‑mawɔn 'to.» ");
INSERT INTO daf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","'Yö‑ mɛ do 'bha ‑ya pö: «Mang ‑dɩ 'pö, ‑du ‑kaɔng do 'a‑ dhɔ ya, ‑yö n \"piʋ̈ ꞊dhɛ 'a dho kö 'a‑ ‑nu draan‑ yë kë ‑sü ‑bha. 'Bha 'dho ‑bhö ‑a pö i dëmɛ ‑dhɛ 'mii 'dho nu.» ");
INSERT INTO daf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","'Yö‑ mɛ ‑yaaga ‑naa ‑ya pö: «A ‑go dhe 'sü ‑dhɛ 'gü ‑dee 'gü, 'wɔn 'ö‑ ‑wɔn 'gü 'mii 'dho nu 'pö 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","'Yö‑ ‑bha gwëëmi bha 'ö ö yee kë 'ö nu 'ö ‑ziö 'wɔn bha‑ ꞊gban ‑gɛn 'gü \"pɛɛpɛdhö ö dëmɛ ‑dhɛ, 'yö 'wɔn bha 'ö ‑siö 'mɛ 'ö ꞊dhiɔ kë bha‑ ‑dhɛ. 'Yö ‑wʋ ‑dee 'bha kpɔ gwëëmi bha‑ ‑bha 'ö‑ pö: «‑Bhö 'dho ‑bɛang 'ka \"dhɛɛdhɛ waa‑ zian ‑gbeng ‑ta ‑dhɛ ‑nu 'gü kö 'i ‑wëëmɛ ‑nu, ꞊niɔɔmɛ ‑nu, \"yanwlümɛ ‑nu waa‑ \"ta ‑sü 'bebedhö ‑mɛ ‑nu ‑dhɛ kö 'ka nu.» 'Yö 'mɛ bha 'ö dho 'yö nu, ");
INSERT INTO daf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","'yö‑ pö ö ‑gɔmɛ ‑dhɛ: «N dëmɛ, ‑kɔ 'i‑ pö 'a‑ kë‑ ‑bha bha 'ma‑ kë‑ ‑bha, \"kɛɛ ‑yɛa 'bha ꞊ya 'to.» ");
INSERT INTO daf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'Yö‑ ‑gɔmɛ ‑ya pö‑ ‑dhɛ: «‑Bhö 'dho zian ‑gɔ ‑ta ‑dhɛ ‑nu waa‑ \"yasa \"piʋ̈ ‑dhɛ ‑nu 'gü kö 'i ꞊dhiɔ kë, mɛ \"ʋʋ mɛ 'i dho ‑kpan ‑bha, ‑bhö ‑fɛɛ ‑ya ‑bha kö ‑yö nu kö ‑yö ‑da 'kɔɔdhö kö 'kɔ ‑yö pa; ");
INSERT INTO daf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‑a ‑gɛn ‑mü ꞊dhɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mɛ 'a‑ ‑nu ‑dhɛ ‑a ‑nu ꞊bhlëë ‑bha bha‑ mɛ do ‑zian 'yii dho 'pë 'wo‑ ‑kpa bha‑ din ‑zian ‑ga.» ");
INSERT INTO daf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yi do 'ka kö mɛ ꞊ya ta Yesu ‑bha kö ‑wo 'dho sië zian ‑ta ‑yɛɛdhö, 'yö ꞊slëë ö 'gü 'yö‑ pö 'mɛ 'wo bha‑ ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«'Mɛ 'ka nu sië bha mɛ \"ʋʋ mɛ 'ö‑ pö 'ö bɔ n 'ka, \"kɛɛ 'ö‑ ‑mɛ ‑yö ö dë oo, ö dhe oo, ö ‑bha dhebhɔ oo, ö ‑bha 'në ‑nu oo, ö dheebhang gɔɔn‑ ‑nu \"ɛɛn dhong ‑nu \"ɛɛn ‑a ‑mɛ ‑dɩ ‑bha ‑tosɛa ꞊dede ‑zian fië bho n ‑bha, kö ma ꞊klangdhiʋ̈ 'yaa ‑mü. ");
INSERT INTO daf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","\"Ɛɛn 'zü 'mɛ 'yii \"wɩ‑ ‑bha kö ‑yö saan\" n ‑wɔn 'gü, kö 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö kë ma ꞊klangdhiʋ̈ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","'Yö‑ pö: «‑A pö 'a‑ wo ka ‑dhɛ \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ mɛ 'bha 'yaa 'dhö ka kpö 'gü bha kö ‑ya pö ꞊dhɛ yö ‑zë 'ya‑ pö 'ö 'kɔ dɔ, 'yaa 'yaanu kö ‑yö ö ‑zʋ 'gɔn 'pë 'ö dho ꞊mɔɔ 'kɔ bha‑ dɔ ‑sü ‑bha kö ‑yö bo‑ ‑wɔn ‑ta, ");
INSERT INTO daf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","kë \"dhʋ̈ kö 'ya 'dho ö bo 'kɔkpan ‑ya ‑sü 'ka 'ö 'wëë‑ ‑yö kɔn, 'ö ꞊fië‑ 'kɔ dɔ ‑sü ‑bha 'ö mɛ 'wo \"yan ‑kpan bha kö ‑yö 'kɔ bha‑ dɔ sië bha 'wo ꞊wɛɛ dɔ ‑bha 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","«'Mɛ 'ö ya, ‑yö ‑gun 'kɔ dɔ sië \"kɛɛ ꞊ya ꞊fië‑ ‑bha ‑wa! ");
INSERT INTO daf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","\"Ɛɛn 'zü ‑gblüdë ‑mɛɛ ‑mü, 'yö ꞊yaa‑ pö 'ö 'dho ‑gblü bha, \"kɛɛ kö mɛ \"gblü ‑kaɔng do ꞊në‑ ‑gɔ, 'yö 'yaa 'yaanu 'yaa ö ‑zʋ 'gɔn \"ni 'ö‑ faan dho ꞊mɔɔ 'mɛ 'ö nu sië‑ ‑gɔ mɛ \"gblü ‑kaɔng ꞊plɛ 'ka bha‑ ‑bha ‑sü ‑wɔn 'gü, 'yö 'yaa gun ‑na 'dho‑? ");
INSERT INTO daf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","‑A ‑mɛ ꞊yaa‑ yö ꞊në‑ kë \"dhʋ̈, 'yö ꞊ya kë ꞊dhɛ 'yii 'dho ꞊mɔɔ‑ ‑bha, 'yö ‑gblüdë 'dhɛ bha‑ to ꞊gblɛɛn, 'yö mɛ bɔ‑ ‑dhɛ 'yö‑ pö: «‑Gblü 'yaa n \"piʋ̈». ");
INSERT INTO daf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yö ꞊në‑ ‑wɔn 'gü, 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ 'ö mɛ \"ʋʋ mɛ 'ö‑ 'ka 'ö ka kpö 'gü 'ö 'yii ö kwaa‑ pë \"pɛpɛ 'ö‑ ‑gɔ ‑a ꞊gban ‑zü, kö ‑yö ziö n ꞊keng‑, ‑a ‑mɛ 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö kë ma ꞊klangdhiʋ̈ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","'Yö‑ pö: «꞊Wee 'ö bha pë ‑së ‑mü, \"ɛɛn 'yaa \"dhʋ̈ ‑ee? \"Kɛɛ ꞊ya kë ꞊dhɛ ꞊wee din ꞊ya 'go‑ ‑bha kö \"slë \"wɛɛ 'bha 'kö 'wo dho‑ kë ꞊taamasü 'gü kö‑ din ‑yö dhi 'yaa 'dhö 'zü. ");
INSERT INTO daf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kö ꞊ya kë pë see‑ ‑sü ꞊në‑ 'ka bha, kö‑ ꞊trɔɔn 'yaa 'dhö 'zü \"sɛ waa‑ \"dung ‑zian 'bha ‑bha. Kö ꞊ya 'to ‑zuö \"kpɛnng ‑pë ꞊në‑ 'ka.» 'Yö‑ pö: «'Ma‑ pö \"dhʋ̈, 'wɔn ma ‑tʋ 'dhö 'mɛ 'ö‑ ‑gɔ ‑bha ‑ya 'gü ma!» ");
INSERT INTO daf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","‑A \"tʋ̈ng bha‑ 'gü, 'niisɔngkunmɛ ‑nu waa‑ 'wɔnyaakëmɛ \"wɛɛdhe ‑nu ‑gun nu sië Yesu ‑dhɛ 'gü kö 'wo \"tʋ 'to‑ ‑wʋ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Yö Fadhiziɛn ‑nu waa‑ 'tɔnggɔmɛ ‑nu 'wo ‑ya Yesu ꞊tɔɔ kë ‑sü ‑bha \"waa 'gü 'wo‑ pö: «Mɛ 'kö ya yö ‑zë waa‑ 'mɛ 'ö‑ ‑nu \"ta ‑kɔ 'yaa ‑së bha ꞊në 'wo ꞊nëng 'kwëë‑. Wɛng‑ ‑nu ‑wo pë ‑zian ‑bhö wo \"kwëë.» ");
INSERT INTO daf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'Yö Yesu ‑yö \"gwënng do ‑da ‑nu ‑dhɛ ‑a ‑wɔn 'gü 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«De ‑mü ka kpö 'gü 'yö \"bhlaa këng do ꞊ya kë‑ ‑gɔ, 'yö‑ do ꞊ya ꞊dhɛng 'yö 'yaa‑ ‑kaɔng \"sueisiö waa‑ \"bhlaa \"sueisiö 'ö to bha‑ 'to \"tʋng ‑ta, 'yö 'yaa 'dho‑ do ö ꞊dhɛng bha‑ mɔɔ‑ ‑dhɛ 'gü, 'yö 'yaa 'to‑ mɔɔ‑ ‑dhɛ 'gü 'yaa 'dho 'yaa zun‑ 'ka ‑a yö ‑sü ‑bha? ");
INSERT INTO daf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A‑ ‑pö ka ‑dhɛ ꞊dhɛ: ꞊Ya kë ꞊dhɛ‑ ‑mɛ ꞊yaa‑ yö, ‑a ꞊nii ‑yö ‑da 'ö‑ sü 'ö‑ ‑wɔ ö gbaandhö, ");
INSERT INTO daf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","'ö nu‑ 'ka \"kwɛandhö 'ö ö \"tɛabɔ ‑nu waa‑ ö ‑yayɔɔ ‑nu ‑dhɛ 'ö‑ pö‑ ‑nu ‑dhɛ: «‑Ka nu kö 'kwa ma \"tan kë n ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ ma \"bhlaa 'ö ꞊dhɛng bha 'ma‑ yö!» ");
INSERT INTO daf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ‑Kɔ do bha ꞊në ꞊niidadhe ‑yö kë‑ 'ka dhang‑ 'gü kö 'wɔnyaakëmɛ doseng ‑zian ꞊ya bɔ Atanna 'ka \"kpʋng ꞊taa 'ö ‑ziö 'ka mɛ ‑kaɔng \"sueisiö ga \"sueisiö 'ö pö 'aa‑ ‑nu ‑bha ‑a ‑nu ‑dɩ 'gü, 'ö‑ ‑nu ‑mawɔn 'yaa ‑bɔ Atanna 'ka ‑wɔn ‑bha 'zü ‑a ‑nu ‑wɔn ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","'Yö go mü 'zü 'ö‑ pö: «Kö 'wëë‑ \"puu ga ‑kaɔng do ‑yö kë dhebhɔ do ‑gɔ, kö‑ ga do ‑yö ꞊dhɛng, ‑yö ‑dho ‑dhangbha dɔ 'ö ‑pia sü 'ö‑ ‑ziö 'kɔ \"piʋ̈ ‑dhɛ ꞊gban \"pɛpɛ 'gü, \"fɔn kö ꞊yaa‑ yö. \"Ɛɛn 'yaa kë \"dhʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","꞊Ya ö bo‑ yö ‑sü 'ka, 'yö ö \"tɛabɔ ‑nu waa‑ ö ‑yayɔɔ ‑nu ‑dhɛ 'yö‑ pö: «‑Ka nu 'kwa ma troo kë n ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ ma 'wëë‑ \"puu ga 'a kë‑ ꞊dhɛng bha 'ma‑ yö!» ");
INSERT INTO daf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ ꞊dhɛ: Kö 'wɔnyaakëmɛ do ‑yö bɔ Atanna 'ka, ‑a ꞊niidadhe ‑yö ‑kë ‑a ‑bha \"kië ‑nu kpö 'gü dhang‑ 'gü ‑kɔ do bha ꞊në‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","'Yö ‑ya mü 'zü 'ö \"gwënng do 'bha ‑da 'ö‑ pö: «Gɔndënë do 'bha ꞊në gun, 'yö 'nëgɔɔn ꞊plɛ ‑yö gun‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'Yö‑ mɛ \"bhlëngsü ‑ya pö ö dë ‑dhɛ yi do 'ka 'ö‑ pö: «N dë, i 'kɛan‑ 'ö dho 'to yi ‑gɔ dhia\" bha, ‑bhö ‑a 'gü ‑gblü kö 'i n ‑bha nu.» 'Yö‑ dë ‑yö ö 'kɛan‑ 'gü ‑gblü ‑a ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","꞊Dhɛ 'ö mɛ \"bhlëngsü bha 'ö ö ‑kɔ ‑da ö ‑bha ꞊naɔ bha‑ 'gü, 'yö ‑dhɛkpaɔyi 'në 'bha ‑kë, 'yö ꞊wlü 'ö dho \"sɛ ꞊gblɛɛn 'bha 'gü, 'yö ‑ya 'nëglɔɔndhɛ kë ‑sü ‑bha ꞊naɔ bha‑ 'gü, 'yö ‑ya ‑a 'gü see‑ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","꞊Dhɛ 'ö ꞊ya ö bo‑ ꞊gban 'gü see‑ ‑sü 'ka \"pɛɛpɛdhö, 'yö \"vʋ̈ʋ̈ ‑yö ‑da \"sɛ bha‑ 'gü, 'yö ‑kpla ‑yö zun‑ 'kun ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","'Yö dho 'yö ‑da yë 'gü \"sɛ bha‑ 'gü mi do \"piʋ̈, 'yö 'mɛ bha 'ö‑ bɔ ö ‑gɔ ‑bhɔ ‑kluu 'gü kö ‑yö ‑ya ‑a ‑nu ‑gɔ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","\"Tʋ̈ng 'ö gun‑ 'ka ‑bhɔ ‑gɔ \"dhiʋ̈ bha, ‑bhɔ ‑nu ‑bhöpë 'wo‑ nu‑ ‑nu ‑dhɛ bha‑ 'bha ‑bhö ‑dhɔ ‑gun ‑bha; ‑a ‑gɛn ‑mü ꞊dhɛ kö ‑bhöpë 'bhaa‑ ‑gɔ, (kö din‑ ‑ya kë sië), \"kɛɛ 'waa gun‑ ‑bha nu sië. ");
INSERT INTO daf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yi do 'ka 'yö 'yaanu 'ö ö ‑zʋ gɔn \"fluudhö 'yö‑ pö: «Din‑ ‑yö n ‑zë ‑më ‑wɔn ‑zë 'gü kö 'mɛ 'wo yë 'gü n dë ‑gɔ ‑wo 'gbɛ, \"kɛɛ kö ‑wo pë ‑bhö 'wo ꞊fië‑ ‑kpɛa ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","A ‑dho \"wlü 'a dho n dë \"piʋ̈, 'ö 'a‑ pö n dë ‑dhɛ: «N dë, ‑bhö n 'to, 'ma ‑da Atanna \"dhiʋ̈, 'ma ‑da i \"dhiʋ̈, ");
INSERT INTO daf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","‑a ‑dhɛ 'yaa ‑bha ‑zianwo 'zü ꞊dhɛ ‑wo i 'tɔ pö n ‑bha ꞊dhɛ i gbö ‑mü n 'ka, \"kɛɛ 'kö 'zü 'i n 'sü ‑zianwo ꞊dhɛ i ‑bha yëkëmɛ do 'dhö kö 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","꞊Dhɛ 'ö 'në bha 'ö ö ‑zʋ gɔn \"dhʋ̈, 'yö ꞊wlü 'ö dho ö dë \"piʋ̈. ꞊Dhɛ 'ö‑ dë ‑ya yö kö ‑yö nu sië, 'yö dho dɔ‑ ‑gɔ zian‑ ‑dhɛ ꞊gblɛɛn 'gü, 'yö ‑wëë ‑yö bɔ‑ ‑ta ꞊dedewo, 'yö ‑bɛang sü 'ö dho ö gbö bha‑ \"dhiʋ̈ ‑gɔ 'yö dho 'yö ꞊loo‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'Yö‑ gbö ‑ya pö‑ ‑dhɛ: «N dë, 'ma nu, \"kɛɛ nu 'a‑ wo bha a‑ ‑dɔ ꞊dhɛ 'ma ‑da Atanna \"dhiʋ̈, 'ma ‑da i \"dhiʋ̈, ‑a ‑dhɛ 'yaa ‑bha 'zü ꞊dhɛ ‑wo i 'tɔ ‑zian pö n ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","\"Kɛɛ 'yö‑ dë ‑ya pö ö ‑bha gwëëzë ‑nu ‑dhɛ 'ö‑ pö: «‑Ka 'dho \"vaandhö kö 'ka nu ma ꞊gbauu‑ ga ‑sësü ꞊dede 'ö 'kɔɔdhö bha‑ 'ka kö 'ka‑ ‑da n gbö ya‑ ‑bha, kö 'ka kɔnggaapë ‑ya ‑kɔ ‑bha (kö ‑ya ‑zɔn ꞊dhɛ ‑kɔ do 'ö gun‑ ‑bha n ‑gɔ ‑blɛɛsü bha ꞊ya kë 'zü‑ ‑bha ‑deewo), kö 'ka ‑slu ‑ya ‑gɛn ‑bha! ");
INSERT INTO daf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","‑Ka 'dho kö 'ka nu ‑du \"gbɔng 'ö 'kwa‑ \"dhiʋ̈ gba 'ö ꞊ya \"yɔn kë bha‑ 'ka kö 'ka‑ zë kö 'kwa pë ‑bhö kö 'kwa troo kë! ");
INSERT INTO daf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‑A ‑gɛn ‑mü ꞊dhɛ n gbö 'ka‑ ‑ga sië 'ö dɔ bha, ꞊ya gun ꞊ya kë ꞊dhɛ 'mɛ ꞊ya ga ꞊në‑ 'dhö, n gbö 'ö ꞊ya bhɔ ‑deewo ö dɔ bha ꞊ya gun ꞊ya ꞊dhɛng 'nu n ‑gɔ, \"kɛɛ 'yö 'ma‑ yö bha!» 'Yö 'wo ‑ya troo kë ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","\"Kɛɛ kë 'wo‑ wo sië \"dhʋ̈ bha kö ‑a gbö 'kpiisü ‑zë ‑yö 'bhlaa. ꞊Dhɛ 'ö ꞊ya nu ꞊ya ꞊loo \"kwɛandhɛ \"sɔɔ, 'yö‑ \"tʋ ‑yö ‑da \"wɩpë ‑nu waa‑ troo ‑nu ‑wʋ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'Yö ö dë ‑bha gwëë\" ‑nu bha‑ mɛ do ‑dhɛ 'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «'Kwa‑ ma \"kwɛandhö?» ");
INSERT INTO daf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Yö gwëëmi bha 'ö‑ pö‑ ‑dhɛ: «I dheebhang 'ö kë dho \"sɛ \"piʋ̈ bha ꞊në ꞊ya ö yee kë ꞊ya nu, 'yö i dë ꞊ya ‑du zë‑ ‑dhɛ, nu 'ö‑ wo kö ‑a \"klʋ̈ʋ̈klʋ̈ ‑sü ‑yö ‑kpan ‑bha bha‑ ‑wɔn 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","‑A ma 'ö‑ wo \"dhʋ̈ bha 'yö ‑siö ‑dhɛ, 'yö ‑zʋʋ ‑kë 'ö‑ pö 'yii 'dho 'dho \"kwɛandhö. ‑A dë‑ ‑zun \"kpɛnng ‑gɛn ꞊nɛ, 'yö ꞊bhɛa‑ ‑dhɛ kö 'wo 'dho 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","\"Kɛɛ 'yö‑ pö ö dë ‑dhɛ 'ö‑ pö: «Ma ‑zë 'a zun yë ‑kë i ‑dhɛ ‑sü ‑bha \"dhʋ̈ 'yi bha‑ 'ka, yö ꞊në‑ ꞊dɛɛ 'dhö 'dhö, 'mii i ‑wʋ bho‑ \"piʋ̈ do, \"kɛɛ 'bhii ‑bhʋ 'në ‑zian nu n ‑dhɛ do kö yaa‑ n \"tɛabɔ ‑nu 'yi‑ ‑bhö kö 'yi troo kë‑ ‑ta, ");
INSERT INTO daf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","\"Kɛɛ i gbö 'kö yö ‑zë 'ö i ‑bha ꞊naɔ sü 'ö dho‑ 'ka \"sɛ \"piʋ̈, 'ö‑ ꞊gban 'gü see‑ ‑zuadhe ‑nu ‑bha bha, yö ‑zë 'ö nu 'bha ‑du 'kwa gun‑ \"dhiʋ̈ gba sië bha‑ zë‑ ‑dhɛ ‑kɛɛ!» ");
INSERT INTO daf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","'Yö‑ dë ‑ya pö‑ ‑dhɛ 'ö‑ pö: «Gɔnnë, bhi ‑zë kwɛng ko 'ko \"piʋ̈ yi ꞊gban 'ka, pë \"pɛpɛ 'ö n ‑gɔ ya i ‑bha ‑mü, ");
INSERT INTO daf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","\"kɛɛ bhii ꞊dede ‑bhö ‑a ‑ga bha, i 'zlaa‑ 'ö dɔ ya, ꞊ya gun ꞊ya kë ꞊dhɛ 'mɛ ꞊ya ga‑ 'dhö, 'yö ꞊ya ‑bö 'ö dɔ bha, ꞊ya gun ꞊ya kë ꞊dhɛ 'mɛ ꞊ya ꞊dhɛng ‑a 'dhö, 'yö 'ma‑ yö ö dɔ bha. (‑A ‑kë \"dhʋ̈ ‑sü 'gü, ‑a ‑dhɛ ‑gun ‑bha ꞊dhɛ i 'zlaa‑ 'ö nu bha, 'kwa‑ 'gü ‑troo kë kö 'kwa kwa \"dhia bho).» ");
INSERT INTO daf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö go mü 'zü 'yö \"gwënng ‑dee 'bha ‑da ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «Gɔndënë do 'bha ‑yö ‑gun, 'ö ꞊naɔ gun‑ ‑gɔ. 'Yö‑ ‑bha ꞊naɔ bha‑ ‑gɔdhiʋ̈mɛ ‑yö gun. Yi do 'ka 'yö 'wo nu 'wo‑ pö ꞊naɔmɛ bha‑ ‑dhɛ ꞊dhɛ ‑a ‑bha ꞊naɔ ‑gɔdhiʋ̈mɛ bha ‑ya ‑bha ꞊naɔ bha‑ 'gü ꞊në‑ see‑ sië. ");
INSERT INTO daf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","'Yö gɔndë bha 'ö ö ‑bha ꞊naɔ ‑gɔdhiʋ̈mɛ bha‑ ‑dhɛ 'ö‑ pö‑ ‑dhɛ: «‑Wʋ ‑nu 'a‑ ma sië i ‑bha ya‑ 'bha 'yaa n ‑zʋ 'kun. ꞊Dhɛ 'ö \"dhʋ̈, ‑bhö nu kö 'i ma ꞊naɔ bha‑ \"kplëng bho n ‑dhɛ; ‑a ‑gɛn ‑mü ꞊dhɛ 'yaa n \"piʋ̈ ꞊dhɛ 'i ‑ya ‑gɔ \"dhiʋ̈ 'zü.» ");
INSERT INTO daf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","'Yö 'mɛ 'bha 'ö zun ö ‑zʋ 'gɔn ‑sü ‑bha 'ö‑ pö: «N dëmɛ ‑ya pö 'ö‑ wo yöö ö ‑bha ꞊naɔ ꞊gban 'sü n ‑gɔ ya, a ‑dho ‑a kë mü ꞊dhɛ, \"kɛɛ kö 'ke‑ kë \"sɩ 'yaa n ‑dhɛ, kö ‑gbadhɛsü ‑yö n 'gü 'pö 'yiʋ̈sü ya?» ");
INSERT INTO daf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Yö‑ pö: «'Kwa‑ ma, 'pë maa kë kö mɛ ‑nu ‑wo n gba ‑yɛa 'ka wo ‑gɔ 'kɔɔdhö kö ꞊wa n kë yë bha‑ 'gü 'ma‑ dɔ.» ");
INSERT INTO daf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","'Yö ö dëmɛ ‑bha \"pɔ 'dhö 'mɛ 'ö‑ ‑nu ‑bha bha‑ ‑nu ‑dhɛ, 'yö‑ pö mɛ ‑blɛɛsü ‑dhɛ: «N dëmɛ ‑bha 'wëë‑ ꞊dhɛ 'pö i ‑bha?» ");
INSERT INTO daf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Yö‑ pö: «‑A ‑bha \"yɔn \"gbʋnggbʋ këng do ꞊në n ‑gɔ.» 'Yö‑ pö‑ ‑dhɛ: «‑Bhö 'yaanu kö 'i i ‑dɩ ‑bha \"pɔ 'sëëdhɛ bha‑ ‑bɛn zë kö 'i ‑ya 'gü ꞊dhɛ \"yɔn \"gbʋnggbʋ ‑kaɔng \"sɔɔdhu ꞊në i ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","'Yö go mü 'ö‑ pö mɛ do 'bha ‑dhɛ 'ö‑ pö: «'Yö bhi ‑zë ꞊wɛ?» 'Yö‑ ‑yɔ bɔ 'pö‑ ‑gɔ 'ö‑ pö: «‑A ‑bha ‑mlüga 'tɛa‑ ‑yan këng do ꞊në n ‑gɔ.» 'Yö‑ pö‑ ‑dhɛ: «‑Bhö i ‑bha \"pɔ 'sëëdhɛ 'sü 'pö kö 'i ‑kaɔng \"saaga ‑bɛn zë‑ ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","꞊Dhɛ 'ö ꞊naɔmɛ bha 'ö‑ ma ꞊dhɛ ö ‑kɔdhiʋ̈mɛ ꞊flüsü bha ꞊yaa‑ kë \"dhʋ̈, 'yö \"dhɛ ‑ya ‑ta 'ö‑ pö ‑yö ‑dɔ 'wɔn kë ‑dhɛ 'ka. ꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «‑A pö 'a‑ wo ka ‑dhɛ \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'mɛ 'waa Atanna dɔ 'wo ꞊dɛɛ ‑yën ya‑ 'gü ya, ‑wo woo‑ 'wɔn ‑nu ‑zun 'ko \"dhiʋ̈ kë ‑kɔ ‑dɔ wo 'ko ꞊zinng 'gü 'ö ‑ziö 'ka 'mɛ 'wo Atanna dɔ ‑a ‑nu ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","'Ö go mü 'yö‑ pö 'zü ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «‑A ‑kë \"dhʋ̈ ‑sü 'gü, mang ‑dɩ 'pö a‑ ‑pö ka ‑dhɛ ꞊dhɛ: \"Dhang ‑naɔ 'ö \"kpʋng ꞊taa yö bha, 'ka \"taɔngdëdhɛ 'kun‑ 'ka mɛ ‑nu ‑bha. ꞊Ya kë \"dhʋ̈, ‑a ꞊naɔ 'ö ka ‑gɔ bha ꞊ya yën yi 'ö‑ 'ka Atanna ‑dho ö ‑kɔ 'kpɔ ka ‑gɔ ‑a ‑bha ꞊sii 'ö 'yaa yën bha‑ këdhɛ 'gü, ");
INSERT INTO daf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","'sa 'mɛ 'ö 'wlɔɔdhɛ ‑kë 'wɔn 'sɛɛnnë ‑nu 'gü, kö ‑yö ‑dho ‑a kë 'wɔn 'kpii‑ 'gü 'pö, \"kɛɛ mɛ 'ö 'yaa 'wlɔɔdhɛ kë 'wɔn 'sɛɛnnë 'gü, kö‑ ‑mɛ 'yii dho‑ kë 'wɔn 'kpii‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","‑A ‑kë \"dhʋ̈ ‑sü 'gü, ꞊ya kë ꞊dhɛ 'wii ka 'wlɔɔdhɛ yö ꞊flü ‑naɔ 'ö \"kpʋng ꞊taa yö bha‑ ‑wɔn 'gü, 'dee dho ꞊mɔɔ‑ ‑bha 'ö ꞊naɔ ‑së 'ö Atanna \"piʋ̈ bha‑ ‑kɛfama bho ka ‑bha? ");
INSERT INTO daf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","꞊Ya kë 'zü ꞊dhɛ mɛ ‑nu ‑bha pë 'wo‑ ‑duɛ bho ka \"piʋ̈ bha 'kii‑ 'kun ‑së, Atanna ‑dho ‑a 'dhɛ ka ‑bha 'ka ‑a nu ka ‑dhɛ ‑kɔ ‑kë ꞊dhɛ? ");
INSERT INTO daf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‑Yö kë ka \"yaan ꞊dhɛ: Mɛ do 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö yë kë mɛ ꞊plɛ \"piʋ̈. ꞊Ya kë \"dhʋ̈, ꞊ya kë ‑kɔ \"ʋʋ ‑kɔ 'ö‑ 'gü mɛ do ‑san ‑dho ‑a kë 'ö mɛ do ‑dhɔ ‑ya ‑kë. \"Ɛɛn 'zü ‑yö ‑dho ‑kplü mɛ do ‑bha, 'ö‑ mɛ do to. Kaa ‑dɩ 'pö 'kii 'dho ꞊mɔɔ‑ ‑bha kö 'ka kë Atanna ‑bha mɛ 'ka kö 'ka ‑ya mü 'zü 'ka kë ꞊naɔ ‑gɔ ꞊dhuëngdhɛ 'gü ‑kɔ do bha ꞊në‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Dhiang ‑nu 'ö Yesu gun‑ zë sië \"dhʋ̈ bha kö Fadhiziɛn ‑nu \"tʋ ‑ya ‑bha. \"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ ꞊naɔ ‑dhɔ ‑ya ‑nu kë \"gbɩɩ‑ bha, ‑wo ‑gun ꞊wɛɛ ꞊në‑ dɔ sië‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","‑Ya ‑pö ‑nu ‑dhɛ yö ꞊në‑ ‑wɔn 'gü 'ö‑ pö: «Fadhiziɛn ‑nu, ka ‑zë ‑kɔ 'ka dho‑ kë‑ 'ka kö 'ka bhɔ mɛ ‑nu 'gü Atanna dhɔɔbhaawɔn kë ‑mɛ ‑bha ꞊në 'ka‑ ‑dhɛ ꞊mɔɔ, \"kɛɛ 'sa kö yö ‑zë ‑yö ‑dhɛ yö ka zuë\" \"piʋ̈. 'Pë 'ö mɛ \"bhɩɩ‑ ‑nu ‑zë ‑a ‑nu 'gü pë ‑së 'ka bha ꞊në yö ‑zë 'gü pë ‑yënngsü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","꞊Ya 'go mü ‑a ‑bha 'tɔng‑ ‑nu 'ö Moizö ‑ya ‑bɛn zë yi 'bha 'ka bha waa‑ ‑wʋdhiʋ̈loomɛ ‑nu ‑a ‑nu ‑bha \"tʋ̈ng ꞊në gun ‑blɛɛsü kö Zan 'yii bhɔ ꞊kö. (Kë \"dhʋ̈ kö ‑yö Atanna ‑dhidhɛwɔn kë ‑kɔ ‑gleng ‑da Izraɛdhö ‑mɛ ‑nu ‑bha), \"kɛɛ 'ö go Zan bhɔ ‑sü ‑bha 'ö nu 'ö zun‑ 'ka ꞊dɛɛ bha, ꞊naɔ ‑së 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑bha ꞊në 'yi‑ pö sië. Mɛ ꞊gban ‑wo wo 'gü dɔ sië \"gbɩɩ‑ yö ꞊në‑ ‑wɔn 'gü 'yö 'wo ‑kplakpla zë sië kö 'wo ‑da mü bha. ");
INSERT INTO daf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","\"Kɛɛ yö ꞊në‑ ꞊gban 'gü, dhang‑ waa‑ \"sɛ ‑a ‑nu ziö ‑sü ‑dho kë ‑bhaasü Atanna ‑bha 'tɔng‑ bha‑ ꞊blünga ‑zian ‑go ‑bha ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","‑A ‑kë \"dhʋ̈ ‑sü 'gü, mɛ \"ʋʋ mɛ 'ö‑ dhe bho \"bü 'ö‑ ‑dee sü kö ‑yö ‑da ꞊në‑ wo mɛ ‑nu ‑bha \"piʋ̈ bha. 'Sa kö mɛ \"ʋʋ mɛ 'ö ‑yö dhe 'ö ꞊wa wo bo‑ 'ka ‑a 'sü, kö‑ ‑mɛ ‑yö ‑da ꞊në wo sië mɛ ‑nu ‑bha dhe \"piʋ̈ bha.» ");
INSERT INTO daf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «꞊Naɔmɛ 'kpii‑ 'bha ꞊në gun, sɔ ‑nu 'wo gun‑ ‑gɔ, \"yi 'yaa zun‑ 'bha ‑bha. ‑Yö ‑gun sɔga \"kpɛakpɛa ‑dɩ ‑slɔɔ 'ö ‑ma 'yaa wo‑ sɔng ‑bha bha ꞊në‑ ‑da sië. 'Yö ‑dhɛ \"puu 'ö ꞊kpaɔ, 'yö ö \"dhia bho 'yö pë ‑sɛsɛngbɔ ‑nu ‑bhö. ");
INSERT INTO daf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","‑Wëëmɛ 'bha ‑yö gun mü 'pö 'wo‑ gun ‑dhɛ sië Dhazaa. Bhiëë ‑yö ‑gun ‑bha ‑dhɛ ꞊gban \"pɛpɛ 'gü, 'yö gun nu sië ‑kpɛawo 'ö ‑wɔ ꞊naɔmɛ bha‑ ‑gɔ 'kɔ \"dhiëngdhö. ");
INSERT INTO daf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kë \"dhʋ̈ kö 'mɛ bha 'ö 'pë 'ö‑ ‑bhö sië kö‑ ꞊blünblün 'në ‑nu 'wo ꞊wɛnng bha ‑wa nu ö ‑dhɛ kö 'ö‑ ‑bhö. Kö 'gbɛn‑ ‑nu ‑wo nu sië 'wo bhiëë 'ö‑ kwi ‑bha bha‑ ‑ma pa ‑nu wo. ");
INSERT INTO daf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yi do 'ka 'yö ‑wëëmɛ bha 'ö ga, 'yö Atanna ‑bha \"kië ‑nu ‑wa sü 'wo dho‑ 'ka ‑dhɛ ‑së 'ö Ablaamö \"sɔɔ bha‑ 'gü. 'Yö ꞊naɔmɛ bha yöö ‑dɩ 'pö 'ö dho 'ö ga. 'Yö 'wo dho 'wo‑ ‑wɛɛ bho. ");
INSERT INTO daf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo ꞊geebɔɔ 'pö, 'ö ‑wëëdhɛ yö sië mü ꞊dedewo, 'ö dho ö \"yan \"dhiʋ̈ \"wlü kö ‑yö ‑dhɛ ‑ga, kö Ablaamö ‑yö dɔ sië ‑dhɛ 'bha 'gü 'tiii mü, \"kɛɛ kö Dhazaa ‑ya \"piʋ̈ mü. ");
INSERT INTO daf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","'Yö ö ‑wʋ \"dhiʋ̈ ꞊wlü \"gbɩɩ‑ 'ka 'ö‑ pö: «N dë Ablaamö, ‑bhö dɔ \"gbɩɩ‑ kö 'i n ‑wëë ‑ga kö 'i Dhazaa bɔ kö ‑yö ö kɔngga \"zɔ \"yɛ \"yi ‑bha kö ‑yö nu‑ 'ka ‑ya zun n 'nɛɛ‑ ꞊taa kö ‑yö ꞊dhië ‑dhe! Saan\" ‑yö 'ma sië n ‑bha pɛng ya‑ 'gü \"gbɩɩ‑ ‑wa!» ");
INSERT INTO daf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","'Yö Ablaamö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Gɔnnë n gbö, ‑a 'wɔn kë i \"yaan ꞊dhɛ ‑tosɛa ‑së ‑zë ‑a 'bha ꞊në 'i gun‑ kë sië \"kpʋng ꞊taa bha. ‑A \"tʋ̈ng bha‑ 'gü kö Dhazaa ‑dɩ 'pö ‑yö saan\" 'gü, \"kɛɛ 'yö dɔ 'kwa‑ wo ya yö ‑zë ꞊nii 'dhö ‑da sië ‑dhɛ ya‑ 'gü 'yö bhi ‑zë 'i ‑wëëdhɛ yö sië bha. ");
INSERT INTO daf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","\"Kɛɛ yö ꞊në‑ ꞊gban 'gü ‑zianwo, ꞊zinng ‑yö kwa ꞊zinng 'gü, ꞊gblüga do 'bha ‑yö kwa ꞊zinng 'gü bha‑ ‑kë ꞊gblɛɛn ‑kɔ 'yaa ‑së. Kë \"dhʋ̈ kö mɛ ꞊yaa‑ pö 'ö 'go yi \"pɛan \"piʋ̈ kö 'ö bɔ ka \"pɛan \"piʋ̈, \"ɛɛn kö ‑yö 'go ka \"pɛan \"piʋ̈ ‑yö bɔ ‑dhɛ ya‑ 'gü, kö 'ya 'dho ꞊mɔɔ‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","'Yö ꞊naɔmɛ bha 'ö‑ pö: «‑Bhö dɔ \"gbɩɩ‑ 'sa, n dë Ablaamö, bhɛa\" ꞊në 'a‑ wo i ‑dhɛ kö 'i Dhazaa bɔ n dë ‑gɔ 'kɔdhi 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ n dheebhang ‑nu \"sɔɔdhu ‑wo mü. ");
INSERT INTO daf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kö ‑yö 'dho ‑yö 'wɔn ‑nu ya‑ ‑nu ‑gɛn dɔ‑ ‑nu ‑dhɛ kö wo ‑zë ‑wo Atanna ‑wʋ ‑ya ꞊bhlëë 'gü kö 'wa 'dho nu ‑wëëdhɛyödhɛ ya‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","'Yö Ablaamö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Atanna ‑wʋ 'sëëdhɛ 'ö Moizö ‑ya ‑bɛn zë bha ‑yö mü, ‑a 'dhɛ 'ö‑ ‑wʋdhiʋ̈loomɛ ‑nu ‑wa ‑bɛn zë 'pö bha ‑yö mü, ‑wo ‑dho ‑a ‑wʋ pö‑ ‑nu ‑dhɛ, ‑wo wo \"tʋ 'to‑ ‑bha!» ");
INSERT INTO daf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","'Yö ꞊naɔmɛ bha 'ö‑ pö Ablaamö ‑dhɛ: «(꞊Iin, ‑yö \"dhʋ̈ tɛan‑ 'ka n dë Ablaamö,) \"kɛɛ 'mɛ 'kö 'wo bha wo ‑zë ‑a ‑nu ‑wʋ ꞊në 'yii 'dho ꞊mɔɔ‑ ‑nu ‑bha. \"Kɛɛ ꞊ya kë ꞊dhɛ mɛ ꞊ya 'go ꞊geebɔɔ kö ‑yö 'dho ‑a ‑nu \"piʋ̈, ‑wo ‑dho wo bo wo kë ‑sɔng ‑nu 'ka yö ‑zë 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","'Yö Ablaamö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'wii wo \"tʋ to 'sëëdhɛ 'ö Moizö waa‑ Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'wo‑ ‑bɛn zë bha yö ‑zë ‑wʋ ‑bha, 'kö mɛ \"yaandhe ‑zian yöö 'go ꞊geebɔɔ kö ‑yö 'dho, 'yii 'dho bhɔ‑ ‑nu 'gü tɛan‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑yö go mü 'zü 'ö dhiang zë ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: ꞊Ya kë ‑kɔ \"ʋʋ ‑kɔ 'ö 'gü, 'wɔn‑ ‑dho ‑da ‑nu wo mɛ \"bhɩɩ‑ ‑nu ‑gɛn 'gü 'ö 'wo ‑da Atanna \"dhiʋ̈, \"kɛɛ 'mɛ 'kö yaa‑ ‑kë 'wɔn ‑nu bha‑ ‑nu ‑da mɛ ‑gɛn 'gü ‑mɛ 'ka bha ꞊në‑ ‑mɛ bha dho kë ‑wëësü. ");
INSERT INTO daf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","‑Gwë kpö 'kpikpi ‑zian ‑dun ‑a ‑mɛ bhɔ ‑bha ‑sü 'wo‑ ‑zuö 'ka ꞊weeyi ꞊bhaa ‑a fië‑ ‑dhö ‑a ‑mɛ ‑bha 'mɛ 'wo ꞊dhɛ 'në 'sɛɛnnë ‑nu ya‑ ‑nu 'dhö 'dhang ‑bho n \"dhiʋ̈ ‑sü 'gü bha mɛ do zian ‑da Atanna \"dhiʋ̈ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, ‑ka \"ta ka 'suan‑ 'ka. ꞊Ya kë ꞊dhɛ i dheebhang ꞊ya 'wɔn yaa kë i 'ka, ‑bhö ‑a ‑dhiang zë ‑së 'ka kö 'i ‑dhio dɔ‑ ‑ta. ꞊Ya kë ꞊dhɛ ꞊ya \"wɩ i ‑bha ‑bha kö ‑yö ö bo ö ꞊sɔng bha‑ 'ka, ‑a ‑mawɔn 'to. ");
INSERT INTO daf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","꞊Ya kë ꞊dhɛ ꞊ya ‑da i \"dhiʋ̈ ꞊dhɛ pë \"saɔplɛ 'dhö ‑dhɛkpaɔyi do 'ka, kö ꞊ya ‑da i \"dhiʋ̈ ‑kɔ 'ö‑ 'gü 'do 'do kö ‑yö nu ‑ya pö i ‑dhɛ ꞊dhɛ 'ya ‑da i \"dhiʋ̈, \"kɛɛ 'yii 'dho‑ 'bha kë \"dhʋ̈ 'zü, ‑a ‑dhɛa ‑bha ꞊dhɛ 'i‑ ‑mawɔn 'to. ");
INSERT INTO daf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö‑ ‑bha bɔmɛ ‑nu ‑wa pö‑ ‑dhɛ: «Yi Dëmɛ, ‑bhö yi ‑bha ‑zʋ ‑yö Atanna ‑dhɛ ‑sü taa kë!» ");
INSERT INTO daf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «꞊Ya kë ꞊dhɛ ka ‑bha ‑zʋ ‑yö Atanna ‑dhɛ ‑sü ꞊ya kë ‑zianwo ꞊dhɛ \"pënngga 'dhö, 'ka‑ pö \"dhü 'kpii‑ 'ö dɔ ya‑ ‑dhɛ ‑yö 'go ö \"gblʋʋ kö ‑yö 'dho dɔ ꞊weeyi ꞊bhaa, ‑yö ‑dho 'dho ka ‑wʋ bha‑ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","'Yö‑ pö 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «'Mɛ 'ka ya de ‑mü 'ka ka kpö 'gü 'yö‑ ‑bha ꞊dhuënggɔmi ꞊ya 'go 'ke‑ kë ‑dhɛ 'gü kö ‑yö nu, \"ɛɛn ꞊ya 'go ‑tuʋ̈ ‑maa kë ‑dhɛ 'gü kö ‑yö nu, 'yö dho ꞊mɔɔ‑ ‑bha kö ‑ya pö‑ ‑dhɛ: «‑Bhö nu \"vaandhö kö 'i pë ‑bhö? ‑A ‑mɛ 'yaa 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Pë 'ö dho‑ pö yö ‑mü ꞊dhɛ ‑yö ö baa‑, ‑yö 'bhlaa‑ ‑sɔ bha‑ bho ö ‑bha kö ‑yö ö \"dhi mɔɔ‑ kö 'ö pë ‑bhö kö 'ö müpë mü. Kö ꞊ya bo ö ‑bha bha‑ 'ka kö yö ‑zë ‑yö gun ‑na 'yaanu kö ‑yö ö ‑bha ‑bhö \"ɛɛn ö ‑bha müpë mü. ");
INSERT INTO daf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kö ‑yö kë ꞊dhɛ yöö‑ nuɛ\" 'bha ꞊në‑ bho ‑a këwɔn ‑bha 'yaa ‑mü. \"Ɛɛn 'yaa \"dhʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ka ‑bha ‑yö ‑kɔ bha ꞊në‑ 'gü 'pö. ꞊Ya kë ꞊dhɛ ‑wʋ ‑nu 'a dho‑ 'kpɔ ka ‑bha bha, 'ka ka bo‑ ꞊gban 'gü ‑wɔn kë ‑sü 'ka, ‑kaa pö: «Gwëëmi \"wɛɛwɛɛdhe ‑mü yi 'ka, yi kë ‑yë ꞊në 'yi‑ ‑kë, nuɛbhomɛ ‑zian 'yaa ‑mü yi 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","꞊Dhɛ 'ö yi do 'ka kö Yesu ‑yö 'dho sië Zedhizadhɛmö, 'yö bɔ Samadhi ‑sɛ waa‑ Gadhidhe ‑sɛ ‑nu ‑naa \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","'Ö gun kö ‑yö ‑da sië 'pödhɛ do 'bha 'gü, 'yö ꞊weeyuamɛ ‑kaɔng do 'wo nu dɔ‑ ‑gɔ zian‑, ‑wo ‑to 'ka 'bleng ‑bleng, 'yö 'wo wo ‑wʋ \"dhiʋ̈ ꞊wlü 'wo‑ pö‑ ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Yesu yi Dëmɛ, ‑bhö yi ‑wëë ‑ga ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","꞊Dhɛ 'ö‑ ‑nu yö, 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka 'dho kö 'ka ka ‑dɩ ‑zɔn \"saabhomɛ ‑nu ‑dhɛ!» ꞊Dhɛ 'ö 'mɛ 'wo bha 'wo 'dho sië, 'wo dho \"kan wo ‑ta kö ꞊wa kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","꞊Dhɛ 'ö 'mɛ 'wo bha‑ mɛ do 'ö ö ‑dɩ yö kö 'ya kë \"klʋ̈ʋ̈klʋ̈ 'kpakpadhö, 'yö ‑yɛ ö 'gü 'zü ‑deewo 'ö nu Atanna 'tɔ bhɔ ‑sü 'ka \"gbɩɩ‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","'Yö nu 'ö zun ö kpiö 'gü Yesu ‑dhɛ, 'yö zun‑ nuɛ\" bho ‑sü ‑bha, \"kɛɛ 'sa kö Samadhi mi ꞊në gun 'mɛ 'kö bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ‑ya ‑pö yö ꞊në‑ ‑wɔn 'gü 'ö‑ pö: «Mɛ ‑kaɔng do 'wo gun bha, ‑a ‑nu ꞊gban 'wii kë ꞊në wo \"klʋ̈ʋ̈klʋ̈ ‑ee? 'Yö‑ mɛ ‑kpɛa ‑nu ‑zë ‑wo 'mɛ? ");
INSERT INTO daf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","‑Më ‑wɔn ꞊në ‑kë 'yö‑ mɛ ‑kpɛa ‑zë ‑a ‑nu 'bha ‑zʋ 'yii ‑da Atanna nuɛ\" bho ‑wɔn ‑ta kö ‑wo wo yee kë ‑wo nu kö 'yii kë \"sɛ \"wɛɛ 'gü mi 'kö ya‑ 'ka?» ");
INSERT INTO daf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö‑ pö 'mɛ 'bha‑ ‑dhɛ: «N \"taɔngdë, ‑bhö \"wlü kö 'i i ‑bha 'dho wo; i ‑bha 'dhang ‑bho n \"dhiʋ̈ ‑sü ꞊në i dha bha.» ");
INSERT INTO daf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö Fadhiziɛn ‑nu ‑wo Yesu dhɛɛ\" kpɔ 'wo‑ pö: «Atanna ‑bha ‑gblüdëdhɛ ‑dho nu ‑më \"tʋ̈ng ꞊në‑ 'gü?» 'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A ‑bha ‑gblüdëdhɛ ‑bha nu ‑sü bha 'yii 'dho kë mɛ 'bha \"yan ‑bha 'kun ‑wɔn 'ka. ");
INSERT INTO daf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","'Wii 'dho‑ pö: «Atanna ‑bha ‑gblüdëdhɛ ‑bha ꞊dhɛ ꞊ya nu ꞊dɛɛ ꞊ya ꞊loo ‑dhɛ 'ö ꞊ni‑ 'gü!», \"ɛɛn: «‑Yö ‑dhɛ 'dhɛ ya‑ 'gü!»; ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑bha ‑gblüdëdhɛ ‑yö ka kpö 'gü yö.» ");
INSERT INTO daf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","'Yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «‑Ka ‑dhɛ ‑ga, \"tʋ̈ng 'bha‑ mü ‑dho ꞊loo 'ö 'ka‑ \"slë ꞊mɔɔ kö ka \"yan ‑yö ‑da mang Mɛgbömɛ ma mɛdhɛ kë ‑yi \"zɔ \"dhiʋ̈ 'në 'dɛdɛ 'në 'bha ‑zian 'gü, \"kɛɛ 'kii 'dho‑ ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","‑Wo ‑dho ‑a pö ka ‑dhɛ: «‑Ka 'dho ‑dhɛ ya‑ 'gü, ‑yö mü!» \"ɛɛn: «‑Yö ‑dhɛ 'dhɛ ꞊ni‑ 'gü!», \"kɛɛ ꞊waa‑ pö \"dhʋ̈ 'ka 'dho‑ ‑yɔ bɔ, 'ka 'dho ‑bɛang 'sü 'ka dho‑ ‑dhɛ mɔɔ‑; ");
INSERT INTO daf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","‑a ‑gɛn ‑mü ꞊dhɛ mang Mɛgbömɛ n nu ‑sü bha ‑yö ‑dho kë ꞊dhɛ ‑kɔ 'ö dha ‑yö \"yaan‑ kun‑ 'ka, 'ö ‑kë ꞊dhɛ mɛ‑ mɛ \"yan zë, \"kɛɛ 'ö \"sɛ zun‑ 'ka 'ko \"dhiʋ̈ bha ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","\"Kɛɛ \"sanni ‑yö kë \"dhʋ̈, kö ꞊dɛɛ ya‑ 'gü ‑mɛ ‑nu ꞊në ꞊wa wo bo n 'ka, kö ꞊wa n ‑wëë ‑kë \"dhiʋ̈ ꞊gban \"pɛpɛ suu bho. ");
INSERT INTO daf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","'Wɔn do 'ö ‑kë yi 'bha 'ka Noe ‑bha \"tʋ̈ng 'gü, ‑a do 'bha ‑dho kë mang Mɛgbömɛ n nu ‑yi 'ka. ");
INSERT INTO daf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","‑A \"tʋ̈ng bha‑ 'gü kö mɛ \"bhɩɩ‑ ‑nu ‑wo pë ꞊në ‑bhö sië, 'ö 'wo we mü, 'ö 'wo dhe sü, 'ö 'wo‑ sü \"dhʋ̈ wo gbö ‑nu ‑dhɛ 'ö 'to‑ 'ka \"dhʋ̈ 'ö zun‑ 'ka Noe ‑bha ‑da \"yitagɔ 'gü ‑yi ‑bha. ‑wo ‑to 'wɔn ‑nu bha ꞊në‑ ‑bha 'yö dha ‑yö zun \"sɛɛ, 'yö \"yi ‑yö pa, 'yö‑ ‑nu ꞊gban zë \"pɛɛpɛdhö. ");
INSERT INTO daf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","'Wɔn do 'ö ‑kë Dhɔtö ‑bha \"tʋ̈ng 'gü 'zü ꞊në dho kë. ‑A \"tʋ̈ng bha‑ 'gü kö pë ‑bhö ‑sü ‑nu oo, we mü ‑sü ‑nu oo, pë 'dhɔ ‑sü ‑nu, pë \"dhɔɔ dɔ ‑sü ‑nu, pë ta ‑sü ‑nu waa‑ 'kɔ dɔ ‑sü ‑nu ꞊në ꞊wa wɔ mɛ \"bhɩɩ‑ ‑nu ‑gɔ ‑së. ");
INSERT INTO daf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","‑Wo ‑to 'wɔn ‑nu bha ꞊në‑ kë ‑sü ‑bha, 'yö Dhɔtö ‑go Sodɔmö ‑yi ‑yö ꞊loo. ꞊Dhɛ 'ö ꞊ya bo 'go ‑sü 'ka Sodɔmö ‑pö 'gü, 'yö pɛng waa‑ blɔɔn\" ‑dha ‑yö zun ban ‑sü ‑bha, 'yö‑ ‑nu ꞊gban \"pɛpɛ zë. ");
INSERT INTO daf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yi 'ö Mɛgbömɛ dho nu‑ 'ka, ‑yö ‑dho kë ‑kɔ do bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mɛ \"ʋʋ mɛ 'ö dho kë 'kɔ ꞊taa yi 'ö \"dhʋ̈ bha‑ 'ka, 'ö‑ ꞊kwɛɛ yaa‑ ‑kë 'kɔɔdhö, 'ya 'dho‑ pö ö ‑dɩ ‑dhɛ ꞊dhɛ 'ö lɔɔ‑ kö 'ö dho‑ 'sü ‑dhɛ 'gü, ‑ɛɛ 'mɛ yaa‑ ‑kë 'zü 'bhlaadhɛ 'bha 'gü, 'ya 'dho‑ pö 'ö ö yee kë kö 'ö 'dho ö ꞊taama. ");
INSERT INTO daf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","'Ma‑ pö \"dhʋ̈, ka ‑zʋ ‑yö ‑da 'wɔn 'ö Dhɔtö ‑bha dhebhɔ ꞊slɔɔ yi 'bha 'ka ('ö ‑dhɛ ‑ga ö ꞊taama 'ö‑ 'gü ‑yö see‑ bha ꞊në‑ ‑ta). ");
INSERT INTO daf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","'Mɛ 'ö yaa ö ‑dɩ dha ‑dhɛ ‑mɔɔ ‑a ‑mɛ ‑gɔ ‑dho 'to‑ 'gü. 'Yö 'mɛ 'ö yaa ‑wɩ ö ‑gɔ ‑to 'gü ‑wɔn ‑bha bha yö ‑zë 'ö dha. ");
INSERT INTO daf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ‑A yi 'ö bha‑ 'ka gbeng, mɛ ꞊plɛ 'wo wɔ ‑sü 'ka sɛɛ\" do ‑ta, 'gbʋ‑ ‑dho mɛ do 'sü 'ö dho‑ 'ka 'ö‑ mɛ do to. ");
INSERT INTO daf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","'Ö dhong ‑nu ꞊plɛ 'wo dho kë pë zɔn ‑dhɛ 'gü \"wlʋ̈ do 'gü, 'ö 'gbʋ‑ ‑ya mɛ do sü 'ö‑ mɛ do to. ");
INSERT INTO daf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Gɔɔn‑ ‑nu ꞊plɛ 'ö waa‑ ‑kë 'bhlaa‑ do 'gü, 'gbʋ‑ ‑dho mɛ do 'sü 'ö‑ mɛ do to.» ");
INSERT INTO daf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'Yö‑ ‑bha ꞊klang ‑nu ‑wa dhɛɛ\" kpɔ 'wo‑ pö: «‑A 'wɔn 'i \"wɩ sië‑ 'ka bha, ‑yö ‑dho kë \"dhʋ̈ ‑dhɛ ‑mɛɛ ꞊në‑ 'gü, yi Dëmɛ?» 'Yö‑ pö: «‑Ka 'wɔn 'suan‑ bho \"gblëë‑ ‑nu bha. ‑Dhɛ 'ö pë ꞊gee 'dhö‑ ‑bha, 'yö \"gblëë‑ ‑nu ‑wo bho 'ko ‑ta ‑a ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö \"gwënng do ‑da ö ‑bha ꞊klang ‑nu bha‑ ‑nu ‑dhɛ, kë \"dhʋ̈ kö 'ö‑ ‑zɔn ‑nu ‑dhɛ ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ ‑wo bhɛa\" Atanna ‑dhɛ yi ꞊gban \"pɛpɛ 'ka kö‑ ‑nu 'gü 'ya 'dho ga 'yö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Zadɔmɛ do 'bha ‑yö ‑gun 'pödhɛ do 'bha 'gü yi 'bha 'ka, 'ö 'yaa gun \"suʋ̈ sië Atanna ‑gɔ, \"ɛɛn 'ö 'yaa gun ‑kpla sië mɛ 'bha ‑mɛ ‑bha ‑mɛ 'bha ‑gɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","꞊Gɛandhe do 'bha ‑yö ‑gun 'pö 'pödhɛ do bha‑ 'gü, 'ö dhiang ‑yö gun waa‑ mɛ 'bha ‑a ‑nu ꞊zinng 'gü. 'Yö ꞊gɛandhe bha 'ö dho 'ö dhiang bha‑ ‑da zadɔmɛ bha‑ ‑dhɛ. ꞊Ya kë ꞊sië ‑nu wo 'yö dho zadɔmɛ bha‑ \"piʋ̈, 'yö‑ pö‑ ‑dhɛ ‑yö woo‑ za bha‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","'Yö ꞊gɛandhe bha 'ö ö ‑gɛn dɔ zadɔmɛ bha‑ ‑dhɛ 'gü pinpindhö kö 'yaa \"wɩ‑ ‑bha kö ‑ya ‑nu ‑bha za bha‑ dɔ. \"Kɛɛ ‑a ‑fɛɛ ‑ya ‑bha ‑kɔ yaa bha‑ ‑wɔn 'gü, 'yö yi do 'ka 'yö zadɔmɛ bha 'ö‑ pö: «'Kwa‑ ma, 'maa \"suʋ̈ ‑zë wo Atanna ‑gɔ tɛan‑ 'ka, \"ɛɛn 'maa ‑kpla mɛ 'bha ‑gɔ, ");
INSERT INTO daf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","\"kɛɛ yö ꞊në‑ ꞊gban 'gü, ꞊dhɛ 'ö 'maa n ‑yɛa yö dhebhɔ ya‑ ‑gɔ bha, ‑ka dɔ kö 'a‑ ‑bha za bha‑ dɔ kö‑ ‑bha ‑fɛɛ 'go n ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","'Yö kwa Dëmɛ Yesu ‑ya ‑ta yɔ 'ö‑ pö: «Zadɔmɛ ‑mawɔn yaa bha 'ö dhiang 'ö‑ zë bha ka‑ ma ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'Yö‑ pö: «(\"Sanni mɛ \"bhɩɩ‑ ‑zë ‑yö ꞊dua ‑fɛɛ ‑gɔ kö ‑yö za dɔ ꞊dhɛ ‑kɔ bha‑ 'dhö, \"kɛɛ kö yö ‑zë ‑mawɔn ‑yö 'ya‑ \"dhʋ̈ bha ‑oo,) 'yö Atanna ‑zë ꞊wɛ? ‑Më ꞊në ‑kë 'yö 'yaa ö ‑bha mɛ ‑nu ‑ta ‑za dɔ kö ‑wo bhɛa\" sië‑ ‑dhɛ 'yënng‑ 'gü waa‑ gbeng 'gü ‑nu ꞊gban 'gü?» ");
INSERT INTO daf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: ‑A 'gü ‑zian 'yii 'dho ꞊gwëë 'yö ka ‑ta ‑za dɔ. \"Kɛɛ 'wɔn do 'bha‑ ‑dhö, yö ‑mü ꞊dhɛ: 'Ö yaa‑ ‑dɔ mang Mɛgbömɛ n nu ‑yi ‑bha kö ‑zʋ ‑yö n ‑dhɛ ‑sü ‑yö ‑tun mɛ 'bha ‑gɔ \"kpʋng yö ꞊taa \"wɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","꞊Dhɛ 'ö Yesu ꞊ya ö bo \"gwënng 'dhɛ bha‑ ‑da ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö dho 'yö‑ do 'bha ‑da 'mɛ 'wo gun wo ‑zʋ 'gɔn sië ꞊dhɛ wo ‑zë pö 'yaa wo ‑bha Atanna wëëdhö, 'ö 'waa gun mɛ ‑kpɛa yö sië‑ 'gü bha‑ ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Yi do 'ka, 'yö mɛ ꞊plɛ 'wo ꞊wlü 'wo dho ‑bhɛa Atanna ‑dhɛ ‑dhɛ 'gü ‑a ‑dhɔkëgükɔ 'gü. Mɛ ꞊plɛ 'wo \"dhʋ̈ bha‑ mɛ do ‑gun Fadhiziɛn 'ka. 'Yö‑ mɛ do‑ gun 'niisɔngkunmɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ‑da 'kɔɔdhö, 'yö‑ Fadhiziɛn mi ‑sü ‑yö dɔ \"pɛan do \"piʋ̈, 'yö zun ‑bhɛa Atanna ‑dhɛ ‑sü ‑bha 'ö‑ pö: «'Aa, n Dë Atanna, 'ma i nuɛ\" bho ꞊dedewo, \"wɩ 'ö bhii‑ wo‑ ‑bha kö 'a kë ꞊kwaanmɛ 'ka, \"ɛɛn kö 'a kë 'wɔnyaakëmɛ \"ɛɛn ‑zuazëmɛ 'ka ꞊dhɛ mɛ ‑kpɛa 'wo to‑ ‑nu 'dhö, \"ɛɛn 'zü kö 'maa ꞊dhɛ 'niisɔngkunmɛ 'ö dɔ ya‑ 'dhö bha‑ ‑wɔn 'gü; ");
INSERT INTO daf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","‑a ‑gɛn ‑mü ꞊dhɛ a 'sunng‑ ‑ma ‑dhɛkpaɔyi ꞊plɛ ꞊në 'ka \"dhɔɔgɔ do 'gü, 'ö 'a n ꞊slɔɔpë ꞊gban \"pɛpɛ 'nii‑ bho i ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kö 'niisɔngkunmɛ 'kö bha ‑yö dɔ sië \"pɛan \"wɛɛ \"piʋ̈, kö 'yaa ꞊mɔɔ ‑zian wo‑ ‑bha kö ‑yö ö \"yan \"dhiʋ̈ \"wlü dhang‑ 'gü. \"kɛɛ kö ‑yö ö ‑kɔ ‑ya sië ö ‑kuu 'gü 'ö‑ pö: «'Aaa, n Dë Atanna, ‑bhö i zuë\" kë ‑sɛa n \"piʋ̈ kö 'i n ‑mawɔn 'to ‑dhe, 'wɔnyaakëmɛ ‑mü n 'ka ‑wa.» ");
INSERT INTO daf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Yö Yesu ‑ya ‑ta yɔ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ ꞊sii ꞊dede ‑ta ꞊dhɛ mɛ ꞊plɛ bha‑ mɛ 'dhɛ 'ö ꞊bhɛa \"dhʋ̈ bha, Atanna ‑yö kë‑ ‑mawɔn ‑to 'ö dho ö ‑ta \"puu 'ka ö ‑gɔ 'kɔɔdhö mɛ 'dhɛ 'ö to bha‑ ‑bha; ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö dho‑ pö 'ö ö ‑dɩ fië bho mɛ ‑kpɛa ‑bha, Atanna ‑dho ‑a ꞊bhlëë ‑pö kpɛkpɛdhö, \"kɛɛ 'mɛ 'ö yaa ö ‑dɩ ‑da mɛ ꞊gban ꞊wlöö, ‑yö ‑dho ‑a ‑mɛ gba ‑duɛ 'kpii‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","'Ö go‑ 'dhɛ bha‑ 'gü, 'yö 'wo nu‑ ‑dhɛ 'në 'sɛɛnnë ‑nu 'ka 'pö kö ‑yö ö ‑kɔ zun‑ ‑nu ‑bha kö Atanna ‑bha 'dhuë‑ ‑ya ‑nu 'kun. \"Kɛɛ ꞊dhɛ 'ö‑ ‑bha ꞊klang ‑nu 'wo‑ ‑dhɛ yö \"dhʋ̈, 'yö ‑siö ‑nu ‑dhɛ, 'yö 'wo ‑ya ‑dɔn bho ‑sü ‑bha 'mɛ 'wo nu 'në ‑nu 'ka bha‑ ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'Yö Yesu ‑ya pö ‑wo nu‑ ‑nu 'ka. ꞊Dhɛ ꞊ya kë \"dhʋ̈ 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka ka kwaa‑ 'në ‑nu ‑zü kö ‑wo nu n \"piʋ̈, 'ka 'dho‑ ‑nu \"kan n ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ 'ö dhang‑ 'gü bha ‑yö 'mɛ 'wo ꞊dhɛ ‑a ‑nu 'dhö ꞊në‑ ‑nu ‑bha 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Mɛ \"ʋʋ mɛ 'ö 'yii ö ‑kɔ ‑ya Atanna ‑bha ‑gblüdëdhɛ bha‑ ‑bha ꞊dhɛ ‑kɔ 'ö 'nësɛɛnnë ‑nu 'wo \"wɩ sië‑ 'ka 'wɔn ‑bha bha‑ 'dhö, ‑a ‑mɛ 'yii 'dho ‑da mü tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yi do 'ka 'yö Zuifö ‑nu ‑gɔmɛ do ‑yö nu, 'yö Yesu dhɛɛ\" kpɔ 'ö‑ pö: «‑Gɔmɛdë këwɔn ‑sësü, ‑më ꞊në këwɔn 'ka 'ö 'ma‑ kë 'yö a dho ꞊sii 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha‑ ‑slɔɔ?» ");
INSERT INTO daf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «I n ‑dhɛ mɛ këwɔn ‑së ‑më ‑wɔn 'gü, \"kɛɛ kö Atanna yöö do ꞊në‑ këwɔn 'dhö ‑së?» ");
INSERT INTO daf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","'Yö‑ pö: «I‑ 'wɔn ‑dɔ ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'tɔng‑ 'gü ꞊dhɛ: ‹'Waa ‑da mɛ ‑nu ‑bha dhe \"piʋ̈ tongtongdhö, 'waa mɛ zë tongtongdhö, 'waa ꞊kwaan bho tongtongdhö, 'waa ꞊sua ‑ya mɛ 'bha ‑bha tongtongdhö, ‑bhö i 'kpɔmɛ ‑nu ꞊bhlëë ‑ya.› ‑Yö n 'gü ꞊dhɛ i yö ‑zë ‑dɔ.» ");
INSERT INTO daf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","'Yö‑ pö: «꞊Iin, ‑a 'dhɛ 'kö bha a yö ‑zë ‑dɔ, a ‑bhɔ yö ‑zë kë ‑sü 'ka n 'nëdhɛ 'gü 'nu yi 'bha 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","꞊Dhɛ 'ö Yesu ꞊yaa‑ ma \"dhʋ̈ 'yö‑ pö‑ ‑dhɛ: «'Wɔn do ꞊në‑ këwɔn ꞊ya 'to i ‑bha.» 'Yö‑ pö: «‑Bhö 'dho kö 'i i ꞊slɔɔpë ꞊gban \"pɛpɛ \"dhɔɔ dɔ kö i‑ ꞊naɔ bha 'gü ‑gblü ‑wëëmɛ ‑nu ‑ta kö 'i nu 'i 'to n ꞊keng‑, ꞊ya kë \"dhʋ̈ Atanna ‑dho i gba ꞊naɔ bha‑ \"wɛɛ 'ka dhang‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","꞊Dhɛ 'ö ‑wʋ 'dhɛ 'kö bha‑ ma Yesu \"dhi, 'yö ö wëë' 'gü ‑siö, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊naɔ ‑yö ‑gun ‑gɔ ꞊dedewo, 'yö 'yii \"wɩ‑ ‑bha kö ‑yö ö ‑kɔ bho ö ‑bha ꞊naɔ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","꞊Dhɛ 'ö Yesu ‑ya ‑dhɛ yö ꞊dhɛ ‑a wɔ ‑ta ꞊ya ga kpɛkpɛdhö dhiang 'ö‑ zë‑ ‑dhɛ bha‑ ‑wɔn 'gü, 'yö‑ pö 'mɛ 'wo gun mü bha‑ ‑nu ‑dhɛ: «Ka ‑dhɛ ‑yö bha ‑ee? A‑ ‑pö ka ‑dhɛ ꞊dhɛ ꞊naɔmɛ ‑nu ‑da Atanna ‑bha ‑gblüdëdhɛ 'gü ‑sü ‑dho ꞊gbaɔn ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","‑Yɔɔnmɛa ‑zian ‑bha ‑ziö ‑sɛdha ‑yɛ 'ka ‑dhɛ ‑dho kë ‑së ꞊naɔmɛ ‑nu ‑bha ‑da Atanna ‑bha ‑gblüdëdhɛ 'gü ‑sü ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","꞊Dhɛ 'ö 'mɛ 'wo gun mü 'wo 'wɔn bha‑ ma, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «꞊Ya kë \"dhʋ̈ 'sa kö 'dee dho dha 'wɔn yö‑ 'gü?» ");
INSERT INTO daf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Mɛ \"bhɩɩ‑ ꞊në‑ ‑fiëbhawɔn 'dhö 'dhö, \"kɛɛ Atanna ‑zë ‑fiëbhawɔn 'yaa 'dhö tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","'Yö Piɛdhö ‑ya pö‑ ‑dhɛ: 'Yö 'mɛ 'kö 'ya yi 'kɛ‑ ‑nu waa‑ yi ꞊slɔɔpë ꞊gban \"pɛpɛ 'to 'ya nu i ꞊keng‑ 'sa yö ꞊wɛ?» ");
INSERT INTO daf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Mɛ \"ʋʋ mɛ 'ö zë Atanna ‑bha ‑gblüdëdhɛ ‑wɔn ‑dhɛ 'ö bo ö ‑bha 'kɔ 'ka \"ɛɛn 'ö ‑kan ö ‑bha dhebhɔ ‑bha, \"ɛɛn ö dheebhang ‑nu ‑bha, \"ɛɛn ö 'kɛ‑ ‑nu ‑bha, \"ɛɛn ö ‑bha 'në ‑nu ‑bha, ");
INSERT INTO daf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Atanna ‑dho ‑a \"dhiʋ̈ziöta nu‑ ‑mɛ ‑dhɛ \"tʋ̈ng 'kwa dɔ‑ 'ka ya‑ 'gü, 'ö dho 'ö‑ gba ꞊sii 'ö 'yaa yën 'ö‑ \"piʋ̈ bha‑ 'ka ‑dhɛkpaɔ dhia\" 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö ö ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ ‑nu ‑dhɛ ‑dɩ ‑ta, 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka ‑dhɛ ‑ga, 'dho ꞊në kwa‑ wo sië Zedhizadhɛmö bha. 'Wɔn \"pɛpɛ 'ö ‑gban mang Mɛgbömɛ n ‑wɔn ‑bha 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑wa ‑bɛn zë bha, ‑a 'gü ‑wɔn kë \"tʋ̈ng ꞊në ꞊loo bha, ");
INSERT INTO daf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","‑a ‑gɛn ‑mü ꞊dhɛ 'dho kwa‑ wo sië ya ‑wo ‑dho n ꞊gbaɔ 'mɛ 'waa Atanna dɔ‑ ‑nu ‑gɔ, 'ö 'wo ꞊wɛɛ dɔ n ‑bha, 'ö 'wo \"si bho n ‑gɔ, 'ö 'wo wo \"dhidhi ‑pɛn n ‑bha, ");
INSERT INTO daf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","'ö 'wo n ‑ma ꞊klangga 'ka, 'ö 'wo n zë, \"kɛɛ ꞊wa bo n zë ‑sü 'ka, a ‑dho ‑bö ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa bha‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","\"Kɛɛ ‑a pö 'ö‑ wo \"dhʋ̈ bha 'wii‑ 'gü ma, ‑a 'gü ‑yö ‑gun ‑nu 'gü tii', 'wii‑ 'klɔɔ‑ 'bha dɔ. ");
INSERT INTO daf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","꞊Dhɛ 'wo 'dho sië, 'ö Yesu ꞊ya ꞊loo Zedhiko ‑pö \"saan \"dhiʋ̈, 'yö 'wo ‑kpan \"yanwlümɛ do ‑bha kö ‑yö ‑ya sië zian \"gʋ̈ng \"piʋ̈ kö ‑yö gba ‑dhɛ sië. ");
INSERT INTO daf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","꞊Dhɛ 'ö‑ \"tʋ 'dhö ‑da mɛ kpö 'wo gun ziö sië ‑yuudhö bha‑ ‑nu ‑wʋ 'gü, 'yö mɛ ‑nu dhɛɛ\" kpɔ, ");
INSERT INTO daf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","'yö 'wo‑ pö‑ ‑dhɛ: «Yesu 'ö go Nazadhɛtö bha ꞊në ziö sië bha.» ");
INSERT INTO daf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Yö \"yanwlümɛ bha 'ö ꞊gbla 'ö‑ pö: «Yesu, Davi Gbö, ‑bhö n ‑wëë ‑ga ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö 'mɛ 'wo gun \"ta 'sü sië 'wo gun Yesu \"dhiʋ̈ bha 'wo zun ‑ya ‑a \"yan 'gü ‑sü ‑bha, kë \"dhʋ̈ kö ‑yö ö \"dhi ta. \"Kɛɛ 'yii‑ ‑yɔ bɔ, 'yö ö ‑wʋ \"dhiʋ̈ 'bha ꞊wlü 'zü \"gbɩɩ‑ 'ka 'ö‑ pö: «Davi Gbö, ‑bhö n ‑wëë ‑ga ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","꞊Dhɛ 'ö Yesu \"tʋ ‑yö ‑da ‑a ‑wʋ 'gü, 'yö 'daɔnnu, 'yö‑ pö ‑wo nu‑ 'ka ö ‑dhɛ. ꞊Dhɛ 'ö ꞊wa nu ꞊wa ꞊loo‑ 'ka Yesu \"sɔɔ, ");
INSERT INTO daf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «‑Më ‑wɔn ꞊në 'i‑ \"piʋ̈ ꞊dhɛ 'a‑ kë i ‑dhɛ?» 'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N Dëmɛ, ‑yö n \"piʋ̈ ꞊dhɛ 'i n \"yan ya ꞊në‑ \"dhiʋ̈ \"pʋ kö a ‑dhɛ yö ‑deewo.» ");
INSERT INTO daf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","'Yö Yesu ‑ya pö‑ ‑dhɛ: «꞊Dhɛ 'ö \"dhʋ̈, i \"yan \"dhiʋ̈ ‑yö \"pʋ, i ‑bha 'dhang ‑bho n \"dhiʋ̈ ‑sü ꞊ya i dha!» ");
INSERT INTO daf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","'Mɛ bha ‑yö ‑to ‑dhɛ do bha‑ 'gü 'ö‑ \"yan ‑yö ‑dhɛ yö ‑deewo, 'yö ‑ziö Yesu ꞊keng‑ kö ‑yö Atanna 'tɔ bhɔ sië. 'Yö mɛ \"pɛpɛ 'kö 'wo gun Yesu ꞊keng‑, 'ö 'wo 'wɔn bha‑ ‑dhɛ yö, 'yö 'wo ‑ya Atanna 'tɔ bhɔ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","'Yö Yesu ‑yö ‑dho \"dhʋ̈ 'ö ‑da Zedhiko ‑pö 'gü, 'yö zun 'pö‑ 'gü \"pɛ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'Ö \"dhʋ̈ bha kö gɔndënë do 'bha 'ö ‑kë ꞊naɔmɛ 'ka, \"kɛɛ 'ö ‑kë 'niisɔngkunmɛ ‑gɔmɛ 'ka 'wo‑ ‑dhɛ Zase bha ‑ya \"slë mɔɔ‑ sië kö 'ö Yesu dɔ. ");
INSERT INTO daf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","\"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ 'yaa gun mɛ ꞊gblɛɛn 'ka, ‑a ‑kɔ 'yii ꞊mɔɔ‑ ‑bha mɛ kpö 'ö gun Yesu ꞊keng‑ bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","'Yö ‑bɛang sü 'ö ‑da \"dhiʋ̈, 'yö dho ö ‑da \"dhü do 'bha bha‑ 'gü, kë \"dhʋ̈ kö 'ö Yesu yö; ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊yaa‑ 'wɔn dɔ ꞊dhɛ ‑yö ‑dho bɔ ‑dhɛ bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","꞊Dhɛ 'ö Yesu dho 'ö ꞊loo \"dhü 'ö Zase gun‑ 'gü bha‑ ꞊wlöö, 'yö ö ‑gɔ \"dhiʋ̈ ꞊wlü 'ö ‑dhɛ ‑ga \"dhü bha‑ 'gü, 'yö‑ pö Zase ‑dhɛ: «Zase, ‑bhö lɔɔ‑ \"vaandhö, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊dɛɛ 'ö ꞊dɛɛ 'ka a ‑dho ‑da 'ka i ‑gɔ 'kɔɔdhö.» ");
INSERT INTO daf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'Yö Zase ‑yö ꞊lɔɔ ‑bɛang 'ka, 'yö dho 'ö‑ ꞊yëë bho ꞊niidadhe ꞊dede 'ka ö ‑gɔ 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","꞊Dhɛ 'ö 'mɛ 'wo gun Yesu ꞊keng‑ bha 'wo 'wɔn bha‑ ‑dhɛ yö, 'yö‑ ‑nu ꞊gban \"pɛpɛ 'wo ‑ya ‑dɔn ‑bho wo yun 'gü ‑sü ‑bha Yesu 'ka 'wo‑ pö: «'Mɛ bha ꞊ya 'dho ö ꞊yëë bho 'wɔnyaakëmɛ ‑gɔ 'kɔɔdhö ‑wa!» ");
INSERT INTO daf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","\"Kɛɛ \"tʋ̈ng 'wo‑ pö sië 'ka \"dhʋ̈ bha kö Zase ꞊ya 'dho ꞊ya dɔ Yesu wëëdhö kö ‑ya pö sië‑ ‑dhɛ 'ö‑ pö: «N Dëmɛ, ꞊ya 'go ꞊dɛɛ 'gü, ꞊naɔ 'ö n ‑gɔ a ‑dho ‑a \"pɛ 'gü 'a‑ \"pɛan do nu \"flɛɛmɛ ‑nu ‑dhɛ, 'ö mɛ \"pɛpɛ 'a \"kpënng‑ ‑kë ‑nu ‑gɔ 'a‑ ‑nu ‑bha ꞊naɔ ‑bhö bha 'a dho 'a‑ ‑gaɔ ‑yiisiö nu‑ ‑mɛ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Yesu ‑ya pö‑ ‑dhɛ: «Zase, dha ‑sü ‑bhiëë ꞊ya zun i ‑bha 'kɔ ‑bha ꞊dɛɛ, ‑a ‑gɛn ‑mü ꞊dhɛ Ablaamö suu ‑mü i 'ka 'pö. ");
INSERT INTO daf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ mang Mɛgbömɛ a ‑nu \"kpʋng ꞊taa kö 'mɛ 'ö Atanna ‑bha zian ꞊ya ꞊dhɛng‑ ‑nu ‑gɔ ꞊në 'a‑ ‑nu mɔɔ‑ kö 'a‑ ‑nu dha.» ");
INSERT INTO daf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","\"Tʋ̈ng 'ö Yesu 'dhö \"wɩ sië‑ 'ka \"dhʋ̈ bha kö 'waa Zedhizadhɛmö ‑dhɛ 'ka ꞊gblɛɛn 'zü, kö 'mɛ 'wo wo \"tʋ 'to sië‑ ‑wʋ ‑bha bha ‑wo wo ‑zʋ 'gɔn sië ꞊dhɛ 'wa bo 'dho ‑sü ‑zë 'ka kö 'wo ꞊loo Zedhizadhɛmö bhoo, kö Atanna ‑bha ‑gblüdëdhɛ ꞊ya ‑ya ‑bha ꞊naa bha. ");
INSERT INTO daf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'Yö \"gwënng do ‑da ‑nu ‑dhɛ 'ö‑ pö: «Yi do 'ka 'yö gɔndënë do 'ö bhɔ ‑gblüdëdhɛ ‑kɔdhi 'gü, 'yö ꞊wlü 'ö dho \"sɛ ꞊gblɛɛn 'bha 'gü kö ꞊wa bo ö kë ‑sü 'ka ‑gblüdë 'ka mü kö 'ö nu 'ö ‑ya ö ‑bha \"sɛ ‑gɔ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","꞊Dhɛ 'ö yöö 'dho, 'yö ö ‑bha gwëëzë ‑nu ‑kaɔng do ‑dhɛ, 'yö \"sënng ga ‑kaɔng do 'gü ‑gblü ‑a ‑nu ‑ta 'yö‑ pö: «‑Ka 'dho‑ 'ka kö 'ka‑ ‑ziö 'gü ziö \"sanni n nu ‑sü ꞊zinng 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","\"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ 'mɛ bha‑ ‑san ‑gun ö ‑gɔ \"sɛgümɛ ‑nu kë sië bha, 'yö 'wo mɛ bɔ‑ ꞊keng‑ \"sɛ 'ö dho‑ 'gü bha‑ 'gü, 'yö 'wo‑ pö 'mɛ 'wo mü‑ ‑nu ‑dhɛ: «'Yaa yi \"piʋ̈ ꞊dhɛ 'ka 'mɛ bha‑ ‑ya yii‑ ‑gblüdë 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","\"Kɛɛ yö ꞊në‑ ꞊gban‑ 'gü, ꞊dhɛ 'ö ꞊wa bo 'mɛ bha‑ ‑ya ‑sü 'ka ‑gblüdë 'ka, 'ö ꞊ya ö yee kë ꞊ya nu ö ‑gɔ \"sɛ 'gü, 'yö mɛ bɔ ö ‑bha gwëëzë ‑nu bha‑ ‑nu ‑dhɛ kö ‑wo nu kö ‑wo wo \"kplëng bho ö ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","‑A mɛ ‑blɛɛsü 'ö nu, 'yö ö \"kplëng bho 'ö‑ pö: «N Dëmɛ, \"sënng ga do 'i‑ to n ‑gɔ bha, ‑a ‑kaɔng do ꞊në 'a‑ ꞊slɔɔ‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'Yö ‑gblüdë ‑ya pö‑ ‑dhɛ: «꞊Ya dhi, i këwɔn ‑yö ‑së. 'Ma‑ dɔ ꞊dhɛ 'wlɔɔ‑ 'në ‑mü i 'ka pë ‑bhaasü 'a‑ to i \"piʋ̈ ya‑ ‑bha. ꞊Dhɛ 'ö \"dhʋ̈, 'ma i ‑ya 'pö‑ \"gblʋ̈gblʋ̈ ‑kaɔng do ‑gɔ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","'Yö mɛ ꞊plɛ ‑naa ‑yö nu 'yö‑ pö: «N Dëmɛ, \"sënng kpö do 'i‑ to n ‑gɔ bha, ‑a \"sɔɔdhu ꞊në 'a‑ ꞊slɔɔ‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","'Yö‑ pö‑ ‑dhɛ: «Bhii ‑dɩ 'pö, ‑bhö ‑ya 'pö‑ \"gblʋ̈gblʋ̈ \"sɔɔdhu ‑gɔ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","'Yö‑ mɛ do 'bha‑ nu 'ö‑ pö: «N Dëmɛ, \"sënng kpö 'i‑ nu n ‑dhɛ bha, ‑a ‑ga 'a‑ ‑da sɔ 'gü 'a kpö ‑kë 'ö ya.» ");
INSERT INTO daf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'Yö‑ pö: «‑A kë 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ \"suʋ̈ ꞊në 'a‑ wo i ‑gɔ, a‑ ‑dɔ ꞊dhɛ i ‑mawɔn ‑yö 'ya‑, 'pë 'yaa i ‑bha 'ka 'i‑ ‑sü 'ö to i ‑gɔ, 'ö 'bhii ‑mlü bɔ ‑dhɛ 'ö‑ 'gü 'i dho 'i ‑mlü ‑kan mü.» ");
INSERT INTO daf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","'Yö ‑gblüdë ‑ya pö‑ ‑dhɛ: «I ‑dɩ ‑wʋ ꞊në 'a dho i 'kun‑ ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ gwëë\" suu yaa ‑mü i 'ka. I‑ ‑pö i‑ ‑dɔ ꞊dhɛ n ‑mawɔn ‑yö 'ya‑, 'pë 'yaa n ‑bha 'ka, a‑ ‑sü 'ö to n ‑gɔ, 'ö 'mii 'pëë‑ ta 'a‑ bhɛ bho, ");
INSERT INTO daf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","‑yö ‑kë ‑mü ꞊dhɛ 'sa 'yö 'bhii 'dho ma ꞊naɔ 'a‑ dɔ i ‑gɔ bha‑ 'ka kö 'i‑ ‑da 'wëë‑ ‑kɔ 'gü, kö \"sanni ‑yö dɔ n nu ‑yi ‑bha kö ‑a ꞊trɔɔn ꞊ya ‑da, 'yö i‑ to i ‑ta?» ");
INSERT INTO daf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'Yö‑ pö 'mɛ 'wo gun mü bha‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka ma \"sënng kpö 'ö 'mɛ bha‑ ‑gɔ bha‑ 'sü‑ ‑gɔ kö 'ka‑ dɔ‑ ‑kaɔng do 'dhö 'mɛ‑ ‑gɔ bha‑ ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'Yö 'mɛ 'wo bha 'wo‑ pö‑ ‑dhɛ: «'Yö n Dëmɛ, ‑a ‑kaɔng do 'dhö 'mɛ 'kö‑ ‑gɔ 'yö 'i‑ pö 'zü 'yi‑ 'bha nu yö ꞊në‑ ‑dhɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'A‑ zë ka ‑dhɛ ꞊sii ꞊dede ‑ta ꞊dhɛ: ‑A 'bha 'dhö 'mɛ 'ö‑ ‑gɔ 'ö‑ ‑ziö 'gü ‑ziö ꞊në 'wo dho‑ ‑mɛ taa kë, \"kɛɛ pë 'bha 'yaa 'mɛ 'kö‑ ‑gɔ, ‑a 'dhɛ 'në ‑zian 'ö‑ ‑gɔ ('ö 'yaa‑ ‑ziö 'gü ziö) bha ꞊në 'wo dho‑ 'sü‑ ‑gɔ do. ");
INSERT INTO daf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","꞊Ya 'go yö ‑zë 'gü, 'mɛ 'wii \"wɩ‑ ‑bha kö 'a kë‑ ‑nu ‑bha ‑gblüdë 'ka bha, ‑ka nu‑ ‑nu 'ka kö 'ka‑ ‑nu zë n \"yaan yö!» ");
INSERT INTO daf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","꞊Dhɛ 'ö ꞊ya ö bo dhiang ‑nu bha‑ ‑nu zë ‑sü 'ka, 'yö ‑da mɛ kpö bha‑ ‑nu ‑dhɛ \"dhiʋ̈, 'yö 'wo dho Zedhizadhɛmö. ");
INSERT INTO daf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","꞊Dhɛ 'ö ꞊wa 'dho 'ö ꞊ya ꞊loo Bɛfaze ‑pö waa‑ Betani ‑pö ‑nu \"sɔɔ, ‑tɔn 'wo‑ ‑dhɛ Odhivie ‑tɔn bha‑ \"pɛan \"piʋ̈, 'yö ö ‑bha ꞊klang ‑nu bha‑ mɛ ꞊plɛ bɔ, 'yö‑ pö‑ ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«‑Ka 'dho 'pö‑ 'ö ‑ya kwa wëëdhö bha‑ 'gü. 'Ka ‑da 'plöö ka ‑dho ꞊soofëng 'në do 'ö mɛ 'bha 'yii ‑ya ‑ta do ‑a yö kö ‑yö ‑kplü ‑sü 'ka, 'ka‑ yö ‑kaa \"pʋ kö 'ka nu‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mɛ ꞊ya ka dhɛɛ\" 'kpɔ ꞊yaa‑ pö: «Ka‑ ‑pʋ kö 'ka‑ kë ꞊dhɛ?», ‑kaa pö‑ ‑mɛ ‑dhɛ: «Yi dëmɛ ‑mawɔn ꞊ya zun‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","'Mɛ 'ö‑ ‑nu bɔ \"dhʋ̈ bha 'yö 'wo dho. 'Yö 'wo ‑kpan ꞊soofëng 'në bha‑ ‑bha ꞊dhɛ ‑kɔ 'ö‑ pö‑ 'ka bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","꞊Dhɛ 'wo ꞊soofëng 'në bha‑ \"pʋ sië, 'yö‑ ‑mɛ ‑nu ‑wo nu 'wo‑ ‑nu dhɛɛ\" kpɔ 'wo‑ pö: «Ka‑ ‑pʋ ‑më ‑wɔn 'gü?» ");
INSERT INTO daf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'Yö 'wo‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'wo‑ pö: «Yi Dëmɛ ‑mawɔn ꞊ya zun‑ ‑bha.» 'Yö 'mɛ 'wo bha 'wii \"wɩ. ");
INSERT INTO daf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","'Yö 'wo‑ sü 'wo dho‑ 'ka Yesu ‑dhɛ. ꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo‑ 'ka Yesu ‑dhɛ 'gü, 'yö 'wo woo‑ sɔ ‑nu ꞊loo‑ ‑ta, 'yö 'wo Yesu ‑ya ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","꞊Dhɛ 'ö ꞊soofëng 'në bha 'ö zun \"ta 'sü ‑sü ‑bha, 'yö mɛ ‑nu 'wo sɔ kpɔ zian ‑ta ‑dhɛ ꞊gban 'gü 'wo dho‑ 'ka \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","꞊Dhɛ 'ö ꞊wa 'dho 'ö 'wo Odhivie ‑tɔn bha‑ lɔɔ‑ sië 'kö ꞊wa ꞊yɔɔn Zedhizadhɛmö ‑pö \"sɔɔ, 'yö‑ ‑bha ꞊klang ‑nu bha‑ ‑nu ꞊gban \"pɛpɛ 'wo wo ‑wʋ \"dhiʋ̈ ꞊wlü, 'yö 'wo zun Atanna 'tɔ bhɔ ‑sü ‑bha kö ‑a ‑nu ꞊nii ‑yö ‑da sië ꞊dedewo \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu 'ö Yesu ‑ya ‑kë 'wo‑ ‑dhɛ yö bha‑ ‑wɔn 'gü ");
INSERT INTO daf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","'yö 'wo‑ pö: «‑Gblüdë 'ö nu kwa Dëmɛ ‑bha nu 'gü bha, ‑a 'tɔ ‑yö bhɔɔ! ‑Ya ‑dɩ 'flëë‑ 'gü ‑sü ‑yö kë dhang‑ 'gü kö Atanna 'ö dhang‑ 'gü ‑a 'tɔ‑ bhɔɔ!» ");
INSERT INTO daf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","꞊Dhɛ 'wo‑ pö sië \"dhʋ̈, 'yö Fadhiziɛn ‑nu ga bha ‑wo bɔ mɛ \"dhaa bha‑ 'gü 'wo‑ pö Yesu ‑dhɛ: «Yi Dëmɛ, ‑a pö i ‑bha ꞊klang ‑nu ‑dhɛ kö ‑wo wo \"dhi ta!» ");
INSERT INTO daf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: ««A‑ ‑pö ka ‑dhɛ ꞊dhɛ kö 'mɛ 'wo bha ‑wo wo \"dhi ta, ‑gwë ‑nu ‑dho \"wɩ!» ");
INSERT INTO daf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","꞊Dhɛ 'ö ꞊wa ꞊yɔɔn 'pödhɛ \"sɔɔ, 'yö Yesu zun \"gbʋ bɔ ‑sü ‑bha Zedhizadhɛmö ‑pö 'gü ‑mɛ ‑nu bha 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«Zedhizadhɛmö ‑mɛ ‑nu, ꞊ya kë 'nu ꞊dhɛ 'wɔn 'ö dho ka gba ‑ya ‑dɩ 'flëë‑ 'gü ‑sü 'ka, 'ö kë sië ka ‑dhɛ ꞊dɛɛ ya, ka‑ ‑dɔ 'nu, kö ka ‑bha ‑dho kë ‑së. \"Kɛɛ ‑kaa ‑ga ꞊tɔn 'ö 'yaa \"dhʋ̈, 'yö ‑bin ‑sü 'ka ka ‑gɔ 'yö 'kaa‑ yö bha. ");
INSERT INTO daf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","‑Ka ‑dhɛ ‑ga, ‑a dɔ 'ö 'kii‑ wo bha‑ ‑wɔn 'gü, \"tʋ̈ng 'bha ‑dho ꞊loo 'ö ka 'yaɔ‑ ‑nu 'wo nu 'wo \"saan ‑kan kaa‑ 'pö‑ ya‑ ‑zü, 'ö ‑gblü ‑yö 'gba dɔ ka ‑bha 'ö 'wo ka ꞊klëën zian ꞊gban ‑zian ꞊gban 'ka, 'ö 'wo ka ꞊kang. ");
INSERT INTO daf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","‑Wo ‑dho kaa‑ 'pö‑ ya‑ 'wü ‑trukpɛ ‑trukpɛdhö, 'ö mɛ do ‑zian 'yaa 'to \"yaan, 'ö 'wo dho 'wo wo ‑gɛn ‑ziö ‑a \"yʋʋ 'gü, 'ö‑ 'kɔ \"kpan ‑gwë do ‑zian 'yaa 'to 'ko ‑ta, ‑a ‑gɛn ‑mü ꞊dhɛ \"tʋ̈ng 'ö Atanna ‑ya sü kö 'ö \"ta‑ 'ka ka ‑dhɛ bha 'kii‑ dɔ.» ");
INSERT INTO daf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","꞊Dhɛ 'ö dho 'ö ꞊loo Zedhizadhɛmö, 'yö dho 'ö ‑da Atanna ‑dhɔkëgükɔ 'gü, 'ö dho ‑yö ‑kpan \"dhɔɔdɔmɛ ‑nu ‑bha mü kö ‑wo woo‑ pë 'në ‑nu \"dhɔɔ dɔ sië. 'Yö ‑ya ‑a ‑nu \"piʋ̈ kë ‑sü ‑bha ");
INSERT INTO daf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kö ‑ya pö sië‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Yö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü ꞊dhɛ ‑a ‑bha 'kɔ‑ ‑dho kë ‑bhɛa 'gü ‑kɔ ꞊në‑ 'ka, \"kɛɛ yö ꞊në ka ‑zë 'ka‑ kë ꞊kwaanmɛ ‑nu ‑ya 'gü ‑yɛ ꞊në‑ 'ka bha!» ");
INSERT INTO daf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","‑A \"tʋ̈ng bha‑ 'gü, ‑yö gun 'dho sië yi ꞊gban \"pɛpɛ 'ka Atanna ‑dhɔkëgükɔ 'gü, 'ö mɛ ‑nu ꞊klang ‑nu ‑kë ‑nu wo, \"kɛɛ 'sa kö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu oo, 'tɔnggɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha ‑kwɛagbö ‑nu ‑wa \"slë mɔɔ‑ sië kö 'wo‑ zë. ");
INSERT INTO daf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","\"Kɛɛ ‑kɔ 'ö woo‑ kë‑ 'ka kö‑ ‑nu ‑kɔ ꞊mɔɔ‑ ‑bha 'wii‑ yö, ‑a ‑gɛn ‑mü ꞊dhɛ kö \"sɛgümɛ ‑nu ꞊gban \"pɛpɛ ‑wo wo \"tʋ 'to sië‑ ‑wʋ bha‑ ‑bha 'wo‑ din yö ꞊dedewo 'ö 'wo‑ tɛandhɛ ‑nu ꞊gban yö. ");
INSERT INTO daf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yi do 'bha bha‑ 'ka kö Yesu ‑yö 'wɔn ‑taɔng ‑së pö sië \"sɛgümɛ ‑nu ‑dhɛ, 'ö‑ ‑nu ꞊klang ‑kë ‑a ‑wɔn 'ka Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gü, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu 'wo nu waa‑ 'tɔnggɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu 'dhö, ");
INSERT INTO daf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'yö 'wo‑ pö Yesu ‑dhɛ: «'Wɔn ‑nu 'i‑ kë sië ya i‑ ‑kë de ꞊në‑ ‑bha kë 'gü \"ɛɛn i‑ ‑sabho de \"dhiʋ̈?» ");
INSERT INTO daf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'Yö ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Kwa‑ ma, a ‑dho ‑a ‑yɔ bɔ, \"kɛɛ a ‑dho ka dhɛɛ\" do 'kpɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kaa ‑dɩ 'pö Zan ‑bha mɛ ‑bɔ Atanna 'ka ‑zʋ 'ö gun‑ wo sië ya, ‑yö ‑gun ‑sabho sië de ꞊në‑ \"dhiʋ̈? Mɛ \"bhɩɩ‑ ‑nu ‑ee, \"ɛɛn Atanna ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","꞊Dhɛ 'ö‑ pö \"dhʋ̈, 'yö 'wo ‑ya ‑wɩ 'gü ‑sü ‑bha wo 'ko ꞊zinng 'gü 'wo‑ pö: «Ya kë ꞊dhɛ 'kwa‑ pö ‑yö ‑go Atanna \"piʋ̈, kö yöö‑ pö kwa ‑dhɛ yö kë ‑mü ꞊dhɛ 'sa 'yö 'kii 'dhang bho‑ \"dhiʋ̈, ");
INSERT INTO daf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","\"kɛɛ ꞊ya kë 'zü ꞊dhɛ 'kwa‑ pö ‑yö ‑gun kë sië mɛ \"bhɩɩ‑ ‑nu ꞊në‑ ‑nu ‑bha kë 'gü, kö \"sɛgümɛ ‑nu ꞊gban \"pɛpɛ woo (꞊wɛɛ dɔ kwa ‑bha) kö ‑wo kwa ‑zuö ‑gwë 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ ‑wo 'dhang ‑bho \"dhiʋ̈ ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ꞊në gun Zan 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","꞊Dhɛ 'ö ꞊waa‑ zɔn‑ 'gü \"dhʋ̈, 'yö 'wo‑ pö Yesu ‑dhɛ 'waa‑ 'go ‑dhɛ dɔ. ");
INSERT INTO daf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'Yö ‑yɔ bɔ‑ ‑nu ‑gɔ 'pö 'ö‑ pö: «Mang ‑dɩ 'pö, 'wɔn 'a‑ kë sië bha 'mɛ 'a‑ kë‑ ‑bha kë 'gü 'maa‑ dɔ.» ");
INSERT INTO daf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","‑Yö ‑to ‑dhɛ bha‑ 'gü 'yö \"gwënng do 'bha ‑da \"sɛgümɛ ‑nu ‑dhɛ 'ö‑ pö: «Mɛ do 'bha ꞊në gun, 'yö ö ‑bha ‑drɔɔdhɛ kpɔ, 'yö dho 'yö‑ ‑da buzan 'gü 'yö dho \"ta ꞊gblɛɛn 'bha 'gü. ");
INSERT INTO daf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","꞊Dhɛ 'ö ‑drɔɔ bha‑ ga bho \"tʋ̈ng ꞊ya ꞊loo, 'yö ö ‑bha gwëëmi do bɔ buzankëmɛ ‑nu bha‑ ‑nu \"piʋ̈, kö ‑wa 'gü ‑gblü kö ‑wo ö ‑bha dɔ‑ ‑gɔ kö ‑yö nu‑ 'ka ö ‑dhɛ, \"kɛɛ 'yö buzankëmɛ ‑nu bha 'wo gwëëmi bha‑ ‑ma ‑tëkë ‑tëkëdhö, 'yö 'wo‑ \"piʋ̈ kë 'yö dho ö ‑kɔ 'gü \"fië 'ka ö dëmɛ ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","'Yö ꞊slëë 'zü 'ö mɛ \"wɛɛ do 'bha bɔ, 'yö 'wo‑ kun 'zü 'wo‑ ‑ma ‑tɛkpɛ ‑tɛkpɛdhö, 'yö 'wo \"si bho‑ ‑gɔ, 'yö 'wo‑ ‑kë 'yö dho ö ‑kɔ \"fië 'ka ö dëmɛ ‑ta 'pö. ");
INSERT INTO daf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'Yö dho 'zü 'ö‑ mɛ ‑yaaga ‑naa bɔ. Yö ‑zë 'ö ꞊loo mü, ‑a ‑gi ꞊në 'wo‑ wo, 'yö 'wo‑ ‑kë 'yö dho. ");
INSERT INTO daf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","꞊Dhɛ 'ö mɛ 'dhɛ bha 'ö dho, 'yö ‑drɔɔdhɛ dëmɛ ‑ya pö: «‑Kaa 'to \"dhʋ̈! 'Mɛ 'a‑ ‑nu bɔ bha kë 'wo‑ wo mɛ \"wɛɛ 'ka 'yö ‑kë, ‑ka dɔ kö 'a n ga 'gü ꞊në ꞊dede bɔ, 'bha mü \"dhʋ̈ ‑wo ‑dho yö ‑zë ‑ya ꞊bhlëë 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","\"Kɛɛ ꞊dhɛ 'ö‑ gbö ꞊ya 'dho ꞊ya ꞊loo mü, 'ö buzankëmɛ ‑nu bha ꞊waa‑ yö 'yö 'wo‑ pö: «‑An aaan‑! Mɛ ꞊dede 'ö‑ ‑bha 'kɛanpë 'dhö ‑mü 'yö nu bha, yö ꞊në zëmɛ ‑zian 'ka, yö ‑zë 'kwa‑ zë kö ‑dhɛ ya ꞊ya 'to kwa ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Yö 'wo ‑pö ‑ta 'wo‑ kun 'yö 'wo go‑ 'ka ‑drɔɔdhɛ 'gü, 'yö 'wo‑ zë.» ꞊Dhɛ 'ö bo \"gwënng bha‑ ‑da ‑sü 'ka, 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Yö ka 'gü ꞊dhɛ ꞊ya kë \"dhʋ̈ bhao‑, 'bhlaamɛ bha ‑yö ‑dho buzankëmɛ ‑nu bha‑ ‑nu kë ꞊dhɛ ꞊taamasü 'gü? ");
INSERT INTO daf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","‑Yö kë ka \"yaan ꞊dhɛ ꞊ya nu, ‑yö ‑dho buzankëmɛ ‑nu bha‑ ‑nu zë ꞊në‑ wo kö ‑yö ö ‑bha 'bhlaa‑ 'sü ‑ya dɔ mɛ \"wɛɛ ‑nu ‑gɔ. ꞊Dhɛ 'ö \"sɛgümɛ ‑nu ‑wo 'wɔn bha‑ ma 'yö 'wo‑ pö: «'Wɔn 'dhɛ 'kö bha‑ yaa ‑yö dɔ mɛ 'ka ꞊gblɛɛn ‑wa.» ");
INSERT INTO daf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","\"Kɛɛ ꞊dhɛ 'wo‑ pö \"dhʋ̈, 'yö Yesu ‑ya ‑nu ‑ta ‑ga 'yö‑ pö: «꞊Ya kë \"dhʋ̈ 'sa kö‑ pö 'ö Atanna ‑wʋ 'sëëdhɛ ‑ya wo ꞊dhɛ: ‹‑Gwë 'ö 'kɔdɔmɛ ‑nu ‑wa ‑zuö bha ꞊në kë ‑kë 'kɔ \"kpan ‑ya ‑ta ‑gwë 'ka› bha kö ka‑ 'klɔɔ‑ ‑dɔ ꞊naa bha \"wɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A‑ ‑pö ka ‑dhɛ ꞊dhɛ mɛ \"ʋʋ mɛ 'ö yaa‑ ‑pö ‑gwë bha‑ ‑ta, ‑a ‑mɛ \"dhiʋ̈ ‑dho \"yɛ, \"kɛɛ 'sa ‑gwë bha yaa‑ ‑pö mɛ \"ʋʋ 'mɛ 'ö‑ ‑ta, ‑yö ‑dho ‑a ‑mɛ ‑bʋ̈ʋ̈ bho. ");
INSERT INTO daf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","\"Saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu ‑gun ‑a \"slë mɔɔ‑ sië kö wo ‑kɔ yö wɔ‑ ‑ta ‑dhɛ do bha‑ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊waa‑ 'wɔn dɔ ꞊dhɛ ‑yö \"wɩ sië wo ꞊në wo 'ka bha, \"kɛɛ kö ‑wo \"suʋ̈ sië \"sɛgümɛ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'wo mɛ bɔ kö ‑wo 'kpɔ‑ ‑dhɛ \"yɛɛdhö kö ‑wa ‑gɛn mɔɔ‑. 'Mɛ 'wo \"dhʋ̈ bha, 'yö 'wo wo ‑dɩ ‑kë ꞊dhɛ 'wɔnsëkëmɛ 'dhö, 'yö 'wo dhɛɛ\" \"kapɩ ‑kapɩ ‑nu kpɔ‑ ‑gɔ, kë \"dhʋ̈ kö ꞊ya 'kɔn‑ ‑gɔ \"kwëë ‑dhɛ 'ö‑ 'gü kö 'wo‑ 'kun 'wo 'dho‑ 'ka \"sɛgɔdhiʋ̈mɛ ‑nu ‑kuu \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","'Yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi Dëmɛ, yi 'wɔn ‑dɔ ꞊dhɛ 'bhaa ꞊sua kë, ꞊dhɛ pë \"pɛpɛ 'i yi ꞊klang ‑kë 'ka bha tɛan‑ ‑mü, ꞊ya 'go mü 'zü, 'bhaa ‑kpla mɛ 'bha ‑bha ‑kë ‑tiandhö ‑sü ‑gɔ kö i 'kpɔ tɛanwɔn 'ka, Atanna ‑bha zian ꞊në 'i‑ ‑zɔn mɛ ‑dhɛ ꞊sii ꞊dede ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","‑A ‑kë \"dhʋ̈ ‑sü 'gü, yi 'nii‑ sɔng ‑bho \"sɛkɔɔnmɛ 'kpii‑ ‑dhɛ ‑sü ya, këwɔn ‑mü \"ɛɛn këwɔn 'yaa ‑mü?» ");
INSERT INTO daf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","꞊Dhɛ 'ö Yesu ‑ya ‑nu ‑bha \"kpënng‑ bha‑ 'gü yö, 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka nu \"tanmaga do 'ka!» ");
INSERT INTO daf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","꞊Dhɛ 'wo nu‑ 'ka, 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «De ꞊në‑ 'tɔ waa‑ \"blɛɛn‑ 'wo \"tanmaga bha‑ ‑ta bha?» 'Yö 'wo‑ pö‑ ‑dhɛ «Wlɔmö ‑mɛ ‑nu ‑bha ‑gblüdë 'kpii‑ ‑mü.» ");
INSERT INTO daf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","'Yö‑ pö: «꞊Dhɛ 'ö \"dhʋ̈ 'sa kö pë 'dhɛ 'ö Sezaa ‑bha 'ka, ‑kaa bho ‑gblüdë 'kpii‑ ‑dhɛ, kö pë 'dhɛ Atanna ‑bha 'ka 'ka‑ bho‑ ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","꞊Dhɛ 'ö‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈, 'ö 'mɛ 'wo‑ ‑nu bɔ ‑a ‑wʋ mɔɔ‑ ‑dhɛ 'gü bha 'wii ‑yɛ yö dhiang ‑yɔ 'ö‑ bɔ mɛ kpö bha‑ 'gü bha‑ ‑bha ‑dhɛ 'bha ‑dhɛ 'bha 'gü, ‑a 'wɔn ‑zian ꞊në‑ ‑nu kɔn, 'yö 'wo wo \"dhi ta. ");
INSERT INTO daf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","'Mɛ 'wo ‑kë Sadusiɛn ‑nu 'ka, 'ö 'wo ‑zë 'waa 'dhang bho 'mɛ ꞊ya ga ‑a ‑bö ‑wɔn \"dhiʋ̈ bha, yi do 'ka 'yö‑ mɛ ga 'bha 'wo dho Yesu \"piʋ̈, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Yi Dëmɛ, 'pë Moizö ‑ya ‑bɛn zë yi ‑dhɛ ‑a ‑ga 'ö ya, ‑ya pö ꞊dhɛ: ‹'Mɛ 'ö dhe 'dhö‑ ‑gɔ, ꞊ya kë ꞊dhɛ ꞊ya ga kö 'në 'yaa‑ ‑gɔ, ‑a ‑mɛ 'zlaa‑ ‑ya ‑bha dhebhɔ bha‑ 'sü kö wɛng ‑wo 'në 'kpɔ, kö ‑yö kë 'mɛ 'ö ga bha‑ suu 'ka.› ");
INSERT INTO daf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","\"Kɛɛ ‑bhö ‑a ‑ga kö dheebhang ‑zë ‑nu \"saɔplɛ 'wo gun, kö mɛ ‑blɛɛsü ‑yö dhe 'sü kö ‑yö 'dho ‑yö ga kö 'yii 'në 'kpɔ ꞊kö. ");
INSERT INTO daf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kö‑ mɛ ꞊plɛ ‑naa waa‑ mɛ ‑yaaga ‑naa ‑wo 'dho kö ‑wa ‑bha dhebhɔ bha‑ 'sü kö‑ ‑nu 'bha 'wii 'në 'kpɔ. ");
INSERT INTO daf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kö mɛ \"saɔplɛ bha‑ ‑nu ꞊gban ‑wo 'dho kö ‑wo dhe bha‑ 'sü kö waa‑ \"wɛɛ 'bha 'wii 'në 'kpɔ tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kö ‑yö to‑ 'ka \"dhʋ̈ kö‑ dhebhɔ bha ‑yö ga 'pö. ");
INSERT INTO daf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","꞊Ya kë \"dhʋ̈, gamɛ ‑nu bhɔ ‑yi bha ꞊ya ꞊loo, dhebhɔ bha ‑yö ‑dho kë 'mɛ 'wo bha‑ de ‑sü 'pö‑ ‑bha dhebhɔ 'ka kpɛnngdhö, \"kɛɛ kö ‑a ‑nu ꞊gban ‑wo kë 'ke‑ ‑kë dhebhɔ bha‑ ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Mɛ 'wo ꞊dɛɛ ‑yën ya‑ 'gü ꞊në‑ ‑nu ‑mawɔn 'dhö dhe 'sü ‑sü waa‑ gwaan‑ 'kpɔ ‑sü ‑bha, ");
INSERT INTO daf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","\"kɛɛ 'mɛ 'kö 'wo dho kë ‑tosɛakëmɛ 'ka ‑dhɛkpaɔ dhia\" 'gü, ‑tosɛa ‑dee 'ö Atanna dho‑ kë bha‑ 'gü kö ꞊wa ‑bö ꞊wa 'go ga 'gü bha, wo ‑zë ‑a ‑nu ‑mawɔn 'yii 'dho kë dhe 'sü ‑wɔn \"ɛɛn gwaan‑ 'kpɔ ‑wɔn ‑bha; ");
INSERT INTO daf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","‑a ‑gɛn ‑mü ꞊dhɛ kö 'wii 'dho ga 'zü tongtongdhö, \"kɛɛ kö woo kë ꞊dhɛ Atanna ‑bha \"kië ‑nu ꞊në 'dhö ꞊taamasü 'gü, kö 'go 'wo‑ wo ga 'gü bha ꞊wa kë Atanna ‑bha 'në 'ka. ");
INSERT INTO daf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","꞊Ya 'go yö ‑zë 'gü, ꞊ya 'to‑ 'dhɛ 'kö ‑gban gamɛ ‑nu ‑bö ‑wɔn ‑bha bha‑ ‑bha, 'pë 'ö Moizö ‑ya ‑bɛn zë yi 'bha 'ka ö ‑gɔ 'sëëdhɛ 'gü, 'ö ‑gban ‑kpɔɔ kpö 'ö \"gʋ̈ sië‑ ‑bha bha ‑ya ‑zɔn ꞊dhɛ 'yaa ꞊sua 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ Moizö ‑yö Atanna ‑dhɛ ‑dhɛ bha ꞊në‑ 'gü Ablaamö ‑bha Atanna, Izaakö ‑bha Atanna, Zakɔbö ‑bha Atanna. ");
INSERT INTO daf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","\"Kɛɛ 'sa a‑ ‑pö ka ‑dhɛ ꞊dhɛ mɛ 'dhɛ 'kö Atanna ‑ya 'tɔ pö ö ‑bha \"dhʋ̈ bha, ‑a ‑nu ꞊gban ‑wo \"yaanmɛ ꞊në‑ 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ 'kö 'wii kë \"yaandhe 'ka kwa kpö 'gü ꞊dɛɛ, \"kɛɛ ‑a ‑nu ꞊gban \"pɛpɛ ‑wo \"yaan Atanna ‑zë ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","꞊Dhɛ 'ö‑ pö \"dhʋ̈ 'ö ö bo, 'yö 'tɔnggɔmɛ ‑nu bha‑ mɛ ga 'bha 'wo‑ pö‑ ‑dhɛ 'wo‑ pö: «'A, n Dëmɛ, i dɔ ‑zë ‑wo mɛa‑ dhiang ‑nu ‑yɔ bɔ ‑dhɛ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","'Ö go yö ‑zë 'gü, Sadusiɛn ‑nu bha 'wii‑ dhɛɛ\" \"wɛɛ 'bha 'kpɔ 'zü. ");
INSERT INTO daf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑ya pö 'pö‑ ‑nu ‑dhɛ 'ö‑ pö: «꞊Ya kë \"dhʋ̈ 'sa kö ‑a pö 'wo‑ wo sië ꞊dhɛ 'mɛ 'ö Atanna ‑bha ‑Yamɛ 'ka bha Davi suu ‑mü bha‑ ‑gɛn ‑mü ‑më 'ka, ");
INSERT INTO daf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","\"kɛɛ kö Davi yöö ꞊dede ‑ya ‑pö ö ‑bha \"tan 'ö‑ bho Atanna ‑dhɛ bha‑ 'sëëdhɛ 'gü Klisi bha‑ ‑bu 'gü ꞊dhɛ: ‹Kwa Dëmɛ ‑ya ‑pö n Dëmɛ ‑dhɛ: ‑Bhö ‑ya ‑duɛ ‑së 'ö n ‑kɔ ‑së ‑ta ya‑ 'gü ꞊kö ");
INSERT INTO daf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kö ‑yö 'dho \"dhʋ̈ ‑yö zun‑ 'ka yi 'a dho i 'yaɔ‑ ‑nu kë‑ 'ka i ‑gɛn ‑dɔ ‑ta ‑pë 'ka› bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","꞊Ya kë \"dhʋ̈ 'mɛ 'ö Davi ‑zë ‑ya ‑dhɛ ö Dëmɛ bha ‑yö ‑mɔɔ ‑bha 'ö ‑kë ‑a bhaa 'në 'ka ‑kɔ ‑kë ꞊dhɛ? (\"Kɛɛ 'yö‑ ‑yɔ 'yii ꞊slɔɔ‑ ‑nu ‑gɔ.) ");
INSERT INTO daf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","꞊Dhɛ 'ö dhiang ‑nu bha‑ ‑nu zë sië \"dhʋ̈, 'ö mɛ ꞊gban \"pɛpɛ 'wo \"tʋ 'to sië‑ ‑wʋ ‑bha, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«‑Ka ka ‑dɩ 'kun ‑së 'tɔnggɔmɛ ‑nu ‑gɔ! ‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'wo bha ‑tɔyang ꞊gblɛɛngblɛɛn ꞊në‑ ‑da ‑dhɔ ‑ya ‑nu ‑kë kö 'wo ꞊nië‑ 'ka ‑dhɛ ‑nu 'gü kö 'wa ꞊loo \"dhɛɛdhɛ ‑nu 'gü kö ‑wo zun‑ ‑nu ‑dhɛ kpiö 'gü kö ‑wa ‑nu ꞊bhlëë ‑ya. ‑Yɛa ‑blɛɛsü ‑nu bha ꞊në 'wo‑ ꞊mɔɔ Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu waa‑ dɔtadhɛ ‑nu 'gü kö 'wo ‑ya 'gü. ");
INSERT INTO daf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","\"Kɛɛ ꞊wa 'go mü kö ‑wo 'dho sië 'wo ꞊gɛandhe ‑nu ‑ta ‑bhö, ꞊wa 'go mü ꞊wa ꞊loo mɛ ‑nu \"yan \"dhiʋ̈, 'yö 'wo ꞊bhɛa Atanna ‑dhɛ ‑kɔ 'gü ꞊gblɛɛngblɛɛn ‑nu bha‑ ‑kë, (kë \"dhʋ̈, kö 'wo bhɔ mɛ ‑nu 'gü Atanna dhɔɔbhaawɔn kë ‑mɛ ‑nu ‑bha, \"kɛɛ kö 'waa‑ \"gblʋʋ ‑zian ‑bha). A‑ ‑pö ka ‑dhɛ ꞊dhɛ 'wɔn 'ö Atanna dho‑ wɔ 'mɛ 'wo bha‑ ‑nu ‑ta, ‑a \"dhiʋ̈‑ ‑dho ziö mɛ ꞊gban ‑bha ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","꞊Dhɛ 'ö Yesu ‑yö ö bo ‑a ‑pö \"dhʋ̈ ‑sü 'ka, 'yö ö ‑gɔ \"dhiʋ̈ ꞊wlü. 'Ö dho ‑dhɛ ‑ga kö ꞊naɔmɛ ‑nu ‑wo gbaɔ sië Atanna ‑gɔ, kö ‑wa 'wëë‑ ‑da sië 'pë 'wo‑ nu Atanna ‑dhɛ ‑a ‑da 'gü ‑pë 'ö‑ ‑dhɔkëgükɔ 'gü bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","\"Kɛɛ kö ꞊gɛandhe ‑wëësü 'në do 'bha bha 'pö \"tanmaga ꞊plɛ ‑ya ꞊kwɛɛ‑, kö ‑ya ‑da sië mü 'pö. ");
INSERT INTO daf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","'Yö Yesu ‑ya pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ \"tanmaga ꞊plɛ 'ö ꞊gɛandhe ya 'ö‑ ꞊gbaɔ Atanna ‑gɔ ya, ‑yö 'gbiin‑ 'ö ‑ziö mɛ 'wo bha‑ ‑nu ꞊gban \"pɛpɛ ‑bha ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","‑A ‑gɛn ‑mü ꞊dhɛ wo ‑zë ‑a ‑nu ‑kɔ ꞊në‑ ‑nu 'kën ‑gu ‑ta, 'yö‑ 'dhɛ 'ö‑ ‑nu \"yan 'yaa ‑kë 'ka ‑pë \"dhiʋ̈ bha 'wo‑ ꞊gbaɔ Atanna ‑gɔ, \"kɛɛ ꞊gɛandhe 'në ‑wëësü 'kö pë 'bhaa‑ ‑gɔ 'ö dɔ bha, a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'pë ꞊ya 'to‑ 'nu‑ ‑gɔ ‑a ‑bha ‑bhöpë sɔng ‑zian 'ka ‑a ‑kpɛa ꞊në 'ö‑ nu Atanna ‑dhɛ bha. ");
INSERT INTO daf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","'Ö gun kö mɛ 'bha ‑nu ‑wo Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ ‑kë ‑së ‑dhiang zë sië, ‑gwë suu ‑nu 'wo‑ sü 'wo 'kɔ bha‑ dɔ‑ 'ka waa‑ pë ‑nu 'wo‑ ꞊gbaɔ Atanna ‑gɔ 'wo mü bha‑ ‑wɔn 'gü, 'yö Yesu ‑yö dhiang do zë 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«‑Ka ‑dhɛ ‑ga, ‑a yi ‑yö nu sië 'ö ‑gwë ‑sɛngbɔ ‑nu 'ka‑ ‑ga sië bha, 'ö‑ ꞊gban ‑yö ꞊loo, 'ö‑ do ‑zian 'yaa 'to 'ko ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi Dëmɛ, ‑a 'wɔn bha ‑yö ‑dho kë \"dhʋ̈ ‑më \"tʋ̈ng ꞊në‑ 'gü? \"Ɛɛn ꞊yaa‑ pö 'ö kë yi ‑dho ‑a 'suan‑ bho ‑më ‑nu ꞊në‑ ‑bha?» ");
INSERT INTO daf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Kaa kë ‑së kö 'wa 'dho \"kpënng‑ kë ka ‑gɔ 'wo ka ‑pö; ‑a ‑gɛn ‑mü ꞊dhɛ mɛ 'gbɛ‑ ‑dho nu n 'tɔ 'gü, 'ö 'wo‑ pö ka ‑dhɛ ꞊dhɛ n nu \"tʋ̈ng ꞊ya ꞊loo, \"ɛɛn wo ꞊në 'wo n 'ka, \"kɛɛ ꞊waa‑ pö \"dhʋ̈, 'ka 'dho‑ ‑yɔ bɔ. ");
INSERT INTO daf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","꞊Ya 'go yö ‑zë 'gü, ka ‑dho ‑a ma ka \"tʋ 'ka ꞊dhɛ ‑wo ‑gblü gɔɔn sië ‑dhɛ ‑nu 'wo ꞊ni ‑a ‑nu 'gü, \"ɛɛn \"sɛgɔ ‑nu \"yan ‑yö dɔ sië ‑gɛan. ꞊Ya kë \"dhʋ̈ ka \"gblʋ̈ʋ̈dhɛ 'ya 'dho \"muu bho, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'wɔn ‑nu bha ‑wo kë ꞊kö ‑blɛɛsü. \"Kɛɛ yö ‑zë 'yii 'dho kë \"sɛ \"dhiʋ̈todhɛ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","\"Sɛgɔ 'bha‑ ‑dho \"wlü 'ö dho ö ‑gblü ‑da ‑a 'bha ‑ta, 'ö ‑gblüdë 'bha ‑yö ꞊wlü 'ö dho 'ö ‑pö mɛ 'bha ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'Ö \"sɛ ‑yö ꞊zii ‑kɔ ‑ziisü ‑ziisü ‑nu ‑kë, 'ö \"vʋ̈ʋ̈ 'dhö ‑da ‑dhɛ ‑nu 'gü 'zuuzudhö 'ö 'ka‑ ma, 'ö \"yua yaya ‑nu 'wo sɔ. 'Ö \"dhabhliwɔn ‑nu 'ö ꞊ya kë 'ö \"suʋ̈ ‑da mɛ 'gü 'ö ‑kë dhang‑ 'gü ‑dhɛ ‑nu 'gü 'ka‑ yö. ");
INSERT INTO daf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","\"Kɛɛ \"sanni 'wɔn ‑nu bha‑ ꞊gban \"pɛpɛ ‑yö kë, ‑wo ‑dho ka 'kun ꞊kö ‑blɛɛsü 'wo ka ‑wëë ‑kë ꞊gban \"pɛpɛ suu wo, 'ö wo ka \"dhiʋ̈ dɔ pë ‑gɔ, 'ö 'wo 'wɔn bho ka 'gü Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü, 'ö 'wo ka ‑da ‑nu wo ‑kaso 'gü, 'ö 'wo dho ka 'ka ‑gblüdë ‑nu waa‑ \"sɛgɔdhiʋ̈mɛ ‑nu ‑kuu \"dhiʋ̈ n 'tɔ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'Wɔn ‑nu bha ‑wo ‑dho kë ka 'ka \"dhʋ̈, \"kɛɛ ‑a ‑gɛn ‑mü ꞊dhɛ kë \"dhʋ̈ kö 'ka \"sɛɛdhɛ kë n ‑bha ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","A‑ ‑pö \"dhʋ̈ kö ‑yö 'to ka \"yaan kö ‑a yi ꞊ya ꞊loo kö ka ‑dɩ ‑ta ‑za dɔ ‑wɔn ‑zʋgɔndhe 'ya 'dho ‑ya ka ‑bha, ");
INSERT INTO daf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","‑a ‑gɛn ‑mü ꞊dhɛ ka ‑ziö dhiang 'gü \"tʋ̈ng ꞊ya ꞊loo kö ꞊wa 'dho ka 'ka ‑gɔmɛ ‑nu ‑kuu \"dhiʋ̈ (dhiang 'ö kaa‑ zë ma ꞊në 'a dho‑ dɔ ka \"dhi). Ma ꞊në 'a dho \"yaaki nu ka ‑dhɛ. \"Yaaki ‑zian 'a dho‑ nu ka ‑dhɛ bha, ‑yö ‑dho ziö ka ‑da ‑mɛ ‑nu ‑bha ‑ta, 'ö‑ ‑nu \"dhi kun 'ö 'ka dhiang ‑yɔ bɔ, 'ö 'pë woo‑ pö ka ‑dhɛ 'ö ꞊dhɛng‑ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mɛ 'wo ‑kë ka 'kpɔmɛ ‑nu 'ka waa‑ ka dheebhang ‑nu, 'mɛ 'ö kɛng‑ ‑nu ka suu 'dhö do, \"ɛɛn ka \"taɔngdë ‑nu ‑zian ‑dho ka \"dhiʋ̈ dɔ ka 'yaɔ‑ ‑nu ‑dhɛ. ‑Wo ‑dho mɛ ga 'bha zë ka \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ka ‑san ‑dho mɛ ꞊gban \"pɛpɛ kë n ‑wɔn 'gü, ");
INSERT INTO daf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","\"kɛɛ yö ꞊në‑ ꞊gban 'gü, ka wun \"dhɛ 'ö ka ‑gɔ ‑bha bha‑ do ‑zian 'yii 'dho ꞊dhɛng Atanna ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","꞊Ya kë ꞊dhɛ yö ꞊në ꞊ya 'kun bho ka 'gü, kö 'kii bo n 'ka, 'yö 'ka dho ‑da ꞊sii 'ö yaa yën ‑a kë ‑dhɛ 'gü ‑dhɛkpaɔ dhia\" 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","'Yö Yesu ‑yö go mü 'ö‑ pö: «꞊Ya 'go yö ‑zë 'gü, yi 'ö 'ka dho‑ ma‑ 'ka ꞊dhɛ ‑gblü ꞊ya 'gba dɔ Zedhizadhɛmö ‑dhɛ ‑bha ‑dhɛ ꞊gban \"pɛpɛ 'gü ꞊ya ꞊klëën‑ 'ka‑ ‑zü, ‑yö kë ka \"yaan ꞊dhɛ kö ‑a 'wü \"tʋ̈ng ꞊ya ꞊loo. ");
INSERT INTO daf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","‑A yö ‑zë ꞊ya kë \"dhʋ̈, 'mɛ 'wo dho kë Zude ‑sɛ 'gü ‑a \"tʋ̈ng bha‑ 'gü, ‑wo ‑bɛang sü kö ‑wo 'dho ‑tɔn ‑gbeng 'gü ‑dhɛ ‑nu 'gü. Kö 'mɛ 'wo Zedhizadhɛmö ‑pö yaan‑ ‑bha ‑wo ‑da \"bü, kö 'mɛ 'ö wo ‑zë waa‑ ‑kë gbɛɛ ‑ta ‑dhɛ ‑nu 'gü, 'wa 'dho ‑nu 'plöödhɛ mɔɔ‑. ");
INSERT INTO daf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑dho 'wɔn bho ka 'gü 'yi bha ꞊në‑ 'ka, kë \"dhʋ̈ kö 'wɔn \"pɛpɛ 'ö ‑bɛn zë ‑sü 'ka‑ ‑bha 'sëëdhɛ 'gü bha‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","‑A \"tʋ̈ng bha‑ 'gü, dhong ‑nu 'wo dho kë 'gbiödhe 'ka, \"ɛɛn 'ö 'në dho kë‑ ‑nu ‑gɔ \"yɔn ‑bha, ‑a ‑nu ‑bha ‑dho kë ‑wëësü; ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑dho ö ‑mawɔn ‑siö \"sɛgɔ ya‑ 'gü mɛ ‑nu 'ka \"tʋ̈ng bha ꞊në‑ 'gü, 'ö \"sɛ ya‑ 'gü ‑mɛ ‑nu 'wo ‑kë ‑wëëwëësü ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","'Mɛ 'waa Atanna dɔ ‑a ‑nu ‑bha ‑gblü ‑kɔ ‑dho ꞊mɔɔ‑ ‑nu ‑bha, 'ö 'wo‑ ‑nu kun ꞊dhuëng 'ka, 'ö 'wo dho nu‑ 'ka \"sɛgɔ ꞊gban \"pɛpɛ 'do 'do 'gü, 'ö \"sɛ \"wɛɛ 'gü ‑mɛ ‑nu 'wo ꞊taa Zedhizadhɛmö ‑dhɛ ‑ta, 'ö 'wo‑ ‑da wo ‑gɛn ꞊wlöö 'ö dho‑ 'ka \"dhʋ̈ 'ö zun‑ 'ka‑ ‑nu ‑bha \"tʋ̈ng 'ö Atanna ‑ya ‑ya ‑a ziö ‑yi ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","꞊Ya 'go yö ‑zë 'gü, \"dhabhliwɔn ‑dho kë 'ö 'ka‑ ‑dhɛ yö 'yënng‑ waa‑ \"su waa‑ \"susëngga ‑nu ‑bha. \"Suʋ̈‑ ‑dho ‑da \"kpʋngtaamɛ ‑nu 'gü, 'ö \"sika ‑yö ‑da ‑nu 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a \"tʋ̈ng bha‑ 'gü, ꞊weeyi ‑dho ö kpö kë ꞊dhɛ ‑tɔn 'dhö 'ö ꞊loo 'ö dho 'ö ‑zuö ‑yuudhö. ");
INSERT INTO daf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","‑A \"tʋ̈ng bha‑ 'gü, mɛ 'bha ‑nu ‑dho ga zuëdhiʋ̈tɛɛ ‑gɔ kö ‑wo wo ‑zʋ 'gɔn sië 'wɔn ‑nu 'wo dho wɔ \"kpʋngtaadhɛ ‑ta bha‑ 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha 'gügbɩɩdhɛ 'ö dhang‑ 'gü bha ‑yö ‑dho ꞊loo 'yi bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","‑Wo ‑dho mang Mɛgbömɛ n yö \"tʋ̈ng bha ꞊në‑ 'gü kö a nu sië dha 'kpong‑ ‑ta ma mɛdhɛ ‑faan \"gbɩɩ‑ bha‑ 'ka waa‑ 'tɔbhɔdhe ‑ziisü 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","꞊Ya kë ꞊dhɛ 'ka 'wɔn ‑nu bha‑ ‑dhɛ yö \"tʋ̈ng 'ö‑ 'gü kö ꞊ya kë ‑sü ‑zü bho, ‑ka dɔ ꞊zinng 'gü kö 'ka ka ‑gɔ \"dhiʋ̈ \"wlü, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö kë sië \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü kö ka ‑bho 'wɔn 'gü \"tʋ̈ng ꞊ya \"gan klöö‑.» ");
INSERT INTO daf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","'Yö 'wɔn ‑zɔn 'ka do ‑zɔn ‑a ‑nu ‑dhɛ 'ö‑ pö: «‑Ka figö ‑dhü ‑nu waa‑ \"dhü \"wɛɛ 'dhɛ ‑nu 'wo to ‑a ‑nu ‑ga kö 'ka 'wɔn 'suan‑ bho‑ ‑bha:. ");
INSERT INTO daf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","‑a ‑gɛn ‑mü ꞊dhɛ 'ka‑ ‑nu yö kö ‑wo wo ‑trɔng ‑dee ‑ya sië, kö 'ka‑ 'wɔn dɔ ꞊dhɛ dha \"yi ꞊ya ꞊tëng. ");
INSERT INTO daf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","꞊Ya kë 'pö ꞊dhɛ ka \"yan 'dhö ‑da sië 'wɔn ‑nu bha‑ ‑nu kë ‑dhɛ 'gü, ‑yö kë ka \"yaan ꞊dhɛ Atanna ‑bha ‑gblüdëdhɛ ‑ya dun ka ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: 'Wɔn ‑nu bha‑ ꞊gban ‑dho kë kö 'mɛ 'wo \"tʋ̈ng ya‑ 'gü ya‑ ‑nu ꞊gban 'wii ga ꞊kö. ");
INSERT INTO daf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","‑A ‑gɛn ‑mü ꞊dhɛ \"sɛ waa‑ dhang‑ ‑wo ‑dho ziö, \"kɛɛ n ‑wʋ ‑zë 'yii 'dho bho‑ ‑bha tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesu ‑ya ‑pö ‑nu ‑dhɛ yö ꞊në‑ ‑wɔn 'gü 'ö‑ pö: «‑Kaa kë ka 'suan‑ 'ka kö ka ‑gɔ 'ya 'dho 'to pë ‑së ‑bhö ‑sü waa‑ we mü ‑sü \"ɛɛn ‑ya \"kpʋngtaapë ‑nu ‑wɔn zuën ‑ta ‑sü 'ö \"dhiʋ̈ ziö 'ka‑ ‑bha, 'ö yi bha 'ö nu 'ö ‑kan ka 'gü; ");
INSERT INTO daf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","‑a ‑gɛn ‑mü ꞊dhɛ yi 'ö bha‑ nu ‑sü ‑dho kë ꞊dhɛ \"nuu 'ö \"yibhakëmɛ ‑nu ‑wa ‑zuö \"yi ꞊bhaa bha ꞊në‑ 'dhö 'ö ‑kan \"kpʋngtaamɛ ꞊gban \"pɛpɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","‑A ‑kë \"dhʋ̈ ‑sü 'gü, ‑ka ‑ya ka \"yaan kö 'ka bhɛa\" Atanna ‑dhɛ \"tʋ̈ng ꞊gban 'gü, kë \"dhʋ̈ kö 'ka faan ꞊slɔɔ, kö 'wɔn \"pɛpɛ 'ö nu sië bha ‑yö 'kun bho ka 'gü, kö yi 'ö Mɛgbömɛ dho nu‑ 'ka bha ‑yö ‑kpan ka ‑bha ‑dɔ ‑gɛan ‑sü 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","\"Tʋ̈ng 'ö Yesu ‑ya ‑kë Zedhizadhɛmö bha ‑dhɛ ‑ya ꞊kpaɔ ‑kɔ 'ö‑ 'gü 'do 'do 'yö dho Atanna ‑dhɔkëgükɔ 'gü, 'yö mɛ ꞊draan mü, \"bin 'dhö 'ma sië, 'yö dho ‑tɔn 'wo Odhivie ‑tɔn ‑kë bha‑ ꞊gbin‑ 'yö ‑wɔ mü. ");
INSERT INTO daf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","‑A ‑wɔn 'gü, \"sɛgümɛ ‑nu ꞊gban \"pɛpɛ ‑wo ‑gun ‑suʋ̈ sië ‑dhɛkpaɔ tii' 'gü, 'ö 'wo nu Atanna ‑dhɔkëgükɔ 'gü kö 'wo‑ ‑wʋ ma. ");
INSERT INTO daf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","'Ö gun \"dhʋ̈ kö 'bluu‑ 'ö \"sɛkɛ 'yaa‑ ‑bha 'wo‑ ‑bhö ‑troo 'ö‑ ‑ta 'wo‑ ‑dhɛ 'Pakö bha, ‑a yi ꞊ya 'to klöö‑, ");
INSERT INTO daf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","kö 'mɛ 'wo ‑kë \"saabhomɛ ‑nu ‑gɔmɛ ‑nu 'ka, waa‑ 'tɔnggɔmɛ ‑wa \"slë mɔɔ‑ sië kö 'wo Yesu 'kun, \"kɛɛ kö ‑wo \"suʋ̈ sië \"sɛgümɛ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","\"Kɛɛ 'sa Sɔtraan ‑yö ‑da Yesu ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ mɛ 'dhɛ 'wo‑ ‑dhɛ Zuda Isikadhiɔtö bha‑ ‑gɔ 'gü \"tʋ̈ng ꞊dede bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","'Yö ‑ziö 'ö dho ö ‑gɔ dun \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Atanna ‑bha 'kɔ ‑gɔdhiʋ̈mɛ ‑nu ‑gɔmɛ ‑nu 'ka kö ‑kɔ 'ö dho Yesu \"dhiʋ̈ dɔ‑ 'ka‑ ‑nu ‑dhɛ kö ‑wa ‑ya 'kwëë‑ kë. ");
INSERT INTO daf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","꞊Dhɛ 'ö dho 'ö‑ pö‑ ‑nu ‑dhɛ 'yö‑ 'gü ‑wɔn ‑yö ‑dhi ‑nu ‑dhɛ ꞊dedewo, 'yö 'wo‑ pö‑ ‑dhɛ ꞊yaa‑ yö ‑zë kë \"dhʋ̈, ‑wo ‑dho ‑a gba 'wëë‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","꞊Dhɛ 'ö bo ‑wɩ 'wɔn bha‑ ‑bha ‑sü 'ka, 'yö ‑ya ‑a \"slë mɔɔ‑ ‑sü ‑bha kö 'ö Yesu ꞊gbaɔ‑ ‑nu ‑gɔ mɛ ꞊gban tii' 'ka. ");
INSERT INTO daf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","‑Wo ‑to 'wɔn bha‑ ‑bha \"dhʋ̈, 'yö yi 'wo ‑tuʋ̈ ‑pë 'wo‑ zë troo bha‑ ‑ta bha‑ zë‑ 'ka bha 'ö ꞊loo. ");
INSERT INTO daf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","'Yö Yesu ‑yö Piɛdhö waa‑ Zan ‑a ‑nu bɔ, 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Ka 'dho kwa ‑bha Pakö ‑pë ‑kpa kö 'kwa‑ ‑bhö!» ");
INSERT INTO daf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'Yö 'mɛ 'wo bha 'wo‑ pö‑ ‑dhɛ: «‑Yö i \"piʋ̈ ꞊dhɛ 'yi‑ ‑kpa 'mɛ?» ");
INSERT INTO daf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","'Yö‑ pö: «‑Ka ‑dhɛ ‑ga, ꞊ya kë ꞊dhɛ 'ka 'dho 'ka ‑da Zedhizadhɛmö 'plöö, ka ‑dho ‑kpan mɛ do 'bha ‑bha kö \"yipë ‑ya ‑gɔ, 'ka‑ yö ‑ka ziö‑ ꞊keng‑ kö kɛng‑ ‑nu 'ka 'dho, 'kɔ 'ö yaa‑ ‑da 'gü bha kö 'ka ‑da ꞊keng‑ mü. ");
INSERT INTO daf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","꞊Ya kë ꞊dhɛ 'ka ‑da 'kɔɔdhö mü kö 'ka‑ pö‑ 'kɔ dë ‑dhɛ: «'Kɔ dë, yi Dëmɛ ‑ya ‑pö ‑dhɛ 'ö waa‑ ö ‑bha ꞊klang ‑nu 'wo dho 'Pakö ‑pë ‑bhö ‑bha 'i‑ ‑dhɛ ‑zɔn yi ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","'Ka‑ pö‑ ‑dhɛ \"dhʋ̈ ‑yö ‑dho 'kɔdhi ‑mɔɔbhasü 'ö‑ 'gü ‑dhɛ 'dhö ‑pë kë ‑sü 'ka, 'ö ‑yatapë ꞊gban 'dhö mü, ‑a ‑dhɛ ‑zɔn ka ‑dhɛ 'kɔ ‑ta \"dhʋ̈ng 'gü. ‑Dhɛ 'ka dho kwaa‑ Pakö ‑pë ‑kpa ‑bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Yö 'mɛ 'wo bha 'wo dho, 'yö ‑kɔ do 'ö Yesu ‑ya pö‑ 'ka bha 'yö ‑kë 'pö‑ ‑kɔ ‑bha \"kpʋ̈üdhö, 'yö 'wo Pakö pë ‑kpa mü. ");
INSERT INTO daf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","꞊Dhɛ 'ö ꞊wa wo bo pë bha‑ ‑kpa ‑sü 'ka 'ö‑ ‑bhö \"tʋ̈ng ꞊ya ꞊loo, 'yö Yesu waa‑ ö ‑bha bɔmɛ ‑nu 'wo ‑ya pëpë \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","'Yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «Pakö ‑pë 'dhɛ 'kwa‑ ‑bhö sië ya ‑a 'gü ‑wɔn ‑yö ‑dhi n ‑dhɛ ꞊dedewo, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑gun n \"piʋ̈ ꞊dhɛ‑ do 'dhɛ 'kö ya 'kwa‑ ‑bhö kwa \"kwëë gbonggbongdhö kö 'a gun ‑na saan\". ");
INSERT INTO daf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ 'mii 'dho‑ 'bha ‑bhö \"kpʋng ya‑ ꞊taa 'zü 'ö dho 'ö zun‑ 'ka ‑a 'klɔɔ‑ zun zang ‑ta ‑sü ('ö n ga ‑sü 'ka) bha‑ ‑bha, 'ö dho 'ö zun‑ 'ka‑ 'dhɛ 'kwa dho‑ ‑bhö Atanna ‑bha ‑gblüdëdhɛ 'gü bha‑ yi ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'ö ꞊ya ö bo, 'yö ö ‑kɔ ‑da we ‑kɔɔ 'gü, 'yö Atanna nuɛ\" bho 'yö‑ pö: «‑Ka we ‑kɔɔ ya‑ 'kun kö 'ka‑ 'gü ‑gblü ka 'ko ‑ta; ");
INSERT INTO daf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","‑a ‑gɛn ‑mü ꞊dhɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ ‑drɔɔ ga \"yi 'ö ya 'mii 'dho‑ mü 'zü tongtongdhö 'ö dho 'ö zun‑ 'ka Atanna ‑bha ‑gblüdëdhɛ nu ‑yi ‑bha.» ");
INSERT INTO daf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","꞊Dhɛ 'ö ö bo‑ pö \"dhʋ̈ ‑sü 'ka, 'yö ö ‑kɔ ‑da 'bluu‑ 'gü, 'yö Atanna nuɛ\" bho. ꞊Dhɛ 'ö ꞊ya ö bo, 'yö‑ \"kplü \"kplü bho 'yö‑ 'gü ‑gblü ‑a ‑nu ‑ta 'yö‑ pö: «‑Ka ‑dhɛ ‑ga, n kwi 'a‑ nu ka ‑wɔn 'gü bha‑ \"blɛɛn‑ ꞊nɛ, 'ka kë ‑kaa ‑bhö ꞊sië kö ka ‑zʋ ‑yö ‑bö n ‑wɔn ‑ta ‑kpɛawo.» ");
INSERT INTO daf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","꞊Dhɛ 'wo wo bo pë ‑bhö ‑sü 'ka, 'yö wekɔɔ sü 'zü ‑kɔ do bha‑ 'gü, 'yö‑ nu‑ ‑nu ‑dhɛ 'yö‑ pö: «N ꞊yɔɔn 'ö woo‑ ꞊wɛnng kö ‑yö kë ‑mlɛɛ ‑dee 'ö maa ‑da n Dë Atanna waa‑ mɛ \"bhɩɩ‑ ‑nu ‑a ‑nu ꞊zinng 'gü ‑a ‑gɛn 'ka bha‑ \"blɛɛn‑ ꞊nɛ. ");
INSERT INTO daf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","\"Kɛɛ 'sa 'mɛ 'ö dho n ‑da pë ꞊kwɛɛ‑ \"dhʋ̈ bha, yɛng ꞊në yi ‑kɔ 'dhö pëfië do 'gü ya!» ");
INSERT INTO daf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","\"Kɛɛ a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ mang Mɛgbömɛ ga 'ö maa‑ wo ya 'a‑ wo \"dhʋ̈ kö 'wɔn 'ö Atanna ꞊yaa‑ ‑bɛn zë 'nu ꞊ya bo bha ‑ya yö ꞊në‑ 'gü ‑wɔn kë, \"kɛɛ 'mɛ 'kö dho 'wɔn bha‑ ‑gbɔ dɔ ö ‑dɩ ꞊gbin‑ ꞊në‑ ‑mɛ ‑bha 'dhö ‑wëësü! ");
INSERT INTO daf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑bha ꞊klang ‑nu 'wo ‑ya wo 'ko ‑nu dhɛɛ\" 'kpɔ ‑sü ‑bha kö 'mɛ 'ö dho 'wɔn bha‑ kë 'wo‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","‑Wo ‑to ‑dhɛ do bha‑ 'gü, 'yö Yesu ‑bha ꞊klang ‑nu bha 'wo ‑ya wo 'ko zaɔ‑ ‑sü ‑bha ‑duɛ 'kpiidhɛ ‑wɔn 'gü, ");
INSERT INTO daf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Gblüdë ‑nu 'wo \"kpʋng ꞊taa ‑a ‑nu ‑kɔ ‑yö ‑mɔɔ woo‑ \"sɛgümɛ ‑nu ‑bha, 'ö 'wɔn 'ö ‑dhi ‑nu ‑dhɛ 'wo‑ ‑wɔ ‑nu ‑ta, \"kɛɛ 'ö ꞊wa 'go mü 'wo‑ pö wo ‑gɔmɛ ‑nu këwɔn ‑yö ‑së. ");
INSERT INTO daf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","\"Kɛɛ ka ‑zë ka ‑bha 'ya 'dho kë \"dhʋ̈. Ka ‑zë 'mɛ 'ö‑ ‑duɛ dho kë 'kpii‑ ka kpö 'gü, ‑a ‑dhɛa ‑bha ꞊dhɛ yö ꞊në ‑yö kë ꞊dhɛ mɛ ꞊gban ka ‑da ꞊wlöö 'dhö, kö mɛ 'ö ka ‑gɔdhiʋ̈ ꞊në ‑yö kë ꞊dhɛ ka \"dhiʋ̈ ‑ziöwomɛ 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","\"Ɛɛn mɛ ꞊plɛ ꞊wa kë kö mɛ do ‑yö kë pë ‑bhö ‑dhɛ 'gü, kö mɛ do ‑ya \"dhiʋ̈ ‑ziö wo kö mɛ ꞊plɛ 'wo bha 'dee 'kpii‑? Kö 'mɛ 'wo‑ \"dhiʋ̈ ‑ziö wo sië bha 'yaa ‑mü ‑ee? \"Kɛɛ ‑kaa ‑ga 'ö ma ‑zë 'ma kë ka kpö 'gü ꞊dhɛ ka \"dhiʋ̈ ‑ziöwomɛ 'dhö bha. ");
INSERT INTO daf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ka ‑zë ka ꞊në 'ka 'to n ꞊keng‑ 'ö 'kwa ‑ziö 'wɔn \"gbɩɩ‑ \"pɛpɛ 'ö ‑wɔ n ‑ta ‑a ꞊gban 'gü. ");
INSERT INTO daf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yö ꞊në ‑wɔn 'gü, 'yö 'a ‑gblüdëdhɛ nu ‑sü 'ka ka ‑dhɛ ꞊dhɛ ‑kɔ do 'ö n Dë ‑ya nu‑ 'ka n ‑dhɛ ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kë \"dhʋ̈ kö kwɛng‑ ‑nu 'kwa ‑kɔ ‑da pëfië do 'gü ma ‑gblüdëdhɛ ‑ya ‑bha ‑yi 'ka, kö 'ka ‑ya 'pö ‑blüdëdhɛ ‑gbloo ‑nu 'gü kö 'ka Izraɛdhö \"sɛgɔ ‑kaɔng do ga ꞊plɛ bha‑ 'mɛ 'ö 'dhö ‑a ‑duɛ ‑zɔn.» ");
INSERT INTO daf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka, 'yö‑ pö Piɛdhö ‑dhɛ: «Piɛdhö, Sɔtraan ꞊ya ka ‑gbadhɛ Atanna ‑gɔ kö 'ö ka ‑piö ꞊dhɛ ‑kɔ 'wo ‑mlü ‑piö 'ka 'ö‑ ꞊flee ‑yö go‑ 'gü bha‑ 'dhö, ");
INSERT INTO daf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","\"kɛɛ 'ma bhɛa\" Atanna ‑dhɛ i ‑wɔn 'gü kö i ‑bha 'dhang ‑bho n \"dhiʋ̈ ‑sü 'bha 'ya 'dho \"kan‑ ‑ta 'ö 'i ‑kan n ‑bha. 'Bha i ‑dɩ ꞊slɔɔ yi 'ö‑ 'ka kö i zuë\" ꞊ya 'waanu, bhii ‑dɩ 'pö 'i i dheebhang ‑nu 'ö kɛng‑ ‑nu 'ka bɔ n 'ka bha‑ ‑nu ‑zʋ ‑gban.» ");
INSERT INTO daf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","'Yö Piɛdhö ꞊ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N Dëmɛ, ‑a \"sɩ 'yaa n ‑dhɛ kö 'a \"kan i ‑bha. 'Kö ꞊ya kë ga ‑zian 'ka kwa ‑dho ‑a wo kwa \"kwëë, ꞊ya kë 'zü dha ‑sü 'ka kwa ‑dho ‑a wo kwa \"kwëë.» ");
INSERT INTO daf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Piɛdhö, a‑ ‑pö i ‑dhɛ ꞊dhɛ \"sanni ‑tɔgɔn ‑yö \"wɩ gbeng 'ö ꞊dɛɛ 'gü, kö 'bha bo n 'ka ꞊dhɛ pë ‑yaaga 'dhö.» ");
INSERT INTO daf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","꞊Dhɛ 'ö go mü 'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «Ka bɔ 'a‑ wo \"tʋ̈ng 'bha 'gü, 'ö 'a‑ pö ka ‑dhɛ ꞊dhɛ 'ka‑ pö kaa 'dho 'ka 'dho ꞊kwɛɛsügüpë waa‑ 'wëë‑ ‑nu, 'waa ‑sabha ‑nu 'bha 'sü bha, ꞊dhɛ 'ö 'ka dho pë 'bha ‑kpla ‑yö kë ka ‑kun ‑ee?» 'Yö 'wo‑ pö‑ ‑dhɛ: «'Aa bhoo, pë 'bha ‑kpla 'yii yi 'kun.» ");
INSERT INTO daf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","'Yö‑ pö‑ ‑nu ‑dhɛ: «'Ka‑ pö 'ka 'dho ꞊taamasü ya‑ 'gü, 'mɛ 'ö‑ ‑bha 'wëëga 'dhö‑ ‑gɔ ‑yö ö ‑bha pë 'sü, ꞊kwɛɛsügüpë 'dhö 'mɛ 'ö‑ ‑gɔ ‑ya 'sü, kö 'mɛ 'ö ‑siangga 'yaa‑ ‑gɔ, ‑yö ö ‑bha ‑sɔ \"dhɔɔ dɔ kö ‑ya 'dhɔ; ");
INSERT INTO daf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü n ‑bu 'gü bha, ‑a 'gü ‑wɔn ‑yö kë ꞊dhɛ: ‹꞊Waa‑ dɔ 'wɔnyaakëmɛ ‑nu ‑bhiëë 'gü.› \"Kɛɛ 'sa 'wɔn 'ö ‑bɛn zë ‑sü 'ka n ‑bu 'gü, 'ö‑ këwɔn 'dhö 'dhö \"dhʋ̈ bha‑ kë \"tʋ̈ng ꞊ya ꞊tëng. Yö ꞊në dho kë 'wɔn 'ö Atanna ‑yö n bɔ‑ 'gü bha‑ ‑gɔ ‑da 'plöö ‑sü 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","'Yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, ‑siangga ꞊plɛ ꞊nɛ!» 'Yö‑ pö‑ ‑nu ‑dhɛ: «‑A 'dhɛ bha ‑yö 'to \"dhʋ̈, ꞊ya ꞊mɔɔ.» (‑A pö 'ö‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ 'pë 'ö‑ pö‑ ‑nu ‑dhɛ bha 'wii‑ 'gü ma ö 'klɔɔ‑ 'ka.) ");
INSERT INTO daf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu ‑gun 'dho sië Odhivie ‑tɔn ꞊gbin‑ zii 'kpa 'ö ꞊bhɛa Atanna ‑dhɛ mü, 'ö ꞊ya gun ꞊ya kë‑ 'tuʋ̈‑ 'ka. ꞊Dhɛ 'ö go 'kɔ bha‑ 'gü 'ö zun \"kpɛnng, ‑yö ‑ziö do 'ö ö wë dɔ Odhivie ‑tɔn ꞊gbin‑, 'yö‑ ‑bha ꞊klang ‑nu ‑dɩ 'pö 'wo ‑ziö ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","꞊Dhɛ 'wo dho 'wo ꞊loo mü, 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «‑Ka bhɛa\" Atanna ‑dhɛ kö 'ka 'dho ‑da Sɔtraan ‑gɔ döng 'gü!» ");
INSERT INTO daf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","'Yö yö ‑zë 'ö bhɔ 'në 'bha wo‑ ‑nu ‑dhɛ taa‑ 'bleng ‑bleng 'yö zun ö kpiö 'gü, 'yö zun ‑bhɛa Atanna ‑dhɛ ‑sü ‑bha 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«N Dë Atanna, ꞊ya kë ꞊dhɛ ꞊ya ga i 'gü kö 'wɔn \"gbɩɩ‑ 'ö maa‑ \"yi mü ya 'i n dha‑ ‑gɔ, ‑yö ‑dho ‑dhi n ‑dhɛ, \"kɛɛ yö ꞊në‑ ꞊gban 'gü, 'yaa n \"piʋ̈ ꞊dhɛ ‑yö 'to ma ‑zë n ‑bha ‑bha, ‑yö n \"piʋ̈ ꞊dhɛ bhi ꞊në i dhɔɔbhaa ‑yö kë.» ");
INSERT INTO daf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","‑Yö ‑to mü 'yö Atanna ‑bha \"kië do ‑yö go dhang‑ 'gü 'yö nu 'yö faan ‑sɛa ‑da 'gü. ");
INSERT INTO daf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","꞊Dhɛ 'kö 'ö‑ ‑ga ꞊dhɛ ga ‑zii ꞊ya kpa ö ‑ta, 'yö zun ‑bhɛa Atanna ‑dhɛ ‑sü ‑bha ö ‑sɔbhɛɛ ꞊dede 'ka, 'ö dɔ mü kö 'fëyi 'ö bhɔ sië‑ ‑bha 'ö ꞊loo \"sia‑ bha, ꞊ya kë ꞊dhɛ ꞊yɔɔn kpö kpö ꞊në‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","꞊Dhɛ 'ö ö bo, 'yö ꞊wlü 'ö dho ö ‑bha ꞊klang ‑nu ‑dhɛ 'gü, 'ö dho ‑yö ‑kpan ‑a ‑nu ‑bha kö ‑a ‑nu ꞊gban ꞊wa yi zë kplɔɔngdhö ‑wëë 'ö bɔ sië‑ ‑nu ‑ta bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","'Yö‑ pö‑ ‑nu ‑dhɛ: «Yi ‑zian ꞊në 'ka‑ zë sië ‑wa! A‑ ‑pö ka ‑dhɛ ꞊dhɛ 'ka \"wlü kö 'ka bhɛa\" kö Sɔtraan 'ya 'dho \"kpënng‑ kë ka ‑gɔ 'ö 'ka ‑da Atanna \"dhiʋ̈!» ");
INSERT INTO daf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","‑Yö ‑to dhiang bha‑ zë ‑dhɛ 'gü, 'yö mɛ kpö ‑yö ‑wo kö‑ ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ bha‑ mɛ 'dhɛ 'wo‑ Zuda ‑kë bha ‑ya ‑nu ‑dhɛ \"dhiʋ̈. ꞊Dhɛ 'wo nu, 'yö ꞊yɔɔn Yesu \"sɔɔ 'yö ꞊loo‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Zuda, 'wɔn 'ö i 'gü 'yö bha ‑ee? I mang Mɛgbömɛ n \"dhiʋ̈ ‑dɔ ‑loo n ‑bha ‑sü ꞊në‑ 'ka ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","꞊Dhɛ 'mɛ 'wo gun Yesu ꞊keng‑ bha‑ ‑nu \"yan 'dhö ‑da 'wɔn bha‑ ‑dhɛ 'gü, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi Dëmɛ, ‑yö mü ꞊dhɛ, 'yi 'mɛ 'wo‑ ya‑ ‑nu 'yën ‑siang 'ka ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","‑A ‑pö \"dhʋ̈ ‑sü ꞊në \"gbɩɩ‑ kö‑ mɛ do ꞊ya ‑siang bɔ ö ‑ta kö ꞊ya \"saabhomɛ 'kpii‑ ‑bha gwëëmi zë‑ 'ka‑ ‑kɔ ‑së 'gü \"tʋ kpö ‑bha kö ꞊yaa‑ bho mü. ");
INSERT INTO daf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","\"Kɛɛ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «꞊Ya ꞊mɔɔ! ‑Kaa 'to \"dhʋ̈.» 'Yö 'mɛ bha‑ \"tʋ kpö bha ‑sü 'yö‑ ‑ya mü ö \"gblʋʋ 'ka ‑deewo 'yö‑ ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑ya pö \"saabhomɛ ‑gɔmɛ ‑nu waa‑ Atanna ‑bha 'kɔ ‑maakëmɛ ‑nu ‑gɔmɛ ‑nu waa‑ ‑kwɛagbö ‑nu 'wo nu bha‑ ‑nu ‑dhɛ 'ö‑ pö: «Nu 'ka‑ wo n 'kun ‑dhɛ 'gü ꞊dhɛ mɛ‑ nu mɛzëmɛ 'kun, 'ö 'ka nu \"dhü ‑nu waa‑ ‑siang ‑nu 'ka ya‑ ‑gɛn ‑mü ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","\"Kɛɛ kö yi ꞊gban \"pɛpɛ 'ka, kwɛng‑ ‑nu kwa ‑gun Atanna ‑dhɔkëgükɔ 'gü ‑dhɛ do 'gü, 'yö 'kii n 'kun ‑a \"tʋ̈ng bha‑ 'gü, \"kɛɛ a‑ 'wɔn ‑dɔ ꞊dhɛ ka ‑bha \"tʋ̈ng ꞊në ꞊loo bha, ‑a ‑gɛn ‑mü ꞊dhɛ Sɔtraan 'ö ‑dhɛtiidhɛ ‑gɔmɛ 'ka bha, ‑a ‑kɔ ‑mɔɔ n ‑bha \"tʋ̈ng 'ö Atanna ‑ya ‑ya ꞊në ꞊loo bha. ");
INSERT INTO daf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","꞊Dhɛ 'wo Yesu kun, 'yö 'wo dho‑ 'ka \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ ‑gɔ \"kwɛandhö kö Piɛdhö ‑ya ꞊keng‑ \"kɛɛ kö ‑ya 'ka ꞊gblɛɛn. ");
INSERT INTO daf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","꞊Dhɛ 'wo dho 'wo ꞊loo \"kwɛandhɛ bha‑ 'gü, 'yö 'wo pɛng ‑ya 'dhuëng ‑ta \"kpɛnngdhö mü, 'yö 'wo ‑ya ‑bha. 'Yö Piɛdhö dho‑ ‑nu kpö 'gü mü 'yö 'yaanu. ");
INSERT INTO daf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","‑Wo ‑ya ‑zlëëdhö, 'yö gwëëdhe do 'bha bha 'ö Piɛdhö yö kö ‑yö ‑ya sië pɛng 'bhü \"dhiʋ̈, 'yö ö \"yan ‑gban 'gü zuudhö 'ö‑ pö: «'Mɛ 'ö ya ‑yö ‑gun 'mɛ 'wo‑ kun bha‑ ꞊keng‑ \"dhɛ!» ");
INSERT INTO daf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","\"Kɛɛ 'yö Piɛdhö ‑ya ꞊zaɔ‑ 'ö‑ pö: «'Maa 'mɛ bha‑ dɔ ‑wa, dhebhɔnë!» ");
INSERT INTO daf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","꞊Dhɛ 'ö‑ ‑dhɛ 'në bha ꞊ya ꞊gwëë, 'yö mɛ \"wɛɛ 'bha ‑ya yö 'zü 'yö‑ pö‑ ‑dhɛ: «'Mɛ 'wo bha‑ mɛ do ‑mü i 'ka \"dhɛ!» 'Yö Piɛdhö ‑ya pö: «'Aa, 'maa ‑mü ‑wa, gɔɔn‑ ‑së!» ");
INSERT INTO daf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","꞊Dhɛ 'ö \"tʋ̈ng 'bha ꞊ya ziö 'zü, 'yö mɛ do 'bha ‑yö ꞊nëng 'gü 'zü 'ö‑ pö: «'Mɛ 'ö ya ‑yö ‑gun 'mɛ bha‑ ꞊keng‑ tɛan‑ ꞊dede 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ Gadhidhe mi ‑mü, (mɛ ‑ya ‑dhɛ ‑yö ‑a \"dhi ‑wʋ ‑bha).» ");
INSERT INTO daf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'Yö Piɛdhö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Dhiang ‑zian 'i‑ zë sië bha n \"tʋ 'yaa‑ ‑bha.» Piɛdhö ‑to dhiang bha‑ zë ‑dhɛ 'gü ‑dhɛ do bha‑ 'gü 'yö ‑tɔgɔn ‑yö ‑wɩ. ");
INSERT INTO daf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","'Yö kwa Dëmɛ ‑yö ꞊slëë ö 'gü 'yö‑ ‑ga. 'Yö Piɛdhö ‑zʋ ‑yö ‑bö 'pö dhiang 'ö‑ zë‑ ‑dhɛ ‑blɛɛsü, 'ö‑ pö ꞊dhɛ \"sanni ‑tɔgɔn ‑yö \"wɩ, kö ꞊ya bo ö 'ka ꞊dhɛ pë ‑yaaga 'dhö bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","'Yö zun \"kpɛnng, 'yö zun \"gbʋ bɔ ‑sü ‑bha ‑wëëwëësü 'ka. ");
INSERT INTO daf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","\"Tʋ̈ng 'ö kë sië‑ 'ka \"dhʋ̈ bha kö 'mɛ 'kö‑ ‑nu ‑kɔ 'dhö gun Yesu ‑bha bha ‑wa ‑ma ꞊në wo sië 'ö 'wo ꞊wɛɛ dɔ‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","'Ö 'wo pë ‑kplü ‑a \"yan \"dhiʋ̈, ('wo‑ ‑ma) 'wo‑ pö‑ ‑dhɛ: «De ꞊në i ‑ma bha? ‑Bhö ‑a ‑mɛ 'tɔ pö, Atanna ‑wʋdhiʋ̈loomɛ!» ");
INSERT INTO daf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'Ö 'wo \"si ꞊gban ‑si ꞊gban suu bho‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","꞊Dhɛ 'ö ‑dhɛ ꞊ya ꞊kpaɔ, 'yö Zuifö ‑nu ‑bha ‑kwɛagbö ‑nu oo, \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu 'wo bho 'ko ‑ta, 'yö 'wo mɛ bɔ kö ‑wo nu Yesu 'ka wo ‑kuu \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","꞊Dhɛ 'wo nu‑ 'ka, 'yö 'wo‑ pö‑ ‑dhɛ: «꞊Ya kë ꞊dhɛ 'ö bhi ꞊në 'i Atanna ‑bha ‑Yamɛ bha‑ 'ka ꞊dedewo tɛan‑ 'ka, ‑bhö ‑a pö yi ‑dhɛ!» 'Yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «'Kö maa‑ pö ka ‑dhɛ \"dhʋ̈ ꞊wɛ, 'kii 'dho 'dhang bho‑ \"dhiʋ̈, ");
INSERT INTO daf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","'ma ka dhɛɛ\" ‑zian 'kpɔ, 'kii 'dho‑ ‑yɔ bɔ, ");
INSERT INTO daf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","\"kɛɛ 'wɔn 'ö tɛanwɔn 'ka yö ‑mü ꞊dhɛ ꞊ya 'go ꞊dɛɛ 'gü, mang Mɛgbömɛ, n ‑yɛa ꞊në dho kë n Dë Atanna 'ö‑ 'gü 'dhö \"gbɩɩ‑ bha‑ ‑kɔ ‑së 'gü dhang‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","'Yö‑ ‑nu ꞊gban \"pɛpɛ 'wo‑ pö: «'Bha‑ pö \"dhʋ̈ kö i‑ ‑pö ꞊dhɛ? Atanna Gbö ‑mü i 'ka ‑ee?» 'Yö‑ pö: «꞊Iin, yö ꞊në 'ka‑ pö bha, Atanna Gbö ‑mü n 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","꞊Dhɛ 'kö 'wo‑ ma \"dhʋ̈ bhoo 'yö 'wo‑ pö: «‑Më ‑wɔn ꞊në ka \"piʋ̈ ꞊dhɛ ‑ya pö ka ‑dhɛ 'zü‑ 'dhɛ 'kö bha‑ zian 'gü, \"kɛɛ kö yöö ꞊dede ‑a \"dhi ꞊yaa‑ pö kö 'kwa‑ ma?» ");
INSERT INTO daf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","꞊Dhɛ 'wo‑ pö \"dhʋ̈, 'yö 'mɛ 'wo bha‑ ꞊gban \"pɛpɛ 'wo ‑wlü 'wo ‑ta Yesu ‑bha, 'yö 'wo dho‑ 'ka Pidhatö ‑kuu \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","꞊Dhɛ 'wo dho 'wo ꞊loo mü, 'yö 'wo Yesu ‑da Pidhatö ‑dhɛ 'wo‑ pö: «Yi ‑kpan 'mɛ ya‑ ‑bha kö ‑yö ‑da sië \"sɛgümɛ ‑nu ‑gɔ 'gü, 'ö‑ pö‑ ‑nu ‑dhɛ 'wa 'dho 'nii‑ sɔng bho ‑gblüdë Sezaa ‑dhɛ, \"ɛɛn yö ‑zë Klisi ‑mü ö 'ka, ö \"dhʋ̈ kö ‑gblüdë ‑mü ö 'ka 'pö.» ");
INSERT INTO daf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","꞊Dhɛ 'ö ꞊waa‑ ‑da Pidhatö ‑dhɛ ‑wʋ bha‑ 'gü, 'yö Pidhatö ‑ya dhɛɛ\" kpɔ 'ö‑ pö: «I‑ ‑pö Zuifö ‑nu ‑bha ‑gblüdë ‑mü i 'ka tɛan‑ 'ka ‑ee?» 'Yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «Yö ꞊në 'i‑ pö sië bha.» ");
INSERT INTO daf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","'Yö Pidhatö ‑ya pö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ mɛ kpö 'wo gun 'mü bha‑ ‑nu ‑dhɛ 'ö‑ pö: «꞊Sɔng 'ö yöö kë 'mɛ 'ka nu‑ ka ya‑ ‑bha kö ‑yö kë‑ zë ‑gɛn 'ka 'mii‑ yö.» ");
INSERT INTO daf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","\"Kɛɛ 'yö 'wo ꞊nëng 'gü 'wo‑ pö: «Yi‑ ‑pö ‑yö ‑da ꞊në wo sië \"sɛgümɛ ‑nu ‑gɔ 'gü, 'ö‑ ‑nu ‑gɔ 'gü ꞊see dhiang ‑nu 'ö‑ zë wuudhö 'ö ‑ziö 'ka, 'ö zü bho Gadhidhe ‑sɛ 'gü 'ö ꞊ya bɔ‑ 'ka Zude ‑sɛ 'gü ‑dhɛ ꞊gban 'gü ꞊ya nu ꞊ya ꞊loo‑ 'ka yö bha‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","꞊Dhɛ 'ö Pidhatö ꞊ya Yesu 'tɔ ma Gadhidhe ‑dhɛ ‑bha, 'yö‑ ‑nu dhɛɛ\" kpɔ‑ ‑kë Gadhidhe mi 'ka ‑sü ‑wɔn 'ka. ");
INSERT INTO daf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","꞊Dhɛ 'kö 'wo bo‑ ꞊iin 'pö ‑sü ‑zë 'ka, 'ö‑ 'wɔn dɔ ꞊dhɛ ‑yö ‑go Gadhidhe, \"sɛgɔ 'ö Edhodö gun‑ ‑gɔdhiʋ̈ bha‑ 'gü, 'yö‑ bɔ Edhodö ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö Edhodö ‑yö Zedhizadhɛmö \"tʋ̈ng bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","꞊Dhɛ 'ö Edhodö ‑yö Yesu yö, ‑a 'gü ‑wɔn ‑yö ‑dhi ‑dhɛ ꞊dedewo, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö 'ö zun‑ \"slë mɔɔ‑ ‑sü ‑bha kö 'ö ‑kpan ‑bha kö‑ yi ꞊ya ꞊gwëë. Pë 'ö ‑kë 'yö gun‑ \"slë mɔɔ‑ sië kö 'ö‑kpan ‑bha bha, ‑a ‑gɛn ‑mü ꞊dhɛ kö ꞊yaa‑ ‑taɔng ma, 'yö gun ö ‑zʋ 'gɔn sië ꞊dhɛ 'ö ‑kpan ‑bha yi do 'ka kö ‑yö \"dhabhliwɔn ‑nu bha‑ 'bha kë ö \"yaan. ");
INSERT INTO daf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","‑A ‑wɔn 'gü ꞊dhɛ 'ö Yesu ‑yö ꞊loo mü, Edhodö ‑yö dhɛɛ\" 'gbɛ ꞊dede ‑kpɔ ‑gɔ \"kɛɛ 'yii‑ 'bha ‑yɔ bɔ. ");
INSERT INTO daf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'tɔnggɔmɛ ‑nu ‑wo mü, kö ‑wo wo ‑wʋ \"dhiʋ̈ \"wlü sië 'ö 'wo ꞊sua ‑ya ‑bha ‑a ‑san ‑bha ‑mawɔnyaadhɛ 'ka \"dhʋ̈ do. ");
INSERT INTO daf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","'Yö Edhodö waa‑ ö ‑bha \"sɔdha ‑nu 'wo zun ꞊wɛɛ ‑dɔ Yesu ‑bha ‑sü ‑bha kö‑ ‑san ꞊ya zun‑ ‑nu 'gü \"pɛɛpɛdhö. ꞊Dhɛ 'ö ꞊wa ꞊wɛɛ 'bha dɔ‑ ‑bha 'ö ꞊wa wo bo, 'yö Edhodö ‑yö sɔ ga do sü 'ö‑ ‑da ‑bha, 'yö‑ sü 'zü ‑deewo 'ö‑ bɔ Pidhatö ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","‑A \"tʋ̈ng bha‑ 'gü, kö Edhodö waa‑ Pidhatö 'waa ‑së, \"kɛɛ ‑wo ‑dhi wo 'ko ‑dhɛ yi do bha‑ ꞊në‑ 'ka, 'yö 'wo ‑kë \"taɔngdë ‑zë ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","꞊Dhɛ 'wo dho 'zü ‑deewo 'wo ꞊loo Pidhatö ‑kuu \"dhiʋ̈, 'yö Pidhatö ‑yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ mɛ ‑kiandhö ‑nu ꞊loo 'ko ‑ta waa‑ \"sɛgümɛ ‑nu 'dhö, 'yö‑ pö‑ ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","«'Mɛ 'ka nu‑ 'ka n ‑dhɛ ya ka‑ ‑pö ‑bha ꞊dhɛ ‑yö ‑da ꞊në wo sië \"sɛgümɛ ‑nu ‑gɔ 'gü kö 'wa 'dho yi ‑wʋ ma, \"kɛɛ ‑a dhɛɛ\" 'a‑ kpɔ kaa ꞊dede ka \"yaan ya, pë \"pɛpɛ 'ö 'ka‑ pö‑ ‑bha bha‑ 'bha 'kö 'a dho‑ yö ‑a ꞊sɔng 'gü 'yaa 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A‑ ‑sü 'a‑ bɔ Edhodö ‑dhɛ yö ꞊në‑ ‑wɔn 'gü, \"kɛɛ yöö ‑dɩ 'pö 'yii ꞊sɔng 'bha yö‑ ‑bha. Yö ꞊në‑ ‑wɔn 'gü 'yö ꞊yaa‑ bɔ 'zü ‑deewo kwa ‑dhɛ ya. ꞊Ya kë \"dhʋ̈ kö 'wɔn 'kö yöö kë mɛ ‑zë 'gü ‑wɔn 'ka, 'yii‑ 'bha kë. ");
INSERT INTO daf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","꞊Dhɛ 'ö \"dhʋ̈, a ‑dho ‑a pö kö ‑wa ‑wëëdhɛ bho ‑zë wo, \"kɛɛ ꞊waa‑ ‑ma 'bha wo a ‑dho n kwaa‑ ‑zü 'ö dho.» ");
INSERT INTO daf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'Ö \"dhʋ̈ bha kö Pakö yi ꞊ya ꞊loo ‑kɔ 'ö‑ 'gü 'do 'do, Pidhatö ‑yö ‑kasogümɛ do ‑lɔɔ Zuifö ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'mɛ 'wo bha 'wo ta wo 'gü 'wo ꞊gbla \"gbɩɩ‑ 'ka 'wo‑ pö Pidhatö ‑dhɛ 'wo‑ pö: «‑Bhö mɛ 'dhɛ 'kö bha ꞊në‑ zë kö 'i Badhabasö ‑zë lɔɔ‑ yi ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","\"Kɛɛ kö Badhabasö 'wo \"wɩ sië‑ 'ka bha, ‑wa ‑da ‑kaso 'gü \"dhinaa 'kpii‑ 'bha 'ö ‑da 'plöö mü bha waa‑ mɛ 'ö‑ zë ꞊në‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","'Yö Pidhatö ‑yö ö ‑kɔ ‑ya ‑nu zuë\" ‑ta 'zü ‑deewo kë \"dhʋ̈ kö ‑wo \"wɩ‑ ‑bha kö 'ö ö kwaa‑ Yesu ‑zü. ");
INSERT INTO daf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","\"Kɛɛ 'yö 'wii‑ ‑yɔ bɔ, 'yö 'wo ꞊gbla 'wo‑ pö: «‑A dɔ \"dhü ‑bha! ‑a dɔ \"dhü ‑bha!» ");
INSERT INTO daf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","'Yö Pidhatö ‑ya pö 'zü‑ ‑nu ‑dhɛ ‑gɛn ‑yan ‑yaaga ‑naa 'ka 'ö‑ pö: «‑Më ‑wɔn yaa ꞊në 'mɛ ya 'ö‑ ‑kë? A‑ ‑pö ka ‑dhɛ ꞊dhɛ ma ‑zë 'mii ꞊sɔng 'bha yö‑ ‑bha kö ‑yö kë‑ zë ‑gɛn 'ka. ꞊Dhɛ 'ö \"dhʋ̈, ꞊waa‑ ‑ma 'bha wo a ‑dho n kwaa‑ ‑zü.» ");
INSERT INTO daf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","\"Kɛɛ 'wii \"wɩ‑ ‑bha tongtongdhö, 'yö 'wo ꞊nëng 'gü 'yö 'wo ꞊gbang dɔ‑ 'ka ‑yuudhö ꞊dhɛ ‑wo Yesu ꞊në‑ zë. 'Yö‑ ‑nu ‑bha ‑yö to‑ ‑bha \"gbla 'wo‑ wo \"dhʋ̈ kpö 'ka bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","'Yö Pidhatö ‑ya pö: «‑Ɛɛ, ‑a 'dhɛ kaa‑ ‑pö ꞊në dho kë.» ");
INSERT INTO daf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","'Yö dho 'ö ö ‑kɔ bho \"dhinaa ‑damɛ, mɛzëmɛ 'kö bha yö ‑zë 'gü 'mɛ 'wo bha‑ ‑nu ‑dhɛ. 'Yö Yesu dɔ‑ ‑nu ‑gɔ kö 'pë 'ö ‑dhi ‑nu ‑dhɛ ‑wa kë‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","꞊Dhɛ 'ö \"sɔdha ‑nu ꞊wa Yesu 'kun 'wo dho sië‑ 'ka ‑a zë ‑dhɛ 'gü, 'yö 'wo dho 'wo ‑kpan Sidhɛnö mi do 'bha 'wo‑ ‑dhɛ Simɔ bha‑ ‑bha kö ‑yö 'go sië 'bhlaa‑, 'yö 'wo‑ kun 'pö 'wo Yesu ‑dɔ bha \"dhü bha‑ nu‑ ‑dhɛ kö ‑ya 'sü ‑yö 'dho‑ 'ka‑ ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","'Wo gun 'dho sië Yesu 'ka \"dhiʋ̈ kö mɛ kpö 'gbɛ ꞊dede ‑wa ꞊keng‑, kö dhong ‑nu 'gbɛ 'bha ‑nu ‑wo mü 'pö kö ‑wo wo ‑kuu ‑ta ‑ma sië \"gbʋ 'ka, 'ö 'wo ‑wëë ‑wʋ kpɔ Yesu ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","'Yö Yesu ‑yö ö wë bɔ‑ ‑nu ‑ta 'ö‑ pö: «Zedhizadhɛmö dhong ‑nu, 'ka 'dho \"gbʋ bɔ ma ‑zë n ‑bha, ‑ka \"gbʋ bɔ ka ‑dɩ ꞊në‑ bha waa‑ kaa‑ 'në ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‑A ‑gɛn ‑mü ꞊dhɛ \"tʋ̈ng 'bha‑ ‑dho ‑wo 'ö 'wo‑ pö ꞊gblöödhe ‑nu oo, 'mɛ 'wii 'në 'kpɔ do waa‑ 'mɛ 'wii \"yɔn nu 'në ‑dhɛ do ‑a ‑nu ‑bha ‑së! ");
INSERT INTO daf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","‑A \"tʋ̈ng bha ꞊në‑ 'gü, 'yö 'wo dho 'daɔnnu 'wo‑ pö ‑tɔn \"gblʋ̈gblʋ̈ ‑nu ‑dhɛ: «‑Ka nu 'ka ‑gblü yi ‑ta! ‑Tɔn 'sɛɛnnë ‑nu, ‑ka nu 'ka yi ‑ta kpa!» ");
INSERT INTO daf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","‑A ‑gɛn ‑mü ꞊dhɛ \"sanni ‑wo 'wɔn suu ya‑ wɔ \"dhü ‑sɛa ‑zë ‑ta, 'yö \"dhü \"kpɛa ‑zë ꞊wɛ?» ");
INSERT INTO daf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","\"Tʋ̈ng 'wo gun 'dho sië Yesu 'ka \"dhʋ̈ bha kö 'wɔnyaakëmɛ ‑nu \"wɛɛ ꞊plɛ 'wo 'dho sië‑ ‑nu zë 'pö ‑wo mü, ‑wo ‑gun 'dho sië waa‑ Yesu ‑nu ꞊gban ꞊në‑ ‑nu 'ka bha. ");
INSERT INTO daf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","꞊Dhɛ 'wo dho 'wo ꞊loo ‑tɔn 'wo‑ mɛ ‑gɔ \"kpɛa ‑tɔn ‑kë bha‑ ꞊gbin‑, 'yö 'wo Yesu waa‑ 'wɔnyaakëmɛ ‑nu ꞊plɛ bha‑ ‑nu ‑gban \"dhü ‑bha ‑dhɛ bha‑ 'gü. 'Yö 'wo‑ mɛ do bɔ Yesu ‑kɔ ‑së 'gü, 'yö 'wo‑ mɛ do bɔ ‑a ꞊kwaa 'gü, 'yö 'wo‑ dɔ‑ ‑nu ꞊zinng 'gü. ");
INSERT INTO daf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","\"Tʋ̈ng 'wo gun‑ dɔ sië‑ 'ka \"dhü ‑bha bha kö ‑yö ö zë ‑mɛ ‑nu \"dhiʋ̈ bhɛa\" wo sië‑ Atanna ‑dhɛ 'ö‑ pö: «N Dë, ‑bhö ‑a ‑nu ‑mawɔn 'to, ‑a ‑gɛn ‑mü ꞊dhɛ 'pë 'wo‑ kë sië bha 'waa‑ dɔ.» 'Yö 'wo zë \"kpʋ̈ü ‑kë ‑a ‑dasɔ ‑nu ‑ta, 'yö 'wo‑ 'gü ‑gblü wo 'ko ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","'Ö kë sië \"dhʋ̈ bha kö mɛ kpö 'kpii‑ bha ‑wo mü, kö ‑wa ‑dhɛ ‑ga sië. Kö Zuifö ‑nu ‑gɔmɛ ‑nu bha ‑wo ꞊wɛɛ dɔ sië Yesu ‑bha 'wo‑ pö: «꞊Ya kë ꞊dhɛ 'ö Klisi 'ka, 'ö 'mɛ 'ö Atanna ‑ya ‑ya ‑a 'ka ꞊dedewo tɛan‑ 'ka, ꞊ya mɛ ‑nu dha 'gbɛ, ‑yö ö ‑dɩ dha ꞊tɔn kö 'wo‑ ‑dhɛ yö!» ");
INSERT INTO daf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kö \"sɔdha ‑nu ‑dɩ 'pö 'wo ꞊wɛɛ dɔ sië‑ ‑bha 'pö, 'ö 'wo we din yaa 'bha bha‑ sü 'wo‑ nu‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","'Ö 'wo‑ pö: «'Bha kë Zuifö ‑nu ‑bha ‑gblüdë 'ka ꞊dedewo tɛan‑ 'ka ‑bhö i ‑dɩ dha kö 'kwa‑ ‑dhɛ ‑ga!» ");
INSERT INTO daf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kö ꞊wa pë ‑bɛn do 'bha zë kö ꞊waa‑ ꞊nëng \"dhü ‑bha ‑a ‑ta \"dhʋ̈ng 'gü ꞊dhɛ: «Zuifö ‑nu ‑bha ‑gblüdë ꞊nɛ». ");
INSERT INTO daf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kö 'wɔnyaakëmɛ ‑nu 'ö 'wo‑ ‑nu ‑dɔ \"dhü ‑bha ‑a \"sɔɔ mü bha‑ mɛ do ‑yö \"si bho sië‑ ‑gɔ 'pö 'ö‑ pö: «Atanna ‑bha ‑Yamɛ 'yaa ‑mü i 'ka ‑ee? ‑Bhö i ‑dɩ dha ꞊tɔn kö 'i yi dha 'pö ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","\"Kɛɛ kö‑ mɛ do ‑sü ‑zë ‑yö ‑dɔn bho sië ö \"tɛado 'ka 'ö‑ pö: «'Bhaa \"suʋ̈ ꞊në‑ wo Atanna ‑gɔ 'yö 'i dhiang zë \"dhʋ̈ ‑ee? \"Ɛɛn 'wɔn do 'ö wɔ sië‑ ‑ta bha 'aa mü 'ö‑ 'bha 'dhö wɔ sië i ‑ta 'pö bha ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yi ‑zë ‑zianwo yi ‑bha ‑zë ‑a ‑wɔ yi ‑ta \"dhʋ̈ ‑dhɛ ‑mü, ‑a ‑gɛn ‑mü ꞊dhɛ yi ‑zë 'wɔn yaa 'yi‑ ‑kë ꞊në‑ 'gü ‑wɔn 'dhö wɔ sië yi ‑ta, \"kɛɛ yö ‑zë ‑yö ‑më ‑wɔn yaa ꞊në‑ ‑kë?» ");
INSERT INTO daf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'Yö to 'mü 'ö‑ pö Yesu ‑dhɛ: «N Dëmɛ, yi 'i dho nu‑ 'ka i ‑bha ‑gblüdëdhɛ 'gü, 'i dɔ \"gbɩɩ‑ kö i ‑zʋ ‑yö ‑bö n ‑wɔn ‑ta.» ");
INSERT INTO daf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «A‑ ‑pö i ‑dhɛ ꞊sii ꞊dede ‑ta ꞊dhɛ kwa ‑dho ‑da ‑yɛa ‑së 'ö n Dë Atanna \"piʋ̈ bha‑ 'gü ‑dhɛkpaɔyi do 'ö ꞊dɛɛ‑ 'ka!» ");
INSERT INTO daf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","꞊Dhɛ 'ö 'yënng‑ ‑yö ‑ya mɛ ‑gɔ ꞊zinng 'gü, 'yö ‑dhɛ ‑yö ꞊tröö \"kpʋngtaadhɛ ꞊gban \"pɛpɛ 'gü mɔɔdhö do, 'yö to \"dhʋ̈ 'ö zun‑ 'ka \"wɔ \"yɛ ‑yën 'bhü \"tʋ̈ng bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","'Yö 'yënng‑ ‑yö bo 'bhü ‑sü 'ka, 'yö \"bin ‑yö ma 'yënng‑ bha‑ 'gü, 'yö Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gükangüsɔ ‑yö ‑pɛ ö ꞊zinng 'gü ꞊gbanngdhö do \"tʋ̈ng do bha‑ 'ka (kö ‑ya ‑zɔn ꞊dhɛ zian 'ö dho Atanna \"piʋ̈ ‑a \"dhi ꞊ya \"pʋ). ");
INSERT INTO daf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","꞊Dhɛ 'ö ‑dhɛ 'gü ‑yö ꞊tröö \"dhʋ̈, 'yö Yesu ‑yö ꞊gbla \"gbɩɩ‑ 'ka 'ö‑ pö: «N Dë, 'ma n 'nii‑ wɔ i ꞊kwɛɛ‑.» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ ꞊ya ö bo 'yö ‑tɔn ‑da. ");
INSERT INTO daf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","꞊Dhɛ 'ö Wlɔmö \"sɔdha ‑gɔmɛ 'ö gun mü bha 'ö 'wɔn bha‑ ‑dhɛ yö, 'yö Atanna 'tɔ bhɔ 'ö‑ pö: «'Mɛ 'ö ya pö 'aa gun‑ ‑bha tɛan‑ ꞊dede 'ka, ‑a ‑bho \"piʋ̈ ‑dhɛ 'bhaa 'dhö!» ");
INSERT INTO daf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","꞊Dhɛ 'ö 'wɔn bha ꞊ya bo kë ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö mɛ kpö 'wo gun mü 'ö‑ ‑nu \"yan ‑yö dɔ‑ ‑dhɛ 'gü bha, 'wo wo yee kë 'wo dho wo ꞊plöö ‑a ‑wëë ‑wʋ 'kpɔ ‑sü 'ka kö‑ ‑nu ‑kɔ ‑ya ‑nu ‑kuu 'gü. ");
INSERT INTO daf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","\"Tʋ̈ng 'ö 'wɔn ‑nu bha 'wo kë sië‑ 'ka‑ \"dhʋ̈ bha, kö mɛ \"pɛpɛ 'kö 'wo Yesu dɔ waa‑ dhebhɔ ‑nu 'wo go‑ ꞊keng‑ Gadhidhe ‑sɛ 'gü 'wo nu bha‑ ‑nu ꞊gban \"pɛpɛ ‑wo dɔ sië‑ 'ka ꞊gblɛɛn 'në 'bha wo 'wo 'wɔn ‑nu bha‑ ‑nu ‑dhɛ ‑ga. ");
INSERT INTO daf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","\"Kɛɛ mɛ do 'bha ‑yö ‑gun mü 'wo‑ ‑dhɛ Zosɛfu, 'ö go Zuifö ‑bha 'pö‑ 'wo‑ ‑dhɛ bha‑ 'gü, 'ö gun \"klʋsëmɛ 'ö Atanna dɔ ‑a 'ka. ‑Kwɛagbö ‑nu 'wo‑ ‑nu ‑ya \"sɛ bha‑ 'gü dhiangzëmɛ 'ka kö ꞊wa ꞊loo 'ko ‑ta bha‑ mɛ do ꞊në gun Zosɛfu bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mɛ 'ö bha 'wɔn \"pɛpɛ 'ö Zuifö ‑nu ‑wa ‑wɔ Yesu ‑ta bha‑ ‑kɔ 'yaa gun‑ 'bha 'gü, \"ɛɛn 'yaa gun‑ ‑ya 'kwëë‑ kë ‑dhɛ ‑zian 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑gun 'dhang ‑bho Atanna \"dhiʋ̈ ‑mɛ 'ka, 'ö‑ \"yan‑ gun ‑a ‑bha ‑gblüdëdhɛ nu ‑sü ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mɛ 'ö bha 'yö dho 'yö Yesu ꞊gee ‑gbadhɛ Pidhatö ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","꞊Dhɛ 'ö Pidhatö ꞊ya ö ‑kɔ bho‑ 'gü ‑a ‑dhɛ, 'yö dho 'yö‑ bho \"dhü ‑bha, 'yö sɔ \"puu bɔ‑ ‑bha, 'yö dho‑ 'ka 'yö‑ ‑wɛɛ bho ‑gwëyɛ 'bha 'ö mɛ 'bha 'yii mɛ ‑wɛɛ ‑blɛɛsü bho‑ bha do bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","'Wɔn bha ‑yö ‑kë \"dhʋ̈ yi 'ö Zuifö ‑nu ‑bha ꞊gloo ‑sü zü ‑yö bho‑ 'ka yɛan\" \"piʋ̈ bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","'Ö gun kö Zosɛfu ‑yö dho sië Yesu 'ka, 'yö dhong ‑nu 'wo go‑ ꞊keng‑ Gadhidhe bha 'wo dho‑ dɔ, 'yö 'wo Yesu ‑wɛɛbhodhɛ waa‑ ‑a wɔ ‑kɔ ꞊gban ‑dhɛ yö 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","꞊Dhɛ 'wo go mü, 'yö 'wo dho wo ꞊yëë \"dhiʋ̈ ‑dhɛ ‑nu 'gü, 'yö 'wo \"yɔn ‑nu waa‑ ‑dhasiklɔɔ \"yi ‑nu ꞊mɔɔ 'yö 'wo‑ ‑ya wo ‑kɔ \"sɔɔ kö 'wo dho‑ ꞊wɛnng Yesu ꞊gee ‑bha. ꞊Dhɛ 'ö ꞊glooyi bha 'ö ꞊loo, 'yö 'wo ꞊gloo ꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka Atanna ‑gɔ 'sëëdhɛ 'gü ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","꞊Dhɛ 'ö Zuifö ‑nu ꞊glooyi bha ꞊ya ziö 'ö‑ ‑tadhɛ ꞊ya ꞊kpaɔ, 'yö dhong ‑nu 'wo gun Yesu ꞊keng‑ bha 'wo ꞊wlü 'wo dho ‑a bun ꞊taa ‑dhɛkpaɔ tii 'gü, \"yɔn ‑nu waa‑ ‑dhasiklɔɔ ‑nu 'wo‑ ꞊mɔɔ bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","꞊Dhɛ 'wo dho 'wo ꞊loo mü, 'wo dho ‑dhɛ ‑ga kö ‑gwë 'wo ‑yɛ \"dhiʋ̈ ‑ta 'ka bha 'yaa mü, kö ꞊waa‑ glün‑ ꞊waa‑ ‑ya zian \"wɛɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'Yö 'wo ‑sɔ ‑yɛ bha‑ 'gü, \"kɛɛ 'wii‑ ‑nu Dëmɛ Yesu ꞊gee yö mü. ");
INSERT INTO daf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","'Wɔn bha 'yö‑ 'wɔn ‑ya ‑nu kɔn, ‑wo ‑to wo ‑zʋ 'gɔn ‑sü ‑bha 'wɔn bha‑ 'gü, 'yö gɔɔn‑ ‑nu ꞊plɛ ‑wo wo ‑dɩ ‑zɔn ‑a ‑nu ‑dhɛ. Mɛ ꞊plɛ 'wo bha sɔ 'ö gun‑ ‑nu ‑bha bha ‑yö ‑dɔ mɛ \"yan 'gü ‑glanglandhö. ");
INSERT INTO daf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","꞊Dhɛ dhong ‑nu bha 'wo 'mɛ 'wo bha‑ ‑nu yö, 'yö \"suʋ̈ 'dhö ‑da ‑nu 'gü, 'yö 'wo wo ‑gɔ \"dhiʋ̈ \"gblëënu. \"Kɛɛ 'yö 'mɛ 'wo bha 'wo‑ pö‑ ‑nu ‑dhɛ 'wo‑ pö: «'Mɛ 'ö \"yaandhe 'ka ka‑ ‑mɔɔ 'mɛ ꞊wa ga ‑a ‑nu kpö 'gü ‑më ‑wɔn 'gü? ");
INSERT INTO daf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","'Yaa ‑dhɛ ya‑ 'gü 'zü, ꞊ya ‑bö 'nu, ka ‑zʋ 'ya 'dho bhɔ dhiang 'ö‑ zë ka ‑dhɛ kö ‑yö ‑tun Gadhidhe 'ö‑ pö ꞊dhɛ: «‑A ‑dhɛ ‑ya ‑bha ꞊dhɛ ‑wo Mɛgbömɛ \"dhiʋ̈ dɔ 'wɔnyaakëmɛ ‑nu ‑gɔ kö ‑wa dɔ \"dhü ‑bha kö ‑wa zë, \"kɛɛ kö ‑yö ‑bö ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa 'ka bha ꞊në‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","꞊Dhɛ 'ö ꞊waa‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈, 'yö‑ ‑nu ‑zʋ ‑yö ‑bö ‑wʋ 'ö Yesu ‑ya pö‑ ‑nu ‑dhɛ \"dhʋ̈ bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","꞊Dhɛ 'ö ꞊wa 'go bun ꞊taa ꞊wa nu, 'yö 'wo 'wɔn bha‑ ‑gɛn dɔ Yesu ‑bha ꞊klang ‑nu ‑kaɔng do ga do 'wo to bha‑ ‑nu ‑dhɛ waa‑ mɛ ‑kpɛa 'wo to‑ ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","'Mɛ 'ö‑ ‑nu \"yan 'dhö ‑da 'wɔn ‑nu bha‑ ‑dhɛ 'gü, 'ö 'wo nu 'wo‑ ‑gɛn dɔ \"dhʋ̈ bha, 'yö‑ mɛ do‑ ‑kë Madhi 'ö go Madadha ‑a 'ka, 'yö Zanö, 'yö Madhi Zakö dhe waa‑ 'mɛ 'wo gun‑ ‑nu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","\"Kɛɛ 'wɔn 'ö dhong ‑nu bha 'wo‑ ‑gɛn dɔ \"dhʋ̈ bha 'yii bhɔ Yesu ‑bha ꞊klang ‑nu bha‑ ‑nu 'gü tɛan‑ ‑bha, ‑wa ‑ga ꞊dhɛ \"wlaa‑ ꞊në 'wo‑ zë. ");
INSERT INTO daf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","\"Kɛɛ 'yö Piɛdhö ‑zë 'ö ꞊wlü 'ö dɔ ‑bɛang ‑bha 'ö dho mü. ꞊Dhɛ 'ö dho 'ö ꞊loo mü, 'yö ö ‑gɔ 'naanu 'yö ‑dhɛ ‑ga ‑yɛ 'gü mü, \"kɛɛ 'yii pë \"wɛɛ 'bha yö kö 'yii kë sɔ 'kö 'wo‑ bɔ Yesu ‑bha 'ö‑ ‑kɔn ‑yö to \"sia‑ mü bha‑ 'ka. ꞊Dhɛ 'ö‑ ‑dhɛ yö \"dhʋ̈, 'yö‑ 'wɔn ‑ya kɔn 'pö 'yö ‑ziö 'ö dho ö ‑gɔ \"kwɛandhö. ");
INSERT INTO daf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","‑A yi do bha‑ 'ka, 'yö Yesu ‑bha ꞊klang ‑nu bha‑ mɛ ꞊plɛ 'wo ꞊wlü 'yö 'wo gun 'dho sië 'pödhɛ do 'bha 'ö \"kidhʋng ‑kaɔng do ga do \"sinma \"dhiʋ̈ Zedhizadhɛmö ‑dhɛ \"sɔɔ mü 'wo‑ Emausö ‑dhɛ ‑kë bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","꞊Dhɛ 'wo ‑da zian ‑ta, 'yö 'wɔn \"pɛpɛ 'ö ‑kë Yesu ‑wɔn 'gü bha 'wo zun‑ ‑dhiang zë ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","꞊Dhɛ 'wo 'wɔn ‑nu bha‑ ‑dhiang zë sië 'ö 'wo‑ zaɔdhe ‑da sië 'wo 'dho sië‑ 'ka, 'yö Yesu ‑yö nu 'ö ‑da ‑a ‑nu \"piʋ̈ 'yö 'wo \"ta bha sü wo \"kwëë. ");
INSERT INTO daf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","‑Wo \"ta bha‑ ‑sü wo \"kwëë \"dhʋ̈ 'wo dho‑ 'ka, \"kɛɛ kö ꞊ya kë ꞊dhɛ pë 'bha ꞊ya kpa mɛ \"yan \"dhiʋ̈, kö 'waa Yesu dɔ. ");
INSERT INTO daf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","'Yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Më ‑wɔn ꞊në 'ka‑ ‑dhiang zë sië‑ zian ‑ta bha?» ꞊Dhɛ 'ö‑ ‑nu dhɛɛ\" kpɔ \"dhʋ̈, 'yö‑ ‑nu wë ‑ta ‑yö ga ‑yɔɔndhö, 'yö 'wo 'daɔnnu. ");
INSERT INTO daf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","꞊Dhɛ 'wo 'daɔnnu, 'yö‑ mɛ do 'dhɛ 'wo Kleopasö ‑kë bha 'ö‑ pö Yesu ‑dhɛ: «‑Kë ꞊dhɛ bhii do ꞊në 'wɔn 'ö ‑kë Zedhizadhɛmö ‑dhɛkpaɔyi ꞊plɛ ya‑ 'ka bha 'bhii‑ ma \"dhɛ!» 'Yö Yesu ‑ya pö: «‑Më ‑wɔn ꞊në ‑kë Zedhizadhɛmö?» ");
INSERT INTO daf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «'Wɔn 'ö kë Yesu 'ö go Nazadhɛtö, 'ö gun Atanna ‑wʋdhiʋ̈loomɛ 'kpii‑ 'ka, 'ö gun \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu kë sië, 'ö ꞊ya dhiang zë 'ö 'yaa bhɔ mɛ \"bhɩɩ‑ ‑bha mɛ 'bha 'gü, 'ö Atanna ꞊dede ‑ya dɔ, ");
INSERT INTO daf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","\"kɛɛ 'ö kwaa \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ \"sɛgɔdhiʋ̈mɛ ‑nu 'wo‑ \"dhiʋ̈ dɔ ‑a 'yaɔ‑ ‑nu ‑gɔ kö ‑wa zë, 'ö 'wo‑ ‑gban \"dhü ‑bha bha 'bhii‑ ma ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","‑Yö ‑gun yi 'gü ꞊dhɛ 'mɛ 'kö bha ꞊në dho Izraɛdhö ‑mɛ ‑nu bho ꞊dhuëngdhɛ 'gü 'nu, \"kɛɛ 'wɔn bha 'ö bo kë ‑sü 'ka \"dhʋ̈, ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa ꞊në ꞊dɛɛ. ");
INSERT INTO daf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","‑Yö \"dhʋ̈ tɛan‑ 'ka ꞊dhɛ 'mɛ 'yi gun‑ ꞊keng‑ bha‑ dhong ‑nu 'bha ‑nu ꞊wa 'go‑ ‑wɛɛ bho ‑dhɛ 'gü ꞊wa nu, ‑wʋ ‑nu 'wo go‑ 'ka mü bha 'yi‑ ma, ‑a 'wɔn ‑yö yi ‑kɔn. ‑Wa ‑pö ꞊dhɛ wo ‑zë wo kë ‑suʋ̈ ‑dhɛkpaɔ tii 'gü 'wo dho‑ bun ꞊taa, ");
INSERT INTO daf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","\"kɛɛ 'dho 'wo‑ wo bha 'wii ‑kpan ‑a ꞊gee ‑bha mü, 'wo nu ‑wa ‑pö yi ‑dhɛ ꞊dhɛ wo wo \"yan ‑kpan Atanna ‑bha \"kië ‑nu ꞊në‑ ‑nu ‑bha, 'yö 'wo‑ pö wo ‑dhɛ ꞊dhɛ ‑yö \"yaandhe 'ka. ");
INSERT INTO daf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","'Yö 'mɛ 'ö yɛng ‑nu 'yi gun‑ ꞊keng‑ bha‑ mɛ 'bha ‑nu 'wo dho 'pö mü, 'yö 'wo ‑kpan 'pö‑ ‑dhɛ ‑bha ꞊dhɛ ‑kɔ 'ö dhong ‑nu bha 'wo‑ ‑gɛn dɔ‑ 'ka yi ‑dhɛ bha‑ 'dhö, \"kɛɛ yö ‑zë 'wii‑ yö tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈, 'yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «'Aa 'mɛ 'ka ya! Ka \"yaaki ‑yö 'sɛɛnnë ꞊tɔn ‑kɛɛ! 'Wɔn 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑wa to \"dhʋ̈ 'wo‑ pö yi 'bha yi 'bha 'ka bha 'dhang ‑bho \"dhiʋ̈ zuëga 'yaa ka ‑gɔ ‑wa! ");
INSERT INTO daf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","\"Ɛɛn 'kaa‑ 'wɔn ꞊në‑ dɔ ꞊dhɛ 'mɛ 'ö Atanna ‑ya ‑ya Izraɛdhö ‑mɛ ‑nu Dhamɛ 'ka bha ‑yö ‑dho saan\" ꞊dhɛ ‑kɔ bha ꞊në‑ 'dhö kö ‑yö gun ‑na ‑da ö ‑bha mɛdhɛ ‑kwi 'gü ‑ee? ");
INSERT INTO daf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","꞊Dhɛ 'ö ꞊yaa‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈, 'yö 'wɔn \"pɛpɛ 'ö ‑gban ‑bha 'ö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü, yö ‑zun 'klɔɔ‑ ‑pö ‑nu ‑dhɛ ‑sü ‑bha, 'yö‑ zü bho 'sëëdhɛ 'ö Moizö ‑ya ‑bɛn zë bha‑ ‑ta 'yö dho‑ 'ka 'ö ‑da 'ka Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑gɔ 'sëëdhɛ 'gü, 'yö dho‑ 'ka \"dhʋ̈ 'dɔɔndhö. ");
INSERT INTO daf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","꞊Dhɛ 'wo dho 'wo ꞊tëng 'pödhɛ 'wo 'dho sië‑ 'gü bha‑ ‑ta, 'yö Yesu ‑ya ‑kë ꞊dhɛ 'pë 'ö yö ‑zë 'ö ‑tun 'dho‑ ‑dhɛ ꞊gblɛɛn 'gü ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'Yö 'wo‑ bho zian‑ 'wo‑ pö‑ ‑dhɛ: «‑Bhö dɔ \"gbɩɩ‑ kö i wɔ, ‑a ‑gɛn ‑mü ꞊dhɛ \"bin ꞊ya 'ma ꞊ya bo, 'yënng‑ ‑gɔ ꞊ya ‑ya ‑tɔn ‑ta.» 'Yö ‑wɩ ‑bha 'yö dho‑ ‑nu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","꞊Dhɛ 'wo dho, 'ö pë ‑bhö \"tʋ̈ng 'dhö ꞊loo, 'ö woo zun pë ‑bhö ‑sü ‑bha, 'yö ö ‑kɔ ‑da 'bluu‑ 'gü, 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü, 'yö‑ \"kplü \"kplü bho 'yö‑ 'gü ‑gblü ‑a ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö‑ ‑nu \"yan \"dhiʋ̈ ‑yö ‑pʋ, 'yö 'wo‑ dɔ, \"kɛɛ 'yö to 'mü 'pö 'ö ꞊dhɛng‑ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","꞊Dhɛ 'ö bo ‑dhidha 'sü ‑sü 'ka ‑a ‑nu ‑gɔ ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö 'wo zun‑ ‑pö wo 'ko ‑nu ‑dhɛ ‑sü ‑bha ꞊dhɛ: «Mɛ 'ö bha \"tʋ̈ng 'ö gun Atanna ‑wʋ 'klɔɔ‑ pö sië‑ 'ka kwa ‑dhɛ zian ‑ta bha, kö kwa zuë\" 'yaa 'dho sië \"sia‑ ‑yɔɔndhö ꞊dhɛ 'pë ꞊wa böö‑ ‑sɛa ꞊në‑ ‑ya ‑ta ‑a 'dhö ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","‑Wo ‑to ‑dhɛ do bha‑ 'gü 'wo ꞊wlü 'wo wo wë dɔ 'zü ‑deewo Zedhizadhɛmö. 'Wo dho ‑wo ‑kpan mɛ ‑kaɔng do ga do bha waa‑ 'mɛ wɛng‑ ‑nu 'wo gun \"kwëë bha‑ ‑nu ‑bha kö ‑wo ‑dhɛ do 'gü ");
INSERT INTO daf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kö ‑wa pö sië: «Kwa Dëmɛ ꞊ya ‑bö tɛan‑ 'ka, Simɔ ꞊yaa‑ yö.» ");
INSERT INTO daf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","'Yö woo ‑dɩ 'pö ‑kɔ 'ö‑ ‑nu ‑bha ‑ya ‑nu ꞊slɔɔ‑ 'ka, ‑kɔ 'wo Yesu dɔ‑ 'ka kö ‑yö 'bluu‑ \"kplü \"kan sië bha 'wo ‑ziö 'pö‑ ‑gɛn 'gü ‑a ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dhiang bha ‑yö ‑to ‑nu \"dhi, 'yö Yesu ‑yö go ‑dhidha 'gü ‑a ‑nu ‑dhɛ, 'yö dɔ‑ ‑nu ꞊zinng 'gü 'ö‑ pö: «Zuëyagblʋ̈ʋ̈‑ ‑yö kë ka ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","\"Kan 'ö‑ wo‑ ‑nu 'gü \"dhʋ̈ bha 'yö pɛng ‑yö ‑kan ‑a ‑nu ‑bha 'yö \"suʋ̈ ‑yö ‑da ‑a ‑nu 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑bhɔ ‑a ‑nu 'gü mɛ ‑zii ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","\"Kɛɛ 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «\"Suʋ̈ ‑yö ‑da ka 'gü 'yö ꞊yɔɔn ‑gblü ‑yö dɔ ka zuë\" ‑ta 'yö 'ka ‑zʋ 'gɔn ‑kɔ suu ‑nu bha‑ ‑kë ‑më ‑wɔn 'gü? ");
INSERT INTO daf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","‑Ka \"pɔni \"gblʋʋ ‑nu 'wo n ‑kɔ ‑nu waa‑ n ‑gɛn ‑nu ‑bha ya‑ ‑ga kö 'ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ pë \"wɛɛ 'bha 'yaa ‑mü, ma ‑mü! ‑Ka nu kö 'ka ka ‑kɔ zun n kwi ‑bha kö 'ka 'dhang bho‑ \"dhiʋ̈. \"Ɛɛn mɛ ‑zii ga‑ ‑kë 'gü ꞊dhɛ ‑kɔ 'ö n ‑bha 'dhö‑ ‑bha ya‑ 'dhö ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","'Ö‑ pö sië \"dhʋ̈ kö ‑yö ö ‑kɔ waa‑ ö ‑gɛn ‑nu ‑zɔn sië‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","꞊Dhɛ 'ö ‑kë ꞊dhɛ \"yan 'wo‑ ‑kpan Yesu ‑bha bha‑ 'gü ‑wɔn ‑yö ‑dhi ‑nu ‑dhɛ ꞊dedewo, \"kɛɛ 'ö‑ 'wɔn ‑ya ‑nu kɔn 'ö‑ ‑wɔn 'gü kö 'wii 'dhang bho‑ \"dhiʋ̈ ꞊kö 'kpakpadhö bha, 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Bhöpë 'bha ‑yö ka ‑gɔ yö ‑ee?» ");
INSERT INTO daf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'Yö 'wo‑ pö: «꞊Iin.» 'Yö 'wo nu‑ ‑dhɛ 'yuʋ̈‑ ‑yɛsü \"kplü do 'ka, ");
INSERT INTO daf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","'yö‑ ‑bhö ‑a ‑nu \"yaan mü. ");
INSERT INTO daf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","꞊Dhɛ 'ö ö bo‑ ‑bhö ‑sü 'ka 'yö‑ pö: «‑Ka ‑dhɛ ‑ga, ‑wʋ ‑nu 'a gun‑ pö sië ka ‑dhɛ kö a ‑tun ka kpö 'gü, 'ö 'a‑ pö ꞊dhɛ 'wɔn \"pɛpɛ 'ö Moizö oo, Atanna ‑wʋdhiʋ̈loomɛ ‑nu oo, \"ɛɛn ‑a ‑bha \"tan 'sëëdhɛ ‑ya ‑dhiang zë n ‑bu 'gü bha, ‑a ꞊gban 'gü ‑wɔn ‑dho kë bha, ‑kaa ‑ga bha.» ");
INSERT INTO daf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'wɔn 'gü ma zuëga nu‑ ‑nu ‑dhɛ, kë \"dhʋ̈ kö ‑wo Atanna ‑wʋ 'gü ma ö 'klɔɔ‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","'Yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Yö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'sëëdhɛ 'gü ꞊dhɛ ‑a ‑bha ‑Yamɛ bha ‑yö ‑dho saan\" ꞊dedewo 'ö 'wo‑ zë, \"kɛɛ ‑yö ‑dho ‑bö ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa 'ka. ");
INSERT INTO daf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","'Ö 'wo mɛbhɩɩdhe ‑bha ‑kwaa ö ꞊sɔng ‑zü kö ‑yö bɔ Atanna 'ka ‑sü waa‑ Atanna ‑bha mɛbhɩɩdhe ‑bha 'wɔn yaa ‑mawɔn 'to ‑sü ‑dhiang zë ‑sü zü bho Zedhizadhɛmö ‑pö ya‑ 'gü, 'ö 'wo dho‑ 'ka \"sɛgɔ \"pɛpɛ ꞊gban 'gü ‑a 'tɔ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ka ꞊në 'ka n \"sɛɛ‑ 'ka 'wɔn ‑nu bha‑ \"gblʋʋ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","꞊Dhɛ 'ö \"dhʋ̈, 'pë 'ö n Dë ‑ya bɔ ‑wɔn \"plüün bho ka ‑dhɛ bha mang ꞊dede ꞊në 'a dho‑ bɔ ka ‑dhɛ. \"Kɛɛ \"sanni ‑yö kë \"dhʋ̈ ‑a ‑dhɛa ‑bha ꞊dhɛ 'ka 'to Zedhizadhɛmö ‑pö ya‑ 'gü kö ‑yö 'to \"dhʋ̈ ‑yö zun‑ 'ka yi 'ö faan 'ö \"dhʋ̈ bha 'ö dho 'go‑ 'ka dhang‑ 'gü kö ‑yö ‑da ka 'gü bha‑ yi ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","꞊Dhɛ 'ö ꞊ya ö bo ‑wʋ bha‑ ‑kpɔ ‑nu ‑bha ‑sü 'ka, 'yö‑ ‑nu sü 'ö wë dɔ‑ ‑nu 'ka Betani ‑zian 'ka, ꞊dhɛ 'ö ꞊wa ꞊loo‑ ‑nu 'dho ‑dhɛ 'gü, 'yö ö ‑kɔ \"dhiʋ̈ ꞊wlü 'yö 'dhuë‑ ‑kë ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","‑Yö ‑to 'dhuë‑ ‑kë ‑nu ‑bha ‑dhɛ bha ꞊në‑ 'gü, 'yö ‑kan ‑a ‑nu ‑bha 'yö 'gbʋ‑ ‑ya sü 'yö dho‑ 'ka dhang‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","꞊Dhɛ 'ö 'dho sië \"dhʋ̈, 'yö‑ ‑bha ꞊klang ‑nu ‑zë 'wo zun wo kpiö 'gü, 'yö 'wo 'tɔ ꞊loo‑ ‑bha. ꞊Dhɛ 'wo wo bo, 'yö 'wo nu 'zü ‑deewo Zedhizadhɛmö \"kɛɛ kö ‑a ‑nu zuë\" ꞊nii ꞊ya ‑da ‑tɛkpɛ ‑tɛkpɛdhö. ");
INSERT INTO daf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","'Ö go yö ‑zë 'gü, ‑wo ‑gun Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gü yi ꞊gban \"pɛpɛ 'ka 'ö 'wo ꞊gloo‑ 'tɔ bhɔ ‑sü ‑bha.");
INSERT INTO daf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","'Ö gun kö \"sɛ waa‑ dhang‑ 'waa 'dhö kö (Atanna Gbö) 'ö‑ ‑Wʋ 'ka bha yö ‑zë ‑yö ‑dhö kö wɛng‑ ‑wo wo 'ko \"piʋ̈. ‑Yö ‑gun 'dhö ‑kpɛawo 'pö (꞊dhɛ Atanna 'dhö), yöö ‑dɩ 'pö ‑yö Atanna ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pë ‑nu 'ö Atanna ‑ya ‑kë, ‑ya ‑nu ‑kë yö ꞊në‑ ‑kɔ 'ka. Pë \"pɛpɛ 'ö‑ ‑kë, ‑a 'bha 'yii kë \"wɛɛwɛɛ kö ‑a Gbö 'kö bha 'yaa ‑mü. ");
INSERT INTO daf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yö ꞊në ‑tosɛa ꞊dede ‑gɔgodhɛ 'ka. Yö 'ö \"dhʋ̈ bha 'zü ꞊në ‑dhɛpuudhɛ nu mɛ \"bhɩɩ‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yö 'ö bha ꞊në‑ ‑kë 'yö 'mɛ 'wo ‑dhɛtiidhɛ 'gü 'wo ‑dhɛ yö, \"kɛɛ 'yö 'wii 'dhang bho‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","'Yö Atanna 'dhö mɛ do bɔ, 'mɛ bha ꞊në 'wo‑ ‑dhɛ Zan. ");
INSERT INTO daf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Zan bha ꞊në nu kö ‑yö \"sɛɛdhɛ kë ‑dhɛpuudhɛ bha‑ ‑bha. Kë \"dhʋ̈ kö mɛ \"bhɩɩ‑ ‑nu ‑wo 'dhang bho ‑dhɛpuudhɛ bha‑ \"dhiʋ̈ dhiang ‑nu 'ö Zan gun‑ zë sië bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yöö ꞊dede ‑zë 'yaa gun ‑dhɛpuudhɛ bha‑ 'ka, \"kɛɛ ‑yö ‑gun 'mɛ 'ö Atanna ‑ya bɔ kö ‑yö \"sɛɛdhɛ kë ‑dhɛpuudhɛ bha‑ ‑bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","‑Dhɛpuudhɛ 'ö \"dhʋ̈ bha ꞊në gun ‑dhɛpuudhɛ ꞊dede, 'ö nu \"kpʋng ꞊taa kö ‑yö ‑dhɛ \"pʋ mɛ \"pɛpɛ ꞊gban ‑ta ‑a 'ka. ");
INSERT INTO daf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yesu 'ö Atanna ‑wʋ 'ka \"dhʋ̈ bha ‑yö ‑gun \"kpʋng ꞊taa. Atanna ‑yö \"kpʋngtaadhɛ ‑pë ‑kë yö ꞊në‑ ‑kɔ 'ka, \"kɛɛ 'sa \"kpʋngtaamɛ ‑nu 'wii‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","'Yö dho ö ‑dɩ ‑gɔ \"sɛ 'gü, 'yö‑ ‑gɔ \"sɛ 'gü ‑mɛ ‑nu 'wii ‑kɔ ‑ya ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","\"Kɛɛ yö ‑zë ꞊gban 'gü, mɛ ga 'bha ‑wo 'dhang ‑bho ‑a \"dhiʋ̈, 'ö 'wo ‑kɔ ‑ya ‑wɔn ‑bha. 'Mɛ 'wo \"dhʋ̈ bha 'yö‑ ‑kë kö ‑wo kë Atanna ‑bha 'në 'ka. ");
INSERT INTO daf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","\"Kɛɛ ‑a ‑nu ‑bha ‑kë Atanna ‑bha 'në 'ka ‑kɔ ‑yö ‑dɩ ‑ta, 'yaa ꞊dhɛ mɛ \"bhɩɩ‑ ‑nu ‑bha 'ö‑ ‑nu dë (waa‑ dhe) 'dhö ‑dhö bha‑ 'dhö; Atanna ꞊në‑ ‑nu gba ‑tosɛa ‑dee 'ka. ");
INSERT INTO daf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yö 'ö ‑kë Atanna ‑wʋ 'ka \"dhʋ̈ bha, 'yö dho 'ö ‑kë mɛ \"bhɩɩ‑ 'ka, 'yö nu 'ö ‑tosɛa ‑kë kwa kpö 'gü, Atanna ‑bha \"klʋsëdhɛ ꞊gban \"pɛpɛ waa‑ tɛanwɔn 'ö ‑gban ‑bha bha‑ 'ka, 'yö kwa \"yan 'dhö ‑da ‑a ‑bha 'tɔbhɔdhe kë 'kpiisü 'gü. ‑Yö ‑gun 'në ga do 'ka ö Dë ‑gɔ, 'yö gun‑ ‑bha 'tɔbhɔdhe ‑zɔn sië. ");
INSERT INTO daf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yö ꞊në Zan ‑ya ‑dhiang zë 'ö‑ pö: «'Mɛ 'a‑ pö ka ‑dhɛ ꞊dhɛ ‑yö nu sië n zian‑ ‑ta, \"kɛɛ yö ‑zë ‑yö ꞊bhlëësü ma ‑zë n ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun kö 'maa 'dhö kö yö ‑zë ‑yö ‑dhö bha.» ");
INSERT INTO daf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kwaa ‑dɩ 'pö kwa kwa ‑bha ꞊trɔɔn ‑slɔɔ ‑a ‑bha \"klʋsëdhɛ ‑ziisü bha‑ 'gü, 'ö‑ ‑wɔn 'gü Atanna ‑bha 'dhuë‑ ‑yö dɔ 'ko ‑gɛn \"piʋ̈ kwa ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","'Ö gun yi 'bha 'ka, Atanna ‑yö bɔ Moizö ꞊në‑ ‑ta 'yö 'tɔng‑ nu kwa ‑dhɛ. \"Kɛɛ ‑a ‑bha \"klʋsëdhɛ waa‑ tɛanwɔn 'ö ‑gban ‑bha bha, ‑yö ‑bɔ Yesu Klisi ꞊në‑ ‑ta 'yö nu kwa \"piʋ̈ ꞊dɛɛ ‑yën ya‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mɛ 'bha 'yii \"yan ‑kpan ‑bha do, \"kɛɛ ‑a Gbö doseng 'ö Atanna 'ka ('pö ꞊dhɛ ‑a 'dhö), 'ö ö Dë \"sɔɔ yi ꞊gban \"pɛpɛ 'ka bha ꞊në‑ ‑zɔn mɛ \"bhɩɩ‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","(‑A \"tʋ̈ng bha‑ 'gü kö Zan ‑yö mɛ ‑go 'wɔn yaa 'gü ‑zu bho sië \"yiga 'wo‑ Zuudɛn ‑kë bha‑ ꞊bhaa.) ꞊Dhɛ 'ö Zuifö ‑nu ‑bha ‑yamɛ ‑nu ꞊wa ‑ya Zedhizadhɛmö ꞊waa‑ ma \"dhʋ̈, 'yö 'wo \"saabhomɛ ‑nu waa‑ Dhevi ‑gɔ 'kɔɔmɛ ‑nu bɔ Zan dhɛɛ\" 'kpɔ ‑dhɛ 'gü. ꞊Dhɛ 'ö ꞊wa nu ꞊wa ꞊loo‑ ‑dhɛ 'gü, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Bhi 'i ya de suu ‑mü i 'ka?» ꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈, 'yö Zan ‑yö ö ‑bha \"sɛɛdhɛ ‑kë ‑a ‑nu ‑dhɛ \"puu 'ka mɛ ꞊gban \"pɛpɛ wëëdhö mü 'ö‑ pö: «Ma ‑zë Atanna ‑bha ‑Yamɛ ('ö‑ \"plüün bho bha) 'yaa ‑mü n 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","'Yö 'wo‑ dhɛɛ\" 'bha kpɔ 'zü 'wo‑ pö: «\"Kɛɛ de ‑mü i 'ka 'sa? \"Ɛɛn (Atanna ‑wʋdhiʋ̈loomɛ) Edhi ('ö gun yi 'bha 'ka bha) ‑ee?» 'Yö Zan ‑ya pö: «‑Abin! Edhi 'yaa ‑mü n 'ka!» 'Yö 'wo‑ pö: «\"Ɛɛn Atanna ‑wʋdhiʋ̈loomɛ 'ö‑ bɔ ‑wɔn \"plüün bho yi ‑dhɛ 'ö 'yi ‑ya ‑gɔ bha yö ‑mü i 'ka ‑ee?» 'Yö Zan ‑ya pö 'zü: «‑Abin.» ");
INSERT INTO daf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'wo‑ pö‑ ‑dhɛ: \"Kɛɛ de ‑mü i 'ka 'sa? ‑Bhö i ‑dɩ ‑zɔn yi ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'yi 'dho ‑wʋ do 'ka 'mɛ 'wo yi bɔ bha‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","'Yö Zan ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Ma ‑zë 'mɛ 'ö ‑wɩ \"wla ‑ta ꞊dhɛ ‑kɔ 'ö Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑ya pö‑ 'ka ‑a 'dhö ꞊dhɛ: ‹‑Ka ka Dëmɛ ‑bha zian ‑ba kö 'ka‑ du ꞊gban \"pɛpɛ bho‑ 'gü, kö 'ka‑ ‑ta ‑dhɛ ‑pë kë› bha yö ‑mü n 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","'Mɛ 'wo‑ ‑nu bɔ \"dhʋ̈ bha Fadhiziɛn ‑nu ‑gun ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","꞊Dhɛ 'ö ꞊wa Zan ‑wʋ ma ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö 'wo‑ dhɛɛ\" kpɔ 'pö 'wo‑ pö: «I‑ ‑pö Atanna ‑bha ‑Yamɛ 'ö‑ \"plüün bho kwa ‑dhɛ bha 'yaa ‑mü i 'ka, \"ɛɛn Edhi 'yaa ‑mü i 'ka, \"ɛɛn Atanna ‑wʋdhiʋ̈loomɛ 'yi ‑ya ‑gɔ bha 'yaa ‑mü i 'ka, \"kɛɛ ‑yö ‑kë ꞊dhɛ 'sa 'yö 'i \"zu ‑zë bho?» ");
INSERT INTO daf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","'Yö Zan ‑ya ‑yɔ bɔ 'pö‑ ‑nu ‑gɔ 'ö‑ pö: «Ma ‑zë a mɛ ‑zu \"yi ꞊në‑ 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ ('kwa ‑ya ‑gɔ bha ‑yö ka kpö 'gü), ");
INSERT INTO daf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","‑yö ‑dho nu n zian‑ ‑ta, \"kɛɛ 'kii‑ dɔ ꞊kö. ‑A ‑gɛn 'gü ‑sabha ‑zian fië‑ ‑dhö ma ‑zë n 'ka. ");
INSERT INTO daf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","'Wɔn \"pɛpɛ 'ö \"dhʋ̈ bha ‑yö ‑kë \"dhʋ̈ ‑dhɛ 'wo‑ Betani ‑dhɛ ‑kë, 'ö \"yi 'wo‑ Zuudɛn ‑kë bha‑ ꞊taama, ‑dhɛ 'ö Zan gun mɛ ‑go 'wɔn yaa 'gü ‑zu bho sië mü bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya ꞊kpaɔ, 'yö Zan ‑yö Yesu yö kö ‑yö nu sië ö ‑zian 'ka. 'Yö‑ pö: «‑Ka ‑dhɛ ‑ga, \"bhlaanë 'ö Atanna ‑ya bɔ kö ‑ya kë \"saa‑ 'ka kö mɛ ꞊gban \"pɛpɛ ‑bha 'wɔn yaa ‑mawɔn ‑yö 'to bha yö ꞊nɛ! ");
INSERT INTO daf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yö ꞊në 'a‑ ‑dhiang zë ka ‑dhɛ 'a‑ pö: «Mɛ do 'bha ‑yö ‑dho nu n zian‑ ‑ta, ‑a ‑duɛ ‑yö 'kpii‑ 'ö ‑ziö n ‑ma ‑ta, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun kö 'mii bhɔ ꞊kö kö yö ‑zë ‑yö ‑dhö bha. ");
INSERT INTO daf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","\"Kɛɛ \"tʋ̈ng 'a gun‑ pö sië‑ 'ka ka ‑dhɛ \"dhʋ̈ bha kö 'mii‑ dɔ ꞊kö. Ma ‑zë a mɛ ‑go 'wɔn yaa 'gü ‑zu bho \"yi ꞊në‑ 'ka, kë \"dhʋ̈ kö 'a yö ꞊në‑ ‑zɔn Izraɛdhö ‑mɛ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","'Yö Zan ‑ya pö 'zü: «Mang ꞊dede n \"yan ‑yö ‑kpan Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑bha kö ‑yö 'go sië dhang‑ 'gü 'ö ꞊lɔɔ‑ ‑ta ꞊dhɛ ‑tong 'dhö 'ö to 'mü. ");
INSERT INTO daf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","A‑ ‑pö ka ‑dhɛ ꞊dhɛ ‑a \"tʋ̈ng bha‑ 'gü kö 'mii‑ dɔ ꞊kö 'kpakpadhö. \"Kɛɛ Atanna 'ö n bɔ ‑go 'wɔn yaa 'gü ‑zu bho ‑dhɛ 'gü \"yi 'ka bha ꞊në‑ pö n ‑dhɛ ꞊dhɛ: «'Mɛ 'i dho i \"yan ‑kpan ma 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑bha kö ‑yö 'go sië dhang‑ 'gü 'ö ꞊lɔɔ‑ ‑ta 'ö to 'mü bha ꞊në dho mɛ pa 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ka.». ");
INSERT INTO daf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'Yö Zan ‑ya pö: «A‑ ‑pö ka ‑dhɛ ꞊dhɛ a kë n \"yan ‑kpan ‑bha ꞊dhɛ ‑kɔ bha‑ 'dhö tɛan‑ 'ka. 'Wɔn 'ö‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ yö ꞊në Atanna Gbö 'ka bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","꞊Dhɛ 'ö‑ ‑tadhɛ 'bha ꞊ya ꞊kpaɔ, kö Zan ‑yö ‑tun ‑dhɛ do bha‑ 'gü waa‑ ‑bha ꞊klangdhiʋ̈ ‑nu ꞊plɛ 'dhö, ");
INSERT INTO daf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","'yö ö \"yan ‑kpan 'zü Yesu ‑bha kö ‑yö ziö sië. 'Yö‑ pö: «\"Saa‑ \"bhlaanë 'ö Atanna ‑ya bɔ (kö ‑yö mɛ \"bhɩɩ‑ ‑nu ‑bha 'wɔn yaa bho‑ ‑nu ‑bha) bha yö ꞊nɛ!» ");
INSERT INTO daf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","꞊Dhɛ 'ö Zan ‑bha ꞊klangdhiʋ̈ ‑nu ꞊plɛ bha ꞊waa‑ ‑wʋ ma ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö 'wo ‑ziö Yesu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","꞊Dhɛ 'ö ꞊ya ‑kë \"dhʋ̈, 'yö Yesu ‑yö ꞊slëë ö 'gü, 'yö \"yan ‑kpan ‑a ‑nu ‑bha kö ‑wa ꞊keng‑, 'yö‑ pö‑ ‑nu ‑dhɛ: «Kwa‑ ma 'mü?» 'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Dhabi, i ꞊yëë ‑yö 'mɛ?» (꞊Waa‑ pö «Dhabi» ‑a ‑nu ‑wʋ 'gü kö ‑wa pö «n Dëmɛ».) ");
INSERT INTO daf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","'Yö‑ ‑yɔ bɔ 'pö‑ ‑nu ‑gɔ 'ö‑ pö: «‑Ka ‑kwa 'dho kö 'ka‑ ‑dhɛ dɔ!» 'Yö 'wo ‑ziö 'wo dho. 'Yö 'wo ‑kpan ‑a ‑dhɛ ‑bha, 'yö 'wo ‑dhɛ ꞊kpaɔ ‑yi 'dhɛ bha‑ ‑kë ‑a \"piʋ̈ mü. (‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑kë \"dhʋ̈ 'yënng‑ ‑dho bhaa 'ka). ");
INSERT INTO daf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mɛ ꞊plɛ 'wo \"tʋ to Zan ‑wʋ bha‑ ‑bha 'wo ‑ziö Yesu ꞊keng‑ bha, 'yö‑ mɛ do‑ ‑kë Andre 'ö ‑kë Simɔ Piɛdhö dheebhang 'ka bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, Andre ‑yö ‑kpan ö dheebhang Simɔ ꞊në‑ ‑bha ꞊kö ‑blɛɛsü 'yö‑ pö‑ ‑dhɛ: «Yi ‑zë 'ya ‑kpan Atanna ‑bha ‑Yamɛ 'ö‑ ‑wɔn 'dhö 'dhö bha‑ ‑bha!» (Yö ꞊në 'wo‑ ‑dhɛ glɛkö ‑wʋ 'gü Klisi bha.) ");
INSERT INTO daf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'Yö dho Simɔ 'ka Yesu \"piʋ̈. ꞊Dhɛ 'ö Yesu ꞊yaa‑ yö, 'yö‑ ‑ga \"sɛnngdhö 'yö‑ pö: «Bhi ꞊në 'wo i ‑dhɛ Simɔ, 'yö 'i ‑kë Zonasö gbö 'ka, \"kɛɛ ‑wo ‑dho i ‑dhɛ ꞊taamasü ya‑ 'gü Sefasö (꞊waa‑ pö \"dhʋ̈ kö ‑wa ‑pö Piɛdhö, \"ɛɛn 'zü ‑gwë). ");
INSERT INTO daf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ 'bha ꞊ya ꞊kpaɔ, kö ‑yö Yesu \"piʋ̈ ꞊dhɛ 'ö 'dho Gadhidhe ‑sɛ 'gü, 'yö ‑kpan Fidhipö ‑bha, 'yö‑ pö‑ ‑dhɛ: «‑Bhö nu kö 'i ‑da n ꞊keng‑!» ");
INSERT INTO daf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fidhipö 'ö \"dhʋ̈ bha ‑yö ‑go 'pödhɛ 'wo‑ ‑dhɛ Bɛsaida 'ö Andre waa‑ Piɛdhö 'wo go‑ 'gü bha ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Fidhipö ‑yö ‑kpan Natanaɛɛ ‑bha 'yö‑ pö‑ ‑dhɛ: «'Mɛ 'ö Moizö ‑ya ‑dhiang zë 'tɔng‑ 'sëëdhɛ 'gü, 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑dɩ 'pö 'wo‑ ‑dhiang zë yi 'bha 'ka bha 'ya ‑kpan ‑bha. ‑Wa ‑dhɛ Yesu, Zosɛfu gbö, ‑yö ‑go Nazadhɛtö.» ");
INSERT INTO daf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","'Yö Natanaɛɛ ‑ya pö‑ ‑dhɛ: «Pë ‑tiandhö 'bha‑ ‑mɔɔ ‑bha 'ö go Nazadhɛtö 'pö ‑ee?» 'Yö Fidhipö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Bhö nu ‑zë wo ꞊zɔɔ!» ");
INSERT INTO daf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","꞊Dhɛ 'ö Yesu ꞊ya Natanaɛɛ yö kö ‑yö nu sië ö ‑zian 'ka, 'yö‑ pö‑ ‑bu 'gü 'ö‑ pö: «Izraɛdhö mi ꞊dede ꞊nɛ, pö 'aa‑ ‑bha!» ");
INSERT INTO daf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","'Yö Natanaɛɛ ‑ya dhɛɛ\" kpɔ 'ö‑ pö: «I n dɔ ‑kɔ ‑kë ꞊dhɛ?» 'Yö Yesu ‑ya pö‑ ‑dhɛ: «\"Sanni Fidhipö ‑yö i ‑dhɛ, \"tʋ̈ng 'i gun ‑ya sië‑ 'ka figö ‑dhü ꞊wlöö bha kö n \"yan ‑yö i ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","꞊Dhɛ ꞊yaa‑ pö \"dhʋ̈, 'yö Natanaɛɛ ‑ya pö‑ ‑dhɛ: «N Dëmɛ, Atanna Gbö ‑mü i 'ka ꞊dedewo tɛan‑ 'ka, 'ma‑ ‑dhɛ yö, Izraɛdhö ‑mɛ ‑nu ‑bha ‑gblüdë ‑mü i 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑A pö 'a‑ wo i ‑dhɛ ꞊dhɛ n \"yan ‑yö ‑gun i ‑bha kö i ‑ya sië figö ‑dhü ꞊wlöö bha 'yö 'i 'dhang bho n \"dhiʋ̈ bha \"kɛɛ ('bha 'to n ꞊keng‑), i \"yan‑ ‑dho ‑da 'wɔn \"gblʋ̈gblʋ̈ ‑nu 'wo ‑ziö ‑a 'dhɛ 'kö bha‑ ‑ta ‑a ‑dhɛ 'gü!» ");
INSERT INTO daf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","'Yö‑ pö‑ ‑dhɛ 'bha wo 'zü 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ dhang‑ \"dhi‑ ‑dho \"pʋ 'ö 'ka‑ ‑dhɛ yö kö Atanna ‑bha \"kië ‑nu ‑wo ‑da sië 'wo ꞊lɔɔ mang Mɛgbömɛ n ‑ta.» ");
INSERT INTO daf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'ö ‑dhɛkpaɔyi ꞊ya ziö ꞊plɛ ‑a ‑yaaga ‑naa bha‑ 'ka kö ‑wo dhedɔ troo do kë sië 'pödhɛ 'wo‑ ‑dhɛ Kana 'ö Gadhidhe ‑sɛ 'gü bha‑ 'gü, kö Yesu dhe ‑yö mü, 'yö 'wo Yesu waa‑ ö bha ꞊klangdhiʋ̈ ‑nu ‑a ‑nu ‑dhɛ troo bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","꞊Dhɛ 'ö ꞊wa ‑drɔɔ mü 'ö‑ ꞊ya yën. 'Yö Yesu dhe ‑ya pö‑ ‑dhɛ: «‑A ‑nu ‑bha we bha ꞊ya yën ‑wa!» ");
INSERT INTO daf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","'Yö Yesu ꞊ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «\"Kɛɛ kö ma ‑zë 'a‑ kë ꞊dhɛ, dhebhɔnë, kö n ‑bha \"tʋ̈ng 'yii ꞊loo ꞊kö?» ");
INSERT INTO daf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö‑ dhe ‑ya pö gwëëzë ‑nu ‑dhɛ 'ö‑ pö: «Pë \"ʋʋ pë 'ö dho‑ pö ka ‑dhɛ ‑kaa kë ꞊zɔɔ 'dhɛ!» ");
INSERT INTO daf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Zuifö ‑nu ‑bha ‑zu 'ka \"yi 'bha 'ö‑ ‑nu wɔ ‑kɔ 'gü bha‑ ‑ya 'gü pë \"fië 'ö ‑gwë 'ka, 'ö‑ ‑yan do ‑yö ꞊mɔɔ ‑sangdhe këng do ‑nu ‑bha bha‑ \"saɔdo ‑yö ‑gun ‑dhɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","'Yö Yesu ‑ya pö gwëëzë ‑nu bha‑ ‑nu ‑dhɛ: «‑Ka pë \"fië ‑nu bha‑ \"dhiʋ̈ pa \"yi 'ka!» 'Yö 'wo‑ ꞊gban \"pɛpɛ \"dhiʋ̈ pa \"klënklëndhö. ");
INSERT INTO daf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","꞊Dhɛ 'ö ꞊waa‑ kë \"dhʋ̈, 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Kaa 'bha 'sü kö 'ka 'dho‑ 'ka troo ‑gɔmɛ ‑dhɛ!» 'Yö 'wo‑ 'bha sü 'wo dho‑ 'ka‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","'Yö troo ‑gɔmɛ bha 'ö \"yi 'ö Yesu ‑ya ‑gla we 'gü bha‑ din ‑ga. Yö ‑zë we bha 'yaa gun‑ 'godhɛ dɔ sië \"kɛɛ kö gwëëzë ‑nu 'kö 'wo‑ \"dhiʋ̈ ‑wlö sië bha wo ‑zë ‑wa ‑dɔ. 'Yö troo ‑gɔmɛ bha 'ö dhemɛdë ‑dhɛ, ");
INSERT INTO daf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","'yö‑ pö‑ ‑dhɛ: «('Yö‑ we 'dhɛ 'kö ya ‑yö ‑go 'mɛ 'yö‑ din‑ ‑kë ‑së \"dhʋ̈) we din ‑së ꞊në mɛ ꞊gban 'wo‑ ‑dɔ ‑dhɛng ‑dhɛ ‑blɛɛsü 'yö ꞊wa 'kën 'yö 'wo gun ‑na ‑a 'dhɛ 'ö‑ din ꞊ya 'go zian ‑ta bha‑ nu ‑a ‑nu ‑dhɛ, \"kɛɛ bhi ‑zë we 'dhɛ‑ din ꞊ya 'go zian ‑ta ꞊në 'i‑ nu ‑blɛɛsü 'yö 'i gun ‑na ‑a ‑së nu ꞊taama ‑wa!» ");
INSERT INTO daf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu ‑yö ö ‑bha \"dhabhliwɔn ‑blɛɛsü ‑kë Kana ‑pö 'ö Gadhidhe ‑sɛ 'gü bha‑ 'gü ‑kɔ bha ꞊në‑ 'gü, 'yö ö ‑bha 'tɔbhɔdhe ‑zɔn 'ka‑ ‑nu ‑dhɛ. 'Yö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ‑bha 'dhang ‑bho ‑a \"dhiʋ̈ ‑sü 'bha 'dhö ‑da 'gü. ");
INSERT INTO daf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu 'dhö, ‑a dhe 'dhö, ‑a dheebhang ‑nu 'dhö, ‑a ‑bha ꞊klangdhiʋ̈ ‑nu 'dhö, 'yö 'wo dho 'pödhɛ 'wo‑ ‑dhɛ Kapɛɛnaɔmö bha‑ 'gü 'yö 'wo ‑dhɛkpaɔyi 'bha ‑kë mü. ");
INSERT INTO daf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","꞊Dhɛ 'ö gun kö Zuifö ‑nu ‑bha troo 'wo‑ ‑dhɛ Pakö bha‑ yi 'yaa ꞊gblɛɛn 'zü, 'yö Yesu ‑yö dho Zedhizadhɛmö. ");
INSERT INTO daf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","꞊Dhɛ 'ö ꞊ya ‑da \"kwɛandhɛ 'ö Atanna ‑dhɔkëgükɔ 'dhö‑ ‑bha bha‑ 'gü, 'yö ‑kpan ‑du ‑nu oo, \"bhlaa ‑nu oo, ‑tong ‑nu ('ö Zuifö ‑nu ‑wa dhɔ kö ‑wo \"saa‑ bho‑ 'ka Atanna ‑dhɔkë 'gü ‑kɔ 'gü bha‑) \"dhɔɔdɔmɛ ‑nu ‑bha mü, waa‑ 'mɛ 'wo nu 'wëë‑ fië bho 'wëë‑ 'dhɛ 'ö Atanna ‑dhɔkëgükɔ 'gü mü ‑bha ‑bha bha‑ ‑nu 'dhö 'pö kö ‑wo ‑ya sië woo‑ ‑tabɛdhi ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","꞊Dhɛ 'ö ꞊ya ‑kpan ‑nu ‑bha ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö ö ‑kɔ ‑da bhiëga 'bha 'gü 'yö‑ ‑kë ꞊dhɛ ꞊klangga 'dhö, 'yö‑ ‑nu ꞊gban \"pɛpɛ ‑kë ‑dhɛ bha‑ 'gü waa‑ ‑nu ‑bha ‑du ‑nu waa‑ \"bhlaa ‑nu 'dhö, 'yö 'wëë‑ fiëbhomɛ ‑nu ‑bha 'wëë‑ ꞊gban ꞊wɛnng, 'yö‑ ‑nu ‑bha ‑tabɛdhi ‑nu \"dhiʋ̈ ‑zuö, ");
INSERT INTO daf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","'yö‑ pö ‑tong \"dhɔɔdɔmɛ ‑nu ‑dhɛ: «Pë ‑nu bha ‑kaa ‑nu bho bha, 'ka 'dho n Dë ‑bha 'kɔ kë kaa‑ \"dhɔɔ ‑kɔ 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","꞊Dhɛ 'ö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ꞊waa‑ ma \"dhʋ̈, 'yö‑ ‑nu ‑zʋ ‑yö ‑bö ‑wʋ 'ö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü 'ö‑ pö: ‹Atanna ‑wɔn ‑yö ‑dɔ n ‑zʋ ‑bha ꞊dhɛ pɛng 'dhö› bha‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","꞊Dhɛ 'ö ꞊ya bo ‑a ‑nu \"piʋ̈ kë ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö Zuifö ‑nu ‑gɔmɛ ‑nu 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «‑A kë 'i‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ‑më 'ka? ‑Më ꞊në dho ꞊mɔɔ‑ ‑bha kö ‑ya ‑zɔn yi ‑dhɛ ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'i‑ kë \"dhʋ̈, ‑a ‑pë ‑zɔn yi ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Ka Atanna ‑dhɔkëgükɔ ya‑ 'wü, a ‑dho dɔ ‑dhɛkpaɔyi ‑yaaga 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","'Yö 'wo‑ pö‑ ‑dhɛ: «'Ö ‑më! 'Kɔ 'yi‑ dɔ ‑kwɛ ‑kaɔng ‑yiisiö ga \"saɔdo 'ka ya bhi ‑zë i‑ ‑pö i ‑dho dɔ ‑dhɛkpaɔyi ‑yaaga 'ka ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'Sa Atanna ‑dhɔkëgükɔ 'ö Yesu ‑ya pö \"dhʋ̈ bha pë \"wɛɛ 'bha 'yaa ‑mü, ‑yö ‑wɩ ö ‑dɩ ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","꞊Dhɛ 'ö‑ yi ꞊ya ꞊gwëë 'ö Yesu ꞊ya ga 'ö ꞊ya ‑bö (‑a ‑dhɛkpaɔyi ‑yaaga ‑naa bha‑ 'ka), 'yö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ‑zʋ 'dhö ‑bö ꞊dhɛ ‑yö kë‑ pö wo ‑dhɛ \"dhʋ̈ yi do 'ka, 'yö 'wo 'dhang bho Atanna ‑wʋ 'ö ‑bɛn zë ‑sü 'ka 'sëëdhɛ 'gü waa‑ 'dhɛ 'ö Yesu ‑ya pö 'pö bha‑ ‑nu \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","\"Tʋ̈ng 'ö Yesu gun‑ 'ka Zedhizadhɛmö Pakö troo ‑ta bha, ‑yö kë \"dhabhliwɔn ‑nu ‑kë 'ö mɛ 'gbɛ 'wo 'dhang bho‑ \"dhiʋ̈ ‑a ‑wɔn 'gü, ");
INSERT INTO daf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","\"kɛɛ Yesu ‑zë 'yii 'dhang bho‑ ‑nu \"dhiʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑ya nu zuëpiʋ̈wɔn ‑dɔ 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","‑A ‑mawɔn 'yaa gun‑ ‑bha kö ‑wo mɛ sɔng ‑gɛn dɔ‑ ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö mɛ \"bhɩɩ‑ ‑nu zuëpiʋ̈wɔn ‑dɔ. ");
INSERT INTO daf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","꞊Dhɛ 'ö yi do 'ka 'yö Zuifö ‑nu ‑bha ‑gɔmɛ do 'wo‑ ‑dhɛ Nikodɛmö, \"kɛɛ 'ö ‑kë Fadhiziɛn 'ka, ");
INSERT INTO daf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","'yö nu Yesu \"piʋ̈ gbeng, 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ, yi‑ 'wɔn ‑dɔ ꞊dhɛ Atanna ꞊në i bɔ kö 'i mɛ \"bhɩɩ‑ ‑nu draan‑; ‑a ‑gɛn ‑mü ꞊dhɛ \"dhabhliwɔn suu ‑nu 'i‑ ‑kë sië ya mɛ 'bha ‑kɔ 'yaa ꞊mɔɔ‑ ‑bha kö ‑ya kë kö Atanna 'yaa‑ ‑mɛ \"piʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Yesu ‑ya pö‑ ‑dhɛ: «A‑ ‑pö i ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Mɛ \"ʋʋ mɛ 'ö 'bhii bhɔ ‑deewo, 'bhii 'dho ‑da Atanna ‑bha ‑gblüdëdhɛkëmɛ ‑nu ‑bhiëë 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","'Yö Nikodɛmö ‑ya pö‑ ‑dhɛ: «Mɛ 'bha‑ ‑mɔɔ ‑bha 'ö bhɔ 'ö go mü 'zü ‑deewo 'ö ‑da ö dhe \"gblʋ̈ʋ̈‑ ‑ee? \"Ɛɛn 'bha‑ pö \"dhʋ̈ kö i‑ ‑pö ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «A‑ ‑pö i ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ mɛ \"ʋʋ mɛ 'ö Atanna 'yii i 'kpɔ ‑deewo \"yi waa‑ 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑kɔ 'ka, 'bhii 'dho ‑da ‑bha ‑gblüdëdhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö bhɔ dhe waa‑ gɔn ‑a ‑nu suu 'gü, mɛ ‑dhɛ zuëga ꞊në ‑kë ‑mɛ ‑gɔ; \"kɛɛ 'mɛ 'ö Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑ya ‑gla bha, Atanna zuë\" ꞊në ‑kë ‑mɛ ‑zë ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‑A pö 'a‑ wo i ‑dhɛ ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'ka bhɔ ‑deewo bha 'ya 'dho i \"gblʋ̈ʋ̈dhɛ \"muu bho; ‑a ‑gɛn ‑mü ꞊dhɛ ");
INSERT INTO daf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑bha mɛ \"gla ‑sü bha ‑yö ‑kë ꞊dhɛ \"tɛɛ 'ö ‑ziö ꞊sië bha ꞊në‑ 'dhö; ‑yö ‑ziö ‑dhɛ 'ö ‑dhi ‑dhɛ ꞊në‑ 'gü, 'ö mɛ ‑ya vin ma, \"kɛɛ 'bhaa‑ 'godhɛ waa‑ 'dhodhɛ 'bha dɔ. ");
INSERT INTO daf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","'Yö Nikodɛmö ‑ya pö‑ ‑dhɛ: «Yö ‑zë 'zü ‑yö kë ‑kɔ ‑kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑A kë ‑sü kö bhi 'i ‑kë Atanna ‑wʋ ‑gɔmɛ 'kpii‑ do 'ka Izraɛdhö ‑sɛ 'gü bha 'bhaa 'wɔn ‑nu bha‑ ‑nu dɔ bha‑ 'wɔn ‑yö n ‑kɔn. ");
INSERT INTO daf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A‑ ‑pö i ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'wɔn 'yi‑ dɔ, 'ö yi \"yan‑ ‑yö ‑da 'gü ꞊në 'yi‑ pö ka ‑dhɛ, \"kɛɛ 'kaa \"wɩ‑ ‑bha kö 'ka 'dhang bho‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","꞊Ya kë ꞊dhɛ 'wɔn ‑nu 'wo ‑gban Atanna ‑bha, 'ö \"kpʋngtaadhɛ ya‑ 'gü 'ma‑ ‑dhiang zë ka ‑dhɛ 'kii‑ 'gü ma, ‑a 'dhɛ 'kö ‑gban ‑bha dhang‑ 'gü 'ma‑ ‑dhiang zë ka ‑dhɛ ka ‑dho ‑a 'gü ma ‑kɔ kë ꞊dhɛ 'yö 'ka 'dhang bho‑ \"dhiʋ̈, ");
INSERT INTO daf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","\"kɛɛ kö mɛ 'bha 'yii 'dho ‑dhɛ 'ö‑ ‑bha dhang‑ 'gü bha‑ 'gü do kö 'yii kë mang Mɛgbömɛ 'a go 'mü 'a ꞊lɔɔ \"kpʋng ꞊taa yö bha ma ‑zë n 'ka?» ");
INSERT INTO daf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","‑Bhö ‑dhɛ ‑ga, ‑kɔ do 'ö Moizö ‑yö ‑mlɛɛ \"blɛɛn‑ ‑kë 'ka yi 'bha 'ka zën 'ka 'ö‑ dɔ \"dhü ‑bha \"wla ‑ta bha, ‑wo ‑dho Mɛgbömɛ dɔ \"dhü bha 'pö ‑kɔ do bha‑ 'gü, kë \"dhʋ̈ kö mɛ \"ʋʋ mɛ 'ö ꞊ya 'dhang bho‑ \"dhiʋ̈, kö ꞊sii 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha ‑yö kë‑ ‑mɛ ‑dhɛ 'pö (꞊dhɛ ‑kɔ do 'ö ‑kë 'ka Izraɛdhö ‑mɛ ‑nu kpö 'gü yi 'bha 'ka, 'ö 'mɛ ꞊ya ö \"yan \"dhiʋ̈ \"wlü kö ‑yö ‑mlɛɛ bha‑ ‑ga 'ö gun dha sië bha‑ 'dhö.) ");
INSERT INTO daf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ mɛ \"bhɩɩ‑ ‑nu ‑dhɔ 'ö Atanna ‑kë ‑a \"sinma 'yaa 'dhö. Yö ꞊në‑ ‑wɔn 'gü 'yö 'në ga do 'ö‑ ‑gɔ ‑a bɔ‑ ‑nu ‑dhɛ, kö mɛ \"ʋʋ mɛ 'ö dho 'dhang bho‑ \"dhiʋ̈, kö ‑tosɛa 'ö 'yaa yën 'ö‑ \"piʋ̈ bha ‑yö kë‑ ‑mɛ ‑dhɛ, kö‑ ‑mɛ 'gü 'ya 'dho see‑. ");
INSERT INTO daf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Atanna ‑yö ö Gbö ‑bɔ mɛ \"bhɩɩ‑ ‑nu ‑dhɛ kö ‑ya ‑nu dha ꞊në‑ wo, 'yii‑ bɔ kö ‑yö za ‑zë dɔ‑ ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","\"Kɛɛ 'mɛ 'kö 'yii 'dhang bho‑ Gbö bha‑ \"dhiʋ̈, kö za ‑ya ‑bha. ‑A ‑gɛn ‑mü ꞊dhɛ kö 'yii 'dhang bho Atanna ‑bha 'në ga do bha‑ \"dhiʋ̈. 'Mɛ 'kö ꞊ya 'dhang bho 'pö‑ Gbö bha‑ \"dhiʋ̈ kö za ꞊ya 'go‑ ‑mɛ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Za kë mɛ ‑bha ‑gɛn ‑mü ‑më 'ka? ‑A ‑gɛn ‑mü ꞊dhɛ (Atanna Gbö 'ö ‑kë) ‑dhɛpuudhɛ 'ka bha ꞊ya nu \"kpʋng ꞊taa, \"kɛɛ mɛ \"bhɩɩ‑ ‑nu këwɔn 'bha 'yaa kë 'ö‑ wo ‑së bha, 'yö 'wo wo ‑to ‑dhɛ tii 'gü ‑sü fië‑ bho ‑dhɛ ‑pʋ wo ‑ta ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","‑A ‑gɛn ‑mü ꞊dhɛ mɛ \"pɛpɛ 'wo 'wɔn yaa ‑kë, ‑dhɛpuudhɛ ‑san ‑ya ‑nu ‑kë. 'Waa \"wɩ‑ ‑bha kö ‑wo ‑wo zang ‑ta, kë \"dhʋ̈ kö‑ ‑nu këwɔn yaa ‑nu bha ‑wo 'to ‑gblɛn 'kpɔ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","\"Kɛɛ 'mɛ 'kö Atanna ‑wʋ 'dhö 'pë 'ö‑ pö, 'ö yö ꞊në tɛanwɔn 'ka bha‑ 'gü ‑wɔn ‑kë, ‑a ‑mɛ 'yaa \"suʋ̈ ‑dhɛpuudhɛ ‑gɔ. Kë \"dhʋ̈ kö ‑wo \"yan ‑kpan ö këwɔn ‑së ‑nu ‑bha. ‑A ‑gɛn ‑mü ꞊dhɛ ‑yö ö zü ‑gban Atanna ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu waa‑ ö ‑bha ꞊klangdhiʋ̈ ‑nu 'wo dho Zude ‑sɛ 'gü, 'yö wɛng‑ ‑nu 'wo to mü \"tʋ̈ng 'në 'bha 'ka 'yö 'wo mɛ ‑nu ‑go 'wɔn yaa 'gü ‑zu bho. ");
INSERT INTO daf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","‑A \"tʋ̈ng bha‑ 'gü kö Zan ‑dɩ 'pö ‑yö mɛ \"zu sië 'pö ‑dhɛ 'wo‑ ‑dhɛ ‑dhɛ Ɛnɔ, 'ö ‑ya ‑sü 'ka 'pödhɛ 'wo‑ ‑dhɛ Sadhimö ‑a \"sɔɔ bha‑ 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ \"yigɔ 'gbɛ ‑yö ‑gun ‑dhɛ bha‑ 'gü. Mɛ ‑nu ‑gun 'dho sië‑ \"piʋ̈ (‑dhɛ bha ꞊në‑ 'gü) 'yö‑ ‑nu ‑zu. ");
INSERT INTO daf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","('Ö \"dhʋ̈ bha kö 'wii Zan ‑da ꞊kö ‑kaso 'gü.) ");
INSERT INTO daf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Zan ‑bha ꞊klangdhiʋ̈ ‑nu bha‑ mɛ 'bha ‑nu waa‑ Zuifö mi do 'wo ‑ya zaɔdhe ‑da ‑sü ‑bha 'wɔn 'ö ‑gban ‑a ‑nu ‑bha ‑kë \"slʋ̈ʋ̈slʋ̈ ‑zu bho ‑sü 'ö‑ ‑nu wɔ ‑kɔ 'gü ‑a ‑bha bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö 'wo dho Zan \"piʋ̈ 'yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, ‑dhɛ ‑ga, 'mɛ 'i‑ ‑dhiang zë yi ‑dhɛ yuënggü Zuudɛn ꞊taama bha ‑yö mɛ ‑go 'wɔn yaa 'gü ‑zu bho sië, mɛ 'kpii‑ ‑dhɛ ꞊gban ‑wo 'go sië i \"piʋ̈ 'wo dho yö ꞊në‑ ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","'Yö Zan ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Atanna 'yii i gba ‑duɛ 'ö‑ 'ka 'bhaa‑ ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kaa ꞊dede ka ‑mɔɔ ‑bha 'ka‑ \"sɛɛdhɛ ‑kë ꞊dhɛ a kë‑ ‑pö ka ‑dhɛ ꞊dhɛ ma ‑zë 'mii kë Atanna ‑bha ‑Yamɛ bha‑ 'ka, \"kɛɛ a ‑kë ‑a \"dhiʋ̈ ‑naɔdɔmɛ ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","‑Yö kë ka \"yaan ꞊dhɛ ma ‑zë a ꞊dhɛ 'mɛ 'wo nu sië‑ ‑bha dhe dɔ ‑a \"taɔngdë ꞊në‑ 'dhö. ‑A dhebhɔ ‑zë ‑yö dhemɛdë ꞊në‑ ‑bha 'ka, \"kɛɛ 'yö‑ \"taɔngdë ‑zë 'ö dɔ‑ \"sɔɔ, 'yö‑ ‑wʋ ma, 'yö‑ ꞊nii ‑yö ‑da. ‑Kɔ 'ö n ꞊nii 'dhö ‑da sië‑ 'ka (\"tʋ̈ng ya‑ 'gü) 'yö bha; ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn 'a‑ pö ‑a 'gü ‑wɔn ꞊ya kë. ");
INSERT INTO daf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","‑A ‑dhɛa ‑bha ꞊dhɛ yö ꞊në‑ ‑duɛ ‑yö kë 'kpii‑ ‑kpɛawo ma ‑zë n ‑bha ‑bha, ");
INSERT INTO daf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö go Atanna \"piʋ̈ yö ‑zë ‑duɛ ‑yö 'kpii‑ 'ö ‑ziö mɛ ꞊gban \"pɛpɛ ‑bha ‑ta. Mɛ 'ö bhɔ mɛ \"bhɩɩ‑ ‑nu suu 'gü kö \"kpʋngtaamɛ ‑mü. Pë 'ö \"kpʋng ꞊taa yö 'yö‑ ‑dhiang zë, \"kɛɛ 'mɛ 'ö go Atanna \"piʋ̈ ‑a ‑duɛ ‑yö mɛ ꞊gban ‑bha ‑ta \"dhʋ̈ng 'gü; ");
INSERT INTO daf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","‑a ‑gɛn ‑mü ꞊dhɛ 'pë 'ö‑ yö, 'yö‑ ‑dhiang zë, ‑a 'dhɛ 'ö‑ \"tʋ ‑ya ma, 'yö‑ pö, \"kɛɛ mɛkpiidhɛ ꞊në 'waa 'dhang bho‑ ‑bha \"sɛɛdhɛ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","‑A ‑wɔn 'gü, 'mɛ 'ö ꞊ya 'dhang bho‑ \"dhiʋ̈, 'yö ö ‑kɔ ‑ya ‑wɔn ‑bha, 'yö‑ 'wɔn dɔ ꞊dhɛ pë \"pɛpɛ 'ö Atanna ‑ya pö ‑a 'bha 'yaa ꞊sua 'ka. ");
INSERT INTO daf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","'Mɛ 'ö Atanna ꞊yaa‑ bɔ, ‑a ‑mɛ ‑ya ‑wʋ ꞊në‑ \"dhiʋ̈ ꞊loo, ‑a ‑gɛn ‑mü ꞊dhɛ 'yaa ö bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ dan kö ‑ya nu‑ ‑mɛ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","꞊Dhɛ 'ö ‑kë ꞊dhɛ ‑a Gbö ‑dhɔ ‑ya ‑kë, 'yö pë ꞊gban \"pɛpɛ dɔ‑ ‑kɔ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","'Mɛ 'ö ꞊ya 'dhang bho‑ \"dhiʋ̈, kö ‑tosɛa 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha ꞊yaa‑ ꞊slɔɔ, \"kɛɛ 'mɛ 'yii‑ Gbö ꞊bhlëë ‑ya, ‑tosɛa bha‑ ‑mɛ 'yii 'dho‑ ꞊slɔɔ; ‑a ‑gɛn ‑mü ꞊dhɛ kö ‑yö ö ‑dɩ ‑ya ‑sü 'ka Atanna ‑bha 'wɔn ‑bho mɛ 'gü ‑sü ꞊në‑ ‑bha ‑ya 'gü. ");
INSERT INTO daf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Fadhiziɛn ‑nu 'wo‑ ma ꞊dhɛ 'mɛ 'wo bɔ Yesu 'ka 'wo‑ ‑nu ‑go 'wɔn yaa 'gü ‑zu bho sië ꞊wa kë 'gbɛ ꞊wa ziö Zan ‑bha ‑ta, (\"kɛɛ tɛan‑ ꞊dede 'ka, Yesu ‑zë 'yaa gun mɛ 'bha \"zu sië. ‑A ‑bha ꞊klangdhiʋ̈ ‑nu ꞊në 'wo gun mɛ \"zu bha‑ bho sië). ꞊Dhɛ 'ö Yesu ꞊yaa‑ ma \"dhʋ̈, 'yö go Zude ‑sɛ 'gü 'yö ö yee ‑kë 'ö dho Gadhidhe ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","‑A 'dho ‑sü 'ka ‑a ‑dhɛ ‑gun ‑bha ꞊dhɛ ‑yö bɔ Samadhi ‑sɛ ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo 'pödhɛ do 'bha 'ö \"sɛ bha‑ 'gü 'wo‑ ‑dhɛ Sisiaa, 'ö ‑ya ‑sü 'ka 'bhlaadhɛ 'ö Zakɔbö ‑ya nu ö gbö Zosɛfu ‑dhɛ yi 'bha 'ka bha‑ \"sɔɔ bha‑ 'gü, ");
INSERT INTO daf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","‑a \"tʋ̈ng bha‑ 'gü kö 'yënng‑ ꞊ya ‑ya mɛ ‑gɔ ꞊zinng 'gü, 'yö ꞊loo Zakɔbö ‑bha ‑klɔng \"dhiʋ̈ kö‑ 'gü ꞊ya ga, 'yö dho 'yö ‑ya ‑klɔng bha‑ \"kpʋng \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","'Ö gun \"dhʋ̈ kö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ꞊wa 'dho ‑bhöpë 'dhɔ ‑dhɛ 'gü 'pödhö. 'Yö dhebhɔnë do 'ö go Samadhi ‑sɛ bha‑ 'gü 'ö nu \"yi 'tɔdhɛ 'gü. 'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Bhö n ‑bha \"yi nu 'kaa‑ mü!» ");
INSERT INTO daf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Yö bhi kö 'i ‑kë Zuifö 'ka ‑yö kë ‑kɔ ‑kë ꞊dhɛ 'yö 'i‑ pö a i gba \"yi 'ka \"kɛɛ kö ma ‑zë a ‑kë Samadhi dhebhɔ 'ka!» (‑A ‑yɔ 'ö‑ bɔ \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ Samadhi ‑mɛ ‑nu bha waa‑ Zuifö ‑nu 'waa gun wo 'ko ‑dhɛ ‑së ‑kpɛidhö.) ");
INSERT INTO daf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «꞊Ya kë 'nu ꞊dhɛ 'pë 'ö Atanna ‑ya ꞊gbaɔ mɛ \"bhɩɩ‑ ‑nu ‑gɔ bha 'i‑ ‑dɔ, 'ö 'mɛ 'ö \"yi ‑gbadhɛ sië i ‑gɔ kö 'ö‑ mü bha 'i‑ dɔ, kö bhi ꞊në 'i dho \"yi ‑gbadhɛ yö ‑zë ‑gɔ 'nu 'yö \"yi ziösü nu i ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","'Yö dhebhɔnë ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N Dëmɛ, ‑a \"yi 'kö \"dhʋ̈ i ‑dho ‑a nu ‑kɔ kë ꞊dhɛ n ‑dhɛ kö ‑klɔng ‑tɔ 'ka ‑pë 'yaa i ‑gɔ, \"kɛɛ kö ‑klɔng ya ‑yö ꞊gblɛɛn. ");
INSERT INTO daf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","(\"Ɛɛn ‑a \"yi 'dhɛ 'kö \"dhʋ̈‑ suu‑ mü ꞊dhɛ? \"Ɛɛn yö ‑zë ꞊bhlëë ꞊në 'kpii‑ 'ö ‑ziö ‑a 'dhɛ 'ö) yi \"bhɛma Zakɔbö ‑ya pɔn yi ‑dhɛ, 'ö yöö ꞊dede 'ö‑ 'bha mü, 'ö‑ bhang ‑nu waa‑ ‑bha ‑tuʋ̈ ‑nu 'wo‑ 'bha mü 'pö ya‑ ‑ta ‑ee? \"Ɛɛn bhi ꞊në bhi ‑zë i ꞊bhlëë 'dhö 'kpii‑ 'ö ‑ziö yi \"bhɛma Zakɔbö ꞊dhɛ 'ö ‑kë ꞊dhɛ i ‑mɔɔ ‑bha 'i \"yi suu \"wɛɛ nu yi ‑dhɛ bha‑ ‑wɔn 'gü ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Mɛ 'ö \"yi 'dhɛ 'kö ya‑ mü, \"yi mü ‑dhɔ ‑dho ‑a mɛ kë ‑deewo, ");
INSERT INTO daf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","\"kɛɛ mɛ \"ʋʋ mɛ 'ö \"yi 'a dho‑ nu‑ ‑dhɛ bha‑ mü, \"yi mü ‑dhɔ 'yii 'dho‑ ‑mɛ kë 'zü tongtongdhö; ‑a ‑gɛn ‑mü ꞊dhɛ \"yi 'dhɛ 'a dho‑ nu‑ ‑mɛ ‑dhɛ bha ‑yö ‑dho kë \"yi ziösü 'ö ‑tosɛa 'ö 'yaa yën ‑a ‑kë mɛ ‑dhɛ bha‑ 'ka 'ö‑ ‑gɔ ‑yö bhɔ‑ ‑mɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö dhebhɔnë bha 'ö‑ pö‑ ‑dhɛ: «N Dëmɛ, ‑bhö ‑a \"yi suu bha‑ nu n ‑dhɛ 'sa kö \"yi mü ‑dhɔ 'ya 'dho n kë 'zü, \"ɛɛn kö 'ma 'dho nu \"yi 'tɔ ‑dhɛ ya‑ 'gü 'zü ‑dhe!» (‑Yö ‑kë 'gü ꞊dhɛ \"yi ꞊dede kwa‑ mü sië ya ꞊në Yesu ‑ya ‑dhiang zë bha.) ");
INSERT INTO daf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Bhö 'dho kö 'i i ꞊gɔn ‑dhɛ kö kɛng 'ka nu!» ");
INSERT INTO daf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","'Yö dhebhɔnë ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Maa gwaan‑ ‑bha.» 'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑A pö 'i‑ wo 'bhaa gwaan‑ ‑bha bha tɛan‑ ‑mü, ");
INSERT INTO daf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","‑a ‑gɛn ‑mü ꞊dhɛ 'bha gwaan‑ 'kpɔ \"sɔɔdhu, mɛ 'dhɛ 'i‑ ‑kɔ ‑bha ꞊dɛɛ 'yënng‑ ya‑ 'gü bha i ꞊gɔn 'yaa ‑mü, 'bhii ꞊sua kë.» ");
INSERT INTO daf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","'Yö dhebhɔnë ‑ya pö‑ ‑dhɛ: «N Dëmɛ, 'ma‑ 'wɔn dɔ ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ‑mü i 'ka, (‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn \"pɛpɛ 'ö gun ma ‑tosɛa 'gü 'bha‑ ꞊gban pö.) ");
INSERT INTO daf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","\"Kɛɛ ‑a pö 'ö Zuifö ‑nu 'ka‑ wo ꞊dhɛ Atanna ‑dhɔkë ꞊dhɛ 'ö 'dhö ‑yö Zedhizadhɛmö ꞊naa, \"kɛɛ kö yi \"bhɛma ‑nu ‑zë ‑wo wo ‑bha ‑dhɔkë ‑tɔn ya ꞊në‑ ꞊gbin‑ bha (bhi ‑zë i i ‑bha ‑pö 'gü ꞊dhɛ?).» ");
INSERT INTO daf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","'Yö Yesu ꞊ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Yö kë i \"yaan ꞊dhɛ Atanna bha 'nii‑ ‑mü, ‑a ‑wɔn 'gü 'mɛ 'wo dho‑ ‑dhɔkë, ‑a \"tʋ̈ng ‑dho ꞊loo 'ö 'wii 'dho 'dho ‑tɔn ya‑ ꞊gbin‑ ‑dhɛ yöö do‑ 'gü, \"ɛɛn Zedhizadhɛmö ‑dhɛ ‑zian 'gü, (\"kɛɛ 'ö 'wo dho‑ ‑dhɔkë ‑dhɛ ꞊gban \"pɛpɛ ꞊në‑ 'gü); ‑a ‑gɛn ‑mü ꞊dhɛ Samadhi ‑mɛ ‑nu 'ka bha 'pë 'ka‑ ‑dhɔkë bha 'kaa‑ dɔ. 'Yö 'mɛ 'kö 'yi ‑kë Zuifö 'ka bha yi ‑zë 'pë 'yi‑ ‑dhɔkë bha 'yi‑ dɔ. ‑A 'klɔɔ‑ ‑mü ꞊dhɛ Atanna ‑yö ‑bɔ Zuifö ꞊në‑ ‑nu ‑ta 'yö mɛ \"bhɩɩ‑ ‑nu dha. ‑A ‑wɔn 'gü ‑a \"tʋ̈ng ‑dho ꞊loo, 'ö ꞊ya ꞊loo ‑zianwo, 'ö Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ö tɛanwɔn 'ö‑ ‑wɔn 'gü ‑a ‑zɔn mɛ ‑dhɛ bha 'ö‑ ‑kë kö mɛ \"bhɩɩ‑ ‑nu ‑wo n Dë Atanna bha‑ ‑dhɔkë (‑dhɛ ꞊gban \"pɛpɛ 'gü). ꞊Dhɛ 'ö ‑kë ꞊dhɛ Atanna bha 'Nii‑ ‑mü bha ‑a ‑dhɛa ‑bha ꞊dhɛ 'mɛ 'wo dho‑ ‑dhɔkë 'pö bha‑ ‑bha tɛanwɔn pö 'Nii‑ bha ‑ya \"sɩ kë‑ ‑nu ‑dhɛ kö ‑wa ‑dhɔkë ꞊dhɛ ‑kɔ 'ö‑ 'ka ‑a 'dhö; ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö mɛ suu 'ö \"dhʋ̈ ꞊në‑ ꞊mɔɔ kö ‑wa ‑dhɔkë.» ");
INSERT INTO daf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","'Yö dhebhɔnë ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «A‑ 'wɔn ‑dɔ ꞊dhɛ Atanna ‑bha ‑Yamɛ 'wo‑ Klisi ‑kë bha ‑yö ‑dho nu. ꞊Dhɛ ꞊ya nu yö ꞊në dho 'wɔn ꞊gban 'klɔɔ‑ pö yi ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Ma 'a dhiang zë sië i ‑dhɛ ya ma ꞊në 'wo n ‑dhɛ \"dhʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","‑A \"tʋ̈ng ꞊dede bha‑ 'ka 'yö‑ ‑bha ꞊klangdhiʋ̈ ‑nu 'wo go 'pödhö 'wo nu. ‑Kpan 'wo‑ wo‑ ‑bha kö waa‑ dhebhɔnë bha ‑wo dhiang zë sië bha 'yö‑ 'wɔn ‑ya ‑nu kɔn, \"kɛɛ ‑a ‑nu 'bha 'wii ꞊mɔɔ‑ ‑bha kö ‑wa dhɛɛ\" 'kpɔ kö ‑wa pö: «I ‑bha ‑më ꞊në‑ ‑gɔ?» \"ɛɛn «ka ‑më ‑dhiang ꞊në‑ zë sië?». ");
INSERT INTO daf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö dhebhɔnë bha 'ö ö bha \"yigbɔ to 'mü 'yö ö yee ‑kë 'ö dho 'pödhö 'yö‑ pö 'pömɛ ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«‑Ka nu kö 'ka ‑dhɛ 'bha ‑ga! 'Mɛ 'ö ya 'wɔn ‑nu 'a‑ ‑kë ‑ya ꞊gban ‑dɔ, ꞊yaa‑ ꞊gban pö n ‑dhɛ \"pɛɛpɛdhö (\"kɛɛ kö 'mii‑ yö ‑zianwo do)! Atanna ‑bha ‑Yamɛ bha 'yaa ‑mü \"wɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö 'pö‑ bha‑ 'gü ‑mɛ ‑nu 'wo dɔ ‑bɛang ‑bha 'wo dho Yesu ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","\"Tʋ̈ng 'ö kë sië‑ 'ka \"dhʋ̈ bha kö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ‑zë ‑wo ‑gban sië‑ ‑bha pë ‑bhö ‑wɔn ꞊në‑ 'ka 'wo‑ pö: «Yi Dëmɛ, ‑bhö pëbhee 'në 'bha ‑zë ‑bhö.» ");
INSERT INTO daf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","\"Kɛɛ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «'Pë 'ö n ‑bhöpë 'ka 'kaa‑ dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'Yö‑ ‑bha ꞊klangdhiʋ̈ ‑nu 'wo ‑ya wo 'ko ‑nu dhɛɛ\" 'kpɔ ‑sü ‑bha 'wo‑ pö: «\"Ɛɛn mɛ 'bha ꞊në ꞊ya nu‑ ‑dhɛ ‑bhöpë 'ka 'nu ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «'Mɛ 'ö n bɔ bha‑ ‑zʋ \"piʋ̈ ‑wɔn kë ‑sü waa‑ yë 'ö‑ nu n ‑dhɛ ‑a \"dhiʋ̈ ‑ta ‑sü bha ꞊në ꞊dhɛ n ‑bhöpë 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","\"Ɛɛn 'waa‑ pö kwa ‑wʋ 'gü ꞊dhɛ «\"Su ꞊ya 'to ‑yiisiö kö 'kwa ‑mlü \"kan ‑ee?») \"Kɛɛ ma ‑zë a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'ka ka \"yan \"dhiʋ̈ \"wlü kö 'ka ‑dhɛ ‑ga. 'Mɛ 'wo nu sië ‑yɛɛdhö bha ‑kaa ‑nu ‑ta ‑ga, ‑wo ꞊dhɛ 'bhlaadhɛ 'ö‑ ‑mlü ꞊ya ‑pë kë ꞊në‑ 'dhö bha. ");
INSERT INTO daf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","'Mɛ 'ö ‑mlü ta ꞊yaa‑ \"kan kö ‑ya dɔ ꞊gbaandhö kö yë 'ö‑ ‑kë bha ꞊yaa‑ ꞊saa ꞊në‑ 'sü bha, ‑a ꞊nii ‑yö ‑da. ‑Kɔ do bha‑ 'gü 'mɛ 'ö 'dhang ‑bho Atanna \"dhiʋ̈ ‑mɛ ‑nu ꞊loo 'ko ‑ta, ‑a ꞊nii ‑yö ‑da 'pö ‑a ‑nu ‑bha ‑da ‑tosɛa 'ö 'yaa yën ‑a kë ‑dhɛ 'gü ‑sü bha‑ ‑wɔn 'gü. ‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, kö 'mɛ 'ö ‑mlü bɔ waa‑ 'mɛ 'ö‑ ‑kan, ‑a ‑nu ꞊nii ‑yö ‑da ꞊dhɛ 'ko 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‑A ‑wɔn 'gü \"gwënng 'wo‑ ‑da 'wo‑ pö: «Mɛ 'bha ꞊në ‑mlü bɔ 'yö mɛ 'bha ‑ya ‑kan» bha 'yaa ꞊sua 'ka, ");
INSERT INTO daf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","‑a ‑gɛn ‑mü ꞊dhɛ 'bhlaadhɛ 'a ka bɔ‑ 'gü ‑mlü \"kan ‑dhɛ 'gü bha 'kii‑ ‑yë 'bha kë, mɛ \"wɛɛ ‑nu ꞊në 'wo‑ ‑ke ‑kë 'yö ka ‑zë ka dɔ‑ ‑nu \"gblʋʋ ‑ta bha. ");
INSERT INTO daf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samadhi ‑pö bha‑ 'gü ‑mɛ ‑nu 'wo dho Yesu ‑dhɛ 'gü bha ꞊dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo mü, ‑a mɛ 'gbɛ ꞊dede kë 'dhang ‑bho \"dhiʋ̈ ‑a pö 'ö dhebhɔnë bha 'ö‑ wo ꞊dhɛ «'Wɔn \"pɛpɛ 'a‑ ‑kë ꞊yaa‑ ꞊gban‑ pö n ‑dhɛ bha‑ ‑wɔn 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yö ꞊në‑ ‑wɔn 'gü 'yö 'mɛ 'wo nu bha 'wo ‑gban Yesu ‑bha ꞊dhɛ ‑yö ‑dhɛkpaɔyi 'bha kë wo \"piʋ̈ mü. 'Yö to 'mü 'yö ‑dhɛkpaɔyi ꞊plɛ ‑kë ‑a ‑nu ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Dhiang ‑nu 'ö Yesu ꞊dede 'ö‑ zë‑ ‑nu ‑dhɛ bha 'mɛ 'wo 'dhang bho‑ \"dhiʋ̈ ‑wo kë ‑kë 'gbɛ, 'wo ‑ziö 'mɛ 'wo 'dhang bho dhebhɔnë bha‑ ‑wʋ \"dhiʋ̈ ‑a ‑nu ‑ta. ");
INSERT INTO daf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","'Yö 'wo‑ pö dhebhɔnë bha‑ ‑dhɛ 'wo‑ pö: «'Dhang 'yi‑ bho sië‑ \"dhiʋ̈ ꞊taamasü ya‑ 'gü ya‑ 'klɔɔ‑ 'yaa ‑mü 'wɔn 'i‑ ‑gɛn dɔ yi ‑dhɛ bha‑ 'ka 'zü, \"kɛɛ yii ꞊dede 'ya‑ ‑wʋ ma, 'ya‑ 'wɔn dɔ 'pö ꞊dhɛ yö ꞊në Atanna ‑ya bɔ ꞊dedewo tɛan‑ 'ka kö ‑yö mɛ \"bhɩɩ‑ ‑nu dha. ");
INSERT INTO daf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","꞊Dhɛ 'ö Yesu ꞊ya ‑dhɛkpaɔyi ꞊plɛ kë ‑dhɛ bha‑ 'gü, 'yö waa‑ ꞊kengmɛ ‑nu 'wo go 'mü 'wo dho Gadhidhe ‑sɛ ('ö ‑kë ‑a ‑kpɔ 'gü ‑sɛ 'ka bha‑) 'gü. ");
INSERT INTO daf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","'Ö gun \"dhʋ̈ kö ꞊yaa‑ pö 'nu ꞊dhɛ «Atanna ‑wʋdhiʋ̈loomɛ ꞊bhlëë 'yaa kë ö ‑dɩ ꞊plöö». ");
INSERT INTO daf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","\"Kɛɛ ꞊dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo Gadhidhe ‑sɛ bha‑ 'gü, ‑a \"sɛ bha‑ 'gü ‑mɛ ‑nu 'ö ‑wɩ ‑nu 'ka \"dhʋ̈ bha ‑wo kë ‑dɔ ‑gɔ zian‑ ‑së 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ woo ‑dɩ 'pö ‑wo kë ‑dho Pakö troo ‑ta Zedhizadhɛmö 'ö 'wo 'wɔn ‑nu \"pɛpɛ 'ö gun‑ kë sië 'mü bha‑ ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö ö yee ‑kë 'zü ‑deewo 'ö dho Kana ‑pö 'ö \"yi ‑gla we 'gü ‑a 'gü \"tʋ̈ng 'bha 'gü bha‑ 'gü. ‑Gblüdë ‑bha ‑yamɛ ꞊bhlëësü do 'bha ‑yö ‑gun 'pö‑ bha‑ 'gü 'ö‑ gbö do 'gü 'yaa gun ‑së 'pödhɛ \"wɛɛ 'dhɛ 'wo‑ ‑dhɛ Kapɛɛnaɔmö bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","꞊Dhɛ 'ö mɛ bha ꞊yaa‑ ma ꞊dhɛ Yesu ꞊ya 'go Zude ‑sɛ 'gü ꞊ya nu Gadhidhe, 'yö dho‑ \"piʋ̈, 'yö ꞊bhɛa‑ ‑dhɛ kö wɛng 'wo 'dho Kapɛɛnaɔmö kö ‑ya gbö kë \"klʋ̈ʋ̈klʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö‑ gbö 'gü 'yaa ‑së ꞊dedewo, kö ꞊ya wɔ 'ya‑. ");
INSERT INTO daf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Ka ‑zë ka \"yan 'yii ‑da \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu 'gü, 'dhang ‑bho n \"dhiʋ̈ ‑sü 'yii 'dho kë ka ‑gɔ tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","'Yö ‑gblüdë ‑bha ‑yamɛ bha 'ö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N Dëmɛ, ‑bhö dɔ \"gbɩɩ‑ kö i nu kö 'kwa 'dho, 'yii kë \"dhʋ̈ n gbö bha yöö ga.» ");
INSERT INTO daf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Bhö 'dho, i gbö bha ꞊ya kë \"klʋ̈ʋ̈klʋ̈!» ꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈, 'yö 'mɛ bha 'ö 'dhang bho‑ ‑wʋ bha‑ \"dhiʋ̈ 'yö dho. ");
INSERT INTO daf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","꞊Dhɛ 'ö gun 'dho sië, ‑yö ‑to zian ‑ta 'yö ‑kpan ‑a ‑bha gwëëzë ‑nu ‑bha kö ‑wo nu sië ‑dɔ ‑gɔ zian ‑dhɛ 'gü. ꞊Dhɛ 'ö ꞊wa ‑kpan ‑bha 'yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, i gbö ꞊ya dha!» ");
INSERT INTO daf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","'Yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «‑Yö ö ‑dɩ ‑slɔɔ ‑më \"tʋ̈ng 'gü?» 'Yö 'wo‑ pö‑ ‑dhɛ: «‑Yö ‑kë \"dhʋ̈ yaan \"dhiʋ̈ kö 'yënng‑ ꞊ya 'kpɔ mɛ ‑gɔ 'ka ‑dee 'gü. Pɛng‑ ‑zɔɔ kwi 'gü \"tʋ̈ng bha ꞊në‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈ 'yö gɔndënë bha‑ ‑zʋ ‑yö ‑bö ꞊dhɛ \"tʋ̈ng ꞊dede bha ꞊në Yesu ‑ya pö‑ 'ka ö ‑dhɛ ꞊dhɛ ö gbö ꞊ya kë \"klʋ̈ʋ̈klʋ̈. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö waa‑ \"piʋ̈mɛ ‑nu ꞊gban \"pɛpɛ 'wo 'dhang bho Yesu \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu 'ö go Zude 'ö dho Gadhidhe, \"dhabhliwɔn ꞊plɛ ‑naa 'ö‑ ‑kë 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","꞊Dhɛ 'ö ꞊ya 'wɔn ‑nu bha‑ kë ꞊dhɛ ‑kɔ bha‑ 'dhö, 'ö Zuifö ‑nu ‑bha Atanna ‑dhɔkë troo do 'bha yi ꞊ya ꞊loo, 'yö dho Zedhizadhɛmö. ");
INSERT INTO daf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","\"Yi ꞊gblü 'kpikpi do 'bha ‑yö 'pödhɛ bha‑ 'gü 'ö dɔ sië \"saan 'wo‑ ꞊klëën Atanna ‑dhɔkë ‑dhɛ ‑zü bha‑ \"dhi 'dhɛ 'wo‑ ‑dhɛ \"bhlaa ‑nu bɔdhɛ bha‑ \"sɔɔ, 'ö 'wo‑ ‑dhɛ Eblö ‑wʋ 'gü Bɛsata. \"Yi ꞊gblü 'ö \"dhʋ̈ bha 'kɔ 'zaa‑ do 'bha‑ ‑gun dɔ sië‑ ‑ta 'ö‑ \"dhi‑ gun \"sɔɔdhu. ");
INSERT INTO daf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","‑A \"dhi \"dhiʋ̈ ‑dhɛ ‑nu bha 'yö \"yuëdhi ‑nu 'wo nu 'gbɛ 'ka ꞊dedewo 'wo ꞊loo 'ko ‑ta mü. \"Yanwlümɛ ‑nu, ‑göngklöömɛ ‑nu, ꞊niɔɔmɛ ‑nu, ‑gɛnloomɛ ‑nu, 'yö‑ ‑nu ꞊gban \"pɛpɛ 'wo nu ‑dhɛ bha‑ 'gü, 'yö 'wo ‑ya \"yi ꞊gblü bha‑ ꞊bang \"bang kë ‑sü ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑bha \"kië do 'bha‑ ‑gun nu sië 'mü ꞊siësië 'yö \"yi bha‑ ꞊bang \"bang ‑kë. 'Yö \"yi bha 'ö ꞊bang \"bang kë sië \"tʋ̈ng 'ö‑ 'gü \"dhʋ̈ bha, mɛ \"ʋʋ mɛ 'ö \"yua suu \"ʋʋ suu 'ö ‑kë ‑bha, 'ö ‑pö \"yi bha‑ ꞊bhaa ‑blɛɛsü, 'yö ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","\"Yuëdhi ‑nu ꞊loo ‑dhɛ bha gɔndënë do 'bha ‑yö ‑gun mü, kö \"yua 'ö zun‑ ‑bha ‑a ‑kwɛ ꞊ya kë ‑kaɔng ‑yaaga ga \"saaga. ");
INSERT INTO daf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","꞊Dhɛ 'ö Yesu ꞊ya ö \"yan ‑kpan 'mɛ bha‑ ‑bha, 'ö ꞊yaa‑ 'wɔn dɔ ꞊dhɛ \"yua ꞊ya ꞊gwëë‑ ‑bha ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö‑ pö‑ ‑dhɛ: «‑Yö i \"piʋ̈ ꞊dhɛ 'i kë \"klʋ̈ʋ̈klʋ̈ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'Yö \"yuëdhi bha 'ö‑ pö Yesu ‑dhɛ: «N Dëmɛ, mɛ 'bha ꞊në 'yaa n ‑gɔ kö ‑yö n ‑zuö \"yi ꞊bhaa kö ‑yö ꞊bang \"bang kë sië, 'yö 'ma‑ pö 'a 'dho kö 'a ‑pö mü, 'yö mɛ 'bha ‑yö to 'ö ‑pö mü n \"dhiʋ̈ ‑wa, 'yaa \"dhʋ̈ ‑a ‑dhɔ ‑zë ‑yö n ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Bhö \"wlü kö 'i i ‑bha sɛɛ\" ‑be kë kö 'i 'dho!» ");
INSERT INTO daf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","'Mɛ bha ‑yö ‑to ‑dhɛ do bha‑ 'gü 'ö kë \"klʋ̈ʋ̈klʋ̈. 'Yö ö ‑wɔtapë sü 'yö ‑ya \"ta 'sü ‑sü ‑bha. \"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ 'wɔn bha ‑yö ‑kë \"dhʋ̈ Zuifö ‑nu ‑bha ꞊glooyi 'ka, ");
INSERT INTO daf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","'yö‑ ‑nu ‑gɔmɛ ‑nu ‑wa pö 'mɛ 'ö Yesu ‑ya ‑kë \"klʋ̈ʋ̈klʋ̈ bha‑ ‑dhɛ: «꞊Glooyi ꞊në ꞊dɛɛ, ‑yö kë ‑kɔ ‑kë ꞊dhɛ 'yö 'i i ‑wɔtapë ‑kwɛɛ sü \"kɛɛ kö kwaa‑ 'tɔng‑ ‑ya ‑pö 'kwa 'dho yë 'bha kë yi 'ö ꞊dɛɛ‑ 'ka?» ");
INSERT INTO daf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Mɛ 'ö n ‑kë \"klʋ̈ʋ̈klʋ̈ ya ꞊në‑ pö n ‑dhɛ: «‑Bhö i ‑wɔtapë 'sü kö 'i ziö!» ");
INSERT INTO daf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö 'wo‑ dhɛɛ\" 'bha kpɔ 'zü 'wo‑ pö: «'Mɛ 'kö yö ‑zë 'ö‑ pö i ‑dhɛ yi 'kö ꞊dɛɛ‑ 'ka ꞊dhɛ «‑bhö i ‑wɔtapë 'sü 'kii ziö» bha de suu ‑mü?» ");
INSERT INTO daf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","\"Kɛɛ 'mɛ 'ö ‑kë \"klʋ̈ʋ̈klʋ̈ \"dhʋ̈ bha mɛ ꞊dede 'ö‑ pö‑ ‑dhɛ ꞊dhɛ «‑bhö i ‑wɔtapë 'sü 'kii ziö» bha 'yii‑ ‑mɛ dɔ, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö Yesu ꞊ya ꞊dhɛng mɛ \"dhaa 'wo gun mü bha‑ ‑nu ꞊zinng 'gü. ");
INSERT INTO daf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","꞊Dhɛ 'ö \"tʋ̈ng 'bha ꞊ya ziö, 'yö Yesu ‑yö ‑kpan 'mɛ bha‑ ‑bha Atanna ‑dhɔkëgükɔ 'gü 'yö‑ pö‑ ‑dhɛ: «‑Bhö ‑dhɛ ‑ga, 'bha kë ‑zë wo \"klʋ̈ʋ̈klʋ̈ \"kɛɛ 'bha 'dho, 'bha 'dho ‑da Atanna \"dhiʋ̈ 'zü, kö 'wɔn 'dhɛ 'ö ‑ziö 'dhɛ 'ö ‑blɛɛsü bha‑ ‑ta 'ya 'dho i \"dhiʋ̈ ꞊slɔɔ!» ");
INSERT INTO daf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö gɔndënë bha 'ö dho 'yö‑ pö Zuifö ‑nu ‑gɔmɛ ‑nu ‑dhɛ ꞊dhɛ Yesu ꞊nɛ ö ‑kë \"klʋ̈ʋ̈klʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","'Yö 'wo ‑ya Yesu ‑san kë ‑sü ‑bha ‑a kë 'ö‑ wo \"dhʋ̈ ꞊glooyi 'ka bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «N Dë ‑yö 'wɔn ‑së ‑kë yi ꞊gban \"pɛpɛ 'ka ('yaa ö \"tɛɛ 'pa), mang ‑dɩ 'pö a n ‑bha ‑kë \"dhʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","‑A pö 'ö Yesu ‑ya wo \"dhʋ̈ bha 'yö Zuifö ‑nu ‑gɔmɛ ‑nu 'wo ‑ya ‑san kë ‑sü ‑bha ‑a ‑wɔn 'gü 'yö ‑ziö 'ka ‑blɛɛsü ‑bha ‑ta, kë \"dhʋ̈ kö 'wo‑ zë. ‑A kë 'wo‑ wo \"dhʋ̈ bha‑ ‑gɛn 'yii kë‑ ‑nu ‑bha 'tɔng‑ bho ‑wɔn doseng 'ka, \"kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ ‑ya ‑pö 'pö ꞊dhɛ ö Dë ꞊dede ‑mü Atanna 'ka bha, 'yö 'wo‑ pö 'pö ꞊dhɛ ꞊ya kë \"dhʋ̈ kö ꞊ya ö ‑dɩ dan Atanna 'ka. ");
INSERT INTO daf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","'Yö Yesu ‑yö dhiang zë‑ ‑nu ‑dhɛ ‑dee wo 'zü 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Ma 'a Atanna Gbö 'ka bha 'maa 'wɔn 'bha kë n ‑dɩ ‑ta \"wɛɛwɛɛ kö 'mii‑ ‑dhɛ yö n Dë ‑gɔ, \"kɛɛ 'wɔn 'a‑ këdhɛ yö n Dë ‑gɔ ꞊në 'a‑ ‑kë 'pö. ‑Yö kë ka \"yaan ꞊dhɛ pë \"pɛpɛ 'ö n Dë ‑ya ‑kë a‑ ‑kë 'pö. ");
INSERT INTO daf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ n ‑dhɔ ‑bha n Dë këwɔn 'gü, pë \"pɛpɛ 'ö‑ ‑kë ‑ya ‑zɔn n ‑dhɛ. 'Wɔn \"gblʋ̈gblʋ̈ ‑nu 'wo ‑ziö ‑a 'dhɛ 'kö ya‑ ‑ta ‑yö ‑dho ‑a ‑zɔn n ‑dhɛ 'a‑ ‑kë 'ö‑ 'wɔn ‑yö mɛ suu ‑nu 'wo ꞊dhɛ ka 'dhö ‑a ‑nu kɔn. ");
INSERT INTO daf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","‑A ‑gɛn ‑mü ꞊dhɛ ‑kɔ do 'ö n Dë ‑yö ꞊sii ‑dee ‑da 'ka 'mɛ ꞊wa ga ‑a ‑nu 'gü bha, a‑ ‑da 'mɛ ‑a ‑da ‑nu 'gü ‑dhɔ ꞊ya n kë‑ ‑nu 'gü ‑kɔ do bha‑ 'gü 'pö. ");
INSERT INTO daf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","꞊Ya 'go yö ‑zë 'gü, n Dë ‑zë 'yaa za dɔ mɛ 'bha ‑bha, \"kɛɛ ‑yö za dɔ ‑sü 'sü ‑sü 'ka 'ö‑ dɔ ma ꞊në n ‑kɔ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kë \"dhʋ̈ kö mɛ ꞊gban \"pɛpɛ ‑wo n ꞊bhlëë ‑ya ꞊dhɛ ‑kɔ 'wo n Dë ꞊bhlëë ‑ya 'ka ‑a 'dhö. 'Mɛ 'ö 'yii n ꞊bhlëë ‑ya, kö 'yaa n Dë 'ö n bɔ bha‑ ꞊bhlëë ‑ya 'pö. ");
INSERT INTO daf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'ö ö \"tʋ to n ‑wʋ ‑bha, 'ö 'dhang bho 'mɛ 'ö n bɔ bha‑ \"dhiʋ̈, kö ꞊ya ‑tosɛa 'ö Atanna \"piʋ̈ ‑a ꞊slɔɔ, kö 'yii 'dho 'wɔn bho‑ ‑mɛ 'gü, kö yö ‑zë ꞊ya bɔ ga 'gü ꞊ya ꞊sii ꞊slɔɔ ꞊naa bha. ");
INSERT INTO daf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ‑a \"tʋ̈ng ‑dho ꞊loo, 'ö ꞊ya ‑wo ‑zianwo, 'ö 'mɛ ꞊wa ga bha 'wo mang Atanna gbö ‑mɛ n ‑wʋ ma, 'ö 'mɛ 'wo dho‑ ma \"dhʋ̈ bha 'wo ‑tosɛa ‑kë. ");
INSERT INTO daf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","‑A ‑gɛn ‑mü ꞊dhɛ ‑kɔ do 'ö ‑tosɛa ‑nu mɛ ‑dhɛ \"sɩ 'dhö‑ 'ka n Dë ‑dhɛ bha ‑ya \"sɩ kë ‑sü 'ka mang ‑dɩ 'pö n ‑dhɛ, kö 'a‑ nu 'pö mɛ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Za dɔ ‑sü dɔ 'ö‑ wo n ‑kɔ 'ka bha‑ ‑gɛn ‑mü ꞊dhɛ mɛ \"bhɩɩ‑ ‑bha 'në ‑mü n 'ka. ");
INSERT INTO daf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","‑A 'wɔn 'ya 'dho ka 'kɔn, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a \"tʋ̈ng‑ nu sië 'ö mɛ \"pɛpɛ 'ö ꞊wa ga 'wo bun 'gü, 'wo n ‑wʋ ma, ");
INSERT INTO daf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","'ö 'wo go wo wɔdhɛ ‑nu 'gü 'wo ‑wo \"yɛa‑, 'ö 'mɛ 'wo 'wɔn ‑së ‑kë 'wo ‑bö, 'ö 'wo ‑tosɛa ‑kë Atanna \"piʋ̈. 'Yö 'mɛ 'wo 'wɔn yaa ‑kë 'wo ‑bö 'pö, \"kɛɛ kö Atanna ‑yö 'wɔn bho wo ‑zë ‑a ‑nu 'gü. ");
INSERT INTO daf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ma ‑zë 'maa 'wɔn 'bha ‑wɔn 'bha kë n ‑dɩ ‑ta. 'Pë 'ö n Dë ‑ya pö n ‑dhɛ 'yö 'a za dɔ‑ 'ka. Yö ꞊në‑ ‑wɔn 'gü 'yö 'maa ꞊sua za dɔ, ‑a ‑gɛn ‑mü ꞊dhɛ 'maa n ‑dɩ ‑gɔ. 'Mɛ 'ö n bɔ bha ꞊në 'a‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","꞊Ya kë ꞊dhɛ mang do ꞊në 'a \"sɛɛdhɛ ‑kë 'nu n ‑dɩ ‑bha, kö 'pë 'a‑ pö 'yii 'dho bhɔ ka 'gü tɛan‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","\"Kɛɛ n Dë ꞊në ꞊dhɛ mɛ \"wɛɛ 'ö \"sɛɛdhɛ ‑kë n ‑bha ‑a 'dhö. ‑A ‑wɔn 'gü, a 'dhang ‑bho \"dhiʋ̈ ꞊dhɛ 'pë 'ö‑ pö n ‑bha bha 'yaa ꞊sua 'ka. ");
INSERT INTO daf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ka ꞊në 'ka mɛ bɔ Zan ‑dhɛ kë \"dhʋ̈ kö 'ö 'pë‑ pö sië 'ka‑ dɔ, 'yö 'wɔn 'ö ‑gban tɛanwɔn ‑bha ‑a \"sɛɛdhɛ ‑kë ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","\"Kɛɛ ma ‑zë n ‑bha 'ka, ma ‑wɔn 'yaa mɛ \"bhɩɩ‑ ‑nu ‑bha \"sɛɛdhɛ ‑kë n ‑bha ‑sü ‑bha. A‑ ‑pö \"dhʋ̈ kë \"dhʋ̈ kö ka ꞊në 'ka dha. ");
INSERT INTO daf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zan‑ gun ꞊dhɛ ‑dhangbha 'ö dɔ ‑sü 'ka 'ö ‑dhɛ ‑pʋ ꞊në‑ 'dhö, 'yö 'ka ‑wɩ ‑bha 'yö ka ꞊nii 'në 'bha 'dhö ‑da ‑a 'bhü \"dhiʋ̈ \"tʋ̈ng 'në 'bha 'ka. ");
INSERT INTO daf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","\"Kɛɛ ma ‑zë \"sɛɛdhɛ 'ö ‑gban n ‑bha ‑yö 'kpii‑ 'ö ‑ziö Zan ‑bha ‑zë ‑ta, ‑a ‑gɛn ‑mü ꞊dhɛ \"dhabhliwɔn ‑nu 'ö n Dë ‑ya dɔ n ‑kɔ 'ka kö 'a‑ kë, 'ö 'a‑ kë sië bha ꞊në‑ ‑zɔn ꞊dhɛ n Dë ꞊në n bɔ. ");
INSERT INTO daf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'Yö n Dë 'ö n bɔ 'pö \"dhʋ̈ bha, 'kö ‑kë ꞊dhɛ 'kii‑ ‑wʋ ma do tongtongdhö, 'ö 'kii‑ wëëdhɛ ‑zian yö do, \"kɛɛ yöö ꞊dede ‑ya \"sɛɛdhɛ ‑kë 'pö n ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","\"Kɛɛ ‑a ‑wʋ 'yaa 'dho ka \"tʋʋdhö, ‑a ‑gɛn ‑mü ꞊dhɛ 'kaa 'dhang bho ma 'ö n bɔ bha n \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","‑A ‑wʋ bha ꞊në 'ka ka \"yan \"nuu dɔ‑ ‑bha, 'yö ‑kë ka 'gü ꞊dhɛ ‑tosɛa 'ö 'yaa yën ka ‑dho ‑a ꞊slɔɔ yö ꞊në‑ 'gü, \"kɛɛ 'sa kö ‑wʋ ‑nu ꞊dede 'wo \"dhʋ̈ bha ꞊në 'wo n ‑wɔn ‑dhiang zë. ");
INSERT INTO daf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","\"Kɛɛ yö ‑zë ꞊gban 'gü 'kaa \"wɩ‑ ‑bha kö 'ka 'dhang bho n \"dhiʋ̈ kö 'ka ꞊sii ꞊dede ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","'Mii mɛ \"bhɩɩ‑ ‑nu ‑bha \"dhɛ ‑ya n ‑ta ‑sü mɔɔ‑, ");
INSERT INTO daf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","\"kɛɛ a ka suu ‑dɔ. A‑ ‑dɔ ꞊dhɛ Atanna ‑dhɔ 'yaa ka 'gü. ");
INSERT INTO daf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","N Dë ꞊në n bɔ, \"kɛɛ 'yö 'kaa \"wɩ‑ ‑bha kö 'ka ‑kɔ ‑ya n ‑dhɛng ‑bha. \"Kɛɛ 'sa mɛ \"wɛɛ 'bha ‑zë ꞊ya nu ö ‑dɩ 'ka, ka ‑dho ka ‑kɔ ‑ya yö ‑zë ‑dhɛng ‑bha! ");
INSERT INTO daf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","\"Kɛɛ mɛ 'ö 'ka mɛ \"bhɩɩ‑ ‑nu ꞊në‑ ‑nu ‑bha \"dhɛ ‑ya ka ‑ta ‑dhɛ ꞊mɔɔ, 'ö 'kaa‑ mɔɔ‑ kö Atanna doseng 'ö 'dhö yö ‑zë ‑yö \"dhɛ ‑ya ka ‑ta bha ka ‑dho 'dhang bho n \"dhiʋ̈ ‑kɔ ‑kë ꞊dhɛ? ");
INSERT INTO daf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","\"Kɛɛ yö ꞊në‑ ꞊gban 'gü, 'ka 'dho ka ‑zʋ 'gɔn ꞊dhɛ ma ꞊në 'a dho yang ‑ya ka ‑bha n Dë ‑kuu \"dhiʋ̈. 'Mɛ 'ö yang ‑ya ‑sü 'ka ka ‑bha yö ‑mü Moizö ꞊në‑ 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ yö ꞊në 'ka ka ‑zʋ gɔn‑ ‑dhɛ 'ö 'ka 'dhang bho‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","\"Kɛɛ ꞊ya kë ‑zianwo 'nu ꞊dhɛ ka 'dhang bho Moizö \"dhiʋ̈ ꞊dedewo, kö ka ‑dho 'dhang bho 'pö n \"dhiʋ̈. ‑A ‑gɛn ‑mü ꞊dhɛ 'pë 'ö Moizö ‑ya ‑bɛn zë bha ‑yö ‑gban ma ꞊në n ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","\"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ 'kaa 'dhang bho pë ‑nu 'ö‑ ‑bɛn zë bha‑ ‑nu \"dhiʋ̈, 'kii dho 'dhang bho 'pö n ‑wʋ \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö dho \"yitagbɛa 'ö Gadhidhe 'wo‑ ‑dhɛ 'pö Tibedhiadö ‑yi bha‑ ꞊taama. ");
INSERT INTO daf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mɛ \"dhaa ‑yö ‑gun ꞊keng‑ ‑kpɛawo \"dhabhliwɔn ‑nu 'ö gun‑ kë sië \"yua ‑bho mɛ ‑bha ‑sü ‑nu 'ka bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","꞊Dhɛ 'ö ꞊ya ‑wo \"yi ꞊taama ‑dhɛ bha‑ 'gü, 'yö ‑da ‑tɔn ꞊gbin‑ waa‑ ‑bha ꞊klangdhiʋ̈ ‑nu 'dhö 'yö 'wo ‑ya mü. ");
INSERT INTO daf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","‑A \"tʋ̈ng bha‑ 'gü kö Pakö 'ö ‑kë Zuifö ‑nu ‑bha Atanna ‑dhɔkë ‑yi 'kpii‑ 'ka bha‑ yi 'yaa ꞊gblɛɛn 'zü. ");
INSERT INTO daf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Yesu dho ö ‑gɔ \"dhiʋ̈ \"wlü kö 'ö ‑dhɛ ‑ga, kö mɛ \"bhɩɩ‑ ꞊ya ta‑ 'gü kö ‑wo nu sië ‑yɛɛdhö ‑dhɛ ꞊gban 'gü. 'Yö‑ pö Fidhipö ‑dhɛ: «Mɛ \"sinma 'wo nu sië ya ꞊zɔɔ ‑dhɛ ‑mɛɛ ꞊në 'kwa dho ‑bhöpë ꞊slɔɔ‑ ‑bha kö 'kwa‑ 'dhɔ kö 'kwa‑ nu‑ ‑nu ‑dhɛ kö ‑wa ‑bhö kö ‑wo 'kën?» 'Ö gun \"dhʋ̈ kö 'pë yöö‑ kë ‑ya ‑dɔ, \"kɛɛ ‑ya dhɛɛ\" ‑kpɔ \"dhʋ̈ ö ‑dɩ \"yaan ‑a 'gü dan kian 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Fidhipö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑Tu \"tu 'dhɛ kö 'wo nu sië bha ꞊ya 'to wo ‑zë ‑nu \"dhiʋ̈ gba ‑wɔn ‑bha, aa\" ꞊ni kwaa 'wëë‑ 'wo dho yëkëmɛ do ꞊saa bho‑ 'ka \"su \"saaga \"piʋ̈ ‑a 'bluu‑ 'dhɔ, 'yii 'dho ꞊mɔɔ‑ ‑nu ‑ta kö mɛ do ‑ya \"kplü 'në 'dɛdɛ ‑zian ꞊slɔɔ (kö yöö 'to‑ ‑nu 'kën ‑wɔn ꞊në‑ ‑bha).» ");
INSERT INTO daf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","꞊Dhɛ 'ö Fidhipö ꞊yaa‑ pö \"dhʋ̈, 'yö Yesu ‑bha ꞊klang ‑nu bha‑ mɛ 'dhɛ 'wo‑ ‑dhɛ Andre 'ö ‑kë Simɔ Piɛdhö 'zlaa‑ 'ka bha 'ö‑ pö‑ ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«'Në \"gbɔng 'në do 'bha ‑yö yö 'ö 'bluu‑ bhɛ 'sɛnsɛn 'në \"sɔɔdhu waa‑ 'yuʋ̈ga ꞊plɛ 'wo‑ ‑gɔ, \"kɛɛ mɛbhɩɩdhe \"dhaa 'kö ma ya 'pë 'kö bha ‑yö ‑dho ꞊mɔɔ ‑më ꞊në‑ ‑bha?» ");
INSERT INTO daf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Kaa pö kö mɛ ꞊gban \"pɛpɛ ‑wo 'yaanu!» Blëë‑ ‑gun ‑dhɛ bha‑ 'gü mɔɔdhö ‑dhɛ ꞊gban 'gü. 'Yö gɔɔn‑ ‑nu 'wo ꞊mɔɔ mɛ \"gblʋ̈ \"sɔɔdhu ‑nu ‑bha, (kö 'wii 'në ‑nu waa‑ dhong ‑nu ‑zë ‑da mü bha) 'wo dho \"sia‑ 'wo 'yaanu. ");
INSERT INTO daf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","꞊Dhɛ 'ö ꞊wa 'yaanu \"dhʋ̈, 'yö Yesu ‑yö ö ‑kɔ ‑da 'bluu‑ bha‑ 'gü 'yö Atanna nuɛ\" bho‑ ‑wɔn 'gü, 'yö 'wo‑ 'gü ‑gblü 'mɛ 'wo gun mü bha‑ ‑nu ‑ta. 'Yö dho 'yö 'yuʋ̈ga bha‑ ‑bha ‑kë \"dhʋ̈, 'yö 'wo‑ ‑bhö ‑kɔ 'ö ‑dhi ‑nu ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","꞊Dhɛ 'ö ꞊waa‑ ‑bhö ꞊wa 'kën, 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ ‑wa \"kplü ‑kpɛa 'ö to bha‑ ‑wlö kö‑ 'gü 'ya 'dho see‑. ");
INSERT INTO daf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'Yö 'wo 'bluu‑ bhɛ 'sɛnsɛn 'në \"sɔɔdhu 'ö gun bha‑ \"kplü 'dhɛ 'ö to 'ö 'wo ꞊fië‑ ‑bha bha‑ ‑wlö, 'yö dho 'ö ‑kë töö ‑yan ‑kaɔng do ga ꞊plɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","꞊Dhɛ 'ö 'mɛ 'wo bha‑ ‑nu \"yan ꞊ya ‑da \"dhabhliwɔn 'ö Yesu ‑ya kë bha‑ ‑dhɛ 'gü, 'yö 'wo ‑ya ‑a pö ‑sü ‑bha ꞊dhɛ: «Atanna ‑wʋdhiʋ̈loomɛ 'yi ‑ya ‑gɔ bha yö ꞊nɛ ꞊dedewo tɛan‑ 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","\"Kɛɛ ꞊dhɛ 'ö Yesu ꞊yaa‑ 'wɔn dɔ ꞊dhɛ woo nu kö wo faan wɔ ö ‑ta kö ‑wo ö 'kun ‑wo 'dho ö 'ka ‑wo ö ‑ya \"sɛgɔ \"dhiʋ̈, 'yö ꞊dua‑ ‑nu ‑gɔ 'ö dho 'zü ‑dee \"wɛɛ wo ‑tɔn ꞊gbin‑ ö do 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","꞊Dhɛ 'ö \"bin ꞊ya 'ma, 'yö Yesu ‑bha ꞊klangdhiʋ̈ ‑nu 'wo ꞊lɔɔ \"yitagbɛa bha‑ \"kpʋng \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","'Yö 'wo ‑da \"kplagɔnë 'gü 'wo ‑ya \"yi \"kan ‑sü ‑bha kö ‑a ‑nu wë ‑ya 'gü Kapɛɛnaɔmö ‑zian 'ka. ‑A \"tʋ̈ng bha‑ 'ka kö ‑dhɛ 'gü ꞊ya trö \"kɛɛ kö Yesu 'yii ‑kpan ‑a ‑nu ‑bha ꞊kö. ");
INSERT INTO daf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","'Yö \"tɛɛ \"gbɩɩ‑ 'dhö ‑ya ‑ziö ‑sü ‑bha, 'yö \"yi 'dhö ‑ya zɔn ‑sü ‑bha bang ꞊bang bangdhö. ");
INSERT INTO daf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","꞊Dhɛ 'ö 'pë 'ö ꞊mɔɔ \"kidhʋng \"sɔɔdhu \"saɔdo ‑nu ‑bha waa‑ \"ta 'sü \"yi ‑ta, 'yö 'wo Yesu yö kö ꞊ya ꞊tëng‑ ‑nu ‑bha \"yitagɔ bha‑ ‑ta kö ‑yö \"ta sië \"yi ‑ta 'ö nu‑ 'ka. 'Yö \"suʋ̈ 'dhö ‑da ‑a ‑nu 'gü, ");
INSERT INTO daf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","\"kɛɛ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «\"Suʋ̈ 'ya 'dho ka kë, ma ‑mü!» ");
INSERT INTO daf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","‑Wo ‑to ‑a pö ‑dhɛ 'gü ꞊dhɛ 'wo‑ ‑da wo \"piʋ̈ \"kplagɔnë 'gü 'yö to 'yö ‑kë ‑a ‑gɔ ‑gban \"kpʋng ‑bha ‑sü 'ka, 'yö 'wo ꞊loo‑ ‑nu 'dhodhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mɛ kpö 'wo‑ ‑nu to \"yi ꞊taama bha ‑wa 'wɔn ‑dɔ ꞊dhɛ \"yitagɔ do ꞊në gun ‑dhɛ bha‑ 'gü. ꞊Dhɛ Yesu ‑zë 'yii ‑da \"yitagɔ bha‑ 'gü ‑a ‑bha ꞊klang ‑nu \"piʋ̈, ꞊dhɛ ‑wo kë ‑dho wo do 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya ꞊kpaɔ, 'ö \"yitagɔ 'bha ‑nu ꞊wa 'go Tibedhiadö ꞊wa nu ꞊wa ꞊loo ‑dhɛ 'ö kwa Dëmɛ ‑yö Atanna nuɛ\" bho 'bluu‑ ‑wɔn 'gü mü 'wo‑ ‑bhö bha‑ ‑dhɛ \"sɔɔ, ");
INSERT INTO daf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","'ö mɛ kpö bha ꞊waa‑ 'wɔn dɔ ꞊dhɛ Yesu waa‑ ‑bha ꞊klang ‑nu 'bha 'waa ‑dhɛ bha‑ 'gü, 'yö 'wo ‑da \"yitagɔ ‑nu bha‑ 'gü wo ‑dɩ 'ka 'wo dho Kapɛɛnaɔmö, ‑a mɔɔ‑ ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ‑kpan ‑bha \"yi ꞊taama mü, 'yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, i ‑loo ‑dhɛ ya‑ 'gü ‑më yi 'ka?» ");
INSERT INTO daf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","\"Kɛɛ 'yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «A‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ n mɔɔ‑ 'ka‑ wo sië bha a‑ 'klɔɔ‑ ‑dɔ. ‑A 'klɔɔ‑ 'yaa ‑mü \"dhabhliwɔn ‑nu 'ka‑ ‑dhɛ yö bha‑ 'ka, ‑a 'klɔɔ‑ ‑mü 'bluu‑ 'ka‑ ‑bhö 'ka kën bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","'Sa a‑ ‑pö ka ‑dhɛ ꞊dhɛ: 'Ka 'dho‑ pö 'ka sëë bho ‑bhöpë 'ö ꞊see bha yö ‑zë ‑wɔn 'gü, \"kɛɛ 'ka sëë bho ‑bhöpë 'ö ꞊gwëë, 'ö ꞊sii 'ö 'yaa yën‑ ‑kë mɛ ‑dhɛ bha ꞊në‑ ‑wɔn 'gü. ‑A ‑bhöpë suu 'ö \"dhʋ̈ bha mang Mɛgbömɛ ꞊në 'a dho‑ nu ka ‑dhɛ. ‑A 'klɔɔ‑ ‑mü ꞊dhɛ n Dë Atanna ꞊ya ö ‑kɔ \"gblʋʋ 'ö‑ ‑zɔn ꞊dhɛ yö ꞊në n bɔ bha‑ ‑ya n ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'Yö 'mɛ 'wo bha 'wo‑ pö‑ ‑dhɛ: «Yi ‑dho ‑a kë ꞊dhɛ kö 'yi Atanna ‑dhidhɛ ‑wɔn kë?» ");
INSERT INTO daf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Pë 'ö ‑dhi Atanna ‑dhɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ka‑ kë yö ‑mü ꞊dhɛ kö 'ka 'dhang bho ma 'ö n bɔ bha ꞊në n \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","'Yö 'wo‑ pö‑ ‑dhɛ: «꞊Dhɛ 'ö \"dhʋ̈ kö ‑bhö \"dhabhliwɔn do kë 'sa kö yi \"yan‑ ‑da 'gü kö ‑ya ‑zɔn yi ‑dhɛ ꞊dhɛ Atanna ꞊në i bɔ, kö 'yi 'dhang bho i \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‑A pö 'yi‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ ‑bhöpë 'ö go dhang‑ 'gü, 'wo‑ ‑dhɛ manö bha, yi \"bhɛma ‑nu kë‑ ‑bhö \"tʋng ‑ta 'ö ‑bɛn zë ‑sü 'ka 'pö \"dhʋ̈ Atanna ‑wʋ 'gü ꞊dhɛ: ‹Atanna ‑yö kë 'bluu‑ 'ö go dhang‑ 'gü ‑a ‑nu ‑nu ‑dhɛ 'wo‑ ‑bhö›. ");
INSERT INTO daf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: 'Mɛ 'ö kë ‑bhöpë 'ö go dhang‑ 'gü ‑a ‑nu ka \"bhɛma ‑nu ‑dhɛ bha Moizö 'yaa ‑mü, n Dë ‑mü. N Dë do bha ꞊në ‑bhöpë ꞊dede 'ö go dhang‑ 'gü ‑a nu sië 'zü ka ‑dhɛ ya. ");
INSERT INTO daf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ ‑bhöpë 'ö Atanna ‑ya nu yö ꞊në go dhang‑ 'gü 'yö nu 'yö ꞊sii nu mɛ \"bhɩɩ‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","'Yö mɛ kpö bha 'wo‑ pö Yesu ‑dhɛ: «Yi Dëmɛ, ‑bhöpë 'ö suu 'dhö bha ‑bhö ‑a nu yi ‑dhɛ yi ꞊gban 'ka 'sa ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «Ma ꞊në 'a ‑bhöpë 'ö ꞊sii ‑kë mɛ ‑dhɛ \"dhʋ̈ bha‑ 'ka. 'Mɛ 'ö ꞊ya nu n \"piʋ̈, din‑ 'yii 'dho‑ ‑mɛ kë tongtongdhö. Mɛ 'ö ꞊ya 'dhang bho n \"dhiʋ̈, \"yi mü ‑dhɔ 'yii 'dho‑ mɛ kë 'zü tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'Sa 'ma‑ pö ka ‑dhɛ \"dhʋ̈, ꞊ya 'go mü 'zü ka \"yan ‑yö n ‑bha \"kɛɛ yö ‑zë ꞊gban 'gü 'kaa 'dhang bho‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","\"Kɛɛ a‑ pö ka ‑dhɛ ꞊dhɛ mɛ \"pɛpɛ 'dhɛ 'kö n Dë ‑ya nu n ‑dhɛ, ‑wo ‑dho nu n \"piʋ̈. Mɛ 'dhɛ 'kö ꞊ya nu 'pö n \"piʋ̈, 'mii 'dho‑ ‑mɛ \"kan n ‑bha tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","‑A ‑gɛn ‑mü ꞊dhɛ 'go 'a‑ wo dhang‑ 'gü 'a nu bha 'mii nu 'kaa n ‑dɩ dhɔɔbhaa kë. A ‑nu kö 'mɛ 'ö n bɔ bha ꞊në 'a‑ dhɔɔbhaa kë. ");
INSERT INTO daf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'Sa 'mɛ 'ö n bɔ bha‑ dhɔɔbhaa 'ö 'dhö yö ‑mü ꞊dhɛ kö mɛ \"pɛpɛ 'ö‑ nu n ‑dhɛ bha‑ 'bha 'gü 'ya 'dho see‑ n ‑kɔ ‑ta, \"kɛɛ kö 'a‑ ‑nu ‑bö ꞊në‑ wo kö ‑wo 'go ga 'gü ‑tosɛa yën ‑yi 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","N Dë dhɔɔbhaa 'ö 'dhö yö ‑mü ꞊dhɛ kö mɛ \"ʋʋ mɛ 'ö \"yan ‑kpan n ‑bha, 'ö 'dhang bho n \"dhiʋ̈, kö ꞊sii 'ö 'yaa yën ‑yö kë‑ ‑mɛ ‑dhɛ. ꞊Ya kë \"dhʋ̈ a ‑dho ‑a ‑mɛ ‑bö ‑tosɛa yën ‑yi 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","‑A pö 'ö Yesu ‑ya wo ꞊dhɛ ‑bhöpë 'ö go dhang‑ 'gü yö ‑mü yö ꞊në ö 'ka bha, 'yö Zuifö ‑nu 'wo ‑ya ‑dɔn bho ‑sü ‑bha ‑a 'ka wo yun 'gü ‑a ‑wɔn 'gü ");
INSERT INTO daf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","'wo‑ pö: «Yesu do \"wɛ 'kwa‑ dhe waa‑ dë ꞊gban dɔ ya 'yaa ‑mü ‑ee? \"Ɛɛn 'waa‑ dë ‑dhɛ Zosɛfu 'nu ‑ee? ‑Yö kë mü ꞊dhɛ 'yö‑ pö ö ‑go dhang‑ 'gü?» ");
INSERT INTO daf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Ka 'dho ‑dɔn bho n 'ka ka yun 'gü ‑a pö 'a‑ wo \"dhʋ̈ bha‑ ‑wɔn 'gü, ");
INSERT INTO daf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","‑a ‑gɛn ‑mü ꞊dhɛ mɛ 'bha 'yii 'dho ꞊mɔɔ ‑bɔ n 'ka ‑sü ‑bha ö ‑dɩ 'ka kö n Dë 'kö n bɔ bha 'yii‑ ‑mɛ \"gan. Yö ꞊në ꞊yaa‑ ‑mɛ \"gan \"dhʋ̈, 'yö ma ‑zë 'a dho‑ ‑mɛ ‑bö ‑dhɛkpaɔyi ‑totaamasü 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","'Wɔn 'ö‑ ‑wɔn 'gü 'yö Atanna ‑wʋdhiʋ̈loomɛ ‑nu 'wo‑ ‑bɛn zë woo‑ 'sëëdhɛ 'gü yi 'bha 'ka 'wo‑ pö ꞊dhɛ: ‹‑A ‑nu ꞊gban \"pɛpɛ‑ ‑dho tɛanwɔn ma Atanna ꞊në‑ ‑ta› bha 'yö bha. 'Wɔn 'ö‑ ‑wɔn 'gü 'pö 'yö mɛ \"ʋʋ mɛ 'ö ꞊ya n Dë Atanna ‑bha mɛ ꞊klangkëwʋ ('ö 'ka‑ ma bha‑) ma, 'yö to 'ö nu n \"piʋ̈ bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","'Yii kë ꞊dhɛ ꞊ya kë \"dhʋ̈ kö mɛ 'bha ꞊në ꞊ya \"yan ‑kpan n Dë ‑bha kö 'yii kë ma 'kö ma ‑zë 'a go mü bha n 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ mɛ 'ö ꞊ya 'dhang bho n \"dhiʋ̈ ‑yö ‑dho ꞊sii 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha‑ ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma ꞊në 'a ‑bhöpë 'ö ꞊waa‑ ‑bhö 'wo ‑tosɛa ‑kë bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ka dë ‑nu kë ‑bhöpë 'ö go dhang‑ 'gü 'wo‑ manö ‑kë bha‑ ‑bhö \"tʋng ‑ta \"dhʋ̈ tɛan‑ 'ka \"kɛɛ yö ‑zë ꞊gban 'gü ‑wo kë ‑ga. ");
INSERT INTO daf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","\"Kɛɛ ‑ka ‑dhɛ ‑ga, ‑bhöpë 'ö go dhang‑ 'gü bha 'mɛ ꞊yaa‑ ‑bhö 'yii 'dho ga 'zü tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","‑Bhöpë \"yaandhe 'ö go dhang‑ 'gü 'ö ꞊lɔɔ \"dhʋ̈ bha yö ‑mü ma ꞊në n 'ka. 'Mɛ 'ö ꞊ya ‑bhöpë 'dhɛ 'kö bha‑ ‑bhö, ‑yö ‑dho ‑tosɛa kë ‑todhʋ̈ 'ka. ‑Bhöpë 'a dho‑ nu \"dhʋ̈ bha n ‑wü ‑mü. Yö ꞊në 'a dho‑ nu \"kpʋngtaamɛ ‑nu dha ‑sü ‑wɔn 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Zuifö ‑nu 'wo ‑ya zaɔdhe ‑da wo \"kwëë ‑sü ‑bha 'wo‑ pö: «'Mɛ 'ö ya ‑yö ‑dho ö ‑wü ‑zë nu ‑kɔ kë ꞊dhɛ kwa ‑dhɛ ‑bhöpë 'ka kö 'kwa‑ ‑bhö?» ");
INSERT INTO daf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ꞊ya kë ꞊dhɛ kö 'kii Mɛgbömɛ ‑wü ‑zë ‑bhö, kö 'kii‑ ꞊yɔɔn mü, kö ꞊sii ꞊dede 'yaa ka 'gü. ");
INSERT INTO daf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","\"Kɛɛ mɛ 'ö n ‑wü ‑bhö 'ö n ꞊yɔɔn mü, kö ꞊sii 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha ꞊ya kë‑ ‑mɛ ‑dhɛ, kö a ‑dho ‑a ‑mɛ ‑bö 'ö go ga 'gü \"kpʋngtaadhɛ yën ‑yi 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","‑A ‑gɛn ‑mü ꞊dhɛ n ‑wü bha ‑yö ‑bhöpë ꞊dede ꞊në‑ 'ka. N ꞊yɔɔn ‑dɩ 'pö, ‑yö müpë ꞊dede ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","'Mɛ 'ö n ‑wü ‑bhö, 'ö n ꞊yɔɔn bha‑ mü kö yaa‑ ‑mɛ yi ‑kɔ ‑yö 'ko ꞊kwɛng ‑kpɛawo, ");
INSERT INTO daf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","꞊dhɛ ‑kɔ 'ö n Dë 'ö \"yaandhe 'ka 'ö n bɔ‑ 'ka 'ö 'a ‑tosɛa ‑kë ‑a 'saa‑ 'gü bha‑ 'dhö. 'Mɛ 'ö n ‑wü ‑bhö, ‑yö ‑dho ‑tosɛa kë n 'saa‑ 'gü 'pö. ");
INSERT INTO daf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma ꞊në 'a ‑bhöpë 'ö go dhang‑ 'gü ‑a 'ka, ma ‑zë 'maa ꞊dhɛ ‑a 'dhɛ 'ö ka \"bhɛma ‑nu kë‑ ‑bhö bha‑ 'dhö. ‑A ‑gɛn ‑mü ꞊dhɛ ꞊dhɛ 'wo‑ ‑bhö \"dhʋ̈, wo kë ‑ga. 'Mɛ 'kö ‑bhöpë 'dhɛ 'kö ya‑ ‑bhö, ‑yö ‑dho ‑tosɛa kë \"dhʋ̈ \"dhʋ̈ \"dhʋ̈ 'ö‑ \"dhiʋ̈ 'to ‑dhɛ 'yaa kë.» ");
INSERT INTO daf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu ‑yö dhiang ‑nu bha‑ zë \"dhʋ̈ kö ‑yö mɛ ‑nu ꞊klang kë sië Kapɛɛnaɔmö, Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","꞊Dhɛ 'ö‑ ‑bha ꞊klangdhiʋ̈ ‑nu ꞊wa ‑wʋ bha‑ ma ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö‑ mɛ kpö 'bha 'wo‑ pö: «Dhiang 'dhɛ 'kö‑ zë ya, ꞊ya 'to yö ‑zë ‑bha kö ‑yö \"gbɩɩ‑ \"dhɛ! 'Dee dho ꞊mɔɔ yö ‑zë kë ‑sü ‑bha?» ");
INSERT INTO daf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","꞊Dhɛ 'ö Yesu ꞊yaa‑ 'wɔn dɔ ꞊dhɛ ‑a ‑bha ꞊klang ‑nu ‑wo ‑dɔn bho sië wo yun 'gü 'wɔn bha‑ 'gü 'pö, 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «'Wɔn 'kö 'a‑ pö bha yö 'pö ‑yɛ ka ‑bha 'yö ka ‑din yën \"dhʋ̈ bha ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Yö 'ka \"yan ‑zë ‑kpan mang Mɛgbömɛ n ‑bha yi 'kö‑ 'ka kö a n yee kë sië 'a ‑tɔn kun 'a dho ‑dhɛ 'a gun‑ 'gü ‑blɛɛsü bha‑ 'gü 'sa ꞊wɛ! Ka ‑dho ‑a kë mü ꞊dhɛ? ");
INSERT INTO daf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","꞊Ya kë ꞊dhɛ 'ma‑ pö ꞊dhɛ 'ka n ‑wü ‑bhö, ‑kaa 'gü ma ꞊dhɛ 'mii \"wɩ n ‑wü 'ö n ‑bha ya‑ 'ka, 'mii‑ pö 'ka yö ‑zë ‑bhö. ‑A ‑gɛn ‑mü ꞊dhɛ mɛ ‑wü 'dhɛ kö mɛ ‑bha \"kpʋng ꞊taa yö bha yö ‑zë ꞊bhlëë 'yaa 'dhö Atanna wëëdhö, \"kɛɛ 'ma‑ pö \"dhʋ̈ kö a‑ ‑pö: 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ö n 'gü bha ꞊ya ‑da mɛ \"ʋʋ mɛ 'ö‑ 'gü kö‑ ‑mɛ ꞊ya ꞊sii 'ö 'yaa yën‑ ꞊slɔɔ ꞊naa bha. ꞊Ya kë \"dhʋ̈ kö ‑wʋ ‑nu 'a‑ pö ka ‑dhɛ bha ‑wo ‑gban ꞊sii 'ö 'yaa yën ‑a ‑da 'ö 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑ya wo mɛ 'gü bha ꞊në ‑wɔn ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","\"Kɛɛ 'sa mɛ 'bha ‑nu ‑wo ka kpö 'gü 'ö 'waa 'dhang bho n \"dhiʋ̈.» ‑A pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ kö 'mɛ 'waa 'dhang bho‑ \"dhiʋ̈ bha ‑ya ‑nu ‑dɔ, 'ö 'mɛ 'ö dho‑ ꞊gbaɔ bha 'ö‑ dɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","'Yö‑ 'bha ‑da ‑ta 'ö‑ pö: «'Wɔn 'ö ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ mɛ 'bha 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö 'dhang bho n \"dhiʋ̈ kö n Dë ‑zë 'yii‑ ‑mɛ gba‑ ‑faan 'ka bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","꞊Dhɛ 'ö Yesu ꞊ya bo‑ ‑pö \"dhʋ̈ ‑sü 'ka 'yö‑ ‑bha ꞊klang ‑nu bha‑ mɛ 'gbɛ 'wo wo ‑kɔ ꞊lɔɔ wo \"piʋ̈, 'yö 'wo wo yee ‑kë ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","꞊Dhɛ 'ö ꞊yaa‑ 'wɔn dɔ \"dhʋ̈ 'yö‑ pö ö ‑bha ꞊klang ‑nu ‑kaɔng do ga ꞊plɛ 'wo 'dhö ‑a ‑nu ‑dhɛ 'ö‑ pö: «Kaa ‑dɩ 'pö ꞊wɛ, 'kii 'dho 'dho ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","'Yö Simɔ Piɛdhö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N Dëmɛ, yi ‑dho i 'to yi dho 'mɛ, \"kɛɛ kö ꞊sii 'ö 'yaa yën ‑a ‑kë mɛ ‑dhɛ ‑dhiang ‑go bhi ꞊në i \"dhi! ");
INSERT INTO daf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yi ‑zë 'ya 'dhang bho‑ \"dhiʋ̈ 'ya‑ 'wɔn ‑dɔ ꞊tɔn ꞊dhɛ Atanna ‑bha ‑Yamɛ 'ö pö 'aa‑ ‑bha 'ö‑ bɔ yö ‑mü bhi ꞊në i 'ka tɛan‑ ꞊dede 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Mɛ ‑kaɔng do ga ꞊plɛ 'kö 'ka bha ma ꞊në 'a ka ‑zë ka ‑ya, \"kɛɛ 'sa mɛ do ‑yö ka kpö 'gü \"yina yaa ‑mɛ ‑mü!» ");
INSERT INTO daf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","‑Yö ‑gun \"wɩ sië Simɔ Isikadhiɔtö gbö 'wo Zuda ‑kë bha ꞊në‑ 'ka \"dhʋ̈ bha, ‑a ‑gɛn ‑mü ꞊dhɛ yö 'ö ‑kë mɛ ‑kaɔng do ga ꞊plɛ bha‑ mɛ do 'ka bha ꞊nɛ dho ‑da ‑dhɛ pë \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö ‑ya \"ta 'kpɔ ‑sü ‑bha Gadhidhe ‑sɛ 'gü, \"kɛɛ 'yaa gun‑ \"piʋ̈ ꞊dhɛ 'ö ‑da 'ka Zude ‑sɛ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ kö Zuifö ‑nu ‑gɔmɛ ‑nu ‑wa \"slë mɔɔ‑ sië kö ‑wa zë. ");
INSERT INTO daf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","\"Kɛɛ 'sa 'ö gun \"dhʋ̈ kö Zuifö ‑nu bha troo 'wo‑ ‑kë bɔɔ\" ꞊wlöö bha‑ yi 'yaa ꞊gblɛɛn 'zü. ");
INSERT INTO daf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'Yö Yesu dheebhang ‑nu 'wo‑ pö‑ ‑dhɛ 'wo‑ pö: «‑Bhö 'dho Zude ‑sɛ 'gü 'pö kö i ‑bha ꞊klang ‑nu 'dhɛ 'wo mü ‑wo 'wɔn ‑nu 'i‑ kë sië ya‑ ‑dhɛ yö ‑dhe; ");
INSERT INTO daf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'kö 'i‑ \"piʋ̈ ꞊dhɛ ‑wo i dɔ, 'bhaa 'wɔn kë ‑gblɛn 'kpɔ 'gü. ꞊Dhɛ 'ö \"dhʋ̈ ‑bhö 'dho kö 'wɔn ‑nu 'i‑ kë sië bha 'i‑ kë mɛ ꞊zinng 'gü kö mɛ ꞊gban ‑wo i dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","‑A pö 'ö‑ dheebhang ‑nu ‑wa wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'waa gun 'dhang bho sië‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «꞊Ya kë ka ‑zë ka ‑bha 'ka kö \"tʋ̈ng ꞊gban ‑yö ‑së, \"kɛɛ ma ‑zë n ‑bha \"tʋ̈ng 'yii ꞊loo ꞊kö.» ");
INSERT INTO daf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","‑A ‑gɛn ‑mü ꞊dhɛ ka ‑zë ka ‑san 'yaa \"kpʋngtaamɛ ‑nu kë, \"kɛɛ ma ‑zë n ‑san ‑ya ‑nu ‑kë, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ 'ma \"dhɛ bho‑ ‑nu ‑ta, a‑ pö‑ ‑nu këwɔn ‑yö 'ya‑. ");
INSERT INTO daf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ka ‑zë ‑ka 'dho troo bha‑ ‑ta, \"kɛɛ ꞊ya 'to ma ‑zë n ‑bha ‑bha kö 'maa maa 'dho ꞊kö, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a \"tʋ̈ng 'yii ꞊loo ꞊kö.» ");
INSERT INTO daf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","꞊Dhɛ 'ö ꞊yaa‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈ 'yö to Gadhidhe ‑sɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","꞊Dhɛ 'ö‑ 'zlaabɔ ‑nu bha ꞊wa 'dho Atanna ‑dhɔkë ‑dhɛ 'gü troo bha‑ ‑ta, 'yö yöö ‑dɩ 'pö 'ö ꞊wlü ‑suɛɛdhö kö mɛ 'bha 'ya 'dho ö yö, 'yö dho. ");
INSERT INTO daf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","'Yö Zuifö ‑nu 'wo ‑ya mɔɔ‑ ‑sü ‑bha troo bha‑ ‑ta kö ‑wa pö sië: «‑Yö 'mɛ?» ");
INSERT INTO daf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kö ‑wa ‑dhiang zë sië wo \"dhi ꞊wlöö mɛ kpö 'gü ‑dhɛ ꞊gban 'gü ‑nu wo 'ö ‑kɔ \"pɛan 'bha ꞊ya pö: «'Wɔnsëkëmɛ ‑mü». Kö mɛ 'bha ‑nu ‑wa pö sië 'pö: «‑Abin, \"kpënng‑ ‑kë mɛ ‑gɔ ‑mɛ ‑mü.» ");
INSERT INTO daf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","\"Kɛɛ mɛ 'bha 'yaa gun‑ ‑dhiang zë sië ö ‑ta \"puu 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ kö ‑wo \"suʋ̈ sië Zuifö ‑nu ‑gɔmɛ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","꞊Dhɛ 'ö ꞊wa troo bha‑ kë 'ö ꞊wa dɔ‑ ꞊zinng 'gü, 'yö Yesu ‑yö dho Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gü, 'yö ‑ya mɛ draan‑ ‑sü ‑bha mü. ");
INSERT INTO daf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","꞊Dhɛ 'ö Zuifö ‑nu ‑gɔmɛ ‑nu 'wo‑ mɛ draan‑ ‑kɔ bha‑ ‑dhɛ yö, 'yö‑ 'wɔn ‑ya ‑nu kɔn, 'yö 'wo‑ pö: «Mɛ 'ö 'yii ꞊klang 'bha kë ya ‑yö Atanna ‑wʋ \"sinma ya‑ ‑dɔ 'mɛ?» ");
INSERT INTO daf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","'Yö Yesu ꞊ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Wʋ ‑nu 'a mɛ ꞊klang kë sië‑ 'ka bha 'wii 'go n ‑dɩ 'gü, Atanna 'ö n bɔ bha ꞊në‑ dɔ n \"dhi!» ");
INSERT INTO daf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Atanna dhɔɔbhaawɔn kë ‑dhɔ ꞊ya kë 'mɛ 'ö‑ ‑bha, 'ö ‑wʋ ‑nu 'a‑ pö sië bha 'wo go ma ꞊në n 'gü oo, \"ɛɛn 'wo go Atanna ꞊në 'gü oo, ‑a ‑mɛ ꞊në dho‑ 'wɔn dɔ. ");
INSERT INTO daf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö ö ‑dɩ 'gü ‑dhiang zë, ‑ya ‑mɔɔ kö yö ꞊në 'ö 'tɔ ‑yö bhɔ, \"kɛɛ 'mɛ 'kö 'wo‑ bɔ ꞊në wo 'ö‑ mɔɔ‑ sië kö 'mɛ 'ö ö bɔ bha ꞊në‑ 'tɔ ‑yö bhɔ, ‑a ‑mɛ ‑yö tɛanwɔn ꞊në pö, 'sa ꞊ya kë \"dhʋ̈ kö ‑a ‑mɛ ‑zë ‑wʋ 'yaa mɛ ‑pö ‑wʋ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","\"Ɛɛn Moizö 'aa mü 'ö kaa‑ 'tɔng‑ ‑nu dɔ yi 'bha 'ka ‑ee? \"Ɛɛn 'yaa \"dhʋ̈ ‑ee? \"Kɛɛ 'mɛ 'ka bha 'dee 'tɔng‑ bha‑ 'kun sië ꞊dɛɛ, mɛ ꞊gban 'kii ka ꞊taa ‑ya ‑gɔ ‑ee? Ka n ‑gɛn ‑mɔɔ kö 'ka n zë 'sa ‑më ‑wɔn 'gü?» ");
INSERT INTO daf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","'Yö mɛ kpö bha 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Bhi 'i ya slaa\" ‑yö i 'gü \"dhɛ! 'Dee \"piʋ̈ ꞊dhɛ 'ö i zë ‑dhɛ ya‑ 'gü?» ");
INSERT INTO daf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Wɔn doseng ꞊në 'a‑ kë (꞊glooyi 'ka), 'yö ‑yɛ ka ‑bha ('yö 'ka‑ \"piʋ̈ ꞊dhɛ 'ka n zë bha), ");
INSERT INTO daf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","\"kɛɛ 'sa kö ka ‑zë ka mɛ ‑kë 'gbannë 'ka ꞊glooyi bha‑ 'ka, ꞊dhɛ 'ö ‑kë ꞊dhɛ Moizö ꞊në 'wluu‑ ‑ya, 'ö‑ pö ꞊dhɛ 'ka gɔɔn‑ ‑nu kë 'gbannë 'ka bha‑ ‑wɔn 'gü, \"kɛɛ 'sa kö yö ‑zë 'yii‑ zü bho, kö ka \"bhɛma ‑nu ꞊në 'wo‑ zü bho (kö yö ‑zë 'yii bhɔ ‑zianwo ꞊kö). ");
INSERT INTO daf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","꞊Ya kë ꞊dhɛ ka ‑zë 'ka ꞊mɔɔ‑ ‑bha 'ka 'nëgɔɔn ‑nu kë 'gbannë 'ka ꞊glooyi 'ka kë \"dhʋ̈ kö 'ka Moizö ‑bha 'tɔng‑ ꞊bhlëë ‑ya bha oo, 'yö ma ‑zë 'ma mɛbhɩɩdhe ‑dhü kë \"klʋ̈ʋ̈klʋ̈ ꞊glooyi 'ka, ‑yö ‑siö ka ‑dhɛ ‑më ‑wɔn 'gü? ");
INSERT INTO daf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","N këwɔn ‑yö ‑kë ‑së oo, ‑yö ‑kë 'ya‑ oo, \"kɛɛ 'ka‑ pö 'ka za dɔ mɛ ‑bha ‑kaa dɔ tɛan‑ ‑ta. 'Ka 'dho‑ dɔ‑ ‑mɛ këwɔn 'ka‑ yö bha yö ‑zë ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","꞊Dhɛ ꞊ya ö bo‑ pö \"dhʋ̈ ‑sü 'ka, 'yö Zedhizadhɛmö ‑mɛ ‑nu 'bha ‑nu 'wo ‑ya pö ‑sü ‑bha: «'Mɛ 'wo‑ mɔɔ‑ sië kö ‑wa zë ya 'yaa ‑mü 'ö ya ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","‑Kaa ‑ga 'ö dhiang zë sië mɛ kpö ya‑ 'gü ö 'flëë‑ 'gü 'ö 'waa‑ kë ‑kɔ 'bha‑ 'gü ya! \"Ɛɛn ꞊ya kë \"dhʋ̈ kö kwa ‑gɔmɛ ‑nu ꞊waa‑ 'wɔn ꞊në dɔ ꞊dhɛ Atanna ‑bha ‑Yamɛ 'ö‑ bɔ yö ‑mü tɛan‑ 'ka ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","\"Kɛɛ 'sa Atanna ‑bha ‑Yamɛ 'ö‑ nu ‑wɔn 'dhö 'dhö bha yö ‑zë mɛ 'bha 'yii 'dho‑ 'kpɔmɛ ‑nu dɔ, \"kɛɛ mɛ 'dhɛ 'kö ya kwa‑ 'kpɔmɛ ‑nu ‑dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","\"Tʋ̈ng 'wo dhiang zë sië‑ 'ka \"dhʋ̈ bha kö Yesu ‑yö mɛ draan‑ sië Atanna ‑dhɔkëgükɔ 'gü. 'Yö ö ‑wʋ \"dhiʋ̈ ꞊wlü 'ö‑ pö: «Ka‑ pö ‑zë ‑wo ka ‑dɩ ‑dhɛ ꞊dhɛ 'ka n ‑dɔ 'ö 'ka n 'kpɔmɛ ‑nu ꞊gban dɔ, \"kɛɛ a‑ ‑pö ka ‑dhɛ ꞊dhɛ 'mii nu n ‑dɩ 'ka, 'mɛ 'ö n bɔ bha ꞊në tɛanwɔn pömɛ 'ka, ka ꞊në 'kaa‑ dɔ ");
INSERT INTO daf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","\"kɛɛ ma ‑zë a‑ ‑dɔ, ‑a ‑gɛn ‑mü ꞊dhɛ yö ꞊në n bɔ, a ‑nu 'pö yö ꞊në‑ ‑bha nu 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","‑Wo ‑gun \"slë mɔɔ‑ sië kö ‑wa 'kun, \"kɛɛ mɛ 'bha ‑kɔ 'yii ꞊mɔɔ‑ ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ kö‑ ‑bha \"tʋ̈ng 'yii ꞊loo ꞊kö. ");
INSERT INTO daf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","‑A ‑kë \"dhʋ̈ ‑sü ꞊gban waa‑ ‑bha ‑bha, mɛ 'gbɛ ꞊dede ‑wo kë ‑slɔɔ mɛ kpö bha‑ 'gü 'wo 'dhang bho‑ \"dhiʋ̈ 'wo‑ pö: «Atanna ‑bha ‑Yamɛ 'ö‑ nu ‑wɔn 'dhö 'dhö ya yaa‑ ‑nu yi 'ö‑ 'ka, ‑yö ‑dho \"dhabhliwɔn ‑nu kë 'ö ‑ziö 'mɛ ya‑ ‑bha ‑ta \"wɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","‑Wʋ ‑nu 'wo gun‑ pö sië \"dhʋ̈ bha 'yö ‑da Fadhiziɛn ‑nu \"tʋ 'gü. 'Yö Zuifö ‑nu ‑bha \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu 'wo mɛ bɔ kö ‑wa 'kun. ");
INSERT INTO daf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «A ‑dho n yee kë 'a dho 'mɛ 'ö n bɔ bha‑ \"piʋ̈, \"kɛɛ ‑a \"tʋ̈ng 'yii ꞊loo ꞊kö, a ‑tun ꞊kö \"tʋ̈ng ꞊në 'bha ‑kë ka \"piʋ̈ yö. ");
INSERT INTO daf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","'Ma 'dho yi 'ö‑ 'ka ka ‑dho n mɔɔ‑, \"kɛɛ 'kii 'dho n yö, ‑a ‑gɛn ‑mü ꞊dhɛ ‑dhɛ 'a dho kë‑ 'gü \"dhʋ̈ bha 'kii 'dho ꞊mɔɔ ‑dho mü ‑sü ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Zuifö ‑nu ‑gɔmɛ ‑nu 'wo ‑ya wo 'ko dhɛɛ\" 'kpɔ ‑sü ‑bha 'wo‑ pö: «‑Dhɛ ‑mɛɛ ꞊në \"wɩ sië 'ka ya? ‑Yö ‑dho 'dho ‑dhɛ ‑mɛɛ ꞊në‑ 'gü kö 'ya 'dho ꞊mɔɔ ‑dho mü ‑sü ‑bha? \"Ɛɛn kö ‑yö 'dho Zuifö ‑nu 'wo ‑pɛn ‑sü 'ka Glɛkö ‑nu kpö 'gü bha‑ ‑nu \"piʋ̈ kö ‑yö 'mɛ 'waa Zuifö 'ka bha‑ ‑nu ꞊klang kë 'pö ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","\"Ɛɛn ‑a pö 'ö‑ wo ꞊dhɛ ka ‑dho n mɔɔ‑, 'kii 'dho n yö, ‑a ‑gɛn ‑mü ꞊dhɛ ‑dhɛ 'a dho kë‑ 'gü bha 'kii 'dho ꞊mɔɔ‑ ‑bha kö 'ka 'dho mü ya‑ 'klɔɔ‑ ‑mü ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Troo 'wo dho‑ ‑ta \"dhʋ̈ bha‑ ‑dhɛkpaɔyi ‑totaamasü ꞊në ꞊bhlëësü ꞊dedewo. ꞊Dhɛ 'ö‑ yi 'kpii‑ bha ꞊ya ꞊loo, 'yö Yesu ‑yö ꞊wlü 'yö dɔ ö ‑gɛan mɛ \"dhaa bha‑ ‑nu wëëdhö 'yö dhiang zë‑ ‑nu ‑dhɛ \"gbɩɩ‑ 'ka 'ö‑ pö: «\"Yi mü ‑dhɔ 'dhö 'mɛ 'ö‑ kë sië ‑a ‑mɛ nu n \"piʋ̈ kö ‑yö \"yi mü! ");
INSERT INTO daf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","'Mɛ 'ö ꞊ya 'dhang bho n \"dhiʋ̈, \"yigɔ 'ö ꞊dhɛ ꞊gwaan 'dhö ‑yö ‑dho bhɔ‑ ‑mɛ zuë\" 'gü ꞊dhɛ ‑kɔ 'ö Atanna ‑wʋ ‑ya pö‑ 'ka ‑a 'dhö.» ");
INSERT INTO daf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu ‑gun \"wɩ sië Atanna ‑bha 'Nii‑ 'ö 'mɛ 'wo dho 'dhang bho‑ \"dhiʋ̈, 'wo dho‑ ꞊slɔɔ bha ꞊në‑ 'ka \"dhʋ̈ bha, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a \"tʋ̈ng bha‑ 'gü kö Atanna 'yii 'Nii‑ bha‑ bɔ ꞊kö, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑a 'tɔ bhɔ \"tʋ̈ng 'yii ꞊loo ꞊kö. ");
INSERT INTO daf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","꞊Dhɛ 'ö mɛ 'bha ‑nu 'wo gun mɛ kpö bha‑ 'gü 'wo Yesu ‑wʋ ma ꞊dhɛ ‑kɔ bha‑ 'dhö 'yö 'wo‑ pö: «'Mɛ 'ö ya Atanna ‑wʋdhiʋ̈loomɛ 'ö‑ ‑nu ‑wɔn 'dhö 'dhö bha yö ‑mü ꞊dedewo tɛan‑ 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","'Yö mɛ 'bha ‑nu ‑dɩ 'pö 'wo‑ pö: «‑A ‑bha ‑Yamɛ ‑mü!» Kö mɛ 'bha ‑nu ‑dɩ 'pö ‑wa pö sië: «\"Kɛɛ ‑ka dɔ! Atanna ‑bha ‑Yamɛ bha ‑yö ‑mɔɔ ‑bha 'ö go Gadhidhe \"wɛ ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","‑A 'klɔɔ‑ ‑mü ꞊dhɛ ‑yö ‑bɛn zë ‑sü 'ka ‑a ‑wʋ 'gü ꞊dhɛ ‑a ‑bha ‑Yamɛ bha‑ ‑dho kë Davi suu 'gü ‑në ‑nu ꞊në‑ mɛ do 'ka, ‑yö ‑dho go Betedhɛmö, 'pödhɛ 'ö Davi ‑yö go‑ 'gü bha ꞊në‑ 'gü!» ");
INSERT INTO daf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mɛ kpö 'wo bha‑ ‑nu ‑pɛ 'gü ‑gɛn ꞊në bha Yesu ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mɛ 'bha ‑nu ‑gun ‑nu kpö 'gü 'ö ('wo‑ ‑nu bɔ, 'ö) gun‑ ‑nu \"piʋ̈ ꞊dhɛ 'wo‑ 'kun \"kɛɛ mɛ 'bha ‑kɔ 'yii ꞊mɔɔ‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","'Yö 'mɛ 'wo‑ ‑nu bɔ bha 'wo wo yee ‑kë 'wo dho \"saabhomɛ ‑nu ‑gɔmɛ waa‑ Fadhiziɛn ‑nu 'wo‑ ‑nu bɔ bha‑ ‑nu \"piʋ̈. ꞊Dhɛ 'ö ꞊wa wo \"yan ‑kpan 'mɛ 'wo‑ bɔ bha‑ ‑nu ‑bha kö ꞊wa wo yee kë ꞊wa nu wo ‑kɔ 'gü \"fië 'ka, 'yö 'wo‑ ‑nu dhɛɛ\" kpɔ 'wo‑ pö: «‑Yö ‑kë ‑mü ꞊dhɛ 'yö 'kii‑ 'kun kö 'ka nu‑ 'ka?» ");
INSERT INTO daf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'Yö 'wo ‑yɔ bɔ‑ ‑nu ‑gɔ 'wo‑ pö: «'Aa! Yi ‑zë mɛ suu 'bha 'yii dhiang zë ꞊dhɛ 'mɛ bha‑ 'dhö yi \"yaan do ‑wa!» ");
INSERT INTO daf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈ 'yö Fadhiziɛn ‑nu 'wo‑ pö‑ ‑nu ‑dhɛ: «\"Ɛɛn ‑a ‑kɔ ꞊ya ꞊mɔɔ kaa ‑dɩ 'pö ka ‑bha ꞊në wo ꞊zɔɔ ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","\"Ɛɛn ‑yö ka 'gü ꞊dhɛ ‑gɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu 'yi ‑dhɛ ya‑ 'gü ya mɛ 'bha ꞊në ꞊ya 'dhang bho‑ \"dhiʋ̈, ");
INSERT INTO daf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","kö 'yii kë \"wlaamɛ ‑nu 'ö 'waa Moizö ‑bha 'tɔng‑ 'bha dɔ, \"dhangmɛ ‑nu bha wo ‑zë ‑a ‑nu 'ka ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Fadhiziɛn ‑nu 'wo gun‑ pö sië \"dhʋ̈ bha Nikodɛmö ‑gun ‑nu kpö 'gü. 'Ö gun \"dhʋ̈ kö yö ‑zë ꞊ya 'dho 'nu Yesu ‑dhɛ 'gü ‑blɛɛsü wo. ꞊Dhɛ 'wo‑ pö \"dhʋ̈ 'yö‑ pö‑ ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«'Ö kwaa‑ 'tɔng‑ 'gü bha ‑oo, za‑ ‑mɔɔ ‑bha 'ö mɛ 'bha zë \"wɛɛwɛɛ kö 'yii ziö ö ‑bha 'gü, \"ɛɛn 'zü kö 'waa‑ ‑mɛ këwɔn dɔ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","'Yö 'wo‑ ‑yɔ bɔ Nikodɛmö ‑gɔ 'wo‑ pö: «i ‑go Gadhidhe ꞊në‑ wo 'pö 'yö 'i dhiang zë \"dhʋ̈ ‑ee? ‑Bhö i \"yan \"ta Atanna ‑wʋ 'gü ‑së 'ka, ꞊ya kë ꞊dhɛ 'bha i \"yan 'ta‑ 'gü, bhii ꞊dede i ‑dho ‑a ‑dhɛ yö ꞊dhɛ Atanna ‑wʋdhiʋ̈loomɛ ‑zë 'bha 'yii go Gadhidhe do.» ");
INSERT INTO daf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","꞊Dhɛ 'ö go‑ 'gü 'yö mɛ 'ö \"dhʋ̈ 'ö dho ö ‑gɔ 'kɔɔ. ");
INSERT INTO daf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑yö ꞊wlü 'ö dho ‑tɔn 'wo Odhivie ‑tɔn ‑kë bha‑ ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","\"Kɛɛ ꞊dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya ꞊kpaɔ, 'yö ‑ziö 'zü ‑deewo 'ö dho Atanna ‑dhɔkëgükɔ 'gü ‑dhɛkpaɔ tii 'gü, 'yö \"sɛgümɛ ‑nu ꞊gban \"pɛpɛ 'wo nu‑ ‑dhɛ 'gü. ꞊Dhɛ 'ö ꞊ya bo 'yaanu ‑sü 'ka, 'yö‑ ‑nu ꞊klang kë ‑sü zü bho. ");
INSERT INTO daf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","‑Yö ‑to mü 'yö Zuifö ‑nu ‑bha 'tɔnggɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu 'wo nu dhebhɔnë do 'wo‑ kun ꞊mlaabɔ ‑bha ‑a 'ka. ");
INSERT INTO daf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","'Yö 'wo‑ ‑ya wo ꞊zinng 'gü, 'yö 'wo‑ pö Yesu ‑dhɛ: «Yi Dëmɛ, dhebhɔnë ya ‑wa ‑kun ꞊mlaabɔ ꞊në‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","'Tɔng‑ 'ö Moizö ‑ya ‑bɛn zë kwa ‑dhɛ bha ‑ya ‑pö ꞊dhɛ ꞊wa dhebhɔ 'kun ꞊mlaabɔ ‑bha ꞊dhɛ ‑kɔ bha‑ 'dhö, ‑wa zë ‑gwë 'ka kö ‑yö ga. Bhi ‑zë i i ‑bha ‑pö 'gü ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","‑Wa ‑pö \"dhʋ̈‑ ‑wʋ mɔɔ‑ kian ꞊në‑ 'ka kë \"dhʋ̈ kö 'wo za ‑dɔ ‑bha ‑dhɛ yö. \"Kɛɛ ꞊dhɛ 'ö ꞊waa‑ pö \"dhʋ̈, 'yö Yesu ‑yö \"gblëënu, 'yö ‑ya ‑bɛn zë ‑sü ‑bha ö kɔngga 'ka \"sia‑. ");
INSERT INTO daf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","'Ö gun kö ‑wa dhɛɛ\" 'kpɔ sië ‑dhɔkɔ ‑dhɔkɔdhö ‑dhɛ do 'gü, 'yö ö ‑gɔ \"dhiʋ̈ ꞊wlü 'ö‑ pö‑ ‑nu ‑dhɛ: «'Mɛ 'ö ka kpö 'gü bha 'ö 'yii 'wɔn yaa kë do ‑a ‑mɛ ‑yö ‑gwë ‑blɛɛsü 'sü kö ‑ya ‑zuö dhebhɔ bha‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","'Yö \"gblëënu 'zü ‑deewo 'ö ‑ya ‑bɛn zë ‑sü ‑bha \"sia‑. ");
INSERT INTO daf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","꞊Dhɛ 'mɛ 'wo bha 'wo 'wɔn bha‑ ma, ('yö‑ ‑nu zuë\" 'dhö ‑ya za dɔ ‑sü ‑bha ‑a ‑nu ‑bha,) 'yö‑ mɛ \"gblʋ̈gblʋ̈ ‑nu 'wo gun‑ ‑nu ‑ta bha 'wo ‑ya 'dho ‑sü ‑bha, 'yö 'wo dho \"dhʋ̈ flɛ ꞊flɛ flɛdhö ('yö‑ ‑nu ꞊gban 'wo dho). 'Yö dhebhɔnë bha 'ö to ö do 'ka Yesu ‑kuu \"dhiʋ̈ mü. ");
INSERT INTO daf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","'Yö Yesu ‑yö ö ‑gɔ \"dhiʋ̈ ꞊wlü 'zü ‑deewo, ('ö dho ‑dhɛ ‑ga kö 'mɛ 'wo bha‑ ꞊gban ꞊wa 'dho kö dhebhɔ bha yöö do ꞊në ꞊ya 'to mü). 'Yö‑ pö‑ ‑dhɛ: «'Yö 'mɛ 'wo nu i 'ka ya ‑wo 'mɛ, dhebhɔnë? \"Ɛɛn i ‑zëzakamɛ 'yii ꞊slɔɔ‑ ‑nu kpö 'gü ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","'Yö‑ ‑yɔ bɔ Yesu ‑gɔ 'ö‑ pö: «꞊Iin ‑wa, n Dëmɛ.» 'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Ɛɛ! Mang ‑dɩ 'pö 'mii 'dho i zë za 'ka. ‑Bhö 'dho, \"kɛɛ 'bha 'dho, 'bha 'dho 'wɔn yaa kë 'zü!» ");
INSERT INTO daf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","'Yö Yesu ‑yö dhiang zë 'zü ‑deewo 'mɛ 'wo gun mü ‑blɛɛsü bha‑ ‑nu ‑dhɛ 'ö‑ pö: «Ma ꞊në 'a \"kpʋngtaadhɛ ‑bha ‑dhɛpuudhɛ 'ka. 'Mɛ 'ö ꞊ya ziö n ꞊keng‑, ‑dhɛ ‑dho \"pʋ‑ ‑mɛ ‑bha ‑tosɛa ‑ta 'ö 'yaa ‑tosɛa kë ö tii ‑bha 'zü tongtongdhö, \"kɛɛ 'ö‑ ‑kë ‑dhɛpuudhɛ ꞊në‑ 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Fadhiziɛn ‑nu ‑wa pö‑ ‑dhɛ 'wo‑ pö: «‑A 'dhɛ 'kö bha \"sɛɛdhɛ ꞊në‑ kë sië i ‑dɩ ‑bha bha. ꞊Ya 'to yö ‑zë ‑bha kö 'pë 'i‑ pö sië bha ꞊sua ꞊në‑ ꞊gban 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Kö 'zü 'ö ‑kë ꞊dhɛ a \"sɛɛdhɛ ‑kë n ‑dɩ ‑bha oo, 'mii‑ kë n ‑dɩ ‑bha oo, a‑ 'wɔn ‑dɔ ꞊dhɛ tɛanwɔn ꞊në 'a‑ pö, ‑a ‑gɛn ‑mü ꞊dhɛ ka ꞊në 'kaa n 'godhɛ waa‑ n 'dhodhɛ dɔ, \"kɛɛ ma ‑zë a‑ ‑dɔ. ");
INSERT INTO daf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ka ꞊në 'ka za dɔ n ‑bha ka ‑gɔ \"piʋ̈ \"wɛɛwɛɛ, \"kɛɛ ma ‑zë 'maa za dɔ mɛ 'bha ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","'Kö 'zü 'ma za ‑zian dɔ mɛ ‑bha kö tɛanwɔn ꞊në 'a‑ pö, ‑a ‑gɛn ‑mü ꞊dhɛ 'maa n do 'ka, n Dë 'ö n bɔ bha ‑yö n \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","'Yö‑ ‑bɛn 'dhö zë ‑sü 'ka 'zü ka ‑bha 'tɔng‑ 'sëëdhɛ 'gü ꞊dhɛ \"sɛɛ‑ ꞊plɛ ‑wʋ ꞊ya kë do 'wɔn 'dhɛ 'kö‑ ‑bha kö tɛan‑ ‑mü. ");
INSERT INTO daf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","‑A ‑kë \"dhʋ̈ ‑sü 'gü, a n ‑dɩ \"sɛɛ‑ 'ka, 'yö n Dë 'ö n bɔ bha 'ö \"sɛɛdhɛ ‑kë n ‑bha 'pö.» ");
INSERT INTO daf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","'Yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «I dë ꞊në de 'ka?» 'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «N dɔ 'ö 'kaa‑ wo ꞊në‑ ‑wɔn 'gü 'yö 'kaa n Dë dɔ bha. ꞊Ya kë ꞊dhɛ ka n ‑dɔ 'nu kö n Dë ‑dɩ 'pö ka‑ ‑dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","‑Yö dhiang ‑nu bha‑ ‑zë \"dhʋ̈ kö ‑yö Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gü, ‑dhɛ 'wo Atanna ‑bha 'kɔ ‑yë ‑kë 'ka 'wëë‑ bho‑ ‑bha bha‑ 'gü, \"kɛɛ mɛ 'bha ‑kɔ 'yii ꞊mɔɔ‑ 'kun ‑sü ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ kö‑ ‑bha yi 'yii ꞊loo ꞊kö. ");
INSERT INTO daf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","'Yö‑ pö 'zü‑ ‑nu ‑dhɛ ‑deewo 'ö‑ pö: «Maa 'dho, \"kɛɛ 'ma 'dho, ka ‑dho n mɔɔ‑, \"kɛɛ 'kii 'dho n yö 'ö to \"dhʋ̈ 'ö 'ka ga ka ꞊sɔng 'ka ka ‑bha; ‑a ‑gɛn ‑mü ꞊dhɛ ‑dhɛ 'a 'dho sië‑ ‑bha bha, 'kii 'dho ꞊mɔɔ‑ ‑bha kö 'ka 'dho mü.» ");
INSERT INTO daf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","꞊Dhɛ 'ö‑ pö \"dhʋ̈ 'yö ‑gɔmɛ ‑nu bha 'wo‑ pö wo 'ko ‑dhɛ: «‑Yö ‑më ‑dhiang ꞊në‑ zë ꞊ni? \"Ɛɛn yöö ö ‑dɩ zë ‑ee?» \"Ɛɛn 'zü ‑a pö 'ö‑ wo ꞊dhɛ ‑dhɛ 'ö yöö 'dho‑ ‑bha 'kwaa ꞊mɔɔ‑ ‑bha kö 'kwa dho mü bha‑ ‑gɛn ‑mü ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","'Yö‑ pö‑ ‑nu ‑dhɛ: «Ka ‑zë ka kpu‑ ‑go \"kpʋng ꞊taa yö, \"kɛɛ ma ‑zë n kpu‑ ‑go dhang‑ 'gü. \"Kpʋngtaamɛ ‑mü ka ‑zë ka 'ka, \"kɛɛ \"kpʋngtaamɛ 'yaa ‑mü ma ‑zë n 'ka. ");
INSERT INTO daf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yö ꞊në‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ ka ‑dho ga ka ꞊sɔng 'ka ka ‑bha. ꞊Ya kë ꞊dhɛ kö 'kii 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ ma ꞊në 'a 'dhö 'ka, ka ‑dho ga ka ꞊sɔng 'ka ka ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","'Yö 'wo‑ pö‑ ‑dhɛ: «De ‑zë ‑mü i 'ka ‑zë wo ꞊zɔɔ?» 'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «Pë do 'a ‑gban pö ‑sü ‑bha ka ‑dhɛ 'yi bha‑ 'ka ꞊në 'a‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","꞊Sɔng 'gbɛ ‑yö ka ‑bha, 'ö 'a ꞊mɔɔ‑ 'nu‑ ‑bha 'a‑ pö \"ɛɛn 'ö 'a za dɔ‑ 'ka ka ‑bha, \"kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ 'mɛ 'ö n bɔ bha yö ꞊në tɛanwɔn pö bha, yö ꞊në‑ ‑wɔn 'gü 'yö 'wɔn 'dhɛ 'a‑ ma‑ ‑ta ꞊në 'a‑ pö mɛ \"bhɩɩ‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","\"Kɛɛ ‑a pö 'ö‑ wo \"dhʋ̈ bha 'wii‑ 'gü ma ꞊dhɛ ‑yö ‑wɩ ö Dë Atanna ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yö ꞊në‑ ‑wɔn 'gü 'yö‑ pö 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'ka bo mang Mɛgbömɛ n ‑dɔ \"dhü ‑bha ‑sü 'ka yi 'ö‑ 'ka, 'yö 'pë 'a‑ 'ka 'ka gun ‑na ‑a dɔ, \"ɛɛn 'zü ꞊dhɛ 'maa 'wɔn 'bha kë n ‑dɩ ‑ta, \"kɛɛ ‑wʋ 'ö n Dë ‑ya kpɔ n ‑bha 'yö 'a‑ 'gü ‑wɔn ‑kë. ");
INSERT INTO daf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","'Mɛ 'ö n bɔ \"dhʋ̈ bha ‑yö n \"piʋ̈, 'yii n 'to n do 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ a‑ ‑dhidhɛwɔn ꞊në‑ ‑kë yi ꞊gban ‑yi ꞊gban 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mɛ 'gbɛ ‑wo kë 'dhang bho‑ \"dhiʋ̈ dhiang ‑nu 'ö‑ zë \"dhʋ̈ bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","'Yö‑ pö Zuifö ‑nu 'wo 'dhang bho‑ \"dhiʋ̈ bha‑ ‑nu ‑dhɛ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'ka 'to ‑kplü ‑sü 'ka n ‑wʋ ‑bha ‑së 'ka \"pɛɛpɛdhö, kö 'ka kë ma ꞊klang ꞊dede 'ka. ");
INSERT INTO daf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ka ‑dho tɛanwɔn dɔ, 'ö tɛanwɔn bha 'ö ka gba ‑ya ‑dɩ 'flëë‑ 'gü ‑sü 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Ablaamö suu ‑mü yi 'ka, 'yii ‑da ꞊dhuëngdhɛ 'gü mɛ 'bha ‑gɔ do, ‑yö kë ‑kɔ ‑kë ꞊dhɛ 'yö 'i‑ pö yi ‑dho 'go ꞊dhuëngdhɛ 'gü?» ");
INSERT INTO daf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","'Yö Yesu ‑ya pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ mɛ \"ʋʋ mɛ 'ö 'wɔn yaa ‑zë ‑kë, kö‑ ‑mɛ ‑yö 'wɔn yaa ‑gɔ ꞊dhuëngdhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","\"Kɛɛ 'sa kö ꞊dhuëng ‑zë 'yaa 'to 'kɔdhi 'gü kö 'yii kë 'kɔ 'gü 'në ‑zë 'ka. ");
INSERT INTO daf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","‑A ‑kë \"dhʋ̈ ‑sü 'gü, ꞊ya kë ꞊dhɛ mang Atanna gbö ‑mɛ ‑zë 'ma ka bho ꞊dhuëngdhɛ 'gü kö 'ka 'go ꞊dede ꞊në‑ wo ꞊dhuëngdhɛ 'gü bha. ");
INSERT INTO daf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A‑ 'wɔn ‑dɔ ꞊dhɛ Ablaamö suu ‑mü ka 'ka, \"kɛɛ n ‑wʋ 'yaa 'dho 'ö‑ wo ka \"tʋʋdhö 'yö ‑kë 'yö ka \"piʋ̈ ꞊dhɛ 'ka n zë bha. ");
INSERT INTO daf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pë 'ö n Dë ‑ya ‑zɔn n ‑dhɛ ꞊në 'a‑ ‑dhiang zë, \"kɛɛ ka ‑zë, 'pë 'ö ka dë ‑ya ‑dhiang zë ka ‑dhɛ ꞊në 'ka‑ ‑kë.» ");
INSERT INTO daf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Ablaamö ꞊në yi dë 'ka!» 'Yö Yesu ‑ya pö 'pö‑ ‑nu ‑dhɛ: «(Ablaamö suu 'yaa ‑mü ka 'ka!) ꞊Ya kë ꞊dhɛ ka ‑kë Ablaamö suu 'ka 'nu kö ka ‑dho Ablaamö këwɔn ‑nu kë. ");
INSERT INTO daf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","\"Kɛɛ ka ‑zë n zë ‑zian ꞊në 'kaa‑ mɔɔ‑ sië, \"kɛɛ 'sa kö tɛanwɔn 'a‑ ma n Dë ‑ta ꞊në 'a‑ pö ka ‑dhɛ. 'Sa Ablaamö ‑zë 'yii yö ‑zë suu kë!» ");
INSERT INTO daf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","꞊Ya kë \"dhʋ̈ kö 'pë ka dë ‑ya ‑kë 'yö 'ka‑ kë sië bha, (kö Ablaamö ‑zë 'yaa ka dë 'ka).» 'Yö 'wo‑ pö‑ ‑dhɛ: «Yi ‑zë 'tʋʋ‑ ‑ta ‑në 'yaa ‑mü yi 'ka ‑wa. Yi dë ‑yö doseng yö ‑mü Atanna ꞊në‑ 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «Ka dë 'yaa ‑mü Atanna 'ka! Ka dë‑ ‑kë Atanna 'ka 'nu kö n ‑dhɔ ‑dho ka kë. ‑A ‑gɛn ‑mü ꞊dhɛ a ‑go yö ꞊në‑ 'gü. ꞊Ya 'go mü 'zü a ‑nu yö ꞊në‑ ‑bha nu 'gü. 'Mii nu n ‑dɩ 'ka, yö ꞊në n bɔ. ");
INSERT INTO daf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","‑Më ꞊në ‑kë 'yö 'kaa n ‑wʋ 'gü ma? ‑A ‑gɛn ‑mü ꞊dhɛ 'kaa \"tʋ 'to n ‑wʋ ‑bha! ");
INSERT INTO daf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","꞊Ya kë \"dhʋ̈ kö ka ‑zë ka dë ꞊në Sɔtraan 'ka, 'yö 'ka‑ \"piʋ̈ ꞊dhɛ 'ka ka dë bha‑ ‑dhidhɛwɔn kë bha, 'sa kö yö ‑zë mɛzëmɛ ‑mü 'ö ‑bhɔ 'ka \"dhʋ̈ ‑a zübhoyi 'ka 'yii tɛanwɔn pö do, ‑a ‑gɛn ‑mü ꞊dhɛ tɛanwɔn pö zuëga 'yaa‑ \"gblʋ̈ʋ̈‑, ‑a ‑dɔ 'ka ‑mü ꞊sua ꞊në‑ 'ka, 'yii ꞊sua kë‑ ꞊nii 'yaa ‑da, ‑a ‑gɛn ‑mü ꞊dhɛ yö ꞊në ꞊sua suu ‑da. ");
INSERT INTO daf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","'Wɔn 'ö‑ ‑wɔn 'gü, 'yö ma ‑zë 'ma tɛanwɔn pö ka ‑dhɛ 'yö 'kaa 'dhang bho n \"dhiʋ̈ bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","\"Ɛɛn de ‑mü 'ka ka kpö 'gü bha 'yö ꞊sɔng yö ‑sü 'ka n ‑bha? ꞊Ya kë \"dhʋ̈ 'ma tɛanwɔn pö ka ‑dhɛ bha ‑oo! 'Kaa 'dhang bho‑ \"dhiʋ̈ ‑më ‑wɔn ꞊në‑ 'gü? ");
INSERT INTO daf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ka ‑zë ka dë ꞊në 'yaa Atanna 'ka 'yö‑ ‑wɔn 'gü 'yö 'kaa ka \"tʋ 'to n ‑wʋ ‑bha bha, \"kɛɛ 'yaa yö ‑zë 'ka, mɛ \"ʋʋ mɛ 'kö Atanna ‑bha 'ka, ‑yö ö \"tʋ ‑to ‑a ‑wʋ ‑bha!» ");
INSERT INTO daf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","'Yö Zuifö ‑nu ‑gɔmɛ ‑nu bha 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «‑A pö 'yi‑ wo ꞊dhɛ Atanna ‑wɔn ‑ma ‑zukplü ‑bha ‑mɛ ‑nu 'wo‑ ‑nu Samadhi ‑mɛ ‑nu ‑kë bha‑ mɛ do ‑mü i 'ka, \"kɛɛ \"yina yaa ‑yö i 'gü ya 'yaa ꞊sua 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","'Yö Yesu ꞊ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'pö 'ö‑ pö: «\"Yina yaa 'bha 'yaa n 'gü, ma ‑zë n Dë ꞊në 'a‑ ꞊bhlëë ‑ya, \"kɛɛ 'yö ka ‑zë 'ka ꞊bhlëë ꞊në‑ bho n ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma ‑zë 'mii n ‑dɩ 'tɔbhɔdhɛ mɔɔ‑, ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑mɔɔ n ‑dhɛ ‑mɛ ‑dhö, yö 'ö \"dhʋ̈ bha ꞊në ma ‑zë n ‑ta ‑zadɔmɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","\"Kɛɛ a‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ ꞊ya n ‑wʋ ma kö‑ ‑mɛ ‑ya ‑ya ꞊bhlëë 'gü, ‑a ‑mɛ 'yii 'dho ga tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","꞊Dhɛ 'ö Yesu ꞊yaa‑ pö \"dhʋ̈ 'yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «'Ya‑ 'wɔn dɔ ꞊tɔn ꞊dedewo ꞊dhɛ \"yina yaa ꞊në i 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ bhi ‑zë i‑ ‑pö ꞊dhɛ mɛ \"ʋʋ mɛ 'ö ꞊ya 'dhang bho i \"dhiʋ̈ ‑a ‑mɛ 'yii 'dho ga tongtongdhö, \"kɛɛ 'sa kö Ablaamö waa‑ Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑zë ꞊gban ꞊wa ga. ");
INSERT INTO daf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","\"Ɛɛn ꞊ya kë \"dhʋ̈ kö bhi ‑zë i fië‑ ꞊në 'dhö yi dë Ablaamö 'ö yö ‑zë ꞊ya ga bha‑ 'ka bha ‑ee? Atanna ‑wʋdhiʋ̈loomɛ ‑nu ꞊gban ꞊wa ga ‑dhɛ 'ö‑ ‑bha bha bhi ‑zë de ‑mü i 'ka ('yö 'i‑ pö 'mɛ ꞊ya 'dhang bho i \"dhiʋ̈ 'yii 'dho ga tongtongdhö)?» ");
INSERT INTO daf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: ꞊Ya kë 'nu ꞊dhɛ kö ma ꞊në 'a n ‑dɩ 'tɔ bhɔ sië, kö n 'tɔ bhɔ ‑sü 'yaa pë 'bha 'ka, kö ‑yö \"wlaasü, \"kɛɛ n Dë do 'ka‑ ‑dhɛ sië kaa‑ Atanna bha ꞊në n 'tɔ bhɔ sië. ");
INSERT INTO daf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","\"Kɛɛ 'sa kö 'kaa‑ dɔ, 'sa ma ‑zë a‑ ‑dɔ. ꞊Ya kë ꞊dhɛ a‑ ‑pö 'nu ꞊dhɛ 'maa‑ dɔ kö ꞊suakëmɛ ‑mü n 'ka 'pö ꞊dhɛ ka 'dhö. \"Kɛɛ a‑ ‑dɔ, a‑ ‑wʋ ‑ma yö ꞊në‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","'Sa kö ka 'ziʋ̈‑ Ablaamö ‑zë ‑yö ö ‑zʋ ‑gɔn ꞊dhɛ ö ‑dho n nu \"tʋ̈ng yö, 'yö ö ‑sëkë \"dhiʋ̈, \"kɛɛ kö‑ yi‑ ‑tun mü ꞊gblɛɛn. ꞊Dhɛ 'ö‑ \"yan 'dhö ‑da ‑a ‑dhɛ 'gü, ‑a ꞊nii‑ kë ‑da.» ");
INSERT INTO daf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","'Yö Zuifö ‑nu 'wo‑ pö: «‑A ‑kwɛ ‑zian 'yii ꞊mɔɔ ꞊kö ‑kaɔng \"sɔɔdhu ‑bha \"kɛɛ ‑yö Ablaamö ‑dhiang zë sië!» ");
INSERT INTO daf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «A‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'ö gun kö Ablaamö 'yii bhɔ ꞊kö kö ma ‑zë a ‑dhö.» ");
INSERT INTO daf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Zuifö ‑nu 'wo ‑gwë sü 'yö 'wo‑ pö 'wo‑ zë ‑gwë 'ka, \"kɛɛ 'yö ö ‑gblɛn kpɔ 'yö zun \"kpɛnng. ");
INSERT INTO daf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","'Ö gun kö Yesu ‑yö ziö sië 'pö‑ \"piʋ̈, 'yö ‑kpan gɔndënë do 'bha bha‑ ‑bha. 'Mɛ bha 'ö bhɔ kö‑ \"yan ‑yö ꞊wlü 'ka. ");
INSERT INTO daf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","'Yö Yesu ‑bha ꞊klang ‑nu 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi Dëmɛ, 'mɛ 'ö ya yö ꞊në 'wɔn yaa ‑kë ‑ee, \"ɛɛn ‑a dë ‑nu ꞊në 'wo 'wɔn yaa ‑kë 'yö‑ ‑wɔn 'gü 'yö bhɔ kö‑ \"yan ‑yö 'wü ‑sü 'ka ya?» ");
INSERT INTO daf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Ö bhɔ 'ö‑ wo \"yan ꞊wlü 'ka bha‑ ‑gɛn 'yii ‑gban ‑a ‑bha 'wɔn yaa kë ‑sü, \"ɛɛn 'zü ‑a 'kpɔmɛ ‑nu ‑bha ‑bha, \"kɛɛ ‑yö ‑kë \"dhʋ̈ kö mɛ \"bhɩɩ‑ ‑nu ꞊në ‑wo Atanna ‑bha 'gügbɩɩdhɛ dɔ‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","꞊Dhɛ 'ö ‑kë ꞊dhɛ \"bin 'yii 'ma ꞊kö bha‑ ‑dhɛa ‑bha ꞊dhɛ mɛ 'ö n bɔ bha, 'ö n bɔ‑ 'wɔn 'ö‑ 'gü 'kwa‑ kë, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ \"bin ‑zë ꞊ya bo 'ma ‑sü 'ka, kö yë kë \"tʋ̈ng ꞊ya ziö. ");
INSERT INTO daf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","\"Tʋ̈ng 'a ‑tun 'ka \"kpʋng ꞊taa yö bha ma ꞊në 'a ‑dhɛ ‑pʋ mɛ \"bhɩɩ‑ ‑nu ‑ta.» ");
INSERT INTO daf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö \"dhidhi bho \"sia‑, 'yö pa‑ 'gü, 'yö ‑kë bʋ̈ʋ̈‑ 'ka, 'yö‑ ‑kan 'mɛ bha‑ \"yan 'gü. ");
INSERT INTO daf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","꞊Dhɛ 'ö ꞊yaa‑ \"kan‑ \"yan 'gü \"dhʋ̈ 'yö‑ pö‑ ‑dhɛ: «‑Bhö 'dho kö 'i i wëë' \"zu \"yi ꞊gblü 'wo‑ Sidhoe ‑kë bha‑ ꞊bhaa.» (꞊Waa‑ pö Sidhoe ‑a ‑nu ‑wʋ 'gü kö ‑wa pö \"yi 'wo‑ bɔ). ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö gɔndënë bha 'ö dho \"yi bha‑ ꞊bhaa, 'yö ö wëë' ‑zu mü. ‑A ‑go mü ‑sü 'ka kö‑ \"yan 'gü ꞊ya \"pʋ, kö ꞊ya ‑dhɛ yö 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö‑ ‑yayɔɔ ‑nu waa‑ 'mɛ 'wo‑ dɔ gbadhɛmɛ 'ka 'nu ‑blɛɛsü bha 'wo‑ pö: «Gbadhɛmɛ 'ö gun ‑ya ‑sü 'ka ‑dhɛ 'ya‑ 'gü ya 'yaa kë ꞊ni ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","'Yö mɛ 'bha ‑nu ‑wa pö: «Yö ‑mü.» Kö mɛ 'bha ‑nu ‑wa pö sië 'pö: «‑Abin ꞊maa, ‑yö ‑bhɔ ꞊në wo‑ ‑bha \"kɛɛ 'yaa ‑mü!» 'Yö yöö ꞊dede 'ö‑ pö: «Mɛ \"wɛɛ 'bha 'yaa ‑mü, ma ‑mü!» ");
INSERT INTO daf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «I \"yan ‑yö \"pʋ ‑kɔ ‑kë ꞊dhɛ 'sa?» ");
INSERT INTO daf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Mɛ 'wo‑ ‑dhɛ Yesu bha ꞊në bʋ̈ʋ̈‑ ‑kë 'yö‑ ‑kan n \"yan 'gü, 'yö‑ pö n ‑dhɛ 'a 'dho kö 'a n wëë' \"zu \"yi 'wo‑ Sidhoe ‑kë bha‑ ꞊bhaa, 'yö 'a 'dho 'a n wëë' ‑zu mü. ꞊Dhɛ 'ö 'ma bo n wëë' \"zu ‑sü 'ka, 'yö n \"yan ‑yö ‑dhɛ yö.» ");
INSERT INTO daf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","'Yö 'wo‑ dhɛɛ\" 'bha kpɔ 'zü 'wo‑ pö: «‑A 'mɛ 'ö \"dhʋ̈ bha ‑yö 'mɛ?» 'Yö‑ pö‑ ‑nu ‑dhɛ: «'Aa! 'maa‑ yö ‑zë 'wɔn dɔ!» ");
INSERT INTO daf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö 'mɛ 'ö Yesu ‑ya dha bha 'wo dho‑ 'ka Fadhiziɛn ‑nu ‑kuu \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bʋ̈ʋ̈‑ 'ö Yesu ‑ya ‑kë 'ö gɔndënë bha‑ dha‑ 'ka bha ‑ya ‑kë \"dhʋ̈ Zuifö ‑nu ‑bha ꞊glooyi do 'bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yö ꞊në‑ ‑wɔn 'gü 'yö Fadhiziɛn ‑nu 'wo gɔndënë bha‑ dhɛɛ\" kpɔ 'pö ‑kɔ 'ö ‑kë 'ka 'yö‑ \"yan ‑yö ‑dhɛ yö bha‑ ‑wɔn 'ka. 'Yö‑ ‑yɔ bɔ 'pö‑ ‑nu ‑gɔ 'ö‑ pö: «‑Yö bʋ̈ʋ̈‑ ꞊në‑ ‑kan n \"yan 'gü 'yö 'a dho 'a n wëë' ‑zu 'yö 'a ‑dhɛ yö.» ");
INSERT INTO daf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","'Yö Fadhiziɛn ‑nu 'wo ‑pɛ 'gü, 'yö ‑kɔ \"pɛan bha ‑ya pö: «'Mɛ 'ö bhɔ \"dhʋ̈ bha Atanna ‑bha mɛ 'yaa ‑mü; yö ꞊në‑ ‑wɔn 'gü 'yö 'yaa‑ ‑bha 'tɔng‑ 'ö‑ ‑gban ꞊glooyi ‑bha bha‑ ꞊bhlëë ‑ya.» Kö ‑kɔ \"pɛan 'bha ‑dɩ 'pö ‑ya pö sië 'ö‑ pö: «Atanna ‑bha mɛ ‑mü! 'Yaa \"dhʋ̈ 'mɛ 'kö 'yaa Atanna ‑bha mɛ 'ka ‑yö ‑mɔɔ ‑bha 'ö \"dhabhliwɔn suu ‑nu ya‑ kë ‑kɔ ‑kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","'Yö Fadhiziɛn ‑nu 'wo‑ dhɛɛ\" 'bha kpɔ 'zü 'wo‑ pö: «'Ö bhi 'kö bhi ‑zë i \"yan \"dhiʋ̈ ‑pʋ bha i i ‑bha ‑pö 'gü ꞊dhɛ?» 'Yö‑ pö: «Ma ‑zë a‑ ‑pö Atanna ‑wʋdhiʋ̈loomɛ ‑mü ‑wa!» ");
INSERT INTO daf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","\"Kɛɛ ‑a ‑pö ꞊dhɛ 'mɛ 'kö bha‑ \"yan‑ ‑gun 'wü ‑sü 'ka \"pɛɛpɛdhö 'yö ‑dhɛ ‑dee 'bha yö sië bha‑ ‑wɔn ‑zë 'yii bhɔ Fadhiziɛn ‑nu bha‑ ‑nu 'gü tɛan‑ ‑bha tongtongdhö. 'Yö 'wo 'mɛ bha‑ dë ‑nu ‑dhɛ kö 'wo‑ ‑nu dhɛɛ\" 'kpɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","꞊Dhɛ 'ö ꞊wa nu, 'yö 'wo‑ ‑nu dhɛɛ\" kpɔ 'wo‑ pö: «'Mɛ ya ka gbö ‑mü ‑ee? ‑Wa ‑pö 'ö bhɔ kö‑ \"yan ‑yö 'wü ‑sü 'ka ‑wa, tɛan‑ ‑mü ‑ee? 'Yö ‑yö kë ‑kɔ ‑kë ꞊dhɛ 'yö ‑dhɛ yö ‑deewo?» ");
INSERT INTO daf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","'Yö \"yanwlümɛ bha‑ 'kpɔmɛ ‑nu bha 'wo‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'wo‑ pö: «Yi gbö ‑mü, 'ö bhɔ kö‑ \"yan ‑yö ꞊wlü 'ka \"dhʋ̈ tɛan‑ 'ka, ");
INSERT INTO daf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","\"kɛɛ 'ö ‑kë ‑kɔ 'kö‑ ‑bha 'yö ‑dhɛ ‑dee 'bha yö sië ya 'yaa yö ‑zë 'wɔn dɔ, 'mɛ 'ö 'wɔn bha‑ ‑kë 'pö 'yaa‑ dɔ. ‑Kaa yöö ꞊dede dhɛɛ\" 'kpɔ kö ‑ya ‑gɛn bho ka ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ 'yaa 'në 'dɛdɛ 'ka 'zü!» ");
INSERT INTO daf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","‑A pö 'ö 'mɛ bha‑ dë ‑nu bha ‑wa wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ kö ‑wo \"suʋ̈ sië Zuifö ‑nu ‑gɔmɛ ‑nu bha‑ ‑nu ‑gɔ; ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊wa ‑ya 'kwëë‑ kë kö‑ ‑nu ‑wʋ ꞊ya 'to‑ ‑bha do ꞊dhɛ mɛ \"ʋʋ mɛ 'ö dho‑ pö ꞊dhɛ Yesu bha Atanna ‑bha ‑Yamɛ Klisi ‑mü, ‑wo ‑dho a‑ ‑mɛ ‑gɛn ‑naa 'kpɔ, 'ö 'yaa ‑da ‑a ‑nu ‑bha ‑yakwëëkëgükɔ 'bha ‑bha 'bha 'gü 'zü. ");
INSERT INTO daf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","'Wɔn 'ö‑ ‑wɔn 'gü 'yö‑ dë ‑nu ‑wa pö 'në 'dɛdɛ 'yaa ‑mü, ‑kaa yöö ꞊dede dhɛɛ\" 'kpɔ kö ‑ya ‑gɛn bho bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","'Yö Fadhiziɛn ‑nu 'wo 'mɛ 'ö \"yan ‑yö gun ꞊wlü 'ka bha‑ ‑dhɛ 'zü ‑deewo, 'yö 'wo‑ pö‑ ‑dhɛ: «'i‑ zë Atanna ‑dhɛ! 'Mɛ 'ö i dha bha de suu ‑mü? ‑A pö 'yi‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ yi ‑zë yi 'dhang bho ‑sü ‑ya \"dhiʋ̈ ꞊dhɛ 'mɛ bha 'wɔnyaakëmɛ ‑mü.» ");
INSERT INTO daf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Wɔnyaakëmɛ ‑mü ‑ee, \"ɛɛn 'wɔnyaakëmɛ 'yaa ‑mü ‑ee, 'maa yö ‑zë 'wɔn dɔ! N ‑bha 'a‑ dɔ ‑yö doseng, yö ‑mü ꞊dhɛ 'a bhɔ kö 'maa ‑dhɛ yö \"kɛɛ 'ma ‑dhɛ yö ꞊taa yö‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","'Yö 'wo‑ pö‑ ‑dhɛ: «‑Yö i \"yan \"dhiʋ̈ \"pʋ ‑kɔ kë ꞊dhɛ? ‑Yö ‑më ꞊në‑ ‑kë i ‑bha?» ");
INSERT INTO daf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","'Yö‑ ‑yɔ bɔ 'zü‑ ‑nu ‑gɔ 'ö‑ pö: «'Ma ziö ‑zë wo‑ ‑gɛn 'gü ka ‑dhɛ 'nu, \"tʋ ꞊në 'kii‑ 'to n ‑wʋ ‑bha, ka n dhɛɛ\" ‑kpɔ 'zü ‑deewo ‑më ‑wɔn 'gü? \"Ɛɛn ‑yö ka \"piʋ̈ 'pö ꞊dhɛ 'ka ‑da ꞊keng‑ kö 'ka kë‑ ‑bha ꞊klangdhiʋ̈ 'ka ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","꞊Dhɛ 'ö‑ pö \"dhʋ̈ 'yö 'wo ‑ya \"si bho ‑sü ‑bha ‑a ‑gɔ, 'yö 'wo‑ pö‑ ‑dhɛ: «Bhi ꞊në 'i‑ ‑bha ꞊klangdhiʋ̈ 'ka, \"kɛɛ yi ‑zë yi Moizö ꞊në‑ ‑bha ‑gɔ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","‑A ‑gɛn ‑mü ꞊dhɛ yi Moizö ꞊në‑ dɔ ꞊dhɛ 'mɛ 'ö Atanna ‑yö dhiang zë‑ ‑dhɛ ‑a 'dhö, \"kɛɛ mɛ 'dhɛ 'kö bha 'yaa‑ 'godhɛ dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","'Yö 'mɛ bha 'ö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑A kë ‑sü kö 'ka‑ pö ꞊dhɛ 'kaa 'mɛ 'kö bha‑ 'godhɛ dɔ ‑zë 'wɔn ꞊në n kɔn, \"kɛɛ 'sa yö ꞊në ma ‑zë n dha. ");
INSERT INTO daf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mɛ ꞊gban kwa‑ 'wɔn ‑dɔ ꞊dhɛ Atanna 'yaa ö \"tʋ 'to 'wɔnyaakëmɛ ‑bha bhɛa\" ‑wʋ ‑bha kö 'yii kë 'mɛ kö‑ ꞊bhlëë ‑ya, 'ö ö \"tʋ to‑ ‑wʋ ‑bha ‑a 'ka. ");
INSERT INTO daf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","꞊Ya 'go ‑mü 'zü 'kwii‑ ‑ma \"sɛ ya‑ 'gü do ꞊dhɛ 'mɛ 'ö bhɔ kö‑ \"yan ‑yö 'wü ‑sü 'ka mɛ 'bha ꞊yaa‑ ‑mɛ kë \"klʋ̈ʋ̈klʋ̈ do. ");
INSERT INTO daf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","꞊Ya kë 'nu ꞊dhɛ 'mɛ bha Atanna ‑bha mɛ 'yaa ‑mü, kö‑ ‑kɔ 'yii 'dho ꞊mɔɔ 'wɔn bha‑ kë ‑sü ‑bha!» ");
INSERT INTO daf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","'Yö Fadhiziɛn ‑nu bha 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Bhi 'ö bhi ‑zë 'wɔn yaa \"kɔngblɛ 'dhö i ‑bha, 'ö 'i bhɔ 'wɔn yaa 'gü, 'ö 'i ‑gla 'wɔn yaa 'gü bha ‑yö i \"piʋ̈ ꞊dhɛ 'i yi ꞊klang kë ‑më ‑wɔn ꞊në‑ 'ka?» 'Yö 'wo‑ ‑kë Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","꞊Dhɛ 'ö 'mɛ bha ꞊ya ziö ꞊ya 'dho, 'yö Yesu ‑ya ma 'pö ꞊dhɛ ꞊waa‑ \"piʋ̈ kë Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ 'gü. ꞊Dhɛ 'ö ‑kpan ‑bha ‑dhɛ 'bha bha‑ 'gü, 'yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «I 'dhang ‑bho Mɛgbömɛ ‑wɔn \"dhiʋ̈ \"wɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «A‑ dɔ ‑zë wo 'nu kö a ‑dho 'dhang bho‑ \"dhiʋ̈ ‑dhe, n Dëmɛ! \"Kɛɛ ‑yö 'mɛ ‑zë wo?» ");
INSERT INTO daf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","'Yö Yesu ‑ya pö‑ ‑dhɛ: «'Bha ‑kpan ‑bha ꞊naa bha, ‑a ‑gɛn ‑mü ꞊dhɛ yö ꞊në kɛng 'ka \"wɩ sië bha.» ");
INSERT INTO daf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","'Yö‑ pö: «'Ma 'dhang bho‑ \"dhiʋ̈, n Dëmɛ!» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö zun‑ ‑dhɛ ö kpiö 'gü. ");
INSERT INTO daf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu ‑ya ‑pö ‑dhɛ yö ꞊në‑ 'gü 'ö‑ pö: «Nu 'a‑ wo \"kpʋng ꞊taa bha a ‑nu kö 'a 'wɔnbhokota ꞊në‑ kë kö 'mɛ 'waa ‑dhɛ yö tongtongdhö ‑wo ‑dhɛ yö, kö 'mɛ 'wo‑ pö wo ‑dɩ ‑dhɛ wo ‑dhɛ yö bha 'wa 'dho ‑dhɛ 'bha yö, kö‑ ‑nu \"yan ‑yö 'wü.» ");
INSERT INTO daf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'ö Fadhiziɛn ‑nu 'bha ‑nu 'wo gun‑ ꞊keng‑ mü bha ꞊waa‑ ma, 'yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «꞊Ya kë \"dhʋ̈ kö 'mɛ 'yi ya 'pö yi \"yan‑ ꞊wlü 'ka ꞊naa bha ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «꞊Ya kë 'nu ꞊dhɛ ka ka ‑dɩ ‑sü ꞊dhɛ \"yanwlümɛ 'dhö kö 'bɔn 'yaa ka ‑bha, \"kɛɛ ka‑ ‑pö ka ‑dɩ ‑dhɛ ꞊dhɛ ka ‑dhɛ ‑yö; 'wɔn 'ö‑ ‑wɔn 'gü 'yö 'bɔn 'yii 'dho 'go ka ‑bha tongtongdhö bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","'Yö Yesu ‑yö \"gwënng do ‑da ‑a ‑nu ‑dhɛ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ mɛ \"ʋʋ mɛ 'ö 'yii bɔ \"bhlaa wlɛɛ \"dhi 'ka kö ‑yö ‑da 'gü, \"kɛɛ 'ö bɔ zian \"wɛɛ 'ka, kö 'mɛ bha ꞊kwaanmɛ \"ɛɛn pëgüseemɛ ‑mü. ");
INSERT INTO daf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","\"Kɛɛ 'mɛ 'ö bɔ \"bhlaa wlɛɛ \"dhi 'ka 'ö ‑da 'gü bha kö yö ꞊në \"bhlaa bha‑ ‑maakëmɛ 'ö‑ ‑mɛ ꞊dede 'ka ‑a 'ka. ");
INSERT INTO daf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","\"Bhlaa wlɛɛ \"dhiʋ̈mɛ ‑zë ‑yö wlɛɛ \"dhi \"pʋ ꞊në‑ wo 'yö ‑tuʋ̈ dëmɛ 'ö ö ‑bha ‑tuʋ̈ ‑nu ‑dhɛ, 'yö 'wo‑ ‑wʋ ma. Yö ‑zë ‑yö ö ‑bha \"bhlaa ‑nu bha‑ ‑nu ‑sü 'tɔ 'ka 'do 'do 'yö‑ ‑nu ‑dhɛ, 'yö dho‑ ‑nu 'ka \"kpɛnng. ");
INSERT INTO daf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","꞊Ya bo ö ‑dɩ ‑bha ‑tuʋ̈ ‑nu bha‑ ‑nu ‑zun \"kpɛnng ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö ‑da ‑nu ‑dhɛ \"dhiʋ̈ 'yö 'wo ‑ziö ꞊keng‑, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ ‑wa ‑wʋ ‑dɔ. ");
INSERT INTO daf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","'Mɛ 'wo mɛ \"wɛɛ 'ka ‑a ‑bha ‑tuʋ̈ ‑nu bha ‑wo ‑dho ꞊dua ꞊në‑ wo‑ ‑nu ‑gɔ, 'wii 'dho ziö‑ ‑nu ꞊keng‑, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ 'waa‑ ‑nu ‑wʋ dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","\"Gwënng bha Yesu ‑ya ‑da ‑a ‑nu ‑dhɛ \"dhʋ̈ \"kɛɛ 'wii‑ 'klɔɔ‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","'Yö‑ 'klɔɔ‑ pö 'zü‑ ‑nu ‑dhɛ ‑deewo 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: Ma ꞊në 'a ꞊dhɛ ‑tuʋ̈ wlɛɛ \"dhiʋ̈ \"kwɛɛ ‑yaan 'dhö; ");
INSERT INTO daf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","‑a ‑gɛn ‑mü ꞊dhɛ mɛ \"pɛpɛ 'wo gun wo ‑dɩ kë sië ‑tuʋ̈ ‑mɛ 'ka 'wo nu bha, ‑tuʋ̈ ‑nu 'wii wo \"tʋ 'to‑ 'bha ‑wʋ ‑bha. ‑A ‑gɛn ‑mü ꞊dhɛ ꞊kwaanmɛ ‑nu waa‑ pëgüseemɛ ‑nu ꞊në gun wo ‑zë ‑a ‑nu 'ka. ");
INSERT INTO daf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ma ꞊në 'a ꞊dhɛ ‑tuʋ̈ wlɛɛ \"dhi 'dhö. 'Mɛ 'ö bɔ n ‑ta 'ö ‑da wlɛɛ 'gü, ‑yö ‑dho dha, ‑yö ‑dho ꞊mɔɔ‑ ‑bha 'ö ‑da 'kɔɔdhö 'ö zun \"kpɛnng, (‑a ‑gɛn ‑mü ꞊dhɛ kö ‑yö ꞊dhɛ mɛ 'dhö mɛ ‑dɩ ‑gɔ 'kɔɔdhö). ꞊Ya 'go mü 'zü ‑yö ‑dho ö ‑bhöpë ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","꞊Kwaanmɛ ‑zë ‑yö ‑nu kö 'ö ꞊kwaan ꞊në‑ bho kö 'ö ‑tuʋ̈ ‑nu zë ‑nu wo kö 'ö‑ ‑nu 'gü see‑, \"kɛɛ ma ‑zë a ‑nu kö 'a‑ ‑nu ‑maa ꞊në‑ kë kö ꞊sii ‑yö kë‑ ‑nu ‑dhɛ kö ‑wo ‑ya ‑a \"yi ꞊bhaa. ");
INSERT INTO daf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ma ꞊në 'a ‑tuʋ̈ ‑maakëmɛ ꞊dede 'ö ‑tuʋ̈mɛ 'ka ‑a 'ka. ‑A ‑gɛn ‑mü ꞊dhɛ \"bhlaa ‑tuʋ̈ ‑maakëmɛ ꞊dede ꞊në ꞊mɔɔ‑ ‑bha 'ö ö ‑bha ‑tosɛa ꞊gbaɔ ö ‑bha ‑tuʋ̈ ‑nu ‑wɔn 'gü; ");
INSERT INTO daf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","\"kɛɛ 'mɛ 'kö yö ‑zë 'wo‑ ꞊saa ꞊në‑ bho, 'ö 'yaa ‑tuʋ̈mɛ 'ka, \"ɛɛn 'ö 'yaa ‑tuʋ̈ ‑maakëmɛ ‑së 'ka, ꞊ya laa yö kö ‑yö nu sië ‑tuʋ̈ 'kun ‑dhɛ 'gü, ‑yö ö kwaa‑ ꞊në‑ wo‑ ‑nu zü 'ö ‑ziö ‑bɛang 'ka, 'yö laa ‑ya nu zë, 'yö‑ ‑nu ‑pɛn 'yö 'wo dɔ 'do 'do. ");
INSERT INTO daf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","꞊Naɔmɔɔmɛ ‑zë ‑ziö ‑bɛang 'ka ‑gɛn ‑mü ꞊dhɛ yö ‑zë ꞊naɔmɔɔmɛ ꞊në ‑mü ‑a 'ka, ‑tuʋ̈ ‑nu ‑wɔn 'yaa‑ ‑gɔ ‑dhɛ ‑tuʋ̈mɛ ꞊dede 'dhö, \"kɛɛ ma ‑zë ‑tuʋ̈ ‑maakëmɛ ‑së ꞊dede 'ö‑ 'ka yö ‑mü n 'ka. ");
INSERT INTO daf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","A ma ‑tuʋ̈ ‑nu ‑dɔ, woo ‑dɩ 'pö 'wo n dɔ. ");
INSERT INTO daf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","꞊Dhɛ ‑kɔ 'ö n Dë ‑yö n dɔ‑ 'ka 'ö mang ‑dɩ 'pö 'a‑ dɔ‑ bha‑ 'dhö. Yö ꞊në‑ ‑wɔn 'gü 'yö 'a ma ‑tosɛa nu ma ‑tuʋ̈ ‑nu ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","‑Tuʋ̈ ‑nu 'wo \"dhʋ̈ bha‑ ‑kpɛa 'yaa kë ꞊ni, ‑a 'bha ‑nu ‑wo ‑dhö 'ö 'waa wlɛɛ ya‑ 'gü. ‑A 'dhɛ 'wo \"dhʋ̈ bha \"fɔn kö 'a nu‑ ‑nu 'ka wlɛɛ ya‑ 'gü 'pö. A ‑dho ‑a ‑nu ‑dhɛ 'wo n ‑wʋ ma, 'ö 'wo nu 'ö ‑tuʋ̈ kpö ‑yö to do, 'ö‑ ‑gɔdhiʋ̈mɛ ‑yö ‑kë do 'pö. ");
INSERT INTO daf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","N ‑dhɔ ‑yö n Dë ‑kë, ‑a ‑gɛn ‑mü ꞊dhɛ a ma ‑tosɛa ‑nu \"dhʋ̈ kö 'a‑ 'sü ‑deewo. ");
INSERT INTO daf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mɛ 'bha ‑kɔ 'yii ziö n ‑gɔ, a‑ ‑nu n ‑dɩ ꞊nii ꞊në‑ ‑bha. ‑A ‑gɛn ‑mü ꞊dhɛ ‑a nu \"sɩ ‑yö n ‑dhɛ, ‑a 'sü \"sɩ ‑yö n ‑dhɛ. 'Wɔn 'ö n Dë ‑ya ‑ya n ꞊kwɛɛ‑ kö 'a‑ kë 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","‑Wʋ 'ö Yesu ‑ya pö \"dhʋ̈ bha 'yö 'gügblüdhe ‑dee 'bha ‑da 'zü Zuifö ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","'Yö mɛ kpö 'kpii‑ 'bha ‑wa pö: «'Mɛ bha ‑tamamɛ ‑mü!» \"ɛɛn: «Slaa\" ꞊në ꞊ya ‑da 'gü, 'ka 'dho ka \"tʋ 'to‑ ‑wʋ ‑bha!» ");
INSERT INTO daf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","\"Kɛɛ kö mɛ 'bha ‑nu ‑zë ‑wa pö sië 'pö ꞊dhɛ: «‑Tamamɛ \"ɛɛn slaamɛ ‑zë \"wɩ ‑kɔ 'yaa kë \"dhʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ \"yina yaa ‑zë 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö \"yanwlümɛ \"yan \"dhiʋ̈ \"pʋ.» ");
INSERT INTO daf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","'Wɔn bha ‑yö ‑kë \"dhʋ̈ \"nɛnɛ ziö \"tʋ̈ng 'gü kö Zuifö ‑nu ‑bha \"saa‑ ‑bho Atanna ‑dhɛ ‑dhɛ 'wo‑ ‑pë ‑kë yi 'bha 'ka bha ‑wa ‑kwɛ ‑zun 'ko \"dhiʋ̈ troo kë sië Zedhizadhɛmö. ");
INSERT INTO daf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kö Yesu ‑yö ꞊nië sië Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ \"kwɛɛdhɛ 'wo‑ ‑dhɛ Sadhomɔ ‑bha \"kwɛɛdhɛ bha‑ 'gü, ");
INSERT INTO daf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","'yö Zuifö ‑nu 'wo nu 'wo bho 'ko ‑ta ‑a ‑dhɛ 'gü mü 'wo‑ pö‑ ‑dhɛ: «'Ya dɔ ꞊tɔn 'kën 'gü i ‑wɔn 'gü \"gbɩɩ‑ ‑wa, i ‑dho yi bho‑ 'gü ‑më yi ꞊në‑ 'ka? 'Ö ꞊ya kë ꞊dhɛ bhi ꞊në 'i Atanna ‑bha ‑Yamɛ 'ö‑ nu ‑wɔn 'dhö 'dhö bha‑ 'ka tɛan‑ 'ka, ‑bhö ‑a pö yi ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Ma‑ pö ‑zë wo ka ‑dhɛ 'nu ‑wa, 'dhang ꞊në 'kaa‑ bho n \"dhiʋ̈. \"Kɛɛ 'sa kö 'wɔn ‑nu 'a‑ ‑kë n Dë ‑bha 'gügbɩɩdhɛ ‑kɔ 'ka bha ‑wa ‑zɔn ꞊dhɛ ma ꞊në 'a Atanna ‑bha ‑Yamɛ bha‑ 'ka \"dhʋ̈ tɛan‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","\"Kɛɛ 'dhang 'ö 'kaa‑ bho n \"dhiʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ 'kaa ma \"bhlaa ‑tuʋ̈ kpö 'gü ‑mɛ ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ ma ‑tuʋ̈ kpö 'gü ‑mɛ ‑nu ‑zë ‑wo wo \"tʋ ‑to n ‑wʋ ‑bha, 'ö 'a‑ ‑nu dɔ, 'ö 'wo ‑ziö n ꞊keng‑ 'pö, ");
INSERT INTO daf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'yö 'a ꞊sii 'ö 'yaa yën‑ ‑da ‑nu 'gü. ‑A ‑wɔn 'gü 'wii 'dho ga tongtongdhö, 'yö pë 'bha ‑pë 'bha ‑kɔ 'yii 'dho ꞊mɔɔ‑ ‑bha 'pö kö ‑ya ‑nu bho n ꞊kwɛɛ‑. ");
INSERT INTO daf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","‑A ‑gɛn ‑mü ꞊dhɛ n Dë 'ö‑ ‑nu nu n ‑dhɛ bha‑ 'gü ‑yö \"gbɩɩ‑ 'ö ‑ziö pë ꞊gban \"pɛpɛ ‑ta. 'Wɔn 'ö‑ ‑wɔn 'gü 'yö mɛ 'bha ‑kɔ 'yaa ꞊mɔɔ‑ ‑bha 'pö kö ‑ya ‑nu 'sü n Dë ‑gɔ bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'Sa yaa‑ n Dë ‑zë yi do.» ");
INSERT INTO daf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","꞊Dhɛ 'ö Yesu ‑ya pö \"dhʋ̈ bhoo, 'yö Zuifö ‑nu ‑gɔmɛ ‑nu bha 'wo ‑kɔ ‑da 'zü ‑deewo ‑gwë 'gü kö 'wo‑ ‑zuö 'ka. ");
INSERT INTO daf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","'Yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «'Wɔn ‑sɛngbɔ ‑nu 'gbɛ 'ö go n Dë \"piʋ̈ 'a‑ ‑kë 'ö ka \"yan‑ ‑da 'gü ya‑ ‑mɛɛ ꞊në kaa n zë ‑gwë 'ka‑ ‑wɔn 'gü ya?» ");
INSERT INTO daf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","'Yö ‑gɔmɛ ‑nu bha 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Bhi 'ö 'i ‑kë mɛbhɩɩdhe 'ka ꞊dhɛ yi 'dhö ‑a pö 'i‑ wo ꞊dhɛ kaa‑ Atanna ka do bha ꞊në‑ ‑wɔn 'gü 'yö 'yi‑ \"piʋ̈ ꞊dhɛ 'yi i zë, ‑a ‑gɛn ‑mü ꞊dhɛ 'bha‑ pö \"dhʋ̈ kö 'bha ‑da Atanna \"dhiʋ̈. ‑A ‑gɛn 'yaa ‑mü 'wɔn ‑së ‑nu 'kö 'i‑ ‑kë bha‑ 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'zü 'ö‑ pö: «'Yaa ‑bɛn zë ‑sü 'ka ka ‑gɔ 'tɔng‑ 'sëëdhɛ 'gü ꞊dhɛ: ‹Atanna ‑ya ‑pö ꞊dhɛ: Ka ꞊dhɛ ‑zlan ‑nu 'dhö› ‑ee? \"Ɛɛn 'yaa \"dhʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","'Sa kö 'wɔn 'kö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'sëëdhɛ 'gü 'yaa bho \"gblʋʋ tongtongdhö. ꞊Ya kë \"dhʋ̈, \"sanni 'mɛ 'kö Atanna 'dhö ö ‑wʋ ꞊në‑ nu‑ ‑nu ‑dhɛ ‑ya ‑nu ‑dhɛ ‑zlan ‑nu bha ‑oo, ");
INSERT INTO daf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'yö ma 'kö n ‑ya, 'ö n sü 'ö n bɔ \"kpʋng ꞊taa ꞊wɛ? Ka ‑mɔɔ ‑bha 'ka‑ pö n ‑bha ꞊dhɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ 'ma‑ pö n Dë ‑mü Atanna 'ka bha ꞊ya kë \"dhʋ̈ kö 'ma ‑da \"dhiʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","꞊Ya kë ꞊dhɛ 'mii n Dë këwɔn kë, 'ka 'dho 'dhang bho n \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","\"Kɛɛ 'ö ꞊ya kë ‑zë wo ꞊dhɛ a n Dë këwɔn ꞊në‑ ‑kë, 'kö 'kii 'dhang bho ma ‑zë n \"dhiʋ̈, \"kɛɛ ‑ka 'dhang bho 'wɔn ‑nu 'kö 'wo kë sië bha‑ ‑nu \"dhiʋ̈ kö 'ka‑ 'gü ma kö 'ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ n Dë ‑mü Atanna 'ka, yɛng yi do.» ");
INSERT INTO daf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","‑A pö 'ö‑ wo \"dhʋ̈ bha 'yö 'wo ‑ya 'kun ‑yan ‑ta, \"kɛɛ 'yö dha‑ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","꞊Dhɛ 'ö dha‑ ‑nu ‑gɔ \"dhʋ̈, 'yö dho ꞊gwaan 'wo‑ Zuudɛn ‑kë bha‑ ꞊taama, ‑dhɛ 'ö Zan gun mɛ \"zu sië mü bha‑ 'gü 'yö ö \"tɛɛ pa mü. ");
INSERT INTO daf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mɛ kpö ‑wo ‑gun nu sië‑ ‑dhɛ 'gü ‑dhɛ bha‑ 'gü 'wo‑ pö: «Zan 'yii \"dhabhliwɔn \"wɛɛ 'bha kë, \"kɛɛ 'ö dhiang \"pɛpɛ 'ö‑ zë 'mɛ 'ö ya‑ ‑bu 'gü ‑a ꞊gban ‑gun tɛan‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","'Yö mɛ 'gbɛ 'wo ‑wɩ Yesu ‑wɔn ‑bha ‑dhɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Gɔndënë do 'bha 'wo‑ ‑dhɛ Dhazaa bha‑ 'gü 'yaa gun ‑së. Dhazaa bha ‑yö ‑go Betani, 'pödhɛ 'ö Madhi waa‑ ö dheebhang Matö 'wo go‑ 'gü bha‑ 'gü. Madhi bha ꞊në kë ‑dhasiklɔɔ \"yi ꞊fii ‑së ꞊wɛnng Yesu ‑gɛn ‑ta 'yö ö ‑gɔ \"dhɛ ‑ziö ‑bha \"tʋ̈ng 'bha 'gü bha. ");
INSERT INTO daf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","'Yö dheebhang ‑zë ‑nu ꞊plɛ bha 'wo mɛ bɔ Yesu ‑dhɛ kö ‑wa pö‑ ‑dhɛ ‑a \"taɔngdë Dhazaa 'gü 'yaa ‑së. ");
INSERT INTO daf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","꞊Dhɛ 'ö Yesu ꞊ya 'wɔn bha‑ ma 'yö‑ pö: «\"Yua 'ö Dhazaa kë sië bha 'yii 'dho 'to‑ ‑gɔ. ‑Yö ‑kë \"dhʋ̈ kö Atanna 'tɔ‑ bhɔ, kö ‑yö Atanna Gbö ‑dɩ 'pö‑ 'tɔ bhɔ.» ");
INSERT INTO daf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","꞊Dhɛ 'ö‑ ma ꞊dhɛ Dhazaa 'gü 'yaa ‑së, 'yö ‑dhɛkpaɔyi ꞊plɛ ‑kë ‑dhɛ 'ö gun‑ 'gü bha‑ 'gü ‑deewo. \"Kɛɛ 'sa kö Dhazaa 'dhö, ‑a dheebhang ‑nu 'ö‑ mɛ do ‑kë Matö 'ka, 'ö‑ mɛ do ‑kë Madhi 'ka bha‑ ‑nu ‑wɔn ‑gun ‑gɔ \"gbɩɩ‑. ");
INSERT INTO daf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","꞊Dhɛ 'ö ꞊ya ‑dhɛkpaɔyi ꞊plɛ bha‑ kë \"dhʋ̈, 'yö gun ‑na ‑a pö ö ‑bha ꞊klang ‑nu ‑dhɛ: «‑Ka ‑kwa kwa yee kë 'kwa 'dho Zude ‑sɛ 'gü!» ");
INSERT INTO daf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","'Yö‑ ‑bha ꞊klang ‑nu 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, ‑dhɛ 'ö Zuifö ‑nu gun‑ \"piʋ̈ ꞊dhɛ 'wo i zë‑ ‑bha ꞊dede ya‑ 'gü bha 'yö i \"piʋ̈ 'zü ꞊dhɛ 'i 'dho mü bha ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","'Yö‑ pö‑ ‑nu ‑dhɛ: «\"Tʋ̈ng 'ö ‑dhɛkpaɔyi do 'gü ‑yö ꞊dhɛ? 'Yaa ‑kaɔng do ga ꞊plɛ ‑ee? 'Mɛ 'ö \"ta sü 'yënng‑ 'gü ‑a ‑mɛ ‑gɛn \"dhiʋ̈ 'yaa ‑zuö, ‑a ‑gɛn ‑mü ꞊dhɛ kö‑ ‑mɛ ‑yö ‑dhɛ ‑yö ‑dhɛpuudhɛ 'ö \"kpʋng ꞊taa yö bha‑ 'bhü \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","\"Kɛɛ 'mɛ 'ö \"ta sü gbeng, ‑a ‑mɛ ꞊në \"ta sü 'tuu‑ 'tudhö, 'yö 'yaa ‑dhɛ yö, ‑a ‑gɛn ‑mü ꞊dhɛ kö ‑dhɛpuudhɛ 'yaa‑ ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","꞊Dhɛ 'ö ꞊yaa‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈ 'yö go mü 'ö‑ pö: «Kwa \"taɔngdë Dhazaa ꞊ya yi zë, \"kɛɛ a ‑dho 'dho 'a pa‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","'Yö‑ ‑bha ꞊klang ‑nu 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, ꞊dhɛ 'kö ꞊ya yi ‑zë zë kö ‑yö ‑dho kë \"klʋ̈ʋ̈klʋ̈ 'sa ‑dhe!» ");
INSERT INTO daf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","‑A pö 'ö Yesu ‑ya wo \"dhʋ̈ bha 'wii‑ 'gü ma. ‑Yö ‑kë ‑nu 'gü ꞊dhɛ Dhazaa ‑yö yi ꞊dede ꞊në zë 'yö‑ pö \"dhʋ̈ bha, \"kɛɛ kö ‑ya ga ‑wɔn ꞊në‑ pö. ");
INSERT INTO daf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'Yö‑ ‑ta ‑pʋ ‑nu ‑dhɛ 'ö‑ pö: «Dhazaa ꞊ya ga. ");
INSERT INTO daf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","\"Kɛɛ ga 'ö‑ wo kö 'maa mü bha ‑yö ‑dhi n ‑dhɛ ka ꞊në ka ‑bu 'gü, kë \"dhʋ̈ kö 'ka 'dhang bho n \"dhiʋ̈ 'kpakpadhö. ꞊Dhɛ 'ö \"dhʋ̈ ‑ka ‑kwa 'dho zun‑ ‑dhɛ 'gü!» ");
INSERT INTO daf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","꞊Dhɛ 'ö‑ pö \"dhʋ̈, ‑a ‑bha ꞊klangdhiʋ̈ 'dhɛ 'wo‑ ‑dhɛ Toma 'wo‑ 'tɔ ‑ya ‑ta ‑dhɛ 'peng‑ bha 'yö‑ pö: «꞊Dhɛ 'ö \"dhʋ̈ kö mɛ ꞊gban ‑ka ‑kwa 'dho kö 'wo dho kwa Dëmɛ zë ‑dhɛ 'ö‑ 'gü kö ‑wo mɛ ꞊gban kwa zë mü do!» ");
INSERT INTO daf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","꞊Dhɛ 'ö Yesu ‑yö dho 'ö ꞊loo mü, kö 'wo Dhazaa ‑wɛɛ bho ‑a ‑dhɛkpaɔyi ꞊ya kë ‑yiisiö. ");
INSERT INTO daf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","'Ö gun \"dhʋ̈ kö Betani ‑dhɛ kë 'ö‑ wo Zedhizadhɛmö ‑dhɛ \"sɔɔ, 'ö‑ ‑nu ꞊zinng 'gü ‑dhɛ 'yaa ꞊mɔɔ \"kidhʋng ‑yaaga ‑zian ‑bha bha, ");
INSERT INTO daf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","'kö Zuifö ‑nu kpö 'gbɛ ꞊wa 'go Zedhizadhɛmö ꞊wa nu Matö waa‑ Madhi ‑a ‑nu sɛɛgbengbha bho ‑dhɛ 'gü ‑a ‑nu dheebhang 'ö ga bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","꞊Dhɛ 'ö Matö ꞊yaa‑ ma ꞊dhɛ Yesu ‑yö nu sië, 'yö dho dɔ‑ ‑gɔ zian‑, 'yö Madhi ‑zë 'ö to 'yaanu ‑sü 'ka 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","꞊Dhɛ 'ö Matö 'dhö 'ö \"yan ‑kpan Yesu ‑bha 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ, bhi ‑zë i ‑kë yö 'nu kö n dheebhang ya 'yii 'dho ga, ");
INSERT INTO daf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","\"kɛɛ a‑ 'wɔn ‑dɔ ꞊dhɛ dɔ ‑zian 'kwa‑ wo ya pë \"ʋʋ pë i‑ ‑gbadhɛ Atanna ‑gɔ ‑yö ‑dho ‑a kë i ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Matö, i dheebhang bha ‑yö ‑dho ‑bö!» ");
INSERT INTO daf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","'Yö Matö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «꞊Iin, n Dëmɛ, ‑yö \"dhʋ̈, a‑ 'wɔn ‑dɔ ꞊dhɛ ‑yö ‑dho ‑bö mɛ ꞊gban ‑go ga 'gü ‑yi 'ka \"sɛ yën \"tʋ̈ng 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","'Yö Yesu ‑ya pö: «Matö, ꞊waa‑ pö gamɛ ‑nu ‑bö ‑mɛ, kö ‑wo ‑wɩ ma ꞊në n 'ka, ꞊waa‑ pö ꞊sii, kö ‑wo ‑wɩ ma ꞊në‑ 'ka. 'Mɛ 'ö 'dhang bho n \"dhiʋ̈, aa\" ꞊ni ꞊ya ga, ‑yö ‑dho ‑tosɛa kë. ");
INSERT INTO daf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","'Sa kö mɛ \"ʋʋ mɛ 'ö ‑yö 'dhang bho n \"dhiʋ̈ kö ‑yö ö \"yaan, kö‑ ‑mɛ ‑yö ꞊sii 'kö bha‑ ꞊slɔɔ, 'yii 'dho ga 'zü tongtongdhö. I 'dhang ‑bho \"dhiʋ̈ \"dhʋ̈ \"wɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","'Yö Matö ‑ya pö: «꞊Iin, n Dëmɛ, a 'dhang ‑bho \"dhiʋ̈ ꞊dhɛ Atanna ‑bha ‑Yamɛ, ‑a Gbö 'ö‑ nu ‑wɔn 'dhö 'dhö \"kpʋng ꞊taa bha yö ‑mü i 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","꞊Dhɛ 'ö Matö ꞊yaa‑ pö \"dhʋ̈, 'yö Madhi ‑dhɛ ꞊plɛ 'gü 'yö‑ pö‑ ‑dhɛ: «Madhi, kwa Dëmɛ ꞊ya nu, ‑ya ‑pö 'i nu.» ");
INSERT INTO daf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","꞊Dhɛ 'ö Madhi 'dhö‑ ma ꞊dhɛ Yesu ꞊ya nu, 'yö ꞊wlü 'zodhö 'yö dho mü. ");
INSERT INTO daf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","‑A ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö 'yii ‑da ꞊kö 'plöö, kö ‑yö ‑tun 'pö‑ \"saan \"dhiʋ̈, ‑dhɛ 'ö Matö 'dhö ‑kpan ‑bha ‑a 'gü bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","꞊Dhɛ 'ö Madhi ꞊ya \"wlü 'vadhö \"dhʋ̈ 'ö ꞊ya zun \"kpɛnng, 'yö Zuifö ‑nu 'wo gun‑ \"piʋ̈ 'kɔɔdhö 'mü 'wo gun‑ ‑taga sië bha 'wo ‑ziö ꞊keng‑ kö ‑wa pö sië: «‑Kë ꞊dhɛ ‑yö 'dho sië ö dheebhang bun ꞊taa ꞊naa bha kö yö \"gbʋ 'bha bɔ 'mü.» ");
INSERT INTO daf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","꞊Dhɛ 'ö Madhi ꞊ya 'dho ꞊ya ꞊loo ‑dhɛ 'ö Yesu‑ gun‑ ‑bha bha‑ 'gü 'ö ꞊yaa‑ yö, 'yö zun ö kpiö 'gü 'yö \"gblëënu‑ ꞊wlöö 'yö‑ pö: «N Dëmɛ, ꞊ya kë ꞊dhɛ i kë yö 'nu‑ zü bho ‑yi 'ka kö n dheebhang ya 'yii 'dho ga!» ");
INSERT INTO daf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","꞊Dhɛ 'ö Yesu 'dhö Madhi yö kö ‑yö \"gbʋ bɔ sië waa‑ Zuifö ‑nu 'wo nu‑ ꞊keng‑ bha‑ 'dhö, 'yö ‑wëë ‑yö bɔ‑ ‑ta ꞊dedewo, 'yö‑ \"gblʋ̈ʋ̈dhɛ ‑yö \"muu bho, ");
INSERT INTO daf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","'yö‑ ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «Ka‑ ‑wɔ 'mɛ?» 'Yö 'wo‑ pö‑ ‑dhɛ: «Yi Dëmɛ, nu kö 'kwa 'dho kö 'yi‑ ‑dhɛ ‑zɔn i ‑dhɛ!» ");
INSERT INTO daf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","'Yö Yesu ‑yö ‑da \"gbʋ 'gü 'pö. ");
INSERT INTO daf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","꞊Dhɛ 'ö Zuifö ‑nu 'wo Yesu \"gbʋbɔdhɛ yö 'yö 'wo‑ pö: «‑A ‑dhɔ ‑zë ‑gun kë sië ꞊zɔɔ ‑kɛɛ!» ");
INSERT INTO daf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kö mɛ ga 'bha ‑nu ‑dɩ 'pö ‑wa pö sië: «Yö 'ö \"yanwlümɛ \"yan \"dhiʋ̈ ‑pʋ bha 'yaa ꞊mɔɔ 'nu‑ ‑bha 'ö \"slë 'bha ‑kë 'ö Dhazaa ‑yö dha \"yua ya‑ ‑gɔ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","'Yö ‑wëë ‑dee 'bha ‑yö bɔ 'zü Yesu ‑ta, 'yö dho Dhazaa bun ‑ta ‑dhɛ ꞊dede 'gü. ‑Yɛ 'wo‑ pɔn ‑tɔn 'gü ꞊në gun‑ 'ka, 'yö 'wo ‑gwë zun‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","꞊Dhɛ 'ö ꞊loo ‑yɛ bha‑ \"dhi \"dhiʋ̈ 'yö‑ pö: «‑Ka ‑gwë bha‑ bho mü!» 'Yö Matö 'ö ‑kë mɛ 'ö ga bha‑ dheebhang 'ka bha 'ö‑ pö‑ ‑dhɛ: «N Dëmɛ, 'mɛ bha‑ \"gbiën ꞊ya dɔ ꞊zɔɔ ‑wa!» 'Mɛ 'wo‑ ‑wɛɛ bho 'ö‑ ‑dhɛkpaɔyi ‑yiisiö ‑naa ꞊nɛ aa!» ");
INSERT INTO daf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Matö, 'mii‑ pö i ‑dhɛ ꞊dhɛ 'bha 'dhang bho n \"dhiʋ̈, i ‑dho Atanna ‑bha 'gügbɩɩdhɛ ‑dhɛ yö ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö 'wo ‑gwë bha‑ bho 'mü, 'yö Yesu ‑yö ö \"yan \"dhiʋ̈ ꞊wlü dhang‑ 'gü 'yö‑ pö: «N Dë, 'ma i nuɛ\" bho bhɛa\" 'a‑ wo i ‑dhɛ 'i‑ ‑slëëta ‑kë bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ma ‑zë a‑ 'wɔn ‑dɔ ꞊dhɛ i \"tʋ ‑yö n bhɛa\" ‑wʋ ‑bha yi ꞊gban 'ka 'ö 'i‑ ‑slëëta ‑kë ‑kpɛawo, \"kɛɛ a‑ ‑pö \"dhʋ̈ mɛ kpö 'wo ‑klëën n ‑zü ya ꞊në‑ ‑nu ‑wɔn 'gü, kë \"dhʋ̈ kö ‑wa 'wɔn dɔ ꞊dhɛ bhi ꞊në 'i n bɔ.» ");
INSERT INTO daf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'ö ꞊ya ö bo, 'yö ꞊gbla \"gbɩɩ‑ 'ka 'ö‑ pö: «Dhazaa, ‑bhö zun \"kpɛnng!» ");
INSERT INTO daf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","'Yö 'mɛ 'ö ꞊ya ga 'nu 'ö‑ yi ꞊ya ꞊gwëë bha 'ö zun \"kpɛnng kö sɔ \"pɛn ‑yö piʋ̈‑ ‑sü 'ka‑ ‑kɔ waa‑ ‑gɛn ‑nu 'ka, kö sɔ 'bha ‑yö bɔ ‑sü 'ka‑ ‑gɔ ‑bha mlɔngdhö. 'Yö Yesu ‑ya pö 'mɛ 'wo gun mü bha‑ ‑nu ‑dhɛ: «‑Ka sɔ bha‑ bho‑ ‑bha kö 'ka ka kwaa‑ ‑zü kö ‑yö 'dho!» ");
INSERT INTO daf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Zuifö ‑nu 'wo nu Madhi ‑nu ‑dhɛaga ‑dhɛ 'gü 'wo 'wɔn bha‑ ‑dhɛ yö bha‑ mɛ 'gbɛ 'wo 'dhang bho Yesu \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","\"Kɛɛ 'yö‑ mɛ ga 'bha 'wo dho 'wɔn 'ö Yesu ‑ya ‑kë bha‑ ‑gɛn dɔ ‑dhɛ 'gü Fadhiziɛn ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","꞊Dhɛ 'ö Fadhiziɛn ‑nu 'wo 'wɔn bha‑ ma, 'yö 'wo \"saabhomɛ ‑nu ‑gɔmɛ ‑nu ‑dhɛ, 'yö 'wo zagɔbhomɛ ‑nu ‑dhɛ 'yö 'wo bhokota ‑dhɛ do 'gü 'yö 'wo‑ pö: «'Wɔn ya kwa ‑dho ‑a 'kun ‑kɔ kë ꞊dhɛ? Mɛ 'ö ya ‑yö \"dhabhliwɔn ‑nu kë sië \"gbɩɩ‑ \"dhɛ! ");
INSERT INTO daf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","꞊Ya kë ꞊dhɛ 'kwa kwa kwaa‑ ‑zü kö ‑ya kë \"dhʋ̈ ‑yö 'dho‑ 'ka ‑kpɛawo mɛ ꞊gban \"pɛpɛ ‑dho 'dhang bho‑ \"dhiʋ̈. 'Sa ꞊ya kë \"dhʋ̈ kö Wlɔmö mɛ ‑nu ‑bha \"sɛgɔdhiʋ̈mɛ ‑nu woo nu kö ‑wo kwaa‑ \"sɛ wü waa‑ kwaa‑ Atanna ‑dhɔkëgükɔ 'dhö!» ");
INSERT INTO daf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈ 'yö gɔndënë do 'ö gun‑ ‑nu kpö 'gü mü 'wo‑ ‑dhɛ Kaifö, 'ö gun \"saabhomɛ ‑nu bha‑ ‑nu bha mɛ 'kpii‑ ‑sü 'ka ‑kwɛ bha‑ ‑ta bha 'ö‑ pö: «'Kaa 'wɔn bha‑ 'gü ma!» ");
INSERT INTO daf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","'Yaa ka 'gü ꞊dhɛ mɛ do ‑bha ga ‑sü 'ö \"sɛ 'gü ‑mɛ ‑nu ‑wɔn 'gü ‑a fië‑ ‑dhö 'ö ‑ziö \"sɛgümɛ ‑nu ꞊gban 'gü see‑ ‑sü ‑ta ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","\"Kɛɛ 'sa ‑a pö 'ö gun‑ wo sië \"dhʋ̈ bha 'yaa gun‑ ‑dɩ ꞊kwɛɛ‑ ‑wɔn 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö ‑gun \"dhʋ̈ kö yö ꞊në \"saabhomɛ ‑nu ‑gɔmɛ 'ka ‑kwɛ bha‑ ‑ta, \"kɛɛ kö ꞊ya bo‑ pö ‑sü 'ka Atanna ‑wʋ \"dhiʋ̈ ꞊loo ‑sü 'ka 'nu ꞊dhɛ Yesu ꞊në dho ga Zuifö ‑nu ‑wɔn 'gü, ");
INSERT INTO daf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","\"kɛɛ Zuifö ‑nu woo do 'waa ‑mü ‑zianwo, ‑yö ‑ga 'pö kö ‑yö Atanna ‑bha 'në ‑nu \"pɛpɛ 'wo ‑pɛn ‑sü 'ka \"kpʋngtaadhɛ ꞊gban \"pɛpɛ 'gü bha ꞊në waa‑ Zuifö ‑nu ‑a ‑nu ‑kɔ 'wü 'koo kö ‑wo kë mɛ do 'ka. ");
INSERT INTO daf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Zuifö ‑nu ‑gɔmɛ ‑nu ‑wʋ ‑yö ‑mɔɔ Yesu ‑zë ‑sü ‑bha 'yi bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yö ꞊në‑ ‑wɔn 'gü 'yö Yesu ‑yö ö bo ‑dho ‑a ‑nu kpö 'gü ‑sü 'ka, 'yö ö ‑bha 'dho wo \"sɛgɔ 'bha 'ö ‑ya ‑sü 'ka \"wlatadhɛ \"sɔɔ, \"kɛɛ ‑a 'pödhɛ 'dhɛ 'wo‑ ‑dhɛ Eflaimö bha‑ 'gü 'yö waa‑ ‑bha ꞊klang ‑nu 'wo wo \"tɛɛ 'bha pa mü. ");
INSERT INTO daf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","'Ö gun \"dhʋ̈ kö Zuifö ‑nu ‑bha troo 'wo‑ Pakö ‑kë bha ꞊ya ꞊tëng. Kö ꞊dhɛ 'ö ‑kë ꞊dhɛ Pakö yi 'yii ꞊loo ꞊kö bha mɛ 'gbɛ ‑wo 'dho sië Zedhizadhɛmö kö ‑wo wo kë \"slʋ̈ʋ̈slʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","'Ö gun \"dhʋ̈ 'pö kö ‑wo Yesu mɔɔ‑ sië. ꞊Dhɛ ('ö 'mɛ 'wo gun 'dho sië wo ‑kë \"slʋ̈ʋ̈slʋ̈ ‑dhɛ 'gü \"dhʋ̈ bha) 'wo wo 'ko yö Atanna ‑dhɔkëgükɔ 'ö Zedhizadhɛmö bha‑ 'gü, 'yö 'wo wo 'ko ‑nu dhɛɛ\" kpɔ 'wo‑ pö: «Ka ka ‑zʋ ‑gɔn ꞊dhɛ ‑yö ‑dho ö yee kë 'ö nu troo ya‑ ‑ta ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","\"Kɛɛ 'sa 'ö gun \"dhʋ̈ kö Fadhiziɛn ‑nu waa‑ \"saabhomɛ ‑nu ‑gɔmɛ ‑nu ꞊waa‑ pö ‑wa ‑dhɛa \"dhiʋ̈ bho \"sɛ 'gü ‑dhɛ ꞊gban \"pɛpɛ 'gü kö ‑wa pö ꞊dhɛ mɛ \"ʋʋ mɛ 'ö Yesu ‑dhɛ dɔ, ‑a mɛ ‑yö nu kö ‑ya pö wo ‑dhɛ kö 'wo mɛ bɔ‑ 'kun ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","'Ö gun kö ‑dhɛkpaɔyi ꞊ya 'to \"saɔdo kö Pakö yi ‑yö ꞊loo, 'yö Yesu ‑yö dho Betani, ‑dhɛ 'ö Dhazaa 'ö‑ ‑bö bha 'ö gun‑ ‑bha bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ꞊loo mü, 'yö 'wo‑ \"dhi ꞊mɔɔ. Dhazaa ‑yö ‑gun 'mɛ 'wo gun‑ \"piʋ̈ pë ‑bhö ‑dhɛ 'gü mü bha‑ ‑nu kpö 'gü, 'yö Matö ‑zë 'ö gun‑ ‑nu \"dhiʋ̈ ‑ziö wo sië. ");
INSERT INTO daf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","'Yö Madhi ‑yö ‑dhasiklɔɔ \"yi ꞊bhlëësü sɔng \"gbɩɩ‑ wo‑ ‑dhɛ 'naadhö, 'ö 'waa‑ kaan‑ suu \"wɛɛwɛɛ 'bha 'ka bha‑ sü, 'yö nu‑ ‑sangdhe ‑yan do 'ka, 'yö‑ ꞊wɛnng Yesu ‑gɛn ‑ta, 'yö ö ‑gɔ \"dhɛ ‑ziö ‑bha. 'Yö‑ ꞊fii ‑yö ꞊mɔɔ 'kɔ 'gü ‑dhɛ ꞊gban \"pɛpɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","\"Kɛɛ ꞊dhɛ 'ö ꞊yaa‑ kë \"dhʋ̈, 'yö Yesu ‑bha ꞊klang ‑nu bha‑ mɛ 'dhɛ 'wo‑ ‑dhɛ Zuda Isikadhiɔtö, 'ö yöö ‑da ‑dhɛ pë \"piʋ̈ bha 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«꞊Ya kë ꞊dhɛ ‑dhasiklɔɔ \"yi 'ö‑ sɔng ‑yö ꞊mɔɔ mɛ do ꞊saa 'ö ‑kwɛ do 'gü‑ ‑bha ya‑ \"dhɔɔ ꞊në 'kwa‑ dɔ 'nu 'ö 'kwa‑ 'wëë‑ ‑zë ꞊gbaɔ ‑wëëmɛ ‑nu ‑gɔ kö ꞊bhlëë 'yaa‑ ‑bha 'ö ‑ziö ‑a ꞊wɛnng 'wo‑ wo i ‑gɛn ‑ta bha‑ ‑ta ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","\"Kɛɛ kö ‑a pö 'ö‑ wo \"dhʋ̈ bha‑ ‑gɛn 'yii kë ꞊dhɛ ‑yö ‑ya ‑sü ꞊në‑ 'ka ‑wëëmɛ ‑nu zuën ‑ta \"gbɩɩ‑, \"kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ ‑yö ꞊kwaan ‑bho bha kë \"dhʋ̈ kö 'ö‑ ꞊kwaan; ‑a ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu ‑bha ‑naɔ ‑duɛ bho ‑sü ‑gun yö ꞊në‑ \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","\"Kɛɛ 'yö Yesu ‑ya pö‑ ‑dhɛ: «‑A 'to \"dhʋ̈ \"sɛnngdhö! ‑A ‑gɛn ‑mü ꞊dhɛ ‑dhasiklɔɔ \"yi 'ö dho‑ ꞊wɛnng 'nu n ꞊gee ‑bha n bun bho ‑yi 'ka bha ꞊në ꞊ya n 'to \"yaan ꞊yaa‑ ꞊wɛnng n ‑bha bha. ");
INSERT INTO daf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","‑Wëëmɛ ‑nu ‑zë ‑wo ka \"piʋ̈ \"kpʋngtaadhɛ ya‑ 'gü yi ꞊gban 'ka, \"kɛɛ ma ‑zë 'mii 'dho to ka \"piʋ̈ yö ‑kpɛawo ꞊dhɛ ‑a ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","꞊Dhɛ 'ö Zuifö ‑nu ꞊waa‑ ma ꞊dhɛ Yesu ‑yö Betani, 'yö 'wo wo kpö dɔ ‑yɛɛdhö 'wo dho mü. ‑Wo ‑dho \"dhʋ̈ kö 'wo \"yan ‑kpan ‑bha, \"kɛɛ kö 'wo wo \"yan ‑kpan 'pö Dhazaa 'ö‑ ‑bö bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","'Yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu 'wo‑ ‑yakwëë ‑kë, 'yö‑ ‑nu ‑wʋ ‑yö ‑kë ‑bha do ꞊dhɛ 'wo Dhazaa ‑dɩ 'pö‑ zë, ");
INSERT INTO daf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","‑a ‑gɛn ‑mü ꞊dhɛ kö Zuifö ‑nu 'gbɛ ‑wo 'go sië‑ ‑nu \"piʋ̈ 'wo bɔ Yesu 'ka ‑a ‑bö ‑wɔn ‑kë tɛan‑ 'ka ‑wɔn ꞊në‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya ꞊kpaɔ, 'ö mɛbhɩɩdhe kpö ‑ziisü 'wo nu troo ‑ta Zedhizadhɛmö bha ꞊waa‑ ma ꞊dhɛ Yesu ‑yö nu sië, ");
INSERT INTO daf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","'yö 'wo \"sɔɔndhɛ ‑nu ‑kan, 'yö 'wo dho dɔ‑ ‑gɔ zian‑, kö ‑wo \"gɛɛ kë sië ‑nu wo 'wo ‑bhabhoo kun 'wo‑ pö: «\"Sookwedhi! ‑Bha ‑bha ‑bha! \"Sookwedhi! Izraɛdhö ‑mɛ ‑nu ‑bha ‑gblüdë ‑yö nu sië! ‑Yö ‑nu kwa Dëmɛ ‑bha nu 'gü! \"Sookwedhi! Atanna 'tɔ‑ bhɔ!» ");
INSERT INTO daf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kö Yesu ‑yö ‑ya ‑sü 'ka ꞊soofëng \"gbɔng do 'ö ‑kpan ‑bha zian 'ka bha‑ ‑ta, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑gun ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'gü zii ‑be ꞊dhɛ: ");
INSERT INTO daf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«‑Ka ‑dhɛ ‑ga, Siɔn ‑mɛ ‑nu, 'ka 'dho \"suʋ̈ 'zü, kaa‑ ‑gblüdë ‑yö nu sië, ‑yö ‑ya ‑sü 'ka ꞊soofëng \"gbɔng do ‑ta.» ");
INSERT INTO daf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu ‑bha ꞊klang ‑nu 'wii 'wɔn bha‑ 'gü ma ‑a \"tʋ̈ng bha‑ 'gü, \"kɛɛ ꞊dhɛ 'ö ꞊ya bo 'dho ‑sü 'ka 'ö ‑ya ‑ya ö ‑bha ‑blüdëdhɛ ‑gbloo 'gü ö Dë \"sɔɔ dhang‑ 'gü, 'yö‑ ‑nu ‑zʋ ‑yö ‑bö ꞊dhɛ ‑yö ‑gun ‑bɛn zë ‑sü 'ka \"dhʋ̈ ‑a ‑bu 'gü tɛan‑ 'ka, yö ꞊në‑ ‑wɔn 'gü 'yö Zedhizadhɛmö ‑mɛ ‑nu 'wo‑ 'gü ‑wɔn ‑kë ꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka‑ 'ka ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mɛ \"pɛpɛ 'kö 'wo gun ‑dhɛ 'ö Yesu ‑yö Dhazaa ‑dhɛ ‑bha 'ö go ga 'gü 'ö ‑bö bha‑ 'gü, ‑a ‑nu ꞊gban \"pɛpɛ‑ ‑gun 'wɔn bha‑ ‑gɛn dɔ sië 'wo ‑ziö 'ka. ");
INSERT INTO daf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yö ꞊në‑ ‑wɔn 'gü 'yö mɛ kpö ‑ziisü bha 'wo nu dɔ Yesu ‑gɔ zian‑; ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ꞊waa‑ ma ꞊dhɛ ꞊ya \"dhabhliwɔn 'ö suu 'dhö bha‑ kë. ");
INSERT INTO daf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Fadhiziɛn ‑nu 'wo ‑ya ‑a pö ‑sü ‑bha wo 'ko ‑nu ‑dhɛ 'wo‑ pö: «‑Ka ‑dhɛ ‑ga bha, 'mɛ bha 'yaa ‑kɔ ‑mɔɔ ‑bha ‑mɛ 'ka 'zü, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ 'gbɛ ꞊gban ꞊wa bɔ‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","'Mɛ 'wo nu Atanna ‑dhɔkë ‑dhɛ 'gü troo ‑ta Zedhizadhɛmö \"dhʋ̈ bha 'mɛ 'waa Zuifö 'ka ‑a ‑nu ga bha‑ ‑gun ‑a ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","'Yö 'mɛ 'wo bha 'wo ꞊yɔɔn Fidhipö 'ö go Bɛsaida, Gadhidhe ‑sɛ 'gü bha‑ \"sɔɔ, 'yö 'wo‑ pö‑ ‑dhɛ: «N Dëmɛ, yi ‑nu kö 'yi yi \"yan ‑kpan Yesu ‑bha!» ");
INSERT INTO daf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","'Yö Fidhipö ‑yö dho 'yö‑ ‑gɛn dɔ Andre ‑dhɛ, 'yö wɛng 'wo dho Yesu \"piʋ̈, 'yö 'wo‑ pö‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑A yi ꞊ya ꞊loo ꞊tɔn kö mang Mɛgbömɛ 'a 'dho kö 'a ‑ya ma ‑blüdëdhɛ ‑gbloo 'ö Atanna \"piʋ̈ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","(\"Kɛɛ n 'dho ‑sü bha‑ \"dhiʋ̈ ‑bha ‑kë ꞊dhɛ) ‑mlüga ‑da \"sɛɛ ‑sü 'dhö, ‑a ‑gɛn ‑mü ꞊dhɛ a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: «‑Mlüga 'dhɛ 'kö 'yii 'dho \"sɛɛdhö kö ‑yö ga, 'yaa ‑gɔ bho kö ‑yö dhi. \"Fɔn kö yö 'dho \"sɛɛdhö. ");
INSERT INTO daf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, 'mɛ 'ö ‑ya ö ‑dɩ ‑bha ‑tosɛa ‑wɔn zuën ‑ta \"dhiʋ̈ ziö 'ka, ‑a ‑mɛ ‑dho ‑a 'ma ‑zukplü ‑bha. \"Kɛɛ 'mɛ‑ ‑bha ‑tosɛa ‑wɔn 'yaa‑ ‑gɔ \"gbɩɩ‑ \"kpʋng ꞊taa yö ꞊në‑ ‑mɛ ‑bha dho 'to‑ ‑gɔ ‑dhɛkpaɔ dhia\" 'gü, 'yö dho ‑da 'ka ꞊sii 'ö 'yaa yën 'ö Atanna \"piʋ̈ bha‑ kë ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","'Mɛ 'ö‑ \"piʋ̈ ꞊dhɛ 'ö bɔ n 'ka, ‑a ‑dhɛa ‑bha ꞊dhɛ ‑a ‑mɛ ‑yö ziö n ꞊keng‑ kö ‑dhɛ 'a‑ ‑bha ‑yö kë mü 'pö, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ yë ‑kë n ‑dhɛ ‑mɛ bha n Dë ‑ya ꞊bhlëë ‑ya. ");
INSERT INTO daf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","꞊Dhɛ 'ö‑ pö \"dhʋ̈ 'yö 'go mü ö‑ pö: «\"Tʋ̈ng 'kwa‑ dɔ‑ 'ka ya n zuë\" ꞊ya kaan‑ \"kwëë, \"kɛɛ maa‑ kë ꞊dhɛ? ‑A pö ꞊në maa‑ wo ꞊dhɛ: N Dë, ‑bhö n dha \"tʋ̈ng 'ö nu sië ya‑ ‑gɔ, \"kɛɛ kö a ‑nu kö 'a yö ꞊në‑ 'gü ‑wɔn kë kö 'a saan\" bha‑ wo \"dhʋ̈ ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","꞊Dhɛ 'ö \"dhʋ̈, n Dë, bhi ꞊në ‑bhö i 'tɔ bhɔ!» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö ‑wʋ 'bha ‑yö bɔ dhang‑ 'gü 'ö ‑wɩ 'ö‑ pö: «A ‑bhɔ n 'tɔ ‑zë bhɔ ‑sü 'ka zii 'nu ‑blɛɛsü, \"kɛɛ a ‑dho ‑a 'bha bhɔ 'zü ‑deewo.» ");
INSERT INTO daf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","꞊Dhɛ 'ö mɛ ‑tu \"tu 'wo gun ‑dhɛ bha‑ 'gü bha 'wo ‑wʋ bha‑ ma, 'yö ‑kɔ \"pɛan 'bha ‑ya pö: «Dha ꞊në ‑wɩ bha!» 'Yö‑ \"pɛan 'bha ‑ya pö: «Atanna ‑bha \"kië ꞊në dhiang zë‑ ‑dhɛ bha!» ");
INSERT INTO daf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","\"Kɛɛ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Wʋ 'ö ‑wɩ bha 'yii \"wɩ ma ‑zë n ‑dhɛ, ‑yö ‑wɩ ka ꞊në ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","‑A ‑gɛn ‑mü ꞊dhɛ \"kpʋngtaadhɛ \"dhɔɔ ga \"tʋ̈ng 'yaa ꞊gblɛɛn 'zü, Sɔtraan 'ö ‑gblüdë 'ka ('ö mɛ ꞊gban 'dhö‑ ‑gɔ 'kun 'gü) \"kpʋng ꞊taa bha‑ ‑bha ‑gblüdëdhɛ ‑sü ‑gɔ \"tʋ̈ng ꞊ya ꞊loo, kö Atanna ‑ya yöö ꞊dede ‑zuö \"kpɛnng yi do 'ka. ");
INSERT INTO daf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","\"Kɛɛ ma ‑zë ꞊wa bo n \"dhiʋ̈ ‑wlü \"sia‑ ‑sü 'ka kö ‑wo n dɔ 'tëng‑ ‑ta, a ‑dho mɛ ꞊gban \"gan n ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","‑Ya ‑pö \"dhʋ̈ kö ga ‑kɔ suu 'ö dho ga‑ 'ka ‑a ‑dɔ \"dhʋ̈ ‑bha ‑sü 'ka bha ꞊në 'ö‑ ‑zɔn 'ka ‑zɔn. ");
INSERT INTO daf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","'Yö mɛ kpö bha 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Yi‑ ‑ma Atanna ‑bha 'tɔng‑ 'sëëdhɛ 'gü ꞊dhɛ ‑a ‑bha ‑Yamɛ 'ö dho nu bha 'yii 'dho ga tongtongdhö, \"kɛɛ bhi 'ö bhi ‑zë yi ‑zʋ 'dhö i 'gü 'zü bha) 'yö i‑ ‑pö sië ‑a ‑dhɛa ‑bha ꞊dhɛ Mɛgbömɛ ‑yö dɔ 'tëng‑ ‑ta bha. ꞊Ya kë \"dhʋ̈ 'sa kö ‑Yamɛ 'ö \"dhʋ̈ bha ꞊në de 'ka?» ");
INSERT INTO daf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Dhɛpuudhɛ ‑yö ‑tun ka kpö 'gü, \"kɛɛ ‑a 'dho \"tʋ̈ng 'yaa ꞊gblɛɛn 'zü. 'Ö \"dhʋ̈, \"tʋ̈ng 'ö ‑tun 'ka ka kpö 'gü bha ‑ka \"ta‑ 'ka‑ 'bhü \"dhiʋ̈ kö ‑dhɛtiidhɛ 'ya 'dho \"kan ka 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö \"ta sië ‑dhɛtiidhɛ 'gü 'yaa ö 'dho ‑zian dɔ. ");
INSERT INTO daf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","‑A ‑wɔn 'gü, ‑ka 'dhang bho ‑dhɛpuudhɛ \"dhiʋ̈ \"tʋ̈ng 'ö ‑tun 'ka ka \"piʋ̈ bha‑ 'gü kö 'ka kë ‑dhɛpuudhɛ 'gü ‑mɛ ‑nu 'ka.» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö dho ‑dhɛ ꞊gblɛɛn 'gü 'yö ö ‑gblɛn 'kpɔ‑ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","\"Dhabhliwɔn 'gbɛ 'ö Yesu ‑ya ‑kë 'ö‑ ‑nu \"yan ‑yö ‑da ‑dhɛ 'gü bha, \"kɛɛ yö ꞊në‑ ꞊gban 'gü 'wii 'dhang bho‑ \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","\"Kɛɛ ‑yö ‑kë \"dhʋ̈ kö 'wɔn 'ö Atanna ‑wʋdhiʋ̈loomɛ Ezai ‑ya pö yi 'bha 'ka ꞊dhɛ: «N Dëmɛ, i ‑bha naɔ 'yi‑ dɔ bha ‑yö kë ‑bhɔ de ꞊në‑ 'gü tɛan‑ ‑bha? \"Ɛɛn 'ö ö ‑gbe 'ö‑ ‑wo zang ‑ta bha de ꞊në‑ kë‑ dɔ bha‑ 'gü ‑wɔn ‑yö kë!» ");
INSERT INTO daf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","'Waa ꞊mɔɔ‑ ‑bha 'nu 'pö kö ‑wo 'dhang bho‑ \"dhiʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ Ezai kë‑ ‑pö 'zü 'ö‑ pö: ");
INSERT INTO daf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","꞊Yaa‑ ‑nu \"yënng tröö, ꞊yaa‑ ‑nu gɔɔ kë \"gbɩɩ‑, kë \"dhʋ̈ kö‑ ‑nu \"yan 'ya 'dho ‑dhɛ yö 'ö 'wo 'wɔn ‑nu ‑yaki dɔ 'ö 'wo wo zuë\" ꞊slëë 'ö 'a‑ ‑nu dha.» ");
INSERT INTO daf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezai ‑yö 'wɔn ‑nu bha‑ ‑nu ‑pö \"dhʋ̈ kö‑ \"yan ꞊ya ‑da Yesu ‑bha mɛdhɛ bha ꞊në‑ 'gü 'yö‑ ‑dhiang zë \"dhʋ̈ bha. ");
INSERT INTO daf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","'Wɔn bha aa\" ꞊ni Zuifö ‑nu ‑gɔmɛ ‑nu 'gbɛ ꞊dede ‑gun 'dhang bho sië Yesu \"dhiʋ̈, \"kɛɛ 'ö 'waa ‑mɔɔ ‑bha kö ‑wa ‑dɔ \"yaan‑ dɔ Fadhiziɛn ‑nu ‑wɔn 'gü, kö ‑wo \"suʋ̈ sië‑ ‑nu ‑gɔ kö 'wa 'dho‑ ‑nu kë ‑a ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu 'gü; ");
INSERT INTO daf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","‑a ‑gɛn ‑mü ꞊dhɛ ‑wo mɛ \"bhɩɩ‑ ‑nu ‑bha \"dhɛ ‑ya wo ‑ta ‑sü fië‑ ‑bho Atanna ‑bha \"dhɛ ‑ya wo ‑ta ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yi do 'ka 'yö Yesu ‑yö ö ‑wʋ \"dhiʋ̈ ꞊wlü 'ö‑ pö: «'Mɛ \"ʋʋ mɛ 'ö ꞊ya 'dhang bho n \"dhiʋ̈, kö‑ ‑mɛ 'yii 'dhang bho ma ‑zë n \"dhiʋ̈, \"kɛɛ kö‑ 'dhang ‑bho 'mɛ 'ö n bɔ bha ꞊në‑ \"dhiʋ̈ bha. ");
INSERT INTO daf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","‑A ‑wɔn 'gü, 'mɛ 'ö ꞊ya n yö kö ꞊ya mɛ 'ö n bɔ bha‑ yö. ");
INSERT INTO daf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma ‑zë a ‑nu ꞊dhɛ ‑dhɛpuudhɛ ꞊në 'dhö \"kpʋng ꞊taa, kë \"dhʋ̈ kö mɛ \"ʋʋ mɛ 'ö ꞊ya 'dhang bho n \"dhiʋ̈, kö‑ mɛ 'ya 'dho ‑tosɛa kë 'wɔn yaa 'gü ‑kpɛawo. ");
INSERT INTO daf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","‑A ‑wɔn 'gü, 'mɛ 'ö n ‑wʋ ma 'ö 'yaa ö \"tʋ kë‑ ‑bha, ma ‑zë 'mii 'dho‑ ‑mɛ dhɛɛ\" 'kpɔ, ‑a ‑gɛn ‑mü ꞊dhɛ ma ‑zë a ‑nu mɛ \"bhɩɩ‑ ‑nu dha ꞊në‑ wo 'mii nu‑ ‑nu zë za 'ka. ");
INSERT INTO daf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","'Mɛ 'ö‑ pö ö \"tʋ 'yaa n ‑wɔn ‑bha, 'ö 'yaa 'ö \"tʋ 'to n ‑wʋ ‑bha, ‑a ‑mɛ ‑bha zadɔmɛ ‑yö ‑dhö. ꞊Ya kë ꞊dhɛ \"tʋ̈ng ‑totaamasü ꞊ya ꞊loo, dhiang ‑nu 'a‑ zë bha ꞊në dho‑ ‑mɛ zë za 'ka. ");
INSERT INTO daf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'mii n ‑dɩ 'gü ‑dhiang zë tongtongdhö, \"kɛɛ n Dë 'ö n bɔ bha ꞊në ö ‑wʋ kpɔ n ‑bha, 'yö ‑wʋ ‑nu 'a dho mɛ ‑nu ꞊klang kë‑ 'ka waa‑ \"ta ‑kɔ ‑nu 'a dho‑ ‑zɔn ‑nu ‑dhɛ bha‑ ‑nu ‑zɔn n ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","'Sa a‑ 'wɔn ‑dɔ ꞊dhɛ ‑wʋ 'ö‑ kpɔ n ‑bha bha ꞊në ‑tosɛa 'ö 'yaa yën 'ö‑ \"piʋ̈ bha‑ ‑kë mɛ ‑dhɛ. 'Wɔn 'ö‑ ‑wɔn 'gü 'yö pë do 'ö n Dë ‑ya pö n ‑dhɛ 'a yö ꞊në‑ pö 'pö bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","‑Yö ‑kë \"dhʋ̈ Pakö \"dhɔɔ yɛan\" \"piʋ̈ 'ka kö‑ yi ꞊ya 'to ꞊dhɛ dhia\" 'dhö, kö Yesu ꞊yaa‑ 'wɔn dɔ ꞊dhɛ ö ‑go \"kpʋng ꞊taa \"tʋ̈ng ꞊ya ꞊loo kö 'ö 'dho ö Dë Atanna \"piʋ̈. ‑A ‑bha mɛ ‑nu 'wo \"kpʋng ꞊taa ‑a ‑nu ‑dhɔ ‑gun kë 'ö‑ wo sië \"dhiʋ̈ ziö 'ka bha, 'yö‑ ‑gɔ ‑da 'plöö yi bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","'Ö gun \"dhʋ̈ kö waa‑ ‑bha ꞊klang ‑nu ‑wo pë ‑bhö sië, kö Sɔtraan ꞊yaa‑ \"dhiʋ̈ dɔ zuëga ‑da 'nu Zuda 'ö ‑kë Simɔ Isikadhiɔtö gbö 'ka bha‑ \"gblʋ̈ʋ̈‑. ");
INSERT INTO daf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","꞊Dhɛ 'ö ‑kë ꞊dhɛ Yesu yöö ꞊dede ‑ya 'wɔn ‑dɔ ꞊dhɛ ö ‑go Atanna \"piʋ̈, 'ö ö yee kë sië 'zü 'ö dho Atanna \"piʋ̈ ‑dhɛ do bha ꞊në‑ 'gü, ꞊dhɛ ö Dë ‑yö ö ‑ya sü 'ka pë ꞊gban \"pɛpɛ ‑gɔ ‑ta bha, ");
INSERT INTO daf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","'yö ꞊wlü ‑bhöpë ‑pë \"dhiʋ̈, 'yö ö ‑bha ꞊gbauu‑ bho ö ‑bha, 'yö ‑zu 'ka ‑sɔ 'kpii‑ do sü 'yö‑ ‑kplü ö 'drüü. ");
INSERT INTO daf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","'Yö \"yi ‑da pëfië do 'gü, 'yö ‑ya ö ‑bha ꞊klangdhiʋ̈ ‑nu bha‑ ‑nu ‑gɛn ‑bha \"zu ‑sü ‑bha ꞊dhɛ ‑a ‑nu bha gwëëmi 'dhö. ꞊Ya mɛ 'dhɛ‑ ‑gɛn ‑bha \"zu, 'yö ‑zu 'ka ‑sɔ 'ö‑ ‑kplü ö ‑ta bha‑ sü 'ö‑ ‑ziö ‑mɛ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","‑Ya yö ꞊në‑ ‑kë \"dhʋ̈ 'yö dho 'ö zun Simɔ Piɛdhö ‑bha. 'Yö Piɛdhö ‑ya pö‑ ‑dhɛ: «N Dëmɛ, bhi ꞊në, bhii ma ‑zë n ‑gɛn ‑bha \"zu ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","'Yö Yesu ‑ya pö‑ ‑dhɛ 'ö‑ pö: «‑Dhɛ ‑ga, Simɔ, 'wɔn 'a‑ kë sië bha 'bhii 'dho‑ 'gü ma ꞊dɛɛ ‑zë 'gü, \"kɛɛ i ‑dho ‑a 'gü ma yi \"wɛɛ 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","'Yö Piɛdhö ‑ya pö‑ ‑dhɛ: «‑Abin! N Dëmɛ, 'bhii 'dho ma ‑zë n ‑gɛn ‑bha \"zu tongtongdhö!» 'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «꞊Ya kë ꞊dhɛ 'mii i ‑gɛn bha \"zu kö i ‑duɛ 'yaa n \"piʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","'Yö Piɛdhö ‑ya ‑yɔ bɔ‑ ‑gɔ 'pö 'ö‑ pö: «꞊Ya kë \"dhʋ̈ 'sa yö ‑zë 'gü, n Dëmɛ, kö 'bha n ‑gɛn ‑bha \"zu, ‑bhö n ‑kɔ waa‑ n ‑gɔ ‑nu ꞊gban ‑bha \"zu do!» ");
INSERT INTO daf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Simɔ, 'mɛ 'kö ꞊ya 'go ö \"zu \"yi 'kpii‑ ꞊bhaa kö‑ ‑mɛ ‑dhɛ 'bha \"zu ‑wɔn 'yaa 'dhö 'zü kö 'yii kë‑ ‑gɛn 'kö ‑ta ‑ta bha‑ 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ kö ‑dhii 'yaa‑ ‑mɛ ‑bha. ꞊Ya kë \"dhʋ̈ kö ka ‑zë ‑dhii ꞊ya 'go ka ‑bha Atanna wëëdhö ꞊naa bha, \"kɛɛ 'sa mɛ ꞊gban ꞊dede ‑zë 'kii kë \"dhʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","‑A pö 'ö‑ wo ꞊dhɛ mɛ ꞊gban ‑zë 'kii kë \"slʋ̈ʋ̈slʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑yö ö \"dhiʋ̈dɔmɛ ‑dɔ ‑a ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑nu ‑gɛn ‑bha \"zu ‑sü 'ka, 'yö ö ‑bha sɔ ‑nu ‑da ö ‑bha, 'yö 'yaanu ‑deewo ö ‑yɛa 'gü 'yö‑ pö‑ ‑nu ‑dhɛ: «'Wɔn 'a‑ ‑kë bha ka‑ ‑gɛn ‑dɔ \"wɛ ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","N ‑dhɛ 'ka‑ wo «yi ‑Gɔmɛ» «yi Dëmɛ» bha tɛanwɔn ‑yö ka \"piʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ a‑ 'ka \"dhʋ̈ tɛan‑ 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","꞊Ya kë \"dhʋ̈ ma 'kö ma ‑zë 'a ‑kë ka ‑gɔmɛ 'ka 'a ka Dëmɛ 'ka bha 'ma ka ‑gɛn ‑bha \"zu, ‑a ‑dhɛa ‑bha ꞊dhɛ kaa ‑dɩ 'pö 'ka ka ‑dɩ kë ‑bha ‑sü kö 'ka ka 'ko ‑nu ‑ta 'kun; ");
INSERT INTO daf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn zaɔn ꞊në 'a‑ nu ka ‑dhɛ bha kö 'ka‑ kë 'pö ꞊dhɛ n 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ gwëë\" 'bha 'yaa 'dhö kö‑ ꞊bhlëë ‑yö kë 'kpii‑ ‑yö ziö‑ 'ka ö dëmɛ ‑zë ‑ta, \"ɛɛn ꞊dhɛ bɔmɛ ‑zë 'bha 'yaa 'dhö kö‑ ꞊bhlëë ‑yö kë 'kpii‑ ‑yö ziö‑ 'ka 'mɛ 'kö‑ bɔ bha‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","'Ma‑ pö ka ‑dhɛ 'ka‑ dɔ. ꞊Ya kë ꞊dhɛ 'ka‑ 'gü ‑wɔn ‑zë kë, ka ‑bha ‑dho kë ‑së. ");
INSERT INTO daf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","'Sa a‑ ‑pö \"dhʋ̈ \"kɛɛ 'mii \"wɩ mɛ ꞊gban 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'a‑ ‑nu ‑ya a‑ ‑nu ‑dɔ. \"Kɛɛ ‑a ‑dhɛa ‑bha ꞊dhɛ 'pë 'ö Atanna ‑wʋ ‑ya pö 'ö‑ pö ꞊dhɛ: ‹'Mɛ yɛng yi ‑kɔ 'dhö gun 'tɛa‑ do ‑bha bha ꞊ya ‑da n ‑dhɛ pë \"piʋ̈› bha‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","A 'wɔn bha‑ ‑to \"dhiʋ̈ 'a‑ pö ka ‑dhɛ \"dhʋ̈ kë \"dhʋ̈ kö ꞊ya kë yi 'ö‑ 'ka kö 'ka‑ 'wɔn dɔ ꞊dhɛ Atanna ‑bha ‑Yamɛ bha yö ‑mü ma ꞊në n 'ka. ");
INSERT INTO daf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'ö ö ‑kɔ ‑ya 'mɛ 'a‑ bɔ ‑a ‑dhɛng ‑bha, kö ꞊ya ö ‑kɔ ‑ya n ‑dhɛng ‑bha ꞊naa bha. 'Sa mɛ \"ʋʋ mɛ 'ö ö ‑kɔ ‑ya n ‑dhɛng ‑bha kö ꞊ya ö ‑kɔ ‑ya 'mɛ 'ö n bɔ ‑a ‑dhɛng ‑bha 'pö ꞊naa bha.» ");
INSERT INTO daf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","꞊Dhɛ 'ö ꞊ya ö bo‑ ‑pö \"dhʋ̈ ‑sü 'ka 'yö‑ \"gblʋ̈ʋ̈dhɛ ‑yö \"muu bho, 'yö‑ \"dhiʋ̈ ꞊loo‑ ‑nu ‑bha 'ö‑ pö «‑Ka ‑dhɛ ‑ga, a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ 'mɛ 'ka bha ꞊në‑ mɛ do dho ‑da n ‑dhɛ pë \"piʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","'Yö 'wo ‑ya wo 'ko ‑ga ‑sü ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ kö 'ö \"wɩ sië 'mɛ 'ö‑ 'ka \"dhʋ̈ bha 'waa‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","'Ö gun \"dhʋ̈ kö Yesu ‑bha ꞊klang ‑nu bha‑ ‑mɛ 'dhɛ 'ö‑ ‑dhɔ ‑ya kë bha ‑yö ‑ya ‑sü 'ka‑ \"sɔɔ klüü\" klüüdhö. ");
INSERT INTO daf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","'Yö Simɔ Piɛdhö ‑yö dhiang zë‑ ‑dhɛ ö \"yanga 'gü kö ‑yö Yesu dhɛɛ\" 'kpɔ kö 'ö \"wɩ sië 'mɛ 'ö‑ 'ka bha ‑ya pö wo ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","'Yö 'mɛ bha 'ö ö ‑gɔ ꞊yɔɔn Yesu \"sɔɔ 'yö‑ pö‑ ‑dhɛ: «N Dëmɛ, de ‑mü?» ");
INSERT INTO daf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","'Yö Yesu ‑ya ‑yɔ bɔ 'ö‑ pö: «'Bluu‑ 'ö maa ziö \"tʋʋ 'ka ya maa‑ ‑dɔ mɛ 'ö‑ ‑gɔ bha kö‑ ‑mɛ ꞊në bha. 'Yö 'bluu‑ \"kplü do sü, 'yö‑ ‑ziö \"tʋʋ 'ka 'yö‑ nu Zuda 'wo‑ dë ‑dhɛ Simɔ Isikadhiɔtö bha‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","꞊Dhɛ 'ö Zuda ‑yö 'bluu‑ \"kplü bha‑ 'sü bhoo, 'yö Sɔtraan ‑yö 'wɔn yaa kë zuëga ‑da ‑a \"gblʋ̈ʋ̈‑. Yesu ‑yö ‑to mü 'pö 'ö‑ pö‑ ‑dhɛ: «Zuda, 'wɔn 'ö bhii‑ kë ‑bhö ‑a kë \"vaandhö!» ");
INSERT INTO daf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","‑A pö 'ö‑ wo Zuda ‑dhɛ \"dhʋ̈ bha 'mɛ 'ö wɛng‑ ‑nu 'wo gun ‑dhɛ do 'gü mü bha‑ ‑nu 'bha 'wii‑ 'klɔɔ‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","‑Yö ‑kë mɛ 'gbɛ 'gü ꞊dhɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ Zuda ꞊në gun 'mɛ 'wo bha‑ ‑nu ‑bha ꞊naɔ ‑duɛ bho ‑mɛ 'ka bha ꞊Ya kë \"dhʋ̈ kö Yesu ‑ya ‑pö ‑yö 'dho ‑bhöpë 'wo dho‑ ‑bhö troo ‑ta ꞊në‑ 'dhɔ ‑dhɛ 'gü, \"ɛɛn 'zü ꞊dhɛ ‑yö pë 'bha nu ‑wëëmɛ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Zuda ‑yö 'ö ‑kɔ ‑da 'bluu‑ \"kplü bha‑ 'gü, 'yö to 'ö zun \"kpɛnng, \"kɛɛ 'ö gun \"dhʋ̈ kö \"bin ꞊ya 'ma. ");
INSERT INTO daf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","꞊Dhɛ 'ö Zuda ꞊ya zun \"kpɛnng 'ö \"tʋ̈ng 'në 'bha ꞊ya ziö, 'yö Yesu ‑ya pö ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «‑A \"tʋ̈ng ꞊ya ꞊loo kö mang Mɛgbömɛ n 'tɔ ‑yö bhɔ ga 'ö maa‑ wo bha‑ 'gü, kö Atanna ‑dɩ 'pö‑ 'tɔ ‑yö bhɔ n ‑bu 'gü. ");
INSERT INTO daf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'Sa ꞊ya kë ꞊dhɛ Atanna 'tɔ ꞊ya bhɔ n ‑bu 'gü kö yöö‑ \"slë kë 'pö kö mang Mɛgbömɛ n 'tɔ ‑yö bhɔ 'pö ö ‑bu 'gü. ‑A ‑kë \"dhʋ̈ \"tʋ̈ng 'yaa ꞊gblɛɛn 'zü.» ");
INSERT INTO daf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","'Yö‑ pö 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «\"Tʋ̈ng 'ö ꞊ya 'to n ‑gɔ kö 'a‑ kë ka \"piʋ̈ 'yaa ꞊gblɛɛn 'zü, n bhang ‑nu, ‑a \"tʋ̈ng 'ö \"dhʋ̈ bha ꞊ya ziö, ka ‑dho n mɔɔ‑ \"kɛɛ 'wɔn do 'a‑ pö Zuifö ‑nu ‑gɔmɛ ‑nu ‑dhɛ ꞊në 'a‑ ‑pö sië ka ‑dhɛ 'pö ya, ꞊dhɛ 'kii 'dho ꞊mɔɔ‑ ‑bha kö 'ka 'dho ‑dhɛ 'a 'dho sië‑ ‑bha bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","‑A ‑kë \"dhʋ̈ ‑sü 'gü, ma ‑zë ma ‑dhio ‑dee 'a dho‑ dɔ ka ‑ta 'yö ‑mü ꞊dhɛ kö ka 'ko ‑nu ‑dhɔ ‑yö ka 'ko kë ꞊dhɛ ‑kɔ 'ö ka ‑dhɔ ‑yö n ‑kë 'ka ya‑ 'dhö. ꞊Dhɛ 'ö \"dhʋ̈, ka ‑dhɔ ‑yö ka 'ko kë. ");
INSERT INTO daf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","꞊Ya kë ꞊dhɛ ka ‑dhɔ ꞊në ꞊ya ka 'ko kë ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö mɛ ꞊gban‑ dho‑ 'wɔn dɔ ꞊dhɛ ma ꞊klang ‑nu ‑mü ka 'ka. ");
INSERT INTO daf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","‑Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Simɔ Piɛdhö ‑ya dhɛɛ\" kpɔ 'ö‑ pö: «N Dëmɛ, i ‑dho 'mɛ?» 'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Dhɛ 'a 'dho sië‑ ‑bha bha i ‑dho 'dho mü ('pö \"kɛɛ yö ‑zë ‑yö ‑dho kë), \"kɛɛ \"tʋ̈ng ‑dhɛ 'kö 'kwa dɔ‑ 'ka ya 'bhii 'dho ꞊mɔɔ ‑dho mü ‑sü ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","'Yö Piɛdhö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N Dëmɛ, i‑ ‑pö \"dhʋ̈ ‑më ‑wɔn 'gü? A‑ ‑pö i ‑dhɛ ꞊dhɛ \"tʋ̈ng kwa dɔ‑ 'ka ya n ‑kɔ ‑mɔɔ ‑bha kö 'a ga ‑zianwo i ‑wɔn 'gü!» ");
INSERT INTO daf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «I‑ ‑pö i ‑mɔɔ ‑bha 'i ga n ‑wɔn 'gü ꞊dedewo tɛan‑ 'ka ‑ee, Piɛdhö? A‑ ‑pö i ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ‑dhɛkpaɔyi do 'ö ꞊dɛɛ, \"sanni ‑wa pö ꞊dhɛ ‑tɔgɔn ꞊ya \"wɩ, kö 'bha n ‑wɔn zaɔ‑ ‑gɛn ‑yan 'ka ‑yaaga, (kö 'bha‑ pö 'bhaa n dɔ).» ");
INSERT INTO daf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ 'ö‑ pö: \"Kɛɛ ka zuë\" 'ya 'dho kaan‑ \"kwëë. ‑Ka 'dhang bho Atanna \"dhiʋ̈ kö 'ka 'dhang bho mang ‑dɩ 'pö n \"dhiʋ̈! ");
INSERT INTO daf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","‑Yɛa 'ö n Dë \"piʋ̈ dhang‑ 'gü ‑yö 'gbɛ. ‑A yö ‑zë 'yaa \"dhʋ̈ 'nu kö 'mii 'dho‑ pö ka ‑dhɛ ꞊dhɛ 'ma 'dho ka ‑yɛa baa‑ ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","꞊Ya kë ꞊dhɛ 'ma 'dho kö 'a ka ‑yɛa ‑pë kë, a ‑dho n yee kë 'zü ‑deewo a ‑nu ka 'sü ‑dhɛ 'gü 'yö 'ka ‑kë n \"sɔɔ, kë \"dhʋ̈ kö ‑dhɛ 'a‑ ‑bha kaa ‑dɩ 'pö 'ka kë mü. ");
INSERT INTO daf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'Sa zian 'ö dho ‑dhɛ 'a 'dho sië‑ ‑bha bha‑ 'gü ka‑ ‑dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Toma ‑ya pö‑ ‑dhɛ: «N Dëmɛ, ‑dhɛ 'i 'dho sië‑ ‑bha 'ö 'yaa‑ dɔ ‑zianwo bha yi ‑dho ‑a zian ‑zë dɔ ‑kɔ kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Toma, ma ꞊në 'a zian 'ö dho Atanna \"piʋ̈ ‑a 'ka, ma ꞊në 'wo n ‑dhɛ tɛanwɔn, ꞊waa‑ pö 'zü ꞊sii 'ö 'yaa yën, kö ‑wo ‑wɩ ma ꞊në n 'ka. Mɛ 'bha 'yaa 'dho n Dë ‑dhɛ 'gü kö 'yii zun ma ‑zë n ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","'Ka ma ‑zë n dɔ kö 'ka n Dë dɔ ꞊naa bha. ꞊Ya 'go ꞊dɛɛ 'gü, 'ka n Dë dɔ ꞊naa bha, ‑a ‑gɛn ‑mü ꞊dhɛ 'ka n yö kö 'ka‑ yö.» ");
INSERT INTO daf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","'Yö Fidhipö ‑ya pö‑ 'pö‑ ‑dhɛ 'ö‑ pö: «N Dëmɛ, ‑bhö i Dë ‑zɔn yi ‑dhɛ ‑dhe! 'Bha‑ ‑zɔn yi ‑dhɛ kö ꞊ya yi ‑bha bho.» ");
INSERT INTO daf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Fidhipö, bhi 'ö ka ‑da n ꞊keng‑ ‑yi \"sinma ꞊ya ꞊gwëë ya 'bhii n dɔ ꞊kö, i ‑tun pö ‑deewo ꞊dhɛ 'a n Dë ‑zɔn i ‑dhɛ ‑ee? ‑Dhɛ ‑ga, 'mɛ 'bha n yö kö 'bha n Dë yö. 'Bha 'dho‑ pö 'zü ‑deewo ꞊dhɛ «‑bhö i Dë ‑zɔn yi ‑dhɛ». ");
INSERT INTO daf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ yaa n Dë yi do. \"Ɛɛn 'bhaa‑ 'wɔn dɔ ꞊dhɛ n Dë ‑yö n 'gü mang ‑dɩ 'pö a‑ 'gü ‑ee? ‑Wʋ ‑nu 'a‑ pö sië ka ‑dhɛ bha 'mii‑ 'bha bho n ‑dɩ 'gü! N Dë 'ö n 'gü bha ꞊në 'wɔn ‑së ‑nu bha‑ ‑nu ‑kë. ");
INSERT INTO daf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","‑Ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ a n Dë 'gü n Dë ‑dɩ 'pö ‑yö n 'gü. 'Kö 'zü 'kii 'dhang bho n zë ‑dhiang ‑zë \"dhiʋ̈, \"kɛɛ 'wɔn ‑nu 'kö 'a‑ kë sië bha ‑kaa ‑ga kö 'ka 'dhang bho n \"dhiʋ̈ ‑a ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ: «Mɛ \"ʋʋ mɛ 'ö 'dhang bho n \"dhiʋ̈, 'wɔn ‑nu 'a‑ kë sië bha‑ ‑mɛ ‑dho ‑a kë. ‑A ‑mɛ ‑zian ‑zë ‑dho ‑a \"dhiʋ̈ ‑ziö ‑ta kë, ‑a ‑gɛn ‑mü ꞊dhɛ ma ‑zë n ‑dho n Dë \"piʋ̈ ‑sü ꞊nɛ (kö 'a Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ bha‑ bɔ ka ‑dhɛ). ");
INSERT INTO daf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","꞊Ya kë 'zü ꞊dhɛ 'ma 'dho, pë \"pɛpɛ 'ka dho‑ ‑gbadhɛ n Dë ‑gɔ n 'tɔ 'gü a ‑dho ‑a kë ka ‑dhɛ, kë \"dhʋ̈ kö n Dë 'tɔ ‑yö bhɔ ma 'a‑ Gbö 'ka bha n ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","꞊Ya kë 'zü ꞊dhɛ 'ka pë ‑gbadhɛ n ‑gɔ n 'tɔ 'gü a ‑dho ‑a kë ka ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","'Yö Yesu ‑ya pö 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «\"Ni ꞊ya kë ꞊dhɛ n ‑dhɔ ‑zë 'ö ka ‑kë tɛan‑ ꞊dede 'ka, kö ‑wʋ ‑nu 'a‑ kpɔ ka ‑bha bha 'ka‑ 'gü ‑wɔn kë. ");
INSERT INTO daf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ma ‑zë 'ma 'dho a ‑dho bhɛa\" n Dë ‑dhɛ kö ‑yö mɛ \"wɛɛ bha bɔ ka ‑dhɛ kö ‑yö ka ‑ta 'kun. A ‑dho bhɛa\" n Dë ‑dhɛ kö ‑yö tɛanwɔn pö 'Nii‑ bha‑ bɔ ka ‑dhɛ kö ‑yö kë ka \"piʋ̈ yi ꞊gban 'ka. 'Nii‑ 'ö \"dhʋ̈ bha \"kpʋngtaamɛ ‑nu ‑zë 'waa ꞊mɔɔ‑ ‑bha kö ‑wa ꞊slɔɔ, ‑a ‑gɛn ‑mü ꞊dhɛ 'waa ꞊mɔɔ‑ ‑bha kö ‑wa yö, \"ɛɛn kö ‑wa dɔ. \"Kɛɛ ka ‑zë ka‑ ‑dɔ, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ka \"piʋ̈ yi ꞊gban 'ka, ‑yö ka 'gü. ");
INSERT INTO daf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'Dho 'ö maa‑ wo bha 'mii 'dho n ‑kɔ \"kan ka \"dhiʋ̈ kö 'ka to ꞊dhɛ ‑tɩnë 'dhö, a ‑dho n \"dhiʋ̈ yee kë 'a nu 'zü ka \"piʋ̈ ‑deewo. ");
INSERT INTO daf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'Sa ‑a \"tʋ̈ng 'yaa ꞊gblɛɛn 'zü kö 'ma ꞊dhɛng \"kpʋngtaamɛ ‑nu ‑gɔ, \"kɛɛ ka ‑zë ka ‑dho n yö, ‑a ‑gɛn ‑mü ꞊dhɛ a \"yaandhe 'ka, ꞊ya 'go mü 'zü kaa ‑dɩ 'pö ka ‑dho kë ꞊dhɛ n 'dhö 'ö 'kaa ga 'zü tongtongdhö. ");
INSERT INTO daf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","‑A yi 'ö bha ꞊në‑ 'ka, 'yö 'ka dho‑ 'wɔn dɔ ꞊dhɛ a n Dë 'gü, 'yö 'ka n 'gü, 'yö mang ‑dɩ 'pö 'a ka 'gü. ");
INSERT INTO daf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","'Mɛ 'ö dho ö ‑zʋ 'kpɔ ‑wʋ ‑nu 'a‑ kpɔ ka ‑bha bha‑ 'gü, 'ö‑ 'gü ‑wɔn ‑kë kö n ‑dhɔ ‑ya ‑mɛ ꞊në‑ ‑kë. 'Mɛ 'ö \"dhʋ̈ bha‑ ‑dhɔ ‑dho n Dë kë 'ö‑ ‑dhɔ ‑yö mang ‑dɩ 'pö n ‑kë 'ö 'a n ‑dɩ ‑zɔn ‑mɛ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö Zudë ‑ya pö‑ ‑dhɛ: «N Dëmɛ, ‑yö kë ‑kɔ ‑kë ꞊dhɛ 'yö 'i‑ pö i ‑dho i ‑dɩ ‑zɔn yi ‑zë yi ‑dhɛ \"kɛɛ 'bhii 'dho i ‑dɩ ‑zɔn \"kpʋngtaamɛ ‑nu ‑zë ‑a ‑nu ‑dhɛ?» Zudë 'dhɛ 'ö dhɛɛ\" kpɔ \"dhʋ̈ bha ‑yö ‑dɩ ‑ta 'yö Zuda Isikadhiɔtö ‑dɩ 'pö 'ö ‑dɩ ‑ta. ");
INSERT INTO daf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","'Yö Yesu ꞊ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö n ‑dhɔ ‑ya ‑kë ‑a ‑mɛ ‑zë ‑yö ‑dho ö \"tʋ 'to n ‑wʋ ‑bha 'ö‑ 'gü ‑wɔn ‑kë, 'mɛ 'ö \"dhʋ̈ bha 'pö 'yö‑ ‑dhɔ dho n Dë kë, 'yö yaa n Dë 'yi dho nu yi ‑dhɛng bhɔ‑ ‑mɛ ‑ta 'yö 'yi ‑ya mü. ");
INSERT INTO daf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","\"Kɛɛ 'mɛ 'kö n ‑dhɔ 'yaa‑ kë, ‑a ‑mɛ 'yaa ö \"tʋ 'to n ‑wʋ ‑bha. 'Sa ‑wʋ ‑nu 'ka‑ ma sië n ‑ta bha 'mii‑ 'bha bho n ‑dɩ 'gü. N Dë 'ö n bɔ bha ꞊në‑ ‑nu dɔ n \"dhi. ");
INSERT INTO daf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","꞊Dhɛ 'ö ‑kë ꞊dhɛ a ‑tun ka \"piʋ̈ yö bha a 'wɔn ‑nu bha‑ ‑nu ‑pö ka ‑dhɛ 'yö ꞊në‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","\"Kɛɛ 'mɛ 'ö dho ka ‑zʋ gban kö 'ma 'dho bha‑ ‑mɛ ‑dho nu. 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ö n Dë dho‑ bɔ ka ‑dhɛ ma bɔ 'gü bha ꞊në dho ka ꞊klang kë pë ꞊gban \"pɛpɛ 'ka, 'yö ka ‑zʋ ‑bö 'pö pë \"pɛpɛ 'a‑ pö ka ‑dhɛ bha‑ ꞊gban 'ka. ");
INSERT INTO daf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Zuëwaanusü ꞊në ma ‑zë 'a‑ to ka ‑gɔ. Zuëwaanusü 'ö n ‑gɔ bha ꞊në 'a‑ ꞊gbaɔ ka ‑gɔ. Yö ‑zë 'yaa ꞊dhɛ 'mɛ 'waa Atanna dɔ‑ ‑nu ‑bha 'dhö. ‑A ‑wɔn 'gü ka zuë\" 'ya 'dho kaan‑ \"kwëë, \"suʋ̈ 'ya 'dho ka kë! ");
INSERT INTO daf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","'Sa ‑a pö 'a‑ wo ka ‑dhɛ ꞊dhɛ «maa 'dho \"kɛɛ 'ma 'dho a ‑dho n \"dhiʋ̈ yee kë 'zü 'a nu ka \"piʋ̈» bha ‑yö ka \"tʋʋdhö. ꞊Ya kë 'nu ꞊dhɛ n ‑dhɔ ‑yö ka ‑kë kö ‑a pö 'a‑ wo \"dhʋ̈ bha‑ \"dhia‑ ‑dho 'ma ka 'gü 'nu, ‑a 'klɔɔ‑ ‑mü ꞊dhɛ n Dë 'a 'dho sië‑ \"piʋ̈ bha yö ‑zë ‑duɛ 'kpii‑ ma ‑zë n ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","'Sa 'wɔn 'ö dho kë ‑a 'to 'a‑ wo \"dhiʋ̈ 'a‑ pö ka ‑dhɛ 'pö \"dhʋ̈ bha, a‑ ‑kë \"dhʋ̈ kö ꞊ya kë yi 'ö‑ 'ka kö 'ka 'dhang bho n \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Dhiang 'ö maa‑ zë ka ‑dhɛ ka ꞊klang kë ‑dhiang 'ka ‑a ‑kpɛa ꞊në 'a‑ zë sië bha, ‑a ‑gɛn ‑mü ꞊dhɛ Sɔtraan 'ö \"kpʋng ꞊taa ‑gblüdë 'ka bha ‑yö nu sië n ‑gɔ. 'Sa kö ‑yö kë ꞊dhɛ ‑a faan ꞊në \"gbɩɩ‑ 'ö ‑ziö n ‑bha ‑ta 'yaa ‑mü. ");
INSERT INTO daf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","\"Kɛɛ ‑a ‑dhɛa ‑bha ꞊dhɛ \"kpʋngtaamɛ ‑nu ‑wa 'wɔn dɔ ꞊dhɛ n Dë ‑dhɔ ‑yö n ‑kë, ꞊dhɛ 'pë 'ö‑ pö n ‑dhɛ ꞊në 'a‑ ‑kë. ꞊Dhɛ 'ö \"dhʋ̈ ‑ka \"wlü kö 'kwa 'dho 'kwa 'go ‑dhɛ ya 'gü!» ");
INSERT INTO daf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","꞊Dhɛ 'ö Yesu ꞊ya ö bo‑ ‑pö ‑nu ‑dhɛ \"dhʋ̈ ‑sü 'ka 'yö \"gwënng do ‑da ‑nu ‑dhɛ 'ö‑ pö: «Ma ꞊në 'a ꞊dhɛ ‑drɔɔ ‑dhü ꞊dede 'wo‑ ta ‑a 'dhö, 'yö n Dë ‑zë 'ö‑ ta ‑mɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","('Yö mɛ \"pɛpɛ 'wo 'dhang bho n \"dhiʋ̈ bha 'wo ꞊dhɛ 'pö ꞊dhɛ n ‑gbeng ‑nu 'dhö.) N ‑gbeng \"pɛpɛ 'wo n ‑bha 'ö 'waa bha n Dë ꞊në‑ ‑nu ‑kan, 'yö‑ 'dhɛ 'wo bha 'yö‑ ‑nu ‑ta zë, kë \"dhʋ̈ kö ‑wo sa, kö ‑wo bhɛ ‑ya kö ‑yö ziö ‑blɛɛsü ‑bha ‑ta. ");
INSERT INTO daf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","\"Kɛɛ ꞊ya 'to ka ‑zë 'ka ‑bha ‑bha kö ‑wʋ ‑nu 'a ka ꞊klang ‑kë 'ka bha ꞊wa 'ka ‑gbeng yaya ꞊gban \"kan ka ‑bha, ꞊wa ka ‑ta zë, 'ka ‑kë \"slʋ̈ʋ̈slʋ̈ 'dhang 'ka‑ bho‑ \"dhiʋ̈ bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","꞊Dhɛ 'ö \"dhʋ̈ ‑ka 'to ‑kplü ‑sü 'ka n ‑bha, kö 'a 'to 'pö ‑kplü ‑sü 'ka ka ‑bha (kö kwa ‑wʋ ‑yö kë do). Ka‑ 'wɔn ‑dɔ ꞊dhɛ \"dhü ‑gbeng 'ö ꞊ya \"kan ö ‑dhü ‑bha 'yaa ꞊mɔɔ‑ ‑bha 'zü kö ‑yö bha ö ‑dɩ ‑ta. ‑Kɔ do bha‑ 'gü 'kii 'to ‑kplü ‑sü 'ka n ‑bha, kö 'ka kë ꞊dhɛ \"dhü ‑gbeng 'ö ꞊ya \"kan ö ‑dhü ‑bha ꞊në‑ 'dhö bha. ");
INSERT INTO daf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ma ꞊në 'a ꞊dhɛ ‑drɔɔ ‑dhü ꞊dede 'dhö, 'yö ka ‑zë 'ka ꞊dhɛ n ‑gbeng ‑nu 'dhö. 'Mɛ 'ö ꞊ya 'to ‑kplü ‑sü 'ka n ‑bha 'ö mang ‑dɩ 'pö n ‑kɔ 'dhö‑ ‑mɛ ‑bha, 'ö yi ‑wʋ 'dhö do, ‑yö ‑dho bha ꞊dedewo. ‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'kaa ꞊mɔɔ‑ ‑bha kö 'ka pë 'bha kë kö n ‑kɔ 'yaa‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mɛ \"ʋʋ mɛ 'ö 'yii 'to ‑kplü ‑sü 'ka n ‑bha, n Dë ‑ya ‑mɛ ‑zuö \"kpɛnng ꞊dhɛ \"dhü ‑gbeng 'ö 'yaa bha‑ 'dhö 'yö \"kpɛa kpɔ klöngklöngdhö, 'yö 'wo‑ ‑wlö 'wo‑ ꞊loo pɛng \"dhiʋ̈ 'yö ‑gʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","\"Kɛɛ ꞊ya kë ꞊dhɛ 'ka 'to ‑kplü ‑sü ‑zë 'ka n ‑bha kö kwa ‑wʋ ‑yö kë do, kö ‑wʋ ‑nu 'a‑ pö ka ‑dhɛ bha ‑wo 'to ka \"tʋʋdhö, pë \"ʋʋ pë 'ö ‑dhi ka ‑dhɛ, ‑kaa ‑gbadhɛ n Dë ‑gɔ, ‑yö ‑dho ‑a kë ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ n Dë 'tɔ bhɔ ‑kɔ 'ö 'dhö, yö ‑mü ꞊dhɛ kö 'ka kë ꞊dhɛ \"dhü ‑gbeng 'ö ꞊waa‑ baa‑, 'ö bha sië ꞊dedewo bha ꞊në‑ 'dhö. Yö ꞊në ꞊ya kë \"dhʋ̈ kö 'ka kë ma ꞊klangdhiʋ̈ 'ka ꞊dedewo \"pɛɛpɛdhö. ");
INSERT INTO daf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ka ‑dhɔ ‑yö n ‑kë 'pö ꞊dhɛ ‑kɔ 'ö n ‑dhɔ ‑yö n Dë ‑kë 'ka ‑a 'dhö. ꞊Dhɛ 'ö \"dhʋ̈, ‑ka 'to ‑kplü ‑sü 'ka ‑dhɔ bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","꞊Ya kë ꞊dhɛ 'ka ka ‑zʋ kë ‑wʋ ‑nu 'a‑ kpɔ ka ‑bha bha‑ 'gü kö 'ka‑ 'gü ‑wɔn kë, kö ka ‑kplü ‑sü 'ka n ‑bha, kö ka ‑dhɔ bha‑ \"gblʋʋ ‑ta ꞊dhɛ ‑kɔ 'ö mang ‑dɩ 'pö 'a n Dë ‑wʋ kun‑ 'ka 'ö n ‑dhɔ ‑ya ‑kë bha‑ 'dhö ꞊naa bha. ");
INSERT INTO daf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","'Wɔn ‑nu bha a‑ ‑nu ‑pö ka ‑dhɛ \"dhʋ̈ kö zuëniidadhe 'ö n ‑gɔ bha yö ꞊në ‑yö kë ka ‑gɔ 'pö, kë \"dhʋ̈ kö ka zuë\" ꞊nii ‑yö ‑da ꞊dedewo ‑tɛkpɛ ‑tɛkpɛdhö. ");
INSERT INTO daf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ka ‑dhɔ ‑yö ka 'ko kë ꞊dhɛ ‑kɔ 'ö ka ‑dhɔ ‑yö n ‑kë 'ka bha‑ 'dhö. ‑Wʋ 'a‑ kpɔ ka ‑bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ mɛ \"taɔngdë 'ö‑ ‑dhɔ ‑yö mɛ ‑kë 'yö mɛ‑ ꞊mɔɔ‑ ‑bha mɛ mɛ ‑dɩ nu‑ ‑wɔn 'gü. Mɛ ‑dhɔ ‑bha mɛ kë ‑sü ‑zë \"wɛɛ 'bha 'yaa ziö‑ 'dhɛ 'kö bha ꞊në‑ ‑ta. ");
INSERT INTO daf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","꞊Dhɛ 'ö \"dhʋ̈ n \"taɔngdë ‑nu, ꞊ya kë ꞊dhɛ ‑wʋ 'a‑ kpɔ ka ‑bha bha 'ka yö ꞊në‑ 'gü ‑wɔn kë kö 'ka kë n \"taɔngdë ꞊dede 'ka. ");
INSERT INTO daf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Maa ka 'sü 'zü ꞊dhɛ ma gwëëzë ‑nu 'dhö, ‑a ‑gɛn ‑mü ꞊dhɛ gwëëmi ‑zë 'yaa ö dëmɛ zuëpiʋ̈wɔn ‑nu dɔ. \"Kɛɛ ma ‑zë 'wɔn 'a‑ dɔ n Dë \"gblʋʋ \"piʋ̈ 'ma‑ ꞊gban ‑zɔn ka ‑dhɛ. 'Wɔn 'ö‑ ‑wɔn 'gü 'yö 'a ka ‑dhɛ n \"taɔngdë ‑nu bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","\"Kɛɛ 'sa ka ‑zë 'kii n ‑ya. Ma ꞊në ma ‑zë 'a n ‑kɔ ‑yɛ ka ‑bha, 'yö 'a ka ‑ya kö 'a ka bɔ, kö 'ka bhɛ ‑së dɔ \"tʋ̈ng ꞊gban 'gü, 'wɔn ‑së kë ‑sü waa‑ ‑dhɔkë mɛ ꞊gban \"pɛpɛ 'ka ‑sü 'ka, kö ‑yö kë \"dhʋ̈ kö 'pë 'ö 'ka dho‑ ‑gbadhɛ n Dë ‑gɔ n 'tɔ 'gü bha ‑ya nu ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","‑Wʋ 'a‑ kpɔ ka ‑bha yö ‑mü ꞊dhɛ kö ka ‑dhɔ ‑yö ka 'ko kë ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","'Yö‑ pö‑ ‑nu ‑dhɛ 'zü 'ö‑ pö: «\"Kɛɛ ꞊ya kë ꞊dhɛ ka ‑san ꞊ya mɛ \"bhɩɩ‑ ‑nu kë, ka ‑zʋ ‑yö ‑bö ꞊dhɛ ma ꞊në n ‑san ‑ya ‑nu ‑kë ‑blɛɛsü. ");
INSERT INTO daf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","꞊Ya kë 'nu ꞊dhɛ ka ‑tosɛa ‑kë ꞊dhɛ 'mɛ 'waa Atanna dɔ‑ ‑nu 'dhö, kö ka ‑dhɔ ‑dho ‑a ‑nu kë, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'kö wɛng‑ ‑nu 'wo bɔ ‑a ‑nu ‑dhɔ ‑ya ‑nu ‑kë. \"Kɛɛ ka 'sü 'a‑ wo 'a ka ‑ya ‑dɩ ‑ta, 'a ka ‑kan ‑a ‑nu ‑bha, 'ö kɛng‑ ‑nu ka ‑wʋ 'yaa do 'zü bha ka ‑san ‑ya ‑nu ‑kë yö ꞊në‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, ‑wʋ 'a‑ pö ka ‑dhɛ 'a‑ pö ꞊dhɛ gwëëmi 'bha ‑bha 'bha fië‑ 'yaa 'dhö ö dëmɛ 'ka bha ka ‑zʋ 'ya 'dho bhɔ yö ꞊në‑ 'ka. ꞊Ya kë ꞊dhɛ ꞊wa n ‑wëëdhɛ bho kö ‑yö kë ka \"yaan ꞊dhɛ ‑wo ‑dho ka ‑wëëdhɛ bho 'pö. ꞊Ya kë ꞊dhɛ ꞊wa 'dhang bho n ‑wʋ \"dhiʋ̈ kö ‑wo ‑dho 'dhang bho 'pö ka ‑bha \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","\"Kɛɛ ‑wo ‑dho 'wɔn ‑nu bha‑ ꞊gban \"pɛpɛ kë ka 'ka \"dhʋ̈ ma ꞊në n ‑wɔn 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö n bɔ bha 'waa‑ ‑dɔ. ");
INSERT INTO daf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","'Sa ꞊ya kë ꞊dhɛ 'mii nu 'nu kö 'a dhiang zë‑ ‑nu ‑dhɛ, kö za 'yaa‑ ‑nu ‑bha. \"Kɛɛ 'ma nu 'ma dhiang zë‑ ‑nu ‑dhɛ. ꞊Ya kë ꞊dhɛ 'wii 'dhang bho n \"dhiʋ̈ kö za ‑ya ‑nu ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ö n ‑san ‑ya ‑kë kö n Dë ‑san ‑ya ‑kë. ");
INSERT INTO daf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","꞊Ya kë ꞊dhɛ 'wɔn ‑nu 'ö mɛ 'bha 'yii‑ suu kë do bha 'mii yö ꞊në‑ 'bha kë 'nu ‑a ‑nu kpö 'gü kö‑ ‑nu \"yan‑ ‑da ‑dhɛ 'gü, kö za 'yaa‑ ‑nu ‑bha. \"Kɛɛ ‑a ‑nu \"yan ꞊ya ‑da ‑dhɛ 'gü, ꞊wa ‑ya mü 'zü yaa n Dë yi ‑san ꞊yaa‑ ‑nu kë, ꞊ya kë \"dhʋ̈ kö‑ ‑nu ‑dha za bha‑ ‑gɔ ‑dhɛ 'bhaa 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","\"Kɛɛ ‑yö ‑kë \"dhʋ̈ kö 'pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑bha 'tɔng‑ 'sëëdhɛ 'wo‑ pö wo 'dhang ‑bho \"dhiʋ̈ bha‑ 'gü ꞊dhɛ: ‹N ‑san ‑ya ‑nu ‑kë \"wɛɛwɛɛ ‑a ‑gɛn 'bhaa 'dhö› bha ꞊në‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","27","꞊Dhɛ 'ö ‑kë ꞊dhɛ ka ‑gun n \"piʋ̈ yë ya‑ zübhodhɛ 'gü bha 'ma 'dho, tɛanwɔn pö 'Nii‑ 'ö go n Dë \"piʋ̈ bha‑ ‑dho ‑a ‑gbadhɛ ‑gɔ kö ‑ya bɔ ka ‑dhɛ kö ‑yö ka ‑ta 'kun kö ‑yö n ‑dhiang zë ka ‑dhɛ. Kö kaa ‑dɩ 'pö 'ka‑ \"sɛɛdhɛ kë n ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'Yö Yesu ‑ya pö 'zü ö ‑bha ꞊klang ‑nu ‑dhɛ 'ö‑ pö: «A‑ ‑pö ka ‑dhɛ \"dhʋ̈ kö ka ‑zʋ ꞊në ‑yö ‑gban ka ‑bha ‑zʋ ‑yö Atanna ‑dhɛ ‑sü 'gü, kö 'ka 'dho \"kan‑ ‑wʋ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A‑ ‑pö ka ‑dhɛ ꞊dhɛ ‑wo ‑dho ka ‑gɛn ‑naa 'kpɔ Zuifö ‑nu ‑bha ‑yakwëë ‑kë 'gü ‑kɔ ‑nu 'gü. \"Tʋ̈ng 'bha ‑zian ‑dho ꞊loo 'ö 'wo ka zë, 'ö 'mɛ 'wo ka zë sië \"dhʋ̈ bha 'ö ‑kë ‑nu 'gü ꞊dhɛ ‑wo Atanna ‑dhɔ ꞊në‑ kë sië bha. ");
INSERT INTO daf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","‑A ‑kë \"dhʋ̈ ‑gɛn ‑mü ꞊dhɛ 'wii n Dë dɔ, 'wii n dɔ. ");
INSERT INTO daf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","‑A pö 'a‑ wo sië ka ‑dhɛ \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ kö 'wo‑ kë sië ka 'ka \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü, kö‑ 'wɔn 'ya 'dho ka 'kɔn. 'Mii‑ pö 'ö‑ wo ka ‑dhɛ zü bho ‑yi 'ka bha‑ ‑gɛn ‑mü ꞊dhɛ kö a ‑tun ka \"piʋ̈ yö. ");
INSERT INTO daf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","\"Kɛɛ ‑a \"tʋ̈ng ꞊ya ꞊loo kö 'a 'dho 'mɛ 'ö n bɔ bha‑ ‑dhɛ 'gü. 'Sa mɛ 'bha kö yöö n dhɛɛ\" 'kpɔ ka kpö 'gü ꞊dhɛ «n Dëmɛ, i ‑dho 'mɛ?» 'yaa 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","\"Kɛɛ a‑ 'wɔn ‑dɔ ꞊dhɛ ‑a pö 'a‑ wo ka ‑dhɛ \"dhʋ̈ bha ꞊në ‑wëë bɔ sië ka ‑ta. ");
INSERT INTO daf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","\"Kɛɛ 'sa kö tɛanwɔn ꞊në 'a‑ pö. ‑Yö ‑së ka ‑bha 'ka kö 'a 'dho, ‑a ‑gɛn ‑mü ꞊dhɛ kö 'mii 'dho, 'mɛ 'ö dho ka ‑zʋ ‑gban bha 'yii 'dho nu, \"kɛɛ ꞊ya kë ꞊dhɛ 'ma 'dho 'yö 'a‑ bɔ ka ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'Yö‑ pö 'zü‑ ‑nu ‑dhɛ 'ö‑ pö: «Ka ‑zʋ ‑gban ‑mɛ 'ö \"dhʋ̈ bha ꞊në ꞊ya nu, 'yö dho 'wɔn yaa 'ö \"kpʋngtaamɛ ‑nu ‑wa ‑kë bha‑ ‑zɔn ‑nu ‑dhɛ 'kpakpadhö 'yö 'wo‑ dɔ. 'Yö tɛanwɔn 'dhö Atanna \"piʋ̈ 'klɔɔ‑ 'ö‑ 'gü, ‑a pö 'ö‑ wo ꞊dhɛ za ‑ya ‑nu ‑bha bha‑ ‑wɔn 'gü bha, waa za bha 'ö dho‑ ‑nu zë 'klɔɔ‑ 'ö‑ ‑bha bha 'yö 'wo‑ dɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","'Yö 'wo‑ 'wɔn dɔ ꞊dhɛ ‑a pö 'ö Atanna ‑ya wo ꞊dhɛ za ‑ya ‑nu ‑bha bha‑ 'klɔɔ‑ ‑mü 'dhang 'ö 'wii‑ bho n \"dhiʋ̈ bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","'Yö 'wo‑ 'wɔn dɔ 'zü ꞊dhɛ tɛanwɔn ‑kë Atanna \"piʋ̈ ‑sü bha‑ 'klɔɔ‑ ‑mü nu 'a‑ wo 'ö 'wii‑ dɔ ꞊dhɛ n Dë Atanna ꞊në n bɔ, 'ö maa n yee kë kö 'a 'dho, \"kɛɛ 'ö 'dho 'ö maa‑ wo bha 'wii 'dho n yö 'zü bha ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","'Yö 'wo‑ 'wɔn dɔ ꞊dhɛ za 'ö dho‑ ‑nu zë kö 'wii 'dhang bho n \"dhiʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ Sɔtraan 'ö ‑gblüdë 'ka \"kpʋng ꞊taa, 'ö 'wo bɔ‑ 'ka bha za ꞊yaa‑ zë 'nu ('yö 'wo‑ 'wɔn dɔ ꞊dhɛ 'dhang ‑bho n \"dhiʋ̈ ‑sü ‑dɩ doseng ꞊në ꞊sɔng bho mɛ ‑bha Atanna wëëdhö).» ");
INSERT INTO daf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'Yö‑ pö: «Ka ꞊klang ‑kë 'ka ‑wɔn 'gbɛ ꞊dede ‑yö n ‑gɔ, \"kɛɛ 'kii 'dho ꞊mɔɔ‑ ꞊gban ‑kwɛɛ 'sü ‑sü bha \"tʋ̈ng ya‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","\"Kɛɛ ka ‑zʋ ‑gban ‑mɛ 'ö ‑kë tɛanwɔn pö 'Nii‑ 'ka bha ꞊në ꞊ya nu, 'yö dho zun ka ‑dhɛ \"dhiʋ̈, 'yö tɛanwɔn suu ꞊gban \"pɛpɛ 'do 'do ‑zɔn ka ‑dhɛ. 'Yii 'dho ö ‑dɩ 'gü ‑dhiang zë ka ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ 'yaa ö ‑dɩ ‑gɔ. 'Wɔn ‑nu 'ö‑ ma n ‑ta, waa‑ 'wɔn ‑nu 'ö dho kë ‑dhɛkpaɔ dhia\" 'gü bha ꞊në 'ö dho ka ꞊klang kë‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yö ꞊në dho n 'tɔ bhɔ, ‑a ‑gɛn ‑mü ꞊dhɛ ma ꞊në 'a dho n ‑wʋ 'kpɔ‑ ‑bha kö ‑yö nu‑ pö ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","'Yö‑ pö: «N Dë ꞊slɔɔpë \"pɛpɛ ꞊gban ‑yö ma ꞊në n ‑bha 'ka. Yö ꞊në‑ ‑wɔn 'gü 'yö 'a‑ pö ka ‑dhɛ ꞊dhɛ ‑wʋ 'a dho‑ 'kpɔ‑ ‑bha ꞊në 'ö dho‑ pö ka ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","'Yö 'go mü 'zü 'ö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «‑A \"tʋ̈ng 'yaa ꞊gblɛɛn 'zü kö ka \"yan ‑yö ꞊fië n 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ (maa 'dho n Dë \"piʋ̈). Kö \"tʋ̈ng 'në 'bha ꞊ya ziö 'zü kö 'ka \"yan ‑dee 'bha ‑kpan n ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö‑ ‑bha ꞊klang ‑nu bha‑ mɛ 'bha ‑nu 'wo ‑ya wo 'ko dhɛɛ\" 'kpɔ ‑sü ‑bha 'wo‑ pö: «'Yö ꞊yaa‑ pö ꞊ni kö ‑ya ‑pö ꞊dhɛ 'zü «‑a \"tʋ̈ng 'yaa ꞊gblɛɛn 'zü kö ka \"yan ‑yö ꞊fië n 'ka, kö \"tʋ̈ng 'në 'bha ꞊ya ziö 'zü kö 'ka n yö ‑deewo», \"ɛɛn «maa 'dho n Dë \"piʋ̈» ‑zë 'klɔɔ‑ ꞊në ‑më 'ka? ");
INSERT INTO daf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","\"Tʋ̈ng 'në kö \"wɩ sië‑ 'ka ya ‑më \"tʋ̈ng ‑mü 'yö 'yaa‑ 'gü ma ya?» ");
INSERT INTO daf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","'Yö Yesu ‑ya 'wɔn dɔ ꞊dhɛ ‑ya ‑nu \"piʋ̈ ꞊dhɛ 'wo ö dhɛɛ\" 'kpɔ. ꞊Dhɛ 'ö ꞊yaa‑ 'wɔn dɔ \"dhʋ̈ 'yö‑ ‑nu dhɛɛ\" 'kpɔ 'ö‑ pö: «‑A pö 'a‑ wo ka ‑dhɛ ꞊dhɛ ‑a \"tʋ̈ng 'yaa ꞊gblɛɛn 'zü kö ka \"yan ‑yö ꞊fië n 'ka, kö ꞊ya 'go mü kö \"tʋ̈ng 'në 'bha ꞊ya ziö kö 'ka n yö ‑deewo bha ꞊në‑ 'ka ka 'ko ‑nu dhɛɛ\" 'kpɔ sië‑ 'ka bha ‑ee? ");
INSERT INTO daf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","'Yö‑ pö: «A‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ('ma ga yi 'ö‑ 'ka) ka ‑dho \"gbʋ bɔ 'ö 'ka ‑wëë ‑wʋ ꞊gban suu kpɔ, kö \"kpʋngtaamɛ ‑nu ‑zë ‑wo wo \"dhia bho sië. Ka zuë\" \"dhiʋ̈ ‑dho \"tɛɛ, \"kɛɛ ka ‑bha zuëdhiʋ̈tɛɛ bha 'yö ‑dho \"gla ka ‑gɔ ꞊niidadhe 'gü. ");
INSERT INTO daf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","‑Yö kë ka \"yaan ꞊dhɛ dhebhɔ 'ö‑ 'në yö \"tʋ̈ng ꞊ya ꞊loo, ‑a zuë\" \"dhiʋ̈ ‑yö ‑tɛɛ, ‑a ‑gɛn ‑mü ꞊dhɛ kö yöö ziö \"tʋ̈ng \"gbɩɩ‑ do 'gü. \"Kɛɛ ꞊ya bo 'në yö ‑sü 'ka 'yö‑ ꞊nii ‑yö ‑da, ‑a \"tʋ̈ng 'dhɛ 'kö bha‑ 'gü kö‑ ‑zʋ ꞊ya bhɔ sëë 'ö‑ bho bha‑ 'ka 'ö mɛbhɩɩdhe ‑dhü do 'ö ‑da \"kpʋng ꞊taa bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","‑Kɔ do bha ꞊në ka zuë\" 'dhö ꞊gbaɔn sië‑ 'ka \"tʋ̈ng ya‑ 'gü, \"kɛɛ a ‑dho ka yö 'zü ‑deewo (kö 'ma 'go ga 'gü 'ma ‑bö), 'yö ka zuë\" ꞊nii ‑yö ‑da. ‑A zuëniidadhe 'dhɛ 'kö bha mɛ 'bha ‑kɔ 'yii 'dho ꞊mɔɔ‑ ‑sü ka ‑gɔ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","‑A yi 'ö bha ꞊ya ꞊loo yi 'ö 'ka, 'kii 'dho n dhɛɛ\" 'kpɔ 'wɔn \"wɛɛ 'bha 'ka 'zü; ‑a ‑gɛn ‑mü ꞊dhɛ a‑ ‑pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ ‑a yi 'ö bha‑ 'ka, pë \"pɛpɛ ka dho‑ ‑gbadhɛ n Dë ‑gɔ n 'tɔ 'gü, ‑yö ‑dho ‑a kë ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ ('ö go ka ‑da n ꞊keng‑ ‑yi ‑bha) 'ö dho 'ö zun‑ 'ka ꞊dɛɛ ‑bha, 'kii pë ‑gbadhɛ n Dë ‑gɔ n 'tɔ 'gü do, \"kɛɛ ‑a \"tʋ̈ng ꞊ya ꞊loo ꞊tɔn kö 'ka pë ‑gbadhɛ kö ‑ya kë ka ‑dhɛ (kö ka zuë\" 'ya 'dho 'to ꞊taama 'wɔn 'bha 'gü,) \"kɛɛ kö ka ꞊nii ‑yö ‑da ‑tɛkpɛ ‑tɛkpɛdhö.» ");
INSERT INTO daf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","'Yö 'go mü 'zü 'ö‑ pö: «'Sa 'wɔn ‑nu bha a‑ ꞊gban ‑dhiang ‑zë ka ‑dhɛ \"gwënng 'gü, \"kɛɛ ‑a \"tʋ̈ng ‑dho ꞊loo 'ö 'a bo \"gwënng ‑da ka ‑dhɛ ‑sü 'ka, 'ö 'wɔn ‑nu 'wo ‑gban n Dë ‑bha bha 'a‑ ‑dhiang ‑ta ‑pʋ ka ‑dhɛ ‑së 'ka 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","‑A yi 'ö bha ꞊ya ꞊loo, ka ‑dho pë ‑gbadhɛ n Dë ‑gɔ n 'tɔ 'gü. 'Sa 'mii 'dho‑ pö ka ‑dhɛ ꞊dhɛ a ‑dho bhɛa\"‑ ‑dhɛ ka ‑bha 'ka, ");
INSERT INTO daf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","‑a ‑gɛn ‑mü ꞊dhɛ ka ‑dhɔ ‑yö yöö ꞊dede ‑a ‑kë n ‑dhɔ 'ö ka ‑kë 'ö 'ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ yö ꞊në n bɔ bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A‑ pö ka ‑dhɛ tɛan‑ ꞊dede 'ka ꞊dhɛ a ‑go n Dë ꞊në‑ \"piʋ̈ 'yö 'a nu \"kpʋng ꞊taa yö, maa 'go 'zü \"kpʋng ꞊taa yö kö 'a 'dho n Dë do bha ꞊në‑ \"piʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'Yö‑ ‑bha ꞊klang ‑nu 'wo‑ pö‑ ‑dhɛ: «‑A ‑ga bha! I bo 'i‑ wo dhiang ‑zë yi ‑dhɛ \"gwënng 'gü ‑sü 'ka 'i‑ zë sië \"puu 'ka ‑së 'ka bha, ");
INSERT INTO daf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","'ya‑ 'wɔn dɔ ꞊tɔn ꞊dhɛ bhi ‑zë dhɛɛ\" 'kpɔ ‑mɛ ‑zian 'yaa ‑mü i 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ 'wɔn 'bha ‑wɔn 'bha 'yaa ‑bin ‑sü 'ka i ‑gɔ. Yö ꞊në‑ ‑wɔn 'gü 'yö 'yi‑ dɔ ꞊dhɛ i ‑go Atanna \"piʋ̈ tɛan‑ ꞊dede 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Ka 'dhang bho‑ \"dhiʋ̈ ꞊tɔn ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","'Yö‑ pö: «‑Ka ‑dhɛ ‑ga, ‑a \"tʋ̈ng ‑yö nu sië 'ö ꞊ya ꞊loo ‑zianwo 'ö 'ka dho \"kan n ‑zü 'kwëë‑ 'ka n to n do 'ka, 'ö 'ka dho ka ‑gɔ 'kɔɔdhɛ ‑nu 'gü 'do 'do 'ka. \"Kɛɛ 'kö 'zü kaa‑ kë \"dhʋ̈, 'mii 'dho 'to n do 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ n Dë ‑yö n \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","'Wɔn ‑nu bha a‑ ‑nu ‑pö ka ‑dhɛ \"dhʋ̈ kö ka zuë\" ꞊në ‑yö 'waanu kwɛng‑ ‑nu kwa ‑bha ‑kë 'ko \"piʋ̈ ‑sü bha‑ 'gü; ‑a ‑gɛn ‑mü ꞊dhɛ ka ‑dho sëë bho ꞊dedewo \"kpʋngtaadhɛ ya‑ 'gü, \"kɛɛ ‑ka ka faan dɔ, n ‑kɔ ꞊ya ziö \"kpʋngtaadhɛ ‑gɔ.» ");
INSERT INTO daf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","꞊Dhɛ 'ö Yesu ꞊ya ö bo‑ pö \"dhʋ̈ ‑sü 'ka, 'yö ö \"yan \"dhiʋ̈ ꞊wlü dhang‑ 'gü 'ö ꞊bhɛa Atanna ‑dhɛ 'ö‑ pö: «N Dë, ‑a \"tʋ̈ng bha ꞊ya ꞊loo, ‑bhö ma 'a i Gbö 'ka bha n 'tɔ bhɔ kö mang ‑dɩ 'pö 'a i 'tɔ bhɔ! ");
INSERT INTO daf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","‑A ‑gɛn ‑mü ꞊dhɛ ‑kɔ ‑ziö mɛbhɩɩdhe ꞊gban \"pɛpɛ ‑gɔ ‑sü ‑faan 'i‑ nu n ‑dhɛ bha, i‑ ‑kë \"dhʋ̈ kö 'a ꞊sii 'ö 'yaa yën ꞊në‑ nu mɛ \"pɛpɛ 'i‑ ‑nu nu n ‑dhɛ bha‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","\"Kɛɛ 'sa kö ꞊sii 'ö 'yaa yën \"dhʋ̈ bha‑ ‑nu ‑a ‑nu ‑dhɛ ‑kɔ 'ö 'dhö yö mü ꞊dhɛ kö 'mɛ 'wo \"dhʋ̈ bha ‑wo bhi 'ö 'i ‑kë Atanna doseng 'ö 'dhö ‑a 'ka bha bhi ꞊në i dɔ, kö ‑wo mang Yesu Klisi ‑mɛ 'i n bɔ bha n dɔ 'pö. ");
INSERT INTO daf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nu 'a‑ wo \"kpʋng ꞊taa yö bha 'ma i 'tɔ bhɔ, yë 'i‑ nu n ‑dhɛ kö 'a‑ kë bha 'ma‑ ꞊gban kë 'ma‑ ‑gɔ dɔ. ");
INSERT INTO daf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","꞊Dhɛ 'ö \"dhʋ̈, n Dë, 'tɔbhɔdhe 'ö gun n ‑gɔ ‑blɛɛsü i \"sɔɔ kö \"sɛ 'yaa 'dhö bha, ‑bhö ‑a nu n ‑dhɛ 'zü ‑deewo ꞊dhɛ ‑kɔ bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","'Mɛ 'i‑ ‑nu sü \"kpʋngtaamɛ ‑nu kpö 'gü 'i‑ nu n ‑dhɛ bha, 'ma i dɔ ‑kɔ ꞊gban pö‑ ‑nu ‑dhɛ. 'Mɛ 'wo \"dhʋ̈ bha ‑wo ‑gun i ‑bha 'ka ‑blɛɛsü, 'yö 'i‑ ‑nu nu n ‑dhɛ, ‑wo i ‑wʋ bha‑ ꞊bhlëë ‑ya ‑sü 'ka 'pö. ");
INSERT INTO daf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","꞊Waa‑ 'wɔn dɔ ꞊taamasü ya‑ 'gü ꞊dhɛ pë \"pɛpɛ 'a‑ ‑ta ‑pʋ ‑nu ‑dhɛ bha, ‑wo ‑go bhi ꞊në i 'gü, bhi ꞊në 'i n ꞊draan‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","‑A pö 'a‑ wo \"dhʋ̈ bha‑ 'klɔɔ‑ ‑mü ꞊dhɛ ‑wʋ \"pɛpɛ 'i‑ kpɔ n ‑bha bha ꞊në 'a‑ ‑nu ꞊klang ‑kë 'ka, 'yö 'wo 'dhang bho‑ \"dhiʋ̈. ‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, ‑wa 'wɔn dɔ ‑sü 'ka 'kpakpadhö ꞊dhɛ bhi ꞊në 'a go i 'gü, ꞊dhɛ bhi ꞊në 'i n bɔ. ");
INSERT INTO daf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","'Mɛ 'wo \"dhʋ̈ bha a ‑bhɛa i ‑dhɛ wo ꞊në‑ ‑nu ‑wɔn 'gü. 'Mii bhɛa\" i ‑dhɛ mɛ \"wɛɛ \"pɛpɛ 'dhɛ 'wo to bha‑ ‑nu 'bha ‑wɔn 'gü kö 'yii kë 'mɛ 'kö 'i‑ nu n ‑dhɛ bha‑ ‑nu 'ka; ‑a ‑gɛn ‑mü ꞊dhɛ ‑wo bhi ꞊në i ‑bha 'ka. ");
INSERT INTO daf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","i‑ 'wɔn dɔ ꞊dhɛ koo‑ pë ‑yö do, i ‑bha pë ‑zë kö n ‑bha ‑mü, \"ɛɛn 'pë 'ö n ‑bha 'ka 'pö kö ‑yö i ‑bha 'ka. 'Wɔn 'ö‑ ‑wɔn 'gü 'yö ma mɛdhɛ 'bhü 'dhö ‑wo ‑sü 'ka ‑a ‑nu ‑bha bha 'yö bha. ");
INSERT INTO daf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","i‑ 'wɔn ‑dɔ ꞊dhɛ 'go ꞊në maa‑ wo \"kpʋng ꞊taa yö kö 'a nu i \"piʋ̈ bha, \"kɛɛ wo ‑zë ‑wo yö. ꞊Dhɛ 'ö \"dhʋ̈, n Dë \"slʋ̈ʋ̈slʋ̈, ‑bhö ‑a ‑nu ‑maa kë 'gügbɩɩdhɛ 'ö‑ ‑naa 'yaa 'dhö 'ö i 'tɔ 'gü bha‑ 'ka. 'Sa 'tɔ do 'ö \"dhʋ̈ bha ꞊në 'i‑ nu n ‑dhɛ 'pö, \"kɛɛ ‑bhö ‑a kë \"dhʋ̈ kö ‑wo kë do 'pö ꞊dhɛ kwɛng 'ko do ‑kɔ 'ö‑ 'gü bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ \"tʋ̈ng 'a gun‑ 'ka‑ ‑nu \"piʋ̈ \"kpʋng ꞊taa bha, ma ꞊në 'a gun‑ ‑nu ‑maa kë sië i 'tɔ 'gü. 'Ö 'a n ‑zʋ ‑kë mɛ 'dhɛ 'kö 'i‑ n ‑dhɛ bha‑ ‑nu \"piʋ̈ 'ö‑ mɛ do ‑zian 'yii ꞊dhɛng, kö 'yii kë mɛ 'dhɛ 'kö‑ ‑bha gun ‑bɛn zë ‑sü 'ka i ‑wʋ 'gü ꞊dhɛ ‑yö ‑dho kë \"dhʋ̈, kë \"dhʋ̈ kö 'pë 'ö i ‑wʋ ‑ya pö ‑a 'gü ‑wɔn ‑yö kë bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","꞊Dhɛ 'ö \"dhʋ̈ ‑a \"tʋ̈ng ꞊ya ꞊loo kö 'a nu i \"piʋ̈, \"kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ a ‑tun \"kpʋng ꞊taa bha, a‑ ‑pö i ‑dhɛ \"dhʋ̈ yö ꞊në‑ 'gü kë \"dhʋ̈ kö ma zuëniidadhe ‑yö kë‑ ‑nu ‑gɔ kö‑ ‑nu zuë\" ꞊nii ‑yö ‑da ‑tɛkpɛ ‑tɛkpɛdhö, kö‑ \"piʋ̈ 'ya 'dho 'to. ");
INSERT INTO daf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","I ‑wʋ bha ꞊në 'a‑ \"dhiʋ̈ ꞊loo‑ ‑nu ‑bha 'yö 'wo 'dhang bho‑ \"dhiʋ̈ 'yö‑ ‑nu ‑san 'dhö \"kpʋngtaamɛ ‑nu ‑kë, ꞊Dhɛ 'ö ‑kë ꞊dhɛ yaa \"kpʋngtaamɛ ‑nu 'yaa do, 'ö woo ‑dɩ 'pö 'waa ꞊dhɛ ‑a ‑nu 'dhö 'zü bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Mii bhɛa\" i ‑dhɛ kö 'i‑ ‑nu bho \"kpʋng ꞊taa yö, \"kɛɛ kö 'i‑ ‑nu ‑maa ꞊në‑ kë mɛ yaa bha‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","'Waa \"kpʋngtaadhɛ ‑bha 'ka 'zü ꞊dhɛ 'maa \"kpʋngtaadhɛ ‑bha 'ka 'pö ‑kɔ 'ö‑ 'gü bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","‑Bhö dɔ \"gbɩɩ‑ yö ꞊në‑ ‑wɔn 'gü, n Dë, kö 'i‑ ‑nu \"zu i ‑bha tɛanwɔn bha‑ 'ka kö ‑wo kë \"slʋ̈ʋ̈slʋ̈. Tɛanwɔn bha yö ‑mü i ‑wʋ ꞊në‑ 'ka, (kö i ‑wʋ bha 'i‑ ‑ta \"pʋ‑ ‑nu ‑dhɛ kö ‑yö kë‑ ‑nu ‑ya i ‑bha ‑ya 'gü ‑kɔ 'ka). ");
INSERT INTO daf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'i n bɔ ‑kɔ do 'ö‑ 'gü \"kpʋng ꞊taa bha, mang ‑dɩ 'pö 'ma‑ ‑nu bɔ ‑kɔ do bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","'Wɔn 'ö‑ ‑wɔn 'gü 'yö 'a n ‑dɩ nu i ‑dhɛ ‑a ‑nu ‑wɔn 'gü bha 'yö bha, kë \"dhʋ̈ kö woo ‑dɩ 'pö ‑wo kë i ‑bha 'ka ꞊dedewo 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","꞊Ya kë \"dhʋ̈ kö 'mii bhɛa\" i ‑dhɛ woo do ‑a ‑nu ‑wɔn 'gü, kö a ‑bhɛa i ‑dhɛ 'pö mɛ \"pɛpɛ 'ö 'mɛ 'wo bha 'wo dho n ‑dhiang zë‑ ‑nu ‑dhɛ, 'ö 'wo dho 'dhang bho‑ \"dhiʋ̈ ‑a ‑nu ‑wʋ \"dhiʋ̈ bha ꞊në‑ ꞊gban \"pɛpɛ ‑wɔn 'gü bha do. ");
INSERT INTO daf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kë \"dhʋ̈ kö ‑a ‑nu ꞊gban \"pɛpɛ ‑wo kë do ꞊dhɛ ‑kɔ 'ö kwɛng 'ko ko \"kʋʋ‑ ‑bha bha‑ 'dhö kö ‑wo 'to ‑kplü ‑sü 'ka ko ‑bha kpɛnngkpɛnngdhö, kë \"dhʋ̈ kö \"kpʋngtaamɛ ‑nu ‑wo 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ bhi ꞊në 'i n bɔ tɛan‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","'Tɔbhɔdhe 'i‑ nu n ‑dhɛ bha 'ma‑ nu‑ ‑nu ‑dhɛ 'pö, kë \"dhʋ̈ kö ‑wo kë do ꞊dhɛ kwɛng 'ko do ‑kɔ 'ö‑ 'gü bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kö 'a kë‑ ‑nu 'gü ꞊dhɛ 'i n 'gü ‑kɔ 'ö 'gü bha‑ 'dhö kö ‑a ‑nu ‑bha kë do ‑sü \"piʋ̈ 'ya 'dho 'to. Kë \"dhʋ̈ kö \"kpʋngtaamɛ ‑nu ‑wo 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ bhi ꞊në 'i n bɔ, ꞊dhɛ ‑a ‑nu ‑dhɔ ‑yö i ‑kë 'pö ꞊dhɛ ‑kɔ 'ö n ‑dhɔ ‑yö i kë‑ 'ka bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","꞊Dhɛ 'ö \"dhʋ̈, n Dë, bhi ꞊në 'i‑ ‑nu nu n ‑dhɛ. 'Wɔn 'ö n 'gü ‑wɔn 'ka ‑yö ‑mü ꞊dhɛ kö ‑dhɛ 'a dho kë‑ 'gü bha ‑wo kë mü 'pö, kö 'tɔbhɔdhe 'i‑ nu n ‑dhɛ n ‑dhɔ 'ö i ‑kë kö 'bhii \"kpʋngtaadhɛ ‑da ꞊kö ‑a ‑wɔn 'gü bha ‑wa ‑dhɛ yö. ");
INSERT INTO daf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","N Dë Atanna, bhi 'ö 'bhaa 'kpɔ tɛanwɔn 'ka, 'ö pö 'aa i ‑bha bha \"kpʋngtaamɛ ‑nu ꞊në 'waa i dɔ, \"kɛɛ ma ‑zë a i ‑dɔ, 'mɛ 'wo ya 'pö ‑wa 'wɔn ‑dɔ ꞊dhɛ bhi ꞊në 'i n bɔ. ");
INSERT INTO daf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Ma i ‑wɔn ‑ta \"pʋ‑ ‑nu ‑dhɛ \"pɛpɛdhö, \"kɛɛ a ‑tun 'zü ‑a ‑ta \"pʋ‑ ‑nu ‑dhɛ, kë \"dhʋ̈ kö n ‑dhɔ 'dhö i ‑kë ‑kɔ do 'ö‑ 'gü bha n ‑dhɔ ‑ya ‑nu kë 'pö ‑kɔ do bha‑ 'gü, kö 'a kë‑ ‑nu zuë\" 'gü \"tʋ̈ng ꞊gban 'gü. ");
INSERT INTO daf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","꞊Dhɛ 'ö Yesu ꞊ya ö bo ‑bhɛa Atanna ‑dhɛ ‑sü 'ka ꞊dhɛ ‑kɔ bha‑ 'dhö, 'yö waa‑ ‑bha ꞊klang ‑nu 'wo ‑ziö 'wo dho 'wo \"yi 'wo‑ Sedrɔn ‑kë bha‑ ‑kan, 'yö 'wo dho‑ ꞊taama. \"Dhü ‑bhlaa 'bha ‑yö ‑gun ‑dhɛ bha‑ 'gü, 'yö 'wo dho‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","‑Dhɛ 'wo dho‑ 'gü \"dhʋ̈ bha‑ ‑dhɛ ‑gun Zuda 'ö ‑da ‑dhɛ pë \"piʋ̈ bha‑ \"yaan, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö waa‑ ‑bha ꞊klang ‑nu ꞊wa 'dho mü ‑blɛɛsü wo ‑nu wo. ");
INSERT INTO daf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","꞊Dhɛ 'ö 'mɛ 'wo bha waa‑ Yesu ‑nu ꞊wa 'dho \"dhʋ̈, 'yö Zuda ‑dɩ 'pö 'ö ‑ziö 'ö dho mü, waa‑ Wlɔmö \"sɔdha ‑nu, waa‑ \"yan ‑to Atanna ‑dhɔkëgükɔ ‑bha ‑mɛ ‑nu, waa‑ 'mɛ 'ö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Fadhiziɛn ‑nu 'wo‑ ‑nu bɔ kö ‑wo Yesu 'kun bha‑ ‑nu kpö 'kpii‑ bha‑ 'dhö. Kö ‑dhangbha ‑nu, \"sɔng ‑nu waa‑ 'ko ‑zë 'ka ‑kwɛɛ ‑nu ‑wa ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","'Ö gun \"dhʋ̈ kö 'wɔn 'ö nu sië‑ këwɔn 'gü bha‑ ꞊gban ‑naa ‑yö Yesu ‑zë \"yaan. ꞊Dhɛ 'ö ꞊yaa‑ ‑nu yö kö ‑wo nu sië, 'yö go ö ‑bha ꞊klang ‑nu kpö 'gü 'ö dho‑ ‑nu \"dhiʋ̈ ‑gɔ, 'yö‑ pö‑ ‑nu ‑dhɛ: «'De ꞊në 'ka‑ mɔɔ‑ sië?» ");
INSERT INTO daf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Yesu 'ö go Nazadhɛtö bha‑ yö.» 'Yö‑ pö‑ ‑nu ‑dhɛ: «‑Ɛɛ! Kö ma ꞊nɛ 'sa.» 'Ö \"dhʋ̈ bha kö Zuda 'ö ‑da ‑dhɛ pë \"piʋ̈ bha ‑ya ‑nu kpö 'gü mü. ");
INSERT INTO daf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","꞊Dhɛ Yesu ꞊ya ö bo‑ ‑pö ‑nu ‑dhɛ ‑sü 'ka ꞊dhɛ «kö ma ꞊në 'ka n mɔɔ‑ sië bha», 'yö 'wo go‑ ‑bha wo zun wo zü 'ka. ");
INSERT INTO daf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","'Yö‑ ‑nu dhɛɛ\" kpɔ 'zü 'bha wo 'ö‑ pö: «A‑ pö de ꞊në 'ka‑ mɔɔ‑ sië?» 'Yö 'wo‑ pö: «Yi‑ ‑pö Yesu 'ö go Nazadhɛtö bha.» ");
INSERT INTO daf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈ 'yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «'Ma‑ pö ka ‑dhɛ 'nu ꞊dhɛ ma ꞊në 'wo n ‑dhɛ \"dhʋ̈, 'ö ꞊ya kë ꞊dhɛ 'ka ma ꞊në n mɔɔ‑ sië ‑zë wo kö ‑ka ka kwaa‑ 'mɛ 'kö 'wo ya‑ ‑nu ‑zü kö wo ‑zë ‑wo 'dho.» ");
INSERT INTO daf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","‑Wʋ 'ö Yesu ‑ya pö kö ‑yö bhɛa\" sië Atanna ‑dhɛ 'ö‑ pö: «N Dë, 'i mɛ \"pɛpɛ 'ö‑ nu n ‑dhɛ ‑a 'bha 'gü 'yii see‑ n ‑kɔ ‑ta bha‑ 'gü ‑wɔn kë ‑kɔ ꞊në gun bha.» ");
INSERT INTO daf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","'Ö gun \"dhʋ̈ kö‑ ‑bha ꞊klang ‑nu bha‑ mɛ 'dhɛ 'wo‑ ‑dhɛ Simɔ Piɛdhö bha ‑siang ga do ‑ya ‑gɔ. 'Yö‑ bho ö ‑kpee 'gü, 'yö \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ ‑bha gwëëmi zɔn‑ 'ka \"wɛ \"bɛidhö, 'yö‑ ‑kɔ ‑së 'gü \"tʋ kpö bho‑ 'ka mü. 'Mɛ 'wo‑ \"tʋ kpö bho 'mü \"dhʋ̈ bha ‑wa ‑dhɛ Masiusö. ");
INSERT INTO daf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","\"Kɛɛ ꞊dhɛ 'ö Piɛdhö ꞊yaa‑ kë \"dhʋ̈ 'yö Yesu ‑ya pö‑ ‑dhɛ: «Piɛdhö, i ‑bha ‑dhaa bha‑ ‑da ‑kpee 'gü! ‑A pö 'a‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ ‑a ‑dhɛa ‑bha ꞊dhɛ saan\" 'ö n Dë \"piʋ̈ ꞊dhɛ 'a‑ wo bha 'a‑ wo. ");
INSERT INTO daf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö \"sɔdha kpö 'wo nu bha waa‑ ‑nu ‑gɔmɛ waa‑ \"yan ‑to Atanna ‑dhɔkëgükɔ ‑bha ‑mɛ ‑nu 'ö Zuifö ‑nu ‑wa bɔ bha 'wo Yesu kun, 'yö 'wo‑ ‑lö. ");
INSERT INTO daf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","꞊Dhɛ ꞊wa bo‑ ‑lö ‑sü 'ka, mɛ ‑blɛɛsü 'wo dho‑ 'ka‑ ‑kuu \"dhiʋ̈ bha ‑wa ‑dhɛ Anö (yö ꞊në gun \"saabhomɛ 'kpii‑ ziisü 'ka \"tʋ̈ng bha‑ 'gü). 'Ö gun \"dhʋ̈ ‑kwɛ bha‑ ‑ta kö Kaifö ꞊në Atanna ‑bha \"saabhomɛ 'kpii‑ 'ka, 'yö Anö ‑zë 'dhu ‑yö gun Kaifö bha‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","'Sa Kaifö bha ꞊në kë‑ pö kö Zuifö ‑nu ‑gɔmɛ ‑nu ꞊wa ꞊loo 'ko ‑ta 'ö‑ pö ꞊dhɛ: «Mɛ doseng ‑ga \"sɛ 'gü ‑mɛ ꞊gban \"pɛpɛ ‑wɔn 'gü ‑sü ‑zë fië‑ ‑dhö mɛ ꞊gban 'gü see‑ ‑sü ‑bha» bha. ");
INSERT INTO daf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","꞊Dhɛ 'ö ꞊wa Yesu 'kun 'wo dho sië‑ 'ka, 'yö Simɔ Piɛdhö waa‑ ‑bha ꞊klang ‑nu bha‑ mɛ \"wɛɛ do ‑wo ‑ziö 'wo dho‑ ꞊keng‑. 'Ö gun \"dhʋ̈ kö \"saabhomɛ 'kpii‑ bha ‑ya ‑bha ꞊klang ‑nu bha‑ mɛ 'dhɛ 'ö waa‑ Piɛdhö 'wo dho‑ ꞊keng‑ bha‑ ‑dɔ. ꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊loo \"saabhomɛ 'kpii‑ bha‑ ‑gɔ \"kwɛandhö, 'yö ꞊klangdhiʋ̈ \"wɛɛ do 'dhɛ 'ö bha waa‑ Yesu ‑zë 'wo ‑da \"kwɛandhɛ yaan‑ bha ‑dhɛ ꞊dede 'gü wo \"kwëë. ");
INSERT INTO daf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","'Yö Piɛdhö ‑zë 'ö to \"kwɛandhɛ bha‑ \"dhi ‑wo ‑dhɛ 'gü \"kpɛnng. 'Yö‑ mɛ 'dhɛ waa‑ Yesu 'wo ‑da \"kwɛandhɛ yaan‑ ‑bha, 'ö gun \"saabhomɛ ‑nu ‑gɔmɛ dɔ ‑mɛ 'ka bha 'ö dho \"kpan \"dhiʋ̈, ‑da \"kwɛandhö ‑dhɛ 'gü, 'yö dhiang zë dhebhɔ 'ö gun 'kɔdhi ‑maa kë sië bha‑ ‑dhɛ, 'yö Piɛdhö ‑da 'kɔɔdhö. ");
INSERT INTO daf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","꞊Dhɛ 'ö Piɛdhö gun ‑da sië 'kɔɔdhö, 'yö dhebhɔ bha 'ö Piɛdhö dhɛɛ\" kpɔ 'ö‑ pö: «'Mɛ 'wo‑ kun ya‑ ‑bha ꞊klang ‑nu bha‑ mɛ do 'yaa ‑mü i 'ka \"wɛ ‑ee?» 'Yö Piɛdhö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Aa! ꞊Iin \"dhɛ! ‑A ‑bha pë 'bha ‑pë 'bha 'yaa ‑mü n 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","'Ö gun \"dhʋ̈ kö gwëëzë ‑nu waa‑ 'mɛ 'wo‑ ‑nu bɔ bha ꞊wa pɛng ‑ya 'dhuëngtadhɛ bha‑ 'gü kö ‑wo dɔ sië‑ ‑bha. ‑A kë 'wo‑ wo \"dhʋ̈ bha‑ ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ \"tʋ̈ng bha‑ 'gü kö \"nɛnɛ ‑yö ziö sië. 'Yö Piɛdhö ‑yö dho 'pö ‑dɔ pɛng ‑bha ‑dhɛ 'gü ‑a ‑nu \"piʋ̈ mü. ");
INSERT INTO daf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö Anö 'ö gun \"saabhomɛ ‑nu ‑gɔmɛ zii 'ka bha 'ö Yesu dhɛɛ\" kpɔ ‑a ‑bha ꞊klang ‑nu 'waa‑ ‑bha mɛ draan‑ ‑kɔ ‑nu ‑wɔn 'ka. ");
INSERT INTO daf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «\"Tʋ̈ng \"pɛpɛ 'a gun mɛ ꞊klang kë sië‑ 'ka 'maa gun‑ 'bha kë sië ‑gblɛn 'kpɔ 'gü, a ‑gun ꞊gban kë sië Zuifö ‑nu ‑bha ‑yakwëëkëgükɔ ‑nu \"ɛɛn ‑a ‑nu ‑bha Atanna ‑dhɔkëgükɔ ꞊në‑ 'gü, 'ö 'a dhiang zë mɛ ꞊gban \"pɛpɛ wëëdhö kö Zuifö ‑nu ꞊wa bho 'ko ‑ta, 'ö dhiang ‑nu 'a‑ zë 'mii‑ 'bha zë ‑gblɛn 'kpɔ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","꞊Dhɛ 'ö \"dhʋ̈, ma ‑zë n dhɛɛ\" 'kpɔ ‑dhɛ 'yaa‑ ‑bha. 'Mɛ 'wo gun wo \"tʋ 'to sië n ‑wʋ ‑bha bha ꞊në ‑bhö ‑a ‑nu dhɛɛ\" 'kpɔ, 'pë 'a‑ pö‑ ‑nu ‑dhɛ ‑ya ‑nu \"yaan.» ");
INSERT INTO daf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dhiang bha ‑yö ‑to Yesu \"dhi 'yö \"yan ‑to Atanna ‑dhɔkëgükɔ ‑bha ‑mɛ ‑nu bha‑ mɛ do 'bha 'ö gun mü bha 'ö‑ ‑gɔ ‑ma, 'yö‑ pö‑ ‑dhɛ: «I dhiang ‑yɔ ‑bɔ \"saabhomɛ ‑nu ‑gɔmɛ 'kpii‑ ‑gɔ ‑kɔ ꞊në bha ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","'Yö Yesu ‑ya pö‑ ‑dhɛ: «Dhiang 'a‑ zë ya‑ ‑mɛɛ ꞊në dhiang yaa 'ka? ‑A 'dhɛ 'ö dhiang yaa 'ka ‑a pö n ‑dhɛ. 'Ö ꞊ya kë 'zü ꞊dhɛ 'mii dhiang yaa zë kö n ‑gɔ 'i‑ ‑ma ya‑ ‑ma ‑gɛn ‑mü ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Anö ‑yö Yesu to ‑lö ‑sü 'ka \"dhʋ̈ 'yö‑ bɔ \"saabhomɛ 'kpii‑ 'wo‑ Kaifö ‑kë bha‑ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","\"Tʋ̈ng 'wo gun‑ kë sië‑ 'ka \"dhʋ̈ bha kö Piɛdhö ‑yö dɔ sië pɛng ‑bha mü. 'Yö 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Bhii ‑dɩ 'pö 'mɛ 'ö ya‑ ‑bha ꞊klang ‑nu bha‑ mɛ do 'yaa ‑mü i 'ka nu \"wɛ ‑ee?» 'Yö‑ ꞊zaɔ 'zü 'ö‑ pö: «'Mɛ bha‑ ‑bha mɛ 'bha 'yaa ‑mü n 'ka tongtongdhö!» ");
INSERT INTO daf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö \"saabhomɛ ‑nu ‑gɔmɛ ‑bha gwëëzë ‑nu bha‑ mɛ do 'ö ‑kë 'mɛ 'ö Piɛdhö ‑ya \"tʋ kpö sü mü bha‑ ‑gɔ \"kwɛangümɛ do 'ka bha 'ö‑ pö‑ ‑dhɛ 'ö‑ pö: «\"Kɛɛ ma ‑zë a kë i ‑yö ‑a ꞊keng‑ \"dhɛ. \"Ɛɛn kɛng‑ ‑nu 'aa mü 'ka gun \"dhü ‑bhlaa 'gü tii‑ ‑dhö ya ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","'Yö Piɛdhö ‑ya zaɔ‑ 'zü ‑deewo. ‑Yö ‑to mü 'yö ‑tɔgɔn ‑yö ‑wɩ. ");
INSERT INTO daf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö 'wo go Yesu 'ka Kaifö ‑gɔ \"kwɛandhö 'wo dho‑ 'ka ‑gblüdë 'ö gun \"sɛ bha‑ ‑gɔ \"dhiʋ̈ \"tʋ̈ng bha‑ 'gü bha‑ ‑gɔ zadɔgükɔ \"dhiëngdhö. Yö ‑zë 'ö gun kë sië \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü bha kö ‑dhɛ ꞊ya ꞊kpaɔ, \"kɛɛ 'mɛ 'wo dho Yesu 'ka \"dhʋ̈ bha Zuifö ‑nu ‑gɔmɛ ‑nu 'wo gun‑ ‑nu kpö 'gü bha wo ‑zë 'wii ‑da ‑gblüdë ‑bha zadɔdhɛ bha‑ 'gü, kë \"dhʋ̈ kö 'wa 'dho wo ‑dɩ \"kian zë 'ö‑ ‑nu ‑bha Pakö ‑bhöpë ‑bhö ‑sü ‑yö ꞊see. (‑A ‑gɛn ‑mü ꞊dhɛ Zuifö ‑nu 'waa gun ‑da sië 'mɛ 'waa Zuifö 'ka‑ ‑nu ‑gɔ 'kɔɔdhö tongtongdhö.) ");
INSERT INTO daf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pidhatö ‑yö zun \"kpɛnng yö ꞊në‑ ‑wɔn 'gü 'yö dho 'mɛ 'wii ‑da 'kɔɔdhö bha‑ ‑nu ‑dhɛ 'gü 'yö‑ pö‑ ‑nu ‑dhɛ: «'Yö 'kwa‑ ma mü? Ka ‑nu 'mɛ bha‑ 'ka n ‑dhɛ ‑më ‑wɔn 'gü?» ");
INSERT INTO daf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","'Yö 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «'Wɔnyaakëmɛ ‑mü ꞊në‑ wo, 'yaa \"dhʋ̈ 'nu kö 'yii 'dho nu‑ 'ka i ‑kuu \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈, 'yö Pidhatö ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «'Mɛ 'ö bha kaa ꞊dede ‑ka 'dho‑ 'ka kö 'ka‑ ‑bha za dɔ ꞊dhɛ ‑kɔ 'ö ‑bɛn zë ‑sü 'ka‑ 'ka kaa‑ 'tɔng‑ 'gü bha‑ 'dhö!» 'Yö Zuifö ‑nu 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Yi ‑zë ‑a ‑dhɛ 'yaa‑ ‑bha kö 'yi mɛ zë yi ‑dɩ ‑ta.» ");
INSERT INTO daf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","‑A pö 'wo‑ wo \"dhʋ̈ bha ꞊në ‑kë 'pö dhiang 'ö Yesu ‑ya zë ‑blɛɛsü 'ö ‑gban ‑a ga ‑kɔ ‑bha bha‑ 'gü ‑wɔn kë ‑kɔ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","꞊Dhɛ 'ö ꞊waa‑ pö Pidhatö ‑dhɛ \"dhʋ̈, 'yö ‑ziö 'ö dho 'ö ‑da 'zü ‑deewo ö ‑gɔ zadɔgükɔ 'gü, 'yö Yesu ‑dhɛ mü, 'yö‑ pö‑ ‑dhɛ: «Bhi ꞊në 'i Zuifö ‑nu ‑bha ‑gblüdë 'ka ya ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","'Yö‑ ‑yɔ bɔ 'ö‑ pö: «Dhiang 'i‑ zë bha i‑ ‑bho i ‑dɩ 'gü, \"ɛɛn mɛ 'bha ꞊në n ‑wɔn ‑dhiang zë i ‑dhɛ ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","'Yö Pidhatö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N ‑ga 'i‑ wo bha Zuifö ‑mü n 'ka ‑ee? I ‑gɔ \"sɛ 'gü ‑mɛ ‑nu waa‑ kaa‑ \"saabhomɛ ‑nu ‑gɔmɛ ‑nu ꞊në 'aa mü 'wo nu i ‑da ‑dhɛ 'gü n ‑dhɛ ‑ee? ‑Më ꞊në 'i‑ ‑kë?» ");
INSERT INTO daf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «Ma ‑gblüdëdhɛ 'yaa \"kpʋng ꞊taa yö. ꞊Ya kë 'nu ꞊dhɛ ma ‑gblüdëdhɛ ‑yö \"kpʋng ꞊taa yö kö ma gwëëzë ‑nu ‑dho n ta ‑gblü gɔɔn 'nu 'ö Zuifö ‑nu ‑kɔ 'yaa ꞊mɔɔ n ‑bha, \"kɛɛ ‑a ‑ga bha, ma ‑gblüdëdhɛ 'yaa \"kpʋng ꞊taa yö.» ");
INSERT INTO daf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","'Yö Pidhatö ‑ya pö‑ ‑dhɛ: «꞊Ya kë \"dhʋ̈ 'sa kö ‑gblüdë ‑mü i 'ka ‑kɛɛ?» 'Yö Yesu ‑ya pö‑ ‑dhɛ: «꞊Iin, ‑gblüdë ‑mü n 'ka.» Bhɔ 'a‑ wo \"kpʋng ꞊taa yö bha a ‑bhɔ \"dhʋ̈ kö 'a tɛanwɔn ꞊në‑ ‑ta \"pʋ mɛ \"bhɩɩ‑ ‑nu ‑dhɛ. Yö ꞊në‑ ‑wɔn 'gü 'yö mɛ \"ʋʋ mɛ 'ö tɛanwɔn dɔ ꞊në ö \"tʋ 'to n ‑wʋ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","'Yö Pidhatö ‑ya pö‑ ‑dhɛ: «'Ö ‑më? ‑Më ꞊në 'wo‑ ‑dhɛ tɛanwɔn?» ꞊Dhɛ 'ö Pidhatö ꞊ya bo dhɛɛ\" bha‑ ‑kpɔ Yesu ‑gɔ ‑sü 'ka \"dhʋ̈, 'yö zun 'zü ‑deewo \"kpɛnng 'yö dho Zuifö ‑nu ‑gɔmɛ ‑nu bha‑ ‑nu \"piʋ̈, 'yö‑ pö‑ ‑nu ‑dhɛ: «'Aa! Kaa‑ 'mɛ ka nu‑ 'ka n ‑dhɛ bha, 'wɔn 'bha 'kö yöö‑ kë kö 'a‑ dɔ, kö ‑yö kë‑ zë ‑gɛn 'ka 'mii‑ yö \"dhɛ! ");
INSERT INTO daf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","\"Kɛɛ ꞊dhɛ 'ö ‑kë ꞊dhɛ ‑kwɛ ꞊ya zun 'ko \"dhiʋ̈ ‑kɔ 'ö‑ ‑bha 'do 'do Pakö yi 'ka, 'ö 'a mɛ do bho ‑kaso 'gü ka ‑dhɛ bha, ‑yö ka \"piʋ̈ ꞊dhɛ ‑a 'dhɛ ya 'a ‑kɔ bho ka ‑dhɛ de ꞊në‑ 'gü? Zuifö ‑nu ‑bha ‑gblüdë ya ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","꞊Dhɛ 'ö ꞊yaa‑ ‑nu dhɛɛ\" 'kpɔ \"dhʋ̈, 'yö‑ ‑nu ꞊gban \"pɛpɛ 'wo ta wo 'gü 'wo‑ pö‑ ‑dhɛ: «'Aabhoo! Yö ‑zë ‑yö 'to mü kö 'i Badhabasö ꞊në‑ bho mü!» \"Kɛɛ 'sa kö Badhabasö 'kö bha ‑yö ‑gun mɛ zë ‑mɛ ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","꞊Dhɛ 'ö 'mɛ 'wo bha ꞊waa‑ pö Pidhatö ‑dhɛ ꞊dhɛ 'waa Yesu ‑zë \"piʋ̈ \"kɛɛ ‑wa yö ꞊në‑ zë, 'yö Pidhatö ‑ya pö \"sɔdha ‑nu ‑dhɛ ‑wo nu kö ‑wa 'sü kö ‑wa ‑ma ꞊klangga 'ka. ('Yö dho 'zü ‑deewo ö ‑gɔ 'kɔɔdhö.) ");
INSERT INTO daf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","꞊Dhɛ 'ö \"sɔdha ‑nu bha ꞊wa Yesu ‑ma, 'yö 'wo dho 'wo \"glɛɛn 'faan‑ do bɔ, 'yö 'wo‑ ‑ya ‑gɔ ‑bha ꞊wɛɛ ‑dɔ ‑bha kian 'ka ꞊dhɛ ‑a ‑bha ‑gblüdëdhɛ 'faan‑ ꞊në bha. 'Yö 'wo dho 'wo \"gblan \"bhɛɛ do ‑da ‑bha, 'yö 'wo ꞊yɔɔn‑ \"sɔɔ 'wo‑ pö‑ ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","«Zuifö ‑nu ‑bha ‑gblüdë, 'bha ꞊boo mü!» Kö ‑wa \"tʋ ‑nu ‑ma sië. ");
INSERT INTO daf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","꞊Dhɛ 'ö 'wɔn bha 'ö kë sië \"dhʋ̈, 'yö Pidhatö ‑yö zun 'zü ‑dee wo \"kpɛnng, 'yö‑ pö mɛ kpö bha‑ ‑nu ‑dhɛ 'ö‑ pö: «‑Ka ‑dhɛ ‑ga, 'mɛ bha maa‑ 'sü kö 'a nu‑ 'ka ka ‑dhɛ \"kpɛnng yö kö‑ ‑naa kë ka \"yaan ꞊dhɛ ma ‑zë n ‑kɔ 'yaa‑ zë ‑wɔn 'gü.» ");
INSERT INTO daf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","‑Yö Yesu ‑zun \"kpɛnng yö ꞊në‑ ‑wɔn 'gü kö \"glɛɛn 'faan‑ bha ‑ya ‑gɔ ‑bha \"dhʋ̈ waa‑ \"gblan \"bhɛɛ bha‑ ‑dhö. 'Yö‑ pö‑ 'mɛ 'wo bha‑ ‑nu ‑dhɛ: «Kaa‑ 'mɛ bha 'yö ya! ('Pë 'ö ‑dhi ka ‑dhɛ, ‑kaa kë‑ 'ka ꞊tɔn!)»» ");
INSERT INTO daf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","꞊Dhɛ 'ö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ \"yan ‑to Atanna ‑dhɔkëgükɔ ‑bha ‑mɛ ‑nu bha 'wo Yesu yö, 'yö 'wo ‑ya \"gbla ‑sü ‑bha 'wo‑ pö: «‑Kaa dɔ \"dhü ‑bha! ‑Kaa dɔ \"dhü ‑bha! ‑Kaa dɔ \"dhü ‑bha!» 'Yö Pidhatö ‑ya pö‑ ‑nu ‑dhɛ: «'Aa! ꞊Ya 'to yö ‑zë ‑bha kö kaa ꞊dede ‑kaa 'sü 'ka 'dho‑ 'ka 'ka‑ dɔ \"dhü ‑bha ‑wa, 'yaa \"dhʋ̈ ma ‑zë 'wɔn yaa 'kö mɛ zë ‑gɛn bho 'mii‑ yö‑ ‑bha.» ");
INSERT INTO daf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","'Yö Zuifö ‑nu ‑gɔmɛ ‑nu bha 'wo‑ ‑yɔ bɔ‑ ‑gɔ 'wo‑ pö: «Yi ‑bha 'tɔng‑ ‑yö ‑dhö. 'Tɔng‑ 'ö \"dhʋ̈ bha ꞊në‑ pö ꞊dhɛ mɛ 'ö bha‑ ‑dhɛa ‑bha ꞊dhɛ ‑wa zë, ‑a ‑gɛn ‑mü ꞊dhɛ ꞊ya ö ‑dɩ kë Atanna Gbö 'ka». ");
INSERT INTO daf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","\"Suʋ̈ ‑zë ‑yö ‑gun Pidhatö 'gü ‑blɛɛsü \"kɛɛ ꞊dhɛ 'ö‑ \"tʋ ‑yö ‑da ‑wʋ bha‑ 'gü, 'yö‑ ‑ta ‑kpɛa ‑yö dɔ do. 'Yö‑ \"gblʋ̈ʋ̈dhɛ ‑yö \"muu bho, ");
INSERT INTO daf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","'yö ‑sɔ 'zü za dɔ 'gü ‑kɔ bha‑ 'gü ‑deewo 'yö Yesu ‑dhɛ mü, 'yö‑ dhɛɛ\" do 'bha kpɔ 'zü 'ö‑ pö: «A‑ ‑pö bhaa, i‑ ‑pö de suu ‑mü i 'ka \"wɛ kpɛnngdhö?» \"Kɛɛ 'yii‑ ‑yɔ bɔ kö ‑ya ‑yɔ bɔ‑ ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","'Yö Pidhatö ‑ya pö‑ ‑dhɛ: «I \"dhi ‑taga ma ꞊në n ‑wʋ 'ka 'yö 'bhaa \"wɩ bha ‑ee? \"Ɛɛn 'bhaa‑ 'wɔn dɔ ꞊dhɛ a ‑mɔɔ ‑bha 'a i dɔ \"dhü ‑bha \"ɛɛn 'zü 'a i dha ‑ee?» ");
INSERT INTO daf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑A \"sɩ 'yaa i ‑dhɛ 'nu kö 'i pë 'bha kë n 'ka kö Atanna 'kö dhang‑ 'gü bha 'yii \"wɩ‑ ‑bha. 'Wɔn 'ö‑ ‑wɔn 'gü 'yö 'mɛ 'ö n \"dhiʋ̈ dɔ i ‑dhɛ bha ꞊në‑ ‑mɛ ‑bha 'wɔn yaa 'dhö 'kpii‑ 'ö ‑ziö i ‑bha ‑ta bha 'yö bha.» ");
INSERT INTO daf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈, 'yö Pidhatö ‑yö zun‑ \"slë mɔɔ‑ ‑sü ‑bha kö 'ö‑ dha, \"kɛɛ kö Zuifö ‑nu ‑gɔmɛ ‑nu ‑zë ‑wo \"gbla sië \"gbɩɩ‑ 'ka ‑kpɛawo 'wo‑ pö: «꞊Ya kë ꞊dhɛ 'kii i ‑kɔ bho 'mɛ bha‑ 'gü, kö 'bhaa bɔ yii‑ ‑gblüdë 'kpiisü 'ka tongtongdhö, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ \"pɛpɛ 'kö 'wo wo ‑dɩ ‑kë ‑gblüdë 'ka kö‑ 'yaɔ‑ ‑nu ‑mü.» ");
INSERT INTO daf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","꞊Dhɛ 'ö Pidhatö ꞊ya ‑wʋ bha‑ ma 'zü \"dhʋ̈, 'yö Yesu sü 'zü 'yö zun‑ 'ka \"kpɛnng, 'yö dho 'ö ‑ya za ‑dɔ ‑ta ‑gbloo 'gü \"wasi 'wo‑ zadɔgükɔ \"sɔɔ 'wo‑ ‑dhɛ ꞊dhɛ Eblö ‑wʋ 'gü Gabata bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","'Wɔn bha ‑yö ‑kë \"dhʋ̈ yi 'ö ꞊ya 'go mü 'ö Pakö yi ‑yö dɔ mü bha‑ 'ka kö 'yënng‑ ꞊ya ‑ya mɛ ‑gɔ ꞊zinng 'gü. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Pidhatö ‑ya pö Zuifö ‑nu ‑gɔmɛ ‑nu bha‑ ‑nu ‑dhɛ: «Kaa‑ ‑gblüdë bha 'yö ya!» ");
INSERT INTO daf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","\"Kɛɛ 'yö 'wo ‑ya \"gbla ‑sü ‑bha 'zü 'wo‑ pö: «Yi‑ ‑pö ‑a zë ꞊në ‑yö wo, yi‑ ‑pö ‑a zë ꞊në wo, ‑a dɔ \"dhü ‑bha!» 'Yö Pidhatö ‑ya ‑nu dhɛɛ\" kpɔ 'ö‑ pö: «Ka‑ ‑pö 'a kaa‑ ‑gblüdë bha‑ dɔ \"dhü ‑bha tɛan‑ ꞊dede 'ka ‑ee?» 'Yö \"saabhomɛ ‑nu ‑gɔmɛ ‑nu ‑wa ‑yɔ bɔ 'wo‑ pö: «Yii‑ ‑gblüdë \"wɛɛwɛɛ 'bha 'yaa 'dhö kö 'yii kë i ‑gɔmɛ ‑zë 'ka! ‑A dɔ \"dhü ‑bha!» ");
INSERT INTO daf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","꞊Dhɛ 'ö ꞊waa‑ pö \"dhʋ̈ 'yö Pidhatö ‑yö ö ‑kɔ bho Yesu 'gü ‑a ‑nu ‑dhɛ kö ‑wa dɔ \"dhü ‑bha. ꞊Dhɛ 'ö ꞊ya ö ‑wʋ bho‑ ‑ta, 'yö 'wo‑ sü 'wo dho‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","‑A ‑dɔ ‑bha \"dhü bha ‑yö ‑gun yöö ꞊dede ꞊në‑ ‑gɔ 'wo go‑ 'ka 'plöö 'wo dho 'wo ꞊loo‑ 'ka ‑tɔn 'wo‑ mɛ ‑gɔ \"kpɛa ‑tɔn ‑kë, 'wo‑ ‑dhɛ Eblö ‑wʋ 'gü «Gɔgota» bha‑ ꞊gbin‑. ");
INSERT INTO daf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","‑Wo Yesu ‑dɔ \"dhü ‑bha ‑dhɛ bha ꞊në‑ 'gü, 'yö 'wo 'wɔnyaakëmɛ ꞊plɛ dɔ 'pö \"dhü ‑bha ‑a \"sɔɔ mü 'yö 'wo‑ mɛ do dɔ‑ ‑kɔ ‑së 'gü, 'yö 'wo‑ mɛ do dɔ‑ ꞊kwaa 'gü, 'yö dɔ‑ ‑nu ꞊zinng 'gü. ");
INSERT INTO daf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Pidhatö ‑yö ‑wʋ do 'bha ‑bɛn zë 'yö‑ ꞊nëng Yesu ‑dɔ ‑bha \"dhü bha‑ ‑bha 'ö‑ pö: «'Mɛ 'ö ya ꞊në 'wo‑ ‑dhɛ Yesu 'ö go Nazadhɛtö, Zuifö ‑nu ‑bha ‑gblüdë». ");
INSERT INTO daf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","‑Wʋ 'ö Pidhatö ‑ya ‑bɛn zë \"dhʋ̈ bha Zuifö ‑nu 'gbɛ ꞊dede ‑wo kë‑ ‑wʋ ‑pö, ‑a ‑gɛn ‑mü ꞊dhɛ ‑dhɛ 'wo‑ dɔ \"dhü ‑bha ‑a ‑dhɛ 'gü \"dhʋ̈ bha ‑yö ‑gun 'pö‑ \"sɔɔ, 'yö ‑wʋ 'wo‑ ‑bɛn zë 'wo ꞊nëng‑ ‑dɔ ‑bha \"dhü ‑bha bha 'ö gun 'pö ‑bɛn zë ‑sü 'ka eblö ‑wʋ oo, glɛkö ‑wʋ waa‑ Wlɔmö ‑mɛ ‑nu ‑wʋ 'wo‑ dhatɛn ‑wʋ ‑kë bha‑ ꞊gban 'gü. ");
INSERT INTO daf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","'Yö Zuifö ‑nu ‑bha \"saabhomɛ ‑nu ‑gɔmɛ ‑nu 'wo‑ pö Pidhatö ‑dhɛ 'wo‑ pö: «'Bha 'dho‑ ‑bɛn zë 'i‑ pö Zuifö ‑nu ‑bha ‑gblüdë, ‑a pö 'mɛ 'ö‑ pö ꞊dhɛ yö ꞊në 'ö Zuifö ‑nu ‑bha ‑gblüdë 'ka.» ");
INSERT INTO daf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","\"Kɛɛ 'yö Pidhatö ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑A 'dhɛ 'kö 'ma‑ ‑bɛn zë bha 'ma‑ zë, (yö ‑zë 'yii 'dho bho \"gblʋʋ 'zü). ");
INSERT INTO daf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","꞊Dhɛ 'ö \"sɔdha ‑nu bha ꞊wa wo bo Yesu ‑dɔ \"dhü ‑bha ‑sü 'ka, 'yö 'wo‑ ‑bha sɔ ‑nu sü 'wo‑ \"dhɛa ‑yiisiö ‑ya, 'yö 'wo‑ 'gü ‑gblü wo 'ko ‑ta, 'yö mɛ do ‑ya \"dhɛa do sü. 'Yö 'wo‑ ‑bha sɔ 'dhɛ 'ö‑ ‑da sɔ ꞊wlöö bha‑ sü 'pö, \"kɛɛ 'sa yö ‑zë ‑wɔ ‑dhɛ 'yaa gun‑ ‑bha ‑dhɛ 'bha ‑dhɛ ‑bha ‑dhɛ 'bha 'gü, 'yö 'wo‑ pö wo 'ko ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","«'Kwa 'dho‑ \"pɛ, ‑ka nu kö 'kwa‑ zë \"kpʋ̈ü kë kö 'mɛ ꞊yaa‑ zë kö ‑ya 'sü!» 'Yö 'wo‑ ‑kë \"dhʋ̈. ‑A pö 'wo‑ wo \"dhʋ̈ bha ‑yö ‑kë \"dhʋ̈ kö 'pë 'ö Atanna ‑wʋdhiʋ̈loomɛ ‑nu ‑wa pö yi 'bha 'ka, 'ö ‑bɛn zë ‑sü 'ka ‑a ‑wʋ 'sëëdhɛ 'gü ꞊dhɛ: «‑Wo kë n ‑dasɔ ‑nu 'gü ‑gblü wo 'ko ‑ta, 'ö 'wo zë \"kpʋ̈ü ‑kë ma ‑da \"bhɛɛ ꞊wlöö ‑sɔ ‑ta» bha ꞊në‑ 'gü ‑wɔn ‑yö kë. 'Wɔn bha 'yö \"sɔdha ‑nu bha 'wo‑ ‑kë ꞊dhɛ ‑kɔ bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","'Wɔn ‑nu bha 'wo kë sië \"dhʋ̈ \"tʋ̈ng 'ö‑ 'gü bha kö Madhi 'ö ‑kë Yesu dhe 'ka bha waa‑ ö dheebhang dhebhɔ do 'dhö, Madhi 'dhɛ 'ö ‑kë 'pö Klopa ‑bha dhebhɔ 'ka bha‑ 'dhö, Madhi 'dhɛ 'ö go Madadha bha‑ 'dhö, kö ‑wo dɔ sië Yesu ‑zë ‑bha ‑dhü bha‑ \"sɔɔ mü. ");
INSERT INTO daf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","꞊Dhɛ 'ö ꞊ya ö dhe yö kö waa‑ ‑bha ꞊klangdhiʋ̈ 'dhɛ 'ö‑ ‑dhɔ gun‑ kë sië ꞊dedewo bha ‑wo dɔ sië wo 'ko \"sɔɔ mü, 'yö‑ pö ö dhe ‑dhɛ 'ö‑ pö: «Dhebhɔnë, ꞊ya 'go ꞊dɛɛ 'gü i gbö ꞊në dɔ i \"sɔɔ bha.» ");
INSERT INTO daf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","'Yö go mü 'ö‑ pö 'pö ö ‑bha ꞊klangdhiʋ̈ bha‑ ‑dhɛ 'ö‑ pö: «N ‑sëmɛ, ꞊ya 'go 'pö ꞊dɛɛ 'gü i dhe ꞊në dɔ bha.» Yesu ‑bha ꞊klangdhiʋ̈ bha ‑yö ‑to ‑dhɛ do bha‑ 'gü 'ö ö ‑kɔ ‑da Madhi 'gü 'yö zun ö ‑zʋ ‑kë \"piʋ̈ ‑sü ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'ö Yesu ꞊yaa‑ 'wɔn dɔ ꞊dhɛ 'wɔn 'ö nu‑ 'gü \"kpʋng ꞊taa bha ꞊ya ꞊mɔɔ \"kwëë, 'yö‑ pö: «\"Yi mü ‑dhɔ ꞊ya n 'kun.» 'Sa ‑ya ‑pö \"dhʋ̈ kö 'pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'sëëdhɛ 'gü ‑a ‑bu 'gü bha ꞊në‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","\"Tʋ̈ng 'ö‑ pö sië‑ 'ka‑ \"dhʋ̈ bha kö we 'wangwang 'bha ‑yö dɔ ‑sü 'ka \"sɔdha ‑nu bha‑ ‑nu \"sɔɔ pëfië 'bha 'gü mü. ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö 'wo dho 'wo ‑fuu ‑da we bha‑ ꞊bhaa, 'yö 'wo‑ sü 'wo‑ ‑ya \"dhü suu 'bha 'wo‑ izɔpö ‑kë bha‑ ‑gbeng do \"dhiʋ̈, 'yö 'wo‑ ‑da ‑a \"dhi. ");
INSERT INTO daf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","꞊Dhɛ 'ö ꞊yaa‑ ‑kplü 'bha \"kan 'yö‑ pö: «‑A ꞊gbaan zun 'ko \"dhiʋ̈ ꞊tɔn.» ꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö ö ‑gɔ zun \"sɛɛ, 'yö ö 'nii‑ ‑wɔ Atanna ꞊kwɛng. ");
INSERT INTO daf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","'Wɔn \"pɛpɛ bha‑ ꞊gban‑ ‑kë \"dhʋ̈ yi 'ö ꞊ya 'go mü 'ö Zuifö ‑nu ‑bha ꞊glooyi ‑yö dɔ mü bha ꞊në‑ 'ka (\"Kɛɛ ‑a ‑dhɛkpaɔyi 'dhɛ bha ‑yö kë 'ö‑ wo Pakö zübhoyi 'ka bha‑ ‑wɔn 'gü), 'yaa gun Zuifö ‑nu \"piʋ̈ ꞊dhɛ 'mɛ 'wo‑ ‑nu dɔ \"dhü ‑bha \"dhʋ̈ bha‑ ‑nu ꞊gee ‑yö ꞊gloo mü kö‑ ‑nu ꞊glooyi bha ‑yö ꞊loo‑ ‑bha. ‑A ‑gɛn ‑mü ꞊dhɛ ‑a ‑nu ꞊glooyi 'dhɛ 'kö bha Atanna ‑dhɔkë ‑yi 'kpii‑ ꞊në gun yö ‑zë 'ka ‑a ‑nu ‑gɔ. ‑Wo ‑bhɛa Pidhatö ‑dhɛ yö ꞊në‑ 'gü 'wo‑ pö ‑yö dɔ \"gbɩɩ‑ kö ‑yö mɛ bɔ 'mɛ 'wo‑ ‑nu dɔ \"dhü ‑bha bha‑ ‑nu ‑gɛn \"yɛ ‑dhɛ 'gü, (kë \"dhʋ̈ kö ‑wo ga \"vaandhö) kö ‑wa ‑nu bho \"dhü ‑bha. ");
INSERT INTO daf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'Yö \"sɔdha ‑nu 'wo dho 'wo mɛ ‑blɛɛsü ‑gɛn ꞊loo waa‑ \"tɛado 'wo‑ ‑nu dɔ \"dhü bha \"kwëë bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","꞊Dhɛ 'ö ꞊wa zun Yesu ‑bha 'ö ꞊waa‑ 'wɔn dɔ ꞊dhɛ yö ‑zë ꞊ya ga 'nu, 'yö 'wii yö ‑zë kë ‑kɔ 'bha 'gü. ");
INSERT INTO daf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","\"Kɛɛ 'yö‑ \"sɔdha ‑nu bha‑ mɛ do ‑yö 'düga sü 'yö‑ \"sɛn 'gü ꞊zua‑ 'ka, 'yö to 'yö ꞊yɔɔn waa‑ \"yi 'wo go‑ ‑dhɛ 'gü 'wo ꞊wɛnng. ");
INSERT INTO daf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","'Mɛ 'ö 'wɔn bha‑ ‑gɛn dɔ sië ka ‑dhɛ bha yöö ꞊dede ꞊në‑ \"yan ‑yö ‑da ‑a ‑dhɛ 'gü. 'Wɔn 'ö‑ pö bha 'yaa ꞊sua 'ka yö ꞊në‑ 'gü. ‑A ‑kë tɛanwɔn 'ka ‑sü bha ꞊në‑ ‑wɔn 'gü 'yö‑ ‑gɛn dɔ 'pö ka ‑dhɛ, kë \"dhʋ̈ kö kaa ‑dɩ 'pö 'ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ Yesu bha Atanna Gbö ‑mü ꞊dedewo tɛan‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","'Wɔn ‑nu bha ‑wo ‑kë \"dhʋ̈ kö 'pë 'ö ‑bɛn zë ‑sü 'ka Atanna ‑wʋ 'gü ꞊dhɛ: «‑A ga do ‑zian 'yii 'dho \"yɛ‑ kwi 'gü» ");
INSERT INTO daf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","\"ɛɛn 'zü 'ö ‑bɛn zë ‑sü 'ka ‑dhɛ \"wɛɛ 'bha‑ 'gü ꞊dhɛ: «'Mɛ 'wo mɛ zua bha woo ꞊dede ‑wo ‑dho 'mɛ 'wo‑ zua bha‑ yö wo \"yanga ꞊plɛ 'ka» bha kö‑ 'gü ‑wɔn ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","꞊Dhɛ 'ö 'wɔn bha ꞊ya kë \"dhʋ̈, 'yö Zosɛfu 'ö go 'pödhɛ 'wo‑ Adhimate ‑dhɛ ‑kë bha‑ 'gü bha 'ö dho Pidhatö \"piʋ̈, 'yö Yesu ꞊gee ‑gbadhɛ ‑gɔ. Zosɛfu bha Yesu ‑bha ꞊klangdhiʋ̈ do ꞊në gun‑ 'ka 'pö, \"kɛɛ yö ‑zë ‑yö ‑gun ö ‑bha kë sië ‑gblɛn 'kpɔ 'gü, ‑a ‑gɛn ‑mü ꞊dhɛ ‑yö ‑gun \"suʋ̈ sië Zuifö ‑nu ‑gɔmɛ ‑nu ‑gɔ. ꞊Dhɛ 'ö ꞊ya 'dho ꞊yaa‑ ꞊gee ‑gbadhɛ Pidhatö ‑gɔ, 'yö‑ nu‑ ‑dhɛ. 'Yö nu 'yö‑ ꞊gee sü 'yö dho‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","'Yö gɔndënë 'wo‑ ‑dhɛ 'pö Nikodɛmö, 'ö dho Yesu \"piʋ̈ 'nu gbeng yi do 'ka bha 'ö dho mü 'pö. ‑A 'dho ‑sü 'ka, ‑dhasiklɔɔ \"yi suu 'bha ‑nu 'wo‑ miidhö waa‑ adhoe ‑kë bha‑ ‑kaan \"kwëë ‑sü \"kidhʋng 'ö ꞊mɔɔ ‑kaɔng ‑yaaga ‑bha ‑yö ‑gun ‑gɔ 'ö dho‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","'Yö mɛ ꞊plɛ bha 'wo dho 'wo Yesu sü, 'yö 'wo sɔ bɔ‑ ‑bha kö ‑wo ‑dhasiklɔɔ \"yi bha‑ ꞊wɛnng sië‑ ‑bha ꞊dhɛ ‑kɔ 'wo mɛ ꞊gee ‑pë ‑kë 'ka Zuifö ‑nu ‑gɔ \"sɛ 'gü bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","‑Dhɛ 'wo Yesu zë‑ ‑bha bha \"dhü ‑bhlaa do 'bha ‑yö gun‑ ‑dhɛ \"sɔɔ, 'ö bun ‑dee 'wo‑ pɔn ‑gwë ‑tɔn 'gü, 'ö 'wii mɛ ‑blɛɛsü wɔ‑ 'gü ꞊kö bha 'ö gun‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","‑Wo Yesu ‑wɛɛ ‑bho ‑dhɛ bha ꞊në‑ 'gü, kë 'ö wo Zuifö ‑nu ‑bha ꞊glooyi yɛan\" \"piʋ̈ 'ka, kö \"tʋ̈ng 'yaa‑ ‑nu ‑gɔ kö ‑wo ‑dhɛ ‑dee 'bha mɔɔ‑ ‑dhɛ \"wɛɛ 'gü bha‑ ‑wɔn 'gü. ‑A ‑gɛn ‑mü ꞊dhɛ ‑dhɛ bha ꞊në‑ ‑dhɛ 'yaa gun ꞊gblɛɛn, ('yö 'wo ‑gwë kpö 'kpii‑ do sü 'wo‑ zun‑ \"dhiʋ̈). ");
INSERT INTO daf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","꞊Dhɛ 'ö Zuifö ‑nu ꞊glooyi bha ꞊ya ziö 'ö‑ ‑ta ‑dhɛ ꞊ya ꞊kpaɔ, 'yö Madhi 'ö go Madadha bha 'ö ‑suʋ̈ ‑dhɛkpaɔ tii 'gü 'yö dho Yesu bun ꞊taa. 'Ö dho 'ö ꞊loo mü kö ‑gwë kpö 'wo‑ zun‑ bun \"dhiʋ̈ bha 'yaa mü 'zü. ");
INSERT INTO daf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","'Yö dɔ ‑bɛang ‑bha 'ö dho Simɔ Piɛdhö waa‑ ꞊klang ‑nu bha‑ mɛ 'dhɛ 'ö‑ ‑dhɔ gun Yesu kë sië bha‑ ‑nu \"piʋ̈, 'yö‑ pö‑ ‑nu ‑dhɛ: «'Mɛ 'ka dɔ bha, ꞊wa kwa Dëmɛ 'sü ꞊waa‑ bho‑ ‑wɛɛ bha‑ 'gü \"kɛɛ 'wo dho‑ 'ka ‑dhɛ 'ö‑ 'gü 'yaa‑ ‑dhɛ dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","'Yö Piɛdhö waa‑ Yesu ‑bha ꞊klangdhiʋ̈ 'dhɛ bha 'wo zun \"kpɛnng, 'yö 'wo dho Yesu ‑wɛɛ bho ‑dhɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","‑An ꞊gban ꞊plɛ‑ ‑gun 'dho sië ‑bɛang 'ka \"kɛɛ 'yö‑ ꞊klangdhiʋ̈ 'dhɛ bha‑ ‑gɛn ‑yö Piɛdhö to, 'yö dho 'ö ꞊loo mü ‑a \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","'Dho 'ö‑ wo 'ö ꞊loo mü bha 'yii ‑da ‑yɛ 'gü mü, \"kɛɛ ꞊dhɛ 'ö ꞊ya \"gblëënu, 'ö ꞊ya ‑dhɛ ‑ga ‑yɛ bha‑ 'gü, ‑a \"yan ‑yö ‑kpan sɔ \"pɛn ‑nu kö 'wo gun piʋ̈‑ ‑sü 'ka Yesu 'ka bha‑ ‑nu ‑bha mü. ");
INSERT INTO daf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","꞊Dhɛ 'ö Simɔ Piɛdhö 'ö yö ‑zë 'ö gun ꞊taama bha ꞊ya nu ꞊ya ꞊loo mü, 'yö ‑da ‑yɛ bha‑ 'gü, 'yö sɔ \"pɛn ‑nu 'wo gun \"sia‑ mü bha‑ ‑nu yö 'pö ");
INSERT INTO daf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","waa‑ sɔ 'wo kë‑ kpa Yesu ‑gɔ ‑ta bha‑ 'dhö \"kɛɛ kö 'waa ‑dhɛ do 'gü, kö sɔ 'kö bha yö ‑zë yö \"yɛ ‑sü 'ka 'ö wɔ ‑sü 'ka ‑dɩ ‑ta ‑dhɛ \"wɛɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","'Yö ꞊klang ‑nu bha‑ mɛ 'dhɛ 'ö kë dho 'ö ꞊loo bun ‑ta mü ‑blɛɛsü \"kɛɛ 'ö 'yii ‑da ‑yɛ 'gü mü bha 'ö dho 'pö 'ö ‑da ‑yɛ bha‑ 'gü, 'yö‑ \"yan ‑yö ‑da 'wɔn bha‑ ‑dhɛ 'gü 'pö, 'yö 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ ꞊ya 'go ga 'gü ꞊ya ‑bö tɛan‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","‑A ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö Atanna ‑wʋ 'ö ‑bɛn zë ‑sü 'ka‑ ‑gɔ 'sëëdhɛ 'gü ꞊dhɛ Yesu ‑dho 'go ga 'gü 'ö ‑bö bha 'wii‑ 'gü ma ö 'klɔɔ‑ 'ka ꞊kö. ");
INSERT INTO daf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö Yesu ‑bha ꞊klang ‑nu ꞊plɛ bha 'wo wo yee ‑kë 'wo dho wo ꞊yëë \"dhiʋ̈. ");
INSERT INTO daf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","'Mɛ 'wo bha ‑wo Madhi ‑zë ‑to mü kö ‑yö dɔ sië Yesu bun \"sɔɔ \"kpɛnng kö ‑yö \"gbʋ bɔ sië. ‑Yö ‑to \"gbʋ bha‑ bɔ ꞊dhɛ 'gü \"dhʋ̈, 'ö dho \"gblëënu kö ‑yö ‑dhɛ ‑ga ‑yɛ 'gü mü ");
INSERT INTO daf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kö Atanna ‑bha \"kië ꞊plɛ 'ö sɔ \"puu 'dhö‑ ‑nu ‑bha ‑wo ‑ya sië ‑dhɛ 'ö Yesu ‑yö gun wɔ sië‑ ‑bha bha‑ 'gü, kö‑ mɛ do ‑yö ‑ya sië‑ ‑gɔ ‑duɛ 'gü, kö‑ ‑mɛ 'dhɛ 'ö to ‑yö ‑ya sië 'pö‑ ‑gɛn ‑wɛɛ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","'Yö 'wo‑ pö Madhi ‑dhɛ 'wo‑ pö: «Dhebhɔnë, i ‑më ‑wɔn ꞊në‑ \"gbʋ bɔ?» 'Yö‑ ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «N \"gbʋ bɔ ‑gɛn ‑mü ꞊dhɛ n Dëmɛ 'wo‑ ‑wɛɛ bho ‑dhɛ ya‑ 'gü yuënggü bha ꞊waa‑ 'sü mü ꞊wa 'dho‑ 'ka \"kɛɛ 'wo dho‑ 'ka 'wo‑ ‑wɔ ‑dhɛ 'ö‑ 'gü 'maa‑ ‑dhɛ dɔ.» ");
INSERT INTO daf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","‑Yö ‑to ‑a ‑pö \"dhʋ̈ ‑dhɛ 'gü 'ö dho slëë‑ ö 'gü kö 'ö ‑dhɛ ‑ga kö Yesu ‑yö dɔ sië‑ \"sɔɔ mü, \"kɛɛ 'yii‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","'Yö‑ dhɛɛ\" kpɔ 'ö‑ pö: «Dhebhɔnë, i‑ ‑mɛɛ ꞊në‑ \"gbʋ bɔ? i 'dee‑ mɔɔ‑ sië?» Madhi ‑zë ‑yö ö ‑zʋ ‑gɔn ꞊dhɛ \"dhü ‑bhlaa bha‑ yëkëmɛ ‑mü. 'Yö‑ pö‑ ‑dhɛ: «N Dëmɛ, 'ö ꞊ya kë ꞊dhɛ bhi ꞊në 'i n Dëmɛ Yesu ꞊gee sü 'i dho‑ 'ka kö ‑bhö dɔ \"gbɩɩ‑ kö 'i‑ ‑wɔ ‑dhɛ 'ö‑ 'gü 'i‑ ‑dhɛ ‑zɔn n ‑dhɛ kö 'a 'dho‑ 'sü.» ");
INSERT INTO daf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","'Yö Yesu ‑ya ‑dhɛ 'ö‑ pö: «Madhi!» 'Yö ꞊slëë ö 'gü 'ö ö wë bɔ‑ ‑ta, 'yö‑ pö‑ ‑dhɛ Eblö ‑wʋ 'gü 'ö‑ pö: «Dhabuni!» (꞊Waa‑ pö \"dhʋ̈ kö ‑wa ‑pö «n Dëmɛ».) ");
INSERT INTO daf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","(꞊Dhɛ 'ö yöö ꞊loo Yesu ‑bha,) 'yö‑ pö‑ ‑dhɛ: «'Bha 'dho i ‑kɔ zun n ‑bha, ‑a ‑gɛn ‑mü ꞊dhɛ 'mii ‑tɔn 'kun ꞊kö kö 'a 'dho n Dë \"piʋ̈ dhang‑ 'gü. \"Kɛɛ ‑bhö 'dho kö 'i‑ pö n dheebhang ‑nu ‑dhɛ ‑zë wo ꞊dhɛ 'dho ꞊në maa‑ wo n Dë 'ö ka Dë 'ka 'pö, ma Atanna 'ö ka ‑bha Atanna 'ka 'pö bha‑ \"piʋ̈ ya.» ");
INSERT INTO daf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","'Yö Madhi ‑yö dho Yesu ‑bha ꞊klang ‑nu ‑zian 'ka, 'yö 'wɔn bha‑ ‑gɛn dɔ‑ ‑nu ‑dhɛ 'ö‑ pö: «'Ma ‑kpan kwa Dëmɛ ‑bha. Yö ꞊në ‑wʋ 'ö ꞊ni 'ö ꞊ni‑ kpɔ n ‑bha. 'Yö ‑ziö ‑nu ‑dhɛ ‑wʋ ‑nu bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","‑A yi do 'ö ‑kë Zuifö ‑nu ꞊glooyi ‑tadhɛkpaɔ ‑ta 'ka bha‑ 'ka yɛan\" \"piʋ̈, 'yö Yesu ‑yö nu 'yö dɔ ö ‑bha ꞊klang ‑nu kpö 'gü 'yö ö ‑dɩ ‑zɔn ‑nu ‑dhɛ kö 'kɔ 'wo gun‑ 'gü bha‑ \"dhi ꞊gban \"pɛpɛ ‑yö ta ‑sü 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö ‑wo ‑tun ꞊kö \"suʋ̈ Zuifö ‑nu ‑gɔmɛ ‑nu ‑gɔ. ꞊Dhɛ 'ö ꞊ya nu ꞊ya dɔ‑ ‑nu kpö 'gü \"dhʋ̈ 'yö‑ pö: «Zuëyagblʋ̈ʋ̈‑ ‑yö kë ka ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","꞊Dhɛ 'ö ꞊ya ö bo‑ pö‑ ‑nu ‑dhɛ \"dhʋ̈ ‑sü 'ka, 'yö ö ‑kɔ ꞊kwɛng ‑dhɛ ‑nu ‑zɔn ‑a ‑nu ‑dhɛ waa‑ \"sɛn 'gü ‑dhɛ 'dhö, (kë \"dhʋ̈ kö ‑wo \"pɔni waa‑ 'düga \"gblʋʋ ‑nu bha‑ yö). ꞊Dhɛ 'ö‑ ‑bha ꞊klang ‑nu ꞊waa‑ ‑dhɛ yö \"dhʋ̈, 'yö‑ ‑nu zuë\" ꞊nii ‑da ꞊dedewo. ");
INSERT INTO daf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","'Yö‑ pö‑ ‑nu ‑dhɛ 'zü ‑deewo 'ö‑ pö: «Zuëyagblʋ̈ʋ̈‑ ‑yö kë ka ‑gɔ! 'Ma ka bɔ 'pö ꞊dhɛ ‑kɔ 'ö n Dë ‑yö n bɔ‑ 'ka bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö ö \"tɛɛ ‑blü ‑a ‑nu ‑bha 'yö‑ pö: «Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ bha ꞊në 'a‑ ‑da ka 'gü bha.» ");
INSERT INTO daf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","'Yö 'go mü 'zü 'ö‑ pö: «Mɛ \"ʋʋ mɛ 'ö 'ka‑ ‑mawɔn 'to \"kpʋng ꞊taa yö, kö Atanna ꞊yaa‑ mɛ ‑mawɔn 'to 'pö ꞊naa bha. Mɛ \"ʋʋ mɛ 'ö 'kii‑ ‑bha 'wɔn yaa ‑mawɔn 'to, kö Atanna ‑dɩ 'pö 'yii 'dho‑ ‑mɛ ‑mawɔn 'to. ");
INSERT INTO daf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","\"Tʋ̈ng 'ö ö ‑dɩ ‑zɔn 'ka ö ‑bha ꞊klang ‑nu ‑dhɛ \"dhʋ̈ bha kö Toma 'wo‑ 'tɔ ‑ya ‑ta ‑dhɛ Didimö bha 'yaa mü. ");
INSERT INTO daf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","‑A \"tɛabɔ ‑nu ‑wa pö‑ ‑dhɛ yö ꞊në‑ 'gü kö ꞊wa ‑kpan ‑bha 'wo‑ pö: «Toma, yi ‑zë 'ya kwa Dëmɛ yö.» 'Yö Toma ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «꞊Ya kë ꞊dhɛ kö mang ꞊dede ‑zë n \"yan 'yii ‑da \"pɔni 'wo‑ ‑gban ‑a ꞊kwɛng bha‑ ‑dhɛ 'gü, kö 'a n ‑kɔ dan ‑dhɛ 'gü ꞊ni, \"ɛɛn kö 'a n ‑kɔ dan ‑dhɛ 'wo zua‑ ‑bha ‑a \"sɛnngdhö bha‑ ‑dhɛ 'gü 'pö ꞊ni, 'mii 'dho 'dhang bho 'wɔn 'ka‑ pö bha‑ \"dhiʋ̈ tongtongdhö.» ");
INSERT INTO daf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","꞊Dhɛ 'ö ‑dhɛkpaɔyi \"saɔplɛ ꞊ya ziö, ‑a \"saaga ‑naa bha‑ 'ka, 'yö Yesu ‑bha ꞊klang ‑nu bha 'wo bho 'zü 'ko ‑ta ‑deewo 'kɔ do bha‑ 'gü. ‑A yi 'dhɛ kö bha‑ 'ka kö Toma ‑yö mü. Kö 'mɛ 'wo bha ‑wo \"kwɛɛ ta ‑sü ꞊wlöö 'pö 'zü. 'Wo dho \"kan wo ‑ta kö ‑yö dɔ sië‑ ‑nu kpö 'gü mü. 'Yö‑ pö‑ ‑nu ‑dhɛ 'zü ‑deewo 'ö‑ pö: «Zuëyagblʋ̈ʋ̈‑ ‑yö kë ka ‑gɔ!» ");
INSERT INTO daf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö go mü 'ö‑ pö Toma ‑dhɛ: «Toma, ‑bhö ꞊yɔɔn n \"sɔɔ yö kö bhii ꞊dede 'i i ‑kɔ dan ‑dhɛ 'wo n zua‑ ‑bha n ꞊kwɛng bha‑ ‑dhɛ 'gü, kö 'i‑ dan 'zü ‑dhɛ 'wo n zua‑ ‑bha n \"sɛnngdhö bha‑ ‑dhɛ 'gü kö 'i i bo gɔɔgbɩɩdhɛ bha‑ 'ka kö 'i 'dhang bho n \"dhiʋ̈.» ");
INSERT INTO daf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","'Yö Toma ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «N Dëmɛ, ma Atanna!» \"Kɛɛ ‑yö ‑to ‑a \"dhi, 'yö Yesu ‑ya pö‑ ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","«\"Yan 'i‑ ‑kpan n ‑bha bha ꞊në‑ ‑wɔn 'gü 'yö 'i 'dhang bho n \"dhiʋ̈, \"kɛɛ 'mɛ 'kö 'wii n yö 'wo 'dhang bho n \"dhiʋ̈ bha‑ ‑nu ‑bha ‑së.» ");
INSERT INTO daf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","\"Slë ‑nu 'ö Yesu ‑ya ‑kë ö ‑bha ꞊klang ‑nu \"yaan ‑a 'gbɛ ꞊në 'yaa 'sëëdhɛ ‑be ya‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","\"Kɛɛ ‑a 'dhɛ ‑nu 'ö‑ ‑nu ‑bɛn 'dhö zë ‑sü 'ka ya yi‑ ‑bɛn zë \"dhʋ̈ kö 'ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ Yesu ꞊në Atanna ‑bha ‑Yamɛ bha‑ 'ka, ꞊dhɛ yö 'ö bha ꞊në Atanna Gbö 'ka, kö ka ‑bha 'dhang ‑bho ‑a \"dhiʋ̈ ‑sü 'gü, kö 'ka ꞊sii ꞊slɔɔ ‑a 'saa‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","2","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'ö yi do 'bha 'ka 'zü, kö‑ ‑bha ꞊klang ‑nu bha‑ mɛ \"saɔplɛ 'ö‑ mɛ do‑ ‑kë Simɔ Piɛdhö 'ka, 'ö‑ mɛ do‑ ‑kë Toma 'ka 'ö 'wo‑ 'tɔ kpɔ Didimö bha waa‑ Natanaɛɛ 'ö go Kana, Gadhidhe ‑sɛ 'gü bha waa‑ Zebede gbö ‑nu, waa‑ ‑bha ꞊klang ‑nu bha‑ mɛ \"wɛɛ ꞊plɛ ‑wo piʋ̈\" ‑da sië \"yitagbɛa 'wo‑ Tibedhiadö ‑yi ‑kë bha‑ ꞊bhaa, 'yö Yesu ‑yö ö ‑dɩ ‑zɔn 'zü ‑dee wo‑ ‑nu ‑dhɛ. ‑Kɔ 'ö ö ‑dɩ ‑zɔn 'ka ‑kaa ‑ga 'ö ya: ");
INSERT INTO daf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","‑A mɛ 'dhɛ 'wo‑ ‑dhɛ Simɔ Piɛdhö bha ꞊në‑ pö 'mɛ 'wo bha‑ ‑nu ‑dhɛ: «Maa 'dho \"yi \"piʋ̈.» 'Yö 'wo‑ pö 'pö‑ ‑dhɛ: «꞊Ya kë \"dhʋ̈ kö yi ‑dho 'dho 'pö i ꞊keng‑.» ꞊Dhɛ 'ö‑ ‑nu ‑wʋ ꞊ya kë do, 'yö 'wo zun \"kpɛnng 'wo dho 'wo ‑da \"kplagɔnë do 'gü 'yö 'wo dho \"yi ‑bha kë ‑dhɛ 'gü, \"kɛɛ 'wii pë 'bha 'sü gbeng 'kö bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","꞊Dhɛ 'ö ‑dhɛ ꞊ya ꞊kpaɔ, 'yö 'wo dho 'wo ‑kpan Yesu ‑bha \"yi \"kpʋng \"dhiʋ̈ mü, \"kɛɛ 'wii‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","'Yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «N bhang ‑nu, 'yuʋ̈‑ ꞊në 'yaa ka ‑gɔ 'zü kö 'ka‑ ‑bhö ‑ee?» 'Yö wo‑ pö‑ ‑dhɛ: «꞊Iin.» ");
INSERT INTO daf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","꞊Dhɛ 'wo‑ pö \"dhʋ̈ 'yö‑ pö‑ ‑nu ‑dhɛ: «‑Kaa \"nuu bha‑ ‑zuö 'sa \"kplagɔnë bha‑ ‑kɔ ‑së 'gü \"pɛan bha‑ 'ka, ka ‑dho 'yuʋ̈‑ zë. 'Yö 'wo \"nuu bha‑ ‑zuö ꞊dhɛ ‑kɔ 'ö‑ pö 'ka‑ ‑nu ‑dhɛ bha‑ 'dhö, 'yö‑ ‑nu faan 'yii ꞊mɔɔ‑ \"gan ‑sü ‑bha 'yuʋ̈‑ 'ö gun‑ 'gü bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö‑ ‑bha ꞊klang ‑nu bha‑ mɛ 'dhɛ 'ö‑ ‑dhɔ gun‑ kë sië bha 'ö‑ pö Piɛdhö ‑dhɛ: «Piɛdhö, kwa Dëmɛ ꞊në bha!» ꞊Dhɛ 'ö Simɔ ꞊yaa‑ ma ꞊dhɛ wo Dëmɛ ꞊në bha, 'yö sɔ ‑da ö ‑bha, 'yö ‑pö \"yi bha‑ ꞊bhaa 'yö dho‑ ‑zian 'ka. ");
INSERT INTO daf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","'Yö mɛ 'dhɛ 'wo to \"yitagɔ 'gü bha 'wo ‑ya \"nuu bha‑ \"gan ‑sü ‑bha 'wo nu‑ 'ka \"yi \"kpʋng \"dhiʋ̈, ‑a ‑gɛn ‑mü ꞊dhɛ 'ö gun \"dhʋ̈ kö 'waa \"yi \"kpʋng 'ka ꞊gblɛɛn 'zü, kö ‑wo ꞊dhɛ ‑gɛn ‑yan këng do \"sinma \"dhiʋ̈ ‑dhɛ 'dhö, \"kɛɛ kö \"nuu bha ‑yö pa ‑sü 'ka 'yuʋ̈‑ 'ka ‑tɛtɛdhö. ");
INSERT INTO daf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","꞊Dhɛ 'ö ꞊wa 'go \"yitagɔ 'gü ꞊wa zun \"sia‑, 'wo dho ‑dhɛ ‑ga kö 'yuʋ̈‑ ꞊pia ‑sü ‑yö pɛng ꞊dhuu ‑ta kö 'bluu‑ ‑ya \"sɔɔ mü. ");
INSERT INTO daf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Ka nu 'yuʋ̈‑ 'ka‑ kun bha‑ 'bha 'ka!» ");
INSERT INTO daf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","'Yö Simɔ Piɛdhö ‑yö ‑da \"kplagɔ bha‑ 'gü 'yö \"nuu bha‑ ‑gan 'ö nu‑ 'ka \"sia‑, kö 'yuʋ̈‑ ‑ya pa ‑sü 'ka. 'Yuʋ̈‑ 'ö gun \"nuu bha‑ 'gü bha‑ ꞊gban ‑da 'kwëë‑ ‑sü gun 'yuʋ̈‑ këng do ö ‑kɔ \"sɔɔdhu waa‑ 'yuʋ̈‑ ‑yaaga. 'Sa ‑a 'bha 'yaa gun 'sɛɛnnë \"kɛɛ yö ‑zë ꞊gban 'gü, \"nuu bha‑ ga do ‑zian 'yii \"kan. ");
INSERT INTO daf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","'Yö Yesu ‑ya pö‑ ‑nu ‑dhɛ: «‑Ka nu kö 'ka pë ‑bhö!» \"Kɛɛ 'mɛ 'wo bha‑ mɛ do ‑zian 'yii ꞊mɔɔ‑ ‑bha kö ‑ya dhɛɛ\" 'kpɔ ꞊dhɛ: «De ‑zë ‑mü i 'ka ‑zë wo ꞊zɔɔ?» ‑A ‑gɛn ‑mü ꞊dhɛ kö ‑wa 'wɔn ‑dɔ ꞊dhɛ wo Dëmɛ ‑mü. ");
INSERT INTO daf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö ꞊yɔɔn‑ ‑nu \"sɔɔ 'yö 'bluu‑ bha‑ sü 'yö‑ nu‑ ‑nu ‑dhɛ waa‑ 'yuʋ̈‑ ꞊pia ‑sü bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","'Go 'ö Yesu ‑ya wo ga 'gü bha‑ ‑bha ö ‑dɩ ‑zɔn ö ‑bha ꞊klang ‑nu ‑dhɛ ‑kɔ ‑yaaga ‑naa ꞊në gun bha. ");
INSERT INTO daf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","꞊Dhɛ 'ö ꞊wa wo bo pë ‑bhö ‑sü 'ka, 'yö‑ pö Piɛdhö ‑dhɛ: «Simɔ, Zan gbö, n ‑dhɔ ‑yö i ‑kë 'ö ‑ziö mɛ 'wo ya‑ ‑nu ‑ta \"wɛ ‑ee?» 'Yö Piɛdhö ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «꞊Iin, n Dëmɛ, i‑ 'wɔn ‑dɔ ꞊dhɛ i ‑dhɔ ‑yö n ‑kë.» 'Yö‑ pö‑ ‑dhɛ: «‑Ɛɛ, ꞊dhɛ 'ö \"dhʋ̈ ‑bhö i ‑zʋ 'to ('mɛ 'wo bɔ n 'ka 'wo ꞊dhɛ) ma ‑tuʋ̈ ‑nu 'dhö bha‑ ‑nu \"piʋ̈!» ");
INSERT INTO daf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","'Yö 'go mü 'zü 'ö‑ dhɛɛ\" ꞊plɛ ‑naa kpɔ 'ö‑ pö: «Simɔ Zan gbö, n ‑dhɔ ‑yö i ‑kë ‑ee?» 'Yö Piɛdhö ‑ya pö‑ ‑dhɛ: «꞊Iin, n Dëmɛ, ‑a 'wɔn ‑yö i \"yaan ꞊dhɛ i ‑dhɔ ‑yö n ‑kë.» 'Yö Yesu ‑ya pö‑ ‑dhɛ: «‑Ɛɛ, ꞊dhɛ 'ö \"dhʋ̈ ‑bhö i ‑zʋ 'to ('mɛ 'wo bɔ n 'ka 'wo ꞊dhɛ) ma ‑tuʋ̈ ‑nu 'dhö bha‑ ‑nu \"piʋ̈!» ");
INSERT INTO daf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","'Yö 'go mü 'ö‑ dhɛɛ\" ‑yaaga ‑naa kpɔ 'zü 'ö‑ pö: «Simɔ, Zan gbö, i‑ ‑pö n ‑dhɔ ‑yö i ‑kë ꞊dedewo \"wɛ ‑ee?» 'Yö Piɛdhö ‑yö ö wëë 'gü ‑siö ‑a dhɛɛ\" ‑yaaga ‑naa 'ö Yesu ‑ya kpɔ bha‑ ‑wɔn 'gü. 'Yö‑ ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «'Aa, n Dëmɛ, bhi 'ö bhi ‑zë 'i 'wɔn ꞊gban ‑wɔn ꞊gban dɔ ya, 'bhaa‑ 'wɔn dɔ ꞊në wo ꞊dhɛ i ‑dhɔ ‑yö n ‑kë ‑ee?» Yesu ‑ya ‑pö ‑dhɛ yö ꞊në‑ ‑wɔn 'gü: «꞊Dhɛ 'ö \"dhʋ̈ kö ‑bhö ma ‑tuʋ̈ ‑nu \"dhiʋ̈ gba!» ");
INSERT INTO daf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'Yö ö ‑wʋ ‑ta ‑yɔ 'ö‑ pö: «Piɛdhö, a‑ ‑pö i ‑dhɛ, tɛan‑ ꞊dede 'ka ꞊dhɛ: 'Ö gun kö i 'në \"gbɔng 'ka, 'wɔn 'ö ‑dhi i ‑dhɛ ꞊në 'i gun‑ kë sië, 'ö 'i dho ‑dhɛ 'ö ‑dhi i ‑dhɛ ‑a 'gü ꞊dhɛ ‑kɔ 'ö ‑dhi i ‑dhɛ ‑a 'dhö, \"kɛɛ 'bha kë zii yi 'ö‑ 'ka, i ‑dho i ‑gbe wang ꞊në‑ \"pʋ, 'yö mɛ \"wɛɛ ‑yö dho i 'ka ‑dhɛ 'ö‑ ‑dhɔ 'yaa i ‑bha bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Saan\" ‑kɔ 'ö Piɛdhö dho saan\"‑ 'ka kö‑ ga ‑kɔ ‑yö Atanna 'tɔ bhɔ bha ꞊në Yesu ‑ya to \"dhiʋ̈ 'ö‑ dhiang zë \"dhʋ̈ bha. ꞊Dhɛ 'ö ꞊ya bo‑ ‑pö \"dhʋ̈ ‑sü 'ka 'yö‑ pö‑ ‑dhɛ: «‑Bhö nu 'kwa 'dho.» ");
INSERT INTO daf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","꞊Dhɛ 'ö ꞊wa ziö 'wo 'dho sië, Piɛdhö dho slëë‑ ö 'gü kö ‑yö ‑dhɛ ‑ga kö Yesu ‑bha ꞊klang ‑nu bha‑ mɛ 'dhɛ 'ö‑ ‑dhɔ gun‑ kë sië, 'ö kë ö ‑gɔ ‑wɔ ‑a ‑kuu ‑ta kö ‑wo pë ‑bhö sië 'ö‑ dhɛɛ\" kpɔ 'ö‑ pö «N Dëmɛ, 'dee yöö ‑da i ‑dhɛ pë \"piʋ̈ bha» ‑yö nu sië‑ ‑nu ꞊keng‑. ");
INSERT INTO daf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","'Yö Yesu dhɛɛ\" kpɔ 'ö‑ pö: «'Yö mɛ 'dhɛ 'kö nu sië ya ꞊wɛ, n Dëmɛ? Yö ‑zë ‑bha ga ‑kɔ ‑dho kë mü ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑gɔ 'ö‑ pö: «‑A 'dhɛ 'kö bha 'yaa dɔ i ‑gɔ ‑dhɛ 'bha 'gü, ꞊ya ga n 'gü, ‑yö ‑mɔɔ ‑bha 'ö to \"yaan 'ö zun‑ 'ka n \"dhiʋ̈ yee kë ‑yi ‑bha. Bhi ‑zë ‑bhö nu ꞊zɔɔ kö 'kwa 'dho!» ");
INSERT INTO daf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","‑A pö 'ö Yesu ‑ya wo \"dhʋ̈ bha 'yö‑ ‑wʋ ‑yö ꞊mɔɔ kwa dheebhang ‑nu kpö 'gü ꞊dhɛ ‑a ‑bha ꞊klangdhiʋ̈ 'dhɛ 'kö bha 'yii 'dho ga 'zü tongtongdhö. \"Kɛɛ 'sa kö Yesu ‑zë 'yii‑ pö Piɛdhö ‑dhɛ ꞊dhɛ 'yii 'dho ga 'zü, ‑ya ‑pö ꞊naa 'kö 'zü ꞊ya 'to \"yaan kö ‑yö zun‑ 'ka n nu yi ‑bha ꞊wɛ, yö ‑zë ‑yö ‑dɔ i ‑gɔ 'mɛ?» ");
INSERT INTO daf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","‑A ꞊klangdhiʋ̈ 'ö \"dhʋ̈ bha ꞊në 'wɔn ‑nu bha‑ ‑gɛn dɔ 'yö‑ ‑bɛn zë bha. Yö ꞊në‑ ‑wɔn 'gü 'yö 'yi 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ 'wɔn 'ö‑ ‑gɛn dɔ bha tɛan‑ ‑mü. ");
INSERT INTO daf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","'Wɔn 'ö Yesu ‑ya ‑kë ‑a ‑kpɛa 'yaa ‑mü ‑a 'dhɛ 'yi‑ ‑gɛn dɔ 'sëëdhɛ ya‑ 'gü ya‑ 'ka. ꞊Ya kë 'nu ꞊dhɛ 'wɔn ‑nu 'kö Yesu ‑ya ‑kë yi‑ ꞊gban ‑sü 'do 'do 'yi‑ ‑bɛn zë, ‑a 'sëëdhɛ ‑be 'yii 'dho ꞊mɔɔ \"kpʋngtaadhɛ ‑todhʋ̈sü ‑zian 'gü.");
INSERT INTO daf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofidhö, n dheebhang ꞊bhlëësü, ma 'sëëdhɛ ‑blɛɛsü 'a‑ ‑bɛn zë bha, 'wɔn 'ö ‑gban pë \"pɛpɛ 'ö Yesu ‑ya ‑kë waa‑ pë ‑nu 'ö mɛ ‑nu ꞊draan‑ ‑bha 'ö go‑ 'ka‑ ‑bha yë zü bho ‑sü ‑bha ");
INSERT INTO daf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","'ö dho 'ö zun‑ 'ka ‑dhɛkpaɔyi 'ö Atanna ‑ya ꞊wlü 'ö dho‑ 'ka dhang‑ 'gü ‑a ‑bha bha, a kë‑ ꞊gban \"pɛpɛ ‑gɛn ‑dɔ ‑a 'gü. \"Sanni ‑yö 'dho dhang‑ 'gü, ‑yö ö ‑wʋ ‑kpɔ mɛ ‑nu 'ö‑ ‑nu sü ö ‑bha bɔmɛ ‑nu 'ka \"kpʋng ꞊taa yö bha‑ ‑nu ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑bha 'gügbɩɩdhɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","꞊Dhɛ 'ö ꞊ya 'go ga 'gü, ‑yö ö ‑dɩ ‑zɔn ‑nu ‑dhɛ ‑gɛn ‑yan 'gbɛ ꞊dede 'ka ‑dhɛkpaɔyi ‑kaɔng ‑yiisiö 'ka 'yö‑ ‑zɔn ‑nu ‑dhɛ ꞊dhɛ 'ö \"yaan. ‑Wo wo \"yan ‑kpan ‑bha 'pö 'ö 'wɔn 'ö ‑gban Atanna ‑bha ‑gblüdëdhɛ ‑bha 'ö‑ pö‑ ‑nu ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yi do 'ka kö waa‑ ‑bha ꞊klangdhiʋ̈ ‑nu bha ‑wo pë ‑bhö sië ‑dhɛ do 'gü, 'yö‑ pö‑ ‑nu ‑dhɛ 'ö‑ pö: «'Ka 'dho bhɔ Zedhizadhɛmö ‑dhɛ 'ka taa‑ ꞊gblɛɛn ꞊kö, ‑ka ka \"yan 'to 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ö n Dë ‑ya \"plüün bho ka ‑dhɛ, 'a‑ ‑dhiang zë ka ‑dhɛ bha‑ ‑gɔ! ");
INSERT INTO daf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‑A ‑gɛn ‑mü ꞊dhɛ Zan ‑zë ‑yö mɛ ‑nu ‑zu \"yi ꞊në‑ 'ka, \"kɛɛ ka ‑zë ‑a yi 'yaa ꞊gblɛɛn 'zü kö Atanna ‑yö ka pa 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ka. ");
INSERT INTO daf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesu ‑bha bɔmɛ ‑nu 'ö wɛng‑ ‑nu 'wo gun ‑dhɛ do 'gü bha, 'wo‑ dhɛɛ\" kpɔ 'wo‑ pö: «Yi Dëmɛ, i‑ ‑pö ‑a yi ꞊ya ‑loo kö 'i Izraɛdhö ‑mɛ ‑nu bho ꞊dhuëngdhɛ 'gü (Wlɔmö ‑mɛ ‑nu ‑gɔ) kö ‑wo ‑ya wo ‑dɩ 'flëë‑ 'gü 'zü ‑deewo ‑ee?» ");
INSERT INTO daf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","'Yö Yesu ‑ya ‑yɔ bɔ‑ ‑nu ‑gɔ 'ö‑ pö: «‑Abin! ‑A ‑dhɛ 'yaa‑ ‑bha kö yi ‑nu waa‑ \"tʋ̈ng ‑nu ('wo ‑gban 'wɔn ‑nu bha‑ ‑bha) 'ö n Dë ‑ya ‑ya ö ‑bha ‑gblüdëdhɛ 'gü ‑wʋ 'ka bha 'ka‑ ‑nu dɔ. ");
INSERT INTO daf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","\"Kɛɛ (‑a 'dhɛ ka ‑mawɔn 'dhö‑ ‑bha kö 'ka‑ dɔ yö ‑mü ꞊dhɛ:) 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑dho lɔɔ‑ ka ‑ta 'ö Atanna ‑yö 'gügbɩɩdhɛ nu ka ‑dhɛ. Yö ꞊në ꞊ya kë \"dhʋ̈ 'yö 'wɔn 'ö ‑gban n ‑bha 'ka dho kë‑ pö ‑mɛ 'ka 'mɛ 'wo Zedhizadhɛmö pö 'gü ‑dhɛ ‑nu oo, Zude ‑sɛ 'gü ‑dhɛ ‑todhʋ̈sü waa‑ Samadhi ‑dhɛ ‑nu 'gü ‑a ‑nu ‑dhɛ 'ö dho \"dhʋ̈ 'ö zun‑ 'ka \"sɛ \"dhiʋ̈todhɛ 'gü.» ");
INSERT INTO daf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","꞊Dhɛ 'ö ꞊ya 'wɔn ‑nu bha‑ pö \"dhʋ̈ 'dɔɔndhö 'ö ꞊ya ö bo, 'yö ꞊wlü Atanna ‑bha 'gügbɩɩdhɛ 'ka 'yö dho dhang‑ 'gü, 'yö dho \"dhʋ̈ 'ö ‑da dha 'kpong‑ 'gü, 'yö dha 'kpong‑ ‑yö kpa‑ ‑ta ‑a ‑nu \"yan \"dhiʋ̈ mü. ");
INSERT INTO daf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","‑A ‑nu \"yan‑ ‑to Yesu ꞊keng‑ zian 'ö 'dho sië‑ 'ka dhang‑ 'gü bha‑ 'ka, 'wo dho ‑dhɛ ‑ga kö gɔɔn‑ ‑nu ꞊plɛ 'ö sɔ \"puu 'dhö‑ ‑nu ‑bha (Atanna ‑bha \"kië ‑nu bha) kö ‑wo dɔ sië‑ ‑nu \"sɔɔ mü. ");
INSERT INTO daf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","'Yö gɔɔn‑ ‑nu ꞊plɛ bha 'wo‑ pö‑ ‑nu ‑dhɛ: «Gadhidhe ‑mɛ ‑nu 'ka ya, ‑më 'ö ‑kë 'yö 'ka ‑dhɛ ‑ga dhang‑ 'gü zuudhö \"dhʋ̈? Yesu do 'ö 'go sië ka kpö 'gü 'ö dho dhang‑ 'gü bha, ‑yö ‑dho ö yee kë 'zü 'ö nu ꞊dhɛ ‑kɔ do 'ka‑ yö‑ 'ka kö ‑yö 'dho sië bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö Yesu ‑bha bɔmɛ ‑nu bha 'wo go ‑tɔn 'wo‑ ‑dhɛ Odhivie ‑tɔn 'ö Zedhizadhɛmö ‑dhɛ \"sɔɔ bha‑ ꞊gbin‑, 'yö 'wo wo yee ‑kë 'wo dho Zedhizadhɛmö 'plöö. ‑Go Zedhizadhɛmö 'plöö kö 'i dho Odhivie ‑tɔn ꞊gbin‑ ‑yö ‑mɔɔ \"kidhʋng do ‑nu \"sinma ‑bha. ");
INSERT INTO daf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","꞊Dhɛ 'ö ꞊wa ‑loo Zedhizadhɛmö, 'yö 'wo dho 'kɔdhi 'wo gun‑ 'gü 'kɔ ‑ta \"dhʋ̈ng 'gü bha‑ 'gü. 'Mɛ 'wo gun mü bha ‑wa mɛ do ‑dhɛ Piɛdhö, 'yö 'wo‑ mɛ do 'bha ‑dhɛ Zan, 'yö Zakö, Andre, Fidhipö, Toma, Batedhemi, Matiö, Zakö 'ö ‑kë Adhöfe gbö 'ka, 'yö Simɔ, 'wo‑ 'tɔ kpɔ 'wo‑ ‑dhɛ \"yangüsiʋ̈mɛ bha waa‑ Zudë 'ö ‑kë Zakö gbö 'ka 'pö. ");
INSERT INTO daf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","'Mɛ 'wo bha‑ ‑nu ‑wʋ ‑gun do 'ö 'wo ‑yɛa do 'gü 'wo ꞊bhɛa ‑kpɛawo, waa‑ dhebhɔ 'bha ‑nu waa‑ Yesu dhe Madhi waa‑ dheebhang ‑nu 'dhö. ");
INSERT INTO daf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yi do 'ka kö 'dhang ‑bho Yesu \"dhiʋ̈ ‑mɛ ‑nu 'wo dho ꞊mɔɔ mɛ këng do ö ‑kɔ ꞊plɛ ‑nu ‑bha bha ‑wo ‑dhɛ do 'gü, 'yö Piɛdhö ‑yö ꞊wlü‑ ‑nu ꞊gban wëëdhö mü 'ö‑ pö‑ ‑nu ‑dhɛ: ");
INSERT INTO daf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«N dheebhang ‑nu, ‑yö ‑së kö 'pë 'ö Atanna ‑bha 'Nii‑ ‑ya pö yi 'bha 'ka Davi \"dhi 'ö ‑bɛn zë ‑sü 'ka‑ ‑bha 'sëëdhɛ 'gü, 'ö ‑gban Zuda 'ö zian bho 'mɛ 'wo Yesu kun ‑a ‑nu 'ka ‑a ‑bha bha ‑yö kë. ");
INSERT INTO daf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zuda bha ‑yö ‑kë 'mɛ 'kwa gun Yesu ꞊keng‑ bha‑ mɛ do 'ka, yë 'kwa‑ ‑kë bha‑ ‑bha ‑gun 'pö. ");
INSERT INTO daf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","'Wëëga 'ö ‑kë ‑a mɛ zë ꞊saa 'ka bha 'yö 'bhlaadhɛ do dhɔ‑ 'ka. ꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈, 'yö dho ö ‑gɔ 'bhlaadhɛ bha‑ 'gü 'yö‑ ‑pö mü 'ö wü, 'yö‑ gblëën‑ ꞊gban 'wo ‑pɛn 'do 'do, 'yö ga. ");
INSERT INTO daf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","'Mɛ 'wo Zedhizadhɛmö ‑pö ya‑ 'gü ‑a ‑nu ꞊gban \"pɛpɛ ‑wo kë 'wɔn bha‑ ma, 'yö‑ ‑wɔn 'gü 'yö 'wo 'bhlaadhɛ bha‑ ‑dhɛ wo ‑wʋ 'gü Akɛdama (꞊waa‑ pö \"dhʋ̈ kö ‑wa ‑pö 'bhlaadhɛ 'ö mɛ ꞊yɔɔn ‑yö ꞊wɛnng‑ 'gü). ");
INSERT INTO daf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","'Wɔn 'ö ‑gban Zuda ‑bha bha ‑yö ‑bɛn zë ‑sü 'ka \"Tan 'sëëdhɛ ('wo‑ Somö kë bha‑) 'gü 'nu yi 'bha 'ka ꞊dhɛ: «Mɛ 'bha ‑bha ‑wɔn 'ya 'dho zun‑ ‑bha 'kɔ ‑bha, mɛ 'bha 'ya 'dho ‑ya 'gü.» 'Yö ‑bɛn zë ‑sü 'ka 'zü ꞊dhɛ: «Mɛ do 'bha ‑yö dɔ‑ \"gblʋʋ 'gü». ");
INSERT INTO daf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","꞊Dhɛ 'ö \"dhʋ̈ mɛ do ‑yö ‑da yi \"piʋ̈ kö ‑yö kë kwa Dëmɛ Yesu ‑bha ‑go ga 'gü ‑sü bha‑ \"sɛɛ‑ 'ka 'pö. Mɛ 'ö \"dhʋ̈ bha ‑yö kë 'mɛ 'ö gun 'mɛ 'ö 'kwa gun kwa Dëmɛ Yesu ꞊keng‑ \"tʋ̈ng \"pɛpɛ 'ö‑ ‑kë, 'ö bɔ‑ 'ka \"sɛ ‑nu 'gü 'ö go‑ 'ka yi 'ö Zan ‑ya ‑zu 'ka bha‑ ‑bha 'ö dho 'ö zun‑ 'ka yi 'ö go‑ 'ka kwa kpö 'gü, 'ö Atanna ‑ya ꞊wlü 'ö dho‑ 'ka dhang‑ 'gü ‑a ‑bha bha‑ mɛ do ꞊në‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","꞊Dhɛ 'ö ꞊ya kë \"dhʋ̈ 'yö 'wo mɛ ꞊plɛ 'tɔ sü, mɛ 'wo bha ‑wa mɛ do ‑dhɛ Zosɛfu 'wo‑ ‑dhɛ Baazabasö, 'yö 'wo‑ 'tɔ kpɔ Zutusö, waa‑ Matiasö. ");
INSERT INTO daf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","'Yö 'wo ꞊bhɛa kwa Dëmɛ ‑dhɛ 'wo‑ pö: «Yi Dëmɛ, bhi 'ö 'i mɛ ꞊gban \"pɛpɛ zuëga dɔ, mɛ ꞊plɛ 'wo ya‑ mɛ 'dhɛ 'i i ‑kɔ ‑yɛ ‑bha ‑a ‑zɔn yi ‑dhɛ ");
INSERT INTO daf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kö ‑yö kë Zuda \"yɔɔ 'gü 'ka! ‑A ‑gɛn ‑mü ꞊dhɛ Zuda ‑yö kë ‑go ö ‑bha yë 'ö ‑kë i ‑bha \"ta 'sü ‑yë 'ka bha‑ 'gü 'yö dho ‑dhɛ 'ö‑ ꞊mɔɔ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","꞊Dhɛ ꞊wa bhɛa\" ꞊dhɛ ‑kɔ bha‑ 'dhö 'yö 'wo zë \"kpʋ̈ü ‑kë, 'yö to Matiasö ‑bha ‑bha, 'yö ‑da Yesu ‑bha bɔmɛ ‑nu ‑kaɔng do ga do bha‑ ‑nu \"piʋ̈. ");
INSERT INTO daf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","꞊Dhɛ 'ö Zuifö ‑nu ‑bha ꞊niidadhe 'wo‑ ‑dhɛ Pangtökɔtö bha‑ yi ꞊ya ꞊loo, 'dhang ‑bho Yesu \"dhiʋ̈ ‑mɛ ‑nu ꞊gban \"pɛpɛ ‑wo ‑gun ‑dhɛ do 'gü 'kɔ do 'bha 'gü. ");
INSERT INTO daf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","'Wo dho \"kan wo ‑ta kö pë vin \"gbɩɩ‑ 'bha ꞊ya ‑da ‑nu \"tʋ 'gü dhang‑ 'gü. ‑A vin‑ ‑kë ꞊dhɛ \"tɛɛ \"gbɩɩ‑ 'ö ‑ziö ‑a 'dhö 'yö 'kɔ 'wo gun‑ 'gü bha‑ pa. ");
INSERT INTO daf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","'Yö pë 'bha 'ö bhɔ pɛng 'nɛɛ‑ ‑bha bha 'ö ‑ya ‑a ‑nu ꞊gbin‑ 'dɔɔndhö. ");
INSERT INTO daf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","'Yö 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ‑yö ‑da ‑a ‑nu 'gü, 'yö‑ ‑nu ꞊gban \"pɛpɛ pa, 'yö 'wo ‑ya dhiang zë ‑sü ‑bha ‑wʋ \"wɛɛ 'ö 'waa‑ dɔ 'nu ‑blɛɛsü bha‑ 'gü ꞊dhɛ ‑kɔ 'ö Atanna ‑bha 'Nii‑ bha 'ö‑ dɔ‑ 'ka‑ ‑nu \"dhi ‑a 'dhö. ");
INSERT INTO daf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","‑A yi 'ö \"dhʋ̈ bha‑ 'ka kö Zuifö ‑nu 'wo Zedhizadhɛmö 'plöö, waa‑ mɛ 'dhɛ ‑nu 'wo go \"sɛ \"pɛpɛ ꞊gban 'gü, 'ö 'wo ‑kë Atanna ꞊bhlëëyamɛ 'ka kö ‑wo Zedhizadhɛmö mü. ");
INSERT INTO daf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","꞊Dhɛ 'ö pë vin bha ꞊waa‑ ma, 'yö‑ mɛ kpö 'gbɛ ꞊dede 'wo nu 'kɔ bha‑ \"dhi \"dhiʋ̈ mü ꞊gbang 'wo‑ dɔ sië 'kɔɔdhö mü bha‑ ‑wɔn 'gü. 'Wɔn bha‑ 'wɔn ‑ya ‑nu ‑kɔn ꞊dedewo, ‑a ‑gɛn ‑mü ꞊dhɛ mɛ \"pɛpɛ 'wo nu \"dhʋ̈ bha ‑wo 'dhang ‑bho Yesu \"dhiʋ̈ ‑mɛ ‑nu ‑wʋ 'gü ma wo ‑dɩ ‑wʋ ‑nu 'gü 'do 'do 'ka, 'ö dhiang ‑nu 'wo‑ zë sië bha 'wo‑ 'gü ma 'kpakpadhö. ");
INSERT INTO daf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","꞊Dhɛ 'ö‑ 'wɔn ‑ya ‑nu kɔn \"dhʋ̈, 'yö 'wo ‑ya \"kaabho bho ‑sü ‑bha 'wo‑ pö: «‑Ka dɔ! 'Mɛ 'wo dhiang zë sië ya, Gadhidhe ‑mɛ ‑nu 'waa ‑mü ‑ee? ");
INSERT INTO daf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","‑Yö kë ‑kɔ ‑kë ꞊dhɛ 'yö dhiang ‑nu 'wo‑ zë sië ya kwa‑ 'gü ma kwa ‑dɩ ‑wʋ ‑nu 'gü 'do 'do 'ka? ");
INSERT INTO daf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","\"Kɛɛ kö 'mɛ 'kwa ya mɛ 'bha ‑nu ‑go Paatö ‑sɛ ‑nu oo, Medi ‑sɛ ‑nu waa‑ Edhamö ‑sɛ ‑nu 'gü, 'ö mɛ 'bha ‑nu ‑wo go Mezopotami ‑sɛ, Zude ‑sɛ, Kapadɔsö ‑sɛ, Pɔng ‑sɛ, Azi ‑sɛ ");
INSERT INTO daf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Flizi ‑sɛ, Panfidhi ‑sɛ, Ezitö ‑sɛ waa‑ Dhibi ‑pö ‑nu 'wo Sidhɛnö ‑dhɛ ‑züzü ‑a ‑nu 'gü, 'ö mɛ 'bha ‑nu 'wo go Wlɔmö, ");
INSERT INTO daf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","'ö mɛ 'wo Zuifö 'në ꞊dede 'ka 'pö, 'mɛ 'wo wo zuë\" ꞊slëë 'pö Zuifö ‑nu ‑bha bhɛa\" ‑kɔ 'gü waa‑ mɛ ‑nu 'wo go Klɛtö ‑dhɛ ‑nu, waa‑ Adhabi ‑sɛ ‑nu 'gü 'wo mü, \"kɛɛ 'yö dhiang ‑nu 'wo‑ zë sië 'ö ‑gban Atanna ‑bha 'wɔn ‑së 'ö‑ ‑kë ‑a ‑bha bha 'kwa‑ ma kwa ‑dɩ ‑wʋ ‑nu 'gü 'do 'do 'ka?» ");
INSERT INTO daf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","‑A 'wɔn ‑ya ‑nu ‑kɔn ꞊dedewo 'ö 'pë 'wo dho‑ pö 'wii‑ dɔ, 'yö 'wo‑ pö wo 'ko ‑nu ‑dhɛ: «꞊Ya kë \"dhʋ̈ kö 'wɔn ya‑ 'klɔɔ‑ ‑mü ‑më 'ka?» ");
INSERT INTO daf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","\"Kɛɛ ‑a mɛ bha ‑nu ‑zë kö ‑wo ꞊wɛɛ dɔ sië 'dhang bho Yesu \"dhiʋ̈ ‑mɛ ‑nu ‑bha 'wo‑ pö: «‑Aa, n 'bha, 'mɛ 'wo bha we ꞊në ꞊yaa‑ ‑nu 'kun!» ");
INSERT INTO daf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","'Yö Piɛdhö waa‑ Yesu ‑bha bɔmɛ ‑nu ‑kaɔng do ga do ‑kpɛa 'wo to bha 'wo ꞊wlü 'wo dɔ wo ‑gɛan 'mɛ 'wo bha‑ ‑nu wëëdhö, 'yö Piɛdhö ‑yö ö ‑wʋ \"dhiʋ̈ ꞊wlü 'yö dhiang zë‑ ‑nu ‑dhɛ 'ö‑ pö: «'Mɛ 'ka Zuifö 'ka, 'ö 'ka Zedhizadhɛmö ‑pö ya‑ 'gü waa 'mɛ 'ka nu, ‑ka ka \"tʋ 'to kö 'wɔn 'ö kë sië bha 'a‑ ‑gɛn pö ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","‑A ‑gɛn ‑mü ꞊dhɛ 'mɛ 'ka‑ ‑nu ‑ga sië bha we 'yaa‑ ‑nu ‑bha ꞊dhɛ ‑kɔ 'ka ka ‑zʋ 'gɔn sië‑ 'ka bha‑ 'dhö. ‑A 'klɔɔ‑ ‑mü ꞊dhɛ \"tʋ̈ng 'kwa dɔ‑ 'ka ya \"yënng \"tɛɛ ‑ta ‑mü (we ‑bha mɛ 'kun \"tʋ̈ng 'yaa kë ꞊ni!). ");
INSERT INTO daf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","\"Kɛɛ 'pë 'ö Atanna ‑yö bɔ ö ‑wʋdhiʋ̈loomɛ Zoɛdhö 'gü 'ö‑ pö yi 'bha 'ka bha 'yö‑ 'gü ‑wɔn 'dhö kë sië ꞊dɛɛ bha. ");
INSERT INTO daf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‑A ‑gɛn ‑mü ꞊dhɛ Atanna ‑ya ‑pö Zoɛdhö ‑dhɛ 'ö‑ pö: ‹\"Tʋ̈ng ‑totaamasü 'gü, a ‑dho ma 'Nii‑ 'gü ‑gblü mɛ suu \"pɛpɛ ꞊gban ‑ta, 'ö ka gbö ‑nu waa‑ ka 'dhu ‑nu 'wo n ‑wʋ \"dhiʋ̈ ꞊loo, 'ö ka ‑bha 'në \"wlü ‑sü ‑nu \"yan 'gü 'dhö ‑da 'wo tɛanwɔn 'ö ‑gban Atanna ‑bha ‑a dɔ 'Ö kaa‑ mɛ zizi ‑nu 'wo \"yɛɛn bho (tɛanwɔn ‑nu 'wo Atanna \"piʋ̈) ‑a 'ka. ");
INSERT INTO daf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tɛan‑ ꞊dede 'ka, a ‑dho ma 'Nii‑ 'gü ‑gblü ma yëkëmɛ ‑nu, gɔɔn‑ ‑nu waa‑ dhong ‑nu ‑ta kö ‑wo n ‑wʋ \"dhiʋ̈ ꞊loo yi 'ö bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","A ‑dho \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu kë dhang‑ 'gü ‑dhɛ ‑nu waa‑ \"kpʋngtaadhɛ ‑nu 'gü. ꞊Yɔɔn ‑nu, pɛng ‑nu waa‑ pɛng \"gbiën ‑nu ‑wo ‑dho kë. ");
INSERT INTO daf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","'Yënng‑ 'bhü‑ ‑dho kë tii, 'ö \"su ‑yö ‑kë ꞊dhɛ ꞊yɔɔn 'dhö, 'yö yi 'ö kwa Dëmɛ ‑ya ‑ya ö 'tɔ bhɔ ‑yi 'ka, yi 'kpii‑ bha 'yö gun ‑na ꞊loo. ");
INSERT INTO daf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","꞊Ya bo kë ‑sü 'ka \"dhʋ̈, mɛ \"ʋʋ mɛ 'ö dho kwa Dëmɛ mɔɔ‑, ‑yö ‑dho \"ta‑ ‑mɛ ‑dhɛ 'ö‑ dha›.» ");
INSERT INTO daf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","'Yö Piɛdhö ‑yö dhiang zë 'zü 'ö‑ pö: «Izraɛdhö ‑mɛ ‑nu, ‑ka ka \"tʋ to: Yesu 'ö go Nazadhɛtö bha Atanna ‑ya ‑bɔ kwa ‑dhɛ, 'yö bɔ‑ 'gü kö ‑ya ‑zɔn kwa ‑dhɛ ꞊dhɛ yö ꞊në‑ bɔ, 'yö \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu ‑kë ꞊dhɛ ‑kɔ 'ö kaa ꞊dede 'ka‑ dɔ‑ 'ka bha‑ 'dhö. ");
INSERT INTO daf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","\"Kɛɛ 'yö 'wo‑ \"dhiʋ̈ dɔ ka ‑dhɛ ꞊dhɛ ‑kɔ 'ö gun‑ 'ka Atanna zuë\" \"piʋ̈ 'nu ‑blɛɛsü, 'ö gun‑ \"piʋ̈ ꞊dhɛ ‑yö kë‑ 'ka ‑a 'dhö, 'yö 'ka‑ dɔ 'wɔnyaakëmɛ ‑nu ‑gɔ, 'yö 'wo‑ dɔ \"dhü ‑bha 'wo‑ zë, ");
INSERT INTO daf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","\"kɛɛ ꞊dhɛ 'ö ꞊wa bo‑ ‑wëëdhɛ bho ‑sü 'ka 'ö ꞊ya ga, Atanna ‑ya ‑bho ga ‑bha \"dhiʋ̈dhɛ ‑gɔ 'ö‑ bo, ‑a ‑gɛn ‑mü ꞊dhɛ ga faan 'yaa ꞊mɔɔ‑ ‑bha kö ‑yö wɔ‑ ‑ta ");
INSERT INTO daf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","꞊dhɛ ‑kɔ 'ö Davi ‑ya pö‑ 'ka yi 'bha 'ka ‑a ‑bu 'gü 'ö‑ pö ꞊dhɛ: ‹A‑ 'wɔn dɔ ꞊dhɛ n Dëmɛ ‑yö n \"piʋ̈ ‑kpɛawo, 'ö n ‑maa ‑kë, ‑a ‑wɔn 'gü n 'yaɔ‑ ‑nu ‑kɔ 'yii 'dho ꞊mɔɔ n ‑bha. ");
INSERT INTO daf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yö ꞊në‑ ‑wɔn 'gü 'yö n ꞊nii 'dhö ‑da, 'yö 'a dhiang zë zuë\" ꞊nii ‑da 'ka. A‑ 'wɔn ‑dɔ ꞊dhɛ a ‑dho ga ‑dhɛkpaɔyi do 'ka, \"kɛɛ a n ‑zʋ ‑yö 'pë 'ö Atanna ‑ya pö ö ‑dho kë n ‑dhɛ bha‑ ‑dhɛ ‑kpɛawo. ");
INSERT INTO daf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","‑A ‑gɛn ‑mü ꞊dhɛ a‑ ‑pö ‑dhɛ: 'Bhii 'dho kwaa‑ n 'nii‑ ‑zü ꞊geebɔɔ, ꞊ya 'go mü 'bhii 'dho \"wɩ‑ ‑bha kö i ‑bha yëkëmɛ \"slʋ̈ʋ̈slʋ̈ bha‑ kwi ‑yö \"bu. ");
INSERT INTO daf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","'Bha ‑tosɛa kë ‑zian ‑zɔn n ‑dhɛ, i ‑bha ‑kë n \"piʋ̈ ‑sü bha ‑yö n zuë\" ꞊nii ‑da ‑kpɛawo› bha‑ 'dhö.» ");
INSERT INTO daf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","'Yö Piɛdhö ‑yö dhiang zë 'ö dho‑ 'ka ö \"dhiʋ̈ 'ö‑ pö: «N dheebhang ‑nu, ‑ka dɔ kö 'wɔn 'ö ‑gban kwa \"bhɛma ‑wɔngbɩɩsü Davi ‑bha bha 'a‑ pö ka ‑dhɛ 'kpakpadhö. ‑A ‑gɛn ‑mü ꞊dhɛ Davi bha ‑yö ‑ga 'ö 'wo‑ ꞊gee bho, 'ö‑ bun 'dhö ‑tun ꞊dɛɛ kwa ‑gɔ yö. ");
INSERT INTO daf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","\"Kɛɛ 'ö gun kö ‑yö ‑tun \"yaan ‑yö ‑gun Atanna ‑wʋdhiʋ̈loomɛ 'ka, 'ö‑ 'wɔn dɔ 'kpakpadhö ꞊dhɛ ‑yö dhiang ‑zë ö ‑dhɛ 'ö ‑sö ‑bhö 'ö‑ pö ö ‑dhɛ ꞊dhɛ ö ‑dho ‑a suu 'gü ‑në do 'sü 'ö‑ ‑ya ö ‑bha ‑gblüdë 'ka ꞊dhɛ Davi 'dhö 'pö. ");
INSERT INTO daf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü 'wɔn 'ö dho kë 'yö Davi ‑ya to \"dhiʋ̈ 'ö‑ dɔ. 'Wɔn 'ö ‑gban Atanna ‑bha ‑Yamɛ ‑bha ‑go ga 'gü ‑sü ‑bha bha ꞊në 'ö‑ ‑dhiang zë 'ö‑ pö ꞊dhɛ: ‹Atanna 'yii ‑kɔ \"kan‑ \"dhiʋ̈ ꞊geebɔɔ kö‑ kwi ‑yö \"bu› bha. (‑A ‑kë \"dhʋ̈ ‑sü bha‑ 'gü, kö dhiang 'ö Davi ‑ya zë bha 'yii‑ bho ö ‑dɩ 'gü, Atanna ‑bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ ꞊në‑ dɔ‑ \"dhi.) ");
INSERT INTO daf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu 'a‑ ‑dhiang zë sië ka ‑dhɛ ya, Atanna ꞊yaa‑ bho ga 'gü, mɛ ꞊gban \"pɛpɛ kwa‑ \"sɛɛ‑ 'ka, kwa‑ 'wɔn ‑dɔ. ");
INSERT INTO daf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","'Yö‑ sü 'ö‑ ‑ya ‑yɛa ꞊bhlëësü 'ö‑ \"sɔɔ dhang‑ 'gü bha‑ 'gü, 'yö 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ö‑ dë ‑ya \"plüün bho‑ ‑dhɛ bha‑ ꞊slɔɔ, 'yö‑ ꞊lɔɔ yi ‑ta. Pë ‑nu 'ka‑ yö sië \"ɛɛn 'ka‑ ma sië bha 'Nii‑ \"slʋ̈ʋ̈slʋ̈ bha ꞊në‑ ‑nu ‑kë. ");
INSERT INTO daf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","‑A ‑gɛn ‑mü ꞊dhɛ Davi bha 'yii ‑da dhang‑ 'gü ꞊dhɛ Yesu 'dhö, \"kɛɛ ‑ya ‑pö 'ö‑ pö: ‹N Dëmɛ Atanna ‑ya ‑pö n Dëmɛ ‑dhɛ: ‑Bhö ‑ya ma ‑yɛa ‑së ya‑ 'gü! ");
INSERT INTO daf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Kö ‑yö 'to‑ 'ka \"dhʋ̈ ‑yö zun‑ 'ka yi 'a dho i ‑kɔ ziö‑ 'ka i 'yaɔ‑ ‑nu ‑gɔ bha‑ ‑bha›. ");
INSERT INTO daf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","꞊Dhɛ 'ö \"dhʋ̈ Izraɛdhö ‑mɛ ‑nu ꞊gban \"pɛpɛ, ‑ka 'dhang bho‑ \"dhiʋ̈ ꞊dhɛ Yesu 'ka‑ dɔ \"dhü ‑bha bha ꞊në Atanna ‑ya ‑ya mɛ ꞊gban \"pɛpɛ Dëmɛ, ‑a ‑bha ‑Yamɛ Klisi 'ka. Yö ꞊në Atanna ‑ya pö ö ‑dho bɔ mɛ \"bhɩɩ‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","꞊Dhɛ 'wo Piɛdhö ‑wʋ bha‑ ma, 'yö dho‑ ‑nu ‑gɔ ꞊gblɛɛn, 'yö pɛng ‑yö ‑kan ‑nu ‑bha, kö ꞊waa‑ 'wɔn dɔ ꞊dhɛ 'wa ‑da Atanna \"dhiʋ̈. 'Yö 'wo Piɛdhö waa‑ 'dhang ‑bho Yesu \"dhiʋ̈ ‑mɛ ‑nu 'wo to bha‑ ‑nu dhɛɛ\" kpɔ 'wo‑ pö: «Yi dheebhang ‑nu, ꞊dhɛ 'ö \"dhʋ̈ bha 'yi‑ kë ꞊dhɛ?» ");
INSERT INTO daf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","'Yö Piɛdhö ‑ya pö‑ ‑nu ‑dhɛ: «‑Ka bo ka ꞊sɔng 'ka kö 'mɛ 'ö \"dhʋ̈ ‑yö ö ‑bha ‑tosɛadhe slëë‑, kö ‑yö ö kwaa‑ ö kë ‑sɔng yaa ‑nu ‑zü, kö ‑wa ‑bɔ Yesu 'ka ‑zu bho Yes ‑a 'tɔ 'gü, kö ‑ya ‑bha 'wɔn yaa ‑nu ‑mawɔn 'to! ꞊Ya kë \"dhʋ̈ 'Nii‑ \"slʋ̈ʋ̈slʋ̈ 'ö Atanna ‑ya ꞊gbaɔ bha ka ‑dho ka ‑bha ꞊slɔɔ. ");
INSERT INTO daf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","‑A ‑gɛn ‑mü ꞊dhɛ ‑ya \"plüün ‑së bha‑ ‑bho kaa‑ ka bhang ‑nu ka ‑dhɛ, 'yö dho 'ö‑ bho 'pö 'mɛ 'wo \"sɛ \"wɛɛ ‑nu 'gü ꞊gblɛɛngblɛɛn, 'ö kwa Dëmɛ, kwa ‑bha Atanna dho‑ ‑nu ‑dhɛ kö ‑wo kë‑ ‑bha 'në ‑nu 'ka bha‑ ‑nu ‑dhɛ.» ");
INSERT INTO daf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","'Yö Piɛdhö ‑yö dhiang ‑nu zë 'zü 'gbɛ 'ka ‑a ‑nu ‑dhɛ, 'yö ‑dhio ‑nu dɔ‑ ‑nu ‑ta 'ö‑ ‑nu faan dɔ, kö ꞊wa \"wɩ dha ‑sü ‑wɔn ‑bha kö ‑wo 'go 'wɔnyaakëmɛ ‑nu 'wo Yesu zë, 'ö Atanna dho 'wɔn bho‑ ‑nu 'gü bha‑ ‑nu kpö 'gü. ");
INSERT INTO daf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","'Yö mɛ 'gbɛ 'wo 'dhang bho Atanna ‑wʋ 'ö Piɛdhö ‑ya pö bha‑ \"dhiʋ̈, 'yö 'wo‑ ‑nu ‑bɔ Yesu 'ka ‑zu bho. 'Yö mɛ 'wo ꞊mɔɔ mɛ \"gblü ‑yaaga ‑bha 'wo ‑da 'dhang ‑bho Yesu \"dhiʋ̈ ‑mɛ ‑nu \"piʋ̈ yi do bha‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","‑Wo ‑gun wo faan dɔ sië ‑kpɛawo 'ö 'wo wo \"tʋ to mɛ draan‑ ‑wʋ ‑nu 'ö Yesu ‑bha bɔmɛ ‑nu gun‑ ‑zɔn sië‑ ‑nu ‑dhɛ bha‑ ‑bha. 'Ö‑ ‑nu ‑kɔ ‑yö ‑kë 'wɔn do ‑bha, 'ö‑ ‑nu ‑bha ‑dhië gun do, ('yö 'wo to mü 'wo kwa Dëmɛ Yesu ‑bha ‑bhöpë ‑bhö), ‑a ‑nu ‑bha ‑bhɛa Atanna ‑dhɛ ‑sü ‑nu bha 'wo‑ ꞊gban ‑kë wo \"kwëë. ");
INSERT INTO daf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","\"Suʋ̈‑ ‑gun mɛ ꞊gban \"pɛpɛ 'gü, 'ö 'wo 'dhang ‑bho Yesu \"dhiʋ̈ ‑mɛ ‑nu ꞊bhlëë ‑ya \"dhabhliwɔn \"gblʋ̈gblʋ̈ ‑nu waa‑ ‑kian ‑wɔn 'gbɛ ‑nu 'ö‑ ‑bha bɔmɛ ‑nu gun‑ kë sië bha‑ ‑wɔn 'gü. ");
INSERT INTO daf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","'Dhang ‑bho Yesu \"dhiʋ̈ ‑mɛ ‑nu ‑gun wo kpö 'ka \"dhʋ̈ do, 'ö‑ ‑nu ꞊slɔɔpë ꞊gban‑ gun do. ");
INSERT INTO daf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","'Mɛ 'wo bha ‑wo gun woo‑ 'bhlaadhɛ ‑nu, \"ɛɛn pë ‑nu 'ö‑ ‑nu ꞊slɔɔpë 'ka ‑a ‑nu \"dhɔɔ dɔ sië 'yö 'wo‑ ‑naɔ ꞊loo 'ko ‑ta, 'yö 'pë 'ö ꞊mɔɔ 'mɛ 'ö \"dhʋ̈ ‑a ‑bha ‑kpla ‑bho 'ka ‑pë ‑bha 'wo‑ nu‑ ‑mɛ ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","'Yö 'wo ꞊loo 'ko ‑ta ‑dhɛkpaɔyi ꞊gban \"pɛpɛ 'ka Zuifö ‑nu ‑bha Atanna ‑dhɔkëgükɔ 'gü, 'yö 'wo kwa Dëmɛ Yesu ‑bha ‑bhöpë ‑bhö, kö ‑wo pë ‑nu ‑bhö sië 'ko \"piʋ̈ ‑a ‑nu ‑gɔ 'kɔɔdhɛ ‑nu 'gü ꞊niidadhe waa‑ zuëwaanusü 'ka. ");
INSERT INTO daf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","'Yö 'wo Atanna 'tɔ bhɔ, 'yö‑ ‑nu ‑dhɔ ‑yö \"sɛgümɛ ‑nu ‑kë. 'Yö kwa Dëmɛ Yesu ‑yö 'dhang bho ö \"dhiʋ̈ ‑mɛ 'ö ꞊wa dha ‑a ‑da ‑a ‑nu \"piʋ̈ yi ꞊gban \"pɛpɛ 'ka. ");
INSERT INTO daf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yi do 'ka kö Piɛdhö waa‑ Zan ‑wo 'dho sië Zuifö ‑nu ‑bha Atanna ‑dhɔkëgükɔ 'gü kö 'yënng‑ ꞊ya 'kpɔ mɛ ‑gɔ 'ka ‑a ‑nu ‑bha ‑bhɛa Atanna ‑dhɛ \"tʋ̈ng 'gü, ");
INSERT INTO daf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","'yö 'wo ‑gɛnloomɛ do yö kö ‑yö ‑ya ‑sü 'ka 'kɔdhi 'dhɛ 'wo‑ ‑dhɛ 'kɔdhi ‑sësü bha‑ \"dhiʋ̈. Gɔndë bha ‑yö ‑bhɔ ö ‑bha \"yua bha‑ 'ka. ‑Wo ‑nu 'ka ‑dhɛkpaɔyi ꞊gban \"pɛpɛ 'ka 'wo‑ ‑ya mü kö ‑yö 'wëëga ‑gbadhɛ 'mɛ 'wo ‑da sië Atanna ‑dhɔkëgükɔ 'gü bha ꞊në‑ ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","'Yö Piɛdhö waa‑ Zan ‑nu yö kö ‑wo 'dho sië Atanna ‑dhɔkëgükɔ 'gü, 'yö gba ‑dhɛ ‑a ‑nu ‑gɔ. ");
INSERT INTO daf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","'Yö Piɛdhö waa‑ Zan 'wo‑ ‑ga zuudhö, 'yö Piɛdhö ‑ya pö‑ ‑dhɛ: «‑Bhö ‑dhɛ ‑ga ꞊zɔɔ!» ");
INSERT INTO daf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","'Yö gɔɔn‑ bha 'ö ö \"yan \"dhiʋ̈ ꞊wlü 'yö‑ ‑nu ‑ga ‑së 'ka, ‑a ‑gɛn ‑mü ꞊dhɛ kö ‑yö ö ‑zʋ 'gɔn sië ꞊dhɛ ‑wo ‑dho pë 'bha nu ö ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","'Yö Piɛdhö ‑ya pö‑ ‑dhɛ 'zü 'ö‑ pö: «'Wëëga 'yaa n ‑gɔ kö 'a‑ nu i ‑dhɛ \"kɛɛ pë 'bha ‑yö n ‑gɔ, a ‑dho yö ‑zë nu i ‑dhɛ: Yesu Klisi 'ö go Nazadhɛtö bha‑ 'tɔ 'gü, ‑bhö \"wlü kö 'i \"ta!» ");
INSERT INTO daf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","꞊Dhɛ 'ö ꞊yaa‑ pö \"dhʋ̈ 'yö gɔɔn‑ bha‑ kun‑ kwɛɛ\" 'ka, 'yö‑ ꞊wlü, 'yö‑ ‑gɛn ‑yö dɔ dingdhö ‑a ꞊wlöö, ");
INSERT INTO daf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","'yö ‑wlö 'ö ‑gban ö ‑gɛn bha‑ ‑ta, 'yö ‑ya \"ta 'sü ‑sü ‑bha. 'Yö waa‑ Yesu ‑bha bɔmɛ ‑nu 'wo ‑da Atanna ‑dhɔkëgükɔ 'gü kö ‑yö \"ta 'sü sië, kö ‑yö ‑wlö sië, kö ‑yö Atanna 'tɔ bhɔ sië. ");
INSERT INTO daf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mɛ \"pɛpɛ 'wo gun 'mü ‑wa ‑yö kö ‑yö \"ta 'sü sië Atanna 'tɔ bhɔ ‑sü 'ka. ");
INSERT INTO daf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","꞊Dhɛ 'ö ꞊waa‑ ‑ga 'ö ꞊waa‑ dɔ ꞊dhɛ 'mɛ 'ö gun ‑ya ‑sü 'ka Atanna ‑dhɔkëgükɔ \"dhi ‑sësü \"dhiʋ̈, 'ö gun gba ‑dhɛ sië bha yö mü, 'yö \"suʋ̈ 'dhö ‑da ‑nu 'gü 'yö 'wɔn 'ö ‑kë ‑dhɛ bha‑ 'wɔn ‑ya ‑nu kɔn. ");
INSERT INTO daf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Gɔndënë bha 'yii go Piɛdhö waa‑ Zan ‑a ‑nu ꞊keng‑, ‑a ‑wɔn 'gü mɛ kpö 'wo gun Atanna ‑dhɔkëgükɔ 'gü bha 'mɛ bha‑ ‑kë \"klʋ̈ʋ̈klʋ̈ ‑wɔn bha 'yö‑ 'wɔn ‑ya ‑nu kɔn ꞊dedewo, 'yö 'wo ‑bɛang sü 'wo nu‑ ‑nu ‑zian 'ka 'kɔ \"gbɛɛtazëdhɛ 'dhɛ 'wo‑ ‑dhɛ Sadhomɔ ‑bha 'kɔ \"gbɛɛtazëdhɛ bha‑ 'gü. ");
INSERT INTO daf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","꞊Dhɛ 'ö Piɛdhö ꞊yaa‑ ‑nu yö, 'yö‑ pö‑ ‑nu ‑dhɛ: «Izraɛdhö ‑mɛ ‑nu, ‑më 'ö ‑kë 'yö 'mɛ ya‑ ‑kë \"klʋ̈ʋ̈klʋ̈ ‑sü ‑wɔn ‑yö ka kɔn? ‑Më 'ö ‑kë 'yö 'ka yi ‑ga ꞊dhɛ 'pë yi ꞊në 'yi gɔndënë ya‑ ‑bha \"yua bo yi ‑dɩ ‑bha 'gügbɩɩdhɛ \"ɛɛn yi ‑dɩ ‑bha ‑kplü Atanna ‑bha ‑kɔ ‑së 'ka ‑a 'dhö? ");
INSERT INTO daf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ablaamö, Izaakö waa‑ Zakɔbö ‑a ‑nu ‑bha Atanna 'ö ‑kë kwa \"bhɛma ‑nu ‑bha Atanna 'ka bha ꞊në‑ ‑kë kö mɛ ‑nu ‑wo ö ‑bha yëkëmɛ Yesu 'tɔ bhɔ ('yö‑ ‑bö 'ö‑ bho ga 'gü). Yesu 'ö \"dhʋ̈ bha Zuifö ‑nu kaa ꞊dede ka kë‑ ‑kun 'ka‑ dɔ kaa‑ \"sɛgɔdhiʋ̈mɛ ‑nu ‑gɔ, 'ö 'ka 'wɔn yaa ‑nu pö‑ ‑bha Pidhatö ‑kuu \"dhiʋ̈, \"kɛɛ kö yö ‑zë ‑ya \"piʋ̈ ꞊dhɛ 'ö ö kwaa‑ ‑zü. ");
INSERT INTO daf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'Ö 'kii \"wɩ mɛ 'ö \"slʋ̈ʋ̈slʋ̈, 'ö pö 'aa‑ ‑bha Atanna wëëdhö bha‑ ‑wɔn ‑bha, 'ö 'ka 'mɛ yö ‑zë 'ö ‑kë mɛzëmɛ 'ka bha ꞊në‑ ‑dhɛ Pidhatö ‑gɔ kö ‑ya bho ‑kaso 'gü ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","'Yö 'ka 'mɛ 'ö ‑tosɛadhe nu mɛ ꞊gban \"pɛpɛ ‑dhɛ bha‑ zë ‑kɔ bha‑ 'gü. \"Kɛɛ Atanna ‑ya ‑bho ga 'gü, yi‑ \"sɛɛ‑ 'ka. ");
INSERT INTO daf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","'Mɛ 'ka‑ dɔ 'kpakpadhö 'ö ‑ya ya, 'gügbɩɩdhɛ 'ö Yesu 'tɔ 'gü bha ꞊në‑ gba faan 'ka 'yö 'ka‑ ‑ga sië bha. ‑Zʋ ‑yö Yesu ‑dhɛ ‑sü ꞊në gɔndënë ya‑ ‑bha \"yua bo 'kpakpadhö mɛ ꞊gban \"pɛpɛ ka \"yaan bha. ");
INSERT INTO daf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","꞊Dhɛ 'ö \"dhʋ̈, n dheebhang ‑nu, 'a‑ ‑dɔ ꞊dhɛ 'wɔn kaa‑ ka ‑gɔmɛ ‑nu 'ka‑ ‑kë Yesu 'ka \"dhʋ̈ bha 'kaa‑ 'wɔn ꞊në‑ dɔ. ");
INSERT INTO daf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","\"Kɛɛ ‑yö ‑kë \"dhʋ̈ kö 'pë 'ö Atanna ‑yö bɔ ö ‑wʋdhiʋ̈loomɛ ꞊gban \"pɛpɛ ‑ta 'ö‑ pö bha‑ 'gü ‑wɔn ꞊në ‑yö kë. Yö ‑mü ꞊dhɛ ‑a ‑bha ‑Yamɛ ‑wëëdhɛ ‑dho bho. ");
INSERT INTO daf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","‑A ‑wɔn 'gü, ‑ka ka zuë\" slëë‑ kö 'ka ka wë ‑ya Atanna \"piʋ̈ kö ‑yö kaa‑ 'wɔn yaa ‑nu ‑mawɔn 'to. ");
INSERT INTO daf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","꞊Ya kë \"dhʋ̈, ‑yö ‑dho ‑ya ‑dɩ 'flëë‑ 'gü \"tʋ̈ng nu ka ‑dhɛ, 'ö 'mɛ 'ö ꞊yaa‑ ‑ya 'nu \"pɛpɛdhö ka Dhamɛ 'ka 'ö ‑kë Yesu 'ka bha‑ nu ka ‑dhɛ. ");
INSERT INTO daf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","꞊Ya 'go yö ‑zë 'gü, Yesu Klisi ‑dho 'to dhang‑ 'gü 'ö dho‑ 'ka \"dhʋ̈ 'ö zun‑ 'ka pë ꞊gban \"pɛpɛ kë ‑dee \"tʋ̈ng 'ö Atanna ‑yö bɔ‑ 'ka ö ‑wʋdhiʋ̈loomɛ 'ö‑ ‑nu ‑ya ‑dɩ ‑ta bha‑ ‑nu ‑ta, 'ö‑ pö 'ö‑ yi ꞊ya ꞊gwëë bha‑ ‑bha. ");
INSERT INTO daf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","'Yö Yesu ‑wɔn dhiang zë‑ ‑nu ‑dhɛ 'ö‑ pö: «Moizö kë‑ ‑pö yö ꞊në‑ ‑bu 'gü yi 'bha 'ka 'ö‑ pö: ‹Kwa Dëmɛ, kwa ‑bha Atanna ‑dho ö ‑wʋdhiʋ̈loomɛ 'ö ꞊dhɛ n 'dhö ‑a sü ka ꞊zinng 'gü 'ö‑ bɔ ka ‑dhɛ. 'Wɔn \"pɛpɛ 'ö dho‑ pö ka ‑dhɛ bha ‑kaa ma! ");
INSERT INTO daf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mɛ \"ʋʋ mɛ 'ö 'yii‑ ‑wʋ ma, ‑yö ‑dho 'go Atanna ‑bha mɛ ‑nu ꞊zinng 'gü 'ö‑ 'gü ‑yö ꞊see› bha.» ");
INSERT INTO daf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Atanna ‑wʋdhiʋ̈loomɛ ‑nu \"pɛpɛ 'ö go‑ 'ka Samiɛdhö ‑bha 'ö zun‑ 'ka ꞊dɛɛ ‑bha, ‑a ‑nu ꞊gban \"pɛpɛ ‑wo 'wɔn 'ö ‑gban 'yi bha‑ ‑bha bha‑ ‑dhiang ‑zë. ");
INSERT INTO daf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","'Pë 'ö Atanna ‑ya \"plüün bho 'ö bɔ‑ 'ka ö ‑wʋdhiʋ̈loomɛ ‑nu ‑ta bha ‑yö ka ‑bha 'ka, 'ö ‑nëngkwëëdhe 'ö‑ ‑da waa‑ ka \"bhɛma ‑nu wo ꞊zinng 'gü bha 'ö ka ‑bha 'ka 'pö. ‑A ‑gɛn ‑mü ꞊dhɛ ‑ya ‑pö Ablaamö ‑dhɛ 'ö‑ pö: ‹A ‑dho bɔ i suu 'gü ‑në ‑nu ‑ta 'a 'dhuë‑ ‑kë \"kpʋngtaamɛ \"pɛpɛ ꞊gban ‑bha›. ");
INSERT INTO daf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yö ꞊në‑ ‑wɔn 'gü, 'yö Atanna ‑yö ö ‑bha yëkëmɛ (Yesu) sü 'ö‑ bɔ ka ꞊në ka ‑dhɛ \"dhiʋ̈ ‑blɛɛsü ꞊kö kö ‑yö 'dhuë‑ kë ka ‑bha, \"kɛɛ kö ‑yö 'mɛ 'ö \"dhʋ̈ ‑a ‑kɔ bho‑ këwɔn yaa ‑nu bha 'do 'do 'ka.» ");
INSERT INTO daf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piɛdhö waa‑ Zan ‑wo ‑to dhiang ‑zë \"sɛgümɛ ‑nu ‑dhɛ ‑dhɛ 'gü, 'yö \"saabhomɛ ‑nu oo, \"yan ‑to Zuifö ‑nu ‑bha Atanna ‑dhɔkëgükɔ ‑bha ‑mɛ ‑nu ‑gɔmɛ ‑nu waa‑ Sadusiɛn ‑nu 'wo dɔ ‑bɛang ‑bha 'wo nu. ");
INSERT INTO daf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yesu ‑bha bɔmɛ ‑nu ‑bha \"sɛgümɛ ‑nu draan‑ ‑wɔn bha 'yii dhi‑ ‑nu ‑dhɛ, ‑a ‑gɛn ‑mü ꞊dhɛ ‑wa ‑pö \"sɛgümɛ ‑nu ‑dhɛ ꞊dhɛ Yesu ‑yö ‑go ga 'gü kö ‑ya ‑zɔn ꞊dhɛ 'mɛ ꞊wa ga ‑wo ‑mɔɔ ‑bha kö ‑wo 'go ga 'gü. ");
INSERT INTO da