﻿USE sofia;
DROP TABLE IF EXISTS sofia.dad_vpl;
CREATE TABLE dad_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dad_vpl WRITE;
INSERT INTO dad_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesus Kristus wõ yen, anĩ nẽ ibor gĩ isin, Ĩ Dawid tubu, Abraham nẽ ibor. ");
INSERT INTO dad_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Isak, ne tama Abraham, Jakop, ne tama Isak, Juda, ne tura tar geid, idi temeid Jakop, ");
INSERT INTO dad_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Feres Sera ado, nedi temeid Juda, nedi sineid Tamar, Hesron, ne tama Feres, Ram, ne tama Hesron, ");
INSERT INTO dad_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadab, ne tama Ram, Nason, ne tama Aminadab, Salmon, ne tama Nason, ");
INSERT INTO dad_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Boas, ĩ yogon tama Salmon, Boas sina Rahab, ĩ haiden kayau, Israel kayau sã, Obed, ĩ yogon tama Boas, yogon sina Rut, ĩ haiden kayau, Israel kayau sã, Jesi, ne tama Obed, ");
INSERT INTO dad_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","King Dawid, ne tama Jesi. Solomon, ne tama Dawid, Solomon ne sina ĩ, kulu kusĩ mudur Uria nẽ kayaun, ");
INSERT INTO dad_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Rehoboam, ne tama Solomon, Abiya, ne tama Rehoboam, Asa, ne tama Abiya, ");
INSERT INTO dad_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jehosafat, ne tama Asa, Jehoram, ne tama Jehosafat, Usia, ne tama Jehoram, ");
INSERT INTO dad_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jotam, ne tama Usia, Ahas, ne tama Jotam, Hesekia, ne tama Ahas, ");
INSERT INTO dad_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manase, ne tama Hesekia, Amon, ne tama Manase, Josia ne tama, Amon, ");
INSERT INTO dad_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jekonia in tura tar geid, nedi temeid Josia, sain anĩ bun, Babilonem Israel tamo kayau guri difeid dirou, Babilon kalabus bun dilen. ");
INSERT INTO dad_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon kalabus bun dilen sain anĩ bunem, Sieltiel, ne tama Jekonia, Serubabel, ne tama Sieltiel, ");
INSERT INTO dad_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiud, ne tama Serubabel, Eliakim, ne tama Abiud, Asor, ne tama Eliakim, ");
INSERT INTO dad_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadok, ne tama Asor, Akim, ne tama Sadok, Eliud, ne tama Akim, ");
INSERT INTO dad_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleasar, ne tama Eliud, Matan, ne tama Eleasar, Jakop, ne tama Matan, ");
INSERT INTO dad_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Josef ĩ, ne tama Jakop, Josef ĩ Maria aiwa, Maria ĩ Jesus gõ fen, Jesus ĩ anĩ Kristus dedig. ");
INSERT INTO dad_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Anĩ nigin, ibor Abraham bun tamal ile Dawid, are ibor 14, Dawid bun tamal ile Babilon kalabus dilen, are ibor 14, kalabus bun tamal ile Kristus wõ yen, are ibor 14. ");
INSERT INTO dad_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus wõ yen anĩ eig fiya: In sina Maria Josefem yalouf nigin digirkenen, anĩ ere, idi uruwom fau mois diyo ken, Awa Uur Fateul bunem Maria bou adon anĩ dilen. ");
INSERT INTO dad_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josef, Maria ne aiwa, ĩ nun karĩya tamo, anĩ ĩ Maria atun meleid bun yana sane ifenẽya itor ken, yaor to wogõ yen, ĩ namen kayau anĩ itornẽf nigin kisi fen. ");
INSERT INTO dad_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Agef kisif mog, Negur nẽ engel, imĩya bun ĩ wagen wõ ye fen, iron, “Josef, Dawid naal, Maria wale fõ bun on kayau ibodõf nigin to kumĩ wo, ere nigin, Maria namen kare fef are, Awa Uur Fateul bunem. ");
INSERT INTO dad_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kayau anĩ kesu monog gõ fouf, õ yana ũ Jesus wouf, ere nigin, yogon tamo kayau mosor bun temeleid kel gei fouf.” ");
INSERT INTO dad_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Negur nẽ od, profet sigor bun eig ye wogõ yen anĩ kisi falauf nigin, enĩ ganan wõ yen: ");
INSERT INTO dad_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kayau taulei kesu adouf, kesu monog gõ fouf, idi yana dũ Imanuel douf,” anĩ nẽ gariya, “Negur ĩ ada ado.” ");
INSERT INTO dad_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sain Josef irik yen, Negur nẽ engel wogõ fiyen kilei agef fen, Maria yale fõ bun irou ile, in kayau ibodon. ");
INSERT INTO dad_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Anĩ ere, ĩ kayau ado bouweid bagu fiya san, ile kesu monog matu gõ fen, anĩ Josef kesu yana yũ Jesus yen. ");
INSERT INTO dad_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","King Herod nẽ sain bun, Jesus Betlehem fonõ Judia distrik bun wõ yen, anĩ bure fele di, keleĩ tamo gaa iseyan temeleid Jerusalem disin, ");
INSERT INTO dad_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","idi to difen, “Kesu momou Juda neid king wõ youf den anĩ, nain wõ yen? Amã in barisa gaa iseyan melem mailen, ĩ yana malesauf nigin masin.” ");
INSERT INTO dad_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herod od anĩ karĩ yen, ĩ wau morõ fen, idi Jerusalem dibodon anĩ ganan geid waud morõ fedin. ");
INSERT INTO dad_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Agef fen, tamo kayau neid pris odudug ganan ado, lo ifelnẽdiya tamo ganan iweigneĩd, guru dife di, ĩ to fedin, “Kristus nain bagai wõ youf?” ");
INSERT INTO dad_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Idi aiten dalen, “Oun Betlehem fonõ Judia distrik an, age fouf nigin kulu profet eig ye itoton: ");
INSERT INTO dad_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Õ Betlehem, Juda teneub bun, õ Juda neid uyu irouya atun naal bagai sã, fau õ bunem tamo yana odug ado wõ youf, ĩ anim neu tamo kayau Israel marau ibodõf.’ ” ");
INSERT INTO dad_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Age de di, Herod gaa iseyan keleĩ tamo iminẽyan iweigneĩd fen, ere sain bagai barisa anĩ wõ yen anĩ kelein. ");
INSERT INTO dad_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ĩ idi Betlehem sur feid fen, iron, “Ulagauf, kesu anĩ foinenem ed ge umirẽgouf. Kesu anĩ fata gouf, kaisã bagai aya urokanag, ago ge di, ayag ele fen, yana alesauf.” ");
INSERT INTO dad_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","King nẽ od karĩ del fen, idi naab dale dilen, age de mog, barisa oun gaa iseyan idi dilen anĩ, ĩ ket uyu ile, kesu yenen nẽ modoũ an bagai dẽ yel ifaren. ");
INSERT INTO dad_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Barisa anĩ dẽ yele di, dile fen, idi waud kulĩya odug bagai adon. ");
INSERT INTO dad_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Fõ namen disorũ dilen, kesu sina Maria ado diledin, idi bobou dife fen, in yana dalesen, age de fen, nedi faa diwareĩd fen, safina ege luwa eneidi difenen, are gol, aa gaula sumeĩ nigin tõ fiyadig, moul aa bun tamal sumeĩ biya biya ado anĩ. ");
INSERT INTO dad_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Herod wagenem to ke de dilauf nigin, imĩya bunem wedereid iroun, anĩ nigin, idi neid teneub bun ke douf nigin naab taka dalen. ");
INSERT INTO dad_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Idi dilel mog, Odug nẽ engel, imĩya bun Josef wagen wõ yen, ĩ iron, “Fã wo, kesu sina ado gei wo, uyag Isip uleg, an ubodõg uleg mog, aya fau arokonõf, gama bagai Herod kesu imirek yukesiyouf nigin age fef.” ");
INSERT INTO dad_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Anĩ nigin, Josef fã yen, kesu sina ado gei feid, bõ turan Isip diya dilen. ");
INSERT INTO dad_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josef fau an ibod mog, Herod laa fen. Anĩ bun, Odug nẽ od, profet sigor bun eig ye wogõ yen anĩ, wõ ye kisi felen, “Isip bun tamal aya neu kesu aweignen.” ");
INSERT INTO dad_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod mogo kisi yalen, “Gaa iseyan keleĩ tamo aya didegnan,” ye fen, ĩ mogo fatuk bagai seye yen, keleĩ tamo naa nigin solo de dirokenen anĩ bun kisi es fe fen, Betlehem fonõ kalilĩ fiya anĩ kesu monog yar uru, yar tekelei anĩ ganan didenkesiyouf nigin bagai ari fedi di, didenkesin. ");
INSERT INTO dad_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Anĩ bun, Negur, profet Jeremaia bunem eig ye wogõ yen anĩ, agef kisi felen: ");
INSERT INTO dad_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama fonõ ait taka, inã wau gudũ fiya odug karĩ den, Rahel inã odug gere tar nigin yalen, ĩ taka nem bobo fiyẽf anĩ itoron, ere nigin, yogon kesu taka to mata ibodon.” ");
INSERT INTO dad_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod laa fe di, Odug nẽ engel, Josef Isip ibod mog, imĩya bun ĩ wagen wõ ye fen, ");
INSERT INTO dad_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","iron, “Fã wo, kesu sina ado gei wo, Israel teneub bun ule, ere nigin, idi kesu yukesiya nigin age difen are mogo gare den.” ");
INSERT INTO dad_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Age fe di, Josef fã yen, kesu sina ado gei feid, Israel teneub bun diyok dilen. ");
INSERT INTO dad_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Anĩ ere, ĩ, Akelaus ĩ mogo tama Herod fotokar Judia teneub lo fef ya anĩ karĩ ye fen, ĩ an ileya nigin kumĩ yen. Imĩya bun weder iroun nigin, ĩ tokõ fel, Galili distrik ilen. ");
INSERT INTO dad_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Josef ilen, taun taka Nasaret dedig an ibodon. Anĩ bun, profet od eig de wogõ den anĩ kisi felen, “Ĩ Nasaret tamo douf.” ");
INSERT INTO dad_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sain anĩ bun, Jon naan igunẽdiya tamo isin, gerere tuan Judia teneub bun biya od wogõ ye fen, ");
INSERT INTO dad_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","iweig iron, “Wauĩ falei gei, ere nigin, saa tano mogo melsak.” ");
INSERT INTO dad_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tamo enĩ nigin profet Asaia eig ye wogõ yen, “Ait taka gerere tuan iweig iron, ‘Odug nẽ naab dodok gei, in naab madur gei.’” ");
INSERT INTO dad_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ne gabar are kamel siwi, ĩ gaar gabar nem lũ diwan anim luwa gu fedig. Yogon saaf totobi nin te ado. ");
INSERT INTO dad_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tamo kayau Jon wagen guru difen, idi Jerusalem, Judia teneub ganan, Jordan naan kalilĩ fiya anĩ adok bun temeleid. ");
INSERT INTO dad_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Idi neid mosor yaor difele di, Jon Jordan naan igunẽdin. ");
INSERT INTO dad_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Anĩ ere, ĩ naan iguneĩd mog, Farisia tamo, Sadusia tamo geid musei disi di, ileid fen, ĩ idi irokenẽdin, “Ã, gogour sane gere tar! Didi isiyouf anĩ wal ge fen, uyagauf nigin aim irokenein? ");
INSERT INTO dad_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wauĩ falei gef are, age fiya gen faat biya ũ gouf. ");
INSERT INTO dad_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ã aug nigin kisi to eig ye irõf, ‘Abraham nemã tamamã.’ Aya arokeneik, meein eneidi bun Negur sã irõ di, Abraham gere tar wowã douf. ");
INSERT INTO dad_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Safor aayũ gariyan mogo ibodok, aayũ ganan faat biya to yuk, are itu ira ken, yã malan irãf. ");
INSERT INTO dad_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Wauĩ falei gef nigin, aya naan nem naan aguneik, anĩ ere, taka ĩ aya dumeun isiyouf, ĩ megeir barikã aya wal fiya, ayam yogon ye su inukeis kenẽya kisi feleya sã. Ĩ Awa Uur Fateul yã ado nem naan iguneĩf. ");
INSERT INTO dad_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ĩ susu fiya nẽ fok iman ado, ĩ yogon susu fiya nẽ mayã waĩ fouf, yogon wit biya are wit fõ bun kuruf fen, wit ido yã mala faimud bun an irãf.” ");
INSERT INTO dad_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Anĩ bure fele di, Jesus Jonem naan igunẽf nigin Galili tamal Jordan naanũ isin. ");
INSERT INTO dad_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Anĩ ere, Jon Jesus gudũ fiye ken, iron, “Onom aya naan igunaya, ere nigin aya garan usif?” ");
INSERT INTO dad_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus aiten yalen, “Arokonok nem ago. Negur nẽ madur bagai anĩ ganan kisi falauf nigin ada age tafouf, are biya.” Age ye di, Jon dõf age fen. ");
INSERT INTO dad_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus naan yale bure fel fen, kaisã bagai ĩ naanũ tamal fã yen. Agef mog bagai, saa ilun bobog kã fele di, ĩ lof mog, Negur nẽ Awa Uur, ninã kuburir gen Jesus muduren isi, lalan ifenen. ");
INSERT INTO dad_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ait taka saa ilun iweig iron, “Eĩ neu Kesu, ĩ nigin aya wau laa fedig, ĩ nigin aya wau kulĩ yedig.” ");
INSERT INTO dad_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Anĩ bure fele di, Awa Uur Jesus itonẽ di, gerere tuan ile, Satanem kisi fiyen. ");
INSERT INTO dad_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ĩ kuri ibodon, naa foti bõ foti bure fele di, ĩ naũ fen. ");
INSERT INTO dad_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kisi fiyẽya tamo Satan, ĩ bun wõ ye fen, irokenen, “Õ Negur Naal ouf are, meein enidi urõ di, bret falei fediyouf.” ");
INSERT INTO dad_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesus Satan aiten yalen, “Negur nẽ Itotoya bun eig ye irok, ‘Tamo bretem dogol to mata ifenẽf, sã, od ganan Negur sigor bun isif anim mata ifenẽf.’ ” ");
INSERT INTO dad_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Age fe di, Satan Jesus yale irou, fateul taun Jerusalem irou iselen, an tempel fõ soko ilun bagai inenẽ ifaren. ");
INSERT INTO dad_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Satan iron, “Õ Negur Naal ouf are, ogo ufũ urã. Ere nigin, Negur nẽ Itotoya bun eig ye irok, “‘Negur õ nigin yogon engel ari fedi di, idi õ imedim ololon daleyõf, age dife di, õ yẽ meein takam to itutu ouf.’ ” ");
INSERT INTO dad_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus Satan aiten yale iron, “Negur nẽ Itotoya taka buneg eig ye irok, ‘Odug ogon Negur kisi fiya bun to unenẽf.’ ” ");
INSERT INTO dad_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Baban, Satan Jesus yale irou, arei odug ilun biya isel fen, teneub enei nẽ tano ganan, nedi biya fiya adok ifelnen. ");
INSERT INTO dad_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Satan iron, “Enidi ganan aya afonõf, õ wageun bobou wo, selu wabiyouf are.” ");
INSERT INTO dad_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus Satan irokenen, “Satan, utorna ule! Ere nigin, Negur nẽ Itotoya bun eig ye irok, ‘Odug ogon Negur seli wabi fen, ĩ dogol aruna walouf.’ ” ");
INSERT INTO dad_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Age ye di, Satan Jesus itornẽ ile di, engel disi Jesus aruna dalen. ");
INSERT INTO dad_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesus mogo, Jon kalabus ibodon anĩ karĩ ye fen, kel Galili distrik ilen. ");
INSERT INTO dad_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jesus Nasaret taun itor ile, Kapenaum taun ibodon, Kapenaum are Galili daliyou sirin, Sebulun Naptali ado idi neid teneub akor bun ibodon. ");
INSERT INTO dad_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Od profet Asaia eig ye wogõ yen anĩ kisi falauf nigin, agef wõ yen, ");
INSERT INTO dad_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun nẽ teneub, Naptali nẽ teneub, are naab maaĩwõ ileyan, Jordan naan sitakã, Galili distrik haiden Israel sã anidi dibodok nẽ, ");
INSERT INTO dad_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","tamo kayau gugum bun difaren, idi lalan odug dilen, tamo kayau laa teneub ado laa nẽ buri bun dibodon idi bun lalan iran.” ");
INSERT INTO dad_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sain anĩ bunem ilen anĩ, Jesus biya od wogõya gariya inon, “Wauĩ falei gei, ere nigin, saa tano mogo melsak.” ");
INSERT INTO dad_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus Galili daliyou yeri iyok isil fen, mala iran uru tura ado iledin, Simon yana taka Pita, yogon tura Endru ado. Idi maaĩ daliyoun kakãg diran, ere nigin, idi gau yaleya tamo. ");
INSERT INTO dad_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus iron, “Usig, aya dõ wiyag len, aya ã tamo gei fiya tamo aneneĩf.” ");
INSERT INTO dad_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kaisã bagai, idi neid kakãg folõ difel fen, Jesus dõ difen. ");
INSERT INTO dad_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Anenem iyok ile fen, Jesus baban mala iran uru tura ado iledin, Jems Sebedi ne naal, yogon tura Jon ado. Idi waag bun nedi temeid Sebedi geid kakãg madur difedif dibodon. Jesus disiyouf nigin iweignẽdin. ");
INSERT INTO dad_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kaisã bagai, temeid waag ado ditor ken, Jesus dõ difen. ");
INSERT INTO dad_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus Galili distrik akor anĩ adok iyo ken, Juda neid uub fõ bun od ifelneĩd, saa tano ne biya od anĩ wogõ fedin, agef fen, tamo kayau atun dagi fire fire ado ilõyabidiya adok el fedin. ");
INSERT INTO dad_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ĩ nigin od anĩ, Siria teneub ganan bun iyokelen, age fe di, tamo kayau idi, dagi taka taka adodo anidi ganan Jesus wagen guri difeid, disin, idi darau odug biya adodo, idi kaa sesen adodo, idi mir adodo, idi bouweid ilolaisidiya anĩ, Jesus el fedin. ");
INSERT INTO dad_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Guru fiya odug, Galili temeleid, Dekapolis temeleid, Jerusalem temeleid, Judia teneub ado Jordan naan sitakã teneub akor anĩ ganan tamo kayau Jesus dõ difen. ");
INSERT INTO dad_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Gama tamo kayau musei guru dife di, Jesus ileid fen, arei wala bun isel ibodon. Yogon dõ fiya tar Jesus wagen disin. ");
INSERT INTO dad_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesus gariya ino ifelneĩd fen, iron, ");
INSERT INTO dad_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aib idi uur nigin maleg dibodok, gama idi el fedif, ere nigin, saa tano are idi neid. ");
INSERT INTO dad_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aib idi waud gudũ fedif, gama idi el fedif, ere nigin, idi waud yo fediyouf. ");
INSERT INTO dad_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aib idi molol dibodok, gama idi el fedif, ere nigin, idi teneub akor adouf. ");
INSERT INTO dad_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aib idi Negur nẽ madur bagai nigin naũ fedif, naan ail fedif, gama idi el fedif, ere nigin, idi weit fediyouf. ");
INSERT INTO dad_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aib idi waud ifenẽdif, gama idi el fedif, ere nigin, idi wau ifenẽya dalouf. ");
INSERT INTO dad_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aib idi waud bun karẽtut, gama idi el fedif, ere nigin, idi Negur dilouf. ");
INSERT INTO dad_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aib idi maur gudũ difedig, gama idi el fedif, ere nigin, idi Negur gere tar difediyouf. ");
INSERT INTO dad_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aib idi Negur nẽ madur bagai nigin darau dalef, gama idi el fedif, ere nigin, saa tano are idi neid. ");
INSERT INTO dad_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Aib ã aya nigin tamo kayau idi kono diyeik, darau difeneik, idegẽya bun od sane ganan ã bun dirarak, gama ã nigin el yeik. ");
INSERT INTO dad_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wauĩ kulĩg fen, sereg, ere nigin, ãgenei mala solo saa tano bun odug, profet idi ket dibodoneg kulu darau age fiya bagai dalen. ");
INSERT INTO dad_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ã teneub enĩ nẽ sol, anĩ ere, sol in kai sa kalauf are, ere naig fe di, baban kai adouf? Ĩ baban ereb kabĩ taka ifenẽya kisi feleya sã, diraile di, tamo anĩ teten dilef, disi difouf dogol. ");
INSERT INTO dad_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ã teneub enĩ nẽ lalan. Taun taka uya bun ibodok anĩ inokeleya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Age fiya gen, tamo kayau lam tõ de fen, beĩ kur to dinouf. Age fiya ban, idi yoki bun diseginnẽ di, anĩ lalan tamo ganan fõ anĩ bun ifenẽdif. ");
INSERT INTO dad_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Age fiya bagai, ãgenei fula fiya tamo kayau lalan ifenẽdiyouf, ago ge di, tamo kayau idi ãgenei tobonuneĩ biya anĩ dile fen, ãgenei Temeĩ saa ilun ibodok anĩ seli dabiyouf. ");
INSERT INTO dad_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Aya asin anĩ, Moses nẽ Lo, profet neid od ado alelauf nigin asin to gouf, aya anĩ yaleleya nigin to asin, anĩ kisi afalauf nigin asin. ");
INSERT INTO dad_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aya momoi bagai arokeneik, sain saa teneub ado iminkeleya sã mog, sifa naal bagai, pen togo fiya anĩ Lo bun taka to fitol yale iminkalauf, idi anĩ ganan dibod mog, ereb ereb ganan kisi falauf. ");
INSERT INTO dad_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aibem taka, ĩtãfiya enĩ nẽ tekelei naal bagai anĩ to dõf fen, tamo tunĩ ĩ dõ difiyẽ age difouf nigin ifelnẽdiyouf are, ĩ saa tanon yana naal bagai youf, anĩ ere, aib taka ĩtãfiya eneidi dõf agef kisi fel ifelnẽdiyouf, saa tanon yana odug yalouf. ");
INSERT INTO dad_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Anĩ aya arokeneik, ãgenei madur bagai anim, Farisia tamo ado lo ifelnẽdiya tamo neid madur bagai to wal gouf are, ã saa tanon ileya nigin kisi feleya sã bagai. ");
INSERT INTO dad_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tamo ĩtãfiya kulu eig den anĩ karĩ gen, ‘Õ tamo to ukeis, taka ne tã yukesif are, es fiya bun ifarauf.’ ");
INSERT INTO dad_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Anĩ ere, aya ã arokeneik, aibem taka tura seye ifenek are, ĩ es fiya bun ifarauf. Baban, aib taka tura irokenek, ‘Daku,’ ĩ kot bun ifarauf. Takag, aibem irok, ‘Õ neneya!’ age youf, hel nẽ yã uruwa dõya kelẽ fiyek. ");
INSERT INTO dad_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Anĩ nigin, õ Negur bun sesewi wou fenẽ kisi wale, alta garan safina urou ule fen, õ turã õ bun nauseir ado anĩ õ weder fokõ fouf are, ");
INSERT INTO dad_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","safina an alta garan utor yen, kel ule turã ado komo weleg fen, gama usi, Negur safina wenẽ, sesewi wouf. ");
INSERT INTO dad_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Aib õ kot bun irouleyõya nigin, ã uruwom naab luwe uleg fen, on kiwai tamo ado kaisã komo gouf. Sãf, ĩ õ es fiya tamo bun inenõf. Age fe di, es fiya tamo õ irouyõ polis imeid bun ino di, idim õ kalabus bun dirãyõf. ");
INSERT INTO dad_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aya momoi arokonok, õ kalabus bun kutũ yesiya sã mog, wareg ganan unolauf. ");
INSERT INTO dad_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Tamo ĩtãfiya eig den anĩ karĩ gen, ‘Õ seseirã to uno.’ ");
INSERT INTO dad_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Anĩ ere, aya ã arokeneik, taka ĩ malam kayau lof fen, mala yũ yalef, ĩ mogo wau bun kayau anĩ bun seseirã inol. ");
INSERT INTO dad_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Õ malã biyalem mosor bun inenõf are, ubodol uraile. Õ boũ adok hel bun irãya anĩ fotokar, õ boũ tunĩ taka iminkalauf, are deuf. ");
INSERT INTO dad_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Õ imã biyalem mosor bun inenõf are, gudũ uraile. Õ boũ adok hel bun irãya anĩ fotokar, õ boũ tunĩ taka iminkalauf, are deuf. ");
INSERT INTO dad_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ĩtãfiya eig fe yenen, ‘Aibem taka yogon aiwa iruwau fenẽ, kayau ado bagu fiya anĩ fara fiya nẽ pepa ifen ken, bagu fiya fara fouf.’ ");
INSERT INTO dad_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Anĩ ere, aya ã arokeneik, aibem taka, yogon kayau ĩ tamo taka ado to seseirã dino mog, iruf are, ĩ kayau anĩ seseirã naab bun inenek. Anĩ aibem taka kayau anĩ yalef, tamo anĩ mogo seseirã inof. ");
INSERT INTO dad_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Takag, tamo ĩtãfiya kulu eig den anĩ karĩ gen, ‘Ã wau kuturoleya od anĩ to waleleg. Ã wau kuturoleya od, Odug mala bun unogen anĩ kulatun gouf.’ ");
INSERT INTO dad_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Anĩ ere, aya arokeneik, od megeir ifenẽya bun, saa mala bun to bagai wouf, ere nigin, saa are Negur nẽ ibodõya modoũ. ");
INSERT INTO dad_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Oo teneub mala buneg to wouf, ere nigin, teneub are Negur ye inoya nẽ sawa. Oo Jerusalemeg mala bun to wouf, ere nigin, are King Odug in taun yana. ");
INSERT INTO dad_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Õ muduremeg anĩ nigin megeir to unouf, ere nigin, õ ogon fatiya age fe di, lalau be karos be taka wõya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ã nigin yo yeya are yo gouf, sã de sã gouf dogol, od enĩ wal fe fen, tobol fiya are Satan bunem isif. ");
INSERT INTO dad_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tamo ĩtãfiya eig den anĩ karĩ gen, ‘Mala fagã difouf, mala solo abag mala fagã wo. Waila are waila tura.’ ");
INSERT INTO dad_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Anĩ ere, aya arokeneik, tamo sane mala solo to wenẽ. Tamo taka ogon walã biyalẽ fakã fouf are, falei wel len, walã sitakãg fakã fouf. ");
INSERT INTO dad_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tamo taka ogon kolos yalouf nigin kot yõ fenẽ, malakaĩ ogon saket anĩg utorken. ");
INSERT INTO dad_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tamo taka mail tekelei ileya nigin nugo yõf, malakaĩ uruwom mail uru ulagauf. ");
INSERT INTO dad_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aibem ereb taka nigin to yok, are wenẽf. Aibem ereb taka wareg õ bun yalou fenẽf, õ to dudum wiyẽ. ");
INSERT INTO dad_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tamo ĩtãfiya eig den anĩ karĩ gen, ‘Õ nẽ tã nigin waũ laaf fen, on kiwai anĩ kiwai wenẽ.’ ");
INSERT INTO dad_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Anĩ ere, aya arokeneik, ãgenei kiwai nigin wauĩ laaf fen, tunĩ darau difeneik idi nigineg kosẽ gouf. ");
INSERT INTO dad_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ago gouf are, ã Temeĩ saa ilun ibodok gere tar wowã gouf. Ĩ yogon gaa sur fef, tamo sane, tamo biya adok daledig, taka uyẽg sur fef, tamo madur, tamo madur sã adok ifenẽdidig. ");
INSERT INTO dad_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Idi ã nigin orodidig anidi nigin dogol wauĩ laa fouf are, ere mala solo anĩ ã walogouf? Are takis yaleya tamog to age difedig de? ");
INSERT INTO dad_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ã tureĩ tar dogol aan wiyẽdigouf are, ere anĩ tunĩ wal fediya ago gef? Haiden are idig, anĩ to age difedig de? ");
INSERT INTO dad_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Anĩ nigin, Temeĩ saa ilun ibodok ĩ madur bagai gen, ãg de madur bagai agog. ");
INSERT INTO dad_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ã lo welegei, ãgenei tobonuneĩ madur anĩ seluma kulõ difouf ge mã, anĩ tamo kayau meleid bun yaau to du wog. Ã ago gouf, Temeĩ saa ilun ibodok mala solo to ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Sain õ maleg tamo usennẽdiyou fenẽ, õ anĩ taur to fũ fen, ait bagauf, mala yaleya tamo Juda neid uub fõ bun ado naabur, tamo idi seluma kulõ difouf de fen, age difedig gen. Aya momoi arokeneik, idi anĩ nẽ mala solo adok mogo dalen. ");
INSERT INTO dad_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Anĩ õ maleg tamo usennẽdif, on imã kilẽ to keleĩ mog, imã biya melẽ age fouf, ");
INSERT INTO dad_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","anĩ õ iminẽyan dor walef. Ago di, on Tamã, õ iminẽyan agol, ile fen, mala solo ifonõf. ");
INSERT INTO dad_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Sain ã kosẽ gouf bun, ã mala yaleya tamo age difedig gen to agog. Idi tamo dilemãf de fen, Juda neid uub fõ namen ado naab kaleyan difar fen, kosẽya orodidig. Aya momoi arokeneik, idi anĩ nẽ mala solo adok mogo dalen. ");
INSERT INTO dad_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sain õ kosẽ wou fenẽ, õ ogon aabẽ ule, sukar unol fen, Tamã Negur, ĩ iminẽyan ibodok, kosẽ wiyẽ. Anĩ on Tamã õ iminẽyan agol, ile fen, mala solo ifonõf. ");
INSERT INTO dad_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Sain ã kosẽ gouf, haiden age difedig gen, od musei to dĩg, ere nigin, idi neid kisi, nemã od musei nigin karĩ famãf de fen, idi od musei biya wogõ dedig. ");
INSERT INTO dad_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ã, idi age difedig gen, to agog, Negur ãgenei Temeĩ ĩ ereb ã lau gef anĩ mogo keleĩ mog, dum ĩ to wiyẽgedig. ");
INSERT INTO dad_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Kosẽ gou fenẽ, ã eig wog urõgouf: “‘Õ nemã Dei õ saa ilun ubodok, õ yanã fateul ibodõf, ");
INSERT INTO dad_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ogon tano isiyouf, ogon oroyok saa ilun age fef gen, tenebur eineg age fouf. ");
INSERT INTO dad_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Saaf naa enĩ nẽ wanamãf. ");
INSERT INTO dad_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Õ amã nemã mosor nigin wederẽ tu kalauf, are idi amã bun mosor dinof, amãg idi neid mosor nigin wederamã tu kelef gen. ");
INSERT INTO dad_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kisi famãya bun to uroulemãf, sesen anĩ bun tamal amã walelnamãf.’ ");
INSERT INTO dad_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tamo idi ã bun mosor dinoyeĩf, ã idi neid mosor nigin wedereĩ tu kalauf are, ãgenei Temeĩ saa ilun ibodok, ĩg ãgenei mosor nigin weder tu kalauf. ");
INSERT INTO dad_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Anĩ ere, ã tamo idi neid mosor nigin wedereĩ to tu kalauf are, ãgenei Temeĩ, ĩg ãgenei mosor nigin weder to tu kalauf. ");
INSERT INTO dad_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Sain ã kuri gouf, mala yaleya tamo sẽya nẽ neweid age difedig gen to ago gei, ago gouf, tamo anĩ dile fen kuri def douf. Aya momoi arokeneik, anĩ nẽ mala solo adok mogo dalen. ");
INSERT INTO dad_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Anĩ ere, sain õ kuri wouf, fatiyã moul u ken, nawã usurũf. ");
INSERT INTO dad_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Anĩ bunem, õ kuri bek oo sã be, tamo idi õ nigin to keleĩ youf. Ogon Tamã, Negur iminẽyan ibodok, ĩ yogo dogol keleĩ youf, anĩ ogon Tamã õ iminẽyan ereb ago wouf ile fen, mala solo ifonõf. ");
INSERT INTO dad_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Aug nigin safina biya biya tenebur ein to kuru wog. An dedek yãf, maat te yũf, bẽ tamog narĩ de, bẽ dalouf. ");
INSERT INTO dad_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ã aug nigin safina biya biya saa ilun kuru wog. An dedek to yãf, maat te to yũf, bẽ tamog to narĩ de, bẽ dalouf. ");
INSERT INTO dad_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ogon safina biya biya ibodok nẽ an, ogon waũg an yenẽf. ");
INSERT INTO dad_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mala are bouwa nẽ yal. Õ malã biyauf are, ogon bouwã ganan lalan lauf. ");
INSERT INTO dad_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Anĩ ere, õ malã sane lauf are, ogon bouwã ganan gugum kalauf. Lalan õ ado anĩ gugum kalauf, gugum are odug bagai! ");
INSERT INTO dad_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Aib taka ĩ yogon marau uru bun kabĩ to yalouf. Anĩ taka kiwai ifen ken, taka anĩ nigin wau laa fouf. Ĩ taka anĩ dõf fen, taka anĩ mala irim fouf. Anĩ nigin, ã uru to aruneid walogouf, Negur ado moni. ");
INSERT INTO dad_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Age fiya nigin, aya ã arokeneik, ã ãgenei bouweĩ mata ibodõf nigin to osig fen, ere saaf tãf, ere naan tãf gouf. Ã ãgenei bouweĩ nigin to osig fen, ere gabar tafilaĩf gouf. Mata anĩ saaf wal fiya, bouwa anĩ gabar wal fiya sã de? ");
INSERT INTO dad_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Saa ilun ã ninã uledigouf, idi saaf to ditenẽdig, idi saaf u de fen, kin to dinodig, anĩ ere, ãgenei Temeĩ saa ilun yogo ifoutnẽdidig. Ã idi anĩ wal fediya sã de? ");
INSERT INTO dad_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ã takam yogon mata nigin osi ye fen, aua tekelei tobol fiya kisi feleya de? ");
INSERT INTO dad_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ere nigin ã gabar nigin osi gef? Dubur aa munĩ, naig fe odugedig anĩ ulogouf. Idi kabĩ to daledig, to diwadig. ");
INSERT INTO dad_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Anĩ ere, aya ã arokeneik, kulu King Solomoneg, yogon saki gegẽ biya biya ifonun anim, aa munĩ eig fediya taka to wal fen. ");
INSERT INTO dad_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Anĩ ere, Negur, dubur aa munĩ gama dogol ifarauf, nile di, yã irãf anĩ, agef naki fediyouf are, ã bun idi wal fediya bagai Negur ifounneĩf, age fiya sã de, ã momoiya naal bagai ado? ");
INSERT INTO dad_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Anĩ nigin, to osi wog urõgouf, ‘Ere saaf ada tãf?’ oo ‘Ere naan ada tãf?’ oo ‘Ere gabar ada tafilaĩf?’ ");
INSERT INTO dad_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Haiden idi enĩ ganan nigin meleid dimirẽdig. Ãgenei Temeĩ saa ilun lau gef anĩ ganan keleĩ. ");
INSERT INTO dad_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Anĩ ere, Negur nẽ tano ado yogon madur bagai ketem umirẽg, ago ge di, safina eneidig ganan ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Age fiya nigin, naa nil nẽ anĩ nigin to osi wog, nil nẽ are yogo nigin osi youf. Naa mugu mugu nẽ morõ are idi dogo dalouf. ");
INSERT INTO dad_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Taka to es wiyẽg, ago gouf, ãg es yeĩf. ");
INSERT INTO dad_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anĩ nigin, tunĩ es wedigef gen, ãg agef es yeĩf. Ãgenei es fiya nẽ naab de tekelei bun ãg agef es yeĩf. ");
INSERT INTO dad_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Õ ere nigin turã mala teteur lo fen, õ ogon aa masak malã bun ibodok anĩ to ulef? ");
INSERT INTO dad_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aa masak ogon malã bun ibod mog, naig fe di, turã nigin dogol urokenek, ‘Utor len, aya ogon malã teteur alelkonõf’? ");
INSERT INTO dad_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Õ mala yaleya tamo, õ ogon malã bun ketem aa masak walel kelẽ wol fen, dum turã bun mala teteur walelauf. ");
INSERT INTO dad_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ereb fateul anĩ gaũ to urakenẽdig. Ãgenei maaĩ tuwa meli bagai pel anĩ bor to urakenẽdig. Ã ago gouf, yedim lalai difouf. Age de fen, falei del, ã serek de fisik diyeĩf. ");
INSERT INTO dad_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“To gouf, agef ã ifeneĩf; umirẽgouf, ã gurug gouf; godugodu gouf, ã sukar kã feneĩf. ");
INSERT INTO dad_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aibem taka to fef, yalouf; aibem taka imirek, gurug fouf; aibem taka godugodu fef, sukar kã fel kenẽf. ");
INSERT INTO dad_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ã anĩ takam, ĩ naal bret nigin to fef, ĩ meein ifenẽf de? ");
INSERT INTO dad_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Takag, ĩ gau nigin to fef, ĩ gogour ifenẽf de? ");
INSERT INTO dad_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Seseneĩ bagai ã, ãgenei kesu safina biya biya anĩ ifenẽdiya ã keleĩ bagai, age fiyauf are, Temeĩ saa ilun ibodok, safina biya biya aib idi to difiyek, ãgenei wenẽdigedig anĩ wal fiya, idi ifenẽdiyouf! ");
INSERT INTO dad_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Anĩ nigin, ereb ereb ganan bun, ereb taka idim age diyeĩf anĩ oroyeik anĩ, ãg idi nigin ago gouf. Od enĩ Lo od ado Profet od neid kaũ. ");
INSERT INTO dad_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Bobog kidõ bun usorug ulagauf. Ere nigin, daũ fiya bun ileya nigin bobog bilalã fiya, naab odug. Tamo kayau musei naab odug anĩ diledig. ");
INSERT INTO dad_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Anĩ ere, mata tano bun ileya nigin bobog kidõ, naab naal. Anĩ nigin, tamo kayau teke tekeleim dogol, anĩ fata difedig. ");
INSERT INTO dad_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Idegẽya profet anidi lo weledigei. Idi ege sipsip siwi difoun ken, ã garan disif, anĩ ere, idi namedin gaũ kuĩ sane ado. ");
INSERT INTO dad_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Idi neid faat yũf bun, ã idi dogo anibo be biya be ulogouf. Tamo kayau idi wei biya barik bun, gira udum bun daledig de? ");
INSERT INTO dad_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Age fiya gen, aayũ biya are faat biya yũdig, aayũ anibo are faat anibo yũdig. ");
INSERT INTO dad_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Aayũ biya ĩ, faat sane yũya kisi feleya sã, aayũ anibo are faat biya imaya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aayũ ganan faat biya to imaf are, ditu dale yã malan dirãf. ");
INSERT INTO dad_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Age fiya nigin, idi neid faat yũdig bunem, ã idi nigin yaor keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Idi aya ‘Odug, Odug’ de fen dirokanadig, idi ganan saa tanon to dilauf. Aibem ĩ, neu Dei saa ilun ibodok in oroya dõf age fef anim dogol ilauf. ");
INSERT INTO dad_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Naa anĩ bun, musei aya dirokanauf, ‘Odug, Odug, amã õ yanã nem profet od wogõ maun, amã õ yanã nem kaa sesen maruid fen, õ yanã nem memelik musei manodin!’ ");
INSERT INTO dad_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Age de di, aya yaor arokenẽdiyouf, ‘Aya ã keleĩ sã. Ã sane gide gedig, uyaleleg!’ ");
INSERT INTO dad_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Age fiya nigin, taka ĩ neu od eneidi karĩ ye fen, dõf age fef, ĩ keleĩ tamo yogon fõ meein teten inon gen. ");
INSERT INTO dad_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sain uyẽ burabura isin, kuwei odug ile, solalã fel fen, yau odug fã ye fen, fõ yoũ fe di, to kubũ yen, ere nigin, tor gariya meein teten inon. ");
INSERT INTO dad_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Anĩ ere, aib taka ĩ neu od eneidi karĩ ye fen, to dõf age fef, ĩ neneya tamo yogon fõ subusir teten inon gen. ");
INSERT INTO dad_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sain uyẽ burabura isin, kuwei odug ile, solalã fel fen, yau odug fã ye fen, fõ yoũ fe di, kubũ ye narĩf irailen.” ");
INSERT INTO dad_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Od ganan Jesus wogõ ye idikele di, tamo kayau in od ifelnẽdin anĩ nigin terẽ den, ");
INSERT INTO dad_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ere nigin, Jesus ifelnẽdin are, taka ĩ yana adom gen age fiya od wogõ fedin, idi neid lo ifelnẽdiya tamo age difedig gen sã. ");
INSERT INTO dad_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus arein tamal kutũ yesi di, tamo kayau musei dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tamo lepra dagi ado isi, Jesus wagen ibor bobou fe fen, irokenen, “Odug, õ waũ irom are, aya el fiyaya nigin kisi feleyam.” ");
INSERT INTO dad_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus ima iran, tamo anĩ kobũf fen, iron, “Aya wau irok, bouwã biyaf.” Age ye di, kaisã bagai yogon lepra dagi sa kelen. ");
INSERT INTO dad_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus irokenen, “Õ aib taka to urokenẽf. Õ ogo pris wagen ule, bouwã ufelne ken, Moses nẽ od dõ fen, safina sesewi wo, anĩ bunem õ biya lel anĩ, tamo kayau dilouf.” ");
INSERT INTO dad_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus Kapenaum taun wõ ye di, Rom kusĩ tamo neid orowa Jesus wagen isi fen, isennẽf nigin to fiyen. ");
INSERT INTO dad_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ĩ iron, “Odug, neu kabĩ tamo fõ bun darau odug ado ilolaisin yenek.” ");
INSERT INTO dad_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus irokenen, “Aya ele, el afiyẽf.” ");
INSERT INTO dad_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Age ye di, kusĩ orowa aiten yale iron, “Odug, aya to biya nigin aya kisi afef, õ neu fõ bun to usiyouf. Malakaĩ, õ od dogol urõ di, anĩ neu kabĩ tamo dagi sa kalauf. ");
INSERT INTO dad_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aya yug nigin age fiya, ayag neu odug anĩ farumen abodok, kusĩ tamo idig aya farumeun dibodok. Aya taka enĩ arokenek, ‘Ule’ afiyek, ĩ ilauf. Aya taka arokenek, ‘Õ usi’ au di, ĩ isidig. Neu kabĩ tamo enĩ ago afiyek, ĩ agef age fedig.” ");
INSERT INTO dad_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Od anĩ kusĩ orowa age irõ di, Jesus od anĩ karĩ ye, terẽ ye fen, tamo kayau dõ difiyen anidi irokenẽdin, “Aya ã momoi arokeneik, aya Israel bun ãgenei momoiya odug eig fiya taka to ailen. ");
INSERT INTO dad_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aya arokeneik, musei fau gaa iseyan gaa ileyan temeledim disiyouf, idim modoũ dalel fen, saa tano nẽ tar odug bun, Abraham, Isak, Jakop geid saa tanon dibodõf. ");
INSERT INTO dad_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Anĩ ere, Israel tamo kayau musei Negurem idi nigin saa tano dodok fe kenẽdin anidi, fau dumeitur gugum bẽ mayarẽ irarãf, an inã odug ado firi de fen, goboreid kikokõ youf.” ");
INSERT INTO dad_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus age wogõ yel fen, kusĩ orowa irokenen, “Kel ule! Õ ogon momoiya kilei bagai, õ nigin dõf agef ifonõf.” Sain anĩ wogõ ye mog bagai, yogon kabĩ tamo dagi sa kelen. ");
INSERT INTO dad_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus Pita nẽ fõ bun ilen, Pita nẽ mam bouwa uruwa odug ado fatarẽ yen mog, ilen. ");
INSERT INTO dad_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus kayau ima anĩ kobũ fe di, bouwa uruwa fara fiye kele di, kaisã bagai kayau fã yale, Jesus aruna yalen. ");
INSERT INTO dad_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gugum mog, tamo kayau kaa sesen adodo musei guri difeid, Jesus wagen disin. Age dife di, Jesus od nem kaa sesen iruid fen, dagi adodo ganan el fedin. ");
INSERT INTO dad_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesus enĩ ganan age fen, are Negur ĩ, profet Asaia bunem od eig ye wogõ yen anĩ kisi falauf nigin: “Ĩ yogo neda ilõyabiya yales, neda dagi faali fen.” ");
INSERT INTO dad_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sain anĩ Jesus mala iran, tamo kayau musei kalilĩ difiyẽ di, daliyou sitakã dibal dilauf nigin in dõ fiya tar irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Age fiyeĩd mog, lo ifelnẽdiya tamo taka wagen isi fen, irokenen, “Tise, õ narib ulauf are, aya õ dõ ayõf.” ");
INSERT INTO dad_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus aiten yale iron, “Gaũ kuĩ idi yenẽya nẽ modoũ ku ado, ninã lalo bun diyok idi uru ado, anĩ ere, Tamo Naal ĩ mudur inoya nẽ modoũ sã.” ");
INSERT INTO dad_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","In dõ fiya taka irokenen, “Odug, fau de, folõ wiya len, aya ele fen, neu dei mũ afel fen.” ");
INSERT INTO dad_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Anĩ ere, Jesus ĩ irokenen, “Õ aya dõ wiya, laa tamo idi, laa tutur abob mumã difouf.” ");
INSERT INTO dad_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesus waag owor isile di, in dõ fiya tar ĩ geid dilen. ");
INSERT INTO dad_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Idi keleĩ sã mog, maaĩ daliyoun yau totol fã yen. Agef mog, maaĩ odug fã ye, waag yũ di, waag anĩ naanũ imutkesilau fenẽ age fen. Anĩ ere, Jesus mulã yenen. ");
INSERT INTO dad_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","In dõ fiya tar dilen, turĩ difiyẽ, diron, “Odug, usennamã! Amã mogo naanũ mamutatã gare mausiyou fenẽ!” ");
INSERT INTO dad_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus aitedin yalen, “Ãgenei momoiya naal bagai, ere nigin ã fatuk kumĩ gef?” Age ye fen, ĩ fã ye, maaĩ yau ado ou fiyẽdi di, oditekei kee delen. ");
INSERT INTO dad_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tamo idi terẽ de fen, to difen, “Tamo eĩ naig fiya bagai? Maaĩ yau ado karĩ difiye ken, dõ difef!” ");
INSERT INTO dad_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesus Gadara neid teneub bun daliyou sitakã ilen, kaa sesen adodo tamo uru matmat bunem dile fen, Jesus tarabã difen. Tamo uru kuĩ bagai diledin nigin, tamo ganan naab anĩ to diyõdig. ");
INSERT INTO dad_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Anĩ idi diweig fen, diron, “Negur Naal, õ amã nigin ere naig wamãf? Õ naa wenen anĩ fau mog, gama bagai daig wamã fenẽ ein usif de?” ");
INSERT INTO dad_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Idi difaren sitakã gerõ nuwa an, bor musei saaf doko diyon. ");
INSERT INTO dad_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kaa sesen idi Jesus digonen, “Õ tamo eneidi bun tamal urumã fenẽf are, amã bor musei namedin sur wamãf.” ");
INSERT INTO dad_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus kaa sesen irokenẽdin, “Uleleg!” Idi ulolõ deis fen, diselen bor namedin dilelen. Bor ganan gududu de bebeigir disil, daliyoun naanũ gare desin. ");
INSERT INTO dad_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bor lo fiya tamo diya, taun disil fen, Jesus kaa sesen irudi di, bor gare den anĩ ganan wogõ den. Age de fen, idi ereb tamo uru kaa sesen adodo bun wõ yen anĩ nigineg wogõ den. ");
INSERT INTO dad_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Age de di, tamo kayau taun temeleid adok, Jesus ileya nigin dilen. Idi Jesus dile fen, idi neid fonõ anĩ itor ilauf nigin digonen. ");
INSERT INTO dad_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus waag taka sõ ye, daliyou ibal fen, yogon taun ilen. ");
INSERT INTO dad_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tamo tunĩ tamo bouwa ilolaisin gabgab bun yen mog, Jesus wagen diroulen. Idi neid momoiya Jesus ile fen, Jesus tamo bouwa ilolaisin irokenen, “Kesu, waũ unois, ogon mosor alelkonok.” ");
INSERT INTO dad_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Anĩ karĩ de fen, lo ifelnẽdiya tamo tunĩ, idi neid kisi bun diron, “Tamo eĩ Negur kono fiyek!” ");
INSERT INTO dad_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Idi neid kisi kelei ken, Jesus iron, “Ã ere nigin wauĩ bun kisi sane agef wõ yef? ");
INSERT INTO dad_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nanĩ anĩ irõya nigin karika: ‘Ogon mosor alelkonok,’ de? Oo ‘Fã, ufar uyok ule’? ");
INSERT INTO dad_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Anĩ ere, Tamo Naal ĩ tenebur ein mosor yaleleya nigin yana ado anĩ ã keleĩ youf nigin…” Age ye fen, tamo bouwa ilolaisin irokenen, “Fã ufar, ogon gabgab wale urou, fonõ ule.” ");
INSERT INTO dad_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Age ye di, tamo fã yale, fonõ ilen. ");
INSERT INTO dad_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tamo kayau guru difen ganan anĩ meledim dile fen, terẽ de kumĩ den. Negur yogo tamo yana enĩ ifenẽdin anĩ nigin, idi Negur yana dalesen. ");
INSERT INTO dad_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus an tamal iyok ile fen, mala irakelen, tamo yana Matyu takis yaleya fõ bun ibod mog, ilen. Jesus ĩ irokenen, “Aya dõ wiya.” Age ye di, Matyu fã yale, Jesus dõ fen. ");
INSERT INTO dad_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesus Matyu nẽ fõ bun bõ saaf yõ mog, takis yaleya tamo, mosor ado tamo kayau musei disi fen, Jesus in dõ fiya tar geid weim saaf don. ");
INSERT INTO dad_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisia tamo idi anĩ dile fen, idi Jesus nẽ dõ fiya tar to difedin, “Ere nigin ãgenei tise, takis yaleya tamo, mosor ado tamo kayau geid saaf doko?” ");
INSERT INTO dad_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Od anĩ Jesus karĩ ye fen, iron, “Idi bouweid biya bagai, dokta gein ileya nigin to waud yenẽdig, tamo dagi ado idim dogol, dokta gein ileya nigin waud yenẽdig. ");
INSERT INTO dad_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Uleg fen, od enĩ dir ge fen, kaũ ere yeĩf anĩ keleĩ youf, ‘Aya wau ifenẽya anĩ orouf, sesewi fiya sã.’ Anĩ nigin, aya tamo madur anidi iweignẽdiya nigin to asin, aya mosor adodo anidi iweignẽdiya nigin asin.” ");
INSERT INTO dad_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Age ye mog, Jon naan igunẽdiya tamo nẽ dõ fiya tar disin, Jesus to difiyen, “Naig fe di, amã Farisia tamo geid kuri mau di, ogon dõ fiya tar idi kuriya sak?” ");
INSERT INTO dad_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus aitedin yalen, “Tamo, kayau yalou fenẽ tar bun, ne tã tar disennek idi fau weim dibod ken, naig ĩ nigin waud gudũ fouf? Dum sain wõ ye di, an ne tã tar bun tamal yalelnẽf bun anĩ, idi gama kuri douf. ");
INSERT INTO dad_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tamo taka, gabar masak mata, gabar tubu ado baguf fen, to iwauf. Anĩ age fouf, gabar masak matam gabar tubu dĩ fe di, tubu kudef, awa kanouf. ");
INSERT INTO dad_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Takag, tamo idi wain mata anĩ meme gabar tubu anĩ bun to ditinẽf. Age difouf, meme gabar kude fele di, wain oho yalauf. Meme gabar sane lauf. Age fiya sã, idi wain mata are meme gabar mata bun ditinẽf. Age fe di, uru idi kabĩ ifenẽdiya nigin biya difarauf.” ");
INSERT INTO dad_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Od enĩ Jesus fau wogõ ye mog, Juda neid uub fõ nẽ uyu irouya taka isin, Jesus wagen ibor bobou fe fen, iron, “Gama bagai neu barai laa fel. Õ uma fen, imã teten uno di, kayau naal baban kel mata ibodõf.” ");
INSERT INTO dad_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus fã yale, uruwom dile di, yogon dõ fiya tar idig dilen. ");
INSERT INTO dad_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Dile mog, kayau taka ogõ dagi faimud ado yar tuwelf iyon anĩ, Jesus dume dume isi fen, Jesus nẽ kolos iri kobũ fen. ");
INSERT INTO dad_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kayau anĩ yogon kisi iron, “Aya de yogon kolos dogol kobũ afouf, anĩ aya neu dagi sa kalauf.” ");
INSERT INTO dad_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus falei yelen, kayau anĩ ile fen, iron, “Nau barai, waũ unois, ogon momoiya anim dagi sa kel konok.” Age ye mog bagai, kayau in dagi sa kelen. ");
INSERT INTO dad_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesus uyu irouya nẽ fõ bun isour ilen, mala iran, tamo kayau musei kokũ de, i de mog, iledin. ");
INSERT INTO dad_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesus iron, “Uyaleleg, kayau naal enĩ laa fiya sã, mulã yenek.” Age ye di, idi kasã difiyen. ");
INSERT INTO dad_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tamo kayau mayarẽ irud laisi fen, Jesus aab namen ilen, kayau naal ima yale iroun. Age fe di, kayau naal fã yen. ");
INSERT INTO dad_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nenerĩ anĩ wogõ de di, teneub anĩ ganan bun iyokelen. ");
INSERT INTO dad_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus modoũ anĩ itor ken, iyok ile mog, tamo uru meleid ifofakeleya Jesus dõ difiyen, diweig diron, “Dawid Naal, amã nigin waũ inõ!” ");
INSERT INTO dad_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus fõ aaben ile di, tamo uru meleid ifofakeleya wagen dilen, Jesus idi to fedin, “Ã momoi gef, aya ã meleĩ el afe di, lo gouf nigin kisi feleya?” Idi aiten dalen, “Ao, Odug.” ");
INSERT INTO dad_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Age de di, Jesus imam meleid kobũ feid fen, iron, “Momoi gef kilei, ã nigin age feneĩf.” ");
INSERT INTO dad_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Idi neid meleid gama kelẽ delen. Jesus totol bagai katũ feid fen, iron, “Enĩ nigin taka to urokenẽgouf.” ");
INSERT INTO dad_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Anĩ ere, idi kututũ deis dile fen, Jesus age fen anĩ, teneub anĩ nẽ akor ganan bun od dinof diyon. ");
INSERT INTO dad_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Idi Jesus ditornẽ dile mog, tamo taka kaa sanem ait ifokelen anĩ Jesus wagen dirousin. ");
INSERT INTO dad_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kaa sane iru di, iyan, tamo ait ifokeleya wogõ yen. Tamo kayau guru difen ganan terẽ de fen, diron, “Kulu nem isi gama, Israel bun eig fiya taka to tailen.” ");
INSERT INTO dad_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Anĩ ere, Farisia tamo idi diron, “Are kaa sane neid mudur yana bunem, ĩ kaa sesen irudif.” ");
INSERT INTO dad_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus taun ganan fonõ fonõ ganan bun iyo ken, nedi uub fõ bun ifelneĩd, saa tano nẽ biya od wogõ feid fen, dagi gariya fire fire ganan el fedin. ");
INSERT INTO dad_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sain Jesus mala iran, tamo kayau musei guru difen anĩ ileid fen, idi nigin wau yun, ere nigin, idi morõ adodo isennẽdiya sã, idi sipsip marau sã age fiya gen. ");
INSERT INTO dad_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Anĩ yogon dõ fiya tar irokenẽdin, “Kabier saaf musei biya ima bure felen, anĩ ere, kabĩ tamo musei sã. ");
INSERT INTO dad_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Age fiya nigin, kusu fiya marau, Odug to wiyẽg, kabĩ tamo susur fedi di, yogon kabier kususu fiya nigin dilauf.” ");
INSERT INTO dad_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus in dõ fiya tar tuwelf iweignẽdi di, wagen guru difen, kaa sesen irudiya, dagi gariya fire fire ganan el difediyouf nigin megeir ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Eĩ aposel tuwelf yeneid, Simon (in yana Pita dedig), yogon tura Endru, Jems Sebedi naal, ne tura Jon, ");
INSERT INTO dad_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Batolomyu, Tomas, taka Matyu takis yaleya tamo, Jems Alfeus naal, taka Tadeus, ");
INSERT INTO dad_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Selot, taka Judas Iskariot, ĩ anĩ Jesus kiwai ifenen. ");
INSERT INTO dad_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Idi tuwelf enidi, Jesus fadim enĩ ado dõ difouf nigin sur fedin: “Idi ibor fire Juda ibor sã wagedin to ulagauf, Samaria neid taun taka taka buneg to uleg. ");
INSERT INTO dad_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel atun idi sipsip fõ delen anidi bun dogol ulagauf. ");
INSERT INTO dad_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sain ã ulagauf, od enĩ anĩ wogõ gef uyõg, ‘Saa tano mogo melsak.’ ");
INSERT INTO dad_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Dagi el wedig, gare den turĩ wedig, lepra dagi ado el wedig, kaa sesen urudig. Megeir anĩ ã na yaleya sã ege walegen, anĩ nigin, ege luwa wenẽdigouf. ");
INSERT INTO dad_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ã gol moni, silwa moni, kapa moni be, ãgenei kodolẽ taka to bagai ufeg. ");
INSERT INTO dad_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Delẽ uyõgou fenẽ, delẽ iyõya nẽ faa sã, gabar uru, sendel uru, manig uru agog to guri gouf, tamo kabĩ dalef, idi de mala ereb lau difef anĩ difenẽdiyadidig. ");
INSERT INTO dad_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Narib gouf, taun be, fonõ taka be bun ulegef, ã meleĩ unog, tamo ã nigin sere yeĩf, yogon fõ bun ubodõg, dum utorõg uleg. ");
INSERT INTO dad_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ã fõ anĩ bun ulegef, ãgenei wau inosiya nẽ aanya wenẽdigouf. ");
INSERT INTO dad_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Fõ anĩ bun tamo kayau biya diyeik, ãgenei wau inosiya nẽ aanya an urofosig, idi age fiya sãf, ãgenei wau inosiya nẽ aanya anĩ baban keg waleg. ");
INSERT INTO dad_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aib taka ĩ ã nigin to sere yeĩf, ãgenei od to karĩ youf, ãgenei yeĩ aasu tu weleg fen, fõ be taun anĩ utorõg ulagauf. ");
INSERT INTO dad_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aya momoi arokeneik, Sodom Gomora ado darau dalen anĩ wal fiya, es fouf naa anĩ bun, taun anĩ in darau odug bagai yalouf. ");
INSERT INTO dad_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Aya ã sur ayeik are, sipsip gaũ kuĩ atun sur fiya gen. Anĩ nigin, ã gogour age fedig gen, kisi ed ge waleg fen, ago gouf, ninã kuburir gen, imatkesiya ubodõgouf. ");
INSERT INTO dad_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ã tamo nigin lo walagauf, idi fau kaunsel imeid bun dineneĩ di, idi Juda neid uub fõ bun wagagã diyeĩf. ");
INSERT INTO dad_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Idi aya nigin de fen, ã guri diyeĩ diroule, gawaman mudur, king ado wagedin difarnei ken, ã idi geid fen, haiden Israel sã anidi meleid bun, aya nigin wogõ gouf. ");
INSERT INTO dad_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Anĩ ere, idi ã kot bun ifareya nigin gei diyeĩf, ã wauĩ to morõ ken, ere od tarõf, naig ta tarõf anĩ nigin to kisi fatuk walogouf. Sain anĩ bun, ã ereb od urõgouf nigin fau ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Are ãgem to urõgouf, ãgenei Temeĩ nẽ Awa Uur ĩ yogo ã bunem wogõ youf. ");
INSERT INTO dad_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tura fã youf, tura nigin kiwai fen, idegẽ di, laa bun inenẽf, tamag naal ado age difouf, kesu fã douf, idi neid sina tama nigin kiwai dino fen, idi dogo laa bun dinenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tamo ganan idi, aya nigin fau kiwai difeneĩf, anĩ ere, aib taka megeir ino ifar ile idikeleya bun ouf, Negur isennẽf. ");
INSERT INTO dad_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Teneub taka bun, ã darau odug difeneĩf are, uyu takã uyag uleg. Aya momoi arokeneik, ã fau Israel neid taun ganan bun to uyõg udikeleg mog, Tamo Naal kel isiyouf. ");
INSERT INTO dad_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Skul kesu ĩ yogon tise to wal fouf, age fiya gen, ferfer ĩ yogon marau to wal fouf. ");
INSERT INTO dad_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Skul kesu ĩ yogon tise genẽf, are de. Takag, kabĩ tamo ĩ yogon orowa genẽf, are de. Fõ anĩ tama yana dun Belsebub, anĩ nigin, fõ anĩ tamo ganĩ be dibodok idi yeneid sane bagai dalef! ");
INSERT INTO dad_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Age fiya nigin, ã idi to kumĩ wedig. Gama ereb ein dede fiya yenek, are fau lelek falauf, gama ereb iminẽyan yenek, are dum fau keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gama ereb aya gugum bun wogõ ayeik, are fau gaa lalan bun wogõ gouf bagai; gama ereb kosesẽyam karĩ gef, dum fau fõ agaran ufareg fen, uweigig urõgouf bagai. ");
INSERT INTO dad_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Idi bouwa dukesif, anĩ ere, malakanon yukesiya kisin sã anĩ to kumĩg. Anĩ ere, taka ĩ malakanon bouwa ado yũ orok fe, hel bun irãya kisi feleya anĩ dogol kumĩ gouf. ");
INSERT INTO dad_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Fisisir uru ten toea nem na nigin sur gedig. Anĩ ere, ãgenei Temeĩ yogon wau to irõ mog, taka tenebur to kubũ youf. ");
INSERT INTO dad_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ãgenei mudureĩ bun fatiyeĩg ganan iwes yalen. ");
INSERT INTO dad_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Age fiya nigin, to kumĩg, ã Negur mala bun safina odug bagai, fisisir musei wal fediya. ");
INSERT INTO dad_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Aibem taka aya nigin tamo meleid bun kurõ falaisiyouf, ayag ĩ nigin neu Dei saa ilun ibodok wagen kurõ afalaisiyouf. ");
INSERT INTO dad_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Anĩ ere, aibem taka aya nigin tamo meleid bun wa fouf, ayag ĩ nigin neu Dei saa ilun ibodok wagen wa afouf. ");
INSERT INTO dad_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ã to kisi eig wog, aya tenebur ein wau inosiya irou isiya nigin asin gouf. Aya wau inosiya irou isiya nigin to asin, anĩ ere, aya soworu irou isiya nigin asin. ");
INSERT INTO dad_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Anĩ nigin, aya tubi kobõ fiya nigin asin, “‘Tamo ĩ tama nigin kiwai inouf, ne barai yogon sina nigin kiwai inouf, yanawau ĩ sina yana nigin kiwai inouf. ");
INSERT INTO dad_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tamo nẽ kiwai are, de tamo anĩ nẽ ibor bun tamalem fã de fen, kiwai difenẽf.’ ");
INSERT INTO dad_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Aibem taka ĩ, yogon tama sina nigin wau fatuk ifen ken, aya nigin to age fef, ĩ aya dõ fiya nigin to kisi falauf. Aibem taka ĩ, yogon naal be, ne barai be wau fatuk ifen ken, aya nigin to age fef, ĩ aya dõ fiya nigin to kisi falauf. ");
INSERT INTO dad_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aibem taka ĩ, yogon aa tetek orowa to sef fen, aya dõ fiyaf, areg aya dõ fiya nigin to kisi falauf. ");
INSERT INTO dad_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aib taka tenebur ein nẽ mata alouf ye fen imirek, yogon mata fõ yalauf. Aib taka yogon mata aya nigin irailef, yogon mata kel yalouf. ");
INSERT INTO dad_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tamo aibem ã yaleyeik, are aya yaleyaf, tamo aibem aya yaleyaf, are aib ĩ aya sur fiyan ĩ yalef. ");
INSERT INTO dad_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aibem taka ĩ, ĩ profet nigin ye fen, profet taka yalef, ĩ profet mala yalouf, aibem taka ĩ, ĩ madur tamo nigin ye fen, madur tamo taka yalef, ĩ madur tamo nẽ mala yalouf. ");
INSERT INTO dad_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aibem taka, naan medir kap tekelei, tamo yeneid sã anĩ taka ifen yãf, ere nigin, ĩ neu dõ fiya tamo, aya ã momoi arokeneik, ĩ yogon mala solo to bagai wal fiyẽf.” ");
INSERT INTO dad_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus yogon dõ fiya tamo tuwelf tai feid bure fel fen, anenem tokõ fel, Galili taun taka taka bun ifelneĩd fen, biya od wogõ fediyouf nigin ilen. ");
INSERT INTO dad_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Age fe di, Jon naan igunẽdiya tamo kalabus bun ibod ken, Kristus kabĩ agef yalef de di, od anĩ karĩ yen, Jon yogon dõ fiya tar Jesus to difiyẽf nigin ");
INSERT INTO dad_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","sur fedi di, dilen, to difiyen, “Tamo isiyouf den, õ ogo yeir de? Oo amã fau taka nigin tari mafouf?” ");
INSERT INTO dad_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus aitedin yalen, “Kekug uleg fen, ã wedereim karĩ gel, meleim ulegel anĩ Jon wogõ wiyẽg, ");
INSERT INTO dad_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","meleid ifofakelen kelẽ def, to diyon mogo diyok, lepra dagi adon mogo el fedin, wedereid daabun od karĩ def, gare den turĩ fedif, maleg bun biya od wogõ fedif. ");
INSERT INTO dad_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tamo aya nigin wau to firagagaũ fef, Negur ĩ el fiyek.” ");
INSERT INTO dad_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon nẽ dõ fiya tamo ditornẽ dilele di, Jesus, tamo kayau guru difen anidi, Jon nigin irokenẽdiya anĩ gariya inon, “Ã ere bagai anĩ ulogouf nigin, gerere tuan ulegen? Ã unin yaum walala fe di, ulogouf nigin ulegen de? ");
INSERT INTO dad_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Anĩ sãf are, ere bagai ã ulogou fenẽ, ulegen? Tamo taka kolos biya bagai ifonun de? Sã, idi kolos biya bagai difonuk age fiya are, king nẽ fõ bun dibodok. ");
INSERT INTO dad_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ba, ere bagai anĩ ã ulogou fenẽ, ulegen? Profet taka de? Are de yeir, aya ã arokeneik, ĩ profet wal fediya. ");
INSERT INTO dad_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tamo anĩ, ĩ nigin Negur nẽ Itotoya bun eig ye itoton: “‘Aya neu arũ tamo sur afe di, ĩ ket uyu ilauf, im uyulil ogon naab dodok fouf.’ ");
INSERT INTO dad_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Aya ã momoi arokeneik, kayau onoudi kesu dalen idi atun an, taka nem Jon naan igunẽdiya tamo to wal difiyen, anĩ ere, aib taka saa tanon yana naal bagai ado ĩ Jon wal fiya. ");
INSERT INTO dad_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon naan igunẽdiya tamo in sain bunem isi gama, saa tano, megeir ado bilalaũ fedig, megeir ado tamom saa tano anĩ irou irouledig. ");
INSERT INTO dad_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Profet ganan Moses nẽ Lo ado, saa tano nigin profet od wogõ def disin, isi Jon bun daun. ");
INSERT INTO dad_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ã walogou fenẽ wauĩ oroĩf are, ĩ Eliya, ĩ fau isif ya anĩ. ");
INSERT INTO dad_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aib ĩ weder adouf, karĩ youf. ");
INSERT INTO dad_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Tamo kayau sain enei bun, idi nigin ere bunem aya kisi afouf? Idi simom maket modoũ bun dibod ken, abob diweignẽdidig gen: ");
INSERT INTO dad_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Amã ã nigin kelel maun, anĩ ere, ã to kui gen; amã kanon seg malen, anĩ ere, ã to wauĩ gudũ fen.’ ");
INSERT INTO dad_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Anĩ Jon isin, saaf to yon, wain to yon, idi dirõdig, ‘Ĩ kaa sane ado.’ ");
INSERT INTO dad_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tamo Naal isin, saaf yon, wain yon, idi dirõdig, ‘Eĩ saaf wan, wainei yedig, dobu irãya tamal, ĩ, takis yaleya tamo, mosor tamo ado geid nigal difedig.’ Anĩ ere, kisi biya ĩ in tobonunã anĩ bunem, biya yaoref.” ");
INSERT INTO dad_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesus ĩ, taun tunĩ bun memelik musei inodin, anĩ ere, idi waud to falei den, anĩ nigin, Jesus ou fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasin taun, õ malalon ado! Betsaida, õ malalon ado! Ã bun memelik musei anodin, age fiya gen anĩ Taia taun Saidon taun ado bun wõ yem are, mogo kulu waud falei de fen, wau gudũ fiya nẽ gabar difoun ken, aasur dibodom. ");
INSERT INTO dad_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Anĩ ere, aya ã arokeneik, es fiya sain bun, morõ Taia taun Saidon taun ado dalouf anĩ wal fiya, ã walogouf. ");
INSERT INTO dad_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Õ Kapenaum, õ yanã anĩ saa ilun iselauf de? Sã bagai, õ laa neid modoũ bun usilauf. Memelik õ bun wõ yen anĩ age fiya, Sodom taun an wõ yem are, ĩ gamag eig fe di, ibodom. ");
INSERT INTO dad_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Anĩ ere, aya ã arokeneik, es fiya sain bun, morõ Sodom yalouf anĩ wal fiya, õ walouf.” ");
INSERT INTO dad_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sain anĩ bun, Jesus iron, “Dei, saa ado teneub nẽ Odug, aya õ yanã alesef, ere nigin, safina eneidi, kisi biya ado keleĩ adodo to dilouf nigin õ unokon, ago fen, simõ dibodon anidi bun yaor won. ");
INSERT INTO dad_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ariya, Dei, enĩ are ogon waũ filolõ fiya biya bunem agon. ");
INSERT INTO dad_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ereb ereb ganan, neu Dei ĩ aya bun inon. Taka nem Naal keleĩ sã, Dei yogo dogol. Taka nem Dei keleĩ sã, Naal yogo, tunĩ idi Naalum Dei ifelnẽdiyouf nigin igirnẽdif anidim dogol keleĩ. ");
INSERT INTO dad_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ã ganan morõ yei ken, sii yeik, wageun usig, ago ge di, aya wau inosiya afeneĩf. ");
INSERT INTO dad_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Neu sũ waleg, oroweĩ seg fen, aya bun keleĩ walogouf, ere nigin, aya molol fen, aya imatkesiya. Ago gouf, meleĩkanon siwo inoya gurug fouf. ");
INSERT INTO dad_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ere nigin, neu sũ karika fen, neu morõ yal bagai.” ");
INSERT INTO dad_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sain anĩ Juda neid Sabat naa bun, Jesus wit kabĩ atu atu iyok ilen. Jesus in dõ fiya tar naũ feid fen, wit tunĩ gei fiya gariya dino fen, don. ");
INSERT INTO dad_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisia tamo idi anĩ dileid fen, idi Jesus dirokenen, “Ulef! On dõ fiya tamo tar idi, ĩtãfiya difodul ken, Sabat naa bun oug difef.” ");
INSERT INTO dad_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus aitedin yalen, “Dawid in kusĩ tamo anidi geid naũ fedi di, Dawid age fen anĩ, ã Negur nẽ Itotoya bun to uwesegen de? ");
INSERT INTO dad_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ĩ Negur nẽ fõ namen ilen, agef fen, ĩ in kusĩ tamo anidi geid, bret fateul anĩ don, anĩ idi age fiya kisi feleya sã, anĩ idi ĩtãfiya difodul ken, age difen anĩ, prisem sã age difoũ nẽ anĩ. ");
INSERT INTO dad_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Oo ã Lo od anĩ to be uwesegen de? Are Sabat naa bun, pris tempel namen kabĩ dalef bunem naa anĩ didodok, anĩ ere, anĩ mosor sã. ");
INSERT INTO dad_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aya ã arokeneik, tekelei ĩ tempel wal fiya anĩ, are yeir. ");
INSERT INTO dad_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ã od enĩ, ‘Aya wau ifenẽya anĩ orouf, sesewi fiya sã,’ anĩ nẽ gariya keleim are, ã tamo morõ sã ege mosor ado to wiyẽdigem. ");
INSERT INTO dad_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ere nigin, Tamo Naal yogo dogol Sabat naa nẽ Odug.” ");
INSERT INTO dad_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus modoũ anĩ itor ken, iyok ile, Juda neid uub fõ namen ilen, ");
INSERT INTO dad_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tamo taka ima sitakã gege fefu fen, ĩ an ibodon. Idi Jesus bouwa bun od dinou fenẽ nigin naab dimir ken, abugã to difiyen, “Sabat naa bun tamo madur fiya anĩ idodõya sã de?” ");
INSERT INTO dad_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus idi irokenẽdin, “Ã anĩ taka, ã atun ĩ sipsip taka ado anĩ Sabat naa bun mekur isilauf, ã to uleg waleseg unenẽgouf de? ");
INSERT INTO dad_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tamo ĩ sipsip wal fiya bagai! Anĩ nigin, biya anĩ Sabat naa bun age tafef, are idodõya sã.” ");
INSERT INTO dad_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Age ye fen, ĩ tamo anĩ irokenen, “Imã fara wol.” Age ye di, ĩ ima fara fele di, oditekei ima madur len, age fe di, ima sitakã gen wõ yen. ");
INSERT INTO dad_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Anĩ ere, Farisia tamo idi dilelel fen, Jesus yukesiya nigin katõ difen. ");
INSERT INTO dad_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Idi neid kisi kelei ken, Jesus modoũ anĩ itoron. Tamo kayau musei ĩ dõ difiyẽ di, ĩ idi neid dagi ganan el fedin, ");
INSERT INTO dad_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","tamo kayau ganan wedereid iroun, ĩ aib yeya anĩ to yaor difouf nigin. ");
INSERT INTO dad_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Enĩ Negur, profet Asaia bunem eig ye wogõ yen anĩ kisi falauf nigin, agef wõ yen: ");
INSERT INTO dad_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Eĩ neu kabĩ tamo ayam agirnen, ĩ nigin aya wau laa fedig, ĩ nigin aya wau kulĩ yedig; aya neu Awa Uur ĩ bun anouf, ĩ anĩ teneub ganan haiden bun Negur nẽ madur bagai anĩ kurõ fesiyouf. ");
INSERT INTO dad_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ĩ to seye ye fen, ait bagam to iweig irõf; takam in ait naabur to karĩ youf. ");
INSERT INTO dad_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Werĩ felu reya ĩ to were fouf, takag, lalan komomor fe mog, ĩ to gare falauf, agef mog, Negur nẽ madur bagai anim ganan wal fouf. ");
INSERT INTO dad_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","In yana bun, teneub ganan haiden, idi neid waud an yenẽf.” ");
INSERT INTO dad_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tamo taka kaa sanem irou di, mala sigor ado ifofakelen, idi anĩ dirousi di, Jesus ĩ el fiyen. Age fe di, ĩ mala kelẽ ye fen, od wogõ yen. ");
INSERT INTO dad_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tamo kayau adok waud bun terẽ de fen, diron. “Enĩ anĩ Dawid Naal de?” ");
INSERT INTO dad_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Anĩ ere, Farisia tamo idi karĩ de fen, diron, “Are kaa sane neid mudur Belsebub yana bunem dogol, tamo enĩ kaa sesen irudif.” ");
INSERT INTO dad_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus idi neid kisi kelei ken, idi irokenẽdin, “Tano ganan yogo kiwai ifen ken, fara fouf, are sane lauf, taun ganan bun be, fõ ganan bun be, idi dogo fara difouf, idi to difarauf. ");
INSERT INTO dad_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan ĩ yogo Satan iruf, ĩ yogo nigin faraf, yogo kiwai ifenek, naig fe fen, anĩ yogon tano ifarauf? ");
INSERT INTO dad_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Are aya Belsebub yana bunem kaa sesen arudif, ere bunem ãgenei tamo kayau kaa sesen dirudidig? Anĩ nigin, idim ã es diyeĩf. ");
INSERT INTO dad_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Anĩ ere, aya Negur nẽ Awa Uur bunem kaa sesen arudif are, Negur nẽ tano mogo ã bun isil. ");
INSERT INTO dad_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Takag, taka megeir ado nẽ fõ bun ile, in safina bẽ yalou fenẽ, are ĩ tamo megeir ado anĩ ket ifokel fen, gama ĩ in safina fõ bun bẽ yalouf. ");
INSERT INTO dad_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Taka ĩ aya to fedẽ fiyaf, ĩ neu kiwai, takag, taka ĩ aya ado to guru mafef are, ĩ firagagaũ fef. ");
INSERT INTO dad_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Anĩ nigin, aya ã arokeneik, mosor kono fiya ado ganan tamo bun wõ yef, are yalelauf, anĩ ere, Awa Uur kono fiyek, are mosor to yalelauf. ");
INSERT INTO dad_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Taka ĩ Tamo Naal nigin kiwai ifen ken, kobu yef are, in mosor yalelauf. Ani ere, taka ĩ Awa Uur Fateul nigin kiwai ifen ken, kobu yef are, in mosor to yalelauf, gama sain enĩ bun ado dumen isiyouf buneg to yalelauf. ");
INSERT INTO dad_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Aa biya are faat biya yũdig, aa sane are faat sane yũdig, anĩ nigin, aa ganan faat bunem keleĩyadig. ");
INSERT INTO dad_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ã, gogour sane gere tar, naig fe di, ã sane anim ã biya nigin wogõ gouf? Ereb ã namein isokosef, are sigoreim kaaresi gef. ");
INSERT INTO dad_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tamo biya, safina biya ĩ bun kuru fef anĩ irou isidig, age fe di, tamo sane, safina sane ĩ bun kuru fef anĩ irou isidig. ");
INSERT INTO dad_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Anĩ ere, aya ã arokeneik, tamo idi od kisi sã wogõ den anĩ ganan, fau es fiya sain bun, idi fau dogo Negur mala bun, mugu mugu kurõ difesiyouf. ");
INSERT INTO dad_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anĩ nigin, ogon od bunem õ mosor sã yõf, ogon od bunem õ mosor ado yõf.” ");
INSERT INTO dad_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Age fe di, Farisia tamo tunĩ, lo ifelnẽdiya tamo tunĩ geid, idi Jesus dirokenen, “Tise, amã õ bun memelik nẽ uris taka mailau fenẽ.” ");
INSERT INTO dad_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus aitedin yalen, “Sane seseirã ibor, sain enei nẽ tamo kayau anĩ, memelik nigin to difef! Anĩ ere, taka to ifelneĩf, de profet Jona nẽ uris anim dogol ifelneĩf. ");
INSERT INTO dad_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ere nigin, Jona naa towo bõ towo, gau odug namen ibodon, age fiya gen, Tamo Naal naa towo bõ towo, teneub akor ilon yenẽf. ");
INSERT INTO dad_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niniwe tamo kayau fã de fen, es fiya naa bun, ibor enĩ, sain enei nẽ tamo kayau sane difiyẽdiyouf, ere nigin, idi mogo Jona wogõ ye di, waud falei den, gama taka Jona wal fiya are yeir. ");
INSERT INTO dad_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kuin Saut tamal fã ye fen, es fiya naa bun, ibor enĩ, sain enei nẽ tamo kayau sane fiyẽdiyouf, ere nigin, kayau anĩ, King Solomon nẽ keleĩ biya karĩ youf nigin teneub idiyan tamal isin, gama taka King Solomon wal fiya are yeir. ");
INSERT INTO dad_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Sain kaa sane tamo bun tamal ulõ yeis fen, gerere tuan ile, si inoya modoũ imirek ile to fotou fef. ");
INSERT INTO dad_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Agef fen, ĩ irok, ‘Aya fõ atoron anĩ bun baban kelauf.’ Sain ĩ kel isif, fõ ani daku, waĩ difel fen, madur difen anĩ ilef. ");
INSERT INTO dad_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Anĩ nigin, ĩ ile fen, baban kaa sesen ĩ wal fiya sewen anĩ geif irou isif, age de fen, idi namen dile, an difaref. Age dife di, tamo anĩ gai sane bagai lef, uruwa bun ne tobonunã anĩ wal fiya. Age fiya bagai, sain enei nẽ tamo kayau, ibor sane enĩ gama difaref, idi tobonunã anĩ adouf.” ");
INSERT INTO dad_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sain Jesus tamo kayau wogõ feid mog, in sina tura tar geid serẽ difar fen, ĩ geid od wogõ douf nigin orodin. ");
INSERT INTO dad_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Takam ĩ irokenen, “Ogon sinã turã tar geid serẽ difaref, idi õ geid od wogõ dou fenẽ orodif.” ");
INSERT INTO dad_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus aiten yalen, “Ai anĩ neu naai, ai anĩ neu turau tar?” ");
INSERT INTO dad_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","In dõ fiya tar bun imam ifelneĩd fen, ĩ iron, “Enidi anĩ neu naai, neu turau tar. ");
INSERT INTO dad_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Taka ĩ, neu Dei saa ilun ibodok anĩ nẽ oroya dõf age fef anĩ ĩ, neu turau, neu mainou, neu naai.” ");
INSERT INTO dad_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Naa de anĩ bun, Jesus aaben tamal kutũ yeis ile, daliyou sirin ibodon. ");
INSERT INTO dad_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Guru fiya odug kalilĩ difiyẽ di, tamo kayau adok ubun difar mog, ĩ waag namen isil ibodon. ");
INSERT INTO dad_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Agef fen, ereb ereb musei yaab od nem irokeneĩd fen, iron, “Kabĩ marau taka, faat irarãf nigin ilen. ");
INSERT INTO dad_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sain ĩ irarak ile mog, tunĩ naab luwen kuku ren, are ninã disi dakasin. ");
INSERT INTO dad_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tunĩ meein tuar kuku ren, an teneub badagar. Are kaisã bagai fokũ den, ere nigin, teneub are badagar bagai. ");
INSERT INTO dad_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Anĩ ere, sain gaa ise di, bali are ilala di, laasi yedin, ere nigin, idi warumutei sã. ");
INSERT INTO dad_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Faat tunĩ malũ duri atun kuku ren, are malũ duri anĩ fã ye fen, bali sile feledin. ");
INSERT INTO dad_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Faat tunĩ teneub biya bun kuku ren, are idi biya imadin, taka biya handred, taka biya siksti, taka biya teti age fef ilauf. ");
INSERT INTO dad_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aib ĩ weder adouf, karĩ youf.” ");
INSERT INTO dad_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","In dõ fiya tar ĩ wagen disi to difiyen, “Ere nigin õ yaab od nem tamo kayau urokenẽdif?” ");
INSERT INTO dad_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus aitedin yalen, “Saa tano nẽ waa keleĩ youf nigin are mogo ã ifenein, anĩ ere, tamo kayau to ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ereb taka aib ĩ ado are, anĩ wal fiya ifenẽf, anĩ ĩ musei adouf. Ereb taka aib ĩ sã, ereb ereb ĩ ado areg ĩ bun yalelauf. ");
INSERT INTO dad_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Anĩ nigin, aya yaab od nem arokenẽdif, ere nigin, “Idi meledim diledig, anĩ ere, idi meleid fokõya sã, idi wederedim karĩ dedig, anĩ ere, idi wedereid fokõya sã, to keleik. ");
INSERT INTO dad_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Idi bun, Asaia nẽ profet od kisi felef: “‘Ã wedereim karĩ gouf, anĩ ere, wedereĩ to fokõ youf, ã meleim ulogouf, anĩ ere, meleĩ to fokõ youf. ");
INSERT INTO dad_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ere nigin, tamo kayau enei, idi waud katĩ felen, idi wederedim karĩya malai bagai, age de fen, idi meleid difofakelen, age fiya sam are, idi meledim dilem, wederedim karĩ dem ado, idi waud fokõ ye fen, falei de di, aya idi el afedim.’ ");
INSERT INTO dad_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Anĩ ere, ãgenei meleĩ nigin el fedif, ere nigin, ã ulegef, ãgenei wedereĩ nigin el fedif, ere nigin, ã karĩ gef. ");
INSERT INTO dad_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Anĩ aya ã momoi arokeneik, profet musei, madur tamo geid, ã ulegef anĩ dilou fenẽ nigin waud yenen, anĩ ere, idi meledim to dilen, takag, karĩya ã karĩ gef anĩ karĩ dou fenẽ nigin waud yenen, anĩ ere, idi wederedim to karĩ den. ");
INSERT INTO dad_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yaab od bun, faat irarãya tamo nẽ gariya anĩ karĩg: ");
INSERT INTO dad_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Taka ĩ, saa tanon nẽ od karĩ ye fen, ĩ weder to fokõ yef, sane taka isi, faat yogon wau bun iraran anĩ son fiyek. Are faat naab luwen iraran anĩ age fiya. ");
INSERT INTO dad_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Takag, faat meein tuar kubũ yen are, tamo ĩ od karĩ ye fen, kaisã bagai ĩ od anĩ yale fen, wau bun kulĩ yef. ");
INSERT INTO dad_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Anĩ ere, ĩ warumutei sã, anĩ nigin, ĩ sain meluk to ibodõf. Sain, biya od nigin morõ be, kafĩ fiya be isif, ĩ kaisã bagai irofosif. ");
INSERT INTO dad_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Takag, faat taka malũ duri atun kubũ yen are, tamo ĩ od karĩ yef, anĩ ere, tenebur mata ibodõya nẽ sii fiya, safina ado ibodõya nẽ kisi fiya anidim, biya od sile fe di, anim biya to yũf. ");
INSERT INTO dad_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Takag, faat teneub biya bun kubũ yen are, tamo ĩ od karĩ ye fen, fokõ yef, are ĩ biya yũf, taka biya handred, taka biya siksti, taka biya teti agef imauf.” ");
INSERT INTO dad_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus yaab od taka irokenẽdin, “Saa tano ĩ, tamo taka yogon kabĩ bun, wit faat biya iraran gen. ");
INSERT INTO dad_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Anĩ ere, tamo adok mulaĩ den mog, yogon kiwai isin, lili wit kabier irara ken, agef yen ilen. ");
INSERT INTO dad_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sain wit bali fokũ ye fen, biya olili den, agef mog, lilig wowã den. ");
INSERT INTO dad_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Marau nẽ kabĩ tamo, ĩ wagen disin diron, ‘Tamo biya, õ faat biya on kabier to uraran de? Lili anĩ nainenem disin?’ ");
INSERT INTO dad_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ĩ aitedin yalen, ‘Kiwai takam age fen.’ “Ne kabĩ tamom to difiyen, ‘Amã mele anĩ kususu mafelauf anĩ õ oroyok de?’ ");
INSERT INTO dad_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ĩ aitedin yalen, ‘Sã, ere nigin, lili kususu ge mã, ã wit ado kususu gouf. ");
INSERT INTO dad_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Malakaĩ, weim difar mog, fau kusu fiya sain bun. Sain anĩ bun, aya kususu fiya tamo arokenẽdiyouf: Lili ketem kurug fen, ufafãg, dum yakur feid isaikalauf nigin; agog fen, wit kurug, neu kin gurig uleg.’” ");
INSERT INTO dad_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus yaab od taka irokenẽdin: “Saa tano ĩ, masted faat tamo takam yale fen, yogon kabier itenen gen. ");
INSERT INTO dad_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Anĩ ĩ faat ganan nigin naal bagai, anĩ ere, ĩ odugouf, ĩ kabier saaf ganan wal fediya aa wõ youf. Age fe di, ninã ilun temeleid disi, were bun dibodõf.” ");
INSERT INTO dad_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus baban yaab od taka irokenẽdin: “Saa tano ĩ, yis kayau takam yale fen, flawa odug ado falei fe di, ganan gẽ yedig gen.” ");
INSERT INTO dad_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus od enĩ ganan, yaab od nem tamo kayau wogõ fiyẽdin. Ĩ od ganan to kurõ falaisi irokenẽdin, yaab od nem dogol. ");
INSERT INTO dad_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Anĩ bunem, Negur profet bunem eig ye wogõ yen anĩ, agef kisi felen: “Aya yaab od bunem sigoroum kurõ afesiyouf, gariya bun teneub ino fen, ereb ereb inokakan anĩ aya yaor afouf.” ");
INSERT INTO dad_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesus tamo kayau itorneĩd fen, fõ namen ilen. In dõ fiya tar ĩ wagen disi fen, diron, “Kabier lili nẽ yaab od anĩ, amã faded wamã.” ");
INSERT INTO dad_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus aitedin yalen, “Tamo tekelei faat biya iraran, are Tamo Naal. ");
INSERT INTO dad_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kabĩ are tenebur tamo kayau, faat biya anĩ, are Negur nẽ tano nẽ gere tar, lili are Satan nẽ gere tar, ");
INSERT INTO dad_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","kiwaim lili iraran, are Satan. Kusu fiya are saa teneub ado idiyẽf bun, kususu fiya tamo are idi engel. ");
INSERT INTO dad_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Anĩ nigin, lili kususu feid, yã yakur feid isaikalauf, age fiya gen, saa teneub ado idiyẽf bun, age fouf. ");
INSERT INTO dad_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tamo Naal ĩ, yogon engel sur fediyouf, idi yogon tano bun ereb ereb ganan mosor dinodig ado, tamo kayau ganan sane age difedig gei difeid fen, dalelnẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Idi yã mala bobo rouf bun dirarãf, an inã odug ado firi de fen, goboreid kikokõ youf. ");
INSERT INTO dad_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Age fe di, madur tamo idi, gaa gen nedi Temeid nẽ tanon fula difouf. Aib ĩ weder adouf, karĩ youf. ");
INSERT INTO dad_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Saa tano ĩ, safina biya bagai kabier inokon gen. Tamo taka fotou fe fen, baban kabier inokon. Agef fen, wau al fef ile, safina adok ĩ ado anĩ, na nigin sur fe fen, akor anĩ na yalen. ");
INSERT INTO dad_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Takag, saa tano ĩ, na yaleya tamo, maaĩ tuwa meli bagai pel biya, na nigin imirek gen. ");
INSERT INTO dad_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ĩ meein medeĩya taka moni odug nẽ anĩ fotou fe fen, ile, safina adok ĩ ado anĩ na nigin sur fe fen, meein medeĩya anĩ na yalen. ");
INSERT INTO dad_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Takag, saa tano ĩ, kakãg daliyou bun gau bou fire fire gei fiya nigin dirãdig gen. ");
INSERT INTO dad_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sain kakãg isokose di, gau yaleya tamo dĩ dife, ubun ise di, anĩ idi dibod ken, gau biya gei de, karam namen difeid fen, sesen anĩ are dirarailen. ");
INSERT INTO dad_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Age fiya bagai, saa teneub ado idikalauf bun eig fouf. Engel idi disi fen, idi madur tamo atun sesen anidi gei de dale, ");
INSERT INTO dad_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yã mala bobo ref bun dirarãf, an inã odug ado firi de fen, goboreid kikokõ youf.” ");
INSERT INTO dad_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus to fedin, “Ã od enĩ ganan wedereĩ fokõ yef de?” Idi diron, “Yo, amã karĩ mauf.” ");
INSERT INTO dad_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesus idi irokenẽdin, “Anĩ nigin, lo ifelnẽdiya tamo ganan saa tano nigin ifelnẽdin are, idi fõ tama gen, ĩ safina biya nẽ aaben tamal safina mata tubu ado irou isidig.” ");
INSERT INTO dad_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus yaab od eneidi bure fel fen, anenem iyok ilen. ");
INSERT INTO dad_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","In fõ gariyan isi fen, ĩ an tamo kayau dogo neid uub fõ bun ifelnẽdin, age fe di, idi terẽ den. Idi to difen, “Tamo eĩ, kisi biya ado memelik nẽ totol enei, nain yalen? ");
INSERT INTO dad_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ĩ kapenta naal sã de? In sina Maria sã de? In tura tar Jems, Josef, Simon, Judas ado sã de? ");
INSERT INTO dad_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","In main tar ganan, ada weim to tabodok de? Tamo enĩ enei ganan nain yalen?” ");
INSERT INTO dad_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Age de fen, idi ĩ kiwai difenen. Anĩ ere, Jesus idi irokenẽdin, “Profet taka ĩ, in fõ gariyan ado in fõ bun dogol, ĩ yana sã.” ");
INSERT INTO dad_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ĩ an memelik musei to inon, ere nigin, idi to momoi den. ");
INSERT INTO dad_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sain anĩ bun, Galili nẽ uyu irouya Herod Jesus nigin od karĩ ye fen, ");
INSERT INTO dad_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","in kabĩ tamo irokenẽdin, “Enĩ Jon naan igunẽdiya tamo, ĩ laa fen anĩ kel fã yen! Anĩ nigin, memelik nẽ totol ĩ bun kabĩ yalef.” ");
INSERT INTO dad_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kulu Herod, in tura Filip nẽ aiwa, Herodias nigin, Jon yale ifõ, kalabus bun inenen. ");
INSERT INTO dad_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ere nigin, Jon ĩ irokenẽdig, “Õ ĩtãfiya ufodul ken, turã nẽ kayau walen.” ");
INSERT INTO dad_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod Jon yukesiya nigin wau yenen, anĩ ere, tamo kayau kumĩ fedin, ere nigin, idi ĩ profet taka dedig. ");
INSERT INTO dad_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod sina gõ fen anĩ nẽ naa bun, Herodias nẽ barai seg kui ye fen, dole kenẽdi di, Herod wau al bagai fen. ");
INSERT INTO dad_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Age fe di, ĩ wau adok kuturol fen, ne barai ereb taka nigin to fouf, de anĩ bagai ifenẽf yen. ");
INSERT INTO dad_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","In sinam weder te yabi di, ĩ iron, “Beĩ taka bun Jon naan igunẽdiya tamo mudur uno fen, ein wanauf.” ");
INSERT INTO dad_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King ĩ wau togun, anĩ ere, wau kuturol fen, tamo kayau meleid bun kurõ fesin anĩ nigin, in oroya dõf anĩ bagai ifenẽf nigin wogõ ye fen, tamo sur fe di, ");
INSERT INTO dad_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jon kalabus bun ula gudũ fen. ");
INSERT INTO dad_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","In mudur beĩ bun dino diroule, ne barai difenẽ di, ĩ sina gein irou ilen. ");
INSERT INTO dad_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jon nẽ dõ fiya tar disi, in bouwa buru dale mũ difen. Age de fen, idi dilen, Jesus dirokenen. ");
INSERT INTO dad_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus, Herod Jon ula gudũ fen anĩ karĩ ye fen, ĩ mugu bagai waag bun moilin ilen. Tamo kayau idi anĩ karĩ de fen, taun temeleid yedim dõ difen. ");
INSERT INTO dad_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sain Jesus kutũ yeis fen, mala iran, tamo kayau musei iledin, ĩ idi nigin wau yu ken, idi neid dagi el fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mogo bok isi di, in dõ fiya tar Jesus wagen disi diron, “Eĩ gerere tuan, sain mogo sa kelef. Tamo kayau susur wo di, dilalauf, ago di, idi fonõ fonõ dile fen, dogo neid saaf na dalouf.” ");
INSERT INTO dad_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus irokenẽdin, “Idi ileya nigin kisi to yenẽf. Saaf yõya nigin ãgem wenẽdigouf.” ");
INSERT INTO dad_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Idi dirokenen, “Amã ein bret faif, gau uru ado dogol.” ");
INSERT INTO dad_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ĩ iron, “Wageun gurig urousig.” ");
INSERT INTO dad_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tamo kayau fisir bun dibodadãf nigin Jesus irokenẽdin. Bret faif gau uru ado, imam yale, saa ilun itad fen, ĩ Negur de fiye ken, bret mumã fen. Agef fen, in dõ fiya tar ifenẽdi di, idim tamo kayau difenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Idi ganan don anĩ kisi felen. Age fe di, in dõ fiya tar, tamo kayau bret dokon, tunĩ ditoraran anĩ fito difen, karam tuwelf eweid gere fen. ");
INSERT INTO dad_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tamo bret don anĩ, idi faif tausen age fiya, kayau kesu geid iwesediya sã. ");
INSERT INTO dad_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kaisã bagai, Jesus, in dõ fiya tar waag bun idi ketem sitakã dilauf nigin sur fedin. Age de mog, ĩ tamo kayau irudin. ");
INSERT INTO dad_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesus idi irud le fen, ĩ yogo arein kosẽ youf nigin iselen. Ĩ an mugu ibod mog, bõ irou isin. ");
INSERT INTO dad_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Anĩ ere, waag mogo teneub itoron gerõ ifaren, yau odug fã ye di, moloun wĩ ye fen, waag yũ di, ilef isif fen. ");
INSERT INTO dad_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wef mog, Jesus daliyou teteatu idi gedin iyok ilen. ");
INSERT INTO dad_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sain in dõ fiya tar meleid diran, daliyou teteatu iyõ mog, dile fen, idi tererẽ den. Idi diron, “Eĩ baraũ,” kumĩ de fen, ui guru den. ");
INSERT INTO dad_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Anĩ ere, kaisã bagai Jesus irokenẽdin, “Totol ufareg! Are ayam. To kumĩ wog.” ");
INSERT INTO dad_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita solof iron, “Odug, onom ouf are, urokana len, naan teteatu õ garan asiyouf.” ");
INSERT INTO dad_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus iron, “Usi.” Age fiyẽ di, Pita waag bun kutũ yeis, naan teteatu Jesus wagen iyok ilen. ");
INSERT INTO dad_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Anĩ ere, ĩ yau ile fen, kumĩ ye di, gamai imutuk isil fen, iweig iron, “Odug, usenna!” ");
INSERT INTO dad_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kaisã bagai, Jesus ima iran, yalesne ken, irokenen, “Õ momoiya naal, ere nigin õ waũ uru ado?” ");
INSERT INTO dad_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Age ye fen, idi uru waag namen sosõ de di, yau kee relen. ");
INSERT INTO dad_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Anĩ dile fen, idi waag namen difaren, Jesus nigin seli dabi diron, “Momoi bagai, õ anĩ Negur Naal.” ");
INSERT INTO dad_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sain idi daliyou sitakã dibal dilen, Genesaret teneub bun wõ den. ");
INSERT INTO dad_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tamo kayau fonõ anĩ bun temeleid, Jesus kelei ken, idi fonõ anĩ kalilĩ fiya fõ fõ ganan od dinon. Fonõ fonõ idi neid dagi tamo guri difeid, Jesus wagen disi fen, ");
INSERT INTO dad_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","idi dagi tamo yogon gabar irig kobũ difouf nigin, Jesus digonen. Ganan idi ĩ kobũ difen, dagi fara feledin. ");
INSERT INTO dad_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sain anĩ bun, Farisia tamo tunĩ, lo ifelnẽdiya tamo tunĩ geid, Jesus garan Jerusalem temeleid disi to difiyen, ");
INSERT INTO dad_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ere nigin on dõ fiya tar, mudur ado neid tobonunã wal difedig? Idi neid imeid kulo fiya sã, saaf dõdig!” ");
INSERT INTO dad_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus solof irokenẽdin, “Ere nigin ã ãgenei tobonuneĩ dõg fen, Negur nẽ ĩtãfiya wal gedig? ");
INSERT INTO dad_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ere nigin, Negur iron, ‘Õ sinã tamã yeneid wales,’ ‘Aibem taka sina be tama be gelu fiyẽf, ĩ laa bun dinenẽf bagai.’ ");
INSERT INTO dad_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Anĩ ere, ã urõgedig, ‘Tamo taka, sina be, tama be idi bun irõf, “Ereb taka õ isennõya nigin ayam ifonõya anĩ, ayam Negur afenem,” ");
INSERT INTO dad_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ĩ age fef anĩ bunem in tama yana seli kulõ fiya nigin to age fouf,’ gedig. Ãgenei tobonunã age fiya bunem Negur nẽ od to dõ gedig. ");
INSERT INTO dad_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ã mala yaleya tamo! Asaia ĩ, ã nigin profet od eig ye wogõ yen in od tutuk: ");
INSERT INTO dad_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Tamo kayau enidi, nedi sigoredim aya selu kulõ difedig, anĩ ere, idi neid waud aya nigin gerõ ifaref. ");
INSERT INTO dad_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Idi aya yanau dalesedig, are ege. Idi neid ifelnẽdiya are tamo nẽ keleĩ dogol dõ difedig.’ ” ");
INSERT INTO dad_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus tamo kayau iweig laisi, irokeneĩd fen, iron, “Karĩg fen, wedereĩ fokõf. ");
INSERT INTO dad_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ereb taka mayarem tamo awa kurẽ isilef anim, ĩ amuyẽ to ifenẽdig, anĩ ere, ereb taka namenem awa kurem ulõ yesif anim, ĩ amuyẽ ifenẽdig.” ");
INSERT INTO dad_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Age ye di, in dõ fiya tar ĩ garan disi to difiyen, “Farisia tamo idi od enĩ karĩ de fen, waud õ nigin to biyaf anĩ, õ karĩ wof de?” ");
INSERT INTO dad_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus aitedin yalen, “Aayũ ganan, neu Dei saa ilun tamal im to itenanan, are warumutei ado kususu fouf. ");
INSERT INTO dad_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Utornẽdig; idi uyu irouya nigin meleid ifofakelen. Mala ifofakeleya tamo taka, mala ifofakeleya taka gim fiyẽf are, idi uruwom mekur kuku douf.” ");
INSERT INTO dad_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita iron, “Yaab od enĩ nẽ gariya faded wo urokanamã.” ");
INSERT INTO dad_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus to fedin, “Ã fau nene gef de? ");
INSERT INTO dad_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ã to ulegedig de? Ereb taka awa gerinem te namen isilef are te ado iledig. ");
INSERT INTO dad_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Anĩ ere, ereb taka awa bun wõ yef are wauda bunem isedig anim, tamo amuyẽ ifenẽdig. ");
INSERT INTO dad_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ere nigin, wauda bun tamal wõ yef, are kisi sesen, tamo yukesiya, seseirã inoya, noli tobonunã, bẽ, kot bun idegẽya od bou bun yũya, dumen od wogõya. ");
INSERT INTO dad_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Enĩ ganan anĩ tamo amuyẽ ifenẽdig, anĩ ere, ima kulo fiya sã saaf doko anim, tamo amuyẽ to ifenẽdig.” ");
INSERT INTO dad_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus modoũ anĩ itor ken, Taia Saidon ado neid teneub akoron ilen. ");
INSERT INTO dad_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Haiden kayau Kanan tamal taka, melsã an tamal Jesus wagen isin iweig iron, “Odug, Dawid Naal, aya nigin malalon yõ! Neu barai kaa sanem irou di, to biya bagai yenek.” ");
INSERT INTO dad_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Anĩ ere, Jesus od taka to solo fenen. Anĩ nigin, in dõ fiya tar Jesus wagen disi, totol bagai dirokenen, “Kayau sur wo di, ile, ere nigin, ĩ iweig fen, iweig fen, dõ fadaf.” ");
INSERT INTO dad_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus kayau aiten yalen, “Negur aya sur fiyan are, sipsip Israel atun fõ delen anidi bun dogol.” ");
INSERT INTO dad_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kayau anĩ isin, wagen ibor bobou fe fen, ĩ iron, “Odug, aya usenna!” ");
INSERT INTO dad_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus aiten yalen, “Kesu nanaal neid saaf yale fen, gaũ irarak kenẽdiya are to biya.” ");
INSERT INTO dad_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kayau anĩ iron, “Odug, are momoi, anĩ ere, gaũ idig moroid tar tebol bun saaf dõ di, momout kuku re di, dõdig.” ");
INSERT INTO dad_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Age ye di, Jesus aiten yalen, “Kayau, õ momoiya odug ado! Ogon waũ irok agef ifonok.” Sain anĩ bun bagai, ĩ ne barai el felen. ");
INSERT INTO dad_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus an itor ken, Galili maaĩ yeri dõ fen. Agef fen, ĩ arein isel ibodon. ");
INSERT INTO dad_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tamo kayau musei wagen disin, yeid kirorõya, meleid ifofakelen, iborodim gogo dedig, aiteid ifofakelen, dagi fire fire museig, Jesus ye gariyan guri dife dirou disi di, ĩ el fedin. ");
INSERT INTO dad_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aiteid ifofakelen od wogõ den, iborodim gogo dedig madur feid difaren, yeid kirorõya diyon, meleid ifofakelen lo difen, anĩ ganan tamo kayau dile fen, terẽ den. Age fe di, idi Israel nẽ Negur yana dalesen. ");
INSERT INTO dad_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus, in dõ fiya tar iweignẽdi di, wagen disi di, irokenẽdin, “Aya tamo kayau enidi nigin waud inaf, idi mogo aya geid naa towo dibodon, anĩ ere, gama ereb taka yõya sã. Aya, idi naũ susur afedi di, dilauf anĩ to orouf, age afouf are, idi luwen kuku douf.” ");
INSERT INTO dad_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","In dõ fiya tar dirokenen, “Amã gerere tuan ein bret kisi feleya nain male fen, musei enĩ weit mafediyouf?” ");
INSERT INTO dad_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus to fedin, “Bret ganĩ ã ado?” Idi diron, “Bret sewen, gau nanaal teke tekelei ado.” ");
INSERT INTO dad_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesus tamo kayau tenebur dibodadãf nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Agef fen, Jesus, bret sewen gau ado, imam yale iroun, ĩ Negur de fiye ken, bret anĩ mumã feid fen, in dõ fiya tar ifenẽdi di, idi bagam tamo kayau difenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Idi ganan don anĩ kisi felen. Dumen in dõ fiya tar, tamo kayau bret dokon, tunĩ ditoraran anĩ fito difen, karam sewen eweid gere fen. ");
INSERT INTO dad_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tamo bret don anĩ idi fo tausen, kayau kesu geid iwesediya sã. ");
INSERT INTO dad_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesus tamo kayau susur feid, dilele di, ĩ waag bun sõ ye, Magadan akoron ilen. ");
INSERT INTO dad_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisia tamo Sadusia tamo geid, Jesus wagen disi, kisi difiye ken, saa ilun nẽ memelik taka meledin inouf nigin to difiyen. ");
INSERT INTO dad_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus aitedin yalen, “Sain aragau isi di, ã urõgedig, ‘Sain biyau fenẽ, ere nigin, saa giri yef,’ ");
INSERT INTO dad_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","bonimei di, ã urõgedig, ‘Gama uyẽ yau ado fouf, ere nigin, saa giri ye fen, budũ iyokelef.’ Ã saa bun es fiya nigin keleĩ bagai, anĩ ere, ã ereb sain nẽ uris es fiya nigin kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sain enei nẽ tamo kayau, ibor sane seseirã inoya nẽ anĩ, memelik nẽ uris dimirẽdig, anĩ ere, taka to ifenẽdiyouf, de Jona nẽ uris dogol ifenẽdiyouf.” Age ye fen, Jesus idi itorneĩd ilen. ");
INSERT INTO dad_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sain idi daliyou sitakã dibal dilen, in dõ fiya tar bret yaleya nigin wedereid tu kelen. ");
INSERT INTO dad_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus idi irokenẽdin, “Lo welegei! Farisia tamo ado Sadusia tamo neid yis nigin, ã lo welegei.” ");
INSERT INTO dad_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","In dõ fiya tar idi dogo dogol katõ de fen, diron, “Ĩ agef irok, ere nigin, ada bret to tarousil nigin.” ");
INSERT INTO dad_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Idi neid wogõya Jesus kelei ken, to fedin, “Ã momoiya naal bagai, ere nigin ã bret sã ge fen, aug tutur wogõ gef? ");
INSERT INTO dad_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ã wedereĩ fau to fokõ yef de? Ã to karĩ welegef, bret faif anĩ faif tausen don, age fe di, karam ganĩ ã kuru ge di, eweid gere fen? ");
INSERT INTO dad_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Takag, bret sewen anĩ fo tausenem don, age fe di, karam ganĩ ã kuru ge di, eweid gere fen? ");
INSERT INTO dad_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ã naig fe di, wedereĩ to fokõ yef, aya bret nigin ã to arokeneim de? Anĩ ere, ã lo welegei, Farisia tamo ado Sadusia tamo neid yis nigin.” ");
INSERT INTO dad_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Age ye di, idi mogo wedereid fokõ yen, ĩ yis bret bun dinodig anĩ nigin to wogõ fedin, ĩ Farisia tamo ado Sadusia tamo neid ifelnẽdiya anĩ nigin wogõ fedin. ");
INSERT INTO dad_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sain Jesus Sisaria Filipai nediwon isi fen, in dõ fiya tar to fiyẽdin, “Tamo kayau Tamo Naal nigin ai dedig?” ");
INSERT INTO dad_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Idi dirokenen, “Tunĩ dirok, õ Jon naan igunẽdiya tamo, tunĩ dirok, õ Eliya, tunĩ dirok, õ Jeremaia oo profet taka be.” ");
INSERT INTO dad_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus to fedin, “Ba ã uleg? Aya nigin ã ai gef?” ");
INSERT INTO dad_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Pita aiten yalen, “Õ anĩ Kristus, Õ mata ibodõya Negur Naal.” ");
INSERT INTO dad_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus solof iron, “El fiya õ ado, Simon Jona nẽ naal, ere nigin, on keleĩ are tamo nẽ keleĩ bunem sã, are neu Dei saa ilun tamal in keleĩ bunem. ");
INSERT INTO dad_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Anĩ nigin, aya õ arokonok, õ Pita, meein enĩ teten neu sios anouf, laa nẽ megeir anim sios to wal fiyẽf. ");
INSERT INTO dad_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aya saa tano nẽ ki õ afonõf, ereb õ tenebur ein ufok, are saa ilun ouneg ifõf, ereb õ tenebur ein biru wof, are saa ilun ouneg biru fouf.” ");
INSERT INTO dad_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Age ye fen, Jesus ĩ Kristus yeya anĩ, aib taka to dirokenẽf nigin, in dõ fiya tar wedereid iroun. ");
INSERT INTO dad_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sain anĩ bunem ilauf bun, Jesus yogo nigin in dõ fiya tar yaor fe irokenẽdin, ĩ Jerusalem ilauf bagai, an darau musei, mudur adodo, pris odudug, lo ifelnẽdiya tamo imeid bun yalouf, an ĩ dukesiyouf, naa towo bure fele di, mata kel fã youf. ");
INSERT INTO dad_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita Jesus yale, yerin irou ile ou fiyen, ĩ iron, “Odug, sã bagai! Enĩ ganan õ nigin to bagai wõ youf!” ");
INSERT INTO dad_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus falei yel, Pita irokenen, “Satan, dumeun ule! Õ aya naaburau gudũ wof; on kisi are Negur nẽ sã, on kisi tamo nẽ dogol.” ");
INSERT INTO dad_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Age ye fen, Jesus in dõ fiya tar irokenẽdin, “Aib taka aya dõ fiyau fenẽ, ĩ yogon oroya lai fesil fen, ĩ yogon aa tetek faali fe fen, anĩ aya dõ fiyauf. ");
INSERT INTO dad_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ere nigin, aib taka yogon mata isennẽf nigin oro fef are, fõ yalauf, aib taka yogon mata, aya nigin irailauf are, mata anĩ gurug fouf. ");
INSERT INTO dad_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tamo taka ĩ, teneub enĩ ganan kakarai fe fen, akorou yef, anĩ are, ĩ yogon malakanon irailauf, ere biya ĩ yalouf? Takag, tamo taka yogon malakanon nigin ere mala solof fen, ĩ kel yalouf? ");
INSERT INTO dad_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tamo Naal, in Tama nẽ fula fiya medeĩya ado in engel geid disiyouf, agef fen, tamo mugu mugu ereb age fef anĩ kilei, ĩ mala solo age fiya bagai ifenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aya momoi arokeneik, tunĩ ein difaref fau to gare de mog, idi Tamo Naal in tano bun isi di, dilouf.” ");
INSERT INTO dad_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Naa sigis bure fele di, Jesus, Pita, Jems, taka Jon Jems nẽ tura geif fen, idi mugu arei odug ilun diselen. ");
INSERT INTO dad_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","An Jesus idi meleid bun bouwa falei felen. In nawa gaa gen fula felen, in kolos lalau fen, yal gen lalanen. ");
INSERT INTO dad_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Agef mog, an idi meleid bun Moses, Eliya ado wõ de fen, Jesus weim wogõ den. ");
INSERT INTO dad_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita Jesus irokenen, “Odug, ada ein ibodõya nigin biya bagai. Õ oroyõf are, aya salafat towo anouf, taka ogon, taka Moses nẽ, taka Eliya nẽ.” ");
INSERT INTO dad_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita fau wogõ ye mog, lalo lalau bagai idi kerub fedin, ait taka lalo namen iron, “Eĩ neu Kesu, ĩ nigin aya wau laa fedig, ĩ nigin aya wau kulĩ yedig. Ĩ karĩ wiyẽg!” ");
INSERT INTO dad_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Anĩ in dõ fiya tar karĩ den, idi neweid kususur de fen, tenebur gurorõ de tererẽ den. ");
INSERT INTO dad_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Anĩ ere, Jesus isin, kobũ feid fen, ĩ iron, “Fafãg, to kumĩg.” ");
INSERT INTO dad_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Idi ditadsen, taka to dilen, Jesus dogol. ");
INSERT INTO dad_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Idi arei bun diyok disi fen, Jesus idi irokenẽdin, “Ã ereb ulegel enĩ, aib taka to urokenẽg, fau Tamo Naal laa bun tamal kel fã ye di.” ");
INSERT INTO dad_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","In dõ fiya tar Jesus to difiyen, “Ere nigin lo ifelnẽdiya tamo dirõdig, ‘Eliya ĩ ketem isiyouf bagai’ dedig?” ");
INSERT INTO dad_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus aitedin yalen, “Momoi bagai, Eliya isi fen, ereb ereb ganan madur fediyouf. ");
INSERT INTO dad_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Anĩ ere, aya ã arokeneik, Eliya mogo isi bure felen, idi anĩ ĩ nigin to kelei ken, ereb ereb ganan idi waud iron kilei, ĩ nigin mogo age difen. Age fiya gen, Tamo Naal idi imeid bun darau yalouf.” ");
INSERT INTO dad_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesus age wogõ ye di, in dõ fiya tar idi wedereid fokõ yen, Jon naan igunẽdiya tamo nigin irok den. ");
INSERT INTO dad_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sain idi tamo kayau gedin disin, tamo taka Jesus wagen isi fen, ibor bobou fen. ");
INSERT INTO dad_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ĩ iron, “Odug, neu kesu nigin malalon yõ. Ĩ mir yuk sain, sane bagai firi ye fen, sain musei yãg iledig, naanũg iledig. ");
INSERT INTO dad_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aya, ĩ, on dõ fiya tar wagedin arou elen, anĩ ere, idi el fiyẽya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus solof iron, “Sain enei nẽ tamo kayau, ibor enĩ, sane, momoiya sã, sain ganĩ aya ã geid tabodõf? Sain ganĩ aya ã nigin wau aukesilauf? Kesu wageun ein urousig.” ");
INSERT INTO dad_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus kaa sane ou fiyẽ di, kesu bun tamal ulõ yeis ile mog, kesu ĩ bou karika len. ");
INSERT INTO dad_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Age fe di, in dõ fiya tar mugun Jesus wagen disi to difiyen. “Ere nigin amã kaa sane iruya kisi feleya san?” ");
INSERT INTO dad_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus irokenẽdin, “Ere nigin, ãgenei momoiya naal bagai nigin. Aya momoi arokeneik, ã momoiya naal masted faat age fiya adouf are, ã arei enĩ urokenẽgouf, ‘Ein tamal godo urou ule, oun ufar,’ ago ge di, ĩ dõf age fouf. Ereb ereb ganan ã age fiya kisi feleya.” ");
INSERT INTO dad_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sain idi disi, Galili guru difen, Jesus idi irokenẽdin, “Tamo Naal ĩ fau tamo imeid bun dinouf. ");
INSERT INTO dad_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Idi fau ĩ dukesiyouf, anĩ ere, naa towo bure fele di, ĩ fau baban mata kel fã youf.” Age ye di, in dõ fiya tar waud morõ gudũ fesin. ");
INSERT INTO dad_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus in dõ fiya tar geid, Kapenaum taun disi di, tempel takis yaleya tamo, Pita wagen disi to difiyen, “Ãgenei tise tempel nẽ takis to inodig de?” ");
INSERT INTO dad_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita iron, “Ariya, ĩ takis inodig.” Sain Pita fõ namen isi di, Jesus ket wogõ yen, “Simon, õ ere kisi wof? Ai bunem tenebur nẽ king anidi takis daledig, idi neid kesu bunem de, oo tamo tunĩ bunem?” ");
INSERT INTO dad_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita solof iron, “Tamo tunĩ bunem.” Jesus ĩ irokenen, “Anĩ nigin, kesu idi bunem sã. ");
INSERT INTO dad_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Anĩ ere, adam idi waud saneya to tafenẽdiyouf nigin, õ daliyoun ule, on mũ urãf. Gau uruwa walouf anĩ awa gede fen, an silwa koin moni ulouf, wale fen, takis ogon ado neu nigin wenẽdiyouf.” ");
INSERT INTO dad_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sain anĩ bun, in dõ fiya tar Jesus wagen disi, to difiyen, “Aim saa tanon odug bagai ibodok?” ");
INSERT INTO dad_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ĩ kesu naal taka iweignẽ isi di, idi atun ifarnen. ");
INSERT INTO dad_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Agef fen, ĩ iron, “Aya momoi arokeneik, ã kesu nanaal gen falei gouf anĩ dogol, age fiya sãf are, ã saa tanon to bagai ulagauf. ");
INSERT INTO dad_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Anĩ nigin, aib taka yogo nigin kuru kel fen, kesu enĩ genẽf are, ĩ saa tanon odug bagai ibodok. ");
INSERT INTO dad_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Takag, aib taka kesu naal eig fiya, aya yanau nem yalef are, ĩ aya yaleyaf. ");
INSERT INTO dad_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Anĩ ere, aibem taka age fe di, kesu aya nigin momoi def enidi taka, mosor bun kubũ youf are, tamo anĩ meein odug guyutu bun ifo ken, maaĩwõ irãya nigin biya. ");
INSERT INTO dad_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Teneubur tamo kayau idi meleidlon ado, ere nigin, ereb to biya anĩ age fe di, tamo mosor bun dilalauf. Tobonunã age fiya bagai wõ youf, anĩ ere, tamo nanĩ be bunem isif, ĩ malalon ado! ");
INSERT INTO dad_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ogon imam be, yem be mosor bun ineyõf are, gudũ fen uraile. Õ imã tobega be, yẽ tobega ado mata bun ileya nigin biya bagai, ere nigin, imã totoũ be, yẽ totoũ adouf are, yã faimud ibodkeleya anĩ bun an dirãyõf. ");
INSERT INTO dad_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Age fiya bagai, ogon malam mosor bun ineyõf are, ubodol uraile. Õ malã tekelei ado mata bun ileya nigin biya bagai, ere nigin, malã totoũ adouf are, hel nẽ yã mala bun dirãyõf. ");
INSERT INTO dad_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ã lo welegei, kesu nanaal enidi taka to meleĩ irim gouf. Ere nigin, aya ã arokeneik, idi neid engel saa ilun dibodok, sain ganan neu Dei saa ilun ibodok no diledig. ");
INSERT INTO dad_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ã ere kisi ado? Tamo taka ĩ wan handred sipsip ado, tekelei idi atun fõ yalauf are, marau ĩ nainti-nain sipsip uya bun itorneĩd fen, ile, tekelei fõ yelen anĩ to imirẽf de? ");
INSERT INTO dad_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aya ã momoi arokeneik, ĩ fata fouf are, ĩ sipsip tekelei anĩ nigin wau kulĩya odug, sipsip nainti-nain to fõ delen nigin anĩ nẽ kulĩya wal fiya. ");
INSERT INTO dad_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Age fiya bagai, ãgenei Temeĩ saa ilun ibodok, kesu nanaal enidi taka fõ yeleya nigin to orodig. ");
INSERT INTO dad_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ogon turã taka mosor inoyõf, ule ã uruwom atun dogol in kũ fenẽya ufelnẽf. Ĩ õ karĩ yõf, õ ogon turã mogo kel walel. ");
INSERT INTO dad_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Anĩ ere, ĩ to karĩ yõf, baban tekelei be uru age fiya õ geid fen, ulagauf, ago di, ‘od ganan isennẽya uruwom be, towom sigoredim kurõ difesiyouf anĩ megeir gouf.’ ");
INSERT INTO dad_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ĩ idi karĩ fediya nigin itorõf, sios urokenẽf. Ĩ sioseg karĩ fiyẽya nigin itorõf are, ĩ haiden be takis yaleya tamo sane gen unenẽf. ");
INSERT INTO dad_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Aya ã momoi arokeneik, ereb taka ã tenebur ein ufokalagauf, are saa iluneg ifokalauf, ereb taka ã tenebur ein biru walagauf, are saa iluneg biru falauf. ");
INSERT INTO dad_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Baban, aya ã arokeneik, tenebur ein ã uruwom ereb taka nigin wauĩ tekelei fen, to gouf, neu Dei saa ilun ibodok, ĩ dõf ã nigin age fouf. ");
INSERT INTO dad_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ere nigin, uruwom be, towom be, aya yanau nem guru difef, aya an idi geid mabodok.” ");
INSERT INTO dad_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Age ye di, Pita Jesus wagen isi, to fen, “Odug, neu turau aya nigin mosor inouf, sain ganĩ neu turau nẽ mosor nigin wederou tu kalauf? Wederou tu kelef ile, sewen daũ de?” ");
INSERT INTO dad_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus aiten yalen, “Aya õ arokonok, õ sewen dogol to agouf, sewenti anĩ are sewenem tobol wouf. ");
INSERT INTO dad_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Anĩ nigin, saa tano ĩ, king taka, ne ferfer geid in wareg madur fiya nigin oron gen. ");
INSERT INTO dad_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","King ĩ wareg madur fiya nigin gariya inon, tamo taka ĩ bun ten milion kina yalen anĩ, ĩ wagen dirou disin. ");
INSERT INTO dad_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ĩ wareg anĩ yukesiya kisi feleya sã nigin marau iron, ĩ yogo ado in aiwa, in gere tar ado in safina ganan na nigin sur fedi di, in wareg anĩ yukesiya kisi falauf yen. ");
INSERT INTO dad_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kabĩ tamo, marau wagen ibor bobou fe fen, igonen, ‘Õ aya nigin waũ unois fen, sain wana len, aya wareg anĩ ganan kisi afelkonõf.’ ");
INSERT INTO dad_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kabĩ tamo anĩ nẽ marau, ĩ nigin wau yu ken, wareg anĩ ganan lai fesil fen, itornẽ di, ilen. ");
INSERT INTO dad_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Anĩ ere, kabĩ tamo anĩ oreis ile fen, ĩ yogon kabĩ tura taka fotou fen, ĩ bun wareg wan handred kina ado. Ĩ ka fe, ula irou fen, iron, ‘Õ aya bun wareg walen anĩ kel wana!’ ");
INSERT INTO dad_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“In kabĩ tura kubũ ye, ibor bobou fe fen, igonen, ‘Õ aya nigin waũ unois fen, sain wana len, aya wareg anĩ mala kela afonõf.’ ");
INSERT INTO dad_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Anĩ ere, ĩ to karĩ fiyen. Ĩ tamo yale irou, kalabus bun iran, are de wareg inouf anĩ dogol. ");
INSERT INTO dad_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Anĩ kabĩ tura tar tunĩ, ĩ age fen anĩ dile fen, idi waud odug sanen, anĩ nigin, dile, idi neid marau ereb age fen anĩ ganan wogõ difiyen. ");
INSERT INTO dad_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Age de di, marau tamo, kabĩ tamo anĩ iweignẽ isi di, ĩ irokenen, ‘Õ kabĩ tamo sane. Aya ogon wareg ganan lai afonon, ere nigin, õ aya ugonan. ");
INSERT INTO dad_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aya õ nigin wau inan gen, õ ogon kabĩ tura nigin waũ inõya san de?’ ");
INSERT INTO dad_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","In marau tamo name ise fen, darau ifenẽya nigin kalabus lo fiya tamo imeid bun inenen, are de wareg ganan inouf anĩ dogol. ");
INSERT INTO dad_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Age fiya bagai, neu Dei saa ilun ibodok, ã atun tureĩ tar neid mosor nigin wauĩ bun wedereĩ to tu kalauf are, ãg age yeĩf.” ");
INSERT INTO dad_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus od enidi wogõ ye bure fel fen, Galili distrik itor ken, Judia distrik ilen, Jordan naan sitakã. ");
INSERT INTO dad_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tamo kayau musei dõ difiyẽ di, ĩ an idi dagi el fedin. ");
INSERT INTO dad_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisia tamo tunĩ ĩ wagen disi, kisi difiye ken, idi to difiyen, “Tamo taka, yogon kayau gariya fire fire bun iruf anĩ, lo dõ fiya de?” ");
INSERT INTO dad_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus aitedin yalen, “Ã Negur nẽ Itotoya to uweseg ulegen de? Gariya bun, Negur ereb ereb kare fedin ĩ, ‘tamo ino kayau ino fen,’ ");
INSERT INTO dad_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Negur iron, ‘Anĩ nigin, tamo ĩ in sina tama itorneĩd fen, in kayau ado bagu difouf, idi uruwom bouweid tekelei.’ ");
INSERT INTO dad_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Age difef, idi uru sã, idi tekelei. Anĩ nigin, Negur tamo kayau ado bagu fedin anĩ, tamom to fara fouf.” ");
INSERT INTO dad_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Idi to difiyen, “Age fiyauf are, ere nigin Moses iron, tamo taka in kayau fara fiya nẽ pepa ifen ken, iru di, ilauf yen?” ");
INSERT INTO dad_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus idi irokenẽdin, “Moses ĩ ãgenei wauĩ totol anĩ ile fen, ãgenei kayau iruya nigin to katũ yein. Anĩ ere, gariya bun age fiya sã. ");
INSERT INTO dad_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aya ã arokeneik, aib taka in kayau seseirã inoya sã mog, kayau iru fen, kayau taka yalef are, ĩ seseirã inof.” ");
INSERT INTO dad_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","In dõ fiya tar Jesus dirokenen, “Tamo kayau atun morõ agef yenek nigin, ĩ kayau to yalouf are biya bagai.” ");
INSERT INTO dad_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus irokenẽdin, “Tamo ganan od enĩ dõ fiya kisi feleya sã, teke tekeleim Negurem age fedif anidi dogol. ");
INSERT INTO dad_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tunĩ idi, sineid namenem, bouweid kesu irouya nigin tutuk sã gõ fedidig, tunĩ are tamom korõ difedidig, tunĩ saa tano nigin kisi de fen, kayau to daledig. Tamo taka kisi enĩ dõ fiya nigin kisi falauf, dõf age fouf.” ");
INSERT INTO dad_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jesus ima tetedin ino fen, kosẽ fiyẽdiyouf nigin, kesu nanaal ĩ wagen guri de dirousin. Anĩ ere, in dõ fiya tar, idi guri de dirousin anidi ou difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus iron, “Utornẽdig len, kesu nanaal aya wageun disiyouf, idi to katũ wedig, ere nigin, saa tano are eig fediya neid.” ");
INSERT INTO dad_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Age ye fen, ĩ ima tetedin inol fen, an tamal tokõ fel ilen. ");
INSERT INTO dad_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tamo taka Jesus wagen isi to fiyen, “Tise, ere biya anĩ aya age afe fen, mata ibodkeleya alouf?” ");
INSERT INTO dad_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus aiten yalen, “Õ ere nigin ereb biya nigin aya to wiyaf? Tekelei ĩ dogol biya. Mata ibodkeleya bun ulau fenẽ, õ ĩtãfiya dõ woid.” ");
INSERT INTO dad_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tamo Jesus irokenen, “Ĩtãfiya nanĩ bagai?” Jesus iron, “‘Õ tamo taka to ukesiyouf, seseirã to unouf, to bẽ walouf, õ taka nigin idegẽya od to urõf, ");
INSERT INTO dad_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ogon sinã tamã yeneid walesauf, õ ogo nigin waũ laa fef gen, nẽ tã nigineg ago.’ ” ");
INSERT INTO dad_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tamo gaũ iron, “Anĩ ganan aya dõ afen, ere taka anĩ aya fau dõ fiya sã?” ");
INSERT INTO dad_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus ĩ irokenen, “Õ madur bagai you fenẽf, ule, ogon safina ganan na nigin sur wo fen, maleg tamo wenẽdiyouf, agouf, õ saa ilun safina biya adouf. Agol fen, usi, aya dõ wiya.” ");
INSERT INTO dad_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Od enĩ tamo gaũ karĩ ye fen, ĩ wau morõ fe di, itor ilen, ere nigin, ĩ safina musei ado. ");
INSERT INTO dad_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Age fe di, Jesus in dõ fiya tar irokenẽdin, “Aya ã momoi arokeneik, safina musei ado tamo, saa tanon ileya nigin malai bagai. ");
INSERT INTO dad_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Baban aya ã arokeneik, kamel ĩ gabar iwaya nẽ nil ku bun ileya nigin karika bagai, safina musei ado tamo, Negur nẽ tano bun ileya nigin malai bagai.” ");
INSERT INTO dad_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Od enĩ in dõ fiya tar karĩ den, idi fatuk terẽ de fen, to difen, “Age fiyauf are, aim anĩ mata ibodkeleya yaleya kisi feleya?” ");
INSERT INTO dad_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus idi lo feid fen, iron, “Tamo yogo bun age fiya kisi feleya sã, anĩ ere, Negur yogo bun ereb ereb ganan age fiya kisi feleya.” ");
INSERT INTO dad_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita Jesus aiten yalen, “Amã ereb ereb ganan mator ken, õ dõ mayok! Ere anĩ amã nemã mala solo malouf?” ");
INSERT INTO dad_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus idi irokenẽdin, “Aya ã momoi arokeneik, ereb ereb ganan mata falei fouf sain anĩ bun, Tamo Naal ĩ yogon king nẽ sia bun fula fiya medeĩya ado ibodõf, ã aya dõ wiyagef, ãg king nẽ sia tuwelf bun ubodõg fen, Israel ibor tuwelf es wedigouf. ");
INSERT INTO dad_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Taka fõ be, tura tar be, main tar be, tama, sina, gere tar, kabĩ, aya yanau nigin itoron, idi ganan mala solo wan handred wal fiya dalouf, mata faimud ibodkeleya anĩ dalouf. ");
INSERT INTO dad_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Anĩ ere, musei malabag dibodok, idi dumen dibodõf, musei dumen dibodok, idi malabag dibodõf. ");
INSERT INTO dad_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Saa tano nẽ tobonunã are, teneub marau taka ĩ, bonimei bagai ile fen, yogon wain kabier kabĩ dalouf nigin tamo oroi yaledin age fiya gen. ");
INSERT INTO dad_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kabĩ marau naa tekelei nigin ten kina afeneĩf ye di, idi ganan anĩ yo de di, in wain kabier sur fedin. ");
INSERT INTO dad_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nain kilok bonimei age fiya, ĩ ilen, tamo tunĩ maket modoũ bun ege difar mog, iledin. ");
INSERT INTO dad_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ĩ idi irokenẽdin, ‘Ãg uleg, neu wain kabier kabĩ waleg, ago gouf, mala de afeneĩf.’ ");
INSERT INTO dad_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Age ye di, idi dilen. “Ĩ baban gaa atun ado aragau tri kilok age fiya ile feneg, de age fen. ");
INSERT INTO dad_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aragau faif kilok age fiya, ĩ ilen, tunĩg fau difar mog, iledin. Ĩ idi to fiyẽdin, ‘Ere nigin ã ege bagai gaa ganan ein ufaregel?’ ");
INSERT INTO dad_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Idi aiten dalen, ‘Ere nigin, taka nem amã to oroi yalemam.’ “Ĩ idi irokenẽdin, ‘Ãg uleg, neu wain kabier kabĩ waleg.’ ");
INSERT INTO dad_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Sain aragau di, wain kabĩ marau in kabĩ tamo neid orowa irokenen, ‘Kabĩ tamo uweigneĩd fen, dogo neid mala wenẽdiyouf, dumen disil idi bun gariya uno fen, ule, uyu disil bun ouf.’ ");
INSERT INTO dad_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kabĩ tamo aragau faif kilok age fiya kabĩ dalen disi fen, mugu mugu ten kina dalen. ");
INSERT INTO dad_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sain idi bonimei nem ket iweignẽdin anidi disin, idi kisi difen, amã idi wal fiya malouf den, anĩ ere, idig mugu mugu ten kina dalen. ");
INSERT INTO dad_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sain idi moni dalel fen, idi teneub marau nigin nauseir den. ");
INSERT INTO dad_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Idi diron, ‘Tamo enidi dum bagai uweignẽdi di, aua tekelei dogol kabĩ dalel, anĩ ere, amã, naa enĩ ganan bonimei nem isi, gama yeiref, kabĩ totol malel, gaa uruwa dõ famam, anĩ ere, õ amã idi geid ten kina dede wanamam.’ ");
INSERT INTO dad_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Anĩ ere, kabĩ marau ĩ, idi neid taka solof irokenen, ‘Mou, aya õ sane to ayok. Õ ten kina nigin ada uruwom sigoroda to tekeleil de? ");
INSERT INTO dad_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ogon kabĩ mala wale fen, ule. Aya õ afonom age fiya, tamo dum bagai oroi aleyen anĩ, de age fiya afenẽf nigin wau irok. ");
INSERT INTO dad_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Aya neu safina ereb taka age fiya nigin wau irok anĩ, aya to age afouf de? Aya neu biya age afef nigin, õ aya kiyeĩ wanaf de?’ ");
INSERT INTO dad_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Anĩ nigin, idi dumen dibodok anidi malabag dibodõf, idi malabag dibodok anidi dumen dibodõf.” ");
INSERT INTO dad_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus Jerusalem iselau fenẽ, ĩ in dõ fiya tar tuwelf mugu bagai gei feid fen, irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ada Jerusalem teselef, an Tamo Naal ĩ pris odudug, lo ifelnẽdiya tamo imeid bun dinenẽf. Idi ĩ laa fouf nigin bou bun od dũf. ");
INSERT INTO dad_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Age de fen, idi ĩ haiden Juda sã anidi imeid bun dino di, kono difiyẽ, wagĩ difiye ken, aa tetek bun dukesiyouf. Naa towo bun, ĩ mata kel fã youf!” ");
INSERT INTO dad_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Age fe di, Sebedi nẽ kesu uru, sineid geid Jesus wagen disin. Idi neid sineid ibor bobou fe fen, wau irok anĩ Jesus to fiyen. ");
INSERT INTO dad_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus to fiyen, “Ere anĩ õ orok?” Kayau iron, “Õ urõf, neu kesu uru enĩ, ogon tano bun taka ima biyalẽ ibodõf, taka ima kilẽ ibodõf.” ");
INSERT INTO dad_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus idi irokenẽdin, “Ã ereb to gef anĩ nẽ gariya, ã keleĩ sã, naan aya ãf anĩ ã yõya kisi feleya de?” Idi aiten dalen, “Amã kisi feleya.” ");
INSERT INTO dad_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus idi irokenẽdin, “Ã momoi neu kap bun naan are wãgauf, anĩ ere, imau biyalẽ ibodõya be, kilẽ ibodõya are, ayam ifenẽya kisi feleya sã. Modoũ anidi are, neu Dei idi nigin dodok fen anidi neid.” ");
INSERT INTO dad_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","In dõ fiya tar ten, od anĩ karĩ de fen, uru tura ado nigin seye den. ");
INSERT INTO dad_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesus idi iweig laisi fen, iron, “Ã keleĩ, haiden idi dogo neid uyu irouya, tamo kayau lo fiya nigin totol dinodig, idi dogo neid odudug, tamo kayau nigin megeir yaor difedig. ");
INSERT INTO dad_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Anĩ ere, ã bun kisi to agef yenẽf, ã atun aib taka odug ibodõf nigin orof, ĩ ãgenei kabĩ tamo ibodõf. ");
INSERT INTO dad_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ã atun aib taka uyun ibodõf nigin orof, ĩ ãgenei ferfer ibodõf. ");
INSERT INTO dad_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Age fiya gen, Tamo Naal ĩ disennẽf nigin to isin, anĩ ere, ĩ tamo kayau isenneĩd fen, tamo kayau musei idi neid mosor anĩ fotokar yogon mata ifenẽdiyouf nigin isin.” ");
INSERT INTO dad_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesus in dõ fiya tar geid Jeriko ditor dile mog, tamo kayau musei dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tamo uru meleid ifofakelen naab yerin dibodon. Sain idi Jesus isi ilef yeya karĩ de fen, diweig diron, “Odug, Dawid Naal, amã nigin malalon yõ!” ");
INSERT INTO dad_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tamo kayau idi ou difiyeĩd fen, foro dalauf nigin dirokenẽdin, anĩ ere, idi wade bagai diweig diron, “Odug, Dawid Naal, amã nigin malalon yõ!” ");
INSERT INTO dad_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus dẽ yel fen, idi iweigneĩd fen, ĩ to fedin, “Ere naig ayẽif nigin ã oroyeik?” ");
INSERT INTO dad_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Idi aiten dalen, “Odug, amã malamã fara wol kanamãf nigin oromak.” ");
INSERT INTO dad_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus idi nigin meleidlon fe fen, idi meleid kobũ fedin. Kaisã bagai, idi meleid fara fele di, sã lo dife fen, idi Jesus dõ difen. ");
INSERT INTO dad_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Idi Jerusalem kelẽ difiye ken, Moul Arei bun Betfage fonõ wõ den, Jesus in dõ fiya tar uru sur feid fen, ");
INSERT INTO dad_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ĩ idi irokenẽdin, “Fonõ wagein ifaref tokõ weleg, ulõ wesig fen, kaisã bagai donki ifõya naal ado uledigouf. Idi biru weledig fen, wageun gurig usig. ");
INSERT INTO dad_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Taka nem ã ereb yeĩf, ĩ urokenẽgouf, Odug ĩ kabĩ ifenẽdiyou fenẽ orof, ago ge di, kaisã bagai sur fediyouf.” ");
INSERT INTO dad_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Profet eig ye wogõ yen anĩ kisi falauf nigin agef wõ yen: ");
INSERT INTO dad_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saion nẽ tamo kayau urokenẽgouf, ‘Ulef, ogon king õ garan isif, imatkeis fen, donki bun ibodok, donki naal teten.’” ");
INSERT INTO dad_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","In dõ fiya tar dilen, Jesus iron kilei age difen. ");
INSERT INTO dad_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Idi donki naal ado dirousi di, tetedin idi neid gabar du difedi di, Jesus anĩ tetedin ibodon. ");
INSERT INTO dad_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tamo kayau musei, idi neid gabar naabur du difedin, tunĩ idi aa were kokour dife, naabur du difedin. ");
INSERT INTO dad_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tamo kayau uyu dilen ado, dume dõ difen diweig diron, “Hosiana, Dawid Naal bun!” “Odug yana bunem isif, ĩ el fiya ado!” “Hosiana, saa ilun bagai!” ");
INSERT INTO dad_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sain Jesus Jerusalem ulõ yesi di, taun anĩ bun tamo kayau ganan terẽ de fen, toti difen, “Tamo eĩ aim?” ");
INSERT INTO dad_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tamo kayau diron, “Eĩ Jesus, profet Nasaret taun Galili teneub bun tamal.” ");
INSERT INTO dad_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus tempel modoũ bun ile, wõ ye fen, na dale dile disi dife mog, an tamo kayau adok irudidin. Ĩ moni solo fediya neid tebol ado kuburir na sur fediya neid fatar eleg feledin. ");
INSERT INTO dad_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesus idi irokenẽdin, “Negur nẽ Itotoya irok, ‘Neu fõ ĩ kosẽ nẽ fõ douf,’ anĩ ere, ã ‘bẽ tamo neid iminẽya fõ’ unogen.” ");
INSERT INTO dad_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Meleid ifofakeleya, yeid kirorõya, Jesus wagen tempel bun disi di, ĩ el fedin. ");
INSERT INTO dad_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Anĩ ere, Jesus ereb biya bagai age fe di, kesu nanaal tempel modoũ bun diweig diron, “Hosiana, Dawid Naal bun,” age de di, pris odudug, lo ifelnẽdiya tamo geid, idi anĩ dileid fen, seye den. ");
INSERT INTO dad_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Idi Jesus to difiyen, “Kesu nanaal enidi ereb def, õ karĩ wof de?” Jesus aitedin yalen, “Ariya, ã Negur nẽ Itotoya to uwesegen de? “‘Kesu momou kesu nanaal geid sigoreid bun selu kulõ fiya nigin Negur idi mogo saika fedin.’ ” ");
INSERT INTO dad_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Agef fen, Jesus an tamal idi itorneĩd, taun anĩ itor ken, Betani fonõ ilen, an bõ tekelei ibodon. ");
INSERT INTO dad_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bonimei bagai, Jesus Jerusalem kel ile fen, naab luwen naũ fen. ");
INSERT INTO dad_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mala irakelen, aa fig naab yerin ilen, Jesus iyok iselen fele fen, aa fig biya sã ege aarau dogol. Jesus aa fig irokenen, “Õ baban to bagai umauf!” Kaisã bagai, aa fig gariri kelen. ");
INSERT INTO dad_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","In dõ fiya tar anĩ dile mã, idi terẽ de kulõ de fen, diron, “Naig fe di, aa fig kaisã bagai gariri kelen?” ");
INSERT INTO dad_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus aitedin yale iron, “Aya ã momoi arokeneik, ã wauĩ momoi ge mã, wauĩ to ilef isi fouf, ã aa fig enĩ bun age afel dogol to ago gouf, sã arei enĩg urokenẽgouf, ‘Kusu fen, maaĩwõ irãyõf,’ are ĩ dõf age fouf. ");
INSERT INTO dad_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ã momoi gouf are, ereb taka nigin tog fen, kosẽ gouf, ã walogouf.” ");
INSERT INTO dad_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus tempel modoũ namen ulõ yeis fen, an tamo kayau od ifelneĩd mog, pris odudug, tamo kayau neid mudur adodo, ĩ wagen disi to difen, “Ere igirĩya bunem õ ereb ereb enĩ ago wof? Aim õ igirĩya enĩ ifonon?” ");
INSERT INTO dad_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus aitedin yale iron, “Ayag to fiya tekelei afeneĩf. Ã solog urokanagauf are, ereb igirĩya bunem ereb ereb enĩ age afef, aya ã arokeneĩf. ");
INSERT INTO dad_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon nẽ naan igunẽdin, are nainenem isin? Are saa ilun tamal de, tamo bunem?” Idi dogo dogol katõ de fen, diron, “Ada ‘Ĩ saa ilun tamal,’ tauf, ĩ irõf, ‘Ba anĩ, ere nigin ã ĩ nigin to momoi wiyẽgen?’ ");
INSERT INTO dad_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Anĩ ere, ada ‘Tamo bunem’ tauf, ada tamo kayau nigin kumĩ tafedif, ere nigin, tamo kayau idi ganan Jon nigin profet taka dedig.” ");
INSERT INTO dad_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Anĩ nigin, idi Jesus ait solo de diron, “Amã keleĩ sã.” Age de di, Jesus iron, “Ago gouf are, ayag, ere igirĩya bunem ereb ereb enĩ age afef anĩ to arokeneĩf. ");
INSERT INTO dad_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ã ere kisi gef? Tamo taka ĩ naal uru adon. Tama ĩ kesu matu garan ile iron, ‘Neu kesu, gama wain kabier ule, kabĩ walouf.’ ");
INSERT INTO dad_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ĩ aiten yalen, ‘Aya tuwauf,’ dum ĩ in kisi falei ye fen, ilen. ");
INSERT INTO dad_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Agef fen, tama kesu taka garan ile, od tekelei anĩ irokenen. Kesu aiten yalen, ‘Dei, aya age afouf,’ anĩ ere, ĩ ileya sã. ");
INSERT INTO dad_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Idi uru atun, aim anĩ tama oron anĩ age fen?” Idi aiten dalen, “Matum.” Jesus idi irokenẽdin, “Aya ã momoi arokeneik, takis yaleya tamo, kayau bouweid na nẽ sur difedig geid, ã atun, idi ketem Negur nẽ tano bun uyu dilauf. ");
INSERT INTO dad_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ere nigin, Jon naan igunẽdiya tamo ĩ, madur ibodõya nẽ naab ifelneĩf nigin ã garan isin, ã ĩ nigin to momoi gen, anĩ ere, takis yaleya tamo, kayau bouweid na nẽ sur difedig geid, idi momoi den. Ã ĩ ulegeneg, ã wauĩ to falei ge fen, ĩ to momoi wiyẽgen. ");
INSERT INTO dad_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Yaab od taka nigin wedereĩ unog. Teneub marau taka ĩ yogon kabier aa wain itenen, ĩ kau ifõ kalĩ felen, wain sumin asi fiya nigin ku yalen, kabĩ lo fiya nẽ fõ inon. Agef fen, ĩ mala solo yalouf nigin wain kabĩ, kabĩ lo difedig tamo tunĩ imeid bun ino fen, uyu takã ilen. ");
INSERT INTO dad_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sain biya bure fele di, teneub marau wain biya fito fiya nigin in ferfer susur fe di, kabĩ lo difedig tamo garan dilen. ");
INSERT INTO dad_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Kabĩ lo difedig tamo, teneub marau nẽ ferfer dirouneĩd fen, taka dun, taka dukesin, taka meein tulu difen. ");
INSERT INTO dad_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Age dife di, teneub marau ferfer tunĩ sur fedin, are idi musei uyulil sur fedin wal fiya. Age fe di, kabĩ lo difedig tamo uruwa age difen gen, baban yogon ferfer bun age difedin. ");
INSERT INTO dad_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dum bagai, teneub marau yogon naal idi garan sur fiyen. Ĩ iron, ‘Idi neu kesu nigin fau karĩ difiyẽf.’ ");
INSERT INTO dad_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Anĩ ere, kabĩ lo difedig tamo, naal anĩ dile fen, idi abob dirokenen, ‘Eĩ inim wain kabĩ akorouf. Usig, ada ĩ taukeis fen, yogon akor talouf.’ ");
INSERT INTO dad_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Age de fen, idi ĩ dale, wain kabĩ mayarẽ dira ken, dukesin. ");
INSERT INTO dad_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Age fiya nigin, sain wain kabĩ nẽ marau isiyouf, ĩ kabĩ lo difedig tamo ere naig fediyouf?” ");
INSERT INTO dad_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Idi Jesus aiten dalen, “Teneub marau, idi sane bagai sane ye fen, idenkesiyouf, ĩ wain kabĩ anĩ, kabĩ lo difedig tamo tunĩ imeid bun ino fen, na yaledi di, idi wain mayof sain bun fito de fen, yogon biya difenẽf.” ");
INSERT INTO dad_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus idi irokenẽdin, “Ã od Negur nẽ Itotoya bun yenek anĩ to uwesegen de? “‘Meein are fõ inoya tamom sane de fen, ditoron anĩ, gama monog tor wõ yen, anĩ Odug yogo age fe di, malamã yun.’ ");
INSERT INTO dad_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Anĩ nigin, aya ã arokeneik, Negur nẽ tano ã bun tamal son yeĩ yale, tamo kayau idi aayũ faat biya yũf anidi ifenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aib taka meein anĩ teten kubũ youf, mered fe fisik fouf, takag, aib taka meein anĩ ĩ teten kubũ youf, ĩ danĩf aas lauf.” ");
INSERT INTO dad_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sain pris odudug, Farisia tamo geid, Jesus nẽ yaab od karĩ den, idi kelein, Jesus idi nigin wogõ yen. ");
INSERT INTO dad_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Idi Jesus irounẽya nigin naab dimiren, anĩ ere, idi tamo kayau nigin kumĩ den, ere nigin, tamo kayau idi Jesus nigin profet taka dedig. ");
INSERT INTO dad_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus yaab od nem baban irokeneĩd fen, iron: ");
INSERT INTO dad_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Saa tano ĩ, king taka, ĩ naal kayau yalouf nigin tar dodok fen age fiya gen. ");
INSERT INTO dad_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ĩ yogon ferfer sur fedi di, tamo iweignẽdin yogon tar bun disiyouf nigin dirokenẽdin, anĩ ere, idi isiya ditoron. ");
INSERT INTO dad_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ĩ baban ferfer tunĩ sur feid fen, iron, ‘Idi aya aweignẽdin anĩ urokenẽdig: Aya tar mogo saika afel. Aya bulmakau yaro biya biya ado adenen, ereb ereb ganan mogo dodok afelel. Bagu fiya tar bun usig.’ ");
INSERT INTO dad_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Anĩ ere, idi to karĩ difiyẽdin, idi diyalelen, taka yogon kabier ilen, taka ĩ yogon bisnis kabĩ yalen. ");
INSERT INTO dad_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tunĩ idi ferfer dirouneĩd fen, tadũ difiyeĩd didenkesin. ");
INSERT INTO dad_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Anĩ nigin, king name odug sane fen, yogon kusĩ tamo sur fedi di, dilen, ferfer didenen anidi didenkeis fen, nedi taun yã dinon. ");
INSERT INTO dad_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Agef fen, king, ne ferfer irokenẽdin, ‘Bagu fiya nẽ tar mogo dodok afelel, aya tamo aweigneĩd fen, naa afenẽdin anidi, dogo sane age difen nigin, isiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Anĩ nigin, ã ulagauf, naab kaleyan aib aib uledigouf are, urokenẽdig len, idi tar bun disiyouf.’ ");
INSERT INTO dad_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Age ye di, ferfer dilelen, naab naab diyo ken, tamo kayau dileid fen, biya ado sane ganan gou difedin, age dife di, tamo kayau ado bagu difedidig nẽ guru fiya modoũ bun tamo kayau isokosen. ");
INSERT INTO dad_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Age dife di, king namen isin, tamo kayau fele fedin, an ĩ tamo taka kolos biya ifonũya sã fotou fen. ");
INSERT INTO dad_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","King ĩ to fiyen, ‘Mou, naig fe di, õ bagu fiya nẽ naki sã anĩ guru fiya enĩ namen usil?’ Tamo ĩ od sã ibodon. ");
INSERT INTO dad_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Age fe di, king yogon kabĩ tamo irokenẽdin, ‘Ima ye ado ufõg, mayarẽ gugum bun urãg, an are wifirig ye fen, gobora kikokõ yediyouf.’ ");
INSERT INTO dad_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Anĩ nigin, tamo kayau musei iweignẽdif, anĩ ere, teke tekelei igirnẽdif.” ");
INSERT INTO dad_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Age fe di, Farisia tamo dilen, Jesus in od bun naig fe mog, talouf de fen, od katõ difen. ");
INSERT INTO dad_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Age de fen, Farisia tamo, idi neid dõ fiya tar, Herod nẽ tamo tar geid, Jesus wagen sur difedi di, dilen, idi Jesus dirokenen, “Tise, amã keleĩ, õ momoi wogõya nẽ tamo, anĩ õ Negur nẽ naab momoi bagai ufelnẽdidig, õ tamom to wewu diyõdig, ere nigin, õ idi yana ado be sã anĩ to es wedig. ");
INSERT INTO dad_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Anĩ amã urokanamã, ogon kisi ere wof? Sisa takis ifenẽya nigin biya de, sã?” ");
INSERT INTO dad_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Anĩ ere, Jesus idi neid namedin kisi sane kelei ken, iron, “Ã meleid yaleya tamo, ere nigin ã aya kisi wiyagef? ");
INSERT INTO dad_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis ifenẽya nigin koin moni ufelnag.” Idi koin moni taka wagen diroule di, ");
INSERT INTO dad_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesus idi to fedin, “Eĩ ai nawa nẽ malakanon? Eĩ ai yana nẽ itotoya?” ");
INSERT INTO dad_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Idi aiten dalen, “Sisa nẽ.” Age de di, ĩ idi irokenẽdin, “Ereb Sisa nẽ are Sisa wenẽg, ereb Negur nẽ are Negur wenẽg.” ");
INSERT INTO dad_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Od enĩ idi karĩ de fen, terẽ den. Age de fen, idi Jesus ditornẽ diya dilelen. ");
INSERT INTO dad_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Naa de tekelei anĩ bun, Sadusia tamo idi dirõdig anĩ, laa bun tamal to ke de fã dedig, dedig anidim, Jesus wagen disi to difiyen. ");
INSERT INTO dad_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Idi diron, “Tise, Moses iron, tamo taka kesu sã mog laa fef, in tura waab yale fen, tura fotokar kesu iroukenẽf. ");
INSERT INTO dad_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Amã atun, tura tura sewen dibodon. Matu ĩ kayau yalen laa fen, ĩ kesu sã, anĩ nigin, ĩ, in kayau, ne tura itorkenen. ");
INSERT INTO dad_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Age fiya bagai, tura dõ fiya ĩg age fen, anĩ dõ fiya tri ĩg agef ile sewen adoken. ");
INSERT INTO dad_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Idikeleya bun, kayau ĩg laa fen. ");
INSERT INTO dad_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Anĩ nigin, kel fãya bun, idi sewen anĩ atun, ĩ ai nẽ kayau bagai ibodõf? Ere nigin, idi ganan kayau anĩ dalen.” ");
INSERT INTO dad_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus aitedin yale irokenẽdin, “Ã od kũ wenẽgef, ere nigin, ã Negur nẽ Itotoya ado Negur nẽ megeir keleĩ sã. ");
INSERT INTO dad_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Laa bun tamal kel fãya bun, an tamo kayau ado abob yalef ya sã, idi engel saa ilun difaref gen dibodõf. ");
INSERT INTO dad_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Anĩ ere, laa bun tamal kel fãya nigin, Negur ã irokenein anĩ, ã to uwesegen de? ");
INSERT INTO dad_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Negur iron, ‘Aya Abraham nẽ Negur, Isak nẽ Negur, Jakop nẽ Negur.’ Ĩ laa neid Negur sã, ĩ mata ibodõya neid Negur.” ");
INSERT INTO dad_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Anĩ tamo kayau od enĩ karĩ de fen, ĩ agef ifelnẽdin anĩ nigin terẽ den. ");
INSERT INTO dad_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesus ĩ Sadusia tamo od bun sigoreid ifokelen anĩ karĩ de fen, Farisia tamo idi guru difen. ");
INSERT INTO dad_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Idi atun, lo keleĩ tamo takam Jesus kisi fiye ken, eig fiyẽ to fiyen, ");
INSERT INTO dad_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tise, ĩtãfiya nanĩ anĩ, ganan wal fiya odug bagai Lo bun irok?” ");
INSERT INTO dad_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus irokenen, “‘Õ, Odug ogon Negur waũ adok, malãkanon adok, kisi adok bunem, ĩ nigin waũ laaf.’ ");
INSERT INTO dad_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ĩtãfiya enĩ ĩ matu, Lo bun ganan wal fiya odug bagai irok. ");
INSERT INTO dad_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Anĩ dõ fiya are eig fiya, ‘Õ ogo nigin waũ laa fef gen, nẽ tã nigineg ago waũ laaf.’ ");
INSERT INTO dad_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lo ado Profet neid od ganan, ĩtãfiya uru enĩ teten difaref.” ");
INSERT INTO dad_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sain Farisia tamo idi guru difesi di, Jesus idi to fedin, ");
INSERT INTO dad_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kristus nigin ã kisi ai gef? Ai nẽ naal anĩ Kristus?” Idi aiten dalen, “Dawid naal.” ");
INSERT INTO dad_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus idi irokenẽdin, “Dawid naig fe di, anĩ Awa Uurem irokenen, ĩ nigin ‘Odug’ yen?” Ĩ nigin Dawid iron, ");
INSERT INTO dad_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Negur neu Odug irokenen: “Imau biya melem ubod mog, ogon kiwai tar on yẽ farume gõ afalauf.” ’ ");
INSERT INTO dad_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dawid ĩ nigin ‘Odug’ yen ouf are, naig fe di, Kristus ĩ Dawid naal ouf?” ");
INSERT INTO dad_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Taka nem, ĩ aiten yale solof irõya kisi feleya san, naa anĩ bunem ilen ganan, takam baban ĩ to fiyẽya nigin kumĩ den. ");
INSERT INTO dad_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dum Jesus, tamo kayau in dõ fiya tar geid irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lo ifelnẽdiya tamo, Farisia tamo geid, Moses nẽ sia bun dibodõdig. ");
INSERT INTO dad_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Anĩ nigin, ã idi karĩ wiyẽdig fen, ereb idi ã ago gei de di, ã ago gouf. Anĩ ere, ereb idi age difef anĩ, ã to agog, ere nigin, idi dirõdig anĩ to dõ de age difedig. ");
INSERT INTO dad_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Idi morõ odudug difofa ken, tamo kayau oroweid se difedig, anĩ ere, idi dogo bagai, morõ enei dalesauf nigin imeid gege tekelei bagai gebeya nigin to orodidig. ");
INSERT INTO dad_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Idi ereb ereb ganan age difedig, are ege tamo meleid yaleya: Age de fen, idi tamo meleid yaleya nigin, lo ĩtãfiya bokis naal odudug nuwa bun difeid fen, demeid bun ado imeid dã bun difofãdig, idi neid kolos nẽ malũ meluluk adodo dinodidig. ");
INSERT INTO dad_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Idi, saaf odudug bun ado Juda neid uub fõ bun, modoũ malabag ibodõya anĩ orodidig. ");
INSERT INTO dad_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Idi maket modoũ bun, tamo kayau idim sere difiyeĩd fen, ‘O tise’ difediyouf anĩ orodidig. ");
INSERT INTO dad_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Anĩ ere, ã tise to diyeĩf, ere nigin, ã Tise tekelei dogol ado, ã adok tura tura. ");
INSERT INTO dad_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ã tenebur ein aib taka to dei gouf, ere nigin, ã Temeĩ tekelei dogol ado, ĩ saa ilun ibodok. ");
INSERT INTO dad_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ã mudur ado to diyeĩf, ere nigin, ã Mudur Ado tekelei dogol, are Kristus. ");
INSERT INTO dad_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ã atun, aib taka ganan wal fiya wõ you fenẽ, ĩ ãgenei kabĩ tamo ibodõf. ");
INSERT INTO dad_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ere nigin, aib taka ĩ yogo yana yalesef, ĩ lai fesilauf, aib taka ĩ yogo nigin lai fesilauf, ĩ yana adouf. ");
INSERT INTO dad_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Lo ifelnẽdiya tamo, Farisia tamo geid, ã meleid yaleya tamo, ã nigin meleĩlon ado! Ã tamo kayau meleid bun saa tano nigin sukar unogedig. Ã aug namen to ulegedig, idi dilau fenẽ age difef, ã katĩ welegedig. ");
INSERT INTO dad_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Lo ifelnẽdiya tamo, Farisia tamo geid, ã meleid yaleya tamo, ã nigin meleĩlon ado! Ã, tamo tekelei waleg fen, ĩ ãgenei dõ fiya unenẽgouf nigin, teneub bun uyokeleg fen, maaĩ naab bun uyõgefeg ago gedig, agog fen, tamo ĩ anĩ ufelnẽge di, ĩ ãgenei dõ fiya wõ yef are, ĩ ã hel nẽ gere tar ubodõgef wal yeĩya sane bagai wõ yef. ");
INSERT INTO dad_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mala ifofakeleya uyu irouya, ã nigin meleĩlon ado! Ã urõgedig, ‘Aib taka tempel yana bunem in od isen ken, totol od irok, are ege, anĩ ere, aib taka tempel nẽ gol bunem in od isen ken, totol od irok, ĩ dõf age fouf.’ ");
INSERT INTO dad_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ã neneya, meleĩ ifofakeleya! Ere anĩ odug, gol de, oo tempel gol fateul ifenẽdig anĩ? ");
INSERT INTO dad_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Takag ã urõgedig, ‘Aib taka alta yana nem in od isen ken, totol od irok, are ege, anĩ ere, aib taka sesewi fiya nẽ safina alta bun ifaref anĩ yana nem in od isen ken, totol od irok, ĩ dõf age fouf.’ ");
INSERT INTO dad_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ã, mala ifofakeleya tamo! Ere anĩ odug, safina de, oo alta sesewi fiya fateul ifenẽdig anĩ? ");
INSERT INTO dad_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Anĩ nigin, aib taka alta yana nem in od isen ken, totol od irok, ĩ alta ado safina ganan alta teten ifaref anim in od isen ken, totol od irok. ");
INSERT INTO dad_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Taka ĩ tempel yana nem in od isen ken, totol od irok, ĩ tempel ado, Negur tempel namen ibodok anim in od isen ken, totol od irok. ");
INSERT INTO dad_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Taka ĩ saa yana nem in od isen ken, totol od irok, ĩ Negur nẽ king sia ado, Negur ĩ an ibodok anim in od isen ken, totol od irok. ");
INSERT INTO dad_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Lo ifelnẽdiya tamo, Farisia tamo geid, ã meleid yaleya tamo, ã nigin meleĩlon ado! Ã kabier tamal sako nanaaleg farag fen, ten tekelei unogedig, anĩ ere, ã, lo nẽ odug, are safina wal fiya anidi nigin to kisi gedig, are lo nẽ madur fiya, wau ifenẽya, wau momoiya. Ã anĩ adok to tai gedig. Ã teten nẽ anĩ dõg fen, dum nẽ anĩg tai gem, are dem. ");
INSERT INTO dad_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ã, mala ifofakeleya uyu irouya! Ã soloulã tar bun ibodok anĩ ulul nem yaleleya nigin kous gedig, anĩ ere, ã kamel tar bun ibodok anĩ utobogedig. ");
INSERT INTO dad_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Lo ifelnẽdiya tamo, Farisia tamo geid, ã meleid yaleya tamo, ã nigin meleĩlon ado! Ã kap beĩ ado agara anĩ kulo gedig, anĩ ere, name bun amuyẽ isokos fen, taka nẽ safina yaleya nigin imeĩ su lai ge fen fe tetenem yaleya ado, akorou yeya aug naumeĩ nigin dogol yenek. ");
INSERT INTO dad_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisia tamo, mala ifofakeleya! Kap beĩ ado name ket kulo wedig, ago ge di, teteneg fili youf. ");
INSERT INTO dad_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Lo ifelnẽdiya tamo, Farisia tamo geid, ã meleid yaleya tamo, ã nigin meleĩlon ado! Ã aau lalau nem matmat sigor naki fiya gen, teten lo fiya nigin biya bagai, namen anĩ are tamo gare den tuweid ado ereb ereb ganan amuyẽ isokosen. ");
INSERT INTO dad_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Age fiya bagai, ãg teten tamo kayau meleid bun madur tamo gen ubodõgedig, anĩ ere, nameneĩ mala yaleya ado sane bagai isokosen. ");
INSERT INTO dad_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Lo ifelnẽdiya tamo, Farisia tamo geid, ã meleid yaleya tamo, ã nigin meleĩlon ado! Ã profet neid matmat unog fen, madur tamo neid matmat garab wiyẽgedig. ");
INSERT INTO dad_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ã urõgedig, ‘Ada tubuda tar dibodon sain bun, ada tabodom are, ada idi geid to bagu tafem, profet naudeid to filu fadam.’ ");
INSERT INTO dad_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Anĩ nigin, ã aug nigin yaor gef, ere nigin, ã idi profet didenkesin anidi neid ibor tar. ");
INSERT INTO dad_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ãgenei tubuĩ tar neid mosor tobol ge di, isokosef! ");
INSERT INTO dad_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ã gogour bagai! Ã gogour sane gere tar! Ã naig ge fen, hel nẽ es fiyauf bun tamal uyagauf? ");
INSERT INTO dad_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Age fiya nigin, aya, profet, keleĩ biya tamo, tise ado ã bun sur afediyouf. Idi tunĩ udenkesigouf, tunĩ aa tetek bun udenẽdigouf, tunĩ ãgenei uub fõ bun wagagã gouf, fonõ fonõ idi darau wenẽdig fen, urudigouf. ");
INSERT INTO dad_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Anĩ nigin, madur tamo Abel nẽ naud bun ile, Sekaraia Berekia naal, ĩ tempel alta ado atun ã ukesigen, in naud bun, madur tamo neid naudeid ganan teneub enĩ iroun nigin, anĩ nẽ mala solo sane ã bun isiyouf. ");
INSERT INTO dad_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aya ã momoi arokeneik, mala solo kafĩ fiya enĩ ganan, tamo kayau sain enei bun dibodok anidi bun isiyouf. ");
INSERT INTO dad_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem, õ profet udenkeis fen, õ bun sur fedig anidi meein meein wedidig, sain musei aya õ wau afon ken, ogon gerẽ tar kuru afedig, tataro sina momou waye farumen kuru fedig gen, anĩ ere, ã utorõgedig. ");
INSERT INTO dad_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ulogouf, ãgenei fõ fonou lef. ");
INSERT INTO dad_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Anĩ nigin, aya ã arokeneik, ã aya baban to uleyagauf ile, ã fau urõgouf, ‘Odug yana bunem isif, ĩ el fiya ado,’ sain anĩ bun, ã aya uleyagauf.” ");
INSERT INTO dad_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus tempel bun tamal kutũ yeis, iyok ile mog, in dõ fiya tar Jesus wagen disin, tempel fõ tunĩ anĩ difelnen. ");
INSERT INTO dad_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus to fedin, “Ã enĩ ganan ulegef de? Aya ã momoi arokeneik, meein enĩ taka, meein tura teten to yenẽf, anĩ adok fau isog irailauf.” ");
INSERT INTO dad_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus Moul Arein ibod mog, in dõ fiya tar mugun wagen disin dirokenen, “Urokanamã, ere sain enĩ wõ youf? Ere uris bagai anĩ, on isiya nẽ ado idikeleya nẽ?” ");
INSERT INTO dad_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus aitedin yalen, “Takam to idegneĩf nigin lo weleg. ");
INSERT INTO dad_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ere nigin, musei aya yanau nem disi dirõf, ‘Aya Kristus,’ age de fen, idi tamo kayau musei didegnẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ã kusĩ wõya karĩg fen, tamo sigoredim kusĩ nigin wogõ douf anĩ karĩ gouf, ã anĩ nigin to terẽ gei. Ereb ereb anĩ agef wõ youf, anĩ ere, idikeleya sain fau dum isiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Teneub taka fã ye fen, ĩ teneub taka nigin kiwai ifenẽf, tano taka ĩ tano taka nigin kiwai ifenẽf. Naũ odug mimĩ ado, uyu taka taka bun wõ youf. ");
INSERT INTO dad_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Enei ganan, kayau kesu ibodõf nigin darau gariya inof gen. ");
INSERT INTO dad_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sain age fouf bun, ã idi imeid bun ulagauf, darau odug laa bun dineneĩf, teneub ganan bun tamo kayau ã nigin to orodiyouf, ere nigin, aya yanau ã ado nigin. ");
INSERT INTO dad_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sain anĩ bun, musei momoiya dudum difouf, idi dogo tutur abob kiwai difenẽf, idi abob to orodiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Agef mog, idegẽya profet musei wowã douf, idi tamo kayau musei didegnẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tobonunã sane anĩ fou yalauf nigin, tamo kayau musei wau laa fiya nigin folo rouf. ");
INSERT INTO dad_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Anĩ ere, aib taka ĩ megeir ifar ile, idikeleya bun, Negur ĩ isennẽf. ");
INSERT INTO dad_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Saa tano nẽ biya od enĩ wogõ difediyouf anim, teneub ganan bun tamo kayau wedereid irou fen, uris gen ifenẽdiyouf, anĩ gama idikeleya isiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Sain ã log mog, ninir fonou inenẽf, are profet Daniel sigor bun wogõ yen anĩ, Jerusalem fateul modoũ bun ifarauf are (ani uweseg keleĩ youf), ");
INSERT INTO dad_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","idi Judia teneub bun dibodok, arein diya diselauf. ");
INSERT INTO dad_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Taka ĩ yogon fõ sokor ibodok, ĩ to kel isil, aaben ereb ereb gei fouf. ");
INSERT INTO dad_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Taka ĩ kabier ibodok, yogon gabar yalouf nigin to kel ilauf. ");
INSERT INTO dad_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Naa anĩ bun, kayau bouweid ado, kayau kesu su ifenek ado, idi meleidlon adouf. ");
INSERT INTO dad_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Feluk sain Sabat naa bun ado, ã to uyagauf nigin Negur kosẽ gouf. ");
INSERT INTO dad_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sain anĩ bun, morõ odug biya isiyouf, morõ age fiya gariya bun teneub inon isi gama, taka to wõ yen, dum buneg taka to wõ youf. ");
INSERT INTO dad_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Negurem naa anĩ to godo falaisim are, taka to mata ibodom, tamo kayau igirnẽdin idi nigin ye fen, naa anĩ godo falaisiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sain anĩ bun, taka ã irokeneĩf, ‘Ulegef, Kristus yeir!’ oo ‘Ĩ your!’ ã anĩ to momoi ge. ");
INSERT INTO dad_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Fau idegẽya Kristus, idegẽya profet ado wõ de fen, idi kisi falauf are, Negur igirnẽdin anidig didegnẽdiyouf nigin uris odug memelik ado difelnẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Karĩg, aya tetunem ã arokenein. ");
INSERT INTO dad_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Anĩ nigin, takam ã irokeneĩf, ‘Kristus ĩ your, gerere tuan,’ ã to ulagauf, ‘Kristus ĩ yeir, aab namen,’ ã anĩ to momoi ge. ");
INSERT INTO dad_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gaa iseyanem kolimei fili ye di, ile, gaa ileyaneg iledig, age fiya bagai, Tamo Naal in isiyouf bun age fouf. ");
INSERT INTO dad_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nain be ereb bouwa buru waaif nẽ an, tum guru difouf. ");
INSERT INTO dad_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Morõ sain anĩ bure fele di, kaisã bagai “‘gaa gugum kalauf, ogõ to lalan youf, saa ilun tamal barisa kuku rediyouf, saa nẽ megeir guyoyõ douf.’ ");
INSERT INTO dad_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Sain anĩ bun, Tamo Naal nẽ uris saa bun wõ youf, teneub ganan bun tamo kayau waud gudũ fouf. Idi Tamo Naal saa lalo bun, yogon fula fiya medeĩya barikã megeir ado isi mog, dilouf. ");
INSERT INTO dad_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Agef fen, ĩ yogon engel, taur ait odug ado susur fedi di, idi, yogon tamo kayau igirnẽdin anidi, teneub akor ganan bun, saa akor ganan bun ado kuru difediyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gama ã, aa fig bun keleĩ walogouf: Susu bonuf fen, aarau inodif, ã keleĩ, saneya melsak. ");
INSERT INTO dad_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Age fiya nigin, ã anĩ ganan ulogouf are, ã keleĩ, in isiya mogo melsã, bobogẽ bagai ifaref. ");
INSERT INTO dad_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aya ã momoi arokeneik, tamo kayau sain enei nẽ idi to sa kel mog, enĩ ganan wowã youf. ");
INSERT INTO dad_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Saa teneub ado sa kalauf, anĩ ere, neu od to bagai sa kalauf. ");
INSERT INTO dad_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Taka nem, anĩ nẽ naa sain ado to keleĩ, saa ilun engel idig sã, Naal ĩg sã, Dei yogo dogol keleĩ. ");
INSERT INTO dad_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa nẽ sain bun age fen age fiya bagai, Tamo Naal isiyouf bun age fouf. ");
INSERT INTO dad_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kuwei odug nẽ naa fau mog, tamo kayau saafei de fen, naanuei den, tamo kayau yalef, kayau tamo difenek difen, age de dile mog, Noa waag namen ilen. ");
INSERT INTO dad_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Idi ereb wõ youf anĩ to keleĩ mog, kuwei isi, adok kuweir dilelen. Age fiya bagai, Tamo Naal ĩ isiyouf bun age fouf. ");
INSERT INTO dad_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tamo uru idi kabier kabĩ dalef difarauf, tekelei yalouf, taka itornẽf. ");
INSERT INTO dad_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kayau uru idi falawa falei dife mog, tekelei yalouf, taka itornẽf. ");
INSERT INTO dad_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Age fiya nigin, meleĩ unog fen, log, ere nigin, ã keleĩ sã, naa nanĩ be bun ãgenei Odug isiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ã keleĩ youf: Fõ marau, bõ ereb sain, bẽ tamo isiyouf keleĩ youf are, ĩ mata ibod ken, bẽ tamo in fõ to narĩ fouf nigin ololo fouf. ");
INSERT INTO dad_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Age fiya nigin, ãg saika gouf, ere nigin, Tamo Naal ĩ fau sain to isiyouf gouf bun isiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ferfer taka aim anĩ dõ fiya kisi biya ado de? Ĩ yogon odugem, ĩ yogon odug nẽ fõ bun anidi neid saaf, dogo neid sain kilei dõf ifenẽdiyouf nigin ima bun inon anĩ. ");
INSERT INTO dad_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sain tamo odug kelouf bun, ferfer biya bagai age fe di, ilouf, tamo odug ĩ nigin biya fiyẽf. ");
INSERT INTO dad_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aya ã momoi arokeneik, tamo odug ĩ, yogon safina ganan ferfer anĩ ima bun inouf. ");
INSERT INTO dad_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Anĩ ere, ferfer taka sane ĩ wau bun irõf, ‘Neu tamo odug ilen, sain meluk biya gerõ ibodok, ĩ kukula to isiyouf.’ ");
INSERT INTO dad_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Age ye fen, ĩ, in kabĩ tura tar idenẽdiya gariya ino fen, gama ĩ yogo, saaf biya naan biya, aai sẽ fiya tamo geid dõdig. ");
INSERT INTO dad_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ferfer anĩ nẽ tamo odug, in isiya nẽ naa, ferfer to isiyouf ye fen, kisif mog, in isiya sain, ĩ keleĩ sã mog, isiyouf. ");
INSERT INTO dad_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tamo odug, ferfer anĩ gudũf fisik fe fen, mala yaleya tamo geid nedi modoũ bun inenẽf, an are wifirig ye fen, gobora kikokõ yediyouf.” ");
INSERT INTO dad_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus tobol fe iron, “Sain anĩ bun, saa tano ĩ, kayau taulei ten, idi neid lam gei de diyok dilen, tamo mois tarabã difiyẽf age fiya gen. ");
INSERT INTO dad_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Faif idi kisi neneya ado di, faif idi kisi biya ado. ");
INSERT INTO dad_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kisi neneya ado, idi neid lam gei difen, anĩ ere, keresin to dalen. ");
INSERT INTO dad_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Anĩ ere, kisi biya ado, keresin kulumã ado lam dalen. ");
INSERT INTO dad_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tamo mois kaisã to isin, idi adok mulã fedi di, denenan. ");
INSERT INTO dad_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Bõ atun ait taka iweig iron, ‘Ulegef, tamo mois mogo yeir, ulolõ wesig fen, fotou wiyẽg!’ ");
INSERT INTO dad_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Kayau taulei ganan fafã de fen, lam wik koriri difeselen. ");
INSERT INTO dad_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kisi neneyam, kisi biya ado dirokenẽdin, ‘Ãgenei keresin tunĩ wanamãg, amã nemã lam gare felediyou fenẽ.’ ");
INSERT INTO dad_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Kisi biya adodom, kisi neneya dirokenẽdin, ‘Eo, keresin eĩ, ã ado amã ado to kisi falauf. Amam ifeneĩya ban, uleg, oun keresin na nẽ dinodig bun, aug nigin na waleg.’ ");
INSERT INTO dad_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kisi neneya idi, keresin na nigin dile mog, tamo mois mogo isin. Kayau taulei idi ololo difiyen, weim bagu fiya nẽ tar bun, aaben dilelen. Age dife di, sukar kotũ felen. ");
INSERT INTO dad_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Dum, kisi neneya idig disin, idi diron, ‘Tamo odug, tamo odug, amã nigin sukar kã wo!’ ");
INSERT INTO dad_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Anĩ ere, tamo mois aitedin yalen, ‘Aya ã momoi arokeneik, aya ã keleĩ sã.’ ");
INSERT INTO dad_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Age fiya nigin, ã lo weleg, ere nigin, naa kilok ado ã keleĩ sã. ");
INSERT INTO dad_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Takag, saa tano ĩ, tamo taka ĩ, uyu takã gerõ naab ilau fenẽ nigin, ĩ yogon ferfer iweigneĩd fen, yogon safina kulatun de kenẽf nigin, imeid bun inon age fiya gen. ");
INSERT INTO dad_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Taka ĩ faif tausen kina ifenen, taka tu tausen kina ifenen, taka wan tausen kina ifenen, idi dogo mugu mugu neid safina kulatun fiya nẽ keleĩ kilei kilei ifeneĩd fen, ĩ uyu takã gerõ naab ilen. ");
INSERT INTO dad_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tamo faif tausen kina yalen, kaisã bagai ilen, moni kabĩ bun ino fen, baban faif tausen kina yalen. ");
INSERT INTO dad_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tamo tu tausen kina yalen, ĩg agef fen, baban tu tausen kina yalen. ");
INSERT INTO dad_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tamo wan tausen kina yalen, anĩ ere, ĩ ile, meku yale fen, tamo odug nẽ moni teneub kur inokelen. ");
INSERT INTO dad_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Sain meluk bure fele di, ferfer neid odug kel isi fen, moni ferfer mugu mugu ifenẽdin anĩ, idi naig dife kabĩ difenen anĩ, faded de dirokenẽf nigin ferfer ganan iweig laisin. ");
INSERT INTO dad_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tamo faif tausen kina yalen, ĩ baban faif tausen kina taka ado irou isi fen, ĩ iron, ‘Tamo odug, õ aya faif tausen kina wanan, ulef, aya baban faif tausen kina taka ado.’ ");
INSERT INTO dad_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“In tamo odug ĩ irokenen, ‘Õ de agon, õ ferfer biya dõ fiya biya bagai! Õ safina naal bun kulatun biya ubodon nigin, aya õ imã bun safina musei anouf. Usi fen, ogon tamo odug nẽ kulĩya namen ubod!’ ");
INSERT INTO dad_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tamo tu tausen kina yalen, ĩg isi fen, ĩ iron, ‘Tamo odug, õ aya tu tausen kina wanan, ulef, aya baban tu tausen kina taka ado.’ ");
INSERT INTO dad_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“In tamo odug ĩ irokenen, ‘Õ de agon, õ ferfer biya dõ fiya biya bagai! Õ safina naal bun kulatun biya ubodon nigin, aya õ imã bun safina musei anouf. Usi fen, ogon tamo odug nẽ kulĩya namen ubod!’ ");
INSERT INTO dad_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Age fe di, tamo wan tausen kina yalen, ĩ isi fen, iron, ‘Tamo odug, aya kelein, õ tamo totol ado, onom to utenen anĩ kusu wodig, onom faat to uraran anĩ fito wodig. ");
INSERT INTO dad_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Anĩ nigin, aya õ nigin kumĩ au fen, ele, ogon moni teneub kur anokelen. Ulef, ogon safina yeir.’ ");
INSERT INTO dad_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“In tamo odug ĩ irokenen, ‘Õ, ferfer sane fõ tamal! Õ kelein, ayam to atenen anĩ kusu afedig, ayam faat to araran anĩ fito afedig de? ");
INSERT INTO dad_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Õ kisi agom, neu moni benk bun uno di, benk im kabĩ yalekanam, ago wom, sain aya kelauf bun, moni kabĩ yalen anĩ nẽ mala ado, moni õ benk wenen anĩ bagu fiya kel isin ado alem. Anĩ õ to agon.’ ");
INSERT INTO dad_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Age ye fen, ĩ ari fedin, ‘Wan tausen kina ĩ bun son ge fen, tamo ten tausen kina ado anĩ wenẽg. ");
INSERT INTO dad_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Taka ĩ ereb ado, aya toru afouf, age fe di, ĩ musei adouf. Taka ĩ sã bagai, ereb taka ĩ adog, ĩ bun tamal son fouf. ");
INSERT INTO dad_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ferfer sane anĩ mayarẽ gugum namen urãg, an are wifirig ye fen, gobora kikokõ yediyouf.’ ");
INSERT INTO dad_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Sain Tamo Naal, yogon fula fiya medeĩya ado engel ganan geid disiyouf, ĩ in ibodõya modoũ fula fiya medeĩya bun ibodõf. ");
INSERT INTO dad_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Teneub ganan bun, tamo kayau ĩ wagen kuru difediyouf, age dife di, ĩ tamo kayau foi fediyouf, sipsip lo fiya tamo, sipsip meme ado foi fedig gen age fouf. ");
INSERT INTO dad_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ĩ sipsip ima biyalẽ inoid fen, meme ima kilẽ inodiyouf. ");
INSERT INTO dad_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Agef fen, King ĩ, idi ima biyalẽ anidi irokenẽdiyouf, ‘Neu Deim el yeik ã, usig, ãgenei akoreĩ waleg, gariya bun teneub inon bunem isi gama, tano ãgenei nigin saika fen anĩ. ");
INSERT INTO dad_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ere nigin, aya naũ fiya mog, ã yõya nẽ safina wanagen, aya naan ail fiya mog, ã naan yõya nigin wanagen, aya yaũ tamo abod mog, ã aabẽ urou uleyagen. ");
INSERT INTO dad_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aya gemũ abod mog, ã gabar ufilaĩnagen, aya dagi abod mog, ã kulatun wiyagen, aya kalabus bun abod mog, ã usig ki wiyagen.’ ");
INSERT INTO dad_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Age ye di, madur tamo kayau aiten dalen, ‘Odug, ere sain õ naũ ubod mog, amã saaf mafonon, õ naan ail yõ mog, naan mafonon? ");
INSERT INTO dad_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ere sain õ yaũ tamo mailiyo ken, amã nemã fõ bun maleyon, õ gemũ ubod mog, gabar mafilaĩnon? ");
INSERT INTO dad_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ere sain õ dagi ubod mog, amã õ mailiyon, õ kalabus bun ubod mog, amã ki mayon?’ ");
INSERT INTO dad_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“King aitedin yale irõf, ‘Aya ã momoi arokeneik, ã neu turau tar yeneid sã enidi taka el wiyẽgen, are aya el wiyagen.’ ");
INSERT INTO dad_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Age ye fen, ĩ ima kilẽ anidig irokenẽdiyouf, ‘Gelu yein ã, wageun uyag uleg, yã mala fitotoleya faimud, Satan in engel geid idi nigin dodok fen anĩ, an uleg. ");
INSERT INTO dad_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ere nigin, aya naũ abod mog, ã ereb taka to wanagen, aya naan ail fiya mog, ã naan to wanagen. ");
INSERT INTO dad_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aya yaũ tamo abod mog, ã aabẽ to urou uleyagen, aya gemũ abod mog, ã gabar to ufilaĩnagen, aya dagi abodon, kalabus bun abod mog, ã to kulatun wiyagen.’ ");
INSERT INTO dad_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Idig aiten dale dirõf, ‘Odug, ere sain õ naũ ubodon, naan sã ubodon, yaũ tamo ubodon, gabar sã ubodon, dagi ubodon, kalabus bun ubodon, amã õ to masennon?’ ");
INSERT INTO dad_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“King aitedin yale irõf, ‘Aya ã momoi arokeneik, ã neu idi yeneid sã enidi taka to el wiyẽgen, are aya to el wiyagen.’ ");
INSERT INTO dad_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Age ye di, idi darau faimud ibodkeleya nẽ bun dilauf, madur tamo kayau idi mata faimud ibodkeleya nẽ bun dilauf.” ");
INSERT INTO dad_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus od enĩ ganan wogõ ye bure fel fen, ĩ in dõ fiya tar irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ã keleĩ, naa uru bure fele di, Pasa naa isiyouf, age fe di, Tamo Naal idi imeid bun dino di, aa tetek bun dukesiyouf.” ");
INSERT INTO dad_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dum pris odudug, tamo kayau neid mudur adodo, pris mudur ado in yana Kaiafas in fõ bun guru difen. ");
INSERT INTO dad_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","An idi Jesus idegẽya naab bun dale fen, dukesiyouf nigin katõ difen. ");
INSERT INTO dad_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Idi diron, “Sifa inoya bun to age tafouf, age tafouf, tamo kayau idi seye de fen, kusĩ dalesauf.” ");
INSERT INTO dad_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus, Betani fonõ an, Simon lepra dagi kulu adon in fõ bun ibod mog, ");
INSERT INTO dad_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kayau taka, Jesus wagen moul sumeĩ biya bagai moni odug nem anĩ, moul ifeya nẽ gulub ado irou isin anĩ, Jesus tebol bun saaf yoko ibod mog, ĩ mudur bun moul fi felen. ");
INSERT INTO dad_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Anĩ in dõ fiya tar dile mã, idi nameid sane fen, diron, “Ere nigin enĩ sekil fef? ");
INSERT INTO dad_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Moul enei na odug nem sur fiyam are, moni anĩ yale maleg tamo ifenẽdiyam.” ");
INSERT INTO dad_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Anĩ Jesus kelei ken, idi irokenẽdin, “Ã, ere nigin kayau enĩ wau morõ wenẽgef? Kayau enĩ aya bun biya bagai age fel. ");
INSERT INTO dad_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Maleg idi ã geid faimud ubodõgouf, anĩ ere, aya ã geid faimud to tabodõf. ");
INSERT INTO dad_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sain kayau moul enĩ, neu bouwau bun fi felel are, mekur ainẽf nigin dodok fiyal. ");
INSERT INTO dad_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aya ã momoi arokeneik, tenebur ein nain be biya od enĩ wogõ douf, ereb kayau anĩ age fen anĩg wogõ douf. Age dife di, idi ĩ nigin dum dum wogõ de fen, karĩ dalauf.” ");
INSERT INTO dad_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Agef fen, dõ fiya tar tuwelf idi atun taka, yana Judas Iskariot tamal, pris odudug wagedin ile fen, ");
INSERT INTO dad_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","to fedin, “Sain aya ĩ imeĩ bun ano di, ere anĩ ã aya wanagauf nigin kisi gef?” Age ye di, idi teti silwa koin moni anĩ diweskene ken, difenen. ");
INSERT INTO dad_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","De anenem, Judas ĩ Jesus kiwai tamo imeid bun inoya nigin naab imirek ilen. ");
INSERT INTO dad_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bret yis sã sifa inoya naa matu anĩ bun, in dõ fiya tar Jesus wagen disi to difiyen, “Õ amã nain anĩ Pasa saaf wãf nigin, amã dodok mafe konõf anĩ oroyok?” ");
INSERT INTO dad_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus iron, “Taun uleg, tamo taka wagen wõg fen, urokenẽg, ‘Tise irok: Aya neu naa mogo melsã. Aya, neu dõ fiya tar geid, ogon fõ bun Pasa saaf male fen, sigigi mafouf.’” ");
INSERT INTO dad_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Anĩ nigin, in dõ fiya tar, Jesus iron anĩ dõ de fen, Pasa saaf nigin dodok difen. ");
INSERT INTO dad_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aragau di, Jesus, in tuwelf geid, tebol bun saaf doko dibodon. ");
INSERT INTO dad_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Idi saaf dokon, Jesus iron, “Aya ã momoi arokeneik, ã atun takam, aya kiwai tamo imeid bun ineyauf.” ");
INSERT INTO dad_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Idi waud gudũf fen, mugu mugu wogõ fiyẽya nigin gariya dinon, “Odug, momoi bagai, aya sã?” ");
INSERT INTO dad_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus aitedin yale iron, “Taka ĩ, amã uruwom imamã takai beĩ bun nu mafesil, im aya kiwai tamo imeid bun ineyauf. ");
INSERT INTO dad_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tamo Naal, ĩ nigin Negur nẽ Itotoya irok kilei, agef bagai ilauf. Anĩ ere, tamo ĩ Tamo Naal kiwai tamo imeid bun inof, ĩ malalon ado! Ĩ sina to gõ fem, are dem.” ");
INSERT INTO dad_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Age ye di, Judas, tamo ĩ Jesus kiwai tamo imeid bun inouf, iron, “Momoi bagai, aya sã, Rabi?” Jesus aiten yale iron, “Are õ ogo urok.” ");
INSERT INTO dad_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Idi saaf dokon, Jesus bret yale, Negur de fiye ken, bret anĩ mumãf, in dõ fiya tar ifeneĩd fen, iron, “Bret enei waleg fen, wõg, eĩ neu bouwau.” ");
INSERT INTO dad_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Agef fen, ĩ kap yale, Negur de fiye ken, kap anĩ ifeneĩd fen, iron, “Ã ganan, enĩ bun wõg. ");
INSERT INTO dad_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Eĩ neu naudou bar itenẽya nigin, are tamo kayau musei mosor yalel kenẽdiyouf nigin fi felef. ");
INSERT INTO dad_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aya ã arokeneik, aya baban wain enĩ to ãf, gaman ile, aya ã geid, neu Dei nẽ tano bun, wain mata tãf anĩ bun.” ");
INSERT INTO dad_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Anĩ bure fele di, idi seg taka dalel fen, idi Moul Arei bun diselen. ");
INSERT INTO dad_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesus idi irokenẽdin, “Bõ enĩ bun, ã ganan aya utornagauf, ere nigin, are Negur nẽ Itotoya irok kilei: “‘Aya sipsip marau aukesi di, sipsip ganan firagagaũ difouf.’ ");
INSERT INTO dad_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Anĩ ere, aya, laa bun tamal kel fã au fen, aya ket Galili uyu alauf.” ");
INSERT INTO dad_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita, Jesus aiten yale iron, “Idi ganan õ ditornõfeg, aya are to bagai atornõf.” ");
INSERT INTO dad_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus Pita irokenen, “Aya õ momoi arokonok, bõ enĩ bun tataro kokorok yeya sã mog, õ aya nigin wa towo wouf.” ");
INSERT INTO dad_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Anĩ ere, Pita Jesus irokenen, “Momoi ada uruwom gare tau mogoufeg, aya õ nigin to bagai wa afouf.” Age ye di, dõ fiya tar ganan, od tekelei anĩ diron. ");
INSERT INTO dad_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Age de fen, Jesus in dõ fiya tar geid, modoũ taka yana Getsemane dilen. An, ĩ idi irokenẽdin, “Aya oun ele, kosẽ au mog, ein ubodõgouf.” ");
INSERT INTO dad_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesus, Pita Sebedi gere tar uru gei feid fen, dile mã, ĩ wau gudũf fen, moro kalaisin. ");
INSERT INTO dad_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Age fe di, ĩ idi irokenẽdin, “Neu malaukanon tobega le fen, wau morõ gudũ falaisi, laa nẽ daũ bun ifaref. Ein ufareg fen, ã aya geid lo tafalauf.” ");
INSERT INTO dad_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Naal godof iroule fen, kubũ ye, nawa tenebur kumokur fe fen, kosẽ yen, “Neu Dei, kisi falauf are, darau nẽ kap enĩ walel kanauf. Anĩ ere, neu oroya to dõ wouf, on oroya anĩ dogol dõ wo.” ");
INSERT INTO dad_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Age fel fen, Jesus in dõ fiya tar gedin kel isin, mulã den mog, iledin, ĩ Pita to fiyen, “Tamo ã, aya geid aua tekelei lo fiya nigin to kisi feleya de? ");
INSERT INTO dad_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ã, lo weleg fen, kosẽ gouf, are ã kisi yeĩya bun to kubũ gouf nigin. Uur are orof, anĩ ere, bouwa anĩ malegef.” ");
INSERT INTO dad_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ĩ, anĩ dõ fiya, baban kel ile, kosẽ yen, “Neu Dei, kap enĩ bun aya to ãf are, õ kap enĩ yaleleya nigin kisi feleya sã, age fouf, õ ogon oroya dõ wouf.” ");
INSERT INTO dad_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ĩ kel isin, baban denena mog iledin, ere nigin, idi meleid morõ gudũ fesin. ");
INSERT INTO dad_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Agef fen, ĩ idi itorneĩd fen, baban kel ilen, kosẽ yen anim towo, od tekelei iron anĩ baban kosẽ yen. ");
INSERT INTO dad_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Agef fen, ĩ in dõ fiya tar gedin kel ile, idi irokenẽdin, “Ã fau si unog fen, yenẽyai gef? Ulegef, sain mogo melsã, Tamo Naal mogo mosor tamo imeid bun ilef. ");
INSERT INTO dad_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fafãg fen, teleg! Kiwai imeid bun inoya tamo yeir isif!” ");
INSERT INTO dad_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus fau wogõ ye mog, in dõ fiya tar tuwelf idi anĩ atun taka, Judas isin. Tamo musei dimig adodo seburer adodo ĩ geid disin. Pris odudug, tamo kayau neid mudur adodo idim sur difedi di, disin. ");
INSERT INTO dad_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gama Judas, Jesus kiwai tamon inoya tamo ĩ, Jesus yaor fiyẽf nigin idi uris ifenẽdin: “Tamo aya umã fiya bunem aan afiyẽf anĩ, ĩ waleg.” ");
INSERT INTO dad_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas, kaisã bagai, Jesus wagen ile iron, “O Rabi, fel!” Age ye fen, ĩ umã fiyen. ");
INSERT INTO dad_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus ĩ irokenen, “Mou, ereb wofon usif, are ago.” Age ye mog, tamo Jesus wagen dile dirounen. ");
INSERT INTO dad_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Age dife di, tamo Jesus weim difaren anidi takam, ima iran, dimig ul feis yalen, pris mudur ado nẽ ferfer weder salõf iran. ");
INSERT INTO dad_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus ĩ irokenen, “Ogon dimig in modoũ bun uno, ere nigin, idi ganan dimig ul difeis dalef, dimig bun gare douf. ");
INSERT INTO dad_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ã kisi gef are, aya, neu Dei isennauf nigin aweignẽ di, ĩ kaisã bagai, engel musei biya, sewenti-tu tausen wal fiya imau bun inoya kisi feleya sã de? ");
INSERT INTO dad_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Age afouf are, Negur nẽ Itotoya anĩ nigin iron enĩ ganan, naig fe kisi fel, agef wõ youf?” ");
INSERT INTO dad_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sain anĩ bun, Jesus tamo musei irokenẽdin, “Ã bẽ tamo walegedig gen, aya ã dimig adodo seburer adodo waleyagau fenẽ usigef de? Naa ganan, aya tempel fofomala bun abod ken, od afelnẽdidig, anĩ ere, ã aya to urouyagen. ");
INSERT INTO dad_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Anĩ ere, profet neid itotoya kisi falauf nigin, enĩ ganan wõ yen.” Age ye di, in dõ fiya tar ganan ditornẽ diyalelen. ");
INSERT INTO dad_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Idi Jesus dalen, pris mudur ado Kaiafas garan dirou dilen, an lo ifelnẽdiya tamo, tamo kayau neid mudur adodo geid guru difen. ");
INSERT INTO dad_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Anĩ ere, Pita, Jesus dume naal soso fiye ken, dõf tokõ fel ile, pris mudur ado nẽ fofomalan wõ yen. Ĩ namen ile fen, kabĩ tamo geid dibod ken, naig be difiyẽf nigin lo fen. ");
INSERT INTO dad_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pris odudug, Juda neid kaunsel ganan geid, Jesus laa bun dinenẽf nigin, bou bun idegẽya od dinou fenẽ dimiren. ");
INSERT INTO dad_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Musei wagen disi fen, disenneĩd fen, idegẽya od diraran, anĩ ere, Jesus laa bun dinenẽf nigin od gariya taka to dilen. Dum tamo uru wõ den, ");
INSERT INTO dad_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","anidim diron, “Tamo enim iron, ‘Aya Negur nẽ tempel narĩ afel fen, naa towo bun baban anouf, are kisi feleya.’” ");
INSERT INTO dad_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Age de di, pris mudur ado fã ye, ifar fen, Jesus irokenen, “Õ to solo urõf de? Eĩ ere od anĩ, tamo enidi õ nigin dirousif?” ");
INSERT INTO dad_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Anĩ ere, Jesus mutũ ifaren. Pris mudur ado Jesus irokenen, “Õ mata ibodõya Negur mala bun urõf nigin, od arokonok. Õ momoi Kristus, Negur Naal be anĩ, amã urokanamãf.” ");
INSERT INTO dad_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus aiten yalen, “Ao, õ ogo yer urok. Anĩ ere, aya ã ganan arokeneik: Dum bun, Tamo Naal Negur megeir ado ima biyalem ibod ken, saa lalo bun isi mog, ã ulogouf.” ");
INSERT INTO dad_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jesus age ye di, pris mudur ado karĩ ye fen, in kolos serek fe fen, iron, “Ĩ Negur kono fel! Ere nigin ada od megeir fiya nigin tamo baban tamirẽf? Ulegef, ã gama Negur kono fel anĩ karĩ gel. ");
INSERT INTO dad_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anĩ ã ere kisi gef?” Idi aiten dalen, “Ĩ laa bun ilauf.” ");
INSERT INTO dad_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Age de fen, idi, Jesus nawa bun disisne ken, imedim dun. Tunim wala fã de fen, ");
INSERT INTO dad_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","diron, “Kristus, kurõ weis urokanamã, aim õ inok?” ");
INSERT INTO dad_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita, pris mudur ado nẽ fõ fofomalan ibod mog, kabĩ kayau momoul taka wagen isi iron, “Õg Jesus Galili tamal weim uyõgen.” ");
INSERT INTO dad_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Anĩ ere, ganan meleid bun ĩ waf fen, iron, “Õ od urok enĩ, aya keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Age ye fen, ĩ iyok ilen, bobog bun, an kayau momoul takam ile fen, tamo kayau an difaren idi irokenẽdin, “Tamo enĩ, Jesus Nasaret tamal ĩ geiden.” ");
INSERT INTO dad_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ĩ baban waf fen, totol od iron, “Tamo are aya keleĩ sã!” ");
INSERT INTO dad_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sain naal ile di, idi an difaren Pita garan dile fen, diron, “Momoi bagai, õ idi neid taka, on od wogõya bun ogo yaor yok.” ");
INSERT INTO dad_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Age de di, ĩ mogo yogo bouwa geluf fen, totol od irokenẽdin, “Tamo are aya keleĩ sã!” Age ye mog, kaisã bagai tataro kokorok yen. ");
INSERT INTO dad_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Age fe di, Pita Jesus wogõ yen anĩ nigin weder fokõ yen, “Sain tataro kokorok yeya sã mog, õ aya nigin wa wo towo wouf.” Anĩ nigin, ĩ weder fokõ ye di, ĩ mayarẽ ile fen, inã odug yalen. ");
INSERT INTO dad_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bonimei bagai, pris odudug, tamo kayau neid mudur adodo geid, Jesus yukesiya nigin od difon. ");
INSERT INTO dad_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Idi ĩ difõ dale diroule, gawaman nẽ mudur Pailat ima bun dinon. ");
INSERT INTO dad_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Anĩ Judas, Jesus kiwai ifenen, ĩ lof mog, Jesus dukesiyouf nigin ĩ bou bun od dun anĩ ile fen, ĩ kisif wau yu ken, teti silwa koin moni kel iroule, pris odudug, tamo kayau neid mudur adodo geid ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas iron, “Aya mosor anon, ere nigin, ĩ mosor sã mog, ayam kiwai anon.” Age ye di, idi aiten dalen, “Amã ere mayõf? Are ogon sakir.” ");
INSERT INTO dad_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas moni irou ile, tempel namen irara ken, ilen. Anĩ ĩ iya ile, yogo kosim bun ula iseginen. ");
INSERT INTO dad_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pris odudug moni gei de fen, diron, “Lo to wal tafouf nigin, moni enĩ tempel nẽ kolekta bokis bun to ufeg, ere nigin, moni enĩ naud mala.” ");
INSERT INTO dad_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Katõ fiya bure difel fen, moni anim, mis inoya tamo nẽ teneub anĩ na dale fen, yaũ tamo mumã difediyouf nigin, idi kisi difon. ");
INSERT INTO dad_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Anĩ bunem, gamag teneub anĩ yana, Naud nẽ Mayã dedig. ");
INSERT INTO dad_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Are profet Jeremaia nẽ od, eig ye wogõ yen anĩ kisi felen: “Idi teti silwa koin moni dalen, moni anĩ Israel tamo kayau ĩ nigin digiren. ");
INSERT INTO dad_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Idi moni anim, mis inoya tamo nẽ teneub na dalen, Odug aya agef irokanan kilei.” ");
INSERT INTO dad_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus, Rom gawaman nẽ mudur Pailat, mala bun ifare di, gawaman nẽ mudur Pailat ĩ to fiyen, “Õ Juda neid king de?” Jesus iron, “Are de yer, õ urok anĩ.” ");
INSERT INTO dad_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sain pris odudug, tamo kayau neid mudur adodo geid, Jesus bou bun od dun, ĩ aitedin to yalen. ");
INSERT INTO dad_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pailat Jesus to fiyen, “Õ boũ bun od dirarak to karĩ wof de?” ");
INSERT INTO dad_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Anĩ ere, Jesus aiten to yalen, ĩ bou yũya od tekelei bagai nigin taka to solof iron. Age fe di, gawaman nẽ mudur, odug biya terẽ yen. ");
INSERT INTO dad_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gama gawaman mudur nẽ tobonunã, Pasa sifa naa bun, tamo kayau, tamo taka kalabus bun digirĩ di, yalisnẽdig. ");
INSERT INTO dad_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sain anĩ bun, idi kalabus tamo taka, yana sane bagai adon, ĩ yana Barabas. ");
INSERT INTO dad_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bonimei, tamo kayau, Pailat nẽ fõ bun guru difesi di, Pailat to fedin, “Nanĩ ã aliskeneĩf anĩ oroyeik, Barabas de oo Jesus ĩ Kristus dedig anĩ?” ");
INSERT INTO dad_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ere nigin, ĩ yogo kelein, tamo kayau neid mudur adodo idi, kiyeĩ bunem, Jesus ĩ ima bun dinon. ");
INSERT INTO dad_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat od es fiya modoũ bun ibod mog, in aiwa od sur fen, “Tamo anĩ ĩ mosor sã, ĩ nigin ereb taka to ago wouf, ere nigin, aya, nor bõ, ĩ nigin ami ken, morõ odug ĩ nigin ailel.” ");
INSERT INTO dad_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Anĩ ere, pris odudug, mudur adodo geid, tamo kayau od irõya nigin wedereid diroun, are idi Barabas yalisnẽya nigin ado, Jesus dukesiyouf nigin nonĩ douf nigin age difen. ");
INSERT INTO dad_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gawaman nẽ mudurem to fedin, “Aya ã aliskeneĩf nigin, uru enidi ã nanĩ oroyeik?” Idi aiten dalen, “Barabas anĩ.” ");
INSERT INTO dad_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat to fedin, “Age fiyauf are, aya, Jesus, Kristus dedig nigin, ere naig afouf?” Idi ganan diron, “Aa tetek bun ũf!” ");
INSERT INTO dad_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat to fedin, “Ere nigin? Ere mosor ĩ age fen?” Anĩ ere, idi totol bagai diweig diron, “Aa tetek bun ũf!” ");
INSERT INTO dad_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat ĩ anĩ ile fen, ĩ od irõya nigin naab taka sã, anĩ tamo kayau idi totol bagai dino fen, kusĩ dou fenẽ age dife di, ĩ naan yale fen, tamo kayau meleid bun ima kulof fen, ĩ iron, “Tamo enĩ naud aya bun sã, are ãgenei sakir!” ");
INSERT INTO dad_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tamo kayau ganan aiten dale diron, “Yogon naud utor len, amã bun ado nemã kesu tar bun yenẽf!” ");
INSERT INTO dad_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Age de di, ĩ Barabas yalis ifenẽdin. Agef fen, ĩ irõ di, Jesus wagĩ de fen, ĩ aa tetek bun dũf nigin, kusĩ tamo imeid bun inon. ");
INSERT INTO dad_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gawaman mudur nẽ kusĩ tamo, Jesus dale gawaman mudur nẽ fõ namen dile fen, an mayã taka, kusĩ tamo ganan gou difalaisi salili difiyen. ");
INSERT INTO dad_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Idi Jesus nẽ kolos dinukeis fen, kolos meluk giriya anĩ difounnen. ");
INSERT INTO dad_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Age dife fen, idi malũ duri ado dale, teter tanak kori de fen, ĩ mudur bun kurũ difen. Idi werĩ tibog dale, ima biyalẽ dino fen, wagen bobou de fen, diselinen. Idi diron, “O Juda neid king gai gai ibodõf!” ");
INSERT INTO dad_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Idi ĩ disisne ken, idi baban werĩ tibog ima bun tamal dale, mudur bun baba baban dun. ");
INSERT INTO dad_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Idi diseline kel fen, kolos meluk giriya anĩ dinukeis, yogon kolos bagai anĩ baban difounnen. Age de fen, kusĩ tamom idi, ĩ aa tetek bun dũf nigin dirou diselen. ");
INSERT INTO dad_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sain idi mayã anĩ ditor diyok dile fen, idi Sairini tamal tamo taka fotou difen, yana Simon. Idi ĩ, Jesus nẽ aa tetek faali fouf nigin nugo difiyen. ");
INSERT INTO dad_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Idi disel, modoũ yana Golgota (anĩ nẽ gariya, Mudur Tuwa nẽ Modoũ) wõ den. ");
INSERT INTO dad_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kusĩ tamo idi, an wain makik ado falei difen anĩ, Jesus yãf nigin difenen. Anĩ ere, ĩ yõ ile fen, yõya nigin itoron. ");
INSERT INTO dad_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sain idi ĩ aa tetek bun du kel fen, idi aisaĩ dira kodẽ de fen, yogon kolos morou morou gadõ difen. ");
INSERT INTO dad_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Age de fen, idi an dibod ken, lo difiye kelen. ");
INSERT INTO dad_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ĩ bou bun od dinon anĩ, idi yogon mudur ilun ditoton: EĨ JESUS, JUDA NEID KING. ");
INSERT INTO dad_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Age de fen, kusĩ tamo idi, bẽ tamo urug, ĩ geid aa tetek bun didenen, taka yogon ima biyalẽ, taka yogon ima kilẽ. ");
INSERT INTO dad_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tamo kayau dile disi dife, Jesus kono difiye ken, kasã difiyẽ, mudureid dira ken, ");
INSERT INTO dad_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","idi diron, “Õ onom tempel narĩ wol fen, baban naa towo bun anouf won, õ ogo nigin usennẽf! Õ Negur Naal wouf are, aa tetek bun tamal kutũ weis!” ");
INSERT INTO dad_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Age difiyen gen, pris odudug, lo ifelnẽdiya tamo, tamo kayau neid mudur adodo, idi Jesus diselinen. ");
INSERT INTO dad_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Idi diron, “Tunĩ anĩ isennẽdin, anĩ ere, ĩ yogo nigin isennẽya kisi feleya sã! Ĩ Israel nẽ king! Utornẽg len, gama aa tetek bun tamal kutũ yesiyouf. Age fe di, ada ĩ nigin momoi tauf. ");
INSERT INTO dad_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ĩ Negur nigin momoi yedig. Ĩ irõdig, ‘Aya Negur Naal,’ anĩ nigin, Negur ĩ nigin orouf are, utornẽg len, gama Negurem ĩ isennẽf.” ");
INSERT INTO dad_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Age difiyen gen, bẽ tamo Jesus geid, aa tetek bun didenen idig, ĩ nigin kono fiya od in bou bun diran. ");
INSERT INTO dad_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tuwelf kilok gaa ado nẽ ile, tri kilok aragaun, gugum isin, teneub ganan kerub fen. ");
INSERT INTO dad_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tri kilok age fiya mog, Jesus wade bagai iweig iron, “Eloi, Eloi, lama sabaktani?” –anĩ nẽ gariya, “Neu Negur, neu Negur, ere nigin õ aya utornal?” ");
INSERT INTO dad_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tunĩ an difaren, anĩ karĩ de fen, diron, “Ĩ Eliya iweignek.” ");
INSERT INTO dad_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kaisã bagai, idi atun takam gudu re ile, spons yalen, wain kai ado bun nu feis fen, tibog bun ino fen, Jesus yãf nigin ifenen. ");
INSERT INTO dad_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tunĩ ganan diron, “Gama utornẽg, Eliya isi isennẽ mog, tailauf.” ");
INSERT INTO dad_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus baban ait odug nem iweig di, in uur ul fe yale di, laa fen. ");
INSERT INTO dad_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sain anĩ bun, gabar meluk odug tempel namen modoũ fateul bun ibodon anĩ, serek fe uru fen, ilunenem irousil teneburen. Teneub yoũf fen, meein fara fedin. ");
INSERT INTO dad_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Matmat bobog kã fedi di, tamo kayau fateul musei gare den idi, baban mata fafã den. ");
INSERT INTO dad_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Idi matmat bunem fafã den anidi, Jesus kel fã ye di, Jerusalem fateul taun dile fen, tamo kayau musei meleid bun wowã den. ");
INSERT INTO dad_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kusĩ tamo tunĩ, idi neid orowa geid, Jesus tari difiyen, teneub yoũ fe di, ereb ereb ganan wowã ye di, dile fen, fatuk bagai terẽ de fen, diron, “Momoi bagai, ĩ Negur Naal!” ");
INSERT INTO dad_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kayau musei an difaren, idi so del fen, lo difen. Idi Galili anenem Jesus aruna yaleya nigin dõ difen anidi. ");
INSERT INTO dad_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Idi atun Maria Magdala tamal, Maria Jems Joses ado neid sineid, taka Sebedi gere tar neid sineid. ");
INSERT INTO dad_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aragau mog, safina ado tamo, Arimatea tamal, yana Josef isin, ĩ Jesus nẽ dõ fiya tar anĩ nẽ taka. ");
INSERT INTO dad_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ĩ Pailat wagen ile, Jesus nẽ bouwa buru nigin to fiyẽ di, Pailat yo ye fen, Jesus nẽ bouwa buru ĩ ifenẽya nigin, kusĩ tamo irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josef bouwa buru yale gabar lalau amuyẽ sã anim sile fen. ");
INSERT INTO dad_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Agef fen, ĩ yogon matmat mata sa bun ku yalen ani bun, Jesus nẽ bouwa buru inenen. Ĩ meein odug wele fe di, isi, matmat awa ku katĩ fel fen, ilen. ");
INSERT INTO dad_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdala tamal, Maria taka ado, matmat wagen dibodon. ");
INSERT INTO dad_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Naa taka, Sabat naa nẽ dodok fiya naa anĩ bure fele di, pris odudug, Farisia tamo geid, Pailat wagen dilen. ");
INSERT INTO dad_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Idi diron, “Tamo Odug, amã karĩ maulef, idegẽya tamo ĩ matan iyo ken, iron, ‘Naa towo bure fele di, aya laa bun tamal, baban mata kel fã auf.’ ");
INSERT INTO dad_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Age fiya nigin, õ urõ len, naa towo bun matmat totol bagai tari difouf. Age fiya sãf, in dõ fiya tar disi, bouwa buru bẽ dale mã, tamo kayau didegneĩd fen, ĩ laa bun tamal kel fã yel douf. Idegẽya dum isiyouf anĩ gai sane bagai, uruwa nẽ wal fiyauf.” ");
INSERT INTO dad_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat iron, “Lo fiya tamo tekelei waleg. Uleg fen, ã, taka nem matmat bun ileya nigin, totol bagai katĩ feleya nigin, ã keleĩ anĩ kilei bagai, matmat agog totol bagai lo gouf.” ");
INSERT INTO dad_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Anĩ nigin, idi dile, matmat bun meein teten wõ dũ dino fen, lo fiya tamo anĩ dinenen. ");
INSERT INTO dad_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat naa bure fele di, uub nẽ naa matu bun bonimei mumurei ado, Maria Magdala tamal, Maria taka ado matmat dilou fenẽ dilen. ");
INSERT INTO dad_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sain anĩ bun kaisã bagai, mimĩ totol ado wõ yen, ere nigin, Odug nẽ engel saa ilun tamal isin, matmat bun ilen, meein welef yerin ile di, teten ibodon. ");
INSERT INTO dad_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Agef fen, in lo fiya kolimei filiya gen, in kolos lalau medeĩya saa lalo lalau gen. ");
INSERT INTO dad_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Matmat lo difen tamo, idi ĩ nigin kumĩ de, tererẽ de fen, laa tamo gen denenan. ");
INSERT INTO dad_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Engel kayau irokenẽdin, “To kumĩ wog, ere nigin, aya keleĩ, ã Jesus aa tetek bun dun anĩ umirnẽgef. ");
INSERT INTO dad_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ĩ ein sã, ĩ iron kilei, mogo laa bun tamal mata kel fã yel. Usig fen, ĩ yenen modoũ uleg. ");
INSERT INTO dad_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Agog fen, kaisã bagai uleg, in dõ fiya tar urokenẽdig: ‘Ĩ laa bun tamal kel fã ye fen, ĩ ketem Galili ilef. An ã ĩ ulogouf.’ Aya mogo ã arokeneim.” ");
INSERT INTO dad_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Age ye di, kayau idi, kaisã bagai matmat ditor dilen, kumĩ den, anĩ ere, waud kulĩya ado, Jesus nẽ dõ fiya tar dirokenẽdiyou fenẽ nigin gududu den. ");
INSERT INTO dad_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Age de mog, Jesus tarabã feid fen, iron, “Fel.” Idi ĩ wagen disin, in ye dirou fen, seli dabin. ");
INSERT INTO dad_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Age dife di, Jesus idi irokenẽdin, “Ã, to kumĩ wog, uleg fen, neu turau tar idi, Galili dilauf nigin urokenẽdig; idi an aya dileyauf.” ");
INSERT INTO dad_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kayau naab luwe dile mog, matmat lo difen tamo tunĩ, taun namen dile, pris odudug bun, ereb ereb ganan wõ yen anĩ nigin od dinon. ");
INSERT INTO dad_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pris odudug, mudur adodo geid, guru de, kisi katõ de fen, idi kusĩ tamo moni odug difenẽdin. ");
INSERT INTO dad_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Idi, matmat lo difen tamo dirokenẽdin, “Ã urõgouf, ‘Jesus nẽ dõ fiya tar bõ disi fen, mainana kel mog, in bouwa buru bẽ dalen’ gouf. ");
INSERT INTO dad_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Od enĩ gawaman nẽ mudur bun ilauf are, amã faded mafiyẽ di, ã morõ to walogouf.” ");
INSERT INTO dad_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Anĩ nigin, kusĩ tamo moni dalen, idi diron kilei age difen. Od enĩ, Juda tamo kayau bun iyokelen, gamag agef yenek. ");
INSERT INTO dad_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Age fe di, in dõ fiya tar ilewen Galili dilen, arei Jesus irokenẽdin nẽ an dilen. ");
INSERT INTO dad_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sain idi Jesus dilen, idi seli dabinen, anĩ ere, tunĩ waud urun. ");
INSERT INTO dad_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Age dife di, Jesus wagedin isin irokenẽdin, “Megeir adok, saa ilun nẽ ado tenebur nẽ anĩ ganan, Negurem aya ifanan. ");
INSERT INTO dad_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Anĩ nigin, ã, teneub ganan bun, tamo kayau ganan bun uleg fen, neu dõ fiya tar unenãdigouf, Dei yana nem, Naal yana bunem, Awa Uur Fateul yana bunem, idi naan ugunẽdigouf. ");
INSERT INTO dad_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Agog fen, od aya ã arokenein anĩ ganan dõ difouf nigin ufelnẽdigouf. Momoi bagai, aya ã geid sain faimud tabodok, ile, sain idikalauf bun.” ");
INSERT INTO dad_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesus Kristus, Negur Naal nigin, biya od gariya inoya. ");
INSERT INTO dad_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profet Asaia nẽ itotoya bun ibodok: “Aya neu arũ tamo ĩ ket sur afe di, ĩ uyu ilauf, ogon naab dodok fouf.” ");
INSERT INTO dad_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Ait taka gerere tuan iweig irok, ‘Odug nẽ naab dodok ge fen, madur wenẽg.’” ");
INSERT INTO dad_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Age fiya nigin, Jon isin, tamo kayau gerere tuan od irokenẽdi di, waud falei del, nedi mosor yaleleya nigin naan igunẽdin. ");
INSERT INTO dad_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judia kalilĩ fiya, Jerusalem tamo kayau ganan, ĩ garan dilen. Idi neid mosor kurõ difesi di, idi im Jordan naanũ naan igunẽdin. ");
INSERT INTO dad_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon kamel siwi nem gabar diwan anĩ ifonũdig. Agef fen, gaar gabar nem lũ diwan anim luwa gu fedig. Ĩ totobi nin te ado yõdig. ");
INSERT INTO dad_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Eĩ enĩ yogon od iron, “Taka ĩ aya dumeun dõ fiyauf, anĩ ere, in megeir neu wal fiya. Aya to biya nigin, iborou bobou fe fen, in ye su nẽ malũ biru fiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aya naan nem aguneik, anĩ ere, ĩ Awa Uur Fateulem iguneĩf.” ");
INSERT INTO dad_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sain anĩ bun, Jesus Nasaret taun oun Galili nediwom isi, Jonem Jordan naan igunen. ");
INSERT INTO dad_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus naanum fã yale fen, ĩ lof mog, saa tano kãf fen, Awa Uur kuburir gen, ĩ bun isi mog, ilen. ");
INSERT INTO dad_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Age fe di, ait taka saa ilunem isin, “Õ neu Kesu, õ nigin aya wau laa fedig, õ nigin aya wau kulĩ yedig.” ");
INSERT INTO dad_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kaisã bagai, Awa Uurem sur fiyẽ di, gerere tuan ilen. ");
INSERT INTO dad_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ĩ gerere tuan an, naa foti ibod mog, Satanem kisi fiyen. Ĩ gaar kuĩ geid difar mog, engel idim anĩ ĩ disennen. ");
INSERT INTO dad_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jon kalabus bun dinenen ibod mog, Jesus Galili ile, Negur nẽ biya od anĩ kurõ feis iron. ");
INSERT INTO dad_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ĩ iron, “Sain mogo isil. Negur nẽ tano mogo melsak. Wauĩ falei wog fen, biya od enĩ nigin wauĩ momoi gei!” ");
INSERT INTO dad_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus Galili maaĩ yeri iyo ken, ĩ Simon, ne tura Endru ado, daliyou bun kakãg dirã mog, iledin, ere nigin, idi gau yaleya tamo. ");
INSERT INTO dad_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus iron, “Usig, dõ wiyag, aya ã tamo gei fiya nigin aneyeĩf.” ");
INSERT INTO dad_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sain anĩ bun bai, nedi kakãg ditor ken, ĩ dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sain ĩ naal iyok ile fen, ĩ Sebedi naal Jems, tura Jon ado, waag namen, idi neid kakãg dodok dife mog, iledin. ");
INSERT INTO dad_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kaisã bagai, ĩ iweignẽdin. Age fe di, idi temeid Sebedi, in kabĩ tamo oroi yaledin anidi geid waag bun ditorneĩd fen, Jesus dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Idi Kapenaum taun dilen. Sain Juda neid uub naa Sabat wõ ye di, Jesus Juda neid uub fõ namen ile fen, od ifelnẽdiya gariya inon. ");
INSERT INTO dad_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tamo kayau in od nigin terẽ den, ere nigin, ĩ tamo yana adom gen ifelnẽdin, ĩ lo ifelnẽdiya tamo gen sã. ");
INSERT INTO dad_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Agef mog bai, tamo taka kaa sanem irounen anĩ, nedi uub fõ namen an kaĩ ye iron, ");
INSERT INTO dad_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Õ amã ere naig wamã fenẽ, Jesus Nasaret tamal? Õ amã daig wamã fenẽ nigin usil de? Aya õ nigin keleĩ, Negur nẽ Fateul bagai!” ");
INSERT INTO dad_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus totol ado iron, “Foro wol! Ĩ namen tamal ulõ weis!” ");
INSERT INTO dad_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kaa sane, tamo anĩ totol bagai yokũ fiyẽ, sur fiyẽ, ira ken, kaĩ ye, ulõ yesin. ");
INSERT INTO dad_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tamo kayau ganan terẽ de fen, abob toti difen, “Eĩ ere? Keleĩ mata, agef fen, totol ado! Ĩ irõ di, kaa seseneg dõ difedig.” ");
INSERT INTO dad_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ĩ age fen anĩ nẽ od kaisã bagai, Galili kalilĩ fiya fonõ anĩ adok iyokelen. ");
INSERT INTO dad_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sain Juda neid uub fõ ditor ken, kututũ desin, idi Jems Jon ado weim, Simon Endru ado neid fõ bun dilen. ");
INSERT INTO dad_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon nẽ mam, ĩ bouwa uruwa odug ado nigin fatarẽ yenen, anĩ idi ĩ nigin Jesus dirokenen. ");
INSERT INTO dad_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Anĩ nigin, Jesus kayau wagen ile, kayau ima yales irou isennẽ di, fã yen. Age fe di, bouwa uruwa anĩ kayau folo fiye kele di, kayau ĩ aruneid yalen. ");
INSERT INTO dad_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aragau anĩ bun gaa kuru kel mog, tamo kayau dagi adodo, kaa sesen adodo ganan, Jesus wagen guri difeid, disin. ");
INSERT INTO dad_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Taun anĩ nẽ tamo kayau ganan, fofomala anĩ bun guru difen. ");
INSERT INTO dad_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Anĩ bun, Jesus, tamo kayau dagi fire fire adodo musei el fiyẽdin, kaa sesen musei irudi di, diyawon. Anĩ ere, kaa sesen idi ĩ nigin kelein. Anĩ nigin, idi to wogõ douf nigin sigoreid ifofan. ");
INSERT INTO dad_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bonimei bagai mumurei ado, Jesus fã yale, fõ itor, moilin ile, an Negur kosẽ fiyen. ");
INSERT INTO dad_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ĩ, ne tã tar geid dimirne ken, dilen. ");
INSERT INTO dad_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","An fotou difiye ken, idi dirokenen, “Tamo kayau ganan õ dimirnok!” ");
INSERT INTO dad_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus aitedin yale iron, “Ada uyu takã talauf, fonõ melsã anĩ bun. Aya aneg od arõf, anĩ nigin aya asin.” ");
INSERT INTO dad_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Age ye fen, Jesus Galili kalilĩ fiya ganan bun iyo ken, nedi uub fõ fõ bun od iro ken, kaa sesen irudi di, diyawon. ");
INSERT INTO dad_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tamo taka lepra dagi ado, ĩ wagen isi, ibor bobou fe fen, igon, “Õ oroyõf are, el wiyauf.” ");
INSERT INTO dad_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus wau gudũf fen, ima irã, kobũ fiye ken, ĩ iron, “Aya wau irok, õ bouwã biyaf!” ");
INSERT INTO dad_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Age ye di, kaisã bagai lepra guruma ĩ itornẽ di, bouwa biya len. ");
INSERT INTO dad_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus kaisã bagai totol bagai weder irou fen, sur fiyẽ di, ilen: ");
INSERT INTO dad_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Karĩ welei, enĩ aib taka to urokenẽf, anĩ ere, õ pris wagen ule, õ bouwã ufelnẽf, õ bouwã biyal anĩ nigin Moses nẽ od irok anĩ dõ fen, sesewi fiya wenẽf, anĩ bunem yaore di, tamo kayau dilouf.” ");
INSERT INTO dad_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Anĩ ere, ĩ iyok ile fen, kurõ feis irõ di, od anĩ iyokelen. Anĩ nigin, Jesus mal atun taun taka bun to iledig, ĩ moilin ibodon. Anĩ ere, tamo kayau firen firen temeleid fau fau ĩ wagen disidig. ");
INSERT INTO dad_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Naa tunĩ bure fele di, Jesus baban Kapenaum taun ile di, tamo kayau idi, ĩ fõ taka bun ibodok yeya anĩ karĩ den. ");
INSERT INTO dad_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Anĩ nigin, tamo kayau musei guru difen, fõ aaben ado fofomala dino dale di, modoũ san. Age dife di, Jesus od irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jesus od irokeneĩd mog, tamo tunĩ tamo ilolaisin anĩ tamo aiwa ifenẽyam faali de, dirou disin. ");
INSERT INTO dad_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Idi ĩ Jesus garan irou ileya kisi feleya sã, ere nigin, tamo kayau musei, anĩ nigin, idi Jesus ibodok nẽ fõ soko anĩ korõ difel fen, tamo gabgab bun yen mog, folo folõ dife di, isilen. ");
INSERT INTO dad_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus idi neid momoiya ile fen, ĩ tamo ilolaisin irokenen, “Kesu, ogon mosor alelkonok.” ");
INSERT INTO dad_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Age fe di, lo ifelnẽdiya tamo tunĩ an dibodon, idi dogo namedin kisi difen, ");
INSERT INTO dad_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ere nigin ĩ age irok? Ĩ kono fef! Taka nem mosor yaleleya to yenek, Negur yogo dogol.” ");
INSERT INTO dad_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kaisã bagai, Jesus yogon kisi bun, idi waudim kisi difen anĩ kelein. Agef fen, ĩ idi irokenẽdin, “Ã ere nigin agog kisi gef? ");
INSERT INTO dad_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tamo ilolaisin anĩ irokenẽya nigin nanĩ anĩ karika, ‘Ogon mosor alelkonok’ de, ‘Fã wo, ogon gabgab wale fen, uyok ule’? ");
INSERT INTO dad_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Anĩ ere, Tamo Naal ĩ tenebur ein mosor yaleleya nigin yana ado anĩ, ã keleĩ youf nigin…” Age ye fen, ĩ tamo ilolaisin anĩ irokenen, ");
INSERT INTO dad_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Aya õ arokonok, fã wo, ogon gabgab wale fen, fõ bun ule.” ");
INSERT INTO dad_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ĩ fã yale, ganan meleid bun in gabgab yale iyok ilen. Age fe di, tamo kayau ganan terẽ de fen, Negur yana dales diron, “Ada kulu ereb eig fiya taka to tailen!” ");
INSERT INTO dad_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus ĩ baban daliyou sirin ilen. Tamo kayau musei ĩ wagen disile di, ĩ od gariya ino ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ĩ iyok ile, Lewi, Alfeus naal, takis yaleya fõ bun ibod mog, ile fen, irokenen, “Aya dõ wiya.” Age ye di, ĩ fã yale, dõ fiyen. ");
INSERT INTO dad_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesus Lewi nẽ fõ bun saaf yõ mog, takis yaleya tamo musei, mosor adodo tamo kayau musei, ĩ, in dõ fiya tar geid, weim saaf don, ere nigin, idi musei Jesus dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sain lo ifelnẽdiya tamo, Farisia tamo idi, Jesus ĩ takis yaleya tamo, mosor adodo tamo kayau geid, weim saaf doko dibod mog, dileid fen, idi in dõ fiya tar anĩ to difiyẽdin, “Ere nigin ĩ takis yaleya tamo, mosor adodo tamo kayau geid weim doko?” ");
INSERT INTO dad_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Anĩ karĩ ye fen, Jesus idi irokenẽdin, “Dagi sã anidim dokta bun ileya nigin waud to yenek, dagi adodom dogol. Aya madur tamo anidi iweignẽdiya nigin to asin, mosor adodo tamo anidi iweignẽdiya nigin asin.” ");
INSERT INTO dad_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon nẽ dõ fiya tar, Farisia tamo geid, idi kuri den. Tamo tunĩ disi, Jesus to difiyen, “Naig fe di, Jon nẽ dõ fiya tar, Farisia tamo nẽ dõ fiya tar geid, idi kuri dedig, anĩ ere, ogon idi sã?” ");
INSERT INTO dad_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus aitedin yale iron, “Naig fe di, mois tamo ibod mog, in tamo tar idi kuri douf? Idi to age difouf, ere nigin, ĩ idi geid fau dibodok. ");
INSERT INTO dad_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Anĩ ere, naa fau isi di, anĩ bun mois tamo idi bun tamal yalelnẽ di, naa anĩ bun gama idi kuri douf. ");
INSERT INTO dad_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tamo taka, gabar tubu, gabar masak mata ado baguf fen, to iwauf. Taka ĩ age fouf are, masak mata anim tubu arirĩ fe di, tubu kudef irailauf. ");
INSERT INTO dad_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Takag age fiya, taka nem wain mata meme gabar tubu bun to itinẽf. Ĩ age fouf are, wain anim age fe di, meme gabar gẽ ye fen, serek fouf. Age fe di, wain meme gabar ado sane lauf. Age fiya nigin, ĩ wain mata meme gabar mata bun itinẽf.” ");
INSERT INTO dad_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat naa taka bun, Jesus in dõ fiya tar geid, wit kabĩ atu diyok dile fen, idi wit biya tunĩ fito difen. ");
INSERT INTO dad_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Age dife di, Farisia tamo idi Jesus dirokenen, “Ulef, ere nigin idi Sabat naa nẽ lo difodul ken, Sabat naa bun oug difef?” ");
INSERT INTO dad_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus irokenẽdin, “Sain Dawid, ne tã tar geid naũ fedi di, saaf lau de fen, Dawid age fen anĩ, ã to uwesegen de? ");
INSERT INTO dad_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiata, pris mudur ado ibodon sain anĩ bun, Dawid ĩ Negur nẽ fõ namen ile fen, bret fateul prisem dogol dõdig an ibodon anĩ yokon, ĩ bret tunĩ, ne tã tareg ifenẽdin.” ");
INSERT INTO dad_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Age ye fen, ĩ idi irokenẽdin, “Tamo isennẽya nigin Sabat naa inon, tamom Sabat naa anĩ isennẽf nigin to inon. ");
INSERT INTO dad_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Anĩ nigin, Tamo Naal ĩ Odug, Sabat nẽg ĩ Odug.” ");
INSERT INTO dad_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sain taka, Jesus baban Juda neid uub fõ bun ilen. Tamo taka ima sitakã gege fefu fen anĩ, an ibodon. ");
INSERT INTO dad_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tamo tunĩ an difaren idi, Jesus bouwa bun od dinouf nigin naab dimiren, anĩ nigin, idi ĩ Sabat naa bun tamo anĩ el fiyẽ mog, dilouf nigin ololo difen. ");
INSERT INTO dad_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus tamo ima fefu fiya anĩ irokenen, “Ganan meleid bun fã, ufar.” ");
INSERT INTO dad_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Age ye fen, Jesus idi to fedin, “Nanĩ anĩ Sabat naa bun lo dõ fiya? Tobonunã biya age fiya anĩ de, tobonunã sane age fiya anĩ; isennẽ di, mata ibodõya anĩ de, yukesiya anĩ?” Anĩ ere, idi nin kẽ delen. ");
INSERT INTO dad_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus seye ye fen, idi fele fedin, idi waud togun nigin, ĩ wau odug gudũf fen, tamo anĩ irokenen, “Ogon imã yaĩ wo.” Ĩ yaĩ fe di, in ima oditekei biya len. ");
INSERT INTO dad_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Age fe di, kaisã bagai Farisia tamo idi kututũ deis dile, Herod nẽ dõ fiya tar weim, idi Jesus naig de dukesiyouf nigin od katõ difen. ");
INSERT INTO dad_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus in dõ fiya tar geid, daliyoun disile di, tamo kayau musei Galili temeleid dõ difen. ");
INSERT INTO dad_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesus ĩ ereb ereb ganan age fen anĩ karĩ de fen, tamo kayau musei Judia distrik, Jerusalem taun, Idumea distrik, Jordan naan kalilĩ fiya, Taia Saidon ado kalilĩ fiya adok, ĩ wagen disin. ");
INSERT INTO dad_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tamo kayau museim Jesus to sile difiyẽf nigin, ĩ yogon waag naal taka dodok de yenẽf nigin, in dõ fiya tar irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ere nigin, ĩ mogo musei el fedin. Anĩ nigin, idi dagi adodo Jesus kobũ fiya nigin abob susur difedin. ");
INSERT INTO dad_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kaa sesen Jesus dilef sain ganan, idi ĩ wagen kuku de, den ken, diweig dirõdig, “Õ Negur Naal.” ");
INSERT INTO dad_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Anĩ ere, Jesus, ĩ aib anĩ, to wogõ douf nigin totol bagai katũ fedin. ");
INSERT INTO dad_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus arei wala bun isel ibod ken, idi ĩ aib aib oron anĩ iweignẽdin. Age fe di, idi ĩ wagen disin. ");
INSERT INTO dad_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesus ĩ tuwelf gei fen, aposel wowã douf nigin igirnẽdin, are idi Jesus geid fen, dum biya od wogõ douf nigin fau sur fediyouf, ");
INSERT INTO dad_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","idi totol dale fen, kaa sesen dirudiyouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesus tuwelf igirnẽdin enidi, are Simon (Jesus ĩ yana yun Pita), ");
INSERT INTO dad_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems Sebedi naal, tura Jon ado (Jesus idi yeneid yun Boaneges, anĩ nẽ gariya, Kolimei Gere Tar), ");
INSERT INTO dad_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endru, Filip, Batolomyu, Matyu, Tomas, Jems Alfeus naal, Tadeus, Simon Selot taka, ");
INSERT INTO dad_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariot, ĩ dum Jesus kiwai imeid bun inenen. ");
INSERT INTO dad_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesus ĩ, fõ taka bun ile di, tamo kayau musei baban guru difen. Anĩ nigin, Jesus in dõ fiya tar geid, saaf yõya kisi feleya san. ");
INSERT INTO dad_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesus nẽ tura tar od anĩ karĩ de fen, idi ĩ dale diroulauf nigin dilen, ere nigin, idi diron, “Ĩ neneya kisi ado.” ");
INSERT INTO dad_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Age dife di, lo ifelnẽdiya tamo Jerusalem temeleid disi diron, “Ĩ Belsebub ado, ĩ kaa sesen neid mudur yana bunem, kaa sesen irudidig.” ");
INSERT INTO dad_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Anĩ nigin, Jesus idi iweigneĩd fen, yaab od nem irokenẽdin, “Satan ĩ naig Satan iruwauf? ");
INSERT INTO dad_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tano tekelei anĩ, yogo faraf, kiwai ifenẽf are, tano anĩ to ifarauf. ");
INSERT INTO dad_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Fõ tekelei anĩ, yogo faraf, kiwai ifenẽf are, fõ anĩ to ifarauf. ");
INSERT INTO dad_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Takag, Satan ĩ yogo faraf, kiwai ifenẽf are, ĩ to ifarauf, in sain mogo bure felef. ");
INSERT INTO dad_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Anĩ ere, taka nem tamo totol ado nẽ fõ bun safina gei fou fenẽ, tamo totol ado ket ifokel fen, anĩ ĩ yogon fõ bun bẽ yalouf. ");
INSERT INTO dad_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Aya ã momoi arokeneik, tamo neid mosor ganan ado kono difef are, fau yalel kenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ani ere, aibem taka Awa Uur Fateul kono fiyek, in mosor to yalelauf, in mosor anĩ faimud ibodkalauf.” ");
INSERT INTO dad_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus od enĩ iron, ere nigin, idi dirõdig, “Ĩ kaa sane ado.” ");
INSERT INTO dad_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Age ye di, Jesus nẽ sina, tura tar geid disin. Mayarẽ difar mã, idi Jesus dirokenẽf nigin taka sur difen. ");
INSERT INTO dad_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tamo kayau musei ĩ salili difiyek dibodon, idi ĩ dirokenen, “Ogon sinã, turã tar geid, mayarẽ õ dimirnok.” ");
INSERT INTO dad_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus to fedin, “Ai anĩ neu naai, neu turau tar?” ");
INSERT INTO dad_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Age ye fen, ĩ, salili difiyẽ dibodon idi lo feid fen, ĩ iron, “Enidi anĩ neu naai, neu turau tar! ");
INSERT INTO dad_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aib idi Negur nẽ oroya dõ difedig anidi anĩ, neu turau, neu mainou, neu naai.” ");
INSERT INTO dad_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus baban daliyou sirin, gariya ino, od ifelnẽdin. Tamo kayau guru de, salili difiyen anĩ gai musei biya, anĩ nigin, tamo kayau adok ubun difar mog, ĩ waag taka daliyoun ifaren anĩ namen isil ibodon. ");
INSERT INTO dad_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Agef fen, ereb ereb musei yaab od nem ifelneĩd fen, iron, ");
INSERT INTO dad_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Karĩ gei! Kabĩ marau taka faat irarãf nigin ilen. ");
INSERT INTO dad_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sain ĩ irarak ile mog, tunĩ naab luwen kuku ren, are ninã disi dakasin. ");
INSERT INTO dad_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tunĩ meein tuar kuku ren, an teneub badagar. Are kaisã bagai fokũ den, ere nigin, teneub are badagar bagai. ");
INSERT INTO dad_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Anĩ ere, sain gaa ise di, bali are ilalaid, laasi yedin, ere nigin, idi warumutei sã. ");
INSERT INTO dad_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Faat tunĩ malũ duri atun kuku ren, are malũ duri anĩ fã ye fen, sile feledin, anĩ nigin, biya to yun. ");
INSERT INTO dad_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Faat tunĩ teneub biya bun kuku ren, are idi fokũ yedin, oduduge di, biya imadin, taka biya teti, taka biya siksti, taka biya wan handred, age fef ilauf.” ");
INSERT INTO dad_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Age ye fen, Jesus iron, “Taka ĩ karĩya nigin weder ado, ĩ karĩ youf.” ");
INSERT INTO dad_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sain Jesus ĩ yogo ibod mog, yogon dõ fiya tar tuwelf, tamo tunĩ salili difiyen anidi geid, yaab od nigin ĩ to difiyen. ");
INSERT INTO dad_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus idi irokenẽdin, “Negur tano nẽ waa are Negur mogo ifenein, anĩ ere, idi dumeitur onudi nigin, ereb ereb ganan yaab od bunem wogõ yef, ");
INSERT INTO dad_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ere nigin, “‘idi meledim diledig, anĩ ere, idi meleid fokõya sã, idi wederedim karĩ dedig, anĩ ere, idi gariya keleĩ sã. Age fiya sãf are, idi waud falei de di, mosor yalel kenẽdiyouf.’ ” ");
INSERT INTO dad_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Age ye fen, Jesus idi irokenẽdin, “Ã yaab od enĩ wauĩ to fokõ youf? Age fiyauf are, naig fe di, ã yaab od tunĩ nigin wauĩ fokõ youf? ");
INSERT INTO dad_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Faat irarãya tamo, biya od irarak. ");
INSERT INTO dad_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tamo tunĩ idi faat naab luwen kuku ren gen, an biya od iraran. Idi karĩ de mog, kaisã bagai Satan isi, biya od idi namedin iraran anĩ yaleledig. ");
INSERT INTO dad_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tunĩ idi faat meein tuar iraran gen, idi od anĩ karĩ de fen, kaisã bagai dale fen, waud bun kulĩ dedig. ");
INSERT INTO dad_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Anĩ ere, idi warumutei sã, anĩ nigin, idi sain meluk to dibodõf. Sain, biya od nigin, morõ be kafĩ fiya be isif, idi kaisã bagai dirofosif. ");
INSERT INTO dad_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tunĩg faat malũ duri atun iraran gen, idi biya od karĩ den. ");
INSERT INTO dad_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Anĩ ere, tenebur mata ibodõya nẽ sii fiya, safina ado ibodõya nẽ kisi fiya, oroya fire fire isif anidim, biya od sile fe di, anim biya to yũf. ");
INSERT INTO dad_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tunĩ faat teneub biya bun iraran gen, idi biya od karĩ den, dale di, anĩ biya yũf, taka biya teti, taka biya siksti, taka biya wan handred, age fef ilauf.” ");
INSERT INTO dad_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus idi irokenẽdin, “Ã lam urou usig, beĩ kuren be fatar farumen unogouf de? Age fiya ban, ã lam yogon yoki bun to useginnẽgouf de? ");
INSERT INTO dad_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ereb ereb ganan iminẽyan yenek anĩ ganan yaor fouf, ereb ereb ganan nar fen yenek anĩ ganan irou isi, biru fel fen, yaau du fouf. ");
INSERT INTO dad_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Taka ĩ karĩya nigin weder ado, ĩ karĩ youf.” ");
INSERT INTO dad_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesus idi irokenẽdin, “Ã od karĩ gef anĩ, ed ge kisi gouf, ã idi nigin kisi gef gen, ã nigineg age de kisi difouf, anĩ tobol feneĩf. ");
INSERT INTO dad_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aib taka ĩ ado, wal fiya ifenẽf, aib taka ĩ sã, ereb ereb ĩ ado anĩg ĩ bun yalelauf.” ");
INSERT INTO dad_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Takag Jesus iron, “Negur nẽ tano are eig fiya gen, tamo taka teneub bun faat irarak. ");
INSERT INTO dad_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bõ ado gaa ado, tamo ĩ mulaĩ yenek, fã ye iyok, faat fokũ ye fen, odugef, anĩ ere, ĩ naig be fe odugef, ĩ keleĩ sã. ");
INSERT INTO dad_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Teneub yogo dogol biya inodig, uyulil bali, age fe di, turu, anĩ turu bun biya inodig. ");
INSERT INTO dad_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Biya bure fele di, kaisã bagai ĩ dimig gunõ waila ado inodig, ere nigin, biya yaleya sain isif.” ");
INSERT INTO dad_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Baban Jesus iron, “Negur nẽ tano, ere taka age fiya tauf? Ere bunem yaab tafouf? ");
INSERT INTO dad_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ĩ masted faat age fiya. Ĩ faat memereis bagai ã teneub bun utenẽgedig. ");
INSERT INTO dad_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Anĩ ere, ĩ utenẽge di, ĩ odugouf, ĩ kabier saaf ganan wal fediyouf, in beneir odudug irara ken, buri ino di, ninã ilun temeleid disi dibodõf.” ");
INSERT INTO dad_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus yaab od age fediya musei bunem, tamo kayau idi keleĩ youf kisin, od wogõ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ĩ tamo kayau ereb od irokenẽdiyou fenẽ, yaab od bunem dogol. Anĩ ere, ĩ mugu yogon dõ fiya tar geidef are, ereb ereb ganan faded fedidig. ");
INSERT INTO dad_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Naa anĩ bun aragau di, Jesus in dõ fiya tar irokenẽdin, “Ada daliyou sitakã talauf.” ");
INSERT INTO dad_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Idi tamo kayau ditorneĩd fen, Jesus waag bun ibod mog, idi ĩ dale dirou dilen. Waag tunĩg weim dilen. ");
INSERT INTO dad_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yau odug fã ye di, maaĩ fã ye, waag yu ken, maaĩ ifilege di, waag namen isokosen. ");
INSERT INTO dad_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus ĩ, waag ibun edẽ bun mulaĩ yen mog, idi ĩ turĩ difiyẽ dirokenen, “Tise, ada naanũ talalau fenẽ, õ to kisi walef de?” ");
INSERT INTO dad_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ĩ fã yen, yau sakã fiye ken, maaĩ irokenen, “Kee resig fen, dẽ weleg!” Age ye di, yau dẽ yele di, maaĩg oditekei dẽ yelen. ");
INSERT INTO dad_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus in dõ fiya tar irokenẽdin, “Ere nigin ã kumĩ wogef? Ã fau momoiya sã de?” ");
INSERT INTO dad_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Idi fatuk bagai kumĩ tererẽ de fen, abob toti difen, “Eĩ aim bagai? Ĩ irõ di, yau maaĩ adog ait dõ difef!” ");
INSERT INTO dad_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Idi naan daliyou dibal dile, Gerasa teneub bun wõ den. ");
INSERT INTO dad_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus waag bun tamal kutũ yesi di, tamo taka kaa sane ado, matmat bunem ĩ fotou fiyẽ fenẽ isin. ");
INSERT INTO dad_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tamo matmat bun ibodon anĩ, taka nem ĩ ifõya nigin kisi feleya sã, sen nemeg ifõya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ĩ sain musei sen nem, ye ima ado difofãdig, anĩ ere, ĩ sen kokour fel, yem ain weweur fedig. Taka nem totol ino fen, ĩ ifõ di, dẽ yeleya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sain ganan bõ ado gaa ado, ĩ matmat atun ado areineg iweig kaĩ ye fen, meeinem yogo bouwa kokour fedig. ");
INSERT INTO dad_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ĩ mala irakelen, Jesus gerom ile fen, gudu ref ile, Jesus wagen kubũ ye, ibor bobou fen. ");
INSERT INTO dad_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ĩ ait odug nem iweig iron, “Õ aya ere naig wiyau fenẽ, Jesus, Negur Ilun Bagai nẽ Naal? Negur yana nem aya õ agonok, õ aya to daig wiyauf!” ");
INSERT INTO dad_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ere nigin, ĩ mogo kaa sane irokenen, “Õ tamo enĩ bun tamal ulõ weis!” ");
INSERT INTO dad_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Age ye fen, Jesus ĩ to fiyen, “Õ yanã ai?” Ĩ iron, “Aya yanau Ami, ere nigin, amã musei biya.” ");
INSERT INTO dad_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jesus idi akor anĩ bun tamal to irudiyouf nigin, ĩ baba baban Jesus igonen. ");
INSERT INTO dad_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Melsã arei wala sirin, bor musei biya saaf doko difaren. ");
INSERT INTO dad_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kaa sesen Jesus digonen, “Amã bor atun susur wamãf, yo wamã di, idi namedin malalauf.” ");
INSERT INTO dad_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus idi yo fedi di, kaa sesen ulolõ deis disel, bor namedin dilelen. Bor, tu tausen age fiya, gududu de, bebeig sane baurin daliyoun disil, naanũ gare desin. ");
INSERT INTO dad_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bor lo fiya tamo diya dile, od anĩ taun ado fonõ fonõ wogõ den. Age dife di, tamo kayau ereb wõ yen anĩ dilou fenẽ dilen. ");
INSERT INTO dad_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sain idi Jesus garan wõ den, idi meleid dirã, tamo kaa sesen museim dirounen anĩ, an garab yel, kisi biya ado ibod mog, dilen. Anĩ nigin, idi kumĩ den. ");
INSERT INTO dad_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tamo idi meledim dilen anidim, kaa sesenem tamo diroun anĩ ado bor age difen anĩ nigin, tamo kayau wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Age dife di, tamo kayau, Jesus ĩ idi neid teneub anĩ itor ilauf nigin digonen. ");
INSERT INTO dad_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Age de di, Jesus ĩ waag bun sõ ye mog, tamo kaa sesenem dalen anĩ, Jesus ado dilauf nigin nonĩ fiyen. ");
INSERT INTO dad_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesus ĩ to awa yokon irokenen, “Õ fonõ ogon ibor tar gedin ulauf, Odug õ nigin age fen anĩ ado, ĩ naig fe fen, õ nigin wau yun anĩ, idi urokenẽdiyouf.” ");
INSERT INTO dad_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Age ye di, tamo anĩ itor ilen, Jesus ĩ nigin age fen anĩ, Dekapolis teneub bun tamo kayau wogõ fiyẽdi di, idi ganan terẽ den. ");
INSERT INTO dad_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus baban waag bun ibal, naan daliyou sitakã ilen, ĩ daliyou yerin ibod mog, tamo kayau musei disi salili difiyen. ");
INSERT INTO dad_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Age de mog, Juda neid uub fõ lo fiya nẽ mudur taka, yana Jairus an isin. Ĩ Jesus ile fen, ĩ ye gariyan kubũ yen. ");
INSERT INTO dad_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ĩ igone ken, irokenen, “Nau barai naal oboim fef. Uma fen, imã teten uno di, ĩ biyal, matauf.” ");
INSERT INTO dad_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Anĩ nigin, Jesus ĩ uruwom dilen. Tamo kayau musei dõ difiyẽ, kitikiti de, susir difiyek dilen. ");
INSERT INTO dad_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kayau taka idi atun an ifaren, ogõ dagi faimud ado yar tuwelf iyon. ");
INSERT INTO dad_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kayau anĩ dokta musei bun ilen, anĩ ere, bouwa bun morõ odug idi bun yalen. Agef fen, yogon safina ganan irailen. Anĩ ere, kayau ĩ bouwa biya leya ban sane len. ");
INSERT INTO dad_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sain kayau ĩ Jesus nigin karĩ yen, ĩ Jesus dume dõf, tamo kayau atu ile, in kolos kobũ fen, ");
INSERT INTO dad_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ere nigin, kayau ĩ kisi fen, “Aya in gabar dogol kobũ afouf, are deuf, aya fau biyauf.” ");
INSERT INTO dad_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kaisã bagai, kayau naud segẽ yelen. Age fe di, kayau ĩ yogo bouwa bun karĩ yen, are karika len. ");
INSERT INTO dad_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kaisã bagai, Jesus in totol ĩ bun tamal ul fe yale mog, karĩ yen. Ĩ tamo kayau atun falei yel, to fedin, “Aim neu kolos kobũ fel?” ");
INSERT INTO dad_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","In dõ fiya tar Jesus dirokenen, “Tamo kayau musei õ kiti diyok, ule fen anĩ, õ ‘Aim aya kobũ fiyal?’ wof.” ");
INSERT INTO dad_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Anĩ ere, Jesus ĩ aibem age fen anĩ ilouf nigin, fau fau fai yen. ");
INSERT INTO dad_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Age fe di, kayau ĩ yogo ereb age fen kelei ken, Jesus wagen isi, ye gariyan kubũ yen. Ĩ kumĩ tererẽ ye fen, momoi od ganan Jesus irokenen. ");
INSERT INTO dad_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus kayau irokenen, “Nau barai, ogon momoiya anim el yom. Waũ unois ule, dagi anim to ifõyõf.” ");
INSERT INTO dad_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus fau od wogõ ye mog, tamo tunĩ, Juda neid uub fõ lo fiya mudur Jairus nẽ fõ bunem disin. Idi diron, “Nẽ barai mogo laa fel. Ere nigin õ tise fau morõ wenek?” ");
INSERT INTO dad_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus od idi diron anĩ idod ken, Juda neid uub fõ lo fiya mudur anĩ irokenen, “To kumĩ wo, momoi dogol wo.” ");
INSERT INTO dad_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesus ĩ takam dõ fediya nigin katũ fedin, Pita, Jems, ne tura Jon idim dogol. ");
INSERT INTO dad_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Idi Juda neid uub fõ lo fiya mudur nẽ fõ bun ulõ deis fen, Jesus mala iran, tamo kayau waud gudũf fen, inã legur mog, iledin. ");
INSERT INTO dad_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesus aaben ile fen, idi irokenẽdin, “Ere nigin ã fatuk bagai inaĩ gef? Kayau naal ĩ laa fiya sã, ĩ mulã yenek.” ");
INSERT INTO dad_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Anĩ ere, idi Jesus kasã difiyen. Age dife di, Jesus idi irud le fen, ĩ kesu nẽ sina tama ado, in dõ fiya tar geid, kesu yenen nẽ namen dilen. ");
INSERT INTO dad_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesus ĩ imalẽ yalesne ken, irokenen, “Talita kum!” (anĩ nẽ gariya, “Kayau naal, aya õ arokonok, fã wo!”). ");
INSERT INTO dad_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kaisã bagai, kayau naal fã yale iyon (ĩ yar tuwelf ado). Anĩ nigin, idi oditekei terẽ den. ");
INSERT INTO dad_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Anĩ ere, taka to diro ken, karĩ youf nigin, Jesus totol bagai katũ fedin. Agef fen, ĩ kayau naal saaf difenẽ di, yãf nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus an itor ken, in dõ fiya tar geid yogon fõ gariyan dilen. ");
INSERT INTO dad_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat naa wõ ye di, Jesus Juda neid uub fõ bun ifelnẽdiya gariya inon. Age fe di, musei ĩ karĩ difiye ken, terẽ de diron, “Tamo enĩ ereb ereb enei nain gei fen? Eĩ ere keleĩ anĩ ĩ ifenen? Anĩ bunem ĩ memelikeg inodig. ");
INSERT INTO dad_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ĩ to kapenta de? Ĩ to Maria naal fen, Jems, Josef, Judas, Simon ado tureid de? In main tar ada to ein weim de?” Age de fen, idi ĩ kiwai difenen. ");
INSERT INTO dad_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus idi irokenẽdin, “Profet taka ĩ, in fõ gariyan, in sirag atun ado, in fõ bun dogol, ĩ yana sã.” ");
INSERT INTO dad_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ĩ an memelik taka inoya kisi feleya sã, anĩ ere, ĩ dagi tamo teke tekelei dogol ima tetedin ino fen, el fedin. ");
INSERT INTO dad_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesus idi neid momoiya to ile fen, terẽ yen. Agef fen, Jesus fonõ fonõ iyo ken, od ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesus tuwelf iweignẽdi di, idi ĩ wagen disin. Ĩ uru uru, sur feid fen, kaa sesen dirudiyouf nigin, idi megeir ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ĩ fadim yu ken, iron, “Delẽ uyõgouf nigin ereb taka to walogouf, bret sã, kodol sã, moni sã, manig dogol. ");
INSERT INTO dad_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sendel ufonũg fen, gabar ufilaĩgef dogol, taka to walogouf. ");
INSERT INTO dad_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ereb sain ã fõ bun ulagauf, an ubodõgef uleg, taun anĩ utorõgouf. ");
INSERT INTO dad_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Fonõ taka bun ã to daleyei ken, ã to karĩ diyeĩf, sain ã fonõ anĩ utorõg fen, yeĩ aas tu welege di, idi ã kiwai difenein anĩ keleĩf.” ");
INSERT INTO dad_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tamo kayau waud falei youf nigin, idi dile, od wogõ den. ");
INSERT INTO dad_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Idi kaa sesen musei diruid fen, tamo kayau dagi ado musei moul diguneĩd, el difedin. ");
INSERT INTO dad_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Herod Jesus nigin od karĩ yen, ere nigin, Jesus nẽ yana fõ fõ ganan karĩ den. Tunĩ diron, “Jon naan igunẽdiya tamo, ĩ laa bun tamal kel fã yen, anĩ nigin, memelik nẽ totol ĩ bun kabĩ yalef.” ");
INSERT INTO dad_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tunĩ diron, “Ĩ Eliya.” Tunĩ diron, “Ĩ profet taka, profet kulu temeleid taka gen.” ");
INSERT INTO dad_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Anĩ ere, sain Herod od enĩ karĩ ye fen, ĩ iron, “Jon, tamo anĩ ayam ula gudũ afen, ĩ laa fen anĩ kel fã yen!” ");
INSERT INTO dad_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ere nigin, kulu Herod ĩ irõ di, Jon dale difo ken, kalabus bun dinenen. Are Herod yogo tura Filip nẽ kayau Herodias yalen nigin, ");
INSERT INTO dad_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon Herod irokenẽdig, “Õ turã nẽ kayau son won, are lo ufodulen.” ");
INSERT INTO dad_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias Jon nigin name sane fen, ĩ dukesiyouf nigin wau iron. Anĩ ere, ĩ kisi feleya sã, ");
INSERT INTO dad_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ere nigin, Herod Jon kumĩ fiye ken, ĩ, Jon anĩ madur fateul tamo ye fen, kulatun fedig. Sain Herod ĩ Jon nẽ od karĩ yedig, ĩ wau togudig, anĩ ere, ĩ in od karĩya nigin orodig. ");
INSERT INTO dad_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dum sain biya wõ yen, Herod ĩ sina gõ fen anĩ nẽ naa bun, in kabĩ tamo odudug, in kusĩ mudur adodo, Galili teneub bun uyu irouya tamo anidi nigin tar inon. ");
INSERT INTO dad_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sain anĩ bun, Herodias nẽ barai isi, seg kui ye fen, dole di, Herod in tamo tar geid waud al fen. Anĩ nigin, king kayau momoul irokenen, “Ereb taka nigin waũ iro ken, to wiyauf, are õ afonõf.” ");
INSERT INTO dad_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Age ye fen, ĩ wau adok kuturol fen, kayau momoul irokenen, “Ereb taka nigin õ to wiyauf, aya neu tano anĩ fara af, uru afe fen, sitakã ifonõya kisin anĩ afonõf.” ");
INSERT INTO dad_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kayau momoul ile, sina irokenen, “Ere bagai nigin aya to afiyẽf?” Sina iron, “Jon naan igunẽdiya tamo nẽ mudur nigin.” ");
INSERT INTO dad_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ĩ kaisã bagai ile, king irokenen, “Aya gama bagai Jon naan igunẽdiya tamo nẽ mudur, beĩ bun uno wanauf anĩ orouf.” ");
INSERT INTO dad_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King ĩ wau togun bagai, anĩ ere, in wau kuturol fen, tamo kayau meleid bun mogo iron nigin, ĩ kayau nẽ od yaleleya itoron. ");
INSERT INTO dad_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Anĩ nigin, king kaisã bagai ula gudũ fedig kabĩ tamo, Jon nẽ mudur yale irou isiyouf nigin sur fiyen. Age fe di, ĩ ilen, kalabus bun Jon ula gudũf fen, ");
INSERT INTO dad_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mudur anĩ beĩ bun ino irou isin, kayau momoul ifenẽ di, ĩ bam yale, sina ifenen. ");
INSERT INTO dad_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon nẽ dõ fiya tar anĩ karĩ de fen, disin, in bouwa dale, matmat bun mũ difen. ");
INSERT INTO dad_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposel idi Jesus wagen guru de fen, idi ereb age difen ado difelnẽdin anĩ adok, wogõ difiyen. ");
INSERT INTO dad_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Age de mog, tamo kayau musei dilef disif difen, anĩ bunem, idi saaf yõya kisin san. Anĩ nigin, Jesus idi irokenẽdin, “Ã aug dogol usig, aya geid talauf, modoũ taka motikeleyan an si tanouf.” ");
INSERT INTO dad_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Anĩ nigin, idi dogo dogol waag dale diya, moilin dilen. ");
INSERT INTO dad_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Anĩ ere, tamo kayau musei lo difeid mog, dilen nigin, idi nigin kelei ken, taun ganan bun temeleid idi yedim gududu de dile, idi ket an wowã den. ");
INSERT INTO dad_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sain Jesus wõ ye fen, mala iran, tamo kayau musei iledin, ĩ idi nigin wau yun, ere nigin, idi sipsip marau sã gen. Anĩ nigin, ĩ ereb ereb musei idi ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sain anĩ bun, gaa mogo kuru kelen, anĩ nigin, in dõ fiya tar ĩ garan disi diron, “Eĩ gerere tuan, sain mogo sa kelel. ");
INSERT INTO dad_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tamo kayau susur wodi di, dilauf, ago di, idi fonõ kalilĩ fiya fonõ fonõ dile fen, dogo yõya nigin saaf na gei difouf.” ");
INSERT INTO dad_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Anĩ ere, ĩ aitedin yale iron, “Idi dãf nigin ereb ãgem wenẽdigouf.” Idi ĩ dirokenen, “Tamo kayau musei nigin, saaf na yaleya moni odug biya. Ada tele, bret bun moni odug age fiya tara ken, tafenẽdi di, dãf de?” ");
INSERT INTO dad_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus idi irokenẽdin, “Bret ganĩ ã ado? Uleg ulogouf.” Idi kelei ken, Jesus dirokenen, “Bret faif, gau uru ado.” ");
INSERT INTO dad_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Age de di, Jesus, tamo kayau ganan, mala fire fire, fisir biya bun dibodadãf nigin, in dõ fiya tar irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Anĩ nigin, idi mala bun dibodadan, tunĩ wan handred, wan handred, tunĩ fifti, fifti. ");
INSERT INTO dad_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus bret faif gau uru ado yale, saa ilun itad fen, ĩ Negur de fiye ken, bret mumã fen. Agef fen, ĩ in dõ fiya tar ifenẽdin, tamo kayau wagedin dinodiyouf nigin. Ĩ gau urug agef tamo kayau atun foif ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Idi ganan don kisi felen. ");
INSERT INTO dad_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","In dõ fiya tar, tamo kayau bret gau ado dokon, tunĩ ditoraran anĩ fito difen, karam tuwelf isokosen. ");
INSERT INTO dad_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Faif tausen tamo anidim bret don. ");
INSERT INTO dad_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kaisã bagai, Jesus, in dõ fiya tar waag bun, idi ketem Betsaida dilauf nigin, sur fedin. Agef fen, ĩ tamo kayaug irudin. ");
INSERT INTO dad_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jesus idi itorneĩd fen, Negur kosẽ fiyẽf nigin arein iselen. ");
INSERT INTO dad_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aragau mog, waag daliyou atun ifaren, anĩ ere, Jesus ĩ yogo mugu teneub bun. ");
INSERT INTO dad_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesus in dõ fiya tar totol bagai ful dife mog, iledin, ere nigin, yau odug biya wewu fedin. Maur oboi wele ye mog, Jesus daliyou teteatu idi gedin iyok ilen. Ĩ wal fediyou fenẽ age fen. ");
INSERT INTO dad_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Anĩ ere, sain in dõ fiya tar meleid diran, Jesus daliyou teteatu iyõ mog, dile mã, idi kisi baraũ de fen, idi ui guri den, ");
INSERT INTO dad_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ere nigin, idi ganan ĩ dile fen, kumĩ tererẽ den. Kaisã bagai, Jesus idi irokenẽdin, “Totol unog! Are ayam. To kumĩ wog.” ");
INSERT INTO dad_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Age ye fen, ĩ idi gediyouf nigin waag bun sõ ye di, yau kee relen. Idi oditekei terẽ den, ");
INSERT INTO dad_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ere nigin, idi bret bun waud to fokõ yen, idi neid waud katĩ felen. ");
INSERT INTO dad_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Idi sitakã dibabal dale, Genesaret teneub bun wõ de fen, an waag difokel difaren. ");
INSERT INTO dad_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Idi waag bunem kututũ deis mog, tamo kayau enei Jesus yeya idi kelein. ");
INSERT INTO dad_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Idi Jesus an ibodok yeya karĩ def are, idi fonõ anĩ kalilĩ fiya adok gududu de fen, dagi tamo gabgab ado guri difedi di, disin. ");
INSERT INTO dad_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sain ganan, modoũ fire fire bun, Jesus ilen, fonõ fonõ, taun tunĩ, taun dumeitur, tamo kayau idi maket modoũ bun dagi tamo dinenẽdin. Idi yogon gabar iri kobũ difouf nigin Jesus nonĩ difiyen. Ganan idi ĩ kobũ difen, dagi fara feledin. ");
INSERT INTO dad_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisia tamo, lo ifelnẽdiya tamo tunĩ geid, Jerusalem temeleid disi guru de fen, Jesus salili difiyen. ");
INSERT INTO dad_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Idi lo difeid mog, in dõ fiya tar tunĩ amuyẽ ado imeid kulo fiya sã saaf don. ");
INSERT INTO dad_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Farisia tamo ado Juda tamo kayau ganan, saaf kaisã to dõdig. Idi imeid ket kulo difel fen, saaf dãf, ere nigin, idi mudur adodo biyeid neid tobonunã dõ difedig. ");
INSERT INTO dad_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Idi maket bun tamal ke douf, idi saaf kaisã to dãf, idi imeid kulo de fen bagai. Idi tobonunã musei tunĩg dõ difedig, kap, darum, ketel kulo fiya age fiya.) ");
INSERT INTO dad_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Anĩ nigin, Farisia tamo, lo ifelnẽdiya tamo geid, Jesus to difiyen, “Ere nigin on dõ fiya tar, mudur adodo biyeid neid tobonunã to dõ de fen, amuyẽ ado imeid kulo fiya sã saaf dõdig?” ");
INSERT INTO dad_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus idi irokenẽdin, “Asaia ĩ, ã mala yaleya tamo nigin wogõ yen, in od tutuk, are eig ye itoton: “‘Tamo kayau enidi neid sigoredim aya selu kulõ difedig, anĩ ere, idi waud aya nigin gerõ ifaref. ");
INSERT INTO dad_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Idi aya yanau dalesedig, are ege. Idi tamo nẽ lo dogol anĩ difelnẽdidig.’ ” ");
INSERT INTO dad_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesus idi irokenẽdin, “Ã Negur nẽ ĩtãfiya utorõg fen, tamo nẽ tobonunã anĩ urougef.” ");
INSERT INTO dad_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Age ye fen, ĩ idi irokenẽdin, “Ã augeneĩ tobonunã dõ fiya nigin ge fen, ã Negur nẽ ĩtãfiya anĩ weleĩ sirin inoya keleĩ bagai! ");
INSERT INTO dad_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ere nigin, Moses iron, ‘Õ sinã tamã yeneid wales,’ ‘Aibem taka sina tama ado yeneid sane inouf, ĩ laa bun dineyẽf.’ ");
INSERT INTO dad_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Anĩ ere, ã urõgedig, tamo taka sina tama ado nigin irõf, ‘Ereb taka ã isenneĩya nigin ayam ifeneĩya, anĩ Koban’ (anĩ nẽ gariya, ‘ayam Negur afenem’), ");
INSERT INTO dad_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","anĩ bunem, ã ĩ sina tama baban isennẽdiya nigin katũ wiyẽgedig. ");
INSERT INTO dad_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Anĩ nigin, tubuĩ tar neid tobonunã anĩ waleg uroug fen, Negur nẽ od tadũ gedig. Agog fen, ã tobonunã fire fire musei ago gedig.” ");
INSERT INTO dad_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesus baban tamo kayau iweignẽdi di, wagen disi di, iron, “Ã adok aya karĩ wiyag, enei keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Safina serẽ tamal tamo namen isilef anim, tamo amuyẽ to ifenẽdig, anĩ ere, ereb taka tamo namenem wõ yef anim, ĩ amuyẽ ifenẽdig.” ");
INSERT INTO dad_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesus tamo kayau itorneĩd fen, fõ bun ile di, in dõ fiya tar, yaab od enĩ nigin ĩ to difiyen. ");
INSERT INTO dad_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesus idi irokenẽdin, “Ãg fatuk nene gef de? Ereb taka serẽ tamal tamo namen isiledig anim, amuyẽ to ifenẽdig anĩ, ã to ulegedig de? ");
INSERT INTO dad_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ere nigin, safina are tamo wau bun to iledig, anĩ ere, te namen isiledig, anenem bou dõf isil, ulõ yesidig.” (Age ye iron anĩ bunem, Jesus kurõ feis, saaf ganan amuyẽ sã yen.) ");
INSERT INTO dad_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ĩ od tobol fe fen, iron, “Ereb tamo namenem ulõ yesef anim, ĩ amuyẽ ifenẽdig. ");
INSERT INTO dad_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ere nigin, tamo waud bunem kisi sesen wõ yef, noli tobonunã, bẽ, tamo yukesiya, seseirã inoya, ");
INSERT INTO dad_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","neu mugu yeya, tobonunã sesen, idegẽya, noli kisi, kiyeĩ, ne tã bou yũya, aya aya yeya, neneya tobonunã. ");
INSERT INTO dad_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tobonunã sesen enei ganan, tamo namen tamal ulõ yesef anim, tamo amuyẽ ifenẽdig.” ");
INSERT INTO dad_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesus fonõ anĩ itor ken, Taia teneub bun ilen. Ĩ fõ taka aaben ile fen, taka nem ĩ an ibodok yeya to keleĩ youf nigin wau iron. Anĩ ere, ĩ iminkel ibodõya nigin kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Agef mog, kayau taka Jesus nigin od karĩ yen, ĩ, ne barai kaa sanem irounen anĩ isi fen, Jesus ye gariyan kubũ yen. ");
INSERT INTO dad_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kayau anĩ ĩ Grik kayau, ĩ Siria nediwon Fonisia an sina gõ fen. Ĩ, kaa sane, ne barai bun tamal iruwauf nigin Jesus nonĩ fiyen. ");
INSERT INTO dad_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus kayau irokenen, “Kesu nanaal idi ereb orodif anĩ, idi ket dãf, ere nigin, kesu nanaal neid bret yale, gaũ irarakenẽdiya, are to biya.” ");
INSERT INTO dad_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kayau anĩ solof iron, “Odug, are momoi, anĩ ere, gaũ idig, tebol farumen kesu nanaal neid saaf momout kuku re di, dõdig.” ");
INSERT INTO dad_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Age ye di, Jesus kayau irokenen, “Ago solo urok nigin, õ ule, kaa sane, nẽ barai mogo itornem.” ");
INSERT INTO dad_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Age ye di, kayau fõ bun ilen, kaa sane, ne barai itornen anĩ, fatarẽ yen mog, ilen. ");
INSERT INTO dad_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus Taia teneub itor ken, Saidon teneub atu ilen, Dekapolis teneub bun wõ ye fen, Galili maaĩwõ isilen. ");
INSERT INTO dad_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","An tamo kayau, tamo taka weder daabu leya tutuk wogõya kisi feleya sã anĩ, Jesus wagen dirou disin. Idi tamo anĩ bun, ima teten inouf nigin Jesus nonĩ difiyen. ");
INSERT INTO dad_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus, ĩ tamo kayau atun yale, firen irou ile fen, in ima gege, tamo anĩ nẽ weder kur inodin. Agef fen, Jesus salina ira ken, tamo anĩ nẽ bale kobũ fen. ");
INSERT INTO dad_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesus saa ilun itad fen, si odug yale fen, ĩ irokenen, “Efata!” (anĩ nẽ gariya, “Fokõ weid!”). ");
INSERT INTO dad_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kaisã bagai, tamo nẽ weder fokõ yedin, in bale karika le di, ĩ od atata fel wogõ yen. ");
INSERT INTO dad_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus, taka irokenẽya nigin idi katũ fiyẽdin. Ĩ baba baban irokenẽdin, anĩ ere, musei wogõ def dilen. ");
INSERT INTO dad_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tamo kayau idi odug biya terẽ de fen, idi diron, “Ĩ ereb ereb ganan biya dogol age fen. Ĩ age fe di, weder daabuya karĩ yef, sigor ifokeleya wogõ yef.” ");
INSERT INTO dad_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sain anĩ bun, baban tamo kayau musei guru difen. Idi ereb taka yõya nigin san, anĩ nigin, Jesus in dõ fiya tar ĩ garan iweig laisi fen, irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Aya tamo kayau enidi waud inaf, idi mogo aya geid, naa towo ereb taka yõya sã. ");
INSERT INTO dad_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aya idi naũ ado fonõ susur afouf are, idi luwen kuku douf, ere nigin, idi tunĩ egerõ temeleid disin.” ");
INSERT INTO dad_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","In dõ fiya tar aiten dale, Jesus dirokenen, “Gerere tuan eig fiya, taka nem bret kisi feleya nain yale fen, idi ifenẽdiyouf?” ");
INSERT INTO dad_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus to fedin, “Bret ganĩ ã ado?” Idi diron, “Sewen dogol.” ");
INSERT INTO dad_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesus tamo kayau tenebur dibodadãf nigin irokenẽdin. Agef fen, Jesus bret sewen geif iroun, ĩ Negur de fiye ken, bret anĩ mumã feid fen, tamo kayau wagedin dinouf nigin, in dõ fiya tar ifenẽdi di, idi age difen. ");
INSERT INTO dad_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Idi gau nanaaleg teke tekelei adon. Ĩ gau anidi nigineg Negur de fiye ken, idi gadõ difediyouf nigin in dõ fiya tar irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tamo kayau don kisi felen. Dum in dõ fiya tar, tamo kayau bret dokon, tunĩ ditoraran anĩ fito difen, karam sewen isokosen. ");
INSERT INTO dad_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tamo fo tausen age fiya an difaren. Anĩ Jesus idi, nedi fonõ fonõ sur fedi di, ke de dilen. ");
INSERT INTO dad_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Agef fen, Jesus in dõ fiya tar geid, waag bun sosõ de fen, Dalmanuta distrik dilen. ");
INSERT INTO dad_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisia tamo disi, Jesus kisi difiye ken, saa ilun nẽ uris dilouf nigin to difiyen. ");
INSERT INTO dad_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ĩ si odug yale fen, iron, “Ere nigin tamo kayau sain enĩ bun difaref eneidi, uris nigin aya to difiyaf? Aya ã momoi arokeneik, uris taka idi to dalouf.” ");
INSERT INTO dad_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Age ye fen, ĩ idi itorneĩd, waag bun kel sõ ye, maaĩ sitakã ibal ilen. ");
INSERT INTO dad_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","In dõ fiya tar bret taka to dalen, wedereid tu kelen. Bret tekelei dogol waag bun idi adon. ");
INSERT INTO dad_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus idi wedereid iroun, “Ã, Farisia tamo geid Herod geneid yis nigin lo welegei.” ");
INSERT INTO dad_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","In dõ fiya tar idi dogo dogol katõ de fen, diron, “Ada bret sã nigin age yel.” ");
INSERT INTO dad_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Idi neid wogõya Jesus kelei ken, idi to fedin, “Ere nigin ã bret to urougel nigin wogõ gef? Ã fau ileya sã, wedereĩ fokõya sã de? Ãgenei wauĩ totol bagai lef de? ");
INSERT INTO dad_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ã meleĩ ado, anĩ ere, ã to ulegedig de? Ã wedereĩ ado, anĩ ere, ã to karĩ gedig de? Ã to karĩ welegef de? ");
INSERT INTO dad_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sain aya bret faif, faif tausen tamo nigin mumã afen, ã karam ganĩ bun, bret tunĩ kuru ge di, isokosen?” Idi aiten dalen, “Karam tuwelf.” ");
INSERT INTO dad_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sain aya bret sewen, fo tausen tamo nigin mumã afen, ã karam ganĩ bun, bret tunĩ kuru ge di, isokosen?” Idi aiten dalen, “Karam sewen.” ");
INSERT INTO dad_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesus idi irokenẽdin, “Ã fau to kisi fokõ yef de?” ");
INSERT INTO dad_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Idi Betsaida disin. An tamo kayau tunĩ, tamo taka mala ifofakeleya diroule fen, Jesus imam kobũ fiyẽf nigin nonĩ difiyen. ");
INSERT INTO dad_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus, tamo mala ifofakeleya ima yale, sibof, fonõ dumeitur dilen. Agef fen, ĩ tamo mala bun salina ira ken, ima tamo mala bun ino fen, to fiyen, “Ere tau ulef?” ");
INSERT INTO dad_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ĩ mala fara fel fen, iron, “Aya tamo kayau ailedif, idi aa gegen diyokesif.” ");
INSERT INTO dad_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus baban in ima, tamo mala bun inon. Age fe di, tamo mala fara fele di, tutuk kelẽ yelen. Ereb ereb ganan ĩ yaor iledin. ");
INSERT INTO dad_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus tamo anĩ in fõ bun sur fiye ken, irokenen, “Fonõ atu to ulauf.” ");
INSERT INTO dad_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus in dõ fiya tar geid, Sisaria Filipai nediwon fonõ fonõ diyok dilen. Naabur ĩ to fedin, “Tamo kayau idi, aya nigin ai dedig?” ");
INSERT INTO dad_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Idi diron, “Tunĩ dirok, Jon naan igunẽdiya tamo; tunĩ dirok, Eliya; tunĩ dirok, profet anidi taka.” ");
INSERT INTO dad_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesus to fedin, “Ba ã uleg? Aya nigin ã ai gef?” Pita aiten yale iron, “Õ anĩ Kristus.” ");
INSERT INTO dad_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Age ye di, Jesus ĩ nigin taka to dirokenẽf nigin, idi wedereid iroun. ");
INSERT INTO dad_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Age ye fen, Jesus gariya ino, idi ifelneĩd fen, irokenẽdin, Tamo Naal ĩ, darau musei yale fen, mudur adodo, pris odudug, lo ifelnẽdiya tamo idim dudum difiyẽf. Age de fen, ĩ dukesi di, naa towo bure fele di, kel fã youf. ");
INSERT INTO dad_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus od anĩ kurõ fesi di, Pita Jesus yale, yerin irou ile, ou fiyen. ");
INSERT INTO dad_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Age fe di, Jesus falei yel, in dõ fiya tar lo feid fen, ĩ Pita ou fiyen. Ĩ iron, “Satan! Dumeun ule. On kisi are Negur nẽ sã, on kisi tamo nẽ dogol.” ");
INSERT INTO dad_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Age ye fen, Jesus, tamo kayau in dõ fiya tar geid iweigneĩd fen, irokenẽdin, “Aib taka aya dõ fiyau fenẽ, ĩ yogon oroya lai fesil fen, yogon aa tetek faali fe, aya dõ fiyauf. ");
INSERT INTO dad_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ere nigin, aib taka yogon bouwa buru mata ibodõf nigin oro fef, are fõ yalauf, anĩ ere, aib taka yogon mata bouwa buru, aya nigin ado biya od nigin ye fen, irailauf, are kel yalouf. ");
INSERT INTO dad_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tamo taka ĩ, teneub enĩ ganan kakarai fe, akorou ye fen, in malakanon irailauf, ere biya ĩ yalouf? ");
INSERT INTO dad_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Takag, tamo taka, yogon malakanon nigin ere mala solof fen, ĩ kel yalouf? ");
INSERT INTO dad_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aib taka, seseirã inoya, mosor inoya nẽ tamo kayau eneidi bun, aya nigin ado neu od nigin mama fouf are, sain Tamo Naal in engel fateul geid, Tama nẽ fula fiya medeĩya ado disiyouf bun, ĩg ĩ nigin mama fouf.” ");
INSERT INTO dad_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Age ye fen, ĩ idi irokenẽdin, “Aya ã momoi arokeneik, tunĩ ein difaref, fau to gare de mog, idi Negur nẽ tano megeir ado isi mog, dilouf.” ");
INSERT INTO dad_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Naa sigis bure fele di, Jesus, Pita, Jems, Jon anidi geif fen, idi mugu arei odug ilun diselen. An Jesus idi meleid bun bouwa falei felen. ");
INSERT INTO dad_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","In kolos lalau medeĩya bagai, lalau anĩ tenebur ein taka nem kulo fe di, agef filiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Agef mog, an idi meleid bun, Moses Eliya ado wowã de fen, Jesus weim wogõ den. ");
INSERT INTO dad_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita Jesus irokenen, “Rabi, ada ein ibodõya nigin biya bagai. Ada salafat towo tanouf, taka ogon, taka Moses nẽ, taka Eliya nẽ.” ");
INSERT INTO dad_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ĩ wogõya tata fen, ere nigin, idi fatuk bagai kumĩ den.) ");
INSERT INTO dad_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Agef mog, lalo isi, idi kerub feid fen, ait taka lalo bunem wõ yen, “Eĩ neu Kesu, ĩ nigin aya wau laa fedig. Ĩ karĩ wiyẽg!” ");
INSERT INTO dad_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kaisã bagai, idi fai den, aib taka to weim difar mog, dilen, Jesus dogol. ");
INSERT INTO dad_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Idi arei nem diyok disi fen, Jesus ereb idi dilen anĩ, Tamo Naal laa bun tamal fau fãya sã mog, taka to dirokenẽf nigin, idi katũ fedin. ");
INSERT INTO dad_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Idi od anĩ dogo bun dogol ibod ken, ‘laa bun tamal kel fãya’ anĩ nẽ gariya nigin katõ difen. ");
INSERT INTO dad_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Age de fen, idi Jesus to difiyen, “Ere nigin lo ifelnẽdiya tamo, ‘Eliya ĩ ket uyu isi di, Mesia isiyouf,’ dedig?” ");
INSERT INTO dad_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus aitedin yalen, “Momoi bagai, Eliya ket uyu isi fen, ereb ereb ganan madur fedif. Anĩ ere, ere nigin Tamo Naal ĩ darau musei yale fen, dudum difiyẽf anĩ, Negur nẽ Itotoya bun ibodok? ");
INSERT INTO dad_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Anĩ ere, aya ã arokeneik, Eliya mogo isin, ĩ nigin Negur nẽ Itotoya bun yenek gen, ereb ereb ganan idi waud iron, ĩ nigin mogo age difen.” ");
INSERT INTO dad_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sain idi, in dõ fiya tar tunĩ ganan geredin disi fen, tamo kayau musei, idi salili difiyeĩd fen, lo ifelnẽdiya tamo geid, od nem abob fe fe de mog, diledin. ");
INSERT INTO dad_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kaisã bagai, tamo kayau ganan Jesus isi mog, dile fen, idi fatuk bagai terẽ den, aan difiyẽf nigin gududu de dilen. ");
INSERT INTO dad_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus idi to fiyẽdin, “Ã ere nigin idi geid, od nem abob fe fe gef?” ");
INSERT INTO dad_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Guru fiya atun, tamo takam aiten yale iron, “Tise, aya neu kesu, õ gein arou asil, ĩ kaa sanem irou di, ait ifokelen. ");
INSERT INTO dad_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sain ganan kaa sanem irouf, ĩ yũ irã di, tenebur kubũ ye, sali mokuf, gobora kikokõ ye fen, bouwa teregein yedig. Aya on dõ fiya tar kaa sane diruwauf nigin to afedin, anĩ ere, idi kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus solof iron, “Tamo kayau eneidi momoiya sã, sain ganĩ aya ã geid tabodõf? Sain ganĩ aya ã nigin wau aukesilauf? Kesu wageun urousig.” ");
INSERT INTO dad_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Age ye di, idi kesu anĩ, ĩ garan dirou disi di, kaa sane Jesus ile fen, kaisã bagai kesu yũ iran. Kesu ĩ tenebur kubũ ye, wele yef, yen ken, awa bun sali moku fen. ");
INSERT INTO dad_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus kesu nẽ tama to fiyen, “Sain ganĩ ĩ eig fiya ibodon?” Ĩ aiten yale iron, “Ĩ kesu naalun gariya inon. ");
INSERT INTO dad_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sain musei, ĩ yukesiyou fenẽ nigin yã bun ado naanũ irãdig. Anĩ ere, õ ereb taka age fiya nigin kisi feleyauf are, amã nigin waũ ino ken, usennamã.” ");
INSERT INTO dad_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus ĩ irokenen, “‘Õ kisi feleyauf,’ wof de? Taka ĩ momoi youf, ereb ereb ganan age fiya nigin kisi feleya.” ");
INSERT INTO dad_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kaisã bagai, kesu nẽ tama iweig iron, “Aya momoi auf, neu momoiya naal nigin usenna!” ");
INSERT INTO dad_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Age ye di, tamo kayau gududu de disi mog, anĩ Jesus ileid fen, ĩ kaa sane ou fiyen. Ĩ iron, “Õ daabuya ait ifokeleya kaa, aya õ arokonok, ĩ bun tamal ulõ weis fen, baban ĩ namen to kel ulauf.” ");
INSERT INTO dad_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kaa anĩ ui ye fen, kesu yũ irã di, fatuk bagai tererẽ ye mog, ulõ yeis ilen. Lo difen, kesu laa gen yenẽ di, musei diron, “Ĩ laa fel.” ");
INSERT INTO dad_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Anĩ ere, Jesus kesu anĩ ima irou fen, yalesnẽ di, ĩ ifaren. ");
INSERT INTO dad_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesus ĩ aaben ile ibod mog, in dõ fiya tar mugun ĩ to difiyen, “Ere nigin amã kaa sane iruya nigin kisi feleya san?” ");
INSERT INTO dad_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Age de di, ĩ irokenẽdin, “Eig fiya are, Negur kosẽ fiyẽya bunem dogol iyawauf.” ");
INSERT INTO dad_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Idi modoũ anĩ ditor ken, Galili distrik atu diyok dilen. Taka nem idi an yeya karĩya nigin, Jesus to oron, ");
INSERT INTO dad_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ere nigin, ĩ in dõ fiya tar ifelnẽdin. Ĩ idi irokenẽdin, “Tamo Naal ĩ, fau kiwai tamo imeid bun dinouf. Idi fau ĩ dukesiyouf, naa towo bure fele di, ĩ fau kel fã youf.” ");
INSERT INTO dad_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anĩ ere, idi od enĩ nẽ gariya nene de fen, ĩ to fiya nigin kumĩ den. ");
INSERT INTO dad_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Idi Kapenaum taun disin. Jesus fõ bun ibod ken, ĩ idi to fedin, “Ã naabur ere luwa urougel?” ");
INSERT INTO dad_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Anĩ ere, idi foro firi delen, ere nigin, naab luwen, aim anĩ idi atun odug bagai ibodok nigin luwa diroun. ");
INSERT INTO dad_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus ibod ken, in dõ fiya tar tuwelf iweig laisi fen, iron, “Taka ĩ uyu ifarau fenẽf, ĩ gai dumen bagai youf. Agef fen, ĩ ganan neid kabĩ tamouf.” ");
INSERT INTO dad_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ĩ kesu naal taka yale iroule, idi atun ifarnen. Ĩ imam yale koboi fiye ken, ĩ idi irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aib taka aya yanau bunem, kesu naal eig fiya taka yalef are, ĩ aya yaleyaf. Aib taka ĩ aya yaleyaf are, ĩ aya dogol to yaleyaf, ĩ aya sur fiyan anĩg yalef.” ");
INSERT INTO dad_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon iron, “Tise, tamo taka, õ yanã nem kaa sesen iruid mog, amã mailen. Anĩ nigin, amã ĩ katũ mafiyen, ere nigin, ĩ neda takam sã.” ");
INSERT INTO dad_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Anĩ ere, Jesus iron, “To katũ wiyẽg, taka ĩ neu yanau nem memelik inof are, ĩ kaisã bagai aya nigin sane irõya kisi feleya sã, ");
INSERT INTO dad_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ere nigin, taka ĩ ada nigin kiwai to inof, are neda. ");
INSERT INTO dad_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aya ã momoi arokeneik, taka ĩ, aya yanau nem, ã Kristus nẽ nigin ye fen, kap naan ado ifeneĩf are, ĩ in mala solo momoi bagai yalouf. ");
INSERT INTO dad_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Aibem taka age fe di, kesu aya nigin momoi def enidi taka, mosor bun ineyẽf are, tamo anĩ meein odug guyutu bun ifo ken, maaĩwõ irãyam, are dem. ");
INSERT INTO dad_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ogon imam mosor bun ineyõf, gudũ wol. Õ imã tobega ado, mata bun ileya nigin biya bagai, ere nigin, ima totoũ adouf are, hel bun an yã faimud ibodkeleyan uleya nigin. ");
INSERT INTO dad_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Age fiya gen, ogon yẽ anim, mosor bun ineyõf, gudũ wol. Õ yẽ tobega ado mata bun ileya nigin biya bagai, ere nigin, yẽ totoũ adouf are, hel bun dirãyõf. ");
INSERT INTO dad_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Takag, ogon malã anim, mosor bun ineyõf, ubodol uraile. Õ malã tekelei ado Negur nẽ tano bun ileya nigin biya bagai, ere nigin, malã totoũ adouf are, hel bun dirãyõf, ");
INSERT INTO dad_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","an “‘idi neid mamat to gare dedig, yãg to gare feledig.’ ");
INSERT INTO dad_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tamo ganan, yã tetedin sol gen tu difouf. ");
INSERT INTO dad_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sol ĩ biya, anĩ ere, in kai sa kalauf, naig wo di, baban kai youf? Ã aug bun sol adouf, agog fen, abob nigin wau inosiya bun ubodõgouf.” ");
INSERT INTO dad_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus modoũ anĩ itor ken, Judia distrik nẽ akor anĩ atu ile, Jordan naan sitakã ilen. Baban tamo kayau mala odug ĩ wagen disi di, ĩ gai age fedig gen, od ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisia tamo tunĩ disi, kisi difiye ken, to difiyen, “Tamo taka yogon kayau iruf anĩ, are lo dõ fiya de?” ");
INSERT INTO dad_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ĩ aitedin yale iron, “Moses, anĩ nigin ere od wogõ yein?” ");
INSERT INTO dad_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Idi diron, “Moses yo yen, are tamo bagu fiya anĩ fara fiya pepa itot fen, kayau od sã iru di, ilauf, yen.” ");
INSERT INTO dad_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus idi irokenẽdin, “Moses lo anĩ itotkenein, ere nigin, ãgenei wauĩ totol bagai agef yeneĩd. ");
INSERT INTO dad_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Anĩ ere, gariya bun Negur ereb ereb ino fen, ‘tamo ino, kayau ino fen.’ ");
INSERT INTO dad_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Age fiya nigin, tamo ĩ in sina tama itorneĩd fen, in kayau ado bagu difouf, ");
INSERT INTO dad_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","age fe di, idi uruwom bouweid tekelei youf.’ Age dife di, idi uru sã, idi tekelei. ");
INSERT INTO dad_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anĩ nigin, ereb Negur bagu fedin anĩ, tamom to fara fouf.” ");
INSERT INTO dad_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sain idi baban fõ bun dibod ken, in dõ fiya tar od enĩ nigin Jesus to difiyen. ");
INSERT INTO dad_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus idi irokenẽdin, “Aib taka in kayau iru fen, kayau taka yalouf, ĩ kayau tubu morõ ifen ken, seseirã inouf. ");
INSERT INTO dad_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Age fiya bagai, kayau taka in aiwa itorne ken, tamo taka yalouf are, ĩ seseirã inouf.” ");
INSERT INTO dad_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tamo kayau, kesu nanaal Jesus wagen kobũ fediyouf nigin guri difeid disin, anĩ ere, in dõ fiya tar, idi ou difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus anĩ ile fen, wau sanen. Ĩ idi irokenẽdin, “Utornẽdig len, kesu nanaal aya wageun disiyouf, idi to katũ wedig, ere nigin, Negur nẽ tano are eig fediya neid. ");
INSERT INTO dad_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aya ã momoi arokeneik, aib taka ĩ, Negur nẽ tano kesu naal age fiya gen to yalouf are, ĩ namen to bagai ilauf.” ");
INSERT INTO dad_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Age ye fen, ĩ kesu nanaal koboi feid fen, in ima tetedin ino fen, el fiya ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus mogo naab iyok ile mog, tamo taka ĩ garan gudu ref isel, wagen kubũ ye, ibor bobou fe fen, ĩ to fiyen, “Tise biya, aya ere naig afouf anĩ, mata faimud ibodkeleya alouf?” ");
INSERT INTO dad_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus ĩ irokenen, “Ere nigin õ aya anĩ biya wiyaf? Aibem taka biya sã, Negur yogo dogol. ");
INSERT INTO dad_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Õ ĩtãfiya keleĩ: ‘Õ tamo taka to ukesiyouf, õ to seseirã unouf, õ to bẽ walouf, õ taka nigin idegẽya od to urõf, õ idegẽya bunem safina to walouf, sinã tamã sigoreid dõ wouf.’ ” ");
INSERT INTO dad_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ĩ Jesus irokenen, “Tise, enei ganan, aya kesu naalun dõ afef asin.” ");
INSERT INTO dad_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus ĩ lof ile, ĩ nigin wau laaf fen, iron, “Tekelei anĩ õ inĩ sã. Ule, ogon safina ganan na nigin sur wo fen, maleg tamo weneĩd, agouf anĩ, õ saa ilun safina biya adouf. Ago wol fen, usi, aya dõ wiya.” ");
INSERT INTO dad_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Od anĩ bunem, nawa kuru kele fen. Ĩ wau morõ ado ilen, ere nigin, ĩ safina musei ado. ");
INSERT INTO dad_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus falei yel fen, in dõ fiya tar irokenẽdin, “Safina musei ado tamo, Negur nẽ tano bun ileya nigin gai malai bagai!” ");
INSERT INTO dad_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","In dõ fiya tar, in od anĩ nigin terẽ den. Anĩ ere, Jesus baban iron, “Nau kesu tar, Negur nẽ tano bun ileya nigin gai malai bagai! ");
INSERT INTO dad_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel ĩ gabar iwaya nil ku bun ileya nigin karika bagai, safina musei ado tamo Negur nẽ tano bun ileya nigin malai bagai.” ");
INSERT INTO dad_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Od anĩ bun, in dõ fiya tar fatuk bagai terẽ de fen, abob toti difen, “Age fiyauf are, aim anĩ mata ibodkeleya yaleya kisi feleya?” ");
INSERT INTO dad_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus idi lo feid fen, iron, “Tamo bun are kisi feleya sã, anĩ ere, Negur bun kisi feleya. Ereb ereb ganan Negur bun kisi feleya.” ");
INSERT INTO dad_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita Jesus irokenen, “Amã ereb ereb ganan mator ken, õ dõ mayok!” ");
INSERT INTO dad_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus solof iron, “Aya ã momoi arokeneik, aib taka fõ, tura tar, main tar, sina, tama, gere tar be, kabĩ, aya nigin ado biya od nigin itoron, ");
INSERT INTO dad_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ĩ mala solo wan handred wal fiya, sain enĩ bun, (fõ, tura tar, main tar, sina tar, gere tar, kabĩ anidi ado morõg) yalouf, ĩ dumen isiyouf buneg mata faimud ibodkeleya yalouf. ");
INSERT INTO dad_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Anĩ ere, musei malabag dibodok, idi dumen dibodõf; musei dumen dibodok, idi malabag dibodõf.” ");
INSERT INTO dad_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus uyu irou fen, idi Jerusalem naab diselen. Age fe di, in dõ fiya tar idi terẽ de mog, idi dõ difedin anĩ kumĩ den. Baban Jesus in dõ fiya tar tuwelf firen gou feid fen, ĩ fau bouwa bun ere wõ youf anĩ irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesus iron, “Ada Jerusalem teselef, an Tamo Naal ĩ pris odudug, lo ifelnẽdiya tamo imeid bun dinenẽf. Idi ĩ laa fouf nigin bouwa bun od dũf. Age de fen, idi ĩ haiden Juda sã anidi imeid bun dino di, ");
INSERT INTO dad_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","idi ketẽ difiyẽf, disisnẽf, wagĩ difiye ken, dukesiyouf. Naa towo bure fele di, ĩ kel fã youf.” ");
INSERT INTO dad_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi gere tar, Jems Jon ado, Jesus wagen disin. Idi diron, “Tise, amã ereb taka nigin to mafe di, õ agouf anĩ oromak.” ");
INSERT INTO dad_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesus idi irokenẽdin, “Ã ere anĩ, aya age afeneĩf nigin oroyeik?” ");
INSERT INTO dad_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Idi aiten dale diron, “Ogon fula fiya medeĩya bun, amã taka ogon ima biyalẽ ibodõ di, taka ogon ima kilẽ ibodõf anĩ oromak.” ");
INSERT INTO dad_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus idi irokenẽdin, “Ã ereb to gef anĩ nẽ gariya ã keleĩ sã, aya naan ãf anĩ, ã yõya kisi feleya de? Agef mã, naan aya agũf anĩ, ã igũya kisi feleya de?” ");
INSERT INTO dad_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Idi aiten dale diron, “Amã kisi feleya.” Age de di, Jesus idi irokenẽdin, “Naan aya ãf are, ã wãgauf, naan aya agũf are, ã ugũgouf, ");
INSERT INTO dad_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","anĩ ere, imau biyalẽ ibodõya, kilẽ ibodõya are, ayam ifenẽya kisi feleya sã. Modoũ anidi are, idi nigin saika fen anidi neid.” ");
INSERT INTO dad_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","In dõ fiya tar ten od anĩ karĩ de fen, Jems Jon ado nigin seye den. ");
INSERT INTO dad_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesus idi iweig laisi fen, iron, “Ã keleĩ, haiden neid uyu irouya def anĩ, tamo kayau lo fiya nigin totol dinodig, idi dogo neid odudug, idi aruneid dalouf nigin megeir dinodig. ");
INSERT INTO dad_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ã bun kisi to agef yenẽf, ã atun, aib taka odug ibodõf nigin orof, ĩ ãgenei kabĩ tamo ibodõf. ");
INSERT INTO dad_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aib taka uyun ibodõf nigin orof, ĩ ganan neid ferfer ouf. ");
INSERT INTO dad_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ere nigin, Tamo Naal ĩg disennẽf nigin to isin, anĩ ere, ĩ tamo kayau isenneĩd fen, tamo kayau musei idi neid mosor anĩ fotokar, yogon mata ifenẽdiyouf nigin isin.” ");
INSERT INTO dad_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Age de fen, idi Jeriko disin. Jesus, in dõ fiya tar, tamo kayau mala odug geid, taun anĩ ditor dile mã, tamo taka mala ifofakeleya, Bartimeus (Timeus naal), ĩ naab yerin nonĩ yef ibodon. ");
INSERT INTO dad_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sain ĩ Jesus Nasaret tamal yeya anĩ karĩ ye fen, ĩ iweig iron, “Jesus, Dawid Naal, aya nigin malalon yõ!” ");
INSERT INTO dad_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Age ye di, tamo musei sakã difiye ken, foro yalauf nigin dirokenen, anĩ ere, ĩ wade bagai iweig iron, “Dawid Naal, aya nigin malalon yõ!” ");
INSERT INTO dad_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus dẽ yel fen, iron, “Uweignẽg.” Age ye di, idi tamo mala ifofakeleya diweignen, “Waũ el fe fen, fã wale! Ĩ õ iweignok.” ");
INSERT INTO dad_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Age de di, ĩ yogon gabar sirilẽ iraile fen, fã yale, Jesus wagen isin. ");
INSERT INTO dad_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus ĩ to fiyen, “Aya õ ere age afonõf ani, õ oroyok?” Tamo mala ifofakeleya iron, “Rabi, aya kelẽ au fenẽ.” ");
INSERT INTO dad_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus iron, “Ule, ogon momoiya anim el yom.” Kaisã bagai, ĩ kelẽ yel fen, Jesus dõf, naab dilen. ");
INSERT INTO dad_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Idi Jerusalem kelẽ difiye ken, Moul Arei bun Betfage Betani ado wõ den, Jesus in dõ fiya tar uru sur feid fen, ");
INSERT INTO dad_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ĩ idi irokenẽdin, “Fonõ wageik anĩ bun uleg, an wõg fen, donki naal difon anĩ ulogouf, are aibem taka anĩ bun to iyon. Anĩ biru weleg fen, ein urou usig. ");
INSERT INTO dad_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Taka nem to yeĩf, ‘Ere nigin ã enĩ ago gef?’ youf are, urokenẽgouf, ‘Odug orof nigin, fau mogo kaisã ein kel sur fouf.’” ");
INSERT INTO dad_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Idi dile, donki naal naabur bobog ileyan difokelen ifar mog, fotou difen. Idi biru de mog, ");
INSERT INTO dad_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tamo tunĩ an difaren anidim to difedin, “Ã ere naig gouf nigin, donki naal anĩ biru gef?” ");
INSERT INTO dad_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Idi Jesus irokenẽdin kilei, solo de dirokenẽdin. Age de di, tamo ditornẽdi di, dilen. ");
INSERT INTO dad_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Idi donki naal anĩ Jesus wagen dirousi fen, idi neid gabar teten dirarã di, ĩ anĩ teten ibodon. ");
INSERT INTO dad_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tamo kayau musei, idi neid gabar naabur du difedin, age de mog, tunĩ idi kabier aa were aarau ado kokour difedin anĩ du difedin. ");
INSERT INTO dad_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tamo kayau uyu dilen ado dume dõ difen, kakaĩ de diron, “Hosiana!” “Odug yana bunem isif, are ĩ el fiyek!” ");
INSERT INTO dad_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Neda tamada Dawid nẽ tano isif, are el fiyek!” “Hosiana, ilun bagai!” ");
INSERT INTO dad_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus Jerusalem wõ ye fen, tempel ilen. Ĩ ereb ereb ganan kii fedin, anĩ ere, sain bure felen nigin, ĩ in dõ fiya tar tuwelf geid Betani dilen. ");
INSERT INTO dad_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","We fele di, idi Betani ditor dile fen, Jesus naũ fen. ");
INSERT INTO dad_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ĩ mala ira kel, aa fig aarau ile fen, ĩ faat ado be ye mã, ilouf nigin ilen. Ĩ non ilen, faat taka to ilen, aarau dogol, ere nigin, imaya sain sã. ");
INSERT INTO dad_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Age fiya ile fen, ĩ aa irokenen, “Taka nem õ bun faat baban to yãf.” Agef irõ mog, in dõ fiya tar karĩ den. ");
INSERT INTO dad_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem wõ de fen, Jesus tempel modoũ namen ile, na dale dile disi dife mog, an irudidin. Ĩ moni solo fediya neid tebol ado, kuburir na nigin sur fediya neid bens eleg feledin. ");
INSERT INTO dad_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tamo ganan, tempel modoũ bun safina na nẽ iroulediya nigin katũ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Agef fen, Jesus ifelneĩd iron, “‘Neu fõ, teneub ganan nẽ kosẽya fõ douf,’ are Negur nẽ Itotoya bun to yenek de? Anĩ ere, ã ‘bẽ tamo neid iminẽya fõ’ unogen.” ");
INSERT INTO dad_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Age ye di, pris odudug, lo ifelnẽdiya tamo geid, od enĩ karĩ de fen, Jesus dukesiyouf nigin naab dimiren. Idi Jesus kumĩ difiyen, ere nigin, tamo kayau ganan in ifelnẽdin anĩ nigin terẽ den. ");
INSERT INTO dad_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aragau di, idi taun anĩ ditor dilen. ");
INSERT INTO dad_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Bonimei idi naab diyok dile fen, idi aa fig warei bunem gariri kelen anĩ dilen. ");
INSERT INTO dad_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita weder fokõ yel fen, Jesus irokenen, “Rabi, ulef! Õ aa fig usisin, are gariri kelen!” ");
INSERT INTO dad_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Age ye di, Jesus solof irokenẽdin, “Negur bun momoi wogei. ");
INSERT INTO dad_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aya ã momoi arokeneik, aibem taka arei enĩ irokenẽf, ‘Õ kusu urã, maaĩwõ usil,’ age ye fen, ĩ wau to uru fen, momoi aya orok anĩ agef wõ youf, youf are, agef dõ fenẽf. ");
INSERT INTO dad_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Anĩ nigin, aya ã arokeneik, ereb taka nigin ã kosẽ bun tog fen, mogo malel ge, momoi gouf, are ãgenei youf. ");
INSERT INTO dad_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sain ã ufareg kosẽg fen, ã takan nẽ sane nigin wauĩ bun yenẽf are, wedereĩ tu kalauf. Ago ge di, ãgenei Temeĩ saa tanon ibodok, ãgenei mosor nigin weder tu kalauf.” ");
INSERT INTO dad_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Idi baban Jerusalem wõ den, Jesus tempel fofomalan iyok ile mog, pris odudug, lo ifelnẽdiya tamo, mudur adodo geid, ĩ wagen disin. ");
INSERT INTO dad_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Idi Jesus to difiyen, “Ere igirĩya bunem, õ ereb ereb enĩ ago wof? Aim õ enĩ agouf nigin igirnon?” ");
INSERT INTO dad_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus aitedin yale iron, “Aya to fiya tekelei afeneĩf. Solog urokanage di, ereb igirĩya bunem ereb ereb enĩ age afef anĩ, aya ã arokeneĩf. ");
INSERT INTO dad_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon naan igunẽdin, are saa ilun tamal de, tamo bunem? Urokanag!” ");
INSERT INTO dad_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Idi dogo dogol katõ de fen, diron, “Ada, ‘Saa ilun tamal,’ tauf, ĩ to fouf, ‘Age fe di, ere nigin, ã ĩ nigin to momoi gen?’ ");
INSERT INTO dad_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Anĩ ere, ada, ‘Tamo bunem,’ tauf…” (Idi tamo kayau kumĩ difedin, ere nigin, tamo ganan, Jon ĩ momoi bagai profet den.) ");
INSERT INTO dad_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Anĩ nigin, idi Jesus ait solo de diron, “Amã keleĩ sã.” Age de di, Jesus iron, “Ayag ã to arokeneĩf, ereb igirĩya bunem aya ereb ereb enĩ age afedif.” ");
INSERT INTO dad_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Age ye fen, Jesus yaab od nem idi irokenẽdin, “Tamo taka wain kabĩ yalen. Ĩ kau ifõ kalĩ felen, wain sumin asi fiya nigin ku yalen, kabĩ lo fiya tamo neid fõ inon. Agef fen, ĩ mala solo yalouf nigin wain kabĩ, kabĩ tamo tunĩ imeid bun ino fen, uyu takã ilen. ");
INSERT INTO dad_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Fito fiya sain, ĩ, kabĩ tamo taka, wain kabĩ lo fiya tamo gedin, wain biya tunĩ, idi bun gei fouf nigin sur fen. ");
INSERT INTO dad_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Anĩ ere, idi ĩ dale, du ken, sur difiyẽ di, ima sãsã ilen. ");
INSERT INTO dad_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Age dife di, ĩ kabĩ tamo taka idi gedin sur fen. Idi tamo anĩ mudur bun du ken, mama difenẽ di, ilen. ");
INSERT INTO dad_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ĩ baban takag sur fen, areg idi dukesin. Ĩ musei tunĩg sur fedin, age fe di, tunĩ diden ken, tunĩ didenkesin. ");
INSERT INTO dad_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ĩ gama tekelei dogol sur fiya nigin ibodon, are yogo naal, ĩ yogon oboi bagai. Ĩ anĩ dumen bagai sur fiye ken, iron, ‘Idi neu kesu anĩ karĩ difiyẽf.’ ");
INSERT INTO dad_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Anĩ ere, kabĩ lo fiya tamo, idi abob dirokenen, ‘Eĩ ĩ akorouf. Usig, ada ĩ tau keis fen, akor eĩ nedauf.’ ");
INSERT INTO dad_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Anĩ nigin, idi ĩ dale, dukeis fen, wain kabĩ dumeitur diran. ");
INSERT INTO dad_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Age dife di, wain kabĩ marau naig fouf? Ĩ isi, kabĩ lo fiya tamo idenkeis fen, wain kabĩ anĩ tamo tunĩ ifenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ã Negur nẽ Itotoya enĩ to uwesegen de? “‘Meein are fõ inoya tamom sane de fen, ditoron, meein anĩ gama monog tor wõ yen, ");
INSERT INTO dad_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","anĩ Odug yogo age fe di, malamã yũ yalen.’ ” ");
INSERT INTO dad_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Age ye di, pris odudug, lo ifelnẽdiya tamo, mudur adodo geid, Jesus irounẽya nigin naab dimiren, ere nigin, idi kelein, ĩ idi nigin yaab od wogõ yen. Anĩ ere, idi tamo kayau nigin kumĩ de fen, idi ĩ ditornẽ dilen. ");
INSERT INTO dad_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dum idi, Farisia tamo tunĩ, Herod nẽ tamo tunĩ geid, Jesus garan in od bun kũ fenẽ di, dirounẽf nigin sur difedin. ");
INSERT INTO dad_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Idi ĩ garan disi fen, diron, “Tise, amã keleĩ, õ momoi wogõya nẽ tamo. Õ tamom to wewu diyõdig, ere nigin, õ idi yeneid ado be, sã anĩ to es wedidig. Ago fen, õ momoi bagai Negur nẽ naab ufelnamãdig. Sisa takis ifenẽya nigin biya de, sã? ");
INSERT INTO dad_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Amã mafenẽf de, sã?” Anĩ ere, Jesus idi neid namedin kisi sane kelei ken, iron, “Ere nigin ã aya nigin kor unogef? Koin moni taka urousig len, aya ailau fenẽ.” ");
INSERT INTO dad_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Idi koin moni taka dirousi di, ĩ idi to fedin, “Eĩ ai nẽ malakanon? Eĩ ai yana nẽ itotoya?” Idi aiten dale diron, “Sisa nẽ.” ");
INSERT INTO dad_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Age de di, Jesus idi irokenẽdin, “Sisa nẽ are Sisa wenẽg, Negur nẽ are Negur wenẽg.” Age ye di, idi ĩ nigin terẽ den. ");
INSERT INTO dad_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusia tamo idi dirõdig, laa bun tamal to ke de fã dedig anĩ, Jesus wagen disi to difiyen. ");
INSERT INTO dad_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Idi diron, “Tise, Moses itotkanaman, are tamo taka laaf fen, aiwa itornen, anĩ ere, kesu sã, tamo ĩ waab anĩ yale fen, tura nẽ kesu diroukenẽf. ");
INSERT INTO dad_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gama tura tura sewen dibodon. Matu ketem kayau yalen, anĩ ere, kesu yaleya sã mog, laa fen. ");
INSERT INTO dad_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Matu dõ fiya bagam waab anĩ yalen, anĩ ere, ĩg kesu sã mog, laa fen. Idi dõ fediyag de age fen. ");
INSERT INTO dad_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tura tura sewen anidi adok, kesu taka to dalen. Dum kayau areg laa fen. ");
INSERT INTO dad_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dum laa bun tamal kel fãya sain bun, ĩ ai nẽ kayau ibodõf, ere nigin, tura tura sewen anidi adok, ĩ dale dogolen?” ");
INSERT INTO dad_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus aitedin yale irokenẽdin, “Ã od kũ wenẽgef, ere nigin, ã Negur nẽ Itotoya ado Negur nẽ megeir keleĩ sã. ");
INSERT INTO dad_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sain laa bun tamal kel fãya bun, an tamo kayau ado abob yalef ya sãf, idi engel saa ilun dibodok gen dibodõf. ");
INSERT INTO dad_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gama, laa bun tamal fãya nigin, Moses nẽ od Negur nẽ Itotoya bun ibodok, are arein aa mata bun fotou fiyen Negur ĩ naig fe irokenen, ‘Aya Abraham nẽ Negur, Isak nẽ Negur, Jakop nẽ Negur’ anĩ to be uwesegen de? ");
INSERT INTO dad_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ĩ laa neid Negur sã, anĩ ere, ĩ mata ibodõya neid. Ã fatuk bagai kũ wenẽgef!” ");
INSERT INTO dad_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lo ifelnẽdiya tamo taka isi, idi od nem kusĩ de mog, karĩ fiyẽdin. Jesus ĩ aiten, od biya irokeneĩd mog, karĩ ye fen, ĩ Jesus to fiyen, “Ĩtãfiya ganan bun, ĩtãfiya nanĩ anĩ ganan wal fiya?” ");
INSERT INTO dad_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus iron, “Ĩtãfiya ganan wal fiya are enĩ, ‘O Israel, karĩ wog, Odug neda Negur, Odug ĩ yogo tekelei. ");
INSERT INTO dad_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Õ, Odug ogon Negur ĩ nigin waũ adok, malãkanon adok, kisi adok, megeir adok bunem, ĩ nigin waũ laaf.’ ");
INSERT INTO dad_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Anĩ dõ fiya are eig fiya, ‘Õ ogo nigin waũ laa fef gen, nẽ tã nigineg ago waũ laaf.’ Ĩtãfiya uru enim, ganan wal fiya.” ");
INSERT INTO dad_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lo ifelnẽdiya tamo anĩ Jesus irokenen, “Tise, õ de urok. Negur ĩ tekelei, taka to ibodok, Negur yogo dogol wof, anĩ bun momoi urok. ");
INSERT INTO dad_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Õ Negur nigin waũ adok, kisi adok, megeir adok bunem waũ laaf fen, õ ogo nigin waũ laa fef gen, nẽ tã nigineg ago waũ laafei yeya anim, yã bun sesewi fiya ado sesewi fiya fire fire ganan wal fiya.” ");
INSERT INTO dad_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus tamo anĩ keleĩ ado aiten yale di, ile fen, Jesus ĩ irokenen, “Õ Negur nẽ tano nigin egerõ sã.” Sain anĩ bunem ilen, taka nem baban to fiyẽya nigin kumĩ den. ");
INSERT INTO dad_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus tempel modoũ bun ifelneĩd fen, ĩ to fedin, “Naig fe di, lo ifelnẽdiya tamo, Kristus ĩ Dawid nẽ naal dedig? ");
INSERT INTO dad_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawid ĩ yogo Awa Uur Fateul bunem wogõ ye fen, kurõ falaisin: “‘Negur, neu Odug irokenen, “Imau biya melem ubod mog, ogon kiwai tar on yẽ farumẽ gõ afalauf.” ’ ");
INSERT INTO dad_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawid yogo, ĩ nigin ‘Odug’ yef, naig fe di, ĩ Dawid naal ouf?” Tamo kayau musei waud el fiya ado karĩ difiyen. ");
INSERT INTO dad_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus ifelneĩd fen, iron, “Lo ifelnẽdiya tamo nigin lo welegei. Idi gabar meluluk difonunakel diyo ken, maket modoũ bun aan difiyẽdiyouf anĩ orodidig. ");
INSERT INTO dad_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Age de fen, idi Juda neid uub fõ bun, sia biyai biyai bun dibod ken, tar inoya bun modoũ malabag bun dibodõdig. ");
INSERT INTO dad_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Idi, kayau waab idegnẽdiya bunem nedi fõ sosoin de fen, meleid yaleya nigin meluk bagai kosẽ dedig. Tamo age fediya, mala solo sane bagai dalouf.” ");
INSERT INTO dad_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus ofa moni bogis sitakã ibod ken, tamo kayau lo feid mog, idi moni tempel bogis bun dinon. Tamo kayau safineid adodo musei moni odudug diraran. ");
INSERT INTO dad_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Anĩ ere, kayau waab maleg taka isi, kapa koin moni giriya nanaal bagai uru inon. Are tu toea dogol. ");
INSERT INTO dad_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesus in dõ fiya tar iweig laisi fen, irokenẽdin, “Aya ã momoi arokeneik, kayau waab maleg enĩ ĩ, ganan wal fediya, odug bagai bogis bun inol. ");
INSERT INTO dad_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Idi ganan dogo neid safineid bun tamal tunĩ dinon, anĩ ere, kayau maleg anĩ, ereb ereb adok ĩ isennẽf anĩ ganan inon.” ");
INSERT INTO dad_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus ĩ tempel bunem kutũ yeis mog, in dõ fiya tar taka ĩ irokenen, “Ule, Tise! Ere meein odudug oug fediya! Ere fõ meli meli oug fediya!” ");
INSERT INTO dad_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Age ye di, Jesus ĩ irokenen, “Fõ odudug enĩ ganan uledif de? Meein enĩ taka to abob teten yenẽf, anĩ adok fau isog irailauf.” ");
INSERT INTO dad_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus Moul Arein tempel sitakã ibod mog, Pita, Jems, Jon, Endru anidim mugun Jesus to difiyen, ");
INSERT INTO dad_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ere sain enidi wõ youf? Ere uris bagai anĩ, enĩ ganan kisi falauf nigin wõ youf? Anĩ urokanamã.” ");
INSERT INTO dad_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus idi irokenẽdin, “Takam idegneĩya nigin lo weleg. ");
INSERT INTO dad_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Musei aya yanau nem disi dirõf, ‘Aya Kristus,’ age de fen, musei didegnẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sain ã kusĩ nigin karĩg fen, tamo sigoredim kusĩ nigin wogõ douf anĩ karĩ gouf, ã to tererẽ gei. Ereb ereb anidi agef wõ youf, anĩ ere, idikeleya sain fau dum isiyouf. ");
INSERT INTO dad_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Teneub taka fã ye fen, ĩ teneub taka nigin kiwai ifenẽf, tano taka ĩ, tano taka nigin kiwai ifenẽf. Uyu taka taka bun mimĩ wõ ye fen, naũ isiyouf. Age fouf anĩ, kayau kesu gõ fouf nigin darau gariya inodig age fiya. ");
INSERT INTO dad_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ã aug nigin lo weleg. Ã fau kaunsel imeid bun dinenei ken, uub fõ bun wagagã diyeĩf. Aya yanau nigin, ã gawaman mudur, king geid meleid bun ufareg fen, idi kurõ walaisig urokenẽdigouf. ");
INSERT INTO dad_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Biya od ketem teneub ganan bun iyokalauf. ");
INSERT INTO dad_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sain ã gei diyei ken, kot bun dirouleyeĩf, ere mauf wog fen, to kisi musei waleg. Sain anĩ bun, ereb ifeneik anĩ wogõ gouf, ere nigin, are ãgem to wogõ gouf, are Awa Uur Fateulem. ");
INSERT INTO dad_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Turam, tura kiwai imeid bun ino di, dukesiyouf, age fe di, tamam in kesu age fouf. Kesum sina tama kiwai difeneĩd fen, laa bun dinenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tamo ganan aya nigin ã kiwai difeneĩf, anĩ ere, taka ĩ megeir ifaref ile ile idikeleyanouf, Negur ĩ yalouf. ");
INSERT INTO dad_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Sain ‘ninir anĩ fonou inouf nigin’ ĩ an to ifarau nẽ anĩ ulogouf (anĩ uweseg, keleĩ youf), idi Judia distrik bun dibodok, arein diya diselauf. ");
INSERT INTO dad_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Taka ĩ yogon fõ agaran ibodok, ĩ kutũ yeis, aaben ile, ereb ereb to yalouf. ");
INSERT INTO dad_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Taka ĩ kabier ibodok, yogon gabar yalouf nigin to kel ilauf. ");
INSERT INTO dad_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Naa anĩ bun, kayau bouweid ado, kayau kesu su difenẽdif ado, idi meleidlon ado! ");
INSERT INTO dad_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Feluk sain bun, anĩ to wõ youf nigin, ã Negur kosẽ wiyẽgouf, ");
INSERT INTO dad_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ere nigin, naa anidi bun morõ odug biya adouf, morõ age fiya, gariya bun Negur teneub inon bunem isi gama, taka to wõ yen, dum buneg taka to wõ youf. ");
INSERT INTO dad_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Odug morõ odug nẽ naa anĩ to guru falaisim, taka to ibodom. Anĩ ere, tamo kayau ĩ igirnẽdin nigin, ĩ naa anĩ guru falaisin. ");
INSERT INTO dad_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sain anĩ bun, taka ã irokeneĩf, ‘Ulegef, Kristus yeir!’ oo ‘Ĩ your!’ ã anĩ to momoi ge. ");
INSERT INTO dad_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Fau idegẽya Kristus, idegẽya profet ado, wõ de fen, idi kisi falauf are, Negur igirnẽdin anidi didegnẽdiyouf nigin uris memelik ado dinodiyouf. ");
INSERT INTO dad_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Anĩ nigin, lo welegei, sain anĩ fau mog, aya ã ereb ereb ganan arokenein. ");
INSERT INTO dad_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Anĩ ere, naa anidi bun, morõ anĩ dõ fiya, “‘gaa gugum kalauf, age fe di, ogõ lalan to ifenẽf, ");
INSERT INTO dad_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","saa ilun tamal barisa kuku rouf, saa nẽ megeir ganan guyoyõ douf.’ ");
INSERT INTO dad_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Sain anĩ bun, tamo idi, Tamo Naal lalo bun yogon megeir odug fula fiya medeĩya ado isi mog, dilouf. ");
INSERT INTO dad_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Agef fen, ĩ yogon engel susur fedi di, yogon tamo kayau igirnẽdin anidi, teneub akor ganan bun, gaa iseya nem ile gaa ileyan, gei de, kuru difediyouf. ");
INSERT INTO dad_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Gama ã, aa fig bun keleĩ walogouf. Susu bonuf fen, aarau inodif, ã keleĩ, saneya melsak. ");
INSERT INTO dad_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Age fiya gen, ã ereb ereb anĩ wõ youf ulogouf, ã keleĩ, are mogo melsã bagai bobogẽ ifaref. ");
INSERT INTO dad_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Aya ã momoi arokeneik, tamo kayau sain enĩ bun dibodok eneidi to gare de mog, enĩ ganan wõ youf. ");
INSERT INTO dad_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Saa teneub ado sa kalauf, anĩ ere, neu od to bagai sa kalauf. ");
INSERT INTO dad_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Taka nem naa sain ado to keleĩ youf, saa ilun engel idig sã, Naal ĩg sã, Dei yogo dogol. ");
INSERT INTO dad_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mata ubodõg fen, lo weleg! Ereb sain anĩ wõ youf, ã to keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Are tamo fõ itor ileya gen. Ĩ yogon fõ itor ken, lo difouf nigin yogon ferfer imeid bun inon, idi mugu mugu kabĩ fire fire ifenẽdin. Agef fen, ĩ tamo bobog bun anĩ mala inof ibodõf nigin irokenen. ");
INSERT INTO dad_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Anĩ nigin, mata ubodõg fen, lo welegei, ere nigin, ã keleĩ sã, ereb sain fõ marau kel isiyouf, aragau be, bõ atun be, tataro yũ mog be, wef mog be. ");
INSERT INTO dad_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ĩ isi tarabã yeĩf, ã to wenẽg mog, ileyeĩf, are deuf. ");
INSERT INTO dad_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ereb aya ã arokeneik, aya adok ganan arokenẽdif, ‘Lo weleg!’” ");
INSERT INTO dad_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gama Pasa naa ado Bret Yis Sã Sifa naa, fau uru yen mog, pris odudug, lo ifelnẽdiya tamo geid, Jesus idegẽya naab bun dale dirou fen, dukesiyouf nigin naab dimiren. ");
INSERT INTO dad_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Idi diron, “Sifa sain bun to age tafouf, age tafouf are, tamo kayau seye de fen, kusĩ dalesauf.” ");
INSERT INTO dad_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus Betani an, Simon kulu lepra dagi adon tamo, in fõ bun saaf yoko ibod mog, kayau taka ĩ wagen moul sumeĩ biya bagai moni odug nem, nad nem dogol dinon anĩ, gulub ado irou isin. Agef fen, kayau gulub anĩ karãf fen, Jesus mudur bun moul fi felen. ");
INSERT INTO dad_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Age fe di, tunĩ an difaren are waud sane fen, abob dirokenen, “Ere nigin moul enĩ sekil fef? ");
INSERT INTO dad_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Moul enei yar tekelei nẽ dimig mala wal feseya nem sur fiyam, agef fen, moni anĩ yale, maleg tamo ifenẽdiyam, are dem.” Age de fen, idi ĩ totol bagai ou difiyen. ");
INSERT INTO dad_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus iron, “Utornẽg, ã ere nigin ĩ wau morõ wenẽgef? Kayau enĩ aya nigin biya bagai age fel. ");
INSERT INTO dad_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Maleg idi faimud ã geid ubodõgouf, anĩ nigin, ã idi isennẽdiya oroyeĩf, are sain musei. Anĩ ere, aya faimud ã geid to tabodõgouf. ");
INSERT INTO dad_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ĩ ereb age fiya kisin anĩ age fel. Ĩ moul aya bouwau bun fi felel are, mekur ainẽf nigin anĩ ketem dodok fel. ");
INSERT INTO dad_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aya ã momoi arokeneik, tenebur ein nain be, biya od enĩ wogõ douf, ereb kayau enĩ age fel anĩg wogõ douf. Age fe di, idi ĩ nigin kisi difouf.” ");
INSERT INTO dad_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Age ye di, Judas Iskariot, tuwelf anidi atun taka, Jesus kiwai ifen ken, pris odudug imeid bun inouf nigin wagedin ilen. ");
INSERT INTO dad_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pris odudug idi od enĩ karĩ de, waud al fe fen, ĩ moni difenẽf nigin dirokenen. Anĩ nigin, ĩ Jesus idi imeid bun inouf nigin naab imirek ilen. ");
INSERT INTO dad_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bret Yis Sã Sifa inoya naa matu anĩ bun, sain anĩ are idi neid tobonunã, sipsip naal, Negur tubuid tar isennẽdin anĩ kisi de fen, sesewi difedig anĩ, Jesus nẽ dõ fiya tar Jesus to difiyen, “Õ amã nain anĩ Pasa naa nẽ saaf wãf nigin, amã dodok mafouf anĩ oroyok?” ");
INSERT INTO dad_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Age de di, Jesus in dõ fiya tar uru sur feid fen, irokenẽdin, “Taun uleg fen, tamo taka darum naan ado isi fotou yeĩf, ĩ dõ gouf. ");
INSERT INTO dad_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ĩ fõ taka namen ile di, uleg fen, gama ã fõ marau eig wiyẽg urokenẽgouf, ‘Tise to fel: Aya neu dõ fiya tar geid, Pasa naa nẽ saaf mãf nigin aab nain ibodok?’ ");
INSERT INTO dad_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ĩ aab odug ilun anĩ ifelneĩf, an ereb ereb dodok de bure difelen. An neda nigin dodok gouf.” ");
INSERT INTO dad_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","In dõ fiya tar taun dile fen, Jesus iron kilei, ereb ereb age fiya dilen. Anĩ nigin, idi Pasa naa nẽ saaf dodok difen. ");
INSERT INTO dad_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aragau di, Jesus in dõ fiya tar tuwelf geid, an wõ den. ");
INSERT INTO dad_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Idi tebol bun si dino, saaf dokon, Jesus iron, “Aya ã momoi arokeneik, ã atun takam aya kiwai imeid bun inoyauf, taka aya uruwom moko anim.” ");
INSERT INTO dad_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Idi waud gudũf fen, mugu mugu dirokenen, “Momoi bagai, ayam sã de?” ");
INSERT INTO dad_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus aitedin yale iron, “Ã tuwelf atun takam, taka ĩ, imamã uruwom beĩ bun nu mafef anim. ");
INSERT INTO dad_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tamo Naal ĩ nigin ditoton agef bai ilauf. Anĩ ere, tamo ĩ Tamo Naal kiwai tamo imeid bun inof, ĩ malalon ado! Ĩ sina to gõ fem, are dem.” ");
INSERT INTO dad_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Idi saaf dokon, Jesus bret yale, Negur de fiye ken, bret anĩ mumã fen. Agef fen, in dõ fiya tar ifeneĩd fen, iron, “Waleg, eĩ neu bouwau.” ");
INSERT INTO dad_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Agef fen, ĩ kap yale, Negur de fiye ken, kap anĩ ifenẽdin, age fe di, idi adok anĩ bun don. ");
INSERT INTO dad_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesus idi irokenẽdin, “Eĩ neu naudou, ã Negur geid bar itenẽya nigin, are tamo kayau musei nigin fi felef, ");
INSERT INTO dad_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","aya ã momoi arokeneik, aya baban wain enĩ to ãf, gaman ile, aya Negur nẽ tano bun wain mata ãf bun.” ");
INSERT INTO dad_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Idi seg taka dalel fen, idi Moul Arei bun diselen. ");
INSERT INTO dad_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus idi irokenẽdin, “Ã fau adok uyalalagauf, ere nigin, Negur nẽ Itotoya eig ye irok: “‘Aya sipsip marau aũ di, sipsip ganan firagagaũ difouf.’ ");
INSERT INTO dad_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Anĩ ere, aya kel fã auf bun, aya ket Galili uyu alauf.” ");
INSERT INTO dad_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita Jesus irokenen, “Ganan diyalalaufeg, aya sãf.” ");
INSERT INTO dad_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus Pita irokenen, “Aya õ momoi arokonok, gama bõ enĩ bun, tataro kokorok ye uru fiya sã mog, õ ogo aya nigin wa wo, towo wouf.” ");
INSERT INTO dad_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Anĩ ere, Pita totol bagai iron, “Momoi aya õ uruwom gare tauf nigin oufeg, aya õ nigin to bagai wa afouf.” Age ye di, idig ganan od de tekelei anĩ diron. ");
INSERT INTO dad_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Idi modoũ yana Getsemane dedig, an dilen. Age de fen, Jesus in dõ fiya tar irokenẽdin, “Ein ubodõg mog, aya kosẽ auf.” ");
INSERT INTO dad_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ĩ, Pita, Jems, Jon anidi dogol geif fen, ĩ geid dilen. Agef fen, ĩ wau gũf fen, morõ odug gudũ fen. ");
INSERT INTO dad_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jesus idi irokenẽdin, “Neu malaukanon tobega le fen, wau morõ gudũ feis, laa nẽ daũ bun ifaref. Ein ufareg fen, lo weleg.” ");
INSERT INTO dad_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naal godof iroule fen, kisi falauf are, sain anĩ Jesus wal fiyẽf nigin, ĩ tenebur kubũ ye fen, kosẽ yen. ");
INSERT INTO dad_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jesus iron, “Aba, Dei, ereb ereb ganan, õ age fiya kisi feleya. Kap enĩ walelkana. Anĩ ere, neu oroya anĩ to dõ wo, on oroya dõ wo.” ");
INSERT INTO dad_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Age fel fen, Jesus in dõ fiya tar gedin kel isin, mulã den mog, iledin. Jesus Pita irokenen, “Simon, õ wenek de? Õ aua tekelei to mata ubodõf de? ");
INSERT INTO dad_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ã, kisi yeĩya bun to kubũ gouf nigin lo weleg fen, kosẽ gouf. Uur are orof, anĩ ere, bouwa anĩ malegef.” ");
INSERT INTO dad_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ĩ baban kel ile, uruwa kosẽ yen gen, dõf age fen. ");
INSERT INTO dad_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ĩ kel isin, baban denena mog, iledin, ere nigin, idi meleid morõ gudũ fesin. Idi ĩ ereb fiyẽya nigin taka to kisi difen. ");
INSERT INTO dad_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesus kel towo fe fen, in dõ fiya tar irokenẽdin, “Ã fau si unog fen, yenẽyai gef? Bure! Sain mogo isil. Ulegef, Tamo Naal mogo mosor tamo imeid bun ilef. ");
INSERT INTO dad_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fafãg fen, teleg! Kiwai imeid bun inoya tamo yeir isif!” ");
INSERT INTO dad_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus fau wogõ ye mog, tuwelf anidi atun taka, Judas wõ yen. Tamo musei dimig adodo, seburer adodo, ĩ geid disin. Pris odudug, lo ifelnẽdiya tamo, mudur adodo idim sur difedi di, disin. ");
INSERT INTO dad_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gama Judas ĩ Jesus yaor fiyẽya nẽ uris nigin, idi faded fiyẽdin: “Tamo aya umã afouf anĩ, ĩ waleg fen, uroug uleg.” ");
INSERT INTO dad_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas kaisã bagai Jesus wagen ile iron, “Rabi!” Agef fen, umã fiyen. ");
INSERT INTO dad_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tamo idi Jesus ka dife dirounen. ");
INSERT INTO dad_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Age dife di, tamo melsã difaren anĩ takam dimig ul feis yale, pris mudur ado nẽ kabĩ tamo weder salõf iran. ");
INSERT INTO dad_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus iron, “Aya bẽ tamo gen, ã dimig adodo, seburer adodo, waleyagau fenẽ usigef de? ");
INSERT INTO dad_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naa ganan, aya ã geid tabod ken, tempel fofomala bun afelnein, anĩ ã aya to urouyagen. Anĩ ere, Negur nẽ Itotoya bun ibodok anĩ kisi falauf nigin.” ");
INSERT INTO dad_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Age ye di, ganan ditornẽ diyalelen. ");
INSERT INTO dad_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tamo gaũ taka, gabar lalau dogol ifonun ĩ, Jesus dõ fen. Sain idi Jesus ka dife di, ");
INSERT INTO dad_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ĩ gabar inũ iraile, gemũ iyawon. ");
INSERT INTO dad_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Idi Jesus dale, pris mudur ado wagen diroulen. Age dife di, pris odudug, mudur adodo, lo ifelnẽdiya tamo geid, ganan disi guru difen. ");
INSERT INTO dad_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita Jesus dume dõf, tokõ fel ile, pris mudur ado nẽ fõ fofomalan wõ yen. An ĩ kabĩ tamo geid dibod ken, yã imidirek ibodon. ");
INSERT INTO dad_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pris odudug, kaunsel ganan geid, Jesus laa bun dinenẽf nigin bouwa bun od dimiren. Anĩ ere, taka to dilen. ");
INSERT INTO dad_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Musei Jesus bouwa bun idegẽya od diraran, anĩ ere, idi neid od tekelei sã. ");
INSERT INTO dad_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Age de fen, tamo tunĩ fafã de fen, Jesus bouwa bun idegẽya od enĩ diran, ");
INSERT INTO dad_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Amã karĩ mafiyẽ mog, iron, ‘Aya tempel tamom dinon anĩ narĩ afel fen, naa towo bun, taka, are tamom to inouf anĩ anouf.’” ");
INSERT INTO dad_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Anĩ ere, idi neid od anĩg tekelei sã. ");
INSERT INTO dad_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Age de di, pris mudur ado wagedin fã ye ifar fen, Jesus to fiyen, “Õ to solo urõf de? Eĩ ere od anĩ tamo enidi dirousi, õ boũ bun duk?” ");
INSERT INTO dad_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Anĩ ere, Jesus ĩ mutũ ifar fen, to solof iron. Baban pris mudur adom, ĩ to fiyen, “Õ Kristus, Negur Naal de?” ");
INSERT INTO dad_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus iron, “Aya im, ã Tamo Naal Negur megeir ado ima biyalem ibod ken, saa lalo bun isi mog, ulogouf.” ");
INSERT INTO dad_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Age ye di, pris mudur ado in kolos serek fe fen, to fen, “Ere nigin ada od megeir fiya nigin tamo baban tamirẽf? ");
INSERT INTO dad_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ã kono fiya od mogo karĩ gel. Ã ere kisi gef?” Idi ganan ĩ laa fouf nigin diron. ");
INSERT INTO dad_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Age de fen, tunĩ Jesus disisnẽ, mala difofakel fen, imedim dun. Age de fen, idi diron, “Aim inok kurõ weis urõ!” Age dife di, kusĩ tamo Jesus dale fen, dun. ");
INSERT INTO dad_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita fõ fofomalan tenebur ibod mog, pris mudur ado nẽ kabĩ kayau taka isin. ");
INSERT INTO dad_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ĩ, Pita yã imidir mog, lo fel fen, iron, “Õg Jesus Nasaret tamal geiden.” ");
INSERT INTO dad_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Anĩ ere, ĩ waf fen, iron, “Õ od urok enĩ, aya keleĩ sã.” Age ye fen, ĩ bobogẽ iyok ilen. ");
INSERT INTO dad_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kabĩ kayau anĩ Pita an ile fen, ĩ baban an difaren anĩ irokenẽdin, “Tamo enĩ are idi neid taka.” ");
INSERT INTO dad_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ĩ baban wa fen. Sain naal ilele di, idi melsã difaren anidim Pita dirokenen, “Momoi bagai, õ idi neid taka, ere nigin, õ Galili tamal.” ");
INSERT INTO dad_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ĩ mogo yogo bouwa geluf fen, totol od irokenẽdin, “Tamo ã urõgef anĩ, aya keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Age ye mog, kaisã bagai, tataro baban kokorok yen. Age fe di, Pita Jesus od irokenen anĩ weder fokõ felen: “Tataro fau kokorok ye uru fiya sã mog, õ aya nigin wa wo, towo wouf.” Anĩ bunem, ĩ kusureis fen, inã yalen. ");
INSERT INTO dad_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bonimei bagai, pris odudug, mudur adodo, lo ifelnẽdiya tamo, Juda neid kaunsel ganan geid, od difon. Idi Jesus difõ dale dirou, Pailat ima bun dinon. ");
INSERT INTO dad_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat Jesus to fiyen, “Õ Juda neid king de?” Jesus solof iron, “Are de yer, õ urok anĩ.” ");
INSERT INTO dad_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pris odudug ĩ bouwa bun od musei dun. ");
INSERT INTO dad_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Anĩ nigin, Pailat baban Jesus to fiyen, “Õ to solo wo urõf de? Ereb ereb musei nigin bouwã bun od dinof anĩ ulef.” ");
INSERT INTO dad_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Anĩ ere, Jesus fau od taka to solo fen. Age fe di, Pailat terẽ ye fen, kisi musei yalen. ");
INSERT INTO dad_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gawaman nẽ tobonunã are, Pasa Sifa inoya bun tamo kayau dirõ di, kalabus bun tamo taka dalisnẽdig. ");
INSERT INTO dad_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tamo taka yana Barabas ĩ, tamo kusĩ dales fen, tamo didenkesin, kalabus bun dinenan anidi neid taka. ");
INSERT INTO dad_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tamo kayau mala odug dise, Pailat gai age fedig anĩ, age fenẽdiyouf nigin to difiyen. ");
INSERT INTO dad_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat to fedin, “Ã aya Juda neid king anĩ aliskeneĩf de?” ");
INSERT INTO dad_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat keleĩ, pris odudug idi kiyeĩ dino fen, Jesus ĩ ima bun dinon. ");
INSERT INTO dad_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Anĩ ere, pris odudug tamo kayau waud dale fen, dirokenẽdi di, idi Jesus ban Barabas anĩ Pailatem yaliskenẽdiyouf nigin diron. ");
INSERT INTO dad_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat idi to fiyẽdin, “Juda neid king gedig anĩ, aya ĩ nigin naig afiyẽf?” ");
INSERT INTO dad_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Idi diweig diron, “Aa tetek bun ũf!” ");
INSERT INTO dad_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat idi to fiyẽdin, “Ere nigin? Ere mosor ĩ age fen?” Anĩ ere, idi totol bagai diweig diron, “Aa tetek bun ũf!” ");
INSERT INTO dad_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tamo kayau waud el fouf nigin, Pailat Barabas yaliskenẽdin. Pailat irõ di, Jesus wagĩ difiye ken, aa tetek bun dũf nigin, kusĩ tamo imeid bun inon. ");
INSERT INTO dad_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kusĩ tamo idi, Jesus dale dirou gawaman mudur nẽ fõ aaben dile fen, kusĩ tamo ganan diweignẽdi di, guru difen. ");
INSERT INTO dad_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Idi gabar kadaũ difounkenen, age de fen, idi malũ duri ado dale, teter tanak kori de fen, ĩ mudur bun kurũ difen. ");
INSERT INTO dad_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Age de fen, idi ĩ diweig dirokenen, “O, Juda neid king gai gai ibodõf!” ");
INSERT INTO dad_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Baba baban idi werĩ tibog nem mudur bun du ken, disisnen. Idi iboreid bobou de, kususu de fen, ketẽ difiyen. ");
INSERT INTO dad_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Idi ketẽ difiye kel fen, gabar kadaũ dinukeis, yogon gabar bagai anĩ difounkenen. Age de fen, idi ĩ aa tetek bun dũf nigin dirou diselen. ");
INSERT INTO dad_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tamo taka Sairini tamal, yana Simon, Aleksanda Rufus ado neid temeid, ĩ yogon fonom isi, luwen wal fediyoũ mog, idi Jesus nẽ aa tetek faali fouf nigin nugo difiyen. ");
INSERT INTO dad_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Idi Jesus modoũ yana Golgota (anĩ nẽ gariya, Mudur Tuwa nẽ Modoũ) an dirou diselen. ");
INSERT INTO dad_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Age de fen, idi Jesus darau naal to karĩ youf nigin wain marasin taka ado falei de difenen, anĩ ere, ĩ to yon. ");
INSERT INTO dad_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Idi ĩ aa tetek bun du ken, in gabar foi de fen, aibem ereb anĩ yalouf nigin aisaĩ kodẽ den. ");
INSERT INTO dad_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bonimei nain kilok bun, idi ĩ aa tetek bun dun. ");
INSERT INTO dad_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesus bouwa yũya od eig de ditoton: JUDA NEID KING. ");
INSERT INTO dad_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Idi bẽ tamo urug, ĩ geid aa tetek bun didenen, taka Jesus ima biyalẽ, taka ima kilẽ. ");
INSERT INTO dad_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tamo kayau dile disi dife, kono difiye ken, kasã difiyẽ, mudureid dira ken, diron, “Õ, tempel narĩ afel fen, baban naa towo bun anouf, won, ");
INSERT INTO dad_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","õ ogo nigin usenne ken, aa tetek bun tamal kutũ weis!” ");
INSERT INTO dad_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Age difiyen gen, pris odudug, lo ifelnẽdiya tamo geid, idi dogo dogol wogõ de fen, ĩ ketẽ difiyen. Idi diron, “Ĩ tunĩ isennẽdidig, anĩ ere, ĩ yogo isennẽya kisi feleya sã! ");
INSERT INTO dad_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristus enĩ, Israel neid King, utornẽg len, gama aa tetek bun tamal kutũ yeis len, tail fen, momoi tauf.” Idi ĩ geid aa tetek bun didenẽdineg, ĩ kono difiyen. ");
INSERT INTO dad_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gaa atun tuwelf kilok bun, gugum isi, teneub ganan kerũ fel ile, tri kilok aragaun. ");
INSERT INTO dad_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aragau tri kilok bun, Jesus wade bagai iweig iron, “Eloi, Eloi, lama sabaktani?” –ani nẽ gariya, “Neu Negur, neu Negur, ere nigin õ aya utornal?” ");
INSERT INTO dad_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tunĩ melsã difaren, anĩ karĩ de fen, idi diron, “Karĩg, ĩ Eliya iweignek.” ");
INSERT INTO dad_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tamo taka gudu re ile, spons yalen, wain makik ado bun nu feis fen, tibog bun ino fen, Jesus yãf nigin ifenen. Agef fen, ĩ iron, “Gama utornẽg. Eliya isi yaleisnẽ mog, tailauf.” ");
INSERT INTO dad_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus ait odug nem iweig fen, laa fen. ");
INSERT INTO dad_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tempel nẽ gabar faraf uru fen, ilunenem irousil teneburen. ");
INSERT INTO dad_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kusĩ tamo neid orowa, Jesus wagen an ifaren anĩ, in kaĩya anĩ karĩ ye, in laa anĩ ile fen, iron, “Momoi bagai, tamo enĩ Negur Naal!” ");
INSERT INTO dad_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kayau tunĩ so del difar fen, lo difen. Idi atun, Maria Magdala, taka Maria, Jems naal bagai Joses ado neid sineid, taka Salome. ");
INSERT INTO dad_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galili an kayau enidi Jesus dõ difiye ken, aruna dalen. Kayau musei, Jesus geid Jerusalem diselen anidig an difaren. ");
INSERT INTO dad_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Naa are dodok fiya nẽ naa (naa anĩ bure fele di, Sabat naa wõ youf). Aragau mog, ");
INSERT INTO dad_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josef, Arimatea tamal, ĩ kaunsel neid odug taka, ĩ yogo anĩ Negur nẽ tano tari fen, ĩ kumĩ sã Pailat garan ile, Jesus bouwa buru yalouf nigin to fiyen. ");
INSERT INTO dad_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat Jesus mogo laa fel ya anĩ karĩ ye fen, terẽ yen. Ĩ kusĩ tamo neid orowa iweigne ken, Jesus mogo be laa fel anĩ, ĩ to fiyen. ");
INSERT INTO dad_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sain ĩ kusĩ tamo neid orowa bun laa fel ya karĩ ye fen, ĩ Jesus bouwa buru yaleya nigin Josef yo fiyen. ");
INSERT INTO dad_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Age fe di, Josef gabar lalau na yale fen, bouwa buru yaleis, gabar lalau anim sile fen. Agef fen, ĩ matmat sa bun ku dalen anĩ kur inenen. Gama ĩ meein wele fe di, matmat bobog katĩ felen. ");
INSERT INTO dad_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdala, Maria Joses nẽ sina ado, ĩ dinenen modoũ anĩ dilen. ");
INSERT INTO dad_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat naa bure fele di, Maria Magdala, Maria Jems sina, Salome anidim dile, Jesus bouwa bun wã difouf nigin, moul sumeĩ biya na gei difen. ");
INSERT INTO dad_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Uub nẽ naa matu bun bonimei bagai, we kurã fel mog, idi matmat bun naab diyok dile fen, ");
INSERT INTO dad_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","idi abob to difen, “Aim matmat bobog bun meein wele fel kanadauf?” ");
INSERT INTO dad_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Age de fen, meleid diran, idi meein odug biya anĩ wele feleya dilen. ");
INSERT INTO dad_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Idi meku namen dilen, tamo gaũ taka gabar lalau ifounkel, ima biya melem ibod mog, dile fen, terẽ den. ");
INSERT INTO dad_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ĩ iron, “To terẽ wog, ã Jesus Nasaret tamal aa tetek bun dun anĩ umirnẽgef. Ĩ mogo fã yel! Ĩ ein sã. Idi ĩ dinenẽ yenen modoũ anĩ uleg. ");
INSERT INTO dad_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Anĩ ere, uleg, in dõ fiya tar Pita geid urokenẽdig, ‘Ĩ ketem Galili ilef. An ĩ ulogouf, ĩ irokenein kilei.’” ");
INSERT INTO dad_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Idi terẽ de fen, waud firagagaũ felen, anĩ nigin, kayau idi ulolõ deis, meku ditor diyawon. Idi kumĩ den nigin, aib taka to dirokenen. ");
INSERT INTO dad_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus, uub nẽ naa matu bun bonimei bagai, fã ye fen, ĩ Maria Magdala bun ketem wõ yen, kulu Jesus kaa sesen sewen kayau anĩ bun irudin. ");
INSERT INTO dad_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ĩ ile, idi Jesus geid diyon anidi, waud gudũf fen, marudim difen anĩ irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Idi, Jesus mata fã yel, kayau ĩ ilel ya anĩ karĩ de fen, waud to momoi den. ");
INSERT INTO dad_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dum in dõ fiya tar uru naab diyok dile mog, Jesus bouwa fire bunem, idi atun wõ yen. ");
INSERT INTO dad_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Age fe di, idi keku de disi, an difaren anidi dirokenẽdin, anĩ ere, idi nigineg to momoi den. ");
INSERT INTO dad_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dum idi Ilewen, saaf doko dibod mog, Jesus idi bun wõ ye fen, ou fiyẽdin, ere nigin, idi Jesus fã yel mog, dilen anĩ to momoi de fen, waud katĩ difelen nigin. ");
INSERT INTO dad_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesus irokenẽdin, “Ã teneub ganan bun uleg fen, biya od tamo kayau ganan urokenẽdig. ");
INSERT INTO dad_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Taka ĩ momoi ye fen, naan yalef are, ĩ kel yalouf, taka ĩ to momoi yef are, es fiya bun inenẽf. ");
INSERT INTO dad_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Momoi def idi, uris enidi idi bun wõ youf, idi aya yanau nem kaa sesen dirudiyouf, idi od mata mata wogõ douf. ");
INSERT INTO dad_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Idi imedim gogour dale diroudiyouf, takag, laa nẽ mũ sane dãf, to mũ idenẽdiyouf, takag, idi dagi tamo bun imeid dino di, dagi sa kalauf.” ");
INSERT INTO dad_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Odug Jesus irokeneĩd bure fele di, Negur Jesus yale, saa ilun irou isel, Negur ima biyalẽ ibodok. ");
INSERT INTO dad_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Anĩ nigin, in dõ fiya tar dile, teneub ganan bun biya od wogõ den. Age dife di, Odug idi ado kabĩ yale di, uris bunem yogon od anĩ megeir fen. ");
INSERT INTO dad_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Musei idi, amã atun ereb ereb wowã yen anĩ, ditotauf nigin age difen, ");
INSERT INTO dad_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","are biya od nẽ kabĩ tamo uyulil dibod ken, meledim dilen anidi bun tamal, anĩ wogõ difaman. ");
INSERT INTO dad_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Age fiya nigin, aya yug bagai, gariya bunem ereb wowã yen anĩ ganan amir ailen, are aya kisi afen, tamo odug Teofilus õ bun el fe, itotoya nigin biya bagai aun, ");
INSERT INTO dad_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","anĩ bunem, õ ereb ereb difelnon are momoi yeya anĩ keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod Judia nẽ king ibodon sain bun, pris taka ibodon, in yana Sekaraia, ĩ Abiya nẽ pris bun tamal taka, in aiwa Elisabet ĩg Aron nẽ ibor bun tamal. ");
INSERT INTO dad_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Idi urom Negur mala bun madur dibodon, idi Odug nẽ ĩtãfiya ganan ado nun el de, tutuk dõ difedig. ");
INSERT INTO dad_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Anĩ ere, idi urom kesu sã, ere nigin, Elisabet ĩ dali, kesu gõ fiya kisi feleya sã, agef fen, idi urom tubau bagai. ");
INSERT INTO dad_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sain taka bun, Sekaraia, ne kabĩ tura tar geid kabĩ dale mog, ĩ Negur nẽ pris kabĩ yale fen, ");
INSERT INTO dad_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","pris idi neid tobonunã bunem, Odug nẽ tempel namen ile fen, aa gaula sumeĩ biya tõ fiya nigin aisaĩ kodẽ bunem ĩ digirnen. ");
INSERT INTO dad_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aa gaula sumeĩ biya tõ fiya saine di, idi Odug yana dalesedig ganan mayarẽ kosẽ den. ");
INSERT INTO dad_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Agef mog, Odug nẽ engel, ĩ bun wõ ye, alta aa gaula sumeĩ biya tõ fiyadig anĩ ima biyalẽ ifaren. ");
INSERT INTO dad_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Age fe di, Sekaraia ĩ ile fen, ĩ terẽ ye mã, kumĩ ye fen, dẽ yelen. ");
INSERT INTO dad_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anĩ ere, engel ĩ irokenen, “Õ to kumĩ wo, Sekaraia, ogon kosẽya are Negur ĩ karĩ yen. Ogon aiwã Elisabet ĩ, ogon kesu monog gõ fouf, age fe di, in yana ũ, Jon wouf. ");
INSERT INTO dad_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ĩ bunem waũ kulĩya ado waũ al fiya õ bun ibodõf, age fe di, musei ĩ gõ fouf bun waud al fouf, ");
INSERT INTO dad_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ere nigin, Odug mala bun ĩ yana odug adouf, ĩ wain be, aai naan totol falei difef anĩg to yãf, agef fen, ĩ sina namenem Awa Uur Fateulem aura fiyẽf. ");
INSERT INTO dad_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israel tamo kayau musei fau inim, Odug, nedi Negur wagen kel gurif irou ilauf. ");
INSERT INTO dad_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Agef fen, ĩ Eliya nẽ uur ado megeir bunem, Odug fau ileya sã mog, ĩ ket uyu irou ile fen, temeid tar, naaluid tar nigin waud yenẽf nigin ado, fe temeleid idi madur ibodõya nẽ kisi biya bun ileya nigin falei fe fen, tamo kayau Odug nẽ anidi saika fediyouf.” ");
INSERT INTO dad_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraia engel to fiyen, “Naig afe fen, aya enei keleĩ youf? Aya neu kayau ado urom mabodok masi, tubau bagaif.” ");
INSERT INTO dad_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Engel aiten yale iron, “Aya Gabriel. Aya Negur mala bun afaredig, anĩ nigin, aya õ wogõ yõya nigin ado, biya od enei irokonõya nigin sur fiyal. ");
INSERT INTO dad_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Anĩ gama õ ait ufokol fen, od to wogõ wof ule, anĩ wõ youf naa bun, ere nigin, õ neu od to momoi wol, od enei are fau yogon sain bun bagai, kaũ wõ youf.” ");
INSERT INTO dad_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Age fe di, tamo kayau Sekaraia tari de fen, idi ĩ sain meluk tempel namen ibodon nigin kisi musei dalen. ");
INSERT INTO dad_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ĩ ulõ yesin sain bun, ĩ wogõ fiyẽdiya kisi feleya san. Age fe di, idi kelein, ĩ tempel namen mala seleulã kurãf fen, ereb taka ilel, ere nigin, ĩ imam dogol ifelneĩd fen, ĩ wogõya sã ibodok ilen. ");
INSERT INTO dad_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","In kabĩ nẽ sain bure fele di, ĩ fõ bun kel ilen. ");
INSERT INTO dad_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Anĩ bure fele di, in aiwa Elisabet bou adon, agef fen, ogõ faif ĩ iminkel ibodon. ");
INSERT INTO dad_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ĩ iron, “Odugem enei age fanan. Naa eneidi bun, ĩ yogon oroya ado wau ifenẽya ifelnan, agef fen, neu mama tamo kayau atun yalelkanan.” ");
INSERT INTO dad_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ogõ sigis bun, Negur, engel Gabriel Nasaret taun, oun Galili teneub, sur fiyẽ di, ile, ");
INSERT INTO dad_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kayau taulei, tamo yana Josef, Dawid nẽ ibor bun tamalem yalouf nigin digirin gein ilen. Kayau taulei yana Maria. ");
INSERT INTO dad_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Engel ĩ gein ile fen, iron, “Fel, õ nigin Negur fatuk el yok. Odug õ ado ibodok.” ");
INSERT INTO dad_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria in od nigin wau fatuk togu fen, aanya enei naig fiya nigin ye fen, kisi musei yalen. ");
INSERT INTO dad_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anĩ ere, engel ĩ irokenen, “Maria, õ to kumĩ wo, õ Negur nẽ wau el fiya gurug wol. ");
INSERT INTO dad_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Õ fau kesu ado fen, kesu monog gõ wouf, ago fen, yana ũ, Jesus wouf. ");
INSERT INTO dad_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ĩ fau odug wõ ye di, Negur Ilun Bagai Naal douf. Negur Odug yogo, king nẽ modoũ tama Dawid nẽ anĩ, ĩ ifenẽf. ");
INSERT INTO dad_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Age fe di, ĩ Jakop nẽ ibor bun king gai ibodkalauf, in tano to sa kalauf.” ");
INSERT INTO dad_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria engel to fiyen, “Aya fau mois, eĩ naig fe wõ youf?” ");
INSERT INTO dad_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Engel ĩ aiten yale iron, “Awa Uur Fateul õ bun isiyouf, age fe di, Negur Ilun Bagai nẽ megeir kerub yõf. Anĩ bunem fateul bagai gõ wouf are, yana Negur Naal douf. ");
INSERT INTO dad_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ogon sirag Elisabeteg tubau mog, kesu yalouf, ĩ dali den, anĩ mogo ogõ sigis ĩ bou ado ibodok. ");
INSERT INTO dad_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ere nigin, ereb taka anĩ Negur bun malai sã.” ");
INSERT INTO dad_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria ĩ aiten yale iron, “Aya Odug nẽ kabĩ kayau, aya bun od sã, õ urok kilei od sã agef wõ youf.” Age ye di, engel ĩ itornẽ ilen. ");
INSERT INTO dad_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sain anĩ bun, Maria dodok fel, kaisã bagai taun taka arei bun, Judia distrik nediwon ilen. ");
INSERT INTO dad_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","An ĩ Sekaraia nẽ fõ bun wõ ye fen, Elisabet fel fiyen. ");
INSERT INTO dad_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sain Elisabet Maria nẽ fel ya anĩ karĩ ye fen, kesu sina namen ibodon anĩ okĩ yen, age fe di, Elisabet Awa Uur Fateulem aura fiyen. ");
INSERT INTO dad_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ĩ ait odugem iweig iron, “Kayau ganan atun, Negur õ el yok. Agef fen, kesu gõ wouf anĩg, Negur ĩ el fiyek! ");
INSERT INTO dad_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Anĩ ere, aya naig fiya bagai nigin, neu Odug nẽ sina anĩ aya bun isif? ");
INSERT INTO dad_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ogon fel ya nẽ ait wederoun ile mog bagai, momou nameun al fe fen, okĩ yel. ");
INSERT INTO dad_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kayau taka, ĩ ereb Odug ĩ irokenek are agef kisi fel wõ youf, ye fen, momoi yef, are Negur ĩ el fiyek!” ");
INSERT INTO dad_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Age fe di, Maria iron: “Neu malaukanon Odug yana yalesef, ");
INSERT INTO dad_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","agef fen, neu uur Negur Isennaya nigin kulĩ yef, ");
INSERT INTO dad_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ere nigin, ĩ, aya yogon kabĩ kayau maleg nigin kisi fatuk yalen. Sain enei bunem ilauf ganan, ibor ganan Negur ĩ el fiyen douf, ");
INSERT INTO dad_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ere nigin, Negur Megeir Barikã ĩ aya bun ereb odug age fel, ĩ yana fateul ibodok. ");
INSERT INTO dad_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","In wau yũya, ĩ nigin anini def bun tobol fouf, ibor gama ibodok enei ado, dumen isiyouf idi buneg gai gai ibodkalauf. ");
INSERT INTO dad_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ĩ yogo imam kabĩ totol odug biya age fedin, ĩ idi neid kisi bun yeneid dalesef anĩ irudi di, firagagaũ difen. ");
INSERT INTO dad_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ĩ yeneid adodo, nedi modoũ bun yalelneĩd fen, maleg anĩ yalesnẽdin. ");
INSERT INTO dad_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ĩ idi naũ fedif anĩ, ereb ereb biya ifeneĩd fen, idi safineid adodo daku irudin. ");
INSERT INTO dad_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ĩ amã tubumã tar irokenẽdin kilei, ĩ yogon kabĩ tamo Israel isennen, ");
INSERT INTO dad_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","agef fen, Abraham ado in ibor nẽ tubu tar bun faimud, wau yũya ifenẽdiya nigin karĩ yeledig.” ");
INSERT INTO dad_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria, Elisabet ado ogõ towo age fiya dibod ken, fõ bun kel ilen. ");
INSERT INTO dad_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet nẽ kesu gõ fiya sain wõ ye di, ĩ kesu monog gõ fen. ");
INSERT INTO dad_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ĩ ne tã tar, in sirag tar geid, Negur nẽ wau yũya odug ifelnen anĩ karĩ de fen, idi weim waud al fen. ");
INSERT INTO dad_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Naa eit bun, idi mulũ nigin kesu bou gudũ fiya nigin disin, age de fen, ĩ yana dũ, tama nẽ dait Sekaraia douf nigin age difen. ");
INSERT INTO dad_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Anĩ ere, ne sina aitedin yale iron, “Age fiya sã! Ĩ yana Jon ye yauf.” ");
INSERT INTO dad_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Idi ĩ dirokenen, “Ogon sirag tar atun, yana age fiya taka sã.” ");
INSERT INTO dad_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Age de fen, in tama bun kesu yana aib youf anĩ karĩ douf nigin, uris difenen. ");
INSERT INTO dad_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Age dife di, ĩ itotoya nẽ safina nigin to fiyẽdin, agef fen, “Ĩ yana Jon,” ye itoto di, idi ganan terẽ den. ");
INSERT INTO dad_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sain anĩ bun bagai, ĩ awa kakã ye di, bale faraf yale ulõ yalaisi di, ĩ wogõ ye fen, Negur yana yalesen. ");
INSERT INTO dad_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ne tã tar terẽ de fen, anini den, age de fen, Judia neid arein, fonõ fonõ wogagã de fen, ereb wõ yen anĩ ganan wogõ den. ");
INSERT INTO dad_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Adok anĩ karĩ de fen, kisi musei dale fen, to difen, “Kesu enei naig fiya wõ youf?” Ere nigin, Odug nẽ ima ĩ bun ibodon. ");
INSERT INTO dad_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","In tama Sekaraia Awa Uur Fateulem aura fiyẽ di, ĩ profet od eig ye wogõ yen: ");
INSERT INTO dad_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Odug seli tabiyouf, Israel neid Negur, ere nigin, ĩ isi fen, in tamo kayau kafĩ fiya bun tamal kel gei fel. ");
INSERT INTO dad_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ĩ yogon kabĩ tamo Dawid nẽ fõ bun, isennadaya megeir ado yalesel ifaref, ");
INSERT INTO dad_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(are ĩ yogon profet fateul kulu temeleid sigoreid bun wogõ den kilei). ");
INSERT INTO dad_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nemã kiwai tar ado, amã nigin to orodif anĩ imeid bun tamal, kel yalemãf. ");
INSERT INTO dad_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nemã tamamã tar nigin wau yũya anĩ ifelneĩd fen, ĩ yogon bar itenẽya fateul anĩ karĩ yelen. ");
INSERT INTO dad_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ĩ wau kuturol fen, nemã tamamã Abraham irokenen. ");
INSERT INTO dad_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nemã kiwai tar imeid bun tamal kel gei famãf, agef fen, amã kumĩ sã ĩ aruna yaleya kisi falauf nigin. ");
INSERT INTO dad_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Amã nemã mabodok malauf bun, ĩ mala bun gai fateul bagai fen, madur bagai mabodõf nigin. ");
INSERT INTO dad_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Age fe di, õ neu kesu, Negur Ilun Bagai nẽ profet douf, ere nigin, õ uyu urou fen, Odug nẽ naab dodok wouf. ");
INSERT INTO dad_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","In tamo kayau neid mosor nigin wedereid tu kalauf bunem, kel yalediyouf nẽ keleĩ wenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Are nemã Negur molol nem wau yũya bunem, anĩ bun gaa kurã fiya, saa ilunem amã bun isiyouf. ");
INSERT INTO dad_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Are idi gugum bun difaref ado, laa nẽ buri bun difaref anidi bun, fula fouf, age fe di, nemã yemã delẽ anidi bun madur marã di, wau inosiya bun malauf.” ");
INSERT INTO dad_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Age fe di, kesu biya fen, uur orib yen, ĩ gerere tuan ibodok ile, dum ĩ Israel tamo kayau meleid bun wõ yen. ");
INSERT INTO dad_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sain anĩ bun, Sisa Ogastus, Rom teneub ganan bun, tamo kayau an temeleid anĩ yeneid yaleya nigin od inon. ");
INSERT INTO dad_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Eĩ urug bagai, sain Kwirinius ĩ Siria nẽ gawaman mudur ibod mog, tamo kayau yeneid dalen.) ");
INSERT INTO dad_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Anĩ nigin, ganan dogo dogo neid taun bun yeneid inoya nigin dilen. ");
INSERT INTO dad_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Anĩ nigin, Josef ĩg, oun Galili teneub Nasaret taun bun tamal Judia iselen, Betlehem Dawid nẽ taun bun iselen, ere nigin, ĩ Dawid nẽ fonõ ado in ibor bun tamal. ");
INSERT INTO dad_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ĩ Maria ado yeneid dinouf nigin diselen, ĩ Maria aiwauf nigin digirin, anĩ ĩ bou ado. ");
INSERT INTO dad_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Idi an dibod mog, kesu gõ fiya sain wõ yen. ");
INSERT INTO dad_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Age fe di, kesu monog matu gõ fen. Maria ĩ gabar nem silef fen, yaro neid beĩ bun inenen, ere nigin, tamo irouya fõ bun modoũ isokosen. ");
INSERT INTO dad_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","An gaar lo fediya tamo, melsã fonõ yerin dibod ken, bõ nedi gaar lo difedin. ");
INSERT INTO dad_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Age de mog, Odug nẽ engel idi bun wõ yen, age fe di, Odug nẽ fula fiya medeĩya kerub fedi di, idi kumĩ tererẽ den. ");
INSERT INTO dad_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anĩ ere, engel idi irokenẽdin, “Ã to kumĩ wog, aya od biya, tamo kayau ganan waud al fouf nigin arou asif. ");
INSERT INTO dad_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ere nigin, gama Dawid nẽ taun bun, ãgenei isenneĩya wõ yel, ĩ anĩ Kristus Odug. ");
INSERT INTO dad_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Enei ã bun uris. Ã momou taka gabar nem sile de fen, yaro neid beĩ bun dinenem yenek anĩ ulogouf.” ");
INSERT INTO dad_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kaisã bagai, engel musei saa ilun temeleid ulolõ deis, engel anĩ geid Negur yana dales diron, ");
INSERT INTO dad_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Negur ilun bagai bun fula fiya medeĩya, age fe di, tenebur ein tamo kayau ĩ el fedif bun, wau inosiya ibodõf.” ");
INSERT INTO dad_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sain engel idi ditorneĩd, saa ilun disele di, gaar lo fiya tamo abob dirokenen, “Odug ada irokanadal anĩ nigin, ada Betlehem teleg, ereb wõ yel anĩ taileg.” ");
INSERT INTO dad_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Anĩ nigin, idi kaisã bagai dile, Maria, Josef ado diledin, momou yaro neid beĩ bun yen mog, dilen. ");
INSERT INTO dad_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Idi ĩ dile fen, idi kesu anĩ nigin wogõ fiyẽdin anĩ od wogõ de diyon. ");
INSERT INTO dad_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Age dife di, ganan karĩ den idi, gaar lo fiya tamo wogõ difiyẽdin anĩ nigin terẽ den. ");
INSERT INTO dad_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Anĩ ere, Maria od anĩ ganan yale fen, waun ino fen, kisim dogol fen. ");
INSERT INTO dad_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Gaar lo fiya tamo keku de fen, idi wogõ fiyẽdin kilei, ereb idi karĩ den ado dilen anĩ ganan nigin, Negur seli dabi fen, yana dalesen. ");
INSERT INTO dad_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Naa eit bun, ĩ mulũ ileya saine di, ĩ yana dũ, Jesus den, yana are sina fau bou ado ya sã mog, engelem yun. ");
INSERT INTO dad_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Idi neid nonorou lilik fiya naa, Moses nẽ Lo ifaref kilei anĩ bure fele di, Josef Maria ado, Jesus Jerusalem, Odug ifenẽya nigin dirou diselen, ");
INSERT INTO dad_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(are Odug nẽ Lo itotoya bun ibodok kilei, “Kesu matu monog wõ douf ganan, Odug wenẽdigouf”), ");
INSERT INTO dad_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","idi Negur sesewi fiya difenẽf nigin diselen, Odug nẽ Lo eig ye irok kilei, “kuburir uru be, kukutir balas uru be.” ");
INSERT INTO dad_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gama Jerusalem an tamo yana Simeon ibodon, ĩ madur bagai fen, Odug nigin karĩ yeledig. Ĩ Israel waud inosiya dalouf anĩ tari fedig, Awa Uur Fateul ĩ bun ibodon. ");
INSERT INTO dad_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Awa Uur Fateulem, ĩ fau to laaf mog, Odug nẽ Kristus wõ ye di, ilouf nigin irokenen. ");
INSERT INTO dad_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Awa Uurem toli fiyẽ di, ĩ tempel nẽ modoũ bun ilen. Sain tama sina ado, Lo irok kilei age difouf nigin, kesu Jesus dirou dile di, ");
INSERT INTO dad_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon imam ĩ yales fen, Negur yana yales iron: ");
INSERT INTO dad_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Odug, õ uron kilei, õ gama ogon ferfer wau inosiya ado sur wo di, ilauf. ");
INSERT INTO dad_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aya malaum bagai ogon isennẽya anĩ ailel. ");
INSERT INTO dad_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Are ganan meleid bun saika won. ");
INSERT INTO dad_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Are haiden Israel sã anidi bun, Negur nẽ oroya kurõ falaisiya nẽ lalan, ago di, are ogon tamo kayau Israel bun fula fiya medeĩya.” ");
INSERT INTO dad_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kesu tama sina ado, od anĩ karĩ de fen, kisi bun terefeit den. ");
INSERT INTO dad_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Age dife di, Simeon el fiya ifeneĩd fen, sina Maria irokenen, “Kesu enĩ, Israel tamo kayau musei kuku douf, musei fafã douf nigin ado, ĩ daũ gen ifare di, ĩ dumen od sane dirõf nẽ uris wõ youf nigin igirnen. ");
INSERT INTO dad_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Anĩ bunem, musei waud bun dinokok are yaorouf. Age fe di, ogon malãkanon anĩg dig otem borũ fouf.” ");
INSERT INTO dad_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Profet kayau takag ibodon, Ana, Fanuel ne barai, Aser nẽ ibor bun tamal. Ĩ gai tubau bagai, ĩ tamo yale fen, aiwa ado yar sewen dibodon. ");
INSERT INTO dad_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Agef fen, ĩ waab ibodok ile, in yar eiti-fo. Ĩ tempel to itoron, bõ ado gaa ado kuri ye fen, kosẽ ye, Negur yana yalesedig. ");
INSERT INTO dad_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sain anĩ bun bagai, ĩ idi gein isel, Negur de fiye ken, Jerusalem tamo kayau kafĩ fiya bun tamal kel yalediyouf nigin ganan tari de difaren anidi, kesu anĩ nigin wogõ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josef, Maria ado, Odug nẽ Lo irok anĩ ganan dõ de kisi fele di, idi baban ke de, Galili teneub oun, nedi taun Nasaret dilen. ");
INSERT INTO dad_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","An, kesu ĩ biya fen, totol adon, ĩ kisi biya barikan, agef fen, Negur nẽ wau ifenẽya ĩ bun ibodon. ");
INSERT INTO dad_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yar ganan bun, in tama sina Pasa Sifa naa bun Jerusalem taun diledig. ");
INSERT INTO dad_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sain ĩ tuwelf yar mog, idi neid tobonunã dõ de fen, Sifa bun diselen. ");
INSERT INTO dad_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sifa bure fele di, in tama sina fonõ ke de dile mog, kesu Jesus ĩ fau Jerusalem ibodon, anĩ ere, idi to kelein. ");
INSERT INTO dad_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Idi weim melef den, age de fen, naa tekelei diyon. Age dife fen, idi mogo nedi sirag tar bun ado, nedi tã tar atun dimirnen. ");
INSERT INTO dad_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Idi ĩ to dile mã, idi ĩ dimirnẽ fenẽ nigin, Jerusalem taun baban ke de dilen. ");
INSERT INTO dad_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Naa towo bure fele di, idi ĩ tempel modoũ bun ifelnẽdiya tamo atun ibod, karĩ fiyeĩd fen, to fiyeĩd mog, fotou difiyen. ");
INSERT INTO dad_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ganan ĩ karĩ difiyen are, in karĩya nigin ado aiteid solo fen anĩ nigin, terefeit den. ");
INSERT INTO dad_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tama sina ado ĩ dile fen, fatuk bagai terẽ den. Sina ĩ irokenen, “Neu kesu, ere nigin eig wamam? Aya tamã ado waumã morõ ken, mamirnom.” ");
INSERT INTO dad_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ĩ to fen, “Ere nigin ã aya umirnagel? Aya neu Dei nẽ fõ bun abodõf ya, ã keleĩ sã de?” ");
INSERT INTO dad_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Anĩ ere, ĩ ereb irokenẽdin are, idi to kelein. ");
INSERT INTO dad_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Age dife di, ĩ weim Nasaret disil fen, sigoreid dõf el fen. Anĩ ere, in sina anĩ ganan yale, waun inon. ");
INSERT INTO dad_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus kisi biya ado bouwa orib yen, Negur ado tamo nẽ lo fiya bun biya len. ");
INSERT INTO dad_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taiberius, Sisa mudur ibodon yar fiftin bun, Pontius Pailat ĩ Judia distrik nẽ gawaman mudur ibodon, Herod ĩ Galili distrik lo fen, ĩ tura Filip Ituria distrik ado Trakonitis distrik lo fen, age fe di, Lisanias ĩ Abilene distrik lo fen. ");
INSERT INTO dad_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas Kaiafas ado pris mudur dibodon sain bun, Negur nẽ od gerere tuan oun Jon, Sekaraia naal bun isin. ");
INSERT INTO dad_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ĩ Jordan naan kalilĩ fiya ganan bun iyo ken, waud falei de fen, naan digũ di, mosor yalel kenẽdiyouf nigin biya od wogõ yen. ");
INSERT INTO dad_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Are profet Asaia nẽ itotoya bun ibodok kilei: “Ait taka gerere tuan iweig irok, ‘Odug nẽ naab dodok ge fen, madur wenẽg. ");
INSERT INTO dad_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Uus ganan bun kurokirĩya yoso fouf, arei ganan mudu ganan ado gudũ falaisi tenebur ouf. Naab goigul yedin, madur fouf, naab koũkĩ yediya yoso fediyouf. ");
INSERT INTO dad_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Age fe di, tamo kayau ganan, Negur nẽ tamo kayau kel gei fiya anĩ dilouf.’” ");
INSERT INTO dad_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tamo kayau Jonem naan igunẽdiyouf nigin guru difen anidi Jon irokenẽdin, “Ã, gogour sane gere tar! Negur nẽ didi isiyouf anĩ wal ge fen, uyagauf nigin, aim irokenein? ");
INSERT INTO dad_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wauĩ falei gef are, faat biya ũ gouf. Ã aug nigin to eig ge urõg, ‘Abraham nemã tamamã.’ Aya arokeneik, meein enidi Negur sã irõ di, Abraham gere tar wowã douf. ");
INSERT INTO dad_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Safor aayũ gariyan mogo ibodok, aayũ ganan faat biya to yuk, are itu ira ken, yã malan irãf.” ");
INSERT INTO dad_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tamo kayau guru difen anidim to difen, “Age fiyauf are, amã naig mafouf?” ");
INSERT INTO dad_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon aitedin yale iron, “Tamo ĩ gabar uru adouf are, aib ĩ sã anĩ taka ifenẽf, takag, taka ĩ saaf adouf, areg de age fouf.” ");
INSERT INTO dad_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis yaleya tamog, naan igũya nigin disin, idi to difen, “Tise, amã ere naig mafouf?” ");
INSERT INTO dad_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ĩ irokenẽdin, “Ã yaleya kilei anĩ to wal woseg waleg.” ");
INSERT INTO dad_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Age fe di, kusĩ tamo tunĩ to difiyen, “Ba amã ere naig mafouf?” Age de di, ĩ iron, “Ã nedi moni nigin ge fen, to fefu wiyẽdig fen, idegẽya bunem tamo kayau bouweid bun od to ũg. Ãgenei kabĩ mala walegedig anĩ bun dogol al gouf.” ");
INSERT INTO dad_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tamo kayau Kristus nigin tari difen, anĩ nigin, idi ganan waud bun Jon anĩ Kristus be de fen, kisi musei dalen. ");
INSERT INTO dad_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon idi ganan aitedin yale irokenẽdin, “Aya naan nem naan aguneik. Anĩ ere, taka ĩ in megeir neu wal fiya fau isif, aya to biya nigin, ayam in su nẽ malũ biru felediya kisi feleya sã. Ĩ Awa Uur Fateul yã ado nem naan iguneĩf. ");
INSERT INTO dad_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ĩ es fiya nẽ fok iman ado, ĩ yogon mayã waĩ fouf, yogon wit biya are yogon ki bun kuruf fen, wit ido yã mala faimud bun an irãf.” ");
INSERT INTO dad_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Agef fen, Jon od musei bunem, tamo kayau waud yale fen, biya od wogõ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Anĩ ere, Jonem, Herod tano anĩ nẽ mudur, tura nẽ aiwa Herodias nigin ado ereb ereb sane ganan age fen nigin ou fiyẽ di, ");
INSERT INTO dad_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod mosor ganan mosor enei ado baguf fen, ĩ Jon kalabus bun inenen. ");
INSERT INTO dad_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sain Jonem tamo kayau ganan naan iguneĩd fen, Jesus ĩg naan igunen. Age fe di, Jesus kosẽ ye mog, saa kã fele di, ");
INSERT INTO dad_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Awa Uur Fateul kuburir bouwa bun genem ĩ bun isin. Age fe di, ait taka saa ilunem isin, “Õ neu Kesu, õ nigin aya wau laa fedig, õ nigin aya wau kulĩ yedig.” ");
INSERT INTO dad_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Gama Jesus yogo ĩ yar teti age fiya bun kabĩ gariya inon. Tamo kayau kisi difen, ĩ Josef naal den, Heli naal, ");
INSERT INTO dad_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat naal, Lewi naal, Melki naal, Janai naal, Josef naal, ");
INSERT INTO dad_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatias naal, Amos naal, Nahum naal, Esli naal, Nagai naal, ");
INSERT INTO dad_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mat naal, Matatias naal, Semen naal, Josek naal, Joda naal, ");
INSERT INTO dad_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan naal, Resa naal, Serubabel naal, Sieltiel naal, Neri naal, ");
INSERT INTO dad_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melki naal, Adi naal, Kosam naal, Elmadam naal, Er naal, ");
INSERT INTO dad_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josua naal, Elieser naal, Jorim naal, Matat naal, Lewi naal, ");
INSERT INTO dad_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeon naal, Juda naal, Josef naal, Jonam naal, Eliakim naal, ");
INSERT INTO dad_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea naal, Mena naal, Matata naal, Natan naal, Dawid naal, ");
INSERT INTO dad_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesi naal, Obed naal, Boas naal, Salmon naal, Nason naal, ");
INSERT INTO dad_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab naal, Ram naal, Hesron naal, Peres naal, Juda naal, ");
INSERT INTO dad_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jakop naal, Isak naal, Abraham naal, Tera naal, Nahor naal, ");
INSERT INTO dad_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug naal, Reu naal, Peleg naal, Eber naal, Sela naal, ");
INSERT INTO dad_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainan naal, Arpaksad naal, Sem naal, Noa naal, Lamek naal, ");
INSERT INTO dad_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusela naal, Enok naal, Jared naal, Mahalalel naal, Kenan naal, ");
INSERT INTO dad_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos naal, Set naal, Adam naal, Negur naal. ");
INSERT INTO dad_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus Awa Uur Fateulem aura fiyen, Jordan naanum kel fen, Awa Uurem itonẽ, gerere tuan irou ilen. ");
INSERT INTO dad_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","An ĩ naa foti ibod mog, Satanem kisi fiyen. Ĩ sain anĩ bun ereb taka to yon, naa foti bure fele di, ĩ naũ fen. ");
INSERT INTO dad_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Agef mog, Satanem Jesus irokenen, “Õ Negur Naal ouf are, meein enei urokenẽ di, bret falei fouf.” ");
INSERT INTO dad_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus Satan aiten yale iron, “Negur nẽ Itotoya bun eig ye irok, ‘Tamo bretem dogol to mata ifenẽf.’” ");
INSERT INTO dad_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satan Jesus yale irou, modoũ ilun isel fen, kaisã bagai teneub enei nẽ tano ganan ifelnen. ");
INSERT INTO dad_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Agef fen, Satan Jesus irokenen, “Aya õ teneub enei nẽ biya fiya megeir ado ganan afonõf, ere nigin, are aya ifanan, anĩ nigin, aya aib taka ifenẽya orouf are afenẽf. ");
INSERT INTO dad_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Anĩ nigin, õ aya selu wabiyouf are, onou ganan are ogon ouf.” ");
INSERT INTO dad_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus Satan aiten yale iron, “Negur nẽ Itotoya bun eig ye irok, ‘Odug ogon Negur seli wabi fen, ĩ dogol aruna walouf.’ ");
INSERT INTO dad_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Satan Jesus yale irou, Jerusalem taun ilen, an tempel fõ soko ilun bagai inenẽ, ifaren. Satan iron, “Õ Negur Naal ouf are, ogo einenem ufũ urã. ");
INSERT INTO dad_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ere nigin, Negur nẽ Itotoya bun eig ye irok: “‘Negur õ nigin yogon engel ari fedi di, kulatun diyõf, ");
INSERT INTO dad_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","idi õ imedim ololon daleyõf, age dife di, õ yẽ meein takam to itutu ouf.’” ");
INSERT INTO dad_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus Satan aiten yale iron, “Eig ye irok, ‘Odug ogon Negur kisi fiya bun to unenẽ.’” ");
INSERT INTO dad_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan kisi fiya enei ganan bure fel fen, ĩ Jesus itorne ken, ĩ fau sain taka anĩ tari fen. ");
INSERT INTO dad_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus Awa Uur nẽ megeir bunem Galili kel ilen, age fe di, ĩ nigin od Galili teneub fonõ fonõ ganan iyokelen. ");
INSERT INTO dad_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ĩ idi neid uub fõ fõ bun biya od ifelnẽdi di, ganan ĩ yana dalesen. ");
INSERT INTO dad_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ĩ Nasaret ilen, ĩ an biyan nẽ, agef fen, Sabat naa bun, idi neid uub fõ namen ilen, gai age fedig gen. Agef fen, ĩ iwesauf nigin fã ye ifaren. ");
INSERT INTO dad_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Age fe di, profet Asaia nẽ itotoya buk kori fiya anĩ difenen, age dife di, ĩ fara fel fen, eig ye itoton anĩ imiren: ");
INSERT INTO dad_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Odug nẽ Awa Uur aya bun ibodok, ere nigin, ĩ aya maleg anidi biya od wogõ afediyouf nigin, igirna fen, mudurou bun moul fi felen. Ĩ, aya kalabus bun difaref anidi karika dalouf nigin ado, meleid ifofakeleya anidi meleid fara falauf nigin, kurõ afalaisiyouf nigin sur fiyan. Tamo kayau tunim kiwai difeneĩd fen, morõ difenẽdif anidi yalel kenẽdiya nigin sur fiyan. ");
INSERT INTO dad_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Takag, Odug nẽ biya fiya nẽ yar anĩ kurõ afalaisiyouf nigin sur fiyan.” ");
INSERT INTO dad_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Age yel fen, ĩ gaar gabar itotoya ado are korif fen, itotoya anĩ lo fedig tamo, kel ifen ken, ibodon. Juda neid uub fõ anĩ bun difaren ganan bagai, Jesus lo difelen. ");
INSERT INTO dad_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Age dife di, ĩ gariya ino fen, irokenẽdin, “Gama naa enĩ bun, Negur nẽ Itotoya enei, ãgenei karĩya bun kisi felel.” ");
INSERT INTO dad_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ganan ĩ yana dales fen, ĩ sigoron, wau ifenẽya od wogõ yen anĩ nigin terẽ den. Age de fen, idi to difen, “Eĩ Josef naal anĩ sã de?” ");
INSERT INTO dad_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus idi irokenẽdin, “Momoi bagai, aya nigin od enei tamo kayau musei wogõ dedig wogõ gouf, ‘Dokta, õ ogo ogon dagi el wo! Ereb Kapenaum taun oun agon karĩ maun anĩ, ogon fõ gariyan ein ago wo.’” ");
INSERT INTO dad_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ĩ od tobol fe fen, iron, “Aya ã momoi arokeneik, profet taka ĩ yogon fõ gariyan to karĩ difiyẽf. ");
INSERT INTO dad_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aya ã momoi bagai arokeneik, Eliya nẽ sain bun, Israel oun kayau waab musei difar mog, yar towo ogõ sigis saa katĩ fele di, teneub ganan bun uyẽ sã naũ odug difaren. ");
INSERT INTO dad_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Age de mog, Negur idi anidi taka bun Eliya to sur fen, anĩ ere, waab taka Sarefat oun Saidon teneub bun sur fen. ");
INSERT INTO dad_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Takag, Israel oun profet Elisa nẽ sain bun, musei lepra dagi ado dibodon, anĩ ere, idi atun taka lepra dagi to loko felen, Naman, Siria tamalem dogol.” ");
INSERT INTO dad_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Juda neid uub fõ bun, ganan anĩ karĩ de fen, waud sanen. ");
INSERT INTO dad_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Age de fen, idi fafã de fen, ĩ taun anĩ itor ilauf nigin dirun. Nedi taun are, arei bun nigin, siya sane bun dirãf nigin dirou dilen. ");
INSERT INTO dad_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Anĩ ere, ĩ tamo kayau atu iyok ile fen, yogon naab ilauf nẽ anĩ dõf ilen. ");
INSERT INTO dad_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Agef fen, ĩ Kapenaum taun isilen, taun are Galili distrik bun ibodok, an Sabat naa bun, ĩ tamo kayau ifelnẽdiya gariya inon. ");
INSERT INTO dad_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Idi ĩ ifelnẽdin anĩ nigin terẽ den, ere nigin, in od wogõya are megeir ado. ");
INSERT INTO dad_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Juda neid uub fõ bun, tamo taka kaa sanem irounen anĩ an ibodon. Ĩ ait ilun feis iweig iron, ");
INSERT INTO dad_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O, Jesus Nasaret tamal, õ amã ere naig wamã fenẽ? Õ amã daũ wamã fenẽ nigin usil de? Aya õ nigin keleĩ, Negur nẽ Fateul anĩ!” ");
INSERT INTO dad_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus totol ado iron, “Foro wol! Ĩ namen tamal ulõ weis!” Age ye di, kaa sane anĩ, tamo kayau ganan atun, tamo anĩ tou fiyẽ ira ken, ulõ yeis ilen, tamo are bouwa to daũ fen. ");
INSERT INTO dad_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tamo kayau ganan terẽ de fen, abob dirokenen, “Eĩ ere keleĩ eig fiya? Ĩ yana megeir adom irõ di, kaa sesen ulõ deis dilef.” ");
INSERT INTO dad_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Anĩ bunem, ĩ nigin od teneub anĩ kalilĩ fiya ganan bun iyokelen. ");
INSERT INTO dad_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus Juda neid uub fõ itor ken, Simon nẽ fõ bun ilen. Simon nẽ mam, ĩ bouwa uruwa odug ado nigin yenen anĩ, isennẽf nigin Jesus to difiyen. ");
INSERT INTO dad_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Anĩ nigin, Jesus ĩ itirne ken, bouwa uruwa dagi ou fiyẽ di, itornen. Age fe di, kayau anĩ kaisã bagai fã yale, aruneid yalen. ");
INSERT INTO dad_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gaa kuru kel mog, tamo kayau, dagi tamo dagi gariya fire fire adodo ganan, Jesus wagen guri difeid disin, age dife di, idi mugu mugu bun ima tetedin ino fen, ĩ idi el fedin. ");
INSERT INTO dad_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kaa sesen, tamo kayau musei bun, ulolõ deis fen, diweig diron, “Õ anĩ Negur Naal!” Anĩ ere, ĩ sakã fiyeĩd fen, to wogõ douf nigin sigoreid ifofan, ere nigin, idi keleĩ, ĩ Kristus. ");
INSERT INTO dad_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bonimei gugum ado, Jesus moilin ilen. Tamo kayau ĩ dimirnek dile, ĩ ibodon nẽ disi fen, ĩ idi to itornẽdiyouf nigin katũ difiyen. ");
INSERT INTO dad_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Anĩ ere, ĩ iron, “Aya Negur nẽ tano nigin biya od, taun taka takag wogõ auf, ere nigin, aya anĩ nigin sur fiyan.” ");
INSERT INTO dad_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Age ye fen, ĩ Judia distrik oun Juda neid uub fõ fõ bun, biya od wogõ yef iyon. ");
INSERT INTO dad_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Naa taka bun, Jesus Genesaret daliyou yerin ifaren. Agef mog, tamo kayau ĩ salili difiye ken, Negur nẽ od wogõ ye di, karĩ de difar mog anĩ, ");
INSERT INTO dad_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ĩ mala ira kel, waag uru naan yerin difar mog, ilen, are gau yaleya tamom an ditor yen ken, nedi kakãg kulo difen. ");
INSERT INTO dad_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ĩ waag anidi taka bun sõ yen, are Simon nẽ waag, agef fen, waag naanũ naal godof irou ilauf nigin to fiyen. Agef fen, ĩ waag bun ibod ken, tamo kayau biya od ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Sain ĩ wogõya bure fel fen, ĩ Simon irokenen, “Waag naan mala bun urou ule fen, gau yaleya nigin kakãg urofosil.” ");
INSERT INTO dad_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon aiten yale iron, “Odug, amã bõ odug kabĩ totol malel, anĩ ere, ereb taka to malel. Anĩ ere, õ urok nigin aya kakãg baban arofosilauf.” ");
INSERT INTO dad_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sain idi age difen, idi gau musei bagai gei difen, age dife di, nedi kakãg serek fou fenẽ melsan. ");
INSERT INTO dad_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Anĩ nigin, idi, nedi tã tar waag taka bun temeleid disi disennẽdiyouf nigin, gale difiyẽdin, age dife di, disi, waag uru bun gau dife isokos fen, waag uru are dimutũ fenẽ melsan. ");
INSERT INTO dad_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sain Simon Pita enĩ ile fen, Jesus iboron bobou fe fen, iron, “Odug, aya utorna ule, aya mosor nẽ tamo!” ");
INSERT INTO dad_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ere nigin, ĩ ne tã tar geid gau gei difen anĩ nigin, terefeit den. ");
INSERT INTO dad_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedi gere tar Jems Jon ado, are Simon ne kabĩ tura tar idig age difen. Age dife di, Jesus Simon irokenen, “Õ to kumĩ wo, gama naa enĩ bunem ilauf ganan, õ tamo gei wouf.” ");
INSERT INTO dad_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Age fe di, idi neid waag fiteiwõ didĩ dife di, isel fen, ereb ereb ganan ditorara ken, Jesus dõ difen. ");
INSERT INTO dad_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesus taun taka bun ibod mog, tamo taka lepra guruma barikã anĩ isin. Sain ĩ Jesus ile fen, ĩ tenebur kubũ ye kumokur fe, Jesus igone ken, iron, “Odug, õ oroyõf are, el wiyauf.” ");
INSERT INTO dad_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus ima irã, tamo anĩ kobũ fiye ken, iron, “Aya wau irok, õ bouwã biyauf.” Age ye di, kaisã bagai, lepra dagi ĩ itornen. ");
INSERT INTO dad_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Agef fen, Jesus tamo anĩ irokenen, “Õ aib taka to urokenẽf, anĩ ere, õ pris wagen ule, õ bouwã ufelnẽf, õ bouwã biyal anĩ nigin Moses nẽ od irok anĩ dõ fen, sesewi fiya wenẽf, anĩ bunem yaore di, tamo kayau dilouf.” ");
INSERT INTO dad_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Anĩ ere, ĩ nigin od fau fau iyok ilen, anĩ nigin, tamo kayau musei ĩ karĩ difiye ken, idi neid dagi yalel kenẽdiyouf nigin disin. ");
INSERT INTO dad_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Anĩ ere, Jesus sain taka taka moilin ile fen, kosẽ yedig. ");
INSERT INTO dad_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Naa taka bun, ĩ biya od ifelneĩd mog, Farisia tamo, lo ifelnẽdiya tamo geid, Galili distrik fonõ ganan, Judia distrik ado Jerusalem temeleid idi an dibodon. Age de mog, dagi el fediyouf nigin Odug nẽ megeir, ĩ bun ibodon. ");
INSERT INTO dad_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tamo tunĩ, tamo ilolaisin anĩ, gabgab bun faali de dirou disi, Jesus wagen dinenẽf nigin fõ namen dirou dilau fenẽ age difen. ");
INSERT INTO dad_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Idi anĩ age fiya nigin naab taka to dilen, ere nigin, tamo kayau ino yalen, idi fõ sokoron disel, soko korõ difel fen, ĩ gabgab ado folo folõ dife di, tamo kayau atun, Jesus wagen bagai isilen. ");
INSERT INTO dad_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus idi neid momoiya ile fen, ĩ iron, “Mou, ogon mosor alelkonok.” ");
INSERT INTO dad_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Farisia tamo, lo ifelnẽdiya tamo geid, idi dogo namedin kisi difen, “Eĩ aim bagai, kono fiya od wogõ yef? Taka nem mosor yaleleya to yenek, Negur yogo dogol.” ");
INSERT INTO dad_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus idi kisi difen anĩ kelei ken, to fen, “Ã ere nigin nameĩ bun agog kisi gef? ");
INSERT INTO dad_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Od nanĩ anĩ aya wogõya nigin karika, ‘Ogon mosor alelkonok’ de, ‘Fã wale fen, uyok ule’? ");
INSERT INTO dad_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Anĩ ere, Tamo Naal ĩ tenebur ein mosor yaleleya nigin yana ado anĩ, ã keleĩ youf nigin…” Ĩ tamo ilolaisin anĩ irokenen, “Aya õ arokonok, fã wo, ogon gabgab wale fen, fonõ ule.” ");
INSERT INTO dad_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Age ye mog bagai, ĩ fã ye, idi wagedin ifaren, yogon yenen gabgab yale, Negur yana yalesef, fonõ ilen. ");
INSERT INTO dad_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ganan terẽ de fen, Negur yana dalesen. Idi waud bun terefeit ye fen, diron, “Ada gama tobonunã fire bagai tailel.” ");
INSERT INTO dad_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Enei bure fel fen, Jesus ile, takis yaleya tamo yana Lewi, an yogon takis yaleya fõ bun ibod mog, ilen. Jesus ĩ irokenen, “Aya dõ wiya.” ");
INSERT INTO dad_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Age ye di, Lewi fã ye, ereb ereb adok itor yen, Jesus dõ fiyen. ");
INSERT INTO dad_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Agef fen, Lewi yogon fõ bun, Jesus nẽ saaf odug yabi di, takis yaleya tamo musei, tunĩ geid weim saaf don. ");
INSERT INTO dad_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Anĩ ere, Farisia tamo, idi neid lo ifelnẽdiya tamo geid, Jesus nẽ dõ fiya tar bun nauseir den, “Ã ere nigin takis yaleya tamo, mosor adodo geid, saaf ado naan wõgef?” ");
INSERT INTO dad_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus idi aitedin yale iron, “Dagi sã anidim dokta nigin waud to yenẽdig, dagi adodom dogol. ");
INSERT INTO dad_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aya madur tamo anidi iweignẽdiya nigin to asin, mosor adodo tamo anidi waud falei douf nigin asin.” ");
INSERT INTO dad_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Farisia tamo idi ĩ dirokenen, “Jon nẽ dõ fiya tar, idi kuri de fen, kosẽ dedig, Farisia tamo neid dõ fiya tar idig age fiya, anĩ ere, ogon idi dobu dirak.” ");
INSERT INTO dad_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus aitedin yale iron, “Mois ĩ fau ne tã tar weim dibod mog, ã ne tã tar idi kuriya nigin urokenẽdigouf anĩ kisi feleya de? ");
INSERT INTO dad_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Anĩ ere, naa fau isi di, anĩ bun mois tamo idi bun tamal yalelnẽ di, naa anidi bun idi kuri douf.” ");
INSERT INTO dad_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus yaab od enei idi irokenẽdin, “Taka nem gabar masak mata serek fe fen, gabar tubu bun to iwadig. Ĩ age fouf are, ĩ gabar mata anĩ serek fouf, takag, gabar mata bun tamal masak are tubu anĩ ado to susu falauf. ");
INSERT INTO dad_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Takag, taka nem wain mata meme gabar tubu bun to itinẽf. Ĩ age fouf are, wain mata anĩ, meme gabar gẽ ye fen, serek fouf. Age fe di, wain anĩ oho yeis fen, meme gabar sane lauf. ");
INSERT INTO dad_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Age fiya sã, wain mata, meme gabar mata bun itinẽf. ");
INSERT INTO dad_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Agef fen, taka nem wain tubu yakas fen, mata to orodig, ere nigin, ĩ irok, ‘Tubu are de biya.’” ");
INSERT INTO dad_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat naa taka bun, Jesus in dõ fiya tar geid, wit kabĩ atu diyok dile fen, in dõ fiya tar wit biya tunĩ fito difen, imeid bun orok de fen, nedi ilo don. ");
INSERT INTO dad_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisia tamo tunim to difen, “Ã ere nigin Sabat naa bun ĩtãfiya ufoduleg fen, tobonunã enei ago gef?” ");
INSERT INTO dad_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus aitedin yale irokenẽdin, “Sain Dawid, ne tã tar geid naũ fedi di, age fen anĩ, ã to uwesegen de? ");
INSERT INTO dad_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ĩ Negur nẽ fõ namen ile fen, bret fateul prisem dogol dõdig an ibodon anĩ yokon, ĩ bret tunĩ ne tã tareg ifenẽdin.” ");
INSERT INTO dad_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Age ye fen, Jesus idi irokenẽdin, “Tamo Naal ĩ Sabat naa nẽ Odug.” ");
INSERT INTO dad_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat naa taka bun, ĩ Juda neid uub fõ bun ile, biya od ifelnẽdin, sain anĩ bun, tamo taka ima biya melem gege fefu fiya anĩ an ibodon. ");
INSERT INTO dad_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Farisia tamo, lo ifelnẽdiya tamo geid, idi Jesus bouwa bun od dinouf nigin naab dimiren, anĩ nigin, idi ĩ Sabat naa bun dagi el fe mog, mailauf de fen, ololo difen. ");
INSERT INTO dad_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Anĩ ere, Jesus idi neid kisi kelei ken, tamo ima gege fefu fiya anĩ irokenen, “Fã wo fen, ganan meleid bun ufar.” Age ye di, ĩ fã yale, an ifaren. ");
INSERT INTO dad_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Age fe di, Jesus idi irokenẽdin, “Aya ã to ayeik, nanĩ anĩ Sabat naa bun lo dõ fiya? Biya age fiya anĩ de, sane age fiya anĩ, oo, isennẽ di, mata ibodõya anĩ de, daũ fiya anĩ?” ");
INSERT INTO dad_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesus idi ganan fele feid le fen, tamo anĩ irokenen, “Imã yaĩ wo.” Ĩ yaĩ fe di, in ima oditekei biya len. ");
INSERT INTO dad_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Anĩ ere, idi waud fatuk sane fen, mogo Jesus naig tafiyẽf de fen, dogo tutur katõ difen. ");
INSERT INTO dad_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Anĩ sain bun naa taka, Jesus arein kosẽ youf nigin iselen, bõ anĩ bun Negur kosẽ fiyen. ");
INSERT INTO dad_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","We fele di, bonimei, Jesus in dõ fiya tar wagen iweig laisi fen, idi atun tuwelf geif fen, idi anidi aposel wowã douf nigin igirnẽdin. ");
INSERT INTO dad_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Jesus ĩ yana yun Pita), in tura Endru, Jems, Jon, Filip, Batolomyu, ");
INSERT INTO dad_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jems Alfeus naal, Simon ĩ anĩ Selot taka, ");
INSERT INTO dad_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ĩ Jems naal, Judas Iskariot, inim dum Jesus kiwai imeid bun inenen. ");
INSERT INTO dad_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus idi geid weim disil, teneub uus bun difaren. In dõ fiya tar musei ado, tamo kayau musei biya, Judia distrik kalilĩ fiya ganan temeleid, Jerusalem temeleid, Taia Saidon taun ado neid ubun temeleid, an difaren, ");
INSERT INTO dad_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","tamo kayau anidi Jesus karĩ difiyẽ fenẽ nigin ado, idi neid dagi el fediyouf nigin, disin. Idi kaa sesenem morõ difenẽdin are el fedin. ");
INSERT INTO dad_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tamo kayau ganan ĩ kobũ difiyẽ fenẽ age difen, ere nigin, megeir ĩ bunem isi fen, idi ganan el fedin. ");
INSERT INTO dad_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus in dõ fiya tar lo fiyeĩd fen, iron: “Ã aib maleg are el yeik, ere nigin, Negur nẽ tano are ãgenei. ");
INSERT INTO dad_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ã gama naũ ufaregef are el yeik, ere nigin, ã nameĩ isokosauf. Ã gama maruĩ isif are el yeik, ere nigin, ã kasã gouf. ");
INSERT INTO dad_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tamo Naal nigin, tamo kayau sane diyeik, diruyei ken, kono diyeik, ã yeneĩ sane dile fen, to orodif are, Negur ã el yeik. ");
INSERT INTO dad_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Naa anĩ bun, wauĩ kulĩ ye fen, wauĩ al fouf, ere nigin, ãgenei mala solo odug oun saa ilun ibodok. Ere nigin, temeid tar profet nigin de age difedin. ");
INSERT INTO dad_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Anĩ ere, safineĩ ado ã meleĩlon ado, ere nigin, ãgenei wauĩ isenneĩya mogo walegel. ");
INSERT INTO dad_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nameĩ gama isokosef ã meleĩlon ado, ere nigin, ã naũ ulagauf. Gama kasã gef ã meleĩlon ado, ere nigin, ã fau wauĩ gudũf fen, maruĩ isiyouf. ");
INSERT INTO dad_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ã nigin tamo ganan biya de fen, wogõ def ã meleĩlon ado, ere nigin, temeid tar idegẽya profet nigin de age difedin. ");
INSERT INTO dad_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Anĩ ere, ã aib aya karĩ wiyagef anĩ arokeneik: Ãgenei kiwai tar nigin wauĩ laa fouf, ã kiwai difeneik anidi nigin biya ago gouf. ");
INSERT INTO dad_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Idi ã disisneik el fiya wenẽdig, idi ã to biya diyeik anidi nigin kosẽ gouf. ");
INSERT INTO dad_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tamo taka ogon walã sitakã fakã fouf, falei wel, walã sitakãg wenẽ. Tamo taka ogon saket yalouf are, ogon kolos yalouf nigineg to katũ wiyẽ. ");
INSERT INTO dad_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wenẽdiyouf nigin to diyok are, wenẽdiyouf, aib taka ogon safinã yalef are, anĩ baban kel yaleya nigin to urokenẽf. ");
INSERT INTO dad_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ereb taka idim age difekeneĩf anĩ oroyeik age fiya gen, ãg idi bun ago gouf. ");
INSERT INTO dad_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Idi ã nigin waud laa fef anidi nigin dogol wauĩ laa fef are, ã nigin ere mala ado? Mosor adodo idig, idi nigin waud laa fef anidi nigin, waud laa fedig. ");
INSERT INTO dad_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Idi ã nigin biya diyeik anidi nigin biya ago gouf are, ã nigin ere mala ado? Mosor adodo idig age difedig. ");
INSERT INTO dad_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Idi anidi bun moni kel walogouf nigin kisig fen, moni wenẽdigouf are, ã nigin ere mala ado? Mosor adodo idig, moni ganan kel yaleya nigin kisi de fen, mosor adodo tutur moni difenẽdidig. ");
INSERT INTO dad_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Anĩ ere, ãgenei kiwai tar nigin wauĩ laa fouf, idi nigin biya ago wedigouf, ereb taka kel yaleya nigin to kisig fen, wenẽdigouf. Ago gouf are, ãgenei mala solo odug biyauf, agef fen, ã Negur Ilun Bagai nẽ gere tar wowã gouf, ere nigin, Negur ĩ idi to de difiyẽdig sesen anidi ado, biya fiyẽdidig. ");
INSERT INTO dad_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ãgenei Temeĩ wau yũdig gen, ãg idi nigin wauĩ ineĩf. ");
INSERT INTO dad_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Taka to es wiyẽg, to ago gouf are, ãg Negur to es yeĩf. Taka bouwa bun od to ũg, to ago gouf are, ãg Negur bouweĩ bun od to yũf. Mosor nigin wedereĩ tu kalauf, ago gouf are, Negur ãgenei mosor nigin weder tu kalauf. ");
INSERT INTO dad_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wenẽdig, ago gouf are, Negur ifeneĩf. Ima su karikauf, lai fesil fen, baban teten ino isokose di, yokũ fe di, awa gere fasauf, ã nigin gogũ fouf. Tunĩ es wedigef gen, Negur ãg agef es yeĩf.” ");
INSERT INTO dad_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus yaab od eneig irokenẽdin, “Mala ifofakeleya tamo taka, mala ifofakeleya tura itonẽya kisi feleya de? Idi urom bebeigir to kuku douf de? ");
INSERT INTO dad_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skul kesu in tise to wal fef, anĩ ere, taka ĩ keleĩ ganan yalef, yogon tise gen wõ youf. ");
INSERT INTO dad_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Õ ere nigin turã mala teteur lo fen, õ ogon aa masak malã bun ibodok anĩ to ulef? ");
INSERT INTO dad_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Õ ogo aa masak ogon malã bun to ule fen, naig fe di, turã nigin dogol urokenek, ‘Turau, utor len, aya ogon malã teteur alelkonõf’? Õ mala yaleya tamo, õ ogon malã bun ketem aa masak walel fen, anĩ malã kare kele di, turã bun mala teteur walelauf. ");
INSERT INTO dad_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Aa biya ĩ faat sane to imadig, aa sane are faat biya to imadig. ");
INSERT INTO dad_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Aa mugu mugu yogon faat bun, tamo ĩ keleĩ youf. Tamo kayau idi, wei biya barik bun to daledig, gira udum bun to daledig. ");
INSERT INTO dad_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tamo biya ĩ, yogon wau bun ereb biya kuru fedig anĩ bunem, tobonunã biya yaor fedig, age fiya gen, tamo sane, yogon wau bun ereb sane kuru fedig anĩ bunem, tobonunã sane yaor fedig. Yogon wau bun isokosef, yogon sigor bun wogõ yedig. ");
INSERT INTO dad_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ere nigin ã aya nigin ‘Odug, Odug,’ ge fen, aya orok anĩ to ago gedig? ");
INSERT INTO dad_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Taka ĩ wageun isi, neu od karĩ ye fen, dõf age fef, ĩ naig fiya anĩ aya ã afelneĩf. ");
INSERT INTO dad_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ĩ fõ inoya tamo taka, ku fatuk yale fen, meein teten fõ gariya inon gen. Sain kuwei isin, wĩ ye fen, fõ yun, anĩ ere, fõ anĩ yokũ fiya kisi feleya sã, ere nigin, fõ are totol ado inon. ");
INSERT INTO dad_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Anĩ ere, taka ĩ neu od karĩ ye fen, to dõf age fef, ĩ tamo taka teneub bun fõ gariya sã inon gen. Sain kuwei wĩ ye fen, fõ yun, fõ anĩ kala fel, oditekei daũf irailen.” ");
INSERT INTO dad_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus tamo kayau karĩ douf nigin enei ganan wogõ bure fel fen, ĩ Kapenaum taun ilen. ");
INSERT INTO dad_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","An kusĩ tamo neid orowa nẽ ferfer taka, in odug ĩ nigin wau laa fedig anĩ, dagi fen, laa fou fenẽ age fen. ");
INSERT INTO dad_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kusĩ orowa Jesus nigin karĩ ye fen, Juda neid mudur adodo Jesus garan susur fedi di, ĩ isi fen, yogon ferfer el fiyẽf nigin to difiyen. ");
INSERT INTO dad_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Idi Jesus garan disi fen, totol bagai digonen, “Tamo enei, õ enĩ agouf nigin kisi feleya bagai, ");
INSERT INTO dad_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ere nigin, ĩ nemã tamo kayau nigin wau laa fedig, nemã uub fõg inon.” ");
INSERT INTO dad_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Anĩ nigin, Jesus idi geid dilen. Ĩ mogo fõ sirin mog, kusĩ orowa ne tã tar Jesus dirokenẽf nigin sur fedin, “Odug, õ kabĩ totol to walouf, ere nigin, aya to biya nigin aya kisi afef, õ neu fõ bun to usiyouf. ");
INSERT INTO dad_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aya to biya nigin, aya õ garan isiya nigineg to kisi afen. Anĩ ere, õ od urõ di, neu kabĩ tamo dagi fara falauf. ");
INSERT INTO dad_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ere nigin, aya yug nigin age fiya, ayag neu odug anĩ farumen abodok, kusĩ tamo idig aya farumeun dibodok. Aya taka enĩ arokenek, ‘Ule,’ afiyek, ĩ ilauf. Aya taka arokenek, ‘Õ usi,’ au di, ĩ isidig. Neu kabĩ tamo enĩ ago afiyek, ĩ anĩ age fedig.” ");
INSERT INTO dad_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kusĩ orowa od enĩ irõ di, Jesus karĩ ye fen, ĩ nigin terẽ yen, agef fen, tamo kayau dõ difiyen anidi bun falei yel iron, “Aya ã arokeneik, aya Israel bun, momoiya odug eig fiya taka to ailen.” ");
INSERT INTO dad_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Age ye di, kusĩ tamo sur fedin anidi, fõ bun ke de dile fen, ferfer anĩ dagi sã ibod mog, fotou difen. ");
INSERT INTO dad_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Anĩ dumen, Jesus taun taka Nain ilen, in dõ fiya tar, tamo kayau musei, ĩ geid weim dilen. ");
INSERT INTO dad_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ĩ mogo taun bobog kelẽ fiyẽ mog, laa tamo taka faali de disin, laa tamo anĩ kayau waab nẽ kesu tekelei bagai, tamo kayau musei taun temeleid kayau waab geid. ");
INSERT INTO dad_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sain Jesus kayau waab anĩ fele fiyen, in wau ĩ nigin gudũf fen, iron, “To inã wale.” ");
INSERT INTO dad_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Age ye fen, ĩ isel, dege kobũ fe di, faali difen idi, dẽ delen. Ĩ iron, “Tamo gaũ, aya õ arokonok, fã wale!” ");
INSERT INTO dad_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Laa tamo anĩ fã ye ibod ken, od yen, age fe di, Jesus tamo anĩ ĩ sina kel ifenen. ");
INSERT INTO dad_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Age fe di, idi ganan kumĩ ado terefeit de fen, Negur yana dalesen. Idi diron, “Profet odug taka, ada atun wõ yel. Negur yogon tamo kayau isennẽdiyouf nigin isil.” ");
INSERT INTO dad_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesus nigin, od enei Judia distrik kalilĩ fiya ganan iyokelen. Jesus, ");
INSERT INTO dad_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon nẽ dõ fiya tar, enei ganan nigin Jon dirokenen. Jon idi uru iweigneĩd fen, ");
INSERT INTO dad_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Odug eig de to difiyẽf nigin sur fedin, “Tamo isiyouf den, õ ogo yeir de, amã fau taka nigin malamã manouf?” ");
INSERT INTO dad_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tamo Jesus garan disi diron, “Jon Naan Igunẽdiya Tamo, õ to mayõf nigin amã sur famam, ‘Tamo isiyouf den, õ ogo yeir de, amã fau taka nigin malamã manouf?’” ");
INSERT INTO dad_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sain anĩ bun bagai, Jesus, tamo kayau musei dagi adodo, darau adodo, kaa sesenem dirounẽdin el feid fen, meleid ifofakeleya el fedi di, kelẽ den. ");
INSERT INTO dad_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesus solof irokenẽdin, “Kekug uleg fen, ã wedereim karĩ gel, meleim ulegel anĩ Jon wogõ wiyẽg, meleid ifofakelen kelẽ def, to diyon mogo diyok, lepra dagi adon mogo el fedin, wedereid daabun od karĩ def, gare den turĩ fedif, maleg bun biya od wogõ fedif. ");
INSERT INTO dad_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tamo aya nigin wau to firagagaũ fef, Negur ĩ el fiyek.” ");
INSERT INTO dad_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon nẽ arũ tamo ditornẽ dilele di, Jesus, tamo kayau guru difen anidi, Jon nigin irokenẽdin, “Ã ere bagai anĩ ulogouf nigin, gerere tuan ulegen? Ã unin yaum walala fe di, ulogouf nigin ulegen de? ");
INSERT INTO dad_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Anĩ sãf are, ere bagai ã ulogou fenẽ, ulegen? Tamo taka kolos biya bagai ifonun de? Sã, idi kolos medeĩya biya difoun ken, safineid inid adodo are, king nẽ fõ bun dibodok. ");
INSERT INTO dad_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ere bagai anĩ ã ulogou fenẽ, ulegen? Profet taka de? Ariya, aya ã arokeneik, ĩ profet wal fediya. ");
INSERT INTO dad_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tamo anĩ, ĩ nigin eig ye itoton: “‘Aya neu arũ tamo sur afe di, ĩ uyu ilauf, im ket ogon naab dodok fouf.’ ");
INSERT INTO dad_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aya ã arokeneik, kayau onudi kesu dalen idi atun, taka nem Jon to wal difiyen, anĩ ere, aib taka Negur nẽ tanon yana naal bagai ado, ĩ Jon wal fiya.” ");
INSERT INTO dad_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Tamo kayau ganan, takis yaleya tamog, sain idi Jesus nẽ od karĩ de fen, Negur nẽ naab anĩ biya den, ere nigin, idi Jonem naan igunẽdin. ");
INSERT INTO dad_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Anĩ ere, Farisia tamo, lo keleĩ tamo geid, idi dogo nigin Negur nẽ oroya ditoron, ere nigin, idi Jonem naan to igunẽdin.) ");
INSERT INTO dad_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Tamo kayau sain enei bun, idi nigin ere bunem aya kisi afouf? Idi ere gen? ");
INSERT INTO dad_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Idi simõ maket modoũ bun dibod ken, abob diweignẽdidig gen: “‘Amã ã nigin kelel maun, anĩ ere, ã to kui gen; amã kanon seg malen, anĩ ere, ã to inã walegen.’ ");
INSERT INTO dad_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aya enei wogõ auf, ere nigin, Jon naan igunẽdiya tamo isin, bret to yon, wain to yon, ã urõgef, ‘Ĩ kaa sane ado.’ ");
INSERT INTO dad_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tamo Naal isin, saaf yon, naan yon, ã urõgef, ‘Eĩ dobu irãya tamal, ĩ, takis yaleya tamo, mosor tamo adodo geid, uyu kũ difedig.’ ");
INSERT INTO dad_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Anĩ ere, kisi biya ĩ, in dõ fiya ganan bunem, biya yaorouf.” ");
INSERT INTO dad_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisia tamo takam, Jesus ĩ ado saaf dãf nigin iweignen, anĩ nigin, Jesus ĩ Farisia tamo anĩ nẽ fõ bun ile fen, tebol bun ibodon. ");
INSERT INTO dad_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Taun anĩ bun, kayau taka mosor ado ibodõdig, Jesus Farisia tamo anĩ nẽ fõ bun, saaf yoko yeya karĩ ye fen, kayau, moul sumeĩ biya bagai anĩ gulub ado irou isin. ");
INSERT INTO dad_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kayau ĩ Jesus dumen ye garan ifar, maru isi fen, Jesus ye lũ fen. Agef fen, kayau yogon fatiyam Jesus ye waĩf, umã fe, moul sumeĩ biya bagai, ye bun fi felen. ");
INSERT INTO dad_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sain Farisia tamo Jesus iweignen anim, enei ile fen, ĩ yogo kisi bun iron, “Tamo enei profet takauf, ĩ aibem kobũ fiyek, ĩ ere kayau, ĩ mosor kayau taka anĩ, keleĩ youf.” ");
INSERT INTO dad_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus ĩ irokenen, “Simon, aya ereb taka arokonõf.” Ĩ iron, “Tise, urokana.” ");
INSERT INTO dad_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus iron, “Tamo uru, moni tamo taka bun wareg dalen, taka faif tausen kina, taka faif handred kina. ");
INSERT INTO dad_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Idi urom wareg ifenẽya moni sã, anĩ nigin, moni tamo dogo neid wareg gudũ felen. Gama nanim anĩ, moni tamo nigin wau fatuk laa fouf?” ");
INSERT INTO dad_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon solof iron, “Aya kisi afef, taka ĩ wareg odug yalen anĩ gudũ fel kenen anim.” Jesus iron, “Õ tutuk es wol.” ");
INSERT INTO dad_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Age ye fen, Jesus falei yel, kayau wage ifen ken, Simon irokenen, “Õ kayau enei ulef? Aya ogon fõ bun asil. Õ yeu kulo fiya nẽ naan taka to wanal, anĩ ere, kayau ĩ yogon marum yeu lũf fen, yogon fatiyam waĩ fel. ");
INSERT INTO dad_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Õ to umã wiyal, anĩ ere, kayau enei, aya asour alel sain bun, ĩ yeu umã fel anĩ, fau fau umã fiyek. ");
INSERT INTO dad_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Õ mudurou bun moul to unol, anĩ ere, kayau ĩ moul sumeĩ biya bagai, yeu bun fi felel. ");
INSERT INTO dad_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Anĩ nigin, aya õ arokonok, kayau enĩ nẽ mosor musei yalelel, anĩ nigin, ĩ fatuk wau laa fen. Anĩ ere, aib taka mosor naal yalelen, ĩ wau laa fiya naal.” ");
INSERT INTO dad_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Age ye fen, Jesus kayau irokenen, “Ogon mosor alelkonok.” ");
INSERT INTO dad_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tamo Jesus geid dibodon, tutur dogo dogol diron, “Eĩ aim, ĩ mosoreg yalelef?” ");
INSERT INTO dad_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesus kayau anĩ irokenen, “Ogon momoiya anim isennom, waũ inosiya ado ule.” ");
INSERT INTO dad_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Anĩ dumen, Jesus taun ado fonõ fonõ iyo ken, Negur nẽ tano nigin, biya od wogõ yen. In dõ fiya tar tuwelf weim, ");
INSERT INTO dad_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kayau tunĩ idi kaa sesen iruid fen, dagi el fedin idig weim: Maria (Magdala tamal) ĩ bun kaa sesen sewen irudi di, diyan, ");
INSERT INTO dad_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana Kusa nẽ kayau, Kusa ĩ Herod nẽ fõ lo fiya tamo, Susana, musei tunĩ geid. Kayau eneidi, idi neid safineid nem disennẽdin. ");
INSERT INTO dad_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tamo kayau taun ganan bun temeleid, Jesus garan disi, moku de mog, ĩ yaab od enei iron, ");
INSERT INTO dad_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kabĩ marau taka, faat irarãf nigin ilen. Sain ĩ irarak ile mog, tunĩ naab luwen kuku ren, are teten diyon, ninã ilun temeledim dakasin. ");
INSERT INTO dad_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tunĩ meein tuar kuku ren, are bali fokũ yeid fen, laasi yedin, ere nigin, idi lumi sã. ");
INSERT INTO dad_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Faat tunĩ malũ duri atun kuku ren, are malũ duri, faat anĩ ado, odudug fen, malũ durim sile feledin. ");
INSERT INTO dad_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Faat tunĩ teneub biya bun kuku ren, are fokũ yedin, biya imadin, gariya tekelei yogon biya wan handred iman, biya anim gariya anĩ wal fiya.” Sain ĩ enĩ wogõ ye fen, ĩ iweig iron, “Taka ĩ karĩya nigin weder ado, ĩ karĩ youf.” ");
INSERT INTO dad_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","In dõ fiya tar, yaab od enĩ nẽ gariya nigin, ĩ to difiyen. ");
INSERT INTO dad_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus iron, “Negur tano nigin, iminẽya od nẽ keleĩ are, Negur ã mogo ifenein, anĩ ere, tunĩ bun aya yaab od nem wogõ auf, anĩ bunem, “‘idi meledim diledig, anĩ idi meleid fokõya sã, idi wederedim karĩ dedig, anĩ idi gariya keleĩ sã.’ ");
INSERT INTO dad_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Yaab od anĩ nẽ gariya eig fiya. Faat are Negur nẽ od. ");
INSERT INTO dad_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Faat tunĩ naab luwen kuku ren are, tamo idi od karĩ den, Satan isi, biya od idi namedin ibodok anĩ yaleledig, anĩ bunem, idi to momoi de di, to isennẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Faat tunĩ meein tuar iraran are, tamo idi od karĩ de fen, waud bun kulĩya ado od daledig, anĩ ere, idi warumutei sã. Idi sain naal bagai momoi def, anĩ ere, kisi fiya isi di, fara furu de diyaleledig. ");
INSERT INTO dad_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Faat malũ duri atun kubũ yen are, tamo idi od karĩ den, anĩ ere, idi diyok dile mog, tenebur mata ibodõya nẽ suwẽya, safina ado ibodõya nẽ kisi, bouwa nẽ oroya anidim idi sile fedi di, idi faat to yũf. ");
INSERT INTO dad_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Anĩ ere, faat teneub biya bun kubũ yen are, tamo idi, kisi biya, karĩya biya ado, waud bun ibodok, od karĩ de fen, kafĩ difelef, anĩ totol difaref, faat biya yũf. ");
INSERT INTO dad_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Taka nem lam tõf fen, mis kur be, fatar farumen to inodig. Age fiya ban, ĩ yoki bun iseginẽ di, idi aaben disif, lalan dilouf. ");
INSERT INTO dad_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ereb ereb ganan iminẽya yenek anĩ ganan yaor fouf, ereb ereb ganan nar fen yenek anĩ ganan irou isi, biru fel fen, yaau du fe di, keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Anĩ nigin, ã kisi el ge waleg fen, ã karĩ gouf. Aib taka ĩ ado, aya toru afouf, age fe di, ĩ musei adouf. Taka ĩ sã bagai, ereb taka ĩ ado nigin ĩ kisi fef areg, ĩ bun tamal son fouf.” ");
INSERT INTO dad_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus nẽ sina, tura tar geid, ĩ dilouf nigin disin. Anĩ ere, idi ĩ wagen ileya kisi feleya sã, ere nigin, tamo kayau musei. ");
INSERT INTO dad_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Takam Jesus irokenen, “Ogon sinã, turã tar geid, õ dileyõf nigin serẽ difaref.” ");
INSERT INTO dad_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus solof iron, “Neu naai ado turau tar, are idi Negur nẽ od karĩ de fen, dõ difef anidi.” ");
INSERT INTO dad_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Naa taka bun, Jesus in dõ fiya tar irokenẽdin, “Ada daliyou sitakã talauf.” Anĩ nigin, idi waag bun sõ de dilen. ");
INSERT INTO dad_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Idi solĩ de mog, Jesus mulaĩ yenen. Yau odug daliyou bun isi di, maaĩ waag namen isokosen. Idi morõ odug fotou difen. ");
INSERT INTO dad_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","In dõ fiya tar dile, Jesus turĩ difiyẽ diron, “Odug, Odug, ada naanũ talalau fenẽ!” Ĩ fã yale, yau naan moloun wĩ yen ado, sakã fiyẽdi di, yau uyẽ ado irorou kel, ganan dẽ delen. ");
INSERT INTO dad_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesus in dõ fiya tar to fiyẽdin, “Ãgenei momoiya nain?” Idi kumĩ terẽ de fen, abob toti difen, “Eĩ aim bagai? Ĩ yau ado naaneg irokenẽdi di, ĩ ait dõ difef.” ");
INSERT INTO dad_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Idi Galili tamal daliyou dibal, Gerasa teneub bun dilen. ");
INSERT INTO dad_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sain Jesus ubun kutũ yesin, taun anĩ bun tamal, tamo taka kaa sesen ado ĩ tarabã fiyen. Sain meluk, tamo enei kolos sã, fõ buneg to ibodõdig, anĩ ere, ĩ matmat bun ibodõdig. ");
INSERT INTO dad_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ĩ Jesus ile fen, kaĩ ye, Jesus ye gariyan kubũ ye, ĩ ait odugem iweig iron, “Õ aya ere naig wiyau fenẽ, Jesus, Negur Ilun Biya nẽ Naal? Aya õ agonok, õ aya to daig wiyauf!” ");
INSERT INTO dad_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ere nigin, Jesus mogo kaa sane tamo anĩ bun tamal ulõ yesiyouf nigin irokenen. Sain musei kaa sanem irounẽ di, ye ima ado, sen nem difofãdig, age de fen, tari difiyẽdig, anĩ ere, ĩ sen kokour fele di, kaa sanem wala ino di, moilin iledig. ");
INSERT INTO dad_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Age ye di, Jesus ĩ to fiyen, “Õ yana ai?” Ĩ solof iron, “Aya yanau Ami,” ere nigin, kaa museim ĩ namen disilen. ");
INSERT INTO dad_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Idi ku isil idĩya sã modoũ bun to sur fediyouf nigin, baba baban Jesus digonen. ");
INSERT INTO dad_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Arei wala sirin, bor musei biya an saaf doko difaren. Kaa sesen idi, bor namedin dilauf nigin, Jesus digonẽ di, Jesus idi yo fedin. ");
INSERT INTO dad_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kaa sesen, tamo anĩ bun tamal ulolõ deis fen, bor namedin dilelen. Age dife di, bor gududu de, bebeig sane baurin daliyoun disil, naanũ gare desin. ");
INSERT INTO dad_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bor lo fiya tamo, ereb ereb wõ yen anĩ dile fen, diya dile, od anĩ, taun ado fonõ fonõ wogõ den. ");
INSERT INTO dad_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Age dife di, tamo kayau, ereb wõ yen anĩ dilou fenẽ dilen. Sain idi Jesus garan disin, kaa sesen tamo anĩ bun tamal diyalelen tamo anĩ, garab yel, kisi biya ado, Jesus ye gariyan ibod mog, dile fen, idi kumĩ den. ");
INSERT INTO dad_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tamo idi meledim dilen anidim, kaa sesenem tamo diroun anĩ, naig be el fiyen anĩ, tamo kayau wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Age dife di, Gerasa teneub bun, tamo kayau ganan, Jesus itorneĩd ilauf nigin, ĩ dirokenen, ere nigin, idi kumim lai fedin. Anĩ nigin, Jesus waag bun sõ ye fen, itornẽdin. ");
INSERT INTO dad_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tamo ĩ bun tamal kaa sesen diyalelen anĩ, Jesus ado dilauf nigin igonen, anĩ ere, Jesus ĩ sur fiye ken, iron, ");
INSERT INTO dad_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Fonõ kel ule fen, Negur õ nigin age fen anĩ wogõ wouf.” Age ye di, tamo anĩ itor ilen, Jesus ĩ nigin age fen anĩ, taun ganan bun iyo ken, wogõ yen. ");
INSERT INTO dad_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sain Jesus kele di, tamo kayau musei, ĩ aan difiyen, ere nigin, idi ganan ĩ nigin ololo difen. ");
INSERT INTO dad_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Age de mog, Juda neid uub fõ lo fiya nẽ mudur taka, yana Jairus isi, Jesus ye gariyan kubũ ye fen, yogon fõ bun ileya nigin igonen, ");
INSERT INTO dad_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ere nigin, ĩ ne barai tekelei bagai, ĩ kayau naal tuwelf yar age fiya, mogo laa fou fenẽ. Jesus naab ile mog, tamo kayau musei kiti de fen, kafĩ difiyẽ genen. ");
INSERT INTO dad_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kayau taka an ifaren, ogõ dagi faimud ado, yar tuwelf iyon. Anĩ ere, taka nem ĩ to el fiyen. ");
INSERT INTO dad_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kayau ĩ Jesus dume ise, in kolos iri kobũ fen, age fe di, kaisã bagai, kayau nẽ naud segẽ yelen. ");
INSERT INTO dad_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus to fen, “Aim aya kobũ fiyal?” Idi ganan wa dife di, Pita iron, “Odug, tamo kayau musei kiti de fen, kobũ diyok ");
INSERT INTO dad_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Anĩ ere, Jesus iron, “Aibem aya kobũ fiyal. Aya keleĩ, totol aya bun tamal ul fe yalel.” ");
INSERT INTO dad_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Age ye di, kayau ĩ imin ken, ileya kisi feleya san, tererẽ ye fen, isi, Jesus ye gariyan kubũ yen. Tamo kayau ganan meleid bun, ĩ ereb nigin Jesus kobũ fiyem ado, naig be ĩ kaisã bagai biya lel anĩ, wogõ yen. ");
INSERT INTO dad_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Age ye di, Jesus kayau irokenen, “Nau barai, ogon momoiya anim el yom. Waũ inosiya ado ule.” ");
INSERT INTO dad_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus fau od wogõ ye mog, tamo taka, Juda neid uub fõ lo fiya mudur Jairus nẽ fõ bunem isin. Ĩ iron, “Nẽ barai mogo laa fel. Baban õ tise morõ to wenẽf.” ");
INSERT INTO dad_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus od enei karĩ ye fen, Jairus irokenen, “To kumĩ wo, momoi dogol wo, ago di, kayau fau el fiyẽf.” ");
INSERT INTO dad_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesus Jairus nẽ fõ bun wõ ye fen, takam ĩ geid, aaben ileya nigin katũ fedin, Pita, Jon, Jems ado, kesu nẽ tama sina dogol. ");
INSERT INTO dad_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tamo kayau ganan, ĩ nigin waud gudũf fen, inã legur mog, Jesus iron, “To inã waleg. Kayau naal ĩ laa fiya sã, ĩ mulã yenek.” ");
INSERT INTO dad_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Idi Jesus kasã difiyen, idi keleĩ, kayau naal laa fel. ");
INSERT INTO dad_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Anĩ ere, Jesus ĩ ima yales fen, iron, “Neu kesu, fã wo!” ");
INSERT INTO dad_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kayau nẽ uur kelen, age fe di, kaisã bagai, fã yale ifaren. Age fe di, Jesus, ĩ ereb taka ifen yõya nigin, idi irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kayau nẽ sina tama terefeit de di, ereb wõ yel anĩ, taka to dirokenẽf nigin, Jesus idi katũ fedin. ");
INSERT INTO dad_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus in dõ fiya tar tuwelf iweigneĩd fen, kuru fedin. Agef fen, ĩ, idi kaa sesen ganan dirudiyouf nigin ado, dagi el difediyouf nigin totol ifeneĩd fen, megeir fedin. ");
INSERT INTO dad_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ĩ, idi Negur nẽ tano nigin wogõ douf nigin ado, dagi adodo el difediyouf nigin sur fedin. ");
INSERT INTO dad_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesus idi irokenẽdin, “Delẽ uyõgouf nigin ereb taka to walogouf, manig sã, faa sã, bret sã, moni sã, kolos uru to walogouf, tekelei dogol. ");
INSERT INTO dad_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Fõ nanĩ be bun sõ gouf, an ubodõg ile, taun anĩ utorõgouf. ");
INSERT INTO dad_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tamo kayau ã to daleyei ken, ã to karĩ diyeĩf, sain ã nedi taun anĩ utorõg fen, yeĩ aas tu welege di, idi ã kiwai difenein anĩ keleĩf.” ");
INSERT INTO dad_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Anĩ nigin, idi fafã de, fonõ fonõ diyo ken, modoũ ganan bun, biya od wogõ de fen, tamo kayau dagi el difedin. ");
INSERT INTO dad_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galili lo fiya nẽ mudur Herod, anĩ ganan wõ yef ilef anĩ, karĩ ye fen, wau togun, ere nigin, tunim dirok, Jon ĩ laa bun tamal mata kel fã yen, ");
INSERT INTO dad_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","tunim dirok, Eliya wõ yen, age fe di, tunĩg dirok, profet kulu temeleid anidi taka mata kel fã yen. ");
INSERT INTO dad_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Anĩ ere, Herod iron, “Aya Jon ula gudũ afen. Enei aim, ĩ nigin karĩ auf?” Age ye fen, ĩ Jesus ileya nigin kisi fen. ");
INSERT INTO dad_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sain aposel idi keku den, idi age difen anĩ Jesus wogõ difiyen. Age de di, Jesus idi geif irou, idi mugu diya, taun taka Betsaida dilen. ");
INSERT INTO dad_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Anĩ ere, tamo kayau musei anĩ kelei ken, Jesus dõ difen. Jesus idi aan fiyeĩd, Negur nẽ tano nigin wogõ fiyeĩd fen, idi dagi el fiya nẽ anidi el fedin. ");
INSERT INTO dad_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aragau di, in dõ fiya tar tuwelf, ĩ gein disi diron, “Tamo kayau susur wo di, idi fonõ kalilĩ fiya fonõ fonõ dile fen, saaf ado yenẽya modoũ dilouf, ere nigin, ada ein gerere tuan tabodok.” ");
INSERT INTO dad_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesus aitedin yale iron, “Idi dãf nigin ereb ãgem wenẽdigouf.” Idi solo de diron, “Ada bret faif, gau uru ado dogol. Ada tele, tamo kayau enei ganan nigin saaf to na talouf, are kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Faif tausen tamo age fiya an dibodon.) Anĩ ere, Jesus in dõ fiya tar irokenẽdin, “Tamo kayau, mala fire fire fifti age fiya bun, ubodnẽdig.” ");
INSERT INTO dad_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","In dõ fiya tar age dife di, ganan dibodadan. ");
INSERT INTO dad_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesus, bret faif gau uru ado yale, saa ilun itad fen, ĩ Negur de fiye ken, anĩ mumã fedin. Agef fen, ĩ in dõ fiya tar ifenẽdin, tamo kayau wagedin gõ difouf nigin. ");
INSERT INTO dad_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Idi ganan don kisi felen. In dõ fiya tar, tamo kayau bret gau ado dokon, tunĩ ifaren anĩ fito difen, karam tuwelf isokosen. ");
INSERT INTO dad_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sain Jesus mugun kosẽ yen, in dõ fiya tar idi ĩ weim. Ĩ idi to fedin, “Tamo kayau idi, aya nigin ai dedig?” ");
INSERT INTO dad_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Idi solo de diron, “Tunĩ dirok, Jon naan igunẽdiya tamo, tunĩ dirok, Eliya, are tunĩg dirok, profet kulu temeleid anidi taka mata kel fã yen.” ");
INSERT INTO dad_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesus to fedin, “Ba ã uleg? Aya nigin ã ai gef?” Pita aiten yale iron, “Õ anĩ Negur nẽ Kristus.” ");
INSERT INTO dad_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Age ye di, Jesus enei taka to dirokenẽf nigin, idi wedereid totol iroun. ");
INSERT INTO dad_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Age ye fen, ĩ iron, “Tamo Naal ĩ darau musei yale fen, mudur adodo, pris odudug, lo ifelnẽdiya tamo idim dudum difiyẽf. Age de fen, ĩ dukesi di, naa towo bure fele di, mata kel fã youf.” ");
INSERT INTO dad_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Age ye fen, Jesus idi ganan irokenẽdin, “Aib taka aya dõ fiyau fenẽ, ĩ yogon oroya dudum fe fen, yogon aa tetek, naa ganan faali fe, aya dõ fiyauf. ");
INSERT INTO dad_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aib taka, yogon bouwa buru, mata ibodõf nigin oro fef, are fõ yalauf, anĩ aib taka yogon mata bouwa buru, aya nigin ye fen, irailauf, are kel yalouf. ");
INSERT INTO dad_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tamo taka ĩ teneub enĩ ganan kakarai fe, akorou ye fen, ĩ yogo bou fõ yalauf be irailauf, ere biya ĩ yalouf? ");
INSERT INTO dad_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aib taka, aya nigin ado neu od nigin, mama fouf are, sain Tamo Naal, in fula fiya medeĩya, Tama nẽ ado, engel fateul neid fula fiya medeĩya ado disiyouf bun, ĩg ĩ nigin mama fouf. ");
INSERT INTO dad_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aya ã momoi arokeneik, tunĩ ein difaref, fau to gare de mog, idi Negur nẽ tano dilouf.” ");
INSERT INTO dad_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesus enei irokel fen, naa eit age fiya ilele di, ĩ, Pita, Jon, Jems yale, kosẽ youf nigin arei ilun diselen. ");
INSERT INTO dad_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ĩ kosẽ ye mog, yogon nawa falei felen, agef fen, yogon kolos, kolimei filiya nẽ lalan gen, wõ yen. ");
INSERT INTO dad_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tamo uru, Moses Eliya ado, ");
INSERT INTO dad_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","fula fiya medeĩya ado wowã de fen, Jesus geid wogõ den. Idi Jesus teneub itorõf anĩ nigin wogõ den, anĩ ĩ Jerusalem oun kisi falauf. ");
INSERT INTO dad_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ĩ, ne tã tar geid, mulã nigin meleid morõ kelen, anĩ ere, idi oditekei meleid bi fel fen, idi Jesus nẽ fula fiya medeĩya ado, tamo uru ĩ geid difaren anĩ dilen. ");
INSERT INTO dad_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tamo idi Jesus ditornẽ mog, Pita Jesus irokenen, “Odug, ada ein ibodõya nigin biya bagai. Ada salafat towo tanouf, taka ogon, taka Moses nẽ, taka Eliya nẽ.” (Ĩ wogõ yen anĩ, ĩ yogo keleĩ sã.) ");
INSERT INTO dad_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Age ye mog, lalo isi, idi kerub fedi di, idi lalo bun dilel mog, kumĩ den. ");
INSERT INTO dad_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ait taka lalo bunem wõ ye fen, iron, “Eĩ neu Kesu, ayam ĩ agirnen. Ĩ karĩ wiyẽg.” ");
INSERT INTO dad_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ait anĩ wogõ yele di, idi Jesus mugu dilen. In dõ fiya tar anidi, enei dogo bun dogol ibodon, idi ereb dilen anĩ, sain anĩ bun, taka to dirokenen. ");
INSERT INTO dad_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Naa taka bun, idi arein tamal disi mog, tamo kayau musei Jesus tarabã difiyen. ");
INSERT INTO dad_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Guru fiya atun, tamo takam iweig iron, “Tise, aya õ agonok, õ neu kesu ulekanauf, ere nigin, ĩ neu kesu tekelei bagai. ");
INSERT INTO dad_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kaa sanem irounẽ di, ĩ terẽ adod ye, ui yedig. Kaa sanem kesu yũ irã di, tererẽ ye fen, awa bun sali moku fedig. Agef fen, kaisã to folõ fiye kele fen, ĩ bouwa daũ fedig. ");
INSERT INTO dad_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aya, on dõ fiya tar kaa sane diruwauf nigin agonẽdin, anĩ ere, idi kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus solof iron, “Sain enei bun, tamo kayau momoiya sã, sane bagai. Sain ganĩ aya ã geid tabod ken, ã nigin wau aukesilauf? Ogon kesu ein urousi.” ");
INSERT INTO dad_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kesu anĩ isi mog, kaa sanem kesu tenebur yũ irã di, tererẽ yen. Anĩ ere, Jesus kaa sane ou fiyen, agef fen, kesu anĩ el fiye ken, ĩ tama kel ifenen. ");
INSERT INTO dad_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Age fe di, idi ganan, Negur nẽ megeir odug nigin terefeit den. Idi ganan, Jesus age fen anĩ ganan nigin, terẽ de mog, Jesus in dõ fiya tar irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ereb aya arokeneĩf anĩ wedereĩ unog. Tamo Naal ĩ fau kiwai tamo imeid bun dinou fenẽ.” ");
INSERT INTO dad_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Anĩ ere, idi od enĩ nẽ gariya nigin nene den. Idi nigin gariya anĩ inokon, anĩ nigin, idi od anĩ to kelei ken, ĩ to fiyẽya nigin kumĩ den. ");
INSERT INTO dad_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesus nẽ dõ fiya tar idi, aim anĩ idi atun odug ibodõf nigin, luwa diroun. ");
INSERT INTO dad_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus idi neid kisi kelei ken, kesu naal taka yale iroule, ĩ sirin ifarnen. ");
INSERT INTO dad_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Agef fen, ĩ idi irokenẽdin, “Aib taka, aya yanau bunem, kesu naal eig fiya taka yalef are, ĩ aya yaleyaf. Aib taka ĩ aya yaleyaf are, ĩ aya sur fiyan anĩ yalef. Ã ganan atun, taka ĩ naal bagai are, ĩ anĩ odug bagai.” ");
INSERT INTO dad_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon iron, “Odug, tamo taka, õ yanã nem kaa sesen iruid mog, amã mailen. Anĩ nigin, amã ĩ katũ mafiyẽf nigin age mafen, ere nigin, ĩ neda takam sã.” ");
INSERT INTO dad_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Anĩ ere, Jesus iron, “To katũ wiyẽg, taka ĩ kiwai to ifeneik, are ãgenei.” ");
INSERT INTO dad_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus saa ilun yale irou iseleya nẽ naa dodole di, ĩ Jerusalem ileya nigin wau kuturolen. ");
INSERT INTO dad_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Age fe di, ĩ arũ tamo uyu sur fedi di, idi Jesus nẽ ereb ereb dodok fiya nigin, Samaria fonõ dilen. ");
INSERT INTO dad_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Anĩ ere, tamo kayau an to aan difiyen, ere nigin, ĩ Jerusalem ilauf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sain in dõ fiya tar Jems Jon ado, anĩ dile fen, idi to difen, “Odug, õ amã yã saa ilun tamal maweig di, isi, idi daũ fediyouf nigin oroyok de?” ");
INSERT INTO dad_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Anĩ ere, Jesus falei yel, ou fiyẽdin, ");
INSERT INTO dad_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","age de fen, idi fonõ taka bun dilen. ");
INSERT INTO dad_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Idi naab luwe dile fen, tamo taka Jesus irokenen, “Õ narib ulauf are, aya õ dõ ayõf.” ");
INSERT INTO dad_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus aiten yale iron, “Gaũ kuĩ idi, yenẽya nẽ modoũ ku ado, ninã lalo bun diyok idi, uru ado, anĩ ere, Tamo Naal ĩ mudur inoya nẽ modoũ sã.” ");
INSERT INTO dad_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesus tamo takag irokenen, “Dõ wiya.” Anĩ ere, tamo iron, “Odug, fau de, folõ wiya len, aya ele, neu dei mũ afel fen.” ");
INSERT INTO dad_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus ĩ irokenen, “Laa tamo idi, laa tutur abob mumã difouf. Anĩ ere, õ ule, Negur nẽ tano nigin wogõ wo.” ");
INSERT INTO dad_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Baban takag iron, “Odug, aya õ dõ ayõf, anĩ ere, folõ wiya len, kelau ele, neu ibor tar dabuo afiyeĩd fen.” ");
INSERT INTO dad_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus solof iron, “Taka ĩ dur bun ima ino fen, koriri yedig anĩ, Negur nẽ tano nigin kabĩ yaleya to kisi falauf.” ");
INSERT INTO dad_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Anĩ dumen, Odug sewenti-tu tamo igirneĩd fen, idi, ĩ taun ganan ado modoũ ilauf nẽ bun, uyulil uru uru susur fedin. ");
INSERT INTO dad_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesus idi irokenẽdin, “Kabier saaf musei biya bure felen, anĩ ere, kabĩ tamo musei sã. Age fiya nigin, kabĩ marau, Odug to wiyẽg, kabĩ tamo sur fedi di, yogon kabier dilauf. ");
INSERT INTO dad_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Uleg! Aya ã sipsip naal gen, gaũ kuĩ atun sur ayeik. ");
INSERT INTO dad_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ã moni nẽ kodol be, faa be, su be to walogouf, agog fen, naab luwen taka to aan wiyẽgouf. ");
INSERT INTO dad_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Fõ taka aaben ulagauf, uruwa urõgouf, ‘Fõ enei wau inosiya ado.’ ");
INSERT INTO dad_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tamo taka wau inosiya nẽ anĩ an ibodõf are, ãgenei wauĩ inosiya ĩ bun ibodõf, sãf are, ã bun kel isiyouf. ");
INSERT INTO dad_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Fõ anĩ bun ubodõgouf, saaf ado naan yõya nigin idi difeneĩf, are wãgauf, ere nigin, kabĩ tamo ĩ mala solo yaleya kisi feleya. Fõ fõ to walegef uyõg. ");
INSERT INTO dad_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ã taun taka bun ulege di, idi ã aan diyeĩf, ã ereb wagein dinouf anĩ wãgauf. ");
INSERT INTO dad_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dagi adodo an difaref, el wiyẽdig fen, idi urokenẽdigouf, ‘Negur nẽ tano mogo ã nigin melsã.’ ");
INSERT INTO dad_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Anĩ ere, ã taun taka bun ulege di, idi ã to aan diyeĩf, naab toko tokõ ge fen, urõgouf, ");
INSERT INTO dad_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ãgenei taun nẽ aas yemã bun degẽ fen anĩg, amã kema ã bun tu mafef. Anĩ ere, ã enei keleĩ youf bagai, Negur nẽ tano mogo melsã.’ ");
INSERT INTO dad_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aya ã arokeneik, es fiya naa anĩ bun, taun anĩ, in darau Sodom taun darau dalen anĩ wal fiya, yalouf. ");
INSERT INTO dad_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasin taun, õ malalon ado! Betsaida taun, õ malalon ado! Ã bun memelik musei anodin, age fiya gen anĩ, Taia ado Saidon taun bun wõ yem are, mogo kulu waud falei de fen, wau gudũ fiya nẽ gabar difoun ken, aasur dibodom. ");
INSERT INTO dad_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anĩ nigin, es fiya sain bun, ã, morõ Taia ado Saidon taun dalouf anĩ wal fiya, walogouf. ");
INSERT INTO dad_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Õ Kapenaum taun, õ yanã anĩ saa ilun iselauf de? Sã bagai, õ laa neid modoũ bun usilauf. ");
INSERT INTO dad_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Taka ĩ karĩ yeik, aya karĩ fiyaf, taka ĩ ã iruyeik, are aya iruyaf, anĩ ere, taka ĩ aya iruyaf, are ĩ aya sur fiyan anĩ iruf.” ");
INSERT INTO dad_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sewenti-tu tamo idi, kulĩya ado keku de, disi diron, “Odug, õ yanã bunem kaa seseneg morõ di, dõ difen.” ");
INSERT INTO dad_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus solof iron, “Aya, Satan saa ilunem kolimei lalan gen kakur fen, kubũ ye mog, ailen. ");
INSERT INTO dad_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aya, ã, gogour, ambei lalai wedig fen, kiwai nẽ totol ganan wal gouf nigin, megeir afenein. Ereb takam to tadũ yeĩf. ");
INSERT INTO dad_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Anĩ ere, kaa sigoramã dõ difel ge fen, to wauĩ kulĩ youf, anĩ ere, ãgenei yeneĩ saa ilun itoton nigin, wauĩ kulĩ youf.” ");
INSERT INTO dad_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sain anĩ bun, Jesus, Awa Uur Fateul bunem, kulĩya isokos fen, iron, “Dei, saa ado teneub nẽ Odug, aya õ yanã alesef, ere nigin, safina eneidi, kisi biya ado keleĩ adodo to dilouf nigin, õ unokon, ago fen, simõ gen dibodon anidi bun yaor won. Dei, enĩ are ogon waũ filolõ fiya biya bunem agon. ");
INSERT INTO dad_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ereb ereb ganan, Dei ĩ aya bun inon. Taka nem Naal ĩ ai ya nigin keleĩ sã, Dei yogo dogol keleĩ. Taka nem Dei ĩ ai ya nigin keleĩ sã, Naal yogo dogol ado, tunĩ idi Naalum Dei ifelnẽdiyouf nigin igirnẽdif anidim dogol keleĩ.” ");
INSERT INTO dad_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Age ye fen, Jesus falei yel, in dõ fiya tar lo feid fen, idi dogol irokenẽdin, “Meleim ã ulegedif anĩ dilef are el fedif. ");
INSERT INTO dad_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ere nigin, aya ã arokeneik, profet musei, king geid, ã ulegef anĩ dilou fenẽ nigin waud yenen, anĩ ere, idi meledim to dilen, idi ã karĩ gef anĩ karĩ dou fenẽ nigin waud yenen, anĩ ere, idi wederedim to karĩ den.” ");
INSERT INTO dad_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sain taka bun, lo keleĩ tamo taka fã ye fen, Jesus kisi fiyen. Ĩ Jesus to fiyen, “Tise, aya naig afe di, mata faimud ibodkeleya anĩ alouf?” ");
INSERT INTO dad_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus ĩ irokenen, “Negur nẽ Itotoya bun Lo ere yef? Õ uwesedig anĩ, ere yõdig?” ");
INSERT INTO dad_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lo keleĩ tamom Jesus solof irokenen, “‘Õ, Odug ogon Negur ĩ nigin waũ adok, malãkanon adok, ogon megeir adok, ogon kisi adok bunem, waũ laaf yenẽf.’ Takag, ‘Õ ogo nigin waũ laa fef gen, nẽ tã nigineg ago waũ laa fouf.’” ");
INSERT INTO dad_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus tamo anĩ irokenen, “Õ de tutuk solo wol. Enei ago di, õ mata ibodkeleya walouf.” ");
INSERT INTO dad_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Anĩ ere, lo keleĩ tamo ĩ, Jesus ĩ nigin keleĩ biya sã fiyẽf anĩ itor ken, Jesus to fiyen, “Age fiyauf are, ai anĩ neu tã?” ");
INSERT INTO dad_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus solof iron, “Tamo taka Jerusalem taun tamal Jeriko taun isil mog, bẽ tamo imeid bun ilen. Idi yogon kolos dinukeis dũ di, laa gen yen mog, ditornẽ diyalelen. ");
INSERT INTO dad_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sain anĩ bun, pris taka naab tekelei anĩ dõf isilen, tamo are de ile fen, ĩ fasis fe tokõ felen. ");
INSERT INTO dad_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Age fiya gen, Lewi tamo takag modoũ anĩ bun isi, tamo are de ile fen, ĩ fasis fe tokõ felen. ");
INSERT INTO dad_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Anĩ ere, Samaria tamo taka iyok isin, tamo yenen nẽ isi, wõ ye, tamo anĩ ile fen, ĩ nigin wau yun. ");
INSERT INTO dad_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ĩ wagen ilen, moul wain ado gudũ fiya bun fi fel fen, ifokenen. Agef fen, tamo are yales, yogon donki teten ino irou ilen, tamo irouya fõ bun ino fen, kulatun fiyen. ");
INSERT INTO dad_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Naa taka di, ĩ tu silwa koin moni yalis, tamo irouya fõ marau ifen ken, iron, ‘Kulatun wiyẽf, sain aya kelauf bun, õ baban mala teten be uran, are aya kela afonõf.’ ");
INSERT INTO dad_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Õ kisi wof, towo eneidi atun, ai anĩ, bẽ tamo imeid bun ilen anĩ ĩ ne tã?” ");
INSERT INTO dad_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lo keleĩ tamo solof iron, “Tamo ĩ nigin wau yun anĩ.” Jesus ĩ irokeken, “Ule, ĩ age fen gen, ago.” ");
INSERT INTO dad_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus, in dõ fiya tar geid, naab luwe dile fen, Jesus fonõ taka bun wõ yen, an kayau yana Marta yogon fõ bun Jesus ilauf nigin, Jesus irokenen. ");
INSERT INTO dad_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ĩ tura yana Maria, ĩ anĩ, Odug ye gariyan ibod ken, ĩ wogõ yen anĩ karĩ yen. ");
INSERT INTO dad_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Anĩ ere, Marta ereb ereb dodok fiya anĩ bun kisi yen ken, Jesus wagen isi to fiyen, “Odug, neu turau itorna di, aya mugu kabĩ alef anĩ nigin, õ to kisi wof de? Ĩ uroken, aya isenna!” ");
INSERT INTO dad_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Age ye di, Odug aiten yalen, “Marta, Marta, õ ereb ereb musei nigin suwẽ wo fen, waũ morok, ");
INSERT INTO dad_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","anĩ ere, tekelei dogol õ nigin biya. Maria ĩ biya ani igirim, anĩ taka nem to yalelkenẽf.” ");
INSERT INTO dad_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Naa taka bun, Jesus modoũ taka bun kosẽ yen. Sain ĩ bure fele di, yogon dõ fiya tamo takam Jesus irokenen, “Odug, amã kosẽya nigin ufelnamã, Jon, ne dõ fiya tar ifelnẽdin gen.” ");
INSERT INTO dad_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus idi irokenẽdin, “Sain ã kosẽ gouf, eig ge urõgouf: “‘Dei, õ yanã fateul ibodõf, ogon tano isiyouf. ");
INSERT INTO dad_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Naa mugu mugu bun, naa anĩ nẽ saaf wanamãf. ");
INSERT INTO dad_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ganan amã bun mosor dinof, amã idi neid mosor nigin wederamã tu kelef, age fiya bagai, õg amã nemã mosor nigin wederẽ tu kel. Ago fen, kisi famãya bun to uroulemãf.’” ");
INSERT INTO dad_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Age ye fen, ĩ idi irokenẽdin, “Ãgenei taka ĩ, ne mou ado, anĩ bõ atun ĩ gein ile fen, irokenẽf, ‘Mou, bret towo nem usenna, ");
INSERT INTO dad_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ere nigin, aya neu tã taka, aya bun delẽ isil, anĩ ere, aya ĩ yõya nẽ ereb taka sã.’ ");
INSERT INTO dad_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Age ye di, ĩ aaben tamal anim irõf, ‘Aya kabĩ totol to wana. Sukar mogo kotũ felel, aya neu kesu tar geid mogo fataren mainek. Aya fã au fen, ereb taka ifonõya kisi feleya sã.’ ");
INSERT INTO dad_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aya ã arokeneik, ĩ, ne mou nigin to fã ye fen, bret ifenẽf, anĩ ere, tamo are kukĩya sã kinĩ yei fiyẽ di, fã ye fen, ereb ĩ orof anĩ kilei ifenẽf. ");
INSERT INTO dad_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Anĩ nigin, aya ã arokeneik, to gouf, agef ã ifeneĩf; umirẽgouf, ã gurug gouf; godu godu gouf, ã sukar kã feneĩf. ");
INSERT INTO dad_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aibem taka to fouf, yalouf; aibem taka imirek, gurug fouf; aibem taka godu godu fouf, sukar kã fel kenẽf. ");
INSERT INTO dad_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ã tama tar, aim ãgenei kesu gau nigin to fef, anĩ ban gogour wenẽgouf de? ");
INSERT INTO dad_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Takag, ĩ tataro faat nigin to fef, ĩ ambei wenẽgouf de? ");
INSERT INTO dad_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ã seseneĩ bagai, anĩ ere, ãgenei kesu safina biya biya anĩ ifenẽdiya, ã keleĩ bagai youf are, ãgenei anĩ wal fiya, Temeĩ saa ilun ibodok, Awa Uur Fateul aib idi to difiyek, idi ifenẽdiyouf bagai!” ");
INSERT INTO dad_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus ait ifokeleya nẽ kaa sane irun. Sain kaa sane iyawo di, tamo ait ifokelen od wogõ yen, age fe di, tamo kayau musei terẽ den. ");
INSERT INTO dad_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Anĩ ere, tamo tunĩ diron, “Are kaa sane neid mudur Belsebub yana bunem, ĩ kaa sesen irudif.” ");
INSERT INTO dad_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tunĩ Jesus kisi difiye ken, saa ilun tamal uris nigin to difen. ");
INSERT INTO dad_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesus idi neid kisi kelei ken, idi irokenẽdin, “Tano taka yogo kiwai ifen ken, fara fouf, are sane lauf, fõ taka yogo kiwai ifen ken, fara fouf, are kubũ youf. ");
INSERT INTO dad_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satan ĩ yogo kiwai ifen ken, fara fouf are, yogon tano naig fe ifarauf? Aya enĩ orok, ere nigin, ã urõgef, aya Belsebub yana bunem kaa sesen arudif. ");
INSERT INTO dad_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Are aya Belsebub yana bunem kaa sesen arudif are, ere bunem ãgenei dõ fiya tar kaa sesen dirudidig? Anĩ nigin, idim ã es diyeĩf. ");
INSERT INTO dad_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Anĩ ere, aya Negur nẽ ima gege bunem kaa sesen arudif are, Negur nẽ tano mogo ã bun isil. ");
INSERT INTO dad_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Tamo megeir ado taka, ĩ waila kisi feleya ado yogon fõ lo fef are, in safina are totoũ. ");
INSERT INTO dad_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Anĩ ere, taka ĩ yogon megeir wal fiya anim irounẽ lai fiye ken, yogon waila ĩ anĩ bun totol yaledig anĩ son fe fen, in safina gadõ fouf. ");
INSERT INTO dad_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Taka ĩ aya to fedẽ fiyaf, ĩ neu kiwai, takag, ĩ aya ado to kuru mafef are, ĩ firagagaũ fef. ");
INSERT INTO dad_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Sain kaa sane tamo bun tamal ulõ yeis fen, gerere tuan ile, si inoya modoũ imirek ile to fotou fef. Agef fen, ĩ irok, ‘Aya fõ atoron anĩ bun baban kelauf.’ ");
INSERT INTO dad_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sain ĩ kel isif, fõ ani waĩ difel fen, madur difen anĩ ilef. ");
INSERT INTO dad_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Anĩ nigin, ĩ ile fen, baban kaa sesen ĩ wal fiya sewen anĩ geif irou isif, age de fen, idi namen dile difaref. Age dife di, tamo anĩ gai sane bagai lef, uruwa bun nẽ tobonunã anĩ wal fiya.” ");
INSERT INTO dad_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus eneidi nigin wogõ ye mog, tamo kayau atun kayau taka iweig iron, “Sinã õ gõ yo ken, su ifonon, are ĩ el fiyek.” ");
INSERT INTO dad_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ĩ solof iron, “Age fiya ban, Negur nẽ od karĩ de fen, dõ difef anidi, el fedif.” ");
INSERT INTO dad_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tamo kayau guru fiya mala oduge di, Jesus iron, “Tamo kayau, gama sain enei bun dibodok, are sane bagai. Idi memelik nigin to difef, anĩ ere, taka to afenẽdiyouf, de profet Jona nẽ uris anĩ dogol afenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona are Niniwe taun tamo kayau bun uris, age fiya bagai, Tamo Naal ĩg sain enei nẽ tamo kayau bun uris. ");
INSERT INTO dad_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Es fiya sain bun, Kuin Saut tamal fã ye fen, tamo kayau sain enei bun geid, idi neid mosor nigin kurõ falaisiyouf, ere nigin, kayau anĩ Solomon nẽ keleĩ karĩ youf nigin, teneub idiyan tamal isin, gama taka Solomon wal fiya are yeir. ");
INSERT INTO dad_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Es fiya sain bun, Niniwe tamo kayau fã de fen, tamo kayau sain enei bun geid, idi neid mosor nigin kurõ difalaisiyouf, ere nigin, idi mogo Jona wogõ ye di, waud falei den, gama taka Jona wal fiya are yeir. ");
INSERT INTO dad_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Taka nem lam tõf fen, to iminẽyan be, beĩ kur inodig, age fiya ban, in yoki bun iseginẽdig, age fe di, idi aabẽ disif anidi lalan dilouf. ");
INSERT INTO dad_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Malã are bouwã nẽ lam. Õ malã biyauf are, ogon bouwã gananeg lalan barikãf. Anĩ ere, õ malã sesen lauf are, ogon bouwãg gugum kalauf. ");
INSERT INTO dad_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Anĩ nigin, lalan õ ado anĩ gugum keleya nigin lo walauf. ");
INSERT INTO dad_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Age fiya nigin, ogon boũ ganan lalan barikãf fen, siri sitakã to gugum ouf are, lam nẽ lalan õ bun so fe di, yaor ledig gen, bouwa ganan oditekei lalan ouf.” ");
INSERT INTO dad_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sain Jesus wogõ ye bure fele di, Farisia tamo takam ĩ, Jesus ado saaf dãf nigin iweignẽ di, aaben ile, tebol bun ibodon. ");
INSERT INTO dad_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Anĩ ere, Farisia tamo ĩ, Jesus ima ketem kulo fiya sã, saaf nigin ibodon anĩ ile fen, terẽ yen. ");
INSERT INTO dad_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Age fe di, Odug ĩ irokenen, “Farisia tamo ã, kap ado beĩ agara kulo gedig, anĩ ere, ã namein akorouya ado sanem barikã. ");
INSERT INTO dad_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ã neneya tamo! Negur agara inon anĩ, nameg to inon de? ");
INSERT INTO dad_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Anĩ ere, ereb beĩ namen ibodok anĩ maleg wenẽdigouf, ago ge di, ereb ereb ganan ã bun filiya ibodõf. ");
INSERT INTO dad_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Farisia tamo ã meleĩlon ado, ere nigin, ã ãgenei edẽ, bakso ado, kabier tamal ereb ereb ganan farag fen, ten tekelei Negur wenẽgedig, anĩ ere, ã lo es fiya ado Negur nigin wau laa fiya utorõgedig. Ã dum nẽ anĩ dõg fen, uruwa nẽ anĩg to utorõgem, are dem. ");
INSERT INTO dad_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Farisia tamo ã meleĩlon ado, ere nigin, ã Juda neid uub fõ bun modoũ malabag ibodõya ado, maket modoũ bun tamo kayau idim sere diyeik anĩ oroyeik. ");
INSERT INTO dad_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ã meleĩlon ado, ere nigin, ã tamo mekura dede fiya gen, tamo idi keleĩ sa ken, teten diyõdig.” ");
INSERT INTO dad_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lo keleĩ tamo taka Jesus irokenen, “Tise, õ enei urõ di, õ amãg kono wamak.” ");
INSERT INTO dad_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus solof iron, “Lo keleĩ tamo, ãg meleĩlon ado, ere nigin, ã tamo kayau, morõ idi faali fiya nigin malai bagai anĩ wenẽdigedig, anĩ ere, ã aug imeĩ gege tekelei idi isennẽdiya nigin to fitei yedig. ");
INSERT INTO dad_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ã meleĩlon ado, ere nigin, ã profet neid matmat unogedig, anĩ ere, ã tubuĩ tarem idi didenkesin. ");
INSERT INTO dad_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Anĩ nigin, ãgenei tubuĩ tar profet age difedin anĩ, ã megeir ge fen, yaor gef, ere nigin, idi profet didenkesin, ã idi neid matmat unogedig. ");
INSERT INTO dad_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Age fiya nigin, Negur yogon kisi biya bunem iron, ‘Aya fau idi bun profet, aposel ado sur afediyouf, age afe di, idi tunĩ didenkeis fen, tunĩ kafĩ fiya difenẽdiyouf.’ ");
INSERT INTO dad_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Anĩ nigin, teneub inon gariya bunem isif, profet ganan neid naudeid fi felen anĩ nẽ mala solo, tamo kayau gama sain enei bun idim dalouf, ");
INSERT INTO dad_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel nẽ naud bunem ile, Sekaraia ĩ tempel alta ado atun dukesin in naud bun. Aya ã momoi arokeneik, naud enĩ ganan nẽ mala solo, tamo kayau gama sain enei bun idim dalouf. ");
INSERT INTO dad_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Lo keleĩ tamo, ã meleĩlon ado, ere nigin, ã keleĩ nẽ ki walelegen, ã aug namen ileya sa ken, ã idi namen dilef anidi neid sukar katĩ welegef.” ");
INSERT INTO dad_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sain Jesus modoũ anĩ itoron, Farisia tamo, lo ifelnẽdiya tamo geid, ĩ bun kiwai totol dino, to fiya fire fire musei to difiyen, ");
INSERT INTO dad_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ereb od wogõ youf bun dirounẽf nigin tari difiyen. ");
INSERT INTO dad_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dirub kele di, tamo kayau tausen musei biya guru difen, anĩ bun idi abob tete tete lalai de difaren, age dife di, Jesus in dõ fiya tar ketem irokeneĩd fen, iron, “Ã, Farisia tamo neid yis nigin lo welegei, are mala yaleya tobonunã. ");
INSERT INTO dad_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gama ereb dede fiya yenek, are ganan fau lelek falauf, gama ereb iminẽyan yenek, are ganan fau yaorouf. ");
INSERT INTO dad_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ã gugum bun wogõ gen anĩ, fau gaa lalan bun karĩ douf, ã aaben wedereim kosesẽ gen anĩ, fau fõ sokoronem kurõ difesiyouf. ");
INSERT INTO dad_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Neu mou tar, aya ã arokeneik, idi bouwa dukeis fen, anĩ dumen ereb taka baban age fiya kisi feleya sã anidi to kumĩ wodig. ");
INSERT INTO dad_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anĩ ere, ã aib kumĩ wiyẽgouf anĩ afelneĩf: Ĩ bouwa yukeis fen, dumen ã hel bun irãyeĩf nigin megeir ado anĩ kumĩ wiyẽgouf. Ariya, aya ã arokeneik, ĩ kumĩ wiyẽg. ");
INSERT INTO dad_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Fisisir faif, tuwenti toea nẽ nem na nigin to sur gedig de? Anĩ ere, Negur ĩ anidi taka nigin to weder tu keledig. ");
INSERT INTO dad_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Momoi, Negur ãgenei mudureĩ bun fatiyeĩ ganan iwes yalen. To kumĩ wog, ã fisisir musei wal fediya. ");
INSERT INTO dad_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Aya ã arokeneik, aibem taka, aya nigin tamo meleid bun kurõ falaisiyouf, Tamo Naal ĩg, ĩ nigin Negur nẽ engel meleid bun kurõ falaisiyouf. ");
INSERT INTO dad_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Anĩ ere, taka ĩ, aya nigin tamo meleid bun wa fouf, ayag ĩ nigin Negur nẽ engel meleid bun wa afouf. ");
INSERT INTO dad_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Taka ĩ, Tamo Naal nigin kiwai ifen ken, kobu yef are, in mosor yalelauf. Ani are, taka ĩ, Awa Uur Fateul kiwai ifen ken, kono fiyek, in mosor to yalelauf. ");
INSERT INTO dad_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Sain ã Juda neid uub fõ bun guri diyeĩ diroule, mudur adodo yeneid adodo meleid bun difarneĩf, an wauĩ moro ken, aug isenneĩf nigin naig mafouf, ere mauf, wog fen, to sii yeĩf, ");
INSERT INTO dad_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ere nigin, sain anĩ bun, Awa Uur Fateul ereb wogõ gouf nigin, ifelneĩf.” ");
INSERT INTO dad_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tamo kayau musei atun, tamo takam Jesus irokenen, “Tise, neu turau urokenẽ di, amã urom akor foi mafouf.” ");
INSERT INTO dad_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus solof iron, “Aim aya ã atun es fiya tamo be, foi fiya tamo igirnan?” ");
INSERT INTO dad_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Age ye fen, Jesus idi irokenẽdin, “Lo welegei, ereb ereb ganan bun akorouya anĩ lo welegei, tamo nẽ mata in safina musei bun to ibodok.” ");
INSERT INTO dad_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Age ye fen, ĩ yaab od enei idi irokenẽdin, “Tamo taka safina musei ado, ne teneub bun saaf musei yaledig. ");
INSERT INTO dad_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ĩ kisi yalen, ‘Aya naig afouf? Aya neu saaf inoya nẽ modoũ sã.’ ");
INSERT INTO dad_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Agef fen, ĩ iron, ‘Aya eig afouf anĩ de. Neu ki narĩ afeleid fen, odug nuwa anodiyouf, an neu saaf ado ereb ereb ganan anouf. ");
INSERT INTO dad_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Age afel fen, aya yug nigin orõf, “Õ ereb ereb biyai biyai musei biya, yar musei nẽ unof. Ibodõya karika, saaf, naan wokon, waũ el fouf.”’ ");
INSERT INTO dad_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Anĩ ere, Negur ĩ irokenen, ‘Õ neneya! Bõ enei bun bagai, aya ogon mata alelkonõf. Age afe di, aim ogo nigin dodok won anĩ yalouf?’ ");
INSERT INTO dad_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Taka ĩ yogo nigin, agef safina kuru fef, anĩ ere, Negur mala bun maleg ibodok, ĩ bun eig bagai fe, wõ youf.” ");
INSERT INTO dad_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Age ye fen, Jesus in dõ fiya tar irokenẽdin, “Age fiya nigin, aya ã arokeneik, ã ãgenei bouweĩ mata ibodõf nigin to osig fen, ere saaf tãf gouf, ã ãgenei bouweĩ nigin to osig fen, ere gabar tafilaĩf gouf. ");
INSERT INTO dad_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mata anĩ saaf wal fiya, bouwa anĩ gabar wal fiya. ");
INSERT INTO dad_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ã kalog uledigedig, idi saaf to ditenẽdig, idi saaf to u difedig, idi ki be, udũ inoya modoũ sã, anĩ ere, Negur ifoutnẽdidig. Ã ninã anidi wal fediya bagai! ");
INSERT INTO dad_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ã takam yogon mata nigin osi ye fen, aua tekelei tobol fiya kisi feleya de? ");
INSERT INTO dad_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ã naal bagai enei age fiya kisi feleya sã nigin, ere nigin anĩ ã ereb ereb tunĩ nigin osi gef? ");
INSERT INTO dad_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Aa munĩ naig fe odugedig anĩ ulegedig. Idi kabĩ to daledig, to diwadig. Anĩ ere, aya ã arokeneik, kulu King Solomon yogon fula fiya medeĩya bun naki gegẽ biya biya ifonun animeg, aa munĩ taka to wal fen. ");
INSERT INTO dad_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Anĩ ere, Negur dubur aa munĩ gama dogol ifarauf, nile di, yã irãf anĩ, agef naki fediyouf are, ã idi wal fediya bagai, Negur naig fe ã ifounneĩf, ã momoiya naal bagai ado! ");
INSERT INTO dad_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Anĩ nigin, ã wauĩ ere saaf wãgauf be, ere naan wãgauf anĩ bun to unog, anĩ bun to osig. ");
INSERT INTO dad_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Are haiden idi enĩ ganan nigin meleid dimirẽdig. Ãgenei Temeĩ ã lau gef anĩ ganan keleĩ. ");
INSERT INTO dad_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Anĩ ere, Negur nẽ tano umirẽg, ago ge di, safina eneidig ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Musei sã ã, to kumĩ wog, ere nigin, ãgenei Temeĩ, tano anĩ ã ifeneĩya nigin wau al fen. ");
INSERT INTO dad_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ãgenei safineĩ na sur ge fen, maleg wenẽdigouf. Ã mugu mugu moni nẽ kodol to serek fouf anĩ uwagauf, agog fen, saa ilun nẽ safina biya biya to sa kalauf anĩ kuru gouf, an bẽ tamo non to isidig, tutũ to dãf. ");
INSERT INTO dad_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ãgenei safina biya biya ibodok nẽ an, wauĩg an yenẽf. ");
INSERT INTO dad_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kabĩ nẽ naki ufonũg fen, ãgenei lam tõg saika wog, ");
INSERT INTO dad_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","tamo idi, nedi odug, tamo kayau ado bagu fiya nẽ tar bunem kelouf nigin tari difedig, anĩ bunem, sain ĩ isi, sukar godu godu fe di, idi sã kaisã bagai ĩ sukar kã difelkenẽf anidi gen ago gouf. ");
INSERT INTO dad_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ferfer anidi ololo dife mog, nedi odug isi ilediyouf anĩ, idi nigin deuf, aya ã momoi arokeneik, ĩ fau yogo kabĩ nẽ naki ifoun kel, ferfer tebol bun ibodneĩd fen, isi, aruneid yalouf. ");
INSERT INTO dad_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ferfer anidi saika difel mog, nedi odug, bõ atun be, we ado be isi ilediyouf anĩ, idi nigin deuf. ");
INSERT INTO dad_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anĩ ere, ã enei keleĩ youf: Fõ marau ĩ, sain nanĩ be bun, bẽ tamo isiyouf anĩ keleĩ youf are, ĩ yogon fõ lo fe di, to narĩ fouf. ");
INSERT INTO dad_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ãg saika gouf, ere nigin, Tamo Naal ĩ fau sain to isiyouf gouf bun isiyouf.” ");
INSERT INTO dad_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita to fen, “Odug, õ yaab od enei amã nigin de, ganan nigin urok?” ");
INSERT INTO dad_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Odug solof iron, “Ferfer taka aim anĩ, dõ fiya biya, kisi biya ado de? Ĩ, yogon odugem ĩ yogon odug nẽ fõ bun, anidi neid saaf dogo neid sain kilei, dõf ifenẽdiyouf nigin, ima bun inof. ");
INSERT INTO dad_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sain tamo odug kelouf bun, ferfer biya bagai age fe di, ilouf, tamo odug ĩ el fiyẽf. ");
INSERT INTO dad_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aya ã momoi arokeneik, tamo odug ĩ, yogon safina ganan, ferfer anĩ ima bun inouf. ");
INSERT INTO dad_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Anĩ ere, ferfer taka ĩ wau bun irõf, ‘Neu tamo odug isiya nigin sain meluk yalef,’ age ye fen, ĩ gariya ino, tamo ferfer ado kayau ferfer iden ken, ĩ yogo saaf biya naan biya yokon, aai sẽ fedig. ");
INSERT INTO dad_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ferfer anĩ nẽ tamo odug, in isiya nẽ naa ferfer to isiyouf ye fen, kisif mog, in isiya sain ĩ keleĩ sã mog, isiyouf. Tamo odug, ferfer anĩ gudũf fisik fe fen, momoiya sã geid, nedi modoũ bun inenẽf. ");
INSERT INTO dad_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ferfer taka ĩ, yogon tamo odug nẽ oroya kelei ken, to dodok fef be, yogon odug orof anĩ to dõf age fef, ĩ fau wõf musei fouf. ");
INSERT INTO dad_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Anĩ ere, taka ĩ to kelei ken, darau yaleya nẽ anĩ age fef, ĩ musei to wõ fouf. Aib taka ĩ musei ifenen, ĩ bun musei yaleya nigin irokenẽf, agef fen, taka ĩ lo fouf nigin musei biya ifenen, ĩ bun musei biya yalouf nigin to fiyẽf. ");
INSERT INTO dad_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Aya tenebur yã arou asiyouf nigin asin, yã mala kaur mogom are, aya orou bagai fiyam. ");
INSERT INTO dad_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Anĩ ere, aya naan igũya taka fau alouf, anĩ nigin, aya wau fatuk morok ile, anĩ kisi falauf. ");
INSERT INTO dad_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ã kisi gef, aya tenebur ein maur gudũ fiya arou asiyouf nigin asin de? Sã bagai, aya ã arokeneik, isoreya nigin asin. ");
INSERT INTO dad_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gama ilauf bun, ibor tekelei bun, idi faif fara de fen, towom uru kiwai difenẽdi di, urum towo kiwai difenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Idi fara de fen, tamam kesu kiwai ifenẽ di, kesum tama kiwai ifenẽf, sina, ne barai kiwai ifenẽ di, ne barai sina kiwai ifenẽf, sina yanawau kiwai ifenẽ di, yanawau kayau sina kiwai ifenẽf.” ");
INSERT INTO dad_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus tamo kayau musei irokenẽdin, “Sain ã gaa ileyan budũ fã ye di, uleg fen, ã kaisã bagai urõgedig, ‘Uyẽ isiyouf,’ ago ge di, age fedig. ");
INSERT INTO dad_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Takag, yau karag maaĩ ubunem fũ fef, ã urõgedig, ‘Uruwa dõ fadauf,’ are agef wõ yedig. ");
INSERT INTO dad_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ã mala yaleya tamo! Teneub saa ado suma dinof anĩ uleg fen, es gouf nigin ã keleĩ. Naig fe di, sain enei nẽ suma es fiya nigin ã to keleik de? ");
INSERT INTO dad_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ere nigin ã aug ereb biya anĩg to es gedig? ");
INSERT INTO dad_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Õ ogon kiwai ado medistret bun uleg fen, naab luwen ogon kiwai ado od madur wouf, to agouf are, ĩ õ yale, es fiya tamo bun inenõf, age fe di, es fiya tamo õ polis bun inenõ di, polis õ kalabus bun inenõf. ");
INSERT INTO dad_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aya õ arokonok, õ wareg ganan to unolauf are, õ kalabus bun to kutũ wesiyouf.” ");
INSERT INTO dad_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sain anĩ bun, tunĩ an difaren anidim, Pailat Galili temeleid tunĩ neid naudeid ado dogo neid sesewi fiya nẽ safina ekul fen anĩ, Jesus dirokenen. ");
INSERT INTO dad_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus solof iron, “Ã kisi gef, Galili temeleid eneidi age de darau dalen nigin, idi neid mosor Galili temeleid ganan neid mosor wal fiya de? ");
INSERT INTO dad_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aya ã arokeneik, sã bagai! Anĩ ere, ã wauĩ to falei gouf are, ãg ganan inanakalauf. ");
INSERT INTO dad_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Takag, Siloam fõ meluk tamo kayau bun kubũ ye fen, idi eitin idenkesin. Ã kisi gef, idi neid mosor, tamo kayau ganan Jerusalem taun difaref neid mosor wal fiya de? ");
INSERT INTO dad_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aya ã arokeneik, sã bagai! Anĩ ere, ã wauĩ to falei youf are, ãg ganan inanakalauf.” ");
INSERT INTO dad_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Age ye fen, Jesus yaab od enei iron, “Tamo taka, aa fig tekelei yogon wain kabier itenen, anĩ ĩ ile, faat nigin mala itoton, anĩ ere, taka to ilen. ");
INSERT INTO dad_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Anĩ nigin, ĩ wain kabĩ lo fiya tamo irokenen, ‘Yar towo aya asi, aa fig enei bun faat nigin malau atoton, anĩ ere, taka to ailen. Utu urã! Ere nigin teneub gigiru yakasif?’ ");
INSERT INTO dad_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Kabĩ lo fiya tamo solof iron, ‘Odug, baban yar tekelei utorkana len, aya gariyan ku kalĩ afel, yaro te anouf. ");
INSERT INTO dad_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yar taka bun biyauf, are deuf! Sãf are, utu urã.’” ");
INSERT INTO dad_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat naa taka bun, Jesus Juda neid uub fõ taka bun od ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kayau taka, yar eitin kaa sanem irounen nigin dagi ado, an ibodon. Kayau ĩ bagiya fe fesen, agef fen, ĩ madur ifareya kisi feleya sã bagai. ");
INSERT INTO dad_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sain Jesus kayau anĩ lof fen, ĩ wagen iweigne ken, ĩ irokenen, “Kayau, õ ogon dagi bun tamal õ karika afonok.” ");
INSERT INTO dad_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Age ye fen, Jesus ĩ bun ima ino di, kaisã bagai kayau ĩ madur le ifar fen, Negur yana yalesen. ");
INSERT INTO dad_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Juda neid uub fõ nẽ mudur, Jesus Sabat naa bun dagi el fiyen nigin, name sane fen, tamo kayau irokenẽdin, “Kabĩ yaleya nigin naa sigis ado. Anĩ nigin, naa anidi bun usig el yeĩf, Sabat naa bun sã.” ");
INSERT INTO dad_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Odug ĩ irokenen, “Ã, mala yaleya tamo! Ã mugu mugu Sabat naa bun, ãgenei bulmakau be, donki be difaredig modoũ bun tamal birug fen, naan ifenẽdiya nigin to gurig ulegedig de? ");
INSERT INTO dad_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kayau enei, ĩ Abraham nẽ barai, ĩ Satanem sain meluk yar eitin ifokelnen, ĩ ifõya anĩ bun tamal Sabat naa bun to karika afenẽf de?” ");
INSERT INTO dad_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesus od enei wogõ ye di, yogon kiwai tar ganan mama fedin, anĩ ere, Jesus ereb ereb biya bagai age fen ganan nigin, tamo kayau musei ganan waud al fen. ");
INSERT INTO dad_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Anĩ nigin, Jesus to fen, “Negur nẽ tano anĩ, ere taka gen? Ere bun aya kisi afe di, susu falauf? ");
INSERT INTO dad_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Are masted faat gen, anĩ tamo takam yale fen, yogon kabier itenen. Anĩ odug fen, aa wõ ye di, ninã ilun temeleid disi, were bun dibodadan.” ");
INSERT INTO dad_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Baban ĩ to fen, “Negur nẽ tano anĩ, ere taka bun aya kisi afe di, susu falauf? ");
INSERT INTO dad_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Are yis gen, anĩ kayau takam yale fen, flawa odug ado falei fe di, ganan gẽ yen.” ");
INSERT INTO dad_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus Jerusalem taun ilauf nigin naab luwen iyok ile fen, taun ado fonõ fonõ ile, od ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Takam Jesus to fiyen, “Odug, are teke tekelei dogol kel yalediyouf de?” Jesus idi irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Bobog kidõ anĩ ileya nigin kabĩ totol walogouf, ere nigin, aya ã arokeneik, musei idi namen dilauf nigin age difouf, anĩ ere, to kisi falauf. ");
INSERT INTO dad_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sain fõ marau fã ye fen, sukar inolalauf, ã serẽ ufareg fen, godu godu ge ugonẽgouf, ‘Odug, sukar kã wanamãf.’ “Anĩ ere, ĩ solof irõf, ‘Aya ã keleĩ sã, ã nainenem usigen.’ ");
INSERT INTO dad_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Age ye di, ã urõgouf, ‘Amã õ geid saaf naan ado ton, ago fen, õ nemã naab bun od ufelnamak uyon.’ ");
INSERT INTO dad_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Anĩ ere, ĩ solof irõf, ‘Aya ã keleĩ sã, ã nainenem usigen. Ã sane ago gedig ganan, aya malau bun uyaleleg!’ ");
INSERT INTO dad_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Sain Abraham, Isak, Jakop, profet ganan geid, Negur nẽ tano bun uledig fen, ã aug mayarẽ irarãyeĩf, an inã wifirig fen, goboreĩ kikokõ youf. ");
INSERT INTO dad_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tamo kayau gaa iseyan temeleid, gaa ileyan temeleid, yat temeleid, fa temeleid disi, Negur nẽ tanon tar bun idi neid modoũ dalouf. ");
INSERT INTO dad_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Momoi, an idi dumen dibodok fau malabag dibodõf, idi malabag dibodok fau dumen dibodõf.” ");
INSERT INTO dad_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sain anĩ bun, Farisia tamo tunĩ Jesus garan disi dirokenen, “Modoũ enei utor ken, taka bun ule. King Herod ĩ õ inokesiyou fenẽ.” ");
INSERT INTO dad_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus solof iron, “Uleg, gaũ kuĩ anĩ urokenẽg, ‘Gama ado nil, aya kaa sesen aruid fen, tamo kayau el afediyouf, age afe fen, naa towo bun, aya neu kabĩ anĩ uyu katõ afalauf.’ ");
INSERT INTO dad_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Anĩ ere, aya gama, nil, arã toko tokõ afouf, momoi bagai profet taka Jerusalem taun to ito ken, firen laa fouf! ");
INSERT INTO dad_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem, õ profet udenkeis fen, õ bun sur fedig anidi, meein meein wedidig, sain ganĩ aya õ wau afon ken, ogon gerẽ tar kuru afediyouf nigin age afedig, tataro sina momou waye farumen kuru fedig gen, anĩ ere, õ utorõdig! ");
INSERT INTO dad_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ulegouf, ãgenei fõ ã bun fonou lef. Aya ã arokeneik, ã aya baban to uleyagauf ile, ã fau urõgouf, ‘Odug yana bunem isif ĩ el fiya ado.’ Sain anĩ bun, ã aya uleyagauf.” ");
INSERT INTO dad_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat naa taka bun, Jesus, Farisia tamo uyu irouya taka nẽ fõ bun, saaf yõya nigin ilen, idi an Jesus ololo difen. ");
INSERT INTO dad_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesus wagen an, tamo taka bou didĩya nigin darau yaledig anĩ ibodon. ");
INSERT INTO dad_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus, Farisia tamo, lo keleĩ tamo geid to fedin, “Sabat naa bun, dagi el fediya anĩ lo dõ fiya de, sã?” ");
INSERT INTO dad_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Anĩ ere, idi mutũ difaren. Anĩ nigin, Jesus tamo anĩ yale, el fiye kel sur fiyẽ di, ilen. ");
INSERT INTO dad_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Agef fen, ĩ idi to difen, “Ã taka, Sabat naa bun, kesu be, bulmakau be taka kuren isilauf, ã kaisã bagai to dĩ wasagauf de?” ");
INSERT INTO dad_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Age ye di, idi od solof irõya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesus, tamo tebol bun modoũ malabag anĩ gei dife di, ile fen, ĩ idi yaab od enei irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tamo kayau ado bagu fiya nẽ tar bun, aib õ iweignõf are, modoũ malabag anĩ to walouf, ere nigin, tamo taka õ wal yõya iweignen be. ");
INSERT INTO dad_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Age fouf are, ã uru iweigneim marau isi, õ irokonõf, ‘Ogon modoũ anĩ, tamo enei wenẽ.’ Age ye di, õ mama yo ken, modoũ dumen bagai anĩ walouf. ");
INSERT INTO dad_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Anĩ ere, õ iweignõf are, modoũ dumen anĩ walouf, ago di, iweignom marau isiyouf, ĩ õ irokonõf, ‘Mou, modoũ biya bun godo urou usel.’ Age fe di, õ modoũ malabag anĩ wale di, ã iweigneim turã tar ganan meleid bun õ yanã odug adouf. ");
INSERT INTO dad_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ere nigin, aib taka yogo yana yalesef, fau lai fesilauf, aib taka ĩ yogo yana lai fesilef, Negur ĩ yana yalesauf.” ");
INSERT INTO dad_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Age ye fen, Jesus fõ marau irokenen, “Sain õ gaa atun saaf be, bõ saaf wenẽdiyou fenẽ, ogon mou tar, naud turã tar, sirag tar be, nẽ tã tar safina inid adodo to uweignẽdiyouf, agouf, idi aba diweignõf, anĩ bun õ mala solo difonõf. ");
INSERT INTO dad_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Anĩ ere, sain õ tar unouf, maleg, bouweid sesen, yeid kirorõya, meleid ifofakeleya anĩ uweignẽdiyouf, ");
INSERT INTO dad_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","agouf, Negur õ el yõf. Idi aba õ ke de difonõya kisi feleya sã, anĩ ere, madur tamo neid mata kel fãya bun, Negur õ mala solo ifonõf.” ");
INSERT INTO dad_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tamo tebol bun weim dibodon anidi takam, od enei karĩ ye fen, ĩ Jesus irokenen, “Negur nẽ tanon tar bun tamo saaf yãf anĩ, ĩ el fiya ado.” ");
INSERT INTO dad_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus solof iron, “Tamo taka tar odug dodok fe fen, musei iweignẽdin. ");
INSERT INTO dad_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tar sain bun, ĩ iweignẽdin anidi irokenẽdiyouf nigin yogon ferfer sur fen, ‘Usig, gama ereb ereb ganan dodok felel.’ ");
INSERT INTO dad_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Anĩ ere, idi ganan de tekelei gen galã od dinon. Uyulil ĩ iron, ‘Aya gama bagai kabĩ na alen, anĩ nigin, aya anĩ ailau fenẽ alauf. O malalon ado, aya to asiyouf.’ ");
INSERT INTO dad_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Taka iron, ‘Aya bulmakau ten na alen, anĩ idi naig fiya anĩ ailau fenẽ elef. O malalon ado, aya to asiyouf.’ ");
INSERT INTO dad_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Takag iron, ‘Aya gama bagai kayau mata alen nigin, aya isiya kisi feleya sã.’ ");
INSERT INTO dad_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ferfer kel ile, ne odug od enei irokenen. Age fe di, fõ marau name sane fen, yogon ferfer irokenen, ‘Kaisã bagai ule, taun nẽ naab odug, naab nanaal ado dõ wo fen, maleg, bouweid sesen, meleid ifofakeleya, yeid kirorõya anidi guri urou usi.’ ");
INSERT INTO dad_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ferfer iron, ‘Odug, õ urom are mogo age afel, anĩ ere, modoũ fau lolokã.’ ");
INSERT INTO dad_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Age ye di, odug yogon ferfer irokenen, ‘Naab uyok ule fen, fonõ fonõ naabur tamo kayau idi anĩ disiyouf nigin totol bagai urokenẽdi di, disi, neu fõ isokosauf. ");
INSERT INTO dad_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aya ã arokeneik, aya tamo idi aweignẽdin anidi taka, neu tar bun saaf bagai to kobũ de dilouf.’” ");
INSERT INTO dad_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tamo kayau musei, Jesus weim dile fen, ĩ falei yel, idi irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Taka ĩ aya gein isif, ne tama, sina, ne kayau, kesu tar, ne tura tar, main tar, yogon matag to itorõf are, ĩ neu dõ fiya tamo wõ youf nigin kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Takag, taka ĩ yogon aa tetek to faali fe fen, aya dõ fiyaf, ĩ neu dõ fiya tamo wõ youf nigin kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ã taka, fõ meluk taka inoya nigin orouf are, ĩ tetun ibod ken, fõ inolauf nigin moni kisi feleya ado be anĩ es fouf, age fiya sã de? ");
INSERT INTO dad_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ere nigin, ĩ fõ gariya ino mã, inoleya to kisi falauf are, tamo kayau ganan anĩ dile fen, kasã difiye ken, ");
INSERT INTO dad_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","dirõf, ‘Tamo enei fõ kare fen, anĩ ere, inoleya kisi feleya sã.’ ");
INSERT INTO dad_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Takag, king taka, king taka ado kusĩ douf nigin, ĩ ten tausen kusĩ tamo adom, king taka tuwenti tausen kusĩ tamo ado kusĩ disif anĩ, kusĩ bun wal fiyẽya kisi feleya be sã be anĩ, tetun ibod ken, es fouf, age fiya sã de? ");
INSERT INTO dad_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ĩ to kisi falauf are, ĩ king taka fau gerõ ifar mog, wowor fiya tamo sur fedi di, idi komo fiya nigin to difiyẽf. ");
INSERT INTO dad_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Age fiya gen bagai, ã taka ĩ, ereb ereb ganan ĩ ado anĩ to itorõf are, ĩ neu dõ fiya tamo wõ youf nigin kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Anĩ nigin, sol ĩ biya, anĩ ere, in kai sa kalauf are, naig fe di, ĩ baban kai youf? ");
INSERT INTO dad_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sol age fiya are, teneub ado falei fiya nigin ado, gaar te ado falei fiya nigineg to biya, anĩ nigin dirailedig. “Aib ĩ karĩya nigin weder ado, utornẽ karĩ youf.” ");
INSERT INTO dad_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis yaleya tamo, mosor adodo geid ganan, Jesus karĩ difiyẽf nigin ĩ non disin. ");
INSERT INTO dad_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Anĩ ere, Farisia tamo, lo ifelnẽdiya tamo geid, nauseir de fen, diron, “Tamo enei, mosor adodo aan fiyeĩd fen, weim saaf doko.” ");
INSERT INTO dad_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Age de di, Jesus yaab od enei irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ã taka wan handred sipsip ado, anĩ tekelei iminkalauf are, ĩ nainti-nain sipsip yaorin itorneĩd fen, iminkelen anĩ imirek ile fotou fedig, age fiya sã de? ");
INSERT INTO dad_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sain ĩ fotou fouf, ĩ wau adod fen, yale, benerin orowa sef, ");
INSERT INTO dad_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","fõ bun ilauf. Agef fen, ĩ ne mou tar ado, ne tã tar gou feid irõf, ‘Ã aya geid kulĩ tauf. Aya neu sipsip fõ yelen anĩ fotou afel.’ ");
INSERT INTO dad_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aya ã arokeneik, age fiya gen bagai, mosor ado tamo taka wau falei yef bun, saa ilun kulĩya odug adouf anim, nainti-nain madur tamo baban faleiya nẽ sã idi nigin kulĩya wal fiya. ");
INSERT INTO dad_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Takag, kayau taka silwa koin moni ten ado, anĩ tekelei iminkalauf are, ĩ lam tõf, fõ waĩf fen, el fe imirek ile fotou fouf, age fiya sã de? ");
INSERT INTO dad_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sain ĩ fotou fouf, ĩ ne mou tar ado, ne tã tar gou feid irõf, ‘Ã aya geid kulĩ tauf. Aya neu silwa koin moni iminkelen anĩ fotou afel.’ ");
INSERT INTO dad_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Age fiya gen bagai, aya ã arokeneik, mosor ado tamo taka wau falei yef ĩ nigin, Negur nẽ engel meleid bun kulĩya odug wõ yef.” ");
INSERT INTO dad_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus tobol fe iron, “Tamo taka kesu uru adon. ");
INSERT INTO dad_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ibuyem tama irokenen, ‘Dei, akor neu anĩ fara wana.’ Anĩ nigin, temeid yogon safina idi atun foi fen. ");
INSERT INTO dad_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Anĩ bure fel fen, sain meluk to ilele di, kesu ibuye, safina ĩ ado ganan kuruf yale irou, teneub taka bun gerõ biya ilen, an in safina tobonunã to biya bun daũ felen. ");
INSERT INTO dad_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ĩ ereb ereb ganan daũ fele di, teneub anĩ bun naũ odug wõ yen, age fe di, ĩ bun lau fiya wõ yen. ");
INSERT INTO dad_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Anĩ nigin, ĩ ile, fõ morou taka bun kabĩ yalouf nigin to fiyẽ di, fõ moroum ĩ bor saaf ifenẽdiyouf nigin yogon kabier sur fen. ");
INSERT INTO dad_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ĩ naũ bagai nigin bor saaf dõ di, ĩg anĩ yõya nigin orodig, anĩ ere, takam ereb taka to ifenẽdig. ");
INSERT INTO dad_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ĩ kisi kelen sain, ĩ iron, ‘Neu dei ĩ kabĩ tamo musei ado, idi saaf barikã. Aya ein naum laa fiyau fenẽ! ");
INSERT INTO dad_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aya fã au, neu dei garan kelau fen, ĩ arokenẽf: Dei, aya saa ilun ado õ bun mosor anon. ");
INSERT INTO dad_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aya to biya nigin, neu kesu to wouf, ogon kabĩ tamo oroi waledin taka gen waleyauf.’ ");
INSERT INTO dad_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Anĩ nigin, ĩ fã ye, tama gein ilen. “Anĩ ere, ĩ fau gerõ iyok isi mog, tama ĩ kesu ile fen, ĩ nigin wau fatuk yũ di, kesu gein gudu ref ile, kakarai fiye ken, umã fiyen. ");
INSERT INTO dad_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Kesum tama irokenen, ‘Dei, aya saa ilun ado õ bun mosor anon. Aya to biya nigin, neu kesu to wouf.’ ");
INSERT INTO dad_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Anĩ ere, tama ĩ yogon ferfer irokenẽdin, ‘Gamanem kolos biya bagai waleg urousig, ĩ ufounnẽg, ima gege bun sai unog fen, ye bun su unokenẽg. ");
INSERT INTO dad_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bulmakau lubu bou dĩya waleg urousig ukesig. Ada tar tano tokon, sigigi tafouf. ");
INSERT INTO dad_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ere nigin, neu kesu enei laa fen anĩ baban matal, ĩ fõ yelen anĩ baban fotou tafiyem.’ Anĩ nigin, idi gariya dino sigigi difen. ");
INSERT INTO dad_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Sain anĩ bun, kesu matu ĩ kabier ibodon. Dum ĩ iyok isi, fõ kelẽ fiye ken, fõ non kui de gurũ de mog, karĩ yen. ");
INSERT INTO dad_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Agef fen, ĩ kabĩ tamo taka iweigne ken, to fiyen, ‘Oun ere naig difef?’ ");
INSERT INTO dad_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kabĩ tamo ĩ aiten yale iron, ‘Turã kel isil, anĩ tamã bulmakau lubu bou dĩya yum, ere nigin, tamam ĩ bouwa totoũ biya bagai ado kel yalel.’ ");
INSERT INTO dad_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Age ye di, tura matu name sane fen, fõ bun ileya nigin itoron. Age fe di, tama mayarẽ ile wowor fiyen. ");
INSERT INTO dad_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Anĩ ere, kesu ĩ tama solof irokenen, ‘Ulefe, yar enei ganan aya õ sigor taka to wal afe fen, arunã alef asin. Anĩ ere, õ aya meme lubu taka wana di, neu mou tar geid to sigigi mafen. ");
INSERT INTO dad_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Anĩ ere, õ naal enei are, ogon safina, kayau bouweid na nẽ sur difedig anidi bun daũ fel fen, fonõ isi di, õ bulmakau lubu bou dĩya ukenem!’ ");
INSERT INTO dad_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tama iron, ‘Neu kesu, õ aya ado faimud tabodõdig. Safina ganan aya ado, are ogon. ");
INSERT INTO dad_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Anĩ ere, ada sigigi tafe fen, wauda al fem bagai, ere nigin, turã enei laa fen anĩ baban matal, ĩ fõ yelen anĩ baban fotou tafiyem.’” ");
INSERT INTO dad_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Takag, Jesus in dõ fiya tar irokenẽdin, “Safina musei ado tamo taka, ĩ yogon kabĩ tamo neid orowam in safina daũ fef yeya karĩ yen. ");
INSERT INTO dad_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Anĩ nigin, ĩ iweignẽ ile di, to fiyen, ‘Eĩ ere od anĩ õ nigin karĩ auf? Ogon kabĩ walen anĩ faded wo di, karĩ auf, ere nigin, õ baban kabĩ tamo neid orowa to ubodõf.’ ");
INSERT INTO dad_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kabĩ tamo neid orowa yogo nigin iron, ‘Gama aya naig afouf? Neu odug neu kabĩ yalelkanaf. Aya meku yaleya nigin totolou sã, agef mãg, aya nonĩya nigin mama ado. ");
INSERT INTO dad_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aya naig be afouf are aya keleĩ, anĩ bunem sain aya neu kabĩ ein atorõf are, tamo kayau neid fõ bun ileya nigin aan difiyauf.’ ");
INSERT INTO dad_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Age ye fen, ĩ, yogon odug bun wareg dalen anidi mugu mugu iweignẽdi di, disin. Ĩ tamo uyulil anĩ to fiyen, ‘Õ neu odug bun wareg ganĩ walen?’ ");
INSERT INTO dad_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ĩ aiten yale iron, ‘Eit handred galen aa oliv moul alen.’” Kabĩ tamo neid orowa ĩ irokenen, ‘Ogon wareg ditoton wale, kaisã ubod ken, fo handred utot.’ ");
INSERT INTO dad_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Age ye di, ĩ uyulil dõ fiyen anĩ to fiyen, ‘Ba õ wareg ganĩ walen?’ “Ĩ solof iron, ‘Wan handred wit bek alen.’ “Kabĩ tamo neid orowam ĩ irokenen, ‘Ogon wareg ditoton wale, eiti utot.’ ");
INSERT INTO dad_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Yogon odug ĩ, kabĩ tamo neid orowa idegẽya tamal, ĩ kisi el fe yale fen, age fen nigin, yana yalesen. Ere nigin, tamo kayau teneub enei bun temeleid kisi el de dale fen, ereb dogo neid nigin tamo kayau lalan bun temeleid wal fediya age difedig. ");
INSERT INTO dad_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aya ã arokeneik, teneub enei nẽ safina bunem ã aug nigin neĩ mou tar waledigouf, anĩ bunem, sain safina sa kalauf, mata gai ibodkeleya bun aan diyeĩf. ");
INSERT INTO dad_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Taka ĩ ereb naal bagai el fe lo fef, odug buneg agef lo fouf, taka ĩ naal bagai bun idegek, odug buneg idegẽf. ");
INSERT INTO dad_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Anĩ nigin, ã tenebur enei nẽ safina to el ge lo gen ouf are, aim ã momoi nẽ safina lo fiya nigin ineneĩf? ");
INSERT INTO dad_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ã takan nẽ safina to el ge kulatun gen ouf are, aim anĩ ã safineĩ ifeneĩf? ");
INSERT INTO dad_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kabĩ tamo takam odug uru bun to kabĩ yalouf. Taka nigin to wau yen ken, taka nigin wau laa fouf be, taka anĩ aruna yale fen, taka anĩ to awa yãf. Ã Negur nigin ado moni nigin aruna yaleya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisia tamo moni nigin waud laa fedig anĩ, od enei ganan karĩ de fen, Jesus kasã difiyen. ");
INSERT INTO dad_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Age dife di, Jesus idi irokenẽdin, “Ã bagai anĩ, tamo meleid bun, ã aug nigin biya age mafef gedig, anĩ ere, Negur ĩ wauĩ keleĩ bagai. Tamo ereb nigin waud fatuk difenek, are Negur mala bun ninir bagai.” ");
INSERT INTO dad_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Lo nẽ od ado, profet neid od wogõ def disi, Jon bun daun. Sain anĩ bunem, Negur nẽ tano nigin biya od wogõ def disif, age fe di, ganan namen ileya nigin mugu mugu teĩbir def. ");
INSERT INTO dad_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Saa teneub ado iminkeleya nigin are karika, anĩ ere, Lo bun itotoya togo fiya naal bagai taka to iminkalauf. ");
INSERT INTO dad_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Taka ĩ aiwa iru fen, kayau taka yalouf are, ĩ seseirã inof, taka ĩ kayau tamo takam irun anĩ yalouf are, ĩ seseirã inof. ");
INSERT INTO dad_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Safina musei ado tamo taka, naa ganan bun kolos naki biya, saaf biya, ibodõya biya ibodõdig. ");
INSERT INTO dad_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Maleg taka yana Lasarus, gurumam barikã, safina musei ado tamo ne bobogẽ yenẽdig. ");
INSERT INTO dad_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Agef fen, ĩ, safina musei ado tamo nẽ tebol bunem kuku ref anĩ yãf nigin orodig. Gaũg disi, guruma seum difedig. ");
INSERT INTO dad_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Dum maleg tamo laa fe di, engelem Abraham wagen dirou diselen. Safina musei ado tamog laa fe di, mũ difen. ");
INSERT INTO dad_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Laa neid modoũ bun, safina musei ado tamo darau odug yale fen, ĩ gerõ mala irakel, Lasarus Abraham wagen ibod mog, ilen. ");
INSERT INTO dad_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Agef fen, ĩ Abraham iweigne ken, iron, ‘Dei Abraham, aya nigin waũ ino ken, Lasarus sur wiyẽ di, ima gege uyum naan kobũf fen, irousi baleu felu kouf, ere nigin, aya yã enei bun darau odug alef.’ ");
INSERT INTO dad_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Anĩ ere, Abraham aiten yale iron, ‘Kesu, õ mata ubodon sain, õ ereb ereb biya wale mog, Lasarus ĩ ereb ereb to biya yalen, anĩ karĩ wo, anĩ ere, gama ein ĩ wau wã fe di, õ darau odug bun ubodok. ");
INSERT INTO dad_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Takag, enei ganan teten, amã ã geid atun meku odug inon, anĩ bunem, idi ein tamal ã gein isiya nigin kisi feleya sã, takam an tamal amã gein ibal isiya nigineg kisi feleya sã.’ ");
INSERT INTO dad_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ĩ aiten yale iron, ‘Age fiyauf are, Dei, aya õ agonok, neu dei nẽ fõ bun Lasarus sur wiyẽ di, isilauf, ");
INSERT INTO dad_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ere nigin, aya turau tar faif dibodok. Utornẽ len, wedereid irouwauf, age fe di, idig darau odug nẽ modoũ enei bun to disiyouf.’ ");
INSERT INTO dad_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham solof iron, ‘Idi Moses nẽ itotoya ado profet neid itotoya ado, utorneĩd len, idi anidi bun wedereid dinouf.’ ");
INSERT INTO dad_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ĩ iron, ‘Age fiya sã, Dei Abraham, laa bun tamal takam idi bun isilauf are, idi waud falei youf.’ ");
INSERT INTO dad_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Anĩ ere, Abraham tamo anĩ irokenen, ‘Idi Moses nẽ od ado profet neid od nigin to wedereid dinouf are, laa bun tamal takam fã ye fen, idi irokenẽdiyoufeg to karĩ douf.’” ");
INSERT INTO dad_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus in dõ fiya tar irokenẽdin, “Ereb ereb tamo mosor bun inenẽdiyouf anĩ isiyouf bagai, anĩ ere, tamo nanĩ be bunem isif, ĩ malalon ado. ");
INSERT INTO dad_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Taka ĩ nanaal enidi taka mosor bun inenẽya ban, ĩ meein odug guyutu bun ifo ken, maaĩwõ irãya nigin biya bagai. ");
INSERT INTO dad_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Anĩ nigin, ã lo welegei. “Õ turã mosor inouf, ou wiyẽf, anĩ ĩ falei youf are, õ in mosor nigin wederẽ tu kel. ");
INSERT INTO dad_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ĩ naa tekelei bun, õ bun mosor ino sewen fouf, ĩ õ gein isi, sewen fe irõf, ‘Aya awaul,’ õ in mosor nigin wederẽ tu kel.” ");
INSERT INTO dad_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposel idi Odug dirokenen, “Nemã momoiya odug wouf!” ");
INSERT INTO dad_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesus solof iron, “Ã momoiya naal, masted faat gen adouf are, aa enei urokenẽgouf, ‘Kusu wale, usil maaĩwõ ufarauf,’ ago ge di, ã sigoreĩ dõ fouf. ");
INSERT INTO dad_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ã taka, yogon ferfer kabier teneub yũf be, sipsip lof fen, kabierem isi mog, ne maraum tau, ‘Kaisã bagai saaf yõya nigin usi ubod,’ fiyẽf de? ");
INSERT INTO dad_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Age fiya ban, ĩ eig youf, ‘Neu saaf dodok wol fen, õ naki wol, arunau wale, akas bure afele di, gama õ saaf ado naan wãf.’ ");
INSERT INTO dad_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ĩ irokenẽ di, dõf age fen nigin, maraum ferfer tau de wiyal fiyẽf de? ");
INSERT INTO dad_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anĩ nigin, ã ereb ereb irokeneik anĩ ganan dõg, ago weleg fen, ãg eig ge urõgouf, ‘Amã ferfer to biya, amã nemã kabĩ anĩ dogol malel.’” ");
INSERT INTO dad_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus Jerusalem ileya nigin, Samaria ado Galili distrik daũ atu iyok ilen. ");
INSERT INTO dad_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ĩ fonõ taka bun ile mog, tamo ten lepra dagi adodo, ĩ fotou difiyen. Idi gerom difar fen, ");
INSERT INTO dad_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aiteid odug nem diweig diron, “Jesus, Odug, amã nigin malalon yõ!” ");
INSERT INTO dad_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sain ĩ idi ileid fen, iron, “Uleg, aug bouweĩ pris ufelnẽdigouf.” Age ye di, idi dile mog, bouweid biya len. ");
INSERT INTO dad_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Idi neid taka bouwa biya len anĩ ile fen, kel isi, ait odugem Negur yana yalesen. ");
INSERT INTO dad_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesus ye gariyan kubũ ye yen ken, de wiyal fiyen, ĩ Samaria tamal. ");
INSERT INTO dad_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Age fe di, Jesus to fen, “Ten ganan to biya ledin de? Tamo nain idi nain difaref? ");
INSERT INTO dad_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Takam to kel isi, Negur yana yalesel, yaũ enei dogol de?” ");
INSERT INTO dad_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesus age ye fen, ĩ irokenen, “Fã wale fen, ule, ogon momoiyam õ el yom.” ");
INSERT INTO dad_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sain taka, Farisia tamom, Negur nẽ tano ere sain isiyouf nigin Jesus to difiyẽ di, Jesus solof iron, “Negur nẽ tano, malam ileya kisi feleya sã bunem isidig, ");
INSERT INTO dad_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","tamo to ‘Eĩ yeir,’ be, ‘Your oun,’ be douf, ere nigin, Negur nẽ tano are ã atun ibodok.” ");
INSERT INTO dad_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Age ye fen, Jesus yogon dõ fiya tar irokenẽdin, “Sain isi di, Tamo Naal nẽ naa taka ileya nigin oroyeĩf, anĩ ere, ã anĩ to ulogouf. ");
INSERT INTO dad_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tamom dirokeneĩf, ‘Ĩ your!’ be, ‘Ĩ yeir!’ douf. Ã, to uleg, idi to dõ wedig. ");
INSERT INTO dad_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ere nigin, Tamo Naal, yogon naa bun, kolimei filiya lalan saa gariyanem irou, idikeleyan isiledig gen. ");
INSERT INTO dad_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Anĩ ere, uruwa ĩ darau musei yale di, tamo kayau sain enei bun dibodok anidi ĩ dudum difiyẽf. ");
INSERT INTO dad_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noa nẽ sain bun age fen gen, age fiya bagai Tamo Naal nẽ sain buneg age fouf. ");
INSERT INTO dad_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tamo kayau saafei de fen, naanuei den, tamo kayau yalef, kayau tamo difenek difen, age de dile mog, Noa waag namen ilen. Agef mog, kuwei isi fen, idi ganan daũ fedin. ");
INSERT INTO dad_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lot nẽ sain buneg de age difen, tamo kayau saafem, naanem difen, na dalef, na sur difef, saaf diten, fõ dino mog, difen. ");
INSERT INTO dad_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Anĩ ere, naa Lot Sodom taun itor ilen bun, yã ado meein salfa, saa bunem uyẽ gen kukur fen, idi ganan daũ fedin. ");
INSERT INTO dad_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Age fiya gen bagai, Tamo Naal yaorouf nẽ naa bun, agef wõ youf. ");
INSERT INTO dad_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Naa anĩ bun, taka ĩ yogon fõ agaran ibod mog, in safina namen ibodok anĩ yalouf nigin to kel isilauf. Age fiya bagai, taka ĩ kabier ibodok, yogon safina yalouf nigin to kel ilauf. ");
INSERT INTO dad_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot nẽ kayau bun kisi gouf! ");
INSERT INTO dad_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Taka ĩ yogon mata yalouf nigin kisi fouf, ĩ mata anĩ fõ yalauf. Taka ĩ yogon mata anĩ itorõf are, ĩ yogon mata irou kafĩ falauf. ");
INSERT INTO dad_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aya ã arokeneik, bõ anĩ bun, tamo uru idi fatar tekelei bun denẽf, tekelei yalouf, taka itornẽf. ");
INSERT INTO dad_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kayau uru idi wit ditutu mog, tekelei yalouf, taka itornẽf.” ");
INSERT INTO dad_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Idi to difen, “Odug, õ urok anĩ nain wõ youf?” Jesus idi irokenẽdin, “Nain be laa yenek nẽ an, tum guru difouf.” ");
INSERT INTO dad_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Age ye fen, Jesus, in dõ fiya tar idi faimud kosẽya nigin tuweid to yũf anĩ ifelnẽdiyouf nigin, yaab od taka irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ĩ iron, “Taun taka bun, es fiya tamo taka ibodon, ĩ Negur to kumĩ fiyẽdig, tamog to iwesnẽdig. ");
INSERT INTO dad_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Taun anĩ bun an, kayau waab taka ibodon, ĩ es fiya tamo bun toku kel fen, yogon kiwai mala solo ifenẽf nigin irokenẽyai yedig. ");
INSERT INTO dad_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Es fiya tamo ĩ kaisã to karĩ fiyen, anĩ ere, dum ĩ yogo nigin iron, ‘Aya Negur to kumĩ afiyek, tamog to awesnẽdif, ");
INSERT INTO dad_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","anĩ ere, kayau waab enei toku morõ ifanaf nigin, in morõ anĩ ail fen, kayau ĩ irok anĩ age afouf, anĩ bunem ĩ to kel fen, morõ ifanauf!’” ");
INSERT INTO dad_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesus age ye fen, iron, “Es fiya tamo sane, ereb ĩ iron anĩ karĩg. ");
INSERT INTO dad_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Negur yogon igirnẽdin anidi, bõ ado gaa ado diweig dirokenẽdig nigin, ĩ lo nẽ madur fiya to ifenẽdiyouf de? Ĩ sain meluk to karĩ fiyẽdiyouf de? ");
INSERT INTO dad_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aya ã arokeneik, ĩ kaisã bagai lo nẽ madur fiya ifenẽdiyouf. Anĩ ere, Tamo Naal isiyouf sain bun, tenebur ein ĩ momoiya fotou fouf de?” ");
INSERT INTO dad_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tunĩ idi dogo nigin amã madur bagai de fen, tunĩ meleid irim lai difedidig anidi bun, Jesus yaab od eneig irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tamo uru tempel bun kosẽ douf nigin diselen, taka Farisia tamo, taka takis yaleya tamo. ");
INSERT INTO dad_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisia tamo ifar fen, yogo nigin kosẽ yen, ‘Negur õ de ayok, aya tamo tunĩ gen sã, bẽ diledig, sane age difedig, seseirã dinodig, takis yaleya tamo enei geneg sã. ");
INSERT INTO dad_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aya uub tekelei bun naa uru kuri au fen, ereb ereb ganan aya alef anĩ, ten teke tekelei õ afonõdig.’ ");
INSERT INTO dad_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Anĩ ere, takis yaleya tamo ĩ so rel ifaren. Ĩ saa iluneg to itad fen, anĩ ere, ĩ akor yu ken, iron, ‘Negur, aya nigin waũ inõf, aya mosor temelou.’ ");
INSERT INTO dad_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Aya ã arokeneik, Farisia tamo anĩ sã, takis yaleya tamo enei, Negur mala bun ĩ madur fen, fõ bun ilen. Ere nigin, taka ĩ yogo yana yalesef, Negur ĩ yana lai fouf, taka ĩ yogo yana lai fef, Negur ĩ yana yalesauf.” ");
INSERT INTO dad_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Takag, tamo kayau, Jesus kesu momoug kobũ fediyouf nigin ĩ wagen guri difeid disin. Age dife di, in dõ fiya tar anĩ dile fen, idi ou difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Anĩ ere, Jesus kesu ĩ wagen iweigneĩd fen, iron, “Utornẽdig len, kesu nanaal aya wageun disiyouf, idi to katũ wedig, ere nigin, Negur nẽ tano are eig fediya neid. ");
INSERT INTO dad_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aya ã momoi arokeneik, aib taka ĩ, Negur nẽ tano, kesu naal age fiya gen to yalouf are, ĩ Negur nẽ tanon to bagai ilauf.” ");
INSERT INTO dad_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uyu irouya tamo taka Jesus to fiyen, “Tise biya, aya ere naig afe fen, mata faimud ibodkeleya alouf?” ");
INSERT INTO dad_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus ĩ irokenen, “Ere nigin õ aya anĩ biya wiyaf? Aibem taka biya sã, Negur yogo dogol. ");
INSERT INTO dad_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Õ ĩtãfiya keleĩ: ‘Õ seseirã to unouf, õ tamo taka to ukesiyouf, õ to bẽ walouf, õ taka nigin idegẽya od to urõf, sinã tamã yeneid walesauf.’” ");
INSERT INTO dad_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Age ye di, ĩ iron, “Enei ganan aya kesu naalun dõ afef asin.” ");
INSERT INTO dad_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesus enei karĩ ye fen, ĩ irokenen, “Õ fau tekelei anĩ inĩ sã. Ogon safina ganan na nigin sur wo fen, maleg tamo weneĩd, agouf anĩ õ saa ilun safina biya adouf. Ago wol fen, usi, aya dõ wiya.” ");
INSERT INTO dad_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Anĩ ere, ĩ od enei karĩ ye fen, wau fatuk gudũ fen, ere nigin, ĩ safina musei biya ado. ");
INSERT INTO dad_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus ĩ lege fiye ken, iron, “Safina musei adodo tamo, Negur nẽ tano bun ileya nigin, gai malai bagai! ");
INSERT INTO dad_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Momoi, kamel ĩ, gabar iwaya nẽ nil ku bun ileya nigin, karika bagai, safina musei ado tamo, Negur nẽ tano bun ileya nigin, malai bagai.” ");
INSERT INTO dad_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Idi od anĩ karĩ de fen, to difen, “Age fiyauf are, aim anĩ mata ibodkeleya anĩ yaleya nigin kisi feleya?” ");
INSERT INTO dad_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Anĩ ere, Jesus solof iron, “Ereb tamom age fiya nigin kisi feleya sã anĩ, Negur age fiya nigin kisi feleya.” ");
INSERT INTO dad_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita Jesus irokenen, “Ulef, amã õ dõ mayõf nigin, ereb ereb ganan amã ado anĩ matoron!” ");
INSERT INTO dad_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Age ye di, Jesus idi irokenẽdin, “Aya ã momoi arokeneik, aib taka fõ, kayau, tura tar, sina tama tar be, gere tar, Negur nẽ tano nigin itoron, ");
INSERT INTO dad_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ĩ mala solo musei bagai sain enĩ bun yalouf, ĩ dumen isiyouf buneg mata faimud ibodkeleya yalouf.” ");
INSERT INTO dad_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Age ye fen, Jesus, in dõ fiya tar tuwelf firen geif iroule irokenẽdin, “Ulegef, ada Jerusalem teselef, ereb ereb ganan Tamo Naal nigin profet ditoton anĩ, fau kisi falauf. ");
INSERT INTO dad_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ĩ fau haiden Israel sã anidi imeid bun ilauf. Idi ĩ fau diselinẽf, kono difiyẽf, disisnẽf, wagĩ difiye ken, dukesiyouf. ");
INSERT INTO dad_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Naa towo bun, ĩ fau baban mata kel fã youf.” ");
INSERT INTO dad_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Anĩ ere, dõ fiya tar, enei ganan taka to kelein. Od anĩ nẽ gariya idi bun iminen, agef fen, idi ĩ ereb nigin irok anĩ to kelein. ");
INSERT INTO dad_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sain Jesus Jeriko kelẽ fiyẽ mog, tamo taka mala ifofakeleya, naab yerin nonĩ yef ibodon. ");
INSERT INTO dad_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ĩ tamo kayau musei disi dilef ya karĩ ye fen, ereb wõ yef anĩ nigin to fedin. ");
INSERT INTO dad_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Idi ĩ dirokenen, “Jesus Nasaret tamal isi ilef.” ");
INSERT INTO dad_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Age de di, ĩ iweig iron, “Jesus, Dawid Naal, aya nigin malalon yõ!” ");
INSERT INTO dad_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tamo uyu dilen anidim sakã difiye ken, foro yalauf nigin dirokenen, anĩ ere, ĩ wade bagai iweig iron, “Dawid Naal, aya nigin malalon yõ!” ");
INSERT INTO dad_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus dẽ yel fen, tamo ĩ wagen dirou disiyouf nigin irokenẽdin. Ĩ isi melsã di, Jesus ĩ to fiyen, ");
INSERT INTO dad_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aya õ ere age afonõf ani, õ oroyok?” Tamo anĩ solof iron, “Odug, aya malau kelẽ yalau fenẽ.” ");
INSERT INTO dad_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Age ye di, Jesus ĩ irokenen, “Malã fara wol, ogon momoiya anim el yom.” ");
INSERT INTO dad_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kaisã bagai, ĩ mala fara fel fen, Jesus dõf, Negur yana yalesen. Tamo kayau ganan anĩ dile fen, idig Negur yana dalesen. ");
INSERT INTO dad_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus Jeriko taun wõ ye fen, atu iyok ilen. ");
INSERT INTO dad_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tamo taka yana Sakeus an ibodon. Ĩ takis yaleya tamo neid mudur, safina musei ado. ");
INSERT INTO dad_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ĩ Jesus ĩ ai bagai anĩ ilouf nigin oron, anĩ ere, ĩ tobega tamo nigin ĩ kisi feleya sã, ere nigin, tamo kayau musei dinonolnen. ");
INSERT INTO dad_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Anĩ nigin, ĩ ket gudu ref ile, Jesus ilouf nigin aa fig ilun sõ yen, ere nigin, Jesus naab anĩ dõf, are isi ilauf. ");
INSERT INTO dad_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sain Jesus modoũ anĩ bun ulõ yeis fen, mala ilun ira ken, ĩ irokenen, “Sakeus, kaisã bagai kutũ weis. Gama aya ogon fõ bun abodõf bagai.” ");
INSERT INTO dad_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Age ye di, ĩ kaisã kutũ yeis fen, wau sere fiya ado Jesus aan fiyen. ");
INSERT INTO dad_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tamo kayau ganan enei dile fen, kosesẽ kurã den, “Ĩ mosor ado tamo nẽ fõ bun mogo ilef.” ");
INSERT INTO dad_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Anĩ ere, Sakeus ifar fen, Jesus irokenen, “Odug, ulef! Gama yeir aya neu safina atun fara afe fen, sitakã maleg tamo afenẽdiyouf, aya idegẽya bunem tunĩ neid safina alen are, aya idi mugu mugu mala solo aiwa ifenẽya teten ano fen, afenẽdiyouf.” ");
INSERT INTO dad_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Age ye di, Jesus ĩ irokenen, “Gama kel yaleya anĩ fõ enei bun isil, ere nigin, tamo enĩ, ĩg Abraham naal taka. ");
INSERT INTO dad_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ere nigin, Tamo Naal fõ delen anidi imirneĩd fen, kel gei fouf nigin isin.” ");
INSERT INTO dad_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Idi od enei karĩ de mog, Jesus tobol fe, yaab od taka irokenẽdin, ere nigin, ĩ mogo Jerusalem melsã ifaref, anĩ nigin, tamo kayau Negur nẽ tano kaisã bagai wõ youf de fen, kisi difen. ");
INSERT INTO dad_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Anĩ nigin, ĩ iron, “Tamo taka yana odug ado, ĩ king dinenẽ di, kel isiyouf nigin fõ takã gerõ bagai ilen. ");
INSERT INTO dad_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Anĩ nigin, ĩ yogon ferfer ten iweig laisi fen, moni wan tausen kina mugu mugu ifeneĩd fen, irokenẽdin, ‘Moni enei kabĩ wenẽg mog, aya kelauf.’ ");
INSERT INTO dad_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Anĩ ere, yogon tamo tar kiwai difen ken, eig de dirõf nigin ĩ dumen arũ tamo sur difen, ‘Amã tamo enei nemã king wõ youf nigin to oromak.’ ");
INSERT INTO dad_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Anĩ ere, ĩ king yana yale fen, fonõ kel isin. Agef fen, ĩ, ferfer moni ifenẽdin idi moni ado naig de kabĩ dalen anĩ ilouf nigin, iweignẽdi di, disin. ");
INSERT INTO dad_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Tamo uyu ĩ isi iron, ‘Odug, aya ogon wan tausen kina bun, ten tausen kina taka alen.’ ");
INSERT INTO dad_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Age ye di, yogon odug solof irokenen, ‘Õ ferfer biya, õ de agon! Õ safina naal bagai bun kabĩ biya walen nigin, taun ten lo weid.’ ");
INSERT INTO dad_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ĩ dõ fiya taka isi iron, ‘Odug, aya ogon wan tausen kina bun, faif tausen kina taka alen.’ ");
INSERT INTO dad_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Age ye di, yogon odug ĩg irokenen, ‘Õ taun faif lo weid.’ ");
INSERT INTO dad_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Age fe di, ferfer taka isi iron, ‘Odug, ogon moni yeir. Aya moni anĩ gabar masak nem sile afe fen, anokon. ");
INSERT INTO dad_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aya õ nigin kumĩ aun, ere nigin, õ tamo totol ado. Õ ereb to unokon anĩ waledig, onom to utenen anĩ kusu wodig.’ ");
INSERT INTO dad_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Yogon odug ĩ irokenen, ‘Aya ogon od bunem es ayõf, õ ferfer sane! Õ kelein, aya tamo totol ado, ayam to anokon anĩ aledig, ayam to atenen anĩ kusu afedig de? ");
INSERT INTO dad_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ere wo fen, neu moni benk bun to unon? Ago wom are, sain aya kelauf bun, moni kabĩ yalen anĩ nẽ mala ado, moni õ benk wenen anĩ bagu fiya kel isin ado alem.’ ");
INSERT INTO dad_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Age ye fen, odug idi difaren anidi irokenẽdin, ‘Yogon moni son ge fen, tamo ten tausen kina ado anĩ wenẽg.’ ");
INSERT INTO dad_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Age ye di, idi ĩ dirokenen, ‘Odug, ĩ mogo ten tausen kina ado!’ ");
INSERT INTO dad_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Odug solof iron, ‘Aya ã arokeneik, taka ĩ ado, aya teten anouf, anĩ ere, taka ĩ sã bagai, ereb taka ĩ ado areg, ĩ bun tamal son fouf. ");
INSERT INTO dad_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Anĩ ere, neu kiwai tar, aya nedi king ibodõya nigin to orodin anidi, ein wageun gurig urousig fen, malau bun udenkesig.’” ");
INSERT INTO dad_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesus od enei wogõ yel fen, Jerusalem iseleya nigin, ĩ ketem uyu iselen. ");
INSERT INTO dad_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jesus Moul Arei bun Betfage ado Betani fonõ kelẽ fiye ken, in dõ fiya tar uru sur feid irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Fonõ wageik anĩ bun uleg, an wõg fen, donki naal difon anĩ ulogouf, are aibem taka anĩ bun to iyon. Anĩ biru weleg fen, ein urou usig. ");
INSERT INTO dad_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Taka nem to yeĩf, ‘Ere nigin ã anĩ biru gef?’ urokenẽgouf, ‘Odug anĩ kabĩ ifenẽf nigin.’” ");
INSERT INTO dad_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Anĩ nigin, uyu sur fedin idi dile, Jesus irokenẽdin kilei bagai anĩ fotou difen. ");
INSERT INTO dad_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Idi donki naal biru de mog, anĩ nẽ marau tamo idi to difiyẽdin, “Ã ere nigin donki naal anĩ biru gef?” ");
INSERT INTO dad_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Idi ĩ solo de dirokenen, “Odug anĩ kabĩ ifenẽf nigin.” ");
INSERT INTO dad_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Idi donki naal anĩ Jesus wagen dirousi fen, idi neid gabar teten dirara ken, ĩ anĩ teten dinenẽ ibodon. ");
INSERT INTO dad_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesus iyok ile mog, tamo kayau idi neid gabar naabur du difedin. ");
INSERT INTO dad_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sain ĩ iyok isi, naab Moul Arei bunem isileya non, in dõ fiya tar ganan, memelik ganan inodin dilen nigin, waud al fiya ado aiteid odug nem Negur yana dalesen: ");
INSERT INTO dad_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“King, Odug yana bunem isif, are ĩ el fiya ado!” Saa ilun wau inosiya ado, ilun bagai fula fiya medeĩya ado!” ");
INSERT INTO dad_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tamo kayau atun, Farisia tamo tunĩ Jesus dirokenen, “Tise, ogon dõ fiya tar sakã wiyeĩd!” ");
INSERT INTO dad_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Anĩ ere, Jesus solof iron, “Aya ã arokeneik, idi foro dalauf are, meein eneidi diweig dirõf.” ");
INSERT INTO dad_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ĩ Jerusalem kelẽ fiye ken, taun anĩ ile, wau gudũ fe di, inã yale, ");
INSERT INTO dad_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","iron, “Õ Jerusalem naa enei bun, õ nigin erebem waũ inosiya irou isif anĩ õ keleim, are dem, anĩ ere, gama õ malã bun iminek. ");
INSERT INTO dad_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sain taka õ bun isiyouf, ogon kiwai tar, õ bun teneub mudu dino, salili diyokel, afi diyokalauf. ");
INSERT INTO dad_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Idi õ tenebur dale dirãyõf, õ ado gerẽ tar ogon kau namen difaref geid. Idi meein taka taka teten ditorõ di, to ibodõf, ere nigin, Negur õ bun isin nẽ naa anĩ to ulegen nigin.” ");
INSERT INTO dad_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus tempel modoũ bun ile, idi ereb ereb na nigin sur de mog, an irudidin. ");
INSERT INTO dad_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Agef fen, Jesus idi irokenẽdin, “Negur nẽ Itotoya bun ibodok, ‘Neu fõ are, kosẽya nẽ fõ ibodõf,’ anĩ ere, ãgem ‘bẽ tamo neid iminẽya fõ’ unogen.” ");
INSERT INTO dad_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Naa ganan Jesus tempel bun ifelnẽdidin. Anĩ ere, pris odudug, lo ifelnẽdiya tamo, tamo kayau neid mudur adodo geid, Jesus dukesiyouf nigin naab dimiren. ");
INSERT INTO dad_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Anĩ ere, idi age difouf nigin naab taka to dilen, ere nigin, tamo kayau ganan in od anĩ diroun. ");
INSERT INTO dad_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Naa taka bun, Jesus tempel bun tamo kayau ifelneĩd fen, biya od wogõ yen. Agef mog, pris odudug, lo ifelnẽdiya tamo, mudur adodo geid, ĩ gein disin. ");
INSERT INTO dad_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Idi diron, “Aim õ igirnõ di, õ ereb ereb enĩ ago wof anĩ urokanamã. Aim õ igirnon?” ");
INSERT INTO dad_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus aitedin yale iron, “Ayag to fiya taka afeneĩf. Solog urokanag, ");
INSERT INTO dad_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon naan igunẽdin are saa ilun tamal de, tamo bunem?” ");
INSERT INTO dad_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Idi dogo dogol katõ de fen, diron, “Ada, ‘Saa ilun tamal,’ tauf are, ĩ to fouf, ‘Ere nigin ã ĩ nigin to momoi wiyẽgen?’ ");
INSERT INTO dad_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Anĩ ere, ada, ‘Tamo bunem,’ tauf are, tamo kayau ganan meeinem dinadauf, ere nigin, idi Jon ĩ profet den.” ");
INSERT INTO dad_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Anĩ nigin, idi solo de diron, “Ĩ nain be tamal are amã keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Age de di, Jesus iron, “Ayag ã to arokeneĩf, aim aya igirna di, aya ereb ereb enĩ age afedif.” ");
INSERT INTO dad_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesus tobol fe, yaab od enei tamo kayau irokenẽdin, “Tamo taka wain kabĩ yale, ĩ mala solo yalouf nigin wain kabĩ, kabĩ tamo tunĩ imeid bun ino fen, sain meluk uyu takã ilen. ");
INSERT INTO dad_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Fito fiya sain, ĩ ferfer taka wain kabĩ lo fiya tamo gedin, wain biya tunĩ difenẽf nigin sur fen. Anĩ ere, idi ĩ du ken, sur difiyẽ di, ima sãsã ilen. ");
INSERT INTO dad_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ĩ ferfer taka sur fen, anĩ ere, idi tamo anĩg du ken, mama difenẽ di, ima sãsã ilen. ");
INSERT INTO dad_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ĩ baban takag sur fe di, idi ĩg darau difen ken, dumeitur diran. ");
INSERT INTO dad_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Age dife di, wain kabĩ marau iron, ‘Aya ere naig afouf? Aya neu kesu, oboiyou, sur afouf. Idi ĩ anĩ karĩ difiyẽf be.’ ");
INSERT INTO dad_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Anĩ ere, kabĩ lo fiya tamo idi ĩ dile fen, abob dirokenen. Idi diron, ‘Eĩ ĩ akorouf. Ada ĩ taukeis fen, akor eĩ nedauf.’ ");
INSERT INTO dad_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Anĩ nigin, idi ĩ wain kabĩ dumeitur dira ken, dukesin.” Age dife di, wain kabĩ marau naig fediyouf? ");
INSERT INTO dad_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ĩ isi, kabĩ lo fiya tamo idenkeis fen, wain kabĩ anĩ tamo tunĩ ifenẽdiyouf.” Sain tamo kayau od enei karĩ de fen, idi diron, “Enei to bagai agef wõ youf!” ");
INSERT INTO dad_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Anĩ ere, Jesus idi lo feid le fen, to fedin, “Age fiyauf are, ere gariya nigin Negur nẽ Itotoya bun eig ye irok: “‘Meein are fõ inoya tamom sane de fen, ditoron, meein anĩ gama monog tor wõ yen’? ");
INSERT INTO dad_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aib taka meein anĩ teten kubũ youf, mereb fe fisik fouf, takag, aib taka meein anĩ ĩ teten kubũ youf, ĩ danĩf aas lauf.” ");
INSERT INTO dad_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lo ifelnẽdiya tamo, pris odudug geid, Jesus kaisã bagai irounẽya nigin naab dimiren, ere nigin, idi kelein, ĩ idi nigin yaab od enei wogõ yen. Anĩ ere, idi tamo kayau nigin kumĩ den. ");
INSERT INTO dad_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Anĩ nigin, idi Jesus ololo difiye ken, kofo tamo sur difedin, kofo tamo idi idegẽya bun madur tamo gen dilen. Idi Jesus ereb od wogõya bun kũ fenẽ di, diroune ken, Rom gawaman mudur nẽ lo fiya ado megeir bun dinenẽf nigin kisi difen. ");
INSERT INTO dad_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Anĩ nigin, kofo tamo Jesus to difiyen, “Tise, amã keleĩ, ogon wogõya ifelnẽya ado madur. Õ takam in oroya dõ wouf nigin wewu yõ di, in oroya dõ fen, taka wau morõ to wenẽdig, anĩ ere, õ momoi bun Negur nẽ naab ufelnamãdig. ");
INSERT INTO dad_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Amã Sisa takis mafenẽf anĩ lo dõ fiya de, sã?” ");
INSERT INTO dad_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Anĩ ere, Jesus idi namedin idegẽya anĩ ile fen, irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Koin moni taka ufelnag. Ai nẽ malakanon ado itotoya anĩ bun ibodok?” ");
INSERT INTO dad_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Idi aiten dale diron, “Sisa nẽ.” Age de di, Jesus idi irokenẽdin, “Age fiyauf are, Sisa nẽ are Sisa wenẽg, Negur nẽ are Negur wenẽg.” ");
INSERT INTO dad_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","An Jesus mal atun wogõ yen bun, idi ĩ irounẽya kisi feleya sã. Idi ĩ solof iron anĩ bunem terefeit de fen, foro delen. ");
INSERT INTO dad_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusia tamo idi dirõdig, laa bun tamal mata to ke de fã dedig, dedig anĩ tunim, to fiya eig fiya ado Jesus wagen disin. ");
INSERT INTO dad_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Idi diron, “Tise, Moses itotkanaman, are tamo taka, ne tura laaf fen, aiwa itornen, anĩ ere, kesu sãf are, tamo ĩ kayau waab anĩ yale fen, tura nẽ kesu diroukenẽf. ");
INSERT INTO dad_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gama tura tura sewen dibodon. Matu ketem kayau taka yalen, anĩ ere, kesu yaleya sã mog, tamo laa fen. ");
INSERT INTO dad_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Matu dõ fiya bagam kayau anĩ yalen, ĩ laa fe di, ");
INSERT INTO dad_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ĩ dõ fiya bagam kayau anĩ yalen, age de dile dile, tura tura sewen ganan kesu sã gare desin. ");
INSERT INTO dad_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dum kayau areg laa fen. ");
INSERT INTO dad_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Anĩ nigin, dum laa bun tamal mata kel fãya sain bun, ĩ ai nẽ kayau ibodõf, ere nigin, tura tura sewen anidi adok ĩ dale dogolen?” ");
INSERT INTO dad_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus aitedin yale iron, “Gama sain enei bun, tamo kayau yalef, kayau tamo yalef ya ibodok. ");
INSERT INTO dad_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Anĩ ere, sain anĩ bun, idi laa bun tamal mata kel fãya sain bun dibodõf nigin kisi feleya anidi, an tamo kayau yalef, kayau tamo yalef ya sãf, ");
INSERT INTO dad_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","idi baban gare deyag kisi feleya sã, ere nigin, idi engel gen. Idi laa bun tamal mata ke de fã def nigin, idi Negur nẽ gere tar. ");
INSERT INTO dad_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Anĩ ere, arein aa yã wõ yen nigin Negur nẽ Itotoya bun, Moseseg tamo gare den anĩ mata ke de fã douf nigin ifelnen, ere nigin, ĩ Odug nigin iron, ‘Abraham nẽ Negur, Isak nẽ Negur, Jakop nẽ Negur.’ ");
INSERT INTO dad_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ĩ laa neid Negur sã, ĩ mata ibodõya neid Negur, ere nigin, ĩ bun ganan mata dibodok.” ");
INSERT INTO dad_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lo ifelnẽdiya tamo tunĩ aiten dale diron, “Tise, õ de urok!” ");
INSERT INTO dad_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Anĩ bunem idi kumĩ de fen, taka nem ereb taka nigin baban Jesus to, to fiyen. ");
INSERT INTO dad_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Age dife di, Jesus idi irokenẽdin, “Naig fe di, idi Kristus ĩ Dawid nẽ Naal dedig? ");
INSERT INTO dad_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawid ĩ yogo Buk Sam bun kurõ falaisin: “‘Negur neu Odug irokenen, “Imau biya melem ubod mog, ");
INSERT INTO dad_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ogon kiwai tar on yẽ inoya nẽ sawa anouf.”’ ");
INSERT INTO dad_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawid ĩ nigin ‘Odug’ yef, age fiyauf are, naig fe di, ĩ Dawid naaluouf?” ");
INSERT INTO dad_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tamo kayau ganan karĩ difiyẽ mog, Jesus in dõ fiya tar irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Lo ifelnẽdiya tamo nigin lo welegei. Idi gabar meluluk difonunakel diyo ken, maket modoũ bun aan difiyẽdiyouf anĩ orodidig. Age de fen, idi Juda neid uub fõ bun sia biyai biyai bun dibod ken, tar inoya bun modoũ malabag malabag bun dibodõdig. ");
INSERT INTO dad_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Idi kayau waab idegnẽdiya bunem nedi fõ sosoin difeid fen, meleid yaleya nigin meluk bagai kosẽ dedig. Tamo age fediya, mala solo darau sane bagai dalouf.” ");
INSERT INTO dad_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus mala irã, tamo kayau safineid adodo, nedi kolekta moni tempel bogis bun dino mog, iledin. ");
INSERT INTO dad_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Takag, ĩ lof mog, kayau waab maleg taka isi, peni giriya moni nanaal uru inon. ");
INSERT INTO dad_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Agef fen, Jesus iron, “Aya ã momoi arokeneik, kayau waab maleg enĩ ĩ, ganan wal fediya, odug bagai bogis bun inol. ");
INSERT INTO dad_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tamo kayau enei ganan, dogo neid safineid bun tamal, nedi kolekta moni dinon, anĩ ere, kayau anĩ, maleg bun ĩ mata ibodõf nẽ anĩ ganan inon.” ");
INSERT INTO dad_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","In dõ fiya tar tunĩ, tempel meein biya biya nem ado, safineid biyai Negur difenen anim, tempel naki difiyen anĩ nigin wogõ den. Anĩ ere, Jesus iron, ");
INSERT INTO dad_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ã ulegef enei nigin, sain fau isiyouf, meein enĩ taka to abob tete tete yenẽf, anĩ adok fau isog irailauf.” ");
INSERT INTO dad_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Idi to difen, “Tise, ere sain eneidi wõ youf? Ere uris anĩ, eneidi kisi falauf nigin wõ youf?” ");
INSERT INTO dad_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Age de di, Jesus iron, “Takam to idegneĩf nigin lo weleg. Ere nigin, musei aya yanau nem disi dirõf, ‘Aya Kristus,’ takag, ‘Sain mogo melsak.’ Age de di, to dõ wiyẽdig. ");
INSERT INTO dad_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ã kusĩ nigin ado, kantri bun kiwai fen, gawaman narĩ difef ya karĩ gouf, ã to tererẽ gei. Ereb ereb enidi ketem wõ youf bagai, anĩ ere, idikeleya anĩ, sain anĩ bun bagai to wõ youf.” ");
INSERT INTO dad_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Age ye fen, Jesus idi irokenẽdin, “Teneub taka fã ye fen, ĩ teneub taka nigin kiwai ifenẽf, tano taka ĩ tano taka nigin kiwai ifenẽf. ");
INSERT INTO dad_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mimĩ odug wowã youf, naũ odug ado dagi totol, modoũ taka taka bun wowã youf, ereb ereb kumĩya nẽ ado uris odudug, saa bun wowã youf. ");
INSERT INTO dad_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Anĩ ere, eneidi ganan fau to wõ ye mog, idi kaka diyei ken, kafĩ fiya difeneĩf. Idi Juda neid uub fõ bun ado kalabus bun dineneĩf. Age de fen, ã king ado gawaman mudur adodo meleid bun dirouleyeĩf, anĩ ganan aya yanau nigin de fen, age diyeĩf. ");
INSERT INTO dad_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Naab enei bunem, ã idi meleid bun, aya nigin kurõ wesigouf. ");
INSERT INTO dad_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Anĩ ere, ã idi meleid bun aug isenneĩya nigin dodok ge fen, to wogõ gouf nigin ã kisi ketem ufokeleg. ");
INSERT INTO dad_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ere nigin, aya, od ado kisi biya, ãgenei kiwai tar takam solof irõya be, kiwai ifenẽya kisi feleya sã anĩ afeneĩf. ");
INSERT INTO dad_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Anĩ ere, ã fau sineĩ temeĩ tarem, tureĩ tarem, sirag ado neĩ mou taremeg kiwai difenei ken, ã tunĩ laa bun dineneĩf. ");
INSERT INTO dad_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tamo ganan, aya yanau nigin de fen, ã kiwai difeneĩf. ");
INSERT INTO dad_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Anĩ ere, mudureĩ bun, fatiyeĩ tekelei bagai to iminkalauf. ");
INSERT INTO dad_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Megeir ifareya bunem, mata walogouf. ");
INSERT INTO dad_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Sain ã Jerusalem kusĩ tamom salili dife mog, ulogouf, ã keleĩ youf, Jerusalem fonou inenẽya anĩ melsak. ");
INSERT INTO dad_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Age fiya ulogouf, idi Judia distrik bun dibodok, arein diya diselauf, idi taun anĩ bun dibodok, anenem diyalalauf, idi taun yerin difaref, namen to dilauf bagai. ");
INSERT INTO dad_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ere nigin, sain enei are, Negur nẽ Itotoya bun ibodok ganan kisi falauf nigin darau ifenẽya nẽ sain. ");
INSERT INTO dad_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Naa anĩ bun, kayau bouweid ado, kayau kesu su difenek ado, idi meleidlon ado. Teneub anĩ bun, morõ odug wõ ye fen, Negur nẽ didi, tamo kayau enei bun isiyouf. ");
INSERT INTO dad_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Idi dimig nem didenkeis, kalabus tamo gei difeid fen, teneub ganan bun diroulediyouf. Jerusalem fau haiden Israel sã anidim lalai difeid dile, haiden Israel sã anidi neid sain anĩ kisi falauf. ");
INSERT INTO dad_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Uris gaa bun, ogõ bun ado, barisa bun wõ youf. Tenebur ein, teneub ganan bun moloun fire bagai fã ye fen, maaĩ gugu re di, idi kisi gurũ ye fen, nene douf. ");
INSERT INTO dad_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tamo kayau, teneub bun ere wowã youf de fen, kumĩ de, meleid waĩ youf, ere nigin, saa nẽ megeir guyoyõ douf. ");
INSERT INTO dad_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sain anĩ bun, tamo idi, Tamo Naal lalo bun megeir ado fula fiya medeĩya barikã isi mog, dilouf. ");
INSERT INTO dad_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ereb ereb enei gariya ino, wõ ye di, ufareg fen, mudureĩ utadseg, ere nigin, kel yaleyeĩya are melsak.” ");
INSERT INTO dad_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Age ye fen, Jesus yaab od enei irokenẽdin, “Ã aa fig ado aa ganan ulogouf. ");
INSERT INTO dad_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sain idi aarau ifiraũd mog, anĩ ã aug uleg fen, ã keleĩdig, saneya melsak. ");
INSERT INTO dad_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Age fiya bagai, ereb ereb eneidi wõ ye mog, ulogouf are, ãg keleĩ youf, Negur nẽ tano are mogo melsak. ");
INSERT INTO dad_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Aya ã momoi arokeneik, tamo kayau sain enei bun dibodok anidi to gare de mog, ereb ereb eneidi ganan wõ youf. ");
INSERT INTO dad_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Saa teneub ado sa kalauf, anĩ ere, neu od to bagai sa kalauf. ");
INSERT INTO dad_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Lo walagauf, sãf are, saafei ge, aai naanuei ge fen, tenebur mata ibodõya nigin sii fiya anim, ãgenei wauĩ bun kafĩ yeĩ di, ã keleĩ sã mog, Negur nẽ naa kor gen ã bun isiyouf. ");
INSERT INTO dad_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Naa are, tenebur tamo kayau ganan bun wõ youf. ");
INSERT INTO dad_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eneidi ganan wowã you fenẽ anĩ wal fiya kisi falauf nigin ado, Tamo Naal mala bun ufaragauf nigin, ã faimud ololo wog fen, kosẽ gouf.” ");
INSERT INTO dad_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Naa ganan, Jesus tempel bun ifelneĩd fen, aragau ganan, Moul Arein isel fen, bõ an ibodõdig. ");
INSERT INTO dad_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Age fe di, tamo kayau ganan, tempel bun karĩ difiyẽf nigin, bonimei bagai disidig. ");
INSERT INTO dad_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gama Bret Yis Sã Sifa naa, Pasa naa dedig melsã di, ");
INSERT INTO dad_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pris odudug, lo ifelnẽdiya tamo geid, Jesus yukesiya nigin naab dimiren, ere nigin, idi tamo kayau nigin kumĩ den. ");
INSERT INTO dad_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Age fe di, Satan, Judas, Iskariot tamal dedig, tuwelf dõ fiya tar atun taka, ĩ namen ilen. ");
INSERT INTO dad_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Age fe di, Judas ile, pris odudug ado tempel lo fiya tamo neid uyu irouya bun wõ ye fen, idi geid ĩ naig fe Jesus kiwai imeid bun inouf nigin katõ difen. ");
INSERT INTO dad_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Idi od enĩ karĩ de, waud al fe fen, ĩ moni difenẽf nigin dirokenen. ");
INSERT INTO dad_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ĩ yo ye fen, tamo kayau to guru de mog, Jesus idi imeid bun inouf nigin naab imirek ilen. ");
INSERT INTO dad_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Anĩ dumen, Bret Yis Sã anĩ nẽ naa wõ yen, anĩ bun idi Pasa naa nigin sipsip naal diden ken, sesewi difedig. ");
INSERT INTO dad_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus, Pita Jon ado sur feid fen, iron, “Uleg, ada Pasa naa nẽ saaf tãf nigin dodok wanadag.” ");
INSERT INTO dad_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Idi Jesus to difiyen, “Õ, amã nain anĩ, Pasa naa nẽ saaf tãf nigin, dodok mafouf anĩ oroyok?” ");
INSERT INTO dad_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Age de di, Jesus idi irokenẽdin, “Taun wõg fen, tamo taka darum naan ado isi fotou yeĩf, ĩ fõ bun ilauf anĩ dõg uleg. ");
INSERT INTO dad_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Agog fen, ã fõ marau eig wiyẽg urokenẽgouf, ‘Tise õ irokonok: Aab nanĩ bun an, aya neu dõ fiya tar geid, Pasa naa nẽ saaf mãf?’ ");
INSERT INTO dad_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ago ge di, ĩ aab odug ilun anĩ ifelneĩf, an ereb ereb dodok de bure difelen. An neda nigin dodok gouf.” ");
INSERT INTO dad_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Age ye di, idi dile, Jesus irokenẽdin kilei ereb ereb age fiya dilen. Anĩ nigin, idi Pasa naa dodok difen. ");
INSERT INTO dad_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sain wõ ye di, Jesus in aposel geid tebol bun dibodon. ");
INSERT INTO dad_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Age de fen, Jesus idi irokenẽdin, “Aya darau yaleya sã mog, ã geid Pasa naa nẽ saaf tãf anĩ orouf bagai. ");
INSERT INTO dad_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ere nigin, aya ã arokeneik, aya baban Pasa naa nẽ saaf to ãf ile, anĩ fau Negur nẽ tano bun kisi falauf.” ");
INSERT INTO dad_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Age ye fen, ĩ kap yale, Negur de fiye ken, iron, “Enei waleg fen, ã atun foig. ");
INSERT INTO dad_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aya ã momoi arokeneik, aya baban wain to ãf ile, Negur nẽ tano isiyouf.” ");
INSERT INTO dad_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Age ye fen, Jesus bret yale, Negur de fiye ken, mumã fen. Agef fen, ĩ in dõ fiya tar ifeneĩd fen, iron, “Eĩ neu bouwau, ã nigin afeneik. Enei agog fen, aya nigin kisi gouf.” ");
INSERT INTO dad_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Age fiya bagai, saaf bure difel fen, Jesus kap yale, iron, “Kap enei, neu naudou bun, ã Negur geid bar itenẽya mata, naudou are ã nigin fi felef. ");
INSERT INTO dad_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Anĩ ere, taka aya kiwai imeid bun inoyauf, are ein tebol bun urom imamã manof. ");
INSERT INTO dad_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Momoi, Tamo Naal ĩ nigin iron kilei agef ilauf, anĩ ere, tamo ĩ kiwai ifenek, ĩ malalon ado.” ");
INSERT INTO dad_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Age ye di, idi dogo dogol toti difen, idi atun aim bagai tobonunã enei age fouf. ");
INSERT INTO dad_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Takag, idi atun aim anĩ odug bagai ibodõf nigin luwa diroun. ");
INSERT INTO dad_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Age dife di, Jesus idi irokenẽdin, “Haiden neid king, dogo neid tamo kayau lo difedig, idi dogo neid megeir tamo kayau bun yaor difedig, are ada biya difadauf dedig. ");
INSERT INTO dad_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Anĩ ere, ã age fiya anĩ to ago gouf. Age fiya ban, ã atun odug ibodok are, kesu naal gen ibodõf, takag, uyu irouya tamo ĩ, aruna yaleya tamo gen ibodõf. ");
INSERT INTO dad_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ai anĩ odug, taka tebol bun ibodok anĩ de, taka ĩ aruna yalef anĩ? Taka ĩ tebol bun ibodok anĩ sã de? Anĩ ere, aya ã atun aruna yaleya tamo gen abodok. ");
INSERT INTO dad_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ã anĩ, neu kisi fiya isi di, aya bun toku ufaregen. ");
INSERT INTO dad_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Neu Dei tano aya ifanan gen, ayag tano ã afeneik. ");
INSERT INTO dad_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Age afe di, ã neu tanon, tebol bun saaf ado naan wãgauf, king nẽ sia bun ubodõg fen, Israel ibor tuwelf es gouf. ");
INSERT INTO dad_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, tamo wit biya ado wit ido foi fiya nigin age fedig gen, Satan ĩ ãgenei momoiya kisi yeĩ fenẽ nigin to fen. ");
INSERT INTO dad_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Anĩ ere, aya, Simon õ nigin ogon momoiya to urofosiyouf nigin kosẽ aun. Anĩ nigin, sain õ kelouf, turã tar megeir wediyouf.” ");
INSERT INTO dad_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Anĩ ere, Pita aiten yale iron, “Odug, aya õ ado kalabus bun ado, laa bun ileya nigin dodok afel.” ");
INSERT INTO dad_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Age ye di, Jesus iron, “Pita, aya õ arokonok, gama fau tataro kokorok yeya sã mog, õ wa fen, aya nigin keleĩ sã wo, towo wouf.” ");
INSERT INTO dad_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Age ye fen, Jesus idi to fedin, “Sain aya ã moni nẽ kodol, faa be, su sã sur ayein, ã ere taka lau gen de?” Idi solo de diron, “Sã.” ");
INSERT INTO dad_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Age de di, Jesus idi irokenẽdin, “Anĩ ere, gama taka ĩ moni nẽ kodol adouf, yalouf, faag age fiya, taka ĩ dimig sã, yogon gabar na nigin sur fe fen, taka na yalouf. ");
INSERT INTO dad_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Negur nẽ Itotoya bun eig ye ibodok, ‘Ĩ tamo sesen geid bagu difedin.’ Aya ã arokeneik, enei aya bun kisi fel, agef wõ youf. Ariya, aya nigin itoton are mogo kisi felef.” ");
INSERT INTO dad_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","In dõ fiya tar diron, “Ulef, Odug, dimig uru yeir.” Age de di, ĩ iron, “Are de.” ");
INSERT INTO dad_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Agef fen, Jesus aabẽ tamal ulõ yeis fen, gai age fedig gen, Moul Arein iselen, age fe di, in dõ fiya tareg ĩ dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Modoũ anĩ bun wõ de fen, Jesus in dõ fiya tar irokenẽdin, “Kisi fiya bun to kubũ gouf nigin kosẽ wog.” ");
INSERT INTO dad_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesus yogon dõ fiya tar itorneĩd, meein irã di, ile kubũ youn age fiyan ile, ibor bobou fe fen, kosẽ yen, ");
INSERT INTO dad_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Dei, õ oroyõf are, kap enĩ aya bun walelauf. Anĩ ere, neu oroya to dõ wouf, on oroya dõ wo.” ");
INSERT INTO dad_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Engel taka saa ilun tamal, ĩ bun wõ ye fen, megeir ifenen. ");
INSERT INTO dad_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Age fe di, Jesus wau morõ fatuk fe di, ĩ totol bagai kosẽ yen, age fe di, maab, naud isidig gen, tenebur kuku ren. ");
INSERT INTO dad_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ĩ kosẽ yel fen, fã ye, in dõ fiya tar gedin kel ile, waud gudũ falaisil, den mog, iledin. ");
INSERT INTO dad_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Agef fen, Jesus idi to fedin, “Ere nigin mulaĩ wenẽgef? Ã kisi fiya bun to kuku gouf nigin fafãg fen, kosẽg.” ");
INSERT INTO dad_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus fau wogõ ye mog, tamo musei disin, tuwelf in dõ fiya tar idi anĩ atun taka, Judas dedig inim uyu iroukenẽdin. Ĩ Jesus umã fiyẽf nigin non ilen. ");
INSERT INTO dad_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Anĩ ere, Jesus ĩ to fiyen, “Judas, õ umãya bunem Tamo Naal kiwai wenẽf de?” ");
INSERT INTO dad_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sain Jesus nẽ dõ fiya tar, ereb wõ you fenẽ age fe di, dile fen, idi diron, “Odug, amã nemã dimig nem madenauf de?” ");
INSERT INTO dad_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Age de fen, idi takam, pris mudur ado nẽ ferfer weder biyalẽ anĩ salõf iran. ");
INSERT INTO dad_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Anĩ ere, Jesus iron, “Baban enei to ago gouf!” Age ye fen, ĩ tamo anĩ nẽ weder kobũf fen, el fiyen. ");
INSERT INTO dad_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Agef fen, Jesus, pris odudug, tempel lo fiya tamo neid uyu irouya geid, mudur adodo, ĩ nigin disin anĩ irokenẽdin, “Ã bẽ tamo urounẽgouf gen, ã dimig adodo seburer adodo usigef de? ");
INSERT INTO dad_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Naa ganan, aya ã geid tempel bun tabodon, anĩ ere, ã aya bun imeĩ taka to unogen. Anĩ ere, eĩ ãgenei sain, are gugum irouneik nigin.” ");
INSERT INTO dad_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Idi Jesus dale, diroune ken, pris mudur ado nẽ fõ bun dirou dilen. Pita ĩ so rel fen, dumeid dõ fen. ");
INSERT INTO dad_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Anĩ ere, sain idi fofomala atun yã kũ de dibodon, Pita ĩg an weim dibodon, ");
INSERT INTO dad_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kabĩ kayau momoul taka, Pita yã sirin ibod mog, ilen. Kayau momoul anĩ Pita lo fel fen, iron, “Tamo eneig ĩ geid.” ");
INSERT INTO dad_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Anĩ ere, Pita waf fen, iron, “Kayau, aya ĩ keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sain naal ile di, taka nem ĩ ile fen, iron, “Õg idi neid taka.” Anĩ ere, Pita iron, “Mou, aya sã!” ");
INSERT INTO dad_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aua tekelei age fiya ile di, taka bagam ĩ nigin totol iron, “Momoi bagai, tamo eneig ĩ geid diyon, ere nigin, ĩg Galili tamal.” ");
INSERT INTO dad_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Anĩ ere, Pita aiten yale iron, “Tamo, õ urok anĩ aya keleĩ sã!” Ĩ irõ mog bagai, tataro kokorok yen. ");
INSERT INTO dad_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Odug falei yel, Pita lo felen. Age fe di, Pita Jesus wogõ fiyen anĩ nigin weder fokõ yen, “Gama fau tataro kokorok yeya sã mog, õ aya nigin wa wo, towo wouf.” ");
INSERT INTO dad_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Age fe di, ĩ mayarẽ ile fen, inã fatuk yalen. ");
INSERT INTO dad_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tamo Jesus dirounen idi, ĩ diseline ken, wagĩ difiyen. ");
INSERT INTO dad_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Age dife fen, idi Jesus mala difofakel fen, to difiyen, “Kurõ weis urokanamã! Aim õ inok?” ");
INSERT INTO dad_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Age de fen, idi kono fiya od musei dirokenen. ");
INSERT INTO dad_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","We fele di, tamo kayau neid mudur adodo neid kaunsel, are pris odudug, lo ifelnẽdiya tamo geid, weim guru de mog, Jesus idi gedin dirou dilen. ");
INSERT INTO dad_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Idi diron, “Õ Kristus ouf are, amã urokanamã.” Anĩ ere, Jesus aitedin yale iron, “Aya ã arokeneĩf are, ã to momoi gouf, ");
INSERT INTO dad_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","agef fen, aya ã to ayeĩfeg, ã to solog urõgouf. ");
INSERT INTO dad_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Anĩ ere, gama sain enei bunem ilauf ganan, Tamo Naal ĩ, Negur megeir ado ima biyalem ibodõf.” ");
INSERT INTO dad_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Age ye di, idi ganan to difiyen, “Age fouf are, õ anĩ Negur Naal de?” Ĩ aitedin yale iron, “Ã de urõgef, aya anĩ.” ");
INSERT INTO dad_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Age ye di, idi diron, “Ere nigin ada, ĩ nigin od megeir fiya nigin tamo baban tamirẽf? Ada ĩ sigoron bagai karĩ taul.” ");
INSERT INTO dad_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Age de fen, guru fiya ganan fã de, Jesus Pailat bun dirou dilen. ");
INSERT INTO dad_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Age de fen, idi mogo gariya dino, ĩ bouwa bun od du ken, diron, “Amã, tamo enei nemã tamo kayau ganan idegẽya bunem sanen guri feid irou ile mog, mailen. Ĩ Sisa takis ifenẽya nigin katũ fiyeĩd fen, ĩ yogo nigin aya Kristus, aya king yen.” ");
INSERT INTO dad_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Anĩ nigin, Pailat Jesus to fiyen, “Õ Juda neid king de?” Jesus solof iron, “Are de yer, õ urok anĩ.” ");
INSERT INTO dad_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Age ye di, Pailat ĩ, pris odudug, tamo kayau geid irokenẽdin, “Aya tamo enei bou bun mosor taka to ailel.” ");
INSERT INTO dad_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Anĩ ere, idi totol dinon, “Ĩ Judia distrik ganan bun, in ifelnẽya bunem tamo kayau waud yalen. Ĩ Galili an gariya ino fen, tokõ fel eineg isin.” ");
INSERT INTO dad_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat anĩ karĩ ye fen, ĩ Galili tamal be anĩ to fen. ");
INSERT INTO dad_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailat ĩ, Jesus Herod nẽ tano bun tamal yeya kelei ken, Herod gein sur fen, Herod ĩg sain anĩ bun Jerusalem ibodon. ");
INSERT INTO dad_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod Jesus ile fen, wau fatuk kulĩ yen, ere nigin, sain meluk bagai ĩ ileya nigin oron. Ĩ nigin karĩ yen nigin, Herod ĩ Jesus bun memelik tunĩ ilouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod Jesus musei bagai to fiyen, anĩ ere, Jesus taka to solof iron. ");
INSERT INTO dad_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pris odudug, lo ifelnẽdiya tamo geid an difaren, ĩ bou bun od totol bagai dinon. ");
INSERT INTO dad_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Age dife di, Herod yogon kusĩ tamo geid, Jesus kasã difiye ken, kono difiyen. Age dife fen, kolos biya difounne ken, Pailat wagen sur difiyẽ di, kel ilen. ");
INSERT INTO dad_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Naa anĩ bun, Herod Pailat ado nigal dun, uruwa bun idi uruwom kiwain. ");
INSERT INTO dad_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat ĩ, pris odudug, mudur adodo, tamo kayau geid iweigneĩd fen, ");
INSERT INTO dad_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","irokenẽdin, “Ã tamo enei, tamo kayau waud yale fen, sane nigin weleid inon ge fen, waleg, urou usigel. Aya ã meleĩ bun to afiyem, anĩ ere, ã ĩ bou bun od unogen anĩ, tamo enei bun gariya taka to ailel. ");
INSERT INTO dad_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod ĩg age fiya, anĩ nigin, ĩ kel sur fe di, ada gein isil. Anĩ ulogouf, ĩ yukesiya nigin ereb sane taka to age fen. ");
INSERT INTO dad_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Anĩ nigin, aya darau dogol afen ken, atornẽf.” ");
INSERT INTO dad_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Anĩ ere, idi sigoreid takai fen, diweig diron, “Tamo enei ukesiyouf! Barabas walis kanamã!” ");
INSERT INTO dad_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas ĩ anĩ taun oun kusĩ yales fen, tamo yukesin nigin, kalabus bun dinenen.) ");
INSERT INTO dad_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat, Jesus yalisnẽya nigin baban totol bagai irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Anĩ ere, idi baba baban diweig diron, “Aa tetek bun ũf! Aa tetek bun ũf!” ");
INSERT INTO dad_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Age de di, Pailat ĩ irõ, towo fen sain bun anĩ irokenẽdin, “Ere nigin? Tamo enei, ere mosor inon? Aya ĩ yukesiya nẽ gariya anĩ, ĩ bun taka to ailel. Anĩ nigin, aya ĩ darau afen ken, atornẽf.” ");
INSERT INTO dad_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Anĩ ere, idi aiteid odudug fen, ĩ aa tetek bun yũf nigin, baba baban dirokenen. Age dife di, dogo neid aitedim, Pailat nẽ od lai difiyen. ");
INSERT INTO dad_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Anĩ nigin, Pailat, nedi oroya dõ fiya nigin kisi yale fen, irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pailat ĩ, tamo kusĩ yales fen, tamo yukesi di, kalabus bun dinenen ĩ nigin tamo kayau to difiyen anĩ, yalisne ken, dogo neid oroya dõ difouf nigin Jesus ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Idi Jesus dirou dile fen, Simon Sairini tamal, ĩ yogon fonom isi mog, luwen ĩ dale, aa tetek orowa se dife di, faali fe, Jesus dõ fen. ");
INSERT INTO dad_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tamo kayau musei, kayau idi ĩ nigin waud gudũf fen, inã dalen geid, dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Anĩ ere, Jesus idi bun falei yel, idi irokenẽdin, “Jerusalem nẽ barai tar, aya nigin inã to waleg, ã aug nigin ado gereĩ tar nigin inã waleg. ");
INSERT INTO dad_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ere nigin, sain fau isiyouf bun, idi dirõf, ‘Kayau dali, kayau fau kesu gõ fiya sã, kayau kesu su ifenẽya sã anidi el fedif!’ ");
INSERT INTO dad_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Age de fen, “‘idi arei dirokenẽdiyouf, “Teteman kukug!” arei mudu dirokenẽdiyouf, “Kerub wamãg!”’ ");
INSERT INTO dad_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tamo, aa mata mog, enei age difedif are, meti youf sain bun, ere wõ youf?” ");
INSERT INTO dad_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lo wal fiya tamo uru idig, ĩ geid laa bun dinenẽdiyouf nigin dirou dilen. ");
INSERT INTO dad_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sain idi modoũ yana Mudur Tuwan dedig wõ de fen, an Jesus aa tetek bun dun, lo wal fiya tamo uru geid, taka biya melem, taka ki melem. ");
INSERT INTO dad_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Age dife di, Jesus iron, “Dei, idi neid mosor nigin weder tu kel, ere nigin, idi keleĩ sa ken, enei age difef.” Age fe di, idi aisaĩ kodẽ de fen, yogon kolos idi atun foifu difen. ");
INSERT INTO dad_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tamo kayau difar fen, lo difeid mog, mudur adodomeg ĩ kasã difiyẽ diron, “Ĩ tunĩ isennẽdin, ĩ Kristus Negur igirnen ouf are, utornẽg len, yogo bouwa isennẽf.” ");
INSERT INTO dad_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kusĩ tamog dise fen, diselinen. Idi wain makik ado difen ken, ");
INSERT INTO dad_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","diron, “Õ Juda neid king ouf are, ogo boũ usennẽf.” ");
INSERT INTO dad_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ĩ muduren itotoya eig ya yenen: EĨ JUDA NEID KING. ");
INSERT INTO dad_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Lo wal fiya tamo aa tetek bun difaren anĩ takam, Jesus kono fiyẽ iron, “Õ Kristus ouf are, õ ogo usenne ken, amã usennamãf!” ");
INSERT INTO dad_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Anĩ ere, lo wal fiya tamo taka im, ne tã ou fiye ken, iron, “Õ kafĩ fiya tekelei walef, anĩ ere, õ Negur to kumĩ wiyek de? ");
INSERT INTO dad_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ada urom darau talef, are de, ere nigin, ada urom sane age tafen anĩ mala solo. Anĩ ere, tamo enei ereb sane to age fen.” ");
INSERT INTO dad_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Age ye fen, ĩ Jesus irokenen, “Jesus, sain õ ogon tano bun usel fen, aya karĩ wiyalauf.” ");
INSERT INTO dad_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Age ye di, Jesus tamo anĩ irokenen, “Aya õ momoi arokonok, gama õ aya ado paradis bun tabodõf.” ");
INSERT INTO dad_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Gaa atun tuwelf kilok age fiya bun, teneub ganan bun gugum kelef ile, tri kilok aragaun, ");
INSERT INTO dad_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ere nigin, gaa mala ifokelen. Age fe di, tempel nẽ gabar anĩ atusil serek fe, uru wõ yen. ");
INSERT INTO dad_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus ait odug nem iweig iron, “Dei, neu uur õ imã bun anof.” Agef iro ken, ĩ oboi irour yalen. ");
INSERT INTO dad_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kusĩ tamo neid orowa, Jesus age fiya ile fen, Negur yana yales iron, “Momoi, tamo eĩ madur tamo.” ");
INSERT INTO dad_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tamo kayau ganan idi lo fiya nigin guru difen, ereb anĩ wõ ye di, meledim dilen, are idi waud gudũf fen, akoreid du ken, firagagaũ difen. ");
INSERT INTO dad_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Anĩ ere, idi Jesus keleĩ anidi ganan, idi atun kayau Galilim ĩ dõ de disin anidig, so del difar fen, eneidi wõ ye di, lo difen. ");
INSERT INTO dad_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tamo taka yana Josef, ĩ kaunsel taka, madur tamo biya bagai, ");
INSERT INTO dad_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","anĩ nigin, ĩ idi neid tobonuneid ado od difon anĩ nigin to yo yen. Ĩ Judia distrik bun Arimatea taun tamal, ĩ Negur nẽ tano isiyouf anĩ tari fen. ");
INSERT INTO dad_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Josef ĩ, Pailat gein ile, Jesus bou buru yalouf nigin to fiyen. ");
INSERT INTO dad_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Agef fen, ĩ Jesus bou buru yale, irou isil, gabar lalau nem silef fen, matmat sa bun ku dalen an inenen, ku anĩ bun an taka to dinenen. ");
INSERT INTO dad_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Naa anĩ dodok fiya naa, Sabat naa mogo gariya inou fenẽ melsã. ");
INSERT INTO dad_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kayau Jesus geid Galilim disin, Josef dõ de, matmat ado, Jesus bouwa buru naig de dinof anĩ, lo difen. ");
INSERT INTO dad_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Age difel fen, idi fonõ dile, bou wã fiya nẽ marasin ado moul sumeĩ biya bagai dodok difen. Anĩ ere, idi Sabat naa nigin ĩtãfiya dõ de fen, si dinon. ");
INSERT INTO dad_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Uub nẽ naa matu bun bonimei bagai mumurei ado, kayau idi, bou wã fiya nẽ marasin dodok difen anĩ dale fen, matmat bun dilen. ");
INSERT INTO dad_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Age dife fen, idi matmat bun meein wele feleya dilen. ");
INSERT INTO dad_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Anĩ ere, sain idi meku namen dilen, idi Odug Jesus nẽ bouwa buru an to dilen. ");
INSERT INTO dad_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Idi enei nigin kisi musei dale mog bagai, tamo uru kolos medeĩya barikã siridin difaren. ");
INSERT INTO dad_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Age dife di, kayau kumĩ de fen, kususu de, teneub lo difen, anĩ ere, tamo idi kayau dirokenẽdin, “Ã ere nigin laa atun mata tamo umirnẽgef? ");
INSERT INTO dad_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ĩ ein sã, ĩ mogo fã yel! Ĩ Galili oun ã geid ubodõg fen, irokenein anĩ, wedereĩ fokõ youf, ");
INSERT INTO dad_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ĩ iron, ‘Tamo Naal mosor adodo imeid bun dino di, ĩ aa tetek bun dukesiyouf, age dife di, naa towo bun, ĩ baban mata kel fã youf.’” ");
INSERT INTO dad_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Age de di, kayau idi, in od anĩ wedereid fokõ yen. ");
INSERT INTO dad_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sain idi matmat bunem ke de, disi fen, aposel ilewen tunĩ ganan geid, enei ganan wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kayau idi are Maria Magdala tamal, Joana, Maria Jems nẽ sina. Kayau anidi, kayau tunĩg geid, enei aposel wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Anĩ ere, idi kayau nigin to momoi den, ere nigin, kayau neid od, idi bun auya gen. ");
INSERT INTO dad_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Anĩ ere, Pita fã yale, matmat bun gudu re ilen. Ĩ ku bun itin, gabar lalau dogol yen mog, ilen, agef fen, ereb anĩ wõ yen anĩ nigin, ĩ kisi musei yalef ile, yogon fõ bun ilen. ");
INSERT INTO dad_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Naa de anĩ bun, idi neid tamo uru, fonõ taka yana Emaus dilen, Jerusalem anenem Emaus are ilewen kilomita age fiya. ");
INSERT INTO dad_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Idi urom, ereb ereb ganan wõ yen anĩ abob dirokenek dilen. ");
INSERT INTO dad_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Idi eneidi nigin diro ken, katõ de dile mog, Jesus yogo isi, weim diyok dilen. ");
INSERT INTO dad_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Anĩ ere, idi Jesus keleĩya nigin meleid ifofakelen. ");
INSERT INTO dad_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Age dife di, Jesus idi to fedin, “Ã ere nigin naab luwen katõ ge usigef?” Idi dẽ del fen, idi neweid wau gudũ fiya ado agogon delen. ");
INSERT INTO dad_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Idi taka yana Kleopas Jesus solof irokenen, “Õ ege Jerusalem nẽ ki tamo nigin, naa eneidi bun an ereb ereb wõ yen anĩ, õ keleĩ sã de?” ");
INSERT INTO dad_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Age ye di, Jesus idi irokenẽdin, “Ere bagai?” Idi Jesus dirokenen, “Jesus Nasaret tamal nigin. Ĩ profet taka, Negur ado tamo kayau ganan meleid bun, od ado tobonunã bun megeir barikã. ");
INSERT INTO dad_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pris odudug, neda mudur ado idim, ĩ laa bun dinenẽf nigin imeid bun dino di, aa tetek bun dukesin. ");
INSERT INTO dad_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Anĩ ere, amã waumã iron, im anĩ Israel tamo kayau kel gei fouf maun. Anĩ dogol sã, enei ganan wõ yen are, gama naa eneim mogo naa towo ilef. ");
INSERT INTO dad_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Takag, amã nemã kayau tunĩg, amã terẽ difamam. Gama bonimei bagai, idi matmat bun dilel, ");
INSERT INTO dad_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","anĩ ere, idi yogon bouwa buru to dilel. Idi dile, meleid seleulã kurãf fen, engel diledin, engel idi dirokenẽdil, Jesus ĩ mata ibodok, difiyẽdi di, disi, amã dirokanamam. ");
INSERT INTO dad_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Age de di, amã tunĩ matmat bun dile, kayau wogõ del gen bagai dilel, anĩ ere, idi Jesus to dilel.” ");
INSERT INTO dad_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesus idi irokenẽdin, “Ã neneya bagai, ã profet wogõ den anĩ ganan, wauĩ bun momoiya nigin folo reya bagai! ");
INSERT INTO dad_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kristus ĩ darau enei yale fen, yogon fula fiya medeĩya namen to ilauf de?” ");
INSERT INTO dad_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Age ye fen, ĩ Moses ado profet ganan neid itotoya bunem gariya ino fen, yogo nigin Negur nẽ Itotoya ganan bun ibodok anĩ, idi faded fedin. ");
INSERT INTO dad_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Idi fonõ dilef nẽ anĩ kelẽ difiye ken, Jesus tokõ feleya nigin suma ino genen. ");
INSERT INTO dad_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Anĩ ere, idi totol bagai dirokenen, “Amã geid tabodõf, ere nigin, gaa mogo kuru kelef, gugum irousif.” Anĩ nigin, Jesus idi geid dibodõf nigin namen ilen. ");
INSERT INTO dad_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sain ĩ idi geid tebol bun dibod ken, ĩ bret yale, Negur de fiyẽ, mumãf fen, gariya ino ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Age fe di, idi meleid fara fele di, idi Jesus nigin kelein. Age dife di, ĩ idi meleid bun iminkelen. ");
INSERT INTO dad_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Idi abob dirokenen, “Sain ĩ naab luwen wogõ fada fen, Negur nẽ Itotoya faraf ifelnadal mog, ada namedan wauda to tõf yalel de?” ");
INSERT INTO dad_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Age de fen, idi fã de dale, kaisã bagai Jerusalem keku de dilen, an idi aposel ilewen, tamo tunĩ idi geid, guru de difar mog, fotou difedi di, ");
INSERT INTO dad_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","diron, “Are momoi! Odug fã ye fen, Simon bun wõ yen.” ");
INSERT INTO dad_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Age de di, tamo uru ereb naab luwen wõ yen ado, Jesus ĩ bret mumã fe di, idi Jesus nigin naig de kelein anĩ wogõ den. ");
INSERT INTO dad_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Idi fau enei nigin wogõ de mog, Jesus yogo idi atun ifar fen, irokenẽdin, “Wau inosiya ã ado ibodõf.” ");
INSERT INTO dad_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Idi baraũ mailef de fen, terẽ de fen, kumĩ den. ");
INSERT INTO dad_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Age dife di, Jesus idi irokenẽdin, “Ere nigin ã wauĩ morõ fef, ere nigin ã wauĩ bun kisi uru wõ yef? ");
INSERT INTO dad_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aya imau yeu ado feleg. Eĩ aya yug bagai! Kobũ wiyag fen, uleg. Baraũ ĩ aya bouwau ado, tuwau ado uleyagef gen sã, ĩ bou sã, tuwa sã.” ");
INSERT INTO dad_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jesus enei iro ken, ĩ ima ye ado ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Age fe di, idi waud kulĩya ado terẽya bunem, fau waud to momoi de di, Jesus idi to fiyẽdin, “Ã ereb yõya nẽ taka ein tau ado?” ");
INSERT INTO dad_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Idi gau yã tamal masak taka difenen, ");
INSERT INTO dad_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","age dife di, Jesus gau yale, meledin yon. ");
INSERT INTO dad_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jesus idi irokenẽdin, “Enei are, aya fau ã geid tabodon sain bun arokenein. Ereb ereb ganan, aya nigin Moses nẽ Lo bun, profet neid itotoya bun ado, Buk Sam bun ditoton anĩ ganan kisi falauf bagai.” ");
INSERT INTO dad_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Agef fen, Jesus idi Negur nẽ Itotoya keleĩ youf nigin, waud kã fenẽdin. 4624 ");
INSERT INTO dad_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ĩ idi irokenẽdin, “Negur nẽ Itotoya bun eig ye irok: Kristus ĩ fau darau yale fen, laa bun tamal naa towo bun mata kel fã youf, ");
INSERT INTO dad_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","age fe di, wau faleiya ado, mosor nigin weder tu keleya nẽ od anĩ, fau ĩ yana bunem teneub ganan bun, Jerusalem anenem gariya dino fen, wogõ de dilauf. ");
INSERT INTO dad_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ã enei ulegen nigin kurõ walaisi gouf. ");
INSERT INTO dad_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aya esel fen, neu Dei sur afouf yen anĩ, ã bun sur afouf, anĩ ere, taun anĩ bun ubodõgef uleg, ã megeir saa ilun tamal anim ifounneĩf.” ");
INSERT INTO dad_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sain Jesus idi gurif irou, Betani non dilen, an ĩ ima yales fen, el fiya ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ĩ idi el feid le fen, ĩ itornẽdi di, saa ilun irou iselen. ");
INSERT INTO dad_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Age fe di, idi ĩ yana dales fen, waud kulĩya odug ado, Jerusalem ke de dilen. ");
INSERT INTO dad_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Age de fen, idi tempel bun toku dibod ken, Negur yana dalesedig. ");
INSERT INTO dad_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gariya bun Od anĩ ibodon, Od anĩ Negur ado dibodon, Od anĩ Negur. ");
INSERT INTO dad_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Gariya bun ĩ Negur ado dibodon. ");
INSERT INTO dad_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ĩ bunem ereb ereb ganan inon, Od anĩ sã bun ereb inodin taka to ibodok. ");
INSERT INTO dad_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mata ĩ bun ibodon, mata anĩ tamo neid fula fiya. ");
INSERT INTO dad_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Fula fiya anĩ gugum bun lalan ifenek, anĩ ere, gugum ĩ fula fiya anĩ to kelein. ");
INSERT INTO dad_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tamo taka Negurem sur fe di, isin, ĩ yana Jon. ");
INSERT INTO dad_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ĩ fula fiya anĩ yaor fe, kurõ fesiyouf nigin isin, are tamo kayau ganan ĩ bunem momoi douf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ĩ anĩ fula fiya sã, ĩ fula fiya anĩ kurõ fesiyouf nigin isin. ");
INSERT INTO dad_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Fula fiya bagai yogo tamo kayau ganan lalan ifenẽdif, ĩ tenebur isin. ");
INSERT INTO dad_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ĩ teneub bun ibodon, are ĩ bunem teneub inon, anĩ ere, tamo kayau tenebur ein, ĩ to kelein. ");
INSERT INTO dad_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ĩ yogon bagai anidi bun isin, anĩ ere, yogon bagai anidi ĩ to daleyen. ");
INSERT INTO dad_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Anĩ ere, idi ĩ daleyen, ĩ yana nigin momoi den anidi bun, Negur idi Negur nẽ gere tar wowã douf nigin igirnẽdin. ");
INSERT INTO dad_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sina tama nẽ naud bunem to Negur gere tar wowã den, bouwa nẽ oroya bunem sã, tamo nẽ wau irõya buneg sã, anĩ ere, Negur yogo age fe di, wowã den. ");
INSERT INTO dad_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Od anĩ tamo wõ ye fen, ada atun ibodon. Ada yogon fula fiya medeĩya tailen, fula fiya medeĩya are Naal Tekelei Yogo Dogol nẽ, ĩ Tama bun tamal wau ifenẽya ado momoi barikã isin. ");
INSERT INTO dad_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ĩ nigin kurõ falaisi wogõ yen. Ĩ iweig fen, iron, “Ĩ enei nigin aya arokenein, ‘Taka ĩ aya dumeun isif, ĩ aya wal fiyaya, ere nigin, ĩ ket ibodon.’” ");
INSERT INTO dad_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","In wau ifenẽya barikã bunem, ada adok el fiya tale fen, anĩ teten el fiya musei talen. ");
INSERT INTO dad_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Are Moses bunem lo anĩ talen, anĩ ere, wau ifenẽya ado momoi anĩ, Jesus Kristus bunem isin. ");
INSERT INTO dad_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Taka nem Negur to bagai ilen, anĩ ere, Negur Naal Tekelei Yogo Dogol, ĩ Tama wagen ibod ken, ĩ nigin yaor fen. ");
INSERT INTO dad_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda tamo Jerusalem temeleid idim, pris tunĩ, Lewi nẽ ibor geid sur difedi di, Jon ĩ aim yeya anĩ to difiyẽ di, Jon ĩ eig ye kurõ fesin. ");
INSERT INTO dad_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ĩ wa fiya sã, kurõ falaisi, “Aya Kristus sã,” yen. ");
INSERT INTO dad_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Idi ĩ to difiyen, “Age fiyauf are, õ ai? Õ Eliya de?” Ĩ iron, “Aya ĩ sã.” Idi diron, “Õ Profet amã tari mafef anim de?” Ĩ iron, “Sã.” ");
INSERT INTO dad_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Age ye di, idi diron, “Õ ai bagai? Õ amã urokanamã len, idi amã sur difaman anidi gein ke ma malauf. Õ ogo nigin ere wof?” ");
INSERT INTO dad_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon profet Asaia nẽ od bun solof iron, “Aya anĩ, ait taka gerere tuan iweig irok, ‘Odug nẽ naab madur gouf.’” ");
INSERT INTO dad_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farisia tamo tunĩ sur difedin anidim ");
INSERT INTO dad_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","to difiyen, “Õ Kristus sãf, Eliya sãf, Profet anĩ sãf are, ere nigin naan ugunẽdif?” ");
INSERT INTO dad_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon aitedin yale iron, “Aya naan nem naan agunẽdif, anĩ ere, ã atun, taka ã keleĩ sã anĩ ifaref. ");
INSERT INTO dad_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ĩ anĩ aya dumeun dõ fiyaf, aya to biya nigin, in ye su nẽ malũ biru fediya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Enei ganan Betani oun Jordan naan sitakã, Jon naan igunẽdin nẽ an wõ yen. ");
INSERT INTO dad_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Naa taka di, Jon, Jesus wagen iyok isi mog, ile fen, iron, “Ulegef, Negur nẽ Sipsip Naal, ĩ tamo ganan neid mosor yaleledif! ");
INSERT INTO dad_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Enei nigin au fen, oron, ‘Taka ĩ aya dumeun isif, ĩ aya wal fiyaya, ere nigin, ĩ ket ibodon.’ ");
INSERT INTO dad_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aya yug ĩ keleĩ san, anĩ ere, aya asi, naan nem naan agunẽdif nẽ gariya are, Israel tamo kayau bun ĩ yaor fouf nigin.” ");
INSERT INTO dad_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Age ye fen, Jon enei kurõ feis iron, “Aya, Awa Uur saa ilun tamal kuburir gen isi, ĩ bun ibod mog, ailen. ");
INSERT INTO dad_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Aya ĩ to kelein, anĩ ere, taka ĩ, aya naan nem naan agunẽdiyouf nigin sur fiyan im irokanan, ‘Tamo anĩ, Awa Uur isi, ĩ bun ibod mog, ulouf, im Awa Uur Fateul nem naan igunẽdiyouf.’ ");
INSERT INTO dad_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aya ailen nigin kurõ afeis, ‘Eĩ Negur Naal,’ auf.” ");
INSERT INTO dad_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Naa taka di, Jon, in dõ fiya tar uru geid, baban an difaren. ");
INSERT INTO dad_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ĩ, Jesus isi ile di, ile fen, ĩ iron, “Ulegef, Negur nẽ Sipsip Naal!” ");
INSERT INTO dad_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Sain Jon nẽ dõ fiya tar uru enei karĩ de fen, idi Jesus dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus falei yel, idi ĩ dõ difiyẽ mog, ile fen, to fedin, “Ã ere oroyeik?” Idi diron, “Rabi (anĩ nẽ gariya, Tise), õ nain ubodõdig?” ");
INSERT INTO dad_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ĩ iron, “Umag fen, ulogouf.” Age ye di, idi dile, ĩ ibodõdig anĩ dile fen, naa anĩ bun, ĩ geid dibodon. Are aragau fo kilok age fiya. ");
INSERT INTO dad_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Endru, Simon Pita ne tura ĩ, idi uruwom ereb Jon wogõ yen anĩ karĩ de fen, Jesus dõ difiyen anĩ taka. ");
INSERT INTO dad_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ereb uruwa Endru age fen are, ĩ tura Simon imir ile fen, irokenen, “Amã Mesia (anĩ Kristus) fotou mafen.” ");
INSERT INTO dad_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Age ye fen, Endru, Pita Jesus wagen irou ile di, Jesus Pita lo fiye ken, iron, “Õ Simon, Jon naal. Õ yanã Sifas douf” (Sifas falei fiyauf are, Pita). ");
INSERT INTO dad_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Naa taka di, Jesus Galili ileya nigin kisif fen, Jesus Filip fotou fiye ken, irokenen, “Aya dõ wiya.” ");
INSERT INTO dad_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip ĩ, Endru Pita ado geid, Betsaida taun temeleid. ");
INSERT INTO dad_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip Nataniel fotou fiye ken, ĩ irokenen, “Amã ĩ nigin Moses nẽ Lo bun itoton ado profet idig ditoton, Jesus Nasaret tamal, Josef naal anĩ, fotou mafen.” ");
INSERT INTO dad_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel to fen, “Nasaret! Ereb biya taka, anenem wõya nigin kisi feleya de?” Filip iron, “Usi ule.” ");
INSERT INTO dad_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sain Jesus Nataniel non iyok isi mog, ile fen, ĩ nigin iron, “Eĩ Israel tamo bagai, ĩ bun ereb idegẽya taka sã.” ");
INSERT INTO dad_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel Jesus to fiyen, “Naig wo fen, õ aya keleĩ?” Jesus aiten yale iron, “Aya õ Filip iweignõya sã mog, aa fig farumen ubod mog, ailiyon.” ");
INSERT INTO dad_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Age ye di, Nataniel Jesus irokenen, “Rabi, õ Negur Naal, õ Israel neid King.” ");
INSERT INTO dad_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus iron, “Aya õ aa fig farumen ailiyon aul nigin, õ momoi wof. Õ anĩ wal fiya ereb ereb odug ulouf.” ");
INSERT INTO dad_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ĩ tobol fe iron, “Aya ã momoi bagai arokeneik, ã, saa bobog kã fele di, Negur nẽ engel Tamo Naal bun diselef disif dife mog, ulogouf.” ");
INSERT INTO dad_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Naa uru bure fele di, naa towo bun, tamo kayau ado bagu fiya, Galili distrik oun Kana fonõ wõ yen. Jesus sinag an ibodon. ");
INSERT INTO dad_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus in dõ fiya tar geid idig, tamo kayau ado bagu fiya bun diweignẽdin. ");
INSERT INTO dad_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sain wain sa kele di, sinam Jesus irokenen, “Idi wain taka sã.” ");
INSERT INTO dad_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus iron, “Kayau, õ ere nigin aya kababal wiyaf? Neu sain fau isiya sã.” ");
INSERT INTO dad_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesus sina, kabĩ tamo irokenẽdin, “Ereb ĩ irokeneĩf anĩ dõg, ago gouf.” ");
INSERT INTO dad_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nodin meein gulub sigis naan ifotũya nẽ difaren, are Juda neid tobonuneid bun imeid kulo fiya nigin, idi teke tekelei 100 lita age fiya naan iroudig. ");
INSERT INTO dad_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus kabĩ tamo irokenẽdin, “Gulub bun naan utinẽdig.” Age ye di, idi ditineĩd eweid gere fesedin. ");
INSERT INTO dad_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Age difele di, Jesus idi irokenẽdin, “Gama tunĩ lolob ge fen, sifa marau uroule kenẽg.” Age ye di, idi age difen. ");
INSERT INTO dad_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sifa marau naan wain falei fen anĩ yõ ilen. Ĩ wain anĩ nainenem be isin anĩ to kelein, anĩ ere, kabĩ tamo naan lolob difen idi kelein. Agef fen, sifa marau ĩ, kayau marau yerin iweignẽ, ile di, ");
INSERT INTO dad_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","irokenen, “Ganan idi wain biya anĩ ket dirousi di, tamo disif idi anĩ fatuk dõ mog, to biya gen anĩ dum dirousidig, anĩ ere, õ biya bagai urou ubodom anĩ, gama bagai urousif.” ");
INSERT INTO dad_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus memelik gariya inon are enei bun, oun Galili distrik Kana fonõ. Anĩ bun, ĩ yogon fula fiya medeĩya yaor fe di, yogon dõ fiya tar dogo neid momoiya ĩ bun dinon. ");
INSERT INTO dad_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Enei bure fele di, Jesus ĩ, sina, tura tar ado, yogon dõ diya tar geid, Kapenaum disilen. An naa musei to dibodon. ");
INSERT INTO dad_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda neid Pasa naa sain melsã mog, Jesus Jerusalem iselen. ");
INSERT INTO dad_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tempel modoũ bun, tamo, bulmakau, sipsip ado, kuburir na sur difeid fen, tunĩg tebol bun dibod ken, moni solo de mog, iledin. ");
INSERT INTO dad_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Anĩ ile fen, ĩ malũ nem wip inon, agef fen, tempel modoũ bun tamal, sipsip ado bulmakau ganan irudi di, serẽ dilelen, ĩ moni solo fiya tamo neid koin moni daũf firagagaũ fe fen, ĩ dogo neid tebol yale, falei feledin. ");
INSERT INTO dad_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Idi kuburir na sur difen anĩ irokenẽdin, “Eneidi ein waleledig, neu Dei nẽ fõ anĩ maket modoũ to unog!” ");
INSERT INTO dad_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dum in dõ fiya tar, eig ye itotoya anĩ nigin wedereid fokõ yen, “Ogon fõ nigin wau itenẽya anim nameun isainaf.” ");
INSERT INTO dad_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Age ye di, Juda tamo Jesus dirokenen, “Ere memelik anĩ ufelnamã di, enei ganan agof anĩ nigin õ igirĩya ado mauf?” ");
INSERT INTO dad_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus idi irokenẽdin, “Tempel enei narĩ weleg len, naa towo bun baban alesauf.” ");
INSERT INTO dad_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Juda tamo diron, “Tempel enei dinon are, foti-sigis yar yalen, anĩ õ naa towo bun walesauf de?” ");
INSERT INTO dad_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Anĩ ere, tempel ĩ wogõ yen are, yogo bouwa nigin. ");
INSERT INTO dad_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ĩ laa bunem kel fã yen anĩ bure fele di, in dõ fiya tar, ĩ iron anĩ, wedereid fokõ yen. Anĩ bunem, idi Negur nẽ Itotoya ado Jesus wogõ yen anĩ nigin momoi den. ");
INSERT INTO dad_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Gama ĩ Jerusalem oun sain Pasa Sifa bun ibod ken, tamo kayau musei memelik inodin anĩ dilen, anĩ bun ĩ yana nigin momoi den. ");
INSERT INTO dad_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Anĩ ere, Jesus ĩ yogo bagai, idi nigin to momoi yen, ere nigin, ĩ tamo ganan nigin keleĩ. ");
INSERT INTO dad_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesus ĩ, tamo takam taka nigin ĩ irokenẽya anĩ kisi feleya san, ere nigin, ereb tamo name bun ibodok, ĩ yogo keleĩ. ");
INSERT INTO dad_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisia tamo taka, yana Nikodemus ibodon, ĩ Juda uyu irouya neid kaunsel taka. ");
INSERT INTO dad_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ĩ bõ Jesus wagen isi fen, iron, “Rabi, amã keleĩ, õ tise Negur bunem usin. Ere nigin, taka nem Negur ĩ ado to ibodõf are, memelik õ unodif anĩ inodiya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus aiten yale iron, “Aya õ momoi bagai arokonok, taka nem Negur nẽ tano to ilouf, ĩ baban mata gõ fiyẽf dogol.” ");
INSERT INTO dad_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus Jesus to fiyen, “Tamo ĩ biyan anĩ, sina naig fe baban gõ fouf? Momoi bagai, ĩ sina namen baban ile di, gõ fiyẽya kisi feleya sã!” ");
INSERT INTO dad_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus solof iron, “Aya õ momoi bagai arokonok, taka ĩ, naan ado Awa Uurem mata to wõ youf are, ĩ Negur nẽ tano bun ileya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bouwam gõ fef are, bouwa nẽ, anĩ ere, Awa Uurem gõ fef are, uur nẽ. ");
INSERT INTO dad_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Õ neu od eig au wogõ auf bun, kisi to gurũ wouf, ‘Ã de baban mata wõ gouf.’ ");
INSERT INTO dad_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yau in oroya bun isi iledig. Õ ait dogol karĩ wodig, anĩ ere, õ nainenem isif be, nain be ilef, to keleĩ youf. Ganan idi Awa Uurem gogũ fedif are, age fiya bagai.” ");
INSERT INTO dad_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus Jesus to fiyen, “Are naig fe, agef wõ youf?” ");
INSERT INTO dad_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus iron, “Õ Israel neid tise, anĩ ere, õ enei to keleik de? ");
INSERT INTO dad_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aya õ momoi bagai arokonok, ereb amã keleĩ anĩ wogõ mauf, age ma fen, ereb amã mailen anĩ kurõ mafesif, anĩ ere, tamo kayau ã fau amã nemã od to walegef. ");
INSERT INTO dad_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aya ã ereb tenebur tamal nẽ anĩ wogõ ayeik, anĩ ere, ã to momoi gef, saa ilun tamal nẽ anĩ wogõ ayeĩfeg, naig ge momoi gouf? ");
INSERT INTO dad_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aibem taka saa ilun to iselen, Tamo Naal saa ilunem isin yogo dogol. ");
INSERT INTO dad_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses gerere tuan gogour yalesen, age fiya bagai, Tamo Naaleg age de dalesnẽf. ");
INSERT INTO dad_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Are ganan idi ĩ nigin momoi def, mata faimud ibodkeleya adouf nigin. ");
INSERT INTO dad_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Negur, tamo kayau teneub enei bun ganan nigin fatuk wau laa fen nigin, yogon Naal tekelei bagai anĩ ifenẽdin, are taka ĩ, ĩ nigin momoi youf are, to fõ yalauf, mata faimud ibodkeleya adouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Negur ĩ, yogon Naal teneub enei bun, tamo kayau es fediya nigin to sur fen, ĩ bunem tamo kayau teneub enei bun, kel gei fouf nigin sur fen. ");
INSERT INTO dad_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Taka, ĩ nigin momoi yef are, to es fiyek, anĩ ere, taka, ĩ nigin momoiya sã are, ĩ mogo es fiya bun ifaref, ere nigin, ĩ Negur Naal tekelei bagai yana nigin to momoi yen. ");
INSERT INTO dad_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Foi fiya eig fiya, fula fiya teneub enei bun mogo isin, anĩ ere, tamo idi dogo neid tobonuneid sane nigin, fula fiya ditor ken, gugum nigin waud laa fen. ");
INSERT INTO dad_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tamo idi sane age difef are, lalan to orodidig, ere nigin, dogo neid tobonuneid sane anĩ yaoreya kumĩ de fen, lalan namen to disiyouf. ");
INSERT INTO dad_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Anĩ ere, aib taka ĩ momoi bun age fef, lalan namen isidig, age fe di, ereb ĩ age fen are, Negur bunem age fen anĩ, yaor dilouf.” ");
INSERT INTO dad_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Anĩ bure fele di, Jesus in dõ fiya tar geid, Judia teneub bun dilen, an ĩ idi geid sain naal dibod ken, naan igunẽdin. ");
INSERT INTO dad_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Joneg Ainon Salim non naan igunẽdin, ere nigin, an naan musei bagai, anĩ nigin, tamo kayau naan igunẽdiyouf nigin toku disidig. ");
INSERT INTO dad_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Are Jon fau kalabus bun to dinenẽ mog.) ");
INSERT INTO dad_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jon nẽ dõ fiya tar tunĩ, Juda tamo taka geid, dogo neid tobonuneid dõ de fen, imeid kulo difedig anĩ nigin luwa diroun. ");
INSERT INTO dad_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Idi Jon wagen disi dirokenen, “Rabi, tamo õ uruwom Jordan naan sitakã ufareg fen, ĩ nigin kurõ weis uron, ĩ naan igunẽdif, age fe di, ganan ĩ bun dilef.” ");
INSERT INTO dad_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon solof iron, “Tamo ĩ, ereb saa ilun tamal ifenek anĩ dogol yalouf. ");
INSERT INTO dad_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ã aug aya oron anĩ sã kurõ walaisi gef, ‘Aya Kristus sã, anĩ ere, aya ĩ ket sur fiyan.’ ");
INSERT INTO dad_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mois kayau are, mois tamo nẽ. Mois nẽ mou ĩ, bagu fiya bun ifar fen, karĩ fiyek, ĩ mois tamo nẽ ait anĩ karĩ ye fen, kulĩya odug ado. Kulĩya are neu, anĩ gama kisi felef. ");
INSERT INTO dad_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ĩ yana odug isele di, aya yanau tenebur isilauf. ");
INSERT INTO dad_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Taka ĩ ilunem isif, ĩ ganan wal fiya, taka ĩ tenebur tamal are, tenebur nẽ, anĩ nigin, tenebur nẽ anĩ wogõ yedig. Taka ĩ saa ilunem isif, ĩ ganan wal fiya. ");
INSERT INTO dad_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ereb ĩ ilen ado karĩ yen anĩ, kurõ falaisif, anĩ ere, yogon od taka nem to yalef. ");
INSERT INTO dad_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Taka ĩ yogon od yalen anim, Negur ĩ momoi bagai ye fen, anĩ megeir ifenen. ");
INSERT INTO dad_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Taka ĩ Negurem sur fiyen are, ĩ Negur nẽ od wogõ yef, ere nigin, Negur ĩ Awa Uur idikeleya sã ifenek. ");
INSERT INTO dad_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tama ĩ Naal nigin wau laaf fen, ereb ereb ganan ĩ ima bun inon. ");
INSERT INTO dad_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aib ĩ Naal nigin momoi yef are, mata gai ibodkeleya ado, taka ĩ Naal nigin itorok are, ĩ mata to ilouf, Negur nẽ didi ĩ bun ibodok.” ");
INSERT INTO dad_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesus Jon wal fiye ken, in dõ fiya tar musei geif naan igunẽdif ya anĩ, Farisia tamo karĩ den. ");
INSERT INTO dad_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Anĩ ere, momoi bagai Jesusem naan igunẽdiya sã, are in dõ fiya tar anidim. ");
INSERT INTO dad_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sain Odug enei kelei ken, ĩ Judia distrik itor ken, baban Galili kel ilen. ");
INSERT INTO dad_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Gama ĩ Samaria atu ilauf. ");
INSERT INTO dad_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Anĩ nigin, ĩ Sikar taun oun Samaria, Jakop, ne naal Josef teneub kulu ifenen non, iyok isin. ");
INSERT INTO dad_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","An Jakop nẽ naan ifotokon tutuwõ ibodon, Jesus naab meluk iyok isi, tuwa yu kele di, naan ifotokon tutuwõ sirin ibodon. Are mogo gaa atun age fiya. ");
INSERT INTO dad_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Agef mog, Samaria kayau taka naan ifotũya nigin isi di, Jesus kayau irokenen, “Aya naan tau wana di, ãf.” ");
INSERT INTO dad_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(In dõ fiya tar, taun saaf na yaleya nigin dilelen.) ");
INSERT INTO dad_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria kayau Jesus irokenen, “Õ Juda tamo di, aya Samaria kayau. Naig fe di, ayam õ naan afon, wãf nigin to wiyaf?” (Juda tamo kayau idi, Samaria tamo kayau geid to uyu katõ difedig.) ");
INSERT INTO dad_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus kayau irokenen, “Õ safina ege luwa Negur ifonok ado, aibem naan nigin to yok anĩ keleim are, õ ĩ to wiyẽ di, mata ifenẽya nẽ naan anĩ ifonom.” ");
INSERT INTO dad_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kayau iron, “Odug, õ ifotũya nẽ safina sã, naan ĩ ilon bagai. Õ mata ifenẽya nẽ naan are nain walouf? ");
INSERT INTO dad_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tamamã Jakop naan ifotok kanama ken, ĩ yogog gere tar ado gaareg anĩ bun don, õ ĩ wal fiya de?” ");
INSERT INTO dad_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus kayau aiten yale iron, “Ganan naan enei doko, idi baban naan ail fediyouf. ");
INSERT INTO dad_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Anĩ ere, taka ĩ aya naan anĩ afenẽ di, yoko, ĩ baban to bagai naan ail fouf. Naan aya ĩ afenek, warur naan ĩ namen faimud ulo ulõ yef yenẽ di, anim mata gai ibodkalauf.” ");
INSERT INTO dad_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kayau Jesus irokenen, “Odug, naan enei wanauf, ago di, aya baban naan ail to fiya fen, naan enei bun ifotũya nigin toku ein to kelauf.” ");
INSERT INTO dad_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ĩ kayau irokenen, “Ule, ogon tamo uroken ken, kel usig.” ");
INSERT INTO dad_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kayau iron, “Aya tamo sã.” Jesus kayau irokenen, “Õ tamo sã wof are, õ tutuk urok. ");
INSERT INTO dad_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ere nigin, õ mogo tamo faif adon, tamo gama õ ado are, ogon aiwã sã. Õ ogo urom, are momoi bagai.” ");
INSERT INTO dad_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kayau iron, “Odug, aya õ ailiyok, õ profet taka. ");
INSERT INTO dad_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Amã tamamã tar, arei enei bun Negur yana dalesedig, anĩ ere, Juda ã urõgedig, Negur yana yaleseya modoũ are oun Jerusalem dogol.” ");
INSERT INTO dad_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus kayau irokenen, “Kayau, aya momoi wiya, sain fau isi di, baban arei enei bun ado, Jerusalemeg an, Dei yana to walesagauf. ");
INSERT INTO dad_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria ã, ereb ã keleĩ sã anĩ yana walesegedig, amã ereb amã keleĩ anĩ yana malesedig, ere nigin, tamo kayau kel yaleya nẽ are, Juda ibor bun tamal. ");
INSERT INTO dad_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sain isiyouf are, gama mogo yeir isil, Negur momoi bagai yana dalesedig are, uur ado momoi bunem Dei yana dalesauf, ere nigin, idi age fediya anĩ Dei ĩ imirnẽdif. ");
INSERT INTO dad_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Negur ĩ uur, anĩ nigin, ĩ yana dalesedig idi, uur ado momoi bunem, yana dalesauf.” ");
INSERT INTO dad_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kayau iron, “Aya keleĩ, Mesia (Kristus dedig) fau isif. Ĩ isiyouf sain bun, ereb ereb ganan faded famãf.” ");
INSERT INTO dad_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Age ye di, Jesus kayau irokenen, “Aya inim yeir od ayok.” ");
INSERT INTO dad_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Agef mog bagai, in dõ fiya tar keku de disi, Jesus kayau anĩ ado od de mog, dileid fen, terẽ den. Anĩ ere, taka nem to, to fiyen, “Õ ere oroyok?” be “Õ ere nigin ĩ ado od gef?” ");
INSERT INTO dad_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kayau, ne naan gulub itor yen, taun kel ile, tamo kayau irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Umag, tamo taka, aya ereb ereb ganan age afef asin irokanal anĩ uleg. Ĩ anĩ Kristus be.” ");
INSERT INTO dad_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Idi taun ditor disi, Jesus garan dilen. ");
INSERT INTO dad_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Age de mog, in dõ fiya tar Jesus totol bagai dirokenen, “Rabi, ereb taka wõ.” ");
INSERT INTO dad_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Anĩ ere, ĩ idi irokenẽdin, “Aya saaf ã keleĩ sã anĩ ãf nigin ado.” ");
INSERT INTO dad_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Age ye di, in dõ fiya tar abob dirokenen, “Taka nem mogo saaf irousi ifenem de?” ");
INSERT INTO dad_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus iron, “Neu saaf are, aya sur fiyan in oroya dõ afe fen, in kabĩ bure afalauf anĩ. ");
INSERT INTO dad_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ã eig ge to urõgedig de, ‘Ogõ fo bure fele di, kusu fiya sain wõ youf’? Aya ã arokeneik, meleĩ fara weleg fen, kabĩ onoudi ulogouf! Idi mogo kusu fiya nẽ mayo bure felen. ");
INSERT INTO dad_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kusu fiya tamo ĩ gama mala solo yalef, ĩ gama mata faimud ibodkeleya nẽ biya kususu fef, anĩ bun, itenẽya tamo ado kusu fiya tamo waud al fouf. ");
INSERT INTO dad_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Anĩ nigin, od enei momoi bagai, ‘Tamo takam itenẽdig, tamo takam kusu fedig.’ ");
INSERT INTO dad_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aya, ã kabĩ to walegen nẽ an, kusu fiya nigin sur ayein. Tunim kabĩ totol dalen, anĩ ã idi neid maab mala anĩ kusu gen.” ");
INSERT INTO dad_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria tamo kayau, taun anĩ bun temeleid musei, ĩ nigin momoi den, ere nigin, kayau anĩ eig ye kurõ fesin, “Ĩ ereb ereb ganan age afef asin anĩ irokanal.” ");
INSERT INTO dad_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Anĩ nigin, Samaria tamo kayau ĩ gein disi, ĩ idi geid dibodõf nigin totol bagai dirokenẽ di, ĩ naa uru, idi geid dibodon. ");
INSERT INTO dad_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","In od bunem, musei fau fau momoi den. ");
INSERT INTO dad_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Idi kayau anĩ dirokenen, “Amã ogon od bun dogol to momoi mauf, ere nigin, amã mug karĩ mau fen, amã keleĩ, tamo enei momoi bagai teneub ganan enei nẽ Isennẽya.” ");
INSERT INTO dad_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Naa uru bure fele di, Jesus Galili ilen. ");
INSERT INTO dad_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesus ĩ yogo iron, ‘Profet taka, yogon fõ gariyan, ĩ yana sã.’ ");
INSERT INTO dad_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sain ĩ Galili wõ yen, Galili tamo kayau ĩ daleyen. Idi Jerusalem Pasa Sifa bun, ĩ ereb ereb age fen ganan dilen, ere nigin, idig an weim difaren. ");
INSERT INTO dad_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ĩ baban Galili distrik oun Kana fonõ ki fen, kulu an ĩ naan wain falei felen. Sain anĩ bun, king nẽ kabĩ mudur taka nẽ naal Kapenaum taun an dagi yenen. ");
INSERT INTO dad_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tamo enei, Jesus Judia distrik tamal Galili isin anĩ karĩ ye fen, ĩ Jesus gein ile, ne naal laa melsã yenen anĩ, isi el fiyẽf nigin igonen. ");
INSERT INTO dad_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus ĩ irokenen, “Ã memelik uris ado anĩ to ulogouf are, ã to bagai momoi gouf.” ");
INSERT INTO dad_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","King nẽ kabĩ mudur iron, “Odug, neu kesu fau laa fiya sã mog, õ usiyouf.” ");
INSERT INTO dad_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus ĩ irokenen, “Õ wadã ule. Õ naal fau mata ibodõf.” Tamo anĩ, Jesus nẽ od momoi ye fen, ilen. ");
INSERT INTO dad_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ĩ fau naab iyok ile mog, yogon ferfer ĩ fotou difiye ken, yogon kesu mata ibodok anĩ wogõ difiyen. ");
INSERT INTO dad_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Age de di, ĩ gaa mala ganĩ bun, ne naal dagi karikan anĩ to fiyẽdin. Idi ĩ dirokenen, “Bouwa uruwa, nor wan kilok aragau folõ fiye kelen.” ");
INSERT INTO dad_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Age de di, tama ĩ kelein, sain anĩ bun bagai, Jesus irokenen, “Õ naal fau mata ibodõf.” Anĩ nigin, ĩ yogo, ne fõ tura tar ganan geid, momoi den. ");
INSERT INTO dad_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus Judia distrik bun tamalem Galili isi fen, memelik inon, are eneim anĩ uru. ");
INSERT INTO dad_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Dum, Jesus Juda neid sifa bun Jerusalem iselen. ");
INSERT INTO dad_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem an Sipsip Bobog non, naan kolili fiya taka Hibru od nem Betesta dedig ibodok, naan kolili fiya anĩ sirin meein torem fõ faif dinodin dibodok. ");
INSERT INTO dad_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","An dagi tamo kayau musei denenãdig, meleid ifofakeleya, yeid kirorõya, bouweid ilolaisidin. ");
INSERT INTO dad_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Difaren nẽ an, tamo taka dagi ado ibodok ile, teti-eit yar yalen. ");
INSERT INTO dad_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sain Jesus ĩ an yen mog, ile fen, ĩ sain meluk dagi ado an yenen anĩ kelei ken, ĩ to fiyen, “Õ biya leya oroyok de?” ");
INSERT INTO dad_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dagi tamo iron, “Odug, sain naan moyõ fe di, taka nem isenna di, naanũ isileya to ibodok. Aya asilauf au mog, taka ketem uyu wal fiya fen, isiledig.” ");
INSERT INTO dad_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Age ye di, Jesus ĩ irokenen, “Fã wo! Ogon gogoũ wenẽdig anĩ wale fen, uyok ule.” ");
INSERT INTO dad_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Age ye di, tamo kaisã bagai dagi sa kele di, ĩ yogon gogoũ yale fen, iyok ilen. Anĩ wõ yen naa are, Sabat naa. ");
INSERT INTO dad_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Anĩ nigin, Juda tamo idi, tamo dagi sa kelen anĩ dirokenen, “Naa eĩ Sabat naa. Õ ogon gogoũ irouya nigin lo katũ yef.” ");
INSERT INTO dad_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Anĩ ere, ĩ aitedin yale iron, “Tamo ĩ el fiyal anim, ‘Ogon gogoũ wenẽdig anĩ wale fen, uyok ule,’ fiyal.” ");
INSERT INTO dad_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Anĩ nigin, idi ĩ to difiyen, “Tamo enei nanim, ‘Ogon gogoũ wale fen, uyok ule,’ yom?” ");
INSERT INTO dad_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tamo el fiyen, ĩ aib ya anĩ nene yelen, ere nigin, Jesus ĩ an guru difen anĩ namen iwaikelen. ");
INSERT INTO dad_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dum Jesus tamo anĩ tempel bun fotou fiye ken, irokenen, “Ulef, õ baban biya lel. Baban mosor to uno, are ereb sane bagai uruwa nẽ wal fiya anĩ, õ bun to wõ youf nigin.” ");
INSERT INTO dad_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tamo are ile, Juda tamo irokenẽdin, ‘Aya el fiyal tamo are Jesus,’ yen. ");
INSERT INTO dad_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jesus Sabat naa bun enei age fedig nigin, Juda tamo idi ĩ morõ difenen. ");
INSERT INTO dad_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus idi irokenẽdin, “Neu Dei ĩ faimud kabĩ yalef isi, gama naa enei buneg kabĩ yalef, anĩ nigin, ayag kabĩ alef.” ");
INSERT INTO dad_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesus age yen nigin, Juda tamo idi ĩ dukesiyouf nigin kabĩ totol dalen, Sabat naa nẽ lo wal fiya bun nigin dogol sã, ĩ Negur nigineg neu Dei ye fen, aya Negur ado tekelei yen nigin. ");
INSERT INTO dad_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Anĩ nigin, Jesus od enei idi irokenẽdin, “Aya ã momoi bagai arokeneik, Naal ĩ yogon oroyam ereb taka to age fouf, ĩ Tama age fef anĩ dogol ile fen, ĩg age fedig, ere nigin, ereb Tama age fef are Naaleg age fouf. ");
INSERT INTO dad_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tama ĩ Naal nigin wau laaf fen, ĩ ereb ereb age fedig anĩ ganan ifelnek. Ĩ ereb ereb enei wal fiya Naal ifelnẽf, anĩ bun ã terẽ gouf. ");
INSERT INTO dad_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tama ĩ laa turĩ feid fen, mata ifenẽdidig, age fiya bagai, Naal ĩg aib ĩ orof anĩ mata ifenẽdig. ");
INSERT INTO dad_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tama ĩ aib taka to es fiyẽf, anĩ ere, ĩ es fiya kabĩ ganan Naal bun inon, ");
INSERT INTO dad_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","are tamo kayau ganan idi Temeid yana dalesedig gen, Naal nigineg yana dalesauf nigin ĩ age fen. Taka ĩ Naal yana to yalesef, ĩ Tamam Naal sur fiyen anĩ yana to yalesef. ");
INSERT INTO dad_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Aya ã momoi bagai arokeneik, taka ĩ neu od karĩ ye fen, aya sur fiyan ĩ nigin momoi yef, ĩ mata faimud ibodkeleya ado fen, es fiya bun to ilauf. Ĩ laa bun tamal ibal fen, mata bun ilen. ");
INSERT INTO dad_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aya ã momoi bagai arokeneik, sain fau isif, are mogo yeir isil, laa tamo Negur Naal nẽ ait karĩ douf, idi karĩ def anidi mata dibodõf. ");
INSERT INTO dad_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tama ĩ yogo bun mata ado, age fiya bagai, ĩ mata de anĩ Naaleg adouf nigin ifenen. ");
INSERT INTO dad_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Agef fen, Tama ĩ Naal es fediyouf nigin megeir ifenen, ere nigin, ĩ Tamo Naal. ");
INSERT INTO dad_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Eig fiya bun to terẽ gouf, sain fau isif, ganan nedi matmat bun dibodok idi, yogon ait karĩ de fen, ");
INSERT INTO dad_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ulolõ desiyouf, idi biya age difen anidi mata dibodõf nigin fafã douf, idi sane age difen anidi es fedi di, hel bun dilauf nigin fafã douf. ");
INSERT INTO dad_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aya neu oroyam, ereb taka to naig be afouf. Aya karĩ auf kilei bagai, aya es afef, neu es fiya are madur bagai, ere nigin, aya yug nigin au fen, to age afedig, anĩ ere, aya sur fiyan ĩ wau al fouf nigin au fen, age afedig. ");
INSERT INTO dad_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Aya yug nigin aya mugu wogõ auf are, neu wogõya are, momoi be sã be anĩ yaor sã. ");
INSERT INTO dad_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Taka ĩ aya nigin kurõ fesidig, agef fen, aya keleĩ, ĩ aya nigin kurõ fesif are momoi. ");
INSERT INTO dad_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Ã Jon garan tamo tunĩ sur wedige di, ĩ aya nigin momoi od anĩ kurõ falaisi irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aya tamom aya nigin kurõ fesif anĩ to aroudig, anĩ ere, aya ã isenneĩf au fen, od anĩ wogõ aun. ");
INSERT INTO dad_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ĩ lam futur fen, lalan ifenen, age fe di, ã sain tobega bagai waleg fen, in lalan nigin wauĩ al fen. ");
INSERT INTO dad_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Neu kurõ fesiya anĩ Jon nẽ wal fiya, ere nigin, kabĩ aya bure afalauf nigin Dei ifanan alef anim, Dei ĩ aya sur fiyan anĩ kurõ fesif. ");
INSERT INTO dad_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dei ĩ sur fiyan ĩ yogo, aya nigin kurõ fesin. Ã ĩ ait to karĩ gen, nog to ulegen, ");
INSERT INTO dad_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","in odeg ã bun to ibodok, ere nigin, ã sur fiyen anĩ ĩ nigin to momoi gedig. ");
INSERT INTO dad_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ã Negur nẽ Itotoya keleĩ youf nigin kabĩ totol walegedig, ere nigin, ã kisi gef, anĩ bunem amã mata faimud ibodkeleya malef ge fen, ago gedig. Negur nẽ Itotoya enei, aya nigin kurõ fesif. ");
INSERT INTO dad_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Anĩ ere, ã mata yaleya nigin, aya wageun isiya utorõgedig. ");
INSERT INTO dad_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Aya tamom yanau dalesauf nigin to orok, ");
INSERT INTO dad_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","anĩ ere, aya ã nigin keleĩ. Aya keleĩ, ã wauĩ bun Negur nigin wauĩ laa fiya to ibodok. ");
INSERT INTO dad_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aya neu Dei yana bunem asin, anĩ ã aya to waleyagen, anĩ ere, aibem taka yogo yana bunem isif are, ã walogouf. ");
INSERT INTO dad_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ã abob yana yaleseya anĩ oroyei ken, yana yaleseya Negur Tekelei bunem isif anĩ to totol unog walogouf are, ã naig ge momoi gouf? ");
INSERT INTO dad_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Anĩ ere, ã ayam Dei mala bun ãgenei sane anĩ kurõ afesiyouf ge fen to kisig. Ãgenei sane kurõ fesiya are Moses, ĩ bun ãgenei wauĩ iseya unogedig anĩ. ");
INSERT INTO dad_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ã Moses nigin momoi gem are, aya nigineg momoi gem, ere nigin, im aya nigin itoton. ");
INSERT INTO dad_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Anĩ ere, ereb ĩ itoton anĩ to momoi gef nigin, naig ge fen, aya wogõ auf enei nigineg momoi gouf?” ");
INSERT INTO dad_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Enei dumen, Jesus Galili Maaĩ ub sitakã ibal ilen (Galili Maaĩ anĩ, yana taka Taiberias Maaĩ). ");
INSERT INTO dad_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Age fe di, tamo kayau musei ĩ dõ difiyen, ere nigin, ĩ dagi tamo kayau bun memelik ino di, meledim dilen. ");
INSERT INTO dad_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Agef fen, Jesus arein isel, yogon dõ fiya tar geid dibodon. ");
INSERT INTO dad_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juda neid sifa inoya Pasa naa melsã mog. ");
INSERT INTO dad_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sain Jesus mala irakel, tamo kayau musei ĩ garan disi mog, ileid fen, ĩ Filip irokenen, “Ada tamo kayau eneidi dãf nigin, bret nain na talouf?” ");
INSERT INTO dad_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ĩ Filip kisi fiye ken, enei to fen, ere nigin, Jesus ĩ ereb age fouf nigin are ĩ keleĩ. ");
INSERT INTO dad_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip Jesus aiten yalen, “Ogõ eit nẽ mala anim, idi mugu mugu nigin bret na talouf are, tunĩ to dõ dilouf.” ");
INSERT INTO dad_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","In dõ fiya tamo taka Endru, Simon Pita nẽ tura anĩ Jesus irokenen, ");
INSERT INTO dad_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kesu taka yeir baali bret faif gau uru ado, anim musei ganan enei tau kisi falauf?” ");
INSERT INTO dad_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus iron, “Tamo kayau urokenẽdig len, dibod.” Modoũ anĩ bun fisir musei ado, an tamo dibodadan faif tausen age fiya. ");
INSERT INTO dad_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Gama Jesus bret anĩ geif, Negur de fiye ken, idi dibodadan neid oroya kilei, anĩ gadõ fedin. Ĩ gau buneg de age fen. ");
INSERT INTO dad_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Idi ganan dõ kisi fele di, Jesus in dõ fiya tar irokenẽdin, “Tunĩ ditoraram anĩ kurug. To sekil fiyauf.” ");
INSERT INTO dad_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Anĩ nigin, baali bret faif anĩ idi dokon, masak tunĩ ifaredin anĩ kuru dife di, karam tuwelf isokosedin. ");
INSERT INTO dad_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tamo kayau memelik inon anĩ dile fen, idi diron, “Momoi bagai, enei are Profet teneub enei bun isiyouf ya anĩ.” ");
INSERT INTO dad_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Idi disi, Jesus king ibodõf nigin nugo difiyẽf ya anĩ, ĩ kelei ken, baban mugu arein kel iselen. ");
INSERT INTO dad_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Gugumek isi di, yogon dõ fiya tar daliyoun disilen. ");
INSERT INTO dad_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","An idi waag taka bun sosõ de daliyou dibal fen, Kapenaum luwe dile mog, mogo gugumen, anĩ Jesus fau idi garan to isin. ");
INSERT INTO dad_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yau totol isi di, maaĩ moloun wĩ yen. ");
INSERT INTO dad_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Idi waag sur de dira ken, ful de dile, faif kilomita be, sigis kilomita age fiya mog, Jesus naan tetenem waag garan iyok isi mog, dile fen, kumĩ tererẽ den. ");
INSERT INTO dad_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Anĩ ere, ĩ idi irokenẽdin, “Are ayam, to kumĩ wog.” ");
INSERT INTO dad_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Age ye di, ĩ waag bun dalesnẽf nigin waud yenen, kaisã bagai, idi dilauf nẽ waud iron ub anĩ bun, waag goro fen. ");
INSERT INTO dad_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Naa taka di, tamo kayau daliyou ub sitakã difaren idi kelein, waag tekelei dogol an ibodon, anĩ Jesus in dõ fiya tar geid to sõ den, idi dogo dogol dilen. ");
INSERT INTO dad_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Waag tunĩ Taiberias temeleid, Odug, bret Negur de fiye ken, tamo kayau ifeneĩd don modoũ anĩ non, goro difen. ");
INSERT INTO dad_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tamo kayau, Jesus in dõ fiya tar geid an to dibodon anĩ kelei ken, idi waag sosõ de fen, Jesus dimirnẽf nigin Kapenaum dilen. ");
INSERT INTO dad_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sain tamo kayau idi, daliyou sitakã Jesus fotou dife fen, idi ĩ to difiyen, “Rabi, ere sain õ ein usin?” ");
INSERT INTO dad_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus aitedin yalen, “Aya ã momoi bagai arokeneik, ã aya umirnagef, ã memelik ulegen nigin sã, anĩ ere, ã bret ifoutneĩ di, wõg eweĩ gere fen nigin. ");
INSERT INTO dad_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Saaf sane ledig anĩ nigin to kabĩ waleg, anĩ ere, saaf to sane le fen, mata faimud ibodkeleya bun ibodõdig anĩ nigin kabĩ waleg, are Tamo Naalem ifeneĩf. Ĩ dogol Tama Negurem igirne ken, yoya nẽ megeir ganan ifenen.” ");
INSERT INTO dad_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Age ye di, idi ĩ to difiyen, “Amã Negur nẽ kabĩ malouf nigin, naig bagai mafouf?” ");
INSERT INTO dad_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus solof iron, “Negur nẽ kabĩ are yeir, Negurem sur fiyen ĩ nigin momoi gouf.” ");
INSERT INTO dad_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Anĩ nigin, idi ĩ to difiyen, “Ere memelik bun uris wanamã di, mail fen, õ momoi mayõf? Ere anĩ õ unouf? ");
INSERT INTO dad_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Amã nemã tubumã tar gerere tuan mana don, Negur nẽ Itotoya bun eig ye yenek kilei, ‘Ĩ idi saa ilun tamal bret dãf nigin ifenẽdin.’ ” ");
INSERT INTO dad_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus idi irokenẽdin, “Aya ã momoi bagai arokeneik, Moses im bret saa ilun tamal to ifenein, anĩ ere, neu Dei ĩ yogo bret kaũ bagai saa ilun tamal ifeneik. ");
INSERT INTO dad_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ere nigin, Negur nẽ bret saa ilun tamal isi fen, teneub enei mata ifenek.” ");
INSERT INTO dad_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Idi diron, “Odug, gama ilauf enei bun bret anĩ wanamã.” ");
INSERT INTO dad_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus idi irokenẽdin, “Aya anĩ mata nẽ bret. Taka ĩ aya bun isif, to bagai naũ ilauf, taka ĩ aya nigin momoi yef, to bagai naan ail fouf. ");
INSERT INTO dad_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Anĩ ere, aya ã arokenein kilei, ã mogo uleyagen, anĩ fau to momoi gef. ");
INSERT INTO dad_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Idi ganan Deim ifanaf, aya bun disiyouf, taka ĩ aya bun isif, aya to bagai aruwauf. ");
INSERT INTO dad_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aya saa ilun tamal asin, aya neu oroya dõ afouf nigin sã, anĩ ere, aya sur fiyan nẽ oroya dõ afouf nigin. ");
INSERT INTO dad_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aya sur fiyan nẽ oroya are yeir, idi ganan ĩ ifanan taka to folõ afalauf, anĩ ere, aya idikeleya naa bun alesnẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Neu Dei nẽ oroya anĩ, taka ĩ Naal ile fen, ĩ nigin momoi yef, mata faimud ibodkeleya yalouf, idikeleya naa bun aya alesnẽf.” ");
INSERT INTO dad_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Od enei Juda tamo karĩ de fen, ĩ nigin nauseir den, ere nigin, Jesus iron, “Aya bret saa ilun tamal asin.” ");
INSERT INTO dad_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Idi diron, “Eĩ Jesus sã de? Josef naal, in sina tama ado ada keleĩ. Naig fe di, ĩ irok, ‘Aya saa ilun tamal asin’?” ");
INSERT INTO dad_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus solof iron, “Ã aug to nauseir gouf. ");
INSERT INTO dad_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taka yogon oroyam, aya wageun isiya kisi feleya sã, anĩ ere, Dei aya sur fiyan inim, ĩ namen kabĩ yale fen, aya garan irou isiyouf. Age fe di, idikeleya naa bun, aya ĩ alesnẽf. ");
INSERT INTO dad_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profet neid itotoya bun eig ye yenek, ‘Idi ganan Negurem ifelnẽdiyouf.’ Taka ĩ Dei karĩ fiye ken, ĩ bun keleĩ yalef, aya bun isidig. ");
INSERT INTO dad_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Taka nem Dei to ilen, Negur bunem isin im dogol. Ĩ yogo dogol Dei ilen. ");
INSERT INTO dad_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aya ã momoi bagai arokeneik, taka ĩ momoi yef, mata faimud ibodkeleya ado. ");
INSERT INTO dad_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aya mata nẽ bret. ");
INSERT INTO dad_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ãgenei tubuĩ tar gerere tuan mana don, anĩ ere, idi gare den. ");
INSERT INTO dad_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Anĩ ere, bret enei saa ilun tamal isif, are tamo yãf, to laa fouf. ");
INSERT INTO dad_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aya mata ibodõya bret, are saa ilun tamalem isin. Taka ĩ bret enei yoko, ĩ mata faimud ibodõf. Bret enei aya bouwau, are teneub ganan bun, tamo kayau mata dalouf nigin afenẽdiyouf.” ");
INSERT INTO dad_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Age ye di, Juda tamo dogo dogol fatuk bagai luwa diroun, “Naig fe fen, tamo enei yogon bouwa ifanada tãf?” ");
INSERT INTO dad_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus idi irokenẽdin, “Aya ã momoi bagai arokeneik, ã Tamo Naal nẽ bouwa to wãgauf, in naud to wãgauf are, ã namein mata to ibodok. ");
INSERT INTO dad_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Taka ĩ neu bouwau yokon, neu naudou yoko, ĩ mata faimud ibodkeleya ado, anĩ aya fau idikeleya naa bun alesnẽf. ");
INSERT INTO dad_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ere nigin, neu bouwau are saaf bagai, neu naudou are naan bagai. ");
INSERT INTO dad_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Taka ĩ neu bouwau yokon, neu naudou yoko, ĩ aya nameun ibodok, aya ĩ namen abodok. ");
INSERT INTO dad_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mata ibodõya Dei aya sur fiya di, aya Dei bunem mata abodok gen, taka ĩ aya yõyaf, aya bunem mata ibodõf. ");
INSERT INTO dad_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bret enei saa ilun tamal isin. Ãgenei tubuĩ tar mana don are gare desin, anĩ ere, taka ĩ bret enei yoko, faimud mata ibodkalauf.” ");
INSERT INTO dad_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ĩ od enei Kapenaum taun an, Juda neid uub fõ bun ifelneĩd fen, wogõ yen. ");
INSERT INTO dad_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Od enei karĩ de fen, in dõ fiya tar musei diron, “Ifelnadaf eĩ totol bagai. Aim anĩ keleĩ youf?” ");
INSERT INTO dad_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","In dõ fiya tar od enei nigin nauseir de di, Jesus anĩ kelei ken, idi irokenẽdin, “Od enei ã morõ ifeneik de? ");
INSERT INTO dad_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ba, Tamo Naal ĩ ibodon nẽ kel isel mog ulogouf are, ã ere kisi gouf? ");
INSERT INTO dad_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Awa Uurem mata ifenẽdig, bouwa are gorõ. Od aya wogõ ayein are Uur, od anĩ mata ifenẽdig. ");
INSERT INTO dad_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Anĩ ere, ã tunĩ momoiya sã.” Ere nigin, Jesus idi nigin gariya bun kelein, aiyaim ĩ nigin to momoi den, aim ĩ nigin kiwai inouf. ");
INSERT INTO dad_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ĩ od tobol fe iron, “Anĩ nigin, aya od enei arokenein, Dei ĩ nigin wau to yalouf, ĩ aya bun isiya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Od enei bunem, in dõ fiya tar musei keku den, baban Jesus to dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesus in dõ fiya tar tuwelf to fedin, “Ãg aya utornag ulagauf de?” ");
INSERT INTO dad_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Pita solof iron, “Odug, amã ai bun malauf? Õ mata faimud ibodkeleya nẽ od ado. ");
INSERT INTO dad_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Amã momoi mau fen, keleĩ, õ anĩ Negur nẽ Fateul.” ");
INSERT INTO dad_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Age ye di, Jesus idi irokenẽdin, “Tuwelf ã ayam to agirnein de? Anĩ ere, ã atun taka are Satan.” ");
INSERT INTO dad_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ĩ Judas, Simon Iskariot naal nigin kisif fen, iron. Idi tuwelf anĩ taka Judas, fau dum Jesus kiwai ifenen.) ");
INSERT INTO dad_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Enei dumen, Jesus Galili an iyon, Judia distrik so fiyen, ere nigin, an Juda tamo ĩ dukesiyouf nigin ololo difen. ");
INSERT INTO dad_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Anĩ ere, Juda neid Salafat nẽ Sifa naa melsã di, ");
INSERT INTO dad_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesus tura tarem ĩ dirokenen, “Õ ein utor ken, Judia ulauf, ago di, ogon dõ fiya tar, memelik uno di, dilouf. ");
INSERT INTO dad_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tamo taka ĩ, tamo kayau meleid bun mala yaor wõ you fenẽ, ĩ iminẽyan kabĩ to yaledig. Õ eneidi agof, õ ogo tamo kayau ganan ufelnẽdiyouf.” ");
INSERT INTO dad_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ĩ yogon tura tar bagaig, ĩ nigin to momoi den. ");
INSERT INTO dad_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Anĩ nigin, Jesus idi irokenẽdin, “Aya neu sain bagai fau isiya sã, ã nigin sain ganan kisi feleya bagai. ");
INSERT INTO dad_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tenebur tamo kayau idi, ã to kiwai difeneik, aya nigin kiwai, ere nigin, ereb sane age difef anĩ kurõ afesidig. ");
INSERT INTO dad_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ã Sifa bun ulagauf, aya nigin fau Sifa enei bun to eselauf, ere nigin, neu sain bagai fau isiya sã.” ");
INSERT INTO dad_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesus od enei wogõ yel fen, Galili distrik an ibodon. ");
INSERT INTO dad_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Anĩ ere, tura tar Sifa bun diselel mog, ĩg iselen, anĩ ere, mala yaor sã, iminẽyan. ");
INSERT INTO dad_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sifa bun, Juda tamo idi, ĩ nigin meleid dino fen, to difen, “Tamo are nain?” ");
INSERT INTO dad_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tamo kayau atun, ĩ nigin fatuk bagai kosesẽ kurã den. Tunĩ diron, “Ĩ tamo biya.” Tunĩ solo de diron, “Eo, ĩ tamo kayau idegnẽdidig.” ");
INSERT INTO dad_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Anĩ ere, taka nem ĩ nigin yaor to kurõ fesin, ere nigin, idi Juda tamo nigin kumĩ den. ");
INSERT INTO dad_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sifa mogo atusil ifar mog, Jesus tempel modoũ bun isel fen, od ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juda tamo idi terẽ de fen, diron, “Tamo enei tai fiya yaleya sã mog, naig fe fen, keleĩ eig fiya ado?” ");
INSERT INTO dad_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus solof iron, “Neu ifelnẽya are neu sã, aya sur fiyan ĩ bunem isif. ");
INSERT INTO dad_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Taka ĩ Negur nẽ oroya dõ fiya nigin orof are, neu ifelnẽya Negur bunem isif be, aya neu oroya nem wogõ auf be anĩ, ĩ keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Taka ĩ yogon kisim wogõ yef are, ĩ yogo yana yaleseya nigin age fef, anĩ ere, taka ĩ sur fiyen nẽ yana yaleseya nigin kabĩ yalef, tamo are momoi nẽ. Ĩ bun idegẽya taka sã. ");
INSERT INTO dad_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses lo anĩ to ifenein de? Anĩ ere, ã atun, taka nem lo to dõ fedig. Ere nigin ã aya unakesigouf nigin ago gef?” ");
INSERT INTO dad_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tamo kayau solo de diron, “Õ kaa sane ado. Aim õ inokesiyouf nigin age fef?” ");
INSERT INTO dad_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus idi irokenẽdin, “Aya memelik taka ano di, ã ganan terẽ gen. ");
INSERT INTO dad_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Anĩ ere, Mosesem mulũ ileya ifenein nigin, ã kesu Sabat naa bun mulũ ileya wenẽgedig (mulũ ileya are, Moses bunem to isin, teneub te bunem isin). ");
INSERT INTO dad_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moses nẽ lo to wal gouf nigin, Sabat naa bun kesu nẽ mulũ ileya wenẽgedig, ere nigin aya Sabat naa bun, tamo bou adok el afe di, ã aya nigin nameĩ sanedig? ");
INSERT INTO dad_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mala yaor anĩ dogol uleg fen, to es gei, tutuk bagai el ge, es gei.” ");
INSERT INTO dad_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sain anĩ bun, Jerusalem tamo kayau tunĩ diron, “Tamo enei are idi ĩ dukesiyouf nigin age difef anĩ sã de? ");
INSERT INTO dad_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ĩ de yeir, mal atun wogõ ye di, ereb od taka to dirokenek. Mudur adodo idi, ĩ anĩ Kristus ya anĩ mogo tutuk keleĩ de? ");
INSERT INTO dad_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Anĩ ere, tamo enei nain be tamal, are amã keleĩ. Sain Kristus isiyouf, taka nem ĩ nainenem be isif to keleĩ youf.” ");
INSERT INTO dad_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Age de di, Jesus fau tempel modoũ bun ifelneĩd fen, iweig iron, “Are de, ã aya nigin keleĩ, aya nainenem asin are ã keleĩ. Aya ein neu oroyam to asin, anĩ ere, ĩ aya sur fiyan are momoi. Ã ĩ keleĩ sã, ");
INSERT INTO dad_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","anĩ ere, aya ĩ keleĩ, ere nigin, aya ĩ bun tamal, im aya sur fiyan.” ");
INSERT INTO dad_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Od enei bun, idi ĩ dirounẽf nigin age difen, anĩ ere, taka nem ĩ bun ima to inon, ere nigin, yogon sain fau isiya sã. ");
INSERT INTO dad_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Anĩ ere, tamo kayau musei fau ĩ nigin momoi de fen, diron, “Sain Kristus isiyouf, ĩ memelik tamo enei inodif anĩ wal fiya inodiyouf de?” ");
INSERT INTO dad_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tamo kayau ĩ nigin age de, kosesẽ kurã de mog, Farisia tamo idi karĩ den. Age de fen, pris odudug Farisia geid, tempel lo fiya tamo Jesus dalouf nigin sur difedin. ");
INSERT INTO dad_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus iron, “Aya ã geid sain modeg tabodok, age afe fen, aya ĩ aya sur fiyan bun alauf. ");
INSERT INTO dad_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ã aya umirnagauf, anĩ ere, ã to fotou wiyagauf. Aya abodõf nẽ an, ã isiya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda tamo abob dirokenen, “Tamo enei nari bagai ile di, anĩ ada ĩ to fotou tafouf? Ada neda tamo kayau firagagaũ difen, Grik tamo kayau atun dibodok nẽ an, ĩ ile fen, Grik tamo kayau ifelnẽdiyouf de? ");
INSERT INTO dad_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ere gariya nigin ĩ iron, ‘Ã aya umirnagauf, anĩ ere, ã to fotou wiyagauf. Aya abodõf nẽ an, ã isiya kisi feleya sã’?” ");
INSERT INTO dad_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sifa naa odug idikeleya bun, Jesus ifar fen, iweig iron, “Taka ĩ naan ail fouf, aya bun isi fen, naan yãf. ");
INSERT INTO dad_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Taka ĩ aya nigin momoi yef, Negur nẽ Itotoya iron kilei, warur naan ĩ namenem ulo ulõ yef yenẽf.” ");
INSERT INTO dad_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ĩ od enei Awa Uur nigin wogõ yen, are idi Jesus nigin momoi den anidi fau dalouf. Sain anĩ bun, Awa Uur isiya san, ere nigin, Jesus fau fula fiya medeĩya yaleya sã. ");
INSERT INTO dad_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Od enei karĩ de fen, tamo kayau tunĩ diron, “Momoi bagai, tamo enei Profet ada tari tafef anĩ.” ");
INSERT INTO dad_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tunĩ diron, “Ĩ Kristus.” Tunĩg diron, “Kristus ouf are, naig fe fen, Galilim isiyouf? ");
INSERT INTO dad_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kristus Dawid nẽ ibor bunem, Betlehem taun Dawid ibodon nẽ anenem isiyouf, anĩ Negur nẽ Itotoya to irok de?” ");
INSERT INTO dad_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Anĩ nigin, tamo kayau Jesus nigin fara furu difen. ");
INSERT INTO dad_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tunĩ Jesus ka difiyẽf nigin age difen, anĩ ere, taka nem ĩ bun ima to inon. ");
INSERT INTO dad_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tempel lo fiya tamo idi, pris odudug Farisia tamo gedin keku de dile di, to difedin, “Ere nigin ã ĩ to urou usigel?” ");
INSERT INTO dad_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tempel lo fiya tamo solo de diron, “Taka nem, tamo enei wogõ yedig gen to wogõ yedig.” ");
INSERT INTO dad_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisia tamo solo de diron, “Ĩ ãg idegnein de? ");
INSERT INTO dad_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mudur adodo Farisia tamo geid atun, taka ĩ nigin momoi yen de? ");
INSERT INTO dad_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sã, anĩ ere, tamo kayau eneidi idi lo keleĩ sã, idi Negurem gelu fedif.” ");
INSERT INTO dad_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus, idi neid taka, tetunem Jesus garan ilen, ĩ irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ada neda lo bun, taka ĩ ereb age fef anĩ ileya nigin ketem karĩ tafiye ken, es tafedig. Age fiya sã de?” ");
INSERT INTO dad_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Idi solo de diron, “Õg Galili tamal de? Umir ken, fau keleĩ youf, profet taka Galilim to isif.” ");
INSERT INTO dad_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Age de fen, idi mugu mugu dogo neid fonõ fonõ dilen. ");
INSERT INTO dad_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Anĩ ere, Jesus Moul Arei bun iselen. ");
INSERT INTO dad_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bonimei mumurei ado, ĩ baban tempel modoũ bun wõ yen, an tamo kayau ganan guru de salili difiyẽ di, ĩ ifelnẽdiyouf nigin ibodon. ");
INSERT INTO dad_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lo ifelnẽdiya tamo Farisia tamo geid idi, kayau taka noli ye mog, dale dirou disi, guru fiya mala bun dinenẽ di, ifaren. ");
INSERT INTO dad_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Age dife fen, Jesus dirokenen, “Tise, kayau enei noli tobonunã ino di, malel. ");
INSERT INTO dad_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lo bun, kayau age fediya meein tulu fiya nigin Moses irokanaman. Gama õ ere wof?” ");
INSERT INTO dad_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Idi ĩ bou bun od yũya nigin kor dino fen, age de, to difiyen. Anĩ ere, Jesus obũ yeis fen, ima gegem teneub bun itoton. ");
INSERT INTO dad_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Idi ĩ to difiyẽtu di, ĩ fã ye, saules fen, irokenẽdin, “Ã atun, aib taka ĩ mosor sãf, ĩ ketem kayau bun meein irãf.” ");
INSERT INTO dad_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Baban ĩ obũ yeis fen, teneub bun itoton. ");
INSERT INTO dad_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Idi od anĩ karĩ de fen, idi mugu mugu ul de, diyalelen, biyedim uyu dirou di, age de dile, Jesus kayau ifaren anĩ ado dogol ditornẽdin. ");
INSERT INTO dad_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus saules fen, kayau to fiyen, “Kayau, idi nai difef? Idi takam baban õ bun od to yuk de?” ");
INSERT INTO dad_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kayau iron, “Odug, takam to age fef.” Jesus iron, “Ayag õ boũ bun od to auk. Ule fen, sain enei ilauf ganan, mosor baban to uno.” ");
INSERT INTO dad_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus baban tamo kayau irokeneĩd fen, ĩ iron, “Aya tenebur enei nẽ fula fiya. Taka ĩ aya dõ fiyauf, ĩ gugum namen to bagai iyõf, anĩ ere, ĩ mata nẽ fula fiya adouf.” ");
INSERT INTO dad_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Age ye di, Farisia tamo idi Jesus dirokenen, “Õ ogo nigin wogõ wof, anĩ nigin, ogon wogõya are, momoi be sã be anĩ yaor sã.” ");
INSERT INTO dad_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus solof irokenẽdin, “Aya yug nigin wogõ auf, anĩ ere, neu wogõya are momoi, ere nigin, aya nainenem asin, nain be alauf anĩ, aya keleĩ. Anĩ ere, ã, aya nainenem asin, nain be alauf anĩ, keleĩ sã. ");
INSERT INTO dad_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ã tamo nẽ tobonunã bunem es gedig, aya aib taka to es afedig. ");
INSERT INTO dad_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Anĩ ere, aya es afouf are, neu es fiya are tutuk, ere nigin, aya mugu sã. Aya Dei inim sur fiyan ado mafaref. ");
INSERT INTO dad_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ãgenei Lo bun itotoya irok, tamo urom wogõ tekelei dinof, are momoi. ");
INSERT INTO dad_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aya yug nigin kurõ afalaisidig, age afe di, Dei aya sur fiyan ĩ, aya nigin kurõ fesidig.” ");
INSERT INTO dad_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Age ye di, idi Jesus dirokenen, “Õ tamã nain?” Jesus solof iron, “Ã aya nigin ado neu Dei nigineg keleĩ sã. Ã aya nigin keleim are, neu Dei nigineg keleim.” ");
INSERT INTO dad_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ĩ tempel bun kolekta inoya nẽ modoũ non ifelneĩd fen, od enei wogõ fiyẽdin. Anĩ ere, takam ĩ to ima ka fen, ere nigin, in sain fau isiya sã. ");
INSERT INTO dad_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus baban idi irokenẽdin, “Aya atorneĩ di, ã umirnagauf, agog fen, ã ãgenei mosor bun gare gouf. Aya elef nẽ an, ã isiya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Anĩ bunem, Juda tamo idi diron, “Ĩ yogo bouwa yukesiyouf de? Anĩ nigin, ĩ, ‘Aya elef nẽ an, ã isiya kisi feleya sã,’ yef de?” ");
INSERT INTO dad_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Anĩ ere, Jesus tobol fe fen, irokenẽdin, “Ã tenebur temeleĩ, aya ilun temelou. Ã teneub enei nẽ, aya teneub enei nẽ sã. ");
INSERT INTO dad_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Anĩ nigin, aya, ã ãgenei mosor bun gare gouf ayein. Aya yug nigin, aya im audig anĩ, to momoi gouf are, ã momoi bagai ãgenei mosor bun gare gouf.” ");
INSERT INTO dad_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Age ye di, idi ĩ to difiyen, “Õ ai?” Jesus idi irokenẽdin, “Aya aib anĩ, mogo gariya bunem arokeneik asin. ");
INSERT INTO dad_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Aya ã nigin wogõya musei ado, es fiya nigineg musei. Anĩ ere, sur fiyan ĩ, momoi bagai, anĩ nigin, ereb aya ĩ bun karĩ aun anĩ, tamo kayau tenebur ein arokenẽdif.” ");
INSERT INTO dad_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Idi, ĩ Tama nigin irokenẽdif ya anĩ, to kisi fokõ yen. ");
INSERT INTO dad_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Anĩ nigin, Jesus iron, “Sain ã Tamo Naal walesagauf bun, aya yug nigin aya im audig anĩ, ã keleĩ youf, aya neu oroyam ereb taka to age afedig, anĩ ere, aya Dei ifelnan anĩ dogol wogõ audig anĩ, ã keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aya sur fiyan ĩ, amã urom mabodok, ĩ mugu to itornal, ere nigin, aya faimud, ereb ĩ wau al fouf anĩ, age afedig.” ");
INSERT INTO dad_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Age wogõ ye di, musei ĩ nigin momoi den. ");
INSERT INTO dad_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesus, Juda tamo ĩ momoi difiyen anidi irokenẽdin, “Aya afelnein anĩ uroug tokõ walagauf are, ã momoi bagai neu dõ fiya tar. ");
INSERT INTO dad_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Agog fen, ã momoi anĩ keleĩ youf, momoi anim kafĩ fiya bun tamal yalelneĩf.” ");
INSERT INTO dad_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Idi aiten dale dirokenen, “Amã Abraham nẽ ibor nẽ tubu tar, amã aib taka nẽ ferfer to mabodon. Ere wo fen, amã kafĩ fiya bun tamal yalelnamãya nigin urok?” ");
INSERT INTO dad_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus aitedin yale iron, “Aya ã momoi bagai arokeneik, taka ĩ mosor inof are, ĩ mosor nẽ ferfer. ");
INSERT INTO dad_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ferfer ĩ, ibor anĩ bun gai ibodkeleya modoũ sã, anĩ ere, modoũ are naal nẽ faimud ibodkalauf. ");
INSERT INTO dad_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Anĩ nigin, Naal ĩ kafĩ fiya bun tamal yalelneĩf are, ã momoi bagai karika lauf. ");
INSERT INTO dad_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ã Abraham nẽ ibor nẽ tubu tar are, aya keleĩ. Anĩ ere, ã aya unakesigouf nigin dodok gef, ere nigin, ã neu od nẽ modoũ namein to ibodok. ");
INSERT INTO dad_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ereb aya Dei mala bun ailen anĩ, aya ã arokeneik, ãg ereb ãgenei temeĩ bun karĩ gen anĩ ago gedig.” ");
INSERT INTO dad_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Idi aiten dale dirokenen, “Abraham ĩ tamamã.” Age de di, Jesus iron, “Ã Abraham gere tarem are, Abraham age fedin anĩ ago gem. ");
INSERT INTO dad_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gama ã, aya Negur bun momoi anĩ karĩ au fen, arokenein anĩ, unakesigouf nigin naab umirẽgef. Abraham ĩ to age fen. ");
INSERT INTO dad_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ã temeĩ age fedig anĩ ago gef.” Age ye di, idi Jesus dirokenen, “Amã seseirã inoya naab bun temelamã sã. Nemã Tamamã are Negur yogo dogol.” ");
INSERT INTO dad_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus idi irokenẽdin, “Negur ĩ Temeim are, ã aya nigin wauĩ laa fem, ere nigin, aya Negur bunem asi fen, yeir afaref. Aya neu oroyam to asin, im sur fiyan. ");
INSERT INTO dad_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ere nigin neu od nigin wauĩ to fokõ yef? Are aya wogõ auf anĩ, ã karĩya kisi feleya sã nigin. ");
INSERT INTO dad_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ã, temeĩ Satan nẽ, anĩ nigin, ã temeĩ nẽ oroya dõ fiya nigin oroyeik. Ĩ gariya bunem isin, ĩ yukesiya kaa, momoi to iroudig, ere nigin, ĩ namen momoi sã. Ereb sain ĩ idegẽya od wogõ yedig, ĩ yogon od bagai wogõ yedig, ere nigin, ĩ kori tamal, idegẽya tama. ");
INSERT INTO dad_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Anĩ ere, aya momoi anĩ wogõ audig nigin, ã to momoi wiyagedig! ");
INSERT INTO dad_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ã takam, aya neu mosor anĩ tau kurõ fesiya kisi feleya? Aya momoi wogõ auf are, ere nigin ã to momoi wiyagef? ");
INSERT INTO dad_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aib ĩ Negur nẽ, ĩ Negur ereb yef anĩ karĩ yedig. Ã to karĩ gef anĩ nẽ gariya are, ã Negur nẽ sã nigin.” ");
INSERT INTO dad_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda tamo aiten dale dirokenen, “Amã õ Samaria tamal, kaa sanem irounon mauf are, momoi to morok de?” ");
INSERT INTO dad_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus solof iron, “Aya kaam to irounan, anĩ ere, aya neu Dei yana seli abidig, ã aya selu to wabigedig. ");
INSERT INTO dad_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aya yug nigin fula fiya medeĩya to amirek, anĩ ere, taka ĩ anĩ imirek are ibodok, ĩ anĩ es fiya tamo. ");
INSERT INTO dad_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aya ã momoi bagai arokeneik, taka ĩ neu od irou kafĩ falauf are, ĩ laa to bagai gurug fouf.” ");
INSERT INTO dad_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juda tamo, anĩ bun Jesus dirokenen, “Gama amã keleĩ, õ kaa sanem irounon! Abraham laa fen, profeteg gare den, anĩ ere, õ, taka ĩ ogon od irou kafĩ falauf are, ĩ laa to bagai kobũf ilouf, wof. ");
INSERT INTO dad_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Õ tamamã Abraham wal fiya de? Ĩ laa fen, profeteg age difen. Õ kisi wof, õ ai?” ");
INSERT INTO dad_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus aitedin yale iron, “Aya yug selu alesauf are, neu seli alef are ege. Neu Dei, ĩ anĩ ãgenei Negur gef, ĩ aya yanau yalesedig. ");
INSERT INTO dad_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ã ĩ keleĩ sã, anĩ ere, aya ĩ keleĩ. Aya ĩ keleĩ sã auf are, aya ã gen idegẽya tamouf, anĩ ere, aya ĩ keleĩ bagai, in od dõ afedig. ");
INSERT INTO dad_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Temeĩ Abraham ĩ, neu naa anĩ ilouf nigin kisif fen, wau al fen. Ĩ anĩ mogo ile fen, kulĩ yen.” ");
INSERT INTO dad_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Anĩ nigin, Juda tamo Jesus dirokenen, “Õ fau yar fifti yaleya sã, anĩ õ mogo Abraham ulen de?” ");
INSERT INTO dad_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus idi irokenẽdin, “Aya ã momoi bagai arokeneik, Abraham gõ fiya sã mog, aya abodon.” ");
INSERT INTO dad_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Anĩ nigin, idi ĩ meein tulu difouf nigin meein gei difen, anĩ ere, Jesus bouwa inokel fen, tempel modoũ bun tamal iya ilen. ");
INSERT INTO dad_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus iyok ile fen, tamo taka mala ifofakeleya gõ difen anĩ ilen. ");
INSERT INTO dad_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","In dõ fiya tar Jesus to difiyen, “Rabi, aim mosor ino di, ĩ mala ifofakeleya gõ difen, tamo enei yogo de, sina tamam de?” ");
INSERT INTO dad_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus aitedin yale iron, “Tamo eneimeg sã, sina tama adomeg sã, anĩ ere, Negur nẽ kabĩ ĩ bunem yaorouf nigin eig fiya wõ yen. ");
INSERT INTO dad_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Eĩ fau gaa ado, aya sur fiyan in kabĩ talouf bagai. Bõ fau isif, sain anĩ, taka nem kabĩ yaleya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sain aya tenebur abodok, aya teneub enei nẽ fula fiya.” ");
INSERT INTO dad_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Age wogõ yel fen, ĩ tenebur isis fen, salina buru ado falei fe fen, tamo mala bun inon. ");
INSERT INTO dad_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jesus ĩ irokenen, “Ule, Siloam naan kukor ugũ” (Siloam nẽ gariya, are ‘Sur fiyen’). Anĩ nigin, tamo ile, naan igun, agef fen, mala kelẽ yel, fõ bun isin. ");
INSERT INTO dad_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","In fõ tura tar ado, idi ĩ nonĩ ye mog diledig anidi diron, “Tamo de eneim ibod ken, nonĩ yedig anĩ sã de?” ");
INSERT INTO dad_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Idi tunĩ diron, “Im.” Tunĩ diron, “Im sã, taka ĩ genem.” Anĩ ere, ĩ yogo iron, “Aya de tamo anim.” ");
INSERT INTO dad_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Idi ĩ dirokenen, “Naig fe di, õ malã kelẽ yeledin?” ");
INSERT INTO dad_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ĩ aitedin yale iron, “Tamo yana Jesus dedig im, buru falei fe fen, malau uru bun inodin. Ĩ, aya ele, Siloam naan agũf nigin irokanan. Anĩ aya ele, naan agun, age afe fen, aya malau kelẽ aun.” ");
INSERT INTO dad_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Idi ĩ to difiyen, “Tamo are nain?” Ĩ iron, “Aya keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Idi tamo mala ifofakelen anĩ, Farisia tamo gedin dale dirou disin. ");
INSERT INTO dad_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesus buru falei fe fen, tamo mala el fedin nẽ naa are Sabat naa. ");
INSERT INTO dad_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Anĩ nigin, Farisia tamo idig, ĩ naig fe fen, mala kelẽ yedin anĩ to difiyen. Tamo are irokenẽdin, “Ĩ malau buru inodin, age fe di, agun, anĩ aya gama kelẽ auf.” ");
INSERT INTO dad_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisia tamo tunĩ diron, “Tamo enei Negur bun tamal sã, ere nigin, ĩ Sabat naa to dõ fef.” Anĩ ere, tunĩ diron, “Naig fe di, mosor tamo memelik age fediya inoya kisi feleya?” Anĩ nigin, idi fara difen. ");
INSERT INTO dad_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Idi baban tamo mala ifofakelen anĩ dirokenen, “Ĩ õ malã el fen anĩ, õ ĩ nigin ere wof?” Age de di, ĩ iron, “Ĩ profet.” ");
INSERT INTO dad_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juda tamo idi, tamo mala ifofakeleya mala kelẽ yelen anĩ, fau to momoi den. Anĩ nigin, idi tamo anĩ sina tama diweignẽdin. ");
INSERT INTO dad_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Idi to difen, “Eĩ ã naaluĩ de? De ĩ anĩ mala ifofakeleya gõ mafen gef? Naig fe di, ĩ gama sã mala kelẽ yelef?” ");
INSERT INTO dad_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sina tama diron, “Amã keleĩ, ĩ nemã kesu, anĩ ĩ mala ifofakeleya gõ mafen. ");
INSERT INTO dad_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Anĩ ere, ĩ naig fe fen, gama sã lo fef, aim ĩ mala el fedin anĩ, amã keleĩ sã. Yogo to wiyẽg, ĩ biya, yogo nigin wogõ youf.” ");
INSERT INTO dad_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sina tama idi, Juda tamo kumĩ difiyeĩd fen, age de diron, ere nigin, Juda tamo idi mogo od difon, aib taka Jesus anĩ Kristus youf are, Juda neid uub fõ bun dalelnẽf. ");
INSERT INTO dad_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Age fiya nigin, sina tama eig de diron, “Ĩ biya, yogo to wiyẽg.” ");
INSERT INTO dad_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Baban Juda tamo idi, mala ifofakelen anĩ diweigne ken, diron, “Negur yana wales fen, momoi nẽ od dogol urõf, amã keleĩ, tamo are mosor tamal.” ");
INSERT INTO dad_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ĩ solof iron, “Ĩ mosor ado be sã be, aya keleĩ sã. Tekelei aya keleĩ are, aya malau ifofakelen, anĩ ere, gama lo afedig.” ");
INSERT INTO dad_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Age ye di, idi ĩ to difiyen, “Ĩ õ ere naig yon? Naig fe di, õ malã birikã fedin?” ");
INSERT INTO dad_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ĩ aitedin yale iron, “Aya ã mogo arokenein, anĩ ere, ã to karĩ gen. Ere nigin ã baban karĩ gou fenẽ? Ãg in dõ fiya tar wowã gou fenẽ de?” ");
INSERT INTO dad_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Age ye di, idi kono difiye ken, diron, “Õ tamo enei nẽ dõ fiya taka! Amã are Moses nẽ dõ fiya tar! ");
INSERT INTO dad_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Negur Moses wogõ fiyen are amã keleĩ, anĩ ere, tamo enei nigin, ĩ nainenem isin areg, amã keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tamo anĩ aitedin yale irokenẽdin, “Ago ge di, terẽ auf. Ĩ nainenem isin, ã keleĩ sã, anĩ ere, aya malau birikaũ fedin. ");
INSERT INTO dad_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Amã keleĩ, Negur ĩ mosor dinodidig anĩ to karĩ fiyẽdidig, anĩ ere, taka ĩ Negur anini fiye ken, Negur nẽ oroya dõ fef are, Negurem ĩ karĩ fiyẽdig. ");
INSERT INTO dad_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gariya bunem isi gama, taka nem, tamo mala ifofakeleya gõ difen anĩ birikã fedin yeya to karĩ yedig. ");
INSERT INTO dad_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tamo enei Negur bun tamal sam are, ĩ ereb taka to naig fem.” ");
INSERT INTO dad_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Age ye di, idi diron, “Õ mosor barikã gõ diyon, naig fe di, õ amã ufelnamak?” Age de fen, idi ĩ mayarẽ diru dirã di, isin. ");
INSERT INTO dad_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus, idi tamo anĩ serẽ diran yeya anĩ karĩ yen. Jesus ĩ fotou fiye ken, iron, “Õ Tamo Naal nigin momoi wof de?” ");
INSERT INTO dad_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tamo to fen, “Odug, ai anĩ ĩ? Urokana di, aya ĩ nigin momoi auf.” ");
INSERT INTO dad_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus iron, “Õ gama ĩ ulel, de ĩ anĩ urom wogõ gef.” ");
INSERT INTO dad_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Age ye di, tamo iron, “Odug, aya momoi auf.” Agef fen, ĩ Jesus seli yabin. ");
INSERT INTO dad_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus iron, “Es fiya nigin aya tenebur ein asin, are mala ifofakeleya meleid kelẽ youf, age fe di, idi meleid kelẽ yef, are meleid ifofakalauf nigin.” ");
INSERT INTO dad_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisia tamo tunĩ Jesus geid difaren anĩ, agef wogõ ye di, karĩ de fen, to difen, “Ere? Amãg malamã ifofakeleya de?” ");
INSERT INTO dad_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus iron, “Ã momoi bagai meleĩ ifofakeleyam are, ã mosor sam, anĩ ere, gama ã malamã kelẽ yef gef, anĩ nigin, ãgenei mosor fau ibodok. ");
INSERT INTO dad_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Aya momoi bagai arokeneik, tamo taka ĩ, sipsip nẽ kauwor bobog bunem to ilauf, anĩ ere, naab taka bunem gar ye isilauf are, ĩ bẽ tamo, bẽ yaledig. ");
INSERT INTO dad_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tamo ĩ bobog bunem ilef are, ĩ yogo sipsip marau. ");
INSERT INTO dad_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lo fedig tamo ĩ bobog kãf kenẽdidig, age fe di, sipsip ĩ ait karĩ dedig. Ĩ yogon sipsip yana yaleid fen, mayarẽ guri feid, irouledig. ");
INSERT INTO dad_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sain ĩ yogon ganan mayarẽ guri feid iroule fen, ĩ ketem uyu iledig, age fe di, yogon sipsip dõ difedig, ere nigin, idi yogon ait keleĩ. ");
INSERT INTO dad_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Anĩ ere, idi tamo urug to dõ difedig, idi ĩ mã diyawauf, ere nigin, ĩ ait urug nigin idi keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus yaab od enei nem wogõ fiyẽdin, anĩ ere, ĩ idi ereb gariya nigin irokenẽdin anĩ, idi to kelein. ");
INSERT INTO dad_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Anĩ nigin, Jesus baban iron, “Aya ã momoi bagai arokeneik, aya sipsip neid bobog. ");
INSERT INTO dad_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ganan uyulil disin are, idi bẽ tamo, bẽ daledig, anĩ ere, sipsip idi to karĩ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Bobog are aya, taka ĩ aya bunem isiyouf are, mata kel yalouf. Ĩ namen isi fen, ulõ yeis ilauf, agef fen, fisir yõya nẽ fotou fouf. ");
INSERT INTO dad_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bẽ tamo are bẽ nigin, yukesiyouf nigin ado, narĩ fouf nigin dogol isif, aya idi mata dale fen, barikãuf nigin asin. ");
INSERT INTO dad_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aya sipsip lo fiya tamo biya, sipsip lo fiya tamo biya, yogon mata sipsip nigin itorõdig. ");
INSERT INTO dad_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Oroi tamo are ĩ sipsip marau sã. Anĩ nigin, ĩ gaũ kuĩ isi di, ile fen, sipsip itorarã iyadig. Age fe di, gaũ kuĩ sipsip kaka feid fen, firagagaũ fedidig. ");
INSERT INTO dad_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tamo are iyadig, ere nigin, ĩ oroi tamo, sipsip nigin to karĩ yedig. ");
INSERT INTO dad_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Aya sipsip lo fiya tamo biya, aya neu sipsip keleĩ, neu sipsip idi aya keleĩ, ");
INSERT INTO dad_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","are Dei ĩ aya keleĩ, aya Dei keleĩ gen. Anĩ nigin, aya neu mata sipsip nigin atorok. ");
INSERT INTO dad_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aya sipsip tunĩ ado, are sipsip kau enei bun temeleid sã, aya idig de guri afeid, arou asiyouf. Idig aitou karĩ douf, age fe di, idi uũ tekelei, sipsip lo fiya tamo tekelei youf. ");
INSERT INTO dad_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Neu Dei, aya nigin wau laa fef nẽ gariya are, aya neu mata baban kel yalouf nigin anĩ atorok. ");
INSERT INTO dad_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Taka nem neu mata to son fiyauf, anĩ ere, aya neu oroyam neu mata atorok. Aya neu mata itorõya nigin megeir ado, kel yaleya nigineg megeir ado. Od enei neu Dei bun tamal alen.” ");
INSERT INTO dad_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Juda tamo od enei nigin baban fara difen. ");
INSERT INTO dad_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Musei idi diron, “Ĩ kaa sane ado, agef fen, wadak. Ere nigin ĩ karĩ wiyẽgef?” ");
INSERT INTO dad_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Anĩ ere, tunĩ diron, “Wogõya enei are, tamo kaa sane ado nẽ sã. Kaa sane ĩ mala ifofakeleya birikã feleya kisi feleya de?” ");
INSERT INTO dad_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sain anĩ bun, Negur bun Kel Inoya nẽ Sifa naa Jerusalem wõ yen. Are saneya sain. ");
INSERT INTO dad_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Anĩ Jesus tempel modoũ bun, Solomon nẽ Waranda dõ fef iyon. ");
INSERT INTO dad_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda tamo guru de, Jesus salili difiye ken, dirokenen, “Sain ganĩ amã lo wamã di, nene mauf? Õ Kristus ouf are, amã el wo, faded wamãf.” ");
INSERT INTO dad_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus aitedin yale irokenẽdin, “Aya mogo arokenein, anĩ ere, ã to momoi gef. Memelik neu Dei yana nem anodif, are aya nigin irok. ");
INSERT INTO dad_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Anĩ ere, ã to momoi gef, ere nigin, ã neu sipsip sã. ");
INSERT INTO dad_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Neu sipsip aya aitou karĩ dedig, aya idi keleĩ, anĩ nigin, idi aya dõ difiyadig. ");
INSERT INTO dad_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aya idi mata faimud ibodkeleya afenẽdidig, age afe di, idi to bagai inanakalauf. Takam idi imaun tamal to sosoin fiyauf. ");
INSERT INTO dad_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Neu Dei idi aya ifanan ĩ, ereb ereb ganan wal fiya. Takam idi neu Dei ima bun tamal son fiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aya Dei ado tekelei.” ");
INSERT INTO dad_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Juda tamo baban ĩ meein tulu difiyẽf nigin, meein gei difen. ");
INSERT INTO dad_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Anĩ ere, Jesus idi irokenẽdin, “Aya Dei bun tamal, ã memelik odudug musei afelnein. Anidi atun nanĩ anĩ nigin, ã aya meein tulu wiyagau fenẽ?” ");
INSERT INTO dad_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juda tamo aiten dale diron, “Amã anidi taka nigin meein to tulu mayõf, anĩ ere, Negur kono fiya nigin, ere nigin, õ tamo maug anĩ, ‘aya Negur’ wof.” ");
INSERT INTO dad_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus idi aitedin yale irokenẽdin, “Ãgenei Lo bun itotoya anĩ to ibodok de, ‘Aya aron, ã waitou’? ");
INSERT INTO dad_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Negur nẽ od idi bun isin are, Negur idi anĩ waitou yen. Negur nẽ Itotoya are narĩ fiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Age yen ouf are, Dei yogon bagai igirna fen, ein tenebur sur fiyan anĩ, aya Negur Naal aul anĩ, ere nigin aya kono afel wiyagef? ");
INSERT INTO dad_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aya ereb neu Dei age fedig anĩ, to age afef are, aya to momoi wiyagauf. ");
INSERT INTO dad_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Anĩ ere, aya age afe di, ã neu od to momoi goufeg, memelik anodif anĩ momoi gouf, anĩ bunem Dei aya bun ibodok, aya Dei bun abodok ya anĩ, ã karĩg fen, keleĩ youf.” ");
INSERT INTO dad_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Idi baban Jesus ka difiyẽf nigin age difen, anĩ ere, ĩ oreis iyawon. ");
INSERT INTO dad_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Agef fen, Jesus ĩ, Jordan naan sitakã, uruwa bun Jon naan igunẽdin modoũ bun, kel ile, an ibodõ di, ");
INSERT INTO dad_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","tamo kayau musei ĩ garan disi diron, “Jon memelik taka to inon, anĩ ere, Jon tamo enei nigin wogõ yen ganan, are momoi.” ");
INSERT INTO dad_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Age de fen, an musei idi Jesus nigin momoi den. ");
INSERT INTO dad_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gama tamo Lasarus dedig dagin. Ĩ Betani tamal, Maria ĩ tura Marta ado neid fonõ. ");
INSERT INTO dad_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria de anim, kulu moul sumeĩ biya ado, Jesus bun fi fel fen, fatiyam Jesus ye waĩ fen. Ĩ main Lasarus gama dagi yenek. ");
INSERT INTO dad_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Anĩ nigin, main tar Jesus garan od sur difen, “Odug, ĩ nigin waũ laa fedig are dagi.” ");
INSERT INTO dad_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus ĩ enei karĩ ye fen, iron, “Dagi eneim to laa ilauf, are Negur nẽ fula fiya medeĩya nigin, anĩ bunem, Negur Naal yana dalesauf.” ");
INSERT INTO dad_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Marta, tura ado, maineid Lasarus nigin, Jesus wau laa fen. ");
INSERT INTO dad_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Anĩ ere, Jesus ĩ Lasarus dagi yenek ya karĩ ye fen, ĩ ibodon nẽ an baban naa uru ibodon. ");
INSERT INTO dad_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Anĩ bure fele di, Jesus in dõ fiya tar irokenẽdin, “Ada Judia distrik baban keku tagauf.” ");
INSERT INTO dad_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Anĩ ere, idi diron, “Rabi, õ gama bagai Juda tamo meein tulu diyõf nigin age difen, anĩ õ an kel ulau fenẽ de?” ");
INSERT INTO dad_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus irokenẽdin, “Gaa tekelei bun aua tuwelf to ado de? Anĩ ege aa luwan to ilalauf. Tamo ĩ gaa ado iyok, ĩ ye to tũ fedig, ere nigin, ĩ teneub enei nẽ lalan anim lo fedig. ");
INSERT INTO dad_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sain ĩ bõ iyõf are, ye tũ fouf, ere nigin, ĩ lalan sã.” ");
INSERT INTO dad_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Enei irokel fen, Jesus idi irokenẽdin, “Neda mou Lasarus ĩ mulã yenek, anĩ ere, aya turĩ afiyẽf nigin an elef.” ");
INSERT INTO dad_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","In dõ fiya tar Jesus solo de dirokenen, “Odug, ĩ yenek are, ĩ fau karikauf.” ");
INSERT INTO dad_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lasarus laa fen nigin Jesus iron, anĩ ere, in dõ fiya tar kisi difen, ĩ mulã yenẽya maug bagai nigin irok den. ");
INSERT INTO dad_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Anĩ nigin, Jesus idi faded feid, irokenẽdin, “Lasarus laa fen. ");
INSERT INTO dad_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ã nigin au fen, aya an to abodon anĩ nigin, aya wau al fef, ere nigin, anĩ bunem ã momoi gouf. Anĩ ere, ada ĩ gein talauf.” ");
INSERT INTO dad_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Anĩ nigin, Tomas Didimus dedig, dõ fiya tar tunĩ ganan irokenẽdin, “Weim gare tauf nigin, adag talauf.” ");
INSERT INTO dad_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sain Jesus ile wõ yen are, Lasarus mogo matmat bun naa fo ilelen anĩ karĩ yen. ");
INSERT INTO dad_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani are Jerusalem melsã, tri kilomita age fiya. ");
INSERT INTO dad_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Juda tamo kayau musei, Marta Maria ado maineid laa fen anĩ, waud yo difouf nigin idi gedin disin. ");
INSERT INTO dad_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta Jesus isif ya karĩ ye fen, Jesus fotou fouf nigin ilen, anĩ ere, Maria ĩ fõ bun ibodon. ");
INSERT INTO dad_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesus irokenen, “Odug, õ ein udobom are, mainou to laa fem. ");
INSERT INTO dad_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Anĩ ere, aya keleĩ, gamag õ ereb taka nigin Negur urokenẽf are, ifonõf.” ");
INSERT INTO dad_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus Marta irokenen, “Nẽ main baban kel fã youf.” ");
INSERT INTO dad_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta Jesus aiten yale iron, “Aya keleĩ, idikeleya naa kel fãya sain bun, ĩ baban kel fã youf.” ");
INSERT INTO dad_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus ĩ irokenen, “Aya dogol kel fãya nẽ ado mata nẽ. Taka ĩ aya nigin momoi yef are, ĩ mata ibodõf, laa foufeg, ĩ mata ibodõf. ");
INSERT INTO dad_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Taka ĩ mata ibod ken, aya nigin momoi yef are, ĩ to bagai laa fouf. Õ enei momoi wof de?” ");
INSERT INTO dad_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta Jesus irokenen, “Momoi, Odug, aya momoi auf, õ Kristus, Negur Naal, teneub enei bun usin.” ");
INSERT INTO dad_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ĩ agef irokel fen, ĩ kel ile, tura Maria iweigne ken, mugun irokenen. Ĩ iron, “Tise yeir, ĩ iweignok.” ");
INSERT INTO dad_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria od enei karĩ ye fen, ĩ kaisã bagai fã yale, Jesus garan ilen. ");
INSERT INTO dad_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus fonõ wõya sã, ĩ fau Marta fotou fiyen modoũ anĩ bun ibodon. ");
INSERT INTO dad_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juda tamo kayau, Maria geid, fõ bun dibod ken, ĩ wau wã difenen, ĩ kaisã bagai fã yale, ulõ yeis ile di, dile fen, ĩ matmat bun inã yalouf nigin ilef de fen, dõ difiyen. ");
INSERT INTO dad_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sain Maria Jesus ibodon nẽ modoũ anĩ bun wõ ye, Jesus ile fen, ĩ ye gariyan kubũ ye fen, iron, “Odug, õ ein ubodom are, mainou to laa fem.” ");
INSERT INTO dad_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sain Maria inã yalen ado, Juda tamo kayau Maria geid disin idig inã dalen, Jesus anĩ ile fen, wau fatuk bagai gudũf morõ fen. ");
INSERT INTO dad_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesus to fen, “Ĩ nain mũ gen?” Idi diron, “Odug, usi fen, ule.” ");
INSERT INTO dad_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus ĩ inã yalen. ");
INSERT INTO dad_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Age fe di, Juda tamo kayau diron, “Ulegef, ĩ nigin fatuk bagai wau laa fen anĩ!” ");
INSERT INTO dad_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Anĩ ere, idi tunĩ diron, “Ĩ tamo mala ifofakeleya birikã fedin, tamo eneig laa bun ileya nigin katĩ feleya to kisi feleyan de?” ");
INSERT INTO dad_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus baban wau fatuk bagai gudũf fen, matmat bun isin. Matmat are ku, meein nem bobog katĩ difelen. ");
INSERT INTO dad_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus iron, “Meein waleleg.” Marta, laa tamo nẽ main iron, “Anĩ ere, Odug, are gama waai sane, ere nigin, ĩ an naa fo ibodon.” ");
INSERT INTO dad_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Age ye di, Jesus iron, “Õ momoi wof are, Negur nẽ fula fiya medeĩya ulouf, to age ayon de?” ");
INSERT INTO dad_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Anĩ nigin, idi meein are dalelen. Age dife di, Jesus itad fen, iron, “Dei, õ aya karĩ wiyal nigin, õ de ayok. ");
INSERT INTO dad_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aya kelein, õ faimud aya karĩ wiyadig, anĩ ere, aya tamo kayau yeir difaref nigin od enei orom, are idi onom aya sur wiyan anĩ momoi douf nigin.” ");
INSERT INTO dad_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesus od enei wogõ yel fen, ait odug nem iwegin, “Lasarus, ulõ weis!” ");
INSERT INTO dad_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Laa tamo, ye, ima gabar masak nem filu difen ado, nawa gabarem sile difen ulõ yesi di, Jesus idi irokenẽdin, “Gabar waleleg fen, utornẽge di, ile.” ");
INSERT INTO dad_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Anĩ nigin, Juda tamo kayau musei Maria gein disin, Jesus ereb age fen anĩ dile fen, ĩ nigin momoi den. ");
INSERT INTO dad_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Anĩ ere, idi tunĩ Farisia tamo gedin dile fen, Jesus ereb age fen anĩ dirokenẽdin. ");
INSERT INTO dad_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Anĩ nigin, pris odudug Farisia tamo geid, katõ difouf nigin Juda uyu irouya neid kaunsel guru fiya diwegin. Idi diron, “Ada naig tafouf? Ere nigin, tamo enei memelik musei inodif. ");
INSERT INTO dad_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ada lo tafe di, ĩ enei eig fef ilauf are, tamo ganan ĩ nigin momoi douf, age dife di, neda ibodõya ado teneub, Rom tamom disi dalouf.” ");
INSERT INTO dad_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Age de di, idi atun taka, yana Kaiafas, ĩ yar anĩ bun pris neid mudur ibod ken, wogõ yen, “Ã ereb taka keleĩ sã! ");
INSERT INTO dad_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tamo kayau ganan inanakalauf ban, tamo tekeleim tamo kayau nigin laa fouf, are ã nigin deuf anĩ, ã to kisi gef.” ");
INSERT INTO dad_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ĩ yogon kisi bunem od enei to iron, anĩ ere, ĩ yar anĩ bun pris neid mudur ibodon nigin, profet od wogõ yen, Jesus Juda tamo kayau ganan nigin laa fouf yen. ");
INSERT INTO dad_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Are Juda tamo kayau nigin dogol sã, Negur gere tar firagagaũ difen anidig, guri feid irousi kuru fedi di, idi tekelei youf nigin, Jesus laa fouf yen. ");
INSERT INTO dad_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Anĩ nigin, naa anĩ bunem ilen, idi Jesus dukesiyouf nigin naab dimiren. ");
INSERT INTO dad_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Age dife di, Jesus ĩ, Juda tamo kayau meleid bun mala yaor to iyon, ĩ an iminkele fen, teneub akor taka, gerere tuan melsã, fonõ yana Efraim ilen, an yogon dõ fiya tar geid dibodon. ");
INSERT INTO dad_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sain anĩ Juda neid Pasa naa melsã, musei fonõ fonõ temeleid, dogo neid nonorou lilik fiya nigin, Pasa naa wõya sã mog, Jerusalem diselen. ");
INSERT INTO dad_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Idi Jesus nigin meleid dinof diyon. Idi tempel modoũ bun difar fen, abob to difen, “Ã ere kisi gef? Ĩ Sifa bun to isiyouf de?” ");
INSERT INTO dad_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Anĩ ere, pris odudug Farisia tamo geid, taka nem Jesus nain be ibodok ya anĩ ile fen, irokenẽdi di, dirounẽf nigin wedereid diroun. ");
INSERT INTO dad_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasa nẽ naa wõya nigin, naa sigis fau ibod mog, Jesus Betani wõ yen, an Lasarus ibodon, ĩ Jesusem laa bun tamal turĩ fiyen. ");
INSERT INTO dad_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","An Jesus nigin waud el fe fen, bõ saaf dabin, anĩ Marta aruna yalen. Idi Jesus geid tebol bun dibodon atun, Lasarus ibodon. ");
INSERT INTO dad_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Age de mog, Maria moul sumeĩ biya, hap lita nad nem dinon, are moni odug nẽ anĩ yale fen, Jesus ye bun fi fel fen, fatiyam ye waĩ fen. Age fe di, moul sumeĩ biyam, fõ anĩ ino yalen. ");
INSERT INTO dad_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Anĩ ere, Judas Iskariot, in dõ fiya taka, fau dum im Jesus kiwai imeid bun inouf, im iron, ");
INSERT INTO dad_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ere nigin moul sumeĩ biya enei, na nigin sur fe fen, moni anĩ maleg tamo to ifenẽdiyam? Are yar tekelei bun, kabĩ tamo nẽ mala yaledig kilei.” ");
INSERT INTO dad_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ĩ maleg tamo nigin kisif fen, enei to iron, ĩ yogo bẽ tamo nigin age yen. Ĩ moni nẽ kodol lo fiya tamo, moni nẽ kodol bun dinodig are bẽ yaledig. ");
INSERT INTO dad_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Anĩ nigin, Jesus iron, “Kayau are utornẽg, ĩ aya mũ difiyauf naa nẽ nigin, moul sumeĩ biya enei irouwauf. ");
INSERT INTO dad_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Maleg idi, ã geid sain faimud ubodõgouf, anĩ ere, aya, ã geid sain faimud to tabodõf.” ");
INSERT INTO dad_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Age de mog, Juda tamo kayau musei, Jesus an ibodok ya kelei ken, disin, are ĩ nigin dogol sã, Lasarus Jesusem laa bun tamal turĩ fiyen ĩg dilouf nigin. ");
INSERT INTO dad_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Anĩ nigin, pris odudug Lasarus ĩg dukesiyouf nigin naab dimiren, ");
INSERT INTO dad_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ere nigin, Lasarus bunem, Juda tamo kayau musei Jesus garan dile fen, ĩ nigin momoi den. ");
INSERT INTO dad_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Naa anĩ ile di, tamo kayau musei Sifa bun disin, Jesus Jerusalem isif ya anĩ karĩ den. ");
INSERT INTO dad_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Idi pam aarau anã aarau gen anĩ guri de, Jesus tarabã difiyẽf nigin dile fen, diweig diron, “Hosiana!” “Odug yana bunem isif, ĩ el fiya ado!” “Israel neid King, ĩ el fiya ado!” ");
INSERT INTO dad_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus donki naal fotou fe fen, teten ibodon, are Negur nẽ Itotoya eig ye irok kilei, ");
INSERT INTO dad_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“To kumĩg, Saion nẽ tamo kayau, uleg, ãgenei king, donki naal teten ibod ken, isif.” ");
INSERT INTO dad_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Uruwa bagai, in dõ fiya tar, enei ganan nigin wedereid fokõya san. Dum Negur Jesus fula fiya medeĩya ifenẽ di, enei ĩ nigin ditoton ado, enei tamo kayau ĩ bun age difen anĩ, wedereid fokõ yen. ");
INSERT INTO dad_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tamo kayau Jesus geid difar fen, ĩ Lasarus matmat bun tamal iweigne ken, laa bun tamal turĩ fe di, lo difen idim wogagã def, dile di, od iyokelen. ");
INSERT INTO dad_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tamo kayau musei, Jesus memelik anĩ inon karĩ den nigin, ĩ fotou difiyẽf nigin dilen. ");
INSERT INTO dad_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Age dife di, Farisia tamo idi abob dirokenen, “Ulegef, ada kabĩ ege talegef. Lo gouf are, tamo kayau ganan ĩ dõ difiyek!” ");
INSERT INTO dad_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Sifa bun Negur yana dalesauf nigin diselen idi atun, Grik tunĩ difaren. ");
INSERT INTO dad_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Idi Filip Betsaida tamal Galili teneub bun, ĩ garan disi fen, to difiyẽ diron, “Tamo biya, amã Jesus mailau fenẽ.” ");
INSERT INTO dad_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Age de di, Filip ile, Endru iroken ken, uruwom Jesus dirokenen. ");
INSERT INTO dad_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus idi irokenẽdin, “Negur Tamo Naal fula fiya medeĩya ifenẽf nigin, sain anĩ mogo yeir isil. ");
INSERT INTO dad_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aya ã momoi bagai arokeneik, wit faat taka teneub bun kubũ ye fen, to burauf are, faat tekelei dogol agef ibodõf, anĩ ere, ĩ burauf are, faat musei wowã douf. ");
INSERT INTO dad_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tamo ĩ yogon mata nigin wau laa fef are, ĩ mata anĩ itornẽf, anĩ ere, tamo ĩ teneub enei bun, yogon mata atorok bagai ye fen, itorok are, ĩ irounek ile, mata ibodkeleya bun ilauf. ");
INSERT INTO dad_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Taka ĩ aya arunau yalef, ĩ aya dõ fiyauf bagai. Aya abodok nẽ an, neu kabĩ tamo ĩg an ibodõf. Taka ĩ arunau yalef, neu Dei ĩ yana yalesauf. ");
INSERT INTO dad_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Gama neu wau morok, anĩ aya ere auf? ‘Dei sain enei bun usenna,’ auf de? Sã, gariya enei nigin bagai, sain enei bun asin. ");
INSERT INTO dad_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dei ogo yanã selĩ kulõ!” Age ye di, ait taka saa ilunem isin, “Aya mogo anĩ selu abin, aya baban anĩ selu abiyouf.” ");
INSERT INTO dad_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tamo kayau an difaren anĩ karĩ de fen, diron, kolimei den, tunĩ diron, engel takam wogõ fiyem. ");
INSERT INTO dad_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus iron, “Ait enei, ã isenneĩ di, momoi gouf nigin, aya nigin sã. ");
INSERT INTO dad_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gama Negur ĩ, teneub enei nẽ tamo kayau es fedif, gama teneub enei nẽ mudur iruwauf. ");
INSERT INTO dad_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Anĩ ere, aya tenebur tamal dalesnauf sain, aya tamo ganan aya bun, didĩ afediyouf.” ");
INSERT INTO dad_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesus yogo naig fe, laa fouf anĩ ifelnẽdiyouf nigin, od enei wogõ yen. ");
INSERT INTO dad_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tamo kayau aiten dale diron, “Lo bun amã Kristus gai gai ibodõf ya anĩ karĩ maun, naig fe di, õ urok, ‘Tamo Naal ĩ dalesnẽf bagai’? Ai anĩ Tamo Naal?” ");
INSERT INTO dad_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Age de di, Jesus idi irokenẽdin, “Sain naal bagai ã lalan adouf. Ã lalan ado mog, uyõg, anĩ bunem gugum to irousi kerũ yeĩf. Tamo ĩ gugum bun iyok, ĩ naib ilef are keleĩ sã. ");
INSERT INTO dad_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ã lalan ado mog, ãgenei momoiya lalan bun unog, ago gouf, ã lalan gere tar wowã gouf.” Jesus od enei wogõ yel fen, ĩ itorneĩd ile, iminkelen. ");
INSERT INTO dad_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus idi meleid bun memelik musei inodin, anĩ ere, idi fau ĩ nigin to momoi den. ");
INSERT INTO dad_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Enei are profet Asaia nẽ od kisi falauf nigin wõ yen: “Odug, aim nemã od nigin momoi yen? Aiyai bun Odug nẽ megeir yaor fen?” ");
INSERT INTO dad_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Gariya enei nigin, idi momoiya kisi feleya sã, ere nigin, Asaia baban od enei iron: ");
INSERT INTO dad_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Negur idi meleid ifofa ken, waud ifofakelen, anĩ bunem, idi meledim ileya kisi feleya sã, waud fokõya kisi feleya sã, waud faleiya kisi feleya sã, age fiya sam, aya el afedim.” ");
INSERT INTO dad_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Asaia od enei iron, ere nigin, ĩ Jesus nẽ fula fiya medeĩya ile fen, ĩ nigin iron. ");
INSERT INTO dad_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mudur adodo idi atun, museig ĩ nigin momoi den. Anĩ ere, Farisia tamo idim Juda neid uub fõ bun dirudidiya nigin kumĩ de fen, dogo neid momoiya to yaor difen. ");
INSERT INTO dad_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ere nigin, idi Negurem yeneid yaleseya ban, tamom yeneid dalesauf anĩ orodidig. ");
INSERT INTO dad_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus iweig iron, “Tamo ĩ aya nigin momoi yef, ĩ aya nigin dogol to momoi yef, ĩ aya sur fiyan nigineg momoi yef. ");
INSERT INTO dad_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ĩ aya lo fiyaf, im aya sur fiyan anĩ ilef. ");
INSERT INTO dad_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aya lalan anĩ, tenebur ein asin, are taka ĩ aya nigin momoi yef, ĩ gugum bun to ibodõf nigin age afen. ");
INSERT INTO dad_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Taka ĩ neu od karĩ ye fen, to dõ fef, aya ĩ to es afiyek, ere nigin, aya tamo kayau es fiya nigin to asin, aya kel gei fiya nigin asin. ");
INSERT INTO dad_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Taka ĩ aya itorna fen, neu od to irouf, ĩ nigin es fiya tamo ibodok. Od de wogõ aun anim, idikeleya naa bun ĩ es fiyẽf. ");
INSERT INTO dad_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ere nigin, aya neu kisi nem to wogõ aun, anĩ ere, Dei aya sur fiyan im, ere anĩ wogõ auf, naig afe wogõ auf anĩ, toli fiya di, wogõ aun. ");
INSERT INTO dad_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aya keleĩ, yogon si fiya are mata faimud ibodkeleya bun ileya nẽ, anĩ nigin, ereb aya wogõ auf, Dei aya wogõ auf nigin irokanan kilei bagai, aya wogõ auf.” ");
INSERT INTO dad_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasa nẽ Sifa fau wõya sã mog, Jesus kelein, ĩ teneub enei itor ken, Tama garan ileya nẽ sain mogo wõ yel. Ĩ yogon tamo tar tenebur ein dibodok anidi nigin wau laa fedig, ĩ idi nigin wau laa fen are iroule idikeleya bun. ");
INSERT INTO dad_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bõ saaf dõ mog, Satanem Judas Iskariot, Simon naal namen Jesus kiwai imeid bun ifenẽf nigin, kisi mogo ifenen. ");
INSERT INTO dad_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tama ĩ ereb ereb ganan, Jesus ima bun inon, ĩ Negur bunem isin anĩ, Negur bun kel ilef, are Jesus ĩ keleĩ. ");
INSERT INTO dad_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jesus saaf bun ibodon anĩ fã ye, yogon kolos teten inukeis fen, taul yale, luwa gu fen. ");
INSERT INTO dad_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Age fel fen, ĩ naan yale, beĩ bun yu ken, yogon dõ fiya tar yeid kulo fiya gariya inon, agef fen, taul luwa gu fen anim yeid waĩ fedin. ");
INSERT INTO dad_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jesus Simon Pita garan isi di, ĩ Jesus irokenen, “Odug, õ aya yeu kulo wou fenẽ de?” ");
INSERT INTO dad_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus Pita aiten yale irokenen, “Ereb aya age afef, õ gama keleĩ sã, anĩ ere, fau dum õ keleĩ youf.” ");
INSERT INTO dad_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita iron, “Aya yeu to bagai kulo wouf.” Jesus Pita irokenen, “Aya õ to kulo ayõf are, õ aya ado nigal fiya sã.” ");
INSERT INTO dad_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Pita Jesus irokenen, “Odug, agouf are, yeu dogol sã, imau mudurou adog kulo wouf.” ");
INSERT INTO dad_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus aiten yale iron, “Taka ĩ naan igukelel, ye dogol kulo fouf, bouwa ganan filiya. Ã filiya ba, anĩ ere, ã ganan sã.” ");
INSERT INTO dad_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus ĩ aibem kiwai ifenẽf anĩ keleĩ, anĩ nigin, ganan filiya sã yen. ");
INSERT INTO dad_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesus yeid kulof bure fel fen, yogon kolos ifounkel, yogon modoũ bun kelen. Agef fen, ĩ idi to fedin, “Aya ereb ã bun age afel anĩ, ã wedereĩ fokõ yef de? ");
INSERT INTO dad_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ã aya ‘Tise’ ado ‘Odug’ gedig, are tutuk, ere nigin, aya de anĩ. ");
INSERT INTO dad_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aya ãgenei Tise ado Odug, ã yeĩ kulo afel, anĩ nigin, ãg abob ye kulo gouf. ");
INSERT INTO dad_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aya malakanon anokeneim, are ã nigin age afel gen, ãg ago gouf. ");
INSERT INTO dad_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Aya ã momoi bagai arokeneik, ferfer takam yogon odug to wal fiyẽdig, arũ tamom ĩ sur fiyen to wal fiyẽdig. ");
INSERT INTO dad_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Gama ã enei keleĩ, anĩ nigin, enei dõg ago gouf are, ã el yeĩf. ");
INSERT INTO dad_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Aya ã ganan nigin to wogõ auf. Aya agirnẽdin idi, aya keleĩ, anĩ ere, enei are Negur nẽ Itotoya bun yenek anĩ kisi falauf nigin, ‘Taka ĩ aya urom neu bret moko, ĩ aya kiwai ifana fen, dã fiyal.’ ");
INSERT INTO dad_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Anĩ fau to wõ ye mog, gama aya ã arokeneik, anĩ bunem, anĩ wõ youf sain bun, aya de Im ya anĩ momoi gouf. ");
INSERT INTO dad_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aya ã momoi bagai arokeneik, taka ayam sur afe di, ĩ yalef are, ĩ aya yaleyaf, taka ĩ aya yaleyaf are, ĩ aya sur fiyan anĩ yalef.” ");
INSERT INTO dad_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus od enei wogõ yel fen, ĩ wau moro ken, kurõ feis iron, “Aya ã momoi bagai arokeneik, ãgenei takam aya kiwai ifanauf.” ");
INSERT INTO dad_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yogon dõ fiya tar idi abob loli difen, ai nigin bagai wogõ yef de fen, nene den. ");
INSERT INTO dad_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Idi neid taka, dõ fiya taka Jesus ĩ nigin wau laa fedig ĩ, Jesus sirin ibodon. ");
INSERT INTO dad_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Pita, dõ fiya tamo enei mudurem fiye ken, ĩ iron, “Ĩ ai nigin irok anĩ to wiyẽ.” ");
INSERT INTO dad_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dõ fiya tamo anĩ, Jesus akoron mudur isen ken, to fen, “Odug, õ ai wof?” ");
INSERT INTO dad_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus aiten yale iron, “Tamo bret enei beĩ bun nu afe fen, afenẽf anĩ.” Age ye fen, ĩ bret nuf fen, Judas Iskariot, Simon naal ifenen ");
INSERT INTO dad_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas bret anĩ yale di, Satan ĩ namen ilen. Jesus Judas irokenen, “Ereb agou fenẽ, kaisã bagai ago.” ");
INSERT INTO dad_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Anĩ ere, saaf bun dibodon anĩ takam, ere nigin Jesus od enei Judas irokenen anĩ, kisi to fokõ yen. ");
INSERT INTO dad_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ĩ moni lo fiya tamo nigin, tunĩ kisi difen, Sifa nẽ ereb ereb na yalouf nigin be, maleg ereb ereb ifenẽdiya nigin be, Jesusem Judas irokenẽ di, ilef den. ");
INSERT INTO dad_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas ĩ bret yale fen, kaisã bagai oreis ilen. Sain anĩ bõ. ");
INSERT INTO dad_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas iya ile di, Jesus iron, “Gama Tamo Naal fula fiya medeĩya yale di, Negur fula fiya medeĩya Tamo Naal bun yalef. ");
INSERT INTO dad_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Negur fula fiya medeĩya Naal bun yalef are, Negur ĩ fula fiya medeĩya Yogo bun Naal ifenẽf, fula fiya medeĩya anĩ kaisã bagai Naal ifenẽf. ");
INSERT INTO dad_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Neu kesu tar, aya ã geid sain naal bagai tabodõf. Ã aya umirnagauf. Aya Juda tamo arokenẽdin kilei, gama ã arokeneik, aya elef nẽ an, ã isiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Aya ĩtãfiya mata afeneik, abob nigin wauĩ laa fouf. Aya ã nigin wau laa fedig kilei, ãg abob nigin wauĩ laa fouf bagai. ");
INSERT INTO dad_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ã abob nigin wauĩ laa fouf, anĩ bunem tamo ganan idi keleĩ youf, ã neu dõ fiya tamo tar.” ");
INSERT INTO dad_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Pita Jesus to fiyen, “Odug, õ nai ulef?” Jesus iron, “Aya elef nẽ an, õ gama aya dõ fiyaya kisi feleya sã, anĩ ere, õ fau dum dõ wouf.” ");
INSERT INTO dad_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita to fen, “Odug, ere nigin gama aya õ dõ yõya kisi feleya sã? Aya õ nigin neu mata atorõf.” ");
INSERT INTO dad_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Age ye di, Jesus iron, “Õ aya nigin ogon mata utorõf de? Aya õ momoi bagai arokonok, tataro fau kokorok yeya sã mog, õ aya nigin wa wo, towo wouf! ");
INSERT INTO dad_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ã wauĩ to morõ yeĩ. Negur nigin momoi gouf, aya nigineg momoi gouf. ");
INSERT INTO dad_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Neu Dei nẽ fõ bun aab musei ado, age fiya sam are, arokeneim. Aya eselef nẽ an, ãgenei modoũ dodok afouf. ");
INSERT INTO dad_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aya esel, ãgenei modoũ dodok afel fen, aya ã geid tabodõf nigin, aya kelau gei ayeĩf, are ãg aya abodok nẽ an ubodõgouf nigin. ");
INSERT INTO dad_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aya eselef nẽ naab anĩ, ã keleĩ.” ");
INSERT INTO dad_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas Jesus irokenen, “Odug, õ narib ulef are, amã keleĩ sã, anĩ nigin, naig mafe fen, amã naab anĩ keleĩ youf?” ");
INSERT INTO dad_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus Tomas irokenen, “Aya dogol naab anĩ, aya dogol momoi anĩ, aya dogol mata anĩ. Taka ĩ naab taka bunem, Dei wagen to isiyouf, aya bunem dogol. ");
INSERT INTO dad_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ã aya keleim are, ã neu Deig keleim. Gama sain enei bun ilauf, ã ĩ keleĩ, ĩ ulegel.” ");
INSERT INTO dad_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip iron, “Odug, Tamada ufelnamã, anĩ amã nigin deuf.” ");
INSERT INTO dad_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus iron, “Filip, aya ã geid sain meluk tabodon, anĩ ere, õ aya keleĩ sã de? Taka ĩ aya ileyan are Dei ilen. Naig fe di, õ urok, ‘Tamada ufelnamã’? ");
INSERT INTO dad_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Aya Dei bun abodok, Dei aya bun ibodok anĩ to momoi wof de? Od aya wogõ ayeik are, aya yug bun tamal sã, are Dei aya bun ibodok ĩ kabĩ yalef. ");
INSERT INTO dad_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aya Dei bun abodok, Dei ĩ aya bun ibodok anĩ, momoi wiyagauf, sãf are, aya kabĩ aledig bun, momoi wiyagauf. ");
INSERT INTO dad_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aya ã momoi bagai arokeneik, taka ĩ aya nigin momoi yef, ereb aya age afedig, ĩg age fouf, enei age afedig anĩ wal fiyag age fouf, ere nigin, aya Dei gein eselef. ");
INSERT INTO dad_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ã ereb taka nigin, aya yanau nem to gouf, aya age afouf, anĩ bunem, Dei ĩ Naal bun, fula fiya medeĩya yalouf. ");
INSERT INTO dad_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ereb taka nigin, aya yanau nem to wiyagauf are, aya age afouf. ");
INSERT INTO dad_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ã aya nigin wauĩ laa fouf are, neu ĩtãfiya anĩ dõ gouf. ");
INSERT INTO dad_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aya Dei arokenẽ di, ĩ Isenneĩya taka, ã geid gai gai ibodõf nigin ifeneĩf, ");
INSERT INTO dad_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","are momoi nẽ Awa Uur. Tenebur ein tamo kayau ĩ to dalouf, ere nigin, idi ĩ to dilef, to keleĩ. Anĩ ere, ã ĩ keleĩ, ere nigin, ĩ ã geid ibodok, ã bun ibodõf. ");
INSERT INTO dad_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aya ã madmad gen to atorneĩf. Aya ã gein asiyouf. ");
INSERT INTO dad_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sain naal bagai ile di, tenebur ein tamo kayau, aya to dileyauf, anĩ ere, ã uleyagauf. Aya mata abodok nigin, ãg mata ubodõgouf. ");
INSERT INTO dad_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Naa anĩ bun, aya neu Dei bun abodok, ã aya bun ubodõgef, aya ã bun abodok anĩ, ã keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Taka ĩ neu ĩtãfiya irou dõ fef, ĩ aya nigin wau laa fedig. Ĩ aya nigin wau laa fedig anĩ, neu Dei ĩ nigin wau laa fouf, ayag ĩ nigin wau laaf fen, aya yug ĩ bun yaor afouf.” ");
INSERT INTO dad_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Age ye di, Judas taka (Judas Iskariot anĩ sã) iron, “Odug, ere nigin õ ogo, amã bun dogol õ yaorõf, tenebur ein tamo kayau bun sã?” ");
INSERT INTO dad_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus iron, “Taka ĩ aya nigin wau laa fef, ĩ neu od dõ fouf. Neu Dei ĩ nigin wau laa fouf, anĩ amã ĩ gein masi, weim mabodõf. ");
INSERT INTO dad_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Taka ĩ aya nigin to wau laa fef, ĩ neu od to dõ fouf. Od enei ã karĩ gef, are aya bun tamal sã, are Dei aya sur fiyan nẽ od. ");
INSERT INTO dad_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Aya fau ã geid tabod ken, od enei ganan wogõ ayein. ");
INSERT INTO dad_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Anĩ ere, Isenneĩya, Awa Uur Fateul anĩ, Deim aya yanau nem sur fouf, Awa Uur Fateul ĩ, ereb ereb ganan ifelnei ken, aya arokenein anĩ ganan wedereĩ fokõf fen, kisi turĩ fouf. ");
INSERT INTO dad_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Wau inosiya atorkeneik, neu wau inosiya afeneik, aya afeneik are, tenebur ein tamo kayau wau inosiya difeneik gen sã. Ã wauĩ to morõ yei ken, kumĩg. ");
INSERT INTO dad_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Aya eig au di, karĩ gel, ‘Aya ele fen, ã gein kelau asiyouf.’ Ã aya nigin wauĩ laa fem are, aya Dei bun elef anĩ nigin, ã kulĩya adom, ere nigin, Dei ĩ aya wal fiyaya. ");
INSERT INTO dad_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Anĩ wõya sã mog, aya mogo arokeneim, anĩ bunem, agef wõ ye di, ã momoi gouf. ");
INSERT INTO dad_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aya ã geid, sain meluk to wogõ tauf, ere nigin, teneub enei nẽ mudur mogo isif. Anĩ ere, ĩ aya lai fiyaya nigin megeir sã, ");
INSERT INTO dad_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","anĩ ere, tenebur ein tamo kayau keleĩ bagai youf, are aya Dei nigin wau laa fef, anĩ nigin, neu Dei irokanan kilei bagai age afedig. “Fafãg fen, modoũ enei tatorõg. ");
INSERT INTO dad_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Aya aa wain bagai, neu Dei ĩ kabĩ marau. ");
INSERT INTO dad_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Were aya bun biya to yuk anĩ ganan, Deim kokour falauf, were biya yuk anĩ ganan, Deim dẽ fe di, biya musei imauf. ");
INSERT INTO dad_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Aya od wogõ ayein anim, ã amuyẽ sã, ã mogo filiya. ");
INSERT INTO dad_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ã aya bun ubodõgouf, ayag ã bun abodõf. Were taka aa wain luwa ado to susu falauf are, yogo biya yũya kisi feleya sã. Age fiya bagai, ãg aya bun to ubodõgouf are, biya yũya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Aya aa wain gariya, ã were. Taka ĩ aya bun ibodõ di, ayag ĩ bun abodõf are, ĩ biya musei imauf. Aya utornagauf are, ã ereb taka to ago gouf. ");
INSERT INTO dad_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Taka ĩ aya bun to ibodõf are, ĩ were diraile di, meti ledig gen. Were age fediya are gei de fen, yã dirarã di, isasaikelediyouf. ");
INSERT INTO dad_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ã aya bun ubodõge di, neu od ã bun ibodõf are, ereb taka oroyei ken, urokanage di, ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Biya musei ũg fen, neu dõ fiya tar wowã gouf are, neu Dei ĩ fula fiya medeĩya yalouf. ");
INSERT INTO dad_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Neu Dei aya nigin wau laa fedig kilei, ayag ã nigin wau laa fedig. Gama ã neu wau laa fiya anĩ bun ubodõg. ");
INSERT INTO dad_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Aya neu Dei nẽ ĩtãfiya dõ afe fen, yogon wau laa fiya bun abodok kilei, ã neu ĩtãfiya dõ gouf are, neu wau laa fiya bun ubodõgouf. ");
INSERT INTO dad_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Aya enei arokeneim, are neu kulĩya ã namein ibod ken, ãgenei kulĩya barikãf nigin. ");
INSERT INTO dad_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Neu ĩtãfiya are yeir, aya ã nigin wau laa fedig gen, ãg abob nigin wauĩ laa fouf. ");
INSERT INTO dad_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wau laa fiya enei wau laa fiya ganan wal fiya, are yogon mou tar nigin yogon mata itorok anĩ. ");
INSERT INTO dad_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ã aya ereb ĩtãfiya arokenein anĩ dõg, ago gouf are, ã neu mou tar. ");
INSERT INTO dad_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aya baban ã to ferfer ayeĩf, ere nigin, ferfer ĩ yogon tamo odug nẽ kabĩ keleĩ sã. Anĩ ere, aya ã neu mou tar ayeim, ere nigin, ereb ereb ganan aya Dei bun karĩ aun anĩ, aya ã afelneim. ");
INSERT INTO dad_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ãgem aya to ugirnagen, aya ã agirnei ken, uleg, biya ũg fen, biya anĩ ibodkalauf nigin ã ayein. Agog fen, aya yanau nem, ereb taka nigin Dei urokenẽge di, ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Enei anĩ neu ĩtãfiya, abob nigin wauĩ laa fouf. ");
INSERT INTO dad_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Tenebur tamo kiwai difeneĩf are, aya ketem kiwai difanan anĩ, ã keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ã teneub enei nẽf are, ã yogon nigin, ã nigin wau laa fouf. Anĩ ere, ã teneub enei nẽ sã, aya ã tenebur tamal gei ayei ken, agirnein. Anĩ nigin, tenebur ein ã kiwai difeneik. ");
INSERT INTO dad_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aya od arokenein anĩ, ã karĩ walagauf, ‘Ferfer taka yogon odug to wal fedig.’ Idi aya darau difanan are, ãg age de darau difeneĩf. Idi neu od dõ difen are, idi ãgeneig age de dõ difouf. ");
INSERT INTO dad_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Idi enei ganan ã bun age difouf, ere nigin, aya yanau ã ado, are aya sur fiyan idi ĩ keleĩ sã nigin. ");
INSERT INTO dad_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aya to asi fen, arokenẽdim are, idi mosor sam. Anĩ ere, idi neid mosor nigin to galã dũf. ");
INSERT INTO dad_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Taka ĩ aya kiwai ifanaf, ĩ neu Deig kiwai ifenek. ");
INSERT INTO dad_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Taka nem to age fen anĩ, aya idi atun to age afem are, idi mosor sam. Anĩ ere, gama idi memelik dile fen, aya neu Dei ado kiwai difanaman. ");
INSERT INTO dad_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Anĩ ere, enei, idi neid Lo bun ditoton yenek anĩ, kisi falauf nigin, ‘Idi aya mura sã kiwai difanan.’ ");
INSERT INTO dad_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Awa Uur Isenneĩya are, ayam Dei bun tamal ã bun sur afe di, isiyouf, are momoi nẽ Awa Uur, Dei bun tamal ulõ yeis isi fen, ĩ aya nigin kurõ fesiyouf. ");
INSERT INTO dad_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ãg agog kurõ wesigouf bagai, ere nigin, ã aya geid fen, gariya bunem tasin. ");
INSERT INTO dad_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ã to felu rogouf nigin, od enei ganan mogo ã wogõ ayeim. ");
INSERT INTO dad_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Idi ã Juda neid uub fõ bun diruyeĩf. Takag, sain fau isiyouf bun, taka ĩ ã ideneĩkeis fen, kisi fouf, Negur sesewi afiyek youf. ");
INSERT INTO dad_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Idi enei age difouf, ere nigin, idi Dei keleĩ sã, aya nigineg keleĩ sã. ");
INSERT INTO dad_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aya enei mogo arokeneim, are sain isiyouf bun, ã wedereĩ aroul anĩ, karĩ walagauf nigin. Aya enei tetun to arokenein, ere nigin, aya ã geiden. ");
INSERT INTO dad_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Gama aya ĩ sur fiyan gein eselef, anĩ ere, ã takam to aya to fiyaf, ‘Õ nai ulef?’ ");
INSERT INTO dad_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aya enei arokeneim nigin, ã fatuk bagai wauĩ gudũ fef. ");
INSERT INTO dad_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Anĩ ere, aya momoi arokeneik, aya ãgenei biya fiya nigin eselef. Aya to eselauf are, Isenneĩya anĩ ã bun to isiyouf, aya eselauf are, aya ĩ, ã bun sur afouf. ");
INSERT INTO dad_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sain ĩ isiyouf, tenebur ein tamo kayau bun, mosor nigin, Negur nẽ madur fiya nigin ado, Negur nẽ es fiya nigin, idi neid kũ fenẽya anĩ yaor fe, faded fediyouf. ");
INSERT INTO dad_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mosor are, idi aya nigin to momoi def nigin. ");
INSERT INTO dad_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Negur nẽ madur fiya are, aya Dei gein esele di, ã aya to uleyagauf nigin. ");
INSERT INTO dad_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Negur nẽ es fiya are, teneub enei nẽ mudur mogo es fiyen nigin. ");
INSERT INTO dad_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Aya ã irokeneĩya nigin musei biya, anĩ ere, ã gama keleĩya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Anĩ ere, sain momoi nẽ Awa Uur isiyouf bun, momoi nẽ anĩ ganan bun, im itoneĩf. Ĩ yogon kisim to wogõ youf, ereb ĩ karĩ yef anĩ wogõ youf, agef fen, ereb fau wõ youf anĩ irokeneĩf. ");
INSERT INTO dad_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ĩ neu bun tamal yale fen, ã ifelneĩf, anĩ bunem, aya fula fiya medeĩya ifanauf. ");
INSERT INTO dad_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dei nẽ ganan are neu, anĩ nigin, aya arom, Awa Uur neu bun tamal yale fen, ã ifelneĩf aul. ");
INSERT INTO dad_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Sain naal bagai ile di, ã to uleyagauf, agef fen, baban sain naal bagai ile di, aya uleyagauf.” ");
INSERT INTO dad_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","In dõ fiya tar tunĩ abob dirokenen, “Ere gariya nigin eig ye irok, ‘Sain naal bagai ile di, ã to uleyagauf, agef fen, baban sain naal bagai ile di, aya uleyagauf,’ takag, ‘Ere nigin, aya Dei gein eselef nigin,’ yef?” ");
INSERT INTO dad_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Idi anĩ fau fau wogõ den, “Ĩ ere ye fen, ‘sain naal bagai’ yen? Ĩ irok anĩ, amã gariya keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Idi enei nigin Jesus to difou fenẽ mog, Jesus anĩ ile fen, idi irokenẽdin, “Aya eig aul anĩ nẽ gariya nigin abob to wiyẽgef de, ‘Sain naal bagai ile di, ã to uleyagauf, agef fen, baban sain naal bagai ile di, aya uleyagauf’? ");
INSERT INTO dad_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aya ã momoi bagai arokeneik, ã fau maruĩ isi fen, wauĩ gudũ fouf, tenebur tamo kayau kulĩ de mog. Ã wauĩ gudũ fouf, anĩ ere, ãgenei wauĩ gudũ fiya falei yel kulĩ youf. ");
INSERT INTO dad_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kayau kesu ibodõ fenẽ darau fef, ere nigin, yogon naa wõ yel, anĩ ere, yogon kesu wõ ye di, darau weder tu kelef, ere nigin, kesu tenebur wõ yel nigin kulĩ yef. ");
INSERT INTO dad_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ãg age fiya, gama ãgenei wauĩ gudũ fiya nẽ naa, anĩ ere, aya baban ailiyeĩ di, ã kulĩ gouf, taka nem ãgenei kulĩya to yalelkeneĩf. ");
INSERT INTO dad_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Naa anĩ bun, ereb taka nigin ã to, to wiyagauf. Aya ã momoi bagai arokeneik, aya yanau bunem, ereb taka nigin neu Dei to wiyẽgouf are, ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Uruwa bunem isi gama, aya yanau nem, ereb taka nigin to, to gen. To gouf, walogouf, ago gouf, ã kulĩya barikãf. ");
INSERT INTO dad_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Aya yaab od wogõ audig, anĩ naa taka isiyouf bun, aya yaab od to wogõ auf, anĩ ere, neu Dei nigin yaor arokeneĩf. ");
INSERT INTO dad_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Naa anĩ bun, aya yanau bunem to gouf. Aya ã nigin Dei to afiyẽf ya anĩ to arokeneik, ");
INSERT INTO dad_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ere nigin, ã aya nigin wauĩ laaf fen, aya Negur bun tamal asin anĩ, momoi gedig nigin, Dei ã nigin wau laa fedig. ");
INSERT INTO dad_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Aya Dei bun tamal ulõ aus fen, tenebur asin, gama aya teneub enei ator ken, Dei bun kelauf.” ");
INSERT INTO dad_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Age ye di, Jesus nẽ dõ fiya tar diron, “Gama õ yaor wogõ wof, yaab od nem sã. ");
INSERT INTO dad_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gama amã mailef, õ ereb ereb ganan keleĩ, are taka nem to yõf anĩg to tari wodig. Anĩ bunem, õ Negur bun tamal usin anĩ, momoi mauf.” ");
INSERT INTO dad_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus aitedin yale iron, “Ã gama momoi gef de? ");
INSERT INTO dad_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Anĩ ere, naa fau isif, are mogo isil, anĩ bun, ã firagagaũ yeĩ, ãgenei fonõ fonõ yeĩf. Ã aya mugu utornagauf. Anĩ ere, aya mugu sã, ere nigin, neu Dei ĩ aya ado. ");
INSERT INTO dad_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ã aya bun wauĩ inosiya adouf nigin, od enei arokeneim. Tenebur ein ã morõ adouf, anĩ ere, totol ado ufaragauf! Aya teneub enei nẽ megeir mogo wal afen.” ");
INSERT INTO dad_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus od enei wogõ yel fen, saa ilun itad fen, kosẽ yen: “Dei, naa mogo isil, fula fiya medeĩya õ Naal wenẽ, ago di, õ Naal õ selĩ kulõ fouf. ");
INSERT INTO dad_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Are õ Naal, idi ganan õ wenen bun, mata faimud ibodkeleya ifenẽdiyouf nigin, tamo kayau ganan lo fediya nẽ megeir õ wenen. ");
INSERT INTO dad_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mata faimud ibodkeleya are yeir, õ momoi Negur tekelei ado Jesus Kristus õ sur won anĩ, idi keleĩ youf anĩ. ");
INSERT INTO dad_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kabĩ õ wanan anĩ adikelen bunem, tenebur ein aya õ bun fula fiya medeĩya arou asin. ");
INSERT INTO dad_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Dei, teneub kare fiya sã mog, ada urom fula fiya medeĩya adon anĩ, õ malã bun fula fiya medeĩya anĩ gama wana. ");
INSERT INTO dad_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Aya teneub enei bun tamal õ wanan idi bun, õ yaor ayon. Idi ogon, anĩ ere, õ idi wanan, ago di, idi ogon od dõ difedig. ");
INSERT INTO dad_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Gama idi keleĩ, ereb ereb ganan aya wanan are õ bun tamal. ");
INSERT INTO dad_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Aya od wanan anĩ afenẽdi di, idi dalen. Aya õ bun tamal asin anĩ, idi momoi bagai kelein, idi onom aya sur wiyan anĩ momoi den. ");
INSERT INTO dad_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Aya idi nigin kosẽ auf. Aya teneub enei nẽ tamo kayau nigin to kosẽ auf, anĩ ere, idi õ wanan anidi nigin kosẽ auf, ere nigin, idi ogon. ");
INSERT INTO dad_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Neu ganan are ogon, ogon are neu. Idi bunem, aya fula fiya medeĩya alel. ");
INSERT INTO dad_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aya tenebur ein to abodõf, anĩ ere, idi fau tenebur dibodok, aya õ gein esef. Dei Fateul, õ yanã wanan nẽ megeir bunem, kulatun wediyouf, anĩ bunem, ada tekelei gen idig tekelei youf. ");
INSERT INTO dad_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sain aya idi geid mabodon, õ aya yanã wanan anĩ bunem, kulatun afeid el afen. Taka to fõ yelen, tamo ĩ fõ yalauf nẽ dogol fõ yelen, are Negur nẽ Itotoya kisi falauf nigin. ");
INSERT INTO dad_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Gama aya õ gein esef, neu kulĩya idi namedin barikãf nigin, tenebur ein fau abod ken, od enei arok. ");
INSERT INTO dad_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Aya ogon od afenẽdi di, teneub enei nẽ tamo kayau idi kiwai difenẽdin, ere nigin, gama aya teneub enei nẽ sã, age fiya gen, idig teneub enei nẽ sã. ");
INSERT INTO dad_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aya teneub enei bun tamal walelnẽdiyouf nigin to kosẽ auf, anĩ ere, wadãgen tamo sane isi fen, daũ fediya nigin, kulatun wediyouf anĩ kosẽ auf. ");
INSERT INTO dad_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Aya teneub enei nẽ sã, age fiya gen, idig teneub enei nẽ sã. ");
INSERT INTO dad_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Momoi bunem fateul unenẽdiyouf, ogon od are momoi. ");
INSERT INTO dad_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Õ teneubur ein sur wiyan gen, ayag teneub enei bun sur afiyẽdin. ");
INSERT INTO dad_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Idi nigin, aya yug adok bagai afonok, are idig momoi bagai dogo adok Negur difenẽf nigin. ");
INSERT INTO dad_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Aya neu kosẽya are idi nigin dogol sã, idi neid od bunem, aya nigin momoi douf anidi nigineg, aya kosẽ auf, ");
INSERT INTO dad_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","idi ganan tekelei youf nigin kosẽ auf, Dei õ aya bun ubodok, aya õ bun abodok gen, idig ada bun dibodõ di, teneub enei nẽ tamo kayau, onom aya sur wiyan anĩ, momoi douf nigin. ");
INSERT INTO dad_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Fula fiya medeĩya õ wanan anĩ, idi afenẽdin, are ada tekelei gen, idig tekelei youf nigin. ");
INSERT INTO dad_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aya idi bun, õ aya bun, are idi tekelei youf nigin, anĩ bunem, onom aya sur wiya fen, aya nigin waũ laa fedig gen, idi nigineg waũ laa fedig anĩ, teneub enei nẽ tamo kayau keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Dei, idi õ aya wanan anidi, aya abodok nẽ an, aya geid mabodõf anĩ orouf, are idi neu fula fiya medeĩya dilouf nigin, fula fiya medeĩya anĩ teneub kare fiya sã mog, õ aya nigin waũ laaf fen, wanan anĩ. ");
INSERT INTO dad_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Dei madur bagai, teneub enei nẽ tamo kayau idi õ keleĩ sã, anĩ ere, aya õ keleĩ, neu dõ fiya tar idi, onom aya sur wiyan anĩ keleĩ. ");
INSERT INTO dad_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aya õ anĩ afelnẽdi di, idi õ keleĩ, õ nigin fau fau afelnẽdif alauf, are õ aya nigin waũ laa fiya anĩ, idi bun ibodõf ado, ayag idi bun abodõf nigin.” ");
INSERT INTO dad_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus od enei wogõ yel fen, ĩ yogon dõ fiya tar geid, Kidron naan uus atu dilen. Kidron sitakã kabĩ taka ibodon, ĩ yogon dõ fiya tar geid, kabĩ atu dilen. ");
INSERT INTO dad_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kiwai tamo Judas ĩ modoũ anĩ keleĩ, ere nigin, sain musei Jesus in dõ fiya tar geid an guru difedig. ");
INSERT INTO dad_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Anĩ nigin, Judas, kusĩ tamo tunĩ ado, tempel lo fiya tamo tunĩ pris mudur adodo Farisia tamo geid idim sur difedin anidi geif fen, kabier uyu ile di, dilen. Idi yal, lam, kusĩ nẽ waila guri de fen, dilen. ");
INSERT INTO dad_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus, ĩ bun wõ youf anĩ ganan kelein, ĩ iyok ile to fedin, “Ã ai umirnẽgef?” ");
INSERT INTO dad_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Idi diron, “Jesus Nasaret tamal.” Jesus iron, “Aya im.” Kiwai tamo Judas, idi geid an difaren. ");
INSERT INTO dad_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sain Jesus iron, “Aya im,” ye di, idi soso de dile, tenebur kuku den. ");
INSERT INTO dad_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesus baban idi to fedin, “Ã ai umirnẽgef?” Idi diron, “Jesus Nasaret tamal.” ");
INSERT INTO dad_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus iron, “Aya ã arokeneim, aya im. Aya anĩ umirnagauf are, tamo eneidi utornẽdig len, dile.” ");
INSERT INTO dad_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Agef iron are, od Jesus wogõ yen anĩ kisi falauf nigin, “Aya õ wanan anidi taka to folõ afelen.” ");
INSERT INTO dad_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Age dife di, Simon Pita ĩ, dimig adon anĩ ul feis yale, pris neid mudur nẽ ferfer weder biya melem salõf iran. Ferfer anĩ yana Malkus. ");
INSERT INTO dad_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Age fe di, Jesus Pita irokenen, “Ogon dimig yogon modoũ bun kel uno! Dei aya naan kap ifanan anĩ, aya to ãf de?” ");
INSERT INTO dad_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Age ye di, kusĩ tamo, nedi mudur, Juda neid tempel lo fiya tamo geid, Jesus dalen. Idi ĩ difo ken, ");
INSERT INTO dad_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anas garan ket dirou dilen, Anas ĩ, Kaiafas ne ten, yar anĩ bun Kaiafas ĩ pris neid mudur ibodon. ");
INSERT INTO dad_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas im, Juda tamo kayau wedereid irou fen, tamo tekeleim tamo kayau ganan nigin laa fouf, are deuf, yen. ");
INSERT INTO dad_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pita, Jesus nẽ dõ fiya tar taka ado, Jesus dõ difen. Pris neid mudur, dõ fiya tar taka anĩ keleĩ, anĩ nigin, ĩ Jesus ado, pris neid mudur nẽ fofomalan kau namen dilen. ");
INSERT INTO dad_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Anĩ ere, Pita ĩ serẽ bobogen ifaren. In dõ fiya taka ĩ pris neid mudur ĩ nigin keleĩ, ĩ baban serẽ ke len, bobog lo fiya kayau iroken ken, Pita yale irou, namen dilen. ");
INSERT INTO dad_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kabĩ kayau bobog lo fedig ĩ, Pita to fiyen, “Õg be, in dõ fiya tamo taka anĩ sã de?” Pita iron, “Aya sã.” ");
INSERT INTO dad_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Menig nigin, ferfer, tempel lo fiya tamo geid, yã kũ de fen, salili de, bouweid diroron. Pita ĩg weim difar fen, bouwa iroron. ");
INSERT INTO dad_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Fõ namen, pris neid mudur, Jesus ĩ, in dõ fiya tar nigin ado, yogon od tai fedin nigin to fiyen. ");
INSERT INTO dad_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus solof iron, “Aya tamo kayau atun, mala yaor wogõ aun. Aya sain faimud Juda neid uub fõ bun be, tempel bun, Juda tamo kayau ganan guru de mog, wogõ audig. Aya iminẽyan taka to wogõ aun. ");
INSERT INTO dad_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ere nigin anĩ aya to wiyaf? Idi aya wogõ au di, karĩ difiyan onou idi to wiyeĩd. Ereb aya wogõ aun, idi keleĩ.” ");
INSERT INTO dad_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus age ye irõ di, tempel lo fiya tamo taka non ifaren anim, Jesus wala fãf fen, iron, “Pris neid mudur anĩ, õ ago urokenẽdig de?” ");
INSERT INTO dad_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus solof irokenen, “Aya ereb kũ fenẽya arom are, õ ereb kũ fenẽya anĩ urõf. Anĩ ere, aya momoi arom are, ere nigin õ walau fã wol?” ");
INSERT INTO dad_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Age ye di, Anas Jesus difon ado, pris neid mudur Kaiafas gein sur fen. ");
INSERT INTO dad_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Pita bouwa irorouk ifar mog, idi ĩ to difiyen, “Õg be, in dõ fiya tamo taka anĩ sã de?” Ĩ waf fen, iron, “Aya sã.” ");
INSERT INTO dad_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pris mudur nẽ ferfer taka, ĩ Pitam weder salõf iran nẽ sirag anim iron, “Aya õ ĩ urom kabier to ailiyeim de?” ");
INSERT INTO dad_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita baban waf mog, kaisã bagai tataro kokorok yen. ");
INSERT INTO dad_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Age fe di, Juda tamo, Jesus Kaiafas bun tamal dale dirou, Rom gawaman mudur nẽ fõ bun dilen. Are bonimei bagai, Juda tamo idi Pasa nẽ saaf dãf nigin, kal sese de fen, gawaman mudur nẽ fõ namen to dilen. ");
INSERT INTO dad_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Anĩ nigin, Pailat idi gedin ulõ yeis isi fen, to fedin, “Ere od ã tamo enei bou bun unogouf?” ");
INSERT INTO dad_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Idi solo de diron, “Ĩ lo wal fiya tamo sam are, amã õ gein to marou masim.” ");
INSERT INTO dad_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat idi irokenẽdin, “Ã aug ĩ waleg fen, ãgenei lo bun es wiyẽg.” Juda tamo idi Pailat dirokenen, “Amam tamo yukesiya nigin Rom gawaman to yo faman.” ");
INSERT INTO dad_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Are Jesus ĩ naig be fe, laa fouf nigin wogõ yen anĩ, kisi falauf nigin agef wõ yen. ");
INSERT INTO dad_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Age de di, Pailat aaben kel ile, Jesus iweigne ken, to fiyen, “Õ Juda neid king de?” ");
INSERT INTO dad_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus solof iron, “Õ ogon kisim od enei urok de, tunim be aya nigin õ dirokonon?” ");
INSERT INTO dad_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat solof iron, “Aya Juda tamo de? Õ ogon tamo kayaum pris odudug geid, aya bun dirousiyom. Õ ere taka tau agon?” ");
INSERT INTO dad_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus iron, “Aya neu tano teneub enei nẽ sã. Aya neu tano teneub enei nem are, neu kabĩ tamo, Juda tamom aya to daleyauf nigin kusĩ dem. Anĩ ere, neu tano teneub enei nẽ sã.” ");
INSERT INTO dad_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Age ye di, Pailat Jesus irokenen, “Age fouf, õ king de?” Jesus solof iron, “Õ ogo yer urok, aya king. Enei nigin aya wõ aun, are momoi anĩ wogõ auf nigin, anĩ nigin, aya tenebur asin. Momoi nẽ ganan, aya karĩ difiyadig.” ");
INSERT INTO dad_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat to fen, “Ere anĩ momoi?” Age yel fen, ĩ baban Juda tamo gedin serẽ ile, idi irokenẽdin, “Aya ĩ bun mosor taka to ailef. ");
INSERT INTO dad_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Anĩ ere, ãgenei tobonuneĩ eig fiya, Pasa naa bun, kalabus tamo taka aliskeneĩdig. Ã Juda neid king aliskeneĩf anĩ oroyeik de?” ");
INSERT INTO dad_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Idi baban diweig, solo de diron, “Sã, ĩ sã! Barabas anĩ wanamãf!” Barabas ĩ anĩ bẽ tamal. ");
INSERT INTO dad_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Age de di, Pailat Jesus yale fen, irõ di, wagĩ difiyen. ");
INSERT INTO dad_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kusĩ tamo malũ duri ado dale, teter tanak kori de fen, ĩ mudur bun kurũ difiyen. Idi gabar kadaũ dale difounne ken, ");
INSERT INTO dad_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","idi baba baban ĩ wagen dile fen, diron, “O Juda neid king gai gai ibodõf!” Age de fen, wala fã difen. ");
INSERT INTO dad_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat baban serẽ kel isi fen, Juda tamo irokenẽdin, “Ulegef, aya ĩ bun mosor taka to ailef anĩ, ã keleĩ youf nigin, ĩ ã gein arou asif.” ");
INSERT INTO dad_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sain Jesus malũ duri kurũ difiyen, gabar kadaũ difounnen ado, serẽ isi di, Pailat idi irokenẽdin, “Tamo are yeir!” ");
INSERT INTO dad_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pris odudug, tempel lo fiya tamo geid, ĩ dile fen, diweig diron, “Aa tetek bun ũf! Aa tetek bun ũf!” Anĩ ere, Pailat idi irokenẽdin, “Ã aug waleg, aa tetek bun ũg. Aya ĩ bun mosor taka to ailef.” ");
INSERT INTO dad_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Juda tamo idi solo de diron, “Amã nemã lo ado, lo anĩ kilei ĩ laa fouf, ere nigin, ĩ yogo aya Negur Naal yedig.” ");
INSERT INTO dad_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Od enei Pailat karĩ ye fen, fatuk bagai kumĩ yen. ");
INSERT INTO dad_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ĩ baban fõ aaben kel ile fen, Jesus to fiyen, “Õ nain tamal?” Anĩ ere, Jesus aiten to yalen. ");
INSERT INTO dad_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat Jesus irokenen, “Õ aya od to urokanauf de? Aya õ kafĩ fiya bun tamal yalelnõya nigin megeir ado, õ aa tetek bun inõya nigineg megeir ado anĩ, õ keleĩ sã de?” ");
INSERT INTO dad_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus solof iron, “Ilun tamal megeir õ to ifonom are, aya ogon megeir farumen to abodom. Anĩ nigin, tamo taka ĩ aya õ imã bun inenan, ĩ yogon mosor odug bagai, ogon wal fiya.” ");
INSERT INTO dad_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jesus Pailat age fiyẽ di, Pailat Jesus kafĩ fiya bun tamal yalisnẽf nigin, naab imiren, anĩ ere, Juda tamo idi diweig diron, “Õ tamo enei utornẽ di, ilauf are, õ Sisa nẽ mou sã. Taka ĩ yogo anĩ king yef, ĩ Sisa kiwai ifenek.” ");
INSERT INTO dad_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat od enei karĩ ye fen, Jesus serẽ yale irou isi fen, es fiya tamo nẽ sia, Meein Bedu dedig modoũ bun ibodon (Meein Bedu are, Hibru od nem yana Gabata). ");
INSERT INTO dad_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Naa are Pasa Sifa nigin dodok fiya naa, gaa atun age fiya, naa anĩ ilele di, Pasa naa wõ youf. Pailat Juda tamo idi irokenẽdin, “Ãgenei king yeir.” ");
INSERT INTO dad_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Anĩ ere, idi diweig diron, “Uru uraile! Uru uraile! Aa tetek bun ũ!” Pailat to fen, “Aya ãgenei king aa tetek bun aũf de?” Pris odudug solo de diron, “Amã king taka sã, Sisa dogol.” ");
INSERT INTO dad_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Anĩ nigin, Pailat Jesus aa tetek bun dũf nigin, idi imeid bun inon. Anĩ nigin, kusĩ tamo Jesus dalen. ");
INSERT INTO dad_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ĩ yogon aa tetek faali fe, modoũ Mudur Tuwan (Hibru od nem Golgota dedig) iselen. ");
INSERT INTO dad_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","An idi Jesus aa tetek bun dun, tamo uru idig, ĩ geid aa tetek bun didenen, idi urom si sitakã, Jesus atun. ");
INSERT INTO dad_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat irõ di, eig de ditot fen, aa tetek bun degẽ difen: JESUS NASARET TAMAL, JUDA NEID KING. ");
INSERT INTO dad_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Juda tamo kayau musei itotoya enei diwesen, ere nigin, Jesus aa tetek bun dun modoũ are taun non. Itotoya are Hibru od nem, Rom od nem, Grik od nem. ");
INSERT INTO dad_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Juda neid pris odudug Pailat dirokenen, “To ‘Juda neid King’ wo utot, anĩ ere, tamo enei yogo aya Juda neid king yen, ago utot.” ");
INSERT INTO dad_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat aitedin yale iron, “Ereb aya atoton, are de agef ibodõf.” ");
INSERT INTO dad_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sain kusĩ tamo Jesus aa tetek bun du ken, Jesus nẽ kolos gei difeid, aiwa adodo foi difen, are teke tekelei kusĩ tamo mugu mugum gei difen, kolos meluk ilon tamal dogol foi fiya sã. Kolos are meluk tekelei tokõ feleya diwan. ");
INSERT INTO dad_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Idi abob dirokenen, “Ada anĩ to serek tafouf, ada aisaĩ tara ken, aibem yalouf anĩ tailauf.” Negur nẽ Itotoya eig ye irok anĩ kisi falauf nigin, agef wõ yen, “Neu kolos idi atun foi difeid fen, neu kolos meluk nigin aisaĩ diran.” Anĩ nigin, kusĩ tamo idi enei age difen. ");
INSERT INTO dad_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesus nẽ aa tetek sirin, Jesus sina, sina nẽ tura, Maria Kolopas aiwa, Maria Magdala tamal an difaren. ");
INSERT INTO dad_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sain Jesus mala irã, sina ado in dõ fiya tamo taka ĩ nigin wau laa fedig non difar mog, ileid fen, Jesus ĩ sina irokenen, “Kayau, õ naal yeir.” ");
INSERT INTO dad_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Age ye fen, Jesus yogon dõ fiya tamo irokenen, “Enei ogon sinã.” Naa anĩ bunem ilen, dõ fiya tamo enei sinawau yale, yogon fõ bun iroule, kulatun fiyen. ");
INSERT INTO dad_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Anĩ dumen, Jesus keleĩ, ereb ereb ganan mogo gama bure felel, Negur nẽ Itotoya bun ibodok anĩ kisi falauf nigin, Jesus iron, “Aya naan ail fiyaf.” ");
INSERT INTO dad_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wain makik yag ado an ibodon, idi spons dale, wain bun nu dife, aa hisop were bun dino fen, dales, Jesus sigoron dinon. ");
INSERT INTO dad_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus wain makik anĩ yale fen, iron, “Gama bure.” Age yel fen, guyu kureis, yogon uur itoron. ");
INSERT INTO dad_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Gama naa are dodok fiya nẽ, we fele di, are Sabat naa, Sabat anĩ are, uub odug. Juda tamo idi, Sabat naa bun, bouweid aa tetek bun ifareya ditorõdig, anĩ nigin, idi yeid weweur difeid, bouweid gei difalaisiyouf nigin, Pailat dirokenen. ");
INSERT INTO dad_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Anĩ nigin, kusĩ tamo disin, tamo taka ket ye weweur difen, takag age difen, idi Jesus geid, aa tetek bun didenen anidi. ");
INSERT INTO dad_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Anĩ ere, idi Jesus wagen disi fen, ĩ mogo laa fen anĩ dilen, anĩ nigin, idi ĩ ye to weweur difen. ");
INSERT INTO dad_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Anĩ fotokar, kusĩ tamo takam, ot nem Jesus siri gilĩ fe di, naud naan ado fi felen. ");
INSERT INTO dad_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tamo enei ilen im wogõ yen, yogon wogõya are momoi, ĩ keleĩ, ĩ momoi wogõ yef, are ãg momoi gouf nigin wogõ yef. ");
INSERT INTO dad_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Negur nẽ Itotoya enei kisi falauf nigin agef wõ yen, “Yogon tuwa taka to were fouf,” ");
INSERT INTO dad_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","agef fen, Negur nẽ Itotoya takag irok, “Idi siri gilĩ difen tamo ĩ, idim dilouf.” ");
INSERT INTO dad_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Anĩ dum, Josef Arimatea tamal, Jesus bouwa buru yalouf nigin Pailat irokenen. Josef ĩ, Jesus nẽ dõ fiya tamo taka, anĩ ere, ĩ Juda tamo nigin kumĩ ye fen, iminẽyan Jesus dõ fen. Pailat yo ye di, ĩ isi, Jesus bouwa yalen. ");
INSERT INTO dad_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Josef ĩ Nikodemus ado fen, disin, kulu tamo anim, bõ Jesus gein ilen. Nikodemus ĩ, marasin yana mer (myrrh) aloi (aloe) ado falei difen anĩ iroulen, anĩ nẽ morõ teti kilogram age fiya. ");
INSERT INTO dad_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Idi urom Jesus bouwa dale, marasin ado gabar lalau nem filu difen. Juda neid tamo mũ fiya tobonunã bunem age difen. ");
INSERT INTO dad_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesus aa tetek bun dun nẽ modoũ an, kabĩ taka ado, kabier an, ku mata taka ado, taka an to goro difen. ");
INSERT INTO dad_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Naa are Juda neid dodok fiya nẽ naa nigin ado, tokõ kug melsã nigin, idi Jesus an goro difen. ");
INSERT INTO dad_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Uub nẽ naa matu Sande bun, bonimei bagai gugum ado, Maria Magdala tamal matmat bun ile fen, mala irã, bobog bun meein yaleleya ilen. ");
INSERT INTO dad_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Anĩ kayau, Simon Pita, dõ fiya taka Jesus ĩ nigin wau laa fedig anidi gedin gudu ref ile, irokenẽdin, “Idi Odug matmat bun tamal dale diroulen, ĩ nain be dinon, ada keleĩ sã!” ");
INSERT INTO dad_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Anĩ nigin, Pita, dõ fiya tamo taka ado, matmat bun dilen. ");
INSERT INTO dad_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Urom gududu den, anĩ ere, dõ fiya tamo takam Pita wal fe, ĩ ket matmat bun wõ yen. ");
INSERT INTO dad_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ĩ iti ken, fai yen, gabar lalau filu difen anĩ an yen mog, ilen, anĩ ere, ĩ kuren to ilen. ");
INSERT INTO dad_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Age fe di, Simon Pita dum dõ fiyen, wõ ye fen, tokõ fel, matmat kuren ile, gabar lalau filu difen an yen mog, ilen, ");
INSERT INTO dad_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mũ difen gabar Jesus mudur sile difen anĩg ilen. Mudur sile difen gabar are, yogo fire kori fel, gabar lalau filu difen anĩ firen ibodon. ");
INSERT INTO dad_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Age fe di, dõ fiya tamo taka, ĩ ket matmat bun wõ yen ĩg, kuren ilen. Ĩ ile fen, momoi yen. ");
INSERT INTO dad_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Jesus laa bun tamal kel fã youf ya, Negur nẽ Itotoya bun yenek anĩ, idi fau wedereid fokõya sã.) ");
INSERT INTO dad_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Age de fen, dõ fiya tar, nedi fõ bun ke de dilen. ");
INSERT INTO dad_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Anĩ ere, Maria matmat serẽ inã yalef ifaren. Ĩ inã ado inã ado iti ken, matmat namen fai yen. ");
INSERT INTO dad_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Agef fen, ĩ, engel uru kolos lalau adodo, Jesus yenen modoũ bun dibod mog, iledin, taka muduren, taka yen. ");
INSERT INTO dad_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Idi ĩ to difiyen, “Kayau, õ ere nigin inã walef?” Maria iron, “Idi neu Odug dale diroulen, ĩ nain be dinon anĩ, aya keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Age ye fen, ĩ falei yel, Jesus an ifar mog ilen, anĩ ere, are Jesusem ya anĩ to kelein. ");
INSERT INTO dad_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus iron, “Kayau, õ ere nigin inã walef? Õ ai anĩ umirnek?” Maria kisi fen, ĩ kabĩ lo fedig anim ye fen, irokenen, “Tamo biya, onom ĩ wale uroulen ouf are, nain be unon anĩ, aya urokana di, aya ĩ alouf.” ");
INSERT INTO dad_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus ĩ irokenen, “Maria.” Maria ĩ falei yel, Jesus wage ifen ken, Hibru od nem irokenen, “Raboni!” (anĩ nẽ gariya, Tise). ");
INSERT INTO dad_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus iron, “Aya to urouna, ere nigin, aya Dei gein fau kel iseleya sã. Anĩ ere, neu turau tar gedin ule urokeneĩd, ‘Aya neu Dei, ãgenei Temeĩ, neu Negur, ãgenei Negur bun kelau eselauf.’” ");
INSERT INTO dad_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Anĩ nigin, Maria Magdala tamal, in dõ fiya tar gedin ile irokenẽdin, “Aya Odug ailel!” Age ye fen, Maria Jesus od enei irokenen anĩ, idi wogõ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Uub nẽ naa matu Sande aragau anĩ bun, Jesus nẽ dõ fiya tar, Juda tamo nigin kumĩ de fen, sukar kotũ difel, aaben guru de dibod mog, Jesus isi, idi atun ifar fen, iron, “Wau inosiya ã ado ibodõf!” ");
INSERT INTO dad_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Od enĩ irokel fen, ĩ ima siri ado idi ifelnẽdin. In dõ fiya tar idi, Odug dile fen, fatuk bagai kulĩ den. ");
INSERT INTO dad_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus baban iron, “Wau inosiya ã ado ibodõf! Dei aya sur fiyan gen, ayag ã sur ayeik.” ");
INSERT INTO dad_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Age ye fen, idi bun fuu fiyeĩd fen, iron, “Awa Uur Fateul waleg. ");
INSERT INTO dad_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ã, tamo neid mosor nigin, wedereĩ tu kalauf are, idi neid mosor nigin weder tu kelef, ã idi neid mosor nigin, wedereĩ to tu kalauf are, idi neid mosor nigin weder to tu kelef.” ");
INSERT INTO dad_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Anĩ ere, Jesus in dõ fiya tar meleid bun wõ yen sain, tuwelf idi neid taka Tomas (yana taka Didimus), idi geid to ibodon. ");
INSERT INTO dad_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Anĩ nigin, dõ fiya tar tunim ĩ dirokenen, “Amã Odug mailen!” Anĩ ere, ĩ idi irokenẽdin, “Aya yogon ima bun tuti ba to ailauf, aya imau gege tuti ba bun to ano fen, aya imau siri bun to anouf, aya to momoi auf.” ");
INSERT INTO dad_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Uub tekelei ilele di, in dõ fiya tar baban fõ bun dibodon, are Tomas geid. Sukar kotũ difedin, anĩ ere, Jesus isi, idi atun ifar fen, iron, “Wau inosiya ã ado ibodõf!” ");
INSERT INTO dad_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Agef fen, Jesus Tomas irokenen, “Ogon imã gege ein uno, neu imau uleid. Imã urã siru bun uno. Waũ to ilef isif fouf, momoi dogol wo.” ");
INSERT INTO dad_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas Jesus irokenen, “Neu Odug, neu Negur!” ");
INSERT INTO dad_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Age ye di, Jesus Tomas irokenen, “Õ malam aya uleyaf nigin, momoi wof. Idi meledim to dile fen, momoi def, are el fedif.” ");
INSERT INTO dad_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus, in dõ fiya tar meleid bun, memelik musei inodin, are buk enei bun itotoya san. ");
INSERT INTO dad_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Anĩ ere, Jesus ĩ Kristus, Negur Naal anĩ ã momoi ge fen, ĩ yana nigin momoiya bunem, ã mata walogouf nigin enei itoton. ");
INSERT INTO dad_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Anĩ dum, Jesus baban in dõ fiya tar gedin, Taiberias daliyoun wõ yen. Anĩ eig fe wõ yen. ");
INSERT INTO dad_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Pita, Tomas (yana taka Didimus), Nataniel Kana tamal Galili teneub bun, Sebedi gere tar ado, dõ fiya tar uru anidim guru de dibodon. ");
INSERT INTO dad_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Pita idi irokenẽdin, “Aya gau nigin ayõ fenẽ.” Idi diron, “Amãg õ geid talauf.” Anĩ idi dile, waag bun sosõ den, anĩ ere, bõ anĩ bun, gau taka to dalen. ");
INSERT INTO dad_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bonimei bagai, Jesus maaĩ yerin ifaren, anĩ ere, dõ fiya tar idi, Jesusem ya anĩ to kelein. ");
INSERT INTO dad_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ĩ idi iweig irokenẽdin, “Mou tar, ã gau taka tau walegel?” Idi aiten dalen, “Sã.” ");
INSERT INTO dad_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ĩ irokenẽdin, “Waag siri biya melem kakãg urãg fen, tunĩ gei gouf.” Idi age difen sain, idi kakãg dĩ fiya kisi feleya san, ere nigin, gau musei biya. ");
INSERT INTO dad_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Anĩ in dõ fiya tamo Jesus ĩ nigin wau laa fedig ĩ, Pita irokenen, “Are Odugem!” Ĩ, “Are Odugem,” ye di, Simon Pita karĩ ye fen, ĩ kolos teten tamal inũ inon anĩ yale, luwa guf fen, naanũ ifũ iran. ");
INSERT INTO dad_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","In dõ fiya tar tunĩ ganan, waag bun disi, kakãg gau isokosen ado dĩ de dilen, ere nigin, are idi daliyou yeri gerõ sã, handred mita age fiya. ");
INSERT INTO dad_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sain idi kutũ desin, yã kaureya anĩ bun, gau yã bẽ bret tunĩ ado dilen. ");
INSERT INTO dad_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus idi irokenẽdin, “Ã gau gama bagai walegel tunĩ urousig.” ");
INSERT INTO dad_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Pita waag sõ ye fen, kakãg dĩ falaisi, maaĩ yerin irousin. Kakãg are gau odudug isokosen, gau are 153, gai musei biya, anĩ ere, kakãg to kokour fen. ");
INSERT INTO dad_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus idi irokenẽdin, “Usig, saaf wõg.” In dõ fiya tar kukĩ de fen, takam ĩ to, to fiyen, “Õ aim?” Idi keleĩ, are Odug yogo. ");
INSERT INTO dad_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus isi, bret yale fen, idi ifenẽdin, gaug de age fen. ");
INSERT INTO dad_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesus laa bun tamal kel fã ye fen, in dõ fiya tar meleid bun wõ yen are, gama eneim towo fen. ");
INSERT INTO dad_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Sain idi saaf dakas fen, Jesus Simon Pita irokenen, “Simon Jon naal, õ aya nigin fatuk waũ laa fef, tunĩ eneidi neid wal fiya de?” Pita iron, “Odug, momoi, õ keleĩ, aya õ nigin wau laa fef.” Jesus iron, “Neu sipsip momou ufoutneĩd.” ");
INSERT INTO dad_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Baban Jesus iron, “Simon Jon naal, õ aya nigin waũ laa fef de?” Pita solof iron, “Odug, momoi, õ keleĩ, aya õ nigin wau laa fef.” Jesus iron, “Neu sipsip kulatun wiyẽdiyouf.” ");
INSERT INTO dad_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesus Pita iroken towo fe fen, iron, “Simon Jon naal, õ aya nigin waũ laa fef de?” Pita wau moron, ere nigin, Jesus ĩ to fiyẽ towo fen, “Õ aya nigin waũ laa fef de?” Pita iron, “Odug, ereb ereb ganan õ keleĩ, õ keleĩ, aya õ nigin wau laa fef.” Jesus iron, “Neu sipsip ufoutneĩd. ");
INSERT INTO dad_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aya õ momoi bagai arokonok, sain õ gaun, õ naki rel, ogon oroya dõ fen uledig, anĩ ere, sain õ tubau bun, imã walese di, taka nem ifõyo ken, õ to oroyok nẽ an irouleyõf.” ");
INSERT INTO dad_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pita naig be fe, laaf fen, Negur fula fiya medeĩya ifenẽf anĩ nigin, Jesus od enei iron. Age ye fen, Jesus Pita irokenen, “Aya dõ wiya!” ");
INSERT INTO dad_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita falei yel fen, dõ fiya taka Jesus ĩ nigin wau laa fedig anĩ, dõ feid mog, ilen. (Tamo enei bõ saaf yõya bun, Jesus akoron mudur isen ken, iron, “Odug, aim anĩ õ kiwai ifonõf?”) ");
INSERT INTO dad_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sain Pita tamo anĩ ile fen, Jesus to fiyen, “Odug, tamo enei ĩ naig fouf?” ");
INSERT INTO dad_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus solof irokenen, “Tamo enei mata ibod mog, aya kelauf anĩ aya orouf aufeg, õ nigin ere yok? Õ de aya dõ wiyauf.” ");
INSERT INTO dad_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Enei nigin, dõ fiya tar idi atun, od enei iyokelen, are dõ fiya tamo enei to laa fouf den. Anĩ ere, Jesus, tamo anĩ to laa fouf ya nigin to iron, Jesus ĩ eig ye iron, “Tamo enei mata ibod mog, aya kelauf anĩ aya orouf aufeg, õ nigin ere yok?” ");
INSERT INTO dad_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","In dõ fiya tamo enei, anĩ ganan wogõ ye fen, itoton. Amã keleĩ, in od are momoi. ");
INSERT INTO dad_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus ĩ ereb ereb museig age fen. Aya kisi afef, anĩ ganan buk bun ditotlem are, teneub ganan bun modoũ sam. ");
INSERT INTO dad_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilus, uruwa buk aya atoton anĩ bun, Jesus gariya ino, ereb ereb age fen ado ifelnẽdif ile, ");
INSERT INTO dad_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","aposel ĩ igirnẽdin anidi Awa Uur Fateul bunem faded fiye keleid fen, Jesus saa ilun iselen nẽ naa bun, aya anĩ ganan nigin atoton. ");
INSERT INTO dad_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ĩ darau yale fen, laa fen, mata kel fã ye fen, tamo eneidi meleid bun wõ yen, agef fen, idi ĩ mata ibodok ya anĩ momoi douf nigin, ereb ereb musei age fen. Naa foti anĩ namen, ĩ idi meleid bun wõ ye fen, Negur tano nigin wogõ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesus idi geid saaf doko dibod ken, ĩ idi eig ye fadim yukenẽdin, “Ã Jerusalem to utorõgouf, anĩ ere, ereb aya wogõ au di, karĩ gen, are neu Dei ereb sur afouf yen anĩ tari gouf. ");
INSERT INTO dad_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Are Jon ĩ naan nem dogol igunein, anĩ ere, naa tunĩ ilele di, ã Awa Uur Fateulem naan iguneĩf.” ");
INSERT INTO dad_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Anĩ nigin, sain idi takai guru de dibod ken, idi ĩ to difiyen, “Odug, õ sain enei bun, Israel neid tano baban unouf de?” ");
INSERT INTO dad_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus idi irokenẽdin, “Are Dei ĩ yogon megeir bunem, sain nanĩ be naa inon ibodok anĩ, ã to keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Anĩ ere, ã fau sain Awa Uur Fateul ã bun isiyouf are, megeir walogouf, agog fen, ã aya age afen anĩ nigin wogõg fen, Jerusalem bun, Judia distrik ado Samaria distrik ganan bun ile, teneub idikeleya buneg, aya nigin wogõ gouf.” ");
INSERT INTO dad_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ĩ enei irokel fen, idi meleid bun bagai, ĩ yale irou iselen, ĩ lalo bun iminkele di, to dilen. ");
INSERT INTO dad_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesus isele di, idi saa ilun ditad se, lo difef den mog, kaisã bagai tamo uru kolos lalau adodo, idi siridin difaren. ");
INSERT INTO dad_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Idi diron, “Galili tamo ã, ere nigin ein ufareg utadseg fen, saa ilun lo gef? Jesus enei ã bun tamal yale irou, saa ilun iselel, ã ĩ saa ilun isel mog, ulegel kilei bagai, agef ĩ kel isiyouf.” ");
INSERT INTO dad_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Age de fen, idi Moul Arei dedig bun tamal, Jerusalem keku de dilen, Moul Areinem Jerusalem ileya are wan kilomita age fiya, anĩ nigin, Sabat naa bun iyõya kisi feleya. ");
INSERT INTO dad_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Sain idi Jerusalem wõ de fen, idi aab ilun dibodõdig nẽ an diselen, idi eneidim, Pita, Jon, Jems, Endru, Filip, Tomas, Batolomyu, Matyu, Jems Alfeus naal, Simon Selot taka, Judas Jems naal. ");
INSERT INTO dad_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Idi ganan guru de, waud tekelei dino fen, toku kosẽ dedig, kayau tunĩ geid, Maria Jesus sina, Jesus tura tar geid. ");
INSERT INTO dad_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sain anĩ bun, Pita, momoiya tamo kayau handred tuwenti age fiya idi atun, ifar fen, iron, ");
INSERT INTO dad_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Turau tar, kulu Awa Uur Fateulem Dawid sigoron, Judas ĩ tamo uyu iroukenẽdi di, Jesus dalen ĩ nigin wogõ yen anĩ, Negur nẽ Itotoya bun ibodok, are de agef kisi felen. ");
INSERT INTO dad_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ĩ amã nemã taka, ĩ amã weim kabĩ enei malen.” ");
INSERT INTO dad_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas yogon sane bunem moni yale fen, teneub taka na yalen, an ĩ kubũ ye mudur iten ken, yogon bouwa faraf fen, te galelei adok ulõ yesin. ");
INSERT INTO dad_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Age fe di, tamo kayau Jerusalem dibodon anĩ ganan, od anĩ karĩ den, anĩ nigin, teneub anĩ, dogo neid od nem yana dũ Akeldama den, anĩ nẽ gariya, Naud Teneub.) ");
INSERT INTO dad_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita wogõ tobol fe, irokeneg iron, “Buk Sam bun eig ye itoton, “‘Yogon modoũ are fonou inouf, an taka nem to ibodõf,’ takag, “‘Taka nem ĩ fotokar yogon kabĩ yalouf.’ ");
INSERT INTO dad_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Anĩ nigin, Odug Jesus ada atun kabĩ yale ilef isif mog, ");
INSERT INTO dad_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jon naan igunẽdin sain bunem ile, Jesus ada bun tamal, yale irou iselen sain bun, sain ganan ada weim tabodon anidi taka tagirnẽf. Are idi eneidi atun, takam Jesus mata kel fãya nigin, ada geid od wogõ tauf.” ");
INSERT INTO dad_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Anĩ nigin, idi tamo uru dinenẽdin, Josef Basabas dedig (yana taka Jastus), taka Matias. ");
INSERT INTO dad_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Age de fen, idi kosẽ de fen, diron, “Odug, tamo ganan neid waud õ keleĩ, uru eneidi bun, õ aib ugirin anĩ ufelnamã, ");
INSERT INTO dad_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","are Judas ĩ itor ken, yogon modoũ bun ilen anĩ, ĩ fotokar aposel kabĩ yalouf nigin.” ");
INSERT INTO dad_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Age de fen, idi aisaĩ dira ken, aisaĩ Matias wagen kubũ yen, anĩ bunem, Matias ĩ aposel ilewen baguf weimen. ");
INSERT INTO dad_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sain Pentikos naa isi di, idi ganan modoũ tekelei bun, guru de dibodon. ");
INSERT INTO dad_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Idi an dibod mog, kaisã bagai, ait yau totol ado gugu redig gen, saa ilun tamal isi fen, fõ aab ino yalen. ");
INSERT INTO dad_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Idi ereb yã bale gen isi di, dile mog, fara furu feid, idi mugu mugu tetedin ibodon. ");
INSERT INTO dad_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Age fe di, idi ganan Awa Uur Fateulem aura fiyẽdi di, gariya dino, od fire fire bunem wogõ den, Awa Uurem fiyẽdi di, age difen. ");
INSERT INTO dad_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sain anĩ bun, Juda tamo Negur nigin momoi den idi, teneub ganan bun temeleid disi, Jerusalem dibodon. ");
INSERT INTO dad_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sain idi ait anĩ karĩ de fen, tamo kayau musei idi nene de fen, guru difen, ere nigin, idi mugu mugu dogo neid od bun wogõ den anĩ karĩ den. ");
INSERT INTO dad_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Idi fatuk bagai terẽ de fen, diron, “Tamo od wogõ def eneidi ganan, Galili temeleid sã de? ");
INSERT INTO dad_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Naig fe di, ada mugu mugu, idi neda od bunem wogõ de di, karĩ tauf? ");
INSERT INTO dad_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ada fire firen temelada, Patia, Media, Elam kantri, Mesopotamia, Judia distrik, Kapadosia, Pontus, Asia provins, ");
INSERT INTO dad_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia distrik, Isip kantri ado Libia distrik tunĩ Sairini taun non. Amã tunĩ Rom kantri temelamã, Juda temeleid ado haiden Juda neid momoiya bun falei maun, ");
INSERT INTO dad_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Krit nuyo ado Arabia distrik. Ada mugu mugu neda od bun, Negur kabĩ odug age fen anĩ wogõ de di, karĩ tauf.” ");
INSERT INTO dad_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Idi terẽ de nene de fen, abob toti difen, “Eĩ ere gariya nigin?” ");
INSERT INTO dad_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Anĩ ere, tunĩ idi weli difiyeĩd diron, “Idi wain fatuk domõ.” ");
INSERT INTO dad_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita aposel ilewen geid difar fen, ait odugem tamo kayau wogõ fiyẽdin, “Juda tamo kayau ado ã ganan Jerusalem ubodõgef, utorõg len, aya ã enei faded ayeĩf, kee releg fen, aya wogõ auf anĩ karĩg. ");
INSERT INTO dad_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ã kisi gef, tamo eneidi wain domõ gef, age fiya sã, gama eĩ nain kilok bonimei! ");
INSERT INTO dad_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Anĩ ere, eĩ are Profet Joel eig ye wogõ yen: ");
INSERT INTO dad_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Negur irok, idikeleya naa bun, aya neu Awa Uur, tamo kayau ganan bun gõ afalauf. Age afe di, ãgenei kesu, kayau momoul ado, profet od wogõ douf, ãgenei tamo gaũ meleid bun seleulã kurã fouf, ãgenei tamo tubau dimĩdiyouf. ");
INSERT INTO dad_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Neu ferfer tamo ado kayau geid buneg, aya neu Awa Uur naa anĩ bun gõ afalaisi di, idi profet od wogõ douf. ");
INSERT INTO dad_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aya saa ilun, memelik fire fire afelnẽdiyouf, tenebur ein uris anodiyouf. Naud, yã ado, kaau tubutubuya wõ youf. ");
INSERT INTO dad_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Odug nẽ Naa odug fula fiya medeĩya ado, fau to isi mog, gaa gugum kele fen, ogõ naud gen wõ youf. ");
INSERT INTO dad_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Age fe di, aib taka ĩ, Odug yana yale iweignẽf are, Odug ĩ kel yalouf.’ ");
INSERT INTO dad_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel tamo kayau, od enei karĩg, ã aug keleĩ, Negur ã atun, Jesus Nasaret tamal bunem memelik, ereb urug bagai ado, uris inodin, anĩ bunem Jesus ĩ Negurem sur fiyen anĩ, Negur ã ifelnein. ");
INSERT INTO dad_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tamo enei nigin, Negurem ereb ereb wõya sã mog, yogon keleĩ ado kisi bunem, ĩ ã imeĩ bun inon, age fe di, ã tamo sesenem disenneĩ di, ĩ laa fouf nigin, aa tetek bun tuti nem ũgen. ");
INSERT INTO dad_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Anĩ ere, Negur ĩ laa bun tamal turĩ fe di, mata kel fã yen, laa nẽ darau bun tamal yalelnen, ere nigin, laa anim ĩ irounẽya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Are Dawid ĩ nigin iron: “‘Odug sain faimud malau bun ifar mog, ailedig. Ĩ aya imau biyalem ibodok nigin, aya to kumĩ au fen, terẽ auf. ");
INSERT INTO dad_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Anĩ nigin, neu wau seref fen, sigorou seli abidig, aya, ereb Negur aya bun biya age fouf anĩ tari afedig, ");
INSERT INTO dad_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ere nigin, õ neu malaukanon to utornẽ di, bouwau laa neid modoũ bun ibodõf, õ ogon Fateuleg to utorõ di, bura lauf. ");
INSERT INTO dad_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Õ mata bun ileya nẽ naab ufelna fen, õ malã bun kulĩya barikã wiyauf.’ ");
INSERT INTO dad_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Turau tar, aya ã yaor arokeneik, tubuda Dawid ĩ laa fe di, mũ difen. Yogon matmat, ada atun naa enei bun fau ibodok. ");
INSERT INTO dad_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Anĩ ere, ĩ profet taka, anĩ nigin, ĩ keleĩ, Negur wau kuturol fen, Dawid yogon ibor nẽ tubu tar bun tamal taka, yogon king nẽ sia bun inenẽf nigin irokenen. ");
INSERT INTO dad_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawid ĩ ereb fau wõya sã mog, anĩ tetunem ile fen, Kristus mata kel fã youf nigin eig ye wogõ yen, ‘Ĩ laa neid modoũ bun to ibodõf, ĩ bouwag to bura lauf,’ yen. ");
INSERT INTO dad_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Negur Jesus enei turĩ fe di, ĩ mata kel fã yen anĩ, amã ganan mailen. ");
INSERT INTO dad_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Negur ĩ ima biyalem yalesnẽ di, Jesus ĩ, Tama bun Awa Uur Fateul Negur afeneĩf yen anĩ yale fen, fi felen, are ã gama ulegef ado karĩ gef anĩ. ");
INSERT INTO dad_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawid saa ilun to iselen, anĩ ere, ĩ iron, “‘Negur neu Odug irokenen: “Imau biya melem ubod mog, ");
INSERT INTO dad_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ogon kiwai tar ogon ye inoya nẽ sawa anodiyouf.” ’ ");
INSERT INTO dad_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Anĩ nigin, Israel tamo kayau ganan enei keleĩ bagai youf, Jesus enei ã aa tetek bun ukesigen anĩ, Negur yogo, Odug ado Kristus inenen.” ");
INSERT INTO dad_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tamo kayau od enei karĩ de fen, idi waud gudũ fe di, Pita aposel tunĩ ganan geid dirokenẽdin, “Turamã tar, amã naig mafouf?” ");
INSERT INTO dad_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita solof irokenẽdin, “Ã mugu mugu wauĩ falei wog fen, Jesus yana bunem naan iguneĩ di, ãgenei mosor nigin weder tu kalauf, ago ge di, ege luwa are Awa Uur Fateul walogouf. ");
INSERT INTO dad_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Promis od are ãgenei, ãgenei kesu tar ado, idi gerõ difaref ani ganan neid, are Odug neda Negur iweignẽdiyouf anĩ ganan neid.” ");
INSERT INTO dad_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Age ye fen, Pita od musei bun, idi wedereid irou fen, totol irokenẽdin, “Ã aug isenneĩf nigin, tamo kayau sane sain enei bun tamal urab uraileg.” ");
INSERT INTO dad_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yogon od dalen idi naan igunẽdin, age dife di, naa anĩ bun, tri tausen tamo kayau age fiya, idi neid bun tobol difen. ");
INSERT INTO dad_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Idi aposel neid ifelnẽdiya, uyu kũ fiya, saaf weim yõya, kosẽya bun, idi neid kisi adok dino fen, age difen. ");
INSERT INTO dad_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tamo kayau ganan terẽ de inid ifitin. Age dife di, aposel idi, uris ado memelik musei dinon. ");
INSERT INTO dad_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Momoiya tamo kayau ganan weim dibod ken, safineid ganan gadõ difedig. ");
INSERT INTO dad_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Safineid na nigin sur difeid fen, taka ĩ lau fef anĩ difenẽdig. ");
INSERT INTO dad_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Naa ganan idi toku waud tekelei fen, tempel modoũ bun guru difedig. Idi dogo neid fõ fõ bun, kulĩya ado waud adok an yen ken, weim saaf dõdig. ");
INSERT INTO dad_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Idi Negur yana dalesedig, tamo kayau ganan, idi nigin biya difiyẽdidig, age dife di, Odug naa ganan bun, tamo kayau kel gei feid fen, idi neid bun tobol fedig. ");
INSERT INTO dad_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Naa taka bun, Pita Jon ado, tri kilok aragau kosẽya sain nigin, tempel bun diselen. ");
INSERT INTO dad_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tamo taka sina namen ye ilolaisin gõ fen, tempel bobog yana ‘Meli Bagai’ dedig an faali de diroulen, an naa ganan bun dinenẽ di, ibod ken, tempel bun dilef anidi moni nigin nonĩ fiyẽdidig. ");
INSERT INTO dad_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sain Pita Jon ado, tempel namen dilau fenẽ age dife di, ileid fen, moni nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Anĩ ere, Pita Jon ado, ĩ lo difel fen, Pita iron, “Amã lo wamã!” ");
INSERT INTO dad_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Age ye di, ĩ ereb difanauf ye fen, lo feidlen. ");
INSERT INTO dad_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Age fe di, Pita iron, “Silwa be gol are aya sã, anĩ ere, ereb aya ado anĩ, õ afonok, are Jesus Kristus Nasaret tamal yana bunem uyõ.” ");
INSERT INTO dad_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Age ye fen, Pita tamo ima biyalẽ yale iroune ken, isennẽ yalesnen, kaisã bagai tamo nẽ ye guyu totoledin. ");
INSERT INTO dad_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ĩ gurusã ye ifar fen, iyõya gariya inon. Agef fen, ĩ weim tempel namen dilen, iyõ, gurusã ye fen, Negur yana yalesen. ");
INSERT INTO dad_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tamo kayau ganan ĩ iyo ken, Negur yana yalese di, dile fen, ");
INSERT INTO dad_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","idi, im bagai tempel bobog yana ‘Meli Bagai’ dedig bun ibod ken, nonĩ yedig den. Idi ĩ bun ereb wõ yen anĩ nigin, fatuk bagai terẽ de fen, inid ifitin. ");
INSERT INTO dad_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Solomon nẽ Waranda dedig an, nonĩya tamo anĩ, Pita Jon ado irounẽdi di, tamo kayau ganan terẽ de fen, gududu de, idi gedin disin. ");
INSERT INTO dad_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita anĩ ile fen, idi irokenẽdin, “Israel tamo, ere nigin eneim ã terẽ yeik de? Ere nigin nemã megeir bunem be, nemã Negur aniniya bunem, tamo enei el mafiyen gen amã lo wamãglef? ");
INSERT INTO dad_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isak, Jakop idi neid Negur, tubuda tar neid Negur im, yogon kabĩ tamo Jesus fula fiya medeĩya ifenen. Ã ĩ dukesiyouf nigin wenẽdig fen, Pailat ĩ itornẽ di, ilauf nigin kisi ino mog, ã Pailat mala bun ĩ nigin wa gen. ");
INSERT INTO dad_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ã, ĩ Fateul Madur tamo anĩ wag fen, tamo yukesiya tamo anĩ yaliskeneĩf nigin urokenẽgen. ");
INSERT INTO dad_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ã mata nẽ gariya anĩ ukesigen, anĩ ere, Negur ĩ laa bun tamal yalesnen. Amã enei mailen nigin wogõ mauf. ");
INSERT INTO dad_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesus yana nigin momoiya bunem, Jesus yana anim, tamo enei ã kelei ken, ulegedig anĩ totol ifenem. Momoiya ĩ bunem isif anim, tamo enei ã ganan log mog, el fiye kelel. ");
INSERT INTO dad_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Turau tar, aya keleĩ, ã ãgenei uyu irouya geid, keleĩ sã nigin ago gen. ");
INSERT INTO dad_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Anĩ ere, enei wõya sã mog, Negur profet ganan bun wogõ yen, are yogon Kristus darau yalouf bagai, anĩ Negurem agef kisi felen. ");
INSERT INTO dad_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Anĩ nigin, wauĩ falei ge fen, Negur bun uleg, anĩ bunem ãgenei mosor isasalauf. Ago gouf, wauĩ mata wõya nẽ sain Odug bunem isi fen, ");
INSERT INTO dad_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Negur, Kristus ã nigin igirin, are Jesus sur fouf. ");
INSERT INTO dad_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesus fau de saa ilun ibod mog, Negur ereb ereb ganan mata inouf nẽ sain wõ youf, kulu yogon profet fateul sigoreid bun Negur wogõ yen kilei. ");
INSERT INTO dad_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses iron, ‘Odug ãgenei Negur, profet taka aya gen, tamo kayau ã atun wõ ye keneĩf. Ã ereb irokeneĩf ganan, karĩ gouf bagai. ");
INSERT INTO dad_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Taka nem profet anĩ to karĩ fiyẽf, ĩ tamo kayau atun gai gai gudũf irailauf.’ ");
INSERT INTO dad_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Age fiya gen, profet ganan Samuel bun gariya ino fen, isin idig, gama naa eneidi bun ereb wowã yef isin anĩ nigin wogõ den. ");
INSERT INTO dad_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ã profet neid gere tar, Negur ãgenei tubuĩ tar geid bar itenẽya inon, ã bar itenẽya anĩ nẽ gere tar. Negur Abraham irokenen, ‘Ogon ibor bunem, tamo kayau teneub ganan bun el fediyouf.’ ");
INSERT INTO dad_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Negur yogon kabĩ tamo yalesne ken, ãgenei sane bun tamal, ã mugu mugu ganan falei ge di, el yeĩf nigin, ã bun ket Jesus sur fen.” ");
INSERT INTO dad_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita Jon ado, tamo kayau od dirokeneĩd mog, pris tunĩ, tempel lo fiya tamo neid mudur, Sadusia tamo tunĩ geid, idi gedin disin. ");
INSERT INTO dad_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Idi fatuk bagai waud moron, ere nigin, aposel idi tamo kayau difelneĩd fen, Jesus laa bun tamal mata kel fã yen anĩ wogõ den. ");
INSERT INTO dad_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Idi Pita Jon ado dirouneĩd fen, aragau nigin idi kalabus bun dinenẽdi di, ile we felen. ");
INSERT INTO dad_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Anĩ ere, od karĩ den idi musei momoi den, momoiya tamo faif tausen age fiya wõ den. ");
INSERT INTO dad_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Naa taka di, nedi uyu irouya, mudur adodo, lo ifelnẽdiya tamo geid, Jerusalem guru difen. ");
INSERT INTO dad_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pris neid mudur Anas an ibodon, Kaiafas, Jon, Aleksanda, pris mudur neid ibor tunĩ ganan idig an dibodon. ");
INSERT INTO dad_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Idi Pita Jon ado guri de dirousi, atũ difeid fen, to difedin, “Ere megeir bunem be, ere yana bunem enei ago gen?” ");
INSERT INTO dad_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Age de di, Pita Awa Uur Fateulem aura fiyen ĩ, idi irokenẽdin, “Tamo kayau neid uyu irouya, mudur adodo! ");
INSERT INTO dad_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Amã gama, tamo ye ilolaisin bun ereb biya age mafe di, naig fe el fiyen nigin to wamãgouf are, ");
INSERT INTO dad_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ã, Israel tamo kayau ganan geid enei keleĩ youf, ã Jesus Kristus Nasaret tamal aa tetek bun ukesigen, anĩ ere, Negur ĩ laa bun tamal yalesnen, ĩ yana bunem, tamo ã meleĩ bun ifaref enei el fiyen. ");
INSERT INTO dad_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tamo are “‘meein fõ inoya tamo ãgem sane ge fen, utorõgen, anĩ gama monog tor wõ yen.’ ");
INSERT INTO dad_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Taka bun tamo kel gei fiya to ibodok, ere nigin, ada kel gei fadauf nigin, saa farumen yana taka to tamo ifenẽdin.” ");
INSERT INTO dad_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita Jon ado skul ileya sã, fonõ tamo, are idi kelein, anĩ ere, idi kumĩ sã wogõ de di, dile fen, terẽ den. Age de fen, idi kelein, tamo eneidim Jesus geid diyon. ");
INSERT INTO dad_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Anĩ ere, tamo el difiyen anĩ, Pita Jon ado geid difar mog, dilen nigin, idi ereb od irõya nigin od sã. ");
INSERT INTO dad_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Anĩ nigin, Juda uyu irouya neid kaunsel guru fiya anĩ ditor dilauf nigin, idi dirokeneĩd, ditor dile di, idi dogo dogol katõ difen. ");
INSERT INTO dad_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Idi diron, “Tamo eneidi ere naig tafiyẽdiyouf? Idi memelik enei fire bagai dinon anĩ, Jerusalem dibodok idi ganan keleĩ, are ada wa fiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Anĩ ere, enei, tamo kayau bun to iyokalauf nigin, tamo eneidi Jesus yana bunem taka to wogõ difiyẽf nigin, ada wedereid tarouwauf bagai.” ");
INSERT INTO dad_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Age de fen, idi baban namen diweigneĩd, disi di, Jesus yana bunem to bagai wogõ douf be difelnẽdiyouf nigin, totol bagai dirokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Anĩ ere, Pita Jon ado solo de dirokenẽdin, “Negur mala bun, Negur dõ fiya ban, ã dõ mayeĩf, are tutuk de, sã de anĩ, ã aug es wog. ");
INSERT INTO dad_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ereb amã mailen, karĩ maun nigin, sigoramã ifõya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Uyu irouya idi baban kumĩ od difeneĩd le fen, folõ difeid le di, dilen. Uyu irouya idi darau ifenẽdiya nigin kisi taka to dalen, ere nigin, tamo kayau ganan ereb wõ yen anĩ nigin, Negur yana dalesen. ");
INSERT INTO dad_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tamo memelik dino fen, el difiyen are, yar foti wal feseya. ");
INSERT INTO dad_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sain Pita Jon ado dalisnẽdi di, idi dogo neid tamo kayau bun keku de dile fen, pris odudug mudur adodo geid, od dirokenẽdin anĩ ganan wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Idi od anĩ karĩ de fen, idi aiteid tekelei dales fen, Negur kosẽ difiyẽ diron, “Odug ereb ereb ganan nẽ Marau, õ saa, teneub, maaĩ, anidi namen ereb ereb ganan unodin. ");
INSERT INTO dad_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tamamã Dawid, ogon kabĩ tamo sigor bun Awa Uur Fateulem wogõ won: “‘Ere nigin haiden idi Odug bun seye de fen, tamo kayau idi kiwai nẽ kisi are ege bagai dinof? ");
INSERT INTO dad_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tenebur nẽ king idi kusĩya nigin dodok difef, uyu irouya tamo guru de fen, Odug bun ado yogon Kristus bun kiwai dinof.’ ");
INSERT INTO dad_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Momoi, Herod, Pontius Pailat idim, haiden, Israel tamo kayau geid, taun enei bun guru de fen, ogon kabĩ tamo fateul Jesus õ ogo ugirin ĩ kiwai difenen. ");
INSERT INTO dad_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Õ ogon megeir ado oroya bunem agef wõ youf wo fen, tetun ufon anĩ kilei, idi age difen. ");
INSERT INTO dad_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Odug, gama idi dogo neid kumĩ od dinon anĩ kisi fen, amã ogon ferfer, ogon od kumĩ sã megeir ado wogõ mauf nigin megeir wanamã. ");
INSERT INTO dad_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Imã ura ken, dagi el wo, ago fen, ogon kabĩ tamo fateul Jesus yana bunem memelik uris ado unodiyouf.” ");
INSERT INTO dad_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kosẽ de bure difel mog, idi guru difen nẽ modoũ anĩ guyoyõ fen. Age fe di, idi ganan Awa Uur Fateulem aura fiyeĩd fen, toli fedi di, kumĩ sã Negur nẽ od wogõ den. ");
INSERT INTO dad_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Momoiya tamo kayau ganan waud ado kisi tekelein. Taka nem, yogon safina taka to neu mugu yen, anĩ ere, ereb ereb ganan idi ado are weim dile dogolen. ");
INSERT INTO dad_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposel idi megeir odug nem, Odug Jesus mata kel fã yen nigin wogõ den, age dife di, Negur nẽ wau ifenẽya odug, idi ganan bun ibodon. ");
INSERT INTO dad_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Age fe di, idi atun taka nem ereb taka to lau fen, ere nigin, teneub be fõ adodo anĩ na nigin sur difeid fen, moni dale dirou disi, ");
INSERT INTO dad_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposel imeid bun dinodig, anĩ gadõ de fen, taka ĩ lau fef anĩ difenẽdig. ");
INSERT INTO dad_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josef, Lewi ibor taka, Saipras nuyo tamal, aposel idi ĩ anĩ Banabas dedig (anĩ nẽ gariya, Wau Yaleya Tamo), ");
INSERT INTO dad_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ĩ yogon teneub na nigin sur fe fen, moni yale, aposel imeid bun inon. ");
INSERT INTO dad_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tamo taka yana Ananias, aiwa Safira ado, nedi safina taka na nigin sur difen. ");
INSERT INTO dad_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ĩ, yogon aiwa anĩ ganan keleĩ mog, moni tunĩ yogon nigin irou fen, tunĩ anĩ yale iroule, aposel imeid bun inon. ");
INSERT INTO dad_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Age fe di, Pita iron, “Ananias, naig fe di, Satan waũ bun isokose di, Awa Uur Fateul udegne ken, moni teneub nẽ walen anĩ tunĩ ogon nigin urouf? ");
INSERT INTO dad_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fau na sur fiya sã mog are ogonen, na nigin sur wol fen, moni areg ogonek. Ere nigin õ waũ bun enei ago wouf nigin kisi unol? Õ tamo to udegnẽdil, are õ Negur udegnem.” ");
INSERT INTO dad_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias od enei karĩ ye fen, ĩ kubũ ye laaf yenen. Ganan od enei karĩ den, idi kumĩ tererẽ den. ");
INSERT INTO dad_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Age fe di, tamo gaũ gaũ disi, yogon bouwa sile de, faali de diroule, mũ difen. ");
INSERT INTO dad_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tri aua age fiya ilele di, aiwa gober ereb wõ yen anĩ keleĩ sa ken, isin. ");
INSERT INTO dad_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Age fe di, Pita kayau to fiyen, “Urokana, õ aiwã ado teneub nẽ moni de enei kilei walegen de?” Kayau iron, “Ao, de enei kilei dogol.” ");
INSERT INTO dad_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Age ye di, Pita kayau irokenen, “Naig fe di, õ aiwã ado wauĩ tekelei fen, Odug nẽ Awa Uur kisi wiyẽgel? Ulef, tamo idi ogon aiwã mũ difel, idi neid yebureid yer bobogẽ, õg idi age de faali de dirouleyõf.” ");
INSERT INTO dad_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Agef irokenẽ di, kaisã bagai, Pita ye gariyan, kayau are kubũ ye laa fen. Age fe di, tamo gaũ namen disi, kayau laa fel dile fen, faali de diroule, aiwa mũ difen sirin mũ difen. ");
INSERT INTO dad_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Sios adok, tamo kayau ganan od enei karĩ den idi geid, fatuk bagai kumĩ den. ");
INSERT INTO dad_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposel idi tamo kayau atun memelik uris ado musei dinodin. Age dife di, momoiya tamo kayau ganan Solomon nẽ Waranda bun guru difedig. ");
INSERT INTO dad_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tamo kayau idi nigin yeneid dalesedig, anĩ ere, idi kumĩ de fen, taka nem idi geid to bagu difen. ");
INSERT INTO dad_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Anĩ ere, tamo kayau musei Odug nigin momoi de di, momoiya tamo kayau baba baban tobol fef iselen. ");
INSERT INTO dad_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposel age difef ya anĩ kelei ken, tamo kayau dagi adodo naabur guri difedi di, fatar bun ado gogoũ bun dinenãdin, are Pita ile di, yogon burig idi tunĩ bun irã di, el be fediyouf de fen, age difen. ");
INSERT INTO dad_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tamo kayau musei Jerusalem kalilĩ fiya taun temeleideg, dogo neid dagi adodo, kaa sesenem darau difenẽdin anidi guri de dirou disi di, idi ganan el difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Age dife di, pris neid mudur ĩ, yogon katõ tura tar are Sadusia tamo geid, kiyeĩ beberĩdin. ");
INSERT INTO dad_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Idi aposel dirouneĩd fen, kalabus bun dinenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Anĩ ere, bõ anĩ bun, Odug nẽ engel kalabus fõ sukar kã feleid, gurif, mayarẽ disi fen, irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ulagauf, tempel bun ufareg fen, tamo kayau mata enei nẽ od ganan urokenẽdig.” ");
INSERT INTO dad_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Idi irokenẽdin kilei, bonimei bagai idi tempel bun dile fen, tamo kayau ifelnẽdiya gariya dinon. Sain pris neid mudur, yogon katõ tura tar geid disi di, idi Israel neid uyu irouya ganan neid guru fiya yana Sanhedrin dedig anĩ diroun, age de fen, idi aposel kalabus bun temeleid guri difeid dirou disiyouf nigin tamo sur difedin. ");
INSERT INTO dad_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Anĩ ere, sain kabĩ tamo kalabus fõ bun dilen, aposel an to diledin. Anĩ nigin, idi keku de dile dirokenẽdin, ");
INSERT INTO dad_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Amã kalabus fõ kotũ feleya ado lo fiya tamo bobog bun difar mog, mailedil, anĩ ere, sukar kã mafel fen, an taka nem to ibod mog mailel.” ");
INSERT INTO dad_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Od anĩ karĩ de fen, tempel lo fiya tamo neid mudur, pris odudug geid, nene de fen, enei bunem naig be fe wõ youf de fen, sii fedin. ");
INSERT INTO dad_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Age de mog, taka nem isi iron, “Ulegef! Tamo kalabus bun unenẽdigen idi tempel bun difar fen, tamo kayau difelnẽdif.” ");
INSERT INTO dad_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Age ye di, tempel lo fiya tamo neid mudur, yogon kabĩ tamo geid, dile, aposel gei difeid fen, dirou disin. Idi to sibu difiyeĩd fen, daũ difiyẽdin, ere nigin, idi tamo kayau meein tulu difiyẽdiya nigin kumĩ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Idi aposel gei de dirousi, Israel uyu irouya neid guru fiya meleid bun difarnẽdi di, pris neid mudur idi to fiyeĩd ");
INSERT INTO dad_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","iron, “Amã yana enei bunem to ufelnẽdigouf nigin, totol bagai katũ mayein, anĩ ere, ã wogõ ge di, ã ufelnẽdigen anĩ Jerusalem ganan bun iyokelen, ago ge di, tamo enei nẽ naud amã bouwamã bun unogef.” ");
INSERT INTO dad_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita aposel ganan geid aiten dale diron, “Amã tamo aiteid dõ fiya ban, Negur ait anĩ dõ mafouf bagai. ");
INSERT INTO dad_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesus laa fouf nigin aa bun useginnẽgen, anĩ ere, tamada tar neid Negurem Jesus laa bun tamal yalesnen. ");
INSERT INTO dad_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ĩ Negurem yalesne ken, ima biyalẽ neda King, neda Kel Gei Fadaya inenen, are Negurem Israel tamo kayau waud falei fe di, nedi mosor weder tu kalauf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amã enei mailen anĩ yaor ma wogõ mauf, Awa Uur Fateul, are Negur dõ difef anidi ifenẽdin, ĩg age fef.” ");
INSERT INTO dad_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Idi od enei karĩ de fen, idi seye de, didenkesiyouf nigin age difen. ");
INSERT INTO dad_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Anĩ ere, Farisia tamo taka yana Gamaliel, ĩ lo ifelnẽdiya tamo, tamo kayau ganan ĩ yana dalesedig, ĩ guru fiya atun ifar fen, aposel idi sain naal mayarẽ dinenẽdiyouf nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Age dife di, ĩ idi irokenẽdin, “Israel tamo, ã tamo eneidi ereb naig wiyẽdigou fenẽ are, ã kisi el ge waleg le fen, ago gouf. ");
INSERT INTO dad_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kulu sain taka bun, Teudas ĩ yogo anĩ tamo odug ye fen, wõ yen, age fe di, fo handred tamo age fiya dõ difiyen, anĩ ere, ĩ dukesi di, yogon dõ fiya tar ganan firagagaũ dife, ege sa kelen. ");
INSERT INTO dad_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tamo enei dumen, Judas Galili tamal, tamo kayau yeneid iweseya sain bun wõ ye fen, tamo kayau geif yalen, anĩ ere, ĩg dukesi di, yogon dõ fiya tar ganan firagagaũ difen. ");
INSERT INTO dad_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Anĩ nigin, enei nigin aya ã arokeneik, tamo eneidi utornẽdig len dile! Idi ereb kisi difef be, ereb age difef, are tamo bun tamal ouf are, fau sa kalauf. ");
INSERT INTO dad_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Anĩ ere, enei Negur bun tamal ouf are, ã tamo eneidi katũ fiyẽdiya kisi feleya sã, age fiya ban, ã aug Negur geid kusĩ gef anĩ ulogouf.” ");
INSERT INTO dad_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Age ye di, idi yogon od diroun. Idi aposel diweigneĩd, namen dile di, wagagã difedin, age de fen, idi baban Jesus yana bunem to wogõ douf nigin dirokeneĩd fen, ditornẽdi di, dilen. ");
INSERT INTO dad_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel idi kaunsel guru fiya anĩ ditor dile fen, kulĩ den, ere nigin, Negur kisi fen, are idi Jesus yana nigin mama dalouf nigin kisi feleya. ");
INSERT INTO dad_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Naa ganan, tempel bun ado fõ bun fõ bun dile, toku difelneĩd fen, biya od wogõ de, Jesus ĩ Kristus den. ");
INSERT INTO dad_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sain anĩ bun, dõ fiya tamo kayau musei di, Juda tamo kayau Grik od wogõ dedig anidim, Juda tamo kayau Hibru od wogõ dedig anidi nauseir difiyẽdin, ere nigin, idi neid kayau waab naa ganan saaf gadõ fiya bun ditornẽdidig. ");
INSERT INTO dad_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Anĩ nigin, aposel tuwelf idim, dõ fiya tamo kayau ganan kuru difeid fen, diron, “Amam Negur nẽ od wogõya kabĩ mator ken, saaf lo fiya kabĩ malouf, are to biya. ");
INSERT INTO dad_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Anĩ nigin, turamã tar, ã atun tamo sewen Awa Uur ado kisi biya barikã nigin yeneid walesegedig anidi ugirnẽdig. Kabĩ enei amã idi bun manouf. ");
INSERT INTO dad_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Age ma fen, amã, kosẽya ado od wogõya kabĩ bun dogol, kabĩ totol malouf.” ");
INSERT INTO dad_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Od enei karĩ de fen, idi ganan yo den. Idi digirin, Stiwen, ĩ tamo momoiya ado Awa Uur Fateul barikã, taka Filip, Prokoros, Nikanor, Timon, Pamenas, Nikolas Antiok tamal ĩ Juda neid momoiya bun falei ye fen, Kristus nẽ momoiya yalen. ");
INSERT INTO dad_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Age dife fen, idi, tamo anidi aposel wagedin dinenẽdi di, aposel idi kosẽ del fen, imeid tetedin dinon. ");
INSERT INTO dad_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Negur nẽ od iyokelen. Jerusalem an, dõ fiya tamo kayau tobol fe, musei biya wowã den. Age dife di, pris musei idig momoiya anĩ dõ difen. ");
INSERT INTO dad_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiwen ĩ, Negur nẽ wau ifenẽya ado megeir barikã tamo, ĩ tamo kayau atun memelik uris ado odudug inodin. ");
INSERT INTO dad_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Anĩ ere, fefeya yenen, Friman dedig neid uub fõ bun temeleid tamo, are idi Juda tamo Sairini ado Aleksandria taun temeleid ado, Silisia ado Asia provins bun temeleid anidim, Stiwen geid fefe den. ");
INSERT INTO dad_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Anĩ ere, Stiwen ĩ kisi biya ado Awa Uur bunem wogõ yen anĩ, idim wal fiyẽya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Age fe di, idi iminẽyan, tamo tunĩ eig de dirõf nigin waud dalen, “Stiwen ĩ Moses ado Negur nigin kono fiya od wogõ ye di, karĩ maun.” ");
INSERT INTO dad_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Idi od anim, tamo kayau, uyu iroudiya tamo ado, lo ifelnẽdiya tamo geid nameid dalesen. Age dife di, idi Stiwen ka dife, Juda uyu irouya tamo neid guru fiya bun diroulen. ");
INSERT INTO dad_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Idi, tamo tunĩ idegẽya od wogõ douf nigin, guri de disi di, diron, “Tamo enei faimud sigor taka to ifõdig, Negur nẽ tempel enei nigin ado, Moses nẽ Lo nigin, kiwai od wogõ yedig. ");
INSERT INTO dad_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ere nigin, amã karĩ mafiyẽ mog, ĩ iron, Jesus Nasaret tamal eneim, modoũ enei narĩ fel fen, Moses nẽ tobonunã ifanadan anĩ falei fouf yen.” ");
INSERT INTO dad_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ganan kaunsel guru fiya anĩ bun dibodon idi, Stiwen lo difelen, ĩ nawa engel nawa gen dilen. ");
INSERT INTO dad_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Age de fen, pris neid mudur Stiwen to fiyen, “Od wogõ den enei, are momoi de?” ");
INSERT INTO dad_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stiwen solof iron, “Turau tar ado Dei geg, karĩ wiyag, tubuda Abraham Haran taun fau ileya san, Mesopotamia ibod mog, fula fiya medeĩya nẽ Negur ĩ bun wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Negur Abraham irokenen, ‘Ogon teneub ado ogon tamo kayau utorneĩd fen, teneub aya afelnõf nẽ an ulauf.’ ");
INSERT INTO dad_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Anĩ nigin, ĩ Kaldia teneub itor ken, Haran ile ibodon. Dum yogon tama laa fe di, Negur ĩ sur fiyẽ di, teneub gama ubodõgef enei bun ibodon. ");
INSERT INTO dad_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Negur Abraham ein teneub taka to ifenen, teneub masak bagaig taka to ifenen. Anĩ ere, Negur, Abraham ĩ dumen yogon ibor nẽ tubu tar geid, teneub anĩ afenẽdiyouf yen, anĩ ere, sain anĩ bun Abraham ĩ kesu san. ");
INSERT INTO dad_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Negur Abraham eig ye irokenen, ‘Ogon ibor nẽ tubũ tar, yaũ tamo teneub taka bun dibodõf, an idi ferfer dibodõf, fo handred yar to biya difiyẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Anĩ ere, aya, idi ferfer dibod ken, aruneid dalef neid teneub darau afenẽf, anĩ dumen, idi teneub anĩ bun tamal diya disi, modoũ enĩ bun aya arunau dalouf.’ ");
INSERT INTO dad_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Agef fen, Negur Abraham bar itenẽya nẽ uris, mulũ anĩ ifenen. Age fe di, Abraham naal Isak wõ ye, naa eit ilele di, mulũ ifenen, dumen Isak naal Jakop wõ yen, Jakop ĩ tubuda tar tuwelf neid temeid ibodon. ");
INSERT INTO dad_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Tubuda tar, Josef kiyeĩ difen ken, Josef Isip neid ferfer wõ youf nigin, na nẽ sur difen. Anĩ ere, Negur ĩ adon, ");
INSERT INTO dad_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","agef fen, Negur Josef morõ ganan bun isennen. Negur ĩ, Josef Isip nẽ king Farao mala bun, kisi biya ado wau ifenẽya anĩ ifenẽ di, Farao ĩ, Josef Isip teneub ado yogon fõ ganan lo fiya nigin uyu irouya inenen. ");
INSERT INTO dad_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Age fe di, Isip teneub ado Kanan teneub ganan bun, naũ odug wõ ye di, morõ odug dalen, age fe di, tubuda tar saaf fotou fiya kisi feleya san. ");
INSERT INTO dad_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Anĩ ere, Jakop, Isip oun saaf ado ya karĩ ye fen, tamada tar urug bagai sur fedin. ");
INSERT INTO dad_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Idi baban dile di, Josef ĩ yogo nigin tura tar bun yaor fen, age fe di, Farao ĩ Josef nẽ ibor nigin kelein. ");
INSERT INTO dad_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Anĩ dumen, Josef, tama Jakop ado yogon ibor ganan Isip dilauf nigin od sur fen, idi ganan sewenti-faif. ");
INSERT INTO dad_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Age fe di, Jakop Isip ilen, an ĩ ado tubuda tar gare desin. ");
INSERT INTO dad_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Idi neid bouweid keku de, Sikem taun guri de diroule, kulu Abraham Sikem oun, Hamor gere tar bun moni nem matmat na yalen anĩ bun mumã difen. ");
INSERT INTO dad_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Negur Abraham irokenen anĩ kisi falauf nigin sain dodol mog, Isip oun neda tamo kayau musei biya isoran. ");
INSERT INTO dad_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Age dife di, king taka ĩ Josef nigin keleĩ sã, ĩ bagam Isip nẽ king wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ĩ ada neda tamo kayau idegneĩd fen, darau ifenẽdin, are tubuda tar nugo fiyẽdi di, idi neid kesu momou sineid gogũ difedif anĩ, mayarẽ dirarã di, gare douf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Sain anĩ bun, Moses wõ yen, ĩ Negur mala bun kesu meli bagai. Ogõ towo, tama nẽ fõ bun kulatun difen. ");
INSERT INTO dad_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sain ĩ mayarẽ dinenẽ di, Farao ne baraim yalen, ĩ yogon kesu ouf nigin yale iroulen. ");
INSERT INTO dad_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses ĩ, Isip neid keleĩ biya adok difelnẽ di, wogõya bun ado ereb ereb age fediya nigin, tamo megeir ado wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses ĩ yogon yar foti mog, ĩ Israel tura tar ki fediyouf nigin kisi fen. ");
INSERT INTO dad_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Moses ĩ, idi neid taka Isip tamom to biya fiyẽ mog, ilen, anĩ nigin, ĩ Israel tura isenne ken, aba solof Isip tamo anĩ yukesin. ");
INSERT INTO dad_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses kisi fen, yogon tamo kayau keleĩ youf, are Negurem idi kafĩ fiya bun tamal gei fediyouf nigin, ĩ itonek, anĩ ere, idi to kelein. ");
INSERT INTO dad_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","We fele di, Israel tamo kusĩ de mog, Moses wõ yen. Ĩ, idi komo difouf nigin daũ gudũf fen, iron, ‘Are ã tutur, ere nigin ã abob darau wenẽgef?’ ");
INSERT INTO dad_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Anĩ ere, tamo ĩ, ne tã darau ifenen anim, Moses sur fiyẽ ira ken, iron, ‘Aim õ amã bun, uyu irouya ado es fiya tamo inenon? ");
INSERT INTO dad_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Õ nor Isip tamo ukesin gen, ayag ago unakesiyou fenẽ de?’ ");
INSERT INTO dad_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses od enei karĩ ye fen, ĩ Midian teneub bun iya ilen, an ĩ yaũ tamo ibod ken, kesu monog uru adon. ");
INSERT INTO dad_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Yar foti ilele di, engel taka, gerere tuan Sinai Arei non, aa balai duri ado an yã bale namen, Moses bun wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses anĩ ile fen, terefeit yen. Ĩ tutuk ilouf nigin aa non iyok ile mog, ĩ Odug nẽ ait karĩ yen, ");
INSERT INTO dad_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Aya tubuĩ tar neid Negur, Abraham, Isak, Jakop idi neid Negur.’ Moses kumĩ tererẽ ye fen, lo fiya itoron. ");
INSERT INTO dad_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Age fe di, Odug Moses irokenen, ‘Ogon sendel unukakã, ere nigin, modoũ õ ufaref nẽ are fateul teneub. ");
INSERT INTO dad_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Momoi, aya neu tamo kayau Isip oun darau fatuk bagai dale mog, ailen. Aya idi neid kaĩya karĩ au fen, idi kafĩ fiya bun tamal alelnẽdiyouf nigin asin. Anĩ nigin, gama usi, aya sur ayõ di, Isip kel ulauf.’ ");
INSERT INTO dad_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses enei, idi kulu ĩ nigin eig de diro ken, ditoron, ‘Aim õ amã bun uyu irouya ado es fiya tamo inenon?’ De ĩ anĩ, Negurem idi uyu iroukenẽdiyouf nigin ado kafĩ fiya bun tamal yalelnẽdiyouf nigin, engel aa balai bun yã bale namen Moses mala bun wõ yen anĩ bunem sur fiyen. ");
INSERT INTO dad_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ĩ, tamo kayau Isip temeleid uyu iroukeneĩd fen, Isip an, Maaĩ Giriya bun ado, yar foti gerere tuan, memelik uris ado inodin. ");
INSERT INTO dad_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moses de anim, Israel tamo kayau eig ye irokenẽdin, ‘Negur ĩ, ãgenei tamo kayau bun tamal, profet taka aya gen sur feneĩf.’ ");
INSERT INTO dad_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ĩ, engel Sinai Arei bun wogõ fiyen anĩ ado tubuda tar geid, gerere tuan tamo kayau guru fiya atun ibod ken, mata ibodõya od ifenẽdi di, tobol fe isi, ã bun isiyouf nigin od anĩ yalen. ");
INSERT INTO dad_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Anĩ ere, tubuda tar, Moses nẽ od dõ fiya ditoron. Idi Moses anĩ ditor ken, Isip kel ileya nigin waud iron. ");
INSERT INTO dad_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Age de fen, idi Aron dirokenen, ‘Uyu diroukanamãf nigin, waitou uneye kanamãdiyouf. Ere nigin, Moses enei, Isip tamal gei famã irousin ĩ bun ereb wõ yen are, amã keleĩ sã.’ ");
INSERT INTO dad_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Sain anĩ bun, idi idegẽya waitou bulmakau lubu dinon. Idi anĩ bun sesewi dife fen, idi imedim dinon anĩ nigin seli dabiyou fenẽ, tar odug dinon. ");
INSERT INTO dad_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Anĩ nigin, Negur idi itornẽdi di, saa ilun nẽ megeir anĩ seli dabiyouf nigin folõ feid len. Are profet neid buk bun itotoya yenek kilei: “‘O Israel tamo kayau, ã gerere tuan oun, foti yar bun, sesewi fiya ado ofa wanagen, anĩ ere, ã aya yanau to seli wabigen. ");
INSERT INTO dad_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ã idegẽya waitou Molek nẽ salafat unog fen, ãgenei waitou Refan nẽ barisa yana walesegen, are idegẽya waitou ã selid wabidigouf nigin unodigen. Anĩ nigin, aya ã ãgenei teneub bun tamal alelnei ken, oun Babilon kantri ubodõgouf nigin sur ayeĩf.’ ");
INSERT INTO dad_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Sain neda tubuda tar gerere tuan dibodon, idi Negur nẽ salafat adon, salafat anĩ bun Negur ibod ken, od wogõ yedig. Salafat are, Negur Moses irokenẽ di, Negur Moses ifelnen kilei bagai dinon. ");
INSERT INTO dad_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Neda tubuda tar, salafat dalen anĩ dirou fen, Josuam uyu irou di, Negur tubuda tar meleid bun haiden irud iraile, diya di, teneub anĩ dalen an salafat dirou disin. Salafat anĩ, teneub anĩ bun ibodon, ile Dawid nẽ sain bun. ");
INSERT INTO dad_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Negur Dawid isennẽ el fe di, Dawid wau el fen, anĩ Jakop nẽ Negur ibodõf nẽ modoũ, inim inouf nigin Negur irokenen. ");
INSERT INTO dad_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Anĩ ere, Dawid naal Solomon im, Negur nẽ fõ inon. ");
INSERT INTO dad_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Anĩ ere, Negur Ilun Bagai ĩ, tamo imedim fõ dinof anĩ bun to ibodõdig, are profet eig ye irok kilei: ");
INSERT INTO dad_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Odug irok, saa are neu king nẽ sia, teneub are yeu inoya nẽ sawa. Ã ere fõ anĩ aya unokanagauf? Neu si inoya nẽ modoũ nain ibodok? ");
INSERT INTO dad_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Aya imaum eneidi ganan to anodin de?’ ");
INSERT INTO dad_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ã uleĩ teregein yediya tamo, ã wauĩ ado wedereĩ fitok yukeledin! Ã ãgenei tubuĩ tar gen, faimud Awa Uur Fateul dudum wiyẽgedig! ");
INSERT INTO dad_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tubuĩ tar profet taka to darau difenen de? Tubuĩ tar idi, Madur Tamo anĩ fau isiyouf de fen, wogõ den tamo anidig didenkesin. Are gama Madur Tamo anĩ kiwai wenẽg fen, ukesigen. ");
INSERT INTO dad_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ã, lo engel bunem kabĩ bun difenen anĩ walegen, anĩ ere, ã anĩ to dõ gen.” ");
INSERT INTO dad_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Idi enei karĩ de fen, idi nameid fatuk bagai sane fen, ĩ nigin goboreid kikokõ yedin. ");
INSERT INTO dad_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Anĩ ere, Stiwen, Awa Uur Fateulem barikã, saa ilun mala ira ken, Negur nẽ fula fiya medeĩya ado Negur ima biya melẽ Jesus ifar mog, ilen. ");
INSERT INTO dad_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Agef fen, Stiwen iron, “Ulegef, aya saa kã fele di, Tamo Naal Negur ima biyalẽ ifar mog, ailef.” ");
INSERT INTO dad_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Age ye di, idi aiteid odugem kakaĩ de, imedim wedereid fitok du ken, idi adok ĩ garan gududu den. ");
INSERT INTO dad_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Idi taun tamal Stiwen dĩ de dirou dile, serẽ meein tulu difiyen. Age dife mog, Stiwen bou bun od dun idi, nedi kolos dinukaka ken, tamo gaũ yana Sol ĩ ye gariyan gõ difen. ");
INSERT INTO dad_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Idi Stiwen meein tulu difiyẽ mog, Stiwen kosẽ yen, “Odug Jesus, neu uur wale.” ");
INSERT INTO dad_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Age ye fen, ĩ ibor itenana ken, wade iweig iron, “Odug, mosor age difef enei mala solo to wenẽdiyouf.” Ĩ agef irokel fen, laa fen. ");
INSERT INTO dad_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol ĩ Stiwen dukesiyouf nigin, idi geid waud tekelein. Naa anĩ bun, darau odug Jerusalem sios bun wõ yen. Age fe di, momoiya tamo kayau ganan firagagaũ dife, Judia ado Samaria distrik bun dilelen, aposel dogol Jerusalem difaren. ");
INSERT INTO dad_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Negur oroya dõ difedig tamo tunĩ Stiwen mũ difel fen, ĩ nigin waud fatuk gudũf, inã loguren. ");
INSERT INTO dad_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Anĩ ere, Sol gariya ino, sios daũ fouf nigin age fen. Ĩ fõ bun fõ bun ile fen, momoiya tamo kayau geif fen, kalabus bun inenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Momoiya tamo kayau firagagaũ de dilelen, idi dilelen nẽ an biya od wogõ den. ");
INSERT INTO dad_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip Samaria neid taun taka bun ile fen, an Kristus nigin wogõ yen. ");
INSERT INTO dad_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tamo kayau, Filip nẽ od karĩ den ado ĩ memelik inodin anĩ dile fen, idi ganan Filip wogõ yen anĩ bun kisi fatuk dino, karĩ difiyen. ");
INSERT INTO dad_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tamo kayau musei bun tamal, kaa sesen kakaĩ de ulolõ deis diyalelen, ilolaisin musei ado yeid fefu fedin musei el fedin. ");
INSERT INTO dad_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Anĩ nigin, taun anĩ bun kulĩya odug adon. ");
INSERT INTO dad_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tamo taka yana Simon dedig an ibodon, ĩ taun anĩ bun idegẽya kosẽ inodidig, anĩ bunem Samaria tamo kayau ganan terẽ fiyẽdidig. Ĩ yogo nigin anĩ, aya tamo odug yedig. ");
INSERT INTO dad_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Age fe di, tamo kayau yeneid adodo, yeneid sãsã geid ganan, ĩ bun kisi fatuk dino karĩ difiye ken, diron, “Tamo enei, Negur nẽ megeir, Megeir Odug dedig anĩ.” ");
INSERT INTO dad_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Idi ĩ bun kisi fatuk dino karĩ difiyen, ere nigin, ĩ sain meluk idegẽya kosẽ bunem terẽ fiyẽdidig. ");
INSERT INTO dad_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Anĩ ere, sain Filip Negur nẽ tano ado Jesus Kristus yana nigin biya od wogõ ye di, idi in od momoi den, age dife di, idi naan igunẽdin, tamo ado kayau geid. ");
INSERT INTO dad_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon ĩg momoi ye di, naan igunen. Agef fen, Filip nain be ilef are, ĩ dõ felef iyo ken, memelik uris ado odudug wõ yedin anĩ ileid fen, terẽ yen. ");
INSERT INTO dad_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposel Jerusalem dibodon idi, Samaria tamo kayau, Negur nẽ od mogo dalen anĩ karĩ de fen, idi, Pita Jon ado, idi gedin sur difedin. ");
INSERT INTO dad_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Idi an wõ de fen, Samaria tamo kayau Awa Uur Fateul dalouf nigin kosẽ den, ");
INSERT INTO dad_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ere nigin, Awa Uur Fateul idi taka bun fau isiya san, idi Odug Jesus yana bunem naan igunẽdin dogol. ");
INSERT INTO dad_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Age dife fen, Pita Jon ado, imeid idi tetedin dino di, idi Awa Uur Fateul dalen. ");
INSERT INTO dad_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposel imeid tamo kayau tetedin dino di, tamo kayau Awa Uur ifenẽdin, Simon anĩ ile fen, aposel moni ifenẽdiyouf nigin agef fen, ");
INSERT INTO dad_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","iron, “Ayag megeir enei wanage di, taka teten imau ano di, Awa Uur Fateul yalouf.” ");
INSERT INTO dad_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Age ye di, Pita ĩ irokenen, “Ogon moni õ ado inanakalauf, ere nigin, õ Negur nẽ ege luwa, Awa Uur Fateul moni nem na yaleya kisi feleya wol. ");
INSERT INTO dad_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Õ amã nemã kabĩ bun, amã geid katõ tekelei sã, nemã kabĩ taka to walef, ere nigin, Negur mala bun waũ tutuk sã. ");
INSERT INTO dad_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ani nigin, sane enei nigin waũ falei wo fen, Odug bun kosẽ wo. Õ waũ bun kisi agef yenek anĩ nigin Odug weder tu kalauf be. ");
INSERT INTO dad_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ere nigin, õ waũ bun dirikeĩ bagai fen, mosorem irounok anĩ ailef.” ");
INSERT INTO dad_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Age ye di, Simon solof iron, “Ereb ã wogõ gel anĩ, aya bun to wõ youf nigin, Odug kosẽ wiyẽg.” ");
INSERT INTO dad_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita Jon ado, Odug nẽ od kurõ difeis fen, wogõ difiyẽdin, age difel fen, idi Jerusalem keku de, naab luwen Samaria fonõ musei bun biya od wogõ de dilen. ");
INSERT INTO dad_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Odug nẽ engel Filip irokenen, “Fã wo fen, õ saut melem naab gerere tuan ibodok an ule, naab are Jerusalemem isil, Gasa taun wõ yen.” ");
INSERT INTO dad_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Anĩ nigin, Filip fã ye fen, ilen, luwen Itiopia tamo faat korõ feleya anĩ ĩ ket ile mog, fotou fiyen, tamo are Itiopia nẽ kuin Kandasi nẽ safina ganan lo fiya tamo, yana odug ado. Ĩ Negur yana yalesauf nigin Jerusalem ilen, ");
INSERT INTO dad_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ĩ karis bun ibod ken, kel yogon fonõ naab yale ile fen, profet Asaia nẽ buk iwesef ilen. ");
INSERT INTO dad_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Awa Uur Filip irokenen, “Karis anĩ garan ule fen, non ufar.” ");
INSERT INTO dad_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Age ye di, Filip karis anĩ garan gududu ye isel, tamo anĩ profet Asaia nẽ buk iwes mog, karĩ ye fen, to fiyen, “Õ uwesef anĩ nẽ gariya keleĩ de?” ");
INSERT INTO dad_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ĩ iron, “Tamo takam to faded fiyauf are, naig fe di, aya keleĩ youf?” Anĩ nigin, ĩ Filip isel, urom karis bun dibodõf nigin irokenen. ");
INSERT INTO dad_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Faat korõ feleya tamo are, Negur nẽ Itotoya bun yenek enei iwesen: “Ĩ sipsip dukesiyouf nigin dirou dilen gen dirou dilen, ĩ, sipsip momou siwi gudũ fiya tamo wagen dẽ yeledig gen, od taka to wogõ yen. ");
INSERT INTO dad_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ĩ lai difiye ken, ĩ to tutuk es difiyen. Taka nem yogon ibor nẽ tubu tar nigin to wogõ youf, ere nigin, yogon mata tenebur ein dalelen.” ");
INSERT INTO dad_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Faat korõ feleya tamo Filip to fiyen, “Profet ai nigin enei wogõ yef anĩ urokana, ĩ yogo nigin de, tamo taka nigin?” ");
INSERT INTO dad_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Age ye di, Filip Negur nẽ Itotoya enei bun gariya ino fen, Jesus nigin biya od wogõ fiyen. ");
INSERT INTO dad_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Idi naab diyok dile fen, naan taka bun disi fen, faat korõ feleya tamo iron, “Ulef, naan yeir, erem anĩ aya naan igunauf nigin katũ fiyaf?” ");
INSERT INTO dad_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Age ye fen, ĩ karis irou dẽ yalauf nigin irokenen. Age fe di, ĩ Filip ado kututũ deis, naanũ disil fen, Filipem naan igunen. ");
INSERT INTO dad_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sain idi naanũ tamal disele di, Odug nẽ Awa Uur Filip yale irou ilen, age fe di, faat korõ feleya tamo Filip baban to ilen, anĩ ere, ĩ kulĩya odug ado naab iyok ilen. ");
INSERT INTO dad_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Anĩ ere, Filip Asdot taun wõ ye, naab iyok ile fen, taun ganan bun biya od wogõ yef ile, Sisaria taun wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sain anĩ bun, Sol ĩ fau fau Odug nẽ dõ fiya tar idenkesiya nigin wau ifokel fen, kumĩ ifenẽdif isin. Anĩ nigin, ĩ pris neid mudur garan ile fen, ");
INSERT INTO dad_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damaskus taun oun Juda neid uub fõ fõ bun pas itotkenẽdiyouf nigin irokenen, are ĩ an Odug nẽ naab dõ difef anidi, tamo be kayau be, taka fotou fiyẽf are, ifokel yale, Jerusalem irou ilauf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol ĩ ile Damaskus wõ you fenẽ mog, kaisã bagai, fula fiya taka saa ilun tamal, ĩ bun fulaf irailen. ");
INSERT INTO dad_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Age fe di, ĩ tenebur kubũ ye isil fen, ait taka wogõ fiyẽ mog, karĩ yen, “Sol, Sol, ere nigin õ aya daig wiyaf?” ");
INSERT INTO dad_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Age ye di, Sol to fen, “Odug, õ aim?” Ĩ iron, “Aya Jesus, õ daig wiyaf anim. ");
INSERT INTO dad_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Fã wale fen, taun ule, an õ ereb ago wouf nigin irokonõf.” ");
INSERT INTO dad_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tamo tunĩ Sol geid dilen idi, an terefeit de mã, mutũ difaren. Idi ait karĩ den, anĩ ere, aib taka to dilen. ");
INSERT INTO dad_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol tenebur tamal fã yale, mala birikã felen, anĩ ere, ĩ ereb taka ileya kisi feleya san. Anĩ nigin, idi ima gim de, Damaskus diroulen. ");
INSERT INTO dad_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ĩ naa towo lo fiya kisi feleya san, agef fen, saaf ado naaneg to yon. ");
INSERT INTO dad_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskus an, dõ fiya tamo taka yana Ananias ibodon. Ĩ mala seleulã kurã fen sain, Odug ĩ irokenen, “Ananias!” fiyẽ di, ĩ iron, “Odug, aya yeir.” ");
INSERT INTO dad_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Odug Ananias irokenen, “Fã wale, naab yana Naab Madur dedig an, Judas nẽ fõ bun ule fen, tamo taka Tasus tamal, yana Sol nigin to wouf. Ĩ kosẽ yef ibodok. ");
INSERT INTO dad_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ĩ mala seleulã kurãf fen, tamo taka yana Ananias isi, baban mala lo fouf nigin ima teten ino mog, ilen.” ");
INSERT INTO dad_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias solof iron, “Odug, aya tamo enĩ nẽ od, Jerusalem oun ogon tamo kayau fateul daig fiyẽdin, are museim mogo dirokana di, karĩ aun. ");
INSERT INTO dad_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ĩ, tamo kayau ganan õ yana seli dabidig anidi, kafĩ fiya bun inenẽdiyouf nigin, pris odudug bun tamal megeir yale fen, ein isin.” ");
INSERT INTO dad_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Anĩ ere, Odug Ananias irokenen, “Õ ulauf, tamo enei are, neu yanau, haiden, dogo neid king ado, Israel tamo kayau bun irou ilauf nigin agirnen. ");
INSERT INTO dad_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ĩ aya yanau nigin darau naig be fiya yalouf are, fau aya yug afelnẽf.” ");
INSERT INTO dad_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Age ye di, Ananias fõ anĩ bun ilen, aaben ile fen, ima Sol teten ino fen, iron, “Turau Sol, Odug Jesus õ ein usi mog, naabur õ bun wõ yen ĩ, õ baban malã kelẽ wol fen, Awa Uur Fateul aura yõf nigin sur fiyal.” ");
INSERT INTO dad_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kaisã bagai, Sol mala bun tamal, ereb gau genĩ gen anĩ kuku ralaisin, age fe di, ĩ baban mala kelẽ yelen. Ĩ fã yale di, naan igunen. ");
INSERT INTO dad_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Age fel fen, saaf yõ di, ĩ bouwa baban totol kel yalen. Sol ĩ, Damaskus an, naa tunĩ dõ fiya tar geid dibodon. ");
INSERT INTO dad_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ĩ kaisã bagai gariya ino, Juda neid uub fõ fõ bun od wogõ ye iron, Jesus ĩ Negur Naal yen. ");
INSERT INTO dad_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Idi ganan ĩ karĩ difiyen idi terẽ de fen, to difen, “Im anĩ, Jerusalem oun Jesus yana diweignẽdig tamo kayau tadũ fedin anĩ sã de? Im anĩ, tamo kayau ifofã, pris odudug gedin irou ilauf nigin isin anĩ sã de?” ");
INSERT INTO dad_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Anĩ ere, Sol nẽ od wogõya totolef ilen, agef fen, Jesus anĩ Kristus ye yaor fe, wogõ ye di, Juda tamo idi Damaskus dibodon anidi, yogon od solo fiyẽya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Naa musei ilele di, Juda tamo idi, Sol yukesiya nigin kisi katõ difen, ");
INSERT INTO dad_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","anĩ ere, Sol idi kisi dinon are kelein. Idi Sol dukesiyouf nigin, naa ganan bõ ado gaa ado, taun nẽ kau bobog bun ololo difiyen. ");
INSERT INTO dad_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Anĩ ere, bõ taka bun, in dõ fiya tar ĩ dale, karam bun dife fen, kau kurenem folo folõ dife di, tenebur isilen. ");
INSERT INTO dad_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sain Sol Jerusalem ile fen, dõ fiya tar geid weim bagu difouf nigin age fen. Anĩ ere, idi Sol ĩ dõ fiya tamo taka wõ yen anĩ to momoi de fen, ganan ĩ nigin kumĩ den. ");
INSERT INTO dad_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Anĩ ere, Banabas ĩ Sol yale, aposel gedin iroule fen, Sol ĩ naab luwen Odug ile di, ĩ wogõ fiyen ado, Sol Damaskus oun, kumĩ sã Jesus yana bunem wogõ yen anĩ, aposel faded fedin. ");
INSERT INTO dad_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Anĩ nigin, Sol idi weim dibod ken, Jerusalem oun karika bagai iyo ken, Odug yana bunem, kumĩ sã biya od wogõ yef iyon. ");
INSERT INTO dad_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ĩ Juda tamo Grik od wogõ dedig anidi geid, od wogõ de fefe den, ani ere, idi ĩ dukesiyouf nigin age difen. ");
INSERT INTO dad_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kabĩ tura tar enei kelei ken, idi ĩ dale, Sisaria taun dirou dilen, anenem Tasus taun sur de dirã di, ilen. ");
INSERT INTO dad_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Anĩ nigin, sios an Judia, Galili ado Samaria teneub ganan bun, idi wau inosiya sain biya ado fen, megeir ifenẽdin. Idi Awa Uur Fateul nem waud yalese di, Odug nigin aniniya ado dibodok dile di, momoiya tamo kayau musei len. ");
INSERT INTO dad_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ĩ modoũ ganan iyokelen, agef fen, ĩ Lida tauneg Negur nẽ tamo kayau ki fediyouf nigin ilen. ");
INSERT INTO dad_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Pita, an tamo taka yana Ainias bouwa ilolaisin, ĩ yar eit fataren yenẽyai yedig fotou fiyen. ");
INSERT INTO dad_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita Ainias irokenen, “Ainias, Jesus Kristus õ el yok. Fã wale fen, ogon bedu madur wo.” Kaisã bagai, Ainias fã yalen. ");
INSERT INTO dad_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tamo kayau, Lida taun ado Saron fonõ dibodon idi ganan ĩ dile fen, waud falei ye, Odug nigin momoi den. ");
INSERT INTO dad_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa an, dõ fiya kayau taka, yana Tabita (anĩ Grik od bun Dokas dedig) ibodon. Ĩ faimud tobonunã biya inodidig ado maleg isennẽdidig. ");
INSERT INTO dad_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Sain anĩ bun, Tabita dagi yale fen, laa fen. Ĩ laa fe di, yogon bouwa buru naan digune kel, fõ aab ilun dinenẽ di, yenen. ");
INSERT INTO dad_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida taun are Jopa taun non. Anĩ nigin, dõ fiya tar, Pita Lida ibodok yeya karĩ de fen, tamo uru sur dife di, ĩ gein dile, totol bagai dirokenen, “Kaisã bagai talauf!” ");
INSERT INTO dad_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Anĩ nigin, Pita idi geid dile, an ulõ yesi di, idi Pita fõ aab ilun dale dirou diselen. Kayau waab ganan an Pita salili difiye ken, idi inã dale fen, Dokas ĩ fau matan ibod ken, kolos ado saket iwadin anĩ ganan difelnen. ");
INSERT INTO dad_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Anĩ ere, Pita idi ganan mayarẽ sur feid fen, ĩ ibor bobou fe kosẽ yen. Agef fen, ĩ falei yel, kayau nẽ bouwa buru irokenen, “Tabita, fã wale.” Kayau ĩ mala birikã feid, Pita ile fen, fã yale ibodon. ");
INSERT INTO dad_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Age fe di, Pita kayau ima irou yalesnẽ di, ĩ fã ye ifaren. Age fel fen, Pita, momoiya tamo kayau ado kayau waab geid iweigneĩd fen, Dokas ĩ mata kel fã yel anĩ ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pita enei age fen are, Jopa taun ganan od iyokelen, age fe di, tamo kayau musei Odug nigin momoi den. ");
INSERT INTO dad_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita Jopa an, gaar gabar el fiya tamo yana Simon dedig ĩ ado, naa musei dibodon. ");
INSERT INTO dad_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria taun oun, tamo taka yana Konelius ibodon, ĩ wan handred kusĩ tamo neid orowa taka, ‘Itali kusĩ tamo mala’ dedig anĩ bun tamal. ");
INSERT INTO dad_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ĩ Rom tamal, Juda tamo sã, anĩ ere, Negur yana yalesedig, agef fen, ĩ yogon ibor adok geid, Negur nigin anini dedig. Ĩ Juda maleg tamo musei isennẽdidig, takag, ĩ toku Negur kosẽ fiyẽdig. ");
INSERT INTO dad_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Naa taka bun tri kilok aragau age fiya, Konelius ĩ mala seleulã kurãf fen, ĩ yaor bagai ilen, Negur nẽ engel isi fen, irokenen, “Konelius!” ");
INSERT INTO dad_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konelius kumĩ ado lo fiyekel fen, ĩ to fen, “Odug, ere?” Engel ĩ irokenen, “Ogon kosẽ ado wau sã maleg tamo bun agodig are, Negur wagen sesewi fiya gen isele di, Negur wau kulĩ yen. ");
INSERT INTO dad_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gama tamo tunĩ Jopa taun sur wodi di, dile, tamo taka yana Simon, Pita dedig dirou disiyouf. ");
INSERT INTO dad_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ĩ gaar gabar el fiya tamo Simon ado dibodok, Simon nẽ fõ are maaĩ yerin ibodok.” ");
INSERT INTO dad_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Engel Konelius od wogõ fiyekel fen, ĩ itornẽ di, Konelius yogon kabĩ tamo uru ado kusĩ tamo taka iweignẽdin, kusĩ tamo are Negur yana yalesedig ado Konelius aruna daledig anidi taka. ");
INSERT INTO dad_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Konelius ĩ, ereb wõ yen anĩ ganan irokeneĩd le fen, Jopa taun sur fedin. ");
INSERT INTO dad_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Naa anĩ ile di, idi naab diyok dile, Jopa taun kelẽ difiyẽ mog, Pita kosẽ youf nigin, fõ sokoron iselen, are gaa atun age fiya. ");
INSERT INTO dad_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita ĩ naũ fe di, ereb taka yõya nigin oron. Saaf dodok dife mog, ĩ mulã fe di, yen mog, mala seleulã kurã fen. ");
INSERT INTO dad_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ĩ, saa kã fele di, anenem ereb taka gabar odug gen, iri aiwa adodo kaleya bun irou fen, tenebur folõ fele di, isil mog, ilen. ");
INSERT INTO dad_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Anĩ namen, gaar fire fire yeid imeid adodo, gaar luwedim diyõdig ado, ninã ilun temeleid dibodon. ");
INSERT INTO dad_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Anĩ ait taka Pita irokenen, “Pita, fã wale, udenkeis fen, wõ.” ");
INSERT INTO dad_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Anĩ ere, Pita iron, “Odug, sã bagai! Aya sesen amuyẽ adodo yõya nigin katũ difaman taka to bagai õdig.” ");
INSERT INTO dad_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ait anĩ baban Pita wogõ fiyen, “Ereb taka Negur ĩ amuyẽ sã inon anĩ, to amuyẽ ado wouf.” ");
INSERT INTO dad_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Agef towo fe fen, kaisã bagai gabar kel yale, saa ilun irou iselen. ");
INSERT INTO dad_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita mala seleulã kurãf fen, ilen anĩ nẽ gariya nigin, nene ye kisif mog, Konelius tamo sur fedin idi, Simon nẽ fõ nain be ifaref anĩ to dife kelei ken, dile, fõ bobogẽ difaren. ");
INSERT INTO dad_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Idi diweig fen, Simon, yana taka Pita dedig an ibodok be anĩ to difen. ");
INSERT INTO dad_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita ĩ mala seleulã kurãf fen, ilen anĩ nigin fau kisif mog, Awa Uur ĩ irokenen, “Simon, tamo towo õ dimirnok. ");
INSERT INTO dad_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ani nigin, fã wale, tenebur kutũ weis usil. Idi geid ileya nigin to utor, ere nigin, ayam idi sur afedin.” ");
INSERT INTO dad_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita kutũ yeis isil fen, idi irokenẽdin, “Aya anĩ umirnagef. Anĩ ã ere nigin usigel?” ");
INSERT INTO dad_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Idi diron, “Amã Konelius kusĩ tamo neid orowa takam sur famã di, masil. Ĩ madur tamo, Negur nigin anini yedig. Juda tamo kayau ganan, ĩ tamo biya difiyẽdig. Engel fateul, õ Konelius nẽ fõ bun ule fen, õ urõf anĩ Konelius karĩ youf nigin ĩ irokenen.” ");
INSERT INTO dad_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Age de di, Pita, idi bõ anĩ bun an denẽf nigin, aabẽ geif iroulen. We fele di, Pita ĩ fã yale, tamo anidi weim dilen. Jopa taun temeleid kabĩ tura tar tunĩg, Pita geid weim dilen. ");
INSERT INTO dad_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Naa anĩ ile di, Pita Sisaria taun wõ yen. Konelius idi tari feid fen, ĩ yogon sirag tar ado mou tar melsã difaref anidi geid iweig laisi difaren. ");
INSERT INTO dad_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita Konelius nẽ fõ aaben isour iroule di, Konelius ĩ tarabã fiye ken, ĩ yogo lai feis, ye gariyan bobou fen. ");
INSERT INTO dad_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Anĩ ere, Pita ĩ yalesne ken, iron, “Ufar, ayag tamo maug.” ");
INSERT INTO dad_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita Konelius aaben wogõ fiyek dile fen, tamo kayau musei guru difen anĩ iledin. ");
INSERT INTO dad_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita idi irokenẽdin, “Ã aug keleĩ bagai, Juda tamo taka, haiden tamo taka ado nigal difouf be, ĩ ki fiyẽf, are lo wal fiya. Anĩ ere, aya, tamo taka sane be, amuyẽ ado be, to age auf nigin, Negur aya mogo ifelnan. ");
INSERT INTO dad_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Anĩ nigin, aya uweignag fen, tamo sur wedigen sain, aya wau uruya sã asil. Anĩ nigin, aya to ayeik, ere nigin ã uweignagen?” ");
INSERT INTO dad_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konelius iron, “Naa fo mogo ilelen, sain anĩ bun, aya neu fõ bun sain eig fe mog, tri kilok aragau kosẽ aun. Kaisã bagai, tamo taka kolos medeĩya ado, wageun ifar fen, ");
INSERT INTO dad_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","iron, ‘Konelius, Negur, ogon kosẽya karĩ yen ado, maleg bun ogon wau sã ifenẽya anĩ karĩ yelen. ");
INSERT INTO dad_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Anĩ nigin, oun Jopa taun, tamo Simon, yana taka Pita dedig gein, tamo sur wo di, idi Pita õ bun isiyouf nigin dirokenẽf. Ĩ gaar gabar el fiya tamo Simon nẽ fõ maaĩ yerin ifaref an ibodok.’ ");
INSERT INTO dad_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Anĩ nigin, aya kaisã bagai õ bun tamo sur afedin, õ usil are de agol. Odug, urokanamãf nigin irokonon anĩ ganan karĩ mauf nigin, amã ganan Negur mala bun gama yeir.” ");
INSERT INTO dad_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Age ye di, Pita iron, “Aya gama momoi bagai keleĩ, are Negur ĩ taka nigin dogol to wau yenẽdig, ");
INSERT INTO dad_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","anĩ ere, teneub ganan bun, tamo taka ĩ Negur nigin anini ye fen, tobonunã biya age fedig are, Negur ĩ nigin wau yenek. ");
INSERT INTO dad_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Israel tamo kayau bun, Negur od sur fen anĩ ã keleĩ, biya od eig ye wogõ yen, Jesus Kristus, ĩ ganan neid Odug, ĩ bunem maur gudũ fiya wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ã keleĩ, Jon naan igunẽdiya nigin od wogõ yele di, Galili distrik oun gariya ino fen, Judia distrik ganan bun ereb wõ yen anĩ. ");
INSERT INTO dad_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ã keleĩ, Negur, Jesus Nasaret tamal bun, Awa Uur Fateul ado megeir fi fele di, Jesus iyo ken, tobonunã biya agef fen, Satan nẽ megeir farumen dibodok anidi ganan el fiyẽdin, ere nigin, Negur ĩ ado ibodon. ");
INSERT INTO dad_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Amã, Jerusalem ado Juda neid teneub bun, ereb Jesus age fen anĩ ganan malamã mailen. Idi ĩ aa tetek bun dũ di, laa fen. ");
INSERT INTO dad_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Anĩ ere, Negur ĩ naa towo ilele di, laa bun tamal ĩ turĩ fiyẽ di, tamo kayau dilouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Anĩ ere, tamo kayau ganan ĩ dilouf nigin to age fen, Negur mogo igirnẽdin anidim dogol dilouf nigin age fen, are amam Jesus laa bun tamal mata kel fã ye fen, weim saaf ado naan mon anim. ");
INSERT INTO dad_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ĩ, amã tamo kayau biya od wogõ mafiyeĩd fen, Jesus ĩ mata nẽ ado laa nẽ es fiya tamo ĩ Negurem igirnen anĩ, kurõ mafesiyouf nigin irokanaman. ");
INSERT INTO dad_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Profet ganan ĩ nigin kurõ difeis wogõ den, are taka ĩ Jesus nigin momoi youf are, Jesus yana bunem yogon mosor nigin weder tu kalauf.” ");
INSERT INTO dad_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ĩ fau od enei wogõ ye mog, Awa Uur Fateul od karĩ den anidi ganan bun isin. ");
INSERT INTO dad_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Juda momoiya tamo mulũ bun temeleid Pita geid disin idi, Negurem Awa Uur Fateul wau sã haiden buneg fi fele di, dile fen, terefeit den. ");
INSERT INTO dad_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ere nigin, haiden idi od fire fire bun wogõ de, Negur yana dales mog, karĩ den. Age dife di, Pita iron, ");
INSERT INTO dad_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Taka nem, tamo kayau eneidi naan igunẽdiya nigin katũ fediyouf de? Idi amã Awa Uur Fateul malen age fiya bagai dalel.” ");
INSERT INTO dad_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Anĩ nigin, Pita, idi Jesus yana bunem naan digunẽdiyouf nigin irokenẽdin. Age fe di, Pita idi geid naa tunĩ dibodõf nigin idi Pita dirokenen. ");
INSERT INTO dad_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposel ado, momoiya tamo kayau Judia distrik ganan bun dibodon anidi, haiden idig Negur nẽ od dalen yeya anĩ karĩ den. ");
INSERT INTO dad_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sain Pita Jerusalem isele di, Juda momoiya tamo mulũ bun temeleid kekeir od diroken ken, ");
INSERT INTO dad_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","diron, “Õ haiden mulũ to dilen neid fõ bun ule fen, weim saaf wõgen.” ");
INSERT INTO dad_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Age de di, Pita gariya ino, ereb ereb ganan wõ yen anĩ dir fe faded fiyẽdin, ");
INSERT INTO dad_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Aya Jopa taun abod ken, kosẽ au mog, aya mulam malau gelele fe, malau seleulã kurãf fen, ailen. Aya ereb taka gabar odug gen, iri aiwa adodo kaleya bun irou fen, saa ilun tamal, aya abodon nẽ an folõ fele di, isil mog, ailen. ");
INSERT INTO dad_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aya anĩ fele afe fen, tenebur tamal gaar fire fire yeid imeid adodo, gaar kuĩ, gaar luwedim diyõdig ado, ninã ilun temeleid ailedin. ");
INSERT INTO dad_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Agef fen, ait taka karĩ au mog, irokanan, ‘Pita, fã wale, udenkeis fen, wõ.’ ");
INSERT INTO dad_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Anĩ ere, aya aron, ‘Odug, sã bagai! Aya sesen amuyẽ adodo yõya nigin katũ difaman taka to bagai õ ailen.’ ");
INSERT INTO dad_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ait anĩ baban saa ilunem wogõ yen, ‘Ereb taka Negur ĩ amuyẽ sã inon anĩ, to amuyẽ ado wouf.’ ");
INSERT INTO dad_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Agef towo fe fen, anĩ ganan baban kel dĩf, saa ilun irou iselen. ");
INSERT INTO dad_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sain anĩ bun bagai, tamo towo aya gein Sisariam sur difedin idi, fõ aya abodõdig nẽ an wõ den. ");
INSERT INTO dad_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Awa Uur aya idi weim ileya to atorõf nigin irokanan. Kabĩ turau tar sigis eneidig, aya weim mele, tamo anĩ nẽ fõ namen melen. ");
INSERT INTO dad_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Age mafe di, ĩ engel taka naig be fe fen, yogon fõ bun wõ ye fen, eig ye irokenen, ‘Jopa taun oun, Simon yana taka Pita dedig gein tamo sur woid. ");
INSERT INTO dad_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Õ ado ogon ibor tar ganan kel gei yeĩf nigin, ĩ od õ gein irou isiyouf,’ ye di, ilen anĩ irokanaman. ");
INSERT INTO dad_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Aya od gariya ano, wogõ au mog, Awa Uur Fateul uruwa bun ada bun isin gen, idi buneg agef isin. ");
INSERT INTO dad_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Age fe di, aya Odug eig ye iron anĩ, wederou fokõ yen, ‘Jon ĩ naanem igunẽdin, anĩ ere, ã Awa Uur Fateulem iguneĩf.’ ");
INSERT INTO dad_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Anĩ nigin, ada Odug Jesus Kristus nigin momoi tau di, Negur wau sã ege luwa ifanadan anĩ, idig ifenẽdin anĩ youf are, aya ai nigin Negur naabura gudũ afiyẽf?” ");
INSERT INTO dad_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Idi od enei karĩ de fen, idi kekeir od ditor ken, Negur yana dales diron, “Age fiyauf are, Negur ĩ haiden idig waud falei de fen, mata bun dilauf anĩ ifenẽdin.” ");
INSERT INTO dad_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiwen dukesin sain bun, kafĩ fiya wõ ye di, momoiya tamo kayau firagagaũ dife fen, tunĩ Fonisia distrik, Saipras nuyo ado, Antiok taun dile fen, Juda tamo kayau bun dogol biya od wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Anĩ ere, idi tunĩ Saipras nuyo ado Sairini taun temeleid, Antiok taun dile fen, Grik tamo kayau buneg wogõ de fen, Odug Jesus nigin biya od dirokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Odug nẽ megeir idi adon, age fe di, tamo kayau musei momoi de fen, Odug bun falei den. ");
INSERT INTO dad_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Od enei, Jerusalem taun oun sios bun iyokele di, idi Banabas Antiok taun sur difiyen. ");
INSERT INTO dad_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabas an wõ ye, Negur wau ifenẽdin anĩ ilen, ĩ kulĩ ye fen, idi waud adok Odug bun momoi dibodõf nigin ganan waud yalesen. ");
INSERT INTO dad_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas ĩ tamo biya, Awa Uur Fateul ado momoiya barikã. Tamo kayau musei Odug bun geif iroulen. ");
INSERT INTO dad_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Age dife di, Banabas Sol imirnẽf nigin Tasus ilen. ");
INSERT INTO dad_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Banabas Sol fotou fiye ken, Sol Antiok taun irou isin. Agef fen, Banabas Sol ado yar tekelei adok, sios geid dibod ken, tamo kayau musei difelnẽdin. Antiok an, dõ fiya tar anidi bun yana mata dun, are Kristen den. ");
INSERT INTO dad_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sain anĩ bun, profet tunĩ Jerusalem anenem Antiok disin. ");
INSERT INTO dad_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Idi neid taka, yana Agabus fã ye fen, Awa Uur bunem profet od wogõ yen, kadir odug Rom teneub ganan bun iyokalauf yen. (Sisa Klodius nẽ sain bun, kadir enei wõ yen.) ");
INSERT INTO dad_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Dõ fiya tar, idi mugu mugu, dogo neid megeir bunem, momoiya tamo kayau Judia distrik bun dibodon anidi disennẽdiyouf nigin, kisi difon. ");
INSERT INTO dad_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Idi enei age de fen, moni wau sã Banabas Sol ado imeid bun dino, sios nẽ uyu irouya anidi bun sur difen. ");
INSERT INTO dad_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sain anĩ bun, King Herod sios bun temeleid tunĩ kafĩ fiya ifenẽdiyouf nigin, gei fedin. ");
INSERT INTO dad_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ĩ irõ di, Jon tura Jems dimig nem dukesin. ");
INSERT INTO dad_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herod ĩ Jems laa fe di, Juda tamo kayau waud al fen anĩ ile fen, ĩ Pitag dalouf nigin ari fedin. Enei are, Bret Yis Sã Sifa sain bun wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Idi Pita dale di, ĩ kalabus bun inenen, ĩ kusĩ tamo mala aiwa adodo, mala mugu mugu kusĩ tamo aiwa adodom lo difouf nigin idi imeid bun inon. Herod ĩ, Pasa naa ilele di, ganan meleid bun, Pita kot bun inenẽf nigin kisi yalen. ");
INSERT INTO dad_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Anĩ nigin, Pita kalabus bun dinenẽ ibodon, anĩ ere, sios idi Pita nigin Negur totol bagai kosẽ difiyen. ");
INSERT INTO dad_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod ĩ Pita fau nil kot bun ifarauf ye mog, bõ anĩ bun, Pita sen uru nem ifokeleya ado kusĩ tamo uru atun mulã yenen, kalabus bobog lo fiya tamo, bobog tari de difaren. ");
INSERT INTO dad_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kaisã bagai, Odug nẽ engel wõ ye di, kalabus Pita ibodon aab namen fula felen. Agef fen, engel Pita siri yu ken, turĩ fiyẽ iron, “Gama nem, fã wale!” Age fe di, Pita ima bun tamal sen irokakakesin. ");
INSERT INTO dad_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Age fe di, engel Pita irokenen, “Ogon let luwã gu fen, sendel ufounkel.” Age fele di, engel Pita irokenen, “Ogon kolos meluk ufounkel, dõ wiya.” ");
INSERT INTO dad_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita engel dõf kalabus bun tamal ilen, anĩ ere, ĩ engel age fen are, momoi bagai be anĩ to kelein, ĩ malau seleulã kurã fe di, ailef yen. ");
INSERT INTO dad_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Idi, kusĩ tamo kalabus bobog lo difedig uyulil ado anĩ dõ fiya, wal difeid fen, taun isileya ain bobog bun disi di, sukar are yogo kã fel kenẽdin, age fe di, idi ulolõ desin. Idi naab taka luwe diyok disil fen, kaisã bagai engel Pita itornen. ");
INSERT INTO dad_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Age fe di, Pita weder fokõf mã, iron, “Momoi bagai aya gama keleĩ, Odug engel sur fe di, aya Herod nẽ megeir bun ado Juda tamo idi ereb wõya nigin kisi difen anĩ ganan bun tamal yalelnal.” ");
INSERT INTO dad_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Enei nigin weder fokõ yel fen, Pita ĩ, Jon yana taka Mak dedig sina Maria nẽ fõ bun ilen, an tamo kayau musei guru de fen, kosẽ def dibodon. ");
INSERT INTO dad_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita fõ sukar godu godu fe di, kabĩ kayau taka yana Roda dedig sukar kã fouf nigin isin. ");
INSERT INTO dad_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ĩ Pita ait karĩ ye fen, fatuk bagai kulĩ ye fen, ĩ sukar kã fiya sã, kel gudu ref ile fen, iron, “Pita yeir bobogẽ ifaref!” ");
INSERT INTO dad_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Idi ĩ dirokenen, “Õ wadak.” Anĩ ere, kayau ĩ totol bagai ino fen, agef irõ di, idi diron, “Are Pita nẽ engel.” ");
INSERT INTO dad_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Age de mog, Pita ĩ fau fau sukar godu godu fe di, idi sukar kã difel, Pita dile fen, terẽ den. ");
INSERT INTO dad_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita foro dalauf nigin imam dogol fiyeĩd le fen, Odug ĩ kalabus bun tamal yalis irou isil anĩ faded fiyeĩd fen, iron, “Jems tura tar geid od enei urokenẽdigouf.” Age ye fen, Pita idi itorneĩd, uyu takã ilen. ");
INSERT INTO dad_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bonimei di, kusĩ tamo Pita to dile fen, fatuk bagai nene de, abob to difen. ");
INSERT INTO dad_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod Pita dimirnẽf nigin irokenẽdin, anĩ ere, idi ĩ to fotou difiyẽn. Age dife di, Herod kalabus lo fiya tamo Pita lo difen idi to fiyeĩd le fen, kalabus lo fiya tamo anidi didenkesiyouf nigin irokenẽdin. Agef fen, Herod Judia distrik bun tamal Sisaria taun ile, sain naal an ibodon. ");
INSERT INTO dad_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod ĩ, Taia ado Saidon taun tamo kayau nigin name fatuk bagai sanen, anĩ ere, gama idi waud tekelei fen, Herod dilouf nigin disin. Uyulil idi Blastus, king nẽ ibodõya modoũ nẽ lo fiya mudur, ĩ idi isennẽdiyouf nigin dirokenẽ di, Blastus yo yen. Age de fen, idi Herod garan dile, maur gudũ fiya nigin dirokenen, ere nigin, idi king nẽ akor bun tamal saaf daledig. ");
INSERT INTO dad_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Naa inon anĩ bun, Herod ĩ king nẽ kolos ifounkel, king nẽ sia bun ibod ken, tamo kayau od wogõ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tamo kayau diweig diron, “Eĩ waitou ait, tamo nẽ sã.” ");
INSERT INTO dad_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kaisã bagai, Odug nẽ engel Herod yũ iran, ere nigin, ĩ Negur yana to yalesen. Ĩ mamatem dõ di, laa fen. ");
INSERT INTO dad_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Anĩ ere, Negur nẽ od bilalaũ fel iyokelen. ");
INSERT INTO dad_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas Sol ado, dogo neid kabĩ bure difel fen, Jerusalemem keku de disin, idi Jon, yana taka Mak dedig dale fen, weim disin. ");
INSERT INTO dad_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok sios bun, profet ado tise difaren, are Banabas, Simeon yana taka Karos dedig, Lusius Sairini taun tamal, Manain (ĩ king Herod ado bibiyedin) ado, Sol. ");
INSERT INTO dad_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Idi Odug yana dales fen, kuri de mog, Awa Uur Fateul idi irokenẽdin, “Banabas Sol ado kabĩ aya agirkenẽdin anĩ dalouf nigin, gadi weleid kanag.” ");
INSERT INTO dad_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Anĩ nigin, idi kuri de kosẽ del, imeid idi tetedin dino fen, sur difedin. ");
INSERT INTO dad_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Awa Uur Fateul, Banabas Sol ado sur fedi di, idi Selusia taun dile fen, anenem waag dale, Saipras nuyo dilen. ");
INSERT INTO dad_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Idi Salamis taun wõ de fen, Negur nẽ od Juda neid uub fõ fõ bun wogõ den. Jon idi isennẽdiyouf nigin, ĩ dale weim dilen. ");
INSERT INTO dad_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Idi nuyo anĩ ganan atu diyok dile, Pafos taun wõ den. Idi an idegẽya kosẽ tamo taka, idegẽya profet Juda tamal, yana Bar-Jesus dedig fotou difen. ");
INSERT INTO dad_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bar-Jesus ĩ nuyo anĩ nẽ gawaman mudur Segius Paulus ado dibodon. Segius Paulus ĩ tamo kisi biya ado. Gawaman mudur ĩ, Negur nẽ od karĩ youf nigin, Banabas Sol ado iweignẽdin. ");
INSERT INTO dad_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Anĩ ere, idegẽya kosẽ tamo Elimas (yana are Grik od nem ‘idegẽya kosẽ tamo’) idi naabureid gudũ fe di, gawaman mudur to momoi youf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Age fe di, Sol, yana taka Pol dedig, Awa Uur Fateul barikã, ĩ idegẽya kosẽ tamo lo fiyekel fen, iron, ");
INSERT INTO dad_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Õ Satan naal, õ Negur nẽ madur fiya ganan nẽ kiwai! Idegẽya ado sesen ganan, õ bun isokosef. Õ ere sain anĩ, Odug nẽ naab madur anĩ, idegẽya bun falei fiyai wodig utorlauf? ");
INSERT INTO dad_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gama Odug ima, õ teten isif. Õ malã ifofakalauf, õ sain naal meluk, gaa lalan to ulouf.” Kaisã bagai, budũ ado gugum isi, kerub fiyẽ di, ĩ taka nem ima gim fouf nigin, ima ra yef iyon. ");
INSERT INTO dad_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gawaman mudur ĩ agef wõ yen anĩ ile fen, ĩ momoi yen, ere nigin, ĩ Odug nigin ifelnẽ di, ilen anĩ nigin terẽ yen. ");
INSERT INTO dad_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol yogon kabĩ tura tar geid, waag dale, Pafosem, Pamfilia provins oun Perga taun dilen, an Jon idi itorneĩd fen, Jerusalem kel ilen. ");
INSERT INTO dad_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Idi Perga taun anenem, Pisidia distrik nediwon Antiok taun dilen. Sabat naa bun, idi Juda neid uub fõ bun dile dibodon. ");
INSERT INTO dad_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Lo ado profet neid itotoya diwesleid fen, Juda neid uub fõ nẽ mudur adodo, Banabas Pol ado gein od sur dife fen, diron, “Turamã tar, ã tamo kayau waud yaleseya nigin od adouf are, wogõg.” ");
INSERT INTO dad_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol fã ye, foro dalauf nigin imam fiyeĩd le fen, iron, “Israel tamo kayau ado, haiden Juda tamo kayau geid Negur nigin anini gedig ã, karĩ wiyag! ");
INSERT INTO dad_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel tamo kayau neid Negur, tubumã tar igirneĩd fen, idi Isip dibodon sain, Negurem age fe di, idi fulus difen. Negur ĩ megeir odug nem, idi Isip tamal gurif irou ilen. ");
INSERT INTO dad_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Negur ĩ, foti yar age fiya gerere tuan, idi tobonunã sane age difen anĩ lolou fesif isin. ");
INSERT INTO dad_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ĩ Kanan teneub bun, tamo ibor sewen adok daũf iraile fen, dogo neid teneub, yogon tamo kayau idi akorouf nigin ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Enei ganan fo handred fifti yar age fiya ilelen. “Enei bure fele di, Negur ĩ, Israel tamo kayau es fiya tamo ifenẽdif ile, profet Samuel nẽ sain bun. ");
INSERT INTO dad_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Anĩ bure fele di, tamo kayau king nigin dirõ di, Negur, Sol Kis naal, Benjamin nẽ ibor bun tamal ifenẽdin, Sol foti yar king ibodon. ");
INSERT INTO dad_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Negur Sol yalelne ken, ĩ Dawid idi neid king inenen. Negur Dawid nigin eig ye iron, ‘Aya, Jesi naal Dawid ĩ, tamo aya wau irok kilei anĩ ailen, ĩ ereb ereb ganan, neu oroya yenek anĩ dõf age fouf.’ ");
INSERT INTO dad_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Negur ĩ age afouf yen kilei, Dawid nẽ ibor nẽ tubu tar bun tamal, kel yaleya tamo Jesus Israel ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesus fau isiya sã mog, Jon Israel tamo kayau ganan waud falei ye di, naan igunẽdiyouf nigin od wogõ yen. ");
INSERT INTO dad_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon ĩ yogon kabĩ idikalau fenẽ mog, ĩ iron, ‘Aya nigin ã aim gef? Aya tamo ĩ tari gef anim sã. Anĩ ere, ĩ aya dumeun dõ fiyaf, aya to biya nigin yogon su malũ biru fediya kisi feleya sã.’ ");
INSERT INTO dad_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Turau tar, Abraham gere tar ado, haiden ã Negur nigin anini gedig, Negur tamo kayau kel yaleya nẽ od, amã bun sur fen. ");
INSERT INTO dad_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem tamo kayau, dogo neid mudur adodo geid, Jesus ado, profet neid od Sabat naa ganan bun diwesedig anĩ to kelei ken, Jesus bouwa bun od dun, anĩ bunem profet neid od kisi fel wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Idi Jesus dukesiyouf nigin, gariya taka to dilen, anĩ ere, idi ĩ dukesiyouf nigin, Pailat dirokenen. ");
INSERT INTO dad_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Idi Jesus nigin Negur nẽ Itotoya bun yenek anĩ ganan, dõ de age difel fen, idi ĩ aa tetek bun tamal dalisne ken, matmat bun dinenen. ");
INSERT INTO dad_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Anĩ ere, Negur Jesus laa bun tamal kel turĩ fe di, mata kel fã yen. ");
INSERT INTO dad_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Agef fen, Jesus, tamo idi, ĩ geid Galili teneub bun tamal Jerusalem dilen anidi bun, naa musei wõ yen. Idi anidim gama, tamo kayau bun, ĩ nigin wogõ def dilef. ");
INSERT INTO dad_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Amã biya od ã marokeneik, Negur tubumã tar age afouf fiyẽdin are, ");
INSERT INTO dad_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jesus kel turĩ fiyen anĩ bunem, amã idi gereneid tar kisi fel naman. Sam tu bun itotoya yenek kilei: “‘Õ neu Kesu, aya gama õ Tamã wõ aul.’ ");
INSERT INTO dad_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Negur ĩ laa bun tamal kel turĩ fiyẽ di, ĩ to bagai bura lauf nigin, Negur eig ye iron: “‘Aya momoi bagai nẽ ado fateul nẽ el fiya, are aya Dawid afenẽf aun anĩ, ã afeneĩf.’ ");
INSERT INTO dad_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Negur nẽ Itotoya taka buneg eig ye irok: “‘Õ ogon Fateul Tamo to utorõ di, bura lauf.’ ");
INSERT INTO dad_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dawid ĩ yogon sain bun, Negur nẽ oroya anĩ aruna yale fen, laa fen. Ĩ tubu tar geid mũ dife di, bouwa bura len. ");
INSERT INTO dad_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Anĩ ere, Negurem laa bun tamal kel turĩ fiyen ĩ, bura leya san. ");
INSERT INTO dad_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Anĩ nigin, turau tar, ã keleĩ youf, Jesus bunem mosor weder tu keleya nigin od wogõ yeik. ");
INSERT INTO dad_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tamo ganan Jesus nigin momoi def, mosor ganan yalelkeneĩd fen, madur fedif, anĩ ere, Moses nẽ Lo bunem, tamo neid mosor ganan yalelkeneĩd fen, madur fediya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Anĩ nigin, profet wogõ den anĩ, ã bun to wõ youf nigin lo weleg: ");
INSERT INTO dad_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Ulegef, ã kono fiya tamo! Terẽg fen, gare gouf, ere nigin, aya ãgenei sain bun ereb taka age afouf, are taka nem irokeneĩfeg, ã to bagai momoi gouf.’ ” ");
INSERT INTO dad_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol Banabas ado, Juda neid uub fõ ditor dile mog, tamo kayau, Sabat naa taka bun, od enei baban tobol difouf nigin dirokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tamo kayau dilele di, Juda tamo kayau musei ado, haiden Juda neid momoiya bun falei de fen, Negur nigin anini dedig musei idi, Pol Banabas ado dõ difedin. Age dife di, Pol Banabas ado weim wogõ de fen, idi Negur nẽ wau ifenẽya bun toku dibodõf nigin waud dalesen. ");
INSERT INTO dad_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabat naa taka bun, taun dibodõdig anidi musei ganan, Odug nẽ od karĩ douf nigin guru difen. ");
INSERT INTO dad_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Anĩ ere, Juda tamo idi, tamo kayau guru difen anidi dileid fen, kiyeim aura fiyẽdi di, Pol wogõ yen anĩ nigin kiwai difen ken, kono difiyen. ");
INSERT INTO dad_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Age dife di, Pol Banabas ado kumĩ sã wogõ eig de diron, “Amã Negur nẽ od, ã bun ketem sã wogõ mayeim. Anĩ ere, ã Negur nẽ od utorõg fen, amã to biya nigin mata faimud ibodkeleya to malouf gen. Anĩ nigin, amã gama haiden gedin melef. ");
INSERT INTO dad_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Are Odug eig ye irokanaman: “‘Aya õ haiden neid lalan anenon, anĩ bunem, teneub idikelediya bun, tamo kayau usenneĩd, kel gei wediyouf.’ ” ");
INSERT INTO dad_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Haiden idi od enei karĩ de fen, waud kulĩ ye, Odug nẽ od seli dabin. Mata faimud ibodkeleya nigin igirnẽdin anidi ganan momoi den. ");
INSERT INTO dad_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Age dife di, Odug nẽ od, teneub anĩ ganan bun iyokelen. ");
INSERT INTO dad_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Anĩ ere, Juda tamo idi, haiden kayau yeneid adodo Negur nigin anini dedig ado, taun uyu irouya tamo anidi nameid dalesen. Idi Pol Banabas ado darau difenẽdiyouf nigin, tamo kayau nameid dalese di, dogo neid teneub bun tamal dirudidin. ");
INSERT INTO dad_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Anĩ nigin, Pol Banabas ado, idi neid tobonunã sane anĩ difelnẽdi di, keleĩ youf nigin, yeid aas tu difel fen, Ikonium taun dilen. ");
INSERT INTO dad_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Dõ fiya tar idi, kulĩya ado Awa Uur Fateul barikan. ");
INSERT INTO dad_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Oun Ikonium taun, Pol Banabas ado, idi gai age difedig gen, Juda neid uub fõ bun dile fen, an tamo waud yaleya bun wogõ de di, Juda tamo kayau ado Grik tamo kayau musei momoi den. ");
INSERT INTO dad_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Anĩ ere, Juda tamo momoiya sã anidim, haiden idi nameid dalese di, haiden idi, momoiya tamo kayau kiwai difenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Anĩ nigin, Pol Banabas ado, sain meluk an dibod ken, Odug nigin kumĩ sã wogõ den. Age dife di, Odug ĩ, idi memelik uris ado dinodiyouf nigin, megeir ifenẽdin, anĩ bunem, Odug yogon wau ifenẽya nẽ od anĩ megeir fen. ");
INSERT INTO dad_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tamo kayau taun temeleid faraf fen, tunĩ Juda tamo geideid, tunĩ aposel geid. ");
INSERT INTO dad_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Age de fen, Juda tamo ado haiden, dogo neid uyu irouya geid, aposel to biya difiyeĩd fen, meein tulu difiyẽdiyouf nigin age difen. ");
INSERT INTO dad_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Anĩ ere, aposel idi anĩ kelei ken, idi diya, Likonia distrik nediwon Listra taun, Derbe taun, anĩ kalilĩ fiya bun diyok dile fen, ");
INSERT INTO dad_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","an biya od wogõ den. ");
INSERT INTO dad_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Oun Listra taun, tamo taka ye ilolaisin ibodon, ĩ sina namenem ye ilolaisin wõ yen, anĩ to iyõdig. ");
INSERT INTO dad_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ĩ, Pol od wogõ ye mog, karĩ fiyen. Pol ĩ lo fiyekel fen, ĩ bouwa biya lauf nigin momoiya ado anĩ ile fen, ");
INSERT INTO dad_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pol ait odugem iweig iron, “Fã wale ufar!” Age ye di, ĩ gurusã ye, iyok ilen. ");
INSERT INTO dad_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tamo kayau musei Pol age fen anĩ dile fen, Likonia od nem diweig diron, “Waitou tamo falei difel fen, ada gein disil!” ");
INSERT INTO dad_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Idi Banabas ĩ Sus difiye ken, Pol ĩ Hermes difiyen, ere nigin, Pol ĩ ait ado tamo. ");
INSERT INTO dad_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Waitou Sus nẽ tempel, taun yerin ibodon. Waitou Sus nẽ pris, bulmakau bobõ gĩ fediya adodo, taun bobogẽ irou isin, ere nigin, ĩ tamo kayau musei geid, aposel sesewi fiya difenẽdiyouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Anĩ ere, aposel Banabas Pol ado, anĩ karĩ de fen, dogo neid kolos serek difeid fen, tamo kayau musei atun gududu de dile diweig diron, ");
INSERT INTO dad_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Tamo kayau, ã ere nigin enei ago gef? Amãg tamo maug, ã gen. Amã ã gein biya od marou masif, are ã kaũ sã enei utorõg fen, mata ibodõya Negur ĩ, saa, teneub, maaĩ ado, anidi namen ereb ereb ganan inodin, ĩ bun falei gouf nigin marokeneik. ");
INSERT INTO dad_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kulu Negur ĩ tamo kayau teneub ganan bun itornẽdi di, dogo neid oroya dõ difen. ");
INSERT INTO dad_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Anĩ ere, Negur ĩ yogo nigin yaor fiya to itor ken, faimud ereb ereb biya age fedig anĩ bunem, yogo nigin yaor fedig. Ĩ saa bunem uyẽ ado, saaf dogo neid sain dõf fen, ifeneĩdig. Ĩ saaf musei biya ifenei ken, wauĩ bun kulĩya ifeneĩdig.” ");
INSERT INTO dad_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Od enei nemeg, tamo kayau musei aposel sesewi difenẽdiyouf nigin age difen, anĩ ere, aposel idi naabureid gudũ difenẽdiyouf nigin lakĩ difen. ");
INSERT INTO dad_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Age dife di, Juda tamo tunĩ, Antiok ado Ikonium taun temeleid disi fen, tamo kayau musei waud dalen. Age de fen, idi Pol meein tulu difiyẽ, laa fel de fen, taun yerin diror diroulen. ");
INSERT INTO dad_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Anĩ ere, dõ fiya tar guru de, Pol salili difiyẽ di, ĩ fã yale fen, baban taun kel ilen. Naa taka di, ĩ Banabas ado Derbe taun dilen. ");
INSERT INTO dad_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Idi taun anĩ bun biya od wogõ de fen, dõ fiya tar musei dalen. Age difel fen, idi Listra, Ikonium ado, Antiok taun keku de dile, ");
INSERT INTO dad_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","dõ fiya tar megeir difiyeĩd fen, idi momoiya bun dibodõf nigin waud dalesen. Idi diron, “Ada Negur nẽ tano bun ileya nigin, morõ musei talouf bagai.” ");
INSERT INTO dad_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pol Banabas ado, sios mugu mugu bun, uyu irouya digirneĩd fen, kosẽya ado kuriya bunem, Odug idi ĩ nigin momoi dedig, ĩ ima bun dinenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Idi Pisidia distrik atu diyok dile, Pamfilia provins bun wowã den. ");
INSERT INTO dad_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Age de fen, idi Perga taun an od wogõ del fen, Atalia taun disilen. ");
INSERT INTO dad_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Idi Ataliam waag dale, Antiok keku de dilen, kulu an, sios, kabĩ gama bure difelel anĩ nigin, aposel idi Negur nẽ wau ifenẽya bun dinenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Idi Antiok taun wowã de fen, sios kuru difeid fen, Negur idi bunem ereb age fen anĩ ganan ado, Negur ĩ haiden momoi douf nigin sukar kã fen anĩ, wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Age dife fen, idi, dõ fiya tar geid, sain meluk an dibodon. ");
INSERT INTO dad_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tamo tunĩ, Judia distrik bun temeleid Antiok taun disi fen, momoiya tamo kayau eig de difelnẽdin, “Ã Moses nẽ tobonunã kilei, mulũ to ulagauf are, ã kel gei yeĩya kisi feleya sã.” ");
INSERT INTO dad_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Od enei nigin, idi Pol Banabas ado geid fatuk bagai fefe de fen, luwa diroun. Anĩ nigin, momoiya tamo kayau enei nigin Jerusalem disel fen, aposel ado uyu irouya geid to difiyẽdiyouf nigin, Pol Banabas ado momoiya tamo tunĩ geid digirnẽdin. ");
INSERT INTO dad_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Sios idi sur difedi di, Fonisia ado Samaria distrik atu dile fen, haiden idi Negur bun falei den anĩ dirokenẽdin. Od eneim, momoiya tamo kayau ganan fatuk bagai kulĩ den. ");
INSERT INTO dad_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Idi Jerusalem wõ de di, sios, aposel geid, uyu iroudiya anidim idi aan difiyẽdin. Age dife di, Negur idi bunem ereb age fen anĩ ganan, sios, aposel geid, uyu iroudiya wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Age dife di, momoiya tamo tunĩ Farisia mala bun temeleid, fã de fen, diron, “Haiden idi mulũ dile fen, Moses nẽ Lo dõ difouf nigin dirokenẽdiyouf bagai.” ");
INSERT INTO dad_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Age de di, aposel idi, uyu iroudiya geid, od enei nigin guru de katõ difen. ");
INSERT INTO dad_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Od musei sain meluk katõ difen sain, Pita fã yale irokenẽdin, “Turau tar, ã keleĩ, kulu, sain taka bun, haiden idi aya sigorou bun biya od karĩ de fen, momoi douf nigin, ã atun Negur aya igirnan. ");
INSERT INTO dad_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Negur ĩ, tamo nẽ wau keleĩ, ĩ Awa Uur Fateul, ada ifanadan gen, haiden idig ifenẽdin anĩ bunem, idig yaledin anĩ ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Negur, ada ado idi geid atun daũ taka to inon, ere nigin, momoiya bunem ĩ waud kulo feledin. ");
INSERT INTO dad_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Anĩ ere, ere nigin ã gama Negur kisi wiyẽg fen, morõ adag age fiya, tubuda tareg faali fiya kisi feleya san anĩ, dõ fiya tar tetedin unogouf nigin ago gef? ");
INSERT INTO dad_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Sã! Ada, idi agef kel gei fedif gen, neda Odug Jesus nẽ wau ifenẽya bunem, adag agef kel gei fadaf anĩ momoi tauf.” ");
INSERT INTO dad_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tamo kayau ganan guru difen anidi ganan foro del fen, Banabas Pol ado, Negur idi bunem memelik ado uris fire fire haiden atun inodin anĩ wogõ de di, karĩ den. ");
INSERT INTO dad_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Idi wogõ dele di, Jems ĩ iron, “Neu turau tar, karĩ wiyag. ");
INSERT INTO dad_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon mogo faded fadal, are Negur ĩ yogo yana nigin ye fen, haiden atun tamo kayau yaledin anĩ bunem, ĩ urug bagai haiden nigin wau yenen anĩ ifelnadan. ");
INSERT INTO dad_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Profet neid od are, enei ado susu felef, are Negur nẽ Itotoya bun eig ye irok kilei: ");
INSERT INTO dad_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘Enei dumen, aya kelau fen, Dawid nẽ salafat kubũ yen anĩ baban alesauf. Aya sesen ledin anĩ madur afeleid fen, baban anouf, ");
INSERT INTO dad_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","anĩ bunem, tamo kayau ganan atun tunĩ ado, haiden ganan neu nigin agirnẽdin geid, Odug dimirnẽf.’ ");
INSERT INTO dad_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Odug ĩ enei kulu bagai yaor fen, ĩ anĩ agef irok. ");
INSERT INTO dad_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Anĩ nigin, neu es fiya bun, ada haiden Negur bun falei def anidi, morõ to tafenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Age fiya ban, ada pas tatot fen, idi saaf idegẽya waitou bun sesewi difen anĩ to dãf nigin, noli tobonunã bun to dilauf nigin, yaro uleid kakã difeid fen, didenkesif anĩ to dãf nigin ado, yaro naud adodo to dãf nigin torokenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ere nigin, sain meluk bagai, Moses nẽ Lo taun ganan bun wogõ de fen, Sabat naa ganan bun Juda neid uub fõ fõ bun diwesedig.” ");
INSERT INTO dad_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Age ye di, aposel idi, uyu iroudiya ado, sios ganan geid, idi atun tamo tunĩ digirneĩd fen, Pol Banabas ado weim Antiok taun sur difediyouf nigin kisi difon. Idi Judas (yana taka Basabas dedig) ado Sailas digirnẽdin, tamo uru anidi, momoiya tamo kayau atun, idi uyu irouya. ");
INSERT INTO dad_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Idi bun pas eig de ditoton anĩ sur difen: Amã aposel, uyu iroudiya geid, ãgenei tureĩ tar, haiden bun temeleĩ turamã tar Antiok taun, Siria ado, Silisia provins bun ubodõgef aan mayeik. ");
INSERT INTO dad_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Amã nemã tamo tunĩ, yoya to dale fen, dile, idi neid wogõya bunem gelele diyei ken, wauĩ morõ difenein anĩ, amã karĩ maun. ");
INSERT INTO dad_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Anĩ nigin, amã ganan kisi tekelei mano fen, tamo tunĩ magirneĩd fen, nemã oboimã tar bagai Banabas Pol ado geid ã gein sur mafedif. ");
INSERT INTO dad_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Banabas Pol ado idi, neda Odug Jesus Kristus yana nigin, dogo neid mata itorõya nigin to fese den. ");
INSERT INTO dad_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Anĩ nigin, amã matotkeneik anĩ sigoredim megeir fiya nigin, Judas Sailas ado sur mafedif. ");
INSERT INTO dad_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Awa Uur Fateul, amã geid, kisi tekelei fen, ã bun nun enei teten baban morõ taka to mafeneĩf nigin yo maun: ");
INSERT INTO dad_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ã saaf idegẽya waitou bun sesewi difen anĩ to wãgauf, yaro naud adodo to wãgauf, yaro uleid kakã difeid fen, didenkesif anĩ to wãgauf ado, noli tobonunã bun to ulagauf. Ã enei adok irok kilei sese gouf are, ã nigin deuf. Dabuo. ");
INSERT INTO dad_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tamo idi sur difedi di, Antiok taun disil, sios kuru difeid fen, pas anĩ difenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tamo kayau pas anĩ diwes fen, waud yaleseya od anĩ nigin kulĩ den. ");
INSERT INTO dad_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Sailas ado, idi dogo profet, momoiya tamo kayau waud dales fen, megeir difenẽdiyouf nigin od fatuk wogõ den. ");
INSERT INTO dad_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Idi an sain naal meluk dibodon, age dife di, momoiya tamo kayaum waud inosiya ado sur difedi di, idi sur difedin anidi gedin keku de dilen. ");
INSERT INTO dad_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Anĩ ere, Pol Banabas ado Antiok dibodon, an idi tunĩ museig geid fen, Odug nẽ od difelneĩd fen, wogõ den. ");
INSERT INTO dad_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Naa tunĩ ilele di, Pol Banabas irokenen, “Ada keku tau fen, taun ganan Odug nẽ od wogõ tafiyẽdin nẽ an turada tar ki tafiyeĩd fen, idi naig difef anĩ tailauf.” ");
INSERT INTO dad_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas ĩ, Jon yana taka Mak dedig, idi geid dilauf nigin oron, ");
INSERT INTO dad_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","anĩ ere, Pol ĩ weim dilauf are to biya ye kisi fen, ere nigin, Jon ĩ Pamfilia provins oun idi itorneĩd fen, idi geid kabĩ to dalef dilen. ");
INSERT INTO dad_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Idi fatuk bagai fe de fen, fara difen. Banabas ĩ Mak yale fen, waag bun Saipras nuyo dilen, ");
INSERT INTO dad_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","anĩ ere, Pol ĩ Sailas igirnẽ di, momoiya tamo kayaum Odug nẽ wau ifenẽya bun dinenẽdi di, dilen. ");
INSERT INTO dad_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ĩ Siria ado Silisia provins atu ile fen, sios megeir fiyẽdif ilen. ");
INSERT INTO dad_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ĩ Derbe taun isi fen, anenem Listra taun ilen, an dõ fiya tamo taka yana Timoti ibodõdig, ĩ sina Juda tamal momoiya kayau, anĩ ere, ĩ tama Grik tamal. ");
INSERT INTO dad_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Momoiya tamo kayau Listra ado Ikonium taun temeleid, Timoti biya difiyẽdig. ");
INSERT INTO dad_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol ĩ Timoti ado dilauf nigin oron, anĩ nigin, ĩ, Juda tamo modoũ anĩ bun dibodõdig anidi nigin, Timoti mulũ inenen, ere nigin, idi ganan keleĩ, Timoti ĩ tama Grik tamal. ");
INSERT INTO dad_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Idi taun mugu mugu bun diyok dile fen, oun Jerusalem aposel idi uyu iroudiya tamo geid, tamo kayau dõ difouf nigin od difon anĩ wogõ difiyẽdif dilen. ");
INSERT INTO dad_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Anĩ bunem, sios idi momoiya megeir dale fen, naa ganan momoiya tamo kayau ifagaf ilen. ");
INSERT INTO dad_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol yogon kabĩ tura tar geid, Frigia distrik ado Galesia provins bun diyok dilen, ere nigin, Awa Uur Fateul, idi Asia provins bun od wogõya nigin katũ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Idi Misia distrik nẽ daũ bun disi fen, Bitinia provins bun dilauf nigin age difen, anĩ ere, Jesus nẽ Awa Uur ĩ katũ fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Anĩ nigin, idi Misia distrik wal dife fen, Troas taun disilen. ");
INSERT INTO dad_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Bõ anĩ bun, Pol mala seleulã kurãf fen, Masedonia provins tamal tamo taka ifar fen, igonen, “Masedonia usi fen, usennamã,” fiyẽ mog, ilen. ");
INSERT INTO dad_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol mala seleulã kurãf fen, anĩ ilen, age fel fen, amã kaisã bagai Masedonia provins malauf nigin dodok mafen, ere nigin, amã kisi mafen, Negur idi bun biya od wogõ mauf nigin iweignaman. ");
INSERT INTO dad_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas taun anenem, amã waag bunem madur kilei Samotres nuyo melen, naa taka di, Neapolis melen. ");
INSERT INTO dad_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Anenem amã Filipai melen, Filipai are Rom gawamanem lo fedig, Masedonia provins bun taun anĩ uyu irouf. An naa tunĩ mabodon. ");
INSERT INTO dad_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabat naa bun, amã taun mator ken, taun bobog serẽ naan yerin an, amã kosẽya nẽ modoũ mamirẽf nigin melen. Amã mabod ken, kayau an guru difen anidi wogõ mafiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Idi neid taka karĩ faman, kayau anĩ yana Lidia, Taiataira taun tamal, ĩ gabar kadaũ na nigin susur fedig, ĩ Negur yana yalesedig. Odug, ĩ Pol nẽ od karĩ youf nigin wau bun sukar kãf kenen. ");
INSERT INTO dad_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kayau anĩ yogon ibor tar geid naan diguneĩd kele di, ĩ yogon fõ bun malauf nigin irokanama ken, iron, “Aya Odug nigin momoi auf agef kisi gouf are, umag, neu fõ bun ubodõg.” Ĩ nugo famã di, amã dõ mafiyen. ");
INSERT INTO dad_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Naa taka bun, kosẽya nẽ modoũ bun mele mog, ferfer kayau momoul taka fotou faman, ĩ kaa sane ado, anĩ bunem ereb fau wõ youf anĩ wogõ yedig. Yogon marau tar, ĩ ereb fau wõ youf anĩ wogõ yedig anĩ bunem, moni musei daledig. ");
INSERT INTO dad_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Kayau momoul enei, amã Pol geid dõ fama ken, iweig iron, “Tamo eneidi Negur Ilun Bagai nẽ ferfer tar. Idi ã isennẽya walogouf nẽ naab dirokeneik.” ");
INSERT INTO dad_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kayau ĩ naa musei age fe di, Pol wau fatuk bagai moro ken, falei ye, kaa sane irokenen, “Jesus Kristus yana bunem, aya ĩ bun tamal ulõ wesiyouf nigin arokonok!” Sain anĩ bun bagai, kaa sane kayau anĩ itornen. ");
INSERT INTO dad_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ferfer kayau momoul nẽ marau tar, moni yaleya nẽ naab gudũ felen anĩ kelei ken, Pol Sailas ado gei de didũ difeid, maket modoũ bun yeneid adodo tamo gedin dirouledin. ");
INSERT INTO dad_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Idi Rom neid lo es fiya tamo bun guri difeid dile fen, diron, “Tamo eneidi are Juda temeleid, idi neda taun bun morõ odug dinof. ");
INSERT INTO dad_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Idi tobonunã difelnẽdif are neda lo to irok anĩ, ada Rom tamo, anĩ nigin, ada tobonunã enei to talouf, to dõ tafouf.” ");
INSERT INTO dad_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Age de di, tamo kayau, idi geid bagu de fen, Pol Sailas ado kiwai difenẽdin. Age dife di, Rom es fiya tamo kolos dinukaka keneĩd fen, wagagã difediyouf nigin dirokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Idi fatuk bagai wagagã difiyeĩd kele fen, kalabus bun dinenẽdin. Age dife fen, kalabus lo fiya tamo el fe lo fediyouf nigin dirokenen. ");
INSERT INTO dad_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kalabus lo fiya tamo od anĩ yale fen, kalabus fõ aab namen ineneĩd fen, yeid aam kotũ feledin. ");
INSERT INTO dad_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Bõ atun age fiya, Pol Sailas ado Negur kosẽ difiye ken, seg dale mog, kalabus tamo ganan karĩ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kaisã bagai, mimĩ odug fã ye fen, kalabus fõ gariya anĩ guyõ fen. Kaisã bagai, kalabus fõ nẽ sukar ganan kã feleid fen, kalabus tamo ganan bun sen irokaka kalaisi keledin. ");
INSERT INTO dad_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kalabus lo fiya tamo irik yel fen, kalabus fõ nẽ sukar kã felediya ilen, agef fen, ĩ kisi fen, kalabus tamo diyalelel ye fen, yogon dimig ul feis, yogo bouwa yukesiyouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Anĩ ere, Pol iweig iron, “Õ ogo bouwã to tũ wo! Amã ganan yeir!” ");
INSERT INTO dad_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kalabus lo fiya tamo yal nigin iweig fen, namen gudu ref ile, Pol Sailas ado yedin kubũ ye, tererẽ yen. ");
INSERT INTO dad_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Agef fen, idi gurif irou, mayarẽ isi fen, to fiyẽdin, “Tamo bibiyeĩ, aya naig afe fen, isennẽya alouf?” ");
INSERT INTO dad_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Idi diron, “Odug Jesus nigin momoi wouf are, õ isennõf, õ ogon ibor tar geid.” ");
INSERT INTO dad_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Age de fen, idi Odug nẽ od, ĩ ado ganan yogon fõ bun dibodon anidi geid, wogõ difiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sain anĩ bun bagai bõ, kalabus lo fiya tamo, Pol Sailas ado gurif iroule, bouweid gali gedin anĩ kulo fedin. Age fel fen, kaisã bagai ĩ yogon ibor tar ganan geid, naan digunẽdin. ");
INSERT INTO dad_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kalabus lo fiya tamo, idi yogon fõ aaben gurif iroule, saaf ifenẽdin. Ĩ wau kulĩya barikan, ere nigin, ĩ Negur nigin momoi yen, yogon ibor tar ganan geid. ");
INSERT INTO dad_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","We fele di, Rom es fiya tamo, dogo neid kabĩ tamo anidi bun, kalabus lo fiya tamo gein od sur difen, “Tamo anidi walisneĩd.” ");
INSERT INTO dad_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Age difiyẽ di, kalabus lo fiya tamo Pol irokenen, “Rom es fiya tamo, õ Sailas ado alisneĩf nigin dirokanal. Gama ã wadã ulagauf. Wauĩ inosiya ado ulagauf.” ");
INSERT INTO dad_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Anĩ ere, Pol kabĩ tamo irokenẽdin, “Amã Rom tamo ba, anĩ ere, idi to es difama ken, amã mal atun wagagã difaman. Age dife fen, amã kalabus bun dinenaman. Anĩ gama idi iminẽyan dirumã fenẽ de? Sã! Idi dogo disi, dalisnama ken, dinenamãf.” ");
INSERT INTO dad_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kabĩ tamo, od enei Rom es fiya tamo dirokenẽdin. Pol Sailas ado idi Rom tamo yeya anĩ karĩ de fen, idi kumĩ den. ");
INSERT INTO dad_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Idi Pol Sailas ado gedin bobo difiyẽdiyouf nigin disi fen, kalabus bun tamal dalis dinenẽdin. Age dife fen, Rom es fiya tamo idi, Pol Sailas ado taun anĩ ditor dilauf nigin dirokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol Sailas ado, kalabus bun tamal ulolõ deis fen, Lidia nẽ fõ bun dilen, idi an momoiya tamo kayau fotou difeid, waud dales le fen, ditorneĩd dilen. ");
INSERT INTO dad_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol Sailas ado, Amfipolis ado Apolonia taun atu diyok dile fen, Tesalonika taun wõ den, an Juda neid uub fõ ibodon. ");
INSERT INTO dad_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol ĩ gai age fedig gen, Juda neid uub fõ bun ilen. Sabat naa towo bun, ĩ Negur nẽ Itotoya bun ibodok anĩ, tamo kayau geid katõ de, ifelneĩd fen, ");
INSERT INTO dad_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kristus ĩ darau yale fen, laa bun tamal mata kel fã youf bagai nigin, el fe faded fiyẽdin. Pol iron, “Jesus enei aya ã arokeneik are, ĩ anĩ Kristus.” ");
INSERT INTO dad_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Juda tamo kayau tunĩ karĩ de, momoi de fen, Pol Sailas ado dõ difedin, Grik tamo kayau museig Negur nigin anini dedig ado, kayau yeneid adodo museig age difen. ");
INSERT INTO dad_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Anĩ ere, Juda tamo, Pol Sailas ado kiyeĩ difeneĩd fen, maket modoũ bun tamo sesen tunĩ kuru difeid waud dalese di, tamo kayau guru difalasi fen, taun anĩ bun kakaĩ den. Idi Pol Sailas ado, tamo kayau bun diroulediyouf nigin, Jeson nẽ fõ bun dile dimirnẽdin. ");
INSERT INTO dad_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Anĩ ere, idi Pol Sailas ado to fotou difeid fen, Jeson momoiya tamo tunĩ geid didũ difeid, taun nẽ uyu iroudiya gedin dirouleid fen, diweig diron, “Tamo eneidi teneub ganan bun morõ difenẽdin anĩ gama yeir disin. ");
INSERT INTO dad_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Age dife di, Jeson idi aan fiyeĩd fen, yogon fõ aaben gurif iroulen. Idi ganan Sisa nẽ lo difodul ken, king taka yana Jesus dedig ibodok, age de wogõ dedig.” ");
INSERT INTO dad_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tamo kayau ado, taun nẽ uyu iroudiya geid, od enei karĩ de fen, ninibur den. ");
INSERT INTO dad_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Age dife fen, taun nẽ uyu iroudiya, Jeson ado tamo tunĩ geid kot na dalouf nigin dirokenẽdi di, na dalen, age difele di, ditornẽdi di, dilen. ");
INSERT INTO dad_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bo kele di, kaisã bagai momoiya tamo kayau, Pol Sailas ado Berea taun sur difedin. Idi an wõ de fen, Juda neid uub fõ bun dilen. ");
INSERT INTO dad_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","An Berea tamo kayau idi, Tesalonika tamo kayau gen sã, idi wedereid dino fen, od karĩ dedig. Idi waud adod fen, od karĩ den, age de fen, idi Pol wogõ yen anĩ, momoi be dilouf nigin, naa ganan Negur nẽ Itotoya felei difedig. ");
INSERT INTO dad_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Juda tamo kayau musei momoi den, age fiya bagai, Grik kayau yeneid adodo musei ado Grik tamo museig momoi den. ");
INSERT INTO dad_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tesalonika taun an Juda tamo idi, Pol Negur nẽ od oun Berea tauneg irok ya karĩ de fen, idig an dile, tamo kayau nameid dalese di, seye den. ");
INSERT INTO dad_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Age dife di, momoiya tamo kayau, kaisã bagai Pol maaĩ ubun sur difiyen, anĩ ere, Sailas Timoti ado idi an Berea taun dibodon. ");
INSERT INTO dad_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tamo tunĩ Pol dinenekel fen, weim Atens taun dilen, Pol ĩ, Sailas Timoti ado kaisã bagai ĩ gein disiyouf nigin, irokenẽdi di, idi keku de dilen. ");
INSERT INTO dad_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol, oun Atens Sailas Timoti ado tari fedin, agef fen, ĩ idegẽya waitou taun anĩ bun isokosen anĩ ile fen, wau fatuk moron. ");
INSERT INTO dad_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Anĩ nigin, Pol ĩ, Juda tamo kayau ado, Grik tamo kayau Negur nigin anini dedig geid, Juda neid uub fõ bun wageid yalouf nigin od solo difedin, ĩ naa ganan maket modoũ bun, tamo kayau idi dilef disif difedig geideg, wageid yalouf nigin od solo difedin. ");
INSERT INTO dad_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikurian ifelnẽdiya tamo tunĩ ado, Stoik ifelnẽdiya tamo tunĩg, Pol geid fefe den. Idi tunĩ to difen, “Golẽ tamal enei, ere od wogõ you fenẽ?” Tunĩ diron, “Ĩ yaũ waitou nigin wogõ yef be.” Idi age de diron, ere nigin, Pol ĩ Jesus nigin ado, laa bun tamal mata kel fãya nigin, biya od wogõ yen. ");
INSERT INTO dad_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Age fe di, idi Pol dale, taun uyu irouya neid guru fiya, yana Areopagus dedig, an dirou dile fen, diron, “Keleĩ mata enei urokanamak anĩ, amã tau keleĩ youf? ");
INSERT INTO dad_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Õ keleĩ mata bagai wederaman urou usif, ereb gariya nigin irok anĩ, amã keleĩ you fenẽ.” ");
INSERT INTO dad_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atens tamo kayau ganan ado yaũ tamo kayau an difaredig idi, sain ganan kisi mata mata nigin karĩ yei dedig, wogoĩ dedig, idi kabĩ taka to daledig.) ");
INSERT INTO dad_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Age de di, Pol Areopagus guru fiya atun ifar fen, iron, “Atens tamo, ereb ereb ganan bun, ã waitou karĩ fiyẽya nigin kisi fatuk unogedig anĩ ailef. ");
INSERT INTO dad_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ere nigin, aya ayo ken, ereb ereb yana walesegedig fele afedin, aya alta takag itotoya enei ado ailen: WAITOU, ADA KELEĨ SÃ ANĨ BUN. Ã keleĩ sã anĩ yana walesegedig nigin, aya yaor afe arokeneik. ");
INSERT INTO dad_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Negur ĩ, teneub ado ereb ereb ganan anĩ namen difaref inodin, ĩ anĩ, saa ado teneub nẽ Odug nigin, ĩ tamo imedim tempel dinodin anĩ bun to ibodõdig. ");
INSERT INTO dad_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ĩ ereb taka to lau fedig, anĩ nigin, tamo imam ereb taka ifenẽya kisi feleya sã, ere nigin, ĩ yogo tamo ganan mata, si neseya ado, ereb ereb ganan ifenẽdidig. ");
INSERT INTO dad_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tamo tekelei bunem, ĩ tamo kayau fire fire ganan inodin, idi teneub adok ino yalouf nigin age fen. Ĩ dogo neid sain ifeneĩd fen, idi ibodõya nẽ modoũ daũ fire fire ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tamo ĩ dimirnẽf nigin, imeid ra de dimirek dile, fotou difiyẽf nigin be, ĩ age fen. Anĩ ere, ĩ ada mugu mugu bun gerõ to ibodok. ");
INSERT INTO dad_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Ĩ bun ada mata tabod ken, telef tasif tafef, tabodok.’ Ãgenei itotoya tamo tunĩg eig de diron, ‘Ada yogon gere tar.’ ");
INSERT INTO dad_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Age fiya bagai, ada Negur nẽ gere tar, anĩ nigin, ada kisi to eig tauf, waitou ĩ, gol nem, silwa nem, meein nem be, tamo nẽ kisim ado imam malakanon inodig age fiya, to tauf. ");
INSERT INTO dad_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tamo kayau Negur nigin to kelein sain, idi to kelei ken, age difedig anĩ, Negur to eweid yon, anĩ ere, gama ĩ, tamo kayau adok teneub ganan bun waud falei youf nigin irokenẽdif. ");
INSERT INTO dad_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ĩ naa inon anĩ bun, ĩ tamo igirnen ĩ bunem, teneub ganan madur fiya bun es fouf. Negur ĩ laa bun tamal mata kel turĩ fe di, fã yen anĩ bunem, enei agef wõ youf anĩ tamo ganan ifelnẽdin.” ");
INSERT INTO dad_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Laa bun tamal mata kel fãya nigin, Pol wogõ yen anĩ karĩ de fen, tunĩ Pol kasã difiyen, anĩ ere, tunĩ diron, “Amã enei nigin baban karĩ mayõ fenẽ.” ");
INSERT INTO dad_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Age de di, Pol guru fiya anĩ itor ilen. ");
INSERT INTO dad_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tamo tunĩ Pol dõ dife fen, momoi den. Idi atun, Dionisius, guru fiya yana Areopagus neid taka, kayau taka yana Damaris ado, tunĩ geid, dibodon. ");
INSERT INTO dad_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Enei bure fel fen, Pol Atens taun itor ken, Korin taun ilen. ");
INSERT INTO dad_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pol ĩ, an Juda tamo taka yana Akwila, Pontus provins tamal, fotou fiyen, Akwila ĩ aiwa Prisila ado Italim disi dibod dirubkelen, ere nigin, Sisa Klodius, Juda tamo kayau ganan Rom taun ditorõf nigin totol od irokenẽdin. Pol idi ilediyouf nigin ilen. ");
INSERT INTO dad_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Agef fen, Pol ĩ an idi geid dibod ken, weim kabĩ dalen, ere nigin, ĩg idi gen salafat inoya tamo. ");
INSERT INTO dad_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabat naa ganan, Pol Juda neid uub fõ bun, Juda tamo kayau ado Grik tamo kayau geid, od kuruwa difedig, are idi kisi falei de momoi douf nigin age fedig. ");
INSERT INTO dad_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailas Timoti ado Masedoniam disi di, Pol ĩ Juda tamo kayau bun, Jesus ĩ anĩ Kristus fiyeĩd fen, wogõ ye kurõ fesin, ĩ yogon sain adok kabĩ anĩ bun inon. ");
INSERT INTO dad_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Anĩ ere, Juda idi Pol kiwai difen ken, kono difiyẽ di, ĩ so fiyeĩd fen, yogon kolos tu fel fen, irokenẽdin, “Ã naudeĩ aug mudureĩ bun ibodõf! Aya to kababal fiyauf. Gama sain enei bunem ilef, aya haiden gedin alauf.” ");
INSERT INTO dad_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pol age ye fen, Juda neid uub fõ itor ken, Negur yana yalesedig tamo Titius Justus nẽ fõ bun ilen, fõ are Juda neid uub fõ anĩ non. ");
INSERT INTO dad_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, Juda neid uub fõ nẽ mudur, ĩ yogon ibor ganan geid, Odug nigin momoi den. Korin tamo kayau museig biya od karĩ de fen, momoi den. Age dife di, naan dalen. ");
INSERT INTO dad_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bõ taka bun, Pol mala seleulã kurãf fen, Odug ĩ wogõ fiyẽ mog, karĩ yen, “To kumĩ wo, õ od wogõya tobol wof ulauf, ait to ufokalauf, ");
INSERT INTO dad_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ere nigin, aya õ ado. Taka nem to irounokon, tadũ yõf, ere nigin, taun enei bun, neu tamo kayau musei dibodok.” ");
INSERT INTO dad_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Anĩ nigin, Pol ĩ yar tekelei ado ogõ sigis an ibod ken, tamo kayau Negur nẽ od ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio ĩ Akaia provins nẽ gawaman mudur ibod mog, Juda tamo kayau idi weim kori de, Pol kiwai difen ken, ĩ kot bun diroulen. ");
INSERT INTO dad_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Idi diron, “Tamo enei neda lo wal fe fen, tamo kayau waud yale di, Negur yana, tobonunã fire bun dalesauf nigin age fef.” ");
INSERT INTO dad_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol od wogõ you fenẽ mog, Galio ĩ Juda tamo kayau irokenẽdin, “Juda tamo kayau ã, mosor be, tobonunã sane nigin urokanagauf are, aya ã karĩ yeĩya nigin kisi feleya. ");
INSERT INTO dad_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Anĩ ere, morõ enei, od nigin, yeneid nigin ado, ãgenei lo nigin ouf are, ã aug madur gouf. Aya age fediya to es afouf.” ");
INSERT INTO dad_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Age ye fen, ĩ idi kot bun irudidin. ");
INSERT INTO dad_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Age fe di, idi Juda neid uub fõ mudur Sostenes dale fen, kot fofomala bun dun. Anĩ ere, Galio to eweid yon. ");
INSERT INTO dad_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol ĩ oun Korin taun naa musei ibodon. Agef fen, ĩ momoiya tamo kayau itorneĩd fen, Prisila Akwila ado weim waag dale, Siria distrik dilen. Ĩ fau waag sõya sã mog, Senkria taun an yogon fatiya gudũ difelen, ere nigin, ĩ Negur mala bun wau kuturol fen, iron, age afouf yen. ");
INSERT INTO dad_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Idi Efesus taun wowã den, an Pol, Prisila Akwila ado itornẽdin. Pol ĩ yogo Juda neid uub fõ bun ile fen, Juda tamo kayau geid od kuruwa difen. ");
INSERT INTO dad_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ĩ idi geid sain naal meluk dibodõf nigin dirokenẽ di, itoron. ");
INSERT INTO dad_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Anĩ ere, ĩ ilau fenẽ mã, idi irokenẽdin, “Negur orouf are, aya kelauf.” Age ye fen, ĩ waag bun Efesus taun itor ilen. ");
INSERT INTO dad_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pol ĩ Sisaria taun kutũ yeis fen, Jerusalem isel, sios aan fiyẽdin. Agef fen, ĩ Antiok taun isilen. ");
INSERT INTO dad_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol sain naal an Antiok taun ibodkele fen, anenem fã ye, Galesia provins ado Frigia distrik ganan bun iyo ken, dõ fiya tamo kayau ganan megeir fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Sain anĩ bun, Juda tamo taka yana Apolos, Aleksandria fõ morou, Efesus isin. Ĩ keleĩ biya ado tamo, Negur nẽ Itotoya bun ibodok anĩ nigin keleĩ biya bagai ado. ");
INSERT INTO dad_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ĩ Odug nẽ naab anĩ difelnen, age dife di, ĩ totol ado wogõ ye fen, Jesus nigin tutuk bagai ifelnẽdidig, anĩ ere, ĩ Jon nẽ naan igũya anĩ dogol kelein. ");
INSERT INTO dad_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ĩ Juda neid uub fõ bun, kumĩ sã od wogõ yen. Prisila Akwila ado, ĩ wogõ yen anĩ karĩ de fen, idi ĩ dogo neid fõ bun dale diroule, Negur nẽ naab tutuk faded difiyen. ");
INSERT INTO dad_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Age difel fen, Apolos Akaia provins bun ilauf nigin age fe di, momoiya tamo kayau idi ĩ wau dales fen, Akaia teneub an dõ fiya tamo kayau ĩ aan difiyẽf nigin, pas ditotkenẽdin. Apolos an wõ ye fen, Negur nẽ wau ifenẽya bunem momoi den idi, fatuk bagai isennẽdin. ");
INSERT INTO dad_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ere nigin, ĩ Juda tamo kayau geid mal atun fefe de fen, od megeir ado nem lai feid fen, Negur nẽ Itotoya bun Jesus ĩ anĩ Kristus ya anĩ, agef ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos ĩ fau Korin taun ibod mog, Pol ĩ teneub atu iyok ile, Efesus taun wõ yen. An ĩ, dõ fiya tamo kayau tunĩ fotou fiyeĩd fen, ");
INSERT INTO dad_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","to fiyẽdin, “Ã momoi ge fen, Awa Uur Fateul walegen de?” Idi ĩ dirokenen, “Sã, amã Awa Uur Fateul ibodok ya anĩg to karĩ maun.” ");
INSERT INTO dad_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Age de di, Pol idi to fedin, “Age fiyauf are, ere naan anĩ ã walegen?” Idi ĩ dirokenen, “Jon nẽ naan igũya anĩ.” ");
INSERT INTO dad_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol iron, “Jon nẽ naan igũya are wau faleiya nẽ naan igũya. Jon ĩ yogo, dumen tamo taka isif ĩ nigin momoi douf nigin, tamo kayau irokenẽdin, tamo are Jesus.” ");
INSERT INTO dad_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Idi od enei karĩ de fen, Odug Jesus yana bunem naan dalen. ");
INSERT INTO dad_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol ima tetedin ino di, Awa Uur Fateul idi bun isin. Age fe di, idi od fire fire nem wogõ de fen, profet odeg wogõ den. ");
INSERT INTO dad_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Idi ganan tamo tuwelf age fiya. ");
INSERT INTO dad_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol Juda neid uub fõ bun ile fen, an ogõ towo bun, kumĩ sã od wogõ yen, ĩ tamo kayau geid od kuruwa de, idi waud falei ye, Negur nẽ tano nigin momoi douf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Anĩ ere, idi tunĩ waud totol le fen, to momoi den. Age dife fen, idi mal atun Odug nẽ naab nigin od sesen diron. Anĩ nigin, Pol idi itorneĩd fen, dõ fiya tamo kayau geif fen, naa ganan Tiranus nẽ ifelnẽya fõ bun od katõ difen. ");
INSERT INTO dad_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Enei age fen are yar uru ilelen, anĩ bunem, Juda tamo kayau ado, Grik tamo kayau ganan Asia provins an dibodon idi, Odug nẽ od karĩ den. ");
INSERT INTO dad_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Negur ĩ Pol bunem memelik fire bagai age fedin, ");
INSERT INTO dad_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","are hankisip ado gabar masakeg, Pol bouwa kobũ dife fen, dagi tamo bun diroule dinodi di, dagi el feledin, are kaa sesen idi ditornẽdin. ");
INSERT INTO dad_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Juda tamo tunĩ, kaa sesen dirudiyouf nigin diyõdig, idi kaa sesenem dirounẽdin anidi bun Odug Jesus yana dale fen, idi eig de dirõdig, “Jesus ĩ nigin Pol wogõ yedig, ĩ yana bunem, aya õ ulõ wesiyouf nigin arokonok.” ");
INSERT INTO dad_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Juda neid pris odug taka, Skeba nẽ gere tar sewen idig age difedig. ");
INSERT INTO dad_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Naa taka bun, kaa sanem idi irokenẽdin, “Aya Jesus keleĩ, aya Pol nigin keleĩ, anĩ ere, ã aiyaim?” ");
INSERT INTO dad_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Age ye fen, tamo kaa sane ado tetedin gurusã ye, ganan lalai feid fen, fatuk bagai idenẽdin. Age fe di, idi fõ anĩ bun tamal, gemũ naud adodo diyalelen. ");
INSERT INTO dad_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Juda tamo kayau ado Grik tamo kayau Efesus taun dibodon idi, enei karĩ de fen, idi ganan fatuk bagai kumĩ de, Odug Jesus yana ilun bagai dalesen. ");
INSERT INTO dad_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tamo kayau momoi den musei disi, sane age difedig anĩ, mal atun yaor dife, kurõ difesin. ");
INSERT INTO dad_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Idi idegẽya bunem kosẽ dedig musei, dogo neid buk kori fiya guri de dirousi, kuru de, mal atun yã diraran. Idi buk kori fiya anĩ nẽ mala diwesen, are fifti tausen silwa moni wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Anĩ bunem, Odug nẽ od bilalaũ fe fen, megeiref ilen. ");
INSERT INTO dad_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Enei ganan agef wõ yele di, Pol Masedonia ado Akaia provins atu iyok ile anenem, Jerusalem ilauf nigin kisi yalen. Ĩ iron, “Aya an wõ au fen, aya Romeg ki afouf.” ");
INSERT INTO dad_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Age ye fen, ĩ yogon isennẽya tamo uru, Timoti Erastus ado Masedonia provins bun sur feid fen, ĩ Efesus an Asia provins bun sain naal ibodon. ");
INSERT INTO dad_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sain anĩ bun, Odug nẽ Naab nigin, kiwai ado monẽya odug wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Silwa nem ereb ereb inoya tamo, yana Demetrius, ĩ silwa nem kayau waitou yana Atemis dedig anĩ nẽ tempel malakanon inodig, anĩ bunem yogon kabĩ tamo moni musei daledig. ");
INSERT INTO dad_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrius ĩ, yogon kabĩ tamo tar ado, yogon kabĩ gen age fiya tutur iweig laisi fen, irokenẽdin, “Tamo ã, ã keleĩ, ada kabĩ enei bun moni biya taledig. ");
INSERT INTO dad_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Anĩ ã gama uleg fen, karĩ gef, tamo Pol enei, ein Efesus ado mogo Asia provins ganan melsã bagai bun, tamo kayau musei waud yale fen, eig ye irok, tamo ima nem waitou inodif are anĩ waitou sã, yef. ");
INSERT INTO dad_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Are karĩya sane yenek, ada neda moni kabĩ yana sane yalouf, takag, karĩya sane yenek are, kayau waitou odug Atemis nẽ tempel are ege bagai kaũ sãf. Age fe di, kayau waitou, Asia provins ganan bun ado teneub adok ganan bun, yana dalesedig, ĩ yana odug iseledig are lai difesilauf.” ");
INSERT INTO dad_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Idi od enei karĩ de fen, fatuk bagai seye ise di, kakaĩ de diweig diron, “Efesus neid Atemis ĩ odug bagai!” ");
INSERT INTO dad_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Age de di, taun anĩ bun ganan kuru dalesen. Tamo kayau idi, Gaius Aristakus ado, are idi Masedonia temeleid Pol geid diyõdig anidi, kaka difeid, guru fiya nẽ fõ odug namen, tamo tekeleim gudu ref ileya gen gududu den. ");
INSERT INTO dad_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol ĩ guru fiya atun ilauf nigin age fen, anĩ ere, dõ fiya tamo kayau Pol katũ difiyen. ");
INSERT INTO dad_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia gawaman nẽ uyu irouya tunĩ, are Pol nẽ mou tar idig, Pol guru fiya nẽ fõ anĩ bun to ilauf nigin digone ken, od sur difenen. ");
INSERT INTO dad_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Guru fiya anĩ bun nene delen. Tunĩ od taka diweig dirõ di, tunĩ od fire taka diweig diron. Musei ganan ereb nigin an guru difen anĩ, idi keleĩ san. ");
INSERT INTO dad_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Juda tamo kayau, Aleksanda, tamo kayau wagedin mal atun sur dife, isel ifare di, tamo kayau tunĩ ĩ dile fen, Aleksanda ĩ anĩ morõ gariya den. Age dife di, Aleksanda ĩ tamo kayau meleid bun yogo bouwa isennẽf nigin, ĩ foro dalauf nigin imam dogol fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Anĩ ere, idi ĩ Juda tamo ya kelei ken, idi ganan aiteid tekelei dino fen, aua uru age fiya eig de diweig diron, “Efesus neid Atemis ĩ odug bagai!” ");
INSERT INTO dad_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Age de di, taun uyu irouya nẽ kabĩ tamo ĩ, tamo kayau foro weleg fiyẽdi di, foro delen, age dife di, iron, “Efesus tamo ã, teneub ganan bun tamo kayau ganan, Efesus taun anĩ, Atemis odug nẽ tempel ado yogon malakanon saa ilunem isin anĩ nẽ kulatun fiya taun anĩ, idi to keleĩ de? ");
INSERT INTO dad_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Taka nem enei wa fiya kisi feleya sã, anĩ nigin, ã foro weleg fen, age fiya nigin to buroro gei. ");
INSERT INTO dad_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tamo eneidi ereb taka tempel buneg to bẽ dalen, idi neda kayau waitoug to kono difiyen, anĩ ere, ã idi ein guri wedig urousigel. ");
INSERT INTO dad_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Age fiyauf are, Demetrius yogon kabĩ tura tar geid, tamo taka nigin nauseirya adouf are, kot ibodok, gawaman nẽ mudur adodo difaref. Idi an nauseirya anĩ diroulauf. ");
INSERT INTO dad_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ã nauseir anĩ teten ereb taka manouf gouf are, tamo kayau neid kot guru fiya bun madur gouf. ");
INSERT INTO dad_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Gama wõ yel enei nigin, karĩya sane yenek, kuru talesel enei nigin are ada kot bun dinenadauf. Age difouf are, ada guru fiya sane enei nigin faded fiya kisi feleya sã, ere nigin, are gariya sã.” ");
INSERT INTO dad_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Agef irokel fen, ĩ guru fiya anĩ irudin. ");
INSERT INTO dad_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kuru anĩ bure fele di, Pol ĩ od ino di, dõ fiya tamo kayau disin, age dife di, idi waud yales le fen, dabuo fiyeĩd lel, Masedonia provins ilen. ");
INSERT INTO dad_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pol ĩ Masedonia provins atu iyok ile, wau yaleseya od musei tamo kayau irokenẽdif ile, Grik kantri bun ulõ yeis fen, ");
INSERT INTO dad_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ĩ an ogõ towo ibodon. Ĩ waag bun Siria distrik bun ilauf nigin agef mog, Juda tamo idi, ĩ dukesiyouf nigin lalĩ difiyek anĩ karĩ yen. Anĩ nigin, ĩ Masedonia provins atu kel ilauf nigin kisi yalen. ");
INSERT INTO dad_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pirus naal Sopata Berea taun tamal, Aristakus, Sekundus Tesalonika taun tamal, Gaius Derbe taun tamal, Timoti, Tikikus Trofimus ado Asia provins temeleid anidim, Pol geid diyon. ");
INSERT INTO dad_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tamo eneidi idi ket Troas taun dile, an tari difaman. ");
INSERT INTO dad_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Anĩ ere, Bret Yis Sã nẽ Sifa bure fele di, amã waag male, Filipai taun mator ken, naa faif ilele di, Troas taun wõ mau fen, fata mafiyẽdin, an naa sewen mabodon. ");
INSERT INTO dad_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Uub nẽ naa matu bun, amã weim bret mumã mafouf nigin guru mafalaisin. Pol tamo kayau od wogõ fiyẽdif ile bõ atunen, ere nigin, ĩ, we fele di, itornẽdiyouf nigin kisi fen. ");
INSERT INTO dad_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Guru mafen nẽ aab ilun an, lam musei futu redin. ");
INSERT INTO dad_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Tamo gaũ yana Yutikus, yau yaleya bobog ilun sõ yesel ibod ken, mulã kusu yalen. Pol od wogõ yef ile mog, ĩ mulã kusu yalef ile yen kele fen, fõ ilunenem tenebur kubũ ye isilen. Age fe di, idi ĩ laa dalesnen. ");
INSERT INTO dad_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Anĩ ere, Pol isil, tamo anĩ teten kubũ ye, kakarai fiye ken, iron, “To terẽg, ĩ mata!” ");
INSERT INTO dad_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Age ye fen, ĩ baban fõ ilun isel, bret mumãf fen, yon. Ĩ wogõ yef ile we fele di, ĩ itorneĩd ilen. ");
INSERT INTO dad_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tamo kayau, tamo gaũ anĩ mata dale dirou, fõ bun dile fen, waud el bagai fen. ");
INSERT INTO dad_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Amã ket waag bun mele, sõ mau fen, Asos taun melen, an Pol waag bun malouf nigin kisi mafen. Pol ĩ, amã age mafouf nigin tetun irokanaman, ere nigin, ĩ ye naab iyok ile, an ilauf yen. ");
INSERT INTO dad_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ĩ oun Asos fotou famã di, amã ĩ waag bun male fen, Mitilin taun melen. ");
INSERT INTO dad_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Anenem waag bun mele, we fele di, Kios nuyo non wõ maun. Naa anĩ ile di, Samos taun mele wõ maun, naa anĩ ile di, Miletus taun mele wõ maun. ");
INSERT INTO dad_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol ĩ, Asia provins bun an sain taka to ilalauf nigin, waag bun Efesus wal fouf nigin kisi yalen, ere nigin, kisi falauf are, ĩ Jerusalem Pentikos naa bun wõ youf nigin sibu yen. ");
INSERT INTO dad_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus taun an, Pol ĩ Efesus sios neid uyu irouya fata difiyẽf nigin od sur fen. ");
INSERT INTO dad_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Idi disi wõ de di, ĩ irokenẽdin, “Aya Asia provins bun, uruwa bagai asi wõ au fen, aya ã geid tabod ken, sain ganan naig be afe abodon are ã keleĩ. ");
INSERT INTO dad_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Juda tamo idi aya kiwai difana fen, kisi sane dinon anim fatuk bagai kisi fiyan, anĩ ere, aya wau aukesil, maru ado fen, Odug aruna alen. ");
INSERT INTO dad_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ã keleĩ, aya ã isenneĩf nigin ereb taka wogõya bun to afon, are aya mal atun ado fõ fõ bun afelnein. ");
INSERT INTO dad_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Aya Juda tamo kayau ado Grik tamo kayau idi waud falei ye, Negur bun dino fen, neda Odug Jesus nigin momoi douf nigin totol bagai arokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Gama aya Awa Uurem toli fiyaf anĩ bunem, Jerusalem elef, an aya bun ereb wõ youf are aya keleĩ sã. ");
INSERT INTO dad_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Taun ganan bun Awa Uur Fateul, kalabus ado morõ tari difiyaf anĩ nigin wederou irouf, anĩ dogol aya keleĩ. ");
INSERT INTO dad_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Anĩ ere, aya neu naab adikalauf nigin ado, kabĩ Odug Jesus ifanan, are Negur nẽ wau ifenẽya nẽ biya od wogõya kabĩ anĩ bure afalauf nigin dogol, kisi afef. Anĩ kisi afalauf are, aya neu mata are ege au fen, neu mata nigin to kisi afef. ");
INSERT INTO dad_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Aya ã atun ayo ken, Negur nẽ tano nigin wogõ ayein, are gama aya keleĩ, ã atun takam baban to ileyauf. ");
INSERT INTO dad_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Anĩ nigin, naa enei bun, aya tutuk bagai yaor afe arokeneik, tamo ganan neid naudeid nigin, aya neu mosor sã. ");
INSERT INTO dad_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ere nigin, aya Negur nẽ oroya ganan yaor afe arokeneĩf nigin, taka to afokelen. ");
INSERT INTO dad_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ã aug nigin ado, sipsip ganan Awa Uur Fateulem lo wedigouf nigin imeĩ bun inon anĩ nigin, meleĩ adouf. Negur nẽ sios, ĩ yogon naud bunem na yalen anĩ nẽ sipsip lo fiya tamo ubodõgouf. ");
INSERT INTO dad_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Aya keleĩ, aya atorneĩ mog, gaũ kuĩ sane ã atun disi, sipsip daũ difeidlauf. ");
INSERT INTO dad_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ã tutur buneg tamo tunĩ fã de, dõ fiya tamo tunĩ momoi bun tamal didegneĩd fen, idi dõ difediyouf nigin weleid dino diroulauf. ");
INSERT INTO dad_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Anĩ nigin, ã lo welegei! Yar towo bun, bõ ado gaa ado, maru ado ã mugu mugu ganan wedereĩ aroun anĩ karĩ walagauf. ");
INSERT INTO dad_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Gama aya ã, Negur ado yogon wau ifenẽya nẽ od bun, aneneik, od anim ã totolouf nigin megeir ifenei ken, yogon momoiya tamo tar ganan atun, in akor mata ibodkeleya anĩ ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Aya takan nẽ silwa be, gol be, kolos yaleya nigin to wau yenen. ");
INSERT INTO dad_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ã aug keleĩ, aya imau eneim kabĩ ale di, aya neu kabĩ turau tar geid, ereb lau mafen anĩ ifanaman. ");
INSERT INTO dad_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ereb ereb ganan aya age afen anĩ bunem, aya ã afelnein, are ada kabĩ totol age taf tale fen, anĩ bun tamalem maleg tasennẽdiyouf. Odug Jesus yogo eig ye iron anĩ karĩ taulauf, ‘Ifenẽya are el fiya barikã, yaleya nẽ wal fiya.’” ");
INSERT INTO dad_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol ĩ od enei wogõ yel fen, ĩ ibor bobou fe, idi ganan geid kosẽ den. ");
INSERT INTO dad_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Idi ĩ kakarai difiyẽ, umã difiye ken, ganan inã dalen. ");
INSERT INTO dad_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Idi ĩ nawa baban to dilouf fiyẽdin od anim waud gudũ fen. Age dife fen, idi weim waag bun dinenen. ");
INSERT INTO dad_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Amã dabuo mafiyeĩd matorneĩd fen, waag sõ mau, Kos nuyo tokõ mafelen. Naa anĩ ile di, amã Rodes nuyo mele fen, anenem Patara taun melen. ");
INSERT INTO dad_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Amã waag taka Fonisia distrik bun ile mog, fotou mafe fen, waag anĩ sõ mau melen. ");
INSERT INTO dad_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Amã Saipras nuyo mail fen, wal mafe, anĩ ki melem Siria provins melen. Amã Taia taun kututũ maun, ere nigin, an waag udũ gei falaisiyouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Amã an dõ fiya tamo kayau fotou mafeid fen, weim naa sewen mabodon. Idi Awa Uurem Pol Jerusalem to ilauf nigin totol bagai dirokenen. ");
INSERT INTO dad_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Anĩ ere, nemã sain bure fele di, amã matorneĩd fen, delẽ mayon. Dõ fiya tamo ganan dogo neid kayau kesu tar geid, taun tamal dinenamã, mele, maaĩ ubun ulõ maus fen, an amã iboramã bobou mafe fen, kosẽ maun. ");
INSERT INTO dad_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Amã abob dabuo mafiye ken, amã waag sõ mau di, idi fonõ keku de dilen. ");
INSERT INTO dad_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Amã Taia taun anenem tokõ mafel, Ptolemais taun kututũ maun, an amã momoiya tamo kayau aan mafiyeĩd fen, idi geid naa tekelei mabodon. ");
INSERT INTO dad_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Naa anĩ ile di, amã matorneĩd mele, Sisaria taun wõ mau fen, an biya od wogõya tamo Filip nẽ fõ bun mabodon, ĩ kulu oun Jerusalem momoiya tamo sewen digirnẽdin anidi taka. ");
INSERT INTO dad_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filip ĩ, ne barai tar aiwa adodo tamo sãsã, idi profet od wogõ dedig. ");
INSERT INTO dad_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","An naa tunĩ mabodon, age mã mog, profet taka yana Agabus Judia distrik bun tamal isin. ");
INSERT INTO dad_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ĩ amã garan isi, Pol nẽ lũ yale fen, yogo ye ima ado ifofa ken, iron, “Awa Uur Fateul eig ye irok, ‘Jerusalem oun Juda tamo idi lũ enei nẽ marau eig de difo ken, haiden imeid bun dinenẽf.’” ");
INSERT INTO dad_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Amã od enei karĩ mau fen, amã an tamo kayau geid Pol Jerusalem to ilauf nigin magonen. ");
INSERT INTO dad_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Age mafe di, Pol iron, “Ã ere nigin inã walege di, aya wau gudũ fef? Aya Odug Jesus yana nigin, Jerusalem oun difõyauf nigin ado laa fiyauf nigineg, dodok afel.” ");
INSERT INTO dad_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Amã ĩ wala inoya kisi feleya sa ken, folõ mafiye kele fen, moron, “Odug nẽ oroya anĩ kisi falauf.” ");
INSERT INTO dad_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Age mafel fen, amã dodok mafel, Jerusalem meselen. ");
INSERT INTO dad_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Dõ fiya tamo tunĩ Sisaria taun temeleid dinenama ken, Nason nẽ fõ bun mabodõf nẽ an dirouleman. Nason ĩ, dõ fiya tamo uruwa bun temeleid anidi taka, Saipras nuyo tamal. ");
INSERT INTO dad_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Amã Jerusalem wõ mau di, momoiya tamo idi waud sere fiya ado aan difaman. ");
INSERT INTO dad_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Naa anĩ ile di, amã Pol geid Jems mailauf nigin melen, sios uyu irouya ganan an difaren. ");
INSERT INTO dad_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol idi aan fiyeĩd fen, yogon kabĩ bunem Negur haiden atun ereb age fen anĩ, teke tekelei dir fenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Idi od enei karĩ de fen, Negur yana dalesen. Age dife fen, idi Pol dirokenen, “Turamã, õ ulef, ganĩ tausen Juda idi momoi den, anĩ ere, idi ganan Moses nẽ Lo dõ fiya nigin waud totol bagai yenek. ");
INSERT INTO dad_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Õ, Juda idi haiden neid teneub bun difaref ganan, Moses nẽ Lo ditor ken, dogo neid kesu tar mulũ bun to dinenẽdiyouf, dogo neid tobonunã to dõ difouf nigin ufelnẽdin ya anĩ, idi mogo karĩ den. ");
INSERT INTO dad_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Idi õ usil ya anĩ fau karĩ douf. Age difouf are, ada ere naig tafouf? ");
INSERT INTO dad_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Anĩ nigin, amã marokonok anĩ, ago dõ wo. Tamo aiwa adodo Negur mala bun age mafouf bagai den, idi yeir amã geid. ");
INSERT INTO dad_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tamo eneidi geid uleg fen, nonorou lilik fiya nẽ tobonunã bun ulagauf. Agog fen, na walekenẽdiyouf, ago di, idi fatiyeid korerẽ difalauf. Ago ge di, õ nigin od enei are momoi sã, õ ogo Moses nẽ Lo dõ wedig anĩ, tamo kayau ganan keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Haiden tamo kayau idi momoi den anidi bun, amã kisi mafon anĩ matotkenẽdin, are idi saaf idegẽya waitou bun sesewi difen anĩ to dãf, yaro naud adodo to dãf, yaro uleid kakã difeid fen, didenkesif anĩ to dãf ado, noli tobonunã bun to dilauf.” ");
INSERT INTO dad_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Naa anĩ ile di, Pol tamo anidi geif fen, ĩ yogo weim nonorou lilik difen. Age difel fen, ĩ tempel bun ile, ere sain nonorou lilik fiya naa bure fele di, idi mugu mugu sesewi difouf anĩ, pris keleĩ youf nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Naa sewen anĩ bure falau fenẽ mog, Juda tamo tunĩ Asia provins temeleid idi, tempel bun Pol dilen. Idi tamo ganan waud dalese di, seye de fen, Pol dale, ");
INSERT INTO dad_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","diweig diron, “Israel tamo, usennamãg! Tamo enei anĩ, neda tamo kayau, neda lo ado, modoũ enei nigin, od sane teneub ganan bun, tamo ganan ifelnẽdidig. Takag, ĩ Grik tamo tempel modoũ bun gurif isi di, fateul modoũ enei amuyẽ ifenen.” ");
INSERT INTO dad_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Idi uruwa bun, Trofimus Efesus taun tamal, Pol ado an taun diledin, anĩ nigin, idi kisi difen, Trofimus Pol im tempel modoũ namen iroulen den.) ");
INSERT INTO dad_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Taun tamo kayau ganan fafã de fen, naab uyu fire fire bunem gududu de disin. Idi Pol dale, tempel bun tamal dĩ de diror diroule di, kaisã bagai sukar kotũ difeledin. ");
INSERT INTO dad_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Idi Pol dukesiyou fenẽ age de mog, od isel, Rom kusĩ tamo neid odug, Jerusalem taun tamo kayau ganan kuru dalesef ya anĩ karĩ yen. ");
INSERT INTO dad_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kaisã bagai, kusĩ tamo neid odug ĩ, kusĩ tamo neid orowa tunĩ ado kusĩ tamo geif fen, tamo kayau musei gedin gududu de disilen. Tamo kusĩ dalesen idi, kusĩ tamo neid odug ado yogon kusĩ tamo geid dileid fen, Pol dun anĩ folõ difelen. ");
INSERT INTO dad_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kusĩ tamo neid odug isi, Pol dale, sen uru nem difõf nigin iron. Age ye fen, Pol ĩ ai anĩ, ereb ĩ age fen anĩ ado nigineg, Juda tamo to fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tamo kayau musei atun, tunĩ od gariya fire diweig diron, tunim od gariya fire taka diweig diron. Kusĩ tamo neid odug ĩ, idi kuru dalesen nigin momoi od yaleya kisi feleya san anĩ nigin, ĩ Pol kusĩ tamo neid fõ bun dirou dilauf nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pol lata garan wõ ye mog, tamo musei idi didid aus fele di, kusĩ tamom Pol faali difiyen. ");
INSERT INTO dad_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tamo musei idi dõ difeid fen, diweig diron, “Ukesig!” ");
INSERT INTO dad_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kusĩ tamo idi, Pol kusĩ tamo neid fõ aaben diroulau fenẽ mog, ĩ kusĩ tamo neid odug to fiyen, “Aya od taka tau arokonõf?” Ĩ aba solof iron, “Õ Grik od wogõ wodig de? ");
INSERT INTO dad_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Õ Isip tamal sã de? Kulu gawaman kiwai wene ken, gerere tuan fo tausen kiwai tamo uyu urou ulen anĩ.” ");
INSERT INTO dad_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol iron, “Aya Juda tamo, Silisia provins oun Tasus taun tamal, taun yana ado nẽ fõ morou. Utorna len, tamo kayau od arokenẽdiyouf.” ");
INSERT INTO dad_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kusĩ tamo neid odug yo fiyẽ di, Pol lata bun ifar fen, tamo kayau imam fiyẽdin. Idi ganan foro dele di, Pol Hibru od nem irokenẽdin, ");
INSERT INTO dad_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Turau tar ado dei geg, gama aya yug nigin isennẽya od enei karĩ wog.” ");
INSERT INTO dad_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pol Hibru od nem irokenẽdi di, karĩ de fen, idi fatuk foro delen. Age dife di, Pol iron, ");
INSERT INTO dad_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Aya Juda tamo, Silisia provins oun Tasus taun an wõ au fen, taun enei bun biyaun. Aya Gamaliel bun tubuda tar neid lo nigin tai fiya fatuk alen. Age afe fen, ã ganan gama ago gef gen, ayag Negur nigin kisi totol alen. ");
INSERT INTO dad_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Aya Naab enei dõ difedig tamo kayau, darau afeneĩd fen, adenkesin, tamo ado kayau gei afeid fen, kalabus araran. ");
INSERT INTO dad_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pris neid mudur ado, kaunsel neid uyu irouya ganan geideg, aya age afen anĩ nigin wogõ douf. Aya tureid tar Juda idi oun Damaskus taun difaref anidi bun paseg idi bun ale fen, tamo kayau eneidi darau difenẽdiyouf nigin afofa ken, Jerusalem guri afeid alauf nigin an elen. ");
INSERT INTO dad_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Gaa atun age fiya, aya ele, Damaskus wõ au fenẽ mog, kaisã bagai, lalan fula fiya taka saa ilun tamal aya bun fula felen. ");
INSERT INTO dad_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Aya tenebur kubũ au asil fen, ait taka wogõ fiya mog, karĩ aun, ‘Sol, Sol, ere nigin õ aya daig wiyaf?’ ");
INSERT INTO dad_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Aya to afen, ‘Odug, õ aim?’ “Ĩ solof irokanan, ‘Aya Jesus Nasaret tamal, õ daig wiyaf anim.’ ");
INSERT INTO dad_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Neu kabĩ turau tar fula fiya anĩ dilen, anĩ ere, idi ait wogõ fiyan anĩ to karĩ den. ");
INSERT INTO dad_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Aya to afen, ‘Ere naig afouf?’ “Odug iron, ‘Fã wale fen, Damaskus taun ule, an õ ereb agouf nigin Negur igirkonon anĩ ganan irokonõf.’ ");
INSERT INTO dad_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Neu kabĩ turau tar, imau gim de, Damaskus dirouleyan, ere nigin, lalan fula fiya anim malau gugum kelen. ");
INSERT INTO dad_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Tamo taka yana Ananias ileyauf nigin isin. Ĩ lo el fe dõ fedig tamo, Juda idi an difaref ganan, ĩ nigin biya difiyẽdig. ");
INSERT INTO dad_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ĩ aya sirun ifar fen, iron, ‘Turau, Sol, õ malã kelẽ yalauf!’ Sain anĩ bun bagai, aya ĩ ileya kisi feleyan. ");
INSERT INTO dad_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Age afe di, ĩ iron, ‘Tubuda tar neid Negur, õ yogon oroya keleĩ youf nigin, Madur Bagai Tamo anĩ ulouf nigin ado, ĩ awa bun od karĩ wouf nigin igirnon. ");
INSERT INTO dad_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Õ ereb ulen ado karĩ won anĩ, tamo ganan bun ĩ nigin wogõ wouf. ");
INSERT INTO dad_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Anĩ gama õ ere tari wof? Fã wale, naan wale, ĩ yana uweigne ken, ogon mosor kulo wol.’ ");
INSERT INTO dad_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Aya Jerusalem kelau ele fen, tempel bun kosẽ au mog, malau seleulã kurãf fen, ");
INSERT INTO dad_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Odug wogõ ye mog, ailen. Ĩ aya irokanan, ‘Gama nem, kaisã bagai Jerusalem utor ule, ere nigin, idi aya nigin ogon od to karĩ douf.’ ");
INSERT INTO dad_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Age ye di, aya oron, ‘Odug, idi dogo keleĩ, are aya Juda neid uub fõ fõ bun ele fen, õ nigin momoi den anidi kalabus bun aneneĩd fen, adenẽdidig. ");
INSERT INTO dad_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Takag, ogon od wogõ yedig tamo Stiwen naud fi felen sain bun, ayag an afaren, ĩ dukesiyouf nigin wau iro ken, tamo idi ĩ dukesin neid kolos tari afen.’ ");
INSERT INTO dad_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Age au di, Odug irokanan, ‘Ule, aya haiden gedin gerõ sur ayõf.’” ");
INSERT INTO dad_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tamo kayau musei Pol karĩ difiyek dile, ĩ od enei irõ di, idi kakaĩ de fen, diweig diron, “Ukesig, tenebur tamal uraileg! Ĩ mata ibodõya to biya!” ");
INSERT INTO dad_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Idi diweig diro ken, dogo neid kolos dinukakã dirara ken, aas ilun diraran. ");
INSERT INTO dad_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Age dife di, kusĩ tamo neid odug, Pol kusĩ tamo neid fõ bun dirou dilauf nigin irokenẽdin. Tamo idi Pol eig de diweig dirokenen anĩ nẽ gariya keleĩ youf nigin, Pol wagĩ difiye ken, to difiyẽf nigin, ĩ irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Idi ĩ wagĩ difiyẽf nigin yaĩ difiyẽ mog, Pol kusĩ tamo neid orowa an ifaren anĩ irokenen, “Ã, Rom tamo, mosor ado be ya kelei sa ken, wagĩ fiya are lo dõ fiya de?” ");
INSERT INTO dad_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kusĩ tamo neid orowa od enei karĩ ye fen, ĩ kusĩ tamo neid odug garan ile fen, ĩ irokenen, “Õ ere naig wou fenẽ? Tamo enei ĩ Rom tamo.” ");
INSERT INTO dad_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kusĩ tamo neid odug Pol garan ile fen, to fiyen, “Õ urokana, õ Rom tamo de?” Pol ĩ iron, “Are momoi.” ");
INSERT INTO dad_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Age ye di, kusĩ tamo neid odug iron, “Aya Rom tamo wõ auf nigin, moni odugem na alen.” Pol iron, “Anĩ ere, aya Rom tamo gõ difiyan.” ");
INSERT INTO dad_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Age ye di, tamo Pol to difiyẽf nigin age difen idi, kaisã bagai folõ difelen. Kusĩ tamo neid odug ĩg, Pol ĩ Rom tamo, sen nem ifon anĩ weder fokõ yel fen, kumĩ yen. ");
INSERT INTO dad_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Naa anĩ ile di, kusĩ tamo neid odug ĩ, Juda idi Pol bou bun od dun anĩ nẽ gariya tutuk bagai keleĩ youf nigin oron, anĩ nigin, ĩ Pol yalisne ken, pris odudug ado Juda neid uyu irouya ganan guru difouf nigin irokenẽdin. Agef fen, ĩ Pol yale irousi, idi wagedin ifarnen. ");
INSERT INTO dad_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol guru fiya anĩ lo feid le fen, iron, “Turau tar, aya Negur kabĩ ifanan anĩ, wau karẽtut bagai ado age alef asi, gama naa enei bun.” ");
INSERT INTO dad_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Od enĩ irõ di, pris neid mudur Ananias, tamo Pol non difaren anidi ĩ sigor daũ difouf nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Age ye di, Pol Ananias irokenen, “Negur õ inõ irãf, õ pen lalaum garaĩ naki fiya! Õ lo kilei es wiyauf nigin an ubodok, anĩ ere, õ lo wal wo fen, aya dinauf nigin urokenẽdif!” ");
INSERT INTO dad_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tamo Pol non difaren anidim ĩ dirokenen, “Õ Negur nẽ pris neid mudur kumĩ sã kono wiyek de?” ");
INSERT INTO dad_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Age de di, Pol iron, “Turau tar, ĩ pris neid mudur anĩ aya to kelein. Are Negur nẽ Itotoya bun ibodok, ‘Ogon tamo kayau neid uyu irouya nigin od sane to urõf.’ ” ");
INSERT INTO dad_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Age ye fen, Pol idi tunĩ Sadusia tamo, tunĩ Farisia tamo anĩ kelei ken, uyu irouya neid guru fiya mala bun iweig iron, “Turau tar, aya Farisia tamo taka, Farisia tamo naaluid. Aya laa bun tamal mata kel fãya nigin wau iseya ado nigin, kot bun afaref.” ");
INSERT INTO dad_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pol od enei irõ di, Farisia tamo ado Sadusia tamo geid fefe de fen, guru fiya anĩ faraf uru fen. ");
INSERT INTO dad_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sadusia tamo idi dirõdig, laa bun tamal mata kel fãya sã, engel sã, uureg sã, anĩ ere, Farisia tamo idi dirõdig, anĩ ganan are dibodok.) ");
INSERT INTO dad_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Aiteid oduduge di, lo ifelnẽdiya tamo tunĩ, idig Farisia bun temeleid fafã de fen, totol bagai fe de diron, “Amã tamo enei bun kũ fenẽya taka to mailef. Ĩ uurem be engel takam be irokenen are, naig fiyauf?” ");
INSERT INTO dad_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Fefeya anĩ ile, sane le di, kusĩ tamo neid odug Pol fisik difouf ye fen, kumĩ yen. Anĩ nigin, ĩ kusĩ tamo disil, imedin tamal totol ado son difeid, kusĩ tamo neid fõ bun diroulauf nigin, irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Bõ anĩ bun, Odug Pol non ifar fen, iron, “Totol uno! Õ Jerusalem ein, aya nigin wogõ wol gen, õ Rom ouneg ago wogõ wouf.” ");
INSERT INTO dad_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bonimei di, Juda idi guru de fen, Pol yukesiya nigin kisi katõ difen. Pol yukesiya sã mog, idi saaf ado naan to dãf nigin waud kuturol fen, od difon. ");
INSERT INTO dad_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Tamo foti wal fiya anidim, enei nigin kisi katõ difen. ");
INSERT INTO dad_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Idi pris odudug ado uyu iroudiya bun dile fen, diron, “Pol yukesiya sã mog, amã ereb taka to mãf nigin waumã kuturol fen, od mafon. ");
INSERT INTO dad_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Anĩ nigin, gama ã uyu irouya neid guru fiya geid, tamomoi ge fen, Pol nigin tutuk bagai keleĩ youf ge fen, ĩ ã gein dirou disiyouf nigin, kusĩ tamo neid odug urokenẽgouf. Amã, ĩ ein wõya sã mog, ĩ maukesiyouf nigin dodok mafef.” ");
INSERT INTO dad_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Anĩ ere, Pol main nẽ naal kisi enei karĩ ye fen, ĩ kusĩ tamo neid fõ bun ile fen, Pol irokenen. ");
INSERT INTO dad_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Age ye di, Pol kusĩ tamo neid orowa taka iweignẽ isi di, iron, “Tamo gaũ enei wale, kusĩ tamo neid odug gein uroule. Ĩ od taka irokenẽf nigin ado.” ");
INSERT INTO dad_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Anĩ nigin, ĩ kusĩ tamo neid odug garan yale iroule fen, iron, “Kalabus tamo Pol iweigna fen, tamo gaũ enei õ gein arou asiyouf nigin irokanal, ere nigin, ĩ od taka irokonõf nigin ado.” ");
INSERT INTO dad_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kusĩ tamo neid odug, tamo gaũ ima yale irou, yerin dile fen, to fiyen, “Aya ere od anĩ urokanau fenẽ?” ");
INSERT INTO dad_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tamo gaũ iron, “Juda idi waud tekeleil, tamomoi de fen, Pol nigin tutuk bagai keleĩ youf de fen, nil uyu irouya neid guru fiya mala bun, ĩ diroulauf nigin dirokonõf. ");
INSERT INTO dad_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Are idi to karĩ wiyẽdiyouf, ere nigin, tamo foti wal fiya anidim ĩ nigin dimin ken, tari difef. Pol yukesiya sã mog, idi saaf ado naan to dãf nigin waud kuturol fen, od difon. Idi dodok difel fen, Pol idi garan sur fiya nigin ogon yoya anĩ tari difef.” ");
INSERT INTO dad_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kusĩ tamo neid odug tamo gaũ anĩ weder irou fen, sur fen, “Õ enei urokanal anĩ, aib taka to urokenẽf.” ");
INSERT INTO dad_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Age fel fen, ĩ kusĩ tamo neid orowa uru iweigneĩd, disi di, irokenẽdin, “Kusĩ tamo tu handred ado, kusĩ tamo sewenti hos adodo, kusĩ tamo tu handred ot adodo anidim, bõ nain kilok Sisaria taun ulagauf nigin, dodok gouf. ");
INSERT INTO dad_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pol teten ibod ken, Gawaman nẽ Mudur Feliks bun biya ile wõ youf nigin, hos tunĩ dodok gouf.” ");
INSERT INTO dad_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ĩ pas eig ye itoton: ");
INSERT INTO dad_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Aya Klodius Lisias, Odug Gawaman nẽ Mudur Feliks aan ayok. ");
INSERT INTO dad_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Tamo enei Juda tamom dale fen, dukesiyou fenẽ age difen, anĩ ere, aya neu kusĩ tamo geid masi masennen, ere nigin, aya ĩ nigin kelein, ĩ Rom tamo. ");
INSERT INTO dad_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Idi ĩ bun od dun anĩ, aya gariya keleĩ youf nigin, ĩ dogo neid uyu irouya guru fiya bun aroulen. ");
INSERT INTO dad_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ĩ bun od dun are dogo neid lo nigin age difen, anĩ ere, ĩ laa fiya nẽ be, kalabus ilauf nẽ ereb taka to age fen anĩ aya kelein. ");
INSERT INTO dad_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Aya ĩ dukesiyouf nigin naab dimirek ya anĩ karĩ au fen, aya kaisã bagai ĩ, õ gein sur afiyen. Ĩ bou bun od dun idig, õ malã bun nedi morõ yaor difouf nigin arokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Anĩ nigin, kusĩ tamo idi irokenẽdin kilei, dõ def age difen, idi bõ Pol dale dirou, Antipatris taun dilen. ");
INSERT INTO dad_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","We fele di, idi, kusĩ tamo hos adodo, Pol geid dilauf nigin dirokeneĩd fen, idi kusĩ tamo neid fõ bun keku de dilen. ");
INSERT INTO dad_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kusĩ tamo hos adodo Sisaria taun wõ de fen, pas anĩ gawaman nẽ mudur difen ken, Pol ĩ ima bun dinon. ");
INSERT INTO dad_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gawaman nẽ mudur ĩ pas anĩ iwes fen, Pol ĩ teneub nanĩ bun tamal anĩ to fiyen. Gawaman nẽ mudur ĩ, Pol Silisia provins bun tamal anĩ kelei ken, ");
INSERT INTO dad_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ĩ iron, “Aya ogon od, tamo õ bun od dun anidi ein disiyouf bun, karĩ auf.” Age ye fen, ĩ Pol Herod nẽ fõ bun dinene ken, lo difouf nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Naa faif ilele di, pris neid mudur Ananias, uyu irouya tunĩ ado, lo keleĩ tamo yana Tertulus dedig geid, Sisaria taun disilen. Idi Pol bouwa bun od dũf nigin, gawaman nẽ mudur mala bun wõ den. ");
INSERT INTO dad_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Anĩ Pol diweignẽ, isi di, Tertulus Feliks mala bun, Pol bun bou yũya od anĩ gariya ino irokenen, “Amã õ farumen wau inosiya sain meluk mabodok masin. Ogon lo fiya biya bun, neda teneub bun ereb ereb biya musei wowã den. ");
INSERT INTO dad_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Odug Feliks, modoũ ganan ado naab ganan bun, amã enei kelei ken, anĩ nigin fatuk bagai de mayok. ");
INSERT INTO dad_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Anĩ ere, aya ogon sain to akasiyouf nigin, õ waũ ino ken, sain naal bagai karĩ wamãf nigin arokonok. ");
INSERT INTO dad_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Tamo enei morõ inoya tamo, teneub ganan bun, Juda tamo atun kuru yalesedig anĩ amã mailen. Ĩ Nasaret idegẽya momoiya mala neid uyu irouya. ");
INSERT INTO dad_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ĩ tempeleg amuyẽ ifenẽf nigin age fen, anĩ nigin, amã ĩ malen. ");
INSERT INTO dad_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Õ ogo tamo enei to wiyẽf are, od ĩ bou bun manof anĩ ganan momoi bagai ya anĩ, õ keleĩ youf.” ");
INSERT INTO dad_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Juda tamo idi, ĩ bou bun od yũya bun megeir dife fen, are momoi, den. ");
INSERT INTO dad_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gawaman nẽ mudur, Pol wogõ youf nigin mudurem dogol fiyẽ di, Pol iron, “Aya keleĩ, yar musei õ teneub enei bun es fiya tamo ubodon, anĩ nigin, aya wau el fe fen, aya yug nigin megeir afouf. ");
INSERT INTO dad_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Malai sã, õ yaor bagai keleĩ youf, are naa tuwelf dogol mogo ilef, aya Negur yana alesauf nigin Jerusalem eselen. ");
INSERT INTO dad_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Aya bouwau bun od dun tamo idi keleĩ, aya aib taka ado tempel bun to fe maun be, Juda neid uub fõ bun be taun nameneg, tamo kayau waud to alesen. ");
INSERT INTO dad_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Idi gama aya bouwa bun od duk are momoi yeya anĩ, õ ifelnõya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Anĩ ere, aya Naab idi idegẽya dedig anĩ dõ afe fen, tubuda tar neid Negur yana alesedig, are momoi auf. Aya Moses nẽ Lo ado, profet neid buk bun ditoton anĩ ganan nigin, momoi auf. ");
INSERT INTO dad_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ayag tamo eneidi gen Negur bun wau iseya ado, are madur tamo ado tamo sesen laa bun tamal mata ke de fã douf anĩ. ");
INSERT INTO dad_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Anĩ nigin, Negur mala bun ado tamo meleid bun, aya wau karẽtut abodõf nigin sain ganan kabĩ totol aledig. ");
INSERT INTO dad_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Aya yar tunĩ firen abodkele fen, aya neu tamo kayau maleg nigin safina wau sã ado, Negur bun sesewi fiya nẽ safina, Jerusalem arou asin. ");
INSERT INTO dad_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Aya nonorou lilik afel fen, enei age afe mog, idi aya tempel modoũ bun fotou difiyan. Aya an tamo guru fiya mala taka geid san, katã san. ");
INSERT INTO dad_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Anĩ ere, Juda tamo tunĩ Asia provins temeleid an difaren anidi, dogo bagai õ gein disi fen, bouwau bun od yũya idi adouf are, wogõ dem bagai. ");
INSERT INTO dad_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Sãf are, tamo eneidim, aya uyu irouya neid guru fiya meleid bun afaren sain, idi aya bun ereb mosor fotou difen anĩ wogõ douf. ");
INSERT INTO dad_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Tekelei dogol, aya idi meleid bun afar fen, aweig aron, are eig fiya, ‘Laa bun tamal mata kel fãya anĩ nigin, aya gama ã melein kot bun afaref.’” ");
INSERT INTO dad_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Age ye di, Feliks ĩ yogo, Naab anĩ nigin keleĩ bagai, ĩ kot gudũ fel fen, iron, “Kusĩ tamo neid odug Lisias isiyouf sain, aya ogon kot nigin od afõf.” ");
INSERT INTO dad_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ĩ, Pol lo difouf, anĩ ere, ĩ karika difen ken, yogon mou tar ĩ ereb lau fef anĩ kulatun difouf nigin yo fiyẽdiyouf nigin, kusĩ tamo neid orowa irokenen. ");
INSERT INTO dad_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Naa tunĩ ilele di, Feliks ĩ aiwa Drusila Juda kayau ado disin. Ĩ Pol nigin od sur fe, isi fen, ĩ Kristus Jesus bun momoiya nigin wogõ ye di, karĩ yen. ");
INSERT INTO dad_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pol ĩ Negur nẽ madur fiya nigin, tamo yogon oroya kulatun fiya nigin ado, es fiya fau isiyouf anĩ nigin dir fe di, Feliks ĩ kumĩ ye fen, iron, “Are de bure welef! Wadã ule. Sain biya adouf are, õ nigin od sur afouf.” ");
INSERT INTO dad_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","De sain anĩ bun, Feliks ĩ, Polem moni ifenẽf nigin oron, anĩ nigin, sain musei Feliks Pol nigin od sur fe fen, urom wogõ dedig. ");
INSERT INTO dad_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Yar uru ilele di, Porsius Festus, Feliks nẽ modoũ yalen. Anĩ ere, Feliks Juda tamo meleid yalouf nigin, Pol kalabus bun itornẽ ibodon. ");
INSERT INTO dad_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus provins anĩ bun wõ ye, naa towo ilele di, ĩ Sisariam Jerusalem iselen, ");
INSERT INTO dad_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","an pris odudug ado Juda neid uyu iroudiya geid, ĩ mala bun wõ de fen, Pol bou yũya od anĩ dirokenen. ");
INSERT INTO dad_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Festus ĩ wau ifeneĩd fen, Pol Jerusalem sur fe di, ilauf nigin totol bagai dirokenen, ere nigin, idi naab luwen dimin ken, Pol dukesiyouf nigin dodok difen. ");
INSERT INTO dad_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Age de di, Festus ĩ irokenẽdin, “Pol oun Sisaria kalabus bun ibodok. Aya yug mogo an alau fenẽ. ");
INSERT INTO dad_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Anĩ nigin, tamo anĩ ereb kũ fenen ouf are, ãgenei uyu irouya tunĩ aya weim Sisaria mele fen, an ĩ bou yũya od wogõ douf.” ");
INSERT INTO dad_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus ĩ idi geid, naa eit be ten dibodkele fen, Sisaria isilen. Naa anĩ ile di, ĩ es fiya modoũ bun ibod ken, Pol ĩ wagen dirousiyouf nigin irokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pol wõ ye di, Juda idi Jerusalem temeleid disin ĩ salili difiye ken, ĩ mosor sane bagai inon de fen, ĩ bou yũya od musei diron, anĩ ere, idi anĩ nẽ gariya to yaor difedin. ");
INSERT INTO dad_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Age dife di, Pol yogo nigin isennẽya od iron, “Aya Juda neid lo nigin, tempel nigin, Sisa nigin be, ereb kũ fenẽya taka to age afen.” ");
INSERT INTO dad_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Anĩ ere, Festus ĩ, Juda tamo ĩ nigin waud yenẽf nigin wau iro ken, Pol irokenen, “Õ Jerusalem usel fen, boũ yũya od eneidi nigin an aya malaun kot bun ufarauf de?” ");
INSERT INTO dad_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pol iron, “Aya gama Sisa nẽ kot bun yeir afaref, ein aya kot difiyauf. Õ ogo keleĩ bagai, aya Juda tamo bun kũ fenẽya taka to anon. ");
INSERT INTO dad_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Anĩ ere, aya laa nẽ mosor taka anon ouf are, aya laa nigin to atorok. Anĩ ere, Juda tamo eneidi bouwau bun od dun anĩ momoi sãf are, aya taka nem idi imeid bun inenaya kisi feleya sã. Aya Sisa bun kot afouf.” ");
INSERT INTO dad_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus ĩ, yogon lo keleĩ tamo geid, katõ difel fen, iron, “Õ Sisa bun kot afouf wol. Õ Sisa gein ulauf.” ");
INSERT INTO dad_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Naa tunĩ ilele di, King Agripa Bernis ado, Festus aan difiyẽf nigin Sisaria taun disin. ");
INSERT INTO dad_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Idi naa musei an dibodõ di, Festus Pol nigin king ado katõ de fen, ĩ iron, “Feliks ĩ, kalabus tamo taka ein itornen ibodok. ");
INSERT INTO dad_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Aya Jerusalem ele di, pris odudug Juda neid uyu irouya geid, ĩ bun bou yũya od dirou disi fen, ĩ mosor ado afiyẽf nigin dirokanan. ");
INSERT INTO dad_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Anĩ ere, aya arokenẽdin, Rom neid tobonunã bun, tamo taka bou bun od duk ĩ, yogon kiwai tar meleid bun ifar fen, bou bun od dun anĩ nigin, yogo bou isennẽya od wogõya sã mog, are kaisã tamo anidi imeid bun to dinenẽf. ");
INSERT INTO dad_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Idi aya weim ein masi fen, aya to foi aun, we fele di, aya es fiya modoũ bun abod ken, tamo are dale dirou disiyouf nigin arokenẽdin. ");
INSERT INTO dad_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Yogon kiwai tar fã de wogõ den, anĩ ere, aya mosor kisi afen anĩ nigin taka to bou bun dun. ");
INSERT INTO dad_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Anĩ ere, idi dogo neid momoiya nigin ado, laa tamo yana Jesus, Pol ĩ nigin mata ibodok yedig anĩ nigin, ĩ geid fefe den. ");
INSERT INTO dad_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Aya enei nigin naig afe tutuk keleĩ youf au fen, nene aun, anĩ nigin, aya ĩ Jerusalem ile fen, bou bun od dun enei nigin an kot bun ifarauf nigin to afiyen. ");
INSERT INTO dad_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Anĩ ere, Pol ĩ kusĩ tamom lo difiyẽ dile, fau dum Sisam es fiyẽf nigin irokanan. Anĩ nigin, aya ĩ lo difiyek dile, ĩ Sisa gein sur fiya nigin naab amir ken, sur afiyẽf sain bun anĩ nigin arokenẽdin.” ");
INSERT INTO dad_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Age ye di, Agripa Festus irokenen, “Aya yug tamo enei karĩ afiyẽ fenẽ.” Festus iron, “Õ nil karĩ wiyẽf.” ");
INSERT INTO dad_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Naa anĩ ile di, Agripa Bernis ado, biya biyamã de disi, guru fiya fõ aaben, kusĩ tamo neid odudug, taun nẽ uyu iroudiya geid dilen. Festus irõ di, Pol aaben dirou disin. ");
INSERT INTO dad_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus iron, “King Agripa ado tamo ganan weim tafaref ã, tamo enei ulegef. Juda tamo kayau ganan Jerusalem ado ein Sisaria, ĩ nigin totol bagai dirokanan. Idi ĩ mata to ibodõf nigin diweig diron. ");
INSERT INTO dad_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Aya, ĩ laa fouf nẽ ereb taka to age fen anĩ ailen. Anĩ ere, ĩ Sisa bun kot fouf nigin iron, anĩ nigin, aya ĩ Rom sur fiya nigin kisi afon. ");
INSERT INTO dad_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Anĩ ere, aya ĩ nigin ereb od Sisa bun atotkenẽf anĩ yaor sã. Anĩ nigin, aya ã ganan meleĩ bun ĩ arou asil, King Agripa õ bun bagai, anĩ bunem aya ĩ to afiyẽ kelei ken, ĩ nigin ereb od itotoya nigin adouf be. ");
INSERT INTO dad_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ere nigin, aya kisi afef, kalabus tamo ĩ ereb mosor inon anĩ to yaor mog, sur afouf, are to biya.” ");
INSERT INTO dad_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Age ye di, Agripa Pol irokenen, “Aya õ ogo nigin wogõ wouf nigin arokonok.” Anĩ nigin, Pol imam fe fen, yogo isennẽf nigin wogõ yen, ");
INSERT INTO dad_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“King Agripa, bolẽ bagai, aya gama õ malã bun afar fen, Juda tamo aya bouwau bun od dun anĩ ganan nigin, aya yug isennauf nẽ od wogõ auf. ");
INSERT INTO dad_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Bolẽ bagai auf, ere nigin, õ Juda neid tobonunã ado luwa irouya anĩ ganan keleĩ. Anĩ nigin, õ folo reis fen, karĩ wiyauf nigin agonok. ");
INSERT INTO dad_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Aya kesu naalun naig be afe abodon are, Juda tamo ganan keleĩ. Uruwa bun, aya neu teneub bun abodon, age afe fen, Jerusalemeg abodon are idi keleĩ. ");
INSERT INTO dad_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Idi aya nigin sain meluk kelein, anĩ idi orodiyouf are, idi sã wogõ douf, are ada neda momoiya mala bun, Farisia tamo idi lo totol bagai dõ difedig anidi neid taka abodon. ");
INSERT INTO dad_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Negur ada tubuda tar bun age afouf bagai fiyẽdin anĩ bun, aya wau iseya ado, anĩ nigin, aya gama kot bun afaref. ");
INSERT INTO dad_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Negur age afouf bagai fiyẽdin anĩ nigin, ada neda ibor tuwelf, gaa ado bõ ado totol bagai Negur aruna dales fen, anĩ kisi fele di, dilouf nigin waud iseya adon. O king, wau iseya enei nigin, Juda idi aya bouwau bun od duk. ");
INSERT INTO dad_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ere nigin ã, Negur laa tamo kel turĩ fiyek anĩ kisi feleya sã gef? ");
INSERT INTO dad_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Aya yugeg, Jesus Nasaret tamal yana kiwai afenẽf nigin ereb ereb ganan age afouf aun. ");
INSERT INTO dad_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Are aya Jerusalem an age afen. Pris odudug bun yoya ale fen, Negur nẽ tamo kayau musei kalabus bun anenẽdin. Idi laa bun dinenẽdin sain, ayag idi laa bun dinenẽdiyouf nigin yo aun. ");
INSERT INTO dad_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Sain musei, aya idi darau afenẽdiyouf nigin, Juda neid uub fõ fõ bun elen, age afe fen, idi Negur kono difiyẽf nigin nugo afiyẽdin. Aya idi nigin nameu sane bagai yen ken, aya idi kafĩ fiya afenẽdiyouf nigin yaũ tauneg elen. ");
INSERT INTO dad_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“De anĩ nigin sain taka bun, aya pris odudug neid od ado, yoya bun Damaskus taun elen. ");
INSERT INTO dad_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","O king, gaa atun age fiya naab luwe ele mog, aya saa ilun tamal fula fiya taka, gaa nẽ medeĩya wal fiya, aya neu kabĩ turau tar geid bun, fula felen anĩ ailen. ");
INSERT INTO dad_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Amã ganan tenebur kuku mau fen, ait taka Hibru od nem eig ye irokana mog, karĩ aun, ‘Sol, Sol, ere nigin õ aya daig wiyaf? Õ aa waila ado bun yẽ urak are, õ nigin malai bagai.’ ");
INSERT INTO dad_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Age ye di, aya to afen, ‘Odug, õ aim?’ “Odug iron, ‘Aya Jesus, õ daig wiyaf anim. ");
INSERT INTO dad_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Gama õ fã wale yem ufar. Aya õ bun wõ aul, ere nigin, õ neu kabĩ tamo wõ wo fen, õ aya nigin ereb ulen ado ereb afelnõf anĩ wogõ wouf nigin agirnon. ");
INSERT INTO dad_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Aya Israel tamo kayau bun ado haiden buneg asennõf. Aya idi bun õ sur ayok, ");
INSERT INTO dad_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","idi meleid fokõ yel fen, gugum bun tamal lalan bun disiyouf ado, Satan nẽ megeir bun tamal Negur bun disiyouf, anĩ bunem idi neid mosor nigin weder tu keleya dale fen, aya nigin momoi de fen, fateuledin anidi atun dogo neid modoũ gei difouf.’ ");
INSERT INTO dad_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“King Agripa, anĩ nigin, aya saa ilun tamal malau seleulã kurãf fen, ailen anĩ to adodon. ");
INSERT INTO dad_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Uruwa, oun Damaskus taun difaref anidi bun, Jerusalem ado Judia distrik ganan bun difaref anidi bun ado, haiden buneg, idi waud falei ye, Negur bun falei dife fen, ereb age difef bunem, idi waud falei yen anĩ yaor difouf nigin wogõ aun. ");
INSERT INTO dad_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Anĩ nigin, Juda idi tempel modoũ bun daleya fen, dinakesiyou fenẽ nigin age difen. ");
INSERT INTO dad_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Anĩ ere, Negur aya isennaf isi, gama naa enei bun, anĩ nigin, aya ein afar fen, nanaal ado odudug bun wogõ auf. Aya Moses profet geid agef wõ youf den anĩ to adod ken, wogõ auf, ");
INSERT INTO dad_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","are Kristus darau yale fen, ĩ ket laa bun tamal mata kel fã ye fen, Israel tamo kayau ado haiden geid bun, fula fiya anĩ nigin kurõ fesiyouf anĩ.” ");
INSERT INTO dad_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol yogo bouwa isennẽf nigin od enei wogõ ye di, Festus iweig iron, “Pol, õ wadã inok. Ogon keleĩ odug anim wadã bun irouleyok.” ");
INSERT INTO dad_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pol iron, “Odug Festus, aya wadã sã. Ereb aya orok enei are momoi, gariya ado. ");
INSERT INTO dad_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","King ĩ enei nigin keleĩ, anĩ nigin, aya kumĩ sã wogõ ayok. Aya momoi auf, are enei taka ĩ mala bun to iminen, ere nigin, enei iminẽyan to wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","King Agripa, õ profet ganan nigin momoi wof de? Aya keleĩ, õ momoi wof.” ");
INSERT INTO dad_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Age ye di, Agripa Pol irokenen, “Õ kisi wof, are sain tobega eig fiya bun aya Kristen wõ auf nigin neu kisi falei wouf de?” ");
INSERT INTO dad_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol iron, “Sain tobega be, sain meluk, aya Negur kosẽ afiyẽdig are õ nigin dogol sã, ganan gama aya karĩ wiyagef ãg, aya gen wowã gouf nigin, anĩ ere, sen enei dogol anĩ to difõyeĩf.” ");
INSERT INTO dad_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Age ye di, king, gawaman nẽ mudur, Bernis ado, idi weim dibodon ganan fafã den. ");
INSERT INTO dad_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Age de fen, idi aab ditor dile, abob diroken ken, diron, “Tamo enei ereb taka laa fouf nẽ be, kalabus ileya nẽ to age fef.” ");
INSERT INTO dad_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa Festus irokenen, “Tamo enei Sisa bun to kot fem are, ĩ yalisnẽya kisi feleyam.” ");
INSERT INTO dad_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Amã waag bun Itali kantri malauf nigin od difõ di, Pol kalabus tamo tunĩ geid, kusĩ tamo neid orowa taka yana Julius ima bun dinenẽdin, ĩ Sisa nẽ Kusĩ Mala bun tamal taka. ");
INSERT INTO dad_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Amã waag taka, Adramitium taun tamal Asia provins bun maaĩ ub ub ilau fenẽ agef mog, sõ mau fen, melen. Aristakus, Tesalonika taun tamo oun Masedonia provins bun tamal, ĩ amã weim. ");
INSERT INTO dad_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Naa ile di, Saidon taun wõ maun. Julius ĩ Pol wau ifen ken, ĩ mou tar gedin ile fen, ereb ĩ lau fef anĩ difenẽf nigin yo fiyen. ");
INSERT INTO dad_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Anenem amã baban waag bun sõ mau fen, Saipras nuyo wagenem melen, ere nigin, yau naaburamã gudũ fen. ");
INSERT INTO dad_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Amã Silisia ado Pamfilia maaĩ atu mele fen, Lisia provins bun Maira taun wõ maun. ");
INSERT INTO dad_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","An kusĩ tamo neid orowa, Aleksandria taun tamal waag taka Itali kantri ilau fenẽ mog, ile fen, ĩ amã waag bun inenaman. ");
INSERT INTO dad_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Amã naa musei, foinenem waag bun, Nidus taun non wõya nigin darau nem melen. Yau naaburamã gudũ fe di, amã Krit nuyo uyu Salmone wal mafe fen, Krit nuyo wagenem melen. ");
INSERT INTO dad_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Amã darau kininem maaĩ ub dõ maf masil, modoũ yana Basis Biya dedig, Lasea taun non an wõ maun. ");
INSERT INTO dad_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Naa musei ilelen, agef fen, waag bun ileya are mogo sane bagai len, ere nigin, naa are Kuriya Naa dumen. Anĩ nigin, Pol wedereid iroun, ");
INSERT INTO dad_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Tamo, aya ailef are, neda waag bun delẽ sanel fen, waag adoi, udũ adoi, tamo adag daũf sa kalauf.” ");
INSERT INTO dad_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Anĩ ere, kusĩ tamo neid orowa, Pol wogõ yen anĩ to karĩ ye fen, waag irouya tamo ado waag marau idi neid od dõ fen. ");
INSERT INTO dad_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Basis are yau sain bun ifareya to biya nigin, musei ganan, waag bun tokõ mafel, Finiks wõ mau fen, an mabodõf nigin kisi difon. Finiks are Krit nuyo nẽ basis taka, gaa ileyan saut ado not melem wage ifenek. ");
INSERT INTO dad_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yau saut melem foinenem fũ fe di, idi neid oroya kilei agef wõ yen anĩ kisi difen. Anĩ nigin, idi anka dĩ difesel fen, waag bun Krit nuyo maaĩ ub dõ de dilen. ");
INSERT INTO dad_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Sain meluk ileya sã mog, yau odug totol ado, yana ‘Gaa iseyan not tamal’ dedig anĩ, fã ye fen, nuyo bunem fũf irou isilen. ");
INSERT INTO dad_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Yau odug totol ado waag yũ di, waag yau bun ileya kisi feleya san. Anĩ nigin, amã waag ulum irouya matorõ di, yaum irouleman. ");
INSERT INTO dad_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Amã nuyo naal taka Kauda dedig dumenem wal mafe fen, isennẽya nẽ waag naal darau nem dĩ mafen. ");
INSERT INTO dad_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Tamo, isennẽya nẽ waag naal, waag odug teten dalesel dino fen, gama idi malũ nem waag odug anĩ to fara fouf nigin luwa filu difen. Idi waag, maaĩ kulum yana Sirtis bun sõya nigin kumĩ de fen, anka folõ difesi di, yaum waag iroulen. ");
INSERT INTO dad_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Yau fatuk bagai waag yuk ile, we fele di, idi udũ tunĩ naanũ diraran. ");
INSERT INTO dad_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Naa anĩ ile di, idi imedim waag nẽ safina naanũ diraran. ");
INSERT INTO dad_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Naa musei, gaa ado barisa to mailen, agef fen, yau odug totol ado de agef yenen. Anĩ bunem, amã isennẽya malouf nigin waumã iseya ganan sa kelen. ");
INSERT INTO dad_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Tamo idi sain meluk saaf sã denek dilen nigin, Pol meledin ifar fen, iron, “Tamo ã, neu od Kritem waag bun to talauf nigin arokenein anĩ karĩ gem, are dem, ago gem are, daũ fiya ado iraraileya enei to fotou gem. ");
INSERT INTO dad_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Anĩ ere, aya totol unogouf nigin totol bagai arokeneik, ere nigin, ãgenei taka to fõ yalauf, waag dogol narĩ fouf. ");
INSERT INTO dad_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nor bõ, Negur, aya yogon, aya ĩ aruna aledig, yogon engel sirun ifar fen, ");
INSERT INTO dad_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","iron, ‘Pol, to kumĩ wo. Õ de Sisa malan kot bun ufarauf. Negur õ wau ifon ken, ganan õ geid waag bun ulegef idi neid mata õ ifonon.’ ");
INSERT INTO dad_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Anĩ nigin, tamo, totol unogouf, ere nigin, aya Negur bun momoiya anof, are ĩ irokanan kilei fau agef wõ youf. ");
INSERT INTO dad_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Anĩ ere, ada nuyo taka bun sõ tauf.” ");
INSERT INTO dad_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Naa fotin nẽ bõ anĩ bun, amã fau Mediterenian Maaĩ bun yaum iroulemã mog, bõ atun age fiya waag tamo idi teneub melsã melef ya anĩ kerẽ fedin. ");
INSERT INTO dad_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Idi naan nẽ mala es difouf nigin malũ folõ difele di, isil fen, naan nẽ mala foti mita dilen. Sain naal bagai dile fen, idi baban malũ folõ difele di, isil fen, naan nẽ mala teti mita dilen. ");
INSERT INTO dad_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Idi waag meein tuwa bun ileya nigin kumĩ de fen, idi waag dumen anka aiwa adodo folo folõ difeledi di, disil fen, gaa nigin kosẽ den. ");
INSERT INTO dad_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Waag tamo idi, waag bun tamal diyalalau fenẽ nigin, idi isennẽya nẽ waag naal folõ difele di, maaĩwõ isilen, tamomoi de fen, waag uyu bun anka dirarãf nigin de fen, age difen. ");
INSERT INTO dad_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Age dife di, Pol kusĩ tamo neid orowa, kusĩ tamo geid irokenẽdin, “Tamo eneidi waag bun to dibodõf are, ã isenneĩya to walogouf.” ");
INSERT INTO dad_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Anĩ nigin, kusĩ tamo idi, malũ isennẽya nẽ waag naal iroun anĩ gudũ difele di, ilen. ");
INSERT INTO dad_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","We kurã fiya sã mog, idi ganan saaf dãf nigin, Pol ĩ totol bagai irokeneĩd fen, iron, “Naa fotin bun ã sii yei ken, saaf sã usigen, ã saaf taka to wõgen. ");
INSERT INTO dad_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Anĩ nigin, gama aya ã saaf wãgauf nigin totol bagai arokeneik. Ã mata ubodõgouf nigin wãgauf. Ãgenei taka, mudur bun fatiya tekelei bagai taka to kusuf irãf.” ");
INSERT INTO dad_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pol od enei wogõ yel fen, idi ganan meleid bun, ĩ bret tunĩ yale, Negur de fiyekel fen, mũf gariya ino yon. ");
INSERT INTO dad_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Idi ganan waud yalese di, saaf don. ");
INSERT INTO dad_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Amã waag bun mafaren ganan gu feleya are 276. ");
INSERT INTO dad_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Idi dakas kisi fele di, idi waag karikauf nigin, wit ganan maaĩwõ diraran. ");
INSERT INTO dad_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lalan ise di, teneub uyu nain be ya anĩ idi keleĩ san, anĩ ere, alelei ub mumul ado anĩ dilen, kisi falauf are, idi an waag dirou dilauf nigin kisi difon. ");
INSERT INTO dad_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","De sain tekelei bun maaĩwõ anka kokour de ditorarã yen ken, malũ waag uyu gadi fiya nẽ pul difon anĩ biru difeledin. Age difel fen, idi yau bun sel dalesel fen, yau difenẽ di, waag ubun irou ilauf nigin age difen. ");
INSERT INTO dad_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Anĩ ere, maaĩ irak isi abob bun dũdig nẽ an, waag maaĩ kulum yu ken, anĩ teten sõ yesen. Waag uyu degẽ fel fen, tonoya kisi feleya san, age fe di, waag ibu maaim yũ di, faraf fisik fe irailen. ");
INSERT INTO dad_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kalabus tamo idi maaĩwõ to gaõgĩ de diyawauf nigin, kusĩ tamo idi didenkesiyouf nigin katõ difen. ");
INSERT INTO dad_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Anĩ ere, kusĩ tamo neid orowa Pol isennẽf nigin wau iro ken, kusĩ tamo idi dogo neid kisi to dõ de age difouf nigin gudũ felen. Idi yoyõya kisi feleya anidi, ketem waag bun tamal gurusã de fen, teneub bun dilauf nigin, ĩ ari fedin. ");
INSERT INTO dad_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Tunĩ ganan aa bun be, waag masasak bun an dilen. Anĩ bunem, idi ganan biya bagai totoũ teneub bun wowã den. ");
INSERT INTO dad_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Amã biya bagai ubun wõ mau fen, nuyo are yana Malta ya anĩ kelein. ");
INSERT INTO dad_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Tamo kayau an temeleid waud fatuk bagai difanaman. Uyẽ isi fen, feluken nigin, idi yã kũ dife fen, amã ganan aan difaman. ");
INSERT INTO dad_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol ĩ aa were gurif fen, yã teten ino mog, gogour sane yã uruwam iru di, Pol ima bun degẽ felen. ");
INSERT INTO dad_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Tamo kayau an temeleid, gogour anĩ Pol ima bun kuuri ye mog, dile fen, idi abob dirokenen, “Tamo enei tamo yukesiya tamo bagai, ere nigin, ĩ maaĩwõ tamal iyawol, anĩ ere, neda waitou Madur Fiya anim ĩ mata ibodõf nigin to oron.” ");
INSERT INTO dad_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Age de di, Pol ĩ gogour wiri fe di, yã malan isilen, anĩ ere, ĩ bun ereb taka to wõ yen. ");
INSERT INTO dad_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Tamo kayau ĩ ima dĩ youf be, kaisã bagai kubũ ye laa fouf de fen, kisi difen. Anĩ ere, idi sain meluk lo difef dile, ereb taka ĩ bun to wõ yen anĩ dile fen, idi kisi falei del diron, ĩ waitou den. ");
INSERT INTO dad_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Teneub akor melsã are, nuyo anĩ nẽ mudur, Publius nẽ teneub ibodon. Ĩ aan fama ken, yogon fõ bun gei famã iroule, naa towo el fe kulatun faman. ");
INSERT INTO dad_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ĩ tama dagi di, fataren yenen, bouwa uruwa ado te fururũ yalen. Pol ĩ ilouf nigin ile kosẽ yel fen, ima teten ino di, dagi fara felen. ");
INSERT INTO dad_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Enei wõ ye di, nuyo bun dagi tamo tunĩ ganan ĩ garan disi di, el feid ledin. ");
INSERT INTO dad_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Idi naab fire fire bunem el difama ken, amã waag sõ mauf nigin dodok mafe di, idi amã ereb ereb lau mafen anĩ difanaman. ");
INSERT INTO dad_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ogõ towo ilele di, amã, waag taka yau sain bun nuyo an si inon anĩ, sõ mau fen, melen. Waag are Aleksandria taun tamal, anĩ uyu bun, waitou aina ado Kastor Polluks ado meleidkanon dinon. ");
INSERT INTO dad_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Amã Sirakus taun wõ mau fen, naa towo an mabodon. ");
INSERT INTO dad_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Anenem amã waag bun mele, Regium taun wõ maun. Naa anĩ ile di, yau saut melem fã yen, baban naa anĩ ile di, amã Puteoli taun wõ maun. ");
INSERT INTO dad_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","An amã momoiya tamo tunĩ fotou mafiyẽdi di, idi geid naa sewen mabodõf nigin dirokanaman. Age mafel fen, Rom taun masin. ");
INSERT INTO dad_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Momoiya tamo an, amã masif ya anĩ karĩ de fen, idi diyok disi, Apius Maket ado Tamo Yenẽya Fõ Towo bun an fotou difamãf nigin disin. Pol tamo anidi ileid fen, Negur de fiye ken, wau megeir yalen. ");
INSERT INTO dad_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Amã Rom wõ mau fen, Pol ĩ mugu kusĩ tamo takam tari fiyek dibodõf nigin yo difiyen. ");
INSERT INTO dad_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Naa towo ilele di, Pol Juda neid uyu irouya iweig laisi, guru dife di, idi irokenẽdin, “Turau tar, aya, neda tamo kayau ado, neda tubuda tar neid tobonunã to adodon, anĩ ere, aya Jerusalem oun daliya fen, Rom imeid bun dinenan. ");
INSERT INTO dad_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Idi aya fele difiyale fen, dalisnau fenẽ age difen, ere nigin, aya laa nẽ mosor taka to anon. ");
INSERT INTO dad_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Anĩ ere, Juda idi anĩ nigin kiwai dinon, aya neu tamo kayau nigin bouwa yũya od taka san, anĩ ere, naab taka san nigin Sisa bun kot afen. ");
INSERT INTO dad_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Gariya anĩ nigin, aya fotou ayei ken, ã geid wogõ tauf nigin to ayein. Israel neid waud iseya anĩ nigin, aya sen enei nem difõyan.” ");
INSERT INTO dad_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Idi diron, “Amã õ nigin Judia distrik bun tamal pas taka to malen, agef fen, turada tar idi anenem disin õ nigin od taka be, od sane taka to dirokanaman. ");
INSERT INTO dad_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Anĩ ere, amã ogon kisi anĩ karĩ mauf nigin waumã irok, ere nigin, amã keleĩ, tamo kayau teneub ganan bun, ogon momoiya mala enei nigin kiwai od wogõ dedig.” ");
INSERT INTO dad_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Idi Pol dilouf nigin naa taka dinon, naa anĩ bun, idi musei bagaim Pol ibodon nẽ an disin. Pol ĩ bonimei nem ile bõ, Negur nẽ tano nigin faded fiyeĩd fen, kurõ feis irokenẽdin, ĩ Moses nẽ Lo ado profet neid itotoya bun, Jesus nigin idi neid kisi falei ye fen, momoi douf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Tunĩ Pol wogõ yen anĩ bun waud falei yen, anĩ ere, tunĩ to momoi den. ");
INSERT INTO dad_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Pol idikeleya od enei wogõ ye di, idi dogo dogol fefe de fen, dilelen, “Awa Uur Fateul profet Asaia sigor bunem eig ye wogõ yen, are ĩ tubuĩ tar momoi bagai od anĩ wogõ fiyẽdin: ");
INSERT INTO dad_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“‘Tamo kayau enei bun ule fen, urõ, “ã wedereim karĩ gouf, anĩ ere, wedereĩ to fokõ youf, ã meleim ulogouf, anĩ ere, meleĩ to fokõ youf.” ");
INSERT INTO dad_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ere nigin, tamo kayau enei, idi waud katĩ felen, idi wederedim karĩya kisi feleya sã, age de fen, idi meleid difofakelen, age fiya sam are, idi meledim dilem, wederedim karĩ dem ado, idi waud fokõ ye fen, falei de di, aya idi el afedim.’ ");
INSERT INTO dad_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Anĩ nigin, Negur nẽ isennẽya haiden bun sur fen anĩ, ã keleĩ youf. Age fe di, idi anĩg karĩ douf!” ");
INSERT INTO dad_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Yar uru adok, Pol ĩ yogon fõ na yaledig bun ibod ken, ĩ dilouf nigin disin ganan aan fiyẽdin. ");
INSERT INTO dad_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kumĩ sã ado kafĩ fiya sã, ĩ Negur nẽ tano nigin wogõ ye fen, Odug Jesus Kristus nigin ifelnẽdin. ");
INSERT INTO dad_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Aya Pol, Kristus Jesus nẽ ferfer, aposel wõ auf nigin iweigna fen, Negur nẽ biya od wogõ auf nigin igirnan. ");
INSERT INTO dad_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Biya od anĩ, Negur kulu bagai yogon profet promis od irokenẽdi di, Negur nẽ Itotoya Fateul bun ditoton, ");
INSERT INTO dad_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","are yogon Naal, neda Odug Jesus Kristus nigin, ĩ tamo nẽ ibor bun are, Dawid nẽ ibor bun wõ yen, ");
INSERT INTO dad_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","agef fen, fateul nẽ Awa Uur bunem, ĩ laa bun tamal kel turĩ fiyen anim, Negurem Jesus ĩ Yogo Naal megeir barikã ado anĩ yaor kurõ fesin. ");
INSERT INTO dad_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ĩ bunem, amã yogon yana seli kulõ fiya nigin, haiden ganan atun temeleid, tamo kayau maweignẽdi di, idi momoi de fen, dõ difouf nigin, amã wau ifenẽya ado aposel nẽ kabĩ malen. ");
INSERT INTO dad_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ãg, Jesus nẽ tamo kayau wowã douf nigin iweignẽdif anidi atun, ubodõgef. ");
INSERT INTO dad_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Tamo kayau ganan Rom taun ubodõgef, Negur ã nigin wau laaf fen, tamo kayau fateul wõ gouf nigin iweignein, ã bun pas enei atotof. Wau ifenẽya ado wau inosiya, neda Tamada Negur ado Odug Jesus Kristus bunem, ã bun isiyouf. ");
INSERT INTO dad_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Uruwa bagai, aya ã ganan nigin, Jesus Kristus bunem, neu Negur de afiyek, ere nigin, ãgenei momoiya nigin teneub ganan bun od iyokelen. ");
INSERT INTO dad_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Negur ĩ nigin aya wau adok iro ken, ĩ Naal nẽ biya od wogõya bun aruna aledig, ĩ ileya mog, aya ã nigin toku neu kosẽya bun faimud karĩ auledig. ");
INSERT INTO dad_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Age afe fen, gama Negur orouf are, naab kã fele di, aya ã gein asiyouf nigin aya kosẽ auf. ");
INSERT INTO dad_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Aya ã ileyeĩya nigin bagai wau irok, are aya uur nẽ ege luwa tunĩ megeir ifareya nẽ anĩ afeneĩf nigin age afef, ");
INSERT INTO dad_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","anĩ bunem, aya ã geid, mugu mugu ãgenei momoiya ado neu momoiya bunem abob tasennẽf. ");
INSERT INTO dad_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Turau tar, aya ã enei to keleĩ youf anĩ to orouf, aya, sain musei, ã gein isiya nigin kisi afen, anĩ ere, aya age fiya nigin, naab katĩ felef isi, gama enei bun, are aya, Juda sã anidi tunĩ ganan atun, age afen gen, ã atuneg gei ayeĩf nigin age afen. ");
INSERT INTO dad_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Negur aya isennan nigin, aya ĩ bun wareg ado. Anĩ nigin, Aya, tamo Grik od ado dogo neid tobonuneid keleĩ anidi ado, tamo Grik od ado dogo neid tobonuneid keleĩ sã anidi bun, kisi biya adodo, nene yedidiya buneg, wareg enei aũf. ");
INSERT INTO dad_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Age fiya nigin, aya Rom taun ubodõgef ã buneg, biya od anĩ wogõya nigin kisi totol alef. ");
INSERT INTO dad_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Aya biya od nigin to mama fiyaf, ere nigin, are Negur nẽ megeir, tamo ganan momoi def, kel gei fouf nigin, Juda idi bun keteme di, Juda sã anidi idi buneg age fouf. ");
INSERT INTO dad_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ere nigin, biya od bun, Negur ĩ tamo kayau yogon mala bun madur bagai inenẽdiya nẽ naab anĩ kurõ fesif, Negur ĩ tamo kayau yogon mala bun madur bagai inenẽdiya nẽ naab anĩ momoiya bunem dogol isif, are Negur nẽ Itotoya bun ibodok kilei, “Madur tamo momoiya bunem mata ibodõf.” ");
INSERT INTO dad_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Negur nẽ didi, saa ilun tamal, tamo idi dogo neid sanem momoi anĩ lai difedig anidi neid mosor ado sane ganan bun yaoref, ");
INSERT INTO dad_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ere nigin, ereb Negur nigin idi keleĩ youf are, idi bun yaor, ere nigin, Negur ĩ idi bun anĩ yaor fen. ");
INSERT INTO dad_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Negur teneub saa ado kare fen sain bunem isi gamag, Negur nẽ tobonunã ileya kisi feleya sã anĩ, are in ibodkeleya megeir ado ĩ Negur ya anĩ, idi yaor diledig. Ereb Negur inodin anĩ bunem idi keleĩ, anĩ nigin, tamo idi galã taka sã. ");
INSERT INTO dad_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Idi Negur kelein, anĩ ere, idi ĩ Negur gen to yana dales fen, de difiyẽdig, anĩ ere, idi neid kisi nene yel fen, idi neid waud neneya anĩ bunem dogo neid waud gugum kerũ felen. ");
INSERT INTO dad_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Idi amã kisi biya ado dedig, anĩ ere, idi neneya wowã de fen, ");
INSERT INTO dad_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","idi to bura leya Negur nẽ fula fiya medeĩya anĩ falei difel, bura leya nẽ tamo, ninã, gaar ado, gaar luwedim diyõdig imedim meleidkanon dinon anĩ bun dinon. ");
INSERT INTO dad_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Anĩ nigin, Negur idi itornẽdi di, idi neid waud irõya sane dõ de, noli mosor dino amuyẽ bun dile fen, idi neid bouwedim abob mama difenẽdig. ");
INSERT INTO dad_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Idi Negur nẽ momoi anĩ falei difel, idegẽya bun dinon, age de fen, idi Negur ereb ereb kare fen anĩ ban, ereb ereb Negurem kare fen idi yeneid anĩ dales fen, aruneid daledig. Negur ĩ faimud yana yaleseyauf. Momoi. ");
INSERT INTO dad_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Enei nigin, Negur idi mama nẽ oroya bun itornẽdi di, dilen. Idi neid kayaug, Negur bagu fedin geid bouweid bagu fiya ditor ken, falei del, kayau tutur Negur bagu fediya sã anidi geid bouweid bagu difedig. ");
INSERT INTO dad_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Age fiya bagai, tamog Negur kayau ado bagu fedin anĩ ditor ken, idi abob bun noli nigin yã gaĩ de genen. Tamo, tamo tunĩ geid mama tobonunã age dife fen, idi neid idodõya mala darau dogo ke de dalen. ");
INSERT INTO dad_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Idi Negur nigin keleĩ yaleya ditoron, anĩ nigin, Negur idi itornẽdi di, idi neid kisi sanel fen, idi ereb ereb to age fiya nẽ anĩ age difedig. ");
INSERT INTO dad_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Idi tobonunã madur fiya sã fire fire ganan, sane, safina nigin neu dogol yeya ado, to ile oroya anim isokosen. Idi kiyeĩ, tamo yukesiya, kusĩ, idegẽya ado, sanem barikã. Idi dumen od wogõ dedig, ");
INSERT INTO dad_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","idi bou yũya od wogõ dedig, Negur dudum difiyẽdig, idi kono difedig, idi akoreid dũdig, idi dogo yeneid dalesedig. Idi sane age fiya nigin naab dimirẽdig. Idi sineid temeid tar sigoreid to dõ difedig. ");
INSERT INTO dad_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Idi kisi biya sã, momoiya sã, waud laa fiya sã, waud yũya sã. ");
INSERT INTO dad_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Idi Negur nẽ lo keleĩ, are idi anĩ age difef laa gurug difouf, anĩ ere, idi anĩ dogol to age difef diledig, anĩ ere, idi tunĩ anĩ age difedig anidig waud difenẽdidig. ");
INSERT INTO dad_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Anĩ nigin, õ galã taka sã, õ aib taka es wiyẽdig, ereb taka bun es wiyek, õ ogo boũ uk, ere nigin, õ taka es wiyek, õ ogog de ago wodig. ");
INSERT INTO dad_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ada keleĩ, Negur nẽ es fiya idi age difef anidi bun isif, are momoi nẽ bun Negur es fedig. ");
INSERT INTO dad_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Anĩ nigin, tamo õ aib, tunĩ age difef anidi es wiyeĩd fen, õg anĩ ago wodig, õ Negur nẽ es fiya anĩ wal afouf wof de? ");
INSERT INTO dad_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Õ, Negur nẽ biya fiya õ waũ faleiya bun irouyõ isif anĩ to kelei ken, yogon biya fiya, molol ado, feseya sã, idi kisi feleya bagai anĩ, õ kono wof de? ");
INSERT INTO dad_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Anĩ ere, ogon waũ totol ado ogon waũ faleiya sã bunem, õ ogo nigin Negur nẽ didi wõ youf naa bun walouf nigin didi kuru wof, sain anĩ bun Negur nẽ es fiya madur bagai anĩ yaorouf. ");
INSERT INTO dad_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Negur ĩ “mugu mugu ereb age difen kilei ifenẽdiyouf.” ");
INSERT INTO dad_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Idi feseya sã ereb biya age difen bunem, fula fiya medeĩya, yana ado, to bura leya dimirẽdig anidi, mata ibodkeleya ifenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Anĩ ere, idi dogo nigin dogol kisi de fen dimirẽ di, idi momoi anĩ ditor ken, sane dõ difedig anidi bun, didi ado seyeya wõ youf. ");
INSERT INTO dad_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Morõ ado darau, tamo sane age difedig ganan bun wõ youf, Juda idi bun keteme di, haiden idi buneg age fouf. ");
INSERT INTO dad_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Anĩ ere, fula fiya medeĩya, yana ado, wau inosiya, idi biya age difedig ganan bun wõ youf, Juda idi bun keteme di, haiden idi buneg age fouf. ");
INSERT INTO dad_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ere nigin, Negur ĩ Juda ado haiden, es fiya tekelei bunem es fediyouf. ");
INSERT INTO dad_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Idi Moses nẽ lo sa ken, mosor dinof gananeg, Moses nẽ lo sã daũ falauf, idi Moses nẽ lo farumen dibod ken, mosor dinof ganan, Moses nẽ lo nem es fediyouf. ");
INSERT INTO dad_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Negur mala bun, idi lo karĩ dedig anidi madur bagai sã, anĩ ere, idi lo dõ difedig anidi, Negur mala bun madur bagai youf. ");
INSERT INTO dad_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Haiden idi lo sã dogo neid kisim ereb ereb lo irok kilei age difedig, idi lo sã, anĩ ere, idi dogo, dogo nigin lo. ");
INSERT INTO dad_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Idi ereb ereb lo irok anĩ dogo neid waud bun itoton anĩ yaor difef, anĩ nigin, dogo neid kisi es fiya waud bun ibodok animeg, are momoi anĩ, yaor fe di, dogo neid kisim dogo bouweid yu ken, isenneĩd mog fef. ");
INSERT INTO dad_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Neu biya od, Jesus nigin tamo kayau arokenẽdif anĩ irok kilei, Negur Jesus Kristus bunem, tamo nẽ wau bun iminek anĩ es fouf naa bun, enei agef bagai wõ youf. ");
INSERT INTO dad_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Õ ogo nigin aya Juda tamo wof; õ lo bun ufar fen, aya Negur ado nigal mauf wo fen, yanã walesef; ");
INSERT INTO dad_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","õ lom faded yõ di, õ Negur nẽ oroya kelei ken, ereb madur bagai anĩ õ biya wof; ");
INSERT INTO dad_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","õ ogo nigin momoi wof, are õ mala ifofakeleya neid ulum irouya tamo, õ idi gugum bun difaref anidi neid lalan, ");
INSERT INTO dad_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","õ neneya tamo neid tai fiya tamo, õ momou neid tise, ere nigin, õ lo bun keleĩ ado momoi anĩ barikã, ");
INSERT INTO dad_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","age fiyauf are, õ tunĩ ufelnẽdidig, õ ogo to ufelnẽdig de? Õ to bẽ walegei wodig, õ ogo bẽ waledig de? ");
INSERT INTO dad_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Õ to seseirã unoi wodig, õ seseirã unodig de? Õ idegẽya waitou anĩ to bagai oroyõdig, õ dogo neid tempel bun bẽ waledig de? ");
INSERT INTO dad_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Õ aya lo ado wo fen, yanã walesedig, õ lo ifodulũya bunem Negur mama wenẽdig de? ");
INSERT INTO dad_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Are Negur nẽ Itotoya bun ibodok kilei, “Ã bunem, haiden atun Negur yana kono difiyek.” ");
INSERT INTO dad_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Õ lo dõ wof are, mulũ are isennok, anĩ ere, õ lo ufodulõf are, õ mulũ ileya sã gen wõ wof. ");
INSERT INTO dad_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Anĩ nigin, idi mulũ ileya sã anidim lo irok kilei dõ difouf are, idi mulũ ileyan gen to ilediyauf de? ");
INSERT INTO dad_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Taka ĩ mulũ to ile fen, lo dõf el fouf are, ĩ, õ lo itotoya ado fen, mulũ ulen, anĩ ere, õ lo ifodulũya tamo ye fen, to es yõf de? ");
INSERT INTO dad_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Tamo ĩ bouwam dogol Juda tamouf, ĩ Juda tamo bagai sã. Bouwam dogol mulũ ilef, areg mulũ bagai sã. ");
INSERT INTO dad_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Anĩ ere, tamo ĩ name bun Juda tamouf, ĩ Juda tamo bagai. Mulũ bagai are, Awa Uurem, waud bun age fedig, lo itotoya bunem sã. Tamo age fiya, tamo bunem yana yaleseya to yaledig, anĩ ere, Negur bunem yaledig. ");
INSERT INTO dad_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Age fiyauf are, tamo ĩ aya Juda tamo yef bun, ere biya yalouf? Mulũ bun ere biya adouf? ");
INSERT INTO dad_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Naab ganan bun musei! Uruwa bagai, Negur nẽ od idi kulatun difouf nigin imeid bun inon. ");
INSERT INTO dad_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Juda tunĩ momoiya sãf are, naig fouf? Idi neid momoiya sã anim, Negur age fouf yen anĩ to age fouf de? ");
INSERT INTO dad_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","To bagai agef ilauf! Negur ĩ momoi bagai, age fe di, tamo ganan idegẽya temeleid tauf. Are Negur nẽ Itotoya bun ibodok kilei, “Are sain õ wogõ wouf bun, õ madur bagai anĩ yaorouf, sain õ es diyõf bun, õ wal wediyouf nigin.” ");
INSERT INTO dad_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Anĩ ere, ada neda madur bagai sã anim, Negur nẽ madur bagai fatuk bagai yaor fouf are, ada ere tauf? Negur ĩ ada bun yogon didi ifanadauf nigin, ĩ madur sã tauf de? Aya tamo nẽ luwa irouya anĩ wogõ auf. ");
INSERT INTO dad_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","To bagai agef ilauf! Age fiyauf are, Negur tamo kayau naig fe es fediyouf? ");
INSERT INTO dad_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Taka nem monẽ ye fen, irõf, “Neu idegẽya anim Negur nẽ momoi bagai anĩ yaau du fe di, anĩ bunem, yogon fula fiya medeĩya odugouf are, ere nigin aya fau mosor tamal ya ani, bouwau bun inouf?” ");
INSERT INTO dad_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ere nigin to eig youf, “Biya anĩ wõ youf nigin, ada sane age tafouf” youf? Tunĩ amam od enei wogõ maudig de fen, amã bouwamã yũya od dirõdig. Negur idi es feid fen, mala solo ifenẽdiyouf. ");
INSERT INTO dad_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Amã ere mauf? Juda amã haiden wal fediya de? Gai sã bagai! Amã mogo, Juda ado haiden geid ganan mosor farumen kilei kilei dibodok ya anĩ, moron. ");
INSERT INTO dad_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Are Negur nẽ Itotoya bun ibodok kilei, “Madur bagai taka to ibodok, tekelei bagaig sã; ");
INSERT INTO dad_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","taka nem kisi fokõya sã, taka nem Negur imirẽya sã. ");
INSERT INTO dad_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ganan Negur nẽ naab fasis dife fen, ganan sesen len; aibem taka to biya age fedig, tekelei bagaig sã.” ");
INSERT INTO dad_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Idi neid uleidbanĩ, laa nẽ meku awa dede fiya sã gen; idi neid baleid idegẽya wogõ dedig.” “Gogour sane nẽ mũ sigoredin ibodok.” ");
INSERT INTO dad_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Idi neid eweid, isisĩya ado dirikeĩ bagai.” ");
INSERT INTO dad_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Idi neid yeid, tamo didenkesiyouf nigin tuninirya sã kaisã bagai dirãdig; ");
INSERT INTO dad_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","idi neid iyõya bun, daũ fiya ado morõ dinodig, ");
INSERT INTO dad_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","age de fen, wau inosiya nẽ naab idi keleĩ sã.” ");
INSERT INTO dad_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Idi neid meleid bun, idi Negur nigin kumĩ sã.” ");
INSERT INTO dad_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Gama ada keleĩ, ereb lo irok are, idi lo farumen dibodok anidi irokenẽdif, anĩ bunem, eweid ganan omutukul del fen, tenebur tamo kayau ganan Negur nẽ es fiya farumen dibodõf. ");
INSERT INTO dad_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Anĩ nigin, Negur ĩ, lo dõ fiya bunem, ĩ mala bun taka ĩ madur bagai to youf. Age fiya nigin, lom ada mosor tanon anĩ yaor fadadig. ");
INSERT INTO dad_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Anĩ ere, gama Negur ĩ tamo kayau yogon mala bun madur bagai inenẽdiya nẽ naab, are lo bunem sã anĩ yaor fen, are Lo ado profet neid wogõya bun kurõ difesin. ");
INSERT INTO dad_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Negur ĩ tamo kayau yogon mala bun madur bagai inenẽdiya nẽ naab enei, Jesus Kristus nigin momoiya bunem, idi momoi def ganan bun isif. Juda ado haiden bun de tekelei, ");
INSERT INTO dad_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ere nigin, ganan mosor dinon, anĩ nigin, taka nem Negur fula fiya medeĩya bun ibodok ĩ wagen ileya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Age dife di, Negur nẽ wau ifenẽya anim, kel gei fiya Kristus Jesus na yaledin bunem isin anĩ bunem, idi ege bagai madur bagai inodif. ");
INSERT INTO dad_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Negur ĩ, Jesus nẽ naud bun momoiya bunem, Negur nẽ didi yof fen, tamo kayau neid mosor yalelkenẽdiya kabĩ yalouf nigin, Negurem Jesus sesewi fouf nigin inenen. Ĩ yogo madur bagai ya anĩ yaor fiya nigin, enei age fen, ere nigin, in molol bunem, uruwa mosor dinon anĩ mala solo ifenẽdiya sã itornẽdin. ");
INSERT INTO dad_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Sain enei bun, ĩ yogo madur bagai ya anĩ, yaor fiya nigin age fen, are ĩ yogo madur bagai ye fen, taka ĩ Jesus bun momoiya ado ĩ madur bagai youf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Age fiyauf are, yana yaleseya anĩ nain? Yana yaleseya are sã. Ere gariya bunem? Lo dõ fiya bunem de? Sã, momoiya bunem. ");
INSERT INTO dad_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ere nigin, ada keleĩ, Negur ĩ tamo nẽ momoiya bunem madur bagai youf, lo dõ fiya bunem sã. ");
INSERT INTO dad_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Negur ĩ Juda neid dogol de? Ĩ haiden neid sã de? Eo, ĩ haiden nedig Negur. ");
INSERT INTO dad_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Negur ĩ tekelei, ĩ mulũ dilen anidi, momoiya bunem madur bagai youf, agef fen, mulũ ileya sãg, momoiya de tekelei anim madur bagai youf. ");
INSERT INTO dad_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Age fiyauf are, ada momoiya eneim lo anĩ tadodõf de? Sã bagai. Age fiya ban, ada lo tarou kafĩ tafalauf. ");
INSERT INTO dad_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Age fiyauf are, ada Juda tubuda Abraham, ere anĩ ĩ gurug fen nigin, ere tauf? ");
INSERT INTO dad_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abraham yogon kabĩ bunem, madur bagai inenem are, Abraham ĩ yogo yana yaleseya nigin ereb taka adom, anĩ ere, Negur mala bun sã. ");
INSERT INTO dad_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Negur nẽ Itotoya ere ye irok? “Abraham Negur nigin momoi ye di, Negur ĩ Abraham madur bagai yen.” ");
INSERT INTO dad_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Tamo taka ĩ kabĩ yalef, yogon mala solo are ege luwa ifenẽya gen sã, are kabĩ mala. ");
INSERT INTO dad_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Anĩ ere, tamo ĩ madur bagai wõ youf nigin kabĩ to yale fen, Negur, ĩ dõ fiya sã anidi madur fedidig, ĩ nigin momoi yef, Negur yogon momoiya are madur bagai yef. ");
INSERT INTO dad_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dawid ĩg, tamo kabĩ bunem sã, Negur madur bagai yen, tamo anĩ nẽ el fiya nigin wogõ yen: ");
INSERT INTO dad_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Idi neid kũ fenẽya nigin weder tu keledig, idi neid mosor yaleledig, are el fedif. ");
INSERT INTO dad_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Tamo ĩ yogon mosor nigin Odug to bagai iwesnẽf, ĩ el fiyek.” ");
INSERT INTO dad_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","El fiya enei mulũ ileya neid dogol de? Sã, are mulũ ileya san neideg. Age fiya nigin, amã morõdig, Negur Abraham nẽ momoiya bunem ĩ madur bagai yen. ");
INSERT INTO dad_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ere sain bun Negur ĩ age yen? Ĩ mulũ ilel mog de, mulũ ileya sã mog? Ĩ mulũ ilel mog sã, ĩ mulũ ileya sã mog. ");
INSERT INTO dad_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ĩ mulũ ileya nẽ uris, are ĩ fau mulũ ileya sã mog, momoiya bunem Negur madur bagai yen anĩ nẽ uris yalen. Anĩ nigin, ĩ mulũ ileya san momoi def ganan neid temeid, anĩ bunem, Negur idi madur bagai youf. ");
INSERT INTO dad_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ĩ mulũ ileya nedig temeid, idi mulũ dilen dogol sã, anĩ ere, idi tubuda Abraham ĩ mulũ ileya sã mog, momoiya ado iyon anĩ yebura dõ de diyõdig anidi nedig. ");
INSERT INTO dad_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Negur, Abraham ado in tubu tar irokenẽdin, are Negurem ereb ereb ganan idi afenẽdi di, akorediyouf yen anĩ, lo bunem sã, anĩ ere, madur bagai momoiya bunem isif anĩ bunem. ");
INSERT INTO dad_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Idi lo dõ difedig anidim, Negurem ereb ereb ganan idi afenẽdi di, akorediyouf yen anĩ akorediyouf are, momoiya are ege ile di, ereb Negur iron are ege kilẽf, ");
INSERT INTO dad_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","are lo didi irou isidig nigin. Lo sãf are, lo ifodulũyag sã. ");
INSERT INTO dad_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Anĩ nigin, ereb Negur age afouf yen are, wau ifenẽya bunem, kabĩ yalef ya anĩ yaorouf nigin, momoiya bunem isidig, are Negur ĩ, ege luwa Abraham nẽ ibor nẽ tubu tar ganan afenẽdiyouf yen anĩ, megeir fiya nigin age fedig, idi lo dõ difedig anidi bun dogol sã, anĩ ere, idi Abraham nẽ momoiya dõ difedig anidi buneg. Age fiya nigin, Abraham ĩ, ada ganan neda tamada. ");
INSERT INTO dad_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Are Negur nẽ Itotoya bun ibodok kilei, “Aya õ teneub akor musei neid temeid anenon.” Negur mala bun, ĩ neda tamada, Abraham Negur nigin momoi yen, Negur ĩ tamo gare den mata ifeneĩd fen, ereb to ibodok anĩ iweig di, agef wõ yedig, Negur ĩ anĩ. ");
INSERT INTO dad_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Wau iseya nigin gariya taka sã bun, Abraham in wau iseya bun momoi yen, are ĩ teneub akor musei neid temeid wõ youf nigin age fen, are Negur ĩ eig ye irokenen kilei, “Ogon ibor agef yenẽf.” ");
INSERT INTO dad_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","In momoiya bun felu reya sã, ĩ handred yar age fiya ibodon nigin, yogon bouwa anĩ laa gen ile fen, Sara kesu yaleya nigineg laa gen ilen. ");
INSERT INTO dad_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Anĩ ere, ereb ĩ Negur iron anĩ nigin to wau uru fen, in momoiya to ilef isi fen, anĩ ere, ĩ yogon momoiya megeir fe fen, Negur fula fiya medeĩya ifenen. ");
INSERT INTO dad_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Abraham ĩ, ereb Negur age afouf yen anĩ age fiya nigin, ĩ megeir ado, ye fen, momoi bagai yen. ");
INSERT INTO dad_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Anĩ nigin, Negur, Abraham nigin ĩ madur bagai yen. ");
INSERT INTO dad_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Od “Negur ĩ nigin madur bagai yen” are, ĩ nigin dogol to itoton, ");
INSERT INTO dad_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","anĩ ere, Negur ada nigin madur bagai youf anĩ nigineg itoton, are ada, Negur, neda Odug Jesus tamo gare den bun tamal kel turĩ fiyen nigin, momoi tauf anĩ. ");
INSERT INTO dad_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Negur ĩ Jesus neda mosor nigin laa bun inene ken, ada madur bagai youf nigin, Jesus mata kel turĩ fiyen. ");
INSERT INTO dad_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Anĩ nigin, momoiya bunem, Negur ada madur bagai yen nigin, ada neda Odug Jesus Kristus bunem, Negur ado maror bun tabodok. ");
INSERT INTO dad_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Neda momoiya bunem, Jesus Kristus ĩ, ada Negur nẽ wau ifenẽya enei ada gama an tafaref anĩ namen irou ileda di, telen. Anĩ nigin, ada Negur nẽ fula fiya medeĩya nigin, wauda ise fen, kulĩ taudig. ");
INSERT INTO dad_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Anĩ nigin dogol sã, ada neda morõ nigineg kulĩ taudig, ere nigin, ada keleĩ, morõ bunem feseya sã anĩ wõ yedig, ");
INSERT INTO dad_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","feseya sã anĩ bunem atĩya biya wõ yedig, atĩya biya bunem wau iseya wõ yedig. ");
INSERT INTO dad_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Wau iseya anim ada to fõ fadadig, ere nigin, Awa Uur Fateul Negurem ifanadan anĩ bunem, in wau laa fiya ada wauda bun fi felen. ");
INSERT INTO dad_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ada fau maleg tabod mog, in sain bun bagai, Kristus ĩ, ada Negur dõ fiya sã anidi nigin laa fen. ");
INSERT INTO dad_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Tamo takam, taka madur bagai nigin, laa fiya malai bagai, agef fen, tamo takam aib taka tobonunã biya ado nigin totol ino fen, laa fouf be. ");
INSERT INTO dad_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Anĩ ere, Negur ada nigin yogon wau laa fiya anĩ, enei bun ada ifelnadaf, are ada fau mosor bun tabod mog, Kristus ada nigin laa fen. ");
INSERT INTO dad_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Gama yogon naud bunem, Negur ada madur bagai yen nigin, ada ĩ bunem Negur nẽ didi bun tamal baban momoi bagai yalelkanadauf! ");
INSERT INTO dad_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Sain ada Negur nẽ kiwai tamo tar tabod mog, yogon Naal nẽ laa bunem, ada ĩ geid komo fadan. Gama ada ĩ geid komo fadan nigin, baban momoi bagai, Kristus nẽ mata bunem ada kel gei fadauf! ");
INSERT INTO dad_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Enei dogol sã, anĩ ere, ada, ereb Negur neda Odug Jesus Kristus bunem age fen nigineg kulĩ taudig, are Jesus Kristus bunem, ada gama komo fiya talen. ");
INSERT INTO dad_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Anĩ nigin, tamo tekelei bunem, mosor ket tenebur wõ ye di, laa mosor bunem wõ yen, age fiya bagai, ganan mosor dinon nigin, laa, tamo ganan bun wõ yen. ");
INSERT INTO dad_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Lo wõya sã mog, mosor tenebur ibodon. Anĩ ere, lo sãf are, mosor to iwesauf. ");
INSERT INTO dad_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Anĩ ere, Adam nẽ sain bunem ile Moses nẽ sain bun, idi Adam age fen gen, to Negur nẽ ĩtãfiya wal difen anidig laa farumen dibodon, Adam ĩ taka fau isiyouf nẽ malakanon. ");
INSERT INTO dad_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Anĩ ere, Negur nẽ ege luwa are mosor Adam inon gen sã. Tamo tekelei nẽ mosor bunem musei gare den ouf are, Negur nẽ wau ifenẽya ado ege luwa, tamo tekelei Jesus Kristus nẽ wau ifenẽya bunem isin, naig fiya bagai tamo musei bun gogũ fouf! ");
INSERT INTO dad_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Takag age fiya, Negur nẽ ege luwa are, tamo tekelei nẽ mosor mala age fiya sã. Es fiya mosor tekelei dõf fen, mosor inon nigin bouwa bun od yũya irou isin, anĩ ere, ege luwa mosor musei dõf fen, madur bagai anĩ irou isin. ");
INSERT INTO dad_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Tamo tekelei nẽ mosor bunem, laa anĩ, tamo tekelei anĩ bunem mudur ibodon ouf are, idi Negur bunem, wau ifenẽya barikã ado, madur bagai anĩ nẽ ege luwa barikã dalef anidi, momoi bagai, tamo tekelei Jesus Kristus bunem, mata bun mudur dibodõf! ");
INSERT INTO dad_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Anĩ nigin, mosor tekelei bunem, Negur tamo ganan mosor temeleid yen, age fiya gen, madur bagai tekelei age fen bunem, Negur tamo nigin madur bagai ye fen, tamo ganan nigin mata irou isin. ");
INSERT INTO dad_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Tamo tekelei nẽ od wal fiya bunem, musei mosor adodo wowã den, age fiya gen, tamo tekelei nẽ dõ fiya bunem, musei madur bagai wowã douf. ");
INSERT INTO dad_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Mosor ifageya nigin, lo isin. Anĩ ere, mosor ifaga di, Negur nẽ wau ifenẽya fatuk bagai ifagan, ");
INSERT INTO dad_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","are mosor laa bun mudur ibodon gen, wau ifenẽya madur bagai bunem mudur ibod ken, neda Odug Jesus Kristus bunem mata ibodkeleya irou isiyouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Age fiyauf are, ada ere tauf? Negur nẽ wau ifenẽya ifagauf nigin, ada mosorei tauf de? ");
INSERT INTO dad_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Sã bagai! Ada mosor bun gare taun; naig fe di, ada anĩ bun tau tabodõf? ");
INSERT INTO dad_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ada ganan Kristus Jesus bun naan talen, are yogon laa bun naan talen anĩ, ã to keleĩ de? ");
INSERT INTO dad_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Anĩ nigin, ada, laa bun naan talen bunem, ĩ geid mũ fadan, are Kristus, Tama nẽ fula fiya medeĩya nẽ megeir bunem, tamo gare den bun tamal kel turĩ fen gen, adag ibodõya mata bun mata tabodõf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ada yogon laa bun, enei gen ĩ geid bagu fadan ouf are, ada momoi bagai yogon kel fãya buneg, ĩ geid bagu fadauf. ");
INSERT INTO dad_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ada keleĩ, mosor nẽ bouwada yukesiyouf nigin, neda oroya tubu ĩ geid aa tetek bun yun, are ada mosor nẽ ferfer to tabodõf nigin age fen, ");
INSERT INTO dad_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ere nigin, taka ĩ laa fen are, ĩ mosor nẽ megeir bun tamal yalelnen. ");
INSERT INTO dad_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ada Kristus geid gare taun ouf are, adag ĩ geid mata tabodõf nigin momoi tauf. ");
INSERT INTO dad_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ere nigin, ada keleĩ, Kristus tamo gare den bun tamal, kel turĩ fiyen nigin, ĩ baban to bagai laa fouf, ĩ laa nẽ megeirem baban to irounẽf. ");
INSERT INTO dad_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ĩ laa fen are, ĩ mosor nẽ megeir yukesiyouf nigin, sain tekelei bun dogol laa fen, anĩ ere, mata ĩ ibodok are, ĩ Negur bun mata ibodok. ");
INSERT INTO dad_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Age fiya bagai, ã aug nigin, mosor bun gareg fen, Kristus Jesus bunem, Negur bun mata ubodõgef anĩ kisi gouf. ");
INSERT INTO dad_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Anĩ nigin, ãgenei bouweĩ bura leya nẽ anĩ bun, mosor mudur ibodõ di, ã in oroya sane anĩ dõ gouf nigin to ago gouf. ");
INSERT INTO dad_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ãgenei bouweĩ tunĩ, sane nẽ aruna yaleya nigin mosor bun to wenẽgouf, anĩ ere, idi laa bun tamal kel turĩ fedin gen, ã aug Negur wenẽg fen, ãgenei bouweĩ tunĩ, madur bagai nẽ aruna yaleya nigin Negur bun wenẽgouf. ");
INSERT INTO dad_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Mosor ãgenei odug to ibodõf, ere nigin, ã lo farumen sã, wau ifenẽya farumen ubodõgef. ");
INSERT INTO dad_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Age fiyauf are, naig fiya? Ada lo farumen sã, wau ifenẽya farumen tabodok nigin, mosor tanouf de? Gai sã bagai! ");
INSERT INTO dad_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Sain ã aug, taka sigor dõg fen, ferfer gen ĩ aruna walegef, ã taka sigor dõ gef anĩ nẽ ferfer ubodõgef anĩ, ã to keleĩ de? Ã mosor nẽ ferfer ubodõgef, are laa bun irouleyeik, ã Negur dõ fiya nẽ ferfer ubodõgef, are madur bagai bun irouleyeik. ");
INSERT INTO dad_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Anĩ ere, ada Negur de tafiyẽf, ere nigin, ã uruwa bun mosor nẽ ferfer ubodõgen, anĩ ere, ã tai fiya difenein anĩ, ãgenei wauĩ adok dõ gen. ");
INSERT INTO dad_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ã mosor bun tamal yalelneĩ di, madur bagai nẽ ferfer wõ gen. ");
INSERT INTO dad_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Aya, ã bouweĩ bun felu reya nigin, tamo nẽ tobonunã bunem wogõ auf. Ã uruwa bun ferfer gen, ãgenei bouweĩ, sane amuyẽ ado bun unogen, ago ge di, fatuk bagai sane len, age fiya gen, gama ã ferfer gen, ãgenei bouweĩ, madur bagai bun unoge di, fateul bagai wõ gouf. ");
INSERT INTO dad_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Sain ã mosor nẽ ferfer ubodõgen, ã madur bagai nẽ farumen to ubodõgen. ");
INSERT INTO dad_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Sain anĩ bun, ereb ã gama mama yeik bun tamal, ã ere mala biya walegen? Anĩ ganan are, laa bun irou isif. ");
INSERT INTO dad_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Anĩ ere, ã gama mosor bun tamal yalelneĩ di, Negur nẽ ferfer wõ gen, anĩ nẽ mala biya are, fateul bun irouleyeik, anĩ nẽ kaũ are, mata faimud ibodkeleya. ");
INSERT INTO dad_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ere nigin, mosor mala, are laa, anĩ ere, Negur nẽ ege luwa, are neda Odug Kristus Jesus bun mata faimud ibodkeleya. ");
INSERT INTO dad_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Turau tar, aya, Moses nẽ lo keleĩ tamo ã arokeneik, lo are tamo mata ibodok sain bun dogol, ĩ bun megeir ado anĩ, ã to keleĩ de? ");
INSERT INTO dad_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Eig fiya gen, lo irok, kayau tamo aiwaf, ĩ tamo mata ibodok sain bun dogol ĩ aiwaf, anĩ ere, ĩ aiwa laa fouf are, kayau ĩ bagu fiya nẽ lo farumen to ibodõf. ");
INSERT INTO dad_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Age fiya nigin, kayau ĩ aiwa monog fau mata ibod mog, ĩ baban tamo taka yalouf are, ĩ seseirã kayau douf. Anĩ ere, yogon tamo laa fouf are, lo anim kayau to irounẽ di, ĩ tamo taka yaloufeg, ĩ to seseirã kayau douf. ");
INSERT INTO dad_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Anĩ nigin, neu turau tar, ãg Kristus bouwa bunem lo bun gare gen, are ã, taka ĩ tamo gare den bun tamal kel turĩ fiyen anĩ nẽ wowãg fen, ada Negur bun faat biya taũf nigin ago gen. ");
INSERT INTO dad_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Sain ada bouwa nẽ oroyam irounadan bun, lo anim mosor nẽ oroya turĩ fe di, mosor nẽ oroya anim bouwada bun kabĩ yalen, anĩ bun, ada laa nẽ faat taun. ");
INSERT INTO dad_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Anĩ ere, gama ada ereb mogo irounadan bun gare taun nigin, ada lo bun tamal yalelnadan, anĩ nigin, ada Awa Uur nẽ naab mata bun aruna talef, naab tubu lo itotoya bun sã. ");
INSERT INTO dad_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Age fiyauf are, ada ere tauf? Lo anĩ mosor de? Sã bagai! Momoi, lo sam are, aya mosor are ereb yef anĩ to keleim. Ere nigin, taka nẽ safina ile to oroya nigin lo to age ye irom are, aya taka nẽ safina ile to oroya nigin to keleim. ");
INSERT INTO dad_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Anĩ ere, ĩtãfiya anim mosor modoũ ifenẽ di, aya nameun mosorem taka nẽ safina ile oroya fire fire ganan inodin. Ere nigin, lo sãf are, mosor are laa fen. ");
INSERT INTO dad_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Uruwa aya lo sã bun mata abodon, anĩ ere, ĩtãfiya isi di, mosor mata fã ye di, ");
INSERT INTO dad_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","aya laa fiyan. Lo anĩ mata irousiyouf aun, anĩ ere, ĩ momoi bagai laa irousin anĩ ailen. ");
INSERT INTO dad_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ere nigin, ĩtãfiya anim mosor modoũ ifenẽ di, mosorem aya idegna fen, ĩtãfiya bunem laa bun inenan. ");
INSERT INTO dad_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Age fiyauf are, lo are fateul, ĩtãfiya are fateul, madur fen, biya. ");
INSERT INTO dad_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Age fouf are, ereb biya anim aya bun laa irousin de? Sã bagai! Anĩ ere, mosor are mosor ya anĩ yaorouf nigin, mosorem ereb biya bunem aya bun laa irousin, are mosor ĩtãfiya bunem mosor bagai wõ youf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ada keleĩ, lo are Negur bun tamal, anĩ ere, aya bouwa buru nẽ, mosor nẽ ferfer gen na nẽ sur fiyan. ");
INSERT INTO dad_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ereb aya age afef, are aya keleĩ sã. Ere nigin, ereb aya age fiya nigin orouf, are aya to age afedig, anĩ ere, ereb aya to orouf anĩ, aya age afedig. ");
INSERT INTO dad_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ereb aya age fiya nigin to orouf anĩ, aya age afouf are, aya lo are biya auf anĩ ifelnadaf. ");
INSERT INTO dad_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Anĩ nigin, aya yug anĩ to age afef, anĩ ere, mosor aya nameun ibodok anim age fef. ");
INSERT INTO dad_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Aya keleĩ, ereb biya taka, aya nameun, are mosor nẽ bouwau enei bun to ibodok. Ere nigin, aya ereb biya age fiya nigin orouf, anĩ ere, aya age fiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ere nigin, ereb aya age afef, are ereb biya age fiya nigin orouf anĩ sã, anĩ ere, ereb sane aya age fiya nigin to orouf anĩ, aya faimud age afedig. ");
INSERT INTO dad_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Aya ereb to orouf anĩ age afouf are, ayam anĩ to age afef, anĩ ere, mosor aya nameun ibodok anim age fef. ");
INSERT INTO dad_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Anĩ nigin, aya tobonunã eig fiya kabĩ yale mog, ailef: Sain aya biya age afou fenẽ di, sane anĩ aya ado ibodõdig. ");
INSERT INTO dad_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ere nigin, aya nameun Negur nẽ lo nigin wau kulĩ yedig, ");
INSERT INTO dad_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","anĩ ere, aya lo taka anĩ bouwau tunĩ bun kabĩ yale mog, ailef, are neu kisi biya nẽ lo ado kusĩ de fen, aya, mosor, bouwau tunĩ bun kabĩ yalef anĩ nẽ lo nẽ kalabus tamo inenadig. ");
INSERT INTO dad_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","O aya malaulon bagai! Aim anĩ aya laa nẽ bouwau enei bun tamal yalelnauf? ");
INSERT INTO dad_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Neda Odug Jesus Kristus age fen bunem Negur ada yalelnadan nigin ĩ de tafiyẽf! Age fiyauf are, aya yug neu kisi bun are, Negur nẽ lo nẽ ferfer, anĩ ere, aya mosor nẽ bouwau enei bun, mosor nẽ lo nẽ ferfer. ");
INSERT INTO dad_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Anĩ nigin, idi Kristus Jesus bun dibodok anidi bun, mosor dinon nigin bou yũya taka gama to ibodok, ");
INSERT INTO dad_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ere nigin, Kristus Jesus bunem, mata nẽ Awa Uur nẽ lo anim, mosor ado laa nẽ lo bun tamal yalelnan. ");
INSERT INTO dad_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mosor nẽ bouwa felu reya nigin, lo anim age fiya nigin kisi feleya sã anĩ Negur age fen, are ĩ yogon Naal, mosor tamo nẽ bouwa gen bun, mosor yaleleya nẽ sesewi fiya ibodõf nigin sur fiyen anĩ bunem, Negur ĩ, mosor, mosor tamo nẽ bouwa bun ibodok anĩ nẽ megeir yukesin, ");
INSERT INTO dad_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","are madur bagai wõ youf nigin lo irok anĩ, bouwa nẽ oroya tator ken, Awa Uur nẽ oroya bun tabodõdig ada bun, kisi falauf nigin, Negur ĩ age fen. ");
INSERT INTO dad_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Idi bouwa nẽ oroya bun dibodõdig anidi, dogo neid kisi are, ereb mosor nẽ bouwa orof anĩ bun yenẽdig, anĩ ere, idi Awa Uur nẽ oroya bun dibodõdig anidi, dogo neid kisi are, ereb Awa Uur orof anĩ bun yenẽdig. ");
INSERT INTO dad_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kisi mosor nẽ bouwa bun yenẽdig, are laa nẽ, anĩ ere, kisi Awa Uur bun yenẽdig, are mata nẽ ado wau inosiya nẽ, ");
INSERT INTO dad_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ere nigin, kisi mosor nẽ bouwa bun inodig, are Negur kiwai ifenẽdig, are Negur nẽ lo farumen to ibodõdig, ĩ age fiya nigineg kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Idi mosor nẽ bouwa bun dibodõdig anidi, Negur wau al fiya ifenẽya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Anĩ ere, Negur nẽ Awa Uur ã namein ibodõf are, ã mosor nẽ bouwam to ulum iroukeneĩf, anĩ ere, ã Awa Uurem ulum iroukeneĩf. Anĩ ere, taka ĩ Kristus nẽ Awa Uur sãf are, ĩ Kristus nẽ sã. ");
INSERT INTO dad_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Anĩ ere, Kristus ã namein ibodõf are, ãgenei bouweĩ mosor nigin laa foufeg, ãgenei uur madur bagai nigin mata ibodok. ");
INSERT INTO dad_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ĩ Jesus tamo gare den bun tamal, kel turĩ fiyen anĩ nẽ Awa Uur, ã namein ibodõf are, ĩ Kristus tamo gare den bun tamal, kel turĩ fiyen, yogon Awa Uur ã namein ibodok anĩ bunem, ãgenei bura leya nẽ bouweĩ matag ifeneĩf. ");
INSERT INTO dad_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Anĩ nigin, turau tar, ada wareg ado, are ada mosor nẽ bouwa to dõ tafouf, bouwa nẽ oroya bun to tabodõf. ");
INSERT INTO dad_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ã bouwa nẽ oroya bun ubodõgouf are, ã gare gouf, anĩ ere, Awa Uur bunem ã bouwa nẽ tobonunã anĩ ukesigouf are, ã mata ubodõgouf, ");
INSERT INTO dad_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ere nigin, idi Negur nẽ Awa Uurem uyu iroukenẽdif are, idi Negur nẽ gere tar. ");
INSERT INTO dad_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ã kumĩya nẽ ferfer ineneĩya nẽ uur to walegen, anĩ ere, ã Negur nẽ gere tar ineneĩya nẽ Awa Uur walegen. Anĩ nigin, ĩ bunem ada taweig fen, “Aba, Dei” taudig. ");
INSERT INTO dad_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Awa Uur yogo, ada neda uur bun kurõ falaisi, ada Negur nẽ gere tar yedig. ");
INSERT INTO dad_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ada in gere tar ouf are, ada ereb el fiya biya Negur ifanadauf nigin promis od iron anĩ talouf. Ada Kristus geid weim yogon fula fiya medeĩyag talouf nigin ada momoi bagai ĩ geid weim yogon darau talouf are, ada Kristus geid weim ereb el fiya biya Negur ifanadauf nigin promis od iron anĩ talouf. ");
INSERT INTO dad_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Aya kisi afef, fula fiya medeĩya ada bun yaorouf, are ada neda darau gama talef anĩ wal fiya bagai. ");
INSERT INTO dad_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ereb ereb ganan Negur inodin are, Negur yogo gere tar yaor fediyouf nigin, fatuk bagai tari difedig. ");
INSERT INTO dad_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ere nigin, ereb ereb ganan Negur inodin are, Negur uruwa idi yogon oroya dõ difouf nigin kisi fen anĩ idi to dõ difedig, are dogo neid oroya bunem sã, anĩ ere, ĩ agef inodin anĩ nẽ oroya bunem. Anĩ ere, waud iseya ado, ");
INSERT INTO dad_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","are ereb ereb ganan Negur inodin, idig dogo bura leya nẽ kafĩ fiya bun tamal yalelneĩd fen, Negur nẽ gere tar neid fula fiya medeĩya nẽ karika ibodõya bun gurif iroulediyouf. ");
INSERT INTO dad_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ada keleĩ, ereb ereb ganan Negur inodin, idi kesu gõ fiya nẽ darau bun gen, gariya bunem osi def disi, gama sain enei bun bagaig, age difef. ");
INSERT INTO dad_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Anĩ dogol sã, anĩ ere, ada, Awa Uur, are dumen fula fiya medeĩya ada talouf nẽ faat uyulil yũya anĩ talen, ada dugeg, Negur ada bouwada kel geif fen, ada yogon gere tar bagai ya anĩ yaor fe kurõ falaisiyouf nigin, fatuk bagai tari tafe fen, namedan osi taudig. ");
INSERT INTO dad_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ada kel gei fadan sain bun, ada wauda iseya enei talen. Anĩ ere, wau iseya malam ileya are, wau iseya bagai sã. Aim anĩ, ereb ĩ mogo ilef nigin wau isauf? ");
INSERT INTO dad_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Anĩ ere, ada ereb ada fau ileya sã nigin wauda isauf are, ada totol tano fen, tari tafouf. ");
INSERT INTO dad_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Age fiya gen, Awa Uur ĩ neda felu reya bun isennadadig. Ada ereb nigin kosẽ tauf anĩ ada keleĩ sã, anĩ ere, Awa Uur yogo od faded fiya kisi feleya sã anĩ, osi ye fen, ada nigin kosẽ yedig. ");
INSERT INTO dad_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Age fe di, Negur ada wauda fele fedig, ĩ Awa Uur nẽ kisi keleĩ, ere nigin, Awa Uur ĩ tamo kayau fateul nigin Negur nẽ oroya kilei kosẽ yedig. ");
INSERT INTO dad_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ada keleĩ, ereb ereb ganan bun, Negur yogo nigin waud laa fedig anidi neid biya fiya nigin Negur kabĩ yaledig, idi yogon oroya kilei iweignẽdin anidi. ");
INSERT INTO dad_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Idi Negurem mogo kelein anidi, Negur idi yogo Naal gen wowã douf nigineg mogo igirnẽdin, are yogon Naal, tura tar musei atun, kesu matu wõ youf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Agef fen, idi Negur igirnẽdin anidig, ĩ iweignẽdin, idi Negur iweignẽdin anidig, ĩ madur bagai fiyẽdin, idi Negur madur bagai fiyẽdin anidig, ĩ fula fiya medeĩya ifenẽdin. ");
INSERT INTO dad_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Age fiyauf are, ada enei nigin ere tauf? Negur ĩ nedauf are, aim anĩ ada daũ fadaya kisi feleya? ");
INSERT INTO dad_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ĩ yogo Naal bagai nigin to katũ ye fen, ada ganan nigin yogo Naal itornen anĩ, naig fe di, ĩ yogo Naal ado ereb ereb gananeg, ege kilẽ to ifanadauf? ");
INSERT INTO dad_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Aim anĩ, Negur igirnẽdin anidi kot bun inenẽdiyouf? Negur yogo idi madur bagai fiyẽdidig. ");
INSERT INTO dad_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Aim anĩ, idi mosor dinon ye fen, idi bouweid bun od yũf? Kristus Jesus ĩ mogo laa fen, agef feneg, ĩ kel turĩ fe di, matan, ĩ Negur ima biyalẽ ibod ken, ada nigineg kosẽ yedig. ");
INSERT INTO dad_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Aim anĩ, ada Kristus nẽ wau laa fiya bun tamal fara fadauf? Kafĩ fiya, morõ, darau, naũ, gemũ, waila be, dimigem age fouf de? ");
INSERT INTO dad_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Are Negur nẽ Itotoya bun ibodok kilei, “Õ nigin amã naa tekelei adok laa gurug mafef; amã sipsip didenkesiya nigin age fiya gen dileman.” ");
INSERT INTO dad_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Anĩ ere, enei ganan bun, ada, ĩ ada nigin wau laa fen bunem, ada kusĩ wal difen anidi wal fediya tabodok. ");
INSERT INTO dad_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Aya momoi auf, laa, mata, engel, kaa sesen, ereb gama nẽ, ereb dumen nẽ, ereb megeir taka, ");
INSERT INTO dad_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ilun, kuren bagai be, ereb ereb ganan inodin bun ereb takam, Negur nẽ wau laa fiya, neda Odug Kristus Jesus bun ibodok anĩ bun tamal, ada fara fadaya nigin kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Aya Kristus bun momoi orok, aya idegẽya sã, neu kisi es fiya wau bun ibodok, Awa Uur Fateul bunem, aya bun anĩ megeir fef, ");
INSERT INTO dad_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","are aya fatuk bagai wau gudũf fen, aya faimud wau bun morõ ado. ");
INSERT INTO dad_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ere nigin, aya, neu turau tar, neu ibor anidi nigin, aya yug isisna fen, Kristus bun tamal yalelnauf anĩg, aya orouf. ");
INSERT INTO dad_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Idi Israel tamo kayau. Negur nẽ gere tar ya anĩ dogo neid, Negur nẽ fula fiya medeĩya anĩ, idi bun yaor fen, Negur ado bar itenẽya, lo yaleya, tempel bun Negur yana yaleseya ado, ereb Negur age afouf ye fen igirin, are dogo neid. ");
INSERT INTO dad_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Tubuid tar Abraham, Isak, Jakop are dogo neid, idi neid ibor anĩ isi isi Kristus wõ yen, Kristus ĩ Negur, ganan ĩ farumen dibodok, faimud ĩ yana talesauf! Momoi. ");
INSERT INTO dad_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Are Negur nẽ od irofosiya gen sã. Ere nigin, Israel ibor bun wõ den anĩ, ganan Israel sã. ");
INSERT INTO dad_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Idi Abraham nẽ ibor nẽ tubu tar ba, anĩ ere, ganan Abraham nẽ gere tar bagai sã. Age fiya ban, “Isak bunem, ogon ibor tar douf.” ");
INSERT INTO dad_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Are, tamo nẽ tobonunã nẽ naud bunem Abraham nẽ gere tar wowã den anidi ganan, Negur nẽ gere tar sã, anĩ ere, promis nẽ gere tar idi, Abraham nẽ ibor tar youf. ");
INSERT INTO dad_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Negur nẽ promis od anĩ eig fiya, “Yogon sain bun bagai, aya kelauf, Sara kesu adouf.” ");
INSERT INTO dad_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Anĩ dogol sã, anĩ ere, Rebeka nẽ gere tar tama tekelei ado, are tubuda Isak. ");
INSERT INTO dad_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Anĩ ere, kesu uru fau gõ fiya sã bun, ereb biya be sane be age fiya sã mog, Negur nẽ oroya anĩ, kabĩ bunem sã, iweignẽdif ĩ bunem, yogon igirĩya bun ifarauf nigin, ");
INSERT INTO dad_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ĩ Rebeka irokenen, “Matu anĩ, ibuye nẽ aruna yaleyẽf.” ");
INSERT INTO dad_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Are Negur nẽ Itotoya bun ibodok kilei, “Aya Jakop nigin wau laa fen, anĩ ere, Esau to oroun.” ");
INSERT INTO dad_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Age fiyauf are, ada ere tauf? Negur madur sã de? Sã bagai! ");
INSERT INTO dad_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ere nigin, Negur Moses irokenen, “Aya aib nigin wau yuk anĩ bun, wau yũya afenẽf, aya aib nigin wau irok, ĩ nigin wau yenẽf.” ");
INSERT INTO dad_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Anĩ nigin, are, tamo nẽ oroya be kabĩ totol yaleya bunem sã, Negur nẽ wau yũya bunem. ");
INSERT INTO dad_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Negur nẽ Itotoya bun, Isip nẽ king Farao nigin eig ye irok, “Aya õ enei nigin bagai king anenon, are aya õ bun neu megeir yaor afe di, teneub ganan bun, neu yanau kurõ difalaisiyouf nigin age afen.” ");
INSERT INTO dad_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Anĩ nigin, Negur aib ĩ wau yũya ifenẽya nigin orof bun, ĩ wau yũya ifenẽdig, agef fen, ĩ aib nẽ wau katĩ feleya nigin orof bun, ĩ katĩ feledig. ");
INSERT INTO dad_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ã takam aya irokanauf, “Age fiyauf are, ere nigin Negur fau ada bouwada bun od yuk? Aim anĩ yogon oroya katĩ felef?” ");
INSERT INTO dad_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Anĩ ere, tamo õ ai anĩ Negur od solo urokenẽf? “Ereb kare fen anim ĩ kare fen anĩ, ‘Ere nigin eig wo unoyan?’ fiyẽf de?” ");
INSERT INTO dad_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mis inoya tamo ĩ mafer de tekelei anim, mis uru, taka kabĩ biya ifenẽya nẽ, taka kabĩ sane ifenẽya nẽ, yogon oroyam inoya kisi feleya sã de? ");
INSERT INTO dad_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Negur ĩ yogon didi anĩ yaor fe di, yogon megeir anĩ tamo kayau keleĩ youf nigin wau iro ken, yogon didi idi bun ile, daũ feidlauf anidi nigin molol bunem loloum fedi di, sain meluk ibodon ouf are, ada ere tauf? ");
INSERT INTO dad_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Negur ĩ idi fula fiya medeĩya dalouf nigin dodok fe fen, yogon wau yũya ifenẽdiyouf anidi bun, yogon fula fiya medeĩya barikã anĩ yaor fiya nigineg wau iron ouf are, ada ere tauf? ");
INSERT INTO dad_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ada buneg Negur iweignadan, Juda temeleid dogol sã, haiden buneg. ");
INSERT INTO dad_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Are Hosia nẽ itotoya buneg Negur wogõ yef kilei, “Aya idi neu tamo kayau sã anidi, neu tamo kayau auf, age afe fen, aya neu oboiyou sã anĩ, neu oboiyou auf,” ");
INSERT INTO dad_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","takag, “Negur ‘Ã neu tamo kayau sã’ yen nẽ modoũ anĩ bun, idi anĩ ‘Negur mata ibodõya nẽ gere tar’ youf.” ");
INSERT INTO dad_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Asaia Israel nigin iweig iron, “Israel tamo kayau maaĩ ubun mumul gen musei bagai, anĩ ere, musei sã dogol kel gei fediyouf. ");
INSERT INTO dad_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ere nigin, Odug ĩ teneub bun, yogon tamo kayau es fediyouf nẽ od ganan kaisã bagai dõf agef kisi falauf.” ");
INSERT INTO dad_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Are Asaia mogo iron kilei, “Odug saa ilun nẽ kusĩ tamo guri feid uyu iroudig anĩ, neda ibor nẽ tubu tar tunĩ to itornẽdim are, ada Sodom gen wõ taum, ada Gomora gen tabodom.” ");
INSERT INTO dad_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Anĩ nigin, ada ere tauf? Haiden idi madur bagai anĩ to dimiren anidi, momoiya bunem madur bagai anĩ dalen. ");
INSERT INTO dad_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Anĩ ere, Israel idi madur bagai nẽ lo dõ difen, idi madur bagai anĩ yaleya sã. ");
INSERT INTO dad_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ere nigin yaleya sã? Idi Negur nigin momoiya bunem dõ fiya sã, anĩ ere, lo dõ fiya bunem, Negur mala bun madur bagai dalouf nigin age difen nigin. Idi ye tũ fiya nẽ meein anim yeid tũ fen. ");
INSERT INTO dad_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Are Negur nẽ Itotoya bun ibodok kilei, “Lo weleg, aya Saion oun tamo yeid tũ fiya nigin meein taka, idi kubũ douf nigin sa tuwa taka anof, age afe di, taka ĩ, ĩ nigin momoi youf, ĩ mama to bagai yalouf.” ");
INSERT INTO dad_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Turau tar, aya Negur ĩ Israel kel gei fediyouf nigin wau iro ken, Negur bun kosẽ audig. ");
INSERT INTO dad_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Aya idi nigin kurõ afeis eig auf, idi Negur nigin kisi totol dinodig, anĩ ere, idi neid kisi totol are keleĩ bunem sã. ");
INSERT INTO dad_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ere nigin, idi madur bagai Negur bunem isif anĩ to kelei ken, dogo neid madur bagai anĩ dalouf nigin dimiren, age dife fen, idi, Negur tamo kayau yogon mala bun madur bagai inenẽdiya nẽ naab anĩ ditoron. ");
INSERT INTO dad_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kristus ĩ, idi momoi def ganan madur bagai wowã douf nigin, lo nẽ idikeleya wõ yen. ");
INSERT INTO dad_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Moses ĩ madur bagai lo ganan dõ fiya bunem isif nigin eig ye itoton, “Tamo ĩ lo enei dõ fef, ĩ anĩ bunem mata ibodõf.” ");
INSERT INTO dad_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Anĩ ere, madur bagai momoiya bunem isif anĩ eig ye irok, “Õ waũ bun to eig wo urõf, ‘Aim anĩ saa ilun iselauf?’ ” (are, Kristus irou isiyouf nigin) ");
INSERT INTO dad_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“oo ‘Aim anĩ teneub kur bagai isilauf?’ ” (are, tamo gare den bun tamal Kristus irou isauf nigin). ");
INSERT INTO dad_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Anĩ ere, ĩ ere ye irok? “Od anĩ õ wagen ibodok, are ogon sigor bun, ogon waũ bun ibodok,” are momoiya nẽ od amã wogõ maudig anĩ. ");
INSERT INTO dad_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Are õ ogon sigorom, “Jesus ĩ Odug,” wo fen, õ waũ bun, Negur ĩ Jesus tamo gare den bun tamal kel turĩ fiyen anĩ, momoi wouf are, õ kel yaleyõf. ");
INSERT INTO dad_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Are, taka ĩ wau bun momoi ye di, Negur ĩ madur bagai yef, age fe di, taka ĩ sigorom momoi auf ye di, Negurem ĩ kel yalouf. ");
INSERT INTO dad_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Are Negur nẽ Itotoya bun ibodok kilei, “Taka ĩ, ĩ nigin momoi youf, ĩ mama to bagai yalouf.” ");
INSERT INTO dad_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Juda ado haiden bun fire fire sã, Odug de tekelei anĩ ganan nẽ Odug, ĩ idi diweignek ganan bun el fiya fatuk bagai ifenẽdidig, ");
INSERT INTO dad_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","are Negur nẽ Itotoya bun ibodok kilei, “Idi Odug nẽ yana dale diweignek ganan, Negurem kel gei fediyouf.” ");
INSERT INTO dad_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Age fiyauf are, naig fe di, idi ĩ nigin to momoi den ani diweignẽf? Naig de fen, idi to karĩ den anĩ nigin momoi douf? Taka nem to irokenẽdiyouf are, naig de fen, idi karĩ douf? ");
INSERT INTO dad_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Idi to sur fediyouf are, idi naig de fen, od wogõ douf? Are Negur nẽ Itotoya bun ibodok kilei, “Idi biya od diroulef anidi, yeid gai meli bagai!” ");
INSERT INTO dad_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Anĩ ere, Israel tunĩ biya od anĩ to dalen. Idi age difen nigin, Asaia eig ye iron, “Odug, aim anĩ nemã od nigin momoi yen?” ");
INSERT INTO dad_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Anĩ nigin, momoiya anĩ biya od karĩya bunem isidig, biya od karĩya are Kristus nẽ od bunem isidig. ");
INSERT INTO dad_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Anĩ ere, aya to afef; Idi to karĩ dedig de? Momoi, idi karĩ den, are Negur nẽ Itotoya bun ibodok kilei, “Neu arũ tamo neid aiteid, teneub ganan bun iyokelen, dogo neid od teneub idikeleya bun ilen.” ");
INSERT INTO dad_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Baban aya to afef: Israel idi to kelein de? Uruwa bun, Negur Moses bunem iron, “Aya tamo kayau yeneid sã idi bun age afe di, idi nigin ã kiyeĩ unogouf. Aya tamo kayau keleĩ sã idi bun age afe di, idi nigin ã nameĩ saneuf.” ");
INSERT INTO dad_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Takag, Asaia kukĩya sã eig ye iron, “Idi aya to dimirnan, aya dileyauf. Idi aya nigin to fiya san anidi bun, aya yug yaor afouf.” ");
INSERT INTO dad_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Anĩ ere, Israel nigin ĩ eig ye iron, “Naa tekelei adok, aya tamo kayau dõ fiya sã, fe temeleid bun imau dõ au fen, tari afedif abodon.” ");
INSERT INTO dad_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Age fiyauf are, aya to afef: Negur ĩ yogon tamo kayau aulel fedin de? Sã bagai! Aya yug Israel temelou, Abraham nẽ ibor, Benjamin nẽ gĩ bun temelou. ");
INSERT INTO dad_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Negur ĩ, yogon tamo kayau, ĩ mogo gariya bunem kelei ken igirnẽdin anidi to aulel fedin. Ereb Negur nẽ Itotoya bun Eliya nigin irok, are ĩ Negur ado, Israel idi nigin bou yũya od wogõ den anĩ, ã to keleĩ de? ");
INSERT INTO dad_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Odug, idi mogo ogon profet didenkeis fen, ogon alta narĩ difedin. Aya mugu dogol ditorna fen, idi aya dinakesiyouf nigin age difef.” ");
INSERT INTO dad_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Age ye di, Negur ere od solof irokenen? “Aya, aya yug nigin sewen tausen tamo idi idegẽya waitou Bal bun to iboreid bobou difen anidi, foi afen.” ");
INSERT INTO dad_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Age fiya gen, sain enei buneg, Negur wau ifenẽya bunem musei sã igirnẽdin anidi fau dibodok. ");
INSERT INTO dad_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Igirĩya anĩ, Negur nẽ wau ifenẽya bunem isin, are tamo nẽ kabĩ bunem sã. Igirĩya anĩ tamo nẽ kabĩ bunem isin ouf are, Negur nẽ wau ifenẽya anĩ, wau ifenẽya sa ken, mala ifenẽya yenem. ");
INSERT INTO dad_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Anĩ nigin, ada ere tauf? Ereb Israel idi kabĩ totol dale fen, dimiren anĩ, idi to dalen, anĩ ere, Israel tunĩ musei sã Negur igirnẽdin anidim dogol dalen. Israel tunĩ ganan Negur waud ifofakelen. ");
INSERT INTO dad_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Are Negur nẽ Itotoya bun ibodok kilei, “Negur, idi kisi kurã fiya sã nẽ uur, meleid to dilouf nẽ ado, wedereid to karĩ douf nẽ anĩ ifenẽdin, anĩ bunem isi gama naa enei bun.” ");
INSERT INTO dad_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Takag, Dawid eig ye iron, “Neu kiwai tar, idi neid sifa nẽ tebol bun, saaf dokon waud kulĩ yen sain bun, idi suk bun gei difediyouf, idi kor bun gei difediyouf, idi neid el fiyam, dogo yeid tũ difouf nigin ado, mala solo fiya nẽ darau, idi bun wõ youf nigin aya orouf. ");
INSERT INTO dad_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Dogo neid meleid gugum kele fen, to dilouf, dogo neid bagiyeid gai gai nigin fe fesilauf anĩ orouf.” ");
INSERT INTO dad_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Age fiyauf are, aya to afef: Idi yeid tũ fe di, kubũ de fen, baban fãya kisi feleya sã de? Sã bagai! Anĩ fotokar, idi neid mosor nigin, kel gei fiya are haiden bun isin, are Israel idi kiyeĩ dinouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Anĩ ere, idi neid mosor nigin tenebur tamo kayau bun el fiya kisi feleya bagai wõ ye fen, idi neid kũ fenẽya nigin haiden bun el fiya kisi feleya bagai wõ youf are, idi neid gire fiya anim naig fiya el fiya kisi feleya bagai irousiyouf! ");
INSERT INTO dad_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Aya ã haiden bun wogõ auf. Aya haiden bun aposel nigin, aya neu kabĩ nigin fatuk bagai yanau alesef, ");
INSERT INTO dad_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","are aya neu Israel tamo kayau turĩ afeid, idi kiyeĩ dinouf bun, idi tunĩ kel gei afouf nigin age afef. ");
INSERT INTO dad_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Negur idi aulel fedin bunem, tenebur tamo kayau idi Negur geid komo fiya dalen ouf are, sain Negur idi yalediyouf bun, ere anĩ wõ youf? Are idi tamo kayau ganan gare den bun tamal mata kel fã den gen ouf. ");
INSERT INTO dad_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Wit uyulil faat yun anĩ bunem sesewi fiya nẽ bret dinof, anĩ nẽ masak fateul ouf are, bret gananeg fateul. Warumutei anĩ fateul ouf are, were gananeg fateul. ");
INSERT INTO dad_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Were tunĩ kokour fele fen, õ oliv aa kuĩ nẽ were, oliv aa bun bagu yõ di, oliv aa nẽ warumutei bun saaf tekelei waledig, ");
INSERT INTO dad_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","anĩ nigin, Israel idi bun, õ haiden yanã to wales. Õ yanã walesauf are, enei kisi wo: Õ warumutei to usennek, anĩ ere, warumutei anĩ õ isennok. ");
INSERT INTO dad_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Anĩ ere, õ eig wo urõf, “Aya aa anĩ bun bagu fiyauf nigin were kokour feledin.” ");
INSERT INTO dad_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Are momoi. Ani ere, idi momoiya sã nigin kokour feledin, age fe di, õ momoiya bunem ufaref. Õ yanã to wales, anĩ ere, õ kumĩ wouf. ");
INSERT INTO dad_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ere nigin, Negur ĩ Israel idi oliv aa nẽ were bagai yalelnẽdiyouf nigin to katũ yen ouf are, ĩ õ nigineg to katũ youf. ");
INSERT INTO dad_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Anĩ nigin, Negur nẽ molol ado wau itenẽya nigin kisi gouf, ĩ idi kubũ den anidi bun wau itenen, anĩ ere, ã in molol bun toku ubodõgouf are, ĩ ã bun molol ibodõf. Anĩ ere, ã in molol bun to ubodõgouf are, ãg kokour yeikalauf. ");
INSERT INTO dad_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Israel idi momoiya sã bun toku to dibodõf are, idi baban aa oliv bun bagu fediyouf, ere nigin, Negur ĩ baban idi bagu fediya nigin kisi feleya. ");
INSERT INTO dad_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Õ ogon gariya oliv aa kuĩ bagai bun tamal kokour fele fen, ogon gariya sã oliv aa bagai kulatun fedig anĩ bun bagu yon ouf are, oliv aa bagai nẽ were eneidi, naig fiya karika bagai dogo neid oliv aa bagai bun bagu fediyouf! ");
INSERT INTO dad_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Turau tar, aya waa enei ã to keleĩ youf nigin to orouf, are ã aug nigin keleĩ biya ado to gouf nigin age afef. Waa are, Negurem Israel tunĩ waud ifofakelen, anĩ bunem idi dibodok disi mog, haiden idi Negurem igirnẽdin anidi ganan Negur wagen disiyouf sain anĩ bun. ");
INSERT INTO dad_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Age dife di, Israel ganan kel gei fediyouf, are Negur nẽ Itotoya bun ibodok kilei, “Kel yaleya tamo Saion bun tamal isiyouf, ĩ Jakop bun tamal Negur nẽ od dõ fiya sã nẽ tobonunã anĩ yalelauf. ");
INSERT INTO dad_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Aya, idi geid bar itenẽya nẽ enei atenẽf, anĩ bunem aya dogo neid mosor alelauf.” ");
INSERT INTO dad_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Biya od nigin, idi ã nigin kiwai, anĩ ere, Negur nẽ igirĩya nigin, idi tubuid tar nigin, Negur idi nigin wau laa fedig, ");
INSERT INTO dad_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ere nigin, Negur nẽ ege luwa ado yogon igirĩya anĩ falei fiya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ã uruwa bun Negur dõ fiya sã, anĩ ere, ã gama, Israel Negur dõ fiya sã nigin, Negur nẽ wau yũya walegen. ");
INSERT INTO dad_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Age fiya gen, idig gama Negur dõ fiya sã, are Negur nẽ wau yũya ã ifenein anĩ bunem, idig gama Negur nẽ wau yũya dalouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Age fiya nigin, Negur ĩ tamo ganan, dõ fiya sã nẽ kafĩ fiya bun inenẽdin, are ĩ idi ganan wau yũya ifenẽdiyouf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","O Negur nẽ kisi biya ado keleĩ biya, are kisi feleya bagai ilon bagai isilef. Yogon es fiya anĩ imir ken, keleĩya kisi feleya sã, yogon delẽ iyõdig anĩ dir feleya kisi feleya sã. ");
INSERT INTO dad_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Are Negur nẽ Itotoya eig ye irok, “Aim anĩ Odug nẽ kisi kelein? Aim anĩ ĩ ulum iroukenen?” ");
INSERT INTO dad_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“Aim anĩ Negur ifenen nigin Negur ĩ aba kel ifenẽf?” ");
INSERT INTO dad_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ada keleĩ, od enei are momoi, ere nigin, ereb ereb ganan ĩ bun tamal isif, ereb ereb ganan ĩ bunem ibodok, ereb ereb ganan ĩ bun ilef. Ĩ bun fula fiya medeĩya faimud ibodõf! Momoi. ");
INSERT INTO dad_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Anĩ nigin, turau tar, aya, ã, Negur nẽ wau yũya ada ifanadan bunem totol bagai arokeneik, ãgenei bouweĩ, mata ibodõya nẽ sesewi fiya, fateul ado Negur wau kulĩya nẽ anĩ gen Negur wenẽgouf. Enei anĩ, ãgenei uurem Negur yana yaleseya. ");
INSERT INTO dad_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Tenebur enei nẽ oroya baban to dõg, anĩ ere, Negur ãgenei kisi falei fe mata inoyeĩ di, ãgenei kisi mata anĩ dõ gouf, anĩ bunem, ã Negur nẽ oroya, are yogon biya nẽ, kulĩya nẽ ado, kisi feleya nẽ oroya anĩ keleĩ youf. ");
INSERT INTO dad_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Negur nẽ wau ifenẽya bunem, aposel kabĩ yaleya nẽ yana aya ifanan nigin, aya ã ganan arokeneik: Taka ĩ yogo nigin kisi fouf anĩ to wal fe fen, kisi fouf, anĩ ere, momoiya Negur ifenen anĩ kilei, es fiya biya bun yogo nigin kisi fouf. ");
INSERT INTO dad_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Ada bouwada tekelei bun fara fiya musei ado, anĩ ere, fara fiya ganan bun kabĩ tekelei sã, ");
INSERT INTO dad_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","age fiya gen, ada fara fiya musei, anĩ ere, Kristus bun, bouwada tekelei, fara fiya mugu mugu tunĩ ganan geid bagu fedif. ");
INSERT INTO dad_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Negur wau ifenẽya ada ifanadan kilei, ada Negur nẽ igirĩya ege luwa fire fire ado. Tamo ĩ profet od wogõya nẽ igirĩya ege luwa adouf, utornẽg len, ĩ yogon momoiya kilei wogõ youf. ");
INSERT INTO dad_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ĩ aruna yaleya nẽ igirĩya ege luwa adouf, utornẽg len, ĩ aruna yalouf. Ĩ ifelnẽya nẽ igirĩya ege luwa adouf, utornẽg len, ĩ ifelnẽya kabĩ yalouf. ");
INSERT INTO dad_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Ĩ wau yaleseya nẽ igirĩya ege luwa adouf, utornẽg len, ĩ taka nẽ wau yalesauf. Ĩ tunĩ lau fiya isennẽya nẽ igirĩya ege luwa adouf, utornẽg len, ĩ wau sã ifenẽdiyouf. Ĩ uyu irouya nẽ igirĩya ege luwa adouf, utornẽg len, ĩ fõ fiya sã uyu irouya kabĩ yalouf. Ĩ wau yũya ifelnẽya nẽ igirĩya ege luwa adouf, utornẽg len, ĩ wau kulĩya ado age fouf. ");
INSERT INTO dad_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Wau laa fiya are mala yaleya sã. Ereb sane anĩ seseg fen, ereb biya anĩ kafĩ weleg. ");
INSERT INTO dad_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Ã abob bun tureĩ tar bagai nigin gen, wauĩ laa fiya bun wauĩ wenẽgouf. Ã atun abob yana ketem ilun walesagauf. ");
INSERT INTO dad_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ã to fõ yei ken, kabĩ totol waleg. Ãgenei uur nẽ totol bunem, Odug aruna walogouf. ");
INSERT INTO dad_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Wau iseya bun wauĩ kulĩ youf, morõ bun megeir ufaragauf, toku kosẽ gouf. ");
INSERT INTO dad_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Negur nẽ tamo kayau lau difef anidi wenẽdigouf. Tamo urug waledigouf. ");
INSERT INTO dad_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Idi ã darau difeneik anidi el fiya wenẽdigouf, el fiya wenẽdig fen, to usisnẽdigouf. ");
INSERT INTO dad_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Idi waud kulĩ yef geid kulĩ gouf, idi inã dalef geid inã walogouf. ");
INSERT INTO dad_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Ã abob nigin wauĩ tekelei yenẽf. Ã yeneĩ to walesagauf, anĩ ere, ã tenebur difaref geid nigal yũya nigin ago gouf. Ã aug nigin keleĩ biya ado to gouf. ");
INSERT INTO dad_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ã aib taka sane age yeik anĩ, aba sane to wiyẽgouf. Tamo ganan meleid bun ereb madur age fiya nigin karĩ walagauf. ");
INSERT INTO dad_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ã kisi feleyauf are, ganan geid wau inosiya bun ubodõgouf. ");
INSERT INTO dad_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Neu oboiyou tar, ã aug mala solo to wenẽdigouf, anĩ ere, Negur nẽ didi nigin modoũ unogouf, ere nigin, Negur nẽ Itotoya bun eig ya ibodok, “Odug irok, mala solo ifenẽya are neu. Ayam mala solo afenẽf.” ");
INSERT INTO dad_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Age fiya ban, Negur nẽ Itotoya bun eig ya ibodok, “Ogon kiwai naũ fouf are, saaf wenẽ yãf, ĩ naan ail fouf are, naan wenẽ yãf. Anĩ agouf bun, ĩ yogon ereb sane age fen nigin mama sane falauf.” ");
INSERT INTO dad_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ã sane anim to wal yeĩf, anĩ ere, ãgem biya bunem sane anĩ wal gouf. ");
INSERT INTO dad_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Tamo kayau ganan gawaman farumedin dibodõf, ere nigin, gawaman Negurem to inodin anĩ taka to ibodok. Gawaman gama dibodok are Negur yogo inodin. ");
INSERT INTO dad_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Anĩ nigin, taka ĩ gawaman kiwai ifenek, ĩ ereb Negurem inon anĩ kiwai ifenek. Idi anĩ age difef, idi es fiya dogo bouweid bun dinouf. ");
INSERT INTO dad_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ere nigin, uyu irouya tamo, idi biya age difef anidi kumĩ to difiyẽdidig, anĩ ere, idi sane age difef anidi kumĩ difiyẽdidig. Uyu irouya ĩ õ to kumĩ ifonõf anĩ, õ oroyok de? Agouf are, ereb tobonunã biya anĩ ago wo di, ĩ õ yanã yalesauf. ");
INSERT INTO dad_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ere nigin, ĩ ogon biya fiya nigin Negur nẽ kabĩ tamo inenen. Anĩ ere, sane ago wouf, õ kumĩ wouf, ere nigin, ĩ dimig ege to irouf. Ĩ Negur nẽ kabĩ tamo, ĩ mala ifenẽya tamo, idi sane age difef anidi bun Negur nẽ didi irou isif. ");
INSERT INTO dad_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Anĩ nigin, ã gawaman farumen bagai ubodõgouf, are darau kumĩya bunem dogol sã, Negur mala bun ada biya be sane es fiya nẽ kisi nigineg ago gouf. ");
INSERT INTO dad_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Anĩ nigin, ã takiseg unogedig, ere nigin, gawaman nẽ kabĩ tamo are Negur nẽ kabĩ tamo, idi dogo neid sain ganan gawaman kabĩ nigin difenẽdig. ");
INSERT INTO dad_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ã ereb ganan ifenẽya nigin yenek are wenẽgouf, ã takis ifenẽya nigin ouf, takis unogouf, ã safina yaleya nẽ takis ifenẽya nigin ouf, safina yaleya nẽ takis unogouf, ã anini fiyẽya nigin ouf, anini wiyẽgouf, ã seli yabiya nigin ouf, seli wabigouf. ");
INSERT INTO dad_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Wareg taka to utorõge di, ibodõf, abob nigin wauĩ laa fiya nẽ wareg dogol ã atun ibodõf, ere nigin, taka ĩ ne tã nigin wau laa fef, ĩ lo dõf kisi felef. ");
INSERT INTO dad_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Ĩtãfiya eig ye irok, “Seseirã to uno,” “Tamo to ukeis,” “Bẽ to ule,” “Taka nẽ safina to malã ile orouf,” ĩtãfiya eneidi ado ereb lo tunĩ ifaredif are, ĩtãfiya tekelei eneim ganan irouf, “Õ ogo nigin waũ laa fef gen, nẽ tã nigin ago waũ laa fouf.” ");
INSERT INTO dad_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Wau laa fiya anim, ne tã bun sane to age fedig. Anĩ nigin, wau laa fiya are lo dõf kisi felef. ");
INSERT INTO dad_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Anĩ nigin, sain enei nigin wedereĩ fokõf fen, enei ago gouf. Ã mulaĩ itorõya nẽ sain mogo isif, ere nigin, ada uruwa bun momoi taun bunem isi, gama ada neda kel gei fadaya nẽ sain anĩ melsak. ");
INSERT INTO dad_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Bõ are mogo sa kalau fenẽ, naa mogo wõ you fenẽ. Anĩ nigin, ada gugum nẽ tobonunã tator, yerin gadi tafel fen, lalan nẽ tobonunã biya anĩ dõ tafouf. Age tafe fen, ada, kusĩ nigin kusĩ nẽ naki totol difonũdig gen, tobonunã biya anĩ, ada bun ibodõf nigin age tafouf. ");
INSERT INTO dad_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Tamo kayau we feleyan lo difeid le di, tobonunã biya age difedig gen, ada tobonunã biya dõ tafouf, bilãya ado naan yõya bun sã, noli tobonunã ado bouwa nẽ oroya nigin totol sane wau fãya bun sã, kusĩ ado kiyeĩ buneg sã. ");
INSERT INTO dad_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Anĩ ere, Odug Jesus Kristus anĩ waleg, aug bun ufonũgouf, agog fen, bouwa nẽ oroya dõ fiya nẽ kisi anĩ bun to ufaragauf. ");
INSERT INTO dad_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Taka ĩ momoiya felu ref are waleg fen, yogon keleĩ ã geid tekelei sã nigin to monẽ wiyẽgouf. ");
INSERT INTO dad_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Tamo taka in momoiya anim irõ di, ĩ ereb ereb ganan yõya nigin age fedig, anĩ ere, tamo taka in momoiya felu reya, ĩ sako dogol yõdig. ");
INSERT INTO dad_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Tamo ereb ereb ganan yõdig anim, ne tã sako dogol yõdig to kono fiyẽf, age fe di, tamo ereb ereb ganan to yõdig anim, tamo ereb ereb ganan yõdig bou bun od to yũf, ere nigin, Negur ĩ yalen. ");
INSERT INTO dad_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Õ ai anĩ taka nẽ kabĩ tamo es wof? Ĩ kubũ be youf, ifar bẽf, are yogon Odug bun ibodok. Anĩ nigin, ĩ ifarauf, ere nigin, Odug ĩ yogo, ĩ ifareya nigin age fiya kisi feleya. ");
INSERT INTO dad_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Tamo taka ĩ, naa taka anĩ naa ganan wal fiya gen iledig. Tamo taka naa ganan are de kilei kilei iledig. Idi mugu mugu dogo neid kisi bun anĩ nigin waud ditenẽf. ");
INSERT INTO dad_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Taka ĩ naa taka anĩ odug gen ilef, Odug nigin ye fen, ĩ age fef. Age fiya gen, taka ĩ yaro muda yoko, Odug nigin ye fen, yoko, ere nigin, ĩ Negur de fiyek. Taka ĩ ereb ereb tunĩ yõya nigin itorok, ĩ Odug nigin ye fen, agef fen, Negur de fiyek. ");
INSERT INTO dad_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Ere nigin, ada takam yogo nigin mata to ibodok, ada takam yogo nigin to laa fef. ");
INSERT INTO dad_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ada mata tabodok are, ada Odug nigin mata tabodok. Ada gare tauf are, ada Odug nigin gare tauf. Anĩ nigin, ada mata tabodok be, gare taufeg, ada Odug nẽ. ");
INSERT INTO dad_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Gariya enei nigin, Kristus laaf fen, mata kel fã yen, are ĩ tamo gare den ado tamo mata dibodok neid Odug ibodõf nigin age fen. ");
INSERT INTO dad_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Age fiyauf are, õ ere nigin ogon turã es wiyek? Õ ere nigin ogon turã kono wiyek? Ada ganan Negur nẽ es fiya nẽ sia wagen tafarauf. ");
INSERT INTO dad_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Age fiya nigin, Negur nẽ Itotoya eig ya ibodok, “Odug irok, aya momoi bagai mata abodok nigin, iboreid ganan aya bun bobou difouf, baleid ganan kurõ difeis, Negur yana dalesauf.” ");
INSERT INTO dad_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Age fiya nigin, ada mugu mugu, ada dug nigin Negur kurõ tafeis tarokenẽf. ");
INSERT INTO dad_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Anĩ nigin, ada abob es fiyẽya tatorõf. Anĩ ban, ã tureĩ nẽ naab bun ereb naabura gudũf kenẽya nẽ taka be, ye tũf kenẽya nẽ taka to unogouf nigin lo walagauf. ");
INSERT INTO dad_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Odug Jesus kisi fokõ fel kana di, aya momoi bagai kisi afef, are saaf, Negur mala bun amuyẽ ado taka to ibodok. Anĩ ere, taka ĩ saaf taka amuyẽ ado youf are, ĩ yogo bun saaf anĩ amuyẽ ado. ");
INSERT INTO dad_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ereb õ woko anĩ bunem ogon turã ĩ wau morõ wenẽf are, õ waũ laa fiya bunem to agof. Ereb õ woko anĩ bunem, turã Kristus ĩ nigin laa fen anĩ to daũ wiyẽ. ");
INSERT INTO dad_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Anĩ nigin, ereb ã biya gef anĩ, tamo kayau idi to sane douf nigin ago gouf. ");
INSERT INTO dad_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Ere nigin, Negur nẽ tano are, saaf yõya ado naan yõya nẽ sã, anĩ ere, Awa Uur Fateul bun madur bagai