﻿USE sofia;
DROP TABLE IF EXISTS sofia.cya_vpl;
CREATE TABLE cya_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cya_vpl WRITE;
INSERT INTO cya_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nde nguinu scua nii ta nten 'in Jesucristo, sñe' ta nten 'in Davi, cui' sñe' ta nten 'in Abraham. ");
INSERT INTO cya_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ncua sti Isaac, Isaac ncua sti Jacob, Jacob ncua sti Judá lo'o nchgaa la ña'an ta'a ngula yu. ");
INSERT INTO cya_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yu Judá can' ncua sti Fares lo'o Zara, lo' jyi'an chcuaa yu can' ncua naan Tamar, lo' Fares ncua sti Esrom, Esrom ncua sti Aram. ");
INSERT INTO cya_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram can' ncua sti Aminadab, Aminadab ncua sti Naasón, Naasón ncua sti Salmón. ");
INSERT INTO cya_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Yu Salmón ncua sti Booz, lo' jyi'an can' ncua naan Rahab, Booz ncua sti Obed, lo' jyi'an can' ncua naan Rut, Obed ncua sti Isaí. ");
INSERT INTO cya_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ncua sti yu nu ncua ree Davi, ree Davi can' ncua sti Salomón, lo' jyi'an can' ncua cuilyi'o yu Uría. ");
INSERT INTO cya_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ncua sti Roboam, Roboam ncua sti Abía, Abía ncua sti Asa. ");
INSERT INTO cya_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yu Asa ncua sti Josafat, Josafat can' ncua sti Joram, Joram ncua sti Uzía. ");
INSERT INTO cya_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzía ncua sti Jotam, Jotam s ncua sti Acaz, Acaz ncua sti Ezequía. ");
INSERT INTO cya_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequía ncua sti Manasés, Manasés can' ncua sti Amón, Amón ncua sti Josía. ");
INSERT INTO cya_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yu Josía ncua sti Jeconía lo'o ta'a ngula yu, cui' Babilonia ncua cune' yu xa yaa ne' Israel preso. ");
INSERT INTO cya_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chon' nde'en xa nguila ne' yaa ne' Babilonia ncua cune' Salatiel, cui' sñe' Jeconía, yu Salatiel ncua sti Zorobabel, ");
INSERT INTO cya_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ncua sti Abiud, Abiud ncua sti Eliaquim, Eliaquim ncua sti Azor. ");
INSERT INTO cya_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yu Azor ncua sti Sadoc, Sadoc ncua sti Aquim, Aquim ncua sti Eliud. ");
INSERT INTO cya_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Yu Eliud ncua sti Eleazar, Eleazar ncua sti Matán, Matán ncua sti Jacob. ");
INSERT INTO cya_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ncua sti yu See, cui' nu ncua cuilyi'o María nu ncua jyi'an Jesús, ñi nu lca Cristo. ");
INSERT INTO cya_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Cuaña'an yato'o yton tsa tilcua ta nten, ti' chendyu nu mdi'in yu Abraham hasta chendyu nu mdi'in yu Davi, ticui' cuaña'an yton cha tilcua ta nten, ti' chendyu 'in Davi tsaya' nguila ne' Israel yaa ne' preso se'en lca Babilonia, ticui' cuaña'an yton cha tilcua ta nten, ti' xa nguila ne' yaa ne' Babilonia tsaya' mdiyaan Cristo chendyu. ");
INSERT INTO cya_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ndeña'an yato'o xa ngula Jesucristo: Ncua cuiya' cha' si'yana yu See ntsu'hui cha' ca cuilyi'o 'in María, jyi'an Jesús, una ti' lyijyi chcuan yu cunta 'in María, xa cua' mxilyo ña'an si'ya cha' cuiya' 'in Espíritu nu Luhui 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Una yu See can' tsu'hue nten lca yu, a ncua ti' yu xicune yu cha' can', lo' ncua lca tiquee yu si'yana cunan ti si'yu co' yu cha' can'. ");
INSERT INTO cya_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cui' cha' can' ntsu'hui tiquee yu, xa ngulo'o tloo sca angujle 'in Ñi X'nan na 'in yu ni' cula, lo' juin 'in yu: See, sñe' ta nten 'in Davi, a cutsen chcuan cunta 'in María nu ca cuilyi'o, si'yana cuhui' nu ndon lo'o cua, si'ya cha' cuiya' 'in Espíritu nu Luhui 'in Ndiose ca lca cuhui'. ");
INSERT INTO cya_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Cuhui' nu tyi'in cua ca naan cuhui' Jesús, si'yana culo laa ñi quichen 'in ñi si'ya qui'ya nducui ne'. ");
INSERT INTO cya_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nchgaa cha' re yato'o na, si'yana chcua cha' nu mxiycui' Ñi X'nan na 'in yu Isaía xa juin yu: ");
INSERT INTO cya_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","—Ña'an jan ñii, ntsu'hui cha' xilyo ña'an sca ne' cuna'an tsa suhue ti lo' tyi'in sñe' ne', lo' ca naan can' Emanuel—. Cha' re nchca ti' chcui', Ndiose ndi'in lo'o na. ");
INSERT INTO cya_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Xa mjyin xaa ti' yu See can', mducua yu tñan tsaña'an ycui' angujle 'in Ñi X'nan na lo'o yu, lo' mchcuan yu cunta 'in María. ");
INSERT INTO cya_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Una la cua' mdiyaan cuhui' chendyu xacan' m'ni ca'an yu 'in nten 'in yu, lo' mdi'in tyaa yu nii cuhui' ca naan cuhui' Jesús, nde sñe' ne' nu culoo. ");
INSERT INTO cya_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Xa nu ncua cune' Jesús quichen Belén se'en lyi'ya loo Judea, cui' xa nu lca yu Herode ree, xacan' mdiyaa tucua snan yu mago quichen Jerusalén nu mdo'o tijyo', luhua' se'en nchcua cucha, ");
INSERT INTO cya_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","lo' mñicha' yu: ¿La ndi'in yu nu lca ree 'in ne' judio, yu nu ngula can'? Si'yana cua' na'an hua mdo'o tucua sca cuii, lo' nchcui' na cha' 'in yu, ljyaan hua si'yana cu'ni tnu hua 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Xa ynan yu ree Herode cha' re, msu'hua yu cha' tiquee yu, lo' cui' cuaña'an quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","M'ni yu cha' nguio' ti'in nchgaa nu ntsu'hui cunta cha' 'in laa, tsatlyu lo'o ne' escriba nu ndi'in quichen can', lo' mñicha' yu 'in ne' cha' la ca ntsu'hui cha' cula ñi nu lca Cristo. ");
INSERT INTO cya_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mxcuen ne' 'in yu: Cui' quichen Belén se'en lyi'ya loo Judea, si'yana ndeña'an nguinu scua cha' nu mxiycui' Ndiose 'in nguso 'in ñi cua' s'ni: ");
INSERT INTO cya_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","—Nu'huin Belén, cui' quichen nu m'ni ca'an 'in Judá, a lca um nu chin' la cha' 'in lja nu ndon loo lati se'en lyi'ya loo Judea, si'yana loo nu'huin ntsu'hui cha' tyi'o sca nu culo ca tñan, nu chu'hui cunta 'in quichen 'ñan nu lca Israel—. ");
INSERT INTO cya_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Xacan' yu Herode msi'ya cunan ti yu 'in yu mago can', lo' mñicha' lyicua yu 'in, cha' ti' ñi xaa mdo'o tucua cuii can', ");
INSERT INTO cya_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","xacan' ngua'an tñan yu 'in tsaa quichen Belén, lo' juin yu: Yaa um, lo' cunan tsu'hue um suun ña'an ndi'in cha' 'in cuhui' can', xa quija lyoo um 'in cuhui', xitucui um lo' quitsa' um 'ñan, si'yana lo'on nan' tsa y'nin tnun 'in cuhui'. ");
INSERT INTO cya_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Xa mdyi ycui' ree can' lo'o yu, mdo'o yu nguiaa yu, lo' yuhue 'a ti' yu si'yana xiya' mdo'o tucua cuii nu cua' na'an yu, luhua' se'en nchcua cucha, lo' mducua loo na loo yu tsaya' mdiyaa na chcua se'en ndi'in cuhui' can', lo' can' ycan' tucui na. ");
INSERT INTO cya_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ndyijyin ya' tsu'hue ntsu'hui tiquee yu xa na'an yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Xa yten yu ña'an can', na'an yu 'in cuhui' can' lo'o María jyi'an cuhui', mdyi'ya xtyin' yu lo' m'ni tnu yu 'in cuhui', msla yu se'en ntsu'hui cha' tsu'hue nu ljyan lo'o yu, lo' mdaa yu na oro 'in cuhui', lo'o na xityi'i nu ndiquin tucua ne' tloo Ndiose, lo'o mirra. ");
INSERT INTO cya_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yato'o jui nu mtsa' 'in yu ni' cula, si'yana a xitucui 'a yu se'en ndi'in yu Herode, can' cha' xca tucueen mxitucui yu nde quichen tyi yu. ");
INSERT INTO cya_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Xa cua' nguiaa yu mago can', sca angujle 'in Ñi X'nan na ngulo'o tloo 'in yu See can' ni' cula, lo' juin 'in yu: Ndla ti cu'ni, lo' tsa lo'o 'in cuhui' cua lo'o jyi'an cuhui' se'en lca Egipto, can' tyi'in um la xa nu nan' quitsan' 'in, si'yana yu Herode nan yu ña'an nu cujui yu 'in cuhui'. ");
INSERT INTO cya_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Cui' xaa mdyi'o sla yu, lo' ticui' tla can' mdo'o yu nguiaa yu lo'o cuhui' can' lo'o jyi'an cuhui' se'en lca Egipto. ");
INSERT INTO cya_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Can' ndi'in yu xa ngujui yu Herode, yato'o cha' re si'yana chcua cha' nu mxiycui' Ñi X'nan na 'in nguso 'in ñi cua' s'ni, lo' nchcui' na: —Se'en lca Egipto msi'yan 'in Sñen'—. ");
INSERT INTO cya_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lo' yato'o lyee 'a ycuen tique' yu Herode, xa ngujlyo ti' yu si'yana nguñilyi'o yu mago 'in yu, ngulo yu tñan si'yana caja nchgaa cuhui' nu ndi'in quichen Belén lo'o chcua tyi'iin tso', tsalca cuhui' nu ndiyaa tucua yjan, tsaña'an cunta nu ngulo yu lo'o suun nu mdaa yu mago can'. ");
INSERT INTO cya_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cuaña'an mducua cha' nu mxiycui' Ndiose 'in yu ncua naan Jeremía xa juin yu: ");
INSERT INTO cya_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","—Ngune msi'ya yja cueen ne' quichen Ramá, nguinan ne', ti'i nga'an 'in Raquel si'ya sñe', lo' a ncua lca tiquee caja nu tyaa cha' tnu tiquee 'in si'yana ngujui sñe'—. ");
INSERT INTO cya_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Xa cua' ngujui yu Herode can', ngulo'o tloo sca angujle 'in Ñi X'nan na 'in yu See can' ni' cula, se'en ndi'in yu quichen Egipto, ");
INSERT INTO cya_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","lo' juin 'in yu: Tyaa juesa xitucui se'en lca Israel lo'o cuhui' cua lo'o jyi'an cuhui', si'yana cua' ngujui yu nu ncua ti' cujui 'in cuhui'. ");
INSERT INTO cya_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Xacan' mxitucui jun lo'o cuhui' can', lo' nguila jun se'en lca Israel. ");
INSERT INTO cya_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Xa ynan yu cha' si'yana yu Arquelao ndlo yu tñan se'en lyi'ya loo Judea, tñan loo Herode sti yu, ytsen yu quila yu can', una jui nu mtsa' 'in yu ni' cula, can' cha' mdo'o yu nguiaa yu se'en lyi'ya loo Galilea. ");
INSERT INTO cya_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mdiya ti'in jun quichen Nazaret, cuaña'an mducua cha' nu ycui' nchgaa yu nu mxiycui' Ndiose 'in cua' s'ni, ña'an ca si'yana ca naan ñi Nazareno. ");
INSERT INTO cya_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ya tucua tsaan, yu Xuhua nu mducua tya 'in nten, mdyisnan ycui' yu cha' tsu'hue 'in Ndiose sca se'en ngutyi, cui' se'en lyi'ya loo Judea, ");
INSERT INTO cya_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","lo' nchcui' yu: Xilo'o chon' um qui'ya ngui'ni um, si'yana cua' mdiyaa xaa culo Ndiose tñan 'in na. ");
INSERT INTO cya_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nde cha' nu mxiycui' Ndiose 'in Isaía cua' s'ni: —Tyi'an yu se'en ngutyi lo' chcui' cueen yu: Cu'ni chu'hue um tucueen se'en caan Ñi X'nan na, lo' cu'ni ñi um tucueen nu ntsu'hui cha' tyijyin ñi—. ");
INSERT INTO cya_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yu Xuhua can' lco' yu sca te' nu nguiaa' lo'o quichan' camello, lo'o sca quijyin nchcan' na sii' yu, lo' scua nu nchcu yu lca 'in sco', lo' ndyi'yo yu cuiñan' nu ntsu'hui ni' quixin'. ");
INSERT INTO cya_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mdiyaan nten nu mdo'o quichen Jerusalén se'en ndlyu yu, lo'o quichen se'en lyi'ya loo Judea, lo'o sca chcui se'en lyi'ya loo chco tlyu Jordan, ");
INSERT INTO cya_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","mducua tya yu 'in ne' chco tlyu can', lo' ñee ne' qui'ya 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Xa na'an yu si'yana qui'an ne' fariseo lo'o ne' saduceo ljyaan ne' si'yana chcua tya ne', nchcui' yu lo'o ne': 'Un ta nten nu cuiñi, ¿ti nu ngulo'o 'in um si'yana xnan yu'hui um, lo' a qui'ni ca'an 'in um lo'o cha' nsin' ti' nu tyi'o tiquee Ndiose tiyaa xaa? ");
INSERT INTO cya_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xilo'o chon' um qui'ya ngui'ni um, lo' culo'o xñan um 'in um lo'o sca chendyu nu luhui. ");
INSERT INTO cya_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A cu'ni siye' um ta ljuin um: Sñe' ta nten 'in Abraham lca hua. Cunen lo'o um sca cha': Ndiose tca cu'ni ñi cha' cutsu xca ta nten chon' quee re, lo' ca can' sñe' Abraham. ");
INSERT INTO cya_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A cunta chcuan yca cua' nducui cuta na chon' xcua' yca, can' cha' nchgaa yca nu a ndyi'yu mti ntsu'hui cha' xi'yu na, lo' tsaa na loo quii'. ");
INSERT INTO cya_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Cha' ñii si'yana nducua tyan 'in um lo'o tyi'a, si'yana cua' mxilo'o chon' um qui'ya 'in um, una nde loo la re ljyaan sca nu ndon loo la que ña'an nan', lo' ndyijyin ya' tsu'hue ntsu'hui tiqueen cha' cua na tca cui'yan snan ñi, cui' ñi tucua tya ñi 'in um lo'o Espíritu nu Luhui 'in Ndiose, a cunta lo'o quii'. ");
INSERT INTO cya_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yaa' ñi cua' nducua tiyaa na nu ntsu'hui cha' tyuhui trigo nu cua' nguio' ti'in, lo' xu'hua se'en ñi trigo can', a cunta ntsu'hui cha' tiquin ñi quixin can', lo'o sca quii' nu a ntsu'hui 'a cha' ti' tyuhui'. ");
INSERT INTO cya_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Xacan' mdo'o Jesús se'en lca Galilea, lo' mdiyaa ñi chco tlyu Jordan se'en nu tucua tya yu Xuhua 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Una yu Xuhua a ncua ti' yu tucua tya yu 'in ñi, lo' juin yu: 'Un ntsu'hui cha' tucua tya um 'ñan nan', lo' nde ljyaan um si'yana nan' tucua tyan 'in um. ");
INSERT INTO cya_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Una mxcuen Jesús 'in yu: Tyaa ya', si'yana cuaña'an ntsu'hui cha' tucua na tñan nchgaa cha' nu ñi 'in Ndiose. La xacan' mslyaa yu. ");
INSERT INTO cya_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ña'aan mducua tya Jesús mdyi'o ñi loo tyi'a, cui' ña'an lcaa nguila ni' cuaan, lo' na'an ñi ngu'ya tucua Espíritu 'in Ndiose que ñi, tsaña'an nchca ti' ndyi'ya tucua sca scun' jo'o. ");
INSERT INTO cya_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Xacan' ngune ycui' sca nu ycui' la ni' cuaan: Nde Sñen' nu ta'a lati 'ñan, tsu'hue 'a ntsu'hui tiqueen lo'o. ");
INSERT INTO cya_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Xacan' Espíritu 'in Ndiose mxicu'ni 'in Jesús si'yana tsaa ñi sca se'en ngutyi, lo' can' ncua ti' laxa'an xityu 'in ñi loo qui'ya. ");
INSERT INTO cya_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Xa cua' m'ni ñi ayuna tucua yla tsaan lo' tucua yla tla, xacan' mdyisnan ngute' ti' ñi. ");
INSERT INTO cya_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Cui' ña'an lcaa yaan laxa'an tloo ñi, lo' juin 'in ñi: Cha' nu'huin lca Sñe' Ndiose, chcui' lo'o quee re lo' chca na jaslya. ");
INSERT INTO cya_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mxcuen ñi 'in, ndeña'an nchcui' quityi 'in Ndiose: —Si'i tsaloo ti si'ya cha' nchcu ndyu'hui nten chendyu, cui' ca nu si'ya nchgaa cha' nu nchcui' Ndiose—. ");
INSERT INTO cya_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Xacan' ya lo'o laxa'an 'in ñi quichen Jerusalén, lo' ycuen lo'o 'in ñi sca se'en cuaan lati 'in laa can', ");
INSERT INTO cya_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","lo' juin 'in ñi: Cha' lca Sñe' Ndiose, tyi'o cuaan re lo' qui'ya ton la 'ya cua, si'yana nchcui' quityi 'in Ndiose: —Culo ñi tñan 'in angujle 'in ñi si'yana chu'hui cunta 'in, lo' su'hua yaa' can' 'in se'en nguiaa, si'yana a tsa ton quiya' loo quee—. ");
INSERT INTO cya_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Lo' juin Jesús: Una lo'o cha' re nguinu scua na loo quityi 'in Ndiose: —A tyijyin lyoo 'in Ndiose X'nan—. ");
INSERT INTO cya_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Xacan' ya lo'o laxa'an 'in ñi sca loo qui'ya cuaan ya', lo' ngulo'o 'in ñi sca chcui chendyu se'en ndlo ne' tñan, lo'o cha' cuilyiya' 'in ne', ");
INSERT INTO cya_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","lo' juin 'in ñi: Ña'aan cha' re taan 'in, cha' tyon xtyin' lo' cu'ni tnu 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mxcuen Jesús: Tyi'o tso' siin', Laxa'an, si'yana ndeña'an nchcui' quityi 'in Ndiose: —'In Ndiose X'nan ntsu'hui cha' cu'ni tnu, lo' scati 'in ñi ca ja'an—. ");
INSERT INTO cya_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Xacan' mdo'o tso' laxa'an can' sii' ñi, cui' ña'an lcaa mdiyaan angujle nu ta yaa' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Xa ynan Jesús cha' si'yana yu Xuhua cua' ntsu'hui na'an chcuan, mxitucui ñi se'en lca Galilea. ");
INSERT INTO cya_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Xacan' mdo'o ñi quichen Nazaret, lo' mcha'an ti'in ñi Capernaum, sca quichen ndi'in tu'hua tiyo', cui' loo yuu nu m'ni ca'an 'in Zabulón lo'o Neftalí, ");
INSERT INTO cya_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","si'yana tsato'o cha' nu mxiycui' Ndiose 'in yu Isaía cua' s'ni xa juin yu: ");
INSERT INTO cya_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","—Yuu nu m'ni ca'an 'in ta nten 'in Zabulón lo'o se'en lyi'ya loo Neftalí, cui' tucueen nu ndiyaa tu'hua tiyo' xca tso' chco tlyu Jordan, se'en lyi'ya loo Galilea, se'en ndi'in ne' gentil, ");
INSERT INTO cya_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","sca quichen ndi'in se'en tla yta, na'an ne' sca xaa nu tlyu, nten nu ntsu'hui tuyaa' cha' ndyija, m'ni sca xaa 'in ne'—. ");
INSERT INTO cya_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ti' xacan' mdyisnan Jesús ngulo'o ñi 'in nten, lo' nchcui' ñi: Xilo'o chon' um qui'ya ngui'ni um, si'yana cua' mdiyaa xaa culo Ndiose tñan 'in um. ");
INSERT INTO cya_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yato'o sca tsaan mda'an Jesús tu'hua tiyo' Galilea, lo' na'an ñi 'in yu Tyo lo'o yu Ndre ta'a ngula yu, nduguun yu quitan loo tyi'a can' si'yana yu cuta cula lca yu. ");
INSERT INTO cya_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Lo' juin ñi 'in yu: Chcui ncha'an um 'ñan, nan' culo'on 'in um cu'ni um cuta, tyicana 'in nten. ");
INSERT INTO cya_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ticui' xaa ngula' sti yu quitan 'in yu, lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chin' ti se'en ti' mda'an ñi, xa na'an ñi 'in tucua yu nu nda'an lo'o ta'a ngula, Jacobo lo'o yu Xuhua, ndlyu yu lo'o Zebedeo sti yu ni' sca yca na'an, nxcuan su'hua yu quitan 'in yu, lo' msi'ya ñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cui' xaa mdyi'o yu ni' yca na'an can', ngula' ton yu 'in sti yu lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ña'aan se'en lyi'ya loo Galilea mda'an lo'o ñi cha' tsu'hue 'in Ndiose, lo'o se'en ndiyo' ti'in ne' judio, ngulo'o ñi ña'an ntsu'hui cha' culo Ndiose tñan 'in nten, lo' m'ni chca ñi 'in nchgaa nu ti'i lo'o cuati loo quicha. ");
INSERT INTO cya_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ña'aan se'en lyi'ya loo Siria mscua cueen cha' 'in ñi, mdiyan lo'o ne' 'in nu ti'i lo'o cuati loo quicha, a cunta lo'o nu ntsu'hui cui'in xa'an 'in, lo'o nu nxñi cui'in 'in, lo'o nu mchcun' quiya', lo' m'ni chca ñi 'in. ");
INSERT INTO cya_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Qui'an 'a nten mducui ncha'an 'in ñi nu mdo'o se'en lyi'ya loo Galilea, lo'o Decápolis, lo'o quichen Jerusalén, lo'o se'en lyi'ya loo Judea, a cunta nu mdo'o xca tso' chco tlyu Jordan. ");
INSERT INTO cya_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Xa na'an Jesús si'yana qui'an 'a nten mdiya ti'in can', ycuen ñi sca se'en nu cuaan la, lo' ña'aan yten tucua ñi mdiyaa yu ta'a nda'an ñi tloo ñi. ");
INSERT INTO cya_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Xacan' mdyisnan ngulo'o ñi 'in nten, lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Tsu'hue ca xu'hue nu ndyi'ya cha' tiyaa si'yana 'ni cha' 'in lo'o Ndiose, can' nu caja cha' tsu'hue 'in se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tsu'hue ca xu'hue nu ti'i nga'an 'in si'ya qui'ya m'ni, can' nu caja cha' tnu tiquee 'in. ");
INSERT INTO cya_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tsu'hue ca xu'hue nu suun nten lca, can' nu qui'ni ca'an 'in yuu se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tsu'hue ca xu'hue nu nguite' ti' lo' nguityi ti' cha' nu ñi 'in Ndiose, can' nu cha'an yu'hui cusya 'in. ");
INSERT INTO cya_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tsu'hue ca xu'hue nu ña'an 'tnan ti' 'in ta'a, can' nu caja nu ña'an 'tnan ti' 'in. ");
INSERT INTO cya_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tsu'hue ca xu'hue nu luhui cusya 'in, can' nu ña'an tloo 'in Ndiose tiyaa xaa. ");
INSERT INTO cya_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tsu'hue ca xu'hue nu ndiya nan ña'an tyi'in tsu'hue lo'o nchgaa tucui, can' nu ca naan sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tsu'hue ca xu'hue nu ndijin cha' si'ya tñan tsu'hue nu ngui'ni, can' nu caja cha' tsu'hue 'in se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tsu'hue ca xu'hue um xa caja nu ña'an ti'i, lo' chcui' ca'an 'in um si'ya cha' 'ñan, lo' tñan ne' scasca qui'ya 'in um. ");
INSERT INTO cya_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chcui ti' um lo' ca tsu'hue chu'hui tiquee um, si'yana tlyu cha' tsu'hue qui'ni ca'an 'in um la ni' cuaan, si'yana cuaña'an jui nu m'ni lyi'o 'in yu nu mxiycui' Ndiose 'in cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","'Un nguiaa cha' 'in um ña'an nchca ti' teje' lja nten chendyu, cha' teje' can' tyi'o tiyen' na, ¿ña'an ta tca ca tiyen' na xiya'? A la 'a cunajo'o na, tsaloo chcuan ti na lo' caja nu culo' su'hua 'in na. ");
INSERT INTO cya_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","'Un nguiaa cha' 'in um ña'an nchca ti' xaa nu ndu'hui loo chendyu, cui' cuaña'an sca quichen nu ndi'in sca loo qui'ya, a tca nu a ca chcan' na. ");
INSERT INTO cya_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","A tucui nu ca'an sca quii' lo' nde tucun ti'in 'in na, cui' ca nu cuaan chcua na si'yana tu'hui na xaa 'in nchgaa nu ndi'in ña'an can'. ");
INSERT INTO cya_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Cui' cuaña'an taa um ya' ca um sca xaa 'in nten chendyu, ña'an ca si'yana ca chcan' loo tñan tsu'hue nu ngui'ni um, lo' cu'ni tnu ne' 'in Stina Ndiose, ñi nu nducua ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","A quiñan ti' um ljyaan si'yana tyijyin lyoon 'in lee, lo'o cha' nu ngua'an scua yu nu mxiycui' Ndiose 'in cua' s'ni, si'i na xcuan tloon 'in na, cui' ca nu si'yana ca ja'an 'in na. ");
INSERT INTO cya_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nu cha' ñi cunen lo'o um, tsalja nu ti' chcan' ni' cuaan lo'o chendyu re, ñi sca cha' nu suhue lati nducua loo lee can', lo' a tyijyin cha' 'in na cuati ña'an, cui' ca nu tsato'o nchgaa cha' nu nducua loo na. ");
INSERT INTO cya_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Can' cha' nu cucha ti'in cha' nu suhue lati ngulo Ndiose tñan, lo' cha' cuaña'an culo'o can' 'in xca tucui, a caja nu su'hua loo 'in se'en ndlo Ndiose tñan. Una nu tucua tñan 'in na lo' culo'o 'in na, can' nu ca sca nu ndon loo se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Cunen lo'o um sca cha', cha' a lyee la quia nan um 'in Ndiose que ña'an ngui'ni ne' escriba lo'o ne' fariseo, a tca sten um se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Cua' ngune 'in um ña'an jui nu ycui' lo'o ne' mdi'in s'ni: —A cujui nten—, lo' nu cujui nten tyi'o qui'ya 'in lo' ca xñan bsya 'in. ");
INSERT INTO cya_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Una nan' cunen lo'o um, nu nscuen tique' lo'o ta'a, tyi'o qui'ya 'in lo' ca xñan bsya 'in. Ticui' cuaña'an cha' caja nu chcui' lo'o ta'a: Tijyi 'a nan, tyi'o qui'ya 'in can' se'en nchca cuiya' qui'ya. Lo' ña'an tucui ti nu chcui' lo'o ta'a: Tinto 'a, chen nchcui tsaa can' loo quii'. ");
INSERT INTO cya_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Can' cha' xa yan lo'o um sca lcuan 'in Ndiose, lo' lja xacan' quia yu'hui ti' um si'yana nducui ncha'an cha' 'in um lo'o ta'a um, ");
INSERT INTO cya_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","cula' scua um lcuan can', lo' quia y'ni chu'hue um cha' 'in um lo'o ta'a um culo nducua la, xacan' xitucui um, lo' tyaa um lcuan can' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ndla ti cu'ni chu'hue um cha' 'in um lo'o ta'a cusuun um tucueen nguiaa um, lja nu ti' lyijyi ca cuiya' cha' 'in um, ña'an tu' tyaa can' cunta 'in um tloo bse, lo' yu bse can' tyaa yu cunta 'in um yaa' silyiya, can' nu su'hua 'in um na'an chcuan. ");
INSERT INTO cya_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nu cha' ñi cunen lo'o um, a tyi'o um na'an chcuan, cha' si'i la su'hua lyiya' um nchgaa cunta nu nducui ncha'an 'in um. ");
INSERT INTO cya_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Cua' ngune 'in um ña'an jui nu ycui': —A sten yu'hui um lo'o cuilyi'o nten—. ");
INSERT INTO cya_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Una nan' cunen lo'o um, nu ñan' 'ya 'in sca ne' cuna'an, lo' su'hua cha' nducun' ni' cusya 'in lo'o ne', ña'an loo cha' cua' yten yu'hui lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Cha' si'ya quiloo um ngui'ni um qui'ya, lyoo um 'in na, tsu'hue lati nu ndiya lyijyi sca tso' quiloo um sten um ni' cuaan, lo' si'i nu ña'an chcui um tsaa um loo quii'. ");
INSERT INTO cya_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Cui' cuaña'an, cha' si'ya yaa' um cu'ni um qui'ya, si'yu co' um 'in na, tsu'hue lati nu ndiya lyijyi sca tso' yaa' um sten um ni' cuaan, lo' si'i nu ña'an chcui um tsaa um loo quii'. ");
INSERT INTO cya_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","A cunta jui nu ycui': —Sca yu qui'yu nu nchca ti' cula' ti'in 'in cuilyi'o, 'ni cha' tsa' scua sca quityi 'in yu—. ");
INSERT INTO cya_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Una nan' cunen lo'o um, yu nu cula' ti'in 'in cuilyi'o, lo' cha' si'i si'yana yten yu'hui ne' lo'o xca tucui, ña'an loo cha' nxicu'ni yu 'in ne' sten yu'hui ne' lo'o ña'an tucui ti, lo' yu nu ca cuilyi'o 'in can', lo'o can' cu'ni qui'ya. ");
INSERT INTO cya_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","A cunta cua' ngune 'in um ña'an jui nu ycui' lo'o ne' mdi'in s'ni: —A tyi'in tya ca um sca cha'—, cui' ca nu —tucua um tñan cha' nu tyi'in tyaa um tloo Ñi X'nan na—. ");
INSERT INTO cya_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Una nan' cunen lo'o um: Ñi sca cha' lo' a ntsu'hui cha' tyi'in tya ca um, ñi ni' cuaan lo' a cu'ni tyi'ya um si'yana la cua nducua Ndiose, ");
INSERT INTO cya_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ñi loo chendyu re si'yana nde nxitñan' quiya' ñi, ñi a cu'ni tyi'ya um quichen Jerusalén si'yana lca na quichen 'in ñi nu lca Ree. ");
INSERT INTO cya_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ñi a tyi'in tya ca um chendyu 'in um, si'yana ñi sca quichan' que um lo' a tca cu'ni um cha' ca mta na uta ca mten na. ");
INSERT INTO cya_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Xa chcui' um sca cha', ljuin um: Cui' na, uta, si'i na, si'yana cha' ti' tucua la um cha' can', cua' lo'o cha' cuiñi ljyan lo'o na. ");
INSERT INTO cya_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Cua' ngune 'in um jui nu ycui': —Cha' caja nu culo quiloo um, cui' cuaña'an cu'ni um lo'o can', cha' caja nu xityu lyi'ya um, ticui' cuaña'an cu'ni um—. ");
INSERT INTO cya_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Una nan' cunen lo'o um, a cu'ni su'hua um 'in um lo'o nu nducun', cui' ca nu cha' ycuan' yu sca tso' tloo um, tyaa um xca tso' na ycuan' yu. ");
INSERT INTO cya_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Cha' nde'en nu nchca ti' taa qui'ya 'in um lo' lyaa xcan' um, tyaa um 'in na 'in cui' ña'aan lo'o te' ycan' tnu tu'hua can' 'in um. ");
INSERT INTO cya_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Cha' caja nu xicu'ni 'in um cui'ya um su'hua sca kilometro, 'un cui'ya um 'in na tucua kilometro. ");
INSERT INTO cya_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cha' nde'en la na jñan ne' 'in um, tyaa um 'in na, cui' cuaña'an cha' ntsu'hui nu jñi' na 'in um, a cu'ni tiji um lo'o can'. ");
INSERT INTO cya_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Cua' ngune 'in um jui nu ycui': —Ña'an 'tnan ti' um 'in ta'a nten um—, lo' xcuan tloo um 'in ta'a cusuun um. ");
INSERT INTO cya_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Una nan' cunen lo'o um: Ña'an 'tnan ti' um 'in ta'a cusuun um, lo' chcui' um cha' tsu'hue lo'o nu nchcui' cha' ti'i 'in um, cu'ni um tsu'hue lo'o nu nxcuan tloo 'in um, jñan um 'in Ndiose si'ya cha' 'in nu ndaja 'in um lo' nducui ncha'an 'in um, ");
INSERT INTO cya_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","cuaña'an ca chcan' loo si'yana lca um sñe' Stina Ndiose, ñi nu nducua ni' cuaan, ñi nu n'ni cha' ndu'hui xaa 'in nten nducun' lo'o nten nu tsu'hue, lo' nxi 'ya ñi quioo 'in nten nu tsu'hue lo'o nten nu nducun'. ");
INSERT INTO cya_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Si'yana cha' chu'hui cha' tsu'hue 'in um lo'o tsalca nu ntsu'hui cha' tsu'hue 'in lo'o um, ¿ñi cha' tsu'hue ta nducua tloo um xacan'? ¿Ta si'i lo'o nten nu nducun' n'ni cuaña'an? ");
INSERT INTO cya_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Cha' chcui' cha' um 'in tsalca ta'a ti um, ¿ta nducua la ngui'ni um 'in xca tucui? ¿Ta si'i lo'o ne' gentil n'ni ne' cuaña'an? ");
INSERT INTO cya_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Can' cha' ca um sca nten nu ñi ndi'in cha' 'in, tsaña'an Sti um ñi nu nducua ni' cuaan, ñi ndi'in cha' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Xñi um cunta si'yana si'i tloo ña'an nten cu'ni um scasca loo cha' tsu'hue, ta si'yana taa ne' loo um, lo' cha' cuaña'an cu'ni um, a sca cha' tsu'hue qui'ni ca'an 'in um lo'o tso' 'in Stina Ndiose nu nducua ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Can' cha' xa taa um sca lcuan, a xicune um cha' can' tloo nten, si'yana cuaña'an ngui'ni sca nu a ñi ndi'in cha' 'in se'en n'ni tnu ne' 'in Ndiose, uta sca se'en la, ña'an ca si'yana caja nu taa loo can'. Nu cha' ñi cunen lo'o um, lo'o tsacan' ti cua' lca siya' can'. ");
INSERT INTO cya_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Una xa taa um sca lcuan, a ntsu'hui cha' ca jlyo ti' tso' ca 'in um na nu taa tso' cuen 'in um, ");
INSERT INTO cya_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","cunan ti ntsu'hui cha' taa um lcuan, lo' Sti um, ñi nu nan' 'ya nchgaa loo cha', xitucui ñi cha' tsu'hue 'in um tloo na'an nten. ");
INSERT INTO cya_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Xa chcui' lyi'o um 'in Ndiose, a cu'ni um tsaña'an n'ni nu a ñi ndi'in cha' 'in, si'yana nducui ti' can' ndyon nchcui' lyi'o 'in Ndiose se'en n'ni tnu ne' 'in ñi, uta sca se'en la, si'yana caja nu taa loo can'. Nu cha' ñi cunen lo'o um, lo'o tsacua ti ña'an cua' jui siya' can'. ");
INSERT INTO cya_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Una xa chcui' lyi'o um 'in Stina Ndiose, yten um ña'an 'in um lo' tucun um 'in na, lo' chcui' um lo'o ñi nu a chcan' nducua, lo' Sti um, ñi nu nan' 'ya nchgaa loo cha', xcuen ñi 'in um tloo na'an nten. ");
INSERT INTO cya_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Xa nchcui' lyi'o um 'in Ndiose, a chcui' um ticui' ti loo cha' tsaña'an n'ni ne' gentil nu a ndyu'hui lyoo 'in Ndiose, ñan ti' ne' ta si'yana qui'an cha' chcui' ne', caja nu cu'ni cunta 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A nchca cha' cu'ni um ña'an nu ngui'ni ne', si'yana ñi nu lca Sti um cua' jlyo ti' ñi cha' nu 'ni 'in um, siya' ti' lyijyi jñan um 'in na. ");
INSERT INTO cya_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Can' cha' xa chcui' lyi'o um 'in Ndiose, ndeña'an chcui' um: Ndiose Sti hua, 'un ñi nu nducua ni' cuaan, scati um ntsu'hui cha' cu'ni tnu hua 'in um. ");
INSERT INTO cya_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nchca ti' hua si'yana tsatlyu culo um tñan 'in hua, lo' cu'ni um tsaña'an nu lca tiquee um loo chendyu re, cui' tsaña'an ngui'ni um la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cunda scaa tsaan taa um na nu cunajo'o 'in hua. ");
INSERT INTO cya_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cu'ni um cha' tlyu ti' 'in hua si'ya qui'ya ngui'ni hua, si'yana cuaña'an ngui'ni hua cha' tlyu ti' 'in nchgaa nu ngui'ni cha' ngunan' lo'o hua. ");
INSERT INTO cya_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A taa um cha' cuiya' sten cha' ngunan' tiquee hua, cui' ca nu culo tso' um 'in hua sii' cha' ngunan' can', si'yana scati um ndlo um tñan, lo' tlyu cha' cuiya' ntsu'hui 'in um, tsala xaa cu'ni tnu hua 'in um. Amen. ");
INSERT INTO cya_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Cha' cu'ni um cha' tlyu ti' 'in ta'a nten um, cui' cuaña'an Sti um, ñi nu nducua ni' cuaan, cu'ni ñi cha' tlyu ti' 'in um, ");
INSERT INTO cya_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","una cha' a cu'ni um cha' tlyu ti' 'in ta'a nten um, ticui' cuaña'an Sti um, ñi nu nducua ni' cuaan, a cu'ni ñi cha' tlyu ti' 'in um si'ya qui'ya ngui'ni um. ");
INSERT INTO cya_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Xa cu'ni um ayuna, a taa um ya' ca xi'in tloo um tsaña'an n'ni nu a ñi ndi'in cha' 'in, n'ni xi'in can' tloo si'yana ca jlyo ti' nten si'yana ngui'ni ayuna. Nu cha' ñi cunen lo'o um, lo'o tsacua ti ña'an cua' jui siya' can'. ");
INSERT INTO cya_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Una xa cu'ni um ayuna, cu'ni chu'hue um 'in um, lo' ycui um tyi'a tloo um, ");
INSERT INTO cya_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","si'yana a ca chcan' ña'an si'yana ngui'ni um ayuna, cui' ca nu cu'ni um cha' can' tloo Stina Ndiose, ñi nu a chcan' nducua, lo' Sti um, ñi nu nan' 'ya nchgaa loo cha', xcuen ñi 'in um tloo na'an nten. ");
INSERT INTO cya_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","A so' ti'in um cha' cuilyiya' loo chendyu re, se'en nu sta 'ni 'in na lo' jlyo na, se'en nu sten yu cunan lo' cui'ya 'in na, ");
INSERT INTO cya_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","cui' ca nu so' ti'in um cha' cuilyiya' la ni' cuaan, se'en nu a tca sta 'ni 'in na, ñi a ntsu'hui cha' jlyo na, ñi yu cunan lo' a cui'ya 'in na. ");
INSERT INTO cya_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Si'yana se'en ndi'in cha' cuilyiya' 'in um, can' nguilyu cusya 'in um. ");
INSERT INTO cya_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Quiloo um ndu'hui na xaa 'in um, can' cha' xa nu tsu'hue xaa quiloo um, ti' ña'aan um mtsa'an yu'hui xaa can' 'in um, ");
INSERT INTO cya_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","una cha' a tsu'hue xaa quiloo um, ticui' cuaña'an ña'aan um tla yta um. Lo' cha' tla yta cha' tiyaa 'in um, ¿ña'an la ca ycui' ca tla yta can'? ");
INSERT INTO cya_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","A tucui nu tca chu'hui tucua x'nan, si'yana ña'an ti'i yu 'in sca, lo' xca can' lyee la chu'hui yu cunta 'in, uta lyee la su'hua loo yu 'in sca, lo' xca xcuan tloo yu 'in. Cui' cuaña'an a tca tyi'in tyaa um quiloo um 'in Ndiose, lo' ticui' xaa chcua quiloo um 'in cha' cuilyiya'. ");
INSERT INTO cya_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Can' cha' cunen lo'o um: A su'hua um cha' nduhue ti' tiquee um lo'o na nu cunajo'o 'in um, ñi ste' um lo' a chu'hui yuhue' ti' um. ¿Ta a ndon loo la chendyu 'in um que 'in cha' nchcu, cui' cuaña'an cunan' um, ta a ntsu'hui lyoo la na que 'in ste' um? ");
INSERT INTO cya_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xñi um cunta ña'an ndi'in cha' 'in quiñi, a ntya 'in jyaan, a sca na nxo' 'in, ñi a ntñan 'in ju'hua, una Sti um, ñi nu nducua ni' cuaan nxicu 'in 'in. ¿Ta si'i lyee la ntsu'hui lyoo um que 'in quiñi? ");
INSERT INTO cya_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Siya' lyee la nsu'hua um cha' nduhue ti' tiquee um, ¿ta ñan ti' um tca tya cula la um 'in um lo'o xca lii scun um? ");
INSERT INTO cya_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","A cunta lo'o te' nu ntsu'hui cha' co' um, ¿ñi cha' lyee 'a nsu'hua um cha' nduhue ti' tiquee um lo'o na? Xñi um cunta ña'an ndlyo sca yca quee nu nducua ni' quixin', a n'ni na tñan, ñi a ntñan na te', ");
INSERT INTO cya_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","una cunen lo'o um sca cha', ñi yu ree Salomón tsaña'an nu ncua cuilyiya' yu, lo' a tsu'hue la yco' yu que ña'an quee cua. ");
INSERT INTO cya_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Cha' cuaña'an nxico' Ndiose 'in quixin', cua' ñii tsu'hue ña'an na una quiaa quinan' na lo' tsaa na loo quii'. ¿Ta si'i nde lyee la xico' ñi 'in um, 'un nu jo'o ndiya qui'an ti' 'in ñi? ");
INSERT INTO cya_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Can' cha' a su'hua um cha' nduhue ti' tiquee um, ta ljuin um: ¿Ñi na cu na, ñi na co'o na, lo' ñi na co' na? ");
INSERT INTO cya_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Si'yana chon' nchgaa cha' re nchcua quiloo ne' gentil, una ñi nu lca Sti um, ñi nu nducua ni' cuaan, jlyo ti' ñi si'yana 'ni cha' 'in um lo'o nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Quia nan um 'in Ndiose culo nducua la, lo' tucua um tñan cha' nu ñi 'in ñi, lo' nchgaa cha' re tya cula lo'o ñi 'in um. ");
INSERT INTO cya_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Can' cha' a su'hua um cha' nduhue ti' tiquee um ña'an tyijyin um tsaan quiaa, si'yana quiaa cua' ljyan lo'o na cha' nduhue ti' 'in na, cui' lya lo'o cha' nu nchca tsaan re ñii. ");
INSERT INTO cya_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","A nchca cha' su'hua qui'ya ta'a um, si'yana a caja nu su'hua qui'ya 'in um. ");
INSERT INTO cya_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Si'yana tsaña'an nsu'hua um qui'ya 'in xca tucui, cuaña'an caja nu su'hua qui'ya 'in um, lo'o cuiya' nu nsu'hua cuiya' um, cui' cuaña'an caja nu su'hua cuiya' 'in um. ");
INSERT INTO cya_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Ñi cha' lyee 'a nxñi um cunta mti nu ntsu'hui quiloo ta'a nten um, lo' a n'ni cunta um co' yca nu ntsu'hui quiloo um? ");
INSERT INTO cya_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ña'an ta tca ljuin um 'in ta'a um: Tyaa um ya' culyoon mti nu ntsu'hui quiloo um, lo' cha' quiloo um ntsu'hui sca co' yca 'in na? ");
INSERT INTO cya_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","'Un ne' nu a ñi ndi'in cha' 'in, lyoo um co' yca nu ntsu'hui quiloo um culo nducua la, la xacan' ca chcan' tsu'hue 'in um culyoo um mti nu ntsu'hui quiloo xca tucui. ");
INSERT INTO cya_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","A su'hua um na nu luhui tloo xni', ñi a su'hua um na nu ntsu'hui lyoo 'in um tloo cuhue', ña'an tu' sti quiya' 'in 'in na, lo' xiton 'in lo'o um, can' cha' xñi um cunta 'in um lo'o nten. ");
INSERT INTO cya_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jñan um na nu nchca ti' um, lo' caja na 'in um, quia nan um cha' can' lo' quija lyoo na 'in um, chcui' um lo' caja nu sla tuna'an 'in um. ");
INSERT INTO cya_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Si'yana nchgaa nu jñan sca cha', a s'ni caja na 'in, lo' nu nan cha' can', a s'ni quija lyoo na 'in, lo' nu nchcui', a s'ni ndyijyi nu sla tuna'an 'in. ");
INSERT INTO cya_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Ti ña'an um ndi'in sñe' um, lo' xa jñan jaslya 'in um, ta xtyi ti' um taa um quee 'in can'? ");
INSERT INTO cya_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Uta cha' jñan cula 'in um, ta xtyi ti' um taa um cunaan 'in can'? ");
INSERT INTO cya_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Cha' 'un lca um nten nu nducun', lo' ndaa um na nu tsu'hue 'in sñe' um, ¿ña'an la ca Stina Ndiose, ñi nu nducua ni' cuaan, na a taa ñi cha' tsu'hue nu jñan um 'in ñi? ");
INSERT INTO cya_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Can' cha', tsaña'an nu nducua tloo um cu'ni nten lo'o um, cuaña'an ntsu'hui cha' cu'ni um lo'o ne', si'yana nde cha' nu nsu'hua lo'o ña'aan cha' nu nchcui' lee lo'o cha' nu ycui' yu nu mxiycui' Ndiose 'in cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Quia nan um ña'an sten um tuna'an nu lu'hui, si'yana xeen 'a tuna'an lo' xeen tucueen nu ndiyaa loo cha' ngunan', lo' qui'an 'a nten nguiten ne' tuna'an can'. ");
INSERT INTO cya_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Si'yana lu'hui tuna'an lo' titi tucueen nu ndiyaa se'en caja chendyu, lo' chin' nu nguija lyoo na 'in. ");
INSERT INTO cya_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Xñi um cunta 'in um lo'o yu cuiñi nu nchcui' si'yana Ndiose nxiycui' 'in, yu nu ngui'ni 'in tsaña'an nchca ti' sca slya', una cusya 'in yu nguia cha' 'in na ña'an nchca ti' 'ni la. ");
INSERT INTO cya_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Si'ya tñan nu n'ni yu tca chu'hui lyoo um 'in yu. ¿Ta tca cui'yu mti uva loo ti quiche', uta tyi'o mti higo loo yca quiche'? ");
INSERT INTO cya_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Cui' cuaña'an ndi'in cha' 'in sca yca: Cha' tsu'hue na, tsu'hue mti ndyi'yu loo na, lo' cha' a tsu'hue na, ticui' cuaña'an a tsu'hue mti ndyi'o loo na. ");
INSERT INTO cya_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Si'yana sca yca nu tsu'hue, a ntsu'hui cha' cui'yu mti nu a tsu'hue loo na, cui' cuaña'an sca yca nu a tsu'hue, a tca cui'yu mti nu tsu'hue loo na. ");
INSERT INTO cya_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Can' cha' nchgaa yca nu a ndyi'yu mti nu tsu'hue ña'an loo, xi'yu na lo' tsaa na loo quii'. ");
INSERT INTO cya_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Can' cha' si'ya tñan nu n'ni sca nten tca chu'hui lyoo na 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Si'i nchgaa nu nchcui': Ñi X'nan hua, Ñi X'nan hua, tca sten se'en ndlo Ndiose tñan, cui' ca nu tsalca nu nducua tñan ña'an nu nchca ti' Stin, ñi nu nducua ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Qui'an 'a nu chcui' lo'on tiyaa xaa, lo' ljuin: Ñi X'nan hua, Ñi X'nan hua, ¿ta si'i lo'o cha' cuiya' 'in um mda'an ycui' hua cha' tsu'hue re? ¿Ta si'i lo'o cha' cuiya' 'in um ngulo hua cui'in xa'an nu ntsu'hui 'in nten? ¿A cunta m'ni hua scasca cha' nu tnu lo'o cha' cuiya' 'in um? ");
INSERT INTO cya_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Xacan' xcuen 'in can': —A siya' yu'hui lyoon 'in um, tyi'o tso' um siin', 'un nu ngui'ni tñan ngunan'—. ");
INSERT INTO cya_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nu quine 'in cha' nu nchcuin' re, lo' ca ja'an 'in na, nguiaa cha' 'in can' tsaña'an nguiaa cha' 'in sca nten nu mdi'in tyaa suun na'an 'in loo quee nu tla. ");
INSERT INTO cya_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mdyisnan ngu'ya quioo lo' ycuen yla chco tlyu, a cunta yaan cui'in tnu nu mdijin se'en nducua na'an can', una a mdlyu na si'yana tsu'hue mdi'in suun na chon' quee can'. ");
INSERT INTO cya_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Una nu quine 'in cha' nu nchcuin' re, lo' a ca ja'an 'in na, nguiaa cha' 'in can' ña'an cha' 'in nten nu ndiya lyijyi cha' tiyaa 'in, nu mdi'in tyaa suun na'an 'in loo ysin. ");
INSERT INTO cya_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mdyisnan ngu'ya quioo lo' ycuen yla chco tlyu, yaan cui'in tnu lo' mxitlyu 'in na, lo' ña'aan na 'in yu ngujlyo na. ");
INSERT INTO cya_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Xa mdyi ycui' Jesús cha' can', lyee 'a yuhue ti' ne' ña'an cha' nu ndlo'o ñi, ");
INSERT INTO cya_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","si'yana lo'o cha' cuiya' ndlo'o ñi, lo' si'i ña'an ndlo'o ne' escriba. ");
INSERT INTO cya_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Xa mdo'o Jesús loo qui'ya lyo' ti can', qui'an 'a nten mducui ncha'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Xacan' yaan sca yu nu nguxen quitso' la 'in se'en ndon ñi, lo' mdyi'ya xtyin' yu tloo ñi lo' juin yu: Ñi X'nan hua, cha' nchca ti' um tca cu'ni chca um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús mxñii ñi yaa' ñi lo' yla' ñi 'in yu, lo' juin ñi: Nchca tin' cu'ni chcan 'in, quinu luhui lo'o quicha cua 'in. Ticui' xaa ngulyijyi quitso' la can' 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Xacan' juin Jesús 'in yu: Ña'an jan ñi, a chcui' lo'o ñi sca tucui, cui' ca nu tsaa lo' culo'o 'in tloo yu nu ntsu'hui cunta cha' 'in laa, lo' taa sca lcuan tsaña'an nu ngulo Moisé tñan, cuaña'an ca jlyo ti' nten si'yana cua' mchca. ");
INSERT INTO cya_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Xa mdiyaa Jesús tu'hua quichen Capernaum, sca x'nan sindatu yan ycua 'in ñi, lo' mdyisnan mjñan yu cha' tsu'hue 'in ñi, ");
INSERT INTO cya_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","lo' juin yu: Ñi X'nan hua, sca yu nguso 'ñan nscua yu la na'an 'ñan, ti'i 'a ndijin yu lo' a nchca tyi'an yu. ");
INSERT INTO cya_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Xacan' mxcuen Jesús 'in yu: Nan' tsa'an lo' cu'ni chcan 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","X'nan sindatu can' mxcuen 'in ñi: Ñi X'nan hua, a ntsu'hui suun 'ñan sten um ña'an 'ñan, tsaloo ti chcui' um sca cha' lo' chca nguso 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Si'yana lo'on nan' ntsu'hui nu ndlo tñan 'ñan, a cunta ndlon tñan 'in sca ta sindatu, lo' cha' cunen lo'o sca yu: Nde se'en tsaa, lo' tsaa yu. Cha' cunen lo'o xca yu: Quiaan nde re, lo' quiaan yu. Cha' chcuin' lo'o nguso 'ñan: Nde tñan cu'ni, lo' cu'ni yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Xa ngune 'in Jesús cha' can', yuhue 'a ti' ñi lo' juin ñi 'in nten nu nda'an ncha'an 'in ñi: Nu cha' ñi cunen lo'o um, ñi sca ne' Israel, lo' a ndiyaa ne' cuiya' tsaña'an ndiya qui'an ti' yu re 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cunen lo'o um sca cha', qui'an 'a ne' nu ntsu'hui cha' tyi'o luhua' se'en nchcua cucha, lo'o luhua' se'en nguiaa cucha, can' nu chcua sca se'en ti lo'o Abraham, lo'o Isaac, lo'o Jacob la ni' cuaan se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Una nu ntsu'hui ca cha' qui'ni ca'an 'in se'en ndlo Ndiose tñan, can' nu tsato'o quinu nde lyiya' se'en tla yta, lo' xi'ya yja cueen can' loo nu lyee tyijyin nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Xacan' juin Jesús 'in x'nan sindatu can': Quia lya, lo' tsato'o ña'an nu ndiya qui'an ti'. Ticui' xaa mchca nguso 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mdiyaa Jesús la na'an 'in yu Tyo, lo' na'an ñi si'yana jyi'an laa yu nscua ti'i lo'o tique'. ");
INSERT INTO cya_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yla' ñi yaa', lo' cui' xaa mdyi'o tique' can', mdyiton ne' lo' mdyisnan m'ni cunta ne' 'in jun. ");
INSERT INTO cya_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Xa ngu'ya tla mdyisnan mdiyan lo'o ne' qui'an 'a nu ntsu'hui cui'in xa'an 'in se'en ndon ñi, lo' ngulo ñi cui'in xa'an can' si'ya cha' nu ycui' ñi, lo' m'ni chca ñi 'in nchgaa nu ti'i, ");
INSERT INTO cya_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","si'yana chcua cha' nu mxiycui' Ndiose 'in yu Isaía xa juin yu: —Cui' ñi ngu'ya ñi quicha 'in na, lo' mdijin ñi nu ti'i tñan loo na—. ");
INSERT INTO cya_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na'an Jesús si'yana qui'an 'a nten msu'hua lo'o 'in ñi, can' cha' mdi'in tyaa ñi cha' si'yana tyijyin xi'yu jun xca tso' tiyo'. ");
INSERT INTO cya_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yaan sca yu escriba se'en ndon ñi lo' juin yu 'in ñi: 'Un ñi nu lca Bstro, chcui ncha'an 'in um nchgaa se'en tsaa um. ");
INSERT INTO cya_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mxcuen Jesús 'in yu: Sca cuta' nducua tyi 'in, cui' cuaña'an quiñi ntsu'hui ten 'in, una Yu Qui'yu nu Mdo'o nde ni' Cuaan, a ndyijyi se'en nxitñan' yu. ");
INSERT INTO cya_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Xca yu nu nducui ncha'an 'in ñi juin yu 'in ñi: Ñi X'nan hua, taa um cha' cuiya' quia tsin' 'in stin culo nducua la. ");
INSERT INTO cya_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mxcuen Jesús 'in yu: Chcui ncha'an 'ñan, si'yana a s'nan nu chu'hui yuhue' ti' cutsi' 'in nu cua' ngujui. ");
INSERT INTO cya_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ña'aan yten Jesús ni' yca na'an, cua' lo'o yu ta'a nda'an ñi yten 'in na. ");
INSERT INTO cya_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cui' xaa ti can' yaan sca quio cui'in tnu, lo' mdyisnan nguitsa tiyo' can', mdyiton sten na lo' ncho'o ti'in na 'in yca na'an can', una Jesús nscua lja' ñi. ");
INSERT INTO cya_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yu ta'a nda'an ñi ngulyoo sla ñi lo' juin 'in ñi: ¡Ñi X'nan hua, culo laa um 'in hua, cua' quityin' yu'hui ti na! ");
INSERT INTO cya_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Juin ñi 'in yu: ¿Ñi cha' ta nguitsen um, ta jo'o 'a ndiya qui'an ti' um? Xacan' mdyiton ñi, lo' ngusun lo'o ñi 'in cui'in can' lo'o tiyo' can', lo' cui' xaa mdi'in tiin na. ");
INSERT INTO cya_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ndyijyin ya' yuhue ti' yu ta'a nda'an ñi lo' juin yu: ¿Tucui ca lca ñi re, ñi cha' hasta cui'in lo'o tiyo' re, lo' ja'an na 'in ñi? ");
INSERT INTO cya_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Xa mdiyaa jun xca tso' tiyo' can' se'en lca loo yuu 'in ne' Gadara, yan ycua tucua yu nu ntsu'hui cui'in xa'an 'in, nu mdo'o ni' lyi'o se'en nguitsi' nten, ndyijyin cuiya' la yu, ñi a tucui 'a xtyi ti' tyijyin tucueen can'. ");
INSERT INTO cya_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ycui' cueen yu: Jesús, 'un ñi nu lca Sñe' Ndiose, ¿ñi cha' ljyan taa um cha' nsin' ti' 'in hua? ¿Ta na ljyaan um xitijin um 'in hua nu ti'i, lo' na ti' lyijyi tiyaa xaa 'in hua? ");
INSERT INTO cya_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Cua' tijyo' chin' nda'an nan ycu sca ta tlyu cuhue'. ");
INSERT INTO cya_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Cui'in xa'an can' mjñan cha' tsu'hue 'in ñi, lo' juin: Cha' ntsu'hui tiquee um culo um 'in hua, una taa um cha' cuiya' sten hua 'in cuhue' cua. ");
INSERT INTO cya_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mxcuen ñi 'in: Yaa um. Cui' xaa mdo'o cui'in xa'an can' lo' yten se'en ndi'in cuhue' can', cui' ña'an lcaa mdo'o 'in msnan 'in, lo' tsatlyu mxityu loo 'in loo tiyo' can', can' ngujui yu'hui 'in. ");
INSERT INTO cya_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yu nu na'an seen 'in 'in, msnan yu nguiaa yu nde quichen, mdaa yu suun cha' nu yato'o, lo'o cha' 'in yu nu ntsu'hui cui'in xa'an can' 'in. ");
INSERT INTO cya_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ña'aan quichen ne' ya ycua ne' 'in Jesús. Lo' xa na'an ne' 'in ñi, mjñan ne' cha' tsu'hue 'in ñi si'yana xitucui ñi nde se'en mdo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Xacan' yten ñi ni' yca na'an can', mdyi'o ca'an ñi xca tso' lo' nguila ñi quichen se'en ndi'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yato'o mdiyan lo'o ne' sca yu ti'i nscua loo qui'ñan se'en ndon ñi, lo' a nchca tyi'an yu. Xa na'an Jesús si'yana lyee ndiya qui'an ti' yu nu ndiya lo'o 'in nu ti'i can', xacan' juin ñi 'in nu ti'i can': Sñen', cu'ni tnu tiquee, cua' nguten qui'ya 'in. ");
INSERT INTO cya_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lja can' nducua tucua snan ne' escriba, lo' ñan ti' ne': Yu re, nchcui' ca'an yu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús, cui' xaa ngujlyo ti' ñi ña'an cha' nu ñan ti' ne', lo' juin ñi 'in ne': ¿Ñi cha' ñan ti' cusya 'in um cha' ngunan'? ");
INSERT INTO cya_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ti ña'an ta cha' a tucui la chcuin' lo'o yu ti'i re: Ta cunen lo'o yu, cua' nguten qui'ya 'in, uta na cunen lo'o yu, tyiton, xñi s'ñan lo' quiaa? ");
INSERT INTO cya_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ca jlyo ti' um si'yana lo'on nan', Yu Qui'yu nu Mdo'o nde ni' Cuaan, ntsu'hui cha' cuiya' 'ñan xicuten qui'ya 'in nten, (xacan' juin ñi 'in yu ti'i can'): Tyiton, xñi s'ñan lo' quiaa nde ña'an 'in. ");
INSERT INTO cya_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cui' xaa mdyiton yu ti'i can', lo' nguiaa yu nde ña'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Xa na'an ne' cha' nu yato'o, ndyijyin ya' yuhue ti' ne lo' m'ni tnu ne' 'in Ndiose, si'yana tsacua ña'an cha' cuiya' mdaa ñi 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Xacan' mdo'o Jesús nguiaa ñi, se'en mdijin ñi, can' na'an ñi sca yu naan Mateo, nducua yu se'en nsu'hua lyiya' nten tñi, lo' juin ñi 'in yu: Chcui ncha'an 'ñan. Cui' xaa mdyiton yu lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yato'o sca tsaan mdiyaa ñi sca na'an, lo' yten tucua ñi tu'hua msa lo'o yu ta'an nda'an ñi, a cunta qui'an nu mdiya ti'in can', ne' nducun' lo'o yu nu ndlo tñi, tsatlyu mducua ne' lo'o Jesús. ");
INSERT INTO cya_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Xa na'an ne' fariseo cha' re, juin ne' 'in yu ta'a nda'an ñi: ¿Ñi cha' sca se'en ti nchcu yu nu lca Bstro 'in um lo'o yu nducun', lo'o yu nu ndlo tñi? ");
INSERT INTO cya_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Xa ngune 'in Jesús cha' nu ycui' ne', xacan' juin ñi: Nten nu tsu'hue lca 'in, a 'ni cha' 'in ne' lo'o nu n'ni rmiyu, una nu ti'i can' nu 'ni cha' 'in. ");
INSERT INTO cya_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Quia nan um cha' tiyaa 'in um ñi cha' nchca ti' chcui' cha' re: —Cha' tsu'hue nu tyi'o ni' cusya 'in um nchca tin', lo' si'i nu tiquin tucua um 'ni tloon—. Si'yana a ljyan nan 'in nten nu cua' lca tsu'hue, cui' ca nu 'in nten nu ngui'ni qui'ya, si'yana xilo'o chon' ne' cha' ngunan' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yato'o sca tsaan mdiyaa tucua snan ta'a nda'an yu Xuhua, lo' mñicha' yu 'in Jesús: ¿Ñi cha' huare' lo'o ne' fariseo lyee 'a n'ni hua ayuna, lo' yu ta'a nda'an um a n'ni yu ayuna? ");
INSERT INTO cya_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Lo' juin Jesús 'in yu: ¿Ta tca tyi'in lu'un ti' nten nu ndi'in se'en ndyija cuilyi'o ne', cha' na ti' nducua yu nu ndyija cuilyi'o can'? Una tsa tucua tsaan, yu nu ndyija cuilyi'o can', a la 'a quine cueen yu, la xacan' cu'ni ne' ayuna. ");
INSERT INTO cya_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","A tucui nu nxcuan su'hua sca te' cula lo'o tsa yu'hue te' tiji, si'yana te' tiji can' xiya' na, lo' se'en mda' 'in na quita lyijyi na. ");
INSERT INTO cya_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Cui' cuaña'an a tucui nu nsu'hua vino nu cui ti ni' sca cuijyin quijyin nu cula, si'yana cha' cu'ni ne' cuaña'an, cutsu quijyin can' lo' quilo vino can', a cunta jlyo quijyin can'. Can' cha' nsu'hua ne' vino nu cui ti ni' sca cuijyin quijyin nu cui ti, lo' ñi sca na lo' a jlyo na xacan'. ");
INSERT INTO cya_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lja nu ti' nchcui' ñi cha' can' mdiyaan sca yu nu ndon loo quichen can' se'en ndon Jesús, mdyi'ya xtyin' yu tloo ñi lo' juin yu: Sca sñen' nan' nu cuna'an tca ngujui, cu'ni um sca cha' tsu'hue tsaa um lo' tyi'in tyaa um yaa' um que, lo' tyiqui'o. ");
INSERT INTO cya_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Cui' xaa mdo'o Jesús nguiaa ñi lo'o ta'a nda'an ñi la na'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Una nde chon' ñi mducui ncha'an sca ne' cuna'an, nu cua' ntsu'hui tichcua yjan ti'i lo'o quicha nguilo tne, cui' ti mdiyaa ne' lo' yla' ne' tu'hua ste' ñi, ");
INSERT INTO cya_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","si'yana ndeña'an ñan ti' ne': Si cua' tsu'hue ste' ti ñi culan', lo' chcan. ");
INSERT INTO cya_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Una Jesús mxiton ñi lo' na'an ñi 'in ne', lo' juin ñi: Sñen', cu'ni tnu tiquee, cua' mchca si'yana ndiya qui'an ti'. Ticui' xaa can' mchca ne'. ");
INSERT INTO cya_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Xa yten Jesús ña'an 'in yu nu ndon loo can', na'an ñi si'yana cua' ndi'in yla yu cuhuii, a cunta qui'an nten cua' ndi'in can'. ");
INSERT INTO cya_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lo' juin ñi 'in ne': Quia lya um, si'yana si'i na ngujui cuhui' re, na lja' ti cuhui'. Xacan' mstyi lyi'o ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Xa cua' m'ni ñi cha' mdyi'o ne' nde lyiya', yten ñi ña'an, msñi ñi yaa' cuhui' can', lo' cui' xaa mdyitucui cuhui'. ");
INSERT INTO cya_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ña'aan se'en can' mscua cueen cha' nu yato'o. ");
INSERT INTO cya_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Xa mdo'o Jesús nguiaa ñi, tucua yu cuityin' mducui ncha'an 'in ñi, msi'ya yja cueen yu, lo' nchcui' yu: 'Un ñi nu lca Sñe' ta nten 'in Davi, ña'an 'tnan ti' um 'in hua. ");
INSERT INTO cya_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Xa mxitucui ñi nde ña'an, mdiya ncha'an yu cuityin' can' 'in ñi, lo' juin Jesús 'in yu: ¿Ta ndiya qui'an ti' um si'yana tca cu'ni chcan 'in um? Mxcuen yu: Ndiya qui'an ti' hua, Ñi X'nan hua. ");
INSERT INTO cya_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Xacan' yla' ñi quiloo yu lo' juin ñi: Cui' tsaña'an ndiya qui'an ti' um, lo' cuaña'an tsato'o na. ");
INSERT INTO cya_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Cui' xaa nguila xaa quiloo yu. Una Jesús tla mdi'in tyaa ñi cha' lo'o yu lo' juin ñi: Ña'an jan ñi, a chcui' um lo'o ñi sca tucui cha' re. ");
INSERT INTO cya_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Una xa mdo'o yu nguiaa yu, mdyisnan m'ni cueen yu cha' 'in ñi sca chcui se'en can'. ");
INSERT INTO cya_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ña'aan mdo'o yu se'en can', cua' mdiyan lo'o ne' sca yu cu'un nu ntsu'hui cui'in xa'an 'in. ");
INSERT INTO cya_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Xa ngulo ñi cui'in xa'an can', yu cu'un can' cui' xaa mdyisnan ycui' yu. Ndyijyin ya' yuhue ti' nten lo' nchcui' ne': Ñi siya' lya ña'an na cha' nu cuaña'an se'en lca Israel. ");
INSERT INTO cya_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Una ne' fariseo juin ne': Lo'o cha' cuiya' 'in x'nan cui'in xa'an, ndlo yu re cui'in xa'an ntsu'hui 'in nten. ");
INSERT INTO cya_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús mdyisnan mdijin ñi scasca quichen tnu lo'o quichen suhue ti, ndlo'o ñi 'in nten se'en n'ni tnu ne' 'in Ndiose, nchcui' ñi cha' tsu'hue 'in ñi ña'an ntsu'hui cha' culo ñi tñan 'in nten, lo' ngui'ni chca ñi 'in nchgaa nu ti'i lo'o cuati loo quicha. ");
INSERT INTO cya_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Xa na'an ñi 'in nten qui'an can' mña'an 'tnan ti' ñi 'in ne', si'yana lca ne' ña'an nchca ti' slya' nu a ntsu'hui x'nan, sca nu cua' ña'an nda'an ti, lo' a tucui nu ntsu'hui cunta 'in. ");
INSERT INTO cya_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Xacan' juin ñi 'in yu ta'a nda'an ñi: Nu cha' ñi s'ni, qui'an 'a tñan ndi'in lo' chin' nguso 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Can' cha' jñan um 'in ñi nu lca X'nan tñan re, lo' ca'an tñan ñi nguso 'in ñi loo xñan ñi. ");
INSERT INTO cya_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Xacan' msi'ya ñi 'in tsa tichcua yu nu ca ta'a tyi'an ca ñi, lo' mdaa ñi cha' cuiya' 'in yu si'yana culo yu cui'in xa'an nu ntsu'hui 'in nten, lo' cu'ni chca yu nchgaa nu ti'i lo'o cuati loo quicha. ");
INSERT INTO cya_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ndeña'an naan ta'a tichcua yu nu lca apóstol: Nu culoo can' lca yu Simón nu nchcui' ne' lo'o lca Tyo, lo'o yu Ndre ta'a ngula yu, lo'o Jacobo lo'o yu Xuhua, sñe' Zebedeo, ");
INSERT INTO cya_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","yu Lpe, yu Bartolomé, yu Toma, lo'o Mateo nu ngulo tñi, yu Jacobo, sñe' Alfeo, yu Lebeo nu nchcui' ne' lo'o lca Tadeo, ");
INSERT INTO cya_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","yu Simón nu lca ne' cananista, lo'o yu Juda Iscariote, yu nu mdyaa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tsa tichcua yu re ngua'an tñan Jesús 'in yu, lo' ngulo'o ñi 'in yu ña'an ntsu'hui cha' cu'ni yu, lo' juin ñi: A nchca cha' tsaa um se'en ndi'in ne' gentil, ñi quichen Samaria lo' a sten um, ");
INSERT INTO cya_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","cui' ca nu culo nducua la tsaa um lo'o ne' Israel, cui' slya' nu ngunan' yu'hui can'. ");
INSERT INTO cya_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cua' yaa ña'an nda'an um, chcui' um lo'o ne': Cua' nchcui cuii' cha' culo Ndiose tñan 'in nten. ");
INSERT INTO cya_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cu'ni chca um nu ti'i, lo'o nu ndon quitso' la 'in, xiqui'o um nu cua' ngujui, lo' culo um cui'in xa'an nu ntsu'hui 'in nten. Cha' tsu'hue nu cua' jui 'in um, cui' cuaña'an taa um 'in na 'in xca tucui. ");
INSERT INTO cya_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A nchca cha' cui'ya um tñi, ");
INSERT INTO cya_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ñi cuijyin lo' a cui'ya um, ñi a cui'ya um xca ta ste' um, ñi quinan, ñi yca lo' a chcua yaa' um, si'yana sca yu nu n'ni tñan ntsu'hui suun 'in yu cu yu loo tñan nu ngui'ni yu. ");
INSERT INTO cya_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Xa tiyaa um scasca quichen cunan um se'en quinu um, can' quinu um tsalja tyi'in um quichen can'. ");
INSERT INTO cya_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chcui' cha' um xa sten um na'an can'. ");
INSERT INTO cya_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Cha' nten can' cuan xu'hue ne' 'in um, chcua tucui ne' cha' tsu'hue, una cha' a cuan xu'hue ne' 'in um, a chcua tucui ne' cha' tsu'hue can'. ");
INSERT INTO cya_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Cha' siya' ti a cuan xu'hue ne' 'in um lo'o cha' nu nchcui' um, tyi'o um se'en can' lo' scuin um yuu quiya' um, quinu cunta 'in ne' cha' nde'en la cha' caan 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nu cha' ñi cunen lo'o um, xa cu'ni Ndiose xñan bsya 'in nten chendyu, nten ndi'in quichen can', lyee la tyijyin ne' nu ti'i que ña'an ntsu'hui cha' tyijyin ne' Sodoma lo'o Gomorra. ");
INSERT INTO cya_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ña'an jan ñi, nan' ca'an tñan 'in um tsaa um ña'an nchca ti' sca slya' lja 'ni la, can' cha' tyi'an tiyaa um ña'an nda'an sca cunaan, lo' suun ña'an cu'ni um 'in um ña'an nchca ti' sca scun' jo'o. ");
INSERT INTO cya_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xñi um cunta 'in um lo'o nten, si'yana ntsu'hui cha' tyaa ne' cunta 'in um tloo bsya, lo' jyi'in ne' 'in um se'en n'ni tnu ne' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lo' hasta tloo gubierno lo'o ree ntsu'hui cha' tyaa ne' cunta 'in um si'ya cha' 'ñan, ña'an ca si'yana taa um suun lo'o can' tsatlyu lo'o ne' gentil ña'an ndi'in cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Xa tyaa ne' cunta 'in um tloo bsya, a chu'hui yuhue ti' um ña'an ntsu'hui cha' xcuen um, lo' ñi cha' nu chcui' um, si'yana lja xacan' caja cha' nu chcui' um, ");
INSERT INTO cya_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","una si'i lo'o cha' tiyaa 'in um, cui' ca nu Espíritu 'in Stina Ndiose xiycui' 'in um xacan'. ");
INSERT INTO cya_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","A cunta yu qui'yu ntsu'hui cha' tyaa yu 'in ta'a ngula yu se'en caja nu cujui 'in, cui' cuaña'an tyaa ne' 'in sñe' ne', lo' sñe' ne' ca ti'i ti' 'in ne' lo' tyaa can' 'in nten cula 'in se'en caja nu cujui 'in. ");
INSERT INTO cya_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nchgaa tucui ntsu'hui cha' xcuan tloo 'in um si'ya cha' 'ñan, una nu ta loo tsaya' tsatii cha' nu nchca loo chendyu re, can' nu tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Xa tyisnan cu'ni lyi'o ne' 'in um quichen se'en tiyaa um, tsaa um xca quichen. Nu cha' ñi cunen lo'o um, ñi a nchca tyi'o yso um ña'aan se'en lca Israel, xa quiaan Yu Qui'yu nu Mdo'o nde ni' Cuaan xiya'. ");
INSERT INTO cya_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sca nu ngui'ni cha'an, a ndon loo la que 'in nu ndlo'o 'in, cui' cuaña'an lo'o sca nguso, a ndon loo la que 'in x'nan. ");
INSERT INTO cya_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nu ngui'ni cha'an can', quinu tsu'hue tiquee ca ña'an nchca ti' nu ndlo'o 'in, cui' cuaña'an nguso can', quinu tsu'hue tiquee ca ña'an nchca ti' x'nan. Ñi nu lca x'nan jun nu ndi'in sca na'an, cha' ndlo'o naan ne' 'in lca Beelzebú, x'nan cui'in xa'an, ¿ña'an la ca ljuin um 'in nchgaa la ña'an jun nu ndi'in na'an can'? ");
INSERT INTO cya_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Can' cha' a cutsen um 'in nten, si'yana a sca cha' nu nchca cunan ti, ta a ca chcan' loo na, lo' nchgaa na nu nchca cutsi' ti, ndyi'o yne cha' 'in na. ");
INSERT INTO cya_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Cha' nu chcuin' lo'o um se'en tla, chcui' la um 'in na cucha xaa, cha' nu ngune 'in um cunan ti, tca chcui' cueen um 'in na sca se'en la. ");
INSERT INTO cya_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A cutsen um 'in nu ndujui nten, si'yana a lo'o cusya 'in um tca cujlyo can', cui' ca nu cutsen um 'in ñi nu tca su'hua 'in um lo'o cusya 'in um loo quii'. ");
INSERT INTO cya_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Ta si'i lo'o jacua tñi ti nxi'i ne' tucua quiñi? Siya' cuaña'an, lo' a caja cha' cuiya' tyu 'in, cha' si'i si'ya cha' cuiya' 'in Stina Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hasta quichan' que um, lo' cua' lca ncua na 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Can' cha' a su'hua um cha' tiquee um, si'yana qui'an la ntsu'hui lyoo um que 'in qui'an quiñi. ");
INSERT INTO cya_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ña'an nu ti nu cuan xu'hue 'ñan, cui' cuaña'an cuan xu'huen 'in can' tloo Stin, ñi nu nducua ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Una nu xcuan tloo 'ñan, cui' cuaña'an xcuan tloon 'in can' tloo Stin, ñi nu nducua ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","A quiñan ti' um ta si'yana ljyaan, can' cha' tyi'in tsu'hue nten, cui' ca nu si'ya cha' 'ñan tyisnan xuun ne'. ");
INSERT INTO cya_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cuaña'an tsato'o —yu qui'yu xuun yu lo'o sti yu, ne' cuna'an xuun ne' lo'o jyi'an ne', cui' cuaña'an ne' cuna'an xuun ne' lo'o jyi'an laa ne', ");
INSERT INTO cya_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ticuii' jun nu ndi'in na'an chca ta'a cusuun jun—. ");
INSERT INTO cya_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nu lyee la nsu'hua loo 'in sti lo'o jyi'an que 'ñan nan', a tca chcui ncha'an 'ñan. Cui' cuaña'an nu lyee la nsu'hua loo 'in sñe' yu qui'yu uta nu cuna'an que 'ñan nan', a tca chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Cha' a cua' m'ni tiquee can' tyaa 'in siya' ti si'ya cha' 'ñan, a tca chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Si'yana nchgaa nu ñan ti' culo laa 'in ticuii', tsato'o quinan' can' tiyaa xaa, una nchgaa nu tyaa cusya 'in 'ñan, can' nu tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nu cuan xu'hue 'in um, lo'o 'ñan nan' cuan xu'hue can', lo' nu cuan xu'hue 'ñan, cui' cuaña'an cuan xu'hue 'in ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu cuan xu'hue 'in sca nu nda'an ycui' cha' 'in Ndiose, si'ya cha' 'ñan, scaña'an ti qui'ni ca'an cha' tsu'hue 'in lo'o nu nchcui' can'. Nu cuan xu'hue 'in sca nu ngui'ni tñan tsu'hue, si'ya cha' 'ñan, scaña'an ti qui'ni ca'an cha' tsu'hue 'in lo'o nu ngui'ni tñan can'. ");
INSERT INTO cya_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ña'an tucui ti nu taa siya' sca vaso ti tyi'a co'o nu jo'o la ndi'in cha' 'in re, cui' si'yana ngui'ni cha'an 'ñan, nu cha' ñi cunen lo'o um, a quinan' xu'hue ntsu'hui 'in can'. ");
INSERT INTO cya_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Xa mdyi cha' nu ngulo'o Jesús 'in tsa tichcua yu ta'a nda'an ñi, mdo'o ñi se'en can', nguiaa ñi scasca quichen, ngulo'o ñi lo' ycui' ñi cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti' se'en ntsu'hui yu Xuhua na'an chcuan ynan yu cha' nchgaa tñan nu ngui'ni Cristo, xacan' ngua'an tñan yu tucua ta'a nda'an yu se'en ndlyu ñi. ");
INSERT INTO cya_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nde cha' nu mñicha' yu 'in ñi: ¿Ta cui' um lca um ñi nu ntsu'hui cha' caan, uta na quita na 'in xca tucui? ");
INSERT INTO cya_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Xacan' mxcuen Jesús 'in yu: Quia ytsa' um 'in yu Xuhua nchgaa cha' nu ngune 'in um lo' na'an um cua' ñii: ");
INSERT INTO cya_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","—Nu cuityin' nguila xaa quiloo, nu co' quiya' nchca ndyi'an—, nu ti'i lo'o quitso' la nguinu luhui can', —lo'o nu cu'un cua' ne 'in—, lo' nu ngujui ndyiqui'o, —lo' nu ti'i ña'an chendyu 'in ndyijyi nu nchcui' cha' tsu'hue 'in Ndiose lo'o—. ");
INSERT INTO cya_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tsu'hue ca xu'hue nu a ngui'ni tucua ti' lo'on. ");
INSERT INTO cya_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Xa mdo'o nu ngua'an tñan yu Xuhua can' nguiaa, xacan' mdyisnan ycui' Jesús lo'o nten can' cha' 'in yu Xuhua, lo' juin ñi: ¿Ñi na ya nan' 'ya um se'en ngutyi cua? ¿Ta cui' 'in quii nu mcha ti'in cui'in can'? ");
INSERT INTO cya_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cha' si'i, ¿ñi na ta nan' 'ya um xacan'? ¿Ta cui' 'in sca yu qui'yu nu lco' te' tsu'hue ña'an? Ña'an jan ñi, nu lco' te' tsu'hue ña'an, can' nu ndi'in na'an 'in ree. ");
INSERT INTO cya_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Tucui na'an um cha' na can'? ¿Ta sca nu nxiycui' Ndiose 'in? Cui' yu, una cunen lo'o um sca cha': Ndon loo la can' que 'in sca nu nxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ndeña'an nguinu scua sca cha' loo quityi cha' 'in yu Xuhua: —Ña'an jan ñi, ca'an tñan 'in sca nu chcua loo, cu'ni chu'hue tucueen nu tsaa—. ");
INSERT INTO cya_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ña'an jan ñi, tsalca nten nu cua' mdiyaan loo chendyu re, ñi sca yu nu mxiycui' Ndiose 'in, lo' a ndon loo la can' que ña'an Xuhua nu mducua tya 'in nten. Una cua' ñii tsaña'an nu ndlo Ndiose tñan 'in nten, nu chin' la cha' 'in, can' nu ndon loo la que ña'an cha' 'in yu Xuhua. ");
INSERT INTO cya_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ti' tsaan nu mda'an yu Xuhua mducua tya 'in nten hasta cua' ñii, tsaña'an ntsu'hui cha' culo Ndiose tñan 'in nten, ljyan nguilo na lo'o sca cha' cuiya' nu tlyu, lo' tsalca ti nu tnu tiquee nguiten loo cha' can'. ");
INSERT INTO cya_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Si'yana nchgaa yu nu mxiycui' Ndiose 'in cua' s'ni lo'o cha' 'in lee nu nguinu scua, nchcui' si'yana cuaña'an tsato'o tsaan nu caan yu Xuhua. ");
INSERT INTO cya_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Cha' nchca ti' um cuan xu'hue um cha' re, yu Xuhua can' ca lca yu Elía nu ntsu'hui cha' caan, tsaña'an cha' nu nguinu scua. ");
INSERT INTO cya_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nchgaa nu ndon nscan cha' nu ycuin' re cu'ni cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Ña'an ta cha' nu tca tyi'in tyaan lo'o ta nten re ña'an nu nguiaa cha' 'in ne'? Nguiaa cha' 'in ne' re, ña'an cha' 'in nu suhue ti nu ndi'in loquiya' lo' nxi'ya ta'a, ");
INSERT INTO cya_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","lo' nchcui': Yla hua cuhuii quii, lo' a yla quiya' um, yla hua jyiin nu nguitsi' nten, lo' ñi a mdi'in ynan um. ");
INSERT INTO cya_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Xa mdiyaan yu Xuhua nu mducua tya nten, lo' si'yana a ycu yu ñi a yi'o yu, can' cha' juin um: Cui'in xa'an ntsu'hui 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Cua' ñii mdiyaan Yu Qui'yu nu Mdo'o nde ni' Cuaan, lo' si'yana nchcu yu lo' ndyi'yo yu, can' cha' nchcui' um: Yu re lca yu sca nu tucun' lo'o cha' nchcu, yu cu'hui, lo' ta'a tsu'hue yu 'in nu ndlo tñi lo'o nu nducun'. Si'ya cha' tiyaa nu ñi nchca chcan' loo scasca tñan nu tsu'hue. ");
INSERT INTO cya_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Xacan' mdyisnan ngusun lo'o ñi 'in scasca quichen se'en m'ni ñi cha' nu tnu, si'yana a mslyaa ne' xilo'o chon' ne' qui'ya 'in ne', lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","'Tnan ca um, 'un nu ndi'in quichen Corazín, lo' 'tnan ca um, 'un nu ndi'in quichen Betsaida, tsala ña'an cha' nu tnu cua' m'nin tloo um, lo' cha' cua na m'nin cha' re nde quichen Tiro lo'o Sidón, cua' s'ni mxilo'o chon' ne' qui'ya 'in ne', lo' ca chcan' loo si'yana ti'i nga'an 'in ne' lo'o ña'an nu nchco' ne' a cunta lo'o ña'an nu n'ni ne'. ");
INSERT INTO cya_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Can' cha' cunen lo'o um sca cha': Tsaan nu ntsu'hui cha' ca xñan bsya 'in nten chendyu, lyee la tyijyin um nu ti'i que ña'an nu tyijyin quichen Tiro lo'o Sidón. ");
INSERT INTO cya_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A cunta 'un nu ndi'in quichen Capernaum, —xque' ti' um si'yana cua' jui xu'hue um la ni' cuaan, una tiyaa xaa caja nu su'hua 'in um se'en ndyijyin ne' nu ti'i—, lo' cha' cua na m'nin cha' nu tnu quichen Sodoma tsaña'an nu m'nin se'en ndi'in um, quichen can' ti' ndi'in na hasta cua' ñii. ");
INSERT INTO cya_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Can' cha' xiya' cunen lo'o um: Tsaan nu cu'ni Ndiose xñan bsya 'in nten chendyu, lyee la tyijyin um nu ti'i que ña'an tyijyin quichen Sodoma. ");
INSERT INTO cya_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ticui' xaa can' mdyisnan ycui' ñi lo' juin ñi: Stina Ndiose, nan' cu'nin tnun 'in um, 'un nu lca X'nan ni' cuaan lo'o chendyu re, si'yana msu'hua cutsi' um cha' re 'in nu tiyaa la lo'o nu nxque' ti' lyee la m'ni cha'an, lo' ngulyo scua la um cha' re lo'o nu chin' la cha' 'in. ");
INSERT INTO cya_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Cha' ñi, 'un ñi nu lca Stin, cuaña'an mdo'o tiquee um. ");
INSERT INTO cya_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ñi nu lca Stin nchgaa loo cha' mdyaa ñi cunta 'ñan, lo' a tucui nu ndyu'hui lyoo ca 'in Sñe' ñi, cui' ca nu scati Stina Ndiose, lo' a tucui nu ndyu'hui lyoo ca 'in Stina Ndiose, cui' ca nu scati Sñe' ñi, a cunta culyo scua la can' cha' re lo'o tsalca nu nchca ti'. ");
INSERT INTO cya_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quiaan um, nchgaa 'un nu cua' tñan' lo' xi'in chendyu 'in, —lo' nan' cu'ni cha' xitñan' cusya 'in um—. ");
INSERT INTO cya_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Taa um ya' ca sca cha' ti 'ñan lo'o um, cu'ni cha'an um 'ñan, si'yana cuti cusya 'ñan, suun ña'an ndi'in cha' 'ñan, lo' xitñan' cusya 'in um, ");
INSERT INTO cya_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","si'yana a tucui tñan nu taan 'in um, lo' ñi a ti'in na. ");
INSERT INTO cya_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nu ncua sca tsaan, cui' tsaan nu nxitñan' ne' judio, mdijin Jesús lo'o yu ta'a nda'an ñi sca loo jyaan se'en nducua trigo, lo' si'yana nguite' ti' yu, mston yu jun trigo can' lo' ycu yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Xa na'an tucua snan ne' fariseo ña'an ngui'ni yu, lo' juin ne' 'in ñi: Ña'an jan ñi, xñi um cunta ña'an ngui'ni yu ta'a nda'an um, sca cha' nu a ntsu'hui cha' cu'ni na tsaan nu nxitñan' na. ");
INSERT INTO cya_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mxcuen ñi 'in ne': ¿Ta a nchca chcui' um se'en nchcui' cha' 'in yu Davi ña'an m'ni yu xa ngute' ti' yu lo'o yu ta'a mda'an yu? ");
INSERT INTO cya_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yten yu se'en n'ni tnu ne' 'in Ndiose, lo' ycu yu jaslya nu cua' ncuan 'in Ndiose, na nu a ntsu'hui cha' cu yu, ñi lo'o ta'a nda'an yu, cui' ca nu tsalca ti yu nu ntsu'hui cunta se'en can', tca cu yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ta a nchca chcui' um se'en nguinu scua cha' 'in lee can', si'yana yu nu ntsu'hui cunta se'en n'ni tnu ne' 'in Ndiose ngui'ni yu tñan tsaan nu nxitñan' ne', una a nducui yu qui'ya si'ya cha' can'? ");
INSERT INTO cya_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Una cunen lo'o um sca cha', lja na re ndon sca nu ndon loo lati que cha' 'in laa. ");
INSERT INTO cya_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Cha' cua na ca cuiya' ti' um, ñi cha' nchca ti' chcui' sca cha' nu cua' nguinu scua loo quityi: —Cha' tsu'hue nu tyi'o ni' cusya 'in um nchca tin', lo' si'i nu tiquin tucua um 'ni tloon—. Cha' cua na qui'ya um cunta cha' re, lo' a culo qui'ya um 'in nu a m'ni qui'ya, ");
INSERT INTO cya_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan lca Ñi X'nan tsaan nu nxitñan' na. ");
INSERT INTO cya_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ña'aan mdo'o ñi can' mdiyaa ñi se'en n'ni tnu ne' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Can' ndi'in sca yu nu ngutyi sca tso' yaa'. Ne' fariseo ngunan ne' ña'an nu su'hua ne' qui'ya 'in ñi, lo' mñicha' ne' 'in ñi: ¿Ta ntsu'hui cha' cuiya' cu'ni chca na sca nu ti'i tsaan nu nxitñan' na? ");
INSERT INTO cya_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mxcuen ñi 'in ne': Cha' ndon sca slya' 'in um, lo' tyu yu'hui 'in sca tuyuu tsaan nu nxitñan' na, ¿ta si'i cui' xaa quia lyoo um 'in 'in? ");
INSERT INTO cya_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Ta a ntsu'hui lyoo la sca nten que 'in sca slya'? Can' cha' nchgaa loo tñan tsu'hue tca cu'ni na siya' tsaan nu nxitñan' na. ");
INSERT INTO cya_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Xacan' juin ñi 'in nu ti'i can': Xñii yaa'. Cui' xaa mxñii yu yaa' yu, lo' mchca tsu'hue na 'in yu tsaña'an xca tso' can'. ");
INSERT INTO cya_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ne' fariseo xa mdyi'o ne' se'en can', m'ni cuiya' ne' cha' ña'an tca cujui ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Xa ngujlyo ti' Jesús cha' can', mdo'o ñi nguiaa ñi, lo' qui'an 'a nten mducui ncha'an 'in ñi, lo' m'ni chca ñi 'in nchgaa nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Una mdi'in tya tla ñi sca cha' lo'o ne', si'yana a chcui' la ne' cha' 'in ñi lo'o nten, ");
INSERT INTO cya_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","si'yana chcua cha' nu mxiycui' Ndiose 'in yu Isaía xa juin yu: ");
INSERT INTO cya_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","—Nde nu lca nguso 'ñan nu cua' ngulohuin, ñi nu ta'a lati 'ñan, lo' ndyijyin ya' tsu'hue ntsu'hui tiqueen lo'o ñi. Taan Espíritu 'ñan chu'hui ni' cusya 'in ñi. Tyi'an ycui' ñi lo'o ne' gentil cha' nu ñi 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ñi a ca jñan ti' ñi cha' cusuun, uta xi'ya lo'o ñi 'in ne', ñi a quine tijyo' loo xa chcui' ñi. ");
INSERT INTO cya_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ñi sca quii nu cua' mtsa tucui, lo' a cucha lyijyi ñi 'in na. A cunta sca quii' nu cua' tyuhui' ti, a suhui' lyijyi ñi 'in na, cha' si'i la cua' ngulyo scua la ñi cha' nu ñi 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","lo' si'ya ñi nchgaa ne' gentil nducua tloo ne' tyi'o laa ne'—. ");
INSERT INTO cya_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chon' nde'en can' ya lo'o ne' 'in sca yu ntsu'hui cui'in xa'an 'in tloo Jesús, a cunta cuityin' yu lo' cu'un yu. M'ni chca ñi 'in yu, cui' xaa ncua chcan' 'in yu lo' mdyisnan ycui' yu. ");
INSERT INTO cya_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ndyijyin ya' yuhue' ti' ne', lo' nchcui' ne': ¿Ta xtyi ti' cui' Sñe' ta nten 'in Davi, ñi nu ntsu'hui cha' caan lca ñi re? ");
INSERT INTO cya_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Xa ngune 'in ne' fariseo cha' re, xacan' juin ne': Yu re ndlo yu cui'in xa'an ntsu'hui 'in nten lo'o cha' cuiya' 'in Beelzebú, xñan cui'in xa'an. ");
INSERT INTO cya_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngu'ya Jesús cunta ña'an lca tiquee ne', lo' juin ñi 'in ne': Sca quichen tnu tsatii cha' 'in na cha' tyisnan xuun na lo'o ticuii' ta'a na, cui' cuaña'an lo'o cunda scaa quichen uta cunda scaa na'an, cha' nsuun can' lo'o ticuii' ta'a, a cula scua cha' 'in. ");
INSERT INTO cya_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Cha' Laxa'an ndlo 'in cui'in xa'an, ticuii' ta'a ndlo tso' 'in xacan'. ¿Lo' ña'an ta tca cula scua cha' 'in se'en ndlo tñan? ");
INSERT INTO cya_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Cha' nan' ndlon cui'in xa'an lo'o cha' cuiya' 'in Beelzebú, lo' ti nu mdaa cha' cuiya' 'in nu ta'a nda'an um ndlo cui'in xa'an cha' na can'? Can' yu nu cu'ni cuiya' cha' 'in um lo'o cha' re. ");
INSERT INTO cya_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Una cha' nan' ndlon cui'in xa'an lo'o cha' cuiya' 'in Espíritu 'in Ndiose, ca cuiya' ti' um si'yana cua' mdiyaa tsaan nu culo Ndiose tñan 'in um. ");
INSERT INTO cya_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","A tucui nu tca sten ña'an 'in sca yu ngula ti' lo' cui'ya na ndi'in 'in yu, cha' si'i culo nducua la caja nu scan' 'in yu, la xacan' tca cui'ya can' na nu ndi'in 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nu a nguiaa tso' 'ñan, can' nu lca ta'a cusuun, lo' nu a nxo' ti'in slya' 'ñan, can' nu nde nsu'hua ta 'in 'in. ");
INSERT INTO cya_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Chcuin' sca cha' lo'o um: Ndiose cu'ni ñi cha' tlyu ti' 'in nten si'ya nchgaa loo qui'ya nu n'ni ne', lo'o nchgaa loo cha' ngunan' nu nchcui' ne', una nu nchcui' ca'an 'in Espíritu, a chu'hui 'a cha' tlyu ti' 'in ñi lo'o can'. ");
INSERT INTO cya_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nchgaa tucui nu nchcui' cha' ti'i 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan, ti' chu'hui cha' tlyu ti' 'in ñi lo'o can', una nu nchcui' cha' ti'i 'in Espíritu nu Luhui 'in Ndiose, a cu'ni ñi cha' tlyu ti' 'in can', ñi cua' ñii lo' ñi tsala xaa. ");
INSERT INTO cya_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sca yca nu tsu'hue, ticui' tsu'hue mti ndyi'yu loo na, lo' yca nu a tsu'hue, ticui' a tsu'hue mti ndyi'yu loo na. Chu'hui lyoo na sca yca cua' ña'aan mti ndyi'o loo na. ");
INSERT INTO cya_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡'Un lca um sñe' ta nten nu cuiñi! ¿Ta tca chcui' um cha' nu tsu'hue cha' lca um nten nu nducun'? Cha' nu mtsa'an yu'hui ni' cusya 'in nten, can' cha' nu ndyi'o tu'hua ne'. ");
INSERT INTO cya_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sca nten nu tsu'hue cha' 'in, nchcui' cha' tsu'hue nu ntsu'hui ni' cusya 'in, cui' cuaña'an sca nten nu nducun', nchcui' cha' nducun' nu ndyi'o ni' cusya 'in. ");
INSERT INTO cya_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Una cunen lo'o um sca cha', nchgaa cha' nu a se'en ña'an nchcui' nten, ntsu'hui cha' tyaa ne' cunta 'in na tsaan nu ntsu'hui cha' ca xñan bsya 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Si'ya cha' nu nchcui' um tca quinan' um uta tca tyi'o laa um. ");
INSERT INTO cya_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Xacan' tucua snan ne' escriba lo'o ne' fariseo juin 'in ñi: 'Un ñi nu lca Bstro, nchca ti' hua cu'ni um sca cha' nu tnu tloo hua. ");
INSERT INTO cya_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mxcuen ñi 'in ne': Ta nten nducun' nu a ñi ndi'in cha' 'in, can' nu njñan scasca cha' nu tnu, una a ntsu'hui cha' ña'an ne' cha' can', cui' lya lo'o cha' nu yato'o 'in Jonás. ");
INSERT INTO cya_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tsaña'an —yu'hui yu ni' cula snan tsaan lo' snan tla—, ticui' cuaña'an Yu Qui'yu nu Mdo'o nde ni' Cuaan ntsu'hui cha' caja nu su'hua 'in yu ni' yuu snan tsaan lo' snan tla. ");
INSERT INTO cya_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Xa ca xñan bsya 'in nten chendyu, tyiton ne' Nínive lo' culo qui'ya ne' 'in ta nten re, si'yana nten can' mxilo'o chon' ne' qui'ya 'in ne' lo'o cha' nu ycui' Jonás, una lja na re ndon sca nu ndon loo lati que 'in Jonás. ");
INSERT INTO cya_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ticui' cuaña'an ne' cuna'an 'in ree nu mdo'o se'en lca Arabia, tyiton ne' lo' culo qui'ya ne' 'in ta nten re xa nu ca xñan bsya 'in nten chendyu, si'yana tijyo' mdo'o ne' nu quine 'in cha' tiyaa nu taa yu Salomón, una lja na re ndon sca nu ndon loo lati que 'in yu Salomón. ");
INSERT INTO cya_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Xa nu cui'in xa'an ndyi'o 'in sca nten, nda'an nan can' se'en tyi'in sca se'en ngutyi, una a ndyijyi na. ");
INSERT INTO cya_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ndeña'an nchcui' xacan': Tsu'hue lati cha' xitucuin se'en mdo'on. Lo' xa quila can' se'en mdi'in, quija lyoo na 'in lja na, cua' lca luhui na, a cunta ncua tsu'hue na. ");
INSERT INTO cya_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Xacan' tsa nan cha cati cui'in xa'an nu nducun' lati que 'in, lo' tsatlyu tyi'in can' se'en nguila, lo' nducua la tsato'o 'in ne' que ña'an ti' culoo. Cui' cuaña'an tsato'o 'in ta nten nu nducun' re. ");
INSERT INTO cya_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lja nu ti' nchcui' ñi lo'o nten can', xa mdiyaa ton jyi'an ñi lo'o ta'a ngula ñi tuna'an lyiya', lo' nchca ti' jun chcui' jun lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lo' jui nu mtsa' 'in ñi: La tuna'an lyiya' cua ndon jyi'an um lo'o ta'a ngula um, nchca ti' jun nchcui' jun lo'o um. ");
INSERT INTO cya_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Xacan' mxcuen ñi 'in nu mtsa' 'in ñi: ¿Ti nu lca jyi'an lo' ti nu lca ta'a ngulan? ");
INSERT INTO cya_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ngulo'o yaa' ñi se'en ndi'in nchgaa ta'a nda'an ñi lo' juin ñi: Nde ndi'in nu lca jyi'an lo'o ta'a ngulan. ");
INSERT INTO cya_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ña'an nu ti nu ca ja'an cha' nu nchca ti' Stin, ñi nu nducua ni' cuaan, can' nu lca ta'a ngulan lo' can' nu lca jyi'an. ");
INSERT INTO cya_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ticui' tsaan can' mdyi'o Jesús ña'an can', lo' mdiyaa ñi tu'hua tiyo'. ");
INSERT INTO cya_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mdyisnan nguio' ti'in qui'an nten se'en ndlyu ñi, yten tucua ñi ni' sca yca na'an, lo' nten can' ndi'in ne' tu'hua tiyo' can', ");
INSERT INTO cya_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ngulo'o ñi scasca cha' lo' nchcui' ñi: Nu ncua sca tsaan mdo'o sca yu nguia yta mti trigo. ");
INSERT INTO cya_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Se'en msne yu mti can' nguilo tsachin' na tu'hua tucueen, cui' xaa ti yaan quiñi lo' ycu 'in mti can'. ");
INSERT INTO cya_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tichin' mti can' nguilo na sca se'en nu chin' ti yuu nducua loo quee, lo' cui' xaa mducua na si'yana chin' ti yuu can', ");
INSERT INTO cya_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","una xa cua' m'ni tique' cuaan 'in na, cui' xaa nguinan' na, lo' si'yana a jui se'en tyi'ya xcua' na, can' cha' ngutyi na. ");
INSERT INTO cya_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tichin' mti can' nguilo na lja yca quiche', una yca quiche' can' yjui xu'hua na 'in trigo can'. ");
INSERT INTO cya_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tichin' mti can' nguilo na loo yuu tsu'hue, lo' tsu'hue ncua tñan na: Ntsu'hui juun nu mdo'o sca ciento mti loo, ntsu'hui nu mdo'o snan yla na, a cunta ntsu'hui nu mdo'o cla tyii na 'in. ");
INSERT INTO cya_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nchgaa nu ndon nscan cha' nu ycuin' re, cu'ni cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Xacan' yu ta'a nda'an ñi mñicha' yu 'in ñi xca cunta: ¿Ñi cha' scasca cha' ndyi'in tyaa um lo'o nten cua? ");
INSERT INTO cya_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mxcuen ñi 'in yu: 'Un cua' mdaa Ndiose cha' cuiya' ca cuiya' ti' um scasca cha' nu yu'hui cutsi' 'in ñi, tsaña'an ntsu'hui cha' culo ñi tñan 'in um, una tso' nu 'in ne' cua, a mdaa ñi cha' cuiya' qui'ya ne' cunta cha' re. ");
INSERT INTO cya_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nu cua' ntsu'hui cha' 'in Ndiose ni' cusya 'in, nde taa la ñi cha' tiyaa 'in can', lo' ñi a tsa lyijyi na 'in, una tsalca nu a ntsu'hui cha' re ni' cusya 'in, nde caja nu lyoo tsachin' cha' nu cua' ngune 'in. ");
INSERT INTO cya_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Can' cha' ndyi'in tyaan scasca cha' lo'o ne', ña'an ca si'yana siya' lyee la ña'an ne' lo' a ca chcan' 'in ne', siya' lyee la ton nscan ne' lo' a quine 'in ne', lo' ñi a qui'ya ne' cha' tiyaa. ");
INSERT INTO cya_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tsato'o 'in ne' ña'an mxiycui' Ndiose 'in yu Isaía xa juin yu: —Ñi lyee la quine 'in um, lo' a qui'ya um cha' tiyaa, siya' lyee la ña'an um, lo' a ca chcan' 'in um. ");
INSERT INTO cya_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Si'yana nten re ncua tla cusya 'in ne', cua' mxiya' ti' ne' ne 'in ne', mducun ne' quiloo ne', ña'an ca si'yana a ca chcan' 'in ne', ñi a quine 'in ne', ñi a qui'ya ne' cha' tiyaa, ñi a quia nan ne' 'ñan se'en nu cu'nin chcan 'in ne'—. ");
INSERT INTO cya_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Una tsu'hue ca xu'hue um si'yana tsu'hue xaa quiloo um, lo' xaa tunscan um. ");
INSERT INTO cya_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Chcuin' sca cha' nu ñi lo'o um: Qui'an yu nu mxiycui' Ndiose 'in cua' s'ni, lo'o yu nu m'ni tñan tsu'hue, ncua lca tiquee yu ña'an yu cha' nu na'an um cua' ñii, una a na'an yu 'in na, ñi a ngune 'in yu cha' nu ne 'in um cua' ñii. ");
INSERT INTO cya_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Qui'ya um cunta ña'an nguiaa cha' 'in yu nu ntya mti trigo: ");
INSERT INTO cya_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sca nten nu ne 'in cha' tsu'hue 'in Ndiose, lo' a ndyi'ya ne' cunta cha' can', cui' xaa ndyi'an laxa'an lo' ndlyoo cha' tsu'hue nu cua' nguita ni' cusya 'in ne'. Can' nu nguiaa cha' 'in tsaña'an nguiaa cha' 'in mti nu nguilo tu'hua tucueen can'. ");
INSERT INTO cya_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mti nu nguilo se'en chin' ti yuu nducua loo quee can', nguiaa cha' 'in na tsaña'an nguiaa cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, lo' ticui' xaa nducuan xu'hue ne' cha' can', tsu'hue ntsu'hui tiquee ne'. ");
INSERT INTO cya_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lo' si'yana a ndyi'ya xcua' tsu'hue na ni' cusya 'in ne', chin' ti xaa ndon lo'o ne' cha' can', si'ya scasca cha' nu ndyijyin ne' si'ya cha' tsu'hue 'in Ndiose, cui' xaa ndyi'o tso' ne'. ");
INSERT INTO cya_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mti nu nguilo se'en nducua yca quiche' can', nguiaa cha' 'in na tsaña'an nguiaa cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, una si'ya scasca cha' nu nchca loo chendyu re, uta si'ya cha' cuilyiya' nu ñilyi'o 'in ne', can' nu ndujui xu'hua cha' tsu'hue nu cua' nguita ni' cusya 'in ne', lo' a ndyijyi ña'an cuton na. ");
INSERT INTO cya_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Una mti nguilo loo yuu nu tsu'hue can', nguiaa cha' 'in na tsaña'an nguiaa cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, tsu'hue ndyi'ya ne' cunta cha' can', nchca chcan' loo chendyu 'in ne' tsaña'an nguiaa cha' 'in juun trigo nu ndaa sca ciento mti loo, ta snan yla na, uta cla tyii na scaa loo juun. ");
INSERT INTO cya_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ycui' ñi xca cha' lo' juin ñi: Tsaña'an ndlo Ndiose tñan 'in nten, nguiaa cha' 'in na tsaña'an nguiaa cha' 'in sca nten nu msne mti trigo nu tsu'hue lati loo jyaan 'in, ");
INSERT INTO cya_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","una tla xa lja' ne' yaa ta'a cusuun ne', msne mti nu a tsu'hue lja trigo can', xacan' mdo'o nguiaa. ");
INSERT INTO cya_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tsatlyu mdo'o tucua na, una xa mdyisnan mducua juun na, la xacan' ncua chcan' loo na si'yana si'i chacui' trigo nducua can'. ");
INSERT INTO cya_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tucua snan yu nguso ya ytsa' yu 'in x'nan tñan can', lo' juin yu: 'Un nu lca x'nan hua, ¿ta si'i mti nu cua' mdo'o hui yta um loo x'ñan um? Lo' xca loo mti can', ¿la mdo'o na xacan'? ");
INSERT INTO cya_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xacan' mxcuen x'nan tñan can' 'in yu: Nde'en la ta'a cusuun na ya y'ni tñan cua. Lo' juin yu nguso can': ¿Ta nchca ti' um lo' xton hua 'in na? ");
INSERT INTO cya_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mxcuen x'nan yu 'in yu: A quiton na, ña'an tu' lo'o trigo cua xton um. ");
INSERT INTO cya_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tyaa um ya' culo na tsatlyu lo' cula tucua na, lo' xa quio' na chcuin' lo'o yu nguso can': Xo' um culo nducua la quixin' nu a tsu'hue can', scan' yni um 'in na lo' squin na, xacan' xo' um mti trigo can' lo' tyi'in se'en na. ");
INSERT INTO cya_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nde xca cha' nu ycui' Jesús: Tsaña'an nu ndlo Ndiose tñan 'in nten, nguiaa cha' 'in na tsaña'an nguiaa cha' 'in mti mostaza nu yta sca yu qui'yu loo x'ñan yu. ");
INSERT INTO cya_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cha' ñi si'yana lca na sca mti nu suhue lati que 'in nchgaa loo mti, una tnu la ndlyo na que 'in nchgaa loo quixin', ndlyo na tsaña'an nchca ti' sca yca, lo' hasta quiñi nsu'hua ten 'in lja stan' na. ");
INSERT INTO cya_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nde xca cha' nu ycui' ñi: Tsaña'an nu ndlo Ndiose tñan 'in nten, nguiaa cha' 'in na tsaña'an nguiaa cha' 'in suun jaslya nu mxitiya' ne' lo'o snan cuiya' quita, lo' tsatlyu mchcuen na xacan'. ");
INSERT INTO cya_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nchgaa cha' re ycui' nchcun Jesús lo'o nten, lo' a ncua nu a chcui' nchcun ñi lo'o ne', ");
INSERT INTO cya_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","cui' si'yana chcua cha' nu mxiycui' Ndiose 'in nguso 'in ñi xa juin yu: —Chacui' cha' nu ntsu'hui nchcun chcuin' lo'o nten, culyo scua lan cha' nu ntsu'hui cutsi' 'in Ndiose ti' xa mtñan ñi chendyu—. ");
INSERT INTO cya_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Xa msla' ta'a Jesús lo'o nten can' yten ñi ña'an can', lo' yu ta'a nda'an ñi yaa yu cui' la se'en ndon ñi, lo' juin yu 'in ñi: Cu'ni um cha' tsu'hue quitsa' la um 'in hua ñi cha' nchca ti' chcui' cha' 'in quixin' nu mducua lja trigo can'. ");
INSERT INTO cya_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mxcuen ñi 'in yu: Yu nu ntya mti nu tsu'hue can' lca Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yuu se'en nguita na lca na chendyu re, lo' nchgaa nu lca sñe' Ndiose lca mti nu tsu'hue can', lo' mti nu a tsu'hue can' lca sñe' laxa'an. ");
INSERT INTO cya_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Laxa'an can' lca ta'a cusuun x'nan tñan can', cui' nu ya sne mti can', lo' xa quio' na nchca ti' chcui' xa tsatii cha' nu nchca loo chendyu re, lo' nu ntsu'hui cha' xo' 'in na lca angujle. ");
INSERT INTO cya_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Cui' ña'an nguiton quixin' nu nducua lja trigo can' lo' ndiquin na, cuaña'an tsato'o tiyaa xaa xa tsatii cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yu Qui'yu nu Mdo'o nde ni' Cuaan ca'an tñan angujle 'in se'en ndlo tñan, xo' ti'in can' 'in nchgaa nu nchcui ndijin lo'o nchgaa nu ngui'ni qui'ya, ");
INSERT INTO cya_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","lo' su'hua 'in can' loo quii' tnu, can' xi'ya yja cueen loo nu lyee tyijyin nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Xacan' tsaña'an luhui xaa 'in cucha, cuaña'an tyi'o scua la cha' 'in nchgaa nu ñi ndi'in cha' 'in se'en ndlo Ndiose tñan. Nchgaa nu ndon nscan cha' nu ycuin' re, cu'ni cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ti' juin la ñi: Tsaña'an nu ndlo Ndiose tñan 'in nten, ticui' cuaña'an nguiaa cha' 'in na tsaña'an nguiaa cha' 'in tñi nu ntsu'hui cutsi' ni' yuu, lo' nguija lyoo na 'in sca nten, una msu'hua cutsi' ne' 'in na xiya'. Loo nu tsu'hue ntsu'hui tiquee ne' yjui' ne' nchgaa na nu ndi'in 'in ne' lo' msi'i ne' yuu can'. ");
INSERT INTO cya_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","A cunta nde xca cha' nu tca qui'ya um cha' tiyaa tsaña'an nu ndlo Ndiose tñan 'in nten, nguiaa cha' 'in na tsaña'an ndi'in cha' 'in sca yu nu ndujui' na, lo' nan yu chacui' perla nu tsu'hue la, ");
INSERT INTO cya_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","lo' xa nguija lyoo yu sca perla nu ndyi'ya la can', xacan' yjui' yu nchgaa na nu ndi'in 'in yu lo' msi'i yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ti' juin la ñi: Tsaña'an nu ndlo Ndiose tñan 'in nten, nguiaa cha' can' tsaña'an nguiaa cha' 'in quitan nu nduguun ne' loo tyi'a, lo' nguinu cuati loo cula, ");
INSERT INTO cya_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","lo' xa cua' nguinu 'in, ndlyoo ne' 'in na nde tu'hua tyi'a, xacan' nchcua lyohui ne' cula can', nu tsu'hue can' nxu'hua se'en ne', lo' nxcuan ne' nu a tsu'hue can'. ");
INSERT INTO cya_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Cuaña'an tsato'o xa tsatii cha' nu nchca loo chendyu re, caan angujle lo' culo tso' 'in nten nu nducun' lja nten nu ñi ndi'in cha' 'in, ");
INSERT INTO cya_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","lo' su'hua 'in can' loo quii' tnu, can' xi'ya yja cueen loo nu lyee tyijyin nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lo' juin Jesús 'in yu ta'a nda'an ñi: ¿Ta ngu'ya um cha' tiyaa cha' re? Mxcuen yu 'in ñi: Ngu'ya hua cha' tiyaa Ñi X'nan hua. ");
INSERT INTO cya_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Xacan' juin ñi 'in yu: Sca yu nu tsu'hue ndyi'ya cunta ña'an ndi'in cha' 'in Ndiose, nguiaa cha' 'in yu tsaña'an nguiaa cha' 'in sca nten nu ntsu'hui cunta sca na'an, si'yana loo na nu ntsu'hui se'en can' 'in, ndlyoo na nu cui ti lo'o na nu cula. ");
INSERT INTO cya_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Xa mdyi ycui' Jesús scasca cha' can', mdo'o ñi nguiaa ñi, ");
INSERT INTO cya_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nguila ñi quichen se'en mdi'in ñi, lo' mdyisnan ngulo'o ñi 'in nten se'en n'ni tnu ne' 'in Ndiose, lo' nten can' lyee 'a yuhue ti' ne' 'in ñi lo' nchcui' ne': ¿La ngulo yu re cha' tiyaa tsaña'an nu nchcui' yu lo' n'ni yu cha' nu tnu? ");
INSERT INTO cya_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ta si'i sñe' yu cuityi yca ca lca yu re? ¿Ta si'i jyi'an yu lca María, lo' ta'a ngula yu lca Jacobo, lo'o yu See, yu Simón lo'o yu Juda? ");
INSERT INTO cya_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ta si'i nchgaa nu cuna'an ta'a ngula yu ndi'in lo'o na quichen re? ¿La ta ngulo yu nchgaa cha' re? ");
INSERT INTO cya_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Si'ya cha' can' yten cha' tucua ti' ni' cusya 'in ne' lo'o ñi. Una juin Jesús lo'o ne': Sca yu nu nxiycui' Ndiose 'in ndyijyi nu nducuan xu'hue 'in yu xca se'en, una si'i quichen tyi yu uta lja ta nten 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A m'ni ñi qui'an la cha' nu tnu quichen tyi ñi, si'ya cha' nu a ya qui'an ti' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yu Herode Antipas nu ndlo tñan can', ynan yu nchgaa cha' nu m'ni Jesús, ");
INSERT INTO cya_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","lo' juin yu 'in nguso 'in yu: Cui' yu Xuhua mducua tya 'in nten lca yu cua, lo' cua' ñii mdyiqui'o yu, can' cha' nchca n'ni yu scasca cha' nu tnu. ");
INSERT INTO cya_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Juin yu Herode cuaña'an si'yana cui' yu m'ni yu cha' nguinu yu Xuhua can', lo' mscan' ne' 'in yu lo'o carena, lo' msu'hua ne' 'in yu na'an chcuan, si'ya Herodía, ne' cuna'an 'in yu Lpe ta'a ngula yu. ");
INSERT INTO cya_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Si'yana yu Xuhua nchcui' yu lo'o Herode: A tsu'hue tyi'in lyi'o um cuna'an 'in ta'a ngula um. ");
INSERT INTO cya_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Can' cha' ncua ti' yu Herode cujui yu 'in yu Xuhua, una ntsen yu tloo nten quichen si'yana nsu'hua loo ne' 'in yu lca yu sca nu nxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Una xa ngu'ya nii Herode msu'hua yu sca ta'a, lja xacan' sca nu cuna'an sñe' Herodía yla quiya' tlu'hue la se'en nducua yu, lo' mdiyaa 'a ti' yu ña'an yla quiya' ne', ");
INSERT INTO cya_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","lo' si'ya cha' can', mdi'in tyaa yu sca cha' nu cha' ñi ca lo'o ne' cuna'an can', si'yana taa yu ña'an na ti nu jñan ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lo' jyi'an ne' cuna'an can' msu'hua tiquee ne' si'yana chcui' ne': Jni re ñii nchca tin' sca qui'nan se'en ndi'in que yu Xuhua mducua tya 'in nten. ");
INSERT INTO cya_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yu ree can' cui' xaa ngulu'un ti' yu. Lo' si'ya sca cha' nu cua' mdi'in tyaa yu tloo nchgaa ta'a nducua yu, mxcuen yu cha' nu ncua ti' ne', ");
INSERT INTO cya_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ngulo yu tñan si'yana xi'yu yni yu Xuhua se'en ntsu'hui yu na'an chcuan. ");
INSERT INTO cya_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ni' sca qui'nan mdi'in que can' nguian lo'o yu 'in na, lo' mdyaa yu 'in na 'in ne' cuna'an can', cui' xaa mdyaa ne' 'in na 'in jyi'an ne'. ");
INSERT INTO cya_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Xacan' ta'a mda'an yu Xuhua can' nguia 'ya 'in yu se'en su, lo' ya tsi' yu 'in. Chon' nde'en can' ya ytsa' yu 'in Jesús cha' nu yato'o. ");
INSERT INTO cya_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Xa ngujlyo ti' Jesús cha' can', cui' xaa mdo'o ñi nguiaa ñi lo' yten ñi ni' sca yca na'an, mdiyaa ñi sca se'en scati ñi se'en nu a tca nten. Xa ngujlyo ti' nten la nde nguiaa ñi, cui' xaa mdo'o ne' scasca quichen mda'an quiya' ti ne' ya ncha'an ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Xa mdyi'o ñi ni' yca na'an can', na'an ñi si'yana qui'an 'a nten cua' ndi'in can', mña'an 'tnan ti' ñi 'in ne' lo' m'ni chca ñi 'in nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Xa cua' msiin tsaan can' mdiya ycui' yu ta'a nda'an ñi lo'o ñi, lo' juin yu: Cua' msiin 'a lo' tijyo' a nguinu se'en re, tsu'hue lati sla' tijin um 'in nten re, lo' tsa si'i ne' na nu cunajo'o 'in ne' scasca quichen suhue ti. ");
INSERT INTO cya_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lo' juin Jesús 'in yu: A najo'o quiaa ne', 'un xicu um 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mxcuen yu 'in ñi: Una a nda'an lo'o hua na qui'an la, seen cha ca'yu ti jaslya lo'o chcua ti cula nda'an lo'o hua. ");
INSERT INTO cya_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Lo' juin ñi 'in yu xacan': Tyaa um 'in na 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Xacan' ngulo ñi tñan si'yana sten tucua nten can' loo quixin' xuhue ti can'. Msñi ñi ca'yu jaslya lo'o tucua cula can', mscuen ñi tloo ñi lo' mdyaa ñi xu'hue 'in Ndiose, msu'hue ñi 'in na lo' mdaa ñi 'in na 'in yu ta'a nda'an ñi, can' yu cua' mtsa 'in na 'in nten can'. ");
INSERT INTO cya_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nchgaa ne' ycu ne' tsaya' nu ngula' ti' ne', lo' tsa tichcua xcuhui ti' m'ni cha'an yu lo'o yu'hue jaslya nu nguinu can'. ");
INSERT INTO cya_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nten nu ycu can' mdiyaa ne' tsa ca'yu mii ne' tsalca yu qui'yu ti, lo' ñi a ncua yu 'in jun cuna'an lo'o nu suhue ti. ");
INSERT INTO cya_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Xacan' msu'hua Jesús 'in yu ta'a nda'an ñi, si'yana chcua loo yu tsaa yu ni' yca na'an, lo' tyi'o ca'an yu xca tso' tiyo' can', lja nu ti' nsla' ñi 'in nten can'. ");
INSERT INTO cya_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Xa cua' msla' ta'a ñi lo'o nten can', ycuen ñi sca loo qui'ya lyo' ti, can' nxiton ñi scati ñi xa ngu'ya tla. ");
INSERT INTO cya_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yca na'an can' cua' nguiaa na tlu'hue tiyo' can', lyee ngui'ni xcua na loo tyi'a si'ya cui'in nu ljyaan loo na. ");
INSERT INTO cya_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tla nde cua' ljyaan xaa, mdo'o Jesús nguia ycua ñi 'in yu loo tyi'a can', lo' nda'an quiya' ti ñi. ");
INSERT INTO cya_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yu ta'a nda'an ñi na'an yu ljyaan sca nu nda'an quiya' ti loo tyi'a can', lyee ytsen yu lo' msi'ya yja cueen yu, lo' nchcui' yu: ¡Sca cuxee ca cua! ");
INSERT INTO cya_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Una cui' xaa ycui' Jesús lo'o yu: ¡Cu'ni tnu tiquee um si'yana nan' lcan, a cutsen um! ");
INSERT INTO cya_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Xacan' mxcuen yu Tyo 'in ñi: Ñi X'nan hua, cha' 'un lca um, cu'ni um cha' tsa ycuan 'in um loo tyi'a re. ");
INSERT INTO cya_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lo' juin ñi 'in yu: Cuan lya. Yu Tyo can' cui' xaa ngu'ya ton yu loo tyi'a can', lo' mdyisnan mda'an yu nu tsa ycua yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Una xa na'an yu si'yana lyee nchca cui'in cui' xaa ytsen yu, cui' ña'an lcaa nguityin' yu'hui yu, lo' ycui' cueen yu: ¡Ñi X'nan hua, culo laa um 'ñan! ");
INSERT INTO cya_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lo' Jesús cui' xaa mxñii ñi yaa' ñi, ngulyoo ñi 'in yu, lo' juin ñi: ¿Ta jo'o 'a ndiya qui'an ti', ñi cha' ngui'ni tucua ti'? ");
INSERT INTO cya_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Xa cua' ycuen ñi lo'o yu ni' yca na'an can', cui' ña'an cua' lo'o cui'in can' ngulyijyi na. ");
INSERT INTO cya_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Xacan' nchgaa nu ntsu'hui ni' yca na'an can', cui' xaa mdyi'ya xtyin' yu tloo ñi lo' m'ni tnu yu 'in ñi, lo' nchcui' yu: Nu cha' ñi ca si'yana Sñe' Ndiose lca um. ");
INSERT INTO cya_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Xacan' mdo'o ca'an jun tu'hua tiyo' loo yuu 'in ne' Genesaret. ");
INSERT INTO cya_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Xa yu'hui lyoo nten can' 'in ñi, cui' ña'an lcaa mxicune ne' cha' sca chcui se'en can', lo' cui' xaa ya lo'o ne' 'in nchgaa nu ti'i se'en ndon ñi. ");
INSERT INTO cya_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mjñan ne' cha' tsu'hue 'in ñi si'yana tca cula' ne' siya' tu'hua ste' ti ñi, lo' nchgaa nu yla' ste' ñi mchca. ");
INSERT INTO cya_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Xacan' mdiya ti'in tucua snan ne' escriba, lo'o ne' fariseo nu mdo'o quichen Jerusalén, lo' nchcui' ne': ");
INSERT INTO cya_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Ñi cha' yu ta'a nda'an um ncha ti'in yu cha' nu mxnu scua nten cula 'in na? ¿Ñi cha' a ñaan' yu xa nchcu yu? ");
INSERT INTO cya_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mxcuen ñi 'in ne': Ticui' cuaña'an 'un, ¿ñi cha' ncha ti'in um cha' nu ndlo Ndiose tñan, lo'o ña'an cha' nu cua' ntsu'hui 'in um? ");
INSERT INTO cya_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nde cha' nu nchcui' Ndiose: —Cu'ni suun um 'in um tloo sti um lo'o jyi'an um—, lo' nde xca cha': —Nu taja 'in sti lo'o jyi'an tyi'o tñan caja can'—. ");
INSERT INTO cya_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Una 'un ndeña'an nda cueen um 'in nten: Tca chcui' um lo'o nten cula 'in um, si'yana nchgaa cha' tsu'hue nu ndi'in 'in um cua' lca na lcuan 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","can' cha' a ngui'ni ca'an 'a 'in um ta yaa' um 'in nten cula 'in um. Cuaña'an nguia ncha ti'in um cha' nu ndlo Ndiose tñan si'ya cha' nu cua' ntsu'hui 'in um. ");
INSERT INTO cya_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","'Un ne' nu a ñi ndi'in cha' 'in, cha' ñi 'a ña'an mxiycui' Ndiose 'in yu Isaía cha' 'in um xa juin yu: ");
INSERT INTO cya_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","—Nten re lo'o tu'hua ti ne' n'ni tnu ne' 'ñan, una cusya 'in ne' tijyo' nchca na siin'. ");
INSERT INTO cya_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Cua cha' ti n'ni tnu ne' 'ñan, si'yana cha' nu ndlo que ne' ndijin ne' cunta 'in na lca na cha' nu 'in Ndiose—. ");
INSERT INTO cya_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tsatlyu msi'ya ñi 'in nten lo' juin ñi: Ton nscan um lo' qui'ya um cunta cha' re. ");
INSERT INTO cya_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Si'i na nu nchcu nten, n'ni cha' nchca coo' cusya 'in ne' tloo Ndiose, cha' nu ndyi'o tu'hua ne', can' nu n'ni cha' nchca coo' cusya 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Xacan' mdiya ti'in yu ta'a nda'an ñi tloo ñi, lo' juin yu: ¿Ta ngu'ya um cunta si'yana ne' fariseo a mdiyaa ti' ne' cha' nu ycui' um? ");
INSERT INTO cya_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mxcuen ñi 'in yu: Nchgaa yca nu a yta Stin, ñi nu nducua ni' cuaan, ntsu'hui cha' quiton na ña'an lo'o xcua' na. ");
INSERT INTO cya_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","A ta quiya' um 'in ne', si'yana cuityin' ne' lo' ti' nchca ti' ne' xñi ne' yaa' ta'a cuityin' ne', una tsato'o chcuaa can' tyu sca tuyuu. ");
INSERT INTO cya_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Xacan' mdo'o ycui' yu Tyo lo' juin yu 'in ñi: Cu'ni um cha' tsu'hue quitsa' um 'in hua ña'an nguiaa cha' nu ycui' nchcun um re. ");
INSERT INTO cya_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Juin Jesús 'in yu: ¿Ta na lo'o um nchcun cha' tiyaa 'in um? ");
INSERT INTO cya_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ta na a ndyi'ya um cunta si'yana nchgaa na nu nchcu ne' ndyijyin ti na ni' ne'? ");
INSERT INTO cya_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Una cha' nu ndyi'o tu'hua ne', nde ni' cusya 'in ne' ndyi'o na, can' nu n'ni cha' nchca coo' cusya 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Si'yana nde ni' cusya 'in ne' ndyi'o cha' tiyaa ngunan', cha' nu ndujui ne' nten, nguiten yu'hui ne' lo'o cuilyi'o nten uta lo'o ña'an tucui ti, cha' cunan, cha' cuiñi, cha' nu ndaja ta'a ne'. ");
INSERT INTO cya_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nde cha' nu n'ni cha' nchca coo' cusya 'in ne', una nu cu ne' lo' a ñaan' ne', a cu'ni coo' cha' can' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Xacan' mdo'o Jesús nguiaa ñi, lo' mdiyaa ñi loo yuu se'en lyi'ya loo quichen Tiro lo'o Sidón. ");
INSERT INTO cya_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yato'o sca ne' cuna'an nu mdo'o se'en lyi'ya loo Canaán ycui' cueen ne' lo'o ñi, lo' nchcui' ne': ¡Ñi X'nan hua, 'un ñi nu lca Sñe' ta nten 'in Davi, ña'an 'tnan ti' um 'in hua! Si'yana sca ne' cuna'an sñen' lyee 'a ti'i ndijin si'ya cui'in xa'an nu ntsu'hui 'in. ");
INSERT INTO cya_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Una Jesús a mxcuen ñi 'in ne'. Yu ta'a nda'an ñi mdiyaa yu cui' la se'en nguiaa ñi, lo' juin yu 'in ñi: Chcui' um lo'o ne' si'yana quiaa ne', lo' a can si'ya 'a ne' nde chon' na. ");
INSERT INTO cya_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Lo' juin ñi xacan': Ndiose ngua'an tñan 'ñan si'ya slya' nu nda'an ngunan' yu'hui se'en lca Israel. ");
INSERT INTO cya_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Cui' ña'an lcaa mdiyaa ne' tloo ñi, mdyi'ya xtyin' ne', lo' mjñan ne' cha' tsu'hue 'in ñi: ¡Ñi X'nan hua, ta yaa' um 'in hua! ");
INSERT INTO cya_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mxcuen ñi 'in ne': A ntsu'hui cha' caja nu lyoo jaslya nu ntsu'hui tuyaa' sñe', lo' taa 'in na cu xni'. ");
INSERT INTO cya_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Juin ne' xacan': Cha' ñi 'in um, Ñi X'nan hua, una hasta lo'o xni', lo' nxo' ycu 'in ta nu nguilo nde ni' msa 'in x'nan 'in. ");
INSERT INTO cya_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mxcuen Jesús 'in ne': Cha' ñi si'yana lyee ndiya qui'an ti' um, cui' ña'an cha' nu ntsu'hui tiquee um cuaña'an tsato'o. Ticui' braa can' mchca sñe' ne' cuna'an can'. ");
INSERT INTO cya_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús mdo'o ñi se'en can' lo' mxitucui ñi nde tu'hua tiyo' Galilea, ycuen ñi sca loo qui'ya lyo' ti, can' yten tucua ñi. ");
INSERT INTO cya_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Qui'an 'a nten nguio' ti'in can', mdiya lo'o ne' 'in nu a nchca tyi'an, nu cuityin', nu a nchca chcui', a cunta lo'o nu cuxi yaa', cuaña'an qui'an nu ti'i lo'o cuati loo quicha, mdiya lo'o ne' 'in tloo Jesús, lo' m'ni chca ñi 'in. ");
INSERT INTO cya_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nten qui'an can' lyee 'a yuhue ti' ne' xa na'an ne' si'yana nu cu'un can' ncua ycui', nchgaa nu cuxi yaa' nguinu tsu'hue na 'in, nu a nchca tyi'an lo' mdyisnan mda'an, a cunta nguila xaa quiloo nu cuityin', lo' tsatlyu m'ni tnu ne' 'in Ndiose 'in ne' Israel. ");
INSERT INTO cya_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Xacan' msi'ya Jesús 'in yu ta'a nda'an ñi, lo' juin ñi: 'Tnan 'a tin' 'in nten re si'yana cua' nchca snan tsaan ndi'in ne' lo'on, lo' a lo'o 'a na nu cu ne', a nchca tin' tucui xu'huan 'in ne' cha' a nchca cu ne', chen nchcui ña'an ti' ne' tucueen quiaa ne'. ");
INSERT INTO cya_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mxcuen yu ta'a nda'an ñi: ¿La caja jaslya xicu na 'in nten qui'an re, lo' ni' quixin' lca na re? ");
INSERT INTO cya_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Lo' juin Jesús 'in yu: ¿Ñi ncua jaslya ti' nda'an lo'o um? Mxcuen yu 'in ñi: Cha cati ti na lo'o chcua xnan cula xuhue ti. ");
INSERT INTO cya_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Xacan' ngulo ñi tñan 'in nten can' si'yana sten tucua ne' lyuu. ");
INSERT INTO cya_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Msñi ñi ta'a cati jaslya lo'o cula can', lo' mdyaa ñi xu'hue 'in Ndiose, xacan' msu'hue ñi 'in na lo' mdaa ñi 'in na 'in yu ta'a nda'an ñi, can' nu cua' mtsa 'in na 'in nten can'. ");
INSERT INTO cya_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nchgaa ne' ycu ne' tsaya' ngula' ti' ne', lo' ti' mxo' yu tsa cati xcuhui lo'o yu'hue jaslya nu nguinu can'. ");
INSERT INTO cya_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nten nu ycu can' mdiyaa ne' jacua mii ne' tsalca yu qui'yu ti, lo' ñi a ncua yu 'in jun cuna'an lo'o nu suhue ti. ");
INSERT INTO cya_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Xa cua' msla' ta'a ñi lo'o nten can', yten ñi ni' yca na'an, lo' mdo'o ca'an ñi xca tso' tiyo' se'en lyi'ya loo quichen Magdala. ");
INSERT INTO cya_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ne' fariseo lo'o ne' saduceo mdiyaan ne' lo'o cha' mañan 'in ne', mjñan ne' 'in Jesús si'yana cu'ni ñi cha' nu tnu nu tyi'o nde ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mxcuen ñi 'in ne': Xa nxiin tsaan ndeña'an nchcui' um: Tsu'hue 'a luhui xaa si'yana nga'á ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lo' xa nde tlya nchcui' um: Cua' ñii qui'ya quioo si'yana nga'á ndla nducui ni' cuaan. 'Un ne' nu a ñi ndi'in cha' 'in, ndyi'ya um cunta cha' nu nchca ni' cuaan, ¿lo' ñi cha' a ndyi'ya um cha' tiyaa cha' nu nchca tloo um cua' ñii? ");
INSERT INTO cya_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ta nten nducun' nu a ñi ndi'in cha' 'in, can' nu nchca ti' ña'an cha' nu tnu, una a ntsu'hui cha' ña'an ne' cha' can', cui' lya lo'o cha' nu yato'o 'in Jonás. Xacan' ngula' ton ñi 'in ne', mdo'o ñi nguiaa ñi. ");
INSERT INTO cya_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Xa mdiyaa yu ta'a nda'an ñi xca tso' tiyo' can', nguia yu'hui ti' yu si'yana a lo'o jaslya lyi'ya yu. ");
INSERT INTO cya_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Lo' juin Jesús 'in yu: Ña'an jan ñi, xñi um cunta 'in um si'ya suun jaslya 'in ne' fariseo lo'o ne' saduceo. ");
INSERT INTO cya_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ndeña'an ñan ti' yu: Nchcui' ñi cha' re si'yana a lyi'ya na jaslya. ");
INSERT INTO cya_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ngu'ya ñi cunta cha' can' lo' juin ñi: ¿Ta cuaña'an cha' nda'an tiquee um si'yana a lyi'ya um jaslya, 'un ne' nu jo'o ndiya qui'an ti'? ");
INSERT INTO cya_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ta na a nchca qui'ya um cha' tiyaa, lo' a ndiya yu'hui ti' um cha' 'in tsa ca'yu jaslya nu ycu ca'yu mii yu qui'yu, lo' ñi ncua xcuhui na ti' mxo' um? ");
INSERT INTO cya_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A cunta lo'o cha cati jaslya nu ycu jacua mii nten, ¿lo' ñi ncua xcuhui na ti' mxo' um? ");
INSERT INTO cya_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ta a ndyi'ya um cha' tiyaa? Si'i si'ya cha' 'in jaslya nchcuin' cha' re. Xñi um cunta 'in um si'ya suun jaslya 'in ne' fariseo lo'o ne' saduceo. ");
INSERT INTO cya_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","La xacan' ngu'ya yu cunta si'yana si'i cha' 'in suun jaslya nchcui' ñi, cui' ca nu si'ya ña'an ndlo'o ne' fariseo lo'o ne' saduceo. ");
INSERT INTO cya_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mdiyaa Jesús se'en lyi'ya loo quichen Cesarea de Filipo, lo' mñicha' ñi 'in yu ta'a nda'an ñi: Tsaña'an nu nchcui' nten, ¿ti ca lca Yu Qui'yu nu Mdo'o nde ni' Cuaan? ");
INSERT INTO cya_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mxcuen yu 'in ñi: Ntsu'hui nu nchcui' si'yana lca um yu Xuhua nu mducua tya 'in nten, xca nu nchcui' si'yana lca um yu Elía, lo' ntsu'hui nu nchcui' si'yana Jeremía lca um, uta scasca yu nu mxiycui' Ndiose 'in cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Lo' juin ñi 'in yu: Lo' 'un jan ñi, ¿tucui ta lcan nan' ñan ti' um? ");
INSERT INTO cya_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Xacan' mxcuen yu Tyo: 'Un lca um ycui' ca Cristo, Sñe' Ndiose, ñi nu lo'o ca. ");
INSERT INTO cya_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Xacan' mxcuen Jesús 'in yu: Tsu'hue ca xu'hue, Simón sñe' Jonás, si'yana si'i nten chendyu ngulyo scua la cha' re lo'o, cui' ca nu Stin, ñi nu nducua ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nan' cunen lo'o: Nu'huin lca Tyo, lo' chon' quee re cu'nin cha' tsa quiñan nchgaa nu tsa qui'an ti' 'ñan, lo' ñi cha' ndyija lo' a tca cu'ni ti'i lo'o can'. ");
INSERT INTO cya_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","'In nu'huin taan cha' cuiya' chcui' lo'o nten tsaña'an ntsu'hui cha' culo Ndiose tñan 'in ne', nchgaa cha' nu scan' loo chendyu re, cua' nchcan' na la ni' cuaan, lo' nchgaa cha' nu xtin' loo chendyu re, cua' nguitin' na la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Xacan' ngulo ñi tñan 'in yu ta'a nda'an ñi, si'yana a chcui' yu lo'o ñi sca tucui si'yana lca ñi Jesús, ñi nu lca Cristo. ");
INSERT INTO cya_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti' xacan' Jesús mdyisnan ngulyo scua la ñi cha' lo'o yu ta'a nda'an ñi, si'yana 'ni cha' tsaa ñi quichen Jerusalén, lo' can' tyijyin ñi nu ti'i tuyaa' qui'yu cula, lo'o yu nu ndlo ca tñan ni' lyaa, lo'o ne' escriba, nu hasta cujui ne' 'in ñi, una nu cua' ca snan tsaan tyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yu Tyo can' ngulo tso' yu 'in ñi sca se'en, lo' ngusun lo'o yu 'in ñi: Ñi X'nan hua, a cula ya' Ndiose 'in um ca cuaña'an. ");
INSERT INTO cya_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Cui' xaa mxiton ñi lo' juin ñi 'in yu Tyo can': Laxa'an, tyi'o tso' siin' lo' a chcui ndijin loon, si'yana cha' tiyaa 'in, a nchcua ta'a na lo'o cha' tiyaa 'in Ndiose, cui' ca nu nda'an lo'o cha' tiyaa 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Xacan' juin Jesús lo'o yu ta'a nda'an ñi: Cha' nde'en nu nchca ti' chcui ncha'an 'ñan, 'ni cha' jlya ti' can' 'in, lo' cu'ni tnu tiquee caja si'yan, lo' tsa quiñan chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Lo' nchgaa nu ñan ti' culo laa 'in ticuii', tsato'o quinan' can' tiyaa xaa, una nchgaa nu tyaa 'in si'ya cha' 'ñan, can' nu tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Si'yana, ¿Ñi canan chu'hui 'in ne' cu'ni 'in ne' ña'aan chendyu, lo' nde quinan' cusya 'in ne'? ¿Ñi na tca cu'ni ne' nu ti' chcuan ne' cusya 'in ne' xiya'? ");
INSERT INTO cya_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yu Qui'yu nu Mdo'o nde ni' Cuaan ntsu'hui cha' quiaan ñi loo xaa 'in Sti ñi lo'o angujle 'in ñi, xacan' xu'hua lyiya' ñi 'in cunda scaa nten cua' ña'aan tñan m'ni ne'. ");
INSERT INTO cya_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cha' ñi cunen lo'o um, ntsu'hui nu ndon re a caja, cha' si'i culo nducua la ña'an 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan xa tyisnan culo ñi tñan. ");
INSERT INTO cya_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xa cua' mdijin scua tsaan, sca cunta mdo'o lo'o Jesús 'in yu Tyo, yu Jacobo, lo'o yu Xuhua ta'a ngula yu, nguiaa jun sca loo qui'ya cuaan. ");
INSERT INTO cya_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tloo na'an yu mcha'an ña'an ñi, nduhui tloo ñi tsaña'an nchca ti' cucha, lo' ste' ñi nguinu mten na tsaña'an nchca ti' sca xaa. ");
INSERT INTO cya_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lja xacan' na'an yu mdo'o ton Moisé lo'o Elía nu nchcui' lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Xacan' juin yu Tyo 'in Jesús: Ñi X'nan hua, tsu'hue 'a si'yana lo'o hua ndlyu hua re. Cha' nchca ti' um lo' tñan hua snan quisin, sca na 'in um, xca na 'in Moisé, lo' xca na 'in Elía. ");
INSERT INTO cya_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lja nu ti' nchcui' yu cha' can', nguo'o yu'hui sca ndla tsu'hue ña'an xaa 'in jun, cui' xaa ngune ycui' sca nu ycui' ni' ndla can': Nde Sñen' nan' nu ta'a lati 'ñan, quine 'in um cha' nu chcui' re. ");
INSERT INTO cya_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Xa ngune 'in yu ta'a nda'an ñi cha' can', cui' xaa mdyi'ya sti yu 'in yu la lyuu lo' lyee ytsen yu. ");
INSERT INTO cya_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yaan Jesús lo' yla' ñi 'in yu, lo' juin ñi: Tyiton lo' a cutsen um. ");
INSERT INTO cya_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Xa mscuen yu tloo yu, a tucui 'a na'an yu, cui' ca nu xca ti Jesús ndon ñi. ");
INSERT INTO cya_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Xa mdo'o jun loo qui'ya can', ngulo Jesús tñan 'in yu: A chcui' um lo'o ñi sca tucui cha' nu na'an um, cha' si'i la xa cua' mdyiqui'o Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Xacan' mñicha' yu ta'a nda'an ñi 'in ñi: ¿Ñi cha' ta nchcui' ne' escriba si'yana yu Elía caan yu culo nducua la? ");
INSERT INTO cya_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mxcuen Jesús 'in yu: Cha' ñi si'yana yu Elía caan yu culo nducua la, lo' cu'ni chu'hue yu nchgaa loo cha'. ");
INSERT INTO cya_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Una cunen lo'o um si'yana cua' yaan Elía, lo' a yu'hui lyoo ne' 'in yu, cui' ca nu m'ni lyi'o ne' 'in yu ña'an nu ncua ti' ne', cui' cuaña'an xitijin ne' nu ti'i 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Xacan' yu ta'a nda'an ñi ngu'ya yu cha' tiyaa si'yana nchcui' ñi cha' 'in yu Xuhua mducua tya 'in nten. ");
INSERT INTO cya_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Xa nguila jun se'en ndi'in nten qui'an can', mdiyaan sca yu qui'yu lo' mdyi'ya xtyin' yu tloo ñi, lo' nchcui' yu: ");
INSERT INTO cya_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ñi X'nan hua, ña'an 'tnan ti' um 'in sñen' nan', si'yana nxñi cui'in 'in yu lo' ti'i 'a ndijin yu, cua' tyun ya' nxitlyu su'hua na 'in yu loo quii' uta loo tyi'a. ");
INSERT INTO cya_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cua' yan lo'on 'in yu tloo yu ta'a nda'an um, una a ncua 'in yu cu'ni chca yu 'in. ");
INSERT INTO cya_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mxcuen Jesús: ¡'Un lca um nten nu a ndiya qui'an ti' lo' lca um nten nducun'! ¿Tsala ta xaa cui' ti 'ñan nducua tloo um, lo' tsala xaa ti' ta loon 'in um? Quian lo'o um 'in sñe' um. ");
INSERT INTO cya_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ngusun lo'o Jesús 'in cui'in xa'an can', xacan' ngula' ton na 'in yu, ticui' xaa mchca yu. ");
INSERT INTO cya_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yu ta'a nda'an Jesús mñicha' yu 'in ñi sca cunta: ¿Ñi cha' huare', a ncua 'in hua culo hua cui'in xa'an cua? ");
INSERT INTO cya_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Juin Jesús 'in yu: Cui' si'yana jo'o ndiya qui'an ti' um. Nu cha' ñi cunen lo'o um, mti mostaza suhue ti na, siya' tsacua ti ña'an tsa qui'an ti' um, lo' tca chcui' um lo'o qui'ya cua: Tyi'o lo' tsa tucua la cua, lo' cuaña'an tsato'o, lo' a sca cha' ta a tca cu'ni um. ");
INSERT INTO cya_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Una cui'in nu cuaña'an, a tyi'o can' cha' si'i culo nducua la chcui' lyi'o na 'in Ndiose lo' cu'ni na ayuna. ");
INSERT INTO cya_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lja nu ti' ntsu'hui lyijyi jun se'en lyi'ya loo Galilea, juin Jesús 'in yu ta'a nda'an ñi: Yu Qui'yu nu Mdo'o nde ni' Cuaan caja nu tyaa 'in ñi tuyaa' nten, ");
INSERT INTO cya_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","lo' cujui ne' 'in ñi, una nu cua' ca snan tsaan ntsu'hui cha' tyiqui'o ñi. Una yu ta'a nda'an ñi ndyijyin ya' ngulu'un ti' yu. ");
INSERT INTO cya_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Xa nguila jun quichen Capernaum, mdijin yu nu nxo' tñi cha' 'in laa, lo' juin yu 'in yu Tyo: Ñi nu lca X'nan um, ¿ta a lo'o ñi taa ñi tñi nu nxo' hua re? ");
INSERT INTO cya_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mxcuen yu: Lo'o ñi. Ña'aan yten yu Tyo ña'an can' culo nducua la Jesús ycui' lo'o yu: ¿Ña'an ljuin, Simón? Yu nu nchca ree loo chendyu re, ¿ti ca 'in ndlo yu scasca tñi, 'in sñe' yu uta na 'in nten quita? ");
INSERT INTO cya_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mxcuen yu Tyo 'in ñi: 'In nten quita. Xacan' juin Jesús: Tsalca sñe' yu, a lo'o can' su'hua lyiya'. ");
INSERT INTO cya_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Una si'yana a ljuin yu ta lye' ti' na, yaa loo tiyo' cua lo' cuun chcuin 'in, lo' culoo cula nu quinu 'in sla tu'hua 'in, can' quija lyoo sca tñi plata, culyoo 'in na lo' taa 'in na 'in yu tñan loo na. ");
INSERT INTO cya_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Xacan' mñicha' yu ta'a nda'an Jesús 'in ñi: ¿Tucui ca lca nu ndon loo la se'en ndlo Ndiose tñan? ");
INSERT INTO cya_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Msi'ya Jesús 'in sca yu lyo' ti, lo' mdi'in tyaa ñi 'in yu tlu'hue la can', ");
INSERT INTO cya_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","lo' juin ñi: Nu cha' ñi cunen lo'o um, cha' a xitsa'an um cha' tiyaa 'in um, lo' ñi a cu'ni um 'in um ña'an nu suhue ti, a tca sten um se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Can' cha' ña'an tucui ti nu cu'ni lyo' 'in tsaña'an ndi'in cha' 'in yu lyo' ti re, can' nu ndon loo lati se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ña'an nu ti nu cuan xu'hue 'in sca nu lyo' ti ña'an yu re, si'ya cha' 'ñan, cu'ni can' cunta si'yana 'ñan cuan xu'hue. ");
INSERT INTO cya_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ña'an tucui ti nu xityu 'in sca nu ndiya qui'an ti' 'ñan, tsaña'an ndi'in cha' 'in nu suhue ti re, ndyi'o la tñan yni can' scan' tucui sca quee tlyu nu ndiyo ne' trigo, lo' cuun ne' 'in tlu'hue la tyi'a tujo'o. ");
INSERT INTO cya_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡'Tnan ca nten chendyu nu xityu 'in xca tucui loo qui'ya! A ndyijyin yu'hui nu a caan cha' can'. ¡Una 'tnan ca nu xityu 'in xca tucui loo qui'ya! ");
INSERT INTO cya_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Cha' si'ya yaa' um uta quiya' um cu'ni um qui'ya, si'yu um 'in na lo' xcuan um 'in na, si'yana tsu'hue lati cha' co' yaa' um lo' co' quiya' um sten um tloo Ndiose, lo' si'i nu chcuaa tso' yaa' um lo' chcuaa tso' quiya' um tsaa um loo quii' tsala xaa. ");
INSERT INTO cya_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Cha' si'ya quiloo um cu'ni um qui'ya, culo um 'in na lo' xcuan um 'in na, si'yana tsu'hue lati cha' sca tso' ti quiloo um sten um tloo Ndiose, lo' si'i nu chcuaa tso' quiloo um tsaa um loo quii'. ");
INSERT INTO cya_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Xñi um cunta si'yana a xcuan tloo um 'in nu suhue ti re, cunen lo'o um si'yana angujle nu ntsu'hui cunta 'in re, nchgaa xaa ndon tloo Stin, ñi nu nducua ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yu Qui'yu nu Mdo'o nde ni' Cuaan mdiyaan ñi si'yana culo laa ñi 'in nu ngunan' yu'hui. ");
INSERT INTO cya_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Ña'an ljuin um? Cha' sca yu qui'yu ndi'in sca ciento slya' 'in yu, lo' cha' tyi'o tso' sca 'in, ¿ta a xnu ti'in yu 'in cha jacua yla ntsu'hui 'tñulcua nu can', lo' quia nan yu 'in nu ngunan' yu'hui can'? ");
INSERT INTO cya_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cha' quija lyoo 'in, nu cha' ñi cunen lo'o um, lyee la ca tsu'hue chu'hui tiquee yu lo'o can', que 'in cha jacua yla ntsu'hui 'tñulcua nu a ngunan' yu'hui can'. ");
INSERT INTO cya_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cui' cuaña'an Stina Ndiose, ñi nu nducua ni' cuaan, a lca tiquee ñi quinan' ñi sca nu suhue ti re. ");
INSERT INTO cya_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Cha' sca jun ta'a na cu'ni qui'ya lo' cu'ni ti'i lo'o um, chcui' um lo'o can' se'en scati um, cha' cu'ni cunta cha' nu chcui' um, cua' m'ni um canan mchca tsu'hue cha' 'in. ");
INSERT INTO cya_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cha' a cu'ni cunta cha' chcui' um, cuni um tucua snan jun ta'a tsaa um, —lo' tyi'o scua la sca cha' si'ya tucua snan nu taa suun cha' can'—. ");
INSERT INTO cya_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cha' a cu'ni cunta can' 'in jun ta'a yaa um, quitsa' um 'in laa, lo' cha' a cu'ni cunta cha' nu chcui' nchgaa jun ta'a na, cu'ni um cunta 'in can' lca sca nu nducun' lo' tiji nan. ");
INSERT INTO cya_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nu cha' ñi cunen lo'o um, nchgaa cha' nu scan' um loo chendyu re, cua' nchcan' na la ni' cuaan, lo' nchgaa cha' nu xtin' um loo chendyu re, cua' nguitin' na la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Xiya' cunen lo'o um, cha' tucua um ca sca cha' ti 'in um loo chendyu re, lo' nchgaa cha' nu jñan um 'in Stin, ñi nu nducua ni' cuaan, cui' ñi cu'ni ñi cha' can'. ");
INSERT INTO cya_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Si'yana se'en ndiyo' ti'in tucua snan jun si'ya cha' 'ñan, nan' ndon tlu'hue la can'. ");
INSERT INTO cya_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Xacan' mdiyaa yu Tyo la tloo ñi, lo' juin yu: Ñi X'nan hua, ¿ñi ncua ya' cu'nin cha' tlyu ti' 'in sca yu ta'a na nu cu'ni sca cha' ngunan' lo'on? ¿Tsa cati ya'? ");
INSERT INTO cya_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Juin Jesús 'in yu: Si'i tsa cati ya', cui' ca nu snan yla ntsu'hui tii ya' cu'ni um cati can'. ");
INSERT INTO cya_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Can' cha' tsaña'an ndlo Ndiose tñan, su'hua ña'an nguiaa cha' 'in na lo'o cha' 'in sca yu ree nu m'ni chu'hue cunta 'in lo'o nguso 'in. ");
INSERT INTO cya_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Xa mdyisnan m'ni yu cunta, mdiyaa sca nguso nu nducui tyun millon tñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Lo' si'yana a ncua 'in yu xu'hua lyiya' yu tni' can', ngulo x'nan yu tñan si'yana ca quiya' yu, tsatlyu lo'o nten 'in yu lo'o sñe' yu lo'o nchgaa na nu ndi'in 'in yu, lo' cuaña'an xicuten yu tñi nducui yu. ");
INSERT INTO cya_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Xacan' mdyi'ya xtyin' yu nguso can', mjñan yu cha' tsu'hue 'in x'nan yu, lo' nchcui' yu: Ñi x'nan hua, chu'hui cha' tlyu ti' 'in um lo'on, nan' xu'hua lyiyan' ña'aan tñi nu nducuin 'in um. ");
INSERT INTO cya_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","X'nan nguso can' mña'an 'tnan ti' 'in yu, lo' m'ni cha' tlyu ti' 'in yu lo'o tñi can', lo' ngulaa 'in yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ña'aan mdo'o yu nguso can', mchcua tucui yu 'in xca ta'a nguso yu nu nducui tsachin' tñi 'in yu, cui' xaa yaa yu lo' msñan' yu yni, lo' nchcui' yu: Xu'hua lyiya' na nu nducui 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ta'a nguso yu can' mdyi'ya xtyin' tloo yu, lo' mjñan cha' tsu'hue 'in yu, lo' nchcui': Chu'hui cha' tlyu ti' 'in lo'on, nan' xu'hua lyiyan' ña'aan tñi nu nducuin 'in. ");
INSERT INTO cya_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Una yu nguso can' a m'ni yu cunta cha' can', cui' ca nu msu'hua yu 'in na'an chcuan, lo' can' chu'hui yu tsaya' nu xu'hua lyiya' tñi can'. ");
INSERT INTO cya_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Xa na'an nchgaa la ña'an ta'a lca yu nguso cha' nu yato'o, ndyijyin ya' ngulu'un ti' yu, lo' ya taa yu suun 'in x'nan yu nchgaa cha' nu yato'o. ");
INSERT INTO cya_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Xacan' msi'ya x'nan nguso can' 'in yu lo' juin: Nu'huin lca sca nguso nu nducun', ña'aan tñi nducui 'ñan m'ni cha' tlyu ti' 'in lo'o na, si'yana mjñan cha' tsu'hue 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lo' nu'huin jan ñi, ¿ta a ncua cu'ni cha' tlyu ti' 'in ta'a lca nguso, tsaña'an nu nan' m'nin lo'o? ");
INSERT INTO cya_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lyee 'a ycuen tique' x'nan yu, lo' mdyaa cunta 'in yu se'en nu ntsu'hui cha' tyijyin nu ti'i, tsaya' nu xu'hua lyiya' yu ña'aan tñi nducui yu. ");
INSERT INTO cya_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Cui' cuaña'an cu'ni Stin, ñi nu nducua ni' cuaan lo'o um, cha' a cu'ni um cha' tlyu ti' lo'o nu chcui lca tiquee um, 'in cunda scaa ta'a um nu ngui'ni cha' ngunan' lo'o um. ");
INSERT INTO cya_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yato'o xa mdyi ycui' Jesús cha' re, mdo'o ñi se'en lyi'ya loo Galilea, lo' mdiyaa ñi se'en lyi'ya loo Judea, mdo'o ca'an ñi xca tso' chco tlyu Jordan. ");
INSERT INTO cya_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Qui'an 'a nten mducui ncha'an 'in ñi, can' m'ni chca ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Xacan' mdiyaan tucua snan ne' fariseo, lo' nan ne' ña'an su'hua ne' qui'ya 'in ñi lo'o cha' nu xcuen ñi, lo' juin ne' 'in ñi: ¿Ta ntsu'hui cha' cuiya' 'in yu qui'yu cula' ti'in yu 'in cuilyi'o yu, si'ya cha' a ngujlyo ña'an? ");
INSERT INTO cya_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mxcuen ñi 'in ne': ¿Ta na a nchca chcui' um quityi se'en mdyisnan suun cha' re? Ñi nu mtñan 'in nten chendyu, —qui'yu lo' cuna'an mtñan ñi—, ");
INSERT INTO cya_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","lo' juin ñi: —Can' cha' yu qui'yu ntsu'hui cha' tyi'o tso' yu sii' sti yu lo'o jyi'an yu, lo' tyi'in yu lo'o cuilyi'o yu, lo' chcuaa can' sca tucui ti lca—. ");
INSERT INTO cya_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Cua' si'i 'a tucua lca can', cui' ca nu scati lca can', can' cha' nu cua' m'ni sca Ndiose 'in, a ntsu'hui 'a cha' ti' cula' ti'in ta'a. ");
INSERT INTO cya_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xacan' juin ne' 'in ñi: ¿Ñi cha' Moisé mdaa cha' cuiya' 'in yu qui'yu cula' ti'in yu cuilyi'o yu, cha' na tsa' scua sca quityi 'in yu? ");
INSERT INTO cya_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Lo' juin ñi 'in ne': Si'ya cha' tla cusya 'in um, mdaa Moisé cha' cuiya' si'yana tyi'o cha' cuilyi'o 'in um, una si'i cuaña'an lca na ti' culoo. ");
INSERT INTO cya_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Una nan' cunen lo'o um, yu cula' ti'in 'in cuilyi'o lo' tyi'in lo'o xca ne' cuna'an, qui'ya ngui'ni can', cui' cuaña'an ne' cuna'an nu ngula' ti'in yu can', cha' tyi'in ne' lo'o xca yu qui'yu, ticui' qui'ya ngui'ni ne'. Si'ya scati cha' tca tyi'o cha' cuilyi'o 'in nten, cha' na yten yu'hui can' lo'o xca tucui. ");
INSERT INTO cya_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yu ta'a nda'an ñi can' juin yu 'in ñi: Cha' cuaña'an ndi'in cha' 'in yu qui'yu lo'o ne' cuna'an, a ndyi'o tñan ja cuilyi'o yu. ");
INSERT INTO cya_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Xacan' juin ñi 'in yu: Si'i nchgaa tucui tca qui'ya cunta cha' re, cui' ca nu tsalca nu cua' mdaa Ndiose cha' cuiya' 'in tca cuan xu'hue cha' re. ");
INSERT INTO cya_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ntsu'hui yu nu lca eunuco nu cua' lca ña'an xa ngula, lo' ntsu'hui yu nu nchca eunuco lo'o cunta 'in nten chendyu, a cunta ntsu'hui yu nu nsu'hua juesa 'in lo'o cha' re si'ya tñan 'in Ndiose. Yu nu cuan xu'hue cha' re, tsu'hue cha' tca cu'ni yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Xacan' mdiyan lo'o ne' 'in nu suhue ti tloo ñi, si'yana tyi'in tyaa ñi yaa' ñi que, lo' jñan ñi 'in Ndiose si'ya. Lo' yu ta'a nda'an ñi ngusun lo'o yu 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Una Jesús juin ñi 'in yu: Tyaa um ya' caan nu suhue ti se'en ndon, lo' a chcui ndijin um, si'yana se'en ndlo Ndiose tñan sten tsalca nu cu'ni lyo' 'in tsaña'an nu suhue ti re. ");
INSERT INTO cya_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Xa cua' mdi'in tyaa ñi yaa' ñi que nu suhue ti can', mdo'o ñi nguiaa ñi. ");
INSERT INTO cya_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Xacan' mdiyaan sca yu juin 'in ñi: 'Un lca um bstro nu tsu'hue ca, ¿ñi tñan tsu'hue cu'nin si'yana caja chendyu nu a tsatii 'a 'ñan? ");
INSERT INTO cya_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Xacan' juin ñi 'in yu: ¿Ñi cha' nchcui' si'yana lcan sca nu tsu'hue? Scati Ndiose tsu'hue ñi. Cha' nchca ti' caja chendyu nu a tsatii 'a 'in, xu'hua se'en cha' nu ngulo ñi tñan. ");
INSERT INTO cya_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lo' juin yu: ¿Ti ña'an ta cha'? Mxcuen Jesús 'in yu: —A cujui um nten, a sten yu'hui um lo'o cuilyi'o nten, a cu'ni um cunan, a chcui' um cha' cuiñi. ");
INSERT INTO cya_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Cu'ni suun um 'in um tloo sti um lo'o jyi'an um—, a cunta —ña'an 'tnan ti' um 'in ta'a nten um tsaña'an n'ni um 'tnan 'in um—. ");
INSERT INTO cya_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Xacan' mxcuen yu 'in ñi: Ti' lyon' nxu'hua se'en nchgaa cha' re. ¿Ti ña'an la cha' ti' lyijyi 'ñan? ");
INSERT INTO cya_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Juin Jesús 'in yu: Cha' nchca ti' ca sca nu ñi ndi'in cha' 'in, quiaa lo' cujui' nchgaa na nu ndi'in 'in, lo' cutsa tñi can' 'in nu ti'i, cuaña'an caja cha' cuilyiya' 'in la ni' cuaan, xacan' ljyaan lo' chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Xa ngune 'in yu cha' can', ngulu'un 'a ti' yu si'yana ndyijyin ya' cuilyiya' yu. ");
INSERT INTO cya_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Xacan' juin Jesús 'in yu ta'a nda'an ñi: Nu cha' ñi cunen lo'o um, tucui 'a ña'an sten ne' cuilyiya' se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Xiya' cunen lo'o um: Cuti la tyijyin sca camello quito quiya' cuxa, que nu sten sca yu cuilyiya' se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Xa ngune 'in yu ta'a nda'an ñi cha' re, lyee 'a yuhue ti' yu lo' nchcui' yu: ¿Ti nu ta tca tyi'o laa cha' na can'? ");
INSERT INTO cya_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Xacan' mxina'an Jesús 'in yu, lo' juin ñi: Cha' 'in nten, a ndyijyi ña'an cha' re, una a sca cha' tucui 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yu Tyo mdo'o ycui' yu lo' juin yu 'in ñi: Ña'an um jan ñi, huare' cua' ngula' ti'in hua nchgaa na nu ndi'in 'in hua, lo' nducui ncha'an hua 'in um, ¿ñi cha' tsu'hue ta qui'ni ca'an 'in hua? ");
INSERT INTO cya_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mxcuen Jesús 'in yu ta'a nda'an ñi: Nu cha' ñi cunen lo'o um, tiyaa xaa chca cui nchgaa cha', xa nu Yu Qui'yu nu Mdo'o nde ni' Cuaan chcua ñi loo xaa se'en ntsu'hui cha' culo ñi tñan, nchgaa 'un nu nducui ncha'an 'ñan, lo'o um ntsu'hui cha' chcua um loo tsa tichcua yca xlya, lo' cu'ni cuiya' um cha' 'in tsa tichcua ta nten 'in ne' Israel. ");
INSERT INTO cya_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ña'an tucui ti nu xnu tucua na'an 'in, uta xnu ti'in ta'a ngula, uta 'in sti lo'o jyi'an, lo'o cuilyi'o, lo'o sñe', uta yuu se'en n'ni tñan, cui' si'ya cha' 'ñan, qui'an la caja 'in can', a cunta lo'o chendyu nu a tsatii 'a. ");
INSERT INTO cya_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Si'yana qui'an 'a nu culoo cua' ñii, quinu ca'an chon' can' tiyaa xaa. Lo' nu nguinu ca'an chon' cua' ñii, can' nu chcua loo tiyaa xaa. ");
INSERT INTO cya_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tsaña'an ndlo Ndiose tñan, nguiaa cha' 'in na ña'an ndi'in cha' 'in sca nu ndlo tñan, lo' tlya mdo'o yu nguia nan yu nguso nu cu'ni tñan se'en nducua ti uva 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xa cua' m'ni cuiya' yu cha' lo'o si'yana su'hua lyiya' yu 'in tsaña'an siya' yu sca tsaan, xacan' ngua'an tñan yu 'in la loo xñan yu. ");
INSERT INTO cya_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tsa ntsu'hui braa cua' caa tlya mdijin yu nde loquiya', can' na'an yu tucua snan yu nu a sca tñan ngui'ni, ");
INSERT INTO cya_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","lo' juin yu 'in: Yaa um lo' cu'ni um tñan 'ñan, lo' su'hua lyiyan' 'in um ña'an nu ntsu'hui cha', lo' mdo'o yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Xiya' tsa ntsu'hui ndyi'ya cuaan lo'o braa cua' snan siin, mdo'o x'nan tñan can' nguiaa, ticui' ti ña'an m'ni yu. ");
INSERT INTO cya_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Xiya' mdo'o yu tsa ntsu'hui braa cua' ca'yu siin, nguija lyoo chcua xnan yu nu a sca tñan ngui'ni, lo' juin yu 'in: ¿Ñi cha' ndon um chcui tsaan re, lo' a sca tñan ngui'ni um? ");
INSERT INTO cya_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mxcuen yu 'in: Si'yana a nchca tucui cuni 'in hua. Xacan' juin x'nan tñan can': Tsaa na lo' cu'ni um tñan, lo' caja siya' um ña'an nu ntsu'hui cha'. ");
INSERT INTO cya_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Xa msiin tsaan can', x'nan tñan can' msi'ya 'in yu nu ntsu'hui cunta tñan, lo' juin 'in yu: Xi'ya 'in yu nu m'ni tñan cua lo' su'hua lyiya' tsaan 'in yu, una tyisnan lo'o yu nu yten tñan la msiin la, lo' cuaña'an tsa quiñan lo'o nchgaa la ña'an yu. ");
INSERT INTO cya_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Xa mdiyaan yu nu yten tñan braa cua' ca'yu siin can', cunda scaa yu jui siya' yu tsaña'an siya' yu sca tsaan. ");
INSERT INTO cya_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Xa mdiyaan yu nu yten tlya can', ñan ti' yu si'yana qui'an la caja 'in yu, una scaña'an ti jui siya' yu, cha' 'in sca tsaan. ");
INSERT INTO cya_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Una xa cua' msñi siya' yu, xacan' mdyisnan ycui' tyijyin yu lo'o x'nan tñan can', ");
INSERT INTO cya_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","lo' nchcui' yu: Yu nu yten tñan la msiin la, seen sca braa ti m'ni yu tñan, lo' su'hua ña'an msu'hua lyiya' um 'in hua lo'o yu, lo' chcui tsaan m'ni hua tñan, a cunta tique' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Xacan' mxcuen x'nan tñan can' 'in sca yu can': Migo, a ngui'nin ti'i lo'o, ¿ta a nguinu na cha' si'yana xñi siya' cha' 'in sca tsaan? ");
INSERT INTO cya_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xñi lya siya' lo' quiaa, una nan' nchca tin' su'hua lyiyan' 'in yu nu yten msiin la re, tsaña'an nu msu'hua lyiyan' 'in nu'huin. ");
INSERT INTO cya_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ta a ntsu'hui suun 'ñan cu'nin ña'an nu nchca tin' lo'o na nu 'ñan? ¿Uta na ntsu'hui cha' jñan ti' 'in si'yana tsu'hue cha' 'ñan? ");
INSERT INTO cya_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Can' cha' nu culoo cua' ñii, quinu ca'an chon' can' tiyaa xaa, lo' nu nguinu ca'an chon' cua' ñii, ntsu'hui cha' ca nu culoo, si'yana qui'an nten jui nu msi'ya 'in, una chin' ti nu mdo'o hui. ");
INSERT INTO cya_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús mdo'o ñi nguiaa ñi quichen Jerusalén, lo' tucueen nguiaa jun sca cunta ycui' ñi lo'o tsa tichcua yu can', lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Cua' ñii tsaa na quichen Jerusalén, lo' Yu Qui'yu nu Mdo'o nde ni' Cuaan, ntsu'hui cha' quinu ñi tuyaa' yu nu ndlo ca tñan ni' lyaa, lo'o ne' escriba, lo' culo qui'ya ne' 'in ñi tsaya' caja ñi. ");
INSERT INTO cya_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tyaa ne' cunta 'in ñi yaa' ne' gentil, xacan' taa ne' cha' jyi'o 'in ñi, jyi'in ne' 'in ñi lo' jyi'in ca'an ne' 'in ñi loo cusi, una nu cua' ca snan tsaan ntsu'hui cha' tyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Xacan' mdiyaan cuna'an 'in yu Zebedeo lo'o chcuaa sñe' ne', lo' mdyi'ya xtyin' tloo ñi, lo' mjñan sca cha' tsu'hue 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lo' juin ñi 'in: ¿Ñi na nchca ti'? Ne' cuna'an can' juin 'in ñi: Taa um cha' cuiya' 'in chcuaa sñen' nan', si'yana scaa tso' sii' um chcua se'en ntsu'hui cha' culo um tñan. ");
INSERT INTO cya_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Xacan' mxcuen Jesús: A jlyo ti' um ñi na njñan um. ¿Ta tca tyijyin um nu ti'i tsaña'an ntsu'hui cha' tijin, lo' sca nu ti'i ti tyijyin na lo'o um? Mxcuen yu 'in ñi: Tca 'in hua. ");
INSERT INTO cya_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lo' juin ñi 'in yu: Cha' ñi ña'an nu nchcui' um si'yana sca nu ti'i ti ntsu'hui cha' tyijyin na, lo' scaña'an ti tyijyin na lo'o um. Una nu chcua um tso' cueen 'ñan lo'o tso' ca, si'i cunta 'ñan lca cha' can', cui' ca nu can' chcua nu taa Stin cha' cuiya' 'in. ");
INSERT INTO cya_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cha tii yu ta'a nda'an ñi, xa ngune 'in yu cha' nu ycui' chcuaa yu can', lyee 'a ycuen tique' yu. ");
INSERT INTO cya_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Xacan' msi'ya Jesús 'in nchgaa yu, lo' juin ñi: 'Un cua' jlyo ti' um si'yana tsalca yu nu ndlo tñan quichen tnu, si'ya cha' cuiya' 'in yu n'ni x'nan ne' 'in yu, lo' yu nu ndon loo 'in yu tla 'a ndlo can' tñan. ");
INSERT INTO cya_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Una si'i cuaña'an cu'ni um, cui' ca nu cha' nde'en um nchca ti' um ca um nu ndon loo, can' nu tucua tloo nchgaa tucui. ");
INSERT INTO cya_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nu nchca ti' ca nu ndon loo, can' nu ca nguso 'in nchgaa tucui. ");
INSERT INTO cya_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan, a ljyan nan ñi nu ca nguso 'in ñi, cui' ca nu si'yana ca ñi nguso 'in nchgaa tucui, lo' taa ñi chendyu 'in ñi si'yana tyi'o laa qui'an nten. ");
INSERT INTO cya_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Xa mdijin jun tu'hua quichen Jericó, qui'an 'a nten mducui ncha'an 'in jun. ");
INSERT INTO cya_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tu'hua tucueen can' nducua tucua yu cuityin', xa ngune 'in yu si'yana ndijin Jesús can', msi'ya cueen yu 'in ñi: Ñi X'nan hua, Sñe' ta nten 'in Davi, ña'an 'tnan ti' um 'in hua. ");
INSERT INTO cya_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Scasca nu ngusun lo'o 'in yu si'yana chcua seen tu'hua yu, una nde lyee la msi'ya yu 'in ñi: Ñi X'nan hua, ta nten 'in Davi, ña'an 'tnan ti' um 'in hua. ");
INSERT INTO cya_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Xacan' ycan' ton Jesús, msi'ya ñi 'in yu lo' juin ñi: ¿Ñi na ta nchca ti' um? ");
INSERT INTO cya_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mxcuen yu: Ñi X'nan hua, nchca ti' hua si'yana quila xaa quiloo hua. ");
INSERT INTO cya_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús mña'an 'tnan ti' 'in yu, yla' ñi quiloo yu, cui' xaa nguila xaa quiloo yu, lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Xa cua' tiyaa ti jun quichen Jerusalén, cui' ti can' ndi'in quichen Betfagé se'en nducua qui'ya Olivo, xacan' ngua'an tñan Jesús 'in tucua yu ta'a nda'an ñi. ");
INSERT INTO cya_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Lo' juin ñi 'in yu: Yaa um se'en ndi'in quichen lyo' ti cua, can' quija lyoo um nchcan' ton sca burra lo'o sñe', xtin' um 'in 'in lo' quian lo'o um 'in 'in. ");
INSERT INTO cya_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Cha' ntsu'hui nu cuñicha' 'in um nde'en la cha', ljuin um 'in: Ñi X'nan na nchca ti' 'in 'in, una cui' xaa quian lo'o hua 'in 'in. ");
INSERT INTO cya_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nchgaa cha' re yato'o na si'yana tsa tucua cha' nu mxiycui' Ndiose 'in nguso 'in ñi cua' s'ni, xa juin yu: ");
INSERT INTO cya_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","—Chcui' um lo'o ne' Jerusalén: Ña'an um jan ñi, nde cua' ljyaan ñi nu lca Ree 'in um, suun ña'an ndi'in cha' 'in ñi, nducua ñi chon' sca burru cune' ti, sñe' sca 'ni nu ndyi'ya yu'hua—. ");
INSERT INTO cya_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yu ta'a nda'an Jesús yaa yu, lo' m'ni yu ña'an nu ngulo ñi tñan 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nguian lo'o yu 'in burra can' lo'o sñe' 'in, lo' msla scua yu ste' yu chon' 'in, lo' mducua ñi 'in 'in. ");
INSERT INTO cya_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nten qui'an can' mdyisnan msla sti ne' ste' ne' tucueen ljyaan ñi, ntsu'hui nu ncha stan' quixin', ticui' cuaña'an ndyi'in tyaa ne' 'in na tucueen ljyaan ñi. ");
INSERT INTO cya_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nten nu nducua loo can' lo'o nu ljyaan nde chon' nchcui' ne': ¡—Culo laa um 'in hua—, 'un ñi nu lca Sñe' ta nten 'in Davi! ¡—Tlyu cha' tsu'hue ntsu'hui 'in ñi nu ljyaan lo'o cha' cuiya' 'in Ñi X'nan na! ¡Culo laa um 'in hua—, 'un ñi nu nducua la ni' cuaan! ");
INSERT INTO cya_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Xa yten ñi Jerusalén, ña'aan quichen ne' nguilo ti'in ne', lo' nchcui' ne': ¿Tucui ca lca yu re? ");
INSERT INTO cya_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nten nu nducui ncha'an can' juin ne': Nde nu lca Jesús, ñi nu nxiycui' Ndiose 'in, nu mdo'o quichen Nazaret se'en lyi'ya loo Galilea. ");
INSERT INTO cya_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Xacan' yten Jesús ni' lyaa se'en ngui'ni tnu ne' 'in Ndiose, ngulo ñi 'in nchgaa nu ndyujui' na lo'o nu nsi'i na, mxitlyu ñi msa se'en nducua yu nu nxitsa'an tñi, lo'o yca xlya 'in yu nu ndyujui' quiñi, ");
INSERT INTO cya_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","lo' juin ñi: Ndeña'an nguinu scua sca cha' loo quityi 'in Ndiose: —Na'an 'ñan lca na se'en nchcui' lyi'o ne' 'ñan—, lo' 'un ngui'ni um 'in na lca na —na'an tyi yu cunan—. ");
INSERT INTO cya_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Se'en ndlyu ñi ni' lyaa can', mdiyan lo'o ne' 'in nu cuityin' lo'o nu co' quiya', lo' m'ni chca ñi 'in. ");
INSERT INTO cya_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Una yu nu ndlo tñan ni' lyaa lo'o ne' escriba, lyee ycuen tique' ne' xa na'an ne' cha' nu tnu ngui'ni ñi, a cunta ne 'in ne' ña'an nchcui' yu suhue ti ni' lyaa can': ¡—Culo laa um 'in hua—, 'un ñi nu lca Sñe' ta nten 'in Davi! ");
INSERT INTO cya_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Lo' juin ne' 'in ñi: ¿Ta ne 'in cha' nu nchcui' yu suhue ti re? Xacan' mxcuen Jesús 'in ne': Nen 'ñan, ¿ta na a nchca chcui' um cha' re: —Ndiose m'ni ñi cha' si'yana tu'hua nu suhue ti lo'o nu ti' nguiti' cu'ni tnu 'in ñi—? ");
INSERT INTO cya_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Xacan' mxnu ton ñi 'in ne', mdo'o ñi nguiaa ñi quichen Betania, can' nguinu ñi sca tla. ");
INSERT INTO cya_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tlya ti xca tsaan can' mxitucui ñi nde quichen Jerusalén, lo' mdyisnan ngute' ti' ñi. ");
INSERT INTO cya_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tu'hua tucueen can' na'an ñi nducua sca yca higo, mdiyaa ñi se'en nducua na, lo' na'an ñi si'yana a lyi'yu mti loo na, cui' ca nu chacui' lca' ti na nducua. Lo' juin ñi 'in na: Ñi xca tsaan, lo' a ña'an 'a cui'yu mti loo. Cui' xaa ngutyi yca higo can'. ");
INSERT INTO cya_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Xa na'an yu ta'a nda'an ñi cha' re, lyee 'a yuhue ti' yu lo' nchcui' yu: ¿Ña'an ta ncua ngutyi yca re cui' xaa? ");
INSERT INTO cya_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mxcuen Jesús 'in yu: Nu cha' ñi cunen lo'o um, cha' 'un tsa qui'an ti' um lo' a cu'ni tucua ti' um, si'i tsaña'an m'nin tin lo'o yca higo re tca cu'ni um, cui' ca nu tca chcui' um lo'o qui'ya cua: Tyi'o se'en nducua lo' tsa yu'hui la loo tyi'a tujo'o, lo' cui' cuaña'an tsato'o. ");
INSERT INTO cya_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Cha' tsa qui'an ti' um, chcuan um cunta nchgaa cha' nu jñan um 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yato'o xiya' yten ñi ni' lyaa, lo' yu nu ndlo ca tñan ni' lyaa, lo'o qui'yu cula mdiyaa ne' se'en ndlo'o ñi 'in nten can', lo' juin ne' 'in ñi: ¿La jui cha' cuiya' 'in nu ngui'ni cha' re, lo' ti nu mdaa 'in na 'in? ");
INSERT INTO cya_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mxcuen Jesús 'in ne': Lo'on nan' nchca tin' cuñichan' 'in um sca cha', lo' cha' xcuen um 'ñan lo'o cha' re, xacan' quitsan' 'in um la jui cha' cuiya' nu ngui'nin cha' re. ");
INSERT INTO cya_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tsaña'an nu mducua tya yu Xuhua 'in nten, ¿la mdo'o cha' cuiya' can'? ¿Se'en nducua Ndiose, uta tso' 'in nten chendyu? Xacan' scasca ne' mñicha' ta'a ne': Cha' ljuin na si'yana la ni' cuaan mdo'o cha' cuiya' can', tina'an xcuen yu 'in na, ñi cha' a ya qui'an ti' na cha' can'. ");
INSERT INTO cya_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Cha' ljuin na si'yana nten chendyu mdaa cha' cuiya' can', una a tca chcui' na cuaña'an, si'yana ña'aan quichen ne' cua' jlyo ti' ne' si'yana yu Xuhua can' ncua yu sca nu mxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Xacan' mxcuen ne' 'in Jesús: A jlyo ti' hua. Juin ñi 'in ne': Ñi nan' lo' a quitsan' 'in um la jui cha' cuiya' re 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","¿Ña'an ta ljuin um lo'o cha' re? Sca yu qui'yu ndi'in tucua sñe' yu, lo' juin yu 'in nu culoo can': Sñen', yaa chin' tñan 'ñan tsaan re ñii se'en nducua ti uva cua. ");
INSERT INTO cya_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Xacan' mxcuen yu: A nchca tin' tsa'an, una chon' nde'en can' mxitsa'an yu cha' tiyaa 'in yu, lo' yaa yu. ");
INSERT INTO cya_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ticui' cuaña'an juin yu 'in xca sñe' yu, una sñe' yu mxcuen 'in yu: Nan' tsa'an. Una a yaa yu. ");
INSERT INTO cya_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ti ña'an ta chcuaa yu re mducua yu tñan cha' nu ycui' sti yu? Mxcuen ne' 'in ñi: Yu nu culoo can'. Juin Jesús 'in ne': Nu cha' ñi cunen lo'o um, nten nu nducun' lati, culo nducua lati can' sten se'en ndlo Ndiose tñan que 'in um. ");
INSERT INTO cya_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Cua' yaan yu Xuhua lo' ngulo'o yu cha' nu ñi, una a ya qui'an ti' um cha' nu ycui' yu, una nten nu nducun' lati, lo' ya qui'an ti' ne', una 'un na'an tloo um cha' re lo' a mxilo'o chon' um qui'ya ngui'ni um, ñi a ya qui'an ti' um cha' nu ycui' yu. ");
INSERT INTO cya_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nde xca cha' nu chcuin' lo'o um: Sca yu qui'yu yta yu sca jyaan chacui' ti uva, lo' msu'hua lo'o yu 'in na, mtñan yu sca se'en tyi'o tyi'a uva can', a cunta mtñan yu sca se'en cuaan si'yana chcua nu chu'hui cuan 'in na. Mxnu yu 'in na 'in xca tucui nda tlu'hue, lo' mdo'o yu nguiaa yu sca se'en tijyo'. ");
INSERT INTO cya_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Xa mdiyaa xaa nu ntsu'hui cha' quio' mti can', ngua'an tñan yu nguso 'in yu nu tsa chcuan cunta na nu qui'ni ca'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Una yu nu ntsu'hui cunta tñan can', cuaña'an ti m'ni yu lo'o nguso nu mdiyaa can', ntsu'hui nu mjyi'in yu 'in, lo' xca can' yjui yu, lo' xca can' mjyi'in yu quee 'in. ");
INSERT INTO cya_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Xiya' ngua'an tñan x'nan tñan can' qui'an la nguso 'in yu, una ticui' ti ña'an m'ni lyi'o yu 'in can'. ");
INSERT INTO cya_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Una la xca ti ya' can' ngua'an tñan yu 'in sñe' yu, lo' ndeña'an nguñan ti' yu: Tina'an cu'ni cunta yu cha' nu chcui' sñen' nan'. ");
INSERT INTO cya_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Una yu nu ntsu'hui cunta 'in tñan can', xa na'an yu ljyaan sñe' x'nan tñan can', ndeña'an ycui' scasca yu: Nde ljyaan yu nu ntsu'hui cha' chcuan cunta tñan re, ndla ti um lo' cujui na 'in yu, lo' quinu tñan re 'in na. ");
INSERT INTO cya_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Cui' xaa ngulo yu 'in nde chon' lo'o can', lo' yjui yu 'in. ");
INSERT INTO cya_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Xa caan x'nan tñan can', ¿ña'an ta cu'ni can' lo'o yu nu ntsu'hui cunta tñan can'? ");
INSERT INTO cya_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mxcuen ne' 'in ñi: Cu'ni lyi'o yu 'in can' a se'en 'a ña'an, lo' cujui yu 'in, lo' cunan yu xca nu chu'hui cunta tñan can', cui' nu tyaa cunta na nu ntsu'hui cha' qui'ni ca'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Lo' juin Jesús 'in ne': ¿Ta a nchca chcui' um quityi se'en nguinu scua sca cha': —Quee nu mscuan tloo yu cuityi na'an, cua' ñii lca na quee nu nsñi ton 'in na'an. Ñi X'nan na m'ni ñi cha' re, lo' nduhue ti' na cha' nu na'an tloo na—? ");
INSERT INTO cya_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cunen lo'o um sca cha', Ndiose ntsu'hui cha' chcuan ñi cha' tsu'hue can' 'in um, lo' taa ñi 'in na 'in xca ta nten nu jlyo ti' su'hua loo 'in na. ");
INSERT INTO cya_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nchgaa nu tlyu scua chon' quee can', quita ti'in can', una cha' tyu quee can' chon', quinu ta can' siya' ti. ");
INSERT INTO cya_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yu nu ndlo ca tñan ni' lyaa can' lo'o ne' fariseo, cui' xaa ngu'ya ne' cunta si'yana cha' 'in ne' ca ycui' ñi. ");
INSERT INTO cya_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngunan ne' ña'an nu quinu ñi, una a msti ti' ne' si'yana nguitsen ne' 'in nten quichen can', si'yana cha' nu 'in nten can' lca ñi sca nu nxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Xiya' mdyisnan ycui' Jesús xca cha' lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Se'en ndlo Ndiose tñan, nguiaa cha' 'in na tsaña'an ndi'in cha' 'in sca yu ree nu msu'hua ta'a se'en jui cuilyi'o sñe'. ");
INSERT INTO cya_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xacan' ngua'an tñan yu nguso 'in yu tsa te'en 'in nchgaa nu cua' ngua'an cha' 'in tsaa ta'a can', una a mslyaa ne' tsaa ne'. ");
INSERT INTO cya_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Xiya' ngua'an tñan yu xca ta nguso 'in yu, lo' juin yu 'in: Chcui' um lo'o nchgaa nu ntsu'hui cha' caan ta'a re, si'yana cua' m'ni cha' ngujui 'ni lo'o bta cojo' 'ñan, cua' ncua tsu'hue scua re, cua' ndi'in tiyaa nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Una a tucui nu mdaa quiya' cha' nu ycui' yu nguso can', cui' ca nu ntsu'hui nu nguiaa loo xñan, lo' xca can' nguiaa loo cha' jyinsya 'in. ");
INSERT INTO cya_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A cunta ntsu'hui nu cua' ña'an ti m'ni lyi'o 'in yu nguso can', nu hasta lo'o yjui ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Xa ynan yu ree can' cha' re, cui' xaa ycuen tique' yu, msu'hua yu sindatu 'in yu tsa jlyo nchgaa nu yjui nguso 'in yu, lo' mdiquin yu quichen can'. ");
INSERT INTO cya_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Xacan' juin yu lo'o nguso 'in yu: Nu cha' ñi si'yana cua' lca ta'a re, una nu ntsu'hui ca cha' caan, a ngujlyo ti' cuan xu'hue cha' re. ");
INSERT INTO cya_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Can' cha' cua' ñii, yaa um la tucueen cua, lo' chcui' um lo'o ña'an tucui ti nu quija lyoo um si'yana caan ta'a re. ");
INSERT INTO cya_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mdo'o yu nguso can' nguiaa yu la tucueen, lo' mdyisnan nguni yu ña'an tucui ti nu nguija lyoo yu, ne' nducun' lo'o nten tsu'hue, lo' mtsa'an yu'hui ne' se'en nchca ta'a can'. ");
INSERT INTO cya_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Xacan' yten yu ree can' nu chcui' cha' yu 'in nten can', can' na'an yu nducua sca nu a lco' te', tsaña'an nchco' nten nu ndyi'an ta'a se'en ndyijyi cuilyi'o ne'. ");
INSERT INTO cya_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lo' juin yu 'in: Migo, ¿ña'an ncua yten se'en nchca ta'a re, lo' a lco' te' ña'an nu ntsu'hui cha' co'? Una yu can', ñi sca cha' lo' a mxcuen yu. ");
INSERT INTO cya_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Xacan' juin yu ree can' lo'o yu nu nsu'hua na loo msa: Scan' um quiya' yu lo'o yaa' yu, lo' cuun 'in yu nde lyiya' se'en tla yta, cua xtyi ynan yu loo nu lyee tyijyin yu nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Si'yana qui'an nten jui nu msi'ya 'in, una chin' ti nu mdo'o hui. ");
INSERT INTO cya_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Xacan' mdo'o ne' fariseo nguiaa ne', lo' m'ni cuiya' ne' cha' ña'an ntsu'hui cha' culo qui'ya ne' 'in Jesús lo'o cha' nu chcui' ñi. ");
INSERT INTO cya_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ngua'an tñan ne' tucua snan yu nu m'ni cha'an cha' 'in ne', lo'o nu ntsu'hui tso' 'in ne' Herode, mdiyaa ne' se'en nguilyu ñi lo' juin ne': 'Un ñi nu lca Bstro, cua' jlyo ti' hua si'yana nchcui' um lo' ndlo'o um cha' nu ñi 'in Ndiose, ñi a nan um ña'an nu quinu tsu'hue tiquee nten lo'o um, lo' ñi a nxñi um cunta ña'an cha' 'in nten. ");
INSERT INTO cya_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Ña'an ljuin um lo'o cha' re, ta tsu'hue cha' ti' taa na tñi nu njñan yu César, uta na a tsu'hue 'a? ");
INSERT INTO cya_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Una Jesús ngujlyo ti' ñi si'yana nchcui' ne' lo'o cha' mañan, lo' juin ñi 'in ne': 'Un ne' nu a ñi ndi'in cha' 'in, ¿ñi cha' nan um ña'an nu su'hua um qui'ya 'ñan? ");
INSERT INTO cya_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tyaa um sca tñi 'ñan. Xacan' mdaa ne' sca tñi 'in ñi, nu n'ni ne' canan sca tsaan. ");
INSERT INTO cya_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Xacan' juin ñi 'in ne': ¿Tucui ta 'in lcuin nga'an chon' tñi re, lo'o niin nu nga'an 'in na? ");
INSERT INTO cya_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mxcuen ne' 'in ñi: Yu César. Lo' juin ñi 'in ne': Can' cha' tyaa um 'in César na nu qui'ni ca'an 'in yu, cui' cuaña'an tyaa um 'in Ndiose na nu qui'ni ca'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yuhue' ti' ne' xa ngune 'in ne' cha' re, xacan' ngula' ton ne' 'in ñi, mdo'o ne' nguiaa ne'. ");
INSERT INTO cya_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ticui' tsaan can' mdiyaa tucua snan ne' saduceo se'en nguilyu ñi, ne' nu a ndiya qui'an ti' si'yana ndyiqui'o ne' cua' ngujui, lo' mñicha' ne' 'in ñi: ");
INSERT INTO cya_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","'Un ñi nu lca Bstro, ngua'an scua yu Moisé sca cha' lo' nchcui' na: —Cha' sca yu qui'yu caja yu, lo' ñi sca sñe' yu lo' a mdi'in lo'o cuilyi'o yu, 'ni cha' ticui' ta'a ngula yu tyi'in lyi'o 'in ne' cuna'an can', lo' cha' tyi'in sñe' ne', cu'ni ne' cunta si'yana sñe' ne' lo'o cuilyi'o ca ne' lca can'—. ");
INSERT INTO cya_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nde sca cha' yato'o lja hua, mdi'in tsa cati yu qui'yu, sca ta'a ngula ti yu. Yu nu cula la can' jui cuilyi'o yu, lo' ngujui yu, lo' si'yana a mdi'in sñe' ne' lo'o yu, xca ta'a ngula yu mdi'in lyi'o 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ngujui can', lo' cuaña'an yato'o lo'o nu cua' nchca snan can' tsaya' mda'a cati yu can'. ");
INSERT INTO cya_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yato'o lo'o ne' cuna'an can' ngujui ne'. ");
INSERT INTO cya_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Xa ntsu'hui cha' tyiqui'o ne' cua' ngujui, ¿ti ña'an ta'a cati yu can' lca cuilyi'o ca ne' cuna'an can', si'yana nchgaa yu mdi'in lyi'o yu 'in ne'? ");
INSERT INTO cya_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Xacan' mxcuen Jesús 'in ne': Si'i ña'an cha' tiyaa 'in um, ¿ta na a ndyi'ya um cunta ña'an nchcui' quityi 'in Ndiose, lo' tsala ña'an tlyu cha' cuiya' 'in ñi? ");
INSERT INTO cya_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Xa ntsu'hui cha' tyiqui'o ne' cua' ngujui, a ntsu'hui 'a cha' ti' caja cuilyi'o ne', lo' ñi a taa 'a ne' cha' cuilyi'o 'in nten, cui' ca nu su'hua ña'an ndi'in cha' 'in ne' lo'o angujle 'in Ndiose la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Una cha' 'in ne' nu ntsu'hui cha' tyiqui'o, ¿ta na a nchca chcui' um quityi 'in Ndiose xa juin ñi: ");
INSERT INTO cya_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","—Nan' lcan Ndiose 'in Abraham, Ndiose 'in Isaac, Ndiose 'in Jacob—? Si'yana Ndiose a lca ñi Ndiose 'in ne' ngujui, cui' ca nu lca ñi Ndiose 'in ne' nu lo'o. ");
INSERT INTO cya_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Xa ngune 'in nten cha' nu ycui' ñi, lyee nduhue ti' ne' lo'o cha' nu ndlo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ne' fariseo xa na'an ne' si'yana Jesús m'ni ñi cha' ncua tiin 'in ne' saduceo can', cui' xaa m'ni sca ne' cha' 'in ne' ña'an ntsu'hui cha' cu'ni ne'. ");
INSERT INTO cya_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Lja can' ntsu'hui nu ndlo'o cha' 'in lee, mñicha' 'in ñi lo'o cha' mañan, lo' juin: ");
INSERT INTO cya_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","'Un ñi nu lca Bstro, ¿ti ña'an ta cha' nu ndon loo lati nu nchcui' lee? ");
INSERT INTO cya_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mxcuen Jesús 'in ne': —Lo'o nu chcui cusya 'in um tyaa um 'in um 'in Ndiose X'nan um, lo'o nu chcui lca tiquee um—, lo'o nchgaa cha' tiyaa 'in um. ");
INSERT INTO cya_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nde cha' nu tlyu lati lo' ndon loo la nu ntsu'hui cha' xu'hua se'en na. ");
INSERT INTO cya_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nu cua' nchca tucua ticui' ndon loo na: —Ña'an 'tnan ti' um 'in ta'a nten um tsaña'an n'ni um 'tnan 'in um—. ");
INSERT INTO cya_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chcuaa cha' re nsu'hua lo'o na 'in nchgaa la ña'an cha' nu nchcui' lee, lo'o cha' nu mxiycui' Ndiose 'in nguso 'in ñi cua' sñi. ");
INSERT INTO cya_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tsatlyu ndi'in ne' fariseo, lo' Jesús mñicha' ñi 'in ne' sca cha', ");
INSERT INTO cya_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","lo' juin ñi: ¿Ña'an ta ñan ti' um cha' 'in Cristo? ¿Tucui ta lca ñi? Mxcuen ne' 'in ñi: Cui' sñe' ta nten 'in Davi. ");
INSERT INTO cya_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Juin ñi xacan': ¿Ñi cha' ndlo'o naan Davi 'in ñi si'yana lca ñi X'nan yu, xa mxiycui' Espíritu 'in yu ndeña'an: ");
INSERT INTO cya_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","—Ndiose X'nan na juin ñi lo'o Ñi X'nan: Chcua tso' cueen 'ñan lja xicu'nin 'in ta'a cusuun quinu nde tuquiya'—? ");
INSERT INTO cya_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Cha' Davi ndlo'o naan yu 'in ñi lca ñi X'nan yu, ¿ña'an ta lca ñi sñe' ta nten 'in yu cha' na can'? ");
INSERT INTO cya_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Una a tucui nu ncua mxcuen 'in ñi lo'o cha' re, lo' ñi a tucui 'a msti ti' cuñicha' 'in ñi nde'en la cha'. ");
INSERT INTO cya_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Xacan' mdyisnan ycui' Jesús lo'o nten can' tsatlyu lo'o ta'a nda'an ñi, lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ne' escriba lo'o ne' fariseo nchcua ne', lo' ndlo'o ne' cha' 'in lee nu mxnu scua Moisé. ");
INSERT INTO cya_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ca ja'an um lo' tucua um tñan cha' nu nchcui' ne', una a nchca cha' cu'ni um ña'an nu n'ni ne', si'yana nchcui' ne' sca cha' lo' a n'ni ne' 'in na. ");
INSERT INTO cya_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Si'yana nxi 'ya ne' yu'hua nu ti'in 'in nten lo'o cha' nu ndlo'o ne', una cha' nu 'in ne', ñi tsachin' ti lo' a lca tiquee ne' qui'ni ca'an ne' 'in na. ");
INSERT INTO cya_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tsaloo ti n'ni ne' tñan tsu'hue si'yana caja nu chcua quiloo 'in ne', nducui ti' ne' ncha'an ycha' Ndiose tuchcan ne' lo'o scun ne', lyee la que ña'an nu ntsu'hui ca cha' cu'ni ne', ticui' cuaña'an n'ni chu'hue ne' tu'hua ste' ne'. ");
INSERT INTO cya_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nducui ti' ne' nchcu siin ne' se'en nchcua yu nu ndon loo lati, ticui' cuaña'an nan ne' se'en tsu'hue la nchcua ne' se'en n'ni tnu ne' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nducui ti' ne' ndyijyi nu chcui' cha' 'in ne' lo'o suun ña'an se'en nchca quiya', uta ndlo'o naan ne' 'in: Bstro, Bstro. ");
INSERT INTO cya_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Una 'un a tucua tloo um caja nu chcui' lo'o um, Bstro, si'yana scati ñi nu lca Bstro, cui' Cristo, lo' nchgaa la ña'an um lca um chacui' ta'a ngula um. ");
INSERT INTO cya_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A nchca cha' culo'o naan um 'in sca yu qui'yu, Stina, si'yana scati Ndiose nu nducua ni' cuaan lca Stina. ");
INSERT INTO cya_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ñi a tucua tloo um si'yana caja nu culo'o naan 'in um, Bstro, si'yana scati ñi nu lca Bstro, cui' Cristo. ");
INSERT INTO cya_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nu ndon loo lati ntsu'hui lja um, can' nu ntsu'hui cha' ca nguso 'in um. ");
INSERT INTO cya_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Si'yana nu scuen cuaan 'in ticuii', caja nu cu'ni lyo' 'in, lo' nu cu'ni lyo' 'in caja nu scuen cuaan 'in. ");
INSERT INTO cya_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡'Tnan ca 'un ne' escriba lo'o ne' fariseo, a ñi ndi'in cha' 'in um! Si'yana nchcui ndijin um tloo nten chendyu nu nchca ti' sten se'en ndlo Ndiose tñan, ñi ycui' um lo' a nguiten um lo' ñi a ndaa um ya' sten nten. ");
INSERT INTO cya_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡'Tnan ca 'un ne' escriba lo'o ne' fariseo, a ñi ndi'in cha' 'in um! Si'yana ndlyaa um na'an 'in ne' cuna'an nu nguinu lo'o cha' ycui' ti, lo' si'yana a ca chcan' cha' ngunan' nu ngui'ni um, can' cha' chaan nchcui' lyi'o um 'in Ndiose, una si'ya cha' re tlyu la yuhue' nso' tucua um chon' um. ");
INSERT INTO cya_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡'Tnan ca 'un ne' escriba lo'o ne' fariseo, a ñi ndi'in cha' 'in um! Si'yana ndyi'an snan sti um sca chcui chendyu si'yana cu'ni um canan siya' cua' tsu'hue scati nu sten tso' 'in um, lo' cha' cua' m'ni um canan 'in can', ndla lati tsaa can' loo quii' que 'in um. ");
INSERT INTO cya_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡'Tnan ca 'un nu nchcun cha' tiyaa 'in, lo' ndlo'o um 'in xca tucui! Cha' ntsu'hui nu ndlo ca 'in lo'o cha' 'in laa, a sca ntsu'hui lyoo na, una cha' ndlo'o naan can' oro nu ntsu'hui ni' lyaa, la xacan' nguinu scua tla cha' nu nchcui' can'. ");
INSERT INTO cya_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡'Un ne' tinto lo' nchcun cha' tiyaa 'in um! ¿Ti ña'an ta cha' re nu ndon loo la, oro uta na laa se'en ntsu'hui oro can'? ");
INSERT INTO cya_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A cunta nchcui' um: Cha' ntsu'hui nu ndlo ca 'in, lo' ndlo'o naan loo se'en n'ni tnu na Ndiose, a sca ntsu'hui lyoo na, una cha' ndlo'o naan can' lcuan nu nscua loo can', xacan' nguinu scua tla cha' nu nchcui' can'. ");
INSERT INTO cya_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tiji 'a nan um lo' nchcun cha' tiyaa 'in um! ¿Ti ña'an ta cha' re nu ndon loo la, lcuan can' uta na se'en ndyi'ya na lcuan tloo Ndiose? ");
INSERT INTO cya_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Si'yana nu ndlo ca 'in, lo' ndlo'o naan loo se'en n'ni tnu na Ndiose, si'i tsaloo ti se'en can' nsu'hua loo can', cui' ca nu lo'o lcuan nu nscua can' ndlo ca 'in lo'o na. ");
INSERT INTO cya_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nu ndlo ca 'in lo'o cha' 'in laa, si'i tsaloo ti 'in laa nsu'hua loo can', cui' ca nu lo'o Ndiose ndlo ca 'in. ");
INSERT INTO cya_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Lo' nu ndlo ca 'in lo'o ni' cuaan, si'i tsaloo ti ni' cuaan nsu'hua loo can', cui' ca nu lo'o se'en nducua Ndiose, tsatlyu lo'o ñi ndlo ca can' 'in. ");
INSERT INTO cya_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡'Tnan ca 'un ne' escriba lo'o ne' fariseo, a ñi ndi'in cha' 'in um! Si'yana scasca quixin' nu ndyu'hui loo scua ndaa um tsachin' can' 'in Ndiose, lo' nxnu ca'an chon' um cha' nu ndon loo lati nchcui' lee: Nu chcui ncha'an na cha' nu ñi, lo' ña'an 'tnan ti' na 'in nten, lo' tsa qui'an ti' na 'in Ndiose. Nde cha' nu ndon loo nu ntsu'hui cha' cu'ni um, una si'i can' cha' cula' ti' um cu'ni um nchgaa la ña'an cha' can'. ");
INSERT INTO cya_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡'Un nu nchcun cha' tiyaa 'in lo'o cha' nu ndlo'o um! Nducua hui um na nu ndyi'yo um si'yana a ycuin' um cuiya', una ndiyato'o ycuin' um sca camello. ");
INSERT INTO cya_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡'Tnan ca 'un ne' escriba lo'o ne' fariseo, a ñi ndi'in cha' 'in um! Si'yana njyi'an um nde chon' vaso lo'o nde chon' qui'nan se'en nchcu um, una nde ni' cusya 'in um mtsa'an yu'hui cha' ngunan', a cunta lo'o cha' cunan. ");
INSERT INTO cya_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡'Un ne' fariseo nu nchcun cha' tiyaa 'in! Cha' cua na suhui um culo nducua la nde ni' vaso lo'o qui'nan 'in um, cuaña'an lo'o chon' na quinu luhui. ");
INSERT INTO cya_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡'Tnan ca 'un ne' escriba lo'o ne' fariseo, a ñi ndi'in cha' 'in um! Si'yana su'hua ña'an nguiaa cha' 'in um lo'o sca tucuaa nu tsu'hue ña'an mten, una nde ni' na mtsa'an yu'hui tijyan ne' ngujui lo'o nchgaa loo na nu coo'. ");
INSERT INTO cya_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Cui' cuaña'an nguiaa cha' 'in um, n'ni um cha' si'yana ñi ndi'in cha' 'in um tloo ta'a nten um, una nde ni' cusya 'in um mtsa'an yu'hui cha' cuiñi lo'o cha' nducun'. ");
INSERT INTO cya_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡'Tnan ca 'un ne' escriba lo'o ne' fariseo, a ñi ndi'in cha' 'in um! Si'yana ntñan tucua um tucuaa se'en mtsi' yu nu mxiycui' Ndiose 'in cua' s'ni, lo' n'ni chu'hue um tucuaa se'en mtsi' nten tsu'hue, ");
INSERT INTO cya_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","lo' nchcui' um xacan': Cha' cua na mdi'in na ti' xa mdi'in nten cula 'in na, a ca ta'a lo'o na 'in nu yjui 'in yu nu mxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lo'o cha' re ndaa um suun si'yana lca um ticui' ta nten nu yjui 'in yu nu mxiycui' Ndiose 'in cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Can' cha' tsa quiñan la um cu'ni um nchgaa tñan ngunan' nu m'ni nten cula 'in um. ");
INSERT INTO cya_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡'Un lca um ña'an nchca ti' 'ni la, lo' lca um sñe' ne' cuiñi! ¿Ña'an ta tyi'o laa um loo quii' si'ya yuhue' nducua chon' um? ");
INSERT INTO cya_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Can' cha' nda'an tñan 'in yu nu nxiycui' Ndiose 'in lja um, lo'o yu nu tiyaa, yu nu ndlo'o 'in um. Una ntsu'hui can' cujui um 'in lo' hasta jyi'in ca'an um 'in loo cusi, lo' ntsu'hui nu jyi'in um 'in se'en n'ni tnu um 'in Ndiose, a cunta chcui ncha'an um 'in can' scasca quichen, ");
INSERT INTO cya_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","cui' si'yana caan yuhue' chon' um si'ya nchgaa tne nu nguilo 'in nten nu suun nu mdi'in loo chendyu re, ti' tne nu mslo ne' 'in Abel hasta lo'o nu 'in Zacaría, sñe' Berequía, yu nu yjui nten cula 'in um ni' lyaa. Lo' tlu'hue la se'en yjui ne' 'in yu, sca tso' can' nducua se'en ndiquin tucua ne' 'ni, lo' xca tso' can' nducua laa. ");
INSERT INTO cya_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nu cha' ñi cunen lo'o um, nchgaa cha' re caan na chon' ta nten nu ndi'in cua' ñii. ");
INSERT INTO cya_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Jerusalén, 'un nu ndi'in Jerusalén, ndujui um 'in nu nxiycui' Ndiose 'in, lo'o quee ti ndujui um 'in nu nda'an tñan Ndiose 'in um. Tsala ña'an tyun ya' ncua tin' xo' ti'in 'in um, tsaña'an nxo' ti'in cutu 'in sñe' 'in nde ni' jlyu'hue 'in, una a mslyaa um. ");
INSERT INTO cya_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ña'an jan ñi, —tiyaa xaa quinu tucua lja na'an re—. ");
INSERT INTO cya_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cunen lo'o um sca cha', a ntsu'hui 'a cha' ña'an tloo um 'ñan, cha' si'i la xa nu chcui' um: —Tlyu cha' tsu'hue ntsu'hui 'in ñi nu ljyaan lo'o cha' cuiya' 'in Ñi X'nan na—. ");
INSERT INTO cya_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Xa mdo'o Jesús ni' lyaa can', yu ta'a nda'an ñi mdiyaa yu cui' la se'en ndon ñi, lo' ngulo'o yu 'in ñi tsala ña'an tlyu nguiaa' laa can'. ");
INSERT INTO cya_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mxcuen ñi 'in yu: ¡Na'an um tsala ña'an nguiaa' na! Nu cha' ñi cunen lo'o um, ntsu'hui cha' cuten na re, ñi xca quee lo' a quinu scua 'a na chon' ta'a na. ");
INSERT INTO cya_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lja nducua ñi loo qui'ya Olivo can', sca cunta mdiyaa yu ta'a nda'an ñi cui' la se'en nducua ñi, lo' juin yu: Quitsa' um 'in hua cha' ñi xaa tsato'o cha' re, lo' ñi lyijyi cha' ca chcan' loo xa quiaan um uta xa tsatii chendyu re. ");
INSERT INTO cya_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mxcuen Jesús 'in yu: Xñi um cunta si'yana a tucui nu cuñilyi'o 'in um. ");
INSERT INTO cya_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Si'yana qui'an 'a nu caan, lo' cu'ni 'in si'yana ljyaan lo'o cha' cuiya' 'ñan, lo' chcui': Nan' lcan Cristo. Qui'an 'a nten cuñilyi'o can'. ");
INSERT INTO cya_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A cunta cunan um cha' si'yana cua' ngui'ni ne' cusuun se'en tijyo' lo'o se'en cui' ti, una a su'hua um cha' nduhue ti' tiquee um si'yana nchgaa cha' re ntsu'hui cha' ca na, una si'i can' cha' cua' tsatii chendyu re. ");
INSERT INTO cya_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ntsu'hui cha' xuun quichen tnu lo'o ta'a quichen tnu na, lo' sca chcui chendyu tyi'in suun ne'. A cunta scasca se'en ntsu'hui cha' qui'ya bju'ñan lo'o quicha, lo' ntsu'hui cha' quiñan lyee ya'. ");
INSERT INTO cya_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nchgaa cha' re lca nu ti'i nu tca tyisnan. ");
INSERT INTO cya_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Xacan' tyaa ne' 'in um se'en tyijyin um nu ti'i, lo' cujui ne' 'in um, lo' chcua tyi'iin tso' ntsu'hui cha' xcuan tloo ne' 'in um si'ya cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Qui'an 'a nten tyi'o tso' ne' sii' Ndiose, scasca ne' tnan' ta'a ne', a cunta xcuan tloo ta'a ne'. ");
INSERT INTO cya_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Qui'an 'a nu cuiñi chcui' si'yana Ndiose nxiycui' 'in, lo' tsacua qui'an nu cuñilyi'o can'. ");
INSERT INTO cya_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lo' si'yana lyee 'a cua' yton qui'ya, nguiaa ndiyatii cha' tsu'hue nu ntsu'hui tiquee ne' scasca ne'. ");
INSERT INTO cya_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Una nu tla ndon hasta ya' tsatii cha' nu nchca loo chendyu re, can' nu tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Una cha' tsu'hue 'in Ndiose caja nu chcui' 'in na sca chcui chendyu, ña'an ca si'yana ca cuiya' ti' ne' cha' re, xacan' tsatii cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Can' cha' xa ña'an um cua' nchca —cha' ngunan' se'en n'ni tnu ne' 'in Ndiose—, tsaña'an cha' nu mxiycui' Ndiose 'in Daniel (can' cha' qui'ya um cunta, 'un nu nchcui' quityi re). ");
INSERT INTO cya_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Xacan' nu ndi'in se'en lca Judea, xnan yu'hui can' nde loo qui'ya. ");
INSERT INTO cya_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nu nguilyu nde que na'an 'in, a bla 'a qui'ya can' lyoo na ndi'in ña'an 'in. ");
INSERT INTO cya_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Cuaña'an nu ngui'ni tñan ni' quixin', a bla 'a 'in can' ti' quia 'ya ste'. ");
INSERT INTO cya_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Una 'tnan ca ne' cuna'an nu cua' xcaña'an nxiton, lo'o nu cune' sñe'. ");
INSERT INTO cya_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Can' cha' jñan um 'in Ndiose si'yana a tsato'o cha' re tsaan nu tlya', uta tsaan nu nxitñan' na, ");
INSERT INTO cya_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","si'yana ntsu'hui cha' caan —scasca nu ti'i tnu nu a nchca siya' tsato'o ti' xa mtñan Ndiose chendyu, ñi a ntsu'hui 'a cha' ti' caan la na—. ");
INSERT INTO cya_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cha' Ndiose a si'yu co' ñi cha' re, a tucui nu tyi'o laa, una si'ya nten nu cua' mdo'o hui 'in ñi, can' cha' si'yu co' ñi cha' re. ");
INSERT INTO cya_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Cha' nde'en nu ljuin lo'o um: Ña'an jan ñi, nde ndon Cristo, uta cha' ljuin: La cua ndon ñi. A tsa qui'an ti' um 'in can'. ");
INSERT INTO cya_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Si'yana ntsu'hui cha' caan scasca nu cuiñi lo' ljuin si'yana lca Cristo, a cunta chcui' si'yana Ndiose nxiycui' 'in, lo' cu'ni can' scasca cha' nu tnu se'en nu cuhue ti' nten 'in, lo' hasta lo'o nu cua' ngulohui Ndiose 'in cuñilyi'o, cha' cua na tca 'in. ");
INSERT INTO cya_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cua' msu'hua tiyaan 'in um lo'o cha' re. ");
INSERT INTO cya_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Can' cha', cha' ntsu'hui nu ljuin lo'o um: Ña'an jan ñi, la se'en ngutyi cua nguilyu ñi, a tsaa um. Uta ljuin: Nde ña'an cua nducua. A tsa qui'an ti' um. ");
INSERT INTO cya_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tsaña'an nchca ti' xa ndyuhui ni' cuaan, lo' nxtyi xaa scasca tso', cuaña'an ca chcan' quiaan Yu Qui'yu nu Mdo'o nde ni' Cuaan tiyaa xaa. ");
INSERT INTO cya_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Se'en xtyi nu ngujui, can' ntsu'hui cha' quio' ti'in laxo. ");
INSERT INTO cya_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Cui' ña'an lcaa xa cua' mdijin nchgaa nu ti'i can', —ntsu'hui cha' qui'ya tla loo cucha, ñi coo' lo' a tyu'hui 'a xaa 'in na, cuii nu nducua ni' cuaan ntsu'hui cha' quilo na, lo' ña'aan ni' cuaan ntsu'hui cha' quiñan tucui na—. ");
INSERT INTO cya_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Xacan' ca chcan' loo Yu Qui'yu nu Mdo'o nde ni' Cuaan. —Nchgaa nten chendyu qui'ya tu'hua tiquee ne'—, lo' ña'an tloo ne' 'in —Yu Qui'yu nu Mdo'o nde ni' Cuaan quiaan ñi ni' ndlaa— lo'o sca cha' cuiya' nu tlyu, lo'o sca xaa tsu'hue ña'an. ");
INSERT INTO cya_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Xacan' tyi'o ne sca cuhuii, cui' ña'an lcaa ca'an tñan ñi angujle 'in ñi, nu tsa xo' 'in nchgaa nu cua' mdo'o hui 'in ñi ta'a jacua nscan chendyu. ");
INSERT INTO cya_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Xñi um cunta ña'an nguiaa cha' 'in sca yca higo: Xa ña'an um cua' tyisnan chcua lca' cojo' na, cua' jlyo ti' um si'yana cua' nchcui cuii' cha' quila quioo. ");
INSERT INTO cya_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Cui' cuaña'an xa ña'an um cua' nchca nchgaa cha' re, ca jlyo ti' um si'yana cua' nchcui cuii' cha' quiaan ñi. ");
INSERT INTO cya_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nu cha' ñi cunen lo'o um, ti' ndi'in ta nten re xa tsato'o nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ni' cuaan lo'o chendyu re, a la 'a quine cueen na tiyaa xaa, una cha' nu nchcuin' lo'o um, tsala xaa quinu scua na. ");
INSERT INTO cya_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","A tucui nu jlyo ti' ñi tsaan lo' ñi braa tsato'o cha' re, ñi angujle nu ndi'in ni' cuaan, cui' ca nu scati Stin jlyo ti' ñi cha' re. ");
INSERT INTO cya_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tsaña'an yato'o xa mdi'in yu Noé, cuaña'an tsato'o xa quiaan Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Xa ti' lyijyi caan quio tnu can', nchcu ne', ndyi'yo ne', ndyija cuilyi'o ne', lo' ndaa ne' cha' cuilyi'o 'in ta'a nten ne', tsaya' mdiyaa tsaan yten yu Noé ni' yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ngu'ya ne' cunta cha' can' la cua' mdyisnan quio tnu lo' ngujlyo na 'in ne' nchgaa ne', cuaña'an tsato'o xa quiaan Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tucua yu ngui'ni tñan ni' quixin', sca can' quia lo'o ñi 'in, lo' xca can' quinu ton. ");
INSERT INTO cya_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tucua ne' cuna'an ndiyo, sca can' quia lo'o ñi 'in, lo' xca can' quinu ton. ");
INSERT INTO cya_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Can' cha' tyi'in tiyaa um, si'yana a jlyo ti' um ñi braa quiaan Ñi nu lca X'nan um. ");
INSERT INTO cya_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Una ca jlyo ti' um cha' re: Cha' cua na ca jlyo ti' x'nan na'an ñi braa caan yu cunan, cua' lca ndon tiyaa can', lo' a cui'ya yu na nu ndi'in 'in. ");
INSERT INTO cya_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Cuaña'an 'un, tyi'in tiyaa um, si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan ntsu'hui cha' quiaan ñi lja nu a sca cha' ntsu'hui tiquee um. ");
INSERT INTO cya_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","¿Ti nu lca nguso nu ñi ndi'in cha' 'in lo' tiyaa? Ta si'i cui' yu nguso nu mxnu x'nan cunta 'in lo'o nchgaa loo tñan, si'yana tyi'in tiyaa yu lo' taa yu na nu cunajo'o 'in nu ndi'in na'an can'. ");
INSERT INTO cya_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tsu'hue ca xu'hue yu nguso can', cha' cuaña'an ngui'ni yu xa quila x'nan yu. ");
INSERT INTO cya_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nu cha' ñi cunen lo'o um, x'nan nguso can' xnu cunta 'in yu lo'o nchgaa la ña'an tñan can'. ");
INSERT INTO cya_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Una yu nguso can', cha' lca yu sca nu nducun' lo' tyisnan tyi'an cha' tiquee yu, lo' ljuin yu: Ñi x'nan a quila ñi cui' xaa, ");
INSERT INTO cya_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","lo' tyisnan jyi'in yu 'in nchgaa la ña'an yu nguso can', lo' tyi'an yu lo'o yu cu'hui, ");
INSERT INTO cya_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","lo' cha' quila x'nan yu sca tsaan nu a nta yu 'in, lja nu a sca cha' ntsu'hui ti' yu, ");
INSERT INTO cya_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tsaloo ti xitijin can' 'in yu nu ti'i, lo' su'hua 'in yu sca se'en ti lo'o nu cuiñi, can' xtyi ynan yu loo nu lyee tyijyin yu nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Tsaña'an ndlo Ndiose tñan, nguiaa cha' 'in na ña'an ndi'in cha' 'in tsa tii ngüi' tsa suhue ti, nu ta'a nguiaa 'in xen nu chcuan cunta 'in cuilyi'o, lo' yaa' ne' nducua quii' nu ndu'hui xaa 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tsa ca'yu ne' can' tiyaa ne', lo' cha ca'yu ne' tinto ne'. ");
INSERT INTO cya_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nu tinto can' msñi se'en ndiquin quii' can' 'in, una a lyi'ya xca ta ceite nu ti' tiquin la. ");
INSERT INTO cya_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Una ne' nu tiyaa can', msñi ne' se'en ndiquin quii' can' 'in ne' tsatlyu lo'o xca te'en ceite. ");
INSERT INTO cya_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yu nu ndyijyi cuilyi'o can' a mdiyaan yu cui' xaa, lo' mdyisnan yaan sla ngüi' can', lo' yja' ngüi'. ");
INSERT INTO cya_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Xa mdiyaa tlu'hue tla mdyisnan ycui' cueen nten can' lo' nchcui' ne': Nde cua' ljyaan yu nu ndyija cuilyi'o can', yaa um lo' tsa tucua um 'in. ");
INSERT INTO cya_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Xacan' mdyi'o sla ngüi', lo' mdyisnan m'ni chu'hue ngüi' se'en ndiquin quii' can' 'in ngüi'. ");
INSERT INTO cya_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nu tinto can' juin 'in nu tiyaa can': Tyaa um tsachin' ceite 'in hua si'yana a xlyaa na re xñi quii' 'in na. ");
INSERT INTO cya_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Una ngüi' nu tiyaa can' mxcuen: Tsu'hue lati tsa si'i um ceite nu cunajo'o 'in um, si'yana a sca na tsa lyijyi na 'in na. ");
INSERT INTO cya_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lja mdo'o ne' nguia si'i ne' ceite can', mdiyaan yu nu ndyija cuilyi'o can', lo' ngüi' nu cua' ndon tiyaa can' tsatlyu yten ña'an lo'o yu nu ndyija cuilyi'o can', xacan' mchcun tuna'an can'. ");
INSERT INTO cya_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chon' nde'en can' nguila cha ca'yu ngüi' can', lo' nchcui' ngüi': ¡Ñi X'nan hua, Ñi X'nan hua, xla um tuna'an re lo' sten hua! ");
INSERT INTO cya_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Una mxcuen ñi 'in ne': Nu cha' ñi cunen lo'o um, a ndyu'hui lyoon 'in um. ");
INSERT INTO cya_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Can' cha' tyi'in tiyaa um, si'yana a jlyo ti' um ñi tsaan lo' ñi braa caan Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tsaña'an ndlo Ndiose tñan, nguiaa cha' 'in na ña'an ndi'in cha' 'in sca yu cua' tsaa sca se'en tijyo', lo' msi'ya yu nguso 'in yu si'yana xnu yu cunta tñan can' 'in. ");
INSERT INTO cya_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mdyaa yu cunta 'in sca yu nguso can' ca'yu millon tñi, lo' xca can' mchcuan cunta tucua millon, xca can' mchcuan cunta sca millon, cunda scaa yu cua' ña'aan cunta ti' yu lo'o tñi. Xacan' mdo'o x'nan tñan can', nguiaa sca se'en tijyo'. ");
INSERT INTO cya_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yu nu mchcuan ca'yu millon can', m'ni yu jyinsya lo' m'ni yu canan cha ca'yu millon tñi. ");
INSERT INTO cya_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ticui' cuaña'an m'ni yu nu mchcuan cunta tucua millon can', m'ni yu canan chcua millon lo'o na. ");
INSERT INTO cya_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Una yu nu mchcuan sca millon can', yato'o mjñi yu sca tuyuu lo' msu'hua cutsi' yu tñi nu mdaa x'nan yu. ");
INSERT INTO cya_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","La cua' s'ni can' nguila x'nan nguso can', mdyisnan mjñan cunta 'in yu nguso can'. ");
INSERT INTO cya_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mdiyaa yu nu msñi ca'yu millon can', lo'o cha ca'yu millon lyi'ya yu, lo' juin yu: Ñi x'nan hua, nde tyaan ca'yu millon nu mxnu um cunta 'ñan, a cunta nde cha ca'yu millon nu m'nin canan lo'o na. ");
INSERT INTO cya_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Xacan' juin x'nan yu: Tsu'hue 'a ña'an nu m'ni, nu'huin lca sca nguso nu tsu'hue lo' ñi ndi'in cha' 'in. Lo'o tsachin' cunta nu nguinu yaa' mdo'o ñi cha' 'in, cua' ñii qui'an la cunta tyaan 'in, lo' tsatlyu ca tsu'hue chu'hui tiquee lo'o ñi nu lca x'nan. ");
INSERT INTO cya_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Xacan' mdiyaa yu nu msñi tucua millon can', lo' juin yu: Ñi x'nan hua, nde tyaan tucua millon nu mxnu um cunta 'ñan, a cunta nde chcua millon nu m'nin canan lo'o na. ");
INSERT INTO cya_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Juin x'nan yu lo'o yu: Tsu'hue 'a ña'an nu m'ni, nu'huin lca sca nguso nu tsu'hue lo' ñi ndi'in cha' 'in. Lo'o tsachin' cunta nu nguinu yaa' mdo'o ñi cha' 'in, cua' ñii qui'an la cunta tyaan 'in, lo' tsatlyu ca tsu'hue chu'hui tiquee lo'o ñi nu lca x'nan. ");
INSERT INTO cya_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Xacan' mdiyaa yu nu msñi sca millon can', lo' juin yu: Ñi x'nan hua, jlyo tin' si'yana 'un lca um sca nu tla cha' 'in, lo' nxo' um na nu a ntya um, lo' nxo' um tñan 'in xca tucui, ");
INSERT INTO cya_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","lo' si'yana ytsen culyijyin tñi re 'in um, can' cha' msu'huan cutsin' 'in na tuyuu, una nde tyaan na 'in um. ");
INSERT INTO cya_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mxcuen x'nan yu 'in yu: Nu'huin lca sca nguso nu nducun' lo' ndaja, cua' jlyo ti' si'yana nxon' na nu a ntyan, lo' nxon' tñan 'in xca tucui. ");
INSERT INTO cya_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Cha' cua na mdaa um tñi 'ñan mjñi' xca tucui, lo' xa xitucuin chcuan 'in na lo'o sñe' na. ");
INSERT INTO cya_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chcuan um tñi cua 'in yu, lo' tyaa um 'in na 'in yu nu cua' ndi'in tii millon 'in. ");
INSERT INTO cya_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Si'yana nu cua' jui cha' tsu'hue 'in, nde caja nu taa la na 'in lo' ca qui'an la na 'in, una nu a jui cha' tsu'hue 'in, hasta lo'o tsachin' na nu cua' ndi'in 'in, caja nu chcuan lyijyi 'in na. ");
INSERT INTO cya_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yu nguso nu a ncua tñan re, lyoo um 'in yu nde lyiya' se'en tla yta cua, can' xtyi ynan yu loo nu lyee tyijyin yu nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Xa nu tyi'o Yu Qui'yu nu Mdo'o nde ni' Cuaan loo xaa 'in ñi, lo' tsatlyu caan ñi lo'o nchgaa angujle 'in ñi, xacan' sten tucua ñi se'en ntsu'hui cha' culo ñi tñan loo xaa 'in ñi, ");
INSERT INTO cya_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ña'aan sca chcui chendyu quio' ti'in tloo ñi, lo' culohui ñi 'in cunda scaa ta, tsaña'an n'ni yu nu na'an seen slya' xa ndlohui yu 'in 'in lja chiu. ");
INSERT INTO cya_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Xo' ti'in ñi slya' can' tso' cueen 'in ñi, lo' chiu can' quio' ti'in tso' ca 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Xacan' chcui' ñi nu lca Ree can' lo'o nu ndi'in tso' cueen 'in ñi: Quiaan um, 'un nu cua' nda'an lo'o cha' tsu'hue nu mdaa Stin, chcuan um cunta se'en ndlo ñi tñan, cui' cha' nu cua' mdi'in tyaa ñi ti' xa mtñan ñi chendyu re, lo' cua' ñi qui'ni ca'an na 'in um. ");
INSERT INTO cya_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Si'yana xa ngute' tin' mdaa um na ycun, xa ngutyi tin' mdaa um tyi'a yi'on, xa ncuan sca yu nda'an ti mdaa um se'en nguinun. ");
INSERT INTO cya_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","A cunta ya lyijyi sten' mdaa um te' ycon', xa ncua ti'in 'un m'ni cunta um 'ñan, yu'huin na'an chcuan lo' ya na'an um se'en ntsu'huin. ");
INSERT INTO cya_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Xacan' xcuen jun nu mdo'o hui 'in ñi: ¿Ñi X'nan hua, ñi xaa ngute' ti' um lo' mdaa hua na ycu um, ñi xaa ngutyi ti' um lo' mdaa hua tyi'a yi'o um? ");
INSERT INTO cya_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ñi xaa ncuan xu'hue hua 'in um xa ncua um sca nu nda'an ti, uta ya lyijyi ste' um lo' mdaa hua te' yco' um? ");
INSERT INTO cya_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ñi xaa ncua ti'i um, uta yu'hui um na'an chcuan lo' m'ni cunta hua 'in um? ");
INSERT INTO cya_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Lo' xcuen ñi nu lca Ree can': Nu cha' ñi cunen lo'o um, nchgaa ya' m'ni um cha' tsu'hue lo'o ta'an nu ndon re, siya' nu chin' la cha' 'in, m'nin cunta si'yana lo'on nan' m'ni um 'in na. ");
INSERT INTO cya_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Xacan' chcui' ñi lo'o nu ndi'in tso' ca 'in ñi: Tyi'o tso' um siin', 'un nu nducua yuhue' chon' lo' tsaa um loo quii' tsala xaa, se'en nu cua' ncua tsu'hue tsaa laxa'an tsatlyu lo'o angujle 'in. ");
INSERT INTO cya_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Si'yana ngute' tin' lo' a mdaa um na cun, ngutyi tin' lo' a mdaa um tyi'a co'on. ");
INSERT INTO cya_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Xa ncuan sca nu nda'an ti, a mdaa um se'en quinun, ya lyijyi sten' lo' a mdaa um te' con', ncua ti'in, a cunta yu'huin na'an chcuan lo' a m'ni cunta um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ticui' cuaña'an xcuen ne' can' 'in ñi: Ñi X'nan hua, ¿ñi xaa na'an hua si'yana ngute' ti' um, uta ngutyi ti' um, lo' ñi xaa ncua um sca nu nda'an ti, uta ya lyijyi ste' um, lo' ta ncua ti'i um uta yaa um na'an chcuan, lo' a m'ni cunta hua 'in um? ");
INSERT INTO cya_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Xacan' xcuen ñi 'in ne': Nu cha' ñi cunen lo'o um, loo nu a m'ni um cha' tsu'hue re lo'o ta'an nu ndon re, siya' chin' la cha' 'in, m'nin cunta si'yana 'ñan mscuan tloo um. ");
INSERT INTO cya_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Can' nu tsaa loo quii' tsala xaa, una jun nu cua' ncuan xu'hue 'ñan, qui'ni ca'an 'in can' chendyu nu a tsatii 'a. ");
INSERT INTO cya_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Xa mdyi ycui' Jesús nchgaa cha' re, juin ñi lo'o yu ta'a nda'an ñi: ");
INSERT INTO cya_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Cua' jlyo ti' um si'yana ni' chcua ti tsaan cua' ca ta'a pascua, lo' Yu Qui'yu nu Mdo'o nde ni' Cuaan tyaa ne' 'in ñi, lo' jyi'in ca'an ne' 'in ñi loo cusi. ");
INSERT INTO cya_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lja xacan' yu nu ndlo tñan ni' lyaa lo'o ne' escriba, tsatlyu lo'o qui'yu cula nguio' ti'in ne' tuna'an lyiya' se'en ndi'in yu Caifás, yu nu ndlo ca tñan ni' lyaa 'in ne', ");
INSERT INTO cya_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","m'ni cuiya' ne' cha' ña'an ntsu'hui cha' quinu Jesús lo'o cha' cuiñi 'in ne', lo' cujui ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lo' ndeña'an nchcui' ne': Una si'i lja ta'a re, si'yana a nchca ti' na quilo ti'in nten quichen re. ");
INSERT INTO cya_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús ndi'in ñi quichen Betania, na'an 'in Simón nu ncua ti'i lo'o quitso' la, ");
INSERT INTO cya_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","lja xacan' mdiyaa sca ne' cuna'an se'en nducua ñi tu'hua msa, lyi'ya ne' sca te'en tyi'a xityi'i nu qui'an nchca, lo' mslo tucua ne' 'in na que ñi. ");
INSERT INTO cya_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Xa na'an yu ta'a nda'an ñi cha' can', msin' ti' yu lo' nchcui' yu: ¿Ñi cha' mslo lu'un ne' tyi'a xityi'i re? ");
INSERT INTO cya_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tsu'hue lati cha' cua na ncua quiya' na, caja tñi lo'o na lo' quitsa na 'in nu ti'i ña'an chendyu 'in. ");
INSERT INTO cya_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngu'ya Jesús cunta cha' nchcui' yu, lo' juin ñi: ¿Ñi cha' nducui ndijin um lo'o cha' nu ngui'ni ne' cuna'an re? Sca nu tsu'hue ngui'ni ne' lo'on. ");
INSERT INTO cya_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nu ti'i ña'an chendyu 'in, nchgaa xaa ndi'in can' lo'o um, una nan' si'i tsala xaa ña'an tloo um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tsaña'an mslo tucua ne' tyi'a xityi'i 'ñan, cua' mxitucua loo ne' cha' 'in ne' xa nu quitsin'. ");
INSERT INTO cya_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nu cha' ñi cunen lo'o um, ña'an tucui ti nu tyi'an ycui' cha' tsu'hue re 'ñan sca chcui chendyu, lo'o cha' 'in ne' cuna'an re chcui' can', lo' ca jlyo ti' nten tsaña'an nu m'ni ne' re. ");
INSERT INTO cya_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Xacan' sca yu nu nchca tichcua can', yu nu naan Juda Iscariote, yaa yu se'en ndi'in yu nu ndlo ca tñan ni' lyaa, ");
INSERT INTO cya_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","lo' juin yu 'in ne': ¿Tsala taa um 'ñan, lo' nan' tyaan 'in Jesús tuyaa' um? —Xacan' ncua ne' cla tyii tñi plata mdaa ne' 'in yu—. ");
INSERT INTO cya_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ti' xacan' ngunan yu ña'an nu tyaa yu 'in ñi tuyaa' ne' can'. ");
INSERT INTO cya_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Culoo tsaan nu nchca ta'a, xa nchcu ne' jaslya nu a yu'hui suun 'in, yu ta'a nda'an ñi mdiyaa yu cui' la tloo ñi, lo' juin yu: ¿La ta nchca ti' um tsa y'ni chu'hue hua na nu cu siin na ta'a pascua re? ");
INSERT INTO cya_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Juin ñi 'in yu: Yaa um loo quichen cua, lo' ndeña'an chcui' um lo'o sca yu nu cua' ndon tiyaa can': Ñi nu lca Bstro 'in na juin ñi si'yana cua' nchcui cuii' cha' 'in ñi. Ña'an 'in um ntsu'hui cha' cu siin ñi lo'o yu ta'a nda'an ñi ta'a pascua re. ");
INSERT INTO cya_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yu ta'a nda'an ñi mducua yu tñan ña'an nu juin Jesús, lo' m'ni chu'hue yu na nu cu siin jun ta'a pascua can'. ");
INSERT INTO cya_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Xa ngu'ya tla can' yten tucua ñi lo'o ta'a tichcua yu ta'a nda'an ñi, ");
INSERT INTO cya_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","lo' lja nchcu siin jun mdyisnan ycui' ñi: Nu cha' ñi cunen lo'o um, sca um nu ta'a nducua na re ntsu'hui cha' tyaa um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lyee ngulu'un ti' yu, lo' cunda scaa yu juin yu 'in ñi: Ñi X'nan hua, ¿ta xtyi ti' nan' lcan? ");
INSERT INTO cya_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mxcuen ñi 'in yu: Cui' yu nu cucha' jaslya 'in sca ni' qui'nan ti lo'on, can' nu ntsu'hui cha' tyaa 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nu cha' ñi si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan, ntsu'hui cha' tyijyin ñi ña'an cha' nu cua' ngua'an scua loo quityi 'in Ndiose. ¡Una 'tnan ca yu nu ntsu'hui cha' tyaa 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan! Ti' tsu'hue lati cha' cua na a mdiyaan yu chendyu. ");
INSERT INTO cya_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Xacan' juin yu Juda, cui' yu nu ntsu'hui cha' tyaa 'in ñi: 'Un ñi nu lca Bstro, ¿ta xtyi ti' nan'? Mxcuen ñi 'in yu: Cui' ña'an nu nchcui' cua. ");
INSERT INTO cya_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lja nchcu siin jun can' msñi Jesús sca jaslya, mdyaa ñi xu'hue 'in Ndiose, msu'hue ñi 'in na lo' mdaa ñi 'in na 'in yu ta'a nda'an ñi, lo' juin ñi: Xñi um lo' ca xu'hue um 'in na, nde nu lca cunan' nan'. ");
INSERT INTO cya_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Xacan' msñi ñi se'en ntsu'hui vino can'. Xa cua' mdyaa ñi xu'hue 'in Ndiose mdaa ñi 'in na 'in yu, lo' juin ñi: Yi'o um 'in na nchgaa um. ");
INSERT INTO cya_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nde nu lca tnen nan', lo' si'ya na chca tsu'hue cha' 'in nten lo'o Ndiose, lo' ntsu'hui cha' quilo na, si'yana chca qui'ya 'in qui'an nten. ");
INSERT INTO cya_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cunen lo'o um sca cha', ñi xiya' lo' a co'on 'an vino lja nu ti' ndi'in lo'o um, cha' si'i la xa co'o na 'in na se'en ndlo Stin tñan. ");
INSERT INTO cya_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Xa cua' mdyi yla jun sca jyiin 'in Ndiose, mdo'o jun nguiaa jun nde loo qui'ya Olivo. ");
INSERT INTO cya_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Xacan' juin Jesús 'in yu: Nchgaa um ntsu'hui cha' xnu ton um 'ñan xcan tin tla re ñii, si'yana cuaña'an nguinu scua sca cha' loo quityi 'in Ndiose: —Taan cha' cuiya' cujui ne' 'in ñi nu na'an seen slya', lo' slya' can' cua' la tucueen cunaan 'in—. ");
INSERT INTO cya_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Una xa cua' mdyiqui'on, culo nducua la tsa'an se'en lca Galilea que 'in um. ");
INSERT INTO cya_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yu Tyo can' mxcuen yu 'in ñi: Cha' nchgaa yu re xnu ton yu 'in um, una nan' a cu'nin cuaña'an. ");
INSERT INTO cya_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Juin Jesús 'in yu: Nan' cunen lo'o, cui' tla re ñii lja nu ti' lyijyi xi'ya latyee, tsato'o snan ya' chcui' si'yana a ndyu'hui lyoo 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Una juin yu Tyo 'in ñi: A 'ni cha' siya' cajan lo'o um, una a xcuan tloon 'in um. Scaña'an ti ycui' nchgaa la ña'an yu ta'a nda'an ñi. ");
INSERT INTO cya_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Xacan' mdiyaa Jesús lo'o yu ta'a nda'an ñi sca se'en naan Getsemaní, lo' juin ñi 'in yu: Nde ti chcua um lja chcui' lyi'on 'in Ndiose la cua. ");
INSERT INTO cya_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mdo'o lo'o ñi 'in yu Tyo lo'o chcuaa sñe' Zebedeo, lo' mdyisnan ngu'ya sca tu'hua tiquee ñi nu lyee ti'i nga'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Xacan' juin Jesús 'in yu: Lu'un 'a ti' cusya 'ñan, lyi'ya ca ya' nu cua' cajan. Nde ti quinu um lo' a taa um ya' qui'ya sla um. ");
INSERT INTO cya_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chin' ti se'en ti' mda'an ñi, lo' mdyi'ya xtyin' ñi hasta ngu'ya ti'in tloo ñi la lyuu, lo' mjñan ñi 'in Ndiose lo' juin ñi: 'Un ñi nu lca Stin, cha' caja ña'an nu a tijin nu ti'i re, una si'i ña'an nu nchca tin', cui' ca nu ña'an nu 'un nchca ti' um. ");
INSERT INTO cya_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Xacan' mxitucui ñi se'en nguinu tucua yu can', nguija lyoo ñi 'in yu lja' yu, lo' juin ñi 'in yu Tyo: ¿Ta xtyi ti' ñi sca braa ti lo' a ncua chcua um ndii ti' um? ");
INSERT INTO cya_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chcua tiyaa um lo' chcui' lyi'o um 'in Ndiose, si'yana a sten cha' ngunan' tiquee um. Lca tiquee um cu'ni um sca tñan tsu'hue, una nu cu'ni um 'in na na'an ti' um. ");
INSERT INTO cya_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xiya' yaa ñi lo' ycui' lyi'o ñi 'in Ndiose nu cua' nchca tucua ya', lo' nchcui' ñi: 'Un ñi nu lca Stin, cha' a ndyijyi ña'an nu a tijin nu ti'i re, una cu'ni tu um ña'an nu nchca ti' um. ");
INSERT INTO cya_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Xacan' mxitucui ñi xiya', ticui' ti ña'an lja' yu si'yana lyee ti'in ljyaan sla yu. ");
INSERT INTO cya_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mxnu tucua ñi 'in yu, lo' nu cua' nchca snan ya' ycui' lyi'o ñi 'in Ndiose ticui' ti loo cha' can'. ");
INSERT INTO cya_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Xiya' mxitucui ñi se'en nducua yu ta'a nda'an ñi, lo' juin ñi 'in yu: Caja' lya um, xitñan' um, si'yana cua' mdiyaa braa, Yu Qui'yu nu Mdo'o nde ni' Cuaan ntsu'hui cha' quinu ñi tuyaa' yu nducun'. ");
INSERT INTO cya_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tyiton um lo' quiaa na. Ña'an jan ñi, nde cua' ljyaan yu nu ntsu'hui cha' tyaa 'ñan. ");
INSERT INTO cya_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lja nchcui' ñi cha' can' mdiyaa yu Juda, cui' sca yu nu nchca tichcua can', lo' qui'an 'a nten mdiya lo'o yu, ntsu'hui nu lyi'ya spada, ntsu'hui nu nducua yca yaa'. Mdiyaa ne' si'ya cha' cuiya' 'in yu nu ndlo ca tñan ni' lyaa tsatlyu lo'o qui'yu cula. ");
INSERT INTO cya_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yu nu ntsu'hui cha' tyaa 'in Jesús, m'ni cuiya' yu cha' lo'o ne' ña'an ntsu'hui cha' tyaa yu 'in ñi, lo' ndeña'an juin yu: Yu nu chcui' chan' la sii' sca', can' nu ca lca yu. Cui' xaa xñi um 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Cui' ña'an lcaa mdiyaa yu se'en ndon Jesús, lo' ycui' cha' yu la sii' sca ñi lo' juin yu: 'Un ñi nu lca Bstro. ");
INSERT INTO cya_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Lo' juin Jesús 'in yu: Migo, ¿ñi tñan ljyaan? Cui' xaa mdiyaa ne' lo' msñi ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Una sca yu nu ta'a nda'an Jesús ngulo yu spada 'in yu, lo' msi'yu yu nscan sca nguso 'in yu nu ndlo ca tñan ni' lyaa can'. ");
INSERT INTO cya_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Xacan' juin Jesús 'in yu: Xu'hua se'en spada 'in ni' tyi na, si'yana nchgaa nu nda'an lo'o spada, ticui' lo'o spada caja can'. ");
INSERT INTO cya_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ta ñan ti' si'yana a tca jñan 'in Stin, lo' ca'an tñan ñi tyun mii angujle nu ta yaa' 'ñan? ");
INSERT INTO cya_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Una, ¿ña'an ta quinu cha' nu nguinu scua loo quityi 'in Ndiose, si'yana 'ni cha' tsato'o nchgaa cha' re? ");
INSERT INTO cya_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Xacan' juin Jesús 'in ne': ¿Ñi cha' ljyan 'ya um 'ñan tsaña'an nchca ti' sca yu cunan, hasta lo'o spada lo'o yca nducua yaa' um? ¿Ta si'i nchgaa xaa nguilyun lo'o um, lo' ndlo'on 'in nten ni' lyaa, ñi cha' a msñi um 'ñan xacan'? ");
INSERT INTO cya_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Una nchgaa cha' re nchca na, si'yana tsato'o cha' nu cua' ngua'an scua yu nu mxiycui' Ndiose 'in cua' s'ni. Xacan' nchgaa yu ta'a nda'an ñi mxnu ton yu 'in ñi xca ti ñi, lo' msnan yu. ");
INSERT INTO cya_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ne' nu msñi 'in Jesús ya lo'o ne' 'in ñi tloo Caifás, yu nu ndlo ca tñan ni' lyaa, can' nguio' ti'in ne' escriba lo'o qui'yu cula. ");
INSERT INTO cya_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Una yu Tyo tijyo' ti mducui ncha'an yu 'in Jesús, tsaya' mdiyaa yu tuna'an lyiya' 'in yu nu ndlo ca tñan can'. Can' yten tucua yu sca se'en ti lo'o yu silyiya, si'yana ña'an yu ñi lyijyi ña'an tsato'o cha' can'. ");
INSERT INTO cya_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nchgaa yu nu ndlo tñan ni' lyaa tsatlyu lo'o qui'yu cula, lo'o nchgaa la ña'an ta'a nducua yu can', ngunan ne' ña'an nu su'hua ne' qui'ya 'in Jesús lo'o cha' cuiñi, ña'an ca si'yana cujui ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lo' a sca qui'ya nguija lyoo 'in ñi, siya' qui'an la nten msu'hua ne' qui'ya chon' ñi. Una chon' nde'en can' mdiyaan chcua yu nu msu'hua qui'ya 'in ñi lo'o cha' cuiñi, ");
INSERT INTO cya_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","lo' nchcui' yu: Yu re nchcui' yu si'yana xicuten yu laa 'in Ndiose nu nducua re, lo' tsani' snan ti tsaan xiton 'in na. ");
INSERT INTO cya_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Xacan' mdyiton yu nu ndlo ca tñan ni' lyaa can', lo' juin yu 'in ñi: ¿Ñi cha' ñi sca cha' lo' a nxcuen? ¿Ña'an ta ndyi'o cha' nu nsu'hua ne' re qui'ya 'in? ");
INSERT INTO cya_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Una Jesús ñi sca cha' lo' a mxcuen ñi. Xacan' juin yu nu ndlo ca tñan can': Ti' Ndiose ñi nu lo'o ca, quitsa' 'in hua cha' nu'huin lca ycui' ca Cristo, Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mxcuen Jesús 'in yu: 'Un nchcui' um cuaña'an. Una cunen lo'o um sca cha': Ti' cua' ñii ña'an um 'in —Yu Qui'yu nu Mdo'o nde ni' Cuaan nducua ñi tso' cueen 'in Ndiose—, cui' cuaña'an ña'an um 'in ñi —quiaan ñi ni' ndlaa—. ");
INSERT INTO cya_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Xacan' yu nu ndlo ca tñan can' hasta msta yu ste' yu, lo' juin yu: Yu re nchcui' ca'an yu 'in Ndiose. A 'ni 'a cha' cunan na xca nu taa suun lo'o na, si'yana cua' ngune 'in na ña'an ndaja yu re 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ña'an ljuin um? Nchgaa ne' tsatlyu mxcuen ne': ¡Tsaloo na caja ti yu! ");
INSERT INTO cya_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Scasca ne' mdyisnan msu'hua siye' ne' tloo ñi, ntsu'hui nu mycuan' 'in ñi, lo' ntsu'hui nu mjyi'in yaa' tloo ñi, ");
INSERT INTO cya_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","lo' nchcui' ne': Cristo, chcui' ña'an na cha' tucui ca mjyi'in 'in. ");
INSERT INTO cya_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yu Tyo ti' nducua yu tuna'an lyiya' can', lo' sca ne' cuna'an nguso mdiya ton cui' ti se'en nducua yu, lo' juin ne': Lo'o nu'huin ta'a nda'an Jesús nu mdo'o se'en lyi'ya loo Galilea. ");
INSERT INTO cya_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Una yu Tyo can' ytsen yu, lo' juin yu tloo nchgaa nten can': A jlyo tin' ñi cha' nchcui' um. ");
INSERT INTO cya_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Xa mdo'o ton yu tuna'an lyiya', can' mdo'o ycui' xca ne' cuna'an nguso, lo' nchcui' ne': Lo'o yu re nda'an yu lo'o Jesús Nazaret. ");
INSERT INTO cya_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Una yu Tyo can' hasta m'nin tyi'ya yu 'in Ndiose, lo' mxcuen yu 'in ne': A ndyu'hui lyoon 'in yu cua. ");
INSERT INTO cya_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Cui' xaa ti mdiyaa xca nu juin 'in yu Tyo: Yu re nu cha' ñi ca ta'a nda'an yu cua, si'yana ti' cha' nchcui' ti chcan' ña'an na. ");
INSERT INTO cya_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Xacan' mdyisnan msu'hua yu Tyo sca cha' chon' yu, lo' hasta m'ni tyi'ya yu 'in Ndiose, lo' juin yu: A ndyu'hui lyoon 'in yu cua. Cui' xaa can' msi'ya sca latyee. ");
INSERT INTO cya_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","La xacan' nguia yu'hui ti' yu Tyo cha' nu ycui' Jesús lo'o yu xa nu juin ñi: Ti' lyijyi xi'ya latyee, lo' snan ya' ljuin si'yana a ndyu'hui lyoo 'ñan. Xacan' mdo'o yu nde lyiya', ngu'ya tu'hua tiquee yu lo' ynan yu. ");
INSERT INTO cya_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ngu'ya ti xaa can', nchgaa yu nu ndlo ca tñan ni' lyaa tsatlyu lo'o qui'yu cula, m'ni cuiya' ne' cha' ña'an ntsu'hui cha' cujui ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nchcan' ñi mdyaa ne' cunta 'in ñi yaa' yu Pilato, nu lca gubierno. ");
INSERT INTO cya_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yu Juda nu mdyaa 'in ñi, xa na'an yu si'yana cua' ncua cuiya' cha' si'yana caja ñi, ti'i 'a nga'an 'in yu. Cui' xaa nguia lo'o yu cla tyii tñi plata can', lo' mdiyaa yu tloo yu nu ndlo ca tñan ni' lyaa lo'o qui'yu cula can', ");
INSERT INTO cya_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","lo' juin yu 'in ne': Nan' nducuin qui'ya si'yana mdyaan sca nu ñi ndi'in cha' 'in. Mxcuen ne' 'in yu: ¿Ñi cha' ndyuhue ti' huare' cha' can'? Quinu cunta 'in. ");
INSERT INTO cya_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Xacan' nguun yu tñi can' la ni' lyaa, mdo'o yu nguiaa yu lo' msu'hua yu sca can' yni yu. ");
INSERT INTO cya_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nchgaa yu nu ndlo ca tñan ni' lyaa can', msñi yu tñi can' lo' juin yu: A tsu'hue quinu tñi re ni' lyaa, si'yana cui' na yu'hui lyiya' na tne nten. ");
INSERT INTO cya_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Xa cua' m'ni cuiya' ne' cha', msi'i ne' sca yuu 'in sca nu ntñan quiton', si'yana can' quitsi' nten nu nda'an ti. ");
INSERT INTO cya_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Can' cha' hasta cua' ñii ndlo'o naan ne' se'en can': Yuu nu yu'hui lyiya' lo'o tne nten. ");
INSERT INTO cya_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Cuaña'an mducua cha' nu mxiycui' Ndiose 'in Jeremía xa juin yu: —Ta nten 'in ne' Israel, lo'o cla tyii tñi plata msu'hua lyiya' ne' tne ñi nu ta'a lati 'ñan, tsaña'an cuiya' nu cua' mdi'in tyaa ne'. ");
INSERT INTO cya_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Lo'o tñi can' msi'i ne' sca yuu 'in sca nu ntñan quiton', tsaña'an nu ngulo Ñi X'nan na tñan 'ñan—. ");
INSERT INTO cya_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lo' Jesús ndon ñi tloo yu Pilato, lo' mñicha' yu 'in ñi: ¿Ta cui' lca Ree 'in ne' judio? Jesús mxcuen ñi 'in yu: 'Un nchcui' um cuaña'an. ");
INSERT INTO cya_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lja xacan' msu'hua ne' qui'ya 'in ñi, yu nu ndlo ca tñan ni' lyaa can' lo'o qui'yu cula, una ñi sca cha' lo' a mxcuen ñi. ");
INSERT INTO cya_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Xacan' juin yu Pilato 'in ñi: ¿Ta na a ne 'in, tsala ña'an nsu'hua ne' qui'ya 'in? ");
INSERT INTO cya_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Siya' cuaña'an, a mxcuen Jesús ñi sca cha', can' cha' nde lyee lati yuhue ti' yu Pilato 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ndeña'an ntsu'hui sca cha' 'in gubierno nchgaa yjan xa nchca Pascua, ndlaa yu sca preso, ña'an nu ti nu jñan nten quichen cha' lyaa. ");
INSERT INTO cya_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cui' lja xacan' ntsu'hui sca yu preso nu nducun' lati naan Barrabás. ");
INSERT INTO cya_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yu Pilato mñicha' yu 'in nten nu nguio' ti'in tloo yu: ¿Ti ña'an chcuaa yu re nchca ti' um culaan, ta Barrabás, uta 'in Jesús nu nchcui' ne' lca Cristo? ");
INSERT INTO cya_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Juin yu cuaña'an si'yana jlyo ti' yu si'ya cha' njñan ti' mdyaa ne' 'in Jesús tuyaa' yu. ");
INSERT INTO cya_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lja nducua yu se'en nchca cuiya' cha', xa ngua'an tñan ne' cuna'an 'in yu sca suun 'in yu, lo' nchcui' ne': A nchca cha' ca ta'a lo'o um nten cua, si'yana a sca qui'ya nducui yu cua, a cunta tla re ñii lyee msu'huan cha' tiqueen si'ya cha' nu ycuin' slan. ");
INSERT INTO cya_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Una yu nu ndlo ca tñan ni' lyaa tsatlyu lo'o qui'yu cula, nde lyee la mxicu'ni ne' 'in nten qui'an can' si'yana jñan ne' cha' lyaa Barrabás, lo' cujui ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mxcuen yu Pilato 'in nten can': ¿Ti ña'an ta chcuaa yu re nchca ti' um culaan? Mxcuen ne': 'In Barrabás. ");
INSERT INTO cya_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mñicha' yu Pilato 'in ne': ¿Ña'an ta nchca ti' um cu'nin lo'o Jesús, nu nchcui' ne' lca Cristo? Tsatlyu ycui' ne': ¡Jyi'in ca'an um 'in yu loo cusi! ");
INSERT INTO cya_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yu Pilato can' juin yu: ¿Una ñi qui'ya ta m'ni yu? Nde lyee la ycui' cueen ne': ¡Jyi'in ca'an um 'in yu loo cusi! ");
INSERT INTO cya_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Xa na'an yu Pilato si'yana a ncua 'a chcui ndijin yu lo'o cha' can', cui' ca nu nde lyee la nguilo ti'in nten can', can' cha' mjñan yu tyi'a mjyi'an yu yaa' yu tloo nchgaa nten can', lo' juin yu: Si'i cunta 'ñan cha' caja yu nu ñi ndi'in cha' 'in re, quinu cunta 'in um. ");
INSERT INTO cya_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xacan' mxcuen ña'aan quichen ne': A 'ni cha' siya' chon' hua, uta chon' sñe' hua tsaa cha' re si'ya tne yu. ");
INSERT INTO cya_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Xacan' ngulaa yu Pilato 'in Barrabás, lo' ngulo yu tñan si'yana qui'ni Jesús. Mdyaa yu cunta 'in ñi tuyaa' sindatu si'yana jyi'in ca'an yu 'in ñi loo cusi. ");
INSERT INTO cya_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Xacan' ya lo'o yu sindatu 'in Jesús tuna'an tñan 'in yu, lo' mxo' ti'in ta'a yu se'en ndon ñi, ");
INSERT INTO cya_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ngulyoo yu ste' ñi lo' mxico' yu sca te' nga'á 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xacan' mdi'in tyaa yu sca sni' quiche' que ñi, lo' msu'hua yu sca yca yaa' ñi tso' cueen, mdyi'ya xtyin' yu tloo ñi lo' mstyi lyi'o yu 'in ñi lo' nchcui' yu: ¡Nchcui' cha' hua 'in um, 'un ñi nu lca Ree 'in ne' judio! ");
INSERT INTO cya_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Xacan' msu'hua siye' yu tloo ñi, ticui' yca nducua yaa' ñi msñi yu lo' mjyi'in yu que ñi. ");
INSERT INTO cya_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ngulyoo yu te' nga'á nu lco' ñi, lo' mxico' yu 'in ñi lo'o ste' ca ñi, lo' ya lo'o yu 'in ñi se'en cha'an ñi loo cusi. ");
INSERT INTO cya_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tucueen se'en nguia lo'o yu sindatu 'in Jesús, mchcua ta'a yu lo'o sca yu Cirene nu naan Simón, lo' mxicu'ni yu 'in si'yana cui'ya cusi can'. ");
INSERT INTO cya_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Xacan' mdiya lo'o yu sindatu 'in ñi sca se'en naan Gólgota, cha' re nchca ti' chcui', que jyi'o. ");
INSERT INTO cya_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mdaa yu vino co'o Jesús nu mxitiya' lo'o sca na nu lyee tlyaa', una xa cua' yi'o ca'an ñi 'in na, a mslyaa 'a ñi co'o ñi 'in na. ");
INSERT INTO cya_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Xa cua' mjyi'in ca'an yu sindatu can' 'in ñi loo cusi, xacan' ngulo yu xu'hue yu lo'o ste' ñi, cha' ña'an qui'ni ca'an na 'in yu cunda scaa yu, si'yana tsa tucua cha' nu mxiycui' Ndiose 'in nguso 'in ñi cua' s'ni, xa juin yu: —Mtsa yu sten', a cunta ngulo yu xu'hue yu lo'o na—. ");
INSERT INTO cya_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Can' nducua yu lo' ntsu'hui yu cuan 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Que cusi can' ngua'an yu sca cha' lo'o qui'ya nu msu'hua ne' 'in ñi, lo' nchcui' na: Nde Jesús nu lca Ree 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","A cunta lo'o tucua yu cunan mjyi'in ca'an yu sindatu 'in loo cusi, sca yu tso' cueen 'in ñi, lo' xca yu tso' ca. ");
INSERT INTO cya_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nten nu ndijin cui' ti can' nchcui' ca'an ne' 'in ñi, lo' hasta nxiquiñan ne' que ne', ");
INSERT INTO cya_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","lo' nchcui' ne': ¿Ta si'i nu'huin juin si'yana xicuten laa nducua re, lo' tsani' snan ti tsaan xiton 'in na xiya'? ¡Lyo laa 'in ticuii'! Cha' cui' lca Sñe' Ndiose, qui'ya loo cusi cua. ");
INSERT INTO cya_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yu nu ndlo ca tñan ni' lyaa tsatlyu lo'o ne' escriba, ne' fariseo lo'o qui'yu cula, ticui' cuaña'an nchcui' ca'an ne' 'in ñi lo' nchcui' ne': ");
INSERT INTO cya_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Yu re xca tucui ngulo laa yu, una a nchca culo laa yu 'in yu. Cha' na cui' yu lca yu Ree 'in ne' Israel, tca qui'ya yu loo cusi, lo' tsa qui'an ti' na 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","¿—Ta si'i 'in Ndiose mdi'in tyaa yu quiloo yu? Cui' ñi tca culo laa ñi 'in yu cha' na n'ni ñi 'tnan 'in yu—, si'yana cui' yu juin yu: Nan' lcan Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ticui' cuaña'an yu nu ta'a nga'an ñi loo cusi nchcui' ca'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Xa mdiyaa ndyi'ya cuaan, ngu'ya tla yta ña'aan se'en can' tsaya' mdiyaa braa cua' snan siin. ");
INSERT INTO cya_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chcua braa cua' snan siin can' ycui' cueen Jesús: —Elí, Elí, ¿lama sabactani—? Cha' re nchca ti' chcui': —Ndiose 'ñan, Ndiose 'ñan, ¿ñi cha' ta ngula yaa' um 'ñan—? ");
INSERT INTO cya_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ntsu'hui nu ngune 'in cha' nu ycui' ñi, lo' nchcui' ne': Yu re nsi'ya yu 'in nu ncua naan Elía. ");
INSERT INTO cya_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cui' ña'an lcaa mdo'o sca yu nu nguia 'ya sca te', lo' mcha' yu 'in na lo'o tyi'a vinagre, lo' mscuen yu 'in na sca tuco' yca si'yana xo' yi'o ñi 'in na. ");
INSERT INTO cya_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lo' juin nchgaa la ña'an yu can': Quita na ña'an na cha' caan Elía, lo' culo laa 'in yu. ");
INSERT INTO cya_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Una Jesús xiya' msi'ya cueen ñi, cui' ña'an lcaa mdo'o cusya 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Cui' xacan' te' tlyu nu nducui ni' lyaa can', mda' tlu'hue la na, ti' ndyi'o la cuaan tsaya' ngu'ya la lyuu, lo' juesa nu nguñan can' hasta lo'o quee nguita na. ");
INSERT INTO cya_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Hasta lo'o tucuaa nguila tucua na, lo' qui'an jun nu cua' ya qui'an ti' 'in Ndiose mdyiqui'o xacan', ");
INSERT INTO cya_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","mdyi'o jun ni' cuaa can' xa cua' mdyiqui'o Jesús, xacan' yten jun loo quichen Jerusalén, lo' qui'an nten na'an tloo 'in jun. ");
INSERT INTO cya_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yu nu lca que 'in sindatu ntsu'hui yu cuan 'in Jesús lo'o nchgaa la ña'an ta'a ndi'in yu can', xa na'an yu mdyisnan nguñan, a cunta lo'o nchgaa cha' nu yato'o, lyee ytsen yu, lo' nchcui' yu: Nu cha' ñi ca si'yana yu re ncua yu Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A cunta tyun jun cuna'an ndon tijyo' ti, ngui'ni quii jun, cui' nu ngui'ni cunta 'in Jesús ti' la se'en lca Galilea, ");
INSERT INTO cya_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","lja can' ndon María Magdalena, lo'o María jyi'an Jacobo lo'o yu See, a cunta lo'o jyi'an sñe' Zebedeo. ");
INSERT INTO cya_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Xa cua' msiin tsaan can' mdiyaa sca yu cuilyiya' naan See nu mdo'o Arimatea, lo'o yu cua' ntsu'hui yu cha' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ya jñan yu cha' cuiya' 'in Pilato si'yana cutsi' yu 'in Jesús. Xacan' ngulo yu tñan 'in sindatu 'in yu si'yana chcuan yu See can' cunta 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yu See can' mdyi'ya yu 'in ñi lo' nguxen yu sca te' nu luhui 'in ñi, ");
INSERT INTO cya_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","lo' mdi'in tyaa yu 'in ñi sca ni' tuquee nu tca nguiaa', xacan' mducun yu tucuaa can' lo'o sca quee nu tlyu, lo' mdo'o yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Cui' ti tucuaa can' ndon María Magdalena lo'o xca María. ");
INSERT INTO cya_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Xca tsaan can', cui' tsaan nu nxitñan' ne' judio, nchgaa yu nu ndlo ca tñan ni' lyaa, lo'o ne' fariseo mdiyaa ne' tloo yu Pilato, ");
INSERT INTO cya_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","lo' juin ne': 'Un nu lca x'nan hua, nguia yu'hui ti' hua sca cha' nu ycui' yu cuiñi can' xa ti' lo'o yu, lo' juin yu si'yana ta'a snan tsaan tyiqui'o yu. ");
INSERT INTO cya_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Can' cha' cua' ñii jñan hua sca cha' tsu'hue 'in um, ca'an tñan um 'in yu nu chu'hui cuan tucuaa can' tsani' snan tsaan, ña'an tu' tla tsaa ta'a mda'an yu lo' culyoo 'in yu, lo' tyisnan chcui' lo'o nten si'yana cua' mdyiqui'o yu, lo' hasta lyee la tsa qui'an ti' ne' cha' cuiñi re 'in yu que ña'an ti' culoo. ");
INSERT INTO cya_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mxcuen yu Pilato 'in ne': Una ndi'in silyiya 'in um, tca su'hua um 'in can' tsaa lo' chu'hui cuan tucuaa can', tsaña'an nu tca 'in um. ");
INSERT INTO cya_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Xacan' yaa ne' tucuaa can' lo' mducun tsu'hue la ne' 'in na, hasta mjyi'in ca'an ne' sca cuiya' 'in na, can' mxnu tucua ne' 'in yu nu chu'hui cuan 'in na. ");
INSERT INTO cya_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Xa mdijin tsaan nu nxitñan' ne' judio, tlya ti culoo tsaan 'in snan can', lo' María Magdalena lo'o xca María mdiyaa jun tucuaa can'. ");
INSERT INTO cya_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Xacan' lyee nguñan si'yana sca angujle 'in Ñi X'nan na mdo'o la ni' cuaan, lo' ngulo ntan quee nu nchcun tucuaa can', lo' can' yten tucua. ");
INSERT INTO cya_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tsu'hue ña'an tloo tsaña'an nchca ti' xa ndyuhui, tsu'hue ña'an mten ste' tsaña'an nchca ti' coo. ");
INSERT INTO cya_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yu nu ntsu'hui cuan can' lyee ytsen yu, lo' mdyisnan mchcuan yu xa na'an yu 'in angujle can', mdlyu yu lo' msti yu tsaña'an nchca ti' sca yu ngujui. ");
INSERT INTO cya_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Una angujle juin 'in jun cuna'an can': A cutsen um, jlyo tin' si'yana nda'an nan um 'in Jesús, ñi nu ngua'an loo cusi, ");
INSERT INTO cya_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","una a ntsu'hui 'a ñi re, si'yana cua' mdyiqui'o ñi ña'an nu cua' juin ñi. Quiaan um lo' cu'ni quii um se'en nu mdi'in tyaa ne' 'in Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ndla ti xitucui um lo' quia ytsa' um 'in yu ta'a mda'an ñi si'yana cua' mdyiqui'o ñi, a cunta culo nducua la tsaa ñi se'en lca Galilea, lo' can' ña'an um 'in ñi. Cua' ñii ngune 'in um cha' re. ");
INSERT INTO cya_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Xacan' mdo'o jun tucuaa can', nguitsen jun lo' tsacua ña'an tsu'hue ntsu'hui tiquee jun, ndla ndsa ti nguia ytsa' jun 'in yu ta'a mda'an ñi cha' nu na'an jun. ");
INSERT INTO cya_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tucueen nguiaa jun can' tsa ndu'hui ngulo'o tloo Jesús 'in jun, lo' ycui' cha' ñi 'in jun, cui' xaa mdyi'ya xtyin' jun tloo ñi, msu'hua tuscun jun quiya' ñi, lo' m'ni tnu jun 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Xacan' juin Jesús 'in jun: A cutsen um, xitucui um lo' taa um suun lo'o nchgaa yu ta'an si'yana tsaa yu se'en lca Galilea, la cua ña'an ta'a hua lo'o yu. ");
INSERT INTO cya_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lja nguiaa jun cuna'an can', mdo'o yu silyiya can' nguiaa yu nde loo quichen, lo' mtsa' yu 'in yu nu ndlo ca tñan ni' lyaa nchgaa cha' nu yato'o. ");
INSERT INTO cya_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mxo' ti'in ta'a ne' lo'o qui'yu cula, lo' m'ni cuiya' ne' cha' si'yana su'hua lyiya' ne' qui'an tñi 'in yu silyiya can', ");
INSERT INTO cya_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","lo' nchcui' ne' lo'o yu: Nde cha' nu chcui' um lo'o nten: Yu ta'a mda'an yu cua, yaa yu tla lo' ngulyoo yu 'in nu ngujui can' lja ngu'ya sla hua. ");
INSERT INTO cya_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Siya' gubierno cunan cha' re, una huare' cunan hua ña'an nu chcui' hua lo'o yu, lo' a sca cha' chen nchcui 'in um. ");
INSERT INTO cya_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yu silyiya can' msñi yu tñi can', ncua ja'an yu nchgaa cha' nu ycui' ne' lo'o yu, cuaña'an yato'o mxicune ne' cha' re lja ne' judio hasta cua' ñii. ");
INSERT INTO cya_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Cha tixca yu ta'a mda'an ñi mdo'o yu nguiaa yu se'en lca Galilea, mdiyaa yu loo qui'ya se'en mxnu Jesús cha' tsaa yu. ");
INSERT INTO cya_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Xa na'an yu 'in ñi m'ni tnu yu 'in ñi, una ntsu'hui nu m'ni tucua ti' lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Xacan' mdiyaa Jesús cui' la can', lo' juin ñi 'in yu: Nchgaa cha' cuiya' cua' jui 'ñan la ni' cuaan lo'o loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Can' cha' yaa um sca chcui chendyu lo' cunan um nu cu'ni cha'an cha' re, tucua tya um 'in can' lo'o cha' cuiya' 'in Stina Ndiose, lo'o Sñe' ñi, lo'o Espíritu nu Luhui 'in ñi, ");
INSERT INTO cya_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","lo' culo'o um 'in can' si'yana xu'hua se'en nchgaa cha' nu cua' ycuin' lo'o um. Ña'an jan ñi, nan' ndi'in lo'o um nchgaa xaa tsaya' nu tsatii cha' nu nchca loo chendyu re. Amen.");
INSERT INTO cya_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ndeña'an mdyisnan suun cha' tsu'hue 'in Jesucristo, Sñe' Ndiose, ");
INSERT INTO cya_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","tsaña'an nchcui' quityi nu ngua'an scua yu Isaía, yu nu mxiycui' Ndiose 'in cua' s'ni: —Ña'an jan ñi, nde ca'an tñan sca yu chcua loo si'yana cu'ni chu'hue yu tucueen nu caan. ");
INSERT INTO cya_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tyi'an yu se'en ngutyi lo' chcui' cueen yu: Cu'ni chu'hue um tucueen se'en caan Ñi X'nan na, lo' cu'ni ñi um tucueen nu ntsu'hui cha' tyijyin ñi—. ");
INSERT INTO cya_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yato'o yu Xuhua mda'an ycui' yu sca se'en ngutyi, ngulo'o yu 'in ne' si'yana xilo'o chon' ne' qui'ya 'in ne' lo' chcua tya ne', ña'an ca si'yana cu'ni Ndiose cha' tlyu ti' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Qui'an 'a ne' Jerusalén lo'o nchgaa la ña'an quichen ndi'in se'en lyi'ya loo Judea, ndyi'an ne' se'en nchcui' yu Xuhua can', ñee ne' qui'ya 'in ne' lo' mducua tya yu 'in ne' chco tlyu Jordan. ");
INSERT INTO cya_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Te' nu nchco' yu Xuhua can' nguiaa' na lo'o quichan' camello, lo'o sca quijyin nchcan' na sii' yu. Scua nu nchcu yu lca 'in sco', lo' ndyi'yo yu cuiñan' nu ntsu'hui ni' quixin'. ");
INSERT INTO cya_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ndeña'an nchcui' yu lo'o nten can': Nde loo la re ntsu'hui cha' caan ñi nu tla la cha' 'in que 'ñan nan'. Tsu'hue 'a ntsu'hui tiqueen cha' cua na tca xtin' siya' tisnan ti ñi. ");
INSERT INTO cya_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nan' nu cha' ñi lo'o tyi'a ti nducuan tyan 'in um, una cui' ñi ca'an tñan ñi Espíritu nu Luhui 'in Ndiose chu'hui ni' cusya 'in um. ");
INSERT INTO cya_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yato'o sca tsaan mdo'o Jesús quichen Nazaret se'en lyi'ya loo Galilea, mdiyaa ñi se'en ndon yu Xuhua chco tlyu Jordan, lo' mducua tya yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Xa cua' tyi'o Jesús loo tyi'a can', na'an ñi nguila tucua ni' cuaan, nguiaan Espíritu 'in Ndiose se'en ndon ñi, ngu'ya tucua que ñi tsaña'an nchca ti' ndyi'ya tucua sca scun' jo'o. ");
INSERT INTO cya_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ngune ycui' sca nu ycui' la ni' cuaan: Nu'huin lca Sñen' nan' nu ta'a lati 'ñan, tsu'hue 'a ntsu'hui tiqueen lo'o. ");
INSERT INTO cya_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Cui' xaa ti can' m'ni Espíritu cha' yaa Jesús sca se'en ngutyi. ");
INSERT INTO cya_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Can' yu'hui lyijyi ñi tsani' tucua yla tsaan, a cunta can' ntsu'hui 'ni la. Chcui lja xacan' ncua ti' laxa'an xityu 'in ñi loo qui'ya, una angujle 'in Ndiose mda yaa' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Xa cua' ntsu'hui yu Xuhua na'an chcuan, mdo'o Jesús nguiaa ñi se'en lca Galilea, can' mdyisnan ycui' ñi cha' tsu'hue 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","lo' nchcui' ñi: Cua' mdiyaa xaa tyisnan culo Ndiose tñan 'in um. Xilo'o chon' um qui'ya ngui'ni um lo' tsa qui'an ti' um cha' tsu'hue 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yato'o mdijin Jesús tu'hua tiyo' Galilea, can' na'an ñi 'in yu Tyo lo'o yu Ndre ta'a ngula yu, nduguun yu quitan loo tyi'a can' si'yana yu cuta cula lca yu. ");
INSERT INTO cya_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Lo' juin Jesús 'in yu: Chcui ncha'an um 'ñan, lo' nan' culo'on 'in um cu'ni um cuta, tyicana 'in nten. ");
INSERT INTO cya_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Cui' xaa ti can' ngula' sti yu quitan 'in yu lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chin' ti se'en ti' mda'an ñi, na'an ñi 'in yu Jacobo lo'o yu Xuhua ta'a ngula yu, sñe' Zebedeo, ngui'ni chu'hue yu quitan 'in yu ni' yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Cui' xaa can' msi'ya ñi 'in yu, lo' ngula' ton yu 'in Zebedeo sti yu lo'o nguso 'in yu ni' yca na'an can', lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xacan' mdiyaa jun quichen Capernaum, lo' tsaan nu nxitñan' ne' judio yten Jesús se'en n'ni tnu ne' 'in Ndiose, lo' ngulo'o ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lyee 'a yuhue ti' ne' 'in ñi si'yana ndlo'o ñi ña'an nchca ti' sca nu ntsu'hui cha' cuiya' 'in, lo' si'i ña'an ndlo'o ne' escriba. ");
INSERT INTO cya_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lja can' nguilyu sca yu nu ntsu'hui cui'in xa'an 'in, lo' ycui' cueen yu: ");
INSERT INTO cya_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jesús Nazaret, ¿ñi na nchca ti' lo'o hua? ¿Ta na ljyaan si'yana cujlyo 'in hua? Nan' ndyu'huin lyoon ti ca lca, nu'huin lca ycui' ca nu mdo'o hui 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Una Jesús ngusun lo'o 'in cui'in xa'an can', lo' juin ñi: Seen tyi'in, lya' ton 'in yu re. ");
INSERT INTO cya_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Cui'in xa'an can' mscuin ti'in na 'in yu xiya' ti, cui' ña'an lcaa msi'ya yja cueen yu xa mdyi'o na 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nchgaa ne' yuhue ti' ne', mñicha' ta'a ne' lo' nchcui' ne': ¿Ñi cha' ta lca cha' re? Chacui' cha' nu cui ti ndlo'o yu, hasta lo'o cui'in xa'an ndlo yu tñan 'in, lo' nchca ja'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ndla ndsa ti can' mdo'o yne cha' 'in ñi sca chcui se'en lca Galilea. ");
INSERT INTO cya_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ña'aan mdyi'o Jesús se'en ndiyo' ti'in ne' can', nguiaa ñi lo'o yu Jacobo lo'o yu Xuhua, lo' mdiyaa jun se'en nducua na'an 'in yu Tyo lo'o yu Ndre. ");
INSERT INTO cya_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Cui' xaa jui nu mtsa' 'in ñi si'yana jyi'an laa yu Tyo nscua ti'i lo'o tique'. ");
INSERT INTO cya_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Xacan' yaa ñi se'en nscua ne', msñi ñi yaa' ne' lo' mxitucui ñi 'in ne'. Cui' xaa mdyi'o tique' can' 'in ne', lo' mdyisnan m'ni cunta ne' 'in jun. ");
INSERT INTO cya_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Xa cua' nguiaa cucha, mdiya lo'o ne' nchgaa nu ti'i lo'o nu ntsu'hui cui'in xa'an 'in se'en ndon Jesús, ");
INSERT INTO cya_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ña'aan quichen ne' nguio' ti'in ne' tu'hua tuna'an can'. ");
INSERT INTO cya_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús m'ni chca ñi 'in qui'an nu ti'i lo'o cuati loo quicha nu ntsu'hui 'in ne', ngulo ñi cui'in xa'an nu ntsu'hui 'in ne', lo' a mdaa ñi cha' cuiya' ti' chcui' cui'in xa'an can' si'yana jlyo ti' can' tucui ca lca ñi. ");
INSERT INTO cya_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Xa nde cua' ljyaan xaa, mdo'o Jesús nguiaa ñi nde tu'hua quichen scati ñi, can' nchcui' lyi'o ñi 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yu Tyo lo'o nchgaa la ta'a nda'an yu, mdo'o yu nguia nan yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Xa nguija lyoo ñi 'in yu, xacan' juin yu: Qui'an 'a nten nda'an nan 'in um. ");
INSERT INTO cya_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Lo' juin ñi 'in yu: Tsaa na scasca la quichen nu ndi'in cui' ti re, lo' chcuin' cha' tsu'hue 'in Ndiose, si'yana can' tñan ljyaan. ");
INSERT INTO cya_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ña'aan se'en lyi'ya loo Galilea mda'an ycui' ñi cha' tsu'hue 'in Ndiose cunda scaa se'en n'ni tnu ne' 'in Ndiose, a cunta ngulo ñi cui'in xa'an nu ntsu'hui 'in nten. ");
INSERT INTO cya_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yato'o sca tsaan, tloo Jesús mdiyaa sca yu ti'i lo'o quitso' la. Mdyi'ya xtyin' yu lo' ycui' 'tnan yu lo'o ñi: Cha' nchca ti' um lo' cu'ni chca um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús mña'an 'tnan ti' ñi 'in yu, mxñii ñi yaa' ñi lo' m'ni ca'an ñi 'in yu, lo' juin ñi: Nchca tin'. Quinu luhui lo'o quicha cua 'in. ");
INSERT INTO cya_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cui' xaa ti ngulyijyi quicha can' 'in yu, lo' mchca yu. ");
INSERT INTO cya_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Xacan' ngulo ñi tñan 'in yu si'yana quiaa yu, una tla cha' ycui' ñi lo'o yu: ");
INSERT INTO cya_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ña'an jan ñi, xñi cunta si'yana a chcui' lo'o ñi sca tucui cha' re. Tsaloo ti tsaa se'en nducua laa lo' culo'o 'in 'in yu nu ndlo tñan ni' lyaa, taa sca lcuan ña'an nu ngulo Moisé tñan, xacan' ca cuiya' ti' nten si'yana cua' mchca. ");
INSERT INTO cya_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Una yu nu mchca can' mdo'o yu nguiaa yu, mdaa yu suun lo'o ña'an nu ti cha' nu yato'o 'in yu. Can' cha' a ncua 'a ti' sten Jesús scasca quichen, tsaloo ti se'en nu a tca nten ndyi'an ñi, una ñi cuaña'an ti' ndyi'o nten scasca quichen ndyi'an nan 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tsa mdijin tucua snan ti tsaan, xiya' mxitucui Jesús nde quichen Capernaum. Mscua cueen cha' 'in ñi ña'aan sca chcui quichen si'yana cua' nguila ñi nde ña'an. ");
INSERT INTO cya_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Cui' ña'an lcaa nguio' ti'in qui'an nten, mtsa'an yu'hui ne' tuna'an lyiya', lo' Jesús ndlo'o ñi cha' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Xacan' tsa jacua yu qui'yu mdiya lo'o yu sca nu ti'i nu ncua cuti ti' ña'aan, si'yana cu'ni chca Jesús 'in. ");
INSERT INTO cya_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Si'ya nten qui'an can', a ncua sten lo'o yu 'in nu ti'i can' se'en ndon ñi. Can' cha' ycuen lo'o yu 'in nde que na'an, can' msla yu sca se'en mdyi'ya sti yu 'in nu ti'i can' tloo ñi. ");
INSERT INTO cya_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Xa na'an Jesús si'yana lyee ndiya qui'an ti' yu 'in ñi, xacan' juin ñi 'in nu ti'i can': Sñen', cua' mchca qui'ya 'in. ");
INSERT INTO cya_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lja can' nducua tucua snan ne' escriba, lo' nguñan ti' ne': ");
INSERT INTO cya_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Ña'an 'ni tiquee yu re nchcui' yu cuaña'an? Na nchcui' ca'an yu 'in Ndiose. ¿Ta si'i scati Ndiose nchca 'in ñi xicuten ñi qui'ya? ");
INSERT INTO cya_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús cui' xaa ngu'ya ñi cunta cha' nu ñan ti' ne', lo' juin ñi: ¿Ñi cha' ta ñan ti' um cuaña'an? ");
INSERT INTO cya_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ti ña'an ta cha' nu a tucui la chcuin' lo'o yu ti'i re: Ta cunen lo'o yu, cua' mchca qui'ya 'in, uta chcuin', tyiton, lo' xñi s'ñan lo' quiaa? ");
INSERT INTO cya_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ña'an jan ñi, si'yana ca cuiya' ti' um si'yana nan', Yu Qui'yu nu Mdo'o nde ni' Cuaan, ntsu'hui cha' cuiya' 'ñan xicuten qui'ya 'in nten loo chendyu re. (Xacan' juin ñi 'in nu ti'i can'): ");
INSERT INTO cya_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nan' chcuin' lo'o, tyiton lo' xñi s'ñan, lo' quiaa nde ña'an 'in. ");
INSERT INTO cya_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cui' xaa mdyiton yu, msñi yu s'ñan yu, mdo'o yu nguiaa yu tloo na'an nten can'. Yuhue 'a ti' ne' lo' m'ni tnu ne' 'in Ndiose, lo' juin ne': Ñi siya' a nchca ña'an na cha' nu na'an na cua' ñii. ");
INSERT INTO cya_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chon' nde'en can' mdo'o Jesús nguiaa ñi nde tu'hua tiyo', ticui' ti ña'an nducui ncha'an nten 'in ñi, lo' ndlo'o ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Se'en nguiaa ñi na'an ñi 'in sca yu naan Leví, sñe' yu Alfeo, nducua yu se'en nsu'hua lyiya' nten tñi, lo' juin ñi 'in yu: Chcui ncha'an um 'ñan. Mdyiton yu lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yato'o mdiyaa Jesús lo'o yu ta'a nda'an ñi na'an 'in yu Leví, tsatlyu ycu jun lo'o nchgaa la ña'an yu nu ndlo tñi, a cunta qui'an yu nducun' ta'a nchcu jun, si'yana qui'an 'a nten nducui ncha'an ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tucua snan ne' escriba lo'o ne' fariseo, xa na'an ne' si'yana Jesús nchcu ñi lo'o chacui' yu nducun', lo' juin ne' 'in yu ta'a nda'an ñi: ¿Ñi cha' ta nchcu yu re lo'o yu ndlo tñi lo'o yu nducun'? ");
INSERT INTO cya_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ngune 'in Jesús cha' nu ycui' ne', lo' juin ñi 'in ne': Ne' nu lyee ti', a najo'o rmiyu 'in ne', una nu ti'i, can' nu najo'o na 'in. A ljyan nan 'in nten nu cua' lca luhui, cui' ca nu ljyaan si'ya ne' nu nducui qui'ya. ");
INSERT INTO cya_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yu ta'a nda'an yu Xuhua ngui'ni yu ayuna, a cunta lo'o ne' fariseo ngui'ni ne' cuaña'an. Xacan' mdiyaa tucua snan yu nu mñicha' 'in Jesús: ¿Ñi cha' ta yu nu nducui ncha'an 'in yu Xuhua, lo'o yu nu nducui ncha'an 'in ne' fariseo n'ni yu ayuna, lo' ñi cha' ta yu ta'a nda'an um, a n'ni yu cuaña'an? ");
INSERT INTO cya_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Juin Jesús 'in yu: Nten nu ndyi'an se'en ndyijyi cuilyi'o ne', ¿ta tca cu'ni can' ayuna lja ti' nducua yu nu ndyijyi cuilyi'o can'? A tca 'in can' si'yana ti' nducua sca se'en ti lo'o yu nu ndyijyi cuilyi'o can'. ");
INSERT INTO cya_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Una tiyaa xaa a la 'a quine cueen yu nu jui cuilyi'o can', xacan' tca cu'ni can' ayuna. ");
INSERT INTO cya_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","A tucui nu nxcuan su'hua sca te' nu cua' cula lo'o tsa yu'hue te' tiji, si'yana cha' cu'ni ne' cuaña'an, te' tiji can' xiya' na, lo' sta na 'in te' cula can'. Lo' se'en nu mda' can' lyee la xeen na. ");
INSERT INTO cya_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","A tucui nu nsu'hua vino nu cui ti ni' sca cuijyin quijyin nu cua' cula, cha' cu'ni ne' cuaña'an, chcuen vino can' lo' cutsu quijyin can', tsato'o quilo na lo' jlyo quijyin can'. Can' cha' ntsu'hui cha' su'hua ne' vino nu cui ti ni' sca cuijyin nu tiji. ");
INSERT INTO cya_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yato'o sca tsaan nu nxitñan' ne' judio, mdijin Jesús lo'o yu ta'a nda'an ñi sca loo jyaan se'en nducua trigo. Yu ta'a nda'an ñi mdyisnan mston yu juun trigo lo' ycu yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Xacan' juin ne' fariseo 'in ñi: Ña'an jan ñi, ¿ñi cha' ta ngui'ni yu ta'a nda'an sca cha' nu a nga'an cha' cu'ni na tsaan nu nxitñan' na? ");
INSERT INTO cya_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Una mxcuen ñi 'in ne': ¿Ta na a nchca chcui' um quityi cha' 'in Davi xa ngute' ti' yu lo'o yu ta'a mda'an yu? ");
INSERT INTO cya_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cui' xa ngulo Abiatar tñan ni' lyaa, yten yu Davi lo' ycu yu jaslya nu cua' ndi'in lo'o cunta 'in Ndiose, lo' mdaa yu 'in na 'in yu ta'a mda'an yu, lo' na tsaloo ti yu nu ndlo tñan ni' lyaa ntsu'hui cha' cuiya' cu 'in na. ");
INSERT INTO cya_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ti' juin la ñi 'in ne': Tsaan nu nxitñan' ne', mdaa Ndiose 'in na si'yana najo'o na 'in nten, lo' si'i tsaan can' culo na tñan 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Can' cha' lo'o tsaan nu nxitñan' ne', nan' Yu Qui'yu nu Mdo'o nde ni' Cuaan, lcan X'nan na. ");
INSERT INTO cya_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Xiya' yato'o yten Jesús se'en n'ni tnu ne' 'in Ndiose, can' ntsu'hui sca yu nu ngutyi sca tso' yaa'. ");
INSERT INTO cya_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lo' nsñi ne' cunta 'in Jesús cha' ta cu'ni chca ñi 'in yu tsaan nu nxitñan' ne', si'yana caja ña'an su'hua ne' qui'ya 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Xacan' juin Jesús 'in yu nu ngutyi yaa' can': Tyiton lo' caan la tlu'hue re. ");
INSERT INTO cya_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lo' juin ñi 'in nten can': ¿Ñi tñan tsu'hue cu'ni na tsaan nu nxitñan' na, cha' tsu'hue, uta cha' nu a tsu'hue? ¿Culo laa na 'in nten, uta na taa na ya' caja ne'? A mxcuen ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Xacan' tla mxina'an Jesús 'in ne', tsacua se'en ti'i nga'an 'in ñi si'yana ndyijyin ya' tla cusya 'in ne', juin ñi 'in yu ti'i can': Xñii yaa'. Cui' xaa mxñii yu yaa' yu, lo' mchca tsu'hue na 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Xacan' mdo'o ne' fariseo, nguia y'ni cuiya' ne' cha' lo'o tsalca ta nten 'in ree Herode, si'yana cujui ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Una Jesús mdo'o ñi nguiaa ñi lo'o yu ta'a nda'an ñi nde tu'hua tiyo' Galilea. Qui'an nten mducui ncha'an 'in ñi, ne' nu mdo'o se'en lyi'ya loo Galilea lo'o Judea, ");
INSERT INTO cya_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","lo'o quichen Jerusalén, lo'o se'en lca Idumea, lo'o xca tso' chco tlyu Jordan mdo'o ne', lo'o se'en lyi'ya loo quichen Tiro lo'o Sidón mdo'o ne'. Qui'an 'a nten mda'an nan ne' 'in ñi, si'yana ynan ne' cha' ña'an cha' nu tnu ngui'ni ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Si'ya nten qui'an can', ngulo Jesús tñan 'in yu ta'a nda'an ñi, si'yana tyi'in tiyaa yu lo'o yca na'an nu ntsu'hui cha' sten ñi se'en nu a sta su'hua ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Si'yana qui'an 'a nu ti'i cua' m'ni chca ñi, nchgaa la ña'an nu ti'i can' nsta su'hua 'in ñi se'en nu cula' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nten nu ntsu'hui cui'in xa'an 'in, xa na'an ne' 'in Jesús, cui' xaa ndyi'ya xtyin' ne' tloo ñi, nxi'ya yja cueen ne', lo' nchcui' ne': Nu'huin lca Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Una Jesús tla cha' ycui' lo'o ne', si'yana a chcui' la ne' tucui ca lca ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chon' nde'en can' ycuen Jesús sca loo qui'ya, msi'ya ñi 'in tsalca nu ncua ti' ñi, lo' nguio' ti'in yu tloo ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Xacan' ngulohui ñi 'in tsa tichcua yu nu ta'a tyi'an ca ñi nchgaa xaa, yu nu ca'an tñan ñi 'in chcui' cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mdaa ñi cha' cuiya' 'in yu si'yana tca culo yu cui'in xa'an nu ntsu'hui 'in nten, lo' tca cu'ni chca yu 'in nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nde yu nu ngulohui ñi: Yu Simón, nu mdi'in tyaa ñi nii ca naan Tyo, ");
INSERT INTO cya_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yu Jacobo, sñe' yu Zebedeo, lo'o yu Xuhua ta'a ngula yu, chcuaa yu can' mdi'in tyaa ñi nii yu, Boanerges, lo' cha' re nchca ti' chcui', sñe' tyi'yu, ");
INSERT INTO cya_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","yu Ndre, yu Lpe, yu Bartolomé, yu Mateo, yu Toma, lo'o yu Jacobo, sñe' yu Alfeo, yu Tadeo, lo'o yu Simón nu ntsu'hui cha' 'in ne' cananista, ");
INSERT INTO cya_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","lo'o yu Juda Iscariote nu mdyaa 'in Jesús. Xacan' mxitucui jun lo' nguila jun la na'an. ");
INSERT INTO cya_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ña'an ti ya' nguio' ti'in qui'an nten se'en ndi'in jun, ñi cu jun lo' a jui 'a xaa. ");
INSERT INTO cya_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Xa ynan ta nten 'in Jesús cha' can', cui' xaa mdo'o jun nguia 'ya jun 'in ñi, si'yana cua' nchcui' nten si'yana ndiyo' ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lja can' ntsu'hui ne' escriba nu mdo'o quichen Jerusalén, nchcui' ne' si'yana Jesús ntsu'hui x'nan cui'in xa'an 'in ñi nu naan Beelzebú, lo' si'ya cha' cuiya' 'in can' ndlo ñi cui'in xa'an nu ntsu'hui 'in nten. ");
INSERT INTO cya_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Xacan' msi'ya ñi 'in ne' escriba, lo' mdyisnan ycui' ñi scasca cha' lo'o ne': ¿Ña'an ta tca 'in Laxa'an culo 'in ticuii'? ");
INSERT INTO cya_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Cui' cuaña'an se'en nducua lo'o ne' cha' cuiya', cha' a sca cha' ti 'in ne', a tca cula scua cha' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ticui' cuaña'an lo'o nten nu ndi'in sca na'an, cha' a sca cha' ti 'in can', a tca cula scua cha' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cuaña'an Laxa'an, cha' nsuun can' lo'o ticuii', cha' a sca cha' ti 'in, a tca cula scua cha' 'in can', tsato'o tsatii tuhue cha' 'in. ");
INSERT INTO cya_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","A cunta, a tucui nu tca sten na'an 'in sca yu nu ngula ti' lo' cu'ni cunan 'in yu, cha' si'i culo nducua scan' ne' 'in yu, la xacan' cui'ya ne' na nu ndi'in 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nu cha' ñi chcuin' lo'o um, nchgaa qui'ya nu n'ni ne', lo'o nchgaa yuhue' nu nchcui' ne', ti' cu'ni Ndiose cha' tlyu ti' 'in ne', ");
INSERT INTO cya_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","tyicana nu nchcui' yuhue' 'in Espíritu nu Luhui 'in Ndiose, a nducua 'a tsaan cu'ni Ndiose cha' tlyu ti' 'in can', cui' ca nu nducui ncha'an yuhue' 'in can' tsala xaa. ");
INSERT INTO cya_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Juin Jesús cuaña'an, si'yana ne' escriba nchcui' ne': Cui'in xa'an ntsu'hui 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lja xacan' mdiyaa jyi'an Jesús lo'o ta'a ngula ñi tuna'an lyiya', lo' ngulo jun tñan 'in ne' si'yana xi'ya ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nten nu ta'a nducua ñi can' juin 'in ñi: Tuna'an lyiya' cua mdiyaan ñi jyi'an um lo'o ta'a ngula um, lo' nan jun 'in um. ");
INSERT INTO cya_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mxcuen ñi 'in ne': ¿Tucui ca lca jyi'an, lo' tucui lca ta'a ngulan? ");
INSERT INTO cya_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tyi'iin mxina'an ñi, lo' juin ñi: Nde nu lca jyi'an lo'o ta'a ngulan, ");
INSERT INTO cya_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","si'yana nchgaa nu nducua tñan cha' nu nchcui' Ndiose, can' nu lca ta'an lo' can' nu lca jyi'an. ");
INSERT INTO cya_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Xiya' mdyisnan ngulo'o Jesús 'in nten tu'hua tiyo' can'. Lo' si'ya nten qui'an can' yten tucua ñi ni' yca na'an. Nchgaa nten can' nguio' ti'in ne' tu'hua tiyo' can'. ");
INSERT INTO cya_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Qui'an 'a cha' ngulo'o ñi 'in ne' lo'o scasca cha' nu ycui' ñi, lo' ndeña'an nchcui' ñi: ");
INSERT INTO cya_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ton nscan um cha' re: Nu ncua sca tsaan mdo'o sca yu qui'yu, nguia yta yu mti trigo. ");
INSERT INTO cya_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Se'en msne yu 'in na nguilo tsachin' na tu'hua tucueen, cui' xaa ti yaan quiñi nu ycu 'in na. ");
INSERT INTO cya_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tichin' mti can' nguilo na sca se'en nu chin' ti yuu nducua loo quee. Ndla mducua na si'yana chin' ti yuu mducun ti'in 'in na. ");
INSERT INTO cya_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Xa mdyisnan m'ni tique' cuaan 'in na cui' xaa nguinan' na, lo' ngutyi na si'yana a ngu'ya xcua' tsu'hue na. ");
INSERT INTO cya_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tichin' mti can' nguilo na sca se'en nducua yca quiche'. Ndla la ylo yca quiche' can', lo' a mdaa na ya' culo trigo can'. ");
INSERT INTO cya_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lo' tichin' na nguilo na loo yuu tsu'hue, tsu'hue 'a ylo na lo' ncua tñan na. Ntsu'hui juun can' mdaa na cla tyii mti scati loo juun na, ntsu'hui juun nu mdaa snan yla mti, lo' ntsu'hui nu mdaa sca ciento na scati loo juun. ");
INSERT INTO cya_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Xacan' juin ñi 'in ne': Nchgaa nu ngune 'in cha' nu ycuin', cu'ni cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Xa cua' nguinu ton ñi lo'o yu tichcua nu ta'a nda'an ñi, lo'o chcua xnan nu ndon cui' ti can', mñicha' yu 'in ñi sca cunta, cha' ñi cha' nchca ti' chcui' cha' nu ycui' ñi can'. ");
INSERT INTO cya_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Lo' juin ñi 'in yu: Cha' nu ntsu'hui cutsi' 'in Ndiose tsaña'an ndlo ñi tñan, cua' mdaa ñi cha' cuiya' 'in um si'yana qui'ya um cunta cha' re. Una nchgaa la ña'an nten chacui' cha' nu ntsu'hui nchcun nchcuin' lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","—Siya' lyee la ña'an ne' lo' a chcan' 'in ne', siya' lyee la ndon nscan ne' lo' a qui'ya ne' cha' tiyaa, ña'an ca si'yana a quia nan ne' 'in Ndiose, lo' ñi a cuten qui'ya 'in ne'—. ");
INSERT INTO cya_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Lo' juin Jesús 'in yu: ¿Ta na a ngu'ya um cunta cha' nu ycuin' can'? ¿Ña'an la ca nchgaa la ña'an cha' nu cua' mdi'in tyaan? ");
INSERT INTO cya_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yu nu ntya mti trigo can', nguiaa cha' 'in yu ña'an cha' 'in yu nu nchcui' cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mti trigo nu nguilo tu'hua tucueen can', lca na ña'an cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose. Cui' xaa ndyi'an Laxa'an lo' ndlyoo cha' tsu'hue nu cua' ntsu'hui ni' cusya 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mti nu nguilo loo yuu nu titi tu'hua nducua loo quee can', lca na ña'an cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, tsu'hue ntsu'hui tiquee ne' nducuan xu'hue ne' 'in na. ");
INSERT INTO cya_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Una a ngu'ya xcua' tsu'hue na ni' cusya 'in ne', xi'i ti ndaa loo ne', lo' si'ya scasca cha' nu ndyijyin ne' si'ya cha' 'in Ndiose, cui' xaa ndyi'o tso' ne'. ");
INSERT INTO cya_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mti nu nguilo se'en nducua yca quiche' can', nguiaa cha' 'in na ña'an cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Una si'ya scasca cha' nu nchca loo chendyu re, cha' xquee' 'in cha' cuilyiya', lo' nchcui ti' ne' scasca la cha', can' nu ndujui xu'hua cha' tsu'hue nu cua' ntsu'hui ni' cusya 'in ne', lo' a ndyijyi 'a ña'an cuton na. ");
INSERT INTO cya_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Una mti nu nguine loo yuu tsu'hue can', nguiaa cha' 'in na ña'an cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, nducuan xu'hue ne' 'in na, lo' tsu'hue nchca tñan na: Ntsu'hui juun nu ndyi'yu cla tyi mti loo, ntsu'hui nu ndyi'yu snan yla na 'in, a cunta ntsu'hui juun nu ndyi'yu sca ciento na loo. ");
INSERT INTO cya_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nde xca cha' ycui' ñi: A tucui nu nguiten lo'o sca quii' ndiquin, lo' nde tucun ti'in 'in na ni' cuiya' sca', uta nde ni' qui'ñan, cui' ca nu tyi'in tyaa ne' 'in na sca se'en cuaan si'yana tu'hui na xaa. ");
INSERT INTO cya_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ticui' cuaña'an lo'o sca cha' nu nchca cunan ti, a tca a quine cha' 'in na, uta lo'o sca cha' nu nchca cutsi' ti, a tyijyin yu'hui cha' a tyi'o scua la na. ");
INSERT INTO cya_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nchgaa nu ne 'in cha' nu nchcuin', cu'ni cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Lo' ti' juin la ñi: Ton nscan um cha' re: Cua' yaa ña'an cuiya' nu ndaa um, cuaña'an cuiya' caja nu taa 'in um, lo' hasta nde lyee la caja na 'in um. ");
INSERT INTO cya_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Si'yana nten nu cua' jui cha' tsu'hue 'in, nde lyee la caja cha' tsu'hue can' 'in, una sca nten nu a ndi'in cha' tsu'hue 'in, lo'o tsachin' cha' nu nducua tloo can', caja nu lyaa 'in na. ");
INSERT INTO cya_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Lo' ti' juin la ñi: Lo'o cha' re ca jlyo ti' um ña'an ntsu'hui cha' culo Ndiose tñan 'in nten. Nguiaa cha' re tsaña'an nguiaa cha' 'in yu nu ntya sca mti. ");
INSERT INTO cya_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ndijya' yu lo' ndyitucui yu, cuaña'an ndijin tsaan 'in yu, lja xacan' nducua mti can', lo' a jlyo ti' yu ña'an nguia nguilo na. ");
INSERT INTO cya_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cha' 'in ti na ndyi'o tucua na loo yuu: Culoo nchcua lca' na, xacan' ndyi'o juun na, la xacan' ndyi'o tucua mti loo juun can'. ");
INSERT INTO cya_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Xa cua' ngula na, nxo' yu 'in na si'yana cua' mdiyaa xaa 'in na. ");
INSERT INTO cya_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nde xca cha' nu ti' ycui' ñi: ¿Ti ña'an ta cha' tca tyi'in tyaa na si'yana tca qui'ya na cunta ña'an ntsu'hui cha' culo Ndiose tñan 'in nten? ");
INSERT INTO cya_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nguiaa cha' can' tsaña'an cha' 'in mti mostaza, mti nu suhue lati nu ntya nten. ");
INSERT INTO cya_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Una xa cua' nguita na, tnu lati ndlyo na que nchgaa loo quixin' nu ntya ne', tnu ndlyo stan' na lo' hasta lo'o quiñi nchcua cu'hua 'in lja na. ");
INSERT INTO cya_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Qui'an 'a cha' ti' ycui' la ñi lo'o nten can', cua' ña'aan ndyi'ya ne' cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Scasca cha' ycui' ñi lo'o nten can', una xca cunta ndlyo scua la ñi cha' can' lo'o yu ta'a nda'an ñi. ");
INSERT INTO cya_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Xa msiin tsaan can', juin Jesús 'in yu ta'a nda'an ñi: Tyijyin xi'yu na xca tso' tiyo' re. ");
INSERT INTO cya_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Xacan' msla' ta'a ñi lo'o nten can', lo' yu ta'a nda'an ñi nguia lo'o yu 'in ñi ni' yca na'an, lo'o nchgaa la ña'an yca na'an can' ta'a nguiaa jun. ");
INSERT INTO cya_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mdyisnan ncua cui'in lyee ya', cui' ña'an lcaa lo'o tiyo' can' mdyisnan nguitsa na, ncua cha' cha'an yu'hui tyi'a ni' yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Una Jesús ngu'ya sla ñi nde chon' la yca na'an can', nscua 'ni quee ñi loo sca te'. Yu ta'a nda'an ñi ngulyoo yu sla ñi, lo' juin yu: Ñi Bstro, ¿ta na a ndyuhue ti' um ña'an cua' quityin' yu'hui ti na? ");
INSERT INTO cya_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Xacan' mdyiton Jesús lo' ngusun lo'o ñi 'in cui'in can', lo' ycui' ñi lo'o tiyo' can': Seen tyi'in. Cui' xaa ngula' ti' cui'in can', lo'o tiyo' can' ncua tiin na. ");
INSERT INTO cya_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lo' juin ñi 'in yu ta'a nda'an ñi: ¿Ñi cha' lyee 'a nguitsen um? ¿Ta na a ndiya qui'an ti' um 'ñan? ");
INSERT INTO cya_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Una yu ta'a nda'an ñi scaña'an ti ndi'in ytsen yu, lo' scasca yu ñicha' ta'a yu, lo' nchcui' yu: ¿Tucui ca lca ñi re, ñi cha' hasta cui'in lo'o tyi'a, lo' ja'an 'in ñi? ");
INSERT INTO cya_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xacan' mdiyaa jun xca tso' tiyo' can' se'en lca loo yuu 'in ne' Gadara. ");
INSERT INTO cya_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ña'aan mdyi'o Jesús ni' yca na'an can', mdiyaa sca yu ndiyo' tloo ñi nu mdo'o ni' lyi'o se'en nguitsi' nten, lo' ntsu'hui cui'in xa'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Can' nguilyu yu nchgaa xaa, lo' a tucui nu nchca tyon tloo yu, ñi lo'o carena lo' a nchca scan' ne' 'in yu, ");
INSERT INTO cya_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","si'yana tyun 'a ya' mchcan' quiya' yu lo'o yaa' yu lo'o carena, lo' cui' xaa nsi'yu yu 'in na, a tucui nu ncua 'in lo'o yu. ");
INSERT INTO cya_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tla lo' cucha nda'an nsi'ya yja yu loo qui'ya lo'o se'en lca tucuaa, lo' ndyujui yuhua' yu 'in yu lo'o quee. ");
INSERT INTO cya_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ti' tijyo' ndon yu xa na'an yu 'in Jesús, msnan yu ya ycua yu 'in ñi, lo' mdyi'ya xtyin' yu tloo ñi. ");
INSERT INTO cya_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ycui' cueen yu lo'o ñi: Jesús, Sñe' Ndiose, ñi nu tlyu lati nu nducua ni' cuaan, ¿ñi cha' ngui'ni lyi'o um 'ñan? Nan' jñan sca cha' tsu'hue 'in um tloo Ndiose si'yana a xitijin um 'ñan nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Juin yu cuaña'an si'yana Jesús cua' nchcui' ñi: Cui'in xa'an, lya' ton 'in yu re siya' ti. ");
INSERT INTO cya_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mñicha' ñi 'in yu: ¿Ña'an ta naan? Lo' mxcuen yu 'in ñi: Legión naan hua, si'yana qui'an 'a hua. ");
INSERT INTO cya_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Lyee 'a mjñan cui'in xa'an can' cha' tsu'hue 'in ñi, si'yana a culo tso' ñi 'in tijyo' la. ");
INSERT INTO cya_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Cui' ti sca sii' qui'ya, qui'an 'a cuhue' nda'an nan ycu. ");
INSERT INTO cya_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Lo' nchgaa cui'in xa'an can' mjñan cha' tsu'hue 'in ñi, lo' juin: Taa um cha' cuiya' sten hua 'in cuhue' cua. ");
INSERT INTO cya_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Cui' xaa mdaa Jesús cha' cuiya', cui' ña'an lcaa mdyi'o cui'in xa'an can' 'in yu, lo' yten 'in cuhue' can'. Cuhue' can' ndiyaa 'in tsaa tucua mii 'in, lo' nchgaa 'in mdo'o snan 'in, lo' mxityu loo 'in loo tiyo' can' se'en ngujui 'in. ");
INSERT INTO cya_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yu nu na'an seen cuhue' can' msnan yu, lo' mtsa' yu 'in nten nchgaa se'en mdijin yu, ni' quixin' lo'o loo quichen, ña'an cha' nu yato'o, cui' xaa ya na'an ne' cha' ñi na nchca. ");
INSERT INTO cya_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Xa mdiyaa ne' se'en nducua Jesús, na'an ne' 'in yu nu yu'hui qui'an cui'in xa'an 'in can', nducua yu chcui cha' tiyaa 'in yu, nguxen yu sca te', lo' lyee ytsen ne'. ");
INSERT INTO cya_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nu na'an nchgaa cha' nu yato'o can', mdaa suun lo'o nten nu mdiyaa can', cha' 'in yu nu yu'hui cui'in xa'an 'in can', lo'o cha' 'in cuhue' can'. ");
INSERT INTO cya_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Xacan' scasca ne' mjñan ne' 'in Jesús si'yana tyi'o ñi se'en can'. ");
INSERT INTO cya_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Xa cua' yten Jesús ni' yca na'an can', lo' yu nu yu'hui cui'in xa'an 'in can' mjñan yu cha' tsu'hue 'in ñi, cha' tca tsaa yu lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Una Jesús a mdaa ñi cha' cuiya', lo' juin ñi 'in yu: Quiaa nde ña'an 'in, lo' quitsa' 'in nchgaa nten 'in ña'an cha' tsu'hue m'ni Ndiose lo'o, lo' ña'an mña'an 'tnan ti' ñi 'in. ");
INSERT INTO cya_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Xacan' nguia ytsa' yu 'in nten nu ndi'in scasca quichen se'en lyi'ya loo Decápolis, ña'an cha' tsu'hue nu m'ni Jesús lo'o yu, lo' nchgaa ne' yuhue ti' ne'. ");
INSERT INTO cya_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Xiya' mdijin xi'yu Jesús lo'o yca na'an xca tso' tiyo' can', lo' mdyisnan nguio' ti'in qui'an nten tu'hua se'en ndon ñi can'. ");
INSERT INTO cya_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Can' mdiyaa sca yu naan Jairo, sca yu ndlo tñan se'en n'ni tnu ne' judio 'in Ndiose, xa na'an yu 'in ñi mdyi'ya xtyin' yu tloo ñi. ");
INSERT INTO cya_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Lyee mjñan yu 'in ñi lo' nchcui' yu: Cua' caja ti sca sñen'. Cu'ni um cha' tsu'hue tsaa um se'en nscua, lo' ti'in tyaa um yaa' um 'in lo' chca. ");
INSERT INTO cya_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Xacan' mdo'o ñi nguiaa ñi lo'o yu, lo' qui'an 'a nten mducui ncha'an 'in ñi, hasta nsta su'hua ta'a ne' lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lja nten can' ntsu'hui sca ne' cuna'an, nu cua' ntsu'hui tichcua yjan ti'i lo'o quicha nguilo tne. ");
INSERT INTO cya_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lyee 'a cua' mdijin ne' nu ti'i yaa' ne' nu n'ni rmiyu, a cunta cua' ngulyijyi ne' ña'aan tñi nu su 'in ne', lo' a sca cunta yu'hui 'in ne', cui' ca nu nde lyee la ti'i ne'. ");
INSERT INTO cya_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Xa ynan ne' cha' 'in Jesús, cui' xaa yaan ne' nde chon' ñi lja nten qui'an can', lo' yla' ne' ste' ñi, ");
INSERT INTO cya_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","si'yana ñan ti' ne': Siya' cua' tsu'hue ste' ti ñi culan', lo' chcan. ");
INSERT INTO cya_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cui' ña'an lcaa ngulyijyi ylo tne can' 'in ne', lo' ngüi ti' ne' si'yana mchca ne'. ");
INSERT INTO cya_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Cui' xaa ngu'ya Jesús cunta si'yana lo'o cha' cuiya' 'in ñi mchca sca nu yla' 'in ñi, lo' mxiton ñi mñicha' ñi 'in nten can', cha' ti nu yla' ste' ñi. ");
INSERT INTO cya_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yu ta'a nda'an ñi juin 'in ñi: Ña'an um tsala ña'an qui'an nten re nsta su'hua ne' 'in um, lo' ti' ñicha' um, ti ca nu yla' 'in um. ");
INSERT INTO cya_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Una Jesús tyi'iin mxina'an ñi cha' ti ca nu yla' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ne' cuna'an can' ngu'ya ne' cha' tiyaa ña'an cha' nu yato'o 'in ne', mdyisnan mchcuan ne' si'yana lyee ytsen ne', lo' mdyi'ya xtyin' ne' tloo ñi, lo' mtsa' ne' 'in ñi ña'aan cha' nu yato'o 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lo' juin ñi 'in ne' cuna'an can': Sñen', cua' mchca si'yana ya qui'an ti' 'ñan. Quia lya lo' quinu luhui, a sca la cha' chu'hui tiquee. ");
INSERT INTO cya_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Can' cha' ti' ndon ycui' ñi, xa mdiyaa tucua snan yu nu mdo'o la na'an 'in yu nu ndlo ca tñan can', lo' juin yu: Cua' ngujui sñe' um. ¿Ñi cha' ti' ndaa um cha' nsin' ti' 'in ñi re? ");
INSERT INTO cya_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngune 'in Jesús cha' nu ycui' yu, lo' juin ñi 'in yu nu ndlo tñan can': A cutsen um, tsaloo ti tsa qui'an ti' um. ");
INSERT INTO cya_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A mdaa ñi ya' chcui ncha'an qui'an la nten 'in ñi, tsa yu Tyo ti, yu Jacobo, lo'o yu Xuhua ta'a ngula yu Jacobo, ya lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Xa mdiyaa jun na'an 'in yu nu ndlo tñan can', na'an ñi qui'an 'a nten cua' ndi'in can', lo' ndi'in ynan ne'. ");
INSERT INTO cya_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ña'aan yten ñi ña'an can', juin ñi 'in nten can': ¿Ñi cha' lyee 'a nguilo ti'in um lo' nguinan um? Cuhui' cua, si'i na ngujui cuhui', na lja' ti cuhui'. ");
INSERT INTO cya_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Xacan' mstyi lyi'o ne' 'in ñi. M'ni ñi cha' mdo'o ne' nde lyiya', tsa sti ti cuhui' lo'o jyi'an cuhui', lo'o yu ta'a nda'an ti ñi, yten lo'o ñi la se'en nscua cuhui' can'. ");
INSERT INTO cya_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Msñi ñi yaa' cuhui', lo' juin ñi 'in lo'o cha' nu nchcui' ñi: Talita cumi. Cha' re nchca ti' chcui': Maa, 'in nchcui' lyi'on, tyitucui. ");
INSERT INTO cya_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Cui' xaa mdyitucui cuhui' lo' mdyisnan mda'an cuhui'. Lo' cua' ntsu'hui cuhui' tichcua yjan. Ndyijyin ya' yuhue ti' ne' ña'an cha' nu yato'o can'. ");
INSERT INTO cya_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Una lyee 'a mjñan ñi 'in ne', si'yana a chcui' ne' lo'o ñi sca tucui cha' nu yato'o, lo' ngulo ñi tñan si'yana taa ne' na cu cuhui'. ");
INSERT INTO cya_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Xacan' mdo'o Jesús nguiaa ñi lo'o yu ta'a nda'an ñi nde quichen tyi ñi. ");
INSERT INTO cya_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Xa mdiyaa tsaan nu nxitñan' ne', mdyisnan ngulo'o ñi 'in nten ndi'in se'en n'ni tnu ne' 'in Ndiose. Qui'an 'a nten can' ngune 'in ne' cha' nu ndlo'o Jesús, nduhue ti' ne' 'in ñi, lo' nchcui' ne': ¿La ta ngulo yu re cha' nu nchcui' yu? ¿La jui cha' tiyaa re 'in yu, lo' nchca n'ni yu scasca cha' nu tnu? ");
INSERT INTO cya_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ta si'i cuityi yca lca yu re, cui' sñe' María? ¿Ta si'i Jacobo, yu See, yu Juda lo'o Simón lca ta'a ngula yu? ¿Ta si'i nchgaa nu cuna'an ta'a yu ndi'in lo'o na quichen re? Can' cha' a tsu'hue lca tiquee ne' lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Juin Jesús 'in nten can': Sca yu nu nxiycui' Ndiose 'in, xca quichen ndyijyi nu nducuan xu'hue 'in yu, una quichen tyi yu, ta lja ta nten 'in yu, uta la na'an 'in yu, a ndyijyi nu cuan xu'hue 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A jui ña'an cu'ni Jesús qui'an la cha' nu tnu quichen tyi ñi, cui' ca nu tucua snan ti nu ti'i m'ni chca ñi, xa mdi'in tyaa ñi yaa' ñi 'in. ");
INSERT INTO cya_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nduhue 'a ti' ñi 'in ta'a quichen tyi ñi si'yana a ndiya qui'an ti' ne' 'in ñi. Xacan' mdo'o Jesús, nguiaa ñi scasca quichen suhue ti nu ndi'in cui' ti can', lo' ngulo'o ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Xacan' msi'ya ñi 'in tsa tichcua yu ta'a nda'an ca ñi, lo' cunda tucua ti yu ngua'an tñan ñi 'in yu tsaa yu scasca quichen, mdaa ñi cha' cuiya' culo yu cui'in xa'an nu ntsu'hui 'in nten. ");
INSERT INTO cya_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ngulo ñi tñan 'in yu si'yana ñi sca na lo' a cui'ya yu, tsaloo yca scaan ti yu, ñi a cui'ya yu cuijyin, ñi na nu cu yu, ñi tñi lo' a cui'ya yu, ");
INSERT INTO cya_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","tsaloo ti quinan lo'o ste' ndon ti yu tsaa yu. ");
INSERT INTO cya_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Xacan' juin ñi 'in yu: Xa tiyaa um sca quichen, cha' nde'en nu taa na'an 'in quinu um, can' tyi'in um tsalja nu quilyu um quichen can'. ");
INSERT INTO cya_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Cha' nde'en se'en a cuan xu'hue ne' 'in um, ñi a ton nscan ne' cha' nu chcui' um, tyi'o um can' lo' scuin um yuu quiya' um, lo' quinu cunta 'in ne' cha' nde'en la cha' caan 'in ne'. Nu cha' ñi chcuin' lo'o um, nten ndi'in quichen can', lyee la tyijyin ne' nu ti'i que ña'an ntsu'hui cha' tyijyin ne' Sodoma lo'o Gomorra, xa cu'ni Ndiose xñan bsya 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xacan' mdo'o yu nguiaa yu, lo' ycui' yu lo'o nten si'yana xilo'o chon' ne' qui'ya ngui'ni ne'. ");
INSERT INTO cya_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ngulo yu qui'an cui'in xa'an nu ntsu'hui 'in nten, a cunta qui'an nu ti'i mxita'an yu ceite 'in, lo' mchca. ");
INSERT INTO cya_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yu nu lca ree Herode ynan yu cha' 'in Jesús, si'yana cua' mscua cueen cha' 'in ñi sca chcui se'en can'. Ndeña'an nchcui' yu cha' 'in ñi: Yu Xuhua nu mducua tya 'in nten cua' mdyiqui'o yu, can' cha' nchca n'ni yu cha' nu tnu. ");
INSERT INTO cya_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ntsu'hui xca nu nchcui': Elía lca yu re. Ntsu'hui xca nu nchcui': Cui' sca yu nu nxiycui' Ndiose 'in lca yu, tsaña'an mxiycui' ñi 'in scasca la tucui cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Xa ynan yu Herode cha' can', juin yu: Cui' ca yu Xuhua nu ngulon tñan xi'yu yni can' lca yu re, lo' cua' ñii cua' mdyiqui'o yu. ");
INSERT INTO cya_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ycui' ca yu Herode ngulo yu tñan si'yana quinu yu Xuhua can', scan' yu lo'o carena lo' tsaa yu na'an chcuan. M'ni yu cuaña'an si'ya sca ne' cuna'an naan Herodía, cuilyi'o yu Lpe ta'a ngula yu, yato'o ngulyaa yu Herode 'in ne' lo' ndi'in lyi'o yu 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yu Xuhua can' nchcui' yu lo'o Herode si'yana a tsu'hue tyi'in lyi'o yu cuna'an 'in ta'a yu. ");
INSERT INTO cya_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Can' cha' lyee la yten cha' nsin' ti' tiquee ne' cuna'an can', lo' nan ne' ña'an nu cujui ne' 'in yu Xuhua, tyicana a jui ña'an na, ");
INSERT INTO cya_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","si'yana yu Herode ntsu'hui sca ytsen 'in yu tloo yu Xuhua can', jlyo ti' yu lca can' sca nten nu ñi ndi'in cha' 'in, nu ndu'hui sca chendyu nu luhui tloo Ndiose, can' cha' nxñi yu cunta si'yana a sca ca 'in. Nducui ti' yu ne 'in yu cha' nu nchcui' yu Xuhua can', siya' lyee nsu'hua yu cha' tiquee yu. ");
INSERT INTO cya_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Una mdiyaa tsaan nu nta ne' cuna'an can', cui' tsaan nu ngu'ya nii yu Herode, msu'hua yu sca ta'a. Msi'ya yu 'in nchgaa ta'a lyi'ya yu tñan nu ndon loo lati, lo'o x'nan sindatu, lo'o nu ndon loo lati ndi'in se'en lyi'ya loo Galilea. ");
INSERT INTO cya_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Lja nchca ta'a can' yten ne' cuna'an sñe' Herodía lo' yla quiya' ne' tloo ree Herode can', mdiyaa 'a ti' yu lo'o nchgaa ta'a nducua yu ña'an yla quiya' ne' cuna'an can'. Xacan' juin yu 'in ne' cuna'an can': Jñan na nu nchca ti', lo' nan' taan 'in na 'in. ");
INSERT INTO cya_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","M'ni tyi'ya yu 'in Ndiose xa juin yu 'in ne': Jñan na nu nchca ti', lo' a 'ni cha' siya' tsa tlu'hue cha' cuilyiya' nu ndi'in 'ñan, lo' taan 'in na 'in. ");
INSERT INTO cya_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mdo'o ne' cuna'an can', nguia ñicha' ne' 'in jyi'an ne', lo' juin ne': ¿Ñi na ta jñan 'in ree? Cui' xaa mxcuen jyi'an ne': Jñan que Xuhua nu mducua tya 'in nten. ");
INSERT INTO cya_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ndla ndsa ti yten ne' cuna'an can' se'en nducua ree can', lo' juin: Jni re ñii nchca tin' sca qui'nan se'en ntsu'hui que Xuhua nu mducua tya 'in nten. ");
INSERT INTO cya_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ngulu'un 'a ti' yu ree, lo' si'yana cua' ycui' yu sca cha' nu ñi ca tloo nchgaa ta'a nducua yu, a jui 'a ña'an ti' xitsa'an yu cha' nu cua' mdi'in tyaa yu. ");
INSERT INTO cya_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Cui' xaa ngulo yu tñan 'in sca sindatu 'in yu si'yana quia 'ya que yu Xuhua can'. ");
INSERT INTO cya_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Yaa yu sindatu lo' msi'yu yni yu Xuhua se'en ntsu'hui yu na'an chcuan, nguian lo'o yu que can' ndi'in na sca ni' qui'nan, lo' mdyaa yu 'in na 'in nu cuna'an can', lo' nu cuna'an can' cua' mdyaa 'in na 'in jyi'an. ");
INSERT INTO cya_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yu ta'a mda'an yu Xuhua, xa ynan yu cha' si'yana cua' ngujui yu, ya chcuan yu cunta 'in, lo' ya tsi' yu 'in. ");
INSERT INTO cya_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Xacan' nguila yu ta'a nda'an ca Jesús, lo' mtsa' yu 'in ñi nchgaa ña'an nu m'ni yu, lo'o ña'an nu ngulo'o yu 'in nten se'en yaa yu. ");
INSERT INTO cya_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lo' juin ñi 'in yu: Tsa xitñan' na sca se'en tsa ycui' ti na. Juin ñi cuaña'an si'yana qui'an 'a nten nguia yaan ne' se'en nguilyu ñi, lo' ñi nu ti' cu jun, lo' a ndyijyi 'a xaa. ");
INSERT INTO cya_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Xacan' yten jun ni' yca na'an, mdo'o jun nguiaa jun sca se'en tsa ycui' ti jun. ");
INSERT INTO cya_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Una qui'an 'a nten na'an ne' xa mdo'o jun nguiaa jun, lo' yu'hui lyoo ne' 'in jun, can' cha' scasca quichen mdo'o ne' mda'an quiya' ti ne', lo' culo nducua la ne' mdiyaa ne' se'en ntsu'hui cha' tiyaa ñi. ");
INSERT INTO cya_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Xa mdyi'o Jesús ni' yca na'an can', na'an ñi si'yana qui'an 'a nten cua' nguio' ti'in can', lo' mña'an 'tnan ti' ñi 'in ne' si'yana ndi'in ne' ña'an nchca ti' slya' nu a ntsu'hui x'nan. Lo' qui'an 'a cha' ngulo'o ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Xa cua' msiin tsaan can', mdiyaa yu ta'a nda'an ñi tloo ñi lo' juin yu: Cua' msiin na, lo' tijyo' nguinu quichen re. ");
INSERT INTO cya_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tsu'hue lati cha' chcui' um lo'o ne', tsa si'i ne' na nu cunajo'o 'in ne', la ña'an ti se'en nga'an nten ni' quixin' uta quichen suhue ti, si'yana a nda'an lo'o ne' na nu cu ne'. ");
INSERT INTO cya_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mxcuen Jesús 'in yu: ¿Ñi cha' ta a xicu um 'in ne'? Juin yu: ¿Ta nchca ti' um culyijyi hua tñi tsaña'an nu cu'ni na canan tucua ciento tsaan, lo' xi'i hua jaslya nu cu ne' re? ");
INSERT INTO cya_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Lo' juin ñi 'in yu: Cu'ni cunta um cha' ñi ncua jaslya nda'an lo'o um. Xa ngujlyo ti' yu xacan' juin yu: Ca'yu ti jaslya lo'o tucua ti cula. ");
INSERT INTO cya_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ngulo ñi tñan 'in yu ta'a nda'an ñi si'yana chcui' yu lo'o nten can', si'yana sten tucua ne' cunda scaa ta ne' loo quii suhue ti can'. ");
INSERT INTO cya_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yten tucua ne' cunda scaa ta ne': Ntsu'hui se'en nducua cunda ciento ne', lo' xca se'en nducua ne' cunda tu'hua tyi ne'. ");
INSERT INTO cya_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Xacan' msñi Jesús ta'a ca'yu jaslya lo'o chcuaa cula can', mscuen ñi tloo ñi nde ni' cuaan lo' mdyaa ñi xu'hue 'in Ndiose, msu'hue ñi 'in na lo' mdaa ñi 'in na 'in yu ta'a nda'an ñi. Can' yu mtsa 'in na 'in nchgaa nten can'. Cui' cuaña'an m'ni ñi lo'o chcuaa cula can'. ");
INSERT INTO cya_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nchgaa ne' ycu ne' tsaya' ngula' ti' ne'. ");
INSERT INTO cya_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Lo' ti' mxo' yu cha tichcua xcuhui jaslya nu nguinu ycu ne' lo'o cula can'. ");
INSERT INTO cya_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tsalca yu qui'yu nu ycu jaslya can' ndiyaa yu tsa ca'yu mii yu. ");
INSERT INTO cya_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Cui' xaa ngulo Jesús tñan 'in yu ta'a nda'an ñi si'yana sten yu ni' yca na'an, chcua loo yu lo' tyijyin yu xca tso' tiyo' can' se'en ndi'in quichen Betsaida, lja nu ti' nsla' ta'a ñi lo'o nten qui'an can'. ");
INSERT INTO cya_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Xa cua' msla' ta'a ñi lo'o nten can', ycuen ñi sca loo qui'ya si'yana chcui' lyi'o ñi 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Xa cua' ngu'ya tla can', cua' tiyaa ti yca na'an can' tlu'hue tiyo', una ti' ndon ñi tu'hua tyi'a can' scati ñi. ");
INSERT INTO cya_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na'an ñi si'yana cua' xtyi lo'o juesa ti nguiaa yu ta'a nda'an ñi, si'ya cui'in nu ljyaan loo yu. Nde cua' ljyaan xaa mdo'o Jesús nguia ncha'an ñi 'in yu, mda'an quiya' ñi loo tyi'a can', m'ni ñi cha' tyijyin ta ti ñi se'en nguiaa yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Xa na'an yu nda'an quiya' ti ñi loo tyi'a can', msque' ti' yu si'yana sca cuxee lca ñi, lo' msi'ya yja yu, ");
INSERT INTO cya_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","si'yana nchgaa yu na'an yu 'in ñi, lo' lyee ytsen yu. Una cui' xaa can' ycui' Jesús lo'o yu: Cu'ni tnu tiquee um si'yana nan' lcan, a cutsen um. ");
INSERT INTO cya_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Xacan' ycuen ñi ni' yca na'an can', cui' xaa ngulyijyi cui'in can', lo' ndyijyin ya' yuhue' ti' yu. ");
INSERT INTO cya_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ñi a nchca qui'ya yu cha' tiyaa, ñi cha' nchca ti' chcui' xa msu'hue ñi jaslya nu ycu ne' can', si'yana ti' nchcun cha' tiyaa 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Xa cua' mdijin xi'yu jun loo tyi'a can', mdiyaa jun loo yuu Genesaret. Lo' tu'hua tyi'a can' mscan' ca'an jun 'in yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ña'aan mdyi'o jun ni' yca na'an can', cui' xaa yu'hui lyoo nten can' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Msnan ne', nguia 'ya ne' 'in nu ti'i sca chcui se'en can', lo' mdiya lo'o ne' 'in nscua loo qui'ñan se'en nu ngune cha' mdiyaa ñi. ");
INSERT INTO cya_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lo' la ña'an ti quichen suhue ti se'en nda'an ñi, lo'o quichen tnu, ta se'en nga'an nten ni' quixin', uta tu'hua tucueen se'en nu ntsu'hui cha' tyijyin ñi, ndiya lo'o ne' 'in nu ti'i. Lo' nu ti'i can' njñan cha' tsu'hue 'in ñi, siya' cua' tsu'hue tu'hua ste' ti ñi cha' taa ñi cula' can', lo' nchgaa nu yla' ste' ñi mchca. ");
INSERT INTO cya_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Xacan' mdiya ti'in tucua snan ne' fariseo tloo Jesús, lo'o chcua xnan ne' escriba nu mdo'o quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Xa na'an ne' si'yana yu ta'a nda'an Jesús nchcu yu, lo' a ngunan' yu tsaña'an nu ntsu'hui cha' 'in ne', mdaa ne' qui'ya si'ya cha' can'. ");
INSERT INTO cya_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Si'yana tsalca ne' fariseo lo'o nchgaa la ña'an ne' judio, tla 'a nguia ncha'an ne' nchgaa cha' nu mxnu scua nten cula 'in ne', lo' a nchcu ne' cha' a culo nducua ñaan' ne'. ");
INSERT INTO cya_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Xa nguila ne' ndyi'an ne' se'en nchca quiya', a nchcu ne' cha' a culo nducua ñaan' ne'. A cunta qui'an la cha' nu ti' nxu'hua se'en ne', ña'an nchca ti' scasca loo na nu njyi'an ne', vaso, quiton', ta castyo chcuan, a cunta lo'o qui'ñan. ");
INSERT INTO cya_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ne' fariseo lo'o ne' escriba mñicha' ne' 'in Jesús: ¿Ñi cha' ta yu ta'a nda'an, a n'ni cunta yu ña'an cha' nu mxnu scua nten cula 'in na, lo' a ñaan' yu xa nchcu yu? ");
INSERT INTO cya_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mxcuen ñi 'in ne': 'Un ne' nu a ñi ndi'in cha' 'in, cha' ñi ca ña'an cha' nu mxiycui' Ndiose 'in yu Isaía cha' nu 'in um, xa juin yu: —Nten re n'ni tnu ne' 'ñan lo'o tu'hua ti ne', una cusya 'in ne' tijyo' nchca na siin'. ");
INSERT INTO cya_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Cua cha' ti n'ni tnu ne' 'ñan, si'yana cha' nu ndlo'o ne' lca na chacui' cha' nu ndlo que ne', lo' nchcui' ne' si'yana cha' 'in Ndiose lca na—. ");
INSERT INTO cya_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Una nxnu ca'an chon' um cha' nu ngulo Ndiose tñan, lo' nde tsu'hue lati nguia ncha'an um cha' nu cua' ntsu'hui 'in nten, ña'an nchca ti' njyi'an um scasca loo na nu ndlya' um, ta quiton', uta vaso, a cunta qui'an 'a cha' ti' nxu'hua se'en um. ");
INSERT INTO cya_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ti' juin la ñi 'in ne': 'Un ndlo tso' um cha' nu ngulo Ndiose tñan, se'en nu tyon loo cha' nu cua' ntsu'hui 'in um. ");
INSERT INTO cya_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nde sca cha' nu ycui' Moisé: —Cu'ni suun um 'in um tloo sti um lo'o jyi'an um—, lo' —nu taja 'in sti lo'o jyi'an tyi'o tñan caja can'—. ");
INSERT INTO cya_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Una 'un nchcui' um cha' sca yu qui'yu nu ndi'in na 'in, lo' tsaloo chcui' ti yu lo'o nten cula 'in yu, si'yana na nu ndi'in 'in yu lca na Corbán (cha' re nchca ti' na nchcui' na si'yana cua' lca na sca lcuan 'in Ndiose), ");
INSERT INTO cya_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","lo' ndiyato'o a ndaa um cha' cuiya' ti' ta yaa' yu 'in nten cula 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Cuaña'an ndlo tso' um ycha' Ndiose, ña'an ca si'yana tsa quiñan um lo'o cha' nu cua' ntsu'hui 'in um. Cui' cuaña'an ljyan y'ni um lo'o scasca la cha'. ");
INSERT INTO cya_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Xacan' msi'ya Jesús 'in nten can', lo' juin ñi: Nchgaa um quine 'in um, lo' qui'ya um cha' tiyaa cha' nu chcuin'. ");
INSERT INTO cya_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Si'i si'ya cha' nchcu, can' cha' a luhui cusya 'in ne', cui' ca nu si'ya cha' nu ndyi'o ni' cusya 'in ne', can' nu n'ni coo' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nchgaa nu ndon nscan cha' re, qui'ya cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Xacan' mdo'o tso' Jesús lo'o yu ta'a nda'an ñi lja nten qui'an can', lo' yten jun sca na'an, can' mñicha' yu 'in ñi, cha' ña'an ndyi'o cha' nu ycui' ñi can'. ");
INSERT INTO cya_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Lo' juin ñi 'in yu: ¿Ta na lo'o um nchcun cha' tiyaa 'in um? ¿Ta na a ndyi'ya um cunta si'yana si'i si'ya cha' nchcu, nchca coo' cusya 'in ne'? ");
INSERT INTO cya_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Si'i ni' cusya 'in ne' ndyi'an na nu nchcu ne', cui' ca nu nde ni' ne' nguiaa na lo' ndyijyin ti na. Lo'o cha' nu ycui' ñi re ca jlyo ti' na si'yana nchgaa loo na tca cu na. ");
INSERT INTO cya_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Lo' ti' juin la ñi: Cha' nu ndyi'o ni' cusya 'in nten, can' na nu n'ni coo' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Si'yana ni' cusya 'in ne' ndyi'o nchgaa cha' tiyaa ngunan', cha' nu nguiten yu'hui ne' lo'o cuilyi'o nten uta lo'o ne' ycui' ti, cha' nu ndujui ta'a ne', ");
INSERT INTO cya_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cha' cunan, nu nchcui ti' ne' cha' cuilyiya', cha' nducun', cha' cuiñi, nu a ndii ti' ne' cha' jyi'o, cha' njñan ti', cha' nu nchcui' ca'an ta'a ne', cha' siye', lo'o cha' nu n'ni ne' cua' ña'an ti. ");
INSERT INTO cya_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nchgaa cha' re ndyi'o ni' cusya 'in ne', can' nu n'ni coo' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xacan' mdo'o Jesús nguiaa ñi se'en lyi'ya loo quichen Tiro lo'o Sidón, can' yten ñi sca na'an, ncua ti' ñi si'yana a tucui nu ca jlyo ti' la mdiyaa ñi, una a ncua chu'hui cutsi' ñi. ");
INSERT INTO cya_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sca ne' cuna'an nu ntsu'hui cui'in xa'an 'in sñe', xa ynan ne' cha' si'yana mdiyaa ñi can', cui' xaa mdiyaa ne' se'en ndon ñi, lo' mdyi'ya xtyin' ne' tloo ñi. ");
INSERT INTO cya_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Lca ne' sca ne' griego nu ncua tyi Sirofenicia, mjñan ne' cha' tsu'hue 'in ñi si'yana culo ñi cui'in xa'an nu ntsu'hui 'in sñe' ne'. ");
INSERT INTO cya_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Una mxcuen Jesús 'in ne': Tyaa ya' cu sñe' nten culo nducua la, si'yana a ntsu'hui cha' caja nu culyaa jaslya nu ntsu'hui tuyaa' sñe' ne', lo' taa 'in na cu xni'. ");
INSERT INTO cya_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mxcuen ne' 'in ñi: Cha' ñi 'in um Ñi X'nan hua, una lo'o xni' nu ndlyu nde ni' msa, nxo' ycu 'in ta nu nguilo tu'hua nu xuhue ti. ");
INSERT INTO cya_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Xacan' juin Jesús 'in ne': Tsu'hue ña'an nu ycui', quia lya, cui'in xa'an can' cua' mdyi'o 'in sñe'. ");
INSERT INTO cya_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Xa nguila ne' la na'an 'in ne', nguija lyoo ne' 'in sñe' ne' nscua loo qui'ñan, cua' mdyi'o cui'in xa'an can' 'in. ");
INSERT INTO cya_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Xacan' mdo'o Jesús quichen Tiro can', mdijin ñi quichen Sidón, lo' xa cua' mxisti ñi se'en lca Decápolis, xacan' nguila ñi tu'hua tiyo' Galilea. ");
INSERT INTO cya_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Can' mdiya lo'o ne' 'in sca yu cu'un nu yja nchcui' se'en ndon Jesús, mjñan ne' cha' tsu'hue 'in ñi si'yana tyi'in tyaa ñi yaa' ñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Lja nten can' mdo'o lo'o Jesús 'in yu ntan ti, yjo' yaa' ñi tunscan yu, ngulo'o siye' ñi, lo' yla' ñi loo tse' yu, ");
INSERT INTO cya_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","xacan' mxina'an ñi nde ni' cuaan, lo' xi'in 'a nguiaan ti' ñi, lo' juin ñi 'in yu: Efata. Cha' re nchca ti' na nchcui' na: Quila na. ");
INSERT INTO cya_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cui' xaa nguila tunscan yu lo' mchca tsu'hue tse' yu, lo' mdyisnan ycui' tsu'hue yu. ");
INSERT INTO cya_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Xacan' ngulo ñi tñan 'in nten can' si'yana a chcui' ne' lo'o ñi sca tucui cha' nu yato'o. Una siya' lyee la ngulo ñi tñan 'in ne' si'yana a chcui' ne', nde lyee lati mxicune ne' cha' can'. ");
INSERT INTO cya_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nten can' ndyijyin ya' yuhue ti' ne' 'in ñi lo' nchcui' ne': Nchgaa cha' nu n'ni ñi tsu'hue na, hasta lo'o nu cu'un lo' n'ni ñi cha' nguila tunscan, nu a nchca chcui' lo' n'ni ñi cha' nchcui'. ");
INSERT INTO cya_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yato'o sca tsaan nguio' ti'in qui'an 'a nten, lo' a lo'o 'a na nu cu ne', xacan' msi'ya Jesús 'in yu ta'a nda'an ñi, lo' juin ñi 'in yu: ");
INSERT INTO cya_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","'Tnan 'a tin' 'in nten re, si'yana cua' nchca tsa cucha ndi'in ne' lo'on, lo' a lo'o 'a na nu cu ne'. ");
INSERT INTO cya_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cha' culon tñan 'in ne' quiaa ne' la na'an 'in ne', lo' si'yana a nchca cu ne', tsato'o ña'an ti' ne' tucueen quiaa ne', si'yana ntsu'hui ne' re tijyo' mdo'o ne'. ");
INSERT INTO cya_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yu ta'a nda'an ñi mxcuen 'in ñi: ¿Ña'an ta cu'ni na caja jaslya nu cu ne' re, lo' a tucui ndi'in ca re? ");
INSERT INTO cya_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Xacan' mñicha' ñi 'in yu: ¿Ñi ncua ta jaslya nda'an lo'o um? Mxcuen yu 'in ñi: Tsa cati ti na. ");
INSERT INTO cya_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ngulo ñi tñan 'in nten can' si'yana sten tucua ne' lyuu. Msñi ñi ta'a cati jaslya can', mdyaa ñi xu'hue 'in Ndiose, msu'hue ñi 'in na, lo' mdaa ñi 'in na 'in yu ta'a nda'an ñi, can' yu nu cua' mtsa 'in na 'in nchgaa nten can'. ");
INSERT INTO cya_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","A cunta nda'an lo'o yu tucua snan cula suhue ti, ncuan ñi 'in 'in, lo' ngulo ñi tñan 'in yu si'yana quitsa 'in lja nten can'. ");
INSERT INTO cya_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nchgaa ne' ycu ne' tsaya' ngula' ti' ne'. Lo' ti' mxo' yu cha cati xcuhui na nu nguinu ycu ne'. ");
INSERT INTO cya_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ne' nu ycu can' ndiyaa ne' jacua mii ne'. Xacan' msla' ta'a ñi lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Cui' xaa yten ñi ni' yca na'an lo'o yu ta'a nda'an ñi, mdo'o jun nguiaa jun se'en lca Dalmanuta. ");
INSERT INTO cya_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xacan' mdiyaa tucua snan ne' fariseo se'en ndon Jesús, lo' ncua ti' ne' si'yana cu'ni ñi sca cha' nu tnu nu tyi'o nde ni' cuaan, ña'an ca si'yana su'hua ne' qui'ya 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Xacan' xi'in 'a nguiaan ti' ñi, lo' juin ñi: ¿Ñi cha' nten re chacui' cha' nu tnu njñan ne' 'ñan? Una cha' ñi chcuin' lo'o um, ñi sca cha' nu tnu lo' a cu'nin tloo ne'. ");
INSERT INTO cya_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ngula' ton ñi 'in ne', lo' xiya' yten jun ni' yca na'an can', mdo'o jun nguiaa jun nde xca tso' tiyo'. ");
INSERT INTO cya_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yu ta'a nda'an ñi ngujlya ti' yu cui'ya yu na nu cu jun, seen scati jaslya nda'an lo'o yu ni' yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Msu'hua tiyaa ñi 'in yu, lo' juin ñi: Xñi um cunta 'in um lo'o suun jaslya 'in ne' fariseo, lo'o nu 'in yu Herode. ");
INSERT INTO cya_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Scasca yu nchcui' yu: Cui' si'yana a lyi'ya na jaslya, can' cha' nchcui' ñi cuaña'an. ");
INSERT INTO cya_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ngu'ya Jesús cunta cha' nchcui' yu, lo' juin ñi 'in yu: ¿Ñi cha' nchcui' um si'yana a lo'o jaslya lyi'ya um? ¿Ta xtyi ti' a chcan' 'in um lo' a ndyi'ya um cunta? ¿Ta ti' nchcun 'a cha' tiyaa 'in um? ");
INSERT INTO cya_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ndi'in quiloo um lo' a chcan' 'in um, nducua tunscan um lo' a ne 'in um. ¿Ta na a ndiya yu'hui ti' um ña'an m'nin? ");
INSERT INTO cya_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Xa msu'huen ca'yu jaslya, lo' tsa ca'yu mii nten ycu 'in na, ¿ñi ncua xcuhui ti' m'ni cha'an um lo'o na nu nguinu ycu ne' can'? ");
INSERT INTO cya_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ticui' cuaña'an xa msu'huen cati jaslya nu ycu jacua mii nten can', ¿ñi ncua xcuhui na ti' mxo' um? Mxcuen yu 'in ñi: Cha cati na. ");
INSERT INTO cya_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Lo' juin ñi 'in yu: ¿Ta cui' ña'an ti a ndyi'ya um cha' tiyaa? ");
INSERT INTO cya_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Xa mdiyaa jun quichen Betsaida, mdiya lo'o ne' 'in sca yu cuityin' se'en ndon Jesús, lo' mjñan ne' cha' tsu'hue 'in ñi si'yana cula' ñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Xacan' msñi ñi yaa' yu cuityin' can', mdo'o lo'o ñi 'in yu nde tu'hua quichen, can' ngulo'o siye' ñi chcuaa tso' quiloo yu, mdi'in tyaa ñi yaa' ñi 'in yu, lo' mñicha' ñi 'in yu cha' cua' chcan' chin' 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mxina'an yu, lo' juin yu: Chcan' 'ñan se'en nguilyu nten, lo' cua' lca na yca nda'an na xque' tin'. ");
INSERT INTO cya_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Xiya' mdi'in tyaa ñi yaa' ñi quiloo yu, ngulo ñi tñan 'in yu si'yana xina'an tsu'hue ca yu, lo' nguila xaa quiloo yu, tijyo' loo ncua chcan' 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ngulo ñi tñan 'in yu si'yana quiaa yu nde ña'an 'in yu, lo' juin ñi: Una a sten loo quichen, ñi a chcui' lo'o ñi sca tucui cha' nu yato'o 'in. ");
INSERT INTO cya_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chon' nde'en can' mdo'o Jesús lo'o yu ta'a nda'an ñi, nguiaa jun nde quichen se'en lca Cesarea de Filipo. Tucueen nguiaa jun mñicha' ñi 'in yu: ¿Tucui ta lcan nan' nchcui' nten? ");
INSERT INTO cya_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mxcuen yu 'in ñi: Ntsu'hui nu nchcui' si'yana lca um yu Xuhua nu mducua tya 'in nten, xca nu nchcui' si'yana lca um Elía, a cunta ntsu'hui nu nchcui' lca um scasca la yu nu mxiycui' Ndiose 'in cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Xacan' juin ñi 'in yu: Lo' 'un jan ñi, ¿tucui ta lcan nan' xque' ti' um? Mxcuen yu Tyo 'in ñi: 'Un lca um ñi nu lca Cristo. ");
INSERT INTO cya_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Una ngulo ñi tñan 'in nchgaa yu can', si'yana a chcui' yu lo'o ñi sca tucui ti ca lca ñi. ");
INSERT INTO cya_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mdyisnan ngulo'o ñi 'in yu si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan, ntsu'hui cha' tyijyin ñi nu ti'i lyee ya', juin ñi si'yana qui'yu cula lo'o yu nu ndlo ca tñan ni' lyaa, lo'o ne' escriba, ntsu'hui cha' xcuan tloo ne' 'in ñi, lo' cujui ne' 'in ñi, una nu cua' ca snan tsaan ntsu'hui cha' tyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mtsa' la ñi 'in yu cha' can'. Una yu Tyo ngulo tso' yu 'in ñi, lo' mdyisnan ngusun lo'o yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Una Jesús mxina'an ñi se'en ndon nchgaa la ña'an yu ta'a nda'an ñi, lo' ngusun lo'o ñi 'in yu Tyo can': Laxa'an, tyi'o tso' siin', si'yana a nda'an lo'o cha' tiyaa 'in Ndiose, cui' ca nu nda'an lo'o cha' tiyaa 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Xacan' msi'ya ñi 'in yu ta'a nda'an ñi tsatlyu lo'o nten can', lo' juin ñi: Cha' ta nde'en nu nchca ti' chcui ncha'an 'ñan, 'ni cha' jlya ti' 'in ticuii', lo' nu chcui ncha'an 'ñan, tyaa can' 'in siya' ti. ");
INSERT INTO cya_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Lo' nchgaa nu ñan ti' culo laa 'in ticuii', tsato'o quinan' can', una nchgaa nu tyaa 'in si'ya cha' 'ñan, lo'o si'ya cha' tsu'hue 'in Ndiose, can' nu tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Si'yana, ¿ñi canan chu'hui 'in ne' cu'ni 'in ne' ña'aan chendyu, lo' nde quinan' cusya 'in ne'? ");
INSERT INTO cya_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ñi na tca cu'ni ne' nu ti' chcuan ne' cusya 'in ne' xiya'? ");
INSERT INTO cya_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cha' nde'en nu xijyi'o ti' lo'on tloo nten nducun' re, ne' qui'ya chendyu, a cunta cha' xijyi'o ti' lo'o cha' nu nchcuin', lo'on nan', Yu Qui'yu nu Mdo'o nde ni' Cuaan, xijyi'o tin' lo'o can' xa yaan xiya' lo'o cha' cuiya' 'in Stin, lo'o angujle nu luhui 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Lo' ti' ycui' la ñi lo'o yu: Nu cha' ñi cunen lo'o um, ntsu'hui nu ndon re a caja cha' si'i culo nducua la ña'an sca cha' cuiya' nu tlyu 'in Ndiose ña'an ntsu'hui cha' culo ñi tñan. ");
INSERT INTO cya_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Xa cua' mda'a scua tsaan can', mdo'o lo'o Jesús 'in yu Tyo, yu Jacobo, lo'o yu Xuhua, sca loo qui'ya cuaan se'en ycui' ti jun, can' tloo na'an yu mcha'an ña'an ñi. ");
INSERT INTO cya_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ste' ñi nguinu nduhui mten tsu'hue ña'an na, ñi te' nu tsu'hue lati nguiten, lo' a nchcua na ña'an mten ste' ñi. ");
INSERT INTO cya_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tloo na'an yu ngu'ya ton yu ncua naan Elía lo'o Moisé, lo' ndaa jun cha' lo'o Jesús. ");
INSERT INTO cya_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Xacan' juin yu Tyo 'in Jesús: Ñi Bstro, tsu'hue 'a si'yana ndi'in hua re, nde tñan hua snan quisin, sca na tyi'in um, xca na tyi'in Moisé, lo' xca na tyi'in Elía. ");
INSERT INTO cya_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ñi a ngujlyo 'a ti' yu, ñi cha' chcui' yu si'yana scaña'an ti ndi'in ytsen yu. ");
INSERT INTO cya_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Xacan' ngu'ya ti'in coo lo' ngo'o yu'hui na se'en ndon jun, lo' ni' coo can' ngune ycui' sca nu ycui': Nde Sñen' nu ta'a lati 'ñan, quine 'in um cha' nu chcui'. ");
INSERT INTO cya_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Xa mxina'an yu a tucui 'a nu ncua chcan', xca ti Jesús ti' ndon ñi. ");
INSERT INTO cya_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Xa cua' mdo'o jun loo qui'ya can' yaan jun, ngulo ñi tñan 'in yu si'yana a chcui' yu lo'o ñi sca tucui cha' nu na'an yu, cui' ca nu xa cua' mdyiqui'o Yu Qui'yu nu Mdo'o nde ni' Cuaan la xacan' tca chcui' yu cha' re. ");
INSERT INTO cya_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yu'hui cunan cha' re ni' cusya 'in yu, lo' scasca yu ñicha' ta'a yu, cha' ña'an ntsu'hui cha' tyiqui'o ne' cua' ngujui. ");
INSERT INTO cya_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mñicha' yu 'in ñi: ¿Ñi cha' ta nchcui' ne' escriba, si'yana yu nu ncua naan Elía ntsu'hui cha' caan yu culo nducua la loo chendyu re? ");
INSERT INTO cya_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mxcuen ñi 'in yu: Cha' ñi si'yana Elía ntsu'hui cha' caan culo nducua la, cui' yu ntsu'hui cha' cu'ni chu'hue yu nchgaa loo cha'. ¿Ñi cha' ta nchcui' quityi 'in Ndiose si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan ntsu'hui cha' tyijyin ñi nu ti'i, lo' caja nu cu'ni lyi'o 'tnan 'in ñi? ");
INSERT INTO cya_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Una cunen lo'o um si'yana yu Elía cua' yaan yu, lo' jui nu m'ni lyi'o 'in yu tsaña'an nu ncua ti' ne', cui' cha' nu cua' nguinu scua cha' 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Xa nguila jun se'en ndi'in nchgaa la ña'an yu ta'a nda'an ñi, na'an ñi si'yana qui'an 'a nten msu'hua lo'o 'in yu, lo' na'an ñi si'yana ne' escriba lyee nchcui' tyijyin ne' lo'o yu. ");
INSERT INTO cya_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nchgaa nten can' yuhue 'a ti' ne' 'in ñi xa nguila ñi, ndla ndsa ti ya ycui' cha' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mñicha' ñi 'in yu ta'a nda'an ñi: ¿Ñi cha' si'ya nchcui' tyijyin um lo'o nten re? ");
INSERT INTO cya_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lja can' ndon sca nu ycui' lo'o Jesús: 'Un ñi nu lca Bstro, nde ljyan lo'on sñen' nu ntsu'hui cui'in xa'an 'in, lo' mxnu cu'un na 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","La ña'an ti ndon yu nxñi cui'in 'in yu, nxitlyu na 'in yu, nchcua ngoo' tu'hua yu, nchcu lyi'ya yu, lo' nguia nguityi yu. Cua' ycuin' lo'o yu ta'a nda'an um, si'yana culo yu cui'in xa'an ntsu'hui 'in sñen', lo' a ncua 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Xacan' juin Jesús: 'Un lca um ne' nu a ndiya qui'an ti', ¿tsala ta xaa cui' ti 'ñan nducua tloo um? ¿Tsala ta xaa ntsu'hui cha' ta loon 'in um? Quian lo'o um 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xacan' mdiya lo'o ne' 'in yu lyo' ti can' se'en ndon ñi, una xa na'an cui'in xa'an can' 'in Jesús, lyee lati msñi na 'in yu tsaya' mxitlyu na 'in yu, mxita yuu na 'in yu, lo' mducua ngoo' tu'hua yu. ");
INSERT INTO cya_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mñicha' Jesús 'in sti yu: ¿Ti' ñi xaa nchca 'in yu cuaña'an? Mxcuen yu 'in ñi: Ti' lyo' yu. ");
INSERT INTO cya_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lyee 'a nxitlyu su'hua na 'in yu loo quii' lo'o loo tyi'a, nu nchca ti' na cujui na 'in yu. Cha' 'un nde'en la ña'an tca cu'ni um, ña'an 'tnan ti' um 'in hua lo' ta yaa' um 'in hua lo'o yu. ");
INSERT INTO cya_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Xacan' juin Jesús 'in yu: Cha' 'un tsa qui'an ti' um 'in Ndiose nchgaa cha' tca, si'yana a sca cha' tucui 'in nu ndiya qui'an ti' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Cui' xaa ycui' cueen sti yu: Ndiya qui'an tin', una tya yaa' um 'ñan si'yana lyee la tsa qui'an tin'. ");
INSERT INTO cya_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Xa na'an Jesús si'yana lyee nguilo ti'in nten can', ngusun lo'o ñi 'in cui'in xa'an can': Cui'in, nu'huin nu mxnu cu'un 'in yu re, nan' culon tñan 'in si'yana tyi'o, lo' a xitucui 'a. ");
INSERT INTO cya_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Cui' ña'an lcaa msi'ya yja yu, mscuin ti'in na 'in yu lo'o juesa xa mdyi'o na 'in yu, ngula' sti na 'in yu ña'an nchca ti' sca nu ngujui. Scasca ne' nchcui' ne' si'yana cua' ngujui yu. ");
INSERT INTO cya_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Una Jesús msñi ñi yaa' yu lo' mxiton ñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Xa cua' yten Jesús ña'an, yu ta'a nda'an ñi mñicha' yu 'in ñi sca cunta: ¿Ñi cha' huare' a ncua 'in hua culo hua cui'in xa'an cua? ");
INSERT INTO cya_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lo' juin ñi 'in yu: Sca cui'in nu cuaña'an a ndyijyi ña'an tyi'o can', cha' si'i culo nducua chcui' lyi'o na 'in Ndiose lo' cu'ni na ayuna. ");
INSERT INTO cya_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Xacan' mdo'o jun nguiaa jun se'en lca Galilea, lo' Jesús ncua ti' ñi si'yana a tucui nu ca jlyo ti' la tucueen nguiaa jun, ");
INSERT INTO cya_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","si'yana ndlo'o ñi 'in yu ta'a nda'an ñi, lo' nchcui' ñi: Nan', Yu Qui'yu nu Mdo'o nde ni' Cuaan, caja nu tyaa 'ñan tuyaa' nten chendyu nu cujui 'ñan, una nu cua' ca snan tsaan tyiqui'on. ");
INSERT INTO cya_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yu ta'a nda'an ñi a ngu'ya yu cha' tiyaa cha' nu ycui' ñi, lo' a msti ti' yu ñicha' yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xa nguila jun quichen Capernaum, lo' xa cua' ndi'in jun ña'an, mñicha' ñi 'in yu ta'a nda'an ñi: ¿Ñi na si'ya lyee 'a ljyan ycui' tyijyin um tucueen? ");
INSERT INTO cya_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A mxcuen 'a yu 'in ñi, si'yana jyi'o ti' yu ña'an ljyan ycui' yu, cha' ti ña'an yu lca yu nu ndon loo lati. ");
INSERT INTO cya_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Xacan' yten tucua ñi lo' msi'ya ñi 'in ta'a tichcua yu, lo' juin ñi: Cha' nde'en nu nchca ti' ca nu culoo, can' nu qui'ni ca'an 'in la chon', lo' ca nguso 'in nchgaa la tucui. ");
INSERT INTO cya_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Xacan' msi'ya ñi 'in sca nu lyo' ti, lo' mdi'in tyaa ñi 'in tlu'hue la se'en nducua jun, msu'hua tuscun ñi 'in, lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Cha' ntsu'hui nu nducuan xu'hue 'in sca nu lyo' ti ña'an nu re, si'ya cha' 'ñan, cu'ni can' cunta si'yana 'ñan nducuan xu'hue, lo' nu nducuan xu'hue 'ñan, si'i tsa 'ñan tin nducuan xu'hue can', cui' ca nu 'in ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yu Xuhua can' juin 'in ñi: 'Un ñi nu lca Bstro, se'en yaa hua na'an hua sca yu nu ndlo cui'in xa'an lo'o cha' cuiya' 'in um, una si'yana si'i ta'a nda'an yu 'in na, a mdaa hua cha' cuiya' ti' cu'ni yu cuaña'an. ");
INSERT INTO cya_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Una Jesús juin ñi: A ca'a um cu'ni yu cuaña'an, a tucui nu tca cu'ni cha' nu tnu lo'o cha' cuiya' 'ñan, lo' nde chcui' ca'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Si'yana nu a ti'i ti' 'in na, cui' tso' 'in na nguiaa can'. ");
INSERT INTO cya_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ña'an tucui ti nu taa siya' sca vaso ti tyi'a co'o um, si'ya cha' 'ñan lo' si'yana nguiaa um tso' 'in Cristo, nu cha' ñi cunen lo'o um, a quinan' xu'hue can'. ");
INSERT INTO cya_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Cha' nde'en nu xityu 'in sca nu lyo' ti re loo qui'ya, nu ndiya qui'an ti' 'ñan, tsu'hue lati yni can' scan' tucui sca quee tlyu nu ndiyo ne' trigo, lo' cuun ne' 'in loo tyi'a tujo'o. ");
INSERT INTO cya_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Cha' si'ya yaa' um cu'ni um qui'ya, si'yu co' um 'in na, tsu'hue lati cha' co' yaa' um sten um chendyu nu a tsatii 'a, lo' si'i nu chcuaa tso' yaa' um tsaa um loo quii' nu a ntsu'hui 'a cha' tyuhui', ");
INSERT INTO cya_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","—sca se'en nu a ntsu'hui cha' tyi ycu cunu' 'in, lo' ñi quii' a ntsu'hui 'a cha' ti' tyuhui'—. ");
INSERT INTO cya_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Cha' si'ya quiya' um cu'ni um qui'ya, si'yu co' um 'in na, tsu'hue lati cha' co' quiya' um sten um chendyu nu a tsatii 'a, lo' si'i nu chcuaa tso' quiya' um caja nu xityu 'in um loo quii' nu a ntsu'hui 'a cha' tyuhui', ");
INSERT INTO cya_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","—sca se'en nu a ntsu'hui cha' tyi ycu cunu' 'in, lo' ñi quii' a ntsu'hui 'a cha' tyuhui'—. ");
INSERT INTO cya_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Cha' si'ya quiloo um cu'ni um qui'ya, culo um 'in na, tsu'hue lati cha' sca tso' ti quiloo um sten um se'en ndlo Ndiose tñan, lo' si'i nu chcuaa tso' quiloo um caja nu xityu 'in um loo quii', ");
INSERT INTO cya_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","—sca se'en nu a ntsu'hui cha' tyi ycu cunu' 'in, lo' ñi quii' lo' a ntsu'hui 'a cha' tyuhui'—. ");
INSERT INTO cya_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Si'yana cunda scaa um ntsu'hui cha' ca tiyen' um lo'o quii', lo' nchgaa 'ni nu tiquin tucua ne' tloo Ndiose ca tiyen' na lo'o teje'. ");
INSERT INTO cya_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Teje' tsu'hue 'a na, una cha' tyi'o tiyen' 'in na, ¿ña'an ta tca ca tiyen' na xiya'? Can' cha' 'un taa um ya' ca tiyen' um, lo' ndyi'ya ti tyi'in um scasca um. ");
INSERT INTO cya_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mdo'o Jesús nguiaa ñi, lo' mdiyaa ñi se'en lca Judea, xacan' mdo'o ca'an ñi xca tso' chco tlyu Jordan. Ticui' ti ña'an nguio' ti'in nten se'en mdiyaa ñi, lo' xiya' ngulo'o ñi 'in ne' si'yana cuaña'an ntsu'hui cha' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tucua snan ne' fariseo mdiyaa ne' se'en ndon Jesús, sca cha' can' ti 'in ne' mñicha' ne' 'in ñi: ¿Ta ntsu'hui cha' cuiya' 'in yu qui'yu cula' ti'in yu cuilyi'o yu? ");
INSERT INTO cya_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mxcuen ñi 'in ne': ¿Ña'an ta ngulo Moisé tñan 'in um? ");
INSERT INTO cya_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Lo' juin ne' 'in ñi: Yu Moisé mdaa cha' cuiya' 'in yu qui'yu cula' ti'in yu cuilyi'o yu, una cha' tsa' scua sca quityi 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Lo' juin Jesús 'in ne': Mdaa yu cha' cuiya' can', una si'ya cha' lye' ti' 'in um. ");
INSERT INTO cya_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Una culoo xa mtñan Ndiose chendyu, —qui'yu lo' cuna'an mtñan ñi. ");
INSERT INTO cya_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Can' cha' yu qui'yu ntsu'hui cha' tyi'o tso' yu sii' sti yu lo'o jyi'an yu, lo' tyi'in yu lo'o cuilyi'o yu, ");
INSERT INTO cya_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","lo' chcuaa can' sca tucui ti lca—, cua' si'i 'a tucua lca can', cui' ca nu scati lca. ");
INSERT INTO cya_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Can' cha' nu cua' m'ni sca Ndiose 'in, a ntsu'hui 'a cha' ti' cula' ti'in ta'a. ");
INSERT INTO cya_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Xa cua' mdiyaa jun ña'an, yu ta'a nda'an ñi mñicha' yu 'in ñi si'ya cha' can'. ");
INSERT INTO cya_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mxcuen ñi 'in yu: Yu nu ndla' ti'in 'in cuilyi'o, lo' tyi'in yu lo'o xca ne' cuna'an, qui'ya ngui'ni yu tloo cuilyi'o ca yu. ");
INSERT INTO cya_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ticui' cuaña'an sca ne' cuna'an nu ndla' ti'in 'in cuilyi'o, lo' tyi'in ne' lo'o xca yu qui'yu, ticui' qui'ya ngui'ni ne'. ");
INSERT INTO cya_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Xacan' mdiyan lo'o ne' 'in nu suhue ti se'en nducua Jesús, si'yana tyi'in tyaa ñi yaa' ñi que, una yu ta'a nda'an ñi ngusun lo'o yu 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Xa na'an Jesús cha' can', a mdyaa ti' ñi lo' ngusun lo'o ñi 'in yu, lo' juin ñi: Tyaa um ya' caan nu suhue ti se'en nducuan, lo' a chcui ndijin um, si'yana nchgaa nu cu'ni lyo' 'in ña'an nu suhue ti re, can' nu qui'ni ca'an 'in se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nu cha' ñi cunen lo'o um: Sca nten cha' a cuan xu'hue ne' 'in Ndiose tsaña'an nguiaa cha' 'in nu suhue ti, a tca sten ne' se'en ndlo ñi tñan. ");
INSERT INTO cya_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Xacan' msu'hua tuscun ñi 'in nu suhue ti can', mdi'in tyaa ñi yaa' ñi que, lo' ncuan ñi 'in. ");
INSERT INTO cya_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Xa mdo'o Jesús nguiaa ñi, carre ti mdo'o sca yu nu yan ycua 'in ñi, mdyi'ya xtyin' yu tloo ñi, lo' mñicha' yu 'in ñi: 'Un ñi nu lca Bstro, lca um sca nu tsu'hue 'a, ¿ñi na tca cu'nin si'yana caja chendyu nu a tsatii 'a 'ñan? ");
INSERT INTO cya_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mxcuen Jesús 'in yu: ¿Ñi cha' nchcui' si'yana lcan sca nten nu tsu'hue? A tucui nu tsu'hue, scati Ndiose tsu'hue ñi. ");
INSERT INTO cya_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Cua' jlyo ti' ña'an tñan ngulo Ndiose: —A sten yu'hui um lo'o cuilyi'o nten, a cujui um nten, a cu'ni um cunan, a chcui' um cha' cuiñi—, ñi a cuñilyi'o um nten, —cu'ni suun um 'in um tloo sti um lo'o jyi'an um—. ");
INSERT INTO cya_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Xacan' mxcuen yu 'in ñi: Ñi Bstro, ti' lyon' nxu'huan se'en nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús mxina'an ñi tloo yu lo' mña'an 'tnan ti' ñi 'in yu, lo' juin ñi: Ndiyaa lyijyi xca cha' 'in, quiaa lo' cujui' nchgaa na nu ndi'in 'in lo' cutsa tñi can' 'in nu ti'i, cuaña'an caja cha' cuilyiya' 'in la ni' cuaan, xacan' chcui ncha'an 'ñan, siya' ti tyaa 'in si'ya cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ndyijyin ya' ngulu'un ti' yu nguiaa yu si'ya cha' nu ycui' ñi lo'o yu, si'yana lyee cuilyiya' yu. ");
INSERT INTO cya_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Xacan' tyi'iin mxina'an Jesús, lo' juin ñi 'in yu ta'a nda'an ñi: Tucui 'a ña'an sten sca yu cuilyiya' se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yu ta'a nda'an ñi lyee 'a yuhue ti' yu si'ya cha' nu ycui' ñi, una Jesús ycui' ñi xiya': Sñen', sca nten nu nchcui ti' cha' cuilyiya', tucui 'a ña'an sten can' se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Cuti la tyijyin sca camello quito quiya' cuxa, que ña'an nu sten sca yu cuilyiya' se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yu ta'a nda'an ñi lyee la yuhue ti' yu, lo' scasca yu ñicha' ta'a yu: ¿Ti nu tca tyi'o laa cha' na can'? ");
INSERT INTO cya_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mxina'an Jesús se'en ndi'in yu, lo' juin ñi: Cha' nu 'in nten, a ndyijyi ña'an na, una lo'o tso' 'in Ndiose nchgaa cha' tca. ");
INSERT INTO cya_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yu Tyo mdyisnan ycui' yu lo'o ñi: Una huare' cua' ngula' ti'in hua nchgaa na nu ndi'in 'in hua, lo' ljyan ncha'an hua 'in um. ");
INSERT INTO cya_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mxcuen Jesús 'in yu: Nu cha' ñi cunen lo'o um, cha' nde'en nu xnu tucua na'an 'in, uta xnu ti'in ta'a ngula, uta 'in sti lo'o jyi'an, uta 'in cuilyi'o, uta sñe', lo' ta cula' sti yuu se'en n'ni tñan, lo' nu cu'ni cuaña'an si'ya cha' 'ñan, lo'o si'ya cha' tsu'hue nu nchcui' Ndiose, ");
INSERT INTO cya_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nde lyee lati caja cha' tsu'hue 'in loo chendyu re: Nde quinu na'an 'in can', cuaña'an lo'o ta'a ngula, lo'o jyi'an, lo'o sñe', lo'o yuu, a cunta lo'o scasca nu ti'i tyijyin can', una tiyaa xaa caja chendyu nu a tsatii 'a 'in. ");
INSERT INTO cya_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Si'yana qui'an 'a nu culoo cua' ñii, quinu ca'an chon' tiyaa xaa, lo' nu nguinu ca'an chon', ca nu culoo tiyaa xaa. ");
INSERT INTO cya_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yato'o nguiaa jun tucueen Jerusalén, lo' nducua loo Jesús loo yu ta'a nda'an ñi, ntsu'hui cha' tiquee yu, a cunta nguitsen yu, cui' cuaña'an lo'o nchgaa la ña'an nu nchcui ncha'an 'in ñi. Xiya' ngulo tso' Jesús 'in ta'a tichcua yu can' se'en ycui' ti jun, lo' mdyisnan mtsa' ñi 'in yu ña'an ntsu'hui cha' tsato'o 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Lo' juin ñi: Ña'an jan ñi, cua' ñii tiyaa na quichen Jerusalén, lo' Yu Qui'yu nu Mdo'o nde ni' Cuaan ntsu'hui cha' quinu ñi tuyaa' yu nu ndlo ca tñan ni' lyaa, lo'o tuyaa' ne' escriba, can' nu culo qui'ya 'in ñi se'en nu caja ñi, lo' tyaa ne' 'in ñi tuyaa' ne' gentil. ");
INSERT INTO cya_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Can' nu taa cha' jyi'o 'in ñi, jyi'in 'in ñi, su'hua siye' ne' tloo ñi, lo' cujui ne' 'in ñi, una nu cua' ca snan tsaan tyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Xacan' yu Jacobo lo'o yu Xuhua, sñe' Zebedeo, mdiyaa yu cui' ti se'en ndon Jesús, lo' juin yu: 'Un ñi nu lca Bstro, nchca ti' hua cu'ni um sca cha' tsu'hue lo'o hua. ");
INSERT INTO cya_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Lo' juin ñi 'in yu: ¿Ñi na ta nchca ti' um? ");
INSERT INTO cya_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mxcuen yu 'in ñi: Nchca ti' hua cha' taa um cha' cuiya' chcua hua scaa tso' sii' um la se'en ntsu'hui cha' culo um tñan. ");
INSERT INTO cya_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Xacan' juin Jesús 'in yu: A jlyo ti' um ñi na jñan um. Vaso nu ntsu'hui cha' co'on, ¿ta tca co'o um 'in na? ¿Ta tca tyijyin um nu ti'i tsaña'an nu ntsu'hui cha' tijin? ");
INSERT INTO cya_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mxcuen yu 'in ñi: Tca 'in hua. Juin Jesús 'in yu: Cha' ñi ña'an nchcui' um si'yana sca vaso ti co'o um lo'on, ticui' sca nu ti'i ti ntsu'hui cha' tyijyin um lo'on. ");
INSERT INTO cya_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Una nu chcua um tso' cueen 'ñan lo'o tso' ca, a ntsu'hui cha' cuiya' 'ñan taan 'in um, si'yana can' chcua nu cua' ngua'an cuiya' 'in. ");
INSERT INTO cya_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cha tii yu can' ycuen tique' yu lo'o yu Jacobo lo'o yu Xuhua, xa ngune 'in yu cha' nu ycui' yu can'. ");
INSERT INTO cya_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Una Jesús msi'ya ñi 'in nchgaa yu: 'Un cua' jlyo ti' um si'yana tsalca yu nu ndlo tñan quichen tnu, lo'o cha' cuiya' 'in yu n'ni x'nan ne' 'in yu, lo' yu nu ndon loo 'in yu, tla 'a ndlo yu tñan 'in nten can'. ");
INSERT INTO cya_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Una si'i cuaña'an ntsu'hui cha' cu'ni um, cui' ca nu cha' nde'en um nchca ti' um ca um nu ndon loo lati, can' nu tucua tloo nchgaa tucui. ");
INSERT INTO cya_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cha' nde'en nu nchca ti' ca nu culoo, can' nu ca nguso 'in nchgaa tucui. ");
INSERT INTO cya_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yu Qui'yu nu Mdo'o nde ni' Cuaan, a ljyaan ñi ta si'yana caja nu ca nguso 'in ñi, cui' ca nu si'yana ca ñi nguso 'in nchgaa tucui, lo' taa ñi chendyu 'in ñi si'yana tyi'o laa qui'an nten. ");
INSERT INTO cya_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Xacan' mdiyaa jun quichen Jericó. Xa nde cua' mdo'o Jesús tu'hua quichen lo'o yu ta'a nda'an ñi, qui'an nten nducui ncha'an 'in jun, lo' tu'hua tucueen can' nducua sca yu cuityin' naan Bartimeo, sñe' yu Timeo, njñan yu lcuan. ");
INSERT INTO cya_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Xa ynan yu cha' si'yana Jesús Nazaret ndijin can', xacan' msi'ya cueen yu 'in ñi: Jesús, Sñe' ta nten 'in Davi, ña'an 'tnan ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Scasca ne' ngusun lo'o ne' 'in yu si'yana chcua seen tu'hua yu, una nde lyee la msi'ya yu 'in ñi: Sñe' ta nten 'in Davi, ña'an 'tnan ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Xacan' ycan' ton Jesús, lo' ngulo ñi tñan si'yana xi'ya ne' 'in yu cuityin' can'. Msi'ya ne' 'in yu, lo' juin ne': Cu'ni tnu tiquee, tyiton si'yana nxi'ya ñi 'in. ");
INSERT INTO cya_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yu cuityin' can' cui' xaa ngula' sti yu te' nguixen yu, mdyiton yu, lo' mdiyaa yu tloo Jesús. ");
INSERT INTO cya_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Lo' juin Jesús 'in yu: ¿Ñi na nchca ti' cu'nin lo'o? Yu cuityin' can' mxcuen yu 'in ñi: 'Un ñi nu lca Bstro, nchca tin' quila xaa quiloon. ");
INSERT INTO cya_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús juin 'in yu: Tca quiaa, cua' mchca si'yana ya qui'an ti' 'ñan. Ticui' xaa nguila xaa quiloo yu, lo' mducui ncha'an yu 'in Jesús se'en nguiaa ñi. ");
INSERT INTO cya_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Xa cua' tiyaa jun quichen Jerusalén, cui' ti can' ndi'in tucua quichen suhue ti, Betfagé lo'o Betania, lo' chcua can' nducua qui'ya Olivo, lo' Jesús ngulo ñi tñan 'in tucua yu ta'a nda'an ñi, ");
INSERT INTO cya_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","lo' juin ñi 'in yu: Yaa um se'en ndi'in quichen lyo' ti cua. Xa tiyaa um tu'hua quichen cua, can' nchcan' ton sca burru cune' ti nu a nchca tucui chcua. Xtin' um 'in 'in, lo' quian lo'o um 'in 'in. ");
INSERT INTO cya_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Cha' nde'en nu cuñicha' 'in um ñicha' nxtin' um 'in 'in, xacan' ljuin um 'in ne' si'yana ñi nu lca X'nan um nchca ti' 'in 'in, lo' cui' xaa ti ca'an tñan ñi 'in 'in. ");
INSERT INTO cya_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mdo'o yu nguiaa yu, lo' nguija lyoo yu burru can', nchcan' ca'an 'in tu'hua tucueen tuna'an lyiya', lo' mxtin' yu 'in 'in. ");
INSERT INTO cya_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Cui' xaa ycui' tucua snan nu ndon can': ¿Ñi cha' nxtin' um burru cua? ");
INSERT INTO cya_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Xacan' mtsa' yu 'in ne' ña'an juin Jesús, la xacan' mdaa ne' cha' cuiya' 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nguian lo'o yu burru can' se'en ndon Jesús, lo' mdi'in tyaa yu ste' yu chon' 'in, lo' mducua ñi 'in 'in. ");
INSERT INTO cya_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Qui'an 'a nten mdyisnan msla sti ne' ste' ne' tucueen nguiaa ñi, a cunta ntsu'hui nu mcha stan' quixin', lo' mdi'in tyaa ne' 'in na tucueen can'. ");
INSERT INTO cya_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nten nu nducua loo lo'o nu ljyaan nde chon' nchcui' cueen ne': ¡—Culo laa um 'in hua! Tlyu cha' tsu'hue ntsu'hui 'in ñi nu ljyaan lo'o cha' cuiya' 'in Ñi X'nan na—. ");
INSERT INTO cya_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tlyu cha' tsu'hue ntsu'hui 'in ñi nu ljyaan lo'o cha' cuiya' 'in Davi nu ncua nten cula 'in na. ¡—Culo laa um 'in hua—, 'un ñi nu nducua ni' cuaan! ");
INSERT INTO cya_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xacan' yten Jesús loo quichen Jerusalén, lo' yten ñi ni' lyaa, m'ni quii ñi ña'aan ni' lyaa can'. Lo' si'yana cua' msiin tsaan mxitucui ñi nde quichen Betania lo'o ta'a tichcua yu. ");
INSERT INTO cya_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Xca tsaan can' mdo'o jun quichen Betania, lo' tucueen nguiaa jun ngute' ti' Jesús. ");
INSERT INTO cya_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ti' tijyo' nguiaa ñi na'an ñi nducua sca yca higo nu nducua lca', ya na'an ñi cha' lyi'yu mti na. Una xa mdiyaa ñi se'en nducua na, a sca na lyi'yu loo na si'yana si'i tsaan 'in na, cui' ca nu lca' ti na nducua. ");
INSERT INTO cya_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Xacan' juin Jesús 'in yca can': Ñi xca tsaan lo' a caja 'a nu cu mti nu cui'yu loo. Yu ta'a nda'an ñi ngune 'in yu cha' nu ycui' ñi. ");
INSERT INTO cya_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Xa mdiyaa jun quichen Jerusalén yten Jesús ni' lyaa, lo' mdyisnan nguloo ñi 'in nchgaa nu ngui'ni quiya' can'. Mxiquilyu ñi msa 'in yu nu nxitsa'an tñi, lo'o yca xlya 'in nu ndyujui' quiñi. ");
INSERT INTO cya_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A mdaa 'a ñi cha' cuiya' ti' tyijyin ne' ni' lyaa lo'o su'hua ne'. ");
INSERT INTO cya_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ngulo'o ñi 'in nten lo' juin ñi: ¿Ta si'i quityi 'in Ndiose nchcui' na: —Na'an 'ñan lca na se'en nchcui' lyi'o sca chcui chendyu 'ñan—? Lo' 'un ngui'ni um 'in na lca na —na'an tyi yu cunan—. ");
INSERT INTO cya_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yu nu ndlo tñan ni' lyaa lo'o ne' escriba, ngune 'in yu cha' nu ycui' Jesús, lo' nan yu ña'an nu cujui yu 'in ñi, si'yana qui'an 'a nten cua' ngui'ni cunta cha' nu ndlo'o ñi, can' cha' nguitsen yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Xa ngu'ya tla mdo'o Jesús quichen can'. ");
INSERT INTO cya_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tlya xca tsaan mdijin jun se'en nducua yca higo can', lo' na'an jun si'yana cua' ngutyi na. ");
INSERT INTO cya_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yu Tyo nguia yu'hui ti' yu ña'an ycui' Jesús lo'o yca can', lo' juin yu 'in ñi: Ñi Bstro, ña'an um jan ñi, ña'an ti ngutyi yca nu ngulo um yuhue' 'in cua. ");
INSERT INTO cya_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mxcuen Jesús 'in yu ta'a nda'an ñi: Tsa qui'an ti' um 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nu cha' ñi cunen lo'o um, cha' nde'en nu chcui' lo'o qui'ya cua si'yana tyi'o na se'en nducua na, lo' tsa yu'hui na la loo tyi'a tujo'o, cui' cuaña'an tsato'o, una la cha' tsa qui'an ti' can', lo' a cu'ni tucua ti'. ");
INSERT INTO cya_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Cunen lo'o um, nchgaa cha' nu njñan um 'in Ndiose, cu'ni um cunta si'yana cua' jui na 'in um, lo' cui' cuaña'an tsato'o. ");
INSERT INTO cya_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Xa nchcui' lyi'o um 'in ñi, cu'ni um cha' tlyu ti' 'in nu ntsu'hui cha' tiquee um lo'o, ña'an ca si'yana lo'o Ndiose, ñi nu nducua ni' cuaan, cu'ni ñi cha' tlyu ti' 'in um si'ya qui'ya nducui um. ");
INSERT INTO cya_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Cha' a cu'ni um cha' tlyu ti' 'in ta'a nten um, cui' cuaña'an Ndiose, ñi nu nducua ni' cuaan, a cu'ni ñi cha' tlyu ti' 'in um si'ya qui'ya nducui um. ");
INSERT INTO cya_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xiya' mdiyaa jun quichen Jerusalén, lo' yten Jesús ni' lyaa, can' nguilyu ñi xa mdiyaa tucua snan yu nu ndlo tñan ni' lyaa, tsatlyu lo'o ne' escriba, lo'o qui'yu cula. ");
INSERT INTO cya_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Lo' juin ne' 'in ñi: ¿La jui cha' cuiya' 'in nu ngui'ni nchgaa cha' re, lo' ti nu mdaa 'in na? ");
INSERT INTO cya_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mxcuen Jesús 'in yu: Lo'on nan' cuñichan' 'in um sca cha', xcuen um 'ñan, lo' quitsan' 'in um ti nu mdaa cha' cuiya' ngui'nin nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ti nu mdaa cha' cuiya' 'in yu Xuhua nu mducua tya 'in nten, Ndiose uta nten chendyu? Xcuen um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xacan' scasca ne' mñicha' ta'a ne': Cha' ljuin na ni' cuaan mdo'o cha' cuiya' can', tina'an xcuen yu 'in na: ¿Ñi cha' a ya qui'an ti' um 'in yu cha' na can'? ");
INSERT INTO cya_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Cha' ljuin na si'yana nten chendyu mdaa 'in na... Una nguitsen ne' tloo nten quichen can', si'yana nchgaa ne' mda ne' loo yu Xuhua, ncua yu sca nu cha' ñi ca mxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Can' cha' mxcuen ne' 'in Jesús: A jlyo ti' hua. Xacan' mxcuen Jesús 'in ne': Ñi nan' a quitsan' 'in um ti nu mdaa cha' cuiya' ngui'nin nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Xacan' mdyisnan ycui' Jesús scasca cha' lo'o nten, lo' juin ñi: Sca yu qui'yu msu'hua lo'o yu se'en nducua ti uva 'in yu. Ni' lyi'o can' mtñan yu sca se'en xiin' uva can'. A cunta mtñan yu sca se'en cuaan, chcua nu chu'hui cunta 'in na, lo' cunda tlu'hue mxnu yu tñan can' 'in yu nu chu'hui cunta 'in na, mdo'o yu nguiaa yu sca se'en tijyo'. ");
INSERT INTO cya_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mdiyaa xaa nu ntsu'hui cha' quio' mti can', x'nan tñan can' ngua'an tñan yu sca nguso nu tsa chcuan cunta 'in mti nu ntsu'hui cha' qui'ni ca'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Una yu nu ntsu'hui cunta tñan can' yjui ti'in yu 'in nguso nu mdiyaa can', lo' mxitucui yu lo' a sca na ngu'ya yu. ");
INSERT INTO cya_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Xacan' ngua'an tñan x'nan tñan can' xca nguso 'in yu, can' nu mjyi'in yu 'in lo'o quee, yjui yuhua' yu que, cua' ña'an ti m'ni lyi'o yu 'in. ");
INSERT INTO cya_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xiya' ngua'an tñan yu xca nguso 'in yu, can' nu yjui yu 'in. Cuaña'an yato'o lo'o nchgaa la ña'an nguso nu yaa can', ntsu'hui nu yjui yuhua' yu, lo' ntsu'hui nu yjui yu 'in. ");
INSERT INTO cya_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ndi'in scati sñe' x'nan tñan can' nu ta'a la ti' 'in yu, lo' ngua'an tñan yu 'in yaa se'en ndi'in tñan 'in yu. Ñan ti' yu: Ñii ca'an tñan 'in ycui' ca sñe', nde nu cu'ni cunta yu cha' nu chcui'. ");
INSERT INTO cya_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Una yu nu ntsu'hui cunta tñan can', mdyisnan m'ni cuiya' yu cha' lo'o ta'a yu, lo' nchcui' yu: Nde ljyaan ycui' ca sñe' x'nan tñan nu ntsu'hui cha' quinu tñan re 'in, cujui na 'in yu lo' quinu tñan re 'in na. ");
INSERT INTO cya_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Cui' ña'an lcaa msñi yu 'in lo' yjui yu 'in, mscuan yu 'in nde chon' lo'o. ");
INSERT INTO cya_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Cua' ñii jan ñi, ¿ña'an ta cu'ni x'nan tñan can'? Cui' ca nu tsa yjui yu 'in yu nu ntsu'hui cunta tñan can', lo' taa yu 'in na cu'ni cunta xca tucui. ");
INSERT INTO cya_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ta a nchca chcui' um sca cha' nu nguinu scua loo quityi 'in Ndiose: —Quee nu mscuan tloo yu cuityi na'an, cua' ñii lca na quee nu nsñi ton 'in na'an. ");
INSERT INTO cya_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ñi X'nan na m'ni ñi cha' re, lo' nduhue ti' na cha' nu na'an tloo na—? ");
INSERT INTO cya_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ngunan ne' ña'an quinu Jesús si'yana ngu'ya ne' cha' tiyaa, cha' 'in ne' ca ycui' ñi. Lo' si'yana nguitsen ne' tloo nten qui'an can', ngula' ton ne' 'in ñi, mdo'o ne' nguiaa ne'. ");
INSERT INTO cya_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Xacan' ngua'an tñan ne' tucua snan ne' fariseo, lo'o chcua xnan nten 'in ree Herode nu tsa ycui' lo'o Jesús, lo' cunan ne' ña'an nu su'hua ne' qui'ya chon' ñi. ");
INSERT INTO cya_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Xa mdiyaa ne' tloo ñi, juin ne' 'in ñi: 'Un ñi nu lca Bstro, huare' jlyo ti' hua si'yana 'un lca um sca nu nchcui' cha' nu ñi, lo' ñi a nan um ña'an nu quinu tsu'hue nten lo'o um, ñi a nxñi um cunta ña'an cha' 'in nten, cui' ca nu ndlo'o um cha' nu ñi 'in Ndiose, ña'an ntsu'hui cha' cu'ni na. Ña'an ljuin um, ¿ta tsu'hue cha' taa na tñi nu njñan yu César, uta na a tsu'hue 'a? ¿Taa na 'in na, uta na a taa na 'in na? ");
INSERT INTO cya_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús ngüi ti' ñi si'yana a ñi cusya 'in ne', lo' juin ñi: ¿Ñi cha' nan um ña'an su'hua um qui'ya chon'? Tyaa um sca tñi 'ñan, ña'an na. ");
INSERT INTO cya_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mdaa ne' tñi can' 'in ñi, lo' mñicha' ñi 'in ne': ¿Ti nu 'in lcuin nga'an chon' tñi re, lo'o nii nu nga'an 'in na? Mxcuen ne' 'in ñi: Yu César. ");
INSERT INTO cya_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Xacan' mxcuen Jesús 'in ne': Tyaa um 'in César na nu qui'ni ca'an 'in yu, cui' cuaña'an tyaa um 'in Ndiose na nu qui'ni ca'an 'in ñi. Lyee 'a yuhue ti' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Xacan' mdiyaa tucua snan ne' saduceo se'en ndon Jesús nu a ndiya qui'an ti' si'yana tyiqui'o ne' cua' ngujui. Mñicha' ne' 'in ñi: ");
INSERT INTO cya_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","'Un ñi nu lca Bstro, yu Moisé ngua'an scua yu sca quityi lo' nchcui' na: —Sca yu qui'yu cha' caja yu, lo' ñi sca sñe' yu lo' a mdi'in lo'o cuilyi'o yu, 'ni cha' ticui' ta'a ngula yu tyi'in lyi'o 'in ne' cuna'an can', lo' cha' tyi'in sñe' ne' cu'ni ne' cunta si'yana sñe' ne' lo'o cuilyi'o ca ne' lca can'—. ");
INSERT INTO cya_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yato'o mdi'in tsa cati yu qui'yu sca ta'a ngula ti yu. Yu nu cula can' jui cuilyi'o yu, lo' ngujui yu, una ñi sca sñe' ne' lo' a mdi'in lo'o yu. ");
INSERT INTO cya_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yu nu cua' nchca tucua can' mdi'in lyi'o 'in ne' cuna'an can', ticui' cuaña'an ngujui yu, a sca sñe' ne' mdi'in lo'o yu. Cuaña'an yato'o lo'o yu nu cua' nchca snan can'. ");
INSERT INTO cya_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Scaña'an ti yato'o 'in ta'a cati yu, ngujui yu, una ñi sca sñe' ne' lo' a mdi'in lo'o yu. Yato'o lo'o ne' cuna'an can' ngujui ne'. ");
INSERT INTO cya_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Xa ntsu'hui cha' tyiqui'o ne' cua' ngujui, ¿ti ña'an ta yu can' nu cuilyi'o ca ne' cuna'an can', si'yana mdi'in ne' lo'o ta'a cati yu? ");
INSERT INTO cya_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Xacan' mxcuen Jesús 'in ne': Si'i ña'an cha' tiyaa 'in um, si'yana a ndyi'ya um cunta ña'an nchcui' quityi 'in Ndiose, ñi a jlyo ti' um tsala cha' cuiya' nu ntsu'hui 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Xa tyiqui'o ne' cua' ngujui, a ntsu'hui 'a cha' ti' caja cuilyi'o ne', ñi a taa 'a ne' cha' cuilyi'o 'in nten, cui' ca nu scaña'an ti tyi'in ne' ña'an nchca ti' angujle 'in Ndiose la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Una tso' 'in ne' cua' ngujui lo' tyiqui'o, ¿ta na a nchca qui'ya um cha' tiyaa ña'an nchcui' quityi nu ngua'an scua Moisé, xa ycui' Ndiose lo'o yu lja yca quiche' ndiquin can', lo' juin ñi: —Nan' lcan Ndiose 'in Abraham, Ndiose 'in Isaac, Ndiose 'in Jacob—? ");
INSERT INTO cya_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Si'yana Ndiose a lca ñi Ndiose 'in ne' ngujui, cui' ca nu lca ñi Ndiose 'in ne' nu lo'o. Can' cha' nchcuin' lo'o um si'yana si'i ña'an cha' tiyaa 'in um. ");
INSERT INTO cya_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Xacan' sca yu escriba nu ngune 'in cha' nu ycui' ne' lo'o Jesús, mdiyaa yu se'en ndon ñi. Lo' si'yana tsu'hue mxcuen ñi 'in ne', can' cha' mñicha' yu 'in ñi: ¿Ti ña'an ta cha' nu ndon loo lati ngulo Ndiose tñan 'in na? ");
INSERT INTO cya_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mxcuen Jesús 'in yu: Nde cha' nu ndon loo lati que nchgaa la ña'an cha': —Ne' Israel quine 'in um cha' re. Ndiose nu lca X'nan um, scati ñi lca ñi X'nan um. ");
INSERT INTO cya_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lo'o nu chcui lca cusya 'in um tyaa um 'in um 'in Ndiose X'nan um, lo'o nu chcui lca tiquee um—, lo'o nchgaa cha' tiyaa 'in um, —lo'o nchgaa juesa 'in um—. Nde cha' nu ndon loo lati que nchgaa la ña'an cha'. ");
INSERT INTO cya_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nu cua' nchca tucua ticui' ndon loo na: —Ña'an 'tnan ti' um 'in ta'a nten um tsaña'an n'ni um 'tnan 'in um—. A ntsu'hui xca cha' nu ndon loo la que chcuaa cha' re. ");
INSERT INTO cya_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Xacan' juin yu escriba can' 'in Jesús: Ñi Bstro, cha' ñi ña'an nu nchcui' um si'yana scati Ndiose lca Ñi X'nan na, lo' a ntsu'hui 'a xca tucui ña'an nu lca ñi. ");
INSERT INTO cya_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cha' ñi si'yana lo'o nu chcui cusya 'in na ntsu'hui cha' tyaa na 'in na 'in ñi, lo'o nu chcui lca tiquee na, lo'o nchgaa cha' tiyaa 'in na, lo'o nchgaa juesa 'in na. A cunta ña'an 'tnan ti' na 'in ta'a nten na tsaña'an n'ni na 'tnan 'in na. Cha' re lyee la ntsu'hui lyoo na tloo Ndiose que nchgaa la ña'an cha' nu ngui'ni ne' xa ndiquin tucua ne' sca 'ni tloo ñi. ");
INSERT INTO cya_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Xa ngune 'in Jesús si'yana lo'o cha' tiyaa mxcuen yu 'in ñi, xacan' juin ñi 'in yu: A tijyo' nchca um se'en ndlo Ndiose tñan. A tucui 'a nu ti' msti ti' cuñicha' 'in ñi scasca la cha'. ");
INSERT INTO cya_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lja ndlo'o Jesús 'in nten ni' lyaa, mñicha' ñi 'in ne' sca cha': ¿Ñi cha' ta nchcui' ne' escriba si'yana Cristo lca ñi ticui' sñe' ta nten 'in Davi? ");
INSERT INTO cya_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Si'yana ticui' Davi ngua'an yu sca cha' xa mxiycui' Espíritu nu Luhui 'in Ndiose 'in yu: —Ndiose X'nan na juin ñi lo'o Ñi X'nan: Chcua tso' cueen 'ñan lja xicu'nin 'in ta'a cusuun quinu nde tuquiya'—. ");
INSERT INTO cya_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ticuii' Davi ndlo'o naan yu 'in ñi si'yana lca ñi X'nan yu, ¿ña'an ta lca ñi sñe' ta nten 'in yu cha' na can'? Nten qui'an can' tsu'hue 'a ntsu'hui tiquee ne' ndon nscan ne' cha' nu nchcui' ñi. ");
INSERT INTO cya_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lo' ndlo'o ñi 'in nten can': Xñi um cunta 'in um lo'o ne' escriba, ne' nu nducui ti' nchco' te' tucuin nu tsu'hue ña'an, lo' ndiya ti' ne' xa nchcui' cha' ne' 'in lo'o suun ña'an se'en nchca quiya'. ");
INSERT INTO cya_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nchcua ne' se'en ndon loo lati se'en nu n'ni tnu ne' 'in Ndiose, ticui' cuaña'an nducui ti' ne' nchcua ycu siin ne' loo yca xlya nu ndon la loo lati. ");
INSERT INTO cya_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ndlyaa ne' na'an 'in ne' cuna'an nu nguinu lo'o cha' ycui' ti, can' cha' chaan nchcui' lyi'o ne' 'in Ndiose tloo nten, can' ne' nu tlyu lati nu ti'i ntsu'hui cha' tyijyin tiyaa xaa. ");
INSERT INTO cya_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús nducua ñi chcua se'en nscua quiñan' se'en ndyi'ya ne' lcuan, ngui'ni quii ñi ña'an ndyi'ya nten can' lcuan. Ne' nu cuilyiya' qui'an 'a lcuan ndyi'ya ne'. ");
INSERT INTO cya_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xacan' mdiyaa sca ne' cuna'an ti'i ña'an chendyu 'in nu nguinu lo'o cha' ycui' ti, mdyi'ya ne' tsa tucua tñi suhue ti, nu chin' ti ntsu'hui lyoo. ");
INSERT INTO cya_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mxi'ya ñi 'in yu ta'a nda'an ñi, lo' juin ñi: Nu cha' ñi chcuin' lo'o um, ne' cuna'an nu nguinu lo'o cha' ycui' ti re, ti'i ña'an 'in ne', una qui'an la lcuan mdyi'ya ne' que nchgaa la ña'an nten re. ");
INSERT INTO cya_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Si'yana nchgaa la ña'an ne' re, mdyi'ya ne' lcuan lo'o tñi nu nguinu ti 'in ne'. Una ne' cuna'an re, lo'o cha' ti'i chendyu 'in ne' mdyi'ya ne' ña'aan tñi nu su 'in ne', tñi nu ntsu'hui cha' cunajo'o 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ña'an mdo'o Jesús ni' lyaa, sca yu ta'a nda'an ñi juin lo'o ñi: Ñi Bstro, ña'an um jan ñi, ña'an ti tnu quee re lo' tsala ña'an tlyu nguiaa' laa re. ");
INSERT INTO cya_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mxcuen Jesús 'in yu: Xñi cunta tsala ña'an tlyu nguiaa' na, una tiyaa xaa ñi xca quee re a quinu scua 'a na chon' ta'a na, si'yana ña'aan na ntsu'hui cha' cuten na. ");
INSERT INTO cya_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Xa mdiyaa jun se'en nducua qui'ya Olivo, can' yten tucua ñi chcua se'en nducua laa. Yu Tyo, yu Jacobo, yu Xuhua, lo'o yu Ndre mñicha' yu 'in Jesús sca cunta, lo' juin yu: ");
INSERT INTO cya_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Quitsa' um 'in hua cha' ñi xaa tsato'o cha' re, lo' ña'an ntsu'hui cha' ca cuiya' ti' hua xa nu cua' nchcui cuii' na? ");
INSERT INTO cya_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mxcuen Jesús 'in yu: Xñi um cunta si'yana a tucui nu cuñilyi'o 'in um. ");
INSERT INTO cya_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Qui'an 'a nu ntsu'hui cha' caan lo' chcui' si'yana lo'o cha' cuiya' 'ñan ljyan lo'o, lo' chcui' can': Nan' lcan Cristo. Lo' qui'an 'a nten cuñilyi'o can'. ");
INSERT INTO cya_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Xa cunan um cha' cua' nsuun scasca quichen, uta tijyo' loo ne cha' nsuun ne', a su'hua um cha' nduhue ti' tiquee um, si'yana a tyijyin yu'hui nu a ca cha' re, una si'i can' cha' cua' tsatii chendyu. ");
INSERT INTO cya_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Si'yana ntsu'hui cha' xuun quichen tnu lo'o ta'a quichen tnu na, sca chcui chendyu tyi'in suun. Ntsu'hui cha' quiñan scasca se'en, qui'ya bju'ñan, lo' cuaña'an quilo ti'in nten. Can' nu ti'i ntsu'hui cha' tyijyin ne' culo nducua la. ");
INSERT INTO cya_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Can' cha' xñi um cunta 'in um. Ntsu'hui cha' tyaa ne' 'in um yaa' bsya, jyi'in ne' 'in um se'en nu n'ni tnu ne' 'in Ndiose. Cui' si'ya cha' 'ñan tsa lo'o ne' 'in um tloo bsya tnu uta tloo ree, ña'an ca si'yana taa um suun ña'an cha' 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","si'yana 'ni cha' culo nducua la caja nu chcui' cha' tsu'hue 'in Ndiose sca chcui chendyu. ");
INSERT INTO cya_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Xa tsa lo'o ne' 'in um tloo bsya, a cuhue ti' um ña'an cha' nu chcui' um, cui' ca nu chcui' um ña'an cha' nu tyi'o tiquee um, si'yana si'i lo'o cunta 'in um chcui' um, cui' ca nu Espíritu nu Luhui 'in Ndiose xiycui' 'in um. ");
INSERT INTO cya_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tsato'o ticui' ta'a ngula ne' tyaa 'in ne' se'en nu cujui ne' 'in, cui' cuaña'an cu'ni ne' lo'o sñe' ne', a cunta sñe' ne' ca ti'i ti' 'in nten cula 'in, tyaa can' 'in ne' se'en nu cujui ne' 'in. ");
INSERT INTO cya_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","A cunta ña'an tucui ti ca ti'i ti' 'in um si'yan, una nchgaa nu ta loo lo'o cha' re, can' nu tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Xa ña'an um cua' nchca —sca cha' ngunan' nu cujlyo 'in ne' se'en nu a nga'an cha' ca na—, cui' ña'an cha' nu mxiycui' Ndiose 'in yu Daniel, (can' cha' qui'ya um cunta, 'un nu nchcui' quityi re), xacan' nchgaa ne' nu ndi'in se'en lca Judea, xnan yu'hui ne' loo qui'ya. ");
INSERT INTO cya_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nchgaa nu nguilyu nde que na'an, a bla 'a qui'ya can', lyoo na nu ndi'in ña'an 'in. ");
INSERT INTO cya_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Cui' cuaña'an lo'o nu ngui'ni tñan ni' quixin', a bla 'a ti' quia 'ya can' ste'. ");
INSERT INTO cya_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Una 'tnan ca ne' cuna'an nu cua' xcaña'an nxiton, lo'o nu cune' sñe'. ");
INSERT INTO cya_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Can' cha' jñan um 'in Ndiose si'yana a tsato'o cha' re tsaan nu ndi'ya ti'in tlya'. ");
INSERT INTO cya_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Si'yana caan —scasca nu ti'i tnu, nu a nchca siya' tsato'o ti' xa mtñan Ndiose chendyu, lo' ñi a ntsu'hui 'a cha' ti' caan la na—. ");
INSERT INTO cya_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Cha' Ñi X'nan na a si'yu co' ñi cha' can', a tucui nu tyi'o laa, una si'ya nten nu cua' mdo'o hui 'in ñi, can' cha' si'yu co' ñi cha' re. ");
INSERT INTO cya_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Cha' nde'en nu chcui' lo'o um: Ña'an jan ñi, nde ndon Cristo, uta ljuin: La cua ndon ñi. A tsa qui'an ti' um 'in can'. ");
INSERT INTO cya_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Si'yana ntsu'hui cha' caan scasca nu cuiñi lo' ljuin si'yana lca Cristo, a cunta chcui' si'yana Ndiose nxiycui' 'in, lo' cu'ni can' scasca cha' nu tnu se'en nu cuhue ti' nten 'in, lo' cunan can' ña'an nu cuñilyi'o 'in nu cua' ngulohui Ndiose, cha' cua na tca 'in. ");
INSERT INTO cya_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Can' cha' xñi um cunta 'in um, cua' msu'huan tiyaan 'in um lo'o cha' re. ");
INSERT INTO cya_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Xa cua' mdijin nchgaa nu ti'i re, —ntsu'hui cha' qui'ya tla loo cucha, ñi coo' lo' a tyu'hui 'a xaa 'in na. ");
INSERT INTO cya_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Cuii cua ntsu'hui cha' quilo na, ña'aan ni' cuaan quiñan tucui na—. ");
INSERT INTO cya_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","La xacan' ña'an ne' 'in —Yu Qui'yu nu Mdo'o nde ni' Cuaan quiaan ñi ni' ndlaa— lo'o sca cha' cuiya' nu tlyu lo'o sca xaa tsu'hue ña'an. ");
INSERT INTO cya_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Xacan' ca'an tñan Ndiose angujle 'in ñi, tsa xo' 'in nchgaa nu cua' ngulohui ñi nu ndi'in sca chcui chendyu. ");
INSERT INTO cya_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Xñi um cunta ña'an ndi'in cha' 'in sca yca higo xa cua' tyisnan ca cune' stan' na, lo' chcua lca' cojo' na, cua' jlyo ti' um si'yana cua' nchcui cuii' cha' quila quioo. ");
INSERT INTO cya_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cui' cuaña'an 'un xa ña'an um cua' nchca nchgaa cha' re, cua' jlyo ti' um si'yana cua' nchcui cuii' cha' yaan loo chendyu re xiya'. ");
INSERT INTO cya_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nu cha' ñi chcuin' lo'o um, ta nten re ti' ndi'in ne' xa ntsu'hui cha' ca nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ni' cuaan lo'o chendyu re, a la 'a quine cueen na tiyaa xaa, una cha' nu nchcuin' a tyijyin yu'hui a tsato'o na. ");
INSERT INTO cya_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","A tucui nu jlyo ti' ñi tsaan lo' ñi braa tsato'o cha' re, ñi angujle 'in Ndiose nu nducua ni' cuaan, lo' ñi Sñe' ñi, cui' ca nu scati Stina Ndiose jlyo ti' ñi cha' re. ");
INSERT INTO cya_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Can' cha' xñi um cunta 'in um, tyi'in tiyaa um, lo' chcui' lyi'o um 'in Ndiose, si'yana a jlyo ti' um ñi xaa tsato'o cha' re. ");
INSERT INTO cya_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nguiaa cha' re ña'an nchca ti' sca yu qui'yu nu nguiaa tijyo', yaa' nguso 'in yu mxnu yu cunta na'an 'in yu, cua' ña'aan tñan m'ni ca'an 'in yu cunda scaa yu, lo' yu nu chu'hui cuan tuna'an can', mxnu yu cunta si'yana tyi'in tiyaa yu nchgaa xaa. ");
INSERT INTO cya_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ticui' cuaña'an 'un ntsu'hui cha' tyi'in tiyaa um, si'yana a jlyo ti' um ñi xaa quila ñi nu lca x'nan um, ta nde xa siin, uta tlu'hue tla, lo' ta xa nu nxi'ya culoo latyee, uta nde cua' ljyaan xaa. ");
INSERT INTO cya_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Can' cha' xñi um cunta 'in um, si'yana xa quiaan ñi tsati ntyin, a quija lyoo ñi 'in um lja' um. ");
INSERT INTO cya_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cha' nu nchcuin' lo'o um, cuaña'an nchcuin' lo'o nchgaa tucui: Tyi'in tiyaa um. ");
INSERT INTO cya_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ti' lyijyi chcua ti tsaan nu ca ta'a Pascua, lo'o ta'a xa nchcu ne' jaslya nu a yu'hui suun 'in. Nchgaa yu nu ndlo ca tñan ni' lyaa tsatlyu lo'o ne' escriba, nan ne' ña'an nu su'hua ne' cha' cuiñi si'yana quinu Jesús, lo' cujui ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nchcui' ne': Una si'i lja ta'a re quinu yu, si'yana a nchca ti' na xilo ti'in na nten. ");
INSERT INTO cya_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús ndi'in ñi quichen Betania se'en nducua na'an 'in yu Simón, yu nu ncua ti'i lo'o quitso' la. Lja nducua ycu jun xa mdiyaa sca ne' cuna'an se'en nducua Jesús. Lyi'ya ne' sca te'en tyi'a xityi'i nu chacui' nardo, lo' qui'an ntsu'hui lyoo na. Mcha ne' yni te'en can' lo' mslo tucua ne' tyi'a xityi'i can' que ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ntsu'hui yu nu ta'a nducua ñi can' msin' ti' yu, lo' nchcui' yu: ¿Ñi cha' ta mslo lu'un ne' tyi'a xityi'i re? ");
INSERT INTO cya_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tsu'hue lati cha' cua na ncua quiya' na, lo' caja qui'an tñi lo'o na, tsaña'an nu n'ni ne' canan ndyijyin snan ciento tsaan, lo' quitsa na 'in nu ti'i. Lyee 'a ycui' tyijyin yu si'ya cha' 'in ne' cuna'an can'. ");
INSERT INTO cya_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Una Jesús juin ñi 'in yu: A ta quiya' um 'in ne', lo' a chcui ndijin um, si'yana sca cha' tsu'hue ngui'ni ne' lo'on. ");
INSERT INTO cya_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ña'an nchca ti' nu ti'i ña'an chendyu 'in, nchgaa xaa ndi'in can' lo'o um, lo' tca ta yaa' um 'in can' ña'an xaa nchca ti' um, una nan' si'i nchgaa xaa ña'an tloo um 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ne' cuna'an re cua' m'ni ne' tsa se'en nu ncua 'in ne', msu'hua ne' tyi'a xityi'i 'ñan, si'yana xitucua loo ne' cha' 'in ne' tsaan nu ntsu'hui cha' quitsin'. ");
INSERT INTO cya_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nu cha' ñi chcuin' lo'o um: Yu nu tyi'an ycui' cha' tsu'hue 'in Ndiose sca chcui chendyu, lo'o cha' 'in ne' cuna'an re chcui' yu, si'yana caja nu quia yu'hui ti' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Xacan' yu Juda Iscariote, cui' ta yu tichcua nu ta'a nda'an ñi, ya ytsa' yu 'in nchgaa nu ndlo ca tñan ni' lyaa, si'yana tyaa yu 'in Jesús tuyaa' ne'. ");
INSERT INTO cya_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mdiyaa 'a ti' ne' xa ycui' yu cha' can', lo' mdi'in tyaa ne' cha' si'yana su'hua lyiya' ne' 'in yu. Ti' xacan' nan yu ña'an ntsu'hui cha' tiyaa yu 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Culoo tsaan 'in ta'a xa nchcu ne' jaslya nu a yu'hui suun, cui' xa ndujui ne' slya' cune' ta'a Pascua, lo' yu ta'a nda'an ñi mñicha' 'in ñi: ¿La ta nchca ti' um tsa y'ni chu'hue hua, na nu ca siin 'in na ta'a Pascua re? ");
INSERT INTO cya_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Xacan' ngua'an tñan Jesús tucua yu ta'a nda'an ñi, lo' juin ñi 'in yu: Yaa um loo quichen cua, can' chcua um 'in sca yu lyi'ya sca te'en tyi'a lo' chcui ncha'an um 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ña'an se'en sten yu, can' sten um. Ndeña'an chcui' um lo'o x'nan na'an can': Ñi nu lca Bstro juin ñi, ¿cha' la ca cu siin ñi lo'o yu ta'a nda'an ñi ta'a Pascua re? ");
INSERT INTO cya_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Cui' yu quitsa' yu 'in um se'en nducua sca na'an tlyu, nu cua' nchca tucua nde cuaan, can' ndi'in nchgaa na nu cunajo'o 'in na, lo' cu'ni chu'hue um na nu ntsu'hui cha' cu siin na. ");
INSERT INTO cya_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xacan' mdo'o yu ta'a nda'an ñi lo' yten yu loo quichen can', cui' ña'an ycui' Jesús lo'o yu, cuaña'an yato'o. Mdyisnan m'ni chu'hue yu na nu cu siin jun lja ta'a Pascua can'. ");
INSERT INTO cya_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Xa ngu'ya tla, mdiyaa Jesús lo'o ta'a tichcua yu ta'a nda'an ñi se'en nducua na'an can'. ");
INSERT INTO cya_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yten tucua jun, lo' lja nchcu siin jun juin Jesús 'in yu: Nu cha' ñi cunen lo'o um, sca um nu ta'a nchcu na re ntsu'hui cha' tyaa 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mdyisnan ngulu'un ti' yu, cunda scaa yu mñicha' yu 'in ñi: ¿Ta xtyi ti' nan'? ");
INSERT INTO cya_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús mxcuen ñi 'in yu: Cui' sca um nu nchca tichcua um re lca can', cui' nu cucha' jaslya 'in sca ni' qui'nan ti lo'on. ");
INSERT INTO cya_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nu cha' ñi si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan, ntsu'hui cha' tyijyin ñi ña'an cha' nu cua' ngua'an scua loo quityi 'in Ndiose, una 'tnan ca yu nu ntsu'hui cha' tyaa 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan tuyaa' nten. Ti' tsu'hue lati cha' cua na a mdiyaan yu chendyu. ");
INSERT INTO cya_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lja nchcu siin jun msñi Jesús sca jaslya, mdyaa ñi xu'hue 'in Ndiose, msu'hue ñi 'in na lo' mdaa ñi 'in na 'in yu. Lo' juin ñi: Cu xu'hue um 'in na, nde nu lca cunan'. ");
INSERT INTO cya_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Xacan' msñi ñi sca vaso vino, mdyaa ñi xu'hue 'in Ndiose, lo' mdaa ñi 'in na 'in yu, nchgaa yu yi'o yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Lo' juin ñi 'in yu: Nde nu lca tnen, lo' si'ya na, chca tsu'hue cha' 'in nten chendyu lo'o Ndiose, lo' ntsu'hui cha' quilo na si'yana qui'an nten tyi'o laa ne'. ");
INSERT INTO cya_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nu cha' ñi cunen lo'o um: Ñi xiya' lo' a co'on 'an vino lja nu ti' ndi'in lo'o um re, cha' si'i la se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Xa cua' yla jun sca jyiin, xacan' mdo'o jun nguiaa jun nde loo qui'ya Olivo. ");
INSERT INTO cya_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Xacan' juin Jesús 'in yu: Nchgaa um ntsu'hui cha' xnu ton um 'ñan tla re ñi, tsaña'an nchcui' quityi 'in Ndiose: —Taan cha' cuiya' cujui ne' 'in ñi nu na'an seen slya', lo' slya' can' cua' la tucueen cunaan 'in—. ");
INSERT INTO cya_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lo' xa cua' mdyiqui'on, culo nducua la tsa'an se'en lca Galilea que 'in um. ");
INSERT INTO cya_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yu Tyo juin yu 'in ñi: Cha' ta nchgaa yu re xnu ton yu 'in um, una nan' a cu'nin cuaña'an. ");
INSERT INTO cya_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús mxcuen 'in yu: Nu cha' ñi cunen lo'o, tla re ñi lja nu ti' lyijyi xi'ya latyee tucua ya', tsato'o snan ya' ljuin si'yana a ndyu'hui lyoo 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yu Tyo nde lyee la mdi'in tyaa yu cha' lo'o ñi, lo' juin yu: Una a 'ni cha' siya' cujui ne' 'ñan lo'o um, una a xcuan tloon 'in um. Scaña'an ti ycui' nchgaa yu. ");
INSERT INTO cya_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Xacan' mdiyaa jun sca se'en naan Getsemaní, lo' juin ñi 'in ta'a nda'an ñi: Nde ti chcua um lja chcuin' lyi'on 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tsa 'in yu Tyo ti, yu Jacobo, lo'o yu Xuhua mdo'o lo'o ñi ntan ti, lo' mdyisnan ngu'ya sca tu'hua tiquee ñi nu lyee ti'i nga'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Lo' juin ñi 'in yu: Lu'un 'a ti' cusya 'ñan, cua' lca na cua' cajan. Nde ti quinu um lo' tyi'in um ndii ti' um. ");
INSERT INTO cya_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chin' ti se'en ti' mda'an ñi, can' mdyi'ya sti ñi 'in ñi la lyuu, mjñan ñi 'in Ndiose cha' caja ña'an nu a tyijyin ñi nu ti'i. ");
INSERT INTO cya_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Lo' juin ñi: Abba, Sti hua, nchgaa cha' tca 'in um, a taa um cha' cuiya' tijin nan' nu ti'i re, una si'i ña'an nu nchca tin', cui' ca nu ña'an nu 'un nchca ti' um. ");
INSERT INTO cya_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Xacan' mxitucui ñi se'en nducua snan yu can', nguija lyoo ñi 'in yu lja' yu, lo' juin ñi 'in yu Tyo: Simón, ¿ta lja'? ¿Ta xtyi ti' ñi sca braa a mda loo chcua ndii ti'? ");
INSERT INTO cya_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chcua um ndii ti' um lo' chcui' lyi'o um 'in Ndiose, si'yana a sten cha' ngunan' tiquee um. 'Un ñan ti' cusya 'in um cu'ni um tñan tsu'hue, una nu cu'ni um 'in na na'an ti' um. ");
INSERT INTO cya_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Xiya' yaa ñi, ticui' ti ña'an mjñan ñi 'in Ndiose lo'o ña'an cha' nu cua' ycui' ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Xacan' mxitucui ñi xiya', na'an ñi si'yana ticui' ti ña'an lja' yu, si'yana lyee ti'in ljyaan sla yu, lo' a ngujlyo 'a ti' yu ña'an ti' xcuen yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nu cua' nchca snan ya' mxitucui ñi, xacan' juin ñi 'in yu: Caja' lya um lo' xitñan' um, ca tu si'yana cua' mdiyaa braa quinu Yu Qui'yu nu Mdo'o nde ni' Cuaan tuyaa' nten qui'ya chendyu. ");
INSERT INTO cya_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tyiton um lo' quiaa na. Ña'an jan ñi, cua ljyaan yu nu ntsu'hui cha' tyaa 'ñan. ");
INSERT INTO cya_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lja nu ti' nchcui' Jesús mdiyaa yu Juda se'en ndon ñi, cui' ta yu tichcua can' lca yu. Qui'an 'a nten mdiya lo'o yu, ntsu'hui nu lyi'ya spada, ntsu'hui nu nducua yca yaa', mdiyaa yu si'ya cha' cuiya' 'in nchgaa yu nu ndlo ca tñan ni' lyaa, lo'o ne' escriba, lo'o qui'yu cula. ");
INSERT INTO cya_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yu nu ntsu'hui cha' tyaa 'in Jesús, cua' m'ni cuiya' yu cha' ña'an cu'ni yu, lo' juin yu: Yu nu chcui' chan' la sii' sca', can' nu ca lca, xñi um 'in yu una xñi tsu'hue um cunta 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Cui' ña'an lcaa mdiyaa yu se'en ndon Jesús lo' juin yu: Ñi Bstro, Ñi Bstro. Xacan' ycui' cha' yu la sii' sca' ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Cui' xaa msñi ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Una sca yu ta'a nda'an ñi ngulo yu spada 'in yu, lo' msi'yu yu nscan nguso 'in yu nu ndlo ca tñan ni' lyaa. ");
INSERT INTO cya_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Xacan' juin Jesús lo'o ne': ¿Ñi cha' lo'o spada lo'o yca ljyan sñi um 'ñan tsaña'an nchca ti' um lo'o sca yu cunan? ");
INSERT INTO cya_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nchgaa xaa nguilyun lo'o um, lo' ndlo'on 'in nten ni' lyaa, ¿ñi cha' ta a msñi um 'ñan xacan'? Una 'ni cha' tsato'o ña'an cha' nu cua' nguinu scua loo quityi 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nchgaa yu ta'a nda'an ñi ngula yaa' yu 'in ñi, cua' la tucueen msnan yu. ");
INSERT INTO cya_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Una sca yu tsa suhue ti nu nducui cha'an 'in Jesús, lo'o yu msñi lo'o ne' 'in yu, nguxen yu sca te', ");
INSERT INTO cya_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","una mxnu sti yu te' can', lo' msnan yu cunan' ti yu. ");
INSERT INTO cya_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Xacan' mdiya lo'o ne' 'in Jesús se'en ndi'in yu nu ndlo ca tñan ni' lyaa, can' nguio' ti'in yu lo'o nchgaa la ña'an ta'a ntsu'hui yu cunta, tsatlyu lo'o qui'yu cula lo'o ne' escriba. ");
INSERT INTO cya_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yu Tyo tijyo' ti mducui ncha'an yu 'in Jesús, tsaya' mdiyaa yu tuna'an lyiya' se'en ndi'in yu nu ndlo ca tñan can'. Sca se'en ti yten tucua yu lo'o yu silyiya nu ntsu'hui cuan can', lo' nguitson ti' yu se'en ndon quii' can'. ");
INSERT INTO cya_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nchgaa yu nu ndlo tñan ni' lyaa, tsatlyu lo'o nchgaa la ña'an ta'a ndlo yu tñan, nan yu ña'an nu su'hua yu qui'ya chon' Jesús se'en nu cujui ne' 'in ñi, una ñi sca cha' lo' a nguija lyoo 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Siya' qui'an la nu msu'hua qui'ya 'in ñi, una a ncua ca sca cha' ti 'in ne', si'yana si'i scaña'an ti nchcui' ne'. ");
INSERT INTO cya_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Xacan' mdyiton tucua snan yu nu msu'hua qui'ya 'in ñi lo'o cha' cuiñi: ");
INSERT INTO cya_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Huare' ngune 'in hua sca cha' nu ycui' yu re, lo' juin yu: Nan' xicuten laa nducua re nu nguiaa' lo'o juesa 'in nten chendyu, una nu cua' ca snan tsaan xiton xca na, una si'i 'a lo'o juesa 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ñi cuaña'an, lo' a ncua ca sca cha' ti 'in ne'. ");
INSERT INTO cya_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Xacan' yu nu ndlo ca tñan ni' lyaa mdyiton yu tlu'hue la, lo' mñicha' yu 'in Jesús: ¿Ñi cha' ta ñi sca cha' lo' a nxcuen, ñi qui'ya ta nsu'hua ne' 'in? ");
INSERT INTO cya_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Una Jesús ñi sca cha' lo' a mxcuen ñi. Xiya' mñicha' yu nu ndlo ca tñan can': ¿Ta cha' ñi si'yana nu'huin lca Cristo, Sñe' Ndiose ñi nu tlyu lati? ");
INSERT INTO cya_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mxcuen Jesús 'in yu: Nan' lcan. Ntsu'hui cha' ña'an um 'in —Yu Qui'yu nu Mdo'o nde ni' Cuaan nducua ñi tso' cueen 'in Ndiose—, a cunta ña'an um 'in ñi —quiaan ñi ni' ndlaa—. ");
INSERT INTO cya_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Xacan' yu nu ndlo ca tñan ni' lyaa msta yu ste' yu loo nu lyee ycuen tique' yu, lo' juin yu: ¿Ñi cha' ti' cunan na xca nu chcui' ña'an cha' 'in yu re? ");
INSERT INTO cya_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Cua' ngune 'in na ña'an ycui' ca'an yu 'in Ndiose. ¿Ña'an ljuin um ñii? Nchgaa yu msu'hua yu qui'ya chon' ñi, lo' juin yu: Tsaloo na caja ti yu. ");
INSERT INTO cya_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Scasca ne' mdyisnan msu'hua siye' ne' tloo ñi, mducun ne' tloo ñi lo' mycuan' ne' 'in ñi, lo' nchcui' ne': Ljuin ña'an na, cha' ti nu ca mycuan' 'in. Lo'o yu silyiya can' mjyi'in yaa' yu tloo ñi. ");
INSERT INTO cya_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yu Tyo ti' nducua yu tuna'an lyiya' la 'ya can', lo' mdiyaa ton sca ne' cuna'an nguso 'in yu nu ndlo ca tñan ni' lyaa. ");
INSERT INTO cya_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na'an ne' nducua yu Tyo nguitson ti' yu se'en ndon quii' can', lo' mxina'an tsu'hue ca ne' 'in yu, lo' juin ne': Lo'o nu'huin ta'a nda'an Jesús Nazaret. ");
INSERT INTO cya_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lo' juin yu Tyo: A lo'on, ñi a ndyu'hui lyoon 'in yu, ñi a jlyo tin' ñi cha' nchcui' um. Lo' mdo'o ton yu Tyo tu'hua tuna'an lyiya', xacan' msi'ya sca latyee. ");
INSERT INTO cya_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Xiya' mxina'an ne' cuna'an can' se'en ndon yu Tyo, lo' ycui' ne' lo'o nchgaa nu ndon cui' ti can': Ticui' ta cua lca yu re. ");
INSERT INTO cya_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yu Tyo ticui' ti ña'an juin yu si'yana a lo'o yu nda'an yu lo'o Jesús. Chon' nde'en can' ycui' scasca ne' lo'o yu: Nu cha' ñi ca si'yana lo'o lca ta'a nda'an yu cua, si'yana ti' cha' nchcui' ti chcan' ña'an na si'yana lca sca yu Galilea. ");
INSERT INTO cya_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Xacan' msu'hua yu Tyo can' sca cha' chon' yu, lo' m'ni tyi'ya yu Ndiose, lo' juin yu: Nu cha' ñi s'ni, a ndyu'hui lyoon 'in yu nu nchcui' um cha' 'in cua. ");
INSERT INTO cya_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Xacan' msi'ya latyee can' nu cua' nchca tucua ya'. La xacan' nguia yu'hui ti' yu Tyo ña'an ycui' Jesús lo'o yu, si'yana lja nu ti' lyijyi xi'ya latyee tucua ya', tsato'o snan ya' chcui' yu si'yana a ndyu'hui lyoo yu 'in ñi. Mdyisnan ynan yu xa nguia yu'hui ti' yu cha' can'. ");
INSERT INTO cya_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tlya ti xca tsaan can' nchgaa yu nu ndlo tñan ni' lyaa, lo'o qui'yu cula, lo'o ne' escriba, tsatlyu lo'o nchgaa la ña'an yu ta'a lyi'ya yu tñan, m'ni cuiya' ne' cha' si'yana tsa lo'o ne' 'in Jesús tloo Pilato, lo' ña'an nchcan' ñi mdyaa ne' cunta 'in ñi yaa' yu. ");
INSERT INTO cya_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yu Pilato can' mñicha' yu 'in ñi: ¿Ta cui' lca Ree 'in ne' judio? Mxcuen Jesús 'in yu: 'Un nchcui' um cuaña'an. ");
INSERT INTO cya_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yu nu ndlo ca tñan ni' lyaa, nde lyee la msu'hua yu qui'ya 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xiya' mñicha' yu Pilato 'in ñi: ¿Ñi cha' ta ñi sca cha' lo' a xcuen, lo' tsala ña'an nsu'hua ne' re qui'ya 'in? ");
INSERT INTO cya_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Una ñi cuaña'an lo' a mxcuen Jesús, can' cha' nduhue ti' yu Pilato 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ndeña'an ntsu'hui cha' 'in gubierno nchgaa yjan xa nchca Pascua, ndlaa yu sca preso, ña'an tucui ti nu ndyi'o ne' judio cha' 'in. ");
INSERT INTO cya_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sca yu naan Barrabás, tsatlyu lo'o nchgaa la ña'an ta'a nducun' yu, ntsu'hui yu preso si'yana yjui yu nten se'en mdi'in suun yu. ");
INSERT INTO cya_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nten qui'an nu nguio' ti'in can', mdyisnan mjñan ne' 'in yu Pilato cha' culaa yu sca preso lja ta'a can', cui' ña'an cha' nu cua' ntsu'hui 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yu Pilato mxcuen yu 'in nten can': ¿Ta nchca ti' um culaan 'in yu nu lca ree 'in ne' judio? ");
INSERT INTO cya_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Juin yu cuaña'an, si'yana ngu'ya yu cunta si'ya cha' jñan ti' 'in ne' nu ndlo ca tñan ni' lyaa, can' cha' mdyaa ne' 'in Jesús cunta 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Una yu nu ndlo ca tñan ni' lyaa, nde lyee la msu'hua yu tiquee nten can', si'yana tsatlyu jñan ne' 'in yu Pilato si'yana culaa yu 'in Barrabás. ");
INSERT INTO cya_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Xiya' mñicha' yu Pilato 'in ne': ¿Ña'an ta nchca ti' um cu'nin, lo'o yu nu nchcui' um si'yana lca ree 'in ne' judio? ");
INSERT INTO cya_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Xacan' xiya' ycui' cueen nten can': Jyi'in ca'an um 'in yu loo cusi. ");
INSERT INTO cya_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lo' juin yu Pilato 'in ne': Una a sca qui'ya m'ni yu re. Nten can' nde lyee la ycui' cueen ne': Jyi'in ca'an um 'in yu loo cusi. ");
INSERT INTO cya_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Se'en nu quinu tsu'hue yu Pilato lo'o nten can', ngulaa yu 'in Barrabás, lo' mdyaa yu cunta 'in Jesús yaa' sindatu, ngulo yu tñan si'yana qui'ni ñi, lo' cha'an ñi loo cusi. ");
INSERT INTO cya_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yu sindatu yten lo'o yu 'in Jesús ña'an tñan, can' mxo' ti'in ta'a yu tsatlyu. ");
INSERT INTO cya_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mxico' yu sca te' cuaa 'in ñi, mtñan yu sca sni' quiche' lo' mdi'in tyaa yu 'in na que ñi. ");
INSERT INTO cya_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mdyisnan msi'ya lo'o yu 'in ñi, lo' nchcui' yu: ¡Ngui'ni tnu hua 'in um, 'un nu lca ree 'in ne' judio! ");
INSERT INTO cya_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Lo'o yca mjyi'in yu que ñi, msu'hua siye' yu 'in ñi, lo' mdon xtyin' yu tloo ñi, si'yana lyee ngui'ni tnu yu 'in ñi ca lca cha' 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Xa cua' ngula' mstyi lyi'o yu 'in ñi, xacan' ngulyoo yu te' cuaa nu mxico' yu 'in ñi, lo' mxico' yu 'in ñi lo'o ste' ca ñi. Ya lo'o yu 'in ñi se'en cha'an ñi loo cusi. ");
INSERT INTO cya_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tucueen nguiaa yu mchcua ta'a yu lo'o sca yu yaa tñan ni' quixin', sca yu naan Simón nu mdo'o quichen Cirene, sti yu Jantro lo'o Rufo, lo' yu sindatu can' mxicu'ni yu 'in cui'ya cusi can'. ");
INSERT INTO cya_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xacan' mdiya lo'o yu sindatu 'in Jesús sca se'en nu naan Gólgota, lo' cha' re nchca ti' chcui', se'en lca que jyi'o. ");
INSERT INTO cya_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mdaa yu vino nu mxitiya' lo'o mirra 'in Jesús, una a yi'o ñi 'in na. ");
INSERT INTO cya_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Xa cua' mjyi'in ca'an yu 'in ñi loo cusi, mtsa yu ste' ñi, ngulo yu xu'hue yu lo'o na, cha' ña'an qui'ni ca'an na 'in yu cunda scaa yu. ");
INSERT INTO cya_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ntsu'hui braa cua' caa tlya xa mjyi'in ca'an yu 'in ñi loo cusi. ");
INSERT INTO cya_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lo' qui'ya nu msu'hua ne' 'in Jesús nga'an na nde que cusi, lo' nchcui' na: Nde yu lca ree 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","A cunta lo'o tucua yu cunan mjyi'in ca'an yu sindatu 'in loo cusi, sca yu tso' cueen 'in ñi, lo' xca yu tso' ca. ");
INSERT INTO cya_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yato'o cha' nu nguinu scua loo quityi 'in Ndiose, lo' nchcui' na: Cua' lca na sca cha' ti 'in ñi lo'o ne' nducun'. ");
INSERT INTO cya_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nten nu ndyijyin cui' ti can' nchcui' ca'an ne' 'in ñi, nxiquiñan ne' que ne' lo' nchcui' ne': Jun', ¿ta si'i nu'huin juin si'yana xicuten laa, lo' tsani' snan ti tsaan tñan 'in na xiya'? ");
INSERT INTO cya_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Can' cha' lyo laa 'in ticuii', lo' qui'ya loo cusi cua. ");
INSERT INTO cya_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yu nu ndlo tñan ni' lyaa lo'o ne' escriba, ticui' ti ña'an nchcui' ca'an yu 'in ñi, lo' nchcui' scasca yu: Yu re, xca tucui ngulo laa yu, una a nchca culo laa yu 'in yu ticuii' yu. ");
INSERT INTO cya_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cua' ñii tloo na'an na cha' qui'ya Cristo loo cusi, cui' ree 'in ne' Israel, lo' tsa qui'an ti' na 'in. A cunta yu nu ta'a nga'an ñi loo cusi, nchcui' ca'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Xa mdiyaa ndyi'ya cuaan tsaya' mdiyaa braa cua' snan siin, ngu'ya tla yta ña'aan sca chcui se'en can'. ");
INSERT INTO cya_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Cui' braa cua' snan siin ycui' cueen Jesús: —Eloi, Eloi, ¿lama sabactani—? Cha' re nchca ti' chcui': —Ndiose 'ñan, Ndiose 'ñan, ¿ñi cha' ta ngula yaa' um 'ñan—? ");
INSERT INTO cya_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ntsu'hui nu ngune 'in cha' nu ycui' ñi, lo' nchcui' ne': Ña'an jan ñi, nsi'ya yu 'in nu ncua naan Elía. ");
INSERT INTO cya_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Xacan' ndla ndsa ti mdo'o sca yu nu nguia 'ya sca te', lo' mcha' yu 'in na lo'o tyi'a vinagre, mscuen yu 'in na sca tuco' yca si'yana co'o Jesús 'in na, lo' nchcui' yu: Quita na ña'an na cha' caan ca yu Elía, lo' tyi'ya 'in yu loo cusi. ");
INSERT INTO cya_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Una Jesús msi'ya cueen ñi, cui' ña'an lcaa ngujui ñi. ");
INSERT INTO cya_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Te' tlyu nu nducui ni' lyaa mda' tlu'hue la na, ti' ndyi'o la cuaan ngu'ya la lyuu. ");
INSERT INTO cya_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nde loo se'en nga'an Jesús ndon x'nan sindatu, xa ngune 'in yu ña'an msi'ya Jesús xa ngujui ñi, lo' juin yu: Nu cha' ñi ca si'yana yu re ncua yu Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A cunta lo'o tucua snan jun cuna'an ndon jun tijyo' ti nan' 'ya jun, cui' María Magdalena, María jyi'an yu See lo'o Jacobo, yu nu cune' la can', a cunta lo'o Salomé. ");
INSERT INTO cya_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jun cuna'an re mducui ncha'an jun 'in Jesús, lo' mdaa yaa' jun 'in ñi xa mda'an ñi se'en lca Galilea. A cunta lo'o xca ta jun cuna'an nu ta'a mdiyaa ñi quichen Jerusalén, ndon can'. ");
INSERT INTO cya_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Si'yana cua' msiin tsaan nu cua' tyisnan xitñan' ne' judio, ");
INSERT INTO cya_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","yato'o sca yu naan See Arimatea, m'ni tnu tiquee yu ya jñan yu cha' cuiya' 'in Pilato si'yana cutsi' yu 'in Jesús. Lca yu sca nu ndon loo 'in ne' judio, lo'o yu nta yu tsaan nu ntsu'hui cha' culo Ndiose tñan 'in nten. ");
INSERT INTO cya_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yu Pilato can' yuhue 'a ti' yu xa ynan yu cha' si'yana cua' ngujui Jesús, can' cha' msi'ya yu 'in x'nan sindatu can', lo' mñicha' yu 'in cha' na cha' ñi ca cua' ngujui Jesús. ");
INSERT INTO cya_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Xa cua' jui suun 'in yu si'yana cua' ngujui Jesús, xacan' mdyaa yu Pilato cunta 'in yu See can' si'yana cutsi' yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Msi'i yu See can' sca te' tsu'hue ña'an, lo' xa mdyi'ya yu 'in Jesús loo cusi, nguxen yu te' can' 'in ñi. Mdi'in tyaa yu 'in ñi ni' sca tuquee nu cua' lca nguiaa', lo' mxixen yu sca quee si'yana tucun yu 'in na. ");
INSERT INTO cya_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, lo'o María nu lca jyi'an yu See, na'an ne' la mtsi' Jesús. ");
INSERT INTO cya_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Xa cua' mdijin tsaan nu nxitñan' ne' judio, María Magdalena lo'o María jyi'an yu Jacobo, lo'o Salomé msi'i jun tyi'a xityi'i nu su'hua jun 'in Jesús se'en mtsi' ñi. ");
INSERT INTO cya_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tlya ti culoo tsaan 'in snan can', xa tsa nducua cucha mdo'o ne' nguiaa ne' tucuaa can'. ");
INSERT INTO cya_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tucueen nguiaa jun scasca jun nchcui' jun: ¿Ti nu culo ntan quee nu nchcun tucuaa can'? ");
INSERT INTO cya_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Xa mdiyaa jun, na'an jun si'yana cua' mdo'o ntan quee can', lo' lca na sca quee tlyu. ");
INSERT INTO cya_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yten jun se'en mtsi' Jesús, lo' na'an jun nducua sca yu tsa suhue ti tso' cueen can', lco' yu sca te' tucuin nu mten, lo' ytsen jun. ");
INSERT INTO cya_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lo' juin yu 'in jun: A cutsen um, jlyo tin' si'yana nda'an nan um 'in Jesús Nazaret nu mjyi'in ca'an ne' 'in loo cusi. Cua' mdyiqui'o ñi, lo' a ntsu'hui 'a ñi re, cu'ni quii um se'en mdi'in tyaa ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Quia ytsa' um 'in yu ta'a mda'an ñi, lo'o yu Tyo, si'yana culo nducua la ñi tsaa ñi se'en lca Galilea, la cua ña'an ta'a ñi lo'o yu, cui' ña'an nu cua' ycui' ñi lo'o yu. ");
INSERT INTO cya_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ndla ndsa ti mdyi'o jun cuna'an can' se'en mtsi' ñi, mchcuan jun nu lyee nguitsen jun, lo' ñi a ycui' 'a jun lo'o ñi xca tucui, si'yana lyee ytsen jun. ");
INSERT INTO cya_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tlya culoo tsaan 'in snan xa mdyiqui'o Jesús, culo nducua la 'in María Magdalena ngulo'o tloo ñi, cui' nu ngulo ñi tsa cati cui'in xa'an 'in. ");
INSERT INTO cya_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mdo'o jun nguia ytsa' jun cha' can' 'in nchgaa la ña'an ta'a mda'an Jesús, se'en ndi'in lu'un ti' yu lo' nguinan yu. ");
INSERT INTO cya_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Xa ynan yu cha' si'yana lo'o Jesús, a cunta María cua' na'an tloo 'in ñi, una a ya qui'an ti' yu cha' can'. ");
INSERT INTO cya_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chon' nde'en la can', ngulo'o tloo Jesús 'in tucua yu nu nguiaa sca tucueen ni' quixin', una xcaña'an ngulo'o tloo ñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cui' xaa ya ytsa' yu 'in nchgaa la ña'an ta'a mda'an ñi cha' can', una ticui' ti ña'an a ya qui'an ti' yu. ");
INSERT INTO cya_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","La xiya' ti can' ngulo'o tloo Jesús 'in ycui' ca yu ta'a mda'an ñi, cui' cha tixca yu can', se'en nducua ycu yu. Lo' ycui' ñi lo'o yu ñi cha' tla 'a cusya 'in yu, lo' a ya qui'an ti' yu 'in nu na'an tloo ca 'in ñi xa cua' mdyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Xacan' juin ñi 'in yu: Tsaa um sca chcui chendyu, lo' chcui' um cha' tsu'hue 'in Ndiose lo'o nchgaa nten. ");
INSERT INTO cya_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nu tsa qui'an ti' 'ñan lo' chcua tya, can' nu tyi'o laa. Una nu a tsa qui'an ti' 'ñan, can' nu nducua yuhue' chon' tsala xaa. ");
INSERT INTO cya_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nu tsa qui'an ti' 'ñan, scasca cha' nu tnu cu'ni can': Lo'o cha' cuiya' 'ñan, culo can' cui'in xa'an nu ntsu'hui 'in nten, lo' chcui' can' scasca lenguas nu cui ti. ");
INSERT INTO cya_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cha' xñi can' sca cunaan nu la, lo' ta co'o can' na nu yu'hui yaan 'in, lo' a sca ca 'in. A cunta tyi'in tyaa can' yaa' 'in nu ti'i lo' chca. ");
INSERT INTO cya_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Xa mdyi ycui' Ñi X'nan na cha' re, m'ni Ndiose cha' ycuen ñi nde ni' cuaan, lo' yten tucua ñi tso' cueen 'in ñi. ");
INSERT INTO cya_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yu ta'a mda'an ñi ya ycui' yu cha' tsu'hue 'in Ndiose nchgaa se'en, lo' Ñi X'nan na mda yaa' ñi 'in yu, lo' mxnu scua tla ñi cha' nu ycui' yu lo'o cha' tnu nu m'ni ñi. Amen.");
INSERT INTO cya_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Qui'an 'a nu cua' msu'hua juesa ca'an lyicua quityi re tsaña'an nu cha' ñi ca yato'o lja hua, ");
INSERT INTO cya_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","chcui ña'an jui nu ngulo'o 'in hua, nu na'an tloo cha' re ti' xa mdyisnan na, lo' mchcuan yu cunta si'yana tsa ycui' yu cha' re lo'o nten. ");
INSERT INTO cya_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Can' cha' lo'on nan' mdo'o tiqueen ca'an quityi re lyicua la 'in um, 'un ñi Teófilo, si'yana cua' nguia nan tsu'huen nchgaa cha' re lo'o cha' tiyaa, ti' la suun se'en mdyisnan na, ");
INSERT INTO cya_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","si'yana ca cuiya' tsu'hue ti' um lo' a cu'ni tucua ti' um lo'o cha' nu cua' jui nu ngulo'o 'in um. ");
INSERT INTO cya_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Xa ncua yu Herode ree se'en lyi'ya loo Judea, ndi'in sca yu naan Zacaría nu ntsu'hui cunta 'in laa, cui' ta 'in Abía, lo' cuna'an 'in Zacaría can' naan Elisabet, ta nten 'in Aarón. ");
INSERT INTO cya_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chcuaa can' ñi ndi'in cha' 'in tloo Ndiose, tsu'hue nguia ncha'an can' nchgaa cha' nu ndlo Ñi X'nan na tñan lo'o cha' nu mdi'in tyaa ñi. ");
INSERT INTO cya_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Una a mdi'in sñe' jun si'yana Elisabet la' ña'an a mdu'hui sñe', a cunta chcuaa jun cua' cula jun. ");
INSERT INTO cya_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yato'o lja ngui'ni Zacaría tñan 'in Ndiose, cui' tsaan nu m'ni ca'an 'in ta nu ntsu'hui yu, ");
INSERT INTO cya_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","mdo'o xu'hue yu tiquin tucua yu na nu xityi'i ni' lyaa 'in Ñi X'nan na, ña'an cha' nu cua' ntsu'hui 'in yu nu ndlo tñan ni' lyaa. ");
INSERT INTO cya_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ña'aan quichen ne' ndi'in nde lyiya', nchcui' lyi'o ne' 'in Ndiose lja ndiquin na xityi'i can'. ");
INSERT INTO cya_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Xacan' ngu'ya ton sca angujle 'in Ñi X'nan na tloo yu, luhua' tso' cueen se'en ndiquin na can'. ");
INSERT INTO cya_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Xa na'an Zacaría 'in angujle can', ytsen yu lo' a ngujlyo 'a ti' yu ña'an ca. ");
INSERT INTO cya_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Una angujle can' juin lo'o yu: A cutsen Zacaría, si'yana cua' mxcuen Ndiose cha' nu njñan, nten 'in nu lca Elisabet ntsu'hui cha' tyi'in sca sñe', lo' tyi'in tyaa nii ca naan Xuhua. ");
INSERT INTO cya_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ndyijyin ya' ca tsu'hue chu'hui tiquee si'ya cha' re, cui' cuaña'an qui'an 'a nten ca tsu'hue chu'hui tiquee ne' xa ca cune' cuhui', ");
INSERT INTO cya_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","si'yana tlyu tucui ca can' tloo Ndiose. A ntsu'hui cha' co'o can' vino uta sidra, si'yana cua' lca mtsa'an yu'hui can' lo'o Espíritu nu Luhui 'in Ndiose xa tiyaan chendyu. ");
INSERT INTO cya_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Cu'ni can' cha' si'yana qui'an ne' Israel xitucui ne' lo' tsa qui'an ti' ne' 'in Ñi X'nan na, ñi nu lca Ndiose 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Chcua loo yu cu'ni yu tñan 'in Ñi X'nan na lo'o nu chcui lca tiquee yu tsaña'an cha' cuiya' nu mdon lo'o Elía, —cu'ni yu cha' chca tsu'hue lca tiquee nten cula can' lo'o sñe' ne'—, cui' cuaña'an nu lye' ti' tyisnan cu'ni tñan tsu'hue, ña'an ca si'yana tyi'in tya tiyaa yu sca quichen nu cuan xu'hue 'in Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Xacan' juin Zacaría 'in angujle can': ¿Ña'an ta tca chu'hui lyoon cha' re? A cunta cua' culan, cui' cuaña'an nten 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mxcuen angujle can' 'in yu: Nan' lcan Gabriel nu nguilyu tloo Ndiose, cui' ñi ngua'an tñan ñi 'ñan si'yana chcuin' lo'o lo' ca jlyo ti' cha' tsu'hue re. ");
INSERT INTO cya_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Una ti' cua' ñii a tca 'a chcui' tsaya' tiyaa tsaan nu tsato'o cha' re, si'yana a ya qui'an ti' cha' nu ycuin' lo'o. ");
INSERT INTO cya_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nten can' nta ne' 'in Zacaría nde lyiya', lo' nduhue ti' ne' ñi cha' lyee 'a ndiya' yu ni' lyaa can'. ");
INSERT INTO cya_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Una xa mdyi'o yu a ncua 'a chcui' yu, xacan' ngu'ya ne' cunta si'yana na'an xñii yu sca cha' ni' lyaa can'. Xtyi n'ni yaa' ti yu ntsa' yu cha' nu na'an yu, lo' a ncua 'a chcui' yu. ");
INSERT INTO cya_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Xa yatii tsaan nu nguilyu yu ni' lyaa, xacan' nguila yu nde se'en ndi'in yu. ");
INSERT INTO cya_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chon' nde'en can' mxilyo ña'an Elisabet, lo' tsani' ca'yu coo' a la 'a mdo'o ne', lo' nchcui' ne': ");
INSERT INTO cya_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ndeña'an m'ni Ñi X'nan na lo'on si'yana nguia yu'hui ti' ñi 'ñan, lo' a caja 'a cha' chcui' nten lo'on cua' ña'an ti. ");
INSERT INTO cya_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Xa cua' nguiaa scua coo' mxilyo ña'an Elisabet, xacan' ngua'an tñan Ndiose 'in angujle Gabriel can', tsaa quichen Nazaret se'en lyi'ya loo Galilea, ");
INSERT INTO cya_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","se'en ndi'in sca ne' cuna'an tsa suhue ti nu a nchca qui'ni ca'an yu qui'yu 'in, una cua' ncua cuiya' cha' si'yana ca cuilyi'o ne' 'in sca yu naan See, cui' ta nten 'in Davi, lo' ne' cuna'an can' naan ne' María. ");
INSERT INTO cya_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Xacan' mdiyaa angujle se'en ndi'in ne' cuna'an can' lo' juin: ¡Ca tsu'hue chu'hui tiquee tsaña'an cha' tsu'hue nu mdo'o tiquee Ndiose lo'o! Si'yana Ñi X'nan na ndi'in lo'o, lo' tlyu la xu'hue mdaa Ndiose 'in que nchgaa la ña'an ne' cuna'an. ");
INSERT INTO cya_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Una xa na'an 'in angujle can', ytsen lo'o cha' nu ngune 'in, lo' msu'hua cha' tiquee cha' ñi cha' ca lca cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Xacan' juin angujle: María, a cutsen, si'yana Ndiose ndyu'hui cuiya' ti' ñi 'in. ");
INSERT INTO cya_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cua' ñii ntsu'hui cha' xilyo ña'an lo' tyi'in sca cuhui' qui'yu 'in, lo' tyi'in tyaa nii cuhui' ca naan cuhui' Jesús. ");
INSERT INTO cya_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ntsu'hui cha' ca ñi sca nu ndon loo, lo' ca naan ñi Sñe' Ndiose, ñi nu tlyu lati, cui' Ndiose X'nan na xiton 'in ñi, lo' chcuan ñi cunta cha' cuiya' nu mdaa Ndiose 'in Davi, nu lca sti ta nten 'in ñi, ");
INSERT INTO cya_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tsala xaa culo ñi tñan 'in ta nten 'in Jacob, lo' a ntsu'hui cha' tsatii cha' cuiya' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Xacan' juin María 'in angujle can': ¿Ña'an ta tsato'o cha' re si'yana a nchca sca yu qui'yu qui'ni ca'an 'ñan? ");
INSERT INTO cya_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mxcuen angujle can': Espíritu nu Luhui 'in Ndiose qui'ya yu'hui 'in, scati Ndiose ñi nu tlyu lati cu'ni ñi cha' cho'o yu'hui cha' cuiya' 'in ñi 'in, lo' nu ntsu'hui cha' ca cune' can' lca sca nu Luhui, can' cha' ca naan can' Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Cua' ñii ca cuiya' ti' si'yana lo'o Elisabet nu ti' nchca ta'a, cua' mxilyo ña'an siya' cua' cula, cua' nguiaa scua coo' 'in lo'o cha' can', cui' nu nchcui' ne' 'in si'yana a ndyi'in sñe', ");
INSERT INTO cya_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","una cha' nu 'in Ndiose, a sca cha' tucui. ");
INSERT INTO cya_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Xacan' juin María: Nde ndon lo' ca ja'an 'in Ñi X'nan na, lo' tsato'o nchgaa cha' nu ycui' um lo'on. Xacan' mdo'o angujle can' nguiaa. ");
INSERT INTO cya_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Xi'i ti mducui, ndla ti m'ni María cha' mdo'o nguiaa sca quichen ndi'in lja qui'ya se'en lyi'ya loo Judea, ");
INSERT INTO cya_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","xa mdiyaa se'en nducua na'an 'in Zacaría, ycui' cha' 'in Elisabet. ");
INSERT INTO cya_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yato'o xa ngune 'in Elisabet ycui' cha' María can', ngüi ti' Elisabet nguñan yu'hui cuhui' can' 'in, cui' ña'an lcaa mtsa'an yu'hui Elisabet lo'o Espíritu nu Luhui 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Cui' xaa mdo'o ycui' cueen: Tsu'hue ca xu'hue nu'huin que 'in nchgaa la ña'an ne' cuna'an, lo' tlyu ca xu'hue ntsu'hui 'in ñi nu lca sñe'. ");
INSERT INTO cya_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nduhue tin' ñi cha' m'ni ca'an cha' re 'ñan si'yana jyi'an Ñi X'nan yan ycui' cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ña'aan xa ngune 'ñan ycui' cha', cui' xaa nguñan yu'hui cuhui' re 'ñan loo nu lyee tsu'hue ntsu'hui tiquee cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tsu'hue ca xu'hue si'yana ya qui'an ti', a s'ni tsato'o cha' nu cua' mdi'in tyaa Ñi X'nan na lo'o. ");
INSERT INTO cya_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Xacan' juin María: —Lo'o nu chcui cusya 'ñan cu'nin tnun 'in Ñi X'nan na, ");
INSERT INTO cya_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","lo' ndyijyin ya' tsu'hue ntsu'hui tiqueen lo'o Ndiose, Ñi nu ndlo laa 'ñan, ");
INSERT INTO cya_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","si'yana mdi'in tyaa ñi quiloo ñi 'ñan, nan' nu lca nguso 'in ñi—, lo' ti' cua' ñii nchgaa ta nten nu caan nde loo re, chcui' si'yana tlyu ca xu'hue ntsu'hui 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Si'yana Ñi nu tla la cha' 'in m'ni ñi sca cha' nu tnu lo'on, —lo' lca ñi sca nu Luhui 'a—. ");
INSERT INTO cya_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tsala xaa —ña'an 'tnan ti' ñi 'in nten tsalca nu nchca ja'an 'in ñi—. ");
INSERT INTO cya_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","M'ni ñi scasca cha' nu tnu lo'o cha' cuiya' 'in ñi, ngujlyo ñi 'in nu siye' lo'o cha tiyaa 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mchcuan ñi cha' cuiya' 'in nu ndlo tñan loo chendyu re, lo' mscuen cuaan ñi 'in nu jo'o la ndi'in cha' 'in. ");
INSERT INTO cya_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mdaa ñi nchgaa loo cha' tsu'hue 'in nu nda'an nguite' ti', una nu cuilyiya' mxnu ñi 'in can' cua ti ña'an. ");
INSERT INTO cya_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mda yaa' ñi 'in ne' Israel nu lca nguso 'in ñi, nguia yu'hui ti' ñi 'in ne' lo' tsala ña'an mña'an 'tnan ti' ñi 'in ne', ");
INSERT INTO cya_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","cha' nu mdi'in tyaa ñi lo'o nu ncua nten cula 'in na, cui' Abraham lo'o ta nten nu lca sñe' can', lo' nguinu scua cha' re tsala xaa. ");
INSERT INTO cya_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Can' nguinu María lo'o Elisabet tsani' snan coo', chon' nde'en can' mxitucui nde quichen tyi. ");
INSERT INTO cya_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Xa ya tucua tsaan can' mdiyaan sca cuhui' qui'yu 'in Elisabet. ");
INSERT INTO cya_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ta'a ndi'in ne' cui' ti can' lo'o nchgaa la ña'an ta'a jun, xa ynan ne' cha' si'yana Ndiose tlyu cha' tsu'hue m'ni ñi lo'o jun, tsu'hue yu'hui tiquee ne'. ");
INSERT INTO cya_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Xa ncua snu' tsaan cuhui' can', yaa jun se'en ntsu'hui cha' ca circuncida 'in cuhui', lo' mdi'in tyaa ne' nii cuhui' si'yana ca naan cuhui' Zacaría, ña'an naan sti cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Una jyi'an cuhui' mxcuen: Si'i cuaña'an ca naan cuhui', Xuhua ca naan cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lo' juin ne' xacan': ¿Ñi cha' ca naan cuhui' cuaña'an, lo' ñi sca ta nten 'in, a naan cuaña'an? ");
INSERT INTO cya_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Xacan' m'ni yaa' ti ne' 'in sti cuhui' cha' ña'an ca naan cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Cui' xaa mjñan yu sca ca' lyo' ti, lo' ndeña'an ngua'an yu loo na: Xuhua ca naan cuhui'. Xacan' nchgaa ne' yuhue ti' ne'. ");
INSERT INTO cya_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ticui' xaa nguila cha' nchcui' 'in Zacaría can', lo' mdyaa yu xu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ndyijyin 'a ya' nduhue ti' nchgaa nten ndi'in cui' ti can', cuaña'an scasca quichen ndi'in lja qui'ya se'en lyi'ya loo Judea mscua cueen cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nchgaa nu ngune 'in cha' can' msu'hua ne' cha' tiquee ne', lo' nchcui' ne': ¿Ñi na ña'an ndi'in cha' 'in cuhui' cua? Lo' Ñi X'nan na ntsu'hui ñi cunta 'in cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Lo' Zacaría sti cuhui' mtsa'an yu'hui lo'o Espíritu nu Luhui 'in Ndiose lo' ndeña'an mxiycui' ñi 'in: ");
INSERT INTO cya_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Tlyu ca cha' tsu'hue ntsu'hui 'in Ndiose X'nan ne' Israel—, si'yana cua' mdiyaan ñi se'en nu culo laa ñi quichen 'in ñi, ");
INSERT INTO cya_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","mxiton ñi sca nu tla la cha' 'in nu culo laa 'in na, nu yaan loo ta nten 'in Davi nu ncua nguso 'in ñi, ");
INSERT INTO cya_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","cui' tsaña'an cha' nu mxiycui' ñi 'in nchgaa nu mdo'o hui 'in ñi ti' culoo, ");
INSERT INTO cya_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","si'yana culo laa ñi 'in na tuyaa' ta'a cusuun na lo'o nchgaa nu nxcuan tloo 'in na, ");
INSERT INTO cya_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","lo' cuaña'an ña'an 'tnan ti' ñi 'in nchgaa nten cula 'in na, lo' nguia yu'hui ti' ñi cha' nu mxnu ñi 'in can', ");
INSERT INTO cya_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","cui' cha' nu mdi'in tyaa ca ñi lo'o nten cula 'in na Abraham, cha' nu ntsu'hui cha' taa ñi 'in na, ");
INSERT INTO cya_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","si'yana tyi'o laa na tuyaa' ta'a cusuun na, lo' cuaña'an taa ñi cha' cuiya' cu'ni na tñan 'in ñi lo'o nu chcui lca tiquee na, ");
INSERT INTO cya_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","luhui cha' tiyaa 'in na cu'ni na tñan tsu'hue tloo ñi tsala xaa. ");
INSERT INTO cya_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nu'huin nu lca sñen', ntsu'hui cha' caja nu culo'o naan 'in si'yana lca yu nu nxiycui' Ndiose 'in, ñi nu tlyu lati. Si'yana —chcua loo lo' cu'ni chu'hue tucueen nu caan Ñi X'nan na—. ");
INSERT INTO cya_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Lo' culo'o 'in quichen 'in ñi ña'an ntsu'hui cha' tyi'o laa ne', ña'an ca si'yana cu'ni ñi cha' tlyu ti' 'in ne' lo'o qui'ya nducui ne'. ");
INSERT INTO cya_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Si'yana tlyu cha' tsu'hue mdo'o tiquee Stina Ndiose lo'o na, can' cha' ti' la ni' cuaan ncua chcan' sca xaa nu yaan 'in na, ");
INSERT INTO cya_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","si'yana —tyu'hui xaa 'in nchgaa nu ndi'in se'en tla yta, nchgaa nu nsu'hua nchcun cha' ndyija 'in—, a cunta si'yana culo'o ñi 'in na tucueen nu tsaa na, lo' cuaña'an tca tyi'in tsu'hue na. ");
INSERT INTO cya_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Cuhui' can' nguia nguilo cuhui', lo' cuaña'an nguia ndyija juesa 'in lo'o tso' nu 'in Ndiose, lo' mdi'in yu sca se'en ngutyi tsaya' mdiyaa tsaan nu ngulo'o tloo yu 'in ne' Israel. ");
INSERT INTO cya_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yato'o yu nu lca ree Augusto César, mdi'in tyaa tla yu sca cha' si'yana nchgaa nten cha'an scua nii ne' ña'aan se'en ndlo yu tñan. ");
INSERT INTO cya_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cha' re yato'o culoo xa ngu'ya yu Cirenio tñan se'en lyi'ya loo Siria. ");
INSERT INTO cya_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Cunda scaa nten nguiaa ne' quichen tyi ne' si'yana cha'an scua nii ne'. ");
INSERT INTO cya_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Can' cha' lo'o yu See mdo'o yu quichen Nazaret se'en lyi'ya loo Galilea, nguiaa yu quichen tyi Davi, cui' Belén se'en lyi'ya loo Judea, si'yana lca yu ta nten 'in Davi, ");
INSERT INTO cya_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","can' ntsu'hui cha' cha'an scua nii jun lo'o María nu lca cuilyi'o yu, lo' cua' nchcui cuii' cha' tiyaan sñe' can' chendyu. ");
INSERT INTO cya_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yato'o lja ndi'in jun can', ya tucua xaa nu ntsu'hui cha' tyijyin yu'hui 'in. ");
INSERT INTO cya_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mdi'in sca cuhui' 'in, sñe' nu culoo, lo' nguxen sca te' 'in cuhui', mdi'in tyaa 'in cuhui' sca se'en ndyu'hui na nchcu 'ni, si'yana a jui na'an se'en quinu jun. ");
INSERT INTO cya_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tu'hua quichen can' ndi'in tucua snan yu nu na'an seen slya', ntsu'hui yu cunta 'in 'in chcui tla. ");
INSERT INTO cya_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tsati ntyin ngulo'o tloo sca angujle 'in Ñi X'nan na 'in yu, la ni' cuaan mdo'o sca xaa 'in Ñi X'nan na msu'hua lo'o 'in yu, lo' lyee ytsen yu. ");
INSERT INTO cya_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Una juin angujle can' lo'o yu: A cutsen um, si'yana nde ljyan lo'on sca cha' tsu'hue 'in um tsaña'an nu ca tsu'hue chu'hui tiquee nchgaa nten: ");
INSERT INTO cya_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Si'yana tla re ñii, quichen tyi Davi, ngula ñi nu culo laa 'in um, can' nu lca Cristo ñi nu lca X'nan na. ");
INSERT INTO cya_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nde sca cuiya' nu ndyi'in tyaan 'in um: Quia nan um 'in sca cuhui' nu ntsu'hui ni' yca se'en ndyu'hui na nchcu 'ni. ");
INSERT INTO cya_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tsati ntyin ncua chcan' qui'an la angujle la ni' cuaan nu ngui'ni tnu 'in Ndiose, lo' nchcui': ");
INSERT INTO cya_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Cu'ni tnu na 'in Ndiose, ñi nu nducua ni' cuaan, cua' ñii caja ña'an tyi'in tsu'hue nten loo chendyu re, si'yana cuaña'an lca tiquee ñi lo'o ne'! ");
INSERT INTO cya_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yato'o xa mxitucui angujle can' nde ni' cuaan, yu nu na'an seen slya' can' mdyisnan nchcui' yu scasca yu: Tsaa na quichen Belén lo' ca cuiya' ti' na cha' nu yato'o, tsaña'an mtsa' Ñi X'nan na 'in na. ");
INSERT INTO cya_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ticui' xaa mdo'o yu nguiaa yu, lo' nguija lyoo yu 'in María lo'o yu See, lo' cuhui' can' nscua cuhui' ni' yca se'en ndyu'hui na nchcu 'ni. ");
INSERT INTO cya_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Xa na'an yu 'in cuhui' can', mdaa yu suun lo'o jun nchgaa cha' nu ngune 'in yu cha' 'in cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nduhue ti' nchgaa nu ngune 'in cha' nu ycui' yu nu na'an seen slya' can'. ");
INSERT INTO cya_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nguinu yu'hui cha' can' tiquee María, lo' qui'an cha' nguñan ti' si'ya cha' nu yato'o. ");
INSERT INTO cya_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Xacan' yu nu na'an seen slya' can' mxitucui yu nguiaa yu, ngui'ni tnu yu 'in Ndiose lo' ndyaa yu xu'hue 'in ñi si'ya nchgaa cha' nu na'an yu lo' ngune 'in yu, cui' tsaña'an cha' nu ycui' angujle can' lo'o yu. ");
INSERT INTO cya_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Xa mda'a snu' tsaan can' m'ni jun cha' ncua circuncida 'in cuhui', lo' mdi'in tyaa jun nii cuhui' si'yana ca naan cuhui' Jesús, cui' nii nu mdi'in tyaa angujle xa ti' lyijyi xilyo ña'an María. ");
INSERT INTO cya_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xa mda'a tsaan nu ntsu'hui cha' suhui jun 'in jun, tsaña'an nu nchcui' lee ngua'an scua Moisé, xacan' ya lo'o jun 'in cuhui' quichen Jerusalén, si'yana xnu jun cunta 'in cuhui' yaa' Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Si'yana ndeña'an nguinu scua cha' loo lee 'in Ñi X'nan na: —Cuhui' qui'yu nu culoo 'in jyi'an, can' nu tucua tloo Ñi X'nan na 'in—.) ");
INSERT INTO cya_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A cunta si'yana taa jun sca lcuan nu squin tucua tloo Ndiose tsaña'an nchcui' lee 'in Ñi X'nan na: Ntsu'hui cha' taa jun —tsa ta ngroo uta tucua scun' jo'o nu cune' ti—. ");
INSERT INTO cya_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Cui' quichen Jerusalén ndi'in sca yu nu naan Simeón, lca yu sca nu ñi ndi'in cha' 'in lo' n'ni tnu yu 'in Ndiose, lo'o yu nta yu tsaan nu ntsu'hui cha' tyi'o laa ne' Israel, lo' mtsa'an yu'hui yu lo'o Espíritu nu Luhui 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Cua' mtsa' Espíritu 'in yu si'yana a tyi'o yu loo chendyu re, cha' si'i la cua' na'an tloo yu 'in ñi nu mdo'o hui ca 'in Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Cui' tsaan can' mdu'hui Espíritu tiquee yu si'yana tsaa yu ni' lyaa, lja xacan' mdiya lo'o jun 'in cuhui' can', si'yana cu'ni ne' lo'o cuhui' tsaña'an nu nchcui' lee. ");
INSERT INTO cya_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Xacan' mdi'in tyaa scun yu Simeón can' 'in cuhui', mdyaa yu xu'hue 'in Ndiose, lo' nchcui' yu: ");
INSERT INTO cya_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ñi X'nan hua, cua' ñii tca chcuan um 'ñan ña'an cha' nu cua' mdi'in tyaa um, ");
INSERT INTO cya_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","si'yana cua' na'an tloon 'in ñi nu ntsu'hui cha' culo laa 'in hua, ");
INSERT INTO cya_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","cui' cha' tsu'hue nu cua' mdi'in tyaa um nu cu'ni tsu'hue 'in nchgaa nten, ");
INSERT INTO cya_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","nde nu lca sca xaa nu sla cha' tiyaa 'in ne' gentil, cui' cuaña'an ca tsu'hue chu'hui tiquee ne' Israel nu lca quichen 'in um. ");
INSERT INTO cya_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yu See lo'o jyi'an cuhui' nduhue 'a ti' jun cha' nu nchcui' Simeón can' cha' 'in cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lo' mjñan yu Simeón 'in Ndiose si'yana ncuan ñi 'in jun, xacan' juin yu 'in María jyi'an cuhui' can': Nde nu ngulo ton Ndiose, lo' si'ya ñi re qui'an 'a ne' Israel tyiton ne', a cunta qui'an ne' ntsu'hui cha' tlyu ne', lo' caja nu ña'an ti'i 'in, ");
INSERT INTO cya_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","(lo' cha' re tyijyin xi'yu na ni' cusya 'in tsaña'an nchca ti' sca xlyu), ña'an ca si'yana ca chcan' loo tsaña'an lca cusya 'in nchgaa nten. ");
INSERT INTO cya_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","A cunta ni' lyaa can' nguilyu Ana, sca ne' cuna'an nu nxiycui' Ndiose 'in, sñe' Fanuel nu lca ta nten 'in Aser, a cunta cua' cula ne', lo' mdi'in ne' lo'o cuilyi'o ne' cati yjan xa ncua suhue ne', ");
INSERT INTO cya_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","lo' cua' nguiaa jacua yla ntsu'hui jacua yjan nu nguinu ne' lo'o cha' ycui' ti. Nchgaa xaa nguilyu ne' ni' lyaa ngui'ni tnu ne' 'in Ndiose, tla lo' cucha nchcui' lyi'o ne' 'in ñi, cui' cuaña'an ngui'ni ne' ayuna. ");
INSERT INTO cya_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lja xacan' mdiyaa ne' se'en nguilyu jun lo'o cuhui' can', lo' mdyaa ne' xu'hue 'in Ndiose, a cunta nchcui' ne' cha' 'in cuhui' can' lo'o scasca ne' Jerusalén nu nta tsaan nu ntsu'hui cha' culo laa ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Xa cua' msu'hua ta jun cha' 'in jun tsaña'an nchcui' lee 'in Ñi X'nan na, xacan' mxitucui jun se'en lyi'ya loo Galilea, cui' quichen tyi jun se'en lca Nazaret. ");
INSERT INTO cya_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Cuhui' can' nguia nguilo cuhui', ndyija juesa 'in cuhui', nguia ndyu'hui cha' tiyaa 'in cuhui', a cunta lyee ndyu'hui cuiya' ti' Ndiose 'in cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nchgaa yjan ndyi'an nten cula 'in Jesús ta'a Pascua quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Xa ntsu'hui Jesús tichcua yjan ya lo'o jun 'in ñi se'en nchca ta'a quichen can', tsaña'an cha' nu cua' ntsu'hui 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lo' ña'aan mdyi ta'a can' mxitucui jun nde quichen tyi jun, una a ngujlyo ti' nten cula 'in Jesús si'yana nguinu ton ñi se'en lca Jerusalén, ");
INSERT INTO cya_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ñan ti' jun cha' ta yaan Jesús lja nten nu yaa ta'a can', lo' chcui tsaan cua' mda'an jun xa mdyisnan ngunan jun 'in Jesús lja nten nu ti' nchca ta'a jun, uta lja nchgaa la ña'an ta'a tsu'hue jun, ");
INSERT INTO cya_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","lo' a nguija lyoo ñi, can' cha' xiya' mxitucui jun nde Jerusalén nu nguia nan jun 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Una yato'o la mda'a cucha can' nguija lyoo jun 'in ñi ni' lyaa, nducua ñi lja yu nu m'ni cha'an cha' 'in lee, lo' ndon nscan ñi cha' nu nchcui' yu lo' ñicha' ñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nchgaa nu ne 'in cha' nu nchcui' ñi, nduhue ti' ne' si'yana tsu'hue cha' tiyaa nda'an lo'o ñi, lo' nchgaa cha' nxcuen ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Xa na'an jun 'in ñi nducua ñi lja yu can', yuhue 'a ti' jun lo' juin jyi'an ñi: Sñen', ¿ñi cha' m'ni lo'o hua cuaña'an? Ña'an jan ñi, nan' lo'o sti nda'an nan hua 'in, lo' lyee 'a msu'hua cha' nduhue ti' tiquee hua ");
INSERT INTO cya_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Xacan' mxcuen Jesús 'in jun: ¿Ñi cha' nda'an nan um 'ñan, ta a jlyo ti' um si'yana 'ni cha' 'ñan lo'o tñan 'in Stin? ");
INSERT INTO cya_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Una a ngu'ya jun cha' tiyaa ñi cha' ycui' ñi cuaña'an. ");
INSERT INTO cya_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Xacan' mxitucui ñi lo'o jun nde quichen Nazaret, lo' ncua ja'an ñi 'in jun lo'o nchgaa cha'. Nguinu yu'hui nchgaa cha' can' ni' cusya 'in jyi'an ñi. ");
INSERT INTO cya_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús nguia nguilo ñi, a cunta lo'o cha' tiyaa 'in ñi, lyee ndyu'hui cuiya' ti' Ndiose 'in ñi, ticui' cuaña'an ndyu'hui cuiya' ti' nten 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yato'o cui' yjan nu cua' nchca 'tñu nu ndlo yu Tiberio César tñan ña'aan quichen can', xacan' lca yu Poncio Pilato bsya se'en lyi'ya loo Judea, lo' yu Herode tetrarca ndlo tñan se'en lyi'ya loo Galilea, lo' yu Lpe ta'a ngula yu ndlo tñan se'en lyi'ya loo Iturea lo'o se'en lca Traconite, lo' yu Lisanias tetrarca ndlo tñan se'en lyi'ya loo Abilinia. ");
INSERT INTO cya_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yu Anás lo'o Caifás ndlo yu tñan ni' lyaa, cui' xacan' mxiycui' Ndiose 'in yu Xuhua, sñe' Zacaría, xa mda'an yu se'en ngutyi can'. ");
INSERT INTO cya_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mda'an yu luhua' se'en su chco tlyu Jordan, nchcui' yu lo'o nten si'yana xilo'o chon' ne' qui'ya ngui'ni ne' lo' chcua tya ne', lo' Ndiose cu'ni ñi cha' tlyu ti' 'in ne', ");
INSERT INTO cya_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","cui' tsaña'an nguinu scua cha' loo quityi nu ngua'an yu Isaía, yu nu mxiycui' Ndiose 'in cua' s'ni, lo' nchcui' na: —Ndeña'an nchcui' cueen yu nu nda'an se'en ngutyi can': Cu'ni chu'hue um tucueen nu caan Ñi X'nan na, lo' sla um sca tucueen nu ñi ti ni' cusya 'in um. ");
INSERT INTO cya_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nchgaa se'en lca lja yuu cha'an yu'hui na, lo' quinu lyicua nchgaa se'en nducua qui'ya, lo' tucueen nu nxiti'in ntsu'hui cha' ca ñi na, a cunta tucueen nu chen ña'an chca lyicua na. ");
INSERT INTO cya_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lo' ña'aan nten chendyu ca cuiya' ti' ne' si'yana Ndiose tca culo laa 'in ne'—. ");
INSERT INTO cya_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Qui'an 'a nten ndyi'an ne' se'en ndon yu Xuhua can' si'yana chcua tya ne', lo' ndeña'an nchcui' yu lo'o ne': 'Un ta nten nu cuiñi, ¿ti nu ngulo'o 'in um si'yana xnan yu'hui um, lo' a qui'ni ca'an 'in um lo'o cha' nsin' ti' nu tyi'o tiquee Ndiose tiyaa xaa? ");
INSERT INTO cya_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Can' cha' cu'ni um scasca tñan tsu'hue, lo' cuaña'an ca chcan' loo si'yana cua' mxilo'o chon' um qui'ya 'in um, lo' a quiñan ti' um: Cua' mdo'o laa hua si'yana Abraham lca nten cula 'in hua. Una cunen lo'o um sca cha' Ndiose tca xiton ñi quee ndu'hui re lo' ca na sñe' Abraham. ");
INSERT INTO cya_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A cunta cua' ndon tiyaa chcuan yca nu si'yu la suun yca, can' cha' nchgaa yca nu a ndyi'yu mti loo, xi'yu na lo' chu'hui na loo quii'. ");
INSERT INTO cya_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nten can' mñicha' ne' 'in yu Xuhua can': Huare' jan ñi, ¿ñi na ta cu'ni hua? ");
INSERT INTO cya_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Xacan' mxcuen yu: Nu ntsu'hui tucua ta ste', taa sca na 'in nu a ntsu'hui na 'in, ticui' cuaña'an lo'o nu ndi'in na nu najo'o 'in, ta yaa' can' 'in nu a ndi'in na 'in. ");
INSERT INTO cya_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lo'o tucua snan yu nu ndlo tñi mdiyaa can' si'yana chcua tya yu, lo' juin yu 'in yu Xuhua can': 'Un ñi nu lca Bstro, huare' jan ñi, ¿ñi na ta cu'ni hua? ");
INSERT INTO cya_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Xacan' mxcuen yu Xuhua can': A jñan um qui'an la tñi 'in nten, cui' tsaña'an nu ntsu'hui cha' su'hua lyiya' ti ne'. ");
INSERT INTO cya_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","A cunta lo'o tucua snan yu sindatu mñicha' yu 'in yu Xuhua can': Huare' jan ñi, ¿ña'an ta cu'ni hua? Juin yu Xuhua can': A culo um tñi 'in ne' lo'o juesa, uta su'hua um qui'ya 'in ne' lo'o cha' cuiñi, cui' ca nu quinu tsu'hue tiquee um lo'o tsaña'an siya' ti um. ");
INSERT INTO cya_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Si'yana nchgaa nten can' ñan ti' ne' cha' ta cui' yu Xuhua can' lca yu Cristo, ");
INSERT INTO cya_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","can' cha' mxcuen yu 'in nten can': Nan' nu cha' ñi lo'o tyi'a ti nducuan tyan 'in um, una ntsu'hui cha' caan sca ñi nu tla la cha' 'in que 'ñan nan', lo' tsu'hue 'a chu'hui tiqueen cha' cua na taa ñi cha' cuiya' xtin' tsa tisnan ti ñi. Can' ñi nu ntsu'hui cha' tucua tya 'in um, una lo'o Espíritu nu Luhui 'in Ndiose, a cunta lo'o quii'. ");
INSERT INTO cya_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Si'yana cua' nducua na yaa' ñi nu scuin trigo, lo' xo' ñi nu cua' nguhui can' lo' xu'hua se'en ñi 'in na, una quixin trigo can' su'hua ñi 'in na loo quii' nu a ntsu'hui cha' ti' tyuhui'. ");
INSERT INTO cya_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Qui'an 'a cha' ti' ycui' yu Xuhua lo'o nten can', mda cueen yu 'in ne' tsaña'an nguiaa cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yato'o ngusun lo'o yu Xuhua can' 'in Herode tetrarca, si'ya cha' nu ngulyaa yu 'in Herodía, cuilyi'o Lpe ta'a ngula yu, a cunta si'ya nchgaa la ña'an cha' ngunan' nu ngui'ni yu, ");
INSERT INTO cya_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","lo' si'i tsacua ti ña'an, cui' ca nu nde lyee la nguso' tucua yu qui'ya chon' yu si'yana msu'hua yu 'in Xuhua can' na'an chcuan. ");
INSERT INTO cya_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yato'o xa nducua tya nten can', lo'o Jesús mducua tya ñi, lo' lja nchcui' lyi'o ñi 'in Ndiose nguila tucua ni' cuaan, ");
INSERT INTO cya_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","can' ncua chcan' nguiaan Espíritu nu Luhui 'in Ndiose se'en ndon ñi, lo' ngu'ya tucua Espíritu can' que ñi tsaña'an ndyi'ya tucua sca scun' jo'o, lo' ngune ycui' sca nu ycui' la ni' cuaan: Nu'huin lca Sñen' nu ta'a lati 'ñan, tsu'hue 'a ntsu'hui tiqueen lo'o. ");
INSERT INTO cya_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús ntsu'hui ñi cla tyii yjan xa mdyisnan m'ni ñi tñan 'in Ndiose. Nchcui' nten si'yana See lca sti ñi, lo' sti See can' ncua naan Elí, ");
INSERT INTO cya_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","lo' sti Elí ncua naan Matat, sti Matat ncua naan Leví, sti Leví ncua naan Melqui, sti Melqui ncua naan Jana, sti Jana ncua naan See, ");
INSERT INTO cya_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","sti See ncua naan Matatía, sti Matatía ncua naan Amós, sti Amós ncua naan Nahum, sti Nahum ncua naan Esli, sti Esli ncua naan Nagai, ");
INSERT INTO cya_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","sti Nagai ncua naan Maat, sti Maat ncua naan Matatía, sti Matatía ncua naan Semei, sti Semei ncua naan See, sti See ncua naan Judá, ");
INSERT INTO cya_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","sti Judá ncua naan Joana, sti Joana ncua naan Resa, sti Resa ncua naan Zorobabel, sti Zorobabel ncua naan Salatiel, sti Salatiel ncua naan Neri, ");
INSERT INTO cya_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","sti Neri ncua naan Melqui, sti Melqui ncua naan Adi, sti Adi ncua naan Cosam, sti Cosam ncua naan Elmodam, sti Elmodam ncua naan Er, ");
INSERT INTO cya_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","sti Er ncua naan Josué, sti Josué ncua naan Eliezer, sti Eliezer ncua naan Jorim, sti Jorim ncua naan Matat, ");
INSERT INTO cya_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","sti Matat ncua naan Leví, sti Leví ncua naan Simeón, sti Simeón ncua naan Judá, sti Juda ncua naan See, sti See ncua naan Jonán, sti Jonán ncua naan Eliaquim, ");
INSERT INTO cya_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","sti Eliaquim ncua naan Melea, sti Melea ncua naan Mainán, sti Mainán ncua naan Matata, sti Matata ncua naan Natán, ");
INSERT INTO cya_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","sti Natán ncua naan Davi, sti Davi ncua naan Isaí, sti Isaí ncua naan Obed, sti Obed ncua naan Booz, sti Booz ncua naan Salmón, sti Salmón ncua naan Naasón, ");
INSERT INTO cya_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","sti Naasón ncua naan Aminadab, sti Aminadab ncua naan Aram, sti Aram ncua naan Esrom, sti Esrom ncua naan Fares, sti Fares ncua naan Judá, ");
INSERT INTO cya_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","sti Judá ncua naan Jacob, sti Jacob ncua naan Isaac, sti Isaac ncua naan Abraham, sti Abraham ncua naan Taré, sti Taré ncua naan Nacor, ");
INSERT INTO cya_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","sti Nacor ncua naan Serug, sti Serug ncua naan Ragau, sti Ragau ncua naan Peleg, sti Peleg ncua naan Heber, sti Heber ncua naan Sala, ");
INSERT INTO cya_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","sti Sala ncua naan Cainán, sti Cainán ncua naan Arfaxad, sti Arfaxad ncua naan Sem, sti Sem ncua naan Noé, sti Noé ncua naan Lamec, ");
INSERT INTO cya_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","sti Lamec ncua naan Matusalén, sti Matusalén ncua naan Enoc, sti Enoc ncua naan Jared, sti Jared ncua naan Mahalaleel, sti Mahalaleel ncua naan Cainán, ");
INSERT INTO cya_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","sti Cainán ncua naan Enós, sti Enós ncua naan Set, lo' sti Set ncua naan Adán nu lca sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús mtsa'an yu'hui ñi lo'o Espíritu 'in Ndiose xa mdo'o ñi chco tlyu Jordan can', lo' Espíritu mdu'hui tiquee ñi si'yana tsaa ñi sca se'en ngutyi, ");
INSERT INTO cya_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","can' yu'hui lyijyi ñi tsani' tucua yla tsaan, lo' ncua ti' laxa'an xityu 'in ñi loo qui'ya. Ñi sca na lo' a ycu ñi chcui lja xacan', xa mda'a tsaan can' mdyisnan ngute' ti' ñi. ");
INSERT INTO cya_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xacan' juin laxa'an 'in ñi: Cha' lca Sñe' Ndiose, cu'ni cha' si'yana quee ndu'hui re chca na jaslya. ");
INSERT INTO cya_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Una mxcuen Jesús: Ndeña'an nchcui' quityi 'in Ndiose: —Si'i tsaloo ti si'ya cha' nchcu ndyu'hui nten chendyu—, cui' ca nu si'ya nchgaa cha' nu nchcui' Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Xacan' ya lo'o laxa'an 'in ñi sca loo qui'ya cuaan, ticui' xaa can' ngulo'o 'in ñi ña'aan sca chcui chendyu se'en ndlo ne' tñan, ");
INSERT INTO cya_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","lo' juin 'in ñi: Ña'aan cha' cuiya' re tyaan cunta 'in lo' cui' cuaña'an lo'o cha' cuilyiya' taan 'in, si'yana tuyaan' nguinu nchgaa cha' re, lo' taan 'in na 'in nu nchca tin', ");
INSERT INTO cya_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","cha' nu'huin tyi'ya xtyin' tloon lo' cu'ni tnu 'ñan, nchgaa cha' re quinu na 'in. ");
INSERT INTO cya_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mxcuen Jesús: Tyi'o tso' siin' laxa'an, si'yana ndeña'an nchcui' quityi 'in Ndiose: —'In Ndiose X'nan ntsu'hui cha' cu'ni tnu, lo' scati 'in ñi ca ja'an—. ");
INSERT INTO cya_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Xacan' ya lo'o laxa'an 'in ñi quichen Jerusalén, lo' ycuen lo'o 'in ñi la que laa sca se'en cuaan lati, lo' juin 'in ñi: Cha' lca Sñe' Ndiose, tyi'o cuaan re lo' qui'ya ton la 'ya cua, ");
INSERT INTO cya_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","si'yana ndeña'an nchcui' quityi 'in Ndiose: —Culo ñi tñan 'in angujle 'in ñi si'yana chu'hui cunta 'in, ");
INSERT INTO cya_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","lo' su'hua yaa' can' 'in se'en nguiaa, si'yana a tsa ton quiya' loo quee—. ");
INSERT INTO cya_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Xacan' mxcuen Jesús: Ndeña'an nchcui' quityi 'in Ndiose: —A tyijyin lyoo 'in Ndiose X'nan—. ");
INSERT INTO cya_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Si'yana a ncua 'in laxa'an xityu 'in ñi loo qui'ya, mdo'o tso' sii' ñi sca co' xaa. ");
INSERT INTO cya_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús mxitucui ñi se'en lyi'ya loo Galilea, mtsa'an yu'hui ñi lo'o cha' cuiya' 'in Espíritu, lo' mdyisnan mscua cueen cha' 'in ñi sca chcui se'en can'. ");
INSERT INTO cya_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ngulo'o ñi 'in nten na'an se'en ndiyo' ti'in ne', lo' nchgaa tucui tsu'hue ntsu'hui tiquee lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús nguila ñi quichen Nazaret, quichen se'en ylo ñi, lo' tsaan nu nxitñan' ne' judio yten ñi se'en ndiyo' ti'in ne', tsaña'an cha' nu cua' ntsu'hui 'in ñi, lo' mdyiton ñi si'yana chcui' ñi quityi 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","mdaa ne' quityi 'in ñi se'en mxiycui' Ndiose 'in Isaía, msla ñi 'in na lo' nguija lyoo sca se'en nchcui': ");
INSERT INTO cya_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Mtsa'an yu'huin lo'o Espíritu 'in Ñi X'nan na, can' cha' ngulohui ñi 'ñan si'yana chcuin' cha' tsu'hue 'in ñi lo'o nu ti'i ña'an chendyu 'in, ngua'an tñan ñi 'ñan si'yana cu'ni chcan cusya 'in nu lu'un ti'. Chcuin' lo'o nu ntsu'hui nchcun si'yana tca tyi'o laa, slan quiloo nu cuityin', lo' culo laan 'in nu nsñi su'hua yaa' cui'in xa'an 'in. ");
INSERT INTO cya_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","A cunta chcuin' lo'o nten si'yana cua' ya tucua yjan nu cu'ni Ñi X'nan na sca cha' tsu'hue lo'o ne'—. ");
INSERT INTO cya_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Xacan' mxcun' ñi quityi can', mdyaa ñi 'in na 'in yu nu ntsu'hui cunta 'in na, yten tucua ñi lo' nchgaa nu ndiyo' ti'in can' nan' 'ya 'in ñi, ");
INSERT INTO cya_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","lo' juin ñi: Cua' ñii ya tucua tsaan ña'an nchcui' quityi re lo'o um. ");
INSERT INTO cya_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nchgaa ne' tsu'hue ndaa ne' suun cha' 'in ñi, nduhue ti' ne' si'yana tsu'hue 'a nguiaa cha' nu nchcui' ñi, lo' scasca ne' nchcui' ne': ¿Ta si'i sñe' yu See lca yu re? ");
INSERT INTO cya_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Xacan' juin ñi: A s'ni ntsu'hui nu ñan ti' cha' re lo'on: 'Un ne' nu n'ni rmiyu, cu'ni chca 'in ticuii', tsala ña'an qui'an cha' nu cua' ngune 'in hua m'ni quichen Capernaum, una cua' ñii cu'ni 'in na quichen tyi re. ");
INSERT INTO cya_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ti' juin la ñi: Nu cha' ñi cunen lo'o um, sca nu nxiycui' Ndiose 'in, a ndyijyi nu nducuan xu'hue 'in quichen tyi. ");
INSERT INTO cya_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Cha' ñi si'yana qui'an 'a ne' cuna'an Israel nguinu lo'o cha' ycui' ti lja mda'an ycui' Elía, xa nu a ngu'ya 'a quioo tsani' snan yjan tlu'hue, lo' lyee ngu'ya bju'ñan sca chcui se'en can', ");
INSERT INTO cya_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","una a ngua'an tñan Ndiose 'in yu Elía tsaa yu se'en ndi'in scasca ne' cuna'an can', cui' ca nu yaa yu quichen Sarepta se'en lyi'ya loo Sidón, se'en ndi'in sca ne' cuna'an nu nguinu lo'o cha' ycui' ti. ");
INSERT INTO cya_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Cui' cuaña'an xa mda'an yu Eliseo, yu nu mxiycui' Ndiose 'in, qui'an 'a nu ti'i lo'o quitso' la ndi'in quichen Israel, una ñi sca can' lo' a mchca, cui' ca nu scati yu Naamán mchca yu, yu nu mdo'o se'en lyi'ya loo Siria. ");
INSERT INTO cya_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nchgaa nu nguio' ti'in can' ycuen tique' lo'o ñi xa ngune 'in ne' cha' can', ");
INSERT INTO cya_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","cui' xaa mdyiton ne' lo' ngulo ne' 'in ñi nde tu'hua quichen, ya lo'o ne' 'in ñi loo qui'ya se'en chen ña'an, can' ncua ti' ne' xityu ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Una Jesús mdijin ñi tlu'hue la lja ne', mdo'o ñi nguiaa ñi. ");
INSERT INTO cya_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Xacan' mdo'o Jesús nguiaa ñi quichen Capernaum se'en lyi'ya loo Galilea, lo' ndlo'o ñi 'in nten tsaan nu nxitñan' ne'. ");
INSERT INTO cya_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nduhue 'a ti' ne' tsaña'an cha' nu ndlo'o ñi si'yana nchcui' ñi tsaña'an nchcui' sca nu nda'an lo'o cha' cuiya'. ");
INSERT INTO cya_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Se'en nguio' ti'in ne' nguilyu sca yu nu ntsu'hui cui'in xa'an 'in, ");
INSERT INTO cya_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","lo' nchcui' cueen yu: ¡A cu'ni lyi'o 'in hua! ¿Ñi cha' nducui ndijin loo hua, Jesús Nazaret? ¿Ta cua' ljyaan si'yana cujlyo 'in hua? Nan' ndyu'huin lyoon tucui lca, nu'huin lca ycui' ca nu mdo'o hui 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Una Jesús ngusun lo'o ñi 'in cui'in xa'an can', lo' juin ñi: Seen tyi'in, tyi'o se'en ntsu'hui cua. Cui' xaa mxitlyu cui'in xa'an can' 'in yu lja nten can', cui' ña'an lcaa mdyi'o cui'in xa'an can' 'in yu lo' a sca ti'i ncua 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yuhue 'a ti' nchgaa nu ndi'in can', lo' nchcui' ne': ¿Ñi cha' nchca ti' chcui' cha' re si'yana lo'o cha' cuiya' ndlo yu tñan 'in cui'in xa'an, lo' nchca ja'an 'in yu? ");
INSERT INTO cya_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Cui' xaa ti can' mscua cueen cha' 'in Jesús sca chcui se'en can'. ");
INSERT INTO cya_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Xacan' mdyi'o Jesús se'en ndiyo' ti'in ne', mdiyaa ñi la na'an 'in yu Tyo se'en nscua jyi'an laa yu ti'i si'yana lyee ndu'hui tique' 'in, lo' mjñan jun cha' tsu'hue 'in ñi si'ya ne'. ");
INSERT INTO cya_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mxiton Jesús se'en nscua ne' lo' ngusun lo'o ñi 'in tique' can', mdyi'o na 'in ne', cui' xaa mdyi tucui ne' lo' m'ni cunta ne' 'in jun. ");
INSERT INTO cya_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Xa msiin tsaan can' mdyisnan mdiya lo'o ne' 'in nu ti'i lo'o cuati loo quicha se'en ndon Jesús, cunda scaa ne' mdi'in tyaa ñi yaa' ñi 'in ne' lo' mchca ne'. ");
INSERT INTO cya_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A cunta qui'an nu mdo'o cui'in xa'an 'in, lo' nxi'ya cueen lo' nchcui': Nu'huin lca ycui' ca Sñe' Ndiose. Una ngusun lo'o ñi 'in cui'in can' lo' a mdaa 'a ñi cha' cuiya' ti' chcui', si'yana cua' jlyo ti' cui'in xa'an can' si'yana lca ñi ycui' ca Cristo. ");
INSERT INTO cya_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Xa cua' ngu'ya xaa mdo'o Jesús nguiaa ñi nde tu'hua quichen se'en scati ñi, una mdyisnan ngunan nten can' 'in ñi, xa mdiyaa ne' se'en ndon ñi ncua ti' ne' si'yana a tyi'o tso' ñi quichen can', ");
INSERT INTO cya_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","una juin ñi 'in ne': 'Ni cha' tsa ycuin' cha' tsu'hue 'in Ndiose scasca la quichen tsaña'an ntsu'hui cha' culo ñi tñan 'in ne', si'yana can' tñan ljyaan. ");
INSERT INTO cya_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Scasca se'en ndiyo' ti'in ne' judio se'en lyi'ya loo Galilea, mda'an ycui' ñi cha' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yato'o xa ndon Jesús tu'hua tiyo' Genesaret, lo' nten qui'an can' nsta su'hua ta'a ne' tloo ñi loo nu lyee lca tiquee ne' quine 'in ne' cha' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na'an ñi nducui tucua yca na'an cui' ti tu'hua tyi'a se'en ndlyu yu cuta cula ñjyi'an yu quitan 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Xacan' yten ñi ni' sca yca na'an cui' nu 'in yu Simón, mjñan ñi cha' tsu'hue 'in yu si'yana tcan' na'an chin' yu 'in na nde loo tyi'a can', yten tucua ñi lo' mdyisnan ngulo'o ñi 'in nten. ");
INSERT INTO cya_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Xa mdyi ycui' ñi lo'o ne', juin ñi 'in yu Simón can': Ya lo'o um yca na'an re 'in um la se'en tlya la cua, lo' cuun um quitan cua 'in um lo' xñi um cula. ");
INSERT INTO cya_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mxcuen yu Simón can' 'in ñi: 'Un ñi nu lca Bstro, chcui tla m'ni hua cuta lo' ñi sca cula a jui 'in hua, una cuun hua quitan re si'yana 'un ndlo um tñan 'in hua. ");
INSERT INTO cya_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Xa nguun yu 'in na qui'an 'a cula nguinu 'in yu, nu hasta lo'o mda' quitan can'. ");
INSERT INTO cya_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Xacan' m'ni yaa' ti yu 'in nu ntsu'hui ni' xca yca na'an can' si'yana can ta yaa' 'in yu. Cui' xaa mdiyaa yu lo' m'ni cha'an yu chcuaa yca na'an can', nu tichin' ti na a ngutyin' yu'hui na. ");
INSERT INTO cya_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yu Simón Tyo can' xa na'an yu cha' re mdyi'ya xtyin' yu tloo ñi lo' juin yu: Ñi X'nan, tyi'o tso' um siin' si'yana nan' lcan nten qui'ya chendyu. ");
INSERT INTO cya_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Si'yana qui'an cula msñi yu, lyee msu'hua yu cha' nduhue ti' tiquee yu lo'o nchgaa ta'a nda'an yu, ");
INSERT INTO cya_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","cui' cuaña'an lo'o chcuaa sñe' Zebedeo, yu Jacobo lo'o yu Xuhua, msu'hua yu cha' tiquee yu, cui' yu nu ta'a ngui'ni yu Simón can' tñan. Una Jesús juin ñi lo'o Simón can': A cutsen si'yana ti' cua' ñii tyisnan cu'ni cuta, tyicana 'in nten. ");
INSERT INTO cya_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Xacan' nchgaa yu ngulyo sti yu yca na'an can' la tu'hua ysin, mxnu yu nchgaa na 'in yu lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yato'o lja nguilyu Jesús sca quichen, mdiyaa ton sca yu qui'yu nu ngujlyo nguxen quitso' la 'in, lo' xa na'an yu 'in Jesús cui' xaa mdyi'ya xtyin' yu tloo ñi lo' mdyi'ya sti yu tloo yu la lyuu, mjñan yu cha' tsu'hue 'in ñi lo' juin yu: Ñi X'nan hua, cha' nchca ti' um tca cu'ni chca um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Xacan' mxñii ñi yaa' ñi lo' m'ni ca'an ñi 'in yu, lo' juin ñi: Nchca tin' cu'nin chcan 'in, quinu luhui. Ticui' xaa can' ngulyijyi quitso' la can' 'in yu lo' mchca yu. ");
INSERT INTO cya_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ngulo ñi tñan si'yana a chcui' yu lo'o ñi sca tucui cha' nu yato'o, tsaloo juin ti ñi 'in yu: Yaa, lo' culo'o 'in tloo nu ntsu'hui cunta 'in laa, taa sca lcuan tsaña'an nu ngulo Moisé tñan, cuaña'an ca cuiya' ti' nten si'yana cua' mchca. ");
INSERT INTO cya_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Una nde lyee la mscua cueen cha' 'in ñi, qui'an nten nguio' ti'in tloo ñi se'en nu ton nscan ne' cha' nu nchcui' ñi, a cunta si'yana cu'ni chca ñi 'in ne' lo'o quicha nu ntsu'hui 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Una Jesús la' ña'an ndyi'o ñi nchcui' lyi'o ñi 'in Ndiose se'en scati ñi. ");
INSERT INTO cya_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yato'o sca tsaan ndlo'o Jesús 'in nten, lja can' nducua tucua snan ne' fariseo lo'o yu nu m'ni cha'an cha' 'in lee, nu mdo'o scasca quichen se'en lyi'ya loo Galilea lo'o Judea, a cunta lo'o nu mdo'o quichen Jerusalén, lo' Jesús nda'an lo'o ñi cha' cuiya' 'in Ñi X'nan na nu cu'ni chca ñi 'in nten. ");
INSERT INTO cya_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Xacan' tucua snan yu qui'yu mdiya lo'o yu sca qui'ñan se'en nscua sca yu ti'i nu cuti ti' ña'aan, ncua ti' yu si'yana sten lo'o yu 'in la se'en ndon Jesús. ");
INSERT INTO cya_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Una a ncua sten yu si'ya nten qui'an can', can' cha' ycuen yu nde que na'an lo' msla yu sca se'en, can' mdyi'ya yu qui'ñan se'en nscua nu ti'i can' tlu'hue la se'en ndon Jesús. ");
INSERT INTO cya_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Xa na'an ñi si'yana lyee ndiya qui'an ti' yu nu mdyi'ya qui'ñan can', xacan' juin ñi 'in nu ti'i can': Ña'an jan ñi, cua' nguten qui'ya nducui. ");
INSERT INTO cya_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ne' escriba lo'o ne' fariseo cui' xaa mda'an cha' tiquee ne' lo' nguñan ti' ne': ¿Ta tnu 'a tiquee yu re ña'an nchcui' ca'an yu 'in Ndiose? ¿Ta si'i scati Ndiose nchca 'in ñi nxicuten ñi qui'ya? ");
INSERT INTO cya_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús ngu'ya ñi cha' tiyaa ña'an cha' nu ñan ti' ne', lo' juin ñi: ¿Ñi cha' ñan ti' um cuaña'an lo'o cha' nu ycuin' re? ");
INSERT INTO cya_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ti ña'an ta cha' nu a tucui la chcuin' lo'o yu ti'i re: Ta cunen lo'o yu cua' nguten qui'ya nducui, uta chcuin' lo'o yu, tyiton lo' quiaa? ");
INSERT INTO cya_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ña'an jan ñi, ca jlyo ti' um si'yana lo'on nan', Yu Qui'yu nu Mdo'o nde ni' Cuaan, ntsu'hui cha' cuiya' 'ñan xicuten qui'ya nducui nten chendyu, (xacan' juin ñi 'in yu ti'i can':) Nan' chcuin' lo'o, tyiton, xñi s'ñan lo' quiaa la na'an 'in. ");
INSERT INTO cya_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cui' xaa mdyiton yu tloo na'an nchgaa nten can', msñi yu s'ñan yu, mdo'o yu nguiaa yu nde ña'an 'in yu, lo' ngui'ni tnu yu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nchgaa ne' can' ndyijyin ya' yuhue ti' ne', lo' m'ni tnu ne' 'in Ndiose, msu'hua ne' cha' tiquee ne' lo' nchcui' ne': La ñii na'an na sca cha' nu tnu ca. ");
INSERT INTO cya_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Xa cua' mdijin cha' can' mdo'o Jesús nguiaa ñi, se'en mdijin ñi na'an ñi sca yu ndlo tñi nu naan Leví, nducua yu se'en nsu'hua lyiya' nten tñi, xacan' juin ñi 'in yu: Chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Cui' xaa mdyiton yu lo' mxnu yu nchgaa tñan can', lo' mducui ncha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","M'ni yu Leví cha' ncua sca ta'a la na'an 'in yu si'ya Jesús, a cunta tyun ta'a ndlo yu tñi nducua ycu yu can' tsatlyu lo'o ta'a tsu'hue yu. ");
INSERT INTO cya_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ne' escriba lo'o ne' fariseo mdyisnan nchcui' tyijyin ne' lo'o yu ta'a nda'an ñi, lo' nchcui' ne': ¿Ñi cha' nducua ycu um lo' ndyi'yo um tsatlyu lo'o yu ndlo tñi, lo'o yu nducun'? ");
INSERT INTO cya_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Xacan' mxcuen Jesús 'in ne': Nten nu a la 'in ti'i, a 'ni cha' 'in lo'o rmiyu, una nu ti'i, can' nu 'ni cha' 'in lo'o na. ");
INSERT INTO cya_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nan' a ljyaan si'ya nten nu a nducui qui'ya, cui' ca nu ljyaan si'ya nu nducui qui'ya si'yana xilo'o chon' ne' qui'ya ngui'ni ne'. ");
INSERT INTO cya_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Xacan' juin ne' 'in ñi: ¿Ñi cha' ta yu ta'a nda'an yu Xuhua la' nchgaa ti xaa n'ni yu ayuna lo' nchcui' lyi'o yu 'in Ndiose, cui' cuaña'an ta 'in ne' fariseo, una ñi cha' ta yu ta'a nda'an nu'huin nchcu yu lo' ndyi'yo yu? ");
INSERT INTO cya_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mxcuen ñi 'in ne': ¿Ta tca xicu'ni um 'in nu nda'an se'en ndyija cuilyi'o ne', lo' cu'ni can' ayuna lja nu ti' nducua yu nu ndyija cuilyi'o can'? ");
INSERT INTO cya_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tyicana tiyaa xaa, a la 'a quine cueen yu nu ndyija cuilyi'o re, la xacan' cu'ni can' ayuna. ");
INSERT INTO cya_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Xacan' mdi'in tyaa ñi sca cha' lo' juin ñi: A tucui nu nsi'yu tsa yu'hue te' tiji lo' nxcuan su'hua 'in na lo'o te' cula, si'yana cha' cu'ni ne' cuaña'an, cua' ngujlyo ne' te' tiji can', a cunta a nchcua ta'a te' tiji can' lo'o te' cula. ");
INSERT INTO cya_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Cui' cuaña'an a tucui nu nsu'hua vino nu tca mdo'o ni' sca cuijyin quijyin nu cua' cula, si'yana cha' cu'ni ne' cuaña'an, vino can' chcuen na lo' cu'ni na cha' cutsu quijyin can', tsato'o quilo vino lo' jlyo quijyin can'. ");
INSERT INTO cya_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Can' cha' ntsu'hui cha' chu'hui vino nu tca mdo'o ti ni' sca cuijyin quijyin nu tiji, lo' ñi vino lo' ñi quijyin can' a jlyo na. ");
INSERT INTO cya_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A cunta nu ndyi'yo vino nu cua' s'ni mdo'o, a ndyi'o tiquee can' co'o vino nu tca mdo'o ti si'yana ndeña'an nchcui' can': Tsu'hue la vino nu cua' s'ni mdo'o. ");
INSERT INTO cya_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yato'o sca tsaan nu nxitñan' ne' judio, mdijin xi'yu Jesús lo'o yu ta'a nda'an ñi sca loo jyaan se'en nducua trigo, mdyisnan mston yu 'in na, mycui yaa' yu 'in na si'yana tyi'o scua' na lo' cu yu mti na. ");
INSERT INTO cya_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tucua snan ne' fariseo juin ne' lo'o jun: ¿Ñi cha' ta ngui'ni um sca cha' nu a nga'an cha' cu'ni na tsaan nu nxitñan' na? ");
INSERT INTO cya_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mxcuen Jesús 'in ne': ¿Ta na a nchca chcui' um quityi tsaña'an nguinu scua sca cha' 'in yu Davi xa lyee ngute' ti' yu lo'o ta'a mda'an yu? ");
INSERT INTO cya_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yten yu se'en n'ni tnu ne' 'in Ndiose lo' msñi yu jaslya nu cua' ncuan 'in Ndiose, cui' jaslya nu nchcu tsalca yu nu ndlo tñan se'en can', una Davi ycu 'in na, a cunta mdaa yu 'in na 'in ta'a nda'an yu. ");
INSERT INTO cya_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Lo' juin ñi 'in ne': Yu Qui'yu nu Mdo'o nde ni' Cuaan, lo'o tsaan nu nxitñan' na lca Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yato'o xca tsaan, ticui' tsaan nu nxitñan' ne' judio, yten Jesús se'en n'ni tnu ne' 'in Ndiose, mdyisnan ngulo'o ñi 'in nten, lja can' ntsu'hui sca yu qui'yu nu ngutyi yaa' tso' cueen 'in. ");
INSERT INTO cya_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ne' escriba lo'o ne' fariseo nsñi ne' cunta 'in Jesús cha' ta cu'ni chca ñi 'in yu ti'i can' tsaan nu nxitñan' ne', ña'an ca si'yana su'hua ne' qui'ya 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Una Jesús ngu'ya ñi cunta cha' nu ntsu'hui tiquee ne', lo' juin ñi 'in yu nu ngutyi yaa' can': Tyiton lo' caan la tlu'hue re. Cui' xaa mdyiton yu lo' mdiyaa yu la se'en ndon ñi. ");
INSERT INTO cya_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xacan' juin Jesús 'in nten can': Cua' ñii cuñichan' 'in um sca cha': ¿Ñi tñan tca cu'ni na tsaan nu nxitñan' na, cha' nu tsu'hue uta cha' nu a tsu'hue? ¿Culo laa na 'in nten uta na taa na ya' caja ne'? ");
INSERT INTO cya_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Xacan' mxina'an ñi tyi'iin se'en ndi'in nten can', lo' juin ñi 'in yu ti'i can': Xñii yaa'. Cui' xaa mxñii yu 'in na lo' mchca tsu'hue na 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Una ne' fariseo lo'o ne' escriba lyee 'a msin' ti' ne', lo' nchcui' ne' cha' ña'an ca tyisnan su'hua ne' qui'ya 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yato'o sca tsaan ycuen Jesús sca loo qui'ya si'yana chcui' lyi'o ñi 'in Ndiose, can' ycui' lyi'o ñi 'in Ndiose chcui tla. ");
INSERT INTO cya_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Xa ngu'ya xaa msi'ya Jesús 'in nchgaa nu nducui ncha'an 'in ñi, ngulohui ñi 'in tsa tichcua yu ta'a tyi'an ca ñi, lo' ngulo'o naan ñi 'in yu apóstol si'yana tyi'an yu lo'o cha' cuiya' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ngulohui ñi 'in Simón, nu mdi'in tyaa ñi nii ca naan Tyo, lo'o yu Ndre ta'a ngula yu, lo'o Jacobo, yu Xuhua, yu Lpe lo'o yu Bartolomé, ");
INSERT INTO cya_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","yu Mateo, lo'o Toma, lo'o yu Jacobo sñe' Alfeo, yu Simón nu nchcui' ne' lo'o lca Zelote, ");
INSERT INTO cya_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","yu Juda ta'a ngula Jacobo, lo'o Juda Iscariote yu nu mdyaa 'in Jesús nde loo la. ");
INSERT INTO cya_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Xacan' mdo'o Jesús loo qui'ya can' nguila ñi sca se'en ntin' lo'o nchgaa ta'a nda'an ñi, a cunta can' nguio' ti'in qui'an nten nu mdo'o se'en lyi'ya loo Judea, lo'o quichen Jerusalén, lo'o luhua' nde 'ya la se'en ndi'in quichen Tiro lo'o Sidón, se'en nu quine 'in ne' cha' nu nchcui' ñi, lo' cu'ni chca ñi 'in ne' lo'o scasca quicha ntsu'hui 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Cui' cuaña'an mchca nchgaa nu ndijin nu ti'i si'ya cui'in xa'an nu ntsu'hui 'in. ");
INSERT INTO cya_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nchgaa nten can' nan ne' ña'an nu cula' ne' 'in ñi, si'yana lo'o cha' cuiya' nda'an lo'o ñi ngui'ni chca ñi 'in nchgaa nu ti'i. ");
INSERT INTO cya_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Xacan' mxina'an ñi se'en ndi'in ta'a nda'an ñi lo' juin ñi: Tsu'hue ca xu'hue 'un nu ti'i ña'an chendyu 'in, si'yana cua' jui cha' tsu'hue 'in um se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tsu'hue ca xu'hue 'un nu nguite' ti', si'yana cha'an yu'hui cusya 'in um tiyaa xaa. Tsu'hue ca xu'hue 'un nu nguinan, si'yana nde loo la re ca tsu'hue chu'hui tiquee um. ");
INSERT INTO cya_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tsu'hue ca xu'hue um xa caja nu xcuan tloo 'in um, uta caja nu culo tso' 'in um, ta taja ne' 'in um, lo' chcui' ne' cua' ña'an ti cha' 'in um, si'yana nguiaa um tso' 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ca tsu'hue chu'hui tiquee um lo' cha'an yu'hui um lo'o cha' nducui ti', si'yana tlyu cha' tsu'hue nu cua' jui 'in um la ni' cuaan, si'yana cui' cuaña'an m'ni nten cula 'in can' lo'o nchgaa nu mxiycui' Ndiose 'in cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Una 'tnan ca nchgaa 'un yu cuilyiya', si'yana a sca na ndiya lyijyi 'in um. ");
INSERT INTO cya_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","'Tnan ca 'un nu a ntsu'hui cha' nda'an ngute' ti', si'yana tiyaa xaa quite' ti' um. 'Tnan ca 'un nu nda'an nstyi cua' ñii, si'yana tiyaa xaa tyi'an ynan um. ");
INSERT INTO cya_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Una 'tnan ca um xa nchgaa tucui ndaa loo um, si'yana cuaña'an m'ni nten cula 'in can' lo'o yu nu mda'an ycui' cha' cuiñi, lo' nchcui' si'yana Ndiose mxiycui' 'in. ");
INSERT INTO cya_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Una chcuin' sca cha' lo'o um, 'un nu ndon nscan cha' re: Chu'hui cha' tsu'hue 'in um lo'o nu ti'i ti' 'in um, lo' cu'ni um tsu'hue lo'o nu nxcuan tloo 'in um, ");
INSERT INTO cya_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","cui' cuaña'an lo'o nu ndaja 'in um cu'ni um tsu'hue lo'o can', lo' jñan um 'in Ndiose si'ya cha' 'in nu na'an ti'i 'in um. ");
INSERT INTO cya_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Cha' ntsu'hui nu jyi'in sca tso' sca' um, taa um ya' jyi'in can' xca tso' na, lo' cha' nde'en nu culyaa te' tucuin nu lco' um, taa um ya' lyaa can' lo'o xcan' um. ");
INSERT INTO cya_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ña'an nu ti nu jñan na ndi'in 'in um tyaa um 'in na 'in, cui' cuaña'an cha' cui'ya na nu ndi'in 'in um, a tyi'an ñicha' um 'in na. ");
INSERT INTO cya_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tsaña'an nducua tloo um cu'ni nten lo'o um, cuaña'an ntsu'hui cha' cu'ni um lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Una cha' ntsu'hui cha' tsu'hue 'in um lo'o tsalca nu tsu'hue ntsu'hui tiquee lo'o um, ¿ñi cunta ntsu'hui 'in um xacan'? Si'yana cuaña'an nguiaa cha' 'in nten chendyu, ntsu'hui cha' tsu'hue 'in ne' lo'o tsalca nu tsu'hue ntsu'hui tiquee lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Cha' cu'ni um tsu'hue lo'o tsalca nu ngui'ni tsu'hue lo'o um, ¿ñi cunta ntsu'hui 'in um xacan'? Si'yana ticui' cuaña'an n'ni nten chendyu. ");
INSERT INTO cya_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Cha' taa um tñi jñi' tsalca nu tca xu'hua 'in na lo'o sñe' na, ¿ñi cunta ntsu'hui 'in um xacan'? Si'yana cuaña'an n'ni nten chendyu, ndaa can' tñi njñi' xca tucui si'yana nducua la na chcuan. ");
INSERT INTO cya_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Una 'un chu'hui cha' tsu'hue 'in um lo'o nu ti'i ti' 'in um, cu'ni um tsu'hue lo'o can', taa um na jñan can' siya' a nducua 'a tloo um ti' tyaa can' 'in na, cuaña'an ca tlyu la cha' tsu'hue nu qui'ni ca'an 'in um, lo' ca jlyo ti' nten si'yana lca um sñe' Ndiose, ñi nu tlyu lati, si'yana ngui'ni ñi 'tnan 'in nu lye' ti' lo'o nu nducun'. ");
INSERT INTO cya_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Can' cha' ña'an 'tnan ti' ta'a um tsaña'an nguiaa cha' 'in Stina Ndiose lo'o um. ");
INSERT INTO cya_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","A su'hua um qui'ya 'in xca tucui, lo' cuaña'an a caja nu su'hua qui'ya 'in um. A culo um yuhue' 'in xca tucui, lo' cuaña'an a caja nu culo yuhue' 'in um. Cu'ni um cha' tlyu ti' 'in ta'a nten um, cui' cuaña'an caja nu cu'ni cha' tlyu ti' 'in um. ");
INSERT INTO cya_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Taa um cha' tsu'hue 'in xca tucui, lo' cuaña'an caja nu taa cha' tsu'hue 'in um, sca cuiya' nu chcui lo' mtsa'an yu'hui, si'yana tsaña'an cuiya' nu ndaa um, cui' cuaña'an cuiya' caja nu tyaa 'in um. ");
INSERT INTO cya_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Xacan' mdi'in tyaa ñi sca cha' lo' juin ñi 'in nten can': ¿Ta tca 'in sca nu cuityin' tyi'an lo'o 'in xca nu cuityin'? ¿Ta si'i chcuaa can' tsato'o tyu yu'hui sca tuyuu? ");
INSERT INTO cya_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A sca nu ngui'ni cha'an, ta ndon loo la que 'in nu ndlo'o 'in, una nchgaa tucui nu tsu'hue m'ni cha'an, a s'ni tiyaa can' cuiya' 'in nu ndlo'o 'in. ");
INSERT INTO cya_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Ñi cha' nxñi um cunta yuu nu ntsu'hui quiloo ta'a nten um, lo' a n'ni cunta um ti' ña'aan co' yca nu ntsu'hui quiloo um? ");
INSERT INTO cya_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Ña'an ta xtyi ti' um chcui' um lo'o can': Tyaa um culyoon yuu nu ntsu'hui quiloo um, lo' a n'ni cunta um co' yca nu ntsu'hui quiloo um? 'Un ne' cuiñi, culo nducua la culyoo um co' yca nu ntsu'hui quiloo um, la xacan' ca chcan' 'in um culyoo um yuu nu ntsu'hui quiloo xca tucui. ");
INSERT INTO cya_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sca yca nu tsu'hue a tca cui'yu mti nu a tsu'hue loo na, cui' cuaña'an lo'o yca nu a tsu'hue, a tca cui'yu mti nu tsu'hue loo na. ");
INSERT INTO cya_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Si'yana cunda scaa yca nchca chcan' ña'an na si'ya mti nu ndyi'yu loo na, can' cha' a ntsu'hui cha' nsu ne' mti higo loo yca quiche', lo' ñi uva a nsu ne' 'in na loo yca quiche'. ");
INSERT INTO cya_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sca nten nu tsu'hue, chacui' cha' tsu'hue ndyi'o ni' cusya 'in can', cui' cuaña'an lo'o nu nducun', ticui' cha' nducun' ndyi'o ni' cusya 'in, si'yana cua' ña'aan cha' nu mtsa'an yu'hui ni' cusya 'in ne', can' cha' nu ndyi'o tu'hua ne'. ");
INSERT INTO cya_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Ñi cha' ndlo'o naan um 'ñan: Ñi X'nan hua, Ñi X'nan hua, lo' a nducua um tñan cha' nu nchcuin'? ");
INSERT INTO cya_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nchgaa nu nducui ncha'an 'ñan, lo' ndon nscan cha' nu nchcuin' lo' nducua tñan 'in na, ");
INSERT INTO cya_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","nguiaa cha' 'in can' tsaña'an nguiaa cha' 'in sca nten nu mtñan na'an 'in, mjñi can' qui'ñi lo' mdi'in tyaa suun 'in na loo quee, lo' xa mdo'o tyi'a yuu m'ni 'in na'an can', una a mdlyu na si'yana tsu'hue ndi'in suun na. ");
INSERT INTO cya_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Una tsalca nu ngune 'in cha' nu ycuin' lo' a nducua tñan 'in na, nguiaa cha' 'in can' tsaña'an nguiaa cha' 'in sca nten nu mtñan na'an 'in, una a mjñi se'en ndi'in suun na, lo' xa mdo'o tyi'a yuu m'ni 'in na'an can', cui' xaa mdlyu na lo' ngujlyo na ña'aan na. ");
INSERT INTO cya_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Xa mdyi ycui' Jesús lo'o nten can', mdo'o ñi nguiaa ñi quichen Capernaum. ");
INSERT INTO cya_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Can' nscua sca yu ti'i, cui' nguso 'in x'nan sindatu nu lyee ndyu'hui cuiya' ti' x'nan 'in, lo' cua' caja ti yu. ");
INSERT INTO cya_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","X'nan sindatu can' xa ynan yu cha' si'yana mdiyaa Jesús quichen can', cui' xaa mjñan yu cha' tsu'hue 'in tucua snan qui'yu cula nu ndon loo la 'in ne' judio, si'yana tsa te'en yu 'in Jesús lo' cu'ni chca ñi 'in yu nguso can'. ");
INSERT INTO cya_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Xa mdiyaa yu se'en ndon Jesús lyee 'a mjñan yu cha' tsu'hue 'in ñi, lo' nchcui' yu: Yu x'nan sindatu cua, ntsu'hui suun 'in yu ta yaa' um 'in yu, ");
INSERT INTO cya_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","si'yana nsu'hua loo yu quichen tyi na, a cunta cua' mtñan yu sca na'an se'en n'ni tnu na 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Xacan' mdo'o Jesús nguiaa ñi lo'o yu. Xa cua' tiyaa ti ñi se'en nducua na'an 'in yu x'nan sindatu can', cui' xaa ngua'an tñan yu chcua xnan ta'a tsu'hue yu nu ya ycua 'in ñi lo' chcui' yu lo'o Jesús: Ñi X'nan, a nchca tin' taan tñan 'in um lyee la, si'yana a ntsu'hui suun 'ñan tsaa um se'en ndi'in, ");
INSERT INTO cya_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","can' cha' a msti tin' tsa jñan cha' tsu'hue 'in um, una ñii tsaloo ti chcui' um sca cha' lo' chca nguso 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Si'yana lo'on nan' ntsu'hui x'nan, a cunta ndi'in sindatu nu ndlon tñan 'in, lo' xa cunen lo'o can': Nde se'en tsaa, lo' tsaa yu, uta chcuin' lo'o xca yu: Cuan lya, cui' xaa caan yu, uta chcuin' lo'o sca nguso 'ñan: Nde tñan cu'ni, cui' xaa cu'ni yu 'in na. ");
INSERT INTO cya_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Xa ngune 'in Jesús cha' can', yuhue 'a ti' ñi 'in yu, mxiton ñi ycui' ñi lo'o nten nu ljyan ncha'an 'in ñi: Ñi sca ne' Israel lo' a nchcua ta'a cha' 'in ne' lo'o yu re tsaña'an nu ndiya qui'an ti' yu 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Xa mxitucui yu nu ngua'an tñan x'nan sindatu can', na'an yu si'yana cua' mchca yu nguso can'. ");
INSERT INTO cya_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chon' nde'en can' mdo'o Jesús nguiaa ñi sca quichen naan Naín, tsatlyu lo'o nu ngui'ni cha'an 'in ñi lo'o nten qui'an can'. ");
INSERT INTO cya_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Xa cua' tiyaa ti ñi tulo'o tu'hua quichen can', mchcua ta'a ñi lo'o nten qui'an nu nguia tsi' 'in sca nu ngujui, lo' lca can' tyi ca ña'an sca sñe' ne' cuna'an nu nguinu lo'o cha' ycui' ti. ");
INSERT INTO cya_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ñi X'nan na xa na'an ñi ljyaan ne' cuna'an can', cui' xaa mña'an 'tnan ti' ñi 'in ne', lo' juin ñi lo'o: A cunan 'a um. ");
INSERT INTO cya_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Xacan' mdiyaa ñi cui' ti se'en ljyaan caja can', yla' ñi 'in na, lo' ycan' ton yu nu lyi'ya 'in na, lo' juin ñi 'in nu ngujui can': Nu'huin yu tsa suhue ti nan' nchcuin' lo'o, Tyitucui. ");
INSERT INTO cya_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Cui' xaa mdyitucua yu, mdyisnan ycui' yu, lo' mdyaa ñi cunta 'in yu 'in jyi'an yu. ");
INSERT INTO cya_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nchgaa nten can' ytsen ne' lo' m'ni tnu ne' 'in Ndiose, lo' nchcui' ne': La ñii ngulo ton Ndiose sca nu tlyu lati lja na nu nxiycui' ñi 'in. A cunta ntsu'hui nu nchcui': La ñii mdiyaan ycui' ca Ndiose nu culo laa quichen 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lo' ña'aan se'en lyi'ya loo Judea lo'o scasca quichen ndi'in cui' ti can' mscua cueen cha' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ta'a nda'an yu Xuhua can' mtsa' 'in yu nchgaa cha' nu yato'o can'. Xacan' msi'ya yu Xuhua can' 'in tucua ta'a nda'an yu, ");
INSERT INTO cya_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","lo' ngua'an tñan yu 'in si'yana tsa ñicha' 'in Jesús cha' cui' ca ñi lca ñi nu ntsu'hui cha' caan, uta quita yu 'in xca tucui. ");
INSERT INTO cya_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Xa mdiyaa chcuaa yu can' se'en ndon Jesús, juin yu 'in ñi: Yu Xuhua nu mducua tya 'in nten msu'hua yu 'in hua si'yana cuñicha' hua 'in um cha' cui' um lca um ñi nu ntsu'hui cha' caan, uta quita hua 'in xca tucui? ");
INSERT INTO cya_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ticui' xaa can' m'ni chca ñi 'in qui'an nu ti'i lo'o cuati loo quicha, lo'o nu ntsu'hui cui'in xa'an 'in, a cunta qui'an nu cuityin' msla ñi quiloo. ");
INSERT INTO cya_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Xacan' mxcuen Jesús 'in yu: Quia ytsa' um 'in yu Xuhua nchgaa cha' nu na'an um lo' ngune 'in um: —Nu cuityin' nguila xaa quiloo, nu co' quiya' cua' nchca ndyi'an—, nu ti'i lo'o quitso' la nguinu luhui, —lo'o nu cu'un cua' ne 'in—, ndyiqui'o nu ngujui, —lo' nu ti'i ña'an chendyu 'in ndyijyi nu nchcui' cha' tsu'hue 'in Ndiose lo'o—, ");
INSERT INTO cya_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","tsu'hue ca xu'hue nu a ngui'ni tucua ti' lo'on. ");
INSERT INTO cya_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Xa cua' mdo'o yu nu ngua'an tñan yu Xuhua can' nguiaa, xacan' mdyisnan ycui' ñi lo'o nten cha' 'in yu Xuhua: ¿Tucui ca 'in ya nan' 'ya um se'en ngutyi cua? ¿Ta 'in nu chin' cha' 'in tsaña'an nguiaa cha' 'in quii nu mcha ti'in cui'in? ");
INSERT INTO cya_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Cha' si'i, ¿tucui ca 'in ya nan' 'ya um xacan'? ¿Ta cui' 'in sca yu qui'yu nu lco' te' tsu'hue ña'an? Ña'an jan ñi, nu lco' te' tsu'hue ña'an nu nda'an lo'o cha' nducui ti' 'in, can' nu ndi'in na'an 'in ree. ");
INSERT INTO cya_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Tucui ca 'in ya na'an um cha' na can'? ¿Ta 'in yu nu nxiycui' Ndiose 'in? Cui' yu, una cunen lo'o um sca cha': Ndon loo lati can' que 'in sca nu nxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ndeña'an nchcui' quityi 'in Ndiose cha' 'in can': —Ña'an jan ñi, ca'an tñan 'in sca nu chcua loo, can' nu cu'ni chu'hue tucueen tsaa—. ");
INSERT INTO cya_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cunen lo'o um sca cha', a sca yu nu mxiycui' Ndiose 'in nu cua' yaan loo chendyu re, ta ndon loo la que ña'an yu Xuhua nu mducua tya 'in nten. Una cua' ñii nu chin' la cha' 'in se'en ndlo Ndiose tñan, can' nu lyee la ndon loo que 'in yu Xuhua can'. ");
INSERT INTO cya_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nchgaa nten lo'o yu nu ndlo tñi xa ngune 'in ne' cha' nu ycui' Jesús, cui' xaa ncua cuiya' ti' ne' si'yana ñi ndi'in cha' 'in Ndiose, lo' mducua tya ne' tsaña'an nu ngulo'o yu Xuhua can'. ");
INSERT INTO cya_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Una ne' fariseo lo'o nu m'ni cha'an cha' 'in lee, nde mxcuan tloo ne' cha' nu cua' mdi'in tyaa Ndiose lo'o ne', a mslyaa ne' chcua tya ne' tsaña'an ngulo'o yu Xuhua can'. ");
INSERT INTO cya_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Xacan' juin Ñi X'nan na: ¿Tucui ta lo'o tca cu'nin su'huan 'in ta nten re tsaña'an nu nguiaa cha' 'in ne'? ");
INSERT INTO cya_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nguiaa cha' 'in ne' re tsaña'an cha' 'in nu suhue ti nu ndyi'in jya loquiya', nxi'ya ta'a lo' nchcui': Yla hua cuhuii quii lo' a yla quiya' um, yla hua jyiin nu nguitsi' nten, lo' ñi a mdi'in ynan um. ");
INSERT INTO cya_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xa mdiyaan yu Xuhua nu mducua tya 'in nten, lo' si'yana a ycu yu jaslya ñi a yi'o yu vino, juin um si'yana cui'in xa'an ntsu'hui 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Una cua' ñii mdiyaan Yu Qui'yu nu Mdo'o nde ni' Cuaan, lo' si'yana nchcu yu lo' ndyi'yo yu, nchcui' um: Yu re lca yu sca yu tucun', yu cu'hui, lo' ta'a tsu'hue yu 'in yu ndlo tñi lo'o nten qui'ya chendyu. ");
INSERT INTO cya_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Una cha' tiyaa 'in Ndiose nchca chcan' loo na lo'o nchgaa nu lca sñe' ñi, lo' ca cuiya' ti' can' si'yana ñi ndi'in cha' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yato'o sca yu fariseo ya jñan cha' tsu'hue 'in Jesús si'yana tsa ycu ñi se'en ndi'in yu. Xa mdiyaa ñi la na'an 'in yu yten tucua ñi tu'hua msa can'. ");
INSERT INTO cya_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Cui' quichen can' ndi'in sca ne' cuna'an nducun', xa ncua jlyo ti' ne' si'yana ña'an 'in yu fariseo can' mdiyaa Jesús, xacan' mdiya lo'o ne' sca te'en tyi'a xityi'i, ");
INSERT INTO cya_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","lo' yten tucua ne' cui' ti se'en ndon quiya' Jesús, nguinan ne' lo' chon' quiya' ñi nguilo tucua tyi'a quiloo ne', nxityi ne' 'in na lo'o quichan' que ne', a cunta nchcui' cha' ne' quiya' ñi lo' nslo tucua ne' tyi'a xityi'i can' chon' quiya' ñi. ");
INSERT INTO cya_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Una yu fariseo nu ya te'en 'in Jesús xa na'an yu cha' can', ndeña'an nguñan ti' yu: Cha' cua na yu re lca yu nu nxiycui' ca Ndiose 'in, cui' xaa chu'hui lyoo yu lo' qui'ya yu cunta si'yana sca ne' cuna'an nducun' lca nu ngui'ni ca'an quiya' yu. ");
INSERT INTO cya_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Xacan' juin Jesús lo'o yu: Simón, cunen lo'o um sca cha'. Xacan' mxcuen yu: Chcui' um. ");
INSERT INTO cya_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Lo' juin ñi: Ndi'in tucua yu nu nducui tñi 'in sca yu cuilyiya', sca can' nducui qui'an tñi, tsaña'an tñi nu n'ni ne' canan ca'yu ciento tsaan, lo' xca can' nducui tsaña'an tñi nu n'ni ne' canan tu'hua tyi tsaan. ");
INSERT INTO cya_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Si'yana a ncua 'a 'in yu xu'hua lyiya' yu tñi can', m'ni yu cha' tlyu ti' 'in chcuaa yu can'. Ljuin ña'an na, ¿ti ña'an chcuaa yu can' lyee la lca tiquee yu lo'o yu cuilyiya' can'? ");
INSERT INTO cya_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mxcuen yu Simón can': Ñan tin' yu nu qui'an la tñi mducui can'. Xacan' juin ñi 'in yu: Cui' ña'an ycui'. ");
INSERT INTO cya_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Xacan' mxina'an ñi se'en nducua ne' cuna'an can' lo' juin ñi 'in yu Simón: ¿Ta cua' ngu'ya cunta ña'an ngui'ni ne' cuna'an re? Nan' yten ña'an 'in lo' a mdaa tyi'a quiten quiyan', una ne' cuna'an re mslo tucua ne' tyi'a quiloo ne' chon' quiyan' lo' mxityi ne' 'in na lo'o quichan' que ne'. ");
INSERT INTO cya_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A ycui' cha' 'ñan, una ne' cuna'an re ti' xa yten ña'an 'in, a ndla' ti' ne' nchcui' cha' ne' quiyan'. ");
INSERT INTO cya_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A msu'hua ceite quen, una ne' cuna'an re msu'hua ne' tyi'a xityi'i quiyan'. ");
INSERT INTO cya_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Can' cha' cunen lo'o, cua' nguten nchgaa qui'ya 'in ne' si'yana tlyu cha' tsu'hue cua' m'ni ne' lo'on, una nu a ndyu'hui lyoo qui'ya 'in chin' ti cha' tsu'hue ndyi'o tiquee can'. ");
INSERT INTO cya_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Lo' juin ñi 'in ne' cuna'an can': Cua' nguten qui'ya 'in. ");
INSERT INTO cya_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yu ta'a nducua ñi can' mdyisnan ycui' yu: ¿Tucui ta lca yu re nu lo'o nxicuten yu qui'ya 'in nten? ");
INSERT INTO cya_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Una ti' juin la ñi 'in ne' cuna'an can': Mdo'o laa si'yana ya qui'an ti' 'ñan, quiaa lyaa lo' a sca la cha' su'hua tiquee. ");
INSERT INTO cya_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chon' nde'en can' mdijin Jesús scasca quichen, mda'an ycui' ñi cha' tsu'hue 'in Ndiose tsaña'an ntsu'hui cha' culo ñi tñan 'in nten, mda'an ñi lo'o tsa tichcua yu can'. ");
INSERT INTO cya_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","A cunta lo'o tucua snan jun cuna'an nducui ncha'an 'in ñi, cui' nu cua' m'ni chca ñi 'in lo' ngulo ñi cui'in xa'an 'in: María nu naan Magdalena, nu mdo'o tsa cati cui'in xa'an 'in, ");
INSERT INTO cya_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","lo'o xca nu naan Juana, cuilyi'o yu Chuza, yu nu lyi'ya cunta tñan 'in Herode, lo'o Susana, a cunta lo'o scasca la jun cuna'an nu nda yaa' 'in ñi lo'o na nu ndi'in 'in jun. ");
INSERT INTO cya_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yato'o mdyisnan nguio' ti'in qui'an nten se'en ndon ñi, ne' nu mdo'o scasca quichen, xacan' mdyisnan ngulo'o ñi 'in ne', lo' mdi'in tyaa ñi sca cha' lo' nchcui' ñi: ");
INSERT INTO cya_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Sca yu qui'yu yta mti trigo, se'en msne yu 'in na tsachin' na nguilo na tu'hua tucueen, lo' jui nu ngulo su'hua 'in na, a cunta yaan quiñi lo' ycu 'in na. ");
INSERT INTO cya_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tichin' mti can' nguilo na sca se'en nu chin' ti yuu nducua loo quee, cua' ña'aan nducua na yaa nguityi na si'yana a tu'hua yuu se'en can'. ");
INSERT INTO cya_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tichin' mti can' nguilo na se'en nducua yca quiche', lo' si'yana tsatlyu nducua na lo'o yca quiche', can' cha' ngujui yu'hui na. ");
INSERT INTO cya_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Una tichin' mti can' nguilo na loo yuu tsu'hue, tsu'hue 'a mducua na lo' ncua tñan na, ntsu'hui juun nu mdaa sca ciento mti scati loo juun na. Lo' ña'aan mdyi ycui' Jesús cha' can', ycui' cueen ñi: Nchgaa nu ndon nscan cha' nu ycuin' re cu'ni cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Una yu ta'a nda'an ñi mñicha' 'in ñi: ¿Ñi cha' nchca ti' chcui' cha' nu ycui' um? ");
INSERT INTO cya_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Juin ñi 'in yu xacan': Cua' mdaa Ndiose cha' cuiya' qui'ya um cunta cha' nu ntsu'hui cutsi' 'in ñi tsaña'an nu ndlo ñi tñan. Una nchgaa la ña'an nten a nchcui' lan lo'o ne', —siya' lyee la ña'an ne' una a ndyi'ya ne' cunta, siya' lyee la ndon nscan ne' una a ndyi'ya ne' cha' tiyaa—. ");
INSERT INTO cya_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ndeña'an nguiaa cha' nu mdi'in tyaan can': Mti trigo can' lca na ycha' Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mti trigo nu nguilo tu'hua tucueen can', nguiaa cha' 'in na tsaña'an nguiaa cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, una cui' xaa ti ndyi'an laxa'an lo' ndlyoo cha' tsu'hue nu cua' ntsu'hui ni' cusya 'in ne', ña'an ca si'yana a tsa qui'an ti' ne' lo' a tyi'o laa ne'. ");
INSERT INTO cya_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mti nu nguilo loo yuu nu titi tu'hua nducua loo quee can', nguiaa cha' 'in na tsaña'an nguiaa cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, tsu'hue ntsu'hui tiquee ne' nducuan xu'hue ne' 'in na, una a ngu'ya xcua' na. Sca co' xaa ndiya qui'an ti' ne', una xa ndyijyin ne' scasca loo cha', cui' xaa ndyi'o tso' ne'. ");
INSERT INTO cya_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nu nguilo se'en nducua yca quiche' can', nguiaa cha' 'in na tsaña'an nguiaa cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, una si'ya cha' nduhue ti', ta cha' cuilyiya' lo'o scasca cha' nducun' nu nchcui ti' ne', can' nu ndujui xu'hua cha' tsu'hue can', lo' a ndyijyi 'a ña'an cuton na. ");
INSERT INTO cya_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Una nu nguilo loo yuu tsu'hue can', nguiaa cha' 'in na tsaña'an nguiaa cha' 'in nten nu ne 'in cha' tsu'hue 'in Ndiose, tsu'hue nxu'hua se'en ne' 'in na lo'o sca cusya nu ñi, lo' tsu'hue nchca tñan na si'yana nxñi ton ne' 'in ne' loo cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A tucui nu ca'an sca quii' lo' nde tucun ti'in 'in na, uta su'hua 'in na nde ni' qui'ñan, cui' ca nu tyi'in tyaa 'in na sca se'en cuaan, si'yana tu'hui na xaa 'in nu sten ña'an can'. ");
INSERT INTO cya_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Cui' cuaña'an lo'o sca cha' nu nchca cunan ti, a s'ni ca chcan' loo na tiyaa xaa, lo' cuaña'an ndi'in cha' 'in sca cha' nu nchca cutsi' ti, a tyijyin yu'hui cha' a tyi'o scua la cha' 'in na. ");
INSERT INTO cya_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Can' cha' xñi um cunta nchgaa cha' nu ne 'in um, si'yana nten nu n'ni cunta cha' nu nchcuin', nde lyee la ndyijyi cha' tiyaa 'in can', una nu a n'ni cunta cha' re, lo'o cha' tiyaa nu ñan ti' cua' jui 'in, ndlyaa ñi 'in na. ");
INSERT INTO cya_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xacan' mdiyaa jyi'an Jesús lo'o ta'a ngula ñi se'en nguilyu ñi, una a ncua sten jun la se'en ndon ñi si'ya nten qui'an can'. ");
INSERT INTO cya_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jui nu mtsa' 'in ñi: Tuna'an lyiya' cua ndon ñi jyi'an um lo'o ta'a ngula um, nchca ti' jun chcui' jun lo'o um. ");
INSERT INTO cya_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Xacan' juin ñi 'in nten can': Tsalca nu ndon nscan cha' 'in Ndiose lo' nxu'hua se'en 'in na, can' nu lca jyi'an nan' lo' can' nu lca ta'a ngulan. ");
INSERT INTO cya_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yato'o sca tsaan yten Jesús lo'o yu ta'a nda'an ñi sca ni' yca na'an, lo' juin ñi 'in yu: Tyijyin xi'yu na xca tso' tiyo' re. Lo' mdo'o jun nguiaa jun. ");
INSERT INTO cya_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Una lja nguiaa jun loo tyi'a can' ngu'ya sla ñi. Tsati ntyin yaan sca cui'in tnu, lo' chen nchcui 'in jun si'yana cua' mdyisnan nguiten tyi'a 'in yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ngulyoo yu sla ñi, lo' juin yu 'in ñi: Ñi Bstro, Ñi Bstro, cua' quityin' yu'hui ti na. Xacan' mdyiton ñi lo' ngusun lo'o ñi 'in cui'in can' lo'o tiyo' nu lyee nguitsa can', cui' xaa ngulyijyi na lo' mdi'in seen na. ");
INSERT INTO cya_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Xacan' juin ñi 'in yu: ¿Ta na a ndiya qui'an ti' um 'ñan? Una scaña'an ti ndi'in ytsen yu, nduhue ti' yu lo' ñicha' ta'a yu: ¿Tucui ta lca ñi re, ñi cha' lo'o cui'in lo'o tyi'a ndlo ñi tñan 'in na, lo' ja'an na 'in ñi? ");
INSERT INTO cya_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xacan' mdyi'o ti'in jun loo yuu 'in ne' Gadara, cui' luhua' xca tso' se'en lyi'ya loo Galilea. ");
INSERT INTO cya_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lo' ña'aan mdyi'o ton Jesús tu'hua tyi'a can', yan ycua sca yu Gadara se'en ndon ñi, yu nu cua' s'ni 'a ntsu'hui cui'in xa'an 'in, a nchco' 'a yu ste' yu, a cunta a ndyi'in 'a yu ña'an 'in yu, cui' ca nu ni' lyi'o se'en nguitsi' nten ndlyu yu nchgaa xaa. ");
INSERT INTO cya_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yu re xa na'an yu 'in Jesús, msi'ya yja cueen yu, mdyi'ya xtyin' yu tloo ñi, lo' ycui' cueen yu: Jesús, Sñe' Ndiose, ñi nu tlyu lati nu nducua ni' cuaan, ¿ñi na lca 'in um lo'on? Jñan sca cha' tsu'hue 'in um a xitijin um 'ñan nu ti'i. ");
INSERT INTO cya_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Lo' mdyisnan ngulo ñi tñan 'in cui'in xa'an can' si'yana cula' ton 'in yu, si'yana cua' s'ni 'a ngui'ni lyi'o 'tnan cui'in xa'an can' 'in yu. Tyun 'a ya' mscan' ne' yaa' yu lo'o quiya' yu lo'o carena, una msi'yu yu 'in na, chacui' se'en ngutyi ndyi'an lo'o cui'in xa'an can' 'in yu.) ");
INSERT INTO cya_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mñicha' Jesús 'in yu: ¿Ña'an ta naan? Xacan' mxcuen yu: Legión naan hua. Cui' si'yana qui'an 'a cui'in xa'an ntsu'hui 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Cui'in xa'an can' mjñan cha' tsu'hue 'in ñi si'yana a su'hua ñi 'in sca se'en qui'ñi. ");
INSERT INTO cya_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Cui' sii' qui'ya can' nda'an nan ycu sca ta tlyu cuhue', lo' mjñan cui'in xa'an can' 'in Jesús cha' taa ñi cha' cuiya' sten 'in cuhue' can', lo' mdaa ñi cha' cuiya'. ");
INSERT INTO cya_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ña'aan mdyi'o cui'in xa'an can' 'in yu yten se'en ndi'in cuhue' can', tsatlyu mdo'o 'in msnan 'in, lo' mxityu loo 'in loo tiyo', can' ngujui yu'hui 'in. ");
INSERT INTO cya_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yu nu na'an seen cuhue' can', xa na'an yu cha' nu yato'o, cui' xaa msnan yu nguia ytsa' yu 'in nten ndi'in quichen can' lo'o nten nga'an ni' quixin'. ");
INSERT INTO cya_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mdo'o ne' ya na'an ne' cha' nu yato'o can', mdiyaa ne' se'en nducua Jesús, na'an ne' 'in yu nu yu'hui cui'in xa'an 'in nducua yu tloo ñi, cua' lco' yu ste' yu, ntsu'hui chcui cha' tiyaa 'in yu, lo' ytsen 'a ne'. ");
INSERT INTO cya_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nchgaa nu na'an cha' can' mdaa suun lo'o nten nu mdiyaa can', ña'an mchca yu nu yu'hui cui'in xa'an 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Xacan' nchgaa nten nu mdo'o chcua tyi'in tso' se'en lyi'ya loo Gadara, mjñan ne' cha' tsu'hue 'in ñi si'yana tyi'o tso' ñi se'en can' loo nu lyee nguitsen ne'. Jesús yten ñi ni' yca na'an can', lo' mxitucui ñi nguiaa ñi. ");
INSERT INTO cya_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yu nu qui'an 'a cui'in xa'an yu'hui 'in can', mjñan yu cha' tsu'hue 'in ñi cha' tca chcui ncha'an yu 'in ñi, una Jesús msla' ñi 'in yu, lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Quiaa nde ña'an 'in, lo' taa suun tsala ña'an tlyu cha' tsu'hue m'ni Ndiose lo'o. Mdo'o yu nguiaa yu lo' mdaa yu suun ña'aan loo quichen can' tsala ña'an tlyu cha' tsu'hue m'ni Jesús lo'o yu. ");
INSERT INTO cya_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Xa nguila Jesús se'en ndi'in nten qui'an can', tsu'hue 'a ntsu'hui tiquee ne' ncuan xu'hue ne' 'in ñi, si'yana cua' ndi'in ta ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lja xacan' mdiyaa sca yu naan Jairo, yu nu ndlo tñan se'en ndiyo' ti'in ne' Judio, mdyi'ya xtyin' yu tloo Jesús lo' mjñan yu cha' tsu'hue 'in ñi si'yana tsaa ñi la se'en ndi'in yu, ");
INSERT INTO cya_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","si'yana cua' caja ti nu cuna'an sñe' yu, tyi ca ña'an sca can' ndi'in 'in yu, lo' ntsu'hui tichcua yjan. Tucueen nguiaa ñi lo'o yu msta su'hua ta'a nten si'ya ñi. ");
INSERT INTO cya_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Cui' lja can' nguiaa sca ne' cuna'an nu cua' ntsu'hui tichcua yjan ti'i lo'o quicha nguilo tne, cua' ngulyijyi ne' ña'aan tñi 'in ne' lo'o nu n'ni rmiyu, una ñi sca can' lo' a ncua 'in cu'ni chca 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ne' cuna'an can' yaan ne' cui' ti nde chon' Jesús lo' yla' ne' tu'hua ste' ñi, cui' xaa ngulyijyi ylo tne 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Xacan' juin Jesús: ¿Ti nu ca m'ni ca'an 'ñan? Nchgaa nten can' juin ne' si'yana a tucui, xacan' mxcuen yu Tyo lo'o nchgaa ta'a nguiaa yu: Ñi Bstro, jlyo ti' um tsala ña'an qui'an nten nsta su'hua 'in um, lo' ti' nchcui' um: ¿Ti nu ca m'ni ca'an 'ñan? ");
INSERT INTO cya_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lo' ti' juin la Jesús: Ntsu'hui nu m'ni ca'an 'ñan, si'yana ngüi tin' mdo'o juesa 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Xa na'an ne' cuna'an can' si'yana a ncua su'hua cutsi' ne' cha' nu m'ni ne', mdyisnan mchcuan ne' xa mdiyaa ne' tloo ñi, mdyi'ya xtyin' ne', tloo ndi'in nten can' mdaa ne' suun lo'o ñi ña'an yla' ne' ste' ñi lo' ticui' xaa mchca ne'. ");
INSERT INTO cya_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lo' juin ñi 'in ne': Sñen', cua' mchca si'yana ya qui'an ti' 'ñan, quia lya lo' a sca cha' chu'hui tiquee. ");
INSERT INTO cya_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Can' ca cha' ti' ndon ycui' ñi xa mdiya ytsa' sca yu nu mdo'o la na'an 'in yu nu ndlo tñan can', lo' juin yu: Cua' ngujui sñe' um, a najo'o 'a ti' chcui' um lo'o ñi re tsaa ñi. ");
INSERT INTO cya_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Xa ngune 'in Jesús cha' nu ycui' yu can', juin ñi 'in yu nu ndlo tñan can': A cutsen um, tsaloo ti tsa qui'an ti' um 'ñan lo' chca sñe' um. ");
INSERT INTO cya_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Xa mdiyaa ñi la na'an 'in yu, a mdaa ñi ya' sten ña'an nu ti, tsa yu Tyo ti, yu Jacobo lo'o yu Xuhua, a cunta lo'o nten cula 'in cuhui' can'. ");
INSERT INTO cya_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nchgaa nten can' ndi'in ynan ne' si'ya cuhui' can', lo' juin ñi 'in ne': A cunan um, cuhui' re si'i na ngujui cuhui', na lja' ti cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nten can' mstyi lyi'o ne' 'in ñi, si'yana jlyo ti' ne' na ngujui cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Una Jesús msñi ñi yaa' cuhui', lo' ycui' cueen ñi: Sñen', tyitucui. ");
INSERT INTO cya_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Cui' ña'an lcaa nguila cusya 'in cuhui' lo' mdyi tucui cuhui', xacan' ycui' ñi lo'o jun si'yana taa jun na cu cuhui'. ");
INSERT INTO cya_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nten cula 'in cuhui' ndyijyin ya' yuhue ti' jun cha' can', una Jesús ngulo ñi tñan 'in jun si'yana a chcui' jun lo'o ñi sca tucui cha' nu yato'o. ");
INSERT INTO cya_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Xacan' mxo' ti'in Jesús 'in tichcua yu ta'a nda'an ñi, lo' mdaa ñi cha' cuiya' 'in yu si'yana tca culo yu nchgaa loo cui'in xa'an nu ntsu'hui 'in nten, lo' cu'ni chca yu 'in nu ti'i lo'o cuati loo quicha. ");
INSERT INTO cya_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xacan' ngua'an tñan ñi 'in yu si'yana tsa ycui' yu ña'an ntsu'hui cha' culo Ndiose tñan 'in nten, a cunta si'yana cu'ni chca yu 'in nu ti'i. ");
INSERT INTO cya_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Lo' juin ñi 'in yu: Ñi sca na lo' a cui'ya um se'en tsaa um, ñi yca lo' a chcua yaa' um, ñi cuijyin, ñi na cu um, ñi tñi a cui'ya um, lo' ñi a cui'ya um xca ta ste' um. ");
INSERT INTO cya_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Quichen se'en tiyaa um, cha' nde'en nu taa se'en quinu um, can' tyi'in um tsalja ndi'in um quichen can'. ");
INSERT INTO cya_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Cha' nten can' a cuan xu'hue ne' 'in um, tyi'o um quichen can' lo' scuin um yuu quiya' um, cuaña'an quinu cunta 'in ne' cha' nde'en la cha' nu caan 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Xacan' mdo'o yu nguiaa yu lo' mdijin yu scasca quichen suhue ti, mda'an ycui' yu cha' tsu'hue 'in Ndiose, lo' m'ni chca yu 'in nu ti'i scasca se'en can'. ");
INSERT INTO cya_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yu Herode nu ndlo tñan can', xa ynan yu cha' ña'an ngui'ni Jesús, msu'hua yu cha' tiquee yu si'yana ntsu'hui nu nchcui' si'yana yu Xuhua can' cua' mdyiqui'o yu, ");
INSERT INTO cya_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","a cunta ntsu'hui xca nu nchcui' si'yana Elía cua' ngulo'o tloo 'in ne', lo' ntsu'hui xca nu nchcui' si'yana lca ñi scasca la nu mxiycui' Ndiose 'in cua' s'ni, lo' cua' ñii mdyiqui'o can'. ");
INSERT INTO cya_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Xacan' juin yu Herode: Una nan' ngulon tñan msi'yu yni yu Xuhua can', ¿tucui ta lca nu nchcui' nten cua cha' 'in? Can' cha' nchca ti' yu chu'hui lyoo yu 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Xa nguila yu ta'a mda'an Jesús, mdaa yu suun lo'o ñi nchgaa cha' nu m'ni yu se'en yaa yu. Xacan' mdo'o lo'o ñi 'in tsalca ti yu, sca se'en nu cua' ntan la tu'hua quichen Betsaida. ");
INSERT INTO cya_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Una nten nu nguinu ti'in can' xa ngujlyo ti' ne' la tucueen nguiaa ñi, mducui ncha'an ne' 'in ñi, cui' xaa ncuan xu'hue ñi 'in ne', lo' ycui' ñi lo'o ne' ña'an ndlo Ndiose tñan 'in nten, a cunta m'ni chca ñi 'in nchgaa nu ntsu'hui quicha 'in. ");
INSERT INTO cya_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Xa msiin tsaan can' mdiya ycui' yu ta'a nda'an ñi lo'o ñi: Chcui' um lo'o nten re si'yana cunan ne' se'en quinu ne' se'en ndi'in scasca quichen uta se'en nga'an nten ni' quixin', can' caja na cu ne' si'yana tijyo' nguilyu na re. ");
INSERT INTO cya_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Juin ñi 'in yu xacan': 'Un xicu um 'in ne'. Mxcuen yu 'in ñi: Una seen ca'yu ti jaslya nda'an lo'o hua lo'o tucua ti cula, uta na nchca ti' um tsa si'i hua na nu cu nten qui'an re. ");
INSERT INTO cya_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsalca yu qui'yu can' ndiyaa yu ca'yu mii yu. Xacan' juin ñi 'in yu ta'a nda'an ñi: Cu'ni um cha' chcua nten re cunda tu'hua tyii ne'. ");
INSERT INTO cya_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cuaña'an m'ni yu cha' yten tucua nchgaa nten can'. ");
INSERT INTO cya_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Xacan' msñi Jesús ta'a ca'yu jaslya lo'o chcua cula can', lo' mscuen ñi tloo ñi nde cuaan, mdyaa ñi xu'hue 'in Ndiose, xacan' msu'hue ñi 'in na, lo' mdaa ñi 'in na 'in yu ta'a nda'an ñi si'yana cutsa yu 'in na. ");
INSERT INTO cya_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nchgaa ne' ycu ne' tsaya' ngula' ti' ne', lo' na nu nguinu can' ti' m'ni cha'an yu cha tichcua xcuhui lo'o na. ");
INSERT INTO cya_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yato'o lja nchcui' lyi'o Jesús 'in Ndiose scati ñi, una lo'o yu ta'a nda'an ñi nguilyu can', lo' mñicha' ñi 'in yu: ¿Tucui ta lcan nan' nchcui' nten? ");
INSERT INTO cya_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mxcuen yu 'in ñi: Ntsu'hui nu nchcui' si'yana lca um yu Xuhua nu mducua tya 'in nten, lo' ntsu'hui nu nchcui' si'yana lca um yu Elía, a cunta ntsu'hui xca nu nchcui' si'yana lca um sca yu nu mxiycui' Ndiose 'in cua' s'ni, lo' cua' ñii mdyiqui'o can'. ");
INSERT INTO cya_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Xacan' juin ñi 'in yu: Lo' 'un jan ñi, ¿tucui ñan ti' um lcan nan'? Mxcuen yu Tyo can': 'Un lca um ycui' ca Cristo nu mdo'o se'en nducua Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Una tla cha' mdi'in tyaa ñi lo'o yu si'yana a chcui' yu cha' re lo'o ñi sca tucui. ");
INSERT INTO cya_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Juin ñi 'in yu: Yu Qui'yu nu Mdo'o nde ni' Cuaan, qui'an 'a nu ti'i ntsu'hui cha' tyijyin ñi, ntsu'hui cha' xcuan tloo qui'yu cula 'in ñi, cui' cuaña'an lo'o yu nu ndlo ca tñan ni' lyaa lo'o ne' escriba, cunan ne' ña'an cujui ne' 'in ñi, una nu cua' ca snan tsaan ntsu'hui cha' tyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xacan' tsatlyu ycui' ñi lo'o nten can': Cha' nde'en nu nchca ti' chcui cha'an 'ñan, 'ni cha' jlya ti' can' 'in, lo' nu chcui ncha'an 'ñan, tyaa can' 'in siya' ti. ");
INSERT INTO cya_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Si'yana nchgaa nu ñan ti' culo laa 'in, tsato'o quinan' can' tiyaa xaa, una nchgaa nu tyaa chendyu 'in 'ñan, can' nu tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Si'yana ñi canan chu'hui 'in ne' cu'ni 'in ne' ña'aan chendyu, lo' tsato'o jlyo ne' uta tnan' ne' 'in ne'? ");
INSERT INTO cya_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Si'yana nu xijyi'o ti' lo'on nan' uta lo'o cha' nu nchcuin', cui' cuaña'an Yu Qui'yu nu Mdo'o nde ni' Cuaan xijyi'o ti' ñi lo'o can' xa quiaan ñi xiya' lo'o cha' cuiya' 'in ñi, tsatlyu lo'o cha' cuiya' 'in Stina Ndiose lo'o angujle nu luhui 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nu cha' ñi cunen lo'o um, ntsu'hui nu ndlyu re, a caja cha' si'i culo nducua la ña'an tloo cha' cuiya' 'in Ndiose tsaña'an nu ntsu'hui cha' culo ñi tñan. ");
INSERT INTO cya_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yato'o nu cua' nchca snu' tsaan ycui' ñi cha' can', mdo'o lo'o ñi 'in yu Tyo, yu Xuhua lo'o Jacobo, lo' ycuen jun sca loo qui'ya si'yana chcui' lyi'o ñi 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lja nchcui' lyi'o ñi 'in Ndiose mcha'an ña'an tloo ñi, lo' ste' ñi nguinu nduhui na tsu'hue ña'an mten na. ");
INSERT INTO cya_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Can' ngu'ya ton tucua yu qui'yu nu ndaa cha' lo'o Jesús, cui' Moisé lo'o Elía, ");
INSERT INTO cya_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","msu'hua lo'o sca xaa nu tsu'hue ña'an 'in jun, lo' ndaa jun cha' ña'an ntsu'hui cha' caja ñi quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yu Tyo can' lo'o ta'a nducua yu lyee 'a ndyu'hui sla yu, una mdaa loo yu a yja' yu, na'an tloo yu xaa nu tsu'hue 'a ña'an can' 'in Jesús lo'o chcuaa yu ta'a ndon ñi. ");
INSERT INTO cya_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ña'aan xa ngula' ton chcuaa yu can' 'in Jesús, xacan' juin yu Tyo can' lo'o ñi: Ñi Bstro, tsu'hue si'yana ndi'in hua lo'o um re, nde tñan hua snan quisin, sca na tyi'in um, xca na 'in Moisé, lo' xca na tyi'in Elía. Juin yu cuaña'an si'yana a ngujlyo 'a ti' yu ñi cha' ti' chcui' yu. ");
INSERT INTO cya_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lja nu ti' nchcui' yu cha' can', ngu'ya ti'in ndlaa lo' ngo'o yu'hui na 'in jun, lo' ytsen yu xa mchcun yu'hui yu ni' ndlaa can'. ");
INSERT INTO cya_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ti' la ni' ndlaa can' jui nu ycui': Nde Sñen' nan' nu ta'a lati 'ñan, quine 'in um cha' nu chcui' re. ");
INSERT INTO cya_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Una xa mdyi ycui' can', xca ti Jesús nguinu ton ñi, lo' yu ta'a nda'an ñi x'ni 'a msu'hua cutsi' yu cha' nu na'an tloo yu can'. ");
INSERT INTO cya_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Xca tsaan can' mdo'o jun loo qui'ya can', tucueen yaan jun qui'an 'a nten ya ycua 'in jun. ");
INSERT INTO cya_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lja nten can' mdo'o ycui' cueen sca yu qui'yu: Ñi Bstro, jñan sca cha' tsu'hue 'in um cu'ni cunta um 'in yu lyo' ti re 'ñan, si'yana tyi ca ña'an sca yu 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Xa nxñi cui'in 'in yu, tsati ntyin nxi'ya yja yu, nscuin ti'in na 'in yu lo'o juesa, nchcua ngoo' tu'hua yu, lyee nsuhue' sti na 'in yu, lo' que' 'a ti' ndla na 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cua' mjñan cha' tsu'hue 'in yu ta'a nda'an um si'yana culo yu cui'in can' 'in sñen', una a ncua 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Xacan' juin Jesús 'in nten can': 'Un lca um nten nu a ndiya qui'an ti', lo' lye' ti'. ¿Ta re ti ña'an ndi'in lo'o um tsala xaa? Can lo'o um 'in sñe' um. ");
INSERT INTO cya_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Xa cua' tiyaa ti yu se'en ndon ñi, cui'in can' mxitlyu 'in yu lo' mscuin ti'in na 'in yu lo'o juesa, una Jesús ngusun lo'o ñi 'in cui'in xa'an can' lo' m'ni chca ñi 'in yu, lo' mdyaa ñi cunta 'in yu 'in sti yu. ");
INSERT INTO cya_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nchgaa nten can' yuhue ti' ne' tsala ña'an tlyu cha' cuiya' 'in Ndiose. Lja ti' ndi'in yuhue ti' ne' si'ya cha' nu m'ni ñi, juin ñi 'in yu ta'a nda'an ñi: ");
INSERT INTO cya_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tyaa um ya' ton nscan tsu'hue um cha' re, si'yana tsa tucua xaa Yu Qui'yu nu Mdo'o nde ni' Cuaan, caja nu tyaa 'in ñi tuyaa' nten chendyu. ");
INSERT INTO cya_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Una yu ta'a nda'an ñi a ngu'ya yu cha' tiyaa cha' nu ycui' ñi, si'yana a jui cha' cuiya' qui'ya yu cunta cha' can', ñi a msti ti' yu cuñicha' yu 'in ñi. ¿Ti nu lca nu ndon loo la? ");
INSERT INTO cya_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Xacan' mdyisnan ycui' tyijyin yu ta'a nda'an ñi cha' ti ña'an yu ntsu'hui cha' ca yu nu ndon loo la. ");
INSERT INTO cya_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús ngu'ya ñi cunta cha' nu ñan ti' yu, can' cha' m'ni ñi cha' yaan sca nu lyo' ti se'en ndon ñi, ");
INSERT INTO cya_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","lo' juin ñi 'in yu ta'a nda'an ñi: Ña'an nu ti nu cuan xu'hue 'in nu lyo' ti re si'ya cha' 'ñan, cu'ni can' cunta si'yana 'ñan cuan xu'hue. Lo' ña'an nu ti nu cuan xu'hue 'ñan, si'i 'ñan nan' ti cuan xu'hue can', cui' ca nu lo'o 'in nu ngua'an tñan 'ñan. Si'yana nu n'ni lyo' 'in, can' nu ndon loo lati lja um. ");
INSERT INTO cya_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Xacan' mdo'o ycui' yu Xuhua can': Ñi Bstro, cua na'an hua sca yu nu ndlo cui'in xa'an 'in nten lo'o cha' cuiya' 'in um, una msi'yu co' hua cha' nu ngui'ni yu si'yana a nda'an yu lo'o na. ");
INSERT INTO cya_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Xacan' juin Jesús lo'o yu: A chcui ndijin um lo'o cha' nu ngui'ni yu, si'yana nu a ti'i ti' 'in na, tso' 'in na nguiaa can'. ");
INSERT INTO cya_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Xa cua' nchcui cuii' cha' quiaa ñi nde ni' cuaan, xacan' mdi'in tyaa ñi cusya 'in ñi si'yana tsaa ñi quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Xacan' ngua'an tñan ñi 'in tucua snan yu nu chcua loo tsaa sca quichen lyo' ti se'en lyi'ya loo Samaria lo' cunan yu se'en quinu ñi can'. Mdo'o yu nguiaa yu lo' mdiyaa yu quichen can', ");
INSERT INTO cya_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","una nten ndi'in can' a ncuan xu'hue ne' 'in ñi xa mdiyaa ñi, si'yana jlyo ti' ne' tyijyin ti ñi tsaa ñi quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Xa na'an Jacobo lo'o yu Xuhua cha' re, juin yu 'in ñi: Ñi X'nan hua, ¿ta nchca ti' um jñan hua cha' qui'ya quii' tsaña'an m'ni yu Elía, lo' cujlyo na 'in ne'? ");
INSERT INTO cya_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mxina'an ñi se'en ndon yu lo' ngusun lo'o ñi 'in yu: 'Un a nchca qui'ya um cunta la tso' nguiaa um, ");
INSERT INTO cya_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","si'yana nan' Yu Qui'yu nu Mdo'o nde ni' Cuaan, a ljyaan si'yana cujlyon 'in nten chendyu, cui' ca nu si'yana culo laan 'in ne'. Xacan' mdo'o jun nguiaa jun lo' mdiyaa jun xca quichen lyo' ti. ");
INSERT INTO cya_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tucueen nguiaa jun can' mdo'o ycui' sca yu qui'yu lo'o ñi: Ñi X'nan hua, nchca tin' chcui ncha'an 'in um la ña'an ti nguiaa um. ");
INSERT INTO cya_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mxcuen Jesús 'in yu: Sca cuta' nducua tuque tyi 'in, cui' cuaña'an quiñi, cua' lca se'en nxcua ten 'in, una Yu Qui'yu nu Mdo'o nde ni' Cuaan, a ndyijyi se'en xitñan' can'. ");
INSERT INTO cya_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Xacan' juin ñi 'in xca yu can': Chcui ncha'an 'ñan. Mxcuen yu 'in ñi: Ñi X'nan hua, taa um ya' quia tsin' 'in stin culo nducua la. ");
INSERT INTO cya_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mxcuen Jesús 'in yu: A s'nan nu chu'hui yuhue' ti' cutsi' 'in nu cua' ngujui, una nu'huin tsa ycui' cha' tsu'hue 'in Ndiose tsaña'an nu ntsu'hui cha' culo ñi tñan 'in nten. ");
INSERT INTO cya_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Xacan' mdo'o ycui' xca yu lo'o ñi: Ñi X'nan hua, lo'on nan' nchca tin' chcui ncha'an 'in um, una taa um ya' culo nducua la quia slan' 'in nu ndi'in na'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús mxcuen 'in yu: Sca yu nu nxñi yaa' yca nguita yuu lo' xina'an nde chon', a ca tñan can' cu'ni tñan 'in Ndiose se'en ndlo ñi tñan. ");
INSERT INTO cya_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chon' nde'en can', Ñi X'nan na ngulohui ñi cha xnan yla ntsu'hui tii yu, lo' ngua'an tñan ñi 'in yu cunda tucua ti yu chcua loo yu tsaa yu scasca quichen se'en ntsu'hui cha' tyijyin ñi. ");
INSERT INTO cya_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lo' juin ñi 'in yu: Cha' ñi si'yana qui'an tñan ndi'in 'in Ndiose, cua' tca quio' na, una chin' ti yu nguso, can' cha' jñan um cha' tsu'hue 'in ñi nu lca X'nan tñan re si'yana su'hua ñi nguso nu xo' 'in na. ");
INSERT INTO cya_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nan' su'huan 'in um tsaa um ña'an nchca ti' slya' nu nguiten lja ni' la. ");
INSERT INTO cya_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A cui'ya um cuijyin, ñi tñi lo' ñi quinan lo' a cui'ya um, a nchca cha' tiya' um lo'o ñi sca tucui nu chcua um tucueen. ");
INSERT INTO cya_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","La ña'an ti tiyaa um se'en nducua na'an 'in nten, ndeña'an chcui' um lo'o ne' culo nducua la: Ndiose taa ñi cha' tsu'hue nu chu'hui ni' cusya 'in um nchgaa 'un nu ndi'in na'an re. ");
INSERT INTO cya_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cha' ntsu'hui nu nguiaa tso' 'in cha' tsu'hue, cuan xu'hue can' cha' nu chcui' um, lo' cha' a cuan xu'hue can' 'in um, a quinu cha' tsu'hue se'en ndi'in can'. ");
INSERT INTO cya_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na'an se'en cuan xu'hue ne' 'in um, can' quinu um, cuan xu'hue um na nu taa ne' cu um lo'o na nu co'o um, si'yana sca yu nguso ntsu'hui suun 'in yu xñi yu siya' yu. A nchca cha' quinu um scasca na'an. ");
INSERT INTO cya_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ña'an quichen ti tiyaa um, cha' cuan xu'hue ne' 'in um, ca xu'hue um na nu tyi'in tyaa ne' tloo um, ");
INSERT INTO cya_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","cu'ni chca um 'in nchgaa nu ti'i, lo' chcui' um lo'o ne': Cua' mdiyaan cha' tsu'hue 'in um tsaña'an ntsu'hui cha' culo Ndiose tñan 'in na. ");
INSERT INTO cya_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Cha' nde'en quichen sten um a cuan xu'hue ne' 'in um, tyi'an um chcui tucueen loo quichen can', lo' ndeña'an chcui' um lo'o ne': ");
INSERT INTO cya_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Yuu ta nu msñi ca'an quiya' hua loo quichen re scuin hua 'in na si'yana a ncuan xu'hue um 'in hua, lo' ca jlyo ti' um si'yana cua' mdiyaan cha' tsu'hue se'en ndi'in um ña'an ntsu'hui cha' culo Ndiose tñan 'in na. ");
INSERT INTO cya_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chcuin' lo'o um sca cha', tsaan nu ntsu'hui cha' cu'ni Ndiose xñan bsya 'in nten chendyu, lyee lati tyijyin nten can' nu ti'i que ña'an nu ti'i ntsu'hui cha' tyijyin quichen Sodoma. ");
INSERT INTO cya_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","'Tnan ca um, 'un nu ndi'in quichen Corazín, lo' 'tnan ca um, 'un nu ndi'in quichen Betsaida, tsala ña'an cha' tnu cua' m'nin tloo um. Cha' cua na m'nin cha' re quichen Tiro lo'o Sidón, cua' s'ni mxilo'o chon' ne' qui'ya ngui'ni ne', lo' ca chcan' loo si'yana ti'i nga'an 'in ne' lo'o ña'an nu nchco' ne' lo'o ña'an nu n'ni ne'. ");
INSERT INTO cya_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Can' cha' tsaan nu ntsu'hui cha' cu'ni Ndiose xñan bsya 'in nten chendyu, ne' nu ndi'in quichen Corazín lo'o Betsaida, lyee lati tyijyin can' nu ti'i que ña'an ti'i nu ntsu'hui cha' tyijyin quichen Tiro lo'o Sidón. ");
INSERT INTO cya_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Lo' 'un quichen Capernaum, —xque' ti' um si'yana cua' jui xu'hue um la ni' cuaan, una tiyaa xaa caja nu su'hua 'in um se'en tyijyin um nu ti'i—. ");
INSERT INTO cya_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Can' cha' nchgaa nu ton nscan cha' nu chcui' um, ña'an loo cha' 'ñan nan' ton nscan can', lo' nu xcuan tloo 'in um, 'ñan nan' xcuan tloo can', lo' nu xcuan tloo 'ñan, 'in ñi nu ngua'an tñan 'ñan xcuan tloo can'. ");
INSERT INTO cya_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xa nguila snan yla ntsu'hui tii yu can', ndyijyin ya' tsu'hue ntsu'hui tiquee yu lo' nchcui' yu: Ñi X'nan hua, lo'o cui'in xa'an ncua ja'an 'in hua si'ya cha' cuiya' 'in um. ");
INSERT INTO cya_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mxcuen ñi 'in yu: Cha' ñi 'in um, ti' la ni' cuaan na'an mdyi'o tyu Laxa'an tsaña'an nchca ti' quii' 'in tyi'yu. ");
INSERT INTO cya_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ña'an jan ñi, cua' mdaan cha' cuiya' 'in um si'yana tca lyo' su'hua um 'in cunaan la lo'o xe'en, tlyu la cha' cuiya' re que 'in ta'a cusuun um, lo' a sca ti'i ca 'in um. ");
INSERT INTO cya_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Una si'i can' cha' ca tsu'hue chu'hui tiquee um, ta si'yana nchca ja'an cui'in xa'an 'in um, cui' ca nu ca tsu'hue chu'hui tiquee um si'yana cua' ngua'an scua nii um la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Xacan' ndyijyin ya' tsu'hue ntsu'hui tiquee Jesús si'ya Espíritu 'in Ndiose, lo' juin ñi: Stina Ndiose, nan' cu'nin tnun 'in um, 'un nu lca X'nan ni' cuaan lo'o loo chendyu re, si'yana msu'hua cutsi' um cha' re 'in nu tiyaa lo'o nu nxque' ti' ndyi'ya la cha' tiyaa, lo' ngulyo scua la um cha' re lo'o nu chin' la cha' 'in. 'Un nu lca Stin, cha' ñi 'in um si'yana cuaña'an nchca ti' um. ");
INSERT INTO cya_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nchgaa loo cha' mdyaa Stin cunta 'ñan, nan' nu lca Sñe' ñi, lo' a tucui nu jlyo ti' tucui lcan, cui' ca nu scati Stina Ndiose, cui' cuaña'an a tucui nu jlyo ti' tucui lca Stina Ndiose, cui' ca nu scan tin, a cunta culyo scua lan cha' re lo'o nu nchca tin'. ");
INSERT INTO cya_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Xacan' mxina'an ñi se'en ndon ta'a nda'an ca ñi, lo' ycui' ñi lo'o yu sca cunta: Tsu'hue ca xu'hue nchgaa nu na'an cha' nu na'an um cua' ñii, ");
INSERT INTO cya_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","si'yana cunen lo'o um sca cha', qui'an 'a yu nu mxiycui' Ndiose 'in cua' s'ni cui' cuaña'an lo'o nu ncua ree, ncua ti' yu ña'an yu cha' nu na'an um cua' ñii, una a na'an yu 'in na, lo' ncua ti' yu quine 'in yu cha' nu ne 'in um cua' ñii, una a ngune 'in yu cha' re. ");
INSERT INTO cya_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yato'o mdyiton sca yu nu m'ni cha'an cha' 'in lee, lo' mñicha' yu 'in Jesús se'en nu su'hua yu qui'ya 'in ñi, lo' juin yu: 'Un ñi nu lca Bstro, ¿ti ña'an cha' nu tca cu'nin si'yana caja chendyu nu a tsatii 'a 'ñan? ");
INSERT INTO cya_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mxcuen ñi 'in yu: ¿Ña'an ta nchcui' lee can'? ¿Ña'an ta ndyi'ya um cunta 'in na? ");
INSERT INTO cya_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Xacan' mxcuen yu: —Lo'o nu chcui cusya 'in um tyaa um 'in um 'in Ndiose X'nan um, lo'o nu chcui lca tiquee um, lo'o nchgaa juesa 'in um—, lo'o nchgaa cha' tiyaa 'in um, a cunta —ña'an 'tnan ti' um 'in ta'a nten um tsaña'an n'ni um 'tnan 'in um—. ");
INSERT INTO cya_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Juin ñi 'in yu: Cui' ña'an ycui' um, cu'ni um cuaña'an lo' caja chendyu 'in um. ");
INSERT INTO cya_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ncua ti' yu suhui yu tloo yu, can' cha' juin yu 'in Jesús: ¿Tucui ca lca ta'an? ");
INSERT INTO cya_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Xacan' mxcuen Jesús 'in yu: Sca yu qui'yu mdo'o yu Jerusalén nguiaa yu nde quichen Jericó, tucueen nguiaa yu can' mdo'o yu cunan nu yjui ti'in 'in yu, ngulyaa na 'in yu, lo' mxnu sti yu 'in ña'an nchca ti' sca yu ngujui. ");
INSERT INTO cya_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yato'o tucueen can' nguiaa sca yu nu ntsu'hui cunta 'in laa, una xa na'an yu 'in nu su can' mdijin ti yu. ");
INSERT INTO cya_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cui' cuaña'an lo'o sca yu Leví nu nda yaa' cha' 'in laa, mdijin tucueen can', xa na'an yu 'in nu su can' ticui' mdijin ti yu. ");
INSERT INTO cya_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Cui' cuaña'an mdijin sca yu Samaria, una xa na'an yu 'in nu su can' cui' xaa mña'an 'tnan ti' yu 'in. ");
INSERT INTO cya_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mdiyaa yu se'en su, msu'hua yu ceite lo'o vino se'en ti'i can', lo' nguxen yu te' 'in na, xacan' mscuen yu 'in chon' burru 'in yu, lo' ya xnu yu 'in sca na'an se'en ntsu'hui cha' cu'ni cunta ne' 'in. ");
INSERT INTO cya_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Xca tsaan can' xa cua' tyi'o yu tsaa yu, mxnu yu tucua tñi plata 'in nu ndi'in na'an can', lo' juin yu 'in: Cu'ni um cha' tsu'hue cu'ni cunta um 'in yu ti'i re, lo' cha' nducua la tñi culyijyi um si'ya yu, nan' xu'huan lyiyan' 'in na xa nde xitucuin. ");
INSERT INTO cya_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Ti ña'an ta ta'a snan yu re lca ta'a yu nu m'ni lyi'o yu cunan 'in can'? ");
INSERT INTO cya_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mxcuen yu 'in ñi: Cui' yu nu m'ni cha' tsu'hue lo'o can'. Xacan' juin Jesús 'in yu: Yaa um, lo' ticui' cuaña'an cu'ni um. ");
INSERT INTO cya_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yato'o mdo'o Jesús nguiaa ñi, mdiyaa ñi sca quichen lyo' ti, can' ndi'in sca ne' cuna'an naan Marta nu ncuan xu'hue 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ndi'in sca ta'a ngula ne' naan María, can' nu yten tucua cui' ti se'en nducua Jesús si'yana ton nscan cha' nu nchcui' ñi. ");
INSERT INTO cya_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Una Marta can' lyee la ntsu'hui yuhue ti' tñan nu ndi'in tuquii', xacan' yaa se'en nducua ñi lo' juin 'in ñi: Ñi X'nan hua, ¿ta a nduhue ti' um tsala ña'an tñan mxnu ta'an 'ñan? Chcui' um lo'o si'yana ta yaa' 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Una mxcuen Jesús 'in: Marta, Marta, ta lyee 'a nsu'hua yuhue ti' tiquee si'ya scasca tñan ngui'ni. ");
INSERT INTO cya_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ntsu'hui sca cha' nu ndon loo lati, can' nu ngulohui María, lo' a tucui nu tca lyaa cha' can' 'in. ");
INSERT INTO cya_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yato'o sca tsaan Jesús nchcui' lyi'o ñi 'in Ndiose sca se'en, xa mdyi ycui' ñi juin sca yu ta'a nda'an ñi lo'o ñi: Ñi X'nan hua, culo'o um 'in hua ña'an ntsu'hui cha' chcui' lyi'o hua 'in Ndiose, tsaña'an ngulo'o yu Xuhua 'in ta'a mda'an yu. ");
INSERT INTO cya_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Xacan' juin ñi 'in nchgaa yu can': Xa chcui' lyi'o um 'in Ndiose ndeña'an chcui' um: Ndiose Sti hua, 'un nu nducua ni' cuaan, scati um ntsu'hui cha' cu'ni tnu hua 'in um. Nchca ti' hua si'yana tsatlyu culo um tñan 'in hua. Cu'ni um ña'an nu nchca ti' um loo chendyu re tsaña'an ngui'ni um la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","A cunta taa um na nu cunajo'o 'in hua cunda scaa tsaan. ");
INSERT INTO cya_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cu'ni um cha' tlyu ti' 'in hua lo'o qui'ya ngui'ni hua, si'yana cuaña'an ngui'ni hua cha' tlyu ti' 'in nchgaa nu ngui'ni cha' ngunan' lo'o hua. A taa um ya' sten cha' ngunan' tiquee hua, cui' ca nu culo tso' um 'in hua sii' cha' ngunan' can'. ");
INSERT INTO cya_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Lo' ti' juin la ñi 'in yu: Cha' ndi'in sca ta'a tsu'hue um, lo' tiyaa um se'en ndi'in can' tlu'hue tla, lo' chcui' um lo'o can': Jñan sca cha' tsu'hue 'in, taa snan ti jaslya 'ñan, ");
INSERT INTO cya_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","si'yana sca yu ta'a tsu'hue ntsu'huin tca mdiyaan yu se'en ndi'in, lo' a sca na ndi'in 'ñan taan cu yu. ");
INSERT INTO cya_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Cha' ti' la ña'an xcuen yu 'in um: Ñi cha' ljyan taa cha' nsin' ti' 'ñan, ta a jlyo ti' cua' nchcun tuna'an 'ñan, cua' ljan' lo'o nu xuhue ti 'ñan, a tca tyitucuin taan na nu nchca ti'. ");
INSERT INTO cya_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Una cunen lo'o um sca cha', si'i si'yana lca can' ta'a tsu'hue yu ta can' cha' tyitucui yu lo' taa yu nchgaa na nu njñan can', cui' ca nu si'yana ndaja ti yu ndon taa can' cha' nsin' ti' 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Can' cha' chcuin' lo'o um sca cha': Jñan um na nu nchca ti' um lo' caja na 'in um, quia nan um cha' can' lo' quija lyoo na 'in um, chcui' um lo' caja nu sla tuna'an 'in um. ");
INSERT INTO cya_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Si'yana nchgaa nu njñan sca cha', a s'ni ndyijyi na 'in, lo' nu ndiya nan cha' can', a s'ni quija lyoo na 'in, lo' nu nchcui', a s'ni ndyijyi nu sla tuna'an 'in. ");
INSERT INTO cya_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tsaña'an nguiaa cha' 'in um lo'o sñe' um, ¿ta xtyi ti' um taa um sca quee 'in can' cha' na jñan sca jaslya 'in um? Uta cha' jñan can' sca cula 'in um, a xtyi ti' um taa um sca cunaan 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Uta cha' jñan can' sca scuhue cutu 'in um, a xtyi ti' um taa um sca xe'en 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Cha' 'un lca um sca nten nu nducun', una jlyo ti' um ndaa um na nu tsu'hue 'in sñe' um, ña'an la ca Ndiose, ñi nu lca Sti um nu nducua ni' cuaan, ntsu'hui cha' taa ñi Espíritu nu Luhui 'in ñi 'in nchgaa nu njñan 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yato'o ngulo Jesús sca cui'in xa'an nu cua' mxnu cu'un 'in sca yu qui'yu, lo' xa mdyi'o cui'in xa'an can' 'in yu mdyisnan ycui' yu, lo' ndyijyin ya' yuhue ti' nten can'. ");
INSERT INTO cya_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Una scasca ne' mdyisnan nchcui' ne': Si'ya cha' cuiya' 'in Beelzebú, x'nan cui'in xa'an, can' cha' nchca 'in yu re ndlo yu cui'in xa'an nu ntsu'hui 'in nten. ");
INSERT INTO cya_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ntsu'hui nu mjñan 'in ñi si'yana cu'ni ñi sca cha' nu tnu lo'o cha' cuiya' 'in Ndiose, se'en nu caja ña'an su'hua ne' qui'ya 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Una ngu'ya ñi cunta ña'an cha' nu nda'an tiquee ne', lo' juin ñi: Sca quichen tnu tsatii cha' 'in na cha' tyisnan xuun na lo'o ticui' ta'a na, cui' cuaña'an sca na'an cha' tyisnan xuun ne' lo'o ticui' ta'a ne', tsato'o tyi'o tso' ta'a ne'. ");
INSERT INTO cya_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","A cunta Laxa'an cha' tyisnan xuun can' lo'o ticui' ta'a, ¿ta tca tsa quiñan can' culo tñan xacan'? Lo' 'un nchcui' um si'yana lo'o cha' cuiya' 'in Beelzebú ndlon cui'in xa'an nu ntsu'hui 'in nten. ");
INSERT INTO cya_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Cha' nan' ndlon cui'in xa'an lo'o cha' cuiya' 'in Beelzebú, una tso' 'in ta'a nda'an um, ¿la mdo'o cha' cuiya' nu ndlo can' cui'in xa'an cha' na can'? Can' nu ntsu'hui cha' cu'ni cuiya' cha' 'in um. ");
INSERT INTO cya_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Una cha' nan' ndlon cui'in xa'an lo'o cha' cuiya' 'in Ndiose, ca cuiya' ti' um si'yana Ndiose cua' ndlo ñi tñan lja um. ");
INSERT INTO cya_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Sca yu qui'yu nu ngula ti', cha' tyon tiyaa yu lo'o na nu culaa 'in yu, a sca ca se'en ndi'in yu. ");
INSERT INTO cya_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Una cha' tiyaa sca nu lyee la ngula ti', cu'ni can' canan 'in yu lo' lyaa can' na nu nducua tloo yu culaa 'in yu, lo' cutsa can' nchgaa na nu ndi'in 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nu a nguiaa tso' 'ñan, can' nu lca ta'a cusuun, lo' nu a nda yaa' quio' tñan 'ñan, nde njlyo can' 'in na. ");
INSERT INTO cya_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Xa ndyi'o cui'in xa'an nu ntsu'hui 'in nten, nda'an nan can' se'en tyi'in sca se'en ngutyi. Lo' si'yana a ndyijyi se'en tyi'in ndeña'an ñan ti': Xitucuin nde na'an se'en mdo'on. ");
INSERT INTO cya_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Xa quila can' se'en mdi'in, quija lyoo 'in na si'yana cua' ncua na, cua' lca ncua tsu'hue na. ");
INSERT INTO cya_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Xacan' tsa nan cha cati cui'in xa'an nu nducun' lati que ña'an ycui', lo' tsatlyu sten ni' cusya 'in ne', lo' nde lyee lati cu'ni lyi'o cui'in xa'an can' 'in ne' que ña'an ti' culoo. ");
INSERT INTO cya_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lja nchcui' Jesús cha' re, mdo'o ycui' cueen sca ne' cuna'an lja nten qui'an can': Tsu'hue ca xu'hue ne' cuna'an nu m'ni cha' ncua cune' um, nu mdaa yti' um. ");
INSERT INTO cya_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Xacan' mxcuen ñi 'in ne': Tsu'hue la xu'hue nu ndon nscan cha' 'in Ndiose lo' nducua tñan 'in na. ");
INSERT INTO cya_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tsa nducua qui'an la nten ndiyo' ti'in ne' se'en ndon ñi, lo' ndeña'an ycui' ñi: Ta nten nu ndi'in loo chendyu re nducun' ne', njñan ne' scasca cha' nu tnu, una a ntsu'hui cha' ña'an ne' cha' nu cuaña'an, tsaloo ti cha' nu mda'an ycui' Jonás ntsu'hui cha' ña'an ne'. ");
INSERT INTO cya_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tsaña'an msu'hua tiyaa Ndiose 'in quichen Nínive lo'o cha' nu ycui' Jonás, cui' cuaña'an nsu'hua tiyaa ñi 'in ta nten nu ndi'in cua' ñii si'ya cha' 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ne' cuna'an 'in ree nu mdo'o se'en lca Arabia, tyiqui'o ne' tiyaa xaa tsatlyu lo'o ta nten ndi'in re xa ca xñan bsya 'in ne', culo qui'ya ne' 'in nten re si'yana tijyo' mdo'o ne' se'en nu quine 'in ne' cha' tiyaa 'in yu Salomón, una lja na re ndon sca un ndon loo lati que 'in Salomón. ");
INSERT INTO cya_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ticui' cuaña'an lo'o ne' Nínive, ntsu'hui cha' tyiqui'o ne' tsatlyu lo'o ta nten ndi'in re xa ca xñan bsya 'in ne', culo qui'ya ne' 'in nten re si'yana lo'o cha' nu ycui' Jonás mxilo'o chon' ne' qui'ya m'ni ne', una lja na re ndon sca nu ndon loo lati que 'in Jonás. ");
INSERT INTO cya_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A tucui nu su'hua cutsi' sca quii' uta su'hua 'in na ni' cuiya' mblya, cui' ca nu tyi'in tyaa 'in na cuaan si'yana tu'hui na xaa 'in nu sten ña'an can'. ");
INSERT INTO cya_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Quiloo um ndaa na xaa 'in um, lo' cha' tsu'hue xaa quiloo um ti' ña'aan um mtsa'an yu'hui um lo'o xaa can', una cha' a tsu'hue xaa quiloo um, cui' cuaña'an tla yta cha' tiyaa 'in um. ");
INSERT INTO cya_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Xñi um cunta si'yana a chca xaa cua 'in um tla yta. ");
INSERT INTO cya_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Cha' ti' ña'aan um mtsa'an yu'hui um lo'o xaa, lo' a la 'a ti' tla yta loo chendyu 'in um, lca um chacui' xaa tsaña'an nchca ti' sca quii' nu tsu'hue ña'an xaa 'in. ");
INSERT INTO cya_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Xa mdyi ycui' Jesús cha' can', sca yu fariseo mjñan yu cha' tsu'hue cha' tsa ycu tlya ñi lo'o yu, lo' ña'aan yten ñi ña'an can' yten tucua ñi tu'hua msa. ");
INSERT INTO cya_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Una yuhue 'a ti' yu fariseo si'yana a culo nducua ngunan' ñi. ");
INSERT INTO cya_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Una juin Ñi X'nan na 'in yu: 'Un ne' fariseo, tsa nde chon' ti vaso lo'o qui'nan njyi'an um, una nde ni' cusya 'in um mtsa'an yu'hui cha' jñan ti' lo'o cha' nducun'. ");
INSERT INTO cya_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","'Un ne' lye' ti', ¿ta si'i nu mtñan nde chon' vaso can' lca nu mtñan nde ni' na? ");
INSERT INTO cya_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Cha' cua na tca taa um sca lcuan nu tyi'o ni' cusya 'in um, nchgaa cha' luhui 'in um xacan'. ");
INSERT INTO cya_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","'Tnan ca um, 'un ne' fariseo, si'yana hasta lo'o scasca na quixin' ndaa um tsachin' ti 'in Ndiose, lo'o menta nu xityi'i, lo'o ruda, una a nsu'hua loo um cha' nu ñi 'in Ndiose lo'o cha' tsu'hue 'in ñi. Cu'ni um nchgaa cha' re, una a jlya ti' um cha' nu ndon loo lati nu nga'an cha' cu'ni um. ");
INSERT INTO cya_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","'Tnan ca 'un ne' fariseo, si'yana se'en n'ni tnu na 'in Ndiose lyee lca tiquee um chcua um loo yca xlya se'en nchcua nten nu ndon loo, lo' tsu'hue ntsu'hui tiquee um xa ndyijyi nu nchcui' cha' 'in um lo'o suun ña'an se'en nchca quiya'. ");
INSERT INTO cya_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Tnan ca 'un ne' fariseo lo'o ne' escriba, 'un nu a ñi ndi'in cha' 'in, nguiaa cha' 'in um tsaña'an nchca ti' sca cuaa nu a chcan' su, lo' nchgaa nten nu ndijin chon' can' a jlyo ti' ne' la ndlo' su'hua ne'. ");
INSERT INTO cya_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Xacan' mdo'o xcuen sca yu nu ngui'ni cha'an cha' 'in lee, lo' juin yu: 'Un ñi nu lca Bstro, cha' nu nchcui' um cua lo'o 'in hua m'ni lo'o na. ");
INSERT INTO cya_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mxcuen ñi 'in yu: Cui' cuaña'an 'un nu ngui'ni cha'an cha' 'in lee, 'tnan ca um, si'yana nxi 'ya um yu'hua ti'in 'in nten nu a nchca cui'ya ne', una cha' nu 'in um, ñi sca loyaa' ti um lo' a ngui'ni ca'an 'in na. ");
INSERT INTO cya_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","'Tnan ca 'un nu ngui'ni chu'hue cuaa se'en mtsi' yu nu mxiycui' Ndiose 'in cua' s'ni, yu nu ngujui yaa' nten cula 'in um. ");
INSERT INTO cya_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nchca chcan' ña'an si'yana sca cha' ti 'in um lo'o nten cula 'in um, si'yana can' nu yjui 'in yu, lo' 'un ngui'ni chu'hue um se'en mtsi' yu. ");
INSERT INTO cya_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Can' cha' juin Ndiose lo'o cha' tiyaa 'in ñi: Nde ca'an tñan 'in nu xiycuin' 'in, a cunta lo'o nu chcui' cha' tsu'hue 'ñan lo'o nten, ntsu'hui can' caja nu cujui 'in lo' ntsu'hui nu xitijin ne' 'in nu ti'i, ");
INSERT INTO cya_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","can' cha' ta nten ndi'in re ntsu'hui cha' tyaa ne' cunta 'ñan si'ya tne nu nguilo 'in nchgaa yu nu mxiycuin' 'in cua' s'ni ti' xa nu mdyisnan suun chendyu re, ");
INSERT INTO cya_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ti' tne nu mslo ne' 'in Abel lo' m'ni tyii ne' cha' re lo'o Zacaría, yu nu yjui ne' 'in tlu'hue la lyiya' se'en ndiquin tucua 'ni lo'o tulaa can'. Cunen lo'o um sca cha' si'yana ta nten re ntsu'hui cha' tyaa ne' cunta si'ya cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Tnan ca 'un nu ngui'ni cha'an cha' 'in lee, si'yana nducui ndijin um se'en nu qui'ya ne' cunta cha' 'in Ndiose, ñi ycui' um lo' a nguiten um, lo' a ndaa um ya' sten xca tucui. ");
INSERT INTO cya_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Xa mdyi ycui' ñi cha' re, ne' escriba lo'o ne' fariseo ycuen tique' ne' lo' mdyisnan mñicha' ne' 'in ñi scasca cha' nu tucui, ");
INSERT INTO cya_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ña'an ca si'yana su'hua ne' qui'ya 'in ñi lo'o cha' nu chcui' ñi. ");
INSERT INTO cya_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lja xacan' nguio' ti'in tyun mii nten se'en nguilyu Jesús, nu hasta lo'o nsta su'hua ta'a ne', lo' culo nducua la mdyisnan ycui' ñi lo'o yu ta'a nda'an ñi: Xñi um cunta 'in um lo'o cha' nu nchcui' ne' fariseo, si'yana a ñi ndi'in cha' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A sca na nu nchca cunan ti, ta a chcan' loo na, uta sca cha' nu nchca cutsi', ta a tyi'o scua la na. ");
INSERT INTO cya_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Can' cha' nchgaa cha' nu ycui' um se'en tla yta, a s'ni caja nu culyo scua la 'in na tiyaa xaa, cui' cuaña'an lo'o cha' nu ycui' cunan ti um se'en ntsu'hui nchcun um, a s'ni tyi'o yne cha' can' lja nten. 'In Ndiose ntsu 'hui cha' cutsen na ");
INSERT INTO cya_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Cunen lo'o um sca cha', 'un nu lca ta'a tsu'huen: A cutsen um 'in nten ta si'yana cujui ne' 'in um una a tca cu'ni ne' ti'i lo'o cusya 'in um. ");
INSERT INTO cya_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Una quitsan' 'in um tucui ca 'in ntsu'hui cha' cutsen um: Cutsen um 'in ñi nu tca cujui 'in um lo' su'hua cusya 'in um loo quii', nu cha' ñi cunen lo'o um, can' ñi nu ntsu'hui cha' cutsen um 'in. ");
INSERT INTO cya_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Ta si'i lo'o tucua tñi suhue ti nxi'i ne' tsa ca'yu quiñi? Siya' cuaña'an, cunda scaa 'in ntsu'hui Ndiose cunta 'in 'in. ");
INSERT INTO cya_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hasta lo'o quichan' que um, cua' lca ncua na 'in ñi. Can' cha' a su'hua um cha' tiquee um, si'yana 'un lyee la ntsu'hui lyoo um que 'in qui'an la quiñi. ");
INSERT INTO cya_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Cunen lo'o um sca cha', nchgaa nu a nxijyi'o ti' chcui' si'yana tso' 'ñan nguiaa, cui' cuaña'an nan', Yu Qui'yu nu Mdo'o nde ni' Cuaan, a xijyi'o tin' lo'o can' tloo angujle 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Una nu nchcui' si'yana a ndyu'hui lyoo 'ñan, cui' cuaña'an tloo angujle 'in Ndiose caja nu xcuan tloo 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nchgaa nu chcui' cha' ti'i 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan, ti' ntsu'hui cha' tlyu ti' 'in can', una nu chcui' ca'an 'in Espíritu nu Luhui 'in Ndiose, a chu'hui 'a cha' tlyu ti' 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Xa tsa lo'o ne' 'in um tloo nu cu'ni cuiya' cha' 'in um se'en ngui'ni tnu ne' judio 'in Ndiose, uta tloo bsya, ta tloo bsya tnu, a su'hua um cha' tiquee um ña'an chcui' um uta ña'an xcuen um 'in ne', ");
INSERT INTO cya_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","si'yana ticui' xaa can' taa Espíritu nu Luhui 'in Ndiose cha' nu chcui' um. ");
INSERT INTO cya_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Xacan' mdo'o ycui' sca nu ntsu'hui lja nten qui'an can': 'Un ñi nu lca Bstro, chcui' um lo'o yu ta'an si'yana taa yu tsa tlu'hue tñan nu nguinu 'in yu 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mxcuen ñi 'in yu: Ña'an jan ñi, a tucui nu ngulo ton 'ñan si'yana can bse lo' cutsan yuu 'in um. ");
INSERT INTO cya_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mdyisnan ycui' ñi lo'o nten can': Xñi um cunta si'yana a sten scasca cha' xque' ni' cusya 'in um, si'yana chendyu 'in nten a ljyaan na tso' 'in cha' cuilyiya'. ");
INSERT INTO cya_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A cunta mdi'in tyaa ñi sca cha' lo' juin ñi: Ndi'in sca yu cuilyiya', lo' tsu'hue 'a ncua tñan na nu yta yu. ");
INSERT INTO cya_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ñan ti' yu xacan': ¿Ña'an ta ca ñii, lo' a nducua se'en tlyu la quio' yu'hui na nu ntsu'hui cha' xon'? ");
INSERT INTO cya_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Lo' juin yu: Ndeña'an cu'nin, xcan nchgaa na'an suhue ti re lo' cu'nin cha' tsaa' nu tnu la, can' xu'hua se'en nchgaa na 'ñan lo'o na nu ntsu'hui cha' xon'. ");
INSERT INTO cya_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndeña'an ñan tin': Tsala ña'an qui'an cha' cuilyiya' nu cua' ndi'in 'ñan, ta loo na 'ñan tyun yjan, can' cha' cua' ñii xitñan', cun lo' co'on, cuaña'an ca tsu'hue chu'hui tiqueen. ");
INSERT INTO cya_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Una Ndiose juin 'in yu: ¿Ta tiji 'a nan? Tla re ñii caan nu chcuan cunta cusya 'in, ¿lo' ti nu ta quinu lo'o nchgaa na nu cua' mxu'hua se'en? ");
INSERT INTO cya_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cuaña'an ndiyato'o lo'o nu nso' ti'in cha' cuilyiya' loo chendyu re, una ti'i ña'an 'in can' lo'o tso' nu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Xacan' juin ñi 'in yu ta'a nda'an ñi: Can' cha' nchcuin' lo'o um cha' re: A su'hua um cha' nduhue ti' tiquee um lo'o na nu cunajo'o 'in um, lo' ñi lo'o ste' um. ");
INSERT INTO cya_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Si'yana ntsu'hui lyoo la chendyu 'in um que 'in cha' nchcu, cui' cuaña'an ntsu'hui lyoo la um que 'in ste' um. ");
INSERT INTO cya_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xñi um cunta ña'an ndi'in cha' 'in sca quiñi, a ntya 'in jyaan, a sca na nxo' 'in, lo' a la ndyi'in se'en na 'in 'in, una Ndiose nxicu 'in 'in. ¿Ta si'i lyee la ntsu'hui lyoo um que 'in quiñi? ");
INSERT INTO cya_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Siya' lyee la nsu'hua um cha' nduhue ti' tiquee um, ¿ta tca ta yaa' cha' can' 'in um culo um xca lii scun um? ");
INSERT INTO cya_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Cha' a nchca 'in um cu'ni um nducuii cha' nu suhue la re, ¿ñi cha' ntsu'hui yuhue ti' um nchgaa la ña'an cha'? ");
INSERT INTO cya_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Xñi um cunta sca yca quee nducua ni' quixin', a n'ni na tñan, a la nxcuan ste' na, una cunen lo'o um sca cha', tsala ña'an cuilyiya' ncua yu ree Salomón, una a yco' yu te' tsu'hue ña'an tsaña'an quee cua. ");
INSERT INTO cya_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Cha' cuaña'an nxico' Ndiose 'in quixin' cua, cua' ñii tsu'hue ña'an na, una quiaa cua' nguinan' na lo' tsaa na loo quii', ¿ña'an la ca 'un, cha' cua na tca tsa qui'an ti' um? ");
INSERT INTO cya_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Can' cha' 'un a nchca cha' chu'hui yuhue ti' um si'ya na nu cunajo'o 'in um, lo' ñi a tyi'an lu'un ti' um si'ya cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Si'yana chon' nchgaa cha' re nchcua quiloo nten chendyu, una ñi nu lca Sti um cua' jlyo ti' ñi nchgaa cha' nu 'ni 'in um. ");
INSERT INTO cya_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Cui' ca nu quia nan um 'in Ndiose lo' tucua um tñan cha' nu nchcui' ñi, lo' cui' ñi su'hua yaa' ñi 'in um lo'o nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","'Un nu lca slya' 'ñan, siya' chin' ti um, una a cutsen um si'yana Ndiose lo'o nu chcui lca tiquee ñi cua' mdaa ñi cha' cuiya' qui'ni ca'an 'in um se'en ndlo ñi tñan. ");
INSERT INTO cya_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Can' cha' cujui' um na nu ndi'in 'in um, lo' ta yaa' um 'in nu ti'i ña'an chendyu 'in, cuaña'an xo' ti'in um cha' cuilyiya' nu a ntsu'hui 'a cha' tyii, lo' tyi'in na 'in um tsala xaa la ni' cuaan, se'en nu a ntsu'hui cha' sten yu cunan, lo' ñi a tca sta 'ni 'in na. ");
INSERT INTO cya_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Si'yana se'en ndi'in cha' cuilyiya' 'in um, can' nchca cusya 'in um. ");
INSERT INTO cya_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tyon tiyaa um, scan' um sii' um lo' yaa' um chcua sca quii' ndiquin, ");
INSERT INTO cya_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","lo' cu'ni cha'an um ña'an cha' 'in nguso nu ndon tiyaa cha' ñi xaa quila x'nan nu nguiaa se'en ndyija cuilyi'o ne', si'yana ña'aan quila can' cun' tuna'an, lo' sla yu nguso can' 'in na. ");
INSERT INTO cya_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tsu'hue ca xu'hue nchgaa yu nguso nu ndon tiyaa xa quila x'nan. Nu cha' ñi cunen lo'o um, x'nan yu nguso can' scan' tsu'hue sii', cu'ni cha' chcua yu nguso can' tu'hua msa, lo' tyisnan su'hua na cu yu. ");
INSERT INTO cya_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Siya' quila can' tlu'hue tla uta nde cua' ljyaan xaa, lo' cha' ti' quija lyoo yu ndon tiyaa yu, tsu'hue ca xu'hue yu nguso can'. ");
INSERT INTO cya_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Una ca cuiya' ti' um cha' re: Cha' cua na ca jlyo ti' ne' ñi braa caan yu cunan, cua' lca ndon tiyaa ne', lo' a taa ne' ya' sten yu se'en ndi'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Cui' cuaña'an 'un, tyi'in tiyaa um, si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan quiaan ñi lja nu a sca cha' ntsu'hui tiquee um. ");
INSERT INTO cya_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yu Tyo can' mdo'o ycui' yu: Ñi X'nan hua, ¿ta ycui' um cha' re si'ya huare' ti, uta si'ya nchgaa la tucui? ");
INSERT INTO cya_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Juin Ñi X'nan na: ¿La quija lyoo sca nguso nu ñi ndi'in cha' 'in lo' tiyaa, nu chu'hui cunta na'an 'in x'nan, lo' tsu'hue cu'ni co'o nchgaa la ña'an nguso can'? ");
INSERT INTO cya_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tsu'hue ca xu'hue nguso can' cha' cuaña'an ngui'ni yu xa quila x'nan yu. ");
INSERT INTO cya_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nu cha' ñi cunen lo'o um, x'nan tñan can' xnu nchgaa la ña'an tñan 'in yu yaa' nguso can'. ");
INSERT INTO cya_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Una cha' yu nguso can' quiñan ti' yu: Ñi x'nan a quila ñi cui' xaa. Lo' cha' tyisnan cu'ni lyi'o 'tnan 'in nchgaa nguso can', tyisnan cu yu lo' co'o yu, a cunta ca cu'hui yu, ");
INSERT INTO cya_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","lo' tsati ntyin quila x'nan yu lja nu a sca cha' ntsu'hui ti' yu, xacan' lyee xitijin can' 'in yu nu ti'i, lo' su'hua 'in yu loo quii' se'en ntsu'hui nu lye' ti'. ");
INSERT INTO cya_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Sca nguso nu cua' jlyo ti' cha' nu nchca ti' x'nan, lo' cha' a ndon tiyaa, ñi a nducua tñan cha' nu nchca ti' x'nan, can' nu lyee ntsu'hui cha' tyijyin nu ti'i. ");
INSERT INTO cya_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Una sca nguso nu a jlyo ti' cha' nu nchca ti' x'nan, siya' tnan' can' nde'en la cha', jo'o ti tyijyin can' nu ti'i, si'yana tsalca nu qui'an la jui 'in, cui' cuaña'an qui'an la tyaa can', lo' tsalca nu qui'an cunta mchcuan, cuaña'an qui'an la cunta tyaa can'. ");
INSERT INTO cya_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nan' ljyaan si'yana xiqui'on quii' loo chendyu re, ¿lo' ña'an la ta nchca tin', ta si'i cua' ndiquin na? ");
INSERT INTO cya_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Una ntsu'hui cha' tijin sca nu ti'i tnu, lo' lu'un 'a tin' tsaya' nu tsato'o cha' re. ");
INSERT INTO cya_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ta ñan ti' um ljyan lo'on cha' tsu'hue nu xiti'in tsu'hue 'in nten chendyu? Chcuin' lo'o um si'yana si'i na, cui' ca nu cha' cusuun lca na. ");
INSERT INTO cya_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ti' cua' ñii nu tsaa nde loo re, cha' cusuun tyisnan scasca na'an. Se'en ndi'in ca'yu nten, snan can' xuun lo'o tucua, lo' tucua can' xuun lo'o snan. ");
INSERT INTO cya_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","—Sti can' xuun lo'o ticui' sñe', lo' cuaña'an cu'ni sñe' yu lo'o yu, a cunta jyi'an can' xuun lo'o ticui' sñe', cui' cuaña'an cu'ni sñe' ne' lo'o ne', jyi'an laa ne' xuun lo'o ticui' sñe' xen, lo' nu lca xen can' xuun lo'o jyi'an laa—. ");
INSERT INTO cya_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ti' ycui' la ñi lo'o nten can': Xa ña'an um si'yana lyee ndla ti' xaa luhua' se'en nguiaa cucha, nchcui' um si'yana qui'ya quio, lo' cuaña'an ndiyato'o na. ");
INSERT INTO cya_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Xa nxcua cui'in nu ndyi'o se'en lca sur, nchcui' um si'yana ca tique' cuaan, lo' cuaña'an ndiyato'o na. ");
INSERT INTO cya_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡'Un lca um nten nu cuiñi! Ndyi'ya um cunta cha' nu nchca ni' cuaan lo'o loo chendyu re, ¿lo' ñi cha' ta a ndyi'ya um cunta cha' nu na'an tloo um cua' ñii? ");
INSERT INTO cya_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Ñi cha' a ndlohui um cha' nu tsu'hue lati? ");
INSERT INTO cya_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Xa tsaa um lo'o ta'a cusuun um tloo bsya, ti' tucueen nguiaa ti um cu'ni chu'hue um cha' 'in um lo'o can', si'yana a tsa lo'o can' 'in um lo'o juesa la tloo bse, lo' yu bse can' tyaa yu cunta 'in um yaa' silyiya, lo' tsato'o su'hua yu 'in um na'an chcuan. ");
INSERT INTO cya_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cunen lo'o um sca cha', a tyi'o um na'an chcuan can' cha' a su'hua lyiya' um nchgaa cunta nu nducui ncha'an 'in um. ");
INSERT INTO cya_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lja xacan' mdo'o ycui' tucua snan yu nu mtsa' 'in Jesús tsaña'an mxitiya' tne ne' galilea lo'o tne 'ni, xa nu m'ni yu Pilato cha' ngujui tucua snan ne' lja ndiquin tucua ne' 'ni tloo Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mxcuen Jesús 'in yu: Cha' nu yato'o 'in ne' Galilea can', ¿ta ñan ti' um si'yana lyee la nducui yu qui'ya que nchgaa la ña'an ta'a Galilea ne'? ");
INSERT INTO cya_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cunen lo'o um si'yana si'i na, una cha' 'un a xilo'o chon' um qui'ya ngui'ni um, ticui' scaña'an ti quinan' um lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Uta lo'o 'tñuxnan yu nu ngujui nu mscua 'ni torre Siloé 'in, ¿ta ñan ti' um si'yana lyee la nducui can' qui'ya que nchgaa la ña'an nten nu ndi'in Jerusalén? ");
INSERT INTO cya_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cunen lo'o um si'yana si'i na, una cha' 'un a xilo'o chon' um qui'ya ngui'ni um, ticui' scaña'an ti quinan' um lo'o yu. ");
INSERT INTO cya_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","A cunta mdi'in tyaa ñi sca cha' lo'o nten can', lo' juin ñi: Sca yu qui'yu ndi'in sca yuu se'en nducua ti uva 'in yu, can' nducua sca yca higo, ya na'an yu cha' lyi'yu mti na una a jui na 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lo' juin yu 'in nu ntsu'hui cunta se'en can': Ña'an jan ñi, cua' nchca snan yjan nda'an nan mti loo yca re, una a ndyi'yu na, tsu'hue lati xi'yu na si'yana cua cha' ti nducua na. ");
INSERT INTO cya_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Xacan' mxcuen yu nu ntsu'hui cunta se'en can': Ñi x'nan, tyaa um ya' chcua na siya' xca yjan ti, lo' xo' ca'an yuu suun na lo' su'huan yuu cuti 'in na. ");
INSERT INTO cya_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Cha' tyisnan cui'yu na, tsu'hue, lo' cha' a cui'yu na tca xi'yu na. ");
INSERT INTO cya_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yato'o sca tsaan nu nxitñan' ne', ndlo'o Jesús 'in nten se'en ngui'ni tnu ne' 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","can' nducua sca ne' cuna'an nu nguinu xincun si'ya cui'in, lo' cua' ntsu'hui 'tñuxnan yjan a nchca 'a quiñi ton ne'. ");
INSERT INTO cya_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Xa na'an Jesús 'in ne', msi'ya ñi 'in ne' lo' juin ñi: Ne' cuna'an, cua' mdo'o laa lo'o quicha nu ntsu'hui 'in. ");
INSERT INTO cya_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mdi'in tyaa ñi yaa' ñi 'in ne' cuna'an can', cui' xaa nguñi ton ne' lo' m'ni tnu ne' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Una yu nu ntsu'hui cunta se'en can', ycuen tique' yu si'yana m'ni chca Jesús 'in ne' cuna'an can' tsaan nu nxitñan' ne', lo' juin yu 'in nten can': Scua tsaan ntsu'hui cha' cu'ni na tñan, lja xacan' tca caan um si'yana chca um, una si'i tsaan nu nxitñan' na. ");
INSERT INTO cya_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Xacan' mxcuen Ñi X'nan na 'in yu: 'Un nu cuiñi cua, ¿ta si'i cunda scaa um ndyi'an taa um tyi'a co'o 'ni 'in um siya' tsaan nu nxitñan' na? ");
INSERT INTO cya_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ne' cuna'an re ticui' ta nten 'in Abraham lca ne', cua' nguiaa 'tñuxnan yjan nsñi su'hua yaa' Laxa'an 'in ne'. Tsaña'an nu mchcan' ne', ¿ta a ntsu'hui cha' cuiya' caja nu xtin' 'in ne' siya' tsaan nu nxitñan' na? ");
INSERT INTO cya_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Xa ycui' ñi cha' re mxijyi'o ti' nchgaa nu ti'i ti' 'in ñi, una ña'aan quichen ne' tsu'hue ntsu'hui tiquee ne' si'ya scasca cha' nu tnu ngui'ni ñi. ");
INSERT INTO cya_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Lo' ti' juin la ñi 'in nten can': ¿Ti ña'an ta cha' tca tyi'in tyaan lo'o um si'yana tca qui'ya um cunta ña'an ntsu'hui cha' culo Ndiose tñan 'in nten? ");
INSERT INTO cya_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nguiaa cha' can' tsaña'an nguiaa cha' 'in mti mostaza nu ya yta sca yu qui'yu loo jyaan 'in yu, cui' xaa mducua na lo' tlyu ylo na, hasta lo'o quiñi msu'hua ten 'in lja stan' na. ");
INSERT INTO cya_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Xiya' mxitucui ñi ycui' ñi: ¿Ti ña'an ta cha' tca tyi'in tyaan lo'o um si'yana tca qui'ya um cunta ña'an ntsu'hui cha' culo Ndiose tñan 'in nten? ");
INSERT INTO cya_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nguiaa cha' can' tsaña'an nguiaa cha' 'in suun jaslya nu mxitiya' ne' cuna'an 'in na lo'o snan cuiya' quita, lo' ña'aan na mchcuen na. ");
INSERT INTO cya_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tucueen nguiaa Jesús quichen Jerusalén mdijin ñi scasca quichen tnu lo'o quichen suhue ti, lo' ndlo'o ñi 'in nten can'. ");
INSERT INTO cya_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jui nu mñicha' 'in ñi: Ñi X'nan hua, ¿ta chin' ti nten nu ntsu'hui cha' tyi'o laa? Mxcuen ñi 'in ne': ");
INSERT INTO cya_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Su'hua um juesa sten um tuna'an nu lu'hui, si'yana cunen lo'o um sca cha', qui'an 'a nten ca lca tiquee ne' sten ne' can', una a tca 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Xa cua' mducun x'nan na'an can' tuna'an 'in, xacan' 'un tyisnan cun' um 'in na, lo' chcui' um: Ñi X'nan hua, Ñi X'nan hua, sla um tuna'an re sten hua. Lo' xcuen ñi 'in um: A ndyu'hui lyoon 'in um. ");
INSERT INTO cya_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Xacan' tyisnan chcui' um: Tsatlyu mducua na lo' ycu na, lo' se'en nchca quiya', can' ngulo'o um 'in hua. ");
INSERT INTO cya_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Una xcuen ñi 'in um: Cunen lo'o um, a ndyu'hui lyoon 'in um, nchgaa 'un nu ngui'ni tñan ngunan', tyi'o tso' um siin'. ");
INSERT INTO cya_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Can' tyisnan cunan um loo nu lyee tyijyin um nu ti'i, xa ña'an um 'in Abraham, Isaac, lo'o Jacob tsatlyu lo'o nchgaa yu nu mxiycui' Ndiose 'in cua' s'ni, ndi'in se'en ndlo Ndiose tñan, lo' 'un tsato'o quinu ton um nde lyiya'. ");
INSERT INTO cya_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta'a jacua nscan chendyu tyi'o nten nu sten se'en ndlo Ndiose tñan, lo' chcua can' tsatlyu tu'hua msa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Cunen lo'o um sca cha', nu nguinu ca'an chon', can' nu ca nu culoo tiyaa xaa, lo' nu culoo cua' ñii, tiyaa xaa quinu ca'an chon' can'. ");
INSERT INTO cya_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Cui' tsaan can' mdiyaa tucua snan ne' fariseo se'en ndon Jesús, lo' juin ne' 'in ñi: Tyi'o quichen re si'yana yu Herode ntsu'hui tiquee yu cujui yu 'in. ");
INSERT INTO cya_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Lo' juin ñi 'in ne': Yaa um lo' chcui' um lo'o cuta' cua: Tsaan re ñii lo'o quiaa quilyun re, culon cui'in xa'an nu ntsu'hui 'in nten lo' cu'ni chcan 'in nu ti'i, lo' la ta'a snan tsaan tyii tñan re 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Una 'ni cha' tsa quiñan tucueen nu cua' ngui'an cua' ñii lo'o quiaa lo'o bcha, si'yana a ndyi'o tñan caja sca yu nu nxiycui' Ndiose 'in cha' si'i la Jerusalén. ");
INSERT INTO cya_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Jerusalén, Jerusalén! 'Un ne' nu ndujui 'in yu nu nxiycui' Ndiose 'in, lo'o quee ti ndujui um 'in nchgaa nu nda'an tñan ñi 'in um, tsala ña'an tyun ya' ncua tin' xo' ti'in 'in um, tsaña'an n'ni cutu lo'o sñe' 'in, una a mslyaa um. ");
INSERT INTO cya_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Una tiyaa xaa quinu tucua xi'in na'an 'in um. Cunen lo'o um sca cha', a ntsu'hui 'a cha' ña'an tloo um 'ñan tsaya' tiyaa tsaan nu chcui' um: —Tlyu cha' tsu'hue ntsu'hui 'in ñi nu ljyaan lo'o cha' cuiya' 'in Ñi X'nan na—. ");
INSERT INTO cya_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yato'o sca tsaan nu nxitñan' ne' judio, ya ycu tlya Jesús la na'an 'in sca yu fariseo nu ndon loo 'in ne', lo' nchgaa la ña'an ne' nsñi ne' cunta cha' ña'an ca cu'ni ñi. ");
INSERT INTO cya_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lja xacan' mdiyaa sca yu ti'i lo'o quicha quiin se'en nducua ñi. ");
INSERT INTO cya_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Xacan' juin Jesús 'in yu nu m'ni cha'an cha' 'in lee lo'o ne' fariseo can': ¿Ta ntsu'hui cha' cuiya' cu'ni chca na 'in sca nu ti'i tsaan nu nxitñan' na, uta na a ntsu'hui na? ");
INSERT INTO cya_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ñi sca ne' lo' a mxcuen ne' 'in ñi. Xacan' msñi ñi yaa' yu ti'i can' lo' m'ni chca ñi 'in yu, lo' juin ñi si'yana quiaa yu. ");
INSERT INTO cya_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Xacan' mñicha' ñi 'in ne': Cha' ntsu'hui um ndon 'ni 'in um, lo' cha' tyu yu'hui 'in sca tuyuu tsaan nu nxitñan' na, ¿ta si'i cui' xaa ti tsa lyoo um 'in 'in? ");
INSERT INTO cya_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Una a ngujlyo ti' ne' ña'an xcuen ne' 'in ñi lo'o cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús nsñi ñi cunta 'in ne' si'yana chacui' la que msa ndlohui ne' nchcua ne', xacan' mdi'in tyaa ñi sca cha' 'in nchgaa nu mdiyaa se'en nchca ta'a can', lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Xa cuni ne' 'in um tsaa um se'en caja cuilyi'o ne', a culohui um se'en chcua um la que msa, ña'an tu' tiyaan xca nu ndon loo la que 'in um, ");
INSERT INTO cya_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","lo' tsato'o chcui' yu nu msu'hua ta'a can' lo'o um: Tyi'o um se'en ntsu'hui cha' chcua yu re. Xacan' ti' jyi'o ti' um tyi'o um se'en can' lo' tsa tucua um la chon'. ");
INSERT INTO cya_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Can' cha' xa caja nu cuni 'in um tsaa um ta'a, tsu'hue lati chcua um la chon', lo' xa ña'an yu 'in um nducua um can' ljuin yu 'in um: Quiaan um lo' chcua um la loo re. Xacan' tloo ña'aan nten can' caja nu ta loo um. ");
INSERT INTO cya_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Si'yana nu scuen cuaan 'in ticuii' tsato'o caja nu tyi'ya te'en 'in, lo' nu n'ni lyo' 'in caja nu scuen cuaan 'in. ");
INSERT INTO cya_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Xacan' mdyisnan ycui' Jesús lo'o yu nu msu'hua ta'a can': Xa cu'ni um sca ta'a, a nchca cha' xi'ya um 'in ta'a tsu'hue um uta ta'a ngula um, uta 'in ta nten 'in um, ta yu cuilyiya' ta'a nducua ti um, si'yana can' nu xitucui cha' tsu'hue 'in um xa cu'ni ta'a. ");
INSERT INTO cya_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cui' ca nu cuni um 'in nu ti'i ña'an chendyu 'in, nu cuxi yaa', nu cuxi quiya', lo'o nu cuityin', ");
INSERT INTO cya_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","xacan' ntsu'hui xu'hue um si'yana a caja 'in can' tyaa 'in um, una tiyaa xaa chcuan um cha' tsu'hue can' xa ntsu'hui cha' tyiqui'o nchgaa nu ñi cusya 'in. ");
INSERT INTO cya_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sca yu ta'a nducua ñi tu'hua msa can', xa ngune 'in yu cha' nu ycui' ñi, juin yu lo'o ñi: Tsu'hue ca xu'hue nu chcua ycu tu'hua msa la se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mxcuen Jesús 'in yu: Sca yu qui'yu m'ni yu sca ta'a tlyu, qui'an 'a nten nguni yu tsa ycu siin se'en ndi'in yu. ");
INSERT INTO cya_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Xa cua' lca siin can', msu'hua yu sca nguso 'in yu tsa te'en 'in nchgaa nu cua' nguni yu can', lo' ndeña'an ngulo yu tñan 'in chcui': Cua' tca tsaa um, si'yana cua' lca na nu ntsu'hui cha' ca siin 'in um. ");
INSERT INTO cya_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nchgaa yu can' scaña'an ti mdyisnan mdaa yu qui'ya, lo' juin sca yu: Cu'ni um cha' tlyu ti' 'ñan, a tca tsa'an si'yana tca msi'in sca yuu lo' 'ni cha' tsa na'an 'in na. ");
INSERT INTO cya_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Xca yu juin yu: Cu'ni um cha' tlyu ti' 'ñan si'yana a tca tsa'an, tca msi'in tsa ca'yu ta bta, lo' 'ni cha' tsa na'an cha' cua' tca cu'ni 'in tñan. ");
INSERT INTO cya_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Lo' juin xca yu: Nan' a tca tsa'an si'yana tca jui cuilyi'on. ");
INSERT INTO cya_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mxitucui yu nguso can', nguia ytsa' yu 'in x'nan yu cha' can', lo' msin' ti' x'nan yu lo' juin 'in yu nguso can': Ndla ti cu'ni lo' tsaa nde se'en nchca quiya', tyijyin scasca tucueen loo quichen, lo' cu'ni cha' caan nu ti'i ña'an chendyu 'in, nu cuxi yaa' lo'o nu cuxi quiya', a cunta lo'o nu cuityin' can lo'o. ");
INSERT INTO cya_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Xacan' juin yu nguso can': Ñi x'nan hua, cua' mducuan tñan tsaña'an nu juin um, una ti' lja se'en re. ");
INSERT INTO cya_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Juin x'nan yu 'in yu: Yaa nde tu'hua quichen cua, tyijyin scasca tucueen, lo' xicu'ni 'in ne' can ycu siin ne', lo' cha'an yu'hui ne' tu'hua msa re 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cunen lo'o um sca cha', ñi sca nten nu nguni 'in ti' culoo, a cu siin 'a ne' lo'on. ");
INSERT INTO cya_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tucueen nguiaa ñi qui'an nten nguia ncha'an 'in ñi, lo' mdyisnan ycui' ñi lo'o ne': ");
INSERT INTO cya_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Cha' ntsu'hui nu nchca ti' tsa qui'an ti' 'ñan, 'ni cha' su'hua loo can' 'ñan lyee la que 'in nten cula 'in, lo'o nten 'in, lo'o sñe', uta 'in nchgaa ta'a ngula, uta 'in ticuii', can' nu ntsu'hui suun 'in chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Cha' a tyaa 'in siya' ti si'ya cha' 'ñan, a tca 'in can' ca sca nu cu'ni ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Si'yana, ¿ti nu tñan sca na'an cuaan, cha' si'i culo nducua la culo cunta cha' cula tñi 'in tsa' tucua na? ");
INSERT INTO cya_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ña'an tu' tyi'in tyaa suun yu 'in na, una cha' a tyi tsaa' na 'in yu, ña'an nu ti tca xtyi lyi'o 'in yu, ");
INSERT INTO cya_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","lo' chcui' ne': Yu cua mdyisnan mtñan yu na'an 'in yu, una a mdyi tsaa' na 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ticui' cuaña'an lo'o sca ree nu tsa cusuun, a s'ni chcua yu culo nducua la lo' culo yu cunta cha' tca cu'ni yu canan lo'o tsa tii mii sindatu 'in yu, lo' xuun yu lo'o tsa cla mii sindatu 'in xca ree. ");
INSERT INTO cya_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Cha' a lyi'ya ya' tca 'in yu, cui' xaa ca'an tñan yu nu tsa ycui' lo'o xca ree can' xa ti' lyijyi tiyaan yu, lo' cunan yu ña'an chu'hua ti'in cha' cusuun can'. ");
INSERT INTO cya_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Cui' cuaña'an 'un, cha' a cula ya' um nchgaa cha' nu ndi'in 'in um, a tca chcui ncha'an um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Teje' tsu'hue 'a na, una cha' tyi'o tiyen' 'in na, ¿ña'an ta tca ca tiyen' na xiya'? ");
INSERT INTO cya_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A ca tñan na quine na loo yuu uta quio' ti'in na ca na yuu cuti, cui' ca nu siya' ti nxcuan ne' 'in na. Nchgaa nu ndon nscan cha' nu nchcuin' re cu'ni cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nchgaa nu ndlo tñi lo'o nu nducun' mdiyaa tloo Jesús si'yana ton nscan ne' cha' nu nchcui' ñi, ");
INSERT INTO cya_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","una ne' fariseo lo'o ne' escriba mdyisnan ycui' tyijyin ne' si'ya ñi, lo' juin ne': Yu re nducuan xu'hue yu 'in nten qui'ya chendyu lo' sca se'en ti nchcu yu lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Xacan' mdi'in tyaa ñi sca cha' lo'o ne', lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Cha' ndi'in sca ciento slya' 'in um, lo' quinan' sca 'in, ¿ti nu a xnu ti'in ta'a jacua yla ntsu'hui 'tñulcua can', lo' quia nan 'in nu ngunan' yu'hui can' tsaya' quija lyoo 'in 'in? ");
INSERT INTO cya_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Lo' xa quija lyoo um 'in 'in, tyi'in tya scun um 'in 'in, tsu'hue ntsu'hui tiquee um quian lo'o um 'in 'in. ");
INSERT INTO cya_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Xa quila um la na'an 'in um, xo' ti'in um nchgaa ta'a tsu'hue um lo'o ta'a nducua ti um, lo' ljuin um 'in can': Ca tsu'hue chu'hui tiquee na, si'yana nguija lyoo slya' nu ngunan' yu'hui can' 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Cunen lo'o um sca cha', lyee la tsu'hue ntsu'hui tiquee Ndiose, ñi nu nducua ni' cuaan, si'ya sca nten nu nxilo'o chon' qui'ya 'in, que 'in jacua yla ntsu'hui 'tñulcua nu a 'ni cha' 'in lo'o cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sca ne' cuna'an su tsa tii tñi plata 'in ne', lo' cha' quinan' sca na, ¿ti nu ta a ca'an sca quii' lo' tyisnan cua ña'an 'in, lo' tsu'hue ti quia nan 'in na tsaya' quija lyoo na 'in? ");
INSERT INTO cya_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Xa nguija lyoo na, xo' ti'in 'in nchgaa ta'a tsu'hue lo'o ta'a nducua ti, lo' ljuin xacan': Ca tsu'hue chu'hui tiquee na, si'yana nguija lyoo tñi nu ngunan' can' 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cunen lo'o um sca cha', cuaña'an tsu'hue ntsu'hui tiquee angujle 'in Ndiose si'ya sca nten nu nxilo'o chon' qui'ya 'in. ");
INSERT INTO cya_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Lo' ti' ycui' Jesús xca cha': Sca yu qui'yu ndi'in tucua sñe' yu. ");
INSERT INTO cya_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yu cune' la can' juin yu 'in sti yu: Paa, tyaa um cha' tsu'hue nu ntsu'hui cha' qui'ni ca'an 'ñan. Xacan' mdaa sti yu cha' tsu'hue nu ntsu'hui cha' qui'ni ca'an 'in chcuaa yu. ");
INSERT INTO cya_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Una xi'i ti mducui, yu nu cune' la can' yjui' yu nchgaa na nu cua' jui 'in yu, mdo'o yu nguiaa yu tijyo' xca loo yuu, can' mdyisnan ngulyijyi yu tñi 'in yu cua' ña'an ti lo'o chacui' cha' ngunan'. ");
INSERT INTO cya_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yato'o xa mdyi tñi 'in yu, mdyisnan ngu'ya bju'ñan ña'aan se'en can', lo' a jui 'a na nu cunajo'o 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ya jñan yu tñan cu'ni yu se'en ndi'in sca yu ndi'in quichen can', can' nu msu'hua 'in yu la se'en ndi'in tñan 'in si'yana ña'an seen yu cuhue' 'in. ");
INSERT INTO cya_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Lyee ncua lca tiquee yu cu yu na nu nchcu cuhue' can', una a tucui nu mdaa 'in na cu yu. ");
INSERT INTO cya_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nguñan ti' yu xacan': ¡Tsala ña'an qui'an nguso ndi'in 'in stin lo' a sca na ndiya lyijyi 'in can', lo' nan' ndi'in re ndijin yte' tin'! ");
INSERT INTO cya_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tsu'hue lati xitucuin nde se'en ndi'in stin, lo' cunen lo'o: Paa, nan' m'nin qui'ya tloo Ndiose lo' m'nin qui'ya tloo um. ");
INSERT INTO cya_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A nga'an 'a cha' ti' cuan xu'hue um 'ñan tsaña'an nchca ti' sca sñe' um, cui' ca nu cu'ni um lo'on tsaña'an n'ni um lo'o sca nguso 'in um. ");
INSERT INTO cya_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Xacan' mdo'o yu nguiaa yu, lo' nguila yu se'en ndi'in sti yu. Ti' tijyo' yaan yu cua' na'an sti yu 'in yu, lo' mña'an 'tnan ti' 'in yu, cui' xaa mdo'o ya ycua 'in yu, ycui' cha' ta'a yu lo' msu'hua tuscun 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Juin yu 'in sti yu: Paa, nan' m'nin qui'ya tloo Ndiose, lo' m'nin qui'ya tloo um, a nga'an 'a cha' ti' cuan xu'hue um 'ñan tsaña'an nchca ti' sca sñe' um. ");
INSERT INTO cya_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Una sti yu ngulo tñan 'in nguso 'in: Quia 'ya um te' nu tsu'hue la ña'an lo' xico' um 'in sñen', su'hua um sca cuii' loyaa' yu lo' taa um quinan chu'hui quiya' yu, ");
INSERT INTO cya_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","quia 'ya um bta nu cojo' can', cujui um 'in 'in lo' cu'ni na sca ta'a lo' tsatlyu cu na, ");
INSERT INTO cya_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","si'yana yu sñen' re m'nin cunta si'yana cua' ngujui yu, una cua' ñii mdyiqui'o yu, cua' ngunan' yu, una xiya' nguila yu. Xacan' mdyisnan m'ni ne' ta'a lo'o nu chcui lca tiquee ne'. ");
INSERT INTO cya_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Una xca sñe' yu nu cula la can', yaan yu yaa yu tñan, xa cua' quila ti yu se'en nducua na'an 'in sti yu, ngune 'in yu ndi'in yla yu bstro lo' nguila quiya' nten can'. ");
INSERT INTO cya_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xacan' msi'ya yu 'in sca nguso can', lo' mñicha' yu 'in cha' ñi na nchca. ");
INSERT INTO cya_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Juin yu nguso can': Yu ta'a ngula um nguila yu, lo' sti um ngulo tñan si'yana cujui hua bta nu cojo' can', si'yana nguila yu tsu'hue lca 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Xacan' ycuen tique' yu nu cula la can', lo' a mslyaa yu sten yu ña'an. Cui' xaa mdo'o sti yu, mjñan cha' tsu'hue 'in yu si'yana quiaan yu ña'an. ");
INSERT INTO cya_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Una mxcuen yu 'in sti yu: Nan' cua' s'ni 'a ngui'nin tñan 'in um, ñi siya' lo' a nchca cu'nin lye' tin' 'in um, una ñi sca chiu cune' ti 'in um, a nchca taa um si'yana cu'nin chin' sca ta'a lo'o yu ta'a tsu'hue ntsu'huin. ");
INSERT INTO cya_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Una cua' ñii si'yana nguila sñe' um, yu nu cua' ngulyijyi ña'aan cha' tsu'hue nu mdaa um 'in lo'o ne' cuna'an nducun', lo' nde ngulo um tñan si'yana caja bta nu cojo' can' si'ya yu. ");
INSERT INTO cya_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Xacan' mxcuen sti yu: Sñen', nu'huin nchgaa xaa ndi'in lo'on, lo' nchgaa na nu ndi'in 'ñan, na 'in lca na. ");
INSERT INTO cya_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A mdijin yu'hui nu a cu'ni na ta'a lo' ca tsu'hue chu'hui tiquee na, si'yana yu ta'a ngula m'ni na cunta si'yana ngujui yu, lo' la ñii mdyiqui'o yu, cua' ngunan' yu, una cua' ñii nguila yu. ");
INSERT INTO cya_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nde xca cha' nu ycui' ñi lo'o yu ta'a nda'an ñi: Ndi'in sca yu cuilyiya', lo' yu nguso nu nguia lo'o cunta tñan 'in yu, jui nu msu'hua qui'ya 'in yu si'yana ndlyijyi su'hua yu na nu ndi'in 'in x'nan yu. ");
INSERT INTO cya_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Xacan' msi'ya x'nan yu 'in yu lo' juin: ¿Ta cha' ñi ña'an nchcui' nten cha' 'in? Tsu'hue lati cha' tyaa cunta nu nguia lo'o si'yana a tca 'a cu'ni tñan re. ");
INSERT INTO cya_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nguñan ti' yu nguso can': ¿Ña'an ta cu'nin ñii, si'yana cua' chcuan yu x'nan cunta nu ntsu'hui yaan'? Nu ti' cu'nin tñan ni' quixin' a tca 'a 'ñan, lo' jyi'o tin' jñan lcuan 'in nten. ");
INSERT INTO cya_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Cua' jlyo tin' ña'an ntsu'hui cha' cu'nin, ña'an ca si'yana ti' caja nu cuan xu'hue 'ñan xa cua' mdyaan cunta re. ");
INSERT INTO cya_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Xacan' msi'ya yu 'in cunda scaa nten nu nducui 'in x'nan yu, lo' juin yu 'in nu mdiyaa culoo can': ¿Tsala nducui 'in yu x'nan? ");
INSERT INTO cya_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Lo' juin ne': Sca ciento barri ceite. Xacan' juin yu lo'o ne': Ndla ti cu'ni lo' chcua, su'hua nii quityi re lo' quinu na 'in lo'o tu'hua tyi. ");
INSERT INTO cya_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Juin yu 'in xca ne': Nu'huin, ¿tsala nducui? Mxcuen ne' 'in: Sca ciento cuijyin trigo. Xacan' juin yu lo'o ne': Nde su'hua nii lo' quinu na 'in lo'o jacua yla. ");
INSERT INTO cya_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","X'nan yu nguso can' yuhue 'a ti' yu 'in si'yana tiyaa 'a yu lo'o cha' mañan. Tsaña'an nguiaa cha' 'in nten chendyu, tiyaa la ne' lo'o cha' mañan que ña'an nguiaa cha' 'in sñe' Ndiose nu nda'an loo xaa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Cunen lo'o um sca cha': Cunan um ña'an nu chu'hui ta'a tsu'hue um lo'o cha' cuilyiya' nu ndi'in loo chendyu re, si'yana xa tsatii na, caja nu cuan xu'hue 'in um sca se'en tyi'in um ni' cuaan tsala xaa. ");
INSERT INTO cya_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sca nu ñi ndi'in cha' 'in lo'o sca cunta nu suhue ti, cui' cuaña'an ñi ndi'in cha' 'in lo'o cunta nu tnu. Sca nu a ñi ndi'in cha' 'in lo'o cunta nu suhue ti, cui' cuaña'an nguiaa cha' 'in lo'o cunta nu tnu. ");
INSERT INTO cya_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cha' a ñi ndi'in cha' 'in um lo'o cha' cuilyiya' nu ndi'in loo chendyu re, ¿ta caja nu xnu cunta 'in um lo'o sca cha' nu ñi ca? ");
INSERT INTO cya_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Cha' a ñi ndi'in cha' 'in um lo'o na 'in xca tucui, ¿ta caja nu taa na nu qui'ni ca'an 'in um? ");
INSERT INTO cya_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Sca nguso, a tca chu'hui tucua x'nan yu, si'yana ña'an ti'i yu 'in sca lo' xca can' lyee la chu'hui yu cunta 'in, uta lyee la su'hua loo yu 'in can' lo' xcuan tloo yu 'in xca. Ticui' cuaña'an a tca tyi'in tyaa um quiloo um 'in Ndiose lo' ticui' xaa lo'o cha' cuilyiya'. ");
INSERT INTO cya_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lo'o ne' fariseo ngune 'in ne' nchgaa cha' nu ycui' Jesús, lo' mdyisnan mstyi lyi'o ne' 'in ñi si'yana lyee 'a lca tiquee ne' lo'o tñi. ");
INSERT INTO cya_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Xacan' juin ñi 'in ne': 'Un nsuhui um tloo um ticuii' um, una Ndiose ndyu'hui lyoo ñi ña'an lca cusya 'in um. Na nu ndon loo 'in nten chendyu, Ndiose nxcuan tloo ñi 'in na. ");
INSERT INTO cya_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Xa ti' lyijyi tiyaan yu Xuhua, jui nu ycui' cha' 'in lee lo'o cha' nu mda'an ycui' yu nu mxiycui' Ndiose 'in cua' s'ni, una ti' xa mdiyaan yu ndyijyi nu nchcui' cha' tsu'hue 'in Ndiose tsaña'an ntsu'hui cha' culo ñi tñan 'in nten, lo' nchgaa ne' nsu'hua ne' juesa sten ne' loo cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ntsu'hui cha' tsatii cha' nu nchca ni' cuaan lo'o loo chendyu re, una si'i cuaña'an lo'o cha' 'in lee, si'yana hasta lo'o cha' nu suhue lati nducua loo na ntsu'hui cha' tsato'o na. ");
INSERT INTO cya_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nchgaa yu nu ndla' ti'in cuilyi'o, lo' cha' ca cuilyi'o yu 'in xca ne' cuna'an ngui'ni yu qui'ya, ticui' cuaña'an yu nu ca cuilyi'o 'in ne' cuna'an can', ticui' qui'ya ngui'ni yu. ");
INSERT INTO cya_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ndi'in sca yu cuilyiya' nu nchco' chacui' te' tsu'hue ña'an, lo' nchgaa tsaan ngui'ni yu ta'a nu tnu se'en ndi'in yu. ");
INSERT INTO cya_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tuna'an lyiya' 'in yu su sca yu ti'i naan Lázaro, ti' ña'aan yu nguxen quitso' 'in yu, ");
INSERT INTO cya_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","lyee lca tiquee yu cha' tca cu yu na nu nguilo nde ni' msa 'in yu cuilyiya' can', hasta xni' lo' ndyi'an le'e 'in loo quitso' can' 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yato'o ngujui yu ti'i can', lo' ya lo'o angujle 'in yu la ni' cuaan se'en nducua Abraham. A cunta lo'o yu cuilyiya' can' ngujui yu lo' mtsi' yu. ");
INSERT INTO cya_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ti' la se'en ndijin yu nu ti'i mscuen yu tloo yu, na'an yu 'in Abraham msu'hua tuscun 'in yu Lázaro. ");
INSERT INTO cya_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ycui' cueen yu cuilyiya' can': Abraham, 'un nu lca sti hua, ña'an 'tnan ti' um 'ñan, ca'an tñan um 'in Lázaro caan se'en ntsu'huin, cucha' sca loyaa' lo'o tyi'a lo' xicu'hua chin' tsen' se'en ndijin nu ti'i loo quii' re. ");
INSERT INTO cya_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Una Abraham mxcuen 'in yu: Sñen', quia yu'hui ti' tsala ña'an tsu'hue mdi'in loo chendyu, a sca na ya lyijyi 'in, lo' yu Lázaro ti'i 'a mdijin yu, una cua' ñii ndyijyi cha' tnu tiquee 'in yu, lo' nu'huin ndijin nu ti'i. ");
INSERT INTO cya_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A cunta tlu'hue la re ntsu'hui sca se'en xeen lo' qui'ñi na, nu ndi'in nde re a tca tyijyin tsaa nde cua, cui' cuaña'an lo'o nu ndi'in nde cua, a tca tyijyin caan nde re. ");
INSERT INTO cya_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Xacan' juin yu cuilyiya' can': Una jñan sca cha' tsu'hue 'in um, 'un nu lca sti hua, ca'an tñan um 'in Lázaro tsaa la na'an 'in stin, ");
INSERT INTO cya_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","si'yana ti' ndi'in cha ca'yu ta'a ngulan, lo' su'hua tiyaa 'in yu si'yana a caan yu tyijyin yu nu ti'i re. ");
INSERT INTO cya_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mxcuen Abraham 'in yu: Cua' nguinu scua cha' nu ngua'an Moisé lo'o cha' nu ngua'an yu nu mxiycui' Ndiose 'in cua' s'ni, can' cha' nu ntsu'hui cha' cu'ni cunta yu. ");
INSERT INTO cya_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Xacan' juin yu cuilyiya' can': Cha' ñi ña'an nu juin um, una cha' tyiqui'o sca nu cua' ngujui lo' tsaa se'en ndi'in yu, cui' xaa xilo'o chon' yu qui'ya ngui'ni yu. ");
INSERT INTO cya_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Una mxcuen Abraham 'in yu: Cha' a n'ni cunta yu cha' nu ngua'an scua Moisé lo'o cha' nu mxiycui' Ndiose 'in nchgaa la nguso 'in ñi, ticui' cuaña'an a tsa qui'an ti' yu 'in sca nu cua' mdyiqui'o lja ne' ngujui. ");
INSERT INTO cya_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Xacan' juin Jesús 'in yu ta'a nda'an ñi: A s'ni ljyaan scasca cha' ngunan' nu xityu 'in um loo qui'ya, ¡una 'tnan ca nu ljyan lo'o cha' ngunan' can'! ");
INSERT INTO cya_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ndyi'o la tñan yni can', caja nu scan' tucui sca quee tlyu nu ndiyo ne' trigo, lo' cuun ne' 'in loo tyi'a tujo'o, lo' si'i nu xityu can' 'in sca nu suhue ti re loo qui'ya. ");
INSERT INTO cya_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Can' cha' xñi um cunta 'in um. Cha' sca ta'a um cu'ni sca cha' ngunan' lo'o um, chcui' um lo'o si'ya cha' can', lo' cha' qui'ya can' cunta si'yana si'i ña'an m'ni, cu'ni um cha' tlyu ti' 'in. ");
INSERT INTO cya_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Cha' tnan' can' cha' 'in lo'o um tsa cati ya' sca tsaan, lo' cui' tsacua ya' xitucui jñan cha' tlyu ti' 'in um, cu'ni um cha' tlyu ti' 'in. ");
INSERT INTO cya_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yu ta'a nda'an Ñi X'nan na juin yu 'in ñi: Ta yaa um 'in hua si'yana lyee la tsa qui'an ti' hua 'in um. ");
INSERT INTO cya_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Xacan' juin Ñi X'nan na: Xñi um cunta tsala ña'an suhue mti mostaza, una cha' 'un ndiya qui'an ti' um 'ñan, tca chcui' um lo'o yca cua si'yana quiton na se'en nducua na lo' tsa yu'hui na loo tyi'a tujo'o, lo' cui' cuaña'an tsato'o. ");
INSERT INTO cya_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Cha' ndi'in sca nguso 'in um nu ngui'ni tñan nguita yuu uta na'an seen yu bta 'in um, lo' xa quila yu yaa yu tñan, ¿ta nga'an cha' chcui' um lo'o can': Chcua lya lo' ca xu'hue na nu nducua loo msa re? ");
INSERT INTO cya_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Ta si'i na nde ljuin um lo'o can': Cha'an ste' lo' cu'ni chu'hue na nu cu siin, lo' cu'ni cunta 'ñan lja nu cun, lo' ndi'a cu? ");
INSERT INTO cya_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ta ndyaa um xu'hue 'in yu nguso can' si'yana mducua yu tñan tsaña'an nu juin um lo'o yu? Nducua cha' si'i na. ");
INSERT INTO cya_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Cui' cuaña'an 'un, xa cua' mdyi y'ni um nchgaa tñan nu ngulon 'in um, tca ljuin um xacan': Lca hua sca nguso ti, lo' seen ti m'ni hua tsa tñan nu mdo'o ti 'in hua. ");
INSERT INTO cya_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Xacan' mdo'o Jesús nguiaa ñi tucueen Jerusalén, lo' mdijin ñi tu'hua yuu 'in ne' Samaria lo'o Galilea. ");
INSERT INTO cya_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Cua' tiyaa ti ñi sca quichen lyo' ti xa mdo'o tsa tii yu nu ti'i lo'o quitso' la, tijyo' ti ndon yu, ");
INSERT INTO cya_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","lo' nchcui' cueen yu: ¡Jesús, 'un ñi nu lca Bstro, ña'an 'tnan ti' um 'in hua! ");
INSERT INTO cya_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Xa na'an ñi 'in yu, xacan' juin ñi: Yaa um lo' culo'o um 'in um 'in yu nu ntsu'hui cunta 'in laa, ña'aan mdo'o yu nguiaa yu, mchca yu. ");
INSERT INTO cya_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Una sca yu can' xa na'an yu si'yana cua' mchca yu, cui' xaa mxitucui yu se'en ndon ñi, ycui' cueen yu lo' m'ni tnu yu 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","mdyi'ya xtyin' yu tloo Jesús tsaya' mdyi'ya ti'in yu tloo yu la lyuu, lo' mdyaa yu xu'hue 'in ñi, lo' lca yu ne' Samaria. ");
INSERT INTO cya_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Xacan' juin Jesús: ¿Ta si'i tsa tii lca um nu mchca um? Lo' cha caa yu can', ¿la ncua yu ñii? ");
INSERT INTO cya_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ta a jui xca tucui nu xitucui tyaa xu'hue 'in Ndiose, tyi ca ña'an sca yu mxitucui yu, lo' lca yu ne' Samaria? ");
INSERT INTO cya_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Xacan' juin ñi 'in yu: Tyiton lo' quiaa, mchca si'yana ya qui'an ti'. ");
INSERT INTO cya_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ne' fariseo mñicha' ne' 'in Jesús cha' ñi xaa tyisnan culo Ndiose tñan 'in nten, lo' mxcuen ñi 'in ne': Tsaña'an ntsu'hui cha' culo Ndiose tñan 'in nten, a ca chcan' ña'an tyisnan cha' can', ");
INSERT INTO cya_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ñi a caja nu ljuin: Nde re cua' mdiyaan na, ta nde cua ndi'in na. Una cunen lo'o um sca cha': Ndiose cua' ndlo ñi tñan 'in um. ");
INSERT INTO cya_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Lo' juin ñi 'in yu ta'a nda'an ñi: Tiyaa xaa, lyee ca lca tiquee um ti' ña'an um 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan siya' xca tsaan ti, una a la a quine cueen ñi. ");
INSERT INTO cya_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Caja nu chcui' lo'o um xacan': Nde re cua' mdiyaan ñi, ta nde cua ndi'in ñi. Una a nchca cha' tsaa um, lo' ñi a chcui ncha'an um 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Si'yana tsaña'an nchca ti' xa ndyuhui lo' nxtyi xaa chcua tyi'iin tso', cui' cuaña'an ca chcan' Yu Qui'yu nu Mdo'o nde ni' Cuaan tsaan nu ntsu'hui cha' quiaan ñi xiya'. ");
INSERT INTO cya_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Una culo nducua la 'ni cha' tyijyin ñi scasca nu ti'i, lo' xcuan tloo nten chendyu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tsaña'an m'ni nten xa mdi'in yu Noé, cui' cuaña'an cu'ni ne' xa tiyaa tsaan nu quiaan Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nten can' nchcu ne', ndyi'yo ne', scasca ne' ndyija cuilyi'o ne' tsaya' nu mdiyaa tsaan yten yu Noé ni' yca na'an, xacan' mdyisnan ngu'ya quio tnu lo' ngujlyo na 'in nchgaa nten can'. ");
INSERT INTO cya_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ticui' cuaña'an m'ni nten xa mdi'in yu Lot, nchcu ne', ndyi'yo ne', nsi'i ne' lo' ndyujui' ne' na, nguita ne' jyaan lo' ntñan ne' na'an, ");
INSERT INTO cya_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","una tsaan nu mdo'o yu Lot quichen Sodoma, mdyi'ya Ndiose quii' nu mxitiya' lo'o azufre, lo' ña'aan nten can' ngujlyo ne'. ");
INSERT INTO cya_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Cui' cuaña'an cu'ni nten tsaan nu ntsu'hui cha' ca chcan' loo Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Xacan' yu nu ndlyu nde que na'an 'in, a bla 'a qui'ya can' lyoo na nu ndi'in ña'an 'in, ticui' cuaña'an lo'o yu nu ngui'ni tñan ni' quixin', a bla 'a can' ti' xitucui nde ña'an 'in. ");
INSERT INTO cya_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Quia yu'hui ti' um ña'an yato'o 'in ne' cuna'an 'in yu Lot. ");
INSERT INTO cya_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Si'yana nchgaa nu ñan ti' culo laa 'in ticuii', tsato'o quinan' can' tiyaa xaa, una nchgaa nu tyaa chendyu 'in 'ñan, can' nu tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Cunen lo'o um, cui' tla xa ntsu'hui cha' tsato'o cha' re, tucua nu nscua loo qui'ñan, sca can' quiaa lo' xca can' quinu scua. ");
INSERT INTO cya_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A cunta tucua ne' cuna'an nu ndiyo sca se'en ti, sca can' quiaa lo' xca can' quinu ton. ");
INSERT INTO cya_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Uta tucua yu nu ngui'ni tñan ni' quixin', sca can' quiaa lo' xca can' quinu ton. ");
INSERT INTO cya_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yu ta'a nda'an ñi juin 'in ñi: Ñi X'nan hua, ¿la ta tsato'o cha' re? Xacan' mxcuen ñi 'in yu: Cui' se'en quinu tu'hui nu ngujui, can' ntsu'hui cha' quio' ti'in laxo. ");
INSERT INTO cya_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A cunta ti' ycui' la Jesús xca cha' lo'o yu ta'a nda'an ñi si'yana 'ni cha' chcui' lyi'o na 'in Ndiose nchgaa xaa, lo' a cu'ni na'an ti' na. ");
INSERT INTO cya_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ndeña'an juin ñi: Ndi'in sca yu bse sca quichen, ñi a ntsen yu tloo Ndiose, ñi tloo nten chendyu. ");
INSERT INTO cya_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A cunta quichen can' ndi'in sca ne' cuna'an nu nguinu lo'o cha' ycui' ti, nchgaa xaa nda'an ycui' ne' lo'o yu bse can': Cu'ni cuiya' um cha' 'in hua si'ya cha' 'in nu ti'i ti' 'in hua. ");
INSERT INTO cya_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yu bse can' a m'ni cunta yu cha' can' cui' xaa, una chon' nde'en can' nguñan ti' yu: Siya' a ntsen tloo Ndiose lo' ñi a n'ni suun 'in nten, ");
INSERT INTO cya_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","una ne' cuna'an re nda'an taa ne' cha' nsin' ti' 'ñan, can' cha' cu'ni cuiyan' cha' 'in ne', ña'an tu' tsatii cha' tlyu ti' 'ñan lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ti' juin la Ñi X'nan na: Ton nscan um tsaña'an ycui' yu bse nu a ñi ndi'in cha' 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xacan' jan ñi, ¿ta a ndla la cu'ni cunta Ndiose 'in nchgaa nu cua' mdo'o hui 'in ñi nu njñan 'in ñi tla lo' cucha? ¿Ta si'i cui' xaa ti xcuen ñi 'in can'? ");
INSERT INTO cya_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cunen lo'o um si'yana cui' xaa ti cu'ni cuiya' ñi cha' 'in can'. Una Yu Qui'yu nu Mdo'o nde ni' Cuaan, tsaan nu ntsu'hui cha' quiaan ñi xiya', ¿ta caja nu tsa qui'an ti' 'in ñi? ");
INSERT INTO cya_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ti' ycui' la Jesús xca cha', cui' cha' 'in nu nsuhui tloo ticuii' una nxcuan tloo 'in xca tucui, lo' juin ñi: ");
INSERT INTO cya_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tucua yu qui'yu mdiyaa yu ni' lyaa si'yana chcui' lyi'o yu 'in Ndiose, sca can' lca ne' fariseo, lo' xca can' lca nu ndlo tñi. ");
INSERT INTO cya_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ne' fariseo can' ndon ne' lo' nchcui' lyi'o ne' 'in Ndiose: Stina Ndiose, tyaan xu'hue 'in um si'yana a lcan ña'an nchca ti' nchgaa la tucui, yu cunan, yu nducun', yu nguiten yu'hui lo'o scasca ne' cuna'an, lo' ñi a lcan ña'an nchca ti' yu nu ndlo tñi re, ");
INSERT INTO cya_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","cui' ca nu n'nin ayuna tucua ya' sca snan, lo' ndaan lcuan loo tñi nu n'nin canan sca snan. ");
INSERT INTO cya_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Una yu nu ndlo tñi can' tijyo' ti ndon yu, ñi a xtyi ti' yu scuen yu tloo yu nde cuaan, cui' ca nu mdyisnan nycuan' yu jyan tiquee yu lo' nchcui' yu: Stina Ndiose, ña'an 'tnan ti' um 'ñan si'yana nan' lcan nten qui'ya chendyu. ");
INSERT INTO cya_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Una cunen lo'o um, yu re mxitucui yu nde ña'an 'in yu, a xca 'a qui'ya nducui yu tloo Ndiose, una si'i cuaña'an lo'o xca ne' can'. Si'yana nu nchca ti' scuen cuaan 'in ticuii', Ndiose ndyi'ya te'en ñi 'in can', una nu n'ni lyo' 'in, can' nu scuen cuaan Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Xacan' mdyisnan mdiyan lo'o ne' 'in nu suhue ti tloo Jesús si'yana tyi'in tyaa ñi yaa' ñi que, lo' yu ta'a nda'an ñi ngusun lo'o yu 'in nten nu ndiyaa can'. ");
INSERT INTO cya_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Una Jesús msi'ya ñi 'in yu lo' juin ñi: Tyaa um ya' caan nu suhue ti se'en nducuan, lo' a chcui ndijin um, si'yana can' nu ntsu'hui cha' qui'ni ca'an 'in se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nu cha' ñi cunen lo'o um, nu nchca ti' sten se'en ndlo Ndiose tñan, cha' a tsa qui'an ti' 'in ñi tsaña'an nguiaa cha' 'in nu suhue ti, a tca sten can'. ");
INSERT INTO cya_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yato'o sca nu ndon loo la 'in ne' judio mñicha' 'in Jesús: 'Un lca um sca nu tsu'hue 'a, ¿ñi na tca cu'nin si'yana caja chendyu nu a tsatii 'a 'ñan? ");
INSERT INTO cya_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mxcuen Jesús 'in yu: ¿Ñi cha' nchcui' si'yana lcan sca nten nu tsu'hue? A tucui nu tsu'hue, cui' ca nu scati Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Cua' jlyo ti' ña'an tñan ngulo Ndiose: —A sten yu'hui lo'o cuilyi'o nten, a cujui nten, a cu'ni cunan, a chcui' cha' cuiñi, cu'ni suun 'in tloo sti lo'o jyi'an—. ");
INSERT INTO cya_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mxcuen yu 'in ñi: Ti' lyon' nxu'huan se'en nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Xa ngune 'in Jesús cha' nu ycui' yu, juin ñi 'in yu: Xca ti cha' ya lyijyi 'in. Quiaa yjui' nchgaa na nu ndi'in 'in lo' cutsa tñi can' 'in nu ti'i, cuaña'an caja cha' cuilyiya' 'in la ni' cuaan, xacan' chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Xa ngune 'in yu cha' can', ngulu'un 'a ti' yu si'yana cuilyiya' 'a yu. ");
INSERT INTO cya_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Xa na'an Jesús si'yana ngulu'un ti' yu, xacan' juin ñi: Tucui 'a ña'an sten ne' cuilyiya' se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A tucui la tyijyin sca camello quito quiya' cuxa que ña'an nu sten ne' cuilyiya' se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lo' nu ngune 'in cha' can' mdyisnan ycui': ¿Ti nu tca tyi'o laa cha' na can'? ");
INSERT INTO cya_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Xacan' juin ñi: Cha' nu tucui 'in nten chendyu, a tucui na 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Xacan' juin yu Tyo: Huare' cua' mxnu ti'in hua nchgaa na nu ndi'in 'in hua, lo' nducui ncha'an hua 'in um. ");
INSERT INTO cya_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mxcuen Jesús 'in yu: Nu cha' ñi cunen lo'o um, cha' nde'en nu xnu tucua na'an 'in, uta xnu ti'in nten cula 'in, lo'o ta'a ngula, ta cuna'an 'in uta sñe', si'ya cha' 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","can' nu lyee la caja cha' tsu'hue 'in loo chendyu re, a cunta tiyaa xaa qui'ni ca'an 'in lo'o chendyu nu a tsatii 'a. ");
INSERT INTO cya_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Xacan' sca cunta mdo'o lo'o Jesús 'in yu ta'a nda'an ñi, lo' juin ñi 'in yu: Cua' ñii tsaa na Jerusalén, lo' tsato'o nchgaa cha' nu nguinu scua cha' 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan, tsaña'an ngua'an yu nu mxiycui' Ndiose 'in cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tyaa ne' 'in ñi tuyaa' ne' gentil, taa ne' cha' jyi'o 'in ñi, cu'ni lyi'o 'tnan ne' lo' su'hua siye' ne' tloo ñi. ");
INSERT INTO cya_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xa cua' mjyi'in ne' 'in ñi, xacan' cujui ne' 'in ñi, una xa cua' ca snan tsaan tyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Una yu ta'a nda'an ñi a ngu'ya yu cha' tiyaa si'yana ti' nchcun cha' tiyaa 'in yu, can' cha' a ngujlyo ti' yu cha' nu ycui' ñi. ");
INSERT INTO cya_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yato'o xa mdiyaa Jesús tu'hua quichen Jericó, tu'hua tucueen can' nducua sca yu cuityin' nu njñan lcuan 'in nten, ");
INSERT INTO cya_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","xa ngune 'in yu ndijin nten qui'an can', mñicha' yu cha' ñi na nchca. ");
INSERT INTO cya_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jui nu mtsa' 'in yu si'yana Jesús Nazaret nguiaa can'. ");
INSERT INTO cya_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Xacan' mdyisnan msi'ya cueen yu 'in ñi: Jesús, Sñe' ta nten 'in Davi, ña'an 'tnan ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nten nu nducua loo can' ngusun lo'o 'in yu si'yana chcua seen tu'hua yu, una nde lyee la msi'ya yu: Sñe' ta nten 'in Davi, ña'an 'tnan ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Xacan' ycan' ton Jesús, lo' ngulo ñi tñan si'yana tsa te'en ne' 'in yu. Xa mdiyaa yu se'en ndon ñi, mñicha' ñi 'in yu: ");
INSERT INTO cya_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Ñi na ta nchca ti' cu'nin lo'o? Mxcuen yu xacan': Ñi X'nan hua, nchca tin' si'yana quila xaa quiloon. ");
INSERT INTO cya_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Xacan' juin Jesús: Quila xaa quiloo, cua' mchca si'yana ya qui'an ti' 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ticui' xaa can' nguila xaa quiloo yu, lo' mducui ncha'an yu 'in ñi, m'ni tnu yu 'in Ndiose. Nchgaa nten xa na'an ne' cha' can' mdaa ne' loo Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús nguia ndijin ñi quichen Jericó, ");
INSERT INTO cya_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","can' ndi'in sca yu cuilyiya' naan Zaqueo, x'nan yu nu ndlo tñi. ");
INSERT INTO cya_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nchca ti' yu chu'hui lyoo yu 'in Jesús, una a ncua ña'an yu 'in ñi si'ya nten qui'an can', a cunta si'yana lyo' ti ndyon yu. ");
INSERT INTO cya_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Xacan' mdo'o yu msnan yu nde loo se'en ntsu'hui cha' tyijyin ñi, can' ycuen yu sca loo yca nu naan sicómoro se'en nu tca ña'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Xa mdijin Jesús can', mxina'an ñi nde cuaan lo' na'an ñi 'in yu, lo' juin ñi: Zaqueo, ndla ti qui'ya, si'yana cua' ñii tsa'an se'en ndi'in. ");
INSERT INTO cya_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ndla ndsa ti ngu'ya yu, tsu'hue ntsu'hui tiquee yu ncuan xu'hue yu 'in ñi se'en ndi'in yu. ");
INSERT INTO cya_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Xa na'an nten cha' can', scasca ne' mdyisnan ycui' ne' ñi cha' mdiyaa ñi se'en ndi'in sca nten qui'ya chendyu. ");
INSERT INTO cya_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Xacan' mdyiton yu Zaqueo se'en nducua yu lo'o Ñi X'nan na, lo' juin yu: Ñi X'nan hua, cua' ñii taan tsa tlu'hue na nu ndi'in 'ñan 'in nu ti'i ña'an chendyu 'in, lo' cha' nde'en nu ngulon tñi 'in lo'o cha' mañan, tsa jacua ta xu'huan 'in na 'in. ");
INSERT INTO cya_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Lo' juin Jesús 'in yu: Na'an re ndi'in sca nu cua' mdo'o laa, si'yana lo'o yu lca yu ta nten 'in Abraham. ");
INSERT INTO cya_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan ljyan nan ñi 'in nu ngunan' yu'hui si'yana tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Si'yana ndon nscan ne' cha' nu nchcui' ñi, mdyisnan ycui' ñi xca cha', a cunta cui' ti can' ndi'in Jerusalén, lo' nten can' ñan ti' ne' si'yana ticui' xaa tyisnan culo Ndiose tñan 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Juin ñi xacan': Sca yu qui'yu nu ndon loo la 'in ne' nguiaa yu sca se'en tijyo', si'yana chcuan yu sca cha' cuiya' nu culo yu tñan, la xacan' xitucui yu. ");
INSERT INTO cya_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Xa ti' lyijyi tyi'o yu msi'ya yu 'in tsa tii nguso 'in yu, lo' mdaa yu tñi 'in cunda scaa yu, lo' juin yu 'in: Cu'ni um tñan lo'o tñi re 'ñan lja tsa'an lo' xitucuin. ");
INSERT INTO cya_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Una ta'a quichen tyi yu ti'i ti' ne' 'in yu, lo' ngua'an tñan ne' tucua snan nu ya su'hua qui'ya 'in yu se'en nguiaa yu, lo' juin ne': A nchca ti' hua si'yana culo yu cua tñan 'in hua. ");
INSERT INTO cya_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yato'o xa cua' mchcuan yu cha' cuiya' can' nguila yu, xacan' msi'ya yu 'in nguso nu mchcuan cunta tñi can', si'yana ca cuiya' ti' yu tsala cua' m'ni na canan. ");
INSERT INTO cya_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Lo' juin nu mdiyaan culoo can': Ñi X'nan hua, tsa tii tñi m'nin canan lo'o tñi nu mdaa um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Lo' juin x'nan yu xacan': Tsu'hue 'a, nu'huin lca sca nguso nu ñi ndi'in cha' 'in, loo nu mducua tñan lo'o tsachin' na nu mxnun 'in, can' cha' cua' ñii ntsu'hui cha' culo tñan 'in tsa tii quichen. ");
INSERT INTO cya_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Xacan' mdiyaan xca yu, lo' juin yu: Ñi x'nan hua, tsa ca'yu tñi m'nin canan lo'o tñi nu mdaa um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ticui' cuaña'an juin x'nan can' 'in: Lo'o nu'huin ntsu'hui cha' culo tñan 'in tsa ca'yu quichen. ");
INSERT INTO cya_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chon' nde'en can' mdiyaan xca yu lo' juin: Ñi x'nan hua, nde tñi nu mdaa um 'ñan, tsu'hue 'a yu'hui se'en na 'ñan, ");
INSERT INTO cya_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ytsen 'in um si'yana tla 'a ndi'in tyaa um sca cha', nchcuan um lo'o na nu a ndaa um, lo' nxo' um na nu a ntya um. ");
INSERT INTO cya_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Xacan' mxcuen x'nan yu 'in yu: Nu'huin lca sca nguso nu a ñi ndi'in cha' 'in, ticuii' chon' yaan cha' nu ycui'. Cha' jlyo ti' si'yana tla cha' nchcuin', nchcuan lo'o na nu a ndaan, lo' nxon' na nu a ntyan, ");
INSERT INTO cya_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿ñi cha' a mdaa tñi can' jñi' xca tucui, lo' nu nguilan cua' ñii chcuan 'in na lo'o sñe' na? ");
INSERT INTO cya_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Xacan' juin x'nan can' 'in nu ndon cui' ti can': Chcuan um tñi 'in yu re, lo' taa um 'in na 'in nu cua' su tsa tii na 'in. ");
INSERT INTO cya_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mxcuen ne': Ñi X'nan hua, una yu cua cua' su tsa tii tñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Una cunen lo'o um sca cha', nchgaa nu cua' ndi'in cha' tsu'hue 'in nde caja la na 'in, una nu a ndi'in na 'in, lo'o tsachin' na nu ndi'in 'in nde caja nu lyaa 'in na. ");
INSERT INTO cya_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A cunta lo'o nu ti'i ti' 'ñan, nu a ncua ti' ca ja'an 'ñan, can lo'o um 'in can' lo' cujui um 'in. ");
INSERT INTO cya_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Xa cua' mdyi ycui' ñi cha' can', mducua loo ñi nguiaa ñi nde quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yato'o xa cua' tiyaa ti jun quichen Betfagé lo'o quichen Betania, cui' ti can' nducua qui'ya nu nchcui' ne' lo'o lca Olivo, lo' mxitucua loo ñi 'in tucua yu ta'a nda'an ñi, ");
INSERT INTO cya_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","lo' juin ñi 'in yu: Yaa um se'en ndi'in quichen lyo' ti cua, lo' xa sten um tu'hua quichen cua, ña'an um chcan' ton sca burru cune' ti nu a nchca tucui chcua. Xtin' um 'in 'in lo' quian lo'o um 'in 'in. ");
INSERT INTO cya_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Cha' nde'en nu cuñicha' 'in um: ¿Ñi cha' nxtin' um 'in 'in? Lo' ljuin um 'in ne' si'yana Ñi X'nan na nchca ti' 'in 'in. ");
INSERT INTO cya_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xacan' mdo'o chcuaa yu can' nguiaa yu, lo' nguija lyoo yu 'in 'in tsaña'an nu juin ñi lo'o yu. ");
INSERT INTO cya_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lja ndon xtin' yu 'in 'in, mdo'o x'nan 'in lo' juin lo'o yu: ¿Ñi cha' nxtin' um burru cua? ");
INSERT INTO cya_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mxcuen yu 'in ne': Si'yana Ñi X'nan na nchca ti' 'in 'in. ");
INSERT INTO cya_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Xacan' nguila lo'o yu 'in 'in se'en ndon Jesús, msla scua yu ste' yu chon' 'in, lo' mda yaa' yu 'in ñi ycuen ñi chon' 'in. ");
INSERT INTO cya_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Cua' yaa ña'an nguiaa ñi, msla sti ne' ste' ne' tucueen can'. ");
INSERT INTO cya_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Xa cua' nguiaa ñi tsalcui quiya' qui'ya Olivo can', nchgaa nu nguia ncha'an 'in ñi tsatlyu lo'o ta'a nda'an ñi, ndyijyin ya' tsu'hue ntsu'hui tiquee ne' nchcui' cueen ne', lo' ngui'ni tnu ne' 'in Ndiose si'ya scasca cha' tnu nu na'an ne', ");
INSERT INTO cya_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","lo' nchcui' ne': —Tlyu cha' tsu'hue ntsu'hui 'in ñi nu lca Ree nu ljyaan lo'o cha' cuiya' 'in Ñi X'nan na—. Cua' m'ni chu'hue ñi cha' 'in na la ni' cuaan, cu'ni tnu na 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Xacan' tucua snan ne' fariseo nu nguiaa lja nten can' juin ne' 'in ñi: 'Un ñi nu lca Bstro, xun lo'o um 'in ta'a nda'an um re si'yana chcua seen tu'hua ne'. ");
INSERT INTO cya_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mxcuen ñi 'in ne': Cunen lo'o um sca cha', cha' nten re chcua seen tu'hua ne', quee cua tsato'o chcui' cueen na xacan'. ");
INSERT INTO cya_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cua' tiyaa ti ñi tu'hua quichen Jerusalén, una xa na'an ñi 'in na, ngu'ya sca tu'hua tiquee ñi lo' ynan ñi si'ya na, ");
INSERT INTO cya_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","lo' juin ñi 'in quichen can': Cha' cua na tca ca cuiya' ti' um cha' nu cu'ni tsu'hue lo'o um, siya' cua' tsu'hue sca tsaan ti re ñii, una mchcun yu'hui cha' re tso' nu 'in um. ");
INSERT INTO cya_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Si'yana cua' ljyaan tsaan nu chen chcui 'in um, xa caan ta'a cusuun um su'hua lo'o 'in um, tñan can' xca lo'o quee chcua tyi'iin tso' se'en ndi'in um, lo' cuaña'an su'hua nchcun 'in um, ");
INSERT INTO cya_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","cujlyo can' 'in um siya' ti tsatlyu lo'o sñe' um, lo' ñi sca quee lo' a quinu scua 'a na chon' ta'a na, si'yana a ncuan xu'hue um 'in ñi nu ljyaan se'en ndi'in um. ");
INSERT INTO cya_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Xacan' yten ñi ni' lyaa, lo' ngulo ñi 'in nchgaa nu ndujui' lo' nsi'i na tuna'an lyiya' can'. ");
INSERT INTO cya_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Juin ñi 'in nten can': Quityi 'in Ndiose nchcui' na: —Na'an 'ñan lca na se'en nchcui' lyi'o ne' 'ñan—, lo' 'un ngui'ni um 'in na lca na —na'an tyi yu cunan—. ");
INSERT INTO cya_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Cunda scaa tsaan ndlo'o ñi 'in nten ni' lyaa can', una yu nu ndlo ca tñan, tsatlyu lo'o ne' escriba lo'o qui'yu cula, ngunan ne' ña'an nu cujui ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Una a jui ña'an cu'ni ne' tsaña'an nu nchca ti' ne', si'yana ña'aan quichen can' tsu'hue ndon nscan ne' cha' nu ndlo'o ñi. ");
INSERT INTO cya_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yato'o xca tsaan lja ndlo'o Jesús 'in nten ni' lyaa, nchcui' ñi cha' tsu'hue 'in Ndiose, lo' tucua snan yu nu ndlo ca tñan ni' lyaa, tsatlyu lo'o ne' escriba, lo'o qui'yu cula mdiyaa ne' se'en ndon ñi, ");
INSERT INTO cya_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","lo' juin ne' 'in ñi: Quitsa' 'in hua, ¿la jui cha' cuiya' 'in lo'o cha' nu ngui'ni re, lo' ti nu mdaa 'in na 'in? ");
INSERT INTO cya_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mxcuen Jesús 'in ne': Lo'on nan' nchca tin' cuñichan' 'in um sca cha', cha' ña'an xcuen um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yu Xuhua nu mducua tya 'in nten, ¿ta ni' cuaan mdo'o cha' cuiya' 'in yu, uta na nten chendyu mdaa 'in na? ");
INSERT INTO cya_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xacan' scasca ne' mñicha' ta'a ne': Cha' ljuin na si'yana ni' cuaan mdo'o cha' cuiya' can', tina'an xcuen yu 'in na, ¿ñi cha' a ya qui'an ti' um 'in yu? ");
INSERT INTO cya_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Cha' ljuin na si'yana nten chendyu mdaa cha' cuiya' can', una ña'aan quichen ne' jyi'in ne' quee 'in na, si'yana ncua cuiya' ti' ne' yu Xuhua can' ncua yu sca nu mxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mxcuen ne' 'in ñi si'yana a jlyo ti' ne' ti nu mdaa cha' cuiya' can'. ");
INSERT INTO cya_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Xacan' juin Jesús 'in ne': Lo'on nan' a tca quitsan' 'in um la jui cha' cuiya' 'ñan lo'o cha' nu ngui'nin re. ");
INSERT INTO cya_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Xacan' mdi'in tyaa Jesús sca cha' lo'o nten can' lo' juin ñi: Sca yu qui'yu yta sca jyan chacui' ti uva, lo' mxnu yu 'in na nda tlu'hue lo'o yu nu chu'hui cunta 'in na, xacan' mdo'o yu nguiaa yu sca se'en tijyo' x'ni ya'. ");
INSERT INTO cya_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Xa mdiyaa xaa nu ntsu'hui cha' quio' mti can', ngua'an tñan yu sca nguso nu chcuan cunta na nu qui'ni ca'an 'in yu. Una yu nu ntsu'hui cunta tñan can' mjyi'in 'in yu nu mdiyaa can', lo' mducui xu'hua 'in yu nguiaa yu cua ti ña'an. ");
INSERT INTO cya_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","X'nan tñan can' ngua'an tñan yu xca nguso 'in yu, una ticui' cuaña'an mjyi'in yu 'in nu mdiyaa can', cua' ña'an ti m'ni lyi'o yu 'in, lo' mducui xu'hua yu 'in nguiaa cua ti ña'an. ");
INSERT INTO cya_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yu x'nan tñan can' ngua'an tñan yu xca nguso 'in yu, nu cua' nchca snan juesa, ticui' ti ña'an yjui yuhua' yu 'in nu mdiyaa can' lo' ngulo yu 'in nde chon' lo'o. ");
INSERT INTO cya_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Xacan' nguñan ti' x'nan tñan can': ¿Ña'an ta cu'nin ñii? Ca'an tñan ycui' ca sñen' nu ta'a la 'ñan, tina'an cu'ni cunta yu cha' nu nchcui' can' xa tiyaa la cua. ");
INSERT INTO cya_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Una yu nu ntsu'hui cunta 'in tñan can', xa na'an yu ljyaan sñe' x'nan tñan can' mdyisnan ycui' scasca yu: Nde ljyaan yu nu quinu ca tñan re 'in, ndla ti um lo' cujui na 'in yu lo' quinu tñan re 'in na. ");
INSERT INTO cya_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Cui' xaa ngulo yu 'in nde chon' lo'o, lo' yjui yu 'in. Xacan' jan ñi, ¿ña'an ta cu'ni x'nan tñan can' lo'o yu? ");
INSERT INTO cya_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cui' ca nu xitucui yu lo' cujui yu 'in nu ntsu'hui cunta tñan can', lo' taa yu 'in na cu'ni cunta xca tucui. Xa ngune 'in ne' cha' nu ycui' ñi, juin ne' xacan': ¡A cula ya' Ndiose 'in na! ");
INSERT INTO cya_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Una Jesús mxina'an ñi se'en ndon ne' lo' juin ñi: ¿Ñi cha' nchca ti' chcui' quityi 'in Ndiose xa nchcui' na: —Quee nu mscuan tloo yu cuityi na'an, cua' ñii lca na quee nu nsñi ton 'in na'an—? ");
INSERT INTO cya_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nchgaa nu tlyu scua chon' quee can', quita can', una cha' quee can' tyu na chon' ne', jlyo ne' siya' ti. ");
INSERT INTO cya_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Xacan' yu nu ndlo ca tñan ni' lyaa lo'o ne' escriba ngunan ne' ña'an nu quinu Jesús ticui' xaa, si'yana ngu'ya ne' cunta cha' 'in ne' ycui' ñi, una a msti ti' ne' xñi ne' 'in ñi si'yana nguitsen ne' 'in nten quichen can'. ");
INSERT INTO cya_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Una xa jui ña'an 'in ne' ngua'an tñan ne' tucua snan nu tsaa lo'o cha' mañan, lo' cu'ni can' 'in si'yana lca sca nten nu suun, ña'an ca si'yana su'hua ne' qui'ya 'in ñi lo'o cha' nu chcui' ñi, la xacan' tyaa ne' 'in ñi tuyaa' bsya nu cu'ni cuiya' cha' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Lo' mñicha' ne' 'in ñi: 'Un ñi nu lca Bstro, cua' jlyo ti' hua si'yana cui' ña'an ndlo'o um, a cunta scaña'an ti n'ni um 'tnan 'in nten, lo' ndlo'o um cha' nu ñi 'in Ndiose tsaña'an nu ntsu'hui cha' cu'ni na. ");
INSERT INTO cya_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Ta ti' tsu'hue taa na tñi nu njñan yu César, uta na a tsu'hue 'a? ");
INSERT INTO cya_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Una ngüi ti' ñi si'yana nchcui' ne' lo'o cha' mañan, xacan' juin ñi 'in ne': ¿Ñi cha' ta nchcui' um lo'on cuaña'an? ");
INSERT INTO cya_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tyaa um sca tñi 'ñan, ña'an na. ¿Tucui ca 'in lcuin nga'an chon' tñi re, lo' ti nu niin nga'an 'in na? Xacan' mxcuen ne' 'in ñi: Yu César. ");
INSERT INTO cya_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Juin ñi xacan': Tyaa um 'in César na nu ntsu'hui cha' qui'ni ca'an 'in yu, cui' cuaña'an taa um 'in Ndiose na nu qui'ni ca'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Si'ya nten qui'an can' a jui ña'an su'hua ne' qui'ya 'in ñi lo'o cha' nu ycui' ñi, cui' ca nu nguinu ton seen ne' lo' yuhue 'a ti' ne' lo'o cha' nu mxcuen ñi. ");
INSERT INTO cya_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xacan' mdiyaa tucua snan ne' saduceo se'en ndon ñi, cui' nu a ndiya qui'an ti' si'yana ntsu'hui cha' tyiqui'o nten, lo' mñicha' ne' 'in ñi: ");
INSERT INTO cya_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","'Un ñi nu lca Bstro, yu Moisé ndeña'an ngua'an yu sca cha': —Sca yu qui'yu nu cua' jui cuilyi'o lo' cha' caja yu, lo' ñi sca sñe' ne' lo' a mdi'in lo'o yu, xacan' ticui' ta'a ngula nu ngujui can' tyi'in lyi'o 'in ne' cuna'an can', lo' cha' tyi'in sñe' ne' cu'ni ne' cunta si'yana sñe' ne' lo'o cuilyi'o ca ne' lca can'—. ");
INSERT INTO cya_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tyi'in tyaa na sca cha', ndi'in tsa cati yu qui'yu, sca ta'a ngula ti yu. Yu nu cula la can' jui cuilyi'o yu, lo' ngujui yu, una a mdi'in sñe' ne' lo'o yu. ");
INSERT INTO cya_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Xacan' yu nu cua' nchca tucua can' mdi'in lyi'o 'in ne' cuna'an can', ticui' cuaña'an ngujui yu, lo' ñi sca sñe' ne' lo' a mdi'in lo'o yu. ");
INSERT INTO cya_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ticui' cuaña'an yato'o lo'o nu cua' nchca snan can', ngujui yu, lo' scaña'an ti yato'o 'in ta'a cati yu can', lo' a mdi'in sñe' ne' lo'o yu. ");
INSERT INTO cya_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yato'o lo'o ne' cuna'an can' ngujui ne'. ");
INSERT INTO cya_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Xacan' jan ñii, xa ntsu'hui cha' tyiqui'o nten, ¿ti ña'an yu can' lca cuilyi'o ca ne' cuna'an can', si'yana ta'a cati yu mdi'in lyi'o yu 'in ne'? ");
INSERT INTO cya_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Xacan' mxcuen Jesús 'in yu: Nten chendyu re ndyijyi cuilyi'o ne', ");
INSERT INTO cya_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","una nten un tyiqui'o lo' ntsu'hui xu'hue lo'o xca chendyu, a ntsu'hui 'a cha' ti' caja cuilyi'o ne', ");
INSERT INTO cya_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","lo' ñi a ntsu'hui 'a cha' ti' caja can', si'yana su'hua ña'an ndi'in cha' 'in lo'o angujle, cua' lca can' sñe' Ndiose si'ya cha' nu mdyiqui'o. ");
INSERT INTO cya_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Una tsaña'an ndi'in cha' 'in ne' ngujui nu ntsu'hui cha' tyiqui'o, yu Moisé ngua'an yu cha' re xa na'an yu 'in yca quiche' nu ndiquin can', lo' nchcui' na si'yana Ñi X'nan na lca ñi —Ndiose 'in Abraham, Ndiose 'in Isaac, Ndiose 'in Jacob—. ");
INSERT INTO cya_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A lca ñi Ndiose 'in ne' ngujui, cui' ca nu lca ñi Ndiose 'in ne' nu lo'o, si'yana cunta cha' nu 'in ñi nchgaa nten lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Xacan' tucua snan ne' escriba juin 'in ñi: 'Un ñi nu lca Bstro, cui' ña'an nu ycui' um. ");
INSERT INTO cya_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lo' ñi xca cha' a msti 'a ti' ne' cuñicha' ne' 'in ñi. ¿Ti nu sñe' 'in Cristo? ");
INSERT INTO cya_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Xacan' juin ñi 'in nten can': ¿Ñi cha' ta nchcui' nten si'yana Cristo lca ñi ticui' sñe' ta nten 'in Davi? ");
INSERT INTO cya_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","¿Ta si'i ticui' Davi ngua'an yu sca cha' loo quityi Salmo, lo' nchcui' na: —Ndiose X'nan na juin ñi lo'o Ñi X'nan: Chcua tso' cueen 'ñan, ");
INSERT INTO cya_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","lja xicu'nin 'in ta'a cusuun quinu nde tuquiya'—? ");
INSERT INTO cya_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ticuii' Davi ndlo'o naan 'in ñi si'yana lca ñi X'nan yu, ¿lo' ña'an ta lca ñi sñe' ta nten 'in yu cha' na can'? ");
INSERT INTO cya_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lja ndon nscan nten can' cha' nu nchcui' ñi, juin ñi 'in yu ta'a nda'an ñi: ");
INSERT INTO cya_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Xñi um cunta 'in um lo'o ne' escriba, cui' nu nducui ti' nchco' te' tucuin nu tsu'hue ña'an, nducui ti' ne' xa ndyijyi nu nchcui' cha' 'in ne' lo'o suun ña'an se'en nchca quiya', a cunta nchcua ne' la loo se'en n'ni tnu ne' 'in Ndiose uta se'en nchca ta'a, ");
INSERT INTO cya_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","a cunta ndlyaa ne' na'an 'in ne' cuna'an nu nguinu lo'o cha' ycui' ti, can' cha' chaan nchcui' lyi'o ne' 'in Ndiose tloo na'an nten, una can' tlyu la nu ti'i tyijyin tiyaa xaa. ");
INSERT INTO cya_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mxina'an ñi se'en ndlyu tucua snan ne' cuilyiya' ndyi'ya lcuan ni' lyaa can'. ");
INSERT INTO cya_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A cunta na'an ñi xa mdiyaa sca ne' cuna'an nu ti'i ña'an chendyu 'in nu nguinu lo'o cha' ycui' ti, can' mdyi'ya ne' tucua ti tñi suhue ti. ");
INSERT INTO cya_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Juin ñi xacan': Nu cha' ñi cunen lo'o um, ne' cuna'an nu nguinu lo'o cha' ycui' ti re, ti'i ña'an 'in ne', una qui'an la lcuan mdyi'ya ne' que 'in nchgaa la ña'an nten re. ");
INSERT INTO cya_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Si'yana nten re mdyi'ya ne' lcuan lo'o tñi nu cua' nguinu ti 'in ne', una ne' cuna'an re, lo'o cha' ti'i chendyu 'in ne' mdyi'ya ne' ña'aan tñi nu su 'in ne', tñi nu ntsu'hui cha' cunajo'o 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mdyisnan ycui' tucua snan yu cha' 'in laa can', si'yana ndyi'ya 'a nguia' cuityi na lo'o quee nu lca lcuan nu mdaa ne', lo' juin ñi 'in yu: ");
INSERT INTO cya_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tsaña'an nu na'an um nducua na cua' ñii, una tiyaa xaa caja nu xicuten 'in na, lo' ñi xca quee re a quinu scua 'a na chon' ta'a na. ");
INSERT INTO cya_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Xacan' mñicha' yu 'in ñi: 'Un ñi nu lca Bstro, quitsa' um 'in hua ñi xaa tsato'o cha' re, ¿lo' ña'an ca cuiya' ti' hua xa nu cua' nchcui cuii' cha' re? ");
INSERT INTO cya_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mxcuen ñi 'in yu: Xñi um cunta si'yana a tucui nu cuñilyi'o 'in um, si'yana qui'an 'a nu caan lo' chcui' si'yana ljyaan lo'o cha' cuiya' 'ñan, lo' chcui' can': Nan' lcan Cristo, uta ljuin: Cua' mdiyaa xaa nu tyi'o laa um. Una a chcui ncha'an um 'in can'. ");
INSERT INTO cya_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Xa cunan um cha' si'yana cua' nchca cusuun scasca se'en, a nchca cha' cutsen um si'yana nchgaa cha' re ntsu'hui cha' tsato'o na culo nducua la, una si'i can' cha' cua' tsatii chendyu. ");
INSERT INTO cya_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ti' juin la ñi: Scasca quichen tnu tyi'in suun, ");
INSERT INTO cya_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ntsu'hui cha' quiñan lyee ya', a cunta scasca se'en ntsu'hui cha' qui'ya bju'ñan uta quicha, lo' ca chcan' loo cha' nu cutsen nten lo'o cha' nu tnu nde ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Una xa ti' lyijyi tsato'o nchgaa cha' re, ntsu'hui cha' quinu um tuyaa' nu xitijin 'in um nu ti'i, lo' tyaa ne' cunta 'in um yaa' yu nu ntsu'hui cunta se'en n'ni tnu ne' 'in Ndiose, su'hua ne' 'in um na'an chcuan, lo' si'ya cha' 'ñan tsa lo'o ne' 'in um tloo bsya tnu uta tloo ree, ");
INSERT INTO cya_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","cuaña'an tca taa um suun ña'an nguiaa cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ñi a su'hua um cha' nduhue ti' tiquee um ña'an ntsu'hui cha' xcuen um 'in nu cu'ni cuiya' cha' 'in um, ");
INSERT INTO cya_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","si'yana cui' xacan' taan cha' tiyaa 'in um lo'o cha' nu chcui' um, lo' nchgaa nu ti'i ti' 'in um a quija lyoo ña'an xcuen 'in um uta ljuin si'yana si'i ña'an nchcui' um. ");
INSERT INTO cya_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hasta lo'o nten cula 'in um, ta'a ngula um, nten 'in ti um, uta ta'a tsu'hue um ntsu'hui cha' tyaa 'in um yaa' bsya, lo' ntsu'hui um caja nu cujui 'in um, ");
INSERT INTO cya_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","lo' nchgaa tucui xcuan tloo 'in um si'ya cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Una ñi sca quichan' que um lo' a ntsu'hui cha' quinan' na. ");
INSERT INTO cya_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Cha' 'un ta loo um lo'o cha' nu ljyaan 'in um, xacan' tyi'o laa um. ");
INSERT INTO cya_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Una xa ña'an um si'yana cua' msu'hua lo'o sindatu 'in quichen Jerusalén, ca cuiya' ti' um si'yana cua' jlyo quichen can'. ");
INSERT INTO cya_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Xacan' nchgaa nten nu ndi'in se'en lyi'ya loo Judea xnan yu'hui ne' loo qui'ya, cui' cuaña'an nu ndi'in quichen can' tyi'o tso' ne', lo' nu ngui'ni tñan ni' quixin' a xitucui 'a can' nde quichen. ");
INSERT INTO cya_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Si'yana lca na sca tsaan nu xitijin Ndiose 'in ne' nu ti'i, lo' tsato'o nchgaa cha' nu cua' nguinu scua loo quityi 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Una 'tnan ca ne' cuna'an nu cua' mxilyo ña'an, lo'o ne' nu nguiti' sñe' xacan', si'yana caan nu ti'i tnu loo chendyu re, si'ya cha' nsin' ti' nu ntsu'hui tiquee Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tyisnan cujui ne' 'in nten lo'o spada, a cunta ntsu'hui nu tsa lo'o ne' 'in preso sca chcui chendyu, quichen Jerusalén can' ntsu'hui cha' quinu na tuyaa' ne' gentil, lo' cu'ni ne' ña'an nu nchca ti' ne' lo'o na tsaya' nu tsa tucua tsaan nu cua' mdi'in tyaa Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Xacan' ca chcan' cha' nu tnu loo cucha, loo coo', lo'o loo cuii, nten chendyu lyee 'a su'hua ne' cha' tiquee ne', lo' a jlyo 'a ti' ne' ña'an ti' cu'ni ne' tsaña'an nu cueen ne tyi'a tujo'o si'yana lyee nguitsa na, ");
INSERT INTO cya_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","tyisnan ña'an ti' ne' loo nu lyee nguitsen ne', si'ya scasca cha' tnu nu cua' ljyaan loo chendyu re, si'yana —lo'o ni' cuaan ntsu'hui cha' quiñan tucui na—. ");
INSERT INTO cya_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Xacan' ña'an ne' 'in —Yu Qui'yu nu Mdo'o nde ni' Cuaan quiaan ñi ni' ndlaa— lo'o cha' cuiya' nu tlyu, lo' xtyi sca xaa nu tsu'hue ña'an. ");
INSERT INTO cya_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Xa tyisnan ca chcan' cha' re, cu'ni tnu tiquee um lo' scuen um tloo um nde cuaan, si'yana cua' mdiyaa braa nu tyi'o laa um. ");
INSERT INTO cya_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mdi'in tyaa ñi xca cha' lo' juin ñi: Xñi um cunta tsaña'an nguiaa cha' 'in yca higo lo'o scasca la yca, ");
INSERT INTO cya_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","xa ña'an um si'yana cua' tyisnan chcua lca' cojo' na, cua' jlyo ti' um si'yana cua' nchcui cuii' cha' quila quio. ");
INSERT INTO cya_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Cui' cuaña'an 'un xa ña'an um cua' nchca scasca cha' can', ca cuiya' ti' um si'yana cua' nchcui cuii' cha' nu culo Ndiose tñan 'in nten. ");
INSERT INTO cya_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nu cha' ñi cunen lo'o um, ta nten re ti' ndi'in ne' xa nu ntsu'hui cha' ca nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ni' cuaan lo'o chendyu re, a la 'a quine cueen na tiyaa xaa, una cha' nu nchcuin' lo'o um quinu scua na tsala xaa. ");
INSERT INTO cya_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Can' cha' xñi um cunta si'yana a cha'an yu'hui ni' cusya 'in um lo'o cha' nu nchca loo chendyu re, cha' cu'hui, cha' tucun', ña'an tu' lja xacan' tsati ntyin caan cha' tnu can' chon' um. ");
INSERT INTO cya_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Si'yana cha' tnu can' ntsu'hui cha' caan na tsaña'an nchca ti' sca can' chon' nten chendyu. ");
INSERT INTO cya_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Can' cha' tyi'in tiyaa um lo' chcui' lyi'o um 'in Ndiose nchgaa xaa si'yana ta loo um tyijyin um nchgaa cha' re, lo' cuaña'an tiyaa um tloo Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Cunda scaa tsaan ndyi'an lo'o ñi 'in nten ni' lyaa can', lo' xa nxiin tsaan nxitucui ñi nde loo qui'ya se'en lca Olivo. ");
INSERT INTO cya_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Can' cha' tlya ti ndiyaa nten ni' lyaa can', si'yana quine 'in ne' cha' nu ndlo'o ñi. ");
INSERT INTO cya_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Cua' nchcui cuii' cha' cu'ni ne' ta'a pascua, cui' xa nchcu ne' jaslya nu a yu'hui suun 'in. ");
INSERT INTO cya_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yu nu ndlo ca tñan ni' lyaa lo'o ne' escriba nan ne' ña'an nu cujui ne' 'in Jesús, una lo'o cha' mañan si'yana nguitsen ne' tloo nten quichen. ");
INSERT INTO cya_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yu Juda nu nchcui' ne' lo'o lca Iscariote, cui' ta yu nu tichcua can', yten Laxa'an ni' cusya 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ya y'ni cuiya' yu cha' lo'o nu ndlo ca tñan ni' lyaa, tsatlyu lo'o nu lca que 'in silyiya cha' 'in laa, ña'an ntsu'hui cha' tyaa yu 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mdiyaa 'a ti' ne' cha' can', lo' m'ni cuiya' ne' cha' lo'o yu si'yana su'hua lyiya' ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ncua sca cha' ti 'in yu lo'o ne', lo' ngunan yu ña'an tyaa yu 'in Jesús lja nu a ndlyu nten. ");
INSERT INTO cya_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mdiyaa tsaan xa nchcu ne' jaslya nu a yu'hui suun 'in, lo' lca na tsaan nu 'ni cha' cujui ne' 'in slya' si'ya ta'a pascua. ");
INSERT INTO cya_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Xacan' ngua'an tñan Jesús 'in yu Tyo lo'o yu Xuhua, lo' juin ñi 'in yu: Yaa um lo' cu'ni chu'hue um na nu cu siin na ta'a pascua re. ");
INSERT INTO cya_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Juin yu 'in ñi: ¿La nchca ti' um cu'ni chu'hue hua 'in na? ");
INSERT INTO cya_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mxcuen ñi 'in yu: Ña'an jan ñi, xa sten um loo quichen cua, can' chcua ta'a um lo'o sca yu nu lyi'ya sca te'en tyi'a, chcui ncha'an um 'in yu tsaya' sten yu sca na'an. ");
INSERT INTO cya_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chcui' um lo'o yu nu lca x'nan na'an can': Ndeña'an juin ñi nu lca Bstro: ¿La nducua na'an se'en cu siin ñi lo'o yu ta'a nda'an ñi ta'a pascua re? ");
INSERT INTO cya_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Quitsa' yu 'in um se'en nducua sca na'an tlyu nu cua' nchca tucua nde cuaan, can' cua' ndi'in nchgaa na nu cunajo'o 'in na, can' ntsu'hui cha' cu'ni chu'hue um na nu cu siin na. ");
INSERT INTO cya_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xacan' mdo'o yu nguiaa yu, lo' chcui ña'an juin ñi lo'o yu cuaña'an yato'o, can' m'ni chu'hue yu na nu cu siin jun ta'a pascua. ");
INSERT INTO cya_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Xa mdiyaa braa can', yten tucua ñi tu'hua msa tsatlyu lo'o yu ta'a nda'an ca ñi. ");
INSERT INTO cya_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lo' juin ñi 'in yu: Lyee 'a ncua lca tiqueen cu siin na lo'o um ta'a pascua re, lja nu ti' lyijyi tijin nu ti'i. ");
INSERT INTO cya_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cunen lo'o um sca cha', a cu'nin 'an siin ta'a pascua re cha' si'i la se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Xacan' msñi ñi vaso se'en ntsu'hui vino, mdyaa ñi xu'hue 'in Ndiose, lo' juin ñi 'in yu: Xñi um 'in na nchgaa um, lo' ca xu'hue um 'in na. ");
INSERT INTO cya_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cunen lo'o um sca cha', a co'on 'an vino re cha' si'i la se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Xacan' msñi ñi jaslya, mdyaa ñi xu'hue 'in Ndiose, msu'hue ñi 'in na, lo' mdaa ñi 'in na 'in yu, xacan' juin ñi: Nde nu lca cunan' nan', lo' si'ya um tyaan 'ñan. Tsa quiñan um cu'ni um cha' re lo' quia yu'hui ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Xa mdyi ycu siin ñi, cui' cuaña'an msñi ñi vaso se'en ntsu'hui vino can', lo' juin ñi: Nde sca cha' nu cui ti, lo' si'ya tnen nu quilo si'ya um caja ña'an cu'ni chu'hue um cha' 'in um lo'o Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ña'an um jan ñi, nde nducua na sca se'en ti lo'o nu ntsu'hui cha' tyaa 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nu cha' ñi si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan ntsu'hui cha' tyijyin ñi tsaña'an cha' nu cua' ngua'an 'in ñi, una 'tnan ca yu nu ntsu'hui cha' tyaa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Xacan' scasca yu mñicha' ta'a yu cha' ti ña'an yu cu'ni yu cha' can'. ");
INSERT INTO cya_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A cunta mdyisnan nchcui' tyijyin yu cha' ti ña'an yu lca yu nu ndon loo la. ");
INSERT INTO cya_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Xacan' juin ñi 'in yu: Yu ree ndi'in loo chendyu re tla 'a ndlo yu tñan 'in nten, lo' ti' nchcui' ne' si'yana lca yu sca nu nda yaa' 'in nten, ");
INSERT INTO cya_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","una 'un si'i cuaña'an cu'ni um, si'yana sca nu ndon loo lja um ntsu'hui cha' cu'ni lyo' can' 'in, lo' yu nu ntsu'hui cunta 'in um cu'ni can' 'in tsaña'an nchca ti' sca nguso. ");
INSERT INTO cya_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Xacan' jan ñi, ¿ti ña'an nu ndon loo la, nu nducua tu'hua msa uta nu nsu'hua na loo msa? ¿Ta si'i nu nducua tu'hua msa can'? Una nan' lcan tsaña'an nchca ti' sca nguso 'in um. ");
INSERT INTO cya_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Cuaña'an 'un a nchca cula yaa' um 'ñan lo'o nchgaa nu ti'i ndijin. ");
INSERT INTO cya_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Can' cha' taan sca cha' cuiya' 'in um se'en culo um tñan, cui' tsaña'an mdaa Stin cha' cuiya' 'ñan, ");
INSERT INTO cya_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","si'yana tca chcua um lo' cu na sca loo msa ti la se'en ntsu'hui cha' culon tñan, a cunta ntsu'hui cha' chcua um lo' cu'ni cuiya' um cha' 'in ta'a tichcua ta ne' Israel. ");
INSERT INTO cya_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Lo' ti' juin la Ñi X'nan na: Simón, Simón, cunen lo'o sca cha', Laxa'an cua' mjñan cha' cuiya' si'yana scuin ti'in 'in tsaña'an nchca ti' nscuin ne' mti trigo. ");
INSERT INTO cya_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Una nan' cua' mjñan 'in Ndiose si'ya cha' 'in, si'yana a cu'ni na'an ti' lo'o cha' nu ndiya qui'an ti', lo' xa nu'huin tyiton, taa cha' tnu tiquee 'in ta'a ndiya qui'an ti'. ");
INSERT INTO cya_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Xacan' juin yu 'in ñi: Ñi X'nan hua, cua' m'nin tiqueen si'yana si'i tsaloo na'an chcuan ti tsa'an lo'o um, cui' ca nu cajan lo'o um. ");
INSERT INTO cya_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Lo' juin ñi: Tyo, cunen lo'o sca cha', ti' lyijyi xi'ya latyee lo' snan ya' chcui' si'yana a ndyu'hui lyoo 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ti' juin la ñi lo'o yu: Xa ngua'an tñan 'in um yaa um, nen lo'o um si'yana a cui'ya um tñi, ñi cuijyin, ñi a cui'ya um quinan, ¿ta nde'en la na ya lyijyi 'in um xacan'? Mxcuen yu 'in ñi: A sca na. ");
INSERT INTO cya_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Juin ñi 'in yu: Una cua' ñii, tca cui'ya um tñi lo'o cuijyin, lo' nu a ntsu'hui spada 'in, tca cujui' ste' lo' xi'i sca na. ");
INSERT INTO cya_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cunen lo'o um sca cha', 'ni cha' tsato'o 'ñan tsaña'an cha' nu cua' nguinu scua loo quityi 'in Ndiose, lo' nchcui' na: —Tsatlyu mda'an ñi lo'o yu nducun'—. Nchgaa cha' nu cua' nguinu scua si'ya cha' 'ñan, tsaloo na ca ti na. ");
INSERT INTO cya_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Xacan' mxcuen yu 'in ñi: Ñi X'nan hua, nde lo'o tucua spada 'in hua. Lo' juin ñi: Cui' lya lo'o cuati. ");
INSERT INTO cya_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Xacan' mdo'o ñi nguiaa ñi nde loo qui'ya Olivo, cui' tsaña'an cha' nu cua' ntsu'hui 'in ñi, lo'o yu ta'a nda'an ñi nducui ncha'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Xa mdiyaa ñi can' juin ñi 'in yu: Chcui' lyi'o um 'in Ndiose si'yana a sten cha' ngunan' tiquee um. ");
INSERT INTO cya_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mdo'o ntan ñi sii' yu tsaña'an cuiya' se'en nduguun ne' sca quee, can' mdyi'ya xtyin' ñi lo' mdyisnan ycui' lyi'o ñi 'in Ndiose: ");
INSERT INTO cya_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","'Un ñi nu lca Stin, cha' a tyijyin yu'hui tijin nu ti'i re, una ñi si'i ña'an nu nchca tin', cui' ca nu cu'ni um ña'an nu nchca ti' um. ");
INSERT INTO cya_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Xacan' ngulo'o tloo sca angujle 'in ñi nu mdo'o nde ni' cuaan si'yana ta yaa' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Loo cha' ti'i nga'an 'in ñi, nde lyee la ycui' lyi'o ñi 'in Ndiose, lo' mdyisnan nguilo tyi'a ta ñi la lyuu tsaña'an nchca ti' tne. ");
INSERT INTO cya_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Xa mdyi ycui' lyi'o ñi 'in Ndiose, mdyiton ñi lo' nguila ñi se'en nducua yu ta'a nda'an ñi, nguija lyoo ñi 'in yu lja' yu si'yana lyee lu'un ti' yu. ");
INSERT INTO cya_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Lo' juin ñi 'in yu: ¿Ñi cha' ta lja' um? Tyitucui um lo' chcui' lyi'o um 'in Ndiose si'yana a sten cha' ngunan' tiquee um. ");
INSERT INTO cya_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lja nchcui' ñi cha' can' mdiyaan nten qui'an, lo' yu Juda cui' ta yu tichcua can', nducua loo yu loo nten can', mdiyaa yu se'en ndon Jesús si'yana chcui' cha' yu la sii' sca' ñi. ");
INSERT INTO cya_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Xacan' juin Jesús 'in yu: Juda, ¿ta cuaña'an mdyaa 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan lo'o ña'an nu ycui' cha' 'ñan? ");
INSERT INTO cya_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Xa na'an yu ta'a nda'an ñi cha' nu nchca, lo' juin yu 'in ñi: Ñi X'nan hua, ¿ta si'yu hua 'in ne' lo'o spada re? ");
INSERT INTO cya_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sca yu ta'a nda'an ñi msi'yu nscan yu nguso 'in nu ndlo ca tñan ni' lyaa can', tso' cueen 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Xacan' mxcuen Jesús 'in yu: Cui' lya tsacua ti ña'an. Xacan' yla' Jesús nscan yu nguso can', cui' xaa mchca na 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Xacan' ycui' Jesús lo'o nchgaa nu ljyan y'ni lyi'o 'in ñi, cui' nu ndlo ca tñan ni' lyaa tsatlyu lo'o nu lca que 'in silyiya nu ntsu'hui cuan 'in laa, lo'o qui'yu cula, lo' juin ñi 'in yu: ¿Ñi cha' lo'o yca lo'o spada nducua yaa' um ljyan 'ya um 'ñan tsaña'an nchca ti' um lo'o sca yu cunan? ");
INSERT INTO cya_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nchgaa xaa nguilyun lo'o um ni' lyaa, ¿ñi cha' a msñi um 'ñan xacan'? Una cua' ñii mdiyaa braa nu nta um tsaña'an nu ndlo laxa'an tñan 'in um. ");
INSERT INTO cya_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xacan' msñi ne' 'in Jesús, ya lo'o ne' 'in ñi se'en nducua na'an 'in yu nu ndlo ca tñan ni' lyaa. Yu Tyo can' tijyo' ti mducui ncha'an yu 'in nten can'. ");
INSERT INTO cya_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tlu'hue la lyiya' mxiqui'o ne' quii', tyi'iin sii' na yten tucua ne', a cunta lo'o yu Tyo yten tucua yu lja can'. ");
INSERT INTO cya_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sca ne' cuna'an nu lca nguso, xa na'an ne' si'yana lo'o yu Tyo nducua yu can', mxina'an tsu'hue ca ne' 'in yu, lo' juin ne': Lo'o yu re ta'a nda'an yu cua. ");
INSERT INTO cya_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Una mscuan tloo yu cha' can' lo' juin yu: A ndyu'hui lyoon 'in yu nu nchcui' um cha' 'in cua. ");
INSERT INTO cya_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chon' nde'en can' ticui' cuaña'an juin sca yu 'in yu Tyo can': Lo'o nu'huin ta'a nda'an yu cua. Mxcuen yu xacan': A lo'on nan'. ");
INSERT INTO cya_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tsa ndyijyin sca braa ti, mdo'o ycui' xca yu lo' juin yu: Nu cha' ñi s'ni, si'yana lo'o yu re lca yu ta'a nda'an yu cua, si'yana lca yu ne' Galilea. ");
INSERT INTO cya_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mxcuen yu Tyo: A jlyo tin' ñi cha' nchcui'. Lja nu ti' nchcui' yu cha' can' mdo'o si'ya sca latyee. ");
INSERT INTO cya_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Xacan' Ñi X'nan na mxina'an ñi se'en ndon yu Tyo can', cui' xaa nguia yu'hui ti' yu cha' nu ycui' ñi xa juin ñi lo'o yu: Ti' lyijyi xi'ya latyee lo' snan ya' chcui' si'yana a ndyu'hui lyoo 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mdo'o yu Tyo can' nde lyiya', lo' ynan yu si'yana ndyijyin ya' ti'i nga'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yu nu nsñi cunta 'in Jesús mxiycha' ne' lo' mjyi'in ne' 'in ñi, ");
INSERT INTO cya_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","a cunta mscan' ne' sca te' tloo ñi, mycuan' ne' 'in ñi, lo' juin ne': ¿Chcui' ña'an na cha' ti ca mycuan' tloo? ");
INSERT INTO cya_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Qui'an 'a cha' ti'i ycui' ne' lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Xa ngu'ya xaa can', tsatlyu nguio' ti'in nchgaa qui'yu cula lo'o yu nu ntsu'hui ca cunta laa 'in ne' lo'o ne' escriba, mdiya lo'o ne' 'in ñi se'en ntsu'hui cha' ca cuiya' cha' 'in ñi, lo' juin ne' 'in ñi: ");
INSERT INTO cya_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","¿Ta cui' lca Cristo? Quitsa' la 'in hua. Mxcuen ñi 'in ne': Cha' cunen lo'o um si'yana cuin', a tsa qui'an ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A cunta cha' cuñichan' 'in um sca cha', ñi a xcuen um 'ñan, lo' ñi a culaa um 'ñan. ");
INSERT INTO cya_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Una ti' cua' ñii —sten tucua Yu Qui'yu nu Mdo'o nde ni' Cuaan tso' cueen 'in Ndiose—. ");
INSERT INTO cya_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nchgaa ne' juin ne' 'in ñi: ¿Ca nu Sñe' Ndiose lca xacan'? Mxcuen ñi 'in ne': 'Un nchcui' um cuaña'an. ");
INSERT INTO cya_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Xacan' juin ne': A 'ni 'a cha' ti' cunan na xca tucui nu taa suun cha' 'in yu re, si'yana cui' na ngune 'in na cha' nu mdo'o tu'hua yu. ");
INSERT INTO cya_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Cui' ña'an lcaa mdyiton nchgaa nten can', lo' ya lo'o ne' 'in Jesús tloo yu Pilato. ");
INSERT INTO cya_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mdyisnan msu'hua ne' qui'ya 'in ñi tloo yu, lo' nchcui' ne': Nguija lyoo hua 'in yu re nxilo ti'in yu 'in nten quichen, nchcui' yu si'yana a taa 'a hua tñi cha' 'in yu César, a cunta nchcui' yu si'yana cui' yu lca yu Cristo, lo' lca yu ree. ");
INSERT INTO cya_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Xacan' mñicha' yu Pilato 'in ñi: ¿Ta cui' lca Ree 'in ne' judio? Mxcuen ñi 'in yu: 'Un nchcui' um cha' re. ");
INSERT INTO cya_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Xacan' juin yu Pilato 'in nten lo'o yu nu ndlo ca tñan ni' lyaa can': A sca qui'ya nguija lyoon 'in yu re. ");
INSERT INTO cya_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Una nten can' nde lyee la mdon loo cha' 'in ne' lo' nchcui' ne': Nxilo ti'in yu 'in nten quichen lo'o cha' nu ndlo'o yu ña'aan se'en lyi'ya loo Judea, lo' mdyisnan yu ti' la se'en lca Galilea. ");
INSERT INTO cya_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Xa ngune 'in yu Pilato si'yana m'ni tyi'ya ne' Galilea, xacan' mñicha' yu 'in ne' cha' Jesús lca ñi ne' Galilea. ");
INSERT INTO cya_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Xa ncua cuiya' ti' yu Pilato si'yana mdo'o ñi se'en lyi'ya loo Galilea se'en ndlo yu Herode tñan, xacan' ngulo yu tñan si'yana tsa lo'o ne' 'in ñi tloo yu Herode, si'yana lja xacan' nguilyu yu quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mdiyaa 'a ti' yu xa na'an yu 'in Jesús, si'yana cua' s'ni nchca ti' yu ña'an yu 'in ñi, qui'an 'a cha' cua' ynan yu lo' nta yu cha' ñi xaa cu'ni ñi sca cha' nu tnu tloo yu. ");
INSERT INTO cya_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Qui'an 'a cha' mñicha' yu 'in ñi, una a sca cha' can' mxcuen ñi. ");
INSERT INTO cya_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nchgaa yu nu ntsu'hui cunta laa 'in ne' tsatlyu lo'o ne' escriba, nde lyee la msu'hua ne' qui'ya 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Xacan' yu Herode lo'o sindatu 'in yu mscuan tloo 'in ñi lo' mxiycha' yu 'in ñi, lo' mxico' yu sca te' tsu'hue ña'an 'in ñi, xiya' ngua'an tñan yu 'in ñi nde se'en ndi'in yu Pilato can'. ");
INSERT INTO cya_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Cuaña'an mchca tsu'hue cha' 'in yu Pilato lo'o yu Herode, si'yana ti' culoo a tsu'hue ndi'in yu. ");
INSERT INTO cya_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Xacan' mxo' ti'in yu Pilato 'in nchgaa nu ndlo tñan ni' lyaa, tsatlyu lo'o yu nu lyi'ya tñan lo'o nten quichen can', ");
INSERT INTO cya_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","lo' juin yu 'in ne': Mdiyan lo'o um 'in yu re tloon lo' nchcui' um si'yana nxilo ti'in yu nten quichen, una cua' mxicunen 'in yu tloo na'an um, lo' a sca qui'ya nguija lyoon 'in yu ña'an nu ndlo qui'ya um 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ñi yu Herode, lo' a ngulo qui'ya 'in yu xa ngua'an tñan 'in yu yaa yu. Can' cha' cunen lo'o um, a ndyi'o tñan caja yu si'yana a sca qui'ya m'ni yu. ");
INSERT INTO cya_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Culaan 'in yu ndi'a xa cua' m'ni yu. ");
INSERT INTO cya_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sca cha' nu ntsu'hui 'in ne', njñan ne' si'yana ndlyaa sca preso cunda scaa yjan xa nchca ta'a can'. ");
INSERT INTO cya_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Una nten qui'an can' tsatlyu nchcui' cueen ne': ¡Yjui um 'in yu re lo' culaa um 'in yu Barrabás! ");
INSERT INTO cya_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ntsu'hui yu na'an chcuan si'yana mxilo ti'in yu nten quichen, a cunta yjui yu nten. ");
INSERT INTO cya_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Xiya' ycui' yu Pilato lo'o nten can' si'yana ntsu'hui tiquee yu culaa yu 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Una nten can' ycui' cueen ne': ¡Jyi'in ca'an um 'in yu loo cusi, jyi'in ca'an um 'in yu loo cusi! ");
INSERT INTO cya_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Xacan' ycui' yu Pilato lo'o nten can' nu cua' nchca snan ya': ¿Ñi na ta m'ni yu re? A sca qui'ya nguija lyoon 'in yu nu hasta lo'o caja yu. Can' cha' qui'ni yu lo' ndi'a culaan 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Una nde lyee la ycui' cueen ne' lo' mjñan ne' cha' si'yana cha'an ñi loo cusi. Mdon loo cha' 'in ne' tsatlyu lo'o nu ntsu'hui cunta laa 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Xacan' mdaa yu Pilato cha' cuiya' si'yana cu'ni ne' ña'an nu nchca ti' ne'. ");
INSERT INTO cya_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ngulaa yu 'in yu nu mjñan nten can', yu nu ntsu'hui na'an chcuan si'yana mxilo ti'in yu nten, a cunta yjui yu nten, lo' mdyaa yu Pilato cunta 'in Jesús yaa' ne'. ");
INSERT INTO cya_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tucueen nguia lo'o ne' 'in ñi mchcua ta'a ne' lo'o sca yu yaa tñan ni' quixin', yu Simón nu mdo'o quichen Cirene, mxicu'ni ne' 'in yu si'yana cui'ya yu cusi nu lyi'ya Jesús lo' chcui cha'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Qui'an 'a nten nguia ncha'an 'in ñi, cui' cuaña'an ne' cuna'an nguia ynan si'ya ñi. ");
INSERT INTO cya_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Una Jesús mxina'an ñi nde chon' se'en ljyaan ne', lo' juin ñi 'in ne': 'Un ne' cuna'an Jerusalén, a cunan lo'o um 'ñan, cui' ca nu cunan lo'o um 'in um lo'o sñe' um. ");
INSERT INTO cya_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Cunen lo'o um sca cha', ljyaan sca tsaan xa caja nu chcui': Tsu'hue ca xu'hue ne' cuna'an nu a mdaa Ndiose cha' cuiya' tyi'in sñe', nu a siya' mxilyo ña'an, ñi a na'an ne' yti' sñe' ne'. ");
INSERT INTO cya_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","—Xacan' chcui' nten can' lo'o qui'ya: Cho'o ti'in um 'in hua, cui' cuaña'an chcui' ne' lo'o qui'ya suhue ti: Tucun ti'in um 'in hua—. ");
INSERT INTO cya_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cha' cuaña'an ngui'ni lyi'o ne' 'in sca yca yi'a, ña'an la ca cu'ni ne' lo'o sca yca ngutyi. ");
INSERT INTO cya_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A cunta nguia lo'o ne' 'in tucua yu nducun' si'yana tsatlyu caja yu lo'o Jesús. ");
INSERT INTO cya_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Xa mdiyaa ne' se'en naan que jyi'o, can' mjyi'in ca'an ne' 'in ñi loo cusi, a cunta lo'o yu nducun' nga'an yu loo cusi, scaa yu sca tso' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Xacan' juin Jesús: 'Un ñi nu lca Stin, cu'ni um cha' tlyu ti' 'in nten re si'yana a jlyo ti' ne' ñi na ngui'ni ne'. —Ticui' lja can' mtsa ne' sten', ngulo ne' xu'hue ne' lo'o na—. ");
INSERT INTO cya_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nten can' nan' 'ya ne' 'in ñi, lo' yu nu lyi'ya tñan can' nchcui' ca'an 'in ñi: Yu re ngulo laa yu 'in xca tucui, ¿ñi cha' a culo laa yu 'in yu cha' na cha' ñi ca lca yu Cristo, ñi nu mdo'o hui ca 'in Ndiose? ");
INSERT INTO cya_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Lo'o yu sindatu mstyi lyi'o 'in ñi, lo' ncua ti' yu xico'o yu vinagre 'in ñi, ");
INSERT INTO cya_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","lo' nchcui' yu: Cha' nu'huin lca Ree 'in ne' judio, culo laa 'in ticuii'. ");
INSERT INTO cya_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A cunta nga'an sca cha' que cusi can' lo'o cha' griego, cha' latin, lo'o cha' hebreo, lo' nchcui' na: Nde yu nu lca Ree 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sca yu nducun' nu ta'a nga'an ñi loo cusi mdyisnan ycui' ca'an yu 'in ñi: Cha' nu'huin lca Cristo, culo laa 'in ticuii', xacan' culo laa 'in hua. ");
INSERT INTO cya_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mxcuen xca yu can' lo' ngusun lo'o yu 'in: Ñi tsachin' ti lo' a ntsen nu'huin tloo Ndiose, lo' re ña'an ndijin na nu ti'i. ");
INSERT INTO cya_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nu cha' ñi ntsu'hui suun 'in na tyijyin na nu ti'i re, si'ya tñan ngunan' nu m'ni na, una yu re a sca cha' ngunan' m'ni yu. ");
INSERT INTO cya_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Xacan' juin yu 'in Jesús: Quia yu'hui ti' um 'ñan xa tiyaa um se'en culo um tñan. ");
INSERT INTO cya_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Xacan' mxcuen Jesús 'in yu: Nu cha' ñi cunen lo'o, ti' cua' ñii cua' ndi'in lo'on la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tsa ntsu'hui ndyi'ya cuaan tsaya' mdiyaa braa cua' snan siin, ngu'ya tla yta sca chcui se'en can'. ");
INSERT INTO cya_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Cucha a mdu'hui 'a na xaa, lo' te' tlyu nu nducui la ni' lyaa can' mda' na tlu'hue la na, mdo'o na tucua yu'hue. ");
INSERT INTO cya_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Xacan' cueen 'a msi'ya Jesús: 'Un ñi nu lca Stin, —tuyaa' um xnun cusya 'ñan—, lo' ña'aan mdyi ycui' ñi cha' re ngujui ñi. ");
INSERT INTO cya_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Xa na'an yu nu lca que 'in sindatu cha' nu yato'o, cui' xaa m'ni tnu yu 'in Ndiose lo' juin yu: Nu cha' ñi s'ni, yu re ncua yu sca nten nu ñi ndi'in cha' 'in tloo Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nten qui'an nu nguio' ti'in can' xa na'an ne' cha' nu yato'o, mxitucui ne' lo' mycuan' ne' jyan tiquee ne' loo nu ti'i nga'an 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Una nchgaa nu lca ta'a tsu'hue ñi lo'o jun cuna'an nu mducui ncha'an 'in ñi ti' la se'en lca Galilea, tijyo' ti ndon jun nan' 'ya jun. ");
INSERT INTO cya_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Can' ndi'in sca yu naan See nu mdo'o quichen Arimatea se'en lyi'ya loo Judea, lca yu sca qui'yu cula 'in ne' judio, tsu'hue nten lca yu lo' ñi ndi'in cha' 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Lo'o yu nta yu cha' ñi xaa culo Ndiose tñan 'in nten, a cunta xa m'ni cuiya' ne' cha' 'in Jesús a ncua ta'a lo'o yu 'in ne', ñi lo'o ña'an nu m'ni ne'. ");
INSERT INTO cya_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ya jñan yu cha' cuiya' 'in Pilato cha' tca cutsi' yu 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Xa mdyi'ya yu 'in ñi loo cusi nguxen yu sca te' 'in ñi, lo' ya tsi' yu 'in ñi sca tuquee nu cua' lca nguiaa', se'en nu a nchca tucui quitsi'. ");
INSERT INTO cya_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lca na vierne siin nu cua' tyisnan xitñan' ne' judio. ");
INSERT INTO cya_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tsalca jun cuna'an nu mducui ncha'an 'in ñi ti' la se'en lca Galilea, mdiya ncha'an jun 'in yu se'en mtsi' ñi, lo' na'an jun ña'an mdi'in tyaa yu 'in ñi ni' tucuaa can'. ");
INSERT INTO cya_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Xacan' mxitucui jun nguiaa jun, m'ni chu'hue jun tyi'a xityi'i nu chu'hui 'in Jesús, lo' mxitñan' jun tsaan can' ña'an cha' nu cua' ntsu'hui 'in ne'. ");
INSERT INTO cya_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Una culoo tsaan nu mducua snan can', tlya ti nguiaa jun cuna'an tucuaa can', lyi'ya jun tyi'a xityi'i nu cua' ncua tsu'hue, a cunta lo'o chcua xnan jun cuna'an ta'a nguiaa jun. ");
INSERT INTO cya_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Xa mdiyaa jun na'an jun si'yana cua' mdo'o ntan quee nu nchcun tucua can'. ");
INSERT INTO cya_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xacan' yten jun lo' 'a na'an 'a jun su Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lja ndon yuhue ti' jun cha' can', tsati ntyin mdo'o ton tucua yu qui'yu nu lco' te' tsu'hue ña'an xaa. ");
INSERT INTO cya_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lyee ytsen jun, can' cha' mdyi'ya tucui jun tloo jun, lo' juin yu 'in jun: ¿Ñi cha' nda'an nan um 'in sca nu lo'o lja ne' cua' ngujui? ");
INSERT INTO cya_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A ntsu'hui 'a ñi re, cua' mdyiqui'o ñi. Quia yu'hui ti' um ña'an ycui' ñi lo'o um xa mdi'in ñi se'en lca Galilea, ");
INSERT INTO cya_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","xa juin ñi: Yu Qui'yu nu Mdo'o nde ni' Cuaan, caja nu tyaa 'in ñi yaa' nten qui'ya chendyu, jyi'in ca'an ne' 'in ñi loo cusi, una nu cua' ca snan tsaan ntsu'hui cha' tyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Xacan' nguia yu'hui ti' jun cha' nu ycui' ñi. ");
INSERT INTO cya_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Cui' xaa mdo'o jun nguia ytsa' jun 'in cha tixca yu ta'a mda'an ñi lo'o nchgaa la ña'an jun cha' nu yato'o. ");
INSERT INTO cya_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tsalca jun nu mdaa suun cha' re lo'o yu ta'a mda'an ñi lca María Magdalena, Juana, lo'o María jyi'an Jacobo, a cunta lo'o chcua xnan jun cuna'an nu ta'a nda'an jun. ");
INSERT INTO cya_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Una yu ta'a mda'an ñi msque' ti' si'yana la xnan ycui' tinto jun cuna'an can', lo' a ya qui'an ti' yu 'in jun. ");
INSERT INTO cya_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Una yu Tyo can' msnan yu ya na'an yu se'en mtsi' ñi, lo' xa msti quiloo yu na'an yu su te' nu nguxen ti ñi, xacan' mxitucui yu lo' ndyijyin ya' nduhue ti' yu si'ya cha' nu ya' to'o can'. ");
INSERT INTO cya_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yato'o cuii' tsaan can' mxitucui tucua yu nu nguiaa nde quichen Emaús, lo' a tijyo' nguinu na quichen Jerusalén, tsa ntsu'hui lyoo tixca kilometro. ");
INSERT INTO cya_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nguia taa yu cha' ña'an cha' nu yato'o can'. ");
INSERT INTO cya_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lja nguia ycui' yu cha' can', mdiya ncha'an Jesús 'in yu, ");
INSERT INTO cya_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","una mchcun cha' tiyaa 'in yu lo' a ncua chu'hui lyoo yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Lo' juin ñi 'in yu: ¿Ñi cha' ta nguia taa um, lo' lu'un ti' um? ");
INSERT INTO cya_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sca yu can' naan yu Cleofas, lo' mxcuen yu 'in ñi: ¿Ta scati nu'huin yaa Jerusalén, a nchca ca jlyo ti' cha' nu yato'o nu cua' nchca snan tsaan ti re? ");
INSERT INTO cya_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Xacan' juin ñi 'in yu: ¿Ñi na ta nchca? Mxcuen yu 'in ñi: Cui' cha' 'in Jesús Nazaret, sca nu mxiycui' Ndiose 'in, tlyu cha' cuiya' mda'an lo'o ñi lo'o cha' nu ycui' ñi lo'o ña'an nu m'ni ñi, lo' yu'hui cuiya' ti' Ndiose 'in ñi, cui' cuaña'an lo'o nten. ");
INSERT INTO cya_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yato'o nguinu ñi tuyaa' yu nu ntsu'hui cunta cha' 'in laa tsatlyu lo'o nu lca bsya 'in na, lo' ngulo qui'ya ne' 'in ñi tsaya' nu mjyi'in ca'an ne' 'in ñi loo cusi. ");
INSERT INTO cya_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Una huare' ncua ti' hua si'yana cui' ñi culo laa ñi 'in ne' Israel, lo' cua' nguiaa snan tsaan yato'o cha' re. ");
INSERT INTO cya_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A cunta tucua snan jun cuna'an msu'hua jun cha' nduhue ti' tiquee hua, tlya re ñii yaa jun tucuaa can', ");
INSERT INTO cya_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lo' si'yana a nguija lyoo 'a ñi 'in jun mxitucui jun, mdaa jun suun si'yana na'an xñii jun angujle, can' nu mtsa' 'in jun si'yana lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Cui' cuaña'an tucua snan yu ta'a nda'an hua yaa yu tucuaa can', lo' nguija lyoo yu 'in na chcui ña'an juin jun cuna'an can', una a na'an yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Xacan' mxcuen ñi 'in yu: ¡Ta chin' 'a cha' tiyaa 'in um, ta a ndiya qui'an ti' um nchgaa cha' nu ngua'an scua yu nu mxiycui' Ndiose 'in cua' s'ni! ");
INSERT INTO cya_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ta si'i culo nducua la ntsu'hui cha' tyijyin ñi nu lca Cristo nu ti'i, la xacan' sten ñi la ni' cuaan loo xaa 'in ñi? ");
INSERT INTO cya_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Xacan' ti' la suun se'en mdyisnan ngua'an yu Moisé ngulyo scua la ñi cha' 'in ñi lo'o yu, cuaña'an ya quiñan ñi lo'o cunda scaa quityi nu ngua'an nchgaa la ña'an yu nu mxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Xa mdiyaa yu tu'hua quichen se'en ntsu'hui cha' quinu yu, m'ni ñi cha' si'yana tijyo' la tsaa ñi. ");
INSERT INTO cya_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Una mxicu'ni yu 'in ñi si'yana quinu ñi lo'o yu, lo' juin yu: ¿Ñi cha' ta a quinu um lo'o hua, si'yana cua' msiin lo' cua' qui'ya tla? Xacan' yten ñi ña'an se'en ntsu'hui cha' quinu ñi lo'o yu. ");
INSERT INTO cya_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yato'o lja nducua ñi tu'hua msa can' lo'o yu, msñi ñi sca jaslya, mdyaa ñi xu'hue 'in Ndiose, msu'hue ñi 'in na lo' mdaa ñi 'in na 'in yu. ");
INSERT INTO cya_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","La xacan' nguila cha' tiyaa 'in yu, lo' yu'hui lyoo yu 'in ñi, una a ncua chcan' 'a ñi. ");
INSERT INTO cya_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mdyisnan ycui' yu: Cha' ñi tsaña'an nu ngüi ti' cusya 'in na lja ndaa ñi cha' tucueen ljyaan na, xa ngulyo scua la ñi cha' nu nducua loo quityi 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ticui' xaa can' mxitucui yu nde quichen Jerusalén, nguija lyoo yu 'in cha tixca yu ta'a mda'an ñi nguio' ti'in yu lo'o nchgaa la ña'an jun, ");
INSERT INTO cya_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","lo' ndeña'an ndi'in ycui' jun xa mdiyaa yu: Nu cha' ñi ca si'yana cua' mdyiqui'o Ñi X'nan na, cua' ngulo'o tloo ñi 'in yu Simón re. ");
INSERT INTO cya_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Xacan' mdyisnan mdaa chcuaa yu can' suun tsaña'an cha' nu yato'o 'in yu tucueen nguiaa yu, lo' ña'an yu'hui lyoo yu 'in ñi xa msu'hue ñi jaslya can'. ");
INSERT INTO cya_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lja nchcui' yu cha' can', tsati ntyin ngulo'o tloo Jesús tlu'hue la se'en nguio' ti'in jun, lo' juin ñi 'in jun: Tsu'hue ti tyi'in um scasca um. ");
INSERT INTO cya_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nchgaa jun ytsen jun, lo' a jlyo 'a ti' jun ña'an ti' quiñan ti' jun, msque' ti' jun si'yana sca cui'in ti na'an jun. ");
INSERT INTO cya_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Xacan' juin ñi: ¿Ñi cha' ta nguitsen um, lo' ngui'ni tucua ti' um? ");
INSERT INTO cya_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cu'ni quii um yaan' lo'o quiyan' lo' ca cuiya' ti' um si'yana nan' lcan. Cula' um 'ñan lo' ca jlyo ti' um, si'yana sca cui'in a ntsu'hui tijyan na lo' ñi a ntsu'hui cunan' na tsaña'an nu na'an um 'ñan cua' ñii. ");
INSERT INTO cya_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Xa ycui' ñi cha' can', ngulo'o ñi yaa' ñi lo'o quiya' ñi. ");
INSERT INTO cya_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ndyijyin ya' tsu'hue ntsu'hui tiquee jun siya' ti' ngui'ni tucua ti' jun, a cunta nduhue ti' jun, can' cha' juin ñi 'in jun: ¿Ta a sca na ndi'in 'in um cu na? ");
INSERT INTO cya_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Xacan' mdaa jun tsa yu'hue cula nu cua' mque' 'in ñi, lo'o scua' cuton nu ntsu'hui cuiñan'. ");
INSERT INTO cya_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Msñi ñi 'in na lo' ycu ñi 'in na tloo na'an jun. ");
INSERT INTO cya_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Xacan' juin ñi 'in jun: Nde cha' ycuin' xa mda'an na lo'o um, si'yana 'ni cha' tsato'o nchgaa se'en nchcui' quityi 'in Ndiose cha' 'ñan, quityi nu ngua'an scua Moisé lo'o nchgaa la ña'an yu nu mxiycui' Ndiose 'in, lo'o quityi salmo. ");
INSERT INTO cya_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Xacan' msla ñi cha' tiyaa 'in jun si'yana qui'ya jun cunta ña'an nchcui' quityi 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","lo' juin ñi 'in jun: Nde cha' nu nguinu scua, Ñi nu lca Cristo ntsu'hui cha' tyijyin ñi nu ti'i tsaya' caja ñi, una tyiqui'o ñi nu cua' ca snan tsaan, ");
INSERT INTO cya_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","a cunta caja nu tyi'an ycui' cha' re lo'o cha' cuiya' 'in ñi sca chcui chendyu, si'yana xilo'o chon' ne' qui'ya 'in ne' lo' cu'ni Ndiose cha' tlyu ti' 'in ne', lo' tyisnan chcui' ne' cha' re se'en lca Jerusalén. ");
INSERT INTO cya_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Un lca um nu na'an tloo cha' re. ");
INSERT INTO cya_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cunen lo'o um sca cha', nan' ca'an tñan cha' nu cua' mdi'in tyaa Ndiose lo'o um, una quita um quichen Jerusalén re tsaya' chcuan um cha' cuiya' nu tyi'o la ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Xacan' mdiya lo'o ñi 'in jun nde tu'hua quichen Betania, lo' mscuen ñi yaa' ñi lo' ncuan ñi 'in jun. ");
INSERT INTO cya_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yato'o lja ncuan ñi 'in jun mdyisnan ycuen ñi nde ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Xa cua' m'ni tnu jun 'in ñi, mxitucui jun nde quichen Jerusalén, ndyijyin ya' tsu'hue ntsu'hui tiquee jun. ");
INSERT INTO cya_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nchgaa xaa nguilyu jun ni' lyaa, ngui'ni tnu jun 'in Ndiose lo' ndyaa jun xu'hue 'in ñi. Amen.");
INSERT INTO cya_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Xa ti' lyijyi tsaa' chendyu cua' ndi'in Cha' 'in Ndiose, tsatlyu ndi'in Ndiose lo'o Cha' can', lo' Ndiose lca Cha' can'. ");
INSERT INTO cya_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cua' ndi'in Cha' can' lo'o Ndiose xa ti' lyijyi tsaa' chendyu. ");
INSERT INTO cya_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cui' ñi mtñan ñi nchgaa loo na, ñi sca na lo' a nguiaa', cha' si'i si'ya ñi. ");
INSERT INTO cya_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cui' ñi nda'an lo'o ñi chendyu 'in nten, lo' chendyu can' lca na xaa 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nxtyi xaa can' se'en tla yta, una tla yta can', a nchca 'in na chcui ndijin na loo xaa can'. ");
INSERT INTO cya_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yato'o ngulo ton Ndiose 'in sca yu ncua naan Xuhua. ");
INSERT INTO cya_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nde nu yan ytsa' 'in nten, mdaa yu suun ña'an ndi'in cha' 'in xaa can', si'yana tsa qui'an ti' nchgaa nten si'ya cha' nu chcui' yu. ");
INSERT INTO cya_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Una si'i yu lca yu xaa can', cui' ca nu yaan yu si'yana taa yu suun ña'an ndi'in cha' 'in xaa can'. ");
INSERT INTO cya_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Xaa can' lca na cha' nu ñi nu ndaa chendyu 'in nchgaa nten, lo' mdiyaan xaa can' loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mdi'in ñi loo chendyu re, cui' ñi mtñan ñi 'in na, una nten chendyu a yu'hui lyoo ne' tucui lca ñi. ");
INSERT INTO cya_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yaan ñi se'en nu mtñan ñi, una a ncuan xu'hue ta nten 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Una tsalca nu ncuan xu'hue 'in ñi, nu ndiya qui'an ti' 'in ñi, mdaa ñi cha' cuiya' si'yana ca can' sñe' Ndiose, ");
INSERT INTO cya_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","una a ncua cune' can' lo'o juesa 'in nten chendyu, ta si'ya cha' cuiya' 'in ne', cui' ca nu ncua cune' can' si'ya cha' cuiya' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lo' ñi nu lca Cha' can' ncua ñi sca nten, tsatlyu mdi'in ñi lo'o hua, (na'an hua cha' cuiya' 'in ñi, cha' cuiya' nu nda'an lo'o scati Sñe' Ndiose), lo' mtsa'an yu'hui cha' tsu'hue 'in ñi lo' ycui' ñi cha' nu ñi. ");
INSERT INTO cya_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yu Xuhua can' mdaa yu suun cha' 'in ñi, lo' nchcui' yu: Cui' cha' 'in ñi re lca nu ycuin' lo'o um si'yana cua' ljyaan sca nu ndon loo lati que 'ñan, si'yana cua' s'ni la ndi'in can'. ");
INSERT INTO cya_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Loo nu mtsa'an yu'hui cha' tsu'hue 'in ñi, ngui'ni ca'an scasca cha' tsu'hue 'in na nchgaa na. ");
INSERT INTO cya_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ndiose mdaa ñi lee 'in na si'ya Moisé, una cha' tsu'hue lo'o cha' nu ñi yaan na si'ya Jesucristo. ");
INSERT INTO cya_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","A tucui nu cua' na'an tloo 'in Ndiose, scati Sñe' ñi nu sca cha' ti 'in ñi lo'o, can' nu ngulyo scua la cha' 'in Ndiose lo'o na. ");
INSERT INTO cya_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yato'o ngua'an tñan ne' judio tucua snan yu levita, lo'o yu nu ntsu'hui cunta 'in laa quichen Jerusalén, si'yana cuñicha' ne' 'in yu Xuhua cha' tucui ca lca yu, lo' nde suun nu mdaa yu, ");
INSERT INTO cya_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ycui' la yu, lo' juin yu: Nan' a lcan ñi nu lca Cristo. ");
INSERT INTO cya_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","¿Tucui ta lca xacan'? ¿Ta cui' lca Elía? Mxcuen yu 'in ne': Si'in. ¿Uta na lca ycui' ca nu nxiycui' Ndiose 'in? Mxcuen yu 'in ne': Si'i can' nu lcan. ");
INSERT INTO cya_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Xacan' juin ne' 'in yu: ¿Tucui ta lca cha' na can', si'yana tca tyaa hua cunta 'in yu nu ngua'an tñan 'in hua? ¿Ñi suun ndaa cha' nu 'in? ");
INSERT INTO cya_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mxcuen yu 'in ne': Nan' lcan yu nu cua' nguinu cha' —tyi'an se'en ngutyi lo' chcui' cueen: Cu'ni ñi um tucueen se'en caan Ñi X'nan na—, tsaña'an cha' nu mxiycui' Ndiose 'in yu Isaía cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Cui' ta 'in ne' fariseo lca nu mdiyaa can', ");
INSERT INTO cya_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","lo' ti' mñicha' ne' 'in yu: ¿Ñi cha' ta nducua tya 'in nten, cha' na si'i Cristo lca, ñi a lca Elía, ñi a lca nu nxiycui' Ndiose 'in? ");
INSERT INTO cya_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mxcuen yu Xuhua can': Nan' nducua tyan 'in nten lo'o tyi'a, una cui' lja um re tyi'o sca nu a nchca chu'hui lyoo um 'in. ");
INSERT INTO cya_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Can' nu cua' ljyaan, lo' ndon loo lati que 'ñan nan', lo' tsu'hue ntsu'hui tiqueen cha' cua na taa ñi cha' cuiya' xtin' tsa tisnan ti ñi. ");
INSERT INTO cya_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nchgaa cha' re yato'o na se'en lca Betábara, xca tso' chco tlyu Jordan se'en nu mducua tya yu Xuhua 'in nten. Ñi nu lca Slya' 'in Ndiose ");
INSERT INTO cya_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Xca tsaan can' na'an yu Xuhua ljyaan Jesús se'en ndon yu, lo' juin yu 'in nten: Nde ñi nu lca Slya' 'in Ndiose nu nxicuten qui'ya 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Cui' cha' 'in ñi re lca nu ycuin' lo'o um si'yana cua' ljyaan ñi nu ndon loo lati que 'ñan nan', si'yana cua' s'ni la ndi'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nan' a ndyu'hui lyoon 'in ñi, una nde cha' nducua tyan 'in ne', si'yana chu'hui lyoo ne' Israel 'in ñi, ");
INSERT INTO cya_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ndeña'an juin yu Xuhua can': Nan' na'an xa mdo'o Espíritu 'in Ndiose la ni' cuaan, ngu'ya tucua que ñi tsaña'an nchca ti' ndyi'ya tucua sca scun' jo'o. ");
INSERT INTO cya_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nan' a ndyu'hui lyoon 'in ñi, una ñi nu ngua'an tñan 'ñan si'yana tucua tyan 'in nten lo'o tyi'a, juin ñi 'ñan: Ñi nu ña'an qui'ya tucua Espíritu nu Luhui 'in Ndiose que, can' nu cu'ni cha' tucua tya 'in nten, una lo'o Espíritu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nan' na'an tloon can 'in ñi, can' cha' ndaan suun si'yana cui' ñi lca ñi Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Xca tsaan can' nguilyu yu Xuhua ticui' se'en can' lo'o tucua yu ta'a nda'an yu. ");
INSERT INTO cya_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na'an yu Xuhua se'en nguilyu Jesús lo' juin yu: Ña'an jan ñi, cua ndon ñi nu lca Slya' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Xa ngune 'in chcuaa yu can' cha' nu ycui' yu, cui' xaa mducui ncha'an yu 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Xa na'an Jesús si'yana ljyan ncha'an yu 'in ñi, juin ñi 'in yu: ¿Tucui ca 'in nda'an nan um? Mxcuen yu 'in ñi: Rabí, (cha' re nchca ti' chcui', 'Un ñi nu lca Bstro), ¿la ta ndi'in um? ");
INSERT INTO cya_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Lo' juin ñi 'in yu: Tsaa na lo' ca jlyo ti' um. Xacan' yaa yu lo' mdiyaa yu se'en ndi'in ñi. Can' nguinu yu si'yana cua' ntsu'hui braa cua' jacua siin xa mdiyaa yu. ");
INSERT INTO cya_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chcuaa yu nu ngune 'in ycui' yu Xuhua can' mducui ncha'an 'in Jesús, sca can' naan Ndre, ta'a ngula yu Simón nu nchcui' ne' lo'o lca Tyo. ");
INSERT INTO cya_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Cui' xaa nguia nan yu 'in Simón ta'a ngula yu, lo' juin yu 'in: Cua' nguija lyoo hua 'in ñi nu lca Mesía (cha' re nchca ti' chcui', Cristo, ñi nu ngua'an tñan Ndiose 'in). ");
INSERT INTO cya_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ya lo'o yu 'in tloo Jesús, lo' xa na'an ñi 'in yu juin ñi: Nu'huin lca Simón, sñe' Jonás, una cua' ñii ca naan Cefas, (cha' re nchca ti' chcui' Tyo). ");
INSERT INTO cya_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Xca tsaan can' mdo'o tiquee Jesús tsaa ñi se'en lyi'ya loo Galilea, can' mchcua ta'a ñi lo'o yu Lpe, lo' juin ñi 'in yu: Chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Quichen Betsaida mdo'o yu Lpe can', cui' quichen tyi yu Ndre lo'o yu Tyo. ");
INSERT INTO cya_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Yu Lpe ya nan 'in yu Natanael, lo' juin yu 'in: Cua' nguija lyoo hua 'in ñi nu ntsu'hui cha' caan, ñi nu cua' ngua'an scua Moisé cha' 'in, cui' cha' nu ngua'an scua yu nu mxiycui' Ndiose 'in cua' s'ni, lo' lca ñi Jesús, sñe' See, nu mdo'o quichen Nazaret. ");
INSERT INTO cya_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Lo' juin yu Natanael: ¿Ta xtyi ti' Nazaret tyi'o sca nu cu'ni tñan tsu'hue? Xacan' juin yu Lpe: Tsaa na lo' ca cuiya' ti'. ");
INSERT INTO cya_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Xa na'an Jesús ljyaan yu Natanael, juin ñi: Nde ljyaan sca yu Israel nu cua' tyi ca, nu ñi sca cha' cuiñi lo' a ntsu'hui 'in. ");
INSERT INTO cya_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yu Natanael can' juin yu 'in ñi: ¿La ta yu'hui lyoo um 'ñan? Mxcuen Jesús 'in yu: Cua' na'an 'in xa nducua suun yca higo can', xa ti' lyijyi tsa te'en yu Lpe 'in. ");
INSERT INTO cya_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Xacan' mxcuen yu Natanael 'in ñi: Rabí, 'un lca um ycui' ca Sñe' Ndiose, 'un lca um Ree 'in ne' Israel. ");
INSERT INTO cya_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Lo' juin Jesús 'in yu: ¿Ta ya qui'an ti' 'ñan si'yana nen na'an nducua suun yca higo can'? Una ntsu'hui cha' ña'an cha' nu tnu lati que ña'an cha' nu na'an cua' ñii. ");
INSERT INTO cya_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lo' ti' juin la ñi 'in yu: Nu cha' ñi s'ni cunen lo'o, chcui nu nguiaa nde loo re ña'an quila tucua ni' cuaan, lo' can' ña'an —scuen lo' qui'ya angujle 'in Ndiose— se'en ndon Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nu cua' nchca snan tsaan can' nchca sca ta'a se'en ndyijyi cuilyi'o ne' quichen Caná se'en lyi'ya loo Galilea. Lo'o jyi'an Jesús nguilyu can'. ");
INSERT INTO cya_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","A cunta lo'o Jesús lo'o ta'a nda'an ñi jui nu nguni 'in jun tsaa jun se'en nchca ta'a can'. ");
INSERT INTO cya_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Xa yatii vino 'in ne' juin jyi'an Jesús 'in ñi: Cua' mdyi vino re. ");
INSERT INTO cya_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Xacan' mxcuen Jesús: ¿Ñi cha' lyee 'a ntsu'hui yuhue ti' um cha' re? Ti' lyijyi tiyaa braa nu cu'nin sca cha'. ");
INSERT INTO cya_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Xacan' juin jyi'an ñi lo'o yu nu nsu'hua vino can': Tucua um tñan nchgaa cha' nu chcui' ñi. ");
INSERT INTO cya_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Can' ndon tsa scua quiton' tnu, nu nguiaa' lo'o quee lo' najo'o na 'in ne' judio xa nsuhui ne' cha' 'in ne'. Cunda scaa quiton' can' ndyu'hui tucua uta snan te'en tyi'a 'in na. ");
INSERT INTO cya_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Lo' juin Jesús 'in ne': Cu'ni cha'an um quiton' cua lo'o tyi'a. Cui' xaa m'ni cha'an ne' 'in na hasta la tu'hua na. ");
INSERT INTO cya_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Xacan' juin ñi 'in ne': Su'hua um tsachin' na, lo' tsa lo'o um 'in na 'in yu nu ntsu'hui cunta 'in ta'a re. Lo' cuaña'an m'ni ne'. ");
INSERT INTO cya_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yu nu ntsu'hui cunta 'in ta'a can' a ngujlyo ti' yu la mdo'o na, una nu ya lo'o 'in na jlyo ti' la mdo'o na. Xa yi'o yu tyi'a nu mchca vino can', cui' xaa msi'ya yu 'in yu nu ndyijyi cuilyi'o can', ");
INSERT INTO cya_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lo' juin yu 'in: Nchgaa nten nsu'hua ne' culo nducua la vino nu tsu'hue, lo' xa cua' tlya na yi'o ne', xacan' nsu'hua ne' vino nu cuxi ti, una 'un la cua' ñii msu'hua um vino nu tsu'hue la. ");
INSERT INTO cya_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nde culoo cha' nu tnu m'ni Jesús quichen Caná se'en lyi'ya loo Galilea, xa ncua chcan' loo cha' cuiya' nda'an lo'o ñi, lo' yu ta'a nda'an ñi ya qui'an ti' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chon' nde'en can' mdo'o Jesús nguiaa ñi nde quichen Capernaum tsatlyu lo'o jyi'an ñi lo'o ta'a ngula ñi, lo'o yu ta'a nda'an ñi. Can' nguinu jun tucua snan tsaan. ");
INSERT INTO cya_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Cua' nchcui cuii' cha' ca ta'a pascua 'in ne' judio, lo' Jesús yaa ñi quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Xa mdiyaa ñi se'en nducua laa can', na'an ñi 'in nten nu ndyijui' bta lo'o slya' lo'o scun' jo'o, a cunta lo'o yu nu nxitsa'an tñi nducua yu can'. ");
INSERT INTO cya_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Xacan' mxijnan ñi sca tiso nducua yaa' ñi, lo' ngulo ñi 'in nchgaa nu ndi'in can' nde lyiya', lo'o slya' lo'o bta 'in ne', mslo tu'hui ñi tñi 'in ne' nu nxitsa'an tñi can', lo' mxiquilyu ñi msa, ");
INSERT INTO cya_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","lo' juin ñi 'in ne' nu ndyijui' scun' jo'o can': Lyoo um nchgaa na re nde lyiya', lo' a cu'ni um na'an 'in Stin ca na na'an loquiya'. ");
INSERT INTO cya_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Xacan' nguia yu'hui ti' yu ta'a nda'an ñi ña'an nchcui' quityi 'in Ndiose: Cua' lca na a ta loon 'an si'yana lyee nsu'huan cha' tiqueen si'ya cha' 'in laa 'in um. ");
INSERT INTO cya_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mñicha' ne' judio 'in ñi: ¿La jui cha' cuiya' 'in lo'o cha' nu ngui'ni re? ");
INSERT INTO cya_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mxcuen Jesús 'in ne': Xicuten um laa re, lo' ni' snan ti tsaan xiton 'in na xiya'. ");
INSERT INTO cya_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Cui' xaa juin ne' judio can': Tsani' tucua yla ntsu'hui scua yjan nguiaa' laa re, ¿lo' nu'huin lo'o snan ti tsaan xiton 'in na xiya'? ");
INSERT INTO cya_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Una laa nu nchcui' ñi cha' 'in can' lca na ticuii' ñi. ");
INSERT INTO cya_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Xa nu cua' mdyiqui'o ñi, xacan' nguia yu'hui ti' yu ta'a mda'an ñi si'ya cha' nu ycui' ñi re, lo' ya qui'an ti' yu cha' nu nguinu scua loo quityi 'in Ndiose lo'o cha' nu ycui' Jesús. ");
INSERT INTO cya_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lja nu ti' ndi'in ñi quichen Jerusalén se'en nchca ta'a pascua can', qui'an 'a nten ya qui'an ti' 'in ñi si'ya scasca cha' nu tnu ngui'ni ñi. ");
INSERT INTO cya_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Una Jesús ncua cuiya' ti' ñi si'yana a ñi ndi'in cha' 'in ne', si'yana ndyu'hui lyoo tsu'hue ñi 'in nchgaa nten, ");
INSERT INTO cya_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ñi a 'ni cha' caja nu quitsa' 'in ñi ña'an ndi'in cha' 'in nten, si'yana jlyo ti' ñi ña'an lca cusya 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Cui' ta 'in ne' fariseo ndi'in sca yu naan Nicodemo, lca yu sca nu ndon loo 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yato'o sca tla yaa yu se'en ndi'in Jesús, lo' juin yu 'in ñi: Rabí, cua' jlyo ti' hua si'yana lo'o cunta 'in Ndiose ndlo'o um, si'yana a tucui nu tca cu'ni scasca cha' nu tnu ña'an nu 'un ngui'ni um, cha' si'i lo'o cha' cuiya' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mxcuen Jesús 'in yu: Nu cha' ñi s'ni cunen lo'o, a tucui nu tca sten se'en ndlo Ndiose tñan cha' na a chca cune' xiya'. ");
INSERT INTO cya_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Lo' juin yu Nicodemo: ¿Ña'an tca ca cune' sca nten cha' cua' cula ne'? ¿Ta ti' tca ca cune' ne' 'in jyi'an ne' xiya'? ");
INSERT INTO cya_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Xacan' mxcuen Jesús 'in yu: Nu cha' ñi s'ni cunen lo'o, sca nten nu a ca cune' lo'o tyi'a, lo'o Espíritu, a tca sten can' se'en ndlo Ndiose tñan. ");
INSERT INTO cya_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Si'yana nu nchca cune' lo'o juesa 'in nten chendyu, ticui' nten chendyu lca can', una nu nchca cune' lo'o cha' cuiya' 'in Espíritu, cua' mchca cune' cusya 'in can'. ");
INSERT INTO cya_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","A cuhue ti' lyee la cha' nu ycuin' lo'o si'yana 'ni cha' ca cune' xiya'. ");
INSERT INTO cya_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Cui'in nchca na la ña'an ti, lo' ne nguiaa na, una a tucui jlyo ti' la mdo'o na uta la nguiaa na, cui' cuaña'an ndi'in cha' 'in nu nchca cune' lo'o Espíritu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mxcuen Nicodemo 'in Jesús: ¿Ña'an tca ca cuiya' ti' na cha' re? ");
INSERT INTO cya_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mxcuen Jesús 'in yu: ¿Ta si'i nu'huin lca nu ndlo'o 'in ne' Israel, lo' a ndyi'ya cunta cha' re? ");
INSERT INTO cya_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nu cha' ñi s'ni cunen lo'o, nchcui' hua cha' nu jlyo ti' hua lo' ndaa hua suun cha' nu cua' na'an hua, una a ndiya qui'an ti' um cha' nu nchcui' hua. ");
INSERT INTO cya_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cha' nu nchca loo chendyu re cua' ycuin' lo'o um una a ndiya qui'an ti' um, ¿ña'an la ca cha' nu nchca la ni' cuaan na tca tsa qui'an ti' um? ");
INSERT INTO cya_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A tucui nu cua' ycuen la ni' cuaan, cui' ca nu scati Yu Qui'yu nu Mdo'o nde ni' Cuaan, ñi nu ndi'in ca la ni' cuaan mdiyaan loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tsaña'an m'ni Moisé xa mda'an yu se'en ngutyi, mxiton yu sca yca se'en mjyi'in ca'an yu cunaan, lo' cuaña'an 'ni cha' jyi'in ca'an ne' 'ñan sii' yca, Nan' Yu Qui'yu nu Mdo'o nde ni' Cuaan, ");
INSERT INTO cya_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ña'an ca si'yana nchgaa nu tsa qui'an ti' 'in ñi a quinan' cusya 'in, cui' ca nu caja chendyu nu a tsatii 'a 'in. ");
INSERT INTO cya_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tsala ña'an tlyu cha' tsu'hue 'in Ndiose, nu hasta mdaa ñi scati Sñe' ñi 'in nten chendyu, si'yana nchgaa nu tsa qui'an ti' 'in ñi a quinan' cusya 'in, cui' ca nu caja chendyu nu a tsatii 'a 'in. ");
INSERT INTO cya_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Si'yana a ngua'an tñan Ndiose 'in Sñe' ñi loo chendyu re, ta si'yana so' tucua ñi qui'ya chon' nten, cui' ca nu yaan ñi si'yana culo laa ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nu ndiya qui'an ti' 'in ñi, a nducua 'a qui'ya chon', una nu a ndiya qui'an ti' 'in ñi ti' nducua qui'ya chon', cui' si'yana a nchca tsa qui'an ti' 'in scati Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nde cha' nducua qui'ya chon' ne': Si'yana ñi nu lca xaa cua' yaan loo chendyu re, una nten chendyu lyee la lca tiquee ne' lo'o cha' tla yta, si'yana chacui' cha' ngunan' ntsu'hui tiquee ne'. ");
INSERT INTO cya_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Si'yana tsalca nu ngui'ni cha' ngunan' a ndyi'an ne' loo xaa 'in ñi, ñi a ndaa can' ya' qui'ni xaa 'in, se'en nu a ca chcan' loo tñan ngunan' nu ngui'ni. ");
INSERT INTO cya_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Una nu nguia ncha'an cha' nu ñi, can' nu ndyi'an loo xaa 'in Ndiose, se'en nu ca chcan' loo tñan tsu'hue nu ngui'ni can' si'ya cha' cuiya' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chon' nde'en can' yaa Jesús lo'o yu ta'a nda'an ñi se'en lyi'ya loo Judea, can' mdi'in ñi lo'o yu sca co' xaa, mducua tya ñi 'in nten. ");
INSERT INTO cya_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lo'o yu Xuhua mducua tya yu 'in nten sca se'en naan Enón, cui' ti se'en lca Salim, si'yana can' tlya tyi'a ntsu'hui, lo' mducua tya yu 'in nten nu mdiyaa can'. ");
INSERT INTO cya_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ti' lyijyi su'hua ne' 'in yu Xuhua na'an chcuan xa m'ni yu cha' re. ");
INSERT INTO cya_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Xacan' mdyisnan ycui' tyijyin ne' judio lo'o ta'a nda'an yu Xuhua, lo' a ncua ca sca cha' ti 'in yu lo'o ne' ña'an ntsu'hui cha' quinu luhui nten tloo Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ya ytsa' ne' 'in yu Xuhua lo' juin ne': Rabí, ña'an um jan ñi, yu nu ta'a nguilyu um xca tso' chco tlyu Jordan, yu nu mdaa um suun ña'an ndi'in cha' 'in, lo'o yu cua' nducua tya yu 'in nten, lo' qui'an 'a nten cua' nducui ncha'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mxcuen yu Xuhua: A tucui nu tca cuan xu'hue sca cha', cha' si'i Ndiose taa ñi cha' cuiya'. ");
INSERT INTO cya_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Cui' um ngune 'in um cha' nu ycuin' si'yana si'i Cristo lcan, una mducua loon si'yana taan suun ña'an ndi'in cha' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Sca yu nu ndyijyi cuilyi'o ntsu'hui cha' chcuan yu cunta 'in cuilyi'o yu. Lo' nu lca ta'a tsu'hue yu ndon cui' ti sii' yu, tsu'hue ntsu'hui tiquee yu xa ne 'in yu cha' nu nchcui' yu nu ndyijyi cuilyi'o can'. Cui' cuaña'an ndi'in cha' 'ñan cua' ñii, cua' ya tucua xaa nu ca tsu'hue chu'hui tiqueen. ");
INSERT INTO cya_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cui' ñi ntsu'hui cha' scuen cuaan ñi, lo' nan' nde qui'ya te'en cha' 'ñan. Ñi nu mdo'o nde ni' cuaan ");
INSERT INTO cya_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ñi nu mdo'o nde ni' cuaan scati ñi lca ñi nu ndon loo la, una nten chendyu, ticui' loo chendyu re ngula ne' lo' nchcui' ne' cha' nu nchca loo chendyu re. Una ñi nu mdo'o nde ni' cuaan scati ñi lca ñi nu ndon loo lati. ");
INSERT INTO cya_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ndaa ñi suun cha' nu na'an ñi lo'o cha' nu cua' ngune 'in ñi, una a tucui nu nducuan xu'hue cha' nu nchcui' ñi. ");
INSERT INTO cya_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nu n'ni cunta cha' nu nchcui' ñi, can' nu ndaa suun si'yana Ndiose ñi ndi'in cha' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Si'yana ñi nu ngua'an tñan Ndiose 'in, cui' cha' 'in Ndiose nchcui' can', si'yana si'i na ndyu'hui cuiya' ti Espíritu nu ndaa Ndiose 'in can'. ");
INSERT INTO cya_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Stina Ndiose lyee ndyu'hui cuiya' ti' ñi 'in Sñe' ñi, lo' yaa' can' mxnu ñi cunta nchgaa loo cha'. ");
INSERT INTO cya_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nu ndiya qui'an ti' 'in Sñe' Ndiose, cua' jui chendyu nu a tsatii 'a 'in, una nu xcuan tloo 'in Sñe' ñi, a qui'ni ca'an 'in can' chendyu nu a tsatii 'a, cui' ca nu nde xitijin Ndiose 'in can' nu ti'i. ");
INSERT INTO cya_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yato'o ne' fariseo ngune 'in ne' si'yana qui'an la nten nducui ncha'an 'in Jesús, lo' lyee la nducua tya ñi 'in nten que 'in yu Xuhua, ");
INSERT INTO cya_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(siya' si'i Jesús nducua tya ñi 'in nten, cui' ca nu yu ta'a nda'an ñi). ");
INSERT INTO cya_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Can' cha' mdo'o ñi se'en lyi'ya loo Judea, mxitucui ñi nde se'en lyi'ya loo Galilea, ");
INSERT INTO cya_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","una 'ni cha' tyijyin ñi se'en lyi'ya loo Samaria. ");
INSERT INTO cya_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mdiyaa ñi sca quichen naan Sicar se'en lyi'ya loo Samaria, se'en su sca yuu nu mdaa Jacob 'in yu See nu ncua sñe' yu. ");
INSERT INTO cya_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Can' nducua sca chco mtñan Jacob, tu'hua chco can' yten tucua Jesús si'yana ncua tñan' ñi tucueen yaan ñi, lo' tsa ntsu'hui ndyi'ya cuaan ti lca na. ");
INSERT INTO cya_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Xacan' mdiyaa sca ne' cuna'an Samaria nu nguia 'ya tyi'a, lo' juin Jesús 'in ne': Taa tsachin' tyi'a co'on. ");
INSERT INTO cya_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yu ta'a nda'an ñi ti' ntsu'hui lyijyi yu nde loo quichen, nguia si'i yu na nu cunajo'o 'in jun. ");
INSERT INTO cya_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ne' cuna'an Samaria juin ne' 'in ñi: 'Un lca um ne' judio lo' nan' lcan ne' Samaria, ¿ñi cha' njñan um tyi'a co'o um 'ñan? Juin ne' cuaña'an si'yana ne' judio a tsu'hue ndi'in ne' lo'o ne' Samaria. ");
INSERT INTO cya_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mxcuen Jesús 'in ne': Cha' cua na nu'huin su'hua loo cha' tsu'hue nu ndaa Ndiose, lo' qui'ya cunta tucui ca nu njñan tyi'a 'in, cui' xaa jñan cha' tsu'hue 'ñan, lo' taan tyi'a nu taa chendyu 'in. ");
INSERT INTO cya_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Xacan' juin ne' 'in ñi: Una 'un, a lo'o na nu culo um tyi'a re lo' chco re qui'ñi na. ¿La ta culo um tyi'a nu taa chendyu 'ñan? ");
INSERT INTO cya_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ta lyee la ndon loo um que 'in Jacob nu ncua nten cula 'in hua? Can' nu mdaa chco re 'in hua, cui' re yi'o can' tyi'a lo'o sñe' lo'o scun'. ");
INSERT INTO cya_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mxcuen Jesús 'in ne': Ña'an nu ti nu co'o tyi'a re, a s'ni ti' quityi ti' can' xiya'. ");
INSERT INTO cya_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Una nu co'o tyi'a nu nan' taan, a ntsu'hui 'a cha' ti' quityi ti' can', si'yana tyi'a nu taan chcua na ni' cusya 'in tsaña'an nducua tyi'a tlya, lo' taa na chendyu nu a tsatii 'a 'in. ");
INSERT INTO cya_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mxcuen ne' cuna'an can': Ñi x'nan hua, tyaa um tyi'a can' co'o hua, lo' a quityi 'a ti' hua, ñi a can 'ya 'a hua tyi'a chco re. ");
INSERT INTO cya_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Lo' juin Jesús 'in ne': Quia te'en 'in cuilyi'o lo' can lo'o 'in. ");
INSERT INTO cya_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mxcuen ne' cuna'an can': A ndi'in cuilyi'o hua. Lo' juin Jesús: Cui' ña'an nu juin si'yana a ndi'in cuilyi'o, ");
INSERT INTO cya_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","si'yana cua' nchca ca'yu cuilyi'o, lo' nu ndi'in lo'o cua' ñii si'i cuilyi'o ca lca can', cha' ñi ña'an juin lo'on. ");
INSERT INTO cya_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Xacan' juin ne' 'in ñi: Cua' lca na 'un lca um nu nxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ne' nu ncua nten cula 'in hua m'ni tnu ne' 'in Ndiose loo qui'ya re, una tsalca 'un ne' judio nchcui' um si'yana quichen Jerusalén ntsu'hui cha' cu'ni tnu ne' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Lo' juin Jesús 'in ne': Tsa qui'an ti' cha' nu chcuin' lo'o, si'yana tiyaa xaa, ñi si'i loo qui'ya cua lo' ñi si'i quichen Jerusalén ntsu'hui cha' tsa y'ni tnu um 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'Un ne' Samaria, ngui'ni tnu um cha' nu a ndyi'ya um cunta, una huare' ngui'ni tnu hua cha' nu cua' jlyo ti' hua, lo' si'ya ne' judio caja ña'an tyi'o laa nten. ");
INSERT INTO cya_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Cua' ñii cua' mdyisnan cha' re, lo' tsalca nu cha' ñi ca cu'ni tnu 'in Ndiose, lo'o sca cusya nu ñi cu'ni tnu can' 'in ñi, si'yana cuaña'an nchca ti' Stina Ndiose caja nu cu'ni tnu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ndiose lca ñi Espíritu, lo' nu cu'ni tnu 'in ñi, 'ni cha' cu'ni tnu 'in ñi lo'o sca cusya nu ñi. ");
INSERT INTO cya_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Xacan' juin ne' cuna'an can' 'in ñi: Huare' jlyo ti' hua si'yana ntsu'hui cha' caan nu lca Mesía, ñi nu ca naan Cristo, lo' xa caan ñi culyo scua la ñi cha' re lo'o na. ");
INSERT INTO cya_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Juin Jesús 'in ne': Cui' can' lca nu nchcui' lo'o cua' ñii. ");
INSERT INTO cya_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lja xacan' nguila yu ta'a nda'an ñi, lo' nduhue ti' yu si'yana lo'o sca ne' cuna'an ta'a nchcui' ñi, una a sca yu msti ti' yu cuñicha' yu 'in ñi cha' ñi cha' ca nchca ti' ñi uta ñi cha' nchcui' ñi lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Xacan' ngula' ton ne' te'en 'in ne', lo' mdo'o ne' nguiaa ne' nde loo quichen, lo' juin ne' lo'o nten can': ");
INSERT INTO cya_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Cuan lya um lo' chu'hui lyoo um sca yu nu ngu'ya cunta nchgaa ña'an cha' nu cua' m'ni hua. ¿Ta si'i ca cua nu lca Cristo? ");
INSERT INTO cya_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Cui' xaa mdo'o nten can' nguia na'an ne' se'en nducua ñi. ");
INSERT INTO cya_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lja xacan' yu ta'a nda'an ñi juin 'in ñi: Ñi Bstro, ¿ta a ca xu'hue um? ");
INSERT INTO cya_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mxcuen ñi 'in yu: Nan' nda'an lo'on na nu cunajo'o 'ñan, una 'un a jlyo ti' um. ");
INSERT INTO cya_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Xacan' scasca yu mdyisnan nchcui' yu lo'o ta'a yu: ¿Ta xtyi ti' ntsu'hui nu yan lo'o na nu cunajo'o 'in ñi? ");
INSERT INTO cya_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Lo' juin Jesús 'in yu: Cha' nchcu 'ñan ca lca nu tucuan tñan cha' nu nchca ti' ñi nu ngua'an tñan 'ñan, lo' cu'nin tyiin tñan nu mdaa ñi 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Ta si'i ndeña'an nchcui' um sca cha': Ñii cha jacua coo' quio' na nu yta na? Una cunen lo'o um sca cha', xla um quiloo um lo' cu'ni quii um se'en nguita jyaan cua, si'yana cua' ngula na lo' cua' tca quio' na. ");
INSERT INTO cya_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yu nu nxo' 'in na nxñi siya' yu, lo' a tsatii cha' tsu'hue can' 'in yu la ni' cuaan, si'yana tsatlyu tsu'hue chu'hui tiquee yu nu yta 'in na lo'o yu nu nxo' 'in na. ");
INSERT INTO cya_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Cha' ñi ña'an nu nchcui' ne' sca cha': Sca nu ntya lo' xca nu nxo'. ");
INSERT INTO cya_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nan' ngua'an tñan 'in um tsa xo' um na nu a yta um, xca tucui cua' m'ni tñan can' lo' 'un qui'ni ca'an 'in um xo' um 'in na. ");
INSERT INTO cya_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Quichen can' qui'an 'a ne' Samaria ya qui'an ti' 'in ñi, si'ya cha' nu ycui' ne' cuna'an can' xa juin ne': Nchgaa ña'an nu cua' m'ni hua ngu'ya ñi cunta. ");
INSERT INTO cya_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Xacan' ne' Samaria nu mdiyaa can' mjñan cha' tsu'hue 'in ñi si'yana quinu ñi quichen can', lo' can' nguinu ñi tucua tsaan. ");
INSERT INTO cya_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cuaña'an qui'an la nten ya qui'an ti' ne' lo'o cha' nu ycui' ñi, ");
INSERT INTO cya_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","lo' juin ne' 'in ne' cuna'an can': Si'i 'a si'ya cha' nu ycui' ti ya qui'an ti' hua, cui' ca nu si'yana ngune 'in hua ña'an cha' nu ycui' ñi, lo' ncua cuiya' ti' hua si'yana nde ñi nu cha' ñi ca lca Cristo, ñi nu ndlo laa 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Xa mda'a cucha can' mdo'o ñi nguiaa ñi nde se'en lyi'ya loo Galilea. ");
INSERT INTO cya_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ticui' Jesús juin ñi si'yana sca yu nu nxiycui' Ndiose 'in, a nducuan xu'hue ta'a quichen tyi ne' cha' nu nchcui' yu. ");
INSERT INTO cya_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Xa nguila ñi se'en lyi'ya loo Galilea, nchgaa ne' m'ni cunta ne' 'in ñi si'yana cua' na'an ne' cha' nu tnu m'ni ñi se'en yaa ñi ta'a quichen Jerusalén, si'yana lo'o ne' Galilea yaa ne' ta'a can'. ");
INSERT INTO cya_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nguila Jesús xiya' quichen Caná se'en lyi'ya loo Galilea, se'en nu m'ni ñi cha' mchca vino tyi'a can'. Quichen Capernaum ndi'in sca yu lyi'ya tñan 'in ree, lo' ti'i sca sñe' yu. ");
INSERT INTO cya_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Xa ynan yu cha' si'yana Jesús cua' nguila ñi se'en lyi'ya loo Galilea nu yaa ñi Judea, ya jñan yu cha' tsu'hue 'in ñi si'yana tsa y'ni chca ñi 'in sñe' yu si'yana cua' caja ti. ");
INSERT INTO cya_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Xacan' juin Jesús 'in yu: A tsa qui'an ti' um cha' a ña'an um sca cha' nu tnu. ");
INSERT INTO cya_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yu nu lyi'ya tñan can' juin 'in ñi: Ñi X'nan hua, cu'ni um sca cha' tsu'hue tsaa um se'en ndi'in lja nu ti' lyijyi tsatii sñen'. ");
INSERT INTO cya_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Lo' juin Jesús 'in yu: Quia lya um si'yana cua' mchca sñe' um. Ya qui'an ti' yu cha' nu ycui' Jesús, cui' xaa mdo'o yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Xa nu cua' quila ti yu, mdo'o tucua snan nguso nu ya ycua 'in yu, can' nu mtsa' 'in yu si'yana cua' xa' lca 'in sñe' yu. ");
INSERT INTO cya_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Xacan' mñicha' yu 'in nguso can': ¿Ñi braa ta mchca tsu'hue lca 'in yu? Lo' juin yu nguso can': Cui' lca, tsa ntsu'hui braa cua' sca siin xa mdyi'o tique' can' 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Xacan' ngu'ya yu cunta si'yana cui' braa can' ycui' Jesús lo'o yu xa nu juin ñi: Cua' mchca sñe' um. Lo' ya qui'an ti' yu 'in Jesús tsatlyu lo'o nchgaa nu ndi'in na'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nde cha' nu tnu m'ni Jesús nu cua' nchca tucua juesa, xa mdo'o ñi se'en lyi'ya loo Judea lo' nguila ñi se'en lyi'ya loo Galilea. ");
INSERT INTO cya_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chon' nde'en can' yaa Jesús quichen Jerusalén se'en nu nchca ta'a 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Cui' ti tu'hua quichen se'en nguiten ne' Tulo'o Slya' can', nducua sca se'en ndi'in tyi'a tlya, lo' ndlo'o naan ne' 'in na lo'o cha' hebreo, Betesda. Tyi'iin sii' can' nguia' tucui lo' nducua tsa ca'yu tuna'an 'in na. ");
INSERT INTO cya_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Can' ndi'in qui'an nu ti'i lo'o cuati loo quicha, nu cuityin', nu co' quiya' lo'o nu cuxi quiya', nta ne' cha' ñi xaa quiñan ti'in tyi'a can'. ");
INSERT INTO cya_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Si'yana cua' lca ti xaa ndyi'ya sca angujle nu nxiquiñan ti'in tyi'a can', lo' nu sten culo nducua la loo tyi'a can' xa ndyi quiñan ti'in na, can' nu nchca lo'o ña'an quicha ti nu ntsu'hui 'in. ");
INSERT INTO cya_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Can' su sca yu nu cua' ntsu'hui cla tyii ntsu'hui snu' yjan ti'i. ");
INSERT INTO cya_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús na'an ñi su yu, lo' xa ngujlyo ti' ñi si'yana cua' s'ni ti'i yu, juin ñi 'in yu: ¿Ta nchca ti' um chca um? ");
INSERT INTO cya_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mxcuen yu 'in ñi: 'Un jlyo ti' um si'yana a ndyijyi nu su'hua 'ñan loo tyi'a re xa nguiñan ti'in na. Xa nchca tin' sten 'in na xca tucui nu ndla la nguiten que 'ñan nan'. ");
INSERT INTO cya_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Lo' juin Jesús 'in yu: Tyiton um, xñi um jaa' 'in um lo' quiaa um. ");
INSERT INTO cya_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ticui' xaa mchca yu, msñi yu jaa' 'in yu, mdo'o yu nguiaa yu, lo' lca na tsaan nu nxitñan' ne' judio. ");
INSERT INTO cya_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Xacan' juin ne' judio lo'o yu nu mchca can': Tsaan nu nxitñan' na lca na cua' ñii, a ntsu'hui cha' cuiya' 'in cui'ya jaa' 'in. ");
INSERT INTO cya_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mxcuen yu 'in ne': Una nu m'ni chca 'ñan juin lo'on: Xñi um jaa' 'in um lo' quiaa um. ");
INSERT INTO cya_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Xacan' mñicha' ne' 'in yu: ¿Tucui ca nu juin lo'o si'yana xñi jaa' 'in lo' quiaa? ");
INSERT INTO cya_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","A ngujlyo ti' yu ti ca nu m'ni chca 'in yu si'yana Jesús a ncua chcan' 'a ñi lja nten qui'an can'. ");
INSERT INTO cya_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","La cua' msiin la can' nguija lyoo Jesús 'in yu ni' lyaa, lo' juin ñi 'in yu: Cua' mchca um ñii, a cu'ni 'a um qui'ya, ña'an tu' tlyu la cha' nu ña'an um. ");
INSERT INTO cya_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Xacan' mdo'o yu nguiaa yu, lo' mtsa' yu 'in ne' judio si'yana Jesús lca nu m'ni chca 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Cui' si'ya cha' re mdyisnan mna'an ti'i ne' judio 'in Jesús, lo' nan ne' ña'an nu cujui ne' 'in ñi si'yana tsaan nu nxitñan' ne' m'ni chca ñi 'in nten. ");
INSERT INTO cya_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Xacan' mxcuen Jesús 'in ne': A nchca tsatii tñan nu ngui'ni Stin, cui' cuaña'an nan'. ");
INSERT INTO cya_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Can' cha' ne' judio nde lyee la ngunan ne' ña'an nu cujui ne' 'in ñi, si'yana a n'ni cunta ñi tsaan nu nxitñan' ne', lo' si'i tsacan' ti cha', cui' ca nu nchcui' ñi si'yana Ndiose lca ycui' ca Sti ñi, lo' ngui'ni sca ñi 'in ñi lo'o Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Xacan' mxcuen Jesús 'in ne': Nu cha' ñi s'ni cunen lo'o um, Sñe' Ndiose, ñi sca cha' lo' a tca cu'ni cha' 'in ti, cui' ca nu cu'ni can' tsaña'an nu cua' m'ni cha'an 'in Stina Ndiose, si'yana nchgaa tñan nu ngui'ni Stina Ndiose, ticui' cuaña'an ngui'ni Sñe' ñi. ");
INSERT INTO cya_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Si'yana Stina Ndiose lyee ndyu'hui cuiya' ti' ñi 'in Sñe' ñi, lo' ndlo'o ñi 'in can' nchgaa tñan nu ngui'ni ñi, hasta tnu la cha' ntsu'hui cha' culo'o ñi 'in can' que ña'an cha' nu na'an um cua' ñii, lo' lyee la cuhue ti' um xacan'. ");
INSERT INTO cya_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Si'yana tsaña'an nxiqui'o Stina Ndiose 'in ne' cua' ngujui, cuaña'an ndaa Sñe' ñi chendyu nu cui' ti 'in nu nchca ti' ñi. ");
INSERT INTO cya_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Si'yana Stina Ndiose, a n'ni ñi xñan bsya 'in nten chendyu, cui' ca nu mdaa ñi cha' cuiya' can' 'in Sñe' ñi, ");
INSERT INTO cya_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ña'an ca si'yana cu'ni tnu nchgaa nten 'in Sñe' ñi tsaña'an n'ni tnu ne' 'in Stina Ndiose. Nu a cu'ni tnu 'in Sñe' ñi ticui' cuaña'an a n'ni tnu can' 'in nu ngua'an tñan 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nu cha' ñi s'ni cunen lo'o um, nu ndon nscan cha' nu nchcuin' lo' ndiya qui'an ti' 'in nu ngua'an tñan 'ñan, cua' jui chendyu nu a tsatii 'a 'in, a nducua 'a qui'ya chon' si'yana cua' mdo'o tso' can' sii' cha' ndyija lo' cua' jui chendyu 'in. ");
INSERT INTO cya_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nu cha' ñi s'ni cunen lo'o um, cua' mdiyaa xaa ntsu'hui cha' quine 'in ne' ngujui cha' nu chcui' Sñe' Ndiose, lo' nu cu'ni cunta 'in ñi caja chendyu 'in. ");
INSERT INTO cya_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Si'yana Stina Ndiose la' ña'an cua' ndi'in ñi, cui' cuaña'an mdaa ñi cha' cuiya' can' 'in Sñe' ñi. ");
INSERT INTO cya_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A cunta mdaa ñi cha' cuiya' 'in can' si'yana cu'ni xñan bsya 'in nten chendyu, si'yana lca can' Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","A cuhue ti' um cha' re, si'yana tiyaa xaa nchgaa nu ntsu'hui ni' cuaa quine 'in cha' nu chcui' can'. ");
INSERT INTO cya_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nu m'ni tñan tsu'hue tyiqui'o can' lo' caja chendyu 'in, nu m'ni tñan ngunan' tyiqui'o can' una tyijyin can' nu ti'i tsala xaa. Ñi nu ndaa suun cha' 'in Cristo ");
INSERT INTO cya_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ñi sca cha', lo' a tca cu'nin cha' 'ñan tin, cui' ca nu ngui'nin xñan bsya tsaña'an ndlo Stin tñan 'ñan, ñi ndi'in cha' 'ñan lo'o cha' re si'yana a ngui'nin ña'an nu nchca tin', cui' ca nu ngui'nin cha' nu nchca ti' ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Cha' ticuiin' ndaan suun ña'an ndi'in cha' 'ñan, a sca cunta ntsu'hui cha' can'. ");
INSERT INTO cya_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Una ntsu'hui xca tucui nu ndaa suun cha' 'ñan, lo' jlyo tin' si'yana suun nu ndaa can' lca na cha' nu ñi. ");
INSERT INTO cya_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Cui' um ngua'an tñan um 'in nu ya ñicha' 'in yu Xuhua can', lo' suun nu mdaa yu lca na cha' nu ñi. ");
INSERT INTO cya_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nan' a najo'o suun nu ndaa nten chendyu 'ñan, una chcuin' cha' re si'yana caja ña'an tyi'o laa um. ");
INSERT INTO cya_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yu Xuhua ncua yu ña'an nchca ti' sca quii' nu ndu'hui xaa, lo' sca co' xaa tsu'hue 'a yu'hui tiquee um lo'o cha' can'. ");
INSERT INTO cya_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nan' ndaan sca suun nu ndon loo la que ña'an nu mdaa yu Xuhua, si'yana ticui' tñan nu mdaa Stina Ndiose 'ñan ngui'nin cua' ñii, can' nu ndaa suun si'yana Stina Ndiose ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A cunta Stina Ndiose, ñi nu ngua'an tñan 'ñan, mdaa ñi suun ña'an ndi'in cha' 'ñan. Ñi siya' lo' a nchca quine 'in um cha' nu nchcui' ñi, ñi a nchca ña'an tloo um 'in ñi, ");
INSERT INTO cya_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ñi a nducuan xu'hue um cha' nu nchcui' ñi, si'yana a ndiya qui'an ti' um 'in nu ngua'an tñan ñi. ");
INSERT INTO cya_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Cu'ni quii tsu'hue um quityi 'in Ndiose, 'un nchcui' um si'yana ndaa na chendyu nu a tsatii 'a, lo' cui' cha' 'ñan lca nu nchcui' quityi can'. ");
INSERT INTO cya_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Una a nchca ti' um cuan xu'hue um 'ñan se'en nu caja chendyu nu a tsatii 'a 'in um. ");
INSERT INTO cya_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nan' a nducua tloon quinu tsu'hue tiquee nten lo'on, ");
INSERT INTO cya_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ndyu'hui lyoon cusya 'in um lo' jlyo tin' si'yana a tsu'hue ntsu'hui tiquee um lo'o Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nan' ljyaan lo'o cha' cuiya' 'in Stin, lo' a nducuan xu'hue um 'ñan, una cha' caan xca tucui lo'o cha' cuiya' nu 'in ti, can' nu cuan xu'hue um 'in. ");
INSERT INTO cya_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ta tca tsa qui'an ti' um cha' scasca um nducua tloo um quinu tsu'hue tiquee nten lo'o um, lo' si'i nu nsu'hua loo um cha' nu nchca ti' ycui' ca Ndiose? ");
INSERT INTO cya_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","A quiñan ti' um ta nan' su'huan qui'ya 'in um tloo Stina Ndiose, una ntsu'hui nu ndlo qui'ya 'in um, cui' Moisé nu nducua tloo um 'in. ");
INSERT INTO cya_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Cha' ndiya qui'an ti' um 'in Moisé, cui' cuaña'an tsa qui'an ti' um 'ñan, si'yana ticui' cha' 'ñan ngua'an Moisé. ");
INSERT INTO cya_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Una cha' a ndiya qui'an ti' um cha' nu ngua'an scua yu, ¿ña'an la ca cha' nu nchcuin'? ");
INSERT INTO cya_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chon' nde'en can' mdo'o Jesús nguiaa ñi xca tso' tiyo' Galilea, ticui' tiyo' Tiberias lca na. ");
INSERT INTO cya_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Qui'an 'a nten nducui ncha'an 'in ñi si'yana na'an ne' cha' nu tnu ngui'ni ñi lo'o nu ti'i. ");
INSERT INTO cya_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Xacan' ycuen Jesús sca loo nten, can' yten tucua ñi lo'o yu ta'a nda'an ñi. ");
INSERT INTO cya_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Cua' nchcui cha' ca ta'a pascua 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Xa mxina'an Jesús si'yana qui'an 'a nten ljyaan se'en nducua ñi, xacan' juin ñi 'in yu Lpe: ¿La ta xi'i na jaslya nu cu nten re? ");
INSERT INTO cya_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ycui' cuiya' ti ñi lo'o yu cha' ña'an ca xcuen yu, una cua' jlyo ti' ñi ña'an ntsu'hui cha' cu'ni ñi. ");
INSERT INTO cya_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mxcuen yu Lpe can': Ñi tñi nu cu'ni na canan tucua ciento tsaan, a cula na xi'i na jaslya nu cu nten re. ");
INSERT INTO cya_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Una yu Ndre, cui' ta'a nda'an ñi, ta'a ngula yu Simón Tyo, juin yu 'in ñi: ");
INSERT INTO cya_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Nde ndon sca yu lyo' ti nu nda'an lo'o ca'yu ti jaslya lo'o tucua cula suhue ti. Una ñi ca cula na lo'o tsare nten. ");
INSERT INTO cya_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nducua quixin' xuhue ti se'en can'. Xacan' juin Jesús: Chcui' um lo'o nten re si'yana sten tucua ne'. Tsalca yu qui'yu nu yten tucua can' ndiyaa yu ca'yu mii yu. ");
INSERT INTO cya_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Xacan' msñi Jesús jaslya can', mdyaa ñi xu'hue 'in Ndiose, msu'hue ñi 'in na lo' mdaa ñi 'in na 'in yu ta'a nda'an ñi, can' yu nu cua' mtsa 'in na 'in nchgaa nten. Ticui' cuaña'an m'ni ñi lo'o cula can', ycu ne' tsaña'an nu ncua 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Xa cua' mdyi ycu ne' juin Jesús 'in yu ta'a nda'an ñi: Xo' um nchgaa yu'hue nu nguinu cua si'yana a lyi'un na. ");
INSERT INTO cya_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xacan' mxo' yu 'in na, lo' m'ni cha'an yu tsa tichcua xcuhui lo'o yu'hue jaslya nu nguinu ycu ne' loo tsa ca'yu ti jaslya cebada can'. ");
INSERT INTO cya_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Xa na'an nten can' cha' nu tnu m'ni Jesús, mdyisnan ycui' ne': Nu cha' ñi ca, nde ñi nu nxiycui' ca Ndiose 'in, nu cua' mdiyaan loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Una Jesús ngu'ya ñi cunta si'yana nchca ti' ne' xicu'ni ne' 'in ñi nu ca ñi ree 'in ne', can' cha' mdo'o tso' ñi lja nten can', lo' nguiaa ñi nde sii' qui'ya can' scati ñi. ");
INSERT INTO cya_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Xa ngu'ya tla can' mdo'o yu ta'a nda'an ñi nguiaa yu tu'hua tiyo' can'. ");
INSERT INTO cya_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Can' yten yu ni' sca yca na'an nu tyijyin xi'yu yu xca tso' tiyo' can' nu tiyaa yu quichen Capernaum. Cua' ngu'ya tsu'hue tla, lo' Jesús a nchca tsa ncha'an ñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mdyisnan ncua cui'in lyee ya', cui' ña'aan cua' lo'o tiyo' can' mdyisnan nguitsa na. ");
INSERT INTO cya_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Xa cua' nguiaa yu tsa ntsu'hui lyoo ca'yu uta scua kilometro, xacan' na'an yu ljyan ncha'an Jesús 'in yu, nda'an quiya' ti ñi loo tyi'a can', lo' lyee 'a ytsen yu. ");
INSERT INTO cya_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lo' juin ñi 'in yu: Nan' lcan, a cutsen um. ");
INSERT INTO cya_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tsu'hue 'a ntsu'hui tiquee yu xa yten ñi ni' yca na'an can', cui' xaa ti mdiyaa yca na'an can' se'en ntsu'hui cha' tyi'o ti'in jun. ");
INSERT INTO cya_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Xca tsaan can' nten nu nguinu ti'in xca tso' tiyo' can', ngujlyo ti' ne' si'yana tsa yu ta'a nda'an ti Jesús yten ni' xca ti yca na'an nu nguinu nducui can', una a lo'o Jesús yten ñi. ");
INSERT INTO cya_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Una mdyi'o ti'in chcua xnan yca na'an nu mdo'o quichen Tiberias, lo' mdiyaa na cui' ti se'en ycu ne' jaslya xa cua' mdyaa Ñi X'nan na xu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Xa ncua cuiya' ti' nten can' si'yana a lo'o Jesús, lo' ñi yu ta'a nda'an ñi a lo'o can', xacan' yten ne' ni' yca na'an can', mdo'o ne' nguia nan ne' 'in Jesús nde quichen Capernaum. ");
INSERT INTO cya_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","La xca tso' tiyo' can' nguija lyoo ne' 'in ñi, lo' juin ne': 'Un ñi nu lca Bstro, ¿ñi xaa mdiyaan um nde re? ");
INSERT INTO cya_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mxcuen Jesús 'in ne': Nu cha' ñi s'ni cunen lo'o um, nda'an nan um 'ñan, una si'i si'ya cha' nu tnu nu na'an um, cui' ca nu si'yana ycu um jaslya ña'an nu ncua ti' um. ");
INSERT INTO cya_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Cu'ni um tñan, una si'i si'ya cha' nchcu ti, na nu ntsu'hui cha' lyi'un, cui' ca nu su'hua um juesa 'in um lo'o na nu ntsu'hui cha' ta loo tsala xaa, na nu ntsu'hui cha' taa Yu Qui'yu nu Mdo'o nde ni' Cuaan 'in um, si'yana nde ñi nu mdo'o hui ca 'in Stina Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Xacan' mxcuen ne' 'in ñi: ¿Ña'an ta cu'ni hua si'yana tca tucua hua tñan tsaña'an nu nchca ti' Ndiose? ");
INSERT INTO cya_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mxcuen Jesús 'in ne': Nde cha' nu nchca ti' Ndiose, si'yana tsa qui'an ti' um 'in nu ngua'an tñan ñi. ");
INSERT INTO cya_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Xacan' mxcuen ne' 'in ñi: ¿Ti ña'an ta cha' nu tnu cu'ni um tloo hua, lo' tsa qui'an ti' hua 'in um? ¿Ñi tñan cu'ni um cua' ñii? ");
INSERT INTO cya_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nu ncua nten cula 'in na ycu ne' jaslya nu mdo'o nde ni' cuaan lja nu mda'an ne' loo yuu ngutyi can', cui' tsaña'an nchcui' quityi 'in Ndiose: —Jaslya nu mdo'o nde ni' cuaan mdaa ñi ycu ne'—. ");
INSERT INTO cya_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Juin Jesús 'in ne': Nu cha' ñi s'ni cunen lo'o um, si'i Moisé lca nu mdaa jaslya nu mdo'o nde ni' cuaan 'in um, cui' ca nu Stin lca nu ndaa ycui' ca jaslya 'in um. ");
INSERT INTO cya_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Si'yana jaslya 'in Ndiose lca nu mdo'o nde ni' cuaan lo' ndaa na chendyu 'in nten. ");
INSERT INTO cya_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lo' juin ne' 'in ñi: Ñi X'nan hua, tyaa um jaslya can' cu hua tsala xaa. ");
INSERT INTO cya_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Xacan' juin Jesús 'in ne': Nan' lcan jaslya nu ndaa chendyu 'in nten. Nu ndiya nan 'ñan, ñi xiya' lo' 'a quite' 'a ti' can', lo' nu ndiya qui'an ti' 'ñan, ñi xiya' lo' a quityi 'a ti'. ");
INSERT INTO cya_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Cui' ña'an cua' nen lo'o um, siya' na'an tloo um 'ñan una a ndiya qui'an ti' um. ");
INSERT INTO cya_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Si'yana tsalca nu ndaa Stina Ndiose cha cuiya' 'in, can' nu quia nan 'ñan, lo' nu quia nan 'ñan a ntsu'hui cha' xcuan tloon 'in can'. ");
INSERT INTO cya_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nan' mdo'on nde ni' cuaan, una si'i si'yana cu'nin ña'an nu nchca tin', cui' ca nu ña'an nu nchca ti' ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nde cha' nu nchca ti' Stina Ndiose, ñi nu ngua'an tñan 'ñan, si'yana a quinan' ñi sca nu cua' mdaa ñi 'ñan, cui' ca nu cu'nin cha' tyiqui'o can' xa tsatii cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nde cha' nu nchca ti' ñi nu ngua'an tñan 'ñan, si'yana nchgaa nu chcua quiloo 'in Sñe' ñi lo' tsa qui'an ti' 'in ñi, caja chendyu nu a tsatii 'a 'in, lo' nan' cu'nin cha' tyiqui'o can' xa tsatii cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Xacan' mdyisnan ycui' tyijyin scasca ne' judio si'ya cha' nu juin Jesús: Nan' lcan jaslya nu mdo'o nde ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nchcui' ne': ¿Ta si'i Jesús sñe' See lca yu re, ta si'i na cua' ndyu'hui lyoo na 'in sti yu lo'o jyi'an yu? ¿Ña'an ta nchcui' yu si'yana nde ni' cuaan mdo'o yu? ");
INSERT INTO cya_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús juin ñi 'in ne': A najo'o chcui' tyijyin um lyee la. ");
INSERT INTO cya_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","A tucui nu quia nan 'ñan cha' si'i Stina Ndiose, ñi nu ngua'an tñan 'ñan, tu'hui tiquee can', lo' nan' cu'nin cha' tyiqui'o can' xa tsatii cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nde cha' nu ngua'an yu nu mxiycui' Ndiose 'in: —Nchgaa nten ntsu'hui cha' culo'o Ndiose 'in—. Can' cha' nchgaa nu cua' ngune 'in cha' nu ycui' Stina Ndiose lo' m'ni cha'an 'in ñi, can' nu ndiya nan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Si'i si'yana nde'en la tucui nu cua' na'an tloo 'in Stina Ndiose, cui' ca nu scati ñi nu mdo'o se'en nducua ñi, can' nu cua' na'an tloo 'in Stina Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nu cha' ñi s'ni cunen lo'o um, nu ndiya qui'an ti' 'ñan cua' jui chendyu nu a tsatii 'a 'in. ");
INSERT INTO cya_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nan' lcan jaslya nu ndaa chendyu 'in nten. ");
INSERT INTO cya_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nu ncua nten cula 'in na ycu ne' jaslya nu mdo'o nde ni' cuaan xa mda'an ne' loo yuu ngutyi can', una chon' nde'en can' ngujui ne'. ");
INSERT INTO cya_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Una nde jaslya nu mdo'o nde ni' cuaan, lo' nu cu 'in na, a caja 'a can'. ");
INSERT INTO cya_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nan' lcan jaslya nu lo'o ca nu mdo'o nde ni' cuaan, lo' nu cu jaslya re tyu'hui can' chendyu tsala xaa. Nan' lcan jaslya can', lo' tyaan 'ñan si'yana caja chendyu 'in nten. ");
INSERT INTO cya_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Xacan' ne' judio mdyisnan nchcui' tyijyin ne' lo'o ta'a ne', lo' nchcui' ne': ¿Ña'an ta tca taa yu re ticuii' cunan' yu cu na? ");
INSERT INTO cya_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Lo' juin Jesús 'in ne': Nu cha' ñi s'ni cunen lo'o um, cha' na a cu um cunan' Yu Qui'yu nu Mdo'o nde ni' Cuaan, lo' cha' a co'o um tne yu, a ntsu'hui chendyu 'in um. ");
INSERT INTO cya_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nu cu cunan' lo' co'o tnen, cua' jui chendyu nu a tsatii 'a 'in, lo' nan' cu'nin cha' tyiqui'o can' xa tsatii cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Si'yana cunan' lca na ycui' ca cha' nchcu, lo' tnen lca na ycui' ca cha' ndyi'o. ");
INSERT INTO cya_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu cu cunan' lo' co'o tnen, sca cha' ti 'in lo'on, cui' cuaña'an nan' lo'o can'. ");
INSERT INTO cya_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Stina Ndiose, ñi nu lo'o ca, ngua'an tñan ñi 'ñan, lo' si'ya ñi can' cha' lo'on nan', cui' cuaña'an taan chendyu 'in nu cuan xu'hue 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nde jaslya nu mdo'o nde ni' cuaan, una si'i ña'an jaslya nu ycu nten cula 'in na lo' ngujui ne', nu cu jaslya re caja chendyu nu a tsatii 'a 'in. ");
INSERT INTO cya_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nde cha' nu ycui' Jesús xa ngulo'o ñi 'in nten se'en ndiyo' ti'in ne' judio quichen Capernaum. ");
INSERT INTO cya_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Qui'an 'a nu nducui ncha'an 'in ñi ngune 'in cha' nu ycui' ñi, lo' juin ne': Tucui 'a cha' nu ndlo'o ñi re. ¿Tucui ca nu qui'ya cunta 'in na? ");
INSERT INTO cya_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ngüi ti' Jesús ña'an cha' nu nchcui' nu nducui ncha'an 'in ñi, lo' juin ñi 'in ne': ¿Ta na a mdiyaa ti' um cha' nu ycuin'? ");
INSERT INTO cya_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ña'an ta cu'ni um cha' ña'an tloo um scuen Yu Qui'yu nu Mdo'o nde ni' Cuaan se'en ndi'in ñi ti' culoo? ");
INSERT INTO cya_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Si'ya cusya 'in na can' cha' lo'o na, cunan' re a sca ntsu'hui lyoo na. Cha' nu ycuin' lo'o um lca na cha' nu lo'o ca lo' ndaa na chendyu 'in um. ");
INSERT INTO cya_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Una ntsu'hui um re a ndiya qui'an ti' um 'ñan. Juin Jesús cuaña'an si'yana ti' culoo cua' ngujlyo ti' ñi tsalca nu a ndiya qui'an ti' 'in ñi, lo' ti nu ntsu'hui cha' tyaa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ti' juin la ñi: Can' cha' cua' ycuin' lo'o um si'yana a tucui nu quia nan 'ñan, cha' si'i Stina Ndiose ndu'hui tiquee can'. ");
INSERT INTO cya_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ti' xacan' qui'an 'a nu nducui ncha'an 'in ñi mdo'o tso', lo' a mda'an 'a lo'o ñi. ");
INSERT INTO cya_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Xacan' juin Jesús lo'o tichcua yu ta'a nda'an ñi: ¿Ta na lo'o um nchca ti' um tyi'o tso' um? ");
INSERT INTO cya_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yu Simón Tyo can' mxcuen yu 'in ñi: Ñi X'nan hua, ¿tucui ta 'in chcui ncha'an hua, lo' scati um nda'an lo'o um cha' nu ndaa chendyu nu a tsatii 'a 'in hua? ");
INSERT INTO cya_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Huare' cua' ya qui'an ti' hua 'in um, lo' ncua cuiya' ti' hua si'yana 'un lca um Cristo, Sñe' Ndiose, ñi nu lo'o ca. ");
INSERT INTO cya_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mxcuen Jesús 'in yu: ¿Ta si'i nan' ngulohuin 'in ta'a tichcua um, lo' sca um nguiaa um tso' 'in laxa'an? ");
INSERT INTO cya_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ycui' ñi cuaña'an si'ya cha' 'in yu Juda Iscariote, sñe' Simón, si'yana can' nu ntsu'hui cha' tyaa 'in ñi, lo' cui' ta yu tichcua can' lca yu. ");
INSERT INTO cya_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chon' nde'en can' mda'an Jesús se'en lyi'ya loo Galilea, a ncua ti' ñi tsaa ñi se'en lyi'ya loo Judea, si'yana ntsu'hui tiquee ne' judio cujui 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Cua' nchcui cuii' cha' ca ta'a 'in ne' judio xa ntñan ne' quisin. ");
INSERT INTO cya_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ta'a Jesús juin 'in ñi: ¿Ñi cha' ta a tsaa se'en lca Judea, si'yana lo'o yu ta'a nda'an ña'an yu cha' nu tnu ngui'ni? ");
INSERT INTO cya_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Si'yana a tucui nu culyo scua la cha' 'in, cu'ni sca cha' nu cunan ti, Cha' cuaña'an ngui'ni cha' nu tnu, cu'ni 'in na tloo na'an nchgaa nten. ");
INSERT INTO cya_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Lo' ñi sca ta'a Jesús a ndiya qui'an ti' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Xacan' juin Jesús 'in ta'a ñi: A nchca tiyaa braa nu 'ñan, una 'un ña'an braa ti tsu'hue 'in um. ");
INSERT INTO cya_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ñi a ntsu'hui cha' xcuan tloo nten 'in um, una nan' nxcuan tloo ne' 'ñan si'yana ndlyo scua lan cha' ngunan' nu ngui'ni ne'. ");
INSERT INTO cya_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Una 'un tca tsaa um ta'a cua, nan' a tsa'an si'yana a nchca tiyaa braa nu 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ti' nguinu la ñi se'en lca Galilea xa ycui' ñi cha' re. ");
INSERT INTO cya_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Una xa cua' mdo'o ta'a ñi nguiaa, xacan' mdo'o ñi scati ñi nguiaa ñi se'en nchca ta'a can', a mda'an la ñi, cui' ca nu nda'an cutsi' ti ñi. ");
INSERT INTO cya_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Se'en nchca ta'a can' nda'an nan ne' judio 'in ñi, lo' nchcui' ne': ¿La ta ncua yu can'? ");
INSERT INTO cya_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lja nten qui'an can' scasca ña'an nchcui' ne' cha' 'in ñi, ntsu'hui nu nchcui': Tsu'hue nten lca ñi. Ntsu'hui nu nchcui': Si'i na, cui' ca nu nda'an ñilyi'o yu 'in nten. ");
INSERT INTO cya_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Una a tucui nu nchcui' la cha' 'in ñi si'yana nguitsen ne' tloo ne' judio. ");
INSERT INTO cya_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tlu'hue nguiaa nchca ta'a can' xa yten Jesús ni' lyaa, lo' mdyisnan ngulo'o ñi 'in nten. ");
INSERT INTO cya_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nduhue 'a ti' ne' judio 'in ñi, lo' nchcui' ne': ¿La ta ngulo yu cha' tiyaa re, lo' a chcan' yu'hui yu xcula? ");
INSERT INTO cya_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Xacan' juin Jesús 'in ne': Cha' nu ndlo'on 'in um, si'i cha' tiyaa 'ñan lca na, cui' ca nu lca na cha' tiyaa 'in ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nu nchca ti' tucua tñan cha' nu nchca ti' Ndiose, qui'ya can' cunta cha' na ndlo'on cha' 'in Ndiose, uta na nchcuin' lo'o cha' tiyaa nu 'ñan tin. ");
INSERT INTO cya_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sca nten nu nchcui' lo'o cunta 'in, nsu'hua loo can' 'in ticuii', una cha' nsu'hua loo can' 'in nu ngua'an tñan 'in, ñi ndi'in cha' 'in lo' a nchcui' cha' cuiñi. ");
INSERT INTO cya_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Ta si'i Moisé lca nu mdaa lee 'in um, lo' ñi sca um a nducua um tñan 'in na? ¿Ñi cha' ta nchca ti' um cujui um 'ñan? ");
INSERT INTO cya_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Xacan' mxcuen nten can': Cui'in xa'an ntsu'hui 'in nu'huin. ¿Ti nu nchca ti' cujui 'in? ");
INSERT INTO cya_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Mxcuen Jesús 'in ne': Scati cha' nu tnu cua' m'nin, lo' nchgaa um nduhue ti' um. ");
INSERT INTO cya_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Cha' ñi si'yana Moisé ngulo tñan si'yana ca circuncida 'in um, (una si'i Moisé mducua suun cha' re, cui' ca nu mdyisnan na lo'o nten cula 'in na), ¿ta si'i cui' tsaan nu nxitñan' na n'ni um circuncida 'in sñe' um? ");
INSERT INTO cya_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lo' si'yana a nchca ti' um tnan' um cha' 'in lee nu mdaa Moisé, n'ni um circuncida 'in sñe' um siya' tsaan nu nxitñan' na, ¿ñi cha' ti'i ti' um 'ñan si'yana m'nin chcan can 'in sca yu qui'yu tsaan nu nxitñan' na? ");
INSERT INTO cya_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A cu'ni cuiya' um sca cha' lo'o cha' tiyaa nu 'in um, cui' ca nu cu'ni cuiya' um 'in na lo'o sca cha' tiyaa nu ñi. ¿Ta re ñi nu lca Cristo? ");
INSERT INTO cya_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Xacan' mdyisnan nchcui' scasca ne' Jerusalén: ¿Ta si'i re nu nda'an nan ne' si'yana cujui ne' 'in? ");
INSERT INTO cya_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Cua' ñii nchcui' la yu tloo nten re, lo' a tucui nu nchcui ndijin. ¿Ta xtyi ti' lo'o bsya cua' m'ni cunta si'yana lca yu ycui' ca Cristo? ");
INSERT INTO cya_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yu re jlyo ti' na la quichen mdo'o yu, una xa ntsu'hui cha' caan ñi nu lca Cristo, a tucui ca jlyo ti' la tyi'o can'. ");
INSERT INTO cya_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Xacan' ycui' cueen Jesús se'en ndon ñi ndlo'o ñi ni' lyaa can': 'Un ndyu'hui lyoo um 'ñan lo' jlyo ti' um la mdo'on, nan' a ljyaan lo'o cunta nu 'ñan tin, una ñi ndi'in cha' 'in ñi nu ngua'an tñan 'ñan, lo' a ndyu'hui lyoo um 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Una nan' ndyu'hui lyoon 'in ñi si'yana mdo'on se'en nducua ñi, lo' cui' ñi ngua'an tñan ñi 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ncua ti' ne' si'yana quinu ñi, una a tucui nu msñi 'in ñi si'yana a nchca tiyaa braa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Qui'an 'a nten ya qui'an ti' 'in ñi, lo' nchcui' ne': Xa caan ñi nu lca Cristo, ¿ta lyee la cu'ni ñi cha' nu tnu que ña'an yu re? ");
INSERT INTO cya_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ne' fariseo ngune 'in ne' ña'an nchcui' nten can' cha' 'in Jesús, lo' yu nu ndlo ca tñan ni' lyaa lo'o ne' fariseo, ngua'an tñan ne' 'in yu nu ntsu'hui cuan can', si'yana xñi yu 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Xacan' juin Jesús 'in ne': Ti' ña'an ta'a na xca co' xaa, la xacan' qui'an se'en nducua ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Siya' quia nan um 'ñan una a quija lyoon 'in um, lo' ñi a tca tsaa um se'en nu nan' tsa'an. ");
INSERT INTO cya_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Xacan' mdyisnan ycui' ne' judio: ¿La ta tsaa yu re si'yana a quija lyoo yu 'in na? ¿Uta tsaa yu se'en ndi'in ta'a judio na nu ndi'in xca quichen, lo' culo'o yu 'in ne' griego? ");
INSERT INTO cya_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ñi cha' nchca ti' chcui' ña'an juin yu: Siya' quia nan um 'ñan una a quija lyoon 'in um, lo' ñi a tca tsaa um se'en nu nan' tsa'an? ");
INSERT INTO cya_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Xca ti tsaan nu nchca ta'a can', cui' tsaan nu ndon loo lati 'in ne', mdyiton Jesús lo' ycui' cueen ñi: Cha' ntsu'hui nu nguityi ti' tyi'a, tca caan lo' taan tyi'a co'o can'. ");
INSERT INTO cya_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nu ndiya qui'an ti' 'ñan, cui' ña'an nchcui' quityi 'in Ndiose, nde ni' cusya 'in ntsu'hui cha' chcua tyi'a nu lo'o ca. ");
INSERT INTO cya_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nde cha' nu ycui' ñi si'ya Espíritu 'in Ndiose nu ntsu'hui cha' cha'an yu'hui ni' cusya 'in nchgaa nu tsa qui'an ti' 'in Jesús. Xa ycui' ñi cha' re ti' lyijyi caan Espíritu nu Luhui 'in Ndiose, si'yana Jesús a nchca scuen ñi nde ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Xa ngune 'in nten can' cha' nu ycui' ñi mdyisnan ycui' ne' scasca ne': Nu cha' ñi ca si'yana nde yu nu nxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ntsu'hui xca nu nchcui': Ycui' ca Cristo lca yu re. A cunta ntsu'hui nu nchcui': ¿Ta Galilea tyi'o ñi nu lca Cristo? ");
INSERT INTO cya_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Ta si'i na nchcui' quityi 'in Ndiose si'yana —loo ta nten 'in Davi tyi'o— ñi nu lca Cristo, —cui' Belén— quichen tyi Davi? ");
INSERT INTO cya_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lo' si'ya ñi a ncua ca sca cha' ti 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ntsu'hui nu ncua ti' si'yana quinu ñi, una a tucui nu msti ti'. ");
INSERT INTO cya_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yu nu ntsu'hui cuan can' mxitucui yu se'en ndiyo' ti'in yu nu ndlo ca tñan ni' lyaa tsatlyu lo'o ne' fariseo, lo' mñicha' ne' 'in yu: ¿Ñi cha' ta a nguian lo'o um 'in yu? ");
INSERT INTO cya_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mxcuen yu: Ñi sca tucui lo' a nchca quine 'in hua chcui' tsaña'an nchcui' yu cua. ");
INSERT INTO cya_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Xacan' juin ne' fariseo: ¿Ta xtyi ti' lo'o um cua' jui nu nguñilyi'o 'in um? ");
INSERT INTO cya_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ta nde'en yu nu lyi'ya tñan re uta lo'o ne' fariseo cua' ya qui'an ti' 'in yu? ");
INSERT INTO cya_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Una nten re si'yana a ndyu'hui lyoo ne' lee, nducua yuhue' chon' ne'. ");
INSERT INTO cya_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Xacan' yu Nicodemo, yu nu ya ycui' lyi'o Jesús sca tla, cui' ta nten 'in ne' fariseo lca yu, ");
INSERT INTO cya_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","lo' juin yu: Una tsaña'an nchcui' lee 'in na, ¿ta tca cu'ni cuiya' na cha' 'in sca nten, cha' ti' lyijyi quine 'in na cha' nu m'ni ne'? ");
INSERT INTO cya_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mxcuen ne' 'in yu: ¿Ta na lo'o um lca um ne' Galilea? Cu'ni quii tsu'hue um loo quityi 'in Ndiose lo' qui'ya um cunta si'yana a ntsu'hui cha' tyi'o sca nu nxiycui' Ndiose 'in se'en lca Galilea. ");
INSERT INTO cya_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Xacan' cunda scaa ne' mdo'o ne' nguiaa ne' nde ña'an 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Xacan' mdo'o Jesús nguiaa ñi se'en nducua qui'ya Olivo. ");
INSERT INTO cya_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tlya xca tsaan can' mxitucui ñi lo' yten ñi ni' lyaa, ña'aan quichen ne' nguio' ti'in ne' se'en nducua ñi, lo' mdyisnan ngulo'o ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Xacan' ne' escriba lo'o ne' fariseo mdiya lo'o yu 'in sca ne' cuna'an nu yten yu'hui lo'o xca yu qui'yu. Lja nten can' mdi'in tyaa yu 'in ne' cuna'an can'. ");
INSERT INTO cya_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Lo' juin yu 'in ñi: 'Un ñi nu lca Bstro, ne' cuna'an re nguija lyoo ne' lja nguiten yu'hui ne' lo'o xca yu qui'yu. ");
INSERT INTO cya_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lee nu mxnu scua Moisé ndlo na tñan si'yana sca ne' cuna'an nu ngui'ni cuaña'an, 'ni cha' cujui ne' 'in lo'o quee. Cua' ñii, ¿ña'an ta ljuin um? ");
INSERT INTO cya_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ycui' cuiya' ti yu cha' ña'an ca xcuen ñi se'en nu su'hua yu qui'ya 'in ñi. Una Jesús yten tucua ñi lo' mdyisnan ngua'an ñi lyuu lo'o loyaa' ñi. ");
INSERT INTO cya_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Si'yana ticui' ti loo cha' nchcui' yu, mdyiton ñi, lo' juin ñi 'in nten can': Nu ñan ti' si'yana a sca qui'ya nducui, can' nu culo nducua la jyi'in quee 'in ne' cuna'an re. ");
INSERT INTO cya_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Xiya' yten tucua ñi lo' ngua'an ñi lyuu can'. ");
INSERT INTO cya_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Una xa ngune 'in ne' cha' nu ycui' ñi, cui' xaa ngu'ya ne' cunta si'yana nducui ne' qui'ya, cunda scaa ti ne' mdo'o ne' nguiaa ne' ti' nu cula la hasta lo'o nu suhue ti. Xca ti Jesús nguinu tucua ñi se'en ndon ne' cuna'an can'. ");
INSERT INTO cya_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Xacan' mdyiton Jesús lo' na'an ñi si'yana a tucui 'a nu ndon can', cui' ca nu xca ti ne' cuna'an can', lo' juin ñi 'in ne': ¿La ncua nu nsu'hua qui'ya 'in? ¿Ti nu ngulo tñan si'yana caja? ");
INSERT INTO cya_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mxcuen ne' cuna'an can': A tucui, Ñi X'nan hua. Xacan' juin Jesús lo'o ne': Ñi nan' a su'huan qui'ya 'in. Quiaa lya, lo' a cu'ni 'a qui'ya. ");
INSERT INTO cya_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Xiya' mdyisnan ycui' Jesús lo'o nten can': Nan' lcan nu ndu'hui xaa 'in nten chendyu. Nu chcui ncha'an 'ñan, a tyi'an 'a se'en tla yta, cui' ca nu tyi'an can' loo xaa nu ndaa chendyu. ");
INSERT INTO cya_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Xacan' juin ne' fariseo 'in ñi: Ticui' ti ndaa suun ña'an ndi'in cha' 'in, can' cha' a sca cunta ntsu'hui ña'an nu nchcui'. ");
INSERT INTO cya_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mxcuen Jesús: Siya' ticuin' ndaan suun cha' 'ñan, una lca na cha' nu ñi, si'yana jlyo tin' la mdo'on, lo' jlyo tin' la qui'an, una 'un a jlyo ti' um la mdo'on uta la qui'an. ");
INSERT INTO cya_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'Un n'ni cuiya' um cha' lo'o cha' tiyaa 'in nten chendyu, una nan' a ngui'nin cuiyan' cha' 'in ñi sca tucui. ");
INSERT INTO cya_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Lo' cha' cu'nin cuiyan' cha' 'in nten, cu'nin 'in na lo'o cha' nu ñi, si'yana si'i scan tin, cui' ca nu lo'o Stina Ndiose, ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ticui' lee 'in um nchcui' na, cha' tucua yu scaña'an ti suun taa yu, lca na cha' nu ñi. ");
INSERT INTO cya_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nan' ndaan suun tsaña'an ndi'in cha' 'ñan, cui' cuaña'an Stina Ndiose, ñi nu ngua'an tñan 'ñan, ndaa ñi suun ña'an ndi'in cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Xacan' juin ne' 'in ñi: ¿La ta ncua Sti? Mxcuen Jesús: Ñi 'ñan nan', lo' a ndyu'hui lyoo um, lo' ñi 'in Stin. Cha' cua na ndyu'hui lyoo um 'ñan, lo'o Stin ndyu'hui lyoo um xacan'. ");
INSERT INTO cya_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ndlo'o Jesús cha' re ni' lyaa se'en ndyi'ya ne' lcuan, lo' a tucui nu msñi 'in ñi si'yana ti' lyijyi tiyaa braa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Xiya' ycui' Jesús lo'o nten can': Nan' ntsu'hui cha' tsa'an, lo' 'un tyi'an nan um 'ñan, una tsato'o caja um loo qui'ya 'in um, can' cha' a tca tsaa um se'en ntsu'hui cha' tsa'an. ");
INSERT INTO cya_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Scasca ne' judio mdyisnan ycui' ne': ¿Ta xtyi ti' cujui yu 'in yu ticuii' yu? ¿Ta can' cha' nchcui' yu si'yana a tca tsaa na se'en ntsu'hui cha' quiaa yu? ");
INSERT INTO cya_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Juin Jesús 'in ne': 'Un ndi'in loo chendyu re, nan' mdo'on nde ni' cuaan. Loo chendyu re mdo'o um, una nan' si'i re mdo'on. ");
INSERT INTO cya_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Can' cha' nen lo'o um ntsu'hui cha' caja um loo qui'ya 'in um. Cha' na a tsa qui'an ti' um tucui lcan, loo qui'ya 'in um ntsu'hui cha' caja um. ");
INSERT INTO cya_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Xacan' juin ne' 'in ñi: Nu'huin jan ñi, ¿tucui ta lca cha' na can'? Mxcuen Jesús: Cui' ña'an cua' nen lo'o um ti' culoo. ");
INSERT INTO cya_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Qui'an 'a cha' ti' ntsu'hui cha' chcuin' lo'o ña'an nu ngui'ni um. Ñi nu ngua'an tñan 'ñan, ñi ndi'in cha' 'in ñi, lo' nchcuin' cha' nu ngune 'ñan ycui' ñi. ");
INSERT INTO cya_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Una a ngu'ya ne' cunta si'yana cha' 'in Stina Ndiose nchcui' ñi. ");
INSERT INTO cya_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Xacan' juin Jesús 'in ne': Xa jyi'in ca'an um 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan loo cusi, xacan' ca cuiya' ti' um si'yana nan' lcan ña'an cua' nen lo'o um, ñi sca cha' lo' a ngui'nin lo'o cha' cuiya' nu 'ñan, cui' ca nu nchcuin' cha' nu m'ni cha'an 'in Stina Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ñi nu ngua'an tñan 'ñan ndi'in ñi lo'on, lo' a mxnu Stina Ndiose 'ñan scan tin, si'yana nchgaa xaa nducuan tñan ña'an cha' nu nchca ti' ñi. ");
INSERT INTO cya_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Xa ycui' ñi cha' re, qui'an 'a nten ya qui'an ti' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Xacan' juin Jesús 'in ne' judio nu ya qui'an ti' 'in ñi: Cha' 'un tyon tla um lo'o cha' nu nchcuin', cha' ñi ca lca um nu ngui'ni cha'an 'ñan, ");
INSERT INTO cya_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","chu'hui lyoo um cha' nu ñi, lo' cha' nu ñi can' culo laa na 'in um. ");
INSERT INTO cya_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mxcuen ne' 'in ñi: Huare' lca hua ta nten 'in Abraham, lo' ñi siya' lo' a nchca ca hua nguso 'in xca tucui lo'o juesa, ¿ña'an ta nchcui' si'yana ntsu'hui cha' tyi'o laa hua? ");
INSERT INTO cya_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Xacan' mxcuen Jesús 'in ne': Nu cha' ñi s'ni cunen lo'o um, nchgaa nu ngui'ni qui'ya, nguso 'in qui'ya lca can'. ");
INSERT INTO cya_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sca nguso a tca quinu lo'o x'nan tsala xaa, una yu nu lca sñe' x'nan can', tsala xaa ntsu'hui cha' quinu lo'o sti. ");
INSERT INTO cya_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Can' cha', cha' na Sñe' Ndiose culo laa 'in um, nu cha' ñi ca tyi'o laa um xacan'. ");
INSERT INTO cya_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nan' jlyo tin' si'yana lca um ta nten 'in Abraham, una nchca ti' um cujui um 'ñan, si'yana a nducuan xu'hue um cha' nu nchcuin'. ");
INSERT INTO cya_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nan' nchcuin' tsaña'an cha' nu na'an tloon se'en nducua Stina Ndiose, una 'un ngui'ni um cha' nu nchcui' sti um. ");
INSERT INTO cya_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mxcuen ne' 'in ñi: Abraham lca nu ncua nten cula 'in hua. Xacan' juin Jesús 'in ne': Cha' na lca um sñe' Abraham, cui' tñan nu m'ni Abraham cu'ni um xacan'. ");
INSERT INTO cya_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Una nde nchca ti' um cujui um 'ñan, cui' nu nchcui' cha' nu ñi tsaña'an nu ngune 'in ycui' Ndiose. Una Abraham a m'ni yu cuaña'an. ");
INSERT INTO cya_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Una 'un ngui'ni um tñan nu ngui'ni sti um. Xacan' juin ne' 'in ñi: Una huare' si'i ña'an tucui ti lca sti hua, si'yana scati Ndiose lca sti hua. ");
INSERT INTO cya_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Xacan' mxcuen Jesús 'in ne': Cha' na Ndiose lca sti um, tsu'hue ntsu'hui tiquee um lo'on, si'yana nan' mdo'on se'en nducua Ndiose lo' mdiyaan re, una si'i lo'o cha' cuiya' nu 'ñan tin, cui' ca nu lo'o cha' cuiya' 'in ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ñi cha' a ndyi'ya um cunta cha' nu nchcuin'? Cui' si'yana a nchca ti' um cuan xu'hue um 'in na. ");
INSERT INTO cya_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'Un nguiaa um tso' 'in laxa'an nu lca sti um, lo' nguia ncha'an um ña'an nu ngui'ni can'. Ti' culoo lca can' nu ndujui nten, a ndon can' loo cha' nu ñi si'yana a ñi ndi'in cha' 'in, la' ña'an nchcui' can' cha' cuiñi si'yana lca nu cuiñi, ycui' ca sti cha' cuiñi. ");
INSERT INTO cya_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nan' si'yana nchcuin' cha' nu ñi, can' cha' a ndiya qui'an ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ti nu tca chcui' si'yana nducuin qui'ya? Cha' na nchcuin' cha' nu ñi, ¿ñi cha' a ndiya qui'an ti' um 'ñan? ");
INSERT INTO cya_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nu nguiaa tso' 'in Ndiose ndon nscan cha' 'in Ndiose, can' cha' a ndon nscan um cha' re si'yana a nguiaa um tso' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Xacan' mxcuen ne' judio 'in ñi: Cui' ña'an cua' ycui' hua lo'o si'yana lca ne' Samaria, lo' ntsu'hui cui'in xa'an 'in. ");
INSERT INTO cya_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mxcuen Jesús: A ntsu'hui cui'in xa'an 'ñan. Cui' ca nu ngui'nin tnun 'in Stin, una 'un nxcuan tloo um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ñi a nchca tin' scuen cuaan 'ñan ticuiin', una xca tucui nscuen cuaan 'ñan, can' nu cu'ni cuiya' cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nu cha' ñi s'ni cunen lo'o um, nu xu'hua se'en cha' nu nchcuin', a ntsu'hui cha' caja can'. ");
INSERT INTO cya_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Xacan' juin ne' judio 'in ñi: Cua' ñii ngu'ya hua cunta si'yana ntsu'hui cui'in xa'an 'in. Abraham ngujui yu, cui' cuaña'an ngujui nchgaa la ña'an yu nu mxiycui' Ndiose 'in, lo' nu'huin nchcui': Nu xu'hua se'en cha' nu nchcuin', a ntsu'hui cha' caja can'. ");
INSERT INTO cya_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ta ndon loo la nu'huin que 'in Abraham nu ncua nten cula 'in na? Ngujui yu lo' ngujui nchgaa la ña'an yu nu mxiycui' Ndiose 'in, lo' nu'huin, ¿tucui ta lca ñan ti'? ");
INSERT INTO cya_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mxcuen Jesús: Cha' nan' scuen cuaan 'ñan ticuiin', a sca cunta ntsu'hui, una ñi nu lca Stin, can' nu nscuen cuaan 'ñan, cui' ñi nu nchcui' um lca Ndiose 'in um. ");
INSERT INTO cya_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'Un a ndyu'hui lyoo um 'in ñi, una nan' ndyu'hui lyoon 'in ñi. Cha' cunen a ndyu'hui lyoon 'in ñi, lcan sca nu cuiñi tsaña'an ndi'in cha' 'in um. Una nan' ndyu'hui lyoon 'in ñi lo' nxu'hua se'en cha' nu nchcui' ñi. ");
INSERT INTO cya_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham nu ncua nten cula 'in um, tsu'hue yu'hui tiquee yu xa ynan yu cha' si'yana ntsu'hui cha' caan, na'an yu cha' can' lo' ncua tsu'hue yu'hui tiquee yu. ");
INSERT INTO cya_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Xacan' juin ne' judio 'in ñi: Ñi tu'hua tyii yjan a nchca chu'hui, lo' nchcui' si'yana cua' na'an 'in Abraham. ");
INSERT INTO cya_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Juin Jesús 'in ne': Nu cha' ñi s'ni cunen lo'o um, ti' lyijyi tyi'in Abraham lo' nan' cua' ndi'in. ");
INSERT INTO cya_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Xacan' msñi ne' quee si'yana jyi'in ne' 'in Jesús, una yu'hui cutsi' ñi lo' mdyi'o ñi ni' lyaa can', mdijin ñi lja nten can' nguiaa ñi. ");
INSERT INTO cya_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tucueen se'en mdijin Jesús, na'an ñi nducua sca yu cua' lca cuityin' ti' xa ngula. ");
INSERT INTO cya_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yu ta'a nda'an ñi mñicha' 'in ñi: Rabí, ¿ti nu nducui qui'ya, yu re uta na nten cula 'in yu, ñi cha' cua' lca cuityin' yu xa mdiyaan yu chendyu? ");
INSERT INTO cya_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Xacan' mxcuen Jesús: Si'i yu, lo' ñi nten cula 'in yu a nducui jun qui'ya, cui' ca nu si'yana ca chcan' loo cha' nu tnu cu'ni Ndiose lo'o yu. ");
INSERT INTO cya_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","'Ni 'ni ca cha' cu'nin tñan 'in ñi nu ngua'an tñan 'ñan lja nu ti' ndyijyi xaa, si'yana cha' cua' ngu'ya tla a tucui 'a nu cu'ni tñan. ");
INSERT INTO cya_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lja nu ti' ndi'in loo chendyu re, nan' lcan nu ndu'hui xaa 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ña'aan mdyi ycui' ñi cha' re ngulo'o siye' ñi lyuu, m'ni ñi tsachin' mtso' lo'o tyi'a siye' ñi, lo' mxita'an ñi 'in na quiloo yu cuityin' can', ");
INSERT INTO cya_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","lo' juin ñi 'in yu: Ya ycui tyi'a tloo ni' plyaa Siloé cua, (cha' re nchca ti' chcui': Nu ngua'an tñan ne' 'in). Xacan' ya ycui yu tyi'a tloo yu, lo' cua' lca nguila na 'in yu xa mxitucui yu. ");
INSERT INTO cya_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tsalca ta'a nducua ti yu, lo'o nu jlyo ti' si'yana ncua yu sca nu cuityin', nchcui' ne': ¿Ta si'i re yu cuityin' nu nchcua njñan lcuan nchgaa xaa? ");
INSERT INTO cya_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ntsu'hui nu nchcui': Cui' yu. Ntsu'hui xca nu nchcui': Na chcui ña'an ti yu. Ticuii' yu mxcuen yu 'in ne': Nan' lcan. ");
INSERT INTO cya_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mñicha' ne' 'in yu: ¿Lo' ña'an ta ncua nguila quiloo? ");
INSERT INTO cya_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mxcuen yu 'in ne': Cui' yu nu naan Jesús m'ni chu'hue yu tsachin' mtso', mxita'an yu 'in na quiloon, lo' juin yu 'ñan: Ya ycui tyi'a tloo se'en lca Siloé cua. Cui' xaa ya ycuin tyi'a tloon, lo' ncua chcan' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Xacan' juin ne' 'in yu: ¿La ta ncua yu ñii? Mxcuen yu 'in ne': A jlyo tin'. ");
INSERT INTO cya_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ya lo'o ne' 'in yu nu ncua cuityin' can' tloo ne' fariseo. ");
INSERT INTO cya_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lca na tsaan nu nxitñan' ne' judio xa m'ni chu'hue Jesús mtso' can', lo' m'ni ñi cha' nguila quiloo yu. ");
INSERT INTO cya_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ticui' cuaña'an mñicha' ne' fariseo 'in yu cha' ña'an ncua nguila quiloo yu. Lo' juin yu 'in ne': Tsachin' mtso' mxita'an yu quiloon, mjyi'an 'in na, lo' cua' ñii chcan' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Xacan' mdyisnan ycui' ne' fariseo: Yu cua a mdo'o yu se'en nducua Ndiose si'yana a nxu'hua se'en yu tsaan nu nxitñan' na. Ntsu'hui xca nu nchcui': ¿Una ña'an ta n'ni yu cha' nu tnu cha' na lca yu nten qui'ya chendyu? Lo' a ncua 'a ca sca cha' ti 'in ne' si'ya ñi. ");
INSERT INTO cya_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Xiya' mñicha' ne' 'in yu nu ncua cuityin' can': ¿Ña'an ta ñan ti' lo'o yu nu msla quiloo? Mxcuen yu 'in ne': Yu nu nxiycui' Ndiose 'in lca yu. ");
INSERT INTO cya_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Una a ya qui'an ti' ne' si'yana ncua yu sca nu cuityin' lo' cua' ñii nguila quiloo yu. Can' cha' m'ni ne' cha' yaan nten cula 'in yu, ");
INSERT INTO cya_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","lo' mñicha' ne' 'in: ¿Ta sñe' um lca yu re? ¿Ta cha' ñi si'yana cua' lca cuityin' yu xa mdiyaan yu chendyu? ¿Ña'an ta ncua nguila quiloo yu? ");
INSERT INTO cya_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nten cula 'in yu mxcuen 'in ne': Jlyo ti' hua si'yana sñe' hua lca yu, lo' jlyo ti' hua si'yana cua' lca cuityin' yu xa ngula yu, ");
INSERT INTO cya_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","una tsaña'an nguila quiloo yu, a ndyi'ya hua cunta lo' ñi a jlyo ti' hua ti ca nu msla quiloo yu, una cua' cula yu re, tca cuñicha' um 'in yu, lo' cui' yu quitsa' yu 'in um. ");
INSERT INTO cya_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ycui' jun cuaña'an si'yana nguitsen jun tloo ne' judio, si'yana cua' m'ni cuiya' ne' cha', cha' nde'en nu chcui' si'yana Jesús lca ñi nu mdo'o hui ca 'in Ndiose, cui' xaa culo ne' 'in can' se'en ndiyo' ti'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Can' cha' juin nten cula 'in yu: Cua' cula yu re, tca cuñicha' um 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Xiya' mxi'ya ne' 'in yu nu ncua cuityin' can' lo' juin ne' 'in yu: Tyaa xu'hue 'in Ndiose si'ya cha' re, huare' jlyo ti' hua si'yana yu cua lca yu nten qui'ya chendyu. ");
INSERT INTO cya_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Xacan' mxcuen yu can': A jlyo tin' cha' ta lca yu nten qui'ya chendyu, scati cha' nu jlyo tin' si'yana ncuan sca yu cuityin' lo' cua' ñii chcan' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Xiya' mñicha' ne' 'in yu: ¿Ña'an ta m'ni yu lo'o? ¿Ña'an ta msla yu quiloo? ");
INSERT INTO cya_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mxcuen yu 'in ne': Cua' nen lo'o um, una a n'ni cunta um cha' nu nchcuin'. ¿Ñi cha' ta nchca ti' um quitsan' 'in um xiya', ta na lo'o um ndyi'o tiquee um chcui cha'an um 'in yu? ");
INSERT INTO cya_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Xacan' ycuen tique' ne' lo'o yu lo' juin ne': Nu'huin lca nu ngui'ni cha'an 'in yu cua, una huare' ngui'ni cha'an hua cha' 'in Moisé. ");
INSERT INTO cya_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jlyo ti' hua si'yana Ndiose lca nu ycui' lo'o Moisé, una yu cua a jlyo ti' hua la mdo'o yu. ");
INSERT INTO cya_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Xacan' mxcuen yu: Nduhue 'a tin' cha' re, si'yana a jlyo ti' um la mdo'o yu, una cui' yu msla yu quiloon. ");
INSERT INTO cya_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cua' jlyo ti' na si'yana sca nten qui'ya chendyu a n'ni cunta Ndiose cha' nu njñan can', una sca nten nu n'ni tnu 'in ñi lo' nchca ja'an 'in ñi, can' nu n'ni cunta ñi cha' nu nchcui'. ");
INSERT INTO cya_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ñi siya' a nchca quine cha' ta nde'en nu cua' msla quiloo sca nu cua' lca cuityin' ti' xa ngula. ");
INSERT INTO cya_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Cha' cua na a mdo'o yu se'en nducua Ndiose, ñi sca cha' lo' a tca cu'ni yu. ");
INSERT INTO cya_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mxcuen ne' 'in yu: Nu'huin nu cua' lca nducua qui'ya chon' ti' xa ngula, ¿lo' cua' ñii ñan ti' culo'o 'in hua? Cui' xaa ngulo ne' 'in yu nde lyiya'. ");
INSERT INTO cya_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ynan Jesús cha' si'yana cua' ngulo ne' 'in yu nde lyiya', lo' xa nguija lyoo ñi 'in yu juin ñi: ¿Ta ndiya qui'an ti' 'in Sñe' Ndiose? ");
INSERT INTO cya_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mxcuen yu can': Quitsa' um 'ñan cha' ti ca lca can', lo' tsa qui'an tin' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Juin Jesús 'in yu: Cua' ndyu'hui lyoo 'in can', si'yana cui' ñi ta'a nchcui' cua' ñii. ");
INSERT INTO cya_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Juin yu 'in ñi: Ñi X'nan hua, ndiya qui'an tin' 'in um, xacan' m'ni tnu yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lo' juin Jesús: Nan' mdiyaan loo chendyu re si'yana cu'nin cuiyan' cha' 'in nten, ña'an ca si'yana nu a chcan' 'in, quila xaa quiloo, lo' nu chcan' 'in, nde quinu cuityin'. ");
INSERT INTO cya_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Xa ngune 'in ne' fariseo cha' nu ycui' Jesús, juin ne' 'in ñi: ¿Ta lo'o huare' cuityin' hua? ");
INSERT INTO cya_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Xacan' mxcuen Jesús 'in ne': Cha' cua na cuityin' um a nducui um qui'ya, una cua' ñii si'yana nchcui' um chcan' 'in um, can' cha' nducua qui'ya chon' um. ");
INSERT INTO cya_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nu cha' ñi s'ni cunen lo'o um, sca nu a nguiten nde tulo'o 'in slya', cui' ca nu ndyi'o cuaan nde tu'hua lo'o, can' nu nducun' lo' cunan. ");
INSERT INTO cya_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Una nu nguiten nde tulo'o, can' nu ntsu'hui cunta 'in slya' can'. ");
INSERT INTO cya_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yu nu ndon tulo'o can', cui' xaa nsla yu 'in na xa ndiyaa yu nu na'an seen slya' can', lo' slya' can' ne 'in 'in xa nchcui' yu, cunda scaa 'in ndlo'o naan yu 'in 'in, lo' ndyi'an lo'o yu 'in 'in se'en nan ycu 'in. ");
INSERT INTO cya_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Xa ndlyoo yu slya' 'in yu nchcua loo yu loo 'in, lo' nchcui ncha'an 'in 'in yu si'yana ndyu'hui lyoo 'in ña'an tyi'i nchcui' yu. ");
INSERT INTO cya_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Una a nchcui ncha'an 'in 'in nten nu a ndyu'hui lyoo 'in, cui' ca nu nde nxnan 'in si'yana a ndyu'hui lyoo 'in ña'an tyi'i nchcui' can'. ");
INSERT INTO cya_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nde cha' nu mdi'in tyaa Jesús lo'o ne', una a ngu'ya ne' cunta ñi cha' lca na. ");
INSERT INTO cya_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Xiya' mxitucui Jesús ycui' ñi: Nu cha' ñi s'ni cunen lo'o um, nan' lcan tulo'o se'en nguiten slya'. ");
INSERT INTO cya_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nchgaa nu yaan xa ti' lyijyi caan nan', lca can' yu nducun' lo' cunan, una slya' can' a m'ni cunta 'in cha' nu ycui' can'. ");
INSERT INTO cya_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nan' lcan tulo'o can', nu sten 'in na lo'o cunta 'ñan, can' nu tyi'o laa, tsa nan ycu, lo' ticui' can' quila xiya'. ");
INSERT INTO cya_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yu cunan ljyaan yu si'yana cujui yu, si'yana cujlyo yu lo' cu'ni yu cunan. Una nan' ljyaan si'yana caja chendyu 'in um, sca chendyu nu cha'an yu'hui um lo'o. ");
INSERT INTO cya_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nan' lcan sca nu tsu'hue ña'an seen slya', lo' nu tsu'hue ña'an seen slya' can' ndyaa cusya 'in si'ya 'in. ");
INSERT INTO cya_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Una yu nguso si'yana a lca yu x'nan 'in, xa ña'an yu ljyaan sca 'ni la, nde nxnan yu'hui yu lo' nxnu ti'in yu slya' can', lo' 'ni la can' n'ni lyi'o 'in 'in, lo' cua' la tucueen nda'an 'in xacan'. ");
INSERT INTO cya_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yu nguso can' nxnan yu si'yana nguso ti lca yu, can' cha' a nduhue ti' yu nxnu ti'in yu slya' can'. ");
INSERT INTO cya_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nan' lcan nu tsu'hue ña'an seen slya', ndyu'hui lyoon slya' 'ñan, lo' slya' can' ndyu'hui lyoo 'ñan, ");
INSERT INTO cya_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tsaña'an ndyu'hui lyoo Stina Ndiose 'ñan, lo' nan' ndyu'hui lyoon 'in ñi, nu hasta ndyaan cusya 'ñan si'ya 'in. ");
INSERT INTO cya_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","A cunta ndi'in xca ta slya' 'ñan nu a ntsu'hui ni' lyi'o re, lo'o can' ntsu'hui cha' quia 'yan, lo' cu'ni cunta cha' nu chcuin'. Sca ni' lyi'o ti chu'hui 'in nchgaa 'in, lo' scati nu ña'an seen 'in 'in. ");
INSERT INTO cya_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Can' cha' tsu'hue 'a ntsu'hui tiquee Stina Ndiose lo'on, si'yana hasta lo'o chendyu 'ñan ndyaan se'en nu tca chcuan 'in na xiya'. ");
INSERT INTO cya_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","A tucui nu tca chcuan chendyu 'ñan, cui' ca nu ticuiin' ndyaan 'in na. Ntsu'hui cha' cuiya' 'ñan tyaan 'in na, lo' ntsu'hui cha' cuiya' 'ñan chcuan 'in na xiya'. Nde cha' cuiya' nu mdaa Stin 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ne' judio can', ticui' ti ña'an a ncua 'a ca sca cha' ti 'in ne' si'ya cha' nu ycui' Jesús. ");
INSERT INTO cya_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Qui'an nu nchcui': Cui'in xa'an ntsu'hui 'in yu re, can' cha' ndiyo' yu. ¿Ñi cha' ndon nscan um cha' nu nchcui' yu? ");
INSERT INTO cya_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ntsu'hui xca nu nchcui': Una sca nu ntsu'hui cui'in xa'an 'in a nchcui' can' tsaña'an nchcui' yu re. ¿Ta tca 'in cui'in xa'an sla quiloo sca yu cuityin'? ");
INSERT INTO cya_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lja xacan' nchca ta'a 'in laa nu nducua quichen Jerusalén, lo' lca na tsaan nu ndyi'ya ti'in tlya'. ");
INSERT INTO cya_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús nxiton ñi ni' lyaa se'en nguia' tucui tulaa nu naan Salomón. ");
INSERT INTO cya_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Msu'hua lo'o ne' judio 'in ñi lo' juin ne': ¿Tsala ta xaa tyi'an lo'o hua cha' tucua ti' re? Cha' na cui' lca Cristo, siya' ti quitsa' la 'in hua. ");
INSERT INTO cya_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mxcuen Jesús 'in ne': Cua' nen lo'o um, lo' a ndiya qui'an ti' um 'ñan. Una ticuii' tñan nu ngui'nin lo'o cha' cuiya' 'in Stin, ndaa na suun tucui ca lcan. ");
INSERT INTO cya_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Una 'un a ndiya qui'an ti' um si'yana a lca um slya' 'ñan, cui' tsaña'an nu cua' ycuin' lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Una tsalca slya' 'ñan ne 'in cha' nu nchcuin', lo' ndyu'hui lyoon 'in 'in, lo' nchcui ncha'an 'in 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nan' ndaan chendyu nu a tsatii 'a 'in 'in, lo' a ntsu'hui cha' quinan' cusya 'in 'in, ñi a tucui nu tca culyoo 'in 'in tuyaan'. ");
INSERT INTO cya_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Stin, ñi nu mdyaa 'in 'in 'ñan, scati ñi ndon loo la ñi, lo' a tucui nu tca culyoo 'in 'in tuyaa' ñi. ");
INSERT INTO cya_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nan' lo'o Stina Ndiose, scati lca hua. ");
INSERT INTO cya_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Xiya' msñi ne' judio quee nu jyi'in ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Lo' juin Jesús 'in ne': Tsala qui'an tñan tsu'hue cua' m'nin tloo um lo'o cha' cuiya' 'in Stin. ¿Ti ña'an ta si'ya cha' can' nchca ti' um jyi'in um quee 'ñan? ");
INSERT INTO cya_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Xacan' mxcuen ne' judio 'in ñi: Si'i si'ya tñan tsu'hue can' jyi'in hua quee 'in, cui' ca nu si'yana nchcui' ca'an 'in Ndiose, nu'huin lca nten chendyu lo' nchcui' si'yana lca Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mxcuen Jesús 'in ne': ¿Ta a nguinu scua sca cha' loo lee 'in um: —Nan' cua' nen si'yana ndiose lca um—? ");
INSERT INTO cya_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cha' na Ndiose juin ñi si'yana ndiose lca nu mchcuan cunta cha' 'in ñi, (lo' jlyo ti' na si'yana cha' nu nguinu scua can' a tca cutsa ti'in na), ");
INSERT INTO cya_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿lo' ña'an ta ljuin um cha' 'in nu cua' ngulohui ca Stina Ndiose, lo' ngua'an tñan ñi 'in yaan loo chendyu re? Nchcui' um si'yana ycuin' ca'an 'in Ndiose xa nen: Sñe' Ndiose lcan. ");
INSERT INTO cya_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Cha' cua na si'i tñan 'in Stin ngui'nin, a na jo'o tsa qui'an ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Una cha' ngui'nin 'in na, siya' a tsa qui'an ti' um 'ñan, una tsa qui'an ti' um si'ya tñan nu ngui'nin, lo' ca cuiya' ti' um lo' tsa qui'an ti' um si'yana sca cha' ti 'ñan lo'o Stina Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Xiya' ncua ti' ne' quinu Jesús, una mdo'o ñi tuyaa' ne'. ");
INSERT INTO cya_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Xacan' xiya' nguiaa ñi xca tso' chco tlyu Jordan, se'en nu mducua tya yu Xuhua 'in nten ti' culoo. Can' nguinu ñi sca co' xaa. ");
INSERT INTO cya_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Qui'an 'a nten ndyi'an ne' se'en ndi'in ñi, lo' nchcui' ne': Cha' ñi si'yana yu Xuhua ñi sca cha' nu tnu lo' a m'ni yu, una nchgaa cha' nu ycui' yu cha' 'in ñi re, cha' ñi lca na. ");
INSERT INTO cya_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Qui'an 'a nten ya qui'an ti' 'in Jesús se'en can'. ");
INSERT INTO cya_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yato'o quichen Betania ncua ti'i sca yu naan Lázaro, cui' quichen tyi María lo'o Marta ta'a ngula yu. ");
INSERT INTO cya_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(María ta'a ngula yu Lázaro nu ncua ti'i can', lca nu msu'hua tyi'a xityi'i 'in Ñi X'nan na, lo' mxityi quiya' ñi lo'o quichan' que.) ");
INSERT INTO cya_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chcuaa jun cuna'an can' msu'hua suun 'in Jesús, lo' nchcui' jun: Ñi X'nan hua, yu ta'a tsu'hue ntsu'hui um, cua' ñii nscua yu ti'i yu. ");
INSERT INTO cya_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Xa ngune 'in Jesús cha' re, xacan' juin ñi: Si'i quicha ntsu'hui cha' cujui 'in yu ca lca na, cui' ca nu si'yana ca chcan' loo cha' cuiya' 'in Ndiose lo' caja nu cu'ni tnu 'in Sñe' ñi. ");
INSERT INTO cya_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Marta lo'o nu cuna'an ta'a, lo'o Lázaro lca jun ta'a tsu'hue Jesús. ");
INSERT INTO cya_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Xa ynan Jesús cha' si'yana yu can' ti'i yu, ti' nguinu la ñi chcua tsaan se'en can'. ");
INSERT INTO cya_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Xacan' juin ñi 'in yu ta'a nda'an ñi: Tsaa na xiya' se'en lca Judea. ");
INSERT INTO cya_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mxcuen yu ta'a nda'an ñi 'in ñi: Rabí, a tyun tsaan ncua ti' ne' judio jyi'in ne' quee 'in um, lo' cua' ñii nchca ti' um tsaa um xiya'. ");
INSERT INTO cya_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mxcuen Jesús 'in yu: ¿Ta si'i tichcua braa nchca sca tsaan? Tsalca nu nda'an cucha, a ntsu'hui cha' chcua quee quiya' can' si'yana nda'an loo xaa. ");
INSERT INTO cya_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Una nu nda'an tla, nchcua quee quiya' can' si'yana a nda'an loo xaa. ");
INSERT INTO cya_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Xa mdyi ycui' ñi cha' re, xiya' juin ñi 'in yu: Yu ta'a tsu'hue na Lázaro ngu'ya sla yu, una cua' ñii tsa xitucuin 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xacan' mxcuen yu ta'a nda'an ñi: Ñi X'nan hua, cha' na lja' ti yu, quila juesa 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús nchcui' ñi cha' re si'yana ngujui yu Lázaro, una yu ta'a nda'an ñi ñan ti' yu si'yana lja' ti yu. ");
INSERT INTO cya_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","La xacan' mtsa' la ca Jesús 'in yu: Yu Lázaro cua' ngujui yu, ");
INSERT INTO cya_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lo' si'ya um tsu'hue ntsu'hui tiqueen si'yana a ndlyun la cua, ña'an ca si'yana tsa qui'an ti' um 'ñan, cua' ñii tsaa na se'en su yu. ");
INSERT INTO cya_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Xacan' yu Toma, nu nchcui' ne' lo'o lca Dídimo, juin yu lo'o nchgaa la ña'an ta'a nda'an yu: Tsaa na, lo' tsatlyu caja na lo'o ñi la cua. ");
INSERT INTO cya_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Xa mdiyaa Jesús can' ynan ñi cha' si'yana cua' nguiaa jacua tsaan mtsi' yu Lázaro. ");
INSERT INTO cya_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Quichen Betania, cui' ti nguinu na se'en lca quichen Jerusalén, tsa ntsu'hui lyoo snan ti kilometro. ");
INSERT INTO cya_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Qui'an 'a ne' judio mdiyaa ne' se'en ndi'in Marta lo'o María, nu taa ne' cha' tnu tiquee 'in si'yana ngujui yu ta'a ngula. ");
INSERT INTO cya_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Xa ynan Marta cha' si'yana cua' ljyaan Jesús, mdo'o ya ycua 'in ñi, una María can' nguinu nde na'an. ");
INSERT INTO cya_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lo' juin Marta 'in Jesús: Ñi X'nan hua, cha' cua na 'un ndi'in um re, lo' a caja ta'a hua. ");
INSERT INTO cya_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Una jlyo tin' si'yana nchgaa cha' nu njñan um 'in Ndiose nxcuen ñi 'in um. ");
INSERT INTO cya_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Juin Jesús: Una ta'a ngula ntsu'hui cha' tyiqui'o. ");
INSERT INTO cya_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mxcuen Marta can' 'in ñi: Cua' jlyo tin' si'yana ntsu'hui cha' tyiqui'o, una la xa tsatii cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Xacan' juin Jesús 'in ne': Nan' lcan nu n'ni cha' ndyiqui'o nten, nan' lcan chendyu 'in ne', lo' nu ndiya qui'an ti' 'ñan, tyiqui'o can' siya' cua' ngujui. ");
INSERT INTO cya_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nchgaa nu lo'o lo' ndiya qui'an ti' 'ñan, a caja 'a can'. ¿Ta ndiya qui'an ti' cha' re? ");
INSERT INTO cya_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Lo' juin 'in ñi: Cha' ñi, Ñi X'nan hua, ndiya qui'an tin' si'yana lca um ñi nu lca Cristo, cui' Sñe' Ndiose nu mdiyaan loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Xa mdyi ycui' Marta cha' can', mxitucui nde na'an nguia ytsa' cunan ti 'in María ta'a ngula, lo' juin: Cua ndon ñi nu lca Bstro lo' nxi'ya ñi 'in tsaa. ");
INSERT INTO cya_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Xa ynan cha' can', cui' xaa mdo'o nguiaa se'en ndon ñi. ");
INSERT INTO cya_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Una Jesús a nchca sten ñi loo quichen, ti' ndon ñi se'en ya ycua Marta 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ne' judio nu mdiyaa se'en ndi'in María nu taa cha' tnu tiquee 'in, xa na'an ne' si'yana ndla ndsa mdo'o nguiaa, mducui ncha'an ne' 'in lo' nchcui' ne': Cui' la tucuaa nguia ynan cua' ñii. ");
INSERT INTO cya_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Xa mdiyaa María se'en ndon Jesús, cui' xaa mdyi'ya xtyin' tloo ñi xa na'an 'in ñi, lo' juin 'in ñi: Ñi X'nan hua, cha' cua na 'un ndi'in um re, lo' a caja ta'a hua. ");
INSERT INTO cya_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Xa na'an Jesús si'yana nguinan, a cunta nguinan ne' judio nu mdiya ncha'an 'in, lo'o ñi ngu'ya tu'hua tiquee ñi si'yana ti'i nga'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Lo' juin ñi: ¿La ta mtsi' um 'in yu? Juin ne' 'in ñi: Ñi X'nan hua, caan um nde re lo' ña'an um se'en mtsi'. ");
INSERT INTO cya_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Lo' ynan Jesús. ");
INSERT INTO cya_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nchcui' ne' judio: Ña'aan, tsala ti'i nga'an 'in ñi lo'o yu. ");
INSERT INTO cya_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ntsu'hui nu nchcui': Cha' yu re msla quiloo yu cuityin' can', ¿ñi cha' ta a m'ni yu cha' si'yana a caja yu Lázaro? ");
INSERT INTO cya_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Xiya' ngu'ya tu'hua tiquee Jesús, lo' mdiyaa ñi tucuaa can'. Se'en mtsi' ne' 'in yu lca na sca tuquee, lo' nchcun na lo'o sca quee tlyu ya'. ");
INSERT INTO cya_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Xacan' juin Jesús: Lyo ntan um quee cua. Marta ta'a ngula nu ngujui can' juin 'in ñi: Ñi X'nan hua, una cua' nxcua tyi'i si'yana cua' nguiaa jacua tsaan mtsi'. ");
INSERT INTO cya_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mxcuen Jesús 'in: ¿Ta si'i can' cha' nen lo'o cha' ndiya qui'an ti', lo' ña'an cha' cuiya' 'in Ndiose? ");
INSERT INTO cya_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Xacan' ngulo ntan ne' quee nu nchcun tucuaa se'en su yu ngujui can'. Mscuen Jesús tloo ñi nde cuaan, lo' juin ñi: Stina Ndiose, tyaan xu'hue 'in um si'yana ngune 'in um cha' nu ycuin' lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nan' jlyo tin' si'yana nchgaa xaa ne 'in um cha' nu nchcuin', una si'ya nten qui'an ndi'in re ycuin' cuaña'an, ña'an ca si'yana tsa qui'an ti' ne' cui' um ngua'an tñan um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Xa mdyi ycui' ñi cha' re ycui' cueen ñi: Lázaro, tyi'o nde lyiya'. ");
INSERT INTO cya_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yu nu ngujui can' mdyi'o yu ña'an ti' nguixen yu te' lo'o yaa' yu lo'o quiya' yu, a cunta lo'o tloo yu nguxen xca te'. Juin Jesús 'in ne': Xtin' um 'in yu lo' quiaa yu. ");
INSERT INTO cya_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Xacan' qui'an 'a ne' judio nu ta'a mdiyaa María, xa na'an ne' cha' nu m'ni Jesús ya qui'an ti' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Una ntsu'hui nu ya ytsa' 'in ne' fariseo ña'an m'ni Jesús. ");
INSERT INTO cya_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Xacan' nchgaa nu ndlo ca tñan ni' lyaa, tsatlyu lo'o ne' fariseo mxo' ti'in ta'a ne' si'yana cu'ni cuiya' ne' cha', lo' nchcui' ne': ¿Ña'an ta cu'ni na lo'o yu cua, si'yana qui'an 'a cha' tnu ngui'ni yu? ");
INSERT INTO cya_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Cha' a chcui ndijin na ña'an ngui'ni yu re, ña'aan quichen re tsa qui'an ti' 'in yu, chen nchcui caan ne' romano lo' cujlyo ne' se'en n'ni tnu na 'in Ndiose tsatlyu lo'o quichen re. ");
INSERT INTO cya_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Xacan' mdo'o ycui' sca yu naan Caifás, lo' cui' yjan can' lca yu nu ndlo ca tñan ni' lyaa, lo' juin yu: 'Un ñi sca cha' lo' a jlyo ti' um, ");
INSERT INTO cya_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ñi a ndyi'ya um cunta si'yana tsu'hue lati caja scati yu qui'yu si'ya quichen, lo' si'i nu jlyo ña'aan nten re. ");
INSERT INTO cya_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A ycui' yu cha' can' lo'o cha' tiyaa nu 'in ti yu, cui' ca nu si'yana yjan can' lca yu nu ndlo ca tñan ni' lyaa, can' cha' mxiycui' Ndiose 'in yu si'yana Jesús ntsu'hui cha' caja ñi tñan loo ña'aan quichen ne'. ");
INSERT INTO cya_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Si'i tsaloo ti si'yana caja ñi si'ya quichen, cui' ca nu si'yana xo' ti'in ta'a nchgaa sñe' Ndiose nu ndi'in sca chcui chendyu, lo' tsatlyu ca sca cha' ti 'in jun. ");
INSERT INTO cya_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ti' xacan' cua' yten tiquee ne' cujui ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Can' cha' Jesús a mda'an la 'a ñi lja ne' judio, cui' ca nu mdo'o tso' ñi lo' mdiyaa ñi sca quichen naan Efraín nu ndi'in cui' ti sca se'en ngutyi, can' nguinu ñi lo'o yu ta'a nda'an ñi. ");
INSERT INTO cya_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Cua' nchcui cuii' cha' ta'a Pascua nu n'ni tnu ne' judio, lo' qui'an 'a nten mdo'o ne' scasca quichen, lo' mdiyaa ne' Jerusalén nu suhui ne' 'in ne' lja nu ti' lyijyi tyisnan ta'a Pascua. ");
INSERT INTO cya_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nan ne' 'in Jesús, lo' scasca ne' ñicha' ta'a ne' se'en ndiyo' ti'in ne' ni' lyaa can': ¿Ña'an ta ljuin um, ta caan yu can' ta'a cua' ñii? ");
INSERT INTO cya_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nchgaa yu nu ndlo ca tñan ni' lyaa lo'o ne' fariseo, cua' mdi'in tyaa ne' sca cha' si'yana cha' ntsu'hui nu ña'an 'in Jesús cui' xaa quitsa' 'in ne' si'yana quinu ñi. ");
INSERT INTO cya_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ti' lyijyi cha xcua tsaan nu ntsu'hui cha' ca ta'a Pascua, yaa Jesús quichen Betania se'en ndi'in yu Lázaro, cui' yu nu ngujui can' lo' m'ni ñi cha' mdyiqui'o. ");
INSERT INTO cya_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Can' m'ni chu'hue jun na nu cu siin ñi. Marta msu'hua na loo msa, lo' Lázaro lca sca nu ta'a nducua ñi tu'hua msa can'. ");
INSERT INTO cya_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xacan' María msñi sca te'en tyi'a xityi'i nu tsa tlu'hue litro, nu chacui' nardo, lo' qui'an 'a ntsu'hui lyoo na, mslo tucua 'in na chon' quiya' Jesús, lo' mxityi 'in na lo'o quichan' que, mtsa'an yu'hui tyi'i na ña'an can'. ");
INSERT INTO cya_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sca yu ta'a nda'an ñi, cui' yu Juda Iscariote sñe' Simón, yu nu ntsu'hui cha' tyaa 'in ñi, juin 'in ñi: ");
INSERT INTO cya_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Ñi cha' ta a ncua quiya' tyi'a xityi'i re lo' caja tñi nu n'ni ne' canan snan ciento tsaan, lo' quitsa na 'in nu ti'i ña'an chendyu 'in? ");
INSERT INTO cya_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ycui' yu cha' re, una si'i si'yana ntsu'hui yuhue ti' yu 'in nu ti'i, cui' ca nu si'yana lca yu sca nu cunan, lo' ntsu'hui yu cunta tñi 'in yu ta'a nda'an ñi, lo' nxñi su'hua yaa' yu 'in na. ");
INSERT INTO cya_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Xacan' juin Jesús 'in yu: A chcui ndijin ña'an nu ngui'ni ne' re, na mxu'hua se'en ne' 'in na si'yana cui' tñan cu'ni na tsaan nu ntsu'hui cha' quitsin'. ");
INSERT INTO cya_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nu ti'i ña'an 'in, nchgaa xaa ndi'in can' lo'o um, una nan' si'i nchgaa xaa ña'an tloo um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Qui'an 'a ne' judio ynan ne' cha' si'yana can' ndi'in Jesús, cui' xaa mdiyaa ne', una si'i tsaloo ti si'ya Jesús, cui' ca nu si'yana nchca ti' ne' ña'an ne' 'in Lázaro, yu nu ngujui lo' mdyiqui'o. ");
INSERT INTO cya_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Una nchgaa yu nu ndlo ca tñan ni' lyaa 'in ne' judio, m'ni cuiya' ne' cha' si'yana lo'o yu Lázaro ntsu'hui cha' caja yu. ");
INSERT INTO cya_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Si'ya yu qui'an 'a ne' judio cua' mdo'o tso' ne' lo' ya qui'an ti' ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Xca tsaan can', nten qui'an nu cua' mdiyaa si'ya ta'a can', xa ynan ne' cha' si'yana cua' tiyaan Jesús quichen Jerusalén, ");
INSERT INTO cya_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","mdo'o ne' ya ycua ne' 'in ñi, lyi'ya ne' lca' yca quiñan, lo' nchcui' cueen ne': —¡Culo laa um 'in hua! Tlyu cha' tsu'hue ntsu'hui 'in ñi nu ljyaan lo'o cha' cuiya' 'in Ñi X'nan na—, ñi nu lca Ree 'in ne' Israel. ");
INSERT INTO cya_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Lo' jui sca burru cune' ti mducua Jesús tsaña'an nchcui' quityi 'in Ndiose: ");
INSERT INTO cya_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","—A cutsen um, 'un nu ndi'in quichen Jerusalén, nde cua' ljyaan ñi nu lca Ree 'in um, nducua ñi chon' sca burru cune' ti—. ");
INSERT INTO cya_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yu ta'a nda'an ñi, a ngu'ya yu cunta cha' re, la cua' ycuen Jesús nde ni' cuaan, xacan' nguia yu'hui ti' yu cha' nu m'ni ne' lo'o ñi si'yana nducua na loo quityi 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nten nu na'an tloo xa m'ni ñi cha' mdyiqui'o yu Lázaro tucuaa can', mdaa ne' suun cha' nu yato'o, ");
INSERT INTO cya_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","can' cha' qui'an nten ya ycua 'in ñi, si'yana cua' ynan ne' cha' ña'an cha' nu tnu m'ni ñi. ");
INSERT INTO cya_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Una ne' fariseo mdyisnan ycui' ne' scasca ne': Ña'an um jan ñi, ñi sca cha' lo' a tca cu'ni na si'yana ña'aan quichen ne' nducui ncha'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yato'o tucua snan ne' griego nu ya y'ni tnu ta'a can', ");
INSERT INTO cya_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","mdiyaa ne' se'en ndon yu Lpe, yu mdo'o quichen Betsaida se'en lyi'ya loo Galilea, lo' mjñan ne' cha' tsu'hue 'in yu: Nchca ti' hua ña'an hua 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Xacan' ya ytsa' yu Lpe can' 'in yu Ndre, lo' chcuaa yu ycui' yu lo'o Jesús. ");
INSERT INTO cya_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mxcuen Jesús 'in yu: Cua' mdiyaa braa scuen cuaan cha' 'in Yu Qui'yu nu Mdo'o nde ni' Cuaan. ");
INSERT INTO cya_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nu cha' ñi s'ni cunen lo'o um, sca mti trigo cha' a tyu na lyuu, ticui' ti loo scati na, una cha' tyu na lo' chcua na, qui'an la chca na. ");
INSERT INTO cya_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nu n'ni 'tnan chendyu 'in, quinan' can' tiyaa xaa, una nu a n'ni 'tnan 'in, can' nu qui'ni ca'an 'in lo'o chendyu nu a tsatii 'a. ");
INSERT INTO cya_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Cha' ntsu'hui nu nchca ti' cu'ni tñan 'ñan, chcui ncha'an 'ñan, lo' se'en nu nan' ti'in, can' tyi'in nguso 'ñan. Tsalca nu cu'ni tñan 'ñan, lo'o Stin chu'hui cunta 'in can'. ");
INSERT INTO cya_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Cua' ñii lu'un 'a ti' cusya 'ñan, ¿lo' ña'an ta cunen? ¿Ta na chcuin' lo'o Stin, a taa um cha' cuiya' tijin cha' re? ¿Ta si'i can' cha' mdiyaan loo chendyu re si'yana tijin nu ti'i? ");
INSERT INTO cya_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Stina Ndiose, cu'ni um cha' ca chcan' loo cha' cuiya' 'in um. Xacan' ngune ycui' sca nu ycui' la ni' cuaan: Cua' ncua chcan' loo cha' cuiya' 'ñan, lo' xiya' ntsu'hui cha' ca chcan' loo na. ");
INSERT INTO cya_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nten qui'an can' ngune 'in ne' xa jui nu ycui', lo' nchcui' ne' si'yana tyi'yu ngune. Ntsu'hui xca nu nchcui' si'yana sca angujle ycui' lyi'o 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mxcuen Jesús 'in ne': Si'i si'yan jui nu ycui' cua, cui' ca nu si'ya um ca lca na. ");
INSERT INTO cya_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cua' mdiyaa braa nu ntsu'hui cha' ca cuiya' cha' nu nchca loo chendyu re, lo' caja nu culo tso' 'in laxa'an nu ndlo tñan loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Xa ntsu'hui cha' xiton ne' 'ñan, tsatlyu xi'yan 'in nchgaa nten si'yana chcui ncha'an ne' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Lo'o cha' nu ycui' ñi re, ngulyo scua la ñi ña'an ntsu'hui cha' caja ñi. ");
INSERT INTO cya_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mxcuen nten can' 'in ñi: Huare' cua' ngune 'in hua ña'an nchcui' quityi 'in Ndiose si'yana ñi nu lca Cristo ntsu'hui cha' tyi'in ñi tsala xaa. ¿Ñi cha' ta nchcui' nu'huin, si'yana Yu Qui'yu nu Mdo'o nde ni' Cuaan ntsu'hui cha' cujui ne' 'in? ¿Ti nu ta lca Yu Qui'yu nu Mdo'o nde ni' Cuaan? ");
INSERT INTO cya_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Xacan' juin Jesús 'in ne': Tixi'i ti ti' ndu'hui xaa 'in um, can' cha' chcui ncha'an um 'in xaa can', ña'an tu' tsato'o tsati ntyin qui'ya tla yta se'en nda'an um, si'yana nu nda'an se'en tla yta, a jlyo ti' can' la nguiaa. ");
INSERT INTO cya_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Can' cha' lja nu ti' ndu'hui xaa 'in um tsa qui'an ti' um 'in xaa can', lo' cuaña'an ca um sca sñe' nu nda'an loo xaa. Tsare cha' nu ycui' Jesús, xacan' mdo'o ñi nguiaa ñi lo' yu'hui cutsi' ñi 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Siya' lyee la m'ni ñi cha' nu tnu tloo nten can', una a ya qui'an ti' ne' 'in ñi, ");
INSERT INTO cya_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ña'an ca si'yana tsato'o ña'an cha' nu mxiycui' Ndiose 'in yu Isaía xa juin yu: —Ñi X'nan hua, ¿ti nu ya qui'an ti' cha' nu ycui' hua? ¿Ti nu 'in ngulyo scua la um cha' cuiya' 'in um, 'un Ñi X'nan hua—? ");
INSERT INTO cya_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Can' cha' a ncua tsa qui'an ti' ne' 'in ñi, si'yana nde xca cha' nu ycui' Isaía: ");
INSERT INTO cya_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","—Yato'o mducun ne' quiloo ne' si'yana a ca chcan' 'in ne', m'ni tla ne' cusya 'in ne' si'yana a qui'ya ne' cha' tiyaa, lo' cha' cua na xitucui ne', nan' cu'nin chcan 'in ne'—. ");
INSERT INTO cya_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yu Isaía ycui' yu cha' re xa na'an tloo yu cha' cuiya' 'in ñi, lo' cui' cha' 'in ñi lca nu mda'an ycui' yu. ");
INSERT INTO cya_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ñi cuaña'an qui'an nten nu ndon loo lati 'in ne' judio ya qui'an ti' 'in ñi, una si'ya ne' fariseo a ngulo'o la ne' 'in ne', si'yana nguitsen ne' caja nu culo 'in ne' se'en nu n'ni tnu ne' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Lyee la nducua tloo ne' quinu tsu'hue tiquee nten lo'o ne', que 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ycui' cueen Jesús: Nu ndiya qui'an ti' 'ñan, si'i tsa 'ñan tin ndiya qui'an ti' can', cui' ca nu lo'o 'in ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nu cua' na'an 'ñan, cua' na'an 'in ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nan' lcan xaa nu cua' mdiyaan loo chendyu re, si'yana nchgaa nu tsa qui'an ti' 'ñan, a quinu can' se'en tla yta. ");
INSERT INTO cya_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nu ne 'in cha' nu nchcuin', lo' a nxu'hua se'en 'in na, si'in cu'ni cuiyan' cha' 'in can', si'yana a ljyan y'nin xñan bsya 'in nten, cui' ca nu si'yana culon laan 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nu nxcuan tloo 'ñan, lo' a nducuan xu'hue cha' nu nchcuin', ntsu'hui xca nu cu'ni cuiya' cha' 'in, cui' cha' nu cua' ycuin' lca nu cu'ni cuiya' cha' 'in, xa tsatii cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Si'yana a nchcuin' lo'o cunta 'ñan, cui' ca nu Stina Ndiose, ñi nu ngua'an tñan 'ñan, mdaa ñi cha' nu chcuin', lo'o cha' nu culo'on. ");
INSERT INTO cya_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jlyo tin' si'yana cha' nu ndlo ñi tñan 'in na lca na chendyu nu a tsatii 'a, can' cha' nchgaa cha' nu nchcuin' lca na cha' nu ndlo Stina Ndiose tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lja nu cua' tyisnan ta'a pascua, Jesús cua' jlyo ti' ñi si'yana cua' mdiyaa xaa nu ntsu'hui cha' tyi'o ñi loo chendyu re lo' quiaa ñi se'en nducua Stina Ndiose. Jesús lyee m'ni ñi 'tnan 'in nu ya qui'an ti' 'in ñi lja mdi'in ñi loo chendyu re, lo' cuaña'an m'ni ñi hasta mdyi'o ñi loo chendyu. ");
INSERT INTO cya_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nducua ycu siin jun, lo' yu Juda Iscariote, sñe' yu Simón, cua' mdi'in tyaa laxa'an cha' ni' cusya 'in yu si'yana tyaa yu 'in Jesús, ");
INSERT INTO cya_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","una Jesús cua' jlyo ti' ñi si'yana tuyaa' ñi mxnu Stina Ndiose nchgaa loo cha' cuiya', a cunta jlyo ti' ñi si'yana se'en nducua Ndiose mdo'o ñi, lo' ticui' can' ntsu'hui cha' quiaa ñi. ");
INSERT INTO cya_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mdyiton ñi se'en nducua ycu siin ñi, ngulyoo ñi te' tucuin nu lco' ñi, msñi ñi sca te' lo' mscan' ñi 'in na sii' ñi. ");
INSERT INTO cya_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Xacan' msu'hua ñi tyi'a sca ni' si'yu, lo' mdyisnan mjyi'an ñi quiya' yu ta'a nda'an ñi, mxityi ñi 'in na lo'o te' nchcan' sii' ñi. ");
INSERT INTO cya_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Xa mdiyaa ñi se'en nducua yu Simón Tyo, juin yu 'in ñi: Ñi X'nan hua, ¿ta 'un jyi'an um quiyan'? ");
INSERT INTO cya_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mxcuen Jesús 'in yu: Tsaña'an ngui'nin cua' ñii, a ndyi'ya cunta, una nde loo la ca jlyo ti' cha' re. ");
INSERT INTO cya_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yu Tyo can' juin yu 'in ñi: Una a ntsu'hui cha' jyi'an um quiyan' nan'. Mxcuen Jesús 'in yu: Cha' na a jyi'an quiya', si'i 'a sca cha' ti 'in na. ");
INSERT INTO cya_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Juin yu Simón Tyo can': Ñi X'nan hua, si'i tsa quiyan' tin jyi'an um xacan', cui' ca nu lo'o yaan' lo'o quen jyi'an um. ");
INSERT INTO cya_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Juin Jesús 'in yu: Sca nu cua' yta, a 'ni 'a cha' ti' cuta xiya' si'yana ña'aan cua' luhui, cui' lya tsa quiya' ti can' quiten na. Lo' 'un cua' luhui um, una si'i nchgaa um. ");
INSERT INTO cya_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Cua' jlyo ti' ñi ti ca nu ntsu'hui cha' tyaa 'in ñi, can' cha' juin ñi: Si'i nchgaa um luhui um. ");
INSERT INTO cya_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Xa mdyi jyi'an ñi quiya' jun, yco' ñi te' tucuin can' 'in ñi lo' xiya' yten tucua ñi tu'hua msa can', lo' juin ñi: ¿Ta ndyi'ya um cunta ña'an cha' nu m'nin lo'o um? ");
INSERT INTO cya_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'Un ndlo'o naan um 'ñan, Ñi Bstro, a cunta Ñi X'nan hua, lo' cha' ñi ña'an nu nchcui' um si'yana can' nu lcan. ");
INSERT INTO cya_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Cha' nan' lcan X'nan um lo'o Bstro 'in um, lo' mjyi'an quiya' um, cui' cuaña'an ntsu'hui cha' jyi'an um quiya' scasca ta'a um. ");
INSERT INTO cya_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nde cha' nu tyi'in tyaan lo'o um, si'yana cui' ña'an cha' nu m'nin cua' ñii, cuaña'an ntsu'hui cha' cu'ni um. ");
INSERT INTO cya_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nu cha' ñi cunen lo'o um, sca nguso a ndon loo la can' que 'in x'nan, cui' cuaña'an lo'o sca nu ndyi'an lo'o suun, a ndon loo la can' que 'in nu ngua'an tñan 'in. ");
INSERT INTO cya_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Cha' ndyi'ya um cunta cha' re, tsu'hue ca xu'hue um cha' tucua um tñan 'in na. ");
INSERT INTO cya_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Una a nchcuin' cha' nu 'in nchgaa um, si'yana cua' jlyo tin' ti' lyijyi nu cua' ngulohuin, una nde cha' nu nguinu scua loo quityi 'in Ndiose, lo' nchcui' na: —Nu nchcu jaslya sca se'en ti lo'on, yato'o mchca ta'a cusuun 'ñan—. ");
INSERT INTO cya_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ti' cua' ñii quitsan' 'in um lja nu ti' lyijyi tsato'o cha' re, lo' xa nu tsato'o na ca cuiya' ti' um si'yana nan' lcan ña'an cua' nen lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nu cha' ñi s'ni cunen lo'o um, nu cuan xu'hue 'in nu ntsu'hui cha' ca'an tñan, 'ñan nan' cuan xu'hue can', lo' nu cuan xu'hue 'ñan, cui' cuaña'an cuan xu'hue can' 'in nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ña'aan mdyi ycui' Jesús cha' can', ngu'ya sca tu'hua tiquee ñi, xacan' mtsa' la ñi 'in jun: Nu cha' ñi s'ni cunen lo'o um, sca um ntsu'hui cha' tyaa um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Xacan' scasca yu ta'a nda'an ñi mxina'an tloo ta'a yu, msu'hua yu cha' tiquee yu cha' ti ña'an nu 'in cha' nchcui' ñi. ");
INSERT INTO cya_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sca yu ta'a nda'an ñi, cui' yu nu lyee ndyu'hui cuiya' ti' ñi 'in, nducua yu cui' ti sii' Jesús, ");
INSERT INTO cya_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","lo' yu Simón Tyo can' m'ni yaa' 'in yu si'yana cuñicha' yu 'in Jesús cha' ti ca 'in cha' nchcui' ñi. ");
INSERT INTO cya_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yu can' cui' la ya tucua yu sii' Jesús, lo' juin yu 'in ñi: Ñi X'nan hua, ti ca 'in cha' nchcui' um? ");
INSERT INTO cya_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mxcuen Jesús: Yu nu taan jaslya nu cuchan' re 'in, can' nu lca yu. Xacan' mcha' ñi jaslya lo' mdaa ñi 'in na 'in yu Juda Iscariote, sñe' yu Simón. ");
INSERT INTO cya_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Xa mdyi ycu yu 'in na, yten Laxa'an ni' cusya 'in yu. Xacan' juin Jesús 'in yu: Cu'ni lya cha' nu ntsu'hui tiquee cu'ni. ");
INSERT INTO cya_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Una ñi sca yu ta'a nducua ñi a ngu'ya yu cunta ñi cha' ycui' ñi lo'o yu cuaña'an. ");
INSERT INTO cya_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Si'yana yu Juda nda'an lo'o yu cuijyin se'en ntsu'hui tñi, ntsu'hui nu msque' ti' si'yana ngulo Jesús tñan 'in yu tsa si'i yu na nu cunajo'o 'in jun lja ta'a can', uta taa yu sca lcuan 'in nu ti'i ña'an chendyu 'in. ");
INSERT INTO cya_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Xa mdyi ycu yu jaslya can', cui' xaa mdo'o yu nguiaa yu, lo' cua' ngu'ya tsu'hue tla xacan'. ");
INSERT INTO cya_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Xa cua' nguiaa yu, xacan' juin Jesús: Cua' mdiyaa braa scuen cuaan cha' 'ñan, Yu Qui'yu nu Mdo'o nde ni' Cuaan, cui' cuaña'an Ndiose scuen cuaan cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Cha' cuaña'an si'yan scuen cuaan cha' 'in Ndiose, cui' cuaña'an scuen cuaan Ndiose cha' 'ñan, lo' cua' nchcui cuii' cha' cu'ni ñi cha' re. ");
INSERT INTO cya_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sñen', ti' chin' 'a xaa ti' ndi'in lo'o um. Ntsu'hui cha' quia nan um 'ñan, una cui' ña'an cua' nen lo'o ne' judio, chcuin' lo'o um cua' ñii: Se'en nu ntsu'hui cha' tsa'an, 'un a tca tsaa um. ");
INSERT INTO cya_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nde cha' nu cui ti culon tñan 'in um, scasca um chu'hui cha' tsu'hue 'in um. Tsaña'an ntsu'hui cha' tsu'hue 'ñan lo'o um, cuaña'an chu'hui cha' tsu'hue 'in um scasca um. ");
INSERT INTO cya_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ndeña'an ca cuiya' ti' nten si'yana ngui'ni cha'an um 'ñan, si'yana ntsu'hui cha' tsu'hue 'in um scasca um lo'o ta'a um. ");
INSERT INTO cya_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yu Simón Tyo juin yu 'in ñi: Ñi X'nan hua, ¿la ta tsaa um? Mxcuen Jesús 'in yu: Se'en nu nan' tsa'an, a tca chcui ncha'an 'ñan, una nde loo la re ntsu'hui cha' chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Xacan' juin yu Tyo: Ñi X'nan hua, ¿ñi cha' a tca chcui ncha'an 'in um cua' ñii? Cua' m'nin tiqueen cajan si'ya um. ");
INSERT INTO cya_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mxcuen Jesús 'in yu: ¿Ta cua' m'ni tiquee caja si'yan? Nu cha' ñi s'ni cunen lo'o, lja nu ti' lyijyi xi'ya latyee, tsato'o snan ya' chcui' si'yana a ndyu'hui lyoo 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","A su'hua um cha' tiquee um lyee la, tsa qui'an ti' um 'in Ndiose, lo' tsa qui'an ti' um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","La na'an 'in Stin, qui'an 'a se'en lja. Cha' si'i cuaña'an lca na, nde cua' s'ni mtsan' 'in um. Una qui'an, lo' cu'nin chu'huen se'en ntsu'hui cha' tyi'in um. ");
INSERT INTO cya_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Quia y'ni chu'huen se'en ntsu'hui cha' tyi'in um, una yaan xiya', yan 'yan 'in um si'yana tsatlyu tyi'in na lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Cua' jlyo ti' um la qui'an, lo' jlyo ti' um tucueen can'. ");
INSERT INTO cya_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yu Toma juin yu 'in ñi: Ñi X'nan hua, a jlyo ti' hua la tsaa um, ¿ña'an ta ca jlyo ti' hua tucueen can'? ");
INSERT INTO cya_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Lo' juin Jesús 'in yu: Nan' lcan tucueen, lcan cha' nu ñi, lo' lcan chendyu. A tucui nu tca tiyaa se'en nducua Stina Ndiose, cha' si'i si'yan. ");
INSERT INTO cya_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Cha' 'un ndyu'hui lyoo um 'ñan, lo'o 'in Stin ndyu'hui lyoo um, lo' ti' cua' ñii cua' ndyu'hui lyoo um 'in ñi, lo' na'an um 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yu Lpe juin yu 'in ñi: Ñi X'nan hua, taa um ya' ña'an tloo hua 'in Stina Ndiose, lo' quinu tsu'hue tiquee hua. ");
INSERT INTO cya_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Mxcuen Jesús 'in yu: Lipe, tsala ña'an cua' s'ni ndi'in lo'o um, ¿ta a nchca chu'hui lyoo 'ñan? Nu cua' na'an tloo 'ñan, cua' na'an can' 'in Stina Ndiose. ¿Ñi cha' ta nchcui' si'yana nchca ti' ña'an tloo 'in Stina Ndiose? ");
INSERT INTO cya_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ta a ndiya qui'an ti' si'yana sca cha' ti 'ñan lo'o Stina Ndiose, lo' cuaña'an Stina Ndiose lo'on? Cha' nu nchcuin' lo'o um a nchcuin' 'in na lo'o cunta 'ñan, cui' ca nu Stina Ndiose, ñi nu ntsu'hui ni' cusya 'ñan, can' ñi nu ngui'ni tñan re. ");
INSERT INTO cya_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tsa qui'an ti' um cha' re: Sca cha' ti 'ñan lo'o Stina Ndiose, lo' cuaña'an Stina Ndiose lo'on. Cha' a ndiya qui'an ti' um, siya' cua' tsu'hue tñan nu ngui'nin tsa qui'an ti' um. ");
INSERT INTO cya_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nu cha' ñi s'ni cunen lo'o um: Nu ndiya qui'an ti' 'ñan, cui' tñan nu ngui'nin cu'ni can', hasta tlyu la tñan tca cu'ni can' si'yana qui'an se'en nducua Stina Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nchgaa cha' nu jñan um 'in Stina Ndiose lo'o cha' cuiya' 'ñan, cu'nin 'in na, ña'an ca si'yana scuen cuaan cha' 'in Stina Ndiose si'ya Sñe' ñi. ");
INSERT INTO cya_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Cha' nde'en la cha' jñan um lo'o cha' cuiya' 'ñan, nan' cu'nin 'in na. ");
INSERT INTO cya_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Cha' lyee lca tiquee um lo'on, xu'hua se'en um cha' nu chcuin'. ");
INSERT INTO cya_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nan' jñan 'in Stina Ndiose, lo' taa ñi xca nu taa cha' tnu tiquee 'in um nu tyi'in lo'o um tsala xaa, ");
INSERT INTO cya_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","cui' Espíritu nu ñi 'in Ndiose, una nten chendyu a tca cuan xu'hue 'in ñi si'yana a ña'an tloo ne' 'in ñi, ñi a ndyu'hui lyoo ne' 'in ñi. Una 'un cua' ndyu'hui lyoo um 'in ñi si'yana cua' ndi'in ñi lo'o um, lo' chu'hui ñi ni' cusya 'in um. ");
INSERT INTO cya_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","A ntsu'hui cha' xnun 'in um tsa ycui' ti um, si'yana ti' yaan xiya'. ");
INSERT INTO cya_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cua' nchcui cuii' cha' a ña'an tloo 'a nten chendyu 'ñan, una 'un ntsu'hui cha' ña'an tloo um 'ñan. Si'yana lo'on nan', can' cha' lo'o um tu'hui um chendyu. ");
INSERT INTO cya_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Xacan' ca cuiya' ti' um si'yana sca cha' ti 'ñan lo'o Stina Ndiose, lo' cuaña'an sca cha' ti 'in na lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nu ndon nscan cha' nu nchcuin' lo' nxu'hua se'en 'in na, can' nu cha' ñi ca lca tiquee lo'on, lo' nu lyee lca tiquee lo'on cuaña'an ca lca tiquee Stin lo'o can', a cunta lo'on nan' lyee lca tiqueen lo'o, lo' culo'on tloon 'in can'. ");
INSERT INTO cya_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yu Juda, (una si'i yu Iscariote) juin yu 'in ñi: Ñi X'nan hua, ¿ña'an ta culo'o tloo um 'in tsa huare' ti, lo' si'i 'in nchgaa tucui? ");
INSERT INTO cya_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mxcuen Jesús 'in yu: Nu lyee lca tiquee lo'on, xu'hua se'en can' cha' nu nchcuin', lo' cuaña'an Stin ntsu'hui cha' ca lca tiquee lo'o can', lo' caan hua se'en ndi'in can' lo' tsatlyu tyi'in hua lo'o. ");
INSERT INTO cya_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nu a lca tiquee lo'on, a xu'hua se'en can' cha' nu nchcuin'. Cha' nu nen lo'o um cua' ñii, si'i ychan' lca na, cui' ca nu ycha' Stina Ndiose, ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nchgaa cha' re nchcuin' lja nu ti' ndi'in lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Una xa caan ñi nu taa cha' tnu tiquee 'in um, cui' Espíritu nu Luhui 'in Ndiose, ñi nu ca'an tñan Stina Ndiose lo'o cha' cuiya' 'ñan, cui' ñi culo'o ñi 'in um nchgaa la ña'an cha', xu'hua ti' ñi 'in um nchgaa cha' nu cua' ycuin'. ");
INSERT INTO cya_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Loo cha' tsu'hue xnun 'in um, nan' cu'nin cha' tyi'in tsu'hue um, una si'i ña'an n'ni nten chendyu. A su'hua um cha' tiquee um lyee la, lo' ñi a cutsen um. ");
INSERT INTO cya_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Cua' ngune 'in um cha' nu ycuin': Qui'an, una yaan xiya'. Cha' lyee lca tiquee um lo'on, a s'ni tsu'hue ntsu'hui tiquee um xa nen si'yana qui'an se'en nducua Stina Ndiose, si'yana ndon loo la ñi que 'ñan nan'. ");
INSERT INTO cya_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Cua' msu'huan tiyaan 'in um lja nu ti' lyijyi tsato'o cha' re, ña'an ca si'yana tsa qui'an ti' um xa nu ca na. ");
INSERT INTO cya_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","A ndyijyi ña'an ti' chcuin' qui'an la cha' lo'o um, si'yana cua' ljyaan laxa'an nu ndlo tñan loo chendyu re, una a sca cha' cuiya' ntsu'hui 'in can' lo'on nan'. ");
INSERT INTO cya_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Una se'en nu ca cuiya' ti' nten tsala ña'an lca tiqueen lo'o Stina Ndiose, can' cha' nchgaa cha' nu ndlo ñi tñan ngui'nin 'in na. Tyiton um, lo' quiaa na. ");
INSERT INTO cya_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nan' lcan suun ti uva nu lo'o ca, lo' Stin lca nu ngui'ni tñan 'in na. ");
INSERT INTO cya_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nchgaa stan' nu lyi'ya loon nu a ndyi'yu mti 'in, nsi'yu ñi 'in na. Una nchgaa stan' nu ndyi'yu mti loo, nsuhui ñi 'in na si'yana lyee la cui'yu na. ");
INSERT INTO cya_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","'Un cua' nguinu luhui um si'ya cha' nu cua' ycuin' lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xñi ton um 'in um lo'o cha' 'ñan, lo' cuaña'an nan' lo'o um. Tsaña'an nguiaa cha' 'in stan' ti uva, a ndyi'yu na cha' quitan na se'en nducua suun na, cui' cuaña'an ndi'in cha' 'in um cha' a nsñi ton um 'in um lo'o cha' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nan' lcan suun ti uva lo' 'un lca um stan' na, nu nsñi ton 'in lo'o cha' 'ñan, lo' cuaña'an nan' lo'o can', lyee ndyi'yu mti loo, una cha' tyi'o tso' um siin' a sca na tca cu'ni um. ");
INSERT INTO cya_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu a nsñi ton 'in lo'o cha' 'ñan, nguiaa cha' 'in can' tsaña'an nguiaa cha' 'in stan' yca nu nsi'yu ne', nguityi ti'in na, ndiyo' ti'in na si'yana squin na. ");
INSERT INTO cya_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Cha' xñi ton um 'in um lo'o cha' 'ñan, lo' quinu yu'hui cha' nu nchcuin' ni' cusya 'in um, tca jñan um ña'an cha' nu nchca ti' um, lo' caja na 'in um. ");
INSERT INTO cya_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lo'o cha' re scuen cuaan cha' 'in Stin, xa culo xñan um 'in um lo' ca chcan' loo si'yana ngui'ni cha'an um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tsaña'an tsu'hue lca tiquee Stina Ndiose lo'on, cui' cuaña'an nan' lo'o um, tyon um loo cha' tsu'hue 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Cha' xu'hua se'en um cha' nu ndlon tñan, cui' cuaña'an ntsu'hui cha' tyon um loo cha' tsu'hue 'ñan, tsaña'an nan' nxu'hua se'en cha' nu ndlo Stin tñan 'ñan, lo' ndon loo cha' tsu'hue 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nde cha' nu nchcuin' lo'o um, si'yana tsatlyu ca tsu'hue chu'hui tiquee na, lo' cuaña'an nde lyee la ca tsu'hue chu'hui tiquee um. ");
INSERT INTO cya_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nde cha' nu ndlon tñan 'in um: Chu'hui cha' tsu'hue 'in um scasca um, tsaña'an nu lca tiqueen lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Si'yana a tucui nu tlyu la cha' tsu'hue ntsu'hui 'in que ña'an nu tyaa can' 'in si'ya ta'a tsu'hue. ");
INSERT INTO cya_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'Un lca um ta'a tsu'huen cha' ngui'ni um cha' nu ndlon tñan. ");
INSERT INTO cya_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","A n'nin cunta si'yana lca um sca nguso ti, si'yana sca nguso a jlyo ti' yu ñi na ngui'ni x'nan yu, cui' ca nu nchcuin' lo'o um si'yana lca um sca ta'a tsu'huen, si'yana cua' mtsan' 'in um nchgaa cha' nu cua' ycui' Stin lo'on. ");
INSERT INTO cya_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Si'i um ngulohui um 'ñan, cui' ca nu nan' ngulohuin 'in um, ña'an ca si'yana tsala xaa ca chcan' loo cha' tsu'hue 'ñan loo chendyu 'in um, lo' nchgaa cha' nu jñan um 'in Stina Ndiose lo'o cha' cuiya' 'ñan, taa ñi 'in na. ");
INSERT INTO cya_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nde cha' nu ndlon tñan 'in um si'yana chu'hui cha' tsu'hue 'in um scasca um. ");
INSERT INTO cya_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Cha' nten chendyu nxcuan tloo ne' 'in um, ca cuiya' ti' um si'yana culo nducua la 'ñan mscuan tloo ne'. ");
INSERT INTO cya_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Cha' cua na sca cha' ti 'in um lo'o nten chendyu, ca tsu'hue chu'hui tiquee ne' lo'o um, una 'un a nguiaa um tso' 'in ne' si'yana cua' ngulohuin 'in um, can' cha' nxcuan tloo ne' 'in um. ");
INSERT INTO cya_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Quia yu'hui ti' um cha' nu ycuin' lo'o um, sca nguso a ndon loo la can' que 'in x'nan. Cha' jui nu mna'an ti'i 'ñan, cui' cuaña'an caja nu ña'an ti'i ne' 'in um, lo' cha' jui nu mducua tñan cha' nu ycuin', cui' cuaña'an caja nu cu'ni cunta cha' nu chcui' um. ");
INSERT INTO cya_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Si'yan caja nu xcuan tloo 'in um, si'yana a ndyu'hui lyoo ne' 'in ñi nu ngua'an tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Cha' cua na a yaan loo chendyu re, lo' ñi a ycuin' cha' re lo'o ne', a sca qui'ya nducui ne'. Una cua' ñii a ndyijyi ña'an nchcui' ne' ta a nducui ne' qui'ya. ");
INSERT INTO cya_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nu nxcuan tloo 'ñan, lo'o 'in Stin nxcuan tloo can'. ");
INSERT INTO cya_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cha' cua na a m'nin scasca cha' tnu nu a nchca tucui cu'ni, a nducui ne' qui'ya, una cua' ñii cua' na'an tloo ne' cha' can', lo' ti' nxcuan tloo ne' 'ñan tsatlyu lo'o Stin. ");
INSERT INTO cya_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Una ngui'ni ne' cha' re si'yana tsato'o ña'an cha' nu cua' nguinu scua loo lee 'in ne', lo' nchcui' na: —Mscuan tloo ne' 'ñan siya' a nducuin qui'ya—. ");
INSERT INTO cya_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Una xa caan ñi nu ntsu'hui cha' taa cha' tnu tiquee 'in um, can' nu taa suun ña'an ndi'in cha' 'ñan, lo' nan' ca'an tñan 'in ñi lo'o cunta 'in Stina Ndiose, cui' Espíritu nu ñi nu tyi'o se'en nducua Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","A cunta lo'o um ntsu'hui cha' taa um suun ña'an ndi'in cha' re, si'yana tsatlyu mdi'in na lo'o um ti' culoo. ");
INSERT INTO cya_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nde cha' nu nchcuin' lo'o um si'yana a cu'ni na'an ti' um lo'o cha' nu ndiya qui'an ti' um. ");
INSERT INTO cya_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ntsu'hui cha' culo ne' 'in um se'en ndiyo' ti'in ne' judio. A cunta ntsu'hui cha' cujui ne' 'in um, lo' quiñan ti' can' si'yana tñan tsu'hue ngui'ni tloo Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cu'ni ne' cuaña'an si'yana a ndyu'hui lyoo ne' 'in Stina Ndiose, lo' ñi a ndyu'hui lyoo ne' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nchgaa cha' re nchcuin' lo'o um si'yana quia yu'hui ti' xa ntsu'hui cha' ca na. A ycuin' cha' re ti' culoo si'yana ti' x'ni ntsu'hui cha' tyi'in lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Una ntsu'hui cha' qui'an se'en nducua ñi nu ngua'an tñan 'ñan, una ñi sca um a ñicha' um 'ñan cha' la tsa'an. ");
INSERT INTO cya_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Cui' ca nu nde qui'ya xi'in 'in um si'yana mtsan' 'in um nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Una nchcuin' lo'o um cha' nu ñi, tyi'o la cunta 'in um cha' qui'an, si'yana ntsu'hui cha' ca'an tñan Ñi nu taa cha' tnu tiquee 'in um. Una cha' a qui'an, a caan ñi nu tyi'in lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Lo' xa caan ñi, cu'ni ñi cha' ca chcan' loo cha' tiyaa ngunan' 'in nten chendyu, si'yana ca cuiya' ti' ne' ñi na lca qui'ya, lo' ñi na lca cha' tsu'hue, a cunta si'yana Ndiose cu'ni ñi xñan bsya 'in nten. ");
INSERT INTO cya_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ca cuiya' ti' ne' ñi na lca qui'ya, si'yana a xlyaa ne' tsa qui'an ti' ne' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ca cuiya' ti' ne' ñi na lca cha' tsu'hue, si'yana cua' qui'an se'en nducua Stina Ndiose, lo' a ña'an 'a um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A cunta ca cuiya' ti' ne' si'yana Ndiose ntsu'hui cha' cu'ni ñi xñan bsya 'in nten, si'yana cua' msu'hua ñi yuhue' chon' laxa'an nu ndlo tñan 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Qui'an 'a cha' ti' ntsu'hui cha' chcuin' lo'o um, una cua' ñii a ta loo um quine 'in um cha' re. ");
INSERT INTO cya_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Una xa caan Espíritu nu ñi 'in Ndiose, cui' ñi culo'o ñi 'in um nchgaa la ña'an cha' nu ñi, si'yana a chcui' ñi lo'o cha' 'in ti ñi, cui' ca nu chcui' ñi nchgaa cha' nu ne 'in ñi, lo' quitsa' ñi 'in um cha' nu tsato'o. ");
INSERT INTO cya_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Cui' ñi scuen cuaan ñi cha' 'ñan si'yana ntsu'hui cha' culyo scua la ñi cha' 'ñan lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nan' sca cha' ti 'ñan lo'o Stina Ndiose, can' cha' nen lo'o um si'yana Espíritu ntsu'hui cha' culyo scua la cha' 'ñan lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sca co' xaa a ña'an 'a um 'ñan, una xca co' xaa ti' ña'an tloo um 'ñan, si'yana cua' qui'an se'en nducua Stina Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Xacan' tucua snan yu ta'a nda'an ñi mñicha' ta'a yu lo' nchcui' yu: ¿Ña'an ta ndyi'o cha' nu nchcui' ñi re, si'yana sca co' xaa a ña'an 'a na 'in ñi, lo' xca co' xaa ti' ña'an na 'in ñi, lo' quiaa ñi se'en nducua Stina Ndiose? ");
INSERT INTO cya_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ti' nchcui' la yu: ¿Ña'an ta ndyi'o cha' nu ycui' ñi cha' 'in xca co' xaa can'? A ndyi'ya na cunta cha' nu nchcui' ñi. ");
INSERT INTO cya_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Una Jesús ngu'ya ñi cunta si'yana nchca ti' yu cuñicha' yu 'in ñi si'ya cha' can', lo' juin ñi 'in yu: ¿Ta na ñicha' ta'a um si'ya cha' nu ycuin' re xa nen: Sca co' xaa a ña'an 'a um 'ñan, lo' xca co' xaa ti' ña'an um 'ñan? ");
INSERT INTO cya_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nu cha' ñi s'ni cunen lo'o um, ntsu'hui cha' qui'ya tu'hua tiquee um lo' cunan um, lo' nten chendyu ca tsu'hue chu'hui tiquee ne' xacan'. Siya' ti'i nga'an 'in um, una tiyaa xaa chca tsu'hue lca tiquee um. ");
INSERT INTO cya_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ña'an nchca ti' sca ne' cuna'an nu ndiyaan sñe' chendyu, tyisnan caan ti'i 'in ne' si'yana cua' mdiyaa braa 'in ne', una xa cua' mdijin yu'hui 'in ne', a quia yu'hui 'a ti' ne' ti'i nu mdijin ne' loo nu tsu'hue ntsu'hui tiquee ne' si'yana cuhui' qui'yu lca sñe' ne'. ");
INSERT INTO cya_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Cuaña'an ndi'in cha' 'in um cua' ñii, ti'i nga'an 'in um, una ntsu'hui cha' ña'an ta'a na lo'o um xiya', xacan' chca tsu'hue lca tiquee um, lo' a tucui 'a nu ti' cu'ni lyi'un cusya 'in um. ");
INSERT INTO cya_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Xa tiyaa tsaan can' a sca 'a cha' ti' cuñicha' um 'ñan. Nu cha' ñi s'ni cunen lo'o um, nchgaa cha' nu jñan um 'in Stina Ndiose lo'o cha' cuiya' 'ñan, cui' ñi xcuen ñi cha' can'. ");
INSERT INTO cya_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta cua' ñii lo' a nchca sca cha' jñan um lo'o cha' cuiya' 'ñan. Jñan um 'in na lo' caja na 'in um, ña'an ca si'yana nde lyee la ca tsu'hue chu'hui tiquee um. ");
INSERT INTO cya_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nan' a ycui' lan cha' re lo'o um, una tiyaa xaa a ntsu'hui 'a cha' ti' chcuin' lo'o um cuaña'an, cui' ca nu siya' ti culyo scua lan cha' 'in Stina Ndiose lo'o um. ");
INSERT INTO cya_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Xacan' ntsu'hui cha' jñan um 'in ñi lo'o cha' cuiya' 'ñan, ñi a cunen lo'o um si'yana ti' jñan 'in Stina Ndiose si'ya cha' 'in um, ");
INSERT INTO cya_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","si'yana ycui' ca Stina Ndiose tsu'hue lca tiquee ñi lo'o um, cui' si'yana lyee lca tiquee um lo'on, lo' ya qui'an ti' um si'yana mdo'on se'en nducua Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mdo'on se'en nducua Stina Ndiose, mdiyaan loo chendyu re, lo' cua' ñii xnun chendyu re, lo' xiya' qui'an se'en nducua ñi. ");
INSERT INTO cya_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Juin yu ta'a nda'an ñi: La ñii ycui' la ca um, lo' a ycui' nchcun 'a um lo'o hua. ");
INSERT INTO cya_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","La ñii ndyi'ya hua cunta si'yana jlyo ti' um nchgaa loo cha', lo' a 'ni cha' ti' caja nu quitsa' 'in um nde'en la cha', si'ya cha' re ndiya qui'an ti' hua si'yana mdo'o um se'en nducua Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mxcuen Jesús 'in yu: ¿Ta la cua' ñii ndiya qui'an ti' um 'ñan? ");
INSERT INTO cya_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tiyaa xaa, lo' cui' cua' ñii mdiyaa braa nu xnu ton um 'ñan xcan tin, cunda scaa um ntsu'hui cha' quiaa um se'en ndi'in um. Una si'i xcan tin quinun ton si'yana Stina Ndiose ndi'in ñi lo'on. ");
INSERT INTO cya_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nde cha' ycuin' lo'o um si'yana tsatlyu tyi'in tsu'hue na. Loo chendyu re ntsu'hui cha' tyijyin um scasca loo cha', una cu'ni tnu tiquee um si'yana nan' cua' m'nin canan cha' nu nchca loo chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Xa mdyi ycui' Jesús cha' can' mscuen ñi tloo ñi nde cuaan, lo' juin ñi: Ndiose, 'un lca um Stin, cua' mdiyaa braa scuen cuaan um cha' 'in Sñe' um, ña'an ca si'yana lo'o Sñe' um scuen cuaan 'in um. ");
INSERT INTO cya_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Si'yana cua' mdaa um cha' cuiya' 'ñan culon tñan 'in nchgaa nten, si'yana taan chendyu nu a tsatii 'a 'in tsalca nu cua' mdyaa um cunta 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nde chendyu nu a tsatii 'a: Si'yana chu'hui lyoo ne' 'in um, 'un ñi nu lca ycui' ca Ndiose, lo' chu'hui lyoo ne' 'in Jesucristo, ñi nu ngua'an tñan um. ");
INSERT INTO cya_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nan' m'nin tnun 'in um loo chendyu re, lo' cua' m'nin tyiin tñan nu mdaa um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","'Un ñi nu lca Stin, cu'ni um cha' scuen cuaan cha' 'ñan la se'en nducua um, tsaña'an nguiaa cha' 'ñan ti' culoo xa ti' lyijyi tsaa' chendyu re. ");
INSERT INTO cya_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Cua' ngulyo scua lan cha' 'in um lo'o tsalca nu mdyaa um cunta 'ñan, cui' nu culo nducua la ndi'in cunta 'in um, lo' cua' ñii mdyaa um cunta 'in can' 'ñan, lo' mxu'hua se'en jun ycha' um. ");
INSERT INTO cya_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ncua cuiya' ti' jun si'yana nchgaa cha' nu mdaa um 'ñan mdo'o na se'en nducua um, ");
INSERT INTO cya_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","si'yana cua' ycuin' lo'o jun nchgaa cha' nu mdaa um 'ñan, lo' ncuan xu'hue jun 'in na, jlyo tsu'hue ti' jun si'yana mdo'on se'en nducua um, lo' ya qui'an ti' jun si'yana cui' um ngua'an tñan um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Njñan 'in um si'ya cha' 'in jun, lo' si'i si'ya ña'an tucui ti, cui' ca nu si'ya cha' 'in jun nu cua' mdyaa um cunta 'ñan, si'yana cunta 'in um ndi'in jun. ");
INSERT INTO cya_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nchgaa nu ntsu'hui tuyaan', ticui' tuyaa' um ntsu'hui can', lo' nchgaa nu ntsu'hui tuyaa' um, ticui' cuaña'an ntsu'hui can' tuyaan', lo' nchca chcan' loo cha' cuiya' 'ñan loo chendyu 'in jun. ");
INSERT INTO cya_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tixi'i ti ndi'in loo chendyu re, una ti' quinu la jun, lo' nan' qui'an se'en nducua um. Ndiose, 'un ñi nu lca Stin, ñi nu luhui lati, lo'o cha' cuiya' 'in um xñi um cunta 'in nchgaa nu cua' mdaa um ntsu'hui tuyaan', si'yana ca sca cha' ti 'in jun tsaña'an sca cha' ti 'in nare'. ");
INSERT INTO cya_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lja mdi'in lo'o jun, tsu'hue 'a yu'huin cunta 'in jun lo'o cha' cuiya' 'in um, jun nu cua' mdaa um ntsu'hui yaan', msñin cunta 'in jun, lo' ñi sca jun lo' a ngunan' jun, cui' ca sca yu nu ntsu'hui ca cha' quinan', si'yana tsato'o ña'an cha' nu cua' nguinu scua loo quityi 'in um. ");
INSERT INTO cya_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Una cua' ñii qui'an se'en nducua um, lo' chcuin' cha' re lja nu ti' ndi'in loo chendyu re, si'yana lyee la ca tsu'hue chu'hui tiquee jun lo'on. ");
INSERT INTO cya_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Cua' ycuin' lo'o jun nchgaa cha' nu mdaa um 'ñan, una nten chendyu mscuan tloo 'in jun si'yana a nchcua ta'a cha' 'in jun lo'o cha' tiyaa ngunan' 'in ne', tsaña'an nu a nchcua ta'a cha' 'ñan lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A njñan 'in um si'yana culyoo um 'in jun loo chendyu re, cui' ca nu xñi um cunta si'yana a sten cha' ngunan' tiquee jun. ");
INSERT INTO cya_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A nchcua ta'a cha' 'in jun lo'o cha' tiyaa ngunan' nu nchca loo chendyu re, tsaña'an nu a nchcua ta'a cha' 'ñan lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cu'ni um cha' si'yana quinu luhui cusya 'in jun lo'o cha' nu ñi, cha' nu nchcui' um lca na cha' nu ñi. ");
INSERT INTO cya_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tsaña'an ngua'an tñan um 'ñan loo chendyu re, cuaña'an ngua'an tñan 'in jun cu'ni jun tñan 'in um. ");
INSERT INTO cya_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Si'ya jun, ndyaan 'ñan 'in um, si'yana lo'o jun quinu luhui cusya 'in jun si'ya cha' nu ñi 'in um. ");
INSERT INTO cya_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Una si'i tsaloo ti cha' 'in jun njñan 'in um, cui' ca nu si'ya nchgaa nu ntsu'hui cha' tsa qui'an ti' 'ñan xa quine 'in cha' nu chcui' jun, ");
INSERT INTO cya_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","si'yana tsatlyu ca sca cha' ti 'in nchgaa jun, tsaña'an sca cha' ti 'in na, 'un nu lca Stin, cui' cuaña'an tsatlyu ca sca cha' ti 'in jun lo'o na. Xacan' ca cuiya' ti' nten si'yana 'un ngua'an tñan um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tsaña'an cha' cuiya' mdaa um 'ñan, cuaña'an cha' cuiya' mdaan 'in jun, si'yana ca sca cha' ti 'in jun tsaña'an sca cha' ti 'in nare'. ");
INSERT INTO cya_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nan' sca cha' ti 'ñan lo'o jun tsaña'an sca cha' ti 'ñan lo'o um, ña'an ca si'yana ca sca cha' ti 'in jun nu cha' ñi ca, xacan' ca cuiya' ti' nten si'yana 'un ngua'an tñan um 'ñan, si'yana lyee lca tiquee um lo'on, lo' cuaña'an lca tiquee um lo'o jun. ");
INSERT INTO cya_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","'Un ñi nu lca Stin, nchca tin' si'yana tsalca jun nu cua' mxnu um tuyaan', sca se'en ti tyi'in lo'o jun, si'yana ña'an jun cha' cuiya' nu mdaa um 'ñan, tsaña'an ncua lca tiquee um lo'on xa ti' lyijyi tsaa' chendyu. ");
INSERT INTO cya_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'Un ñi nu lca Stin, nu ngui'ni tñan tsu'hue, a nchca chu'hui lyoo nten chendyu 'in um, una nan' cua' ndyu'hui lyoon 'in um, lo' jlyo ti' jun re si'yana 'un ngua'an tñan um 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Cua' ngulyo scua lan cha' 'in um lo'o jun, lo' ti' tsa quiñan cu'nin cha' re, si'yana tsaña'an lyee lca tiquee um lo'on, cuaña'an quii ti' jun, lo' tsatlyu ca sca cha' ti 'ñan lo'o jun. ");
INSERT INTO cya_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Xa mdyi ycui' Jesús cha' re, mdo'o ñi nguiaa ñi lo'o yu ta'a nda'an ñi xca tso' tuti nu naan Cedrón, can' yten yu'hui jun sca se'en nducua yca olivo. ");
INSERT INTO cya_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yu Juda, yu nu ntsu'hui cha' tyaa 'in ñi, ndyu'hui lyoo yu se'en can', si'yana tyun ya' nguio' ti'in Jesús lo'o yu ta'a nda'an ñi can'. ");
INSERT INTO cya_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mdiya lo'o yu Juda tsa ta yu sindatu, lo'o xca ta yu silyiya cunta 'in ne' fariseo lo'o yu nu ndlo ca tñan ni' lyaa. Lyi'ya ne' quii', a cunta lo'o quii' ndiquin, lo'o spada. ");
INSERT INTO cya_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Una Jesús cua' jlyo ti' ñi tsala cha' nu ntsu'hui cha' tyijyin ñi, can' cha' nde ya ycua ñi 'in ne', lo' juin ñi: ¿Tucui ca 'in nda'an nan um? ");
INSERT INTO cya_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lo' mxcuen ne' 'in ñi: 'In Jesús Nazaret. Juin ñi 'in ne': Nan' lcan. Lo'o yu Juda ta'a nda'an ne' can', yu nu ndyaa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Xa juin Jesús: Nan' lcan, cui' xaa mda'an chon' ne' lo' mdlyu ti'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Xiya' mñicha' ñi 'in ne': ¿Tucui ca 'in nda'an nan um? Lo' juin ne': Cui' 'in Jesús Nazaret. ");
INSERT INTO cya_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mxcuen Jesús 'in ne': Cua' nen lo'o um si'yana nan' lcan. Cha' na nda'an nan um 'ñan, tyaa um ya' quiaa yu ta'a nda'an re. ");
INSERT INTO cya_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Juin ñi cuaña'an si'yana tsato'o ña'an cha' nu cua' ycui' ñi xa juin ñi: Ñi sca nu mdaa um 'ñan, lo' a ngunan'. ");
INSERT INTO cya_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Xacan' yu Simón Tyo ngulyoo yu spada nu nda'an lo'o yu, lo' yjui yuhua' yu sca nguso 'in yu nu ndlo ca tñan ni' lyaa, msi'yu yu nscan tso' cueen 'in yu, lo' naan yu Malco. ");
INSERT INTO cya_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Xacan' juin Jesús 'in yu Tyo: Xu'hua se'en spada 'in ni' tyi na. Cha' Stina Ndiose cua' juin ñi tijin nu ti'i re, ¿ñi cha' a tijin 'in na? ");
INSERT INTO cya_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Xacan' yu sindatu lo'o x'nan yu, tsatlyu lo'o xca ta silyiya 'in ne' judio, msñi ne' 'in Jesús lo' mscan' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ya lo'o ne' 'in ñi tloo Anás culo nducua la, si'yana can' nu lca sti lyaa Caifás, yu nu ndlo ca tñan ni' lyaa yjan can'. ");
INSERT INTO cya_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yu Caifás can' lca yu nu msu'hua tiquee ne' judio, xa juin yu si'yana tsu'hue lati cha' caja scati yu qui'yu tñan loo ña'aan quichen ne'. ");
INSERT INTO cya_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yu Simón Tyo can' mducui ncha'an yu 'in Jesús, a cunta lo'o xca yu ta'a nda'an ñi ta'a nguiaa yu, yu re ndyu'hui lyoo tsu'hue yu 'in yu nu ndlo ca tñan ni' lyaa, tsatlyu yten yu lo'o Jesús tuna'an lyiya' se'en ndi'in nu ndlo tñan can'. ");
INSERT INTO cya_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Una yu Tyo nguinu ton yu nde tuna'an lyiya'. Xacan' yu ta'a nda'an ñi, cui' yu nu cua' ndyu'hui lyoo 'in yu nu ndlo ca tñan can', nguia ycui' yu lo'o ne' cuna'an nu ntsu'hui cuan tuna'an can', lo' m'ni yu cha' yten yu Tyo se'en can'. ");
INSERT INTO cya_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Xacan' ne' cuna'an nu ntsu'hui cunta tuna'an can' juin ne' 'in yu Tyo: ¿Ta si'i lo'o nu'huin lca ta'a nda'an yu qui'yu cua? Mxcuen yu Tyo can': A lo'on. ");
INSERT INTO cya_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tucua snan yu nguso lo'o yu silyiya can' mxiqui'o yu quii' si'yana tlya', can' ndon yu nguitson ti' yu, a cunta lo'o yu Tyo ndon can'. ");
INSERT INTO cya_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yu nu ndlo ca tñan ni' lyaa, mñicha' yu 'in Jesús ña'an nguiaa cha' 'in ñi lo'o cha' nu ndlo'o ñi, a cunta cha' 'in yu ta'a nda'an ñi. ");
INSERT INTO cya_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Mxcuen Jesús 'in yu: Tloo nten qui'an mda'an ycuin', lo' ngulo'on 'in ne' se'en ndiyo' ti'in ne', uta ni' lyaa 'in ne' judio, lo' ñi sca cha' a msu'hua cutsin' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ñi cha' 'ñan ñicha' um? Cuñicha' um 'in nu ngune 'in cha' nu ycuin', can' nu jlyo ti' nchgaa cha' re. ");
INSERT INTO cya_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ña'aan mdyi ycui' ñi cha' re, sca yu silyiya nu ndon cui' ti sii' ñi mjyi'in yaa' tloo ñi, lo' juin yu 'in ñi: ¿Ta cuaña'an ntsu'hui cha' xcuen 'in ñi nu ndlo ca tñan ni' lyaa 'in na? ");
INSERT INTO cya_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mxcuen Jesús 'in yu: Cha' si'i ña'an ycuin', quitsa' um 'ñan cha' ñi cha' lca na, lo' cha' ycuin' cha' nu ñi, ¿ñi cha' ta mjyi'in um 'ñan? ");
INSERT INTO cya_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Xacan' ña'an nchcan' Jesús ngua'an tñan Anás 'in ñi la se'en ndi'in Caifás, yu nu ndlo ca tñan ni' lyaa. ");
INSERT INTO cya_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lja nu ti' ndon yu Tyo nguitson ti' yu, mñicha' ne' 'in yu: ¿Ta si'i lo'o nu'huin lca ta'a nda'an yu cua? A msti ti' yu quitsa' yu 'in ne', lo' juin yu: A lo'on. ");
INSERT INTO cya_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Can' nguilyu sca yu nguso 'in yu nu ndlo ca tñan, cui' yu nu ti' nchca ta'a yu nu msi'yu yu Tyo can' nscan, lo' juin yu 'in: ¿Ta si'i cui' na'an 'in lja yca olivo lo'o yu cua? ");
INSERT INTO cya_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Xiya' mxcuen yu Tyo lo' juin yu si'yana a lo'o yu. Cui' xaa can' msi'ya sca latyee. ");
INSERT INTO cya_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Xacan' mdo'o ne' se'en ndi'in Caifás, lo' ya lo'o ne' 'in Jesús se'en nducua na'an tñan 'in gubierno, cua' qui'ya ti xaa, una ne' judio a mslyaa ne' sten ne' ña'an can' si'yana a ncua ti' ne' tyi'o ngunan' cha' 'in ne' lo'o cha' nu cua' ntsu'hui 'in ne', si'yana ntsu'hui cha' cu siin ne' ta'a pascua can'. ");
INSERT INTO cya_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Can' cha' mdo'o yu Pilato mñicha' yu 'in ne': ¿Ñi qui'ya ta ljyan su'hua um 'in yu re? ");
INSERT INTO cya_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mxcuen ne' 'in yu: Cha' cua na a lca yu sca yu nducun', ñi a can lo'o hua 'in yu tloo um. ");
INSERT INTO cya_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Xacan' juin yu Pilato: Quia lo'o um 'in yu, cui' um cu'ni cuiya' um cha' 'in yu tsaña'an nu nchcui' lee 'in um. Una ne' judio can' mxcuen ne' 'in yu: Huare' a ntsu'hui cha' cuiya' 'in hua cujui hua sca nten. ");
INSERT INTO cya_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ycui' ne' cuaña'an si'yana tsato'o tsaña'an nu juin Jesús ña'an ntsu'hui cha' caja ñi. ");
INSERT INTO cya_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Xacan' yten yu Pilato ña'an tñan xiya', lo' mxi'ya yu 'in Jesús lo' mñicha' yu 'in ñi: ¿Ta cui' lca Ree 'in ne' judio? ");
INSERT INTO cya_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Mxcuen Jesús 'in yu: ¿Ta cha' 'in ti 'in um nchcui' um cha' re, ta na xca tucui mtsa' 'in um ña'an ndi'in cha' 'ñan? ");
INSERT INTO cya_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Lo' juin yu Pilato: ¿Ta ñan ti' lcan ne' judio? Nten ta'a quichen tyi, lo'o ne' nu ndlo tñan ni' lyaa, can' nu mdyaa cunta 'in tuyaan'. ¿Ñi qui'ya ta m'ni? ");
INSERT INTO cya_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mxcuen Jesús 'in yu: Si'i loo chendyu re mdo'o cha' cuiya' 'ñan. Cha' cua na ndlon tñan loo chendyu re, nchgaa nu ta'a nda'an tyi'o cha' 'ñan lo' a quinun tuyaa' ne' judio. Una cha' cuiya' nu nda'an lo'on, si'i re mdo'o na. ");
INSERT INTO cya_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Xacan' juin yu Pilato: ¿Ta cui' lca ree xacan'? Mxcuen Jesús: 'Un nchcui' um si'yana lcan ree. Cui' can' cha' mdiyaan loo chendyu re si'yana chcuin' cha' nu ñi. Nchgaa nten nu n'ni cunta cha' nu ñi ne 'in ne' cha' nu nchcuin'. ");
INSERT INTO cya_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mxcuen yu Pilato 'in ñi: ¿Ñi na lca cha' nu ñi? Ña'aan mdyi ycui' yu cha' can' xiya' mdyi'o yu nde lyiya' se'en ndi'in ne' judio, lo' juin yu 'in ne': Ñi sca qui'ya, lo' a nducui yu re. ");
INSERT INTO cya_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Una 'un cua' ntsu'hui sca cha' 'in um xa nchca ta'a pascua, njñan um cha' ndlyaa sca preso. ¿Ta nchca ti' um culaan 'in yu nu lca Ree 'in ne' judio? ");
INSERT INTO cya_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Xacan' tsatlyu nchcui' cueen ne': A culaa um 'in yu cua, lyaa um 'in yu Barrabás. Lo' yu Barrabás can' lca yu sca yu cunan. ");
INSERT INTO cya_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Xacan' mchcuan yu Pilato cunta 'in Jesús lo' ngulo yu tñan si'yana qui'ni ñi. ");
INSERT INTO cya_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yu sindatu can' mtñan yu sca sni' quiche', mdi'in tyaa yu 'in na que ñi, lo' mxico' yu sca te' cuaa 'in ñi, ");
INSERT INTO cya_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","lo' nchcui' yu: Tlyu cha' cuiya' 'in Ree 'in ne' judio. A cunta njyi'in yaa' yu tloo ñi. ");
INSERT INTO cya_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Xiya' mdyi'o yu Pilato ña'an tñan can', lo' juin yu 'in ne' judio: Ña'an jan ñi, nde ndon yu re lo' ca cuiya' ti' um si'yana ñi sca qui'ya lo' a nducui yu. ");
INSERT INTO cya_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Xacan' mdo'o lo'o yu 'in Jesús, nducua sca sni' quiche' que ñi, lo' lco' ñi sca te' cuaa. Lo' juin yu Pilato: Nde ndon yu re. ");
INSERT INTO cya_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nchgaa yu nu ndlo tñan ni' lyaa tsatlyu lo'o yu silyiya nu ntsu'hui cuan cha' 'in laa, xa na'an ne' 'in Jesús mdyisnan ycui' cueen ne': Jyi'in ca'an um 'in yu loo cusi, jyi'in ca'an um 'in yu loo cusi. Lo' juin yu Pilato 'in ne': Cui' um tsa lo'o um 'in yu lo' jyi'in ca'an um 'in yu loo cusi, si'yana cunta nu 'ñan nan' a sca qui'ya nducui yu. ");
INSERT INTO cya_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mxcuen ne' judio 'in yu: Huare' ntsu'hui sca lee 'in hua, lo' ndlo qui'ya na 'in yu, si'yana juin yu lca yu ycui' ca Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Xa ngune 'in yu Pilato cha' can' lyee la ytsen yu. ");
INSERT INTO cya_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xiya' yten yu ña'an tñan can' lo' juin yu 'in Jesús: ¿La ta quichen mdo'o? Una Jesús a mxcuen ñi 'in yu. ");
INSERT INTO cya_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Xacan' juin yu Pilato 'in ñi: ¿Ñi cha' ta a nxcuen 'ñan? ¿Ta a jlyo ti' si'yana ntsu'hui cha' cuiya' 'ñan jyi'in ca'an 'in loo cusi, lo' ntsu'hui cha' cuiya' 'ñan culaan 'in? ");
INSERT INTO cya_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mxcuen Jesús 'in yu: A sca na tca cu'ni um lo'on cha' si'i nde ni' cuaan mdo'o cha' cuiya' 'in um. Can' cha' tlyu lati qui'ya nducui nu mdyaa 'ñan tuyaa' um. ");
INSERT INTO cya_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ti' xacan' yu Pilato ngunan yu ña'an nu culaa yu 'in Jesús, una nde lyee lati nchcui' cueen ne' judio: Cha' culaa um 'in yu re, a lca um ta'a tsu'hue yu César, si'yana sca yu nu ngui'ni 'in lca ree, ta'a cusuun César lca can'. ");
INSERT INTO cya_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Xa ngune 'in yu Pilato cha' can', cui' xaa ngulyoo yu 'in Jesús nde lyiya', lo' yten tucua yu se'en n'ni cuiya' yu cha', sca se'en ndlo'o naan ne' lo'o cha' hebreo, Gabata, cha' re nchca ti' chcui', se'en ncua tsu'hue lyuu. ");
INSERT INTO cya_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tsa ntsu'hui ndyi'ya cuaan, cui' tsaan nu cu siin ne' judio si'ya ta'a pascua can', lo' juin yu Pilato 'in ne': Nde ndon yu nu lca Ree 'in um. ");
INSERT INTO cya_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nde lyee la ycui' cueen ne': Lyoo um 'in yu nde lyiya', lyoo um 'in yu nde lyiya', jyi'in ca'an um 'in yu loo cusi. Lo' juin yu Pilato can': ¿Ta nchca ti' um jyi'in ca'an 'in Ree 'in um loo cusi? Xacan' nchgaa yu nu ndlo tñan ni' lyaa mxcuen yu: A ntsu'hui 'a xca ree 'in hua, cui' ca nu scati yu César. ");
INSERT INTO cya_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Cuaña'an yato'o mdyaa yu Pilato cunta 'in Jesús tuyaa' ne' si'yana cha'an ñi loo cusi, mchcuan ne' cunta 'in ñi lo' ya lo'o ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Cui' ñi lyi'ya ñi cusi se'en ntsu'hui cha' cha'an ñi, lo' mdiyaa ñi sca se'en nu nchcui' ne' lo'o lca Que Jyi'o, lo'o cha' hebreo ndyi'o cha' re Gólgota. ");
INSERT INTO cya_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Can' mjyi'in ca'an ne' 'in ñi loo cusi, a cunta lo'o tucua yu nu ta'a ngua'an ñi, scaa yu scaa tso', lo' Jesús ngua'an ñi tlu'hue la. ");
INSERT INTO cya_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Cua' lca ngua'an yu Pilato sca cha' nu cha'an que cusi can', lo' nchcui' na: Nde nu lca Jesús Nazaret, Ree 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Qui'an 'a ne' judio ycui' ne' cha' re, si'yana se'en nu ngua'an Jesús loo cusi can', cui' ti tu'hua quichen lca na. Ngua'an na lo'o cha' hebreo, cha' griego, lo'o cha' latín. ");
INSERT INTO cya_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tsalca ne' nu ndlo ca tñan ni' lyaa 'in ne' judio, juin ne' 'in yu Pilato: A ca'an um 'in na si'yana lca yu Ree 'in ne' judio, tsu'hue lati cha'an na tsaña'an nu juin yu: Nan' lcan Ree 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mxcuen yu Pilato 'in ne': Ña'an cha' nu cua' ngua'an, cui' cuaña'an quinu na. ");
INSERT INTO cya_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Xa cua' mjyi'in ca'an yu sindatu can' 'in Jesús loo cusi, msñi yu ste' ñi lo' ngulo yu 'in na jacua yu'hue, cunda scaa na 'in scaa yu. A cunta msñi yu te' tucuin 'in ñi nu mchcuan sca co' ti. ");
INSERT INTO cya_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Xacan' mdyisnan ycui' scasca yu: A sta na 'in na, tsu'hue lati culo na xu'hue na lo'o na, cha' ti ña'an nu qui'ni ca'an na 'in. Cuaña'an m'ni yu, si'yana tsato'o cha' nu nguinu scua loo quityi 'in Ndiose se'en nchcui': —Ticui' lja can' mtsa yu sten', ngulo yu xu'hue yu lo'o na—. Cui' cuaña'an m'ni yu sindatu can'. ");
INSERT INTO cya_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Cui' ti se'en nga'an Jesús loo cusi ndon jyi'an ñi, lo'o ta'a ngula jyi'an ñi, lo'o María cuilyi'o Cleofas, a cunta ndon María Magdalena. ");
INSERT INTO cya_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús na'an ñi ndon jyi'an ñi, a cunta cui' ti can' ndon sca yu ta'a nda'an ñi, cui' yu nu ndyu'hui cuiya' ti' ñi 'in can', lo' juin ñi 'in jyi'an ñi: Cua ndon nu ca sñe' um. ");
INSERT INTO cya_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Xacan' juin ñi 'in yu ta'a nda'an ñi can': Cua ndon nu ca jyi'an. Ti' xacan' mchcuan yu can' cunta 'in jyi'an ñi la se'en ndi'in yu. ");
INSERT INTO cya_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ngujlyo ti' Jesús si'yana cua' ya tucua nchgaa cha' nu ntsu'hui cha' tyijyin ñi, xacan' juin ñi: Nguityi 'a tin'. Juin ñi cuaña'an si'yana tsato'o cha' nu nguinu scua loo quityi 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Can' ndon sca te'en mtsa'an ntsu'hui tyi'a vinagre. Yu sindatu can' mcha' yu tyi'a can' 'in sca te', lo' mdi'in tyaa yu 'in na loo sca yca, lo' mjyi'in ca'an yu 'in na tu'hua Jesús. ");
INSERT INTO cya_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Xa cua' yi'o ñi tyi'a can' juin ñi: Cua' ya tucua nchgaa cha'. Cui' xaa mdyi'ya tucui ñi que ñi, lo' mdyaa ñi cusya 'in ñi tuyaa' Ndiose. ");
INSERT INTO cya_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Si'yana lca na tsaan nu nsiin ta'a pascua, a ncua ti' ne' judio si'yana quinu ca'an nu ngujui can' loo cusi tsaan nu nxitñan' ne', (a cunta lja xacan' ya tucua tsaan nu lyee la n'ni tnu ne' ta'a can'), can' cha' ya ycui' ne' lo'o yu Pilato cha' taa yu cha' cuiya' cutsa tijyan quiya' nu nga'an loo cusi can', lo' tyi'ya ne' 'in. ");
INSERT INTO cya_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mdiyaa yu sindatu can' lo' mcha yu tijyan quiya' yu nu ta'a nga'an Jesús, cui' cuaña'an mcha yu quiya' nu nga'an xca tso' can'. ");
INSERT INTO cya_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Una xa na'an yu si'yana cua' ngujui Jesús, a mcha 'a yu quiya' ñi. ");
INSERT INTO cya_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Xacan' sca yu sindatu can' yjo' yu sca chcuan cha sii' ñi, cui' ña'an lcaa nguilo tne ñi nu mxitiya' lo'o tyi'a. ");
INSERT INTO cya_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yu nu na'an cha' re ndaa yu suun cha' nu yato'o, lo' nchcui' yu cha' nu ñi, a cunta jlyo ti' yu si'yana suun nu ndaa yu lca na cha' nu ñi, ña'an ca si'yana lo'o um tca tsa qui'an ti' um cha' re. ");
INSERT INTO cya_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cha' re yato'o na si'yana tsa tucua cha' nu nchcui' quityi 'in Ndiose: —Ñi sca tijyan ñi lo' a cutsa na—. ");
INSERT INTO cya_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ndeña'an nchcui' xca se'en loo quityi 'in Ndiose: —Chcua quiloo ne' 'in nu yjo' ne' chcuan cha sii'—. ");
INSERT INTO cya_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chon' nde'en can' sca yu naan See nu mdo'o Arimatea, cui' sca yu ya qui'an ti' 'in Jesús, una a ngulo'o la yu 'in yu si'yana ntsen yu tloo ne' judio, mjñan yu cha' cuiya' 'in Pilato si'yana cui'ya yu 'in Jesús, lo' mdaa yu cha' cuiya'. Xacan' mdiyaa yu se'en nga'an ñi lo' ngu'ya yu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","A cunta mdiyaa yu Nicodemo, cui' yu nu ya ycui' lo'o Jesús sca tla, lo' lyi'ya yu sca se'en ntsu'hui tyi'a xityi'i nu naan mirra nu mxitiyaa' lo'o áloes, lo' ti'in na cla tyi kilo. ");
INSERT INTO cya_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Xacan' nguxen yu sca te' 'in Jesús, lo' msu'hua yu tyi'a xityi'i 'in ñi tsaña'an ntsu'hui cha' 'in ne' judio xa ntsi' ne' 'in sca nu ngujui. ");
INSERT INTO cya_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Se'en ngua'an ñi loo cusi can', cui' ti nguinu sca se'en nducua yca, can' cua' lca nguiaa' sca cuaa nu a nchca tucui chu'hui. ");
INSERT INTO cya_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Can' mtsi' yu 'in Jesús si'yana cui' se'en ti su cuaa can', a cunta cua' tyisnan xitñan' ne' judio. ");
INSERT INTO cya_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Culoo tsaan 'in snan can', ti' nducui lyoo xa mdo'o María Magdalena nguiaa tucuaa can', lo' na'an si'yana cua' mdo'o ntan quee nu nchcun na. ");
INSERT INTO cya_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Cui' xaa mdo'o msnan, nguia ytsa' 'in yu Simón Tyo lo'o xca yu ta'a mda'an Jesús, cui' yu nu ndyu'hui cuiya' ti' ñi 'in can', lo' juin 'in yu: Cua' ngulyoo ne' 'in Ñi X'nan na se'en mtsi' ñi, lo' a jlyo ti' hua la nguia lo'o ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Cui' xaa mdo'o yu Tyo lo'o xca yu ta'a mda'an ñi, nguiaa yu tucuaa can'. ");
INSERT INTO cya_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tsatlyu mdo'o chcuaa yu msnan yu, una xca yu can' lyee la msnan yu que 'in yu Tyo, culo nducua la yu mdiyaa yu tucuaa can'. ");
INSERT INTO cya_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mducui ndlyu yu lo' msti quiloo yu ni' cuaa can', lo' na'an yu si'yana xtyi te' nu nguxen ti ñi su can', una a yten yu ni' can'. ");
INSERT INTO cya_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Cui' ña'an cua' lo'o yu Tyo can' mdiyaa yu, lo' yten yu ni' cuaa can', na'an yu si'yana xtyi te' nu nguxen ti ñi su can', ");
INSERT INTO cya_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","a cunta na'an yu si'yana te' nu nguxen tloo ñi a su 'a na sca se'en ti lo'o te' nu nguxen ca ñi, cui' ca nu mtsa tu'hua na nscua na xca se'en. ");
INSERT INTO cya_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Xacan' yten xca yu ta'a mda'an ñi can', cui' yu nu mdiyaa culo nducua la can', na'an yu cha' can' lo' ya qui'an ti' yu, ");
INSERT INTO cya_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","una a nchca qui'ya tsu'hue yu cunta tsaña'an nu nchcui' quityi 'in Ndiose ña'an ntsu'hui cha' tyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Xacan' mxitucui yu ta'a mda'an ñi can' nde se'en ndi'in yu. ");
INSERT INTO cya_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Una María ti' nguinu ton tucuaa can' lo' nguinan, lja xacan' mducui ndlyu lo' msti quiloo ni' cuaa can', ");
INSERT INTO cya_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","na'an nducua tucua angujle nu lco' te' mten. Sca can' nducua nde que se'en msti Jesús, lo' xca nde quiya' can'. ");
INSERT INTO cya_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lo' juin angujle can': ¿Ñi cha' ta nguinan? Mxcuen María: Si'yana ngulyoo ne' 'in Ñi X'nan, lo' a jlyo tin' la nde nguia lo'o ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ña'aan mdyi ycui' cha' can' mxiton nde chon' lo' na'an ndon Jesús, una a ngujlyo ti' si'yana Jesús lca nu ndon can'. ");
INSERT INTO cya_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Lo' juin Jesús 'in: ¿Ñi cha' ta nguinan? ¿Tucui ca 'in nda'an nan? María msque' ti' cha' ta yu nu ntsu'hui cunta se'en nducua yca can' lca nu ndon can', lo' juin xacan': Cha' cui' um ngulyoo um 'in ñi, quitsa' um 'ñan la ya lo'o um 'in ñi, lo' nan' quia 'yan 'in ñi. ");
INSERT INTO cya_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Lo' juin Jesús 'in: ¡María! Cui' xaa mxiton lo' juin 'in ñi, ¡Raboni! (Cha' re nchca ti' na nchcui' na, ñi nu lca Bstro). ");
INSERT INTO cya_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Juin Jesús 'in: A cula' 'ñan si'yana ti' lyijyi qui'an se'en nducua Stin, quia ytsa' 'in nchgaa ta'an si'yana cua' qui'an se'en nducua Stin, cui' ñi nu lca Sti um, Ndiose 'ñan, lo' Ndiose 'in um. ");
INSERT INTO cya_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Xacan' mdo'o María Magdalena nguia ytsa' 'in yu ta'a mda'an Jesús si'yana na'an tloo 'in Ñi X'nan na, lo' mtsa' nchgaa cha' nu ycui' ñi lo'o. ");
INSERT INTO cya_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Xa ngu'ya tla, cui' tsaan culoo 'in snan can', lo' se'en nguio' ti'in yu ta'a mda'an ñi, mchcun tsu'hue tuna'an can' si'yana ntsen yu 'in ne' judio, lo' tlu'hue la se'en ndi'in yu yten Jesús, lo' juin ñi 'in yu: A su'hua um cha' nduhue ti' tiquee um. ");
INSERT INTO cya_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Xa mdyi ycui' ñi cha' re, ngulo'o ñi yaa' ñi 'in jun lo'o jyan sii' ñi. Yu ta'a mda'an ñi tsu'hue ntsu'hui tiquee yu si'yana na'an yu 'in Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Xiya' ycui' Jesús lo'o yu: A su'hua um cha' nduhue ti' tiquee um, tsaña'an nu ngua'an tñan Stina Ndiose 'ñan, cuaña'an ca'an tñan 'in um. ");
INSERT INTO cya_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Xa ycui' ñi cha' re ngula' su'hua ñi tloo yu lo' juin ñi: Quinu yu'hui Espíritu nu Luhui 'in Ndiose ni' cusya 'in um. ");
INSERT INTO cya_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Cha' 'un cu'ni um cha' tlyu ti' 'in nde'en la tucui lo'o qui'ya ngui'ni, a nducui 'a can' qui'ya, lo' cha' ti ña'an nu a cu'ni um cha' tlyu ti' 'in, cui' ña'an ti nducui can' qui'ya. ");
INSERT INTO cya_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Una yu Toma, cui' ta yu nu tichcua can', yu nu nchcui' ne' lo'o lca Dídimo, a lo'o yu nguio' ti'in yu xa yaa Jesús. ");
INSERT INTO cya_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nchgaa la ña'an ta'a mda'an ñi juin yu 'in Toma: Cua' na'an tloo hua 'in Ñi X'nan na. Mxcuen yu xacan': Cha' a ña'an lo' a cojo' yaan' se'en yten clau yaa' ñi, lo' cha' a cojo' yaan' jyan sii' ñi, a tsa qui'an tin'. ");
INSERT INTO cya_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mda'a snu' tsaan nguio' ti'in yu ta'a mda'an ñi ña'an can', cua' lo'o yu Toma xacan'. Mchcun tsu'hue tuna'an can' xa yten Jesús tlu'hue la se'en ndi'in yu, lo' juin ñi: A su'hua um cha' nduhue ti' tiquee um. ");
INSERT INTO cya_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lo' juin ñi 'in yu Toma can': Cojo' yaa' re lo' cu'ni quii yaan', tyaa yaa' lo' cojo' yaa' jyan siin', lo' a cu'ni tucua ti', cui' ca nu tsa qui'an ti'. ");
INSERT INTO cya_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Xacan' mxcuen yu Toma 'in ñi: 'Un lca um X'nan lo' lca um Ndiose 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Lo' juin Jesús 'in yu: Si'yana na'an tloo 'ñan, Toma, can' cha' ya qui'an ti', una tsu'hue ca xu'hue nu ya qui'an ti' lo' a na'an 'ñan. ¿Ñi cha' ngua'an yu Xuhua quityi re? ");
INSERT INTO cya_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ti' m'ni la Jesús scasca cha' nu tnu tloo na'an yu ta'a mda'an ñi, una a ngua'an scua na loo quityi re. ");
INSERT INTO cya_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Una cha' re ngua'an scua na si'yana tsa qui'an ti' um si'yana Jesús lca ñi nu lca Cristo, Sñe' Ndiose, lo' loo nu tsa qui'an ti' um 'in ñi caja chendyu nu a tsatii 'a 'in um. ");
INSERT INTO cya_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chon' nde'en can' xiya' ngulo'o tloo Jesús 'in yu ta'a mda'an ñi tu'hua tiyo' Tiberias can', lo' ndeña'an ngulo'o tloo ñi 'in yu: ");
INSERT INTO cya_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tsatlyu nguio' ti'in yu Simón Tyo can' lo'o Toma nu nchcui' ne' lo'o lca Dídimo, lo'o Natanael nu mdo'o Caná se'en lyi'ya loo Galilea, lo'o chcuaa sñe' Zebedeo, a cunta lo'o chcua yu nu ta'a mda'an Jesús nguio' ti'in yu can'. ");
INSERT INTO cya_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Lo' juin yu Simón Tyo can': Tsa'an nan' cuta cula. Mxcuen nchgaa la ña'an yu can': Lo'o huare' tsaa hua. Xacan' yten yu sca ni' yca na'an lo' mdo'o yu nguiaa yu, una ñi sca cula lo' a msñi yu sca chcui tla can'. ");
INSERT INTO cya_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Xa nde cua' qui'ya xaa, tu'hua ysin can' ndon Jesús, una yu ta'a mda'an ñi a yu'hui lyoo yu si'yana Jesús ndon can'. ");
INSERT INTO cya_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ycui' ñi lo'o yu: Sñen', ¿ñi na nda'an lo'o um cu na? Mxcuen yu 'in ñi: A sca na. ");
INSERT INTO cya_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Xacan' juin ñi 'in yu: Nguun um quitan 'in um nde tso' cueen se'en nducui yca na'an cua, lo' quinu 'in 'in um. Xacan' nguun yu 'in na, lo' hasta ñi a ncua 'a ti' lyoo yu 'in na si'yana mtsa'an na ntsu'hui cula. ");
INSERT INTO cya_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Xacan' xca yu ta'a mda'an ñi, cui' yu nu ndyu'hui cuiya' ti' ñi 'in can', juin yu 'in yu Tyo: Cui' Ñi X'nan na ndon cua. Lo' ña'aan ngune 'in yu Simón Tyo si'yana Ñi X'nan na lca ñi, cui' xaa yco' yu ste' yu (si'yana cua' ngulo yu 'in na), lo' mdo'o cuaan yu loo tyi'a can'. ");
INSERT INTO cya_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nchgaa la ña'an yu nguia lo'o yu yca na'an can' la tu'hua ysin, nducuan qui yu quitan se'en ntsu'hui cula can' si'yana a tijyo' lyee nguinu tu'hua ysin can', tsa ntsu'hui lyoo sca ciento metro. ");
INSERT INTO cya_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Xa mdyi'o ti'in yu tu'hua ysin can', na'an yu ndi'in quii' nscuhui', can' nscua sca cula ndique' 'in, a cunta lo'o jaslya. ");
INSERT INTO cya_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Lo' juin Jesús 'in yu: Quian lo'o um tucua snan cula nu tca msñi um cua. ");
INSERT INTO cya_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Cui' xaa ycuen yu Simón Tyo can' ni' yca na'an lo' ngulyoo yu quitan can' la tu'hua ysin, mtsa'an na ntsu'hui chacui' cula nu tnu, lo' ndiyaa 'in sca ciento ntsu'hui tu'hua tyi ntsu'hui snan 'in. Tsacan' 'in ntsu'hui 'in ni' quitan can' una a mda' na. ");
INSERT INTO cya_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Juin Jesús 'in yu: Quiaan um lo' ca xu'hue um na re. Ñi sca yu ta'a mda'an ñi lo' a msti ti' yu cuñicha' yu 'in ñi cha' ti ca lca ñi, ngu'ya yu cunta si'yana Ñi X'nan na lca ñi. ");
INSERT INTO cya_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Xacan' msñi Jesús jaslya can' lo' mdaa ñi 'in na 'in yu, cui' cuaña'an m'ni ñi lo'o cula can'. ");
INSERT INTO cya_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nde nu cua' nchca snan ya' ngulo'o tloo Jesús 'in yu ta'a mda'an ñi, ti' xa mdyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Xa mdyi ycu jun juin Jesús 'in yu Simón Tyo can': Simón, sñe' Jonás, ¿ta lyee la lca tiquee lo'on que 'in cha' re? Mxcuen yu 'in ñi: Cui' cuaña'an, Ñi X'nan hua, 'un jlyo ti' um si'yana lyee lca tiqueen lo'o um. Juin ñi 'in yu xacan': Tsu'hue ti ña'an seen slya' cune' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mxitucui ñi ycui' ñi lo'o yu nu cua' nchca tucua ya': Simón, sñe' Jonás, ¿ta lyee lca tiquee lo'on? Mxcuen yu Tyo: Cui' cuaña'an Ñi X'nan hua, 'un jlyo ti' um si'yana lyee lca tiqueen lo'o um. Lo' juin ñi 'in yu: Tsu'hue ti ña'an seen slya' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Xiya' ycui' ñi lo'o yu nu cua' nchca snan ya': Simón, sñe' Jonás, ¿ta lyee lca tiquee lo'on? Yu Tyo can' ngulu'un ti' yu si'yana snan ya' ticui' ti loo cha' ycui' ñi: ¿Ta lyee lca tiquee lo'on? Yu Tyo can' mxcuen yu 'in ñi: Ñi X'nan hua, 'un jlyo ti' um nchgaa loo cha', jlyo ti' um si'yana lyee lca tiqueen lo'o um. Juin Jesús 'in yu: Tsu'hue ti ña'an seen slya' 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nu cha' ñi s'ni cunen lo'o: Xa ncua sca yu tsa suhue ti, mscan' sii' lo' yaa se'en nu ncua ti'. Una xa nu cua' cula ntsu'hui cha' xñii ne' scun, lo' xca tucui nu scan' 'in, tsa lo'o can' 'in se'en nu a nchca ti' tsaa. ");
INSERT INTO cya_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nde cha' ycui' Jesús si'yana qui'ya yu Tyo can' cunta ña'an ntsu'hui cha' cujui ne' 'in yu, lo' taa yu loo Ndiose si'ya cha' can'. Ti' juin la ñi 'in yu: Chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Xacan' mxina'an yu Tyo can' nde chon' yu, lo' na'an yu ljyaan xca yu ta'a mda'an ñi, cui' yu nu lyee ndyu'hui cuiya' ti' ñi 'in can', yu nu ngua'an nan' sii' ñi xa ycu siin jun lo' mñicha' 'in ñi: Ñi X'nan hua, ¿tucui ca nu ntsu'hui cha' tyaa 'in um? ");
INSERT INTO cya_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Lo' juin yu Tyo can' 'in Jesús xa na'an 'in yu: Ñi X'nan hua, ¿ña'an ta tsato'o 'in yu cua? ");
INSERT INTO cya_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mxcuen Jesús 'in yu: Cha' nan' nchca tin' si'yana ti' ndi'in yu xa yaan xiya', ¿ñi cha' ntsu'hui yuhue ti' cha' re? Tsaloo chcui ncha'an ti 'ñan. ");
INSERT INTO cya_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Si'ya cha' nu ycui' ñi can', mdo'o yne cha' si'yana yu ta'a mda'an ñi can' a caja 'a yu. Una a juin Jesús si'yana a ntsu'hui cha' caja yu, cui' ca nu juin ñi: Cha' nan' nchca tin' si'yana ti' ndi'in yu xa yaan xiya', ¿ñi cha' ntsu'hui yuhue ti' cha' re? ");
INSERT INTO cya_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Cui' yu ta'a mda'an ñi can' lca nu ndaa suun cha' re, cui' yu ngua'an scua yu 'in na, lo' jlyo ti' hua si'yana nchcui' yu cha' nu ñi. ");
INSERT INTO cya_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Qui'an 'a cha' nu ti' m'ni Jesús, lo' cha' cua na cha'an scua na cunda scaa ti na, ñan tin' a cula loo chendyu re tyi'in quityi nu chcui' cha' can'. Amen.");
INSERT INTO cya_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Culoo quityi ngua'an tñan 'in um, cua' mtsan' 'in um, ñi Teófilo, nchgaa ña'an nu m'ni Jesús lo'o nchgaa cha' nu ngulo'o ñi ti' xa nu mdyisnan m'ni ñi tñan, ");
INSERT INTO cya_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tsaya' mdiyaa tsaan nu ycuen ñi nde ni' cuaan. Una culo nducua la, lo'o cha' cuiya' 'in Espíritu nu Luhui 'in Ndiose ycui' ñi lo'o yu ta'a mda'an ñi, yu nu cua' ngulohui ñi, ñi tñan ntsu'hui cha' cu'ni. ");
INSERT INTO cya_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Una xa cua' mdyiqui'o ñi, ti' ngulo'o tloo ñi 'in yu cha ni' chcua yla tsaan, si'yana ca cuiya' tsu'hue ti yu si'yana lo'o ca ñi, ti' ycui' ñi lo'o yu ña'an ntsu'hui cha' culo Ndiose tñan 'in nten. ");
INSERT INTO cya_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lja nguio' ti'in yu ngulo ñi tñan 'in yu si'yana a tyi'o yu quichen Jerusalén cui' xaa, cui' ca nu quita yu tsaya' nu caan cha' nu cua' mdi'in tyaa Ndiose, cui' cha' nu cua' ycui' ñi lo'o yu: ");
INSERT INTO cya_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Cha' ñi si'yana yu Xuhua mducua tya yu 'in nten lo'o tyi'a, una ni' chcua xnan ti tsaan, cha'an yu'hui Espíritu nu Luhui 'in Ndiose 'in um. ");
INSERT INTO cya_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Xacan' yu nu nguio' ti'in can' mñicha' yu 'in ñi, lo' juin yu: Ñi X'nan hua, ¿ta cua' taa um cha' cuiya' 'in quichen Israel si'yana xiya' culo na tñan se'en lyi'ya loo na? ");
INSERT INTO cya_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mxcuen ñi 'in yu: A 'ni cha' ca jlyo ti' um ñi tsaan lo' ñi xaa tsato'o sca cha' nu cua' mdi'in tyaa Stina Ndiose, si'yana scati ñi ntsu'hui cha' cuiya' can' 'in ñi, ");
INSERT INTO cya_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","una caja cha' cuiya' 'in um xa cha'an yu'hui Espíritu nu Luhui 'in Ndiose 'in um, xacan' tsa ycui' um cha' tsu'hue re 'ñan lo'o ne' Jerusalén, lo'o nchgaa nu ndi'in se'en lyi'ya loo Judea, lo'o Samaria, lo'o ña'aan sca chcui chendyu. ");
INSERT INTO cya_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ña'aan mdyi ycui' Jesús cha' re, tloo na'an yu m'ni Ndiose cha' ycuen ñi nde ni' cuaan, lo' ngulyijyi yu'hui ñi ni' ndlaa. ");
INSERT INTO cya_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lja ndon nan' 'ya yu se'en nguia nchcuen ñi nde ni' cuaan, tsati ntyin ngu'ya ton tucua yu qui'yu nu mten ste', ");
INSERT INTO cya_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","lo' juin lo'o yu: 'Un ne' Galilea, ¿ñi cha' nan' 'ya um nde ni' cuaan? Cui' Jesús, ñi nu m'ni Ndiose cha' ycuen nde ni' cuaan, cui' tsaña'an na'an um ycuen ñi cua' ñii, cui' cuaña'an ntsu'hui cha' quiaan ñi loo chendyu re xiya'. ");
INSERT INTO cya_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Xacan' mdo'o jun loo qui'ya nu naan Olivo, mxitucui jun nde quichen Jerusalén. Cui' ti nguinu qui'ya can' se'en lca Jerusalén, tsaña'an cuiya' nu nchcui' lee 'in ne' nu tca tyi'an ne' tsaan nu nxitñan' ne'. ");
INSERT INTO cya_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Xa nguila jun quichen can', yten jun ña'an se'en nu cua' nchca tucua nde cuaan se'en nguinu yu Tyo, lo'o yu Jacobo, lo'o yu Xuhua, lo'o yu Ndre, yu Lpe, yu Toma, yu Bartolomé, yu Mateo, lo'o yu Jacobo sñe' yu Alfeo, lo'o yu Simón ta yu Zelote, lo'o yu Juda ta'a yu Jacobo. ");
INSERT INTO cya_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nchgaa jun sca cha' ti 'in jun nchcui' lyi'o jun 'in Ndiose, tsatlyu lo'o María jyi'an Jesús, lo'o ta'a ngula ñi, lo'o chcua xnan jun cuna'an ndiyo' ti'in can'. ");
INSERT INTO cya_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yato'o sca tsaan can', mdyiton yu Tyo lja jun ta'a na, (lo' jun nu nguio' ti'in can', ndiyaa jun sca ciento ntsu'hui cla jun), lo' juin yu 'in jun: ");
INSERT INTO cya_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nchgaa 'un jun ta'a na, m'ni cha' yato'o tsaña'an nu mxiycui' Espíritu nu Luhui 'in Ndiose 'in Davi cha' 'in yu Juda, cui' yu nu ya lo'o 'in nten nu msñi 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tñan 'in Ndiose m'ni hua lo'o yu, cui' ta 'in hua ncua yu. ");
INSERT INTO cya_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Una lo'o tñi nu msu'hua lyiya' ne' 'in yu si'ya cha' ngunan' nu m'ni yu, msi'i ne' sca yuu, lo' se'en mchcan' tucui yu mdyu yu loo yuu can', ytsu ni' yu, lo' ña'aan tixe'en yu mdo'o ti'in na. ");
INSERT INTO cya_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mscua cueen cha' re ña'aan quichen Jerusalén, can' cha' mdi'in tyaa ne' nii se'en can' ca naan na Acéldama, cha' re nchca ti' chcui': Yuu se'en nguilo tne. ");
INSERT INTO cya_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Si'yana nde cha' nu nguinu scua loo quityi Salmo: —Se'en lca tyi yu, ntsu'hui cha' quinu tucua lja na, a caja 'a xca tucui nu ti' tyi'in 'in na—. Nde xca cha' nu nchcui' quityi can': —Xca tucui ntsu'hui cha' sten tñan loo yu—. ");
INSERT INTO cya_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Can' cha' cua' ñii, 'ni cha' tyi'o hui sca yu nu ta'a mdyisnan mda'an hua lo'o Ñi X'nan na Jesús, ");
INSERT INTO cya_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ti' tsaan nu mducua tya yu Xuhua 'in ñi, tsaya' mdiyaa tsaan nu ycuen ñi nde ni' cuaan, si'yana ca sca cha' ti 'in hua lo'o yu nu taa hua suun si'yana cua' mdyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xacan' ngulo ton jun 'in tucua yu nu ntsu'hui lja can', cui' yu naan See Barsabás, nu nchcui' ne' lo'o lca Justo, lo'o xca yu naan Matía. ");
INSERT INTO cya_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Xacan' ycui' lyi'o jun 'in Ndiose, lo' juin jun: Ñi Ndiose X'nan hua, scati um jlyo ti' um nchgaa ña'an lca cusya 'in nten, quitsa' um 'in hua ti ña'an chcuaa yu re cua' ngulohui um, ");
INSERT INTO cya_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nu ca sca cha' ti 'in hua lo'o yu nu cu'ni hua tñan 'in um, cui' tñan nu mxnu ti'in yu Juda can', si'yana cua' nguiaa yu se'en nu ntsu'hui cha' qui'ni ca'an 'in yu si'ya tñan ngunan' nu m'ni yu. ");
INSERT INTO cya_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Xacan' ngulo jun xu'hue 'in chcuaa yu can', lo' Matía m'ni ca'an cha' 'in si'yana ca sca cha' ti 'in lo'o cha tixca yu ta'a mda'an ca Jesús. ");
INSERT INTO cya_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Xa mdiyaa ta'a Pentecostés, sca se'en ti nguio' ti'in jun, nchgaa jun. ");
INSERT INTO cya_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tsati ntyin ngune nde ni' cuaan tsaña'an ne se'en ljyaan sca cui'in tnu, cui' ña'an lcaa ngune 'in jun se'en ndi'in jun ña'an can', ");
INSERT INTO cya_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","xacan' ncua chcan' ngu'ya tucua sca na que jun cunda scaa jun, tsaña'an nchca ti' sca quii'. ");
INSERT INTO cya_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nchgaa jun mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in jun, lo' mdyisnan ycui' jun scasca loo cha' nu si'i 'a cha' nu nchcui' ca jun, cui' tsaña'an mxiycui' Espíritu 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lo' Jerusalén can' mdiyaa qui'an 'a ne' judio nu mdo'o scasca quichen tnu si'yana cu'ni ne' ta'a can'. ");
INSERT INTO cya_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Qui'an 'a nten mdyisnan nguio' ti'in se'en ngune can', a ngujlyo 'a ti' ne' ñi lyijyi cha' ti' quiñan ti' ne' si'yana cunda scaa ne' ngune 'in ne' ña'an nchcui' jun lo'o cha' nu nchcui' ca ne'. ");
INSERT INTO cya_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Lyee 'a yuhue ti' ne' lo' nchcui' ne' scasca ne': ¿Ta si'i ne' Galilea ca lca nchgaa nu ndi'in nchcui' cha' re? ");
INSERT INTO cya_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ña'an ta ne 'in na cunda scaa na cha' nu nchcui' ne' lo'o cha' nu nchcui' ca na ti' xa ngula na? ");
INSERT INTO cya_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Lo'o ne' Partia ndi'in ne' re lo'o na, lo'o ne' Media, lo'o ne' Elam, ne' mdo'o quichen Mesopotamia, ne' mdo'o se'en lca Judea, ne' mdo'o Capadocia, lo'o ne' Ponto, lo'o ne' nu mdo'o se'en lyi'ya loo Asia, ");
INSERT INTO cya_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ne' Frigia, ne' Panfilia, lo'o ne' Egipto, lo'o ne' Africa nu mdo'o nde loo la quichen Cirene, lo' ndi'in ne' Roma lo'o na re, nu lca ycui' ca ne' judio, a cunta lo'o ne' nu ntsu'hui ña'an cha' nu cua' ntsu'hui na, ");
INSERT INTO cya_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","lo'o ne' Creta lo'o ne' Arabia ndi'in ne' re, cunda scaa cha' nu nchcui' na, ne 'in na ña'an nchcui' ne' re cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nchgaa ne' can' ndi'in yuhue ti' ne', a jlyo 'a ti' ne' ñi lyijyi cha' ti' quiñan ti' ne', lo' scasca ne' ñicha' ta'a ne': ¿Ñi cha' ta nchca ti' chcui' cha' nu nchca re? ");
INSERT INTO cya_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Una ntsu'hui nu nde nstyi lyi'o 'in yu, lo' nchcui' ne': Na cu'hui yu re. ");
INSERT INTO cya_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Xacan' mdyiton yu Tyo lo'o ta'a tixca yu ta'a mda'an Jesús, lo' mdyisnan ycui' cueen yu lo'o nten can': Nchgaa 'un, ta'a lca na ne' judio, 'un nu ndi'in Jerusalén re, ca jlyo ti' um lo' quine 'in um cha' nu chcuin' lo'o um. ");
INSERT INTO cya_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yu nu ndi'in re si'i na cu'hui yu ña'an nu 'un ñan ti' um, lo' na tca ntsu'hui ti braa cua' caa tlya. ");
INSERT INTO cya_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Cui' ca nu nchca ña'an cha' nu mxiycui' Ndiose 'in yu Joel, lo' nchcui' na: ");
INSERT INTO cya_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","—Ndeña'an ntsu'hui cha' cu'nin, juin Ndiose, xa tsatii cha' nu nchca loo chendyu re: Cu'nin cha' cha'an yu'hui nchgaa nten lo'o Espíritu 'ñan, xiycuin' 'in sñe' um, yu tsa suhue ti ña'an xñii yu cha' nu ntsu'hui cha' ca, cui' cuaña'an yu cula chcui' sla yu cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nu cha' ñi s'ni, cu'nin cha' cha'an yu'hui Espíritu 'ñan 'in nguso 'ñan, yu qui'yu lo'o nu cuna'an chcui' can' cha' tsu'hue 'ñan lo'o nten. ");
INSERT INTO cya_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nan' cu'nin cha' nu tnu nde ni' cuaan lo'o loo chendyu re: Ntsu'hui cha' quilo tne, ntsu'hui cha' squin quii' nu tnu, lo' xtyi sñi ti quinu ti'in xacan'. ");
INSERT INTO cya_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cucha ntsu'hui cha' tyuhui' na, lo' coo' chca nga'á na ña'an nchca ti' tne. Tsato'o cha' re xa ti' lyijyi cu'ni cuiya' ñi nu lca X'nan um cha' 'in nten chendyu, cui' tsaan nu cu'nin sca cha' nu tlyu xa ca chcan' loo cha' cuiya' 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nchgaa nu tsa qui'an ti' si'yana lcan X'nan, can' nu tyi'o laa—. ");
INSERT INTO cya_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","'Un ne' Israel, quine 'in um cha' nu chcuin': Cua' jlyo ti' um si'yana Jesús Nazaret, lo'o cha' cuiya' nu mdaa Ndiose 'in ñi qui'an 'a cha' nu tnu m'ni ñi tloo na'an um, lo' ncua cuiya' ti' um si'yana Ndiose ngulohui 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Una si'ya cha' nu cua' mdi'in tyaa Ndiose cua' s'ni yato'o nguinu Jesús tuyaa' um, lo' mdyaa um cunta 'in ñi 'in ne' nducun' lo' yjui ne' 'in ñi loo cusi, ");
INSERT INTO cya_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","una Ndiose m'ni ñi cha' mdyiqui'o Jesús, ngulyoo ñi 'in can' se'en ndijin ne' nu ti'i, a ncua 'in cha' ndyija can' xñi su'hua yaa' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Si'yana ndeña'an ngua'an scua Davi cha' 'in ñi: —Nchgaa xaa ndi'in Ñi X'nan na lo'on, a sca cha' ntsu'hui cha' cutsen si'yana ndon ñi tso' cueen 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Can' cha' tsu'hue ntsu'hui tiqueen, nducui tin' nchcuin' cha' re, a ndyuhue tin' xa ntsu'hui cha' cajan, ");
INSERT INTO cya_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","si'yana a xnu su'hua um cusya 'ñan yaa' cha' ndyija, ñi a taa um ya' cutso' ti'in cunan', nan' nu lca Sñe' um nu luhui lati. ");
INSERT INTO cya_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ngulo'o um sca tucueen nu taa chendyu 'ñan, cui' um cu'ni um cha' ca tsu'hue lca tiqueen la tloo um—. ");
INSERT INTO cya_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","'Un nu ndi'in re, nchca tin' chcuin' la ya' lo'o um cha' 'in Davi nu ncua nten cula 'in na, ña'an ngujui yu lo' mtsi' yu, lo' hasta cua' ñii jlyo ti' na la mtsi' yu. ");
INSERT INTO cya_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ncua yu sca nu mxiycui' Ndiose 'in, cui' ñi mdi'in tyaa tla ñi cha' re lo'o yu, ngujlyo tsu'hue ti' yu si'yana loo ta nten 'in yu ntsu'hui cha' caan Cristo nu ntsu'hui cha' culo ca tñan 'in na, ");
INSERT INTO cya_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ti' xacan' cua' na'an Davi ña'an mdyiqui'o Cristo, can' cha' juin yu si'yana a nguinu yu'hui cusya 'in ñi yaa' cha' ndyija, ñi a ytso' ti'in cunan' ñi. ");
INSERT INTO cya_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Cui' ñi nu lca Jesús m'ni Ndiose cha' mdyiqui'o, lo' nchgaa hua ndaa hua suun si'yana cuaña'an yato'o. ");
INSERT INTO cya_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Xacan' mchcuan ñi sca cha' cuiya' nu tlyu nde tso' cueen 'in Ndiose, a cunta mchcuan ñi Espíritu nu cua' mdi'in tyaa Sti ñi cha' cha'an yu'hui ni' cusya 'in na, cui' cha' nu na'an tloo um cua' ñii lo' ne 'in um. ");
INSERT INTO cya_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Si'yana yu Davi a nchca scuen yu nde ni' cuaan xa nu juin yu: —Ndiose X'nan na juin ñi lo'o Ñi X'nan: Chcua tso' cueen 'ñan, ");
INSERT INTO cya_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","lja xicu'nin 'in ta'a cusuun quinu nde tuquiya'—. ");
INSERT INTO cya_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Can' cha' cua' ñii, 'un ne' Israel, ca cuiya' ca ti' um si'yana Jesús nu mjyi'in ca'an um 'in loo cusi, Ndiose cua' m'ni ñi cha' lca Ñi X'nan na, lo' lca ñi Cristo. ");
INSERT INTO cya_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cui' xaa ngu'ya sca tu'hua ni' cusya 'in ne' xa ngune 'in ne' cha' can', lo' mñicha' ne' 'in yu Tyo lo'o nchgaa la ña'an ta'a mda'an Jesús: 'Un jun ta'a na, ¿ñi na tca cu'ni hua? ");
INSERT INTO cya_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Xacan' mxcuen yu Tyo can': Tyaa ti' um 'in Ndiose lo' chcua tya um lo'o cha' cuiya' 'in Jesucristo si'yana cuten qui'ya nducui um, lo' cha'an yu'hui Espíritu nu Luhui 'in Ndiose 'in um. ");
INSERT INTO cya_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Si'yana ntsu'hui cha' qui'ni ca'an cha' tsu'hue re 'in um, lo'o sñe' um, lo'o nchgaa nten nu ndi'in tijyo' loo, nchgaa nu cua' ngulohui Ndiose X'nan na. ");
INSERT INTO cya_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Qui'an 'a cha' ti' ycui' la yu Tyo lo'o nten can', mdaa yu cha' tnu tiquee 'in ne', lo' juin yu: Tyi'o tso' um tucueen ngunan' nu nguiaa um. ");
INSERT INTO cya_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yato'o nchgaa nu m'ni cunta cha' nu ycui' yu Tyo can' mducua tya ne', ticui' tsaan can' ndiyaa ne' tsa snan mii ne' nu mchca sca cha' ti 'in ne' lo'o jun. ");
INSERT INTO cya_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tsatlyu ndi'in lo'o jun cha' nu ndlo'o yu ta'a mda'an Jesús, sca cha' ti 'in jun nchcu jun, cui' cuaña'an sca cha' ti 'in jun nchcui' lyi'o jun 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yten sca ytsen ni' cusya 'in nchgaa tucui si'ya scasca cha' nu tnu ngui'ni yu ta'a mda'an Jesús. ");
INSERT INTO cya_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nchgaa jun nu cua' ya qui'an ti' 'in ñi, sca cha' ti 'in jun lo'o ta'a jun, lo' tsatlyu ndi'in na 'in jun nchgaa jun. ");
INSERT INTO cya_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ntsu'hui nu yjui' se'en ndlo tñan, ntsu'hui nu yjui' na nu ndi'in 'in, lo' mtsa jun tñi can' cua' ña'aan 'ni cha 'in jun cunda scaa jun. ");
INSERT INTO cya_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sca cha' ti 'in jun ndiyo' ti'in jun nchgaa tsaan ni' lyaa, tsatlyu nchcu jun ña'an 'in cunda scaa jun, tsu'hue ntsu'hui tiquee jun ndi'in jun lo'o suun ña'an, ");
INSERT INTO cya_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","n'ni tnu jun 'in Ndiose, lo' nten ndi'in quichen can' ndyu'hui cuiya' ti' ne' ña'an ndi'in jun lo'o ta'a jun. Cunda scaa tsaan can' ngui'ni Ñi X'nan na cha' nchca tyun la jun, nchgaa nu ntsu'hui cha' tyi'o laa. ");
INSERT INTO cya_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yato'o sca tsaan yu Tyo lo'o yu Xuhua nguiaa yu se'en nducua laa, tsa ntsu'hui braa cua' snan siin xa nchcui' lyi'o ne' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tulaa nu naan ndyi'ya 'a, nchgaa tsaan ndyi'an lo'o ne' 'in sca yu nu mchcun' quiya' ti' xa ngula, can' nchcua jñan yu tñi 'in ne' nu nguiten can'. ");
INSERT INTO cya_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Xa na'an yu si'yana cua' sten yu Tyo lo'o yu Xuhua ni' lyaa, mjñan yu tñi 'in chcuaa yu can'. ");
INSERT INTO cya_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Una yu Tyo lo'o yu Xuhua mxina'an tsu'hue ca yu tloo yu can', lo' juin yu 'in: Ña'an um jan ñi. ");
INSERT INTO cya_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Xacan' sa 'a yu si'yana cua' xñi yu tñi 'in yu can'. ");
INSERT INTO cya_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Una yu Tyo can' juin yu 'in: A lo'o tñi 'ñan, una taan na nu lo'o 'ñan. Lo'o cha' cuiya' 'in Jesucristo Nazaret, tyiton um lo' tyi'an um. ");
INSERT INTO cya_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Xacan' msñi yu Tyo can' yaa' yu tso' cueen nu xiton yu 'in, ticui' xaa mchca tsu'hue quiya' yu. ");
INSERT INTO cya_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Sca juesa ti mdyiton yu, mdyisnan mda'an yu, yten yu lo'o chcuaa yu can' ni' lyaa, mda'an yu, mdo'o cuaan yu, m'ni tnu yu 'in Ndiose si'yana cua' mchca yu. ");
INSERT INTO cya_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nchgaa ne' na'an ne' ña'an nda'an yu lo' ngui'ni tnu yu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Cui' xaa yu'hui lyoo ne' 'in yu si'yana lca yu nu nchcua njñan tñi can' tulaa nu naan ndyi'ya 'a. Yuhue 'a ti' ne', a cunta ytsen ne' si'ya cha' nu yato'o can'. ");
INSERT INTO cya_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yu nu mchca quiya' can' nsñi ton yu 'in yu Tyo lo'o yu Xuhua se'en nu nguia' tucui tulaa nu naan Salomón. Nchgaa ne' msnan ne' mdiyaa ne' se'en ndon yu si'yana lyee yuhue ti' ne'. ");
INSERT INTO cya_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Xa na'an yu Tyo si'yana cua' nguio' ti'in nten can', mdyisnan ycui' yu lo'o ne': 'Un ne' Israel, ¿ñi cha' nduhue 'a ti' um cha' re? ¿Ñi cha' nan' 'ya um 'in hua, ta nxque' ti' um si'yana lo'o cha' cuiya' 'in hua, uta lo'o cha' tsu'hue 'in hua mchca yu re? ");
INSERT INTO cya_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","—Ndiose 'in Abraham, lo'o Isaac, lo'o Jacob, cui' Ndiose 'in nten cula 'in na—, m'ni ñi cha' ycuen cuaan cha' 'in Sñe' ñi nu lca Jesús, ñi nu mdyaa um cunta 'in tuyaa' yu Pilato, ñi nu ncua ti' yu culaa yu, lo' 'un a mslyaa um. ");
INSERT INTO cya_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yato'o mscuan tloo um 'in ñi nu Luhui lati, nu Ñi ndi'in cha' 'in, lo' nde mjñan um cha' lyaa sca yu nu ndujui nten. ");
INSERT INTO cya_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yjui um 'in ñi nu ndaa chendyu 'in na, una Ndiose m'ni ñi cha' mdyiqui'o can', lo' huare' ndaa hua suun cha' re. ");
INSERT INTO cya_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Si'ya cha' nu ndiya qui'an ti' hua 'in Jesús mchca yu re, yu nu ndyu'hui lyoo um lo' nan' 'ya um, lo' si'yana ndiya qui'an ti' hua 'in ñi, can' cha' siya' ti m'ni chca ñi 'in yu tloo na'an um. ");
INSERT INTO cya_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Una cua' ñii, 'un jun ta'a na, jlyo ti' hua si'yana m'ni um cha' re lo'o cha' tinto tsatlyu lo'o jun nu ndlo tñan 'in um. ");
INSERT INTO cya_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Una Ndiose m'ni ñi cha' yato'o cha' re tsaña'an cha' nu cua' mxiycui' ñi 'in nchgaa nguso 'in ñi, si'yana Cristo ntsu'hui cha' tyijyin ñi nu ti'i. ");
INSERT INTO cya_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Can' cha' cua' ñii, tyaa ti' um 'in Ndiose si'yana chca qui'ya nducui um, lo' Ñi X'nan na cu'ni ñi cha' xitñan' cusya 'in um, ");
INSERT INTO cya_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","lo' ca'an tñan ñi 'in Jesucristo, ñi nu cua' mdo'o ton si'yana culo laa 'in um. ");
INSERT INTO cya_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Una nta ñi la ni' cuaan lja nu tsato'o nchgaa la ña'an cha' nu cua' mdi'in tyaa Ndiose, tsaña'an cha' nu cua' mxiycui' ñi 'in nchgaa nu ngulohui ñi 'in ti' cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Si'yana yu Moisé ndeña'an juin yu 'in nten cula 'in na: —Ndiose nu lca X'nan na juin ñi si'yana lja ta'a na ntsu'hui cha' caan sca yu nu xiycui' Ndiose 'in tsaña'an nu nxiycui' Ndiose 'ñan nan', can' nu cu'ni cunta um cha' nu chcui'. ");
INSERT INTO cya_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nchgaa nu a cuan xu'hue cha' nu chcui' can', caja nu culo tso' 'in—. ");
INSERT INTO cya_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Cui' cuaña'an nchgaa la ña'an yu nu mxiycui' Ndiose 'in, ti' yu Samuel nu ljyaan nde loo, ticui' cha' re mda'an ycui' yu. ");
INSERT INTO cya_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ncua yu nten cula 'in na, can' cha' ngui'ni ca'an cha' tsu'hue re 'in na, cui' cha' nu mdi'in tyaa Ndiose lo'o nten cula 'in na, lo' ndeña'an juin ñi 'in Abraham: —Loo ta nten 'in ntsu'hui cha' caan sca sñe' nu ljyan lo'o cha' tsu'hue 'in nchgaa nten chendyu—. ");
INSERT INTO cya_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","¿Ta si'i lja na culo nducua la mxiton Ndiose 'in scati Sñe' ñi nu taa cha' tsu'hue 'in na lo'o um, ña'an ca si'yana xilo'o chon' na qui'ya ngui'ni na cunda scaa na? ");
INSERT INTO cya_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lja nchcui' yu lo'o nten can' mdiyaa yu nu ndlo tñan ni' lyaa, tsatlyu lo'o yu nu lca que 'in yu silyiya nu ntsu'hui cuan ni' lyaa can', lo'o ne' saduceo. ");
INSERT INTO cya_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ti'i ti' ne' si'yana ndlo'o yu 'in nten si'yana Jesús cua' mdyiqui'o ñi, lo' si'ya cha' can' nchca cuiya' ti' ne' si'yana ntsu'hui cha' tyiqui'o nu cua' ngujui. ");
INSERT INTO cya_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Msñi ne' silyiya 'in chcuaa yu can', msu'hua yu 'in na'an chcuan, lo' si'yana cua' msiin la xca tsaan can' ncua cuiya' cha' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Una qui'an 'a nten nu ngune 'in cha' 'in Ndiose ya qui'an ti' ne' 'in ñi. Tsalca yu qui'yu nu ya qui'an ti' can', ndiyaa yu ca'yu mii yu. ");
INSERT INTO cya_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yato'o xca tsaan can', cui' Jerusalén nguio' ti'in yu nu ndlo tñan ni' lyaa 'in ne' judio, lo'o qui'yu cula, lo'o ne' escriba, ");
INSERT INTO cya_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","lo'o yu Anás, yu nu ndlo ca tñan ni' lyaa can', lo'o yu Caifás, lo'o sca yu nu naan Xuhua, lo'o yu Jantro, lo'o nchgaa la ña'an nten 'in yu nu ndlo ca tñan ni' lyaa can' nguio' ti'in can'. ");
INSERT INTO cya_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xa nu cua' ndon chcuaa yu can' tloo ne' mñicha' ne' 'in yu: ¿La jui cha' cuiya' re 'in um, lo' ti nu mdaa 'in na lo'o tsaña'an nu m'ni um? ");
INSERT INTO cya_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yu Tyo can' mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in yu, lo' juin yu: 'Un nu ndlo tñan 'in hua, nchgaa 'un nu lca qui'yu cula 'in ne' Israel, ");
INSERT INTO cya_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","cua' ñii nchca cuiya' cha' 'in hua si'ya cha' tsu'hue nu yato'o 'in yu nu ncua ti'i re, lo' ña'an ncua mchca yu, ");
INSERT INTO cya_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","can' cha' quitsan' 'in um, lo' ca jlyo ti' 'un ne' Israel, si'yana lo'o cha' cuiya' 'in Jesús Nazaret, ñi nu lca Cristo, ñi nu mjyi'in ca'an um 'in loo cusi lo' m'ni Ndiose cha' mdyiqui'o, lo' si'ya Jesús ndon yu re tsu'hue lca 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Cui' Jesús lca ñi —quee nu mscuan tloo um, 'un nu lca cuityi na'an, cua' ñii lca ñi quee nu nsñi ton 'in na'an—. ");
INSERT INTO cya_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ñi a caja 'a xca tucui nu tca culo laa 'in na, cui' ca nu scati ñi nu lca Jesús mdaa Ndiose 'in nten chendyu nu tca xicuten qui'ya 'in na. ");
INSERT INTO cya_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nduhue 'a ti' ne' 'in yu Tyo lo'o yu Xuhua can' si'yana lo'o cha' tnu tiquee 'in yu nchcui' yu, jlyo ti' ne' si'yana a sca cha' m'ni cha'an yu, ñi a sca tñan lyi'ya yu, xacan' ncua cuiya' ti' ne' si'yana lo'o Jesús ta'a mda'an yu. ");
INSERT INTO cya_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","A xca 'a cha' ti' ncua chcui' ne' lo'o yu, si'yana sca se'en ti ndon yu lo'o yu nu mchca can'. ");
INSERT INTO cya_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Xacan' ngulo ne' tñan si'yana tyi'o yu nde lyiya' lja cu'ni cuiya' ne' cha' 'in yu lo'o ta'a nducua ne' can', ");
INSERT INTO cya_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","lo' ndeña'an nchcui' ne': ¿Ña'an cu'ni na lo'o yu cua? Cua' m'ni yu sca cha' nu tnu lo' ña'aan quichen Jerusalén cua' mscua cueen cha' re, a ndyijyi 'a ña'an su'hua cutsi' na cha' re. ");
INSERT INTO cya_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Cua' ñii si'yana a quine yu'hui cha' re lyee la, tsu'hue lati xicutsen na 'in yu si'yana a chcui' 'a yu lo'o ñi xca tucui cha' 'in Jesús chcui nu nguiaa nde loo la re. ");
INSERT INTO cya_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Xacan' mxi'ya ne' 'in yu, lo' tla 'a mdi'in tyaa ne' cha' lo'o yu si'yana a chcui' 'a yu lo'o ñi xca tucui cha' 'in Jesús, ñi a culo'o 'a yu 'in nten cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Una yu Tyo lo'o yu Xuhua can' mxcuen yu 'in ne': ¿Ti ña'an ta cha' re nu tsu'hue la na tloo Ndiose? ¿Ta tsu'hue la cha' ca ja'an hua 'in um, uta na ca ja'an hua 'in Ndiose? ");
INSERT INTO cya_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Si'yana huare' a tca cula ti' hua chcui' hua lo'o nten ña'an cha' nu cua' na'an hua lo' ngune 'in hua. ");
INSERT INTO cya_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tla 'a cha' ycui' ne' lo'o yu se'en nu xicutsen ti' yu, xacan' ngulaa ne' 'in yu, a jui ña'an culo qui'ya ne' 'in yu si'yana ytsen ne' 'in nten qui'an can', si'yana nchgaa ne' m'ni tnu ne' 'in Ndiose si'ya cha' nu yato'o can', ");
INSERT INTO cya_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","si'yana yu nu ncua ti'i can' cua' ndyijyin tucua yla yjan ntsu'hui yu, lo' Ndiose m'ni chca 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Xa ngulaa ne' 'in yu, nguila yu se'en ndi'in nchgaa la ña'an ta'a nda'an yu, mdaa yu suun ña'an cha' nu ycui' yu nu ndlo ca tñan ni' lyaa lo'o qui'yu cula can'. ");
INSERT INTO cya_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Xa ngune 'in jun ña'an cha' nu mdaa yu can', sca cha' ti 'in jun mdyisnan ycui' lyi'o jun 'in Ndiose, lo' juin jun: Ndiose X'nan hua, 'un ntsu'hui cha' cuiya' yaa' um lo'o nchgaa loo cha', —cui' um mtñan um ni' cuaan, lo'o chendyu re, lo'o tyi'a tujo'o, cui' um mtñan um nchgaa loo na nu ndi'in 'in na—, ");
INSERT INTO cya_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","cui' um mxiycui' um 'in Davi nu ncua nguso 'in um, lo' juin um: ¿—Ñi cha' ta lyee 'a nguilo ti'in nten re, ñi cha' nsu'hua loo ne' cha' nu a ntsu'hui cunta? ");
INSERT INTO cya_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yu nu lca ree loo chendyu re, tsatlyu lo'o yu nu ntsu'hui cha' cuiya' yaa', ndiyo' ti'in yu se'en nu xuun yu lo'on nan' nu lca X'nan yu, lo'o Cristo nu ngulohuin—. ");
INSERT INTO cya_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Cha' ñi si'yana cuaña'an nguio' ti'in nten re, yu Herode lo'o yu Poncio Pilato, ne' gentil lo'o ne' Israel, se'en nu ña'an ti'i ne' 'in Sñe' um, ñi nu luhui lati nu ngulohui um, nu lca Jesús, ");
INSERT INTO cya_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","si'yana cu'ni ne' tsaña'an cha' nu cua' mdi'in tyaa um cua' s'ni, nchgaa cha' nu ntsu'hui cha' ca. ");
INSERT INTO cya_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cua' ñii, 'un Ñi X'nan hua, xñi um cunta ña'an nchcui' ti'i ti' ne' 'in hua, una taa um cha' cuiya' 'in hua nu lca nguso 'in um, si'yana a xicutsen ti' hua chcui' hua cha' tsu'hue 'in um lo'o nten, ");
INSERT INTO cya_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","lja xacan' cu'ni chca um 'in nu ti'i, cu'ni um scasca cha' nu tnu lo'o cha' cuiya' 'in Sñe' um, ñi nu luhui lati 'in um nu lca Jesús. ");
INSERT INTO cya_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ña'aan mdyi ycui' lyi'o jun 'in Ndiose, nguñan se'en nguio' ti'in jun, mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in nchgaa jun, lo' m'ni tnu tiquee jun ycui' jun cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sca cha' ti 'in jun nu cua' ya qui'an ti' 'in Jesús, lo' sca cusya ti 'in jun ndi'in jun can', a tucui nu nchcui' si'yana na 'in lca na nu ndi'in 'in, si'yana tsatlyu ndi'in na 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yu ta'a mda'an ca Jesús, tnu 'a tiquee yu nchcui' yu lo'o nten si'yana mdyiqui'o Ñi X'nan na Jesús, lo' Ndiose m'ni ñi cha' mtsa'an yu'hui cha' tsu'hue 'in ñi ni' cusya 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","A xca 'a jun ti' ngui'ni cha' 'in jun, si'yana nchgaa jun nu ndi'in yuu 'in, ta nducua na'an 'in, ndyijui' jun 'in na lo' ndiya lo'o jun ña'aan tñi can', ");
INSERT INTO cya_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ndaa jun 'in na 'in yu ta'a mda'an Jesús, lo' yu can' cua' ntsa yu 'in na cua' ña'aan 'ni cha' 'in jun cunda scaa jun. ");
INSERT INTO cya_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lja jun can' ndi'in sca yu naan See nu mdo'o se'en lca Chipre, una yu ta'a mda'an Jesús mdi'in tyaa nii yu ca naan yu Bernabé. (Nii yu nchca ti' chcui': Sñe' nu ndaa cha' tnu tiquee.) Lca yu ta nten 'in ne' Leví. ");
INSERT INTO cya_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Lo'o yu can' yjui' yu sca yuu 'in yu, lo' ña'aan tñi can' mdaa yu 'in yu ta'a mda'an Jesús. ");
INSERT INTO cya_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Una xca yu naan Ananía lo'o Safira cuilyi'o yu, yjui' jun sca yuu 'in jun, ");
INSERT INTO cya_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","una m'ni cuiya' jun cha' si'yana quinu tsa chin' tñi can' 'in jun, lo' xa mdaa yu tñi can' m'ni yu cha' si'yana ña'aan na mdaa yu 'in yu ta'a mda'an Jesús. ");
INSERT INTO cya_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Xacan' juin yu Tyo 'in yu Ananía: ¿Ñi cha' mdaa um ya' nguñi lyi'o Laxa'an 'in um, ncua ti' um cuñilyi'o um 'in Espíritu nu Luhui 'in Ndiose, lo' mxu'hua se'en um tichin' tñi nu yjui' um yuu can'? ");
INSERT INTO cya_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ta si'i se'en ndlo ca um tñan lca na? Xa yjui' um 'in na, ¿ta si'i cunta 'in um su tñi can'? ¿Ñi cha' mdaa um ya' yten cha' ngunan' ni' cusya 'in um? Una si'i tloo nten ycui' um cha' cuiñi re, cui' ca nu tloo Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ña'aan ngune 'in yu Ananía cha' can' mdlyu yu lo' ngujui yu. Nchgaa ne' yten sca ytsen 'in ne' xa ynan ne' cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Cui' xaa mdiyaa tucua snan yu tsa suhue ti, nguxen te' 'in yu lo' ya tsi' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsa mdijin snan braa xa mdiyaan nten 'in yu nu ngujui can', una a ngujlyo ti' ne' ña'an cha' nu yato'o can'. ");
INSERT INTO cya_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Xacan' juin yu Tyo can' 'in ne': Quitsa' um 'in hua, ¿ta cui' tsacua ti ncua yuu nu yjui' um can'? Mxcuen ne' 'in yu: Cui' tsacua ti ncua na. ");
INSERT INTO cya_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Juin yu Tyo 'in ne': ¿Ñi cha' ncua sca cha' ti 'in um lo' ncua ti' um cuñilyi'o um 'in Espíritu 'in Ñi X'nan na? Ña'an jan ñi, tuna'an cua cua' nguila yu nu ya tsi' 'in nten 'in um, lo' cui' cuaña'an tsa lo'o yu 'in um. ");
INSERT INTO cya_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Cui' ña'an lcaa mdlyu ne' cuna'an can' tloo yu Tyo can', lo' ngujui ne'. Ña'aan nguila yu tsa suhue ti can' na'an yu si'yana cua' ngujui ne'. Xacan' ya tsi' yu 'in ne' sii' se'en su cuilyi'o ne'. ");
INSERT INTO cya_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yten sca ytsen ni' cusya 'in nchgaa jun ta'a na, cui' cuaña'an lo'o nchgaa la ña'an nten nu ynan cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Si'ya cha' cuiya' nu mdaa Ndiose 'in yu ta'a mda'an Jesús, ncua m'ni yu scasca cha' nu tnu tloo na'an nten can', sca cha' ti 'in jun ndiyo' ti'in jun se'en nguia' tucui tulaa Salomón can'. ");
INSERT INTO cya_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nchgaa la ña'an nten can' tsu'hue 'a cha' nchcui' ne' 'in jun, una a msti ti' ne' quio' ti'in ne' sca se'en ti lo'o jun, ");
INSERT INTO cya_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","siya' cuaña'an nde lyee la nguia nguiton nten nu cua' ya qui'an ti' 'in Ñi X'nan na, tsaña'an qui'an yu qui'yu lo' cuaña'an qui'an jun cuna'an. ");
INSERT INTO cya_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A cunta ndyi'an lo'o ne' 'in nu ti'i, mdi'in tyaa ne' 'in loo jaa' uta loo qui'ñan tu'hua tucueen se'en ntsu'hui cha' tyijyin yu Tyo, lo' siya' xñii ti yu cha' qui'ni ca'an 'in nu ti'i can', lo' nchca. ");
INSERT INTO cya_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Scasca quichen nu ndi'in cui' ti can', ndyi'o lo'o ne' 'in nu ti'i lo'o nu ntsu'hui cui'in xa'an 'in, mdiya lo'o ne' 'in se'en ndi'in jun quichen Jerusalén, lo' nchgaa can' mchca. ");
INSERT INTO cya_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yu nu ndlo ca tñan ni' lyaa tsatlyu lo'o ta'a nda'an yu, cui' ta 'in ne' Saduceo, yten sca cha' xlya ni' cusya 'in ne', ");
INSERT INTO cya_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","lo' ngulo ne' tñan si'yana quinu yu ta'a mda'an Jesús, lo' tsaa yu na'an chcuan. ");
INSERT INTO cya_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Una ticui' tla can' ngu'ya ton sca angujle 'in Ñi X'nan na se'en ntsu'hui yu, lo' msla tuna'an chcuan can', xa cua' ngulyoo 'in yu xacan' juin: ");
INSERT INTO cya_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Yaa um lo' sten um ni' lyaa, lo' chcui' la um lo'o nten ña'an nguiaa cha' 'in chendyu nu cui ti. ");
INSERT INTO cya_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","M'ni yu cunta cha' can', lo' ña'aan ngu'ya xaa yten yu ni' lyaa, lo' mdyisnan ngulo'o yu 'in nten can'. Una lja xacan', yu nu ndlo ca tñan ni' lyaa lo'o ta'a nda'an yu, mxi'ya yu 'in nchgaa yu nu ntsu'hui cha' cuiya' yaa', tsatlyu lo'o qui'yu cula 'in ne' Israel, lo' ngulo ne' tñan 'in yu silyiya si'yana quia lyoo yu 'in yu nu ntsu'hui ña'an chcuan can'. ");
INSERT INTO cya_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Una xa mdiyaa yu na'an yu si'yana a tucui 'a ntsu'hui can', xacan' nguia ytsa' yu 'in nchgaa yu nu nguio' ti'in can', ");
INSERT INTO cya_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","lo' juin yu: Nu cha' ñi s'ni, xa mdiyaa hua se'en nducua na'an chcuan cua, na'an hua si'yana nchcun tsu'hue na, lo' yu nu ntsu'hui cuan 'in na ndon yu tuna'an can', una xa msla hua 'in na, a tucui 'a ntsu'hui can'. ");
INSERT INTO cya_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yu nu ndlo ca tñan ni' lyaa lo'o yu nu lca que 'in silyiya nu ntsu'hui cuan ni' lyaa, lo'o nchgaa la ña'an yu nu ndlo tñan can', qui'an 'a cha' mda'an tiquee yu, lo' nguñan ti' yu ña'an tsato'o cha' re. ");
INSERT INTO cya_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Una cui' xaa mdiyaa sca yu nu mdaa suun, lo' juin yu: Yu nu msu'hua um na'an chcuan, cua' ñii ndlo'o yu 'in nten ni' lyaa cua. ");
INSERT INTO cya_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Xacan' mdo'o yu nu lca que lo'o silyiya 'in yu, nguia 'ya yu 'in chcuaa yu can', lo'o cha' tsu'hue ti nguian lo'o ne' 'in yu, si'yana nguitsen ne' cha' ta jyi'in nten can' quee 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Xa nguila lo'o ne' 'in yu, mdyaa ne' cunta 'in yu yaa' nu ntsu'hui cha' cu'ni cuiya' cha' 'in yu, lo' yu nu ndlo ca tñan ni' lyaa can' mñicha' 'in yu: ");
INSERT INTO cya_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","¿Ta si'i na cua' ycui' na lo'o um si'yana a culo'o 'a um 'in nten cha' 'in yu can'? Cua' ñii, ña'aan Jerusalén cua' ngune 'in ne' cha' nu ndlo'o um, lo' nchca ti' um su'hua um qui'ya chon' hua si'ya cha' nu ngujui yu. ");
INSERT INTO cya_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mxcuen yu Tyo can' lo'o nchgaa la ña'an ta'a mda'an Jesús: 'Ni cha' ca ja'an hua 'in Ndiose culo nducua la, lo' si'i 'in nten chendyu. ");
INSERT INTO cya_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Cui' Ndiose 'in nten cula 'in na ngua'an tñan ñi 'in Jesús, lo' 'un yjui um 'in ñi xa mjyi'in ca'an um 'in ñi sca sii' yca. ");
INSERT INTO cya_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","'In ñi cua' mdaa Ndiose sca cha' cuiya' nu tlyu tso' cueen 'in ñi, si'yana ca Ñi nu ndon loo, Ñi nu ndlo laa 'in na, se'en nu xilo'o chon' ne' Israel qui'ya ngui'ni ne', lo' cu'ni ñi cha' tlyu ti' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Huare' ndaa hua suun cha' re tsatlyu lo'o Espíritu nu Luhui 'in Ndiose, cui' Espíritu nu ndaa Ndiose chu'hui ni' cusya 'in nchgaa nu ca ja'an 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Una nde lyee la ycuen tique' ne' xa ngune 'in ne' cha' can', lo' ncua ti' ne' cujui ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Una lja can' mdyiton sca yu fariseo naan Gamaliel, lca yu sca nu ndlo'o cha' 'in lee, lo' lyee ndyu'hui cuiya' ti' nten 'in yu. Ngulo yu tñan si'yana culyoo ne' 'in yu ta'a mda'an Jesús tsa xi'i nde lyiya', ");
INSERT INTO cya_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","xacan' juin yu 'in ta'a nducua yu: 'Un ne' Israel, xñi na cunta ña'an cu'ni na lo'o yu cua. ");
INSERT INTO cya_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","A s'ni lyee mda'an sca yu ncua naan Teudas, juin yu si'yana ntsu'hui cha' cuiya' yaa' yu, lo' mxo' ti'in yu jacua ciento yu qui'yu nu ncua sca cha' ti 'in lo'o yu, una xa ngujui yu, nchgaa ta'a mda'an yu cua' la tucueen ngunaan yu. ");
INSERT INTO cya_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chon' nde'en can' mda'an sca yu Galilea nu ncua naan Juda, cui' xa mda'an sñi ne' nii nten quichen, cui' cuaña'an qui'an nten mxo' ti'in yu, una xa ngujui yu ticui' ti ña'an yato'o 'in ta'a mda'an yu, cua' la tucueen ngunaan ne'. ");
INSERT INTO cya_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Can' cha' cua' ñii chcuin' lo'o um: Tsu'hue lati culaa na 'in yu re, a ta quiya' na 'in yu lo'o cha' nu ndlo'o yu, si'yana cha' ta lca na cha' 'in nten chendyu, tsatii tuhue cha' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Una cha' lca na cha' 'in Ndiose, a tca chcui ndijin na loo cha' cua, ña'an tu' quija lyoo na nsuun na lo'o Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nguinu tsu'hue tiquee ne' lo'o ña'an cha' nu ycui' yu. Xacan' mxi'ya ne' 'in yu ta'a mda'an Jesús, ngulo ne' tñan si'yana qui'ni yu lo' mdi'in tyaa tla ne' sca cha' lo'o yu si'yana a chcui' a yu cha' 'in Jesús, xacan' ngulaa ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tsu'hue ntsu'hui tiquee yu mdyi'o yu se'en can' si'yana mdaa Ndiose cha' cuiya' mdijin yu nu ti'i si'ya Jesús. ");
INSERT INTO cya_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nchgaa tsaan ndlo'o yu 'in nten ni' lyaa uta la na'an 'in ne', a ndla' ti' yu nchcui' yu cha' tsu'hue 'in Jesucristo. ");
INSERT INTO cya_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Cui' lja xacan' nguia nguiton jun nu ntsu'hui cha' 'in Jesús, una mdyisnan msu'hua qui'ya ta'a jun nu nchcui' cha' griego lo'o nu nchcui' cha' hebreo, si'yana lyee la nda yaa' jun 'in ne' cuna'an nu nguinu lo'o cha' ycui' ti nu nchcui' cha' hebreo que 'in nu nchcui' cha' griego. ");
INSERT INTO cya_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Xacan' ta'a tichcua yu can' mxo' ti'in yu 'in nchgaa jun nu cua' ntsu'hui cha' 'in Jesús, lo' juin yu: A ndyi'o tñan cula' ti' hua chcui' hua cha' 'in Ndiose, lo' cutsa hua na nu cunajo'o 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Can' cha', 'un jun ta'a na, culohui um tsa cati yu qui'yu lja na re, yu nu ndyi'ya ña'an chendyu ndu'hui, yu nu mtsa'an yu'hui lo'o Espíritu nu Luhui 'in Ndiose, yu nu tiyaa, can' nu xnu na 'in cu'ni tñan re. ");
INSERT INTO cya_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lo' huare' tsa quiñan la hua chcui' lyi'o hua 'in Ndiose lo' chcui' hua cha' tsu'hue 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nguinu tsu'hue tiquee jun lo'o cha' nu ycui' yu. Xacan' ngulo ton jun 'in yu Steba, sca yu nu lyee ndiya qui'an ti' nu mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in, lo'o yu Lpe, yu Prócoro, Nicanor, yu Timón, yu Parmenas, lo'o yu Nicolás nu mdo'o quichen Antioquía, sca yu cua' ntsu'hui ña'an cha' 'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mdiya lo'o jun 'in yu tloo yu ta'a mda'an Jesús, ycui' lyi'o yu 'in Ndiose, lo' mdi'in tyaa yu yaa' yu que. ");
INSERT INTO cya_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tsa nducua lyee la nguia nguine yu'hui cha' tsu'hue 'in Ñi X'nan na quichen Jerusalén, lo' cuaña'an lyee la nchca qui'an jun nu cua' ntsu'hui cha' 'in Jesús, cui' cuaña'an tyun yu nu ndlo tñan ni' lyaa 'in ne' judio ya qui'an ti' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yu Steba can' mtsa'an yu'hui yu lo'o cha' tsu'hue 'in Ndiose, nda'an lo'o yu cha' cuiya' 'in ñi, can' cha' ngui'ni yu scasca cha' nu tnu tloo nten can'. ");
INSERT INTO cya_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yato'o tucua snan yu judio nu ndiyo' ti'in se'en nchcui' ne' lca Liberto, lo'o chcua xnan yu nu mdo'o quichen Cirene lo'o Alejandría, lo'o yu nu mdo'o se'en lca Cilicia lo'o Asia, mdyisnan ycui' tyijyin ne' lo'o yu Steba can'. ");
INSERT INTO cya_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","A ngujlyo 'a ti' ne' ña'an ti' xcuen ne' 'in yu, si'yana lo'o cha' tiyaa nchcui' yu si'ya cha' cuiya' nu mdaa Espíritu 'in Ndiose 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Xacan' msu'hua lyiya' ne' 'in tucua snan nu chcui' si'yana ngune 'in ña'an mdaja yu Steba can' 'in Moisé lo'o 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Si'ya cha' cuiñi can' nguilo ti'in nten, qui'yu cula lo'o ne' escriba. Siya' ngu'ya ti ne' msñi ne' 'in yu Steba can', lo' ya lo'o ne' 'in yu se'en nu ntsu'hui cha' ca cuiya' cha' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ngulo ton ne' chcua xnan nu chcui' cha' cuiñi: Yu re a ndla' ti' yu nchcui' ca'an yu 'in laa nu luhui 'in na, a cunta lo'o cha' 'in lee ndaja yu. ");
INSERT INTO cya_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ngune 'in hua juin yu si'yana Jesús Nazaret ntsu'hui cha' cujlyo yu se'en re, lo' xitsa'an yu nchgaa ña'an cha' nu ngulo'o Moisé 'in na. ");
INSERT INTO cya_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nchgaa nu nducua se'en nchca cuiya' qui'ya can', mxina'an ne' tloo yu Steba can', lo' ncua chcan' tloo yu tsaña'an tloo angujle. ");
INSERT INTO cya_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yu nu ndlo ca tñan ni' lyaa can' mñicha' 'in yu Steba: ¿Ta cha' ñi ña'an nchcui' nchgaa yu re cha' 'in? ");
INSERT INTO cya_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Xacan' mdyisnan ycui' yu Steba: 'Un nu lca nten cula 'in na, quine 'in um cha' nu chcuin'. Ndiose ñi nu tlyu lati ngulo'o tloo 'in nten cula 'in na nu ncua naan Abraham se'en lca Mesopotamia, xa nu ti' lyijyi tsa ti'in yu se'en lca Harán, ");
INSERT INTO cya_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","lo' juin Ndiose 'in yu: —Xnu yuu quichen tyi, tyi'o tso' lja ta nten 'in, lo' tsa ti'in xca loo yuu se'en nu nan' quitsan' 'in—. ");
INSERT INTO cya_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Xacan' mdo'o yu Abraham se'en ndi'in ne' caldeo, mdiya ti'in yu quichen Harán, lo' xa ngujui sti yu mxitsa'an ti'in Ndiose 'in yu loo yuu se'en ndi'in na cua' ñii. ");
INSERT INTO cya_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","—Ñi se'en qui'ya ton sca tso' quiya' ti yu—, a mdaa ñi cha' cuiya' culo yu tñan. —Una mdi'in tyaa ñi sca cha' lo'o yu si'yana ntsu'hui cha' quinu yuu can' 'in yu lo'o sñe' yu—, siya' ñi sca sñe' yu lo' a nchca tyi'in xacan'. ");
INSERT INTO cya_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ndeña'an juin Ndiose 'in yu: —Sñe' ta nten 'in ntsu'hui cha' tsa ti'in xca loo yuu, can' xitijin ne' 'in nu ti'i lo' ca nguso 'in ne' tsani' jacua ciento yjan—. ");
INSERT INTO cya_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Una nan' cu'ni xñan bsya 'in quichen tnu can', juin Ndiose, —lo' tsa tucua xaa xitucui loo yuu se'en ntsu'hui cha' cu'ni tnu 'ñan—. ");
INSERT INTO cya_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xacan' mdi'in tyaa Ndiose sca cha' lo'o Abraham si'yana ca circuncida 'in yu, chon' nde'en can' mdaa ñi sca sñe' yu nu ncua naan Isaac, cui' cuaña'an m'ni yu lo'o Isaac xa ntsu'hui yu snu' ti tsaan, cuaña'an ya quiñan Isaac can' lo'o Jacob, lo' cuaña'an m'ni can' lo'o ta'a tichcua sñe' yu nu lca nten cula 'in na. ");
INSERT INTO cya_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Si'ya cha' jñan ti' 'in can' yato'o yjui' 'in yu See ta'a ngula se'en lca Egipto, una Ndiose a ngula yaa' ñi 'in yu See can', ");
INSERT INTO cya_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mda yaa' ñi 'in yu lo'o nchgaa nu ti'i yaan 'in yu, —mdaa ñi cha' tiyaa 'in yu lo' m'ni ñi cha' yu'hui cuiya' ti' Faraón, ree 'in ne' Egipto, 'in yu See can', ngulo ton ne' 'in yu ca yu bsya ña'aan se'en lca Egipto, tsatlyu lo'o na'an 'in ne'—. ");
INSERT INTO cya_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Chon' nde'en can' ngu'ya bju'ñan ña'aan se'en lyi'ya loo Egipto lo'o Canaán, yaan nu ti'i tnu se'en can', hasta lo'o nten cula 'in na a jui 'a na nu cunajo'o 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Xa ynan yu Jacob cha' si'yana ndi'in trigo se'en lca Egipto, ngua'an tñan yu 'in sñe' yu, cui' nu lca nten cula 'in na, si'yana tsa 'ya ne' trigo se'en can'. ");
INSERT INTO cya_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Xa nu cua' nchca tucua ya' ndyi'an ne', la xacan' mtsa' la yu See si'yana lca yu ta'a ngula ne', lo' yu'hui lyoo tsu'hue yu ree Faraón ñi ta nten lca yu See can'. ");
INSERT INTO cya_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ngulo yu See tñan 'in ta'a ngula yu, si'yana quia 'ya yu 'in Jacob nu lca sti yu lo'o nchgaa ta nten 'in yu, loo nchgaa ne' ndiyaa ne' snan yla ntsu'hui 'tñu ne'. ");
INSERT INTO cya_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Cuaña'an yato'o mdiyaa yu Jacob se'en lca Egipto, can' ngujui yu, lo' cui' cuaña'an lo'o nten cula 'in na. ");
INSERT INTO cya_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xa mdo'o ne' can' nguian lo'o ne' tijyan nten cula 'in na se'en lca Siquem, mdi'in tyaa ne' 'in na ni' tuquee nu yjui' sñe' Hamor 'in Abraham nu ncua nten cula 'in na. ");
INSERT INTO cya_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Lja mdi'in ne' quichen Egipto lyee yton ne', una Ndiose a ngujlya ti' ñi ña'an cha' nu cua' mdi'in tyaa ñi lo'o Abraham, ");
INSERT INTO cya_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","yato'o mdo'o ton xca ree se'en lca Egipto, una a yu'hui lyoo 'a yu cha' 'in yu See can'. ");
INSERT INTO cya_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yu ree can' lo'o cha' cuiñi ngunan yu ña'an nu xitijin yu 'in ne' nu ti'i, lo' ngulo yu tñan 'in ne' si'yana xcuan ne' sñe' ne' si'yana a cuton 'a ne'. ");
INSERT INTO cya_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lja xacan' ncua cune' yu Moisé, can' nu yu'hui cuiya' ti' Ndiose 'in, lo' tsani' snan coo' nten cula 'in yu m'ni co'o 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Una ngula yaa' jun 'in yu si'ya cha' nu mdi'in tyaa ree can', yato'o ticuii' sñe' ree Faraón nu cuna'an mchcuan cunta 'in yu, m'ni co'o ne' 'in yu ña'an nchca ti' sca sñe' ca ne'. ");
INSERT INTO cya_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moisé can' m'ni cha'an yu tsaña'an cha' 'in ne' Egipto, lo' mdon lo'o yu sca cha' cuiya' nu tlyu. ");
INSERT INTO cya_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Xa ntsu'hui yu tucua yla yjan, ncua lca tiquee yu tsa na'an yu se'en ndlyu ta'a yu, ne' Israel. ");
INSERT INTO cya_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Xa na'an yu si'yana sca ne' Egipto ndyijui ti'in ne' 'in ta nten 'in yu, cui' xaa ngula yu 'in lo' yjui yu 'in ne' Egipto can'. ");
INSERT INTO cya_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nguñan ti' yu si'yana nchgaa ta nten 'in yu qui'ya cha' tiyaa si'yana Ndiose lca nu ngua'an tñan 'in yu nu culaa yu 'in ne', una a nguñan ti' ne' cuaña'an. ");
INSERT INTO cya_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Xca tsaan can' mdiyaa yu se'en nsuun tucua yu qui'yu, msu'hue yu cusuun can', lo' juin yu: Sca ta ti nten lca um, ¿ñi cha' ta nsuun um? ");
INSERT INTO cya_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yu nu nsuun can' mducua yaa' yu 'in yu Moisé, lo' juin yu 'in: ¿—Ti nu mdi'in tyaa 'in lca sca bsya uta sca bse lja hua re? ");
INSERT INTO cya_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ta na ñan ti' cujui 'ñan ña'an yjui 'in sca yu Egipto lca—? ");
INSERT INTO cya_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Xa ngune 'in yu cha' can', msnan yu lo' mdiyaa yu xca loo yuu se'en lca Madián, can' jui cuilyi'o yu lo' mdi'in tucua sñe' yu. ");
INSERT INTO cya_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Tucua yla yjan mdijin, yu Moisé nda'an yu sca se'en ngutyi se'en nducua qui'ya Sinai, can' ngulo'o tloo sca angujle 'in yu loo quii' ndiquin lja yca quiche' can'. ");
INSERT INTO cya_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yuhue 'a ti' yu xa na'an yu cha' can', ya ton yu cui' la si'yana cu'ni quii tsu'hue yu 'in na, xacan' ngune 'in yu ycui' Ñi X'nan na: ");
INSERT INTO cya_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","—Nan' lcan Ndiose 'in nten cula 'in, Ndiose 'in Abraham, Ndiose 'in Isaac, Ndiose 'in Jacob. Mdyisnan mchcuan yu Moisé lo' a mxina'an 'a yu se'en ndiquin can'—. ");
INSERT INTO cya_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lo' juin Ñi X'nan na 'in yu: —Lyoo quinan ntsu'hui quiya' si'yana se'en luhui 'a ndon. ");
INSERT INTO cya_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nan' cua' na'an lo' jlyo tin' si'yana cha' ñi ndijin sñe' nu ti'i se'en lca Egipto, cua' ngune 'ñan tsaña'an nu njñan ne' 'ñan, lo' ngu'ya ton si'yana culo laan 'in ne'. Can' cha' cua' ñii ca'an tñan 'in tsaa se'en lca Egipto—. ");
INSERT INTO cya_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yato'o yu nu mscuan tloo ne' 'in xa juin ne': ¿Ti nu mdi'in tyaa 'in lca sca bsya uta sca bse lja hua? Can' yu nu ngua'an tñan Ndiose 'in xa ngulo'o tloo angujle 'in yu se'en ndiquin yca quiche' can', si'yana ca yu sca nu ndon loo lati nu culo laa 'in ta nten 'in yu tuyaa' ne' Egipto. ");
INSERT INTO cya_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mdo'o lo'o yu 'in ne' se'en lca Egipto xa m'ni yu scasca cha' nu tnu, lo'o se'en lca tujo'o nga'á, cui' cuaña'an loo yuu ngutyi se'en mda'an ne' tsani' tucua yla yjan. ");
INSERT INTO cya_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Cui' Moisé lca nu juin 'in ne' Israel: Lja ta nten 'in na, Ndiose X'nan na, ntsu'hui cha' xiton ñi sca nu xiycui' ñi 'in tsaña'an nchcuin' lo'o um cua' ñii, can' nu cu'ni cunta um cha' nu chcui'. ");
INSERT INTO cya_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Cui' Moisé can' lca nu mdon lja nten cula 'in na se'en nguio' ti'in ne' Israel loo yuu ngutyi can', xa ycui' sca angujle lo'o yu loo qui'ya Sinai, lo' mchcuan yu cunta cha' tsu'hue nu taa chendyu 'in na. ");
INSERT INTO cya_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Una nten cula 'in na a ncua ja'an ne' 'in yu, cui' ca nu nde mscuan tloo ne' 'in yu, lo' ncua lca tiquee ne' xitucui ne' se'en lca Egipto, ");
INSERT INTO cya_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","xa juin ne' 'in yu Aaron: —Tñan um lcuin jo'o 'in hua nu chcua loo se'en nguiaa hua, si'yana yu Moisé nu ngulyoo 'in hua se'en lca Egipto, a jlyo ti' hua ñi na ncua 'in yu—. ");
INSERT INTO cya_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Xacan' mtñan ne' sca lcuin bta cune' nu ca jo'o x'nan ne', lo' mdiquin tucua ne' 'ni tloo can', lo' si'ya na nu mtñan yaa' ne' can', tsu'hue ntsu'hui tiquee ne' ngui'ni ne' ta'a. ");
INSERT INTO cya_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Can' cha' Ndiose ngula yaa' 'in ne', lo' mdyisnan m'ni tnu ne' na nu nducua ni' cuaan, cui' tsaña'an cha' nu mxiycui' Ndiose 'in yu nu ngua'an scua quityi cua' s'ni: —Un ne' Israel, ¿ta ñan ti' um si'yana 'ñan nan' m'ni tnu um xa mdiquin tucua um scasca 'ni tloo jo'o x'nan um xa mda'an um loo yuu ngutyi tsani' tucua yla yjan? ");
INSERT INTO cya_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ngu'ya um sca te' na'an 'in jo'o Moloc, lo'o lcuin cuii nu lca jo'o x'nan um Renfán, lcuin nu mtñan yaa' nten m'ni tnu um. Can' cha' cua' ñii cu'nin cha' tsa lo'o ne' 'in um sca se'en tijyo' lati que 'in Babilonia—. ");
INSERT INTO cya_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Cui' cuaña'an mda'an lo'o nten cula 'in na te' na'an nu nguia' xa mdi'in tyaa Ndiose cha' lo'o ne' se'en ngutyi can', lo' mtñan yu Moisé 'in na chcui ña'an ngulo Ndiose tñan 'in yu, tsaña'an lcuin nu na'an xñii yu. ");
INSERT INTO cya_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","A cunta mdiya lo'o ne' te' na'an can' xa yten Josué loo yuu 'in ne' gentil, lo' mchcuan yu cunta 'in na si'yana Ndiose lca nu m'ni cha' mdo'o ne' se'en can', can' mdi'in te' na'an can' tsaya' mdiyaa tsaan nu ngulo yu Davi tñan. ");
INSERT INTO cya_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Can' yu nu yu'hui cuiya' ti' Ndiose 'in, lo' mjñan yu cha' cuiya' cha' tca tñan yu sca se'en tyi'in ñi, cui' Ndiose 'in Jacob. ");
INSERT INTO cya_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Una yu Salomón m'ni yu cha' nguia' sca laa 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Cha' ñi si'yana Ndiose, ñi nu tlyu lati nducua ni' cuaan, a ndyi'in ñi ni' lyaa mtñan yaa' nten chendyu, tsaña'an nchcui' quityi nu ngua'an scua nguso 'in ñi cua' s'ni: ");
INSERT INTO cya_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","—Ni' cuaan lca na se'en nducuan, lo' chendyu re lca na se'en nxitñan' quiyan', ¿ña'an ta tñan um sca na'an 'ñan, nchcui' Ñi X'nan na, uta sca se'en ntsu'hui cha' xitñan'? ");
INSERT INTO cya_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ta si'i cuin' mtñan nchgaa loo na nu chcan' loo chendyu re? ");
INSERT INTO cya_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","'Un lca um nten nu lye' ti', tla cusya 'in um, lo' nducun tunscan um—, scaña'an ti nxcuan tloo um Espíritu nu Luhui 'in Ndiose. Tsaña'an m'ni nten cula 'in na, lo' cuaña'an ngui'ni um cua' ñii. ");
INSERT INTO cya_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Ta nde'en nu mxiycui' Ndiose 'in cua' s'ni, na a mna'an ti'i nten cula 'in na? Yato'o yjui um 'in nu mda'an ycui' si'yana ntsu'hui cha' caan sca nu ñi ndi'in cha' 'in, a s'ni mdyaa um 'in ñi tuyaa' ne' nducun' lo' yjui um 'in ñi, ");
INSERT INTO cya_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","'un nu mchcuan cunta cha' 'in lee nu mdaa angujle, una a mxu'hua se'en um 'in na. ");
INSERT INTO cya_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Xa ngune 'in ne' cha' can', lyee 'a ycuen tiquee ne' lo'o yu Steba can', hasta nchcu lyi'ya ne' ndon ne'. ");
INSERT INTO cya_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Una yu Steba mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in yu, mxina'an yu nde ni' cuaan lo' na'an yu sca xaa nu tsu'hue ña'an se'en nducua Ndiose, lo' tso' cueen 'in ñi nducua Jesús. ");
INSERT INTO cya_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Lo' juin yu: Ña'an jan ñi, chcan' 'ñan nguila tucua ni' cuaan, lo' Yu Qui'yu nu Mdo'o nde ni' Cuaan nducua ñi tso' cueen 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Xacan' msi'ya yja cueen ne', lo' mducun ne' tunscan ne', lo' siya' ngu'ya ti ne' chon' yu, ");
INSERT INTO cya_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ngulo ne' 'in yu nde tu'hua quichen, can' mjyi'in ne' quee 'in yu, lo' te' tucuin nu lco' ne' mdyaa ne' cunta 'in na 'in sca yu naan Saulo. ");
INSERT INTO cya_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yu Steba can' ycui' lyi'o yu 'in Ndiose lja njyi'in ne' quee 'in yu, lo' juin yu: Jesús, 'un ñi nu lca X'nan hua, chcuan um cunta cusya 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ña'aan mdyi'ya xtyin' yu, ycui' cueen yu: Ñi X'nan hua, a cu'ni um cunta ña'an qui'ya ngui'ni ne' re lo'on. Xa mdyi ycui' yu cha' re ngujui yu. ");
INSERT INTO cya_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Yu Saulo, sca cha' ti 'in yu lo'o ne' nu yjui 'in yu Steba can'. Cuii' tsaan can' nde lyee la mxitijin ne' nu ti'i 'in jun nu cua' ya qui'an ti' 'in Jesús, jun nu ndi'in Jerusalén, cua' la tucueen ngunaan jun. Ntsu'hui jun nu mdiyaa se'en lyi'ya loo Judea lo'o Samaria, una ta'a tichcua yu ta'a mda'an Jesús, a la mdo'o yu. ");
INSERT INTO cya_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ne' nu ya tsi' 'in yu Steba can' lca ne' chacui' nten nu suun, lo' lyee ynan lo'o ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Una yu Saulo can', lyee la mxitijin yu 'in jun ta'a na nu ti'i, yten yu cunda scaa na'an, lo' ncuan quii suhue' yu 'in jun, yaa jun na'an chcuan, yu qui'yu lo'o jun cuna'an. ");
INSERT INTO cya_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jun nu cua' la tucueen ngunaan can', mdyisnan ycui' jun cha' tsu'hue 'in Jesús se'en mdiyaa jun. ");
INSERT INTO cya_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Sca yu naan Lpe mdiyaa yu quichen Samaria, lo' mdyisnan ycui' yu cha' tsu'hue 'in Cristo. ");
INSERT INTO cya_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Sca cha' ti 'in ne' ndon nscan ne' cha' nu nchcui' yu, si'yana na'an ne' cha' nu tnu ngui'ni yu, ");
INSERT INTO cya_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","si'yana xa ndlo yu cui'in xa'an ntsu'hui 'in nten, nxi'ya yja cueen ne', a cunta qui'an 'a nu ti'i m'ni chca yu, ne' nu a nchca tyi'an lo'o nu nchcun' quiya', ");
INSERT INTO cya_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","can' cha' tsu'hue 'a ntsu'hui tiquee nchgaa nten can'. ");
INSERT INTO cya_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Cui' can' ndi'in sca yu jlyo ti' naan Simón, lyee 'a cua' nguñilyi'o yu 'in ne' Samaria can', m'ni yu 'in yu si'yana lca yu sca nu ndon loo 'a. ");
INSERT INTO cya_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Cula luhue ne' tsu'hue ndon nscan ne' cha' nu nchcui' yu, lo' nchcui' ne' si'yana tlyu 'a cha' cuiya' 'in Ndiose nda'an lo'o yu. ");
INSERT INTO cya_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tsu'hue n'ni cunta ne' cha' can', si'yana cua' s'ni ñilyi'o yu 'in ne' lo'o cha' jlyo ti' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Una xa ycui' yu Lpe can' cha' tsu'hue 'in Jesucristo ña'an ntsu'hui cha' culo Ndiose tñan, ya qui'an ti' ne' lo' mducua tya ne', yu qui'yu lo'o jun cuna'an. ");
INSERT INTO cya_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Lo'o yu Simón ya qui'an ti' yu lo' mducua tya yu, lo' mdyisnan mda'an yu lo'o yu Lpe can', nduhue 'a ti' yu ña'an cha' nu tnu ngui'ni yu. ");
INSERT INTO cya_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Una yu ta'a mda'an ca Jesús, yu nu ndi'in Jerusalén, xa ynan yu cha' si'yana lo'o ne' Samaria cua' ncuan xu'hue ne' cha' 'in Ndiose, cui' xaa ngua'an tñan yu 'in yu Tyo lo'o yu Xuhua si'yana tsaa yu se'en can'. ");
INSERT INTO cya_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Xa mdiyaa yu can' ycui' lyi'o yu 'in Ndiose, si'yana lo'o ne' Samaria cha'an yu'hui Espíritu nu Luhui 'in Ndiose 'in ne', ");
INSERT INTO cya_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","si'yana ti' lyijyi chu'hui ñi ni' cusya 'in ne', cui' ca nu mducua tya ne' lo'o cha' cuiya' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Xacan' chcuaa yu mdi'in tyaa yu yaa' yu 'in ne', cui' ña'an lcaa mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Una xa na'an yu Simón si'yana tsaloo ndi'in tyaa ti yu yaa' yu 'in ne' lo' nchcuan ne' Espíritu nu Luhui 'in Ndiose, xacan' ncua ti' yu xi'i yu cha' cuiya' can', ");
INSERT INTO cya_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","lo' juin yu: Lo'on nan' nchca tin' taa um cha' cuiya' re 'ñan, si'yana xa tyi'in tyaan yaan' 'in ña'an nu ti, lo'o can' chcuan Espíritu nu Luhui 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Xacan' mxcuen yu Tyo can' 'in yu Simón: Tsato'o quinan' nu'huin lo'o tñi 'in, si'yana ñan ti' tca caja cha' tsu'hue 'in Ndiose lo'o tñi. ");
INSERT INTO cya_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A ntsu'hui cha' qui'ni ca'an cha' cuiya' re 'in, ñi a mdiyaa xu'hue lo'o cha' re, si'yana a ñi ndi'in cha' 'in tloo Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Xilo'o chon' qui'ya 'in lo' jñan 'in Ndiose, tina'an ti' cu'ni ñi cha' tlyu ti' 'in lo'o ña'an nu ñan ti' cusya 'in. ");
INSERT INTO cya_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nan' jlyo tin' si'yana tla 'a cusya 'in, qui'ya 'in mducun na cha' tiyaa 'in. ");
INSERT INTO cya_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mxcuen yu 'in Simón can': Jñan um 'in Ñi X'nan na si'ya cha' 'ñan, si'yana a sca cha' nu ycui' um cua caan 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Xa mdyi ycui' yu Tyo lo'o yu Xuhua cha' 'in Ndiose lo'o ne' Samaria, mxitucui yu nde Jerusalén. Qui'an 'a quichen suhue ti mdijin yu se'en lyi'ya loo Samaria, ycui' yu cha' tsu'hue 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yato'o sca angujle 'in Ñi X'nan na mdo'o ycui' lo'o yu Lpe can': Ndla ti cu'ni, lo' tsaa tucueen nu ndyi'o Jerusalén nu ndiyaa quichen Gaza, cui' tucueen nu ndyijyin loo yuu ngutyi can'. ");
INSERT INTO cya_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Cui' xaa mdo'o yu nguiaa yu. Can' na'an yu 'in sca yu Etiopía, lca yu sca yu eunuco nu ntsu'hui cunta cha' cuilyiya' ndi'in 'in Candace, ne' cuna'an 'in ree Etiopía, lo' ya y'ni tnu yu 'in Ndiose quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Xa mxitucui yu nducua ycui' yu quityi 'in Ndiose ni' carreta 'in yu, quityi nu ngua'an scua yu Isaía nu mxiycui' Ndiose 'in cua' s'ni. ");
INSERT INTO cya_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Xacan' ycui' Espíritu 'in Ndiose lo'o yu Lpe: Ya ycua 'in carreta cua. ");
INSERT INTO cya_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Xa mchcua yu carreta can', ngune 'in yu si'yana quityi ngua'an scua yu Isaía nguia ycui' yu can'. Xacan' juin yu Lpe can': ¿Ta ndyi'ya um cha' tiyaa cha' nu nchcui' quityi cua? ");
INSERT INTO cya_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mxcuen yu 'in: ¿Ña'an ta qui'yan cha' tiyaa cha' a caja nu quitsa' 'ñan? Xacan' mjñan yu cha' tsu'hue 'in yu Lpe can' si'yana chcua sca se'en ti lo'o yu. ");
INSERT INTO cya_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Quityi 'in Ndiose se'en nchcui' yu can' nchcui' na: —Ya lo'o ne' 'in ñi ña'an nchca ti' sca slya' se'en ntsu'hui cha' cujui ne' 'in 'in. Lo' ña'an nchca ti' sca slya' cune' nu a nxi'ya xa nsi'yu ne' quichan', cuaña'an m'ni co'on ñi 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xa mdijin ñi nu ti'i, a jui nu tyi'o cha' 'in ñi. A sca ta nten 'in ñi tca taa suun cha' 'in ñi, si'yana cui' xaa jui nu ngulyoo 'in ñi loo chendyu re—. ");
INSERT INTO cya_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Xacan' juin yu eunuco 'in yu Lpe can': Cu'ni um cha' tsu'hue quitsa' um 'ñan, ¿ti nu 'in cha' nchcui' na, ta nchcui' yu cha' 'in yu ticuii' yu, uta na nchcui' yu cha' 'in xca tucui? ");
INSERT INTO cya_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ticui' loo quityi nu nchcui' yu can' mdyisnan ycui' yu Lpe cha' tsu'hue 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tucueen nguiaa yu can', mdiyaa yu sca se'en ntsu'hui tyi'a, lo' juin yu 'in yu Lpe can': Nde ntsu'hui tyi'a. ¿Ta ndyijyi ña'an cha' chcua tyan cua' ñii? ");
INSERT INTO cya_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mxcuen yu Lpe can': Tca na cha' 'un ndiya qui'an ti' um lo'o nu chcui cusya 'in um. Lo' juin yu: Ndiya qui'an tin' si'yana Jesucristo lca ñi Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Cui' xaa ngulo yu tñan si'yana xican' ton ne' carreta can', chcuaa yu ngu'ya ton yu lo' yten yu loo tyi'a, xacan' mducua tya yu Lpe can' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ña'aan mdyi'o yu loo tyi'a can', a ncua chcan' 'a yu Lpe can' si'yana Espíritu 'in Ñi X'nan na nguia lo'o 'in yu, una tsu'hue 'a ntsu'hui tiquee yu eunuco can' nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Lo' xa ngüi ti' yu Lpe can' cua' ndon yu quichen Azoto, lo' mda'an ycui' yu cha' tsu'hue 'in Jesús cunda scaa quichen mdijin yu tsaya' mdiyaa yu se'en lca Cesarea. ");
INSERT INTO cya_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","u Saulo can', nde lyee la ycuen tique' yu lo'o jun nu cua' ntsu'hui cha' 'in Ñi X'nan na, nu ncua ti' yu cujui yu 'in jun, can' cha' yaa yu se'en ndi'in yu nu ndlo ca tñan ni' lyaa, ");
INSERT INTO cya_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","lo' mjñan yu quityi cha' cuiya' nu tsa lo'o yu 'in na scasca se'en ndiyo' ti'in ne' judio quichen Damasco, se'en nu quinu jun nu cua' ntsu'hui tucueen 'in Jesús, yu qui'yu uta ne' cuna'an, lo' quian lo'o yu 'in jun nde Jerusalén nu chu'hui jun na'an chcuan. ");
INSERT INTO cya_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Cua' tiyaa ti yu quichen Damasco xa nu tsati ntyin msti sca xaa nu mdo'o la ni' cuaan, lo' msu'hua lo'o na 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Can' mdlyu yu, lo' ngune 'in yu jui sca nu ycui': Saulo, Saulo, ¿ñi cha' nda'an y'ni lyi'o 'ñan? ");
INSERT INTO cya_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Xacan' juin yu: ¿Tucui ca lca 'un Ñi X'nan hua? Mxcuen ñi 'in yu: Nan' lcan Jesús nu nda'an y'ni lyi'o. ¿Ta a jlyo ti' si'yana ticuii' ngui'ni nu ti'i lo'o, ña'an nu ngui'ni cua? ");
INSERT INTO cya_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mdyisnan mchcuan yu si'yana lyee ytsen yu, lo' juin yu: Ñi X'nan hua, ¿ñi na ta nchca ti' um cu'nin? Xacan' juin Ñi X'nan na 'in yu: Tyiton lo' sten loo quichen cua, la cua caja nu quitsa' 'in ña'an ntsu'hui cha' cu'ni. ");
INSERT INTO cya_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yu ta'a nda'an yu Saulo can', lyee ytsen yu si'yana ngune ca 'in yu ña'an jui nu ycui', una a tucui na'an yu. ");
INSERT INTO cya_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Mdyiton yu Saulo lo' msla yu quiloo yu, una a ncua chcan' 'a 'in yu. Ta'a nda'an yu can' msñi yaa' yu, lo' yten lo'o 'in yu quichen Damasco. ");
INSERT INTO cya_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Can' mdi'in yu snan tsaan a ncua chcan' 'a 'in yu, ñi a ycu 'a yu, ñi a yi'o 'a yu. ");
INSERT INTO cya_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Una quichen Damasco can' ndi'in sca yu nu cua' ntsu'hui cha' 'in Jesús, naan yu Ananía. Ñi X'nan na m'ni ñi cha' na'an xñii yu sca cha', lo' juin ñi: Ananía. Mxcuen yu 'in ñi: Nde ndon, Ñi X'nan hua. ");
INSERT INTO cya_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Xacan' juin Ñi X'nan na 'in yu: Tyiton, lo' tsaa tucueen nu naan Ñi Ya', lo' ña'an 'in yu Juda quia nan 'in sca yu mdo'o quichen Tarso nu naan Saulo, si'yana nchcui' lyi'o yu 'ñan, ");
INSERT INTO cya_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","lo' cua' ñii na'an xñii yu si'yana mdiyaa sca yu naan Ananía se'en ndi'in yu, lo' mdi'in tyaa yaa' 'in yu si'yana quila xaa quiloo yu. ");
INSERT INTO cya_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Xacan' mxcuen yu Ananía: Ñi X'nan hua, lyee 'a cua' ynan cha' 'in yu cua, tsala ña'an cua' mxitijin yu 'in jun nu ti'i, nu cua' ngulohui um nu ndi'in quichen Jerusalén, ");
INSERT INTO cya_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","lo' mdiyaan yu nde re lo'o cha' cuiya' 'in yu nu ndlo ca tñan ni' lyaa can', si'yana scan' yu 'in nchgaa nu ndiya qui'an ti' 'in um. ");
INSERT INTO cya_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lo' juin Ñi X'nan na 'in yu: Yaa lya, si'yana lca yu sca nu cua' mdo'o hui 'ñan, si'yana tsa ycui' yu cha' tsu'hue 'ñan tloo ree lo'o ne' gentil, a cunta lo'o ne' Israel. ");
INSERT INTO cya_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nan' quitsan' 'in yu tsala nu ti'i ntsu'hui cha' tyijyin yu si'yan. ");
INSERT INTO cya_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Xacan' mdo'o yu Ananía nguiaa yu, lo' yten yu ña'an can'. Mdi'in tyaa yu yaa' yu 'in yu Saulo can', lo' juin yu: Ñi ta'a na Saulo, Jesús ñi nu lca X'nan na, ñi nu ngulo'o tloo 'in um tucueen yaan um, ngua'an tñan ñi 'ñan si'yana quila xaa quiloo um, a cunta cha'an yu'hui Espíritu nu Luhui 'in Ndiose 'in um. ");
INSERT INTO cya_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ticui' xaa can', mdo'o tyu sca na quiloo yu ña'an nchca ti' x'ñan cula, cui' ña'an lcaa nguila xaa quiloo yu, mdyiton yu lo' mducua tya yu. ");
INSERT INTO cya_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mdyisnan ycu yu, lo' cuaña'an nguila juesa 'in yu. Ti' nguinu yu chcua xnan tsaan lo'o jun nu ndi'in quichen Damasco. ");
INSERT INTO cya_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Xacan' mdyisnan ycui' yu cha' tsu'hue 'in Cristo cunda scaa se'en ndiyo' ti'in ne' judio, lo' nchcui' yu si'yana cui' ñi lca ñi Sñe' Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yuhue 'a ti' ne' 'in yu, lo' nchcui' ne': ¿Ta si'i yu re lca yu nu mxitijin 'in jun nu ti'i, nu cua' ya qui'an ti' 'in Jesús quichen Jerusalén? ¿Ta si'i can' cha' ca mdiyaan yu re si'yana scan' yu 'in ne', lo' quia lo'o yu 'in ne' tloo yu nu ndlo ca tñan ni' lyaa quichen Jerusalén? ");
INSERT INTO cya_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Una yu Saulo can' nde lyee la ycui' yu lo'o ne' judio nu ndi'in quichen Damasco. Ngulyo scua la yu cha' 'in Jesús si'yana cui' ñi lca ñi Cristo, lo' a ngujlyo 'a ti' ne' ñi lyijyi cha' ti' quiñan ti' ne'. ");
INSERT INTO cya_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cua' yaa ña'an ndijin tsaan can', mdya ycui' ne' judio nu ndi'in quichen can' si'yana cujui ne' 'in yu Saulo, ");
INSERT INTO cya_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","una jui nu mtsa' 'in yu cha' can'. Tla lo' cucha ntsu'hui ta ne' 'in yu tuna'an se'en ntsu'hui cha' tyi'o yu tu'hua quichen can' si'yana cujui ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Xacan' jun nu cua' ntsu'hui cha' 'in Jesús, msu'hua jun 'in yu sca ni' xcuhui, lo' tla can' mdyi'ya jun 'in yu lo'o sca tiso tu'hua quee chon' lo'o can'. ");
INSERT INTO cya_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Una xa nguila yu quichen Jerusalén, ncua ti' yu quio' ti'in yu lo'o jun nu cua' ntsu'hui cha' 'in Jesús, una nchgaa jun ytsen jun 'in yu, a ya qui'an ti' jun si'yana lo'o yu cua' ntsu'hui yu cha' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Xacan' yu Bernabé ya lo'o 'in yu se'en ndi'in yu ta'a mda'an Jesús, lo' mdaa yu suun si'yana yu Saulo cua' na'an yu 'in Ñi X'nan na tucueen yaa yu quichen Damasco lo' ycui' ñi lo'o yu, a cunta m'ni tnu tiquee yu ycui' yu cha' tsu'hue 'in Jesús lo'o nten ndi'in can'. ");
INSERT INTO cya_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Cuaña'an mdyisnan mda'an yu Saulo lo'o jun nu cua' ntsu'hui cha' 'in Jesús quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A ntsen yu nchcui' yu cha' 'in Ñi X'nan na, nu hasta nxicune ta'a yu lo'o ne' judio nu nchcui' cha' griego, lo' ngunan ne' ña'an nu cujui ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Xa ynan jun ta'a na cha' can', ya lo'o jun 'in yu se'en lca Cesarea, xacan' ngua'an tñan jun 'in yu quiaa yu quichen Tarso. ");
INSERT INTO cya_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","La xacan' nchgaa laa mdi'in tiin na, jun nu ndiyo' ti'in se'en lca Judea, Galilea, lo'o Samaria. Cuaña'an tsa nducua lyee la nguia nguilo jun, ntsu'hui sca ytsen 'in Ñi X'nan na ni' cusya 'in jun, lo' Espíritu nu Luhui 'in Ndiose ndaa cha' tnu tiquee 'in jun, lo' cuaña'an nguia nguiton la jun nchgaa se'en. ");
INSERT INTO cya_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Yato'o mdijin yu Tyo scasca se'en ndi'in jun nu cua' mdo'o hui 'in Jesús, lo' mdiyaa yu se'en ndi'in jun quichen Lida. ");
INSERT INTO cya_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Can' na'an yu 'in sca yu naan Enea, nu cua' ntsu'hui snu' yjan nscua ti'i loo qui'ñan, lo' a nchca tyi'an yu. ");
INSERT INTO cya_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Xacan' juin yu Tyo 'in yu: Enea, Jesucristo cu'ni chca ñi 'in um cua' ñii, tyitucui um lo' cu'ni chu'hue um loo s'ñan um. Ticui' xaa mdyitucui yu. ");
INSERT INTO cya_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nchgaa ne' ndi'in quichen Lida lo'o Sidón na'an ne' si'yana mchca yu, lo' ya qui'an ti' ne' 'in Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Quichen Jope ndi'in sca ne' cuna'an nu cua' ntsu'hui cha' 'in Jesús, lo' naan ne' Tabita, lo' cha' re nchca ti' chcui': Dorca. Qui'an 'a cha' tsu'hue m'ni ne', mda yaa' ne' 'in nu ti'i ña'an 'in, cui' cuaña'an lo'o lcuan. ");
INSERT INTO cya_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lja xacan' ncua ti'i ne' lo' ngujui ne'. Xa nu cua' mxicuta ne' 'in, ycuen lo'o ne' 'in se'en cua' nchca tucua na'an nde cuaan, se'en ntsu'hui cha' xcua yuu. ");
INSERT INTO cya_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A tijyo' nguinu quichen Lida se'en lca Jope can', lo' ynan jun ta'a na cha' si'yana quichen Lida ndi'in yu Tyo, cui' xaa ngua'an tñan jun tucua nu tsa te'en 'in yu si'yana jñan cha' tsu'hue 'in yu tsaa yu cui' xaa. ");
INSERT INTO cya_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mdo'o yu Tyo can', nguiaa lo'o chcuaa yu can' nde quichen Jope, mdiyaa jun se'en nducua na'an can' lo' ycuen lo'o jun 'in yu se'en nscua nu ngujui can'. Nchgaa ne' cuna'an nu nguinu lo'o cha' ycui' ti ndi'in ynan ne', msu'hua lo'o ne' 'in yu Tyo lo' mdyisnan ngulo'o ne' scasca loo te' nu mxcuan Dorca xa nu ti' lo'o. ");
INSERT INTO cya_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ngulo yu Tyo can' 'in nchgaa ne' nde lyiya'. Mdyi'ya xtyin' yu lo' mjñan yu 'in Ndiose. Xacan' mxina'an yu se'en nscua nu ngujui can', lo' juin yu: Tabita, tyiton. Ticui' xaa msla ne' quiloo ne'. Xa na'an ne' 'in yu Tyo can', cui' xaa mdyi tucua ne', ");
INSERT INTO cya_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","msñi yu yaa' ne', lo' mxiton yu 'in ne'. Xacan' mxi'ya yu 'in nchgaa jun ta'a na lo'o ne' nu nguinu lo'o cha' ycui' ti can', lo' na'an jun si'yana cua' mdyiqui'o nu Dorca can'. ");
INSERT INTO cya_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mscua cueen cha' can' sca chcui quichen Jope, lo' qui'an 'a nten ya qui'an ti' 'in Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tyun 'a tsaan ti' nguinu yu Tyo can' quichen Jope, na'an 'in yu Simón cuityi quijyin can'. ");
INSERT INTO cya_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Quichen Cesarea ndi'in sca yu naan Cornelio, lca yu que 'in sca ciento sindatu, cui' ta nu naan Italiana. ");
INSERT INTO cya_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Suun 'a nten lca yu lo'o sñe' yu, n'ni tnu yu 'in Ndiose. Lyee 'a ndaa yu lcuan 'in ne' judio, lo' nchgaa xaa nchcui' lyi'o yu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yato'o sca tsaan, tsa ntsu'hui braa cua' snan siin, na'an xñii yu yten sca angujle 'in Ndiose se'en ndi'in yu, lo' juin 'in yu: Cornelio. ");
INSERT INTO cya_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Xacan' mxina'an tsu'hue ca yu 'in angujle can', lo' nguitsen yu mxcuen yu: ¿Ñi na nchca ti' um cu'nin, Ñi X'nan hua? Mxcuen angujle can' 'in yu: Nchgaa cha' nu cua' ycui' lo'o Ndiose lo'o cha' tsu'hue nu cua' m'ni, cua' mchcuan ñi cunta 'in na. ");
INSERT INTO cya_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Can' cha' cua' ñii, ca'an tñan tucua snan nguso 'in tsaa quichen Jope, tsa te'en yu 'in yu Simón, yu nu nchcui' ne' lo'o lca Tyo. ");
INSERT INTO cya_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Cua' ñii ndi'in yu na'an 'in Simón, yu cuityi quijyin nu nducua na'an 'in cui' ti tu'hua tyi'a tujo'o. Cui' yu quitsa' yu 'in, ñi tñan ntsu'hui cha' cu'ni. ");
INSERT INTO cya_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Xa ngulyijyi yu'hui angujle can', cui' ña'an lcaa msi'ya Cornelio 'in tucua nguso 'in yu, lo'o sca sindatu nu ja'an la 'in yu nu n'ni tnu 'in Ndiose, ");
INSERT INTO cya_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","mtsa' yu 'in ta'a snan yu can' nchgaa cha' nu yato'o 'in yu, lo' ngua'an tñan yu 'in nguiaa quichen Jope. ");
INSERT INTO cya_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Xca tsaan can', xa nu cua' tiyaa ti yu tu'hua quichen Jope can', tsa ntsu'hui ndyi'ya cuan xa ycuen yu Tyo can' nde que na'an se'en ndi'in yu, si'yana chcui' lyi'o yu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mdyisnan nguite' ti' yu lyee ya', lo' lja nta yu nu nchca tsu'hue na nu cu yu, Ndiose m'ni ñi cha' na'an xñii yu sca cha'. ");
INSERT INTO cya_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Na'an yu nguila nde ni' cuaan, can' nguiaan ña'an nchca ti' sca te' xeen nu nchcan' ta'a jacua nscan, ndyi'ya na nde lyuu. ");
INSERT INTO cya_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ni' te' can' ntsu'hui cuati loo 'ni, lo'o 'ni nu nsuhue' ni', a cunta lo'o 'ni nducua jlyu'hue. ");
INSERT INTO cya_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ngune 'in yu jui sca nu ycui': Tyo, tyiton lo' cujui 'ni re, lo' cu 'in 'in. ");
INSERT INTO cya_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lo' juin yu Tyo can': Ñi X'nan hua, a cun 'in 'in si'yana a nchca siya' cun cunan' 'ni nu a ntsu'hui cha' nchcu hua. ");
INSERT INTO cya_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Xiya' jui nu ycui' lo'o yu: Nchgaa na nu cua' msuhui Ndiose, a chcui' si'yana coo' na. ");
INSERT INTO cya_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Xa cua' nchca snan ya' jui nu ycui' can', xacan' mchcuen te' can' nde ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lja ndon yuhue ti' yu Tyo cha' can', ñi cha' nchca ti' na chcui' na, xa mdiyaa nguso nu ngua'an tñan Cornelio tuna'an, ñicha' yu la ca nducua na'an 'in yu naan Simón. ");
INSERT INTO cya_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mñicha' yu cha' can' ndi'in yu Simón, nu nchcui' ne' lo'o lca Tyo. ");
INSERT INTO cya_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ti' ndon yuhue la ti' yu Tyo cha' can' xa ycui' Espíritu 'in Ndiose lo'o yu: Nde cua' mdiyaan snan yu nda'an nan 'in. ");
INSERT INTO cya_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Qui'ya lya, a cu'ni tucua ti' tsaa lo'o yu, si'yana nan' ngua'an tñan 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Xacan' ngu'ya yu Tyo can' se'en ndon nguso nu ngua'an tñan Cornelio, lo' juin yu 'in: Nan' lcan yu nu nda'an nan um, cha' ñi tñan ljyaan um? ");
INSERT INTO cya_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mxcuen yu 'in yu Tyo can': Yu Cornelio, nu lca que 'in sca ciento sindatu, sca yu nu suun ndi'in cha' 'in, lo' n'ni tnu yu 'in Ndiose, a cunta nchgaa ne' judio ndyu'hui cuiya' ti' ne' 'in yu, lo' sca angujle 'in Ndiose cua' mdaa suun lo'o yu si'yana ntsu'hui cha' tsaa um se'en ndi'in yu, lo' quine 'in yu cha' nu chcui' um. ");
INSERT INTO cya_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Xacan' mxi'ya yu Tyo 'in yu nde ña'an lo' can' nguinu yu. Xca tsaan can' mdo'o yu nguiaa yu lo'o yu can', lo'o chcua xnan jun ta'a na nu ndi'in Jope. ");
INSERT INTO cya_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","La xca tsaan can' mdiyaa jun quichen Cesarea, lo' yu Cornelio cua' mxo' ti'in ta'a yu lo'o nchgaa nten 'in yu, lo'o nchgaa ta'a tsu'hue yu. ");
INSERT INTO cya_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Xa mdiyaa yu Tyo can' tuna'an 'in yu Cornelio, cui' xaa mdo'o yu, mdon xtyin' yu tloo, lo' m'ni tnu yu 'in. ");
INSERT INTO cya_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Una yu Tyo can' cui' xaa mxiton yu 'in, lo' juin yu: Tyiton um si'yana nten chendyu lcan na lo'o um. ");
INSERT INTO cya_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Xa cua' ycui' cha' ta'a jun, xacan' yten jun ña'an, lo' na'an yu si'yana qui'an 'a nten cua' nguio' ti'in can'. ");
INSERT INTO cya_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Lo' juin yu Tyo: Nchgaa um cua' jlyo ti' um si'yana a ntsu'hui cha' quio' ti'in ne' judio sca se'en ti lo'o xca ta nten. Una Ndiose cua' ngulo'o ñi 'ñan si'yana a ntsu'hui cha' culo'o naan hua 'in ñi sca tucui si'yana lca ne' nten nu a luhui. ");
INSERT INTO cya_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Can' cha' a m'ni lye' tin' xa mdiyaa yu nu ya te'en 'ñan, lo' cua' ñii nchca tin' ca jlyo tin' ñi cha' msi'ya um 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Xacan' mxcuen yu Cornelio: Cua' ntsu'hui jacua tsaan, cui' ña'an braa cua' ñii, ngui'nin ayuna lo' nchcuin' lyi'on 'in Ndiose, cui' braa cua' snan siin mdiya ton sca yu qui'yu nu tsu'hue ña'an nduhui ste', ");
INSERT INTO cya_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","lo' juin 'ñan: Cornelio, nchgaa cha' nu cua' mjñan 'in Ndiose cua' mdiyaa na tloo ñi, cui' cuaña'an lo'o nchgaa lcuan nu cua' mdaa. ");
INSERT INTO cya_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ca'an tñan 'in nu tsa te'en 'in yu Simón quichen Jope, yu nu nchcui' ne' lo'o lca Tyo, yu nu ndi'in na'an 'in Simón, yu cuityi quijyin nu ndi'in cui' ti tu'hua tyi'a tujo'o, lo' xa caan yu chcui' yu lo'o. ");
INSERT INTO cya_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Can' cha' cui' xaa msu'huan 'in yu nu ya te'en 'in um, lo' tsu'hue si'yana yaan um. Cua' ñii nguio' ti'in hua tloo Ndiose, si'yana quine 'in hua cha' nu taa ñi chcui' um. ");
INSERT INTO cya_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Xacan' mdyisnan ycui' yu Tyo can': Nu cha' ñi s'ni ngu'yan cha' tiyaa si'yana Ndiose scaña'an ti n'ni ñi 'tnan 'in nten, ");
INSERT INTO cya_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","tsu'hue ntsu'hui tiquee ñi lo'o nchgaa nu n'ni tnu 'in ñi lo' n'ni tñan tsu'hue sca chcui chendyu. ");
INSERT INTO cya_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ndiose ycui' ñi cha' tsu'hue 'in ñi lo'o huare' ne' Israel, se'en nu tyi'in tsu'hue na lo'o ñi si'ya Jesucristo, ñi nu lca X'nan nchgaa tucui. ");
INSERT INTO cya_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","'Un cua' ynan um cha' ña'an yato'o ña'aan se'en lca Judea, lo' mdyisnan cha' re ti' la se'en lca Galilea, xa nu cua' mducua tya yu Xuhua can' 'in nten, ");
INSERT INTO cya_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","lo' jlyo ti' um si'yana Ndiose mdaa ñi cha' cuiya' nu tlyu 'in Jesús Nazaret, lo' mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in ñi, lo' m'ni ñi scasca cha' tsu'hue, m'ni chca ñi 'in nchgaa nu ti'i nu ntsu'hui tuyaa' laxa'an, cui' si'yana Ndiose ndon lo'o ñi nchgaa xaa. ");
INSERT INTO cya_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Huare' na'an hua lo' ndaa hua suun nchgaa cha' nu m'ni Jesús xa mda'an ñi se'en lca Judea lo'o Jerusalén, chon' nde'en yjui ne' 'in ñi xa mjyi'in ca'an ne' 'in ñi loo cusi. ");
INSERT INTO cya_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Una Ndiose m'ni ñi cha' mdyiqui'o can' nu cua' ca snan tsaan, lo' ngulo'o tloo ñi 'in nten. ");
INSERT INTO cya_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A ngulo'o tloo ñi 'in nchgaa tucui, cui' ca nu 'in tsa huare' ti nu cua' ngulohui Ndiose 'in na'an tloo hua cha' re, huare' nu ycu sca se'en ti lo'o ñi xa cua' mdyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ngulo ñi tñan 'in hua si'yana tsa ycui' hua lo'o nchgaa nten, lo' quitsa' hua 'in ne' si'yana Ndiose cua' mdi'in tyaa 'in Jesús lca ñi Bse nu cu'ni xñan bsya 'in nten tsatlyu lo'o ne' cua' ngujui. ");
INSERT INTO cya_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Cui' cha' 'in ñi mda'an ycui' yu nu mxiycui' Ndiose 'in cua' s'ni, si'yana nchgaa nu tsa qui'an ti' 'in ñi, cu'ni Ndiose cha' tlyu ti' 'in can' si'ya ñi. ");
INSERT INTO cya_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lja ti' nchcui' yu Tyo cha' can', ngu'ya Espíritu nu Luhui 'in Ndiose 'in nchgaa nu ne 'in cha' nu nchcui' yu. ");
INSERT INTO cya_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yu judio ta'a nda'an yu Tyo can', ndyijyin ya' yuhue ti' yu si'yana lo'o ne' gentil cua' mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in ne', ");
INSERT INTO cya_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","si'yana ngune 'in yu ña'an nchcui' ne' can' lenguas, lo' ngui'ni tnu ne' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Lo' juin yu Tyo can': ¿Ta ntsu'hui nu nchcui ndijin cha' chcua tya ne' re, lo' scaña'an ti mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in ne', tsaña'an yato'o 'in nare'? ");
INSERT INTO cya_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Xacan' ngulo yu Tyo tñan si'yana chcua tya ne' lo'o cha' cuiya' 'in Ñi X'nan na Jesús. Mjñan ne' cha' tsu'hue 'in yu si'yana ti' quinu la yu chcua xnan tsaan lo'o ne'. ");
INSERT INTO cya_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nchgaa la ña'an yu ta'a mda'an Jesús, lo'o jun ta'a na nu ndi'in se'en lca Judea, ynan jun cha' si'yana lo'o ne' gentil cua' ncuan xu'hue ne' cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Xa nguila yu Tyo quichen Jerusalén, ngusun lo'o ne' judio 'in yu, ");
INSERT INTO cya_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","lo' nchcui' ne': ¿Ñi cha' yaa se'en ndi'in ne' gentil lo' ycu sca se'en ti lo'o ne'? ");
INSERT INTO cya_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Xacan' mdyisnan mdaa lyicua yu Tyo can' suun nchgaa cha' nu yato'o 'in yu, lo' juin yu: ");
INSERT INTO cya_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Nan' mdi'in quichen Jope, lja nchcuin' lyi'on 'in Ndiose, na'an xñii sca cha' ña'an nchca ti' sca te' xeen nu nchcan' ta'a jacua nscan, lo' mdo'o na nde ni' cuaan yaan na se'en ndon. ");
INSERT INTO cya_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Xa mxina'an tsu'huen can 'in na, na'an cuati loo 'ni nu ntsu'hui ni' na, a cunta 'ni la, lo'o nu nsuhue' ni', lo'o nu nducua jlyu'hue. ");
INSERT INTO cya_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ngune 'ñan jui sca nu ycui': Tyo, tyiton lo' cujui 'ni re lo' cu 'in 'in. ");
INSERT INTO cya_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nen xacan': Ñi X'nan hua, a cun 'in 'in si'yana a nchca siya' cun 'ni nu a ntsu'hui cha' nchcu hua. ");
INSERT INTO cya_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Xiya' jui nu ycui' lo'on nde ni' cuaan: Nchgaa na nu cua' msuhui Ndiose, a chcui' si'yana coo' na. ");
INSERT INTO cya_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Cha' re yato'o na snan juesa, xacan' mchcuen te' can' nde ni' cuaan. ");
INSERT INTO cya_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Cui' ña'an lcaa mdiyaan snan yu nu mdiyan te'en 'ñan nu mdo'o quichen Cesarea. ");
INSERT INTO cya_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Espíritu 'in Ndiose ycui' lo'on si'yana a cu'ni tucua tin' tsa'an lo'o yu. Yi'an lo'o tsa scua jun ta'a na re, mdiyaa hua la na'an 'in yu nu msi'ya 'ñan, ");
INSERT INTO cya_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","mtsa' yu 'in hua ña'an ngu'ya ton sca angujle tloo yu se'en ndi'in yu, lo' juin 'in yu: Ca'an tñan 'in nu tsaa quichen Jope nu tsa te'en 'in Simón, yu nu nchcui' ne' lo'o lca Tyo, ");
INSERT INTO cya_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","can' nu chcui' cha' tsu'hue 'in Ndiose ña'an ntsu'hui cha' tyi'o laa, lo'o nchgaa nu ndi'in na'an 'in. ");
INSERT INTO cya_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lja nchcuin' lo'o ne' tsati ntyin ngu'ya Espíritu nu Luhui 'in Ndiose 'in ne', tsaña'an yato'o 'in nare' ti' culoo. ");
INSERT INTO cya_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Xacan' nguia yu'hui tin' cha' nu ycui' Ñi X'nan na lo'o na xa nu juin ñi: Cha' ñi si'yana yu Xuhua mducua tya yu 'in nten lo'o tyi'a, una 'un ntsu'hui cha' cha'an yu'hui Espíritu nu Luhui 'in Ndiose 'in um. ");
INSERT INTO cya_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Cha' Ndiose lca nu mdaa cha' tsu'hue re 'in ne', ña'an nu yato'o 'in nare', naa nu cua' ya qui'an ti' 'in Ñi X'nan na Jesucristo, ¿tucui ta lcan nan' si'yana chcui ndijin tloo Ndiose? ");
INSERT INTO cya_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Xa ngune 'in ne' cha' nu ycui' yu Tyo can', cui' xaa mdi'in tiin ne' lo' mdyisnan m'ni tnu ne' 'in Ndiose, lo' nchcui' ne': Ca nu lo'o ne' gentil cua' mdaa Ndiose cha' cuiya' si'yana xilo'o chon' ne' qui'ya 'in ne', lo' caja sca chendyu nu a tsa ti 'a 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ti' xa nu yjui ne' 'in yu Steba can' m'ni lyi'o 'tnan ne' 'in jun, cua' la tucueen ngunaan jun, ntsu'hui nu mdiyaa se'en lca Fenicia, lo'o se'en lca Chipre, a cunta lo'o quichen Antioquía mdiyaa jun. Una a ycui' jun cha' tsu'hue 'in Ndiose lo'o ña'an tucui ti, cui' ca nu tsalca ti lo'o ne' judio. ");
INSERT INTO cya_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Una lja can' ntsu'hui tucua snan yu Chipre lo'o yu Cirene nu mdiya ti'in quichen Antioquía, mdyisnan ycui' yu cha' tsu'hue 'in Ñi X'nan na Jesús lo'o ne' griego ndi'in can'. ");
INSERT INTO cya_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Si'ya cha' cuiya' 'in Ñi X'nan na, qui'an 'a nten ya qui'an ti' ne' lo' mducui ncha'an ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Xa ynan jun nu ndi'in quichen Jerusalén cha' can', ngua'an tñan jun 'in yu Bernabé si'yana tsaa yu quichen Antioquía. ");
INSERT INTO cya_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Una xa mdiyaa yu quichen can', tsu'hue 'a yu'hui tiquee yu si'yana na'an yu ña'an cha' tsu'hue nu ngui'ni Ndiose lo'o jun can'. Mdaa yu cha' tnu tiquee 'in jun si'yana tyi'in tyaa jun cusya 'in jun, a tyi'o tso' jun loo cha' tsu'hue 'in Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ñi ndi'in cha' 'in yu, mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in yu, a cunta lo'o cha' nu ndiya qui'an ti' yu. Lo' qui'an 'a nten ya qui'an ti' 'in Ñi X'nan na. ");
INSERT INTO cya_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chon' nde'en can' yaa yu Bernabé quichen Tarso, ya nan yu 'in yu Saulo, lo' nguian lo'o yu 'in nde quichen Antioquía. ");
INSERT INTO cya_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Can' nguio' ti'in yu lo'o jun ta'a na ni' sca yjan, qui'an 'a nten ngulo'o yu 'in quichen Antioquía can'. Culoo ya' mdyisnan ngulo'o naan ne' 'in jun nu cua' ntsu'hui cha' 'in Cristo: Cristiano. ");
INSERT INTO cya_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Yato'o sca tsaan, tucua snan yu nu nxiycui' Ndiose 'in mdo'o yu Jerusalén, mdiyaa yu quichen Antioquía. ");
INSERT INTO cya_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sca yu can' naan yu Agabo, mdyiton yu lo' mtsa' yu ña'an mxiycui' Espíritu 'in yu, si'yana ntsu'hui cha' qui'ya bju'ñan sca chcui se'en can'. Cha' re yato'o na xa ncua yu Claudio ree. ");
INSERT INTO cya_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Xacan' nchgaa jun Antioquía nu cua' ntsu'hui cha' 'in Jesús, m'ni cuiya' jun cha' si'yana cunda scaa jun taa jun tñi cua' ña'aan tca 'in jun, lo' ca'an tñan jun 'in na 'in jun nu ndi'in se'en lyi'ya loo Judea. ");
INSERT INTO cya_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Cuaña'an yato'o, ngua'an tñan jun tñi can' lo'o yu Bernabé lo'o yu Saulo, can' nu mdyaa cunta 'in na 'in yu nu ntsu'hui cunta 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Cui' xacan', yu nu lca ree Herode msu'hua yu 'in tucua snan jun nu cua' ya qui'an ti' 'in Jesús na'an chcuan, si'yana xitijin ne' 'in jun nu ti'i, ");
INSERT INTO cya_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ngulo yu tñan si'yana xi'yu yni yu Jacobo, ta'a ngula yu Xuhua. ");
INSERT INTO cya_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na'an yu ree can' si'yana mdiyaa 'a ti' ne' judio ña'an nu m'ni yu, xacan' ngunan yu ña'an nu quinu yu Tyo lja ta'a Pascua xa nchcu ne' jaslya nu a yu'hui suun. ");
INSERT INTO cya_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Xa nguinu yu Tyo can', msu'hua ne' 'in yu na'an chcuan. Mdyaa ne' cunta 'in yu yaa' tsa jacua ta yu sindatu nu chu'hui cuan 'in yu, jacua yu scaa ta yu. Lca cha' 'in yu ree can' si'yana culyoo ne' 'in yu Tyo can', lo' tloo nten quichen can' ca cuiya' cha' 'in yu xa tsatii ta'a can', ");
INSERT INTO cya_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","can' cha' tsu'hue 'a ntsu'hui ne' cuan 'in yu. Una chcui lja xacan' a ndla' ti' jun chcui' lyi'o jun 'in Ndiose si'ya cha' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Cua' xca ti tla can' nu cu'ni cuiya' Herode cha' 'in yu Tyo, lo' yu re lja' yu tlu'hue la lja tucua yu sindatu can', nchcan' tsu'hue yaa' yu lo'o carena, nchgaa la ña'an yu sindatu can' ndon yu cuan nde tuna'an lyiya'. ");
INSERT INTO cya_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tsati ntyin msti sca xaa ña'an chcuan can' xa ngu'ya ton sca angujle 'in Ñi X'nan na, yla' sii' yu Tyo can' si'yana tyi'o sla yu, lo' juin 'in yu: Ndla ti cu'ni lo' tyitucui. Cui' ña'an lcaa nguitin' carena can' yaa' yu. ");
INSERT INTO cya_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ti' juin la 'in yu: Xcan' sii' lo' su'hua snan. Lo' cuaña'an m'ni yu. Ti' juin angujle can': Quixen ste' lo' chcui ncha'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Xacan' mducui ncha'an yu 'in angujle can', una a ñan ti' yu si'yana cha' ñi ca ña'an nu ngui'ni can' lo'o yu, msque' ti' yu si'yana nchcui' sla ti yu. ");
INSERT INTO cya_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Xa mdijin yu se'en ndon yu sindatu nu cua' nchca tucua ta can', nguila yu se'en ndon tuna'an tlyu nu nguia' lo'o chcuan, ycuii' na nguila na, xacan' mdyi'o ton yu nde lyiya'. Lo' xa mdiyaa yu se'en ndyaa cusi tucueen can', mdo'o tso' angujle can' sii' yu. ");
INSERT INTO cya_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","La xacan' nguila cha' tiyaa 'in yu, lo' juin yu: La ñii ncua cuiya' tin' si'yana Ñi X'nan na ngua'an tñan ñi angujle nu ngulo laa 'ñan tuyaa' Herode lo'o ne' judio, ña'an nu ncua ti' ne' cu'ni lyi'o ne' 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Xa nu ngu'ya tsu'hue ca yu cunta cha' can', mdo'o yu nguiaa yu la na'an 'in María, jyi'an yu Xuhua, yu nu nchcui' ne' lo'o lca Marco. Can' qui'an 'a jun ndiyo' ti'in jun, nchcui' lyi'o jun 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Xa ngune ycui' yu Tyo tuna'an lyiya', mdo'o sca nu cuna'an tsa suhue ti naan Rode, ya na'an cha' ti ca lca can', ");
INSERT INTO cya_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","una cui' xaa yu'hui lyoo tyi'i nchcui' yu Tyo can'. Loo nu tsu'hue ntsu'hui tiquee, ñi a msla tuna'an can', cui' xaa nguia ytsa' 'in jun si'yana yu Tyo ndon yu tuna'an lyiya' can'. ");
INSERT INTO cya_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Lo' juin jun 'in: Na ndiyo' nu'huin. Mxcuen nu cuna'an can': Nu cha' ñi ca, cua ndon. Xiya' juin jun 'in: Cui' angujle nu nsñi cunta 'in yu ca lca cua. ");
INSERT INTO cya_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yu Tyo can' a ndla ti' yu ndon ycui' yu tuna'an can', lo' xa msla jun 'in na ndyijyin ya' yuhue ti' jun xa na'an jun 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","M'ni yaa' yu si'yana seen tyi'in jun, mdyisnan mtsa' yu ña'an ngulyoo Ñi X'nan na 'in yu na'an chcuan can', lo' juin yu: Cu'ni um cha' tsu'hue quitsa' um 'in yu Jacobo lo'o nchgaa la ña'an jun ta'a na cha' re. Xacan' mdo'o yu nguiaa yu xca se'en. ");
INSERT INTO cya_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Una xa ngu'ya xaa can', lyee 'a nguilo ti'in yu sindatu si'ya cha' 'in yu Tyo can', cha' ña'an ncua mdyi'o yu. ");
INSERT INTO cya_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yu Herode can' ngulo yu tñan si'yana quia nan ne' 'in yu, una a la nguija lyoo yu, lo' xa cua' mxicunee yu 'in nchgaa yu nu yu'hui cuan can', mdo'o tñan si'yana caja yu. Chon' nde'en la can', yu Herode mdo'o yu se'en lca Judea lo' mdiyaa yu se'en lca Cesarea. ");
INSERT INTO cya_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Yu Herode can' ycuen tique' yu lo'o nten ndi'in quichen Tiro lo'o Sidón. Una mdya ycui' ne' cha' ña'an cu'ni chu'hue ne' cha' 'in ne' tloo ree can', lo' mjñan ne' cha' tsu'hue 'in yu Blasto, sca yu nu lyi'ya tñan tloo ree, si'yana chcui' yu cha' 'in ne' se'en nu ca'an tñan la yu ree can' na nu cunajo'o 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Xa mdiyaa tsaan can', yten tucua yu Herode se'en ndlo yu tñan, lco' yu sca te' tsu'hue ña'an, xacan' mdyisnan mda cueen yu 'in nten can'. ");
INSERT INTO cya_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ycui' cueen nten can' lo'o yu: Ycui' ca Ndiose lca nu nchcui' re, lo' si'i 'a nten chendyu. ");
INSERT INTO cya_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ticui' xaa ngu'ya ton sca angujle 'in Ñi X'nan na, m'ni cha' msñi sca quicha 'in yu, mdyisnan ytsu yu'hui cunu' 'in yu lo' ngujui yu, cui' si'yana a mdaa yu loo Ndiose tloo nten can'. ");
INSERT INTO cya_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Cha' tsu'hue 'in Ñi X'nan na nde lyee la nguia nguine yu'hui na, ncua qui'an la nten nu ya qui'an ti' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Yu Bernabé lo'o yu Saulo, xa cua' msu'hua ta yu tñan nu yaa yu quichen Jerusalén, mxitucui yu nde Antioquía, lo' nguia lo'o yu 'in yu Xuhua nu nchcui' ne' lo'o lca Marco. ");
INSERT INTO cya_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Se'en ndiyo' ti'in jun quichen Antioquía, can' ndi'in yu nu nxiycui' Ndiose 'in lo'o yu nu ndlo'o 'in jun: Yu Bernabé, yu Simón nu nchcui' ne' lo'o lca Niger, Lucio nu mdo'o se'en lca Cirene, lo'o Manaén, yu nu m'ni co'o ne' 'in sca se'en ti lo'o Herode tetrarca, a cunta lo'o yu Saulo. ");
INSERT INTO cya_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lja ngui'ni tnu yu can' 'in Ñi X'nan na, ngui'ni yu ayuna, xacan' ycui' Espíritu nu Luhui 'in Ndiose lo'o yu: Lyo ton um 'in yu Bernabé lo'o yu Saulo, si'yana cu'ni yu tñan 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Xa mdyi ycui' lyi'o yu 'in Ndiose nu m'ni yu ayuna, xacan' mdi'in tyaa yu yaa' yu 'in chcuaa yu can', lo' ngua'an tñan jun 'in yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Si'yana cua' ngua'an tñan Espíritu nu Luhui 'in Ndiose 'in chcuaa yu can', mdiyaa yu quichen Seleucia, can' yten yu sca ni' yca na'an lo' mdijin xi'yu yu xca tso' se'en lca Chipre. ");
INSERT INTO cya_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Xa mdo'o ca'an yu can' mdiyaa yu quichen Salamina, can' mdyisnan ycui' yu cha' 'in Ndiose scasca se'en n'ni tnu ne' judio 'in ñi. Lo'o yu Xuhua Marco nda'an nda yaa' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Xa cua' tyi'o yso yu ña'aan se'en lyi'ya loo Chipre, mdiyaa yu quichen Pafos. Can' mchcua ta'a yu lo'o sca yu judio, nu jlyo ti' nu naan Barjesús, lo' nchcui' yu si'yana Ndiose lca nu nxiycui' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ngui'ni yu tñan lo'o yu Sergio Paulo nu lca gubierno can', lo' yu gubierno lca yu sca nu tiyaa, lo' msi'ya yu 'in yu Bernabé lo'o yu Saulo si'yana quine 'in yu cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Una yu Elima, yu jlyo ti' can' (si'yana can' cha' nchca ti' chcui' nii yu), ncua ti' yu chcui ndijin yu si'yana a tsa qui'an ti' gubierno can' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Xacan' yu Saulo can', nu nchcui' ne' lo'o Pablo, mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in yu, mxina'an tsu'hue ca yu 'in yu jlyo ti' can', ");
INSERT INTO cya_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","lo' juin yu 'in: Nu'huin lca sñe' laxa'an nu mtsa'an yu'hui cha' cuiñi lo'o nchgaa loo cha' ngunan' 'in, lca sca nu nxcuan tloo cha' tsu'hue 'in Ndiose. ¿La ñi xaa cula' ti' chcui ndijin loo cha' nu ñi 'in Ñi X'nan na Jesús? ");
INSERT INTO cya_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Can' cha' cua' ñii, xitijin Ñi X'nan na 'in nu ti'i lo' a ca chcan' 'a 'in sca co' xaa. Cui' ña'an lcaa nguinu tla yta tloo yu, lo' mdyisnan mjnan yaa' yu cha' caja nu ta yaa' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Xa na'an yu gubierno cha' nu yato'o 'in yu can', cui' xaa ya qui'an ti' yu 'in Ñi X'nan na, ndyijyin ya' nduhue ti' yu ña'an nguiaa cha' tsu'hue 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Xacan' mdo'o yu Pablo lo'o ta'a nda'an yu se'en lca quichen Pafos, lo' yten yu ni' sca yca na'an tsaya' mdiyaa yu quichen Perge se'en lyi'ya loo Panfilia. Una yu Xuhua Marco can' mxitucui yu nde Jerusalén. ");
INSERT INTO cya_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mdo'o chcuaa yu can' quichen Perge lo' mdiyaa yu quichen Antioquía se'en lyi'ya loo Pisidia. Tsaan nu nxitñan' ne' judio yten yu se'en n'ni tnu ne' 'in Ndiose, can' yten tucua yu. ");
INSERT INTO cya_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Yu nu ndlo tñan se'en can', xa mdyi ycui' yu quityi se'en ngua'an scua lee, lo'o cha' nu ngua'an scua yu nu mxiycui' Ndiose 'in cua' s'ni, xacan' mñicha' yu 'in chcuaa yu can': 'Un ta'a Judio na, cha' ta nde'en la cha' lyi'ya um tca culo'o um 'in hua. ");
INSERT INTO cya_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Xacan' mdyiton yu Pablo, lo' m'ni yaa' yu si'yana tyisnan chcui' yu, lo' juin yu: 'Un ne' Israel, quine 'in um nchgaa 'un ne' nu n'ni tnu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ndiose 'in ne' Israel, ñi nu ngulohui 'in nten cula 'in na, m'ni ñi cha' ncua ne' sca quichen tlyu, siya' lca ne' sca ne' mda'an yu'hui ti se'en lca Egipto, lo' ngulyoo ñi 'in ne' se'en can' lo'o sca cha' cuiya' nu tlyu. ");
INSERT INTO cya_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tsani' tucua yla yjan yu'hui cha' tlyu ti' 'in Ndiose lo'o ne', lja mda'an yu'hui ne' se'en lca yuu ngutyi can'. ");
INSERT INTO cya_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Xacan' ngujlyo ñi tsa cati quichen tnu se'en lyi'ya loo Canaán, se'en nu quinu yuu can' 'in nten cula 'in na. ");
INSERT INTO cya_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Xa cua' mdijin jacua ciento tlu'hue yjan, Ndiose mdaa ñi cha' cuiya' si'yana culo ton ne' bse nu culo tñan 'in ne', tsaya' mdiyaa tsaan nu mdo'o ton yu Samuel, yu nu mxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chon' nde'en can' mjñan ne' sca ree nu culo ca tñan 'in ne', xacan' ngulohui Ndiose 'in yu Saul, sñe' yu Cis nu lca ta nten 'in yu Benjamin. Tsani' tucua yla yjan ngulo yu tñan. ");
INSERT INTO cya_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Xa cua' ngujui yu Saul, ngulohui Ndiose 'in yu Davi nu ca yu ree, lo' ndeña'an ycui' ñi cha' 'in yu: Davi, sñe' Isaí, nde nu su'hua ña'an lca cusya 'in lo'on, lo' cu'ni yu tsaña'an nu nchca tin'. ");
INSERT INTO cya_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Cui' loo ta nten 'in yu Ndiose ngua'an tñan ñi 'in Jesús si'yana culo laa ñi 'in ne' Israel, tsaña'an cha' nu cua' mdi'in tyaa Ndiose lo'o nten cula 'in na ti' s'ni. ");
INSERT INTO cya_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ti' lyijyi tyisnan cu'ni ñi tñan 'in Ndiose, xa cua' mda'an ycui' yu Xuhua lo'o ne' Israel si'yana tyaa ti' ne' 'in Ndiose lo' chcua tya ne'. ");
INSERT INTO cya_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Xa nu cua' tyii tñan ngui'ni yu Xuhua can', juin yu lo'o nten: ¿Tucui ta lcan nan' ñan ti' um? Si'i ñi nu ñan ti' um can' lcan. Nde chon' re ljyaan sca ñi nu tlyu lati que 'ñan nan', lo' ndyijyin ya' nducui tin' cha' cua na siya' tisnan ti ñi xtin'. ");
INSERT INTO cya_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nchgaa naan nu lca ta nten 'in Abraham, lo'o nchgaa 'un ne' nu n'ni tnu 'in Ndiose nducua um re, Ndiose ngua'an tñan ñi cha' tsu'hue re 'in um si'yana tca tyi'o laa um. ");
INSERT INTO cya_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ne' ndi'in quichen Jerusalén lo'o yu nu ngu'ya tñan can', a ngu'ya ne' cha' tiyaa tucui ca lca Jesús, siya' nchgaa tsaan nu nxitñan' ne' nchcui' ne' quityi nu ngua'an scua yu nu mxiycui' Ndiose 'in cua' s'ni, yato'o mducua ne' tñan cha' can' xa ngulo qui'ya ne' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Siya' a sca qui'ya nguija lyoo 'in ñi, una mjñan ne' 'in Pilato si'yana cujui ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Xa cua' yato'o nchgaa cha' nu ngua'an scua nu nchcui' cha' 'in ñi, xacan' mdyi'ya ne' 'in ñi loo cusi lo' ya tsi' ne' 'in ñi, ");
INSERT INTO cya_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","una Ndiose m'ni cha' mdyiqui'o ñi. ");
INSERT INTO cya_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tyun 'a tsaan ti' ngulo'o tloo ñi 'in jun nu mdiya lo'o ñi quichen Jerusalén xa mdo'o ñi se'en lca Galilea, can' nu ndaa suun cha' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Lo'o huare' nda'an ycui' hua cha' tsu'hue 'in ñi lo'o um, cui' cha' nu mdi'in tyaa Ndiose lo'o nten cula 'in na. ");
INSERT INTO cya_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nchgaa cha' tsu'hue re cua' mdaa Ndiose 'in nare' nu lca sñe' ñi xa m'ni ñi cha' mdyiqui'o Jesús, cui' tsaña'an nchcui' Salmo nu cua' nchca tucua: —Nu'huin lca Sñen', lo' nan' lcan Sti cua' ñii—. ");
INSERT INTO cya_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nchcui' Salmo si'yana tyiqui'o ñi, a xca 'a tsaan ti' cutso' ti'in cunan' ñi: —In nu'huin qui'ni ca'an nchgaa cha' tsu'hue nu cua' mdi'in tyaan lo'o yu Davi—. ");
INSERT INTO cya_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Can' cha' ndeña'an nchcui' quityi Salmo xca se'en: —A taa um cha' cuiya' si'yana cutso' ti'in cunan' Sñe' um nu cua' ngulohui um—. ");
INSERT INTO cya_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Cha' ñi si'yana yu Davi ngulo yu tñan tsaña'an nu mdaa Ndiose cha' cuiya' 'in yu, xacan' ngujui yu, sca se'en ti mtsi' yu lo'o nten cula 'in yu, lo' ytso' ti'in cunan' yu. ");
INSERT INTO cya_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Una ñi nu m'ni Ndiose cha' mdyiqui'o can', a ytso' ti'in cunan' ñi. ");
INSERT INTO cya_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","'Un nu lca ta nten 'in na, ca jlyo ti' um cha' re: Si'ya Jesús caja ña'an cu'ni Ndiose cha' tlyu ti' 'in na, ");
INSERT INTO cya_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","si'yana cunta cha' 'in lee nu ngua'an scua Moisé, a ncua xnu luhui na 'in na si'ya qui'ya nducui na, una nchgaa nu tsa qui'an ti' 'in Jesús quinu luhui can' tloo Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Can' cha' cua' ñii, xñi um cunta si'yana a caan cha' nu ngua'an scua yu nu mxiycui' Ndiose 'in, lo' nchcui' na: ");
INSERT INTO cya_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","—Xñi um cunta 'un nu nxcuan tloo 'ñan, lo' chu'hui yuhue ti' um ña'an ntsu'hui cha' caja um, si'yana nan' cu'nin sca cha' nu tnu tloo um, lo' ñi a tsa qui'an ti' um siya' caja nu quitsa' 'in um—. ");
INSERT INTO cya_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Xa mdyi'o yu Pablo lo'o yu Bernabé se'en ndiyo' ti'in ne' can', ne' gentil nu ntsu'hui lja can' mjñan ne' cha' tsu'hue 'in yu si'yana ti' chcui' la yu cha' can' ta'a snu' tsaan, cui' tsaan nu nxitñan' ne'. ");
INSERT INTO cya_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Xa nu cua' msla' ta'a jun, qui'an 'a ne' judio, lo'o nu cua' ntsu'hui ña'an cha' 'in ne', mducui ncha'an ne' 'in yu Pablo lo'o yu Bernabé, xacan' mdyisnan mda cueen yu 'in nten can' ña'an nu ti' tsa quiñan la ne' loo cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mda'a snu' tsaan can', la' nchgaa ti nten can' nguio' ti'in ne' se'en nu quine 'in ne' cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Una xa na'an ne' judio si'yana qui'an 'a nten nguio' ti'in ne', xacan' yten cha' nsin' ti' tiquee ne', lo' mdyisnan ycui' tyijyin ne' lo' mdaja ne' 'in yu Pablo. ");
INSERT INTO cya_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yu Pablo lo'o yu Bernabé, a ytsen yu mxcuen yu 'in ne': Lo'o um ntsu'hui cha' chcui' hua cha' tsu'hue re 'in Ndiose culo nducua la, una mscuan tloo um 'in na, a ñan ti' um si'ya cha' re caja chendyu nu a tsa ti 'a 'in um, can' cha' cua' ñii, tsu'hue lati chcui' hua lo'o ne' gentil. ");
INSERT INTO cya_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Si'yana nde tñan ngulo Ñi X'nan na 'in hua, lo' nchcui' ñi: —Nan' mdi'in tyaan 'in si'yana ca sca xaa 'in ne' gentil nu ndi'in sca chcui chendyu, si'yana tyi'o laa ne'—. ");
INSERT INTO cya_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Xa ngune 'in ne' gentil cha' can', tsu'hue 'a yu'hui tiquee ne', lo' m'ni tnu ne' 'in Ñi X'nan na si'ya ycha' ñi, lo' ya qui'an ti' nchgaa nu cua' mdo'o hui 'in Ndiose, jun nu ntsu'hui cha' caja chendyu nu a tsa ti 'a 'in. ");
INSERT INTO cya_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Cha' tsu'hue 'in Ñi X'nan na nguine yu'hui na ña'aan sca chcui se'en can'. ");
INSERT INTO cya_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Una ne' judio mdyisnan mxo' ti'in ta'a ne' lo'o yu nu lyi'ya tñan quichen can', lo'o ne' cuna'an nu suun lca cha' 'in, msu'hua ne' tiquee nten quichen can', lo' mducui lyi'o ne' 'in yu Pablo lo'o yu Bernabé. ");
INSERT INTO cya_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tu'hua quichen can' mscuin yu yuu quiya' yu, mdo'o yu nguiaa yu nde quichen Iconio. ");
INSERT INTO cya_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Tsalca jun nu cua' ntsu'hui cha' 'in Jesús nu ndi'in quichen Antioquía, tsu'hue 'a ntsu'hui tiquee jun si'yana mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mdiyaa chcuaa yu can' quichen Iconio, yten yu se'en n'ni tnu ne' judio 'in Ndiose, lo' si'ya cha' nu ycui' yu can', qui'an 'a nten ya qui'an ti' 'in Jesús, ne' judio, lo'o ne' gentil. ");
INSERT INTO cya_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Una nchgaa la ña'an ne' judio nu a ya qui'an ti', msu'hua tiquee ta'a ne' lo'o ne' gentil se'en nu lyi'un ti' ne' lo' a cu'ni cunta 'a ne' 'in jun ta'a na. ");
INSERT INTO cya_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Siya' cuaña'an, tyun 'a tsaan ti' nguinu yu quichen can', a ytsen yu ycui' yu cha' tsu'hue 'in Ñi X'nan na, mdaa ñi cha' cuiya' 'in yu cu'ni yu scasca cha' nu tnu, lo' ca cuiya' ti' ne' si'yana lca na cha' nu ñi. ");
INSERT INTO cya_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A ncua 'a ca sca cha' ti 'in nten can', ntsu'hui nu yaa tso' 'in ne' judio, lo' ntsu'hui nu yaa tso' 'in chcuaa yu can'. ");
INSERT INTO cya_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Una ne' judio lo'o ne' gentil m'ni cuiya' ne' cha' lo'o yu bsya, si'yana tucui lyi'o ne' 'in chcuaa yu can', lo' cujui ne' 'in yu lo'o quee ti. ");
INSERT INTO cya_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Una xa ynan yu cha' can', cui' xaa mdo'o yu quichen can', lo' mdiyaa yu quichen Listra lo'o Derbe, se'en lyi'ya loo Licaonia. ");
INSERT INTO cya_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ña'aan se'en can' mda'an ycui' yu cha' tsu'hue 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Quichen Listra, can' ndi'in sca yu mchcun' chcua tso' quiya' ti' xa ngula. ");
INSERT INTO cya_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yu re ngune 'in yu cha' nu nchcui' yu Pablo, xacan' mxina'an yu se'en nducua yu ti'i can', lo' ngüi ti' yu si'yana ndiya qui'an ti' can' 'in Ndiose nu tca cu'ni chca 'in, ");
INSERT INTO cya_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","lo' ycui' cueen yu lo'o: Xñii um quiya' um, lo' tyiton um. Sca juesa ti mdyiton yu lo' mda'an yu. ");
INSERT INTO cya_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Xa na'an nten ña'an cha' nu m'ni yu Pablo, xacan' mdyisnan ycui' cueen ne' lo'o ycha' ne' Licaonia: Ñii nu na'an tloo ca na 'in tucua jo'o tsaña'an nchca ti' sca yu qui'yu. ");
INSERT INTO cya_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mdi'in tyaa ne' nii yu Bernabé, Stina Jo'o Jupiter, lo' yu Pablo ndlo'o naan ne' 'in yu, Stina Jo'o Mercurio, si'yana can' nu lyee la nchcui'. ");
INSERT INTO cya_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yu nu lca stijo'o 'in laa se'en nducua Stina Jupiter, cui' laa nu nducua tu'hua quichen can', ya lo'o yu tucua snan toro tulaa can', a cunta m'ni chu'hue yu quee se'en nu cu'ni tnu yu 'in chcuaa yu lo'o nchgaa nten can'. ");
INSERT INTO cya_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Una xa ynan yu Pablo lo'o yu Bernabé cha' can', hasta msta yu ste' yu yten yu lja nten can', lo' ycui' cueen yu: ");
INSERT INTO cya_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Nchgaa 'un nu ndi'in re, ¿ñi cha' ngui'ni um cuaña'an? Lo'o huare' lca hua nten chendyu ña'an nu lca um, ta si'i cui' cha' re nchcui' hua si'yana tyaa ti' um 'in Ndiose, ñi nu lo'o ca, —ñi nu mtñan ni' cuaan lo'o chendyu re, lo'o tyi'a tujo'o, lo'o nchgaa loo na nu ndi'in 'in na—. ");
INSERT INTO cya_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Chendyu nu mdijin Ndiose mda loo ñi 'in nten, siya' mda'an ne' ña'an nu ncua ti' ne'. ");
INSERT INTO cya_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Una ti' ngui'ni ñi cha' tsu'hue lo'o na se'en nu a jlya ti' na 'in ñi: Ndyi'ya ñi quioo, ngui'ni ñi cha' nchca tñan na nu ntya na, a ndiya lyijyi na nu najo'o 'in na, tsu'hue ntsu'hui tiquee na nchgaa xaa. ");
INSERT INTO cya_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Lo'o cha' nu ycui' yu can', que' 'a ncua canan nu a cu'ni tnu ne' 'in yu lo'o 'ni can'. ");
INSERT INTO cya_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Xacan' mdiyaan tucua snan ne' judio nu mdo'o quichen Antioquía lo'o quichen Iconio, nu msu'hua tiquee nten qui'an can', lo' yato'o mjyi'in ne' quee 'in yu Pablo, msque' ti' ne' si'yana cua' ngujui yu, lo' ncuan quii suhue' ne' 'in yu la tu'hua quichen. ");
INSERT INTO cya_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nchgaa jun nu cua' ntsu'hui cha' 'in Jesús msu'hua lo'o jun 'in yu, mdyiton yu lo' yten yu loo quichen can' xiya'. Xca tsaan can' mdo'o yu nguiaa yu lo'o yu Bernabé nde se'en lca quichen Derbe. ");
INSERT INTO cya_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mdyisnan ycui' yu cha' tsu'hue 'in Jesús quichen can', qui'an 'a nten m'ni yu canan nu ya qui'an ti' 'in Jesús, xacan' mxitucui yu, lo' mdijin yu quichen Listra, lo'o Iconio, lo'o Antioquía. ");
INSERT INTO cya_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Mdaa yu cha' tnu tiquee 'in jun nu cua' ntsu'hui cha' 'in Jesús, si'yana a tyi'o tso' jun loo cha' nu cua' ya qui'an ti' jun, lo' juin yu 'in jun: Loo nu sten na se'en ndlo Ndiose tñan, 'ni cha' tyijyin na scasca nu ti'i. ");
INSERT INTO cya_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Cunda scaa quichen can', ngulo ton yu 'in yu nu chu'hui cunta 'in jun ta'a na, lo' xa cua' m'ni yu ayuna nu ycui' lyi'o yu 'in Ndiose, mxnu yu cunta 'in yu can' yaa' Ñi X'nan na, ñi nu 'in ya qui'an ti' yu. ");
INSERT INTO cya_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Xacan' mdo'o chcuaa yu can' nguiaa yu, mdijin yu se'en lyi'ya loo Pisidia, lo' mdiyaa yu loo yuu 'in ne' Panfilia. ");
INSERT INTO cya_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Quichen Perge, can' ycui' yu cha' tsu'hue 'in Ndiose, xacan' mdo'o yu nguiaa yu tsaya' mdiyaa yu quichen Atalia. ");
INSERT INTO cya_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Can' yten yu ni' yca na'an, si'yana xitucui yu quichen Antioquía, se'en nu mxnu jun cunta 'in yu yaa' Ndiose lo'o tñan nu yaa yu. ");
INSERT INTO cya_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Xa nguila yu quichen can', mxo' ti'in yu 'in jun ta'a na, lo' mdaa yu suun tsala ña'an tnu cha' nu m'ni Ndiose lo'o yu se'en yaa yu, lo' ña'an msla Ndiose sca tucueen 'in ne' gentil si'yana tsa qui'an ti' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Quichen can' x'ni 'a nguinu chcuaa yu can' lo'o jun nu cua' ya qui'an ti' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Can' mdiyaa tucua snan yu nu mdo'o se'en lyi'ya loo Judea, mdyisnan ngulo'o yu 'in jun ta'a na, lo' nchcui' yu: Cha' na a ca circuncida 'in um ña'an cha' nu ngua'an scua Moisé, a tca tyi'o laa um. ");
INSERT INTO cya_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Una yu Pablo lo'o yu Bernabé a ncua ca sca cha' ti 'in yu lo'o yu can', lyee 'a ycui' tyijyin yu scasca yu, can' cha' mdi'in tyaa jun cha' si'yana tsaa yu Pablo lo'o yu Bernabé quichen Jerusalén, lo'o chcua xnan jun nu ca ta'a tsaa yu, lo' cu'ni cuiya' yu cha' can' lo'o yu ta'a mda'an Jesús, tsatlyu lo'o yu nu ntsu'hui cunta 'in jun ta'a na can'. ");
INSERT INTO cya_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Xacan' ngua'an tñan jun 'in yu nguiaa yu, lo' mdijin yu se'en lyi'ya loo Fenicia lo'o Samaria, mdaa yu suun lo'o jun ta'a na si'yana lo'o ne' gentil cua' ya qui'an ti' 'in Jesús, lo' nchgaa jun tsu'hue ntsu'hui tiquee jun si'ya cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Xa mdiyaa yu Jerusalén, yu ta'a mda'an Jesús lo'o yu nu ntsu'hui cunta 'in jun mchcuan cunta 'in yu, lo' mdyisnan mdaa yu suun ña'an cha' tsu'hue m'ni Ndiose lo'o yu se'en yaa yu. ");
INSERT INTO cya_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Yu nu yu'hui tso' 'in ne' fariseo nu cua' ya qui'an ti' 'in Jesús, cui' xaa mdyiton yu, lo' juin yu: 'Ni cha' ca circuncida 'in ne' gentil lo' xu'hua se'en ne' cha' 'in lee nu ngua'an scua Moisé. ");
INSERT INTO cya_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Xacan' nguio' ti'in yu ta'a mda'an Jesús lo'o yu nu ntsu'hui cunta 'in jun ta'a na, si'yana cu'ni cuiya' jun cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Xa nu cua' lyee 'a ycui' tyijyin jun cha' can', mdyiton yu Tyo lo' juin yu: Nchgaa 'un jun ta'a na, jlyo ti' na si'yana cua' s'ni ngulohui Ndiose 'ñan nu tsa ycuin' cha' tsu'hue 'in ñi lo'o ne' gentil se'en nu tsa qui'an ti' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ndiose, ñi nu ndyu'hui lyoo ña'an lca cusya 'in na, ncuan xu'hue ñi 'in ne' lo' mdaa ñi Espíritu nu Luhui 'in ñi tsaña'an yato'o 'in nare'. ");
INSERT INTO cya_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Scaña'an ti na tloo Ndiose lo'o ne' gentil, si'yana msuhui ñi ni' cusya 'in ne' xa nu ya qui'an ti' ne'. ");
INSERT INTO cya_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Cua' ñii, ¿ñi cha' ta ngui'ni lye' ti' um 'in Ndiose si'ya cha' re? ¿Ta na nchca ti' um so' tucua um sca yu'hua chon' jun nu cua' ntsu'hui cha' 'in Jesús, sca yu'hua nu ñi nten cula 'in na, ñi nare', lo' a nchca cui'ya na? ");
INSERT INTO cya_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Cui' ca nu ndiya qui'an ti' na si'yana tyi'o laa na si'ya cha' tsu'hue 'in Ñi X'nan na Jesús, cui' cuaña'an tyi'o laa ne' gentil. ");
INSERT INTO cya_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","La xacan' mdi'in tiin nchgaa jun can', lo' ngune 'in jun ña'an cha' nu ycui' yu Bernabé lo'o yu Pablo, ña'an m'ni Ndiose scasca cha' nu tnu lo'o ne' gentil nchgaa se'en yaa yu. ");
INSERT INTO cya_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Xa mdyi ycui' yu cha' can', juin yu Jacobo: Nchgaa 'un jun ta'a na, quine 'in um sca cha' nu chcuin': ");
INSERT INTO cya_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Yu Tyo cua' mtsa' yu 'in na ña'an cha' tsu'hue m'ni Ndiose lo'o ne' gentil culoo ya', si'yana lja can' caja nu cu'ni tnu 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Cha' re nchcua ta'a na lo'o cha' nu ngua'an scua yu nu mxiycui' Ndiose 'in cua' s'ni, lo' nchcui' na: ");
INSERT INTO cya_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","—Nde loo la re, nan' xitucuin, lo' xiya' xiton na'an 'in Davi nu cua' ngujlyo can', cu'ni chu'huen suun na, lo' xiton 'in na xiya', ");
INSERT INTO cya_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ña'an ca si'yana nchgaa la ña'an nten quia nan ne' 'in ñi X'nan na, nchgaa ne' gentil, tsalca nu cua' ngulohuin nu ca ja'an 'ñan. ");
INSERT INTO cya_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Cuaña'an juin Ñi X'nan na, ñi nu cua' s'ni ngui'ni cha' re—. ");
INSERT INTO cya_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Can' cha' ñan tin', a nchca cha' chcui ndijin na loo chendyu 'in ne' gentil nu cua' ya qui'an ti' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Cui' ca nu ca'an tñan na sca quityi 'in jun, si'yana a cu 'a jun na nu cua' yu'hui loo jo'o, ñi a sten yu'hui jun lo'o cuilyi'o nten uta lo'o ne' ycui' ti, ñi a cu ne' cunan' 'ni nu a nslo tne, ñi a ntsu'hui cha' cu ne' tne 'ni. ");
INSERT INTO cya_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Si'yana ti' cua' s'ni cunda scaa quichen se'en n'ni tnu ne' judio 'in Ndiose, ndyijyi nu nchcui' quityi nu ngua'an scua Moisé nchgaa tsaan nu nxitñan' na. ");
INSERT INTO cya_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Xacan' yu ta'a mda'an Jesús lo'o yu nu ntsu'hui cunta 'in jun, tsatlyu lo'o nchgaa la jun ta'a na, m'ni cuiya' jun cha' si'yana culohui jun nu ta'a quiaa yu Pablo lo'o Bernabé nde quichen Antioquía. Ngua'an tñan jun 'in yu Sila, lo'o Juda, nu nchcui' ne' lo'o Barsabás, cui' jun nu ndon loo lati 'in jun ta'a na. ");
INSERT INTO cya_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ngua'an jun sca quityi nu cui'ya yu, lo' nchcui' na: Nchgaa hua nu ta'a mda'an hua lo'o Jesús, lo'o nchgaa hua nu ntsu'hui cunta 'in jun ta'a na, tsatlyu lo'o jun ta'a na nchcui' cha' hua 'in um, 'un ne' gentil nu lca ta'a na nu ndi'in quichen Antioquía, lo'o se'en lyi'ya loo Siria lo'o Cilicia. ");
INSERT INTO cya_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Cua' ynan hua cha' si'yana tucua snan yu nu mdo'o lja hua yaa yu se'en ndi'in um, si'i lo'o cha' cuiya' 'in hua, lo' msu'hua yu cha' nduhue ti' tiquee um lo'o cha' nu ycui' yu si'yana ca circuncida 'in um, lo' tucua um tñan cha' 'in lee nu ngua'an scua Moisé. ");
INSERT INTO cya_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Huare' m'ni cuiya' hua cha' si'yana ca'an tñan hua 'in yu nu ta'a quiaa yu Bernabé lo'o yu Pablo, yu nu ndyu'hui cuiya' ti' hua 'in, ");
INSERT INTO cya_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","yu nu cua' tyun ya' nchca cha' caja si'ya cha' 'in Ñi X'nan na Jesucristo. ");
INSERT INTO cya_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Can' cha' ngua'an tñan hua 'in yu Juda lo'o yu Sila se'en ndi'in um si'yana tca taa yu suun cha' re. ");
INSERT INTO cya_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Si'ya Espíritu nu Luhui 'in Ndiose nu mxicu'ni cusya 'in hua, a ncua lca tiquee hua ti'in tyaa hua sca cha' nu tucui 'in um, tsaloo ti xu'hua se'en um cha' nu ndon loo lati re: ");
INSERT INTO cya_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","A cu um ñi sca loo na nu cua' yu'hui loo jo'o, ñi a cu um tne, ñi cunan' 'ni nu a nslo tne, ñi a sten yu'hui um lo'o cuilyi'o nten uta lo'o ne' ycui' ti. Tsu'hue cha' cu'ni cunta um cha' re. Tsacua ti cha' chcui' na. ");
INSERT INTO cya_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Xacan' mxitucui yu quichen Antioquía, lo' mxo' ti'in yu nchgaa jun ta'a na, lo' mdyaa yu cunta quityi can'. ");
INSERT INTO cya_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Xa mdyi ycui' jun 'in na, tsu'hue 'a ntsu'hui tiquee jun si'ya cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Si'yana yu Juda lo'o yu Sila lca yu nu nxiycui' Ndiose 'in, a yaa lyijyi cha' nu ngulo'o yu nu taa cha' tnu tiquee 'in jun, lo' mdi'in tya tla la yu 'in jun tucueen 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Can' nguinu yu lo'o jun sca co' xaa, lo' xa nde xitucui yu se'en ndi'in jun nu ngua'an tñan 'in yu, lo'o suun ña'an msla' ta'a jun lo'o yu. ");
INSERT INTO cya_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Una yu Sila can' ncua lca tiquee yu quinu la yu quichen can'. ");
INSERT INTO cya_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Yu Pablo lo'o Bernabé ti' nguinu la yu quichen Antioquía, sca cha' ti 'in yu lo'o jun mda'an ycui' jun cha' tsu'hue 'in Ñi X'nan na, lo' ngulo'o jun 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chon' nde'en la can' juin yu Pablo 'in yu Bernabé: Tsa na'an na 'in nchgaa jun ta'a na nu ndi'in scasca quichen se'en ycui' na cha' tsu'hue 'in Ñi X'nan na, cha' ña'an ca ndi'in jun. ");
INSERT INTO cya_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Yu Bernabé ncua ti' yu tsa lo'o yu 'in yu Xuhua, yu nu nchcui' ne' lo'o lca Marco. ");
INSERT INTO cya_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Una yu Pablo a mslyaa tsa lo'o 'in yu, si'yana ti' la se'en lca Panfilia mxitucui yu lo' a mslyaa 'a yu ti' cu'ni yu tñan 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Lo' si'yana a ncua ca sca cha' ti 'in yu, can' cha' mdo'o tso' yu scasca yu. Yu Bernabé ya lo'o 'in yu Marco, lo' yten yu ni' sca yca na'an nu tiyaa se'en lca Chipre. ");
INSERT INTO cya_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Yu Pablo ngulohui 'in yu Sila si'yana ca ta'a tyi'an yu, lo' xa cua' mxnu jun cunta 'in yu yaa' Ñi X'nan na mdo'o yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mdijin yu se'en lyi'ya loo Siria lo'o Cilicia, mdaa yu cha' tnu tiquee 'in nchgaa jun nu cua' ya qui'an ti' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Chon' nde'en can' mdiyaa yu quichen Derbe lo'o Listra, can' ndi'in sca yu nu cua' ntsu'hui cha' 'in Jesús, lo' naan yu Timoteo. Ne' judio lca jyi'an yu, lo' ndiya qui'an ti' 'in Jesús, una sti yu lca ne' griego. ");
INSERT INTO cya_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jun ta'a na ndi'in quichen Listra lo'o Iconio, tsu'hue 'a suun ndaa jun cha' 'in yu Timoteo. ");
INSERT INTO cya_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Yu Pablo ncua ti' yu tsa lo'o yu 'in Timoteo, can' cha' m'ni yu cha' ncua circuncida 'in yu, si'ya cha' 'in ne' judio nu ndi'in quichen se'en ntsu'hui cha' tyijyin yu, lo' jlyo ti' ne' si'yana ne' griego lca sti yu Timoteo. ");
INSERT INTO cya_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Cunda scaa quichen ndyijyin yu, mtsa' yu 'in jun ña'an cha' nu mxnu scua yu ta'a mda'an Jesús lo'o yu nu ntsu'hui cunta 'in jun nu ndi'in quichen Jerusalén, si'yana xu'hua se'en jun nchgaa cha' nu nchcui' quityi can'. ");
INSERT INTO cya_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Cuaña'an nde lyee la jui cha' tnu tiquee 'in jun lo'o cha' nu cua' ya qui'an ti' jun, cunda scaa tsaan can' nchca qui'an la jun. ");
INSERT INTO cya_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mdijin ti yu se'en lca Frigia lo'o se'en lyi'ya loo Galacia, si'yana a mdaa Espíritu nu Luhui 'in Ndiose cha' cuiya' chcui' yu cha' tsu'hue 'in ñi sca chcui se'en lyi'ya loo Asia. ");
INSERT INTO cya_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Xa mdiyaa yu se'en lyi'ya loo Misia nu cua' tyijyin yu se'en lyi'ya loo Bitinia, ticui' ti ña'an a mdaa Espíritu cha' cuiya' sten yu se'en can'. ");
INSERT INTO cya_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Xacan' mdijin ñi ti yu se'en lyi'ya loo Misia, lo' mdiyaa yu quichen Troas. ");
INSERT INTO cya_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Sca tla can' na'an xñii yu Pablo sca cha', na'an yu ndon sca yu mdo'o se'en lyi'ya loo Macedonia, njñan cha' tsu'hue 'in yu lo' nchcui': Tyijyin xi'yu um lo' caan um se'en lyi'ya loo Macedonia, lo' ta yaa' um 'in hua. ");
INSERT INTO cya_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Xa na'an yu cha' can', cui' xaa m'ni hua cha' nu tsaa hua se'en lyi'ya loo Macedonia, si'yana ngujlyo tsu'hue ti' hua Ndiose lca nu ngulo tñan 'in hua tsa ycui' hua cha' tsu'hue 'in ñi se'en can'. ");
INSERT INTO cya_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Xacan' yten hua ni' sca yca na'an, mdijin ñi ti hua tsaya' mdiyaa hua se'en lca Samotracia, xca tsaan can' mdo'o ca'an hua quichen Neápolis. ");
INSERT INTO cya_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Can' mdo'o hua mda'an quiya' ti' hua, mdiyaa hua quichen Filipos, sca quichen nu ndon loo lati 'in Macedonia, lo' lca na quichen romano, can' nguinu hua tucua snan tsaan. ");
INSERT INTO cya_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tsaan nu nxitñan' ne' judio mdo'o hua nde tu'hua quichen se'en su chco tlyu, ñan ti' hua quija lyoo hua sca se'en nchcui' lyi'o ne' 'in Ndiose. Can' yten tucua hua, lo' mdyisnan ycui' hua cha' tsu'hue 'in Jesús lo'o ne' cuna'an nu cua' nguio' ti'in can'. ");
INSERT INTO cya_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lja can' ndon nscan sca ne' cuna'an naan Lidia nu mdo'o quichen Tiatira, ndujui' ne' te' nu tsu'hue ña'an cuaa, lo' lca ne' nu ndiya qui'an ti' 'in Ndiose. Si'ya cha' nu ycui' yu Pablo msla Ñi X'nan na cha' tiyaa 'in ne' si'yana tca cu'ni cunta ne' cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Xa cua' mducua tya ne' lo'o nchgaa nu ndi'in na'an 'in ne', juin ne' lo'o hua: Cha' 'un ndyu'hui lyoo um si'yana ndiya qui'an ti' hua 'in Ñi X'nan na, tsaa um lo' quinu um la na'an 'in hua. Cuaña'an mxicu'ni ne' 'in hua nguinu hua can'. ");
INSERT INTO cya_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Yato'o sca tsaan xa nguiaa hua se'en nchcui' lyi'o ne' 'in Ndiose, can' mchcua ta'a hua lo'o sca ne' cuna'an tsa suhue ti nu ntsu'hui cui'in xa'an 'in nu ntsa' ña'an cha' nu ljyaan 'in nten. Qui'an 'a canan n'ni x'nan ne' cuna'an can' si'ya cha' jlyo ti' can' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mducui ncha'an ne' 'in yu Pablo se'en nguiaa hua, lo' nchcui' cueen ne': Nchgaa yu re lca yu nguso 'in Ndiose, ñi nu tlyu lati, lo' nchcui' yu ña'an ntsu'hui cha' tyi'o laa um. ");
INSERT INTO cya_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ticui' ti loo cha' nda'an ycui' ne' cuna'an can' nchgaa tsaan, yu Pablo mxiya' ti' yu ña'an nchcui' ne', can' cha' mxiton yu, lo' juin yu 'in cui'in can': Nan' culon tñan 'in lo'o cha' cuiya' 'in Jesucristo, tyi'o lo' cula' ton 'in ne'. Cui' xaa mdyi'o cui'in can' 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Xa ngujlyo ti' x'nan ne' cuna'an can' si'yana a ndyu'hui 'a canan 'in ne' lo'o cha' jlyo ti' can', xacan' msñi ne' 'in yu Pablo lo'o yu Sila nu tyaa ne' cunta 'in yu 'in bsya. ");
INSERT INTO cya_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ña'aan mdiya lo'o ne' 'in yu tloo bsya, juin ne': Chcuaa yu judio re nxilo ti'in yu 'in nten quichen, ");
INSERT INTO cya_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","lo' ndlo'o yu ña'an cha' nu cua' ntsu'hui 'in yu, cha' nu a nga'an cha' cu'ni na, ñi a tca xu'hua se'en na, si'yana ndi'in na se'en lyi'ya loo Roma. ");
INSERT INTO cya_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Xacan' tsatlyu ngu'ya nten can' chon' yu, lo' yu bsya can' ngulo yu tñan si'yana tyi'o ste' yu lo' qui'ni yu. ");
INSERT INTO cya_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Xa lyee 'a cua' mjyi'in ne' 'in yu, xacan' msu'hua ne' 'in yu na'an chcuan, lo' ngulo ne' tñan 'in yu nu ntsu'hui cuan can', si'yana xñi tsu'hue yu cunta 'in chcuaa yu can'. ");
INSERT INTO cya_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mchcuan yu cunta 'in jun lo' msu'hua yu 'in jun cuarto nu qui'ñi la, can' mscan' yu quiya' jun tulja yca. ");
INSERT INTO cya_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yu Pablo lo'o yu Sila nchcui' lyi'o yu 'in Ndiose, nguila lo'o yu 'in ñi tlu'hue tla, lo' ne 'in nchgaa la ña'an yu preso can'. ");
INSERT INTO cya_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tsati ntyin mdyisnan nguñan lyee ya', tsaya' mchcuin ti'in suun na'an chcuan can', juesa nu nguñan nguila nchgaa tuna'an can', cui' ña'an lcaa nguitin' carena nchcan' nchgaa yu preso can'. ");
INSERT INTO cya_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mdyi'o sla yu nu ntsu'hui cuan can', na'an yu si'yana cua' nducua la nchgaa tuna'an can', ngulyoo yu spada lo' ncua ti' yu cujui yu 'in yu si'yana ñan ti' yu cua' ngulaa nchgaa preso can'. ");
INSERT INTO cya_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Una yu Pablo ycui' cueen yu: A cu'ni um ti'i lo'o um, si'yana nchgaa hua ndi'in hua re. ");
INSERT INTO cya_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Xacan' yu nu ntsu'hui cuan can' mjñan yu quii', lo' ndla ndsa ti yten yu ña'an chcuan can', lyee mchcuan yu, mdyi'ya sti yu 'in yu tloo yu Pablo lo'o yu Sila can'. ");
INSERT INTO cya_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Xacan' ngulyoo yu 'in chcuaa yu can', lo' mñicha' yu 'in: ¿Ñi na tca cu'nin si'yana tca tyi'o laan? ");
INSERT INTO cya_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mxcuen chcuaa yu can': Tsa qui'an ti' um 'in Ñi X'nan na Jesucristo, lo' tyi'o laa um lo'o nchgaa nu ndi'in na'an 'in um. ");
INSERT INTO cya_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ycui' yu cha' tsu'hue 'in Ñi X'nan na lo'o yu can', tsatlyu lo'o nchgaa nu ndi'in na'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ticui' tla can' mjyi'an yu se'en ti'i 'in chcuaa yu can', cui' ña'an lcaa mducua tya yu lo'o nchgaa nu ndi'in na'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Xacan' ya lo'o yu 'in chcuaa yu can' la na'an 'in yu, can' mxicu ne' 'in yu. Tsu'hue ntsu'hui tiquee yu tsatlyu lo'o nchgaa nu ndi'in na'an 'in yu, si'yana ya qui'an ti' yu 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Xa ngu'ya xaa, yu bsya can' ngulo yu tñan 'in tucua snan silyiya si'yana tsa lo'o yu suun 'in yu nu ntsu'hui cuan can', si'yana tca culaa yu 'in yu Pablo lo'o yu Sila. ");
INSERT INTO cya_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yu nu ntsu'hui cuan can' juin 'in yu Pablo: Yu bsya msu'hua yu suun si'yana culaa hua 'in um. Cua' tca quiaa um, a sca la cha' chu'hui tiquee um. ");
INSERT INTO cya_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Xacan' mxcuen yu Pablo can': Huare' lca hua ne' lyi'ya loo Roma, mjyi'in ne' 'in hua tloo nten quichen lo' ti' lyijyi ca cuiya' cha' 'in hua, msu'hua ne' 'in hua na'an chcuan, lo' cua' ñii nchca ti' ne' culaa ne' 'in hua cuati ña'an. Una a tyi'o hua cha' na si'i ycui' ca yu quian lyoo yu 'in hua. ");
INSERT INTO cya_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Xacan' nguia ytsa' yu silyiya can' 'in yu bsya ña'an cha' nu ycui' yu Pablo can'. Ytsen yu xa ynan yu cha' si'yana yu Pablo lo'o yu Sila lca yu ne' lyi'ya loo Roma. ");
INSERT INTO cya_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Cui' xaa yaa yu bsya can', lo' mjñan yu cha' tlyu ti' 'in chcuaa yu can', xacan' ngulaa ne' 'in yu, lo' mjñan ne' cha' tsu'hue 'in yu si'yana tyi'o yu quichen can'. ");
INSERT INTO cya_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Xa mdyi'o yu na'an chcuan, mdijin yu se'en nducua na'an 'in Lidia, can' na'an ta'a yu lo'o jun ta'a na, mdaa yu cha' tnu tiquee 'in jun, xacan' mdo'o yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tucueen nguiaa yu mdijin yu quichen Anfípolis lo'o Apolonia, xacan' mdiyaa yu quichen Tesalónica, can' nducua sca se'en n'ni tnu ne' judio 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ña'an cha' nu cua' ntsu'hui 'in yu Pablo yaa yu se'en ndiyo' ti'in ne' judio, lo' tsani' snan snan ya ycui' yu lo'o ne', cui' tsaan nu nxitñan' ne', ");
INSERT INTO cya_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ndlyo scua la yu cha' 'in Cristo tsaña'an nchcui' quityi 'in Ndiose, si'yana m'ni 'a cha' ngujui ñi lo' mdyiqui'o ñi. Nchcui' yu: Jesús, ñi nu 'in cha' nchcuin' re lca ñi Cristo. ");
INSERT INTO cya_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tucua snan ne' judio nu ya qui'an ti' 'in Jesús, ncua sca cha' ti 'in ne' lo'o yu Pablo lo'o yu Sila can'. A cunta qui'an ne' griego nu ndiyo' ti'in can' ya qui'an ti' 'in ñi, cui' cuaña'an tyun ne' cuna'an nu ndon loo lati. ");
INSERT INTO cya_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Una yten cha' nsin' ti' 'in ne' judio nu a ya qui'an ti', mxo' ta'a ne' lo'o yu nducun' nu cua' la nxiton ti, lo' mxilo ti'in ne' nten quichen, nducua ñi mdiyaa ne' ña'an 'in yu Jasón si'yana culyoo ne' 'in chcuaa yu can', lo' tyaa ne' cunta 'in yu tloo nten quichen. ");
INSERT INTO cya_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Una a nguija lyoo yu, can' cha' ticuii' yu Jasón ya lo'o ne' 'in yu tloo bsya, lo'o chcua xnan jun ta'a na, lo' nchcui' cueen ne': Yu re nda'an nxilo ti'in nten sca chcui chendyu, lo' cua' ñii mdiyaan yu quichen tyi na re. ");
INSERT INTO cya_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yu Jasón, nde nu mdaa se'en mdiyaan yu, lo' ngui'ni lye' ti' yu 'in lee nu mxnu scua yu César, nchcui' yu si'yana ntsu'hui xca ree 'in yu nu lca Jesús. ");
INSERT INTO cya_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Xa ngune 'in ne' cha' can', nde lyee la nguilo ti'in ne' lo'o bsya 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Una la msu'hua lyiya' yu Jasón lo'o ta'a nda'an yu, xacan' ngulaa bsya 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ticui' tla can' mducui xu'hua jun ta'a na 'in yu Pablo lo'o yu Sila nde quichen Berea. Xa mdiyaa yu quichen can' yten yu se'en n'ni tnu ne' judio 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Lyee la suun ña'an ndi'in cha' 'in ne' can' que 'in ne' Tesalónica, si'yana cui' xaa ncuan xu'hue ne' cha' tsu'hue 'in Ndiose. Cunda scaa tsaan can' ngui'ni quii tsu'hue ne' loo quityi 'in Ndiose, cha' na cui' ca ña'an ndlo'o yu Pablo can'. ");
INSERT INTO cya_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Qui'an 'a ne' judio ya qui'an ti' 'in Jesús, cui' cuaña'an qui'an ne' cuna'an nu ndon loo lati lja ne' griego, a cunta qui'an yu qui'yu ya qui'an ti' yu. ");
INSERT INTO cya_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Una xa ynan ne' judio nu ndi'in quichen Tesalónica si'yana lo'o quichen Berea cua' nda'an ycui' yu Pablo cha' tsu'hue 'in Ndiose, cui' xaa yaa ne' quichen can', ticui' ti ña'an mxilo ti'in ne' 'in nten can'. ");
INSERT INTO cya_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ticui' xaa mducui xu'hua jun 'in yu Pablo tsaa yu tucueen nu ndiyaa tu'hua tyi'a tujo'o. Yu Sila lo'o yu Timoteo ti' nguinu yu quichen can'. ");
INSERT INTO cya_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ntsu'hui jun nu mdiya lo'o yu Pablo la quichen Atenas. Xacan' mxitucui jun lo' ngu'ya jun suun 'in yu Sila lo'o yu Timoteo, si'yana tsaa yu ticui' xaa se'en nta yu Pablo can' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Lja nta yu Pablo 'in ta'a nda'an yu quichen Atenas can', ti'i 'a nga'an 'in yu xa na'an yu si'yana siya' ti mdyaa ne' 'in ne' lo'o tso' cha' 'in jo'o. ");
INSERT INTO cya_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Se'en ndiyo' ti'in ne' judio mdyisnan ycui' tyijyin ne' lo'o yu si'ya cha' 'in Ndiose, ne' judio lo'o ne' gentil, a cunta nchgaa tsaan nchcui' yu lo'o ña'an tucui ti se'en nchca quiya' can'. ");
INSERT INTO cya_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Quichen can' ndi'in tucua ta yu bstro nu m'ni cha'an cha' tiyaa 'in nten chendyu, sca ta ne' naan ne' epicurios, lo' xca ta ne' naan ne' estoicos. Mdyisnan ycui' tyijyin ne' lo'o yu Pablo, lo' ntsu'hui nu nchcui': ¿Ñi na nchcui' yu nchca nchcui' re? Ntsu'hui xca nu nchcui': Cua' lca na nchcui' yu cha' 'in xca jo'o nu cui ti. Si'yana yu Pablo nchcui' yu cha' tsu'hue 'in Jesús, a cunta si'yana ndyiqui'o nten. ");
INSERT INTO cya_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Xacan' ya lo'o ne' 'in yu sca se'en naan Areópago, can' mñicha' ne' 'in yu: ¿Ta tca quitsa' um 'in hua ña'an cha' nu cui ti ndlo'o um? ");
INSERT INTO cya_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Si'yana nchcui' um cha' nu a nchca siya' quine 'in hua, lo' nchca ti' hua ca jlyo ti' hua ñi cha' nchca ti' chcui' cha' re. ");
INSERT INTO cya_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Si'yana nchgaa ne' Atenas lo'o ne' nu mdiya ti'in ti can', a sca la xa' cha' ntsu'hui yuhue ti' ne', cui' ca nu nchcui' ne' uta ne 'in ne' cha' nu cui ti.) ");
INSERT INTO cya_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Xacan' mdyiton yu Pablo tlu'hue la se'en lca Areópago, lo' juin yu: Nchgaa 'un ne' Atenas, ncua cuiya' tin' si'yana lca um nten nu lyee 'a ndiya qui'an ti'. ");
INSERT INTO cya_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Si'yana se'en mdijin loo quichen re m'nin quiin scasca se'en nducua jo'o 'in um, can' na'an sca cha' lo' nchcui' na: 'IN NDIOSE NU A NDYU'HUI LYOO NA. N'ni tnu um 'in ñi siya' a ndyu'hui lyoo um 'in ñi, can' ñi nu 'in cha' nchcuin' cua' ñii, ");
INSERT INTO cya_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","cui' Ndiose nu mtñan chendyu lo'o nchgaa loo na nu chcan', lo' si'yana lca ñi X'nan ni' cuaan lo'o loo chendyu re, a nducua ñi ni' lyaa nu mtñan yaa' nten chendyu. ");
INSERT INTO cya_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ñi a 'ni cha' caja nu ta yaa' 'in ñi, ta si'yana nde'en la cha' ndiya lyijyi 'in ñi, cui' ca nu nde ycui' ñi ndaa ñi chendyu 'in na, n'ni ñi cha' ndiyaan cui'in na, lo' ndaa ñi nchgaa loo na nu najo'o 'in na. ");
INSERT INTO cya_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Si'ya scati yu qui'yu, m'ni ñi cha' yton nchgaa ta nten si'yana tyi'in ne' sca chcui chendyu, cui' ñi m'ni cuiya' ñi cuaan xaa, cui' cuaña'an se'en ntsu'hui cha' tyi'in na, ");
INSERT INTO cya_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ña'an ca si'yana quia nan na 'in Ndiose, lo' a s'ni quija lyoo ñi 'in na, siya' jnan yaa' ti na, si'yana cha' ñi a tijyo' nchca ñi 'in na cunda scaa na. ");
INSERT INTO cya_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Si'ya ñi can' cha' ndu'hui na, ndyi'an na, can' cha' lo'o na. Lca na ña'an juin sca yu ta'a quichen tyi um xa ngua'an yu cha' re: Ta nten 'in Ndiose lca na. ");
INSERT INTO cya_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Lo' si'yana lca na ta nten 'in Ndiose, a ntsu'hui cha' quiñan ti' na, ta lca ñi ña'an nchca ti' sca lcuin oro uta plata, lo' ta sca lcuin quee, ña'an nchca ti' sca na nu ntñan yaa' nten chendyu lo'o cha' tiyaa 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Una Ndiose yu'hui cha' tlyu ti' 'in ñi lo'o nten nu mdi'in cua' s'ni si'ya cha' tinto 'in ne', una cua' ñii ndlo ñi tñan 'in nchgaa nten sca chcui chendyu si'yana tyaa ti' ne' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Si'yana Ndiose cua' mdi'in tyaa ñi sca tsaan nu cu'ni ñi xñan bsya 'in nten chendyu lo'o sca cha' nu ñi, si'ya scati yu qui'yu nu cua' mdo'o hui 'in ñi, lo' tca tsa qui'an ti' na 'in ñi, si'yana Ndiose m'ni ñi cha' mdyiqui'o can'. ");
INSERT INTO cya_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Una xa ngune 'in ne' si'yana ntsu'hui cha' tyiqui'o ne' cua' ngujui, ntsu'hui nu mstyi lyi'o 'in yu, lo' ntsu'hui nu juin: La xiya' la quine 'in hua cha' nu nchcui' um re. ");
INSERT INTO cya_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Xacan' mdo'o yu Pablo se'en nguio' ti'in ne' can'. ");
INSERT INTO cya_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Una ntsu'hui tucua snan nu ya qui'an ti' 'in Jesús nu ncua sca cha' ti 'in lo'o yu. Lja can' ntsu'hui sca yu naan Dionisio, cui' ta 'in ne' Areópago, a cunta ya qui'an ti' sca ne' cuna'an naan Dámaris, lo'o chcua xnan ta'a nda'an ne'. ");
INSERT INTO cya_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Chon' nde'en can' mdo'o yu Pablo quichen Atenas, lo' mdiyaa yu quichen Corinto. ");
INSERT INTO cya_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Can' mchcua ta'a yu lo'o sca yu judio naan Aquila nu ncua cune' se'en lca Ponto. Ti' mdo'o ti yu se'en lca Italia lo'o Priscila cuilyi'o yu, si'ya cha' 'in Claudio nu ngulo tñan si'yana ntsu'hui cha' tyi'o nchgaa ne' judio quichen Roma. ");
INSERT INTO cya_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Si'yana sca loo ti tñan n'ni yu Pablo lo'o jun, can' cha' nguinu yu se'en ndi'in jun, lo' tsatlyu mtñan jun te' na'an. ");
INSERT INTO cya_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cunda scaa tsaan nu nxitñan' ne' judio, ndyi'an yu Pablo se'en ndiyo' ti'in ne' lo' nan yu ña'an nu qui'ya ne' cha' tiyaa, una ne' judio lo'o ne' griego lyee nchcui' tyijyin ne' lo'o yu. ");
INSERT INTO cya_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Xa mdiyaa yu Sila lo'o yu Timoteo nu mdo'o se'en lyi'ya loo Macedonia, la xacan' jui ña'an mdyaa yu Pablo 'in yu siya' ti nu chcui' yu cha' tsu'hue 'in Ndiose, lo' mtsa' la yu 'in ne' judio si'yana Jesús lca ñi Cristo, ñi nu ngua'an tñan Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Una ne' judio can' m'ni lye' ti' ne', mdyisnan mdaja ne' 'in yu, xacan' mscuin yu Pablo ste' yu lo' juin yu 'in ne': Quinu cunta 'in um cha' quinan' cusya 'in um, lo' si'i 'a cunta 'ñan. Ti' cua' ñii tsa ycuin' cha' tsu'hue re lo'o ne' gentil. ");
INSERT INTO cya_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ña'aan mdyi'o yu se'en can' mdiyaa yu na'an 'in sca yu naan Justo, lca yu sca nu n'ni tnu 'in Ndiose, lo' nducua na'an 'in yu sii' se'en ndiyo' ti'in ne' judio. ");
INSERT INTO cya_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Yato'o yu Crispo, yu nu ndlo tñan se'en n'ni tnu ne' judio 'in Ndiose, ya qui'an ti' yu 'in Ñi X'nan na lo'o nchgaa nu ndi'in ña'an 'in yu. Cui' cuaña'an qui'an ne' Corinto, xa ngune 'in cha' tsu'hue 'in Jesús ya qui'an ti' ne' 'in ñi, lo' mducua tya ne'. ");
INSERT INTO cya_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sca tla can' na'an xñii yu Pablo 'in Ñi X'nan na, lo' nchcui' ñi: A cutsen, tsa quiñan chcui' la cha' re, lo' a cula' ti', ");
INSERT INTO cya_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","si'yana nan' ndi'in lo'o nchgaa xaa, a tucui nu tca cu'ni ti'i lo'o, si'yana qui'an 'a nten ndi'in quichen re nu cua' ngulohuin. ");
INSERT INTO cya_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Can' mdi'in yu Pablo sca yjan tlu'hue, ndlo'o yu 'in nten cha' tsu'hue 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Yu Galión ncua yu gubierno se'en lyi'ya loo Acaya, lo' ne' judio tsatlyu m'ni sca ne' cha' msñi ne' 'in yu Pablo, lo' ya lo'o ne' 'in yu se'en nchca cuiya' qui'ya, ");
INSERT INTO cya_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","lo' juin ne': Yu re nda'an xicu'ni yu 'in nten si'yana xcaña'an cu'ni tnu na 'in Ndiose, lo' si'i 'a ña'an nu nchcui' lee 'in na. ");
INSERT INTO cya_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Cua' tyi'o ycui' ti yu Pablo xa mdo'o ycui' yu Galión, lo' juin yu 'in ne' judio: Nchgaa 'un ne' judio, cha' nde'en la qui'ya m'ni yu re, uta yjui yu nten, la xacan' tca cu'nin cunta cha' nu nchcui' um. ");
INSERT INTO cya_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Una cha' lca na chacui' cha' ti, ña'an nu ngui'ni tyi'ya um nii nten lo'o lee 'in um, tca cu'ni cuiya' um cha' can' ticui' ti um, si'yana nan' a nguiten yu'huin cha' nu cuaña'an. ");
INSERT INTO cya_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Xacan' ngulyoo yu 'in ne' nde lyiya'. ");
INSERT INTO cya_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Cui' ña'aan lca msñi ne' 'in yu Sóstenes, yu nu ndlo tñan se'en n'ni tnu ne' judio 'in Ndiose, lo' yjui ti'in ne' 'in yu cui' se'en ti se'en nchca cuiya' qui'ya can', una yu Galión can' a mda quiya' yu 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Yu Pablo tyun 'a tsaan ti' nguinu yu quichen can'. Xa cua' msla' ta'a yu lo'o jun, mdo'o yu nguiaa yu lo'o Priscila lo'o yu Aquila, lo' mdiyaa jun quichen Cencrea, can' msi'yu quichan' que yu Pablo si'ya sca ca nu cua' mdi'in tyaa yu, xacan' yten jun ni' sca yca na'an si'yana nde cua' quiaa yu Pablo se'en lca Siria. ");
INSERT INTO cya_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Xacan' mdyi'o ti'in yca na'an can' quichen Efeso, can' nguinu yu Aquila lo'o Priscila. Ti' yaa yu Pablo se'en n'ni tnu ne' judio 'in Ndiose, lo' mdyisnan ycui' tyijyin ne' lo'o yu. ");
INSERT INTO cya_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mjñan ne' cha' tsu'hue 'in yu si'yana ti' quinu la yu lo'o ne' chcua xnan tsaan, una a jui 'a ña'an 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Xacan' msla' ta'a yu lo'o ne' lo' juin yu: 'Ni cha' tsa'an quichen Jerusalén si'yana cua' nchcui cha' ca ta'a la cua, una xiya' la ljyaan cha' Ndiose ljuin ñi. Xacan' yten yu ni' yca na'an, mdo'o yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Xa mdiyaa yca na'an can' quichen Cesarea, mdo'o yu nguiaa yu nde Jerusalén, ya ycui' cha' yu 'in jun ta'a na, xacan' mdo'o yu nguiaa yu nde quichen Antioquía. ");
INSERT INTO cya_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Xa cua' mdi'in yu can' sca co' xaa, xca juesa yaa yu cunda scaa quichen, ya na'an yu 'in jun nu cua' ntsu'hui cha' 'in Jesús nu ndi'in se'en lyi'ya loo Galacia, lo'o Frigia, lo' mdaa yu cha' tnu tiquee 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yato'o quichen Efeso mdiyaa sca yu judio naan Apolo, nu ncua tyi quichen Alejandría, tsu'hue 'a nchcui' yu, lo' ndyu'hui lyoo tsu'hue yu quityi 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jui nu ngulo'o 'in yu cha' tsu'hue 'in Ñi X'nan na, nchcui' yu cha' can' lo'o nu chcui lca tiquee yu, lo' ndlo'o yu chcui ña'an nguiaa cha' 'in Ñi X'nan na, siya' tsa mducua tya ti yu ña'an nu ngulo'o yu Xuhua 'in nten. ");
INSERT INTO cya_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mdyisnan ngulo'o yu 'in ne' judio se'en n'ni tnu ne' 'in Ndiose lo'o cha' tnu tiquee 'in yu, una xa ngune 'in Priscila lo'o yu Aquila ña'an cha' nchcui' yu, ya lo'o jun 'in yu se'en scati yu, mtsa' lyicua la jun 'in yu sca chcui ña'an nguiaa cha' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Yten tiquee yu tyijyin xi'yu yu tsaa yu se'en lyi'ya loo Acaya, cui' cuaña'an mdaa jun cha' tnu tiquee 'in yu, xacan' ngua'an jun sca quityi cui'ya yu si'yana cuan xu'hue jun 'in yu, lo' xa mdiyaa yu lyee 'a mda yaa' yu 'in jun lo'o tso' cha' 'in Ndiose, cui' jun nu cua' ya qui'an ti' si'ya cha' tsu'hue 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ngula 'a ycui' yu lo'o ne' judio tloo nten quichen can', si'yana si'i ña'an cha' tiyaa 'in ne', lo' ngulyo scua la yu ña'an nchcui' quityi 'in Ndiose si'yana Jesús lca ñi Cristo, ñi nu ngua'an tñan Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Lja ti' ndi'in yu Apolo quichen Corinto can', yu Pablo cua' mdijin yu scasca quichen nu ndi'in nde loo la se'en lca Frigia tsaya' mdiyaa yu quichen Efeso, can' na'an ta'a yu lo'o tucua snan yu nu cua' ntsu'hui cha' 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Mñicha' yu Pablo 'in yu: ¿Ta ncuan xu'hue um 'in Espíritu nu Luhui 'in Ndiose xa ya qui'an ti' um? Mxcuen yu xacan': Ñi siya' a nchca quine 'in hua cha' ntsu'hui Espíritu nu Luhui 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Xacan' juin yu Pablo 'in yu: ¿Ña'an ta mducua tya um cha' na can'? Xacan' mxcuen yu: Tsaloo mducua tya ti hua ña'an ngulo'o yu Xuhua 'in nten. ");
INSERT INTO cya_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Juin yu Pablo: Yu Xuhua mducua tya yu 'in nten tsalca nu cua' mxilo'o chon' qui'ya ngui'ni, una ycui' yu lo'o ne' si'yana tsa qui'an ti' ne' 'in nu ntsu'hui cha' caan nde chon' la, cui' Jesús, ñi nu lca Cristo. ");
INSERT INTO cya_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Xa ngune 'in yu cha' can', mducua tya yu lo'o cha' cuiya' 'in Ñi X'nan na Jesús. ");
INSERT INTO cya_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Xa mdi'in tyaa yu Pablo yaa' yu 'in yu can', cui' ña'an lcaa mtsa'an yu'hui Espíritu nu Luhui 'in Ndiose 'in yu, lo' mdyisnan ycui' yu lenguas lo' ycui' yu cha' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Loo nchgaa yu ndiyaa yu tsaa tichcua yu. ");
INSERT INTO cya_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Yu Pablo can', tsani' snan coo' lo'o cha' tnu tiquee 'in yu nda'an ycui' yu lo'o ne' judio se'en n'ni tnu ne' 'in Ndiose, lyee 'a ycui' tyijyin ne' lo'o yu, una ngunan yu ña'an nu qui'ya ne' cha' tiyaa ña'an ntsu'hui cha' culo Ndiose tñan 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ntsu'hui nu tla cusya 'in, a mslyaa tsa qui'an ti', mxiycha' ne' Tucueen 'in Ñi X'nan na tloo ndi'in nten can'. Can' cha' ngulo tso' yu Pablo 'in tsalca jun nu cua' ntsu'hui cha' 'in Jesús, lo' ya lo'o yu 'in jun se'en nducua sca na'an xcula 'in sca yu naan Tiranno, lo' cunda scaa tsaan ndlyo scua la yu cha' 'in Ndiose lo'o jun. ");
INSERT INTO cya_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Cuaña'an ya quiñan ycui' yu lo'o nten tsani' tucua yjan, yato'o nchgaa ne' judio lo'o ne' gentil nu ndi'in se'en lyi'ya loo Asia ngune 'in ne' cha' tsu'hue 'in Ñi X'nan na Jesús. ");
INSERT INTO cya_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mdaa Ndiose cha' cuiya' 'in yu Pablo si'yana cu'ni yu scasca cha' nu tnu, ");
INSERT INTO cya_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","nu hasta lo'o te' pañitu uta te' nu nchco' yu, cha' tsa lo'o jun 'in na se'en nscua nu ti'i, lo' nchca, lo' nu ntsu'hui cui'in xa'an 'in cui' xaa ndla' ton na 'in. ");
INSERT INTO cya_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Quichen can' mdiyaa tucua snan ne' judio nu nda'an loo cui'in xa'an 'in nten, ncua ti' ne' si'yana lo'o cha' cuiya' 'in Ñi X'nan na Jesús culo ne' cui'in xa'an can', lo' nchcui' ne': Lo'o cha' cuiya' 'in Jesús nu n'ni tyi'ya yu Pablo, tyi'o lyiya'. ");
INSERT INTO cya_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Cuaña'an m'ni tsa cati sñe' sca yu judio naan Esceva, yu nu ndlo tñan se'en n'ni tnu ne' judio 'in Ndiose quichen can'. ");
INSERT INTO cya_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Una mxcuen cui'in xa'an can' 'in ta'a yu can': Ndyu'hui lyoon 'in Jesús, lo' jlyo tin' ti ca lca Pablo, una 'un, ¿ti ca lca um? ");
INSERT INTO cya_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yu nu ntsu'hui cui'in xa'an can' 'in, siya' mdo'o cuaan ti yu chon' nchgaa yu can', lo' m'ni canan 'in yu tsaya' mdo'o yu ña'an can' msnan yu cunan' ti yu, a cunta ngujui yuhua' yu. ");
INSERT INTO cya_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mscua cueen cha' re ña'aan quichen Efeso can', lo' ne' judio lo'o ne' gentil yten sca ytsen ni' cusya 'in ne', nde lyee la m'ni tnu ne' 'in Ñi X'nan na Jesús si'ya cha' can'. ");
INSERT INTO cya_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Qui'an 'a jun nu ndiya qui'an ti' 'in Jesús mdyisnan nguñee jun qui'ya 'in jun tloo nchgaa la ña'an jun can'. ");
INSERT INTO cya_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Cui' cuaña'an lo'o ne' jlyo ti', nguian lo'o ne' nchgaa quityi nu m'ni cha'an ne', lo' mdiquin ne' 'in na tloo ndi'in jun can'. Ngulo ne' cunta tsaña'an ntsu'hui lyoo quityi can', lo' ndiyaa na tu'hua tyi mii tñi plata. ");
INSERT INTO cya_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Cuaña'an lyee la nguia nguine yu'hui cha' tsu'hue 'in Ñi X'nan na lo'o cha' cuiya' 'in ñi. ");
INSERT INTO cya_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Xa cua' mdijin nchgaa cha' can', yten tiquee yu Pablo xitucui yu Jerusalén. Una culo nducua la tsa tijin yu ña'aan se'en lyi'ya loo Macedonia lo'o se'en lca Acaya. Ñan ti' cusya 'in yu: Xa cua' mdi'in chin' can', 'ni cha' tsa'an quichen Roma. ");
INSERT INTO cya_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Yu Pablo ngua'an tñan yu 'in tucua yu ta'a nda'an yu, Timoteo lo'o Erasto, tsaa yu se'en lyi'ya loo Macedonia, lo' ti' nguinu la yu xca co' xaa se'en lyi'ya loo Asia. ");
INSERT INTO cya_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lja xacan' lyee 'a nguilo ti'in ne' Efeso si'ya jun nu cua' ntsu'hui Tucueen 'in Jesús. ");
INSERT INTO cya_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sca yu naan Demetrio ntñan yu lcuin laa suhue ti lo'o plata 'in sca jo'o naan Diana, lo' qui'an 'a canan n'ni yu lo'o tñan can', ");
INSERT INTO cya_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","mxo' ti'in yu 'in ta'a cuityi chcuan yu, lo' juin yu: 'Un yu nu ta'a ngui'ni na tñan re, jlyo tsu'hue ti' um si'yana ndyu'hui 'a canan 'in na lo'o tñan re. ");
INSERT INTO cya_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nchgaa na na'an na lo' ne 'in na ña'an nda tsaa yu Pablo 'in nten, lo' tsala ña'an qui'an ne' cua' ngulo tso' yu 'in quichen re lo'o ña'aan se'en lyi'ya loo Asia, lo' nchcui' yu si'yana si'i Ndiose lca na nu ntñan yaa' nten. ");
INSERT INTO cya_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Chen nchcui 'in na, si'i tsa tñan ti re tnan' na, cui' ca nu lo'o laa 'in na se'en nducua jo'o Diana, a tucui 'a nu su'hua loo 'in na, lo' tsato'o tsu'hue tsu'hue ti jlya ti' ne' 'in jo'o x'nan na nu lyi'ya loo ña'aan se'en lca Asia, lo'o sca chcui chendyu. ");
INSERT INTO cya_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Xa ngune 'in yu cha' can', lyee 'a ycuen tique' yu, lo' ycui' cueen yu: ¡Tla cha' 'in jo'o Diana, x'nan ne' Efeso! ");
INSERT INTO cya_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Xacan' nguilo ti'in ña'aan quichen ne', tsatlyu ngu'ya ne' chon' tucua yu Macedonia ta'a nda'an yu Pablo, yu Gayo lo'o yu Aristarco, ya lo'o ne' 'in yu se'en nchca cuiya' qui'ya. ");
INSERT INTO cya_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Yu Pablo ncua ti' yu tsa ycui' yu lo'o nten quichen can', una a mdaa jun cha' cuiya'. ");
INSERT INTO cya_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Cui' cuaña'an tucua snan ta'a tsu'hue yu Pablo nu lca bsya se'en lyi'ya loo Asia, msu'hua ne' suun 'in yu lo' mjñan ne' cha' tsu'hue si'yana a tsa su'hua tloo yu se'en nguio' ti'in nten quichen can'. ");
INSERT INTO cya_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nten can' scasca ña'an nchcui' cueen ne' se'en nchca cuiya' cha' can', una qui'an la nu a ndyi'ya cha' tiyaa ñi na nchca. ");
INSERT INTO cya_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Lja nten can' mxicu'ni ne' judio 'in sca yu naan Jantro si'yana chcui' yu tloo nten can', lo' m'ni yaa' yu si'yana tyi'in seen ne' se'en nu chcui' yu tñan loo ne' judio. ");
INSERT INTO cya_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Una xa yu'hui lyoo ne' si'yana lca yu ne' judio, xacan' tsatlyu ycui' cueen ne' tsani' tucua braa, lo' nchcui' ne': ¡Tla cha' 'in jo'o Diana, x'nan ne' Efeso! ");
INSERT INTO cya_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Yu lca scarano quichen can', xa m'ni yu canan mdi'in seen nten can', juin yu xacan': Nchgaa 'un ne' Efeso, ¿ta ntsu'hui nu a jlyo ti' si'yana quichen re nducua laa 'in jo'o Diana, a cunta nde nducua jo'o x'nan na nu mdo'o tyu nde ni' cuaan se'en lca Jupiter? ");
INSERT INTO cya_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","A tucui nchcui' si'yana si'i cuaña'an ca lca na, tsu'hue lati tyi'in seen um, a cu'ni um sca cha' ndla ndsa, ");
INSERT INTO cya_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","tsaña'an mdiyan lo'o um 'in chcuaa yu re, ñi sca cunan lo' a nchca cu'ni yu ni' lyaa re, ñi a nchcui' ca'an yu 'in jo'o x'nan na. ");
INSERT INTO cya_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Cha' yu Demetrio lo'o ta'a ngui'ni yu tñan ntsu'hui ña'an nsuun yu lo'o nde'en la tucui, mdiyaa se'en ca cuiya' cha' 'in yu tloo bse, can' tca su'hua qui'ya ta'a yu. ");
INSERT INTO cya_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Cha' ta nde'en la xca cha' ndi'in 'in um, tca chcui' um cha' can', una tsaan nu n'ni cuiya' ca na tñan. ");
INSERT INTO cya_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Si'yana tsaña'an nu nguilo ti'in na cua' ñii, chen 'a nchcui 'in na cha' ca jlyo ti' gubierno cha' re, ñi a jlyo ti' na ñi suun taa na cha' cuñicha' ne' 'in na. ");
INSERT INTO cya_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ña'aan mdyi ycui' yu cha' can' msla' ta'a yu lo'o nten can'. ");
INSERT INTO cya_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Xa cua' mdi'in tiin nten can', mxo' ti'in yu Pablo 'in jun ta'a na, mdaa yu cha' tnu tiquee 'in jun, lo' msla' ta'a yu lo'o jun, xacan' mdo'o yu nguiaa yu se'en lyi'ya loo Macedonia. ");
INSERT INTO cya_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Mdijin yu scasca quichen se'en ndi'in jun, qui'an 'a cha' ycui' yu lo' mdaa yu cha' tnu tiquee 'in jun, xacan' mdo'o yu nguiaa yu se'en lyi'ya loo Grecia. ");
INSERT INTO cya_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Can' nguinu yu snan coo'. Cua' sten yu ni' yca na'an nu tsaa se'en lyi'ya loo Siria, xa ynan yu cha' si'yana ntsu'hui ta ne' judio 'in yu, can' cha' mdi'in tyaa yu cha' si'yana xitucui yu se'en lyi'ya loo Macedonia. ");
INSERT INTO cya_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nde ta'a mda'an yu Pablo tsaya' yten jun se'en lyi'ya loo Asia: Yu Sópater nu mdo'o quichen Berea, lo'o tucua yu Tesalónica, yu Aristarco lo'o yu Segundo, yu Gayo nu mdo'o quichen Derbe, yu Timoteo, lo'o tucua yu Asia, yu Tíquico lo'o yu Trófimo. ");
INSERT INTO cya_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yu re mducua loo yu, lo' mta yu 'in hua quichen Troas. ");
INSERT INTO cya_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Xa cua' mdyi ta'a nu nchcu ne' jaslya nu a yu'hui suun, xacan' mdo'o hua quichen Filipo yten hua ni' yca na'an, lo' ni' ca'yu tsaan yu'hui lyijyi hua nu mdiyaa hua quichen Troas, can' na'an ta'a hua lo'o yu Pablo xiya' se'en nguinu hua sca snan. ");
INSERT INTO cya_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Culoo tsaan nu mducua snan can', nguio' ti'in jun ta'a na nu cu'ni jun siin, lo' yu Pablo mdyisnan ngulo'o yu 'in jun tsaya' mdiyaa tlu'hue tla, si'yana xca ti tsaan can' cua' ntsu'hui cha' tyi'o yu. ");
INSERT INTO cya_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nguio' ti'in jun sca na'an nu cua' nchca snan nde cuaan se'en tyun 'a quii' nducua quiin. ");
INSERT INTO cya_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Sca yu lyo' ti naan Eutico nducua yu se'en lca ventana, lo' ngu'ya tnu sla yu si'yana chaan 'a ycui' yu Pablo. Ti' la can' mdo'o tyu yu, cua' lca ngujui yu xa mxitucui ne' 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mdiyaa yu Pablo se'en su yu lyo' ti can', lo' msu'hua tuscun yu 'in se'en su, lo' juin yu 'in jun: A su'hua um cha' tiquee um si'yana cua' nguila cha' tiyaa 'in yu re. ");
INSERT INTO cya_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Xiya' ycuen yu Pablo la cuaan can', lo' xa cua' mdyi ycu siin yu lo'o jun, xca juesa mdyisnan ngulo'o yu 'in jun tsaya' nde cua' ljyaan xaa, la xacan' mdo'o yu nguiaa yu. ");
INSERT INTO cya_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tsu'hue 'a ntsu'hui tiquee jun nguia lo'o jun 'in yu lyo' ti can' si'yana ti' nguila cha' tiyaa 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Xacan' nchgaa la ña'an hua mducua loo hua yten hua ni' yca na'an can', mdiyaa hua quichen Asón se'en mta hua 'in yu Pablo, si'yana mdi'in tyaa yu cha' tsaa yu tucueen lyuu. ");
INSERT INTO cya_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Xa mchcua yu 'in hua quichen Asón, yten hua ni' yca na'an lo'o yu, lo' mdiyaa hua quichen Mitilene. ");
INSERT INTO cya_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Xca tsaan can' mdiyaa hua nde loo la quichen Quío, ticui' cuaña'an xca tsaan can' mdo'o hua nguiaa hua, lo' mdyi'o ti'in hua se'en lca Samos. Xca tsaan can' mdijin hua quichen Trogilio, lo' mdyi'o ti'in hua quichen Mileto. ");
INSERT INTO cya_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Si'yana a ncua ti' yu Pablo tiya' ton yu se'en lyi'ya loo Asia, mdijin ti hua quichen Efeso, cha' ti' bla qui'ni ca'an 'in yu ta'a Pentecostés quichen Jerusalén. ");
INSERT INTO cya_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Quichen Mileto ndi'in hua xa msu'hua yu Pablo suun 'in jun ta'a na Efeso, si'yana caan nchgaa yu nu ntsu'hui cunta 'in jun se'en ndi'in hua. ");
INSERT INTO cya_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Xa mdiyaan jun xacan' juin yu Pablo: 'Un cua' ndyu'hui lyoo um ña'an cha' 'ñan ti' tsaan nu mdiyaan se'en lyi'ya loo Asia, ");
INSERT INTO cya_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","si'yana lo'o suun ña'an m'nin tñan 'in Ñi X'nan na, ngu'ya tu'hua tiqueen lo'o um, a cunta ne' judio ncua ti' ne' cujui ne' 'ñan, ");
INSERT INTO cya_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","a ngula' tin' ycuin' cha' nu cu'ni tsu'hue lo'o um, ngulo'on 'in um se'en ndiyo' ti'in um, a cunta mda'an la na'an 'in um cunda scaa um. ");
INSERT INTO cya_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Scaña'an ti ycuin' lo'o ne' judio lo'o ne' gentil, si'yana tyaa ti' ne' 'in Ndiose lo' tsa qui'an ti' ne' 'in Ñi X'nan na Jesucristo. ");
INSERT INTO cya_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Cua' ñii ñan ti' cusya 'ñan tsa'an quichen Jerusalén, ñi a jlyo tin' ñi na tsato'o 'ñan la cua. ");
INSERT INTO cya_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Una ntsa' la Espíritu nu Luhui 'in Ndiose 'ñan nchgaa se'en ndijin, si'yana ntsu'hui cha' tsa'an na'an chcuan, lo' tijin scasca nu ti'i. ");
INSERT INTO cya_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Una a sca cha' can' cu'nin cunta, ñi a ngui'nin 'tnan chendyu 'ñan, scati cha' nu nchca tin' si'yana lo'o nu chcui lca tiqueen cu'nin tyiin tñan nu mdaa Ñi X'nan na Jesús 'ñan, lo' chcuin' cha' tsu'hue 'in Ndiose tsaña'an ngui'ni ñi 'tnan 'in ne'. ");
INSERT INTO cya_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Una cua' ñii quitsan' 'in um sca cha', si'yana ñi xca um lo' a ña'an ta'a 'a na lo'o um, 'un ne' nu cua' ycuin' cha' tsu'hue 'in Ndiose lo'o. ");
INSERT INTO cya_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Can' cha' chcuin' lo'o um, si'i 'a cunta 'ñan cha' nde'en um quinan' cusya 'in um, ");
INSERT INTO cya_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","si'yana a msu'huan cutsin' ñi sca cha' lo'o um nchgaa ña'an nguiaa cha' 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Xñi um cunta 'in um tsatlyu lo'o jun ta'a na nu cua' mxnu Espíritu nu Luhui 'in Ndiose cunta 'in um, lo' cuaña'an chu'hui um cunta 'in jun nu cua' msi'i Ñi X'nan na lo'o tne ñi. ");
INSERT INTO cya_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Jlyo tin' si'yana xa to'on re ntsu'hui cha' sten nu cuñilyi'o 'in um lo' cu'ni ti'i lo'o um, tsaña'an nchca ti' nguiten yu'hui sca 'ni la lja slya'. ");
INSERT INTO cya_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ticui' lja um re tyi'o nu chcui' cha' cuiñi se'en nu culo tso' 'in jun ta'a na. ");
INSERT INTO cya_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Can' cha' tyi'in tiyaa um, lo' quia yu'hui ti' um ña'an ngu'ya tu'hua tiqueen si'ya um, a ngula' tin' ngulo'on 'in um cunda scaa um tsani' snan yjan, tla lo' cucha. ");
INSERT INTO cya_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Can' cha' cua' ñii, 'un jun ta'a na, xnun cunta 'in um yaa' Ndiose lo' tyon um loo cha' tsu'hue 'in ñi, si'yana cui' na tca ta yaa' na 'in um, lo' taa na cha' tsu'hue nu qui'ni ca'an 'in um, tsatlyu lo'o nchgaa la ña'an nu cua' ngulohui Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ñi siya', a mducua tloon tñi 'in um uta ste' um. ");
INSERT INTO cya_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Cui' ca nu jlyo ti' um, si'yana m'nin tñan, jui na nu ngunajo'o 'ñan lo'o nchgaa la ña'an yu ta'a mda'an. ");
INSERT INTO cya_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Cua' jlyo ti' um ña'an ngulo'on 'in um, la nu cu'ni na tñan tca ta yaa' na 'in nu 'ni cha' 'in, lo' quia yu'hui ti' na cha' nu ycui' Ñi X'nan na Jesús: Tsu'hue lati nu taa um, lo' si'i nu nde caja nu taa 'in um. ");
INSERT INTO cya_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ña'aan mdyi ycui' yu Pablo cha' can', mdon xtyin' yu lo' ycui' lyi'o yu 'in Ndiose lo'o nchgaa la ña'an jun can'. ");
INSERT INTO cya_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nchgaa jun ngu'ya tu'hua tiquee jun, lo' msu'hua tuscun jun 'in yu Pablo si'yana cua' quiaa yu. ");
INSERT INTO cya_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Cha' nu ti'i lati nga'an 'in jun, si'ya cha' nu ycui' yu si'yana a ña'an ta'a 'a yu lo'o jun. Xacan' ya lo'o ta jun 'in yu la se'en nducui yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Xa msla' ta'a hua lo'o jun, xacan' yten hua ni' yca na'an can', lo' nguiaa hua nducua ñi se'en lca quichen Cos, xca tsaan can' mdiyaa hua se'en lca Rodas, la xacan' mdiyaa hua quichen Pátara. ");
INSERT INTO cya_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Can' yten hua ni' xca yca na'an nu ntsu'hui cha' tiyaa se'en lyi'ya loo Finicia, mdo'o hua nguiaa hua. ");
INSERT INTO cya_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mdijin hua se'en su yuu ngutyi se'en lca Chipre, lo' mxnu hua 'in na tso' ca 'in hua, tsaya' mdiyaa hua se'en lyi'ya loo Siria, xacan' mdyi'o ti'in hua quichen Tiro si'yana tyi'o yu'hua ntsu'hui ni' yca na'an can'. ");
INSERT INTO cya_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Na'an ta'a hua lo'o jun ndi'in can', lo' nguinu hua lo'o jun sca snan, lyee 'a mjñan jun cha' tsu'hue 'in yu Pablo si'yana a tsaa yu Jerusalén, tsaña'an mxiycui' Espíritu 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Xa yatii snan can', mdo'o hua nde tu'hua quichen lo'o nchgaa jun tsatlyu lo'o nten 'in jun lo'o sñe' jun, ya lo'o ta jun 'in hua la loo ysin tu'hua tyi'a tujo'o, can' mdon xtyin' hua lo' ycui' lyi'o hua 'in Ndiose. ");
INSERT INTO cya_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Msu'hua tuscun ta'a hua lo' msla' ta'a hua lo'o jun, xacan' yten hua ni' yca na'an can', lo' mxitucui jun nde ña'an 'in jun. ");
INSERT INTO cya_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Mdo'o hua quichen Tiro lo' mdiyaa hua se'en lca quichen Tolemaida, can' yatii cha' nu mda'an hua ni' yca na'an. Ya ycui' cha' hua 'in jun ta'a na, lo' can' nguinu hua sca tla. ");
INSERT INTO cya_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Xca tsaan can' mdo'o hua lo'o yu Pablo, nguiaa hua nchgaa hua, lo' mdiyaa hua quichen Cesarea. Yaa hua se'en nducua na'an 'in yu Lpe, yu nu ndyi'an ycui' cha' tsu'hue 'in Ndiose, cui' yu nu yu'hui lja tsa cati yu nu mda yaa' 'in jun ti' culoo, can' nguinu hua lo'o yu. ");
INSERT INTO cya_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yu Lpe can' ndi'in jacua ngüi' cuna'an sñe' yu nu nxiycui' Ndiose 'in. ");
INSERT INTO cya_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Can' mdi'in hua tucua snan tsaan xa mdiyaa sca yu naan Agabo nu mdo'o se'en lca Judea, lo'o yu can' nxiycui' Ndiose 'in yu. ");
INSERT INTO cya_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Mdiyaa yu 