﻿USE sofia;
DROP TABLE IF EXISTS sofia.cwe_vpl;
CREATE TABLE cwe_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cwe_vpl WRITE;
INSERT INTO cwe_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Baho mwanduso, Mulungu kalumba ulanga na isi yose na chila chinhu chili umo, ");
INSERT INTO cwe_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","nayo isi ikala yabule umbo hebu yabule chinhu chochose. Na ziza dikala digubika mchanyha ya mazi, Muhe wa Mulungu kakala katanda uchany'ha ya mazi. ");
INSERT INTO cwe_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Maabaho Mulungu kalonga, “Dilawilile bung'hulo” na bung'hulo dilawilila. ");
INSERT INTO cwe_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mulungu kawona kuwa bung'hulo dinoga, na kavigola bung'hulo na ziza. ");
INSERT INTO cwe_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Bung'hulo kaditanga “Misi” na ziza kaditanga “Chilo.” Iwa imitondo iwa ichigulogulo siku ya mwanduso. ");
INSERT INTO cwe_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Maabaho Mulungu kalonga, “Hanhu hagati ya mazi hayagole yamazi banzi mbili.” ");
INSERT INTO cwe_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ivo Mulungu kausa hanhu na kayagola yamazi yeli mchanyha na yaja yeli hasi. Ilawilila ivo. ");
INSERT INTO cwe_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mulungu kahatanga hanhu baho “Langa.” Iwa imitondo iwa ichigulogulo, siku yekaidi. ");
INSERT INTO cwe_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Maabaho Mulungu kalonga, “Mazi yeli hasi ya ulanga yaiduganye hanhu hamwe, idahe kulawilila hanhu hanyalile.” Ilawilila ivo. ");
INSERT INTO cwe_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mulungu kahatanga hanhu hanyalile “Isi” na hanhu hayaiduganye yamazi hamwe kahatanga “Bahali.” Mulungu kawona kuwa vinoga. ");
INSERT INTO cwe_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Maabaho Mulungu kalonga, “Isi yoteze chila modeli ya mimeya yoikwima mbeyu zake na chila modeli ya mibiki yoikwima matunda yeli na mbeyu zozigendelela koteza mimeya imwenga ya modeli yake.” Ilawilila ivo. ");
INSERT INTO cwe_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ivo isi yoteza chila modeli ya mimeya yoikwima mbeyu na chila modeli ya mibiki yoikwima matunda yeli na mbeyu. Mulungu kawona kuwa vinoga. ");
INSERT INTO cwe_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Iwa imitondo iwa ichigulogulo, siku yetatu. ");
INSERT INTO cwe_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Maabaho Mulungu kalonga, “Mabung'hulo yalawilile kuulanga, yagole imisi na ichilo, yalaguse lusita lwa dugila na siku na miyaka, ");
INSERT INTO cwe_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","yamwemwese kuulanga muladi isi iwe na bung'hulo.” Ilawilila ivo. ");
INSERT INTO cwe_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Maabaho Mulungu katenda mabung'hulo maidi makulu, zua dimwemwese imisi na mwezi umwemwese ichilo, iviya kausa nhondo. ");
INSERT INTO cwe_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mulungu keka mabung'hulo yayo kuulanga muladi yamwemwese isi. ");
INSERT INTO cwe_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Yatawale imisi na ichilo na kuvigola bung'hulo na ziza. Na Mulungu kawona kuwa vinoga. ");
INSERT INTO cwe_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Iwa imitondo iwa ichigulogulo siku yekane. ");
INSERT INTO cwe_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Maabaho Mulungu kalonga, “Mazi yamemezwe vilumbe vili na ugima na langa dimemezwe ndege woguluka.” ");
INSERT INTO cwe_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Mulungu kalumba wanyama wakulu ng'hani mwiibahali na chila modeli mbasakanyo ya vilumbe vili na ugima vovigenda mwiibahali, na chila modeli ya ndege. Mulungu kawona kuwa vinoga. ");
INSERT INTO cwe_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kavitemela mate na kavilongela vilumbe va muna yamazi, “Yongezekeni na yelekeni na muimemeze bahali,” na kawalongela ndege wongezeke muiisi. ");
INSERT INTO cwe_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Iwa imitondo iwa ichigulogulo, siku yetano. ");
INSERT INTO cwe_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Maabaho Mulungu kalonga, “Leka isi ilave chila modeli mbasakanyo ya vilumbe vili na ugima, wanyama wowofugigwa na wang'onyo wotambala na wanyama wa kumbago,” ilawilila ivo. ");
INSERT INTO cwe_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Mulungu kausa chila modeli mbasakanyo ya wanyama wa kumbago na chila modeli ya wanyama wowofugigwa na chila modeli ya wang'onyo wotambala. Mulungu kawona vinoga. ");
INSERT INTO cwe_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Maabaho Mulungu kalonga, “Lelo chimulumbe munhu yalingile fana cheye. Yatawale somba wa mwiibahali na ndege woguluka na wanyama wowofugigwa na isi yose na wang'onyo wose wowotambala.” ");
INSERT INTO cwe_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ivo Mulungu kalumba munhu, yalingile fana yeye mwenyewo. Kawalumba mulume na muke. ");
INSERT INTO cwe_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kawatemela mate na kalonga, “Yelekeni wana wengi, welesi wenu ukale na kuimemeza isi yose na kuitawala. Muwatawale somba weli mwiibahali, ndege woguluka na chila chiumbe chili na ugima chochigenda mwiisi.” ");
INSERT INTO cwe_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Maabaho Mulungu kalonga, “Lola, nomwing'hani chila modeli ya mimeya ili na mbeyu na chila modeli ya mibiki yoikwima matunda yeli na mbeyu muje. ");
INSERT INTO cwe_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na wanyama wose na ndege wose woguluka na wang'onyo wose wotambala mwiisi na viumbe weli na ugima, ndiya yawo izakuwa mayani ya mimeya.” Ilawilila ivo. ");
INSERT INTO cwe_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mulungu kalola chila chinhu chiyatendile, kawona kweli vinoga ng'hani. Iwa imitondo iwa ichigulogulo, siku yesita. ");
INSERT INTO cwe_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ivo isi na ulanga na vose vili umo vikomelezeka. ");
INSERT INTO cwe_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Muna isiku yesaba Mulungu kakomeleza sang'hano yake yose, na siku iyo yesaba Mulungu kahumula. ");
INSERT INTO cwe_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mulungu kaitemela mate siku yesaba na kaitenda iwe kwa ichimu chake, kwaviya siku iyo Mulungu kakomeleza sang'hano yake yose ya ulumbaji na kahumula. ");
INSERT INTO cwe_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Vino niivo Mndewa Mulungu viyalumbile ulanga na isi yose. Lusita ulo Mndewa Mulungu viyalumbile ulanga na isi, ");
INSERT INTO cwe_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hakukalile na masavu bule muna iisi na mimeya haisukile kwaviya Mndewa Mulungu haitonyele mvula iisi na iviya kwabule munhu wa kulima. ");
INSERT INTO cwe_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Nzasa ilawa hasi ya ulongo na itapagiza isi yose. ");
INSERT INTO cwe_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Maabaho Mndewa Mulungu kasola ulongo wa isi na kamuusa mulume, kamuhuvila mhumuzi ya ugima muimhula, na mulume iyo kawa mgima. ");
INSERT INTO cwe_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Maabaho Mndewa Mulungu kahanda mgunda hatangigwe Edeni, ubanzi wa ulawilo wa zuwa, umo kamwika mulume iyo yoyamuusile. ");
INSERT INTO cwe_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mndewa Mulungu koteza mibiki kulawa muna iisi, chila modeli ya mibiki yoinogeza na yoikwima matunda yofaya kwa ndiya. Hana uludonho lwa mgunda uwo kukala na mbiki woulava ugima na mbiki wa kuwatendeza wanhu wayamanye yanogile na yehile. ");
INSERT INTO cwe_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Lwanda lokuluma kulawa muna mgunda wa Edeni na mazi yakulumila muna ichizi, kulawa uko wiigola nyanda nne. ");
INSERT INTO cwe_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Zina da lwanda lwa mwanduso ni Pishoni, ulo loizunguluka isi ya Havila ili na zahabu. ");
INSERT INTO cwe_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Zahabu ya isi iyo inoga. Uko iviya kuna mvumbavumba wounung'hila goya wotangigwa bedola na mabwe ya bei ng'hulu yotangigwa oneki. ");
INSERT INTO cwe_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Zina da lwanda lwekaidi ni Gihoni, ulo loizunguluka isi yose ya Kushi. ");
INSERT INTO cwe_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Zina da lwanda lweketatu ni Tigili, ulo lokulumila banzi ya ulawilo wa zua wa isi ya Ashulu. Zina da lwanda lwekane ni Efulati. ");
INSERT INTO cwe_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Maabaho Mndewa Mulungu kamsola mulume iyo na kamwika muna mgunda wa Edeni yachilime na yachilolese. ");
INSERT INTO cwe_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mndewa Mulungu kamulongela, “Kodaha kuja matunda ya mbiki wowose muna umgunda, ");
INSERT INTO cwe_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mbali sekeuje matunda ya mbiki wa kuyamanya yanogile na yehile, mana siku dondauje matunda ya mbiki uwo, kweli kwizadanganika.” ");
INSERT INTO cwe_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Maabaho Mndewa Mulungu kalonga, “Havinogile bule munhu kukala yaidumwe. Nizamuusila mtazi yomfaya.” ");
INSERT INTO cwe_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ivo Mndewa Mulungu kasola ulongo wa isi na kausa chila modeli ya mnyama na ndege woguluka. Maabaho kamgalila mulume iyo muladi yaweng'he mazina, nayo kaweng'ha chila chiumbe yeli na ugima zina jake. ");
INSERT INTO cwe_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ivo mulume iyo kaweng'ha mazina wanyama wofugigwa na ndege woguluka na wanyama wa kumbago, mbali habule hata imwe yoyofaya kumtaza. ");
INSERT INTO cwe_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Maabaho Mndewa Mulungu kamgalila mulume iyo vuwevuwe da nhongo na viyakalile muna zinhongo, kasola lubavu lwake lumwe na kahagubika hanhu baho kwa nyama. ");
INSERT INTO cwe_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mndewa Mulungu kamulava muke muna ulubavu lolusoligwe kulawa kwa mulume iyo, na kamgala kwa mulume iyo. ");
INSERT INTO cwe_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Maabaho mulume kalonga, “Dino niijo divuha da mivuha yangu, nyama ya nyama zangu, kezatangigwa muke kwaviya kalavigwa mwa mulume.” ");
INSERT INTO cwe_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Lekamana mulume kowaleka tati yake na mami yake na koilumba na muke wake, nawo wokuwa lukuli lumwe. ");
INSERT INTO cwe_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mulume na muke wose waidi wakala ukengele, mbali hawawonile chinyala bule. ");
INSERT INTO cwe_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Lelo zoka dikala vwizi kufosa wanyama wose wa kumbago wowalumbigwe na Mndewa Mulungu. Zoka dimuuza imuke, “Vino Mulungu kawalongela kuwa sekemuje tunda da mbiki wowose muna umgunda?” ");
INSERT INTO cwe_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Muke ija kamwidika, “Chodaha kuja tunda da mbiki wowose muna umgunda, ");
INSERT INTO cwe_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mbali Mulungu kachilongela sekechije matunda ya mbiki uli haludonho hebu kuudalisa. One chahatenda ivo chizadanganika.” ");
INSERT INTO cwe_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Zoka dimwidika muke iyo, “Siyo kweli, hamwizadanganika.” ");
INSERT INTO cwe_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mana Mulungu kavimanya kuwa muhaja matunda yayo meso yenu yezagubuligwa na mwizakuwa fana yeye na mwizamanya yanogile na yehile. ");
INSERT INTO cwe_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kawona uja mbiki wounogeza ng'hani na matunda yake yodaha kudika, na kagesa unoga ng'hani uhadahile kuwa na ubala, ivo kaha tunda na kaja. Maabaho kamwing'ha mulumake, nayo iviya kaja. ");
INSERT INTO cwe_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Bahobaho viwakomeleze kuja, meso yawo yagubuligwa na wavimanya kuwa waukengele, ivo wasola mayani wayawala. ");
INSERT INTO cwe_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ichigulogulo mbeho viziholile, mulume na muke wake wamuhulika Mndewa Mulungu kogenda muna umgunda, ivo waifisa hagati ya mibiki muladi sekeyawawone. ");
INSERT INTO cwe_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mbali Mndewa Mulungu kamtanga mulume na kamuuza, “Kwa kulihi?” ");
INSERT INTO cwe_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nayo kamwidika, “Nikuhulika muna umgunda, nidumba kwaviya naukengele. Ivo niifisa.” ");
INSERT INTO cwe_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mndewa Mulungu kamuuza, “Yelihi yoyakulongele weye kwa ukengele? Vino weye kuja tunda da mbiki unikulongele sekeuje?” ");
INSERT INTO cwe_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mulume kamwidika, “Mwanamke youmwikile hano na niye, youning'hile, iyo yaning'hile tunda da mbiki uwo. Na niye nidija.” ");
INSERT INTO cwe_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mndewa Mulungu kamuuza mwanamke, “Weye kutenda choni?” Mwanamke kamwidika, “Zoka dinivwizila, na niye nija ditunda.” ");
INSERT INTO cwe_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mndewa Mulungu kadilongela dizoka, “Kwaviya kuyatenda yano, weye kuduwiligwa kufosa wanyama wose. Kwizatambala na kwizakuja timbwisi siku zose za ugima wako. ");
INSERT INTO cwe_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nizatenda weye wiihile na muke ija, ulelo wake wiihile na ulelo wako. Yeye kezakuhonda ditwi jako, Na weye kwizamuluma chisiginho chake.” ");
INSERT INTO cwe_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Na kamulongela mwanamke, “Nizakongezela usungu vondauwe na wimo na usungu vondawiibasule. Kwizakuwa na hamu ya kumtawala mulumako, nayo kezakutawala.” ");
INSERT INTO cwe_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Na kamulongela imulume, “Kumtegeleza muke wako na kuja tunda dinikulongele sekeuje. Kwa chiya chiutendile, isi iduwiligwa. Kwizatenda sang'hano ndala siku zose za ugima wako muladi kupata ndiya ifaya. ");
INSERT INTO cwe_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Isi izakwima miwa na mbigili, na weye kwizakuja mimeya ya isi. ");
INSERT INTO cwe_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kwizatenda sang'hano ndala za kulava vuke kuitenda isi ilave ndiya, mbaka vondaubwele muna ulongo moulawile. Weye ni ulongo, na kwizabwela kuwa ulongo kaidi.” ");
INSERT INTO cwe_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mulume kamtanga muke wake Hawa, kwaviya niiyo mama wa wanhu wose weli na ugima. ");
INSERT INTO cwe_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mndewa Mulungu kawatendela viwalo va mbende za wanyama Adamu na muke wake, na kawayawaza. ");
INSERT INTO cwe_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Maabaho Mndewa Mulungu kalonga, “Lelo munhu iyo kawa fana imwe wetu, kayamanya yanogile na yehile. Mbali yolondeka kumgomesa kuja diya ditunda da mbiki wa ugima, mana yahadija kezakala siku zose.” ");
INSERT INTO cwe_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ivo Mndewa Mulungu kamuwinga Adamu muna umgunda wa Edeni na kamtendeza yalime muna ulongo uyalawile. ");
INSERT INTO cwe_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kamuwinga Adamu, na keka wasenga wakalizi wa kuulanga ubanzi wa ulawilo wa zuwa wa mgunda wa Edeni, wakala na panga da moto dodikalile dohinduka kuno na kuno muladi waukalize umbiki wa ugima. ");
INSERT INTO cwe_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu kambandama Hawa muke wake, na kapata wimo. Kamweleka mwana wa chilume yatangigwe Kaini, nayo kalonga, “Kwa kutazigwa na Mndewa Mulungu nipata mwana wa chilume.” ");
INSERT INTO cwe_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hamwande kamweleka mwana imwenga zina jake Abeli. Abeli kakala mdimi wa ng'hondolo na Kaini kakala mulimi wa isi. ");
INSERT INTO cwe_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Maabaho Kaini kagala mavuno yake yamwenga na kayalava kuwa nhosa kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeli nayo kagala nyama inogile na mavuta ya ng'hondolo wake wa mwanduso kwelekigwa kuwa nhosa. Mndewa Mulungu kanogelwa na Abeli na nhosa yake. ");
INSERT INTO cwe_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mbali Kaini hatogoligwe na Mndewa Mulungu na nhosa yake, ivo Kaini kengilwa na ludoko ng'hani, na kakwesa ng'hombali. ");
INSERT INTO cwe_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Maabaho Mndewa Mulungu kamuuza Kaini, “Habali kuna ludoko fana ivo? Habali kukwesa ng'hombali? ");
INSERT INTO cwe_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Vino uhatenda yanogile hutogoligwa bule? One uhatenda yehile, uhasanyi wokusepasepa muna ulwivi lwako, wokulonda kukutawala mbali kolondeka uuhume.” ");
INSERT INTO cwe_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Maabaho Kaini kamulongela mdodo wake Abeli, “Chihite kumgunda.” Viwakalile kumgunda, Kaini kamzumhila mdodo wake na kamkoma. ");
INSERT INTO cwe_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Maabaho Mndewa Mulungu kamuuza Kaini, “Kakulihi mdodo wako Abeli?” Kamwidika, “Niye sivimanyile bule. Vino niye ndolezi wa mdodo wangu?” ");
INSERT INTO cwe_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Maabaho Mndewa Mulungu kauza, “Kutenda choni? Damu ya mdodo wako ilinga fana dizi donililila kulawa muna uulongo. ");
INSERT INTO cwe_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kwaviya kumkoma mdodo wako na damu yake itika muna isi, weye koduwiligwa kulawa iisi youkala. ");
INSERT INTO cwe_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","One uhageza kulima ndiya, ulongo hawizakupatila chinhu chochose. Kwizawegela na kwizakuwa kwabule ukazi muna iisi.” ");
INSERT INTO cwe_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini kamulongela Mndewa Mulungu, “Nhaguso yangu iwa ndala na ibasanya siidaha hata kuipapa. ");
INSERT INTO cwe_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lola diyelo kuniwinga muna iisi inogile na kunisegeza haulongozi hako. Nizakuwa nabule ukazi na nowegela muna iisi yose, na munhu yoyose yondayaniwone kezanikoma.” ");
INSERT INTO cwe_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mbali Mndewa Mulungu kamwidika, “Aka. Munhu yoyose yondayamkome Kaini, kezalihilizigwa miyanza saba.” Maabaho Mndewa Mulungu kamwika nhale kumzuma yoyose yondayaiting'hane nayo, sekeyamkome. ");
INSERT INTO cwe_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaini kahasegela ha Mndewa Mulungu na kakala isi itangigwa “Nodi”, niiyo ili ubanzi wa ulawilo wa zua wa Edeni. ");
INSERT INTO cwe_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini kambandama muke wake, nayo kapata wimo na kamweleka Henoko. Maabaho Kaini kazenga bululu na kaditanga Henoko, zina da mwanage. ");
INSERT INTO cwe_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henoko kapata mwana na kamtanga zina jake Iladi; Iladi nayo kamweleka Mehuyaeli; Mehuyaeli kamweleka Mesusayeli, Mesusayeli kamweleka Lameki. ");
INSERT INTO cwe_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki kakala na wake waidi, imwe katangigwa Ada na imwenga katangigwa Zila. ");
INSERT INTO cwe_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada kamweleka Yabali, yakalile tata wa wafugaji wokala muna yamahema. ");
INSERT INTO cwe_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ndugu yake kakala Yubali, iyo kakala tata wa wose wavina wila na wotowa vimbeta na vingodongodo. ");
INSERT INTO cwe_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila nayo kamweleka Tubalikaini, yoyakalile muhunzi wa via vose va shaba na mazuma. Lumbu wa Tubalikaini katangigwa Nama. ");
INSERT INTO cwe_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki kawalongela wake zake, “Ada na Zila nitegelezeni, Mweye wake wa Lameki tegelezeni yonimulongelani Niye nimkoma munhu kwaviya kaning'ha banha Nimkoma imbwanga kwaviya kanilumiza. ");
INSERT INTO cwe_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ihawa Kaini kolihigwa miyanza saba, Lameki kezalihigwa miyanza malongo saba na saba.” ");
INSERT INTO cwe_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu kambandama kaidi muke wake, nayo keleka mwana wa chilume. Kalonga, “Mulungu kaning'ha mwana wa chilume badala ya Abeli, yoyakomigwe na Kaini.” Ivo kamtanga Seti. ");
INSERT INTO cwe_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti nayo kapata mwana wa chilume, kamtanga Enosi. Baho wanhu wandusa kumtambikila Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Uno uwo ludongo lwa welesi wa Adamu. Kwandusila Mulungu viyamulumbile munhu, kamulumba fana yeye mwenyewo, ");
INSERT INTO cwe_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mulungu kawalumba mulume na muke, maabaho kawatemela mate na kaweng'ha zina “Munhu.” ");
INSERT INTO cwe_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu viyakalile na miyaka gana na malongo matatu, kapata mwana yoyalingile yeye, yeli na chihanga fana chake mwenyewo na kamtanga zina jake Seti. ");
INSERT INTO cwe_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Viyakomeleze kumweleka Seti, Adamu kakala miyaka magana manane na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu kadanganika na miyaka magana kenda na malongo matatu. ");
INSERT INTO cwe_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti viyakalile na miyaka gana na tano, kamweleka mwana zina jake Enosi. ");
INSERT INTO cwe_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seti viyamweleke Enosi, kakala miyaka magana manane na saba na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seti kadanganika na miyaka magana kenda na longo na midi. ");
INSERT INTO cwe_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi viyawile na miyaka malongo kenda, kamweleka mwana zina jake Kenani. ");
INSERT INTO cwe_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosi viyamalile kumweleka Kenani, kakala miyaka magana manane na longo na tano na kaweleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosi kadanganika na miyaka magana kenda na mitano. ");
INSERT INTO cwe_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani viyakalile na miyaka malongo saba, kamweleka mwana zina jake Mahalaleli, ");
INSERT INTO cwe_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","maabaho viyamalile kumweleka Mahalaleli kakala na miyaka magana manane na malongo mane na kaweleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenani kadanganika na miyaka magana kenda na longo. ");
INSERT INTO cwe_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli viyakalile na miyaka malongo sita na tano, kamweleka mwana zina jake Yaledi. ");
INSERT INTO cwe_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalaleli viyamweleke Yaledi, kakala na miyaka magana manane na malongo matatu, kaweleka wana wamwenga wa chilume na chike, ");
INSERT INTO cwe_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli kadanganika na miyaka magana manane na malongo kenda na tano. ");
INSERT INTO cwe_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaledi viyakalile na miyaka gana na malongo sita na midi, kamweleka mwana zina jake Henoko. ");
INSERT INTO cwe_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Maabaho Yaledi viyamalile kumweleka Henoko kakala na miyaka magana manane. Kaweleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Na kadanganika na miyaka magana kenda na malongo sita na midi. ");
INSERT INTO cwe_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henoko viyakalile na miyaka malongo sita na mitano, kamweleka mwana zina jake Mesusela. ");
INSERT INTO cwe_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henoko viyamweleke Mesusela kakala kwa kumnogeza Mulungu kwa miyaka magana matatu na kaweleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henoko kakala miyaka magana matatu na malongo sita na mitano. ");
INSERT INTO cwe_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henoko kakala kwa kumnogeza Mulungu maabaho kasegela, kwaviya Mulungu kamsola. ");
INSERT INTO cwe_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mesusela viyakalile na miyaka gana na malongo manane na saba, kamweleka mwana zina jake Lameki. ");
INSERT INTO cwe_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Maabaho viyamalile kumweleka Lameki, Mesusela kakala na miyaka magana saba na malongo manane na midi, kaweleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mesusela kadanganika na miyaka magana kenda na malongo sita na kenda. ");
INSERT INTO cwe_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki viyakalile na miyaka gana na malongo manane na midi, kamweleka mwana wa chilume. ");
INSERT INTO cwe_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lameki kamtanga mwana iyo zina jake Nuhu, na kalonga, “Mwana ino niyo yondayachigele moyo kwa kulawa muna isang'hano yetu ndala, yochiitenda kwa makono yetu muna iisi yoyaiduwile Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lameki viyamalile kumweleka Nuhu, kakala na miyaka magana matano na malongo kenda na mitano na kaweleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki kadanganika na miyaka magana saba na malongo saba na saba. ");
INSERT INTO cwe_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu viyawile na miyaka magana matano, kaweleka wana watatu, Shemu na Hamu na Yafesi. ");
INSERT INTO cwe_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wanhu viwanduse kongezeka muna iisi yose, na wana wa chike welekigwa kumwawo, ");
INSERT INTO cwe_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","wasenga wa Mulungu wawawona wandele wa wanhu kuwa lumondo, na wawasola kuwa wake zawo fana viwalondile. ");
INSERT INTO cwe_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Maabaho Mndewa Mulungu kalonga, “Muhe wangu hawizakala kwa wanhu siku zose, kwaviya wawo ni lukuli. Kwandusila sambi na kugendelela, hawezakala miyaka kufosa miyaka gana na malongo maidi.” ");
INSERT INTO cwe_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Lusita ulo na kugendelela, kukala na Wanefili mwiisi, wawo wakala welesi wa wana wa Mulungu na wandele wa wanhu. Wawo niiyo wanhu wakalile magalu, wamanyike ng'hani baho umwaka. ");
INSERT INTO cwe_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mndewa Mulungu kawona wihi mkulu wa wanhu muna iisi na magesa yawo yehile chila siku, ");
INSERT INTO cwe_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ivo Mndewa Mulungu kengilwa usungu ng'hani kwa kumulumba munhu na kumwika muna iisi, na kawona usungu ng'hani muna umoyo wake. ");
INSERT INTO cwe_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Mndewa Mulungu kalonga, “Nizamsegeza munhu yonimulumbile muna isi, na iviya nizawasegeza wang'onyo, waja wotambala na ndege wa kuulanga. Nojuta kwaviya niwalumba.” ");
INSERT INTO cwe_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mbali Mndewa Mulungu kanogelwa na Nuhu. ");
INSERT INTO cwe_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Zino ni mbuli za ugima wa Nuhu yoyakalile yotenda yanogile haulongozi wa Mulungu, mkamilifu muna uwelesi wake. Nuhu kakala kwa kumnogeza Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu kaweleka wana watatu wa chilume, wowatangigwe Shemu na Hamu na Yafesi. ");
INSERT INTO cwe_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Chila munhu kakala mwihi haulongozi wa Mulungu, na tibwilitibwili jenela chila hanhu. ");
INSERT INTO cwe_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mulungu kawona isi yose imema wihi, kwaviya wanhu watenda ihe. ");
INSERT INTO cwe_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mulungu kamulongela Nuhu, “Nilamula kuwadanganiza wanhu wose kwaviya waimemeza iisi tibwilitibwili. Kweli nizawadanganiza ng'hani hamwe na isi. ");
INSERT INTO cwe_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Zenga safina kwa mabanzi ya mibiki midala. Gola viheleto na uhake tulasi kunze na mgati. ");
INSERT INTO cwe_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Vino niivo vondauizenge, utali wake iwe makono magana matatu na ugalamu wake makono malongo matano na chimo chake makono malongo matatu. ");
INSERT INTO cwe_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Utende chisuwili na chiwe mkono umwe hagati wa digulu maabaho ika lwivi ubanzi umwe, safina iwe na golofa nhatu. ");
INSERT INTO cwe_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Na niye nizagala gombo muna iisi muladi kudanganiza chila chiumbe chili na ugima. Chila chinhu muna iisi chizadanganika. ");
INSERT INTO cwe_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mbali nizatenda lagano na weye. Kwizakwingila muna isafina na muke wako, wanago na wake zawo. ");
INSERT INTO cwe_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Wagale mwiisafina chila modeli ya viumbe vili na ugima vidi, va chilume na va chike, na uvilolese vikale. ");
INSERT INTO cwe_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Wingize chila ndege wa kuulanga, chila wang'onyo wotambala na chila wanyama, waidi waidi muladi wawe wagima. ");
INSERT INTO cwe_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Usole chila modeli ya ndiya wiike goya kwa ichimu chenu na kwa ichimu chawo.” ");
INSERT INTO cwe_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu kasang'hana chila chinhu fana viyalagilizigwe na Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Maabaho Mndewa Mulungu kamulongela Nuhu, “Ingila mwiisafina weye na wanago wose, kwaviya nikuwona weye muhala kunoga haulongozi wangu mwa iwanhu wa isi yose. ");
INSERT INTO cwe_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Iviya muna iwanyama wodigwa usole malume saba na mazike saba, mbali wanyama hawadigwa sola lume dimwe na zike dimwe. ");
INSERT INTO cwe_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Iviya sola ndege wa kuulanga malume saba na mazike saba, muladi uwakalize ugima wawo mwiisi. ");
INSERT INTO cwe_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Zihafosa siku saba kwandusila sambi nizagala mvula yondaitonye kwa siku malongo mane, imisi na ichilo, muladi kuvibanaga viumbe vigima vose vonivilumbile.” ");
INSERT INTO cwe_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu katenda chila chinhu choyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Gombo vidizile muna iisi, Nuhu kakala na miyaka magana sita. ");
INSERT INTO cwe_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu na muke wake na wanage wa chilume na wake zawo, wengila muna isafina muladi kugomboka na digombo. ");
INSERT INTO cwe_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Wose wanyama iwe wambule mwiko hebu hawambule mwiko na wang'onyo na ndege, ");
INSERT INTO cwe_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","wengila mwiisafina waidi waidi, muke na mulume hamwe na Nuhu, fana Nuhu viyalagilizigwe na Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Vizifosile siku saba gombo diza. ");
INSERT INTO cwe_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhu viyawile na miyaka magana sita, muna isiku ya longo na saba mwezi wekaidi, siku iyo nzasa zose hasi ng'hani ya isi zilava mazi ng'hani na mazonzo ya kuulanga yavuguka. ");
INSERT INTO cwe_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mvula itonya mwiisi siku malongo mane, imisi na ichilo. ");
INSERT INTO cwe_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Siku iyo iyo Nuhu na muke wake wengila muna isafina hamwe na wanawe watatu, Shemu na Hamu na Yafesi na wake zawo. ");
INSERT INTO cwe_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wahita hamwe na chila modeli ya wanyama wa kumbago na chila modeli ya wanyama wofugigwa na chila modeli ya wang'onyo wotambala na chila modeli ya ndege na chila chiumbe chili na mabawa. ");
INSERT INTO cwe_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Chila viumbe waidi waidi walume na wake, chila chilumbe chili na ugima chingila muna isafina hamwe na Nuhu, ");
INSERT INTO cwe_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","fana Mulungu viyamulagilize. Maabaho Mndewa Mulungu kahinda ulwivi hachisogo cha Nuhu. ");
INSERT INTO cwe_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Gombo digendelela kwa siku malongo mane, na yamazi yamema mbaka safina iyengeluka uchanyha ya mazi. ");
INSERT INTO cwe_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mazi yawa na china chitali na safina iyengeluka muna yamazi. ");
INSERT INTO cwe_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mazi yakala mengi ng'hani muna iisi, yaigubika milima mitali chila hanhu. ");
INSERT INTO cwe_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mazi yamema mbaka yaigubika milima utali wa makono longo na mitano. ");
INSERT INTO cwe_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Vilumbe vose vili na ugima muna iisi vidanganika, ndege wose na wanyama wose wofugigwa na wanyama wose wa kumbago na wang'onyo wose wotambala na wanhu wose. ");
INSERT INTO cwe_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Chila chilumbe chikala muna iisi inyalile chidanganika. ");
INSERT INTO cwe_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mndewa Mulungu kavinanga viumbe vose vigima mwiisi, wanhu na wanyama wang'onyo wotambala na ndege woguluka. Kasigala Nuhu muhala na waja wowakalile hamwe nayo muna isafina. ");
INSERT INTO cwe_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mazi yakala muna iisi siku gana na malongo matano. ");
INSERT INTO cwe_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mbali Mulungu kamkumbuka Nuhu na wanyama wose wa kumbago na wanyama wose wofugigwa wowakalile hamwe nayo muna isafina. Ivo Mulungu kahembelula beho muna iisi na mazi yandusa kuhunguka. ");
INSERT INTO cwe_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nzasa zose za mazi hasi ng'hani ya isi na mazonzo ya kuulanga vihindigwa, na mvula ileka kutonya. ");
INSERT INTO cwe_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mazi yagendelela kuhunguka ugalugagaluga muna iisi. Viifikile siku gana na malongo matano, mazi yahunguka ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Muna isiku ya longo na saba ya mwezi wa saba, safina ifika muna imilima ya Alalati na ikala baho. ");
INSERT INTO cwe_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mazi yagendelela kuhunguka ugalugagaluga, na siku ya mwanduso ya mwezi wa longo, vidonho va milima viwoneka. ");
INSERT INTO cwe_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Vizimalile siku malongo mane, Nuhu kavugula zonzo da isafina yoyaitendile, ");
INSERT INTO cwe_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na kamtuma howe kunze, na kaguluka kuno na kuja, mbaka mazi viyanyalile mwiisi. ");
INSERT INTO cwe_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Maabaho Nuhu kamtuma nziwa yawone one mazi yahunguka muna iisi. ");
INSERT INTO cwe_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mbali kwaviya mazi yakala yang'hali yaigubika isi yose, nziwa hapatile hanhu ha kwima bule. Kabwela kwa Nuhu kuna isafina, Nuhu kaugolosa mkono wake kamsola na kumbweleza muna isafina. ");
INSERT INTO cwe_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuhu kagozela siku zimwenga saba, maabaho kamtuma kaidi nziwa. ");
INSERT INTO cwe_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nziwa kabwela kwa Nuhu ichigulogulo kuno kana tambi bisi da mzaituni muna umulomo wake. Ivo Nuhu kavimanya kuwa mazi yakala yahunguka muna iisi. ");
INSERT INTO cwe_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Maabaho kagozela siku zimwenga saba, kamtuma kaidi nziwa, mwanza uno nziwa habwelile bule. ");
INSERT INTO cwe_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhu viyakalile na miyaka magana sita na umwe, siku ya mwanduso ya mwezi mosi, kawona mazi yakala yanyala muna iisi. Nuhu kagubula chigubiko cha safina, kalola na kuwona isi ikala inyala. ");
INSERT INTO cwe_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Siku ya malongo maidi na saba ya mwezi wekaidi, isi ikala inyala ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Maabaho Mulungu kamulongela Nuhu, ");
INSERT INTO cwe_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Lawa mwiisafina weye na muke wako na wanago na wake zawo. ");
INSERT INTO cwe_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Sola chila chiumbe chili na ugima chili na weye, ndege na wanyama wose na wang'onyo ulawe nawo kunze muladi weleke na kwenela muna iisi yose.” ");
INSERT INTO cwe_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nuhu kalawa kunze muna isafina hamwe na muke wake na wanage na wake zawo. ");
INSERT INTO cwe_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Wanyama wose na vilumbe weli na ugima viya vitambala muiisi na chila modeli wa ndege walawa muna isafina, kwa kusondelela modeli wawo. ");
INSERT INTO cwe_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuhu kamzengela Mndewa Mulungu lupango, kalava nhambiko wanyama wamwenga wodigwa na ndege wodigwa, kamtimbulila Mulungu mchanyha ya ulupango. ");
INSERT INTO cwe_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mnung'ho unogile wa nhosa iyo umnogeza Mndewa Mulungu, nayo kalonga muna umoyo wake, “Sizaiduwila kaidi isi kwa ichimu cha wanhu. Kwaviya magesa ya wanhu yeha kwandusila kuudodo wawo. Ivo sizainanga kaidi isi fana vinitendile. ");
INSERT INTO cwe_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Chipindi isi viikalile, msimu wa kuhanda na kugobola, lusita lwa chihuhe na vuke na masika na zua, chilo na misi, havizamala.” ");
INSERT INTO cwe_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mulungu kamtemela mate Nuhu na wanage na kawalongela, “Yelekeni na mongezeke na muimemeze isi yose. ");
INSERT INTO cwe_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Wanyama wose muna iisi na ndege woguluka na wang'onyo wotambala na somba wose muna ibahali wezawadumbani. Wawo wose mwizawatawala. ");
INSERT INTO cwe_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Chila chinhu chili na ugima na chitambala molondeka kuchija. Fana vinimwing'hileni mibiki isuka, sambi nomwing'hani chila chinhu. ");
INSERT INTO cwe_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mbali sekemuje nyama ili na damu, kwaviya ugima wake waumo muna idamu. ");
INSERT INTO cwe_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","One munhu yoyose hebu mnyama yahamkomani, nizamtagusa. Na one munhu yahamkoma miyage, kezatagusigwa. ");
INSERT INTO cwe_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Munhu yoyose yondayamkome miyage, iviya nayo kezakomigwa na munhu, Mana munhu kalumbigwa yalingile fana Mulungu mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Yelekeni na kwenela isi yose.” ");
INSERT INTO cwe_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Maabaho Mulungu kamulongela Nuhu na wanage, ");
INSERT INTO cwe_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Lelo nokwika lagano jangu na mweye na welesi wenu, ");
INSERT INTO cwe_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na vilumbe vili na ugima vose vili na weye, ndege na wanyama wofugigwa na chila mnyama wa kumbago yoyalawile muna isafina hamwe na weye. ");
INSERT INTO cwe_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nodikanhamiza lagano jangu na mweye, vilumbe vose vili na ugima havizanangigwa na gombo, hebu gombo hadizalawilila kaidi kuinanga isi.” ");
INSERT INTO cwe_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Mulungu kalonga, “Chino niicho chilaguso cha lagano dinikwika hagati ya niye na mweye na chila chilumbe chili na ugima chikala hamwe na mweye kwa welesi wose mbaka welesi ukwiza, ");
INSERT INTO cwe_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","nokwika pinde da Mulungu kuna yamawingu. Chizakuwa chilaguso cha lagano jangu na isi yose. ");
INSERT INTO cwe_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Chila nahayatanda mawingu muna uulanga na pinde da Mulungu dizalawilila muna yamawingu, ");
INSERT INTO cwe_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Nizadikumbuka lagano jangu na mweye na vilumbe vose vili na ugima. Mazi hayezagaluka kaidi kuwa gombo kuvinanga vilumbe vose vili na ugima. ");
INSERT INTO cwe_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Baho pinde da Mulungu vondadiwoneke kuna yamawingu, nizadiwona na kudikumbuka lagano jangu na vilumbe vili na ugima mwiisi.” ");
INSERT INTO cwe_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Mulungu kamulongela Nuhu, “Chino ni chilaguso cha lagano donitendile na vilumbe vose vili na ugima muna iisi.” ");
INSERT INTO cwe_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wanage Nuhu wowalawile muna isafina wakala Shemu na Hamu na Yafesi. Hamu kakala niiyo tata wa Kanani. ");
INSERT INTO cwe_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Kufosela wanhu wawo watatu wa Nuhu, wanhu wenela muiisi yose. ");
INSERT INTO cwe_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu kakala wa mwanduso kuhanda mgunda wa mizabibu. ");
INSERT INTO cwe_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kang'wa divai na kakoligwa, maabaho kagona ukulunge muna dihema jake. ");
INSERT INTO cwe_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu tata wa Kanani kauwona ukengele wa tati yake, kalawa kunze na kuwalongela ndugu zake waidi. ");
INSERT INTO cwe_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Maabaho Shemu na Yafesi wasola walo na waigeleka mmayega yawo na wahita chisengelenyuma na kuugubika ukengele wa tati yawo. Walola mumgwazo na hawauwonile bule ukengele wa tati yawo. ");
INSERT INTO cwe_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuhu upele viukunguzuke kavimanya viyatendiligwe na mwanage imdodo, ");
INSERT INTO cwe_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","kalonga, “Nayaduwiligwe Kanani. Kezakuwa mtumwa kwa ndugu zake.” ");
INSERT INTO cwe_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Iviya kalonga, “Yatunhizigwe Mndewa Mulungu, Mulungu wa Shemu. Kanani yawe mtumwa wa Shemu. ");
INSERT INTO cwe_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mulungu yamwing'he wana wengi Yafesi, yakale hamwe na Shemu na Kanani yawe mtumwa wake.” ");
INSERT INTO cwe_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Vidimalile gombo, Nuhu kakala miyaka magana matatu na malongo matano ");
INSERT INTO cwe_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuhu kadanganika na miyaka magana kenda na malongo matano. ");
INSERT INTO cwe_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Uno niuwo welesi wa wana wa Nuhu, Shemu na Hamu na Yafesi. Wano watatu weleka wana vidimalile digombo. ");
INSERT INTO cwe_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wana wa Yafesi wakala Gomeli na Magogu na Madayi na Yavani na Tubali na Mesheki na Tilasi. ");
INSERT INTO cwe_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wana wa Gomeli wakala Ashikenazi na Lifazi na Togoma. ");
INSERT INTO cwe_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wana wa Yavani wakala Elisha na Talishishi na Kitimu na Dodanimu. ");
INSERT INTO cwe_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kufosela wawo wanhu wa mhwani wapwililika muna izisi zawo hamwe na ulonzi wawo na ng'holo zawo na makabila yawo. ");
INSERT INTO cwe_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wana wa Hamu wakala Kushi na Misili na Puti na Kanani. ");
INSERT INTO cwe_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wana wa Kushi wakala Seba na Havila na Sabita na Lama na Sabuteka. Wana wa chilume wa Lama wakala Sheba na Dedani. ");
INSERT INTO cwe_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi kamweleka Nimulodi, yoyakalile galu wa mwanduso mwiisi yose. ");
INSERT INTO cwe_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kakala galu wa kusaka wanyama haulongozi ha Mndewa Mulungu, lekamana wanhu wolonga, “Uwe fana Nimulodi yakalile galu wa kusaka haulongozi ha Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Mwanduso wa ufalume wake ukala Babeli na Eleki na Akadi na Kalinehi muna iisi ya Shinali. ");
INSERT INTO cwe_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimulodi viyalawile uko, kahita Ashulu kazenga mabululu ya Ninawi na Lehobosi na Kala, ");
INSERT INTO cwe_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Leseni ili hagati ya Ninawi na Kala, bululu dikulu. ");
INSERT INTO cwe_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Welesi wa Misili ukala Waludima na Wanami na Walehabi na Wanafutuhima ");
INSERT INTO cwe_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","na Wapatilusi na Wakashuhi na Wakafitoli, Wafilisiti niiyo mwanduso wa Wakashuhi. ");
INSERT INTO cwe_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanani kakala tata wa Sidoni, mwanage chaudele, na imwenga katangigwa Hiti, ");
INSERT INTO cwe_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","na Kanani iviya ni tata wa Wayebusi na Waamoli na Wagiligashi, ");
INSERT INTO cwe_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","na Wahivi na Waaliki na Wasini, ");
INSERT INTO cwe_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","na Waavadi na Wazemali na Wahamati. Hamwande wanhu wa welesi wa Wakanaani waimwaga. ");
INSERT INTO cwe_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Hanhu ha Wakanaani handusila Sidoni kuhita Gelali mbaka kufika Gaza na nzila ya kuhita Sodoma na Gomola na Adima na Seboimu mbaka Lasha. ");
INSERT INTO cwe_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Uno niuwo welesi wa Hamu muna yamakabila yawo na ulonzi wawo na hanhu howokala na ng'holo zawo. ");
INSERT INTO cwe_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Nayo Shemu niiyo sekulu wa Yafesi, na kakala wasaho wa wana wose wa Ebeli. ");
INSERT INTO cwe_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wana wa Shemu wakala Elamu na Ashulu na Alifakisadi na Ludi na Alamu. ");
INSERT INTO cwe_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wana wa Alamu wakala Usi na Huli na Geteli na Mashi. ");
INSERT INTO cwe_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alifakisadi kamweleka Shela, na Shela kamweleka Ebeli. ");
INSERT INTO cwe_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeli keleka wana waidi wa chilume, zina da wa mwanduso ni Pelegi, kwaviya muna ulusita lwake isi iigola, na imwenga zina jake Yokitani. ");
INSERT INTO cwe_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitani kakala tata wa Alimodadi na Shelefu na Hasalimaweti na Yela, ");
INSERT INTO cwe_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","na Hadolamu na Uzali na Dikila, ");
INSERT INTO cwe_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","na Obeli na Abimayeli na Sheba ");
INSERT INTO cwe_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","na Ofili na Havila na Yobabu. Wawo wose wakala welesi wa Yokitani. ");
INSERT INTO cwe_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Isi yowakalile yenela kulawa Mesha mbaka Sifali kuna mulima wa isi ya ulawilo wa zua. ");
INSERT INTO cwe_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Uno niuwo welesi wa Shemu muna izisi zawo na ulonzi wawo na makabila yawo na ng'holo zawo. ");
INSERT INTO cwe_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Zino ni ng'holo za wana wa Nuhu, kusondelela ludongo lwa welesi wawo hamwe na zisi zawo. Wanhu wano wapwililika mwiizisi zose vidimalile digombo. ");
INSERT INTO cwe_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Umwaka wanhu wa zisi zose wakala na ulonzi umwe muhala na walonga mbuli zimwe muhala. ");
INSERT INTO cwe_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Wanhu viwagendile kulawa ulawilo wa zua, wafika bawe da Shinali, wakala. ");
INSERT INTO cwe_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wailongela, “Izoni! Chitende matafali chiyasome moto vinogile.” Wakala na matafali badala ya mabwe, na tulasi badala ya ulongo. ");
INSERT INTO cwe_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Maabaho walonga, “Lelo chiizengele bululu jetu na lingo dizafika mbaka kuulanga, muladi zina jetu dimanyike ng'hani na sekechiimwage muna iisi.” ");
INSERT INTO cwe_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mbali Mndewa Mulungu kahumuluka na kudiwona bululu na lingo dodikalile dizengigwa na wanhu. ");
INSERT INTO cwe_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Na Mndewa Mulungu kalonga, “Lola wanhu wano wose ni wamwe na wolonga ulonzi umwe, uno ni mwanduso wa sang'hano yawo. Lelo wezadaha kutenda chinhu chochose chiwoilungila. ");
INSERT INTO cwe_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Leka chihumuluke na kutibula ulonzi wawo muladi sekewaitegeleze.” ");
INSERT INTO cwe_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ivo Mndewa Mulungu kawapwililisa muna iisi yose, nawo waleka kuzenga dibululu. ");
INSERT INTO cwe_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Lekamana bululu ijo ditangigwa Babeli, kwaviya Mndewa Mulungu katibula ulonzi wa isi yose, na kulawa uko Mndewa Mulungu kawapwililisa wanhu mwiisi yose. ");
INSERT INTO cwe_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Uno uwo ludongo lwa welesi wa Shemu. Shemu viyakalile na miyaka gana kamweleka Alifakisadi, iyo ikala miyaka midi vidimalile digombo. ");
INSERT INTO cwe_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shemu viyamweleke Alifakisadi kakala miyaka magana matano, na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alifakisadi viyakalile na miyaka malongo matatu na mitano, kamweleka Shela. ");
INSERT INTO cwe_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Alifakisadi viyamweleke Shela, kakala miyaka magana mane na mitatu, na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela viyakalile na miyaka malongo matatu, kamweleka Ebeli. ");
INSERT INTO cwe_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shela viyamweleke Ebeli kakala miyaka magana mane na mitatu, na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebeli viyakalile na miyaka malongo matatu na mine kamweleka Pelegi. ");
INSERT INTO cwe_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ebeli viyamweleke Pelegi kakala miyaka magana mane na malongo matatu, na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi viyakalile na miyaka malongo matatu, kamweleka Lewu. ");
INSERT INTO cwe_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelegi viyamweleke Lewu kakala miyaka magana maidi na kenda, na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Lewu viyakalile na miyaka malongo matatu na midi kamweleka Selugi. ");
INSERT INTO cwe_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Lewu viyamweleke Selugi kakala miyaka magana maidi na saba, na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selugi viyakalile na miyaka malongo matatu, kamweleka Naholi. ");
INSERT INTO cwe_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Selugi viyamweleke Naholi kakala miyaka magana maidi, na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naholi viyakalile na miyaka malongo maidi na kenda kamweleka Tela. ");
INSERT INTO cwe_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naholi viyamweleke Tela kakala miyaka gana na longo na kenda, na keleka wana wamwenga wa chilume na wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela viyakalile na miyaka malongo saba kaweleka Abulamu na Naholi na Halani. ");
INSERT INTO cwe_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Uno niuwo welesi wa Tela. Tela kaweleka Abulamu na Naholi na Halani. Nayo Halani kamweleka Lutu. ");
INSERT INTO cwe_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Halani kadanganika Ulu kuna iisi ya Wakalidayo kuyavumbukile chipindi Tela tati yake yang'hali kokala uko. ");
INSERT INTO cwe_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abulamu na Naholi wasola wake. Muke wa Abulamu katangigwa Salayi na muke wa Naholi katangigwa Milika, mndele wa Halani. Halani iviya niiyo tati yawo Milika na Isika. ");
INSERT INTO cwe_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Mbali Salayi kakala kabule wana kwaviya kakala mgumba. ");
INSERT INTO cwe_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela kamsola Abulamu mwanage, na Lutu mzukulu wake yoyelekigwe mwanage Halani, na Salayi muke wake Abulamu, na wasegela wose hamwe kulawa Ulu, bululu da Wakalidayo, kuhita kuna iisi ya Kanaani. Viwafikile Halani wakala uko. ");
INSERT INTO cwe_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela viyakalile na miyaka magana maidi na mitano, kadanganika uko Halani. ");
INSERT INTO cwe_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mndewa Mulungu kamulongela Abulamu, “Segela muna iisi yako, leka ndugu zako na kaye ya tati yako na uhite kuna iisi yondanikulagusile. ");
INSERT INTO cwe_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nizakutenda uwe kabila kulu na nizakutemela mate na nizaditenda zina jako dimanyike ng'hani, na kwizawatemela mate wamwenga. ");
INSERT INTO cwe_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nizawatemela mate wose wowokutemela mate weye, Mbali yoyose yokuduwila, nizamduwila, na ng'holo zose muna iisi zizatemeligwa mate kufosela weye.” ");
INSERT INTO cwe_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abulamu viyasegele Halani kakala na miyaka malongo saba na tano, fana Mndewa Mulungu viyamulongele kutenda. Na Lutu kahita hamwe nayo. ");
INSERT INTO cwe_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abulamu kamsola Salayi muke wake, na mwihwage Lutu na vinhu vake vose na wanhu wose wowawapatile uko Halani. Wasegela kuhita isi ya Kanaani. Viwafikile muna iisi ya Kanani, ");
INSERT INTO cwe_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abulamu kafosa muna iisi ya Shekemu, hanhu heli na mbiki mkulu uko Mole. Lusita ulo Wakanaani wakala wokala muna iisi iyo. ");
INSERT INTO cwe_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mndewa Mulungu kamulawilila Abulamu na kamulongela, “Ino iyo iisi yondaniweng'he welesi wako.” Maabaho Abulamu kamzengela lupango Mndewa Mulungu, yoyamulawilile. ");
INSERT INTO cwe_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Viyafosile yayo, kasegela mbaka kuna mulima uli ubanzi wa ulawilo wa zua wa Beseli, kasimika hema jake hagati ya Beseli ubanzi wa uswelo wa zua na bululu da Ayi ubanzi wa ulawilo wa zua. Baho iviya kamzengela Mndewa Mulungu lupango na kamtambikila. ");
INSERT INTO cwe_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Maabaho Abulamu kagendelela kulawa hanhu mbaka hanhu ubanzi wa Negebu. ");
INSERT INTO cwe_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kuna iisi ya Kanani kukala na nzala. Ivo Abulamu kahita Misili kukala uko fana mgeni, kwaviya nzala ikala ng'hulu muna iisi. ");
INSERT INTO cwe_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Viyakalile habehi kufika Misili, kamulongela Salayi muke wake, “Novimanya kuwa weye kwa muke lumondo. ");
INSERT INTO cwe_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Lusita Wamisili vondawakuwone, wezalonga kuwa weye muke wangu, ivo wezanikoma na kukuleka. ");
INSERT INTO cwe_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Uwalongele kuwa weye kwa lumbu jangu, muladi kwa ichimu icho wezanitendela yanogile na kunileka mgima kwa ichimu chako.” ");
INSERT INTO cwe_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abulamu viyengile Misili, Wamisili wamuwona muke wake kakala lumondo. ");
INSERT INTO cwe_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Wakulu womtaza mfalume viwamuwone Salayi, wamtogoza kwa mfalume na kagaligwa muna imhongono ya mfalume. ");
INSERT INTO cwe_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kwa ichimu cha Salayi, mfalume kamtendela yanogile Abulamu na kahokela ng'hondolo na ng'ombe na vihongwe wa chilume na wa chike na watumwa wa chilume na wa chike na ngamiya. ");
INSERT INTO cwe_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mbali Mndewa Mulungu kamgaza mfalume na wanhu wose weli muimhongono yake kwa matamu makulu kwa ichimu cha Salayi muke wa Abulamu. ");
INSERT INTO cwe_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Maabaho mfalume kamtanga Abulamu na kamuuza, “Chino choni chounitendele? Habali hunilongele kuwa kakala muke wako? ");
INSERT INTO cwe_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Habali kulonga kuwa ino mwali wako na niye nimsola kuwa muke wangu? Lelo ayo muke wako, msole na msegele hano.” ");
INSERT INTO cwe_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Maabaho mfalume kawalongela wanhu wake wamuleke Abulamu yasegele hamwe na muke wake na vinhu vake vose. ");
INSERT INTO cwe_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abulamu kabwela kulawa Misili kengila ubanzi wa Negebu. Kakala na muke wake na vinhu vake vose hamwe na Lutu. ");
INSERT INTO cwe_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abulamu kakala tajili ng'hani. Kakala na fugo na hela na zahabu. ");
INSERT INTO cwe_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kagendelela kugenda kulawa hanhu ha Negebu mbaka Beseli, kafika hanhu hoyakalile kasimika hema baho haichanduso hagati ya Beseli na Ayi, ");
INSERT INTO cwe_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","hanhu hoyakalile yazengile lupango. Baho Abulamu kamtambikila Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Iviya Lutu yoyagendile na Abulamu, kakala na ng'ombe na ng'hondolo na mahema. ");
INSERT INTO cwe_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Isi haiwafaiye wose waidi kukala hamwe kwaviya wakala na fugo nyingi. ");
INSERT INTO cwe_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kwa ivo kulawilila ndwagi hagati ya wadimaji wanyama wa Abulamu na wadimaji wa Lutu. Chipindi icho Wakanaani na Wapelizi wakala wokala muna iisi ija. ");
INSERT INTO cwe_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Maabaho Abulamu kamulongela Lutu, “Cheye cha ndugu, sekechigombe, hebu wadimaji wako sekewagombe na wadimaji wangu. ");
INSERT INTO cwe_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Lola isi ino yose haulongozi wako, chiigole. Uhahita ukumoso niye nizahita ukulume, hebu uhahita ukulume niye nizahita ukumoso.” ");
INSERT INTO cwe_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutu kenula meso yake na kadiwona bawe da lwanda lwa Yoludani, kawona dina mazi ya kufaya chila hanhu, fana viya mgunda wa Mndewa Mulungu na iviya fana isi ya Misili ubanzi wa Soali. Mndewa Mulungu kakala hanayananga mabululu ya Sodoma na Gomola. ");
INSERT INTO cwe_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kwa ivo Lutu kasagula bawe jose da lwanda lwa Yoludani, na kahita ubanzi wa ulawilo wa zua. Ivo waigola. ");
INSERT INTO cwe_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abulamu kakala muna iisi ya Kanaani, mbali Lutu kakala muna yamabululu yaja ya dibawe na kahamila Sodoma. ");
INSERT INTO cwe_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wanhu wa Sodoma wakala weha na wamuhasanya Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Abulamu viyakomeleze kwiigola na Lutu, Mndewa Mulungu kamulongela, “Inula chihanga chako ulole banzi zose. ");
INSERT INTO cwe_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Isi ino yose yowiiwona, nizakwing'ha weye na welesi wako siku zose. ");
INSERT INTO cwe_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Welesi wako wizakuwa fana msanga, habule munhu yondayadahe kuupeta. ");
INSERT INTO cwe_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lelo hita na ukaizunguluke isi ija, kwaviya nizakwing'ha.” ");
INSERT INTO cwe_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ivo Abulamu kahamiza hema jake, kahita kukala habehi na mibiki mikulu ya Mamule kuja Hebuloni, na uko kamzengela lupango Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Siku izo mfalume Amilafeli wa Shinali na Aliyoki wa Elasali na Kedolilaoma wa Elamu na Tidali wa Goimu, ");
INSERT INTO cwe_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","wahita kwiitowa ng'hondo na wafalume wano. Wafalume wawo ni Belo wa Sodoma na Bilisha wa Gomola na Shinabu wa Adima na Shebeli wa Seboimu na mfalume wa Bela iviya yotangigwa Soali. ");
INSERT INTO cwe_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wafalume wawo wayahanganya majeshi yawo yose hana dibawe da Sidimu, vino sambi ni Bahali ya Munyu. ");
INSERT INTO cwe_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kwa lusita lwa miyaka longo na midi, wakala wolangulizigwa na mfalume Kedolilaoma, mbali viifikile mwaka wa longo na tatu, wamuhinduka. ");
INSERT INTO cwe_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Muna umwaka wa longo na nne, mfalume Kedolilaoma na wafalume wayage weza na kuwahuma Walefai wa uko Ashiteloshi Kiliasaimu na Wazuzi uko Hamu na Waemi uko Shawe Kiliyasaimu. ");
INSERT INTO cwe_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Iviya wawahuma Waholi uko kuna mulima wa Seili, wawawinga kutali mbaka Elipalani habehi na dibwilingu. ");
INSERT INTO cwe_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Maabaho wabwela kuchisogo mbaka Enimishipati iviya yotangigwa Kadeshi, waihuma isi yose ya Waamaleki na kuwahuma Waamoli wowakalile Hasasoni Tamali. ");
INSERT INTO cwe_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Maabaho wafalume wa Sodoma na Gomola na Adima na Seboimu na Bela iviya yotangigwa Soali, watenda ng'hondo na wehi wawo kuna dibawe da Sidimu ");
INSERT INTO cwe_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","waitoa na mfalume Kedolilaoma wa Elamu na Tidali wa Goimu na Amilafeli wa Shinali na Aliyoki wa Elasali, wafalume wane waitowa na wafalume watano. ");
INSERT INTO cwe_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Bawe da Sidimu dikala dimemile makombo ya lami, na baho wafalume wa Sodoma na Gomola viwagezile kukimbila ng'hondo, watumbukiya umo na wamwenga waibangila muna ivigongo. ");
INSERT INTO cwe_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wafalume wawo wane wahumile wasola chila chinhu cha Sodoma na Gomola na ndiya zawo zose, maabaho wasegela. ");
INSERT INTO cwe_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Wamgwila Lutu, mwihwa wa Abulamu, yoyakalile yokala Sodoma, wasola na vinhu vake vose, maabaho wasegela. ");
INSERT INTO cwe_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Munhu imwe yoyasulupuke kahita kumulongela ija Muebulaniya Abulamu yoyakalile kokala habehi na mibiki mikulu ya Mamule Muamoli, yoyakalile ndugu yake Eshikoli na Aneli. Wose wakala wailumba na Abulamu. ");
INSERT INTO cwe_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abulamu viyahulike ndugu yake kagwiligwa, kawatanga wanhu wose wa muna ikaye yake wadahile kwiitowa, wakala magana matatu na longo na nane. Wawasondelela wafalume waja mbaka bululu da Dani. ");
INSERT INTO cwe_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ichilo Abulamu kawagola wanhu wake kuna yamabumbila waitowe na wafalume waja, nayo kawatowa na kuwawinga mbaka Hoba, ili ubanzi wa kasikazi wa Damasiki. ");
INSERT INTO cwe_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kavibweleza vinhu vose visoligwe na wafalume waja, na kambweleza Lutu mwihwage, vinhu vake hamwe na wanaake na wanhu wamwenga. ");
INSERT INTO cwe_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abulamu viyabwelile kulawa kuwahuma Kedolilaoma na wafalume wamwenga, mfalume wa Sodoma kahita kuiting'hana nayo hana dibawe da Shawe, iviya ditangigwa Bawe da mfalume. ");
INSERT INTO cwe_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melikizedeki yoyakale mfalume wa Salemu yoyakalile mkulu wa nhambiko wa Mulungu Yeli Uchanyha, kamgalila Abulamu gate na divai. ");
INSERT INTO cwe_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kamtemela mate Abulamu na kalonga, “Abulamu yatemeligwe mate na Mulungu Yeli Uchanyha, yalumbile ulanga na isi. ");
INSERT INTO cwe_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Yatunhizigwe Mulungu Yeli Uchanyha, yoyakutendile uwahume wehi wako.” Abulamu kamwing'ha Melikizedeki chinhu chimwe muna ichila vinhu longo viyapatile kuna ing'hondo. ");
INSERT INTO cwe_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Na mfalume wa Sodoma kamulongela Abulamu, “Niye ning'he wanhu, mbali vinhu ivo sola weye.” ");
INSERT INTO cwe_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abulamu kamwidika mfalume wa Sodoma, “Noilaha haulongozi wa Mndewa Mulungu Yeli Uchanyha, yalumbile ulanga na isi yose, ");
INSERT INTO cwe_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","sizasola lusingija hebu luzabi lwa chilatu, hebu chinhu chako chochose, muladi sekeulonge kuwa kunitendeza niwe tajili. ");
INSERT INTO cwe_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ivo sizasola chochose, ila ndiya ziya muhala ziwadile wanike na vinhu viwapatile kuna ing'hondo. Wowolondeka waja wowakalile hamwe na niye, Aneli na Eshikoli na Mamule uwaleke wawe na vinhu vawo.” ");
INSERT INTO cwe_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Maabaho mbuli ya Mndewa Mulungu imwezila Abulamu kwa malaguso, ilonga, “Sekeudumbe. Niye ni ngawo yako na nizakugweka.” ");
INSERT INTO cwe_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Mbali Abulamu kamwidika, “Weye Mndewa Mulungu, kwizaning'ha choni na kuno nogendelela kukala bila mwana na muhazi wangu ni Eliyazali wa Damasiki?” ");
INSERT INTO cwe_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abulamu kalonga, “Lola huning'hile mwana, mtumwa yavumbuke muna ikaye yangu kezakuwa muhazi wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Maabaho kahulika mbuli ya Mndewa Mulungu imwizila kaidi: “Ino mtumwa wako Eliyazali hezakuwa muhazi wako, mbali mwanago yondaumweleke mwenyewo niiyo yondayawe muhazi wako.” ");
INSERT INTO cwe_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mndewa Mulungu kamulava kunze na kumulongela “Lola kuulanga na geza kuzipeta nhondo, kwizakuwa na welesi mwingi fana nhondo izo.” ");
INSERT INTO cwe_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abulamu kamuhuwila Mndewa Mulungu, na kwa ichimu icho Mndewa Mulungu kanogezigwa nayo na kamtogola kanoga haulongozi hake. ");
INSERT INTO cwe_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Maabaho Mndewa Mulungu kamulongela Abulamu, “Niye niiyo Mndewa Mulungu yonikulavile kulawa Ulu bululu da Wakalidayo, muladi nikwing'he isi ino iwe yako.” ");
INSERT INTO cwe_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mbali Abulamu kalonga, “Weye Mndewa Mulungu nizavimanyaze kuwa isi ija izakuwa yangu?” ");
INSERT INTO cwe_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mndewa Mulungu kamulongela Abulamu, “Nigalile ng'ombe muke wa miyaka mitatu na mwana luti muke wa miyaka mitatu na bebelu da ng'hondolo da miyaka mitatu na huwa na kinda da nziwa.” ");
INSERT INTO cwe_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abulamu kamgalila Mndewa Mulungu wanyama wawo wose, kabalula chila mnyama vihande vidi, keka chila chihande kwa kusonhela miyage, mbali ndege hawakanhile. ");
INSERT INTO cwe_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Vilele weza na wema muna imitufi, mbali Abulamu kawawinga. ");
INSERT INTO cwe_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Zuwa vidikalile doswa, Abulamu kakala na vuwevuwe da nhongo, ziza totolo dimgubika. ");
INSERT INTO cwe_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Mndewa Mulungu kamulongela Abulamu, “Uvimanye kuwa welesi wako wezakuwa nyambenyambe muna iisi siyo yawo na wezakuwa watumwa na wezagazigwa kwa miyaka magana mane. ");
INSERT INTO cwe_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mbali nizawatagusa wanhu wondawawasang'hanile fana watumwa na hamwande wezasola vinhu vingi. ");
INSERT INTO cwe_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Weye mwenyewo kwizakala miyaka mingi, maabaho kwizadanganika kwa tindiwalo na kuwandigwa. ");
INSERT INTO cwe_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Welesi wako wizabwela hano muna uwelesi wekane, kwaviya uhasanyi wa Waamoli haunakuwa mwingi muladi niwataguse.” ");
INSERT INTO cwe_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Zuwa vidiswile na ziza disonga, tanuli difuka yosi na wenge diwoneka na difosa hagati ya maunde ya nyama. ");
INSERT INTO cwe_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Maabaho Mndewa Mulungu katenda chilagano na Abulamu, kalonga, “Nolagana kuweng'ha ino welesi wako wose kusongela lwanda lwa Misili mbaka lwanda lukulu lwa Efulati, ");
INSERT INTO cwe_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","isi ya Wakeni na Wakenizi na Wakadimoni ");
INSERT INTO cwe_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na Wahiti na Wapelizi na Walefai ");
INSERT INTO cwe_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na Waamoli na Wakanaani na Wagiligashi na Wayebusi.” ");
INSERT INTO cwe_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Salayi muke wake Abulamu kakala hanakweleka mwana. Kakala na mtumwa wa chike Mmisili yoyatangigwe Hajili. ");
INSERT INTO cwe_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Salayi kamulongela Abulamu, “Kuvimanya Mndewa Mulungu haninogele kupata wana. Lelo kambandame mtumwa wangu muladi niwapate wana kufosela yeye.” Abulamu katogola chiya choyalongile Salayi. ");
INSERT INTO cwe_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Maabaho Salayi kamsola Hajili mtumwa wake kulawa Misili kamwing'ha Abulamu yawe fana muke wake. Yano yalawilila lusita Abulamu viyakalile kuna isi ya Kanaani miyaka longo. ");
INSERT INTO cwe_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abulamu kambandama Hajili nayo kapata wimo. Hajili viyawonile kapata wimo, kandusa kumwehula Salayi. ");
INSERT INTO cwe_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Salayi kamulongela Abulamu, “Wihi uno unitendiligwa kwizahusika nawo. Niye nikugolela mtumwa wangu wa chike, mbali viyawile na wimo kanyehula. Mndewa Mulungu nayahumize hagati ya niye na weye.” ");
INSERT INTO cwe_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abulamu kamulongela Salayi, “Mtumwa wako kahasi yako weye, mtendele choulonda.” Maabaho Salayi kamgaza Hajili mbaka kaibanga. ");
INSERT INTO cwe_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Msenga wa Mndewa Mulungu kamvika Hajili kudibwilingu kuna inzasa ya mazi, nzila ya kuhita Shuli. ");
INSERT INTO cwe_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Na kalonga, “Hajili msang'hani wa Salayi, kulawa kulihi na kohita kulihi?” Kamwidika, “Nomkimbila Salayi yonimsang'hanila.” ");
INSERT INTO cwe_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Msenga ija wa Mndewa Mulungu kamulongela, “Bwela kwa youmsang'hanila ukamtegeleza.” ");
INSERT INTO cwe_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Maabaho msenga wa Mndewa Mulungu kamulongela, “Nizakwing'ha welesi mwingi habule munhu yondayadahe kuwapeta.” ");
INSERT INTO cwe_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Msenga wa Mndewa Mulungu kamulongela, “Weye kuna wimo na kwizakweleka mwana wa chilume na zina jake kwizamtanga Ishumaili, kwaviya Mndewa Mulungu kohulika manhesa yako. ");
INSERT INTO cwe_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ishumaili kezakala fana mhunda mbago, kezakuwa mwihi wa chila munhu, na chila munhu kezakuwa mwihi wake. Kezaigola na ndugu zake.” ");
INSERT INTO cwe_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hajili kamwing'ha zina Mndewa Mulungu yoyalongile nayo, “Weye ni Mulungu yoniwona.” Na kalonga, “Kweli niye nimuwona yeye yoniwona.” ");
INSERT INTO cwe_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Lekamana nzasa ija yotangigwa Beeli Laha Iloi. Nzasa iyo yahagati ya Kadeshi na Beledi. ");
INSERT INTO cwe_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hajili kamwelekela Abulamu mwana wa chilume. Abulamu kamtanga zina jake Ishumaili. ");
INSERT INTO cwe_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hajili viyamweleke Ishumaili, Abulamu kakala na miyaka malongo manane na sita. ");
INSERT INTO cwe_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abulamu viyakalile na miyaka malongo kenda na kenda, Mndewa Mulungu kamulawilila na kamulongela, “Niye ni Mulungu mwene Udaho. Nitegeleze siku zose na ukale bila ya kutenda yehile. ");
INSERT INTO cwe_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nizatenda lagano jangu na weye na kukwing'ha welesi mwingi.” ");
INSERT INTO cwe_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abulamu katumbala mavindi mbaka chihanga chidalisa hasi. Mulungu kamulongela, ");
INSERT INTO cwe_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Notenda lagano dino na weye. Nokulongela kwizakuwa tata wa makabila mengi. ");
INSERT INTO cwe_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kwandusila sambi, hwizatangigwa Abulamu kaidi, mbali kwizatangigwa Bulahimu, kwaviya nikutenda uwe tata wa makabila mengi. ");
INSERT INTO cwe_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nizakwing'ha welesi mwingii na makabila mengi na wafalume wezalawa kumwako. ");
INSERT INTO cwe_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Lagano jangu na weye na welesi wako dabule uhelelo. Ivo nizakuwa Mulungu wako na Mulungu wa welesi wako. ");
INSERT INTO cwe_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nizakwing'ha weye na welesi wako isi ino imuli nyambenyambe sambi. Isi yose ya Kanaani izakuwa yenu siku zose, na niye nizakuwa Mulungu wawo.” ");
INSERT INTO cwe_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Maabaho Mulungu kamulongela Bulahimu, “Weye iviya kolondeka wamhe lagano jangu, weye na welesi wako wose. ");
INSERT INTO cwe_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Vino niivo vimulondeka kutenda weye na welesi wako, chila mulume kolondeka yengizigwe ulungwana. ");
INSERT INTO cwe_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mwizakwingizigwa ulungwana, na ino izakuwa chilaguso cha lagano da mweye na niye. ");
INSERT INTO cwe_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Chila mwana wa chilume wa siku nane vimuli kolondeka yengizigwe ulungwana na chila mulume wa welesi wenu, yawe mtumwa yelekigwe muna ikaye yenu hebu yoyaguligwe kwa hela zenu kulawa kwa manyambenyambe ");
INSERT INTO cwe_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","na chila mwana wa chilume yelekigwe muna ikaye yako hebu yaguligwe kwa hela kolondeka yengizigwe ulungwana. Chino chizakuwa chilaguso muna ulukuli kulagusa kuwa lagano donikile na weye ni da siku zose. ");
INSERT INTO cwe_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mulume yoyose hengizigwe ulungwana kezabaguligwa na wanhu wake, kwaviya hadikile lagano jangu bule.” ");
INSERT INTO cwe_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Maabaho Mulungu kamulongela Bulahimu, “Mke wako hwizamtanga kaidi Salayi, kwandusila sambi zina jake Sala. ");
INSERT INTO cwe_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nizamtemela mate, nayo kezakwelekela mwana wa chilume. Nizamtemela mate Sala, nayo kezakuwa mama wa makabila mengi na wafalume wa zisi nyingi wezalawa kumwake.” ");
INSERT INTO cwe_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Bulahimu katumbala mavindi mbaka chihanga chake chidalisa hasi, kaseka na kalonga muna umoyo wake, “Vino mulume yeli na miyaka gana kodaha kupata mwana? Vino Sala kodaha kupata mwana na miyaka malongo kenda?” ");
INSERT INTO cwe_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Bulahimu kamuuza Mulungu, “Habali humuleka Ishumaili yahazi chiya chounilaganile?” ");
INSERT INTO cwe_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mulungu kedika, “Siyo. Muke wako Sala kezakwelekela mwana wa chilume, nayo kwizamtanga Isaka. Nizakwika lagano jangu kumwake na welesi wake. Ijo ni lagano da siku zose. ");
INSERT INTO cwe_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nihulika pulo jako kusonhela Ishumaili, ivo nizamtemela mate na kumwing'ha wana wengi na welesi mwingii. Kezakuwa tata wa wafalume longo na waidi, na nizakutenda uwe kabila kulu. ");
INSERT INTO cwe_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mbali nizakwika lagano jangu kwa mwanago Isaka, yondayelekigwe na Sala lusita fana luno mwaka ukwiza.” ");
INSERT INTO cwe_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mulungu viyakomeleze kulonga na Bulahimu, kahita kuchanyha kuulanga. ");
INSERT INTO cwe_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Bulahimu kawasola Ishumaili mwanage na walume wamwenga wose, wowelekigwe mwiikaye yake na wowaguligwe kwa hela zake, kawengiza ulungwana fana Mulungu viyamulagilize. ");
INSERT INTO cwe_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Bulahimu viyengizigwe ulungwana kakala na miyaka malongo kenda na kenda, ");
INSERT INTO cwe_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","na Ishumaili mwanage viyengizigwe ulungwana kakala na miyaka longo na mitatu. ");
INSERT INTO cwe_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Bulahimu na Ishumaili mwanage wengizigwa ulungwana siku iyo. ");
INSERT INTO cwe_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Walume wose weli muna ikaye ya Bulahimu, wowelekigwe muna ikaye yake na wowaguligwe kwa hela, wengizigwa ulungwana hamwe nayo. ");
INSERT INTO cwe_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mndewa Mulungu kamulawila Bulahimu heli na mibiki mikulu ya Mamule. Bulahimu kakala yakalile hana ulwivi lwa dihena jake lusita lwa vuke da imisi. ");
INSERT INTO cwe_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kalola uchanyha na kawawona wanhu watatu wema habehi nayo. Kawakimbilila hima hima kuwahokela, kadulisa ditwi jake mbaka chihanga chidalisa hasi, ");
INSERT INTO cwe_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","na kalonga, “Wenevale, one munogelwa na niye sekemuifose kaye yangu bila kwima, nahano muladi nidahe kuwasang'hanila. ");
INSERT INTO cwe_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Niwagalileni mazi muladi mudahe kuguma nhende na kuhumula hasi hana umbiki uno. ");
INSERT INTO cwe_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kuno mohumula niifunganye ndiya chidogo muladi muje mpate nguvu ya kugendelela na mwanza wenu, kwaviya munizila niye mtumwa wenu.” Nawo wamwidika “Vinoga, sang'hana fana viulongile.” ");
INSERT INTO cwe_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Bulahimu kabwela hima kuna ihema kamulongela Sala, “Lopola, sola mhishi tano za usage unogile na uhonde magate.” ");
INSERT INTO cwe_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Maabaho Bulahimu kakimbila kuna dibumbila da zing'ombe kasagula dang'ang'a dimwe ng'ombe dinenehe, kamwing'ha msang'hani, yoyadisasale hima hima. ");
INSERT INTO cwe_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Maabaho Bulahimu kasola matombo, matombo yagandile na ija inyama ifunganyigwe, kawasasalila ndiya manyambenyambe na kawekila, nayo kema habehi viwakalile woja haja hasi hana umbiki. ");
INSERT INTO cwe_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Maabaho wamuuza, “Kakulihi muke wako Sala?” Kawedika, “Kakuja kugati kuna ihema.” ");
INSERT INTO cwe_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Imwe wa nyambenyambe waja kamulongela Bulahimu, “Lusita fana luno mwaka ukwiza nizakubwelela, na muke wako Sala kezakuwa na mwana wa chilume.” Sala kakala hachisogo chake hana ulwivi lwa ihema kotegeleza. ");
INSERT INTO cwe_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Bulahimu na Sala wakala walala ng'hani, na Sala kafosa lusita lwa kweleka. ");
INSERT INTO cwe_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kwa ivo Sala kaseka chimoyomoyo na kalonga, “Sambi niye namulala. Lelo nodahaze kudeng'helela kupata wimo kwa mulumangu yeli mulala?” ");
INSERT INTO cwe_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Baho Mndewa Mulungu kamuuza Bulahimu, “Habali Sala kaseka na kalonga, ‘Kweli izadahika nyeleke mwana na niye mulala?’ ");
INSERT INTO cwe_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Vino kuna jojose hadidahika kwa Mndewa Mulungu? Lusita fana luno mwaka ukwiza nizabwela, na Sala kezakuwa na mwana wa chilume.” ");
INSERT INTO cwe_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ivo Sala kadumba, kabela na kalonga, “Sisekile bule.” Mndewa Mulungu kamulongela, “Ona, kuseka.” ");
INSERT INTO cwe_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Maabaho wanhu wawo wasegela wahita hanhu howadahile kudiwona bululu da Sodoma, na Bulahimu kawasindikiza. ");
INSERT INTO cwe_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mndewa Mulungu kalonga, “Nimfise Bulahimu mbuli zondanitende? ");
INSERT INTO cwe_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Bulahimu kezakuwa tata wa kabila kulu, kufosela yeye wanhu wa zisi zose wezatemeligwa mate. ");
INSERT INTO cwe_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nimsagula yeye muladi yawafundize wanage na waja wokala muna ikaye yake kusondelela nzila ya Mndewa Mulungu kwa kutenda yanogile haulongozi wangu. Na niye nizamtendela Bulahimu chiya chonimulaganile.” ");
INSERT INTO cwe_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Maabaho Mndewa Mulungu kalonga, “Nihulika kuna mbuli zihile nyingi kwa wanhu wa Sodoma na Gomola, na uhasanyi wawo ubasanya. ");
INSERT INTO cwe_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nihumuluke nihite uko nikalole mwenyewo fana yoniyahulike ni kweli.” ");
INSERT INTO cwe_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Maabaho wanhu waja wasegela na wahita kusonhela Sodoma mbali Mndewa Mulungu kasigala na Bulahimu. ");
INSERT INTO cwe_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Bulahimu kamkwenhukila Mndewa Mulungu kamuuza, “Vino weye kwizawananga wanhu wanogile hamwe na wehile? ");
INSERT INTO cwe_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Yahawa muna dibululu muna wanhu wanogile haulongozi wa Mulungu, vino kwizadinanga bululu ijo jose? Vino kwizadinanga bululu jose badala ya kudileka kwa ichimu cha wanhu wanogile malongo matano weli umo? ");
INSERT INTO cwe_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Sigesa kuwa kwizatenda ivo, kuwakoma wanhu wanogile hamwe na wehile, kuwatendelela wanhu wanogile na wehile. Vino msemi wa isi yose hatenda yanogile?” ");
INSERT INTO cwe_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mndewa Mulungu kamwidika, “Nahawafika wanhu wanogile malongo matano kuja kudibululu da Sodoma nizadileka bululu jose kwa ichimu chawo.” ");
INSERT INTO cwe_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Bulahimu kamulongela kaidi, “Nolamba unilekelele nilonge na Mndewa, niye nili matimbwisi na maivu. Niye ni munhu muhala na sifaya kulonga chinhu chochose. ");
INSERT INTO cwe_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mbali huwenda wopatika wanhu wanogile malongo mane na tano. Ivo kwizadinanga bululu jose kwaviya waswela wanhu watano?” Mndewa Mulungu kedika, “Sizadinanga bule bululu one nahawafika wanhu wanogile malongo mane na tano.” ");
INSERT INTO cwe_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Bulahimu kalonga kaidi, “Huwenda kwizakuwa na wanhu wanogile malongo mane?” Kamwidika, “Sizadinanga bule one kuna wanhu malongo mane.” ");
INSERT INTO cwe_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Bulahimu kalonga, “Nokulamba Mndewa, sekeuwe na ludoko mbali leka nilonge kaidi. One wahawafika wanhu malongo matatu?” Kamwidika, “Sizatenda ivo bule one nahawafika wanhu malongo matatu.” ");
INSERT INTO cwe_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Bulahimu kalonga, “Kwaviya nikulamba bila ya ludumbo, nokulamba kaidi Mndewa. One wahawafika wanhu malongo maidi muhala?” Kamwidika, “Sizadinanga bule one nahawafika wanhu malongo maidi.” ");
INSERT INTO cwe_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Bulahimu kalonga, “Nokulamba Mndewa sekeuwe na ludoko, mbali nolamba nilonge kaidi mwanza umwe muhala. Yokuwaze wahawafika wanhu longo muhala?” Mndewa Mulungu kalonga, “Sizadinanga bule dibululu ijo one nahawafika wanhu longo.” ");
INSERT INTO cwe_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mndewa Mulungu viyakomeleze kulonga na Bulahimu, kasegela, Bulahimu kabwela ukaye. ");
INSERT INTO cwe_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Wasenga wa kuulanga waidi wafika Sodoma ichigulogulo, Lutu kakala yakalile hana ulwivi lwa dibululu. Viyawawone, kahita kuwahohela na kuwatumbalila mavindi mbaka chihanga chidalisa hasi. ");
INSERT INTO cwe_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kalonga, “Wenevale wangu, ingileni muna ikaye yangu niye msang'hani wenu. Modaha kunawa nhende na kugona chilo cha diyelo, igolo imitondo modaha kusegela na kugendelela na mwanza wenu.” Mbali wawo wamwidika, “Bule, chizakala chilo chose hano hana ulubuga.” ");
INSERT INTO cwe_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lutu kawabembeleza ng'hani mbaka watogola, wahinduka na kwingila muna ikaye yake. Lutu kawasasalila magate hayagumigwe lusu na kasasalila dugila kwa manyambenyambe. Manyambenyambe waja zindiya zisasaligwe. ");
INSERT INTO cwe_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nyambenyambe wang'hali hawanagona, walume wa Sodoma waizunguluka kaye ya Lutu. Walume wose wa bululu diya, wakulu na wadodo wakala baho. ");
INSERT INTO cwe_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wamtanga Lutu kunze na wamuuza, “Wakulihi walume waja wezile kumwako? Chilavile kunze muladi chiwabandame.” ");
INSERT INTO cwe_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu kalawa kunze na kahinda ulwivi. ");
INSERT INTO cwe_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Kawalongela, “Mbwiya zangu, nowalamba sekemutende wihi uno. ");
INSERT INTO cwe_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mbali ninawo wali waidi wang'hali mhambe. Lekeni nimwing'heni wawo na mweye mwizawatenda chochose chimulonda kuwatenda. Mbali wanhu wano sekemuwatende chochose, kwaviya wano ni nyambenyambe wangu, nolondeka niwakalize.” ");
INSERT INTO cwe_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mbali wawo walonga, “Teng'hu segela hano! Weye kwa nyambenyambe, na weye kwa yelihi kochilongela cha kutenda? Koitenda weye kwa msemi wetu? Ivo chokutenda yehile kufosa wawo wafosanzila wako.” Wamsung'ha Lutu kuchisogo wamsegeza mbaka walonda kulubena ulwivi lwake. ");
INSERT INTO cwe_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mbali waja iwanhu waidi wowakalile mgati, wagolosa makono yawo, wamkwesa Lutu mgati mwa ikaye na kuluhinda ulwivi. ");
INSERT INTO cwe_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Maabaho kawatenda wanhu wose wowakalile haulwivi watulike yameso, wakulu kwa wadodo, mbaka hawadahile bule kulupata ulwivi. ");
INSERT INTO cwe_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wanhu waja iwaidi wamulongela Lutu, “One kuna munhu yoyose yokala hano, wanago wa chilume na wandele zako na wakoyi hebu ndugu imwenga yokala muna dibululu, uwalave hanhu hano himahima. ");
INSERT INTO cwe_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Chizahananga hanhu hano, kwaviya kuiyalala kwa wanhu wa hano kumfikila Mndewa Mulungu, nayo kachituma chidinange bululu da Sodoma.” ");
INSERT INTO cwe_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Maabaho Lutu kawagendela wakoyi zake wowolonda kuwasola wandele zake na kawalongela, “Segeleni hano himahima, Mndewa Mulungu kohananga hanhu hano.” Mbali wawo wamuwona fana viya kehuka. ");
INSERT INTO cwe_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Vikuchile wasenga waja wa kuulanga wamulongela Lutu, “Lopola na umsole muke wako na wano wandele zako waidi muladi sekemwize kunangigwa lusita bululu dino vondaditagusigwe.” ");
INSERT INTO cwe_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mbali Lutu kakalama. Kwaviya Mndewa Mulungu kamuwonela ubazi, waja iwasenga wa kuulanga wawamha Lutu na muke wake na wandele zake waidi, wawalava mudibululu. ");
INSERT INTO cwe_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Viwakomeleze kuwalava, imwe wa wasenga waja wa kuulanga kalonga, “Kimbileni muladi muhonyeke. Sekemulole kuchisogo na sekemwime muna dibawe, kimbilileni muna imilima muladi sekemukomigwe.” ");
INSERT INTO cwe_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mbali Lutu kamwidika, “Siyo, wenevale wangu. ");
INSERT INTO cwe_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Muninogela na kunihonya ugima wangu kwa kunilagusa ulondo. Mbali milima yakutali, ivo kunangigwa kuno kwizanifika ning'hali sinafika uko na nizadanganika. ");
INSERT INTO cwe_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Loleni kuja kuna bululu dodo nodaha kudikimbilila kwaviya dahabehi. Lelo nilekelele nikimbilile uko. Diya ni bululu dodo muhala na uko nizahonyeka.” ");
INSERT INTO cwe_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nayo kamwidika, “Vinoga, nitogola chiupulile, sizadinanga bululu diya. ");
INSERT INTO cwe_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kimbila! Himahima! Sizadaha kutenda chochose mbaka vondaufike uko.” Lutu kaditanga bululu ijo “Soali” fambulo jake “Dodo.” ");
INSERT INTO cwe_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Zuwa dikala dilawile lusita Lutu viyafikile Soali. ");
INSERT INTO cwe_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Maabaho Mndewa Mulungu kagala makala ya moto kulawa kuulanga muna yamabululu ya Sodoma na Gomola. ");
INSERT INTO cwe_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kayananga mabululu yayo na bawe jose na wanhu wose wowakalile uko na mimeya yose yoikalile muna isi. ");
INSERT INTO cwe_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mbali muke wake Lutu kalola kuchisogo na kagaluka mhanda ya munyu. ");
INSERT INTO cwe_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Igolo yake imitondo, Bulahimu kahita himahima hoyakalile kema haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Viyakalile baho, kalola Sodoma na Gomola na banzi zose za dibawe, kalola na kawona yosi dofuka kulawa muna isi, yosi fana viya da tanuli kulu. ");
INSERT INTO cwe_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Baho Mulungu viyanangile mabululu ya dibawe Lutu hoyakalile kokala, kamkumbuka Bulahimu kwa kumulava Lutu muna yamabululu yano, muladi Lutu sekeyanangigwe. ");
INSERT INTO cwe_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kwaviya Lutu kakala kodumba kukala Soali, yeye na wandele zake waidi wasegela kuna na wahita kukala kuna dituka kuna imilima. ");
INSERT INTO cwe_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Imndele imkulu kamulongela mdodo wake, “Sambi tati yetu mulala na muna iisi habule mulume wa kuchisola chipate wana fana viili muna isi. ");
INSERT INTO cwe_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Lelo chimng'wize upele tati yetu muladi chidahe kwiibandama nayo chimwelekele wana.” ");
INSERT INTO cwe_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ichilo icho wamng'wiza upele tati yawo, na imndele imkulu kahita kaibandama nayo. Mbali tati yake havimanyile bule lusita imndele wake viyaibandame nayo, kwaviya kakala yakoligwe. ");
INSERT INTO cwe_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Igolo yake imndele imkulu kamulongela imdodo, “Niibandama na tata ichilo, Lelo leka chimng'wize upele kaidi maabaho weye wiibandame nayo, ivo chose chizakweleka nayo wana.” ");
INSERT INTO cwe_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ivo ichilo icho wamng'wiza upele tati yawo, maabaho ija imndele imdodo, kahita kaibandama nayo. Mbali tati yake havimanyile bule lusita mndele wake viyaibandame nayo, kwaviya kakala yakoligwe. ");
INSERT INTO cwe_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kwa nzila ino wandele wose wa Lutu weng'higwa wimo na tati yawo. ");
INSERT INTO cwe_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Imndele imkulu keleka mwana na zina jake kamtanga Moabu, iyo niiyo wasaho yawo Wamoabu mbaka diyelo. ");
INSERT INTO cwe_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Imndele imdodo iviya keleka mwana na zina jake kamtanga Benami. Iyo niiyo wasaho yawo Waamoni mbaka diyelo. ");
INSERT INTO cwe_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Bulahimu kasegela kahita ubanzi wa Negebu, kakala Gelali hagati ya Kadeshi na Shuli kwa lusita. ");
INSERT INTO cwe_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Bulahimu kalonga kuwa Sala kakala lumbu jake. Ivo mfalume Abimeleki wa Gelali kamsola Sala. ");
INSERT INTO cwe_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mbali ichilo Mulungu kamulawilila Abimeleki muna zinzozi na kamulongela, “Kwizadanganika kwaviya kumsola muke ino, yoyamalile kusoligwe.” ");
INSERT INTO cwe_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mbali Abimeleki hambandame Sala na kalonga, “Mndewa, niye ninoga haulongozi wako! Vino kwizaninanga niye na kabila jangu? ");
INSERT INTO cwe_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Bulahimu mwenyewo kalonga kuwa kakala lumbu jake, Sala iviya kalonga ivo ivo. Nitenda voilondeka na sisang'hane wihi.” ");
INSERT INTO cwe_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mulungu kamwidika Abimeleki muna zinzozi, “Vinoga, novimanya kuwa yayo youtendile yanoga muumoyo, ivo nikugomesa sekeunitendele uhasanyi na sikulekile umdalise muke iyo. ");
INSERT INTO cwe_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Mbali lelo mbweleze muke iyo kwa mulumake, Bulahimu ni mulotezi wa Mulungu nayo kezakutosela, hwizadanganika bule. Mbali one humbweleze, nokuzuma uvimanye kwizadanganika weye na wanhu wako wose.” ");
INSERT INTO cwe_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Imitondo ng'hani Abimeleki kawatanga wasang'hani wake wose na kawalongela mbuli zose zozilawilile, nawo wadumba ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Maabaho Abimeleki kamtanga Bulahimu na kamuuza, “Kuchitendela choni? Nikubananga choni mbaka kunitenda niwe habehi na kutenda uhasanyi niye na ufalume wangu? Kunitendela mbuli za mdukula hazifaya bule kusang'hanigwa.” ");
INSERT INTO cwe_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleki kamuuza Bulahimu, “Habali kusang'hana ivo?” ");
INSERT INTO cwe_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Bulahimu kamwidika, “Nitenda ivo kwaviya nigesa hanhu hano habule munhu yomdumba Mulungu, iviya mwahadahile kunikoma muladi mumsole muke wangu. ");
INSERT INTO cwe_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Iyo kweli ni lumbu jangu. Yeye ni mwana wa tati yangu, mbali siyo mwana wa mami yangu, na nimsola. ");
INSERT INTO cwe_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lusita Mulungu viyanisegeze muna ikaye ya tati yangu na kunigala kuna iisi imwenga, nimulongela muke wangu, ‘One uhanilonda, hohose hondachihite umulongele chila munhu kuwa weye ni lumbu jangu.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Maabaho Abimeleki kambweleza Sala kwa Bulahimu, iviya kamwing'ha ng'hondolo na ng'ombe na watumwa wa chilume na watumwa wa chike. ");
INSERT INTO cwe_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Maabaho Abimeleki kamulongela Bulahimu, “Lola isi ino yose yangu, kala hohose houlonda.” ");
INSERT INTO cwe_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Maabaho Abimeleki kamulongela Sala, “Nomwing'ha lumbu jako vihande magana longo va hela, kuwalagusa wose weli hamwe na weye kuwa kunoga haulongozi wa Mulungu. Chila munhu yavimanye kuwa kwabule wihi.” ");
INSERT INTO cwe_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Maabaho Bulahimu kampula Mulungu, na Mulungu kawahonya Abimeleki na muke wake na watumwa wake wa chike, ivo weleka wana. ");
INSERT INTO cwe_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Mana Mndewa Mulungu kawatenda wanhu wa kaye ya Abimeleki sekeweleke wana, kwa ichimu cha Sala muke wa Bulahimu. ");
INSERT INTO cwe_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mndewa Mulungu kamtemela mate Sala fana viyamulongele. ");
INSERT INTO cwe_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sala kapata wimo na kamwelekela Bulahimu mwana viyakalile mulala. Imwana kelekigwa lusita luja Mulungu loyalongile kezakwelekigwa. ");
INSERT INTO cwe_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Bulahimu kamtanga zina jake Isaka, ");
INSERT INTO cwe_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isaka viyakalile na siku nane, Bulahimu kamwingiza ulungwana fana Mulungu viyamulagilize. ");
INSERT INTO cwe_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Bulahimu kamweleka Isaka viyakalile na miyaka gana. ");
INSERT INTO cwe_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sala kalonga, “Mndewa Mulungu kanigalila deng'ho na seko. Chila yondayahulike mbuli ino kezaseka na niye.” ");
INSERT INTO cwe_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Maabaho Sala kongezela kulonga, “Yelihi yahadahile kumulongela Bulahimu kuwa niye Sala nizakong'heza wana? Mbali nimwelekela mwana wa chilume muna ulala wake.” ");
INSERT INTO cwe_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Imwana kakula, na siku viyalekezigwe kong'ha, Bulahimu katenda dugila kulu. ");
INSERT INTO cwe_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Siku dimwe Sala kamuwona Ishumaili mwana wa Bulahimu yoyelekigwe na Hajili Mmisili, koseka. ");
INSERT INTO cwe_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sala kawawona na kamulongela Bulahimu, “Msegeze mtumwa ino na mwanage. Mwana wa mwanamke mtumwa hadaha kuhazi hamwe na mwanangu Isaka.” ");
INSERT INTO cwe_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Mbuli ino imguma luholozi ng'hani Bulahimu, kwaviya Ishumaili nayo iviya kakala mwanage. ");
INSERT INTO cwe_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mbali Mulungu kamulongela Bulahimu, “Sekeuwe na luholozi kwa ichimu cha mwana ino na Hajili mami yake. Mbuli yoyose yondayakulongele Sala uitende, kwaviya kufosela Isaka kwizakuwa na welesi wonikulaganile. ");
INSERT INTO cwe_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Iviya nizampatila wana wengi, mwana wa mtumwa wako wa chike, nizamwing'ha makabila mengi kwaviya iyo nayo mwanago.” ");
INSERT INTO cwe_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Igolo yake imitondo Bulahimu kamwing'ha Hajili ndiya na nongo imemile mazi. Kamtwika mwanage mdiyega na kumuwinga hamwe na mami yake. Wasegela na wengila muna dibwilingu da Belisheba. ");
INSERT INTO cwe_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mazi viyamalile yose muna inongo, kamuleka imwana hasi ya mbiki mguhi. ");
INSERT INTO cwe_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Nayo kahita kumgwazo utali wa magulu gana. Kuno kolongelela kuna umoyo wake, “Sidaha bule kumuwona mwanangu viyodanganika.” Hajili viyakalile kumgwazo kandusa kulila kwa dizi kulu. ");
INSERT INTO cwe_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mulungu kamuhulika imwana kolila, msenga wa Mulungu kulawa kuulanga kamulongela Hajili, “Kuna uzidilwa waki Hajili? Sekeudumbe kwa viya Mulungu kahulika imbwanga viyolila. ");
INSERT INTO cwe_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ima na umwinule imwana vinogile, mana nizamtenda yawe wasaho wa makabila mengi.” ");
INSERT INTO cwe_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Maabaho Mulungu kamgubula yameso Hajili, nayo kawona sima da mazi. Kahita na kaimemeza mazi inongo na kamwing'ha mwanage. ");
INSERT INTO cwe_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mulungu kawa hamwe na imwana, nayo kakula, kakala muna dibwilingu da Palani, iviya kakala galu wa kutowa misale. ");
INSERT INTO cwe_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Kakala kuna dibwilingu da Palani, mami yake kamsolela muke kulawa isi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Chipindi icho Abimeleki hamwe na Fikoli mkulu wa wakalizi wake, kamulongela Bulahimu, “Mulungu kahamwe na weye kwa chila chinhu chiutenda. ");
INSERT INTO cwe_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ivo ilahile kwa zina da Mulungu kuwa hwizanivwizila niye na wanangu na welesi wangu. Fana niye viniwile mwaminika kumwako, ivo na weye uwe mwaminika kumwangu na kwa isi yuukala.” ");
INSERT INTO cwe_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Bulahimu kalonga, “Noilaha.” ");
INSERT INTO cwe_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Maabaho Bulahimu kamulongela Abimeleki kwa ichimu cha sima diya dowamuhokile watumwa wa Abimeleki. ");
INSERT INTO cwe_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Mbali Abimeleki kamulongela, “Niye sivimanyile bule yelihi yoyatendile vino. Na weye hunilongele bule mbuli zino, hebu sinahulika mbuli zino mbaka diyelo.” ");
INSERT INTO cwe_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Maabaho Bulahimu kasola ng'hondolo na ng'ombe lume na kamgolela Abimeleki, nawo waidi weka lagano. ");
INSERT INTO cwe_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Bulahimu kawabagula wanang'hondolo wa chike saba, ");
INSERT INTO cwe_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki kamuuza Bulahimu, “Habali kutenda ivo?” ");
INSERT INTO cwe_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Bulahimu kamwidika, “Wanang'hondolo wano wa chike saba, nokwing'ha kwa mkono wangu mwenyewo muladi iwe ukalangama kuwa niye iyo nihimbile sima dino.” ");
INSERT INTO cwe_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Hanhu baho hatangigwa Belisheba, fambulo jake, “Sima da kuilahila.” ");
INSERT INTO cwe_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Viwakomeleze kutenda lagano uko Belisheba, Abimeleki na Fikoli yakalile mkulu wake wa wakalizi wasegela kubwela kuna iisi ya Wafilisiti. ");
INSERT INTO cwe_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Bulahimu kahanda mbiki woutangigwa tamalisiki uko Belisheba na katambika kwa zina da Mndewa Mulungu, Mulungu wa siku zose. ");
INSERT INTO cwe_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Bulahimu kakala muna iisi ya Wafilisiti kwa siku nyingi. ");
INSERT INTO cwe_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Viyafosile yayo Mulungu kamgeza Bulahimu. Kamulongela, “Bulahimu!” Nayo Bulahimu kamwidika, “Nabaha!” ");
INSERT INTO cwe_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Mulungu kamulongela, “Umsole Isaka mwanago nyachende youmulonda na uhite mbaka isi ya Moliya na umulave nhosa ya kutimbuligwa muna mulima uja wondanikulongele.” ");
INSERT INTO cwe_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Imitondo ng'hani Bulahimu kalamka na kampapiza mbahasha chihongwe wake na kawasola wasang'hani wake waidi na Isaka mwanage, kahita kukanha ngodi kwa ichimu cha nhambiko ya kutimbula. Maabaho wahita hanhu hoyalongeligwe na Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Siku yetatu Bulahimu kenula yameso yake na kahawona hanhu baho kwa kutali. ");
INSERT INTO cwe_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Maabaho Bulahimu kawalongela wasang'hani wake, “Kaleni hano hamwe na ichihongwe, niye na ino imbwanga chohita kuja mchanyha kutosa maabaho chizawabwelela mweye.” ");
INSERT INTO cwe_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Bulahimu kasola zingodi kamtwika Isaka mwanage kwa ichimu cha nhosa ya kutimbuligwa na Bulahimu kasola moto na mwele, wose waidi wahita hamwe. ");
INSERT INTO cwe_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka kamulongela tati yake, “Tata!” Bulahimu kamwidika, “Aino mwanangu, kolongaze?” Isaka kamuuza, “Moto na ngodi ivo vino, mbali ng'hondolo wa nhambiko ya kutimbula kakulihi?” ");
INSERT INTO cwe_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Bulahimu kamwidika, “Mulungu mwenyewo kezaning'ha ng'hondolo wa nhambiko ya kutimbula.” Wawo waidi wagendelela na umwanza. ");
INSERT INTO cwe_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Viwafikile hanhu baho Mulungu hoyamulongele, Bulahimu kazenga lupango na kwika ngodi uchanyha yake. Maabaho kamfunga Isaka mwanage na kamtambalisa uchanyha ya zingodi muulupango. ");
INSERT INTO cwe_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Bulahimu kawinula mwele wake kumchinja mwanage. ");
INSERT INTO cwe_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mbali msenga wa Mndewa Mulungu kamtanga kulawa kuulanga, “Bulahimu, Bulahimu!” Bulahimu kamwidika, “Nabaha.” ");
INSERT INTO cwe_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Msenga wa Mndewa Mulungu kamulongela, “Sekeumulumize imwana, hebu sekeumtendele chinhu chochose,” Lelo nivimanya weye komtegeleza Mulungu, kwaviya hunimile bule mwanago nyachende. ");
INSERT INTO cwe_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Bulahimu kenula meso na kawona bebelu da ng'hondolo dinamata mhembe zake kuna ichisolo, Bulahimu kahita na kamsola, kamulava nhambiko ya kutimbula badala ya mwanage. ");
INSERT INTO cwe_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Bulahimu kahatanga hanhu baho, “Mndewa Mulungu kaning'ha.” Mbaka diyelo wanhu wolonga, “Muna mulima wa Mndewa Mulungu wanhu wokwing'higwa.” ");
INSERT INTO cwe_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Msenga wa Mndewa Mulungu kulawa kuulanga kamtanga Bulahimu mwanza wekaidi, ");
INSERT INTO cwe_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","kamulongela, “Mndewa Mulungu kolonga vino, ‘Niilaha kwa zina jangu mwenyewo kuwa kwaviya kutenda vino, hebu hunimile mwanago yaidumwe, ");
INSERT INTO cwe_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ivo nizakutemela mate na nizawongezela welesi wako fana viya nhondo za kuulanga na fana viya msanga uli mumgwazo ya bahali. Welesi wako wezayasola mabululu ya wehi wawo. ");
INSERT INTO cwe_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kufosela welesi wako makabila yose yezatemeligwa mate, kwaviya kunitegeleza.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Bulahimu kawabwelela wasang'hani wake, na wabwela wose hamwe mbaka Belisheba, hanhu hoyakalile Bulahimu. ");
INSERT INTO cwe_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Viyafosile yayo Bulahimu kalongiligwa kuwa Milika kamwelekela wana Naholi sekulu wake, ");
INSERT INTO cwe_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","mwanage chaudele katangigwa Usi na wamwenga Busi na Kemueli tati yake Alamu, ");
INSERT INTO cwe_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi na Hazo na Pilidashi na Yidilafu na Besueli. ");
INSERT INTO cwe_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Besueli kamweleka Lebeka, Milika kamweleka Naholi, ndugu yake Bulahimu, wana wawo wanane. ");
INSERT INTO cwe_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Na Leuma mtumwa wa chike wa Naholi yoyamtendile fana muke wake, iviya kamwelekela wana, Teba na Galamu na Tahalashi na Maaka. ");
INSERT INTO cwe_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sala kakala miyaka gana na malongo maidi na saba. ");
INSERT INTO cwe_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sala kadanganika uko Kiliasi Aliba, iviya yotangigwa Hebuloni, muna iisi ya Kanaani, na Bulahimu kamtendela tanga na kamulilila. ");
INSERT INTO cwe_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Bulahimu kasegela hanhu hautambalisigwe ulukuli lwa muke wake, kahita kwa Wahiti na kawalongela, ");
INSERT INTO cwe_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Niye nyambenyambe, yonikala hano hamwe na mweye, nichuuzileni hanhu ha kuwandila muladi nidahe kumuwanda muke wangu na wanhu wa kabila jangu.” ");
INSERT INTO cwe_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wahiti wamwidika Bulahimu, ");
INSERT INTO cwe_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mwenevale chitegeleze, weye ni mulangulizi mkulu yousaguligwe na Mulungu kumwetu. Muwande muke wako muna dileme jojose dondaudisagule. Habule munhu yoyose yondayakwime leme jake, hebu kukugomesa sekeumuwande muke wako.” ");
INSERT INTO cwe_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Maabaho Bulahimu kema na kainama haulongozi ha Wahiti, wanhu wa isi ija ");
INSERT INTO cwe_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","kawalongela, “Yahawa munitogolela niwawande wanhu wa kabila jangu, nolamba mpuleni Efiloni mwana wa Sohali ");
INSERT INTO cwe_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","yanichuuzile tuka da Makipela dili habehi na imhaka ya mgunda wake. Mulongeleni yanichuuzile nitende maleme yanichuuzile kwa beyi yoilondeka hano hano kuno molola.” ");
INSERT INTO cwe_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efiloni mwenyewo kakala imwe wa Wahiti wawo wowakalile waiting'hana hana ulwivi lwa dibululu. Ivo Efiloni Muhiti kamwidika Bulahimu haulongozi ha wanhu wose wowakalile baho, ");
INSERT INTO cwe_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Unitegeleze, mwenevale, nokwing'ha mgunda wose na tuka dili umo, ivo nokugolela kuno wakaya wayangu wolola, udahe kuwawanda wanhu wa kabila jako.” ");
INSERT INTO cwe_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Bulahimu kainama haulongozi ha wanhu wa isi ija ");
INSERT INTO cwe_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","na kamulongela Efiloni kuno wanhu wose wohulika, “Unihulike nokulamba, nizagula mgunda wako, nokulamba uhokele maliho yano, nidahe kuwawanda wanhu wa kabila jangu.” ");
INSERT INTO cwe_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efiloni kamwidika Bulahimu, ");
INSERT INTO cwe_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mwenevale nitegeleze, mgunda wa magana sehekeli magana mane ya hela. Ni choni hagati yako na niye? Wawande wanhu wa kabila jako umo.” ");
INSERT INTO cwe_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Bulahimu waitogolela na Efiloni, kamulingila chibugulu cha hela chiyalondile kuno Wahiti wose wolola, shekeli magana mane ya hela, chiyasi cha wachuluzi wa chipindi icho. ");
INSERT INTO cwe_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ivo mgunda wa Efiloni uli uko Makipela habehi na Mamule, tuka dodikalile umo muungunda na mibiki yose ikalile hamwe na mwela wose diwa jake ");
INSERT INTO cwe_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Bulahimu haulongozi wa Wahiti wose wowaiting'hane hana ulwivi wa dibululu. ");
INSERT INTO cwe_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Maabaho Bulahimu kamuwanda Sala muke wake muna dituka ijo dili Makipela habehi na isi ya Mamule, niiyo Hebuloni, muna iisi ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mgunda na tuka dodikalile umo, itogoleka na Wahiti ni hanhu ha Bulahimu ha kuwandila. ");
INSERT INTO cwe_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Bulahimu kakala mulala ng'hani, na Mndewa Mulungu kamtemela mate kwa chila chinhu choyatendile. ");
INSERT INTO cwe_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Bulahimu kamulongela msang'hani wake yoyakalile mulala, iviya ndolezi wa vinhu vake vose, “Nokulamba wike mkono wako hasi ya mawambo yangu, nikulahize. ");
INSERT INTO cwe_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nolonda kukulahiza kwa Mndewa Mulungu, Mulungu wa ulanga na isi, kuwa hwizamsolela mwanangu muke kulawa kwa Wakanaani wonikala nawo. ");
INSERT INTO cwe_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kolondeka uhite kuna isi ija yonyelekiligwe na umsolele muke mwanangu Isaka kulawa mwa ndugu zangu.” ");
INSERT INTO cwe_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ija imsang'hani kamuuza, “Fana imndele hezatogola bule kwiileka kaye na kunisondelela kwiza kuno kwiisi ino, lelo nimgale mwanago kuna isi youlawile?” ");
INSERT INTO cwe_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Bulahimu kamwidika, “Uteganye, sekeumbweleze mwanagu uko! ");
INSERT INTO cwe_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mndewa Mulungu, Mulungu wa ulanga kanigala kulawa kaye ya tati yangu na kulawa isi ya ndugu zangu, kanilongela na kanilahila kuwa kezaweng'ha isi ino welesi wangu. Kezamtuma msenga wake wa kuulanga kuulongozi wako, ivo kwizampatila muke mwanangu kulawa kuna iisi iyo. ");
INSERT INTO cwe_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","One imndele halonda kwiisondelela na weye, basi kwizalekeleligwa chilaho icho. Mbali kwa vovose mwanangu sekeumbweleze uko.” ");
INSERT INTO cwe_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Msang'hani keka mkono wake hasi ya diwambo da Bulahimu mwenevale wake, na kumulahila kwa mbuli iyo. ");
INSERT INTO cwe_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Maabaho msang'hani kasola wanyama wotangigwa ngamiya longo wa Bulahimu, na ndolendole zinogile mbasakanyo, na kahita kuna dibululu da Mesopotamiya mbaka buluu da Naholi. ");
INSERT INTO cwe_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Viyafikile, kawatumbaliza mavindi iwangamiya habehi na disima kunze ya dibululu, ikala ichigulogulo, chipindi wanaake wohita kuna disima kudeha mazi. ");
INSERT INTO cwe_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kampula Mulungu, “Weye Mndewa Mulungu, Mulungu wa mwenevale wangu Bulahimu, diyelo nolonda ufanikiwe na ulaguse ulondo wa kufunya umoyo kwa mwenevale wangu. ");
INSERT INTO cwe_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nahano hamgwazo ha inzasa ya mazi hanhu wandele wakaya wa bululu howokwiza kudeha mazi. ");
INSERT INTO cwe_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ija imndele yondanimulongele yanenule nongo yake ya mazi na kuning'ha ning'we, nayo yahaning'ha ning'we niye na ngamiya wangu, iyo niiyo youmsagulile msang'hani wako Isaka. One ihawa ivo, nizavimanya kulagusa ulondo wako wa kufunya umoyo kwa mwenevale wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Yang'hali hanakomeleza kulonga, Lebeka kafika na kuno kaitwika nongo ya mazi muna diyega jake. Mwana wa chike wa Besueli mwana wa Milika, muke wa Naholi, Naholi ni ndugu wa Bulahimu. ");
INSERT INTO cwe_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mndele iyo kakala lumondo na kakala mhambe yang'ali hanaibandama na mulume yoyose. Ivo kagidimila muna disima, kadeha nongo yake na kalawa. ");
INSERT INTO cwe_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Msang'hani kakimbila himahima kuiting'hana nayo na kalonga, “Nokulamba uning'he mazi ning'we kulawa muna inongo yako.” ");
INSERT INTO cwe_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Imndele kamwidika, “Haya, ing'wa mwenevale,” bahobaho kanenula nongo yake, kayamhilila na kumng'wiza. ");
INSERT INTO cwe_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Viyakomeleze kumwing'ha yamazi, kamulongela, “Iviya nizawadehela mazi ngamiya wako wang'we mbaka ng'hilu imale.” ");
INSERT INTO cwe_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Chahimahima kayaguma yamazi ya inongo yake muna diziga da kung'wila zingamiya, na kakimbila kuna inzasa kudeha mazi yamwenga na kaweng'ha ngamiya wake wose. ");
INSERT INTO cwe_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Msang'hani ija wa Bulahimu halongile mbuli yoyose, mbali kakala yomulola yawone fana Mndewa Mulungu kautemela mate mwanza wake. ");
INSERT INTO cwe_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Viyakomeleze kuweng'ha ngamiya mazi, msang'hani wa Mndewa Mulungu kasola mhete ya zahabu iguligwe hela ng'hulu na kamwing'ha Lebeka, na makung'u maidi ya zahabu yazamile ng'hani, kamvaza muna yamakono yake. ");
INSERT INTO cwe_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kalonga, “Nokulamba unilongele, vino weye tati yako yelihi? Vino muna ikaye ya tati yako muna chiheleto cha kugona?” ");
INSERT INTO cwe_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Lebeka kamwidika, “Tati yangu ni Besueli mwana wa Milika muke wa Naholi. ");
INSERT INTO cwe_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Iviya kumwetu kuna mgina na hanhu ha kuchungila na chiheleto cha kugona.” ");
INSERT INTO cwe_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Maabaho msang'hani wa Bulahimu kainama na katambikila kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Kalonga, “Yatunhizigwe Mndewa Mulungu, Mulungu wa mwenevale wangu Bulahimu niiyo yang'hali hanazimiza ulondo wake wa kufunya umoyo na kwaminika kwake kwa mwenevale wangu. Mndewa Mulungu kanilanguliza mbaka kwa ndugu wa mwenevale wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mndele ija kakimbila kuhita kuna ikaye ya mami yake na kumulongela mbuli zose. ");
INSERT INTO cwe_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Lebeka kakala na lumbu jake yatangigwe Labani, Labani kakimbila kuhita kuna inzasa kuja kuyakalile msang'hani wa Bulahimu. ");
INSERT INTO cwe_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labani viyaiwonile ija imhete na dikung'hu muna yamakono ya mwali wake, na kuzihulika mbuli Lebeka ziyalongiligwe na munhu iyo. Labani kamfika munhu iyo kema habehi na ngamiya wake hamgwazo wa inzasa. ");
INSERT INTO cwe_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labani kamulongela, “Izo. Weye munhu utemeligwe mate na Mndewa Mulungu. Habali kokwima hano hanze? Nisasala chiheleto na hanhu ha kukala ngamiya wako.” ");
INSERT INTO cwe_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Msang'hani iyo wa Bulahimu kengila muikaye, nayo Labani kawafungula iwangamiya wake na kaweng'ha mgina na hanhu ha kugona. Maabaho kamwing'ha mazi ya kuguma nhende yeye na wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Viwamgalile ndiya, msang'hani ija kalonga, “Sizakuja bule mbaka nilonge mbuli yangu.” Labani kamwidika, “Haya longa.” ");
INSERT INTO cwe_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ivo kalonga, “Niye namsang'hani wa Bulahimu. ");
INSERT INTO cwe_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mndewa Mulungu kamtemela mate mwenevale wangu, na kamtenda munhu tajili ng'hani. Kamwing'ha mabumbila ya ng'hondolo na luti na ng'ombe na hela na zahabu, wanaake na walume na watumwa na ngamiya na vihongwe. ");
INSERT INTO cwe_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sala, muke wa mwenevale wangu, viyakalile mulala kamwelekela mwana mwenevale wangu, kamwing'ha mwana iyo vinhu vake vose. ");
INSERT INTO cwe_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mwenevale wangu kanilahiliza kwamha lagilizo jake. Kalonga, ‘Sekeumsolele muke mwanangu kulawa muna iisi ya Kanaani yonikala. ");
INSERT INTO cwe_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mbali hita kwa wanhu wa tati yangu na kwa ndugu zangu umsolele muke mwanangu.’ ");
INSERT INTO cwe_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Na nimuuza mwenevale wangu, ‘One yahalema kwiza na niye?’ ");
INSERT INTO cwe_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Kedika, ‘Mndewa Mulungu, yonimtegeleza siku zose, kezakugalila msenga wa kuulanga na kukutenda ufanikiwe. Kwizamsolela muke mwanangu kulawa muna ikaye ya tati yangu na ndugu zangu. ");
INSERT INTO cwe_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kuna nzila imwe muhala ya kukutenda uilegehe na chilaho chako, one uhahita kwa ndugu zangu na wahakulema, kwizakuwa kuilegeha.’ ");
INSERT INTO cwe_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Diyelo vinifikile hana inzasa, nitosa, ‘Mndewa Mulungu, Mulungu wa mwenevale wangu Bulahimu, unitende nipate choniwinzile muna umwanza wangu. ");
INSERT INTO cwe_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Hano nahana inzasa. One mndele yaheza kudeha mazi, nizampula mazi ya kung'wa kulawa muna inongo yake. ");
INSERT INTO cwe_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Nayo one yahaning'ha na kuwadehela mazi ngamiya wangu, iyo niiyo yasaguligwe na Mndewa Mulungu kuwa muke wa mwana wa mwenevale wangu.’ ");
INSERT INTO cwe_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ning'hali sinakomeleza kutosa muna umoyo wangu, lola! Lebeka kalawilila na nongo yake ya mazi muna diyega, kagidimila muna inzasa na kudeha mazi. Na niye nimpula, ‘Nolamba uning'he mazi ning'we.’ ");
INSERT INTO cwe_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Nayo kanenula nongo yake himahima na kalonga, ‘Haya ing'wa na nizawang'wiza mazi iviya ngamiya wako.’ Ivo niye ning'wa na ngamiya wangu iviya wang'wizigwa. ");
INSERT INTO cwe_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ivo nimuuza mndele iyo, ‘Vino weye tati yako yelihi?’ Nayo kanidika, ‘Tati yangu ni Besueli mwana wa Milika muke wa Naholi.’ Maabaho nimwing'ha mhete ndodo ya kwika muna imhula na kumvaza kung'hu muna yamakono. ");
INSERT INTO cwe_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Niidulika mbaka chihanga chidalisa hasi na kumwing'ha hewela Mndewa Mulungu na Mndewa Mulungu kamtemela mate, Mulungu wa mwenevale wangu Bulahimu, yoyanilongoze vinogile muinzila kumsola mndele ino kwa ichimu cha mwana wa mwenevale wangu. ");
INSERT INTO cwe_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Lelo nilongeleni one mutogola kumtendela mwenevale wangu kwa uwaminika na voilondeka na one siivo longeni, na niye nizavimanya cha kutenda.” ");
INSERT INTO cwe_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Maabaho Labani na Besueli wamwidika, “Mbuli ino ilawa kwa Mndewa Mulungu, cheye chabule cha kukulongela chihile hebu chinogile. ");
INSERT INTO cwe_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lebeka iyo baho, umsole uhite nayo. Yakawe muke wa mwana wa mwenevale wako, fana viya Mndewa Mulungu viyalongile.” ");
INSERT INTO cwe_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Msang'hani wa Bulahimu viyahulike mbuli izo, kainama na kamtambikila Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Msang'hani iyo wa Bulahimu kalava viwalo na via va hela na mahambo ya zahabu na kamgolela Lebeka. Iviya kamgolela ndolendole za hela ng'hulu lumbu jake na mami yake Lebeka. ");
INSERT INTO cwe_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Maabaho msang'hani wa Bulahimu na wanhu wowezile nayo waja wang'wa na wakala na kugona ichilo chose. Viwalamuke imitondo, msang'hani kalonga, “Nilekeni nibwele kwa mwenevale wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mbali lumbu jake Lebeka na mami yake walonga, “Muleke imndele yakale na cheye kwa juma dimwe hebu siku longo, maabaho kodaha kuhita.” ");
INSERT INTO cwe_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mbali msang'hani kawalongela, “Nolamba sekemunikalamize, kwaviya Mndewa Mulungu kautemela mate mwanza wangu kamala, lekeni nibwele kwa mwenevale wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wawo walonga, “Leka chimtange mndele mwenyewo chimuuze.” ");
INSERT INTO cwe_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ivo wamtanga Lebeka na wamuuza, “Kolonda kuhita na munhu ino?” Nayo kedika, “Ona nizahita.” ");
INSERT INTO cwe_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ivo wamuleka Lebeka yahite na msang'hani wa Bulahimu na wanhu wake. Iviya waisondelela na yaya wa Lebeka. ");
INSERT INTO cwe_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wamtemela mate Lebeka kwa mbuli ino, “Weye mwali wetu uwe mama wa wanhu wengi ng'hani! Welesi wako wasole mabululu ya wehi wawo!” ");
INSERT INTO cwe_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Maabaho Lebeka na wasang'hani wake wa chike waisasala na wakwela ngamiya na kumsondelela iyo imsang'hani wa Bulahimu, nawo wose wasegela. ");
INSERT INTO cwe_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Lusita ulo Isaka kakala kasegela uko Beeli laha iloi, kakala kokala ubanzi wa Negebu. ");
INSERT INTO cwe_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ichigulogulo Isaka kasegela na kahita kumgunda kugesa na kawona ngamiya wokwiza. ");
INSERT INTO cwe_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Lebeka viyamuwone Isaka, kahumuluka muna ingamiya wake ");
INSERT INTO cwe_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","na kamuuza msang'hani wa Bulahimu, “Munhu ija yelihi yogenda mumgunda yokwiza kuchihowela?” Msang'hani kamwidika, “Ni mwenevale wangu.” Maabaho Lebeka kasola chitambala kaigubika ichihanga. ");
INSERT INTO cwe_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Msang'hani wa Bulahimu kamulongela Isaka chila chinhu choyatendile. ");
INSERT INTO cwe_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Maabaho Isaka kamsola Lebeka mbaka muna ihema da Sala mami yake, na kawa muke wake. Isaka kamulonda Lebeka yoyamsangalaze viyadanganike mami yake. ");
INSERT INTO cwe_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Bulahimu kasola muke imwenga, zina jake Ketula. ");
INSERT INTO cwe_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Muke iyo kamwelekela Bulahimu Zimulani na Yakishani na Medani na Midiani na Ishibaki na Shuwa. ");
INSERT INTO cwe_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yakishani kamweleka Sheba na Dedani, wana wa Dedani ni Waashulu na Waletusi na Waleumi. ");
INSERT INTO cwe_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wana wa Midiani wakala Efa na Efeli na Henoki na Abida na Elidawa. Wose wawo wakala welesi wa Ketula. ");
INSERT INTO cwe_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Bulahimu kamwing'ha Isaka vinhu vake vose, ");
INSERT INTO cwe_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","mbali wana wa watumwa wake wakalile fana wanaake zake wowamwelekele wana kawagolela ndolendole viyakalile yang'hali hanadanganika, kawagala kuna iisi ya ulawilo wa zuwa, kutali na mwanage Isaka. ");
INSERT INTO cwe_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Bulahimu viyadanganike kakala na miyaka gana na malongo saba na tano. ");
INSERT INTO cwe_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Bulahimu kadanganika mulala ng'hani na kakala na deng'ho, kahita kuilumba na wasaho zake. ");
INSERT INTO cwe_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Wanage, Isaka na Ishumaili wamuwanda umo muna dituka da Makipela ulawilo wa zuwa wa Mamule mumgunda woukale wa Efiloni, mwana wa Sohali Muhiti. ");
INSERT INTO cwe_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Bulahimu na Sala muke wake wawandigwa kuna umgunda uja Bulahimu uyagulile kwa Wahiti. ");
INSERT INTO cwe_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Viifosile ifa ya Bulahimu, Mulungu kamtemela mate Isaka mwana wa Bulahimu, yoyokalile kakala habehi na disima da Beeli laha iloi. ");
INSERT INTO cwe_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Uno uwo ludongo lwa welesi wa Ishumaili mwana wa Bulahimu yoyelekigwe na Hajili Mmisili, yoyakalile msang'hani wa chike wa Sala. ");
INSERT INTO cwe_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Yano yayo yamazina ya wana wa Ishumaili kwa kusondelela kwelekigwa kwawo, chaudele wa Ishumaili ni Nebayoti na wamwenga ni Kedali na Abideli na Mibisamu ");
INSERT INTO cwe_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","na Mishima na Duma na Masa ");
INSERT INTO cwe_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","na Hadadi na Tema na Yetuli na Nafishi na Kedema. ");
INSERT INTO cwe_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wano ni wana wa Ishumaili, wowakalile walangulizi wa makabila longo na waidi. Ukazi na vibululu vawo vimanyika kwa mazina yawo. ");
INSERT INTO cwe_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishumaili viyadanganike kakala na miyaka gana na malongo matatu na saba, kahita kuiting'hana na wasaho zake. ");
INSERT INTO cwe_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Welesi wa Ishumaili wakala hagati ya Havila na Shuli, habehi na Misili mwiinzila ya kuhita Ashulu. Wakala kwa kuigola na welesi umwenga za Bulahimu. ");
INSERT INTO cwe_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Uno ulo ludongo lwa welesi wa Isaka mwana wa Bulahimu. Bulahimu kamweleka Isaka ");
INSERT INTO cwe_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka kakala na miyaka malongo mane viyamsolile Lebeka mwana wa Besueli, Mwalamu wa Padani Alamu. Lebeka kakala lumbu wa Labani. ");
INSERT INTO cwe_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Lebeka kakala halela, ivo Isaka kampula Mndewa Mulungu, nayo Mndewa Mulungu kamwidika chiyapulile, ivo Lebeka kapata wimo. ");
INSERT INTO cwe_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Wimo uwo ukala na mambasa, wana wawo waihuma muinda ya Lebeka. Nayo kalonga, “Chino choni chochinilawilila?” Ivo kahita kumuuza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mndewa Mulungu kamulongela Lebeka, “Muinda yako muna makabila maidi, Makabila maidi yondayelekigwe na weye yezaigola. Dimwe dizakuwa na nguvu kufosa dimwenga; Imkulu kezamsang'hanila imdodo.” ");
INSERT INTO cwe_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Lusita lwake lwa kuvumbula vilufikile, kavumbula mambasa. ");
INSERT INTO cwe_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Chaudele kelekigwa na mbende ndung'hu na lukuli lwake lose lukala fana walo dili na mazoya, ivo zina jake kamtanga Esau. ");
INSERT INTO cwe_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Wekaidi kavumbuka kuno kamhilila chisiginho cha Esau, ivo zina jake katangigwa Yakobo. Esau na Yakobo viwavumbuke Isaka kakala na miyaka malongo sita. ");
INSERT INTO cwe_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Wana wawo wakula. Esau kakala mkala, yoyolonda kukala muna ivyuwala, na Yakobo kakala yaholile yolonda kukala hakaye. ");
INSERT INTO cwe_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Mbali Isaka kamulonda Esau, kwaviya kanogelwa kuja wanyama woyawakomile Esau, mbali Lebeka kamulonda Yakobo. ");
INSERT INTO cwe_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Siku dimwe Yakobo kakala yokwambika ndiya, Esau keza kulawa kuukala kuno kana nzala, ");
INSERT INTO cwe_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ivo kamulongela Yakobo, “Nina nzala ng'hani, nokulamba uning'he ndiya iyo indung'hu.” Lekamana Esau katangigwa Edomu fambulo jake ndung'hu. ");
INSERT INTO cwe_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo kamwidika, “Nizakwing'ha one uhanichuuzila haki ya uchaudele wako.” ");
INSERT INTO cwe_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau kamulongela, “Vinoga! Nahabehi kudanganika. Haki yonifaya choni?” ");
INSERT INTO cwe_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo kamwidika, “Teng'hu ilahile kuwa kwizanichuluzila haki yako.” Esau kailaha na kamwing'ha Yakobo haki yake. ");
INSERT INTO cwe_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Maabaho Yakobo kamwing'ha gate na nzugu. Kaja na kang'wa na maabaho kenuka na kasegela. Ivo niivo Esau viyaizehile haki yake ya uchaudele. ");
INSERT INTO cwe_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Maabaho kulawilila nzala muna iisi, nzala iyo haikalile ija yoikalile lusita lwa Bulahimu. Isaka kahita kwa Abimeleki mfalume wa Wafilisiti, uko Gelali. ");
INSERT INTO cwe_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mndewa Mulungu kamulawilila Isaka na kamulongela, “Sekeuhite Misili, mbali kala muna iisi iyo mbaka vondanikulongele. ");
INSERT INTO cwe_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kala hano, na niye nizakuwa na weye na nizakutemela mate. Nizakwing'ha zisi zino zose kuwa zako na welesi wako. Nizakwika goya chilagano choniilahile na tati yako Bulahimu. ");
INSERT INTO cwe_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nizakwing'ha welesi mwingi fana viya nhondo zili kuulanga na kuweng'ha zisi zino zose. Kufosela welesi wako wanhu wa makabila yose wezatemeligwa mate. ");
INSERT INTO cwe_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nizakutemela mate kwaviya Bulahimu kanitegeleza na kamha malagilizo yangu na ndagilizi zangu.” ");
INSERT INTO cwe_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ivo Isaka kakala uko Gelali. ");
INSERT INTO cwe_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Wanhu wa uko viwamuuzile mbuli za muke wake, Isaka kawedika kuwa iyo ni lumbu jake. Kwaviya kadumba kulonga iyo ni muke wake mana kadumba wanhu wa uko sekewamkome kwa ichimu cha Lebeka, yoyakalile lumondo. ");
INSERT INTO cwe_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaka viyakalile uko kwa lusita lutali, Abimeleki mfalume wa Wafilisiti kasungulila muna dizonzo na kamuwona Isaka kamuhagatila Lebeka. ");
INSERT INTO cwe_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki katuma usenga kwa Isaka na kalonga, “Humbe iyo ni muke wako! Habali kulonga ni lumbu jako?” Isaka kedika, “Nigesa one nilongile kuwa ni muke wangu, nihakomigwe.” ");
INSERT INTO cwe_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki kalonga, “Kuchitendela choni?” “Imwe wa wanhu wangu one yambandame muke wako, weye uhachitendile chihasanye.” ");
INSERT INTO cwe_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimeleki kawazuma wanhu wose, “Munhu yoyose yondayamdalise munhu ino hebu muke wake kolondeka yakomigwe.” ");
INSERT INTO cwe_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaka kahanda mbeyu muna iisi ija, na mwaka uwo kagobola ng'hani kwaviya Mndewa Mulungu kamtemela mate. ");
INSERT INTO cwe_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaka kawa tajili na utajili wake ugendelela kongezeka mbaka kawa tajili ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Isaka kawa na mabumbila ya ng'hondolo na ng'ombe na wasang'hani wengi mbaka Wafilisiti wamuwonela migongo. ");
INSERT INTO cwe_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Wafilisiti wazisiliza nzasa zose zozihimbigwe na wasang'hani wa Bulahimu tati yake, lusita Bulahimu viyakalile yang'hali mgima. ");
INSERT INTO cwe_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleki kamulongela Isaka, “Segela muna iisi yetu, mana weye kuna nguvu ng'hani kufosa cheye.” ");
INSERT INTO cwe_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ivo Isaka kasegela uko na kazenga lago jake muna dizanda da Gelali, na kakala uko. ");
INSERT INTO cwe_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka kahimba kaidi masima yaja yahimbigwe na Bulahimu tati yake viyakalile mgima. Masima yaja yasilizigwa na Wafilisiti lusita Bulahimu viyadanganike. Isaka kayagolela mazina yaja yaja yoyayatangile tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Wasang'hani wa Isaka wahimba chisima muna dizanda na wafika sima da mazi ya ugima. ");
INSERT INTO cwe_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Wadimi wa kuja Gelali wagomba na wadimi wa Isaka na walonga, “Mazi yano yetu.” Ivo Isaka kachitanga chisima icho “Eseki,” fambulo jake “Ndwagi” ");
INSERT INTO cwe_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Wasang'hani wa Isaka wahimba chisima chimwenga, icho nacho wachigombela, ivo Isaka kachitanga chisima icho “Sitina,” fambulo jake “Kulema”. ");
INSERT INTO cwe_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Maabaho kasegela hanhu baho na kahimba chisima chimwenga. Baho hahakalile na ndwagi, ivo kachitanga zina “Lehobosi”. Kalonga, “Lelo Mndewa Mulungu kaching'ha ulegeho wa kukala muna isi, na chizakala hano na kongezeka.” ");
INSERT INTO cwe_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaka kasegela na kahita Belisheba. ");
INSERT INTO cwe_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Chilo icho Mndewa Mulungu kamulawila na kamulongela, “Niye ni Mulungu wa tati yako Bulahimu. Nahamwe na weye, sekeudumbe. Nizakutemela mate na kukongeza welesi mwingi kwa ichimu cha msang'hani wangu Bulahimu.” ");
INSERT INTO cwe_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaka kazenga lupango uko na kamtambikila Mndewa Mulungu. Uko kasimika hema na wasang'hani wake wahimba sima uko. ");
INSERT INTO cwe_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki keza kulawa Gelali hamwe na Ahuzati, mbwiyake ng'hani, na Fikoli mkulu wa wakalizi wake, kumulola Isaka. ");
INSERT INTO cwe_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ivo Isaka kawauza, “Habali mwiza kumwangu kunilola, na kuno munihila na muniwinga muna iisi yenu?” ");
INSERT INTO cwe_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wawo wamwidika, “Lelo chovimanya Mndewa Mulungu kahamwe na weye. Ivo chiitogolela yofaya chiilahile na kutenda lagano na weye, ");
INSERT INTO cwe_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kuwa weye hwizachilumiza na cheye iviya hachizakulumiza weye. Chikutendela yanogile na chikuleka usegele kwa tindiwalo na sambi weye kutemeligwa mate na Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaka kawasasalila ndiya ya dugila, nawo waja na wang'wa. ");
INSERT INTO cwe_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Igolo yake imitondo ng'hani, chila munhu keka lagano jake kwa kwiilaha. Maabaho Isaka kawalaga mbwiya zake na waileka kwa tindiwalo. ");
INSERT INTO cwe_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Siku ija wasang'hani wa Isaka wamwizila na wamulongela mbuli ya chisima chowachihimbile. Wamulongela, “Chiyafika mazi.” ");
INSERT INTO cwe_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaka kachitanga chisima icho “Siba,” fambulo jake “Chilaho.” Ivo bululu ijo dotangigwa Belisheba mbaka diyelo. ");
INSERT INTO cwe_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau viyawile na miyaka malongo mane, kasola wanaake waidi Wahiti, Yudisi mwana wa Beeli na Basemati mwana wa Eloni. ");
INSERT INTO cwe_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Wanaake wawo wawatenda Isaka na Lebeka wakale kwa usungu. ");
INSERT INTO cwe_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka viyakalile mulala meso yake yawa hayalola bule. Ivo kamtanga Esau mwanage chaudele na kamulongela, “Mwanangu!” Nayo kamwidika, “Aino hano.” ");
INSERT INTO cwe_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka kalonga, “Lola niye namulala, na siku yangu ya kudanganika siimanyile bule. ");
INSERT INTO cwe_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sola msale na upinde wako na uhite kumbago na ukanisakile mnyama wa mwiimbago kwa ichimu changu. ");
INSERT INTO cwe_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Nyambikile ndiya inogile ija yoniilonda, na unigalile. Nahamala kuja, niye mwenyewo nizakutemelela mate ning'hali sinadanganika.” ");
INSERT INTO cwe_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Humbe Isaka viyakalile kolonga na Esau, Lebeka kakala yotegeleza. Ivo Esau viyahitile kusaka kwiimbago, ");
INSERT INTO cwe_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lebeka kamulongela Yakobo, “Nimuhulika tati yako viyamulongele sekulu wako Esau, ");
INSERT INTO cwe_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Nigalile mnyama na unyambikile ndiya inogile. Nahakomeleza kuja nizakutemela mate haulongozi wa Mndewa Mulungu ning'hali sinadanganika.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Lebeka kagendelela kulonga, “Lelo mwanangu, nitegeleze na utende chinikulongela. ");
INSERT INTO cwe_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Hita kuna dibumbila da iwaluti unigalile wanaluti waidi wanogile muladi nimwambikile tati yako ndiya inogile yoyailondaga ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Na kwizamgalila tati yako yaje muladi yakutemele mate yang'hali hanadanganika.” ");
INSERT INTO cwe_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mbali Yakobo kamulongela Lebeka mami yake, “Kuvimanya kuwa sekulu wangu Esau ni munhu mwene upipi, mbali niye nabule. ");
INSERT INTO cwe_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Yodahika tati yangu kezalonda kunibabasa, na niye nizawoneka fana viya nomvwizila, kwa ivo nizaigalila duwilo badala ya kutemeligwa mate.” ");
INSERT INTO cwe_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mami yake kamulongela, “Duwilo jako dimhate niye, mbali weye mwanangu tenda fana viya vinikulagiliza, na hita ukanigalile wanaluti.” ");
INSERT INTO cwe_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ivo Yakobo kahita na kawasola iwanaluti waidi na kamgalila mami yake, nayo kasasala ndiya inogile yoyailondile tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Maabaho Lebeka kalava viwalo vinogile va Esau mwanage imkulu, voyavikile muna ikaye, na kamuyawaliza Yakobo mwanage imdodo. ");
INSERT INTO cwe_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Iviya kamuyawaliza mbende za iwanaluti waja mmakono na muna ulukuli lutelebuke ulibule upipi muna isingo yake. ");
INSERT INTO cwe_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Lebeka kamwing'ha Yakobo indiya inogile, hamwe na diya digate doyadisasale. ");
INSERT INTO cwe_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Maabaho Yakobo kahita kwa tati yake na kamtanga, “Tata!” Nayo kedika, “Aino.” Tati yake kamuuza, “Weye mwanangu yelihi?” ");
INSERT INTO cwe_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo kamwidika, “Niye Esau chaudele wako. Nisang'hana fana viunilagilize. Nolamba tata ukale uje nyama yonikugalile, muladi udahe kunitemela mate.” ");
INSERT INTO cwe_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka kamuuza, “Mwanangu iwaze kupata himahima fanile ivo?” Yakobo kamwidika, “Mndewa Mulungu, Mulungu wako kanitaza kupata ivo.” ");
INSERT INTO cwe_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaka kamulongela Yakobo, “Mwanangu kwenhuka haguhi nidahe kukubabasa muladi nivimanye fana kweli weye kwa Esau mwanangu hebu siyo.” ");
INSERT INTO cwe_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo kamkwenhukila tati yake, nayo kambabasa na kalonga, “Dizi jako dohulikika fana viya dizi da Yakobo, mbali makono yalinga fana makono ya Esau.” ");
INSERT INTO cwe_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaka hammanyile Yakobo kwaviya makono yake yakala na upipi fana Esau. Ivo kakala kokwandusa kumtemela mate. ");
INSERT INTO cwe_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Mbali kamuuza kaidi, “Weye kweli mwanangu Esau?” Yakobo kamwidika, “Iyo niye.” ");
INSERT INTO cwe_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaka kalonga, “Nigalile nyama muladi nije na kukutemela mate.” Yakobo kamgalila na kaja, nayo iviya kamgalila divai kang'wa. ");
INSERT INTO cwe_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Maabaho Isaka tati yake kamulongela, “Mwanangu, nikwenhukile uninonele.” ");
INSERT INTO cwe_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakobo kamkwenhukila na kamnonela, Isaka viyahulike mnung'ho wa viwalo vake, kamtemela mate na kalonga, “Lola mnung'ho wa mwanangu ulinga fana mnung'ho wa mgunda woutemeligwe mate na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mulungu yakwing'he mvula kulawa kuulanga na yakwing'he ulongo unogile ulava nafaka na divai nyingi. ");
INSERT INTO cwe_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Makabila yose wezakusang'hanila, na wezakutumbalila mavindi, kwizakuwa mulangulizi wa wandugu zako wose na welesi wa mami yako wakutumbalile mavindi, wanhu wokuduwila weye waduwiligwe na wokutemela mate wezatemeligwa mate.” ");
INSERT INTO cwe_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaka viyakomeleze kumtemela mate Yakobo, lusita Yakobo viyasegele, Esau sekulu wake kabwela kulawa kuukala. ");
INSERT INTO cwe_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Iviya Esau kambika ndiya inogile na kamgalila tati yake. Kamulongela, “Haya tata, kala uje nyama yonikugalile, muladi udahe kunitemela mate.” ");
INSERT INTO cwe_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka kamuuza, “Weye kwa yelihi?” Nayo kamwidika, “Niye niiyo Esau mwanago chaudele.” ");
INSERT INTO cwe_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaka kagudemeka ng'hani na kalonga, “Humbe yelihi yoyalawile kuukala na kanigalila nyama, na niye nija yose nimala ung'hali hunakwiza? Iviya nimtemela mate nimala, ivo katemeligwa mate kamala!” ");
INSERT INTO cwe_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau viyahulike ivo kalila kwa dizi kulu na giyogiyo ng'hani na kalonga, “Tata, na niye iviya nitemele mate!” ");
INSERT INTO cwe_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Mbali Isaka kamwidika, “Mdodo wako kanizila na kunivwizila. Na kasola kutemeligwa mate kwako.” ");
INSERT INTO cwe_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau kalonga, “Lekamana kotangigwa Yakobo kwaviya kanivwizila miyanza midi. Mosi kasola haki yangu ya uchaudele, maabaho kasola kutemeligwa mate kwangu.” Esau kalonga, “Hunisigazile kutemeligwa mate kwangu?” ");
INSERT INTO cwe_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka kamwidika Esau, “Nimala kumtenda Yakobo kuwa mulangulizi wako na nimwing'ha ndugu zake wose kuwa wasang'hani wake. Nimpatila nafaka na divai. Lelo nikutendele choni weye mwanagu?” ");
INSERT INTO cwe_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau kamulongela tati yake, “Kodaha kutemela mate mwanza umwe muhala tati yangu? Tati yangu na niye iviya nhemele mate!” Kandusa kulandula dizi na kalila. ");
INSERT INTO cwe_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Maabaho Isaka tati yake kamwidika, “Kwizakala kutali na mgunda unogile ulava nafaka na divai nyingi na kutali na mvula ya kuulanga. ");
INSERT INTO cwe_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kwizakala kwa kuwakoma wanhu kwa sengo, Kwizamsang'hanila ndugu yako. Mbali uhalema, kwizatenda voulonda mwenyewo.” ");
INSERT INTO cwe_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau kamwihila Yakobo kwa ichimu cha kutemeligwa mate koyatemeligwe na tati yake. Kagesa, “Siku za matanga ya tata zaabehi, zihamala nizamkoma mdodo wangu Yakobo.” ");
INSERT INTO cwe_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mbali Lebeka viyavimanyile chiyailungile Esau, kamtumila usenga kumtanga Yakobo na kalonga, “Wiiteganye, sekulu wako Esau koiguma moyo kwa kulonda kukukoma. ");
INSERT INTO cwe_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Lelo mwanangu tegeleza chonikulongela na uchitende. Hima kimbilila kwa lumbu jangu Labani uko Halani, ");
INSERT INTO cwe_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","kala nayo kwa lusita, mbaka ludoko lwa sekulu wako luhunguke. ");
INSERT INTO cwe_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ludoko lwa sekulu wako vondaluhunguke na vondayazimize youmtendele, nizamtuma munhu yakubweleze. Habali nidanganikiligwe na mweye wose waidi siku dimwe?” ");
INSERT INTO cwe_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebeka kamulongela Isaka, “Niye ndegezigwa na wanaake wano Wahiti wa Esau. One Yakobo iviya yahasola muke kulawa mwa wanaake wano Wahiti, muhavu nidanganike.” ");
INSERT INTO cwe_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaka kamtanga Yakobo, kamtemela mate na kamulongela, “Sekeusole mwanamke yoyose Mkanaani. ");
INSERT INTO cwe_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hita kuna iisi ya Padani Alamu, muna ikaye ya wasaho yako Besueli, na ukasole imwe wa wana wa mtumba wako Labani. ");
INSERT INTO cwe_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mulungu mwene Udaho yaitemele mate sola yako na yakwing'he wana wengi, ivo kwizakuwa tata wa makabila mengi. ");
INSERT INTO cwe_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Yakutemele mate weye na welesi wako fana viya viyamtemele mate Bulahimu muladi udahe kuhazi isi ino youkala fana nyambenyambe, Mulungu yoyamwing'hile Bulahimu!” ");
INSERT INTO cwe_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaka kamtuma Yakobo yahite kwiisi ya Padani Alamu kwa Labani, yoyelekigwe na Besueli, Mwalamu, Labani lumbu jake Lebeka yeli mami yawo Yakobo na Esau. ");
INSERT INTO cwe_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau kavimanya kuwa Isaka kamala kumtemela mate Yakobo na kumtuma yahite Padani Alamu yakasole muke. Iviya kavimanya kuwa Isaka viyamtemele mate, kamulongela sekeyasole muke Mkanaani. ");
INSERT INTO cwe_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Kavimanya kuwa Yakobo kawategeleza tati yake na mami yake na kahita Padani Alamu. ");
INSERT INTO cwe_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau kavimanya kuwa Isaka tati yake hanogeligwa bule na wanaake wa Kanaani. ");
INSERT INTO cwe_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esau kahita kwa Ishumaili mwana wa Bulahimu na kamsola muke imwenga yotangigwa Mahalati, lumbu jake Nebayoti. ");
INSERT INTO cwe_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo kasegela Belisheba na kuhita Halani. ");
INSERT INTO cwe_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kafika hanhu hamwe ha kugona chilo chimwe kwaviya zuwa dikala diswa. Kasola dibwe dimwe da hanhu baho kadika hasi ya iditwi jake, kagona. ");
INSERT INTO cwe_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kalota kuwa kawona vidando vimizigwa kulawa muna iisi mbaka kuulanga, wasenga wa kuulanga wokwela na kuhumuluka hasi kwa ividando ivo. ");
INSERT INTO cwe_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mndewa Mulungu kema habehi nayo kamulongela, “Niye niiyo Mndewa Mulungu, Mulungu wa tati yako Bulahimu na Isaka,” kalonga, “Nizakwing'ha weye na welesi wako isi ino yuwiigonela. ");
INSERT INTO cwe_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Welesi wako wizakuwa mwingi fana msanga wa isi. Wezakwenela chila hanhu, ulawilo wa zuwa na uswelo wa zuwa, kasikazi na kusi. Kufosela weye na welesi wako wanhu wose wezatemeligwa mate. ");
INSERT INTO cwe_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Niye nahamwe na weye na kukukaliza hohose houhita, na nizakubweleza muna iisi ino. Sizakuleka mbaka vondanikutendele yose yonikulaganile.” ");
INSERT INTO cwe_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo kalamka na kalonga, “Kweli Mndewa Mulungu ka hanhu hano, niye sivimanyile bule!” ");
INSERT INTO cwe_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nayo kadumba na kalonga, “Hanhu hano hodumbiza ng'hani! Kweli ni kaye ya Mulungu na lwivi lwa kuulanga.” ");
INSERT INTO cwe_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Igolo yake imitondo ng'hani Yakobo kalamuka, kasola idibwe dodikalile hasi ya ditwi jake, kadisimika fana mhanda ya ukumbuso na kudigidila mavuta. ");
INSERT INTO cwe_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Kahatanga hanhu baho Beseli. Umwaka bululu ijo ditangigwa Luzu. ");
INSERT INTO cwe_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Maabaho Yakobo kailaha kwa Mndewa Mulungu, “One wahawa hamwe na niye, na kunikaliza muna umwanza wangu na kuning'ha ndiya na viwalo, ");
INSERT INTO cwe_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na one nahabwela vinogile kuna ikaye ya tati yangu, ivo Mndewa Mulungu kwizakuwa Mulungu wangu. ");
INSERT INTO cwe_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Dibwe dino donidisimike hano fana mhanda ya ukumbuso, dizakuwa kaye ya Mulungu, na niye nizakwing'ha chinhu chimwe muna ichila vinhu longo vondauning'he.” ");
INSERT INTO cwe_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobo kagendelela na mwanza wake na kafika muna iisi ya ulawilo wa zuwa. ");
INSERT INTO cwe_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kalola na kawona chisima mwiichuwala na mumgwazo yake mabumbila matatu ya ng'hondolo wagona. Ng'hondolo wakala wong'wizigwa muna ichisima icho chochigubikigwe na dibwe kulu. ");
INSERT INTO cwe_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mabumbila yose ya ng'hondolo yahaiduganya, wadimaji wobimbilisa idibwe ijo kwa hamwe kulawa hana ichisima na kuwang'wiza iwang'hondolo. Maabaho wogubika kaidi ichisima kwa dibwe ijo. ");
INSERT INTO cwe_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo kawauza waja iwadimi, “Wambwiya zangu, mweye mulawa kulihi?” Wamwidika, “Cholawa Halani.” ");
INSERT INTO cwe_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kawauza kaidi, “Vino mummanya Labani mwana wa Naholi?” Wamwidika, “Ona chimmanya.” ");
INSERT INTO cwe_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakobo kagendelela kuwauza, “Vino mgima?” Nawo wamwidika, “Mgima! Lola mndele wake Laheli iyo ija kokwiza na ng'hondolo zake.” ");
INSERT INTO cwe_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobo kalonga, “Nowona ing'hali misi na siyo lusita lwa kuwaduganya ng'hondolo hamwe, ivo wang'wizeni mazi muhite mukawadime.” ");
INSERT INTO cwe_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nawo wamwidika, “Hachidaha bule mbaka ng'hondolo wose wawe hano, na dibwe dibimbiliswe mwiichisima, maabaho chowang'wiza mazi ng'hondolo.” ");
INSERT INTO cwe_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobo viyakalile yang'hali kolonga nawo, Laheli yakalile mdimi wa ng'hondolo, kafika na ng'hondolo wa tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo viyamuwone Laheli mndele wa mtumba wake Labani hamwe na zing'hondolo, kahita hana disima na kudibimbilisa idibwe kulawa hana disima na kuwang'wiza mazi iwang'hondolo wa mtumba wake. ");
INSERT INTO cwe_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Maabaho Yakobo kamnonela Laheli na kandusa kulila kwaviya kakala na deng'ho. ");
INSERT INTO cwe_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobo kamulongela Laheli, “Niye ni ndugu wa tati yako, na mwana wa Lebeka.” Maabaho Laheli kakimbila kumulongela tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani viyahulike mbuli ya Yakobo mwihwage, kahita yokimbila kumuhowela, viyamfikile kamuhagatila na kamnonela na kamkalibisha ukaye yake. Yakobo kamulongela mbuli zose zozilawilile. ");
INSERT INTO cwe_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labani kalonga, “Ivo weye ni lukuli lumwe na damu imwe na niye.” Yakobo kakala na Labani mwezi umwe. ");
INSERT INTO cwe_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani kamulongela Yakobo, “Weye kwa ndugu yangu hudaha kunisang'hanila bila kukuliha. Lelo nikulihe hela nyingahi?” ");
INSERT INTO cwe_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labani kakala na wandele waidi, imkulu zina jake Leya na imdodo Laheli. ");
INSERT INTO cwe_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya kakalayanogile, mbali Laheli kakala lumondo ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo kamulonda Laheli, ivo kamulongela Labani, “Nizakusang'hanila miyaka saba, one uhanitogolela kumsola Laheli.” ");
INSERT INTO cwe_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani kamwidika, “Muhavu nikwing'he weye Laheli sembuse kumwing'ha munhu imwenga yoyose. Gendelela kukala hano na niye.” ");
INSERT INTO cwe_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakobo kamsang'hanila Labani miyaka saba muladi yampate Laheli, mbali kumwake miyaka saba ni fana viya siku ndodo, kwaviya kamulonda Laheli. ");
INSERT INTO cwe_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Maabaho Yakobo kamulongela Labani, “Lusita lwangu lufika, ning'he muke wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ivo Labani kasasala dugila na kawagoneka wanhu wose wa hanhu haja. ");
INSERT INTO cwe_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mbali viifikile ichigulogulo, Labani kamulava Leya mwanage imkulu na kumgala kwa Yakobo, nayo Yakobo kagona nayo. ");
INSERT INTO cwe_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani kamwing'ha Zilipa mtumwa wake wa chike yawe mtumwa wa Leya mwanage. ");
INSERT INTO cwe_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Igolo yake imitondo, Yakobo katola kuwa ni Leya. Kamgendela Labani na kamuuza, “Choni chino chounhendele? Nikusang'hanila muladi nimpate Laheli. Habali kunivwizila?” ");
INSERT INTO cwe_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani kamwidika, “Chino siyo chihendo chetu kusoligwa imndele imdodo kuno imkulu yang'ali hanasoligwa. ");
INSERT INTO cwe_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Gozela mbaka siku saba za dugila, maabaho nizakwing'ha Laheli kwa usang'hano wa miyaka saba imwenga.” ");
INSERT INTO cwe_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo katogola, viifikile juma da dugila, Labani kamwing'ha Laheli mwanage yawe muke wake. ");
INSERT INTO cwe_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani kamulava Biliha mtumwa wake wa chike, yawe mtumwa wa Laheli. ");
INSERT INTO cwe_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakobo kagona na Laheli iviya, na Yakobo kamulonda kufosa Leya. Maabaho Yakobo kamsang'hanila Labani miyaka saba imwenga. ");
INSERT INTO cwe_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mndewa Mulungu kawona kuwa Leya halondigwa goya, ivo kamtenda yeleke, mbali Laheli heleke bule. ");
INSERT INTO cwe_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya kapata wimo na kaibasula mwana wa chilume na kamtanga zina jake Lubeni kwa viya kalonga, 'Mwana aino'. Leya kalonga, “Mndewa Mulungu kawona manhesa yangu na lelo mulume wangu kezanilonda.” ");
INSERT INTO cwe_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Maabaho kapata wimo kaidi na kaibasula mwana imwenga wa chilume. Kalonga, “Mndewa Mulungu kahulika kuwa nokwihilwa.” Ivo Leya kamtanga zina jake Simeoni. ");
INSERT INTO cwe_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leya kapata wimo kaidi na kaibasula mwana imwenga wa chilume, nayo kamtanga zina jake Lawi. Leya kalonga, “Lelo mulume wangu kezailumba vinogile na niye, kwaviya nimwelekela wana wa chilume watatu.” ");
INSERT INTO cwe_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Maabaho kapata wimo kaidi na kaibasula mwana imwenga wa chilume na kalonga, “Lusita luno nizamtogoza Mndewa Mulungu.” Kamtanga zina jake Yuda, maabaho Leya kaleka kweleka. ");
INSERT INTO cwe_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mbali Laheli hamwelekele Yakobo wana wowose, na ivo kamuwonela migongo mwali wake na kamulongela Yakobo, “Ning'he wana, buleivo nizadanganika.” ");
INSERT INTO cwe_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo kamuwonela ludoko Laheli na kalonga, “Sidaha kusola hanhu ha Mulungu. Yeye muhala niiyo yakukimilile weye sekeupate wana.” ");
INSERT INTO cwe_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Laheli kamulongela, “Ino hano mtumwa wangu Biliha, ibandame nayo muladi yapate wana kwa ichimu changu. Ivo nizakuwa mama kufosela yeye.” ");
INSERT INTO cwe_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Laheli kamwing'ha mulumake Yakobo mtumwa wake Biliha yawe fana muke wake, nayo Yakobo kambandama. ");
INSERT INTO cwe_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha kapata wimo na kamwelekela Yakobo mwana wa chilume. ");
INSERT INTO cwe_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Laheli kalonga, “Mulungu kanigombela, kauhulika usungu wangu na kuning'ha mwana wa chilume.” Ivo Laheli kamtanga zina jake Dani. ");
INSERT INTO cwe_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha mtumwa wake wa chike kapata wimo kaidi na kamwelekela Yakobo mwana imwenga wa chilume. ");
INSERT INTO cwe_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Laheli kalonga, “Nikala na ugomvi mkulu na mwali wangu, mbali nihuma.” Ivo kamtanga mwana iyo Nafutali. ");
INSERT INTO cwe_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leya viyawonile kuwa kaleka kulela, kamsola Zilipa mtumwa wake wa chike na kamwing'ha Yakobo yawe fana muke wake. ");
INSERT INTO cwe_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Maabaho Zilipa kamwelekela Yakobo mwana wa chilume. ");
INSERT INTO cwe_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya kalonga, “Nipata sudi,” ivo kamtanga zina jake Gadi. ");
INSERT INTO cwe_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilipa mtumwa wake wa Leya kamwelekela Yakobo mwana imwenga wa chilume, ");
INSERT INTO cwe_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya kalonga, “Nodeng'helela! Lelo wanaake wezalonga kuwa kanadeng'ho” Kamtanga zina jake Asheli. ");
INSERT INTO cwe_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Lusita lwa kuhuna ngano, Lubeni kahita kuchuwala, uko kapata makalanga na kamgalila Leya mami yake. Laheli kamulongela Leya, “Nopula uning'he makalanga yamwenga ya mwanago.” ");
INSERT INTO cwe_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya kamwidika, “Vino kogesa mbuli ndodo kunihoka mulumangu? Lelo kolonda kusola makalanga ya mwanangu.” Laheli kalonga, “One wahaning'ha makalanga ya mwanago, Yakobo kezagona kumwako chilo cha diyelo.” ");
INSERT INTO cwe_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ichigulogulo Yakobo viyakalile kobwela kulawa kuchuwala, Leya kahita kumuhokela na kamulongela, “Chilo cha diyelo uhite kugona kumwangu kwaviya nikwing'ha makalanga ya mwanangu.” Ivo chilo icho kagona nayo. ");
INSERT INTO cwe_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mulungu kahulika nhosa ya Leya, na kapata wimo na kamwelekela Yakobo mwana wetano wa chilume. ");
INSERT INTO cwe_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya kalonga, “Mulungu kaning'ha yombe jangu, kwaviya nimwing'ha mulume wangu msang'hani wangu wa chike”; Ivo kamtanga zina jake Isakali. ");
INSERT INTO cwe_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya kapata wimo kaidi na kamwelekela Yakobo mwana wa sita wa chilume. ");
INSERT INTO cwe_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leya kalonga, “Mulungu kaning'ha chitumetume chinogile. Lelo mulumangu kezanitogola, kwaviya nimwelekela wana sita wa chilume.” Ivo kamtanga zina jake Zabuloni. ");
INSERT INTO cwe_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hamwande Leya kapata mwana wa chike, na kamtanga zina jake Dina. ");
INSERT INTO cwe_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Maabaho Mulungu kamkumbuka Laheli na kahulika chiyapulile, ivo kamtenda yadahe kupata wana. ");
INSERT INTO cwe_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Laheli kapata wimo na kaibasula mwana wa chilume na kalonga, “Mulungu kanisegezela chinyala changu.” ");
INSERT INTO cwe_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kamtanga zina jake Yosefu, kalonga, “Mndewa Mulungu uning'he mwana imwenga.” ");
INSERT INTO cwe_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Laheli viyamweleka Yosefu, Yakobo kamulongela Labani, “Unileke nibwele ukaye yangu. ");
INSERT INTO cwe_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Uning'he wake zangu na wanangu woniwapatile kwa ichimu cha usang'hano wonikusang'hanile, nisegele nawo, kwaviya kuvimanya nikusang'hanila vinogile.” ");
INSERT INTO cwe_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labani kamulongela Yakobo, “Leka na niye nilonge. Niifunza kwa usawi wangu kuwa Mndewa Mulungu kanitemela mate kwa ichimu chako. ");
INSERT INTO cwe_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Longa yombe jako na niye nizakuliha.” ");
INSERT INTO cwe_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo kedika, “Weye mwenyewo kuvimanya viya vinikusang'hanile, kuvimanya viniwekile goya wanyama wako. ");
INSERT INTO cwe_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kwaviya vinizile kukala na vinhu vidodo, mbali kusongela nifike vinhu vako vongezeka ng'hani na Mndewa Mulungu kakutemela mate chila hanhu honihitile. Mbali lelo kaye yangu nizailola goya zuwaki?” ");
INSERT INTO cwe_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani kamuuza, “Nikulihe choni?” Yakobo kamwidika, “Silonda yombe jojose. One chihaitogolela, nizagendelela kwika goya wanyama wako. ");
INSERT INTO cwe_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nilekele nifose hagati ya wanyama wako wose diyelo nigole muna dibumbila chila mnyama yeli na uzegenha na uzolizoli, chila mnyama mtitu na luti weli na uzegenha na uzolizoli. Ijo niijo yombe donilonda. ");
INSERT INTO cwe_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Siku zikwiza, kwaminika kwangu kwizawoneka funhulafunhula vondawize kulola yombe jangu. One yahawoneka luti yoyose yelibule uzegenha hebu uzolizoli, hebu ng'hondolo yoyose heli na utitu muna dibumbila jangu, iyo kezakuwa kabawigwa.” ");
INSERT INTO cwe_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani kedika, “Vinoga. Chizatenda fana viulongile.” ");
INSERT INTO cwe_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mbali siku iyo Labani kahita kayagola mabebelu yose yeli na mindilizi na uzegenha na luti wose mizike wowakalile na uzolizoli na uzegenha, chila luti wowakalile na uzelu muna ulukuli na chila ng'hondolo yeli na utitu, kaweka hasi ya ulolezi wa wanage, ");
INSERT INTO cwe_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Maabaho Bumbila da Labani dikala kutali na bumbila da Yakobo kwa siku nhatu. Yakobo kadilolesa bumbila da wanyama wa Labani dodisigale. ");
INSERT INTO cwe_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakobo kasola mango mbisi za mibiki mitatu mbasakanyo, kazigomola yamagome muladi mindilizi mizelu iwoneke muna zimango izo. ");
INSERT INTO cwe_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Maabaho kazisimika zimango izo haulongozi wa iwanyama hana zimbaluti za kung'wila mazi iwanyama. Ivo wanyama wezile kung'wa mazi wapata wimo uko. ");
INSERT INTO cwe_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Wapata wimo haulongozi wa mango izo, weleka wanyama weli na mindilizi hebu uzolizoli hebu uzegenha. ");
INSERT INTO cwe_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo kawagola wanang'hondolo wawo, maabaho kawalagusila kuna iwanyama weli na uzolizoli na mindilizi na weli na utitu muna dibumbila da Labani. Kwa ichimu icho Yakobo kapata bumbila jake mwenyewo hadihanganye na diya da Labani. ");
INSERT INTO cwe_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wanyama wanenehe viwatizile, Yakobo keka zimango haulongozi hawo hana zimbaluti za kung'wizila mazi muladi wapate wimo habehi na mango izo. ");
INSERT INTO cwe_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mbali Yakobo hekile zimango izo haulongozi wa wanyama wasokile viwapatile wimo. Ivo wanyama wasokile wawa wa Labani na wanenehe wawa wa Yakobo. ");
INSERT INTO cwe_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ivo Yakobo kawa tajili ng'hani na kawa na mabumbila makulu ya wanyama na wasang'hani wa chilume na wa chike na ngamiya na vihongwe. ");
INSERT INTO cwe_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo kawahulika wanage Labani wolonga, “Yakobo kasola chila chinhu cha tati yetu. Utajili wake wose ulawa kwa tati yetu.” ");
INSERT INTO cwe_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobo kavimanya kuwa Labani hamgesile fana baho haumwaka. ");
INSERT INTO cwe_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Maabaho Mndewa Mulungu kamulongela Yakobo, “Bwela kuna iisi ya wasaho zako na kwa ndugu zako. Na niye nizakuwa hamwe na weye.” ");
INSERT INTO cwe_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakobo katuma wanhu wakawatange Laheli na Leya kwiichuwala koyakalile kowadima iwang'hondolo wake. ");
INSERT INTO cwe_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yakobo kawalongela, “Nowona kuwa tati yenu hanigesa fana umwaka, mbali Mulungu wa tati yangu kahamwe na niye. ");
INSERT INTO cwe_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Muvimanya kuwa nimsang'hanila tati yenu kwa nguvu zangu zose. ");
INSERT INTO cwe_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Hata ivo kanivwizila na kasakanya yombe jangu miyanza longo. Mbali Mulungu hamulekele yanilumize. ");
INSERT INTO cwe_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Haja tati yenu viyalongile, ‘Wanyama wose weli na mawolamawola wezakuwa yombe jako,’ ivo bumbila jose dilela wanyama weli na mawolamawola. Na haja viyalongile, ‘Wanyama wose weli na uzolizoli wezakuwa yombe jako,’ ivo bumbila jose dilela wanyama weli na uzolizoli. ");
INSERT INTO cwe_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mulungu viyasolile wanyama wa tati yenu kaning'ha niye. ");
INSERT INTO cwe_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Lusita lwa wanyama kupata wimo vilufikile nilota nzozi, na niwona mabebelu yose yoyakwelile mazike yakala na mindilizi na mawolamawola na uzolizoli. ");
INSERT INTO cwe_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Msenga wa kuulanga kalonga na niye muna zinzozi na kanitanga, ‘Yakobo,’ nimwidika, ‘Aino.’ ");
INSERT INTO cwe_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Na kalonga, ‘Inula meso yako na ulole mabebelu yose yeli na miliya na mawolamawola. Mbuli iyo iwa ivo kwaviya niwona viyakutendile Labani. ");
INSERT INTO cwe_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Niye ni Mulungu yoyakulawilile kuja Beseli, hanhu haja houitilile mavuta imhanda ya ukumbuso, na weye kunilahila. Lelo isasale na ubwele muna iisi yako yowelekigwe.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Laheli na Leya wamwidika Yakobo, “Cheye chabule kaidi hanhu ha vinhu hebu uhazi wowose muna ikaye ya tati yetu. ");
INSERT INTO cwe_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tati yetu kachitenda fana nyambenyambe. Kachichuuza, na lelo kasang'hanila hela zose zoyalihigwe kwa ichimu chetu. ");
INSERT INTO cwe_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Utajili uno wose Mulungu woyausolile kulawa kwa tati yetu ni wetu cheye na wanetu. Tenda vovose viyakulongele Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakobo kalamka na kaisasala kusegela kwa kuwakweza wanage na wake zake muna ingamiya, ");
INSERT INTO cwe_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Kasola wanyama wake wose na vinhu vake vose viyavipatile kuja Padani Alamu, kandusa mwanza kubwela kuna iisi ya Kanaani kwa Isaka tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labani viyahitile kuwakanha mazoya ng'hondolo wake, Laheli kabawa nyang'hiti za milungu ya tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo kamvwizila Labani Mwalamu, hamulongele bule kuwa kosegela. ");
INSERT INTO cwe_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Kasola chila chinhu chake na kasegela chahimahima. Kaloka ulwanda lwa Efulati na kahita kuna mulima wa isi ya Gileadi. ");
INSERT INTO cwe_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Siku nhatu hamwande Labani kalongiligwa kuwa Yakobo kakimbila. ");
INSERT INTO cwe_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Labani kawasola ndugu zake, kamsondelela Yakobo kwa siku saba. Kamfika kuna mulima wa isi ya Gileadi. ");
INSERT INTO cwe_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Muna zinzozi ichilo Mulungu kamwizila Labani Mwalamu na kamulongela, “Uiteganye, seke umtemele mate Yakobo hebu sekeumduwile.” ");
INSERT INTO cwe_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labani kamfika Yakobo lusita ulo Yakobo viyekile lago jake kumulima, Labani na ndugu zake weka lago jawo muna iisi ya mulima wa Gileadi. ");
INSERT INTO cwe_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani kamulongela Yakobo, “Habali kutenda vino, habali kunivwizila na kuwasola wandele wangu fana mateka kuna ing'hondo? ");
INSERT INTO cwe_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Habali kunivwizila na kunikimbila? One uhanilongele, nahadahile kukulaga kwa deng'ho na nyila na ngoma na vilongelonge. ");
INSERT INTO cwe_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Habali huning'hile nyafasi ya kuwanonela wanangu na wazukulu zangu? Yayo youtendile ya chibozi! ");
INSERT INTO cwe_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ninawo udahi wa kukulumiza, mbali chilo chifosile Mulungu wa tati yako kanizuma kalonga, ‘Seke umtemele mate Yakobo hebu sekeumduwile.’ ");
INSERT INTO cwe_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Novimanya kukimbila kwaviya kukala na hamu ng'hulu ya kubwela ukaye kwa tati yako. Mbali habali kubawa nyang'hiti za milungu yangu?” ");
INSERT INTO cwe_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo kamwidika Labani, “Nidumba kwaviya nigesa uhanihokile wandele wako. ");
INSERT INTO cwe_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mbali one munhu yoyose uhamfika na nyang'hiti za milungu yako, umkome. Zahila haulongozi ha wanhu wetu, one uhawona chinhu chako uchisole.” Yakobo havimanyile bule fana Laheli kabawa nyang'hiti za milungu ya Labani. ");
INSERT INTO cwe_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ivo Labani kahita na kazahila nyang'hiti izo muna dihema da Yakobo, maabaho kengila hema da Leya na hema da wasang'hani waja waidi wa chike, mbali hawonile bule nyang'hiti za milungu yake. Maabaho kengila muna dihema da Laheli. ");
INSERT INTO cwe_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Laheli kakala yasolile nyang'hiti izo za milungu na kazifisa hasi ya chigoda cha kukalila uchanyha ya ngamiya, na kakala mchanyha yake. Mbali Labani kazahila muna dihema jose, mbali hazipatile bule. ");
INSERT INTO cwe_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Laheli kamulongela tati yake, “Tata, sekeuniwonele ludoko, mbali sizakwinuka bule haulongozi wako kwaviya namzisiku zangu.” Labani kazizahila nyang'hiti za milungu yake, mbali hazipatile bule. ");
INSERT INTO cwe_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Maabaho Yakobo kehilwa na kagomba na Labani, kalonga “Nihasanya choni mbaka unisondelele vino? ");
INSERT INTO cwe_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Vino kupekula vinhu vangu vose, chinhu chako chilihi chouchipatile kumwangu? Chike haulongozi wa ndugu zako na ndugu zangu wadahe kulola muladi wadahe kulamula fana imwe wetu kagolosa. ");
INSERT INTO cwe_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nikala na weye miyaka malongo maidi, ng'hondolo wako hebu luti wako hawatengule wimo, na sidile mabebelu kulawa muna dibumbila jako. ");
INSERT INTO cwe_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Niye hata mwanza umwe sikugalile mnyama wako yoyakomigwe na mnyama wa kumbago, mbali niliha ubananzi uwo niye mwenyewo. Weye kunilonda nilihe bila kugesa fana kabawigwa imisi hebu ichilo. ");
INSERT INTO cwe_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Imisi nifunyila umoyo zuwa na ichilo nifunyila umoyo mbeho, sidahile kupata nhongo hata chidogo. ");
INSERT INTO cwe_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Miyaka malongo maidi yose nikala hamwe na weye. Nikusang'hanila miyaka longo na mine kwa ichimu cha wandele zako waidi na miyaka sita kwa ichimu cha wanyama wako, mbali weye kwasakanya yombe jangu miyanza longo. ");
INSERT INTO cwe_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mulungu wa tati yangu na Mulungu wa Bulahimu na Mulungu yoyamtendile Isaka yamdumbe, one sigambeyawe hamwe na niye, wahaniwingile mikono muhala. Mbali Mulungu kayawona manhesa yangu na sang'hano yoniitendile, na ichilo chifosile kakubwakila.” ");
INSERT INTO cwe_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani kamwidika Yakobo, “Wanaake wano ni wandele wangu, na wana wawo ni wanangu, wanyama wano ni wangu. Chila chinhu chouwona hano ni changu. Mbali niye nodaha kutendaki diyelo kwa iwano iwandele wangu na iwana wowaweleke? ");
INSERT INTO cwe_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Izo chitende lagano niye na weye, iwe ukalangama hagati ya weye na niye.” ");
INSERT INTO cwe_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakobo kasola dibwe kulu na kudisimika fana mhanda ya ukumbuso. ");
INSERT INTO cwe_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakobo kawalongela ndugu zake waduganye mabwe, nawo waduganya mabwe na weka chibugulu. Maabaho waja ndiya habehi na chibugulu chiya cha mabwe. ");
INSERT INTO cwe_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani kachitanga chibugulu icho Yegasahadusa, mbali Yakobo kachitanga Galedi. ");
INSERT INTO cwe_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani kamulongela Yakobo, “Chibugulu chino cha mabwe chizakuwa ukalangama kwa cheye waidi.” Kwa ivo lekamana chibugulu icho chotangigwa Galedi, ");
INSERT INTO cwe_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","na iviya hatangigwa Misipa, mana kalonga, “Mndewa Mulungu yachikalize weye na niye lusita vichiwa kutali bila kuiwona.” ");
INSERT INTO cwe_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labani kagendelela kulonga, “One uhawagaza wandele zangu, hebu uhasola wake wamwenga, one ihawa siimanyile mbuli ino, uvimanye kuwa Mulungu ni mkalangama wetu.” ");
INSERT INTO cwe_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani kamulongela Yakobo, “Chibugulu cha mabwe yano ya luwe na mhanda ya ukumbuso yoniisimike hagati ya weye na niye ni ukalangama wa dibwe.” ");
INSERT INTO cwe_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Chibugulu chino na mhanda ni ukalangama kuwa niye sizafosa chibugulu chino kwiza kumwako hebu weye hwizafosa chibugulu chino na mhanda ino kwiza kumwangu kwa wihi. ");
INSERT INTO cwe_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mulungu wa Bulahimu na Mulungu wa Naholi, kezachihumiza niye na weye. Maabaho Yakobo kailaha kwa zina da Mulungu yoyamtendile Isaka yamdumbe. ");
INSERT INTO cwe_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Maabaho Yakobo kalava nhambiko ya kutimbula kuna mulima na kuwagoneka ndugu zake waje ndiya, viwakomeleze wasigala uko chilo chose. ");
INSERT INTO cwe_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Imitondo ng'hani Labani kawanonela wazukulu zake na wanage na kawatemela mate, maabaho kawalaga, kawaleka na kabwela ukaye. ");
INSERT INTO cwe_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo kahita na mwanza wake, wasenga wa kuulanga waiting'hana nayo. ");
INSERT INTO cwe_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo viyawawone kalonga, “Dino ni lago da Mulungu.” Kahatanga hanhu haja Mahanaimu. ");
INSERT INTO cwe_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo katuma wasenga kumulongolela kwa sekulu wake Esau uko Seili kuna iisi ya Edomu. ");
INSERT INTO cwe_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kawalagiliza wakamulongele mwenevale wake Esau, “Msang'hani wako Yakobo kolonga vino ‘Nikala kuugeni kwa Labani mbaka sambi. ");
INSERT INTO cwe_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Niye nina ng'ombe na vihongwe na ng'hondolo na luti na wasang'hani wa chilume na wa chike. Nogala mbuli yangu kumwako mwenevale muladi nitogoleke haulongozi wako.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Wasenga viwabwelile kwa Yakobo, walonga, “Chihita kwa sekulu wako Esau, nayo kamzila kokwiza kukuhokela. Kokwiza na walume magana mane.” ");
INSERT INTO cwe_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakobo kadumba ng'hani na kengiligwa na luholozi. Kawagola mabumbila maidi wanhu wowakalile nayo, iviya ng'hondolo zake na luti zake na ng'ombe zake na ngamiya zake. ");
INSERT INTO cwe_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakobo kagesa, “One Esau yaheza na kuditowa bumbila da mwanduso, bumbila dondadisigale dizaibanga.” ");
INSERT INTO cwe_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Maabaho Yakobo katosa, “Mulungu wa tati yangu Bulahimu na Mulungu wa tati yangu Isaka, nihulike niye! Mndewa Mulungu kunilongela nibwele kuna isi yangu kwa ndugu zangu, na kezanitendela chila chinhu chinogile kumwangu. ");
INSERT INTO cwe_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Niye sifaya hata chidogo sang'hano zako za ulondo wa ufunya umoyo na ubazi wounilaguse msang'hani wako. Vinilokile lwanda lwa Yoludani nikala nabule chinhu ila mhome muhala, mbali lelo ninayo mabumbila maidi. ");
INSERT INTO cwe_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nikombole kwa sekulu wangu Esau. Nodumba kwaviya kezakwiza kuchitowa na kuchinanga cheye chose na wanaake na wana. ");
INSERT INTO cwe_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kulonga kuwa kwiza nitendela yanogile na kutenda welesi wangu uwe mwingi fana msanga wa mwiibahali, haupeteka bule.” ");
INSERT INTO cwe_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakobo kagona baho chilo chose, maabaho kabagula vinhu vake vimwenga viwe chitumetume kwa Esau sekulu wake, ");
INSERT INTO cwe_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","mizike ya luti magana maidi na mabebelu ya luti malongo maidi, mizike ya ng'hondolo magana maidi na mabebelu yang'ondolo malongo maidi, ");
INSERT INTO cwe_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamiya wokong'heza malongo matatu hamwe na madang'ang'a yawo, mang'ombe mazike malongo mane na malume longo, mhunda mazike malongo maidi na malume longo, ");
INSERT INTO cwe_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","kawagola wasang'hani wake, chila munhu bumbila jake. Kawalongela, “Longoleni, kuno muleka nyafasi hagati ya bumbila dimwe na dimwenga.” ");
INSERT INTO cwe_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kamulagiliza msang'hani yalongole, “Wahaiting'hana na sekulu wangu Esau, yahakuuza, ‘Weye kwa msang'hani wa yelihi? Kohitahi? Wanyama kuulongozi wako wa yelihi?’ ");
INSERT INTO cwe_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Kolondeka umwidike, ‘Ni wa msang'hani wako Yakobo. Komgalila chitumetume mwenevale wake Esau. Yakobo mwenyewo kahachisogo chetu kokwiza.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kalagiliza ivoivo kwa msang'hani wa bumbila dekaidi na deketatu na wamwenga wose kwa kulonga, “Mwizamulongela Esau mbuli izo izo vondamwiiting'hane nayo. ");
INSERT INTO cwe_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Iviya mumulongele, ‘Msang'hani wako Yakobo kahachisogo chetu kokwiza.’ ” Yakobo katenda ivo kagesa, “Huwenda nizamuhoza kwa vitumetume ivo vonimulongozela, na hamwande nodaha kuiwona nayo chihanga kwa chihanga, huwenda kezanihokela.” ");
INSERT INTO cwe_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Vitumetume va Yakobo vikala vimulongolela, mbali yeye chilo icho kakala mudilago. ");
INSERT INTO cwe_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Uko chilo icho Yakobo kalamuka kawasola wake zake waidi na watumwa zake wa chike waidi na wanage longo na imwe, na kawalosa lwanda lwa Yaboki. ");
INSERT INTO cwe_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Viyakomeleze kuwalosa umwambu, iviya kalosa vinhu vose viyakalile navo, ");
INSERT INTO cwe_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","mbali Yakobo kakala yaidumwe. Munhu imwe keza na wagomba mbaka imitondo. ");
INSERT INTO cwe_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Munhu iyo viyawonile kuwa hadaha kumuhuma Yakobo, kamdalisa ichigudi mbaka kasiguka. ");
INSERT INTO cwe_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Munhu iyo kalonga, “Nileke nihite kwaviya kokunguzuka.” Yakobo kamwidika, “Sikuleka bule mbaka unitemele mate.” ");
INSERT INTO cwe_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Munhu iyo kamuuza, “Zina jako nani?” Nayo kamwidika, “Yakobo.” ");
INSERT INTO cwe_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Munhu iyo kamulongela, “Zina jako hadizakuwa Yakobo kaidi. Mbali zina jako dizakuwa Isilaili, kwaviya kugomba na Mulungu na wanhu, na kufunya umoyo.” ");
INSERT INTO cwe_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo kamuuza, “Lelo nilongele zina jako.” Mbali yeye kamwidika, “Habali kolonda kumanya zina jangu?” Maabaho kamtemela mate Yakobo. ");
INSERT INTO cwe_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo kalonga, “Nimuwona Mulungu chihanga kwa chihanga na ning'hali mgima.”. Kahatanga hanhu baho Penueli. ");
INSERT INTO cwe_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakobo viyafosile Penueli, zuwa dikala dosomoza, kakala yonjumbila kwaviya kasiguka ichigudi. ");
INSERT INTO cwe_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Niivo ili mbaka diyelo Waisilaili hawaja bule muge wa chigudi, kwaviya imunhu ija kamdalisa Yakobo hana umuge wa ichigudi chake viwakalile wogomba. ");
INSERT INTO cwe_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo kayenula meso yake na kamuwona Esau kokwiza na walume magana mane, ivo kawagola wanage kwa Leya na Laheli, na wasang'hani wake wa chike waidi. ");
INSERT INTO cwe_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kaweka kuulongozi iwasang'hani wa chike na wanawo, maabaho Leya na wanage, kuchisogo Laheli na mwanage Yosefu. ");
INSERT INTO cwe_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakobo mwenyewo kawalongolela kwa kuhita yotumbala mavindi mbaka chihanga chake chidalisa hasi miyanza saba mbaka viyafikile habehi na sekulu wake. ");
INSERT INTO cwe_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mbali Esau kahita yomkimbilila Yakobo, na kamgeleka isingo na kamnonela, na wose waidi walila. ");
INSERT INTO cwe_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau viyalolile na kuwawona iwanaake na iwana, kauza, “Wanhu wano wouli nawo welihi?” Yakobo kamwidika, “Wano ni wana Mulungu woyaning'hile msang'hani wake kwa ubazi wake.” ");
INSERT INTO cwe_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Maabaho waja iwasang'hani na wana wawo wafika habehi na wainama kwa hishima, ");
INSERT INTO cwe_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","iviya Leya na wanage weza na wainama kwa hishima, maabaho Yosefu na Laheli weza na wainama kwa hishima. ");
INSERT INTO cwe_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau kauza, “Vino habali kuyatuma mabumbila yano kumwangu?” Yakobo kamwidika, “Nilonda nitogoleke na weye mwenevale wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mbali Esau kalonga, “Nina vinhu va kufaya sekulu wangu, vinhu viuli navo usigale navo.” ");
INSERT INTO cwe_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo kamulongela Esau, “Haidahika bule, one kutogola kunihokela, nokulamba unihokele vitumetume vangu. Kweli nodeng'helela kukuwona weye fana viya niwona chihanga cha Mulungu, kwaviya viunihokele kwa unovu. ");
INSERT INTO cwe_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nolamba utogole vitumetume vino vonikugalile, kwaviya Mulungu kaninogela na kanipatila chila chinhu chinili nacho.” Ivo Yakobo kambembeleza Esau mbaka kahokela. ");
INSERT INTO cwe_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau kalonga, “Haya chigendelele na mwanza wetu. Niye nizakulongolela.” ");
INSERT INTO cwe_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakobo kamwidika, “Mwenevale wangu kovimanya kuwa wana wano ving'hele, iviya nogesa ng'hondolo na ng'ombe wokong'heza na niye nolondeka kuwalola goya. Fana chahawagendeza siku ngima, yodahika wezadanganika. ");
INSERT INTO cwe_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ivo nolonda mwenevale wangu ulongolele na niye nizasondelela hachisogo ugaluga fana viya kwa ugenzi wa iwanyama na iwana, mbaka vondanifike kwa mwenevale wangu uko Seili.” ");
INSERT INTO cwe_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau kalonga, “Leka nikulekele wanhu wangu wamwenga.” Mbali Yakobo kamwidika, “Sekeusang'hane ivo. Vinoga kumwangu kutogoligwa na weye mwenevale wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Siku iyo Esau kandusa kwamha nzila yake kubwela Seili. ");
INSERT INTO cwe_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mbali Yakobo kahita Sukoti, uko kaizengela kaye mwenyewo na vizewe kwa ichimu cha wanyama wake. Ivo hanhu baho hatangigwa Sukoti. ");
INSERT INTO cwe_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Lusita viyabwelile kulawa Padani Alamu, Yakobo kafika goya muna dibululu da Shekemu muna iisi ya Kanaani na keka lago jake habehi na dibululu. ");
INSERT INTO cwe_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kagula hanhu baho ha lago kulawa muna uwelesi wa Hamoli tati yake Shekemu kwa vihande gana va hela. ");
INSERT INTO cwe_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kazenga lupango hanhu baho na kuhatanga Eli Elohe Isilaili, fambulo jake Mulungu ni Mulungu wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Siku dimwe Dina yoyelekigwe na Yakobo na Leya, kahita kuwalaula wanaake wa isi iyo. ");
INSERT INTO cwe_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shekemu mwana wa Hamoli Muhivi yoyakalile mkulu wa isi iyo, viyamuwene Dina kamwamha na kagona nayo kwa shuluti na kumtenda yawone chinyala. ");
INSERT INTO cwe_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mbali Shekemu kanogelwa ng'hani na Dina mwana wa Yakobo, ivo kandusa kumbembeleza. ");
INSERT INTO cwe_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ivo Shekemu kamulongela Hamoli tati yake, “Uning'he mndele ino yawe muke wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo kahulika kuwa Dina mwanage katendigwa yambule mwiko na Shekemu, Mbali kwaviya wanage wakala wodima wanyama, kanyamala mbaka wanage viwabwelile. ");
INSERT INTO cwe_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamoli tati yake Shekemu kahita kwa Yakobo muladi yadahe kulonga nayo. ");
INSERT INTO cwe_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ivo wanage Yakobo wabwela kulawa kudima wanyama wawo, viwahulike ivo wawona usungu na wehilwa ng'hani kwa yoyatendile Shekemu, kwaviya kawaliga wanhu wa Isilaili kwa kumbandama kwa shuluti mwana wa Yakobo, kwaviya mbuli iyo mwiko. ");
INSERT INTO cwe_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamoli kalonga, “Mwanangu Shekemu kanogelwa ng'hani na mndele wenu, ivo nolamba mumuleke yamsole. ");
INSERT INTO cwe_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Leka chiisole, mweye mwizawasola wanetu na cheye chizawasola wanenu. ");
INSERT INTO cwe_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Maabaho mwizakala hano hana isi yetu hamwe na cheye, mwizakala hohose homulonda na mwizakuwa na ulegeho wa kugula na kuchuluza vinhu na kupata hanhu.” ");
INSERT INTO cwe_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Maabaho Shekemu kamulongela tati yake Dina na iwalumbu zake, “Nolamba munitende nitogoligwe haulongozi wenu na niye nizawagoleleni chomulonda. ");
INSERT INTO cwe_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Munilongele yombe jojose da zengele na chitumetume, hata yahawa ng'hulu vilihi, niye nizalava muladi nimsole yawe muke wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Wanage Yakobo wamwidika kwa kumvwizila Shekemu na tati yake Hamoli, kwaviya Shekemu kamtenda lumbu jawo Dina yambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Walonga, “Haidahika bule lumbu jetu kusoligwa na munhu hengizigwe ulungwana, kutenda ivo ni chinyala kumwetu. ");
INSERT INTO cwe_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Chodaha kwiitogolela kwa chinhu chimwe muhala mwizakuwa fana cheye kwa kumwingiza ulungwana chila mulume mmwenu. ");
INSERT INTO cwe_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Baho niivo vondamusole wandele zetu na cheye kusola wandele zenu. Chizakala hamwe na kuwa wanhu wamwe. ");
INSERT INTO cwe_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mbali one hachiitogolela fana bumbila na kwingizigwa ulungwana, ivo chizamsola mndele wetu na kuhita.” ");
INSERT INTO cwe_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamoli na Shekemu mwanage wanogelwa kwa icho chilongigwe, ");
INSERT INTO cwe_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","imbwanga hakalame hata chidogo kufikiza chochilongigwe, kwaviya viyanogiligwe ng'hani na mndele wa Yakobo. Shekemu niiyo yoyahishimike kufosa wanhu wose ukaye kwa tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamoli na Shekemu mwanage wahita kuna ulwivi lwa dibululu hanhu ha mting'hano kulonga na wanhu wa dibululu, ");
INSERT INTO cwe_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Wanhu wano mambwiya, waleke wakale muna iisi na kugula na kuchuluza vinhu. Isi yofaya kukala cheye na wawo. Wawo wasole wandele wetu na cheye chiwasole wandele wawo. ");
INSERT INTO cwe_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mbali wanhu wano wahatogola kukala na cheye na kuwa wanhu wamwe, kwa chilagano chino cha kumwingiza ulungwana chila mulume vichili, fana viya wawo viwengizigwe ulungwana. ");
INSERT INTO cwe_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Vino hamuwona bule wanyama wawo na vinhu vawo vose vizakuwa vinhu vetu? Lelo chiitogolele nawo muladi wadahe kukala hamwe na cheye.” ");
INSERT INTO cwe_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Walume wose wa dibululu wowaiting'hane hana ulwivi lwa dibululu ijo waitogolela na Hamoli na Shekemu imwanage. Maabaho walume wose wengizigwa ulungwana. ");
INSERT INTO cwe_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Siku yeketatu wengizigwe ulungwana wang'hali wana masungu ng'hani, wana waidi wa Yakobo, niiyo Simeoni na Lawi lumbu zake Dina wasola ngugulila zawo wadihitila dibululu ijo kwa kusinhukiza na kuwakoma walume wose. ");
INSERT INTO cwe_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Iviya wawakoma kwa ngugulila Hamoli na Shekemu imwanage. Maabaho wamsola Dina kulawa muna ikaye ya Shekemu na wahita nayo. ");
INSERT INTO cwe_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Viufosile ukomaji uwo, wana wamwenga wa Yakobo wengila muna dibululu na kusola vinhu kwaviya lumbu jawo katendigwa yambule mwiko shuluti. ");
INSERT INTO cwe_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wasola ng'hondolo na ng'ombe na vihongwe na chila chinhu muna dibululu na muna imigunda. ");
INSERT INTO cwe_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wawagwila wana wawo wose na wanaake wawo wose, na wasola utajili na chila chinhu muna zikaye zawo. ");
INSERT INTO cwe_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Maabaho Yakobo kawalongela Simeoni na Lawi, “Mweye munigalila magayo kwa kunitenda nihiligwe na wanhu wa isi ino ya Wakanaani na Wapelizi. Niye nabule wanhu wengi, na one wahaiduganya hamwe, wezaninanga niye hamwe na ndugu zangu.” ");
INSERT INTO cwe_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Simeoni na Lawi wedika, “Vino vinoga lumbu jetu kusang'haniligwa fana viya malaya?” ");
INSERT INTO cwe_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Mulungu kamulongela Yakobo, “Segela hano, uhite Beseli na ukale uko. Unizengele lupango uko. Niye niiyo Mulungu yoyakulawilile viumkimbile sekulu wako Esau.” ");
INSERT INTO cwe_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ivo Yakobo kawalongela ndugu zake na wanhu wose woyakalile nawo, “Segezeni zinyang'hiti za milungu ya chigeni zimuli nazo, mwiisafye na mwasakanye viwalo zenu. ");
INSERT INTO cwe_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Chosegela hano na chohita Beseli, uko nizamzengela lupango Mulungu yoyanitazile siku ya uzidilwa, Mulungu yoyakalile na niye muna umwanza wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Chila munhu wamtulila nyang'hiti zose za milungu ya chigeni zowakalile nazo, hamwe na heleni zowakalile wozivala mmagutwi. Yakobo kazihimbila hasi ya mbiki wa muwaloni ukalile habehi na Shekemu. ");
INSERT INTO cwe_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yakobo na wanage viwakalile wokwandusa kusegela, Mulungu kawadumbiza ng'hani wakaya wa mabululu yose ya habehi mbaka hawadahile kuwasondelela. ");
INSERT INTO cwe_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobo na wanhu wake wafika Luzu, iviya yotangigwa Beseli, muna iisi ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakobo kazenga lupango baho na kahatanga hanhu baho Eli Beseli, kwaviya Mulungu kamulawilila baho viyamkimbile sekulu wake. ");
INSERT INTO cwe_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debola yaya wa Lebeka kadanganika na kawandigwa hasi ya mbiki wa muwaloni ubanzi wa kusi wa Beseli. Ivo Yakobo kahatanga hanhu baho Aloni Bakusi, fambulo jake “muwaloni wa ndilo.” ");
INSERT INTO cwe_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo viyabwelile kulawa Padani Alamu, Mulungu kamulawilila kaidi na kamtemela mate. ");
INSERT INTO cwe_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mulungu kamulongela, “Weye zina jako Yakobo, mbali kwandusila sambi kwizatangigwa Isilaili.” Ivo Mulungu kamtanga zina Isilaili. ");
INSERT INTO cwe_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Mulungu kamulongela, “Niye Mulungu mwene Udaho, uwe na welesi mwingi na mongezeke. Wanhu wa makabila yose wezalawa kumwako, na kwizakuwa wasaho wa wafalume. ");
INSERT INTO cwe_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Isi yoniweng'hile Bulahimu na Isaka, nizakwing'ha weye na welesi wako.” ");
INSERT INTO cwe_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mulungu viyakomeleze kulonga na Yakobo, kasegela. ");
INSERT INTO cwe_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo kasimika mhanda hanhu haja Mulungu hoyalongile nayo, kaigidila divai na mavuta fana nhosa ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobo kahatanga hanhu baho Mulungu hoyalongile nayo Beseli. ");
INSERT INTO cwe_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakobo na wanhu wake wagendelela na mwanza wasegela Beseli, viwakalile wang'hali hawanafika Efulata, Laheli kapata usungu ng'hani wa kuibasula. ");
INSERT INTO cwe_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nayo viyakalile muna usungu ng'hani wa kuibasula, imulala kamulongela, “Sekeudumbe Laheli, kupata mwana imwenga wa chilume.” ");
INSERT INTO cwe_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mbali Laheli viyakalile habehi na kudanganika, kamwing'ha mwanage zina Benoni, mbali tati yake kamwing'ha mwanage zina Benjamini. ");
INSERT INTO cwe_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Laheli viyadanganike kawandigwa mumgwazo gwazo wa dikulugumbi dodihita Efulata, sambi yomanyika Betelehemu. ");
INSERT INTO cwe_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo kasimika mhanda uchanyha ya leme da Laheli, mbaka diyelo mhanda iyo yauko. ");
INSERT INTO cwe_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isilaili kasegela baho, na keka lago jake viyafosile lingo da Edeli. ");
INSERT INTO cwe_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isilaili viyakalile isi iyo, mwanage Lubeni kagona na Biliha imwe wa watumwa wa chike wakalile fana wake wa tati yake Isilaili na Isilaili kahulika mbuli izo. Yakobo kakala na wana longo na waidi. ");
INSERT INTO cwe_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wanage Leya wakala Lubeni, yeli chaudele wa Yakobo, na Simeoni na Lawi na Yuda na Isakali na Zabuloni. ");
INSERT INTO cwe_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wanage Laheli wakala Yosefu na Benjamini. ");
INSERT INTO cwe_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wana wa Biliha msang'hani wa chike wa Laheli wakala Dani na Nafutali. ");
INSERT INTO cwe_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Wana wa Zilipa msang'hani wa chike wa Leya wakala Gadi na Asheli. Wana wano niiwawo woyaweleke Yakobo uko Padani Alamu. ");
INSERT INTO cwe_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo kahita Mamule kwa Isaka tati yake, habehi na Kiliasi Aliba, iviya yotangigwa Hebuloni, howakalile Bulahimu na Isaka. ");
INSERT INTO cwe_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka kakala na miyaka gana na malongo manane. ");
INSERT INTO cwe_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaka kadanganika mulala ng'hani na kakala na deng'ho, kahita kuilumba na wasaho zake. Esau na Yakobo wanage wamuwanda. ");
INSERT INTO cwe_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Uno uwo ludongo lwa welesi wa Esau, iviya kotangigwa Edomu. ");
INSERT INTO cwe_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau kasola wanaake wa Kanaani, Ada niiyo mndele wa Eloni Muhiti, Oholibama mndele wa Ana na ni mzukulu wa Sibewoni Muhivi, ");
INSERT INTO cwe_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","na Basemati mndele wa Ishumaili, lumbu jake Nebayoti. ");
INSERT INTO cwe_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada kamwelekela Esau Elifazi na Basemati kamweleka Leuweli. ");
INSERT INTO cwe_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama kamweleka Yeushi na Yalamu na Kola. Wano wose wakala wana wa Esau, woyaweleke muna iisi ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Maabaho Esau kawasola wake zake na wanage wa chilume na wanage wa chike na wanhu wose muna ikaye yake, ng'ombe wake na wanyama wake wamwenga wose na vinhu vake vose viyapatile muna iisi ya Kanaani, na kahita isi imwenga kutali na Yakobo mdodo wake. ");
INSERT INTO cwe_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Wasegela kwaviya isi yowakalile wokala Esau na Yakobo ikala haiwafaiye bule. Wakala na mifugo mingi na wapotwa kukala hamwe muna iisi ija. ");
INSERT INTO cwe_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esau kakala muna iisi ya mulima wa Seili, zina dimwenga da Esau ni Edomu. ");
INSERT INTO cwe_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Uno niuwo ludongo lwa welesi wa Esau, wasaho wa Waedomu muna iisi ya milima ya Seili. ");
INSERT INTO cwe_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Wana wa Esau watangigwa Elifazi, yoyelekwe na Ada muke wake, na Leuweli yoyelekwe na Basemati imuke wake imwenga. ");
INSERT INTO cwe_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wana wa Elifazi watangigwa Temani na Omali na Zefo na Gatamu na Kenazi. ");
INSERT INTO cwe_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazi kakala na muke imwenga zina jake Timino, iyo kamwelekela Esau mwana wa chilume zina jake Amaleki, wawo wakala wazukulu wa Ada muke wa Esau. ");
INSERT INTO cwe_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Basemati muke wa Esau kamweleka Leuweli. Wana wa Leuweli watangigwa Nahati na Zela na Shama na Miza. ");
INSERT INTO cwe_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Muke wa Esau Oholibama, mndele wa Ana wa Sibewoni kamwelekela Esau wana watatu, nawo niiyo Yeushi na Yalamu na Kola. ");
INSERT INTO cwe_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Wano ni wakulu wowalawile muna uwelesi wa Esau. Elifazi yoyakalile chaudele wa Esau kaweleka Temani na Omali na Zefo na Kenazi ");
INSERT INTO cwe_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","na Kola na Gatamu na Amaleki, wano wose niuwo welesi wa Elifazi muna iisi ya Edomu, na wazukulu wa Ada muke wake Esau. ");
INSERT INTO cwe_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Leuweli mwanage Esau kaweleka Nahati na Zela na Shama na Miza. Wawo wose wakala wakulu muna yamakabila yawo. Wano wose wakala wana wa Leuweli muna iisi ya Edomu na wazukulu na Basemati muke wa Esau. ");
INSERT INTO cwe_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wano ni wana wa Oholibama muke wa Esau, Yeushi na Yalamu na Kola. ");
INSERT INTO cwe_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Wano ni wawo wana wa chilume wa Esau yani Edomu, chila imwe wawo kawa mkulu wa kabila jake. Wawo wose wana wa Oholibama, mwana wa Ana, muke wa Esau. ");
INSERT INTO cwe_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Wana wa Seili Muholi wowakalile muna iisi iyo watangigwa Lotani na Shobali na Sibeyoni na Ana, ");
INSERT INTO cwe_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","na Dishoni na Eseli na Dishani. Wawo niwawo wakulu wa Waholi wa welesi wa Seili muna iisi ya Edomu. ");
INSERT INTO cwe_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wana wa Lotani watangigwa Holi na Hemanina, lumbu jake Lotani katangigwa Timina. ");
INSERT INTO cwe_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wana wa Shobali watangigwa Avani na Manahati na Ebali na Shefo na Onamu. ");
INSERT INTO cwe_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Wana wa Sibeyoni watangigwa Aya na Ana. Ana niiyo yatolile nzasa za mazi ya moto kuchuwala viyakalile kowadima mhunda wa tati yake Sibeyoni. ");
INSERT INTO cwe_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wanage Ana watangigwa Dishoni na mndele wake zina jake Oholibama. ");
INSERT INTO cwe_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Wana wa Dishoni watangigwa Hemidani na Eshibani na Silani na Kelani. ");
INSERT INTO cwe_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Wana wa Eseli watangigwa Bilihani na Zaawani na Akani. ");
INSERT INTO cwe_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Wana wa Dishani watangigwa Usi na Alani. ");
INSERT INTO cwe_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Wano wakala wakulu wa Waholi, Lotani na Shobali na Sibeyoni na Ana, ");
INSERT INTO cwe_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","na Dishoni na Eseli na Dishani. Wano wakala wakulu wa kabila da Waholi, kwa kusondelela ng'holo zawo muna iisi ya Seili. ");
INSERT INTO cwe_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Wano wakala wafalume watawale mwiisi ya Edomu, yang'hali mfalume yoyose hanawatawala bule Waisilaili ");
INSERT INTO cwe_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwana wa Bewoli kakala mfalume wa Edomu. Bululu jake ditangigwa Dinihaba. ");
INSERT INTO cwe_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Viyadanganike Bela, katawala Yobabu mwana wa Zela kulawa bululu da Bosila, ");
INSERT INTO cwe_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Viyadanganike Yobabu, katawala Hushamu kulawa isi ya Watemani. ");
INSERT INTO cwe_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Viyadanganike Hushamu, Hadadi mwana wa Bedadi katawala, niiyo yoyawatowile na kuwahuma Wamidiani muna iisi ya Moabu, bululu jake ditangigwa Aviti. ");
INSERT INTO cwe_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Viyadanganike Hadadi, katawala Samula kulawa Masileka. ");
INSERT INTO cwe_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Viyadanganike Samula, katawala Shauli kulawa Lehoboti bululu dili habehi ya ulwanda lwa Efulati. ");
INSERT INTO cwe_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Viyadanganike Shauli, katawala Baalihanani mwana wa Akiboli. ");
INSERT INTO cwe_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Viyadanganike Baalihanani, mwana wa Akiboli, katawala Hadadi, bululu jake ditangigwa Pawu na muke wake katangigwa Mehetabeli mndele wa Matiledi na mzukulu wa Mezahabu. ");
INSERT INTO cwe_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Yano ni mazina ya masekulu wa Esau kwa kusondelela ng'holo zawo na hanhu hawo, nawo ni Timina na Aliva na Yeteti ");
INSERT INTO cwe_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","na Oholibama na Ela na Pinoni, ");
INSERT INTO cwe_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","na Kenazi na Temani na Mibisali, ");
INSERT INTO cwe_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","na Magidiyeli na Ilamu. Wawo ni wakulu wa makabila yoyalawile Edomu. Edomu niiyo Esau. Wamanyika kwa kusondelela ukazi wawo muna zisi zowakalile. ");
INSERT INTO cwe_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo kagendelela kukala muna iisi ya Kanaani hanhu hoyakalile tati yake fana mgeni. ");
INSERT INTO cwe_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Zino ni mbuli za ugima wa Yakobo. Yosefu viyakalile mbwanga wa miyaka longo na saba, kakala kodima ng'hondolo na luti hamwe na ndugu zake wana wa Biliha na Zilipa, wake wa tati yake. Yosefu kamulongela tati yake mbuli zihile za ndugu zake. ");
INSERT INTO cwe_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isilaili kamulonda ng'hani Yosefu kufosa wanage wose, kwaviya kamweleka lusita lwa ulala wake. Ivo kamtendela Yosefu ng'hanzu ya chiiyeka yoihambigwe goya. ");
INSERT INTO cwe_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Baho ndugu zake viwawonile kuwa tati yawo kamnogela Yosefu kufosa wawo, wamwihila na hawalongile nayo vinogile bule. ");
INSERT INTO cwe_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Chilo chimwe Yosefu kalota nzozi, na viyawasimulile ndugu zake, wawo waiyoha kumwihila ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosefu kawalongela, “Tegelezeni nzozi yonilotile. ");
INSERT INTO cwe_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nilota kuwa cheye chikala kumgunda chofunga mikinza, na kwa kusinhusa kinza jangu dinuka zugaga! Mikinza yenu iiduganya kudizunguluka na kwiidulikila kinza jangu.” ");
INSERT INTO cwe_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ndugu zake wamuuza, “Vino weye kochilongela kwiza chitawala?” Hebu kwizakuwa na ukulu kumwetu? Ivo waiyoha kugendelela kumwihila kwa ichimu cha nzozi na mbuli zake. ");
INSERT INTO cwe_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Maabaho Yosefu kalota nzozi imwenga na kawalongela ndugu zake, “Nilota nzozi imwenga, niwona zuwa na mwezi na nhondo longo na imwe zinitumbalila mavindi.” ");
INSERT INTO cwe_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Mbali viyawalongele tati yake na ndugu zake, tati yake kambwakila kulonga, “Vino nzozi yaki iyo yuulotile? Vino izatendeza mami yako na ndugu zako na niye chikutumbalile mavindi mpaka chidalise hasi kwa hishima haulongozi wako?” ");
INSERT INTO cwe_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ndugu zake wamuwonela migongo, mbali tati yake kagendelela kuigesa mbuli iyo. ");
INSERT INTO cwe_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Siku dimwe ndugu zake Yosefu wahita kudima mifugo ya tati yawo uko Shekemu. ");
INSERT INTO cwe_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isilaili kamulongela Yosefu, “Nolonda weye uhite uko Shekemu kowadimila mifugo ndugu zako.” Yosefu kamwidika, “Ona nitogola.” ");
INSERT INTO cwe_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tati yake kamulongela, “Hita ukawalole ndugu zako na mifugo one wawo wagima na maabaho ubwele unilongele.” Ivo tati yake kamtuma kulawa muna zanda da Hebuloni. Yosefu kafika Shekemu. ");
INSERT INTO cwe_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Munhu imwe kamuwona kowegela muichuwala na kamuuza, “Kozahila choni?” ");
INSERT INTO cwe_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosefu kamwidika, “Nozahila ndugu zangu wowodima mifugo yawo. Kodaha kunilongela haja haweli?” ");
INSERT INTO cwe_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Munhu ija kamwidika, “Wasegela wamala. Kwaviya niwahulika wolonga wohita Dosani.” Ivo Yosefu kawasondelela ndugu zake na kawafika uko Dosani. ");
INSERT INTO cwe_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Viwamuwone kwa kutali, na yang'hali kuwafikilila, wailungila kumkoma. ");
INSERT INTO cwe_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wailongela, “Lola ija nyamiloto kokwiza. ");
INSERT INTO cwe_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Leka chimkome na chimwase muna disima dimwe. Na chizalonga kadigwa na ng'onyo kali da muna imbago. Maabaho chilole kuwa izo zinzozi zake zizakuwaze.” ");
INSERT INTO cwe_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mbali Lubeni viyahulike mbuli izo, kamkombola Yosefu kulawa kumwawo, kwa kulonga, “Sekechimkome.” ");
INSERT INTO cwe_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Lubeni kawalongela, “Sekemwitile damu, mbali mwaseni muna disima dino hano haichuwala, mbali sekemumulumize.” Kalonga ivo muladi yamkombole Yosefu muna yamakono yawo, maabaho yambweleze kwa tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosefu viyafikile kwa ndugu zake, wamvula ng'hanzu yake ya chiiyeka yoiyawale. ");
INSERT INTO cwe_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Maabaho wamsola na kumwasa muna disima dilibule mazi. ");
INSERT INTO cwe_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Viwakalile woja wawona bumbila da Waishumaili wokwiza kulawa Gileadi kuhita Misili. Ngamiya wawo wakala wapapile vilungo na ubani na mavumba. ");
INSERT INTO cwe_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda kawalongela ndugu zake, “Chizapata choni chihamkoma ndugu yetu, na kufisa ukomaji wake? ");
INSERT INTO cwe_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Chimgule kwa Waishumaili, mbali sekechimulumize kwaviya yeye ni ndugu yetu na iviya ni damu imwe na cheye.” Ndugu zake waitogolela, ");
INSERT INTO cwe_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wagula vinhu Wamidiani viwafikile hanhu baho, ndugu zake wamulava Yosefu muna disima na wamchuuza kwa Waishumaili kwa vihande malongo maidi va hela, na Waishumaeli wamsola Yosefu mbaka Misili. ");
INSERT INTO cwe_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lubeni viyabwelile kuna disima dilibule mazi, hamwone Yosefu bule, Lubeni kadega walo jake kwa usungu. ");
INSERT INTO cwe_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Hamala baho Lubeni kawabwelela ndugu zake na kalonga, “Mbwanga kahabule hano! Choni chondanitende?” ");
INSERT INTO cwe_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hamala baho wachinja mwana luti na wachofeka ng'hanzu ya Yosefu muna idamu. ");
INSERT INTO cwe_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Waisola ing'hanzu mbaka kwa tati yawo na walonga, “Chiiitola ino, lola vino ino niiyo ng'hanzu ya mwanago?” ");
INSERT INTO cwe_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakobo kaimanya ing'hanzu kalonga, “Iyo yake! Mng'onyo wa kumbago kamgwila na kamuja. Yosefu kanyomholigwa vihande vihande!” ");
INSERT INTO cwe_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Baho Yakobo kayadega yamawalo yake kwa usungu, kaiyawaza mawalo ya maguniya muna ichigudi. Kamulilila mwanage kwa siku nyingi. ");
INSERT INTO cwe_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wanage wa chilume na wachike wamwizila wadahe kumuliza, mbali Yakobo kalema kulizwa kwa kulonga, “Nilekeni nizagendelela kulila kwa chimu cha mwanangu, mbaka vondanihite kuzimu kuyeli.” Niivo tati yake viyagendelele kumulilila Yosefu. ");
INSERT INTO cwe_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Chipindi icho uko Misili Wamidiani wamgula Yosefu kwa Potifa imwe wa walangulizi wa mfalume yoyakalile mkulu wa chibumbila cha ukalizi. ");
INSERT INTO cwe_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Chipindi icho Yuda kawaleka ndugu zake na kahita kukala na munhu zina jake Hila, Mwadulamu ");
INSERT INTO cwe_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Uko Yuda kaiting'hana na mndele Mkanaani tati yake zina jake Shuwa. Yuda kamsola mndele iyo na kambandama, ");
INSERT INTO cwe_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mndele wa Shuwa kapata wimo na keleka mwana wa chilume, Yuda kamtanga Eli. ");
INSERT INTO cwe_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kapata wimo umwenga kaidi na keleka mwana imwenga na zina jake kamtanga Onani. ");
INSERT INTO cwe_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Kaidi kapata mwana imwenga wa chilume, kamtanga Shela. Shela viyelekwe, Yuda kakala uko Kezibu. ");
INSERT INTO cwe_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda kamfungiza zengele Eli mwanage chaudele, kwa muke yatangigwe Tamali. ");
INSERT INTO cwe_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mbali Eli chaudele wa Yuda kakala na mbuli za mdukula haulongozi wa Mndewa Mulungu, ivo Mndewa Mulungu kamkoma. ");
INSERT INTO cwe_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ivo Yuda kamulongela Onani ndugu wa Eli, “Hita ukamwingilile muke wa sekulu wako imgane, kwaviya niivo viulondeka utende udahe kumwelekela sekulu wako wana.” ");
INSERT INTO cwe_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mbali Onani kavimanya kuwa sigambe iwe wanage bule, ivo viyambandame muke wa sekulu wake, ketilila hasi zimbeyu, sekeyampatile wana sekulu wake. ");
INSERT INTO cwe_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Choyachitendile Onani iviya chiwa chiha kwa Mndewa Mulungu, iviya yeye nayo Mndewa Mulungu kamkoma. ");
INSERT INTO cwe_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yuda kamulongela Tamali imkoyi wake wa chike, “Bwela kwa tati yako ukale ugane mbaka mwanagu Shela vondayakule.” Yuda kadumba Shela sekeyadanganike fana viya ndugu zake. Ivo Tamali kabwela ukaye kwa tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Lusita lukulu lufosa, muke wake Yuda mwana wa Shuwa kadanganika. Yuda viyakomeleze ndilo, kasegela na mbwiyake Hila kulawa Mwadulamu wahita Timina kwa wakanha mizoya ya ng'hondolo wake. ");
INSERT INTO cwe_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamali kahulika kuwa mkoyi wake wa chilume kakala yohita Timina, kuwakanha mizoya ng'hondolo wake. ");
INSERT INTO cwe_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamali kayavula mawalo ya ukefilwa, kaigubika mtandilo maabaho kakala hana dikumba da kwingilila Enaimu, chibululu chochikalile mwiinzila kuhita Timina. Katenda ivo kwaviya kawona kuwa Shela kawa munhu mkulu mgima mbali Tamali hasoligwe bule na Shela. ");
INSERT INTO cwe_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda viyamuwone Tamali kagesa kuwa kakala yochuuza lukuli lwake, kwaviya chihanga chake kakala yachigubike. ");
INSERT INTO cwe_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Baho havimanyile bule iyo kakala muke wa mwanage Yuda, kamuhitila baho hamgwazo ya inzila kamulongela, “Nolonda nikubandame.” Tamali kalonga, “Kwizaning'ha choni wahanibandama?” ");
INSERT INTO cwe_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda kamwidika, “Nizakwing'ha mwana luti kulawa bumbila jangu.” Tamali kamulongela, “Yose yanoga, yodahika wike wingilizi kulagusa kwizanigalila iyo iluti.” ");
INSERT INTO cwe_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda kamuuza, “Kolonda nikwing'he choni fana wingilizi?” Tamali kamwidika, “Ning'he chinhu chili na luzabi chili na chilaguso chako na mhome.” Yuda kamwing'ha vinhu ivo vose na kambandama, nayo kapata wimo. ");
INSERT INTO cwe_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Maabaho Tamali kasegela, kahambula mtandilo woyaigubike, kayawala nyawalo zake za ugane. ");
INSERT INTO cwe_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda viyamtumile ija imbwiya Mwadulamu, yamgalile ija mwanamke mwana luti muladi yambwelezele wingilizi yoyamulekele, mbali hamfikile bule. ");
INSERT INTO cwe_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kawauza wanhu wa Enaimu, “Kakulihi muke ija malaya yoyakalile hano hana dikulugumbi yoyotenda umalaya fana nzila ya kutosela nyang'hiti za milungu?” Iwanhu wamwidika, “Hanhu hano hakalile na muke malaya bule.” ");
INSERT INTO cwe_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hila kambwelela Yuda na kalonga, “Simuwonile bule. Wanhu wa hanhu baho walonga kuwa hano hahakalile na muke malaya.” ");
INSERT INTO cwe_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda kalonga, “Leka yavisole vinhu ivo. Sekeyachitendeze wanhu wachizehe. Weye mwenyewo kuwona nimgalila mwana luti mbali weye humfikile bule.” ");
INSERT INTO cwe_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Viifosile miyezi mitatu, Yuda kalongiligwa kuwa, “Mkoyi wako Tamali muke wa mwanago kapata wimo kwa ugoni wake.” Yuda kalagiliza, “Msoleni yalavigwe kunze yasomigwe moto mbaka yadanganike.” ");
INSERT INTO cwe_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Viwakalile womulava kunze, Tamali katuma usenga kwa mkoyi wake wa chilume: “Niye nina wimo kwa munhu mwene vinhu vino. Umulole na ummanye munhu mwene chinhu chili na luzabi chili na chilaguso chako na mhome ino.” ");
INSERT INTO cwe_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda kavimanya vinhu ivo na kalonga, “Tamali kanoga kufosa niye, kwaviya simsolele mwanangu Shela.” Kusongela siku ijo Yuda hambandame kaidi Tamali. ");
INSERT INTO cwe_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Viifikile chipindi cha Tamali kwiibasula, kukala na mambasa mwiinda yake. ");
INSERT INTO cwe_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Usungu vuumfikile wa kwiibasula, mbasa imwe kalava mkono kunze, nayo imulala kamfunga kwa lusingija ludung'u kuno kolonga, “Ino niiyo yanduse kwelekigwa.” ");
INSERT INTO cwe_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mbali imwana viyaubweleze mkono mgati, ndugu yake kandusa kwelekigwa. Imulala kalonga, “Hee weye kufosa kwa nguvu kulawa kunze!” Ivo katangigwa zina jake Pelesi, fambulo jake “Kulawa kwa nguvu.” ");
INSERT INTO cwe_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Maabaho sekulu wake nayo kelekigwa kuno kana lusingija ludung'hu muna umkono wake, nayo katangigwa Zela. ");
INSERT INTO cwe_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Waishumaili viwamsolile Yosefu wamgala mbaka Misili na wamchuuza kwa Potifa, imwe wa wakulu wa mfalume, na niiyo mkulu wa chibumbila chake cha wakalizi. ");
INSERT INTO cwe_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mndewa Mulungu kakala hamwe na Yosefu, nayo katenda vinogile ng'hani kwa chila chinhu. Yosefu kakala muna ikaye ya mwenevale wake Mmisili. ");
INSERT INTO cwe_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mwenevale wake viyawonile kuwa Mndewa Mulungu kakala hamwe na Yosefu na chila chiyatendile katenda vinogile. ");
INSERT INTO cwe_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ivo Potifa kanogeligwa ng'hani na Yosefu, na kamtenda msang'hani wake, ivo kamwika kuwa mulolesi wa kaye yake na chila chinhu chiyakalile nacho. ");
INSERT INTO cwe_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kwandusila lusita ulo, kwa ichimu cha Yosefu Mndewa Mulungu kaitemela mate kaye ya Mmisili iyo na chila chinhu choyakalile nacho na migunda yake. ");
INSERT INTO cwe_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifa keka chila chinhu chiyakalile nacho haulolesi na ukalizi wa Yosefu, na hagesile chochose ila kuja ndiya yake muhala. Yosefu kakala mbwanga yanogile na chihanga chinoga, ");
INSERT INTO cwe_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","na lusita vilufosile muke wa Potifa kandusa kummelela mate Yosefu na kamulamba yahite yakaibandame nayo. ");
INSERT INTO cwe_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yosefu kalema na kamulongela, “Mwenevale wangu kabule lugano jojose muna ikaye kwaviya niye nabaha, na kanitulila chila chinhu chiyeli nacho. ");
INSERT INTO cwe_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hano hakaye kabule mamulaka kufosa niye, hanilemesa kwamha chochose ila weye muhala kwaviya weye kwa muke wake. Ivo nodahaze kutenda wihi fana uwo kwa kumuhasanya Mulungu?” ");
INSERT INTO cwe_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Na muke wa Potifa kamulongela Yosefu mbuli iyo chila siku, mbali Yosefu kalema kumbandama na hata kuwa hamwe nayo. ");
INSERT INTO cwe_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mbali siku dimwe Yosefu kengila mgati mwiikaye kusang'hana sang'hano yake na wasang'hani wamwenga hawakalile umo. ");
INSERT INTO cwe_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Muke wa Potifa kamgwila debwani jake na kulonga, “Unyangale.” Mbali Yosefu kasulupuka na kakimbilila kunze, kadileka debwani jake mmakono yake. ");
INSERT INTO cwe_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Muke wa Potifa viyawonile kuwa Yosefu kadileka debwani jake na kukimbilila kunze ya ikaye, ");
INSERT INTO cwe_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kawatanga wasang'hani wa kaye yake na kawalongela, “Loleni ino! Ino Muebulaniya mulumangu yoyomgalile mwiikaye kochiguma chinyala. Kengila muna ichiheleto changu muladi yanyangale, mbali niye niguta nyangi. ");
INSERT INTO cwe_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Viyahulike noguta nyangi, kakimbilila kunze, kadileka debwani jake hamwangu.” ");
INSERT INTO cwe_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mwanamke ija kadika debwani diya, mbaka mwenevale wa Yosefu viyabwelile ukaye. ");
INSERT INTO cwe_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kamsimulila mbuli iyo, “Iyo msang'hani Muebulaniya yoyumgalile hano kengila muna ichiheleto kuniguma chinyala. ");
INSERT INTO cwe_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mbali vinigutile nyangi, kadileka debwani jake na kukimbilila kunze.” ");
INSERT INTO cwe_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mwenevale wa Yosefu viyazihulike mbuli izo za muke wake, kuwa ivo viyasang'hane msang'hani wake, kawa na ludoko ");
INSERT INTO cwe_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","na kamgwila Yosefu na kumwika muna ichifungo hanhu hawakalile wafungigwa wa mfalume. Ivo Yosefu kalekigwa mwiichifungo. ");
INSERT INTO cwe_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mbali hata umo muichifungo Mndewa Mulungu kakala nayo na kagendelela kumulagusa Yosefu ulondo wake, mbaka mkulu wa chifungo kanogelwa nayo. ");
INSERT INTO cwe_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Mkulu wa chifungo kamwika Yosefu yawe mkulu wa wafungigwa wose na chila chochitendeke umo muna ichifungo chitendeka kwa ulangulizi wake. ");
INSERT INTO cwe_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mkulu wa chifungo hagesile chinhu chochose, Yosefu katuliligwa chila chinhu kwaviya Mndewa Mulungu kakala hamwe nayo na chila chinhu choyachitendile katenda vinogile. ");
INSERT INTO cwe_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Viyafosile yayo mwikagoya ving'waji na mokaji magate wa mfalume wa Misili wamuhasanya mfalume wa Misili. ");
INSERT INTO cwe_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mfalume kawawonela ludoko walangulizi wake waidi, mwikagoya ving'waji na mokaji magate ");
INSERT INTO cwe_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","na kawaguma muna ichifungo muna ikaye ya mkulu wa wakalizi, hanhu hoyafungigwe Yosefu. ");
INSERT INTO cwe_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Wanhu wawo wakala muna ichifungo kwa lusita, na mkulu wa wakalizi kamwing'ha ukulu Yosefu yawalolese. ");
INSERT INTO cwe_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ikala chilo chimwe, mwikagoya ving'waji na mokaji magate wa mfalume wa Misili wowafungigwe muna ichifungo walota nzozi, chila imwe kalota nzozi mbasakanyo na miyage, nzozi zikala na fambulo mbasakanyo. ");
INSERT INTO cwe_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yosefu viyezile imitondo, kawawona kuwa wawa luholozi. ");
INSERT INTO cwe_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yosefu kawauza wakulu wawo wa mfalume wowakalile hamwe nayo mwiichifungo mwiikaye ya mwenevale wake, “Habali diyelo muna vihanga va luholozi?” ");
INSERT INTO cwe_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nawo wamwidika, “Chilota nzozi na habule yodaha kuchifambulila nzozi zetu.” Yosefu kalonga, “Vino siyo Mulungu muhala yoyodaha kufambula nzozi?” Nilongeleni nzozi zenu. ");
INSERT INTO cwe_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mwikagoya ving'waji wa mfalume kamulongela Yosefu, “Muna inzozi yangu niwona kuzubuku da mzabibu haulongozi wangu, ");
INSERT INTO cwe_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nawo ukala na matambi matatu. Lusita viusukile mayani, maluwa yake yapumbuluka na vilobota vake viwa zabibu zivile. ");
INSERT INTO cwe_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mmakono yangu nikala nokwamhilila nhungo ya mfalume. Baho nisola zabibu nizikamula muna inhungo na nimwing'ha mfalume.” ");
INSERT INTO cwe_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosefu kamulongela, “Dino niijo fambulo jake, matambi matatu ni siku nhatu. ");
INSERT INTO cwe_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Zahafika siku nhatu, mfalume kezakulava muna ichifungo na kukubweleza kaidi muna ukulu wako. Kwizamwing'ha mfalume nhungo fana viukalile kotenda baho haumwanduso. ");
INSERT INTO cwe_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mbali ung'humbuke baho chila chinhu vondachihite goya kumwako, na nolamba unitendele yanogile na unitambule baho haulongozi wa mfalume na unitaze nilawe muna ichifungo chino. ");
INSERT INTO cwe_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kwaviya niye nitolosigwa kulawa isi ya Waebulaniya na hano sitendile chochose chinitendeze nigumigwe muna ichifungo.” ");
INSERT INTO cwe_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mkulu wa mokaji magate viyawone fambulo ijo dinoga da mwikagoya ving'waji, kamulongela Yosefu, “Iviya naniye nilota nzozi, nikala niitwikile vigelo vitatu va magate mditwi jangu. ");
INSERT INTO cwe_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Muna ichigelo cha uchanyha kukala na ndiya mbasakanyo zibanikigwe kwa ichimu cha mfalume, mbali udege wazija muna ichigelo uchanyha mditwi jangu.” ");
INSERT INTO cwe_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosefu kamwidika, “Dino niijo fambulo jake: Vigelo vitatu ni siku nhatu. ");
INSERT INTO cwe_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Muna zisiku nhatu mfalume kezakulava mchifungo, na kukuchinja ditwi jako. Kezakutumbika muna umbiki na ndege wezakuja nyama yako.” ");
INSERT INTO cwe_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Siku ya tatu, ikala siku ya kufikiza kwelekigwa mfalume. Mfalume kawekila dugila wakulu wake wose, kamulava muna ichifungo mwikagoya ving'waji na mokaji magate mkulu na kaweka haulongozi wa wakulu wake. ");
INSERT INTO cwe_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Mfalume kambweleza mwikagoya ving'waji muna ukulu wake wa kung'wiza, muladi yamwing'he nhungo mfalume muna yamakono. ");
INSERT INTO cwe_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mbali mokaji magate mkulu katumbikigwa fana viyalongile Yosefu. ");
INSERT INTO cwe_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mbali mwikagoya ving'waji, hamkumbuke bule Yosefu kamzimiza. ");
INSERT INTO cwe_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Viifosile miyaka midi, mfalume wa Misili kalota nzozi, kuwa kakala yemile muna ingema ya lwanda lwa Naili, ");
INSERT INTO cwe_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","lusita kawona ng'ombe saba watelele na wanenehe walawa kunze ya ulwanda lwa Naili na wandusa kuja mgina. ");
INSERT INTO cwe_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Maaabaho ng'ombe saba wamwenga weza, wowakalile wasisili na wasoka. Weza na wema habehi na waja ng'ombe mumgwazo wa ulwanda luja lwa Naili, ");
INSERT INTO cwe_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ng'ombe waja saba wasisili na wasokile, wawaja ng'ombe waja watelele na wanenehe. Maabaho mfalume kalamuka. ");
INSERT INTO cwe_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kagona kaidi na kalota nzozi zimwenga. Mimada saba ya uhemba imema na ikangala, ikung'huna muna dibuwa dimwe. ");
INSERT INTO cwe_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mimada saba ya uhemba imisisili yoinyazigwe na mbeho ili na vuke ya ulawilo wa zuwa ilawilila. ");
INSERT INTO cwe_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ivo mimada misisili iyaja ija imimada saba yoinenehe. Mfalume kalamuka kavimanya kuwa kakala kolota. ");
INSERT INTO cwe_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Imitondo kengilwa na lugano, katuma wasawi wose na wanhu wabala wose wa Misili. Na mfalume kawalongela nzozi zake, mbali habule munhu yoyose yamfambulile. ");
INSERT INTO cwe_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Maabaho mkulu wa mwikagoya ving'waji kamulongela mfalume, “Diyelo nokumbuka ubananzi wangu woniutendile. ");
INSERT INTO cwe_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Lusita luja viuchiwonele ludoko cheye wakulu wako, niye na mkulu wa mokaji magate na kuchifunga muna ichifungo muna ikaye ya mkulu wa wakalizi. ");
INSERT INTO cwe_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Chilo chimwe niye na yeye chilota nzozi, na chila nzozi ikala na fambulo jake. ");
INSERT INTO cwe_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Mbwanga iyo Muebulaniya msang'hani wa mkulu wa wakalizi kakala hamwe na cheye, Chimulongela nzozi zetu, na yeye kachifambulila. ");
INSERT INTO cwe_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Chila chinhu chilawilila fana viya viyalongile. Ukulu wangu nibweleziligwa mbali mokaji magate katumbikigwa.” ");
INSERT INTO cwe_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mfalume kalagiliza Yosefu yagaligwe, na wamgala kulawa muna ichifungo. Yosefu viyamalile kuwegula na kusaula nyawalo zake, kahita kwa mfalume. ");
INSERT INTO cwe_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Mfalume kamulongela Yosefu, “Nilota nzozi, mbali habule munhu yoyose yoyadahile kunifambulila. Nilongiligwa kuwa weye kodaha kuzifambula nzozi.” ");
INSERT INTO cwe_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosefu kamwidika mfalume, “Sidaha bule, mbali Mulungu kezamfambulila mfalume vinogile.” ");
INSERT INTO cwe_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Mfalume kamulongela Yosefu, “Nilota nima muna ingema ya lwanda lwa Naili, ");
INSERT INTO cwe_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","niwawona ng'ombe saba wolawa muna ulwanda lwa Naili watelele na wanenehe na wandusa kuja mgina. ");
INSERT INTO cwe_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Maabaho ng'ombe wamwenga saba wasisili na wasokile. Muna iisi yose ya Misili sinawawona bule wowalingile fana wawo. ");
INSERT INTO cwe_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ng'ombe wasisili na wasokile weza na wawaja iwang'ombe saba waja wanenehe, ");
INSERT INTO cwe_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","mbali viwamalile kuwaja ng'ombe waja wanenehe, munhu yoyose sigambe yavimanye kuwa wawaja wayawo, kwaviya wakala wasoka fana viya ichanduso. Maabaho nilamka mzinhongo. ");
INSERT INTO cwe_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Maabaho muna zinzozi zangu niwona mimada saba ya uhemba inogile na imema yokung'huna muna dibuwa dimwe. ");
INSERT INTO cwe_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Maabaho mimada saba ya uhemba, imisisili inyazigwe na mbeho ili na vuke ya ulawilo wa zuwa ilawilila, ");
INSERT INTO cwe_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","na mimada iyo misisili imela ija mimada saba inogile. Niwalongela waganga nzozi izo, mbali habule munhu yoyadahile kunifambulila.” ");
INSERT INTO cwe_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosefu kamulongela mfalume, “Nzozi zako mbili zina fambulo dimwe, Mulungu kakulongela chiya chondayatende. ");
INSERT INTO cwe_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Waja ng'ombe saba wanenehe ni miyaka saba, na ija mimada saba ya uhemba inogile iviya ni miyaka saba, fambulo jake ni dimwe. ");
INSERT INTO cwe_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Waja ng'ombe saba iwasisili na wasokile, waja wowasondelele waja wanenehe na ija mimada saba ya uhemba, yoinyazigwe na mbeho ya ulawilo wa zuwa, fambulo jake ni miyaka saba ya nzala. ");
INSERT INTO cwe_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Fana viya vinimulongele mfalume, Mulungu kamulagusa yaja yondayatende. ");
INSERT INTO cwe_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kwizakuwa na miyaka saba ya shibe muna iisi yose ya Misili. ");
INSERT INTO cwe_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Yahafosa yayo, kwizalawilila miyaka saba ya nzala, na miyaka ija inogile izazimizwa muna iisi ya Misili, kwaviya nzala izalumiza isi. ");
INSERT INTO cwe_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Chipindi cha shibe hachizakumbukigwa, kwaviya nzala ikwiza izakuwa ng'hulu. ");
INSERT INTO cwe_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kwaviya nzozi ya mfalume ibweleligwa miyanza midi, imulagusa kuwa Mulungu kalamula na kezaifikiza mbuli ino ivino sambi. ");
INSERT INTO cwe_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Lelo mfalume kolondeka yamsagule munhu yeli na umanyi na ubala, yawe mulolezi muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kaidi yeye mfalume, yawatome walolesi wamwenga hano mwiisi, yawalagilize waduganye hanhu ha tano ha ndiya ya miyaka saba ya shibe muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Yawalagilize waduganye ndiya zose chipindi cha miyaka inogile ikwiza, na kumwing'ha udahi mfalume wa kwika ndiya muna yamagulu kwa ichimu cha ndiya ya mabululu yose, ikalizwe kwa kwikigwa goya. ");
INSERT INTO cwe_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ndiya iyo izakuwa ngama ya isi chipindi cha miyaka saba ya nzala yondaiwe muna iisi ya Misili. Kwa nzila ino wanhu hawezadanganika kwa nzala bule.” ");
INSERT INTO cwe_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Mbuli iyalongile Yosefu imnogeza mfalume na wakulu wake. ");
INSERT INTO cwe_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ivo mfalume kawauza wakulu wake, “Vino chompatahi munhu fana ino Yosefu yeli na muhe wa Mulungu mgati yake?” ");
INSERT INTO cwe_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mfalume kamulongela Yosefu, “Kwaviya Mulungu kakulagusa yano yose, habule munhu yeli na ubala fana weye. ");
INSERT INTO cwe_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nokwika weye muna ulolesi wa isi yangu, na wanhu wangu wose wezakutegeleza. Ukulu wako wizakuwa wekaidi kulawa niye. ");
INSERT INTO cwe_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mfalume kamulongela Yosefu, Lelo nokwing'ha ukulu wa kutawala isi yose ya Misili.” ");
INSERT INTO cwe_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Mfalume kavula chinhu chili na luzabi chili na chilaguso chake muna ichidole chake, na kachiguma muna ichidole cha Yosefu. Kamuyawaliza walo da mgolole na kumvaza mkufu wa zahabu mwiiisingo yake. ");
INSERT INTO cwe_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Mfalume kamkweza muna umtuka wake wekaidi wa falasi, na wakalizi walongolela haulongozi wa Yosefu, kuno wolandula madizi yawo na kulonga, “Tumbaleni mavindi!” Ivo niivo mfalume viyamwing'hile ukulu Yosefu muna iisi yose ya Misili. ");
INSERT INTO cwe_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Maabaho mfalume kamulongela Yosefu, “Niye mfalume, na habule munhu yoyose muna iisi yose ya Misili yondayenule mkono hebu mgulu bila ya kulongiligwa na weye.” ");
INSERT INTO cwe_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Mfalume kamwing'ha Yosefu zina da Chimisili, Zefanati Paneya, na kamwing'ha muke, Asenati mwana wa Potifela, mkulu wa nhambiko wa bululu da Oni. Yosefu kahita uko na uko muna iisi ya Misili ");
INSERT INTO cwe_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosefu kakala na lika da miyaka malongo matatu viyanduse kumsang'hanila mfalume wa Misili. Yosefu kahasegela haulongozi wa mfalume na kahita kuna iisi yose ya Misili. ");
INSERT INTO cwe_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ivo muna imiyaka ija saba ya shibe, migunda muna iisi ilava ndiya mvunyo, ");
INSERT INTO cwe_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yosefu kaduganya ndiya kwa miyaka saba muna iisi ya Misili na keka kuna yamabululu. Chila bululu keka ndiya kulawa mmigunda yoizunguluka. ");
INSERT INTO cwe_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yosefu keka ngama ya ndiya mvunyo fana viya msanga wa mwiibahali mbaka kapotwa kuipeta kwaviya haipeteka. ");
INSERT INTO cwe_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ing'hali hainakwandusa miyaka saba ya nzala, Yosefu kawa kapata wana waidi kwa imuke Asenati mwana wa Potifela mkulu wa nhambiko wa Oni. ");
INSERT INTO cwe_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosefu kamtanga mwanage chaudele zina jake Manase, kwaviya kalonga, “Mulungu kanitenda nizimize manhesa yangu yose na kaye ya tati yangu.” ");
INSERT INTO cwe_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwana magati kamtanga zina Efulaimu, fambulo jake, “Mulungu kaning'ha wana muna iisi ya manhesa yangu.” ");
INSERT INTO cwe_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Miyaka saba ya shibe iwa imala muna iisi ya Misili, ");
INSERT INTO cwe_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","na miyaka saba ya nzala yandusa, fana viya Yosefu viyalongile. Kukala nzala muna zisi zimwenga zose, mbali muna iisi ya Misili kukala na ndiya. ");
INSERT INTO cwe_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wamisili viwanduse kuwa na nzala, wamulilila mfalume yaweng'he ndiya. Mbali mfalume kawalongela Wamisili wose, “Muhite kwa Yosefu na mutende chondayawalongele.” ");
INSERT INTO cwe_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nzala yenela muna iisi yose, Yosefu kayavugula madungu yose na kawachuluzila ndiya Wamisili, kwaviya nzala ikala ng'hulu muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Wanhu kulawa zisi zose weza Misili kugula ndiya kwa Yosefu, kwaviya nzala ikala ng'hulu ng'hani chila hanhu. ");
INSERT INTO cwe_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo viyamanyile kuwa uko Misili kuna ndiya, kawalongela wanage, “Habali mweye moilola mweye kwa mweye muhala? ");
INSERT INTO cwe_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nihulika uko Misili kuna ndiya, hiteni uko mukagule ndiya muladi sekechidanganike kwa nzala.” ");
INSERT INTO cwe_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ivo ndugu longo wa Yosefu wahita Misili kugula ndiya. ");
INSERT INTO cwe_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mbali Yakobo hamulekele bule Benjamini mdodo wake Yosefu kuhita na ndugu zake, kwaviya kadumba chinhu chihile kumulumiza. ");
INSERT INTO cwe_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Wana wa Isilaili wafika Misili, wagula ndiya fana viya wamwenga, kwaviya uko kwiisi ya Kanaani kukala na nzala. ");
INSERT INTO cwe_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Chipindi icho, Yosefu niiyo yoyakalile mulolesi wa isi ya Misili, yoyawachuuzile ndiya wanhu walawile zisi zose. Ivo ndugu zake Yosefu weza na wamtumbalila mavindi mbaka vihanga vidalisa hasi. ");
INSERT INTO cwe_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosefu viyawawone ndugu zake kawatambula, mbali kaitenda fana viya hawamanyile bule. Kawauza kwa ukali, “Mweye mulawa kulihi?” Nawo wamwidika, “Chilawa isi ya Kanaani, chiza kugula ndiya.” ");
INSERT INTO cwe_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosefu kawamanya sekulu zake, mbali wawo hawammanyile bule. ");
INSERT INTO cwe_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yosefu kaikumbuka nzozi yoyailotile na kalonga, “Mweye mwiza kupelemba unyonyonde wa isi yetu.” ");
INSERT INTO cwe_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ndugu zake wamwidika, “Siyo mwenevale. Cheye ni wasang'hani wako chiza kugula ndiya. ");
INSERT INTO cwe_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Cheye chose ni ndugu, cheye siyo wapelembaji, cheye wasang'hani wako ni wanhu hachilonda uvwizi.” ");
INSERT INTO cwe_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Mbali Yosefu kagendelela kulonga, “Siyo! Mwiza kupelemba unyondenyonde muna iisi yetu.” ");
INSERT INTO cwe_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wamulongela, “Cheye wasang'hani wako, chose cha ndugu longo na waidi, wana wa munhu imwe mkaya wa Kanaani. Ndugu yetu imwe kadanganika, na mdodo wetu kasigala na tati yetu.” ");
INSERT INTO cwe_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosefu kawedika, “Fana viya viniwalongele, mweye mwa wapelembaji. ");
INSERT INTO cwe_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Vino niivo vondamugezigwe, noilaha kwa zina da mfalume, hano hamwizahalawa mbaka mdodo wenu vondayeze hano. ");
INSERT INTO cwe_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mtumeni imwe wenu yamsondelele ndugu yenu imdodo na kuno wamwenga wogozela muna ichifungo baho hondaumanyike ulonzi wenu kweli yake, la sivo noilaha kwa zina da mfalume, mweye mwa wapelembaji.” ");
INSERT INTO cwe_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Maabaho kawaguma muna ichifungo kwa siku nhatu. ");
INSERT INTO cwe_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Siku yetatu Yosefu kawalongela, “Kwaviya niye nomdumba Mulungu, tendeni vino na mweye mwizakala. ");
INSERT INTO cwe_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","One mweye mwa wanhu siyo wauvwizi, imwe wenu yasigale muna ichifungo, wamwenga wawagalile ndiya ndugu zenu ukaye weli na nzala. ");
INSERT INTO cwe_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Maabaho mumgale mdodo wenu kumwangu. Iyo yolagusa ukweli wa ulonzi wenu, na hamwizakomigwa bule.” Waitogolela ivo. ");
INSERT INTO cwe_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Maabaho walonganya, “Lelo cheye cha muna yamagayo kwa ichimu cha yaja yochimtendele Yosefu ndugu yetu, chimuwona kakala na luholozi mkulu hata viya viyachilambile nhazo, mbali cheye hachimtegeleze bule. Lekamana magayo yano yose yochilawilila.” ");
INSERT INTO cwe_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lubeni kawedika, “Siwalongele bule kuwa sekemumulumize mbwanga? Mbali mweye hamunitegeleze bule! Lelo damu yake yolondigwa kumwetu.” ");
INSERT INTO cwe_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosefu kakala yovimanya yose yowakalile wolonga, mbali wawo hawavimanyile bule kuwa kavimanya, kwaviya viyalongile kalonga nawo kwa nzila ya mfambulaji. ");
INSERT INTO cwe_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosefu kasegela hoyakalile na kandusa kulila. Kabwela na kulonga nawo, kamgwila Simeoni na kamfunga haulongozi wawo. ");
INSERT INTO cwe_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosefu kalagiliza maguniya yawo ya kusumila yamemezigwe ndiya na kumbwelezela chila imwe wawo hela muna diguniya jake na ndiya ya mzila. Ivo niivo itendeke. ");
INSERT INTO cwe_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Wawapapiza mbahasha zawo vihongwe, na maabaho wasegela. ");
INSERT INTO cwe_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Viwafikile hanhu ha kugona nyambenyambe, imwe wawo kafungula lobota jake yadahe kumdima chihongwe wake, kazanywa kuwona hela yake muna diguniya jake. ");
INSERT INTO cwe_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kawalongela ndugu zake, “Hela yangu ibwelezigwa.” Aino hano hanadiguniya jangu! Viwahulike yayo mizoyo yawo igwa na wakala wogudema kwa ludumbo na kwiiuzagiza wenyewo, “Chinhu chaki chino Mulungu choyachitendele?” ");
INSERT INTO cwe_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Viwafikile kwa tati yawo Yakobo uko kuna iisi ya Kanaani, wamulongela mbuli zose zozilawilile. ");
INSERT INTO cwe_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mkulu wa isi ya Misili kalonga na cheye kwa ukali na kuchilonga cheye cha wapelembaji muna iisi yake. ");
INSERT INTO cwe_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mbali cheye chimwidika, ‘Cheye siyo wapelembaji, cha wanhu hachilonga uvwizi. ");
INSERT INTO cwe_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Chimulongela kuwa cheye cha ndugu longo na waidi, wana wa tata imwe. Ndugu yetu imwe ni mwene kwaga, mdodo wetu kauko kuna iisi ya Kanaani hamwe na tati yetu.’ ");
INSERT INTO cwe_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Mbali mkulu wa isi ija kachilongela, ‘Vino niivo vondanivimanye kuwa mweye mwa wanhu hamulonga uvwizi, mulekeni kumwangu ndugu yenu imwe, na wamwenga mgale ndiya kwa jamaa zenu weli na nzala. ");
INSERT INTO cwe_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mumgale mdodo wenu kumwangu. Maabaho nizavimanya kuwa hamuli wapelembaji, mbali wanhu hawalonga uvwizi. Nizaweng'ha ndugu yenu kubwela nayo, na mwizadaha kulekelwa kutenda uchuluzi muna iisi ino.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Viwakalile wokung'huna ndiya kulawa muna yamaguniya yawo, wazanywa kuwona chila imwe wawo kabweleziligwa chifuko chake na hela mgati ya guniya jake. Viwawone zihela, wawo na tati yawo Yakobo wadumba. ");
INSERT INTO cwe_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakobo tati yawo kawalongela, “Monihoka wanangu, Yosefu kakwabule, Simeoni kakwabule, na lelo molonda kumsola Benjamini. Manhesa yose yamhata niye!” ");
INSERT INTO cwe_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Lubeni kamulongela tati yake, “Fana niye simbweleze bule Benjamini kumwako, uwakome wanangu waidi. Muleke Benjamini muna imikono yangu na niye nizamkaliza na kumbweleza kumwako.” ");
INSERT INTO cwe_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mbali Yakobo kalonga, “Mwanangu haita hamwe na mweye bule, sekulu wake kadanganika, na kasigala yaidumwe muhala. One jojose dahamulawilila mwiinzila, niye namulala nili na uhenga, ivo mwizanikoma kwa lugano dondanipate.” ");
INSERT INTO cwe_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Maabaho nzala ikala ng'hulu muna iisi. ");
INSERT INTO cwe_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Viwakomeleze kuja ndiya yose yoigaligwe kulawa Misili, tati yawo kawalongela wanage, “Bweleni na kugula ndiya chidogo kwa ichimu chetu.” ");
INSERT INTO cwe_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Mbali Yuda kamulongela, “Munhu ija kachizuma kwa ukali kalonga, ‘Sizawahokela bule fana hamwizile nayo ndugu yenu.’ ");
INSERT INTO cwe_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","One kotogola chihite nayo mdodo wetu, chizahita kukugulila ndiya. ");
INSERT INTO cwe_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mbali one wahalema yahite na cheye, hachizahita bule, kwaviya munhu ija kachilongela funhula funhula kuwa ‘Sizawahokela mweye mbaka mwize na mdodo wenu.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isilaili kalonga, “Habali moniguma muna diyangwayangwa kwa kumulongela imunhu iyo kuwa munayo mdodo wenu imwenga?” ");
INSERT INTO cwe_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wawo wamwidika, “Imunhu iyo kachiuzagiza ugaluga ng'hani kusonhela mbuli zetu na welesi wetu kalonga, ‘Tati yenu yang'hali mgima? Mumpata ndugu imwenga?’ Cheye chimwidika kwa viya viyauzile. Chihavimanyile vilihi fana kochilongela mwize na mdodo wenu?” ");
INSERT INTO cwe_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda kamulongela tati yake Isilaili, “Mulekelele mwanago hamwe na niye, na chizasegela mwanza umwe muladi cheye na weye na wanetu chidahe kuwa wagima sekechidanganike. ");
INSERT INTO cwe_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Niye mwenyewo nokuwa mwingilizi, na weye kwizanyamhilila niye. One simbweleze kumwako, nidaigwe niye siku zose ");
INSERT INTO cwe_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Mbali one hachikalame bule, chahahitile uko na kubwela hano miyanza midi.” ");
INSERT INTO cwe_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tati yawo Isilaili kawalongela, “Haya kwaviya yolondeka iwe ivo, basi, tendeni ivo, soleni kulawa muna imifuko yenu mazao yanogile ya isi, mavuta chidogo ya mkwazu na uki chidogo na ubani na mavuta yonung'ha goya na mbeyu za kuja. ");
INSERT INTO cwe_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Soleni hela ya miyanza midi yoilondeka, kwaviya yolondeka mwiibweleze hela ija yoikigwe muna yamalobota yenu. Yodahika ibwelezigwa chiubananzi. ");
INSERT INTO cwe_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Msoleni ndugu yenu na muhite nayo kwa munhu iyo. ");
INSERT INTO cwe_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mulungu mwene Udaho yawanogele kupata ubazi haulongozi wa munhu iyo na yawalekelele ndugu yenu imwenga, kezaweng'ha Benjamini na ndugu yenu imwenga kubwela mose, one nahalondeka niwagize wanangu, nizawagiza.” ");
INSERT INTO cwe_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Iwandugu wasola vitumetume na hela miyanza midi kufosa ija ya ichanduso. Wahita Misili hamwe na ndugu yawo Benjamini. Viwafikile wahita kwima haulongozi wa Yosefu. ");
INSERT INTO cwe_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Baho Yosefu viyamuwonile Benjamini hamwe nawo, kamulongela mulolesi wa kaye yake, “Wasole wanhu wano mbaka ukaye yangu. Wezakuja ndiya ya imisi hamwe na niye. Chinja mnyama na usasale ndiya.” ");
INSERT INTO cwe_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mulolesi kaye katenda fana viya viyalagilizigwe, kawasola mbaka kwiikaye ya Yosefu. ");
INSERT INTO cwe_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Viwawone wogaligwa kwiikaye ya Yosefu, wadumba na walonga, “Chogaligwa kuno kwa ichimu cha ija ihela yochibweleziligwe muna yamalobota yetu vichizile mwanza wanduso yadahe kupata ulongelo wa kuchidusa kwa kuchihoka vihongwe wetu na kuchitenda chiwe watumwa wake.” ");
INSERT INTO cwe_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Viwawile hana ulwivi lwa ikaye ya Yosefu, wamulongela msang'hani, ");
INSERT INTO cwe_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Chilekelele mwenevale, chiza hano kugula ndiya umwanza wa ichanduso. ");
INSERT INTO cwe_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Vichifikile kaye ya nyambenyambe, chifungula malobota yetu, chila imwe wetu kafika hela muna yamalobota yake. Ivo chinayo, chikubwelezela. ");
INSERT INTO cwe_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Iviya chinazo hela zimwenga za kugulila ndiya kaidi. Hachivimanyile bule yelihi yekile hela yetu muna malobota yetu.” ");
INSERT INTO cwe_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mulolesi kawedika, “Muwe na tindiwalo na sekemdumbe. Mulungu wenu, Mulungu wa tati yenu, niiyo yekile hela zenu muna yamaguniya. Nihokela maliho yenu.” Maabaho kawagalila Simeoni. ");
INSERT INTO cwe_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mulolesi kawasola mbaka mwiikaye ya Yosefu. Kaweng'ha mazi wanawe nhende, na kawadima vihongwe wawo. ");
INSERT INTO cwe_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nawo wasasala vitumetume vawo va kumwing'ha Yosefu, vondayabwele imisi, kwaviya walongiligwa kuwa wezakuja ndiya hamwe nayo. ");
INSERT INTO cwe_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ivo Yosefu viyabwelile ukaye, wasola vitumetume muna ikaye na wamtumbalila mavindi mbaka chihanga chidalisa hasi. ");
INSERT INTO cwe_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kawauza kuhusu ugima wawo na maabaho kalonga, “Munisimulila kuhusu tati yenu imulala, vino kachelwa? Vino yang'hali mgima?” ");
INSERT INTO cwe_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wawo wamwidika, “Msang'hani wako tati yetu yang'hali mgima na kachelwa.” Maabaho wamtumbalila mavindi mbaka chihanga chidalisa hasi. ");
INSERT INTO cwe_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosefu kachinula chihanga chake na kamuwona ndugu yake Benjamini, mwana wa mami yake na kalonga, “Ino niiyo ndugu yenu imdodo, yomnilongele mbuli zake? Mulungu yakunogele, mwanangu.” ");
INSERT INTO cwe_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosefu kahalawa hima hima hanhu baho, kwaviya kaihulika giyogiyo kwa ichimu cha kumemwa na ubazi wa ndugu yake, kahita kuna ichiheleto chake na kalila umo. ");
INSERT INTO cwe_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Viyakomeleze kunawa chihanga chake, kalawa kunze, na kaiyangambiza, kalagiliza yagaliligwe ndiya. ");
INSERT INTO cwe_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yosefu kagaliligwa ndiya yake yaidumwe mwiimeza, na wandugu zake waidumwe. Wamisili wadile hamwe iviya waigola kwaviya ni mwiko kuja ndiya hamwe na Waebulaniya. ");
INSERT INTO cwe_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ndugu zake Yosefu wakala kwa kuipanga haulongozi wake kwa kusondelela lika jawo. Kwandusila wa mwanduso mbaka wa uhelelo, wakala woilola kwa mwazanyo. ");
INSERT INTO cwe_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ndiya ikala isoligwe kulawa kwa Yosefu na kugaligwa kumwawo, mbali Benjamini kagoliligwa miyanza mitano kufosa ndugu zake. Ivo wang'wa na wadeng'helela hamwe nayo. ");
INSERT INTO cwe_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yosefu kamulagiliza mulolesi wa kaye yake, “Memeza malobota ya wanhu wano ndiya fana viya vowodaha kupapa, na mwikile chila munhu hela muna umulomo wa guniya jake. ");
INSERT INTO cwe_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ika nhungo malumu muna umulomo wa lobota da ija imdodo, hamwe na hela ya ndiya yake.” Nayo katenda fana viya viyalongiligwe na Yosefu. ");
INSERT INTO cwe_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Imitondo ng'hani ndugu wawo watogoleligwa kusegela na vihongwe wawo. ");
INSERT INTO cwe_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nawo viwawile hawanahita hatali kulawa muna dibululu, Yosefu kamulongela mulolesi wa kaye yake, “Himahima wasondelele na wahawapata uwagwile na uwauze, ‘Habali muliha yehile kwa yanogile? ");
INSERT INTO cwe_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Vino habali mubawa nhungo malumu ya mwenevale wangu? Vino nhungo ino siyo ija iyong'wila nayo koisang'hanila kulagula? Ivo mutenda vihile kwa dino!’” ");
INSERT INTO cwe_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ivo mulolesi viyawafikile kawalongela mbuli izo izo. ");
INSERT INTO cwe_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Wamulongela, “Habali mwenevale kolonga mbuli fanile zino? Cheye wasang'hani wako hachidaha kusang'hana mbuli fanile ino bule. ");
INSERT INTO cwe_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Lola mwenevale hela ichifikile muna imilomo ya maguniya yetu chiibweleza kulawa muna iisi ya Kanaani. Lelo habali chibawe hela hebu zahabu kulawa muna ikaye ya mwenevale wako? ");
INSERT INTO cwe_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mwenevale, one imwe wetu yahawoneka kanayo, yakomigwe, na chondachisigale chizakuwa watumwa wako.” ");
INSERT INTO cwe_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kalonga, “Nitogola, mbali ija yasolile nhungo yangu muhala niiyo yondayawe mtumwa wangu, na wondamusigale mwizailegeha.” ");
INSERT INTO cwe_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ivo wahulumusa hasi maguniya yawo himahima, na chila munhu kafungula lobota jake. ");
INSERT INTO cwe_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mulolesi wa Yosefu kapekula maguniya yose kwandusila da mkulu kabisa mbaka da mdodo kabisa na nhungo ipatika kwa idodo kabisa muna diguniya da Benjamini ");
INSERT INTO cwe_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Baho wadega viwalo vawo kwa lugano, wawapapiza mizigo vihongwe wawo, na wabwela kuna dibululu. ");
INSERT INTO cwe_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda na ndugu zake viwezile kuna ikaye ya Yosefu, Yosefu kakala yang'hali umo. Ivo wamtumbalila mavindi kwa hishima. ");
INSERT INTO cwe_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosefu kawauza, “Mutenda choni? Hamuvimanyile kuwa munhu fana niye nodaha kulagula?” ");
INSERT INTO cwe_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda kamwidika, “Mwenevale, chodaha kulonga choni?” Chodahaze kulema? “Chodahaze kuigombela? Mulungu kalagusa ubananzi wetu. Lelo cheye chose na ija yatoligwe na nhungo yako, chawatumwa wako.” ");
INSERT INTO cwe_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yosefu kalonga, “Bule! Niye sidaha kutenda ivo! Ija muhala yasolile nhungo yangu niiyo yondayawe mtumwa wangu. Mweye musigalile bweleni kwa tindiwalo kwa tati yenu.” ");
INSERT INTO cwe_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda kamkwenhukila Yosefu na kamulongela, “Mwenevale, nokulamba, unilekelele niigombele. Sekeuniwonele ludoko weye kulinga fana mfalume mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mwenevale, weye kuchiuza cheye, ‘Mweye muna tata hebu ndugu?’ ");
INSERT INTO cwe_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Chidika, ‘Chinayo tata mulala na ndugu mdodo, kamweleka muna ulala wake. Sekulu wake kadanganika, na yeye muhala niiyo mwana yasigale kwa mami yake na tati yake komulonda ng'hani.’ ");
INSERT INTO cwe_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mwenevale, kuchilagiliza cheye wasang'hani wako chimgale hano, muladi umuwone, ");
INSERT INTO cwe_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","na chikulongele kuwa mbwanga iyo hadaha kumuleka tati yake, one yahamuleka tati yake, tati yake kezadanganika. ");
INSERT INTO cwe_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Maabaho kuchilongela wasang'hani wako, ‘One hamwizile na ndugu yenu imdodo sizamuhokelani bule.’ ");
INSERT INTO cwe_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Vichibwelile ukaye kwa msang'hani wako tati yangu, chimulongela mbuli zako mwenevale. ");
INSERT INTO cwe_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Maabaho tati yetu kachilongela chibwele kugula ndiya chidogo. ");
INSERT INTO cwe_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Chimwidika, ‘Hachidaha kuhita, mbali hachihokeligwa mbaka chihite na mdodo wetu. One hezahita na cheye bule hachidaha kuhokiligwa na munhu ija.’ ");
INSERT INTO cwe_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tati yetu kachilongela, ‘Movimanya kuwa muke wangu Laheli kanyelekela wana waidi muhala wa chilume. ");
INSERT INTO cwe_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Imwe kaga kamala. Na nilonga kuwa yodahika kalumizigwa na wang'onyo wa muna imbago. Kwaviya sinamuwona kaidi kwandusila viyasegele. ");
INSERT INTO cwe_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","One muhamsola ino iviya kulawa kumwangu yahapatigwa na yehile mwizanihumulusa kuzimu na kuno na mulala nili na mnamilo.’ ");
INSERT INTO cwe_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ivo mwenevale,” Nihambwelela tati yangu msang'hani wako bila ya mbwanga ino na kuno ugima wa tata ohuwila ugima wa mbwanga ino. ");
INSERT INTO cwe_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","“Yahawona kahabule hamwe na cheye kezadanganika. Ivo cheye wasang'hani wako chizamtenda tati yetu yadanganike kwa mnamilo. ");
INSERT INTO cwe_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Yose ya yayo niye niilava niwe mwingilizi wa mbwanga ino kwa tati yangu, nilonga one simbweleze bule Benjamini kumwako ubananzi uwe kumwangu siku zose. ");
INSERT INTO cwe_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Lelo weye mwenevale nokulamba, niye msang'hani wako, nisigale niwe mtumwa wako kwa chimu cha mbwanga ino. Muleke yeye yabwele ukaye hamwe na ndugu zake. ");
INSERT INTO cwe_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nodahaze kubwela kwa tati yangu one mbwanga heli na niye? Sidaha kufunya umoyo kuwona yehile yondayampate tati yangu.” ");
INSERT INTO cwe_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Baho Yosefu kapotwa kufunya umoyo haulongozi ha wasang'hani wake, ivo kawalongela wose walawe kunze ya chiheleto. Ivo Yosefu kakala yaidumwe viyailaguse kwa ndugu zake. ");
INSERT INTO cwe_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Kalila kwa dizi kulu mbaka Wamisili wamuhulika, mbaka wanhu wa kaye ya mfalume nawo wahulika. ");
INSERT INTO cwe_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Maabaho Yosefu kawalongela ndugu zake, “Niye ni Yosefu. Vino tati yangu yang'hali mgima?” Mbali ndugu zake viwahulike ivo, wadumba mbaka hawadahile kwidika bule. ");
INSERT INTO cwe_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Maabaho Yosefu kawalongela, “Nolamba, kwenhukeni habehi yangu.” Wakwenhuka, nayo kalonga, “Niye ni ndugu yenu Yosefu, yomunichuuzile kuhita Misili. ");
INSERT INTO cwe_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mbali lelo sekemwingilwe na luholozi na sekemuilaumu wenyewe kwaviya munichuuza. Mulungu kanituma kuulongozi wenu muladi nikombole ugima wa wanhu. ");
INSERT INTO cwe_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Uno ni mwaka wekaidi wa nzala muna iisi, na ing'hali miyaka imwenga mitano iyo wanhu hawezadaha kulima hebu kugobola. ");
INSERT INTO cwe_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mulungu kanigala kuulongozi wenu muladi niwatende mweye musigale muna iisi na kuwakombola kwa ukombola mkulu. ");
INSERT INTO cwe_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ivo siyo mweye yomunigalile hano, mbali Mulungu. Kanitenda niwe tata kwa mfalume. Niye ni mwimilizi wa kaye yose, niye ni mtawala wa isi yose ya Misili. ");
INSERT INTO cwe_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ivo himahima mubwele kwa tata na mumulongele kuwa vino ivo viyolonga Yosefu mwanago; ‘Mulungu kanitenda niwe mtawala wa isi yose ya Misili, izo kumwangu bila kukalama. ");
INSERT INTO cwe_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kwizakala muna iisi ya Gosheni, kwizakuwa habehi na niye, weye na wanago na wazukulu zako na ng'hondolo wako na luti wako na ng'ombe wako na chila chinhu chiulinacho. ");
INSERT INTO cwe_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Vondauwe Gosheni, nizakulola goya weye, ndugu zako hamwe na fugo yako muladi sekemupuwe chochose chomulonda, kwaviya ing'hali miyaka imwenga mitano ya nzala.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yosefu kagendelela kulonga, “Mweye wenyewo muwona kwa meso yenu na hata ndugu yangu Benjamini kaniwona kwa meso yake kuwa niye iyo mwenyewo Yosefu yonilonga na mweye. ");
INSERT INTO cwe_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Na mweye mwizamulongela tati yangu hishima inili nayo hano Misili na yose yomuyawone, maabaho himahima mukamsole tati yangu na mumgale hano.” ");
INSERT INTO cwe_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Maabaho Yosefu kamuhagatila Benjamini ndugu yake na kalila, Benjamini nayo kalila na kuno waihagatila. ");
INSERT INTO cwe_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Maabaho wogendelela kulila, Yosefu kawanonela ndugu zake na kalila. Viyakomelezeke yayo ndugu zake wandusa kulonga nayo. ");
INSERT INTO cwe_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mbuli izo vizifikile kwiimhongono ya mfalume, kuwa ndugu wa Yosefu weza, zimnogela mfalume na wakulu wake. ");
INSERT INTO cwe_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ivo mfalume kamulongela Yosefu, “Walongele ndugu zako wawapapize mizigo yawo vihongwe na wabwele kuna iisi ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Wamgale hano tati yawo na wanhu wawo. Niye nizaweng'ha hanhu hanogile ha isi ya Misili, nawo wezadeng'helela matunda yose ya isi ino. ");
INSERT INTO cwe_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Iviya walongele kulawa Misili, wasole mituka ibululigwa kuwagalila wana wawo wadodo na wake zawo na iviya sekewaswele kumgala tati yawo. ");
INSERT INTO cwe_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Walongele sekewagese vinhu vawo kwaviya vinhu vinogile muna iisi ya Misili vizakuwa vawo.” ");
INSERT INTO cwe_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ivo wana wa Isilaili watenda fana viya viwalongiligwe. Yosefu kaweng'ha mituka fana viyalagilize mfalume na ndiya ya kuja mwiinzila. ");
INSERT INTO cwe_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kamwing'ha chila munhu viwalo va kusaula. Mbali kamwing'ha Benjamini vihande magana matatu va hela na viwalo vitano va kusaula. ");
INSERT INTO cwe_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Hamala baho vitumetume vino kamwing'ha tati yake kwa ichimu cha mwanza, vihongwe longo wowapapile vinhu vinogile kulawa Misili, vihongwe wake longo wowapapile ndiya, magate na ndiya zimwenga. ");
INSERT INTO cwe_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ivo Yosefu kailaga na ndugu zake. Viwakalile wosegela Yosefu kawazuma kulonga, “Sekemugombe mwiinzila.” ");
INSERT INTO cwe_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Baho wasegela Misili na kubwela ukaye kwa tati yawo Yakobo mwiisi ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wamulongela tati yawo, “Yosefu mgima!” Niiyo mtawala wa isi yose ya Misili! Baho tati yawo kengilwa na mkangagile, kwaviya hadahile bule kuzitogola mbuli zawo. ");
INSERT INTO cwe_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mbali viwamulongele Yakobo mbuli izo zose ziwalagilizigwe na Yosefu na viyawone mituka yoyagaliligwe na Yosefu kumsola, moyo wake umema deng'ho ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isilaili kalonga, “Lelo moyo wangu woibwanha, mwanangu Yosefu mgima. Nohita nikamuwone ning'hali sinadanganika bule.” ");
INSERT INTO cwe_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isilaili kandusa mwanza wake hamwe na vinhu vake vose kahita Belisheba, uko kalava nhambiko kwa Mulungu wa tati yake Isaka. ");
INSERT INTO cwe_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mulungu kalonga na Isilaili muna yamalaguso ichilo na kamtanga, “Yakobo, Yakobo!” Nayo kamwidika, “Yemwe, aino hano.” ");
INSERT INTO cwe_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Mulungu kalonga, “Niye niiyo Mulungu, Mulungu wa tati yako.” “Sekeudumbe kuhita Misili, vondauwe uko, nizakutenda uwe makabila mengi. ");
INSERT INTO cwe_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Niye mwenyewo nohita na weye uko Misili, na nizakubweleza muna iisi ino. Yosefu kezakuwa na weye baho vondaudanganike na mkono wake wizamfumba meso yako.” ");
INSERT INTO cwe_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakobo kahasegela Belisheba. Wanage Isilaili wamguma Yakobo tati yawo muna imituka yoyailavile mfalume wa Misili hamwe na iwana iwadododo na wake zawo. ");
INSERT INTO cwe_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Iviya wasola mifugo na vinhu vawo vose, viwakalile wapata muna iisi ya Kanaani, maabaho wahita Misili. Yakobo kasola welesi wake wose, ");
INSERT INTO cwe_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","wanage wa chilume na wachike na wazukulu zake na welesi wake kaugala Misili. ");
INSERT INTO cwe_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yano yayo mazina ya wana wa Isilaili wowahitile muna iisi ya Misili, wakala Yakobo na wanage na Lubeni chaudele wa Yakobo, ");
INSERT INTO cwe_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","na wanage Lubeni wakala Henoki na Palu na Heziloni na Kalimi, ");
INSERT INTO cwe_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","na wanage Simeoni wakala Yemueli na Yamini na Ohadi na Yakini na Sohali na Shauli yoyelekigwe na mwanamke Mkanaani. ");
INSERT INTO cwe_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Wanage Lawi wakala Gelishoni na Kohasi na Melali. ");
INSERT INTO cwe_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Wanage Yuda wakala Eli na Onani na Shela na Pelesi na Zela. Mbali Eli na Onani wadanganika muna iisi ya Kanaani. Wana wa Pelesi wakala Hesiloni na Hamuli. ");
INSERT INTO cwe_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Wanage Isakali wakala Tola na Puva na Yobu na Shimuloni. ");
INSERT INTO cwe_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Wanage Zabuloni wakala Seledi na Eloni na Yaleeli. ");
INSERT INTO cwe_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Wano ni wana wa chilume waja Leya woyamwelekele Yakobo kuja Padani Alamu, hamwe na Dina mndele wake. Pete ya wanage, wandele zake na wabwanga zake wakala malongo matatu na watatu. ");
INSERT INTO cwe_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Wanage Gadi wakala Zefoni na Hagi na Shuni na Esboni na Eli na Alodi na Aleli. ");
INSERT INTO cwe_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Wanage Asheli wakala Imina na Ishiva na Ishivi na Belia na Sela yeli lumbu jawo. Na wanage Beliya wakala Hebeli na Melikieli. ");
INSERT INTO cwe_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Wano longo na sita ni wana wa Yakobo na Zilipa, mtumwa niiyo Labani yamwing'hile Leya mndele wake. ");
INSERT INTO cwe_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Laheli, muke wa Yakobo kamwelekela wana waidi wa chilume, Yosefu na Benjamini. ");
INSERT INTO cwe_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Muna iisi ya Misili Yosefu keleka wana waidi, Manase na Efulaimu, kwa Asenati mndele wa Potifela, mkulu wa nhambiko wa Oni. ");
INSERT INTO cwe_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wanage Benjamini wakala Bela na Bekeli na Ashibeli na Gela na Naamani na Ehi na Loshi na Mupimu na Hupimu na Alidi. ");
INSERT INTO cwe_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Wanhu wana longo na wane ni wana na wazukulu wa Yakobo na Laheli muke wake. ");
INSERT INTO cwe_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwanage Dani kakala Hushimu. ");
INSERT INTO cwe_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Wanage Nafutali wakala Yaseeli na Guni na Yaseli na Shilemu. ");
INSERT INTO cwe_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Wawo saba ni wana na wazukulu wa Yakobo na Biliha msang'hani wa chike iyo Labani kamwing'ha mndele wake Laheli. ");
INSERT INTO cwe_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wanhu wose wa welesi wa Yakobo wowahitile nayo kuna iisi ya Misili, bila kuwapeta wake wa wanage, wakala wanhu malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Uko kwiisi ya Misili Yosefu keleka wana waidi. Ivo peta yose ya welesi wa Yakobo wengile Misili wakala malongo saba. ");
INSERT INTO cwe_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobo kamulongoza Yuda kwa Yosefu muladi yamulaguse nzila mbaka Gosheni. Ivo weza mbaka hanhu ha Gosheni. ");
INSERT INTO cwe_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosefu kakwela mtuka wake na kahita kumkimilila Isilaili tati yake uko Gosheni. Viwaiting'hane na tati yake, waigeleka zisingo na kalila kwa lusita lutali. ");
INSERT INTO cwe_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isilaili kamulongela Yosefu, “One nahadanganika sambi si chinhu bule, kwaviya nichiwona chihanga chako na kuvimanya kuwa weye kwa mgima.” ");
INSERT INTO cwe_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hamala baho Yosefu kawalongela ndugu zake na wanhu wose wa tati yake, “Nolondeka kuhita na kumulongela mfalume kuwa ndugu zangu na wanhu wose wa tati yangu wokala mwiisi ya Kanaani, wanizila. ");
INSERT INTO cwe_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nizamulongela kuwa mweye mwawadimaji wanyama kwaviya mukala wafugaji, na kwaviya mufika hamwe na luti na ng'hondolo na ng'ombe na vinhu venu vimulinavo. ");
INSERT INTO cwe_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ivo mfalume yahawatanga na kuwauza sang'hano yenu choni, ");
INSERT INTO cwe_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","longeni, ‘Mwenevale, cheye wasang'hani wako chawafugaji wanyama kwandusila udodo wetu mbaka diyelo, kwaviya niivo viwakalile wasaho zetu.’ Longeni ivo muladi mudahe kutogoligwa kukala mkowa wa Gosheni.” Yosefu kalonga ivo kwaviya kwa Wamisili wadimaji wa ng'hondolo si chinhu bule. ");
INSERT INTO cwe_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yosefu kamulongela mfalume, “Tati yangu na ndugu zangu weza kulawa Kanaani na ng'hondolo wawo na luti wawo na ng'ombe wawo na vinhu vawo vose viweli navo. Sambi wokala muna umkowa wa Gosheni.” ");
INSERT INTO cwe_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kawasagula ndugu watano na kawalagusa kwa mfalume. ");
INSERT INTO cwe_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Mfalume kawauza, “Sang'hano yenu ilihi?” Nawo wamwidika mfalume, “Cheye wasang'hani wako ni wadimaji fana viya viwakalile wasaho zetu.” ");
INSERT INTO cwe_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Maabaho wamulongela mfalume, “Cheye wasang'hani wako chiza kukala fana nyambenyambe muno mwiisi kwaviya uko Kanaani kuna nzala ng'hulu na kaidi chabule mgina wa wanyama wetu wa kufugigwa. Ivo mwenevale, chokupula cheye, wasang'hani wako, uchilekele kukala muna umkowa wa Gosheni.” ");
INSERT INTO cwe_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Mfalume kamulongela Yosefu, “Tati yako na ndugu zako wakwizila weye, ");
INSERT INTO cwe_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","isi ya Misili ni yako. Weng'he tati yako na ndugu zako hanhu hanogile muna umkowa wa Gosheni. Waleke wakale muna iisi, na one kuwamanya wanhu wene ujuzi wawo viweli wasagule wawe walolesi wa mifugo yangu.” ");
INSERT INTO cwe_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Maabaho Yosefu kamsola tati yake Yakobo na kumulagusa kwa mfalume. Maabaho Yakobo kamtemela mate mfalume, ");
INSERT INTO cwe_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","na mfalume kamuuza Yakobo, “Lika jako ni miyaka mingahi?” ");
INSERT INTO cwe_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo kamwidika, “Miyaka yangu fana mfosanzila ni gana na malongo matatu. Miyaka iyo iwa midodo na imema magayo, kaidi hainafika miyaka yowakalile mawasaho fana wafosa nzila.” ");
INSERT INTO cwe_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Maabaho Yakobo kamtemela mate mfalume na kusegela. ");
INSERT INTO cwe_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Maabaho Yosefu kaweng'ha hanhu hakukala tati yake na ndugu zake muna iisi ya Misili, kaweng'ha hanhu hanogile habehi na bululu da Lamasesi, fana viya mfalume viyalagilize. ");
INSERT INTO cwe_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosefu kaweng'ha ndiya tati yake na ndugu zake na wanhu wa mwiikaye yake kusondelela idadi ya wanawo wadododo. ");
INSERT INTO cwe_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ivo hakukalile na ndiya bule muna iisi yose, kwaviya nzala ikala ng'hulu ng'hani muna iisi yose ya Misili na muna iisi ya Kanaani, na isi zigaya kwa nzala. ");
INSERT INTO cwe_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosefu kaduganya hela zose zoziguliligwe ndiya na kuzigala kuna iisi ya Misili na isi ya Kanaani. Kazigala hela zose muna ikaye ya mfalume wa Misili. ");
INSERT INTO cwe_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Hela zose vizimalile muna iisi ya Misili na muna iisi ya Kanaani. Wamisili wose wamwizila Yosefu na wamulongela, “Uching'he ndiya! Habali chidanganike hana yameso yako. Hela zetu zose zimala.” ");
INSERT INTO cwe_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosefu kawedika, “Galeni mifugo yenu. Niye nizaweng'ha ndiya kwasakanya na wanyama wenu, one mowona hela zenu zimala.” ");
INSERT INTO cwe_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Wawagala wanyama wawo kwa Yosefu, nayo kaweng'ha ndiya kwa kwasakanya na vihongwe na ng'hondolo na ng'ombe na mhunda. Nayo kaweng'ha ndiya kwasakanya na wanyama wawo wose mwaka uwo. ");
INSERT INTO cwe_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaka usondelele wamwizila kaidi na wamulongela, “Mwenevale, ukweli ni kuwa hela zetu zose zimala na iviya mifugo yetu iwa yako. Lelo mwenevale, cheye wasang'hani wako chabule chochose chochidaha kukwing'ha mbali ng'huli zetu na migunda yetu. ");
INSERT INTO cwe_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ivo habali chidanganike hana yameso yako cheye na migunda yetu? Uchigule cheye hamwe na isi yetu chiwe watumwa wa mfalume kwa kwasakanya na ndiya. Cheye wenyewe hamwe na isi yetu chizamsang'hanila mfalume. Na uching'he mbeyu muladi chidahe kuwa wagima, ivo isi yetu isigale.” ");
INSERT INTO cwe_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Maabaho Yosefu kamgulila mfalume isi yose ya Misili, kwaviya Wamisili wose wagula migunda yawo kwaviya nzala ikala iwayohela. Ivo isi yose ikala mali yake mfalume. ");
INSERT INTO cwe_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yosefu kawatenda wanhu kuwa watumwa kulawa ubanzi uno wa Misili mbaka ubanzi umwenga. ");
INSERT INTO cwe_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ila isi ya wakulu wa nhambiko muhala haigulile bule. Kwaviya wakulu wa nhambiko wakala wokwing'higwa yombe jawo kulawa kwa mfalume, ivo isi yawo haiguligwe bule. ");
INSERT INTO cwe_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosefu kawalongela wanhu, “Lelo loleni diyelo niwagula mweye na isi yenu kuwa mali ya mfalume. Zino hano mbeyu muzihande muna iisi yenu. ");
INSERT INTO cwe_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Izakuwa chipindi cha kugobola, mwizamwing'ha mfalume chinhu chimwe muna ivinhu vitano na vinhu vine muna ivinhu vitano vizakuwa venu mweye wenyewo. Iwe mbeyu ya isi na ndiya yenu na wanhu wa mwiikaye yenu na wanenu iwadododo.” ");
INSERT INTO cwe_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nawo wamwidika, “Kuukombola ugima wetu, na kulagusa unovu wako na cheye chizakuwa watumwa wa mfalume.” ");
INSERT INTO cwe_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yosefu kaditenda dino lagilizo kwa isi ya Misili kuwa hanhu ha tano ni mali ya mfalume. Lagilizo dino disigala mbaka diyelo. Mbali zisi za wakulu wa nhambiko muhala haziwile mali ya mfalume bule. ");
INSERT INTO cwe_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Waisilaili wakala wokala mkowa wa Gosheni muna iisi ya Misili, wapata utajili na wana wengi na wongezeka. ");
INSERT INTO cwe_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo kakala Misili miyaka longo na saba, mbaka viyawile na miyaka gana na malongo mane na saba. ");
INSERT INTO cwe_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Isilaili viyakalile habehi kudanganika, kamtanga Yosefu mwanage na kamulongela, “Lelo fana weye konogelwa na niye, ika mkono wako hasi ya diwambo jangu na unilaganile kuwa kwizanitendela kwa unovu na voilondeka, hwizaniwanda muna iisi ya Misili bule. ");
INSERT INTO cwe_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nolonda niwandigwe howawandigwe tati zangu, unipape kulawa muna iisi ya Misili na uniwande kuna yamaleme yowawandigwe wawo.” Yosefu kamwidika, “Nizatenda fana voulonga.” ");
INSERT INTO cwe_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobo kamulongela, “Ilahe kwa yayo youlongile.” Yosefu kamulahila, maabaho Isilaili kainamila ubanzi wa ditwi da komwa jake. ");
INSERT INTO cwe_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Viyafosile yayo Yosefu kalongeligwa kuwa tati yake kolumwa. Ivo kawasola wanage waidi wa chilume, Manase na Efulaimu, na kahita kumulola Yakobo. ");
INSERT INTO cwe_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo viyamulongele kuwa mwanage Yosefu keza kumulola, Isilaili kaigangamiza na kadundumala muna dikomwa. ");
INSERT INTO cwe_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo kamulongela Yosefu, “Mulungu mwene Udaho kanilawilila uko Luzu kuna isi ya Kanaani na kanitemela mate. ");
INSERT INTO cwe_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kanilongela, ‘Nizakongezela wana wengi, na welesi wake wizakuwa kabila kulu, nizaweng'ha welesi wako isi ino kuwa yawo siku zose.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakobo kagendelela kulonga, “Wanago waidi wouwapatile hano Misili ning'hali sinafika, ni wanangu. Efulaimu na Manase wezakuwa wangu fana viya viweli Lubeni na Simeoni. ");
INSERT INTO cwe_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","One uhawa na wana wamwenga wengi, hawezakuwa wangu bule, uhazi wondawapate wizalawa kwa Efulaimu na Manase. ");
INSERT INTO cwe_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Vinikalile nobwela kulawa Padani, Laheli kadanganika muna iisi ya Kanaani, siyo ugenzi mtali kufika Efulata. Nimuwanda baho hamgwazo wa dikulugumbi dihita Efulata, sambi yotangigwa Betelehemu.” ");
INSERT INTO cwe_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isilaili viyawawonile wana wa Yosefu, kauza, “Wabwanga wano ni welihi?” ");
INSERT INTO cwe_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosefu kamwidika, “Wano ni wanangu, woyaning'hile Mulungu hano Misili.” Yakobo kalonga, “Nikwenhusile habehi muladi nidahe kuwatemela mate.” ");
INSERT INTO cwe_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Meso ya Yakobo yakala hayalola kwa ichimu cha ulala. Ivo Yosefu kawakwenhusa wanage habehi na tati yake, na Yakobo kawahagatila na kawanonela. ");
INSERT INTO cwe_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isilaili kamulongela Yosefu, “Sigesile bule kuwona chihanga chako kaidi, mbali humbe Mulungu kanogela mbaka kuwawona wanago.” ");
INSERT INTO cwe_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Maabaho Yosefu kawasegeza wanage hana yamavindi ya tati yake na katumbala mavindi mbaka chihanga chake chidalisa hasi. ");
INSERT INTO cwe_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yosefu kaweka wanage wose waidi, Efulaimu kuna umkono wake wa kulume kusonhela mkono wa kumoso wa Isilaili, na Manase kuna umkono wake wa kumoso kusonhela mkono wa kulume wa Isilaili. Kawakwenhusa habehi nayo. ");
INSERT INTO cwe_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mbali Isilaili kayafosesaza yamakono yake, mkono wa kulume kawika mditwi da Efulaimu, ingawa kakala mdodo na mkono wake wa kumoso kawika mditwi da Manase yoyakale chaudele. ");
INSERT INTO cwe_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Maabaho Isilaili kamtemela mate Yosefu kalonga, “Mulungu ija tati zetu Bulahimu na Isaka wakala fana viyolonda muna ugima wawo, Mulungu yoyanidimile muna uugima wangu mbaka diyelo, ");
INSERT INTO cwe_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Msenga wa kuulanga ija yoyanikombole niye muna yehile yose, yawatemele mate wabwanga wano! Wezatangigwa wanangu kwa ludongo lwa welesi wa Bulahimu na Isaka na wongezeke kwa wingi muna iisi.” ");
INSERT INTO cwe_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosefu viyawone kuwa tati yake kawika mkono wake wa kulume kuna iditwi da Efulaimu, hanogelwe bule. Ivo kawamha mkono wa tati yake kalonda kuusegeza uchanyha ya ditwi da Efulaimu, yawike kuna iditwi da Manase. ");
INSERT INTO cwe_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yosefu kamulongela tati yake, “Siyo ivo tata. Ino niiyo chaudele, mwikile mkono wako wa kulume muna iditwi jake.” ");
INSERT INTO cwe_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mbali tati yake kalema, kalonga, “Novimanya mwanangu, novimanya. Welesi wa Manase iviya wezakuwa wanhu wakulu. Mbali mdodo wake kezakuwa mkulu kufosa yeye, na welesi wake wezakuwa makabila makulu.” ");
INSERT INTO cwe_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ivo kawatemela mate siku ijo na kalonga, “Waisilaili wezasang'hanila mazina yenu kutemela mate, wezalonga, ‘Mulungu yakutende weye fana Efulaimu na Manase.’ ” Niivo Yakobo viyamwikile Efulaimu haulongozi wa Manase. ");
INSERT INTO cwe_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Baho Isilaili kamulongela Yosefu, “Fana viya viuwona kuwa niye nahabehi kudanganika, mbali Mulungu kezakuwa na mweye na kuwasola kuwabweleza muna iisi ya wasaho zenu. ");
INSERT INTO cwe_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Niye nikwing'ha weye siyo ndugu zako hanhu hotangigwa Shekemu na vinhu vonisolile muna yamakono ya Waamoli kwa upanga wangu na uta wangu.” ");
INSERT INTO cwe_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakobo kawatanga wanage na kalonga, “Iduganyeni hamwe, na nizamulongelani yaja yondayamulawilileni siku zikwiza.” ");
INSERT INTO cwe_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Izoni hamwe na mutegeleze, wana wa Yakobo. Munitegeleze tati yenu Isilaili.” ");
INSERT INTO cwe_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Lubeni, chaudele wangu, nguvu yangu Na mwana wa mwanduso wa ubwanga wangu, Mwene udahi na nguvu.” ");
INSERT INTO cwe_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Weye fana viya mazi yamemile, Mbali hwizakuwa wa mwanduso kaidi bule, Kwaviya kugona muna dikomwa jangu na kumbandama mtumwa wangu, yalingile fana muke wengu hudihishimu komwa da tati yako. ");
INSERT INTO cwe_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni na Lawi ni ndugu. Wosang'hanila silaha zawo kutenda usede. ");
INSERT INTO cwe_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mbali niye sizaihanganya muna uwihi wawo, Sizaihanganya na mting'hano wawo, Kwaviya muna uludoko lwawo wamkoma munhu, Chiutundu wawo wakanha umuge wa ng'ombe. ");
INSERT INTO cwe_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Noduwila ludoko lwawo kwaviya lukali ng'hani, Na muna ing'hasiliki yawo, kwaviya ni usede. Nizawagola muna iisi ya Yakobo. Nizawapwililisa muna iisi ya Isilaili.” ");
INSERT INTO cwe_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, wana wa tati yako wezakutogola. Wehi wako kwizawanyoda singo. Wana wa tati yako wezatumbala mavindi haulongozi hako. ");
INSERT INTO cwe_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda mwanangu, kulinga fana simba, yoyapatile maingo yake na kabwela ukaye, Fana simba koigolola na kugona hasi, simba yeli na ludabwa yelihi yoyodaha kumulamusa? ");
INSERT INTO cwe_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda kezakwamha mhome ya chifalume, Welesi wake wizatawala siku zose. Mbaka vondayeze yeli na udahi wa ufalume Mbaka makabila wezamtegeleza. ");
INSERT INTO cwe_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Komfunga chihongwe wake kwa nzabi muna umbiki wa zabibu na komfunga mwanachihongwe kwa nzabi muna umbiki wa zabibu unogile, muladi yaje mayani ya mzabibu. Kofuwa viwalo vake muna idivai, Viwalo vake muna idivai ndung'hu. ");
INSERT INTO cwe_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Meso yake yawe na madung'hu fana divai na meno yake yawe mazelu fana matombo.” ");
INSERT INTO cwe_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabuloni kezakala habehi na bahali. Kezasigamiza meli yake muna ingema Mbaka yake izahakana na Sidoni.” ");
INSERT INTO cwe_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakali kalinga fana chihongwe mwene nguvu, Yoyoigoneza hagati ya zimbahasha zake. ");
INSERT INTO cwe_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mbali kowona kuwa hanhu ha kuhumula hanoga, Na kuwa isi iviya ni ya kunogeza. Konamiza mgongo wake kupapa mbahasha, Na kowangilizigwa kusang'hana usang'hano fana mtumwa. ");
INSERT INTO cwe_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani kezakuwa msemi kwa wanhu wake fana imwe ng'holo za makabila ya Isilaili. ");
INSERT INTO cwe_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani kezakuwa nyoka muna inzila, Nyoka yeli na sumu mumgwazo wa nzila, Yoyoluma visigino va vihongwe, Yokwela chihongwe kogwa chingalingali. ");
INSERT INTO cwe_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Mndewa Mulungu niugozela ukombola wako.” ");
INSERT INTO cwe_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi kezatowigwa na mabeduwi, Mbali yeye kezawasondelela kuchisogo na kuwatowa.” ");
INSERT INTO cwe_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Isi ya Asheli izalava ndiya ya inogile. Nayo kezalava ndiya yoimfaya mfalume.” ");
INSERT INTO cwe_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafutali fana viya mbuguma ya mhala, yoyokweleka wana wanogile. ");
INSERT INTO cwe_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosefu ni fana mbiki ukwima, mbiki ukwima mwiingema ya nzasa, matambi yake yatanda muna inhumba. ");
INSERT INTO cwe_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Watowa misale wamtowa ng'hani Na wampigisila misale na wamgaza ng'hani. ");
INSERT INTO cwe_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mbali upinde wake ung'hali ugangamala Makono yake yana udahi, Kwa udahi wa Mndewa Mulungu wa Yakobo, Mdimi na luwe lwa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Kwa Mulungu wa tati yako yondayakutaze Kwa Mulungu mwene Udaho yondayakutemele mate Yakutemele mate kwa mvula kulawa kuchanyha Kutemiligwa mate mazi yoyolawa hasi mwiisi, Kutemiligwa mate kweleka wana na fugo, ");
INSERT INTO cwe_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Kutemeligwa mate kwa tati yako kuhume kutemiligwa mate kwa migongo ya umwaka, Kutemiligwa mate uko kuwe uchanyha ya ditwi da Yosefu, uchanyha ya ditwi jake yeli mkulu kufosa ndugu zake.” ");
INSERT INTO cwe_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini ni mbwizi mkali. Imitondo koja maingo yake na ichigulogulo kogola viyahokile.” ");
INSERT INTO cwe_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Izo niizo ng'holo longo na maidi ya Isilaili, na izo niizo zimbuli ziyawalongele tati yawo iyawatemele mate, fana viya chila munhu viyalondeke. ");
INSERT INTO cwe_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Maabaho Yakobo kawalagiliza wanage wa chilume vino, “Lelo niye nohita kwiilumba na wanhu wangu muna ifa, muniwande hamwe na tati zangu muna dituka muna umgunda wa Efiloni Muhiti ");
INSERT INTO cwe_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","kuja Makipela ulawilo wa zuwa wa Mamule mwiisi ya Kanaani. Bulahimu kagula tuka ijo na mgunda kwa Efiloni Muhiti diwe hanhu hake ha kuwandila. ");
INSERT INTO cwe_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Uko niuko kuwawandigwe Bulahimu na muke wake Sala, iviya uko niuko kuwawandigwe Isaka na muke wake Lebeka, iviya uko niuko nimuwandile Leya. ");
INSERT INTO cwe_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mgunda na tuka dili umo viguligwa kulawa kwa Wahiti.” ");
INSERT INTO cwe_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo viyakomeleze kuwalagiliza wanage, kayabweleza magulu yake mdikomwa, na kadanganika kaihanganya na walala wake wowamulongolele. ");
INSERT INTO cwe_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Maabaho Yosefu kalila na kamuhagatila tati yake na kamnonela. ");
INSERT INTO cwe_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Maabaho Yosefu kawalagiliza waganga wake wamuhake dawa Isilaili muladi sekeyawole, nawo watenda ivo. ");
INSERT INTO cwe_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Isola siku malongo mane, lusita luzoweleke kwa kwika dawa. Wamisili wamulilila kwa siku malongo saba. ");
INSERT INTO cwe_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Nhanga viikomelezeke, Yosefu kawalongela iwakulu wa mfalume, “One nihamnogezani, nolamba soleni usenga uno muugale kwa mfalume, ");
INSERT INTO cwe_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tati yangu viyakalile habehi na kudanganika, kanikila lagano kumuwanda muna dituka doyasasale muna iisi ya Kanaani. Ivo lekeni nihite nikamuwande tati yangu na maabaho nizabwela.’ ” ");
INSERT INTO cwe_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Mfalume kamwidika, “Hita ukamuwande tati yako, fana viuilagane nayo.” ");
INSERT INTO cwe_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ivo Yosefu kahita kumuwanda tati yake. Wakulu wose wa kaye ya mfalume na walala wa kaye ya mfalume na walala wose wa isi ya Misili wahita hamwe na Yosefu. ");
INSERT INTO cwe_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Iviya Yosefu kaisondelela na wanhu wa muna ikaye yake na ndugu zake na wanhu wose weli muna ikaye ya tati yake Yakobo. Muna umkowa wa Gosheni wasigala wana wawo muhala hamwe na ng'hondolo na luti na ng'ombe wawo. ");
INSERT INTO cwe_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wanhu wokwendesha mituka na wanhu wokwela vihongwe iviya wahita hamwe nayo, dikala bumbila kulu. ");
INSERT INTO cwe_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Viwafikile hanhu ha kuhululila nafaka wa Atadi, ulawilo wa zuwa wa ulwanda lwa Yoludani, walila kwa luholozi kwa lusita lukulu, na Yosefu kamtendela mwenekwaga tati yake matanga ya siku saba. ");
INSERT INTO cwe_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wakaya wa mabululu ya Kanaani viwawonile wanhu wotenda matanga halubuga lwa Atadi, walonga, “Matanga yano ya Wamisili ni makulu.” Kwa ivo hanhu baho hatangigwa Abeli Misili ili umwambu wa lwanda lwa Yoludani. ");
INSERT INTO cwe_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Wana wa Yakobo wamtendela tati yawo fana viyawalagilize, ");
INSERT INTO cwe_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","wausola ulukuli lwake mbaka isi ya Kanaani na wamuwanda muna dituka dodikalile muna umgunda uko Makipela, ulawilo wa zuwa wa Mamule, muna umgunda Bulahimu woyaugulile kulawa kwa Efiloni Muhiti hawe hanhu ha kuwandila. ");
INSERT INTO cwe_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosefu viyakomeleze kumuwanda tati yake, kabwela Misili hamwe na ndugu zake na wanhu wose wowakalile waisondelela nayo kuhita kumuwanda tati yake. ");
INSERT INTO cwe_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Viwawone tati yawo kadanganika, ndugu zake Yosefu walonga, “Yodahika Yosefu kezachihila na kezachiliha yehile yose yochimtendele?” ");
INSERT INTO cwe_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ivo wamtumila usenga Yosefu na kumulongela “Tati yako kachasila usenga yang'hali hanadanganika, ");
INSERT INTO cwe_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","mulongeleni Yosefu vino, ‘Nolamba uwalekelele ndugu zako wihi wawo na uhasanyi wawo, kwaviya wakutendela yehile.’ Lelo chokulamba uchilekelele wihi, wasang'hani wa Mulungu wa tati yako.” Yosefu viyauhokele usenga uwo kalila. ");
INSERT INTO cwe_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Maabaho ndugu zake Yosefu wamwizila na wamtumbalila mavindi na walonga, “Cheye hano cha watumwa wako.” ");
INSERT INTO cwe_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mbali Yosefu kawalongela, “Sekemudumbe, vino niye ni Mulungu? ");
INSERT INTO cwe_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mweye mwiilunga kunitendela yehile, mbali Mulungu kailungila yanogile, muladi wanhu wengi wadahe kuwa wagima fana viya vimuwona diyelo chochilawilile. ");
INSERT INTO cwe_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Sekemudumbe. Nizaweka goya mweye na wanenu.” Ivo kawaguma moyo kwa kulonga nawo mbuli zinogile. ");
INSERT INTO cwe_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosefu kagendelela kukala muna iisi ya Misili hamwe na kaye ya tati yake. Yosefu viyadanganike kakala na miyaka gana na kumi. ");
INSERT INTO cwe_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosefu kanogelwa kuwawona wana na wazukulu wa Efulaimu na kuwahokela fana viya wanage wana wa Makili mwana wa Manase. ");
INSERT INTO cwe_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosefu kawalongela ndugu zake, “Niye nahabehi kudanganika, mbali Mulungu kezawezila na kwika goya na kezawalava muna iisi ino na kuwagala muna iisi yoyawalahile Bulahimu na Isaka na Yakobo.” ");
INSERT INTO cwe_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Hamala baho Yosefu katenda chilaho kwa wana wa Isilaili kulonga, “Nilaganileni kuwa Mulungu vondayawasegezeni muna iisi ino, mwizaipapa mivuha yangu kulawa hanhu hano.” ");
INSERT INTO cwe_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ivo Yosefu kadanganika uko Misili yahawa na miyaka gana na longo. Waluboboda dawa lukuli lwake na walwika muna disanduku muladi sekeluwole.");
INSERT INTO cwe_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yano ni mazina ya wana wa Yakobo yoyatangigwe Isilaili wowahitile Misili hamwe nayo, ");
INSERT INTO cwe_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Lubeni na Simeoni na Lawi na Yuda‚ ");
INSERT INTO cwe_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakali na Zabuloni na Benjamini na ");
INSERT INTO cwe_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani na Nafutali na Gadi na Asheli. ");
INSERT INTO cwe_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Welesi wose wa Yakobo ukala malongo saba‚ lusita ulwo Yosefu kakala yokala uko Misili. ");
INSERT INTO cwe_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Maabaho hamwande Yosefu kadanganika, iviya na ndugu zake na welesi wose wadanganika‚ ");
INSERT INTO cwe_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Mbali welesi wa Isilaili wakala wokweleka na kongezeka ng'hani‚ wakala wengi ng'hani na wagendelela kongezeka ludabwa, ivo isi ija ya Misili ikala wenela wawo. ");
INSERT INTO cwe_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Maabaho kalawilila mfalume wa imwenga‚ kuitawala Misili yohammanyile Yosefu. ");
INSERT INTO cwe_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kawalongela wanhu wake‚ “Loleni wanhu wa Isilaili ni wengi ng'hani na wana ludabwa kufosa cheye. ");
INSERT INTO cwe_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Cholondeka chizahile nzila ya ubala sekewongezeke, one siivo, ihalawilila ng'hondo wezailumba na wehi wetu na kuitowa na cheye na kusegela mwiisi.” ");
INSERT INTO cwe_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ivo Wamisili waweka wemilizi wawemilize Waisilaili na kuwagaza kwa sang'hano ndala ya kumzengela mfalume wa Misili mabululu ya ngama uko Pisomo na Lamasesi. ");
INSERT INTO cwe_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mbali kwaviya Wamisili viwawagazile Waisilaili, niivo viwongezeke na kwenela. Wamisili wawadumba Waisilaili, ");
INSERT INTO cwe_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","na wawatendela usede wanhu wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wautenda ugima wawo wihe kwa sang'hano ndala, sang'hano ya kutenda chokaa na kutengeneza matafali na sang'hano zose za muna imigunda. Sang'hano izo zose, Waisilaili wasang'haniligwa kwa usede. ");
INSERT INTO cwe_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Maabaho mfalume wa Misili kawalongela walala wowataza wanaake wa Chiebulaniya kweleka, imwe zina jake katangigwa Shifila na wekaidi zina jake katangigwa Pua. ");
INSERT INTO cwe_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Kawalongela, “Muhawataza wanaake wa Chiebulaniya kuna ukuibasula‚ one yahavumbuka mwana wa chilume mkomeni, mbali one yahavumbuka mwana wa chike mulekeni.” ");
INSERT INTO cwe_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mbali walala wamdumba Mulungu na hawatendile fana viyawalagilize mfalume wa Misili‚ wawaleka wana wa chilume wakale. ");
INSERT INTO cwe_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Maabaho mfalume wa Misili kawatanga walala waja na kawauza‚ “Habali mutenda vino? Habali muwaleka wana wa chilume wakale?” ");
INSERT INTO cwe_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Walala wawo wamwidika mfalume wa Misili‚ “Wanaake wa Chiebulaniya hawalingile fana wanaake wa Chimisili bule, woibasula himahima, na wana wawo wokwelekigwa yang'hali mulala hanafika.” ");
INSERT INTO cwe_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ivo Mulungu kawatendela yanogile walala wawo, na wanhu wongezeka ng'hani, wagendelela kuwa na ludabwa ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Na kwaviya walala wawo wamdumba Mulungu, Mulungu kaweng'ha welesi wawo wenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Maabaho mfalume wa Misili kawalagiliza wanhu wake wose, “Chila mwana wa chilume yondayelekwe kwa Waebulaniya yasigwe muna ulwanda lwa Naili, mbali chila mwana wa chike mulekeni.” ");
INSERT INTO cwe_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Siku izo munhu kulawa kabila da Lawi kasola muke wa kabila jake mwenyewo, ");
INSERT INTO cwe_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","nayo kapata wimo na kaibasula mwana wa chilume. Viyamuwone kuwa kakala mwana yanogile ng'hani‚ kamfisa kwa miyezi mitatu. ");
INSERT INTO cwe_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mbali viyapotwile kumfisa kampatila chigelo cha mayani na kachibulugiza tulasi‚ kamwika mgati yake na kuchika hana yamayani yokota muna ulwanda lwa Naili. ");
INSERT INTO cwe_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Lumbu jake imwana kema hatali hainzila muladi yadahe kulola chiya chondachimulawilile. ");
INSERT INTO cwe_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mwana wa chike wa mfalume wa Misili kahumuluka kuulwanda yoge‚ na wasang'hani wake wakala wogenda genda mumgwazo ya ulwanda. Viyawone ichigelo muna yamakengega‚ kamtuma msang'hani wa chike yachisole. ");
INSERT INTO cwe_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kachivugula na kawona mwana wa chilume. Kakala kolila, ivo kamuwonela ubazi na kalonga, “Ino ni imwe wa wana wa Chiebulaniya.” ");
INSERT INTO cwe_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Maabaho lumbu wa imwana kamuuza mndele wa mfalume wa Misili‚ “Nihite nikamtange muke wa kumong'heza imwana mwa wanaake wa Chiebulaniya?” ");
INSERT INTO cwe_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mndele wa mfalume wa Misili kamwidika. “Wona.” Ivo imndele kahita na kamgala mami yake imwana. ");
INSERT INTO cwe_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mndele wa mfalume wa Misili kamulongela mwanamke ija, “Msole imwana ino unyong'hezele, nizakuliha.” Ivo mwanamke ija kamsola imwana kamong'heza. ");
INSERT INTO cwe_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Hamwande mwana viyakulile kamgala kwa mndele wa mfalume wa Misili‚ nayo kamtenda kuwa mwanage. Mndele wa mfalume kalonga, “Nimulava muna yamazi.” Ivo kamtanga zina jake Musa. ");
INSERT INTO cwe_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Siku izo Musa viyakulile kahita kuwalaula ndugu zake Waebulaniya na kulola sang'hano zawo ndala ziwotenda. Kawona Mmisili komtowa Muebulaniya, imwe wa ndugu zake. ");
INSERT INTO cwe_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa kalola banzi zose‚ na viyawone kuwa habule munhu yomuwona‚ kamkoma Mmisili ija na lukuli lwake kalufisa muna umsanga. ");
INSERT INTO cwe_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Igolo yake kahita kaidi na kawona Waebulaniya waidi woitowa. Kamulongela ija yabanange, “Habali komtowa Muebulaniya miyago?” ");
INSERT INTO cwe_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Munhu ija kamwidika, “Yelihi yakutendile weye kuwa mtawala wetu na msemi? Vino kolonda unikome fana viya viumkomile Mmisili ija?” Maabaho Musa kadumba na kaiuzagiza mwenyewo, “Vino wanhu wavimanya chiya chinitendile?” ");
INSERT INTO cwe_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Mfalume viyahulike yaja yalawilile, kalonda kumkoma Musa, mbali Musa kambanga mfalume wa Misili na kahita kukala muna isi ya Midiani. Siku dimwe Musa kakala hamgwazo wa disima. ");
INSERT INTO cwe_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Mkulu wa nhambiko wa Midiani kakala na wandele saba, nawo weza kudeha mazi. Wamemeza mbaluti muladi wadahe kuwang'wiza ng'hondolo na luti wa tati yawo. ");
INSERT INTO cwe_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Wadimi weza na wawawinga wandele waja saba, mbali Musa kema na kuwataza kuding'wiza bumbila da wanyama wawo. ");
INSERT INTO cwe_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Viwabwelile kwa tati yawo Leueli‚ kawauza‚ “Habali diyelo hamkalame bule kubwela?” ");
INSERT INTO cwe_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wamwidika‚ “Mmisili kachilopola na wadimi‚ na iviya kachidehela mazi na kung'wiza wanyama wetu.” ");
INSERT INTO cwe_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kawauza wandele wake, “Munhu iyo kakulihi?” “Habali mumuleka uko munhu iyo? Hiteni mukamgoneke yaje na cheye.” ");
INSERT INTO cwe_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa katogola kukala haja, Yesilo kamwing'ha Musa mndele wake yatangigwe Sipola yamsole. ");
INSERT INTO cwe_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipola kamwelekela mwana wa chilume. Musa kailongela mwenyewo‚ “Nitogoligwa kukala muna iisi iyo ya manyambenyambe.” Ivo kamtanga mwana iyo zina Gelishomu. ");
INSERT INTO cwe_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Viifosile miyaka mingi mfalume wa Misili kadanganika‚ mbali Waisilaili wakala wang'hali muna utumwa na wolilila kutazigwa. Kugutilila kwawo kumfikila Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mulungu kahulika ndilo yawo na kakumbuka lagano diyekile na Bulahimu na Isaka na Yakobo. ");
INSERT INTO cwe_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Mulungu kawalola Waisilaili na kavimanya viya viwogaya. ");
INSERT INTO cwe_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Siku dimwe Musa viyakalile yodima ng'hondolo na luti wa Yesilo mkoi wake‚ mkulu wa nhambiko wa Midiani, kadilanguliza bumbila kufosa uswelo wa zuwa muna ichuwala kuhita Holebu‚ kuna mulima wa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Msenga wa Mndewa Mulungu kamulawilila Musa muna dilambi da moto muna ichibago. Musa kawona ichibago chokwaka moto mbali hachitakamile. ");
INSERT INTO cwe_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa kalonga, “Yano mauzauza, habali chibago chokwaka moto na hachitakamila? Nizachikwenhukila nikachilole.” ");
INSERT INTO cwe_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mndewa Mulungu viyawone kuwa Musa kokwenhuka habehi, kamtanga kulawa hagati ya ichibago na kalonga, “Musa! Musa!” Musa kamwidika “Wona, nabaha.” ");
INSERT INTO cwe_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mndewa Mulungu kamulongela‚ “Sekeukwenhuke habehi. Vula vilatu vako, kwaviya howimile ni hanhu helile.” ");
INSERT INTO cwe_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Maabaho kalonga, “Niye ni Mulungu wa wasaho zako‚ Mulungu wa Bulahimu na Isaka na Yakobo.” Ivo Musa kaigubika chihanga chake‚ kwaviya kadumba kumulola Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Maabaho Mndewa Mulungu kalonga‚ “Kweli niyawona manhesa ya wanhu wangu weli muna iisi ya Misili. Nihulika ndilo yawo kwa ichimu cha wemilizi wa Misili. Niumanya usungu wawo. ");
INSERT INTO cwe_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ivo nihumuluka muladi niwakombole muna imikono ya Wamisili‚ nizawalava umo na kuwagala kuna isi ino inogile na ng'hulu, isi ili na ulongo unogile‚ isi ya Wakanaani na Wahiti na Waamoli na Wapelizi na Wahivi na Wayebusi. ");
INSERT INTO cwe_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Lelo kulila kwa wanhu wangu Waisilaili kunifikila niye. Niwona viya Wamisili viwowagaza. ");
INSERT INTO cwe_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Lelo hita nokutuma kwa mfalume wa Misili muladi ukawalave wanhu wangu wana Isilaili muna iisi ya Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mbali Musa kamulongela Mulungu‚ “Niye yelihi mbaka nidahe kuhita kwa mfalume wa Misili na kuwalava Waisilaili muna iisi ya Misili?” ");
INSERT INTO cwe_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Mulungu kamulongela‚ “Nizakuwa hamwe na weye. Na chino chizakuwa chilaguso kuwa niye iyo nikutumile. Vondauwalave wanhu muna iisi ya Misili, kwizamtambikila Mulungu muna mulima uno.” ");
INSERT INTO cwe_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa kamulongela Mulungu‚ “One nihahita kwa wanhu wa Isilaili na kuwalongela‚ ‘Mulungu wa wasaho zenu kanhuma kumwenu‚’ nawo wezaniuza‚ ‘Zina jake nani?’ Niwalongeleze?” ");
INSERT INTO cwe_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mulungu kamulongela Musa‚ “NIYE IYO NIYE.” Na kalonga, “Walongele vino wanhu wa Isilaili‚ ‘Ija iwomtanga IYO NIYE kanhuma kumwenu.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Iviya Mulungu kamulongela Musa, “Walongele Waisilaili‚ ‘Mndewa Mulungu, Mulungu wa wasaho zenu na Mulungu wa Bulahimu na Mulungu wa Isaka na Mulungu wa Yakobo‚ kanhuma kumwenu.’ Dino ijo zina jangu siku zose, dizakumbukigwa kwa welesi wose.” ");
INSERT INTO cwe_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Hita na ukawating'hanize hamwe walala wa Isilaili na uwalongele‚ Mndewa Mulungu, Mulungu wa wasaho zenu na Mulungu wa Bulahimu na wa Isaka na wa Yakobo, kanilawilila na kanilongela, “Niyawona yaja yomutendeligwa uko Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Na nimulaganilani kuwa nizamulavani muna yamanhesa yenu uko Misili na kuwengiza muna iisi ya Wakanaani na Wahiti na Waamoli na Wapelizi na Wahivi na Wayebusi‚ isi ili na ulongo unogile. ");
INSERT INTO cwe_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Walala wa Isilaili wezakutegeleza, maabaho weye na walala wa Isilaili mwizahita kwa mfalume wa Misili na kumulongela, ‘Mndewa Mulungu, Mulungu wa Waebulaniya, kaiting'hana na cheye. Lelo chokulamba chilekelele chigende muna ichuwala siku nhatu muladi chikamulavile nhambiko Mulungu wetu.’ ");
INSERT INTO cwe_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Novimanya kuwa mfalume wa Misili hezawalekela muhite mbaka yahavimanya kuwa niye nina nguvu kufosa yeye. ");
INSERT INTO cwe_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mbali nizasang'hanila nguvu zangu kuwatagusa Wamisili kwa kutenda vinhu va mauzauza haja. Hamwande kezamulekelani muhite. ");
INSERT INTO cwe_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Nizawatenda Wamisili wanoge kumwenu muladi vondamusegele‚ sekemusegele makono muhala. ");
INSERT INTO cwe_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Chila mwanamke wa Chiisilaili kezampula mkaya miyage na ija yokala nayo muna ikaye yake yamwing'he via va hela na via va zahabu hamwe na mawalo. Mwizawavaza wanenu wa chike na wa chilume. Vino niivo vondamusole vinhu va Wamisili.” ");
INSERT INTO cwe_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Maabaho Musa kamwidika Mndewa Mulungu, “Mbali Waisilaili hawezanihuwila na hawezanitegeleza, mana wezalonga, ‘Mndewa Mulungu hakulawilile bule.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Mndewa Mulungu kamuuza Musa‚ “Icho choni chiwamhile mumkono wako?” Musa kamwidika “Balati.” ");
INSERT INTO cwe_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mndewa Mulungu kamulongela‚ “Ilagaze hasi.” Ivo kailagaza hasi na igaluka iwa zoka. Musa kakimbila. ");
INSERT INTO cwe_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Maabaho Mndewa Mulungu kamulongela Musa‚ “Golosa mkono wako ujamhe umkila.” Ivo kagolosa mkono wake kajamha, na digaluka mhome kaidi muna umkono wake. ");
INSERT INTO cwe_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mndewa Mulungu kamulongela, “Kwa kutenda vino Waisilaili wezahuwila kuwa Mndewa Mulungu, Mulungu wa wasaho zawo na Mulungu wa Bulahimu na Mulungu wa Isaka na Mulungu wa Yakobo, kakulawilila.” ");
INSERT INTO cwe_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Mndewa Mulungu kamulongela Musa mwanza wekaidi‚ “Ika mkono mudiwalo jako.” Musa keka mkono wake muna diwalo, viyaulavile‚ ugaluka mzelu fana munhu yeli na utamu wa mbende. ");
INSERT INTO cwe_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Maabaho Mndewa Mulungu kamulongela‚ “Ika mkono wako muna diwalo kaidi.” Katenda ivo‚ viyaulavile, ukala mgima, fana mbende yake imwenga. ");
INSERT INTO cwe_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Maabaho Mndewa Mulungu kamulongela‚ “One hawakuhuwile hebu kutogola chilaguso cha mauzauza cha mwanduso, yodahika chilaguso cha mauzauza chino chekaidi wezachitogola. ");
INSERT INTO cwe_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Mbali one hawahuwile vilaguso vino vidi hebu kukutegeleza‚ sola mazi kulawa muulwanda lwa Naili na yetile muna iisi inyalile‚ mazi yondauyadehe kulawa muulwanda yezagaluka damu muna iisi.” ");
INSERT INTO cwe_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa kamulongela Mndewa Mulungu, “Nokulamba Mndewa, niye sidaha kulonga goya kwandusila mwaka‚ hata kusongela baho viulongile na niye msang'hani wako, kwaviya niye sidaha kulonga goya, na lulimi lwangu luzama.” ");
INSERT INTO cwe_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Mndewa Mulungu kamulongela‚ “Yelihi yaumbile mulomo wa munhu? Hebu yelihi yomtenda munhu yawe chibubu hebu msuwamagutwi? Yelihi yomtenda munhu yalole hebu yawe chipofu? Vino siyo niye Mndewa Mulungu? ");
INSERT INTO cwe_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Lelo hita, nizakutaza kulonga na kukufunza mbuli za kulonga.” ");
INSERT INTO cwe_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mbali Musa kamwidika‚ “Mndewa, nolamba umtume munhu imwenga.” ");
INSERT INTO cwe_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ludoko lwa Mndewa Mulungu lumwakila Musa na kalonga‚ “Vino kahabule sekulu wako Haluni‚ ija Imulawi? Nivimanya kuwa yeye kodaha kulonga vinogile. Kweli, kokwiza kuiting'hana na weye na vondayakuwone kezadeng'helela. ");
INSERT INTO cwe_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Weye kwizalonga nayo na kumulongela yose yondayalonge, niye nizawatazeni na kuwafunza mbuli zondamutende. ");
INSERT INTO cwe_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Haluni kezakuwa mulonzi wako na kezawalongela wanhu kwa ichimu chako. Weye kwizakuwa fana mulungu kumwake. ");
INSERT INTO cwe_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Sola balati dino muna umkono wako muladi udahe kutenda vilaguso va mauzauza.” ");
INSERT INTO cwe_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Maabaho Musa kabwela kaidi kwa Yesilo, mkoi wake‚ na kumulongela. “Nokulamba nilekelele nibwele kwa ndugu zangu uko Misili nikawalole fana wang'hali wagima.” Yesilo kamulongela Musa, “Hita kwa tindiwalo.” ");
INSERT INTO cwe_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Lusita Musa viyakalile uko Midiani‚ Mndewa Mulungu kamulongela‚ “Bwela Misili‚ mana waja wose wowalondile kukukoma wadanganika.” ");
INSERT INTO cwe_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa kamsola muke wake na wanage‚ kawakweza muna ichihongwe na kubwela Misili. Kasola mhome ija Mulungu yoyamulongele yaisole. ");
INSERT INTO cwe_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Kaidi Mndewa Mulungu kamulongela Musa‚ “Vondaufike Misili utende haulongozi ha mfalume wa Misili mauzauza yose yonikwing'hile udahi wa kuyatenda. Mbali niye nizautenda moyo wa mfalume wa Misili kuwa mdala, nayo hezawalekela Waisilaili wasegele. ");
INSERT INTO cwe_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Maabaho kolondeka umulongele mfalume wa Misili‚ Mndewa Mulungu kolonga, ‘Isilaili ni mwanangu chaudele. ");
INSERT INTO cwe_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nikulongela umulekele mwanangu yahite‚ muladi yanitambikile, mbali kulema kumulekela yahite, ivo nizamkoma chaudele wako wa chilume.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","“Ikala viwakalile hanhu ha lago mwiinzila kuhita Misili, Mndewa Mulungu kaiting'hana nayo na kageza kumkoma. ");
INSERT INTO cwe_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Maabaho Sipola muke wake, kasola dibwe dikutwa kakanha govi da mwanage, na kumdalisa najo Musa mumgulu na kalonga, ‘Weye kwa mulume wa damu yangu.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Kwa ichimu chino cha mwingizo, Sipola kamulongela Musa, “Weye kwa mulume wa damu yangu.” Kwa ivo Mndewa Mulungu kaulekela ugima wa Musa. ");
INSERT INTO cwe_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mndewa Mulungu kamulongela Haluni, “Hita kuna ichuwala ukaiting'hane na Musa.” Ivo Haluni kahita na waiting'hana kuna mulima wa Mulungu, kamnonela. ");
INSERT INTO cwe_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Maabaho Musa kamulongela Haluni chila chinhu chiyatumigwe na Mulungu kulonga, iviya vilaguso va mauzauza viyamulagilize yatende. ");
INSERT INTO cwe_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa na Haluni wahita Misili na wawaduganya hamwe walala wose wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Haluni kawalongela chila chinhu Mndewa Mulungu choyamulongele Musa. Iviya katenda vilaguso haulongozi ha wanhu, ");
INSERT INTO cwe_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","nawo wahuwila. Viwahulike kuwa Mndewa Mulungu kawezila wanhu wa Isilaili kuwalola viya viwoigaza chiusede, watumbala mavindi na wamtosela Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Maabaho Musa na Haluni wahita kwa mfalume wa Misili na kumulongela‚ “Mndewa Mulungu, Mulungu wa Isilaili‚ kalonga, ‘Walekelele wanhu wangu wahite‚ muladi wakanitendele dugila kuichuwala.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mfalume wa Misili kawalongela‚ “Mndewa Mulungu iyo yelihi mbaka nimtegeleze na kuwalekelela Waisilaili wahite? Simmanyile bule Mndewa Mulungu, na siwalekelela bule Waisilaili wahite.” ");
INSERT INTO cwe_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa na Haluni wamwidika, “Mulungu wa Waebulaniya kachilawilila yeye mwenyewo. Lelo chilekele chigende mwanza wa siku nhatu kuichuwala, chikamulavile nhambiko Mndewa Mulungu, Mulungu wetu. One hachitendile ivo, kezachikoma kwa matamu hebu ng'hondo.” ");
INSERT INTO cwe_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mbali mfalume wa Misili kawalongela‚ “Mweye Musa na Haluni‚ habali mowalekeza wanhu sang'hano zawo? Mweye watumwa wose hiteni kuna zisang'hano zenu! ");
INSERT INTO cwe_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Maabaho mfalume wa Misili kawalongela‚ ‘Loleni‚ lelo wanhu wa isi ni wengi kufosa Wamisili. Molonda kuwalekeza sang'hano zawo!’ ” ");
INSERT INTO cwe_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Siku iyo iyo mfalume wa Misili kawalagiliza wemilizi wa Chimisili na wanyapala wa Chiisilaili, kalonga, ");
INSERT INTO cwe_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Sekemuweng'he wanhu wano mayani ya kutendela matafali fana vimutendaga. Walekeni wahite wakazahile wenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mbali peta ya matafali iwe fana yaja yowakalile wotengeneza mwanduso‚ wekileni iyo iyo na sekemuwahunguzile hata chidogo. Kwaviya wawo ni wabwa wolonga, ‘Chileke chihite chikamulavile nhambiko Mulungu wetu!’ ");
INSERT INTO cwe_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Wongezeni wanhu wano sang'hano ndala muladi wagaye na waleke kuhulika mbuli za uvwizi.” ");
INSERT INTO cwe_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Wemilizi wa Chimisili na wanyapala wa Chiisilaili wahita na kuwalongela Waisilaili‚ “mfalume wa Misili kawalongela kuwa hezaweng'ha mayani. ");
INSERT INTO cwe_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Hiteni wenyewo mkazahile mayani hohose hondamudahe kuyapata‚ mbali molondeka mutende matafali ya peta ija ija.” ");
INSERT INTO cwe_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ivo wanhu wapwililika isi yose ya Misili wozahila mayani yasigale ya kutendela matafali. ");
INSERT INTO cwe_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Wemilizi wawo waiyoha kulonga‚ “Komelezeni sang'hano zenu zimutendaga fana baho umwaka vimukalile mogaliligwa mayani.” ");
INSERT INTO cwe_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Wemilizi wa Chimisili wawatowa wanyapala wa Chiisilaili wowasaguligwe kulola goya sang'hano wahita kwa mfalume wa Misili, walonga, “Habali hamkomeleza sang'hano yenu na kufikiza peta ya matafali ija ija fana ya umwaka?” ");
INSERT INTO cwe_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Maabaho wemilizi wa Chiisilaili weza na kumulilila mfalume wa Misili‚ “Habali kochitendela vino cheye wasang'hani wako? ");
INSERT INTO cwe_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Haching'higwa kaidi mayani yoyose, na kuno chowangilizigwa kutenda matafali. Iviya cheye wasang'hani wako chotowigwa, mbali wabanange wanhu wako.” ");
INSERT INTO cwe_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mfalume wa Misili kalonga‚ “Mweye mwa wabwa, mana hamulonda kusang'hana usang'hano‚ lekamana munipula niwalekelele muhite na kumulavila nhambiko Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Lelo hiteni mkasang'hane usang'hano, mana hamwizakwing'higwa mayani‚ na molondeka kutenda matafali peta ija ija.” ");
INSERT INTO cwe_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Lelo wemilizi wa Waisilaili wawona kuwa wa muna yamagayo, mana walongeligwa, “Hamwizaihunguza peta ya matafali ya chila siku.” ");
INSERT INTO cwe_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Viwasegele kwa mfalume wa Misili‚ wawafika Musa na Haluni wowakalile wowagozela. ");
INSERT INTO cwe_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Wawalongela Musa na Haluni, “Mndewa Mulungu yamuloleni na kuhumiza, kwaviya muchitenda cheye fana china mnung'ho wihile haulongozi ha mfalume wa Misili na wasang'hani wake, mweye muweng'ha chimu cha kuchikoma.” ");
INSERT INTO cwe_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Maabaho Musa kabwela kwa Mndewa Mulungu na kumulongela‚ “Mndewa Mulungu, habali kuwatendela vihile wanhu wano? Habali kunhuma? ");
INSERT INTO cwe_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kwandusila vinihitile na kulonga na mfalume wa Misili kwa zina jako, kawatendela vihile wanhu wano na weye hutendile chochose kuwakombola.” ");
INSERT INTO cwe_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mbali Mndewa Mulungu kamulongela Musa‚ “Sambi kwizawona chondanimtendele mfalume wa Misili. Mana kwa shuluti yangu kezawalekelela wanhu wangu, kwa shuluti kezawawinga muna iisi yake.” ");
INSERT INTO cwe_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mulungu kamulongela Musa, “Niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nimulawilila Bulahimu na Isaka na Yakobo fana viya Mulungu yeli na udahi‚ mbali zina jangu Mndewa Mulungu siditendile dimanyike kumwawo. ");
INSERT INTO cwe_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Iviya nitenda nawo lagano jangu kuwa nizaweng'ha isi ya Kanaani, uko wezakala fana nyambenyambe. ");
INSERT INTO cwe_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Iviya nihulika kulongelela kwa Waisilaili‚ waja Wamisili wawashulutiza kusang'hana sang'hano za chitumwa, ivo nikumbuka lagano jangu. ");
INSERT INTO cwe_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Uwalongele Waisilaili, ‘Niye Mndewa Mulungu! Nizamulavani na kumulekelani kulawa muna utumwa wa Wamisili. Nizawinula mkono wangu wili na ludabwa kuwatagusa Wamisili na nizamkombolani. ");
INSERT INTO cwe_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nizawatendani kuwa wanhu wangu‚ niye nizakuwa Mulungu wenu. Mweye mwizanimanya kuwa niye Mndewa Mulungu, Mulungu wenu yoniwalekelele kulawa kuna uutumwa muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nizamgalani muna iisi ija yoniilahile kuweng'ha Bulahimu na Isaka na Yakobo. Nizamwing'hani mweye iwe yenu‚ niye iyo Mndewa Mulungu.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa kawalongela Waisilaili mbuli ino‚ mbali wawo hawamtegeleze kwaviya wakala wafa moyo kwa ichimu cha utumwa. ");
INSERT INTO cwe_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Maabaho Mndewa Mulungu kamulongela Musa‚ ");
INSERT INTO cwe_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Hita kwa mfalume wa Misili ukamulongele kuwa kolondeka kuwalekelela Waisilaili wasegele muna iisi yake.” ");
INSERT INTO cwe_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mbali Musa kamwidika Mndewa Mulungu‚ “Lola, Waisilaili hawanitegeleze. Lelo mfalume wa Misili kezanitegeleza? Niye sidaha kulonga vinogile!” ");
INSERT INTO cwe_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Mndewa Mulungu kawalagiliza Musa na Haluni‚ “Walongele Waisilaili na mfalume wa Misili kuwa niwalagilizani mweye kuwalava Waisilaili muna iisi ya Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Wano wawo walangulizi wa ng'holo. Lubeni‚ chaudele wa Yakobo kakala na wana wane wa chilume, Henoki na Palu na Heziloni na Kalimi. Wawo wakala lukolo lwa Lubeni. ");
INSERT INTO cwe_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeoni kakala na wana sita wa chilume‚ Yemueli na Yamini na Ohadi na Yakini na Sohali na Shauli, mwana wa mwanamke wa Chikanaani. Wawo wakala wa kaye ya Simeoni. ");
INSERT INTO cwe_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Yano ni mazina ya wana wa chilume wa Lawi na nyelesi zawo‚ fana viili maandiko yawo, Gelishoni na Kohasi na Melali. Lawi kakala miyaka gana na malongo matatu na saba. ");
INSERT INTO cwe_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Wana wa chilume wa Gelishoni wakala Libini na Shimei, nawo wakala na lukolo lwawo. ");
INSERT INTO cwe_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Wana wa chilume wa Kohasi wakala Amilamu na Ishali na Hebuloni na Uzieli. Kohati kakala miyaka gana malongo matatu na nhatu. ");
INSERT INTO cwe_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Wana wa chilume wa Melali wakala Mali na Mushi. Wano wawo mawasaho wa ng'holo za Walawi fana viili maandiko yawo. ");
INSERT INTO cwe_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amilamu kamsola Yokebedi lumbu wa tati yake‚ nayo kamwelekela Haluni na Musa. Amulamu kakala miyaka gana malongo matatu na saba. ");
INSERT INTO cwe_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Wana wa chilume wa Ishali wakala Kola na Nefegi na Zikili. ");
INSERT INTO cwe_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wana wa chilume wa Uzieli wakala Mishaeli na Elisafani na Sisili. ");
INSERT INTO cwe_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haluni kamsola Elisheba mndele wa Aminadabu, iviya kakalalumbu jake Nashoni, nayo kamwelekela Nadabu na Abihu na Eleazali na Isamali. ");
INSERT INTO cwe_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Wana wa chilume wa Kola wakala Asili na Elikana na Abiasafu. Wawo wakala wasaho wa ng'holo za Kola. ");
INSERT INTO cwe_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazali, mwana wa chilume wa Haluni‚ kamsola imwe wa wandele wa Putieli, iyo kamwelekela Finehasi. Wano wakala wakulu wa ng'holo za Lawi. ");
INSERT INTO cwe_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Wano ni Haluni na Musa waja Mndewa Mulungu woyawalongele‚ “Walaveni wanhu wa Isilaili muna iisi ya Misili, lukolo kwa lukolo.” ");
INSERT INTO cwe_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Musa na Haluni niiwawo wowamulongele mfalume wa Misili yawalekelele Waisilaili walawe muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mndewa Mulungu viyalongile na Musa muna iisi ya Misili‚ ");
INSERT INTO cwe_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","kamulongela Musa‚ “Niye Mndewa Mulungu. Mulongele mfalume wa Misili chila chinhu chonikulongela.” ");
INSERT INTO cwe_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mbali Musa kamulongela Mndewa Mulungu‚ “Vino mfalume wa Misili kezanitegeleza? Niye sidaha kulonga vinogile.” ");
INSERT INTO cwe_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mndewa Mulungu kamulongela Musa‚ “Nikutenda weye uwe fana mulungu kwa mfalume wa Misili‚ sekulu wako Haluni kezalonga mbuli zako fana mulongaji wako. ");
INSERT INTO cwe_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mulongele Haluni chila chinhu chonikulagilize‚ nayo kezamulongela mfalume wa Misili yawalekelele Waisilaili wasegele muna iisi yake. ");
INSERT INTO cwe_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Nizautenda moyo wa mfalume wa Misili uwe mdala‚ nizakongeza vilaguso vangu na mauzauza yangu muna iisi ya Misili, ");
INSERT INTO cwe_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","mbali mfalume wa Misili hezakutegeleza bule. Maabaho nizagolosa mkono wangu uli na ludabwa na kuitagusa isi ya Misili na kuwalava wanhu wangu wa Isilaili kwa kuwatagusa ng'hani Wamisili. ");
INSERT INTO cwe_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Wamisili wezanimanya kuwa niye iyo Mndewa Mulungu‚ lusita vondanilaguse udahi wangu na kuwalava Waisilaili muna iisi ya Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Haluni watenda fana viya Mndewa Mulungu viyawalagilize. ");
INSERT INTO cwe_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Lusita luja viwamulongele mfalume wa Misili, Musa kakala na miyaka malongo manane na Haluni kakala na miyaka malongo manane na mitatu. ");
INSERT INTO cwe_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Mndewa Mulungu kawalongela Musa na Haluni‚ ");
INSERT INTO cwe_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Mfalume wa Misili yahalonga na mweye, ‘Ilaguseni kwa kutenda mauzauza,’ maabaho mulongele Haluni, ‘Sola mhome yako na ilagaze hasi haulongozi wa mfalume wa Misili, nayo izagaluka kuwa zoka.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa na Haluni wahita kwa mfalume wa Misili na kutenda fana viya Mndewa Mulungu viyawalagilize. Haluni kadilagaza hasi balati jake haulongozi ha mfalume wa Misili na wasang'hani wake, najo digaluka kuwa zoka. ");
INSERT INTO cwe_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Maabaho mfalume wa Misili kawatanga wanhu wake weli na ubala na wahawi wa Misili‚ nawo watenda fana ivo kwa uhawi wawo. ");
INSERT INTO cwe_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Chila munhu kadilagaza hasi balati jake, najo digaluka kuwa zoka. Mbali balati da Haluni diimela mibalati yawo. ");
INSERT INTO cwe_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Moyo wa mfalume wa Misili ukala ung'hali mdala, halondile kuwategeleza, fana Mndewa Mulungu viyalongile. ");
INSERT INTO cwe_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Maabaho Mndewa Mulungu kamulongela Musa‚ “Moyo wa mfalume wa Misili mdala ng'hani, kolema kuwalekelela wanhu wahite. ");
INSERT INTO cwe_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ivo hita ukaiting'hane na mfalume wa Misili imitondo lusita viyohita kuulwanda lwa Naili. Mgozele muingema ya ulwanda. Sola mhome yako ija yoigaluke kuwa zoka. ");
INSERT INTO cwe_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Maabaho mulongele mfalume wa Misili‚ Mndewa Mulungu‚ Mulungu wa Waebulaniya‚ kanhuma kumwako. Kolonga, ‘Walekelele wanhu wangu wahite‚ muladi wakanitambikile kuichuwala. Mbali mbaka sambi weye kolema kutegeleza. ");
INSERT INTO cwe_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Lekamana Mndewa Mulungu kolonga kuwa kwa mbuli ino‚ kwizanimanya kuwa niye iyo Mndewa Mulungu. Lola nizayatowa mazi yano yeli muulwanda lwa Naili kwa mhome ino inili nayo mumkono wangu‚ nayo yezagaluka kuwa damu. ");
INSERT INTO cwe_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Somba weli muna ulwanda lwa Naili wezakufa‚ lwanda lose lwizanung'ha vundo na Wamisili wezakwihilwa kung'wa mazi ya lwanda ulo.’” ");
INSERT INTO cwe_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mndewa Mulungu kamulongela Musa‚ “Mulongele Haluni yasole mhome yake na kwiigolosa uchanyha ya mazi ya Misili na uchanyha ya nyanda zose na makolongo yose na malamba yose na mazimbu yose, nayo yezakuwa damu. Isi yose izakuwa na damu, hata muna iviya vose va mbawo na mabwe.” ");
INSERT INTO cwe_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Haluni watenda fana viya Mndewa Mulungu viyawalagilize. Haluni kenula uchanyha mhome yake haulongozi ha mfalume wa Misili na wasang'hani wake, kayatowa mazi ya lwanda Naili, nayo yose yagaluka kuwa damu. ");
INSERT INTO cwe_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Somba weli muulwanda wafa‚ ulwanda lunung'ha vundo‚ ivo Wamisili wapotwa kuyang'wa mazi ya lwanda ulo. Isi yose ya Misili imema damu. ");
INSERT INTO cwe_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mbali wahawi wa Misili watenda vinhu fana ivo kwa uhawi wawo‚ ivo moyo wa mfalume wa Misili ukala ung'hali mdala, na halondile kuwategeleza Musa na Haluni‚ fana Mndewa Mulungu viyalongile. ");
INSERT INTO cwe_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Mfalume wa Misili kabwela ukaye yake, hata yano yalawilile hayagesile bule. ");
INSERT INTO cwe_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Wamisili wose wahimba mumgwazo wa lwanda lwa Naili muladi wapate mazi ya kung'wa‚ mana wapotwa kung'wa mazi ya lwanda lwa Naili. ");
INSERT INTO cwe_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Zifosa siku saba Mndewa Mulungu viyagaluse mazi ya lwanda lwa Naili. ");
INSERT INTO cwe_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Maabaho Mndewa Mulungu kamulongela Musa‚ “Hita kwa mfalume wa Misili na umulongele, Mndewa Mulungu kolonga‚ ‘Walekelele wanhu wangu wahite wakanitambikile. ");
INSERT INTO cwe_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","One uhalema kuwaleka wahite, nizaitowa isi yako yose kwa kugala mabula. ");
INSERT INTO cwe_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Lwanda lwa Naili lwizamema mabula‚ nayo yezakwingila mbaka muna ikaye yako na muna ichiheleto chako cha kugona na muna dikomwa jako na muna zikaye za wanhu wako na wasang'hani wako. Mabula yayo yezakwingila muna ivivu venu na muna iviya va kubulugila usage. ");
INSERT INTO cwe_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mabula yezakudanda weye na wanhu wako na wasang'hani wako.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mndewa Mulungu kamulongela Musa‚ “Mulongele Haluni yagolose mkono wake na mhome yake uchanyha ya nyanda na uchanyha ya makolongo na mazimbu‚ mabula yezalawilila na kwenela chila hanhu muna iisi ya Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Haluni kagolosa mkono wake muna yamazi yose ya Misili‚ mabula yalawilila na yaigubika isi yose ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mbali wahawi wa Misili watenda vinhu fana ivo kwa uhawi wawo, iviya mabula yeza yaigubika isi. ");
INSERT INTO cwe_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mfalume wa Misili kawatanga Musa na Haluni‚ kawalongela‚ “Mpuleni Mndewa Mulungu yayasegeze mabula yano kumwangu na kwa wanhu wangu, nizawalekelela wanhu wenu wahite wakamtambikile Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa kamulongela mfalume wa Misili‚ “Vinoga! Nilongele lusita loulonda nikupulile kwa Mulungu, niwapulile wanhu wako na wasang'hani wako. Nizampula yayadanganize mabula yano yeli muna zikaye zenu, yezasigala muna ulwanda lwa Naili muhala.” ");
INSERT INTO cwe_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Mfalume wa Misili kamwidika, “Igolo.” Musa kamwidika‚ “Nizatenda fana viulongile, muladi uvimanye kuwa habule munhu yoyose yalingile fana Mndewa Mulungu, Mulungu wetu. ");
INSERT INTO cwe_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mabula yezasegela kumwako na muna zikaye zako na muna zikaye za wasang'hani wako na wanhu wako, yezasigala muna ulwanda lwa Naili muhala.” ");
INSERT INTO cwe_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Maabaho Musa na Haluni wasegela kwa mfalume wa Misili, Musa kampula Mndewa Mulungu yamsegezele mfalume wa Misili mabula yayo yoyamgalile. ");
INSERT INTO cwe_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mndewa Mulungu katenda fana viya Musa viyapulile‚ mabula wafa muna zikaye zawo na muna zimbuga zawo na muna imigunda yawo. ");
INSERT INTO cwe_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wamisili wayaduganya mabula yayo vibugulu bugulu, isi yose inung'ha vundo. ");
INSERT INTO cwe_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mfalume wa Misili viyawone mabula yafa‚ kawa na moyo mdala kaidi‚ hawategeleze Musa na Haluni, fana Mndewa Mulungu viyalongile. ");
INSERT INTO cwe_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Maabaho Mndewa Mulungu kamulongela Musa, “Mulongele Haluni yadigolose balati jake na kuyatowa matimbwisi‚ nayo yezagaluka kuwa usawasawa muna iisi yose ya Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Nawo watenda ivo, Haluni kagolosa balati jake na kayatowa yamatimbwisi, nayo yagaluka usawasawa uwavamba wanhu na wanyama. Matimbwisi yose muna iisi ya Misili yagaluka kuwa usawasawa. ");
INSERT INTO cwe_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Wahawi kwa uhawi wawo wageza kutenda matimbwisi yagaluke kuwa usawasawa, mbali wapotwa. Usawasawa uwo uwavamba wanhu na wanyama. ");
INSERT INTO cwe_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Wahawi waja wamulongela mfalume wa Misili, “Sang'hano ino kaitenda Mulungu!” Mbali mfalume wa Misili kagendelela kuwa na moyo mdala, hawategeleze Musa na Haluni, fana Mndewa Mulungu viyalongile. ");
INSERT INTO cwe_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Mndewa Mulungu kamulongela Musa, “Igolo wiidawe ng'hani uhite kwa mfalume wa Misili lusita viyohita kuulwanda na umulongele kuwa Mndewa Mulungu kolonga, ‘Uwaleke wanhu wangu wahite wakanitosele.’ ");
INSERT INTO cwe_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","One uhalema kuwalekelela wahite, nizakugalila mabumbila ya ng'honzi, weye na wasang'hani wako na wanhu wako. Ng'honzi wawo wezakwingila muna zikaye zenu, kaye zose za Wamisili zizamema mabumbila ya ng'honzi, hata isi yose wanhu haweli.” ");
INSERT INTO cwe_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“Mbali siku iyo nizaibagula isi ya Gosheni iwokala wanhu wangu, muladi ng'honzi sekewawe uko. Kwa kutenda ivo kwizavimanya kuwa niye Mndewa Mulungu na muna iisi ino. ");
INSERT INTO cwe_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nizawabagula wanhu wangu na wanhu wako. Chilaguso chino cha mauzauza chizalawilila igolo.” ");
INSERT INTO cwe_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mndewa Mulungu katenda fana viyalongile. Mabumbila makulu ya ng'honzi yengila muna ikaye ya mfalume wa Misili na muna zikaye za wasang'hani wake. Wanhu wose wa isi iyo wagazigwa na ng'honzi wawo. ");
INSERT INTO cwe_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Maabaho mfalume wa Misili kawatanga Musa na Haluni na kawalongela, “Hiteni mukamtosele Mulungu wenu muna iisi ino.” ");
INSERT INTO cwe_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa kamwidika, “Havinogile kutenda ivo, mana nhambiko zondachimtambikile Mndewa Mulungu, Mulungu wetu, zizawatenda Wamisili wehilwe. Vino Wamisili wahachiwona cholava nhambiko zoziwehila wawo, hawezachitowa na mabwe mbaka chidanganike? ");
INSERT INTO cwe_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Cholondeka chigende mwanza wa siku nhatu muna ichuwala chikamulavile nhambiko Mndewa Mulungu, Mulungu wetu, fana viyachilagilize.” ");
INSERT INTO cwe_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Mfalume wa Misili kawalongela, “Nizamulekani muhite mukamulavile nhambiko Mndewa Mulungu, Mulungu wenu kuichuwala, mbali sekemuhite kutali ng'hani. Iviya nipulileni na niye.” ");
INSERT INTO cwe_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa kamwidika, “Sambi vonisegela, nizampula Mndewa Mulungu muladi igolo yayasegeze mabumbila yano ya ng'honzi kumwako na kwa wasang'hani wako na kwa wanhu wako. Mbali weye sekeuchivwizile kaidi kwa kulema kuwaleka wanhu wahite kumulavila nhambiko Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Maabaho Musa kasegela kwa mfalume wa Misili na kampula Mndewa Mulungu, ");
INSERT INTO cwe_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mndewa Mulungu katenda fana Musa viyampulile. Kawasegeza ng'honzi wose kwa mfalume wa Misili na kwa wasang'hani wake na kwa wanhu wake, hasigale hata ng'honzi imwe. ");
INSERT INTO cwe_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mbali hata mwanza uno mfalume wa Misili kakala na moyo mdala na hawalekile wanhu wasegele. ");
INSERT INTO cwe_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Maabaho Mndewa Mulungu kamulongela Musa, “Hita kwa mfalume wa Misili na umulongele kuwa Mndewa Mulungu, Mulungu wa Waebulaniya kolonga, ‘Walekele wanhu wangu wahite muladi wakanitosele. ");
INSERT INTO cwe_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","One uhalema kaidi kuwaleka wahite na uhagendelela kuwamhilila, ");
INSERT INTO cwe_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nizagolosa mkono wangu na kuwagalila wanyama wako mitamu, ng'ombe na vihongwe na mhunda na ngamiya na ng'hondolo na luti. ");
INSERT INTO cwe_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Na nizagola wanyama wa Waisilaili na wanyama wa Wamisili muladi hata mnyama imwe wa Waisilaili sekeyafe.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mndewa Mulungu keka lusita na kalonga, “Igolo Mndewa Mulungu kezatenda mbuli ino muna iisi.” ");
INSERT INTO cwe_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Igolo yake Mndewa Mulungu katenda fana viyalongile. Wanyama wose wa Wamisili wafa, mbali wanyama wa Waisilaili hafile hata imwe. ");
INSERT INTO cwe_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Mfalume wa Misili kauza chiya chilawilile kwa wanyama wa Waisilaili, kalongiligwa kuwa habule hata mnyama imwe yafile. Hata ivo mfalume wa Misili kagendelela kuwa na moyo mdala, hawalekele wanhu wahite. ");
INSERT INTO cwe_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Maabaho Mndewa Mulungu kawalongela Musa na Haluni, “Soleni maganza ya maivu ya tanuli, maabaho Musa yayapigise uchanyha haulongozi ha mfalume wa Misili. ");
INSERT INTO cwe_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Maivu yayo yezakuwa timbwisi sisili dondajenele muna iisi yose ya Misili. Nayo yezagala maihu yondayatumbuke na kuwa vilonda kwa wanhu na wanyama chila hanhu muna iisi ya Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ivo wasola maivu ya tanuli na wema haulongozi ha mfalume wa Misili, Musa kayapigisa uchanyha, nayo yawa maihu yotumbuka na kuwa vilonda kwa wanhu na wanyama. ");
INSERT INTO cwe_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Wahawi wapotwa kwima haulongozi ha Musa kwaviya wakala na maihu, mana Wamisili wose wakala na maihu. ");
INSERT INTO cwe_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mbali Mndewa Mulungu kautenda moyo wa mfalume wa Misili uwe mdala na hawategeleze Musa na Haluni, fana Mndewa Mulungu viyamulongele Musa. ");
INSERT INTO cwe_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Maabaho Mndewa Mulungu kamulongela Musa, “Igolo wiidawe ng'hani uhite kwa mfalume wa Misili na umulongele kuwa Mndewa Mulungu, Mulungu wa Waebulaniya, kolonga, ‘Walekele wanhu wangu wahite muladi wakanitosele. ");
INSERT INTO cwe_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Mana lelo nogala mahulo yangu yose kumwako na wasang'hani wako na wanhu wako, ivo kwizavimanya kuwa habule yalingile fana niye muna izisi zose. ");
INSERT INTO cwe_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Mana one nihakugalile mitamu ihile weye na wanhu wako, muhawile mudanganika mumala. ");
INSERT INTO cwe_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mbali nikuleka uwe mgima muladi kulagusa udahi wangu. Ivo wanhu wa zisi zose wezavimanya kuwa niye iyo yelihi. ");
INSERT INTO cwe_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Mbali ung'hali kowalagusa udugi wanhu wangu na huwalekela wasegele. ");
INSERT INTO cwe_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Lelo, igolo lusita fana luno, nizagala mvula ng'hulu ya mabwe, iyo hainalawilila muna iisi ya Misili, kwandusila mwanduso wake mbaka sambi. ");
INSERT INTO cwe_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Lelo lagiliza wanyama wako na chila chinhu chili kumgunda vikigwe muna ikaye. Kwaviya mvula ya mabwe izamtonyela chila munhu na mnyama yeli kumgunda na mnyama yeli kunze ya kaye, wose wezakufa.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wasang'hani wamwenga wa mfalume wa Misili wadumba na watenda fana viyalongile Mndewa Mulungu. Wawagala watumwa wawo na wanyama wawo muna ikaye. ");
INSERT INTO cwe_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mbali waja wayehule mbuli ya Mndewa Mulungu, wawaleka watumwa wawo na wanyama wawo kuna imigunda. ");
INSERT INTO cwe_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Maabaho Mndewa Mulungu kamulongela Musa, “Golosa mkono wako kuulanga, muladi mvula ya mabwe itonye chila hanhu muna iisi ya Misili. Iwatonyele wanhu na wanyama na vose vihandigwe muna imigunda.” ");
INSERT INTO cwe_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ivo Musa kagolosa mhome yake kuulanga, Mndewa Mulungu kagala mvula ya mabwe na mbumo, lumwemwe lumweka muna iisi. Mndewa Mulungu kagala mvula ya mabwe muna iisi yose ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mvula ng'hulu ya mabwe ikalile na lumwemwe, iyo habule munhu yoyose muna iisi ya Misili yaiwonile mvula ilingile ivo kwandusila mwanduso. ");
INSERT INTO cwe_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mvula iyo ya mabwe ibemenda chila chinhu chikalile muna imigunda na chila hanhu muna iisi ya Misili, wanyama na wanhu. Mabwe ya mvula iyo yabemenda mimeya yose na mibiki kuna imigunda. ");
INSERT INTO cwe_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Muna iisi ya Gosheni muhala, kowakalile Waisilaili, hakukalile na mvula ya mabwe. ");
INSERT INTO cwe_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Mfalume wa Misili kawatuma wanhu wakawatange Musa na Haluni na kawalongela. “Mwanza uno nitenda uhasanyi, Mndewa Mulungu kanoga, mbali niye na wanhu wangu chibananga. ");
INSERT INTO cwe_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mpuleni Mndewa Mulungu, mana mibumo ino na mvula ya mabwe viiyoha ng'hani. Niye nizamulekelani musegele na hebu hamwizagendelela kukala hano.” ");
INSERT INTO cwe_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa kamulongela, “Lusita vondanilawe muna dibululu, nizakwinula makono yangu kuchanyha na kumpula Mndewa Mulungu. Mibumo izaleka, hebu hakwizakuwa na mvula ya mabwe kaidi, muladi uvimanye kuwa zisi zose ni za Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mbali novimanya kuwa weye na wasang'hani wako hamumdumba Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Mkonge na chinhu chilingile fana magota ya uwele vose vikala vibanangigwa, kwaviya uwele ukala na masuke na mkonge ukala wokwalika. ");
INSERT INTO cwe_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mbali ngano na vinhu vimwenga vilingile fana ngano havibanangike, kwaviya vokalama kukangala. ");
INSERT INTO cwe_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa kasegela ukaye kwa mfalume wa Misili na kahita kunze ya bululu, kenula makono yake kwa Mndewa Mulungu, mibumo na mvula ya mabwe vileka. Mvula haitonyile muna iisi. ");
INSERT INTO cwe_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mbali mfalume wa Misili viyawonile mvula na mvula ya mabwe na mibumo vileka, katenda uhasanyi kaidi. Kawa na moyo mdala yeye na wasang'hani wake. ");
INSERT INTO cwe_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ivo moyo wa mfalume wa Misili ukala mdala, hawalekile Waisilaili wahite, fana Mndewa Mulungu viyalongile kufosela Musa. ");
INSERT INTO cwe_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Maabaho Mndewa Mulungu kamulongela Musa, “Hita kwa mfalume wa Misili, mana niutenda moyo wake na moyo wa wasang'hani wake kuwa mdala muladi nidahe kutenda vilaguso vangu kumwawo. ");
INSERT INTO cwe_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Nitenda vino muladi muwasimulile wanenu na wazukulu zenu, viya viniwatendile Wamisili kuwa wabozi kwa kutenda mauzauza kumwawo, ivo mwizavimanya kuwa niye iyo Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ivo Musa na Haluni wahita kwa mfalume wa Misili na wamulongela, “Mndewa Mulungu, Mulungu wa Waebulaniya, kolonga, ‘Vino kwizalema kuinyendanyenda haulongozi wangu mbaka zuwaki? Walekelele wanhu wangu wahite, muladi wakanitosele. ");
INSERT INTO cwe_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","One uhalema kuwalekela wanhu wangu wasegele, igolo nizagala nzige muna iisi yako. ");
INSERT INTO cwe_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Wezatanda isi yose, habule munhu yondayadahe kuwona hasi. Wezakuja vinhu visigale viifosile mvula ya mabwe, hamwe na chila mbiki woukwima muna imigunda yako. ");
INSERT INTO cwe_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Nzige wawo wezamema muna zikaye zako na muna zikaye za wasang'hani wako na muna zikaye za Wamisili wose. Wezakuwa wengi ng'hani hata wasaho zenu hawanawawona kwandusila viwelekigwe mbaka diyelo.’ ” Maabaho Musa kahinduka na kasegela kwa mfalume wa Misili. ");
INSERT INTO cwe_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Wasang'hani wa mfalume wa Misili wamulongela, “Vino ino kezachigaza mbaka zuwaki? Waleke wanhu wano wahite muladi wakamtosele Mndewa Mulungu, Mulungu wawo. Vino hugesa kuwa isi ya Misili yodanganizigwa?” ");
INSERT INTO cwe_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Maabaho Musa na Haluni wagaligwa kaidi kwa mfalume wa Misili, nayo kawalongela, “Hiteni mukamtosele Mndewa Mulungu, Mulungu wenu. Mbali welihi wondawahite?” ");
INSERT INTO cwe_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa kamwidika, “Chizahita wose, wabwanga na walala. Chizasegela hamwe na wanetu wa chike na wa chilume, ng'hondolo wetu na luti na ng'ombe, mana cholondeka chimtendele dugila da hishima Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kwa kuwazeha mfalume wa Misili kawalongela, “Mndewa Mulungu yawe hamwe na mweye one nihamulekeleni muhite na wanenu. Kweli muna lungilo dihile muna imizoyo yenu. ");
INSERT INTO cwe_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Haidahika! Walume muhala wawo wondawahite kumtosela Mndewa Mulungu, mana mbuli ino iyo yomulondile umwaka.” Maabaho Musa na Haluni wawingigwa haulongozi ha mfalume wa Misili. ");
INSERT INTO cwe_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mndewa Mulungu kamulongela Musa, “Golosa mkono wako uchanyha ya isi ya Misili, muladi nzige walawilile wengile na kuja mimeya yose muna iisi na vinhu vose visigazigwe na mvula ija ya mabwe.” ");
INSERT INTO cwe_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa kagolosa mhome yake uchanyha ya isi ya Misili, Mndewa Mulungu kagala beho kulu kulawa ulawilo wa zua, dibuma muna iisi ya Misili misi yose na chilo chose. Vikuchile, beho diya da ulawilo wa zuwa digala nzige. ");
INSERT INTO cwe_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Nzige wawo wenela chila hanhu muna iisi ya Misili, na wakala bumbila kulu ng'hani hawanalawilila nzige fana wawo hebu hawezalawilila kaidi. ");
INSERT INTO cwe_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Mana waigubika isi yose ya Misili, mbaka isi iwa na ziza. Waja mimeya yose na matunda yose yasigale chipindi chiya cha mvula ya mabwe. Muna iisi yose ya Misili habule hata yani dimwe disigale hebu mbiki hebu mmeya kuna imigunda. ");
INSERT INTO cwe_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","“Baho mfalume wa Misili kawatanga Musa na Haluni himahima na kawalongela, ‘Nimuhasanya Mndewa Mulungu, Mulungu wenu, na mweye iviya nimuhasanyani. ");
INSERT INTO cwe_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Lelo nilekeleleni uhasanyi wangu mwanza uno umwe muhala, munipulile kwa Mndewa Mulungu, Mulungu wenu, yanisegezele hulo dino dihile ng'hani.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","“Musa kasegela kwa mfalume wa Misili na kampula Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Mndewa Mulungu kagala beho da uswelo wa zuwa dili na nguvu nyingi, ijo diwasegeza nzige waja na kuwagala muna ibahali ya Shamu. Hasigale hata nzige imwe muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mbali Mndewa Mulungu kautenda moyo wa mfalume wa Misili kuwa mdala, hawalekelele Waisilaili wahite.” ");
INSERT INTO cwe_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Maabaho Mndewa Mulungu kamulongela Musa, “Golosa mkono wako kuulanga, muladi ziza totolo diigubike isi yose ya Misili. Ziza dondadiwatende wanhu wababase.” ");
INSERT INTO cwe_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Lelo Musa kagolosa mkono wake kuulanga, kukala na ziza totolo muna iisi yose ya Misili kwa siku nhatu. ");
INSERT INTO cwe_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wanhu hawadahile kuiwona hebu kusegela hanhu howakalile kwa siku nhatu. Mbali Waisilaili wakala na bung'hulo uko Gosheni kowakalile. ");
INSERT INTO cwe_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Mfalume wa Misili kamtanga Musa na kumulongela, “Hiteni mukamtosele Mndewa Mulungu, hamwe na wanenu. Mbali ng'hondolo wenu na luti na ng'ombe wolondeka wasigale hano.” ");
INSERT INTO cwe_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mbali Musa kamwidika, “Uching'he wanyama muladi chikamtimbulile Mndewa Mulungu, Mulungu wetu. ");
INSERT INTO cwe_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Iviya wanyama wetu wofugigwa cholondeka chisegele nawo, hezasigala hata mnyama imwe hebu mapaga, mana chizamtimbulila Mndewa Mulungu mnyama kulawa muna iwanyama wetu. Cheye hachivimanyile mnyama ilihi yondachimtimbulile Mndewa Mulungu mbaka vondachifike uko.” ");
INSERT INTO cwe_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mndewa Mulungu kautenda moyo wa mfalume wa Misili kuwa mdala, hawalekile Waisilaili wahite. ");
INSERT INTO cwe_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Mfalume wa Misili kamulongela Musa, “Segela haulongozi wangu! Sekewize kuniwona kaidi. Mana siku yondawize kaidi haulongozi wangu, kwizadanganika!” ");
INSERT INTO cwe_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa kamwidika, “Fana viulongile, sizakwiza kukuwona kaidi.” ");
INSERT INTO cwe_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Mndewa Mulungu kamulongela Musa, “Nizagala hulo dimwenga dimwe kwa mfalume wa Misili na wanhu wake. Maabaho kezamulekani musegele, na vondayamulekeni musegele, kezamuwingani ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Walongele Waisilaili kuwa chila imwe wawo, muke kwa mulume, kolondeka yampule mkaya miyage via va hela na zahabu.” ");
INSERT INTO cwe_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Mndewa Mulungu kawatenda Waisilaili wanogelwe na Wamisili. Iviya Musa kakala munhu yohishimika ng'hani muna iisi ya Misili, na haulongozi ha mfalume wa Misili na wasang'hani wake. ");
INSERT INTO cwe_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ivo Musa kalonga, “Mndewa Mulungu kolonga, ‘Ichilo chikulu nizafosela Misili. ");
INSERT INTO cwe_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Chila mwana chaudele wa chilume muna iisi ya Misili kezadanganika, kwandusila mwana chaudele wa mfalume wa Misili yoyokala muna ichigoda cha chifalume yeli muhazi wake, mbaka mwana chaudele wa msang'hani wake wa chike yodunda mhule muna idibwe. Hata wana chaudele wa wanyama wofugigwa, nawo wose wezadanganika. ");
INSERT INTO cwe_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Muna iisi yose ya Misili mwizakuwa na ndilo ng'hulu, ndilo yake hainalawilila hebu haizalawilila kaidi. ");
INSERT INTO cwe_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mbali mwa Waisilaili kwizakuwa kwabule ndilo na kwizakuwa na tindiwalo, baho wezavimanya kuwa Mndewa Mulungu niiyo yowabagula Wamisili na Waisilaili.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Musa kakomelezela kwa kumulongela mfalume wa Misili, “Wasang'hani wako wano wose wezanizila na kuinama kwa hishima haulongozi wangu, wezanilamba nisegele muna iisi ya Misili, niye na wanhu wose wowonisondelela. Yahakomelezeka yayo, nizasegela.” Maabaho Musa kuno kana ludoko kasegela kwa mfalume wa Misili. ");
INSERT INTO cwe_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mndewa Mulungu kamulongela Musa, “mfalume wa Misili hezakutegeleza, muladi mauzauza yangu yongezeke muna iisi ya Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa na Haluni watenda mauzauza yano yose haulongozi ha mfalume wa Misili, mbali Mndewa Mulungu kautenda moyo wa mfalume wa Misili kuwa mdala. Hawalekile Waisilaili wasegele muna iisi yake. ");
INSERT INTO cwe_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mndewa Mulungu kawalongela Musa na Haluni muna iisi ya Misili, ");
INSERT INTO cwe_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mwezi uno wizakuwa mwezi wa mwanduso wa mwaka kumwenu. ");
INSERT INTO cwe_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Walongele wanhu wose wa Isilaili kuwa muna isiku ya longo ya mwezi uno, chila munhu kolondeka yasole mwanang'hondolo imwe, kwa chila kaye imwe. ");
INSERT INTO cwe_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Yahawa kaye ina wanhu wadodo ng'hani, yolondeka kuilumba na wanhu wa kaye ya mkaya miyage kuja inyama ya kuwafaya wanhu wake, maabaho wezasagula nyama chila munhu iyodaha kuja. ");
INSERT INTO cwe_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Sagula bebelu kulawa mwa ng'hondolo hebu mwa luti. Diwe da mwaka umwe na dilibule chilema chochose. ");
INSERT INTO cwe_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mwizamwika mbaka siku ya longo na nne ya mwezi uno, maabaho Waisilaili wose wezachinja wanyama wawo ichigulogulo nguku zikwingila. ");
INSERT INTO cwe_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wanhu wezasola damu ya mnyama wawo na kuhaka mibiki yamhilile ulwivi lwa ikaye yondawaje ng'hondolo. ");
INSERT INTO cwe_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Wezakuja nyama ichilo icho vondawayoke, wezakuja hamwe na gate hadigumigwe lusu na mboga zili usungu. ");
INSERT INTO cwe_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Sekemuje nyama mbisi hebu itogosigwe, mbali yolondeka yokigwe yose, hamwe na ditwi na migulu na nyama zake za mgati. ");
INSERT INTO cwe_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sekemusigaze nyama yoyose mbaka imitondo, one ihasigala mbaka imitondo, molondeka muisome moto. ");
INSERT INTO cwe_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Vino ivo vondamuje nyama iyo. Mwizakuwa mufunga mikwiji muna ivigudi venu na muyawala vilatu na mwamha mhome muna yamakono yenu kuisasala na mwanza, kaidi mwizakuja himahima. Iyo ni Pasaka ya Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Chilo icho nizafosela muna iisi ya Misili, nizawakoma welekwa wa udele wose muna iisi ya Misili, wanhu na wanyama. Nizaitagusa milungu yose ya Misili. Niye iyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Lelo damu ija izakuwa chilaguso chenu cha kulagusa kaye zondamuwe. Niye vondaniwone damu iyo, nizawafosani na hamwizapatigwa na dihile jojose lusita vondaniwataguse Wamisili. ");
INSERT INTO cwe_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Siku ino izakuwa ya lukumbuso kumwenu, mwizaitenda iwe dugila kwa Mndewa Mulungu, hata nyelesi zenu zose kwa lagilizo da siku zose kumwenu.” ");
INSERT INTO cwe_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Mndewa Mulungu kalonga, ‘Kwa siku saba, mwizakuja magate hayagumigwe lusu. Siku ya mwanduso ya siku saba izo, mwizasegeza lusu muna zikaye zenu. Munhu yoyose yahaja chinhu chigumigwe lusu muna zisiku saba izo, kolondeka yawingigwe na Waisilaili.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","“Siku ya mwanduso na siku ya saba ni mting'hano wa kutosa kwa Mndewa Mulungu, mwizakuwa na dugila. Muna zisiku izo mbili hamulondeka kusang'hana usang'hano wowose, ila usang'hano wa kusasala ndiya. ");
INSERT INTO cwe_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mwizatenda dugila dino da magate hayagumigwe lusu fana lukumbuso lwa siku vonimulavileni mweye vibumbila va Waisilaili muna iisi ya Misili. Dugila ijo dizatendigwa siku ino na nyelesi zenu zose zikwiza fana lagilizo da siku zose. ");
INSERT INTO cwe_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mwezi wa mwanduso mwizakuja magate hayagumigwe lusu, kwandusila ichigulogulo cha siku ya longo na nne mbaka siku ya malongo maidi na imwe ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Muna zisiku izo saba, sekemuwe na lusu jojose muna zikaye zenu. Munhu yoyose yawe mfosanzila hebu mkaya, yahaja chinhu chigumigwe lusu kezawingigwa na Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Hanhu hohose homukala, sekemuje chinhu chigumigwe lusu. Molondeka muje magate hayagumigwe lusu.” ");
INSERT INTO cwe_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa kawatanga walala wose wa Waisilaili na kuwalongela, “Chila imwe wenu yawasagulile wanhu wa ng'holo zake mwanang'hondolo wa chilume na kumchinja kwa ichimu cha Pasaka. ");
INSERT INTO cwe_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mwizasola mayani ya hisopo na kuyachofa muna idamu mgati ya diziga na kuihaka muna imibiki yamhilile ulwivi lwa kaye zenu. Munhu yeyose sekeyalawe kunze ya kaye ichilo icho mbaka imitondo. ");
INSERT INTO cwe_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mana Mndewa Mulungu kezafosa kuwakoma Wamisili, one yahawona damu yoihakigwe muna imibiki yamhilile ulwivi lwa kaye zenu, kezafosa. Wala hezamuleka mdanganyi yengile muna zikaye zenu na kumkomani. ");
INSERT INTO cwe_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Mweye mwizaika mbuli ino kuwa lagilizo kumwenu na wanenu siku zose. ");
INSERT INTO cwe_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Vondamwingile muna iisi ija Mndewa Mulungu yoyawalaganileni kumwing'hani, mwizatenda dugila dino. ");
INSERT INTO cwe_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Wanenu vondawawauze, ‘Dugila dino fambulo jake choni?’ ");
INSERT INTO cwe_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mwizawedika, ‘Ino ni nhambiko ya Mndewa Mulungu ya Pasaka, kwaviya kafosa uchanyha ya kaye za Waisilaili muna iisi ya Misili viyawakomile Wamisili, mbali cheye hachikomile.’ ” Maabaho Waisilaili waidulika matwi yawo na kumtambikila Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Maabaho Waisilaili wahita, watenda fana Mndewa Mulungu viyawalagilize Musa na Haluni. ");
INSERT INTO cwe_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Chilo chikulu Mndewa Mulungu kawakoma wana chaudele wa muna iisi ya Misili, kwandusila chaudele wa mfalume wa Misili yoyakalile muna ichigoda cha chifalume, mbaka chaudele wa mfungwa na waudele wose wa wanyama. ");
INSERT INTO cwe_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ichilo chiya, mfalume wa Misili na wasang'hani wake na wanhu wose wa Misili, walamka. Kukala na ndilo ng'hulu muna iisi yose ya Misili, mana hakukalile na kaye hata imwe munhu hadanganike. ");
INSERT INTO cwe_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ichilo icho mfalume wa Misili kawatanga Musa na Haluni na kawalongela, “Lamkeni! Segeleni muna iwanhu wangu. Segeleni mweye hamwe na Waisilaili muladi mukamtosele Mndewa Mulungu, fana vimulongile. ");
INSERT INTO cwe_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Soleni ng'hondolo wenu na luti wenu na ng'ombe wenu, musegele. Na niye iviya munitemele mate.” ");
INSERT INTO cwe_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Wamisili wawahimiza Waisilaili wasegele himahima kuna iisi yawo, walonga, “One hamusegele, wose chizadanganika.” ");
INSERT INTO cwe_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ivo Waisilaili wausola usage wawo haugumigwe lusu na mahamha yawo ya kubulugila, waviguma muna yamawalo yawo mmayega. ");
INSERT INTO cwe_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Waisilaili watenda fana Musa viyawalongele, wawapula Wamisili via va zahabu na hela na viwalo. ");
INSERT INTO cwe_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mndewa Mulungu kamala kuwatenda Waisilaili wanogelwe na Wamisili, Wamisili waweng'ha Waisilaili chila chinhu chowapulile. Vino niivo Waisilaili viwasolile vinhu va Wamisili. ");
INSERT INTO cwe_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Waisilaili wasegela kulawa bululu da Lamasesi wahita Sukosi. Wakala walume laki sita, wanaake na wana hawapetigwe bule. ");
INSERT INTO cwe_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Wanhu wamwenga wengi wahita hamwe nawo, ng'hondolo na luti na ng'ombe iviya wahita hamwe nawo. ");
INSERT INTO cwe_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kwaviya wakala wasegele Misili himahima, hawadahile kusasala ndiya ya kuja muna inzila, ila usage uja ubulugigwe bila kugumigwa lusu, ivo woka magate hayagumigwe lusu. ");
INSERT INTO cwe_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Waisilaili wakala Misili miyaka magana mane na malongo matatu. ");
INSERT INTO cwe_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Viifikile siku ya uhelelo ya mwaka wa magana mane na malongo matatu, mabumbila yose ya wanhu wa Mndewa Mulungu wasegela Misili. ");
INSERT INTO cwe_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ikala ichilo Mndewa Mulungu viyawakalize Waisilaili muladi yawalave muna iisi ya Misili, chilo chino yolondeka chikumbukigwe na Waisilaili wose na nyelesi zawo, fana chilo cha hishima kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Mndewa Mulungu kawalongela Musa na Haluni, “Malagilizo ya Pasaka ni yayo yano, nyambenyambe yoyose hezakuja ndiya ya Pasaka. ");
INSERT INTO cwe_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mbali mtumwa yoyose yaguligwe, yahengizigwa ulungwana kodaha kuja. ");
INSERT INTO cwe_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Nyambenyambe yofosa nzila hebu msang'hani yolihigwa, halondeka kuja ndiya iyo. ");
INSERT INTO cwe_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Ndiya yose yolondeka kudigwa muna ikaye yoisasaligwe, sekemulawe nayo kunze hebu sekemubene hata vuha dimwe da mnyama wa Pasaka. ");
INSERT INTO cwe_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Wanhu wose wa Isilaili wolondeka watende dugila ijo. ");
INSERT INTO cwe_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Nyambenyambe yoyose yokala kumwenu yahalonda kutenda Dugila da Pasaka da Mndewa Mulungu, teng'hu walume wose wokala muna ikaye yake wolondeka wengizigwe ulungwana, baho kezapeteka kuwa mkaya na kutogoleligwa kutenda dugila. Mulume yoyose hengizigwe ulungwana, sekeyaje ndiya ya Pasaka. ");
INSERT INTO cwe_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Malagilizo yayo yayo yomsonhela mkaya Muisilaili na nyambenyambe yokala na mweye.” ");
INSERT INTO cwe_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Waisilaili wose watenda fana Mndewa Mulungu viyawalagilize Musa na Haluni. ");
INSERT INTO cwe_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Muna isiku iyo iyo Mndewa Mulungu kawalava Waisilaili muna iisi ya Misili kwa mabumbila. ");
INSERT INTO cwe_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Nisagulile wana chaudele wose wa chilume wawe wangu, mana wa Waisilaili na wa wanyama ni wangu.” ");
INSERT INTO cwe_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa kawalongela wanhu, “Mukumbuke siku ino, siku yomusegezigwe muna iisi ya Misili, isi yomukalile watumwa. Mana Mndewa Mulungu kamulavani kwa udahi wake mkulu, muna isiku ino sekemuje magate yagumigwe lusu. ");
INSERT INTO cwe_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Diyelo muna umwezi wa Abibu, mwizasegela muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mndewa Mulungu vondayawagaleni muna iisi ya Wakanaani na Wahiti na Waamoli na Wahivi na Wayebusi, isi ija yoyawalahile kuweng'ha wasaho zenu, isi ili na ulongo unogile. Molondeka kuditenda dugila dino chila mwaka muna umwezi uno. ");
INSERT INTO cwe_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kwa siku saba muje magate hayagumigwe lusu, muna isiku ya saba mwizatenda dugila da hishima kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Kwa siku saba hamulondeka kuja magate yagumigwe lusu. Magate yagumigwe lusu hebu lusu, sekeviwoneke kumwenu na muna iisi yenu yose. ");
INSERT INTO cwe_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Na mwizawalongela wanenu siku ijo kuwa ni kwa ichimu cha yoyawatendeleni Mndewa Mulungu viyamulavileni muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Dugila dino dizakuwa lukumbuso fana chilaguso muna yamakono yenu hebu muna ivihanga venu, muladi siku zose chiwakumbuse kulonga malagilizo ya Mndewa Mulungu. Mana Mndewa Mulungu kamulavani muna iisi ya Misili kwa udahi wake mkulu. ");
INSERT INTO cwe_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ivo molondeka mutende dugila dino lusita lwikigwe chila mwaka.” ");
INSERT INTO cwe_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Lusita Mndewa Mulungu vondayakugale muna iisi ya Kanaani, kezamwing'hani fana viyakulahile weye na wasaho zako, ");
INSERT INTO cwe_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kolondeka kumwing'ha Mndewa Mulungu chila chaudele wako wa chilume. Waudele wose wa chilume wa wanyama wako wezakuwa wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mbali chaudele wa chihongwe kwizamkombola kwa kuliha mwanang'hondolo, mbali one hudaha kutenda ivo, kwizamkoma kwa kumbena isingo yake. Iviya kwizamkombola chila mwanago chaudele wa chilume. ");
INSERT INTO cwe_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Hamwande mwanago yahakuuza fambulo da chinhu chino, kwizamulongela, ‘Mndewa Mulungu kachilava muna iisi ya Misili kwa udahi wake mkulu, kachisegeza muna iisi ya Misili kochikalile watumwa. ");
INSERT INTO cwe_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Lusita mfalume wa Misili viyakalile na moyo mdala kalema kuchilekela chihite, Mndewa Mulungu kawakoma chila chaudele wa chilume muna iisi ya Misili, wanhu na wanyama. Lekamana chomulavila nhambiko ya mnyama mulume Mndewa Mulungu, mbali chowakombola wanetu wa chilume. ");
INSERT INTO cwe_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Chino chizakuwa fana chilaguso muna umkono wako na chilaguso muna ichihanga chako, kuwa Mndewa Mulungu kachilava muna iisi ya Misili kwa udahi wake mkulu.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Mfalume wa Misili viyawalekele wanhu wahite, Mulungu halondile wafosele nzila ihitile isi ya Wafilisiti, ingawa ikala nzila ikanhize. Mulungu kalonga, “One kuhawa na ng'hondo, wezadaha kugalula magesa yawo na kubwela Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Mbali Mulungu kawafoseza Waisilaili kuna inzila nhali kufosela muichuwala, kuhita bahali ya Shamu. Waisilaili wasegela Misili kuno waisasala kwa ng'hondo. ");
INSERT INTO cwe_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa kaisola mivuha ya Yosefu, fana viya Yosefu viyalagilize lusita yang'hali hanadanganika. Kawalahiza Waisilaili, kalonga, “Mulungu vondayamulaveni, molondeka muipape mivuha yangu musegele nayo.” ");
INSERT INTO cwe_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Waisilaili wasegela Sukosi na weka lago uko Esamu muimhaka ya ichuwala. ");
INSERT INTO cwe_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Imisi Mndewa Mulungu kawalongolela muna yamawingu yalingile fana mhanda kuwalagusa nzila, ichilo kawalongolela muna umoto ulingile fana mhanda kuweng'ha bung'hulo, muladi wadahe kugenda imisi na ichilo. ");
INSERT INTO cwe_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Mawingu yalingile fana mhanda lusita lwa imisi na moto ulingile fana mhanda lusita lwa ichilo, havilekile kuwalongolela Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Maabaho Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Walongele Waisilaili wabwele hachisogo na kwika mahema haulongozi ha Pihahilosi, hagati ya Migidoli na Bahali ya Shamu, haulongozi wa Baali Sefoni. ");
INSERT INTO cwe_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Mfalume wa Misili kezagesa kuwa Waisilaili wowegela muna iisi na chuwala chiwahindila. ");
INSERT INTO cwe_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nizautenda moyo wa mfalume wa Misili kuwa mdala, nayo kezamsondelelani. Niye nizaipatila utunhizo kwa kuwananga mfalume wa Misili na wakalizi wake, Wamisili wezavimanya kuwa niye iyo Mndewa Mulungu.” Maabaho Waisilaili watenda fana viya viwalongeligwe. ");
INSERT INTO cwe_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mfalume wa Misili viyalongiligwe kuwa wanhu wamala kusegela, yeye na wasang'hani wake wagalula magesa yawo na kulonga, “Choni chino chochitendile? Chiwalekela Waisilaili wasegele na chipuwa wasang'hani wa kuchisang'hanila.” ");
INSERT INTO cwe_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Mfalume kasasala mtuka wake wa kubululigwa na falasi na kuwasola wakalizi wake. ");
INSERT INTO cwe_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Iviya kasola mituka inogile magana sita na mituka imwenga yose ya Wamisili, wakulu wa wakalizi wake wose, wakwela mituka iyo. ");
INSERT INTO cwe_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mndewa Mulungu kautenda moyo wa mfalume wa Misili kuwa mdala, muladi yawasondelele Waisilaili, wowasegele kwa ugangamalo. ");
INSERT INTO cwe_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Wamisili hamwe na falasi wawo wose na mituka yoibululigwa na falasi na wakalizi wake wawasondelela Waisilaili, wawafika wozenga lago hamgwazo ya bahali, habehi na Pihahilosi, haulongozi wa Baali Sefoni. ");
INSERT INTO cwe_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Lusita Waisilaili viwamuwonile mfalume wa Misili na wakalizi wake wowasondelela wawo, wadumba ng'hani na kumulilila Mndewa Mulungu yawataze. ");
INSERT INTO cwe_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Wamulongela Musa, “Vino hakukalile na maleme muna iisi ya Misili mbaka kuchigala chidanganikile kuno kuchuwala? Habali kuchitendela yano kwa kuchilava muna iisi ya Misili? ");
INSERT INTO cwe_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Vino hachikulongele mbuli zino vichikalile ching'hali muna iisi ya Misili? Chikulongela uchilekele chigendelele kuwasang'hanila Wamisili. Ihawile muhavu kuwasang'hanila Wamisili sembuse kudanganikila kuno kuchuwala.” ");
INSERT INTO cwe_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa kawedika Waisilaili, “Sekemdumbe! Imeni chigangamavu! Diyelo mwizawona viya Mndewa Mulungu vondayawakomboleni. Mana Wamisili wano womuwawona diyelo, hamwizawawona kaidi. ");
INSERT INTO cwe_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mndewa Mulungu kezawagombeleni mweye, mweye molondeka munyamale hupi.” ");
INSERT INTO cwe_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Mndewa Mulungu kamulongela Musa, “Habali monililila? Walongele Waisilaili wagendele na mwanza. ");
INSERT INTO cwe_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Inula mhome yako na uigolose uchanyha ya bahali uyagole yamazi, muladi Waisilaili wadahe kufosa hagati ya bahali hanhu hanyalile. ");
INSERT INTO cwe_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Niye nizawatenda Wamisili wawe na mizoyo midala muladi wawasondeleleni mgati muibahali, nizaipatila utunhizo kwa kumuhuma mfalume wa Misili na wakalizi wake na mituka yake na wakwela falasi wake. ");
INSERT INTO cwe_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na wanhu wa isi ya Misili wezanimanya kuwa niye Mndewa Mulungu, vondaniipatile utunhizo kwa mfalume wa Misili na mituka yake na wakwela falasi wake.” ");
INSERT INTO cwe_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Maabaho msenga wa Mulungu kawalongolela wakalizi wa Isilaili, kasegela na kukala hachisogo chawo. Iiviya mhanda ija ng'hulu ya wingu isegela na kukala hachisogo chawo, ");
INSERT INTO cwe_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ima hagati ya Wamisili na Waisilaili. Mhanda ya wingu iyo ubanzi umwe ilava ziza, ubanzi umwenga ilava bung'hulo. Ivo mabumbila yayo maidi, wakalizi wa Misili na Waisilaili hawaikwenhukile chilo chose. ");
INSERT INTO cwe_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa kagolosa mkono wake uchanyha muibahali, Mndewa Mulungu kaibweleza bahali kuchisogo kwa beho kulu kulawa ulawilo wa zuwa, beho ijo dibuma ichilo chose, diigola bahali banzi mbili, hagati halawilila isi inyalile. Mazi yaigola, ");
INSERT INTO cwe_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Waisilaili wafosa muibahali hana iisi inyalile, mazi yaigola banzi mbili fana ng'huta. ");
INSERT INTO cwe_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Wamisili wawasondelela na wengila mgati muna ibahali, falasi wawo wose na wakwela falasi wawo na mituka yawo ya ng'hondo. ");
INSERT INTO cwe_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Habehi na kucha, Mndewa Mulungu kawalola wakalizi wa Wamisili kulawa muna imhanda ija ya moto na wingu, kawatenda bumbila da wakalizi wa Misili wawe na lugano ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kayemiza maguludumu ya mituka yawo ya ng'hondo, yakala yogenda ugaluga ng'hani. Wamisili walonga, “Leka chiwakimbile Waisilaili! Mndewa Mulungu kowagombela Waisilaili!” ");
INSERT INTO cwe_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Maabaho Mndewa Mulungu kamulongela Musa, “Golosa mkono wako uchanyha ya bahali, muladi mazi yabwele na kuwagubika Wamisili na mituka yawo na wakwela falasi wawo.” ");
INSERT INTO cwe_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa kagolosa mkono wake uchanyha ya bahali, vikukunguzuke mazi yabwela fana viyakalile. Wamisili wageza kuyakimbila yamazi, mbali Mndewa Mulungu kawasung'hila muna yamazi. ");
INSERT INTO cwe_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mazi yabwela na kugubika mituka hamwe na wakwela falasi, wakalizi wose wa mfalume wa Misili wowawasondelele Waisilaili wadanganika muibahali. Hasigale Mmisili hata imwe. ");
INSERT INTO cwe_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mbali Waisilaili wafosa hagati ya bahali hanhu hanyalile, mazi yakala fana ng'huta kulume kwawo na kumoso kwawo. ");
INSERT INTO cwe_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Siku iyo Mndewa Mulungu kawakombola Waisilaili kulawa muna yamakono ya Wamisili. Waisilaili wawawona Wamisili mumgwazo mwa ibahali wadanganika. ");
INSERT INTO cwe_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Waisilaili viwawonile udahi mkulu Mndewa Mulungu uyalaguse kwa Wamisili, Waisilaili wamdumba Mndewa Mulungu na wamuhuwila yeye na Musa msang'hani wake. ");
INSERT INTO cwe_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Maabaho Musa na Waisilaili wamwimbila Mndewa Mulungu wila uno, walonga, “Nizamwimbila Mndewa Mulungu yeli uchanyha ng'hani. Kawasa muibahali falasi na wakwela falasi. ");
INSERT INTO cwe_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mndewa Mulungu ni mgombezi wangu na chimu cha wila wangu, yeye iyo yonikombola. Yeye ni Mulungu wangu, niye nizamtogoza, Mulungu wa tati yangu, nizamtunhiza. ");
INSERT INTO cwe_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mulungu ni galu wa ng'hondo, Mndewa Mulungu niijo zina jake. ");
INSERT INTO cwe_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Mituka ya mfalume wa Misili na wakalizi wake kawasa muna ibahali, wakalizi wake wanogile kufosa wose, wadumbukila muna ibahali ya Shamu. ");
INSERT INTO cwe_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Mazi mengi ya bahali yawagubika, wadumbukila muibahali fana dibwe. ");
INSERT INTO cwe_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mndewa Mulungu mkono wako wa kulume upata udahi mkulu, Mndewa Mulungu, mkono wako wa kulume uwahonda wehi. ");
INSERT INTO cwe_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Kwa ukulu wako kowagwisa hasi wehi wako, ludoko lwako lokwaka na kuwalunguza fana mabuwa yanyalile. ");
INSERT INTO cwe_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kwa mhumuzi yako, mazi yaiduganya hamwe, mawimbi yema zugaga fana ng'huta, Mazi mengi ya hagati ya bahali yananahila. ");
INSERT INTO cwe_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mwihi kalonga, ‘Nizawawinza na kuwagwila, nizagola utajili wawo na kusola vose vinilonda. Nizasomola ngugulila yangu, mkono wangu wizawadanganiza.’ ");
INSERT INTO cwe_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Mbali kubuma kwa beho jako, Wamisili wagubikigwa, wadumbukila muna yamazi mengi fana dibwe. ");
INSERT INTO cwe_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Mndewa Mulungu, muna imilungu yelihi yalingile fana weye? Yelihi yalingile fana weye uli na utunhizo ng'hani, udumbiza kwa sang'hano za utunhizo? ");
INSERT INTO cwe_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kugolosa mkono wako wa kulume, na isi iwamela wehi wetu. ");
INSERT INTO cwe_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Kwa ulondo wako wa kufunya umoyo, kuwalongoza wanhu wouwakombole, kwa udahi wako mkulu kuwalongoza mbaka hanhu helile houkala. ");
INSERT INTO cwe_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Wanhu wa isi wahulika yayo na kugudemeka, wanhu wokala Filisiti wengilwa na chinhu cha kudumbiza chiwagalile usungu. ");
INSERT INTO cwe_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Walangulizi wa Edomu wadumba, walangulizi wa Moabu wagudemeka kwa kudumba, wanhu wose wokala Kanaani mizoyo yawo imong'honyoka. ");
INSERT INTO cwe_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Wapatigwa na lugano na ludumbo. Kwa ichimu cha ukulu wa nguvu zako, wanyamala hupi fana dibwe. Mbaka wanhu wako weye Mndewa Mulungu wafose, mbaka vondawafose wanhu wako wouwakombole. ");
INSERT INTO cwe_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kwizawengiza mgati na kuwemiza hana mulima wako, hanhu haja houhasagule weye Mndewa Mulungu hawe hanhu handaukale, hanhu helile houhazengile weye Mndewa Mulungu kwa mkono wako, ");
INSERT INTO cwe_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mndewa Mulungu ni Mfalume siku zose.” ");
INSERT INTO cwe_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Falasi wa mfalume wa Misili na mituka na wakwela falasi wake viwengile muibahali, Mndewa Mulungu kayabweleza mazi ya bahali na yawagubika. Mbali Waisilaili wagendelela kugenda hanhu hanyalile hagati ya bahali. ");
INSERT INTO cwe_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Mulotezi Miliamu, lumbu jake Haluni, kasola chigoma mumkono, na wanaake wose wamsondelela, watowa chigoma na wavina. ");
INSERT INTO cwe_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miliamu kawembila, “Mwimbileni Mndewa Mulungu yeli uchanyha ng'hani. Kawasa muibahali falasi na wakwela falasi.” ");
INSERT INTO cwe_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Maabaho Musa kawalongoza Waisilaili kulawa Bahali ya Shamu, wahita kuchuwala cha Shuli. Siku nhatu wagenda muna ichuwala bila kuyawona mazi. ");
INSERT INTO cwe_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Viwafikile hanhu hatangigwe Mala, hawadahile kung'wa mazi ya uko kwaviya yakala usungu. Lekamana hanhu baho hatangigwa Mala. ");
INSERT INTO cwe_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Wanhu walongelela kwa Musa, walonga, “Lelo chizakung'wa choni?” ");
INSERT INTO cwe_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Maabaho Musa kamulilila Mndewa Mulungu, Mndewa Mulungu kamulagusila tambi da biki, Musa kadivabika muna yamazi, mazi yose yahola. Uko Mndewa Mulungu kaweng'ha Waisilaili malagilizo na ndagilizi muladi yawageze, ");
INSERT INTO cwe_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","kawalongela, “One muhaditegeleza vinogile dizi jangu niye Mndewa Mulungu, Mulungu wenu, na kutenda yaja yanogile haulongozi wangu na kutegeleza ndagilizi na malagilizo yangu, niye sizamgalileni matamu yaja yoniwagalile Wamisili. Kwaviya niye iyo Mndewa Mulungu yonimuhonyani.” ");
INSERT INTO cwe_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Maabaho wafika Elimu, kokukalile na nzasa longo na mbili na mitende malongo saba. Uko weka mahema jawo habehi na mazi. ");
INSERT INTO cwe_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Maabaho Waisilaili wose wasegela kulawa Elimu na wahita kuna ichuwala cha Sini, chili hagati ya Elimu na Sinai, muna isiku ya longo na tano ya mwezi wekaidi, lusita viwasegele muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Kuja kuichuwala Waisilaili wose walongelela kwa Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","wanhu wa Isilaili wawalongela, “Muhavu Mndewa Mulungu yahachikomile vichikalile muna iisi ya Misili kochikalile chija nyama na magate mbaka chiguta. Mbali mweye muchigala kuno kuichuwala muladi muchikome chose na nzala.” ");
INSERT INTO cwe_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Mndewa Mulungu kamulongela Musa, “Nizamtonyelani mvula ya magate kulawa kuulanga. Chila siku wanhu wezalawa na kuduganya ndiya ya siku iyo. Kwa nzila ino nizawageza niwone fana wezasondelela ndagilizi zangu hebu hawezasondelela. ");
INSERT INTO cwe_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Siku ya sita vondawasasale ndiya yowaduganye, chiyasi icho chizakuwa miyanza midi ya ndiya ya chila siku.” ");
INSERT INTO cwe_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musa na Haluni wawalongela Waisilaili wose, “Ichigulogulo mwizavimanya kuwa Mndewa Mulungu iyo yamulavileni muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Imitondo mwizawona utunhizo wa Mndewa Mulungu, kwaviya kahulika kulongelela kwenu kwa Mndewa Mulungu. Vino cheye china nani mbaka mudahe kulongelela kumwetu?” ");
INSERT INTO cwe_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Maabaho Musa kawalongela, “Ichigulogulo Mndewa Mulungu kezamwing'hani nyama muje, imitondo kezamwing'hani magate muje mwigute, kwaviya kahulika kulongelela kwenu. Vino cheye china nani mbaka mulongelele kumwetu? Hamulongelele kumwetu mbali mulongelela kwa Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Maabaho Musa kamulongela Haluni, “Walongele wanhu wose wa Isilaili wahite na kwima haulongozi ha Mndewa Mulungu, mana kahulika kulongelela kwenu.” ");
INSERT INTO cwe_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Haluni viyakalile kolonga na Waisilaili wose, walola kuichuwala, utunhizo wa Mndewa Mulungu ulawilila muna diwingu. ");
INSERT INTO cwe_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nihulika kulongelela kwa Waisilaili. Walongele, ‘Nguku zikwingila wezakuja nyama na imitondo wezakuja magate. Baho mwizavimanya kuwa niye iyo Mndewa Mulungu, Mulungu wenu.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ichigulogulo diza bumbila da ng'hwale na wadigubika dilago da Waisilaili, imitondo nhungwe izunguluka lago jose. ");
INSERT INTO cwe_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Nhungwe viimalile, kuichuwala kuwa na chinhu chilingile fana gate sisili. ");
INSERT INTO cwe_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Waisilaili viwawone chinhu icho waiuza, “Chino choni?” Mana hawavimanyile chikala choni. Musa kawalongela, “Dino ijo gate doyamwing'hileni Mndewa Mulungu muje. ");
INSERT INTO cwe_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Chino icho chiyalagilize Mndewa Mulungu, ‘Chila munhu yaduganye ndiya kwa kaye yake viyodaha kuja. Yamdondolele mhishi imwe yoimfaya chila munhu yeli muna ikaye yake.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Waisilaili watenda fana viwalongeligwe, wamwenga waduganya nyingi na wamwenga chidogo. ");
INSERT INTO cwe_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Na viwapimile mhishi ziwaduganye, munhu yaduganye ndiya nyingi hapatile nyingi ng'hani, munhu yaduganye chidogo hapatile chidogo ng'hani. Chila munhu kaduganya ndiya yoimfaya. ");
INSERT INTO cwe_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Maabaho Musa kawalongela, “Munhu yoyose sekeyasigaze ndiya iyo mbaka imitondo.” ");
INSERT INTO cwe_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mbali wawo hawamtegeleze Musa, ivo wasigaza ndiya mbaka imitondo. Mbali imitondo ndiya iyo iwola, ilava mavunyo na kunung'ha vundo. Ivo Musa kawawonela ludoko ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Chila imitondo wanhu woduganya ndiya yoimfaya kuja. Zuwa vidikwelile na kuwa kali, ndiya isigale hamgwazo ya nzila ilumbuzuka. ");
INSERT INTO cwe_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Siku yesita Waisilaili waduganya ndiya iyo miyanza midi kufosa mwanduso, chila munhu mhishi mbili. Ivo walangulizi wose wa Waisilaili wamuhitila Musa na wamulongela mbuli izo. ");
INSERT INTO cwe_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa kawalongela, “Vino niivo viyalagilize Mndewa Mulungu, ‘Igolo ni siku ya kuhumula, Siku ya Mhumulo yelile ya Mndewa Mulungu. Ivo hiteni mukambike hebu mukakimuse ndiya yomulonda diyelo, ndiya yondaisigale ikeni mbaka igolo.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ivo weka goya indiya mbaka imitondo fana Musa viyawalongele, nayo haiwolile na hailavile mavunyo hebu hainung'hile vundo. ");
INSERT INTO cwe_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa kawalongela, “Diyeni ndiya ino diyelo, kwaviya diyelo ni Siku ya Mhumulo ya Mndewa Mulungu. Diyelo hamwizafika ndiya yoyose kunze ya lago. ");
INSERT INTO cwe_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mwizaduganya ndiya kwa siku sita, mbali muna isiku yesaba, Siku ya Mhumulo, hakwizakuwa na chinhu chochose.” ");
INSERT INTO cwe_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Siku ya saba wanhu wamwenga wahita kudondola ndiya, mbali hawafikile chinhu. ");
INSERT INTO cwe_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Maabaho Mndewa Mulungu kamuuza Musa, “Mwizalema kwamha malagilizo yangu na ndagilizi zangu mbaka zuwaki? ");
INSERT INTO cwe_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kumbukeni kuwa Mndewa Mulungu kamwing'hani Siku ya Mhumulo, lekamana muna isiku yesita komwing'hani magate kwa siku mbili. Muna isiku yesaba, chila munhu nayakale hanhu hayeli. Munhu yoyose sekeyalawe kunze siku yesaba.” ");
INSERT INTO cwe_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ivo siku yesaba wanhu wahumula. ");
INSERT INTO cwe_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Waisilaili waitanga ndiya iyo “Mana.” Ikala fana uhemba mzelu na mumulomo ilinga fana gate sisili digumigwe uki. ");
INSERT INTO cwe_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa kawalongela, “Vino ivo viyalagilize Mndewa Mulungu, ‘Soleni lita mbili za mana na mwiike kwa ichimu cha nyelesi zikwiza, muladi wawone ndiya yonimulisileni kuichuwala chipindi chinimulavileni muna iisi ya Misili.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa kamulongela Haluni, “Sola nongo ukagume lita mbili za mana, wiike haulongozi ha Mndewa Mulungu ikalizigwe kwa ukalangama kwa nyelesi zikwiza.” ");
INSERT INTO cwe_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Fana Mndewa Mulungu viyamulagilize Musa, Haluni keka mana haulongozi ha vibawo va mabwe va ukalangama, muladi ikigwe goya. ");
INSERT INTO cwe_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Waisilaili waja mana kwa miyaka malongo mane, mbaka viwafikile muna iisi inogile kukala, isi ili muna imhaka ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Mhamba ya mana lita mbili ikala chinhu chimwe muna ichila vinhu longo, ningo iyo izoweleke yoitangigwa efa. ");
INSERT INTO cwe_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Wanhu wose wa Isilaili walawa muna ichuwala cha Sini, wandusa mwanza kulawa hanhu hamwe kuhita hamwenga fana viya Mndewa Mulungu viyawalagilize. Wazenga lago uko Lefidimu, mbali hakukalile na mazi ya kung'wa. ");
INSERT INTO cwe_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Walongelela kwa Musa, walonga, “Ching'he mazi ya kung'wa.” Musa kawedika, “Habali molongelela kumwangu? Habali momgeza Mndewa Mulungu?” ");
INSERT INTO cwe_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mbali wanhu wakala na ng'hilu ng'hani, walongelela kwa Musa, walonga, “Habali kuchilava kuna iisi ya Misili uchikome na ng'hilu cheye na wanetu na wanyama wetu?” ");
INSERT INTO cwe_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa kamulilila Mndewa Mulungu, kalonga, “Niwatendele choni wanhu wano? Habehi wezanitowa na mabwe.” ");
INSERT INTO cwe_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mndewa Mulungu kamulongela Musa, “Fosa kuulongozi wa wanhu wano na uwasole walala wawo wamwenga. Iviya usole mhome ija youitowele lwanda lwa Naili na uhite. ");
INSERT INTO cwe_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Lola, nizakwima haulongozi wako muna uluwe uko Holebu. Utowe luwe ulo, mazi ya kung'wa wanhu yezalawa muna uluwe.” Musa katenda ivo haulongozi ha walala wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa kahatanga hanhu baho Masa na Meliba, kwaviya Waisilaili walongelela na kumgeza Mndewa Mulungu, walonga, “Vino kweli Mndewa Mulungu kahamwe na cheye?” ");
INSERT INTO cwe_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Waamaleki weza na kuitowa na Waisilaili uko Lefidimu. ");
INSERT INTO cwe_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa kamulongela Yoshua, “Sagula walume uhite ukaitowe na Waamaleki. Igolo nizakwima kuinhembeti ya mulima, noyamhilila mhome ija ya Mulungu muna umkono wangu.” ");
INSERT INTO cwe_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ivo Yoshua kawatowa Waamaleki fana viya Musa viyamulagilize. Musa na Haluni na Huli wahita kuinhembeti ya mulima. ");
INSERT INTO cwe_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Chila Musa viyokwinula makono yake kuchanyha, Waisilaili wakala wohuma, viyohumulusa makono yake, Waamaleki wakala wohuma. ");
INSERT INTO cwe_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mbali hamwande makono ya Musa yalegela. Ivo Haluni na Huli wasola dibwe na wadika habehi na Musa, nayo kakala. Maabaho wayamha na kwinula mikono yake, imwe kenula mkono wa kulume na imwenga mkono wa kumoso. Ivo makono ya Musa yagendelela kugangamala kuno yenuligwa uchanyha mbaka zuwa vidiswile. ");
INSERT INTO cwe_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ivo Yoshua kawahuma Waamaleki kwa upanga. ");
INSERT INTO cwe_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Maabaho Mndewa Mulungu kamulongela Musa, “Yandika mbuli ino muna ichitabu, maabaho igong'onde muna yamagutwi ya Yoshua iwe lukumbuso kwaviya nizawasegeza Waamaleki wose muna iisi yose.” ");
INSERT INTO cwe_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa kazenga lupango na kachitanga, “Mndewa Mulungu kanitenda nihume.” ");
INSERT INTO cwe_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Kalonga, “Mana makono yenuligwa uchanyha kuna ichigoda cha chifalume cha Mndewa Mulungu. Mndewa Mulungu kezakuwa na ng'hondo na Waamaleki siku zose.” ");
INSERT INTO cwe_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yesilo mkulu wa nhambiko wa Midiani yeli mkoi wa Musa, kahulika chila chinhu Mndewa Mulungu chiyamtendele Musa na Waisilaili, na viya viyawalavile kuna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ivo Yesilo keza kwa Musa, kamgala Sipola muke wa Musa, Musa yoyamulekile kuchisogo, ");
INSERT INTO cwe_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","hamwe na wanage waidi wa chilume wa Musa. Mwana wa mwanduso katangigwa Gelishomu. Musa kamtanga zina dino kwaviya kalonga, “Niye nikala nyambenyambe muna iisi ya ugeni.” ");
INSERT INTO cwe_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Wekaidi katangigwa Eliezeli, kwaviya kalonga, “Mulungu wa tati yangu kanitaza na kanikombola kulawa muna upanga wa mfalume wa Misili.” ");
INSERT INTO cwe_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yesilo mkoi wa Musa, hamwe na muke wa Musa na wanage, weza kwa Musa kuichuwala koyekile lago habehi na mulima wa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yesilo katuma usenga kwa Musa, “Niye Yesilo mkoi wako, nokwiza na muke wako na wanage waidi.” ");
INSERT INTO cwe_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa kalawa kunze kumuhokela Yesilo, kamtumbalila mavindi na kamnonela. Waiuzagiza mbuli za uhonyaji, maabaho wengila muna dilago da Musa. ");
INSERT INTO cwe_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa kamulongela mkoi wake chila chinhu Mndewa Mulungu chiyamtendele mfalume wa Misili kwa ichimu cha Waisilaili na kusonhela mbuli ndala zose ziwapatile mnzila na viya Mndewa Mulungu viyawakombole. ");
INSERT INTO cwe_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yesilo kadeng'helela viyahulike mbuli zose zinogile Mndewa Mulungu ziyawatendele Waisilaili kwa ichimu cha kuwakombola muna yamakono ya Wamisili. ");
INSERT INTO cwe_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Na kamulongela, “Mtunhize Mndewa Mulungu, yoyawakomboleni kulawa kwa mfalume wa Misili na Wamisili! Yatunhizigwe Mndewa Mulungu, yoyawagombole wanhu wake kulawa kuutumwa! ");
INSERT INTO cwe_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Lelo nivimanya kuwa Mndewa Mulungu ni mkulu kufosa milungu yose, mana kawakombola wanhu wano muna yamakono ya Wamisili wowawatendele magoda.” ");
INSERT INTO cwe_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Maabaho Yesilo mkoi wa Musa kamulavila Mndewa Mulungu nhambiko za kutimbuligwa na nhambiko. Haluni keza na walala wa Isilaili muladi waje ndiya hamwe na Yesilo haulongozi ha Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Igolo yake Musa kakala kowahumiza Waisilaili, nawo wema kuno wamzunguluka kulawa imitondo mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yesilo mkoi wa Musa viyawonile mbuli zose Musa ziyawatendele Waisilaili, kamuuza, “Chino choni chouwatendela wanhu? Habali kolamula nhaguso wiidumwe kuno wanhu wano wose wakuzunguluka kulawa imitondo mbaka ichigulogulo?” ");
INSERT INTO cwe_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa kamwidika, “Kwaviya wanhu wokwiza kumwangu kuuza viyolonda Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wanhu wahagomba wokwiza kumwangu na niye nowahumiza na kuwalongela malagilizo na ndagilizi za Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Maabaho Yesilo kamulongela Musa, “Viusang'hana havinogile. ");
INSERT INTO cwe_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Weye na wanhu wano mwizalegela, kwaviya sang'hano ino ndala. Hudaha kuisang'hana wiidumwe. ");
INSERT INTO cwe_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Lelo nitegeleze niye na nizakulongela vinigesa, Mulungu yawe hamwe na weye. Weye kwizahita haulongozi ha Mulungu kwa ichimu cha wanhu na kumgalila magayo yawo. ");
INSERT INTO cwe_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kolondeka uwafundize malagilizo na ndagilizi za Mulungu na kuwalagusa viya viwolondeka kukala na kusang'hana usang'hano. ");
INSERT INTO cwe_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mbali kwa mbuli zimwenga sagula walume weli na udahi mwa iwanhu wose. Wanhu womdumba Mulungu na wanhu goya na hawalonda kusola chochose muladi kubena malagilizo, weng'he usang'hano wa kuwemiliza wanhu muna yamabumbila ya wanhu elufu na mabumbila ya wanhu gana na mabumbila ya wanhu malongo matano na mabumbila ya wanhu longo. ");
INSERT INTO cwe_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Wawo wezakuwa na malundo chila siku kuhumiza mbuli za wanhu. Mbuli ndala wezakugalila weye, mbali mbuli ndodondodo wezazilamula wenyewo. Kwa nzila iyo kwizadaha kuitenda sang'hano yako ihuhe, kwaviya wanhu wezailumba na weye muna isang'hano iyo. ");
INSERT INTO cwe_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Uhatenda ivo na ihawa niivo viyolonda Mulungu, kodaha kufunya umoyo, wanhu wano wose wezadaha kubwela kumwawo kwa tindiwalo.” ");
INSERT INTO cwe_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa kamtegeleza mkoi wake na katenda fana viyamulongele. ");
INSERT INTO cwe_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa kasagula wanhu walume weli na udahi mwa Waisilaili, kawatenda kuwa walangulizi wa mabumbila ya wanhu elufu na mabumbila ya wanhu gana na mabumbila ya wanhu malongo matano na mabumbila ya wanhu longo. ");
INSERT INTO cwe_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Wasang'hana fana wasemi wa wanhu lusita lose. Mbuli zizamile wamgalila Musa, mbali mbuli ndodondodo wazikomeleza wawo wenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Maabaho Musa na Yesilo mkoi wake wailaga, nayo Yesilo kabwela kuna iisi yake. ");
INSERT INTO cwe_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Siku ya mwanduso ya mwezi wetatu Waisilaili viwalawile muna iisi ya Misili, wafika kuna ichuwala cha Sinai. ");
INSERT INTO cwe_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Viwasegele Lefidimu na kufika kuichuwala cha Sinai, Waisilaili wazenga lago haulongozi wa mulima wa Sinai. ");
INSERT INTO cwe_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Maabaho Musa kakwela kumulima kwa Mulungu. Mndewa Mulungu kamtanga Musa kulawa kuna mulima, kamulongela, “Vino niivo vondauwalongele welesi wa Yakobo na Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mweye wenyewo muwona viniwatendile Wamisili na viya vinimsolileni fana masumula viyosola wanage kwa mabawa yake, nimgalani kumwangu. ");
INSERT INTO cwe_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Lelo, one mwahanitegeleza na kudika goya lagano jangu, mwizakuwa wanhu wangu mwa makabila yose, mana isi yose yangu. ");
INSERT INTO cwe_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Mweye kumwangu mwizakuwa ufalume wa wakulu wa nhambiko na wanhu welile.’ Zino niizo mbuli zondauwalongele Waisilaili.” ");
INSERT INTO cwe_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ivo Musa kahumuluka na kawatanga hamwe walala wa Waisilaili, kawalongela chila chinhu Mndewa Mulungu chiyamulagilize. ");
INSERT INTO cwe_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Maabaho wanhu wose wedika hamwe, walonga, “Chizatenda chila chinhu chiyalongile Mndewa Mulungu.” Ivo Musa kamulongela Mndewa Mulungu chiwalongile wanhu wawo. ");
INSERT INTO cwe_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mndewa Mulungu kamulongela Musa, “Nizakwiza muna diwingu dizamile, muladi wanhu wahulike vinilonga na weye na wezakuhuwila siku zose. “Musa kamulongela Mndewa Mulungu chiwalongile wanhu wawo.” ");
INSERT INTO cwe_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Mndewa Mulungu kamulongela Musa, “Hita kwa wanhu ukawalongele waisafye diyelo na igolo. Wolondeka wayasunhe mawalo yawo ");
INSERT INTO cwe_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","na waisasale kwa chisindo, mana siku iyo yetatu niye Mndewa Mulungu nizahumuluka kulawa uchanyha ya mulima wa Sinai haulongozi ha wanhu wose. ");
INSERT INTO cwe_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Wekile mhaka wanhu kuzunguluka mulima. Walongele, ‘Muiteganye sekemukwele kumulima hebu kubojoga mhaka yake. Munhu yoyose yondayaudalise mulima kezadanganika.’ ");
INSERT INTO cwe_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Munhu yoyose yondayadalise mulima, kolondeka yatowigwe na mabwe hebu msale, munhu hebu mnyama, kezadanganika. Mbali mhalati vondailile, wanhu wezakwela kumulima.” ");
INSERT INTO cwe_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa viyahumuluke kuna mulima, kawahitila wanhu na kawasafya, nawo wayasunha mawalo yawo. ");
INSERT INTO cwe_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Maabaho Musa kawalongela wanhu, “Muisasale kwa chisindo, mulume yoyose sekeyambandame muke wake.” ");
INSERT INTO cwe_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Siku yetatu imitondo uchanyha ya mulima kulawilila mibumo na mimwemwe na wingu dizamile. Iviya dihulikika dizi da mhalati dodiwagudemeze wanhu wose wa kuna dilago. ");
INSERT INTO cwe_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Maabaho Musa kawalava wanhu mudilago na kawagala wakaiting'hane na Mulungu, wema hasi ya mulima. ");
INSERT INTO cwe_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mulima wa Sinai wakala wogubikigwa na yosi, kwaviya Mndewa Mulungu kahulumuka muna umoto. Yosi dikwela uchanyha fana yosi da tanuli, mulima wose wagudemeka ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Dizi da mhalati digendelela kulanduka. Musa kalonga na Mulungu, Mulungu nayo kamwidika muna umbumo. ");
INSERT INTO cwe_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mndewa Mulungu kahumuluka kuinhembeti ya mulima wa Sinai na kamtanga Musa kuna inhembeti. Ivo Musa kakwela kuna inhembeti ya mulima. ");
INSERT INTO cwe_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Mndewa Mulungu kamulongela Musa, “Humuluka hasi ukawazume wanhu wose sekeweze kunilola, buleivo wezadanganika. ");
INSERT INTO cwe_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hata wakulu wa nhambiko wonikwenhukila, wolondeka waisafye, buleivo niye Mndewa Mulungu nizawatagusa.” ");
INSERT INTO cwe_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa kamulongela Mndewa Mulungu, “Wanhu hawadaha kukwela mulima wa Sinai kwaviya kuchizuma weye mwenyewo chike mhaka kuzunguluka mulima na kuutenda wele.” ");
INSERT INTO cwe_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mndewa Mulungu kamwidika, “Humuluka hasi ukamsole Haluni wize nayo. Mbali wakulu wa nhambiko na wanhu wamwenga sekewaloke imhaka na kwiza kumwangu, buleivo nizawatagusa.” ");
INSERT INTO cwe_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ivo Musa kahumuluka kwa wanhu na kawalongela mbuli ziyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Mulungu kalonga mbuli zino zose, kalonga, ");
INSERT INTO cwe_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Niye Mndewa Mulungu, Mulungu wako yonikulavile kuna iisi ya Misili, koukalile mtumwa. ");
INSERT INTO cwe_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Sekeutambikile milungu imwenga ila niye. ");
INSERT INTO cwe_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Sekeuitendele nyang'hiti ya chinhu chochose chilingile fana chinhu cha kuulanga hebu chili muna iisi hebu chili muna yamazi. ");
INSERT INTO cwe_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Sekeuitumbalile mavindi hebu kuisang'hanila, kwaviya niye Mndewa Mulungu, Mulungu wako, ni Mulungu nili na migongo. Nowatagusa wana kwa uhasanyi wa tati zawo, kwa nyelesi yetatu na yekane ya waja wonihila. ");
INSERT INTO cwe_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Mbali nolagusa ulondo wa kufunya umoyo kwa nyelesi maelufu kwa waja wonilonda niye na kutegeleza ndagilizi zangu. ");
INSERT INTO cwe_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Sekeudisang'hanile chakachaka zina da Mndewa Mulungu, Mulungu wako, mana Mndewa Mulungu kezamtagusa chila munhu yodisang'hanila chakachaka zina jake. ");
INSERT INTO cwe_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Izindilile Siku ya Mhumulo kwa kuitenda yele, mana ni siku ya chiidumwe. ");
INSERT INTO cwe_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Siku sita sang'hana usang'hano na utende mbuli zako zose. ");
INSERT INTO cwe_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mbali siku yesaba ni Siku ya Mhumulo ya Mndewa Mulungu, Mulungu wako. Siku iyo sekeusang'hane usang'hano wowose, weye hebu mwanago wa chilume hebu mwanago wa chike, hebu wasang'hani wako wa chike hebu wasang'hani wako wa chilume, mnyama wako wa kufugigwa hebu nyambenyambe yeli muna ikaye yako. ");
INSERT INTO cwe_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Mana kwa siku sita, niye Mndewa Mulungu nilumba ulanga na isi yose na bahali na vinhu vose vili umo, maabaho siku yesaba nihumula. Ivo niye Mndewa Mulungu niitemela mate siku yesaba na niitenda yele. ");
INSERT INTO cwe_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Wategeleze tati yako na mami yako, muladi ukale siku nyingi muna iisi ija inikwing'ha niye Mndewa Mulungu, Mulungu wako. ");
INSERT INTO cwe_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Sekeukome giladi. ");
INSERT INTO cwe_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Sekeuibandame na mulume hebu muke wa munhu imwenga. ");
INSERT INTO cwe_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Sekeubawe. ");
INSERT INTO cwe_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Sekeumulongeleze mkaya miyago kwa mbuli za uvwizi. ");
INSERT INTO cwe_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Sekeuimelele mate kaye ya munhu imwenga, sekeumelele mate muke wa miyago hebu msang'hani wake wa chike hebu msang'hani wake wa chilume hebu ng'ombe wake hebu chihongwe wake, hebu chinhu chochose chiyeli nacho miyago.” ");
INSERT INTO cwe_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","“Wanhu viwahulike mibumo na dizi da mhalati na kuwona ng'huwa na yosi kuna mulima, wagudemeka kwa kudumba na wema kutali.” ");
INSERT INTO cwe_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wamulongela Musa, “Longa na cheye weye mwenyewo, chizakutegeleza. Mbali Mulungu sekeyalonge na cheye, buleivo chizadanganika.” ");
INSERT INTO cwe_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa kawalongela, “Sekemudumbe, Mulungu keza kumgezani muladi kumtendani mumdumbe na sekemutende uhasanyi.” ");
INSERT INTO cwe_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Lusita Musa viyawile habehi na wingu diya dizamile moyakalile Mulungu, wanhu wose wema kutali. ");
INSERT INTO cwe_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Maabaho Mndewa Mulungu kamulongela Musa yawalongele Waisilaili, “Muwona mweye wenyewo kuwa nilonga na mweye kulawa kuulanga. ");
INSERT INTO cwe_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Sekemuitendele vinhu va hela vilingile fana Mulungu viwe hamwe na niye, sekemuitendele milungu ya zahabu hebu shaba. ");
INSERT INTO cwe_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Munhendele lupango lwa ulongo na mulave nhambiko zenu za wanyama, fana viya nhambiko ya tindiwalo na nhambiko ya kutimbula. Chila hanhu hondaniwakumbuse wanhu zina jangu, nizamwizilani na kumtemelani mate. ");
INSERT INTO cwe_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","One mwahazenga lupango lwa mabwe, sekemuzengele mabwe yosongoligwe, kwaviya lusita londamusang'hanile mabwe yasongoke, uhasang'hanila chia chako kusongolela, kwizakuwa kwambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Wala sekemutende lupango uli na vidando va kukwelela, muladi munhu yokwela uchanyha yake sekeyakale mwazi.” ");
INSERT INTO cwe_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Weng'he Waisilaili ndagilizi zino, ");
INSERT INTO cwe_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","One uhamgula mtumwa wa Chiebulaniya, kezakusang'hanila kwa miyaka sita. Mbali mwaka wa saba kezakuwa kailegeha na kusegela bila kuliha chochose. ");
INSERT INTO cwe_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","One kaguligwa yahawa hanasola muke, kezasegela yaidumwe. Mbali one keza na muke wake, basi kezasegela na muke wake. ");
INSERT INTO cwe_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mwenevale wake yahamwing'ha muke na imuke yahamwelekela mwana wa chilume hebu wa chike, basi imuke na iwana wezakuwa wa mwenevale, msang'hani iyo kezasegela yaidumwe. ");
INSERT INTO cwe_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Mbali mtumwa yahalonga, ‘Nomulonda mwenevale wangu na muke wangu na wanangu, silonda kuilegeha.’ ");
INSERT INTO cwe_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Maabaho mwenevale wake kezamgala mtumwa iyo haulongozi wa Mulungu. Kezamsola na kumgala hana ulwivi hebu chizingiti na kumtobola digutwi kwa sanziya. Maabaho kezamsang'hanila mwenevale wake siku zose. ");
INSERT INTO cwe_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“One munhu yahamchuuza mwanage wa chike kuwa mtumwa, iyo hezatendigwa yailegehe fana viili kwa mtumwa wa chilume. ");
INSERT INTO cwe_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","One ihawa mwenevale wake kamgula yawe imwe wa watumwa wake wa chike mbali hanogelwe nayo, basi mwenevale kezamuleka munhu imwenga yoyose yamkombole. Mwenevale iyo kabule haki ya kumchuuza kuna izisi zimwenga, kwa viya kabena lagano na mtumwa ija. ");
INSERT INTO cwe_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","One yahalonda kumzengeza mtumwa ija kwa mwanage wa chilume, kezamtendela mtumwa iyo fana mndele wake. ");
INSERT INTO cwe_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","One yahasola muke imwenga, kolondeka yagendelele kumwing'ha muke wake wa mwanduso ndiya imfaya na viwalo na kwiibandama nayo. ");
INSERT INTO cwe_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","One yahapotwa kumtendela vinhu vino vitatu, muke kosegela kwa kuilegeha bila kuliha chochose. ");
INSERT INTO cwe_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Munhu yoyose yomtowa miyage na kumkoma, kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Mbali one hamulungile kumkoma ila Mulungu kaleka ilawilile ivo, basi mkomaji iyo kodaha kukimbilila hanhu hondaniwasagulileni. ");
INSERT INTO cwe_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mbali munhu yahamkoma miyage giladi, hata fana kakimbilila hana ulupango lwa kuigombela, msegezeni na mumkome. ");
INSERT INTO cwe_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Munhu yoyose yomtowa tati yake hebu mami yake kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Munhu yoyose yombawa miyage muladi yakamchuuze hebu kumtenda yawe mtumwa wake, kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Munhu yoyose yomduwila tati yake hebu mami yake kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Wanhu waidi wahagomba, maabaho imwenga kamtowa miyage na dibwe hebu ng'honde bila kumkoma, mbali kamulumiza na kumtenda yaugule na kutambalala mdikomwa, ");
INSERT INTO cwe_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","yahawa munhu iyo yatowigwe kezapata muhavu na kudaha kugendela mhome, iyo yamulumize kezalekelelwa. Mbali kezamuliha kwa lusita loyagize viyakalile mdikomwa na kolondeka yamuuguze mbaka yahone. ");
INSERT INTO cwe_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Munhu yahamtowa na balati mtumwa wake wa chilume hebu wa chike na kumkoma baho baho, kolondeka yatagusigwe. ");
INSERT INTO cwe_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mbali mtumwa iyo yahasigala mgima siku dimwe hebu mbili, mwenevale wake hezatagusigwa kwaviya kagiza hela yake iyamgulile. ");
INSERT INTO cwe_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“One walume wahaitowa na kumulumiza mwanamke yeli na wimo, mbaka kavumbula siku siyo zake, munhu ija yamulumize kezaliha fana vondayalonde mulume wa mwanamke iyo na fana wasemi vondawalamule. ");
INSERT INTO cwe_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mbali one kwizalawilila dihile, kezatagusigwa ugima kwa ugima, ");
INSERT INTO cwe_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ziso kwa ziso, zino kwa zino, mkono kwa mkono, mgulu kwa mgulu, ");
INSERT INTO cwe_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kulungula kwa kulungula, chilonda kwa chilonda, kutowa kwa kutowa. ");
INSERT INTO cwe_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“One munhu yahamtowa muna diziso mtumwa wake wa chike hebu wa chilume na kudilava, kolondeka yamuleke yasegele kwa kuilegeha kwa ichimu cha ziso jake. ");
INSERT INTO cwe_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","One yohamtowa na kumng'ola dizino mtumwa wake wa chilume hebu wa chike, kolondeka yamuleke yasegele kwa kuilegeha kwa ichimu cha zino jake. ");
INSERT INTO cwe_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“One ng'ombe yahamkenha mulume hebu muke na kumkoma, ng'ombe iyo kezakomigwa kwa kutowigwa na mabwe na nyama yake haizadigwa. Mwene ng'ombe iyo kezakuwa kabule mbuli. ");
INSERT INTO cwe_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mbali one ng'ombe iyo kazowela kukenha mulume hebu muke na mwene ng'ombe kalongeligwa mbali hamfungile, ng'ombe iyo yahakoma mulume hebu muke kolondeka yatowigwe na mabwe, na mwene ng'ombe kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mbali munhu iyo yahalongigwa yalave yombe muladi kuulekelela ugima wake, kolondeka yalihe chima chiya chondayalongiligwe kulava. ");
INSERT INTO cwe_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","One ng'ombe yahamkenha mbwanga hebu mndele, izahumizigwa ivo ivo. ");
INSERT INTO cwe_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","One ng'ombe iyo yahamkenha mtumwa wa chilume hebu wa chike, mwene ng'ombe kezamuliha mwenevale wa mtumwa iyo kwa shekeli malongo matatu ya hela, na ng'ombe iyo kolondeka yakomigwe kwa kutowigwa na mabwe. ");
INSERT INTO cwe_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“One munhu hadisilize kombo hebu yahahimba kombo na sekeyadigubike, maabaho ng'ombe hebu chihongwe kodumbukila umo, ");
INSERT INTO cwe_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mwene dikombo ijo kolondeka yamulihe hela mwene mnyama iyo, na mnyama iyo yafile kezakuwa wa mwene dikombo. ");
INSERT INTO cwe_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","One ng'ombe wa munhu yahamulumiza ng'ombe wa munhu imwenga na kumkoma, wene ng'ombe wezamchuuza ng'ombe iyo imgima na kuigolela zihela, iviya wezaigolela ng'ombe yafile. ");
INSERT INTO cwe_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mbali one ng'ombe kazowela kuwakenha wayage na mwene ng'ombe hamfungile, mwenyewo kezamuliha miyage ng'ombe mgima, ng'ombe yafile kezakuwa wake. ");
INSERT INTO cwe_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Munhu yahabawa ng'ombe hebu ng'hondolo na kumchinja hebu kumchuuza, kolondeka yalihe ng'ombe watano kwa ng'ombe imwe na ng'hondolo wane kwa ng'hondolo imwe. ");
INSERT INTO cwe_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Mbavi yahafikigwa kobena kaye ichilo, yahatowigwa mbaka kudanganika, yamkomile kabule ubananzi. ");
INSERT INTO cwe_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Mbali mbavi iyo yahagwiligwa uchile na kukomigwa, yamkomile kana ubananzi. Mbavi iyo kolondeka yabweleze chinhu, one kabule kolondeka yachuuzigwe muladi kuliha ubavi wake. ");
INSERT INTO cwe_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","One mnyama yabawigwe yahapatika yahawa mgima kwa mbavi iyo, basi mbavi iyo kezamuliha miyanza midi, yawe ng'ombe hebu chihongwe hebu ng'hondolo. ");
INSERT INTO cwe_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Munhu yahawadima wanyama wake muna umgunda wa mizabibu na kumulekelela mnyama wake yaje muna umgunda wa munhu imwenga, kezaliha udanganyi uwo kwa ndiya inogile ya umgunda wake mwenyewo hebu mgunda wake wa mizabibu. ");
INSERT INTO cwe_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“One munhu yahakwacha moto, nawo uhasoma mibiki ya miwa na kwenela mbaka kusoma maguniya ya ndiya hebu ndiya za munhu imwenga zili hazinagoboligwa hebu mgunda wose wahaka, munhu ija yakwachile moto uwo kolondeka kuliha udanganyi uwo wose. ");
INSERT INTO cwe_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“One munhu yahamwing'ha miyage chinhu hebu hela yamwikile goya, maabaho ibawigwa ukaye yake, mbavi yahapatika kolondeka yalihe hela iyo miyanza midi. ");
INSERT INTO cwe_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Mbali mbavi one hapatike, mwene kaye kezahita haulongozi ha Mulungu muladi kulonga ukweli kuwa yeye kamwabule muubavi wa vinhu va miyage. ");
INSERT INTO cwe_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kwahawa na kuiswela kwa ichimu cha ng'ombe hebu chihongwe, hebu chinhu chochose chagile, wanhu waidi wolonga ni chawo, wanhu watendile ivo wezagaligwa haulongozi wa Mulungu. Munhu ija Mulungu yondayalamule kuwa kabananga, kezamuliha miyage miyanza midi. ");
INSERT INTO cwe_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Munhu yahamwing'ha miyage ng'ombe hebu ng'hondolo hebu chihongwe hebu mnyama imwenga yoyose yamulole goya na mnyama iyo yahafa hebu yahalumila hebu yahasoligwa bila munhu imwenga kumuwona, ");
INSERT INTO cwe_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","chilaho haulongozi wa Mndewa Mulungu chizalamula hagati yawo kulagusa kuwa iyo yeng'higwe kamwabule muubavi wa vinhu va miyage. Mwene mnyama iyo kezatogola chilaho icho, na iyo miyage hezaliha chochose. ");
INSERT INTO cwe_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mbali one ihamanyika kuwa mnyama kabawigwa kumwake, imunhu iyo kolondeka yamulihe mwene mnyama. ");
INSERT INTO cwe_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","One kakomigwa na wanyama wa kumbago, munhu iyo kolondeka yamgale imnyama fana usindila, halondeka kuliha chochose kwa mnyama yoyakomigwe na wanyama wa kumbago. ");
INSERT INTO cwe_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“One munhu yahazima mnyama kwa miyage, maabaho mnyama iyo kalumila hebu kafa, lusita mwene mnyama kahabule, ija yazime kolondeka yamulihe mnyama fana ija. ");
INSERT INTO cwe_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Mbali one ilawilila mwene mnyama kabaho, yazime hezaliha chochose. One kakala yazimigwe kwa hela, hela izo zizafaya kwa kwaga kwa mnyama iyo. ");
INSERT INTO cwe_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Munhu yahamvwizila mhambe yeli hanauzigwa na kambandama, kolondeka yamfungile zengele na kumsola yawe muke wake. ");
INSERT INTO cwe_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tata wa mndele iyo yahalema ng'hani kumzengeza mwanage, munhu iyo kezaliha hela ya zengele yoilondeka kwa mndele yeli mhambe. ");
INSERT INTO cwe_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Sekeumuleke mwanamke muhawi yawe mgima. ");
INSERT INTO cwe_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Munhu yoyose yoibandama na mnyama kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Munhu yoyose yomulavila nhambiko mulungu imwenga badala ya Mndewa Mulungu muhala, kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Sekeumbamanye nyambenyambe hebu kumgaza, mana na mweye iviya mukala nyambenyambe muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Sekeumgaze mgane yoyose hebu mwana mchiwa. ");
INSERT INTO cwe_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","One uhawabamanya nawo wahanyululuka, ukweli nizahulika ndilo yawo. ");
INSERT INTO cwe_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nizakuwa na ludoko ng'hani na nizamkomani na panga. Wake zenu wezakuwa wagane na wanenu wezakuwa wachiwa. ");
INSERT INTO cwe_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Uhamwazima hela munhu yoyose mwa iwanhu wangu weli ngayengaye, sekeuwe fana mdai, iviya sekeulonde yakulihe limangwe. ");
INSERT INTO cwe_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","One uhasola mgolole wa miyago na kuwika poni, kolondeka umbwelezele ding'hali zuwa hadinahonga. ");
INSERT INTO cwe_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Kwaviya mgolole wake wa kuigubika uwo muhala. Vino weye kogesa kezaigubika choni? Yahanililila nizamwidika kwaviya niye nina ubazi. ");
INSERT INTO cwe_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Sekeumulige Mulungu hebu sekeumduwile mtawala wa wanhu wako. ");
INSERT INTO cwe_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Sekeukalame kulava nhosa mvunyo kulawa muna yamalimbulo ya mavuno yako na malimbulo ya divai yako. Mwizaning'ha wanenu waudele wa chilume. ");
INSERT INTO cwe_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Mwizatenda ivo ivo kwa waudele wa ng'ombe na ng'hondolo wenu. Chila mwelekwa wa udele mwizamuleka na mami yake kwa siku saba, siku yenane mwizaning'ha niye. ");
INSERT INTO cwe_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Mweye mwizakuwa wanhu wangu waidumwe. Ivo sekemuje nyama ya mnyama yakomigwe na mnyama wa kumbago. Nyama iyo mwizawasila zimbwa. ");
INSERT INTO cwe_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Sekeupwililise mbuli za uvwizi, na sekeumtaze munhu mbananzi kwa kulava ukalangama wa uvwizi. ");
INSERT INTO cwe_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Sekeusondelele bumbila da wanhu kutenda mbuli zihile, hebu sekewiilumbe na wanhu kulava ukalangama muna ichitala muladi kwagiza ukweli. ");
INSERT INTO cwe_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Sekeuwonele muna imbuli ya ngayengaye. ");
INSERT INTO cwe_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Uhamfika ng'ombe hebu chihongwe wa mwihi wako kaga, mbwelezele mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","One uhamuwona chihongwe wa munhu yokwihila kagwa na mbahasha yake, sekeumuleke mtaze. ");
INSERT INTO cwe_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Sekeuyagize haki iyolondeka kupata ngayengaye muna imbuli yake. ");
INSERT INTO cwe_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Iteganye sekeumulongeleze munhu uvwizi na sekeumkome munhu yelibule ubananzi, kwa viya Mulungu hezawalekelela wanhu wabananzi. ");
INSERT INTO cwe_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Sekeuhokele chinhu cha kukutenda ubene malagilizo, kwaviya chinhu icho chowatula yameso wanhu weli na ubala na kuwagiza wanhu wanogile. ");
INSERT INTO cwe_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Sekeumbamanye nyambenyambe, mweye muumanya unyambenyambe, mana na mweye mukala nyambenyambe muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Kwa miyaka sita kwizahanda migunda yako na kwaha vinhu vihandigwe. ");
INSERT INTO cwe_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mbali muna umwaka wa saba, kwizaleka migunda yako yose bila ya kuhanda mbeyu muladi ngayengaye weli mwa wanhu wako wapate ndiya isigale umo na wanyama wa kumbago waje. Kwizatenda ivo ivo muna umgunda wako wa mizabibu na mizaituni. ");
INSERT INTO cwe_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Kwa siku sita kwizasang'hana sang'hano zako, mbali siku yesaba uhumule, muladi ng'ombe wako na vihongwe wako iviya wahumule, na watumwa wowelekigwe muna ikaye yako na nyambenyambe wahumule. ");
INSERT INTO cwe_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Tegeleza chila chinhu chonikulongela. Sekeuyatambule mazina ya milungu imwenga hata chidogo, mazina yayo sekeyahulikike muna umulomo wako. ");
INSERT INTO cwe_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Miyanza mitatu chila mwaka mwizatenda madugila kwa hishima yangu. ");
INSERT INTO cwe_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Mwizagendelela kutenda Dugila da Magate Hayagumigwe Lusu fana vinimulagilizeni, mwizakuja magate hayagumigwe lusu kwa siku saba lusita lwikigwe muna umwezi wa Abibu, kwaviya muna umwezi uwo mulawa Misili. Munhu yoyose sekeyeze haulongozi wangu makono muhala. ");
INSERT INTO cwe_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Mwizagendelela kutenda Dugila da Vinhu va Mwanduso vimugobole muna imigunda yenu. Mwizatenda Dugila da Kuduganya Vinhu Vimugobole kuuhelelo wa mwaka vondamuduganye vinhu venu vimuhandile. ");
INSERT INTO cwe_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Miyanza mitatu kwa mwaka walume wose wezalawilila haulongozi wa Mndewa Mulungu, Mndewa yeli na udahi. ");
INSERT INTO cwe_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Sekeulave damu ya nhambiko yangu hamwe na magate yagumigwe lusu, na sekeuyaleke mavuta ya mnyama ya dugila jangu yasigale mbaka imitondo. ");
INSERT INTO cwe_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ndiya ya mwanduso ya isi yako kwizaigala kuna ikaye ya Mndewa Mulungu, Mulungu wako. “Sekeumkimuse mwanaluti muna yamatombo ya mami yake. ");
INSERT INTO cwe_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Lola, nomtuma msenga wa kuulanga kuulongozi wenu muladi yamkalizeni mzila na kumgalani kuna iisi yoniisasale. ");
INSERT INTO cwe_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mtegelezeni na kwamha choyolonga sekemumwehule, hezawalekelelani ubananzi wenu, kwaviya nahamwe nayo. ");
INSERT INTO cwe_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mbali muhamtegeleza chiyolonga na kutenda yose yonimulongelani, nizakuwa mwihi wa wehi wenu na nizawalema wose womulemani mweye. ");
INSERT INTO cwe_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“Msenga kuulanga kezamulongolelani na kumgalani kuna iisi ya Waamoli na Wahiti na Wapelizi na Wakanaani na Wahivi na Wayebusi, nawo nizawadanganiza. ");
INSERT INTO cwe_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Sekemutumbale mavindi kuitambikila milungu yawo hebu kuisang'hanila hebu sekemuhige sang'hano zawo. Mwizawadanganiza na kuvibomola vibanda vawo. ");
INSERT INTO cwe_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Nisang'hanileni niye Mndewa Mulungu, Mulungu wenu, niye nizamtemelani mate kwa ndiya na mazi na kusegeza mitamu kumwenu. ");
INSERT INTO cwe_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Hakwizakuwa na mwanamke yondayatengule hebu kuwa mgumba muna iisi yenu. Nizamtendani mukale siku nyingi ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nizawadumbiza na kuwatibula wanhu wose womuitowa nawo, wehi wenu nizawatenda wahinduke na kukimbila. ");
INSERT INTO cwe_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nizawawinga Wahivi na Wakanaani na Wahiti fana wanhu viwowingigwa na madondola. ");
INSERT INTO cwe_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Wanhu wawo sizawawinga muna umwaka umwe, kwaviya isi izasigala yabule chinhu na wanyama wa kumbago wezakongezeka ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mbali nizawasegeza chidogo chidogo mbaka vondamongezeke na kuitawala isi yose. ");
INSERT INTO cwe_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Mhaka za isi yenu zizakuwa kulawa bahali ya Shamu mbaka bahali ya Meditelaniya, na kulawa kuchuwala mbaka lwanda lwa Efulati, mana wakaya wa isi iyo nizawatenda muwahume, na mweye mwizawawinga wasegele kumwenu. ");
INSERT INTO cwe_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Sekemutende nawo lagano jojose hebu na milungu yawo. ");
INSERT INTO cwe_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Sekemuwaleke wakale muna iisi yenu, buleivo wezamtendani munihasanye, mana muhaitambikila milungu yawo, kweli kumwenu uwo wizakuwa mtego wa kunamata.” ");
INSERT INTO cwe_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Maabaho Mndewa Mulungu kamulongela Musa, “Kweleni kumwangu, weye na Haluni na Nadabu na Abihu, hamwe na walala malongo saba wa Isilaili, munitumbalile mavindi kwa kutali. ");
INSERT INTO cwe_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mbali weye Musa wiidumwe ukwenhuke habehi na Mndewa Mulungu, wayago sekewakwenhuke habehi. Wanhu sekeweze hamwe na weye.” ");
INSERT INTO cwe_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa kahita na kuwalongela wanhu mbuli zose za Mndewa Mulungu na ndagilizi zose, wanhu wose wedika kwa dizi dimwe, walonga, “Chizatenda chila chinhu chiyalongile Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa kandika chila chinhu chiyalongile Mndewa Mulungu. Igolo yake kaidawa na kazenga ulupango hasi ya mulima na kasimika mhanda longo na mbili fana viili peta ya makabila longo na maidi ya Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Maabaho kawatuma wabwanga wa Waisilaili wamulavile Mndewa Mulungu nhambiko za kutimbula na nhambiko za tindiwalo za ng'ombe lume. ");
INSERT INTO cwe_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa kasola nusu ya damu ija na kaiguma muna yamahamha, nusu imwenga kaitila uchanyha ya ulupango. ");
INSERT INTO cwe_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Maabaho kasola chitabu cha lagano na kawasomela wanhu. Nawo wedika, “Chizatenda chila chinhu chiyalongile Mndewa Mulungu, chizazindilila.” ");
INSERT INTO cwe_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa kasola damu ija na kawamizila wanhu, kalonga, “Ino iyo damu ya lagano da Mndewa Mulungu diyatendile na mweye kwa kuisondelela na mbuli zino zose.” ");
INSERT INTO cwe_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa na Haluni na Nadabu na Abihu, hamwe na walala malongo saba wa Waisilaili wakwela kuumulima ");
INSERT INTO cwe_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","na wamuwona Mulungu wa Isilaili. Hasi ya migulu yake hakala na chinhu chilingile fana sakafu ya mabwe ya yakuti ya langi ya buluu fana ulanga. ");
INSERT INTO cwe_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mbali Mulungu hawalumize walangulizi wawo wa Isilaili. Wamuwona Mulungu na waja na kung'wa. ");
INSERT INTO cwe_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mndewa Mulungu kamulongela Musa, “Izo kumwangu kuchanyha ya mulima ukale kuno, nizakwing'ha vibawo vidi va mabwe vili na malagilizo na ndagilizi zonyandike kwa ichimu cha kuwafunza Waisilaili.” ");
INSERT INTO cwe_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ivo Musa kasegela hamwe na Yoshua msang'hani wake, na Musa kakwela kumulima wa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa kawalongela walala, “Chigozeleni hano mbaka vondachibwele. Haluni na Huli wezakuwa bahano na mweye, yoyose yondayawe na mbuli kodaha kuwahitila wawo.” ");
INSERT INTO cwe_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa kakwela kuna mulima, maabaho wingu digubika mulima. ");
INSERT INTO cwe_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Utunhizo wa Mndewa Mulungu uhumuluka kuna mulima wa Sinai. Wingu diugubika mulima kwa siku sita. Siku yesaba Mndewa Mulungu kamtanga Musa kulawa hagati ya diwingu. ");
INSERT INTO cwe_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Kuwoneka kwa utunhizo uja wa Mndewa Mulungu kuwa fana moto woulunguza hachanyha ya mulima muna yameso ya wanhu wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa kengila muna diwingu na kakwela kumulima. Kakala kumulima siku malongo mane imisi na ichilo. ");
INSERT INTO cwe_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Walongele Waisilaili wanilavile nhosa. Nihokelele nhosa zangu kulawa kwa munhu yoyose yolonda kuning'ha. ");
INSERT INTO cwe_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Zino niizo nhosa zondauzihokele kulawa kumwawo, zahabu na hela na shaba ");
INSERT INTO cwe_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","na langi ya buluu na langi ya zambalau na langi ndung'hu na viwalo vinogile na mazoya ya luti ");
INSERT INTO cwe_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","na mbende za mabebelu ya ng'hondolo zihakigwe langi ndung'hu, na mbende za wanyama wa mwiibahali na mibiki ya mkenge, ");
INSERT INTO cwe_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","na mavuta ya chitasa cha hema da Mulungu, vilungo kwa mavuta yelile na ubani, ");
INSERT INTO cwe_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","na mabwe yokwaka ya salidoniki na mabwe yokwaka yamwenga kwa ichimu cha mahambo, chifuko cha muimhambaga na chizibawo cha mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Leka wanhu wanizengele hanhu helile, muladi nidahe kukala hamwe nawo. ");
INSERT INTO cwe_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Zenga hema da Mulungu na vinhu vake vose kuilinga na viya vondanikulaguse. ");
INSERT INTO cwe_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Nawo watende sanduku da mbiki wa mkenge, utali wake uwe sentimita gana na longo, ugalamu wake sentimita malongo sita na sita na chimo chake iwe sentimita malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Na weye udihake zahabu yelile mgati na kunze, uditendele lukingilo lwa zahabu banzi zose. ");
INSERT INTO cwe_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Maabaho utende mhete nne za zahabu na uzivaze muna imigulu yake mine, mhete mbili banzi imwe na banzi imwenga mhete mbili. ");
INSERT INTO cwe_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Na utende mibiki ya kupapila ya mkenge na uihake zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ingiza mibiki iyo muna zimhete zili banzi mbili za sanduku, kwa ichimu cha kudipapa. ");
INSERT INTO cwe_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mibiki iyo ya kupapila izasigala muna zimhete, sekeisegezigwe. ");
INSERT INTO cwe_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Muna disanduku ijo, kwizakwika vibawo va mabwe va ukalangama vondanikwing'he. ");
INSERT INTO cwe_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Tenda ngubiko ya zahabu hanhu ha kuilumba, utali wake wizakuwa sentimita gana na longo na ugalamu wake sentimita malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tenda vilumbe vidi va zahabu vovilingile fana wasenga wa kuulanga, tenda usang'hano wa kuhonda muna imihelelo ya ingubiko iyo. ");
INSERT INTO cwe_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Tenda vilumbe ivo vidi, chimwe uhelelo umwe na chimwenga uhelelo wekaidi, tenda vilumbe ivo vidi chinhu chimwe na ngubiko. ");
INSERT INTO cwe_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Vilumbe wawo wezailola, mabawa yawo yakunjuka kuigubika ingubiko, vihanga vawo vizailola ingubiko iyo. ");
INSERT INTO cwe_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mgati mudisanduku kwizakwika vibawo vidi va mabwe va ukalangama na kuika ngubiko iyo uchanyha yake. ");
INSERT INTO cwe_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Nizaiting'hana na weye baho, kulawa hachanyha ya ngubiko iyo, hagati ya vilumbe wawo waidi weli mchanyha ya sanduku da lagano, nizakwing'ha malagilizo yangu kwa ichimu cha wanhu wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Songola meza ya mibiki ya mkenge, yili na utali wa sentimita malongo manane na nane na ugalamu sentimita malongo mane na nne chimo sentimita malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Meza iyo kwizaihaka zahabu yelile na kuizungulusila lukingilo lwa zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Maabaho kwizaizungulusila lukingilo lwili na ugalamu wa sentimita nane. ");
INSERT INTO cwe_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Kwizaitendela mhete nne za zahabu na kuzika kuna zimhembe zake muna imigulu yake. ");
INSERT INTO cwe_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Mhete izo zizakuwa habehi na lukingilo luja lwa kuzunguluka meza na zizakuwa za kwamhilila mibiki ya kupapila imeza iyo. ");
INSERT INTO cwe_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tenda mibiki ya kupapila ya mkenge na kuihaka zahabu, mibiki iyo izakuwa ya kuipapila meza iyo. ");
INSERT INTO cwe_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tengeneza vyano na nhungo na mabuyu na vihamha va kugidila. Tengeneza via ivo vose kwa zahabu yelile. ");
INSERT INTO cwe_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Chila siku ika magate yelile hana imeza haulongozi hangu. ");
INSERT INTO cwe_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Kwizatenda chinala cha chitasa kwa zahabu yelile. Itendigwe kwa kuhonda, kalilo jake na mbiki wake na nhungo zake na matumba yake na maluwa yake, vose vizatendigwa kwa chihande chimwe. ");
INSERT INTO cwe_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Matambi sita yezalawilila hana umbiki wa ichinala, matambi matatu ubanzi umwe na matambi matatu ubanzi umwenga. ");
INSERT INTO cwe_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Muna ditambi kuna nhungo nhatu zilingile fana matumba na maluwa yotangigwa alimondi, muna ditambi disondelela kuna tumba jake na luwa jake. Matambi yose sita yawe fana ivo. ");
INSERT INTO cwe_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na muna ichinala kwizakuwa na nhungo nne zozitendigwe zilingile fana maluwa yotangigwa alimondi, hamwe na ving'honyo va maluwa yake. ");
INSERT INTO cwe_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Hanhu hondahalawilile chila jozi ya matambi yaja sita, hasi yake hezakuwa na tumba dimwe dimwe. ");
INSERT INTO cwe_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Matumba yayo na matambi yake yezakuwa chinhu chimwe. Chinala icho chose chizahondigwa kwa zahabu yelile. ");
INSERT INTO cwe_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Iviya kwizatenda vitasa saba kwa ichimu cha chinala icho na kuvika uchanyha yake muladi vimwemwese kuulongozi. ");
INSERT INTO cwe_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tengeneza makoleo yake na vyano vake kwa zahabu yelile. ");
INSERT INTO cwe_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Sang'hanila chilo malongo matatu na tano va zahabu yelile kutengeneza chinala cha chitasa na via vake vose. ");
INSERT INTO cwe_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Hakikisha uvitengeneze fana viya vinikulaguse kuja kumulima. ");
INSERT INTO cwe_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Maabaho zenga hema da Mulungu kwa mapanzia longo ya mawalo yanogile yabotigwe kwa nyuzi za langi ya buluu na za zambalau na ndung'hu. Mapanzia yayo kwizayahamba kwa vilumbe walingile fana wasenga wa kuulanga wasongoligwe na fundi. ");
INSERT INTO cwe_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Chila panzia dizakuwa na utali wa mita longo na mbili na ugalamu mita mbili. ");
INSERT INTO cwe_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Kwizalumbiliza mapanzia matano yawe chihande chimwe, mapanzia yamwenga matano yawe chihande chekaidi. ");
INSERT INTO cwe_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Iviya kwizasonela vitanzi va buluu muimhindo ya dipanzia da uhelelo da chihande cha mwanduso, iviya kwizashona vitanzi kuuhelelo wa mhindo ya kunze ya chihande chimwenga cha panzia. ");
INSERT INTO cwe_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Kwizagela vitanzi malongo matano muna dipanzia dimwe, vitanzi vimwenga malongo matano va panzia dekaidi, vitanzi vose viilole. ");
INSERT INTO cwe_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Maabaho kwizatengeneza vihindo malongo matano va zahabu muladi kulumbiliza viya vihande vidi va mapanzia, ivo hema da Mulungu dizakuwa chinhu chimwe. ");
INSERT INTO cwe_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Iviya kwizatengeneza ngubiko imwenga ya hema da Mulungu kwa mapanzia longo na dimwe ya mazoya ya luti. ");
INSERT INTO cwe_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Chila panzia dizakuwa na utali wa mita longo na nhatu na ugalamu wake mita mbili, mapanzia yose longo na imwe yezakuwa na ningo ziya ziya. ");
INSERT INTO cwe_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kwizalumbiliza mapanzia matano hamwe na mapanzia sita hamwe, panzia desita kwizadibanda haulongozi wa hema ijo. ");
INSERT INTO cwe_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Maabaho kwizatenda vitanzi malongo matano muimhindo ya panzia da uhelelo da chihande cha mwanduso, kwizatenda vitanzi malongo matano muimhindo ya panzia ya uhelelo wa chihande chekaidi. ");
INSERT INTO cwe_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kwizatengeneza vihindo malongo matano va shaba na kuzigela muna ivitanzi viya malongo matano muladi kulumbiliza vihande vidi va mapanzia kutenda panzia dimwe da hema. ");
INSERT INTO cwe_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Nusu ya panzia disigale, kwizaitumbika ubanzi wa kuchisogo wa dihema, ");
INSERT INTO cwe_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Utali wa panzia disigale kwizaibanda nusu mita ubanzi umwe na nusu mita ubanzi umwenga, muladi itinge ubanzi wa dihema muladi iwe na ngubiko. ");
INSERT INTO cwe_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Kwizatengeneza ngubiko imwenga ya hema kwa mbende ndung'hu ihondigwe ya mabebelu ya ng'hondolo na mchanyha yake ngubiko imwenga ya mbende ya mnyama wa mwiibahali. ");
INSERT INTO cwe_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Kwizatengeneza mibiki ya mkenge ya kwimizila dihema. ");
INSERT INTO cwe_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Mibiki izakuwa na utali wa mita nne na ugalamu wa sentimita malongo sita na sita, ");
INSERT INTO cwe_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","mibiki izakuwa na ndimi mbili za kulumbilizila. Mibiki yose kwizaitenda iwe na ndimi mbili. ");
INSERT INTO cwe_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kwizatengeneza mibiki ya hema vino, mibiki malongo maidi ubanzi wa kusi ");
INSERT INTO cwe_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","na vikalilo malongo mane va hela hasi ya mibiki iyo malongo maidi, vikalilo vidi hasi kwa chila mbiki muladi vamhilile ndimi zake mbili na vikalilo vidi viwe hasi ya mbiki umwenga muladi wamhilile ziya ndimi zake mbili. ");
INSERT INTO cwe_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ubanzi wa kasikazi wa hema kwizatengeneza mibiki malongo maidi ");
INSERT INTO cwe_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Na vikalilo vake malongo mane va hela, vikalilo vidi hasi ya chila mbiki. ");
INSERT INTO cwe_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kwa ubanzi wa kuchisogo wili uswelo wa zuwa wa hema kwizatengeneza mibiki sita. ");
INSERT INTO cwe_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Na kwizatenda mibiki midi kwa ichimu cha vingobweda va dihema ubanzi wake wa kuchisogo. ");
INSERT INTO cwe_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Mibiki iyo ya hasi iileke mbali ilumbilizigwe kwa kuchanyha kuna imhete imwe. Mibiki yose ya vingobweda izatendigwa ivo ivo muladi itende mbili. ");
INSERT INTO cwe_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ivo kwizakuwa na mibiki minane hamwe na vikalilo vake longo na sita va hela. ");
INSERT INTO cwe_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Kwizatengeneza mapalo ya mkenge, mapalo matano kwa ichimu cha mibiki ya ubanzi umwe wa hema, ");
INSERT INTO cwe_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","mapalo matano kwa ichimu cha ubanzi umwenga wa hema, mapalo matano kwa ichimu cha mibiki ya kuchisogo cha hema na ubanzi wa uswelo wa zuwa. ");
INSERT INTO cwe_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Palo da hagati dodifikile nusu ya zengo da hema dizaibebenyeka hagati kulawa kuuhelelo umwe mbaka uhelelo umwenga wa hema. ");
INSERT INTO cwe_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Mibiki yose kwizaihaka zahabu na kuzitendela mhete za zahabu zondazamhilile mapalo yayo, izo iviya kwizazihaka zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ivo kwizaditenda hema ijo kuilinga na viya vinikulaguse kumulima. ");
INSERT INTO cwe_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Kwizatenda panzia da nyuzi za langi ya buluu na za zambalau na ndung'hu na walo dibotigwe. Panzia ijo kwizadihamba vinogile kwa vilumbe vilingile fana wasenga wa kuulanga wasongoligwe na mafundi. ");
INSERT INTO cwe_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kwizatumbika dipanzia muna izimhanda nne za mkenge zozihakigwe zahabu, zili na ngwamo za zahabu na vikalilo vine va hela. ");
INSERT INTO cwe_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kwizatumbika panzia ijo muna ivihindo, maabaho udigale disanduku diya da ukalangama dili na vibao vidi va mabwe kuchisogo ya panzia ijo. Panzia ijo dizagola hanhu helile na hanhu helile ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ika ngubiko uchanyha ya disanduku da lagano mgati ya hanhu helile ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Meza ija kwizaika ubanzi wa kunze wa panzia ijo, chinala chiya cha chitasa kwizachika ubanzi wa kusi wa dihema, viilole na imeza. Meza iyo izakuwa ubanzi wa kasikazi. ");
INSERT INTO cwe_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Kwa ichimu cha hanhu ha kwingilila muna dihema kwizatengeneza panzia da langi ya buluu na zambalau na ndung'hu na walo dinogile dibotigwe na kuhambigwa vinogile. ");
INSERT INTO cwe_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kwa ichimu cha panzia kwizatengeneza mhanda tano za mkenge na kuzihaka zahabu. Mhanda izo zizakuwa na ngwamo za zahabu, chila imwe izakuwa na kalilo da shaba.” ");
INSERT INTO cwe_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Tengeneza upango kwa mibiki ya mkenge. Ulupango uwo wizakuwa wa mulaba utali wake mita mbili na lobo na ugalamu wake mita mbili na lobo na chimo chake chizakuwa mita imwe na lobo. ");
INSERT INTO cwe_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Kwizatenda mahembe mane, chila chingobweda hembe dimwe. Mahembe yayo yezakuwa chinhu chimwe na ulupango, kwizaluhaka shaba ulupango lose. ");
INSERT INTO cwe_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kwizatenda via vake, vizae va kuzolela maivu na vizae va kuhalila moto na mibatilo na magembe na vyano va kuhalila moto. Vinhu vose vizahakigwa shaba. ");
INSERT INTO cwe_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Maabaho kwizatengeneza lwavu lwa shaba lwili na mhete nne za shaba kuna ivingobweda vake vine. ");
INSERT INTO cwe_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Lwavu ulo kwizawika mulugigo lwa ulupango ubanzi wa hasi muladi lwavu lufike hagati ya upango. ");
INSERT INTO cwe_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Na kwizatengeneza mibiki ya mkenge ya kupapila ulupango, nayo kwizaihaka shaba. ");
INSERT INTO cwe_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Mibiki iyo izakwingizigwa muna zimhete banzi mbili za ulupango lusita lwa kuchipapa. ");
INSERT INTO cwe_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tengeneza upango wa mibiki na uli na uvungu mgati kuilinga na simwe donikulaguse kumulima. ");
INSERT INTO cwe_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Tengeneza luwa lwa hema da Mulungu. Ubanzi wa kusi wa uluwa kwizakuwa na mapanzia yatengenezigwe kwa walo dinogile dibotigwe yondayawe na utali wa mita malongo mane na nne kwa ubanzi umwe. ");
INSERT INTO cwe_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Mapanzia yayo yezakwamhigwa na mibiki malongo maidi ya shaba ili na vikalilo va shaba. Mbali ngwamo za mhanda na vihindo vake vizakuwa va hela. ");
INSERT INTO cwe_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Iviya utali wa panzia ubanzi wa kasikazi wizakuwa mita malongo mane na nne na mhanda zake malongo maidi za shaba, mbali ngwamo na mhanda zake na vihindo vake vizakuwa va hela. ");
INSERT INTO cwe_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ubanzi wa uswelo wa zuwa wa uluwa wizakuwa na panzia dili na utali wa mita malongo maidi na mbili na mhanda zake longo na vikalilo vake longo. ");
INSERT INTO cwe_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ubanzi wa ulawilo wa zuwa kuna ulwivi, luwa lwizakuwa na ugalamu wa mita malongo maidi na mbili. ");
INSERT INTO cwe_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Panzia da ubanzi umwe wa ulwivi dizakuwa na ugalamu wa mita sita na nusu, hamwe na mhanda nhatu na vikalilo vake vitatu. ");
INSERT INTO cwe_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Kuna ubanzi wekaidi wa lwivi panzia dizakuwa mita sita na nusu, hamwe na mhanda tatu na vikalilo vake vitatu. ");
INSERT INTO cwe_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Lwivi lwenyewo lwa uluwa lwizakuwa na panzia dili na utali wa mita kenda, ditengenezigwe kwa nyuzi za langi ya buluu na za zambalau na ndung'hu na walo dinogile dibotigwe na kuhambigwa vinogile. Panzia ijo dizakwamhigwa na mhanda nne zili na vikalilo vine. ");
INSERT INTO cwe_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mhanda zose zizunguluke uluwa zizakwamhigwa na vinhu va hela, ngwamo zake zizakuwa za hela na vikalilo vake vizakuwa va shaba. ");
INSERT INTO cwe_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Luwa ulo lwizakuwa na utali wa mita malongo mane na nne na ugalamu wa mita malongo maidi na mbili, chimo mita mbili na lobo. Mapanzia yake yezakuwa ya walo dinogile na vikalilo vake vizakuwa va shaba. ");
INSERT INTO cwe_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Via vose va kusang'hanila chila chinhu muna dihema da Mulungu na vigingi vose na hata via va uluwa vizakuwa va shaba. ");
INSERT INTO cwe_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Walagilize wanhu wa Isilaili wakugalile mavuta yanogile ya mzaituni kwa ichimu cha chitasa, muladi chitasa chidahe kwaka lusita lose. ");
INSERT INTO cwe_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Muna dihema da Mulungu kunze ya panzia ijo haulongozi ha sanduku da lagano, Haluni na wanage wezadika goya haulongozi ha Mndewa Mulungu ichigulogulo mbaka imitondo. Lagilizo dino dolondeka jamhigwe na Waisilaili wose na nyelesi zawo siku zose. ");
INSERT INTO cwe_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Mgale Haluni ndugu yako na wanage, Nadabu na Abihu na Eleazali na Isamali. Wagale kulawa mwa wanhu wa Isilaili muladi wanisang'hanile fana wakulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kwizamsonela Haluni ndugu yako mawalo yelile muladi yadahe kuwoneka yeli na utunhizo na kanoga. ");
INSERT INTO cwe_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Walagilize wanhu wose weli na umanyi woniweng'hile ubala wamsonele Haluni mawalo, muladi yadahe kubaguligwa kuwa mkulu wa nhambiko muna usang'hano wangu. ");
INSERT INTO cwe_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Walongele wamtendele mawalo yelile, chifuko cha muimhambaga na chizibawo na ng'hanzu na chilemba na mkwiji na joho dodihambigwe. Haluni ndugu yako na wanage wezavala muladi wanisang'hanile fana wakulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Wezasang'hanila nyuzi za langi ya buluu na za zambalau na ndung'hu na nyuzi za zahabu na walo dinogile ibotigwe. ");
INSERT INTO cwe_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Wezatengeneza chizibawo cha mkulu wa nhambiko kwa nyuzi za zahabu na nyuzi za langi ya buluu na za zambalau na ndung'hu na walo dinogile dibotigwe na fundi. ");
INSERT INTO cwe_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Chizakuwa na nzabi mbili za kuchifungila muna diyega zozisonigwe hamwe muna zimhembe zake mbili. ");
INSERT INTO cwe_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mkwiji wizatendigwa fana viya, kwa nyuzi za zahabu na nyuzi za buluu na za zambalau na ndung'hu na walo dinogile dibotigwe na kuwa chinhu chimwe na chizibawo icho. ");
INSERT INTO cwe_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Maabaho kwizasola mabwe maidi ya salidoniki na uchanyha yake kwizachola mazina ya wana wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Mazina sita muna idibwe da mwanduso na mazina sita muna idibwe dekaidi, uyapange fana viya viwelekigwe. ");
INSERT INTO cwe_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kwizayachola mazina yayo uchanyha ya mabwe yayo fana viya sonala viyochola muhuli. Maabaho uyahambe na kuyengiza muna ivihindo va zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Mabwe yayo maidi yezakwikigwa uchanyha ya vihande va muna yamayega va chizibawo kulagusa makabila longo na maidi ya Isilaili. Ivo Haluni kezavala mazina yayo muna yamayega yake haulongozi wangu niye Mndewa Mulungu fana lukumbuso. ");
INSERT INTO cwe_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Kwizatenda vihindo vidi va zahabu, ");
INSERT INTO cwe_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na mikufu midi ya zahabu yelile ibotigwe fana luzabi. Kwizaifunga mikufu iyo muna ivihindo. ");
INSERT INTO cwe_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Kwizatenda chifuko cha muimhambaga cha kuhumiza, chitengenezigwe na fundi fana vichitengenezigwe chiya ichizibawo, kwa zahabu na kwa nyuzi za langi ya buluu na za zambalau na ndung'hu na walo dinogile dibotigwe. ");
INSERT INTO cwe_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Chifuko icho chibandigwe chizakuwa cha mulaba, sentimita malongo maidi na mbili. ");
INSERT INTO cwe_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Chizahambigwa kwa misitali mine ya mabwe ya bei ng'hulu. Msitali wa mwanduso wizakuwa wa hakiki na topazi na alimasi ndung'hu. ");
INSERT INTO cwe_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Msitali wekaidi wizakuwa wa zumalidi na johali ya langi ya buluu na alimasi ya langi ya mayani mabisi. ");
INSERT INTO cwe_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Msitali wekatatu wizakuwa wa yasito na agate na amesisito. ");
INSERT INTO cwe_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Msitali wekane wizakuwa wa zabalajadi na shohamu na yasipi, yose yezagumigwa muna ivihindo va zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Lelo hezakuwa na mabwe longo na maidi yoyacholigwe mazina longo na maidi ya wana wa Isilaili. Chila dimwe dizakuwa fana uhula muladi kulagusa makabila longo na maidi. ");
INSERT INTO cwe_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Kwa ichimu cha chifuko icho cha muimhambaga, kwizatengeneza mikufu ya zahabu yelile ibotigwe fana luzabi. ");
INSERT INTO cwe_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Iviya kwizachitengenezela ichifuko cha muimhambaga mhete mbili za zahabu na kuziguma muna zimhembe mbili za chifuko icho. ");
INSERT INTO cwe_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Na uigume imikufu midi ya zahabu muna zimhete izo za chifuko cha muimhambaga. ");
INSERT INTO cwe_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Zinhonga ziya mbili za mikufu ya zahabu kwizazigeleka muna ivihindo vidi muladi ziigelekeze na ichihande cha muna yamayega cha chizibawo ubanzi wa kuulongozi. ");
INSERT INTO cwe_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Iviya kwizatengeneza mhete mbili za zahabu na kuziguma muna zimhembe mbili za hasi, ubanzi wa mgati wa chifuko cha muimhambaga habehi na ichizibawo. ");
INSERT INTO cwe_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Maabaho kwizatengeneza mhete zimwenga mbili za zahabu na kuziguma kuulongozi muna zimhembe mbili za hasi za vihande va muna yamayega va chizibawo, hanhu chizibawo hochiilumba na mkwiji woubotigwe vinogile. ");
INSERT INTO cwe_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Chifuko cha muimhambaga chizafungigwa kuna ichizibawo kwa kulumbiliza mkwiji wake na chizibawo kwa luzabi lwa langi ya buluu, muladi chifuko icho cha muimhambaga sekechitohoke mbali chikale muna ichizibawo. ");
INSERT INTO cwe_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Haluni viyokwingila hanhu helile, kezavala chifuko cha muimhambaga cha kuhumiza chicholigwe mazina ya makabila ya wana wa Isilaili, kwa kutenda ivo, niye Mndewa Mulungu sizawazimiza ng'o. ");
INSERT INTO cwe_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Kwizaguma Ulimu na Sumimu muna ichifuko cha muimhambaga cha kuhumiza, izo zizakuwa uchanyha ya moyo wa Haluni chila viyokwiza haulongozi wangu. Haluni kezasola ulamuzi wa wana wa Isilaili wawo uchanyha ya moyo wake haulongozi wa Mndewa Mulungu siku zose. ");
INSERT INTO cwe_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Kwizasona joho da kuvalila chizibawo kwa nyuzi za langi ya buluu. ");
INSERT INTO cwe_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Hagati izakuwa na nyafasi ya kufosezela ditwi, nyafasi iyo izasonigwa na nyuzi muladi sekeidegeke. ");
INSERT INTO cwe_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Muna imhindo yake ya hasi kuzunguluka banzi zose, izacholigwa makomamanga ya langi ya buluu na zambalau na ndung'hu, iviya hagati ya makomamanga yayo hezakuwa na mbugi za zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Komamanga na mbugi ya zahabu kuzunguluka joho yose. ");
INSERT INTO cwe_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haluni kolondeka yavale ng'hanzu ino lusita viyosang'hana usang'hano wa ukulu wa nhambiko. Dizi da mbugi dizahulikika viyokwingila hanhu helile haulongozi ha Mndewa Mulungu na viyolawa, ivo hezakomigwa bule. ");
INSERT INTO cwe_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Maabaho kwizatengeneza chihande cha zahabu yelile na kuchola uchanyha yake fana munhu viyochola muhuli, ‘Yelile kwa Mndewa Mulungu.’ ");
INSERT INTO cwe_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Chihande icho kwizachifunga kwa luzabi kuulongozi wa chilemba cha buluu. ");
INSERT INTO cwe_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Haluni kezachivala chihande icho kuna ichihanga chake, kwa chihande icho kezasola ubananzi uwatendile Waisilaili kuna ukunilavila nhosa, niye Mndewa Mulungu nizazitogola nhosa zawo. Haluni kezavala chihande icho lusita lose. ");
INSERT INTO cwe_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Kwizamtengenezela Haluni joho ditengenezigwe kwa walo dinogile na kumuhogosela chilemba cha walo dinogile na mkwiji utendigwe na fundi. ");
INSERT INTO cwe_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Kwizawatengenezela wanage Haluni majoho na mikwiji na kofiya muladi wawoneke wana utunhizo na ukulu. ");
INSERT INTO cwe_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Kwizamvaza Haluni ndugu yako na wanage mawalo yano, maabaho uwahake mavuta na kwika kwa sang'hano yelile na uwabagule muladi wanisang'hanile fana wakulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Iviya kwizawasonela kaputula za chitani zondaziwagubike kwandusila mchigudi mbaka muna yamawambo muladi wagubike mwazi wawo. ");
INSERT INTO cwe_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haluni na wanage wezavala kaputula izo chila vondawengile muna dihema da Mulungu hebu vondawawe habehi na ulupango na kutenda sang'hano za ukulu wa nhambiko hana ihanhu helile. Kwa kutenda ivo hawezalagusa mwazi wawo na kukomigwa. Iyo izakuwa ndagilizi ya siku zose kwa Haluni na welesi wake. ");
INSERT INTO cwe_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Vino niivo vondauwatendela Haluni na wanage muladi kuwabagula wanisang'hanile fana wakulu wa nhambiko. Sola dang'ang'a da ng'ombe lume dimwe na mabebelu maidi ya ng'hondolo yelibule chilema chochose, ");
INSERT INTO cwe_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","na magate hayagumigwe lusu, maandazi hayagumigwe lusu yabulugigwe na mavuta, na magate masisili hayagumigwe lusu, mbali yoigumigwe mavuta. Vinhu vino vose vitengenenzigwe kwa usage lunhili wa ngano. ");
INSERT INTO cwe_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Maabaho uvike vinhu ivo muna ichigelo chimwe na uvilave hamwe na diya dang'ang'a da ng'ombe lume na ng'hondolo malume maidi. ");
INSERT INTO cwe_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Maabaho wagale Haluni na wanage wa chilume mbaka hana dihema da Mulungu na uwanave na mazi. ");
INSERT INTO cwe_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Maabaho kwizasola yaja mawalo ya ukulu wa nhambiko umvaze Haluni, joho na ng'hanzu na chizibawo na chifuko cha muimhambaga na kumzingiliza umkwiji uja ubotigwe vinogile. ");
INSERT INTO cwe_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Mvaze Haluni chilemba chiya muna iditwi na kwika chihande chiya cha zahabu yelile uchanyha ya chilemba icho. ");
INSERT INTO cwe_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Maabaho sola mavuta yelile na umgidile mditwi jake na umuhake. ");
INSERT INTO cwe_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Maabaho wasole wanage na uwavaze ng'hanzu, ");
INSERT INTO cwe_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","na uwafunge mikwiji muna ivigudi na kuwavaza kofiya zawo, vino ivo vondauweke Haluni na wanage kwa sang'hano yelile. Wawo wezakuwa wakulu wa nhambiko siku zose. ");
INSERT INTO cwe_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Maabaho kwizagala dang'ang'a da ng'ombe lume haulongozi ha hema da Mulungu. Haluni na wanage wezakwika makono yawo uchanyha ya ditwi da dang'ang'a da ng'ombe ijo. ");
INSERT INTO cwe_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Uchinje dang'ang'a da ng'ombe ijo haulongozi ha Mndewa Mulungu, hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kwizasola damu imwenga ya ng'ombe na wiihake muna yamahembe ya ulupango kwa chidole chako, damu yose yondaisigale kwizaitila hasi ya ulupango. ");
INSERT INTO cwe_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Maabaho kwizasola mavuta yose yogubika utumbo, hanhu ha hasi ya maini hamwe na figo mbili na mavuta yake, vose uvitimbule uchanyha ya lupango. ");
INSERT INTO cwe_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mbali nyama ya dang'ang'a da ng'ombe lume ijo na mbende na mavi yake kwizavisola na kuvitimbula kunze ya lago. Ino izakuwa nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Maabaho kwizasola imwe mwa ng'ondolo malume waja na umulongele Haluni na wanage weke makono yawo uchanyha ya ditwi jake. ");
INSERT INTO cwe_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Weye kwizamchinja na damu yake kwizaimizila banzi zose za ulupango. ");
INSERT INTO cwe_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Maabaho kwizamkanha ng'hondolo lume iyo vihande vihande, kwizasunha utumbo wake na migulu yake, uvike vose hamwe na ditwi jake na vihande vake vimwenga. ");
INSERT INTO cwe_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Maabaho kwizatimbula bebelu da ng'hondolo ijo jose uchanyha ya lupango muladi kunilavila nhambiko ya kutimbuligwa, mnung'ho wa nhambiko yoitimbuligwa izaninogeza niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Kwizasola ng'hondolo lume dimwenga, iviya Haluni na wanage wezakwika makono yawo uchanyha ya ditwi jake. ");
INSERT INTO cwe_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Kwizamchinja na kusola damu chidogo na kumuhaka Haluni na wanage hanhu ha hasi ha magutwi yawo ya kulume na muna yamadole ng'hulu da mikono yawo ya kulume na madole ng'hulu ya migulu yawo ya ukulume. Damu yondaisigale kwizalumizila ulupango banzi zake zose nne. ");
INSERT INTO cwe_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Maabaho kwizasola damu chidogo ili uchanyha ya ulupango hamwe na mavuta yaja yelile ummizile Haluni na mawalo yake, iviya uwamizile wanage na mawalo yawo. Haluni na wanage wezakuwa wela kumwangu hamwe na mawalo yawo yose. ");
INSERT INTO cwe_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Kwizasola mavuta ya ng'hondolo lume, mkila wake na mavuta yogubika utumbo na hanhu hanonile hasi ha maini na figo zake mbili na mavuta yake, hamwe na chima cha kulume. Ng'hondolo iyo ni ng'hondolo wa kwikigwa kwa sang'hano yelile. ");
INSERT INTO cwe_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Muna ichigelo cha magate hayagumigwe lusu chili haulongozi wangu niye Mndewa Mulungu, kwizasola gate dimwe na andazi dimwe dodigumigwe mavuta na gate sisili dimwe. ");
INSERT INTO cwe_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Vinhu vino vose kwizamwing'ha Haluni na wanage muna yamakono yawo, nawo wezavinula uchanyha kuwa chilaguso cha kunilavila nhambiko niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Maabaho kwizavisola kaidi muna yamakono yawo na kuvitimbula uchanyha ya ulupango hamwe na nhambiko ija ya kutimbuligwa, viwe mnung'ho unogile wouninogeza niye Mndewa Mulungu. Iyo ni nhambiko yoitimbuligwa kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Maabaho kwizasola chidali cha bebelu da ng'hondolo na kumwika Haluni kwa sang'hano yelile, na kuchinula uchanyha muladi kunilavila niye Mndewa Mulungu. Nacho chizakuwa chako. ");
INSERT INTO cwe_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Kwika kwa sang'hano yelile ya ukulu wa nhambiko, vihande vidi va bebelu da ng'hondolo. Vino ivo chidali chinuligwe uchanyha na chima chibaguligwe. Chidali yeng'higwe Haluni, chima weng'higwe wanage. ");
INSERT INTO cwe_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ivo Waisilaili siku zose wezasola vihande ivo kulawa muna zinhambiko zawo za tindiwalo zowonilavila niye Mndewa Mulungu na kumwing'ha Haluni na wanage, iyo ni nhambiko kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Haluni yahadanganika, mawalo yake yelile wezakwing'higwa welesi wake, nawo wezavala siku yawo ya kuhakigwa mavuta na kwikigwa kwa sang'hano yelile. ");
INSERT INTO cwe_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mwana wa Haluni yondayawe mkulu wa nhambiko hanhu ha tati yake, kezavala mawalo yayo siku saba muna dihema da Mulungu, muladi yasang'hane usang'hano hanhu helile. ");
INSERT INTO cwe_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Kwizasola nyama ya bebelu ijo da kwikigwa kwa sang'hano yelile na kuikimusa hana ihanhu hamwenga helile. ");
INSERT INTO cwe_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haluni na wanage wezakuja nyama ya bebelu ijo na gate dili muna ichigelo hanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Wezakuja nyama izo zilavigwe kwa ichimu cha kuilumba na kwika kwa sang'hano yelile na kwa ichimu cha kuwabagula, mbali munhu imwenga sekeyalekeligwe kuja nyama izo kwaviya zela. ");
INSERT INTO cwe_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","One nyama yoyose hebu magate yezasigala mbaka imitondo, basi kwizaitimbula, sekeidigwe kwaviya yela. ");
INSERT INTO cwe_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ivo niivo vondauwatendele Haluni na wanage kuisondelela na yaja yose yonikulagilize, kwizaweka kwa sang'hano yelile kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","“Chila siku kwizalava ng'ombe lume dimwe diwe nhambiko ya uhasanyi, kwa kutenda ivo kwizalusafya ulupango, maabaho kwizachigidila mavuta yelile muladi kulubagula ulupango. ");
INSERT INTO cwe_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Kwa siku saba kwizalusafya ulupango na kulubagula. Uhakomeleza kutenda ivo, lupango lwizakuwa lwela ng'hani na chinhu chochose chondachidalise ulupango, chizakuwa chela. ");
INSERT INTO cwe_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Zino niizo nhambiko zomulondeka kulava uchanyha ya lupango chila siku, wanang'hondolo waidi malume weli na mwaka umwe. ");
INSERT INTO cwe_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Mwanang'hondolo imwe kwizamulava imitondo, mwanang'hondolo imwenga kwizamulava ichigulogulo nguku zikwingila. ");
INSERT INTO cwe_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Hamwe na mwanang'hondolo wa mwanduso, kwizalava chibaba cha usage lunhili wouhanganyigwe na lita imwe ya mavuta yanogile na lita imwe ya divai fana nhosa ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Mwanang'hondolo imwenga wa chigulogulo nguku zikwingila kwizamulavila nhambiko hamwe na nhosa ya usage na ya ching'waji fana viutendile imitondo, mnung'ho wa nhambiko iyo yoilavigwa kwa moto wizaninogeza niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Nhambiko ino ya kutimbuligwa izalavigwa siku zose, welesi mbaka welesi, haulongozi hangu niye Mndewa Mulungu, haulongozi ha hanhu ha kwingilila muna dihema da Mulungu hondaniiting'hane na kulonga na mweye. ");
INSERT INTO cwe_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Baho nizaiting'hana na wanhu wa Isilaili, baho hezakwela kwa utunhizo wangu. ");
INSERT INTO cwe_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nizabagula hema da Mulungu na ulupango, iviya nizawabagula Haluni na wanage muladi wanisang'hanile fana wakulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nizakala hagati ya wanhu wa Isilaili, na nizakuwa Mulungu wawo. ");
INSERT INTO cwe_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Baho wezavimanya kuwa niye niiyo Mndewa Mulungu, Mulungu wawo, yoniwalavile muna iisi ya Misili muladi nikale hagati yawo. Niye niiyo Mndewa Mulungu, Mulungu wawo. ");
INSERT INTO cwe_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Kwizatengeneza lupango lwa mibiki ya mkenge, kwa ichimu cha kusomela ubani. ");
INSERT INTO cwe_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Upango lwenyewo luwe lwa mulaba utali sentimita malongo mane na tano na ugalamu sentimita malongo mane na tano na chimo chake sentimita malongo kenda. Mahembe yake ya chila chingobweda yawe chinhu chimwe na lupango lwenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kwizachihaka zahabu yelile, ubanzi wake wa uchanyha na banzi zake zose na mahembe yake, iviya kwizaitendela lukingo lwa zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kwizaitendela mhete mbili za zahabu na kuziguma hasi muna ulukingo lwa mbavu zake mbili zoziilola, mhete izo zizasang'haniligwa kwamhilila mibiki lusita lwa kuipapila. ");
INSERT INTO cwe_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Mibiki iyo iwe ya mkenge na ihakigwe zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Lupango ulo lwike haulongozi wa panzia haulongozi wa disanduku da lagano, haulongozi ha ngubiko ya kuilumba, hondaniiting'hane na weye. ");
INSERT INTO cwe_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Chila imitondo Haluni viyosasala vitasa, kezasoma ubani wili na mnung'ho unogile uchanyha ya lupango. ");
INSERT INTO cwe_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Haluni kolondeka kutenda ivo lusita voyokwacha vitasa ichigulogulo nguku zikwingila. Nhosa ino ya ubani izalavigwa siku zose kwa Mndewa Mulungu bila kuleka muna zinyelesi zenu zikwiza. ");
INSERT INTO cwe_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Muna ulupango luno, usome ubani uluhusigwa muhala na sekemulave nhambiko ya kutimbuligwa, hebu nhosa ya usage, hebu kugida nhosa ya ching'waji uchanyha yake. ");
INSERT INTO cwe_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Haluni kolondeka kuyasafya mahembe ya ulupango mwanza umwe kwa mwaka. Kezayasafya kwa damu ya nhambiko ya uhasanyi mwanza umwe chila mwaka muna zinyelesi zenu zose, mana lupango ulo lwela ng'hani kumwangu niye Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Vondauwapete Waisilaili, chila munhu kezamuliha maliho Mndewa Mulungu kwa ichimu cha ugima wake muladi hagati yawo sekekuwe na mitamu ihile lusita lwa kupetigwa. ");
INSERT INTO cwe_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Chila munhu yopetigwa kolondeka yalihe nusu shekeli ya hela, fana viipimigwe muna dihema da Mulungu. Ino niiyo nhosa yondayanilavile niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Chila munhu yopetigwa kwandusila miyaka malongo maidi na kugendelela, kezanilavila niye Mndewa Mulungu nhosa iyo. ");
INSERT INTO cwe_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Tajili sekeyalave kufosa nudu shekeli iyo ya hela hebu ngayengaye sekeyalave chidogo ya nusu shekeli iyo ya hela vomumulavila Mndewa Mulungu nhambiko ya kuilumba kwa ichimu cha ugima wenu. ");
INSERT INTO cwe_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kwizahokela maliho yayo ya kuilumba kulawa kwa Waisilaili na kwizayasang'hanila kwa sang'hano za hema da Mulungu, nayo yawe lukumbuso kwa Waisilaili haulongozi wangu niye Mndewa Mulungu muladi kuwatendelani kuilumba.” ");
INSERT INTO cwe_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Kwizatengeneza ziga dodiumbigwe kwa shaba da kunawila dili na kalilo da shaba, udike hagati ya dihema da Mulungu na ulupango, na kudiguma mazi mgati yake. ");
INSERT INTO cwe_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haluni na wanage wezasang'hanila mazi yayo kunawa makono yawo na migulu yawo, ");
INSERT INTO cwe_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Lusita wang'hali hawanakwingila muna dihema da Mulungu hebu kukwenhuka habehi ya lupango muladi kumulavila Mndewa Mulungu nhambiko za kutimbuligwa kwa moto. Wezatenda ivo muladi sekewadanganike. ");
INSERT INTO cwe_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Wolondeka wanawe makono yawo na migulu yawo muladi sekewadanganike. Dino dizakuwa lagilizo jawo siku zose, kwandusila Haluni na wanage na kugendelela.” ");
INSERT INTO cwe_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Kwizasola vilungo vinogile ng'hani fana vino, manemane ya mazi chilo sita, mdalasini uli na mnung'ho unogile chilo nhatu, vilungo vinung'hila goya chilo nhatu, ");
INSERT INTO cwe_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na modeli imwenga ya mdalasini chilo sita, ningo izo zose ziwe za kwiilinga na ningo za hema da Mulungu, iviya uyahanganye na lita nne za mavuta ya mzaituni. ");
INSERT INTO cwe_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Kwa vilungo ivo kwizatenda mavuta yelile na uyahanganye fana munhu yokwenga mavuta yonung'hila goya, mavuta yayo yela kwa kuhaka. ");
INSERT INTO cwe_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Maabaho mavuta yayo kwizayagida muna dihema da Mulungu na sanduku da lagano ");
INSERT INTO cwe_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","na meza na via vake vose, chinala cha chitasa na via vake, lupango lwa kusomela ubani ");
INSERT INTO cwe_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","na lupango lwa kutimbulila nhambiko na via vake vose na ziga na kalilo jake. ");
INSERT INTO cwe_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Kwizavibagula vinhu ivo, muladi veleng'hani. Chochose chondachidalise vinhu ivo, chizakuwa chela. ");
INSERT INTO cwe_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Maabaho umuhake mavuta yelile Haluni na wanage na kuwabagula muladi wanisang'hanile fana wakulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Walongele wanhu wa Isilaili, ‘Yano yezakuwa mavuta yangu yelile ya kuhaka muna zinyelesi zenu zose. ");
INSERT INTO cwe_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mavuta yayo sekemumgidile munhu imwenga yoyose, hebu sekemutengeneze mavuta yamwenga yalingile yano, mavuta yano yela na lusita lose yolondeka yele kumwenu. ");
INSERT INTO cwe_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Munhu yoyose yondayenge mavuta fana yano hebu kumuhaka munhu imwenga yoyose halondeka kuhakigwa mavuta yano, kezawingigwa na wanhu wake.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mndewa Mulungu kamulongela Musa, “Sola vilungo vino vili umulile, natafi na shekelesi na kelibena, vilungo vili na mnung'ho unogile, hamwe na ubani unogile. Vinhu ivo vose viwe va ningo imwe. ");
INSERT INTO cwe_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Maabaho kwizasang'hanila via ivo kutengenezela ubani fana viutengenezigwa na munhu yotenda vinhu vonhung'hila goya, ubani uli na munyu na mzelu na wela. ");
INSERT INTO cwe_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Maabaho kwizaudunda uwe usage lunhili muladi usang'haniligwe muna dihema da Mulungu na kuwika haulongozi wa disanduku da lagano, hanhu hondaniiting'hane na weye, uwo kumwenu wizakuwa ubani welile ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Sekemuitendele wenyewo ubani ulingile vino, ubani uwo wizakuwa wela kumwenu haulongozi wangu niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Munhu yoyose yoitengenezela ubani ulingile uwo na kuusang'hanila fana mavuta yonung'ha goya, kezawingigwa na wanhu wake.” ");
INSERT INTO cwe_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Nimsagula Bezaleli, mwana wa Uli, mzukulu wa Huli, kulawa kabila da Yuda, ");
INSERT INTO cwe_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","na nimmemeza Muhe wangu. Nimwing'ha udahi na kuzowela na nzewele na umanyi wa kutengeneza vinhu, ");
INSERT INTO cwe_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","muladi yatole sang'hano za umanyi, yahonde zahabu na hela na shaba, ");
INSERT INTO cwe_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","na kusongola mabwe ya kuhamba na kusongola mibiki na kutenda ufundi wa chila modeli. ");
INSERT INTO cwe_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Iviya nimsagula Oholiabu mwana wa Ahisamaki, kulawa kabila da Dani, yamtaze. Iviya niweng'ha udahi mkulu wanhu wamwenga kwa ichimu cha sang'hano mbasakanyo, muladi watengeneze vinhu vose vinikulagilize. ");
INSERT INTO cwe_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Watengeneze hema da Mulungu na sanduku da lagano na ngubiko iyo ya kuilumba ili uchanyha yake, hamwe na via vake vose, ");
INSERT INTO cwe_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","meza na via vake na chinala cha chitasa na via vake vose na lupango lwa kusomela ubani, ");
INSERT INTO cwe_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","lupango lwa kutimbulila nhambiko na via vake vose, ziga na kalilo jake, ");
INSERT INTO cwe_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","na mawalo yabotigwe vinogile, mawalo yelile ya mkulu wa nhambiko Haluni na mawalo ya wanage wondawatende sang'hano ya ukulu wa nhambiko, ");
INSERT INTO cwe_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mavuta yelile na ubani wili na mnung'ho unogile kwa ichimu cha hanhu helile. Vinhu ivo vizatengenezigwa fana viya vinikulagilize.” ");
INSERT INTO cwe_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Walongele wanhu wa Isilaili, ‘Izindilileni siku yangu ya Mhumulo, mana chino ni chilaguso hagati ya niye na mweye kwa nyelesi zenu zose, ivo mwizavimanya kuwa kweli niye niiyo Mndewa Mulungu, yonimtendani mwele. ");
INSERT INTO cwe_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Molondeka muizindilile Siku ya Mhumulo, kwaviya yela kumwenu. Munhu yoyose yoitenda siku iyo yambule mwiko, kolondeka yakomigwe. Munhu yoyose yosang'hana usang'hano siku iyo, kolondeka yawingigwe na wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sang'haneni sang'hano zenu kwa siku sita, mbali siku yesaba ni siku ya kuhumula ni yela, siku iniibagule niye Mndewa Mulungu. Munhu yoyose yosang'hana usang'hano muna Isiku ya Mhumulo, kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Waisilaili waizindilile Siku ya Mhumulo na waitende kwa nyelesi zawo zose fana viya lagano da siku zose. ");
INSERT INTO cwe_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Chizakuwa chilaguso hagati ya niye na Waisilaili siku zose, mana niye Mndewa Mulungu nilumba ulanga na isi kwa siku sita, mbali siku yesaba nileka kusang'hana usang'hano na nihumula.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mndewa Mulungu viyakomeleze kulonga na Musa kuna mulima wa Sinai, kamwing'ha Musa vibawo vidi va mabwe ya ukalangama, vandikigwe malagilizo kwa chidole cha Mulungu mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Wanhu viwawonile Musa kakalama kuhumuluka kulawa kuna mulima, waiting'hana kumzunguluka Haluni na wamulongela, “Chitengenezele nyang'hiti za milungu yondaichilongoze. Musa yoyachilavile kuna iisi ya Misili, hachivimanyile kapatigwa na choni.” ");
INSERT INTO cwe_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haluni kawedika, soleni heleni za zahabu muna yamagutwi ya wake zenu na wanenu, munigalile. ");
INSERT INTO cwe_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ivo wanhu wose wahambula heleni zawo za zahabu na wamgalila Haluni. ");
INSERT INTO cwe_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Haluni kazihokela kulawa muna yamakono yawo na katengeneza dang'ang'a lume da wa ng'ombe wa zahabu. Wanhu walonga, “Weye Isilaili, ino iyo mulungu wetu, yoyachilavile kuna iisi ya Misili!” ");
INSERT INTO cwe_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Maabaho Haluni viyawonile ivo, kazenga lupango haulongozi ha didang'ang'a na kalonga, “Igolo kwizakuwa na dugila da kumuhishimu Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Igolo yake wanhu waidawa walava nhambiko za kutimbula na nhambiko za tindiwalo. Wanhu wakala hasi kuja na kung'wa, maabaho wema na kuvina. ");
INSERT INTO cwe_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Maabaho Mndewa Mulungu kamulongela Musa, “Humuluka, kwaviya wanhu wako wouwalavile kuna iisi ya Misili wahasanya. ");
INSERT INTO cwe_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Waileka nzila ija yoniwalagilize kuisondelela, watenda dang'ang'a lume da zahabu na kuditambikila na kudilavila nhosa, wolonga, ‘Weye Isilaili, ino niiyo mulungu wetu, yoyachilavile kuna iisi ya Misili!’ ” ");
INSERT INTO cwe_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mndewa Mulungu kamulongela Musa, “Niwawona wanhu wano, wana mizoyo midala. ");
INSERT INTO cwe_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Lelo sekeunigomese, nileke niwadanganize kwa ludoko lwangu. Maabaho kufosela weye, nizatenda wanhu wa kabila kulu.” ");
INSERT INTO cwe_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mbali Musa kamulamba Mndewa Mulungu, Mulungu wake, kamulongela, “Weye Mndewa Mulungu, habali kuna ludoko na wanhu wako wouwalavile kuna iisi ya Misili kwa udahi wako mkulu na mkono wako uli na ludabwa? ");
INSERT INTO cwe_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","One uhatenda ivo, Wamisili wezadaha kulonga kuwa kawalava muna iisi ya Misili muladi kuwakoma muna mulima na kuwananga. Galula magesa yako ya ludoko na sekeuwatende wanhu wako mbuli zihile. ");
INSERT INTO cwe_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wakumbuke wasang'hani wako, Bulahimu na Isaka na Yakobo, wouwalahile kwa kulonga, ‘Nizakongeza welesi wenu fana nhondo za kuulanga na nizaweng'ha welesi wenu isi ino yose yonimulahileni kuweng'ha, izakuwa yawo siku zose.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mndewa Mulungu kagalula magesa yake ya kuwatendela wanhu wake mbuli zihile zoyalongile. ");
INSERT INTO cwe_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Maabaho Musa kahumuluka kulawa kuna mulima kuno kamha vibawo vidi va mabwe va ukalangama muna yamakono yake, vandikigwe banzi zose. ");
INSERT INTO cwe_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Vibawo ivo vikala sang'hano ya Mulungu, mwandiko wandikigwa na Mulungu mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoshua viyahulike madizi ya wanhu woguta, kamulongela Musa, “Nohulika dizi da ng'hondo muna dilago.” ");
INSERT INTO cwe_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa kamwidika, “Siyo dizi da kuhuma hebu kuhumwa, mbali dizi da wanhu wokwimba.” ");
INSERT INTO cwe_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa viyafikile mudilago na kuwona dang'ang'a na wanhu wovina, kawona ludoko ng'hani. Kavasa ivibawo viya kulawa muna yamakono yake na kuvibena haja hasi ya mulima. ");
INSERT INTO cwe_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kasola dang'ang'a lume dowatendile na kadisoma moto, maabaho kadidunda mbaka diwa usage, kakologa usage uwo muna yamazi na kawawangiliza Waisilaili wang'we. ");
INSERT INTO cwe_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa kamuuza Haluni, “Wanhu wano wakutenda choni mbaka kuwatenda watende uhasanyi mkulu ivo?” ");
INSERT INTO cwe_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haluni kamwidika, “Sekeuniwonele ludoko niye msang'hani wako. Kuwamanya wanhu wano viwaisasale kutenda yehile. ");
INSERT INTO cwe_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Wanilongela, ‘Chitendele milungu yondaichilongoze. Musa yoyachilavile kuna iisi ya Misili hachivimanyile kapatigwa na choni.’ ");
INSERT INTO cwe_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Niwalongela, ‘Chila munhu yeli na vinhu va zahabu yavigale. Ivo wanigalila, nivilumbula muna umoto na dang'ang'a lume dilawilila!’ ” ");
INSERT INTO cwe_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa kawona kuwa wanhu wamuleka Mulungu na wotenda viwolonda. Haluni kawalekela wamuleke Mulungu na watende viwolonda, na kuigalila chinyala haulongozi ha wehi wawo. ");
INSERT INTO cwe_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ivo Musa kema haulongozi ha ulwivi lwa dilago na kulonga, “Yoyose yeli ubanzi wa Mndewa Mulungu, yeze hano!” Ivo welesi wose wa Lawi waiting'hana kumzunguluka. ");
INSERT INTO cwe_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kawalongela, “Mndewa Mulungu, Mulungu wa Isilaili, kolonga, ‘Chila mulume yaifunge panga jake muna ichigudi, yazunguluke chila hanhu muna dilago, kulawa lwivi lumwe mbaka umwenga, chila munhu yamkome ndugu yake na mbwiyake na mkaya miyage.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Walawi watenda fana Musa viyalongile. Siku iyo wanhu elufu nhatu wakomigwa. ");
INSERT INTO cwe_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Maabaho Musa kalonga, “Diyelo mwikigwa kwa sang'hano ya Mndewa Mulungu, kwaviya hamulemile kuwakoma wanenu na ndugu zenu. Mndewa Mulungu yamtemeleni mate diyelo idino.” ");
INSERT INTO cwe_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Igolo yake Musa kawalongela wanhu, “Muhasanya ng'hani. Mbali sambi nizahita kuchanyha kwa Mndewa Mulungu, yodahika nizadaha kuilumba kwa ichimu chenu.” ");
INSERT INTO cwe_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa kabwela kaidi kwa Mndewa Mulungu na kumulongela, “Ona, yaja yawatendile wanhu wano yakala uhasanyi mkulu! Wakala waitendela milungu ya zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mbali lelo nokulamba walekelele uhasanyi wawo. One huwalekelele, nokulamba unisegeze muna ichitabu chako chowandike mazina ya wanhu wako.” ");
INSERT INTO cwe_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mndewa Mulungu kamwidika Musa, “Wanhu wose wowanhendele uhasanyi nizawasegeza muna ichitabu changu. ");
INSERT INTO cwe_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Lelo hita ukawalongoze wanhu mbaka hanhu honikulongele. Msenga wangu wa kuulanga kezakulongolela. Siku yondaniwezileni, nizawatagusa kwa ichimu cha uhasanyi wawo.” ");
INSERT INTO cwe_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ivo Mndewa Mulungu kawagalila wanhu tamu dihile, kwaviya wamulongela Haluni yawatendele dang'ang'a lume da zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mndewa Mulungu kamulongela Musa, “Segeleni hano, weye na wanhu wouwalavile kuna iisi ya Misili, muhite kuna iisi yoniwalahile Bulahimu na Isaka na Yakobo, nilonga, ‘Isi ino nizaweng'ha welesi wenu.’ ");
INSERT INTO cwe_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nizamtuma msenga wa kuulanga yawalongolele, nizawawinga Wakanaani na Waamoli na Wahiti na Wapelizi na Wahivi na Wayebusi. ");
INSERT INTO cwe_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Hiteni kuna iisi ili na ulongo unogile. Mbali sizahita hamwe na mweye kwaviya mweye ni wanhu muli na mizoyo midala, muladi sekeniwadanganize muna inzila.” ");
INSERT INTO cwe_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Wanhu viwahulike mbuli zino zihile, wandusa kulila kwa usungu na habule munhu yavalile mahambo. ");
INSERT INTO cwe_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Mana Mndewa Mulungu kamulongela Musa, “Walongele Waisilaili, ‘Mweye ni wanhu muli na mizoyo midala. One nihitile hamwe na mweye kwa lusita, nahadahile kumkomani. Ivo hambuleni mahambo yenu na nizalamula va kutenda.’ ” ");
INSERT INTO cwe_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ivo wanhu wa Isilaili wahambula mahambo yawo kuna mulima wa Holebu. ");
INSERT INTO cwe_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa kakala na chihendo cha kudisola dihema dimwenga na kudisimika kunze ya lago. Hema ijo kaditanga, “Hema da mting'hano.” Munhu yoyose yalondile kumpula Mndewa Mulungu kahita kuna dihema ijo, kunze kutali chidogo na dilago. ");
INSERT INTO cwe_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Chila lusita Musa viyohita kuna dihema, wanhu wose wema hana ihanhu ha kwingilila muna dihema jake na kumulola Musa mbaka viyengile muna dihema ijo. ");
INSERT INTO cwe_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa viyengile muna dihema, wingu dilingile fana mhanda dihumuluka hasi hana ihanhu hakwingilia hana dihema, Mndewa Mulungu kamulongela Musa kulawa muna diwingu. ");
INSERT INTO cwe_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wanhu wose viwawonile wingu dilingile fana mhanda hana ihanhu ha kwingilila hana dihema, chila imwe wawo katambika hana ihanhu baho ha kwingilila. ");
INSERT INTO cwe_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Vino niivo Mndewa Mulungu viyalongile na Musa chihanga kwa chihanga, fana viya munhu kolonga na mbwiyake. Maabaho Musa kabwela kuna dilago. Yoshua, mwana wa Nuni, mbwanga yoyakalile msang'hani wake, kasigala muna dihema. ");
INSERT INTO cwe_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa kamulongela Mndewa Mulungu, “Kunilongela, ‘Walongoze wanhu wano,’ mbali hunilongele yelihi yondaumtume na niye. Kulonga, ‘Nikumanya kwa zina jako na ninogeligwa na weye.’ ");
INSERT INTO cwe_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ivo one kunogeligwa na niye, nilagusile nzila zako, muladi nikumanye na kugendelela kunogelwa na niye. Ukumbuke kuwa wanhu wa kabila dino ni wako.” ");
INSERT INTO cwe_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mndewa Mulungu kalonga, “Niye nizahita na weye, nizakutenda uhumule.” ");
INSERT INTO cwe_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa kamulongela, “One huhita hamwe na cheye, sekeuchisegeze hanhu hano. ");
INSERT INTO cwe_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Vino nizavimanyaze kuwa kunogeligwa na niye na wanhu wako, one huhitile hamwe na cheye? Uhahita hamwe na cheye izachitenda niye na wanhu wako kuwa wanhu wa chiiyeka mwa iwanhu wako.” ");
INSERT INTO cwe_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mndewa Mulungu kamulongela Musa, “Nizatenda fana viya viunilongele, kwaviya ninogeligwa na weye na nikumanya kwa zina jako.” ");
INSERT INTO cwe_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa kalonga, “Nokulamba, nilaguse utunhizo wako.” ");
INSERT INTO cwe_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Mndewa Mulungu kamwidika, “Nizafosa haulongozi wako na kukulagusa unovu wangu wose. Niye nizagong'onda zina jangu, ‘Mndewa Mulungu.’ Nizamnogela ija yonilonda kumnogela na nizamuwonela ubazi ija yonilonda kumuwonela ubazi.” ");
INSERT INTO cwe_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Mbali kalonga, “Sizakuleka uwone chihanga changu, mana munhu yahaniwona niye hawa mgima.” ");
INSERT INTO cwe_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Maabaho Mndewa Mulungu kamulongela Musa, “Hana hanhu habehi yangu, hondaudahe kwima uchanyha ya luwe. ");
INSERT INTO cwe_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Utunhizo wangu viufosa, nizakuguma muna imbane muuluwe na kukugubika kwa mkono wangu, mbaka vondanifose. ");
INSERT INTO cwe_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Maabaho nizasegeza mkono wangu na kwizaniwona ichisogo, mbali chihanga changu whizachiwona.” ");
INSERT INTO cwe_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Maabaho Mndewa Mulungu kamulongela Musa, “Songola vibawo vidi va mabwe vilingile fana viya va mwanduso, niye nizavandika mbuli ziya zonizandike muna ivibawo va mwanduso vouvibenile. ");
INSERT INTO cwe_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Isasale igolo imitotondo ukwele kwiichisuili cha mulima wa Sinai uiting'hane na niye. ");
INSERT INTO cwe_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Munhu yoyose sekeyeze hamwe na weye, hebu sekeyawoneke hanhu hohose kuna mulima, hebu ng'ombe na ng'hondolo sekewadimigwe kuna mulima.” ");
INSERT INTO cwe_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ivo Musa kasongola vibawo vidi va mabwe fana viya va mwanduso. Igolo yake chilochilo kasegela, kakwela kumulima wa Sinai, fana Mndewa Mulungu viyamulagilize. Kuno kamha vibawo viya vidi va mabwe muna yamakono yake. ");
INSERT INTO cwe_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Mndewa Mulungu kahumuluka muna diwingu, kema na Musa haja. Mndewa Mulungu kagong'onda zina jake. ");
INSERT INTO cwe_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Maabaho Mndewa Mulungu kafosa haulongozi ha Musa, kagong'onda, “Mndewa Mulungu, Mndewa Mulungu, Mulungu nili na ubazi na unovu, nabule ludoko lwa himahima, nimema ulondo wa kufunya umoyo na kwaminika. ");
INSERT INTO cwe_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nolagusa ulondo wa kufunya umoyo kwa nyelesi maelufu, nolekelela ubananzi na uhasanyi, mbali sizaleka kuwatagusa wana na wazukulu wa nyelesi yetatu na yekane za wabananzi.” ");
INSERT INTO cwe_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa katumbala mavindi himahima mbaka chihanga chake chidalisa hasi na kamtambikila Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Kalonga, “Weye Mndewa Mulungu, fana nikunogeza, nokupula uhite hamwe na cheye. Wanhu wano wana mizoyo midala, mbali uchilekelele wihi wetu na uhasanyi wetu, uchihokele fana wanhu wako mwenyewo.” ");
INSERT INTO cwe_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mndewa Mulungu kamulongela Musa, “Sambi notenda lagano. Haulongozi ha wanhu wako nizatenda mauzauza yaja hayanalawilila muna iisi yose, hebu muna dikabila jojose. Wanhu wose womukala nawo wezawona sang'hano zangu ng'hulu. Mana nizatenda na weye mbuli za mauzauza na za kudumbiza. ");
INSERT INTO cwe_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Yamha malagilizo yonikwing'ha diyelo. Nizawawinga haulongozi wako Waamoli na Wakanaani na Wahiti na Wapelizi na Wahivi na Wayebusi. ");
INSERT INTO cwe_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Uiteganye sekeutende lagano na wanhu wokala muna iisi youhita, kwaviya dizakuwa mtego hagati yako. ");
INSERT INTO cwe_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Kwizabomola milupango yawo na kuzibena mhanda zawo za kutambikila na mibiki ya milungu yawo ya Ashela. ");
INSERT INTO cwe_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Sekeutambikile milungu imwenga, kwaviya niye Mndewa Mulungu nomanyika kwa zina, ‘Yeli na migongo,’ niye ni Mulungu yeli na migongo. ");
INSERT INTO cwe_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Sekeutende lagano jojose na wanhu wa isi iyo, kwaviya wanhu vondawasondelele milungu yawo fana munhu yoyotenda ugoni na vondawaitambikile, wezakugoneka. Weye kwizakuja ndiya zowotambikila milungu yawo, ");
INSERT INTO cwe_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","na uhawasagula wandele wawo wawe wake wa wanago, na wandele wawo wotambikila milungu yawo, wezawasongeza wabwanga zenu wasondelele milungu yawo fana wanhu wowotenda ugoni. ");
INSERT INTO cwe_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Sekeuitendele nyang'hiti za milungu ya zuma. ");
INSERT INTO cwe_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Tenda Dugila da Magate Hayagumigwe Lusu. Kwa siku saba kwizakuja magate hayagumigwe lusu fana vinikulagilize lusita lwikigwe muna umwezi wa Abibu. Mana muna umwezi uwo kulavigwa muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Wana wa udele wose ni wangu, hamwe na wana wa udele wa chilume wa wanyama wako wose, ng'ombe na ng'hondolo. ");
INSERT INTO cwe_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mbali chaudele wa chihongwe kwizamkombola kwa kunilavila mwanang'hondolo, one humkombole, mbene isingo. Wakombole wanago wa udele wose wa chilume. “Munhu yoyose sekeyeze kumwangu bila chinhu. ");
INSERT INTO cwe_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Siku sita kwizasang'hana usang'hano, mbali siku yesaba kwizahumula, hata ihawa lusita lwa kulima hebu kugobola kwizahumula. ");
INSERT INTO cwe_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Tenda Dugila da Majuma kwa kuhuna ngano yako mwanduso, na Dugila da Kuduganya Vinhu Vimugobole kuuhelelo wa mwaka. ");
INSERT INTO cwe_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Miyanza mitatu kwa mwaka chila mulume kolondeka kuiduganya haulongozi wangu, niye Mndewa Mulungu, Mulungu wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nizawawinga wanhu wa zisi zimwenga haulongozi wako kuzongeza mhaka zenu. Habule munhu yoyose yondayaimelele mate isi yako lusita vondauiting'hane kunitambikila niye Mndewa Mulungu, Mulungu wenu, miyanza mitatu chila mwaka. ");
INSERT INTO cwe_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Sekeunilavile nhosa ya damu na lusu, hebu nhambiko ya Dugila da Pasaka sekeisigazigwe mbaka imitondo. ");
INSERT INTO cwe_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ndiya ya mwanduso ya isi yako na ndiya inogile kwizaigala kuna ikaye ya Mndewa Mulungu, Mulungu wako. “Sekeumkimuse mwanaluti muna yamatombo ya mami yake.” ");
INSERT INTO cwe_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Maabaho Mndewa Mulungu kamulongela Musa, “Yandika malagilizo yano, mana kwa mbuli zino nitenda lagano na weye na Waisilaili.” ");
INSERT INTO cwe_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa kakala kuja na Mndewa Mulungu kwa siku malongo mane, imisi na ichilo, hadile chinhu hebu hang'wile mazi. Kandika muna ivibawo mbuli za lagano na ndagilizi longo. ");
INSERT INTO cwe_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa viyahumuluke kuna mulima wa Sinai kuno kamha vibawo vidi va ukalangama muna umkono wake vandikigwe mbuli za lagano, havimanyile kuwa chihanga chake chikala chikwaka kwaviya kalonga na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haluni na Waisilaili wose viwamuwonile Musa wadumba kumkwenhukila kwaviya chihanga chake chikala chokwaka. ");
INSERT INTO cwe_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mbali Musa kawatanga Haluni na walala wose wa Waisilaili wamkwenhukile, maabaho kalonga nawo. ");
INSERT INTO cwe_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Hamwande Waisilaili wamkwenhukila, nayo kaweng'ha ndagilizi zose ziyeng'higwe na Mndewa Mulungu kuja mulima wa Sinai. ");
INSERT INTO cwe_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa viyakomeleze kulonga nawo, kachigubika chihanga chake na chitambala. ");
INSERT INTO cwe_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Chila lusita Musa viyahitile kulonga na Mndewa Mulungu, kasegeza ichitambala mbaka viyalawile kunze. Viyalawile kunze kawalongela Waisilaili mbuli zose ziyalagilizigwe, ");
INSERT INTO cwe_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Waisilaili wachiwona chihanga cha Musa chokwaka. Musa kaigubika na chitambala kaidi mbaka lusita viyahitile kulonga na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa kawaduganya hamwe Waisilaili wose, kawalongela, “Vino ivo Mndewa Mulungu voyamulagilizeni mutende. ");
INSERT INTO cwe_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Kwa siku sita sang'haneni sang'hano zenu, mbali siku yesaba izakuwa yela kumwenu, siku ya kuhumula ng'hani Mndewa Mulungu. Munhu yoyose yondayasang'hane usang'hano muna isiku iyo kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","“Hata moto sekemukwache muna Isiku ya Mhumulo.” ");
INSERT INTO cwe_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa kawalongela wanhu wose wa Isilaili, “Chinhu chino icho Mndewa Mulungu choyamulongeleni mutende. ");
INSERT INTO cwe_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Soleni nhosa ya kumwing'ha Mndewa Mulungu muna ivinhu venu. Chila munhu yeli na moyo unogile kezamgalila Mndewa Mulungu nhosa ya zahabu na hela na shaba, ");
INSERT INTO cwe_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","na nyuzi za buluu na zambalau na ndung'hu na walo dinogile dibotigwe na mazoya ya luti. ");
INSERT INTO cwe_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Mbende za ng'hondolo lume zozihakigwe langi ndung'hu na mbende za wanyama wamwenga na mbawo za mkenge, ");
INSERT INTO cwe_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","na mavuta kwa chiya chitasa, vilungo kwa mavuta yelile na ubani uli na mnung'ho unogile, ");
INSERT INTO cwe_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","na mabwe yokwaka ya salidoniki na mabwe yokwaka yamwenga kwa ichimu cha mahambo, chifuko cha muimhambaga na chizibawo cha mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Chila munhu yeli na umanyi yeli hagati yenu yeze yatengeneze chila chinhu Mndewa Mulungu chiyalagilize, ");
INSERT INTO cwe_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","na hema da Mulungu na ngubiko yake na panzia jake na ngwamo zake na mhanda zake na makalilo yake ");
INSERT INTO cwe_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","na sanduku da lagano na mibiki yake na ngubiko ya chigoda cha ubazi na panzia da hanhu helile ng'hani, ");
INSERT INTO cwe_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","na meza na mibiki yake ya kwamhila na viya vake vose, hamwe na magate yelile yekigwe haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Na vinala va chitasa hamwe na viya vake vose, vitasa vake na mavuta yake, ");
INSERT INTO cwe_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","na lupango lwa kufukizila ubani na mibiki yake, mavuta yelile na ubani wili na mnung'ho unogile na panzia da hanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Na lupango lwa kutimbulila nhambiko hamwe na lwavu lwa shaba, mibiki yake hamwe na via vake vose na ziga na kalilo jake, ");
INSERT INTO cwe_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","na mapanzia ya luwa, na mhanda zake na vikalilo vake vose, panzia da ulwivi lwa luwa, ");
INSERT INTO cwe_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","na vigingi va hema da Mulungu na vigingi va uluwa na nzabi zake. ");
INSERT INTO cwe_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Na mawalo yoyabotigwe vinogile ng'hani kwa ichimu cha sang'hano ya hanhu helile, yaani mawalo yelile ya mkulu wa nhambiko Haluni na wanage kwa ichimu cha sang'hano zawo za ukulu wa nhambiko.” ");
INSERT INTO cwe_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Wanhu wose wa Isilaili wasegela haulongozi wa Musa, ");
INSERT INTO cwe_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","na chila munhu moyo wake womulonda kumtendela yeze na kumgalila nhosa Mndewa Mulungu kwa ichimu cha hema da Mulungu na kwa ichimu cha usang'hano wa hema ijo, na kwa mawalo yayo yelile ya ukulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Wose weli na moyo wa unyendanyenda, walume kwa wanaake wagala heleni za kuvala muna imhula na heleni za kuvala muna yamagutwi na mhete za mihuli na bangili na chila chinhu cha zahabu, chila munhu kamulavila Mndewa Mulungu chinhu cha zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Wanhu wose wagala nyuzi zawo za buluu hebu zambalau na ndung'hu hebu chitani chinogile hebu mazoya ya luti hebu mbende za ng'hondolo dihakigwe langi ndung'hu hebu mbende za wanyama wamwenga. ");
INSERT INTO cwe_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Chila munhu yadahile kulava hela hebu shaba, kaigala kwa Mndewa Mulungu fana nhosa yake. Iviya chila munhu yakalile na mbawo za mkenge kwa sang'hano yoyose kazigala. ");
INSERT INTO cwe_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Wanaake wose wadahile kubota, wagala vinhu vibotigwe kwa nyuzi za langi ya buluu na zambalau na ndung'hu na walo dinogile dibotigwe vinogile. ");
INSERT INTO cwe_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Wanaake wose mizoyo yawo yowalonda kuwatendela, wabota mazoya ya luti. ");
INSERT INTO cwe_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Walangulizi wagala mabwe ya yotangigwa salidoniki na mabwe ya kwikigwa muna ichifuko cha muimhambaga na chizibawo. ");
INSERT INTO cwe_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Iviya wagala vilungo na mavuta ya mzaituni kwa ichimu cha chitasa na mavuta yelile na ubani uli na mnung'ho unogile. ");
INSERT INTO cwe_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Waisilaili wose walume kwa wanaake, wowalondile muna umoyo wawo kugala chinhu chochose kwa kusang'hana usang'hano uja Mndewa Mulungu uyamulagilize Musa usang'hanike, wagala vinhu ivo kuwa nhambiko ya kulonda wenyewo kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa kawalongela Waisilaili, “Mndewa Mulungu kamsagula Bezaleli, mwana wa Uli, mzukulu wa Huli kulawa kabila da Yuda. ");
INSERT INTO cwe_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Mulungu kammemeza muhe wake na kamwing'ha udahi na nzewele na umanyi na ufundi ");
INSERT INTO cwe_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","muladi yatole sang'hano za umanyi, yahonde zahabu na hela na shaba, ");
INSERT INTO cwe_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","na kusongola mabwe ya kuhamba na kusongola mibiki na kutenda ufundi wa chila modeli. ");
INSERT INTO cwe_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Iviya kamulongoza yeye na Oholiabu mwana wa Ahisamaki, wa kabila da Dani wawe na udahi wa kuwafunza wamwenga. ");
INSERT INTO cwe_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Mndewa Mulungu kaweng'ha udahi wa kusang'hana chila sang'hano ya ufundi hebu yoitendigwa na wanhu wa umanyi hebu mafundi wa kutalizi kwa nyuzi za langi ya buluu na zambalau na ndung'hu na walo dinogile dibotigwe kwa kusang'hanila ufundi wowose wa msanii. ");
INSERT INTO cwe_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bezaleli na Oholiabu na wasang'hani wamwenga waja Mndewa Mulungu yaweng'hile nzewele na umanyi, waja wavimanyile kutenda chila chinhu chochilondeka kuzengela hema da Mulungu, wezatenda chila chinhu fana viya Mndewa Mulungu viyamulagilize Musa.” ");
INSERT INTO cwe_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa kamtanga Bezaleli na Oholiabu na mafundi wamwenga waja Mndewa Mulungu yaweng'hile udahi, wowolonda kutaza. Musa kawalongela wanduse usang'hano. ");
INSERT INTO cwe_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Wahokela kulawa kwa Musa vinhu vose vilavigwe na Waisilaili kwa ichimu cha sang'hano za hema da Mulungu. Wanhu wagendelela kumgalila Musa nhambiko zawo chila imitondo kwa kulonda wenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ivo wanhu waja weli na ufundi wowatendile sang'hano zose muna dihema wahita ");
INSERT INTO cwe_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","na wamulongela Musa, “Wanhu wagala vinhu vingi kufosa viya vovilondeka kwa usang'hano uja uyachilagilize Mndewa Mulungu chiusang'hane.” ");
INSERT INTO cwe_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musa kalagiliza na mbuli iyo igong'ondigwa muna dilago, “Chila munhu, mulume hebu mwanamke, sekeyagale vitumetume vingi kwa ichimu cha hema da Mulungu.” Wanhu wagomesigwa kugala vinhu, ");
INSERT INTO cwe_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","kwaviya vinhu viwagalile vifaya kwa sang'hano iyo yose na vimwenga visigala. ");
INSERT INTO cwe_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Walume wose weli na udahi wazenga hema da Mulungu kwa mapanzia longo ya mawalo yanogile yabotigwe kwa nyuzi za langi ya buluu na za zambalau na ndung'hu na kuhamba vilumbe walingile fana wasenga wa kuulanga wasongoligwe na fundi. ");
INSERT INTO cwe_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Mapanzia yose yakala na utali wa mita longo na mbili na ugalamu mita mbili. Mapanzia yose yakala na ningo imwe. ");
INSERT INTO cwe_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Kayalumbiliza mapanzia matano kutenda chihande chimwe na kutenda ivo ivo yaja yamwenga matano. ");
INSERT INTO cwe_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Kasona vitanzi va buluu muimhindo ya dipanzia da uhelelo da chihande cha mwanduso, vitanzi vimwenga muna dipanzia da uhelelo da chihande cha uhelelo. ");
INSERT INTO cwe_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Kagela vitanzi malongo matano muna dipanzia da mwanduso da chihande cha mwanduso na vitanzi malongo matano muna uhelelo wa panzia dekaidi, vitanzi vose viilola. ");
INSERT INTO cwe_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Maabaho katengeneza vihindo malongo matano va zahabu muladi kulumbilizila vihande vidi va panzia, ivo hema da Mulungu diwa chinhu chimwe. ");
INSERT INTO cwe_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Iviya katenda ngubiko imwenga ya hema jeile kwa mapanzia longo na dimwe ya mazoya ya luti. ");
INSERT INTO cwe_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Wayatenda yose yailinge, utali wa mita longo na tatu na ugalamu mita mbili. ");
INSERT INTO cwe_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Kayalumbiliza mapanzia matano hamwe na mapanzia sita hamwe. ");
INSERT INTO cwe_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Maabaho kagela vitanzi malongo matano muimhindo ya panzia da uhelelo da chihande cha mwanduso na vitanzi malongo matano muimhindo ya chihande chekaidi. ");
INSERT INTO cwe_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Maabaho katenda vihindo malongo matano va shaba muladi kulumbiliza viya vihande vidi va mapanzia, muladi kutenda panzia dimwe da hema. ");
INSERT INTO cwe_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Maabaho katenda ngubiko ya mbende sisili ya bebelu da ng'hondolo dihakigwe langi ndung'hu uchanyha ya ngubiko imwenga ya mbende sisili ya mnyama imwenga. ");
INSERT INTO cwe_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Maabaho katenda mibiki ya mkenge ya kwimizila dihema. ");
INSERT INTO cwe_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Chila mbiki ukala na utali wa mita nne na ugalamu wa sentimita malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Chila mbiki lukala na ndimi mbili za kulumbilizila. Mibiki yose ya hema kaitendela ndimi. ");
INSERT INTO cwe_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Katenda mibiki malongo maidi ubanzi wa kusi wa hema ");
INSERT INTO cwe_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","na vikalilo malongo mane va hela hasi ya mibiki iyo malongo maidi hasi ya chila mbiki muladi kwamhilila ziya zindimi zake mbili. ");
INSERT INTO cwe_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ubanzi wa kasikazi wa hema, katenda mibiki malongo maidi ");
INSERT INTO cwe_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na vikalilo vake malongo mane va hela, vikalilo vidi hasi ya chila mbiki. ");
INSERT INTO cwe_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Kwa ubanzi wa kuchisogo wili uswelo wa zuwa wa hema katenda mibiki sita. ");
INSERT INTO cwe_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Na katenda mibiki midi kwa ichimu cha vingobweda va dihema ubanzi wake wa kuchisogo. ");
INSERT INTO cwe_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Mibiki iyo ya hasi iileke mbali ilumbilizigwe kwa kuchanyha kuna imhete imwe. Mibiki yose ya ivingobweda kaitenda ivo ivo muladi itende mbili. ");
INSERT INTO cwe_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ivo kukala na mibiki minane hamwe na vikalilo vake longo na sita va hela. ");
INSERT INTO cwe_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Iviya katenda mapalo ya mkenge, mapalo matano kwa ichimu cha mibiki ya ubanzi umwe wa hema, ");
INSERT INTO cwe_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","mapalo matano kwa ichimu cha ubanzi umwenga wa hema, na mapalo matano kwa ichimu cha mibiki ya kuchisogo cha hema na ubanzi wa uswelo wa zuwa. ");
INSERT INTO cwe_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Katenda palo da hagati difikile nusu ya zengo da hema dodiibebenyeke hagati kulawa uhelelo umwe mbaka uhelelo umwenga wa hema. ");
INSERT INTO cwe_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Mibiki yose kaihaka zahabu na kaitendela mhete za zahabu za kwamhilila mapalo yayo yoyahakigwe zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Katenda panzia da nyuzi za langi ya buluu na zambalau na ndung'hu na walo dinogile dibotigwe. Panzia ijo dihambigwa vinogile kwa vilumbe vilingile fana wasenga wa kuulanga wasongoligwe na fundi. ");
INSERT INTO cwe_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Katumbika dipanzia muna izimhanda nne za mkenge zozihakigwe zahabu, zili na ngwamo za zahabu na vikalilo vine va hela. ");
INSERT INTO cwe_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Iviya katenda panzia da nyuzi za langi ya buluu na za zambalau na ndung'hu na walo dinogile dibotigwe kwa ichimu cha hanhu ha kwingilila muna dihema. Panzia dihambigwa vinogile. ");
INSERT INTO cwe_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Katenda mhanda zake tano hamwe na ngwamo za zahabu. Hanhu ha uchanyha yake na vihindo vake kavihaka zahabu, mbali vikalilo vake vitano vikala va shaba. ");
INSERT INTO cwe_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleli katenda sanduku da lagano kwa mibiki ya mkenge, utali wake ukala sentimita gana na longo, ugalamu wake sentimita malongo sita na chimo chake sentimita malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Kahaka zahabu yelile mgati na kunze na kuditendela lukingilo lwa zahabu banzi zose. ");
INSERT INTO cwe_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Maabaho katenda mhete nne za zahabu za kudipapila muna imigulu yake mine, mhete mbili ubanzi wake umwe na mhete mbili ubanzi wake wekaidi. ");
INSERT INTO cwe_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Katenda mibiki ya kupapila ya mkenge na kuhaka zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Mibiki iyo kaifoseza muna zimhete zili muna zibanzi mbili za sanduku kwa ichimu cha kupapila. ");
INSERT INTO cwe_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Maabaho katenda ngubiko ya zahabu yelile, utali wake sentimita gana na longo na ugalamu wake ukala sentimita malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Maabaho kasongola vilumbe vidi vilingile fana wasenga wa kuulanga kwa kuhonda zahabu hana imihelelo ya ngubiko iyo, ");
INSERT INTO cwe_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","chilumbe chimwe uhelelo umwe na chilumbe chimwenga uhelelo umwenga. Katenda vilumbe wawo walingile fana wasenga wa kuulanga kuna imihelelo ya ngubiko iyo, viwa chinhu chimwe na ngubiko. ");
INSERT INTO cwe_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Vilumbe ivo vilingile fana wasenga wa kuulanga vikunjula mabawa yawo kuchigubika ngubiko ya kuiumba. Vilumbe ivo vihindukila kuchilola ngubiko iyo. ");
INSERT INTO cwe_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Kasongola meza ya mbiki wa mkenge, utali wake sentimita malongo manane na nane na ugalamu wake sentimita malongo mane na nne na chimo chake sentimita malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Kaihaka zahabu yelile na kuitendela lukingilo lwa zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Maabaho kachizungulusila lukingilo lumwenga lwa zahabu lwili na ugalamu wa sentimita nane. ");
INSERT INTO cwe_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Kaitendela imeza iyo mhete nne za zahabu na kuziguma muna ivingobweda vake vine haimile imigulu. ");
INSERT INTO cwe_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Mhete izo zikala habehi na lukingilo luja lwa kuzunguluka meza na zikala za kwamhilila mibiki ya kupapila imeza iyo. ");
INSERT INTO cwe_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Katenda mibiki ya mkenge ya kupapila, maabaho kaihaka zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Katenda via va zahabu yelile va kwika uchanyha ya meza, vyano na nhungo kwa ichimu cha ubani na mabuyu na vihamha kwa ichimu cha kugidila nhosa za ching'waji. ");
INSERT INTO cwe_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Katenda chinala cha chitasa kwa zahabu yelile. Itendigwe kwa kuhonda, kalilo jake na mbiki wake na nhungo zake na matumba yake na maluwa yake, vose vitendigwa kwa chihande chimwe. ");
INSERT INTO cwe_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Matambi sita yalawilila hana ichinala cha lukingo lwake, matambi matatu ubanzi umwe na matambi matatu ubanzi umwenga. ");
INSERT INTO cwe_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Muna ditambi kuna nhungo nhatu zilingile fana matumba na maluwa yotangigwa alimondi, muna ditambi disondelela kuna tumba jake na luwa jake. Matambi yose sita yawa fana viya chinala cha chitasa ");
INSERT INTO cwe_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na muna ichinala muna nhungo nne zozitendigwe zilingile fana maluwa yotangigwa alimondi, hamwe na ving'honyo va maluwa yake. ");
INSERT INTO cwe_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Hanhu halawilila chila jozi ya matambi yaja sita, hasi yake hana tumba dimwe dimwe. ");
INSERT INTO cwe_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Matumba yayo na matambi yake yawa yake, yawa chinhu chimwe. Chinala icho chose chihondigwa kwa zahabu yelile. ");
INSERT INTO cwe_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Maabaho katenda vitasa vake saba na makoleo yake na vyano vake kwa zahabu yelile. ");
INSERT INTO cwe_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Katenda chinala icho na via vake vose kwa vibaba malongo matatu na tano va zahabu yelile. ");
INSERT INTO cwe_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Maabaho kazenga lupango lwa kusomela ubani kwa mbiki wa mkenge. Utali wa lupango ulo na ugalamu viilinga, utali ukala sentimita malongo mane na tano na ugalamu ukala sentimita malongo mane na tano na chimo chake sentimita malongo kenda. Mahembe ya lupango ulo yakala chinhu chimwe na lupango lwenyewo. ");
INSERT INTO cwe_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kachihaka zahabu yelile, ubanzi wake wa kuchanyha na banzi zake na mahembe yake, iviya katenda lukingo lwa zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Kaitendela mhete mbili za zahabu hasi ya ulukingo hana zibanzi mbili zoziihindukile. Mhete izo zamhilila mibiki ya kupapila. ");
INSERT INTO cwe_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Katenda mibiki midi ya mkenge na kaihaka zahabu. ");
INSERT INTO cwe_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Iviya katenda mavuta yelile na ubani wili na mnung'ho unogile fana mwenzi wa mavuta yonung'hila goya. ");
INSERT INTO cwe_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Kazenga lupango lwa kutimbulila nhambiko kwa mibiki ya mkenge. Utali na ugalamu wa lupango ulo viilinga, mita mbili na lobo kwa mita imwe na lobo, na utali wake mita mbili na lobo. ");
INSERT INTO cwe_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Katenda mahembe mane, chila ubanzi hembe dimwe. Mahembe yayo yawa chinhu chimwe na ulupango, kahaka shaba lupango lose. ");
INSERT INTO cwe_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Katenda via vake, vizae va kuzolela maivu na vizae va kuhalila moto na mibano na magembe na vizae vake. Vinhu vose vihakigwa shaba. ");
INSERT INTO cwe_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Kachitendela ulupango lwavu lwa shaba, kalwika hasi ya lukingilo lwa ulupango mbaka hagati ya ulupango. ");
INSERT INTO cwe_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Katenda mhete nne za shaba za kupapila ulupango, kaziguma chila chingobweda mhete imwe. ");
INSERT INTO cwe_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Katenda mibiki ya mkenge na kuihaka shaba ");
INSERT INTO cwe_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","na kaiguma mibiki ija muna zimhete ziya zikalile mumgwazo wa ulupango muladi kulupapa. Lupango ulo lukala na uvungu. ");
INSERT INTO cwe_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Maabaho kaumba ziga kwa shaba na kalilo jake da shaba, ziga ijo ditendigwa kwa vilole va shaba va wanaake wasang'hanile hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Maabaho katengeneza luwa. Mapanzia ya ubanzi wa kusi wa uluwa yakala ya chitani ibotigwe vinogile na yeli na utali wa mita malongo mane na nne. ");
INSERT INTO cwe_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Yamhililigwa na mhanda malongo maidi za shaba zili na vikalilo malongo maidi va shaba. Mbali ngwamo za mhanda izo na vihindo vake vikala va hela. ");
INSERT INTO cwe_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ubanzi wa kasikazi utali wa panzia ukala mita malongo mane na nne na mhanda zake malongo maidi za shaba, mbali ngwamo za mhanda izo na vihindo vake vikala va hela. ");
INSERT INTO cwe_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ubanzi wa uswelo wa zuwa ukala na panzia dili na utali wa mita malongo maidi na mbili, mhanda zake longo na vikalilo vake longo, ngwamo za mhanda izo na vihindo vake vikala va hela. ");
INSERT INTO cwe_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ubanzi wa ulawilo wa zuwa, hakalile na ulwivi, ubanzi uwo ukala na ugalamu wa mita malongo maidi na mbili. ");
INSERT INTO cwe_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Panzia da ubanzi umwe wa lwivi dikala na ugalamu wa mita sita na nusu, mhanda nhatu na vikalilo vake vitatu, ");
INSERT INTO cwe_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","iviya ubanzi umwenga ukala na panzia dili na ugalamu wa mita sita na nusu, hamwe na mhanda nhatu na vikalilo vake. ");
INSERT INTO cwe_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mapanzia yose kuluzunguluka uluwa yakala ya walo dinogile dibotigwe. ");
INSERT INTO cwe_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Vikalilo vose va mhanda vikala va shaba, mbali ngwamo za mhanda izo na vihindo vake vikala va hela. Iviya hanhu ha uchanyha ha mhanda hakala ha hela na mhanda zake zose zizakwamhigwa na vinhu va hela. ");
INSERT INTO cwe_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Panzia da lwivi lwa luwa ditendigwa kwa luzi lwa langi ya buluu na zambalau na ndung'hu na walo dinogile dibotigwe na kuhambigwa vinogile, najo dikala na utali wa mita kenda na chimo mita mbili. Dilinga fana mapanzia ya uluwa. ");
INSERT INTO cwe_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Iviya mhanda zake zikala nne na vikalilo vine va shaba. Ngwamo zake zikala za hela, hanhu ha uchanyha ha mhanda na mango zake vizakwamhigwa na vinhu va hela. ");
INSERT INTO cwe_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Vigingi vose va hema na va luwa mumgwazo wa dihema vikala va shaba. ");
INSERT INTO cwe_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ino iyo peta ya via visang'haniligwe kwika hema da kwika goya vibawo va ukalangama. Peta ino isasaligwa na Walawi kwa ndagilizi ya Musa, muna ulongozi wa Isamali mwana wa mkulu wa nhambiko Haluni. ");
INSERT INTO cwe_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleli mwana wa Uli, mzukulu wa Huli, wa kabila da Yuda, watenda chila chinhu Mndewa Mulungu choyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Katazigwa na Oholiabu mwana wa Ahisamaki wa kabila da Dani, yoyakalile galu wa kuhamba, kuchola na kuhamba kwa nyuzi za langi ya buluu na zambalau na ndung'hu na walo dinogile dibotigwe. ");
INSERT INTO cwe_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Zahabu yose yowamulavile Mndewa Mulungu kwa kwinula uchanyha kwa ichimu cha kuzengela hema da Mulungu, ikala ya chilo magana manane na malongo saba na saba na gilamu magana matatu, ningo fana viili kwa sang'hano za hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Hela yowailavile wanhu wa makabila ikala chilo elufu tatu na longo na saba na gilamu magana saba na malongo matano. ");
INSERT INTO cwe_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Chila munhu yoyapetigwe kwandusila miyaka malongo maidi na kugendelela, kalava mchango wake wa nusu shekeli ya hela, na walume wose wowapetigwe wakala laki sita elufu tatu na magana matano malongo matano. ");
INSERT INTO cwe_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Chilo elufu nhatu za hela zisang'haniligwa kutendela vikalilo viya gana va hema da Mulungu na diya dipanzia, chilo malongo matatu kwa chila chikalilo. ");
INSERT INTO cwe_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ziya chilo longo na saba na gilamu malongo saba na tano zozisigale, zisang'haniligwa kutengenezela ngwamo za mhanda na kuhaka hanhu ha uchanyha ha mhanda na kuitendela lukingilo. ");
INSERT INTO cwe_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Shaba ziya Waisilaili zowamulavile Mndewa Mulungu kwa kwinula uchanyha zikala shekeli 212,400 ya hela. ");
INSERT INTO cwe_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Bezaleli kasang'hanila shaba iyo kutendela vikalilo va hanhu ha kwingilila muna dihema da Mulungu, lupango lwa shaba hamwe na lwavu lwa shaba na via vose va lupango. ");
INSERT INTO cwe_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Vikalilo va luwa luzunguluke hema da Mulungu na va ulwivi lwa luwa na vigingi vose va hema da Mulungu na va luwa. ");
INSERT INTO cwe_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kwa nyuzi za langi ya buluu na zambalau na ndung'hu, wabota mawalo ya kuvala lusita lwa kulava nhambiko hanhu helile. Wamsonela Haluni mawalo yelile fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Watenda chizibawo kwa nyuzi za zahabu na nyuzi za langi ya buluu na zambalau na ndung'hu na walo dinogile dibotigwe. ");
INSERT INTO cwe_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Wahonda zahabu iyo mbaka iwa sisili ng'hani na kukanha nyuzi, muladi kuzibota hamwe na nyuzi za langi ya buluu na za zambalau na ndung'hu na walo dinogile dibotigwe vinogile. ");
INSERT INTO cwe_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Chizibawo icho chitendigwa kwa nzabi muna yamayega zozisonigwe kuna imihelelo yake midi. ");
INSERT INTO cwe_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mkwiji ubotigwa goya mchanyha yake muladi kuifunga, ukala chinhu chimwe na chizibawo icho. Utendigwa kwa vinhu ivo ivo, nyuzi za zahabu na nyuzi za buluu na ya zambalau na ndung'hu na walo dinogile dibotigwe, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Wasasala mabwe ya salidoniki na kuyahamba na kuyengiza muna ivihindo va zahabu, yacholigwa fana munhu voyochola muhuli, mazina longo na maidi ya wana wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Wayeka mabwe yayo muna ivihande va muna yamayega va chizibawo chiya muladi kulagusa makabila longo na maidi ya Isilaili, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Katenda chifuko cha muimhambaga fana viya viyatendile ichizibawo chiya, kwa nyuzi za zahabu na nyuzi za langi ya buluu na ya zambalau na ndung'hu na kwa walo dinogile dibotigwe. ");
INSERT INTO cwe_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Utali wa chifuko icho na ugalamu wake vikala voilinga, utali sentimita malongo maidi na mbili, ugalamu sentimita malongo maidi na mbili, nacho chikunjigwa. ");
INSERT INTO cwe_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Chihambigwa kwa misitali mine ya mabwe ya bei ng'hulu. Msitali wa mwanduso ukala wa hakiki na topazi na alimasi ndung'hu. ");
INSERT INTO cwe_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Msitali wekaidi ukala wa zumalidi na johali ya langi ya buluu na alimasi. ");
INSERT INTO cwe_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Msitali wekatatu ukala wa yasito na agate na amesisito. ");
INSERT INTO cwe_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Msitali wekane ukala wa zabalajadi na shohamu na yasipi, yose yagumigwa muna ivihindo va zahabu ");
INSERT INTO cwe_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Hakala na mabwe longo na maidi yoyacholigwe mazina longo na maidi ya wana wa Isilaili. Yakala yacholigwa fana viwochola muhuli, chila dibwe dicholigwa zina kulagusa makabila longo na maidi. ");
INSERT INTO cwe_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kwa ichimu cha chifuko icho cha mwiimhambaga, katengeneza mikufu ya zahabu yelile ibotigwe fana luzabi. ");
INSERT INTO cwe_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Iviya kachitengenezela ichifuko cha muimhambaga vihindo va zahabu na mhete mbili za zahabu na kuziguma muna zimhembe mbili za chifuko icho. ");
INSERT INTO cwe_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Mikufu iyo midi ya zahabu waifunga muna zimhete izo za zimhembe za chifuko cha muimhambaga. ");
INSERT INTO cwe_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Zimhembe ziya mbili za mikufu ya zahabu waziguma muna ivihindo viya vidi na wazilumbiliza na ivihande viya vidi va muna yamayega ya chizibawo, ubanzi wa kuulongozi. ");
INSERT INTO cwe_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Watenda mhete mbili za zahabu na waziguma kuna zimhembe mbili za hasi ubanzi wa mgati wa chifuko cha muimhambaga habehi na chizibawo. ");
INSERT INTO cwe_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Watenda mhete zimwenga mbili za zahabu na kuziguma kuulongozi hana zimhembe za hasi za vihande va chizibawo, hanhu hochiilumba na mkwiji uja ubotigwe vinogile. ");
INSERT INTO cwe_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Wafunga chifuko cha muimhambaga hana ichizibawo kwa kulumbiliza mhete zake na chizibawo kwa luzabi lwa buluu, muladi chifuko icho sekechihagaye ila chikalile mkwiji uja lubotigwe vinogile, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Katenda joho da kuvala mgati ya chizibawo cha nyuzi za langi ya buluu. ");
INSERT INTO cwe_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Joho ijo dikala na nyafasi ya kufosezela ditwi hagati, najo dizungulusiligwa lukingilo lubotigwe muladi sekeidegeke. ");
INSERT INTO cwe_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Kuna imhindo ya hasi ya dijoho wabota mahambo ya makomamanga ya nyuzi za langi ya buluu na za zambalau na ndung'hu na walo dinogile dibotigwe vinogile. ");
INSERT INTO cwe_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Maabaho watenda mbugi za zahabu yelile, chila dihafosa komamanga dimwe weka mbugi hana imhindo ya dijoho. ");
INSERT INTO cwe_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ivo mbugi na komamanga, mbugi na komamanga, viyandakana kuizunguluka imhindo ya joho ijo, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Wawatendela Haluni na wanage majoho ya chitani inogile. ");
INSERT INTO cwe_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Chilemba cha chitani inogile na kofiya da chitani inogile na kaputula za chitani ibotigwe vinogile, ");
INSERT INTO cwe_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","na mikwiji ya walo dinogile dibotigwe kwa nyuzi za langi ya buluu na ya zambalau na ndung'hu na kuihamba vinogile, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Watenda chihande cha zahabu yelile kwa ichimu cha chilemba chelile kwa zahabu yelile na kuchola uchanyha yake fana viwacholile muhuli, “Yelile kwa Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Maabaho wachifunga kwa luzabi lwa langi ya buluu haulongozi wa ichilemba chiya, fana Mndewa Mulungu viyamulongele Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ivo sang'hano yose ya hema da Mulungu ikomelezeka. Waisilaili watenda chila chinhu fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Maabaho wadigala dihema da Mulungu kwa Musa, hamwe na via vake vose, vihindo vake na mibiki yake na mapalo yake na mhanda zake na vikalilo vake, ");
INSERT INTO cwe_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","na ngubiko ya mbende za ng'hondolo lume yoihakigwe langi ndung'hu na ngubiko ya mbende za wanyama wamwenga na panzia da hanhu helile, ");
INSERT INTO cwe_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","na sanduku da lagano na mibiki yake na ngubiko ya kuilumba, ");
INSERT INTO cwe_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","na meza na via vake vose na magate yelile yekigwe haulongozi ha Mulungu, ");
INSERT INTO cwe_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","na chinala cha chitasa cha zahabu na vitasa vake, via vake vose na mavuta ya vitasa ivo, ");
INSERT INTO cwe_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","na lupango lwa zahabu, mavuta yelile na ubani uli na mnung'ho unogile na panzia da hanhu ha kwingilila muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","na lupango lwa shaba na lwavu lwake lwa shaba, mibiki yake na via vake vose na ziga na kalilo jake, ");
INSERT INTO cwe_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","na mapanzia ya luwa, mhanda zake na vikalilo vake na panzia da lwivi lwa luwa na nzabi zake na vigingi vake na via vose vovilondeke kuna isang'hano ya hema da Mulungu, iviya dotangigwa hema da Mulungu ");
INSERT INTO cwe_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","na mawalo yabotigwe vinogile kwa ichimu cha sang'hano ya hanhu helile, yaani mawalo yelile ya mkulu wa nhambiko Haluni na ya wanage kwa ichimu cha sang'hano ya ukulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Waisilaili wasang'hana sang'hano zose fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa kalola chila chinhu, kawona Waisilaili wasang'hana chila chinhu fana Mndewa Mulungu viyalagilize. Ivo Musa kawatemela mate. ");
INSERT INTO cwe_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Maabaho Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Muna isiku ya mwanduso ya mwezi wa mwanduso, kwizasimika hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Mgati ya hema ijo kwizakwika diya disanduku da lagano, maabaho ika panzia haulongozi hake. ");
INSERT INTO cwe_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Digale hana imeza na kwika via vake uchanyha. Maabaho chigale chinala cha chitasa na kwika vitasa vake uchanyha. ");
INSERT INTO cwe_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Maabaho kwizakwika lupango lwa zahabu cha kusomela ubani haulongozi wa sanduku da lagano, maabaho kwizatumbika panzia hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kwizakwika lupango lwa kutimbulila nhambiko haulongozi wa hanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kwizakwika ziga hagati ya hema da Mulungu na lupango, kwizaguma mazi mgati ya ziga ijo. ");
INSERT INTO cwe_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Maabaho kwizazenga luwa na kutumbika panzia hana ulwivi lwake. ");
INSERT INTO cwe_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Maabaho kwizasola mavuta yelile na kudihaka hema da Mulungu hamwe na vinhu vake vose na kudibagula na vinhu vake vose, najo dizakuwa jela. ");
INSERT INTO cwe_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Maabaho kwizabagula ulupango lwa kutimbulila nhambiko na via vake vose kwa kuchihaka mavuta yelile, nacho chizakuwa chela ng'hani. ");
INSERT INTO cwe_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Maabaho kwizadibagula diziga na kalilo jake na kuvihaka mavuta fana ivo ivo. ");
INSERT INTO cwe_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Mgale Haluni na wanage hana ihanhu ha kwingilila muna dihema da Mulungu, maabaho uwanave. ");
INSERT INTO cwe_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Maabaho mvaze Haluni mawalo yelile, muhake mavuta yelile na kumbagula muladi yadahe kunisang'hanila fana mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Kwizawasola wanage na kuwavaza ng'hanzu. ");
INSERT INTO cwe_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Maabaho uwahake mavuta yelile fana viya viumuhakile tati yawo, muladi wadahe kunisang'hanila fana wakulu wa nhambiko. Kuhakigwa kwawo mavuta yelile kwizawengiza muna ukulu wa nhambiko siku zose muna zinyelesi zawo zose.” ");
INSERT INTO cwe_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa katenda chila chinhu fana viya Mndewa Mulungu viyamulagilize. ");
INSERT INTO cwe_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Mwezi wa mwanduso muna mwaka wekaidi, siku ya mwanduso ya mwezi, hema da Mulungu disimikigwa. ");
INSERT INTO cwe_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa viyasimike hema da Mulungu, keka vikalilo vake na kwinula mibiki yake, kalumbiliza mapalo yake na kusimika mhanda zake. ");
INSERT INTO cwe_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Kanzanza panzia uchanyha ya hema da Mulungu na keka ngubiko ya hema uchanyha yake, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Maabaho kasola vibawo viya vidi na kuvika hana disanduku diya da ukalangama. Kaifoseza imibiki ija hana zimhete za sanduku na keka ngubiko ya kuilumba uchanyha yake. ");
INSERT INTO cwe_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Maabaho kadika disanduku da lagano muna dihema da Mulungu na kutumbika panzia, kwa kutenda ivo kadifisa disanduku da lagano fana Mndewa Mulungu viyamulongele Musa. ");
INSERT INTO cwe_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musa keka meza mgati ya hema da Mulungu, ubanzi wa kasikazi, kunze ya panzia, ");
INSERT INTO cwe_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","na uchanyha yake kapanga magate haulongozi wa Mndewa Mulungu fana viyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Keka chinala cha chitasa muna dihema da Mulungu, ubanzi wa kusi, viilola na imeza. ");
INSERT INTO cwe_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Kemiza vitasa vake haulongozi wa Mndewa Mulungu, fana Mndewa Mulungu viyamulagilize. ");
INSERT INTO cwe_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Keka lupango lwa zahabu muna dihema da Mulungu kuulongozi wa panzia, ");
INSERT INTO cwe_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na kasoma ubani uli na mnung'ho unogile uchanyha yake, fana viyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Katumbika panzia hana ihanhu ha kwingilila muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Musa keka lupango lwa kutimbulila nhambiko hana ihanhu ha kwingilila muna dihema da Mulungu. Uchanyha yake kalava nhambiko ya kutimbula na nhosa ya usage, fana viyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Kadika diziga hagati ya dihema da Mulungu na lupango na kuguma mazi ya kunawa. ");
INSERT INTO cwe_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa na Haluni na wana wa Haluni, wose wanawa makono yawo na migulu yawo umo. ");
INSERT INTO cwe_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Viwengile mgati ya hema da Mulungu hebu viwakwenhukile ulupango, wanawa fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Musa kemiza luwa kuzunguluka hema da Mulungu na lupango, na keka panzia hana ulwivi lwa luwa. Ivo Musa kakomeleza sang'hano yose. ");
INSERT INTO cwe_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Maabaho wingu digubika hema da Mulungu, dihema dimema utunhizo wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa kapotwa kwingila muna dihema da Mulungu kwaviya wingu dikala uchanyha yake, na utunhizo wa Mndewa Mulungu umema umo. ");
INSERT INTO cwe_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Muna imiyanza yose ya Waisilaili, wingu vidinuligwe kulawa uchanyha ya hema, Waisilaili wandusa mwanza. ");
INSERT INTO cwe_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mbali one diwingu hadinuligwe, wawo hawanduse mwanza, wagozela mbaka vondadinuligwe. ");
INSERT INTO cwe_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Wingu da Mndewa Mulungu dikala uchanyha ya hema da Mulungu lusita lwa imisi, umoto waka muna dihema da Mulungu lusita lwa ichilo, haulongozi wa kaye zose za Waisilaili lusita lose lwa miyanza yawo.");
INSERT INTO cwe_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Mndewa Mulungu kamtanga Musa muna dihema da Mulungu, kamulongela, ");
INSERT INTO cwe_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Walongele Waisilaili, ‘One munhu yahalonda kumulavila Mndewa Mulungu nhambiko ya mnyama, yasagule kulawa muna dibumbila da ng'ombe hebu ng'hondolo hebu luti. ");
INSERT INTO cwe_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘One nhambiko iyo iyolava munhu ni ya kutimbula, kezasagula ng'ombe mulume yelibule chilema, kezamulavila Mndewa Mulungu haulongozi ha ihanhu ha kwingilila muna dihema da Mulungu muladi yapate kutogoligwa na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Munhu kezakwika mkono wake mchanyha ya ditwi da ng'ombe wa nhambiko ya kutimbula, nayo izatogoleka kuwa ya kuilumba. ");
INSERT INTO cwe_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Maabaho kezamchinja ng'ombe iyo haulongozi ha Mndewa Mulungu. Welesi wa Haluni weli wakulu wa nhambiko, wezaisola damu na kuimizila banzi zose za ulupango hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Munhu iyo yagalile mnyama wa nhambiko ya kutimbula, kezamchuna na kumsangula. ");
INSERT INTO cwe_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Welesi wa Haluni weli wakulu wa nhambiko, wezaduganya ngodi mchanyha ya lupango na kubwinha moto. ");
INSERT INTO cwe_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Maabaho welesi wa Haluni weli wakulu wa nhambiko, wezasola vihande viya va ng'ombe na ditwi na mabambala ya mavuta, na kwika mchanyha ya ngodi ziwaduganye hana ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Mbali utumbo na migong'ho ya ng'ombe iyo munhu yagalile kezavisunha na mazi. Mkulu wa nhambiko kezaitimbula nhambiko yose mchanyha ya lupango. Iyo ni nhambiko ya kutimbula kwa moto ili na mnung'ho unogile woumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘One munhu yahalava nhambiko yake ya kutimbula ya ng'hondolo hebu luti kulawa muna dibumbila jake, kolondeka yalave bebelu dilibule chilema. ");
INSERT INTO cwe_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kolondeka yamchinjile ubanzi wa kasikazi wa lupango haulongozi ha Mndewa Mulungu, welesi wa Haluni weli wakulu wa nhambiko, wezaitila idamu banzi zose za lupango. ");
INSERT INTO cwe_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Maabaho munhu yagalile kezamkanha vihande, kovigola ditwi hamwe na mabambala ya mavuta yake, mkulu wa nhambiko kezavika hana zingodi zikwaka mchanyha ya lupango. ");
INSERT INTO cwe_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Mbali kezasunha na mazi utumbo na migong'ho. Mkulu wa nhambiko iyo kezavikwesa vose na kuvitimbula mchanyha ya lupango, iyo ni nhambiko ya kutimbula kwa moto ili na mnung'ho unogile woumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘One munhu yahamulavila Mndewa Mulungu nhambiko ya kutimbula ya ndege, kolondeka yalave huwa hebu nziwa. ");
INSERT INTO cwe_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Mkulu wa nhambiko kezamgala ndege iyo kuna ulupango, kezabobotola ditwi da ndege iyo na kuditimbula mchanyha ya lupango. Damu ya ndege iyo izakamigwa na kumiziligwa kulubavu lwa ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Tupe jake hamwe na michipilo yake kezavisegeza na kuvasa ubanzi wa ulawilo wa zuwa wa ulupango hoyokwikigwa maivu. ");
INSERT INTO cwe_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kezamwamha yamabawa na kumbalula, mbali sekeyamkanhe vihande vidi. Maabaho mkulu wa nhambiko kezamtimbula hana ulupango, mchanyha ya zingodi. Iyo ni nhambiko ya kutimbula kwa moto ili na mnung'ho unogile woumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Munhu yoyose yahagala nhosa ya mhule kwa Mndewa Mulungu, kolondeka yalave usage unogile. Kezauguma mavuta na ubani, ");
INSERT INTO cwe_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","maabaho kezawagalila welesi wa Haluni weli wakulu wa nhambiko. Kezasola ganza dimwe da usage uwo uli na mavuta na ubani wose muladi yautimbule mchanyha ya lupango uwe nhosa ya kumkumbuka Mndewa Mulungu. Iyo ni nhambiko ya kutimbula ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Nhosa yondaisigale ni ya Haluni na wanage wa chilume. Iyo ni hanhu ha nhosa yelile ng'hani iyolaviligwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘One munhu yahamgalila Mndewa Mulungu nhosa ya mhule yokigwe, iyo izakuwa ya magate hayagumigwe lusu ya usage unogile wouhanganyigwe na mavuta ya zaituni hebu magate masisili hayagumigwe lusu yoihakigwe mavuta. ");
INSERT INTO cwe_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","One nhosa yako ihawa ya gate dikanzingigwe, iyo izakuwa ya usage unogile haugumigwe lusu uhanganyigwe na mavuta ya zaituni. ");
INSERT INTO cwe_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Magate yayo yezamogoligwa vihande vihande na kugidiligwa mavuta. Iyo ni nhosa ya mhule. ");
INSERT INTO cwe_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","One nhosa youilava ni ya magate yambikigwe muna inongo, iyo izakuwa ya usage unogile ugumigwe mavuta. ");
INSERT INTO cwe_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kwizamulavila Mndewa Mulungu nhosa ya mhule yoitendigwa kwa vinhu ivo, kwizaigala kwa mkulu wa nhambiko, nayo kezaigala kuna ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Mkulu wa nhambiko kezasola hanhu ha nhosa iyo iwe ya kukumbukigwa na kuitimbula mchanyha ya lupango. Uwo ni mnung'ho unogile woumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Nhosa ya mhule yondaisigale izakuwa ya Haluni na wanage wa chilume, iyo ni nhosa yelile ng'hani iyolaviligwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Nhosa yoyose ya mhule yondaumulavile Mndewa Mulungu yolondeka sekeigumigwe lusu, kwaviya hailondeka kuguma lusu hebu uki muna inhosa iyolaviligwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Kodaha kumgalila nhosa Mndewa Mulungu vinhu vako viwanduse kugobola. Mbali havizalavigwa muna ulupango fana mnung'ho wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Nhosa zako zose za mhule kwizaziguma munyu. Sekeuleke kuguma munyu muna inhosa yako ya mhule, kwaviya munyu ni chilaguso cha lagano diyatendile Mulungu hamwe na mweye. ");
INSERT INTO cwe_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Uhamulavila Mndewa Mulungu nhosa ya vinhu vako viwanduse kugobola, kwizailava nhosa iyo ya sambi yoidundigwe na kwambikigwa muna umoto. ");
INSERT INTO cwe_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kwizaiguma mavuta ya mzaituni na ubani. Iyo ni nhosa ya mhule. ");
INSERT INTO cwe_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Mkulu wa nhambiko kezatimbula hanhu ha nhosa iyo ya mhule yoihondigwe na mavuta hamwe na ubani wake wose, iwe nhosa ya kukumbukigwa, iyo ni nhosa iyolaviligwa Mndewa Mulungu kwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘One munhu yoyose yahalava ng'ombe wake fana nhambiko ya tindiwalo haulongozi ha Mndewa Mulungu, yalave ng'ombe lume hebu zike. Mnyama iyo sekeyawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Munhu kezakwika mkono wake mchanyha ya ditwi da ng'ombe iyo na kumchinja hana ihanhu ha kwingilila muna dihema da Mulungu. Welesi wa Haluni weli wakulu wa nhambiko, wezakwitilila damu ya ng'ombe iyo banzi zose za ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Mabambala yose yogubika utumbo wa ng'ombe iyo wa nhambiko ya tindiwalo kezavitimbula fana nhambiko iyolaviligwa Mndewa Mulungu kwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Iviya kezalava figo mbili na mabambala yake hamwe na hanhu hanogile ha ini. ");
INSERT INTO cwe_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Welesi wa Haluni weli wakulu wa nhambiko, wezaitimbula nhambiko iyo hana ulupango uchanyha ya nhambiko ya kutimbula ili uchanyha ya zingodi. Iyo ni nhambiko kwa moto ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘One nhambiko iyo ya tindiwalo iyomulavila Mndewa Mulungu yolawa muna dibumbila jake da ng'hondolo hebu luti, basi disaguligwe lume hebu zike dilibule chilema. ");
INSERT INTO cwe_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","One munhu yahalava mwanang'hondolo kuwa nhambiko yake, kolondeka yamulave haulongozi ha Mndewa Mulungu, ");
INSERT INTO cwe_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","kezakwika mkono wake mchanyha ya ditwi da mnyama iyo na kumchinja haulongozi wa hema da Mulungu. Wakulu wa nhambiko wezakwitilila damu muna ulupango banzi zose. ");
INSERT INTO cwe_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Maabaho kulawa muna inhambiko iyo ya tindiwalo iyolaviligwa Mndewa Mulungu kwa moto, kezamulavila mabambala yake na mkila wose uli na mabambala yakanhigwe habehi ng'hani na umgongosango hamwe na mabambala yogubika utumbo, ");
INSERT INTO cwe_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","figo mbili na mabambala yake ya mavuta hamwe na hanhu hanogile ha ini. ");
INSERT INTO cwe_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Mkulu wa nhambiko kezavitimbula ivo vose mchanyha ya lupango fana ndiya iyolaviligwa Mndewa Mulungu kwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘One munhu yahawa na nhambiko ya luti, kezamulava haulongozi ha Mndewa Mulungu, ");
INSERT INTO cwe_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","kezakwika mkono wake mchanyha ya ditwi da mnyama iyo na kumchinja haulongozi wa hema da Mulungu. Maabaho welesi wa Haluni wezakwitilila damu ulupango banzi zose. ");
INSERT INTO cwe_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Maabaho kezamulavila Mndewa Mulungu kwa moto mabambala yose yogubika utumbo, ");
INSERT INTO cwe_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","figo zose mbili na mabambala yake hamwe na hanhu hanogile ha ini. ");
INSERT INTO cwe_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Wakulu wa nhambiko wezavitimbula vinhu ivo hana ulupango fana ndiya, nhosa yoilavigwa kwa moto kulava mnung'ho unogile wa kumnogeza Mndewa Mulungu. Mabambala yose ya mavuta ni ya Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Mbuli ino izakuwa lagilizo da siku zose, muna zinyelesi zenu zose na hanhu hohose homukala. Sekemuje mavuta hebu damu.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Walongele Waisilaili, ‘One munhu yahatenda uhasanyi bila kwiilunga na katenda chinhu chilemigwe na lagilizo da Mndewa Mulungu, yalave nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘One mkulu wa nhambiko digogogo yoyahakigwe mavuta iyo yotenda uhasanyi na kuwatenda wanhu wawe na ubananzi, iyo kezamulavila Mndewa Mulungu dang'ang'a lume da ng'ombe dilibule chilema diwe nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Nayo kezadigala dang'ang'a ijo na kudika hanhu ha kwingilila muna dihema da Mulungu haulongozi ha Mndewa Mulungu. Kezakwika mkono wake mchanyha ya ditwi da dang'ang'a ijo da ng'ombe wa kudichinja haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Maabaho mkulu wa nhambiko digogogo iyo yoyahakigwe mavuta kezasola damu imwenga ya dang'ang'a ijo da ng'ombe na kuigala mgati ya hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kezavabika chidole chake muna idamu iyo na kuimiza haulongozi ha Mndewa Mulungu miyanza saba, haulongozi ha panzia da hanhu helile. ");
INSERT INTO cwe_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Maabaho mkulu wa nhambiko digogogo iyo kezakwika damu iyo mchanyha ya mahembe ya ulupango lwa kufukizila ubani unogile haulongozi ha Mndewa Mulungu uli mgati ya dihema da Mulungu. Damu yose ya dang'ang'a ijo yondaisigale kezaitila hasi ya chikalilo cha ulupango lwa kulavila nhambiko ya kutimbula ili hana ihanhu ha kwingilila muna dilhema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Na kezayasegeza mabambala yose ya mavuta ya dang'ang'a ijo da ng'ombe wa nhambiko ya uhasanyi, mabambala yose ya mavuta yogubika utumbo, ");
INSERT INTO cwe_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","na figo zose mbili hamwe na mabambala ya mavuta yeli uchanyha yake habehi na chigudi, na hanhu hanogile ha ini, ");
INSERT INTO cwe_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","fana viya mabambala ya mavuta yosegezigwa kulawa muna ing'ombe wa nhambiko ya tindiwalo. Mkulu wa nhambiko digogogo kezazisola na kuzitimbula mchanyha ya lupango lwa kutimbulila nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mbali mbende ya ng'ombe iyo na nyama na ditwi na migong'ho na utumbo na mavi yake, ");
INSERT INTO cwe_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","yani ng'ombe wose yasigale kezalavigwa kunze ya lago hana ihanhu helile hohasaguligwe kwasila maivu. Mkulu wa nhambiko digogogo kezamtimbula kwa moto uchanyha ya ngodi hanhu baho ha kwitilila maivu. ");
INSERT INTO cwe_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘One Waisilaili wose wahatenda uhasanyi bila kuilunga kwa kutenda chinhu chochilemigwe na malagilizo ya Mndewa Mulungu, wabananga, ");
INSERT INTO cwe_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","uhasanyi uwo vondaumanyike, wanhu wose wezalava dang'ang'a da ng'ombe lume diwe nhambiko ya uhasanyi. Wezadigala haulongozi ha dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Walala wa wanhu wezakwika makono yawo mchanyha ya ditwi da dang'ang'a da ijo, maabaho dizachinjigwa haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Mkulu wa nhambiko digogogo yoyahakigwe mavuta kezagala damu imwenga ya didang'ang'a muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Kezavabika chidole chake muna idamu na kuimizila haulongozi ha panzia miyanza saba, haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Maabaho damu imwenga kezaika muna yamahembe ya lupango lwili muna dihema da Mulungu haulongozi ha Mndewa Mulungu. Damu isigalile kezaitila hasi hana ichikalilo cha ulupango lwa kutimbulila nhambiko habehi na hanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Kezasegeza mabambala yose ya mavuta ya ng'ombe iyo na kuyatimbula hana ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ivo kezamtenda ng'ombe iyo fana viyamtendile ng'ombe ija wa nhambiko ya uhasanyi. Mkulu wa nhambiko digogogo iyo kezawatenda wanhu kuilumba, nawo wezalekelelwa. ");
INSERT INTO cwe_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Maabaho kezamsola ng'ombe iyo na kumulava kunze ya lago na kumtimbula kwa moto fana viya viyamtendile ng'ombe ija wa mwanduso. Iyo ni nhambiko ya uhasanyi wa wanhu. ");
INSERT INTO cwe_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘One mulangulizi yahatenda uhasanyi bila kuilunga kwa kutenda chinhu chochilemigwe na malagilizo ya Mndewa Mulungu, kabananga. ");
INSERT INTO cwe_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Vondayaumanye uhasanyi uyatendile, kolondeka yagale nhambiko yake ya bebelu da luti dilibule chilema. ");
INSERT INTO cwe_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Kezakwika mkono wake mchanyha ya ditwi da bebelu na kudichinja hanhu ha kuchinjila nhambiko ya kutimbula, haulongozi ha Mndewa Mulungu. Iyo ni nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Mkulu wa nhambiko digogogo kezavabika chidole chake muna idamu ya nhambiko ya uhasanyi na kuyahaka yamahembe ya lupango lwa kutimbulila nhambiko. Damu isigale kezaitila hasi hana ichikalilo cha lupango ulo. ");
INSERT INTO cwe_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Maabaho kezatimbula mabambala yose ya mavuta hana ulupango fana viya viyatimbule nhambiko ya tindiwalo. Ivo mkulu wa nhambiko kezamtendela mulangulizi iyo kuilumba kwa ichimu cha uhasanyi uyatendile, nayo kezalekelelwa. ");
INSERT INTO cwe_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Munhu yoyose yahatenda uhasanyi bila kuilunga kwa kutenda chinhu chochilemigwe na malagilizo ya Mndewa Mulungu, kabananga. ");
INSERT INTO cwe_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Vondayaumanye uhasanyi uyatendile, kolondeka yagale nhambiko ya zike da luti dilibule chilema kwa ichimu cha uhasanyi uyatendile. ");
INSERT INTO cwe_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Kezakwika mkono wake mchanyha ya ditwi da luti iyo wa nhambiko ya uhasanyi na kumchinja hanhu ha kutimbulila nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Mkulu wa nhambiko kezavabika chidole chake muna idamu na kuyahaka yamahembe ya lupango lwa kutimbulila nhambiko. Damu isigale kezaitila hasi hana ichikalilo cha lupango. ");
INSERT INTO cwe_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Kezasegeza mabambala yose ya mavuta ya luti iyo fana viya viyosegeza mabambala ya mavuta ya wanyama wa nhambiko za tindiwalo. Maabaho kezayatimbula hana ulupango, mnung'ho wake unogile wizamnogeza Mndewa Mulungu. Ivo mkulu wa nhambiko kezamtendela kuilumba, nayo kezalekelelwa. ");
INSERT INTO cwe_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘One munhu iyo yahagala mwanang'hondolo kuwa nhambiko ya uhasanyi, mwanang'hondolo iyo kolondeka yawe zike dilibule chilema. ");
INSERT INTO cwe_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Kezakwika mkono wake muna iditwi da mwanang'hondolo iyo wa nhambiko ya uhasanyi na kumchinja hanhu howochinjila wanyama wa nhambiko ya kutimbula. ");
INSERT INTO cwe_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Maabaho mkulu wa nhambiko kezavabika chidole chake muna idamu ya nhambiko ya uhasanyi na kuyahaka yamahembe ya lupango lwa kutimbulila nhambiko. Damu isigale kezaitila hasi ya chikalilo cha ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Maabaho kezasegeza mabambala ya mavuta fana viyosegeza mabambala ya mavuta ya mwanang'hondolo wa nhambiko ya tindiwalo. Mkulu wa nhambiko kezayatimbula mchanyha ya lupango hamwe na nhambiko zozilavigwa kwa Mndewa Mulungu kwa moto. Ivo mkulu wa nhambiko kezamtendela kuilumba kwa ichimu cha uhasanyi wake, nayo kezalekelelwa. ");
INSERT INTO cwe_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘One munhu yoyose yahatenda uhasanyi kwa kulema kulava usindila kuna ichitala kwa mbuli iyawone hebu kuhulika, kezatagusigwa kwa uhasanyi wake. ");
INSERT INTO cwe_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","One munhu yoyose vimwili kambula mwiko bila kuilunga kwa kudalisa chinhu chochose chambule mwiko, iwe mtufi wa mnyama wa kumbago hebu mnyama wa kufugigwa hebu mng'onyo, kezakuwa kambula mwiko na kabananga. ");
INSERT INTO cwe_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","One munhu yahamdalisa munhu yambule mwiko, hebu chinhu chochimtenda munhu yambule mwiko bila kuvimanya, basi vondayavimanye kezakuwa kabananga. ");
INSERT INTO cwe_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","One munhu yoyose yahailaha kutenda chinhu chochose bila kugesa, chinogile hebu chihile fana munhu havimanyile, vondayavimanye kezakuwa kabananga. ");
INSERT INTO cwe_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","One munhu yoyose yahabananga kwa mbuli yoyose muna zimbuli izo, kolondeka yalonge kwa mulomo wake ubananzi wake uyatendile, ");
INSERT INTO cwe_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","na kumgalila Mndewa Mulungu nhambiko ya uhasanyi kwa ichimu cha uhasanyi uyatendile. Kezagala zike da ng'hondolo hebu zike da luti kulawa muna dibumbila jake kuwa nhambiko ya maliho ya uhasanyi wake. Ivo mkulu wa nhambiko kezamtendela munhu iyo kuilumba kwa ichimu cha uhasanyi wake. ");
INSERT INTO cwe_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Mbali one hadaha kulava mwanang'hondolo, yamgalile Mndewa Mulungu huwa waidi hebu nziwa waidi kwa kuliha kwa uhasanyi uyatendile, imwe wa nhambiko ya uhasanyi na imwenga wa nhambiko ya kutimbula. ");
INSERT INTO cwe_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Kezawagala kwa mkulu wa nhambiko, nayo kezamulava imwe yawe nhambiko ya uhasanyi kwa kumbobotola isingo bila kumsegeza iditwi. ");
INSERT INTO cwe_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Damu imwenga ya nhambiko ya uhasanyi kezaimiza mumgwazo wa ulupango, na damu isigale kezaikamila hasi hana ichikalilo cha ulupango. Iyo ni nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Maabaho kezamulava ndege wekaidi kuwa nhambiko ya kutimbula fana viilagilizigwe. Mkulu wa nhambiko kezamtendela munhu iyo kuilumba kwa uhasanyi uyatendile, nayo kezalekelelwa. ");
INSERT INTO cwe_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘One munhu hadaha kulava huwa waidi hebu nziwa waidi fana nhambiko ya uhasanyi uyatendile, kezagala chilo imwe ya usage unogile fana nhambiko ya uhasanyi. Mbali hezauguma mavuta hebu ubani, kwaviya ni nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Kezamgalila mkulu wa nhambiko, nayo mkulu wa nhambiko kezasola ganza da usage unogile na kuutimbula uchanyha ya lupango lwa kulavila nhambiko fana hanhu ha lukumbuso, hamwe na nhambiko iyolaviligwa Mndewa Mulungu kwa moto. Iyo ni nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Mkulu wa nhambiko kezamtendela munhu iyo kuilumba kwa uhasanyi uyatendile, nayo kezalekelelwa. Usage wondausigale wizakuwa wa mkulu wa nhambiko fana viili kwa nhosa ya mhule.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“One munhu yoyose yahatenda uhasanyi bila kuilunga kwa kuleka kulava vinhu velile viyolaviligwa Mndewa Mulungu, kezamgalila Mndewa Mulungu bebelu da ng'hondolo dilibule chilema kulawa muna dibumbila. Bebelu da ng'hondolo dizalingigwa kwa kulinganyiza na ningo ya hema da Mulungu. Iyo ni nhambiko ya ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Munhu iyo kezaliha yehile yose yoyasang'hane kusonhela vinhu velile kwa kongeza hanhu ha tano ha maliho yake na kumwing'ha mkulu wa nhambiko. Ivo mkulu wa nhambiko kezamtendela kuilumba kwa kulava bebelu da ng'hondolo da nhambiko ya ubananzi, nayo kezalekelelwa. ");
INSERT INTO cwe_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“One munhu yoyose yahatenda uhasanyi bila kuilunga kwa kubena malagilizo ya Mndewa Mulungu, kezakuwa kabananga na kezatagusigwa kwa ubananzi wake. ");
INSERT INTO cwe_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Kezamgalila mkulu wa nhambiko bebelu da ng'hondolo dilibule chilema kulawa muna dibumbila dili na galama inogile kwa nhambiko ya ubananzi. Mkulu wa nhambiko kezamtendela kuilumba kwa ubananzi uyatendile bila kuilunga, nayo kezalekelelwa. ");
INSERT INTO cwe_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Iyo ni nhambiko ya ubananzi, kweli kabananga haulongozi ha Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“One munhu yoyose yahatenda uhasanyi na kumuleka Mndewa Mulungu kwa kumvwizila miyage kwa limangwe yoyekiligwe, hebu kumuhoka, hebu kumbamanya miyage, ");
INSERT INTO cwe_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","hebu yahapata chinhu chagile na kulonga kuwa hachiwonile bule, hebu kuilaha uvwizi kusonhela chinhu chochose chiwotenda wanhu na kubananga, ");
INSERT INTO cwe_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","hebu munhu yahatenda uhasanyi na kawa kabananga, kolondeka yabweleze chiyabawile hebu chiyapatile kwa ubamanyi, hebu chinhu chiyeng'higwe, hebu chinhu chagile kachipata, ");
INSERT INTO cwe_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","hebu chochose chiyailahile kwa uvwizi. Kezaliha chila chinhu na kongeza hanhu ha tano ha galama yake. Vondayavimanye chiyabanange, kezambwelezela mwenyewo muna isiku yondayaumanye ubananzi wake. ");
INSERT INTO cwe_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Maabaho kezamgalila mkulu wa nhambiko bebelu da ng'hondolo hebu bebelu da luti dilibule chilema, yamulavile Mndewa Mulungu nhambiko ya ubananzi. Galama ya mnyama iyo izakuwa ija izoweleke ya nhambiko ya ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mkulu wa nhambiko kezamtendela kuilumba munhu iyo haulongozi ha Mndewa Mulungu, nayo kezalekelelwa kwa ubananzi uyatendile.” ");
INSERT INTO cwe_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Mwing'he Haluni na wanage wa chilume malagilizo yano, ‘Zino ni ndagilizi kusonhela nhambiko za kutimbula. Nhambiko ya kutimbula izakuwa muna umoto mchanyha ya lupango ichilo chose mbaka imitondo na moto wake wokong'heligwa muladi sekeuzimike. ");
INSERT INTO cwe_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Maabaho mkulu wa nhambiko kezayawala walo jake da chitani na kaputula yake ya chitani, kezasola maivu ya nhambiko ija ya kutimbula kulawa kuna ulupango na kuyeka hamgwazo ya ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Maabaho kezakwasakanya viwalo vake na kezayagala maivu yaja kunze ya lago hanhu helile. ");
INSERT INTO cwe_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Moto wa lupango wolondeka ugendelele kwaka, sekeuzimigwe. Chila siku imitondo mkulu wa nhambiko kezakwika ngodi muna umoto uwo na uchanyha yake kezakwika nhambiko ya kutimbula, na kutimbula mavuta ya nhambiko ya tindiwalo. ");
INSERT INTO cwe_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Moto wizagendelela kwaka siku zose mchanyha ya lupango bila kuzimigwa. ");
INSERT INTO cwe_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Yano ni malagilizo kusonhela nhosa ya mhule. Welesi wa Haluni weli wakulu wa nhambiko, wezamgalila Mndewa Mulungu haulongozi ha ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Maabaho mkulu wa nhambiko kezasola ganza dimwe da usage unogile na mavuta na ubani wose na kuvitimbula uchanyha ya lupango fana hanhu ha lukumbuso na mnung'ho wake unogile wizamnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Usage usigale wezakuja Haluni na wanage wa chilume bila kuguma lusu. Wezakuja muna uluwa lwa hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Sekewokigwe hamwe na lusu. Niweng'ha wawo hanhu baho kulawa muna zinhosa ziwonilavila kwa moto, nhambiko zelile ng'hani fana vizili nhambiko za uhasanyi na nhambiko za ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Welesi wa chilume wa Haluni ni wawo waidumwe siku zose watogoleligwa kuja hanhu baho ha nhambiko ziyolaviligwa Mndewa Mulungu kwa moto. Munhu yoyose yondayadalise kolondeka yawe yelile.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Siku ya Haluni na wanage wa chilume kuhakigwa mavuta, wolondeka kumulavila Mndewa Mulungu nhosa ya mhule chilo imwe ya usage unogile fana nhosa ya chila siku. Nusu imwe ya usage uwo kezailava imisi na nusu imwenga kezailava ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Usage uwo wizahanganyigwa na mavuta na kokigwa, maabaho wizagaligwa uhawa vihande na kumulavila Mndewa Mulungu, mnung'ho wa nhambiko iyo womnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mkulu wa nhambiko yeli wa welesi wa Haluni yahakigwe mavuta yondayasole sang'hano yake, kezamulavila Mndewa Mulungu nhosa iyo, ijo ni lagilizo da siku zose. Nhosa yose izatimbuligwa. ");
INSERT INTO cwe_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Nhosa yoyose ya mhule yoilavigwa na mkulu wa nhambiko izatimbuligwa yose, haizadigwa ng'o.” ");
INSERT INTO cwe_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Walongele Haluni na wanage wa chilume kuwa yano ni malagilizo kusonhela nhambiko ya uhasanyi. Hanhu haja hoyochinjiligwa mnyama wa nhambiko ya kutimbula ni baho hondayachinjiligwe mnyama wa nhambiko ya uhasanyi, haulongozi ha Mndewa Mulungu. Iyo ni nhambiko yelile ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mkulu wa nhambiko yoyolaviligwa nhambiko iyo niiyo yondayaije. Izadigwa muna uluwa lwa hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Chinhu chochose chondachidalise mnyama iyo chizakuwa chela. Walo jojose dihalagaliligwa na damu ya mnyama iyo wa nhambiko, dolondeka difuwigwa hana ihanhu helile. ");
INSERT INTO cwe_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Nongo yoyose yambike nyama ya nhambiko yolondeka ituligwe, mbali one ihambikigwa muna ichia cha shaba, cholondeka chikwanguligwe na kusuuzigwa kwa mazi. ");
INSERT INTO cwe_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Chila mulume muna ulukolo lwa wakulu wa nhambiko kodaha kuja, iyo ni nhambiko yelile ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Mbali one damu ya nhambiko ya uhasanyi yoyose yogaligwa mgati ya hema da Mulungu, muladi kutenda kuilumba muna ihanhu helile, nhambiko iyo haizadigwa mbali izatimbuligwa kwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Yano ni malagilizo kusonhela nhambiko ya ubananzi. Nhambiko iyo yela ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Mnyama wa nhambiko ya ubananzi kezachinjigwa hanhu howochinjiligwa wanyama wa nhambiko ya kutimbula, damu yake izakwitiligwa banzi zose za lupango. ");
INSERT INTO cwe_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Mabambala yake yose ya mavuta yezalavigwa nhambiko, mabambala ya mkila na yaja yogubika utumbo, ");
INSERT INTO cwe_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","na figo zake mbili na mabambala yake yeli mchigudi na hanhu hanogile ha ini. ");
INSERT INTO cwe_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Mkulu wa nhambiko kezavitimbula mchanyha ya lupango fana nhambiko iyolaviligwa Mndewa Mulungu kwa moto. Iyo ni nhambiko ya ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Wotogoleligwa kuja nhambiko iyo ni walume wa lukolo lwa wakulu wa nhambiko muhala, mbali yolondeka kudiligwa hanhu helile. Nhambiko iyo yela ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Lagilizo ni dimwe kwa nhambiko ya ubananzi na nhambiko ya uhasanyi. Mkulu wa nhambiko yondayatende kuilumba niiyo yondayasole nyama ya nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mkulu wa nhambiko yolava nhambiko ya kutimbula ya munhu yoyose, kezasola mbende ya mnyama yoyalavigwe. ");
INSERT INTO cwe_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Chila nhosa ya mhule yokigwe hebu yambikigwe hebu ikanzingigwe, izakuwa ya mkulu wa nhambiko yoyoilava. ");
INSERT INTO cwe_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Mbali chila nhosa ya mhule iwe ihanganyigwa na mavuta hebu inyalile, izakuwa ya welesi wose wa Haluni, nawo wolondeka wagoliligwe sawasawa. ");
INSERT INTO cwe_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Yano yayo malagilizo ya nhambiko za tindiwalo ziya munhu ziyodaha kumulavila Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","One munhu yahalava nhambiko ya kumwing'ha hewela Mulungu, kezalava hamwe na nhambiko iyo magate hayagumigwe lusu yoyahanganyigwe na mavuta na magate masisili yoyahakigwe mavuta na maandazi ya usage unogile wouhanganyigwe na mavuta. ");
INSERT INTO cwe_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Hamwe na nhambiko yake iyo ya tindiwalo ya kumwing'ha hewela Mulungu, kezagala magate yoyagumigwe lusu. ");
INSERT INTO cwe_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ivo kezamulavila Mndewa Mulungu gate dimwe kulawa chila nhosa. Magate yayo yezakuwa ya mkulu wa nhambiko yokwitila damu ya mnyama wa nhambiko ya tindiwalo kuna ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nyama ya nhambiko iyo ya tindiwalo kwa kumwing'ha hewela Mndewa Mulungu izadigwa siku iyo voilavigwa, munhu halondeka kuleka nyama isigale mbaka imitondo. ");
INSERT INTO cwe_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Mbali one nhambiko iyo ya tindiwalo ni ya chilaho hebu ya kulonda mwenyewo, izadigwa siku ija iyolava nhambiko yake. Yondaisigale izadigwa igolo yake. ");
INSERT INTO cwe_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Mbali nyama yoyose ya nhambiko iyo yondaisigale mbaka siku yetatu izasomigwa. ");
INSERT INTO cwe_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","One nyama yoyose ya nhambiko ya tindiwalo ihadigwa siku yetatu, munhu yailavile hezatogoligwa, na nhambiko yake haizapetigwa. Nyama iyo yambula mwiko na munhu yoyose yondayaije kezatagusigwa. ");
INSERT INTO cwe_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Nyama yoidalisa chinhu chambule mwiko hailondeka kudigwa. Nyama iyo izalunguzigwa kwa moto. “Munhu yoyose yelile kodaha kuja nyama. ");
INSERT INTO cwe_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Mbali munhu yoyose yambule mwiko yahaja nyama iyo ilavigwe nhambiko ya tindiwalo kwa Mndewa Mulungu, kezabaguligwa mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Munhu yoyose yodalisa chinhu chochose chambule mwiko, chiwe chinhu chambule mwiko cha munhu hebu mnyama yambule mwiko hebu chinhu chochose cha kutibusa chambule mwiko, maabaho yahaja nyama ya nhambiko ya tindiwalo iyalaviligwe Mndewa Mulungu, munhu iyo kezabaguligwa mwa wanhu wake.” ");
INSERT INTO cwe_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Walongele Waisilaili kuwa sekewaje mabambala ya mavuta ya ng'ombe hebu ya luti hebu ya ng'hondolo. ");
INSERT INTO cwe_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mabambala ya mavuta ya mnyama yoyose yafile mwenyewo hebu mnyama yakomigwe na mnyama wa kumbago yodaha kwikigwa kwa kutendela vinhu vimwenga, mbali kweli sekemuyaje. ");
INSERT INTO cwe_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Munhu yoyose yahaja mabambala ya mavuta ya mnyama ija yoyalavigwe nhambiko kwa Mndewa Mulungu kwa moto, kezabaguligwa mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kaidi sekemuje damu yoyose, iwe ya ndege hebu ya mnyama hohose homukala. ");
INSERT INTO cwe_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Munhu yoyose yahaja damu kezabaguligwa mwa wanhu wake.” ");
INSERT INTO cwe_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Walongele vino Waisilaili, ‘Munhu yoyose yahalava nhambiko ya tindiwalo, kezamgalila Mndewa Mulungu hanhu ha nhambiko iyo. ");
INSERT INTO cwe_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Kezamgalila Mndewa Mulungu kwa makono yake mwenyewo nhambiko yoilavigwe kwa moto. Kezagala mabambala ya mavuta yake hamwe na chidali, nawo wezavinula uchanyha kuwa chilaguso cha kumulavila Mndewa Mulungu nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Mkulu wa nhambiko kezayatimbula mabambala yayo ya mavuta hana ulupango, mbali chidali chizakuwa cha Haluni na wanage wa chilume. ");
INSERT INTO cwe_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Chima cha kulume cha mnyama wa nhambiko zenu za tindiwalo, mwizamwing'ha mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Chima icho chizakuwa cha mwelesi wa Haluni yeli mkulu wa nhambiko, yoyolava damu na mabambala ya mavuta ya nhambiko ya tindiwalo.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Mndewa Mulungu kawalagiliza Waisilaili wasole chidali chochinuligwe uchanyha kuwa chilaguso na chima chochilavigwe cha mnyama wa nhambiko zawo za tindiwalo, wamwing'he mkulu wa nhambiko Haluni na welesi wake iwe hanhu hawo siku zose. ");
INSERT INTO cwe_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Baho ni hanhu habaguligwe kwa ichimu cha Haluni na wanage kulawa muna zinhambiko ziyolaviligwa Mndewa Mulungu kwa moto, kwandusila siku dowekigwe kumsang'hanila Mndewa Mulungu fana wakulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Viwekigwe kuwa wakulu wa nhambiko kwa kuhakigwa mavuta, Mndewa Mulungu kawalagiliza Waisilaili waweng'he hanhu baho ha nhambiko, iyo izakuwa yawo siku zose. ");
INSERT INTO cwe_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Yano ni malagilizo kusonhela nhambiko ya kutimbula na nhosa ya mhule na nhambiko ya uhasanyi na nhambiko ya ubananzi na nhambiko ya kwikigwa kwa sang'hano yelile na nhambiko za tindiwalo. ");
INSERT INTO cwe_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Mndewa Mulungu kamwing'ha Musa malagilizo yano kuna mulima wa Sinai siku ija iyawalagilize Waisilaili wamgalile nhambiko zawo kuja kuna ichuwala cha Sinai. ");
INSERT INTO cwe_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Mtange Haluni na wanage wa chilume na usole walo dinogile na mavuta ya kuhaka na ng'ombe lume wa nhambiko ya uhasanyi na mabebelu maidi ya ng'hondolo na chisege cha magate hayagumigwe lusu. ");
INSERT INTO cwe_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Maabaho waduganye Waisilaili wose hana ihanhu ha kwingilila muna dihema da Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa katenda fana viyalagilizigwe na Mndewa Mulungu. Kawaduganya Waisilaili wose hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa kawalongela wanhu wose, “Chino niicho choyalagilize Mndewa Mulungu chitendigwe.” ");
INSERT INTO cwe_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Maabaho Musa kawagala Haluni na wanage wa chilume haulongozi na kuwanava kwa mazi. ");
INSERT INTO cwe_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Maabaho kamvaza Haluni ng'hanzu na kumfunga mkwiji, kamvaza joho, kamvaza chizibawo na kuchifunga muna ichigudi chake kwa mkwiji wouhogosigwe goya. ");
INSERT INTO cwe_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Maabaho kamwikila chifuko chiya cha muimhambaga, na muna ichifuko icho kaguma Ulimu na Sumimu. ");
INSERT INTO cwe_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Musa kamvaza Haluni chilemba muna iditwi jake na kuulongozi wa chilemba icho keka hambo da zahabu, kombelo jelile, fana viya Mndewa Mulungu viyamulagilize. ");
INSERT INTO cwe_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Maabaho Musa kasola mavuta ya kuhaka na kadihaka dihema da Mulungu na vose vovikalile mgati yake kavitenda vele. ");
INSERT INTO cwe_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Maabaho kamiza mavuta yayo mchanyha ya lupango miyanza saba, kaluhaka mavuta ulupango na via vake vose na ziga na chikalilo chake, muladi kuvitenda vele. ");
INSERT INTO cwe_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Maabaho kamgidila Haluni mavuta yayo muna iditwi muladi kumwika kwa sang'hano yelile. ");
INSERT INTO cwe_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Musa kawagala wana wa chilume wa Haluni, kawavaza ng'hanzu na kuwafunga mikwiji muna ivigudi vawo na kawavaza chilemba fana viyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Maabaho Musa kagala ng'ombe lume da nhambiko ya uhasanyi. Haluni na wanage wa chilume weka makono yawo mchanyha ya ditwi da ng'ombe iyo. ");
INSERT INTO cwe_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Maabaho Musa kamchinja ng'ombe iyo, kasola damu na kuyahaka yamahembe ya ulupango banzi zose kwa chidole chake. Damu isigale kachitilila ichikalilo cha lupango. Ivo kachitenda chele kwa kuchitendela kuilumba. ");
INSERT INTO cwe_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Maabaho Musa kasola mavuta yose yakalile muna uutumbo na hanhu hanogile ha ini na figo zose mbili na mabambala yake ya mavuta na kavisoma mchanyha ya lupango. ");
INSERT INTO cwe_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mbali nyama ya ng'ombe iyo na mbende yake na mavi yake, kavilunguza kwa moto kunze ya lago fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Maabaho Musa kagala bebelu da ng'hondolo da nhambiko ya kutimbula. Haluni na wanage wa chilume weka makono yawo mchanyha ya ditwi da ng'hondolo iyo. ");
INSERT INTO cwe_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa kamchinja ng'hondolo iyo, maabaho idamu kaitilila muna zibanzi zose za lupango. ");
INSERT INTO cwe_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Kamkanha ng'hondolo iyo vihande vihande, kavitimbula hamwe na ditwi jake na mabambala yake ya mavuta. ");
INSERT INTO cwe_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Utumbo na migong'ho vivikomelezeke kusunhigwa, Musa kamtimbula ng'hondolo wose mchanyha ya lupango fana nhambiko ya kutimbula. Iyo ni nhambiko yoilavigwa kwa moto, ili na mnung'ho wa kumnogeza Mndewa Mulungu, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Maabaho Musa kagala bebelu da ng'hondolo dimwenga kwa ichimu cha nhambiko ya kumwika kwa sang'hano yelile. Haluni na wanage wa chilume weka makono yawo mchanyha ya ditwi da ng'hondolo iyo. ");
INSERT INTO cwe_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa kamchinja. Maabaho kasola damu ya ng'hondolo iyo na kumuhaka Haluni hasi ya gutwi jake da kulume na hana didole ng'hulu da mkono wake wa kulume na hana didole ng'hulu da mgulu wake wa kulume. ");
INSERT INTO cwe_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Wanage Haluni nawo weza, Musa kawahaka damu imwenga hasi ya magutwi yawo ya kulume na hana yamadole ng'hulu ya makono yawo ya kulume na hana yamadole ng'hulu ya magulu yawo ya kulume. Damu imwenga kaitilila banzi zose za lupango. ");
INSERT INTO cwe_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Maabaho kaduganya mabambala yose ya mavuta, mkila hamwe na mabambala yake ya mavuta na mabambala yake ya mavuta yogubika utumbo na hanhu hanogile ha ini na figo zose mbili na mabambala ya mavuta yake na chima cha kulume cha bebelu da ng'hondolo. ");
INSERT INTO cwe_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Maabaho muna ichisege cha magate chikigwe haulongozi ha Mndewa Mulungu kalava gate dimwe hadigumigwe lusu na gate dimwe dili na mavuta na gate dimwe sisili. Vose kavika uchanyha ya mabambala ya mavuta na chima cha kulume. ");
INSERT INTO cwe_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Musa kavika vose muna yamakono ya Haluni na wanage wa chilume, nawo wavinula uchanyha kuwa chilaguso kwa kumulavila Mndewa Mulungu nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Maabaho Musa kavisola vinhu ivo vose kulawa muna yamakono yawo na kuvitimbula uchanyha ya lupango hamwe na nhambiko ya kutimbula. Ino ni nhambiko ya kwikigwa kwa sang'hano yelile, ili na mnung'ho wa kumnogeza Mndewa Mulungu. Iyo ni nhambiko yoilavigwa kwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Maabaho Musa kasola chiya ichidali na kuchinula uchanyha kuwa chilaguso kwa kumulavila Mndewa Mulungu. Hanhu baho ha dibebelu da ng'hondolo wa kumwika kwa sang'hano yelile ni ha Musa fana viyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Maabaho Musa kasola mavuta ya kuhaka na damu kulawa muna ulupango, kammizila Haluni na wanage na mawalo yawo. Ivo Musa kaweka kwa sang'hano yelile Haluni na wanage hamwe na mawalo yawo. ");
INSERT INTO cwe_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa kawalongela Haluni na wanage wa chilume, “Kimuseni nyama ija haulongozi ha hanhu ha kwingilila muna dihema da Mulungu, muije baho hamwe na gate kulawa muna ichisege cha nhosa za kwikila kwa sang'hano yelile. Tendeni fana vinilongeligwe na Mndewa Mulungu, ‘Hanhu baho hezadigwa na Haluni na wanage.’ ");
INSERT INTO cwe_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Nyama yoyose na gate jojose vondavisigale volondeka visomigwe. ");
INSERT INTO cwe_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Sekemulawe kunze ya hanhu ha kwingilila muna dihema da Mulungu kwa siku saba, mbaka siku zenu za kwikigwa kwa sang'hano yelile zifose. Siku za kwikigwa kwa sang'hano yelile zizakuwa saba. ");
INSERT INTO cwe_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Mndewa Mulungu kalagiliza chitende fana vichitendile diyelo muladi chimtendeleni kuilumba. ");
INSERT INTO cwe_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mukale hana ihanhu ha kwingilila muna dihema da Mulungu ichilo na imisi kwa siku saba, muhatenda mbuli ziyalagilize Mndewa Mulungu, one siivo mwizadanganika. Vino ivo Mndewa Mulungu viyanilagilize.” ");
INSERT INTO cwe_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ivo Haluni na wanage wa chilume watenda vinhu vose Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Siku yenane Musa kawatanga Haluni na wanage wa chilume hamwe na walala wa Isilaili. ");
INSERT INTO cwe_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Musa kamulongela Haluni, “Sola dang'ang'a lume da ng'ombe kwa ichimu cha nhambiko ya uhasanyi na bebelu da ng'hondolo kwa ichimu cha nhambiko ya kutimbula, wanyama wose welibule chilema, maabaho walave nhambiko haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Walongele Waisilaili kuwa wasole bebelu dimwe da luti kwa ichimu cha nhambiko ya uhasanyi. Iviya wasole dang'ang'a dimwe na mwanang'hondolo kwa ichimu cha nhambiko ya kutimbula. Wanyama wose wawe na mwaka umwe na sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ng'ombe lume dimwe na bebelu da ng'hondolo dimwe kwa ichimu cha nhambiko ya tindiwalo, wakamulavile Mndewa Mulungu hamwe na nhosa ya mhule yoihanganyigwe na mavuta kwaviya diyelo Mndewa Mulungu kezamulawililani.” ");
INSERT INTO cwe_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Waisilaili wagala vinhu ivo vose haulongozi ha dihema da Mulungu fana viya Musa viyawalagilize. Bumbila jose wahita kwima haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Maabaho Musa kawalongela, “Chino icho choyalagilize Mndewa Mulungu muchitende muladi utunhizo wa Mndewa Mulungu uwoneke kumwenu.” ");
INSERT INTO cwe_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa kamulongela Haluni, “Hita kuna ulupango ukalave nhambiko yako ya uhasanyi na nhambiko ya kutimbula na kutenda kuilumba kwa ichimu chako na kwa ichimu cha Waisilaili. Maabaho lava nhosa za wanhu na kuwatendela kuilumba fana viyalagilize Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ivo Haluni kalukwenhukila ulupango na kadichinja dang'ang'a lume diya diyalavile diwe nhambiko ya uhasanyi wake mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Wanage Haluni wamgalila damu, nayo kavabika chidole chake muna idamu ija na kuyahaka mahembe ya lupango. Damu isigale kaitila hana ichikalilo cha lupango. ");
INSERT INTO cwe_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Maabaho mabambala ya mavuta na figo na hanhu hanogile ha ini kulawa muna inhambiko ya uhasanyi, kavitimbula vose mchanyha ya lupango fana viya Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mbali nyama na mbende kavisoma kunze ya dilago. ");
INSERT INTO cwe_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Haluni kamchinja mnyama wa nhambiko ya kutimbula. Wanage wamgalila damu, nayo kaimizila muna zibanzi zose za lupango. ");
INSERT INTO cwe_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Wamgalila nhambiko ya kutimbula, chihande chimwe chimwe, na ditwi, nayo kavitimbula mchanyha ya lupango. ");
INSERT INTO cwe_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Maabaho kasunha utumbo na migulu na kuitimbula hamwe na nhambiko ya kutimbula muna ulupango. ");
INSERT INTO cwe_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Haluni kaika nhosa ya wanhu haulongozi. Kamsola luti wa nhambiko ya uhasanyi kwa ichimu cha wanhu, kamchinja na kumulava nhambiko ya uhasanyi, fana viyatendile kwa ija wa mwanduso. ");
INSERT INTO cwe_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Maabaho kalava mnyama ija wa nhambiko ya kutimbula fana viyalagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Na keka haulongozi nhosa ya mhule, kamemeza ganza dimwe na kuitimbula mchanyha ya lupango hamwe na nhambiko ya kutimbula ya chila imitondo. ");
INSERT INTO cwe_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Haluni kachinja ng'ombe lume na bebelu da ng'hondolo da nhambiko za tindiwalo kwa ichimu cha wanhu. Wanage wamgalila damu na kaitilila muna zibanzi zose za lupango. ");
INSERT INTO cwe_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Mabambala ya mavuta ya ng'ombe lume ijo na bebelu da ng'hondolo na mkila na mabambala ya mavuta yogubika utumbo na figo na hanhu hanogile ha ini, ");
INSERT INTO cwe_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","wavika ivo mchanyha ya vidali, nayo kavitimbula mchanyha ya lupango. ");
INSERT INTO cwe_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Viya ividali na chima cha kulume, Haluni kavinula uchanyha iwe chilaguso cha kumulavila Mndewa Mulungu, fana Musa viyalagilize. ");
INSERT INTO cwe_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Haluni viyakomeleze kulava nhambiko zose, nhambiko za uhasanyi na nhambiko za kutimbula na nhambiko za tindiwalo, kawenulila wanhu makono yake na kuwatemela mate, maabaho kahumuluka. ");
INSERT INTO cwe_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa na Haluni wengila muna dihema da Mulungu. Viwalawile kunze, wawatemela mate wanhu na utunhizo wa Mndewa Mulungu uwalawilila wanhu wose. ");
INSERT INTO cwe_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Bahobaho moto ulawa haulongozi ha Mndewa Mulungu, uitimbula nhambiko ija na yaja mabambala ya mavuta mchanyha ya lupango. Wanhu wose viwauwone moto uwo waguta nyangi na wagwa chingubingubi. ");
INSERT INTO cwe_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabu na Abihu weli wana wa Haluni, wasola chila munhu chetezo chake, weka moto na ubani, wamulavila Mndewa Mulungu moto haulondeka, haulingile fana uyalagilize Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Moto ulawilila haulongozi ha Mndewa Mulungu na uwasoma, nawo wadanganika haulongozi wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Maabaho Musa kamulongela Haluni, “Chino icho chiyalongile Mndewa Mulungu chipindi viyalongile, ‘Nizailagusa kuwa yelile kwa waja weli habehi na niye, nizatunhizigwa haulongozi ha wanhu wose.’ ” Haluni kanyamala. ");
INSERT INTO cwe_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa kawatanga Mishaeli na Elisafani weli wana wa Uzieli mtumba wake Haluni, na kawalongela, “Izoni hano, wasoleni ndugu zenu muwasegeze hano haulongozi ha hema da Mulungu na muweke kunze ya dilago.” ");
INSERT INTO cwe_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ivo weza na wasola mitufi ya ndugu zawo kwa kwamha mawalo ya mitufi na kuigala kunze ya lago, fana viya Musa viyawalagilize. ");
INSERT INTO cwe_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Maabaho Musa kawalongela Haluni na wanage weli Eleazali na Isamali, “Gendeleleni kubunha nyele zenu hebu sekemudege mawalo yenu kwa kuomboleza muladi sekemudanganike na Mndewa Mulungu kuwawonela ludoko mting'hano wose. Mbali ndugu zenu, yani Waisilaili wose walile kwa ichimu cha kulunguzigwa na moto wougaligwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Sekemulawe kunze ya hanhu ha kwingilila muna dihema da Mulungu buleivo mwizadanganika, kwaviya mavuta ya kuhaka ya Mndewa Mulungu ya uchanyha yenu.” Ivo Haluni na wanage watenda fana Musa viyalongile. ");
INSERT INTO cwe_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Mndewa Mulungu kamulongela Haluni, ");
INSERT INTO cwe_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Vomwingila muna dihema da Mulungu, weye na wanago sekemung'we divai hebu upele wowose, buleivo mwizadanganika. Dino ni lagilizo da siku zose muna zinyelesi zenu. ");
INSERT INTO cwe_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Molondeka kubagula mbuli za chiidumwe na ziya za chila siku, ziya zelile na zambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Molondeka muwafundize Waisilaili malagilizo yose yonimwing'hileni kufosela Musa.” ");
INSERT INTO cwe_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa kamulongela Haluni na wanage wowasigale, Eleazali na Isamali, “Soleni nhosa ya mhule yoisigale muna zinhambiko za Mndewa Mulungu zozilavigwe kwa moto. Muje gate hadigumigwe lusu habehi ya ulupango kwaviya ni yelile ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mwizaidila hanhu helile kwaviya ni hanhu hako na ha wanago, muna zinhambiko ziyalaviligwe Mndewa Mulungu kwa moto, kwaviya ivo niivo vinilagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Mbali chidali chiya chinuligwe uchanyha kwa chilaguso cha kumulavila Mndewa Mulungu na chima chochilavigwa nhambiko, modaha kudila hanhu hohose hahanakwambula mwiko. Kwizakuja weye na wanago wa chilume na wa chike. Vinhu ivo kwing'higwa kuwa hanhu hako na ha welesi wako kulawa muna zinhambiko za tindiwalo za Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Chima chiya chilavigwe nhambiko na chidali icho chochinuligwa hamwe na nhambiko za mavuta zozilavigwa kwa moto. Ivo vizakuwa vako weye na wanago, ni venu siku zose fana Mndewa Mulungu viyalagilize.” ");
INSERT INTO cwe_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ivo Musa kamzahila luti iyo yoyalavigwe nhambiko ya uhasanyi, katola kuwa katimbuligwa kamala. Ivo kawehila ng'hani Eleazali na Isamali, wana wa Haluni wowasigale. Kawauza, ");
INSERT INTO cwe_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Habali hamudile nhambiko ya uhasanyi hanhu helile? Kwaviya icho ni chinhu chelile ng'hani na mwing'higwa muladi kusegeza ubananzi wa wanhu wose na kuwatendela kuilumba haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Kaidi, kwaviya damu ya nhambiko haigaligwe mgati muna ihanhu helile, kweli molondeka kumdila mgati ya hanhu helile fana vinilagilize.” ");
INSERT INTO cwe_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Haluni kamulongela Musa, “Lola, diyelo walava nhambiko yawo ya uhasanyi na nhambiko ya kutimbula haulongozi ha Mndewa Mulungu, hata ivo mbuli zino zinipata! Vino diyelo one nidile nhambiko ija ya uhasanyi ihatogoligwe haulongozi ha Mndewa Mulungu?” ");
INSERT INTO cwe_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa viyahulike mbuli izo, katogola. ");
INSERT INTO cwe_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Mndewa Mulungu kawalongela Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Walongeleni Waisilaili, ");
INSERT INTO cwe_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","‘Wanyama wose weli muna iisi yose, mutogoleligwa kuja mnyama yeli na mapaga yoyaigolile banzi mbili na yoselula. ");
INSERT INTO cwe_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Sekemuje mnyama yoyose yoselula mbali kabule mapaga yoyaigolile banzi mbili, hebu yeli na mapaga yoyaigolile banzi mbili mbali haselula. Sekemuje ngamiya, kwaviya koselula mbali kabule mapaga yoyaigolile banzi mbili. Kumwenu iyo kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Pelele sekemuje, iyo koselula mbali mapaga yake hayaigolile banzi mbili, iyo kumwenu kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Buga sekemuje, iyo koselula mbali mapaga yake hayaigolile banzi mbili, iyo kumwenu kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nguluwe sekemuje, iyo mapaga yake yaigola mbali haselula, iyo kumwenu kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kwaviya wanyama wawo wambula mwiko kumwenu, sekemuje nyama yawo hebu sekemudalise mitufi yawo. ");
INSERT INTO cwe_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Somba yoyose wa muna ibahali hebu muna ulwanda yeli na mpepe na makalabandu modaha kuja, ");
INSERT INTO cwe_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","mbali chilumbe chochose chochikala muna ibahali hebu muna ulwanda chilibule mpepe hebu makalabandu, viwe vilumbe vose vovigenda muna yamazi hebu vilumbe vose vovikala muna ibahali hebu muna ulwanda, votibusa kumwenu. ");
INSERT INTO cwe_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Vilumbe ivo kumwenu viha. Sekemuje nyama yawo hebu sekemudalise mitufi yawo kwaviya votibusa kumwenu. ");
INSERT INTO cwe_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Chochose chochikala muna yamazi chilibule mpepe na makalabandu chotibusa kumwenu. ");
INSERT INTO cwe_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ndege wano wose kumwenu wotibusa. Masumula na fulukombe na makungule, ");
INSERT INTO cwe_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","na chimhanga huwa na modeli zose za masumula, ");
INSERT INTO cwe_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","na modeli zose za howe na ");
INSERT INTO cwe_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","na mbuni na lugawa na bata mazi na modeli zose za chinyang'huwi, ");
INSERT INTO cwe_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","na bundi ng'hengeu na nhandala na zizinhila, ");
INSERT INTO cwe_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","na mulu na bundi matuwa na chilele ");
INSERT INTO cwe_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","na nzokowe na iviya modeli zose za mulowa na chizogolo shamba na gombalima. ");
INSERT INTO cwe_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Wang'onyo wose weli na mabawa na wogenda kwa magulu mane, wawo kumwenu wotibusa. ");
INSERT INTO cwe_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mbali wang'onyo wamwenga weli na mabawa wowogendela migulu mine na weli na migulu yoiwadahiza kuzumha, modaha kuja. ");
INSERT INTO cwe_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Wawo ni chila modeli ya nyela, chila modeli ya ngeda, chila modeli ya duludulu na chila modeli ya semvule. ");
INSERT INTO cwe_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mbali wang'onyo wamwenga wose weli na migulu mine na mabawa wotibusa kumwenu. ");
INSERT INTO cwe_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Kudalisa wanyama wamwenga komtenda munhu yambule mwiko, yoyose yodalisa mitufi yawo kokwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Munhu one yahapapa hanhu ha mitufi yake kezakwambula mwiko mbaka ichigulogulo, na viwalo vake volondeka vifuwigwe. ");
INSERT INTO cwe_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Mnyama yoyose yelibule mapaga yaigolile na haselula, iyo kumwenu kambula mwiko. Munhu yoyose yodalisa mnyama iyo kezakuwa kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Wanyama wose wowogendela mafumba ingawa wana magulu mane, kumwenu wambula mwiko. Yoyose yondayadalise mitufi ya mnyama fana iyo kezakuwa kambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Munhu yoyose yopapa mtufi, kezakwambula mwiko mbaka ichigulogulo, nayo kezafuwa viwalo vake. Wanyama wawo kumwenu wambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Viumbe vino vitambala kumwenu vambula mwiko, fuko na ngoso na modeli yoyose ya ng'henge, ");
INSERT INTO cwe_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","na golombela na ng'henge na gugulu na lwivi. ");
INSERT INTO cwe_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Wawo wose wotambala kumwenu wambula mwiko na yoyose yondayadalise mitufi yawo, kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","One mtufi wa viumbe wawo wolagalila chinhu chochose, chiwe chinhu cha mbao hebu walo hebu mbende hebu guniya hebu chia chochose chochisang'haniligwa kwa lungilo jojose, chia icho chizakwambula mwiko mbaka ichigulogulo. Yolondeka kuchisunha kwa mazi muladi chele. ");
INSERT INTO cwe_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","One mtufi wake uhalagalila muna ichia cha ulongo, ivo chochose chili mgati ya chia icho chizakwambula mwiko, na yolondeka chia icho chibenigwe. ");
INSERT INTO cwe_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ndiya yoyose hebu ching'waji chochose chidalisa mazi yake, chizakwambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Chila chinhu chondachilagaliligwe na mtufi, chizakwambula mwiko. Ihawa tanuli hebu jiko, cholondeka chibenigwe, vizakuwa vambula mwiko na vizagendelela kwambula mwiko kumwenu, ");
INSERT INTO cwe_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","mbali nzasa ya mazi hebu kombo da mazi havambule mwiko. Mbali one munhu yahengila na kudalisa mtufi, kezakwambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Na chihande chochose cha mtufi chihalagalila mbeyu za kuhanda, mbeyu izo zizakuwa hazambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mbali one mbeyu zihagumigwa muna yamazi na hanhu hohose ha mtufi hazilagalila, mbeyu izo kumwenu zambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘One mnyama yoyose yofaya kudigwa yahafa, munhu yoyose yondayadalise mtufi uwo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Na munhu yoyose yahaja hanhu hohose ha mnyama ya mtufi uwo, kolondeka yafuwe walo jake, mbali kezakuwa kambula mwiko mbaka ichigulogulo. Na yoyose yondayapape mtufi uwo kolondeka kufuwa walo jake na kezakuwa kambula mwiko mbaka chigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Chilumbe chochose chitambala muna iisi, kumwenu chotibusa, sekemuje. ");
INSERT INTO cwe_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Chochose chochigendela munda wake na chochose chochigendela migulu yose mine hebu migulu mingi, sekemuvije kwaviya votibusa kumwenu. ");
INSERT INTO cwe_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ivo sekemuitibuse kwa kuja viumbe vitambala, hebu sekemwambule mwiko kwa vinhu ivo. ");
INSERT INTO cwe_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mana niye ni Mndewa Mulungu, Mulungu wenu, ivo molondeka mwiilave wenyewo kwa ichimu changu na muwe welile, kwaviya niye ni yelile, sekemuitende mwambule mwiko kwa chinhu chochose chochitambala muna iisi. ");
INSERT INTO cwe_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Niye Mndewa Mulungu, Mulungu wenu yonimulavileni muna iisi ya Misili muladi niwe Mulungu wenu. Molondeka muwe welile, kwaviya niye ni yelile. ");
INSERT INTO cwe_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Basi dino ijo lagilizo kusonhela wanyama na ndege na vilumbe vose vili na ugima vovikala muna yamazi na vovitambala muna iisi, ");
INSERT INTO cwe_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","muladi kubagula vinhu havambule mwiko na vambule mwiko, wanyama wowodaha kudigwa na waja hawadigwa.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Walongele vino Waisilaili, ‘Mwanamke yahawa na wimo, yahaibasula mwana wa chilume, kezakwambula mwiko kwa siku saba fana viya voyokuwa kambula mwiko lusita lwa siku zake. ");
INSERT INTO cwe_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Muna isiku yenane mwana iyo kolondeka yengizigwe ulungwana. ");
INSERT INTO cwe_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Maabaho mwanamke iyo yeli na ching'hele kezagendelela kuwa kambula mwiko kwa siku malongo matatu na tatu. Chipindi icho sekeyadalise chochose chelile hebu kwingila hanhu helile mbaka siku za kusafyigwa kwake vondazimale. ");
INSERT INTO cwe_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Mbali one kaibasula mwana wa chike, kezakuwa kambula mwiko kwa majuma maidi, fana viili viyokuwa muna zisiku zake. Kezagendelela muna ukuisafya kwake kwa siku malongo sita na sita. ");
INSERT INTO cwe_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Siku za kusafyigwa kwake vondazimale, yahapata mwana wa chilume hebu wa chike, kezamgalila mkulu wa nhambiko mwanang'hondolo wa mwaka umwe hana ihanhu ha kwingilila muna dihema da Mulungu kwa ichimu cha nhambiko ya kutimbula, iviya kezamgalila nziwa hebu huwa kwa ichimu cha nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Mkulu wa nhambiko kezamulavila haulongozi ha Mndewa Mulungu na kumtendela mwanamke iyo kuilumba. Ivo mwanamke iyo kezakuwa kela kwa damu yake. Zino ni ndagilizi kwa mwanamke yoibasula mwana wa chilume hebu wa chike. ");
INSERT INTO cwe_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“ ‘One mwanamke hadaha kulava mwanang'hondolo, kezagala nziwa waidi hebu huwa waidi, imwe kwa ichimu cha nhambiko ya kutimbula na imwenga kwa ichimu cha nhambiko ya uhasanyi. Mkulu wa nhambiko kezamtendela kuilumba mwanamke iyo, nayo kezakuwa kela.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mndewa Mulungu kawalongela Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“One munhu yoyose yahawa na lulumu hebu ihu hebu baka muna ulukuli lwake, ihawoneka kuwa ni utamu wa mbende, basi kezagaligwa kwa mkulu wa nhambiko Haluni hebu imwe wa wanage, yeli mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mkulu wa nhambiko kezahalola hanhu baho, one upipi wa hanhu haja ugaluka kuwa mzelu na utamu wenyewo uhawoneka kuwa wamgati ng'hani ya mbende ya lukuli lwake, basi uwo ni utamu wa mbende. Mkulu wa nhambiko yahakomeleza kumpekula kezagong'onda kuwa munhu iyo kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Mbali one baka ijo, ingawa zelu hadingile ng'hani mgati ya mbende hebu upipi wa hanhu baho haugaluke kuwa mzelu, mkulu wa nhambiko kezambagula munhu iyo kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Siku yesaba mkulu wa nhambiko kezampekula kaidi munhu iyo, one ihawa kulingana na ulolaji wa mkulu wa nhambiko, utamu uwo hawenela bule muna imbende yake, mkulu wa nhambiko kezambagula kaidi munhu iyo kwa siku zimwenga saba. ");
INSERT INTO cwe_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Mkulu wa nhambiko kezampekula kaidi munhu iyo siku yesaba. One ihawa kulingana na ulolaji wake, hanhu haja ihatamu hafila na utamu hawenele, mkulu wa nhambiko kezamgong'onda munhu iyo kuwa kela, uwo ni uhele muhala. Munhu iyo kezafuwa viwalo vake na kezakuwa kasafyigwa. ");
INSERT INTO cwe_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mbali one uhele uwo uhenela muna imbende, munhu iyo yahamala kuilagusa kwa mkulu wa nhambiko kwa ichimu cha kusafyigwa kwake, kezakwiza kaidi kwa mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mkulu wa nhambiko kezampekula kaidi, na one uhele uja uhenela muna imbende, mkulu wa nhambiko kezamgong'onda munhu iyo kuwa kambula mwiko, uwo ni utamu wa mbende. ");
INSERT INTO cwe_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“One munhu yoyose yahawa na utamu wa mbende, kezagaligwa kwa mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Mkulu wa nhambiko kezampekula na one yahawona lulumu zelu doditenda upipi uwe mzelu na lulumu ijo digaluka kuwa chilonda chibisi, ");
INSERT INTO cwe_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","uwo ni utamu wa mbende. Mkulu wa nhambiko kezagong'onda kuwa munhu iyo kambula mwiko. Habule chimu cha kumbagula munhu iyo kwaviya kambula mwiko kamala. ");
INSERT INTO cwe_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","One utamu wa mbende uhamwamha na kwenela lukuli lwose, kwandusila kuna didosi mbaka kuna ulwayo fana vondayawone mkulu wa nhambiko, ");
INSERT INTO cwe_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","baho mkulu wa nhambiko kezamulola munhu iyo, yahawona kuwa utamu wa mbende wenela lukuli lwose, kezagong'onda kuwa munhu iyo kela kwaviya lukuli lwake lwose lugaluka luzelu. Ivo munhu iyo kela. ");
INSERT INTO cwe_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mbali one lukuli lwa munhu iyo luhawoneka luna chilonda chibisi, munhu iyo kezakwambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Mkulu wa nhambiko kezalola chilonda icho ichibisi na kumgong'onda kuwa kambula mwiko kwaviya uwo ni utamu wa mbende. ");
INSERT INTO cwe_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mbali one chilonda icho chihona na kugaluka kaidi kuwa chizelu, munhu iyo kezabwela kwa mkulu wa nhambiko, ");
INSERT INTO cwe_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Nayo kezamulola na one yahawona kuwa chigaluka kaidi kuwa chizelu, kezagong'onda kuwa kela. Munhu iyo kela. ");
INSERT INTO cwe_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“One munhu yoyose yahawa na ihu muna imbende yake, najo dihona, ");
INSERT INTO cwe_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mbali hanhu haja hohakalile na ihu hagaluka kuwa lulumu zelu hebu kuwa hadung'hu na hazelu chidogo, yolondeka kumulagusila mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Mkulu wa nhambiko kezampekula munhu iyo, yahawona hagidimila na upipi wa hanhu baho ugaluka kuwa mzelu, mkulu wa nhambiko kezagong'onda kuwa munhu iyo kambula mwiko. Uwo ni utamu wa mbende woulawile kuna diihu. ");
INSERT INTO cwe_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mbali one mkulu wa nhambiko yahamulola munhu iyo na kuwona upipi wa hanhu haja haugaluke kuwa mzelu na hahagidimile mbali hafila, basi kezambagula munhu iyo kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Mbali one utamu uwo uhenela muna imbende, mkulu wa nhambiko kezagong'onda kuwa munhu iyo kambula mwiko, iyo kana utamu. ");
INSERT INTO cwe_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mbali one hanhu haja hahenele, basi ija ni ng'hovu ya ihu muhala yoisigale, mkulu wa nhambiko kezagong'onda kuwa munhu iyo kela. ");
INSERT INTO cwe_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“One munhu yahalungula na chilonda chibisi chigaluka kuwa chidung'hu chidogo hebu chizelu, ");
INSERT INTO cwe_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","mkulu wa nhambiko kezahalola hanhu baho. Na one yahawona kuwa upipi wake ugaluka kuwa mzelu na hagidimila, uwo ni utamu wa mbende woulawile hana ihanhu halungule. Mkulu wa nhambiko kezagong'onda kuwa munhu iyo kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mbali one mkulu wa nhambiko yahawona upipi wa hanhu baho siyo mzelu na hahagidimile mbali hafila, mkulu wa nhambiko kezambagula munhu iyo kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Siku yesaba mkulu wa nhambiko kezamulola kaidi. One uhenela muna imbende, basi mkulu wa nhambiko kezagong'onda kuwa munhu iyo kambula mwiko. Uwo ni utamu wa mbende. ");
INSERT INTO cwe_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mbali one hanhu hafilile hezasigala iviya bila kwenela, ijo ni lulumu dodilawile kuna ukulungula. Mkulu wa nhambiko kezagong'onda kuwa munhu iyo kela, kwaviya iyo ni ng'hovu ya kulungula. ");
INSERT INTO cwe_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Mbali munhu yoyose mulume hebu muke, yahawa na utamu wa mbende muna iditwi hebu muna ichidevu, ");
INSERT INTO cwe_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","mkulu wa nhambiko kezaulola utamu uwo. One yahawona kuwa hagidimila na upipi uwa wa ukole na msisili, basi kezagong'onda kuwa munhu iyo kambula mwiko, kwaviya uwo ni uhele na utamu wa mbende wa muna iditwi hebu muna ichidevu. ");
INSERT INTO cwe_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","One mkulu wa nhambiko yahapekula kaidi uhele uja na yahawona hahagidimile na upipi siyo mtitu, basi mkulu wa nhambiko kezambagula munhu iyo kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Siku yesaba mkulu wa nhambiko kezalola uhele uwo. One uhele uwo hawenele na habule upipi wa langi ya ukole, hebu hahagidimile, ");
INSERT INTO cwe_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","munhu iyo kezawegula nyele zake na ndevu zake. Mbali hanhu haja heli na uhele hezahawegula bule, maabaho mkulu wa nhambiko kezambagula munhu iyo kwa siku zimwenga saba. ");
INSERT INTO cwe_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Muna isiku yesaba mkulu wa nhambiko kezalola hanhu heli na uhele muna imbende hebu havingile mgati ya mbende, basi kezagong'onda kuwa munhu iyo kela. Munhu iyo kezafuwa viwalo vake, nayo kezakwela. ");
INSERT INTO cwe_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mbali yahamala kusafyigwa uhele uwo uhenela, ");
INSERT INTO cwe_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","munhu iyo kezapekuligwa na mkulu wa nhambiko na one uhele uhenela muna imbende, mkulu wa nhambiko hezalonda kulola upipi uli na langi ya ukole, munhu iyo kezakuwa kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mbali one mkulu wa nhambiko yahawona uhele haugaluke na upipi mtitu wota hanhu baho, basi uhele uwo uhona. Munhu iyo kela. Mkulu wa nhambiko kezagong'onda kuwa munhu iyo kela. ");
INSERT INTO cwe_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“One munhu yoyose yawe mulume hebu muke kana mabaka mazelu muna imbende yake, ");
INSERT INTO cwe_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","mkulu wa nhambiko kezamulola munhu iyo. One mkulu wa nhambiko yahawona kuwa mabaka yayo ni mazelu chidogo, uwo ni uhele muhala na munhu iyo kela. ");
INSERT INTO cwe_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“One mulume yahawa na halaza, iyo kela kwaviya kana halaza muhala. ");
INSERT INTO cwe_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","One halaza ijo dihalawa kuna ichihanga, munhu iyo kana halaza muhala, na kela. ");
INSERT INTO cwe_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mbali one muna iditwi muna halaza hebu hana ichihanga hana baka dung'hu chidogo, uwo ni utamu wa mbende ya lukuli woulawile kuna dihalaza jake muna iditwi hebu muna ichihanga. ");
INSERT INTO cwe_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mkulu wa nhambiko kezamulola munhu iyo, one yahawona lulumu zelu dung'hu chidogo muna iditwi hebu muna ichihanga na dowoneka fana utamu wa mbende, ");
INSERT INTO cwe_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","munhu iyo kana utamu wa mbende. Mkulu wa nhambiko kezagong'onda kuwa munhu iyo kambula mwiko, kwaviya kana utamu wa mbende muna iditwi jake. ");
INSERT INTO cwe_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Munhu yoyose yeli na utamu wa mbende kezayawala viwalo videgeke, nyele zake hezazibunha, na mulomo wake kezaugubika, kezalonga kwa dizi kulu, ‘Niye nyambula mwiko, niye nyambula mwiko!’ ");
INSERT INTO cwe_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Munhu iyo kezagendelela kwambula mwiko kwa siku zose ziyeli na utamu uwo. Iyo kambula mwiko, nayo kezakala yaidumwe kunze ya dilago. ");
INSERT INTO cwe_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“One kuhawa na chimvuguya muna diwalo, diwe da sufu hebu chitani, ");
INSERT INTO cwe_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","walo ijo diwe dilukigwa hebu dibotigwa kwa chitani hebu sufu hebu walo ditendigwe kwa mbende yoyose, ");
INSERT INTO cwe_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","one chimvuguya icho chihawa cha langi ya yani bisi hebu ndung'hu muna diwalo ijo, walo ijo dina chimvuguya. Ivo dolondeka dilagusigwe kwa mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Mkulu wa nhambiko kezapekula chimvuguya icho na kudika hakwe diwalo ijo kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Siku yesaba kezapekula chimvuguya icho, one chihenela muna diwalo, diwe da kubota hebu da kuluka hebu da mbende yoyose, walo ijo dina utamu. Ivo walo ijo jambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Maabaho mkulu wa nhambiko kezadilunguza walo ijo kwaviya dina chimvuguya chochenela. ");
INSERT INTO cwe_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Mbali one mkulu wa nhambiko yahalola na yahawona kuwa chimvuguya hachenele bule muna diwalo, ");
INSERT INTO cwe_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","kezalagiliza walo ijo difuwigwe na dikigwe hakwe kwa siku saba zimwenga. ");
INSERT INTO cwe_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Maabaho mkulu wa nhambiko kezadilola walo ijo dihamala kufuwigwa. One hadigaluke ingawa chimvuguya hachenele bule, walo ijo jambula mwiko. Walo ijo kezadilunguza, baka da chimvuguya diwe kuchisogo hebu kuulongozi wa walo ijo. ");
INSERT INTO cwe_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","One mkulu wa nhambiko yahawona hafilile habule kwaviya difuwigwa, kezasegeza hanhu haja halingile fana utamu wa mbende. ");
INSERT INTO cwe_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Maabaho one hafilile howoneka kaidi hamwande muna diwalo dilukigwe hebu dibotigwe hebu muna ichinhu chochose cha mbende, chimvuguya icho chenela. Baho walo ijo kwizadilunguza. ");
INSERT INTO cwe_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Mbali walo diya dilawile chimvuguya dihamala kufuwigwa dolondeka kufuwigwa kaidi, ivo dokuwa jela.” ");
INSERT INTO cwe_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ijo ni lagilizo kusonhela chimvuguya chochilawa muna diwalo da sufu hebu chitani na dilukigwe hebu dibotigwe hebu da mbende. Kwa nzila iyo mwizadaha kudimanya walo jambule mwiko na walo hajambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Dino ni lagilizo kusonhela munhu yeli na utamu wa mbende muna isiku ya kusafyigwa kwake. Yahahona kezagaligwa kwa mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Mkulu wa nhambiko kezahita kumulola munhu iyo kunze ya dilago. One utamu wake wa mbende uhona, ");
INSERT INTO cwe_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","mkulu wa nhambiko kezawalongela wanhu wagale ndege waidi wagima weli hawambule mwiko, chihande cha mbiki wa mwelezi, sufu ndung'hu na tambi da hisopo kwa ichimu cha munhu iyo yondayasafyigwe. ");
INSERT INTO cwe_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Mkulu wa nhambiko kezalonga wamchinje ndege imwe uchanyha ya nongo inogile ili na mazi ya nzasa. ");
INSERT INTO cwe_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Maabaho kezamwamha ndege yeli mgima hamwe na chihande cha umbiki wa mwelezi, sufu ya langi ndung'hu na tambi da hisopo, nayo kezavabika ivo hamwe na ndege yeli mgima muna idamu ya ndege yachinjigwe. ");
INSERT INTO cwe_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Maabaho idamu ija kezammizila munhu iyo yosafyigwa utamu wa mbende miyanza saba, maabaho kezagong'onda kuwa munhu iyo kela. Ndege ija yeli mgima kezamuleka yahite kuna imigunda kunze ya lago. ");
INSERT INTO cwe_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Munhu iyo kezafuwa viwalo vake na kezawegula nyele zose na kezakoga, nayo kezakuwa kela. Maabaho kezabwela kuna dilago, mbali kezakala kunze ya hema jake kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Kezawegula nyele zake zose zili mditwi na ndevu na ng'humbitu. Kezawegula nyele zose zili muna ulukuli lwake. Maabaho kezafuwa viwalo vake na kezakoga, nayo kezakwela. ");
INSERT INTO cwe_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Siku yenane kezagala wanang'hondolo walume waidi welibule chilema na zike da ng'hondolo dimwe da mwaka umwe dilibule chilema na chilo nhatu za usage unogile wouhanganyigwe na mavuta kwa ichimu cha nhosa ya mhule, hamwe na mavuta selusi imwe ya lita. ");
INSERT INTO cwe_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mkulu wa nhambiko yondayamsafye munhu iyo kezamgala haulongozi ha Mndewa Mulungu, habehi na hana ihanhu ha kwingilila muna dihema da Mulungu hamwe na vinhu viyagalile. ");
INSERT INTO cwe_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Mkulu wa nhambiko kezasola mwanang'hondolo mulume imwe na kumulava nhambiko ya ubananzi hamwe na mavuta selusi imwe ya lita. Maabaho kezavinula uchanyha kuwa chilaguso cha kumulavila Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Maabaho kezamchinja mwanang'hondolo iyo hana ulupango, hanhu howochinjiligwa wanyama wa nhambiko ya uhasanyi na nhambiko ya kutimbula. Nhambiko ino ya ubananzi fana viili nhambiko ya uhasanyi, ivo ni va mkulu wa nhambiko, ni nhambiko yelile ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Mkulu wa nhambiko kezasola damu ya nhambiko ya ubananzi na kumuhaka munhu yosafyigwa muna digutwi jake da kulume na dole ng'hulu da mkono wake wa kulume na dole ng'hulu da mgulu wake wa kulume. ");
INSERT INTO cwe_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Maabaho mkulu wa nhambiko kezasola mavuta chidogo ya mzaituni na kuyaguma muna diganza da mkono wake wa kumoso, ");
INSERT INTO cwe_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","maabaho kezavabika chidole cha mkono wake wa kulume muna yamavuta yayo yeli kuna ichiganza cha kumoso na kuyamiza miyanza saba haulongozi wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Mavuta yasigale muna diganza jake kezamuhaka munhu iyo yosafyigwa hasi ya gutwi jake da kulume na dole ng'hulu da mkono wake wa kulume na dole ng'hulu da mgulu wake wa kulume na haja heli na damu ya nhambiko ya ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Mavuta yasigale kezamuhaka munhu iyo mditwi. Ivo mkulu wa nhambiko kezamtendela kuilumba haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Mkulu wa nhambiko kezamulavila Mndewa Mulungu nhambiko ya uhasanyi na kumtendela kuilumba ija yosafyigwa, muladi kumsegezela kwambula mwiko kwake. Maabaho kezamchinja mwanang'hondolo wa nhambiko ya kutimbula. ");
INSERT INTO cwe_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Maabaho mkulu wa nhambiko kezamulavila nhambiko ya kutimbula na nhosa ya mhule mchanyha ya lupango. Mkulu wa nhambiko kezamtendela kuilumba, nayo kezakuwa kela. ");
INSERT INTO cwe_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Mbali munhu iyo yahawa ngayengaye, hadaha kulava vinhu ivo, basi kezagala mwanang'hondolo kuwa nhambiko ya ubananzi yondayenuligwe uchanyha kuwa chilaguso cha kumulavila nhambiko, muladi kumtendela munhu iyo kuilumba. Iviya kezagala chilo imwe ya usage wouhanganyigwe na mavuta kwa ichimu cha nhosa ya mhule na mavuta selusi imwe ya lita. ");
INSERT INTO cwe_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Iviya kezagala huwa waidi hebu nziwa waidi fana viyodaha. Imwe kezakuwa wa nhambiko ya uhasanyi na imwenga wa nhambiko ya kutimbula. ");
INSERT INTO cwe_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Siku yenane kezamgalila mkulu wa nhambiko vinhu ivo haulongozi ha hanhu ha kwingilila muna dihema da Mulungu, kwa ichimu cha kusafyigwa kwake haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Mkulu wa nhambiko kezamsola mwanang'hondolo mulume iyo wa nhambiko ya ubananzi hamwe na yaja yamavuta na kezavinula uchanyha kuwa chilaguso cha kuvilavila haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kezamchinja mwanang'hondolo mulume iyo wa nhambiko ya ubananzi. Mkulu wa nhambiko kezasola damu na kumuhaka munhu iyo yosafyigwa hasi ya gutwi jake da kulume na muna didole ng'hulu da mkono wake wa kulume na dole ng'hulu da mgulu wake wa kulume. ");
INSERT INTO cwe_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Mkulu wa nhambiko kezakwika mavuta yayo chidogo muna diganza jake da kumoso, ");
INSERT INTO cwe_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","na kezayamiza kwa chidole cha mkono wake wa kulume miyanza saba haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Mkulu wa nhambiko kezamuhaka munhu iyo yosafyigwa mavuta hasi ya gutwi jake da kulume na muna didole ng'hulu da mkono wake wa kulume na dole ng'hulu da mgulu wake wa kulume. Kezamuhaka hanhu haja hoyamuhakile damu ija ya nhambiko ya ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mavuta yasigale muna umkono wake kezamuhaka munhu iyo muna iditwi, muladi kumtendela kuilumba haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Maabaho mkulu wa nhambiko kezalava huwa waidi hebu nziwa waidi fana munhu iyo viyodaha kugala, ");
INSERT INTO cwe_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","huwa imwe wa nhambiko ya uhasanyi na imwenga wa nhambiko ya kutimbula. Iviya kezalava nhosa ya mhule, mkulu wa nhambiko kezamtendela kuilumba munhu iyo yosafyigwa haulongozi wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Yayo ni malagilizo kusonhela munhu yeli na utamu wa mbende yeli hadaha kulava nhambiko ziya za kuisafya.” ");
INSERT INTO cwe_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mndewa Mulungu kawalongela Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Vondamwingile muna iisi ya Kanaani yondanimwing'heni kuwa yenu, nizatenda chimvuguya muna ikaye, muna iisi yondaiwe yenu, ");
INSERT INTO cwe_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ivo mwenekaye kezahita kumulongela mkulu wa nhambiko, ‘Niwona chimvuguya muna ikaye yangu.’ ");
INSERT INTO cwe_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Mkulu wa nhambiko kezalagiliza chila chinhu chili umo chilavigwe kunze ya kaye yang'hali hanalola chimvuguya icho, muladi chila chinhu muna ikaye sekechigong'ondigwe kuwa chambula mwiko. Maabaho mkulu wa nhambiko kezakwingila kuilola kaye iyo. ");
INSERT INTO cwe_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Kezalola chimvuguya icho, one chihawoneka muna ing'huta na chitenda mabaka ya langi ndung'hu hebu ya mayani mabisi na kuwoneka kuwa chingila mgati ya ng'huta, ");
INSERT INTO cwe_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","mkulu wa nhambiko kezalawa kunze na kuihinda kaye iyo kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Siku yesaba kezabwela na kulola kaidi. One chimvuguya chihenela muna ing'huta ya kaye iyo, ");
INSERT INTO cwe_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","mkulu wa nhambiko kezawalagiliza wasegeze mabwe yeli hanhu hana ichimvuguya na kuyasa hanhu hambule mwiko kunze ya bululu. ");
INSERT INTO cwe_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Chokaa ya ng'huta za mgati ya kaye iyo izakwanguligwa na chibugulu chake chizakwasigwa hanhu hambule mwiko kunze ya bululu. ");
INSERT INTO cwe_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Maabaho wezasola mabwe yamwenga na kuyeka hanhu haja hoyakalile mabwe ya uchanduso na kuhaka chokaa imwenga. ");
INSERT INTO cwe_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“One chimvuguya icho chihalawilila kaidi muna ikaye yahamala kusegezigwa yamabwe na kukwangula chokaa na kwika chokaa imwenga, ");
INSERT INTO cwe_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","mkulu wa nhambiko kezahita na kulola. One chimvuguya chenela muna ikaye iyo, uwo ni utamu wa chimvuguya, kaye iyo yambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Kaye iyo yolondeka ibomoligwe, mabwe yake na mibiki yake na chokaa yake vigaligwe hanhu hambule mwiko kunze ya bululu. ");
INSERT INTO cwe_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Munhu yoyose yokwingila muna ikaye lusita ihindigwa, kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Munhu yoyose yogona hebu yoja muna ikaye iyo, kolondeka yafuwe viwalo vake. ");
INSERT INTO cwe_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“One yahakomeleza kuilola goya kaye iyo, mkulu wa nhambiko kezawona chimvuguya hachenele viikomelezeke kuhakigwa chokaa, mkulu wa nhambiko kezagong'onda kuwa kaye iyo hayambule mwiko, kwaviya chimvuguya chimala. ");
INSERT INTO cwe_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Muladi kuisafya kaye iyo, mkulu wa nhambiko kezasola ndege waidi hamwe na chihande cha mbiki wa mwelezi, sufu ndung'hu na tambi da hisopo. ");
INSERT INTO cwe_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kezamchinja ndege imwe uchanyha ya nongo ili na mazi ya nzasa. ");
INSERT INTO cwe_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Maabaho kezasola chihande cha mbiki wa mwelezi na hisopo na sufu ndung'hu na ndege yeli mgima, kezavivabika vose muna idamu ya ndege ija yachinjigwe na muna yamazi ya nzasa. Kezaimizila ikaye iyo miyanza saba. ");
INSERT INTO cwe_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ivo kezaisafya ikaye iyo kwa damu ya ndege yafile na mazi ya nzasa na ndege imgima na chihande cha mbiki wa mwelezi na sufu ndung'hu na tambi da hisopo. ");
INSERT INTO cwe_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Maabaho ndege ija imgima kezamuleka yaguluke yahite kuna imigunda kunze ya bululu. Ivo niivo vondayaitendele kuilumba kaye iyo, nayo izakuwa hayambule mwiko.” ");
INSERT INTO cwe_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Yano ni malagilizo kusonhela utamu wa mbende, kwa uhele, ");
INSERT INTO cwe_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","chimvuguya muna diwalo na muna ikaye, ");
INSERT INTO cwe_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","lulumu hebu chilonda hebu baka, ");
INSERT INTO cwe_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","muladi kulagusa chinhu chelile hebu chambula mwiko. Yayo ni malagilizo kusonhela utamu wa mbende na chimvuguya. ");
INSERT INTO cwe_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mndewa Mulungu kawalongela Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Walongele vino Waisilaili, ‘Mulume yoyose yahalawigwa na ufila, ufila uwo womtenda yambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Vino niivo ufila voumtenda munhu yambule mwiko, lusita lwose vondayalawigwe na ufila hebu ufila houkimililigwa mgati yake, munhu iyo kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Komwa jojose doyokalila hebu doyogonela, jambula mwiko. Na chochose choyakalile chizakuwa chambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Munhu yoyose yodalisa komwa da munhu iyo, kolondeka yafuwe viwalo vake na yoge, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Munhu yoyose yondayakalile chinhu chiyokalila munhu iyo yolawigwa na ufila, kolondeka yafuwe viwalo vake na yoge, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Munhu yoyose yomdalisa munhu yolawigwa ufila, kolondeka yafuwe viwalo vake na yoge, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Munhu yoyose yolawigwa na ufila yahambwajulila mate munhu yelile, munhu iyo yabwajuliligwe mate kolondeka yafuwe viwalo vake na yoge, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Lili jojose da kukalila munhu yolawigwa na ufila mchanyha ya mnyama dizakuwa jambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Munhu yoyose yodalisa chinhu chochose chiyakalile munhu iyo, kezakwambula mwiko mbaka ichigulogulo. Munhu yoyose yondayasole chinhu chochose choyakalile munhu iyo, kolondeka yafuwe viwalo vake na yoge, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","One munhu yoyose yahalawigwa na ufila yahamdalisa munhu bila kunawa makono yake, munhu yadalisigwe kolondeka yafuwe viwalo vake na yoge, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Chia chochose cha ulongo chochidalisigwe na munhu yolawigwa na ufila, cholondeka chituligwe. Mbali chia chochose cha mbao cholondeka chisunhigwe na mazi. ");
INSERT INTO cwe_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Mulume yoyose yolawigwa na ufila yahahonyigwa utamu wake, kolondeka yagozele siku saba. Kezafuwa viwalo vake na koga mazi yanogile ya nzasa, nayo kezakuwa kela. ");
INSERT INTO cwe_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Siku yenane kolondeka yagale huwa waidi hebu nziwa waidi haulongozi ha Mndewa Mulungu hana ihanhu ha kwingilila muna dihema da Mulungu na kumwing'ha mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Mkulu wa nhambiko kezawalava, imwe kwa nhambiko ya uhasanyi na imwenga kwa nhambiko ya kutimbula. Mkulu wa nhambiko kezamtendela kuilumba munhu iyo haulongozi ha Mndewa Mulungu kwa ichimu cha kwambula mwiko kwake kwa kulawigwa na ufila. ");
INSERT INTO cwe_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘One mulume yoyose yahalawigwa na shahawa, kolondeka yoge mazi lukuli lwose, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Walo jojose dodilagaliligwe na shahawa hebu mbende yoyose ya mnyama yoidalisigwe na shahawa iyo, yolondeka ifuwigwe kwa mazi, nayo izakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","One mulume yoyose yahambandama muke, yahalawigwa na shahawa, wose waidi wolondeka woge mazi, nawo wezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Mwanamke yoyose viyokuwa muna zisiku zake, kezakuwa kambula mwiko kwa siku saba. Munhu yoyose yondayamdalise mwanamke iyo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Chinhu chochose chiyokalila hebu kugonela lusita yahawa muna zisiku zake, chizakwambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Munhu yoyose yondayadalise komwa da mwanamke iyo, kolondeka yafuwe viwalo vake na koga mazi, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Munhu yoyose yondayadalise chinhu chochose chiyokalila muke iyo kolondeka yafuwe viwalo vake na yoge, nayo kezakuwa kambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Munhu yoyose yondayadalise chinhu chochose chiyakalile mwanamke iyo hebu komwa, kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","One mulume yahambandama muke na damu ya siku za mwanamke iyo ihamulagalila mulume iyo, kezakwambula mwiko kwa siku saba. Komwa jojose dondayagonele mulume iyo dizakwambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘One mwanamke yahalawigwa na damu kwa siku nyingi kufosa viiwaga siku zake hebu kolawigwa damu siku siyo zake, siku zose zoyolawigwa na damu kezakwambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Komwa jojose diyogonela lusita ulo hebu ukazi uyokalila, vizakwambula mwiko fana viyokwambula mwiko lusita lwa siku zake. ");
INSERT INTO cwe_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Munhu yoyose yondayadalise vinhu ivo, kolondeka yafuwe viwalo vake na yoge, nayo kezakwambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Damu ihanyala, mwanamke iyo kezagozela siku saba muladi yawe kela, zihafosa siku izo kezakuwa kela. ");
INSERT INTO cwe_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Siku yenane kezasola huwa waidi hebu nziwa waidi na kumgalila mkulu wa nhambiko hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mkulu wa nhambiko kezamulava imwe kwa ichimu cha nhambiko ya uhasanyi na imwenga kwa ichimu cha nhambiko ya kutimbula. Maabaho mkulu wa nhambiko kezamtendela kuilumba mwanamke iyo haulongozi ha Mndewa Mulungu kwa ichimu cha kwambula mwiko kwake kwa kulawigwa damu. ");
INSERT INTO cwe_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Vino niivo vondamuwabagule Waisilaili kulawa muna ukwambula mwiko kwawo, kwaviya wahadikwenhukila hema da Mulungu jangu wahawa wambula mwiko najo dizakwambula mwiko. One wahatenda ivo wezadanganika.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Yano yayo malagilizo kwa mulume yolawa ufila na yolawa shahawa na kuwa kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Lagilizo dino domsonhela mwanamke yeli muna zisiku zake na mulume hebu mwanamke yolawigwa na chochose. Iviya domsonhela mulume yombandama muke yambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Mndewa Mulungu kalonga na Musa viwamalile kudanganika wabwanga waidi wa Haluni viwakalile womkwenhukila Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Mndewa Mulungu kamulongela Musa, “Mulongele Haluni ndugu yako sekeyengile hanhu helile ng'hani kuchisogo ya panzia lusita halulondeka, kwaviya baho hondanilawile kuna diwingu uchanyha ya ngubiko ya kuilumba. One yahatenda ivo kezadanganika. ");
INSERT INTO cwe_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Haluni kezakwingila hanhu helile ng'hani yahagala dang'ang'a da ng'ombe lume kwa ichimu cha nhambiko ya uhasanyi na bebelu da ng'hondolo kwa ichimu cha nhambiko ya kutimbula. ");
INSERT INTO cwe_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Kezakoga lukuli lose kwa mazi, maabaho kezavala mawalo yelile. Kezayawala ng'hanzu ya chitani mgati ya walo da mgati ya kaputula ya chitani na kuifunga mkwiji wa chitani, na kezafunga chilemba cha chitani. ");
INSERT INTO cwe_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Haluni kezasola mabebelu maidi ya luti kulawa kwa Waisilaili kwa ichimu cha nhambiko ya uhasanyi na bebelu da ng'hondolo kwa ichimu cha nhambiko ya kutimbula. ");
INSERT INTO cwe_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Haluni kezalava ng'ombe lume kwa nhambiko ya uhasanyi na kutenda kuilumba kwa ichimu chake mwenyewo na wanhu wa muna ikaye yake. ");
INSERT INTO cwe_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Maabaho yasole yaja mabebelu maidi ya luti na kuyagala haulongozi ha Mndewa Mulungu hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Baho kezatowa mhiya kwa kusang'hanila mabwe maidi kwa mabebelu maidi ya luti, dibwe dimwe kwa ichimu cha Mndewa Mulungu na dimwenga kwa ichimu cha Azazeli. ");
INSERT INTO cwe_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Haluni kezagala bebelu da luti dodisaguligwe na mhiya kwa ichimu cha Mndewa Mulungu na kumulavila nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Mbali bebelu da luti dodisaguligwe kwa mhiya kwa ichimu cha Azazeli dizalavigwa haulongozi ha Mndewa Mulungu kuno mgima muladi kutenda kuilumba, mkulu wa nhambiko kezamuleka yahite kuchuwala kwa Azazeli. ");
INSERT INTO cwe_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Haluni kezalava dang'ang'a lume da ng'ombe kuwa nhambiko ya uhasanyi kwa ichimu chake mwenyewo, na kutenda kuilumba kwa ichimu chake mwenyewo na kwa ichimu cha wanhu wa muna ikaye yake. Maabaho kezadichinja dang'ang'a ijo kwa nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Maabaho kezasola chetezo yoimemile makala ya moto kulawa hana ulupango lwili haulongozi ha Mndewa Mulungu na maganza maidi ya ubani woudundigwe vinogile, maabaho kezaugala kuchisogo ya panzia. ");
INSERT INTO cwe_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Kezaguma ubani muna umoto uwo haulongozi ha Mndewa Mulungu, yosi da ubani uwo dizaigubika ngubiko ya kuilumba, ivo hezadanganika. ");
INSERT INTO cwe_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Kezasola damu ya ng'ombe ija na kutopola na chidole chake na kuimiza ubanzi wa ulawilo wa zuwa wa ngubiko ya kuilumba, maabaho kezaimiza haulongozi ha sanduku da lagano miyanza saba. ");
INSERT INTO cwe_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Maabaho kezadichinja diya bebelu da luti da nhambiko ya uhasanyi kwa wanhu wose. Kezagala damu ya luti iyo hanhu helile ng'hani, na kwa damu iyo kezatenda viyaviya fana viyaitendile damu ya ng'ombe. Kezaimiza mchanyha ya ngubiko ya kuilumba na kuulongozi kwake. ");
INSERT INTO cwe_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ivo kezatenda kuilumba kwa ichimu cha hanhu helile ng'hani, kwa ichimu cha mbuli zambule mwiko ziwatendile Waisilaili na kwa ichimu cha uhasanyi wawo wose. Iviya kezatenda ivo kwa ichimu cha hema da Mulungu dili hagati ya wanhu wawo wambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Haluni viyotenda kuilumba kwa ichimu chake mwenyewo na wanhu wa muna ikaye yake na Waisilaili wose, mgati muna dihema da Mulungu sekeyakale munhu yoyose mbaka vondayakomeleze na kulawa kunze. ");
INSERT INTO cwe_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Maabaho kezalawa na kuhita kuna ulupango lwili haulongozi ha Mndewa Mulungu na kutenda kuilumba. Kezasola damu chidogo ya ng'ombe ija na luti na kuihaka muna yamahembe yose ya lupango. ");
INSERT INTO cwe_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Kezaimiza damu iyo haulongozi wa lupango kwa chidole chake miyanza saba, na ivo kulusafya kwambula mwiko kulawile kwa Waisilaili na kulutenda lwele. ");
INSERT INTO cwe_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Haluni vondayakomeleze kuhatendela kuilumba hanhu helile ng'hani na hema da Mulungu na lupango, kezalondeka yagale luti yeli mgima kwa ichimu cha Azazeli. ");
INSERT INTO cwe_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Haluni kezakwika makono yake mchanyha ya ditwi da bebelu da luti iyo yeli mgima na kulonga kwa mulomo wake uhasanyi wose wa Waisilaili na ubananzi wawo wose na wihi wawo wose, muladi kuyeka yayo yose muna iditwi da bebelu da luti. Maabaho kezamuleka luti iyo yahite kuchuwala, kezagaligwa uko na munhu yoyose yondayailave mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Kezamuleka luti iyo yahite kuchuwala, ihawa kasola ubananzi wawo wose. ");
INSERT INTO cwe_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Maabaho Haluni kezakwingila muna dihema da Mulungu na kezahambula mawalo ya chitani yoyayawale viyengile hanhu helile ng'hani na kuyaleka umo. ");
INSERT INTO cwe_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Kezakoga umo mgati hana ihanhu helile na kuyawala viwalo vake. Kezalawa na kuilavila nhambiko yake ya kutimbula, na nhambiko ya kutimbula ya wanhu wose, muladi kutenda kuilumba kwa ichimu chake mwenyewo na wanhu wose. ");
INSERT INTO cwe_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Mavuta ya nhambiko ya uhasanyi kezayatimbula mchanyha ya lupango. ");
INSERT INTO cwe_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Munhu yoyamgalile luti kwa Azazeli kolondeka yafuwe viwalo vake na koga muladi yadahe kwingila muna dilago. ");
INSERT INTO cwe_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ng'ombe na luti wowalavigwe nhambiko ya uhasanyi, waja damu yawo igaligwa hanhu helile ng'hani, muladi kutenda kuilumba, wezagaligwa kunze ya lago na kutimbuligwa. Mbende zawo na nyama zawo na mavi yawo vose vizatimbuligwa. ");
INSERT INTO cwe_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Munhu yondayawatimbule kezafuwa viwalo vake na koga, muladi yadahe kwingila muna dilago. ");
INSERT INTO cwe_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Lagilizo dino molondeka mudizindilile siku zose. Siku ya longo ya mwezi wesaba, mweye na nyambenyambe wowokala kumwenu, siku iyo molondeka mufunge na muleke kusang'hana usang'hano. ");
INSERT INTO cwe_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Kwaviya muna isiku iyo kuilumba kwizatendigwa kwa ichimu chenu muladi kumsafyani, na mweye mwizasafyigwa uhasanyi wenu wose haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Siku iyo ni siku ya mhumulo na mweye mwizaleka kuja. Lagilizo ijo dinane siku zose. ");
INSERT INTO cwe_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Mkulu wa nhambiko yoyahakigwe mavuta na kwikigwa kwa sang'hano yelile yasole hanhu ha tati yake, iyo kezatenda kuilumba kuno kayawala mawalo yelile ya chitani ");
INSERT INTO cwe_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","na kezatenda kuilumba kwa ichimu cha hanhu helile ng'hani na kwa ichimu cha hema da Mulungu na lupango na wakulu wa nhambiko na Waisilaili wose. ");
INSERT INTO cwe_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Dino ni lagilizo da kuzindililigwa siku zose, molondeka mudizindilile muladi kuwatendela kuilumba Waisilaili mwanza umwe chila mwaka kwa ichimu cha uhasanyi wawo.” Musa katenda yose fana viyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Walongele Haluni na wanage wa chilume na wanhu wose wa Isilaili, ‘Yano yayo yoyalagilize Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Munhu yoyose mwa Waisilaili yahachinja ng'ombe lume hebu mwanang'hondolo hebu luti mgati ya lago hebu kunze ya lago, ");
INSERT INTO cwe_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","bila kumgala mnyama iyo hana ihanhu ha kwingilila muna dihema da Mulungu muladi kumulavila Mndewa Mulungu. Munhu iyo kokuwa kabananga kwa kwiitila damu, ketila damu na kezabaguligwa mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Lungilo da lagilizo dino ni kuwa Waisilaili wolondeka wamgalile Mndewa Mulungu nhambiko zawo za wanyama ziya umwaka wakala wazowela kuzichinjila kuna imigunda. Wezawagala wanyama wawo kwa mkulu wa nhambiko hana ihanhu ha kwingilila muna dihema da Mulungu, wezawachinja na kumulavila Mndewa Mulungu nhambiko za tindiwalo. ");
INSERT INTO cwe_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Maabaho mkulu wa nhambiko kezaimiza damu muna ulupango lwa Mndewa Mulungu lwili hana ihanhu ha kwingilila muna dihema da Mulungu na kuyatimbula yaja yamavuta yawe na mnung'ho unogile wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ivo Waisilaili wezaleka kutambikila nyang'hiti za milungu ya uvwizi zilingile fana luti, ziwozisondelela na kumuleka Mndewa Mulungu fana munhu yotenda ugoni. Lagilizo dino dikale siku zose kwa nyelesi zose.’ ");
INSERT INTO cwe_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Walongele kuwa Muisilaili yoyose hebu nyambenyambe yokala kumwawo, yolava nhambiko ya kutimbula hebu nhambiko imwenga, ");
INSERT INTO cwe_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","mbali haigala hana ihanhu ha kwingilila muna dihema da Mulungu muladi kumulavila Mndewa Mulungu, munhu iyo kezabaguligwa mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“One Muisilaili yoyose hebu nyambenyambe yokala kumwawo koja damu yoyose, nizamulema munhu iyo na kumbagula na wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Mana ugima wa chiumbe wa muna idamu, nimwing'hani muladi kumtendelani kuilumba hana ulupango, ni damu yoitenda kuilumba kwa ichimu cha ugima wenu. ");
INSERT INTO cwe_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ivo lekamana niwalongela Waisilaili, ‘Munhu yoyose mkaya hebu nyambenyambe yokala hamwe na mweye, kolondeka sekeyaje damu.’ ");
INSERT INTO cwe_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Muisilaili yoyose hebu nyambenyambe yokala kumwenu yoyosaka mnyama hebu ndege yodigwa, kolondeka yetile damu hasi na yaisilize na msanga, ");
INSERT INTO cwe_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","kwaviya ugima wa chila chiumbe wa muna idamu. Lekamana niwalongela Waisilaili, ‘Sekemuje damu ya chiumbe chochose, kwaviya ugima wa chiumbe wa muna idamu yake.’ Yoyose yondayaje damu kezabaguligwa mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Munhu yoyose yawe mkaya hebu nyambenyambe, yoja chochose chifile chenyewo hebu chikomigwe na mnyama wa kumbago, munhu iyo kolondeka yafuwe viwalo vake na yoge, nayo kezakwambula mwiko mbaka ichigulogulo. Maabaho kezakuwa kasafyigwa. ");
INSERT INTO cwe_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mbali one hafuwile viwalo vake na koga, kolondeka yalihilizigwe kwa wihi wake.” ");
INSERT INTO cwe_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Walongele Waisilaili kuwa niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Sekemutende fana viwotenda wanhu wokala muna iisi ya Misili kuja komukalile, hebu sekemutende fana viwotenda wanhu wa isi ya Kanaani konimgalani. Sekemutende fana wawo viwotenda. ");
INSERT INTO cwe_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Molondeka kwamha malagilizo yangu na kuzindilila ndagilizi zangu. Niye ni Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ivo yamheni malagilizo na ndagilizi zangu, mana munhu yotenda ivo kezakuwa mgima. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Munhu yoyose sekeyambandame ndugu yake wa habehi. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Sekeumgume chinyala tati yako kwa kumbandama mami yako yakweleke. Sekeumgume chinyala kwaviya iyo ni mami yako. ");
INSERT INTO cwe_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Sekeumgume chinyala tati yako kwa kumbandama muke wake. ");
INSERT INTO cwe_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Sekeumbandame lumbu jako, mndele wa tati yako hebu mndele wa mami yako, yawe lumbu yelekigwe muna ikaye yenu hebu kumwenga. ");
INSERT INTO cwe_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Sekeumbandame mzukulu wako, mwana wa mwanago hebu wa mndele wako, uko ni kuiguma chinyala. ");
INSERT INTO cwe_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Sekeumbandame mndele yelekwe na mami yako wa kuvikila, kwaviya iyo ni lumbu jako iviya. ");
INSERT INTO cwe_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Sekeumbandame mami yako sangazi, lumbu wa tati yako, kwaviya iyo ni ndugu wa tati yako. ");
INSERT INTO cwe_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Sekeumbandame mwali wa mami yako, kwaviya iyo ni ndugu wa mami yako. ");
INSERT INTO cwe_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Sekeumgume chinyala sekulu wa tati yako kwa kumbandama muke wake, kwaviya iyo ni mami yako mkulu. ");
INSERT INTO cwe_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Sekeumbandame muke wa mwanago, kwaviya iyo ni mkoi wako wa chike. ");
INSERT INTO cwe_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Sekeumbandame muke wa sekulu wako hebu mdodo wako, uko ni kumguma chinyala sekulu wako hebu mdodo wako. ");
INSERT INTO cwe_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","One uhambandama muke, uteganye muladi sekeumbandame mndele wake, hebu wazukulu zake. Wawo ni ndugu wa habehi, mbuli izo ni za chilozo. ");
INSERT INTO cwe_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Sekeumsole mwali wa muke wako kuno muke wako yang'hali mgima. Iyo izawatenda wagombe. ");
INSERT INTO cwe_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Sekeumbandame muke yahawa muna zisiku zake. ");
INSERT INTO cwe_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Sekeumbandame muke wa miyago buleivo kwizaitenda mwenyewo wambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Sekeumulave mwanago yoyose kuwa nhambiko kwa mulungu Moleki, kwaviya uhatenda ivo kodiliga zina jangu, niye Mulungu wako. Niye niiyo Mndewa Mulungu, Mulungu wako. ");
INSERT INTO cwe_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Sekeumbandame mulume miyago fana muke. Mbuli iyo yotibusa. ");
INSERT INTO cwe_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Sekeumbandame mnyama muladi sekewambule mwiko, mulume yoyose hebu muke yoyose sekeyatende ivo, mana kutenda ivo ni chilozo. ");
INSERT INTO cwe_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Sekeuitende wambule mwiko kwa kutenda mbuli izo, mana kwa mbuli izo nowawinga wanhu wa zisi zili habehi na mweye, kwaviya wawo wotenda ivo na kuitenda wambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Isi yawo yambula mwiko, niye niitagusa, nayo iwadeka wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Mbali mweye na nyambenyambe wokala kumwenu, molondeka mwamhe ndagilizi na malagilizo yangu, na hebu sekemutende mbuli izo zitibusa. ");
INSERT INTO cwe_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Mbuli izo zitibusa wazitenda wanhu wakalile kuna iisi ya Kanaani, nawo waitenda isi yambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Isi izawadekani one muhaitenda yambule mwiko, fana voiwadekile wanhu wa zisi zimwenga wowamulongoleleni kukala uko. ");
INSERT INTO cwe_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Munhu yoyose yotenda mbuli yoyose mwa mbuli zino zitibusa, kolondeka yabaguligwe mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ivo yamheni chigangamavu yose yonimulagilizeni, sekemutende chihendo chochose cha kutibusa chochitendigwe na waja wamulongoleleni kukala muna iisi ija. Sekemwambule mwiko kwa mbuli izo. Niye niiyo Mndewa Mulungu, Mulungu wenu.” ");
INSERT INTO cwe_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Walongele Waisilaili wose, ‘Muwe welile kwaviya niye Mndewa Mulungu, Mulungu wenu, nyela. ");
INSERT INTO cwe_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Chila munhu vimwili yawahulike tati yake na mami yake, na molondeka muizindilile siku yangu ya mhumulo. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Sekemutambikile nyang'hiti na sekemuitendele milungu ya zuma na kuitambikila. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Vomumulavila nhambiko ya tindiwalo Mndewa Mulungu, mumulavile fana voilondeka muladi mupate kutogoligwa. ");
INSERT INTO cwe_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nyama iyo yolondeka idigwe muna isiku iyachinjigwe mnyama iyo hebu igolo yake. Nyama yoyose yondaisigale mbaka siku yetatu yolondeka isomigwe na moto, ");
INSERT INTO cwe_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","kwaviya yambula mwiko, na one munhu yoyose yahaja nyama iyo, nhambiko iyo sizaitogola bule. ");
INSERT INTO cwe_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Munhu yoyose yoja nhambiko iyo kolondeka yatagusigwe kwa ubananzi wake, kwaviya kachitenda chinhu chelile cha Mndewa Mulungu chambule mwiko. Munhu iyo kezabaguligwa mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Vondamugobole vinhu vimuhandile muna imigunda yenu, sekemugobole ng'hani mbaka muna zimhaka za migunda, hebu sekemusalale. ");
INSERT INTO cwe_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Sekemusalale migunda yenu ya mizabibu hebu sekemudondole zabibu zilagale, muwalekele nyambenyambe na ngayengaye. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Sekemubawe hebu sekemuivwizile, hebu sekemuilongele uvwizi. ");
INSERT INTO cwe_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Sekemuilahe uvwizi kwa zina jangu, na ivo kudiliga zina da Mulungu wenu. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Sekemumbamanye munhu yoyose hebu kumbawila. Yombe da munhu yekigwe kusang'hana kwa kulihigwa, sekedikale kumwenu misi na chilo. ");
INSERT INTO cwe_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Sekemumduwile msuwamagutwi hebu sekemumwikile ng'walo munhu chipofu, mbali mumdumbe Mulungu wenu. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Muhumize voilondeka, sekeumpendelee ngayengaye hebu kumdumba tajili. Mbali molondeka muwataguse wayenu voilondeka. ");
INSERT INTO cwe_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Sekemufose kuno na kuno kuwalongeleza mbuli za uvwizi wanhu wenu, hebu sekemuwatende wayenu wadanganike kwa mbuli zenu. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Sekemuwehile ndugu zenu muna imizoyo yenu, mbali molondeka muwazume wakaya wayenu muladi sekemutende ubananzi kwa ichimu chawo. ");
INSERT INTO cwe_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Sekemuwalihizile hebu kuwehila wayenu, mbali muwalonde wakaya wayenu fana vomuilonda wenyewo. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Zindilileni malagilizo yangu, sekemuleke wanyama wenu walele na wanyama wa modeli imwenga. Muna imigunda yenu sekemuhande mbeyu za modeli mbili. Sekemuyawale mawalo yasonigwe kwa modeli mbili za chitambala. ");
INSERT INTO cwe_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Mulume yahambandama mwanamke yeli mtumwa wa chike yoyauzigwe na mulume imwenga, mbali yang'hali hanakomboligwa hebu hanatendigwa yailegehe, wolondeka watagusigwe, mbali sekewakomigwe kwaviya mwanamke iyo yang'hali hanailegeha. ");
INSERT INTO cwe_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mulume iyo kezagala nhambiko yake ya ubananzi haulongozi ha hanhu ha kwingilila muna dihema da Mulungu. Nhambiko iyo ni bebelu da ng'hondolo kunilavila niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Mkulu wa nhambiko kezamtendela kuilumba kwa ng'hondolo iyo haulongozi ha Mndewa Mulungu kwa ichimu cha uhasanyi uyatendile, nayo kezalekelelwa uhasanyi wake. ");
INSERT INTO cwe_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Vondamufike kuna iisi ya Kanaani na kuhanda modeli zose za mibiki ya matunda, matunda yayo hamwizayaja bule. Mwizalemesigwa kuyaja kwa miyaka mitatu. ");
INSERT INTO cwe_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Muna umwaka wekane matunda yake yose yezakuwa yela, yezalavigwa kuwa nhosa ya kumwing'ha nhogolwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Mbali matunda ya kusongela mwaka wetano modaha kuja. One muhatenda yano yose, mibiki yenu izakwima matunda mengi. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Sekemuje nyama yoyose ili na damu. Sekemulole bawo na sekemutende uhawi. ");
INSERT INTO cwe_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Sekemusenye nyele zili mumgwazo wa matwi yenu hebu sekemuwegule ndevu zenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Sekemuichanje sale yoyose muna zing'huli zenu kwa ichimu cha wadanganike, hebu sekemwandike chilaguso muna zing'huli zenu. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Sekeumtende mwanago wa chike yambule mwiko kwa kumtenda malaya, muladi isi yose sekeimeme umalaya na wihi. ");
INSERT INTO cwe_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Zindilileni Siku zangu za Mhumulo na muhahishimu hanhu hangu helile. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Sekemuhite kwa wanhu wolonga na mizimu hebu wahawi, muladi kuwapula wamulagulileni na kuitenda mwambule mwiko. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Muhawa haulongozi ha mulala molondeka mwime muladi kumwing'ha hishima yake. Mumdumbe Mulungu wenu. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘One nyambenyambe yahakala muna iisi yenu, sekemumtendele vihile. ");
INSERT INTO cwe_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nyambenyambe iyo yokala muna iisi yenu molondeka mukale nayo vinogile fana mkaya miyenu. Mumulonde fana vomuilonda wenyewe, mana na mweye iviya mukala nyambenyambe muna iisi ya Misili. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Sekemumvwizile munhu yoyose kwa kusang'hanila ningo za uvwizi, za utali hebu nzamo hebu lumemo. ");
INSERT INTO cwe_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Molondeka musang'hanile ningo za vibaba na mhishi za kweli. Niye niiyo Mndewa Mulungu, Mulungu wenu, yonimulavileni muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Zindilileni na kutenda malagilizo yangu na ndagilizi zangu zose. Niye niiyo Mndewa Mulungu.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Walongele Waisilaili, ‘Muisilaili yoyose hebu nyambenyambe yoyose yokala kumwenu yahamulava nhambiko mwanage yoyose kwa mulungu Moleki, kolondeka yakomwigwe. Wanhu wose wezamtowa na mabwe. ");
INSERT INTO cwe_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Nizamulola munhu iyo na kumbagula mwa wanhu wake, kwaviya kamulava nhambiko mwanage kwa mulungu Moleki, na ivo kuhatenda hanhu hangu helile hambule mwiko na kudiliga zina jangu jelile. ");
INSERT INTO cwe_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Mbali one wanhu wa hanhu baho wahamuwona viyomulava mwanage kwa Moleki na hawamkoma, ");
INSERT INTO cwe_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","niye mwenyewo nizamuhindukila munhu iyo na kumtagusa yeye na lukolo lwake lose. Nizawabagula mwa wanhu wawo, yeye mwenyewo na wanhu wa muna ikaye yake walinga fana wagoni kwa kumtambikila mulungu Moleki. ");
INSERT INTO cwe_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘One munhu yoyose yahahita kwa wanhu wolonga na mizimu na wahawi, nizamulema munhu iyo na kumbagula mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ivo muyelize wenyewo na muwe welile kwaviya niye ni Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Zindilileni na kuyatenda malagilizo yangu, kwaviya niye niiyo Mndewa Mulungu yonimtendani welile. ");
INSERT INTO cwe_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Mndewa Mulungu kalagiliza kuwa munhu yoyose yomduwila tati yake hebu mami yake, koitendela mwenyewo yawe na ubananzi, kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘One mulume yahambandama muke wa miyage, kweli wose waidi wolondeka wakomigwe. ");
INSERT INTO cwe_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","One mulume yoyose yahambandama muke wa tati yake, kamguma chinyala tati yake. Kweli wose waidi wolondeka wakomigwe. Woitendela wenyewo wawe na ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Mulume yoyose yahambandama muke wa mwanage, kweli wose waidi wolondeka wakomigwe, watenda mbuli ya chilozo, woitendela wenyewo wawe na ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","One mulume yahambandama mulume miyage fana viyombandama muke, wotenda mbuli itibusa, kweli wose waidi wolondeka wakomigwe. Woitendela wenyewo wawe na ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","One mulume yahamsola muke hamwe na mami yake, wose watatu wezasomigwa moto, muladi sekekuwe na chilozo hagati yenu. ");
INSERT INTO cwe_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","One mulume yahambandama mnyama, kweli mulume iyo na mnyama iyo wolondeka wakomigwe. ");
INSERT INTO cwe_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","One muke yahambandama mnyama, muke iyo na mnyama iyo wolondeka wakomigwe. Woitendela wenyewo wawe na ubananzi. ");
INSERT INTO cwe_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘One mulume yahamsola lumbu jake, mwana wa chike wa tati yake hebu wa mami yake, na mwana iyo katogola kusoligwa na lumbu jake na kumbandama, mbuli iyo ya chinyala, waidi wawo wolondeka wabaguligwe mwa wanhu wawo haulongozi ha wanhu, kwaviya watenda mbuli ya chinyala. Mulume iyo kezatagusigwa kwa uhasanyi wake. ");
INSERT INTO cwe_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","One mulume yahambandama muke yeli muna zisiku zake, wose waidi wolondeka wabaguligwe mwa wanhu wawo. Mulume iyo kambandama muke yambule mwiko yeli na damu, na muke iyo kabandamigwa na mulume kuno kana damu. ");
INSERT INTO cwe_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Sekeumbandame mwali wa mami yako hebu mwali wa tati yako, kwa kutenda ivo kwizawaguma chinyala ndugu zako wa habehi, wose wolondeka kugaya kwa ichimu cha ugoni. ");
INSERT INTO cwe_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","One mulume yahambandama muke wa mtumba wake, kamguma chinyala mtumba wake, mulume iyo na muke iyo wezatagusigwa kwa uhasanyi uwatendile na wezadanganika bila kupata wana. ");
INSERT INTO cwe_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","One mulume yahamsola muke wa sekulu wake hebu mdodo wake, mulume iyo katenda chinhu chambule mwiko na kumguma chinyala sekulu wake hebu mdodo wake. Wezadanganika bila kupata wana. ");
INSERT INTO cwe_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Zindilileni malagilizo yangu yose na ndagilizi zangu zose, buleivo mwizadekigwa na isi yonimgalani. ");
INSERT INTO cwe_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Sekemusondelele vihendo va wanhu wokala uko, nowawinga wanhu haulongozi wenu. Kwaviya watenda mbuli zino zose, niwehila ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mbali nimulongelani, “Mwizahazi isi yawo, nizamwing'hani fana uhazi, isi ili na ulongo unogile.” Niye Mndewa Mulungu, Mulungu wenu, yonimbaguleni na wanhu wa zisi zimwenga. ");
INSERT INTO cwe_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ivo sekemuhanganye mnyama yambule mwiko na hambule mwiko, ndege yambule mwiko na hambule mwiko. Sekemwambule mwiko kwa kudalisa mnyama hebu ndege hebu chinhu chochose chochitambala muna iisi chochilemigwe kuwa chambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mwizakuwa welile kumwangu, mana niye Mndewa Mulungu nyela na nimbagulani na wanhu wa zisi zimwenga, muladi muwe wangu. ");
INSERT INTO cwe_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Mulume hebu muke yoyose yolonga na mizimu hebu muhawi, kolondeka yakomigwe kwa kutowigwa na mabwe. Wose wana ubananzi wouwalonda wakomigwe.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Mndewa Mulungu kamulongela Musa, “Walongele welesi wa Haluni weli wakulu wa nhambiko, ‘Munhu yoyose kumwenu sekeyambule mwiko kwa kumdalisa munhu yadanganike muna ulukolo lwake, ");
INSERT INTO cwe_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","mbali ndugu yake wa habehi fana viya tati yake hebu mami yake hebu mwanage hebu mndele wake hebu sekulu wake, ");
INSERT INTO cwe_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","hebu mwali wake wa habehi yeli yang'ali hanasoligwa yokala muna ikaye yake, kwa muke iyo kezaitenda mwenyewo yambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Sekeyaitende mwenyewo yambule mwiko kwa kuwadalisa ndugu wa kuuzengele wake, kwa kutenda ivo koitenda mwenyewo yambule mwiko. ");
INSERT INTO cwe_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Wakulu wa nhambiko sekewawegule nyele za mumgwazo wa matwi yawo hebu ndevu zawo hebu sekewachanje sale muna zing'huli zawo kulagusa kuwa wolila. ");
INSERT INTO cwe_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Wolondeka wawe welile kwa Mulungu wawo hebu sekewadilige zina da Mulungu wawo. Kwaviya wawo wolava kwa Mndewa Mulungu nhambiko kwa moto, yani ndiya ya Mulungu wawo. Ivo wolondeka wawe welile. ");
INSERT INTO cwe_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Wakulu wa nhambiko wolondeka sekewasole mwanamke malaya hebu muke yasigwe. Kwaviya wakulu wa nhambiko watendigwa kuwa welile kwa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Kwizammanya mkulu wa nhambiko kuwa kela, mana yeye iyo yolava nhosa ya gate da Mulungu wako. Kezakuwa kela kumwako, kwaviya niye Mndewa Mulungu niiyo yonimtendani mwele. ");
INSERT INTO cwe_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Mndele wa mkulu wa nhambiko yoyose yahaibananga kwa kutenda umalaya, komguma chinyala tati yake, kezasomigwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Mkulu wa nhambiko digogogo kahakigwa mavuta muna iditwi jake kumtenda kuwa wa chiidumwe muladi yavale viwalo velile, nyele zake sekeyazileke chakachaka na hebu sekeyadege viwalo vake kulagusa kuwa kana ndilo. ");
INSERT INTO cwe_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Sekeyamkwenhukile munhu yadanganike muladi sekeyambule mwiko, hata one ihawa yadanganike ni tati yake hebu mami yake. ");
INSERT INTO cwe_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kwaviya katendigwa kuwa wa chiidumwe kwa kuhakigwa mavuta ya Mulungu muna iditwi, sekeyasegele hanhu helile na kuhatenda hambule mwiko. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Kolondeka yasole mhambe. ");
INSERT INTO cwe_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Halondeka kusola muke mgane hebu muke yasigwe hebu muke yambule mwiko kwa ugoni hebu malaya, mbali kolondeka yasole mhambe kulawa muna iwanhu wake mwenyewo, ");
INSERT INTO cwe_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ivo sekeyawatende wanage mwenyewo wambule mwiko hagati ya wanhu wake. Niye niiyo Mndewa Mulungu, Mulungu wenu yonimtendile yele.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Mulongele Haluni, ‘Munhu yoyose muna uwelesi wako yeli na chilema sekeyakwenhuke kumgalila nhosa ya ndiya Mulungu wake. ");
INSERT INTO cwe_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Munhu yoyose yeli na chilema, chipofu hebu mbetembete hebu yeli na chihanga chibanangike hebu yeli na chiungo chongezeke muna ulukuli, ");
INSERT INTO cwe_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","hebu munhu yoyose yafile umkono hebu umgulu ");
INSERT INTO cwe_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","hebu munhu yoyose mwene muti hebu munhu mguhi ng'hani, hebu munhu halola goya hebu munhu yeli na uhele hebu yoyalumile zimbwegele. ");
INSERT INTO cwe_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Mwelekwa yoyose yeli na chilema wa mkulu wa nhambiko Haluni, sekeyakwenhuke kunilavila Mndewa Mulungu nhambiko kwa moto. Kwaviya kana chilema, sekeyakwenhuke kulava ndiya ya Mulungu wake. ");
INSERT INTO cwe_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Munhu iyo kodaha kuja ndiya ya Mulungu wake, muna indiya iyo yelile ng'hani na muna indiya iyo yelile. ");
INSERT INTO cwe_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Mbali sekeyakwenhukile dipanzia hebu ulupango, kwaviya kana chilema, sekeyahatende hanhu helile hambule mwiko, kwaviya niye Mndewa Mulungu niiyo yoniwatenda wele.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ivo Musa kawalongela Haluni na wanage na Waisilaili wose mbuli izo zose. ");
INSERT INTO cwe_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Walongele Haluni na wanage wa chilume, ‘Wakulu wa nhambiko wolondeka wazihishimu nhambiko zelile ziya Waisilaili zowazikile kuwa za chiidumwe kwa ichimu changu, muladi sekewadilige zina jangu. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","One munhu yoyose wa welesi wenu yahavikwenhukila vinhu viya Waisilaili vowavikile kuwa va chiidumwe kwa ichimu changu kuno kambula mwiko, munhu iyo nizamulema sekeyawe haulongozi wangu. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Munhu yoyose muna uwelesi wa Haluni yeli na utamu wa mbende hebu yolawigwa na ufila, sekeyaje chinhu chochose muna ivinhu velile mbaka yasafyigwe. Iviya munhu yoyose yondayadalise chinhu chambule mwiko kwa ichimu cha wadanganike, hebu munhu yolawigwa na shahawa, ");
INSERT INTO cwe_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","hebu yahadalisa chilumbe chochose chochitambala chochimtenda munhu yambule mwiko, hebu yahamdalisa munhu yodaha kumtenda yambule mwiko kwa vovose, ");
INSERT INTO cwe_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","munhu iyo kezakwambula mwiko mbaka ichigulogulo na halondeka kuja ndiya yelile mbaka vondayoge. ");
INSERT INTO cwe_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Zuwa vondadihonge kezakuwa kela. Maabaho kezadaha kuja ndiya yelile kwaviya iyo niiyo ndiya yake. ");
INSERT INTO cwe_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mkulu wa nhambiko sekeyaje nyama ya mnyama yoyose yafile mwenyewo hebu yoyakomigwe na mnyama wa kumbago, muladi sekeyambule mwiko. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Wakulu wa nhambiko wose wolondeka wazindilile malagilizo yangu, muladi sekewatende uhasanyi na kukomigwa kwa kuzeha malagilizo. Niye niiyo Mndewa Mulungu yoniwatenda wele. ");
INSERT INTO cwe_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Munhu yoyose yeli siyo wa lukolo lwa mkulu wa nhambiko halondeka kuja ndiya yelile, nyambenyambe wa mkulu wa nhambiko yokala kumwake, hebu msang'hani wa kulihigwa, sekeyaje chinhu chelile. ");
INSERT INTO cwe_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mbali one mkulu wa nhambiko yahamgula mtumwa, hebu mtumwa yahelekigwa muna ikaye yake, mtumwa iyo kodaha kuja ndiya ya mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","One mndele wa mkulu wa nhambiko yahasoligwa na munhu yeli siyo mkulu wa nhambiko, halondeka kuja nhambiko yoyose yelile. ");
INSERT INTO cwe_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mbali one mndele wa mkulu wa nhambiko yahawa mgane hebu keng'higwa chibuwa cha nyasa na kabule mwana, nayo kabwela ukaye kwa tati yake na kukala nayo fana viyakalile mbwanga, kodaha kuja ndiya ya tati yake. Mbali wanhu wa lukolo lwa mkulu wa nhambiko muhala niiwawo wolondeka kuja ndiya iyo. ");
INSERT INTO cwe_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘One munhu yoyose yahaja ndiya yelile bila kuvimanya, baho kezamwing'ha mkulu wa nhambiko na kumongeza hanhu ha tano muna ivinhu ivo. ");
INSERT INTO cwe_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Wakulu wa nhambiko sekewavitende vinhu velile va Waisilaili vambule mwiko, viya viwomulavila Mndewa Mulungu ");
INSERT INTO cwe_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","mbaka kuwatenda watende ubananzi wouwatenda watagusigwe kwa kuja ndiya zawo zelile. Niye niiyo Mndewa Mulungu yonivisafya vinhu ivo.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Walongele Haluni na wanage wa chilume na Waisilaili wose, ‘Muisilaili yoyose hebu nyambenyambe yokala muna iisi ya Isilaili yahalava nhambiko ya kutimbula kwa ichimu cha chilaho hebu nhambiko ya kulonda mwenyewo kwa Mndewa Mulungu, ");
INSERT INTO cwe_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","muladi yatogoligwe, kezalava ng'ombe lume dilibule chilema hebu bebelu da ng'hondolo dilibule chilema, hebu bebelu da luti dilibule chilema. ");
INSERT INTO cwe_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Hailondeka kulava chinhu chochose chili na chilema kwaviya hachizatogoligwa kwa ichimu chenu. ");
INSERT INTO cwe_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Munhu yoyose yahamulavila Mndewa Mulungu nhambiko ya tindiwalo muladi kufikiza chiyailahile hebu nhambiko ya kulonda mwenyewo kulawa muna dibumbila da wanyama wake, muladi yatogoligwe kolondeka yalave mnyama yanogile yelibule chilema. ");
INSERT INTO cwe_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Sekemumulavile Mndewa Mulungu mnyama yoyose yatulike yameso na chilema na yoyabeneke hanhu hohose na yolawa ufila na yeli na uhele hebu chilonda, sekemuwalave kwa Mndewa Mulungu kuwa nhambiko kwa moto hachanyha ya lupango. ");
INSERT INTO cwe_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ng'ombe lume hebu mwanang'hondolo yeli na chiungo chitali hebu chiguhi ng'hani kodaha kumulava nhambiko ya kulonda mwenyewo, mbali iyo sekeumulave kuwa nhambiko ya chilaho. ");
INSERT INTO cwe_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Mnyama yoyose yalumile zimbwegele hebu yahondigwe hebu yatuligwe hebu yakanhigwe, sekemumulavile Mndewa Mulungu. Sekemutende chinhu chilingile ivo muna iisi yenu. ");
INSERT INTO cwe_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“ ‘Sekemuhokele wanyama kulawa kwa manyambenyambe na kunilavila niye Mulungu wenu. Wanyama wawo wana chilema kwaviya wakanhigwa na hawatogoligwa kwa ichimu chenu.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“One dang'ang'a da ng'ombe hebu mwanang'hondolo hebu mwanaluti yahavumbuka kezakala na mami yake siku saba. Kwandusila siku yenane na kugendelela, kezakuwa kofaya kulavigwa nhambiko kwa Mndewa Mulungu kwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Sekemuchinje ng'ombe hebu ng'hondolo hamwe na mwanage siku dimwe. ");
INSERT INTO cwe_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","One muhamchinjila Mndewa Mulungu nhambiko ya hewela, mwizaichinja muladi mutogoligwe. ");
INSERT INTO cwe_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Mnyama iyo kolondeka yadigwe siku iyo iyo, sekemumsigaze mbaka igolo. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Zindilileni malagilizo yangu na muyatende. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Sekemudilige zina jangu jelile, kwaviya yolondeka dimanyike kuwa jelile na Waisilaili. Niye niiyo Mndewa Mulungu yonimtendani mwele, ");
INSERT INTO cwe_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","na yonimulavileni isi ya Misili muladi niwe Mulungu wenu. Niye niiyo Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Walongele Waisilaili, ‘Yano ni madugila ya Mndewa Mulungu yondamuyagong'onde kuwa mting'hano wa kutosa kwa Mulungu, yano ni madugila yangu. ");
INSERT INTO cwe_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Kuna siku sita za kusang'hana sang'hano zenu, mbali siku yesaba ni Siku ya Mhumulo, siku ya mting'hano wa kutosa kwa Mulungu. Sekemusang'hane sang'hano yoyose muna isiku iyo, ni Siku ya Mhumulo ya Mndewa Mulungu hanhu hohose homukala. ");
INSERT INTO cwe_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Yano ni madugila ya Mndewa Mulungu, yondamuwe na mting'hano wa kutosa kwa Mulungu, mwizayagong'onda kwa lusita lwikigwe. ");
INSERT INTO cwe_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“ ‘Dugila da Pasaka da Mndewa Mulungu dokwandusa ichigulogulo nguku zikwingila, siku ya longo na nne ya mwezi mosi. ");
INSERT INTO cwe_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Muna isiku ya longo na tano ya mwezi uwo, Dugila da Mndewa Mulungu da Magate Hayanagumigwa Lusu dokwandusa. Kwa siku saba molondeka muje magate hayagumigwe lusu. ");
INSERT INTO cwe_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Muna isiku ya mwanduso mwizakuwa na mting'hano wa kutosa kwa Mulungu, sekemusang'hane sang'hano ya chila siku. ");
INSERT INTO cwe_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kwa siku saba mwizamulavila Mndewa Mulungu nhambiko kwa moto. Muna isiku yesaba mwizatenda mting'hano wa kutosa kwa Mulungu, sekemusang'hane sang'hano ya chila siku.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Walongele Waisilaili, ‘Vondamwingile muna iisi yondanimwing'heni na kugobola vinhu vihandigwe umo, mwizamgalila mkulu wa nhambiko mganda wa mwanduso kugobola. ");
INSERT INTO cwe_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Mkulu wa nhambiko kezavinula uchanyha kuwa chilaguso cha kulava haulongozi ha Mndewa Mulungu muladi mutogoligwe, mkulu wa nhambiko kezailava ihafosa Siku ya Mhumulo. ");
INSERT INTO cwe_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Siku iyo vondauvinule uchanyha kuwa chilaguso cha kulava mganda haulongozi wangu, niye Mndewa Mulungu, kwizalava nhambiko ya kutimbula ya mwanang'hondolo mulume wa mwaka umwe yelibule chilema, ");
INSERT INTO cwe_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","hamwe na nhosa ya mhule ya chilo mbili za usage unogile uhanganyigwe na mavuta, zondamunilavile niye Mndewa Mulungu kwa moto. Mnung'ho wake wizaninogeza, hamwe na nhosa yake ya ching'waji lita imwe ya divai. ");
INSERT INTO cwe_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Sekemuje gate, hebu lukuso, hebu uhishi, mbaka siku iyo, vondamukomeleze kulava nhosa ya Mulungu wenu. Ndagilizi zino zizindililigwe siku zose muna zinyelesi zenu hanhu hohose homukala. ");
INSERT INTO cwe_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Mwizapeta majuma saba kwandusila siku isondelela Siku ya Mhumulo, siku ija yomugalile nhambiko ya kwinula uchanyha kwa chilaguso. ");
INSERT INTO cwe_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Siku ya malongo matano, siku isondelela ni Siku ya Mhumulo ya saba, mwizanilavila niye Mndewa Mulungu nhosa imwenga ya mhule ya vinhu va mwanduso kugobola. ");
INSERT INTO cwe_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Chila kaye wezagala magate maidi ya nhambiko ya kwinula uchanyha kwa chilaguso haulongozi hangu niye Mndewa Mulungu. Gate dolondeka diumbigwe kwa chilo mbili za usage unogile ugumigwe lusu. Gate ijo mwizanilavila niye Mndewa Mulungu diwe nhosa ya vinhu va mwanduso kugobola. ");
INSERT INTO cwe_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Iviya mwizalava wanang'hondolo walume saba wa mwaka umwe, welibule chilema, dang'ang'a lume da ng'ombe, mabebelu ya ng'hondolo maidi. Wanyama wawo wezakuwa nhambiko ya kutimbula, hamwe na nhosa za mhule na nhosa za ving'waji zizalavigwa kwa moto. Minung'ho inogile ya nhambiko izo izaninogeza niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Iviya mwizalava bebelu da luti kuwa nhambiko ya uhasanyi na wanang'hondolo walume waidi wa mwaka umwe kuwa nhambiko ya tindiwalo. ");
INSERT INTO cwe_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Maabaho mkulu wa nhambiko kezazinula uchanyha kwa chilaguso haulongozi wangu Mndewa Mulungu, hamwe na gate da vinhu va mwanduso kugobola, na wanang'hondolo waja waidi. Vinhu ivo vela kwa Mndewa Mulungu, ivo vizakuwa va wakulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Siku iyo mwizagong'onda mting'hano wa kutosa kwa Mulungu. Sekemutende usang'hano wa chila siku. Lagilizo dino dolondeka dizindililigwe siku zose muna zinyelesi zenu, hanhu hohose homukala. ");
INSERT INTO cwe_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Muhagobola vinhu venu vimuhandile muna imigunda yenu, sekemugobole mbaka muna zimhaka za migunda hebu sekemubwele kuchisogo kudondoleza visigale. Walekeleni ngayengaye na nyambenyambe. Niye niiyo Mndewa Mulungu, Mulungu wenu.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Walongele Waisilaili, ‘Siku ya mwanduso ya mwezi wesaba mwizaitenda kuwa siku ya kuhumula. Siku ya kukumbukigwa yondaigong'ondigwe kwa dizi da mhalati kutenda mting'hano wa kutosa kwa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Sekemutende sang'hano ya chila siku na mumulavile Mndewa Mulungu nhambiko kwa moto.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Siku ya longo ya mwezi uno wesaba ni Siku ya Kuilumba. Muna isiku iyo ya mting'hano wa kutosa kwa Mulungu, mwizafunga na kumulavila Mndewa Mulungu nhambiko kwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Muna isiku iyo sekemutende sang'hano yoyose, kwaviya ni Siku ya Kuilumba, vondamusegezeligwe uhasanyi wenu haulongozi ha Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Munhu yoyose yoja chinhu chochose muna isiku iyo, kezabaguligwa mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Munhu yoyose yotenda usang'hano muna isiku iyo, nizamkoma mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Sekemusang'hane usang'hano. Ndagilizi ino izindililigwe siku zose muna zinyelesi zenu na hanhu hohose homukala. ");
INSERT INTO cwe_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Siku iyo kumwenu izakuwa siku ya kuhumula na mwizafunga. Siku ya Mhumulo yokwandusa ichigulogulo cha siku ya kenda na yokomelezeka ichigulogulo cha siku ya longo.” ");
INSERT INTO cwe_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Walongele Waisilaili, ‘Muna isiku ya longo na tano ya mwezi wa saba, Dugila da Vibanda da Mndewa Mulungu dokwandusa. Dizakomelezeka kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Siku ya mwanduso mwizakuwa na mting'hano wa kutosa kwa Mulungu, sekemutende sang'hano ya chila siku. ");
INSERT INTO cwe_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kwa siku saba, mwizamulavila nhambiko Mndewa Mulungu kwa moto. Siku yenane mwizakuwa na mting'hano wa kutosa kwa Mulungu na kumulavila Mndewa Mulungu nhambiko kwa moto. Mting'hano uwo wela, siku iyo sekemusang'hane sang'hano ya chila siku. ");
INSERT INTO cwe_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Yano ni madugila yapangigwe ya Mndewa Mulungu yondamugong'onde kuwe na mting'hano wa kutosa kwa Mulungu kwa kumulavila nhambiko zozilavigwa kwa moto, nhambiko za kutimbula na nhosa za mhule na nhosa za ching'waji, chila chinhu muna isiku yake ipangigwe. ");
INSERT INTO cwe_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Nhambiko izo ni hamwe na ziya zomunilavila niye Mndewa Mulungu muna Isiku ya Mhumulo, hamwe na nhambiko zenu zimuzowele, hamwe na nhambiko za chilaho, hamwe na nhambiko za kulonda mwenyewo zomunilavila niye Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Muhakomeleza kugobola muna imigunda yenu, mwizatenda dugila kwa siku saba, kwandusila siku ya longo na tano ya mwezi wa saba. Siku ya mwanduso izakuwa siku ya kuhumula, na siku yenane iviya izakuwa ya kuhumula. ");
INSERT INTO cwe_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Muna isiku ya mwanduso mwizasola matunda ya mibiki inogile na matambi ya mitende na matambi yeli na mayani mengi na matambi ya mibiki yoikota mumgwazo ya lwanda. Mwizatenda dugila haulongozi ha Mndewa Mulungu, Mulungu wenu kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Chila mwaka mutende dugila dino kwa siku saba kwa Mndewa Mulungu. Ndagilizi ino muizindile siku zose muna zinyelesi zenu. Mwizaditenda muna umwezi wa saba. ");
INSERT INTO cwe_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Waisilaili wose wolondeka wakale muna ivibanda kwa siku saba, ");
INSERT INTO cwe_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","muladi nyelesi zenu wavimanye kuwa viniwalavile Waisilaili muna iisi ya Misili, niwatenda wakale muna ivibanda. Niye niiyo Mndewa Mulungu, Mulungu wenu.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ivo Musa kawalongela Waisilaili madugila yayo yapangigwe ya Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Walagilize Waisilaili wakugalile mavuta yanogile ya mzaituni muladi vitasa vigendelele kwaka. ");
INSERT INTO cwe_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Haluni kezachika chinala icho cha vitasa mgati ya hema da Mulungu, kunze ya panzia da hanhu helile ng'hani muladi vigendelele kwaka haulongozi ha Mndewa Mulungu kwandusila ichilo mbaka imitondo. Ndagilizi ino yolondeka izindililigwe siku zose muna zinyelesi zenu. ");
INSERT INTO cwe_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Haluni kezavika vitasa ivo hana ichinala cha zahabu inogile haulongozi ha Mndewa Mulungu na vizagendelela kwaka chila siku. ");
INSERT INTO cwe_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Soleni chilo malongo maidi na nne za usage unogile moke magate longo na maidi. ");
INSERT INTO cwe_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Yekeni yamagate muna imisitali midi uchanyha ya meza ya zahabu inogile, chila msitali uwe na magate sita. ");
INSERT INTO cwe_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Chila msitali mwizakwika ubani unogile muladi uilumbe na magate yayo na kuwa hanhu ha nhambiko ya lukumbuso kwa Mndewa Mulungu kwa moto. ");
INSERT INTO cwe_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chila Siku ya Mhumulo Haluni kezayapanga goya magate haulongozi ha Mndewa Mulungu, kwa ichimu cha wanhu wa Isilaili fana lagano da siku zose. ");
INSERT INTO cwe_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Haluni na wanage wa chilume wolondeka kuja magate yayo, nawo wezayadila hanhu helile, kwaviya kumwawo yela ng'hani muna zinhambiko ziyolaviligwa Mndewa Mulungu kwa moto. Iyo ni hanhu hawo siku zose.” ");
INSERT INTO cwe_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Siku dimwe mbwanga imwe mami yake Muisilaili na tati yake Mmisili, kahita kuitowa ng'hondo na Muisilaili imwenga kuna dilago. ");
INSERT INTO cwe_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mbwanga ija mami yake yatangigwe Shelomisi mndele wa Dibili wa kabila da Dani, kadiliga na kudiduwila zina da Mndewa Mulungu. Wanhu wamgala imbwanga iyo kwa Musa. ");
INSERT INTO cwe_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Wamkaliza mbaka vondawavimanye chiyolonda Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Maabaho Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mulave kunze ya lago munhu iyo yaduwile, wanhu wose wowamuhulike viyoduwila weke makono yawo uchanyha ya ditwi jake, waleke wanhu wose wamkome kwa kumtowa na mabwe. ");
INSERT INTO cwe_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Iviya walongele Waisilaili, ‘Munhu yoyose yomduwila Mulungu wake kolondeka yatagusigwe kwa uhasanyi wake. ");
INSERT INTO cwe_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Munhu yoyose mkaya hebu nyambenyambe yodiliga zina da Mndewa Mulungu, wanhu wose wezamkoma kwa kumtowa na mabwe. ");
INSERT INTO cwe_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Munhu yoyose yomkoma miyage kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Munhu yoyose yomkoma mnyama kolondeka yalave mnyama imwenga muladi kulihila ija yakomigwe, ugima kwa ugima. ");
INSERT INTO cwe_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“ ‘Munhu yoyose yomulumiza miyage kolondeka yalumizigwe fana viya viyamulumize miyage. ");
INSERT INTO cwe_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","One munhu yahambena miyage divuha, nayo kolondeka yabenigwe divuha, ziso kwa ziso, zino kwa zino. Chila munhu yomulumiza miyage kolondeka yalumizigwe fana viyamulumize miyage. ");
INSERT INTO cwe_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Munhu yoyose yomkoma mnyama kolondeka yalave mnyama imwenga muladi kuliha ija yakomigwe, mbali munhu yoyose yomkoma munhu miyage, kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Mwizakuwa na lagilizo dimwe kusonhela nyambenyambe na wakaya. Niye niiyo Mndewa Mulungu, Mulungu wenu.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Musa kawalongela Waisilaili mbuli izo zose. Wamulava kunze ya lago munhu ija yamduwile Mndewa Mulungu na wamkoma kwa kumtowa na mabwe. Waisilaili watenda fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mndewa Mulungu kalonga na Musa kuna mulima wa Sinai na kamulagiliza, ");
INSERT INTO cwe_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Walongele Waisilaili, ‘Vondamufike muna iisi yonimwing'hani, chila mwaka wa saba isi yolondeka ihumule. Sekeilimigwe kwa ichimu cha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kwa miyaka sita mwizahanda migunda yenu na mwizadahulila mizabibu yenu na kwaha matunda yake, ");
INSERT INTO cwe_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","mbali mwaka wa saba ni mwaka wa kuhumuza isi, mwaka wa kuhumula wa Mndewa Mulungu. Sekemuhande migunda yenu hebu kudahulila mizabibu yenu. ");
INSERT INTO cwe_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Chinhu chochose chochikota chenyewo sekemuchigobole, hebu sekemwahe zabibu muna imizabibu haidahuliligwe. Uwo wizakuwa mwaka wa isi kuhumula. ");
INSERT INTO cwe_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Mwaka uwo wa isi kuhumula, isi izampatilani ndiya, mweye na watumwa wenu wa chilume na wa chike, wasang'hani wenu na nyambenyambe wamwenga wokala kumwenu. ");
INSERT INTO cwe_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Isi izaweng'ha ndiya wanyama wenu wa kufugigwa na wanyama wa kumbago wowokala muna imigunda yenu. ");
INSERT INTO cwe_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Mwizapeta miyaka saba miyanza saba, yose izakuwa miyaka malongo mane na kenda. ");
INSERT INTO cwe_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Maabaho muna isiku ya longo ya umwezi wa saba, ili Siku ya Kuilumba, mwizamtuma munhu yatowe mhalati muna iisi yose. ");
INSERT INTO cwe_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mwaka wa malongo matano mwizautenda kuwa wa chiidumwe kwa kugong'onda kuilegeha kwa watumwa wose muna iisi. Mwaka uwo wizakuwa wa kubweleza. Chila munhu kumwenu yoyaguligwe fana mtumwa, kolondeka yabwele isi yake na iwanhu wake. ");
INSERT INTO cwe_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kwaviya mwaka uwo ni mwaka wa kubweleza, sekemuhande mbeyu hebu kugobola chinhu chochose chochikota chenyewo, hebu sekemwahe zabibu muna imizabibu haidahuliligwe. ");
INSERT INTO cwe_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kwaviya mwaka uwo ni wa kubweleza, wizakuwa wela kumwenu, mwizakuja chinhu chochikota chenyewo muna imigunda. ");
INSERT INTO cwe_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Muna umwaka uwo wa kubweleza, chila munhu kolondeka yabwele isi yake. ");
INSERT INTO cwe_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Uhagula isi hebu kuchuuza isi kwa miyago, sekeumbunze. ");
INSERT INTO cwe_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Bei ya isi yolondeka iilinge na miyaka mbaka mwaka wa kubweleza ukwiza. ");
INSERT INTO cwe_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","One miyaka ihawa mingi kwizakongeza bei, na one ihawa midodo kwizahunguza bei, kwaviya bei yake izalingigwa fana viya mavuno yake yoyokuchuuziya. ");
INSERT INTO cwe_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Sekemuibunze, mbali mumdumbe Mulungu wenu. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Zindilileni ndagilizi yangu na kutenda vinilagilize, muladi mugendelele kukala bila kudumba muna iisi. ");
INSERT INTO cwe_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Isi izakwima matunda yake na mwizakuwa na vinhu vose vimulonda kuja, na mwizakala bila kudumba. ");
INSERT INTO cwe_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","One muhalonga, “Chizakuja choni muna umwaka wesaba one hachihandile hebu kugobola?” ");
INSERT INTO cwe_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Muna umwaka wesita nizaitemela mate isi, nayo izampatilani ndiya za kuwafaya kwa miyaka mitatu. ");
INSERT INTO cwe_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","One muhahanda migunda yenu muna umwaka wenane, mwizakuwa mung'hali moja vinhu vimugobole umwaka. Mwizagendelela kuja mbaka vondamugobole mwaka wa kenda. ");
INSERT INTO cwe_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Siku zose isi sekeichuuzigwe, kwaviya isi ni yangu. Mweye ni nyambenyambe na wafosanzila muna iisi yangu. ");
INSERT INTO cwe_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","One isi yenu ihachuuzigwa, haki ya mwene kuikombola izamanyika. ");
INSERT INTO cwe_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘One ndugu yako yahawa ngayengaye na kuchuuza isi yake, ndugu yake wa habehi kezaikombola. ");
INSERT INTO cwe_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","One munhu iyo yahawa kabule ndugu wa kuikombola, mbali hamwande kokuwa tajili na kodaha kuikombola, ");
INSERT INTO cwe_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","kezapeta miyaka kulawa viyachuuze na kuliha hela kulingana na miyaka isigale kufika mwaka wa kubweleza. Munhu ija yagulile isi kolondeka yambwelezele. ");
INSERT INTO cwe_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mbali one hadaha kuikombola, izasigala muna yamakono ya ija yagulile mbaka mwaka wa kubweleza. Muna umwaka uwo, isi iyo yolondeka ilekigwe na kubwelezigwa kwa ija yachuuzile, nayo kezabwela isi yake. ");
INSERT INTO cwe_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","One munhu yahachuuza kaye yake iyokala ili mgati ya dibululu dodizengigwe ng'huta, kezadaha kuikombola kwa chipindi cha mwaka umwe kwandusila viyachuuzile. Kwa mwaka uwo wose kezakuwa na haki ya kuikombola. ");
INSERT INTO cwe_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Mbali one kaye ili muna dibululu dizengigwe ng'huta haikomboligwe kwa chipindi cha mwaka umwe, izakuwa ya ija yaigulile siku zose muna zinyelesi zake zose, hebu haizabwelezigwa muna umwaka wa kubweleza. ");
INSERT INTO cwe_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mbali kaye zili muna ivibululu zili hazizungulusiligwe ng'huta, zizapetigwa hamwe na migunda, nazo zodaha kukomboligwa na zizabwelezigwa muna umwaka wa kubweleza. ");
INSERT INTO cwe_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Hata ivo kaye zili muna yamabululu ya Walawi, Walawi wodaha kuzikombola lusita lolose. ");
INSERT INTO cwe_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","One imwe wa Walawi haikombole, kaye ichuuzigwe yolondeka ibwelezigwe kwa mwenyewo muna umwaka wa kubweleza, kwaviya kaye zili muna yamabululu ya Walawi weng'higwa kuwa zawo kulawa kwa Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mbali migunda yose ya kudimila Walawi ili muna yamabululu yawo, sekeichuuzigwe, kwaviya uwo ni uhazi wawo siku zose. ");
INSERT INTO cwe_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘One ndugu yako Muisilaili yahawa ngayengaye na hadaha kuitunza mwenyewo yahawa hamwe na weye, kolondeka umtunze muladi yagendelele kukala na weye. Mtendele fana nyambenyambe hebu mfosanzila yokala kumwako. ");
INSERT INTO cwe_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Sekeulonde yakongeze hela imwenga muna ihela iyakwazime, mbali umdumbe Mulungu wako muladi ndugu yako yadahe kukala hamwe na weye. ");
INSERT INTO cwe_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Sekeumwazime hela kwa kulonda yakulihe limangwe, hebu kumwing'ha ndiya muladi yakulihe limangwe. ");
INSERT INTO cwe_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Niye niiyo Mndewa Mulungu, Mulungu wako, yonikulavile isi ya Misili muladi kukwing'ha isi ya Kanaani, muladi niwe Mulungu wako. ");
INSERT INTO cwe_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘One ndugu zenu Waisilaili wokala habehi na mweye wahawa ngayengaye na kuichuuza kumwenu, sekemuwatende wamsang'hanileni fana watumwa. ");
INSERT INTO cwe_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Molondeka mukale nawo fana wasang'hani wa kulihigwa hebu wafosa nzila. Wezamsang'hanilani mbaka mwaka wa kubweleza, ");
INSERT INTO cwe_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","maabaho wezasegela wawo na wanawo na kubwela ukaye yawo, wabwele kuna uuhazi wa tati zawo. ");
INSERT INTO cwe_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kwaviya Waisilaili ni wasang'hani wangu woniwalavile muna iisi ya Misili, sekewachuuzigwe fana watumwa. ");
INSERT INTO cwe_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Sekemuwatawale ndugu zenu Waisilaili chiusede, mbali mumdumbe Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Iviya modaha kuwagula watumwa kulawa mwa nyambenyambe wokala zisi zili habehi yenu. ");
INSERT INTO cwe_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Iviya modaha kuwagula watumwa kulawa kwa nyambenyambe wowokala hamwe na mweye. Wawo wowelekigwe muna iisi yenu wodaha kuwa wenu. ");
INSERT INTO cwe_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Modaha kuwaleka wawe fana uhazi wa wanenu, mwizawatenda kuwa watumwa siku zose. Mbali sekemuwatawale ndugu zenu Waisilaili chiusede. ");
INSERT INTO cwe_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘One nyambenyambe hebu mfosanzila yokala kumwenu kokuwa tajili na ndugu yako Muisilaili kokuwa ngayengaye na kuichuuza kwa nyambenyambe iyo hebu mfosanzila iyo hebu kwa ndugu zawo, ");
INSERT INTO cwe_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","kodaha kukomboligwa yahakomeleza kuichuuza na ndugu yake yoyose kodaha kumkombola. ");
INSERT INTO cwe_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Mtumba wake kodaha kumkombola, hebu mtani wake hebu ndugu wa habehi muna ulukolo lwake. Iviya yeye mwenyewo kodaha kuikombola one yahapata utajili. ");
INSERT INTO cwe_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Yeye hamwe na ija yamgulile, kezapeta miyaka kwandusila viyaichuuze mbaka mwaka wa kubweleza. Bei ya kulekigwa yailegehe izalinganyizigwa na maliho ya usang'hano wake. ");
INSERT INTO cwe_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","One isigala miyaka mingi, kezaliha nyingi kwa ukombola wake. ");
INSERT INTO cwe_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Mbali one isigala miyaka midodo kufika mwaka wa kubweleza, kezaipeta fana viili peta ya miyaka yake, ivo niivo vondayalihe galama ya kukomboligwa kwake. ");
INSERT INTO cwe_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Siku zose msang'hani ziyokala kwa mwenevale wake, kolondeka yatendeligwe fana msang'hani wa kulihigwa chila mwaka. Hamulondeka kumtendela kwa usede. ");
INSERT INTO cwe_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","One munhu iyo hakomboligwe kwa nzila izo, muna umwaka wa kubweleza kolondeka yalekigwe yailegehe, yeye na wanage. ");
INSERT INTO cwe_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Kwaviya Waisilaili ni wasang'hani wangu, woniwalavile muna iisi ya Misili. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Sekemutende nyang'hiti za milungu wa uvwizi, hebu sekemwimize nyang'hiti za kusongola, hebu mhanda, hebu nyang'hiti ya dibwe jojose disongoligwe muna iisi yenu muladi muditambikile. Niye niiyo Mndewa Mulungu, Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Zindilileni Siku zangu za Mhumulo na kuhahishimu hanhu hangu helile, niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘One muhasondelela ndagilizi zangu na kuzindilila malagilizo yangu na kuyatenda, ");
INSERT INTO cwe_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nizamgalilani mvula lusita lufaya muladi isi ipate ndiya nyingi, na mibiki ili muna imigunda izakwima matunda yake. ");
INSERT INTO cwe_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kugobola mhule kwizagendelela mbaka siku ya kwaha zabibu, na kwaha zabibu kwizagendelela mbaka siku ya kuhanda mbeyu. Mwizakuwa na ndiya nyingi na kukala bila kudumba muna iisi yenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Nizamwing'hani tindiwalo muna iisi muladi mudahe kugona bila kudumba chochose. Nizawawinga wanyama wa kumbago muna iisi yenu na isi yenu haizakuwa na ng'hondo. ");
INSERT INTO cwe_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mwizawawinga wehi wenu na kuwakoma kwa panga. ");
INSERT INTO cwe_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Wanhu watano vimwili wezawawinga wanhu gana dimwe na wanhu gana dimwe vimwili wezawawinga wanhu 10,000. Wehi wenu wezadanganika haulongozi wenu kwa panga. ");
INSERT INTO cwe_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nizamtemelani mate na kumwing'hani wana wengi, nizadifikiza lagano dinikile na mweye. ");
INSERT INTO cwe_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Lusita lwa kugobola mwizakuwa mung'hali moja ndiya ya umwaka, kaidi mwizalondeka kusegeza ndiya igonele muladi kupata kwika ndiya imwenga. ");
INSERT INTO cwe_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Niye nizakala mgati yenu, hebu sizamuwingani bule. ");
INSERT INTO cwe_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nizagenda hagati yenu na nizakuwa Mulungu wenu, mweye mwizakuwa wanhu wangu. ");
INSERT INTO cwe_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Niye Mndewa Mulungu, Mulungu wenu, yonimulavileni kuna iisi ya Misili muladi sekemuwe watumwa kaidi. Nimulavani kuna uutumwa na kumtendani muilegehe. ");
INSERT INTO cwe_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘One hamunihulike hebu hamuzindilile malagilizo yangu, ");
INSERT INTO cwe_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","one mwahalema kuzindilila ndagilizi zangu na kuyehila malagilizo yangu, na kulema kuzindilila malagilizo yangu yose, mbali modibena lagano jangu, ");
INSERT INTO cwe_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","nizamtendelani yano. Nizamtowani kwa kumgalilani ludumbo lukulu lwa kusinhukila, utamu wa lunyalanyala, utamu wa kutula yameso na kumtendani mubande. Mwizahanda mbeyu zenu bila kupata chochose, kwaviya wehi wenu wawo wondawaje. ");
INSERT INTO cwe_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Niye nizamulemani, wehi wenu wezamuhumani, mwizatawaligwa na wanhu womwihilani. Mwizadumba na kukimbila hata one habule munhu yoyose yomuwingani. ");
INSERT INTO cwe_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘One mbuli zino zose zihakomelezeka na mung'hali molema kunihulika, nizakongeza nhaguso yenu miyanza saba kwa ichimu cha uhasanyi wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nizabena chibuli chenu, mvula izakuwa kwabule, na isi yenu izakuwa ndala fana zuma na haizakwima ndiya. ");
INSERT INTO cwe_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Na sang'hano zenu zose zizakuwa zabule faida, kwaviya isi haizapata ndiya yoyose hebu mibiki haizakwima matunda yoyose. ");
INSERT INTO cwe_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘One muhawa mung'hali molema kunihulika na monilema, nizakongeza nhaguso yenu miyanza saba kwa wingi wa uhasanyi wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nizamgalilani wanyama wa kumbago, nawo wezawakoma wanenu, wezabananga wanyama wenu wa kufugigwa na wezamuhunguzani, ivo nzila zenu zizakuwa vihame. ");
INSERT INTO cwe_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘One hata ihamala nhaguso ino mung'hali molema kunihulika, mbali moitowa na niye, ");
INSERT INTO cwe_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nizaitowa na mweye na kumtagusani miyanza saba kufosa ichanduso kwa ichimu cha uhasanyi wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nizawagalilani zele dondadilihilize lagano dombenile. One muhakimbilila muna yamabululu yenu, nizamgalilani mitamu ihile na kumgumani muna yamakono ya wehi wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ndiya yenu nizaihunguza mbaka wanaake longo wasang'hanile chivu chimwe muhala koka magate. Wezamgolelani kwa ningo. Hata muhakomeleza kuja mwizakuwa mung'hali na nzala. ");
INSERT INTO cwe_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘One yahakomelezeka yayo yose na mung'hali molema kunihulika, mbali moitowa na niye, ");
INSERT INTO cwe_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","basi nizaitowa na mweye kwa ludoko ng'hani na kumtagusani mweye wose miyanza saba kufosa ichanduso kwa ichimu cha uhasanyi wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mwizakuwa na nzala ng'hani, ivo mwizakuja wanenu wenyewo, wachilume na wachike. ");
INSERT INTO cwe_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nizahabomola hanhu henu ha nhambiko heli kumulima, nizabomola mapango yenu ya kusomela ubani na kwasa mitufi yenu mchanyha ya nyang'hiti zenu za milungu. Nizamwihilani ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mabululu yenu nizayabomola na hanhu henu helile nizahatenda kuwa mahame, na mnung'ho wenu unogile wa nhambiko sizautogola bule. ");
INSERT INTO cwe_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Nizabananga isi yenu, mbaka wehi wenu wohamila uko wezakwazanywa. ");
INSERT INTO cwe_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nizawagalileni ng'hondo na kuwapwililisani muna izisi zimwenga. Isi yenu izakuwa mahame na mabululu yenu yezabanangika. ");
INSERT INTO cwe_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Mweye vondamuwe muna izisi za wehi wenu, isi izadeng'helela siku zake za kuhumula, vondaiwe mahame. Isi izahumula na kudeng'helela. ");
INSERT INTO cwe_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Isi vondaiwe mahame izahumula, mhumulo ija hainalawilila muna zisiku zenu za mhumulo, baho vimukalile muna iisi iyo. ");
INSERT INTO cwe_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Kumwenu wanhu wondawasigale nizawagalila ludumbo muna imizoyo yawo muna izisi za wehi wawo. Yani dihembeluka dizawatenda wakimbile, wezakimbila fana munhu yokimbila ng'hondo. Wezakimbila na kugwa kuno kwabule munhu yowawinga. ");
INSERT INTO cwe_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Wezaigwila fana munhu yokimbila ng'hondo. Wezakimbila na kugwa hata one habule munhu yowawinga. Hamwizakuwa na nguvu yoyose ya kuwatowa wehi wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mwizadanganika kuna izisi zimwenga, mwizameligwa na isi ya wehi wenu. ");
INSERT INTO cwe_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Wanhu wa kumwenu wondawasigale muna izisi za wehi wenu, wezawola na kukomelezeka kwa ichimu cha wihi wawo na kwa ichimu cha wihi wa wasaho zawo. ");
INSERT INTO cwe_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Mbali one wahatogola uhasanyi wawo na uhasanyi wa wasaho zawo wouwatendile wahinduke na kuitowa na niye, ");
INSERT INTO cwe_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","na niye nizaitowa nawo na kuwagala kuna izisi za wehi wawo, mbali one mizoyo yawo midala ihanyendanyenda, nawo watogola kutagusigwa kwa wihi wawo, ");
INSERT INTO cwe_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","nizakumbuka lagano jangu donitendile na Bulahimu na Isaka na Yakobo, kaidi nizakumbuka isi ija. ");
INSERT INTO cwe_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Vondawawe kunze ya isi yawo, isi izadeng'helela siku yake ya mhumulo baho vondaiwe mahame. Lusita ulo wawo watogola kulamuliligwa nhaguso, kwaviya walema ndagilizi zangu na wayehila malagilizo yangu. ");
INSERT INTO cwe_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Mbali hamwe na yayo yose, vondawawe muna iisi ya wehi wawo, niye sizawasa hebu sizawehila mbaka kuwadanganiza kwa kubena lagano jangu hamwe nawo, kwaviya niye niiyo Mndewa Mulungu, Mulungu wawo. ");
INSERT INTO cwe_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Kwa ichimu icho nizakumbuka lagano jangu donikile na wasaho zawo voniwahamize kulawa kuna iisi ya Misili haulongozi ha wanhu wa zisi zose muladi niwe Mulungu wawo, niye niiyo Mndewa Mulungu.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Yayo yose ni malagilizo na ndagilizi za Mndewa Mulungu yoyaweng'hile Waisilaili kuna mulima wa Sinai kufosela Musa. ");
INSERT INTO cwe_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Walongele Waisilaili, ‘One munhu yaheka chilaho kwa Mndewa Mulungu kuilinga na galama ya munhu, munhu iyo kodaha kusegeza chilaho chake kwa kuliha chiyasi cha hela chochilingigwa fana vino, ");
INSERT INTO cwe_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","mulume wa miyaka malongo maidi mbaka malongo sita kezakomboligwa kwa kuliha shekeli malongo matano ya hela kuilinga na ningo ya hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","One yahawa muke, kezakomboligwa kwa kuliha shekeli malongo matatu ya hela. ");
INSERT INTO cwe_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","One munhu iyo yahawa hagati ya miyaka mitano mbaka malongo maidi kezakomboligwa kwa shekeli malongo maidi ya hela one yahawa mulume, na one yahawa muke kezakomboligwa kwa shekeli longo ya hela. ");
INSERT INTO cwe_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","One yahawa mwana hagati ya mwezi umwe mbaka miyaka mitano, one yahawa mwana wa chilume kezakomboligwa kwa kuliha shekeli tano ya hela, one yahawa mwana wa chike kezakomboligwa kwa kuliha shekeli nhatu ya hela. ");
INSERT INTO cwe_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","One munhu iyo yahawa na miyaka malongo sita na kugendelela, one yahawa mulume kezakomboligwa kwa kuliha shekeli longo na tano ya hela, one yahawa muke kezakomboligwa kwa kuliha shekeli longo ya hela. ");
INSERT INTO cwe_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“ ‘Mbali one munhu iyo yahawa ngayengaye na hadaha kuliha hela ya kuikombola mwenyewo, munhu iyo kezagaligwa kwa mkulu wa nhambiko. Mkulu wa nhambiko kezamulola goya va kuguligwa kwake kuilinga na viyodaha ija yekile chilaho. ");
INSERT INTO cwe_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘One chilaho ni mnyama kulawa muna iwanyama woyolaviligwa nhambiko Mndewa Mulungu, chochose chilavigwa kwa Mndewa Mulungu chela. ");
INSERT INTO cwe_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Haitogoliligwa kwasakanya mnyama iyo na mnyama imwenga yoyose, yanogile kwa yehile hebu yehile kwa yanogile. One yahamwasakanya kwa mnyama imwenga, wose waidi wezakuwa wela. ");
INSERT INTO cwe_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","One yahawa mnyama yambule mwiko hafaya kumulava nhambiko kwa Mndewa Mulungu, munhu iyo yamulavile kezamgala kwa mkulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Mkulu wa nhambiko kezalamula bei yake kuilinga na unovu wake hebu wihi wake. Vondayalamule mkulu wa nhambiko niivo vondaiwe. ");
INSERT INTO cwe_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mbali one mwenyewo yahalonda kumkombola mnyama wake, kolondeka yongeze hanhu ha tano ha bei yake. ");
INSERT INTO cwe_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","One munhu yahaika kaye yake kwa Mndewa Mulungu kwa sang'hano yelile, mkulu wa nhambiko kezalamula bei yake kwa kuilinga na unovu wake hebu wihi wake. Vondayalamule mkulu wa nhambiko niivo vondaiwe. ");
INSERT INTO cwe_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","One munhu yahaika kaye yake kwa sang'hano yelile, kolonda kuikombola kwa kongeza hanhu ha tano, nayo izakuwa yake. ");
INSERT INTO cwe_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘One munhu yahaika kwa sang'hano yelile isi yake ili uhazi wake, bei yake izalingigwa kuilinga na bei ya mbeyu zihandigwe muna umgunda uwo, chila chilo magana maidi na malongo maidi za mhule bei yake izakuwa shekeli malongo matano ya hela. ");
INSERT INTO cwe_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","One yahawika mgunda wake kwa sang'hano yelile muna umwaka wa kubweleza, bei yake yolondeka iwe fana ipangigwe. ");
INSERT INTO cwe_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mbali one yahawika mgunda wake kwa sang'hano yelile uhamala mwaka uwo, mkulu wa nhambiko kezalamula miyaka yake kuilinga na miyaka isigale kufika mwaka wa kubweleza, na bei yake ihunguzigwe. ");
INSERT INTO cwe_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","One munhu ija yekile mgunda wake kwa sang'hano yelile yahalonda kuukombola, kolondeka yalihe na yongezele hanhu ha tano ha bei ya mgunda uwo, maabaho wizakuwa wake. ");
INSERT INTO cwe_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Mbali one halonda kuukombola mgunda hebu kamchuuziya munhu imwenga, basi mgunda uwo sekeukomboligwe kaidi. ");
INSERT INTO cwe_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Mgunda uwo wizakuwa wela kwa Mndewa Mulungu vondaumale mwaka wa kubweleza, one ihawa mgunda wikigwa kwa sang'hano yelile, wizakuwa wa wakulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Mbali munhu yahawika kwa sang'hano yelile mgunda uyagulile, wili siyo wake wa uhazi, ");
INSERT INTO cwe_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","mkulu wa nhambiko kezalamula bei ya mgunda uwo kuilinga na miyaka isigale mbaka kufika mwaka wa kubweleza, munhu iyo kezalondeka kuliha bei yake siku ija fana chinhu chelile kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Muna umwaka wa kubweleza, mgunda uwo wolondeka ubwelezigwe kwa munhu yachuuzile hebu welesi wake. ");
INSERT INTO cwe_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“ ‘Chila hela izalingigwa kwa ningo ya hema da Mulungu, yondaigoligwe kwa ningo ya vihande malongo maidi. ");
INSERT INTO cwe_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Haitogoligwa kumwika kwa sang'hano yelile mwana wa udele wa wanyama, kwaviya kawa wa Mndewa Mulungu kamala, yawe ng'ombe hebu ng'hondolo, ni wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","One yahawa mnyama yambule mwiko, mwenyewo kezamgula kuilinga na viya vimumulinga na kezakongeza hanhu ha tano ha bei ya mnyama iyo. One hakomboligwe, basi kezachuuzigwa kuilinga na viipangigwe. ");
INSERT INTO cwe_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Chinhu chochose chochilavigwa kwa Mndewa Mulungu, iwe munhu hebu mnyama hebu chinhu chipatike kwa uhazi, hachizachuuzigwa hebu kukomboligwa. Chinhu chochose chilavigwe kwa Mndewa Mulungu chela ng'hani. ");
INSERT INTO cwe_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Munhu yoyose yahekigwa kwa kukomigwa, sekeyakomboligwe mbali kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Chinhu chimwe muna ivinhu longo va vinhu viugobole ni va Mndewa Mulungu, iwe mhule hebu matunda ya mibiki, vela kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","One munhu yahalonda kukombola chinhu chochose muna ivinhu vino, kolondeka yalihe bei yake na yongezele hanhu ha tano ha bei yake. ");
INSERT INTO cwe_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kusonhela ng'ombe na ng'hondolo, chila mnyama wa longo muna yamabumbila yake kela kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Munhu yoyose halondeka kuuza mnyama iyo kanoga hebu keha hebu mnyama iyo hezakwasakanyigwa na imwenga, mbali wahayasakanya wanyama, wose waidi wezakuwa wela, hawezakomboligwa.’ ” ");
INSERT INTO cwe_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Yano yayo malagilizo yaja Mndewa Mulungu kamwing'ha Musa kuna mulima wa Sinai kwa ichimu cha Waisilaili.");
INSERT INTO cwe_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Mndewa Mulungu kamulongela Musa kuna ichuwala cha Sinai, muna dihema da Mulungu, siku ya mwanduso ya mwezi wekaidi wa mwaka wekaidi viwamalile kulawa muna iisi ya Misili. Kalonga, ");
INSERT INTO cwe_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Wapeteni Waisilaili, kwa kusondelela ng'holo zawo na kaye zawo, peteni kwa kusondelela mazina ya walume, imwe imwe, ");
INSERT INTO cwe_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","waja wodaha kuitowa kuna ing'hondo, kwandusila weli na miyaka malongo maidi na kugendelela, weye na Haluni mwizayandika mazina yawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Na mulume imwe kulawa chila kabila kezakuwa hamwe na mweye, chila munhu yeli mulangulizi wa kaye ya tati yake. ");
INSERT INTO cwe_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Yano yayo mazina ya walume wondawakutaze, kulawa kabila da Lubeni, Elisuli mwana wa Shedueli, ");
INSERT INTO cwe_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","kulawa kabila da Simeoni, Shelumieli mwana wa Sulishadai, ");
INSERT INTO cwe_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","kulawa kabila da Yuda, Nashoni mwana wa Aminadabu, ");
INSERT INTO cwe_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","kulawa kabila da Isakali, Nasanaeli mwana wa Suali, ");
INSERT INTO cwe_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","kulawa kabila da Zabuloni, Eliabu mwana wa Heloni, ");
INSERT INTO cwe_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","kulawa muna yamakabila ya wana wa Yosefu, kabila da Efulaimu, Elishama mwana wa Amihudi, kabila da Manase, Gamalieli mwana wa Pedasuli, ");
INSERT INTO cwe_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","kulawa kabila da Benjamini, Abidani mwana wa Gidioni, ");
INSERT INTO cwe_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","kulawa kabila da Dani, Ahiezeli mwana Amishadai, ");
INSERT INTO cwe_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","kulawa kabila da Asheli, Pagieli mwana wa Okilani, ");
INSERT INTO cwe_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","kulawa kabila da Gadi, Eliasafu mwana wa Deueli, ");
INSERT INTO cwe_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","kulawa kabila da Nafutali, Ahila mwana wa Enani.” ");
INSERT INTO cwe_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Wawo niiyo wasaguligwe kulawa hana umting'hano, walangulizi wa makabila ya tati zawo, walangulizi wa ng'holo za Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa na Haluni wawasola walume wano wowatambuligwe mazina yawo, ");
INSERT INTO cwe_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","na wawatanga hamwe wanhu wose, siku ya mwanduso ya mwezi wekaidi, nawo walume wapetigwa kulawa muna zing'holo za wasaho zawo, kwa kaye za tati zawo, fana viili peta ya mazina, kwandusila weli na miyaka malongo maidi na kugendelela, imwe imwe, ");
INSERT INTO cwe_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","fana Mndewa Mulungu viyamulagilize Musa. Ivo kawapeta kuna ichuwala cha Sinai. ");
INSERT INTO cwe_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Wanhu wa kabila da Lubeni mwana wa udele wa Isilaili, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuhita kuitowa kuna ing'hondo, wapetigwa kwa mazina, imwe imwe, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Waja wa kabila da Lubeni wapetigwe wakala 46,500. ");
INSERT INTO cwe_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Wanhu wa kabila da Simeoni, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, imwe imwe, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Waja wa kabila da Simeoni wapetigwe wakala 59,300. ");
INSERT INTO cwe_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Wanhu wa kabila da Gadi, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Waja wa kabila da Gadi wapetigwe wakala 45,650. ");
INSERT INTO cwe_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Wanhu wa kabila da Yuda, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Waja wa kabila da Yuda wapetigwe wakala 74,600. ");
INSERT INTO cwe_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Wanhu wa kabila da Isakali, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Waja wa kabila da Isakali wapetigwe wakala 54,400. ");
INSERT INTO cwe_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Wanhu wa kabila da Zabuloni, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Waja wa kabila da Zabuloni wapetigwe wakala 57,400. ");
INSERT INTO cwe_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Wanhu wa kabila da Efulaimu, mwana wa Yosefu, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Waja wa kabila da Efulaimu wapetigwe wakala 40,500. ");
INSERT INTO cwe_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Wanhu wa kabila da Manase, mwana wa Yosefu, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Waja wa kabila da Manase wapetigwe wakala 32,200. ");
INSERT INTO cwe_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Wanhu wa kabila da Benjamini, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Waja wa kabila da Benjamini wapetigwe wakala 35,400. ");
INSERT INTO cwe_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Wanhu wa kabila da Dani, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Waja wa kabila da Dani wapetigwe wakala 62,700. ");
INSERT INTO cwe_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Wanhu wa kabila da Asheli, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Waja wa kabila da Asheli wapetigwe wakala 41,500. ");
INSERT INTO cwe_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Wanhu wa kabila da Nafutali, walume wose weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, wapetigwa kwa mazina, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Waja wa kabila da Nafutali wapetigwe wakala 53,400. ");
INSERT INTO cwe_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Wawo niiyo walume wapetigwe, waja Musa na Haluni wawapeta kwa kutazigwa na waja walangulizi wa Isilaili longo na waidi, chila imwe kwa ichimu cha kaye ya tati yake. ");
INSERT INTO cwe_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ivo walume wose wa Isilaili wapetigwa, weli na miyaka malongo maidi na kugendelela wowadahile kuitowa kuna ing'hondo, kwa kusondelela ng'holo zawo na kaye zawo. ");
INSERT INTO cwe_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Walume wose wapetigwe wakala 603,550. ");
INSERT INTO cwe_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mbali Walawi hawapetigwe hamwe na yaja yamakabila yamwenga, ");
INSERT INTO cwe_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","kwaviya Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Leka kabila da Lawi, sekeuwapete hamwe na Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Mbali uwasagule Walawi wawe ndolezi wa hema da Mulungu da ukalangama na via vake vose na chila chinhu chili umo, wezadipapa hamwe na via vake vose. Wezasang'hana umo na kwika malago yawo kwa kudizunguluka hema ijo. ");
INSERT INTO cwe_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Hema vondadisegezigwe, Walawi wezadisegeza, vondadisimikigwe, Walawi wezadisimika. Munhu yoyose yeli siyo Mulawi yahadikwenhukila kezakomigwa. ");
INSERT INTO cwe_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Waisilaili wamwenga wose wezakwika malago yawo kwa mabumbila mabumbila, chila munhu muna dibumbila jake na hasi ya bendela yake. ");
INSERT INTO cwe_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mbali Walawi wezakwika malago yawo kudizunguluka hema da Mulungu da ukalangama banzi zose, muladi sekekuwe na ludoko kwa Waisilaili, maabaho Walawi wasang'hanile muna dihema da Mulungu da ukalangama.” ");
INSERT INTO cwe_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Vino niivo viwatendile Waisilaili. Watenda chila chinhu fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Mndewa Mulungu kawalongela Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Waisilaili wezakwika malago yawo, chila munhu hana ibendela yake, hana ichilaguso cha kaye ya tati yake. Wezakwika malago yawo kudizunguluka dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Wanhu wondaweke malago yawo ubanzi wa ulawilo wa zuwa wezakuwa hana ibendela ya Yuda. Mulangulizi wawo kakala Nashoni mwana wa Aminadabu, ");
INSERT INTO cwe_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Peta ya bumbila jake wakala walume 74,600. ");
INSERT INTO cwe_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Kabila da Isakali wezakwika lago habehi na kabila da Yuda, mulangulizi wawo kakala Nasanaeli mwana wa Suali. ");
INSERT INTO cwe_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Peta ya bumbila jake wakala walume 54,400. ");
INSERT INTO cwe_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Maabaho kabila da Zebuloni, mulangulizi wa kabila da Zabuloni kakala Eliabu mwana wa Heloni. ");
INSERT INTO cwe_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Peta ya bumbila jake wakala walume 57,400. ");
INSERT INTO cwe_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Wanhu wose wakalile muna dilago da kabila da Yuda kwa kusondelela mabumbila yawo wakala walume 186,400. Wawo niiwawo wondawalongole. ");
INSERT INTO cwe_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“Ubanzi wa kusi kwizakuwa na lago da wanhu wa kabila da Lubeni kwa kusondelela mabumbila yawo. Mulangulizi wawo kakala Elisuli mwana wa Shedueli. ");
INSERT INTO cwe_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Peta yawo wakala walume 46,500. ");
INSERT INTO cwe_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Na wanhu wondaweke lago habehi nayo ni kabila da Simeoni. Mulangulizi wa kabila da Simeoni kakala Shelumieli mwana wa Sulishadai, ");
INSERT INTO cwe_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Peta yawo wakala walume 59,300. ");
INSERT INTO cwe_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Kabila da Gadi wezasondelela. Mulangulizi wa kabila da Gadi kakala Eliasafu mwana wa Leueli. ");
INSERT INTO cwe_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Peta yawo wakala walume 45,650. ");
INSERT INTO cwe_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Walume wose wapetigwe muna dilago da Lubeni wakala 151,450. Wano wawo wondawawe muna dibumbila dekaidi. ");
INSERT INTO cwe_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Maabaho hema da Mulungu dizasegela hamwe na lago da Walawi hagati ya malago yose, fana viwopanga malago. Wezahita ivo ivo, chila bumbila hanhu hake heli na bendela zake. ");
INSERT INTO cwe_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“Ubanzi wa uswelo wa zuwa kwizakuwa na bendela ya lago da wanhu wa kabila da Efulaimu. Mulangulizi wa kabila da Efulaimu kakala Elishama mwana wa Amihudi. ");
INSERT INTO cwe_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Peta ya bumbila jake wakala walume 40,500. ");
INSERT INTO cwe_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Kabila da Manase dizasondelela, mulangulizi wa kabila da Manase kakala Gamalieli mwana wa Pedasuli. ");
INSERT INTO cwe_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Peta yawo wakala walume 32,200. ");
INSERT INTO cwe_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Maabaho kabila da Benjamini dizasondelela, mulangulizi wa kabila da Benjamini kakala Abidani mwana wa Gideoni. ");
INSERT INTO cwe_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Peta yawo wakala walume 35,400. ");
INSERT INTO cwe_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Wanhu wose wakalile muna dilago da wanhu wa Efulaimu kwa kusondelela mabumbila yawo wakala 108,100. Bumbila dino da wanhu wa Efulaimu dizakuwa deketatu kusegela. ");
INSERT INTO cwe_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“Ubanzi wa kasikazi kwizakuwa na bendela ya kabila da Dani, wezakwika malago yawo muna yamabumbila yawo hasi ya bendela. Mulangulizi wa kabila da Dani kakala Ahiezeli mwana wa Amishadai. ");
INSERT INTO cwe_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Peta yawo wakala walume 62,700. ");
INSERT INTO cwe_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Kabila da Asheli dizasondelela. Mulangulizi wa kabila da Asheli kakala Pagieli mwana wa Okilani. ");
INSERT INTO cwe_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Peta yawo wakala walume 41,500. ");
INSERT INTO cwe_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Maabaho dizasondelela kabila da Nafutali. Mulangulizi wa kabila da Nafutali kakala Ahila mwana wa Enani. ");
INSERT INTO cwe_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Peta yawo wakala walume 53,400. ");
INSERT INTO cwe_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Walume wose wapetigwe muna dilago da Dani wakala 157,600. Wawo wezakomeleza kusegela kwa kusondelela bendela yawo.” ");
INSERT INTO cwe_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Wawo niiwawo Waisilaili wapetigwe kwa kusondelela kaye za tati zawo muna yamalago kwa mabumbila yawo, wose wakala walume 603,550. ");
INSERT INTO cwe_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mbali Walawi hawapetigwe mwa Waisilaili fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ivo Waisilaili watenda chila chinhu fana Mndewa Mulungu viyamulagilize Musa. Niivo viwekile malago yawo kwa kusondelela bendela zawo, na niivo viwasegele chila munhu kwa kusondelela lukolo lwake, fana viili kaye ya tati yake. ");
INSERT INTO cwe_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Wano ni welesi wa Haluni na Musa chipindi Mndewa Mulungu viyalongile na Musa kuna umulima wa Sinai. ");
INSERT INTO cwe_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Yano ni mazina ya wana wa chilume wa Haluni. Nadabu chaudele na Abihu, na Eleazali na Isamali. ");
INSERT INTO cwe_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Yayo ni mazina ya wana wa chilume wa Haluni, wakulu wa nhambiko wowahakigwe mavuta na wowekigwe kwa sang'hano yelile muladi wasang'hane sang'hano ya ukulu wa nhambiko. ");
INSERT INTO cwe_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Mbali Nadabu na Abihu wadanganika haulongozi ha Mndewa Mulungu, viwamulavile Mndewa Mulungu nhambiko ya moto haulondeka kuna ichuwala cha Sinai. Wawo hawawile na wana, ivo Eleazali na Isamali wasang'hana fana wakulu wa nhambiko chipindi cha ugima wa Haluni tati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Wakwenhuse habehi wanhu wa kabila da Lawi na uweke haulongozi ha mkulu wa nhambiko Haluni muladi wamsang'hanile. ");
INSERT INTO cwe_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Wezawasang'hanila Haluni na mting'hano wose muna dihema da Mulungu kwa kusang'hana sang'hano za hanhu helile. ");
INSERT INTO cwe_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Wezavikaliza via vose vili muna dihema da Mulungu na kuwataza Waisilaili kwa kusang'hana sang'hano ya hanhu helile. ");
INSERT INTO cwe_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Haluni na wanage wezakwing'higwa Walawi, wawo walavigwa mwa Waisilaili muladi wawasang'hanile. ");
INSERT INTO cwe_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Uweke Haluni na wanage wa chilume kusang'hana fana wakulu wa nhambiko, munhu imwenga yoyose yahageza kusang'hana sang'hano ya ukulu wa nhambiko, kezakomigwa.” ");
INSERT INTO cwe_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Lola sambi niwasagula Walawi mwa Waisilaili wose, badala ya chila mwana wa udele wa chilume wa chila lukolo lwa Isilaili. Walawi ni wangu, ");
INSERT INTO cwe_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","mana wana wa udele wose ni wangu. Viniwakomile wana wa udele kuna iisi ya Misili, nika hakwe chila mwana wa udele muna iisi ya Isilaili. Chila mwana wa udele wa munhu hebu wa mnyama, wawo wezakuwa wangu. Niye niiyo Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Mndewa Mulungu kamulongela Musa kuna ichuwala cha Sinai, ");
INSERT INTO cwe_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Wapete Walawi kwa kusondelela ng'holo zawo na kaye zawo. Wapete walume wose kwandusila wana weli na mwezi umwe na kugendelela.” ");
INSERT INTO cwe_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ivo Musa kawapeta, fana viyalagilizigwe na mbuli ya Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Yano yakala mazina ya wana wa chilume wa Lawi, Gelishoni na Kohasi na Melali. ");
INSERT INTO cwe_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Yano yakala mazina ya wana wa chilume wa Gelishoni kwa kusondelela ng'holo zawo, Libini na Shimei. ");
INSERT INTO cwe_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Wana wa chilume wa Kohasi kwa kusondelela ng'holo zawo, Amilamu na Ishali na Hebuloni na Uzieli. ");
INSERT INTO cwe_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Na wana wa chilume wa Melali kwa kusondelela ng'holo zawo, Mahili na Mushi. Wano wakala welesi wa Lawi kwa kusondelela ng'holo zawo. ");
INSERT INTO cwe_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ng'holo za Walibini na Washimei zilawa kwa Gelishoni. ");
INSERT INTO cwe_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Peta ya walume wose kwandusila wana weli na mwezi umwe na kugendelela wakala 7,500. ");
INSERT INTO cwe_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ng'holo za Wagelishoni weka lago jawo ubanzi wa ulawilo wa zuwa wa hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Mulangulizi wa ng'holo za Wagelishoni kakala Eliasafu mwana wa Laeli. ");
INSERT INTO cwe_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Sang'hano ya Wagelishoni ikala kukaliza hema da Mulungu na ngubiko yake na panzia da hanhu ha kwingilila muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","na mapanzia ya luwa luzunguluka hema da Mulungu na lupango, na panzia da hanhu ha kwingilila muna uluwa na nzabi zake. Sang'hano zawo zikala zosonhela vinhu ivo vose. ");
INSERT INTO cwe_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ng'holo za Kohasi zikala Waamulami na Waishali na Wahebuloni na Wauzieli. ");
INSERT INTO cwe_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Peta ya walume wose kwandusila wana weli na mwezi umwe na kugendelela wakala 8,600. Wano wakala wokaliza hanhu helile. ");
INSERT INTO cwe_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ng'holo za Kohasi walondeka kwika lago jawo ubanzi wa kusi wa hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Mulangulizi wa ng'holo za Kohasi kakala Elisafani mwana wa Uzieli. ");
INSERT INTO cwe_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Wakala wodilola goya sanduku da lagano na meza na chinala cha chitasa na malupango na via viwosang'hanila wakulu wa nhambiko hana ihanhu helile na panzia, na via vose va kusang'hanila. ");
INSERT INTO cwe_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleazali mwana wa Haluni yeli mkulu wa nhambiko kakala mulangulizi wa walangulizi wa Walawi, ndolezi wa wasang'hani wose wa hanhu helile. ");
INSERT INTO cwe_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ng'holo mbili za Melali zikala Wamahili na Wamushi. ");
INSERT INTO cwe_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Peta ya walume wowandikigwe kwandusila wana weli na mwezi umwe na kugendelela wakala 6,200. ");
INSERT INTO cwe_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mulangulizi wa ng'holo za Melali kakala Sulieli mwana wa Abihaili, wano walondeka kwika lago jawo ubanzi wa kasikazi wa hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Wamelali wasaguligwa kulola goya mibiki ya hema na mhanda zake na vikalilo vake na via vake vose na sang'hano yoyose kusonhela vinhu ivo, ");
INSERT INTO cwe_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","na mhanda zizunguluke uluwa na vikalilo vake na vigingi vake na nzabi zake. ");
INSERT INTO cwe_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa na Haluni na wana wawo wa chilume walondeka kwika lago jawo kuulongozi wa hema da Mulungu ubanzi wa ulawilo wa zuwa. Sang'hano yawo ikala kusang'hana sang'hano ya ukulu wa nhambiko muna dihema da Mulungu kwa ichimu cha Waisilaili. Munhu imwenga yoyose yahadikwenhukila dihema da Mulungu kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Walawi wose wapetigwe, walume wose kwandusila wana weli na mwezi umwe na kugendelela, waja Musa na Haluni wawapeta fana viyalagilize Mndewa Mulungu, wakala 22,000. ");
INSERT INTO cwe_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Maabaho Mndewa Mulungu kamulongela Musa, “Wapete wana wa udele wa chilume wose wa Waisilaili, kwandusila wana weli na mwezi umwe na kugendelela, wapete kwa mazina yawo. ");
INSERT INTO cwe_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Kwizaweka hakwe Walawi kwa ichimu changu niye Mndewa Mulungu badala ya wana wa udele wa Waisilaili, iviya kwizaweka hakwe wanyama wose wa Walawi kwa ichimu changu badala ya wanyama wa udele wose wa Waisilaili.” ");
INSERT INTO cwe_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ivo Musa kawapeta wana wa udele wose wa Waisilaili, fana Mndewa Mulungu viyamulagilize. ");
INSERT INTO cwe_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Wana wa udele wose wa chilume fana viili peta ya mazina yawo, kwandusila wana weli na mwezi umwe na kugendelela wakala 22,273. ");
INSERT INTO cwe_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Wabagule Walawi wose kuwa wangu badala ya wana wa udele wa Waisilaili. Iviya wabagule ng'ombe wa Walawi wose badala ya wana wa udele wa ng'ombe wa Waisilaili. Walawi ni wangu. Niye niiyo Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Kwa ichimu cha kuwakombola wana wa udele wa chilume wa Waisilaili 273, wongezeke muna ipeta ya walume wa Walawi. ");
INSERT INTO cwe_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Hokela shekeli tano ya hela kulawa kwa waudele wa Waisilaili wowongezeke kulawa kwa peta ya walume wa Walawi, fana viili ningo ya hanhu helile, ");
INSERT INTO cwe_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","mwing'he Haluni na wanage hela ya ukombola kwa ichimu cha Waisilaili wongezeke muna ipeta.” ");
INSERT INTO cwe_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Musa kasola hela izo za ukombola wawo wongezeke wakomboligwe na Walawi. ");
INSERT INTO cwe_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Kulawa kwa wana wa udele wa Waisilaili kapata shekeli 1,365 ya hela, fana viili ningo ya hanhu helile. ");
INSERT INTO cwe_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa kaweng'ha Haluni na wanage hela izo za ukombola, fana mbuli ya Mndewa Mulungu voimulagilize. ");
INSERT INTO cwe_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mndewa Mulungu kawalongela Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Wapete welesi wa Kohasi, kulawa kabila da Walawi, kwa kusondelela ng'holo zawo na kaye za tati zawo. ");
INSERT INTO cwe_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Kwandusila walume weli na miyaka malongo matatu mbaka malongo matano, wowodaha kwingila muna isang'hano muladi wasang'hane hana dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Sang'hano ya Wakohasi ikala kupapa via velile va hema da Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“Lusita lwa kusegeza dilago, Haluni na wanage wa chilume wezakwingila mgati na kudihulumusa dipanzia dili haulongozi wa sanduku da lagano na kudigubika sanduku da lagano kwa panzia ijo. ");
INSERT INTO cwe_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Uchanyha yake wezakwika mbende ya mnyama wa mwiibahali, wezakwika chitambala cha langi ya buluu. Maabaho wezakwingiza mibiki ya kupapila sanduku da lagano. ");
INSERT INTO cwe_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Uchanyha ya meza ya kulavila magate yelile yoyokwikigwa haulongozi wa Mndewa Mulungu, wezakwanzanza chitambala cha langi ya buluu chiya uchanyha yake wezakwika vyano na vitanda va ubani na nhungo, kwa ichimu cha kulavila nhambiko za ving'waji. Uchanyha ya meza kwizakuwa na magate siku zose. ");
INSERT INTO cwe_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Wezagubika vinhu ivo vose kwa chitambala chidung'hu, na uchanyha yake wezagubika kwa mbende ya mnyama wa mwiibahali na kuiguma ija imibiki yake. ");
INSERT INTO cwe_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Wezasola chitambala cha langi ya buluu na kugubika chinala cha vitasa na vitasa vake na mibato yake na vyano vake na via vake vovisang'haniligwa kwikila mavuta. ");
INSERT INTO cwe_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Wezachiguma na via vake vose mgati ya mbende ya mnyama wa mwiibahali na kuchika uchanyha ya mibiki ya kupapila. ");
INSERT INTO cwe_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Uchanyha ya lupango lwa zahabu wezagubika chitambala cha langi ya buluu na kugubika kwa mbende ya mnyama wa mwiibahali. Wezaguma mibiki yake ya kupapila. ");
INSERT INTO cwe_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Maabaho wezavisola via vose vovisang'haniligwa muna ikaye yelile, na kuviguma muna ichitambala cha langi ya buluu na kugubika kwa mbende ya mnyama wa mwiibahali na kuvika mchanyha ya mibiki ya kupapila. ");
INSERT INTO cwe_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Wezasegeza maivu hana ulupango lwa kutimbulila nhambiko na kulugubika kwa chitambala cha langi ya zambalau. ");
INSERT INTO cwe_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Wezavika mchanyha yake via vose vovisang'haniligwa hana ulupango, hamwe na vyano va kuhalila moto na mibatilo na magembe na vizae. Maabaho uchanyha yake wezakwika ngubiko ya mbende ya mnyama wa mwiibahali na kuiguma mibiki yake ya kupapila. ");
INSERT INTO cwe_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Haluni na wanage wahakomeleza kuhagubika hanhu helile hamwe na via vake vose, wahawa waisasala kwandusa mwanza, wanhu wa lukolo lwa Kohasi wezakwiza na kuvipapa. Wawo hawalondeka kwamha via ivo velile, buleivo wezadanganika. Iyo niiyo sang'hano ya wanhu wa lukolo lwa Kohasi chila lusita hema da Mulungu vidihamizigwa. ");
INSERT INTO cwe_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazali mwana wa mkulu wa nhambiko Haluni kezayeka goya mavuta ya vitasa na ubani unogile na nhosa za usage za chila siku na mavuta ya kuboboda. Iviya kezakaliza hema da Mulungu na vinhu vose vili mgati yake na hanhu helile na via vake.” ");
INSERT INTO cwe_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Mndewa Mulungu kawalongela Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Sekemuwaleke wanhu wa lukolo lwa Kohasi mwa Walawi wadanganizigwe, ");
INSERT INTO cwe_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","mbali watendeleni vino muladi vondawavikwenhukile vinhu velile ng'hani wawe wagima na sekewadanganike. Haluni na wanage wezakwingila mgati na kumsagula chila munhu na sang'hano yake na mbahasha yake. ");
INSERT INTO cwe_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Mbali sekewengile hanhu haja kulola vinhu velile lusita wakulu wa nhambiko wovisasala, buleivo wezadanganika.” ");
INSERT INTO cwe_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Wapete welesi wa Gelishoni kwa kusondelela ng'holo zawo na kaye za tati zawo. ");
INSERT INTO cwe_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Wapete walume kwandusila weli na miyaka malongo matatu mbaka weli na miyaka malongo matano wowodaha kusang'hana sang'hano muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Sang'hano ya Wagelishoni ni kupapa mbahasha. ");
INSERT INTO cwe_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Wezasola mapanzia na hema da Mulungu hamwe na ngubiko yake na ngubiko ya mbende ya mnyama wa mwiibahali uchanyha yake na mapanzia ya hanhu ha kwingilila muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","na mapanzia ya luwa luzunguluke hanhu helile na lupango, na panzia da hanhu ha kwingilila muna dihema da Mulungu na nzabi zake na vinhu vose va usang'hano wawo. Wawo wezasang'hanila mbuli zose zozisonhela vinhu vino. ");
INSERT INTO cwe_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Sang'hano yose ya wana wa chilume wa Wagelishoni kwa kupapa mbahasha na sang'hano yawo yose izakuwa kwa kulangulizigwa na Haluni na wanage. Wezawapangila vinhu vose vowolongeligwa kuvipapa. ");
INSERT INTO cwe_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ino iyo sang'hano ya Wagelishoni hana dihema da Mulungu. Wezasang'hana kwa kulangulizigwa na Isamali mwana wa mkulu wa nhambiko Haluni. ");
INSERT INTO cwe_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Wapete welesi wa Melali kwa kusondelela ng'holo zawo na kaye za tati zawo. ");
INSERT INTO cwe_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Wapete walume wose kwandusila weli na miyaka malongo matatu mbaka weli na miyaka malongo matano, wowodaha kusang'hana usang'hano hana dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Wezalondeka kupapa mibiki, mhanda na vikalilo va hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","“Iviya na mhanda za luwa kuzunguluka banzi zose za hanhu helile na vikalilo na vigingi na nzabi zake hamwe na vinhu vake vose na via vake vimwenga vose. Kwizawapangila kwa kusondelela mazina yawo vinhu vowolondeka kupapa. ");
INSERT INTO cwe_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ino iyo yondaiwe sang'hano ya Wamelali hana dihema da Mulungu, wezalangulizigwa na Isamali mwana wa mkulu wa nhambiko Haluni.” ");
INSERT INTO cwe_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa na Haluni na walangulizi wa mting'hano wose wawapeta welesi wa Kohasi, kwa kusondelela ng'holo zawo na kaye za tati zawo. ");
INSERT INTO cwe_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Walume wose kwandusila weli na miyaka malongo matatu mbaka weli na miyaka malongo matano, wowodaha kusang'hana muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","wowapetigwe kwa kusondelela ng'holo zawo wakala 2,750. ");
INSERT INTO cwe_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ino ikala peta ya welesi wa Wakohasi wowasang'hane usang'hano muna dihema da Mulungu. Musa na Haluni wawapeta fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Wagelishoni wapetigwa kwa kusondelela ng'holo zawo na kaye za tati zawo. ");
INSERT INTO cwe_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Walume wose kwandusila weli na miyaka malongo matatu mbaka weli na miyaka malongo matano, wowodaha kusang'hana usang'hano muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","wowapetigwe kwa kusondelela ng'holo zawo na kaye za tati zawo wakala 2,630. ");
INSERT INTO cwe_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ino ikala peta ya welesi wa Wagelishoni wowasang'hane usang'hano muna dihema da Mulungu, waja Musa na Haluni wawapeta fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Wamelali wapetigwa kwa kusondelela ng'holo zawo na kaye za tati zawo. ");
INSERT INTO cwe_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Walume wose kwandusila weli na miyaka malongo matatu mbaka weli na miyaka malongo matano, wowodaha kusang'hana usang'hano muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","wapetigwa kwa kusondelela ng'holo zawo na kaye za tati zawo, wakala 3,200. ");
INSERT INTO cwe_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ino ikala peta ya welesi wa Wamelali, waja Musa na Haluni wawapeta fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ivo Musa na Haluni na walangulizi wa Isilaili wawapeta Walawi wose kwa kusondelela ng'holo zawo na kaye za tati zawo. ");
INSERT INTO cwe_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Walume wose kwandusila weli na miyaka malongo matatu mbaka weli na miyaka malongo matano, wowodaha kusang'hana usang'hano muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","wapetigwe wakala 8,580. ");
INSERT INTO cwe_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kwa lagilizo da Mndewa Mulungu kufosela Musa, wapetigwa, chila munhu kwa sang'hano yake na fana voili mbahasha yake, niivo viwapetigwe fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Walagilize Waisilaili wamulave kunze ya lago chila munhu yeli na utamu wa mbende, chila munhu yolawigwa na ufila na chila munhu yambule mwiko kwa kudalisa mtufi. ");
INSERT INTO cwe_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Walaveni kunze ya lago wanhu wawo wose, wawe walume hebu wanaake, muladi sekewaditende lago jangu donikala hagati yawo jambule mwiko.” ");
INSERT INTO cwe_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Waisilaili watenda ivo, wawalava kunze ya lago. Watenda fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Walongele Waisilaili, ‘One munhu yoyose, mulume hebu muke yahamuhasanya miyage kwa vovose na ivo kuleka kuwa mwaminika kwa Mndewa Mulungu, munhu iyo kabananga, ");
INSERT INTO cwe_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","baho kolondeka yalonge kwa mulomo uhasanyi wake uyatendile. Kolondeka yalihe kwa ubananzi wake kwa kongeza hanhu ha tano na kumwing'ha ija yamuhasanye. ");
INSERT INTO cwe_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mbali one munhu yahasanyigwe kadanganika na kabule ndugu wa habehi yoyodaha kuhokela chinhu icho, basi maliho kwa ubananzi yezalavigwa kwa Mndewa Mulungu kwa ichimu cha wakulu wa nhambiko. Maliho yayo yezalavigwa hamwe na bebelu da ng'hondolo da kuilumba dondadisang'haniligwe kutendeligwa kuilumba kwa ichimu cha uhasanyi wake. ");
INSERT INTO cwe_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Chila nhosa ya vinhu velile va Waisilaili vowomulavila mkulu wa nhambiko, vizakuwa va mkulu wa nhambiko iyo, ");
INSERT INTO cwe_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","na chila chinhu chelile cha kugaligwa kwa mkulu wa nhambiko, chizakuwa chake.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Walongele Waisilaili, ‘One muke wa munhu yoyose yahaga na kuleka kwaminika kwa mulumake, ");
INSERT INTO cwe_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kwa kugona na mulume imwenga bila mulumake kuvimanya, kambula mwiko hata one habule munhu yawonile chiyatendile kwaviya hagwiligwe ugoni. ");
INSERT INTO cwe_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Mulumake yahengiligwa na migongo na kumuwonela migongo muke wake yambule mwiko, hebu one yahamuwonela migongo muke wake hata one muke iyo hambule mwiko, ");
INSERT INTO cwe_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","baho mulume kezamgala muke wake kwa mkulu wa nhambiko, na kulava nhosa yoilondeka, chilo imwe ya usage wa shayili, mbali bila kuguma mavuta na ubani, kwaviya ni nhosa ya usage ya migongo, nhosa yoilavigwa kwa kulagusa ubananzi. ");
INSERT INTO cwe_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Mkulu wa nhambiko kezamgala imwanamke habehi na kumwimiza haulongozi wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Mkulu wa nhambiko kezasola mazi yelile muna ichia cha ulongo, maabaho kezasola timbwisi dili hasi ya hema da Mulungu na kudiguma muna yamazi yayo. ");
INSERT INTO cwe_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Maabaho mkulu wa nhambiko kezamwika mwanamke iyo haulongozi wa Mndewa Mulungu na kumgubula nyele zake na kumwing'ha nhosa iyo yoilavigwa kwa kulagusa ubananzi ili nhosa ya usage ya migongo. Mkulu wa nhambiko mwenyewo kezakwamhilila chia chiya chili na mazi yeli usungu yoyogala duwilo. ");
INSERT INTO cwe_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Maabaho mkulu wa nhambiko kezamulahiza mwanamke iyo na kumulongela “One hugonile na mulume imwenga na kuitenda wambule mwiko kuno kuna mulumako, hwizapatigwa na duwilo dodigaligwa na mazi yano yeli usungu. ");
INSERT INTO cwe_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mbali fana kwaga kugona na mulume imwenga na kwambula mwiko kwa kugona na mulume imwenga yeli siyo mulumako, ");
INSERT INTO cwe_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Mndewa Mulungu yakutende uwe duwilo chilaho kwa wanhu wako, sekeulele na munda wako umeme. ");
INSERT INTO cwe_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Mazi yano yoyogala uduwilo yengile mmunda wako na kukutenda sekeulele na munda wako umeme.” Mwanamke iyo kezakwidikila, “Ivo.” ");
INSERT INTO cwe_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Maabaho mkulu wa nhambiko kezakwandika maduwilo yano muna ichibende na kuyasunha muna yamazi yeli usungu, ");
INSERT INTO cwe_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","nayo kezamng'wiza mwanamke iyo mazi yayo yeli usungu yoyogala duwilo, nayo yezakwingila mgati yake na kumgalila mawine makulu ng'hani. ");
INSERT INTO cwe_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Maabaho mkulu wa nhambiko kezasola nhosa ija ya usage ya migongo muna yamakono ya mwanamke ija na kwinula uchanyha kwa kumulavila Mndewa Mulungu, na kuigala hana ulupango. ");
INSERT INTO cwe_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Maabaho kezasola ganza dimwe da nhosa ya mhule kwa lukumbuso lwa kuitimbula hana ulupango. Kezamng'wiza mwanamke mazi yayo. ");
INSERT INTO cwe_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Yahakomeleza kung'wa mazi, one yahambula mwiko na kuleka kwaminika kwa mulumake, mazi yayo yoyogala duwilo yezamgalila mawine makulu ng'hani, munda wawe wizamema na hezalela. Mwanamke iyo kezakuwa duwilo mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mbali one hambule mwiko kwa kugonile na mulume imwenga na kela, basi kailegeha na kezadaha kupata wana. ");
INSERT INTO cwe_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Ino iyo ndagilizi kusonhela migongo ihawa mwanamke, ingawa kolangulizigwa na mulumake, kezakwaga na kuitenda yambule mwiko, ");
INSERT INTO cwe_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","hebu mulume yahengiligwa na migongo na kumuwonela migongo muke wake, kezamwika muke iyo haulongozi wa Mndewa Mulungu, na mkulu wa nhambiko kezatenda fana viili ndagilizi iyo. ");
INSERT INTO cwe_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mulumake kezakuwa kabule ubananzi wowose, mbali mwanamke kezatagusigwa kwa ubananzi wake.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Walongele Waisilaili, ‘One mulume hebu muke kokwika chilaho malumu, chilaho cha kuwa Mnazili na kuika hakwe kwa ichimu cha Mndewa Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","kolondeka sekeyang'we divai hebu upele, sekeyang'we ching'waji chochose chitendigwe kwa zabibu, sekeyang'we mazi ya zabibu hebu sekeyaje zabibu zivile hebu zinyalile. ");
INSERT INTO cwe_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Siku zose za kuika hakwe kwake kolondeka sekeyaje chinhu chochose chitendigwe kwa mzabibu, mbeyu hebu makang'ha yake. ");
INSERT INTO cwe_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Siku zose za chilaho chino cha kuika hakwe, sekeyawegule nyele zake mbaka siku zake za kuika hakwe kwa ichimu cha Mndewa Mulungu vondazifike, kezakuwa kela na kezazileka nyele zake zikule. ");
INSERT INTO cwe_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Siku zose zoyoika hakwe kwa ichimu cha Mndewa Mulungu, munhu iyo sekeyakwenhukile mtufi. ");
INSERT INTO cwe_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Hata one uhawa mtufi wa tati yake hebu mami yake hebu lumbu hebu mwali wake, muladi sekeyambule mwiko kwaviya kaika hakwe kwa ichimu cha Mulungu kwa chilaho. ");
INSERT INTO cwe_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Siku zose za kuika hakwe kwake kezakuwa kela kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘One munhu yoyose yahadanganika bila kuugula habehi yake, ija kezakwambula mwiko, maabaho siku yesaba vondayasafyigwe kezawegula ditwi jake. ");
INSERT INTO cwe_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Siku yenane kezamgalila mkulu wa nhambiko huwa waidi hebu makinda ya nziwa maidi haulongozi wa hanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Mkulu wa nhambiko kezalava imwe kwa ichimu cha nhambiko ya uhasanyi na imwenga kwa ichimu cha nhambiko ya kutimbula muladi kumtendela kuilumba kwaviya katenda uhasanyi kwa mtufi. Siku iyo kezaditenda ditwi jake jele. ");
INSERT INTO cwe_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Kezaika hakwe kaidi kwa ichimu cha Mndewa Mulungu. Siku za mwanduso hazizapetigwa kwaviya kambula mwiko muna zisiku zake za kuika hakwe. Kezalava mwanang'hondolo mulume wa mwaka umwe kuwa nhambiko ya ubananzi. ");
INSERT INTO cwe_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Dino ni lagilizo kwa Mnazili. Vondazikomelezeke siku za kuika hakwe kwake, kezagaligwa hanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Kezalava nhambiko yake kwa Mndewa Mulungu, mwanang'hondolo mulume wa mwaka umwe yelibule chilema kwa ichimu cha nhambiko ya kutimbula, zike da mwanang'hondolo dilibule chilema kwa ichimu cha nhambiko ya uhasanyi, bebelu da ng'hondolo dilibule chilema kwa ichimu cha nhambiko ya tindiwalo, ");
INSERT INTO cwe_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","na chisege cha magate hayagumigwe lusu na maandazi ya usage unogile uhanganyigwe na mavuta, na magate masisili hayagumigwe lusu yabobodigwe mavuta hamwe na nhosa za usage na ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Mkulu wa nhambiko kezavigala vinhu ivo haulongozi wa Mndewa Mulungu na kulava nhambiko ya uhasanyi na nhambiko ya kutimbula. ");
INSERT INTO cwe_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Kezamgalila Mndewa Mulungu chisege cha magate hayagumigwe lusu, hamwe na mwanang'hondolo wa nhambiko ya tindiwalo na nhosa za usage na nhosa za ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Hana ihanhu ha kwingilila muna dihema da Mulungu, Mnazili iyo kezawegula nyele zake na kuziguma muna umoto uli hasi ya nhambiko ya tindiwalo. ");
INSERT INTO cwe_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Maabaho mkulu wa nhambiko kezasola yega da bebelu da ng'hondolo ijo dikimusigwe. Kezasola gate dilibule lusu muna ichisege na andazi, kezamwing'ha Mnazili ija, yahakomeleza kuwegula nyele ziyakalile nazo lusita lwa kuika hakwe kwake. ");
INSERT INTO cwe_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Maabaho mkulu wa nhambiko kezavinula uchanyha vinhu ivo fana nhambiko ya kwinuligwa uchanyha haulongozi wa Mndewa Mulungu. Vinhu vino vose vela kwa mkulu wa nhambiko, hamwe na chidali chochinuligwe uchanyha na chima chochilavigwe nhambiko. Yahakomelezeka yayo yose, Mnazili kodaha kung'wa divai. ");
INSERT INTO cwe_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Ino ni ndagilizi kwa Mnazili, fana vichili chilaho chake. Mbali yahadaha kulava vinhu vimwenga, kolondeka kuzindilila ndagilizi ya Mnazili.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Mulongele Haluni na wanage wa chilume wawatemele mate Waisilaili kwa mbuli zino, ");
INSERT INTO cwe_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Mndewa Mulungu yamtemeleni mate na kumkalizani, ");
INSERT INTO cwe_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mndewa Mulungu yamuloleni kwa unovu na kumtendelani yanogile, ");
INSERT INTO cwe_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mndewa Mulungu yamuwoneleni ubazi na kumwing'hani tindiwalo.’ ");
INSERT INTO cwe_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ivo wezaditambula zina jangu kwa Waisilaili, na nizawatemela mate.” ");
INSERT INTO cwe_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Musa viyakomeleze kusimika dihema da Mulungu, kadiboboda mavuta na kudika kwa sang'hano yelile hamwe na via vake vose. Iviya ulupango kaluboboda mavuta na kulwika kwa sang'hano yelile hamwe na via vake vose. ");
INSERT INTO cwe_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Maabaho walangulizi wa Isilaili na wakulu wa kaye za tati zawo na walangulizi wa makabila, wowawemilize wanhu wapetigwe, ");
INSERT INTO cwe_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","wamgalila Mndewa Mulungu nhosa zawo, mituka sita na milume ya ng'ombe longo na midi, mtuka umwe kwa chila walangulizi waidi na ng'ombe lume dimwe kwa chila mulangulizi. Wavigala vinhu ivo haulongozi wa hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Hokela nhambiko izo muladi zisang'haniligwe muna isang'hano yondaisang'hanigwe kwa ichimu cha hema da Mulungu. Uweng'he Walawi chila imwe fana viili sang'hano yake.” ");
INSERT INTO cwe_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ivo Musa kasola mituka na ng'ombe walume kaweng'ha Walawi. ");
INSERT INTO cwe_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Wagelishoni kaweng'ha mituka midi na ng'ombe walume wane, kwa viili sang'hano yawo ya kupapa via va hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Na kaweng'ha Wamelali mituka mine na ng'ombe walume wanane, kwa viili sang'hano yawo ya kupapa via va hema da Mulungu kwa kulangulizigwa na Isamali mwana wa mkulu wa nhambiko Haluni. ");
INSERT INTO cwe_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mbali Wakohasi haweng'hile chochose, kwaviya sang'hano yawo ikala kupapa vinhu va hema da Mulungu muna yamayega yawo. ");
INSERT INTO cwe_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Walangulizi walava nhambiko kwa ichimu cha kulwika ulupango kwa sang'hano yelile na siku iyo vilubobodigwe mavuta, na walangulizi walava nhambiko zawo haulongozi wa ulupango. ");
INSERT INTO cwe_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Mndewa Mulungu kamulongela Musa, “Chila siku mulangulizi imwe kezalava nhambiko yake kwa ichimu cha kulwika ulupango kwa sang'hano yelile.” ");
INSERT INTO cwe_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Munhu yalavile nhambiko yake siku ya mwanduso kakala Nashoni mwana wa Aminadabu wa kabila da Yuda. ");
INSERT INTO cwe_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Nashoni mwana wa Aminadabu. ");
INSERT INTO cwe_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Siku yekaidi Nasanaeli mwana wa Suali, mulangulizi wa kabila da Isakali kalava nhambiko. ");
INSERT INTO cwe_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Nasanaeli mwana wa Suali. ");
INSERT INTO cwe_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Siku yetatu Eliabu mwana wa Heloni, mulangulizi wa kabila da Zabuloni kalava nhambiko. ");
INSERT INTO cwe_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Eliabu mwana wa Heloni. ");
INSERT INTO cwe_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Siku yekane Elisuli mwana wa Shedueli, mulangulizi wa kabila da Lubeni kalava nhambiko. ");
INSERT INTO cwe_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Elisuli mwana wa Shedueli. ");
INSERT INTO cwe_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Siku yetano Shelumieli mwana wa Sulishadai, mulangulizi wa kabila da Simeoni kalava nhambiko yake. ");
INSERT INTO cwe_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Shelumieli mwana wa Sulishadai. ");
INSERT INTO cwe_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Siku yesita Eliasafu mwana wa Deueli, mulangulizi wa kabila da Gadi kalava nhambiko yake. ");
INSERT INTO cwe_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Eliasafu mwana wa Deueli. ");
INSERT INTO cwe_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Siku yesaba Elishama mwana wa Amihudi, mulangulizi wa kabila da Efulaimu kalava nhambiko yake. ");
INSERT INTO cwe_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Elishama mwana wa Amihudi. ");
INSERT INTO cwe_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Siku yenane Gamalieli mwana wa Pedasuli, mulangulizi wa kabila da Manase kalava nhambiko yake. ");
INSERT INTO cwe_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume imwe wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Gamalieli mwana wa Pedasuli. ");
INSERT INTO cwe_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Siku ya kenda Abidani mwana wa Gidioni, mulangulizi wa kabila da Benjamini kalava nhambiko yake. ");
INSERT INTO cwe_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","na ng'ombe walume waidi na mabebelu ya ng'hondolo matano na mabebelu ya luti matano na wanang'hondolo walume watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Abidani mwana wa Gidioni. ");
INSERT INTO cwe_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Siku ya longo Ahiezeli mwana wa Amishadai, mulangulizi wa wanhu wa Dani kalava nhambiko yake. ");
INSERT INTO cwe_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","na ng'ombe walume waidi na mabebelu ya ng'hondolo watano na mabebelu ya luti matano na wanang'hondolo watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Iyo ikala nhambiko ya Ahiezeli mwana wa Amishadai. ");
INSERT INTO cwe_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Siku ya longo na imwe Pagieli mwana wa Okilani, mulangulizi wa kabila da Asheli kalava nhambiko yake. ");
INSERT INTO cwe_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","na ng'ombe walume waidi na mabebelu ya ng'hondolo watano na mabebelu ya luti matano na wanang'hondolo watano wa mwaka umwe kwa ichimu cha nhambiko za tindiwalo. Ino ikala nhambiko ya Pagieli mwana wa Okilani. ");
INSERT INTO cwe_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Siku ya longo na mbili Ahila mwana wa Enani, mulangulizi wa kabila da Nafutali kalava nhambiko yake. ");
INSERT INTO cwe_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Nhambiko yake ikala vino, chano ya hela ili na nzamo ya chilo imwe na nusu na buyu da hela dili na nzamo ya gilamu magana manane kuilinga na ningo za hema da Mulungu. Ivo vose vimemezigwa usage unogile uhanganyigwe na mavuta kwa ichimu cha nhosa ya usage. ");
INSERT INTO cwe_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Iviya kagala ziga da zahabu dili na nzamo ya gilamu gana na longo, dimemile ubani, ");
INSERT INTO cwe_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","na dang'ang'a lume na bebelu da ng'hondolo na mwanang'hondolo mulume wa mwaka umwe, kwa ichimu cha nhambiko ya kutimbula, ");
INSERT INTO cwe_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, ");
INSERT INTO cwe_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","na ng'ombe walume waidi na mabebelu ya ng'hondolo watano na mabebelu ya luti matano na wanang'hondolo watano wa mwaka umwe. Iyo ikala nhambiko ya Ahila mwana wa Enani. ");
INSERT INTO cwe_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Izo zikala nhambiko za walangulizi wa Isilaili kwa ichimu cha kulwika ulupango kwa sang'hano yelile, siku ija vilubobodigwe mavuta, vyano va hela longo na vidi, mabuyu ya hela longo na maidi na maziga ya zahabu longo na maidi. ");
INSERT INTO cwe_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Chila chano ya hela ikala na nzamo ya chilo imwe na nusu, na chila buyu dikala na nzamo ya gilamu magana manane. Nzamo ya via ivo vose va hela ikala gilamu 2,400, kuilinga na ningo ya hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Maziga longo na maidi ya zahabu yamemile ubani, chila dimwe dina nzamo ya gilamu gana na longo, kuilinga na ningo ya hema da Mulungu. Zahabu yose ya maziga yaja ikala chilo imwe na chidogo. ");
INSERT INTO cwe_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Peta yose ya wanyama wa nhambiko ya kutimbula ikala ng'ombe walume malongo maidi, mabebelu ya ng'hondolo malongo maidi na wanang'hondolo walume wa mwaka umwe malongo maidi, hamwe na nhosa zawo za usage na wanaluti longo na mbili kwa nhambiko ya uhasanyi ");
INSERT INTO cwe_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","na wanyama wose wa nhambiko ya tindiwalo wakala ng'ombe walume malongo maidi na wane na mabebelu ya ng'hondolo malongo sita na mabebelu ya luti malongo sita na wanang'hondolo walume wa mwaka umwe malongo sita. Zino izo nhambiko zilavigwe kwa ichimu cha kulwika ulupango kwa sang'hano yelile, lupango vilumalile kubobodigwa mavuta. ");
INSERT INTO cwe_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa viyengile muna dihema da Mulungu kulonga na Mndewa Mulungu, kahulika dizi dolonga na yeye kulawa hagati ya vilumbe waidi walingile fana wasenga wa kuulanga, uchanyha ya ngubiko ya kuilumba hana disanduku da lagano, na kalonga nayo. ");
INSERT INTO cwe_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Mulongele Haluni, ‘Uheka vitasa saba, vizamwemwesa kuulongozi wa ichinala cha chitasa.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haluni katogola na keka vitasa ivo muladi vimwemwese ubanzi wa kuulongozi wa chinala fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Chinala icho cha chitasa chikala chitendigwe kwa ufundi mkulu kwa zahabu yoihondigwe kulawa hana ichikalilo mbaka maluwa fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Weke hakwe Walawi kulawa mwa Waisilaili na uwatende wele. ");
INSERT INTO cwe_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Tenda vino muladi kuwasafya, miza uchanyha yawo mazi ya kuwasafya, maabaho uwalongele waiwegule nyele lukuli lose na wafuwe viwalo vawo muladi kuisafya. ");
INSERT INTO cwe_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Maabaho wezasola dang'ang'a lume hamwe na nhosa yake ya usage, usage unogile uhanganyigwe na mavuta, weye kwizasola dang'ang'a lume dimwenga kuwa nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Wagale Walawi kuulongozi wa hema da Mulungu na uwaduganye Waisilaili wose. ");
INSERT INTO cwe_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Vondauwagale Walawi kuulongozi wa hema da Mulungu, Waisilaili wezawekila makono Walawi, ");
INSERT INTO cwe_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","nayo Haluni kezawagala Walawi haulongozi wangu niye Mndewa Mulungu, wawe fana nhambiko ya kwinula uchanyha kwa chilaguso muladi wanisang'hanile. ");
INSERT INTO cwe_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Walawi wezakwika makono yawo mchanyha ya matwi ya ng'ombe wawo. Imwe kwizamulava kuwa nhambiko ya uhasanyi na imwenga kwa ichimu cha nhambiko ya kutimbula muladi kuwatendela kuilumba Walawi. ");
INSERT INTO cwe_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Maabaho kwizawemiza Walawi haulongozi wa Haluni na wanage na kwika haulongozi wangu niye Mndewa Mulungu, wawe nhambiko ya kwinuligwa uchanyha kwa chilaguso. ");
INSERT INTO cwe_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Vino niivo vondauweke hakwe Walawi kulawa mwa Waisilaili. Walawi wezakuwa wangu. ");
INSERT INTO cwe_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Uhakomeleza kuwasafya Walawi na kuwalava fana nhambiko ya kwinula uchanyha kwa chilaguso, wezasang'hana muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Wawo niwasola wawe wangu ng'hani, niwasola wawo badala ya wana wa udele wa Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Chila mwana wa udele yawe munhu hebu mnyama muna iisi ya Isilaili ni wangu. Viniwakomile wana wa udele wose muna iisi ya Misili, niweka hakwe kwa ichimu changu. ");
INSERT INTO cwe_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Niwasola Walawi badala ya wana wa udele wose wa Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Walawi wamwenga niweng'ha Haluni na wanage, kulawa kwa Waisilaili muladi wawasang'hanile Waisilaili muna dihema da Mulungu, watende kuilumba kwa ichimu cha Waisilaili, muladi sekekuwe na matamu kwa Waisilaili, vondawakwenhukile hanhu helile.” ");
INSERT INTO cwe_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ivo Musa na Haluni na mting'hano wose wa Waisilaili wawatendela Walawi fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Walawi waisafya uhasanyi wawo na wafuwa viwalo vawo. Maabaho Haluni kawalava nhambiko ya kwinula uchanyha kwa chilaguso haulongozi wa Mndewa Mulungu na kuwatendela kuilumba muladi kuwasafya. ");
INSERT INTO cwe_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ivo Walawi wasang'hana usang'hano wawo muna dihema da Mulungu haulongozi ha Haluni na wanage. Wawatendela Walawi fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Mbuli zowolondeka Walawi ni zino, walume wose weli na miyaka malongo maidi na mitano na kugendelela wolondeka wengile kusang'hanila muna dihema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","mbali walume weli na miyaka malongo matano wezaleka kusang'hanila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Wezawataza ndugu zawo wosang'hana muna dihema da Mulungu kwa kuwakaliza, mbali wawo wenyewo sekewasang'hane usang'hano. Vino niivo vondauwalagilize Walawi sang'hano zawo.” ");
INSERT INTO cwe_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Mndewa Mulungu kalonga na Musa kuna ichuwala cha Sinai, mwezi wa mwanduso muna umwaka wekaidi, viwalawile muna iisi ya Misili. Kamulongela, ");
INSERT INTO cwe_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Waisilaili watende Dugila da Pasaka kwa lusita lupangigwe. ");
INSERT INTO cwe_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","“Siku ya longo na nne ya mwezi uno ichigulogulo nguku zikwingila, mwizaitenda ivo kwa kusondelela malagilizo na ndagilizi zose.” ");
INSERT INTO cwe_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ivo Musa kawalongela Waisilaili watende Dugila da Pasaka. ");
INSERT INTO cwe_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Watenda ivo ichigulogulo nguku zikwingila muna isiku ya longo na nne ya mwezi kuna ichuwala cha Sinai. Waisilaili watenda chila chinhu fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Mbali kukala na walume wamwenga wambula mwiko kwa kudalisa mtufi wa munhu, ivo hawadahile kudeng'helele Dugila da Pasaka muna isiku iyo. Wahita kuulongozi wa Musa na Haluni muna isiku iyo. ");
INSERT INTO cwe_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Wamulongela Musa, “Cheye chambula mwiko kwaviya chidalisa mtufi wa munhu, habali sekechimulavile Mndewa Mulungu nhambiko na Waisilaili wamwenga kwa lusita lupangigwe?” ");
INSERT INTO cwe_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa kawedika, “Gozeleni mbaka vondanihulike Mndewa Mulungu chiyolagiliza kusonhela mweye.” ");
INSERT INTO cwe_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Walongele Waisilaili, ‘Munhu wa kumwenu hebu wa nyelesi zenu, munhu yoyose yondayawe kambula mwiko kwa kudalisa mtufi, hebu yahawa kutali muna umwanza, kozindilila Pasaka ya Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Mwezi umwe hamwande, siku ya longo na nne ya mwezi, ichigulogulo nguku zikwingila, wezaizindilila. Wezakuja hamwe na magate hayagumigwe lusu na mboga zili usungu. ");
INSERT INTO cwe_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Sekewasigaze chinhu chochose mbaka imitondo, hebu sekewabene vuha jojose da mnyama wa Pasaka. Wezatenda fana vizili ndagilizi za Dugila da Pasaka. ");
INSERT INTO cwe_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mbali munhu yoyose yelile hebu heli muna umwanza, nayo hajamhile Dugila da Pasaka, munhu iyo kezabaguligwa na wanhu wake, kwaviya hamulavile Mndewa Mulungu nhambiko kwa lusita lupangigwe. Munhu iyo kezatagusigwa kwa uhasanyi wake. ");
INSERT INTO cwe_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Mgeni yahakala na mweye na kolonda kudeng'helela Dugila da Pasaka da Mndewa Mulungu, kolondeka yatende fana viili ndagilizi na lagilizo da Dugila da Pasaka. Mwizakuwa na lagilizo dimwe kwa iyo yeli mgeni na kwa ija yelekigwe muna iisi.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Muna isiku ija vidisimikigwe hema da Mulungu wingu dihulumuka na kugubika hema ijo. Kwandusila ichigulogulo mbaka imitondo wingu diwa uchanyha ya hema da Mulungu diwoneka fana moto. ");
INSERT INTO cwe_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ivo niivo viiwile chila siku, wingu digubika hema imisi, na ichilo diwoneka fana moto. ");
INSERT INTO cwe_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Chila lusita wingu diya vidinuligwe uchanyha ya hema da Mulungu, baho Waisilaili wandusa mwanza, na hanhu hadikalile wingu diya ni baho Waisilaili hawekile lago. ");
INSERT INTO cwe_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Kwa lagilizo da Mndewa Mulungu Waisilaili wandusa mwanza, na kwa lagilizo da Mndewa Mulungu wazenga lago, lusita diwingu diya vidikalile uchanyha ya hema da Mulungu wakala muna dilago jawo. ");
INSERT INTO cwe_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Wingu diya vidikalame uchanyha ya hema da Mulungu siku nyingi, Waisilaili wamuhulika Mndewa Mulungu, hawasegele. ");
INSERT INTO cwe_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Miyanza imwenga wingu dikala uchanyha kwa siku ndodo, kwa lagilizo diya da Mndewa Mulungu wakala muna dilago jawo, na kwa lagilizo da Mndewa Mulungu wandusa mwanza. ");
INSERT INTO cwe_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Miyanza imwenga wingu dikala uchanyha ya hema da Mulungu kulawa ichigulogulo mbaka imitondo. Wingu diya vidinuligwe imitondo, wandusa mwanza, hata one dikala uchanyha imisi na ichilo, wingu vidinuligwe wandusa mwanza. ");
INSERT INTO cwe_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ihawa wingu dikala uchanyha ya hema da Mulungu siku mbili hebu mwezi hebu mwaka, Waisilaili wakala muna dilago jawo, mbali vidinuligwe uchanyha wandusa mwanza. ");
INSERT INTO cwe_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Kwa lagilizo da Mndewa Mulungu weka lago jawo, na kwa lagilizo da Mndewa Mulungu wandusa mwanza. Wazindilila malagilizo ya Mndewa Mulungu yoyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Tenda mhalati mbili za hela zihondigwe, kwizazisang'hanila mhalati izo lusita lwa kuwatanga wanhu na lusita lwa kubomola malago. ");
INSERT INTO cwe_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Mhalati zose zihatowigwa, wanhu wose wezaiting'hana haulongozi wako, haulongozi wa hanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","One ihatowigwa mhalati imwe muhala, walangulizi wa ng'holo za Isilaili wezaiting'hana haulongozi wako. ");
INSERT INTO cwe_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Muhatowa ulo kwa ulo, malago yeli ubanzi wa ulawilo wa zuwa yezasegela. ");
INSERT INTO cwe_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Muhatowa ulo kwa ulo mwanza wekaidi, wanhu wa ubanzi wa kusi wezasegela. Chilaguso icho cha mhalati chizatendigwa chila lusita lwa kwandusa mwanza. ");
INSERT INTO cwe_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Mbali kuwaduganya wanhu hamwe, mwizatowa mhalati, mbali mutowe dimwe kwa dimwe. ");
INSERT INTO cwe_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Wana wa chilume wa mkulu wa nhambiko Haluni wezatowa mhalati izo. Lagilizo dino dizakuwa da siku zose kumwenu na kwa nyelesi zikwiza. ");
INSERT INTO cwe_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Vondamuhite kuitowa ng'hondo na wehi wenu womuwonelani kuna iisi yenu, baho mwizatowa mhalati ulo kwa ulo. Mwizakumbukigwa haulongozi wa Mndewa Mulungu, Mulungu wenu na mwizakomboligwa kulawa kwa wehi wenu. ");
INSERT INTO cwe_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Muna zisiku zenu za kudeng'helela na muna yamadugila yenu yapangigwe, na kwima kwa chila mwezi, mwizatowa mhalati izo lusita lwa kulava nhambiko zenu za kutimbula na nhambiko zenu za tindiwalo, nazo kumwenu zizakuwa lukumbuso haulongozi wa Mndewa Mulungu. Niye niiyo Mndewa Mulungu, Mulungu wenu.” ");
INSERT INTO cwe_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Siku ya malongo maidi ya mwezi wekaidi, mwaka wekaidi kwandusila Waisilaili viwasegele Misili, wingu dikalile uchanyha ya hema da Mulungu dinuligwa. ");
INSERT INTO cwe_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Waisilaili wasegela chuwala cha Sinai, wingu dihumuluka kuna ichuwala cha Palani. ");
INSERT INTO cwe_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Wandusa kusegela fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yuda na makabila yazengile habehi nayo yandusa mwanza hana ibendela yawo. Nashoni mwana wa Aminadabu niiyo yakalile mulangulizi wa kabila da Yuda. ");
INSERT INTO cwe_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nasanaeli mwana wa Suali kakala mulangulizi wa kabila da Isakali, ");
INSERT INTO cwe_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","na Eliabu mwana wa Heloni kakala mulangulizi wa kabila da Zabuloni. ");
INSERT INTO cwe_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Maabaho hema da Mulungu dihulumusigwa hasi, wanhu wa ng'holo za Gelishoni na Melali wowapapile hema ijo, wandusa kusegela. ");
INSERT INTO cwe_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Maabaho wanhu wakalile hana ibendela ya kabila da Lubeni, wasondelela bumbila dimwe dimwe. Mulangulizi wawo kakala Elisuli mwana wa Shedueli. ");
INSERT INTO cwe_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumieli mwana wa Sulishadai kakala mulangulizi wa kabila da Simeoni. ");
INSERT INTO cwe_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Maabaho Eliasafu mwana wa Deueli kalanguliza kabila da Gadi. ");
INSERT INTO cwe_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Wowawasondelele wakala Wakohasi, wasola vinhu velile, na hema dizengigwa wang'hali wawo hawanafika. ");
INSERT INTO cwe_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Wowawasondelele wakala waja weli hana ibendela ya kabila da Efulaimu, bumbila dimwe dimwe. Mulangulizi wawo kakala Elishama mwana wa Amihudi. ");
INSERT INTO cwe_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli mwana wa Pedasuli kakala mulangulizi wa kabila da Manase. ");
INSERT INTO cwe_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Na mulangulizi wa kabila da Benjamini kakala Abidani mwana wa Gideoni. ");
INSERT INTO cwe_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Kuuhelelo wose wakalile hana ibendela ya kabila da Dani wakalile walolezi kwa Waisilaili muladi sekewatowigwe kwa kuchisogo, wandusa mwanza, bumbila dimwe dimwe. Wano walangulizigwa na Ahiezeli mwana wa Amishadai. ");
INSERT INTO cwe_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli mwana wa Okilani kakala mulangulizi wa kabila da Asheli, ");
INSERT INTO cwe_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","na Ahila mwana wa Enani kakala mulangulizi wa kabila da Nafutali. ");
INSERT INTO cwe_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Vino niivo ikalile miyanza ya Waisilaili kwa makabila yawo, dimwe dimwe, viwanduse mwanza. ");
INSERT INTO cwe_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa kamulongela Hobabu mwana wa Leueli Mmidiani, mkoi wake, “Cheye chokwandusa mwanza kuhita hanhu haja Mndewa Mulungu hoyalongile, ‘Nizamwing'hani hanhu baho.’ Wize hamwe na cheye, chizakutendela yanogile kwaviya Mndewa Mulungu kalonga yanogile kusonhela Waisilaili.” ");
INSERT INTO cwe_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabu kedika, “Sizahita, nobwela kuna iisi yangu na wanhu wangu.” ");
INSERT INTO cwe_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mbali Musa kalonga, “Sekeuchileke, mana weye kuhamanya hanhu hochilondeka kwika lago kuichuwala, kodaha kuchilongoza nzila. ");
INSERT INTO cwe_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","One uhahita hamwe na cheye, yanogile yose yondayachitendele Mndewa Mulungu, na weye chizakutendela ivo ivo.” ");
INSERT INTO cwe_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Wasegela kulawa kuna mulima wa Mndewa Mulungu na wagenda siku nhatu. Sanduku da lagano da Mndewa Mulungu diwalongolela muladi kuwazahilila hanhu ha kuhumula. ");
INSERT INTO cwe_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Wingu da Mndewa Mulungu dikala uchanyha yawo imisi viwakalile wohita kuna dilago. ");
INSERT INTO cwe_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sanduku vidihitile, Musa kalonga, “Inuka weye Mndewa Mulungu! Wehi wako wapwililike na wanhu wokwihila wakimbile na kuhumigwa.” ");
INSERT INTO cwe_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Wingu vidimile, Musa kalonga, “Weye Mndewa Mulungu wabwelele wano Waisilaili maelufu na maelufu.” ");
INSERT INTO cwe_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Wanhu wandusa kulongelela kwa Mndewa Mulungu kwa manhesa yawo. Mndewa Mulungu viyahulike, kehilwa na kawagalila moto. Moto uwo waka hagati yawo na utimbula ubanzi umwe wa lago. ");
INSERT INTO cwe_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Wanhu wamulilila Musa, nayo Musa kampula Mndewa Mulungu, na moto uja ufa. ");
INSERT INTO cwe_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ivo hanhu baho hatangigwa Tabela, kwaviya moto wa Mndewa Mulungu waka hagati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Hagati ya Waisilaili kukala na bumbila dimwenga dikala na hamu ng'hulu. Waisilaili walila kaidi, walonga, “Muhavu chipate nyama imwenga ya kuja! ");
INSERT INTO cwe_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Chokumbuka somba wochidile Misili bila kuliha, na yaja matanga na matikiti na vitunguu va mayani na vitunguu na vitunguu saumu. ");
INSERT INTO cwe_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mbali sambi chabule hamu ya kuja, habule chinhu chimwenga cha kuja ila mana muhala.” ");
INSERT INTO cwe_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana iyo ilinga fana mhule za ng'halasi, iwoneka fana nzelu chidogo. ");
INSERT INTO cwe_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Wanhu wazunguluka na kuiduganya, maabaho waidunda kwa mabwe ya kudundila, hebu kuitwanga muna yamatuli, maabaho kuitogosa muna zinongo na kusasala magate, umulile wake ulinga fana maandazi yambikigwe na mavuta. ");
INSERT INTO cwe_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Nhungwe viilagale uchanyha ya lago ichilo, mana ilagala na nhungwe iyo. ");
INSERT INTO cwe_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa kawahulika wanhu wolila muna zing'holo zawo zose, chila munhu hana ihanhu ha kwingilila muna dihema jake, Mndewa Mulungu kawona ludoko ng'hani, Musa nayo kawona viha. ");
INSERT INTO cwe_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa kamulongela Mndewa Mulungu, “Habali kunitendela vihile niye msang'hani wako? Habali hunogelwe na niye mbaka kuning'ha mbahasha ya wanhu wano wose? ");
INSERT INTO cwe_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Vino niye niweng'ha zinda wanhu wano wose? Vino niye niiyo niweleke? Habali kulonga niweke hachaha yangu fana mama viyokong'heza ching'hele, na kuwagala mbaka kuna iisi iuwalahile kuweng'ha wasaho zawo? ");
INSERT INTO cwe_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Kulihi kondanipate nyama ya kuweng'ha wanhu wano wose? Mana wanililila, walonga, ‘Ching'he nyama chije!’ ");
INSERT INTO cwe_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Sidaha kuwapapa wanhu wano wose niidumwe, kwaviya mbahasha iyo izama ng'hani kumwangu. ");
INSERT INTO cwe_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","One wahanitenda vino, muhavu unikome sambi. One uhanitogolela, sekeunileke muna yamagayo yangu.” ");
INSERT INTO cwe_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Mndewa Mulungu kamulongela Musa, “Niduganyile walume malongo saba kulawa mwa walangulizi wa Isilaili, waja weye kuwamanya kuwa niiwawo walangulizi wa wanhu wawo, uwagale hana dihema da Mulungu, weme hamwe na weye. ");
INSERT INTO cwe_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Niye nizahulumuka na kulonga na weye uko, nizasola hanhu ha muhe unikwing'hile, nizaweng'ha wanhu wawo. Nawo wezakutaza kupapa mbahasha za wanhu wano muladi sekeupape wiidumwe. ");
INSERT INTO cwe_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Walongele wanhu, ‘Muisafye kwaviya igolo mwizakuja nyama, kwaviya mumulilila Mndewa Mulungu, mulonga, “Yelihi yondayaching'he nyama chije? Mana kuja Misili chikala na muhavu.” Ivo kwa ichimu icho Mndewa Mulungu kezamwing'hani nyama muje. ");
INSERT INTO cwe_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hamwizakuja siku dimwe hebu siku mbili hebu siku tano hebu siku longo hebu siku malongo maidi, ");
INSERT INTO cwe_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mbali mwizakuja mwezi mgima mbaka nyama iyo vondailawe muna zimhula zenu. Mwizating'hwa, kwaviya mumulema Mndewa Mulungu yeli hagati yenu na mulila haulongozi wake, mulonga, “Habali chisegela Misili?” ’ ” ");
INSERT INTO cwe_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mbali Musa kalonga, “Wanhu wano nili hagati yawo ni wanhu 600,000 wowogenda kwa migulu, weye kulonga, ‘Nizaweng'ha nyama waje mwezi mgima. ");
INSERT INTO cwe_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Vino mabumbila ya ng'hondolo na ng'ombe yezachinjigwa kwa ichimu chawo? Vino somba wose muna ibahali wezavuwigwa kwa ichimu chawo?’ ” ");
INSERT INTO cwe_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mndewa Mulungu kamulongela Musa, “Vino udahi wangu uhunguka? Lelo kwizawona fana mbuli yangu izalawilila kumwako hebu haizalawilila.” ");
INSERT INTO cwe_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ivo Musa kalawa kunze na kuwalongela wanhu mbuli iyalongile Mndewa Mulungu. Maabaho kawaduganya walangulizi malongo saba na kawemiza kuzunguluka hema. ");
INSERT INTO cwe_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Mndewa Mulungu kahulumuka kulawa muna diwingu na kulonga nayo. Kasola hanhu ha muhe uli uchanyha yake na kauguma uchanyha ya walangulizi waja malongo saba. Muhe uwo viuwahulumukile, wandusa kulonga fana walotezi. Mbali watenda ivo mwanza umwe muhala. ");
INSERT INTO cwe_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Walangulizi waidi mwa waja walangulizi malongo saba wasigala muna dilago, imwe katangigwa Elidadi na imwenga Medadi. Muhe ukala uchanyha yawo, nawo wakala mwa waja wapetigwe. Kwaviya hawalawile kuhita kuna dihema, wandusa kulonga fana walotezi muna dilago. ");
INSERT INTO cwe_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mbwanga imwe kakimbila kahita kumulongela Musa, “Elidadi na Medadi walonga fana walotezi muna dilago.” ");
INSERT INTO cwe_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Maabaho Yoshua mwana wa Nuni yakalile msang'hani wa Musa kwandusila viyakalile mbwanga, kedika na kalonga, “Musa, mwenevale wangu, walemese!” ");
INSERT INTO cwe_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mbali Musa kedika, “Weye kowona migongo kwa ichimu changu? Ihawile vinoga wanhu wose wa Mndewa Mulungu wahawile walotezi na one Mndewa Mulungu yahawagumile muhe wake!” ");
INSERT INTO cwe_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Maabaho Musa na walangulizi wa Isilaili wabwela kuna dilago. ");
INSERT INTO cwe_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Maabaho Mndewa Mulungu kagala beho najo digala ng'hwale kulawa muibahali. Diwaleka walagalila habehi na lago, siku dimwe ubanzi uno na siku dimwenga ubanzi umwenga kuzunguluka lago. Wakala wotayaya mita imwe uchanyha ya isi. ");
INSERT INTO cwe_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Wanhu wasegela imisi iyo yose na ichilo chose na igolo yake yose, waduganya ng'hwale. Yapatile wadodo ng'hani kapata chilo 1,000. Maabaho wawanika wose mumgwazo wa lago kuzunguluka banzi zose. ");
INSERT INTO cwe_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mbali viwakalile hawanakomeleza kuja nyama, Mndewa Mulungu kawehila wanhu na kawagalila hulo kulu. ");
INSERT INTO cwe_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Hanhu haja hatangigwa Kibilosi Hataava, kwaviya baho wawawanda wanhu wamelo. ");
INSERT INTO cwe_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kulawa Kibilosi Hataava wanhu wagenda mbaka Haselosi, wakala uko. ");
INSERT INTO cwe_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miliamu na Haluni wandusa kumulonga vihile Musa kwa ichimu cha imuke Mkushi iyamsolile. ");
INSERT INTO cwe_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Walonga, “Vino Mndewa Mulungu kalonga kufosela Musa muhala? Halongile kufosela cheye iviya?” Mndewa Mulungu kahulika chiwalongile. ");
INSERT INTO cwe_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa kakala munhu yoinyendanyenda ng'hani kufosa wanhu wamwenga wose muna iisi. ");
INSERT INTO cwe_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Kwa kusinhukila Mndewa Mulungu kawalongela Musa na Haluni na Miliamu, “Mweye wose watatu laweni na mwize hana dihema da Mulungu.” Ivo watatu wawo wahita muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Mndewa Mulungu kahulumuka muna diwingu dilingile fana mhanda na kema hana ihanhu ha kwingilila muna dihema da Mulungu na kawatanga Haluni na Miliamu. Wose wakwenhuka kuulongozi. ");
INSERT INTO cwe_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Maabaho kawalongela, “Tegelezeni mbuli zangu, kuhawa na mulotezi hagati yenu, niye Mndewa Mulungu nizailagusa kumwake muna yamalaguso, nizalonga nayo muna zinzozi. ");
INSERT INTO cwe_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mbali kwa Musa msang'hani wangu haili ivo, yeye kokwaminika muna iwanhu wangu wose. ");
INSERT INTO cwe_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nolonga nayo chihanga kwa chihanga, funhufunhu siyo kwa chifiso, koniwona niye Mndewa Mulungu vinili. Habali mweye hamudumbile kumulonga vihile Musa msang'hani wangu?” ");
INSERT INTO cwe_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mndewa Mulungu kawawonela ludoko na kasegela. ");
INSERT INTO cwe_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Maabaho wingu disegela uchanyha ya hema da Mulungu na Miliamu kawa na utamu wa mbende, mzelu fana pamba. Haluni kamulola Miliamu na kamuwona kana utamu wa mbende. ");
INSERT INTO cwe_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Haluni kamulongela Musa, “Mwenevale wangu cholamba sekeuchigaze kwaviya chitenda mbuli za chibozi na chitenda uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Sekeumtende yawe fana mwana yelekigwe yadanganike, yeli nusu ya lukuli lwake luwola.” ");
INSERT INTO cwe_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa kamulilila Mndewa Mulungu, kalonga, “Mulungu nokulamba umuhonye Miliamu!” ");
INSERT INTO cwe_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mndewa Mulungu kamwidika, “Hata one tati yake kambwajulila mate muna ichihanga, sigambeyawone chinyala kwa siku saba? Kolondeka yafungigwe kunze ya lago siku saba, maabaho kezabwelezigwa mgati kaidi.” ");
INSERT INTO cwe_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ivo Miliamu kakala kunze ya lago kwa siku saba na wanhu hawagendelele na umwanza mbaka Miliamu viyagaligwe mgati kaidi. ");
INSERT INTO cwe_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Maabaho wanhu wasegela Haselosi na weka lago kuna ichuwala cha Palani. ");
INSERT INTO cwe_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Tuma wanhu muladi wahite wakaipelembe isi ya Kanaani, yoniweng'ha Waisilaili. Kwizamtuma munhu imwe kulawa chila kabila da tati zawo yawe mulangulizi hagati yawo.” ");
INSERT INTO cwe_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ivo Musa kawatuma kulawa kuna ichuwala cha Palani fana viyalagilizigwe na Mndewa Mulungu. Wose wakala walangulizi wa Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Yano ni mazina ya wanhu wawo. Kulawa kabila da Lubeni, kakala Shamua mwana wa Zakuli. ");
INSERT INTO cwe_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Kulawa kabila da Simeoni, kakala Shafati mwana wa Holi. ");
INSERT INTO cwe_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kulawa kabila da Yuda, kakala Kalebu mwana wa Yefune. ");
INSERT INTO cwe_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Kulawa kabila da Isakali, kakala Igali mwana wa Yosefu. ");
INSERT INTO cwe_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Kulawa kabila da Efulaimu, kakala Hoshea mwana wa Nuni. ");
INSERT INTO cwe_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Kulawa kabila da Benjamini, kakala Paliti mwana wa Lafu. ");
INSERT INTO cwe_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Kulawa kabila da Zabuloni, kakala Gadieli mwana wa Sodi. ");
INSERT INTO cwe_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Kulawa kabila da Manase dilawile kuna dikabila da Yosefu, kakala Gadi mwana wa Susi. ");
INSERT INTO cwe_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Kulawa kabila da Dani, kakala Amieli mwana wa Gemali. ");
INSERT INTO cwe_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Kulawa kabila da Asheli, kakala Sesuli mwana wa Mikaeli. ");
INSERT INTO cwe_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Kulawa kabila da Nafutali, kakala Nabi mwana wa Wofisi, ");
INSERT INTO cwe_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kulawa kabila da Gadi, kakala Geueli mwana wa Maki. ");
INSERT INTO cwe_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Yayo ni mazina ya wanhu waja Musa woyawatumile wahite kuipelemba isi ya Kanaani. Iyo Hoshea mwana wa Nuni, Musa kamtanga zina jake Yoshua. ");
INSERT INTO cwe_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa viyawatumile wawo kuipelemba isi ya Kanaani, kalonga, “Kweleni kufosela ubanzi wa kusi na mukwele kuna imilima ya isi, ");
INSERT INTO cwe_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","mukailole isi viili. Iviya mupelembe kuwa wanhu wokala umo wana nguvu hebu wanyondenyonde, wadodo hebu wengi. ");
INSERT INTO cwe_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Muipelembe isi yowokala fana inoga hebu iha, na wanhu wokala muna yamabululu yeli na mhongono hebu wokala muna yamalago. ");
INSERT INTO cwe_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Isi yake yavilihi? Ina ulongo unogile hebu wihile? Ina mibiki hebu yabule? Tendeni vimudaha mukagale matunda ya isi.” Icho chikala chipindi cha zabibu kwandusa kwiva. ");
INSERT INTO cwe_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ivo wanhu wahita na waipelemba isi kulawa chuwala cha Sini mbaka Lehobu, habehi na hanhu ha kwingilila Hamasi. ");
INSERT INTO cwe_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wahita kufosela ubanzi wa kusi na wafika bululu da Hebuloni, uko wawafika Waahimani na Waasheshai na Watalimai, welesi wa Anaki. Bululu da Hebuloni dizengigwe miyaka saba ing'hali kuzengigwa bululu da Soani dili Misili. ");
INSERT INTO cwe_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Viwafikile kuna dikolongo da Eshikoli, wakanha tambi dili na chipambo chimwe cha zabibu. Wanhu waidi wadipapa kwa mbiki hagati ya waidi wawo, iviya wagala makomamanga na nhini. ");
INSERT INTO cwe_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Hanhu haja hatangigwa Kolongo da Eshikoli kwaviya Waisilaili wakanha chipambo chiya hanhu baho. ");
INSERT INTO cwe_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Vizimalile siku malongo mane, wabwela kulawa kuipelemba isi. ");
INSERT INTO cwe_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wabwela kwa Musa na Haluni na Waisilaili wose wakalile Kadeshi muna ichuwala cha Palani, wawalongela wose mbuli ziwawonile uko na wawalagusa matunda ya isi. ");
INSERT INTO cwe_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wamulongela Musa, “Chifika kuna iisi youchitumile, isi ina ulongo unogile ng'hani na yano ni matunda yake. ");
INSERT INTO cwe_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mbali wanhu wokala muna iisi ija wana nguvu, mabululu yawo yanoga na makulu ng'hani na yana mhongono. Iviya uko chiwawona welesi wa Anaki weli watali ng'hani. ");
INSERT INTO cwe_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Waamaleki wokala isi ya ubanzi wa kusi, Wahiti na Wayebusi na Waamoli wokala kuna imilima, Wakanaani wokala habehi na bahali ya Meditelaniya na mwiingema ya Yoludani.” ");
INSERT INTO cwe_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalebu kawatenda wanhu wanyamale haulongozi wa Musa, kalonga, “Cholondeka chihite chikaisole isi, mana chodaha kuhuma.” ");
INSERT INTO cwe_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mbali wanhu wahitile hamwe na Kalebu walonga, “Hachidaha kuitowa na wanhu wano, mana wana nguvu kufosa cheye.” ");
INSERT INTO cwe_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ivo wawagalila Waisilaili mbuli zihile za isi ija yowaipelembe, walonga, “Wanhu wokala muna iisi ija wodanganika. Wanhu wose wochiwawonile umo ni watali ng'hani. ");
INSERT INTO cwe_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Uko chiwawona Wanefili, welesi wa Anaki. Chiiwona wenyewo fana mbalangulu, nawo niivo vowachiwonile.” ");
INSERT INTO cwe_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Wanhu wose walandula madizi yawo na walila ichilo icho. ");
INSERT INTO cwe_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Waisilaili wose walongelela kwa Musa na Haluni, wanhu wose walonga, “Ihawile muhavu chihadanganikile muna iisi ya Misili, hebu ihawile muhavu chihadanganikile muna ichuwala chino! ");
INSERT INTO cwe_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Habali Mndewa Mulungu kachigala muna iisi ino muladi chikomigwe kwa panga? Wake zetu na wanetu wezakuwa mateka. Vino siyo muhavu chibwele Misili?” ");
INSERT INTO cwe_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Wailongela, “Chimsagule mulangulizi na chibwele Misili.” ");
INSERT INTO cwe_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Maabaho Musa na Haluni watumbala mavindi na vihanga vawo vidalisa hasi haulongozi wa Waisilaili wose. ");
INSERT INTO cwe_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yoshua mwana wa Nuni na Kalebu mwana wa Yefune, wakalile wamwe wa wapelembaji, wadega viwalo vawo kwa usungu, ");
INSERT INTO cwe_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","na wawalongela Waisilaili wose, “Isi yochihitile kuipelemba inoga ng'hani. ");
INSERT INTO cwe_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","One Mndewa Mulungu yahanogelwa na cheye, kezachigala kuna iisi iyo na kuching'ha iwe yetu, isi ili na ulongo unogile ng'hani. ");
INSERT INTO cwe_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Sekemumuleke Mndewa Mulungu hebu sekemuwadumbe wakaya wa isi iyo, mana wawo chizawahuma. Hawakalizigwa, mbali Mndewa Mulungu kahamwe na cheye, sekemuwadumbe.” ");
INSERT INTO cwe_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Wanhu wose walonda kuwatowa na mabwe. Maabaho utunhizo wa Mndewa Mulungu uwalawilila Waisilaili wose hana dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mndewa Mulungu kamulongela Musa, “Wanhu wano wezanizeha mbaka zuwaki? Hawezanihuwila mbaka zuwaki, ingawa nitenda vilaguso ivo vose kumwawo? ");
INSERT INTO cwe_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nizawagalila hulo da utamu na kuwaleka. Nizakwing'ha ng'holo nyingi zili na ludabwa kufosa wawo.” ");
INSERT INTO cwe_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mbali Musa kamulongela Mndewa Mulungu, “Wamisili wezahulika mbuli iyo, kuwa kuwagala wanhu wano kwa udahi wako hagati yawo, ");
INSERT INTO cwe_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","maabaho wezawalongela wakaya wa isi ino. Wahulika kuwa weye Mndewa Mulungu kwahagati ya wanhu wano, mana weye Mndewa Mulungu kowoneka chihanga kwa chihanga na wingu jako dokwima uchanyha yawo. Weye imisi kowalongolela muna diwingu dilingile fana mhanda, na ichilo kowalongolela muna umoto ulingile fana mhanda. ");
INSERT INTO cwe_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Lelo one uhawakoma wanhu wano wose mwanza umwe, wanhu wa zisi zimwenga wahulike mbuli izo wezalonga, ");
INSERT INTO cwe_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Mndewa Mulungu kapotigwa kuwagala wanhu wano muna iisi iyawalaganile kuweng'ha, ivo kawakoma kuichuwala.’ ");
INSERT INTO cwe_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nopula udahi wako weye Mndewa Mulungu uwe mkulu ng'hani fana viuchilaganile viulongile, ");
INSERT INTO cwe_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Mndewa Mulungu kabule ludoko lwa hima hima na kamema ulondo wa kufunya umoyo na kolekelela ubananzi na uhasanyi. Mbali hezaleka kuwatagusa wana na wazukulu wa nyelesi yetatu na yekane kwa ubananzi wa tati zawo.’ ");
INSERT INTO cwe_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Nokulamba uwalekelele wanhu wano kwa kusondelela ulondo wako wa kufunya umoyo, fana viuwalekelele wanhu wano kwandusila viwalawile muna iisi ya Misili mbaka sambi.” ");
INSERT INTO cwe_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mndewa Mulungu kamwidika, “Niwalekelela fana viupulile. ");
INSERT INTO cwe_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mbali fana vonili mgima na fana isi yose voimema utunhizo wangu, ");
INSERT INTO cwe_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","habule hata imwe yawonile utunhizo wangu na mauzauza yangu yonitendile Misili na kuchuwala maabaho kaiyoha kunigeza miyanza iyo yose bila kutegeleza dizi jangu, ");
INSERT INTO cwe_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","yondayawone isi yoniwalaganile tati zawo. Chila munhu yanizehile hezaiwona. ");
INSERT INTO cwe_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mbali msang'hani wangu Kalebu kavingi, kanisondelela kwa moyo wose, nizamgala muna iisi iyahitile, na welesi wake wezaisola isi iyo. ");
INSERT INTO cwe_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Kwaviya Waamaleki na Wakanaani wokala muna dikolongo ijo, igolo hindukeni muhite kuchuwala kwa kufosela nzila yoihita Bahali ya Shamu.” ");
INSERT INTO cwe_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Maabaho Mndewa Mulungu kawauza Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Nizakala na mting'hano uno ulongelela mbaka zuwaki? Nilegela kuhulika kulongelela kwawo. ");
INSERT INTO cwe_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Walongeleni, ‘Noilaha fana vonili mgima, Nizamtendelani fana vimunilongele. ");
INSERT INTO cwe_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mwizadanganika na mitufi yenu izakwasigwa muna ichuwala chino. Kwaviya mulongelela kumwangu, habule hata munhu imwe yapetigwe yeli na miyaka malongo maidi na kugendelela vimwili yondayengile muna iisi ija. ");
INSERT INTO cwe_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Niilaha kuwa nizamulekani mukale muna iisi iyo, mbali habule munhu yondayafike, ila Kalebu mwana wa Yefune na Yoshua mwana wa Nuni. ");
INSERT INTO cwe_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mbali wanenu, womulongile kuwa wezakuwa mateka, nizawagala muna iisi iyo, nawo wezaimanya isi yomuilemile. ");
INSERT INTO cwe_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mbali mweye mwizadanganikila muna ichuwala chino. ");
INSERT INTO cwe_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Wanenu wezakuwa wadimi muna ichuwala kwa miyaka malongo mane na wezagaya kwa ichimu cha kuleka kwaminika kwenu, chila imwe wenu kezadanganika kuchuwala. ");
INSERT INTO cwe_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kwa peta ya siku zimpelembe isi, siku malongo mane, chila siku yopetigwa kuwa mwaka. Kwa ichimu cha uhasanyi wenu, mwizagaya kwa miyaka malongo mane na mwizavimanya kuwa nihilwa. ");
INSERT INTO cwe_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Niye Mndewa Mulungu nilonga. Kweli nizawatendela vino wanhu wano wehile wowaiduganye kwa kunilema, wezadanganika muna ichuwala chino.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ivo wanhu waja Musa woyawatumile wakaipelembe isi ija, wowabwelile na kuwatenda wanhu wose walongelele kwa kugala mbuli zihile za isi iyo, ");
INSERT INTO cwe_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","wadanganika kwa kugaliligwa hulo na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mbali Yoshua mwana wa Nuni na Kalebu mwana wa Yefune hawadanganike bule mwa waja wowahitile kuipelemba isi. ");
INSERT INTO cwe_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa kawalongela Waisilaili wose mbuli zino, nawo walila kwa usungu ng'hani. ");
INSERT INTO cwe_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Igolo yake imitotondo ng'hani walamka na wakwela kuna inhembeti ya isi ya mulima. Walonga, “Chitogola chitenda uhasanyi mbali chahano chohita hanhu haja Mndewa Mulungu hoyachilaganile.” ");
INSERT INTO cwe_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mbali Musa kalonga, “Habali hamuzindilila malagilizo ya Mndewa Mulungu? Mbuli iyo haizadahika! ");
INSERT INTO cwe_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Sekemukwele kwaviya Mndewa Mulungu heli hamwe na mweye. Mwizahumigwa na wehi wenu. ");
INSERT INTO cwe_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Mana Waamaleki na Wakanaani wakuulongozi wenu. Mwizadanganika kwa upanga kwaviya hamumsondele Mndewa Mulungu, ivo hezakuwa hamwe na mweye.” ");
INSERT INTO cwe_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mbali wageza kukwela kuinhembeti ya isi ya mulima, ingawa sanduku da lagano da Mndewa Mulungu hadilawile muna dilago hebu Musa halawile. ");
INSERT INTO cwe_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Maabaho Waamaleki na Wakanaani wowakalile kuna iisi ya mulima, wahulumuka na kuwatowa. Wawawinga mbaka wafika Holima. ");
INSERT INTO cwe_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Walongele Waisilaili, ‘Vondamufike muna iisi yondanimwing'heni mondamukale, ");
INSERT INTO cwe_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","muhanilavila niye Mndewa Mulungu nhambiko kulawa muna iwang'ombe wenu hebu ng'hondolo wenu, nhambiko ya kutimbula hebu nhambiko kwa moto, muladi kufikiza chilaho, hebu iwe nhambiko ya kulonda wenyewo, hebu muna zinhambiko za madugila yenu yapangigwe, muladi kumtendela Mndewa Mulungu mnung'ho unogile. ");
INSERT INTO cwe_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Munhu yondayalave nhambiko yake, kolondeka yamulavile Mndewa Mulungu nhosa ya usage chilo imwe ya usage unogile uhanganyigwe na lita imwe ya mavuta. ");
INSERT INTO cwe_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Sasala lita imwe ya divai fana nhosa ya ching'waji kwa ichimu cha chila mwanang'hondolo wa nhambiko ya kutimbula hebu nhambiko imwenga. ");
INSERT INTO cwe_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Hebu kwa ichimu cha bebelu da ng'hondolo, kwizasasala nhosa ya usage chilo mbili uhanganyigwe na lita imwe na nusu ya mavuta zizalavigwa fana nhosa ya mhule, ");
INSERT INTO cwe_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","kwa nhosa ya ching'waji kwizalava lita imwe na nusu ya divai, kuwa mnung'ho wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Vondamusasale ng'ombe lume kwa nhambiko ya kutimbula hebu nhambiko imwenga kwa ichimu cha kufikiza chilaho hebu kwa nhambiko za tindiwalo kwa Mndewa Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","hamwe na ng'ombe lume munhu iyo kezalava nhosa ya usage chilo nhatu wouhanganyigwe na lita mbili za mavuta. ");
INSERT INTO cwe_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Kaidi kwizagala lita mbili za divai kwa nhambiko ya ching'waji yoilavigwe. Nhambiko yose ina mnung'ho wa kumnogeza Mndewa Mulungu kwa moto. ");
INSERT INTO cwe_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“ ‘Kwizatenda fana vino kwa chila ng'ombe lume hebu bebelu da ng'hondolo hebu mwanang'hondolo hebu mwana luti. ");
INSERT INTO cwe_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Fana viili peta ya wanyama wondamuwasasale, niivo vondamumtendele chila mnyama. ");
INSERT INTO cwe_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Wanhu wose welekigwe Isilaili wolondeka watende yayo yose kwa kusondelela simwe ijo, kulava nhambiko kwa moto, ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","One nyambenyambe yahakala kumwenu, hebu munhu yoyose yeli hagati yenu yahalonda kulava nhambiko kwa moto ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu fana imutenda mweye, nayo kezatenda ivo ivo. ");
INSERT INTO cwe_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","“ ‘Muna umting'hano kwizakuwa na lagilizo dimwe kumwenu mweye na kwa nyambenyambe yokala hamwe na mweye, ni lagilizo da siku zose muna zinyelesi zenu, fana mweye vimuli na nyambenyambe kezakuwa ivo ivo haulongozi wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mweye na nyambenyambe yokala hamwe na mweye mwizakuwa na lagilizo dimwe na ndagilizi imwe.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Walongele Waisilaili, ‘Vondamwingile muna iisi yoniwagalani, ");
INSERT INTO cwe_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","na vondamuje ndiya ya isi, mwizamgalila Mndewa Mulungu nhambiko. ");
INSERT INTO cwe_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Vondamoke magate ya mwanduso ya usage wa mhule zenu za mwanduso, wizalavigwa fana mhule ya hanhu ha kuhwagila mhule. ");
INSERT INTO cwe_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Usage wenu wa mwanduso mwizamwing'ha Mndewa Mulungu nhosa muna zinyelesi zenu. ");
INSERT INTO cwe_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Mbali one muhabananga bila kuilunga na kuleka kuzindilila malagilizo yayo yose niye Mndewa Mulungu yonimwing'hile Musa, ");
INSERT INTO cwe_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","yayo yose Mndewa Mulungu yoyamulagilizeni kufosela Musa, kwandusila siku ija Mndewa Mulungu iyalavile malagilizo mbaka muna zinyelesi zenu, ");
INSERT INTO cwe_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","baho izakuwa fana ni ubananzi woutendigwe bila kuilunga, hebu mting'hano hawavimanyile, baho mting'hano wose wezagala ng'ombe lume kuwa nhambiko ya kutimbula ili na mnung'ho wa kumnogeza Mndewa Mulungu, hamwe na nhosa yake ya usage na nhosa yake ya ching'waji, fana lagilizo vidili, na bebelu da luti kuwa nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Mkulu wa nhambiko kezatenda kuilumba kwa ichimu cha mting'hano wose wa Waisilaili, nawo wezalekelelwa kwaviya uhasanyi utendigwa bila kuilunga, nawo wagala nhambiko zawo wamala, nhambiko kwa moto kwa Mndewa Mulungu na nhambiko zawo za uhasanyi haulongozi ha Mndewa Mulungu kwa ichimu cha ubananzi wawo. ");
INSERT INTO cwe_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Waisilaili wose na nyambenyambe wokala kumwawo wezalekelelwa, kwaviya wanhu wose watenda mbuli iyo bila kuilunga. ");
INSERT INTO cwe_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Mbali one munhu yahatenda uhasanyi bila kuilunga, kezagala luti zike dili na mwaka umwe kuwa nhambiko ya uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mkulu wa nhambiko kezatenda kuilumba haulongozi ha Mndewa Mulungu kwa ichimu cha munhu yatendile uhasanyi, vondayatende uhasanyi bila kuilunga haulongozi ha Mndewa Mulungu, muladi kumtendela kuilumba, nayo kezalekelelwa. ");
INSERT INTO cwe_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Mwizakuwa na lagilizo dimwe kwa munhu yotenda mbuli bila kuilunga, yawe mkaya hebu nyambenyambe yokala kumwenu. ");
INSERT INTO cwe_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Mbali munhu yotenda uhasanyi giladi, iyo komuliga Mndewa Mulungu, yawe mkaya hebu nyambenyambe. Munhu iyo kezabaguligwa mwa wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Kwaviya kaizeha mbuli ya Mndewa Mulungu na kabena malagilizo yake, munhu iyo kolondeka yabaguligwe mwa wanhu wake, nayo kezatagusigwa kwa uhasanyi wake.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Waisilaili viwawile kuichuwala, wamuwona munhu imwe kodondola ngodi Siku ya Mhumulo. ");
INSERT INTO cwe_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Vowamuwone kodondola ngodi wamgala kwa Musa na Haluni na mting'hano wose. ");
INSERT INTO cwe_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Nawo wamkaliza kwaviya hawavimanyile wamtende choni. ");
INSERT INTO cwe_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Mndewa Mulungu kamulongela Musa, “Munhu iyo kolondeka yakomigwe. Mting'hano wose wolondeka wamtowe na mabwe kunze ya lago.” ");
INSERT INTO cwe_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ivo wanhu wose wamulava kunze ya lago, maabaho wamtowa na mabwe mbaka kadanganika, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Walongele Waisilaili kuwa waitendele mahambo muna zimhembe za mawalo yawo, muna zinyelesi zose, chila hambo da chila mhembe udigume nyuzi za langi ya buluu. ");
INSERT INTO cwe_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mahambo yayo yezakuwa kumbukumbu kumwenu. Chila muhaviwona, mwizakumbuka malagilizo yangu yose na kuyazindilila, muladi sekemutende vimulonda kwa kusondelela meso yenu hebu mizoyo yenu, yoimulongozani kutenda uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Mahambo yano yezamkumbusani kuzindilila malagilizo yangu yose na mwizakuwa welile kumwangu niye Mulungu wenu. ");
INSERT INTO cwe_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Niye Mndewa Mulungu, Mulungu wenu, yonimulavileni muna iisi ya Misili muladi niwe Mulungu wenu. Niye niiyo Mndewa Mulungu, Mulungu wenu.” ");
INSERT INTO cwe_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kola mwana wa Ishali, mwana wa Kohasi, mwana wa Lawi, kasola wanhu, hamwe na wanhu watatu wa kabila da Lubeni, watatu wawo wakala Dasani na Abilamu wana wa Eliabu na Oni mwana wa Pelesi, ");
INSERT INTO cwe_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","wawo wose hamwe na Waisilaili wamwenga, wanhu magana maidi na malongo matano, walangulizi wakulu wowasaguligwe na wanhu, weli na nhogolwa, wenuka haulongozi wa Musa kwa ichimu cha kumulema. ");
INSERT INTO cwe_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Waiting'hana haulongozi wa Musa na Haluni na wawalongela, “Mweye muiyoha! Mting'hano wose wela, chila munhu kela na Mndewa Mulungu kahamwe na cheye wose. Mbona mweye moitenda wakulu wa wanhu wa Mndewa Mulungu?” ");
INSERT INTO cwe_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa viyahulike ivo, kaibwanha chingubingubi. ");
INSERT INTO cwe_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Maabaho kamulongela Kola na bumbila jake, “Igolo imitondo Mndewa Mulungu kezalagusa welihi weli wake na welihi welile, na yelihi yondayamkwenhukile, mana yondayamsagule niiyo yondayamkwenhuse kumwake. ");
INSERT INTO cwe_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Weye Kola na bumbila jako jose molondeka mutende vino. Soleni vetezo, ");
INSERT INTO cwe_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","igolo muvigume moto na ubani, maabaho muvigale haulongozi wa Mndewa Mulungu. Munhu yosaguligwa na Mndewa Mulungu kokuwa kela. Mweye Walawi yofaya!” ");
INSERT INTO cwe_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa kamulongela Kola, “Tegelezeni mweye wana wa Lawi! ");
INSERT INTO cwe_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Vino mugesa kuwa mbuli ndodo kumwenu kuwa Mndewa Mulungu kambagulani mweye mwa Waisilaili wose muladi mumkwenhukile habehi na musang'hane hana dihema da Mulungu da Mndewa Mulungu na kwima haulongozi wa wanhu wose muladi kuwasang'hanila? ");
INSERT INTO cwe_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kamtendani mweye hamwe na Walawi wamwenga wose muwe habehi nayo. Lelo molonda kusola hata sang'hano ya wakulu wa nhambiko? ");
INSERT INTO cwe_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ivo weye na bumbila jako jose mumulema Mndewa Mulungu. Mweye mumulongelela Haluni, mbali ukweli momulongelela Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Maabaho Musa kalagiliza wakatangigwe Dasani na Abilamu, wana wa Eliabu, mbali wawo walonga, “Cheye hachizakwiza. ");
INSERT INTO cwe_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Vino ni mbuli ndodo weye kuchigala kulawa Misili, isi ili na ulongo unogile muladi uchikomele kuichuwala? Iviya koitunhiza weye mwenyewo muladi uwe mkulu wetu? ");
INSERT INTO cwe_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Huchigalile muna iisi ili na ulongo unogile, hebu huching'hile uhazi wa migunda, na migunda ya mizabibu, vino kolonda kuwatula yameso wanhu wano na kuwavwizila? Cheye hachizakwiza!” ");
INSERT INTO cwe_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Maabaho Musa kapata ludoko na kamulongela Mndewa Mulungu, “Sekeutogole nhambiko zawo. Niye sisolile hata chihongwe imwe kumwawo, hebu simulumize hata munhu imwe viweli.” ");
INSERT INTO cwe_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa kamulongela Kola, “Weye na bumbila jako jose, igolo mwize hano haulongozi wa Mndewa Mulungu, weye na wawo na Haluni. ");
INSERT INTO cwe_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Chila munhu muna dibumbila jake yasole chetezo chake na kuchiguma ubani, mugale vetezo magana maidi na malongo matano haulongozi wa Mndewa Mulungu. Iviya weye na Haluni muwe na vetezo.” ");
INSERT INTO cwe_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ivo chila munhu kasola chetezo chake na kachiguma moto na ubani, na kwima na Musa na Haluni hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kola viyawaduganye Waisilaili wose muladi kuwalema Musa na Haluni hana ihanhu ha kwingilila muna dihema da Mulungu, utunhizo wa Mndewa Mulungu uwalawilila wanhu wose. ");
INSERT INTO cwe_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Mndewa Mulungu kawalongela Musa na Haluni, ");
INSERT INTO cwe_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Muibagule mwa wanhu wano, muladi niwadanganize sambi.” ");
INSERT INTO cwe_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mbali Musa na Haluni waibwanha chingubingubi na walila, “Weye Mulungu, Mulungu uweng'hile ugima wanhu wose, vino munhu imwe yahabananga kowehila wanhu wose?” ");
INSERT INTO cwe_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Maabaho Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Walongele wanhu wasegele hana yamahema ya Kola na Dasani na Abilamu.” ");
INSERT INTO cwe_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa kenuka na kahita kwa Dasani na Abilamu, walala wa Isilaili wamsondelela. ");
INSERT INTO cwe_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kawalongela wanhu wose, “Segeleni hana yamahema ya wanhu wano wehile! Sekemudalise chinhu chawo chochose, buleivo mwizadanganizigwa, mana wawo wose watenda uhasanyi.” ");
INSERT INTO cwe_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ivo wasegela hana yamahema ya Kola na Dasani na Abilamu. Dasani na Abilamu walawa kunze, wema hana ihanhu ha kwingilila muna yamahema yawo, hamwe na wake zawo na wana wawo wose mbaka wana wokong'ha. ");
INSERT INTO cwe_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Maabaho Musa kalonga, “Kwa mbuli ino mwizavimanya kuwa Mndewa Mulungu kanituma nitende mbuli zino zose, kuwa sitendelile kwa magesa yangu. ");
INSERT INTO cwe_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","One wanhu wano wahadanganika fana viwodanganika wanhu wose bila kugazigwa na Mndewa Mulungu, baho Mndewa Mulungu hanitumile. ");
INSERT INTO cwe_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","“Mbali one Mndewa Mulungu kalumba chinhu cha sambi na isi iyo igubuka na kuwamela hamwe na wose wowakalile nawo, nayo iwamela wang'hali wagima nawo wezahita kuzimu. Baho mwizavimanya kuwa wanhu wano wamzeha Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Bahaja viyakomeleze kulonga mbuli izo zose, isi iyakalile Dasani na Abilamu igubuka. ");
INSERT INTO cwe_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Iwamela wanhu wawo na kaye zawo, hamwe na bumbila jose da Kola na vinhu vawo vose. ");
INSERT INTO cwe_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ivo wawo na vinhu vawo vose wagidimila kuzimu. Isi iwagubika, wose wadanganika. ");
INSERT INTO cwe_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Waisilaili wamwenga wowakalile habehi viwahulike kuguta kwawo, wakimbila na walonga, “Chikimbile, isi yodaha kuchimela na cheye iviya!” ");
INSERT INTO cwe_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Maabaho Mndewa Mulungu kagala moto na uwalunguza wanhu magana maidi na malongo matano wowafukize ubani. ");
INSERT INTO cwe_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Maabaho Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Mulongele Eleazali mwana wa mkulu wa nhambiko Haluni yakasegeze vetezo hana umoto, mana vetezo ivo vela. ");
INSERT INTO cwe_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Vela kwaviya wanhu wano wavigala hana ulupango lwa Mndewa Mulungu. Ivo visole vetezo va wanhu wawo wowakomigwe kwa ichimu cha uhasanyi wawo, vovihondigwe kuwa visisili muladi viwe ngubiko ya lupango. Dino dizakuwa lamulo kwa Waisilaili wose.” ");
INSERT INTO cwe_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ivo Eleazali mkulu wa nhambiko kasola vetezo va shaba vovigaligwe na wanhu waja, vihondigwa kuwa ngubiko ya lupango. ");
INSERT INTO cwe_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Dino diwe kumbukumbu kwa Waisilaili kuwa munhu yoyose yeli siyo mkulu wa nhambiko, yani yeli siyo wa welesi wa Haluni, sekeyahite hana ulupango kumfukizila ubani Mndewa Mulungu. Buleivo kezadanganizigwa fana Kola na bumbila jake. Yano yose yatendeka fana Mndewa Mulungu viyamulagilize Eleazali kufosela Musa. ");
INSERT INTO cwe_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Igolo yake Waisilaili wose wawalongelela Musa na Haluni. Walonga, “Muwakoma wanhu wa Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Mbali mting'hano wose viwaiting'hane haulongozi wa Musa na Haluni muladi kulongelela, wahinduka kulola dihema da Mulungu, wawona wingu digubika hema da Mulungu na utunhizo wa Mndewa Mulungu ulawilila hanhu baho. ");
INSERT INTO cwe_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Musa na Haluni wahita kwima haulongozi wa hema da Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","na Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Segeleni kwa wanhu wano, muladi niwadanganize sambi!” Mbali wawo waibwanha chingubingubi. ");
INSERT INTO cwe_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa kamulongela Haluni, “Sola chetezo chako uchigume moto woulawa hana ulupango, maabaho uchigume ubani uhite nacho kwa wanhu himahima ukawatendele kuilumba. Ludoko lwa Mndewa Mulungu luwafikila na hulo jandusa kuwapata.” ");
INSERT INTO cwe_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Haluni katenda fana Musa viyamulagilize. Kasola chetezo chake na kakimbila mbaka hagati ya wanhu wowaiduganye hamwe. Viyawone hulo jandusa, kaguma ubani muna ichetezo na kuwatendela wanhu kuilumba. ");
INSERT INTO cwe_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Viyatendile ivo, hulo ijo dileka, nayo kasigala hagati ya wanhu wadanganike na weli wagima. ");
INSERT INTO cwe_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Peta ya wanhu wowadanganike kwa hulo ijo wakala 14,700, bila kuwapeta waja wowadanganike kwa ichimu cha kuleka kwaminika kwa Kola. ");
INSERT INTO cwe_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Hulo vidikomelezeke, Haluni kabwela kwa Musa hana ihanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Walongele Waisilaili wakugalile fimbo longo na mbili, chila mulangulizi wa chila kabila fimbo imwe. Yandika zina da chila mulangulizi muna ifimbo yake, ");
INSERT INTO cwe_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","na zina da Haluni jandikigwe muna ifimbo ya kabila da Lawi. Kwizakuwa na fimbo imwe kwa chila mulangulizi wa kabila. ");
INSERT INTO cwe_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Zigale fimbo izo hana dihema da Mulungu na kuzika haulongozi wa sanduku da lagano, hanhu honiiting'hana na weye. ");
INSERT INTO cwe_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Fimbo ya munhu yondanimsagule izasuka. Kwa kutenda vino nizawatenda Waisilaili waleke kumulongelelani.” ");
INSERT INTO cwe_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ivo Musa kawalongela Waisilaili na walangulizi wawo wamwing'he fimbo, chila mulangulizi fimbo imwe kwa kusondelela makabila yawo. Zose zikala fimbo longo na mbili, fimbo ya Haluni ikala hamwe na fimbo izo. ");
INSERT INTO cwe_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa kazika fimbo izo haulongozi wa Mndewa Mulungu hana dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Igolo yake Musa kengila muna dihema da Mulungu. Umo kaifika fimbo ya Haluni wa kabila da Lawi, isuka na kulava maluwa na kwima matunda yevile ya alimondi. ");
INSERT INTO cwe_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Maabaho Musa kazilava kunze zifimbo zikalile haulongozi wa Mndewa Mulungu na kawalagusila Waisilaili wose, nawo wawona chiya chilawilile. Chila mulangulizi kasola fimbo yake. ");
INSERT INTO cwe_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Maabaho Mndewa Mulungu kamulongela Musa, “Bweleza fimbo ya Haluni haulongozi wa sanduku da lagano. Iyo izakwikigwa goya hanhu baho muladi iwe lamulo kwa Waisilaili wowomulema Musa, one hawalekile kunilongelelela wezadanganika.” ");
INSERT INTO cwe_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa katenda fana Mndewa Mulungu viyamulagilize. ");
INSERT INTO cwe_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Waisilaili wamulongela Musa, “Chizadanganika! Chikomelezeka! Chikomelezeka! ");
INSERT INTO cwe_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Munhu yoyose yondayakwenhuke habehi ya hanhu hema da Mulungu kezadanganika. Vino chizadanganika chose?” ");
INSERT INTO cwe_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Mndewa Mulungu kamulongela Haluni, “Ubananzi wose kusonhela hema da Mulungu, wizakuwa kumwako na wanago na lukolo lwako. Iviya ubananzi wa sang'hano yenu ya ukulu wa nhambiko mwizausola weye na wanago. ");
INSERT INTO cwe_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Na ndugu zako nawo, kabila da Lawi, kabila ya tati yako, uwagale habehi hamwe na weye, muladi wailumbe na weye na kukusang'hanila, mbali weye na wanago mwizakuwa haulongozi wa hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Wawo wezasang'hana sang'hano zondauweng'he kusonhela hema, mbali hawalondeka kuvikwenhukila via va hema hebu kulukwenhukila ulupango, buleivo wezadanganika wawo na weye iviya. ");
INSERT INTO cwe_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Nawo wezailumba na weye na wezasang'hana sang'hano zose za muna dihema da Mulungu, habule munhu imwenga yoyose yondayakukwenhukile. ");
INSERT INTO cwe_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Mweye mwizasang'hana sang'hano muna dihema da Mulungu na lupango, muladi sekeniwawonele ludoko kaidi Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Niye niwasagula ndugu zenu Walawi mwa Waisilaili, kumwenu mweye wanhu wawo ni chitumetume choching'higwe na Mndewa Mulungu, muladi wasang'hanile sang'hano ya hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Weye na wanago muhala mwizatenda sang'hano ya ukulu wa nhambiko, kwa ichimu cha lupango na chila chinhu chili kuchisogo ya panzia, iyo ni sang'hano yenu. Nomwing'hani chitumetume cha ukulu wa nhambiko. Munhu imwenga yoyose yondayavikwenhukile via va hema da Mulungu kezakomigwa.” ");
INSERT INTO cwe_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Mndewa Mulungu kamulongela Haluni, “Lola nikwing'ha nhambiko zowaning'hile Waisilaili, vinhu velile vose vowaning'hile. Vinhu vose Waisilaili vowavikile kwa sang'hano yelile nokwing'ha weye na welesi wako, navo vizakuwa venu siku zose. ");
INSERT INTO cwe_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Vinhu vino vizakuwa vako muna ivinhu velile ng'hani, vili havitimbuligwa kwa moto, vino vizakuwa venu, nhosa za usage na nhambiko za uhasanyi na nhambiko za ubananzi. Chila chinhu chondawanilavile wanhu, chizakuwa chako weye na wanago. ");
INSERT INTO cwe_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Mwizakuja vinhu ivo fana vinhu velile ng'hani, chila mulume kodaha kuja kwaviya vela kumwenu. ");
INSERT INTO cwe_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Vinhu vino iviya ni venu, nhosa ya vitumetume vawo, nhambiko zose za Waisilaili za kwinuligwa uchanyha kwa chilaguso, nikwing'ha weye na wanago wa chilume na wa chike, vizakuwa venu siku zose. Munhu yoyose muna ikaye yako yeli hambule mwiko kodaha kuja vinhu ivo. ");
INSERT INTO cwe_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Nokwing'ha vinhu vose vinogile va mwanduso kugobola va Waisilaeli vowonilavila niye Mndewa Mulungu, mavuta yanogile na divai na mhule. ");
INSERT INTO cwe_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Matunda yose yevile ya vinhu va mwanduso muna imigunda yawo wezanigalila niye, yezakuwa yako. Chila munhu muna ulukolo lwako yeli hambule mwiko kodaha kuja. ");
INSERT INTO cwe_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Chila chinhu chochikigwe hakwe kwa ichimu cha Mndewa Mulungu muna iisi ya Isilaili chizakuwa chenu. ");
INSERT INTO cwe_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Chila mwana wa udele yondawanilavile Waisilaili, yawe wa munhu hebu mnyama, kezakuwa wako. Mbali kolondeka uwakombole wana wa udele wose wa wanhu, na chila mwana wa udele wa mnyama yambule mwiko kolondeka yakomboligwe. ");
INSERT INTO cwe_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Waudele wawo wezakomboligwa weli na mwezi umwe kwa kuliha shekeli tano ya hela, kuilinga na ningo za hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mbali chila mwana wa udele wa ng'ombe hebu ng'hondolo hebu luti sekewakomboligwe kwaviya wawo wela. Kwizalumizila ulupango damu zawo, mavuta yawo kwizayatimbula kuwa nhambiko yoilavigwa kwa moto ili mnung'ho unogile wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Modaha kuja nyama zawo, fana viya vimudaha kuja chidali chochinuligwe uchanyha kwa chilaguso na chima cha kulume. ");
INSERT INTO cwe_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Vinhu vose Waisilaili vowonigalile niye Mndewa Mulungu, nokwing'ha weye na wanago wa chilume na wa chike. Dino ni lagano da siku zose na hadizabenigwa haulongozi wangu dili kwa ichimu chako na welesi wako.” ");
INSERT INTO cwe_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Mndewa Mulungu kamulongela Haluni, “Weye kwizakuwa kwabule uhazi wowose muna iisi yawo, hebu kwizakuwa kwabule hanhu hohose kumwawo. Niye niiyo hanhu hako na uhazi wako mwa Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Walawi niweng'ha zaka zose zowonigalila Waisilaili kuwa uhazi. Yano yezakuwa maliho yawo kwa sang'hano iwoitenda ya kukaliza hema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kwandusila sambi Waisilaili sekewadikwenhukile hema da Mulungu, buleivo wezatagusigwa kwa uhasanyi wawo na kuigalila ifa. ");
INSERT INTO cwe_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Mbali Walawi muhala wezasang'hanila muna dihema da Mulungu, nawo wezausola wihi wake, dino dizakuwa lagilizo da siku zose muna zinyelesi zose, hawezakuwa na uhazi hagati ya Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Kwaviya zaka zowonilavila Waisilaili niweng'ha Walawi kuwa uhazi wawo. Lekamana nilonga kuwa wawo hawezakuwa na uhazi mwa Waisilaili.” ");
INSERT INTO cwe_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Walongele Walawi ndagilizi zino, ‘Vondamuhokele zaka yomwing'higwe na Mndewa Mulungu kulawa kwa Waisilaili iwe uhazi wenu, mwizanilavila niye Mndewa Mulungu hanhu hamwe ha longo ha zaka iyo. ");
INSERT INTO cwe_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Nhosa yenu ino izatogoleka kuwa fana mhule zenu za mwanduso hebu fana zabibu ziyonilavila mulimi. ");
INSERT INTO cwe_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ivo niivo vondamunilavile niye Mndewa Mulungu zaka zondamuhokele kulawa kwa Waisilaili. Zaka iyo yondamunilavile niye Mndewa Mulungu mwizamwing'ha mkulu wa nhambiko Haluni. ");
INSERT INTO cwe_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kwa zaka zose zondamuhokele, mwizamgalila Mndewa Mulungu hanhu hanogile kufosa zose.’ ");
INSERT INTO cwe_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Kwa ivo kwizawalongela, ‘Muhakomeleza kulava hanhu hanogile kufosa zose, hanhu hasigale hezakuwa henu, fana viili kwa mulimi yosola chisigale viyakomeleze kulava nhosa zake za mhule na zabibu. ");
INSERT INTO cwe_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Na mweye mwizakuja chochilavigwe mwahawa hanhu hohose hamwe na ng'holo zenu, kwaviya ni chitumetume chenu kwa sang'hano yenu muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Muhaja vinhu ivo hamwizakuwa na uhasanyi wowose, one mumulavila Mndewa Mulungu hanhu hanogile kufosa zose. Sekemuvilige vinhu velile va Waisilaili muladi sekemudanganike.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Mndewa Mulungu kawalongela Musa na Haluni, kalonga, ");
INSERT INTO cwe_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Dino ni lagilizo doyalagilize Mndewa Mulungu. Walongele wanhu wa Isilaili wawagalileni ng'ombe muke mdung'hu yelibule chilema chochose na yang'hali kufungigwa nila ");
INSERT INTO cwe_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","na mwizamwing'ha mkulu wa nhambiko Eleazali. Ng'ombe iyo kezagaligwa kunze ya lago na kuchinjigwa haulongozi hake. ");
INSERT INTO cwe_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Maabaho mkulu wa nhambiko Eleazali kezasola chiyasi cha damu na kuvabika chidole chake na kuimiza kusonhela ubanzi wa kuulongozi wa hema da Mulungu miyanza saba. ");
INSERT INTO cwe_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ng'ombe wose kezasomigwa haulongozi wake, mbende yake na nyama yake na damu yake hamwe na mavi yake vose kezavisoma moto. ");
INSERT INTO cwe_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Maabaho mkulu wa nhambiko kezasola mbiki wa mwelezi na tambi da hisopo na sufu ndung'hu, kezaviguma muna umoto uwo. ");
INSERT INTO cwe_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Maabaho mkulu wa nhambiko kezafuwa mawalo yake na koga lukuli lwake kwa mazi, maabaho kodaha kwingila muna dilago mbali kezakuwa kambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Munhu yondayamsome ng'ombe iyo, iviya kolondeka yafuwe mawalo yake na koga lukuli lwake kwa mazi, nayo iviya kezakuwa kambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Munhu yaisafyile kezayazola maivu ya ng'ombe iyo na kuyagala hanhu hasafyigwe kunze ya lago, yezakwikigwa goya kwa ichimu cha Waisilaili wose, kuwa mazi ya kusegeza kwambula mwiko, muladi kusegeza uhasanyi. ");
INSERT INTO cwe_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Munhu yondayazole maivu ya ng'ombe iyo, kolondeka yafuwe viwalo vake, mbali kezakuwa kambula mwiko mbaka ichigulogulo. Mbuli ino izakuwa lagilizo da siku zose kwa wanhu wa Isilaili na nyambenyambe wondawakale hamwe nawo. ");
INSERT INTO cwe_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Munhu yoyose yondayadalise mtufi wa munhu yoyose kezakwambula mwiko kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Siku yetatu na yesaba, munhu iyo kezaisafya kwa mazi yaja ya kuisafya, nayo kosafyika. Mbali one yahaleka kuisafya muna isiku yetatu na yesaba, munhu iyo kezakuwa yang'hali kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Munhu yoyose yondayadalise mtufi wa munhu, one haisafyile, koditenda hema da Mulungu jambule mwiko, nayo kezabaguligwa mwa wanhu wake Waisilaili. Munhu iyo kezasigala kambula mwiko kwaviya hamiziligwe mazi yaja ya kuisafya. ");
INSERT INTO cwe_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Dino ni lagilizo da kuzindilila one munhu kodanganika muna dihema. Munhu yoyose yokwingila muna dihema na munhu yoyose yeli muna dihema, kezakuwa kambula mwiko kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Na chila chia chili hachigubikigwe uchanyha yake, chizakuwa chambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Munhu yoyose yahadalisa mtufi wa munhu yoyakomigwe hebu yoyadanganike fana viimanyika kunze ya kaye, hebu yahadalisa vuha da munhu hebu leme, kezakuwa kambula mwiko kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Na kwa munhu iyo yambule mwiko wezasola maivu ya nhambiko ya uhasanyi yoisomigwe ya ng'ombe iyo, na mazi ya kuulwanda yezahanganyigwa na maivu muna ichia. ");
INSERT INTO cwe_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Maabaho munhu imwenga yeli hambule mwiko kezasola hisopo na kezadivabika muna yamazi yayo, maabaho kezamizila hema na via vose vili mgati yake na wanhu weli mgati. Iviya kezammizila munhu yoyadalise vuha da munhu hebu mtufi wa munhu yoyakomigwe hebu yoyadanganike ifa imanyika, hebu yoyadalise leme. ");
INSERT INTO cwe_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Munhu iyo kezammizila ija yambule mwiko muna isiku yetatu na yesaba. Siku yesaba kezamsafya, nayo kezafuwa mawalo yake na koga kwa mazi, ichigulogulo kezakuwa kela haulongozi wa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Munhu yahambula mwiko na one haisafyile, munhu iyo kezalemigwa muna umting'hano, kwaviya kaditenda hema da Mulungu jambule mwiko. Kwaviya hamiziligwe mazi ya kuisafya, ivo kambula mwiko. ");
INSERT INTO cwe_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Wanhu wolondeka wazindilile lagilizo dino sambi na siku zikwiza. Munhu yomiza mazi ya kuisafya kezafuwa mawalo yake, na munhu yoyose yodalisa mazi yayo kezakuwa kambula mwiko mbaka ichigulogulo. ");
INSERT INTO cwe_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Chinhu chochose chondayadalise munhu yambule mwiko chizakuwa chambula mwiko, na munhu yoyose yondayachidalise chinhu icho kezakuwa kambula mwiko mbaka ichigulogulo.” ");
INSERT INTO cwe_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Muna umwezi wa mwanduso mting'hano wose wa Waisilaili wafika muna ichuwala cha Sini na wakala Kadeshi. Uko Miliamu kadanganika na kuwandigwa uko. ");
INSERT INTO cwe_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Hanhu baho hakala habule mazi kwa mting'hano wose, ivo wose waiting'hana kuwahinduka Musa na Haluni. ");
INSERT INTO cwe_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Waibishila na Musa, walonga, “Muhavu chihadanganike chipindi chiya ndugu zetu viwadanganike haulongozi wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Habali muwagala mting'hano uno wa Mndewa Mulungu muna ichuwala chino muladi chidanganike, cheye na wanyama wetu? ");
INSERT INTO cwe_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Na habali muchilava Misili na kuchigala hanhu hano hehile? Hanhu hano habule mhule hebu nhini hebu zabibu hebu makomamanga hebu mazi ya kung'wa!” ");
INSERT INTO cwe_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa na Haluni wasegela hanhu haja hawakalile iwanhu na wahita kuna dihema da Mulungu. Waibwanha chingubingubi, baho utunhizo wa Mndewa Mulungu uwalawilila. ");
INSERT INTO cwe_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Sola fimbo ukawaduganye wanhu, weye na sekulu wako Haluni hamwe na mting'hano. Ulongele luwe uja uli haulongozi yawo ulave mazi yake. Kwizayagala mazi yalawile muna uluwe kwa ichimu cha mting'hano, ivo wawo na wanyama wawo wodaha kung'wa.” ");
INSERT INTO cwe_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa kasola fimbo ija haulongozi wa Mndewa Mulungu, fana viya viyalagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa na Haluni wawaduganya wanhu wose hana uluwe. Musa kawalongela, “Tegelezeni mweye wehi! Vino chimulavileni mazi kulawa muna uluwe uno?” ");
INSERT INTO cwe_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ivo Musa kenula mkono wake na kuutowa uluwe miyanza midi kwa fimbo yake. Mazi yalawa mengi. Wanhu hamwe na wanyama wawo wang'wa. ");
INSERT INTO cwe_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mbali Mndewa Mulungu kawalongela Musa na Haluni, “Kwaviya hamunihuwile hebu hamuning'hile hishima haulongozi wa Waisilaili, basi kwa ichimu icho hamwizawengiza wanhu wano muna iisi yoniweng'hile.” ");
INSERT INTO cwe_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Yano ni mazi ya Meliba, hanhu haja Waisilaili howamulongelele Mndewa Mulungu, nayo kailagusa mwenyewo kuwa kela hagati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa kawatuma wasenga kulawa Kadeshi wahite kwa mfalume wa Edomu. Wakamulongele, “Ndugu zako Waisilaili wolonga, ‘Weye kuyamanya manhesa yose yochipatile. ");
INSERT INTO cwe_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Tati zetu viwahitile Misili, hanhu hawakalile kwa miyaka mingi. Wamisili wawagaza tati zetu na cheye iviya. ");
INSERT INTO cwe_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Chimulilila Mndewa Mulungu, nayo kachihulika. Kachigalila msenga wa kuulanga yoyachisegeze Misili. Sambi chahano Kadeshi, isi yoihakana na isi yako. ");
INSERT INTO cwe_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Chokulamba uchileke chifosele muna iisi yako. Hachizabojoga migunda yenu, hebu migunda ya mizabibu hebu hachizakung'wa mazi ya visima venu. Chizaisondelela nzila ng'hulu ya mfalume na kuhita dimwe kwa dimwe bila kuhinduka kulume hebu kumoso, mbaka vondachilawe muna iisi yako.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mbali mfalume wa Edomu kamulongela, “Hamwizafosa muna iisi yangu, one muhafosa chizamulawilani na kumtowani na panga.” ");
INSERT INTO cwe_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Waisilaili wamulongela, “Chizafosela nzila ng'hulu, one cheye na wanyama wetu chihang'wa mazi yako chizakuliha. Chokulamba uchilekele chifose kwa magulu, hachilonda chinhu chimwenga chochose.” ");
INSERT INTO cwe_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mfalume wa Edomu kawalongela, “Hamwizafosa muna iisi yangu.” Maabaho mfalume wa Edomu hamwe na wanhu wengi wahita kuitowa nawo. ");
INSERT INTO cwe_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ivo mfalume wa Edomu kalema kuwalekela Waisilaili wafose muna zimhaka zake. Waisilaili wahinduka na kusondelela nzila imwenga. ");
INSERT INTO cwe_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Mting'hano wose wa Waisilaili wasegela Kadeshi na wafika kuna mulima wa Holi. ");
INSERT INTO cwe_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Mndewa Mulungu kawalongela Musa na Haluni kuna mulima wa Holi, kuna imhaka ya isi ya Edomu, ");
INSERT INTO cwe_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Haluni kezadanganika na hezakwingila muna iisi yoniweng'hile Waisilaili, mana mweye waidi mudileka lagilizo jangu kuja Meliba. ");
INSERT INTO cwe_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Uwasole Haluni na Eleazali mwanage, uwagale uchanyha ya mulima wa Holi, ");
INSERT INTO cwe_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","na umuhambule Haluni mawalo yake ya ukulu wa nhambiko na umuyawaze Eleazali mwanage. Haluni kezadanganika uko kuna mulima.” ");
INSERT INTO cwe_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa katenda fana viya Mndewa Mulungu viyamulagilize. Wakwela kuna mulima wa Holi haulongozi wa mting'hano wose. ");
INSERT INTO cwe_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Maabaho Musa kamuhambula Haluni mawalo ya ukulu wa nhambiko na kamuyawaza Eleazali. Haluni kadanganika kuja kuna inhembeti ya mulima. Maabaho Musa na Eleazali wahulumuka. ");
INSERT INTO cwe_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Mting'hano wose viwawonile kuwa Haluni kadanganika, kaye zose za Waisilaili wamulilila Haluni kwa siku malongo matatu. ");
INSERT INTO cwe_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mkanaani imwe mfalume wa Aladi, yoyakalile uko ubanzi wa kusi, viyahulike kuwa Waisilaili wokwiza kufosela nzila ya Asalimu, kahita kuwatowa na wamwenga kawasola. ");
INSERT INTO cwe_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Maabaho Waisilaili wamulahila Mndewa Mulungu, walonga, “One weye kwizawaguma wanhu wano muna imikono yetu, kweli cheye chizayananga ng'hani mabululu yawo.” ");
INSERT INTO cwe_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mndewa Mulungu kadihulika dizi da Waisilaili, kawatenda wawahume Wakanaani. Waisilaili wawananga ng'hani hamwe na mabululu yawo na zina da hanhu haja hatangigwa Holima. ");
INSERT INTO cwe_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Waisilaili wandusa mwanza kulawa mulima wa Holi, wafosela nzila yoihita bahali ya Shamu muladi waizunguluke isi ya Edomu. Mbali muna inzila wanhu wandusa kulegela. ");
INSERT INTO cwe_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Wanhu wamulongelelela Mulungu na Musa, walonga, “Habali muchilava muna iisi ya Misili muladi chidanganike muna ichuwala? Mana hano habule ndiya hebu mazi. Cheye chiting'hwa na ndiya ino ya chakachaka.” ");
INSERT INTO cwe_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Maabaho Mndewa Mulungu kagala nyoka weli na sungu hagati ya wanhu, Waisilaili wengi walumigwa na wengi wadanganika. ");
INSERT INTO cwe_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Wanhu wahita kwa Musa na wamulongela, “Chitenda uhasanyi kwa kumulongelelela Mndewa Mulungu na weye iviya. Mpule Mndewa Mulungu yachisegezele nyoka wano.” Ivo Musa kawapulila wanhu. ");
INSERT INTO cwe_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mndewa Mulungu kamulongela Musa, “Tenda nyoka wa shaba na umtumbike uchanyha ya mbiki, muladi chila yoyalumigwe yahamulola inyoka iyo, kezahona.” ");
INSERT INTO cwe_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ivo Musa katenda nyoka wa shaba na kamtumbika uchanyha ya mbiki. Chila munhu yoyalumigwe na nyoka viyamulolile nyoka iyo wa shaba, kahona. ");
INSERT INTO cwe_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Waisilaili wagendelela na mwanza wawo na weka lago uko Obosi. ");
INSERT INTO cwe_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Maabaho walawa Obosi, wapanga Iye Abalimu, muna ichuwala, ubanzi wa ulawilo wa zuwa wa isi ya Moabu. ");
INSERT INTO cwe_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Viwasegele uko weka lago jawo muna dikolongo da Zeledi. ");
INSERT INTO cwe_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Kulawa uko wagendelela na umwanza na weka lago jawo ubanzi wa kasikazi wa lwanda lwa Alinoni, woukilima mazi kulawa muna iisi ya Waamoli na kufosela muna ichuwala. Lwanda ulo lukala mhaka hagati ya Wamoabu na Waamoli. ");
INSERT INTO cwe_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ivo yandikigwa muna ichitabu cha ng'hondo za Mndewa Mulungu, “Wahebu muna iisi ya Sufa na makolongo ya Alinoni. ");
INSERT INTO cwe_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Na magidimilo ya makolongo yayo kugidimila bululu da Ali na kuhita kuna imhaka ya Moabu.” ");
INSERT INTO cwe_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kulawa uko Waisilaili wahita mbaka Beeli, icho ni chisima chiya Mndewa Mulungu hoyamulongele Musa, “Wating'hanize wanhu hamwe, nizaweng'ha mazi.” ");
INSERT INTO cwe_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Maabaho Waisilaili wemba wila uno. “Chisima weye lawa mazi! Chimbileni! ");
INSERT INTO cwe_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Chisima chowahimbile wakulu na walangulizi wa wanhu. Wakulu wa wanhu wachisikula, kwa fimbo za chifalume na fimbo zawo. Kulawa chuwala chiya wahita Matana.” ");
INSERT INTO cwe_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Kulawa Matana wahita Nahalieli, na kulawa Nahalieli wahita Bamosi, ");
INSERT INTO cwe_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","na kulawa Bamosi wahita kudibawe da Moabu, kuinhembeti ya mulima wa Pisiga, yoisonhela hasi kuchuwala. ");
INSERT INTO cwe_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Maabaho Waisilaili wawatuma wasenga wahite kwa Sihoni mfalume wa Waamoli wakamulongele, ");
INSERT INTO cwe_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Chitogolele chifose muna iisi yako. Hachizafosa mumgwazo na kwingila muna imigunda hebu muna imigunda ya mizabibu, hebu hachizakung'wa mazi ya visima venu, chizafosa dimwe kwa dimwe muna inzila ng'hulu ya mfalume mbaka vondachisegele muna iisi yako.” ");
INSERT INTO cwe_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mbali Sihoni kalema Waisilaili sekewafose muna iisi yake. Kawaduganya hamwe wakalizi wake wose na kahita Yahasa kuichuwala kuwatowa Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Mbali Waisilaili wamkoma kwa panga na waisola isi yake, kwandusila lwanda lwa Alinoni mbaka lwanda lwa Yaboki, mbaka isi ya Waamoni, kwaviya mhaka ya Waamoni ikala yokalizigwa. ");
INSERT INTO cwe_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Waisilaili wayasola mabululu yose ya Waamoli, nawo wakala muna yamabululu yose ya Waamoli, hamwe na bululu da Heshiboni na vibululu vake. ");
INSERT INTO cwe_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Mana Heshiboni dikala bululu da Sihoni mfalume wa Waamoli, yoyaitowile na mfalume wa umwaka wa Moabu na kumuhoka isi yake yose, mbaka lwanda lwa Alinoni. ");
INSERT INTO cwe_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Lekamana wembaji wokwimba, “Izoni Heshiboni na kudizenga. Bululu da Sihoni dizengigwe na kugangamizigwa. ");
INSERT INTO cwe_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Mana moto ulawa Heshiboni, milambi ya moto ilawa kuna dibululu da Sihoni, udidanganiza bululu da Ali da Moabu, udanganiza milima yose ya lwanda lwa Alinoni ");
INSERT INTO cwe_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Kogaya weye Moabu! Mudanganizigwa, mweye wanhu wa Kemoshi! Kawalava wanage wa chilume kuwa wakimbizi, na wanage wa chike wahite kuutumwa, wahite kwa Sihoni mfalume wa Waamoli. ");
INSERT INTO cwe_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Mbali lelo nyelesi zawo zibanangigwa, Nzila zose kulawa Heshiboni mbaka Diboni, kulawa Nashimu mbaka Nofa, habehi na Medeba.” ");
INSERT INTO cwe_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ivo Waisilaili wakala muna iisi ya Waamoli. ");
INSERT INTO cwe_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa kawatuma wanhu kudipelemba bululu da Yazeli. Wadisola hamwe na vibululu vake na wawawinga Waamoli wowakalile umo. ");
INSERT INTO cwe_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Maabaho Waisilaili wahinduka na wasondelela nzila yoihita Bashani. Ogu mfalume wa Bashani kasegela na wanhu wake wose kahita kuitowa na Waisilaili uko Edilei. ");
INSERT INTO cwe_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Maabaho Mndewa Mulungu kamulongela Musa, “Sekeumdumbe, mana nizatenda mumuhume yeye na isi yake yose na wanhu wake wose. Kwizamtendela fana viya viumtendele Sihoni mfalume wa Waamoli, yoyakalile kokala Heshiboni.” ");
INSERT INTO cwe_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ivo Waisilaili wamkoma Ogu na wanage na wanhu wake wose, hawamsigaze hata munhu imwe. Maabaho waisola isi yake. ");
INSERT INTO cwe_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Maabaho Waisilaili wagendelela na umwanza na kwika lago jawo kuna dibawe da Moabu, dili kuumwambu wa Yoludani habehi na Yeliko. ");
INSERT INTO cwe_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balaki mwana wa Sipoli kawona mbuli zose Waisilaili zowawatendele Waamoli. ");
INSERT INTO cwe_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Wamoabu wawadumba ng'hani wanhu wawo kwaviya wakala wengi. Wamoabu wawadumba ng'hani Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Wamoabu wawalongela walala wa Midiani, “Mting'hano uno wa wanhu wizananga chila chinhu mumgwazo yetu fana viya ng'ombe lume viyoja mgina muna imigunda.” Ivo Balaki mwana wa Sipoli yoyakalile mfalume wa Moabu lusita ulo, ");
INSERT INTO cwe_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","katuma wasenga kwa Balaamu mwana wa Beoli, uko Pesoli habehi na lwanda lwa Efulati muna iisi ya Waamawi. Wamulongela Balaki, “Nolonda uvimanye kuwa wanhu wose wowalawile muna iisi ya Misili wenela muna iisi yose na wokala habehi na niye. ");
INSERT INTO cwe_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Lelo izo uwaduwile wanhu wano, kwaviya wana nguvu kufosa niye. Huwenda nizadaha kuwahuma na kuwawinga walawe muna iisi. Kwaviya nivimanya kuwa wose wouwatemela mate wotemeligwa mate na wouwaduwila woduwiligwa.” ");
INSERT INTO cwe_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Walala wa Moabu na walala wa Midiani wasola mayombe kumuliha mganga, wahita kwa Balaamu na wamulongela mbuli zilawile kwa Balaki. ");
INSERT INTO cwe_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaamu kawalongela, “Kaleni hano ichilo chino, niye nizamulongelani mbuli zondayanilongele Mndewa Mulungu.” Ivo walangulizi wawo wa Moabu wakala na Balaamu. ");
INSERT INTO cwe_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mulungu kamwizila Balaamu na kamuuza, “Wano welihi woukalile hamwe nawo?” ");
INSERT INTO cwe_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu kamulongela Mulungu, “Balaki mwana wa Sipoli, mfalume wa Moabu, kanigalila usenga uno, ");
INSERT INTO cwe_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Kuna wanhu wowalawile Misili wenela muna iisi. Lelo izo uniduwilile wanhu wano, huwenda nizadaha kuitowa nawo na kuwawinga.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mulungu kamulongela Balaamu, “Sekeuhite hamwe nawo na sekeuwaduwile wanhu wawo, kwaviya watemeligwa mate.” ");
INSERT INTO cwe_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Imitondo Balaamu kalamka na kawalongela walala wa Balaki, “Bweleni kuna iisi yenu, kwaviya Mndewa Mulungu halonda nihite hamwe na mweye.” ");
INSERT INTO cwe_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ivo wakulu wa Moabu wasegela na wabwela kwa Balaki na wamulongela, “Balaamu kalema kwiza hamwe na cheye.” ");
INSERT INTO cwe_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Maabaho Balaki kawatuma wakulu wamwenga wengi ng'hani na wakulu kufosa waja wa ichanduso. ");
INSERT INTO cwe_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Wahita kwa Balaamu na wamulongela, “Balaki mwana wa Sipoli kolonga, ‘Nokulamba mbuli yoyose sekeikukimilile kwiza kumwangu. ");
INSERT INTO cwe_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nizakiwng'ha vinhu vingi, na chochose chondaunipule nizakutendela. Izo uwaduwile wanhu wano.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mbali Balaamu kawedika, “Hata one Balaki yahaning'ha kaye yake imemile hela na zahabu, niye sidaha kubena lagilizo da Mndewa Mulungu, Mulungu wangu, kwa mbuli yoyose, ng'hulu hebu ndodo. ");
INSERT INTO cwe_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Lelo kaleni hano ichilo chino fana viwatendile wayenu, muladi nivimanye chondayanilongele Mndewa Mulungu kaidi.” ");
INSERT INTO cwe_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ichilo chiya Mndewa Mulungu kamwizila Balaamu na kamulongela, “Fana wanhu wano weza kukutanga, inuka uhite hamwe nawo, mbali chondanikulongele, niicho chondautende muhala.” ");
INSERT INTO cwe_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ivo Balaamu kalamka imitondo, kamsasala chihongwe wake na kahita hamwe nawo. ");
INSERT INTO cwe_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Mbali Mulungu kehilwa kwaviya kahita. Msenga wa kuulanga kamkimilila muna inzila. Balaamu kakala kakwela chihongwe wake yahawa hamwe na wasang'hani wake waidi. ");
INSERT INTO cwe_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Chihongwe viyamuwonile msenga wa kuulanga kema muna inzila kuno kamha zele dodisomoligwe muna iyala, kaileka inzila na kengila kumgwazo. Balaamu kamtowa chihongwe muladi yambweleze muna inzila. ");
INSERT INTO cwe_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Maabaho msenga wa kuulanga kema hana inzila sisili, hagati ya migunda ya mizabibu, iviya hana ng'huta mbili chila ubanzi. ");
INSERT INTO cwe_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Chihongwe viyamuwone msenga wa kuulanga, kaisung'hila kuna ing'huta na kamulumiza Balaamu umgulu. Balaamu kamtowa kaidi ichihongwe. ");
INSERT INTO cwe_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Maabaho msenga wa kuulanga kalongola kaidi, kema hanhu helibule nyafasi ya kufosa ukulume hebu ukumoso. ");
INSERT INTO cwe_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Chihongwe viyamuwonile msenga wa kuulanga, katambalala hasi. Balaamu kawona ludoko ng'hani na kamtowa kwa fimbo yake. ");
INSERT INTO cwe_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Maabaho Mndewa Mulungu kaugubula mulomo wa chihongwe iyo. Chihongwe kamulongela Balaamu, “Nikutenda choni mbaka unitowe miyanza ino mitatu?” ");
INSERT INTO cwe_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu kamwidika, “Kwaviya kunizeha! One nihawile na panga muna umkono wangu, nihakukomile sambi baha.” ");
INSERT INTO cwe_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Chihongwe kamulongela Balaamu, “Vino niye siyo chihongwe wako ija ija yonikupapile siku zose mbaka diyelo? Vino niwahi kukutendela fana vino?” Balaamu kedika, “Aka.” ");
INSERT INTO cwe_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Maabaho Mndewa Mulungu kayagubula meso ya Balaamu, nayo kamuwona msenga wa kuulanga kema muna inzila, kuno kamha zele dodisomoligwe muna iyala. Balaamu kaibwanha chingubingubi. ");
INSERT INTO cwe_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Msenga wa kuulanga kamulongela Balaamu, “Habali kumtowa chihongwe wako miyanza mitatu? Niza kukukimilila muladi sekeugendelele na mwanza uno. ");
INSERT INTO cwe_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Chihongwe wako kaniwona na kahita kumgwazo miyanza mitatu. One hatendile ivo, nihadahile kukukoma na kumuleka chihongwe yawe mgima.” ");
INSERT INTO cwe_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamu kamulongela msenga wa kuulanga, “Nitenda uhasanyi, mana sivimanyile kuwa kukala kunikimilila muna inzila. Lelo one hulonda niye nigendelele na mwanza uno, basi nizabweleganya.” ");
INSERT INTO cwe_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Msenga wa kuulanga kamulongela Balaamu, “Hita hamwe na wanhu wano, mbali kwizalonga chiya chondanikulongele muhala.” Ivo Balaamu kahita hamwe na wanhu watumigwe na Balaki. ");
INSERT INTO cwe_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki viyahulike kuwa Balaamu kokwiza, kahita kumuhokela kuna dibululu da Ali, bululu dikalile mumgwazo wa lwanda lwa Alinoni, muna imhaka ya Moabu. ");
INSERT INTO cwe_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki kamulongela Balaamu, “Vino situmile wanhu kumwako muladi wakutange? Mbona hwizile? Vino niye sidaha kukuliha goya?” ");
INSERT INTO cwe_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","“Balaamu kamulongela Balaki, ‘Lelo niza!’ Mbali nodaha kulonga chochose? Mbuli yondayanilongele Mulungu niiyo yondaniilonge.” ");
INSERT INTO cwe_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Maabaho Balaamu kahita hamwe na Balaki, wafika Kiliasi Husosi. ");
INSERT INTO cwe_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki kachinja nhambiko ya ng'ombe na luti, kamgalila Balaamu na walangulizi wowakalile hamwe nayo. ");
INSERT INTO cwe_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Igolo yake Balaki kamsola Balaamu na kakwela nayo mbaka Bamosi Baali. Kulawa uko Balaamu kawawona Waisilaili wamwenga. ");
INSERT INTO cwe_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamu kamulongela Balaki, “Nizengele hano mapango saba, unigalile madang'ang'a ya ng'ombe malume saba na mabebelu ya ng'hondolo saba.” ");
INSERT INTO cwe_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki katenda fana viya viyalongile Balaamu. Balaki na Balaamu walava nhambiko ya dang'ang'a da ng'ombe lume na bebelu da ng'hondolo uchanyha ya chila lupango. ");
INSERT INTO cwe_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Maabaho Balaamu kamulongela Balaki, “Ima hano habehi na nhambiko yako, niye nisegele. Huwenda Mndewa Mulungu kezaiting'hana na niye. Chochose chondayanilagusile nizakwiza kukulongela.” Ivo kahita yaidumwe kuna inhembeti ya mulima. ");
INSERT INTO cwe_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Mulungu kaiting'hana nayo, Balaamu kamulongela, “Nisasala mapango saba, na chila lupango nilava nhambiko ya dang'ang'a da ng'ombe lume na bebelu da ng'hondolo.” ");
INSERT INTO cwe_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Mndewa Mulungu kamwing'ha Balaamu mbuli za kulonga na kamulongela, “Bwela kwa Balaki ukamulongele mbuli zino.” ");
INSERT INTO cwe_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ivo kabwela na kamfika Balaki yang'hali kema habehi ya nhambiko yake ya kutimbula, yeye hamwe na walangulizi wose wa Moabu. ");
INSERT INTO cwe_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaamu kalava ulotezi uno, “Balaki mfalume wa Moabu kanigalila kulawa Alamu, kulawa Siliya, kulawa ulawilo wa zuwa wa milima. Kalonga, ‘Izo uwaduwile wanhu wa Yakobo kwa ichimu changu, izo, uwalonge vihile Waisilaili.’ ");
INSERT INTO cwe_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Mbali nizamduwilaze munhu haduwiligwe na Mulungu? Nizawalongaze vihile wanhu waja Mndewa Mulungu hawalongile vihile? ");
INSERT INTO cwe_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Nowawona kulawa kuinhembeti ya maluwe, nomsungulilani kulawa kuinhembeti ya milima. Wanhu wowokala waidumwe, wowoiwona kuwa hawalingile fana wanhu wamwenga. ");
INSERT INTO cwe_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yelihi yodaha kuyapeta matimbwisi ya Yakobo, hebu kupeta lobo ya Isilaili? Vondanidanagnike niwe fana wanhu wanogile, fana Waisilaili.” ");
INSERT INTO cwe_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Maabaho Balaki kamulongela Balaamu, “Kunitendela choni? Nikugala hano muladi uwaduwile wehi wangu, mbali weye kuwatemela mate!” ");
INSERT INTO cwe_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaamu kamwidika, “Vino silondeka kulonga mbuli ziya Mndewa Mulungu ziyazikile muna umulomo wangu?” ");
INSERT INTO cwe_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Maabaho Balaki kamulongela Balaamu, “Chihite hanhu hamwenga hondaudahe kuwawona. Kwizawawona wadodo mbali hwizadaha kuwawona wose. Kulawa uko, waduwile kwa ichimu changu.” ");
INSERT INTO cwe_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Balaki kamsola Balaamu mbaka kuna umgunda wa Sofimu, mbaka kuna inhembeti ya mulima wa Pisiga, kazenga mapango saba, kalava nhambiko ya dang'ang'a da ng'ombe lume na bebelu da ng'hondolo uchanyha ya chila lupango. ");
INSERT INTO cwe_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamu kamulongela Balaki, “Ima hano habehi na nhambiko yako ya kutimbula, niye nihite kuumwambu nikaiting'hane na Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mndewa Mulungu kamwing'ha Balaamu mbuli za kulonga na kamulongela, “Bwela kwa Balaki ukamulongele mbuli zino.” ");
INSERT INTO cwe_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ivo kabwela na kamfika Balaki yang'hali kema habehi na nhambiko yake ya kutimbula, hamwe na walangulizi wa Moabu. Balaki kamuuza Balaamu, “Mndewa Mulungu kolongaki?” ");
INSERT INTO cwe_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaamu kamwimbila, kalonga, “Lamka Balaki, utegeleze, nihulike weye mwana wa Sipoli. ");
INSERT INTO cwe_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Mulungu siyo munhu, mbaka yalonge uvwizi, hebu siyo mwana wa munhu, mbaka yagalule magesa yake. Vino kodaha kulaganila chochose na sekeyachitende, hebu kulonga chinhu na sekeyachifikize? ");
INSERT INTO cwe_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ning'higwa amuli ya kutemela mate, yeye kawatemela mate, niye sidaha kugalula. ");
INSERT INTO cwe_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Halolile wihi kwa wanhu wa Yakobo, iviya hawonile magayo mwa Isilaili. Mndewa Mulungu, Mulungu wawo kahamwe nawo, dizi da mfalume da hagati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Mulungu yoyawasolile kulawa Misili, kawagombela na wehi wawo fana ng'ombe mbago. ");
INSERT INTO cwe_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Uhawi haudaha kuwahuma wanhu wa Yakobo, hebu uganga haudaha kuwahuma Isilaili. Mbuli za Yakobo na Isilaili zizalongigwa, ‘Loleni mauzauza yoyatendile Mndewa Mulungu!’ ");
INSERT INTO cwe_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Waisilaili wenuka fana simba zike, wokwima fana simba lume, fana simba yeli hagona mbaka yagwile chiya chiyowinga, na kung'wa damu ya chiya chiyawingile.” ");
INSERT INTO cwe_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balaki kamulongela Balaamu, “Basi sekeuwaduwile, hebu sekeuwatemele mate!” ");
INSERT INTO cwe_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaamu kamwidika Balaki, “Vino sikulongele kuwa nolondeka kutenda chiyolonga Mndewa Mulungu?” ");
INSERT INTO cwe_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki kamulongela Balaamu, “Izo nikugale hanhu hamwenga. Huwenda Mndewa Mulungu kezanogelwa uniduwilile wanhu wawo kulawa uko.” ");
INSERT INTO cwe_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ivo Balaki kamsola Balaamu kahita nayo kuna inhembeti ya mulima wa Peoli, hanhu baho munhu yahema kowona chuwala hasi yake. ");
INSERT INTO cwe_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu kamulongela Balaki, “Nizengele mapango saba hano, na uning'he ng'ombe walume saba na mabebelu ya ng'hondolo saba.” ");
INSERT INTO cwe_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki katenda fana viyalongile Balaamu, kalava ng'ombe lume na bebelu da ng'hondolo uchanyha ya chila lupango. ");
INSERT INTO cwe_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Basi Balaamu viyawonile kuwa imnogeza Mndewa Mulungu kuwatemela mate Waisilaili, hahitile kulotela kaidi, kalola kuchuwala. ");
INSERT INTO cwe_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaamu kenula meso yake kawona Waisilaili weka malago yawo, chila kabila hanhu hake, Muhe wa Mulungu kamwizila, ");
INSERT INTO cwe_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","nayo kagong'onda ulotezi uno, “Balaamu mwana wa Beoli kolotela, ulotezi wa munhu ija yoyagubuligwe yameso, ");
INSERT INTO cwe_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ulotezi wa munhu yoyahulike mbuli za Mulungu, yoyawonile malaguso ya Mulungu yeli na udahi, yoibwanha chingubingubi, kagubuligwa yameso. ");
INSERT INTO cwe_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Mahema yako yanoga ng'hani weye Yakobo, hanhu hako ha kukala hanoga weye Isilaili! ");
INSERT INTO cwe_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Vino vilinga fana mabawe yokilima mazi, fana chizi hamgwazo ya lwanda, fana makunzamvili yoyahandile Mndewa Mulungu, fana mielezi hamgwazo ya mazi. ");
INSERT INTO cwe_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Wezakuwa na mazi mengi muna zinongo zawo, mbeyu zawo zizahandigwa hanhu heli na mazi ya kufaya. Mfalume wawo kezakuwa mkulu kufosa Agagi, ufalume wawo wizatunhizigwa. ");
INSERT INTO cwe_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Mulungu kawalava kulawa Misili, kawagombela na wehi wawo fana ng'ombe mbago. Kezawananga wanhu wa zisi zimwenga weli wehi wawo, kezaibemenda mivuha yawo vihande vihande, kezawahoma kwa misale yawo. ");
INSERT INTO cwe_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Kaidulika, kagona fana simba, kalinga fana simba zike, habule munhu yogeza kumulamsa. Munhu yoyose yokutemela mate, kezatemiligwa mate, munhu yoyose yokuduwila, kezaduwiligwa.” ");
INSERT INTO cwe_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaki kamuwonela ludoko Balaamu, katowa mang'huwa na kamulongela, “Nikutanga muladi uwaduwile wehi wangu, mbali kuwatemela mate miyanza mitatu. ");
INSERT INTO cwe_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Lelo segela! Nikala nikwikila chilagano kukwing'ha vinhu vingi, mbali Mndewa Mulungu hakudahize kupata vinhu ivo, kakwima.” ");
INSERT INTO cwe_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamu kamwidika Balaki, “Vino siwalongele wasenga wouwatumile kumwangu ");
INSERT INTO cwe_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","kuwa hata one uhaning'ha kaye yako imemile hela na zahabu, niye sidaha kubena lagilizo da Mndewa Mulungu kwa kutenda mbuli yoyose, inogile hebu ihile, bila kuwangilizigwa. Nilonga kuwa chondayalonge Mndewa Mulungu, niicho chondanilonge. ");
INSERT INTO cwe_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Sambi nobwela kwa wanhu wangu, mbali ning'hali sinasegela, leka nikulongele mbuli ziya wanhu wano zondawawatendela wanhu wako siku zikwiza.” ");
INSERT INTO cwe_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Kalotela, kalonga, “Balaamu mwana wa Beoli kolonga, Munhu ija yoyagubuligwe yameso, ");
INSERT INTO cwe_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ulotezi wa munhu yohulika mbuli za Mulungu, na kuumanya umanyi wa yeye yeli uchanyha. Munhu yoyowona malaguso ya Mulungu yeli na udahi, yahaibwanha chingubingubi, kagubuligwa yameso. ");
INSERT INTO cwe_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Nomuwona, mbali siyo sambi, Nomuwona, mbali heli habehi. Nhondo izalawilila kwa welesi wa Yakobo, kezalawilila mfalume mwa Waisilaili. Kezawatowa walangulizi wa Wamoabu kwa fimbo yake, kezawadanganiza welesi wose wa Seti. ");
INSERT INTO cwe_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Isi ya Edomu izakuwa yake, isi ya Seili izakuwa yake, Isilaili izahuma. ");
INSERT INTO cwe_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Imwe kulawa muna uwelesi wa Yakobo kezatawala kezawadanganiza wondawasigale muna dibululu.” ");
INSERT INTO cwe_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Maabaho Balaamu kamuwona Amaleki, kalotela na kalonga, “Amaleki ni isi ili na nguvu kufosa zisi zose, mbali kuuhelelo izadanganizigwa ng'hani.” ");
INSERT INTO cwe_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Maabaho kawalola Wakeni, kalotela, kalonga, “Mhongono yenu ina nguvu mweye Wakeni, fana chisanza uchanyha kuuluwe. ");
INSERT INTO cwe_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Mbali mweye Wakeni mwizadanganizigwa, mbaka Ashulu vondayawasole mateka.” ");
INSERT INTO cwe_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Kaidi Balaamu kalonga, “Loo! Yelihi yondayahone, Mulungu vondayatende yano? ");
INSERT INTO cwe_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ngalawa ng'hulu zizakwiza kulawa mhwani ya Kitimu, wezaziteka Ashulu na Ebeli, na wawo iviya wezadanganizigwa.” ");
INSERT INTO cwe_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Maabaho Balaamu kenuka na kabwela ukaye, Balaki iviya kasegela. ");
INSERT INTO cwe_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Waisilaili viwakalile uko Shitimu, walume wandusa kutenda ugoni na wanaake wa Moabu. ");
INSERT INTO cwe_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Wanaake wawo wawagoneka Waisilaili kuna zinhambiko ziwatambikile milungu yawo, nawo Waisilaili waja ndiya na kuitambikila milungu iyo. ");
INSERT INTO cwe_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ivo Waisilaili wailumba na imwe wa milungu yotangigwa Baali wa Peoli. Mndewa Mulungu kawawonela ludoko. ");
INSERT INTO cwe_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Mndewa Mulungu kamulongela Musa, “Wasole walangulizi wose wa wanhu wano, uwakome hana dizuwa haulongozi wangu, muladi ludoko lwangu lufose.” ");
INSERT INTO cwe_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa kawalongela wasemi wa Isilaili, “Mweye molondeka muwakome wanhu wowailumbile na Baali wa Peoli.” ");
INSERT INTO cwe_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Maabaho Muisilaili imwe kamgala mwanamke Mmidiani ukaye yake, haulongozi wa Musa na mting'hano wose, viwakalile wolila haulongozi wa hanhu ha kwingilila muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasi mwana wa Eleazali, mzukulu wa mkulu wa nhambiko Haluni viyawonile ivo, kenuka na kasegela hana umting'hano. Kasola mgoha ");
INSERT INTO cwe_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","na kamsondelela Muisilaili ija muna dihema da Mulungu. Kawahoma wose waidi kwa mgoha wake muna umunda. Tamu dihile dodikalile dowakoma Waisilaili dikomelezeka. ");
INSERT INTO cwe_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Mbali wanhu wowadanganike kwa tamu ijo wakala 24,000. ");
INSERT INTO cwe_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi mwana wa Eleazali, mzukulu wa mkulu wa nhambiko Haluni, kaluhindula ludoko lwangu lulawe kwa Waisilaili, kwaviya kakala na migongo hagati yawo fana inili nayo niye, hata nileka kuwadanganiza Waisilaili kwa migongo yangu. ");
INSERT INTO cwe_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ivo mulongele, ‘Notenda nayo lagano jangu da tindiwalo. ");
INSERT INTO cwe_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Dizakuwa kumwake na welesi wake, wezakuwa wakulu wa nhambiko siku zose kwaviya kawona migongo kwa ichimu changu niye Mulungu wake, kawatendela kuilumba Waisilaili.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Muisilaili ija yoyakomigwe hamwe na ija mwanamke Mmidiani katangigwa Zimili, mwana wa Salu, mulangulizi wa wanhu wake muna dikabila da Simeoni. ");
INSERT INTO cwe_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Mwanamke ija Mmidiani yoyakomigwe katangigwa Kozibi, mndele wa Suli, yoyakalile mulangulizi wa lukolo uko Midiani. ");
INSERT INTO cwe_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Wagaze Wamidiani na uwakome, ");
INSERT INTO cwe_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kwaviya wawo wamgazani kwa uvwizi wawo, wamvwizilani kwa mbuli ya Peoli na kwa mbuli ya Kozibi, mndele wawo yoyadanganike vikulawilile tamu dihile kuja Peoli.” ");
INSERT INTO cwe_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Vidimalile tamu ijo, Mndewa Mulungu kawalongela Musa na Eleazali mwana wa mkulu wa nhambiko Haluni, ");
INSERT INTO cwe_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Wapeteni Waisilaili wose na ng'holo zawo na wanhu wose weli na miyaka malongo maidi na waja wose wowodaha kuitowa kuna ing'hondo.” ");
INSERT INTO cwe_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa na mkulu wa nhambiko Eleazali walonga na wanhu kuna dibawe da Moabu habehi na lwanda lwa Yoludani uli malola na bululu da Yeliko. Wawalongela, ");
INSERT INTO cwe_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Wapeteni wanhu kwandusila weli na miyaka malongo maidi na kugendelela, fana Mndewa Mulungu viyamulagilize Musa.” Wawo wakala Waisilaili wowalawile muna iisi ya Misili. ");
INSERT INTO cwe_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Lubeni kakala mwana wa udele wa Isilaili, welesi wa Lubeni wakala lukolo lwa Henoki na lukolo lwa Palu ");
INSERT INTO cwe_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","na lukolo lwa Heziloni na lukolo lwa Kalimi. ");
INSERT INTO cwe_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Zino zikala ng'holo za Lubeni. Wanhu wose wowapetigwe wakala 43,730. ");
INSERT INTO cwe_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mwana wa Palu kakala Eliabu. ");
INSERT INTO cwe_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Wana wa Eliabu wakala Nemueli na Dasani na Abilamu. Niiyo wawo Dasani na Abilamu wowasaguligwe na mting'hano mbali wawabiduka Musa na Haluni, wailumba na bumbila da Kola lusita viwamulekile Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Isi igubuka na kuwamela. Wadanganika hamwe na Kola na bumbila jake lusita moto viuwadanganize wanhu 250, dikala lamulo kwa wanhu. ");
INSERT INTO cwe_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mbali lukolo lwa Kola hawadanganike. ");
INSERT INTO cwe_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Welesi wa Simeoni wakala lukolo lwa Nemueli na lukolo lwa Yamini na lukolo lwa Yakini ");
INSERT INTO cwe_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","na lukolo lwa Zela na lukolo lwa Shauli. ");
INSERT INTO cwe_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Zino izo ng'holo za kabila da Simeoni, peta yawo wakala walume 22,200. ");
INSERT INTO cwe_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Welesi wa Gadi wakala lukolo lwa Sefoni na lukolo lwa Hagi na lukolo lwa Shuni ");
INSERT INTO cwe_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","na lukolo lwa Ozini na lukolo lwa Eli ");
INSERT INTO cwe_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","na lukolo lwa Alodi na lukolo lwa Aleli. ");
INSERT INTO cwe_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Zino izo ng'holo za kabila da Gadi, peta yawo wakala walume 40,500. ");
INSERT INTO cwe_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Welesi wa Yuda wakala Eli na Onani. Wawo wadanganikila muna iisi ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Welesi wa Yuda wakala lukolo lwa Shela na lukolo lwa Pelesi na lukolo lwa Zela. ");
INSERT INTO cwe_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Welesi wa Pelesi wakala lukolo lwa Hesiloni na lukolo lwa Hamuli. ");
INSERT INTO cwe_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Zino izo ng'holo za kabila da Yuda, peta yawo wakala walume 76,500. ");
INSERT INTO cwe_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Welesi wa Isakali wakala lukolo lwa Tola na lukolo lwa Puva ");
INSERT INTO cwe_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","na lukolo lwa Yashubu na lukolo lwa Shimuloni. ");
INSERT INTO cwe_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Zino izo ng'holo za kabila da Isakali, peta yawo wakala walume 64,300. ");
INSERT INTO cwe_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Welesi wa Zabuloni wakala lukolo lwa Seledi na lukolo lwa Eloni na lukolo lwa Yaleeli. ");
INSERT INTO cwe_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Zino izo ng'holo za kabila da Zabuloni, peta yawo wakala walume 60,500. ");
INSERT INTO cwe_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Wana wa Yosefu wakala Manase na Efulaimu. ");
INSERT INTO cwe_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Welesi wa Manase wakala lukolo lwa Makili na lukolo lwa Gileadi mwanage. ");
INSERT INTO cwe_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Welesi wa Gileadi wakala lukolo lwa Yezeli na lukolo lwa Heleki ");
INSERT INTO cwe_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","na lukolo lwa Asilieli na lukolo lwa Shekemu ");
INSERT INTO cwe_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","na lukolo lwa Shemida na lukolo lwa Hefeli. ");
INSERT INTO cwe_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofehadi mwana wa Hefeli heleke wana wa chilume mbali wana wa chike muhala. Mazina yawo yakala Mala na Nuhu na Hogila na Milika na Tiliza. ");
INSERT INTO cwe_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Zino izo ng'holo za kabila da Manase, peta yawo wakala walume 52,700. ");
INSERT INTO cwe_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Welesi wa Efulaimu wakala lukolo lwa Shusela na lukolo lwa Bekeli na lukolo lwa Tahani. ");
INSERT INTO cwe_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Welesi wa Shusela wakala lukolo lwa Elani. ");
INSERT INTO cwe_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Zino izo ng'holo za kabila da Efulaimu, peta yawo wakala walume 32,500. Zino ni nyelesi za Yosefu kwa kusondelela ng'holo zawo. ");
INSERT INTO cwe_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Welesi wa Benjamini wakala lukolo lwa Bela na lukolo lwa Ashibeli na lukolo lwa Ahilamu ");
INSERT INTO cwe_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","na lukolo lwa Shufamu na lukolo lwa Hufamu. ");
INSERT INTO cwe_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Welesi wa Bela wakala lukolo lwa Alidi na lukolo lwa Naamani. ");
INSERT INTO cwe_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Zino ni ng'holo za kabila da Benjamini, peta yawo wakala walume 45,600. ");
INSERT INTO cwe_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Welesi wa Dani wakala lukolo lwa Shuhamu. ");
INSERT INTO cwe_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Luno ni lukolo lwa Shuhamu, peta yawo wakala walume 64,400. ");
INSERT INTO cwe_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Welesi wa Asheli wakala lukolo lwa Imina na lukolo lwa Ishivi na lukolo lwa Belia. ");
INSERT INTO cwe_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Welesi wa Belia wakala lukolo lwa Hebeli na lukolo lwa Malikieli. ");
INSERT INTO cwe_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asheli kakala na mwana wa chike zina jake Sela. ");
INSERT INTO cwe_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Zino ni ng'holo za kabila da Asheli, peta yawo wakala walume 53,400. ");
INSERT INTO cwe_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Welesi wa Nafutali wakala lukolo lwa Yeseli na lukolo lwa Guni ");
INSERT INTO cwe_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","na lukolo lwa Yaseeli na lukolo lwa Shilemu. ");
INSERT INTO cwe_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Zino ni ng'holo za kabila da Nafutali, peta yawo wakala walume 45,400. ");
INSERT INTO cwe_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Walume wose wa Isilaili wowapetigwe wakala 601,730. ");
INSERT INTO cwe_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Makabila yano yezagoliligwa isi iwe uhazi wawo, kwa kusondelela peta ya mazina yawo. ");
INSERT INTO cwe_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Kabila kulu dizakwing'higwa hanhu hakulu na kabila dodo dizakwing'higwa hanhu hadodo. Chila kabila dizahokela uhazi wake fana viili peta ya wanhu wake. ");
INSERT INTO cwe_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Mbali isi izagoligwa kwa kutowa mhiya. Chila kabila dizakwing'higwa isi kwa viili mazina ya lukolo lwawo. ");
INSERT INTO cwe_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Uhazi wa chila kabila wizagoligwa kwa kutowa mhiya. Chila kabila dizapata kwa viili ukulu wake hebu udodo wake.” ");
INSERT INTO cwe_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Zino ni ng'holo za Walawi zozipetigwe hamwe na nyelesi zawo, lukolo lwa Gelishoni na lukolo lwa Kohasi na lukolo lwa Melali. ");
INSERT INTO cwe_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Iviya welesi wa Walawi wakala lukolo lwa Libini na lukolo lwa Hebuloni na lukolo lwa Mahili na lukolo lwa Mushi na lukolo lwa Kola. Kohasi kamweleka Amilamu. ");
INSERT INTO cwe_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Zina da muke wa Amilamu dikala Yokebedi, mwelesi wa Lawi, iyo yoyelekwe na Lawi kuna iisi ya Misili, nayo kamwelekela Amilamu wana waidi wa chilume, Haluni na Musa na Miliamu lumbu jawo. ");
INSERT INTO cwe_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Haluni kamweleka Nadabu na Abihu na Eleazali na Isamali. ");
INSERT INTO cwe_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Mbali Nadabu na Abihu wadanganika viwalavile moto haulondeka haulongozi wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Walume wowapetigwe, kwandusila weli na mwezi umwe na kugendelela wakala 23,000, mana wawo hawapetigwe mwa Waisilaili kwaviya wawo haweng'higwe isi kuwa uhazi hagati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Wawo ni walume wowapetigwe na Musa na mkulu wa nhambiko Eleazali, viwawapetile Waisilaili muna dibawe da Moabu habehi na lwanda lwa Yoludani uli malola na bululu da Yeliko. ");
INSERT INTO cwe_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Habule hata munhu imwe yasigale mwa iwaja wapetigwe na Musa na Haluni yeli mkulu wa nhambiko muna ichuwala cha Sinai. ");
INSERT INTO cwe_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Mana Mndewa Mulungu kawalongela, “Waisilaili wano wezadanganikila muna ichuwala.” Hasigale hata imwe viweli, ila Kalebu mwana wa Yefune na Yoshua mwana wa Nuni. ");
INSERT INTO cwe_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Chipindi icho Mala na Nuhu na Hogila na Milika na Tiliza, wandele wa Selofehadi, wakwenhuka habehi. Nayo Selofehadi kakala mwana wa Hefeli, mwana wa Gileadi, mwana wa Makili, mwana wa Manase mwana wa Yosefu. ");
INSERT INTO cwe_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Wawo wema haulongozi wa Musa na haulongozi wa mkulu wa nhambiko Eleazali na haulongozi wa walangulizi wose wa mting'hano, hanhu ha kwingilila hana dihema da Mulungu. Walonga, ");
INSERT INTO cwe_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Tati yetu kadanganika muichuwala, hakalile muna dibumbila da waja wowailumbile kumuhasanya Mndewa Mulungu muna dibumbila da Kola, mbali kadanganika kwa uhasanyi wake mwenyewo na heleke mwana wa chilume. ");
INSERT INTO cwe_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Habali zina da tati yetu disegezigwe muna ulukolo lwake kwaviya heleke mwana wa chilume? Ching'he uhazi hamwe na ndugu wa tati yetu.” ");
INSERT INTO cwe_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa kazigala mbuli zawo kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Mbuli yowolonga wandele wa Selofehadi ni kweli, weng'he uhazi hamwe na ndugu wa tati yawo, wasole uhazi wa tati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Walongele Waisilaili kuwa munhu yoyose yadanganike bila kuleka mwana wa chilume, mwanage wa chike kezakwing'higwa uhazi wake. ");
INSERT INTO cwe_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Na one yahawa kabule mwana wa chike, wezakwing'higwa ndugu zake wa chilume. ");
INSERT INTO cwe_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Na one yahawa kabule ndugu wa chilume, uhazi wake wezakwing'higwa tati zake wakulu hebu tati zake wadodo. ");
INSERT INTO cwe_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Na one tati yake kabule sekulu hebu mdodo, uhazi wake kezakwing'higwa ndugu yake wa habehi, nayo kezahazi fana uhazi wake. Dino dizakuwa lagilizo na ndagilizi kwa Waisilaili, fana Mndewa Mulungu viyamulagilize Musa.” ");
INSERT INTO cwe_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Mndewa Mulungu kamulongela Musa, “Kwela kuna umulima uno wa Abalimu na uilole isi yoniweng'hile Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Na uhaiwona, weye iviya kwizadanganika fana viyadanganike ndugu yako Haluni, ");
INSERT INTO cwe_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","kwaviya muleka kunitegeleza mbuli yangu kuna ichuwala cha Sini. Haja mting'hano wose howalongelele kusonhela niye kuja Meliba. Hamunitendile fana yelile haulongozi wawo viwalondile weng'higwe mazi.” Meliba ni nzasa ya mazi ili Kadeshi kuna ichuwala cha Sini. ");
INSERT INTO cwe_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa kamulongela Mndewa Mulungu, ");
INSERT INTO cwe_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Weye Mndewa Mulungu, Mulungu wili mwanduso wa ugima wose, umsagule munhu wa kuwalongoza wanhu wano, ");
INSERT INTO cwe_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","yondayawalongolele na kuwalongoza muna zimbuli zawo zose, muladi wanhu wa Mndewa Mulungu sekewawe fana ng'hondolo welibule mdimi.” ");
INSERT INTO cwe_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Mndewa Mulungu kamulongela Musa, “Msole Yoshua mwana wa Nuni, munhu yeli na muhe wa Mulungu mgati yake na umwikile mkono wako. ");
INSERT INTO cwe_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Umwimize haulongozi ha mkulu wa nhambiko Eleazali na mting'hano wose, umwing'he sang'hano iyo. ");
INSERT INTO cwe_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Umtende yawe mulangulizi hamwe na weye muladi Waisilaili wose wamtegeleze. ");
INSERT INTO cwe_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Nayo kezakwima haulongozi wa mkulu wa nhambiko Eleazali, yeye kezamulongela voyolondeka kwa uhumizo wa Ulimu na Sumimu haulongozi wa Mndewa Mulungu, Eleazali kezawalongoza Yoshua na Waisilaili wose muna zimbuli zawo zose.” ");
INSERT INTO cwe_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa katenda fana Mndewa Mulungu viyamulagilize. Kamsola Yoshua na kumwimiza haulongozi wa mkulu wa nhambiko Eleazali na mting'hano wose. ");
INSERT INTO cwe_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Maabaho kamwikila makono kwa kumtenda yawe mulangulizi, fana Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Walagilize Waisilaili, ‘Mweye mwizanilavila nhosa zozilondeka kwa lusita lolulondeka, ndiya za kutimbuligwa kwa moto, zili na mnung'ho unogile wa kuninogeza.’ ");
INSERT INTO cwe_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","“Walongele kuwa nhambiko zondawanilavile niye Mndewa Mulungu kwa moto zizakuwa vino, mabebelu ya ng'hondolo maidi yeli na mwaka umwe yelibule chilema, kwa ichimu cha nhambiko ya kutimbula ya chila siku. ");
INSERT INTO cwe_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mwanang'hondolo imwe kezalavigwa imitondo na imwenga kezalavigwa ichigulogulo nguku zikwingila, ");
INSERT INTO cwe_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","chila imwe kezalavigwa hamwe na nhosa ya usage chilo imwe, wouhanganyigwe na lita imwe ya mavuta yanogile yahondigwe. ");
INSERT INTO cwe_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Nhambiko ya kutimbula ino izalavigwa chila siku, ija ilagilizigwe uko kuna umulima wa Sinai iwe mnung'ho unogile wa kunogeza, nhambiko iyolaviligwa Mndewa Mulungu kwa moto. ");
INSERT INTO cwe_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Nhosa ya ching'waji yondailavigwe hamwe na chila mwanang'hondolo ni lita imwe ya divai. Kwizaigida nhosa ino ya ching'waji hana ihanhu helile. ");
INSERT INTO cwe_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ichigulogulo nguku zikwingila kwizamulava ija mwanang'hondolo imwenga hamwe na nhosa ya usage na hamwe na nhosa ya ching'waji fana viutendile imitondo, kwizalava nhambiko iyolaviligwa Mndewa Mulungu kwa moto, ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Muna Isiku ya Mhumulo mwizalava wanang'hondolo walume waidi weli na mwaka umwe welibule chilema na chilo mbili za usage unogile wouhanganyigwe na mavuta, hamwe na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Nhambiko ino ya kutimbula izalavigwa chila Siku ya Mhumulo, kufosa nhosa ija ya chila siku hamwe na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Chila mwanduso wa mwezi, mwizamgalila Mndewa Mulungu nhambiko ya kutimbula. Madang'ang'a malume maidi na mabebelu ya ng'hondolo saba na wanang'hondolo walume saba weli na mwaka umwe, wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Mwizalava nhosa ya usage unogile chilo nhatu wouhanganyigwe na mavuta, kwa chila ng'ombe lume, mwizalava chilo mbili za usage unogile wouhanganyigwe na mavuta, kwa chila bebelu da ng'hondolo, ");
INSERT INTO cwe_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","na chilo imwe ya usage unogile wouhanganyigwe na mavuta, kwa chila mwanang'hondolo. Nhambiko zino za kutimbula zolavigwa kwa Mndewa Mulungu kwa moto, zili na mnung'ho unogile wa kumnogeza Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ningo ya nhosa ya ching'waji yoilondeka ni lita mbili za divai kwa chila ng'ombe lume, lita imwe na nusu kwa chila bebelu da ng'hondolo na lita imwe kwa chila mwanang'hondolo. Ino iyo nhambiko ya kutimbula ya chila mwezi kwa mwaka. ");
INSERT INTO cwe_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Iviya mwizamulavila Mndewa Mulungu bebelu da luti kwa ichimu cha nhambiko ya uhasanyi hamwe na nhambiko ija ya kutimbula ya chila siku na nhosa ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Siku ya longo na nne ya mwezi wa mwanduso ni Dugila da Pasaka ya Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Muna isiku ya longo na tano ya mwezi uwo kwizakuwa na dugila, kwa siku saba mwizakuja magate yelibule lusu. ");
INSERT INTO cwe_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Muna isiku ya mwanduso kwizakuwa na mting'hano wa kutosa kwa Mulungu. Siku iyo hamwizasang'hana usang'hano wowose. ");
INSERT INTO cwe_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mwizalava nhambiko ya kutimbula kwa Mndewa Mulungu kwa moto, madang'ang'a malume maidi na bebelu da ng'hondolo na wanang'hondolo walume saba weli na mwaka umwe, wose sekewawe na chilema, ");
INSERT INTO cwe_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","hamwe na nhosa zake za usage, usage unogile wouhanganyigwe na mavuta, mwizalava chilo nhatu kwa chila ng'ombe imwe na chilo mbili kwa chila bebelu da ng'hondolo, ");
INSERT INTO cwe_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","na chilo imwe kwa chila mwanang'hondolo mwa waja wanang'hondolo saba. ");
INSERT INTO cwe_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Iviya mwizalava bebelu da luti kuwa nhambiko ya uhasanyi, muladi kuwatendela kuilumba. ");
INSERT INTO cwe_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mwizalava wanyama wawo, iviya nhambiko ya kutimbula ya chila siku, yoilavigwa chila imitondo. ");
INSERT INTO cwe_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Iviya kwa siku saba mwizalava nhambiko ya ndiya kwa Mndewa Mulungu kwa moto, ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu. Ino mwizailava hamwe na nhambiko ija ya kutimbula ya chila siku na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Muna isiku yesaba mwizakuwa na mting'hano wa kutosa kwa Mulungu, sekemusang'hane usang'hano wowose. ");
INSERT INTO cwe_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Muna isiku ya Dugila da Majuma, vondamumulavile Mndewa Mulungu mhule zenu zimugobole mwanduso, mwizatenda mting'hano wa kutosa kwa Mulungu. Sekemusang'hane usang'hano wowose. ");
INSERT INTO cwe_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mwizalava nhambiko ya kutimbula ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu, madang'ang'a malume maidi na bebelu da ng'hondolo na wanang'hondolo walume saba weli na mwaka umwe. ");
INSERT INTO cwe_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Izakuwa hamwe na nhosa zake za usage unogile wouhanganyigwe na mavuta, chilo nhatu kwa chila ng'ombe lume na chilo mbili kwa chila bebelu da ng'hondolo ");
INSERT INTO cwe_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na chilo imwe kwa chila mwanang'hondolo. ");
INSERT INTO cwe_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Iviya mwizalava bebelu da luti, muladi kumtendelani kuilumba. ");
INSERT INTO cwe_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Iviya mwizalava nhambiko iyo ya kutimbula ya chila siku hamwe na nhosa yake ya ching'waji. Wanyama wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Muna isiku ya mwanduso ya mwezi wa saba mwizakuwa na mting'hano wa kutosa kwa Mulungu, sekemusang'hane usang'hano. Iyo izakuwa siku yenu ya kutowa mhalati. ");
INSERT INTO cwe_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Mwizalava nhambiko ya kutimbula ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu, dang'ang'a lume na bebelu da ng'hondolo na wanang'hondolo walume saba weli na mwaka umwe, wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Iviya mwizalava nhosa yake ya usage unogile wouhanganyigwe na mavuta, chilo nhatu kwa dang'ang'a lume na chilo mbili kwa bebelu da ng'hondolo ");
INSERT INTO cwe_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na chilo imwe kwa chila mwanang'hondolo. ");
INSERT INTO cwe_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Kaidi mwizalava bebelu da luti kwa ichimu cha nhambiko ya uhasanyi muladi kumtendelani kuilumba. ");
INSERT INTO cwe_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Mwizalava vinhu vino hamwe na nhosa ya usage ya mwezi wa sambi na nhosa yake ya mhule na nhosa zake za ching'waji fana viya voilagilizigwa. Mnung'ho wake unogile wizamnogeza Mndewa Mulungu. Iyo ni nhambiko iyolaviligwa Mndewa Mulungu kwa moto. ");
INSERT INTO cwe_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Muna isiku ya longo ya mwezi wa saba mwizakuwa na mting'hano wa kutosa kwa Mulungu, sekemuje hebu sekemusang'hane sang'hano yoyose. ");
INSERT INTO cwe_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mwizamulavila Mndewa Mulungu nhambiko ya kutimbula ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu, dang'ang'a lume na bebelu da ng'hondolo na wanang'hondolo saba wa mwaka umwe, wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Iviya mwizalava usage unogile wouhanganyizigwe na mavuta chilo nhatu hamwe na ng'ombe lume iyo, chilo mbili hamwe na bebelu da ng'hondolo, ");
INSERT INTO cwe_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","na chilo imwe kwa chila mwanang'hondolo. ");
INSERT INTO cwe_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Iviya mwizalava bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, na nhambiko ija ya kuilumba hamwe na nhambiko ya kutimbula ya chila siku na nhosa yake ya usage na nhosa zake za ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Muna isiku ya longo na tano ya mwezi wesaba mwizakuwa na mting'hano wa kutosa kwa Mulungu, sekemusang'hane usang'hano, mwizamtendela dugila Mndewa Mulungu kwa siku saba. ");
INSERT INTO cwe_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Mwizalava nhambiko ya kutimbula kwa moto ili na mnung'ho unogile wa kumnogeza Mndewa Mulungu, madang'ang'a malume longo na matatu na mabebelu ya ng'hondolo maidi na wanang'hondolo longo na wane weli na mwaka umwe, wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Hamwe na nhosa zake na usage unogile wouhanganyigwe na mavuta, chilo nhatu kwa chila dang'ang'a lume na chilo mbili kwa chila ng'hondolo ");
INSERT INTO cwe_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na chilo imwe kwa chila mwanang'hondolo ");
INSERT INTO cwe_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","na bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, hamwe na nhambiko ya kutimbula kwa moto ya chila siku, hamwe na nhosa yake ya usage na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Siku yekaidi mwizalava madang'ang'a longo na maidi na mabebelu ya ng'hondolo maidi na wanang'hondolo walume longo na wane weli na mwaka umwe welibule chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Iviya mwizalava nhosa ya usage na nhosa ya ving'waji hamwe na yaja madang'ang'a malume na ng'hondolo na wanang'hondolo fana viili peta yawo, fana viya viilagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Iviya mwizalava bebelu da luti kuwa nhambiko ya uhasanyi, hamwe na nhambiko ija ya kutimbula kwa moto, hamwe na nhosa yake ya usage na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Muna isiku yetatu mwizalava madang'ang'a malume longo na dimwe na ng'hondolo waidi na wanang'hondolo longo na wane weli na mwaka umwe, welibule chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Iviya mwizalava nhosa ya usage na nhosa ya ching'waji, hamwe na madang'ang'a malume na bebelu da ng'hondolo na wanang'hondolo walume kuilinga na peta yawo, fana voilagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Iviya mwizalava bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, hamwe na nhambiko ija ya kutimbula na nhosa yake ya usage na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Muna isiku yekane mwizalava madang'ang'a malume longo na mabebelu ya ng'hondolo maidi na wanang'hondolo longo na wane weli na mwaka umwe welibule chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Iviya mwizalava nhosa ya usage na nhosa ya ching'waji, hamwe na madang'ang'a malume yayo na ng'hondolo na wanang'hondolo kuilinga na peta yawo, fana voilagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Iviya mwizalava bebelu da luti kuwa nhambiko ya uhasanyi hamwe na nhambiko ya kutimbula, hamwe na nhosa yake ya usage na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Muna isiku yetano mwizalava madang'ang'a malume kenda na ng'hondolo waidi na mabebelu ya ng'hondolo longo na mane yeli na mwaka umwe, wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Iviya mwizalava nhosa ya usage na nhosa ya ching'waji, hamwe na madang'ang'a malume na ng'hondolo na wanang'hondolo kuilinga na peta yawo, fana voilagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Iviya mwizalava bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, hamwe na nhambiko ya kutimbula na nhosa yake ya usage na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Muna isiku yesita mwizalava madang'ang'a malume manane na ng'hondolo waidi na wanang'hondolo walume longo na wane weli na mwaka umwe, wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Iviya mwizalava nhosa ya usage na nhosa ya ching'waji, hamwe na madang'ang'a malume na bebelu da ng'hondolo na wanang'hondolo walume kuilinga na peta yawo, fana voilagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Iviya mwizalava bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, hamwe na nhambiko ya kutimbula na nhosa yake ya usage na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Muna isiku yesaba mwizalava madang'ang'a malume saba na mabebelu ya ng'hondolo maidi na wanang'hondolo walume longo na wane weli na mwaka umwe, wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Iviya mwizalava nhosa ya usage na nhosa ya ching'waji, hamwe na madang'ang'a malume na bebelu da ng'ondolo na wanang'hondolo kuilinga na peta yawo, fana voilagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Iviya mwizalava bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, hamwe na nhambiko ya kutimbula na nhosa yake ya usage na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Muna isiku yenane mwizakuwa na mting'hano wa kutosa kwa Mulungu, sekemutende usang'hano wowose. ");
INSERT INTO cwe_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mbali mwizalava nhambiko ya kutimbula iyolaviligwa Mndewa Mulungu kwa moto ili na mnung'ho unogile wa kumnogeza Mulungu, dang'ang'a lume na bebelu da ng'hondolo na wanang'hondolo walume saba weli na mwaka umwe, wose sekewawe na chilema. ");
INSERT INTO cwe_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Iviya mwizalava nhosa ya usage na nhosa ya ching'waji, hamwe na dang'ang'a lume ijo na bebelu da ng'hondolo ijo na wanang'hondolo wawo kuilinga na peta ya wanyama, fana voilagilizigwe. ");
INSERT INTO cwe_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Iviya mwizalava bebelu da luti kwa ichimu cha nhambiko ya uhasanyi, hamwe na nhambiko ya kutimbula na nhosa yake ya usage na nhosa yake ya ching'waji. ");
INSERT INTO cwe_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Nhambiko zino mwizamulavila Mndewa Mulungu muna yamadugila yenu yapangigwe, hamwe na vilaho venu na nhambiko zenu za kulonda wenyewo, kuwa nhambiko zenu za kutimbula na nhosa zenu za usage na nhosa zenu za ching'waji na nhambiko zenu za tindiwalo.” ");
INSERT INTO cwe_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Ivo Musa kawalongela Waisilaili chila chinhu chiyalagilizigwe na Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Maabaho Musa kawalongela walangulizi wa makabila ya Isilaili, “Chino icho chayalagilize Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Munhu yahamwikila chilaho Mndewa Mulungu hebu vondayailahe muladi kuifunga yeye mwenyewo kwa chilagano, kolondeka sekeyagalule mbuli yake, kezatenda viya viyalongile kwa mulomo wake. ");
INSERT INTO cwe_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Mndele yeli yang'hali kokala muna ikaye ya tati yake yahamulahila Mndewa Mulungu hebu kuifunga mwenyewo kwa chilagano, ");
INSERT INTO cwe_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","tati yake yahahulika chilaho hebu chilagano chiya na halonga chochose, mndele ija kezafungigwa na chilaho na chilagano choyachitendile. ");
INSERT INTO cwe_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","“Mbali one tati yake komgomesa lusita voyohulika voyokwika chilagano icho, hezafungigwa na chilaho. Mndewa Mulungu kezamulekelela kwaviya tati yake kamgomesa. ");
INSERT INTO cwe_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Ihawa mndele yahasoligwa yahamala kwika chilagano hebu kaifunga kwa chilaho chake bila kugesa ");
INSERT INTO cwe_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","na mulumake yahahulika mbuli iyo na hamgomesa, imuke kezafungigwa na chilaho chake chiyekile. ");
INSERT INTO cwe_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mbali one mulumake yahamgomesa siku iyo iyahulike, baho mulume iyo kezasegeza chilagano icho cha imuke na chilaho chiya chiyailahile bila kugesa. Mndewa Mulungu kezamulekelela. ");
INSERT INTO cwe_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Mbali chilaho hebu chilagano chochose chikigwe na mgane hebu muke yasigwe, kezafungigwa na chilaho chake. ");
INSERT INTO cwe_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","One muke yasoligwe yahailaha hebu yaheka chilagano yahawa ukaye kwa mulumake, ");
INSERT INTO cwe_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","na mulumake yahahulika mbuli iyo na hamgomese hebu kumulongela chinhu chochose, baho vilaho na vilagano vake vose vizamfunga. ");
INSERT INTO cwe_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mbali one mulumake yahamgomesa viyohulika mbuli zake, muke iyo halondeka kuchifikiza chilaho chake. Mndewa Mulungu kezamulekelela muke iyo kwaviya mulumake kamgomesa kufikiza chilagano chake. ");
INSERT INTO cwe_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Mulumake kodaha kutogola hebu kusegeza chila chilaho hebu chilagano chochimfunga muke iyo. ");
INSERT INTO cwe_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mbali one mulumake yahamnyamalila siku ija viyahulike, baho kezakuwa katogola vilaho vake vose na vilagano vake vose, mana mulumake viyahulike kanyamala. ");
INSERT INTO cwe_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mbali yahazilema na kuzisegeza yahamala kuhulika, baho mulume iyo kezasola ubananzi wa muke wake.” ");
INSERT INTO cwe_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Zino izo ndagilizi Mndewa Mulungu zoyamulagilize Musa kusonhela mulume na muke wake, na kusonhela tata na mndele wake, mndele wake yahawa muna ikaye ya tati yake. ");
INSERT INTO cwe_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Uwalihilizile Wamidiani kwa chiya chowawatendele Waisilaili, maabaho weye kwizadanganika.” ");
INSERT INTO cwe_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ivo Musa kawalongela wanhu, “Wasasaleni walume kwa ng'hondo, wahite wakawatowe Wamidiani muladi kuwalihilizila kwa ichimu cha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Kulawa chila kabila da Isilaili molondeka muwagale walume magana longo kuna ing'hondo.” ");
INSERT INTO cwe_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Walavigwa mwa Waisilaili maelufu, walume magana longo chila kabila, walume wowasasaligwe kuitowa kuna ing'hondo wakala 12,000. ");
INSERT INTO cwe_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa kawagala kuna ing'hondo walume magana longo chila kabila, hamwe na Finehasi mwana wa mkulu wa nhambiko Eleazali, na via va hanhu helile. Muna yamakono yake kamha mhalati za kusinhusa. ");
INSERT INTO cwe_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Waitowa isi ya Midiani, fana viya Mndewa Mulungu viyamulagilize Musa, wawakoma walume wose. ");
INSERT INTO cwe_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mwa wanhu wose wowakomigwe kukala na wafalume watano, nawo ni Evi na Lekemu na Suli na Huli na Leba. Iviya wamkoma kwa panga Balaamu mwana wa Beoli. ");
INSERT INTO cwe_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Waisilaili wawasola mateka wanaake wa Midiani na wana wawo na ng'ombe wawo wose na ng'hondolo wawo wose na vinhu vawo vose wavisola. ");
INSERT INTO cwe_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Mabululu yawo yose na kaye zawo na malago yawo yose visomigwa kwa moto. ");
INSERT INTO cwe_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Wasola vinhu vose viwahokile na via vose viwapatile kuna ing'hondo, wanhu na wanyama. ");
INSERT INTO cwe_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Na wawagala wanaake na vinhu viwavihokile haulongozi wa Musa na mkulu wa nhambiko Eleazali na mting'hano wa Waisilaili, hana yamalago hana izisi zili muna dibawe da Moabu habehi na lwanda lwa Yoludani uli malola na bululu da Yeliko. ");
INSERT INTO cwe_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa na mkulu wa nhambiko Eleazali na walangulizi wose wa mting'hano, walawa kunze ya lago na wahita kuwahokela. ");
INSERT INTO cwe_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa kehilwa na walangulizi wa watowang'hondo na wakalizi wa maelufu na wakalizi wa magana wowabwelile kulawa kuna ing'hondo. ");
INSERT INTO cwe_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa kawauza, “Habali muwaleka wanaake wano wasigale wagima? ");
INSERT INTO cwe_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Loleni, waanake wano wawo wayasondelele magesa ya Balaamu na kuwatendeza Waisilaili wamuhasanye Mndewa Mulungu kuja Peoli. Lekamana tamu diwezila wanhu wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Lelo wakomeni wana wose wa chilume na chila muke yoyabandamigwe na mulume, ");
INSERT INTO cwe_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","mbali wanaake waja weli hawanaibandama na mulume, wasigale wagima kwa ichimu chenu. ");
INSERT INTO cwe_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Yoyose yakomile munhu hebu kudalisa mtufi wa munhu yakomigwe kolondeka yakale kunze ya lago kwa siku saba. Muna isiku yetatu na siku yesaba molondeka mwiisafye mweye wenyewo na mateka wenu. ");
INSERT INTO cwe_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Iviya molondeka mudisafye chila walo na chila chinhu chochitendigwe kwa mbende hebu kwa mazoya ya luti hebu kwa mbiki.” ");
INSERT INTO cwe_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Mkulu wa nhambiko Eleazali kawalongela walume wowabwelile kulawa kuna ing'hondo, “Yano ni malagilizo Mndewa Mulungu yoyamulagilize Musa, ");
INSERT INTO cwe_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","zahabu na hela na shaba na chuma na bati na madini ya mbwewe, ");
INSERT INTO cwe_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","na chila chinhu chochidaha kwima muumoto, mwizachifoseza muna umoto, nacho chizakuwa chela. Hamwe na yano chizasafyigwa kwa mazi ya kusafya, na chila hachidaha kwima muumoto mwizachifoseza muna yamazi. ");
INSERT INTO cwe_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Muna isiku yesaba mwizafuwa mawalo yenu, baho mwizakuwa mwela na modaha kwingila muna dilago.” ");
INSERT INTO cwe_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Weye na mkulu wa nhambiko Eleazali, hamwe na walangulizi wa ng'holo za Waisilaili, peteni vinhu vovihokigwe kuna ing'hondo na wanhu na wanyama. ");
INSERT INTO cwe_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Goleni vinhu ivo muna yamabugulu maidi, bugulu dimwe da wowahitile kuna ing'hondo na bugulu dimwenga da mting'hano wose. ");
INSERT INTO cwe_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Maabaho muna dibugulu da walume walawile kuna ing'hondo, bagula mchango kwa ichimu cha Mndewa Mulungu. Chinhu chimwe kulawa muna ichila vinhu magana matano, iwe wanhu hebu ng'ombe hebu chihongwe hebu ng'hondolo hebu luti, ");
INSERT INTO cwe_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","umwing'he mkulu wa nhambiko Eleazali kuwa mchango kwa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kulawa muna dibugulu da mting'hano wose, sola hanhu hamwe ha chila malongo matano, iwe ng'ombe hebu chihongwe hebu ng'hondolo hebu luti. Ivo kwizaweng'ha Walawi wowosang'hana muna dihema da Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Musa na mkulu wa nhambiko Eleazali watenda fana viya Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Vinhu viwahokile watowang'hondo kuna ing'hondo vikala ng'hondolo 675,000 ");
INSERT INTO cwe_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","na ng'ombe wakala 72,000 ");
INSERT INTO cwe_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","na vihongwe wakala 61,000 ");
INSERT INTO cwe_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","na wanaake hawaibandame na walume wakala 32,000. ");
INSERT INTO cwe_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nusu yake, hanhu howagoleligwe wowahitile kuna ing'hondo wakala ng'hondolo 337,500 ");
INSERT INTO cwe_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","na ng'hondolo 675 walavigwa kwa ichimu cha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ng'ombe wa wakalizi wakala 36,000, mwa iwawo, ng'ombe malongo saba na waidi walavigwa kwa ichimu cha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Vihongwe wakala 30,500, mwa iwawo, malongo sita na imwe wawalava kwa ichimu cha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Wanhu wakala 16,000, mwa iwawo, wanhu malongo matatu na waidi wawalava kwa ichimu cha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Ivo Musa kamwing'ha mkulu wa nhambiko Eleazali vinhu vovilavigwe kuwa mchango kwa Mndewa Mulungu, fana viya Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Nusu yoweng'higwe Waisilaili ija yoyaibagule Musa na nusu ija yoweng'higwe wakalizi wowahitile kuna ing'hondo, ");
INSERT INTO cwe_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","nusu ya mting'hano wa Waisilaili ikala ng'hondolo 337,500 ");
INSERT INTO cwe_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","na ng'ombe wakala 36,000 ");
INSERT INTO cwe_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","na vihongwe wakala 30,500 ");
INSERT INTO cwe_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","na wanhu wakala 16,000 ");
INSERT INTO cwe_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kulawa muna inusu iyo yoweng'higwe Waisilaili, Musa kasola imwe chila muna yamalongo matano ya wanhu na wanyama, fana viyalagilizigwe na Mndewa Mulungu, kaweng'ha Walawi wowasang'hane muna dihema da Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Maabaho wakulu wa mabumbila wowakalile walangulizi wa maelufu na walangulizi wa magana wahita kwa Musa ");
INSERT INTO cwe_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","na wamulongela, “Cheye wasang'hani wako chiwapeta wakalizi wose wochiwalongoza, chiwona kuwa habule hata imwe yahunguke. ");
INSERT INTO cwe_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ivo chigala vinhu kwa Mndewa Mulungu, chiyapatile chila munhu, via va zahabu na viguku na bangili na mhete za chilaguso na vipuli na usalu. Chivilava fana maliho kwa ugima wetu haulongozi wa Mndewa Mulungu.” ");
INSERT INTO cwe_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa na mkulu wa nhambiko Eleazali wahokela vinhu vose vovihambigwe kwa zahabu. ");
INSERT INTO cwe_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Zahabu yose yowamulavile Mndewa Mulungu ikala chilo magana maidi. ");
INSERT INTO cwe_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Mbali chila mkalizi kasola vinhu kwa ichimu chake mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Ivo Musa na mkulu wa nhambiko Eleazali wahokela zahabu kulawa kwa wakulu wa wakalizi na waigala muna dihema da Mulungu, muladi iwe lukumbuso lwa Waisilaili haulongozi ha Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Makabila ya Lubeni na Gadi wakala na wanyama wengi ng'hani, viwawonile kuwa isi ya Yazeli na isi ya Gileadi zofaya kwa wanyama, ");
INSERT INTO cwe_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","wahita kwa Musa na mkulu wa nhambiko Eleazali na walangulizi wa mting'hano. Wawalongela, ");
INSERT INTO cwe_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Mabululu ya Atalosi na Diboni na Yazeli na Nimula na Heshiboni na Eleale na Sebamu na Nebo na Beoni, ");
INSERT INTO cwe_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","isi ija Mndewa Mulungu kaihuma kwa ichimu cha Waisilaili, ni isi inogile kwa wanyama, cheye china wanyama wengi ng'hani. ");
INSERT INTO cwe_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","One muhachitogolela chomulambani muching'he isi ino iwe yetu, sekemuchilose kuumwambu wa lwanda Yoludani.” ");
INSERT INTO cwe_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa kawalongela makabila ya Gadi na Lubeni, “Vino molonda kukala hano lusita ndugu zenu Waisilaili wohita kuna ing'hondo? ");
INSERT INTO cwe_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Habali mowabena moyo Waisilaili sekewahite kuna iisi ija yoyaweng'hile Mndewa Mulungu? ");
INSERT INTO cwe_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Vino niivo viwatendile tati zenu lusita viniwatumile kulawa Kadeshi Balinea muladi wahite kuilola isi iyo. ");
INSERT INTO cwe_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Kwaviya vowahitile kuna dibawe da Eshikoli, waiwona isi, viwabwelile wawabena umoyo Waisilaili muladi sekewahite kuna iisi iyaweng'hile Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Siku iyo Mndewa Mulungu kapata ludoko, kailaha na kalonga, ");
INSERT INTO cwe_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Noilaha kuwa habule hata mulume imwe mwa walume waja walawile Misili, kwandusila yeli na miyaka malongo maidi na kugendelela, yondayaiwone isi iyo yoniwalahile Bulahimu na Isaka na Yakobo, kwaviya hawanitegeleze. ");
INSERT INTO cwe_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Habule hata imwe yondayaiwone, ila Kalebu mwana wa Yefune, Mkenizi, na Yoshua mwana wa Nuni, mana wawo wamtegeleza Mndewa Mulungu.’ ");
INSERT INTO cwe_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Mndewa Mulungu kawawonela ludoko Waisilaili, kawatenda wawegele mchuwala kwa miyaka malongo mane, mbaka nyelesi zose zozitendile wihi haulongozi wa Mndewa Mulungu, wadanganika. ");
INSERT INTO cwe_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Lola, mweye welesi wa wanhu weli na uhasanyi, mwinuka badala ya tati zenu muladi kumongezela Mndewa Mulungu ludoko kwa Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","One muhalema kumsondelela, kezamulekani kaidi kuchuwala na mwizawatenda wanhu wano wose wadanganike.” ");
INSERT INTO cwe_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Maabaho wamkwenhukila habehi na walonga, “Chizazenga mabumba kwa ichimu cha wanyama wetu na chizazenga mabululu kwa ichimu cha wanetu. ");
INSERT INTO cwe_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Mbali cheye wenyewo chizasola silaha zetu chihite kuna ing'hondo hamwe na ndugu zetu Waisilaili, cheye chizakuwa kuulongozi kuna ing'hondo mbaka chiwafikize hanhu hondawakale. Chipindi icho wanetu wezakala kuna yamabululu yeli na mhongono, muladi kuikaliza na wakaya wa isi iyo. ");
INSERT INTO cwe_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Hachizabwela muna zikaye zetu mbaka Waisilaili wose wapate uhazi wawo. ");
INSERT INTO cwe_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Hachizahazi hanhu hohose hamwe nawo kuumwambu wa lwanda lwa Yoludani, kwaviya cheye chipata hanhu hetu ubanzi wa ulawilo wa zua wa Yoludani.” ");
INSERT INTO cwe_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Musa kawalongela, “One kweli muhatenda fana viya vimulongile, basi bahano haulongozi wa Mndewa Mulungu muisasale kuitowa kuna ing'hondo, ");
INSERT INTO cwe_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","na chila mulume wa kumwenu yondayasole silaha kezaloka ulwanda lwa Yoludani kwa ulangulizi wa Mndewa Mulungu, mbaka vondayawasegeze wehi wake ");
INSERT INTO cwe_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","na kuisola isi ija. Yahamala yayo modaha kubwela, kwaviya mwizakuwa mukomeleza kutenda yoyamulagilizeni Mndewa Mulungu na Waisilaili wayenu. Isi ino izakuwa yenu haulongozi wa Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Mbali one mwahapotwa kutenda ivo, mwizakuwa na uhasanyi kwa Mndewa Mulungu, muvimanye kuwa mwizatagusigwa kwa uhasanyi wenu. ");
INSERT INTO cwe_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Ivo wazengeleni mabululu wanenu na mabumba ya wanyama wenu, mbali tendeni fana vimwikile chilagano!” ");
INSERT INTO cwe_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Makabila ya Gadi na Lubeni wamulongela Musa, “Cheye wasang'hani wako chizatenda fana weye mwenevale wetu vouchilagiliza. ");
INSERT INTO cwe_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Wake zetu na wanetu na ng'ombe wetu na ng'hondolo wetu, wezasigala hano hana yamabululu ya Gileadi. ");
INSERT INTO cwe_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Mbali cheye wasang'hani wako chiisasala kuitowa kuna ing'hondo kwa ulangulizi wa Mndewa Mulungu. Chizaloka lwanda lwa Yoludani na kuitowa, fana viulongile.” ");
INSERT INTO cwe_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Ivo Musa kawalagiliza mkulu wa nhambiko Eleazali na Yoshua mwana wa Nuni na walangulizi wa ng'holo za makabila ya Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Musa kawalongela, “One makabila ya Gadi na Lubeni wahaloka lwanda lwa Yoludani hamwe na mweye kuno waisasala kwa ng'hondo kwa ulangulizi wa Mndewa Mulungu, isi ihahumigwa, basi muweng'he isi ya Gileadi iwe yawo. ");
INSERT INTO cwe_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Mbali one hawaloka lwanda lwa Yoludani na kuitowa kuna ing'hondo hamwe na mweye, wezahokela uhazi wawo muna isi ya Kanaani hamwe na mweye.” ");
INSERT INTO cwe_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Makabila ya Gadi na Lubeni wamwidika, “Wasang'hani wako chizatenda fana viyalongile Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Kwa kulangulizigwa na Mndewa Mulungu, chizaloka muna iisi ya Kanaani na kuitowa kuna ing'hondo, muladi chidahe kusola uhazi wetu uko ubanzi wa ulawilo wa zua wa Yoludani.” ");
INSERT INTO cwe_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Basi Musa kaweng'ha wanhu wa makabila ya Gadi na Lubeni na nusu ya kabila da Manase mwana wa Yosefu, isi yose ya mfalume Sihoni wa Waamoli, isi ya mfalume Ogu wa Bashani hamwe na mabululu na isi izunguluke mabululu yayo. ");
INSERT INTO cwe_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Kabila da Gadi wazenga mabululu ya Diboni na Atalosi na Aloeli ");
INSERT INTO cwe_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","na Atilosi Shofani na Yazeli na Yogibeha ");
INSERT INTO cwe_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","na Besi Nimila na Besi Halani, mabululu yeli na mhongono na vikwama va ng'hondolo. ");
INSERT INTO cwe_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Kabila da Lubeni wazenga mabululu ya Heshiboni na Eleale na Kiliasaimu ");
INSERT INTO cwe_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","na Nebo na Baali Meoni na Sibima, mazina ya mabululu yayo yagalusigwa. Mabululu yowazengile wayeng'ha mazina yamwenga. ");
INSERT INTO cwe_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Welesi wa Makili mwana wa Manase wahita mbaka Gileadi, waitowa isi iyo na kuiteka na kuwawinga Waamoli wowakalile umo. ");
INSERT INTO cwe_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Ivo Musa kaweng'ha wanhu wa welesi wa Makili mwana wa Manase isi ya Gileadi, nawo wakala umo. ");
INSERT INTO cwe_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Maabaho Yaili mwana wa Manase, kahita na kuvisola vibululu vimwenga va Gileadi, kaving'ha zina, Hawosi Yaili. ");
INSERT INTO cwe_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba kaisola isi ya Kenasi na vibululu vake, kaitanga Noba dili zina jake mwenyewo. ");
INSERT INTO cwe_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ino niiyo miyanza ya Waisilaili viwalawile muna iisi ya Misili kwa mabumbila yawo kwa kulangulizigwa na Musa na Haluni. ");
INSERT INTO cwe_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Musa kandika zina da chila hanhu howekile lago, lago mbaka lago, kwa lagilizo da Mndewa Mulungu. ");
INSERT INTO cwe_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Waisilaili wasegela muna dibululu da Lamasesi kwa ugalu ng'hani haulongozi wa Wamisili, siku ya longo na tano ya mwezi wa mwanduso, siku dimwe vidimalile Dugila da Pasaka. ");
INSERT INTO cwe_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Uko Wamisili wakala wowawanda wana wawo wa udele wose wa chilume woyawakomile Mndewa Mulungu na Mndewa Mulungu katagusa mbaka milungu yawo. ");
INSERT INTO cwe_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Waisilaili wasegela Lamesesi na weka lago jawo uko Sukosi. ");
INSERT INTO cwe_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Kulawa Sukosi weka lago jawo uko Esamu, mumgwazo wa chuwala. ");
INSERT INTO cwe_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Wasegela Esamu na wabwela Pihahilosi, ili ubanzi wa ulawilo wa zua wa Baali Sefoni, weka lago jawo kuulongozi wa Migidoli. ");
INSERT INTO cwe_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Wasegela Pihahilosi, wafosela hagati ya Bahali ya Shamu na kwingila muna ichuwala, wagenda siku nhatu muna ichuwala cha Esamu, weka lago jawo uko Mala. ");
INSERT INTO cwe_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Wasegela Mala na wahita Elimu, uko Elimu kukala na nzasa za mazi longo na mbili na mitende malongo saba, weka lago jawo uko. ");
INSERT INTO cwe_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Wasegela Elimu na weka lago jawo habehi na Bahali ya Shamu. ");
INSERT INTO cwe_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Wasegela habehi na Bahali ya Shamu na weka lago jawo kuna ichuwala cha Sini. ");
INSERT INTO cwe_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Wasegela muna ichuwala cha Sini na weka lago jawo uko Dofuka. ");
INSERT INTO cwe_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Wasegela Dofuka na weka lago jawo uko Alushi. ");
INSERT INTO cwe_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Wasegela Alushi na weka lago jawo uko Lefidimu, uko kukala kwabule mazi ya kung'wa. ");
INSERT INTO cwe_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Wasegela Lefidimu na weka lago jawo muna ichuwala cha Sinai. ");
INSERT INTO cwe_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Wasegela muna ichuwala cha Sinai na weka lago jawo uko Kibilosi Hataava. ");
INSERT INTO cwe_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Wasegela Kibilosi Hataava na weka lago jawo uko Haselosi. ");
INSERT INTO cwe_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Wasegela Haselosi na weka lago jawo uko Lisima. ");
INSERT INTO cwe_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Wasegela Lisima na weka lago jawo uko Limoni Pelezi, ");
INSERT INTO cwe_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Wasegela Limoni Pelezi na weka lago jawo uko Libina. ");
INSERT INTO cwe_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Wasegela Libina na weka lago jawo uko Lisa. ");
INSERT INTO cwe_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Wasegela Lisa na weka lago jawo uko Kehelasa. ");
INSERT INTO cwe_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Wasegela Kehelasa na weka lago jawo kuna mulima wa Shefeli. ");
INSERT INTO cwe_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Wasegela kuna mulima wa Shefeli na weka lago jawo uko Halada. ");
INSERT INTO cwe_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Wasegela Halada na weka lago jawo uko Makelosi. ");
INSERT INTO cwe_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Wasegela Makelosi na weka lago jawo uko Tahasi. ");
INSERT INTO cwe_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Wasegela Tahasi na weka lago jawo uko Tela. ");
INSERT INTO cwe_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Wasegela Tela na weka lago jawo uko Mitika. ");
INSERT INTO cwe_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Wasegela Mitika na weka lago jawo uko Hashimona. ");
INSERT INTO cwe_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Wasegela Hashimona na weka lago jawo uko Moselosi. ");
INSERT INTO cwe_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Wasegela Moselosi na weka lago jawo uko Bene Yaakani. ");
INSERT INTO cwe_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Wasegela Bene Yaakani na weka lago jawo uko Holi Hagidigadi. ");
INSERT INTO cwe_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Wasegela Holi Hagidigadi na weka lago jawo uko Yotibasa. ");
INSERT INTO cwe_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Wasegela Yotibasa na weka lago jawo uko Abilona. ");
INSERT INTO cwe_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Wasegela Abilona na weka lago jawo uko Esioni Gebeli. ");
INSERT INTO cwe_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Wasegela Esioni Gebeli na weka lago jawo uko Kadeshi, kuna ichuwala cha Sini. ");
INSERT INTO cwe_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Wasegela Kadeshi na weka lago jawo kuna mulima wa Holi, muna imhaka ya isi ya Edomu. ");
INSERT INTO cwe_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Mkulu wa nhambiko Haluni kakwela kuna mulima wa Holi kwa ndagilizi ya Mndewa Mulungu, uko kadanganika muna isiku ya mwanduso ya mwezi wetano, muna umwaka wa malongo mane, kwandusila Waisilaili viwalawile Misili. ");
INSERT INTO cwe_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Haluni viyadanganike kuna mulima wa Holi kakala na miyaka 123. ");
INSERT INTO cwe_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Mkanaani, mfalume wa Aladi yoyakalile ubanzi wa kusi wa isi ya Kanaani, kahulika kuwa Waisilaili wokwiza. ");
INSERT INTO cwe_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Waisilaili wasegela kuna umulima wa Holi na weka lago jawo uko Salimona. ");
INSERT INTO cwe_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Wasegela Salimona na weka lago jawo uko Punoni. ");
INSERT INTO cwe_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Wasegela Punoni na weka lago jawo uko Obosi. ");
INSERT INTO cwe_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Wasegela Obosi na weka lago jawo uko Iye Abalimu, muna imhaka ya Moabu. ");
INSERT INTO cwe_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Wasegela Iye Abalimu na weka lago jawo uko Diboni Gadi. ");
INSERT INTO cwe_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Wasegela Diboni Gadi na weka lago jawo uko Alimoni Dibilasaimu. ");
INSERT INTO cwe_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Wasegela Alimoni Dibilasaimu na weka lago jawo kuna imilima ya Abalimu, habehi na mulima wa Nebo. ");
INSERT INTO cwe_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Wasegela kuna imilima ya Abalimu na weka lago jawo kuna yamabawe ya Moabu habehi na lwanda lwa Yoludani uli malola na bululu da Yeliko. ");
INSERT INTO cwe_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Kuja kuna yamabawe ya Moabu weka lago jawo mumgwazo wa lwanda lwa Yoludani, kwandusila Besi Yeshimosi mbaka Abeli Shitimu. ");
INSERT INTO cwe_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Mndewa Mulungu kamulongela Musa kuna dibawe da Moabu habehi na lwanda lwa Yoludani uli malola na bululu da Yeliko, ");
INSERT INTO cwe_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Walongele Waisilaili, ‘Vondamuloke ulwanda lwa Yoludani kuhita kuna iisi ya Kanaani, ");
INSERT INTO cwe_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","molondeka kuwawinga wakaya wose wa isi iyo kumwenu. Mwizazinanga nyang'hiti zawo zose za mabwe na za chuma cha kuhonda na kuhabomola chila hanhu hawo ha kutambikila. ");
INSERT INTO cwe_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mwizaisola isi iyo iwe yenu na kukala umo, kwaviya niye nimwing'hani iwe yenu. ");
INSERT INTO cwe_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mwizaigola isi iyo kwa mhiya kuilinga na kaye zenu, kabila kulu wapate hanhu hakulu na kabila dodo wapate hanhu hadodo. ");
INSERT INTO cwe_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Mbali one hamuwawingile wakaya wa isi iyo, waja wondawasigale wezakuwa fana mabale muna yameso yenu hebu miwa chila ubanzi na wezamgazani. ");
INSERT INTO cwe_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Maabaho nizamtendelani fana vonigesile kuwatendela wawo.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Walagilize Waisilaili na uwalongele, ‘Vondamwingile muna iisi ya Kanaani, isi ino izakuwa uhazi wenu, mhaka za hanhu baho zizakuwa fana vino. ");
INSERT INTO cwe_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Ubanzi wa kusi mhaka yenu izakuwa kulawa chuwala cha Sini kufosela ubanzi wa Edomu. Izakwandusila ulawilo wa zuwa ubanzi wa kusi kuuhelelo wa Bahali ya Munyu. ");
INSERT INTO cwe_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Maabaho izafosela kusi kuhita ubanzi wa Akilabimu na kufosela Sini mbaka Kadeshi Balinea, ubanzi wa kusi. Kulawa uko, mhaka izafosela Hasali Adali na kufosa mbaka Azimoni. ");
INSERT INTO cwe_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Kulawa Azimoni mhaka izafosela kuna ichizanda cha Misili na izahelela muna Ibahali ya Meditelaniya. ");
INSERT INTO cwe_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“ ‘Mhaka yenu ya ubanzi wa uswelo wa zua izakuwa Bahali ya Meditelaniya. ");
INSERT INTO cwe_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“ ‘Mhaka yenu ya ubanzi wa kasikazi izakuwa fana vino, kulawa Bahali ya Meditelaniya, mwizatula mkuza mbaka kuna umulima wa Holi, ");
INSERT INTO cwe_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","na kulawa mulima wa Holi mwizatula mkuza mbaka Hamasi. Maabaho mhaka izahita mbaka uko Sedadi, ");
INSERT INTO cwe_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","na izagendelela mbaka Zifiloni na kuhelela uko Hazali Enani. Iyo izakuwa mhaka yenu ya ubanzi wa kasikazi. ");
INSERT INTO cwe_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“ ‘Mhaka yenu ya ubanzi wa ulawilo wa zua mwizatula mkuza kwandusila Hazali Enani mbaka Shefamu. ");
INSERT INTO cwe_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Mhaka izalawa Shefamu kuhita Libila, ubanzi wa ulawilo wa zua wa Aini, maabaho izagendelela na kufika ubanzi wa lamba da Galilaya. ");
INSERT INTO cwe_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Maabaho mhaka izafosela lwanda lwa Yoludani na kulawilila kuna Ibahali ya Munyu. Iyo izakuwa isi yenu fana mhaka viili.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Maabaho Musa kawalagiliza Waisilaili, kalonga, “Ino niiyo isi yondamuihazi kwa kutowa mhiya, isi ija Mndewa Mulungu iyalagilize weng'higwe makabila kenda na nusu. ");
INSERT INTO cwe_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Kwaviya ng'holo za kabila da Lubeni na kabila da Gadi na nusu ya kabila da Manase wapata uhazi wawo kuilinga na ng'holo zawo. ");
INSERT INTO cwe_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Makabila yano maidi na nusu yahokela uhazi wawo kwandusila kuumwambu wa lwanda lwa Yoludani, habehi na Yeliko, ubanzi wa ulawilo wa zua.” ");
INSERT INTO cwe_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Mkulu wa nhambiko Eleazali na Yoshua mwana wa Nuni, niiwawo wondawawagolele wanhu isi kuwa yawo. ");
INSERT INTO cwe_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Sagula mulangulizi imwe kulawa chila kabila muladi wakutaze kuigola isi. ");
INSERT INTO cwe_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Yano ni mazina ya walume. Kulawa kabila da Yuda kakala Kalebu mwana wa Yefune. ");
INSERT INTO cwe_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Kulawa kabila da Simeoni kakala Shemueli mwana wa Amihudi. ");
INSERT INTO cwe_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Kulawa kabila da Benjamini kakala Elidadi mwana wa Kisiloni. ");
INSERT INTO cwe_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Kulawa kabila da Dani kakala Buki mwana wa Yogili. ");
INSERT INTO cwe_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Kulawa kabila da Manase mwana wa Yosefu kakala Hanieli mwana wa Efodi. ");
INSERT INTO cwe_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kulawa kabila da Efulaimu mwana wa Yosefu kakala Kemueli mwana wa Shifitani. ");
INSERT INTO cwe_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Kulawa kabila da Zabuloni kakala Elisafani mwana wa Palinaki. ");
INSERT INTO cwe_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Kulawa kabila da Isakali kakala Palitieli mwana wa Azani. ");
INSERT INTO cwe_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Kulawa kabila da Asheli kakala Ahihudi mwana wa Shelomi. ");
INSERT INTO cwe_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Kulawa kabila da Nafutali kakala Pedaheli mwana wa Amihudi.” ");
INSERT INTO cwe_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Wano niiwawo wanhu waja Mndewa Mulungu woyawalagilize wawagolele Waisilaili uhazi muna iisi ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Mndewa Mulungu kamulongela Musa kuna dibawe da Moabu habehi na lwanda lwa Yoludani uli malola na bululu da Yeliko, kamulongela, ");
INSERT INTO cwe_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Walagilize Waisilaili waweng'he Walawi hanhu ha kukala kulawa muna uuhazi wawo. Na waweng'he hanhu ha kudimila wanyama wawo, habehi na yamabululu. ");
INSERT INTO cwe_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Mabululu yayo yezakuwa yawo, nawo wezakala umo na hanhu ha kudimila wanyama hezakuwa kwa ichimu cha ng'ombe na wanyama wawo wamwenga. ");
INSERT INTO cwe_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Hanhu ha kudimila hondamuweng'he Walawi mumgwazo ya mabululu, hezawoneka chila ubanzi utali wa mita 450 kulawa kuna zimhongono za mabululu yayo. ");
INSERT INTO cwe_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Ivo hanhu baho ha kudimila hezakuwa mita 900 na hezakwenela chila ubanzi, bululu ijo dizakuwa hagati. Hanhu baho hezakuwa hanhu ha kudimila mumgwazo ya mabululu yawo. ");
INSERT INTO cwe_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Mabululu yondamuweng'he Walawi yezakuwa sita ya kukimbilila, yondamuyeke kwa ichimu cha munhu yondayamkome miyage bila kuilunga, muladi yakimbilile uko. Iviya mwizaweng'ha mabululu yamwenga malongo mane na maidi. ");
INSERT INTO cwe_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Mabululu yose yondamuweng'he Walawi ni malongo mane na manane, hamwe na hanhu ha kudimila. ");
INSERT INTO cwe_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Peta ya mabululu yondamuweng'he Walawi muna uhazi wa Waisilaili izasondelela ukulu wa kabila, kabila kulu dizalava mabululu mengi na kabila dodo dizalava mabululu madodo.” ");
INSERT INTO cwe_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Mndewa Mulungu kamulongela Musa, ");
INSERT INTO cwe_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Walongele Waisilaili, ‘Vondamuloke lwanda lwa Yoludani na kwingila muna iisi ya Kanaani, ");
INSERT INTO cwe_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Saguleni mabululu yondayawe mabululu yenu ya kukimbilil. Munhu yahamkoma miyage bila ya kuilunga kodaha kukimbilila uko. ");
INSERT INTO cwe_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Mabululu yayo yezakuwa hanhu ha tindiwalo, muladi mkomaji sekeyakomigwe na munhu yolihiliza ing'hali hanahumizigwa hana iwanhu wose. ");
INSERT INTO cwe_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Mwizasagula mabululu yano sita, nayo yezakuwa mabululu yenu ya kukimbilila. ");
INSERT INTO cwe_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Mwizaweng'ha mabululu matatu kuumwambu wa lwanda lwa Yoludani, mwizaweng'ha mabululu matatu muna iisi ya Kanaani. ");
INSERT INTO cwe_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Mabululu yano yezakuwa ya kukimbilila kwa ichimu cha Waisilaili na nyambenyambe wokala hamwe nawo kwa lusita ludodo. Munhu yoyose yahamkoma miyage bila kuilunga, kodaha kukimbilila uko. ");
INSERT INTO cwe_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Mbali one munhu yahamtowa miyage na chuma na kadanganika, munhu iyo ni mkomaji na kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Munhu yoyose yahamtowa miyage na dibwe, yahadanganika, munhu iyo ni mkomaji na kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","One munhu yahamtowa miyage na lugodi loludaha kumtenda yadanganike, kadanganika, munhu iyo ni mkomaji na kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Ndugu wa habehi wa munhu yoyakomigwe kezalihiliza. Yahamting'hana imkomaji, kezamkoma. ");
INSERT INTO cwe_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","One munhu komwihila miyage, maabaho komsung'ha hebu komwasila chinhu kwa kumsepa, ");
INSERT INTO cwe_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","hebu kwa kumtowa ng'honde na kudanganika, baho munhu iyo yamkomile miyage ni mkomaji na kolondeka yakomigwe. Ndugu wa habehi wa munhu yoyakomigwe kolondeka kulihiliza vondayaiting'hane nayo. ");
INSERT INTO cwe_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Mbali one munhu kamsung'ha kwa kumsinhusa bila kumwihila hebu kamwasila chinhu bila kuilunga, ");
INSERT INTO cwe_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","hebu munhu yahamwasila dibwe dodidaha kumtenda munhu yadanganike na kumkoma, ingawa hakalile mwihi wake hebu halondile kumulumiza, ");
INSERT INTO cwe_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","baho wakaya wa bululu ijo wezahumiza hagati ya munhu yakomile na ndugu wa habehi yoyakalile wa kulihiliza kwa munhu ija yoyakomigwe kwa vodili lagilizo. ");
INSERT INTO cwe_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Wakaya wa bululu wezamkaliza munhu yakomile muladi sekeyakomigwe na ndugu wa munhu yoyakomigwe. Wezambweleza kuna dibululu da kukimbilila koyakimbilile. Kezakala uko mbaka vondayadanganike mkulu wa nhambiko digogogo yoyabobodigwe mavuta yelile. ");
INSERT INTO cwe_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Mbali one munhu yakomile yahalawa kunze ya bululu diyakimbilile lusita luja, ");
INSERT INTO cwe_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","maabaho one ndugu wa habehi wa munhu yoyakomigwe yahamfika kunze ya mhaka ya bululu ijo da kukimbilila na kumkoma, iyo hezakuwa na ubananzi wa kukoma. ");
INSERT INTO cwe_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Kwaviya munhu yakomile kolondeka yakale mgati ya dibululu da kukimbilila mbaka mkulu wa nhambiko digogogo vondayadanganike, ihamala ifa ya mkulu wa nhambiko digogogo, kodaha kubwela ukaye. ");
INSERT INTO cwe_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Malagilizo yano na ndagilizi vizazindililigwa muna uwelesi wenu, hanhu hohose hamukala. ");
INSERT INTO cwe_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Munhu yoyose yomkoma munhu kezatagusigwa ifa kwa usindila wa wanhu waidi hebu kufosa baho. Munhu yoyose hadaha kutagusigwa ifa kwa usindila wa munhu imwe. ");
INSERT INTO cwe_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Sekemuhokele maliho yoyose kwa kugombela ugima wa mkomaji yeli na ubananzi wa kukoma, munhu iyo kolondeka yakomigwe. ");
INSERT INTO cwe_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Sekemuhokele maliho yoyose kulawa kwa munhu yoyakimbilile muna dibululu da kukimbilila muladi kumulekela yabwele ukaye yake yang'hali mkulu wa nhambiko digogogo hanadanganika. ");
INSERT INTO cwe_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","One mwahatenda ivo, mwizaitenda isi yomukala yambule mwiko. Ukomaji wizaitenda isi iyo yambule mwiko, habule nhambiko yoidaha kuisafya isi iyakomigwe munhu, mbali kwa kumkoma mkomaji iyo. ");
INSERT INTO cwe_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Sekemuitende isi yomukala yambule mwiko, isi yonikala niye, kwaviya niye Mndewa Mulungu nokala hagati yenu Waisilaili.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Walangulizi wa lukolo lwa Gileadi mwana wa Makili, mwana wa Manase mwana wa Yosefu, wakwenhuka habehi na kulonga haulongozi wa Musa na walangulizi wamwenga wa Waisilaili. ");
INSERT INTO cwe_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Wamulongela, “Mndewa Mulungu kamulagiliza mwenevale wangu uweng'he Waisilaili uhazi wawo wa isi kwa kutowa mhiya, iviya kalagilizigwa na Mndewa Mulungu yaweng'he wandele wa Selofehadi ndugu yetu uhazi wa tati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Mbali one wahasoligwa na wanhu wa makabila yamwenga ya Isilaili, uhazi wawo wizalawa kumwetu na kuhita kwa wanhu wa kabila diwosoligwa, ivo uhazi wetu wizahunguka. ");
INSERT INTO cwe_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Mwaka wa kukomboligwa wa Waisilaili vondaufike, uhazi wawo wizakongezigwa muna dikabila dowosoliligwa, ivo kabila jetu hadizapata uhazi uwo.” ");
INSERT INTO cwe_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Musa kawalagiliza Waisilaili fana Mndewa Mulungu viyalongile, “Wanhu wa kabila da Yosefu walonga ukweli. ");
INSERT INTO cwe_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Vino niivo viyolagiliza Mndewa Mulungu kusonhela wandele wa Selofehadi, ‘Wodaha kusoligwa na mulume yoyose iwomulonda, mbali wasoligwe muna dikabila jawo. ");
INSERT INTO cwe_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Habule uhazi wa Isilaili wondaulawe kulawa kabila dimwenga, chila Muisilaili kezakwamha uhazi wa kabila jake. ");
INSERT INTO cwe_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Mndele yoyose yeli na uhazi wa isi muna dikabila da Isilaili, kolondeka yasoligwe na munhu wa kabila jake, muladi chila Muisilaili yasole uhazi wa tati zake. ");
INSERT INTO cwe_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ivo hakwizakuwa na uhazi wowose wondauhamizigwe kulawa kabila dimwe kuhita kabila dimwenga, mana chila kabila da Isilaili dizakwamha uhazi wake.’ ” ");
INSERT INTO cwe_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Wandele wa Selofehadi watenda fana viya Mndewa Mulungu viyamulagilize Musa. ");
INSERT INTO cwe_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mala na Tiliza na Hogila na Milika na Nuhu, wandele wa Selofehadi, wasoligwa na wana wa ndugu za tati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Wasoligwa muna dikabila da Manase mwana wa Yosefu na uhazi wawo usigala muna dikabila da tati yawo. ");
INSERT INTO cwe_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Zino ni ndagilizi na malagilizo Mndewa Mulungu yoyaweng'hile Waisilaili kufosela Musa muna dibawe da Moabu habehi na lwanda lwa Yoludani uli malola na bululu da Yeliko.");
INSERT INTO cwe_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Chitabu chino cholonga mbuli ziya Musa ziyawalongele wanhu wa Isilaili viwakalile kuchuwala ubanzi wa ulawilo wa zuwa wa lwanda lwa Yoludani. Wakala kuna dikolongo da Yoludani habehi na Sufu, hagati ya bululu da Palani ubanzi umwe na mabululu ya Tofeli na Labani na Haselosi na Dizahabu, ubanzi umwenga. ");
INSERT INTO cwe_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Kulawa mulima lwa Holebu mbaka Kadeshi Balinea ni ugenzi wa siku longo na imwe kwa nzila ya Seili. ");
INSERT INTO cwe_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Siku ya mwanduso ya mwezi wa longo na imwe, mwaka wa malongo mane viwalawile Misili, Musa kawalongela Waisilaili mbuli zose ziyalagilizigwe na Mndewa Mulungu yawalongele. ");
INSERT INTO cwe_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Katenda ivo viyakomeleze kuwahuma mfalume Sihoni wa Waamoli yakalile kuna dibululu da Heshiboni na mfalume Ogu wa Bashani yakalile kuna yamabululu ya Ashitaloti na Edilei. ");
INSERT INTO cwe_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Kuumwambu wa lwanda lwa Yoludani, kuna iisi ya Moabu, Musa kawalongela wanhu malagilizo yano. Kalonga, ");
INSERT INTO cwe_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Vichikalile kumulima wa Holebu, Mndewa Mulungu, Mulungu wetu kachilongela, ‘Mukala va kufaya hana umulima uno. ");
INSERT INTO cwe_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Lelo hindukeni mugendelele na mwanza, hiteni kuna iisi ya milima ya Waamoli na kolongo da Yoludani, kuna imilima na mabawe, uko ubanzi wa kusi na mhwani. Hiteni kuna iisi ya Kanaani na Lebanoni mbaka kuna ulwanda ulukulu lwa Efulati. ");
INSERT INTO cwe_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Isi ino yose niye Mndewa Mulungu niilaha kuwa nizaweng'ha wasaho zenu, Bulahimu na Isaka na Yakobo na nyelesi zawo. Hiteni mukaisole.’ ” ");
INSERT INTO cwe_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Musa kawalongela wanhu, “Vichikalile kuna umulima wa Sinai, nimulongelani, ‘Sidaha kumulangulizani niye niidumwe. ");
INSERT INTO cwe_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Mndewa Mulungu, Mulungu wenu kamtendani muwe wengi, diyelo muwa wengi fana nhondo za kuulanga. ");
INSERT INTO cwe_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Mndewa Mulungu, Mulungu wa wasaho zenu yamtendeni muwe wengi miyanza elufu kufosa vimwili sambi na kumtemelani mate fana viyalongile! ");
INSERT INTO cwe_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Lelo niye niidumwe niz